(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1751459,      31416]*)
(*NotebookOutlinePosition[   1775791,      31945]*)
(*  CellTagsIndexPosition[   1775063,      31919]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\

 Double-click the graphic to play a sound. Click again anywhere to cancel.
\
\>", "GroupDivider",
  CellTags->{
  "ChitteringWarble", "ElectronicChimes", "G.3.1", "G.3.2", "G.3.3", "G.3.4", 
    "G.3.5", "G.3.6", "G.3.7", "G.3.8", "G.3.9", "HarmonicWow", 
    "LogisticMap", "Major Scale", "RiemannZeta", "SimpleSound", "SineChime", 
    "TouchTones", "G.3.10", "MusicalSounds"}],

Cell["Simple Sound", "Subsection",
  CellTags->{"SimpleSound", "G.3.1"}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.0238095 0.952381 0.0147151 0.588604 [

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

% Start of sampled sound

1 string

11025 22601 8

{ currentfile 1 index readhexstring pop }

 false 1 sampledsound

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7E7E7E7E7E7E7E7E7E7E7E7E7D7D7D7D7C7C7C7C7B7B7B7B7B7B7C7C7C7D7D7D7E7E7F7F8080

8080808080807F7F7E7D7D7C7B7B7A79797978787979797A7A7B7C7D7E7F8081828383838383

83838281807F7D7C7B797877767575757575767678797A7C7E80818384868787888888878684

83817F7D7B78767473717070707071727375787A7D7F828587898B8C8D8D8D8C8B898785827F

7B787572706D6C6A6A6A6B6C6E7073767A7E8285898C8F919393949392908D8A86827E797571

6D6A676563636365676A6D71767B80858A8E9296989A9B9B999794918C87817C76706B66625F

5D5C5B5C5F62666B70767C83898F959A9EA0A2A3A2A09D99948E878079726B645F5A57545354

55585D626970777F878F969DA2A6A9ABABAAA7A29D968E867D756C645D56514D4B4B4C4E5358

5F67707A838D969EA5ABB0B3B4B3B1ADA7A0978E847A6F655C544D4844424244484E555E6772

7D88939DA7AFB5BABCBDBBB8B2ABA2988D8175695E544B433E3A393A3D4249525D6975828E9B

A6B0B9BFC4C6C6C3BEB7AEA3978A7C6F62554A403933303032363D46515D6B798896A3B0BAC3

C9CDCFCECAC3BAAFA395867768594C40362E2927272B313944515F6F7F8F9EADBAC5CDD4D7D7

D5CFC7BDB0A1918170605042362C24201E20252D37445262748596A7B6C4CFD8DDE0DFDBD4CA

BDAF9E8D7A685746382B211B17171A202A364455677A8D9FB1C0CED9E1E6E7E5E0D7CBBDAC9A

8773604D3C2D2118120F10151D283647596D8195A8BACAD8E3EAEEEEEAE3D8CBBBA894806B57

443224180F0A090B111B28384B5E73899EB2C4D4E2EBF2F4F3EEE5D8C9B7A38E78624D3A291A

0F07030408101B2A3C50657B91A7BBCEDEEAF3F8F9F6F0E5D7C6B29D866F5944312012070100

0006101D2E41566C849AB0C5D7E6F2F9FDFDF8F0E3D3C1AC957E67503B28170A010000000611

2032475D758CA4B9CEDFEDF8FEFFFEF8EEE0CFBBA58D755E473220100400000000081525384E

657D95ACC2D5E6F3FCFFFFFEF6EADBC8B39C856C553F2A190A00000000000B1A2B40566E869E

B5CADCECF7FFFFFFFCF3E6D5C1AB947C644C372413060000000004102033485F778FA6BCD0E2

F0FAFFFFFFF9EEDFCDB9A38B735B45301E0F04000000000917273B51687F97AEC3D6E6F2FBFF

FFFBF3E7D8C5B09A826B543E2B1A0D0300000005101E30445A71889FB5C8DAE8F3FAFDFBF6EC

DFCFBCA7917A634D3927180C040000040C1827394D637990A6BACCDCE9F2F7F8F6EFE4D6C6B3

9E88725C483524170D0704060B14213143566C8197ABBECFDDE8EFF3F2EEE7DBCDBCA995806B

5643322418100B0A0D141E2B3A4C6074889DB0C1D0DCE5EBEDEBE6DDD1C3B2A08C7865524031

241B141112161D27354456687B8FA1B2C2CFD9E1E5E5E3DCD3C7B9A9978572604F3F32271F1A

181A1F27323F4E5F708294A5B4C2CDD5DBDEDDD9D2C9BDAF9F8F7E6D5C4D3F342B2521212429

313C495767778897A6B4C0C9D0D4D5D3CFC8BEB3A5978878695A4D4138302B292A2E343C4653

606E7D8C9AA7B2BCC4C9CCCCC9C5BDB4A99D8F817366594E443C37333334383E46505C687582

8F9BA6B0B8BEC1C3C2BFBAB3AAA095897C70655A5048423E3C3C3E42495059646F7A85909BA4

ACB2B6B9BAB8B5B0A9A1988E83796E655C544E49464546484D525A626B747E889199A1A7ACAF

B0B0AEABA6A09990887F766E665F5954514F4E5052565C62697179818990979CA1A5A7A7A7A5

A19D97918A837C756E68625E5A585757595C5F64696F757C82898E93989B9D9E9F9E9C999590

8B86807A756F6B6764616060606264676B6F74797E83878C8F92959697969593918E8A86827E

7975726E6C6A686768686A6C6E7174787B7F8286898B8D8E8F8F8F8E8C8A8885827F7C797774

72716F6F6E6F6F71727476787B7D7F8183858687888888888786858381807E7C7A7977767675

757575767677787A7B7C7D7F808181828283838382828180807F7E7D7C7C7B7B7A7A7A7A7A7A

7A7B7B7C7C7D7D7D7E7E7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D7D7D7D7D7E7E7E7E7E7E7E7E7E

7E7E7D7D7D7C7C7C7B7B7B7A7A7A7A7B7B7B7C7C7D7D7E7F7F808081818181818180807F7E7E

7D7C7B7A7A79797878787878797A7A7B7C7D7E7F8081828283838383828281807F7E7D7C7B7A

79787877777777777878797A7B7C7E7F808182828383838383838281807F7E7D7C7B7A797877

777777777778797A7B7C7D7E7F808182828383838382828180807F7E7D7C7B7A797978787878

7879797A7B7C7C7D7E7F7F808081818181818080807F7E7E7D7D7C7C7B7B7B7A7A7A7B7B7B7B

7C7C7D7D7D7E7E7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D7D7D7D7D7E7E7E7E7E7E7E7E7E7E7E7D

7D7D7C7C7B7B7B7A7A7A7A7A7A7A7B7B7C7D7E7E7F8081818282838383828281807F7E7D7B7A

7978777675757575757677787A7B7D7F8182848587888888888887868482807E7C7977757371

706F6F6F6F70727376787B7E818486898B8D8E8F8F8E8D8C8A8784817D7A7673706D6B696868

68696B6D7074787C8084888C8F92949596969593908D8985807B77726D696663616060616366

696D72787D83888E92969A9C9E9E9D9C9995908B857F79726C67625E5B5958585A5D61666B72

7980878E949A9FA2A5A6A6A5A29E99938C847D756D665F5A555250505153575D636A727B848C

949CA2A8ACAEAFAEACA8A39C948C827970675E57514C484747494D5259616A747E88929CA4AB

B1B5B7B8B6B3ADA69E958A7F74695F564E47423F3E3F42474E57606B77838E9AA4ADB5BBBFC0

C0BDB9B2A99F94887B6F62574D443D383635383C434B55616E7B8895A2ADB7BFC5C8C9C8C4BD

B5AB9F928476685A4E433A332F2D2E31373F49556371808F9DABB7C1C9CED1D1CEC9C1B7AB9D

8E7F6F60524539302A2625272B333D495766768696A6B4C0CAD2D7D9D8D4CDC4B8AA9A8A7968

58493B3027211E1E2127303C4A596A7C8D9FAFBDCAD4DBDFE0DED8D0C4B7A7968472604F3F32

271E1917181D252F3D4C5E708395A7B8C6D3DCE3E6E6E2DBD1C4B4A3917E6A584636291E1612

11141A24303F5063768A9EB0C1CFDBE4EAECEAE5DCD0C2B19E8A76624F3D2D20160F0C0D1119

24324355697D92A6B9C9D8E3EBEFF0EDE6DCCEBEAC98836E5A46352519100A080A1019263647

5B70859AAEC1D1DFE9F0F3F2EEE5DACBB9A6917C66513E2D1E130B060609111C2A3A4D62788D

A2B6C9D8E5EEF4F5F3EDE3D6C6B39F8A745E4A3726180E0704050A131F2F41546A8095AABECF

DEEAF2F6F6F2EADFD1C0AC97826C56423020140B0504060D172435485C72879DB2C4D5E2EDF3

F6F5EFE6DACBB9A58F7A644F3C2B1C1109050509111C2B3C4F647A8FA4B8CAD9E5EEF3F4F1EB

E1D3C3B19D87725D49362719100A07090E17233244576C8196ABBDCEDCE6EEF1F1EDE5DACCBB

A8947F6B5643322418100C0B0D141E2B3B4C6074899DB0C1D0DDE6EBEDECE7DED2C3B2A08C78

64513F302319120F10141B26334355687C8FA2B4C4D1DCE3E8E8E5DFD6C9BAAA9784715F4D3D

2F241B1615161B242F3D4C5E708395A6B7C5D1DADFE2E2DED6CDC0B1A18F7D6C5A4A3C30261F

1C1B1E242D38465566778999A9B8C4CED6DADBDAD5CDC3B6A89988776757493C322A25232327

2E37424F5E6D7D8D9DABB7C2CAD0D3D3D1CBC3B9AD9F9182726456493E362F2C2B2D3138414C

58667483919EABB6BEC5C9CBCAC7C1B9AFA4978A7C6F61554B423B363434363B424B55616D7A

87939FA9B2B9BEC1C2C0BDB7AFA69B9084786C61574E47413E3D3E40454C545E68737E89949E

A6AEB3B7B9B8B6B2ADA59D948A7F756B6259524D494746484B50565D666F78828B949BA2A8AC

AEAFAEACA8A39C958D847C736B645D58545150505255595F656C747C848B92989DA1A4A5A6A4

A29E9A948E878079736C67625E5B5A595A5C5F63676C72787E848A8F93979A9B9C9C9B989591

8D88837E78746F6B68656363636465686B6E72777B8084888B8E9092939392918F8D8A878380

7C797573706E6D6C6B6C6D6E707275777A7D8082858788898A8A8A8A8987868482807E7C7A78

7776757474747475767778797B7C7D7F8081818282828282828181807F7E7E7D7D7C7C7B7B7B

7B7B7C7C7C7C7D7D7D7D7D7D7D7D7C7C7C7C7B7B7B7B7B7B7B7C7C7D7D7E7F80808182828283

83828281807F7E7D7C7A797877767575757575767778797B7D7E808284858687888888888786

8483817E7C7A7875747271706F6F7070727476787B7D808385888A8B8C8D8D8D8C8B89868481

7E7B7875726F6D6C6B6B6B6C6D6F7275787B7F8285898B8E8F919191908F8D8A8784807D7975

726F6C6A68686868696B6E7174787C8084888B8E919293949392908E8B87837F7B77736F6C69

6766656667686B6E7175797E82868A8E90939495959493918E8A86827E7975716D6A68666565

6567696B6F72777B7F84888C8F92949595959492908D8985817C7874706C696766656566686A

6D7074787D8185898C8F929394949492908E8B87837F7B77736F6C6A68676767686A6C6F7376

7A7E8286898C8F9092929291908E8B8885817D7A7673706D6C6A6A696A6B6D6F7275787C7F82

86888B8D8E8F8F8F8E8C8A8885827F7C79767472706E6E6D6E6E6F717375787A7D8082848688

898A8A8A8A8988868482807E7C7A787674737372727373747577787A7C7E7F81828384858585

8584848382817F7E7D7C7B7A79797878787879797A7A7B7C7C7D7D7E7E7F7F7F7F7F7F7F7E7E

7E7D7D7D7D7D7D7D7D7E7E7E7F7F7F7F7F7F7F7F7E7E7D7C7C7B7A797978787878787879797A

7C7D7E7F81828384858686868685848382807E7C7A78767473727170707071727476787B7D80

8386888A8C8D8E8E8E8D8B8A8784817E7A7773706E6B6A686868696B6D7073777B7F83878B8F

92949696969594918E8A86817C77726E6A666361605F606265686C71777C82888D92969A9D9E

9F9E9D9A96928C86807A736D67625E5A585757595B5F646A70777F868D949A9FA3A6A7A7A6A4

A09B948D867E766E665F5A55514F4E4F52555B61697179828B939BA2A8ACAFB0B0ADAAA49E96

8D847B71685F57514C484646484B51575F68727C87919AA3ABB1B5B8B8B7B4AFA8A0968C8176

6B61574F48433F3E3F41464D555F6975818C98A2ACB3BABEC0C0BDB9B3AAA1958A7D7165594F

463F3A3736383C424A54606C7986939FAAB4BCC2C6C7C6C3BDB5ABA09386786B5D51473E3732

30303338404955626F7E8C9AA7B2BCC4CACDCECCC7C0B6AB9E9081726456493E352F2B292B2F

363F4A5765748392A1AFBAC4CCD1D3D3CFC9C1B6A99B8C7C6C5D4E42372E282524272C343F4B

5A69798999A8B6C2CCD3D7D8D6D2CAC0B4A69786766555473A3028222021252B35414E5E6E7F

90A0B0BDC9D2D8DBDBD9D3CABFB1A292806F5E4E40342A221E1D1F242C37445363748697A7B6

C4CED7DCDEDDD9D2C8BBAD9D8C7A6858483A2E251F1B1B1F252E3A4858697A8C9DAEBCC9D3DA

DEDFDDD8D0C4B7A8978573625142352A221C1A1C2028323F4D5E6F8193A4B3C1CDD6DCDFDFDC

D5CCC0B2A2917F6D5C4C3D3127201C1B1D232B37445364768799A9B8C5D0D8DDDEDDD9D1C7BA

AB9B8A786756473A2E25201D1D2127313D4B5A6B7C8D9EAEBCC8D1D8DBDCD9D4CBC1B3A49483

72625244372D26212021262D37435261718293A3B1BEC8D1D6D8D8D4CEC5BAAC9D8E7D6D5D4F

42362E282424272C343E4B5968788897A6B3BFC8CFD3D4D2CEC7BDB2A5968778685A4D413730

2B292A2D333C4653606F7E8C9BA8B4BEC6CBCECECBC6BFB5AA9D8F817365584C423A34302F31

353B444E5A677583909DA9B3BBC2C6C7C7C3BEB6ADA296897C6F62574D443E393737393E444D

57626E7A87939EA8B0B7BCBFC0BEBBB5ADA49A8F84786C62584F4843403E3F42474D555F6973

7E89949DA6ADB2B6B7B7B5B1ACA59C93897F756B625A534D4A4747494C50565E666F78828B93

9BA2A7ABAEAFAEABA8A29C958D847C736B645D585451505152555A5F666D747C848B92989DA1

A4A5A5A4A29E99948E878079736D67625E5C5A5A5A5C5F63686D72787E848A8F9397999B9C9B

9A9895918D88837E79746F6B68666463636466686B6F73777B8084878B8D8F91929291908E8C

898683807C797673716F6E6D6D6D6E6F717375787A7D7F82848587888888888887868483817F

7E7C7B79787777777777777878797A7B7C7D7D7E7E7F7F7F7F7F7F7F7E7E7E7D7D7D7D7D7D7D

7E7E7F7F7F8080808080807F7F7E7D7C7B7A7978777776767676767778797A7C7E7F81838586

878889898988878684827F7D7A787573716F6E6D6D6D6E6F717376797C7F8386898B8E8F9091

91908F8C8A87837F7B7774706D6A6866656566686A6D7074797D82878B8F9295979898989694

918D88837E79746F6A6663605F5E5F6063666A6F747A80868B9095999C9E9F9F9E9B98948E89

837C76706A64605C5A5858595B5F63686E757C838A90969B9FA2A4A5A4A29F9A958F88817972

6B655F5A5754535355585C62686F777E868E959BA0A4A7A9A9A8A5A19B958E867E766E67605A

5552504F5053565C62697179828A9299A0A5A9ABADACAAA6A19B948C847B726A625B56514E4D

4D4E51565C636B737C858E969DA4A9ACAEAFAEABA6A19A928A81786F665F58524E4C4B4B4E52

575D656D7680899199A0A6ABAEB0AFAEAAA59F988F877E746B635C55504D4B4A4C4F53596068

717A838C949CA3A8ACAFAFAFACA8A39C958C837A7169615A54504D4B4C4E51565C636B747D86

8F979EA4A8ACAEAEACA9A59F99918980776F675F5954504E4D4E51555A60676F78808991989E

A4A8AAABABA9A6A19B948D857D756D655F59555251515255595E646C737B838A92989EA2A5A7

A8A7A4A19C969089827A736C65605B58565555575A5E636970777E858B92979C9FA1A3A3A19F

9B97918B857F78726C66625E5C5A5A5B5D6064696E747A80868B9095989B9C9D9D9B9995918C

87827C77726D6965636160616264666A6E72777C81868A8E91949596969694928F8B88837F7B

77736F6D6A68686768696B6D7073767A7E8185888A8C8E8F8F8F8E8D8B898683807D7B787573

71706F6F6F6F70727375787A7C7E8082848586878787878685848381807E7D7B7A7978777777

77777778797A7A7B7C7D7E7E7F7F7F7F7F7F7F7F7E7E7E7E7D7D7D7D7D7D7E7E7E7F7F7F7F7F

7F7F7F7F7E7E7D7C7B7A79797877777777777778797A7C7D7F80828385868787888887868584

82807E7C7977757371706F6E6E6F70717375787B7E8184878A8C8E8F9090908F8D8A8884817D

7975726E6B696766666667696C6F73777C8085898D9194969898989795928F8A86807B76716C

6764615F5E5E5F6164686C72777D83898F94989C9FA0A0A09E9B96918C857F78716B65605C59

575656585B60656B727980878F959BA0A4A6A8A8A6A39F9A938C847C746C655E5954514F4F50

53575C636A737B848C949CA2A8ABAEAFAEABA7A29B948B827970675F58524D4A48494B4F545B

626B757E88929BA2A9AFB2B4B4B3AFAAA49C93897F756B6158514B46444344474C525A636D78

828D97A1A9B0B5B8BAB9B7B2ACA49B91867B70655B524B45413F3E40444A525B65707C87929D

A7AFB5BABDBEBCB9B3ACA3998E82776B60554D45403C3B3B3E434A535D6874808C98A2ACB4BA

BEC1C1BEBAB3ABA1968A7E72665B5048413C39383A3E444C55606C7885919DA7B0B8BEC1C3C2

BEB9B2A99E93867A6D61564C443D3937373A3F454E5864707D8995A1ABB4BBC0C3C3C1BDB7AF

A59A8E8275685D5249413C3837383B4148525C6874818E9AA5AEB6BDC1C3C2C0BBB4ABA1968A

7D7164594F47403B39383A3E454D56616D7986929DA7B0B7BDC0C1C0BCB7AFA69C9185796D61

574D46403C3B3B3E4349525B66727E89959FA9B1B7BBBEBEBCB8B2AAA1978C8075695F554D47

423F3E3F43484F57616B76828D97A1A9B0B5B8BAB9B6B2ACA49B91877C71675E554E49454343

45494E555D67717B858F98A1A8ADB2B4B4B3B0ABA59E958C82796F665E57514C4A49494C5055

5C646C757E8790989FA5AAADAEAEACA9A49E978F877F766E665F59555250505153575D636A71

79818990979CA1A4A6A7A6A4A19C97918A837C756E68625E5A585757595C5F64696F767C8389

8F94989B9E9F9F9E9C9995908B85807A746F6B676361605F606264676B7074797E83888C8F92

949696969593908D8A86827D7975726F6C6A696869696B6D6F7275787C7F8285888A8B8C8D8D

8D8C8A888684817F7C7A787674737272727273747576787A7B7D7F8081828383848483838282

81807F7E7D7D7C7C7B7B7B7B7B7B7C7C7C7D7D7D7D7D7D7D7C7C7C7B7B7A7A7A79797A7A7B7B

7C7D7E7F808283848485858585858483817F7E7C7A78767473717070707071737476797B7E81

8486898B8D8E8F8F8F8D8C8A8784807D7975726F6C6A68676667686A6C7073777C8085898D91

94969898989795928E8A85807B75706B6763605E5D5D5E6063676C72787E848A9095999DA0A1

A2A19F9B97928C857F78716A645F5A57555455575A5E646A7179818890979DA2A6A9AAAAA8A5

A09B948C847C736B635C56524E4C4C4D50555B626A727B858E969EA5ABAFB1B2B1AEAAA49D95

8C82786E655C544E49464545474B5158616A757F8A949DA6ADB3B7B9B9B7B3AEA69E948A7E73

685E554D46413F3E3F43484F58616C78848F9AA4ADB5BABEBFBEBCB7B0A79D92867A6E62574E

453F3B38393B3F464E58636F7C8995A1ABB4BBC1C4C4C3BFB9B0A79B8F8275685C51473F3935

3435383E454F5A6673818E9BA7B2BAC1C6C8C8C5C0B9B0A5988B7E7062564B41393431303237

3D46515D6A788694A1ADB7C0C6CACBCAC6C0B8ADA29487786A5D50453C35302E2F32373F4954

616F7D8C99A6B2BCC4C9CCCDCAC6BFB5AA9E90827365584B4138322E2D2E3239424C58667483

919FABB6BFC6CBCDCCC9C4BCB2A6998B7C6E6053473E36312E2E30353C45515D6B798896A3AF

B9C2C8CBCCCBC7C0B7ADA1938577695C4F453C35312F303339404A5663707F8D9AA6B2BBC2C7

CACAC7C3BBB2A79B8E807265584D433B36323133373D46505C687683919DA9B3BBC1C5C7C6C3

BDB6ACA195887B6E61564C433C383535383D434C56626E7B8894A0AAB3BABFC2C3C1BDB7AFA6

9B8F83776B5F554C443F3B3A3B3E434A535D68737F8B96A1AAB2B7BBBDBDBBB6B0A89F958A7E

73685E554D4743404041454A515A636E78838E98A1A8AFB3B6B7B6B4AFA9A1988F857B70675E

56504B484647494D52596169737C868F989FA6ABAEB0B0AFACA7A19A928A81786F675F595450

4E4D4E51555A60676F777F888F969CA1A5A8A9A8A7A39F9A938C857D766F68625D5957555557

595D62676D747B81888E94989C9FA0A1A09E9B97928D87817B756F6A6662605E5D5E5F626569

6E73787D82878C909396989898979593908C88837E7A76726E6B6967666667686A6D7073777B

7E8286898B8D8F9090908F8D8B898683807D7A777573716F6F6E6F6F70727476787A7C7F8183

8486878787878786858483817F7E7C7B7A797877777777777878797A7B7C7C7D7E7E7F7F7F7F

7F7F7F7F7E7E7E7D7D7D7D7D7D7D7E7E7E7F7F7F7F7F7F7F7F7F7E7D7D7C7B7A797978787777

77777879797B7C7D7F80828384858687878786868483817F7D7B797775737271707070707173

7477797C7E818487898B8C8D8E8E8D8C8B888683807C797673706D6B6A6969696A6C6F727579

7D8184888C8F919394949493918E8B88837F7B76726E6A67656363636466696C7074797E8388

8D919497999A9A999795918D88837D78736E6965625F5E5E5E6063666A6F757B81868C919699

9C9E9F9E9D9A97928D88827B756F6964605D5B5A5A5B5D61656A70767D838A90959A9EA0A2A2

A19F9C98938D867F79726B65605C59575657595C60656B71787F878D94999EA1A4A5A5A3A09C

98928B847D766F68625D5956555556585C60666D747B828990979CA0A4A6A6A5A3A09C969089

827A736C65605B5755545456595D62686F767E858C93999EA2A5A6A6A5A29F9A948D867F7870

69635E5A57555455575B5F656B727980878E959A9FA2A4A5A5A3A09C97918A837C756E68625E

5A575656575A5E62686E757C838990959A9EA1A2A3A2A09D98938E87817A736D67635F5C5A59

595B5E62666C71787E848A9095999C9E9F9F9E9C98948F8A847E78726D6864615F5D5D5E6063

666B70757A80858A8F9396999A9B9A9996938F8B86817C77726E6A67656362636465686B6F73

787D8185898D90929495959493908E8A87837F7B7773706D6B6A6969696A6C6E7174777A7E81

84878A8C8D8E8E8E8D8C8A888583807D7B78767472717070707071737476787A7C7E80828485

868687878686858482817F7E7D7B7A797978787778787879797A7B7C7C7D7E7E7E7F7F7F7F7E

7E7E7E7D7D7D7D7D7D7D7D7E7E7F7F80808080808080807F7F7E7D7C7B7A7877777676757576

7677787A7B7D7F8183848687888989898988868583807E7B787673716F6E6D6C6C6D6E707275

787B7E8285898C8E9092939392918F8C8985817D7874706C69666463636364676A6D72777C81

868B9094979A9C9C9C9B9895918C86817A746E6964605C5A59595A5D60656A70777E858C9298

9DA1A4A6A6A5A39F9A948E867F776F68615B5652504F5052565B61687079818A929AA1A7ABAE

B0AFADAAA59E978E857C72696058514C484646474B50565E67717B86909AA3AAB1B5B8B9B8B5

B0A9A1988D82776C61584F48423E3D3D40454B535D6874808C97A2ACB4BABFC1C1BFBBB5ACA2

978B7F7265594F453E383534363A4048525D6A7785929FABB5BDC4C8CAC9C6C0B8AEA2958879

6B5E51463C352F2D2D30353C46525F6D7C8B99A7B3BEC7CDD0D1CFCBC3BAAEA1928373645648

3D332C2726272B313B465362728292A1B0BCC7CFD5D7D7D4CEC5BAAD9E8E7D6D5D4D40342B24

20202227303A475666778899A9B8C5CFD7DCDDDCD7D0C5B9AA9A8977665545382C231D1B1B1F

262F3C4A5A6C7E90A1B1C0CCD6DDE1E2DFD9D0C4B6A69582705E4D3E30251D1817181D26313E

4E5F728497A9B9C7D3DCE2E5E4E0D9CEC1B2A18F7C695746362A1F181414171E273442536578

8B9EB0C0CED9E1E6E7E5E0D7CBBDAD9B887562503F30241B151213181F2A3848596C7F93A5B6

C6D3DDE4E8E8E4DED4C7B8A794816E5B49392B20181312141A232F3D4E60738699ACBCCBD7E0

E5E8E7E2DACFC1B2A08D7A67544334271E171313171E28354455677A8DA0B1C1CED9E1E5E6E4

DED5C9BBAB998673614F3F31251D1715161B232E3B4B5C6E8193A5B6C4D0DAE0E3E3DFD9CFC2

B4A3917F6D5B4A3B2F251D19191B212A35435263758799AAB9C6D1D9DEE0DEDAD2C7BBAC9B8A

796756473A2E26201D1D2128313D4B5A6B7C8D9EADBBC7D0D6DADBD8D3CABFB3A49483736253

45392F28242224282F39455362728292A1AFBBC6CDD2D5D4D1CBC2B7AA9C8D7D6E5F51453A32

2C29292B3038424E5B69788796A3B0BAC3C9CDCECDC9C2B9AEA29586786A5D50453D36313030

3339414B5662707D8B98A4AFB8BFC4C6C7C4C0B9B0A69A8E8174675B5148403B3837393C424A

535E6976828E99A4ADB4BABDBFBEBBB6B0A79E93887C71665C534B4542404042464C535C6570

7A859099A2A9AFB4B6B7B5B2ADA79F968D83796F665D56504C4948494B4F555B636C757E8790

989FA5A9ACAEAEACA9A49E978F877F766E67605A565351515254585D636A717981888F969B9F

A3A5A5A5A3A09B96908A837C756F69645F5C5A59595B5D61656A70767C82888D9296999B9D9D

9C9A97938F8A85807A75706C6865636262626466696C7075797E83878B8E919394949493918F

8C8985817D7A7673706D6C6A6A6A6A6C6E707275797C7F828587898B8C8C8D8C8B8A88868481

7F7C7A78767473727171727273747677797B7D7F80828384858585858584838281807F7E7C7B

7A7A79797878787979797A7B7B7C7D7D7E7E7E7F7F7F7F7F7E7E7E7E7E7D7D7D7D7D7D7D7E7E

7E7E7E7F7F7F7F7F7E7E7E7D7D7C7C7B7A7A797979797979797A7B7B7C7D7E7F818182838384

848483838281807E7D7C7A797776757574747475757678797B7D7E8082848586878888888887

868482807E7C7A78767473717170707172737476787B7D80828486888A8B8B8B8B8A89878583

807E7B78767371706F6E6E6E6F70717476797B7E818487898B8C8D8D8D8D8C8A888583807D7A

777472706E6D6C6C6D6E6F717476797C808385888A8C8D8E8E8E8D8C8A8785827F7C78767370

6F6D6C6C6C6D6E707275777A7E818486898B8C8D8E8E8D8C8B898683817E7B787572706F6E6D

6D6D6E70717476797C7F818486898A8B8C8C8C8B8A898784827F7C7A77757371706F6F6F7071

727476787A7D7F8284868788898A8A898887868482807E7C7A78767574737272737374757778

7A7C7E7F81828484858686868584848281807F7D7C7B79787877777777777878797A7B7C7D7E

7E7F8080818181818080807F7F7E7E7D7D7D7C7C7C7C7C7C7C7C7D7D7D7D7D7D7D7D7D7D7C7C

7C7B7B7B7B7A7A7B7B7B7C7C7D7E7E7F8081828283838383838281807F7E7D7B7A7877767574

74747474757678797B7D7F8183858788898A8A8A8988878583807E7B787673716F6D6C6C6C6D

6E707275787B7E8285898C8E9091929292908E8C8985817D7874706D69676564636465686B6E

72777C81868B8F9396999A9B9B999794908B86807A756F6A65615E5C5B5B5C5E62666B71777E

858B91979C9FA2A4A4A3A19D99938D867E777069625C585452515254585C6269717981899199

9FA5A9ACADADABA8A39D968D857B72696159534E4A4848494D52586068727C869099A1A9AFB3

B6B7B6B3AEA8A0978D82776C6258504944403E3F42464C555E6974808B97A1ABB3B9BEC0C0BE

BAB4ACA2978B7E72655A4F463F393635373A4049525E6A7785929FABB5BDC4C8CAC9C6C0B8AE

A29588796B5D51453C342F2C2C2F343C46525F6D7C8B9AA8B4BFC8CED2D2D0CCC4BBAFA19383

736355473B312A252325292F39455262728293A3B1BEC9D2D8DBDAD7D1C8BCAE9F8E7D6C5B4B

3D3127201C1C1E242C3745556577899BACBBC8D3DCE1E2E1DCD4C9BCAC9B897664524233271E

17141519202A3747586B7E91A4B5C5D2DDE4E8E9E6E0D6C9BAA996836F5B49382A1E15100E10

151E2A394A5D718599ADBFCEDBE5ECEFEEEAE2D6C8B7A4907B6752402F21150D09090C131E2C

3C4F63788DA2B6C8D7E4EDF2F4F2ECE2D5C5B29E89735E493726180E0704050A131F2F41556A

8096ABBFD0DFEBF3F7F7F3ECE0D2C0AD97816B55412E1E11080301040A152233465B72889EB4

C7D8E6F1F7FAF9F3EADDCDBBA69079624D3927180C040000040C1827394D637A91A7BCCEDFEB

F5FAFBF9F2E7D9C7B49E88715A4531201208010000060F1D2D40556B8299AFC3D5E4EFF7FBFB

F7EEE2D3C0AC967F68523E2B1B0E0500000209142334485D748AA1B6C9DAE8F2F8FAF9F3E9DC

CBB9A48E77614B3726170C050101060F1B2A3C50667C92A8BCCEDEEAF2F7F8F5EDE3D4C3B09B

856F59453222150C0604060C15223244596E8499AEC1D2E0EAF1F4F4EFE7DBCCBBA7937D6853

402F20150D08080B121D2B3B4D61768BA0B3C5D4E0E9EEF0EEE8DFD2C3B29E8A76614E3C2D20

16100D0E121A263444566A7E92A5B7C7D4DFE6EAEAE7E0D6C9BAA896826F5C4A3A2C21191413

151B232F3D4D5F728597A9B9C7D3DCE2E4E3DED7CCBFB0A08E7B695848392D241D1A1A1D242D

39475667798B9CACBAC6D0D7DCDDDAD5CDC3B6A79786756555473A3028232122272D3743505F

6F7F8F9FADBAC4CCD2D4D4D1CCC3B9AC9E8F80706254473C342E2A2A2C3037414C5967768493

A0ADB8C0C7CBCCCBC8C2B9AFA396897B6D6053494039343233353A424B55616E7B8895A1ABB4

BBC0C3C4C2BEB7AFA69B8F83766A5F554C443F3C3B3C3F444B545E6974808B96A0A9B0B5B9BB

BAB8B4AEA69D93897E73695F57504A46444445494E555D656F79838D969EA5ABAFB1B2B1AEAA

A49D958D847B7269615A55504E4D4D4F52575D646C747D858D949BA0A5A8A9A9A8A5A19C968F

878078716A645F5A57565556585B60656B72787F868C92979B9EA0A1A19F9C99948F89837D77

716C6763605E5D5D5E6063676C71767B81868B8F9396989999989794918E8985807B77726E6B

686665656566686B6E7175797D8185898C8E90919292918F8D8B8885817E7B7774726F6E6C6C

6C6C6D6F717376787B7E81848688898B8B8B8B8A89888684827F7D7B78777573727272727273

747677797B7D7E80828384858686868585848382817F7E7C7B7A79787777777777777879797A

7B7C7D7E7F80808181818181818180807F7E7E7D7D7C7C7B7B7B7B7B7B7B7B7B7C7C7C7D7D7D

7D7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D7D7D7D7D7D7D7D7E7E7E7E7E7E7E7E7D7D7D7D7D7C7C

7C7C7C7B7B7B7B7C7C7C7C7D7D7D7E7E7E7F7F7F7F7F7F7F7F7F7F7E7E7D7D7C7C7C7B7B7B7A

7A7A7A7B7B7B7C7C7C7D7E7E7F7F7F8080808080807F7F7F7E7E7D7D7C7C7B7B7B7B7A7A7A7B

7B7B7B7C7C7D7D7E7E7E7F7F7F7F7F7F7F7F7F7E7E7E7D7D7D7C7C7C7C7C7C7C7C7C7C7C7C7C

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7E7E7E7E7E7E7E7E7E7E7E7E7D7D

7D7C7C7B7B7B7B7A7A7A7A7A7B7B7C7C7D7E7E7F8080818182828282828180807F7E7D7C7A79

78787776767676767778797A7C7D7F8082838485868787878685848381807E7C7A7876747372

7171717172737577797C7E81838588898B8C8C8C8C8B8A888583807D7A7774716F6D6B6B6A6B

6C6D707275797C8084878A8D909293939392908E8B87847F7B77736F6B68666463636466696C

7074797E83888C919497999A9B9A9896928E89847E78736D6864605E5C5B5C5E6064686E747A

80878D93989C9FA2A3A3A19E9B96908A837C746D67615C5855535354575B60666D747C848C93

9AA0A5A9ABABABA8A59F99928A81786F675F58534E4B4A4B4D50565C646C767F89929BA3A9AF

B2B4B4B3AFAAA39B92887E746960574F4944424142454A515A636D78848F9AA3ACB3B9BCBEBD

BAB5AFA69C91867A6E62574D453F3A38383A3F454E5863707D8996A2ADB6BEC3C6C7C5C1BBB2

A89C908274675A4E433B34302F303339414C58657382909EABB7C1C8CDD0D0CDC7BFB5A99B8C

7D6E5F504439302A2626282D353F4B5968788898A7B5C1CBD3D7D9D7D3CCC2B6A89888776656

47392E26201D1E2128313D4B5B6C7E90A1B1BFCCD6DDE0E1DED8CFC4B6A694826F5D4C3D2F24

1C1715171C24303D4D5F728598AABBCAD6E0E6E9E8E4DCD1C4B4A28F7B67544232251A120E0E

1118222F3F5164798DA1B4C5D4E0E9EEF0EEE8DED2C2B19D88735E4B38281B110A07080D1622

3142566B8096AABECFDEE9F1F5F6F2EADFD1BFAC97816B55412E1F12090302040B152333475C

72899FB4C8D9E7F1F8FBFAF4EBDECEBBA69079624C3725160A020000020A1625384D637A91A8

BDD1E1EFF8FEFFFCF5EADBC9B59F887059422E1D0E03000000010B192A3E536B839AB1C6D9E9

F5FDFFFFFDF4E7D7C4AE977F67503A26150700000000020E1D2F445B738CA3BACFE1EFFAFFFF

FFFBF1E3D1BDA68F765E47311E0F0200000000051223364C647C95ACC2D6E7F4FEFFFFFFF8ED

DDCAB59E866D553F2A180A00000000000A182A3E556D859DB4C9DCECF8FFFFFFFDF4E7D6C2AC

957D654D382414070000000004101F32475E768EA5BBCFE1EFF9FFFFFFF8EEDFCEBAA38C745D

4632201105000000010A17283B50677E96ACC1D4E4F0F9FDFEFAF2E6D7C5B09A836C55402D1C

0F0500000107122031445970879DB2C6D7E5F0F7FAF9F3EADECEBBA7917B654F3B2A1B0F0703

03070F1A293A4E63788EA3B7C9D9E5EEF3F4F2EBE1D4C4B29E89735E4A38281B110B090A0F18

243344576B8095A8BBCBD9E3EAEEEEEAE2D8CABAA895816C594736281D1511101218222E3D4E

6073879AACBDCBD7DFE5E7E6E1D9CEC0B09F8C79675545362A211A17181B222C384757697B8D

9EAFBDCAD3DADEDFDDD7CEC3B6A7968573625244372D25211F21252C36435160708191A1B0BC

C7CFD4D7D6D3CDC4B9AC9D8E7E6F5F51453A312C28282A2F37414D5A68778695A3AFBAC2C9CD

CECCC8C2B9AFA39587796B5E51473E37333131343A414B56626F7D8A97A3ADB6BDC2C4C5C3BE

B8AFA59A8E8175695D534A433E3B3A3B3F444B545F6A75818C97A1AAB1B7BABCBBB8B4AEA69D

93887D72685E564E4945434345494E555D66707A848E979FA6ACB0B2B3B1AFAAA49D958C837A

7068605954504D4C4D4F52575E656D757E868E959CA1A5A8AAAAA8A5A19C958E877F77706963

5E5A57555556585B60656B727980878D93989C9FA1A1A19F9C99948F89837C76706B6663605E

5D5D5E6063676C71767C81878B90939698999A999795918D8984807B76726E6A686665646566

686B6E7175797E8286898C8F9192929291908E8B8885817E7A7774716F6D6C6B6B6C6D6E7073

76797C7F818487898A8B8C8C8C8B8A888684827F7D7A78767473727171717272747577797B7D

7F81828485868687878686858482817F7E7C7B7978777776767676767778797A7B7C7D7E7F80

81828282828282828180807F7E7D7C7C7B7A7A7A79797A7A7A7A7B7B7C7C7D7D7E7E7F7F7F7F

7F7F7F7F7F7E7E7E7E7D7D7D7D7C7C7C7C7C7C7C7C7C7C7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7E7E7E7E7D7D7D7D7D7D7D7D7D7D7C7C7C7C7C7C7C7C7D

7D7D7D7D7D7D7D7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7E7E7E7E7E7E7E7E7E7E7E7E7E7D7D7D7C7C

7C7B7B7B7B7A7A7A7B7B7B7C7C7D7D7E7F7F808081818181818181807F7F7E7D7C7B7A797978

77777777777879797A7C7D7E7F81828384848585858584838281807E7C7B7977767574737373

7374757677797B7D808284868788898A8A8A8988878582807D7B78767371706E6D6D6D6E6F71

7376787C7F8285888A8D8E9090908F8E8C8A8784807C7975716E6B6968676767696B6D707478

7D8185898D9193959797979593908D89847F7A75706C686562605F606163666A6E73797E848A

8F94989B9D9E9E9D9B98948F8A847E77716B65615D5A5858585A5D62676D737A81898F969BA0

A3A6A7A6A5A19D98918A837B736B645E5854514F4F5154585E646C747D868E969DA4A9ACAFAF

AEABA7A19A928A80776D645C554F4B4846474A4E535B636C76818B959EA6ADB2B6B8B8B6B2AC

A59C92887D72675D544C45413E3E3F43485058636E7985919CA7AFB7BCC0C1C0BDB8B0A79D91

85786C5F544A423B373535383D444D5864707E8B99A5B0B9C1C6C9CAC8C3BCB3A99C8F817264

574B4037312D2C2D3138404B5866748493A1AEBAC4CBD0D3D2CFC9C0B5A99A8B7B6B5C4E4136

2D272423262B343E4B59697A8A9BAAB8C4CED5DADBD9D4CDC2B6A7978675645344372C231E1B

1C2027313E4C5C6E8092A3B4C2CED8DFE2E2DFD9D0C3B5A493806D5B4A3A2D221A1514161B24

303E4F6174879AADBDCCD8E1E7EAE9E4DCD1C3B2A08D79655240302318110D0D111823304153

667B8FA3B6C7D6E1EAEFF0EEE7DDD0C1AF9B86715C4936271A100A07090E17233244586D8298

ACC0D1DFEAF1F5F5F1E9DDCFBDAA947F69533F2D1E11090302050C172536495E748BA1B6C9D9

E7F1F7FAF8F2E9DBCBB8A38D76604A3624160A030000040D19283B4F667D93AABFD1E1EEF7FC

FDF9F2E7D8C6B29C856E57412E1D0F04000000040E1C2D41576E859CB2C7D9E8F4FBFFFEF9F0

E3D3C0AB947D654E392616090000000006122134485F768EA5BBCEE0EDF8FEFFFEF7ECDECDB9

A38C745D4632201105000000010A17283B50677F96ADC2D5E5F1FAFFFFFBF3E7D8C5B19A836B

543F2B1A0D03000000050F1E2F435970879EB4C8DAE9F4FBFEFCF7EEE1D0BDA8927A634D3926

170B020000020A1625374C62788FA6BACDDEEBF4F9FBF8F1E7D9C8B49F89725C473423150A04

010308111E2E40556A8197ACC0D1E0EBF3F6F6F2EADFD0BFAB96816B56423021150C0706090F

1927374A5E73889DB1C3D3E0E9F0F2F0EBE2D6C7B5A28E7964503E2E20160F0C0C1018233041

53677B8FA3B5C5D3DEE6EBECE9E2D9CCBDAC9986725F4C3C2D221914121319212C3A4A5C6F82

95A7B7C6D2DBE2E4E4E0D9CFC2B3A2917E6C5A4A3B2F251E1A191C222B36445465768899A9B8

C5CFD7DBDDDBD6CFC5B8AA9A89786757493C3129242122262C35414E5D6D7D8D9CABB8C2CBD1

D4D4D2CCC4BAAEA09282736456493E352F2B2A2C3037404B57657382909EABB6BFC5CACCCBC8

C2BAB0A5988B7D6F62564B423B363333363A414A54606C7986939EA9B2B9BFC2C2C1BDB7B0A6

9C9084786C61574E47413E3C3D40454B545D68737E89949EA6ADB3B7B9B9B7B3ADA69E948A80

756B6259524D494646474A4F555D656E78818B939BA2A8ACAFB0AFACA9A39D958D857C736B64

5D5853514F505154595E656C747B838B92989DA2A4A6A6A5A39F9A958F88817A736C67625E5B

5958595B5E62666C72787E848A8F94989B9D9D9D9C9A96928E89837E78736F6A676462616162

6466696D72767B8084888C8F929495959493918F8C8884807C7875716F6C6B6A69696A6C6E70

7376797D808386888A8C8D8D8D8D8B8A888683817E7C79777573727171717172737476787A7C

7E7F81838485868686868585848381807F7D7C7B7A797877777777787879797A7B7C7D7E7E7F

7F808080808080807F7F7E7E7E7D7D7D7D7C7C7C7C7D7D7D7D7D7D7D7D7D7D7D7D7D7C7C7C7B

7B7B7B7B7B7B7B7B7C7C7D7D7E7F7F808081818181818181807F7F7E7D7C7B7A797878777777

777778797A7B7C7D7E80818283848485858584848382807F7E7C7A7978767575747474747576

77797A7C7E7F81838485868787878786858482817F7D7B79777675747372727373747577797B

7D7F8182848687888888888787858482807E7C7A78767574737272727273747677797B7D7F81

838586878888888887868583817F7D7B7A787675747373737373747677797A7C7E8081838485

868787878685848382807E7D7B7A7877767575747575767677797A7B7D7E8081828384848484

8483838281807F7E7C7B7A797978787878787879797A7B7C7C7D7E7F7F80808081818080807F

7F7F7E7E7D7D7C7C7C7C7C7C7C7C7C7C7C7D7D7D7D7D7D7D7D7D7D7C7C7C7C7C7C7C7C7C7C7C

7D7D7E7E7F7F808081818181818180807F7E7D7C7B7A79787777767676767778787A7B7C7E80

81838485868787878786858482817F7C7A787674727170706F7071727375787A7D808385888A

8C8D8E8E8E8D8C8A8785827E7B7774716E6C6A696868696B6D7073767A7F83878A8E91939596

969593918E8A86827D78736F6B6764626160616265686C71767B81878C9195999B9D9E9E9C9A

96928D87817B746E68635F5C595858595C5F646A70777E858C92989DA1A4A6A6A5A39F9B958E

877F776F68615B5653504F5052565B61687078818A929AA0A6ABAEAFAFADA9A49E978E857C72

696159524D494747484B50575F67717B858F99A2A9AFB4B7B8B7B4AFA9A1988D83786D625950

4943403E3F41464C545D68737F8B96A1AAB3B9BEC0C0BEBAB4ACA2978B7F72665A50473F3A37

36373B4149525D6A7784919EAAB4BCC3C7C9C8C5BFB7AEA296887A6C5F52473D36312E2E3035

3D46525F6D7C8A99A6B3BDC6CCD0D0CFCAC3BAAEA19384746556493D342C2826272B313A4653

62718191A1AFBCC6CFD5D7D7D4CEC6BBAD9F8F7E6D5D4E40342B24201F21272F3A4655667788

99A9B8C5CFD7DCDEDDD8D1C7BAAB9B8978665545372B221C191A1D242E3A49596B7D8FA1B2C1

CDD8DFE3E4E1DBD2C6B8A89683705E4C3D2F231B1614161B232E3C4C5E718497A9BAC9D5DFE5

E8E8E4DCD2C4B4A3907C69564434271C151110131A23303F5164778B9FB1C2D1DCE5EAECEAE4

DCCFC1B09D8975614E3C2D2016100D0E121A253444576A7F93A7B9C9D7E2EAEEEEEBE4D9CCBC

AA96826D594635261A120D0B0D131D29384A5D72869BAEC0D0DDE6EDEFEEEAE1D6C7B6A38F7A

66523F2F21160F0B0B0E16202E3E5164798EA2B5C6D5E1E9EEF0EDE7DDD1C1AF9C88735F4B39

2A1D140E0B0C111A263445586C8195A9BBCBD9E3EAEEEEEAE3D8CABAA894806C584535261B13

0E0D10161F2C3B4D6074889CAEC0CFDBE4EAECEAE5DDD1C3B2A08D7965524131241A14101114

1C26344355687B8FA2B3C3D1DBE3E7E8E5DFD6CABBAA9885725F4D3D2F241B1614161B232E3C

4C5D6F8295A6B7C5D1DAE0E3E3DFD8CEC1B2A2907E6C5A4A3B2F251E1A1A1C222B3744546576

889AAAB9C5D0D7DCDEDCD7CFC5B8AA9A89786757483B3028222021242B34404D5C6C7D8D9DAC

B9C4CDD3D6D7D4CEC6BCAFA19282726354473C332C2827292D343E495664738291A0ADB8C1C9

CDCFCECBC5BDB2A6998B7C6E6054483F37322F2F32373E47525E6C798794A1ACB5BDC3C6C7C5

C1BBB3A99E9285786B5F544B433D3938393C4148515B66727E8A96A0AAB1B8BCBEBEBBB7B1A9

A0968B80746A5F564E4844414142464B525A636D77828C969EA6ACB1B4B5B4B1ADA7A0988F85

7C7269615A544F4C4A4B4C50555B626A737B848D949BA1A6A9ABABAAA7A39E9890898179726A

645E5A56545455575A5E646A70777E858C92979B9EA0A1A1A09D9995908A847E78726D686461

5F5E5E5F6163676B70757B80858A8E9294969898979694918D8985817C7874706D6A68676767

686A6C6F7276797D808487898B8D8E8F8E8E8D8B898684817E7B797674737170707070717374

76787A7C7E7F81838485858686858584838281807E7D7C7B7A797979797979797A7A7B7B7C7C

7D7D7E7E7E7E7E7E7E7D7D7D7D7D7D7D7D7D7D7E7E7E7F7F8080818181818180807F7E7D7C7B

7A79787776767676767677787A7B7D7E8082838586878888888887868483817F7C7A78767472

70706F6F6F70717375787A7D808386888A8C8D8E8E8E8D8C8A8784817E7B7774716E6C6B6969

696A6C6E7074777B7F82868A8D8F9193949493918F8C8985817D7874706D6A67656464656669

6B6F73777C81858A8E9194969798979694918D8985807B76716D6965636161616264676A6F73

787E83888D9195989A9B9B9A9895928E89847E79736E696562605E5E5F6063666A6F757A8086

8B9094989A9C9D9D9B9996928D87827C76716B6763605E5D5D5E6063676C71767C82888D9296

999C9D9E9D9B9895908B86807A746F6A65625F5D5D5D5F6164696D73797E848A8F93979A9C9D

9D9C9A96938E89837E78726D6965625F5E5E5F6063676B70757B80868B909497999B9B9B9997

94908B86817C76716D6965636160606264666A6E73787D82878B8F9395979898979693908C88

847F7A75716D6A676564646465686A6E72767A7E83878B8E919394949493918F8C8985817D79

75726F6C6A696868696A6C6F7275787C7F8386898B8D8E8F8F8F8E8C8A8885827F7C79767472

706F6E6E6E6F70727476787B7D808284868788898989898887858381807E7C7A787776757474

7474757677787A7B7C7E7F8081828283838382828181807F7E7E7D7C7C7B7B7B7B7B7B7B7C7C

7C7C7D7D7D7D7D7D7D7D7C7C7C7B7B7B7B7B7B7B7C7C7D7D7E7F808181828283838383828281

807E7D7B7A787776757473737374747677797B7D7F81838587898A8B8B8B8A89888684817E7C

797673716E6D6C6B6B6B6D6E7173777A7E8185898C8E919293939392908D8A86827E7975716D

6966646362636466696D71767B80858A8F9397999B9C9C9B9895918D87827C76706A65615E5B

5A5A5B5D60656A6F767C838A90969B9FA2A4A5A4A29E9A958E878079716A635D595552515254

575B61686F777F8890979EA3A8ABADADABA8A49E978F867D746C635C55504C4A494A4D52585F

67707A838D969FA6ACB1B4B5B4B2ADA7A0988E847A6F655C544D4744424244484E555E67727D

88939DA6AEB4B9BCBCBBB7B1AAA1978C8175695E544C453F3C3B3C3F444B545E6975828E9AA5

AEB6BCC1C3C2C0BBB4ABA196897C7063574D443D383534363B414A545F6C798794A1ACB6BEC4

C8C9C7C4BEB5ABA0938577695C50453C35312F2F3238404A5562707E8D9BA8B3BDC5CACDCECB

C6BFB5AA9D8F80726355493E362F2B2A2C3037404B5866758493A1AEBAC4CBD0D2D1CDC7BFB4

A7998A7B6B5D4F4338302A27272A2F37424E5C6B7A8A99A8B5C0C9D0D3D4D3CEC7BDB1A39585

756556493D332B2725262930394452607080909FAEBAC5CDD3D6D6D3CDC5BAAD9F8F7F6F5F51

43382F282424262B323C495766768696A5B3BFC9D0D5D7D5D1CBC1B6A8998979695A4C3F342C

272424272D36414E5C6C7C8C9BAAB7C2CBD2D5D6D4CEC7BDB0A29384746455473C322B272526

2B313B465462728191A0AEBAC4CCD1D4D3D0CAC2B7AA9C8D7E6E5F51453A312C28282A2F3741

4C5A68788796A4B1BCC5CBCFD1CFCBC4BBB0A4968778695B4E433A322E2C2C2F353D4753606F

7D8C9AA7B2BCC4C9CCCCCAC5BEB4A99D8F817366594D433B35313032363C444F5A677482909C

A8B2BBC1C5C7C6C3BEB6ADA296897C6F63574D443E393737393D444C56616D7A86929EA8B1B8

BDC0C0BFBBB6AEA59B9084786C61574F47423F3D3E41464C545E68737E89949EA6AEB3B7B9B9

B7B3ADA69D948A7F756B6159524C484545464A4E555C656E78828B949CA3A9ADB0B1B0AEAAA4

9E968E857C736A635C56524F4E4E5053575D646B737C848C93999FA3A6A8A8A7A4A19C968F88

8179726B65605C59575657595C60656B71787E858B9095999C9E9F9F9D9B98938E89847E7873

6E696663616060616365696D71767B8084898D90929495959594918F8C8884807C7875716F6C

6B6A696A6B6C6E7174777A7D80838587898B8B8C8C8B8A88878582807E7C7A78767574737373

7474757778797B7C7D7F80818182828282828181807F7F7E7E7D7D7C7C7C7C7C7D7D7D7D7E7E

7E7E7E7E7D7D7C7C7B7A7A79797878787879797A7B7C7D7F8082838485868686868685848381

7F7D7B7977757371706F6F6F7071727477797C7F8285888A8C8E8F8F8F8F8D8B8986837F7C78

74716E6B6967676667696B6D7175797D82868A8E9294969898979694908D88847E79746F6A66

63615F5E5F6062666A6F747A80858B9095999C9EA09F9E9C98948F89837C766F69645F5B5957

57585A5E62676E747B838A91979CA1A4A6A7A6A4A19C9690898179726A635D58545251515356

5A60676E767E878F969DA3A7AAACACABA8A49E9790877F766D655D57524E4C4B4C4F53585F67

6F79828B949CA3A9ADB0B1B1AFABA59F978E857B72686058514C494747494C51586068727C86

9099A1A8AEB2B5B5B4B1ACA69E958C82776D645B534D48454344474B5159616B75808A949DA6

ADB2B6B8B8B5B2ACA59C93897E73695F564F4944424243464B525A646E79848E98A2AAB0B5B8

B9B8B6B1ABA39A90857A6F655B534C4643414143474D555D67727D88929CA5ACB2B7B9B9B8B4

AFA89F968C81766B6158504A45424142454A5058616B76818B959FA7AEB3B7B8B8B6B1ACA49B

92887D72685F564F4945434345484D545C66707A848E98A1A8AEB3B5B6B5B2ADA7A0978D8379

6F665D554F4A474646484C5259616A747E87919AA1A8ADB1B2B2B1ADA8A29B928980766D645C

56504C4A4A4B4D52575E666F78818A929AA1A6ABADAEAEABA8A39D958D857C746B645D575350

4F4F5053585D646B737B838B93999FA3A7A8A9A8A5A19D9790898179726B655F5B5755545557

5A5E636970777E858C92979C9FA1A2A2A19E9B96918B857E78726C67625F5D5B5B5C5E61656A

6F747A80868B9094979A9B9C9B999794908B86817C77726E6A67656362636466686C6F74787D

8185898D8F9293949493928F8D8A86837F7B7774716F6D6B6A6A6B6C6D6F7275787B7E818386

888A8B8C8C8C8B8A88868482807D7B79777574737372737374757678797B7C7E7F8182838383

848383838281807F7E7E7D7C7C7B7B7B7B7B7B7B7B7C7C7C7D7D7D7D7D7D7D7C7C7C7B7B7B7B

7B7B7B7B7C7C7D7E7E7F8081828383838483838382817F7E7D7B797876757473737273737475

77797B7D7F828486888A8B8C8C8C8B8A888684817E7B787572706D6C6B6A6A6B6C6E7174777B

7F8286898D8F919394949392908D8985817D7874706C68666463626364676A6E72777C81868B

909397999B9B9B9A9794908B86807B756F6A65615E5C5B5B5C5F62666B71777E848B90969A9E

A1A2A2A19F9C98928C867F77706A645F5A57555455575A5F646B7279818890969CA1A5A8A9A8

A7A49F9A938C847C746C645E5854504F4F5053575D636B737C848D959CA2A8ABAEAEADABA7A1

9B938A81786F675F58524E4B4A4A4C50555C646C757F88929AA2A8ADB1B2B2B1ADA8A29A9188

7E746B6259524D494646474A4F555C656F79838D969FA7ADB2B5B6B5B3AFA9A1998F857A7066

5D554E4845434345494F565E68727C87919BA4ABB1B5B8B8B7B3AEA89F968C81766C6259514A

4542414245495058616B75808B959FA7AEB4B8B9B9B7B3ADA59D93887D72685E554E48434141

42464B525B646E79848F99A2AAB1B5B8B9B8B5B0AAA2998F84796F645B534C4743424244484E

565F68737D88929CA4ACB1B5B7B8B6B2ADA69E958B80766B6259514B47444345484C535A636D

77818B959EA5ACB1B4B5B5B2AEA9A29990867C72696058524C494747494C51575F68717B848E

969EA5ABAFB1B1B0ADA9A39C948C827970675F59534F4C4B4C4E52575D646D757E878F979EA3

A8ABACACABA8A39D978F877F766E67605B565351515254585D636A7179818890969CA0A4A6A7

A6A4A19C97918A837C756E68625E5A585757595B5F64696F757C83898F94989C9E9FA09F9C99

95918B86807A746F6A6663605F5E5F6063666A6F74797E83888C9093969798989695928F8B87

827E7975716E6B6967666667696B6E7174787B7F8386898B8D8F8F8F8F8E8C8A8885827F7C7A

77757371706F6F6F7071737576797B7D7F81838485868686868685848382807F7E7C7B7A7979

7878787879797A7A7B7C7C7D7D7E7E7E7E7E7E7D7D7D7D7C7C7C7C7C7D7D7E7E7F7F80818182

828282828181807F7E7C7B797877757474737373747576787A7C7E80828587888A8B8C8C8B8B

89888583807D7A7774716E6C6B6A696A6B6C6E7174787C8084888B8F91939595959493908D89

85807B76726D696663616060616365696D72787D83898E93979B9D9F9F9E9C9996918B857F78

726B66615C59575657595C60656B727980888F959BA0A4A7A8A8A6A49F9A938C847C746C645E

5853504E4D4F52565B626A727B848D969DA4AAAEB0B1B0AEA9A49D958C82786F655D554F4A47

4545484C5158616A747F89939DA6ADB3B7B9B9B7B4AEA79E958A7F74695E554D46413E3D3E42

474E57616C77838F9AA5AEB5BBBFC0C0BDB8B1A89E93877A6E62574D443E393737393D444C57

626F7C8995A1ACB6BDC3C6C7C5C1BBB3A99D908375685B4F453D36323031353A424C58657381

8F9CA9B4BDC5CACCCCC9C4BCB3A79A8C7E6F6154483E36302C2C2D3239424E5B69778695A3B0

BBC4CBCFD1D0CCC5BCB1A5978878695B4D4137302A28282B313944505E6D7D8C9BAAB6C1CAD0

D3D4D2CCC5BBAFA19282736354473B322B2725262B323B475463738392A2B0BCC6CED3D6D5D2

CCC3B8AB9C8D7D6D5D4E42362E282424262C343E4B5968788998A7B5C1CAD1D5D7D5D1C9C0B4

A69787776757493D332B262424282E3743505E6E7E8E9EACB9C4CDD3D6D6D3CEC6BBAEA09181

716153453A302A2625262B323C485664748494A3B0BCC6CED2D4D4D0C9C1B5A99A8B7B6C5D4F

4238302A27272A2F38424E5C6B7A8998A6B3BEC7CDD1D2D0CBC4BBAFA294857667594C413730

2C2A2B2F353E485562717F8E9CA9B5BEC6CBCDCDCBC5BEB4A89B8E7F7163564A403833302F31

353C454F5C697684929FABB5BDC3C7C9C8C4BEB6ADA195887A6D60554A423B363435373C434C

57626F7C8995A1ABB4BBC0C2C3C1BDB7AFA59A8F82766A5F544B443F3C3B3C3F444B545E6974

808C97A1AAB1B7BABCBCB9B5AFA79E94897E73685E554E4844424243474C535C656F79848E97

A0A7ADB1B4B5B4B1ACA69F978D847A71675F58524D4B494A4C50555B636B747D868E969DA3A8

ABADADABA8A49E97908880787068615C575452515255585D636A717880878E949A9EA2A4A5A4

A29F9B96918A847D76706A65615D5B5A5A5B5E61656A6F757B81878C9195989B9C9C9B999793

8F8A85807B76716D6966646362636466696C7075797D82868A8D909293939392918F8C898582

7E7A7774716F6D6C6B6B6C6D6E707376787B7E81848688898A8B8B8B8A89878583817F7D7B79

7776747473737374757677787A7B7D7E7F8181828383838383828181807F7E7D7D7C7C7B7B7B

7B7B7B7B7C7C7C7D7D7D7D7D7D7D7D7C7C7C7C7B7B7B7B7B7B7B7C7C7D7E7E7F808181828283

8383828281807F7E7C7B7A7877767574747474757677787A7C7D7F8183858688898989898887

868482807D7B78767472706F6E6E6E6F70717476797C7F8285888A8C8E8F8F8F8E8D8B898683

807C7975726F6C6A696868696A6C6F7275797D8185898C8F919394949493918E8B87837F7A76

726E6B686664646465676A6D71757A7F83888C909396979898979693908C87827D78736E6A67

64626060616365686C71767B81868B909397999B9B9B999794908B86817B76706B6763615F5E

5E5F6164686D72787D83888E9296999C9D9D9C9A97948F8A847F79736E6965615F5D5D5D5F61

65696E747A7F858B9094989B9D9E9D9C9A96928D88827D77716C6763605E5D5D5E6063676B70

767C81878C9195999B9D9D9C9B9894908B86807B75706B6763605F5E5E606265696E73787E83

888D9295989A9B9B9A9895918D88837E79746F6B6764626161616365696C71767A8084898D91

94969798979694918E8A86817C78736F6C69666564646567696C7074787C8185898C8F919393

949392908D8A86837F7B7774716E6C6A6969696A6C6E7174777A7E8184878A8C8D8E8E8E8D8C

8A888683807D7B78757372706F6F6F6F70727375787A7C7E8183848687888888888786858382

807E7D7B7A78777676767676767778797A7B7C7D7E7F8080818181818180807F7F7E7E7E7D7D

7D7D7D7D7D7D7D7D7E7E7E7E7E7E7E7D7D7C7C7B7B7A7A797979797979797A7B7C7D7E808182

8384858586868585848381807E7C7A78767473717170707071737476797B7E818486898B8C8E

8E8F8E8D8C898784807D7976726F6C6A68676767686A6D7073787C8085898D90939697989897

95928E8A85807B76706C6764615F5E5E5F6164686C72777E848A9095999DA0A1A1A19F9B9792

8C867F78716A645F5A57555454565A5E636A7179818890979DA3A7AAABABA9A6A19C958D857C

736B635B55504D4B4A4C4F53596069727B858E97A0A7ADB1B4B5B4B1ACA69F968D82786D635A

524B4642414144484E565F69747F8A95A0A9B1B7BBBEBEBCB8B2AAA1968B7F73675B5148413C

3938393D424A545E6A7784919DA8B2BBC1C5C7C6C3BEB6ADA195887A6C5F53483E37322F2F32

373E4853606D7C8A98A6B2BCC5CBCECFCDC9C2B9ADA092837465574A3E352E2927282C323B47

5462718191A0AFBBC6CED4D6D6D3CDC5BAAD9E8E7E6D5D4E40352B25212022272F3A47566677

8899A9B8C4CFD7DCDEDCD8D0C6B9AB9B8978665545372C231D1A1A1E242E3A49596B7D8FA1B1

C0CDD7DEE3E3E1DBD2C6B8A79683705E4D3D2F241B1614161B232E3C4C5E718497A9BAC9D5DF

E5E8E7E3DCD1C4B4A3907C69564434271C151110131A2430405164788B9FB1C2D0DCE5EAECEA

E4DBCFC1B09D8975614E3C2D2016100D0E121A263444576A7F93A7B9C9D7E2EAEEEEEBE4D9CC

BCAA96826D594635261A120D0B0D131D29384A5D72869BAEC0D0DDE6EDEFEEEAE1D6C7B6A38F

7A66523F2F21160F0B0B0E16202E3E5165798EA2B5C6D5E1E9EEF0EDE7DDD1C1AF9C88735E4B

392A1D140D0B0C111A263445586C8195A9BBCBD9E3EAEEEEEAE3D8CABAA894806C584535261B

130E0D10161F2C3B4D6074889CAFC0CFDBE4EAECEAE5DDD1C3B2A08D7965524031241A131010

141C26334355687B8FA2B3C3D1DCE3E7E8E6DFD6CABBAA9885725F4D3D2F231B1614161B232E

3C4B5D6F8295A7B7C5D1DBE1E4E3DFD8CEC1B3A2907E6C5A4A3B2E241E1A191C222B36445465

77889AAAB9C6D0D8DDDEDCD8D0C5B9AA9A89786756473A2F27221F20242A343F4D5C6C7D8E9E

ADBAC5CED4D7D7D5CFC7BCB0A29282726254473B322B2726282C333D485664738392A0ADB9C3

CACED0D0CCC6BEB3A79A8B7C6E6053473D36312E2E30353D46515E6B798795A2ADB7BFC4C8C9

C7C3BDB4AA9F9285786B5E5349413B3736363A3F464F5A65727E8B97A2ABB3BABEC0C0BEB9B3

ABA2978C8074695E544C46413F3E4043485058626C77828D97A0A8AFB4B7B8B7B4B0AAA29A90

867C72685F57514C484747494D52586069727B858E969EA4A9ADAFAFAEABA6A19A928A817970

68615B5652504F5052565B61676F777E868E949A9FA3A5A6A6A4A29E98938C857E77706A6460

5C5A5858595B5F63686E747A80878C9196999C9D9E9D9C9995918C87817C76716C6865636160

616264676A6E73787D81868A8E91939596969593918E8B87837F7B7773706D6B696868696A6C

6E7174777B7E8184878A8C8D8E8E8E8D8C8A888583807D7A7876747271706F70707172747678

7A7C7E8082848586878787878685848381807E7D7B7A79787776767676777778797A7B7C7D7E

7F808081818181818180807F7F7E7E7D7D7C7C7C7C7C7C7C7C7C7C7C7D7D7D7D7D7D7D7D7D7D

7C7C7C7C7C7C7C7C7C7C7C7D7D7E7E7F7F7F80808081818080807F7F7E7D7C7C7B7A79797878

7878787879797A7B7C7E7F80818283838484848484838281807E7D7B7A797876767575747575

7677787A7B7D7E8082838485868787878685848382807E7C7A79777674737373737374757678

797B7D7F81838586878888888887868583817F7D7B79787674737272727273747576787A7C7E

8082848586878888888887868482817F7D7B79777674737372727373747677797B7D7F818284

8586878787878685848381807E7C7A797776757474747475757678797A7C7D7F808283848485

85858484838281807E7D7C7B7A797877777777777878797A7B7C7D7E7F7F8081818181818181

80807F7F7E7E7D7C7C7B7B7B7B7B7B7B7B7B7C7C7C7D7D7D7D7D7D7D7D7D7D7D7D7D7C7C7C7C

7D7D7D7D7E7E7E7F7F808080808080807F7F7E7E7D7C7B7A79797878777777777879797B7C7D

7E8081838485858686868685848381807E7C7A78767473727171717172737577797B7E818386

888A8B8C8D8D8D8C8A888683807D7A7673706E6C6A6969696A6C6E7175787C8084888B8E9193

94959594928F8C8984807B76726E6A66646261616264676A6E73787E83888E9296999C9D9D9D

9B9894908A857E78726C67625E5B5958595A5D61666C727980878E949A9FA3A5A6A6A5A29E98

928B847C746C655F595551504F5153575D636B737C848D959CA3A8ACAFB0AFACA8A39C948B82

786F665D564F4B474646484C5259616B757F89949DA5ADB2B6B9B9B7B3AEA79E948A7F73685E

544C45403D3C3E41464E56616C7884909BA6AFB7BDC1C2C2BFBAB3AA9F93877A6D61554B423B

363333363A414A55616E7C8A97A4AFB9C1C7CBCCCAC6BFB6AB9F91837466584B4037302C2A2B

2F353E485563728191A0ADBAC4CCD1D4D4D1CBC3B8AC9D8E7E6D5E4F41362D2622212429313B

485666778899A9B7C4CED6DBDDDCD7D0C6B9AA9A8977665545372C231C1A1A1D242E3A49596B

7D90A1B2C1CED8E0E4E5E2DCD3C7B8A89683705D4B3B2D221914121419212D3B4B5D718498AB

BCCBD8E2E8EBEBE7DFD4C6B6A4907C685442312318100C0B0F15202D3D4F63788CA1B4C6D5E1

EAF0F2F0EAE1D4C4B29E8A745F4B38281A100906070B14202F4154697F95AABECFDEEAF2F6F7

F3EBE0D2C1AD98826C56412F1F12080301030A142233465B71889EB3C7D8E6F1F8FBFAF4EBDE

CEBCA7917A634D3826170B030000020A1625374C627990A7BCCFE0EDF7FCFEFBF4E9DBC9B5A0

89715A44301F1005000000030C1A2A3E536A8299AFC4D7E6F3FBFFFFFAF2E6D6C3AE98806852

3C29180B0100000005101F31455B738AA1B8CCDDECF6FDFFFEF8EEE1D0BCA68F776049352213

0700000000091525384D647B93A9BFD2E2EFF9FEFFFCF4E9DAC8B49E866F58422E1D0F050000

00040E1C2D40566C849BB1C5D7E6F1F9FDFCF7EFE2D2C0AB957E67513C291A0D040000020A15

2435495E758CA2B7CADBE8F2F8FAF8F2E8DACAB7A28C76604A3726180D06030308111D2C3E52

677D93A8BCCEDCE8F0F5F5F2EAE0D1C1AE99846E59453324170E0907090F192635475B70859A

AEC0D0DDE7EDF0EFEAE2D6C8B7A4907C675442312419110E0D1118222F3F5164788C9FB1C2D0

DBE4E9EAE8E2D9CDBEAE9B887562503F31251C16141519212C39495A6C7F92A3B4C3CFD8DFE2

E2DFD8CFC3B4A493816F5D4D3E3228201C1B1D232B36435263748596A6B5C2CCD4D9DBDAD6CE

C5B9AB9B8B7B6A5A4C3F342C262424272D35404D5B6B7A8A9AA8B5C0C8CED2D3D0CCC4BBAFA2

93847567594C4138312D2C2D3137404A566372808E9CA8B3BCC3C8CAC9C7C1BAB1A6998C7F71

64584D443D383535373B414A535F6B7784919CA7B0B7BDC0C1C0BDB7B0A79D92867A6E635950

49433F3E3E41454B535C66717C87929CA4ACB2B6B8B8B6B3ADA79E958B81776D645B544E4A47

46484A4F555C646D768089929AA1A7ABAEAFAFADA9A49E978F867D756C655E5854514F4F5154

585D646B727A828A91979DA1A4A6A7A6A4A09B969089827B746D67625E5A5858585A5C60656A

70777D848A8F94989B9D9E9E9D9B98948F8A857F79746F6A666361605F606264686C70757A7F

84888D9093959797979593918D8A86817D7874716D6B6967676768696B6E7175787C8083878A

8C8E8F9090908E8D8B8885827F7C797673716F6E6D6D6D6E6F717376787B7D8082858688898A

8A8A898987868482807E7B79787675747373737374757677797A7C7E7F818283848585858585

848382817F7E7D7C7A79797877777777777879797A7B7C7D7E7F7F808181818181818180807F

7F7E7D7D7C7C7B7B7B7A7A7A7B7B7B7B7C7C7C7D7D7D7E7E7E7E7E7E7E7E7E7E7E7E7E7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D7D7D7C7C7C7C7C7C7C7C7D7D7D7D7D7D7D7D7D7D7E7E

7E7E7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

pop

% End of sampled sound

% End of Graphics

MathPictureEnd


\
\>"], "Sound",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oo`008@0000000`00
Oomoo`3oOolMOol100000003001oogoo00Moo`@006aoo`<0015oo`@0011oo`@006aoo`<000Yoo`40
000000<007ooOol01Woo1P003goo1000Egoo1P003Goo1`003Woo1P003goo1000@goo10003goo1P00
2Goo0@0000000`00Oomoo`05Ool8000=Ool7000>Ool4000_Ool5000>Ool7000<Ool9000<Ool8000=
Ool60011Ool6000=Ool90007Ool100000003001oogoo00Aoo`X000]oo`T000aoo`H001]oo`<000mo
o`L000aoo`T000]oo`X000Yoo`X000]oo`P000ioo`D001Uoo`H000eoo`P000aoo`T000Moo`400000
00<007ooOol00goo30002Goo2`002Woo20003Woo1@001Goo1P003Goo2@002Woo2`002Goo300027oo
30002Goo2P002goo20001Goo0`001goo0`001Goo20002goo2P002Woo2`001Woo0@0000000`00Oomo
o`03Ool<0008Ool<0009Ool:0004Ool40004Ool70003Ool80005Ool20004Ool;0008Ool=0007Ool=
0007Ool=0008Ool<000:Ool90003Ool60003Ool60004Ool8000;Ool;0008Ool=0005Ool100000004
001oogooOol@0005Ool>0003Ool00`00Oomoo`02Ool;0002Ool60002Ool900000goo000000080002
Ool50002Ool=0006Ool?0005Ool?0005Ool?0006Ool=0002Ool40003Ool:0002Ool800000goo0000
00060002Ool:0003Ool40002Ool=0006Ool?0004Ool100000003001oogoo018000=ooe/00003Ool0
000000h000=ooa80009ooa400003Ool0000002`00003Ool0000003h000=oo`40000000<007oo0000
o`0070000Goo0@0000000`00Oomoo`0B00000goo001oo`1K00000goo0000000>0003OolA0003OolA
00000goo0000001K00000goo0000000?0003Ool100000003001oogoo009oo`h000Ioo`h000=oo`80
00=oo`/0009oo`H0009oo`T00003Ool0000000P0009oo`H00003Ool0000000/000Moo`h000Eooa00
00Aoo`l000Ioo`d000=oo`@0009oo`X0009oo`P0009oo`L0009oo`/0009oo`@0009oo`d000Ioo`l0
00Aoo`40000000<007ooOol00Woo3P001goo30002Goo2P000goo1@0017oo1`000goo2@000goo1000
0goo2`0027oo3@001goo1P0000=oo`0000001@001Woo3@0027oo30002Goo2P000goo1P000goo1`00
0Woo2P002Goo300027oo3@001Goo0@0000000`00Oomoo`03Ool<0009Ool;000:Ool90005Ool00`00
Oomoo`05Ool50005Ool7000<Ool9000:Ool;0008Ool=0008Ool<0009Ool:000;Ool80005Ool40005
Ool40005Ool8000;Ool;0009Ool;0006Ool100000003001oogoo00Aoo`X000]oo`T000aoo`L0011o
o`8000Moo`@000moo`P000]oo`T000Yoo`/000Yoo`X000]oo`P000eoo`H001Uoo`H000eoo`T000Yo
o`/000Ioo`40000000<007ooOol01Goo200037oo20003Woo1@00;Goo1P003Woo20002goo2@002goo
2@003Goo1P0047oo0`006goo0`0047oo1`0037oo2@001goo0@0000000`00Oomoo`05Ool8000=Ool6
0013Ool3000?Ool7000=Ool7000>Ool6000?Ool40013Ool5000>Ool70008Ool100000003001oogoo
00Ioo`H0011oo`8005Uoo`<0011oo`D000moo`D006]oo`D000Uoo`40000000<007ooOol0S7oo00<0
07ooOol0SGoo0@0000000`00Oomoo`3oOolMOol100000?l00240000000<007ooOol0ogoo7Goo0@00
00000`00Oomoo`07Ool4001/Ool3000AOol4000@Ool4001[Ool4000:Ool100000003001oogoo00Mo
o`04001oogoo001/Ool2000AOol300000goo001oo`0?Ool01000Ool00000Jgoo0P0000=oo`00Ool0
2Goo0@0000000`00Oomoo`07Ool5000@Ool2001IOol3000@Ool01000Oomoo`004Goo0P0000=oo`00
Ool0KGoo00<007ooOol027oo0@0000000`00Oomoo`07Ool5000@Ool2001IOol3000BOol3000@Ool4
001[Ool4000:Ool100000003001oogoo00Moo`80009oo`03001oogoo00ioo`03001oo`0005Qoo`80
0003Ool007oo00ioo`03001oo`00008000moo`05001oogooOol0001[Ool00`00Ool000020009Ool1
00000003001oogoo00Ioo`04001oogoo000BOol3001GOol00`00Ool0000AOol00`00Oomoo`02Ool0
0`00Oomoo`0<Ool300000goo001oo`1ZOol01@00Ool007oo00002Goo0@0000000`00Oomoo`06Ool3
0002Ool00`00Oomoo`0>Ool3001HOol01000Oomoo`003goo100000=oo`00Ool03Goo0P0000=oo`00
00004Goo0P00AGoo0P004Goo10002Woo0@0000000`00Oomoo`0:Ool2000?Ool01000Ool00000Egoo
00<007oo00000P003goo00<007ooOol04Goo0P0000Aoo`000000011oo`8004Eoo`<0011oo`800003
Ool0000000Uoo`40000000<007ooOol077oo00<007oo0000Egoo0`0000=oo`00Ool03Goo00@007oo
0000015oo`03001oo`0001=oo`8004Eoo`<001=oo`8000Uoo`40000000<007ooOol01Woo1P003goo
0P0000=oo`000000EWoo00<007oo00000P004Goo10003Woo00<007oo00000`003goo1000@goo1000
47oo1@002Goo0@0000000`00Oomoo`06Ool30002Ool00`00Oomoo`0=Ool300000goo001oo`13Ool0
0`00Oomoo`0@Ool200000goo001oo`0=Ool200000goo00000002000>Ool300000goo0000000?Ool4
0013Ool3000@Ool20002Ool20009Ool100000003001oogoo00Uoo`03001oogoo011oo`03001oogoo
04Eoo`03001oogoo00moo`8000=oo`03001oogoo02Eoo`03001oogoo00eoo`<004Aoo`800003Ool0
07oo015oo`03001oogoo00Uoo`40000000<007ooOol01Woo00<007oo00000Woo00<007ooOol03Goo
00<007oo00000P00@goo0`003goo0`0000Aoo`00000000eoo`800005Ool00000Ool0000=Ool00`00
Oomoo`02Ool2000?Ool01000Ool00000@goo00@007oo000000moo`800005Ool00000Ool00008Ool1
00000003001oogoo00Eoo`07001oo`00Ool007oo00003Woo0P0000Aoo`00000004=oo`<000moo`04
001oogooOol2000>Ool300001Goo001oogoo000037oo1@0000=oo`00Ool03Woo1000@goo10004Goo
00<007ooOol00P0027oo0@0000000`00Oomoo`06Ool01000Oomoogoo0`003Goo00D007oo001oo`00
04Aoo`80019oo`80011oo`03001oogoo00800003Ool0000000eoo`03001oogoo009oo`03001oogoo
06Moo`03001oogoo00<000Uoo`40000000<007ooOol01Goo00P007oo000007oo001oo`003Goo0`00
00=oo`0000004Goo00<007ooOol0<7oo0P003goo00<007ooOol00Woo0P003Goo00<007oo00000Woo
00<007oo000037oo0`0000=oo`0000000P003Goo1P00@Woo1@003Woo0`0000Aoo`00000000Qoo`40
000000<007ooOol01Goo0`000goo00<007ooOol03Woo0P0000=oo`00Ool03goo0P00<7oo00@007oo
000000moo`03001oogoo00800003Ool007oo00aoo`8000=oo`<000aoo`04001oogoo0003Ool00`00
Oomoo`0;Ool2000017oo00000000@Woo00<007ooOol00P003Woo00L007ooOomoo`00Ool00008Ool1
00000003001oogoo00Ioo`8000=oo`03001oogoo00aoo`03001oogoo01=oo`<002moo`800003Ool0
0000015oo`04001oo`00000=Ool01000Ool000000Woo00<007ooOol03Woo00<007ooOol03goo00@0
07oo000004=oo`04001oo`00000@Ool01`00Oomoogoo001oo`0000Qoo`40000000<007ooOol01Goo
00@007ooOomoo`@000eoo`<00003Ool00000011oo`03001oogoo02moo`<0011oo`<0015oo`800003
Ool00000009oo`03001oogoo00Yoo`04001oo`00Ool200000goo001oo`0<Ool01P00Oomoo`00Ool0
049oo`03001oogoo008000moo`<000]oo`40000000<007ooOol01Goo1@0000=oo`0000003Goo0P00
00=oo`00Ool04Goo0`00;goo00<007oo00000P003Woo0P0000=oo`00Ool00`0037oo00@007ooOomo
o`@000aoo`05001oogoo001oo`03000=Ool01P00Ool00000Ool0045oo`06001oo`00001oo`003Goo
0`0017oo00<007ooOol01Woo0@0000000`00Oomoo`0`Ool2000`Ool01@00Oomoogoo000047oo00<0
07oo00000Woo00<007ooOol02Woo0P0017oo0P0037oo00<007ooOol00goo0P003Goo00<007ooOol0
0Woo00<007ooOol0?goo00<007ooOol00Woo00<007ooOol02goo0`0000Aoo`00Ool000Uoo`400000
00<007ooOol01Goo0P000Woo00@007oo000000ioo`03001oo`0000<000ioo`<00003Ool007oo02eo
o`03001oo`00008000ioo`07001oogooOol007oo00003Goo0P0000Eoo`00001oo`0000eoo`<0009o
o`<000eoo`80009oo`80015oo`03001oogoo01]oo`80011oo`80009oo`8000eoo`8000=oo`@000Mo
o`40000000<007ooOol01Goo00@007ooOol000=oo`03001oogoo00Yoo`@0009oo`8000ioo`800003
Ool007oo02eoo`<00003Ool0000000ioo`04001oo`00Ool2000=Ool200000goo00000003Ool00`00
Oomoo`0:Ool00`00Ool000020002Ool00`00Oomoo`0:Ool00`00Oomoo`04000@Ool2000MOol2000@
Ool00`00Ool0000200000goo001oo`0;Ool00`00Oomoo`060007Ool100000003001oogoo00Aoo`05
001oo`00001oo`04000<Ool20003Ool00`00Ool0000>Ool5000]Ool400000goo001oo`0=Ool01000
Oomoo`000Woo0P002goo0`000Woo00@007oo000000aoo`<00003Ool0000000ioo`<000=oo`8000mo
o`<001]oo`@000moo`8000=oo`8000ioo`03001oogoo009oo`8000Moo`40000000<007ooOol017oo
00@007ooOol000Aoo`8000eoo`03001oogoo015oo`05001oogooOol0000cOol00`00Oomoo`0;Ool0
0`00Oomoo`0FOol00`00Oomoo`0COol00`00Oomoo`0=Ool01@00Oomoogoo00003goo00<007ooOol0
;Woo00<007oo000047oo00@007ooOomoo`8000Yoo`40000000<007ooOol017oo0P0000Aoo`00001o
o`@000]oo`03001oogoo00<00003Ool007oo00eoo`<00003Ool007oo02aoo`D00003Ool007oo00ao
o`800006Ool00000001oo`002goo00<007ooOol01P0037oo00D007ooOomoo`00009oo`03001oogoo
00]oo`06001oogoo001oo`003goo10006goo10003goo00D007ooOol007oo008000aoo`04001oogoo
0003Ool00`00Oomoo`06Ool100000003001oogoo00Eoo`80019oo`04001oo`000002Ool2000>Ool2
00000goo0000000LOol00`00Oomoo`0>Ool20004Ool00`00Oomoo`0:Ool300000goo001oo`03000;
Ool00`00Oomoo`03Ool00`00Ool0000;Ool200000goo00000002Ool2000<Ool00`00Oomoo`020002
Ool00`00Oomoo`0<Ool01000Ool000006goo0P0000=oo`00Ool03Woo00L007oo001oo`00Ool0000<
Ool30002Ool40007Ool100000003001oogoo00Aoo`04001oogoo0005Ool00`00Oomoo`09Ool00`00
Oomoo`04Ool00`00Oomoo`0<Ool200000goo0000000KOol2000DOol2000@Ool00`00Oomoo`02Ool0
0`00Oomoo`0:Ool30003Ool00`00Oomoo`0>Ool01000Ool000003Goo0`0000=oo`0000004goo00<0
07ooOol06Woo0P0047oo0P0000=oo`0000000P003Goo00D007ooOomoo`0000Yoo`40000000<007oo
Ool017oo00<007ooOol00Woo0P000Woo00<007ooOol02Goo1@0000=oo`0000003Goo0`000Woo00<0
07ooOol06Goo0P0047oo1`0037oo10000Woo0`002goo0P000Woo00D007ooOomoo`0000eoo`03001o
ogoo00@000aoo`@00004Ool00000000>Ool5000IOol200000goo0000000>Ool300000goo00000002
000<Ool01000Ool000000Woo00<007ooOol01goo0@0000000`00Oomoo`04Ool50002Ool2000<Ool3
0002Ool00`00Ool0000=Ool00`00Oomoo`03000KOol3000?Ool01000Ool007oo0`003Goo00<007oo
Ool00P000Woo00<007ooOol02Woo0P0000Eoo`00000007oo008000Yoo`<00003Ool007oo009oo`03
001oogoo00Yoo`8000=oo`03001oo`0000ioo`03001oo`00008001Uoo`D000ioo`8000=oo`03001o
o`0000aoo`80009oo`03001oo`00008000Moo`40000000<007ooOol017oo00<007ooOol00Woo00D0
07ooOomoo`0000]oo`03001oogoo00=oo`03001oogoo00aoo`03001oogoo009oo`03001oogoo01Yo
o`8000moo`03001oogoo00=oo`03001oogoo00]oo`03001oo`0000Aoo`03001oogoo00Uoo`03001o
o`0000Aoo`03001oo`0001=oo`03001oogoo011oo`03001oogoo00eoo`03001oogoo01eoo`8001=o
o`03001oo`0000]oo`04001oogoo0003Ool00`00Oomoo`07Ool100000003001oogoo00]oo`<000Yo
o`06001oogoo001oo`000goo00<007ooOol02goo0`0000=oo`0000006Goo10003goo1@003Woo00<0
07ooOol00Woo0P0000=oo`00Ool02Woo00<007ooOol01Woo00<007ooOol027oo0P000Woo00D007oo
001oo`0000aoo`P000eoo`800004Ool00000000JOol200000goo0000000>Ool400000goo0000000<
Ool01000Oomoogoo0`0000=oo`00Ool01Woo0@0000000`00Oomoo`04Ool30002Ool01@00Oomoogoo
00002Woo0P0000Ioo`00001oo`00Ool2000<Ool7000@Ool00`00Oomoo`07Ool3000?Ool00`00Ool0
0003Ool00`00Oomoo`0:Ool2000017oo001oo`000Woo00<007ooOol037oo0P000Woo0`002Woo1000
00Aoo`00001oo`8000]oo`8000Aoo`8000eoo`H001Uoo`H000eoo`8000Aoo`<000Yoo`<00005Ool0
07oo001oo`030006Ool100000003001oogoo00Eoo`800003Ool007oo00=oo`03001oogoo00Qoo`80
00Ioo`03001oogoo00]oo`03001oogoo01=oo`<000Moo`04001oo`00000?Ool200001Goo001oogoo
00003Woo00<007ooOol03Woo00<007ooOol00P0000=oo`00Ool00P002goo00<007ooOol05Goo00D0
07ooOomoo`0000eoo`<001moo`8000ioo`04001oogoo000BOol30003Ool00`00Oomoo`05Ool10000
0003001oogoo00Aoo`800004Ool007ooOol2000=Ool01000Oomoo`004Goo00@007oo001oo`<000mo
o`<000Moo`<00003Ool007oo00eoo`800003Ool007oo008000aoo`<00004Ool007ooOol2000:Ool3
0002Ool01000Ool007oo0P002goo00<007ooOol00P0000Aoo`00Ool000]oo`80009oo`04001oogoo
000?Ool01000Ool000006Goo0P0000=oo`00Ool03Woo0`0000Ioo`00Ool007oo000:Ool00`00Ool0
0005Ool00`00Oomoo`06Ool100000003001oogoo00Ioo`800004Ool007ooOol3000:Ool20002Ool5
000<Ool00`00Oomoo`02Ool2000?Ool30007Ool5000>Ool20002Ool01000Ool000002goo00<007oo
00000Woo0P0000=oo`0000002Woo00<007ooOol00Woo0P000Woo00<007ooOol027oo00L007ooOol0
07oo001oo`03000;Ool00`00Ool00005000=Ool2000017oo001oo`006goo10003Goo100000=oo`00
00000P002Woo0`000Woo0P000goo00<007ooOol017oo0@0000000`00Oomoo`04Ool00`00Oomoo`0A
Ool40003Ool00`00Ool0000?Ool2000BOol00`00Oomoo`07Ool00`00Ool0000>Ool20002Ool01000
Ool000003Goo00<007ooOol00goo00<007ooOol02goo00<007ooOol00goo00<007ooOol02Woo00<0
07ooOol01Woo00<007ooOol02Goo00<007oo00000Woo00<007oo00003Goo00@007oo001oo`<001Qo
o`04001oogoo000?Ool00`00Ool00002Ool00`00Ool0000;Ool01000Oomoo`001Goo00<007ooOol0
1Goo0@0000000`00Oomoo`04Ool02000Oomoogoo001oo`00Ool30009Ool50002Ool3000;Ool30000
0goo001oo`02000?Ool40005Ool400000goo001oo`0<Ool00`00Oomoo`03000=Ool20003Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool200000goo000000020003Ool00`00Oomoo`07Ool00`00Ool00002
00000goo001oo`03000:Ool2000017oo000000000Woo00<007ooOol02goo0P0000=oo`00Ool00P00
67oo0`0000=oo`0000003Goo0P000Woo00D007oo001oo`0000Yoo`80009oo`03001oogoo00@000Io
o`40000000<007ooOol017oo00<007ooOol00P000Woo00<007oo00003Woo00@007ooOomoo`8000]o
o`800004Ool007ooOol2000?Ool30006Ool01P00Ool00000Ool000eoo`<000Aoo`8000Yoo`800008
Ool00000001oo`00Ool000Yoo`800003Ool007oo009oo`04001oo`000009Ool400000goo001oo`04
000:Ool30003Ool4000<Ool200001Goo000007oo00001Woo0P0027oo00<007ooOol01Goo0P000Woo
00<007ooOol02goo10000Woo00@007ooOol000Yoo`800005Ool007ooOol00002Ool20006Ool10000
0003001oogoo00=oo`<000Qoo`03001oogoo00Moo`03001oogoo009oo`03001oogoo008000aoo`80
0003Ool007oo0080019oo`03001oogoo00Ioo`03001oogoo00eoo`04001oogoo0003Ool2000:Ool0
0`00Ool00006Ool00`00Oomoo`08Ool00`00Ool00002000@Ool00`00Oomoo`03Ool01000Oomoo`00
4goo00<007ooOol02Goo0P0000=oo`00Ool00Woo00<007ooOol017oo0P0027oo00<007ooOol01Goo
1`002goo0P004Woo00<007oo00000Woo00<007oo00002Goo0@0000000`00Oomoo`03Ool50002Ool4
000:Ool2000017oo001oogoo0P003Goo00<007ooOol00`0000=oo`00Ool03Goo1@001Goo00@007oo
Oomoo`80015oo`8000eoo`03001oogoo00=oo`800003Ool0000000Uoo`8000=oo`03001oo`0000@0
00Qoo`@0009oo`04001oogoo000;Ool00`00Oomoo`0200000goo00000002000;Ool200000goo001o
o`020006Ool30007Ool30006Ool200000goo001oo`02000;Ool00`00Oomoo`0200001Goo000007oo
00003Woo00@007ooOomoo`<000Ioo`40000000<007ooOol017oo0P000goo00@007ooOomoo`8000Yo
o`03001oo`0000Aoo`<000Yoo`8000Aoo`03001oogoo00eoo`D000Eoo`L000aoo`@0009oo`<000Yo
o`<00004Ool000000003Ool00`00Oomoo`07Ool00`00Oomoo`03Ool01P00Ool00000Ool000Qoo`03
001oogoo009oo`03001oogoo009oo`8000Uoo`<00003Ool0000000=oo`03001oogoo00Yoo`800005
Ool00000Ool00005Ool40006Ool30005Ool20002Ool2000=Ool01000Ool007oo0P000Woo0P002Goo
0P0000Moo`00001oo`00Ool00002Ool00`00Oomoo`04Ool100000003001oogoo00Ioo`03001oo`00
00moo`05001oogooOol00004Ool2000;Ool20002Ool01000Ool000003Goo00<007ooOol00P001Goo
0P0000=oo`00Ool00P0037oo00<007oo00000goo00<007ooOol02goo0P001Goo0P002goo00@007oo
001oo`800004Ool000000009Ool00`00Oomoo`04Ool00`00Oomoo`020009Ool20006Ool00`00Oomo
o`0:Ool01000Oomoogoo0P0000=oo`00Ool017oo0`001goo0`001Goo0P0000=oo`00Ool00Woo00<0
07ooOol02goo00<007ooOol00Woo0`002Goo00<007ooOol01Goo00@007ooOol000Ioo`40000000<0
07ooOol00goo0P0017oo0P0000Aoo`00Ool000Uoo`<0009oo`800004Ool007oo000:Ool40003Ool2
000=Ool60004Ool00`00Ool00003Ool00`00Oomoo`0:Ool20002Ool00`00Oomoo`02000:Ool20000
1Woo000007oo001oo`<000Uoo`03001oogoo00Qoo`03001oogoo00Ioo`03001oogoo00<000=oo`03
001oo`0000Uoo`<000Aoo`<000]oo`D0009oo`03001oogoo00=oo`@000Ioo`<000Eoo`04001oo`00
Ool200000goo001oo`0:Ool200000goo001oo`03Ool2000:Ool30002Ool2000017oo001oo`001Woo
0@0000000`00Oomoo`03Ool200000goo001oo`0AOol200001Woo001oogoo001oo`8000Yoo`<0009o
o`800003Ool007oo00Aoo`8000Ioo`80009oo`03001oogoo00=oo`05001oo`00001oo`02000<Ool0
0`00Ool00002Ool4000:Ool01000Ool000000Woo00<007oo00000P0027oo1@0017oo00<007oo0000
2Goo0`0000Aoo`00Oomoo`D000Uoo`04001oogooOol2000017oo000000002goo0`0017oo00<007oo
Ool00Woo1@001Goo1@0017oo00D007ooOol007oo00<000]oo`<00003Ool00000008000]oo`D0009o
o`03001oogoo008000Ioo`40000000<007ooOol00goo0P0017oo00<007oo000037oo00<007oo0000
0goo10002goo00T007ooOomoo`00Ool007oo00001Goo0P001Woo00@007oo001oo`8000=oo`80009o
o`<000eoo`03001oogoo00Eoo`03001oogoo00Qoo`03001oogoo00Ioo`8000Yoo`800003Ool00000
00Eoo`03001oogoo00Ioo`03001oo`0000=oo`03001oo`0000aoo`04001oogoo0002Ool01000Oomo
o`002goo0P000Woo100017oo0`0000=oo`00Ool017oo00<007oo00000P0017oo0`000Woo0`002goo
00@007ooOol000Eoo`03001oogoo00Qoo`05001oogooOol00004Ool00`00Oomoo`05Ool100000003
001oogoo00=oo`03001oogoo00<00003Ool007oo00<000Uoo`80009oo`05001oogoo001oo`02000:
Ool00`00Ool00002000017oo000000001Goo0P001Woo1@0017oo0`000Woo0`003Woo0`000Woo00<0
07ooOol02Goo00<007ooOol00Woo00D007oo000007oo008000Moo`@00003Ool007oo00@00003Ool0
07oo00Moo`<0009oo`80009oo`<000Uoo`04001oo`00Ool400000goo001oo`0:Ool200000goo0000
00030004Ool50005Ool300000goo001oo`03Ool4000017oo001oo`002goo00<007oo00000P0000=o
o`0000000Woo00<007ooOol01goo00@007ooOomoo`80009oo`<000Ioo`40000000<007ooOol01Goo
00<007oo000017oo0`0027oo00<007ooOol00P0000Moo`00Oomoo`00Ool0000:Ool20004Ool30004
Ool30005Ool3000017oo0000000017oo1@0000=oo`00Ool02Woo0P000Woo00@007oo001oo`8000Yo
o`800005Ool007ooOol00002Ool30007Ool30003Ool30003Ool00`00Oomoo`05Ool20002Ool20000
17oo001oo`000Woo00<007ooOol01Woo0`001goo00<007ooOol02Goo00@007oo0000009oo`8000Ao
o`03001oo`00008000Eoo`<00003Ool007oo00=oo`<00005Ool00000Ool0000;Ool00`00Oomoo`06
Ool20008Ool01@00Ool007oo000017oo00@007oo000000Eoo`40000000<007ooOol00goo0`000goo
00<007oo00000Woo0P001goo0`000Woo00@007ooOol0009oo`03001oogoo00Moo`<0009oo`80009o
o`03001oogoo009oo`@000Aoo`L000=oo`D00003Ool0000000]oo`<000=oo`05001oo`00Ool00008
Ool500000goo001oo`04Ool00`00Oomoo`06Ool01000Oomoo`001Goo0`001goo00D007ooOomoo`00
00Moo`03001oogoo00Ioo`<00003Ool0000000800003Ool0000000]oo`08001oogoo001oo`00Ool0
00Aoo`<00003Ool007oo00Aoo`D000Aoo`03001oogoo00Aoo`8000Yoo`800003Ool007oo00800004
Ool000000008Ool20004Ool40002Ool00`00Oomoo`03Ool100000003001oogoo009oo`8000Uoo`03
001oogoo00Moo`03001oogoo01Ioo`800004Ool007oo0004Ool00`00Ool00005Ool00`00Ool00003
Ool00`00Oomoo`05Ool00`00Ool0000=Ool200001Woo001oogoo001oo`8000Uoo`03001oogoo00Ao
o`03001oo`0000Uoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Moo`03001oo`000080
00=oo`04001oogoo0008Ool01000Oomoo`005goo00<007oo000017oo0`0000=oo`00Ool017oo00<0
07oo00000P0017oo00D007ooOomoo`00009oo`03001oogoo00Uoo`8000Ioo`8000Uoo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo00Aoo`40000000<007ooOol00Woo10000Woo00<007oo0000
0goo00<007ooOol01Woo00@007oo001oo`80009oo`@000Uoo`@000Aoo`8000Aoo`@000Aoo`@00003
Ool0000000=oo`800004Ool007ooOol20005Ool20007Ool01000Ool000000Woo0P0027oo100000=o
o`0000000Woo10001goo00<007ooOol00P0000=oo`0000000P0000Aoo`00000000Ioo`<000Aoo`80
0004Ool000000009Ool00`00Ool00003Ool5000:Ool300001Goo001oogoo000017oo00H007oo0000
07oo0003Ool400000goo001oo`03Ool400000goo000000020009Ool40003Ool40009Ool50003Ool0
0`00Oomoo`020005Ool100000003001oogoo009oo`800003Ool000000080009oo`80009oo`03001o
ogoo00Eoo`<000=oo`800004Ool000000009Ool200001Woo001oogoo001oo`8000Aoo`@000Aoo`03
001oogoo00@000=oo`03001oo`0000<00003Ool007oo00=oo`<000Aoo`D0009oo`@0011oo`800003
Ool0000000Moo`<00003Ool007oo00=oo`D000Qoo`08001oogooOol007oo001oo`8000Uoo`<00003
Ool00000009oo`@000Yoo`800004Ool00000Ool30003Ool00`00Ool000030003Ool70002Ool30002
Ool300000goo001oo`08Ool2000017oo000000000Woo100027oo0`0000Eoo`00Oomoo`00009oo`03
001oogoo00Eoo`40000000<007ooOol00Woo0P002goo00<007ooOol01Goo00<007ooOol00P0017oo
00<007oo00002Goo00@007ooOomoo`800004Ool000000003Ool300000goo001oo`03Ool200001Goo
001oogoo000017oo1@001goo00<007ooOol017oo00<007ooOol01Woo00<007ooOol01Woo0P0000=o
o`00Ool017oo00@007ooOol000Moo`<000Yoo`03001oogoo00Aoo`<00003Ool007oo00Ioo`8000Mo
o`03001oogoo00=oo`03001oogoo00eoo`03001oo`0000Uoo`800003Ool0000000Eoo`03001oo`00
00<000=oo`03001oo`0000Aoo`8000moo`04001oogooOol20008Ool00`00Ool00003Ool01`00Oomo
ogoo001oo`0000Eoo`40000000<007ooOol00Woo00@007oo001oo`80009oo`03001oogoo00<000Mo
o`D000=oo`03001oogoo008000Qoo`04001oo`000002Ool50002Ool2000017oo000000000goo0P00
0Woo00<007oo00000goo00<007oo00000goo0P0017oo10000goo0P0000Ioo`00Ool007oo0002Ool0
0`00Oomoo`07Ool20003Ool20002Ool00`00Ool00008Ool20002Ool00`00Oomoo`0300000goo0000
0006Ool01000Oomoo`000goo00<007oo00000Woo0P001goo100000Ioo`00Oomoo`00Ool20009Ool2
0003Ool50003Ool300000goo00000003Ool00`00Ool000040002Ool01`00Oomoogoo001oo`00009o
o`03001oogoo00Moo`80009oo`80009oo`04001oo`000008Ool2000017oo001oo`000Woo1@001Goo
0@0000000`00Oomoo`02Ool20005Ool200000goo000000020007Ool00`00Oomoo`02Ool20004Ool2
0008Ool20003Ool00`00Oomoo`02Ool00`00Oomoo`060003Ool500000goo001oo`02Ool300000goo
00000006Ool40003Ool00`00Oomoo`02Ool2000017oo0000000027oo00<007ooOol00`000goo00@0
07ooOol000Moo`03001oogoo00800003Ool007oo00Eoo`03001oogoo00Eoo`04001oo`000003Ool2
0003Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Ool0000:Ool200000goo0000000200000goo
00000003Ool60003Ool400000goo00000002Ool40002Ool01000Ool000002Woo0P001Goo00@007oo
Ool000Qoo`0:001oogooOol007oo001oo`00Ool30005Ool100000003001oogoo009oo`<000=oo`03
001oogoo00aoo`03001oogoo00Aoo`05001oogooOol0000;Ool20003Ool00`00Ool00005Ool01000
Oomoo`001Goo0P0000=oo`0000000goo00<007ooOol00P0000Aoo`00000000=oo`800003Ool007oo
009oo`@000Aoo`<000Yoo`03001oo`00009oo`04001oogooOol30009Ool01@00Oomoogoo00000goo
0`001Woo0P0017oo00@007ooOomoo`<000Uoo`<00004Ool007oo0008Ool00`00Oomoo`02Ool20002
Ool00`00Oomoo`02Ool01P00Oomoogoo001oo`@000Aoo`80009oo`03001oogoo009oo`03001oogoo
008000=oo`03001oogoo009oo`03001oogoo00Eoo`03001oo`00009oo`03001oogoo00Uoo`04001o
ogoo0005Ool01000Oomoo`001Goo0@0000000`00Oomoo`02Ool500000goo00000002Ool01000Ool0
00001goo0P0000Aoo`00Ool0009oo`D000Qoo`80009oo`80009oo`<0009oo`H0009oo`<000=oo`<0
009oo`8000Aoo`<000=oo`04001oo`000004Ool200000goo001oo`02Ool30008Ool30002Ool01000
Oomoogoo1@001Goo0P0000Eoo`00000007oo00800003Ool0000000<000Ioo`03001oo`00009oo`80
0003Ool00000009oo`8000Moo`<00003Ool007oo00800004Ool000000003Ool30003Ool300001Woo
001oo`00Ool000=oo`L000=oo`L000=oo`<00003Ool007oo00<000Aoo`8000=oo`<00003Ool007oo
00800004Ool000000008Ool300001Goo001oogoo00000goo0`0017oo0@0000000`00Oomoo`05Ool2
0004Ool300000goo001oo`05Ool50003Ool01000Oomoo`002Woo0`000goo0P001Goo0P0000Aoo`00
0000009oo`L00004Ool007ooOol200001Goo00000000Ool00P000goo0P0000=oo`00Ool00Woo0P00
0goo0P000goo00<007ooOol01Woo0P001Goo0P0000=oo`00Ool00P001Goo0`001goo0P0000=oo`00
00001Woo00@007ooOomoo`8000Eoo`03001oo`0000Ioo`<000=oo`80009oo`<000=oo`<000=oo`80
009oo`03001oo`0000<0009oo`<00004Ool000000003Ool00`00Oomoo`040002Ool400001Woo001o
o`00Ool000=oo`<000=oo`<0009oo`06001oo`00Ool007oo0P001Woo0`0017oo0P0017oo0P0017oo
0@0000000`00Oomoo`02Ool01P00Ool00000Ool000Ioo`8000Moo`80009oo`8000Eoo`03001oogoo
00Moo`03001oo`00009oo`800004Ool000000003Ool20002Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20003Ool300000goo001oo`020003Ool50004Ool00`00Ool00002Ool20002Ool00`00Oomoo`05
Ool2000017oo001oo`0017oo00<007ooOol027oo00D007ooOomoo`0000Aoo`8000Qoo`03001oogoo
00Aoo`04001oogooOol30006Ool01@00Ool007oo00001Woo00<007ooOol00Woo0`000goo00@007oo
Ool0009oo`03001oogoo00=oo`8000Aoo`80009oo`07001oo`00Ool007oo00000goo0P000goo0P00
00=oo`00Ool00Woo00<007oo00001Woo00<007ooOol00goo0P0000=oo`00Ool01Goo0P0017oo00D0
07ooOomoo`00009oo`8000Aoo`40000000@007ooOomoo`<000Eoo`8000=oo`8000Ioo`800005Ool0
07oo001oo`0200000goo001oo`020008Ool00`00Oomoo`030003Ool20002Ool00`00Ool000030002
Ool3000017oo000007oo0P000Woo00<007oo00000Woo0P0017oo0P0000Eoo`00000007oo00800003
Ool007oo009oo`03001oogoo00<000Ioo`800006Ool00000001oo`001Goo0P001Goo0`000Woo0`00
00=oo`00Ool00goo00<007ooOol017oo10000goo00D007oo000007oo008000Ioo`8000=oo`04001o
o`00Ool40002Ool50002Ool400000goo001oo`030002Ool400001Goo00000000Ool00`0000=oo`00
00000P000Woo0P000Woo0`0000=oo`0000000goo10000Woo0P000Woo00<007ooOol00Woo00@007oo
000000Ioo`800003Ool007oo00<00003Ool0000000@000Aoo`40000000@007ooOomoo`<000=oo`80
009oo`04001oo`000007Ool200001Goo001oogoo00000goo00@007oo000000=oo`8000=oo`04001o
o`000003Ool01@00Ool00000Ool0100000=oo`0000000Woo100000Aoo`000000009oo`03001oo`00
00@0009oo`03001oogoo00H00005Ool00000001oo`020004Ool30006Ool200000goo00000003Ool0
1000Ool007oo0`001Goo0P0000=oo`00Ool00goo0P000goo0P001Goo0P0000=oo`00Ool00`000goo
10001Woo00<007ooOol00P0000=oo`00Ool00P0000=oo`00Ool00Woo1@000Woo0P0000Eoo`000000
07oo00<0009oo`800003Ool0000000<00005Ool00000Ool00003Ool00`00Oomoo`0200000goo001o
o`03Ool20003Ool40005Ool00`00Oomoo`03000017oo001oo`001Woo0P0000=oo`0000001goo0`00
17oo0@0000002`00Oomoogoo001oo`00Ool007oo000017oo00<007ooOol00P001Woo0P001goo00@0
07oo000000=oo`8000=oo`03001oogoo00=oo`05001oo`00Ool00003Ool00`00Ool00002Ool01@00
Ool007oo00000goo00@007oo001oo`8000Ioo`80009oo`05001oogooOol00002Ool00`00Ool00003
Ool400000goo001oo`06Ool00`00Oomoo`02Ool00`00Oomoo`02Ool200000goo00000006Ool01000
Ool000000Woo0P0000=oo`00Ool00Woo00<007ooOol00goo0`001Goo00@007oo0000009oo`03001o
ogoo00Aoo`03001oo`0000Ioo`03001oogoo00800003Ool00000008000Aoo`8000Aoo`03001oogoo
009oo`@0009oo`80009oo`8000=oo`8000Moo`800003Ool007oo00=oo`@0009oo`03001oo`0000Eo
o`03001oogoo008000Ioo`8000Ioo`800003Ool007oo008000Aoo`40000000<007ooOol00Woo00@0
07oo000000=oo`03001oogoo00800003Ool0000000Eoo`03001oo`0000<000=oo`05001oo`00Ool0
0002Ool30002Ool300001Goo00000000Ool00P0000=oo`00Ool00`0000=oo`0000000P0000Aoo`00
Oomoo`800007Ool00000001oo`00Ool00P0000=oo`0000000`000Woo1P0000Aoo`000000009oo`04
001oogooOol40006Ool30004Ool01@00Ool00000Ool00`001Goo10001goo10001Goo00L007ooOomo
o`00Ool00005Ool00`00Ool00006Ool30002Ool01000Oomoo`000Woo0`0000=oo`0000000`000Woo
100000Aoo`00001oo`<00003Ool0000000<00005Ool00000Ool00002Ool300000goo000000020000
1Goo00000000Ool010000Woo1@000Woo0P000Woo00@007ooOol0009oo`<000Ioo`04001oo`00Ool2
00000goo001oo`05Ool00`00Oomoo`02Ool100000004001oogooOol2000017oo001oo`000goo0P00
0Woo0`001Goo0`0000Aoo`00001oo`8000=oo`80009oo`<0009oo`@000=oo`03001oogoo00800003
Ool0000000<00004Ool00000Ool40002Ool300001Goo00000000Ool00P0000Aoo`00Ool0009oo`H0
0005Ool00000Ool00004Ool200000goo00000007Ool01000Ool007oo0`0000Aoo`00Oomoo`<000Eo
o`03001oogoo009oo`8000=oo`04001oo`00Ool20004Ool200000goo001oo`03Ool20003Ool20006
Ool200001Goo000007oo00000goo100000=oo`0000000`0000Aoo`000000009oo`04001oogooOol3
00001Goo00000000Ool0100000=oo`0000002P0017oo1@0000=oo`0000000`000Woo0`0000=oo`00
00000goo10001Woo0`0000Aoo`00Ool000Aoo`@000Aoo`40000000L007ooOomoo`00Ool00003Ool2
0002Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`03Ool3000017oo000000000Woo0`00
0goo00@007oo000000Aoo`03001oogoo00Ioo`80009oo`80009oo`03001oogoo00800004Ool00000
0009Ool01000Ool007oo0P0000Qoo`00Ool007oo001oo`000goo00<007oo00000Woo0P000Woo00D0
07oo001oo`0000Qoo`8000Eoo`80009oo`03001oogoo009oo`8000=oo`8000Aoo`@000Ioo`03001o
o`00008000Ioo`04001oogoo0003Ool01000Ool000000Woo00X007oo001oo`00Ool007oo001oo`80
009oo`03001oo`00009oo`03001oogoo00Eoo`800003Ool007oo008000Eoo`04001oo`000002Ool0
0`00Oomoo`02Ool00`00Ool000040002Ool00`00Ool00003Ool01`00Ool007oo001oo`0000Ioo`<0
009oo`06001oogoo001oo`000Woo0P0017oo0@0000001@00Oomoogoo000017oo00<007oo00000goo
1@001Goo0P0000Aoo`00Ool000Aoo`800004Ool007ooOol400000goo00000003Ool200000goo0000
000700002Goo00000000Ool007oo001oo`0200000goo00000003Ool200001Goo00000000Ool00P00
00=oo`000000100000Aoo`00001oo`800006Ool00000Ool007oo0P000Woo0P000Woo0P0000=oo`00
Ool00goo00@007ooOol0009oo`03001oogoo00=oo`@000=oo`8000Aoo`<000Aoo`<00005Ool00000
Ool00003Ool00`00Ool000020005Ool500000goo001oo`02Ool400000goo0000000300000goo0000
0005Ool500000goo0000000200001Goo001oo`00Ool00P000Woo1`0000=oo`0000000P0000=oo`00
Ool00P0000=oo`0000000`000Woo100000=oo`00Ool00Woo00@007oo000000Ioo`04001oo`000005
Ool00`00Oomoo`040003Ool100000004001oogooOol500000goo001oo`03Ool00`00Ool000020004
Ool200001Woo00000000Ool0009oo`03001oo`0000800003Ool0000000<00006Ool00000Ool007oo
0P0000=oo`0000002@0000Eoo`00Ool007oo00<00005Ool00000001oo`0200001Woo000007oo001o
o`X00003Ool0000000=oo`04001oogooOol400000goo0000000200000goo00000003Ool01@00Oomo
o`00Ool00`0000=oo`00Ool017oo0`0000Aoo`00Ool0009oo`03001oo`0000@000Aoo`04001oogoo
0004Ool01P00Ool007oo001oo`8000Eoo`8000=oo`04001oogoo0003Ool200000goo000000030002
Ool500000goo00000002Ool:00000goo00000003000017oo000000000Woo0`000goo100000=oo`00
Ool01P000goo00D007ooOomoo`00009oo`<000Eoo`80009oo`05001oogoo001oo`020002Ool30003
Ool100000004001oogooOol20007Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00001Goo00<0
07ooOol00goo0`0000=oo`00Ool010000goo00@007ooOomoo`<00004Ool007oo0002Ool40003Ool3
0002Ool20008Ool20002Ool02000Ool00000Ool007oo0007Ool200000goo0000000300000goo0000
0003Ool00`00Ool00005Ool20004Ool2000=Ool20004Ool20003Ool00`00Oomoo`06Ool20005Ool3
00000goo00000007Ool00`00Ool000030002Ool30007Ool40006Ool01000Ool000000goo1P0017oo
0P0000Eoo`00000007oo00D00005Ool00000001oo`020007Ool20004Ool20003Ool30004Ool20000
0goo00000003Ool100000004001oogooOol30002Ool00`00Oomoo`0200000goo00000002Ool00`00
Oomoo`02Ool30002Ool00`00Oomoo`0200000goo0000000200000goo0000000300001goo00000000
Ool007oo00P00004Ool00000Ool6000017oo001oo`000Woo1`0000=oo`0000002P0000=oo`00Ool0
0P0000=oo`0000000P000goo1P0000=oo`0000000`0000=oo`00Ool00Woo00<007oo00000`000goo
0P000Woo0`0000Aoo`00Oomoo`800004Ool000000003Ool50005Ool700000goo00000002Ool01000
Ool000000Woo200000=oo`0000000`0000Aoo`00Oomoo`80009oo`H00003Ool0000000`0009oo`@0
0003Ool0000000=oo`04001oo`00Ool:0002Ool300000goo00000003000017oo000007oo1@000goo
00H007ooOomoo`00Ool30003Ool100000003001oogoo00800004Ool000000002Ool01@00Oomoo`00
Ool01@000goo10000goo00H007oo001oo`00Ool800001Goo001oo`00Ool00P000goo1P0000=oo`00
00002@0000=oo`0000001P0000=oo`00Ool00Woo3@000Woo00@007oo001oo`T00004Ool000000005
Ool01000Ool007oo10000goo1@0017oo00@007ooOomoo`800003Ool007oo009oo`800003Ool00000
00@000Eoo`<00005Ool00000001oo`02000017oo001oogoo0P000goo0`0000=oo`0000002`0000Ao
o`00001oo`D0009oo`T00003Ool0000000D0009oo`03001oo`0000/00008Ool007oo001oo`00Ool0
009oo`@00004Ool00000Ool500001Woo001oogoo001oo`800004Ool000000003Ool100000003001o
ogoo00<000]oo`04001oo`000003Ool20002Ool00`00Ool00008Ool20002Ool2000027oo00000000
Ool007oo0004Ool00`00Ool000030003Ool00`00Ool00005Ool200000goo00000005Ool00`00Ool0
0002000017oo000000000Woo0`002Goo200000=oo`00Ool00Woo00<007ooOol00Woo00D007oo0000
07oo008000=oo`03001oo`0000Eoo`8000Eoo`<0009oo`800003Ool007oo009oo`8000=oo`03001o
ogoo00800003Ool0000000@000Moo`04001oogooOol:0004Ool01000Oomoogoo0P0000=oo`000000
0Woo0P000Woo0P000Woo00D007oo000007oo00<000Eoo`800003Ool0000000<00003Ool007oo00<0
00]oo`800004Ool00000Ool20007Ool01P00Oomoogoo001oo`8000=oo`40000000<007ooOol00`00
00Qoo`00Oomoo`00Ool007oo0`000Woo1`0000=oo`00Ool00Woo00@007oo001oo`d00003Ool007oo
009oo`L00003Ool0000000X000=oo`D00004Ool00000Ool500000goo0000000:0003Ool00`00Oomo
o`0=0002Ool00`00Oomoo`02Ool30003Ool50005Ool00`00Oomoo`0200000goo00000002Ool50004
Ool00`00Oomoo`0@0003Ool800000goo00000002000017oo001oo`000Woo1`0000Aoo`00Oomoo`L0
009oo`03001oogoo00P0009ooa0000=ooa400004Ool007oo0002Ool40003Ool100000003001oogoo
00H000Aoo`04001oogooOol;00001Goo001oogoo00000goo4@000Woo00<007oo0000100000=oo`00
00001P0000=oo`0000001P0000Aoo`00Ool000=oo``00004Ool007ooOol300000goo000000090000
17oo001oogoo0P000Woo00@007oo001oo`800003Ool0000000@0009oo`8000=oo`03001oo`0000@0
0003Ool0000000<00003Ool00000009oo`04001oo`00Ool200000goo000000050002Ool00`00Oomo
o`0300000goo001oo`0=00001Woo000007oo001oo`P00003Ool0000000<00004Ool00000Ool50000
0goo001oo`02Ool300000goo0000000700000goo00000003Ool200001Goo001oo`00Ool02@000goo
00<007ooOol00Woo1P000Woo0@0000000`00Ool0000300001goo001oogoo001oo`00009oo`03001o
o`0000`00006Ool007ooOol007oo3@0000Ioo`00Oomoo`00Ool600000goo001oo`080002Ool80000
0goo0000000=00001Goo000007oo00000Woo00<007oo0000300000Ioo`00Oomoo`00Ool200000goo
000000070002Ool02000Oomoo`00Ool007oo0002Ool8000017oo001oo`0017oo00<007ooOol03000
00Ioo`00Oomoo`00Ool=00000goo001oo`0200000goo000000060002Ool00`00Ool0000500000goo
001oo`060002Ool01000Ool007oo1@0000=oo`0000001@0000Ioo`00Oomoo`00Ool=000027oo001o
ogoo001oo`00Ool70001Ool100000003001oo`0000800003Ool007oo00=oo`03001oogoo009oo`03
001oogoo00P000=oo`04001oogooOol20002Ool400000goo000000020002Ool01@00Oomoogoo0000
17oo0`000Woo0P0000=oo`0000000P000Woo0P000Woo0`000goo00@007ooOomoo`L0009oo`<000=o
o`03001oogoo009oo`03001oogoo00@00004Ool000000003Ool00`00Oomoo`02Ool01000Oomoogoo
200000=oo`00000017oo00@007ooOomoo`800003Ool0000000@00003Ool007oo009oo`8000=oo`80
009oo`L000=oo`03001oogoo009oo`04001oogooOol30002Ool400000goo00000003Ool01000Oomo
ogoo0`000Woo0P000Woo0`000goo0P000Woo0`000Woo0P000goo1`000Woo0P0017oo00D007ooOomo
o`0000=oo`P000=oo`03001oogoo009oo`04001oogooOol50001Ool100000003001oo`0000<0009o
o`05001oo`00Ool00002Ool00`00Ool0000;00001Goo001oogoo00000Woo300000=oo`00Ool00P00
00=oo`0000001`0000=oo`0000001P0000=oo`00Ool01P0000=oo`00Ool0400000=oo`00Ool00P00
0Woo2`0000Uoo`00Ool007oo001oo`00Ool0300000Aoo`00Oomoo`80009oo`04001oo`00Ool70000
37oo001oogoo001oo`00Ool007oo001oo`X00004Ool007oo0002Ool00`00Ool0000<00001Woo0000
07oo001oo`H00003Ool007oo00P0009oo`P00006Ool00000Ool007oo3@0000Ioo`00Oomoo`00Ool:
00001Goo000007oo00000Woo00@007oo0000009oo`@0005oo`40000000D007oo000007oo00800003
Ool0000000Aoo`04001oo`00Ool900000goo001oo`02Ool20003Ool<00001Woo00000000Ool0009o
o`d00004Ool00000Ool600001Woo001oogoo001oo`H00003Ool0000000D000=oo`800003Ool007oo
00/000=oo`03001oogoo009oo`/000=oo`03001oogoo009oo`<00004Ool000000002Ool60004Ool0
1000Oomoogoo2P000Woo00@007ooOol000=ooa000004Ool00000Ool600000goo0000000>0002Ool0
1000Ool007oo1`0000=oo`000000100000Eoo`00Oomoo`0000=oo`/00003Ool007oo009oo`03001o
ogoo00<00004Ool000000002Ool100000003001oogoo0080009oo`03001oogoo00=oo`05001oo`00
001oo`0500001Goo001oogoo000017oo00L007ooOol007oo001oo`0:0004Ool01@00Oomoo`00Ool0
10000Woo10000Woo0`0000=oo`00Ool00P000Woo0`0017oo00@007oo001oo`8000=oo`800003Ool0
07oo0080009oo`03001oo`0000T00004Ool007oo0002Ool01000Oomoo`0017oo00D007ooOomoo`00
00=oo`8000Yoo`80009oo`8000Aoo`03001oogoo009oo`<000Aoo`D000Eoo`03001oo`0000<00005
Ool00000001oo`0600000goo001oo`03Ool200001Woo00000000Ool000Aoo`<000Eoo`@00005Ool0
07ooOol00002Ool00`00Oomoo`050002Ool200000goo001oo`02Ool00`00Oomoo`030002Ool50002
Ool01000Oomoogoo0P001Woo0`000goo0@0000001@00Oomoo`00Ool00P000goo00<007ooOol017oo
1P0000=oo`0000001@000goo3@0000Aoo`00Ool0009oo`03001oo`0000D00003Ool0000000H000Eo
o`H0009oo`<00003Ool0000000T0009oo`03001oo`00009oo`03001oo`0000T0009oo`03001oo`00
009oo`03001oogoo00<00003Ool007oo009oo`@000=oo`04001oogoo0003Ool40002Ool300000goo
001oo`03Ool01000Oomoogoo100000=oo`0000000`0000Eoo`00001oo`0000Eoo`d00007Ool007oo
001oo`00Ool01@0000Aoo`00001ooa000004Ool00000Ool=000017oo0000000017oo00<007ooOol0
30000goo0P0000=oo`0000000`000goo0@0000000`00Oomoo`06000017oo000000000Woo00<007oo
00000P0017oo0`0000Eoo`00Oomoo`0000Moo`H00004Ool00000Ool40004Ool>00001Goo00000000
Ool0200000=oo`0000003P000Woo0P0000Aoo`00001oo`H00003Ool0000000800007Ool007ooOol0
07oo00000Woo0`000goo0P0000Aoo`00Ool0009oo`80009oo`<00003Ool00000009oo`800003Ool0
000000800006Ool007ooOol007oo0P0000=oo`00Ool00P0000=oo`0000000P000goo00@007oo001o
o`h00005Ool00000001oo`06000017oo000007oo0`0000Qoo`00001oo`00Ool007oo10000Woo00D0
07ooOol007oo00<00003Ool0000000L000=oo`04001oo`00Ool500000goo000000030006Ool01@00
Ool00000Ool010000goo0@0000000`00Oomoo`030003Ool00`00Oomoo`06Ool20004Ool30005Ool2
0002Ool600001goo001oogoo001oo`0000=oo`05001oo`00001oo`04000017oo001oogoo1@0000Ao
o`00Oomoo`80009oo`05001oogooOol00004Ool30002Ool60006Ool00`00Ool0000300000goo0000
000200000goo001oo`0;Ool00`00Oomoo`03Ool30007Ool200000goo000000030002Ool20004Ool0
1000Oomoo`0027oo0P0000Aoo`00000000Qoo`03001oogoo00<00003Ool0000000@00003Ool007oo
009oo`05001oogooOol00002Ool01@00Oomoogoo00001Woo00<007ooOol00P0000Eoo`00Oomoo`00
009oo`04001oogooOol2000017oo000007oo10002Goo00<007oo00000P0000=oo`0000000goo0P00
2Goo00@007oo000000=oo`40000000<007ooOol01@0000=oo`00Ool00Woo1`0017oo0P0000=oo`00
000017oo00D007oo000007oo00L00003Ool00000009oo`04001oogooOolA000017oo000007oo1@00
00=oo`00Ool00P0000=oo`0000001P0000Aoo`00Ool0009oo`<000Aoo`<00003Ool0000000800004
Ool00000Ool200000goo00000003Ool50003Ool2000017oo000007oo0P000goo00<007ooOol00`00
0goo10001Woo00<007oo0000100000=oo`0000000Woo00<007ooOol00P0000=oo`0000000P000Woo
2P0000=oo`0000000Woo00<007oo00001P0000=oo`0000000`0000=oo`00Ool03@0000Moo`000000
07oo001oo`0;00000goo000000020003Ool00`00Oomoo`02000017oo000007oo0`0000=oo`00Ool0
0Woo00<007oo00000`000goo0@0000001000Oomoogoo0P0000=oo`00Ool00goo00<007ooOol00goo
0P001Goo0`0000Aoo`00000000Aoo`@00003Ool0000000800003Ool007oo008000=oo`03001oogoo
00800003Ool0000000800007Ool00000001oo`00Ool00P0000=oo`00Ool00P0000Eoo`00000007oo
00800004Ool00000Ool800000goo00000002000017oo001oogoo0P0000=oo`0000000Woo0`0000=o
o`0000000P0017oo0`0000=oo`00Ool00P000goo0`002Woo00@007oo000000=oo`H00003Ool007oo
00Aoo`@000Eoo`@00003Ool007oo00=oo`@00003Ool0000000<00003Ool0000000=oo`04001oogoo
Ool700000goo0000000200001Goo00000000Ool020000goo00@007ooOomoo`800003Ool0000000<0
0003Ool0000000800003Ool007oo00=oo`@000Eoo`@0009oo`03001oo`0000=oo`D000=oo`400000
00@007ooOomoo`8000Eoo`06001oogoo001oo`000Woo00<007ooOol00goo0P001Woo00<007ooOol0
1Goo100000=oo`0000001@0000Moo`00Oomoo`00Ool00002Ool2000017oo000007oo0P0000Qoo`00
Oomoo`00Ool007oo0`0000=oo`00Ool00Woo0P0000=oo`0000000P000Woo00<007oo00000P002Goo
00<007ooOol00P000Woo00<007ooOol02Woo0P0017oo0`0000=oo`00Ool00Woo0P0000=oo`00Ool0
0P0000=oo`00Ool00goo00<007ooOol017oo00<007ooOol017oo0P001Goo0P002Goo0P000Woo00<0
07ooOol00P0000Eoo`00Oomoo`00009oo`80009oo`<0009oo`04001oo`00Ool200000goo00000002
0002Ool4000017oo001oo`000goo00D007oo000007oo00800004Ool00000Ool20009Ool30006Ool0
0`00Oomoo`02Ool00`00Oomoo`0200001Goo001oogoo000017oo0@0000001000Oomoogoo1@0000=o
o`0000001Goo0`001Goo1@0000=oo`00Ool00Woo00@007oo0000009oo`@00004Ool000000004Ool0
0`00Oomoo`0200000goo0000000200001goo00000000Ool007oo00<00007Ool007oo001oo`00Ool0
0P000Woo0P0000=oo`0000001`0000Moo`00000007oo001oo`070002Ool20002Ool300000goo0000
0002Ool01000Ool007oo0`001Goo0P000goo00<007ooOol00P0000=oo`0000000`0017oo00<007oo
00000Woo0`000Woo0P0000Aoo`00000000Eoo`<000Aoo`<00005Ool00000001oo`0300000goo001o
o`050002Ool01@00Ool00000Ool00P0000=oo`0000000P0000Eoo`00Ool007oo00800006Ool007oo
Ool007oo0P000Woo0`0000Eoo`00000007oo00D00006Ool00000001oo`000Woo0`0000Aoo`000000
00Ioo`800003Ool007oo00Ioo`04001oogoo0004Ool100000004001oogooOol20002Ool01000Oomo
ogoo0P0000=oo`0000000`001Goo0P0000=oo`00Ool00Woo00L007oo001oo`00Ool00002Ool40000
0goo001oo`02Ool20002Ool200000goo001oo`0800000goo00000004Ool3000017oo000007oo0P00
0Woo100000=oo`000000100000Eoo`00000007oo008000Aoo`<000Ioo`<0009oo`8000Aoo`@000Eo
o`D00003Ool0000000Ioo`8000Aoo`800004Ool007oo0002Ool01000Ool007oo0`0027oo00<007oo
00000P0000Aoo`00001oo`<00003Ool0000000<0009oo`800003Ool00000009oo`03001oo`0000H0
009oo`800003Ool0000000L00003Ool007oo008000=oo`@00003Ool0000000<00004Ool000000002
Ool00`00Ool0000200000goo001oo`07Ool01P00Ool007oo001oo`800003Ool007oo009oo`8000Ao
o`40000000@007ooOomoo`80009oo`03001oo`00009oo`04001oogooOol3000:Ool20003Ool01000
Oomoo`000Woo0`000Woo00<007oo00000goo00<007ooOol00Woo00D007oo000007oo00@0009oo`<0
0003Ool000000080009oo`03001oogoo009oo`8000Eoo`800003Ool007oo009oo`8000Eoo`03001o
ogoo009oo`03001oogoo00Aoo`<0009oo`03001oo`0000Ioo`03001oogoo00=oo`03001oo`0000=o
o`06001oogoo001oo`000Woo0P0017oo10001Woo00D007ooOomoo`0000Ioo`800003Ool0000000Eo
o`03001oo`00009oo`80009oo`04001oogoo0005Ool01@00Oomoogoo00000Woo00@007ooOomoo`80
009oo`04001oogoo0002Ool20002Ool00`00Oomoo`02Ool01000Oomoogoo0P0000Aoo`00001oo`80
00Aoo`8000Moo`8000Ioo`04001oogoo0002Ool00`00Oomoo`03Ool30004Ool100000004001oogoo
Ool3000;Ool20005Ool400000goo001oo`04Ool30002Ool30002Ool8000017oo000000000Woo0`00
00=oo`0000000Woo1P000Woo00P007oo000007oo001oo`000Woo0P000Woo1P0000Aoo`00001oo`80
0005Ool00000001oo`030006Ool200000goo00000003Ool200000goo000000020005Ool3000:Ool3
0004Ool00`00Ool00002000017oo001oo`000Woo10001Woo0P0000Eoo`00Oomoo`00009oo`800004
Ool007ooOol50002Ool02@00Ool00000Ool007oo001oo`02000017oo001oogoo1@0000Eoo`000000
07oo00800004Ool007ooOol300001Woo001oogoo001oo`800003Ool0000000<0009oo`06001oogoo
001oo`000goo00@007oo000000Ioo`<000Aoo`03001oo`0000<00003Ool007oo00=oo`40000000@0
07ooOomoo`800003Ool007oo00@00005Ool00000001oo`020005Ool50002Ool3000017oo00000000
0Woo0`000Woo0P0000=oo`00Ool00Woo00<007oo00000P000Woo1P000Woo0`0000Moo`00000007oo
001oo`0500001Goo000007oo00000Woo1P000Woo00@007oo001oo`800003Ool00000009oo`03001o
ogoo00Eoo`03001oo`0000Qoo`<000Eoo`05001oogooOol00002Ool200000goo001oo`030005Ool3
0003Ool20002Ool00`00Ool000020006Ool20005Ool2000017oo000000000Woo1@000Woo00D007oo
001oo`0000=oo`<00005Ool007oo001oo`0400001Goo00000000Ool010000Woo100000=oo`000000
0`000Woo1@000Woo0`000goo00D007oo000007oo008000Ioo`<0009oo`04001oogoo0003Ool30004
Ool100000003001oogoo009oo`@000Yoo`03001oogoo00=oo`03001oogoo008000=oo`03001oogoo
00Yoo`<000Eoo`8000Aoo`<00003Ool00000009oo`800004Ool007oo0002Ool01@00Ool007oo0000
0Woo00<007oo00000P000goo0P0000=oo`00Ool02Woo0`0027oo0P000Woo0`000Woo1@001Goo0`00
0Woo00@007ooOol0009oo`04001oogoo0006Ool20005Ool20004Ool00`00Oomoo`04Ool400000goo
00000004Ool20003Ool30003Ool30002Ool50002Ool20002Ool00`00Ool00003Ool3000017oo0000
00000Woo0P001Woo0P000goo0P0000Aoo`00Oomoo`<00003Ool0000000Eoo`8000Ioo`05001oogoo
Ool00005Ool01000Oomoo`001Goo0@0000000`00Oomoo`02Ool30004Ool00`00Ool00005000:Ool0
1P00Ool007oo001oo`<000Yoo`@00003Ool007oo0080009oo`03001oo`0000<0009oo`@00003Ool0
000000800003Ool00000009oo`03001oogoo00<0009oo`D000=oo`80009oo`07001oogooOol007oo
000027oo0`000Woo00D007ooOomoo`00009oo`8000Eoo`800003Ool00000008000Eoo`<000Eoo`80
009oo`8000=oo`03001oogoo00<000Moo`80009oo`04001oogoo0002Ool20003Ool30003Ool30006
Ool00`00Oomoo`0500000goo00000002Ool00`00Oomoo`02Ool20002Ool00`00Oomoo`070003Ool4
0002Ool300001Goo001oogoo00000Woo0P001goo0`0000Eoo`00001oo`0000Eoo`8000Aoo`400000
00<007ooOol00Woo00@007ooOomoo`80009oo`03001oogoo00<000Moo`800004Ool007oo0003Ool0
1000Ool0000027oo100000Aoo`00Oomoo`<0009oo`@00003Ool007oo009oo`04001oo`000003Ool0
1@00Oomoo`00Ool0100000=oo`00Ool00Woo1@000goo100000Aoo`00001oo`<000Qoo`<00003Ool0
07oo008000Aoo`8000Eoo`<000=oo`03001oogoo00800004Ool007oo0007Ool200001Woo001oogoo
001oo`800003Ool0000000Moo`@000Aoo`800003Ool007oo009oo`<000=oo`04001oo`00Ool30002
Ool01@00Oomoo`00Ool00P0000=oo`0000000goo1@0000Aoo`00Oomoo`@00006Ool007oo001oo`00
0goo0`000goo00@007ooOol000Aoo`D000Ioo`800005Ool00000Ool00002Ool01@00Ool007oo0000
1Goo0@0000000`00Oomoo`02Ool00`00Ool00008Ool3000AOol30008Ool2000017oo001oogoo0P00
00=oo`0000000Woo0`0000=oo`0000000goo0P000goo00<007oo00000Woo00<007oo00000Woo0P00
00=oo`00Ool01Goo00D007ooOomoo`0000=oo`04001oogoo0002Ool00`00Oomoo`06Ool01000Oomo
o`000goo00@007ooOomoo`8000Ioo`@0015oo`03001oogoo008000Moo`8000Moo`06001oogoo001o
o`0017oo0P000goo0`000goo00X007ooOol007oo001oo`00Ool000Ioo`<000=oo`<000Ioo`04001o
ogoo0002Ool01000Oomoo`000goo0`000goo00H007ooOol007oo000=Ool00`00Ool00005Ool00`00
Ool00002Ool00`00Oomoo`03Ool100000003001oogoo009oo`8000=oo`80009oo`05001oo`00Ool0
0007Ool30003Ool200000goo000000020008Ool01000Oomoogoo1`000Woo00<007oo00000`000goo
1@0000=oo`0000000Woo0`000Woo00@007oo000000=oo`@000=oo`03001oogoo00Aoo`04001oogoo
0008Ool20007Ool01000Ool000001goo0`0000Aoo`00Oomoo`800003Ool007oo008000Ioo`<000=o
o`04001oo`00Ool40007Ool00`00Oomoo`02Ool40002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
1000Ool000000Woo10000Woo100000=oo`0000000goo0P0000=oo`0000000P000Woo1@0000=oo`00
Ool00P0017oo0P000goo0`000Woo0`0017oo00<007ooOol017oo10001goo0`001Goo0@0000000`00
Oomoo`02Ool200000goo00000002Ool200001Goo001oogoo00001goo1P000goo0`002Goo10000Woo
00@007oo000000=oo`H000=oo`03001oogoo00D0009oo`800004Ool00000Ool30003Ool40003Ool0
0`00Ool000020002Ool01000Ool0000027oo100000Ioo`00001oo`00Ool30007Ool01000Ool007oo
0`000Woo0P0000=oo`0000001Woo0P001Goo0P000Woo0P0027oo1@0017oo0`0017oo00<007ooOol0
0Woo0P000Woo00<007ooOol00`000Woo1@0000=oo`00Ool00Woo1`000Woo0`000Woo00<007oo0000
0P0017oo00<007ooOol00Woo0P0000Aoo`00Ool0009oo`800003Ool0000000Moo`<00006Ool00000
001oo`000Woo0P001Goo0@0000000`00Oomoo`02Ool200000goo001oo`04Ool5000>Ool20002Ool0
0`00Oomoo`07Ool50004Ool00`00Oomoo`02Ool200000goo00000003Ool70003Ool00`00Ool00006
0003Ool30004Ool80002Ool00`00Oomoo`06Ool30004Ool60007Ool00`00Oomoo`020005Ool40006
Ool300000goo00000004Ool00`00Oomoo`08Ool40003Ool5000:Ool30002Ool01000Oomoo`000Woo
0`0000Aoo`00000000=oo`<0009oo`80009oo`04001oo`00Ool200000goo0000000:Ool50002Ool0
0`00Ool00002000:Ool50005Ool00`00Oomoo`03Ool100000003001oogoo009oo`8001=oo`03001o
o`00009oo`04001oogoo0002Ool00`00Oomoo`08Ool200000goo00000002Ool20004Ool01000Oomo
o`0017oo0`001goo00@007ooOol000Qoo`03001oo`0000Eoo`8000Eoo`8000Uoo`05001oo`00Ool0
000?Ool200000goo001oo`0HOol01000Oomoo`002Goo0P000goo0`0037oo00<007ooOol00Woo00<0
07oo00001goo00@007oo000000=oo`D000Qoo`03001oo`00009oo`03001oogoo00eoo`H000Qoo`03
001oogoo00Aoo`04001oogoo0007Ool100000003001oogoo009oo`03001oo`00009oo`<000Aoo`03
001oogoo00Ioo`80009oo`03001oo`0000=oo`8000Uoo`8000=oo`800003Ool0000000Aoo`@000Ao
o`<0009oo`8000Aoo`800005Ool007ooOol00005Ool20004Ool20004Ool50008Ool200000goo0000
0002Ool01P00Oomoo`00Ool000Moo`8000Aoo`<0009oo`8000Moo`800003Ool000000080009oo`04
001oogoo0008Ool20002Ool20005Ool00`00Oomoo`07Ool20002Ool01000Ool007oo0P000goo1P00
17oo0P0000=oo`0000000goo0P0000Aoo`00Ool0009oo`8000Yoo`06001oogoo001oo`0017oo00<0
07ooOol01Woo0P0000=oo`00Ool00goo0P0000=oo`0000001Goo0@0000000`00Oomoo`02Ool30003
Ool300000goo000000020007Ool200000goo0000000200000goo001oo`020009Ool01000Oomoo`00
0goo00<007oo000017oo100017oo00<007ooOol010000goo0P0000=oo`0000000`001Goo0P0017oo
00@007ooOomoo`<00004Ool007oo0009Ool01@00Oomoogoo00000Woo00<007ooOol00P001goo0P00
00=oo`00Ool00`000goo0P001goo0`000goo00<007oo00000Woo0P0027oo00<007oo000017oo00@0
07oo000000Yoo`<0009oo`03001oo`00008000=oo`<00003Ool0000000Aoo`03001oo`00008000Ao
o`<00003Ool0000000<000Yoo`8000Qoo`03001oogoo00Ioo`8000Aoo`03001oogoo00800003Ool0
07oo00Aoo`40000000<007ooOol00goo00D007oo001oo`00009oo`03001oogoo00<000Yoo`03001o
ogoo00moo`05001oo`00Ool00004Ool00`00Oomoo`02Ool01000Oomoo`001Goo100000=oo`00Ool0
17oo00H007ooOol007oo000;Ool00`00Ool00002Ool01@00Oomoogoo00003goo00@007oo000000ao
o`03001oogoo00=oo`03001oo`0000Uoo`@000Eoo`03001oogoo00ioo`03001oogoo009oo`8000Yo
o`06001oogoo001oo`000Woo00D007ooOomoo`00009oo`03001oo`0000Aoo`<00003Ool007oo00=o
o`04001oo`000003Ool00`00Oomoo`09Ool00`00Oomoo`020002Ool2000;Ool01@00Oomoogoo0000
1Goo0P001Goo0@0000000`00Oomoo`02Ool01@00Oomoogoo000017oo100027oo0P001Goo00<007oo
00000P002Woo00H007oo001oo`00Ool30004Ool40004Ool200000goo000000020003Ool00`00Oomo
o`02Ool3000<Ool01000Ool0000017oo0P002Goo0P0000Aoo`00Oomoo`<00003Ool0000000Moo`<0
009oo`05001oogooOol00002Ool00`00Oomoo`06Ool20004Ool00`00Oomoo`030009Ool01P00Ool0
0000Ool0009oo`<000Yoo`03001oo`0000800004Ool000000003Ool60004Ool200000goo00000004
Ool300001Goo000007oo00002goo100000=oo`00Ool00Woo0P0027oo00@007oo0000009oo`07001o
o`00Ool007oo00001Goo0@0000000`00Oomoo`03Ool00`00Oomoo`03Ool01000Ool007oo0P002Goo
0`000Woo100037oo0`000Woo0P0000=oo`00Ool00goo0P0000=oo`00Ool00goo1`000goo20002goo
10000Woo0P0037oo0P000Woo00<007ooOol00goo0P001goo1@001Woo0P0027oo00@007oo001oo`80
0003Ool007oo008000Uoo`@00003Ool007oo00800003Ool0000000Yoo`<00005Ool00000Ool00004
Ool300000goo001oo`04Ool50004Ool01000Oomoo`000Woo0P002goo0`0000=oo`00Ool01@002Goo
10000Woo00<007oo00000Woo00<007ooOol00goo0@0000000`00Oomoo`06Ool30005Ool00`00Oomo
o`06Ool01`00Oomoogoo001oo`0000Aoo`03001oogoo00Qoo`8000=oo`04001oogoo0004Ool30006
Ool20002Ool20008Ool00`00Ool0000<Ool01`00Oomoogoo001oo`00009oo`03001oogoo00Moo`<0
009oo`03001oogoo008000Yoo`05001oogoo001oo`0200001Goo000007oo000027oo00@007ooOol0
00=oo`80009oo`03001oogoo00Moo`03001oogoo00Aoo`<000]oo`03001oo`0000Uoo`@000Uoo`80
00Eoo`04001oogoo0002Ool00`00Oomoo`09Ool00`00Oomoo`0@Ool00`00Ool00008Ool00`00Oomo
o`04Ool100000003001oogoo00=oo`<000=oo`03001oogoo009oo`03001oogoo00Ioo`<0009oo`04
001oogooOol3000:Ool00`00Oomoo`0300000goo00000004Ool30005Ool200000goo001oo`020004
Ool40002Ool00`00Oomoo`09Ool00`00Ool000020002Ool40009Ool5000017oo001oogoo0P002Goo
00D007ooOomoo`0000Eoo`8000Qoo`800005Ool007ooOol00002Ool30009Ool300001Goo001oo`00
Ool00P002goo100000Aoo`00000000Eoo`@000Eoo`D000Aoo`80009oo`04001oo`00000;Ool30000
17oo001oogoo0P0000=oo`00Ool027oo0P0000Eoo`00Ool007oo00800003Ool0000000Eoo`400000
00<007ooOol00goo0`0000Aoo`00Oomoo`D000Qoo`03001oogoo0080009oo`03001oogoo008000Yo
o`04001oo`000003Ool20005Ool20005Ool60005Ool400000goo0000000;Ool200000goo00000002
Ool3000:Ool20003Ool2000017oo000000002Goo00<007ooOol017oo1@0027oo0P0000=oo`00Ool0
1Goo0P002Goo00@007oo001oo`800003Ool007oo011oo`800003Ool007oo00Aoo`8000Qoo`@000Ao
o`03001oo`0000D000eoo`03001oo`0000800004Ool000000008Ool30002Ool00`00Oomoo`02Ool3
0005Ool100000003001oogoo00=oo`03001oo`00019oo`04001oogoo0002Ool2000=Ool01P00Oomo
o`00Ool0009oo`03001oogoo00ioo`03001oogoo00Aoo`03001oogoo011oo`03001oo`00009oo`03
001oogoo00eoo`03001oogoo00Eoo`03001oogoo00Uoo`<000Eoo`8000ioo`80011oo`03001oogoo
00=oo`03001oogoo00Uoo`800003Ool007oo00<000Eoo`@000Eoo`D000Aoo`<000=oo`8000]oo`80
0003Ool0000001Eoo`800003Ool007oo00Ioo`40000000<007ooOol00goo00<007ooOol00`0000=o
o`0000000`002Goo00@007ooOomoo`<0009oo`03001oogoo00Yoo`03001oogoo00D000eoo`D000Eo
o`H000ioo`08001oo`00001oo`00Ool000Yoo`05001oogooOol00002Ool01000Oomoo`002Goo0P00
1Goo0P000Woo00<007ooOol01Woo0P0000Aoo`000000009oo`04001oo`000009Ool30003Ool3000<
Ool01000Ool007oo10001Goo10001Goo10001Goo0`000Woo00<007ooOol037oo00<007ooOol00Woo
10002Woo00<007oo00000P0017oo0P001Woo0@0000000`00Oomoo`03Ool00`00Oomoo`03Ool20000
17oo000000002Goo10000goo00<007ooOol02goo0`000goo0`003Goo1@001Woo0P000Woo00<007oo
Ool02goo0P000goo00@007ooOol000]oo`03001oo`00008000Aoo`03001oogoo00Moo`L000Aoo`03
001oogoo00Moo`8000=oo`<000aoo`800004Ool007oo0002Ool2000;Ool40002Ool00`00Oomoo`04
Ool30007Ool30005Ool8000;Ool01P00Oomoo`00Ool0009oo`8000eoo`<0009oo`8000Moo`400000
00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01goo00D007ooOomoo`0000=oo`8000eoo`80
00=oo`8000moo`03001oo`0000Qoo`<0011oo`<0009oo`03001oogoo00Qoo`04001oogoo0002Ool0
0`00Ool0000;Ool30006Ool20009Ool00`00Ool000020005Ool00`00Oomoo`0<Ool00`00Oomoo`0?
Ool2000017oo001oo`001goo0P001goo00<007oo00001Woo00<007oo00000Woo00<007ooOol02goo
00D007ooOomoo`0000ioo`<000Moo`03001oogoo00Aoo`40000000<007ooOol00goo0P000Woo00<0
07ooOol00goo0P002Goo0`000Woo00<007oo00000P002goo00D007ooOomoo`00009oo`8000eoo`03
001oo`00008000Eoo`@00003Ool007oo00aoo`<00003Ool007oo00<000Yoo`800003Ool007oo009o
o`04001oo`00000:Ool00`00Oomoo`03Ool00`00Oomoo`020008Ool300000goo001oo`02Ool40009
Ool40002Ool4000<Ool00`00Oomoo`040006Ool20007Ool30005Ool200001Goo001oogoo00003Goo
0`000goo0`002Woo0`000Woo0`000Woo00<007ooOol017oo0@0000000`00Oomoo`03Ool400001Goo
00000000Ool00`002Goo00<007ooOol00`0000Aoo`00000000aoo`80009oo`03001oogoo00ioo`<0
0003Ool007oo00Aoo`D000ioo`@00003Ool007oo008000Yoo`04001oogoo0002Ool50009Ool00`00
Oomoo`02Ool2000017oo000000002Woo00P007ooOomoo`00Ool007oo0`002Goo1P0000=oo`00Ool0
3Goo0`0000Aoo`00Ool000Ioo`03001oogoo00Moo`03001oogoo00Aoo`06001oogooOol007oo0P00
37oo1@0000Aoo`00000000Yoo`<000Eoo`8000Moo`40000000<007ooOol00goo00<007ooOol00`00
3goo00<007ooOol00goo00<007ooOol03goo00D007ooOomoo`00011oo`8000Moo`03001oogoo0080
00eoo`03001oogoo009oo`800003Ool007oo00Yoo`800005Ool007ooOol00002Ool00`00Oomoo`08
Ool200000goo001oo`0300000goo001oo`0=Ool00`00Oomoo`0?Ool00`00Oomoo`0200000goo0000
000<Ool01000Oomoogoo0P006Goo1P003Goo0P000Woo0P005Woo00<007ooOol01Goo0@0000000`00
Oomoo`03Ool01000Ool000000Woo1@002Woo0`000goo00@007ooOol000aoo`03001oo`0000@000mo
o`<000Moo`D000ioo`@000=oo`03001oogoo00Uoo`80009oo`8000eoo`04001oogooOol20002Ool3
0009Ool200002Goo000007oo001oo`00Ool0000;Ool2000017oo001oogoo0`0037oo1P006Goo1000
00=oo`00Ool037oo00@007ooOol000=oo`03001oogoo00Uoo`04001oo`00Ool200000goo001oo`02
0006Ool100000003001oogoo00Aoo`03001oogoo00Aoo`03001oo`0000Yoo`800004Ool007oo0003
Ool00`00Oomoo`0:Ool01000Ool007oo0`003goo0`001goo10003Woo0P0017oo0`002Woo1@000goo
00<007oo00002Goo10001Woo00<007ooOol02goo00@007ooOol0009oo`03001oogoo00Qoo`8000Mo
o`03001oogoo00]oo`<00003Ool007oo01Qoo`04001oogooOol2000=Ool00`00Oomoo`04Ool2000:
Ool2000017oo001oo`000Woo00<007ooOol01Woo0@0000000`00Oomoo`05Ool00`00Oomoo`04Ool0
0`00Oomoo`09Ool00`00Ool00002Ool01@00Ool007oo000037oo0P0000Eoo`00Oomoo`00011oo`80
00Moo`<0011oo`<000=oo`03001oogoo00Uoo`80009oo`8000=oo`80015oo`03001oogoo00Uoo`80
0006Ool007oo001oo`003Goo00L007ooOomoo`00Ool0000?Ool00`00Ool00002Ool00`00Oomoo`0G
Ool00`00Ool00002Ool00`00Oomoo`0=Ool200001Goo001oogoo000047oo0P0000=oo`0000001Woo
0@0000000`00Oomoo`07Ool3000017oo000000002goo00L007oo000007oo001oo`02000<Ool20000
1Goo000007oo00003goo0`001goo00<007oo00000P003Goo00<007ooOol01@004Goo00<007ooOol0
0P002Woo00@007oo001oo`8000=oo`03001oogoo00Moo`@0009oo`03001oo`00008000eoo`04001o
o`00Ool2000=Ool00`00Oomoo`03000IOol01P00Ool00000Ool000eoo`03001oogoo00800003Ool0
07oo00]oo`@000=oo`@000Ioo`40000000<007ooOol017oo0`000Woo00D007oo001oo`0000]oo`<0
0003Ool00000008000eoo`@0009oo`03001oogoo00ioo`8000Moo`D000ioo`07001oo`00Ool007oo
000037oo00@007ooOomoo`H000Uoo`05001oo`00Ool00003Ool3000:Ool30003Ool00`00Ool0000<
Ool00`00Ool00002Ool3000=Ool20002Ool2000IOol6000=Ool30002Ool00`00Ool0000<Ool00`00
Ool000020002Ool20007Ool100000003001oogoo00Eoo`03001oo`00009oo`04001oogoo000;Ool0
0`00Oomoo`03Ool00`00Ool0000?Ool2000KOol01000Oomoo`0047oo00<007ooOol04Goo0P000Woo
00<007ooOol02Woo00@007ooOol000=oo`04001oogoo000?Ool00`00Ool00002000;Ool20003Ool3
000>Ool200000goo0000000IOol300000goo001oo`0=Ool20004Ool00`00Oomoo`0@Ool00`00Ool0
0008Ool100000003001oogoo00Aoo`800007Ool007ooOol007oo00003Goo00<007oo000017oo00<0
07ooOol02Woo0P000Woo0`006Goo10003goo1`0037oo00<007ooOol00P0000Aoo`00000000Yoo`80
009oo`06001oogoo001oo`002goo00<007oo00000P000Woo00<007ooOol02goo1@0000=oo`000000
3Woo0`0000=oo`00Ool067oo00<007oo00000`003Goo0`0000=oo`00Ool00P0037oo100017oo00<0
07ooOol01Goo0@0000000`00Oomoo`04Ool02000Ool007oo001oo`00Ool2000;Ool01000Ool00000
0Woo00<007oo00003Goo1@006Woo0`0047oo00L007ooOomoo`00Ool0000<Ool30002Ool200000goo
001oo`0:Ool01@00Ool00000Ool00P000Woo00<007ooOol027oo00D007ooOol007oo0080009oo`03
001oogoo00Uoo`04001oo`000003Ool00`00Oomoo`0<Ool4000KOol300000goo001oo`0<Ool01000
Ool000000goo00<007ooOol03Goo0P0000Aoo`00Ool000Moo`40000000<007ooOol017oo0`000Woo
00<007ooOol03Woo00@007oo0000009oo`8000aoo`<00003Ool0000001]oo`<000moo`06001oo`00
001oo`003Goo00<007ooOol00Woo00@007ooOol000]oo`80009oo`03001oogoo008000]oo`04001o
ogoo0004Ool2000;Ool01000Oomoogoo0P0000=oo`00Ool03Goo00<007oo00000P006Woo0P0000=o
o`00Ool03Goo00@007ooOomoo`800003Ool007oo00]oo`8000=oo`04001oogoo0007Ool100000003
001oogoo00Yoo`04001oogoo000@Ool00`00Oomoo`0=Ool200000goo001oo`0LOol2000AOol00`00
Oomoo`0?Ool00`00Oomoo`03Ool3000;Ool20007Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool3000;
Ool01000Oomoo`005Goo0P006Woo0P004goo00D007ooOomoo`0000aoo`05001oogooOol00002Ool2
0007Ool100000003001oogoo00Aoo`H00003Ool0000000aoo`<0009oo`<000eoo`03001oo`0000<0
01]oo`80011oo`<00004Ool00000000<Ool00`00Ool0000300000goo001oo`0;Ool01@00Oomoo`00
Ool01@002goo00H007ooOol007oo000?Ool20003Ool2000>Ool3000MOol3000>Ool30003Ool2000<
Ool2000017oo001oogoo0`001goo0@0000000`00Oomoo`04Ool20002Ool6000<Ool200001Goo0000
07oo00003Woo00D007oo001oo`0002eoo`H000eoo`04001oogoo0003Ool00`00Oomoo`0:Ool30000
0goo00000002Ool00`00Oomoo`09Ool400000goo00000002000<Ool4000017oo000000003Woo1000
6goo10003Woo0P0000=oo`00Ool00`0037oo00<007oo00000P0000Aoo`00000000Moo`40000000<0
07ooOol02goo00<007ooOol02goo0P0000Aoo`00001oo`8000ioo`04001oogoo000^Ool01000Oomo
ogoo0P003Woo00<007ooOol017oo00<007ooOol02Woo10004Goo0P000Woo00<007oo00003Goo0P00
00=oo`00000047oo00@007oo000001]oo`800003Ool007oo00moo`03001oo`00008000eoo`03001o
ogoo00=oo`03001oogoo00Moo`40000000<007ooOol01goo00<007ooOol00Woo0P0037oo00L007oo
Oomoo`00Ool0000>Ool300000goo001oo`0^Ool200000goo001oo`0<Ool9000;Ool00`00Ool00005
Ool00`00Oomoo`09Ool01P00Oomoogoo001oo`<000ioo`05001oogooOol0000?Ool4000LOol3000?
Ool2000BOol200000goo00000002Ool00`00Oomoo`05Ool100000003001oogoo00Eoo`800003Ool0
0000009oo`8000aoo`04001oogoo0002Ool00`00Oomoo`0>Ool3000^Ool00`00Ool00002000>Ool0
0`00Ool00005000=Ool01`00Oomoogoo001oo`0000aoo`05001oogooOol00002Ool00`00Oomoo`0;
Ool2000017oo001oo`0047oo0`0077oo0P0047oo0P0000=oo`00Ool00P0037oo0`0017oo00<007oo
Ool01Woo0@0000000`00Oomoo`09Ool2000AOol00`00Oomoo`02000>Ool01000Ool00000;goo00D0
07ooOomoo`0000moo`05001oogooOol0000>Ool00`00Oomoo`020002Ool00`00Oomoo`0;Ool00`00
Oomoo`02Ool2000?Ool01000Ool0000047oo0P007Goo0P0047oo00<007ooOol00P003Woo00H007oo
Oomoo`00Ool20008Ool100000003001oogoo00Eoo`<0009oo`03001oogoo00eoo`<0019oo`@002mo
o`<00003Ool007oo00eoo`<000=oo`03001oogoo00Yoo`800004Ool007ooOol3000<Ool300001Goo
001oogoo00003Goo100000=oo`00Ool047oo00<007ooOol06goo00<007ooOol03goo100000=oo`00
000037oo0P0000Ioo`00Ool007oo0008Ool100000003001oogoo00Ioo`07001oogooOol007oo0000
3Goo00<007oo000010003goo0`00<7oo10003Woo00<007ooOol00P0000=oo`00Ool02goo00@007oo
0000009oo`<000aoo`03001oo`0000@0011oo`<004Aoo`8001=oo`800003Ool007oo00Moo`400000
00<007ooOol01Goo00@007ooOol0009oo`8000eoo`8000Aoo`03001oogoo00eoo`03001oo`0003=o
o`03001oogoo00aoo`8000=oo`03001oogoo00ioo`03001oogoo00moo`03001oo`0000=oo`8000io
o`04001oogoo0013Ool200000goo0000000=Ool01@00Oomoo`00Ool00`0027oo0@0000000`00Oomo
o`05Ool01000Oomoogoo10003Goo0P000Woo0P0047oo0`00;goo0`0047oo0`0000Aoo`00Ool000eo
o`03001oogoo0080009oo`03001oogoo00]oo`8000Aoo`03001oogoo00]oo`H0045oo`H000eoo`80
009oo`03001oo`0000Uoo`40000000<007ooOol01Goo00<007oo00000`0000=oo`00Ool037oo00<0
07oo00000`0047oo0`00;goo00<007oo00000P0047oo1@003Goo0`0000=oo`0000000P0037oo00D0
07oo000007oo008000ioo`80009oo`80045oo`80009oo`8000ioo`<000=oo`03001oogoo00Ioo`40
000000<007ooOol01Goo0P0000=oo`00Ool047oo00<007ooOol0AWoo10003goo0P000Woo00<007oo
Ool037oo0P005Goo00@007oo0000019oo`03001oogoo05Aoo`<0009oo`03001oogoo00Moo`400000
00<007ooOol01Woo00@007ooOol0009oo`03001oogoo00]oo`03001oogoo00<0049oo`@000moo`@0
009oo`03001oogoo00]oo`03001oo`0000@000eoo`<00004Ool00000000?Ool30014Ool300000goo
001oo`0=Ool200000goo000000020008Ool100000003001oogoo00Ioo`80009oo`03001oo`0000eo
o`<0009oo`03001oogoo045oo`<0011oo`06001oo`00001oo`003Goo00D007ooOol007oo008000io
o`03001oo`00009oo`03001oogoo00eoo`@004=oo`D000ioo`03001oogoo00=oo`03001oogoo00Io
o`40000000<007ooOol01Woo0P000goo0P003Woo1@00@goo0`0047oo00<007ooOol05Goo0P004Goo
00<007ooOol03goo00@007ooOol004=oo`800003Ool007oo00ioo`03001oogoo00aoo`40000000<0
07ooOol01Woo1P003Woo0P0000=oo`000000A7oo0`0047oo0`0000=oo`00Ool03Goo1`003Woo0P00
00Aoo`000000011oo`<004=oo`@000moo`03001oo`0000<000Uoo`40000000<007ooOol02Woo0P00
47oo00@007ooOol004Aoo`03001oogoo00moo`03001oogoo008000ioo`<0019oo`H000moo`04001o
o`000013Ool01000Ool000003goo00<007oo0000100027oo0@0000000`00Oomoo`06Ool3000BOol0
0`00Ool0001HOol200000goo0000000?Ool20002Ool2000>Ool20002Ool00`00Oomoo`0>Ool40014
Ool3000@Ool01000Oomoogoo0P0027oo0@0000000`00Oomoo`06Ool00`00Oomoo`03000?Ool01000
Oomoo`00Egoo0`004Woo00@007oo0000015oo`04001oo`00000?Ool200000goo001oo`13Ool00`00
Ool0000?Ool4000;Ool100000003001oogoo00Ioo`06001oo`00001oo`003goo1000Egoo00<007oo
00000P003goo00<007oo00000`003Woo10004Woo0P00AGoo0P004Woo0P0000=oo`00Ool027oo0@00
00000`00Oomoo`0:Ool2000?Ool00`00Ool0001HOol01@00Ool007oo000047oo0`0047oo00<007oo
Ool04goo00<007ooOol0A7oo00<007ooOol04Woo0`002Goo0@0000000`00Oomoo`07Ool00`00Ool0
000AOol200000goo001oo`1GOol01000Oomoo`003goo00D007oo001oo`0000moo`D0019oo`03001o
ogoo04Aoo`03001oogoo00moo`800003Ool0000000Uoo`40000000<007ooOol01Woo1P0047oo0P00
F7oo100047oo00D007ooOomoo`00011oo`04001oo`00001[Ool50009Ool100000003001oogoo00Io
o`03001oogoo01=oo`8005Uoo`@000moo`D0011oo`@006aoo`800003Ool007oo00Qoo`40000000<0
07ooOol01goo0P0000=oo`00Ool04Goo00<007ooOol0JWoo00<007ooOol05Goo00<007ooOol0JGoo
00<007oo00002goo0@0000000`00Oomoo`07Ool4001/Ool3000AOol4000@Ool4001[Ool4000:Ool1
00000003001oogoo00Moo`04001oo`00001/Ool3000AOol4000@Ool4001/Ool3000:Ool100000003
001oogoo00Uoo`8006eoo`03001oogoo011oo`8001=oo`<006aoo`03001oogoo00Yoo`40000000<0
07ooOol01goo1000P7oo00@007oo0000011oo`03001oo`0006eoo`<000Yoo`40000000<007ooOol0
27oo0P00PGoo10004Goo0P00KGoo0P002goo0@0000000`00Oomoo`3oOolMOol100000?l002400000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250053, 
  0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["WindowsSound", "\<\
DTU6AVeH001G@EI5IVed8100000100404B/0014[000100P0I65dHDUH001mOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGinOWinOWinOWinOWem
OGelO7alNg]kNg]kO7alOGemOWioOh20P820P820OgmnOGelNg]jNGUiN7QiNGUj
NW]lOGioP862Ph>3Ph>3Ph:1P7mmO7]iN7MfMGEeMGEfMWQiNWanP863Q8J7QhR8
R8N6Q8>1OgekN7IdLg5`L71`LG9cMGQjOGn2QHN9Rhb=SHf<RhV7QH9oNgQeLW1]
K6YZJV]/KW1cMWYnPXF9S8nATi>DTi:@SHZ6PWiiMG5]JVMUHf=SIFMZKG5fNh25
RXjBUYRJVi^IUiBAS8N1O7I`JfIRGeeLFeaOHVI[L7IlPhV?UIZNX::SXZ2MVIB>
Qh1iLV]TGeYGE5=DEEQMHVU`Mgn7SiJMXZJYZj^ZYj:MUXj6OGE/I5eFDDe;Bda>
DeQOIg1jPhfFWZF[/;>d/k6]Yj2GSXAjKfELE4e8A492A4Q>EEiWLWf8TifW[kFj
_;fk^;:[XYR=PGEYGUA;@chj>CXm@TUBGFUePXjKY[2i_lC6a/>n]jjSUhYlKf9E
BT0i<c0`<SHmAU5MJgV8UZ>`^/?9cLo>b/>j[j>EQWMXFDa0=RhY9bL[<CU4DEm_
OhnN[K[5cMCGemG?akf`XI61L61@@SH/920N82D]=dABHWB5UZNfa<oHgN3OfmC:
_JnNSGYXEdHh:b4K5aLJ82XfA5EWNXfO/L3>fN7VinGPel^m[9Z7Lf1=?2dQ618?
41DM:3I7FFf1UJRjb]SSj^k^j^?Hbk^XU81[Ed@b91P?2PT;4A/X>4]NLhVN//CD
h^_bm??^iMS9]j>>N69=>RTJ3`L310P@6bXlD6EkTJNkc]kZloSim_3UelJbWHI_
FD@a81870@001Q0M;T5FK8BJ/<GGi_;ioOghl>?C`JbEOVM@>bPG2P4000064B0b
AeeeS:Bic]o]n?koo_S^h<nkYHeeGTLb8104000000PE9CQ>IGfE[<;Ei_?looon
m^[Kb;>LQFaE?bXI2P0000002aX[@5I^QYjeb]c/mooooocci]G1ZiAlI4`g91<6
000000@@83=8GgN?Y[c@h_3joooonNkOcKVSRg=KAC0N3`@000002ALW>e5XOiN^
`mKVl__ooo_cimS5/9Z2Je@n:aX=0`0000D@7S14FW68WkG8f^Scn_gkm^cOckbW
TGYSCCTW60`4000431PW>DeSNI2V^/cLjO;gn?K_i=K6/ij8LUa8=B@G3@L41P/D
8C53EVb1Uj^ncmgXko?bk^OKcKbYUH1[ET<b91P@2`X=51h[>TaPM8RM/<7@g>G[
kN_VgM73/Z2<N6EB@34T6a@A4QHM9cE4EVQkSj6b`/oIhNGUhmcCakVYUhEbH4lo
<RLO6QPJ7bLb?diOL8:DYKC2cMGKg]gId/Vm[in?OVeLCCld:bDQ8B@Y<Ca9EfMg
R9NV]<39d=CEdlo8_[>UUhQhJEY=@CP`:bTZ;S@lAU=PKWf<VZNb_<C9c<c9aKfd
ZIf?PG=VFDi4?3Lc<c@h?TI@G6QePXnKY[2h_/73`[nj/jZPUHUlL6EJD4Q2?S`l
?T99D5UTKgZ5T9^T[;:f^KZh]K2YXIR>PgU^IEaDCTU6ADI8CE9JHV]dOXRAVJ6W
[:n`/:j[YZ2IT8QoMViVGeUDDDm>D59FG69YLGV1RI2GW:6UYjNWYJ6MUi6:Pgae
KVQRGUYHEeMIG5mTJFmeO8:9SY>HVifNWijLVIF@RhJ0NWE_JfMTHF1PH69TIf]_
M7UnPhN<Si:EUYNFUI>ASXZ6PWiiMG9^K6YXIfQXJVa^LGAhNgn2QXV;SHj?Shn>
S8Z8QH9oO7UgM79aKfm^KfmaLWAfN7]mOh63QHJ7R8R8R8N6QH>1P7ilNWUgMWIe
MGEeMWIgN7YkO7eoP861PX:3Ph>2PX60P7mnOGalNg]jNWYjNWYjNg]lO7emOGin
OWinOWinOWinOGemOGemOGemOGinOWinOWinOWinOGemO7alNg]kNWYjNW]kNgal
OGenOgn0P861PH61PH20OginOGakNWYiNGQhN7QhNGYjNgamOWn0PH:2Ph>3Ph:2
PH1oOWelNgYiN7QgMgMgMgQhNGYkO7ioP862PX>3Ph>3Ph:1P7mnOGakNWUhMgMg
MgMgN7UjNgamOWn0PH:2Ph>3Ph:2PH20OgimO7]jNGUhN7QhN7UiNW]lO7enOgn0
P861PH61P820OginOGelO7]kNgYjNW]kNg]lO7emOGinOWinOWinOWinOGemOGem
OGemOGinOWinOWinOWinOGemO7akNg]jNWYjNWYjNg]lOGinOh21PH:2Ph>3PX:1
P7mnOG]jNGQgMWEeMGEeMWMhNW]mOh62Q8F7R8R8R8R7QXB2P7ilNGMeLg5`Kfm_
Kg1bLgIhNgj1Q8J9Rhf>Shn>SHb:QhB1OGYfLg1]JfUXJ6QYJfe`M7QlP8B8S8nB
U9FFUYFCT8f9QH1kMg9]JFISHF1PHF=VJFebN7f3R8jBUYZLWYjMW9VET8^5OgUb
K6MRGU]IF5QJGF5VJg9iP8N>U9ZOXZFVYZFRWYVCS8AmMFeVGeYEDU1@DE=GGF=Z
LW^4S9BLXZR/[Zn^[:RSW9B<PWU`IeiGDDa8AdM9CE9IHFYdOXRBW:B[/KFg^;Jc
[JJNUHYoM6UOETi7@Sln?d97CUMPJgN3SYZT[KFk_l30_KVbZInDR7]_HUM=A3dh
=SDh?4=;EF5^NhREXZfg_lG8bLS4_KF[Wi:4MVQJCT<j<bl];S4g?dUEHg60Sif[
]l79c]7Ac/W1]j^MSWm_H595>C0Z9RDW:c<mBEMVMXJFY[C0b];GfMSDcLBhZYZ:
NFQHBC/`9b4N7R4W<3a:FFYlSIn__L[DfmoPg]S@a;NWUXAbH4lo<RLN6ALH7BD_
?DaNL8>EYkS6dmcSi^KRfm74]:>AOVYHASHY7QHB4A@J930oD6=fRYj``LoKi>[/
j^GLd<:aWXYfHTlm;B0F3``=4ATT<T=EJGfBY[W9f>?[ko3]i]c>_ZbHPfiJASDU
6A0:20X@6BHfAe]`QIZ^`M7OjO3cl^kUf/^iYY5lIU4n;AhC2`H62A4L:SY=HWR=
X[K9f>G^m?GckN?Fa[>ORWANBSLV60h710D:4al_@EAZP9FZ_/oNj_;fm_;Zgm70
[9N2K5I2<20D2`D41PdG93E8G7:7WK;4eN;]loKeknKJbkVUSgYTCc`[71491@D9
4A`[?4mTNXnT^<[IiNkcm?7[hM?3/If7LUe9=RLI40X72@hG8c94Efb1UZ^mc]cV
k_7akNGJc;^XU7m[ET<b91P@30/=51h[>daPM8VM/<7@gNK[kNcWg];3/Z2<N6AA
?c0S6A8?41@K9S=3EFQlSj:da=7LhnSXiMoFbKZZUhAaGddm;b@K5QDF6b@_?DaN
L8>EY[O5dM[Oh^;Ne/g0/J6?OFaJBS``9QlL6ahT;CQ6EFIgRIVY^<C>e][Kf]G=
`kJXVHQgIeM9?38Z9B<S9bhg@TmNKGf=WJ^g`/[@dm?Abl>i[InAPW9TETTn=Rl/
:bda>45<F6IdPi6NZkJnaLW;b/O1^JnTUhYlKf5EBd8k=S@d=S]2BeEQKGZ7TinY
/[Vn`L;0_KN_YY^@Q7Q/HEM>Ad4n?Ci0ADaDGVQcOXVDWZJ^/kNi^;Jb[JFMU8Yo
MF]RFE9=BDM6B4]@EUeVKgR2RiBKXZR/[Zn^[:RSW9F=Q7acJfAMF5AAD51BEEUO
IFadO8B;TYRMXJBUYZBRWYZDSXN0NG=/If9NFeYIFUaOHfM/LWQnQ8Z?TiNJVibL
ViRETHf8PgihM6m[J6ESHf=TIFQ[KW9gNh24R8^>T9:CTi:AShf:Qh>0O7UeLg1^
KFa[K6e^L79eMgYmP8:5QhR9RXZ:RXV7QXB2P7ilNWQgMWEdM7AdMGIgN7UkO7eo
P861PX:2PX:2PH60OginOGelO7]kNg]kO7alO7emOGemOGemO7alO7]kNg]kNg]l
O7emOWn0P862PX:3Ph:2PH1oOWelNWUhMgIeMGEeMGIgN7UkOGj0PXB5QXN8R8R8
QhJ4Ph5nO7YhMGAbLG1_Kg1`LWAfN7]mP8>5R8Z;S8f=SHb;RHJ4PGikN7EbKfe/
Jf][K6e_LWEhNgn2QHV;SXnATI6@Shf:QhB0OGUeLVm/JVQXJ6QYJfiaM7QlP8B8
RhjATY>DTi:@SX^7PgmkMg=_K6UWIVEVIfQ[KW5eNGj2QXZ>T9>DUIFDTi6>RXJ2
OWUeLFeZJ6IUIFEWJF]_LWMkOhB8S8nBU9FEUIBBT8f9QH5lN7A`K6UWIVEUIVQZ
KG1dN7f1QHV<Si:CU9BDTY2>RhN3Og]gLfm/JVQWIfMXJVa_LgIjOX:6RHb?T9:B
TY6@SX^8QH5mNWIcL6e/JVYYJV]]Kg9eN7aoPXJ8Rhf>Shn?SXb:R8F2OgaiMWAb
L6i^KFi^Kg5cMGQjOH22Q8J8RHZ:RXZ9R8J4PX1nO7YhMWAcLg9bLg=dMGMhNWan
Oh62PhB5QHF5Q8B3PX5oOWelNgYiNGQhN7QiNGYjNgalOGenOWmoOgmoOgmnOWim
OGemOGemOGinOWmoOgmoOgmoOWimO7akNWUiN7QhN7QhNGUjO7enOh62PhB5QXJ6
QXF4Ph:0OWajN7IdLg9aL71`LG9dMWQkOH23QXR:S8f>SXj=RhZ7Q85nNWMcL6i[
JVQXJ6U[KG1cMg]oPhN;Si:DUYJFUIBASXZ6PGagLViZIV=QH5mPHVEXK75gO8:8
SI:FVYfNWijMVYJBS8J0NW=]If9NFUQGEeUKGfAZL7MoQXfDVYnSYZNWYZBPViB=
QWifKVIOFUEACdi?DUEKHFUaNH:;Ti^RZ:b_/;2]ZZBNUXf4Ng5XGeMAC4Q6ATQ;
DEMOJ79lQi6JXj^a]KRh]kB_Z:2FS85fJf5GCdQ3?cho@DI=EEmYMH6<V:://kZn
`<2m^K>ZXIF:OG5UFDm6?cXg=SPl@TYDH6aiQY>OZ[Bl`/K7a/>m]J^PThIhJeeA
Achg<S0`<cQ0BEERKgj<VZNb_<C:cLk<al2fZij@PG9TETTn=Bl[:B/_=Sm:EfEd
Pi:Q[k[4c=7Cdlo9`KJYVhalK5e>@SL^:2DT9b`d?d]JJGV9VJRf`/cCemSFd/[0
]:JGQWIUEDLj<2PR824U:cE1CUi^Oi2P/;g9d]SKfmWCb[naXY:0Kei>@3@Z8QhM
7b@/=dACHgB6UjNfa<kGg=kMfM;8^jfMS7YXF4Pj;RDO6a/O9BhjB5QYNXbM[[c9
dm[NgmgHd<BgZ9N5Lf9A@SDZ8Q`J720X<Sm=GVn1TjBc`LgFg=oOg=G<`;:RTGm]
G4`m<BLP71/M8b/gA5=TMXNIZKS5d=SMg]gIdLNjZi^:N6MFAcX^9B0M7B4W<Ce;
FV]lSIj^_<SAf=_LfMC;`K>TU8=bHU94=bdV8B0Q9Rdg@e9QLH:CXk6nb=7Ff=SD
c/Fj[9f>OFeMCd8f;RPT92L/=3i;FFQhR9NV/ko8cm?Dd/k7_K:UUXMhJ5Y=@CL`
:bTZ;C<lAU=PKgj<VjRd_/K;c/k;a[neZYf?PG=UF4a2>S@`;c4e>dA>FVMePi2M
ZK>k`/K7al>n]ZfRUXUlKf9GCD@n>CLg>Ci4CEMRKWZ7TijX/;Nl_l2n^kF]Y9Z?
Q7Q/HUQ?B4=0?Sm2AdeEGfUcOXVDWJJ]/[Jg]kFa[:FLThUoMF]RFU==BTM7BDa@
EUiVKgR2Ri>KXZN[[Zn^ZjRRW9F=Q7acJfAMF5AAD55BEEYOIVedO8B;TYRMXJBU
YJBRWYVDSXN0NG=]If9NG5YJFUaOHfQ]LWQnQ8Z?TiNIVibKVYRETHf8PgiiM6m[
J6ITHf=TIVQ[Kg=gNh24Qh^=Si6BTY6@SXb9QX>0O7UfLg5_KVe]KFi_LG=eN7Ym
Oh:4QHN8R8R8R8N6Q8>1OgilNgUhMgMgMgMgN7QiNW]lOGenOWmoOgmoOgmnOWim
OGemOGemOWioOgn0P820P81oOgimO7]jNGQgMgIfMWIfMgQiNWanOh63QHJ7R8V9
RHR7QXB2OgejN7EcLFm^KFe]KVmaLgIiO7n3QXV;SXn@TI6@Shb:Qh=oNgMdL6eZ
J6IUIFIXJVe`M7UmPXN;Si:EUiRHV9JDTHf8PgiiM6mZIV=PGeiOH6=VJVmdNX26
Ri2EVIbNWinNViRDSXV3O7I`JVAPG5YHF5UKGf=XKWElPhZ@UY^OXZBUY::OVYF?
R85iLV]UGeYGE5=CEEQLHVQ_Mgj6SYFKX:BWZJVXYJ6KUHj6OWI^If1JEE9@Ce1C
EUaRJG5iPXZBVJ2UZJ^][:ZVXI^DS8AkLVYRFeIACTe=CU5FG6=[Lgb5SYJMY:V/
[Zn^ZjJQVY::PGQ_IUmHDTi<Bd]>DUMMIFefP8VAVJ2VZjj`[jjZYInHShMnM6]S
G5E@CD]:C4mCFF1XLGZ3S9BLXjR/[jn_[:RSW9F<PgYaJF5JE51=Bda>DEILHf]d
OHJ?UijTZ:b^[ZbYYInITHV0MfmWGeUDD4i=CU5EFV1WKgR0RI6HWZBXZZ^[ZJJQ
ViB=QGeeKFEOFEEBDE5BEEUNI6acNh>:TYRNXZFWZ:NTXIbFT8V2NW=/IF1KF5IE
EEMJGV=YL7MnQH^BUibOXJ>SXInKUi6;QGmhLVaVHUiLFUYKGF1TJFidNX26Ri2E
V9^LWIfKVIFAS8N2O7MbKFUUHf5PHF9TIVY^LWMlPHJ:SY6DUIJFUYBBSh^8Pgmk
Mg=_KFYXJ6MXJF]]L7=fNWj1QHR:S8j?Shn>SH^9QX>0OG]hMG=aL6m_Kfm`LW=e
N7YlOX22Q8F6QhN7QhJ5Q8>1P7imNgYiN7MgMgMgMgQiNWYkO7enOWmoOgmoOgmo
OWinOWemOGemOGinOWmoOgmoOgmoOginOGakNWUiN7MgMgMgMgQiNWamOh22PhF6
QhN8R8N6QHB2P7ilNGMeLg5`Kfi^Kg1aLgEhNgj1Q8N:S8j?T92@Shf:R8B1OGUe
LVi[JFMVIVIWJFa_LgMlP8F9SI6DUYRHV9NETXn:QX1kMW5/IfAQGeiNGf5TJ6ab
Mgf3RHnDV9bOX:2PWY^FTHb5OgQaJfEPG5UGEUIHFf1UJg9iP8N?UI^PY:JXZ:JS
WiZCS8AlM6aUGUUDDDm?D5=GG6=ZLg^4S9BLXZR[[Zn^ZjNRViB;PWU`IemHDTe:
B4U;CeAKHV]eOXRBVj:Y[k:d];>_ZZBLThUoMF]QF55;ATA3A4M<DUYSKGR2SINQ
ZK2e^;Zi]k:/Y9^AQW]`IE]BBdE1?ci0A4YBFfE`O8NBWJN_]KZm_[bi/jbSVHj2
Mf]PEDe5@3`k>ci3BU=MJ7B0S9RR[;Bj_/71_[ZcZj6FRWibIU]@B44l>CPj?TA<
EF1/N8FAWJN`^;k1`l:n^K:YWY>6NVeQETa4?CTg=cXoADiHI71mRIFQZkBk`<?3
`Kfg[jFJSX9eJ5eBBD4l>3Lh>d58DUaXM86>VZF^][g1`l;0^kB[XIJ:OG5TFDm7
@3/i>3XnADeFHFeiQY:MYk2g_L31`;bg[jJLTHEiKF5GCDI0?3/k?T=9DU]VLWj9
UInY/KNk_[jl^;:ZXIN<P7EYGeE=Ad8o?Sm3B4mGHF]fPXfGXJV`]KRj^KJb[:BK
THMlLFMNEDi9AD=3ADU>EEeWLG^5SiRQZ:fb];Bc/:^UWYF<PWU_IUiGDDa:BDU<
D5ELI6aeOXN@V9nUZZf^[ZbYY9jGShMoMViVGeUEDU1@DE=GGF=ZLGV1RI2GW:6T
YZNVY:6LUi6:PgaeKVQRGUYHEeMIG5mTJFmfO8>9SiBHVijOWijLVIF@RhF0NWA_
JfMSHF1OH69TIf]`M7UnPhR<Si:DUYJFUI>@SHZ6PWeiMG9_K6YYJ6UYJfe_LWEh
O7n2QHR:Rhb=SHf<RXR6Q85oO7YhMWAcLW9bLW=dMGIhNW]mOh21PX>3Q8B3Ph:2
PH1oOWemO7akNg]kNg]lO7amOGemOGemO7alNg]jNWYiNGYjNg]lOGioP8:3Q8B5
QHF5QHB3PGmnO7YhMWAcLG1`L71aLgAfNG]nPHB6RH^=SXn?Shf<RXN4P7eiMG9_
K6YXIfIWJ6Y/L7=gO825RHfAU9JHV9RGUI:>RXF0NgE`JfMSH5iMGEiPHfM/LWQn
Q8Z@UIVMX:6RXInKUi:<QGmhLFYTGeYGEEAEEeYNI6YaNH68T9NMXZJYZZZXYJ2K
U8b4O7=[HeaFDTi<C4e@EE]RJW9kQHjFWZF[[k6b/JjZY9fES89hKVELE4i9ATE5
Ad]AF65ZMGn:U9fV[K>g^KVg/jjVWYB:OW=XGUE=AT4o?Sm3B4mHHFahQ8nJY:fe
^[jo_[bg/:NMTXIjKV9GCTDo>cPi>cm6CUQSKgb9UJ6[];_1a<C3_kV`Yi^?PWEX
G557?cTe=3Dh?TE?FVIcPHjKYk:j`LK8b<G0^K2UV8]nL69FBd4i=34`<SLmAU5M
JWR6U:6]]l36b/_:a/2h[J:DQgQZGE15?3D`;Rlb=cm9E65_OHbIY[:la<W<cL[6
_kFZWY22LfEHBd4h<Rh];S8i@TaHIWB3TIn[][o6blg<bLBl/ZJIRga^H5=7?SHa
;Rh`=Ca5DEe[NHRFXjni`/S;c<_7`;N]XI>5MfULCdDl=C4_<3<i@4YFHg1oSIZV
/[_2al[:al>k/ZNKSX1bIEQ=@c/f<S4c=ce6D5aXMX>AWJVc^l75alK3_KJ/XIF8
NfiQETa3?3Pe=CPm@daFHVikR9BPZ[>j_l;3`Kfg[jJKSh=gJemEC4@o>cXk?T=:
DeeXLgn;UZ6Z/[Nk_Kfk][2XWiF:OW=XGUE=Ad=0@455BU5JHfihPhjHXJR_/kJg
][B_ZJ6HShEkL6MNEU1;B4I7BDeBFF5YLgb6SiROYZ^^/;2_[:NQVY::PGQ_IemI
E51>CDiAEEYPIfmgOhR?UYbQYJRYZ:NSWiZCS8EmMVmXHUeIEeEEEeUMHVM]M7^1
R8jDV9bOX:6PWY^GTXf7PG]eKfYVHV1NGEiOHVEYKW=hOH:7S92CUYRHV9NETi2<
R8=nNWIbKV]YIfIVIfQZKG1cMg]nPXJ9Rhf?T92@Shf;RHJ3P7ejMgEcLFm_KVm_
L79dMWQjO7n1PhB6QhN7QhN6QHB3PGmnO7]jNGQgMgMgMgQhNGYkO7amOWioOgmo
OgmoOginOWemOGemOGenOWioOgmoOgmoOgmnOGelNgYiNGQhMgMgMgQiNG]lOGn0
PX>4QHJ7QhN6QXB3PGmmNgUgMG=bLG1`L71aLgAgNGanPHB7RH^<SHj>SHb;R8J3
P7aiMW=`KF]ZJFUYJVa_LWEiOH64R8b?TI>DU9BCTHj;R8=oNgIbKVYWIF=SHfAV
JFa`M7UnPhR=TIBGVIZJVINETHf8PgehLfiYIF9OGUiNH6=VJVmeNh66S96FVIbN
WijMVYNBSHR2NgE_JFAPGE]JFU]MHFEZL7ImPhZ@UIZNX::RXInLV9>=QWmiLV]U
H5aIEeIGFEaPIF]aN7n7SIBIWZ6TYJFSX9bHTX^4OGI_J69MFEIEEEIHG61VKGAk
PXV@UibPY:JVYJ>PW9J@RH9jLfaUH5]GEEADEUUMHVQ_MWj5S9>IWZ:UYZJUXYnJ
U8f6OgQ`JF=NFUMEE5EGFemUJg9iP8N>UIZOXZBUYJ>PW9NARX=lMFiXHUiJEeIF
EeYNHVQ^MGb3RI2EVYjQXZ>RX9fHThj7PGYcKFMSGeaJFEUKGV9VK75hOXB:T9FI
W9jOWijLV9B?RXAnN79]J6AQGeeMGV1SIV]`MGZ0QHZ?TiJIVY^JVIJCSh^6PGag
LViZIfESHV=TIFQ[Kg=hOH65RHf@TYBEUIBCT8j:Qh=oNgMcL6e[JVUYJFY/KW5d
MgYnPHB7RXb=SXj>SHb:R8F3P7ekN7IdLW5`L71`LG=dMWQjO7j0PXB5QXJ7QhJ6
QHB2PGmnOG]jNGUhN7MhN7QiNGYkO7amOWinOgmoOginOWimOGemOGemOGinOgn0
P820P820P7moOWelNgYhMgMfMWEeMWIgN7YkOGn1PhB6QhR9RHV9R8J5Ph1nNgQf
Lg5_KVe/K6e^L79eN7]nPXF9S8j@TY>CTY6?S8V5PGehM71/JFITHf=SI6MZKG9g
O866Ri2DUiZLW9bKV9FAS8J1NWA^JFAPG5YIFEYMH6EZL7MnQHbBV9fQY:JVYJ>O
VYB>QWmgKfQQFeIBD4m@DUIKHFQ`NH6:TYZQYj^^/:n]ZZFNUhj5O79YH5QAC4Q6
ATM;D5INIg5kQY2JXjZa]KRi^;F`ZJ6HSH9gK65HCdQ2?Sdm@4E;DeeXM82<Uj:/
];Zo`L6o^kF/XYN;Og9UFDm5?SPe=3Hj@4QBGFYgQI:OZkFma<S:bLK0^:jRUHQi
JeiAAS`e;bd]<3DlAU9OKGb;VJNc_/O=d=7?bl>j[Z6BPg=TETPm<b`W9RL[<C]6
Df9bPY:Q/;c7cmGGemC>aKZ]WXimKEe=@3@[920P8RL`>TMFIWN8VJVhaLoGg=gL
em35^JZJRGMVEDDh;2<M6a/O9RllBUY/OY2Q/L3<e]gQh]oId<BfYYF2L5i=?S0U
7APG61dV<Ci>Gg:4UjViam?Lh^GTh=W>`K:QSgaYEdHf:QlH51@G7RLd@U=UN8^N
/<3>fN7VinGPel^m[I^8MF9@?c0T6aDB4aPO:SQ8FFaoTjFfa]?Mi>SXi=kDakRW
U85^FdTi:b0H4a8D6R<_?DiPLhJI[;c;en3Uj>ORf/o1/Z2=NVMD@c@W7QLC4aLN
:3E4EFMjSJ2a`LkIhNGVi=kEbK^[VHIcHDlo<BDM5aDF6b<^>d]LKX6CYKK4d=[P
hn?OfLo2]:>AOfeKBS/_9AdI6A/Q:SE3DV=eQiVZ^LKAfMkPg][Bak^/VhYiIeI7
>RhV81dM8BPa?D]JJgb=WZfkam3Ff]_HdlZo/jBDPg=RDdDi;bPT8R@X;cU5Df9b
PY:Q[k_6cM;Ee=7;`[NZW8emKUmAACXb;2TY:c0h@TiKJGR7UZ>`^/?9cLk=bL:i
[Z:EQWQZGE15?CHa<30c>D5;EV9`OH^HY:nh_lC6alC0^K2VVXj1M6MKDDQ0>cPg
>Ca2BU=NJGJ2SYVT[KBj_Knn^kJ`YijCR7aaIUaCBdE2@412ATaCG6E`NXF@VJ:Y
[kBf]kFb[JNOUXf3NFmVGEI@C4U8BD]?EE]SK7EnQi2HWjFY[:j^[:VTWYN?Qgmf
KVMPFUICDE5BE5QMHfYaNH68SiJKWj>UYJFSX9^FT8Z3O7E_JFAOG5YIFE]MHFEZ
L7IlPXR=TYJIVifMW9ZGThn:QH1jMG1/J6ESHV9RI6IYK71eNGj3Qh^>TI>DU9BC
THn<RHF1OGYfLg1]K6YZJVY/KW1bMGUlOh:5QhV;S8b=S8^:R8J4PGmlNWQfM7=b
LG5bLW=dMWMiNgeoP8:3Q8F5QHF5Q8>2PH1oOWakNWYiNGQhN7UiNGYkNgamOGin
OWmoOgmoOWinOWimOGemOGemOWinOWioOgmoOginOWemO7akNWYiNGUiNGUiNW]k
O7enOh61PX>3Q8B4Ph>2PH1nOGajNGMfMGEdM7AeMGIhNG]mOX22Q8F6QhR8R8R7
QXB2P7ilNWQfM7=aLG1`LG9cM7IhNgf0PXB6R8Z;Rh^;RXV7QH>0OW]hMW=aL6m^
KVi_L75dMWUkOX64QhV;S8f=SHf<RXR5Ph1mNWMdLW1^KFa/KFi_LGAfNGb0PhF8
RXb=SXj>SHb:QhF2OgahMW=`Kfe/K6a]KW1bMGMjOX64QXV;S8f>SXf<RhV6Ph5n
NgQeLW1_KVe]KFi`LGAfNGaoPHB6RHZ;S8b<RhZ9QhB2OgajMgEcLG1_Kfm`LG9d
MWQjOGn2Q8J7R8V:RXV8QhJ4PX1nO7YhMWEdLg9bLg=dMGMhNWanOh62Q8B5QXJ6
QHB4PX60OgelNgUhN7MgMgMgN7QiNW]lOGinOh20PH61PH20P7moOWimOGelO7al
O7alO7emOGemOGemOGelO7akNg]kNWYkNg]lO7enOWn0PH:2Ph>3Ph>2PH1oOWek
NWQgMWEdM7AdM7EfN7UkOGn1PhF7R8V:RXZ9R8N5Ph1nNgQfLg5_KFa/K6e^L79e
N7]nPXF9S8j@TI:BTY2>S8V5PGehM71]JFMUI6=TIFQ[KW9gO866RhnCUYVJVi^I
UiB@RhJ0NWE_JVEQGUaKFeaNHVI[LGMnQH^AUibOXZBTXj6MVI>=QWigL6URG5QD
DU5BE5QLHVUaNH69TIVOYJV/[Jf[Z:>MUXf5Ng9YHEUCCTY8B4U=DUQPJ79lQY2I
XJV_/kJg][>^Z:2GSH9gK69HD4U4@3ho@TI<EEiYM82;Uj6[/kVn`<2n^[B/XYN;
OW9UFTm6?cTf=CLj@4UBGVYgQI:OZkFma<S:bLK0^:jRUHQiJeeAAC`d;b`/;c@l
AU9OKGb;VZRd_lS>d];@c<Bk[j6CPg=SEDLk<BXU8bDY;cU5DV9bPY>S/Kk9d]SK
f]OAb;b^WhimK5];?C4W81`L7R@/=dEEIGN9Vjbkb=?LhN;Qg=C9_:bKRGITDT8c
9ahG51DI82XgAeQ[OY6T]LGBgNCXjNKPe/VjZIJ3Ke]9>2XN5A0>41DN:SU:GG65
VJfoc]_Uk>o^j^;Fb;NTT7]WDT0_8AD=2@T<4ah/?4mSN8fR]/SGi>gbm?;/h]G5
/Yj9Lei9=bHH3PL41@XC7bm1EFZ0UZ^od=o[loOglncPd/2]Uh5[ED4^7Q480`44
2QDR<dIKLXRN]<OHi_7gn_Wcj]g=^jJ@NF9=>BLH30@000@<62LiCF=jTJNlc]o[
mO[knO;WfLNdWXQaFTDa81880@001PlM;D1EJh:I[l?Ei>ogno_gk^;C`:bFOfQB
?R/K3PD0008952<dB5edRZ6fbM[Xl_SjnO?Yg<^iY8igHD/g9QL<1@411PlK:Sa@
IWbBZ;c>g^[bmoSekN?D`k2KQFmIAC8R5@`610H<5B8bA5U^Q9V^`M;Pj_7dm>oW
flbkYi=mJ5=0;b0E3@P82a8M:c]=HGJ;X;?5e>3Yk_3^j=oB`k:NRWIQCS`]81H@
3@hB6RHdA5IZOY:U]lODgnKZj^OPe/VjZ9J2Kea:>R`Q6A@C5A/S;ce=Gg:5UjVi
am?Lh^CSg]O<_k2PSW]YF4Pi;B@M6QXM92diAeIWNH^L[;[6d=OLgM[EcL>fYiN6
MFEEAcX`:2<Q8RL]=d=@GfmoSin]^/C<d]CDdLc3^JbNSh1`HUA7?3@^:RX/<3M1
C5UWMXBCX:fh`<O;c<_8`[V_XiJ9NfePDdU0>C@b<cDj@T]EHFikR9FQZkBk`<?4
`[jg[jJKSh=fJUmEC4@o?3/l?dA;E5iYM82;UZ2Y/;Fi^kZh]:jVWI>9OW=YGeM@
BTI4A4E9CUEMIFmiPhfFWZF[[k6b/JjZY9fESHAkLVUQFUE@CTe=Ce9GGFA/M7f5
SIBKX:FXZJVXYJ6LUXn7P7QaJVAOFUMFEEIHFf1UJg9hOhJ<TYNKWZ2QXInLVIB?
RH=mMg5/If=PGUeMGV1SIfaaMW^1QX^?TiJHVIVHUiBASXV5P7]gLVi[J6IUIFEV
J6]^LGEiOH65RHb>T96BTY6?SH^8QH5nNgMdLVm^K6a/K6e_LG=fN7]nPHB6R8V;
Rh^;RXV8QXB2OgekN7MeLg9bLW9bLgAfMgUkOGj0PX>4QHJ6QXF5Q8>2PGmnO7]j
NGQgMgMgMgMhNGUjNgamOWn0P861PH61PH60P7mnOWemO7akNg]kNg]kNg]lO7am
OGemOWinOWinOWinOGemOGemOGemOGemOGinOWinOWinOGemOGelO7alO7]kNg]l
O7alOGemOWinOgmoOgmoOgmoOginOGelO7akNg]jNWYjNg]kO7alOGinOgmoP820
P820OgmoOWimOGalNg]kNgYjNW]kNg]lO7emOWinOgmoOgmoOgmoOWinOGemO7al
O7alO7alO7alO7emOGemOGemOGemOGemOGemOGemOGemOGinOWinOWinOWinOWem
OGalNg]kNgYjNWYjNg]lO7enOWn0P861PX:2PX:1P81oOWelNWUhN7MfMWIfMWMh
NGYlOGn0PX>4QHJ7QhN6QHB3PH1nO7YhMWAcLW5aLG5bLgEgNGanPH>5R8V;S8b<
S8^:R8F3P7ejMgAaKfe[JfY[K6e`LWEiO824QhZ=T9:CTi>BT8j;QhAoNgMcKf]X
IVASHfAVJFa`M7UnPhR<TIBGVIZKVYRFTXj9Q7ihLfeXI61NG5]LGV1TJ6idNX27
SI>HW9nRXj>QWY^FT8Z3O7A]If5LF5ECDeAGFf1VKGAlQ8bCVZ2UZJ^[ZjRUWiVB
RX5hKfMOF5=>BdY;CE1FG6A/MWn9TY^SZJnb];Bc[jZSVi:8OWAYH5M?BDA2@D95
BU5JHfehQ8nJXjbc^Kbn_KZe[jJLTHIjKV9GCDDo>SPh>Sm5CUQSL7f9UZ:]][k3
a/O5`K^bZ9b@PWAWFTi3>c@`;c0c>D5<F6EcPY2NZkO1b<g@d<g7_kFYVhamKUm@
A3T`:RHV:2de?d]IJ7R8V:Ne`L_CemWGdlc2]ZRHR7MVETLi;RHP7AhQ:34mBe]/
OY2Q/Ko<e]gPhMkHclBfYYB2Kee<?BlT71LE5a`T<3e=Gg:5V:Zkb]KPi^WXi=cA
a;BRSg]WE48b9AXB3PhA628_?e5TNHfQ]<GDh>W^l>kXg];2/If8Lei;>2PK4@X7
20dF8S52EV^0UZZncmkYlOGfl^[OdKn/Uh5[ED4^7a890`842aDS<dMLLXVO]<SI
io7hno[djmk>^jJ@NF9<=bDF2P80008:5RDhCF=jTJRmdN7_n?koo?GZflVeWhQ`
FD8^7@h300000@/I:SiCJh>J/LKIjOGmooomm>OGa:jGOfM@>RHE1`0000023Qd_
A5]cS:>jcn7_n_oooo_ahm6mYXmfGTLa7Pl2000000DB8cI<I7bE[<;FioCnoooo
n>gMb[FNQVeE?bXH2P0000002QPZ?UE]QIfdbMc/n?oooogdimK2[9EmIDdh91@7
000000@@7c97GWJ>YK_?hNoioooon>kOc[ZSS7AMAS8P4@D000012QLX>e1WOYJ/
`MCTl?Wmo_[bi]O5/9Z3K5E0;A`?1@000@LB8354FG27WK;6enG`mo[iln[Nc[^W
TG]UCc/Z6`l70`<73aXY>TiSN8jS]lWIiNkcm?;[hMC4/Yj9Lei:>2PK4@/92PlH
93=4Ef^0UJRkbmWSj^k^j^;Hb[ZXUH5/FDLf:1dE4A0B628^?DiPLhNJ[;g;emoU
inKQfLk0/9n<NFMEACHZ8AXG61/R;3Q7EfUkSIj__L[Cf]kOgMO>`kJWUXEcHU94
=bdU8AlQ9B`f@e5PL86AXK2laloDemKCcLBi[9f>OVmODDDj<B`X:2X_=d5=FVQg
QYFS[k[2bLg>c<S2^JnSUHMiJeiAAchg<c4a=3Y1BeIRKgf:Uj>]][g2a<G3_[R_
YIZ>PGEYGE=:@chk>S/oA4]DGfYePHbGXJZa]kZl^kRd[ZJMThQmLVQNETi9AD=3
ADU>EEeVL7Z4SYNOYZb`/[>a[jZTWIF<PgY`J61IE51=C4e?DUMNIFeeOXJ>UIbQ
YJRZZZRUXIbESXMoMg1YHeiJEeEEEUQKH6E[LWV0QhfCV9bOXJ6QWibIU8n9Pgaf
L6]VHf1NGEeNH6=WK75fO867Ri2CUYRIVYVGUI6=RHB0NgIbKVYXIVETIFIXJfia
MGUnPXJ9S8nATY:BTI2>RhR5PGijMgAaKfe/Jf]/KFi`LgIiO7n1Q8N9RX^<S8b;
RXR6Q89oOGYhMWAcLW5aLG9bM7EgNG]mOh62Q8F6QXN7QXJ5Q8:1OgilNgUhMgMf
MWIfMWMhNGYkO7enOh21PX:2PX:2PX60P7mnOGalNgYjNWUiNWYjNW]kO7amOGin
OgmoOgmoOgmoOWinOWemOGelO7alO7alO7alOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOWinOWemOGemOGemOGelO7alO7alO7emOGemOGemOWinOWinOWin
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOWinOWin
OWinOWinOWemOGalO7]kNg]jNWYkNg]lO7emOWmoP821PH61PH61P7moOWelNgYi
NGQgMgMgMgQiNGYlOGioPH:3Q8B5QHF5Q8>2PH1nO7]iMgIeM7=cLg=dMGIgNG]m
P8:4QXN8RHZ:RXV8QhF2P7ekN7IcLG1^KFe]KVmaLgIhO7n2QHR:SHj@T92?SXb:
QhB0O7UeLFi[JFQWIfMYJfe`M7QmPHF9SI6CUINGUiFCT8f9Q7mjMG1/J6ERH5mP
HF=VJVicNGj4RXnDV9^MWYjMViRDShZ4OWMaJfEQGEYHF5QJGF9WKG=jPHV?UY^P
XjJWYZFQWIRARX=kLf]TGUQDDDm?DEAHGVA/M7f6SYJMY:V/[jn^ZjNQVY::P7M]
I5aECd]8ATM:CU=KHfafPH^EWZJ]/[Jh^;Jb[:FLTXQmLVMME4a5@Chn?d=8D5QS
KWV5TIbW[kNl`<70_KR`YifAQGQ/GeA:@S/g=CDh?DA=F6A`OX^IYK2i`LK9b/S3
_;>YW8n1LVAGBd0g<Bd/;C4h@4]HIWB4Tj6^^/C;d=?BclW0]JVJRg][G4i1=RdW
92<V:c@nBeUYNXZKZ[S4c]GJfmWDcL:fYiN6MFACA3L/8ahK720W<Ci<G6j0TZ>d
`/kHgn;RgmW@`kFTTh1]FdXj;B8J5A@F6b@`?TmQM8NJ[Kg<f>7Wj^WTg=73/Z2=
NFEB@30S614=3A4H8c11DfIkSj>famKQj^o`k^OMd<6_VhIaG4Tf9aX@2PL93QLS
<TAHKH:H[<3Agn[amOGajMg?_JZDOfUC?bdN4@T30PD<5bDfBEidRj6fbMWWlOOj
n?;Yfl^hXhefH4Xf91H:0`0010dI:3]?IWfCZ[oAhNkgo?gil^OHa[:LQFiG@BhM
3`@000043Q`]@EM^QIbbamWXm?_oo_W`hm?0ZiAmIDhi9QH9000000HB8CA8GgJ>
YK_>h>gho_onmncNcKVSS7AMAS8P4@D000012QLX>e1WOiJ]`]GUlO[ooo_cimS5
/IZ3Je@o:aX=0`0000D?7Rm3FG27W[C8f^WdnoklmnkQd;fXTWYSCCTV5`/20002
2QHU=daRN8nV^/gNjoCinoSaimW8]9n9LUa7=2<E2P@10`PA7Ri0EFZ1Ujc0dN3[
loKfl^[Od;n[UX5[ET8`8AD<1`H93aTW=dYNLhRM/L?Ch>W`l_3[h]K7]J:>NFA@
?RhP5Pl<310H8c11DfMkSj>eaM?Ni^_/jN;Ic;f/VHIbGd`l;B8I518C6B4/>TYL
Kh:EYkO6d]_Ri>CPfLo2/j:AOVaJBS/_9AhJ6A`R:cI4E6EfR9VY^<G?em_MfmK?
aKRZVXUhIeM9?34Y924R9R`e@DiMKGf=W:^h`/_Ae=CBc<Bj[Z2BPW=TETTn=Bl[
:R``=d1;EfEcPY2NZkJoaL[<blS2^[2UV8]mKf9FBd8k=S<c=SY1BUAPK7V6TijY
/[Vo`/;1_KN`YYb@Q7Q/HEM>Ad4n?3e0AD]DGFQcOXVDWZJ]/kNi^KNc[JJNU8Z0
MF]RFE9=BDI6AdY?EEeUKWR1Ri>KXZR/[k2_[:VSWIF=QGacJfAMF5=ACe1AE5UN
IFadNh>;TYRMXZBVYZFSWiZEShR1NW=/If9NFeUHFE]NHVI/LWQnQ8Z?U9RKWIfM
W9ZFTXj9PgihLfmZIfARHF5RI6IYKG9fNh24R8b?TYBEUIBCTHn<R8B0O7QeLFm/
JfYYJFY/KW1cMWUmP8>6R8Z<SHf=SH^:R8J3PGilNGMeLg9aLG5aLW=dMWQjO7io
PH>4QHJ6QXJ5QHB3PH1oOGakNWUhMgMgMgQhNGUjNgamOWioOh20P820P81oOgin
OWemOGelO7alOGemOGemOGemOGemOGalO7]kNg]kNg]kNgalOGenOgn0P861PH61
PH60OgmnOGakNWUhN7MgMgMgN7UjNgamOX21PX>4Q8F5QHB4Ph:0OgilNWUhMWEe
M7AdM7EfMgUjO7ioPH>4QHJ7QhN7QXF4PX5oOG]iMgIeM7=bLW=cM7EgNG]mOh62
Q8J7R8R8R8N7QHB2P7ilNWQfMGAcLW9bLW=dMWMiNgeoPH>5QXN8R8R8QhJ5Ph5o
OG]jN7IeM7=cLg=cM7IgNGYlOX21PhB5QXN7QhJ5Q8>2P7imNgYhMgIeMGAeMGIf
MgUjNgenP862PhB4Q8B4Ph>2PH1oOWakNWUiN7QhN7QhNGUjNgalOGioOh20P861
P820OgmoOWimOGalO7alO7alO7alOGemOGemOGemOGalO7alO7alO7alOGenOWmo
P821PH61PH60P7mnOGakNWUhMgMfMWIfMgQhNW]lOX21PhB5QXN7QhN6QHB2PGml
NWQfM79aL71_L75bLgEhNWf0PhF8RXb=SXj>SHb:QhF2OW]gM75^K6YYJ6QYJfe`
LgIjOh>7RXjATiFFUYFCTHj:QX9mN7=_JfMTHV5PHF9UJ6aaMW^1QhbAUIVKWIjN
W9ZFTXf7PG]dKVQSGeaIF5QIG5mTJW1gOXF<TYRMXJBVYZFSWi^ESXMoMfmXHE]F
De1?D59FFf5XL7R1RY:JX:J[[Zn_[JVTWYN>QGabJF5IDTe9AdM8Be1GGfMaNhF?
VJ:Y[kBg^;Nd[jVQV8f3N6eRFE19@d0n?d56C5AMJ7=oRiJQZ[>i_/30_[Zd[::G
RgmbIUY@Aclj=cHg>d59DUeZMhBAWZZd_<?7bLS5_kN^XYJ8NVaODTLm=S4^;S0e
?DIBGfelRYVV/kg6c=3@cl[3^ZjQThAdIEI9?C@/:2HW:c4jAU=RLH6AXJnla/oE
emODc/Jk[In?OVeMCT0d:b@P7b4W;cY6EFIgR9VY^<G?emcNgMSAakZ[VhUhIUE5
=b/R71TJ7B@^>TUIJgf?XK;1cMSOhnCQfm;6^:RFPg1NC3d_8a/F51HK8bhlC5ia
Q9NY^/WEgnGXj>CLd/BdXi1lJEI4=2LL5A4@4aXS<3mAI7N;Wk72dMcUj^cZi=c?
`K2MRGEQCS`]81H@3@hB6RDdA5MZOi>W^LWGh^[^k^_TfLblZYJ2KEU6=BHJ4Pd;
3A<M:CQ:GG:6Vjk0d=gVkNo^j^7FakJSSgYVDSl_8AH?2`/>5R0^?U5TNHjR]LKE
hNW^l>gWgM71[ib8Lem;>BXM50h;314J9SA5F6b1UJVkbmWSj^k^j^?Hb[ZXU81/
F4De9Q/C3Pd@5Ql/>dePM8RL[/3?fnCZk>[UgM73/Z2=NFEB@C4T6Q@@4A@L9SA3
EFQkSj:c`m7KhnOXiMoFb[^ZV8EbGddm;b@K5Q@F6b<^?4aMKh:EY[O5dM[Phn?O
f<k1/Z:@OVaJBS/_9AhJ6Q`R:cM4E6EfR9ZZ^LG@emcNg=O?aKRZVXUhIeM8>c0X
8R0Q92/d@4eLK7f=WJbia<gCe]ODc/Jl[j6BPW9SE4Ll<b`X9bT]=3i9EVAcPY6P
[KS1bLg?c/_5_K:VVH]lKV1DB3lg<Rl_<SLnAe9NK7V7U:6/]Kg3a/O5`K^cZIjB
QGQ[GeA;@cdi>3Tl@DQAFfIbOXZFX:Za^;bn_[^g/JVPUX^0M6YOETi8A451@TI;
DUYSKGN2S9JNYZba];Fd/JfWX9R?QGabJF5JE4m<BT]<D5EKHVYcNhB=U9^QYZV[
ZjZWXijHT8V1NG9ZI5iJEUADEEMJGVAZL7MnQHbBUi^NX:6QX9fIUI2:Q7ihLVeX
I65OGUiOHF=WJg1eNh25RXjBU9JHV9NFU96=RHF1O7QdL6eZJ6MWIfQZK6mbMWUm
P8B7RH^=SXn>SXf;RHJ4PGikNGIdLg5`L71`LG=dMWQjO7ioPH>4QHF6QXF5Q8>2
PH1nOGakNWUiNGUiNGUjNW]kO7amOGinOWinOWimOGemOGemOGemOWinOgn0P861
PH61P81oOWelNgYiN7MfMWIfMWIgN7YkOGj0PX>5QXN8R8R8QhJ4Ph5oO7YhMWAb
L71_Kfm`LG=eN7YmP8>6R8Z<SHj>SXf<RXN4PGikMgAaKVa[JFUYJVa^L7AgNgn2
QXZ=Si6CU9BCTHn<RHF1OGQdL6eZIfETI6EVJF]_LgMlPHF:SY6DUYNHUiJDTHf9
QH1kMW5]JFESHF5QHVAWJVmcN7j3R8fAUIRJVi^JV9FBSXV4OWUcKVUUHV1NGUmP
HfIZKgEjP8J;T9BHVYbMWI^IUY:=Qh9lMW5[If=PGUeMGV1SIfaaMWb2R8fBUYVL
WIjMViRET8^6P7YdKfYUHUmMGEeOHFAYKG=iOXB:Si>GVYbMWIbJUY>>RH=nN79]
JFERGeiNGf1SIf]`MG^0QX^@U9NIVi^KVINDT8^6PGafLFeYIF=QH61RI6IZKW=h
OH:7RhnCUINHV9NFTi2<R8AoNWEaKFYWIFATI6EXJVibMWYnPhN;SY6CU9BDTi6?
S8V5PGeiMG9_K6YYJ6QYJVa_LWEhO7n3QXV;SHj?Shn>S8Z8QH9oO7UfM79`Kfi^
KVm`LWAfN7]mP8:4QXN8RHV9RHR7QH>1P7ilNWQgMWEdM7AdMGIgN7YkO7ioP862
PX>3Ph:2PH60OginOGalNg]kNg]kNgalO7amOGemOGemOGalO7]kNg]kNg]lO7em
OWn0PH62PX>3Ph>2PX60OWekNWQgMWEdLg=cM7AfMgUkOGn1PhF7RHZ;Rh^:RHR6
Q85nO7UfLg5^KFa[Jf]]KW5cMgYnPHF9S8jATY>CTi:@SHZ6PWiiMG5]JFITHf9S
I6IYKG5fNh25RXnCUiVKW9bKV9FASHN2O7I`JVEQGU]JFU]MH6EZKgIlPhZ@UY^O
XZBUY::NVYF>Qh1iLFYSGEUEDU5BE5MKHFQ_Mgn8T9NNXjR[[Jf[Z:BNUhn6OGA/
HeaED4a:BDY=DUQOIg1jPhfFWjJ//KBe];:]Yj2HSXAjKfELE4e7A492A4Q>EEiW
LWf8TifV[[Bi_;bk]k6ZXIN<PGEYGUA<ACll>c`oA4]DGVUePXjJYJjf_<73`/2k
]:^QUXUlL6=GCD@m>3Dd=S]1BUAOK7V7U:6/][k4b<W7a;jeZj2CQGMYG515?3Da
;blb>41:EF9`OXfKZ;>maL[=c/_6_kFZWHn0LV=EBChf;b/Z;30g@4]HIWF4Tj6^
^/C;d=;AcLNo]:NIRW][GDm3>30Z9bLZ;cM2CUa[NXZIZ;G0bM3Ce=?>akfaXiF5
MFEFBCdc:bLU9RT`>DABH720T9n^^/G=dmKFdlg5^ZfOSgm_Ge53>2lX92@V:c8l
BEMVMXJFYK>obM3EemGAbl6fZ9V9NFUJC3ld;2LT92L]=T5>G6alS9^Z]l;;d]GF
e<k7_K2RThAdI5E7?38[9bDV:c4kAUARLX6AX:jja<cAe=?@b/:gZYb=OViODDDj
<B`X:2X_=d5<FVQhQiJT/Kc5bloAcl_4^k2TUXMhJE]>@cXb;R`/;cDmAe=PKgf<
VZNb_<C9c<c:aKjdZIf?PG=VFDe3>cDa<38f?4A?FVMdPY2LZ;:k`LG7a/>n]ZfR
UXUlKf=GCD@n>CLg>Ce4C5IQKGZ6TYjX/KRm`<2o^kJ^YI^@Q7Q/HEM?Ad8o?Ci1
ATaDGVQcOXVDWZJ^/kNi^KNc[JJMU8YoMF]QFE9<B4E5ATY>EEaUKWR2RiBLXjV]
/;6`[ZZTWYJ>QGacJV=LEU9?CTi@DeMMI6]cO8B<TiVOXjJXZ:NTXIbFShR1NG9[
IF1LFEMFEeULH6E[LGQnQH^@UIVLWYnOWI^HThj9Q7ihLfiYIV=QH61QHfEYKG5f
Nh24RHf@TYBEUIFDTHn<R8B0O7QeLFm/JfYYJV]/KW5dMgYmP8>5QhV;Rhb<RhZ8
QhF2P7ilNWQfMGAcLg=dM7EgN7UkO7eoP861PX:2PX:1PH1oOginOGelO7alO7em
OGenOWinOWimOGalNgYjNGUhN7QhNGUjNgamOh22PhB5QXJ6QXJ5Q8>1OgekNGMe
Lg5`Kfm_L75bM7MiO7n2QHR:S8j?Shn?SH^9QX=oO7QdLFi[JFMWIVMYJfeaMGUm
PXJ:SY:DUYRHUiJDT8f8Q7iiM6mZIV=QGeiOH69VJVmdNX25Ri2EVIbNX9nNW9RD
ShV3O7I_JFAOFeUGEeQJGV9WKWAkPhZAUibQY:JWYZBQW9J@RH5iLVYSGEQDDU5A
DeIJH6M^MWj7SiJMXjNZ[:b[Z:BNUi27OgI]IEeGDTi<Bda?DeQOIfmiPX^DW:>Y
[K2a/Jn[YInGSXEkLVQPF55<BDM7BDaAF61XLWb6T9VQZ:jb]KFd/JbVWYF<PWM]
I5]CCDQ5@dA7Be5IHF]eP8ZDWJJ]/[Jh^;Fb[:FLThUnLfUOETm9A492@dI;DUYT
KWV4SYRRZ[2e^;Vh][6[XiZ@QGY_IE]CC4I3@D53AdeEGFMbOHRBW:F//[Ni^KRd
[jROUXb1MV]QF51:AD91@TE:D5QQJgJ1RiFOYjjc]kRh][6/Y9^BR7ebJ5mFCdU5
@d=5B4eDG6I`NXB>V:6X[[>e][Fb[JNPUhf3NFmVGEE?BTM6ATQ<DUUQJWAnQi6J
XJR]/K:b/JfXXY^BRH1fKFALEU1<BTY;CE9GGVI_N86:TYZQYZ^][Zj[Z:>MUHf5
O7A[I5eGDe1?Ce1CF5eTJg=kPh^CVInSYjRYZ:FQWIN@RH5iLV]UGe]GEEAEEeYN
HfU`Mgj5S9:GW9nQXZ:QWY^FTH^5OWQbK6MRGeeKFeaNHFEZKgAjP8J;T9BGVY^L
ViVGU92;QX5lMg9^JVMUHf9SI6IXK6mdN7f1QHV=Si:CU9BCTXn=RXJ3Og]gM75_
KF]ZJV]/KFmbMGQkOX63QXR:Rhb<S8^:R8J4PX1mNgUgMGAcLg9cLgAeMWQiNgan
Oh62Ph>3Q8>3Ph:1P7mnOWelO7]kNg]kNg]kO7alOGemOGemOGalO7]kNg]kNg]k
O7amOWioP862Ph>3Q8>3Ph:1OgimNgUhMWEdLg=bLg=dMGMiNgeoPXB6R8Z;S8b<
RhZ8QXB1OW]hMG9`KFa[JVY[K6iaM7MkOh:6RHf?TI>DU9>BT8f9QH5mN7A`K6QV
I6=RHfAWJVibMgb1QX^@TiNIVi^KVYNDT8^6P7]eKfYUHEiLFe]LGf9VJg5gOXB;
T9JJWZ6RXZ6OW9RBS8IoMg1ZI5mJEeEDEEMJGfA[LWV1R92FW:6UZ:VXYjBOVY><
Q7adK6ANF5A@Cdm@DeMMHf]cO8B=UIbRZ:^^[Zf[Yj6KThZ1N6mWGeQBCT]:BTa@
EEaTK7EoR9:JXZR]/K:b/JfXXYZAR7idJf9IDTe9ATI7BTmEG6E_NH>=UYnW[K:e
][Fc[jVQVHn5NW1VGEE>B4E3@dE9CeINJ79lQi6KY:^a]KRh]k>^Z9nFS85fK69I
DDY5@T52ADU@F65[MH2;UInW[[Bh^KVg/jfUWI>8OG9XGUE>B4=1@D96Be9KI6ii
Q8nIXZZa]KRi^;F`ZZ:IShAiKfAKDda7@d92A4Q>EUmXLgf8TYbT[;6e]kRf/ZfV
WYF;P7I[HUUABdM4@dE8C5=JHfegPH^EWZF//KBe]K:^ZJ:IT8IlLVUPF59<BDM7
BDaAEemXLG^4SYJNYJ^_/K6`[JVSW9B<PWU`IemIDdm<Bda>DUMMI6eeOXN?UijS
Z:^/[:^XXifGShMoMViWH5]FDe5ADUAHGF=ZLGV1R92FW:2TYZNVY:6LUi6:Pgae
KVQRGUYHEeMIFemTJFmeO8>9SiBHW9jOX9nLVIFARhJ0NWA_JVISH5mNGf1SIVY_
M7UnPhR<T9>FUiRHUYFBSh^7PWiiMG5^JfUWIVIWJF]^LGAhNgn3QXV;SHn?Shn>
S8Z8QH9oO7YgMG=aL6m_Kg1aLgEfNG]mOh63Q8F6QXJ6QXF4Ph:0OgilNgYiNGQh
N7QiNGYjNgalOGenOWinOWimOGemO7alO7amOGinOgn0PH62PX:2PX61P7mnO7]i
N7MeM7AcLg=dMGIhNWanP8:5QhR:Rhb<Rh^9R8F3P7ejMgAaKVa[JVUZJfa^LGAh
O824R8^?TI>EUIFDTi2=RHF0NgIbKFUVHf5PH65SIFU]LWQmPhV>TiNKWInOWYbI
UY6;QGmhLV]VHEaIEeIGFEaPIF]bNH28SiFKX:BWZ:RVY9nJThb4O7A/I5iHDe1>
CDmBEU]RJW9kQ8fFWJBZ[[2a/:jYY9fES89hKfEMEDm:AdE5B4aAF65ZM7n9TifV
[K>g^KVg]:jWWYF:OgAYGUE=AT4n?Ci2AdiGHFagPhnJYJje^ko0`;fh/JRNThMj
KV9GCD@n>CLg>Ce4C5MRKgb9UJ6/][g3a/O5`K^cZIf@PgEXFdm5?CHb<34e>T9<
F6EcPHnLZKBmaL[<c<W4_;>WVXanKf5DB3hf<2`/;C8i@TiKJGN6UJ>`^lC;cm7@
c<Fl/JFGR7QYFde1=c0Z:2P[<CU4D5i]OHbKZ[K1b]3Ce=;<aK^_XI:2Lf=DAc/b
:bLU9R/b>dMDHg>3TZ:`_<K>dmKEd/c3^:^LSGe]GDi2=RhX92@V;3@nBeUXN8VH
YkG1b]7EemGAbL2dYYN7MfMGBCdc:bHT92P^=d=@GVinSYj/^LC=dmKFdlk6^jjP
TH5aHE=5>S0Z9RDV:c8lB5ITM8BDXk2la/kBe=C@bL6eZIZ;NfaMCd8h<2XW9bX_
>49>G6]jRIRV/kk7cM7Bd<_4^jnRU8EfIeU<@CL`;2X[;cDnB5ERLGn>W:Ve_/K;
cLg;aKjdZ9^>Og5SETY0>3<`;c4e?4E?G6UfQ9:OZkFm`lO9b<Bn]ZfQUHQjKF1E
BT8k=S@e=ca3C5MRKgb9UJ6[];_0`/?1_KN_YIZ?PWIZGeA;A3ll>c`oA4]DGVUd
P8bGXJZa]kZl_;Ve[jNNU8UnLfQNEDi8A492@dM<DeaUKgV4SYNPYjfa];Fd/JbV
WiN=Q7YaIemHDTe;BDY<D5EKHf]dOHJ>UYfSZ:^][J^XY9jGT8R0N71XHEaGE59A
DUEHGF=ZLGR0QhjDVYjRY:FTXYnKUY6:Q7efL6YUHEeKFUYKGV5UJVmeNh67S96E
V9^LW9^IUi>?RXF0NgIaKFUVI6=RHfAVJFa`MGUmPXJ:SI2BTi>CTY6?S8V5PWij
MgAaKfe/Jf]/KFi`LgIhNgj1Q8J8RHZ;Rh^:RHN5Ph5oOG]iMgIdM7=cLgAeMWMh
NW]mOWn1PH:3Ph>3Ph:1PH1oOWemO7akNg]kNg]kO7alOGemOGemOGelO7alNg]k
Ng]kNgalOGinOh21PH:2Ph>3PX:1P7mnO7]jN7MfMGAdM7AeMWMhNWamOh63QHJ8
RHV9RHR7QXB2P7ekN7IdLW1_KVi^Kg1aM7IiO7n2QHR:S8j?Shn>SH^9QX>0O7Ue
LVm/JVUXJ6UZK6mbMGUmPHF9S8nATiBDU9>ASX^7PgmjMW9^JfQVI6ATIFMZKG5e
NWn3R8b@TiJGV9RGUY>@S8N2OGQcKVYWI69PH65SIFQ/LGIkPHJ;T9>GVI^KViVG
U92;QX5kMW1[If=QGeiNGf5TJ6ebN7f3R8jBUYVLWIfLVYNDShZ4OgUcKVUUHEmM
GEeOHFEYKWAjOhF;T9BHVifNWIbJUY:=R89mMg5/If=PGUeMGV1SIf]`MWb1QhbA
UIVKWIfLViRDT8^6P7]eL6]WHf1OGUiPHVEYKW=hOX>8SI:EV9ZKViZHUI6=R8=n
NGA_JfMTHV5QHF=UJFaaMWZ0Q8V=TIBFUiRGUYBASXZ6PGahLfm/JFIUI6AUIfU/
L7AhO865RHb?TI>CU9>BT8f:QX=oNgMdLFi/JVUYJFY/KW5dMgYnPHB7RXb=SXj>
SHb:R8J3P7ekN7EcLW1_Kfm_L79cMGQjO7j1PhB6QhR8R8R7QXF3PX1nOG]jN7Mf
MWIfMWIgN7UjNgamOWn0P861PH61P81oOginOWemOGemOGemOGenOWinOWinOGel
O7]kNWYiNGUiNGUiNW]lOGj0PH:3Q8F5QXJ5QHB3PH1nO7YhMWAcLG5`L71aLgAf
NG]nPHB6RH^<SXj?SXf<RHN4P7eiMW9_K6YXIfMWJ6Y]L7=hO825RHf@TiJGV9RG
UI:>RXF0NgI`K6MTHEmNGUmQI6Q/LWMnQ8Z@UIVMX:6QXInKUi:<QWmhLFYTGeYG
EEADEUYNHfYaNH68T9NMXjNZZj^YYZ6LUHf5O7=[He]ED4e;BTa?DeUPJG9kQHjG
X:N]/KBe];6/YYnFSH9hKF=JDT]6@T51A4Q>EUmYM7n:UJ2Y/KNk_[jl^;:ZXIJ;
Og=WFe58@C`i>3Tm@TYDGVYgQ96MZ;:k`LG7a/>n]ZfQUHQjK5mCB3hg<Rl_<SLn
B5=PKGb:V:Jb_<G;c/o=bL:i[J2BPgAUEdXn=BhY9bP/<S]7E69aPI6P[k_6c]CF
e]?=aKZ]WXinKEe>@3D[9B4P8RL_>TMFIWN8VJVha<oGg=kLf=36^J^KRGQVEDDg
;2<M6QXN92hjBEU[OHnQ/L3=emkShn7Kd/JhYiJ3L5i=?BlT6aHD5Q/S;Sa<GW64
UjVjbMGOiNSWhmcAa;BST7aYET@d9a`E4A0C6R@`@55TN8^O/L;@g>GZk>[Tflo1
/9f9MF5>?2dP5Q0=3Q8J9SA4EfYoTjNibMORj^k^jnCIc;bZUX9]FDHe9QXB3@/=
4adY>4YMLXJK[/3@gNK]knkZhMK7]Z>?NVIB?blQ5Pl;2`hF82hnDFEiSZ:ea]GQ
jNk`kNOMdL6_W8QcGT/i:QdD3@/<4AXV=4EHK86EZK_;fN?Zk^kZhmS:^ZRDP6aH
ACDV6a<>3A0F7b`kCF1dR9b_`<oKi>[/j^GMdL>bX8eiIE90<B@J4a0@51`V<d=E
J7^?X[?3dMcSinSVgmK:^jZHQG9OCCd_8a/F51HK8bhlBee_PYFW]lGAfn7ThmoH
c/6cXY1nK5Y:>bhT7QXI728[=TADIGN8VZZia]3HgMkLf=35^JZJRGQWETLj;bLR
7b0T:S@oCEa/OHjN[K[5c]CGemG?akb`XY:2LV9DAc/b:bLV:2`c?DQFI7>3TZ2]
^L?:c]3@c<Jn/jNJRga^H5=7?CHa;Rh`=Ce6DEi[NHNEXZfg_lC8bLO3_KBZWi:5
N6]NDdU1>cLf=SXoATmJIG9nRiNRZk>j_/30_[VcZj:GS81dJEiDC4I1?ci0@dQ@
F69/Mh:=Uj2X[kBg^;Nd/:ZRVY26O79XGeMAC4Q7AdU=DUQPJG9kQHjFWZBY[Jn_
[Z^VXIZBRX5iL6QQFeIBD4m@DUIKHFM_Mgj6SYBJWj>UYZJTXYjHThb5OWM`JVAP
G5YHF5UKGf=XKWAjP8N<TIJIW9fNWIbIUI6<Qh5lMW5/J6ESHF1QHVAWJVicN7f1
QXZ>TI>EUYJETi6>RhN3Og]gLg1]JfUXJ6UZK6iaM7MkOX64QhZ<SHj>SXf<RXR5
Ph1mNWQfM79aL6m`L75bM7IhNWanP8:4QHJ7QhN7QXF4Ph60OWekNWUhMgIfMWIg
MgQiNW]lOGioP821PH61PH60P7moOWimOGalO7alO7alO7alOGemOGemOGemOGal
O7alO7alO7alOGenOWmoOh20P861P820OgmnOGalNgYiNGQhN7QhN7UiNW]lOWn0
PH:3PhB4Q8B4Ph:1P7imNgYiN7IfMGEdMGEfMgQjNgenP8:3Q8F6QhN7QXF4Ph:0
OWajNGMfM7=cLg=cM7EfN7UkOGn1PhF6QhR8R8R7QXF3PGmmNgUhMWAcLW9bLW=d
MGIhNWanP8:4QHJ7R8R8R8N6Q8:1OgekNGMfM7=cLW9cLgAfMgUkOGn1PXB5QXN7
QhN6QHB3PH1nO7YiMgIeM7AdM7EeMWQiNWamOh22PhB4QHF5Q8B3PX60OWelNgYi
N7MgMgMgN7QiNW]lOGioOh21PH61PH61P81oOginOGalNg]kNg]kNg]kO7alOGem
OGemOGemOGemOGalO7amOGemOWinOgn0P820P820OgmnOWelNgYiNGQhMgMgMgQi
NG]lOGj0PH>4QHF6QXJ6QHB3PH1nO7YhMWAcLW5aLG5bLgEgNG]nPH>6R8Z;S8f=
SHb:R8J3P7ejMW=`KVaZJFUYJVa^LGEhO824R8^>TI>DUIFDTXn<RHB0NgIbKVYV
I69QHF9TIfY^LgQnPhR>TYJIW9fMWI^HU92:QGihLVaWHUiKFEQIFUeQIVabNH27
SYBJWj>UYZJUXYjHTX^4O7A/IEmIEE5@Ce5CEeeSJg=lQ8fEW:>X[:n`[jbXXibD
Rh9hKfIMETm;AdI6B4aBFF5[MGn9U9fU[K:f^KVg/jjWWYB:Og=XGUA<AD0m?3i1
ATiFHFahQ92KYZng_L72`[nj/jZOThMjKF5EBd8k=S<c=SY1BUEQKWb:UjB_^L77
blc:a[nfZinAPgAVF4]0=c0/:R/_=Ci8EF=bPI6P[K[4c=7De=7;`kR/WHinKEi?
@CH]9R8Q92Ta>dQFIWN8VJVga<kFfmgLem36^JZJRGMVEDDg;2<L6QXM92hjBEU[
OI2Q//7>f>3TiN;LdlNhZ9J3L5e;>bdR6A@B51TQ;C];GG64V:^lbmSRj>_[imoD
a[JTT7aXE48a8aP@30/?5B0]?DmSN8bQ]<KEhN[`l_3ZhMC4/Yj:M5m;>2PJ40T6
1`/D82m1E6UoUJZncmkZl_Kgln_Pd/6]V89/ET4_7a880`432Q@R<dIKLHRN/lOH
i_7hno[djmk>_:NANV==>2HG2`<0008:5RDgC69iT:Nlcn3]mocnnoCYflVeX8Ua
FT@`7a0500000``J:SiCJX:I[lCGi_?kooojl^KF`jjHP6QB?2TH2`40000541la
AE]cRZ6hc=g/m_goo_S^hM2lYXmgH4Te8Q<7000000TE9CQ=I7^CZKoBh^oio_ol
m>WJb;BNQVmH@RhM3`D000043Q`]@5I/Q9^aaMOVlOWmo?O_h];0ZiEnIe4l:AX=
10000PXE93E9GWF<X[O:fnSbn?[hl^SJb[NRS7IPBSLV60d60`<84Ad/?U9WOI>X
_<kLj?3emO;Zh=71[YV4KUU5<b@G3PT72@lI9SE7Fg25VZk0d=gWkO3_j^;Fb;NT
T7aWE48a91TA3PdA628_?e5TN8bO/L;@fnCYj^SRfLfn[Y^8MF9@?c4U71HD5ATQ
;3U9FVaoTZ>d`loHgn;RgmS?`kBTTh5_GDdn<RPP71/M8b/f@e9SM8FFY[G2c=CI
fm[Fc/FiZi^;NfYJC3ld;2HT92L]=D1=Ff]jRYZX]L38c];Cd<c4^jnRThAeIeU<
@CPa;B`]<CM0BUISLX2>W:Rc_<?8b/W7`KZaYYV<Og5TF4e4?CPe=CLk@DYCGf]g
Q96LYk2g_L31`;fg/:NMTXIjKV=ID4U3?chn@DE;DeaVLGb7TYbT[;:f^;Rf/jfW
WYF;PGM]I5]DCTY7ATQ:CeELI6efP8VBVZ6WZjj_[jfYY9jGShImMFaUGUQDDDm?
DEAHGFA[LWZ2RY6GWJ6TYZNVY:2KUY29PW]dKFMRGUYHF5QJG61UJW1gOHB:SiBH
VifNWYfKV9B?RXEoNGA_JVISHF1OH69TJ6a`MGYoQ8R=T9>EUiNGUI>ASHZ6PGeh
M75]JfUWIfMXJF]^LGEhO823QhZ<SXn@T92>SH^8QH9oO7UfLg5_KVe]KFi_LG=f
N7]mP8:5QXR9RXZ:RHV7QXB2P7ikNGQfMGAcLg=cM7EfMgUjO7ioPH:3Q8F5QHF5
Q8>2PGmnOGajNGUhMgMgMgMhNGUjNgamOWmoP861PH61PH60P7moOWemO7akNg]j
NWYkNg]kO7alOGemOWinOWinOWinOWinOWemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGinOWinOWinOWemOGemOGemO7alO7alO7amOGem
OGemOGemOWinOWemOGemOGemOGemOGemOGemOGemOGemOGemO@\>"]},
  ImageCacheContents->"Sound",
  CellTags->{"SimpleSound", "G.3.1"}],

Cell[CellGroupData[{

Cell["Implementation", "SubsubsectionIcon",
  CellTags->{"SimpleSound", "G.3.1"}],

Cell[BoxData[
    \(\(Play[Sin[20\ t]\ Sin[23\ t]\ Sin[2000\ t], \ {t, \ 0, \ 2.05}];\)\)], 
  "Input",
  CellTags->{"SimpleSound", "G.3.1"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ", "GroupDivider"],

Cell["Sine Chime", "Subsection",
  CellTags->{"SineChime", "G.3.2"}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.0238095 0.952381 0.0147151 0.588604 [

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

% Start of sampled sound

1 string

11025 22050 8

{ currentfile 1 index readhexstring pop }

 false 1 sampledsound

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7F7F7F7E7E7E7D7D7D7C7C7C7B7B7B7B7A7A7A7B7B7B7B7B7C7C7D7D7D7E7E7F7F7F

7F7F7F7F7F7F7F7E7E7E7D7D7D7C7C7B7B7B7B7A7A7A7A7A7B7B7B7C7C7C7D7D7E7E7E7F7F7F

7F7F7F7F7F7F7F7E7E7E7D7D7C7C7C7B7B7B7A7A7A7A7A7A7B7B7B7C7C7C7D7D7E7E7F7F7F7F

8080807F7F7F7F7E7E7E7D7D7C7C7B7B7B7A7A7A7A7A7A7A7B7B7B7C7C7D7D7E7E7E7F7F7F80

808080807F7F7F7E7E7D7D7C7C7B7B7B7A7A7A7A7A7A7A7A7B7B7B7C7C7D7D7E7E7F7F7F8080

808080807F7F7F7E7E7D7D7C7C7B7B7A7A7A7A7A7A7A7A7A7B7B7B7C7D7D7E7E7F7F7F808080

808080807F7F7F7E7E7D7C7C7B7B7B7A7A7A7A7A7A7A7A7A7B7B7C7C7D7D7E7E7F7F80808080

808080807F7F7E7E7D7D7C7C7B7B7A7A7A7979797A7A7A7A7B7B7C7C7D7D7E7F7F7F80808080

808080807F7F7E7E7D7D7C7B7B7A7A7A79797979797A7A7A7B7B7C7D7D7E7E7F7F8080808080

808080807F7F7E7E7D7C7C7B7B7A7A7979797979797A7A7A7B7C7C7D7D7E7F7F808080808181

808080807F7F7E7D7D7C7B7B7A7A7A7979797979797A7A7B7B7C7C7D7E7E7F7F808080818181

818080807F7E7E7D7C7C7B7B7A7A797979797979797A7A7B7B7C7D7D7E7F7F80808081818181

8180807F7F7E7E7D7C7C7B7A7A79797979797979797A7A7B7C7C7D7E7E7F7F80808181818181

8180807F7F7E7D7D7C7B7B7A7A79797979797979797A7A7B7C7C7D7E7F7F8080818181818181

8180807F7E7E7D7C7C7B7A7A7979797878787979797A7B7B7C7D7D7E7F7F8081818181818181

8180807F7E7E7D7C7B7B7A7979797878787879797A7A7B7B7C7D7E7E7F808081818181818181

81807F7F7E7D7C7C7C7B79777675747474747577787A7C7E80818283848484838382807F7E7D

7C7B7B7B7B7B7B7B7C7C7D7D7D7D7C7C7B7B7A797878787878797A7B7D7E8082838485868686

858482807E7C7A78777574747474757677797B7C7E7F80818282828181807F7F7E7D7D7D7D7D

7D7E7E7F7F7F7F7F7F7E7D7C7B79787776757575757677797B7D7F8183848686878786858482

807E7C7A797776767575767778797A7B7C7D7E7E7F7F7E7E7E7D7D7D7C7C7D7D7E7F80818182

8383838282807F7D7B7A78767574737373747577787B7D7F8183858686868685848381807E7C

7B7A7978787878797A7A7B7C7C7C7D7C7C7C7B7B7A7A79797A7A7B7C7D7F8182838585868686

858382807D7B7977757372727272737577797B7D7F81828384858484838281807F7E7D7C7C7B

7B7C7C7D7D7D7E7E7E7D7D7C7B7A7877777676767677787A7C7E808284868788888887868482

807D7B79777574737373747576787A7B7D7E80818181818180807F7E7E7D7D7D7D7E7F7F8081

81818181807F7E7C7B7977767473727273747577797C7E8183858788898988878684827F7D7B

797876757575767677787A7B7C7D7D7E7E7E7D7D7C7C7B7B7B7C7C7D7E7F8082838485858585

8482817F7C7A7875737271707171737477797C7E8183858687878787858482817F7D7C7A7A79

7979797A7A7B7C7C7C7D7C7C7B7B7A79787777777878797B7D7F818385868888898887868481

7F7C797775737170707172737577797C7E80828384848484838281807F7E7D7D7C7C7D7D7E7E

7F7F7F7F7F7E7D7C7A79777675747373747576787A7D7F828587888A8A8A89888684817F7C79

77757372727273747577797A7C838382817F7E7C7A79787878797A7C7F818486888989898886

83807D797673706E6D6D6E6F7174777A7D8083858788888887868483817F7E7D7C7B7B7B7B7B

7C7C7C7C7C7B7B7A797877777676767778797A7C7E7F818384858686868585848381807F7D7C

7B7978777776767575757575767778797A7C7E808183858687878787868583817F7D7B7A7877

767676777778797A7B7C7C7C7C7C7B7B7A797979797A7B7D7F81838688898A8A8A898784817D

7A76726F6D6C6B6B6D6F7276797D818487898A8A8A888683817E7B7978777778797B7D7F8183

84858483817F7B7875716F6D6B6B6D6F72767B8084898D90929392918E8A85807B77736F6D6C

6C6D6F7175787C7F828485858583817F7C797776757576777A7D8084878A8C8D8E8D8B87847F

7A76716D6A686868696C7074787D8286898B8D8D8D8B898683807D7B7977777777787A7C7D7E

8080807F7E7D7B797775737272727374777A7D808386898B8C8C8C8B898784817E7B78767473

7271727273747677797A7B7C7D7E7F7F808080818182838383848483838281807F7E7C7B7978

7776767575767676777878797A7B7B7C7D7E7F8081828485868787888887868482807D7A7774

72706E6E6D6E707274777B7E81848687888888868583817F7D7B7A7A7A7B7C7D7F8081828382

81807D7B7874726F6D6C6C6D6F71757A7F84888D9092949392908C87837D7874706D6B6A6B6D

6F73767A7E81838586858482807D7A777574747476787C8084888B8E9090908E8B87827C7671

6C6865646365686C71767C82878B8F9192918F8C8985817D79767473737476787B7D80828384

8483817E7B7774716E6D6C6D6F7175797E7B8084898D90929393928F8B86817B76716D696766

67696B6F74787D818587898A89888683807E7B797878787A7C7E818386888989888684807C78

74706C6A6968696C6F73777C8185898C8E8F8F8E8C898683807D7B79787777777879797A7A7B

7A7A797877767574747576787A7D80828587898A8A8A89878583807E7C7A7877777777787879

797A7979787776757474747476787B7F82868A8D909192918F8C88837E78736F6B696768696C

7074797E82868889898886827F7B777573727274777B80858A8F92949593908B857E776F6862

5E5B5B5D61666D767E878E94999C9C9A97918B847D76706C69696A6D71767C82878B8E8F8E8B

87817B746D6863616062656B727A828B93999EA0A19F9B958D857C746D6662605F6165696F76

7C82868A8C8C8B8985817D78757271717275797D82878C8F929392908C88827C76706B676463

6466696D72777D8286898C8D8D8C8A888583807F7D7C7C7D7D7E7F808080807F7D7A78757370

6F6E6E6E707376797D818487898B8B8B8A888683817F7D7C7B7B7B7C7D7E7E7F7F7E7D7B7976

73706E6C6B6C6D6F73777C82878C9194969695938F8A857F79746F6C6A696A6C6F72777B7F82

8486868583807C79757371707072767A7F84898E9396979795918C867F78716A65615E5E5F62

676C737A81878C90929393918D8985807C787574737475787B7E82858788888785817D797470

6C69676667696D71767C82888D919496979694908C87827D7874706D6B6B6B6C6E707376797B

7E7F8181828181807F7E7D7D7C7D7D7E808183848687888888878583807D7A7773706D6B6A69

696A6C6F73777B8085898C8F919292918F8C8985817D716C6A6A6B6E72767B7E818282817E7C

79767472727375777A7D8082848687878787888888898989888784807C76716B666260606165

6B727981888E939595938F8A857F7A77757576797C80848788898784807C77726E6B6A6A6B6E

7175797C7F8182828282828282838587898B8C8D8C8A87837E7974706D6B6A6B6C6F71747779

7B7C7C7C7C7C7C7E7F8285898C8E90908F8C88837D78736F6C6C6D7074797E8386878785807B

756F69656464676D747C868F979DA1A2A19D9790877F77706A6563626364676B6E73777B7F82

85888A8C8C8B8A87837F7A76726F6E6F71767C838B92989C9D9C9790867A6D62574F4B4A4D54

5E6A7886939EA6AAABA8A29A90867C746D686666686C70767B7F838587878684827F7C787572

6F6D6B6A6A6B6E72777E858C949A9FA3A3A19C958C81766B615A5554565A626B757E878E9294

928F8A837C76726F6E7074797F868C91949594918D87807A746F6C6969696B6D707274767879

7A7C7D7E80828487898A8B8B8A888684817F7E7D7C7D7E7E7F7F7E7D7A76716C686462626468

6E767F8891989D9F9F9C968E857C746D6967686B70777E858B8F918F8C867F776F68625E5D5E

61676E757E868D93979B9C9C9B9895908B867F79736D6863605E5E61656A717981898F949695

928D867D756D676362656A727C87929BA3A7A8A59E95897D70645A53504F52575F68727B838A

909395959492908D8A8784817F7C7A78767473737475777A7D8183858685837F7A746E696462

6264686F78818B949BA1A3A3A09A938A8179726C686667696B6F727577797978777676767678

7B7F83878A8D8E8E8D8A87837F7C797878797B7E8183858583807C736A635F5F63686E74797C

7E7F8082868A8F939696948F89837E7B7A7C7F8182807C746C635D5A5B616A76818A9092918D

87817D7A797A7C7D7E7E7E7E7F81868B9195979590867B6E635B58595E656E767C7F7F7E7B79

797B7F858C91959694918C8884828181807E7A756F6964626469717A83898C8A857E766E6A69

6C727A838A8F91908E8B8886868788888784807A75706E6F7174777978746E67615D5E636C79

8795A1A8AAA7A0978D847D787573716F6E6C6B6B6E737A81888D8F8D877F756C656263676E75

7C81848483818183888F969EA3A4A19A8F83766A615A575656585A5D6168707B8895A1AAAEAC

A4978777685D58595F6A76818C939798979592908C88827B72675D544F4D505863707C878E93

9494939394979A9C9C9A93897D6F635A55565B646F7A83898C8D8B8884817E7B78736E686360

60646D7A8998A6AFB3B1A89C8D7E7168646365686B6E6F6F6F6F7073777C808384837F7B7775

767A80878F959797928C847D7977797C808384827C746B635D5B5D626B747D84898B8C8B8A8A

8A8A8A8985817A746F6D6F757E8A969FA4A49D91817060534B494B5159636C747C848B939BA2

A7A9A8A2998C7F73696362656B72797E81807E7B7A797B7F84888A89847B70655B555457606B

7986929CA3A8ABACACABA7A09688776452433A373B47576B7F909CA3A4A0989087807B787674

716F6D6C6E7178818B959DA2A29E968C8178706C6A6A6A6967625D5956575D67758595A3ADB1

B0A9A0958A817974716F6D6B69696A6D737B838C9294918A7F72655B56565B65717E89909494

928E8B89898A8C8E8E8C88837D7774727375767776736D67615E5E626A76828B9AA2A1988A7D

74737A848E94959088827E7D7D7D7B766F6A68696D727575726F6E737C889296928675665D5D

67788998A1A3A19D99969490887E71665F5C5D606363615F60677383939D9F988C7E74717681

8D9698948C837C78777777767473767B838A8D8B82766B6362666E73747068605E6371869BAC

B5B5AEA3988E868079726B6664676E767B7B766E6561646C79848B8A847A737277828E989B97

8D8278727174777A7D80858D959C9E998C7A6757505158626A6C6A666366708092A2ABACA79E

958D898785817C77737375797B7871665C5659647689979D9A9082777170737676736E69676B

7582909BA3A7A9ABABA9A396836A513E3537435567747A7A78787C85909BA2A29C9289817E7D

7C7B787472737880888C8A847A737176808C94948B79655247454C5865717B838B949FA9B0B1

ADA3978C847F7C766E6358505059697E909B9B92827165606269707678797A7D828A9094938F

8B88898D929491887A6D646369748086847B6D605858606D7A858A8A8886858484827E797576

7C8896A2A8A69C8E817976777977706252443D404E63798D9BA3A5A5A29F988F8274675E5D64

707E888D8C8783848A949FA5A296826C594E4A4E555B606263666D76818C94999C9FA5ADB5B8

B4A790755B4840434E5C6971747679808C99A4A8A59A8977675A524C49494C55657C97B0C3CB

C7BAA8978B8685847F756554463F404A586671797E82878E94999A968E87828285898A857A6B

5E575A687D94A6B0AFA6988A7F77716B62584E47474C5764717B838A929DA9B3B7B3A6917A68

5E606A7A878F8F887E75706F727475726E6A686B70767A7A77747478818D979C998F826F737F

8F999D9A938A827A70665E5C6069737A7C7A78787A7E7D776C625F67788B97978D817B8295AE

C0C2B3987B65595758575350515A6B7F8E95928A827D7C7E7F7F7E7D7D7C7A756F6B6F7C90A3

AFAD9F8B797378838C8C82736560636A6C6656463D44597895A9B0ACA49D9B9C9D9B948B8178

70675E57555C6A7D8E9899938C8785837D6F5C4C464E637C8F9389786B6A778DA2ADACA0938B

898D918F887D746F6E6F6D665C524C4D545F6B788797A6AFAFA38F796A6872828E8F86776B6B

7687969C96897D797D858983735E4F4B55677984857E746B67676C737D8A9AAAB5B7B1A4978E

8A88857A6A584C4A52606A6D696364728AA4B5B4A2846756545E6E7A807F7E8087909799958F

8B8B8E92918C847B736D675F5751505865737B786D615E6982A1BBC6C0AE98898382817A6C5D

5457667C8F9895897D75757B80817C736960595554576071869CABAFA8998B83848A8F8D857A

74788391978F7C63514C586C7E867F7060585C6A7B898F908E8D8E8F8D89837F80868F969997

918B867F75675648444F647D90958C7C6F6C778896988C7863585A65737D81838793A6BAC8C8

BAA2866E5D534E4C4D50555C616362616673889EAFB3AB9B8B83848A8E897C6C61616D7E8A8B

807065687A94AEBAB7A48B725F5249423B393C47576A7B8A97A5B4C3CDCFC7B8A695887B6B56

3E2B2633507492A19E8F7F777B8894988F7E6D6362686F706B646167768B9FABB0ADA7A19C98

928C86817D786D5A432D22263C5B7A909A9B9A9DA6AFB3AA947A655D6473828780736969778D

A3B0B1A5927E6D60564F4B4C54616F7A7F7E7C7C81888E8F8A85838995A2A8A18E7767657287

989B93826A554D55697D8783766A656B767D7A6D5F5B667F9CB2BBB7ACA29C968D7E6E615F67

73787160504D5E7EA0B3AF987C69677078735F45353C5A84A9BBB7A5959097A5ADAA9D8D827E

7A72624E3E3C4A60737A736861697C93A1A09385818C9FAEAD9673503C3F547088969B9B9B9F

A3A4A096897D7166594C413A3A414C5865728398AEC1CAC6B69E8879747881888B877D70645C

5B626D787E7D7772737B868F8E837163606A7C8B8E826C5A55607893A9B3B6B5B4B1A8988069

59545A62635C514B51637987877A6C697893ACB4A58565586483A4B7B39E857573787C776A5C

5863788C9692857873767A786C5B5154647A88867665607295BBD4D4BE9D82767880837B6B5C

585F6E7B7E77685B5457606C77808A92989993887E7A808C979B948471636169788691969695

9594918A7D6B5745393842566E838E8D8379778194A9B5B3A4907F797B8185827C777880888B

8576655955585C60626875879AA29B846A5A5E7492A6A69379696C819BAAA7947E7378889593

80634A424D637882827C78797B786C5B4F526788A7B6B19F8F8D9BB0BCB69B795E545C6A6F66

503B3646688EAAB4AC9A897D76716C6663666F7A80807B76788392A1A8A69F99989CA09C8D76

5C4A444A5661635D5146424A5E7B9BB7CAD0CBBDAD9F93897B6A56463F475A71848E8E8A8A91

9DAAAFA89780695442342B2A354C6B889B9F999295A3B6C4C2B19885818A979885613B242741

647E867D6E676E81949F9D948D8B8E8E836C52414255718A97999AA2B4C9D4C8A57853444D64

75735E402C2D466A8A9C9D958F90969A9688776B6B7584919796949394938C7D6C61626F8391

90806750464D5E7D867F70666876889496918C8D959FA4A29A8E82776C5F55525D7694ABB2A6

8E7566646A6D6759494145536370787F8B9FB6C8CEC7B9ABA1998A7252372E3E608598917659

4D5C7D9EABA0856D66738791866B4E424D69869592867F889DB3BCB29F9296A8BAB692581D00

00204B66685A515E83B4D7DDC59F837D8B9DA2906E4D3D445A717E838792A7BCC3B4916C5454

667C84775C433B486074786D5E596989AEC7CCC1AD9D969596948D847B73685846383644607E

949B968D8A8E9392856C54474C60798B918D87878E969C9B98989DA3A394785945475E7D9190

7A5E4E53687D816F523F456797BECBBB9D857F8B9CA3998474717D8A8B7A5F4B4D668AA4A287

624A4D65818C7D5F474A6B9CC2C9AD80594D5F809AA29787818A9CA9A6947D70727E87806748

312F40596A6D6663708FB5D0D0B58D6A5C677F959D96887C787C81827E7977797D7E79716968

6C73746F666166778B97937F645251637F9BACB2B2B0B0ADA4948070696C71706554484A5A70

7F7D6D5C5A6C8EACB4A07955495C83AABDB7A08A8287919080665250637F95988A786F788A96

8F75554146607C8675523431538DC5E4E0C3A29195A5ADA184624F5164787F745E4B47526572

7571717C92A7AFA2866B5F6A859DA494745547506984969C9B9DA7B6C3C4B49775553E2F2828

2E3B4D5F6C71737887A0BDD4DBCFB699837773706A615B5D67768387847E7A7A7D7E7C77777F

8D9896815E3B2A3352768E9182716F83A6C6D5CCB59E969BA4A1896139201E2F485B656B778D

A5B4AE94715A5A718E9F96795848567AA1B8B49E87818FA8B7AF8F64433948637A837C706867

6C6E685E59617793A7AA9C7C6D758DA3A7967D6C6E8197A49E8B766A6C77838A898173604A34

27293C5D7F99A5A7A7AAB2BAB9AB957E6E67686B6A6764666C757E87919DAAB3B19F815D4031

32405261696B696A6F7B8DA1B0B6B2AAA5A9B6C2C0AA8255362F4059686554444254718A9797

97A0B4C5C5A979492F324960675B4E5477AEE1F7E7BD94828CA4B2A67F4D2514192A3A444B58

6E889FA9A79E97979CA0A09A918A898A89837665564E505D738DA4AFAB99816F6C77868D8369

4A34313F53646A6A70819FC0D9E0D6C1A994817062585963717B7A6F60575A697B8789837970

6C6A69696C747F898E8E8F95A1ADAC9A7B5C4F5D81A7BBB293705C5E6D7B7969564E566A7A7D

71625E6A81959B92847E8596A3A08C72646C89AFC9CBB5916D544A4B505353504F515A6A7E90

9C9D958A8589949E9E8F7861565A687987909AA6B3B8AE93715954647B89836B50424A61767B

6D56474F6B91AEB9B09F918F96A1AAADAAA2958169513F3A415163717C848C9499968C7E726A

6764605D616D7E8D9187766D7896BCD5D2B489675C697F8D8978665F667278705B463B3E4D5F

6F7C8A9BAEBABAAD9989858C989E97856F5C52525A697A8B989D988C7F78787B796A533F3C4F

7293A195785B52607F9DADACA49FA3ACB1AA98867B7D8384765B3E2B2B394C585C5D657C9EC1

D6D6BF9B775E565D6D7C827E7367646F86A0B1B4A9998F8F9495886C4C36323F53616460606A

7B88897B6C6B83AED9EEDFB78A6F6E7F8E896F4D383A527184867B6F6F7B8D9B9E968A7E7060

4C3A323C597EA0B4B8B2AAA8A9A9A3988B817B777168615E61686C685F595E708899967F5E45

435A7EA0B2B0A2928A8A8E908D87817F85818590989480675551565A5A585D6A787E7A716D74

8497A7B2B6AC926A463A4F789AA089707298CEEEE2AD6E4743576968533A2A2B3A4E606E7783

95B2D2E6DFBB8A67657F9EA3875B40486C909985634E526A869CA9AEADA1886A51484D555650

4A4C5664707A8AA4C3DCE6E1D7CDC4B3966E462A1B15131A3057809C9D8B7A7D95B2C0B79F87

786F635347495D7584857F8397B4C8C7B0927B747B8996988A6E49291D25384749475376A6C9

CCB1928DA9D1E2C78D564052768B805C382D4679B0D5DABF90655054666F644934395A81958D

75677598B9C2B298888A98A09C8B776860626E849BA6976F40252C4F778C8775696E7F8D9088

7C747377808D9CA8AAA398939598917F6B6775898B70401B193D739AA3978A8B979F977F6556

565E64676A75879DAFB8B7AC9C8F8F9FB5BEA873340C0F366275664B425A85A6A68A6B64799C

B5B6A5938B919A9D917859403B517CA8BBAA7F595271A1C2BD97694C4852574E3E31313E5778

9EC2D9DBCBB6AAACB0A6896757638094875D2E1B316495A99C7B5E55627C939A8D725B59739C

BCBC98684A4E6B888E827987ACD0D6B785605C728A8D744F322A3547576063656A788FAAC0C6

B8A08C8486867D72738AABBEAF814D354369898C74584D5C798F968D7F736E6E747E88887A63

504E5F778A9297A8C5E3ECD3A2715556667473624B383139506F878C795C4E6396CBDDBF8453

4B6E9EB9AF8E7473879A977B5740466792B3BBA783655E728F987D4410042B6EA3AA85594A68

A0D0E1D3BCADAAA695795B4A4B5969767E7F7C767172787C76624D455677969F8F76676C7E8F

96989DA7ADA58B6E5E667D939A948983827F776B5959625F49364371A3B4A07C635E65728395

9D9587828D9EA49D94949DA4A5A29B835626142D5B6E52241849A0E6F5D0966655668CB0B593

5E3B40648691897E7C859AB8D4D6B3784F547B957F45161844748677573A2D385F98CBE3DECB

BDB9B4ACA49E9071492E344F6159464460859B9D9FAFC5CBB79371553B1F0F17365B78889092

9298AED2EEE9C49B8F9DA894663F353F44392D34506F8389898274676B89B6D6D4B58E70615F

6772735F433D64A6D8D5AA8487ABC6B98B5B4243505B5B48250403307EC5E4D8B89B8D909FB2

B79C6A414576ABB9996E5C6A80867D75767B79726D6B65544442567590A1A69B805F516A9CC2

BF99787B9AB8BCA88D74583E34497394967E67657481827A6F6969727F836E4528356CA8C2B4

9EA3C4E4E7CEAB8C6E4F363141555C57565F6B6E68677792ABB8B5A4825B45527B9A9164404A

80B6C6AD8B7B7F8A949EA9AEA6978A84795C33120A1B35506777786B647AB0E9FCE0B09499AA

A8907159452F1E27518BB6C0B19B8C87898E8D7E614848627B744E2A2A52829C9B9291979DA7

BAD0D3B17B57618FBCC4A1683417172F4F605B4E567DAABDAA897E8EA19E836B66707775757E

8886787181A3C1C9BBA58C7259494850575D687B877B5A424D75968F694B537EA9BDBBB2AA9F

918991A2ACA5907A66523F363F53636972869EA58F6F606D80806C5A60768687848FA4AB9874

5F698CB4CAC4A3724A456897AD976B50566B7262493C3A3B41567FA8BAAE9FA5C1D6C89A6953

5F7E9CA8976E42324B7DA3A6907D7E867F685558666857444A6B8FA2A19B968F7F6E6A7990A1

A7A9A9A49686808282776C6E7E8166381B2C5C818064515F849FBCC0AA8B7467626982A3B5B2

A79F957F6B6D80856F5559737A624C5D85967F6267869C978271665C56585A5451699FDAF9EF

CA9E81809AB3AA7E503F43443B415B6C57322F62A1BAAA96959A958A898C84787F9BB2A57950

434E60707D8996A8B9B9A48D8EA2A3793C191D2F35384B605E464068ACE1F8FFFFEFC193848E

8B64321D325A75756352557399A9977A728191949293896437253D63788190A19978637BAFCD

C4B0B2C4C3A5837471644621060014406E85837E8BA3B0ACA39D969196A7A880401F396F9093

95AABAAC908CA6B79E66382C384C61747A6E5E5B646A67697C97ACB3AC967A6C7FA4B2987575

98AF9C756570786A5C6376796B69809A97764F3424233D73A9BEA8857689B3DBE7CB97747A92

926F4B424C4B3E42658FA19FA4B7BBA0775F56472E2A4C7B8B735551698AA6BCCACEC7BCAFA1

9BA4B0A168260C2A5C75705F4E3B2E3E6D96988387B6E8EBBE8D766D5F5052626A5C4B4E6D9A

C2D6CCAD9295B2C8BC9469442206000A1A24396DAAC3A78289B9DED4B19D9F9C8D8187908566

4C454C566578868580838C8D7E6C656B7B94ABA87936142D5F76695F769BABAAB6DAF7EABC8F

75665C6075816C3E1E23405C6A71788290A1A89B7F6A656562698BB5BC95686DA4D3CD9A6443

3B4E82BDD1A2552B40718D8979706A6360666C695D53546382ABC6BE9A8497BDC7A473595B68

7D9EBBB58553485E6955404E717F6848445C7989929AA0A3A5AAAAA299948A6E4B3B4C6E899C

AEBBB0917A7E887959506B8474442A3F636D5E586D8C9D9E9C9A989AA7B4AC8C6B6581ABCBD1

B375361A2E5366635F6462565A85BCC590514877AAB2946F574F5C81A69F81605D8DD6FFF0AE

6B463F4B66828E7F5F47425476938C5B2A2C608F9382859BA29699B4C2A88994BFCCA36F5B58

42201C4374909997876D698CB2A7724D5366625A6F92946F5363838A8293BDD5C2A298A0997B

646D8BA29C79472426445B4E2C1C315E8DB2C9CEC3B6B6BDBAA07859576D86876A46373E5070

AAECFFCA76547AAEB17F421700073676967E564F6D8C9CA6AFAA9EA8CFEBD8A786796241437B

AD923C03175070767E877D666C9BCCD5B895754F2C2642667A82898E8F9DC0DECF9B788CBCCB

A36336282B384B5C6053444C72A6C9C1996E57535B739BBCB6907584A8B0916D657B99ADA886

5846628B9172524A4B495882A59155354F77817C94C2CFB198A8C1A86533385F849B9F875F52

7CBDD7B8886B5B4B4966837337090B2A415788C9EBD8B6B5D3E5CF9B6D5B657984785F4A4145

536A848D7E6762789CBAC5B484461E265893B29F612318519DB99D8192C0DEE5EFF7DA935247

5C572B01000514336C9FA0775D76AFE4FFFFDA8C4D4E747A4B22356A857D7F9EB7AD9AA3B9B1

86646A82897C70674F280C102E577B8E89777798C1CCB6A3B0CED9C6A488746250433E3D3C3B

435E87ACBAB6B1A57F482E5193AD85472B39526A89A7AF9F93A2BCCAC8C0A876443F698E8563

57636D7389A1872F00016FC9CB94685B5A668EC2D1AD7C6B7B92A6B7B58F5A45618B9C938A83

7363677B733D060B509AB5A38B868B8B87878E948F7B66606F838F949A9C908288A7C5C3A78A

765E3A190D173256767E706980A1A48981A1C2B68C7C94ABA08B8B8D71474678A2956D60788A

7E675A555A78ACCAB0754D474439416A8B75433A78C9F2EFDCC199767FB2D6BB702B2C516356

3D28223C78B2C1A6836E5F556590B4A87958658CAEBFBDA271453E5F8FAEAD95797485938369

6B8DA1865B5063633F1E2440556789ADB09B9BC2E5DDB7967F655978ADB88B5D5B654B283D85

AB83494B7A9076606E817E7C95AD9E756A879F8D664C42425C9BD8E0B9A1B4C9B1816B77785D

42424C432511193B6C9AB0A38B8AA7CADDDBBF823D285EADCAA7786B706B6166737269718790

888A9992654256858B61435060514973ABA6694F85D3EDDFE2F4DE934C38444D55686B461B2C

75A89A726C7C7B6F80A6A87448588792725D6F8D99A1BBD6D4AD784F405587AEA372505A767D

726B6757444B68796E667C9CA4917A6E6A79A1C9C59A7B858F745367A3BD99768BB2A66E4849

45291E3E6052314188C6D0BFB19E7E78A9DFD28C5C646A41183481AB988297B8B69F9DA89765

41445452474A565751555F5E596D98B6B5B7D9FFF2B2756985A5B2A273350D13344D55585549

4C7BC7F4E4BFB3AF86472E4B62451C2A658F8B7F8899A5C3F9FFF7B391988F5F35363E22000D

445E4C4F8DC5AF654877B3C5C1CAD4B986676A6E6665716F56496898A790808C9B9B9AA7AB89

5748627354170000235D91B0BDC8D5D3B99EA3BEC4A37E726F5B46517481664E5A767D7887A4

A68158453D394E7F9F8A6576B6D2A05C56819C969DBABC8A5B6EA6B790655D5E4D415A849079

6054453B5490BBAB837E999B6F444B728885889DB0B4B8C8D2BE9470646667583B22254A706E

4A3247759DB8D4E5D09964505A6F848F815D48639ABCB6A294826A6B97BEAB715C83A6853E1E

32463E3B597D7E6760707A7F9BD0F3E6C5BABFB19180816D360A143E555872AACAA7675279A9

AFA08265595E60523F3B495F7A9CB9BBA89EAEC3C1AA92847B7579838B8C8A7A501B08275460

525880A094726C8BAFBFBFBCAD8A696A8EA8945B2E305A88A5AFADA59E9B9683654D484D4C50

6D93925B242A679BA39A998F6F608BD3EAB77669879EA1A6B2AE906B4D3116173B5D5D4F5E8C

ACA48F8B8F8980889B9B7F6058697F8D8D827A7F898D96BAE6E2983C1B3F70827F796C52475D

786E49384B65707E9AAA9F98B7DFD8A787939F8565759E9D5D1C153D63747F8F999CA1A3926C

4A415066736E5A495483BAD2BE9575738AA7B7B5AFA78D5D3B4B7E987D585C7F8C76605B4F32

284F889B836E7D9DB0B6B6A98B716E797E86A6CECA8B4331598A9F98866C4F3E476175715945

4E77A5B7AEA39F8F6E596A877F4F30519BDAEFDCAA705981C5DEB87C543B211934554A201546

829793A6CCD3AE8A90A9A7866C7797AFAC8D5E372F4C73898881828D979C9B94887C77787763

3F2733535F462D3E6D909BB5F2FFFFFFC09A867468665F4220121F3446596D7A7F8A9DACB0B1

B8B594603F4864705D424572B2D2B8826066809FCAF4F4B3634B7091825D4328000009619C94

705E657AAAECFFD58B83BFE3B565392F1F194CA4CEA8717097ABA4A2A68F582B2A4763757963

39274A85A09695B2CEC8AA928578737F92979190938A756B6F69555269765839539BBE975B4D

6368575A7E9B978D959D8E7B87ACBFB9B6C2BB8D57475556433B484A322B67CAFFD681515F80

8C837868514251768B7D64627FACDAFDFFDB9A6C6C8591876D430D000F6EBAAD5A151241769F

B8BFB4A7A7B0B6B1A0826153657D7D6A5F6360525F98D1D0A0818FADB8B09963140000132732

5F9EAC7C6295E0EFCEC7DDD094749BC09033113E69614D5565616794BCA35F425D766E74A9D3

B266455F7768556378736B87B8CBB2979AB1C5CBB47B3F386D9C863D060005184993C3B79085

97A3A0A1A28B635980ADB29B8D856F6081BBC175262C7AB0A27965593A25468EBFB7967D684B

3A507D907A6065829FBCDCE6BF80698DB4A470576B7D69515D776B3818336F9DAEA98C552831

71B2C7B4937A789BD2E9BC6E434F6767616F85898286979B8A76685D5E7BA0995B1E18364A55

7AA6A37672B9FFEEA07990A48C70768170678DB9A45D3648543C3A79B499492D597E726F9FC7

A35F5FA6D5B57B656B6660728D908799BEC4A08185855F30315E8081776F572F245297B9A77D

5C526CA2CCC1906F74838598D1FEE28D5158756E4A2F251E2558A1BF955442679BBFCFBE8647

3B6DA19D70565E61515A9CE9F8C48E899B967A6E787B6A637785683014274755565A5E6176A8

D7D8B7ACC8D9B7857E9DA8865A4840291523517D99B1C7CCB9A08E817674735926092255695C

5D809B918093C1E4F2F7E7B1715F7C8B6940425957485B7A61170046A7BA8E7D9EB19990BCE3

BC61242237558BC2BB6F324D9ECFCCC3C5B38A7C9CAC731400043242414E67778091ABBFC6BC

9C6E5772A9C7B6937A675556769CA6968B8E8A735E5D6465626058484B74A4A4724D5E848769

5F80AABABBC5CDB6825D647F897D727472604F546D848D8C867D767D8F8E6B3F375057341434

8BD5EBE3DED1AE90A0CDD39B5741525C4F403D3A36426485949BA4A18B7D91B1A8692B265790

B1B397653A355C91B8C4B9A5A0B6D1CAA284847C4C1209314B3519224457617CA4B7BAD0FEFF

EEB898805021255470635C6B7A706385CCF0C474516E9AA38E725431161935505D687C939EA0

A2A39D97A0BACFD1C6B9A7855C4956645020031A5580857A829CAB9D857A818C949DA0885321

1B4780A1A8A6A8AEB5BDC0B59E846B513D4366847B523D577E805C414B687F8FA5B198654A66

9DBBB6AAB0B8AC8E77767F827761473A4D7BA2A68C73685C463B517A8E806F75898D8180929C

8E7E92BECB9E5B405D8DA399806B677CA3C1BC9768402110193D64726A667281848BA4C2C6AF

9EABBFB48763668084684A4C6C8C968E847C746C635B5049567AA5B8A67C54424E7091998269

697F9298A4C2D3B67F6A91C4C79869584F382123323635518CB9B48F777A868C919691848496

9E88707DA5B28D615E7D8D847F9098794731466A8599AAAA8C5D40465E6B5F46394E80B0C0AF

9FA8C2D1C6AB948A888681786D5E46291A2B5274848F9B96724B4F7FA49A7F84A2AA8D7689AA

A98157423F507DB4C8A78081A1B0A0908C7F60546E835905000038576285B7C8AC9ABBF3FFE6

AC7752496590A0835946494F546378817F89A2AB9067596B7F79645D697C81735F5A6D878A77

6F88AEC2C7D7EEE8B577595245343F60694417153E698496A0988B9BC2CDA16E6D8C8753314D

819390A8D3D49D6E76938A665D798B7658535A52454D6573758294885F5080C3CD9459507098

BEDFE3B46A3D486F89897A6E70809395836F65573D2E4775835D343C71A3BABCB39C8999CBF0

E2B1835D331421506F6D7091AA926C7EBED5994D4269775A47545D47344C76807481AECFCFCE

E1E5B778657E918A8A98883F0000446F55282A57829BB0C5CBBFB6B3A48260525457606F7157

39406FA0BCD4F1FFE2B2979995724511000026535331275597B7AFA3A39D93A6DFFFEF985146

575D5F76918A5F3F4A6C87929587695D81BACBA16E636C5C352537463B3A68ACCFC6B8C0C5B1

99A5D1EBCD833A141B41686E502F2F5380A3B8BBA5774D445B79858078798596A4A598826C68

84BBE1C97B3A407AA397735F5D59586D8D92714C434D505064879FA3A9B7B5946F68777D7E94

B8B8815068B1D5AD705A686E63626C6440232D4A57535D80A7C0CFDAD2AF8670696160789CA2

76454478ADB8A38C817A74788B9D9B7B4A241C32526C7E867E695E75A1B495666196DBFFF5C8

9068668299895A2E181322559BBD964E325891B3C3D1C3843D3368917333204D8DB5C4C5B599

8EA4BFB79276706A5A5C7D967F47242C3F4653799C946B556D92988686A7CFDCC8A68C858988

765843414D5B6D849BA49D8F806E5E5C6E868F7F614740516B7568607CB0CCB79693A5A38980

9AB39F73637D9CA398875F1900003B879D85614A4C76BDEBD28F6F8FBCBC9B857B5D2E255B9E

AA8466769EBDCFD6BB732408327AA59C6D35162558848972697B939B9EADC2C6AF938B98A5A5

97857972695C4F4436231E428AC4C6A185888E7D676C84896D4D46566F8AA4A9937C89B4D0C6

B0A9A58A665757411B1C5EA8AF774B556F6D5E69878E725F7196ABADA79B837284ACBA9E776F

8496978D76481D2774C9D99A49242F4B61727E7C6B5D6892C6E1CF9C6C5D6D848F8C806D606B

92B3AE8461668EB9CBBA88491E141D222A476E765A4C7BCDFAE9C3AD9E847897C7C88D50455B

61504857676A738EA5A08A7C74655D7CB1BF863B27517A7A635347373D75CDFFFCD7CAD6D9BE

9577685F5648331C0D0B1222457CB0C1B19FA6C2E5E4B16C403945576D807E675C79A9B8946A

70A4D3D6BA9E8868443446626851311D203C6A95A28E716E8CB9E2FDFFE2AF857775603B283B

5A61555C86ABA37A647CA7BAA8856040303F66817347293971B5EAFEE8B686727988939B9B84

5D496395A5773724497A8A7C6B61595A739AA8885646699EBCBBAC9B866F646C829BAFB7AE97

878889734A303D5A5E44334772929EA3A594736480B0BF9C6D5C666A5A4C597EA3BAC5C9C5BB

AD9B7F6253595D4C2E223350616872796E595E8CC6DECEB9B1A5815A5D8EBCB58150475C7580

78624A48699CBEBEA78F807B7C7D6C400E00235B83929798876D74B6FFFFFFAF7C7D8D8A7255

371D132A56777B7375848D887C726F748397A29C928D866E4F4B72A2AD8F747B9193827E95AD

AA918182837A72756E491100063D708990959DA9B2B1A29397AEBDAB87737983776363778072

646E868C7A6C707460413D5C808B8792ACB79B653C3A5C8CADAA8561628CBBCFC3AC9680737D

99A587512F303B373040627571759AC7C99457476B9EBCBFAC9079788CA09F8C76685E585E73

888D867E76624D5480ADAF86615F6B603E2E456B7E808FB2CFD1BFB0ABA79F98917E5D434867

84876E482A2A528EB4A880696E75654F587F9E9B8B8FA7B1A2908F958A6F616C7D82828DA0A1

8663535B6C7673685F627179643C2A4F92C0BDA18F8C898895ABAC875B567CA7B6B3B1AD8F5C

373B5764553F3D4E647170666376A0C8D0BAA29B9A8C73646463565265828F8F9DC3DBBD794A

547C938D7F75644425223B5A6B6B64606985AEC9C4AB9AA1B4C0C2BBA6866D6F7E7036000020

5C7A8499B7C0A688879DA99B8068533B2D36506366666F7A99C0DEECF1EFDCAF744C4A616C57

34273C5C675338324A7398AFB6AD9C9199B2C3B89167535766737F8A8A7553425A90BFCBB9A8

A9AD9C70412829333735353F536E8FAEBFB9A8A2B0C4C5AD91888F8D734C353E5B768796A6A9

906443456380836E564C566E8BA0A08867586A8EA6A79DA0AFB6A17D69728993867571777662

473941566D8091999383787D8C8F7B5C443F495F83B4DDE1B9837091CAE7CD925F4D50534835

231B23406E9AACA39291A1B1AE977D6A5F5A6482A6B1915A37477BABB8AC9FA0A6A191817A78

73695D5143363442555A4C3D4872A3C4D1DBEDFAEBBF8C6E6764564644525E5A4C495D80A1B2

B4AD9E8D8385887C59311E2A44555F739AC1C9A97E708BB6D0CDB9A596897F7A776A4E312736

4F5E5E595A64708197ACB09B8283ACDBDFA246090E4786A8A897857F8AA5C0C4A97B58515F6C

6D645A50443D49668285746C83B0CBB9875C567193AAB6BCBAAB907A737678706254473E425B

839D95704F50708F968B848C948A715F6274838A95A9BBBBA38472727B7F7D756B60607393A7

986B423A5166614C48638B9E9074687696B9D6E5DCBA8B6A67798477583D35436188AAB29665

45517A97895E425484A8A47F5A4C59789EBEC8B28967647D9CAAA3907D6F6D7E9FB7A86F2D0B

1A415B5D59647D8F918C8F9A9F978D91A3B3AE9576615D69839DA58E664F6395B9AA6F321B2F

55768D9DA2957A676A7D877A6256658195978D838390A9C4D0BE96767999AE95531500163A51

5B66798A8F8B888A8A85828FA8BAB4987B6E73808B8F856A4B405E98C4BE8A554A6B96AAA291

867B684E3B33302B29395E8BAFC1C7C8C7C4C6D0D7C6945939466B7468462313214A7EADC7C5

A78065657D979A7F5842517BA1A48357435989B2BAA68C88A0C5DBCFA46C40303E5E78795B2B

05042C699AAA9F929BBBDDE4C8976E6168716A594E5A7B9EAFA7917C747B889397917F654834

324055656B6F7A8EA0A69B8A838B999E927F7784A1B9BAA0795A4D515D6D7D8A8D8067504B5E

7B8E876D5553698591866F616A86A7BDC3BFB7B2B0AB9D835D3214153A739FA47F4D385698D3

DEB3714345698D906E3E222B5487AFC1C0B8B4B9C2C5B7966D5254729399773C090022577C7F

6A586183ABC5C7BAA99C938B848386877C6449393C506A8297AFC9DCDCC59F7D6860594A3420

1A223244576D859AA7ACB1C0D8EBEACDA078615C5B554E50637C897C5D4243628CA7A38A736F

809AA89F805A3A303E5F8396917E717C9EC2D1C0A293A3C5D6BA722300003060705D3F364F80

B2CBC3A1795D5C7599B3B2956E575D7B98A195848293A9AE976F4D435168787B76716F6E6F73

797D77634B405482B4CEC29B766A7C9BAFB0A08E827D7A76706B6967686D767F81766354525D

666150455482BBE0DDBA917E85979E927B6C6D767A705F565F7791A1A194847873777B786545

251B366EA7C1B187656585ACBCAE938692ADBDB2916D5A5D6C767465524541495C717E7B6B5D

6486B8DEDFB87F504250697B807C7B7F88929EA9AFAA98817376858E82613F33415D6C644E44

5885B1BFA97C574E668FB7CCCAB69C8A87929E997D5536334C6D7E776459647D908E7E727B95

ABA8875A3B384E6B818C939AA2A7A6A19D99958E8682828381786F6C6D6B5B3E25234171969B

805F546A94BACCC8BDB4AFA796806B5D534A444656728F9FA09A989B9C927B6A6161666B6A5D

48332D3F6798BECABCA29093A8C0C6B28B685C6C8A9F99774A2A243650626562687E9DB5B7A1

806A6D87A2AB98704B3D4C6D8C9A95898796B2CAD2C29F77553F36363D4958666F6F6A666977

8A9BA3A198908C8D8D8A837E7D848D9495918D8B8A8578624B40496383989985675049546778

8283828287919BA3A6A59E93877E7D82888A806D594D51668197A1A0988F867861462F273552

70817F767588ADD3E5DAB995848DA3AFA177421B132B527483827B7B828D90897B7274819095

8D7B685E5F676D6E6A6971849FB8CACFC7B6A08D817D8081775E38120000163F67828F97A5BD

D8E8E3C7A07D696568686158545A69777F7E7D859AB6CACAB1896148434C585C584F4A4D5766

7580888D9297A0AFC2D5DFD8BD946A4E464E5B60594C4447576C7C83878D9BABB4AC9372584E

545E625B53566F98C3DDD9BD987D7783949C937E66544C4C51575E676E74777676797E82817A

716E7789A0B0B3AA9B8E857E766E6A708197A5A087654D4B5E77847A60463E50718F998E786C

748FB0C4C1AA8B71635F606368728399ABB2AC9B897B757370695D4E423D3F495868757C8085

91A6C0D5D7C29C735A5B718E9E988168595C697472665B5B6B83969B918279797F7F74604F4E

5E788C8E806D667597BEDAE2D7BFA68F7A6653433B3A3D41454C5A6F8798998D7C747E95ADB6

AA8E716062708089898789919895867060607087989889776D717C81775D3E292B44698B9FA0

9488858FA3BAC9CABCA48A766B686560574F4F5B70838C877869646973767168677694B0B9A6

7F594C5E86AAB49F795B587296AFAF9981798499A49979513329303C4448506383A4B8B8A999

8D8C98A9B4B19E836B60646F797C766E6A6D768086837A6E635F626C7B8C989A907A614D4751

6780939B9A999DA7B4BAB6A793827975726959483D3B434F5A646E7E94ACB9B29772544D5F81

9FA99D84717186A1B1AA907261667D939A8B6D52475166798079706D747F8377604D4B648DB5

C7BD9F81758097A8A48A6A565C789AACA485614A4A5D737E7866554D515C656B707C93B0CAD4

CAB0937E77797970604F4B587390A2A1927F747683919791806A55453C3A404E637B8E999A96

959BA7B4B8B1A2938D939C9F92744F2F2126394E5E68707C8D9CA4A2999395A0A9A48C66402B

314A697D807B7C92BAE6FEF3C88E604C54666F6346291C27415B6A6D6D7791B4CED2BF9F8580

8D9FA49474574F5F7D928E724C36416BA1C8D0B99273666B737160473534455E737B7B7D89A1

BDD1D3C7B4A6A09D927A5532212949718F978C786968727F86837A716E7176797978797F878E

90909197A2AAA7967C6358617A939E957D614F4C545E62605F66768C9C9E94847B7D868E8B7D

6D68758FA8B0A0836C6C86ADC9C6A1693821283F54584D42486690B6C4B9A08A8590A0A3957A

645F6D808A8068545674A2C8D1B6865B4957748C8C74533F4158737E755D4A4B638AAEC3C6C0

BABABCB7A4876B5A5B656D675237282F4E789BADABA096969C9E947C5D44394053697B889097

9C9E9C98979DA9B5B8AA8D6B5148505E6864574A485367787E776C68748CA7B9BDB5AAA19B93

82685045506D8C9E9880665E6F90AEB5A07A584C586E7C7458392E406998B5B8A690868B979D

9584777A8EA9B7AD8B644C4E66808978563933496E8D9482685A678BB4CCC6A67D605963747E

7F7B878B939B9E96887972747B817E73645C5D6671736C5F56586982969E9582706A748BA5BA

C3BFB19F8D7D71675F5854515257616E7D888C8980767377818A8D877A6B605E64728292A1AC

B2AFA4927F726F757E827E7368656D7B847F6C523E3E52738F9B927D6A687893ABB6B2A49791

918F867562595E6F838E8B7F726D727B7C705A4643577A9CACA3876A5D6885A2AFA58C72656A

7A898F8A82808A9CACB0A48C725D504A443C373A4A658193968C7F7B87A0B9C7C1AB8E776E71

787C786E64616876838A887F746C6A707A889399978A765E4A40414C5D6E7B858D98A4B2BDC3

C4BEB5A89986725D4C3E352E2B2D384F7096B5C3BCA48A78788493988D7760555A6B7C85837A

767E92A9B7B6A793827A7877706458535760635B483531446C9DC2D0C7B2A2A1ABB6B29B7652

41475E76827C6B5E5F718BA2ABA59585786F645444393D51708C9D9D92898995A5AFAA998477

7987969C90785E4E4F5F7585898172645C5C616A737D858B8E8C86807A797B7F828589909AA7

B0B1A7957E68595354595F6364625F5C606B7E96AAB5B09E877267676B6C675E5961799ABACA

C5B1978580868D8C806C594C48484744444B5D7791A1A1968A8893A5B3B2A189787683929482

5F3C2B375A86A7B3AA998C8B9297927F665147484E514D4647557293B0C1C5C3C3C8CCC6AF88

5E3E36445D73786D58494A5B758B95938B84848A9090897C7069686D747A7F82858786838081

8998AAB8BBAF987A5F4B424043474B4F565F6B7A8A98A2A6A49E9894969A9B95846E59515A72

8EA4A99D877368676C706D6661626C7984857E746E6F777F817E7A7B84939E9E917F74798FAB

BDB99D7451434A5C676B6863616874818784786B646671818F989C9C9A9895908B8685888D8F

88796350484F637B8D9490857D7C818581725D49424C648197A09B8F85858E9DA9AEA99E9084

7A726A625E5F656E757671696361656C717170727C8EA4B5B8AB917564626F83919388786C6B

758593979389807B7B7B766B5B4D4649546474828D959A9B968D8179798495A6ADA897837572

7982867F6F5C4F4E58656F6F6860627088A2B4B6A9927B6A6364696F767C848C9294928D8A8B

90959690837468636567655D51484A58708793918271697188A5BEC8C3B29F8F857E76695A4C

464A5767757F84878B8F9394918B857F7972655443393E537497B1BCB7ABA09CA1A8A99F8C75

6560646C6F6757463C405169808E93908C898B8E9194959696948D806E5E5456637586919696

999FA6A9A18C6E503E3C495B696B6257525B728FA9B9BAB1A59A938D877E736C6A707A838989

85807B77716A635F626B7985887F6E5E5860748B9CA096877B7A83929D9E978B8281878E8F84

715B4C48516376858E918F8B847A70666062697278797571748094AABABEB7AA9D96948F836C

4E33262C43627D8C8C8379777E8A959A978F86807D7B77716B686A727D868D9093969B9E9D95

897E787B81857F6B4D2F1D1E3251708793989DA8B7C6CCC5B29981726D6C6A63584D484D5C70

8698A5ADAFAA9E8B745E504E5560696B665F5D65768B9BA19F9A99A0AEBABDB0967860555863

6D6E645549444B5A6C7D8B96A0A7ABA89E8E7C6E65636465686B748293A2A9A5998B83858F98

97896E503A3540566C7B7F7C797A828C918F867B767984939EA3A0978D847D79757373777C80

7E76685C575D6D7F8B8C8275706F7175787A7C7F858F9BA5AAA79B8875676165707E888B8880

787373787E8280796E625956575D646B727A8695A5B4BDBDB2A08A766B686E767D7E796F655F

5F66707A8182807B78787A7D7E7D7A7674777D858C8D887F746D6E798B9FAFB5B1A4917E6F65

605D5A55504D4E55606E7B858B8E91969CA3A7A59B8A786860636E7E8E96968E82766E6C6F74

797A79777575787B7C79736B656468717C858886817D7E8796A7B5BBB6A7917A685C57585A5C

5D5E616770798083817D79797D8690979892867A727177838E95948C7F726B6A707A858C908F

8C88847F776C5F5146424755687C8C9597969699A1ABB4B6AF9F8A73615654585F666C707377

7D8286868179716D6F76818A8E8B8173676265707F8D9698958F8C8C90969B9B968C7F72685F

59524C46444955698299A9AFAB9E90837D7E838789857E756F6F747E889093918C86817D7973

6B615955576170808B8F8A80746C6C74818F9A9D9B948C878586898986807974727375767570

6A66666B757F85857C6F61595964778C9FABAFABA49C96918C857B70655E5B5F656D73767778

7C838E979C998C786351484A556677858D909192969BA1A4A49F978F8984807A7165574A4345

4E5D6D7A81827F7D808997A5AEB0A8988471625A57595D636B758495A5B2B7B3A79684756C67

635E55493E3739455C7792A7B3B7B3ADA6A09B968E857B726D6C6E70706D67615E616C7C8D9A

9F9B8F81746D6C6F7375726B645F5F667382919DA5ABB0B3B3B0A6947E655043404754636E74

747271747D89939A9992867B726F70757A7F8285898F959A9B958A7C6E66666C778186847A6D

615B5B636E787E807F7D7D80858C91928C8F9293918C857D767170737981888E8F8C84786B5F

555050555E69747F888E9396999B9C9D9C9892897E7268615E6168737F8A9296948E857B726B

6766686B6E7071706E6D6E7278818B959DA2A4A29D97918B8783807C766E655B534D4C505A68

788997A1A5A39B91857A716C6A6B6D7174787B7F848A91989EA2A29D9488796B5E5653545961

6970757676757475798089929BA1A4A29D958C837C7774727271706E6C6B6B6E737B838B9091

8E867C70655D5A5C636D79858E94979694918E8D8D8D8E8D8A867F78716B6867696C6E70706E

6A6765656A727E8B97A1A6A6A1988C8177706D6D71757A7E80818180818283858584807A7168

605B595C636D78838B90918F8C888686898E93989A99948C81766B645F5E5F62666A6D6F7275

797F858C92959590897F746B66666A737E8B969DA09E9990877E7873706F6E6D6B6966656567

6C727A8186898886827E7C7C80868E959A9C9A938A7F756E69696B7075797B7B7975716E6D6E

7175797D7E7E7E7D7D7F83888F949797938C8278706B6A6D747D878E91918C83796F66605D5D

5F6265696E7379808A949EA7ACAEAAA19586786C646061656B7276797978767575777B808689

8B89847D756E6967686C72797F85898D9094989DA1A4A5A1988B796654453B383C4756677988

949CA1A2A19E9A96918A837A7169625F60666F7B88939B9E9D978F857C75706E6D6D6C6A6762

5E5C5C60687482909CA6ABACA9A39C948C857E77716A635D58575A606B7886929A9D9B93887B

6E645E5D60666F7881878C8F92949698999996918980756C646060646A71777B7D7B78736F6D

6F737981888E91908D88827E7C7C7F83888C8D8C85868584817D78726D6763605F61656B727A

838B91959796938E878079736F6E6F72777E858C92969896928B83796F665E595656585D656D

767F878E94989A9A999794908C87837E7A76726F6C6B6A6B6D71757A8085898B8C8B88837C74

6D66615E5E6167707B87939EA7ADAFADA89F9386796C6058525052565D656E7880878C8F908F

8D8A8783807E7C7B7A7B7B7C7C7D7E7F80828385878889898886827D77706A645F5B5A5C6066

6F78838D959CA1A3A29E9890888079736E6C6C6E7074787B7D7E7E7D7B787573717171737679

7D808385868685848281807F80828486898B8C8C8A87827D76706A6561606063676D737A8085

898C8D8D8C8A8987868584858585858483807D7A7673706E6D6D6F7275797D80828382807D79

767371707175797F868D93979A9B99958F888078716A66646364676B6F73777A7C7E7E7E7E7E

7F80818385888A8B8C8C8A8884817D7A7775757577797B7D7F7F7F7D7B7773706D6B6A6B6E72

777D83898D919293918F8C8885817F7D7C7C7C7C7C7B797774706C69676667696D737A81888E

92959694918C86807A7572707173777B8085898C8C8B89847F79736E6966646466696C71757A

7F83888B8F919495969695938F8A847D766E67625E5C5D60666D767F878E939696928D867D74

6D6763626469717A848E979EA3A4A29D968D82786E655F5A58595B5F656B72787F84898D9092

939392908D8A86817C7874706E6E6F71757A80858A8D8E8E8B867F776F68615D5B5C60666F79

848E979EA2A3A29D968E857D756F6B69696B6E72767A7C7E7F7E7C7A78767473737476797C7F

828486878888888887878686858483817F7C7875716E6C6A6A73777A7C7E808080807E7D7B7A

79797A7C7E8185888B8E9091918F8C87827C766F6A6562606062666A70777E858A8F92939391

8E89847F7A767371707174787C81868A8D8F8F8E8A857F78716A645F5C5C5D61666E76808991

999EA2A3A19D9890887F776F6964616163666B71787E84898C8E8D8B87837D77726D6A68686A

6E737981888F959A9D9D9C99938C847C736C65605C5B5C5F646A70777F858A8F9192918F8C88

84807C7976757576787A7E8184868788888683807C7874706C6A69696A6C6F73787C8186898C

8F90908F8E8C898683807D7A7877767574747474747575757676767778797A7C7D7F81828485

868787868685848381807F7D7C7C7B7A7A7A7979787776757474737272737475777A7D808387

8A8C8E90908F8E8B8884807C7774716E6D6C6C6E6F7275787B7D808182838282817F7E7D7C7B

7B7C7D7F81838587888989898785827F7B7773706D6B69696A6B6E7175797D8185898B8D8E8E

8E8C8A8885827F7C7A787776757575767778797A7A7B7B7B7B7A7A7979787878797A7B7C7E80

828486888A8B8B8B8A898784817D7975726E6C6A69696A6B6E72767A7E83868A8C8E8E8E8C8A

8784817D7A787675757577797B7D808183838382807D7A76736F6D6B6B6B6D71757A7F858B90

9497989896928E88827B756F6A67646465686B70757A7F84878A8B8A898683807C7876747374

75787B7F84888B8E90908F8C88837E78726C6865636364676B70767C82878C8F929292908D89

85817D7A777574747577797B7D7F8081807F7E7C79767472707070717376797D8185888B8D8E

8E8D8B8885827F7C7977757474747576777879797A79797878777776777E818386888A8B8C8C

8B898785827F7C79777573737373747677797B7C7D7E7E7E7D7C7B7A7878777778797B7E8184

878A8C8D8E8E8C8A87837E7974706C69676667696C6F74797E83878A8D8E8E8D8B8885827E7B

787675757677797C7F81848586868583807C7874706D6B69696A6D70757A80858A8F92959695

93908C87817C76726E6B6A696A6C6F73777B7F82848686868482807D7A7876757576777A7D80

84878A8C8D8D8D8A87847F7A76716D6A686768696C6F73787D8185898B8D8D8D8C8A8784817F

7C7A7878777878797B7C7D7E7E7E7E7D7C7A787775747373747576787B7E80838688898A8B8A

89888684817E7C7977767473737373737475767778797B7C7D7E7F8081828383848585858584

838281807E7D7B7A7978777676767777787879797A7A7A7B7B7B7B7C7C7D7E7F818284858688

888888878583817E7A7774716F6E6D6D6E6F7275787B7F82858788898988878582807E7C7A79

7879797B7C7E808182838382817F7C797673706E6D6D6E6F7275797E83878B8E919292918E8B

87827D7974716E6C6C6C6E7073777A7E81838485858482807E7B797776757577797B7F828588

8B8C8D8D8B8985817C78736F6C696868696B6E72777C8185898B8D8E8E8C8A8784817D7B7876

75757677787A7C7E80818281817F7D7B797674727171717375777A7E8185888A8C8D8D8C8B88

85827F7B7875737170707071737577797B7D7E7F80808080807F7F7F7F7F7F7F808081828282

828282817F7E7D7B7978767574747474757677787A7B7D7E7F80818283848484848484848382

81807F7E7C7B7977767574737373747576787A7C7E80818283848484838382807F7E7F808182

8383838382807F7D7B7976747371717171727376787B7E8083858789898A8988878583807E7C

7A7877767575767778797A7B7C7C7D7D7D7D7C7C7B7B7A7A7A7B7B7D7E7F8182848586878786

8584827F7D7A7875737271707071727476787B7E8082848686878786858482817F7D7C7B7A7A

7A7A7A7B7B7C7C7D7D7D7C7C7B7A7978777776767778797A7C7E808384868788898887868482

7F7D7A7875747271717272747577797B7D7F8182838383838281807F7F7E7D7D7D7D7D7E7E7F

808080807F7F7D7C7B79787675747373747576787A7C7F8183858788898988878684817F7D7A

78777574747475757778797B7C7D7E7F7F7F7F7F7E7E7D7D7C7C7D7D7E7F8081828283838483

8281807E7C7A78767473727272737475787A7C7F8183858687878786858482807E7D7B7A7978

78787879797A7B7B7C7C7D7D7C7C7B7B7A7A7979797A7B7C7D7F808283848586868685848280

7E7C7977757473727272737576787A7C7E80828384848484838281807F7E7D7C7C7B7B7C7C7C

7D7D7E7E7E7D7D7C7B7A7978777776767677787A7B7D7F8183858687878786858482807E7C7A

78767574747474757678797B7D7E7F808181818180807F7E7E7D7D7D7D7E7E7F7F8080818180

807F7E7D7B7A78777675747474757677797B7D7F8183858686878686858381807E7C7A797877

7676777778797A7B7C7D7D7E7E7E7D7D7D7C7C7C7C7C7C7D7D7E7F808182838383838382807F

7D7B7977767574737374757678797B7D7F81838484858584848381807F7D7C7B7A7A7A7A7A7A

7B7B7C7C7C7D7D7C7C7B7B7A7A79797979797A7B7C7E7F81828384858585848382817F7D7B79

7A7A7979787878787879797A7A7B7C7D7D7E7F8080818181818181818180807F7E7E7D7C7B7B

7A7979797878787879797A7A7B7B7C7D7E7E7F80808181818181818180807F7F7E7D7D7C7B7B

7A7979797978787979797A7A7B7C7C7D7E7F7F80808181818181818180807F7E7E7D7C7C7B7A

7A79797979797979797A7A7B7B7C7D7D7E7F7F808081818181818180807F7F7E7D7D7C7B7B7A

7A79797979797979797A7A7B7C7C7D7E7E7F7F808081818181818080807F7E7E7D7D7C7B7B7A

7A797979797979797A7A7B7B7C7D7D7E7E7F808080818181818080807F7F7E7E7D7C7C7B7B7A

7A7979797979797A7A7A7B7C7C7D7D7E7F7F8080808081818080807F7F7E7E7D7D7C7B7B7A7A

7A79797979797A7A7A7B7B7C7C7D7E7E7F7F8080808080808080807F7F7E7E7D7C7C7B7B7A7A

7A797979797A7A7A7B7B7C7C7D7D7E7E7F7F80808080808080807F7F7E7E7D7D7C7C7B7B7A7A

7A7A79797A7A7A7A7B7B7C7C7D7D7E7E7F7F808080808080807F7F7F7E7E7D7D7C7C7B7B7A7A

7A7A7A7A7A7A7A7B7B7C7C7D7D7E7E7F7F7F808080808080807F7F7E7E7D7D7C7C7B7B7B7A7A

7A7A7A7A7A7A7B7B7B7C7C7D7D7E7E7F7F7F8080808080807F7F7F7E7E7D7D7C7C7B7B7B7A7A

7A7A7A7A7A7A7B7B7C7C7C7D7D7E7E7F7F7F80808080807F7F7F7E7E7E7D7D7C7C7B7B7B7A7A

7A7A7A7A7A7B7B7B7C7C7D7D7E7E7E7F7F7F7F80807F7F7F7F7F7E7E7D7D7C7C7C7B7B7B7A7A

7A7A7A7A7B7B7B7C7C7C7D7D7E7E7E7F7F7F7F7F7F7F7F7F7F7E7E7E7D7D7C7C7B7B7B7B7A7A

7A7A7A7B7B7B7B7C7C7D7D7D7E7E7E7F7F7F7F7F7F7F7F7F7E7E7E7D7D7D7C7C7B7B7B7B7B7A

7A7B7B7B7B7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D

pop

% End of sampled sound

% End of Graphics

MathPictureEnd


\
\>"], "Sound",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oo`008@0000000`00
Oomoo`3oOolMOol100000003001oogoo07Ioo`8000=oo`03001oogoo00Qoo`03001oogoo009oo`03
001oo`00009oo`03001oo`0000Ioo`05001oogooOol0000BOol00`00Oomoo`1YOol100000003001o
ogoo07=oo`03001oogoo00Aoo`06001oogoo001oo`000Woo00X007ooOomoo`00Ool007oo001oo`@0
009oo`03001oo`0000Ioo`D00003Ool007oo0080009oo`03001oogoo00ioo`03001oogoo065oo`40
000000<007ooOol0GWoo00@007ooOol000aoo`800004Ool00000Ool200000goo0000000300000goo
0000000F00000goo001oo`02Ool600000goo001oo`030003Ool00`00Ool00004Ool01000Ool00000
0Woo00<007ooOol0Hgoo0@0000000`00Oomoo`1?Ool00`00Oomoo`05Ool00`00Oomoo`04Ool;0000
17oo001oo`000Woo0`0000=oo`000000500000=oo`0000007P0000Aoo`00001oo`<00003Ool00000
00<000=oo`05001oogooOol00008Ool00`00Ool0001BOol100000003001oogoo04aoo`800003Ool0
07oo00800003Ool0000000800006Ool00000Ool007oo5P0000=oo`000000B`0000=oo`0000001@00
00=oo`00Ool00Woo00<007ooOol00P00B7oo0@0000000`00Oomoo`0iOol01P00Oomoo`00Ool0009o
oh/00003Ool0000000D00005Ool007oo001oo`030006Ool00`00Oomoo`0gOol100000003001oogoo
02Ioo`04001oogoo0002Ool01@00Oomoo`00Ool0]P000Woo0P000Woo00<007ooOol0;7oo0@000000
0`00Ool0003o000L0001Ool100000003001oogoo00Ioool000l000Qoo`40000000<007ooOol0:Goo
00<007ooOol017oo0`0000=oo`000000[P0000Eoo`00000007oo0080035oo`40000000<007ooOol0
?7oo00L007oo000007oo001oo`2B00000goo000000020005Ool01000Oomoo`00>Goo0@0000000`00
Oomoo`16Ool01P00Oomoo`00Ool0009oo`D0009oo`03001oogoo00<00003Ool0000005l00005Ool0
0000001oo`0200000goo001oo`050003Ool00`00Ool0001:Ool100000003001oogoo04moo`05001o
o`00Ool00003Ool00`00Oomoo`04Ool00`00Ool0000200000goo0000000500000goo001oo`060000
0goo0000000L00000goo0000000E00000goo000000030002Ool400001Woo00000000Ool000Yoo`03
001oogoo00Eoo`03001oogoo04Yoo`40000000<007ooOol0I7oo00<007oo00000P001Goo00D007oo
Oomoo`0000=oo`H00006Ool00000Ool007oo0P000Woo00<007oo00000P0000=oo`00Ool00`0000Ao
o`00Ool000Ioo`<00003Ool007oo0080009oo`03001oo`00009oo`03001oogoo00=oo`03001oogoo
009oo`8006Eoo`40000000<007ooOol0J7oo00<007ooOol02Woo00P007ooOomoo`00Ool007oo0`00
00=oo`00Ool00goo00<007oo00000Woo100000=oo`00Ool00P002Woo00<007ooOol00`000goo00<0
07ooOol0LWoo0@0000000`00Oomoo`1VOol00`00Oomoo`0BOol00`00Oomoo`0<Ool00`00Ool00006
Ool00`00Oomoo`0=Ool2001gOol100000003001oogoo08]oo`03001oogoo00Aoo`03001oogoo08Mo
o`40000000<007ooOol0Ngoo00<007ooOol0WWoo0@0000000`00Oomoo`3oOolMOol100000?l00240
000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`1?Ool00`00Oomoo`0MOol01000Oomoo`0017oo
00D007oo001oo`0000Ioo`03001oogoo00Eoo`04001oo`000004Ool00`00Oomoo`04Ool01000Oomo
o`0017oo00<007ooOol00goo0P000goo00<007ooOol017oo00H007ooOol007oo0006Ool00`00Oomo
o`1JOol100000003001oogoo06Qoo`03001oogoo00aoo`03001oogoo01]oo`03001oogoo08Aoo`40
000000<007ooOol0I7oo00D007ooOomoo`0002Uoo`03001oogoo021oo`03001oogoo06Aoo`400000
00<007ooOol0Kgoo00@007ooOol000Ioo`03001oo`00015oo`03001oogoo00Uoo`03001oogoo00ao
o`03001oogoo00Yoo`03001oogoo06Aoo`40000000<007ooOol0Mgoo00<007ooOol02goo00<007oo
Ool06Goo00<007ooOol0N7oo0@0000000`00Oomoo`1iOol00`00Oomoo`0>Ool00`00Oomoo`04Ool0
1000Oomoo`006goo00<007ooOol00goo00<007ooOol0Hgoo0@0000000`00Oomoo`1YOol00`00Oomo
o`06Ool00`00Oomoo`04Ool00`00Ool00008Ool00`00Oomoo`0MOol00`00Oomoo`0;Ool00`00Oomo
o`1WOol100000003001oogoo065oo`03001oogoo00eoo`03001oogoo00Ioo`03001oo`0000Aoo`80
00Uoo`03001oogoo01Eoo`03001oogoo07Eoo`40000000<007ooOol0Ygoo00<007ooOol01Woo00<0
07ooOol0JGoo0@0000000`00Oomoo`1QOol01000Oomoo`000Woo00<007ooOol047oo00<007ooOol0
3goo00<007ooOol027oo00<007ooOol0PWoo0@0000000`00Oomoo`1YOol00`00Oomoo`0BOol00`00
Oomoo`08Ool00`00Oomoo`020006Ool00`00Oomoo`05Ool00`00Oomoo`05Ool01@00Oomoogoo0000
5Woo00<007ooOol0FWoo0@0000000`00Oomoo`1OOol00`00Oomoo`0OOol00`00Oomoo`08Ool00`00
Oomoo`0@Ool00`00Oomoo`05Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`1KOol10000
0003001oogoo05Moo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Ioo`04001oogoo0006
Ool00`00Oomoo`08Ool00`00Oomoo`020003Ool00`00Oomoo`02Ool30006Ool200000goo001oo`04
Ool00`00Oomoo`0=Ool01000Oomoo`00IGoo0@0000000`00Oomoo`1VOol20002Ool00`00Oomoo`0:
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo00002goo00@007ooOol000Aoo`03001o
ogoo00Aoo`03001oogoo00moo`03001oogoo00Uoo`03001oogoo05Yoo`40000000<007ooOol0IWoo
00<007ooOol047oo00<007ooOol01Goo00<007ooOol02Goo0`003goo00<007ooOol0NWoo0@000000
0`00Oomoo`1GOol00`00Oomoo`05Ool00`00Ool0000<Ool01`00Oomoogoo001oo`0000Moo`03001o
o`0000Uoo`03001oo`0000Uoo`800003Ool0000000Qoo`03001oogoo00ioo`03001oogoo009oo`03
001oogoo069oo`40000000<007ooOol0Ggoo00@007oo000000Ioo`05001oogooOol00007Ool20008
Ool00`00Ool00003Ool3000=Ool00`00Oomoo`05Ool00`00Ool00002Ool00`00Ool00009Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`1BOol10000
0003001oogoo04moo`03001oogoo00eoo`03001oogoo00aoo`8003=oo`05001oo`00Ool0000aOol0
0`00Oomoo`10Ool100000003001oogoo05Eoo`03001oogoo00moo`04001oogoo0004Ool01@00Oomo
ogoo00001Goo00D007ooOomoo`00009oo`05001oogooOol00004Ool20004Ool2000AOol2000;Ool0
0`00Oomoo`0WOol00`00Oomoo`10Ool100000003001oogoo04moo`03001oogoo00=oo`03001oogoo
01Moo`03001oogoo00=oo`03001oogoo011oo`8000Yoo`800003Ool007oo009oo`05001oogooOol0
0005Ool00`00Oomoo`04Ool00`00Oomoo`05Ool01000Oomoo`003Woo00@007oo0000059oo`400000
00<007ooOol0AGoo00<007ooOol0:Woo00<007ooOol01Goo00@007ooOol000Aoo`03001oo`0000ao
o`800003Ool007oo00Uoo`04001oogooOol200000goo001oo`03Ool00`00Oomoo`08Ool2001TOol1
00000003001oogoo04aoo`03001oogoo01Moo`03001oogoo00Moo`04001oo`000002Ool01000Oomo
o`000goo00<007ooOol00Woo00D007ooOomoo`0000Uoo`<000Aoo`03001oogoo00Aoo`H00004Ool0
07oo0006Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo0P00Ggoo0@0000000`00Oomoo`14Ool2
000AOol00`00Oomoo`05Ool20004Ool01000Oomoo`001Woo00<007oo000017oo0P0000=oo`00Ool0
0goo00<007ooOol00goo00<007ooOol01goo00@007oo0000009oo`03001oogoo00Eoo`8000=oo`03
001oogoo00Moo`03001oogoo00]oo`03001oo`0000Yoo`03001oogoo011oo`03001oogoo041oo`40
000000<007ooOol0C7oo00<007ooOol01Goo00<007oo00004Woo0P0037oo00@007ooOol0009oo`<0
00Eoo`03001oogoo00<00004Ool007oo0002Ool00`00Oomoo`08Ool00`00Oomoo`04Ool30006Ool2
0002Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool01000Ool00000DGoo0@0000000`00Oomoo`1FOol0
0`00Oomoo`06Ool00`00Oomoo`0NOol00`00Oomoo`0>Ool00`00Oomoo`04Ool00`00Oomoo`0:Ool0
0`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`0<Ool20002Ool2001COol100000003001oogoo
04Aoo`03001oogoo00Eoo`03001oogoo00Eoo`04001oogoo0003Ool00`00Oomoo`020003Ool20005
Ool00`00Oomoo`04Ool00`00Ool00002000027oo001oo`00Ool007oo0003Ool00`00Oomoo`02Ool0
1000Oomoogoo0P0027oo00D007ooOomoo`0000=oo`03001oogoo00Aoo`05001oogooOol00002Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool30005Ool00`00Ool00004Ool01@00Oomoogoo00001goo00<0
07oo0000BWoo0@0000000`00Oomoo`15Ool00`00Oomoo`05Ool00`00Oomoo`0@Ool00`00Oomoo`03
Ool20005Ool01P00Oomoo`00Ool0009oo`<000Eoo`03001oo`0000Uoo`03001oogoo009oo`8000io
o`03001oo`0000]oo`03001oogoo00=oo`04001oogoo0006Ool00`00Oomoo`0@Ool00`00Oomoo`07
Ool00`00Oomoo`10Ool100000003001oogoo04ioo`03001oogoo00=oo`03001oogoo00]oo`05001o
ogooOol0000:Ool01@00Oomoogoo000017oo00<007ooOol017oo00D007ooOomoo`0001Eoo`07001o
ogooOol007oo000017oo00D007ooOomoo`00021oo`05001oogooOol0001<Ool100000003001oogoo
055oo`03001oogoo00@000Moo`03001oogoo00Ioo`03001oo`0000=oo`03001oogoo00Yoo`03001o
ogoo00Moo`03001oogoo00<000Eoo`8000]oo`03001oogoo00=oo`04001oo`000002Ool00`00Oomo
o`07Ool20003Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Ool00003Ool00`00Oomoo`0<Ool0
0`00Oomoo`10Ool100000003001oogoo055oo`03001oo`00009oo`<000=oo`03001oogoo00=oo`<0
00Aoo`05001oogoo001oo`020006Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00D007oo001o
o`00009oo`800007Ool007oo001oo`00Ool00P0000Moo`00001oo`00Ool00002Ool00`00Ool00003
Ool00`00Oomoo`04Ool00`00Oomoo`020002Ool00`00Ool00002000?Ool20006Ool00`00Oomoo`07
Ool00`00Oomoo`10Ool100000003001oogoo04Aoo`03001oogoo00eoo`03001oogoo019oo`03001o
ogoo00aoo`8000moo`04001oogooOol2000<Ool01@00Oomoogoo000017oo00@007oo000000Eoo`03
001oogoo00Aoo`03001oogoo00=oo`<000Moo`03001oogoo00Aoo`03001oogoo00]oo`03001oogoo
041oo`40000000<007ooOol0>Goo00<007ooOol02Woo00<007ooOol00goo00<007ooOol017oo00H0
07ooOol007oo0007Ool2000017oo001oogoo1@000goo00<007oo00001goo00<007oo00001Woo0P00
1Goo0P002Goo0`0000Aoo`00Oomoo`800003Ool007oo009oo`05001oogooOol00006Ool40002Ool0
1P00Oomoo`00Ool000Ioo`03001oogoo00Moo`03001oogoo00Aoo`03001oogoo00Uoo`03001oogoo
03ioo`40000000<007ooOol0=7oo00<007ooOol00Woo00<007ooOol03goo00H007ooOol007oo0005
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool02`00Oomoogoo001oo`00Ool007oo00000goo00L007oo
Ool007oo001oo`0200000goo001oo`07Ool00`00Ool00004Ool00`00Oomoo`03Ool00`00Oomoo`03
0002Ool00`00Oomoo`03Ool00`00Oomoo`02Ool02@00Ool00000Ool007oo001oo`0300000goo0000
0007Ool2000017oo000000002Goo00@007ooOol000=oo`03001oogoo008000moo`03001oogoo03Mo
o`40000000<007ooOol0BGoo00<007ooOol017oo00<007ooOol02Goo00<007ooOol00P000goo00<0
07oo00001Woo0P0000=oo`00Ool01Goo0P001Woo00<007ooOol01Goo00<007ooOol00goo0P0027oo
00<007oo00004Woo00<007ooOol01goo00<007ooOol00Woo00D007ooOomoo`0000Uoo`03001oogoo
00=oo`03001oogoo01Moo`03001oogoo031oo`40000000<007ooOol0=7oo00<007ooOol03Goo00H0
07ooOol007oo000;Ool00`00Ool00002Ool3000017oo001oo`000goo00@007oo000000Aoo`07001o
ogooOol007oo000027oo0`001Goo00<007ooOol017oo0P000Woo0P0017oo00D007oo001oo`0000=o
o`<000Eoo`8000=oo`03001oogoo009oo`05001oogoo001oo`02000017oo000000002Goo00D007oo
Oomoo`0000=oo`80009oo`03001oo`0000Ioo`05001oogooOol00006Ool00`00Oomoo`0gOol10000
0003001oogoo03Aoo`03001oogoo00eoo`@000=oo`80009oo`03001oogoo009oo`03001oo`0000=o
o`800003Ool007oo00=oo`04001oogooOol20004Ool00`00Ool00002Ool01000Ool000000Woo00@0
07ooOol0009oo`8000Aoo`H0009oo`04001oogooOol20005Ool00`00Oomoo`02Ool00`00Ool00003
Ool00`00Oomoo`020003Ool40007Ool01000Ool000000goo00<007ooOol017oo00<007oo00000P00
1goo00@007ooOol000Eoo`03001oogoo00moo`03001oogoo031oo`40000000<007ooOol0>goo00D0
07ooOomoo`0000moo`03001oogoo00moo`03001oogoo00=oo`03001oogoo00Eoo`8000Uoo`800003
Ool0000000Aoo`05001oogooOol00005Ool00`00Oomoo`04Ool40003Ool01@00Oomoogoo000017oo
00D007oo001oo`00009oo`04001oogooOol200000goo001oo`09Ool01000Oomoogoo0P0000=oo`00
Ool02Woo00<007ooOol0BGoo0@0000000`00Oomoo`0iOol01000Oomoo`001goo00@007oo000000Ao
o`05001oo`00Ool00003Ool01P00Oomoogoo001oo`<000Eoo`03001oogoo009oo`80009oo`04001o
ogoo0002Ool00`00Ool000030003Ool2000027oo001oogoo001oo`00Ool3000017oo000000000Woo
00<007ooOol00goo00<007ooOol00goo0P0000=oo`0000000Woo00<007ooOol00Woo00<007ooOol0
0Woo0P0000=oo`0000000Woo00T007ooOol007oo001oo`00Ool0100000Ioo`00Ool007oo0005Ool0
1`00Oomoogoo001oo`00009oo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo03Moo`400000
00<007ooOol0>goo0P002Woo00<007ooOol00Woo0`000Woo00<007oo00000Woo00D007ooOomoo`00
00=oo`03001oo`0000800005Ool007oo001oo`020002Ool01000Ool000000goo0P000Woo00<007oo
00000Woo0P000Woo0P0000=oo`00Ool00Woo00<007ooOol00Woo00<007ooOol00Woo100000Aoo`00
Ool000=oo`<00005Ool007oo001oo`02000017oo000000000goo0P000goo10000goo0`0000=oo`00
Ool00goo00@007ooOomoo`800004Ool000000002Ool20003Ool01@00Oomoogoo00000goo00<007oo
Ool017oo00<007ooOol0=goo0@0000000`00Oomoo`14Ool00`00Oomoo`03Ool50008Ool00`00Ool0
0007Ool00`00Oomoo`03Ool20002Ool20004Ool01`00Oomoogoo001oo`0000Ioo`8000Uoo`800003
Ool00000009oo`05001oo`00Ool00002Ool01@00Ool007oo00001Woo00<007ooOol027oo00@007oo
001oo`800005Ool007ooOol00002Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007ooOol0
1goo0P002Goo00<007ooOol0>goo0@0000000`00Oomoo`0dOol00`00Oomoo`02Ool01000Ool00000
0Woo00L007ooOomoo`00Ool00005Ool01000Ool007oo0P0017oo00<007oo00001Goo0P0017oo1P00
0goo00<007oo00000goo1`0000=oo`000000200017oo00<007oo00000P000Woo00<007ooOol00Woo
0P0017oo00<007oo0000100000Aoo`00Oomoo`8000=oo`800003Ool0000000800005Ool007oo001o
o`03000017oo001oo`000Woo0P0000=oo`0000000P0017oo00<007ooOol01`000goo00@007oo0000
00Aoo`04001oo`00000iOol100000003001oogoo03Yoo`03001oo`00009oo`03001oogoo00Aoo`05
001oogoo001oo`0400001Goo001oogoo00001Woo00<007ooOol010000goo0`0000Moo`00000007oo
001oo`020002Ool00`00Oomoo`02000017oo000007oo0`0000=oo`00000010000goo0`000Woo0P00
0goo00H007ooOomoo`00Ool3000017oo000007oo0P0000=oo`0000000`000goo00D007ooOol007oo
00800006Ool007oo001oo`000Woo0P0000Eoo`00Ool007oo00<000=oo`<0009oo`03001oo`0000Ao
o`03001oogoo00<000Ioo`800003Ool0000000Ioo`03001oogoo031oo`40000000<007ooOol0=7oo
00<007ooOol00goo00@007ooOol000Ioo`03001oogoo00Eoo`04001oogooOol200000goo001oo`05
Ool01000Oomoogoo0P000goo00<007ooOol02goo00@007ooOomoo`80009oo`04001oo`000004Ool0
1000Oomoo`000Woo0P0000=oo`00000017oo0P000goo0P0000Eoo`00Oomoo`0000Aoo`03001oogoo
00D00003Ool007oo00=oo`@000ioo`04001oogooOol20002Ool00`00Oomoo`05Ool4000:Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0`Ool100000003001oogoo03=oo`03001oogoo00Io
o`03001oogoo00Aoo`8000Uoo`800003Ool00000009oo`03001oo`0000Ioo`<00004Ool007ooOol2
00000goo001oo`030007Ool20002Ool00`00Ool00003Ool500000goo000000020002Ool200001Goo
001oo`00Ool00`0000Qoo`00Ool007oo001oo`001goo0`0000Eoo`00001oo`0000=oo`@000=oo`03
001oo`00009oo`08001oo`00001oo`00Ool0009oo`04001oogooOol40003Ool01@00Ool00000Ool0
1@0000=oo`00Ool00goo00@007oo000003Uoo`40000000<007ooOol0:Goo00<007ooOol01goo00<0
07ooOol01Goo0P000goo0P000goo00D007oo000007oo008000=oo`03001oo`000080009oo`@000Ao
o`03001oogoo00800003Ool007oo00=oo`06001oo`00001oo`000Woo00<007ooOol00P0000=oo`00
00000P000goo00D007oo000007oo0080009oo`800003Ool00000009oo`<0009oo`800005Ool00000
Ool00003Ool3000017oo000000000Woo0`000Woo0P001Woo0P0000Eoo`00001oo`00009oo`800004
Ool007oo0003Ool30002Ool01@00Oomoogoo00000Woo0`000Woo00D007ooOomoo`0000Ioo`03001o
ogoo03Qoo`40000000<007ooOol0>Woo00D007oo000007oo00D00004Ool007oo0004Ool01@00Oomo
ogoo00002Woo0P0000=oo`00Ool00Woo00<007ooOol027oo00<007ooOol00`0000=oo`00Ool00Woo
00<007ooOol00goo0P0000=oo`0000000goo00<007ooOol00P002Goo00@007ooOol000=oo`04001o
ogoo0002Ool00`00Ool00002Ool00`00Oomoo`03Ool200000goo001oo`020008Ool01000Ool007oo
0P0000=oo`0000000goo0P000Woo00<007ooOol00P0000Uoo`00Oomoo`00Ool007oo00001Woo00<0
07ooOol00Woo00<007ooOol0=Goo0@0000000`00Oomoo`0YOol00`00Oomoo`05Ool00`00Oomoo`07
Ool300000goo00000002Ool01000Oomoo`000goo00<007ooOol01@000Woo00<007ooOol00P0000Io
o`00Ool007oo0003Ool40004Ool20002Ool01@00Oomoo`00Ool00P0000=oo`00Ool00Woo00<007oo
00000Woo00D007oo001oo`00009oo`03001oo`00009oo`03001oo`0000Aoo`80009oo`<00004Ool0
0000Ool400000goo001oo`05Ool00`00Ool00002Ool00`00Ool00003Ool500000goo00000002Ool5
000017oo000000000Woo0`0017oo00<007oo00000Woo00@007ooOomoo`80009oo`05001oogooOol0
0002Ool00`00Oomoo`0eOol100000003001oogoo02Uoo`04001oogoo0004Ool00`00Oomoo`04Ool0
0`00Ool00003Ool01@00Ool00000Ool01@000goo00<007oo00001Goo00@007ooOomoo`D0009oo`03
001oo`00009oo`800004Ool00000Ool400000goo001oo`020002Ool500001Woo000007oo001oo`80
0003Ool007oo00D000Eoo`8000=oo`<00007Ool007oo001oo`00Ool00P000goo0P000goo0P0000Mo
o`00Ool007oo001oo`030003Ool500001Woo000007oo001oo`P00003Ool00000009oo`<0009oo`<0
0004Ool007ooOol200000goo001oo`03Ool00`00Ool00008Ool00`00Oomoo`0/Ool100000003001o
ogoo02aoo`03001oogoo00Aoo`8000=oo`D00003Ool007oo00<00003Ool007oo009oo`800003Ool0
07oo00@00006Ool00000001oo`000Woo1P0000Aoo`00Ool000=oo`03001oo`0000<00006Ool00000
001oo`000goo00<007ooOol0100000=oo`00Ool00`0000Eoo`00Ool007oo0080009oo`800003Ool0
07oo00800003Ool007oo00H00004Ool00000Ool20003Ool20003Ool30003Ool8000017oo00000000
0goo00<007oo00000goo0`000goo00D007oo000007oo00800003Ool00000009oo`@000Aoo`800003
Ool007oo00Yoo`03001oogoo02aoo`40000000<007ooOol0;7oo00<007ooOol017oo00<007ooOol0
27oo00<007ooOol00Woo00<007ooOol01goo0P0000Eoo`00Oomoo`0000Aoo`800004Ool00000Ool2
0004Ool00`00Oomoo`04Ool20006Ool400000goo00000006Ool00`00Oomoo`06Ool01000Ool00000
27oo00<007ooOol00Woo00<007oo00000P0000=oo`00Ool00Woo00<007oo00000goo00<007oo0000
0P0017oo00@007ooOol000Eoo`07001oogooOol007oo00001Woo0P0017oo00<007oo00001Goo00<0
07ooOol02Woo0P00=Woo0@0000000`00Oomoo`0YOol20006Ool200000goo001oo`03Ool01000Ool0
00000Woo1@0000=oo`0000002P0000Eoo`00000007oo00800003Ool007oo009oo`800007Ool007oo
001oo`00Ool010000Woo100000=oo`00Ool0100000=oo`00Ool00Woo0P0000=oo`0000001@0000=o
o`0000000Woo00<007oo0000200000Eoo`00Ool007oo0080009oo`80000;Ool007ooOol007oo001o
o`00Ool00003Ool00`00Ool0000600001goo001oo`00Ool007oo008000Aoo`D0009oo`03001oogoo
00@0009oo`03001oo`00009oo`03001oogoo00T000=oo`03001oogoo031oo`40000000<007ooOol0
:Goo0P0000=oo`00Ool00goo0P0000=oo`0000000Woo00<007ooOol00Woo0`0000=oo`0000000`00
0goo100027oo00<007oo00000`0000=oo`0000002@0000=oo`0000001@000Woo0P000Woo2@0000=o
o`0000000`001goo00D007ooOol007oo00P00003Ool007oo00@000=oo`<00006Ool00000Ool007oo
1P000Woo0P0000=oo`0000000P0000=oo`0000000Woo0P000Woo00H007oo001oo`00Ool500000goo
001oo`02Ool00`00Oomoo`030002Ool200000goo000000020003Ool01000Oomoogoo0P0000=oo`00
0000;Woo0@0000000`00Oomoo`0_Ool00`00Ool00006Ool01000Ool007oo0`000Woo0`000goo1000
17oo0P0017oo00@007oo0000009oo`03001oo`0000Eoo`03001oogoo009oo`04001oogooOol20006
Ool20002Ool20003Ool01P00Ool007oo001oo`D0009oo`8000Aoo`04001oogoo0003Ool01000Oomo
o`000goo10001goo0P000Woo00P007ooOol007oo001oo`000Woo00@007ooOol0009oo`03001oo`00
00800006Ool007ooOol007oo0P0000=oo`0000000Woo00@007ooOol0009oo`800004Ool007oo0003
Ool2000:Ool01000Ool0000017oo00<007ooOol09goo0@0000000`00Oomoo`0ZOol01000Ool007oo
0P0000Ioo`00000007oo0002Ool00`00Ool000050002Ool200000goo0000000200001Goo001oo`00
Ool01@000Woo0P0000Moo`00001oo`00Ool00002Ool3000017oo000000000goo100000=oo`00Ool0
0Woo100017oo0P0000=oo`00Ool00P0000Eoo`00000007oo00<00004Ool00000Ool50006Ool30002
Ool30002Ool00`00Ool000020003Ool00`00Ool0000300000goo001oo`02000017oo000007oo0P00
0Woo200017oo100000Ioo`00Ool007oo0002Ool01P00Oomoogoo001oo`H000=oo`<0009oo`04001o
o`000004Ool00`00Oomoo`0WOol100000003001oogoo025oo`03001oogoo00Yoo`80009oo`@00003
Ool00000009oo`800005Ool00000001oo`0200000goo000000050002Ool2000017oo000007oo0P00
00Aoo`00001oo`80009oo`04001oo`00Ool300000goo000000030002Ool2000017oo000007oo1`00
00=oo`00Ool00P0000=oo`00Ool01`000Woo00@007ooOomoo`T000Eoo`03001oogoo00l00003Ool0
000000800003Ool007oo00800004Ool000000002Ool500001Goo00000000Ool00P0000Aoo`00Oomo
o`D00003Ool007oo00800003Ool00000009oo`03001oogoo00@00003Ool00000009oo`04001oogoo
0003Ool200000goo0000000VOol100000003001oogoo025oo`03001oogoo00Qoo`04001oo`00Ool2
00000goo001oo`030003Ool00`00Oomoo`04Ool200000goo001oo`04Ool01000Oomoo`001Goo00<0
07oo00000P0000=oo`0000000P0000Eoo`00Oomoo`0000Qoo`03001oo`0000Eoo`03001oo`0000Ao
o`04001oogooOol20002Ool300000goo00000002Ool00`00Oomoo`0300001Goo001oo`00Ool00P00
00=oo`00Ool00P0000=oo`0000000Woo00<007oo000010000Woo00<007ooOol00Woo00@007ooOol0
009oo`H00003Ool007oo00=oo`05001oo`00Ool00003Ool200000goo0000000200001goo000007oo
001oo`0000=oo`D0009oo`03001oogoo009oo`06001oo`00Ool007oo0P000goo0P0000=oo`00Ool0
9Woo0@0000000`00Oomoo`0QOol200000goo001oo`03Ool01@00Ool00000Ool0100017oo0P000goo
00<007oo000010000Woo00<007oo00000Woo0`0000=oo`0000000`0000Aoo`000000009oo`H000=o
o`T0009oo`<00005Ool00000001oo`0300001Goo00000000Ool00P0000=oo`00Ool00`0000=oo`00
00000Woo1@0000Ioo`00000007oo0004Ool01@00Ool00000Ool01P0000=oo`00Ool00P0000=oo`00
00000goo2@0000Eoo`00001oo`00009ooa400003Ool0000000<0009oo`800005Ool007oo001oo`02
000017oo000007oo0P0000Aoo`00001oo`@000=oo`800003Ool0000002Ioo`40000000<007ooOol0
8Goo0P0000Eoo`00Oomoo`00009oo`06001oo`00Ool007oo1@0000Eoo`00000007oo00800005Ool0
0000001oo`0@00000goo0000000;00001Goo001oogoo00000Woo0P000Woo0`0000Aoo`00Ool0009o
o`08001oo`00Ool007oo001oo`800004Ool000000002Ool600000goo001oo`0900000goo001oo`03
00000goo001oo`0400000goo001oo`080004Ool20002Ool600000goo001oo`0;0003Ool00`00Ool0
000300000goo0000000600000goo0000000300000goo0000000300000goo000000050002Ool20000
0goo0000000VOol100000003001oogoo025oo`800004Ool007ooOol700000goo00000002Ool00`00
Ool00003000017oo000007oo0P0017oo0P0000Ioo`00000007oo0002Ool01`00Oomoogoo001oo`00
00Aoo`8000Ioo`<00003Ool0000000Aoo`03001oo`000080009oo`04001oo`00Ool60006Ool20009
Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool300000goo0000
0003Ool01P00Oomoo`00Ool000=oo`03001oogoo009oo`80009oo`05001oo`00Ool00003Ool00`00
Oomoo`02Ool01P00Oomoogoo001oo`L0009oo`06001oogoo001oo`001Goo0P0000=oo`00Ool01Goo
00@007oo000002Moo`40000000<007ooOol07Goo00@007ooOomoo`8000Eoo`03001oogoo00X0009o
o`800008Ool00000Ool007oo001oo`D00003Ool0000000H0009oo`<00004Ool00000Ool300000goo
001oo`0:00001goo00000000Ool007oo0080009oo`D0009oo`800005Ool007ooOol00002Ool20002
Ool00`00Ool000040003Ool00`00Ool00002000017oo001oo`000goo0P000Woo00<007ooOol00`00
00=oo`00Ool02P000goo00<007oo00000P0000=oo`00Ool00Woo00<007oo00002@0000=oo`000000
0P000Woo1@0000=oo`0000000P000Woo10000Woo0P0000Eoo`00000007oo00<00004Ool007ooOol2
0003Ool2000QOol100000003001oogoo01eoo`80009oo`800004Ool00000Ool30002Ool200001Woo
000007oo001oo`D00005Ool007oo001oo`0>00001Goo00000000Ool00`0000Aoo`000000009oo`80
009oo`05001oo`00001oo`060002Ool30002Ool:00000goo0000000;000017oo000007oo10000goo
1@0000=oo`0000000P000Woo00<007oo00001@000Woo1@000Woo1P000goo2`0000=oo`0000002000
0goo1`0000=oo`0000000P0000=oo`000000100000=oo`0000003P000goo0P0000=oo`00Ool07Woo
0@0000000`00Oomoo`0NOol01P00Ool007oo001oo`80009oo`03001oogoo00<0009oo`8000=oo`D0
0004Ool00000Ool400000goo000000020004Ool400000goo00000002Ool40002Ool00`00Ool00002
00001Goo00000000Ool00P0000=oo`0000000P000Woo00@007ooOol000Qoo`D0009oo`04001oo`00
Ool30004Ool01000Ool007oo0P0000=oo`00Ool00Woo00@007ooOol000Qoo`<000Eoo`07001oo`00
001oo`00Ool00`0000=oo`00Ool00Woo00<007ooOol01@000Woo0P001Goo0`0017oo00D007oo0000
07oo008000Aoo`04001oo`000002Ool01000Ool007oo0P0000=oo`0000000P0000=oo`0000000P00
1goo0P0000=oo`0000007Woo0@0000000`00Oomoo`0JOol00`00Oomoo`0600001Goo00000000Ool0
200000Eoo`00000007oo00<00004Ool00000Ool300001Goo00000000Ool03@0000Aoo`00001oo`80
0003Ool0000000800006Ool00000Ool007oo0`0017oo1P0000=oo`0000000`0000=oo`00Ool00goo
0`0000=oo`0000000P000Woo0P000Woo00@007oo001oo`<00003Ool0000000D0009oo`800003Ool0
000000T00003Ool0000000800004Ool00000Ool200000goo0000000500000goo0000000200000goo
0000000200000goo000000070002Ool700000goo000000050004Ool70005Ool300000goo00000005
00000goo00000003Ool00`00Oomoo`0HOol100000003001oogoo01Uoo`80009ooad000=oo`H00005
Ool007oo001oo`070002Ool00`00Ool0000300000goo000000050002Ool300000goo001oo`070002
Ool700000goo0000000700000goo001oo`03000017oo001oogoo1@0000=oo`00Ool01`0000=oo`00
Ool00goo00<007ooOol010000Woo0`0000Aoo`00001oo`800003Ool0000000<00003Ool0000000@0
0003Ool007oo00H0009oo`03001oo`0000D00003Ool0000000X00005Ool00000001oo`0=00000goo
0000000700000goo00000003Ool00`00Oomoo`0HOol100000003001oogoo01Uoo`800003Ool00000
00@00003Ool0000000800003Ool0000000800003Ool000000080009oo`<0009oo`04001oogoo0002
Ool300000goo00000004Ool400000goo0000000200000goo001oo`060002Ool30006Ool02000Oomo
ogoo001oo`00Ool200000goo001oo`020003Ool00`00Ool00004Ool20005Ool00`00Ool000020002
Ool01@00Oomoogoo00001Woo00H007ooOomoo`00Ool30002Ool3000027oo00000000Ool007oo0003
Ool01@00Oomoogoo000017oo10000goo0P000Woo00<007ooOol00Woo0P0000=oo`0000000P0000Mo
o`00Ool007oo001oo`0500000goo00000002000017oo000007oo0`0000=oo`000000100000Ioo`00
001oo`00Ool400000goo001oo`020002Ool2000JOol100000003001oogoo01Moo`@00004Ool00000
0002Ool300000goo0000000:00000goo0000000:0002Ool200000goo0000000300001Woo000007oo
001oo`800003Ool00000009oo`H00003Ool0000000<0009oo`@00004Ool00000Ool300000goo0000
000400000goo0000000200000goo0000000200000goo0000000300000goo000000020002Ool20000
0goo00000003000017oo001oogoo100000Aoo`00001oo`T00003Ool007oo00D00004Ool00000Ool:
00000goo001oo`0400000goo000000060003Ool30002Ool200000goo0000000200000goo001oo`0E
000017oo000000000Woo0P0000Aoo`00000001Yoo`40000000<007ooOol057oo0P0000=oo`000000
0P0000=oo`000000400000=oo`0000002`0000=oo`0000000P0000=oo`00000010000goo00D007oo
000007oo00T00003Ool0000000H0009oo`09001oogoo001oo`00Ool007oo00800006Ool00000Ool0
07oo0`000Woo100000Aoo`00Oomoo`<00005Ool00000001oo`020002Ool300001Goo001oo`00Ool0
0`0000Moo`00000007oo001oo`0300001goo001oo`00Ool007oo00X00003Ool0000000<00003Ool0
000000800003Ool0000000H000=oo`H00004Ool00000Ool<00000goo0000000500000goo00000005
00000goo00000004000017oo000007oo0P0000=oo`0000000P0000=oo`00Ool05Woo0@0000000`00
Oomoo`0DOol200000goo001oo`0300000goo00000002Ool200000goo0000000400000goo00000002
Ool200000goo001oo`0700000goo00000004Ool01000Oomoogoo100000Moo`00000007oo001oo`05
00000goo0000000200000goo00000004Ool2000017oo000000000Woo0P0000Aoo`00Ool000=oo`80
00Moo`800007Ool007ooOol007oo00000goo00<007oo00000goo00@007ooOol000Uoo`800003Ool0
07oo009oo`04001oogoo0003Ool30002Ool01000Ool000000goo0P0000=oo`00Ool00P000Woo00<0
07oo00000`0000=oo`00Ool00P000goo00D007oo001oo`0000=oo`<00006Ool00000Ool007oo0`00
00=oo`00Ool0100000=oo`00Ool00`0000=oo`0000001@000Woo00@007oo0000009oo`03001oo`00
00H001Ioo`40000000<007ooOol04Goo2@0000=oo`0000003P0000=oo`00000030000goo3P000Woo
0P0000=oo`0000000`0000Aoo`00001oo`@00003Ool007oo00H00005Ool00000001oo`0300001Woo
00000000Ool0009oo`06001oo`00001oo`000goo1@0000Eoo`00Ool007oo00<00003Ool007oo00D0
0003Ool0000000800005Ool007oo001oo`0200000goo0000000=000017oo001oo`000Woo1`0000=o
o`00Ool02P000Woo2P0000=oo`0000003`0000=oo`00Ool00P0000=oo`000000300000=oo`000000
2@000Woo00<007ooOol03goo0@0000000`00Oomoo`0>OolS00000goo0000000:000017oo000007oo
0`000Woo0P0000Aoo`00Oomoo`<00003Ool0000000@00003Ool007oo00=oo`03001oo`0000800004
Ool00000Ool300000goo0000000200000goo0000000500001Woo000007oo001oo`H00005Ool00000
001oo`05000017oo000007oo0P0000=oo`00Ool0100000Aoo`000000009oo`80009oo`<00003Ool0
000000H00003Ool00000009oo`80009oo`03001oo`0000=oo`D00003Ool0000000800003Ool00000
00@00003Ool007oo00`00003Ool0000000`00003Ool0000001/0015oo`40000000<007ooOol03Woo
1`0000=oo`000000100000=oo`0000002@0000Eoo`00000007oo00<00006Ool00000Ool007oo2000
0Woo00L007ooOomoo`00Ool00002Ool300000goo00000005Ool2000017oo001oogoo0P000goo0P00
0goo0P000Woo00D007ooOomoo`0000=oo`<0009oo`<0009oo`D00005Ool007ooOol00002Ool20003
Ool300000goo001oo`030002Ool00`00Oomoo`02000017oo000007oo0`0000=oo`00Ool017oo0`00
00=oo`0000000Woo0`0017oo0`000goo00<007oo00000Woo0P0000Aoo`00Ool000=oo`03001oo`00
00<0009oo`<00003Ool007oo00@00005Ool00000001oo`03000017oo001oo`000Woo00D007oo0000
07oo00H00003Ool000000140015oo`40000000<007ooOol03Goo7`0000Aoo`00001ooa`00003Ool0
000000800003Ool0000001000003Ool0000000D00003Ool0000000D00003Ool0000000@00003Ool0
000000<00003Ool0000000=oo`<00003Ool007oo00800004Ool000000003Ool00`00Ool000070002
Ool4000017oo0000000017oo1@000Woo1@0000=oo`0000001`0000=oo`0000000P0000=oo`000000
2P000Woo6@0000=oo`0000006@003goo0@0000000`00Oomoo`07OolZ00000goo0000000?00000goo
000000060004Ool3000017oo000007oo0`0000=oo`00Ool020000goo100000=oo`0000001P0000Ao
o`00001oo`80009oo`800004Ool007ooOol4000017oo000000000goo0P0000Aoo`00001oo`P00003
Ool0000000@00003Ool0000000L0009oo`D00004Ool007ooOol20006Ool7000017oo000007oo2`00
00Eoo`00000007oo00L00003Ool007oo02l000Qoo`40000000<007ooOol01Woo>P0000=oo`000000
2P000Woo0P0000=oo`0000000`0000=oo`000000100000Ioo`00001oo`00Ool300000goo00000002
0003Ool40003Ool300001Goo00000000Ool010000goo00<007ooOol00P0000Moo`00000007oo001o
o`0200000goo000000020002Ool01000Oomoogoo2`000Woo00<007ooOol0100000=oo`0000002000
00=oo`00Ool01@0000=oo`0000002@0000=oo`0000000`0000=oo`0000001@0000=oo`0000001@00
00=oo`0000001`0000=oo`000000800027oo0@0000000`00Ool0000P00001Goo00000000Ool00P00
00Aoo`00Oomoo`H00004Ool00000Ool2000017oo000000000Woo100000Aoo`00001oo`<00003Ool0
07oo00P00003Ool0000000=oo`03001oo`0000=oo`04001oogooOol30002Ool01`00Ool007oo001o
o`0000Aoo`05001oogooOol00002Ool00`00Oomoo`03Ool00`00Oomoo`020002Ool20003Ool01000
Ool007oo1@000goo0P0017oo00<007oo00000P0017oo00@007oo000000=oo`03001oogoo00D00007
Ool00000001oo`00Ool0100017oo00<007oo00000P0000Aoo`000000009oo`05001oogooOol00004
Ool900000goo001oo`03Ool200000goo001oo`0700000goo0000000500000goo0000000L0001Ool1
00000003001oogoo00Ioob/00003Ool0000000@00003Ool0000000@00003Ool0000000H00004Ool0
0000Ool900000goo0000000<000017oo000007oo2@0000=oo`0000000P0000=oo`00Ool00P0000Eo
o`00000007oo00D00003Ool0000000800003Ool00000009oo`05001oo`00Ool00002Ool4000017oo
000007oo0`000Woo0P0000=oo`00Ool01P0000=oo`0000000P0000=oo`0000002`0000Aoo`00001o
o`800005Ool00000001oo`0800000goo0000000300000goo0000000f0009Ool100000003001oogoo
00Qoob400003Ool0000000X00003Ool0000000@00004Ool00000Ool500000goo000000050002Ool;
0002Ool01@00Ool00000Ool00P0017oo0P0000=oo`00Ool0100000=oo`0000000P000Woo0P000Woo
00D007oo000007oo00H00003Ool0000000<00003Ool000000140009oo`P00003Ool0000000<0009o
o`<0009oo`D00003Ool0000000P00003Ool007oo00800003Ool007oo00H00003Ool0000001400003
Ool0000000@00003Ool0000001h000Yoo`40000000<007ooOol03Woo2@000goo400000Aoo`00Oomo
o`800004Ool007oo0002Ool<0003Ool2000017oo000000000goo00P007ooOomoo`00Ool007oo0P00
17oo00<007ooOol00goo00L007ooOol007oo001oo`020002Ool00`00Oomoo`02Ool200000goo0000
000200001Woo001oo`00Ool0009oo`03001oogoo00<0009oo`800003Ool007oo008000=oo`03001o
o`000080009oo`04001oo`00Ool20006Ool01000Ool007oo0P000Woo00<007oo00000Woo00@007oo
Oomoo`D00003Ool0000000800004Ool007oo0006Ool80002Ool2000017oo001oogoo0`0000=oo`00
Ool00`000Woo00@007oo001oo`800008Ool00000001oo`00Ool0009ooa<00003Ool00000011oo`40
000000<007ooOol03goo;`0000=oo`0000000`0000=oo`0000001`0000=oo`00000040000Woo0`00
00Eoo`00Ool007oo00D00003Ool0000000800003Ool007oo00800003Ool00000008000Aoo`<00004
Ool00000Ool20004Ool00`00Oomoo`0300000goo0000000300000goo0000000500000goo001oo`02
00000goo001oo`0>00000goo001oo`0200000goo0000000500001Woo000007oo001oo`X00005Ool0
0000Ool00002Ool200000goo0000000Y000@Ool100000003001oogoo00moob80009oo`/00003Ool0
000000<00003Ool007oo00@00003Ool0000000<0009oo`03001oogoo009oo`800003Ool0000000<0
0003Ool007oo00800004Ool007oo0002Ool300001Woo000007oo001oo`D00004Ool00000Ool80002
Ool300000goo00000005000017oo000000000Woo0P000goo1P0000Eoo`00000007oo00D00004Ool0
00000002Ool2000017oo000007oo0`0000=oo`0000001`0000Moo`00000007oo001oo`0e00000goo
00000007000@Ool100000003001oogoo011oo`03001oo`0000`00003Ool0000000d00006Ool00000
001oo`000goo00<007ooOol00`0000Moo`00000007oo001oo`0400000goo001oo`02Ool500001Goo
00000000Ool00`000Woo1P0000Eoo`00001oo`00009oo`<000Aoo`8000=oo`<00005Ool00000001o
o`030002Ool00`00Oomoo`030002Ool30002Ool01000Oomoo`000goo00@007ooOol0009oo`80009o
o`8000=oo`P0009oo`04001oogoo0002Ool20002Ool500000goo000000020004Ool01000Ool007oo
0`0000=oo`0000000`0000=oo`00Ool00P000goo00@007oo000000=oo`03001oogoo0080009oo`@0
009oo`04001oo`00Ool900001Goo00000000Ool01`004Woo0@0000000`00Oomoo`0BOol200000goo
0000000:00000goo00000006000017oo000007oo2@0000=oo`000000100000=oo`0000001@0000=o
o`00Ool01@0000Aoo`00Ool0009oo`03001oo`0000d00004Ool000000002Ool20002Ool300000goo
0000000200000goo0000000500000goo00000003000017oo000007oo0P001Goo00H007oo001oo`00
Ool200000goo000000030002Ool;00000goo0000000400000goo0000000200001Goo001oogoo0000
0Woo1`0017oo00<007oo00000P0000=oo`00Ool00`0000=oo`000000100000=oo`0000001@0000Eo
o`00000007oo01/00003Ool007oo008001Eoo`40000000<007ooOol05Woo00<007oo00000`0000Ao
o`00001oo`@000=oo`03001oo`0000L00003Ool0000001800003Ool0000000800003Ool0000000H0
0007Ool00000001oo`00Ool01`0000Moo`00Ool007oo001oo`020002Ool300000goo001oo`020000
17oo001oo`000Woo0P0000=oo`0000000P0000=oo`00Ool02@0000Aoo`00Oomoo`<0009oo`800003
Ool007oo00800003Ool007oo00800003Ool007oo00800003Ool00000009oo`03001oo`0000800006
Ool00000001oo`000goo10000Woo00D007oo001oo`0000=oo``00003Ool0000000H00003Ool00000
009oo`d00003Ool0000000<00003Ool0000000H00005Ool00000Ool0000HOol100000003001oogoo
01Yoo`800003Ool0000000800003Ool0000000P000=oo`03001oo`0000800003Ool007oo00H0009o
o`08001oo`00Ool007oo001oo`<000=oo`80009oo`03001oogoo00=oo`03001oo`00008000Aoo`03
001oogoo00800004Ool007ooOol400001goo001oo`00Ool007oo00@0009oo`04001oo`000002Ool0
0`00Ool00002Ool30003Ool00`00Oomoo`020003Ool00`00Ool000050004Ool20002Ool01000Ool0
07oo0`0000Aoo`00Oomoo`800005Ool00000Ool00002Ool01`00Oomoogoo001oo`0000Aoo`<0009o
o`P00004Ool000000003Ool200000goo001oo`0200000goo0000000200000goo001oo`0400000goo
0000000600000goo001oo`090002Ool2000JOol100000003001oogoo01Uoo`80009oo`H00004Ool0
0000Ool200000goo00000003000017oo000000000Woo100000=oo`000000200000Ioo`00001oo`00
Ool500000goo0000000700000goo001oo`02000017oo000007oo100000Aoo`00001oo`80009oo`80
0005Ool00000001oo`0300000goo000000050002Ool00`00Oomoo`03000017oo001oo`000Woo1P00
00=oo`0000000`0017oo0`0000=oo`0000000P0000=oo`0000000`0000Aoo`00Ool0009oo`800003
Ool00000009oo`<00003Ool0000000@00003Ool0000000`00003Ool0000000/00003Ool000000080
0003Ool0000000800003Ool000000140009oo`8001Yoo`40000000<007ooOol06Goo00@007ooOomo
oaH00004Ool000000002Ool>00000goo001oo`0200000goo001oo`05000017oo001oogoo0`0000Eo
o`00000007oo00800003Ool0000000@00003Ool0000000800003Ool0000000<00003Ool007oo0080
009oo`X00003Ool0000000T00007Ool00000001oo`00Ool00`0017oo0`0000=oo`00Ool00Woo1@00
00Aoo`00001oo`@0009oo`03001oogoo009oo`D00003Ool0000000@00003Ool0000000800006Ool0
0000Ool007oo0`0000=oo`0000000P0000Aoo`00001oo`H00003Ool007oo00L00003Ool0000000L0
0004Ool00000Ool2000NOol100000003001oogoo01Uoo`03001oogoo009oo`05001oo`00001oo`04
0003Ool20002Ool30002Ool00`00Ool00004Ool01000Oomoo`000Woo10001Goo00<007ooOol01@00
00Eoo`00000007oo00800003Ool0000000Ioo`03001oogoo009oo`03001oogoo00<000=oo`03001o
ogoo009oo`05001oogooOol00007Ool01@00Ool007oo00001Goo0`0017oo0P0000Aoo`00Oomoo`80
009oo`<00003Ool007oo00Moo`04001oo`00Ool40002Ool00`00Ool00002000017oo000000000Woo
00@007ooOomoo`8000=oo`<000Aoo`08001oogooOol007oo001oo`@0009oo`05001oo`00001oo`09
00000goo00000004Ool2000017oo000000002Woo00<007ooOol06Goo0@0000000`00Oomoo`0IOol0
1000Oomoogoo0P0000=oo`0000000`0000Aoo`00001oo`800004Ool000000002Ool:0002Ool50000
1Goo00000000Ool01`0000Aoo`00001oo`800004Ool007ooOol200000goo001oo`0300000goo0000
000500000goo00000004Ool400000goo00000002000027oo00000000Ool007oo0005Ool300001Goo
001oo`00Ool00P000Woo0P000Woo0`000Woo1@0000=oo`0000000P0000=oo`0000001@000Woo00@0
07oo000000=oo`P00004Ool000000003Ool50002Ool900000goo0000000300001Woo001oogoo001o
o`H00004Ool00000Ool400000goo0000000200000goo00000003Ool200000goo00000002Ool00`00
Oomoo`0IOol100000003001oogoo01eoo`04001oogooOol500001Woo001oogoo001oo`L00003Ool0
000000X00003Ool0000000@0009oo`800003Ool0000000H00003Ool0000000`00003Ool0000000D0
009oo`@00003Ool0000000D0009oo`@000Aoo`<00003Ool007oo00D0009oo`04001oogooOol20002
Ool00`00Ool000060003Ool300000goo000000020005Ool40003Ool200000goo001oo`0200000goo
001oo`0200000goo000000060003Ool800001Woo001oogoo001ooa000004Ool000000003Ool01@00
Oomoogoo00000Woo0P007Woo0@0000000`00Oomoo`0SOol30005Ool200001Woo000007oo001oo`D0
0006Ool007oo001oo`000Woo00@007oo0000009oo`@000=oo`D00004Ool000000003Ool200001Goo
000007oo00000goo100000Ioo`00Oomoo`00Ool50003Ool00`00Ool00006Ool00`00Oomoo`02Ool0
1000Ool0000017oo00@007ooOol0009oo`03001oo`0000=oo`800006Ool007ooOol007oo0P0000=o
o`00Ool01Goo00D007ooOomoo`00009oo`D00004Ool007oo0002Ool30004Ool20002Ool02000Ool0
07oo001oo`00Ool400000goo001oo`060002Ool600000goo001oo`020002Ool30003Ool30006Ool0
1000Oomoo`007goo0@0000000`00Oomoo`0QOol00`00Oomoo`020002Ool200000goo00000002Ool4
00000goo001oo`0D00000goo0000000200000goo0000000400000goo001oo`02Ool00`00Ool0000:
000017oo000007oo0P0000Eoo`00000007oo00800006Ool007oo001oo`001Woo0P0000=oo`00Ool0
200000=oo`0000000goo1@0000=oo`0000000`0000=oo`0000000P000Woo0`0000Moo`00Ool007oo
001oo`0;00000goo0000000900000goo001oo`0200001Goo00000000Ool01@0000=oo`0000000`00
0Woo0P0000Aoo`00Oomoo`X00003Ool007oo00800003Ool007oo00=oo`03001oogoo021oo`400000
00<007ooOol08Goo00<007ooOol01Goo0P000Woo00@007ooOomoo`<0009oo`04001oo`000002Ool8
00000goo001oo`02Ool60002Ool01@00Oomoo`00Ool02@000Woo0P0000Eoo`00000007oo00<00003
Ool007oo00<00003Ool0000000<00003Ool007oo00/00005Ool00000Ool00002Ool200000goo0000
00020002Ool500001Goo00000000Ool00`0000Eoo`00Oomoo`00009oo`05001oo`00001oo`020002
Ool70002Ool300000goo001oo`070006Ool800000goo000000030002Ool70002Ool2000017oo0000
00000Woo00<007ooOol00Woo0P009Woo0@0000000`00Oomoo`0ROol00`00Oomoo`07Ool20005Ool0
1000Oomoogoo1@000goo00X007ooOomoo`00Ool007oo001oo`@000=oo`03001oo`00008000Aoo`04
001oo`000003Ool00`00Oomoo`02Ool4000017oo001oogoo0P000Woo0`0000=oo`00Ool00`000goo
0P000goo1@0000Ioo`00001oo`00Ool500000goo00000003Ool01@00Ool007oo00000Woo10000Woo
0P000Woo10000goo00<007ooOol00Woo00H007ooOomoo`00Ool30002Ool3000017oo001oo`000goo
100000=oo`00Ool00Woo0`000goo0P0000Aoo`00001oo`L000Aoo`03001oogoo009oo`03001oogoo
02Yoo`40000000<007ooOol08Goo00<007ooOol017oo1@0017oo100000=oo`0000000P0000=oo`00
0000100000=oo`00Ool00`000Woo00<007oo00000P0000Moo`00000007oo001oo`03000017oo001o
o`000Woo1@000Woo00L007oo000007oo001oo`02000027oo000007oo001oo`00Ool200000goo001o
o`020003Ool200001Goo00000000Ool01@0000Aoo`00001oo`<0009oo`8000=oo`<0009oo`<00004
Ool007ooOol30002Ool40002Ool30002Ool20003Ool20003Ool20002Ool800000goo000000020002
Ool20002Ool40002Ool00`00Oomoo`03000017oo000007oo10000Woo00@007ooOomoo`800003Ool0
000002Ioo`40000000<007ooOol08Goo0P001Woo100017oo00H007oo001oo`00Ool2000017oo0000
00000Woo00@007ooOomoo`80009oo`80009oo`800003Ool0000000Aoo`T00004Ool00000Ool20000
0goo0000000400000goo0000000200000goo0000000400000goo000000030002Ool00`00Ool00003
00000goo0000000200001Goo001oo`00Ool00P000Woo00<007ooOol010001Goo00<007ooOol01000
00Aoo`00Oomoo`8000Aoo`04001oo`000002Ool;00000goo001oo`0:0004Ool01@00Ool00000Ool0
1P0000=oo`00000010000Woo00@007oo001oo`80009oo`04001oogooOol200000goo001oo`0VOol1
00000003001oogoo025oo`8000Eoo`03001oo`00009oo`03001oogoo0080009oo`<000Uoo`80009o
o`@000=oo`04001oogoo0003Ool=00000goo001oo`0500000goo001oo`0600000goo001oo`020000
1Woo001oogoo001oo`H0009oo`03001oo`00008000=oo`<00005Ool00000001oo`030003Ool20000
1Goo000007oo00000Woo00<007oo000017oo1`0017oo0P0000Eoo`00000007oo00L00003Ool007oo
00L00006Ool00000001oo`000Woo00<007ooOol00P0000Ioo`00000007oo0002Ool20002Ool30000
0goo001oo`02Ool00`00Oomoo`04Ool00`00Oomoo`0UOol100000003001oogoo02Qoo`8000Uoo`80
0003Ool007oo00800003Ool007oo00=oo`800003Ool007oo008000=oo`03001oogoo00<00004Ool0
07oo0006Ool01000Oomoo`001Goo00<007oo00001Goo0P0000=oo`00Ool00goo100017oo0`000goo
00@007ooOol000Eoo`03001oogoo00800003Ool007oo009oo`<0009oo`03001oogoo00=oo`03001o
ogoo00=oo`05001oogoo001oo`0200001Goo001oogoo00000Woo0P000goo00<007ooOol00P002Goo
10000goo00@007oo0000009oo`04001oogoo0004Ool00`00Oomoo`06Ool20003Ool01@00Oomoogoo
00000goo0P0000=oo`00Ool09Woo0@0000000`00Oomoo`0ZOol01000Ool000000goo00<007oo0000
100000=oo`0000000P000Woo0`000Woo0P0000Yoo`00001oo`00Ool007oo001oo`H00007Ool007oo
001oo`00Ool00`0000Aoo`00Oomoo`<0009oo`03001oo`0000H00006Ool00000001oo`000Woo0`00
00Eoo`00Ool007oo0080009oo`<00004Ool007ooOol30003Ool500000goo001oo`08000017oo0000
00001goo0P0000Ioo`00001oo`00Ool30004Ool20004Ool300000goo001oo`020002Ool30003Ool0
0`00Ool00005Ool00`00Ool00002Ool20002Ool20003Ool20002Ool01000Oomoogoo0P0000=oo`00
Ool09Woo0@0000000`00Oomoo`0YOol01000Oomoo`001Goo00<007ooOol01Woo0`000Woo00<007oo
Ool0100000=oo`00Ool00P0000=oo`0000000Woo00<007oo0000100000=oo`00Ool017oo100000Ao
o`00001oo`<00004Ool00000Ool40002Ool2000017oo000007oo0P0000=oo`00Ool00`0000=oo`00
00000P0000Aoo`00000000Aoo`05001oogoo001oo`050003Ool300001Goo00000000Ool0100000Ao
o`00Oomoo`D00003Ool007oo008000Eoo`06001oo`00Ool007oo0`0017oo00<007ooOol00`000Woo
0P0000=oo`00Ool0100000=oo`0000000P000goo0P000Woo0P000Woo0P00<Goo0@0000000`00Oomo
o`0/Ool01@00Oomoogoo00000Woo0P000goo0P000Woo00<007ooOol01Goo00<007ooOol00goo0P00
0goo00@007ooOomoo`H000Aoo`03001oogoo00Aoo`8000Aoo`06001oogoo001oo`000Woo00@007oo
001oo`8000=oo`800003Ool00000009oo`08001oogoo001oo`00Ool0009oo`07001oogooOol007oo
00000Woo00D007ooOomoo`0000Aoo`05001oo`00Ool00002Ool00`00Ool00002Ool200000goo001o
o`02Ool00`00Oomoo`040002Ool30007Ool01`00Ool007oo001oo`0000Aoo`800003Ool007oo00Io
o`03001oo`00008000=oo`03001oogoo00Aoo`05001oogooOol0000^Ool100000003001oogoo02Uo
o`04001oogoo0003Ool00`00Ool000030003Ool500001Goo001oogoo00000Woo0P0000=oo`00Ool0
0`000Woo00<007oo00000goo10000goo20000goo2P0000Ioo`00001oo`00Ool20002Ool01000Ool0
07oo0`000goo00<007ooOol00`000Woo0P000Woo0P0000=oo`0000000Woo0`000goo00H007ooOomo
o`00Ool300001Goo001oo`00Ool00P0000=oo`0000000`000goo0P0000Aoo`00000000Moo`800003
Ool007oo00<000=oo`04001oogooOol600000goo00000003Ool00`00Ool00008Ool01000Oomoo`00
;Woo0@0000000`00Oomoo`0YOol00`00Oomoo`04Ool20002Ool01000Oomoogoo0P001Woo00<007oo
000010000goo0`0000=oo`00Ool00Woo00<007ooOol00`000Woo0P0000Ioo`00Oomoo`00Ool30002
Ool800000goo001oo`060004Ool01@00Ool00000Ool01@0000Aoo`00001oo`8000Ioo`800003Ool0
000000<00003Ool007oo00Aoo`80009oo`03001oogoo00D0009oo`800003Ool0000000@0009oo`<0
00=oo`@00006Ool007ooOol007oo0P0000=oo`0000001@0000Eoo`00Ool007oo00800003Ool007oo
00<00003Ool007oo00Eoo`80035oo`40000000<007ooOol0<Goo00@007ooOol0009oo`8000Ioo`80
00Eoo`03001oo`00009oo`03001oogoo00Aoo`03001oogoo00=oo`04001oogoo0002Ool00`00Oomo
o`020003Ool00`00Oomoo`02Ool00`00Oomoo`030003Ool00`00Oomoo`03Ool00`00Ool00009Ool0
1@00Oomoo`00Ool00P0017oo0P000goo00@007ooOol000=oo`03001oogoo009oo`05001oogooOol0
0002Ool00`00Ool00002Ool30006Ool01000Oomoo`001Goo0P000goo00<007ooOol01Goo0P006Woo
0P00<Goo0@0000000`00Oomoo`0aOol01`00Oomoogoo001oo`00009oo`04001oo`00Ool40002Ool0
1000Ool0000017oo00<007ooOol01@0000=oo`00Ool01P0000=oo`00Ool017oo0P0000Aoo`00Ool0
009oo`03001oogoo00=oo`05001oo`00001oo`02000017oo000007oo100017oo0P0000=oo`000000
0Woo00<007oo000017oo00<007oo000017oo00@007oo001oo`800004Ool000000002Ool01@00Ool0
0000Ool01@000Woo0`000goo00<007oo00000goo00D007ooOomoo`0000Ioo`<000Qoo`8000Aoo`03
001oogoo00Aoo`8000Ioo`05001oogooOol0000^Ool100000003001oogoo039oo`04001oogoo0004
Ool01@00Ool00000Ool00P0000=oo`0000000`0017oo0P001Goo0P0000Eoo`00000007oo0080009o
o`03001oo`0000D00003Ool00000009oo`03001oogoo009oo`<0009oo`03001oogoo00800003Ool0
000000<0009oo`<00003Ool007oo00<0009oo`03001oo`0000Moo`@0009oo`04001oo`00Ool30000
0goo00000002000017oo000007oo0`0000=oo`00Ool00Woo100000Ioo`00001oo`00Ool400001Goo
001oogoo00000Woo00@007ooOomoo`800004Ool000000007Ool00`00Oomoo`06000:Ool00`00Oomo
o`0/Ool100000003001oogoo039oo`04001oogoo0004Ool00`00Oomoo`04Ool01@00Oomoogoo0000
0Woo00<007ooOol00P002Goo00<007ooOol00Woo0P000Woo00<007ooOol027oo00<007ooOol01Goo
00<007ooOol00Woo0P0000=oo`00Ool00Woo00<007oo00000goo00<007ooOol00Woo00<007ooOol0
0P000goo0P0000Aoo`00Ool000Aoo`04001oo`000005Ool00`00Oomoo`0200000goo00000002Ool0
0`00Oomoo`06Ool01000Oomoo`0017oo00<007ooOol00Woo0`001Goo00@007ooOomoo`8000Eoo`80
00Aoo`03001oogoo03aoo`40000000<007ooOol0<Woo00<007ooOol027oo0P0017oo00P007oo0000
07oo001oo`000goo0P000Woo00@007ooOomoo`@000=oo`@000=oo`05001oo`00Ool00002Ool00`00
Ool0000300000goo001oo`030002Ool01@00Oomoogoo00000Woo0`000goo00@007ooOomoo`800003
Ool0000000=oo`03001oo`0000=oo`03001oogoo0080009oo`05001oo`00Ool00004Ool00`00Ool0
00020002Ool03@00Oomoo`00Ool007oo001oo`00Ool007oo0080009oo`8000=oo`03001oogoo00Eo
o`<00003Ool0000000=oo`07001oogooOol007oo000017oo0P00>Goo0@0000000`00Oomoo`0gOol0
0`00Oomoo`02Ool01000Oomoogoo0P000Woo00H007ooOomoo`00Ool200001Goo001oo`00Ool00P00
00Ioo`00001oo`00Ool200001goo000007oo001oo`0000=oo`<00004Ool007ooOol20005Ool30003
Ool01000Ool007oo0P000Woo00<007oo00000goo00D007oo000007oo00@000Eoo`03001oo`0000@0
009oo`80009oo`06001oogoo001oo`000Woo00@007oo001oo`8000=oo`04001oogoo0002Ool01000
Oomoo`000goo00<007ooOol01P0000=oo`0000000goo00<007oo00000goo0P001Goo0`00?Goo0@00
00000`00Oomoo`17Ool20002Ool200000goo00000004Ool00`00Ool00007Ool00`00Oomoo`020004
Ool01000Ool000001Woo0P000goo00<007oo00000P0000=oo`00Ool00goo00@007oo000000=oo`03
001oogoo008000Eoo`<00003Ool0000000Aoo`03001oogoo00Ioo`03001oo`0000=oo`800004Ool0
0000000:Ool01@00Oomoogoo00000Woo00<007oo000017oo00L007ooOomoo`00Ool00006Ool00`00
Oomoo`05Ool00`00Oomoo`0kOol100000003001oogoo03aoo`8000=oo`08001oogoo001oo`00Ool0
00=oo`03001oogoo00=oo`04001oogoo0003Ool00`00Oomoo`0200001Woo001oo`00Ool0009oo`@0
00Ioo`8000Eoo`800003Ool00000009oo`05001oogoo001oo`0200000goo00000003000017oo0000
00000Woo00D007ooOol007oo00800004Ool007ooOol50003Ool00`00Ool00002Ool01000Oomoo`00
0Woo00@007ooOol000=oo`04001oogooOol30002Ool00`00Oomoo`02Ool00`00Ool00003Ool20003
Ool01000Oomoo`000Woo00@007oo001oo`8000Ioo`8003Uoo`40000000<007ooOol0?7oo00<007oo
Ool017oo0P002Goo0P001Woo00@007ooOomoo`8000Aoo`06001oogooOol007oo0`0000Yoo`00Ool0
07oo001oo`00Ool000=oo`03001oogoo008000=oo`04001oogooOol60003Ool20002Ool70002Ool0
1P00Oomoo`00Ool000Aoo`H000=oo`05001oo`00001oo`0200000goo0000000500001Goo001oogoo
000017oo0`0000=oo`00Ool0100000Moo`00Oomoo`00Ool00004Ool30011Ool100000003001oogoo
045oo`03001oogoo009oo`04001oogoo0006Ool00`00Oomoo`05Ool00`00Oomoo`03Ool01`00Oomo
ogoo001oo`0000Ioo`03001oogoo00=oo`04001oogoo0008Ool01000Oomoo`000Woo00<007oo0000
1Goo00@007ooOol000=oo`80009oo`04001oogoo0003Ool20002Ool00`00Oomoo`02Ool01000Oomo
o`000Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo01Ioo`03001oogoo00Uoo`03
001oogoo03]oo`40000000<007ooOol0Bgoo0P000Woo00H007ooOol007oo0002Ool01000Oomoo`00
1goo00P007oo001oo`00Ool007oo0P0000=oo`00Ool00Woo0`0000=oo`0000000P000Woo00<007oo
00000Woo00<007oo00000`001goo0`000Woo00<007ooOol00P0017oo0P000Woo00<007oo000017oo
100000=oo`00Ool00goo00<007ooOol00goo00L007ooOomoo`00Ool00002Ool20002Ool00`00Ool0
0002Ool01000Ool000000Woo0P000goo00D007ooOomoo`00009oo`03001oo`0003moo`40000000<0
07ooOol0BGoo00<007ooOol017oo00<007ooOol02Goo00@007ooOomoo`800003Ool0000000=oo`03
001oogoo00Eoo`800004Ool007oo0007Ool200000goo00000004000017oo001oogoo0`0000Ioo`00
Ool007oo0003Ool20003Ool20003Ool01P00Oomoogoo001oo`800003Ool00000009oo`03001oo`00
009oo`80009oo`07001oogooOol007oo00001Goo00<007ooOol00Woo00<007ooOol00Woo00@007oo
Ool000Ioo`04001oogoo0012Ool100000003001oogoo03ioo`04001oogoo000DOol00`00Ool00006
Ool01@00Oomoogoo00001Woo00@007ooOol000Uoo`05001oo`00Ool0000=Ool01@00Oomoogoo0000
1goo00@007ooOol000Aoo`8000aoo`8000=oo`03001oogoo00=oo`<000=oo`03001oogoo009oo`03
001oogoo00Ioo`03001oogoo04moo`40000000<007ooOol0?Woo00<007ooOol01Woo00<007ooOol0
0Woo00@007ooOomoo`8000Aoo`03001oo`00009oo`03001oogoo009oo`03001oo`0000Eoo`800003
Ool00000009oo`04001oogoo0002Ool200000goo001oo`050003Ool01000Oomoo`001Goo00D007oo
Ool007oo00<000=oo`<00003Ool007oo00Eoo`04001oogoo0007Ool01000Oomoo`0017oo00@007oo
001oo`<0009oo`05001oo`00Ool0000<Ool20002Ool00`00Oomoo`17Ool100000003001oogoo03ao
o`03001oogoo00Eoo`03001oogoo00Eoo`04001oogoo0003Ool2000:Ool00`00Oomoo`05Ool01P00
Ool00000Ool0009oo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`02Ool20002Ool00`00
Oomoo`05Ool00`00Oomoo`0300001Goo001oogoo00000goo00D007ooOomoo`00009oo`8000Eoo`03
001oo`0000800003Ool00000009oo`800004Ool007oo0007Ool20007Ool200000goo001oo`020002
Ool01@00Oomoogoo0000AGoo0@0000000`00Oomoo`1?Ool01@00Oomoogoo00000goo00<007ooOol0
2Goo00@007ooOomoo`8000aoo`05001oogooOol00002Ool02@00Oomoogoo001oo`00Ool00003Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool20008Ool200000goo001oo`05Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Ool00002000HOol20007Ool00`00Oomoo`0oOol100000003001oogoo03aoo`03
001oogoo009oo`04001oogoo0002Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`08Ool01@00Oomo
ogoo00000goo00<007oo00001goo00<007oo00001Woo00<007ooOol00goo0P002goo0`0000=oo`00
00000Woo00H007oo000007oo0002Ool01000Oomoogoo0`000goo00<007oo00002Woo00@007ooOol0
00Aoo`04001oogoo0005Ool00`00Oomoo`040002Ool20002Ool00`00Oomoo`05Ool00`00Oomoo`0o
Ool100000003001oogoo04=oo`03001oogoo00Moo`80009oo`03001oogoo00Eoo`03001oogoo00=o
o`03001oogoo00Uoo`8000Eoo`06001oogooOol007oo0P0000=oo`00Ool00P0000=oo`00Ool00P00
1goo00<007ooOol00goo00<007ooOol01Goo00<007ooOol00Woo0`000Woo00@007ooOol0009oo`04
001oo`000002Ool01@00Oomoo`00Ool00P0000=oo`00Ool00goo00<007ooOol017oo00L007ooOomo
o`00Ool00008Ool01@00Oomoogoo0000AGoo0@0000000`00Oomoo`0lOol00`00Oomoo`08Ool00`00
Oomoo`02Ool01@00Oomoogoo000027oo00<007ooOol01Woo00@007oo001oo`8000Aoo`04001oo`00
Ool20002Ool01000Ool000000goo0P0000=oo`0000000Woo00@007ooOol0009oo`06001oo`00001o
o`001Woo00<007oo000017oo0`001Goo0P0027oo0P0000=oo`00Ool01Woo00<007ooOol00`0000=o
o`00Ool00Woo00@007ooOol000Yoo`03001oogoo04Qoo`40000000<007ooOol0Cgoo00<007ooOol0
0Woo00<007ooOol027oo00<007ooOol047oo00H007ooOol007oo0002Ool00`00Oomoo`0<Ool00`00
Oomoo`04Ool300000goo001oo`0:Ool00`00Oomoo`0HOol00`00Oomoo`0=Ool00`00Oomoo`04Ool0
0`00Oomoo`05Ool00`00Oomoo`0oOol100000003001oogoo04Aoo`03001oogoo00Moo`03001oogoo
00eoo`8000Uoo`03001oogoo00=oo`05001oo`00Ool00002Ool01@00Oomoogoo00003Goo00H007oo
000007oo0005Ool00`00Oomoo`04Ool40005Ool20002Ool00`00Oomoo`04Ool00`00Ool00006Ool0
0`00Ool0000=Ool00`00Oomoo`1BOol100000003001oogoo04Aoo`03001oogoo00Eoo`03001oogoo
009oo`04001oogoo000>Ool200000goo001oo`02Ool00`00Oomoo`0:Ool30006Ool01@00Oomoogoo
00001goo0P000Woo00@007oo001oo`8000Ioo`<00003Ool00000008000Eoo`<000=oo`04001oogoo
Ool2000:Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`1:Ool100000003001oogoo05mo
o`03001oogoo015oo`8000Ioo`03001oogoo00ioo`05001oogooOol00002Ool30002Ool00`00Oomo
o`02Ool00`00Ool0000:Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`0=Ool2001BOol1
00000003001oogoo05Yoo`05001oogooOol00004Ool20002Ool01000Oomoo`0027oo00<007ooOol0
0goo00<007ooOol00goo0P0000=oo`0000000Woo0P0000=oo`0000000Woo0P0017oo00D007ooOomo
o`00009oo`05001oogooOol00002Ool01000Oomoo`004Goo00<007ooOol017oo0P0027oo0P00Dgoo
0@0000000`00Oomoo`19Ool01@00Oomoogoo00001Woo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo0P002Woo00@007ooOomoo`8000Qoo`05001oo`00Ool00005Ool00`00Oomoo`02Ool0
1@00Oomoogoo00001Woo0`0000=oo`00Ool07goo00<007oo000017oo00<007ooOol0Dgoo0@000000
0`00Oomoo`1HOol00`00Oomoo`020006Ool00`00Oomoo`020004Ool00`00Oomoo`03Ool01000Oomo
o`001goo00@007ooOol000Yoo`03001oogoo01=oo`04001oogoo000<Ool00`00Oomoo`04Ool00`00
Oomoo`1QOol100000003001oogoo04moo`03001oogoo00eoo`03001oogoo00Eoo`8000ioo`<000Ao
o`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00eo
o`04001oogoo0007Ool01000Ool00000FGoo0@0000000`00Oomoo`1HOol01@00Oomoogoo00000goo
00<007oo00002goo00D007ooOomoo`0000Ioo`8000Ioo`03001oogoo00Aoo`05001oogooOol00004
Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool2000IOol01@00Ool007oo0000FGoo0@0000000`00Oomo
o`1DOol00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomo
o`0@Ool00`00Oomoo`09Ool01000Oomoogoo0P000goo00<007ooOol0IGoo0@0000000`00Oomoo`1?
Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0FOol20009Ool00`00Oomoo`02Ool2000A
Ool00`00Oomoo`09Ool00`00Ool00002Ool02@00Oomoogoo001oo`00Ool00006Ool00`00Oomoo`1I
Ool100000003001oogoo05aoo`03001oo`0000Moo`03001oogoo00Uoo`03001oogoo009oo`03001o
o`0000Eoo`8000Ioo`8000Yoo`03001oogoo00Eoo`03001oo`0000Uoo`03001oogoo009oo`05001o
ogooOol00005Ool01@00Oomoogoo000017oo00<007ooOol0FWoo0@0000000`00Oomoo`1COol00`00
Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`0AOol00`00Oomoo`0<Ool00`00Oomoo`0YOol00`00
Oomoo`1POol100000003001oogoo05Moo`03001oogoo00Aoo`8000Aoo`03001oogoo00Moo`03001o
ogoo00ioo`03001oogoo00Aoo`03001oogoo00Moo`03001oogoo00Qoo`800003Ool007oo00=oo`03
001oo`0000Qoo`03001oogoo015oo`03001oogoo05Moo`40000000<007ooOol0Dgoo00<007ooOol0
3Goo00D007ooOol007oo0080011oo`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo00Aoo`<0
00Moo`03001oogoo00Ioo`03001oogoo00ioo`03001oogoo00Moo`03001oogoo05Yoo`40000000<0
07ooOol0NGoo00<007ooOol00Woo00<007ooOol00goo00<007ooOol05Goo00<007ooOol01Goo00<0
07ooOol02Woo00<007ooOol02Woo00<007ooOol0Fgoo0@0000000`00Oomoo`1GOol00`00Oomoo`04
Ool20006Ool01000Oomoo`001Woo00<007ooOol04Goo00<007oo00001goo00@007ooOol000Moo`03
001oogoo019oo`03001oogoo01Ioo`03001oogoo059oo`40000000<007ooOol0Igoo00@007ooOol0
00Ioo`03001oogoo01]oo`8000Uoo`03001oogoo00Ioo`03001oo`0001Uoo`03001oogoo05Yoo`40
000000<007ooOol0LWoo00<007ooOol04Goo00<007ooOol077oo00<007ooOol03goo00<007ooOol0
HWoo0@0000000`00Oomoo`1SOol00`00Oomoo`0;Ool00`00Oomoo`02Ool200000goo001oo`0?Ool0
0`00Oomoo`06Ool00`00Oomoo`07Ool01@00Oomoogoo00002Woo00@007ooOol000Moo`03001oogoo
069oo`40000000<007ooOol0G7oo00<007oo000027oo00<007ooOol05Goo00<007ooOol03Goo00<0
07ooOol00Woo00<007ooOol00goo00<007ooOol04Woo00<007ooOol0JWoo0@0000000`00Oomoo`1^
Ool20009Ool01@00Oomoogoo00002Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol037oo
00<007ooOol0KGoo0@0000000`00Oomoo`1eOol00`00Oomoo`0LOol00`00Oomoo`04Ool2000?Ool0
0`00Oomoo`1]Ool100000003001oogoo07eoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00
Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0[Ool00`00Oomoo`1BOol100000003001oogoo06Io
o`03001oogoo01Ioo`03001oo`0000Qoo`03001oogoo019oo`03001oogoo07Yoo`40000000<007oo
Ool0ogoo7Goo0@0000000`00Oomoo`1GOol00`00Oomoo`0DOol01@00Oomoogoo00001Woo00<007oo
Ool01Woo00<007ooOol037oo00<007ooOol0R7oo0@0000000`00Oomoo`1^Ool00`00Oomoo`0@Ool0
0`00Oomoo`0OOol00`00Oomoo`09Ool00`00Oomoo`1ZOol100000003001oogoo0?mooaeoo`400000
00<007ooOol0JWoo00<007ooOol07goo00<007ooOol05Goo0P00MWoo0@0000000`00Oomoo`1^Ool2
0005Ool20003Ool00`00Oomoo`04Ool20006Ool40002Ool20003Ool00`00Oomoo`02Ool00`00Oomo
o`0200000goo001oo`03Ool200000goo001oo`0NOol00`00Oomoo`1BOol100000003001oogoo0?mo
oaeoo`400000o`008@000000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250053, 
  0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["WindowsSound", "\<\
DTU6ATIF001G@EI5IVed8100000100404B/0014[000100P0I65dHB9F001mOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGeoOgmnOWimOGelO7akNg]k
NWYjNg]kNg]lO7emOGinOgmoOgmoOgmoOginOWemOGalNg]kNgYjNWYjNg]kO7al
OGenOWioOgmoOgmoOgmoOWinOGelO7akNg]jNWYjNWYkNg]lO7amOGinOgmoOh20
P7moOgmnOWimOGalNg]kNWYjNWYjNW]kNgalOGenOWioOgn0P820P7moOginOGel
O7]kNgYjNWYjNWYjNg]kO7amOGinOgmoP820P820OgmoOWimOGalNg]jNWYjNWYj
NWYkNg]lOGenOWmoOh20P820P81oOgmnOWelO7]kNgYjNWYjNWYjNW]kO7amOGin
Ogn0P820P820P7moOWimOGalNg]jNWYiNGUjNWYjNg]lO7emOWmoOh20P820P820
OgmnOWemO7]kNWYjNGUiNGUjNWYkNgamOGinOgn0P820P820P81oOginOGalNg]j
NWUiNGUiNGYjNW]lO7emOWmoP820P861P820P7moOWemO7]kNWYjNGUiNGUiNWYk
NgalOGinOgn0P821PH61P820OginOGalNg]jNWUiNGUiNGUjNW]kO7emOWmoP820
PH61PH60P7moOWimO7akNWYiNGUiNGUiNGYjNgalOGinOgn0P861PH61PH20Ogmn
OGelNg]jNWUiNGUiNGUiNWYkO7amOWmoP821PH61PH61P81oOWimO7akNWYiNGUh
N7QiNGUjNg]lOGenOgn0PH61PH61PH60P7mnOWelNg]jNGUiN7QhN7UiNWYkNgam
OWioP821PH61PH61PH1oOgimO7alNgUgMWEdM7AdMGMhNWanP862PhB4Q8>3PX1o
OWelNg]kNg]kNgalOGemOGalNg]jNGQhN7QhNGYkOGj0PX>4QHJ6QXF4PX1nO7Yh
MgEdM7AdMGIgNG]lOWn0PH:2PX61P7moOWemOGemOGinOgmoOgmoOWelNgUhMgIe
MGEeMWMiNgeoPH>4QXJ7QhJ5Q8:0OWajNGMfMWEeMWMhNGYkO7enOWmoOWinOGem
O7amOGioP861PX>3Ph:2P7mmNgYhMWEdLg=cM7EgN7]mOh63QHJ6QXJ5Q8>1P7il
NgYiN7QhN7UjNW]lO7amO7alNg]jNWUiNWYkO7eoPH:3QHF6QXJ5Ph:0OG]iMgEc
LW9bLW=eMgUkOGn1PX>4QHB4Ph:1P7mnOGalNg]lO7emOGinOWemO7]jN7MgMWIf
MWMhNWanP8:4QXN8R8R7QXB2P7ekNGMeM7=cLgAeMWQjNgenP861PH61P81oOWim
OGemOWmoP861PH61P7mnO7]iMgIdLg9bLgAeMgUlOX63QHN8RHV8QhJ4PWmmNgUh
MWEeMGIfMgQjNgamOGinOWemO7akNg]lO7enOh22PhB5QHF5Q8:1OgajN7EcLW5`
LG5cM7MiO7j1PhF6QhN7QhF4PX5oOGajNWUiNGUjNW]lO7amO7akNgYiN7MgMgQh
NG]mOh63QHJ8R8V8QhJ4PGmlNGMeLg5`L75bLgEgNGanP8:3Q8B4Q8>2PH1oOWem
O7amOGinOgmoOgmnOGajNGMfMGAcLgAeMWQjOGn2QHN8RXZ:RHR6Q85oO7UgMG=b
LW9cM7EgNGYlPh>2PGmnO7YiN7QhNGYlOh64QXR9RHV8QX>0OGUfLg1^KFe^Kg5d
MgYmP8>5QhR8R8N6Q8>1OgimO7]kNg]kO7alO7akNgYiN7MgMWIfMgQiNWanOh63
Q8F6QXJ5QHB3PH1oOGakNGQgMgIfMGEeMGEfMgQiNWanP863QHJ7QhN7QXF3PGmm
NgYhMgIfMWMgN7UjNgalO7alNg]jNGUiNGYkOGn1PhJ8RHZ:RXV7Q85mNWIbKfe/
Jf]]Kg9fNGf1Q8N9RXZ:R8J3PGikNGQgMgQiNgeoPH>4QHB3PGmkN7EaKfe[Jfe_
LWIkP8B9SI2BTi:ASXZ5P7]gLfm]K6a]Kg5eN7aoPXB5QHF3PGmlNGMfMGEfMgYm
P8B7RXb=SXf;QhAoNWIaKFYXJ6QYK71dN7f2QXV;SHf=RhV6Ph1mNgUgMgMgN7Yl
OGj0P81oOWekNGMeLg9bLW=dMgYmP8>6RH^<S8b;RHN4PGikN7IdLg9aLW9cM7Ig
NGYkO7enOgn0P821PH:3Ph>4Q8>3PX60OgilNgUhMgIfMGEfMWIgN7QiNW]kO7en
Oh21PXB5QXN7R8R7QXB2P7ejMgAbL6i^KFi`LWAgNgj1Q8J7R8R8QXF3PGmmNgYj
NW]lOGn0PH:3PX60OG]hM79_KFa/KFmaMGYoQ8R=T9:DTi:@S8N3OGQdL6e[JV]]
Kg=fNWj1PhF6QHB2P7ejMgEdM7AfN7b0Q8R;SY2@T8j;Qh9lMW5/J6ETHfEXK75f
O8:7RhnATY6?S8V5PGeiMWAcLgAfN7]mP8:3Q8B3PGikMgAaKVe/KFmaMGUnNh24
RHf@TY>CTXn;QX5kMW5]JFMVIfU[KgAhOH65QhV:RHR6Ph1nNgUhN7QjO7j1PhJ8
RHV8QXB0O7QdL6aZJFQYK6mcMgb1QHV<SXn?SXb9QX>0OG]iN7MgMgQiNGYjNgYj
NGQgMWEdM7EfN7YmP8:5QhV:RXZ9QhF3P7ilNWQgMgMgN7QiNGYiNGQgMWEdM7Ad
MWQkOh:6RXf@TI:AShb8PgihLfm[JFMXJFa`M7UnPXJ8RHV8QX9oNgMeLg9bM7Mk
P8F:Si:DUI>@RhEnMfmXHUiKFeeQIVefOXN>U9VLW9ZGTH^4OGI`K6UYJVeaMWb2
Qh^>Shj;Qh5kM6eXHf5PHVE[LWZ2Ri>IWZ2QWi^ESHElM6eVHV1OHFEYKgIlPXJ:
S8b;RHF1OGQeLW5aLWEiOH:7S8nBTi:@S8R2O7I`JfMTHfAVJFebMgf2QXV<SHf<
RXR5Ph1oOGalOGenOh20P81oOGYhMG=`Kfi^KW1cMWUmPHB7RH^;RhZ8QX>1Ogel
Ng]kO7enOWmoOWekNGIcL6i/Jfa]Kg=gO8:7S96DUYJEThn:QGmiM6m/JVUZK6mb
Mg]oPXB6QXF3P7aiMG=aL71bMWYoQ8V>TiJGUiFAS8IoN75ZIF5NGUmRIfacNX67
S92BTi>ASHV5P7ahMGAcM7EhNgj2QHN8R8N5PGeiM71/JFMVIfU]LGIlPXR=TIBF
UiJDT8b7PWehM71]Jf][K6i`LgIiNgioPH62PH60OgimOGamOGj0PH>4QXN8R8R7
QH>0OGYgLg1]JfYYJFY/Kg=gNh25RHb?TI:BTHn<RHF1OG5/JVY[KW9fNgj1PX:1
OWaiMWAbLW=eMgYmP8:4QXN7QhN8R8R9RHV8QhB0O7IaJfIRH61QIF]bNH68SY>E
UI>?RXEoNWMeMGIiO824QhR9QhB0O7MbKV]ZJV]^LGEiO7n1PX:2PX:2PX>5QhV;
S8f<RXN3OWUdL6e[JV]/Kg5dMgUkO7alO7alOWn2QHV<SY2@Shb8PgehLfm/K6e`
M7UnPhJ7QhF0NgE_JFETI6M]M7b6SiNMXJ:QWIN@QgmgL6YUHf9SI6M[KW=gNgn2
QHR:S8b;RXN3OgYfLVm^Kg5fO8>;TYRLWIbGT8IjKF9GCd]:CEANJWR6TijVZZ^X
XYZ@QWadKFQVIVQ/L7IkOh>5QhN6Q89oO7QeLVm]JfYZJfibMgj5S9BJWj>SXIbE
S85fJf5JEEAFFV9[MGj7SY:DTXn:PgafLVm^L7AiOhJ<TIBEU96=Qh1jM6m/JFUY
Jfe`LWAfN7UjO7enP8:4QhV:Rh^:R8J4PGmnOGamOWioOgimNWIaK6QTHV9TJ6if
OhRAV9fOWibFSXElM6eYIfQ[L7MnQH^?THn<QWmgKfQRGUeNHFM^MGj6SI>GVibL
ViRET8^6OgUcKFQSH5iNHFEZLGV1RHnDUYFBSHImMFeWHf9UJW9lQi:KXjNXYIjE
RGe`I5YCD4mBEemXLW^3RY2CUIFDTY2=RXN4PGmlNWQfM7=cM7EgNWf1PhF6QH=o
NWA^JFARHVAXKgR1RiBKXJ>SX9ZCRX5iLVaXIVMYJfmbMGMiNGQgMWIfMWQkOh>7
RXf>SXf:Qh=oO7UhN7UkOX63QHF3P7acJV=OGf=XKWAiO7ioP8:6RXnCUYJDShV3
OW]jO7n1PX1lM6aSGEYKHFYfPHZ@TY6=Qh5mNWUjO7enOWinOh66Ri6EUiF@QW]^
He]HFEiUKWIlOgmnNgUiNgn5S96EUYBAS8R4PX61P7ijMFmYI69TJG5jPhV<RXEn
MViZJFabNX>:Si6@SX^8QXJ7R8R7Q81jMG1^Kg5dMgUhM6iWHEeNHfaiQiFQZ:ZW
X9N=Q7ehMG=aKfi/Jf]^LgZ1R8f?SHMoMFaUHV=WKWElPHB4Ph61PhR?UYjSY:6J
Sh=fJV5JEeIFF5YMHFQ`NhREXJZ^[:BGQgMXGEQIGfYfPHbCUiRGUI:@S8R2Ng9W
GEA?CE1HHg1lQhjCU9BCTiBGVYbLVY>9OFmSFUEFFfA_NX>9S8f;R8B1OW]hLfiX
Hf1PI6ejRIRV[k>aZ9b=OW5XI6=UJ6]^Kfm_Kg1cMgb0PhB3Og]gMGIjP8N?UING
TXb4OGUgNGb0PhB2O7A[HeeKGF9[M7f4RH^<RhZ:RXZ:RHF1NWA_KFmeOXZFWjBT
WI61L61CBdU;DEUSK7AlQ8^CVj:WZJRRVHaoLfUSHVE[LWUnPH1nNgYiNgn4R8Z9
Q7]`IE]EE5MPJgV6TYbSZ:^/[:^WX9J8MfAB@cXg>dMGJgn@W:>TX9R@Qh1kN7Id
LFm]K6iaN86;UIfRXYjFS85hL6aZJVYYIf9MFEIGGFMeQIFS[K6`ZJ2ERX5iM75_
KF]YJFY]Lg^3S9:DTHYoLVEKEUIKIG5nRI2DU9:>RhV9RXb>SXb8PgegM79cMGIg
MW=]If5NGV9ZMX:;VZ:QV8YmM7=jQ8jDUI28PWimOGekMVmZJ6U]LWEeLVm^Lgb8
TYJBQWEVGEeWN8VHXJ>QWIVFU928OW5VGeaMH6=SHEmPIg>3TifOV8anM75fPHfF
V9B<PgahMgMgMWAcMW^3RXf;PWI[Hf9VKW=dL6QPGV=aQY^/]KF^XiR>QX1iLV]V
I6M^MW]kMViUHFA/NHB;RXAjLg9gPXjHViN=PWQbLGAgNWf0QHfEW9jIS7YWEe1A
F69ZK6YVHfI`P9:RZjbWWYF=RHN5PGagLg=eNG]hLFILEUUTMXVGWIZ@PWMaL7=f
MW=^JFM[MH:@Vj>WZJ^[ZJ>FPfYA?SDg@eEWM7YjN7QlQI2KXZ:LTXV1OWelNgQd
LW=hP8R<RXAjLg5fP8bDU8]iIE97ADaHIG5kPh^DWjV`/JfSUhb4OgafKV=HD51I
JGj@Vi^BPW5UH69YL7IhNGYmPXZ@U9>?RhR9SI:DTHQjKFASJGB0QXAkKF1HF61]
NXF:RXR6QHB4PWiiMGIlR9JRZ:JLSX5iMWMiMg1RDT@m@4iSNHfKXjFUXYnHSh9d
IeiMI71nR8f<Qh>4RYBOYJ:FPVaICTY>EE]PHV=VKGJ1S9BIW9nU[KFh]:N@ME]8
@4=>G6UaM7IiP8bIY:RUVXUgIeYBC4U9C5EUO9N``l_7^ZRGRhJ5Q7meIEA6?d1:
F6IaNGj2QhjDVIZFSXN2PXF9RXEjJeiGFVQmU:J`[jJHRWmgLF]RF4i7AdaGI75k
PhZBWJVc]k>VTGYXGV1ZNXN?ShQnMG1_LWAeLViZJ6]`MWYjMgAdN86=UibISh9_
Lgn?VIfJThZ2NW1VGUaPJG=jO7YhN7YnOGM/HUmWN8^GUhf1Nh:E[/32/iQkIEUG
F5MCD55JJgn>UI::PWelOWmoOWemO7YeKf]_O92S[jfORgUcN8><S89cIF1SJVaV
ETHmA5UhUJV`[:BMVibMViB;PGQ`IeiGEEaZOHjHVI><QhF3OFmLC4I>Hgb?ThUh
JfYgSJ:][:2CRhV=THn8OGA_KVm]IUaBC4eDGf]hQiNV[jnSSgUZJ7:2SXn6Mf][
MXNFW9J9OGUmQHV3Lei?BeEWNHB5OWA[IfM/Lgf:VZZe]k6TUhj:R8EjJUQ<BU9P
JVeYHfAbRZBe]::4IeIDGVijP7mnP8N@UiVESh^;SY:AS8AkLfeWGeMAD5QULg]h
KF5NJH:Q^lK0[YR9Ph:1NVaME5MVO8nHUHUmMGEkP85lLfUPFEEDEf1aQYb[[jRI
Rh>4RXn=QGYdN8>AUhmlHe5<F6anQWm`H5QLJW^9Si2>SHj?SHV3Oh26SiJIUi6;
QWmeIeI8A4mTOI2ES7a_K7N8UYR<N6=HFVEcOH63Qi>V^/S8^Z:6KUeCCTa=D5EL
HF=RHFIcR9j_/j^KRh>4RXj9O6aQHFenRX^0L6EXNYB^^[NTRg9ODTU2>cTlAeMZ
NhZGYKC3cLo7^:JER7][ESh[9S=@M9:QWXmoMg^8U9R?OVeSHVQ_L6]THFMfRin[
/:fWXIbHTXb6PGehKEY3;B8V?5]jT9ZKVYfV[k>ZU7YUGFAcPXN0LfUYMhfS/;6U
TWi]H5I?BdaDHFmjOgilO868SXn:QH>9UJ:XXHigIfEbQiRKTh9ZEDeEJGf7PgIZ
IF]fOGY]Ge]VOibb^kN/XYbFSGi^HEmWLgQaH51=GWjP/jnHO6UWL7QcGdDe?5Z4
ZK^gYIF@UjF]ZYf=PWijLV9>?Sa:H7=jLfQQJGbCXJ2CQH6<Wjj]UW=@?3mDL8RF
Vi^KWj>TX9J9OG5VFDa1>SY1C5QULX>H[/7:a[JNR7UdN868RhMmL6ALFf9]N7im
Mg9cNhJ?SX=aHf1ZO8^>PVaJEF1hTjVc][Fd/JRHP6UIE5YRHeaABe5SNHN7NVaY
N9>/]:F5IEQTPjBg/ij5MG=hO7MZG5QSN8bFTXEhLgIjN6aKDEATNXR6MVEPLYFk
e=BnWH9fN823Nf]LF5m^NgigJ5]DEf1/Mh2:TYRIThQnNX2<Ui^DQ75SHFUhQY6F
UYFEU96:OF]GACTh@UI^Phj=PgUgPIBY]K>TT7miNh65PWagN828RhEfIEUEF5aP
HVQeQiZRVhAZFUidTZJVTgUYK86KZZNDOW=hR9FCP6=:@TeSN8:2O7QiNgQ/FdmB
IhRW][6OShfK/;bfVgUNE5aZKfI@>cI6J8jZ]:bJRGefLFaVHfI_NX20NgIhPi:Q
Z:JOVIRLX9b=MUa:A4YFHF=MDDI2BUikVkO:d<^m[InCRG]ZETHoAeYaQ8j>RXZA
WJZ_Z9N0JEA2=2/Z=Da[R9^OVI:EXkK4`[6HQH6:UiR5HC/T9d5TOXImKVM^PIBO
WIB=Rhj>PfaB@D9ELHZGVIZR]<WDb:EhDdA=I7EcGT0/;DIZRYbMUHn@UYZFR7M[
JgF4TINFU9>DThamK65RKh>AT81WD4I=GWf6Og1VJ7J8U9JAS8fEWjBRVXj2MfaO
EE9MMYB[/ZJ>MFITJVeWFDU1AE=SL7QoRinfb<k7^J^QVHYbDSL^?V25V95fFDeL
OIj[X8E]IW>7THI[CT9=JHJETXIoR9fc_;:OTYJX^[JBF1d0021;IVQJDEj3]=OM
aIn3OH^MXY1^CCe4FW5nPhNBYkc3]95/E5AVO8AgG4<kB61dN6eNFFV9[/O<`JfM
UYFFU8f4Ng=XF4Hh=TAPOYBKUXf:SY>BQFaDAdaPNH^ASHN7SYJLViRHWJ>SU7QI
ADMNOI6@NUi>DfQmPFmB?dEWUkk;^if5Oh^LXiV4M75mRX]jGd]=IXZTXXMRBTeU
PHamGdM:Jic2bJf0FDeOP9ZRUhN1RYbYYYAmL79nQh1WB34_@5UZKFISL8ned=2e
SFYLIgnEWIJ8O7QlPH9nNGMiOGiiLFUXK7=dKfIQIWN;Ui=oI59AHgnK[;:b/;2]
Y9B0L6U/LG1UE4Q:FW1oOFeLFVb>[;BPNEE9G8>Z_KNPRX:7TI20IU9@HgnEV8Yh
KgR:UXmeED56H7b6ME8d<E>=aNCP`j:AUJF]XHARCe5TN7mdGT]7DVEbMG5aO9:W
[j:6JemZQIfTU7AEAe1YQ9JLVifW]/?4]9MeECh_:2P^>deOK75cN8NP_MCKckJI
PgMcL6YQFeeWMX>7Q7ijNWenO7MgOhfHUX5N>bXcDWJ>TH9aKh>Va]G<]IjFVjBQ
RF4i81h_B5]UJgN=YKB^U75JFW6>WiIiF4QFNZ6h]9j7PHnX]jn?I4<iB6=jPga`
J6M/KVQNFF5gTjNZW7a]MHfSYiImK6j1UjBNRgIZK7N3RXV1Lf1:=2LY?5eoVJFW
YjZb^[V[UGi^IfQ[JVMTIVaeOXNAWJZc/In1GD0a<T1BHFU[JFY_NhfQ/;JbZZFY
]/;0ZX9E=Rm0FFQUE4A2E76:UiNGX;C5aJUiBBlbBF1WFdiDMjkQmnNmU8:<Y;:V
OddU51TZ>TA;F6j8WjVWWYNGW:2PVY6:RHZ9PgIUETi@GG>=Y:n[VH5_K7N6SH=Y
BS@a?e=TJVY`PIo0fN3F`JVDPG1RF5USLG]jKf1GFVUkQhV3NG1/JVUYK7AoRHj>
SiFQ[JbJNea?GH6W^k:CL5aNKG]iJEI>EVYjOG5RGVZ1UI^BQ7j5UZ>PS79TK8V_
bL^eTFeDBT]@De=@Ce5JJWj@W9fERXF9U9jNSgQQEUYXNHN@VZJc^:jCLEUDI7^9
Pf]@@TYQMW]]ETM?Ji6^^K2OTHnFXJZ]ZZ:EPFUA?cY1DF=aO8B<U9VFS7ibJVMT
H5eQKGj=THMfKGRF_=GB]8UWG6UoSHUhIUmVLWQ`FdHk?TeOKgb:Vjjj^ZfIRHF<
V9jGQFmLDU9JJGZ;V9fHS7mhN7]iJU<o?4mbTj6EN5]BH7nM[JbTWj>//JZHQW]m
PhAfFch[:cU<F5aMIGbN`MKF_i]gGUIMKGb2OW=WI6n6X;6dZIV?SiBER6a<=S8o
Df5TH61ZNhR9Nfa[PjkIk]ngRVm^Ohj9Kddh>U9aQ8IkKfmkSI^NUXYnL61<>S8l
FGjP];RbZZRYZJ>HRh5kMg5XHEiQJ6aXGeUNL8RIUWmNAD=JOZ2b/::BRXZ>T8f7
PGn5PHF@V9B0IeEAEUYJF5eZN7ijLFedQ9NW/[J/TVY6>TmhVZ29L7:Hc^kR[Fi7
@eMYJ5<j:R/jCV1^Mh>E/];Vgk^:IfEoWZ>7Fd18K92IQF=>DVZ6W:V^[J68JU58
CEEFD4Y<EVA`NXZT`mcVhMO=a;>FKTHZ6aDC6S1GP9bMRgYmUK;0]in7N6mSDdM9
GGF4QGn3UkC8ak2BNgAkRIJHRVi9:AdU>4M9Ae=fY/W</I:=ZM7RaheF@59fRh1L
>2e6NK3Ef[n@IE1DIVmTBC@iFX6ESGEWMIRi`[:HR8ZHX9b;MfQPHVj4VjJGKd0U
;4mgS8MeJFioSI28O7AcMh2=W:RZXiRCUIRAOf]WMHV;L40K6CecVZ>GRX^GWiMo
IEIFGVAWJWF7WJnh]jbLShnO]KjXLc@<3cIRMFI;@UZ5YZJ:JfAiW;FfYI>;TIZM
TGQI@3]AO:RkZWmIDW6Q`[fGJDa8DUM>?S4a?UMhW/;Ifl^fZZb`YXUWEf>0U8MM
;Q/aI9FYW7]NEF9lTiZ=LU]ILibl_9QXBTi[R8j2NHN/d=JgQF1LLXZ=M4lb:SE7
Ef1SIFYhSj[0a[RPS8B6QWebLhZ[_Zn1CCE3JHV<M5Q=G7V?UXeoLfi^M7j8R7YS
D4iOMhZBUjS5hncCXW5EEVIdLf9;>34iD6n7S7ULCV>FbmfoQ5=;KYji[hidLhNJ
Ug]G@4IWT[>kYh=UGW:?V7e440@[KZ>ZQEU:J:3@hM>l[JZVUGUKBT]IJGInOgaf
LG9hO7IRCDEFMiJOSgIWK7j?UYRMYjfURfiNIWfCVYB9Ph9oMf]IFF9OBCI3LJ>d
X7aSGVEbPiFMUHN2SIjTWIBDWJBUXY^3ERHD;E]^DR@HBJ3VmM2FIUEVS;2eTehk
@6B6THUnO8FJ^=CF/gQ?E7^EOdDF64AdQWMG>RdhGiS;hmk;_KVd[:BNT759;SA?
HEU6A625VifO[lG;]i=aEC/O3aLfFgR8T9:BV:kBk^W4VhnMZ9AV?cDoA3T]=51_
PhV9PWAWJhVfe]BeSW1QGfMbLem3?FBVf=FZQ8N[a[V;Fd93D5]KB2D40c1naNCH
^9^=T9nb]iaZ@DEfZkVIKUaZP8ImMGIkNG9]JfEDA49FMI2QYY^0Ge5ZW<:oVGQk
V[RlZ8edF3hdBG>DUWiWIGB1PWY_JFUbOh=^ABPeK:S2]9jSa>CWcZ^<KTlf<D5E
G5MFGf]^J6MgTZ^h]JB2FdEBNiZAI41:P;K6[H]kOhZDWZV^YYN:Q7UL<a8:6cE@
IgMhJfAj/>Wlh;2DVJZXT75IABlN9e6;]/2aVhb7RHj=OV58B69kM4hZ:U:2W9^B
TINMYk[@dk5kEf6?_<BQJ3@G5bm?H5]>EWfZ_JZ9OXjQWX=[IW1gMGEnR8IhLH6S
`LVkYHabFDU8D5MMJ7^7NeY2CGFFSfU;DgjY_K^bZYnARI6R[:F@NVIB?cHoDf=Y
LXJNYHm_H6f0P6aJH7J6QhB?Y:^HM5mYS;C:a:=bBTEXUjfGJe1FJg9RBC`j>d5F
OjRj[YnU`MK8VVUCGgjLZ9M^@S9;OJ>VT7enQWmXEEQVJ5M4BV^?XZ6KUXmoKVYi
T:6WZJVTUXJ0PX9gK6inPFHh6baLPH1TDEn4Wkc0ZX]dIf9YPZ>e/ZNOUGm[KH25
KeEILgYRC5f5UWmRIhJLUh9aIUaFF5YDDFVOf_W_bYj1P9ZcZWi@?d=4>d5KK5Lb
;f:Q^ZZFUIZERXV<Q7QoVk:UNE13CV1`OHVFZ;ViY8f>XZ=i?1TM;cDhBf1NAT1X
[>7hooo_`I>4SX]T<QdbFWEeHe9ELiVYUgYbPI6DTY>9I3LU?F=hPI2QVGQSNjo=
a;2ba<>UPgAaI4HQ1P0D@6j5Pgj;Xk2/XifFTIJWZ8107cU_T9>EZ[Z/T8bV]iiV
>2`hC65dNViNFfAZIfUlUjbc[9IjK7nT/YQeMIR_W7EUL7QZG6=fNF]YP9ZGMTld
92<mLjVnZ8EfRK?Kil^GM7ZBTVm;@Ta;?T9USj6OY;NkX7MOETL^:TakRg=EDFV:
Y[c:c/Nl[j6KY;2QJ2H<:UaeL5m>>bhnKIJHPhNfj>^nSGI]Ge1BHVYLBdi]V/;F
c:fBUK;8_9AYA28600XJ93U]Z/>WPXVig]BaWInLSH67T8EVC4E<EVEhQXF0Phb=
OVaUJg^DZjQi=Q@]GgIYGgJKZjZff_OZ_8meIUaPMH5/?QhS@5aZLGR2T:6XVgmZ
IFERJH^e_9EXKJCCcIYT@c]>P[gAXUD[@76=RGU`JV=PIVaYGE=DHh:[a[jJQ9Nm
ajAcFE]XOIjk]HECB5iYED1>LGmXB4ALNHVBVZ2SYJZZXYVDRVi;>da^RIb^^k2A
NWj8NEU@JhAdA2XoHfeNF6f<WIjLVYRJYkB/S6]UPJ_;dK=e=QX^DfISGfAREUZ5
_<F@DDQgZ[:DKeM?G86VWh5PGHgFoo2^JdHoBfJ2SWmOAd9DMY><FbX/H8nCPXFK
XYJI]<:XRIBoc:=_FeQ281a3M92IUhM]JHbbYg9=DfIRFVnBU6mCHh>:PY>meL:R
V:2INfA]Rj:LNDLT9TAKCR`L<Ej=//W>`kJf_KZPN5UGKHJ7JTHg?U1`Z^cobWID
NZjaOd8G00LfMYInETm]S9bV[jZNZ<o[f:N6NF91@g^]TS`35e1`MWj7OFI/VlcE
^9EeCb`V@VIjPXV>Sig0g/nKN8blbj=S=RP[>4]LH5=4C7:VbL6IKUMCFg>K_;J@
MHBX/95]IG^I[JR6F4IRRi5bDTY;BER2YI5E=DmgPGbD`/naV:S1Z6Dc>5n4Vin7
Ge9l_MNhR6]KBdUVPg<g2@/Z@EN8bN_H][GCiLnKKE]UNHAhGdY1AE=ZQ8enIf9h
W;[5]8A67RIHTk:OHB<HDIfiWH6B`=kUkoOJTe97G5L[0@0553=/Wj1gGGJ_i?oo
fXa=CWAjBb8eJXEmOijg[IZS^K66I6Z2RGa`IdlX310^Eg^>RGMgV<7<]Z>`c]W6
Y8QdHU13?Sdl>d=NQjbj][6UOdP^DI>]QDL[>E9ZRJN_Wi>R_<[8`:QfA3mYSXES
Ef=]LhVQQbl00Fo9biAXFeYVS/;A[Ga[Ni:V]kF?FTEQRibCRX=cHfMkLcd62e2J
]J>;QX^;QhN>U8mkIV1_PhnDVYb@PXRWaL>WRWIN>QT=5c9FMWi`JH2QY8V1XL:f
S7bDZj2;RheaAdIhXYE]H7R:OVMJEEYh[<Z`MDe7A3U1JX]e@cYhbO;_g<6IMWnb
e[]`:baAHeHm:28lN;;1YX=^GeEUT;BXNEQUS:jo_J9aACiOSjj]UGUdQI>3JF^=
XHIKD6=S?ahT@5EWRJf`Vi_2iMfgUWmUFGR]^8]MFfE;:3f5Zh=9BgZ@MV1^PGil
UJfNMFZ7WheVC492G9_Hh;VQ]<VaPF]gN5e2@Ta39A4I>fbJ/:>;RZO:gM^oPSdX
GZg:YgQ[L6]QIW=bJG67T8R:VI9U@UJ5Rf53D61ABG>[YVU?QM?]gn;dgY=<>4A=
EFQ[AQ//MJRJLValNfn0YZQdB5R7TW9MKhfIXK_Fe:ehCd1EQjjSLU1JMWebJfMG
A4]XNFiVO9bTTGY^JWVQbLFJNhF?M5=WXkfIMX^bYVi8BDDY7SiPDS51R<K@_k6N
OWRYgm:<G6AZ@APdPJ^HPYNh]YnMZ9MU@DADDTM:EUMAEEmNFFfH][FgfOob/WEY
QJFbXW<e3A<dCEEHEDU<NlOdi;nc[hI7;T]RAA`ZIHn;OhRIYL?iooNcTIR?GcDf
?R803DANC4n=aJmUB7NcaL7:e;V6IfY^IVEaKeI9J9RWT82<Vi^JYj^9EdQRLe@G
000SGI6`_LSEdkVNXkk4XgibKe]6DGB1ITiJMWehQjBVPEQ5?CU>Oin:IGJfdZ1L
EX6LUYfj_8YKKZJgT6EMGTe1FXB@NF1DAC]DT;^[PgjIVfm4Bg:8QHRM/;Bhb=:n
U71TIVMH>b8UBW1^BS97MIfhe>G@VFA@FVn4Sh5MB6>J_;JRU89ZJiNnZg5LPjJ5
?QhbAShkFGenIf1`NWnKd??VaKZo/I60PFdf2Q@nEEQbZ/ZWIe9iZJnPPVEIGV1B
?c]9GgZL^K^XWZk3`JZBQ7]eNH>;S8YjD1/89eAPDUR0X9AbK8^__knl[HYYJXjX
U5/^<5Z8YJn]YIjKUX=UCDQ=C51]Ti9K92YWVj>JVHm_H8_Cj[MfJHNNXJJb[Y1[
CC4F5c]MGDmNS:bTSh^?RH28Vi]oH5QYOhf=PWYoRHfF^^KRV3`K?g22OgU/DTMM
N6i9>4]UL7jJZYnH]moHYhNCWhEUMIjMGA`E?F=dOhnIW:6STVa:@E1VLfiJBEB3
^]:nUGEcRZNg]JnWSEdkBgjHOEQLOhafH5]?<RQ?R9^3KWfM/;JfZH]aKWUnQZK>
bX]3<EV:WiR6K4lnAf5eLEU5CWNU]jjSWhm^FFZ7Odl`DI_JkmbZL5V1aMjhO5@k
8ATdEDXP5DJ2Ui>Vc=>^RY2YYhI/MiN_[8eN=bm<LhV8PH:=UibKU8QlMgQgHclW
<e=OARdnKI2K]O;oooo0VXIdJ6IO@R0B7cA6FFejOhZM[;2a^;FDH3m8I71M@TEb
/]:hPV1VP9o:m?BcHd]`TH9M@bP000UQW9A`GVEjZ^coeH^3_n>eICT_7aU<Y<jX
LG2GZjBRYXmH:bY7HgEiHcTWBXFPUYFbc/RZTXEhLgnBUi6@ThYeJfmYEE9YMUPi
Di^nUe]=HfQGFWjKUhfEWHikQjbo^KK2^heGAeEF@c]8BS8[Il[oeX5AGh2<PgQX
DD9AMX]mI69o[=[mom^JK6b5THM]@`d03fjj[EXE4T5fWkRo]:NW/;JaX89QDfEm
OFYOHf1BGiSAd:21Sjfh/9US50004bLbGij/O6:Eh>o>amg@U7BK`90c4CiYHDeE
IF5WU;bSGd9MMVidZM>bITEOMfQEHgQcJhNhbk:GV[75bkAk?cQ]W8Hm1P0564VC
`kN@QINSX:6RRf=IP:fbVhf5Kf21^l5e9Raj/:9iIETj9DJ>_kNFOFQ;>U1mT7YP
IH:O_=cV_h1YSKBTL5M[OFUAGGM[>1PcKif^ZHaE:35a//NdTgYhVm;Y_6i3CfMW
HFn5RH:6Ui^:MVQMGW^PVE/N63I:EGZVXgIb^Oo^X7V@Y8a`MX5`IhfiY5dfB5@l
>WVdVDT]FGibKio7XemOY]FeNfE[IV1bSI27VKk4X865QEl`<Ej0PGM_EblTDYNi
YgeLDVbRc<6@KgB3QISAo^:=DEQeKTX_9AhUF:6oUEA2Ii^ockj6Ac]]XIe`EUiQ
DEZLjOS4SXVKUWY^N7]ZHgN5J30D9dMEEUYNHGJXemRg[<SI]hEnWJR6FTQ0:ADS
DGfI/LO<^J2>PGIdLeTV2B9EJEaMP9^AP9?1i?;gik5aGgb;JD12FEM8FgYQ5`16
YkZ>OIjaVI2lhkaQ928gEH_2^flbCIk?c<?5/hYlW:ac5004<T91CVMgP96[_lJl
W6iGLZW7]Y=jIeEFMYbVUX^>RW=NGFAUHV1HB4]dY:AbCEj4QfUOP:Zj^lG=]X9M
I7n9OG9dLV1?E6f4SHb6OGImShi[?cM@Ec@D=8_Ejn?NdJj@X<gCVeM1DUa?@3dj
=T9TQIBKY:6;OI6aZ6T[9UN@/K>GICXeG96ha;VUX;KAbZ:4Q7a<4PTaBcDI8TAG
HGbT]k[@o_o^^9R0D24UE71SG6]jL6>5c?34M55^VZ>>LU@a5QTeD5eXO9>NX::S
WINP^/oAa[VWQEa9EVA@80<JEH25NX:LZif5NX6<U9fPR5<Q6dN0XJRVZ:je_L2e
WXA[DCe3IXAkDSeGOX1L@D]XOhnU/IQUBVJM^kJZ/;R/SWMfOh9gHDLjCG^RYXac
J5a6>e5jSX1_MHV=PH2BW8inT[k;WU]0GHfSVH1[IgbS`KbGJ40Q41TmI79ZIW:1
Q8^T`/J_WZ^o]8MSIX24J4Y<K8bFSXAlM6aSFe19EWZU^:IlE49>L96IPVUYOi:H
Y<;C]WmZTLC7V6UHCcPQ8c8f=E6<^KB?MgZ6S96FTHB4UYj8L7fU/XeQGWf=Q7n@
V7U7<DIZQIVZZXaM@4INJem6>Dj0/<2_WjS2dLJ[U8Z8QX5hKEi6:AX[DWB4Si^F
LT]?OjBJOhBRZXefRJZYPEM2?e1m]<RWP86Q/:2@S7mPE6j3F@D003QGHXFgb:bJ
^o?oiZagDTUUT:23FDI9CeASN85oRJ:[T6MIJgmiI5eYO85cGeY]QhYgKhR^`/OG
k^ReMeUBAC@oH6U45aDnJHBFX9R;Vl;=XFi]S8MC<Df1Ti2XdmBMKWJCRVIMNH]f
F5=JDTE=IG=ePYB8Ge20`lfDFE1`V;kOhkAZ?DQ_RHUjKW20TiF3KfEG?Bi7MH=M
=3aaXkZl/ib9VL_`h[63GC<D8E1_KG2AZY9/O[kEVDe2JGMJAeAMAcA<MX1dPJk?
clkQiKMhIGjARXZHR3l004A_EBPZEh:K/<G;_kJcY89PDUAGH6maEcU0Kj2le?7o
h[:GVIEbAA4002ICDc4WEINg[j>SWI>Vgoo_V556EeeOMY6:Gcm:K8NBUHMYGH6j
bj5^HfaL=BDgAS/jJ:c?a[S0aK6IYM7[cH<j51]1J6i@;bmCP:>h^jEgCDAKNHF0
N7V5UZBUV89/J8BkhLUk>T1jXiMcGeeIF6f=TW5<@de@D6B7Wj>Y]kFDKfQgOGjD
^;R1D6RaeJe`FVQ^Hf9/I40S;DYGDef0Yl3?f]:_QW1YHF1hW:9fADAh[KRSS85j
M7R;WI]kBR@L<U9/OXInJEieXKBEIV6Ffooeb91XIX:IREX^61<REI^mUThbF96c
`m73Q3dcJ95c<b1=SKG4aKFISZBo]i9fL6YJG7fFOdLT;3m6DgVLU6]EKI:HQXJW
cmc8YXb5RHQfF4=1CE]]Q9^TWHn0KUiLKXJ?Of57@55[MFQPO;3<]iJCYJ>9P9Zc
Wg=SOIbSV8MO6@00>hNMQF5:C7Jmjm:?Khnl_9^5Ned^9E^NZXAVMYjmcmJkLb@8
<WZUW6de5REHQ8UbJG^CVij]`/J_Th^HYJFGQGUbJEa?A3HS7T::a<JQQHR>OFM/
Q8U]CDIFKhZTZI=lRKC@a[2YYHYVEeM16aaNZ:mgBeE_KEiYQhibGg6FZjfWVh=b
Q:bjWWM_Q9JGSGI87BMdbMVJBB@_Bf5bOWa[GFRBa^7?W6aMKHB?S81]H6^B/jj4
HFJ>^L^jR4TN51dR:TM^MUY<NlgjjL>]WXAhUlO8SE15Ff5@B5MWJW>>YJ2:O7AU
GGba_hHk9e5jNV=CAcLmMLgoo=O:e]VnUGMXGeI8<a`=2a8RAGb``K6OY/;Ui;5/
@3U5Eff0OVMLNJVhU6Y`Y=?F^Yj8J4@dAV9XDC4M83aZUJ:>LFj<^N;mon:_QGMe
H3/X>eYQEEb6Zj=jI7bW^ZR5H40`?fJ1LdLY>G6ej_kX]XIbNHRCVi^4GDUSUJEg
=bA9NXYlJf5IFW>JZ8QFAVVN_;^/VhI_I6b2Vjng[YN7R8UcBS0mFUi4<dMbTYjS
YIAcI82`_ia]G6IZFTaIOZ>jaLW5^jfKOf9CFEe<;R8cD65XLWU^FEj<a]k>^K6U
PEYMS[bePE17G7F0N69:B6VL_[jWSh1kO7e/@0h08e^3TYNHQfed]_ooojmlOHf:
LUDg7A<ZEWMkLgF4SHQlLVmdPiNRW9:=QVi?Bg:R[HmdNi6CPWjE[JZAPH:3NW9e
KTTA00HmL8V@UIfY/[6RTiN^_J^7LgV3Mf=SMh1bI6j6S7Y/L7AP@CeLP8^7TZbg
VfDl>Ub<[JZ5HF:<^lo3[9J0LgfIYHMA;c0k=c10HWEaMI[7bIAGAf^N_;n/T7Uh
S:2OS7IXGUQNLhR=QWifHTeDP:f_QV5OJf0n;TE[OX2?//oA_k2[YinHTGiM@dQW
Q8M^B2XZDXjdZ81YKWEUCeQoWY^;SjNaXY2?UHY_HFamPX:=X:66He=KK7IcJ5mR
LGUT?2Y?T/2mXHn<RHREZjb7FeIlYkJc/Jf?G3LkEfAE?ce>I75`IV=fX<S@^Z:K
VXacI6ASEU9UPXn?WL?K_GU:E7bCSGmeI4@U8S]JJf]TH6V5[/W4ZiZQ]<32^jJ6
KFmnL3H0021LNXBI]l2VR8NMZI^0J5<k;CI@HfIVKgZI`=k/lNoL[gA<BV5/Ec@W
?5aWDcPbBW>H[kJ]W96I//>hTFMCEfIcOhZ:ME=2FY2obkVXZJfLL44X:C<g=CDo
Dfj?[[niZ::`a<F]THR?SG=<=CiKMXNFYZV@I4=5Hh23KUI<EVj;X:28IeQZSZJW
WJ2_]Z5mJG:9ThIeLGMfHTLi@EI]P96ITh=hOHb?Nea4?dUOPkCMhKV3L97:ilfB
Gde@DdPe8a/S@6jJ[:>BTJ6a[YMmJUmJI8:V/I5J=dMkZkR/Wj2VXI61NWQcJEeA
@cHd@UEJC3e8LZ?4dM_]n^^oS6iWI5I6A59NFTa9GH2Q/[B]WXf3QHQlFC4N:TAE
Gg>J`LVYOW2;]]3=^JFFRGmjMfY><BLfCeiNFEYTL86G[;2KPX>/fmnRAPT>AhJX
Z9N5OhZU`<BYNeQAGfa]I5Y@A3e9IX:5M6b3/<^iQeaFLI>Z][bjZi1jLgIhL69D
Aci2Fh>MUG1?D72?UX^4S9B:LEmRM8>:UJVk^j>4LW9kOgeeJf1PLi>WV6]2>U5V
HDa8Hh^NT7AXMYJie^GL^X]ZIgV4MePm=D=QR:ZbUVE5DGZGREi2E8BXY7mJC5Uh
W[k8/XUWI7fLZZ>@OFm]OYngZ6l]2aY1FeeII7f?THb?VYnGSI6S/jjEMV5MJH>M
YHiVCf>E^JY_<Q/_EGJ=WJ:ENVMZOHMjHUIUPIFGSH>3T:W4d;jFMWVI[YEC5@0F
>U5KIWV:Sh^8RXZ5PXnX^[BHNficP8^?QFY;@5jHa;j:EDY[UZZRTHIkJ4hk<c0[
:CUNRjo1alS7a<K@elJDFCU6JgAXAR<C8DYn[LO5Yh1UIGfGVWmH@U5kXJB3Ed=I
RK:jYXb8X<GKcjA/@30nGWQiFb/512aYVZZOTY^kgNC8UfiQJ75ZFDiJNij_Yi5l
M7^8TiNAOfE8=390EFE[KgZ>X:JKRX>;VIjBOgN4XKVjX7UJCE5MKGf:SH1WD4]N
Nhj7KEECJHFAQVmQJXJW_L>o]k:`Zif3GC8D5CYcWjAoCCQFV=?N/g53AFV=T6hn
8R]DQjo1`;Rd^L;5]iI]DUAbTiUg?0T08UMlOfYHHH>[aLNjZIbCRhB3QXMlI4Ti
?51ZPYN_bMcLaImmJ61IBS@P6R8bA5M]QIZW[;70f>_ZcJ1hHEaKEDi@Hgb9O5e2
@f:<Yj>:Lfn0VZROP5Xj<3iOPiJAOW5lW/;A`::CXlGF^W8S000`H71M?cI?P;;;
`j5iGEaeVK>bUFiGGG^HXIF4PY>Y[YM_CD=AJ7QkMW5_KVmcNGegHd]0E8:dc/:K
MVYlVjn`X8j2OGYfL6]YIfQ]MWn1MV=DDUeVHE15E8:kh=fjTGj5UijBNfa]MWY`
GeIOMi6QXIB4N7=gNgQUABDK=VjW`K67IFF5[;b^ThJB[KfbTFeJGFafM6EBAD59
G75nNf]MI8Jhg]nhOe12D6UkP7akOhRBWZV_ZYR1LgJ5SX9Q?c=1GFaTCTAHQK6o
ZGaGCVJ?]lc:]Yb:Qi:NVGeE=S=<KGigI5UTOI2>OW9kUJ^XQeXk>4i[PHbCVZ:W
YZ6MVIF>QX:2Ph5hKfa]Je/n9B=1LIJKP5mDJYBjc<Rm]:nWUX1[GE=:A4IFLXnO
X9ZHVibBNfYQHFI[JUe8<bdoIiRnb[bRT9>X`<JbRfQLK8ZOVGM::R@fD69UHVQn
WKFgXH1ZKHNRZiQ`Bce<KHbJUHV7U[;:d/:OMeDo=SHmBEQVKfmZIVUgRY^SXIR@
S8f=RX=nOHB=U9FASH^:QGQRBd19Hh>HVHEWD4UDIgR2Ph:2Qi6KXjJUWY>7OWf2
R8Z0KEU=DFJ1Uj6PV8n6N656;bLeDW21OgIeR:gCiMZiUHB=XjnQMd8K4b]BM8>2
Ng^2SI29Ng9dPI2ESG]XGUmWKFiZJG64WkS:clNfX8f1OH21Mehh4P005SmWPXnG
YKgHj>?7X7eYIFQXHEQDFVUgOgimQIZfb/ZaRF58@daHG5Q?BTeGIWF0R8fBUj2_
`]GOf;fDJTi6CU]PFDa4AeM/O8>7SI^[]:bCLUQ>E5iRFe=FKiS3gMVmV7egPiBL
TgiVE4a<DEMNIfidMgIfNGj2PGYaKWN9X;2cZY^>QGifKVY`PINUX8MUCD]NMhAj
H4HnD76?VHihK7B?/<C1ZX]aHemPHfQbPiV[/ZbKRG]eLg1YGDi2?Cm9F6QeO825
TJK0eMO2W7=JFg6>WYR1J5ULJGAbIU]KJh>FVi62NGUoOgAPCdiNN8b>P6eVMINn
f^;G_jJ?NVIC@c/j?D55C5Y_QiRISGadOYF]]ZZ>LF1RL829RHN9TIREQW1PH727
V9R9MfeaO85gGChY:dAYRinPU8R5Sj>jbLZlY8YfJfQUH5M?Ce]`Phb7N6UTJG=f
LFQWMYB`^JIoFDaNQZZdWgUKF7:F[jnIPGV4VJBINE4c:C0lA4Q@Hh>T^;RYVHf<
V:Vd/Ij3Jf1TKgUlMViZKGJ0QX=jKV=OHVakS9RJT7YQCDMAIh2CViZIWJNd^[JW
Th9iMG9YFDPm>d=?FVA^OYB/^K:GLUA=Gh6OZIf4LG66XK6ZT79QIWfCVX]]DTMA
IWV0NG1]M7n3Mf1=BfB=]LNmWh5eP9NXY8YZEUahVZbTQF5:BUecOWQVEDeAG6E[
L7bC/<[Db[2COWMiNG1PCd]HLi2RXI9oM7J3TINAP6YEAC`j@4iSNhjIVYJEVjNd
^;6RThfCW9nBM4l_8BHiCUiXL7b=W:BRVI>EX:VTS6I0:c5:JGf0NgbB^^KnllR>
H4aDIVmSARTL9d5KJVe]Mi6dc]:oWhF0SInTU7AGCemmTXibC3I1Jj78d;VBLfI[
Lg5PAcDdAEicNg]mRJ6mdM?7]:JPWI9jEC8Q:DUaSiN<N6UXLWn6PgYaKW5fNGUh
NGn7SY2@TINRZZNFO6=HHGZCWYEmHDm<E5iRH5mVMXbLWYB4Ngf6SX]mKFQeSjR`
X8=/K8J]bLJQJCPQ:3mDF4e2B6J@]/BiX8Z5T:2SUGYTGff0RX1XE5IdX/SA]XIK
BEMdS8adDcm1F7=nMEe:Bf>:[/?6`;Zj_;NTQf]JFfE]Ie8g:2m>N9^]Zj2FUYbN
U7aMA3U0DfUkR92GW9jLV9NMZKFhZXe[DDQ@GVQTEdY8DfMhOWM/J7B<YkVm]JZQ
Vi>2J515D6f<WYR0IUi_T:jeX7YHC5Q^O7AH>Bi0JIRe^:J@QX^GWIF4MgZ>ZKN]
RfA<CVJ0RGQF>C=9KXfDPVQJIh^dc<JVOF1IHgAnOg^7Ri>KWYJ8NG9dNh5nLfAL
GFIaLfaOEUQYPYJNUH9`JWB;YK[3_k6OSGeaIemHE55BEf5^OHR<RH1fLgN1RXf7
NV]PGVAbPY:Q[;:_Y99oLVmeOX9nLfQUKG^4OfaB?SiBLhnKTWeZJ7RCZkJbY9NA
THn6MF9IGVn3SX]oLVebNga`FTI3EgZL[:>7JUeXQJ:_YHabIFYjRHn:PX2:W:b`
Y8abGE1:A3`g>TYUPI>FS7mkQj2ial6[SWM^LGQlN6iTHFQfPhZ8OgA/JW1jR9>I
UhYfGTY0@DaMKW^5SIRT/[g3a;jeZ9V6LUe<?SD^:bdhCg2F]L>lY8YhN8BCV8eg
H5EJJgb5PgYfOY:Y]kJWTh9jN7M`I5QCEf1SFdPe<DA/WL;@ak:RXJ^f/Y]fDT57
GWJ2O6]NGg6;XZ^UUHEhKfADA3TmDG2<WIfBRHVEYJnZVHAgNHNFW91hGTi?GgF5
RH5bI5aLHFYcOHF;SXb6P7YiNgn2QHV@VZN`/JNEOVQIDeAIGf=THUmLH6]nUZZe
/9j7LVMWJfaWGUUQNIZjb/FaUhF0QXf<P6aIC4Q8AdA4BeegTJ6QUXZ8TjFc/Z69
N7J3TYB2Gc`[=eZ6Yk>ZVHb;TYNBOfIAAdQ>DDe6AeEbTk31aL?3b<c6[hQN?SI4
GG=hKEQ9BU]eRiFCRhB4RY2@RGa`JFQ]M7YoPXF7QX>0PHVHZ[Rk[iQjGd]2@4=7
BdmFGf]jRYRRYZBNV9BFVY^EQ6iIDEYbSZBYWHMcJ6M/L6eVHF9/NHB5OWA^KgMo
PGijNhBCWYjAOgAiSj^m^IedDD=:G6M[J6=QJ7B1QhAhJfAVLH6?V9bLVYRET8^6
QHR=ShQiHe18Cf=kSIB@QGelPHF1LUe9@TaTPINPVhn5QHjMZJjYWY24NW9ZHUiO
IFieMW5YHf5UK75aL79lSZBe^:^AMFARKh>AThQhK6]eQI>GThV0Ng]kMV]KCDI9
E6AdPXfEVY^FSH5iNHBEYZfXUh=eLWV2QWm_G4m>F6E_KfQPHW28X[BfZI9kJV=T
JFmfO8B<TYBBSHZ;T9FFT8=dJ6=UIfEMDDQ:F727Ti62LFUaR:Fnb<>bWhn5OWIY
FTa6BUMWMGn4Qh^?TiBARhEoNG9UE4<i?U=dUk6l]j^PW:6XZIn<MFEPI6a_IeM6
?41AJH2>Ti2<RH^>TIBEUYJDSH1^GUAFHgF6TIJFVInVZJ6<KU0n?4UKJF]REe9K
LXnY^KZaYIZCSHMnLfaZL7Z3RHV5P7]gLFYSGf9[NHF8OfiNF61dRibPUXMkNX>B
WIjGRh:1Qhj?Q75KC4QAHgJ5SY6?RhAjL6IPHVUbN7UeLGB0U:Zj_[NZWIJDSh=/
CS<V;4=ROHb<PgUgOXZEVYN?QX1mNgMaJfQZLWf6SI2CUY^NWIF9OWQkPHEoJdd_
7AhbDG27TiRMZ;O6c<FbVH5bKFaZHeQ=B4eLL8JHYJf_ZYj;M5i@CUEPJF]VGeeU
MX^KXInJVJ2^^[f`UWQPEEQSKFiTEDU4BeY/OH^FX:N[Z9j>O6iUHfAUJ6]dPY>R
ZJFIRh>5SiRGRFi@>SE0EVakOgaiNX:<THn6NgIiQ9>NXj2GSHAmNGEcLgMlP7if
J5aGGFeoRhb2MG1_LGEhNWaoQHnKYJZWVhQeIf5UL7j8RhR0N7=cN7j2P7U^HUUF
EeeTJg9jQYFU];fm/Z2:MV]XKWImOWU_IEmOIW1jPH:0NgQhNWenOGYfM7MmQHb=
R7mdKFiiRin_]K6TTGi_IF1MFUE@CDiEH6ikQH^>TIJLXjNUVhYhJ61SKWj>UYJ>
PWI^K6mdNGYiMgEeN7]lNG=[IFAXLGb5R8J1OGj7UZNe^kJWTGYXG5MHFUaMGV5W
L7V0Ph5mNGUmQY2GV9:6NW9aMh>>UIB<Og9[JW1jQHb@Shb8Q7mgK5mAAT97EFQl
S9FGUYJIXJ^d]ZnORW=QEUAHGfI/L7=gOH:6QX5iLFe_MX6:SX^1LfMRIG1oSIJH
UHn<S92FVi^FS7mbJ5mIDTa6A4UEJH:IZJn[WY23OGj3QhV5OWE_KgAnR92CTHb6
PGeiLf]QFEEGHG20Rhn:P7A/K7B1SiZMViB<QhF6RHV6P7UdLW=eMWE`JVIVJgEo
QHElKf5IFFAgS9n[[j^TW9JAS8EkL6ENFemUKG=fMgQlPhjGW9V<N6=AB4YEIWN5
SI2ATYJKXJBTWiN?RHB0NW5UEdY3ADiMKGZ1PWmmP8VGYJj`Z9R4LF9JEeUMHf]e
Q9FU/[NcYiJ4MFaWHeiEBChg>DELMi:W/kNc[JJPViJ>QG]bKFa^L71]If5NHFal
SIZOVhn1M6e/Kg=eLV]TGemVLh:AWJF[/;>c/:JDOVE@@d17E6=^M7AbLGAmRI>J
VI:6Ng9_L7EjOh:5RHnEVY^ERWa^IVI/Mh66Q7Y]HE]KHfihOX1oOGf0QHbATXb?
TY>AS8EmMW5`LgV1R8j?S8AhJemED51EGVUdOhR>TiJIVibMW9RBRGibJ65NHFQc
OhZBUYB>QG]bJfMVJ6]^L75`KVe^LWR1RiFMXZBRWINARhN3P7afKVEKDde<D5YX
N8VGXJFSVi65NW5/JV]]LGAhNgn4RY6HWZ:RWIB8NF]NEU=DFF5YL7EfMWEdMGV0
RI:KXJBRWIF<PgagM79bLG1^K6][KW=kPh^@THj6O71UGEYLHfeiQHjDUiJDTHj=
SHf>SHZ6OgQaJfQWJFa^L71^JVMUIFYbOX^GXJJVXIR<PGM`KFeaMGYnP861P862
PhF5Q81jLFQPFeULHfehPh^@THn<R8J6RHjCV9ZIU8b1MV]TGeiOHVIZKFmbMGUo
QHbBUIF@RGmdJfIVJW=nRiJMX9jIT8MnN7=`Kfi]JfUVIFEWK79jPHJ9R8J2OWal
P8J>UIZLVY>:OgE^JFU[L7EiNg]iMG5^KFiaMGUmOWinOGeoPhR?U9NGThb2N71[
JVedOHN>TI6<PgU_IV1MGEmRIFU^LgV0RYBNYjb^ZZ6EQWQ/I61QIF]bMWUiN7Ie
MGMkP8J9RhV4OGE^JFMXK79iOhF9SI2DV9fQY:FQV8]iIUA5>cPlAeIWNHRDW:6R
XIjJUY6:PgYaJF9OH6I_NhRCVijMUhn5O7E`KVe]K6YWHUiLG61XM8:@W:J[[:VS
W9B<QGigLFYSGEQGFV1[N8JBVYfKThQkKVANGF1VKgR1Qhb?TYBFV9VIUY69P7E/
I61PI6YaMg]mNgQcKfe_LgV1R8jAT8f8PWilO7n3R8b=S8F6QHB1OGQbKFMSH5mQ
IF]bNX>;TIFGUY>>Qh1iLfm^Kg9gOXF<TYJHUY:;PgU_IUiIEUIHGFE]MWn7SYBH
VYZIUiB@S8N3OWYfLVm/JfY[KG5eNX25RH^<RhR3O7A]IV5NGV5WL7^7TijW[Jn]
Z9nCQWU/H5QBD59FGFE^N827S8n@Shf:Qh>0OWakNW]kO7amOWn0PX>5QhR9RHR6
PWegL6YTGe]JG61VKgR3SIFLXJ>RWYR@R81iLfi/K6i`M7QkOGinOG]hMG=aLG5c
MWUmP8>5QXJ5Q8:1P7n0PXB6RH^<S8Z7PWefL6YUHF1PHfM]LgZ0QHV<SHf<RXV7
QXF4QHF5QHB3P7ejMW=`KVe]Kg9eNGf0PX>2P7eiMW=aL75eNGn6SI>GVY^IUHn8
P7QaJVITHfAWJfmcMgYlOWinOWioP863QHR:Rhb<RXR4PGejMgEeMGMiNgeoOgmm
NgMcL6e[JV]^LWMmPhV=TI:CTHn<R8F1OgelO7alO7]iMgA`K6UWIVMYKG=jPHR>
TYFFU96<QX1jMG9`LG=gNh25RHb<RhV4OgUcKVUVI6AVJFaaMGYoPhR;Si6DUIJF
UI>?RXAmMViWHUiLGF1VKGIoQhjCUYJBSHImM6eWHf9TJG5jQ8jGWZ>TXYfFSH9h
KVEOFUQIFemUJg9hOhB9SI2BTi>BT8f:QX5lN7A`KVi_LGEjP8F:SHj>RhIoMfmX
HEeKG61VKgV4SYNNXZ>RWIJ>QGeeKf]YJF]^LWIjO7ioOWajN7IdLg=dMWUlOh:4
QXN8R8R8QhN6QXF4Ph5oO7QeLFi/JVYcMgYlOX20P81nOG]jNGUjO7j1QHR;SY2A
THn<Qh9lMVmZIF9PH69VJW1gOXF:Si:CTi6>RHAoNWIcLG1aM7QlPHJ:SHn?SXZ5
OgQaJVAOG5aMHFI^MX29TIVNXZ>QWIR@R7mgKfUTHF5SIV]aN7j4RHb>SH^7Pgeg
LVeZJ6QZKW=iPHR?UIZMWIbIThb4O7=/IF1LFeaOI6Y`Mgn5RXnATY6?S8R4P7ai
MWEeMWQjOX64QXN8R8J3P7ahM71/JVUYJVa_LgQlPHJ9S8n@T8n>S8V6Ph1mNWQg
MWEdM7AdM7EeMGIfMWMhNGYlOGn1PXB5QXN7QXJ5Q8>1P7mmO7akNWYjNGUhMgIe
M7AcLW9cM7EgNWf0PhN:S8j@T8n>RhR4P7agM75^KFa/KVmbMGQkOH21PX>2PX5o
OWelNg]lOGn1PhF7R8V9RHN5PWmkMg=`KF]YJFY[KW5eNGf1QHV;SHj>SXb:R8F2
OgajN7MfMGEeMWMhNGYjNg]kNgYjNGUhN7QiNW]lOX22Q8J8RX^;RhZ9QhB1OGUe
LVi/JVUYJV]^LWIjOX>6RXb>SXj<RXN4PGejN7IeMGEgNG]mP863Ph>2P7ejMW=_
KF][JfeaMGYoQH^@U9NHV9JBSXR2NgE_JVMTI6EXJg1eNWn4QhZ;RXV6Ph1lN7Id
LgAeN7]oQ8R;SY2@Shb8PgihLVaXIF=SI6M[L7IlPXN<Si:BTY2=RHF1OGYgMGAd
MGMiNgeoP860OgilNGIdLW1`L75cMWUmPHF8Rhf>SXf;R8F2OgaiMgEdM7AeMWMh
NGUjNGUhN7MgMWMnPH>6R8Z;S8b;RHN5PWmlNGMeLg=cLgAfMgUkO7enOWimO7]j
N7QgMgQiNgj1Q8N:S8f>SXb:Qh=nNGA`K6UWIVMYK6mdNGj3QhZ=SXj=RhR5PWik
N7IeMGIgNGaoPHB5QXJ5Ph1lN7A`KF]YJFY]L7EjP8F:Si:EUYFCT8b7PGafLVi[
JVUZK6mcMg]oPXB6QXJ4PX1mNWQfMGEfMgYmP8B7RXb=SHf:QhAoNWIaKFYXIfQY
K6mcN7f1QHV;SHf=S8Z7Q85oO7YhN7MhN7UkO7enOWinOGajN7MeM7=cM7EfN7]n
P8>6R8V:RhZ9R8J4PGilNGMfM7=cLg=cM7EfMgQiNgamOWn0PH:3PhB5QHF5Q8>2
PH1nOG]jNGQgMWIfMgMhN7UiNWYjNg]kNgalOGioPH:4QHJ8R8R8QhF3PGijMgAa
Kfi]KFi_LWEhNgn2QHN8RHV8QhF2P7ilNWUhNGUkO7j0PH:3Ph:1OgaiMW=`KVe]
KVmbMGUnPhN;SY6BTY6>RhN2OGUdLFi/K6a^L7=gNWj1PhB5QHB2P7ikNGMfMGEg
NG]oPXF8Rhb=SH^9QH5lN7=_K6UXJ6U[KW9gO865RH^=SXj<RXN4PGekN7IeMGIg
N7YlOX21PX61OgekNGIdLW5aLG=eMgYnPHF8RXb=SHb;R8F2Og]hMG=aL71`LG=e
MgUkOGioP820P81oOgmoOgmoP821PX:2PX:2PGmnOG]iN7IeM7AdM7EfMgQjNgen
Oh21PX>4Q8B4Q8B4Ph:1P7mnO7]iMgIeM7=cLgAeMWQjO7j0PH:3Q8B4Ph>2P7mn
Oh21PX>3Ph>2P7mmNgUfM7=aLG5aLW=fN7]nP8>5QhV9RXV8QhF3P7ilNWQgMWEe
MWMhNGYkO7amOGemO7akNgYjNW]kOGioPH:4QHJ7QhJ5Q89oOGYhMG=bLG1`LG9d
MWQkOX22Q8J6QhN6QHB2PGmmO7]jNWYjNW]kO7amOGelO7]jNGQgMgIfMgQiNWan
P8>4QXN8RHR7QXB2OgejN7EdLW5aLW9dMGMiNgeoPH:3Ph>3PX60OgmnOGemOGen
OWn0P820OgmmO7]iN7IeM7=cM7EfN7YlOh63QHN8RHV8QhJ4PGmmNWQgMGAdM7Ee
MgQiNgamOWmoOgmoOWimOGalOGenOh21PX:3PhB3PX60OWajN7IdLg9bLW=dMGQj
O7n1PhF6QhN7QXF4PX1nOG]jNGQhN7QiNGYkNgalOGelO7]kNWYiNGUjNgamOh22
PhB5QXJ6QHB2P7ilNGMeM7=bLW9cMGIhNWanP8:3Q8B4Q8>2PH1oOWelO7]kO7al
OGenOWimOGakNWUhMgMfMWIgN7YkOGn1PhF6QhN7QXF4PX1nO7YhMWEdM7AdMGIh
NG]mOWn0PH61PH20OginOGemOGinOgn0P861P81oOWekNWQgMWEdM7AeMWMiNgeo
PH>5QXJ7QXJ5Ph60OWajNGQgMWIgMgQiNW]lOGenOWimOGelO7alO7amOGioP862
Ph>3Ph>2P7mmNgUgMWEdLg=dMGIhNG]mOh63Q8B5QHB4Ph60OgelNgYjNWYjNW]k
O7alOGelO7]kNWYiNGUiNGYkO7ioPH:3Q8F5QHB3PX5oOG]iNWYiNGQhN7QhNGUj
NW]lOGenOh20PH61PH61PH60P7mnOWelNg]jNGUiN7QhN7UiNWYkNgamOWioP821
PH61PH61P81oOgimOGakNgYiNGUiN7QiNGUjNW]lO7enOgn0P861PH61PH60P7mn
OWelO7]jNWUiNGUiNGUiNWYkNgamOGioOh20PH61PH61P81oOgimOGakNgYjNGUi
NGUiNGUjNW]lO7enOWmoP821PH61PH20P7mnOWemO7]kNWYiNGUiNGUiNWYkNgam
OGinOh20P861PH60P81oOginOGalNg]jNWUiNGUiNGYjNW]lO7emOWmoP820P861
P820OgmnOWemO7]kNWYjNGUiNGUjNWYkNgalOGinOgn0P820P820P81oOginOGal
Ng]jNWYiNGUiNWYjNg]lO7emOWioOh20P820P820OgmnOWemO7akNgYjNWYiNGYj
NWYkNgalOGenOWmoP820P820P7moOginOGelO7]kNWYjNWYjNWYjNg]lO7emOWio
Ogn0P820P820OgmnOWemO7akNg]jNWYjNWYjNW]kNgalOGenOWmoOh20P820P7mo
OginOGelO7]kNgYjNWYjNWYjNg]lO7amOGinOgmoP820P81oOgmnOWimOGalNg]k
NWYjNWYjNW]kNgalOGenOWioOgmoP81oOgmoOginOGelO7akNg]jNWYjNWYkNg]l
O7amOGinOWmoOgmoOgmoOgmnOWimOGalNg]kNgYjNWYjNg]kNgalOGemOWinOgmo
OgmoOgmoOWinOGemO7akNg]kNgYjNg]kNgemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGem
OGemOGemOGemOGemOGd\>"]},
  ImageCacheContents->"Sound",
  CellTags->{"SineChime", "G.3.2"}],

Cell[CellGroupData[{

Cell["Implementation", "SubsubsectionIcon",
  CellTags->{"SineChime", "G.3.2"}],

Cell[BoxData[
    \(\[Phi][{\[Alpha]_, \[Beta]_}, \[ScriptCapitalA]_, \ f_] := 
      If[\[Alpha] < t < \[Beta], \ \[ScriptCapitalA]\ Sin[f\ t], \ 0]\)], 
  "Input",
  AspectRatioFixed->True,
  CellTags->{"SineChime", "G.3.2"}],

Cell[BoxData[
    \(Play[
      Evaluate[N[
          Sin[\(\[Pi]\ t\)\/2]\ \(\[Sum]\+\(i = 1\)\%36 \[Phi][
                {i\/18, \(36 - i\)\/18}, \((\@\((\(i - 36\)\/13)\)\^2)\)\^2, 
                1000 \((i + Sin[i])\)]\)]], {t, 0, 2}]\)], "Input",
  AspectRatioFixed->True,
  CellTags->{"SineChime", "G.3.2"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ", "GroupDivider"],

Cell["Harmonic Wow", "Subsection",
  CellTags->{"HarmonicWow", "G.3.3"}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.0238095 0.952381 0.0147151 0.588604 [

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

% Start of sampled sound

1 string

11025 22050 8

{ currentfile 1 index readhexstring pop }

 false 1 sampledsound

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F807F7F7F7F7F80

7F7F7F7F7F807F7F7F7F80807F7F7F7F80807F7F7F7F80807F7F7F80807F7F7F7F80807F7F7F

7F80807F7F7F7F80807F7F7F8080807F7F7F80807F7F7F7F80807F7F7F7F80807F7F7F808080

7F7F7F8080807F7F7F80807F7F7F7F80807F7F7F8080807F7F7F8080807F7F7F80807F7F7F7F

80807F7F7F8080807F7F7F8080807F7F7F8080807F7F7F80807F7F7F7F80807F7F7F8080807F

7F7F8080807F7F7F80807F7F7F7F80807F7F7F8080807F7F7F8080807F7F7F8080807F7F7F80

807F7F7F8080807F7F7F8080807F7E7F8080807F7E7F80807F7F7F7F80807F7E7F8080807F7E

7F8081807F7E7F8080807E7E7F80807F7E7E8081807F7E7F8081807F7E7F8081807E7E7F8181

7F7E7E8081807F7E7E8081807F7E7F8081807E7E7F8181807E7E7F81817F7E7E8081807F7E7F

8081807E7E7F8181807E7E7F81817F7E7E8081817F7E7E8081807E7E7F8181807E7E7F81817F

7E7E8081817F7E7E8081817F7D7E8181807E7D7F8181807E7E7F81817F7D7E8082817F7D7E80

82807E7D7F8182807E7D7F81817F7D7D8082817F7D7E8082817E7D7E8182807E7D7F8182807D

7D7F82827F7D7D8082817E7D7E8182817E7D7F8182807D7D7F82827F7D7D8082817F7D7E8182

817E7C7E8182807D7D7F8282807D7D8082827F7C7D8083817E7C7E8183817D7C7F8283807D7C

7F82827F7C7D8083827E7C7D8183817D7C7E8283807D7C7F82837F7C7C8083827E7C7D818381

7E7C7E8283817D7C7F8283807C7C8083837F7C7D8183827E7B7D8183817D7B7E8283807C7C7F

83837F7C7C8083827E7B7D8184827D7B7E8284817C7B7F8383807C7C8084837E7B7C8184827D

7B7D8284817C7B7E8384807C7B7F84837F7B7C8184837E7B7D8284827D7A7E8384817C7B7F84

847F7B7B8084837E7A7C8185827D7A7D8385817C7A7E8484807B7B8084847F7A7B8185837D7A

7C8285827C7A7E8385807B7A7F84847F7A7B8085847E7A7C8285827C797D8385817B7A7E8485

807A7A8085847E797B8186837D797C8386827B797E8485807A7A7F85857F797B8186847D797C

8286827C797D8486817A797F85857F797A8086847E797B8286837C787C8386827B797E858680

79798086857E797A8186847D787C8387837B787D8486817A797F86867F797A8187857D787B83

87837B787D8587817A787E86878078798087867E777A8288857C777B8488837A777D85878179

787F86867F78798187857D787B8387837B787D85878179787F86867F78798188857C777A8489

847A767C86898278767E87898077777F88887E76788189867D76798389847B767B8588827977

7E86878078798187857D787B8387837A777D86888178777F88877E7678828A867C7579848B85

7A747A868B8478747C888B8277757E898A8076768089887E76788289857C767B8488837A777E

86877F78798188857C777B84898379767D87898176757F8A897E7476828C897C7276848D887A

7278868D8678727A878C8477737C888B8277757F88887F76788188857C777B84888279787F87

877E77798389857A757A868B8377737C898C8274727E8C8D807272808D8C7E7173828E8B7C71

75848E897A7177858D8679737A868B8378767E87887F77798288847B777C8688807777808987

7D7478848C87797179878E8676707A8A9084736F7B8C9083726F7D8E8F8171707F8E8D7F7173

818D8A7D7276838C877B747A85898279777F87867E777A84888379767E88897F7475818C8A7C

717584908A796E7587928A766C768A9388746C778B9387736D798C9184736F7C8C8E8173727F

8B8A7E75778289857B767C85878078798188857B757B878B8276737E8C8D80717180908E7D6D

7083938F7B6B7085958E796A7187958D776A7388948A766C7689918776707A898D8376747E89

887E77798388837A777F87877D7579858C8578717A8A9084736E7C8E92826F6C7D9294816C6B

7F94947F6A6B8195937D6A6D8294907C6C7084928D7A6F75858E8879737A868A827877808785

7C777D8688807677828C887A7076879189766C768B95887268778F98886F66789199866D6679

9298856C687B9296836D6B7D9192806F70808E8C7E7376838A867B767D86867E787B84888277

757F8B8B7E717383918D7A6B7187968E7666708A9A8F7464708C9C8E7263718D9B8D7164738E

998A7168768D9587726C7A8C8F8374737E89887E777A838781797982888479747C898D817270

7F90917F6C6C8196947C676A839A967B6369859C96796269869C9578636B879A9278666F8797

8E776B7487918878717A878A8278788087837B798087867C7479878E85746E7A8E94856E687B

93998469647B989C8366627C9A9D8264627D9A9C8165647F99998067688096947E6B6E82918D

7C7175838B867B777D85857D797E86877E7577848E89786D758A968A7266748F9C8B6E617393

A08C6A5E7395A28C695D7396A18B6A5F74949E896C63779198866F6A7B8E908273737F8A887D

777B84867F797B8488817775808C8C7C6E7285958F77666F8A9C92735F6C8DA295715B698EA5

967159688EA596725C6A8CA09374626E8A998E75697489928776717C888A8077798287827979

8188857A747C8A8D81716F8093927D686A849B987A606485A29D795A6085A5A17B5A5E83A4A1

7D5D60819F9C7E63668198957D6B6F83918B7B7178858A8278788087847B777E87877D757986

8D85746E7B8F94826B677D999C82625E7DA0A4845D587AA2A9875D55769FA98A6259759AA389

6961779399866F6B7C8E8E807375828A857A777E87867D777B8588817777828C88786F778B95

886F657695A08A675A739AA98F63526D9BAF9465506997AD976B556891A695715E6D8B9B8E75

6A7689908576747F89877C767B858880777882898479767E8A8A7C707487948C7464708FA192

6D586993AC9A6C506191B1A1704E5C8BAEA477555D85A59F7C60648299957D6B70838F897A74

7C87887F777983898379777F87877D767B878A80737282939079656B88A19975586189ABA477

515684AFAC7E51517DAAAE865A54779FA789655E77949A866F6C7C8C8C7F7579848881787881

89867B767B8588807879838A8376727E90927E6867819E9E7E5B597EA8AC84554D76A9B58E59

496DA2B595634E6996AB956E5B6C8C9B8E766B76888D83787881888379777F88887E76788288

847A7880888579727B8D93836B647A9AA387605473A1B2925D48679FBA9D64455D95B7A4704D

5B89AAA17A5D63829A957E6D71828C877B777F86847B767C87898177767F88867D787D86867C

73798993886F637495A59067526898B49E69465992BAAC73464F85B4B08051507AA5AA88625C

77959A87716E7C89897F797D84857D777A858A8479757C8688817A7B83867E757786928B7463

6E8EA59870525E8DB3AA76494D82B6B7844C4574ADB9915A496B9CAF956B596B8C9C8F776D76

858A837B7C83857F7779828A877C75788388847C7A808480777783918E79656987A39F7A5556

80AFB3854F4472ADBF95573E62A0BEA168475C8EAFA2785A62829A96806F717F88857E7C8184

8079788089897F75767F87867F7B7E83807977818F8F7D6766809FA4845A5074A7B894594061

A0C2A6663D5290BDB0784A4F7FAAAC86605A76959B89736E798587817D8083817A777E888A82

77747C8587827C7D81807A78808D90816A63799AA78D624D689DBAA2673F5291C1B57741447D

B6BC8B53466DA1B1956A586B8C9C907A6E748187837E7F82817C787C858A857A757A8387837E

7D80807C787D8A90856F647394A7956A4D5E92B9AD74424680BCC18B4A3A69ABC39F61435C92

B1A2785A618098968271727D8685807E81827E797A8288867D77798186847F7D7F817D797C87

8F8773656F8EA59B73505786B5B683483D6EB2C99E5735559AC4B073454D80ACAD87615B7491

99897771798385817E8082807B7A7F86868079797F8484807D7E807E7A7B848D8977676D88A2

9F7B54517BAFBC9252385DA4CCB069364486BFBF884E436DA1B2976D5A698898907D72768084

827F7F81817D7B7D8385827C7A7E8384807D7E807F7B7B838B8A7B6A6B839EA2835A4D6FA6BF

A05F374D93CAC07D3D3770B4C89D5C3F5B91B2A47B5D617C94948576747C8383807F81817F7C

7D8083827E7B7E8283807E7E807F7C7C81898A7D6C6A7E9AA38A604C659CBFAC6E3A4180C2CB

93492F5AA4CBB06F414B7FACAE8B655C718C968C7B74798083817F8081807E7D7F81817F7D7E

8182807E7E80807D7C81888A7F6F6A7A96A491674C5D91BDB67D41376DB6D2A75A2D478FC7C0

854A416BA0B39A715B668294918276767D82827F7F8081807E7E7F80807F8081817F7E7E8080

7E7D80878980716A7792A4966F4E5585B7BE8D4B325BA6D3B96F323778BCCA9B593C5990B2A8

805F5E778F95897B757A8082807F808181807E7D7E7F808182817F7D7E80807E7D8087898272

69748FA39B7651507AB0C29B58314B94CEC8843D2D62ACCFAF6C3F497DABB190695A6B869590

8176777D82817F7F8182827F7C7B7D808383817E7C7D80807E7D80868A837369718BA29F7D55

4C6FA7C4A867343E80C5D19A4D294D98CCC082473F699FB59F765B617C92958879757A808280

7E808384817C797B808485827D7B7C80817F7D7F868A8475696E87A1A3845B49659DC3B3763B

356DB7D6AE602C3C81C2CB98563A568EB3AC85615A708B978F7F75767E82817E7E8285837E78

787E8588847E7A7B7F817F7D7F868B8676686B839FA68B60485C92BFBC8545305BA7D4BE7635

306AB3D0AD6A3D467AABB5966B57648196968677747A81827F7D8186868078757A848A877F79

797E82807D7E858C887968687E9DA99367485486BAC294512F4C94CECB8B432A559FCEBE8046

3C669EB9A67A595A75929A8E7B72767F83807D7F858883797377828B8B8278777C82817D7D84

8C8B7B69657999AB9A6E4A4D7BB2C6A25F314082C4D2A0542B4389C5CA965538538CB6B38B61

5469899B958173737C82817D7D8489867C73747F8A8C847A767B81827E7C828B8C7F6C647493

A99F774E486FA9C7AE6D36356FB8D8B3672E3372B9D2AC683A4477ABB89B6E56607E96988878

737981827E7D8187877F76747C868B867D777A80827F7D80888B827066718DA6A3805546659E

C6B97D3D2D5CA9D8C57D36275BA7D3BF7E433A639CB9A87E5C5A728E988E7D75777F827F7D7F

8486827A767A8389867F797A7F82807D7F868A8474686F88A2A4875C465C93C2C18C48294B97

D4D39344224592CDCD9552365189B3B28E6758688495928378777C81807E7E8285837D787A80

8686807B7A7E81817E7F848984776B6E839DA58D63485587BCC79B55293C83CBDDA95723337A

C2D6AC66384275A8B79E745B60798F94897C777B80817F7D808384807B7A7F8485817C7B7E81

817F7F838785796D6D8099A4926B4B4F7CB4CAA9642D306FBDE1BE6D2A2561B0D8C07C423860

98B7AA84625C6F87938E8179797E817F7E7E8183817E7C7E8183807D7C7E81817F7F8286847B

6F6E7D96A396714E4C72AACAB57435285CADE0CF84361D4A9AD4CF9451344E85B0B3946E5C66

7D8F91877C797C80807E7E7F8182807E7E80817F7D7D7F81817F7F8185847C716E7B92A29978

534969A0C8BE833F244A99D9DB9C481C3682C8D9AB64373F71A4B7A37C605F7388918C817A7B

7E807F7E7D7F818281807F7F7E7D7E8082817F7F8184847C726E7990A19C7D57486096C4C593

4C243B85CFE3B25D212769B7DCBF7B41365C94B5AE8B695C697F8F90867D7A7C80807E7C7D80

838483807D7B7B7E8183827F7F8184847D726E788DA09F835C47598CBECAA15A283071C0E5C5

742C1D51A2D8CF9350334A80ADB69B755D61758A918C817B7B7E807F7C7B7E828585827D7979

7D818483807E8084847D736D768BA0A18861485381B7CCAD692E285EAEE2D38C3C1A3C8ACDD9

AA64363C6BA0B9A984635B6B829190867D7A7D80807D7A7B808688857E78777B818584807E80

84857E736C74899FA48D66494D77AFCDB87838234D9BDADEA24F1D2C71BCDCBF7B4133578FB5

B4946D5A61788D938C807A7B7F817E79797E868B8880777478808686817E7F84857F736B7186

9EA6936C4A486EA6CBC08743233F88CEE3B665262159A8D9CE935131457BACBBA47B5D596D86

9491857B797E817F7A777B848C8C837871757E8788837E7E838681746A6E829CA899724D4464

9CC8C79550253475BFE3C67C341D4490CED8AA653638659DBCB28B6555627D92968B7E787C81

817B7678818C8F877A70717B8689857F7D828683776B6C7E99A89E7951425C92C3CCA35E2A2A

62B0E1D593441B3278C0DDBF7C4131528AB4B99B72595C738B948E817A7B80817D78777E888D

897E747279838886807D8085847A6E6C7A93A5A08059445587BBCFAF6C3023509EDCE1A9561E

225FAEDCD09451304276A8BAA781615A6B839190857C7A7E817F7A787C848B89817774798187

86817D7F83847C726E788EA1A0866046507DB3CFB97B391F408BD3E9BE6C26184897D5DCAB66

36376197B7B1906C5C647A8C90897F7B7D81817D797A818788837B76797F8585817E7F82837E

746F778A9DA08B664A4D74AACDC28A451E3278C6ECD0843413337FC7E1C07D42314F84AEB69E

79616071858E8B837D7D80817F7B7A7E8486847D797A7F8384817E7E81837F767176879A9F8E

6C4E4B6BA0C9C89852212764B5EADF9B46142265B5E1D29552314070A1B6A9886A606A7D8A8C

867F7D7F81807D7B7D8184837F7C7B7F8283817E7E80827F78737785979E9171524A6497C4CC

A460272052A3E3EAB25C1B164D9FDADEAC6737355C90B2B19675636574848B88827E7E80817F

7D7C7E8181807E7E7F8282807E7E80817F79747784959D9276564A5F8EBECEB06E301B428FD8

EFC673280F3786CDE4C17E43304B7DA8B5A38369626D7D888A857F7E7F81817F7D7D7E7F7F7F

80818282807E7E80817F7A757783939C94795A4A5A86B7CFB97D3A1B347BCAF0D78B390F256C

BAE3D39755323D699AB3AD9173646775848A87827E7E8182817F7C7B7C7E80828383827F7D7D

7F817F7A757782929C957D5D4B557EB0CEC18A461D2968B9EDE4A34D141853A4DCDEAE6A3933

5688ADB39F7F68636E7D888985807E808283817D7A797B7F838685827E7C7C7F817F7A767782

919C9780604B5176A8CBC79753222157A7E4ECB8641F103D8CCFE4C28146304574A2B5AA8D70

626776848A88827E7F8284837F7976787D848888847E7B7B7E81807A757681919C9983634C4E

6FA1C8CBA361291D4794D9F0CA7B2F0F2B73BDE3D3995832386092B2B39B7B65626E7E898A85

7F7E818585817A74747A838A8B867F7A797D81807B75757F909D9C87664C4B6899C4CFAD6E31

1B3A81CBEFD89242131D5AA8DCDEB06D3B304E80AAB8A8886B5F6677868B88817D808587847C

737176818B8E8A8179777B80817C75747D8F9E9E8B6A4D476191C0D1B77B3C1C2F6FBAEAE2A7

571C154590CFE3C485492E3E6B9CB8B49775605F6E818B8B847E7E8489877E746E727E8B918E

837976797F827D75737B8C9DA1906F4F455A89BAD1BF87461E275EAAE3EABB6D29113177BFE3

D49D5C3333588BB1B8A382675F697A888B867F7E828788827870717A878E8D857C77797E817F

78747988999F927556475680B2CFC59452221F4E99DBF0CD83370F205FABDEDFB3723E2F4878

A4B7AC8E71626574838A87817E808587847C747279838B8C867E78797D81807A767985959C94

7A5C4A5379A9CBCA9F5F281A3F87CFF3DD994813134794D3E6C7894D303C6694B1B19A7C6865

6F7E8787837E7F8386857F78757880888A867F7A797D80807C777983919A947E614D5272A1C7

CCA96B30183275C1F1EAAF5D1B0B327CC4E6D7A06037345483A7B2A38870666C788387847F7E

818485817B77787E848886807B7A7D80807D797A828E9793816651516D99C1CEB2783A182763

B1EBF3C47329082063B0E1E2B676423146709AAFAA937A6B6A747F8584817E7F8284827E7B7A

7D828584807C7B7D80807E7A7B818C9493826954526992BCCDB984451B1F52A0E2F8D68A3A0B

124B99D6E8C98D52333B5F8AA8AE9E85716B707A8284827F7E808283817E7C7D8082827F7D7C

7E80817F7C7B818A9392846C5752658CB6CCBF8F50201A438DD5F8E4A14E12093580C6E8D9A4

663B344E799DADA6907A6D6D757E8383807E7F818282817F7F7F807F7E7D7D7E80817F7C7C81

8A9191846E59526287B0CAC4995C2717377BC7F5EFB6641F052368B3E2E3B97C483341678FA8

AB9B84736D717A8083817F7E7F8183838381807E7D7C7B7D7F81817F7D7D8189909085705B53

6082ABC8C7A2672F162C6AB7EEF6C97B2F0715509CD7E8CC93593738567FA0ACA48F7B6F6E75

7D8282807D7D7F82858684817E7B797A7C808282807D7D8189909085715C535D7DA6C6C9AB72

3818245AA5E4F9D991420E0B3A84C7E7DAA96D4033476D94AAAA9A84736D71798082817D7C7D

81858888847F7976777B808383807D7D8189909186725D525B79A1C3CBB27D421B1E4C94D8F8

E5A6571907286CB3E1E3BD834E343B5C85A3ADA48F7A6E6D747D82827E7B7B7F858A8B888079

7474797F8485827E7C8189919288745E5158749CC0CDB8874B201A4084CAF3EDB96D28081A54

9DD5E7CF996039334C7499ADAB9A83716B70798083807B797C838A8E8B83797271767D848683

7E7C808891938A765E50556F98BDCEBE905526183574BAECF2C9823A0E114085C5E5DCAF7444

313E628BA8B0A48D776B6C747E83817C7879818A9090877B716E727B8487857F7C7F8892958D

78604F516A92BACFC3995F2D182D65ABE2F3D6964D180C2E6EB2DEE4C28A543435517B9FB0AB

977F6F6B717B82827E79787E878F908A7F746F7179828786817C7E858F948E7C655352668CB3

CBC6A26A341925579CDAF6E4AB6021081D579DD4E7D2A0673E33466B91A9AC9E88756D707880

827F7A787C838B8E8B8278727278808686827D7D838C918D7F6A58546486ACC7C8A9743D1B1E

498DCFF6EFBE742E08104187C6E6DEB47C4B353D5C829FAAA3907D7170767E82807C797B8087

8B8A847B7574787F8485827E7D82898E8C806D5C566381A6C3C8AF7E461E1A3D7DC3F2F7D089

3F0D072D6FB3E0E6C6915C3B384F7393A5A597847671757B80817E7B7A7E838888847E787679

7E8384827F7E81878C8B81716059627DA1BEC7B4864F2417326EB5EBFCDF9E5116021C589FD5

E8D5A66F46384564869EA59C8C7D7474797F81807D7B7C80848684807B797A7E8284827F7E80

858A8A8173635B637A9CBAC6B78E582A162A5FA5E2FDEBB26623020F4288C6E6E0B984553B3E

567793A1A093847975787D80807E7C7C7E818383807D7C7C7F8283827F7E808488888174655E

637898B6C5BA95613118235296D7FBF5C47B3307062E71B3DFE6CA9966433B4B69879BA0998B

7E78777B7F80807E7C7D7E8081807F7E7F818283817F7E808387878175675F647795B2C3BC9C

6A381A1E4687CAF6FBD490450F011E5A9FD3E8D8AD794F3C425B79929E9D92857B78797D8081

7F7D7C7C7D7E7F808081838383817F7E8083868680756861647692AFC1BEA172401D1A3C78BC

EFFEE2A4591C01114488C4E4E1BF8D5F423D4F6B87999E988C807A797B7F81817F7C7A7A7B7D

7F8284858583817E7E7F8386857F756861647590ADC0BFA679472219336AAEE6FEECB66D2B05

083171B1DCE6CFA2704B3D455D7A929D9C93867D797A7D8182807D7A77777A7E828688878581

7E7D7F8286857F74686164748EABBFC0AA804E27182C5E9FDAFBF3C6813C0D04215B9DD0E6DB

B58459403E506C88999F998D827A797C8083827F7A7674767B82878B8A87817D7C7E8286857F

74686063728CA9BEC2AE86552C19265391CEF5F8D4954F1904154787C0E1E2C69869473B455E

7B939F9E94877D797A7E8384817B7572727880888D8D89837D7B7D8186868075685F61708AA7

BEC3B28C5C311A224984C2EEF9DEA66227080D3571ADD8E5D4AC7B533D3D516E8A9CA19B8E81

7A787C8285837D75706F747D878F908D857E7A7B8085878176685E5F6D87A6BEC5B69263361C

1F4178B5E5F7E6B67537100A265C98CBE3DEBE8F62423945607E96A19F94867C787B8085857F

77706D717A858E918E877F7A7A7F848682786A605F6C84A1BAC4B8986A3D1F1D386CA9DDF8EF

C687461606184784BBDEE3CCA2734E3D4156738C9C9E978A7F7A7A7F8385827B74707278828A

8F8D87807B7A7E8385837A6E64626B819CB5C1B99C7144231B31619DD5F7F7D59A5720050D34

6FAAD5E4D7B3855D44404E6781949C988E837C7A7D8284837E787373787F878C8C87817C7B7D

8184837C7168656C7E98B0BDB9A0784B281B2B5691CBF3FCE2AB682C0805245A96C8E2DFC298

6D4E42495D768B979891877F7B7D808383807B7775787D84888986817D7B7D8083827D746B68

6D7D94ACBAB8A37D522D1C264C85C0EEFEEDBC7B3B0E01164581B8DBE2CFA97E5B4747556C82

9196928A827D7D7F8283827E7A78797D82868785817D7C7D7F82827D766E6A6F7D92A8B7B7A4

8258321D234479B5E6FEF5CC8D4B17000B336CA6D1E2D9B990694F474F62778992928D857F7D

7E818382807D7B7B7D80838483807E7C7D7F81817D77706D717D90A5B4B5A6865D3720203C6E

A9DEFCFBD99F5D240303235893C4DEDFC7A27A5A4B4C596D808C918E88827E7E7F818382807E

7D7E7F8181817F7D7C7D7F81817D78726F727E8FA3B1B4A689623C231F36649DD4F8FEE4B06F

320A0016447EB3D7E1D2B28B68514B536376858E8F8B85807E7E808283828180807F7F7F7E7D

7C7C7D7F81807D787370747E8FA1AFB3A78C6741261F315A92C9F2FFEDBF814213000C336AA1

CBDFDAC19C775B4D4E5B6C7D898E8D88837F7E7F818384848382807F7D7C7B7A7B7D7F81807D

787371757F8FA1AEB2A78E6B46291F2D5287BFEAFEF4CD92531F030524568EBDDADECDAC8767

534D546374828B8D8B86817E7E808285878785827F7C7978787A7D8081807D78737276808FA1

AEB2A8906E4A2C202A4B7DB4E2FBF8D8A2642D0A0218447AADD1DFD6BC98755B4E4F5A6B7B87

8D8D89837F7D7E818588898885807B777576787C8082817D787372768090A1AEB2A992714D2F

21284574A9D9F7FAE1B1763C13030F33669AC4DBDCC9A98566524C536172818A8E8B86817D7D

8085898C8C88837C767373767A7F82827E787371758090A1AEB3AA947450322226406B9FD0F1

FAE8BE864C1F070A265387B5D4DED3B895735A4D4D58697A878D8D89837E7C7E83898E8F8C86

7D76717073787E82827F797370747F8FA1AFB4AC9777533423253C6496C6EAF8ECC9955D2C0E

081B4274A4C9DCDAC6A68264504A505F71818C8F8C857F7C7D82898F918F898076706E70767D

8283807A7371747E8EA0AEB4AD997A57382524385D8DBEE4F7F1D3A46C39140712336193BCD6

DCCFB39171594E4F5A6B7B878D8C87817D7C7F858B8F8E8A8279737071767C8183817C767375

7D8B9BA9B0AB9A7E5C3D2824345685B6DFF7F7DEB27B451B060A244F80ADCDDBD5BF9F7F6454

5158657582898B87827E7C7E82888C8C89837C767373777C8083817D7875767D8998A5ACA99A

8061422C2531507CAED9F5FBE8C08B53250905183E6E9DC2D7D8C8AD8D715D5457616F7C8589

88837F7D7D8085898A89847E797675787C8082827E7A77777D8795A1A8A7998264462F26304B

75A5D2F2FCEFCC9A62300E020E2F5C8CB5CFD8CFB89B7E675A585E6A7781868784807D7D7E82

85878784807B7877797C8082827F7B79797E87939EA5A49883674A33282F476E9DCAEDFDF5D7

A8713D150307214A7AA5C6D5D3C2A88B72625B5D66717C838584817E7D7D8082848584817D7B

7A7B7D808282807D7A7A7F87919BA2A19783694D362A2E436795C3E8FCF9E1B6804B1F060316

3A6895B9CFD4CAB4997F6B605E636C767E838482807E7D7E80818282817F7D7D7D7F81828280

7D7C7C808790999F9F95836B50392C2E41628DBBE1F9FCE9C28F592A0B010D2C5684ABC7D3CF

BEA68C7667606268717A808382817E7D7D7D7E8080807F7F7F8081828282807E7C7D81879098

9D9D94836C523C2F2F3F5D86B3DBF5FDEFCD9D68371303082046729CBCCED1C6B199816F6562

656D757C8082817F7D7C7B7C7D7E7E7F80818283848382807E7D7E828890979C9B92826C543E

302F3D5980ACD4F1FCF3D6AA77451D07051637618BAFC7D0CCBCA58E796B64646970787E8182

817E7C7A797A7B7C7E81838486868583807E7D7E828990979B9A91816C554032303C567BA5CD

EBFAF5DDB68553290D040F2A507AA1BDCDCFC4B19A84736864666C737A7F81817F7C7A787778

7A7D80848688888784817E7D7E838991979B9990816C554133303B53769FC6E6F7F6E3C09261

3515070B20416991B1C7CFCABBA7907C6D6564686E767C8182817D7A767475777B7F84888A8B

8985817E7D7E838A91989B9990806C554134313A517299C0E0F3F6E7C89E6F421F0C09183459

80A4BECCCEC4B29C87756963646A71797F82827F7A76737273787E84898D8D8B87837F7D7E82

8A92999C9A90806C55413430394F6E94BADAEFF5EACFA87C502B130A12294A7095B3C7CFCBBD

A9927E6E6562666D757D8182807B76716F70747B838A8F908E8A847F7C7D828992999D9A9181

6C56423431394D6B8FB4D5EBF4ECD5B2885C361A0C0E1F3C6085A6BECBCCC3B29C87756A6465

6B737A8082817D78737171747A81878C8E8D8A85807D7D81878F96999890826F5A463833394B

678AAFD1E9F5F1DDBD94683F200D0A1730517698B3C5CBC5B8A5907E7069676B71787E81827F

7B76737375797F85898C8C8985807E7D80858C9296958E82705D4A3C363B4B6586AACCE6F4F4

E4C79F744A2711091025436689A7BCC7C6BCAC9987786E6B6C70777C8082807D79767576797E

8387898A8884817E7D7F848A8F93928C81715F4D40393D4B6382A5C7E3F3F6EACFAA80553016

090B1B36587B9AB2C1C5BFB2A19080756F6E70757B7F81817F7C797777797D81858788868481

7E7E7F83888D908F8A80726150433C3F4B617FA1C3DFF2F7EED7B58B613A1C0B08142B4A6C8C

A7B9C1C0B7A898887C74717175797E8081807E7C7A797A7D808385858483807E7E7F82868A8D

8D887F726253463F414C607C9DBEDBEFF7F1DDBE976C45240F080E213D5D7E9AB0BCBFBAAEA0

91847A757375787C7F8181807E7D7C7C7D7F81828382817F7E7E7F8285898B8A867D71635549

42434D607A99BAD7ECF6F3E3C6A178502D15090B19314F6F8DA5B5BCBBB3A7998B8179767678

7B7E808181807F7E7E7E7F808181807F7E7D7E7F8184878988837C7063564B44454E607996B6

D2E9F4F4E7CDAB835B371C0C09132742617F99ACB7BAB6ACA093887F7977787A7D7F81828282

8180807F7F7F7F7E7D7D7C7D7F8184868786817A6F63564C464750607894B2CEE5F2F4EAD3B4

8E674225110A0F1F3753718CA2B1B8B7B1A79B8F857E7A78797B7E81838484838382817F7E7D

7C7B7B7B7C7E818486868480786E62564D484951617792AFCBE1EFF3EBD8BB98724D2E180D0D

192D47637F97A8B3B7B4ADA2978C837D7A797A7D8082848686858482807E7C7A7979797B7E81

838585837E766C61564E494A52617791ACC7DEECF2ECDCC2A17C583820110D14243B56718A9F

ADB4B5B1A99E9389817C7A7A7C7F82858788888784817E7B787776777A7D80838585827D756B

60554D4A4B53627790AAC4DAE9F0ECDEC7A8866343291710121E3149647D94A5B0B5B4AEA59A

90867F7B7A7B7D8185888A8B8987837F7A77757475787B7F838585827C74695E544D4A4C5463

778FA9C2D7E6EDEBDFCAAF8F6D4E331F14121A293E5770889CAAB3B5B3ACA2978C837D7A7A7C

8084888C8D8C8985807B76737273767A7E828585827C73685D534C494C5463778EA7C0D4E3EB

EAE0CDB49777583C2719131722344B637C91A2AEB4B4AFA79C9188807B7A7B7E83878B8D8D8A

86817C7774727375797D818484827C746A6057504D4F5764778DA5BDD2E2EBEBE3D3BB9F7F60

442C1C14141D2C4158708698A6AEB0AEA79E948B837E7B7B7D8185888B8B8A87827E79767474

76797D818384827D766D635A5451525966778CA4BBD0E0EAECE6D7C2A788694B332015131825

374D647A8E9DA7ACACA7A0978E86807D7C7D80838688898986837F7B787676777A7D80828381

7D776F665E5855565C68788CA2B9CDDEE9ECE8DBC7AE9071543A251813151F2F43596F83939F

A6A8A6A1999189837F7D7D7F81848687878683807D7A7878787A7D7F8182817D787069615C59

5A606A798CA1B7CBDCE7ECE9DECCB4987A5C412B1C14141B283A4E64788997A0A4A4A09A938C

86817E7D7E80828485868583817E7C7A797A7B7D7F8181807D78726B645F5D5E636D7B8CA1B5

C9DAE5EBE9E0D0BA9F8265493221171418223245596D7F8D989EA19F9B958F8984807E7E7F80

8283848382817F7D7C7B7C7D7E8081817F7C78736C67626061666F7D8DA0B4C7D7E3EAE9E2D3

BFA68A6D523A271A15161E2B3C4F62748490989C9D9B96918B8682807E7E7F8081828281817F

7E7E7D7D7E7F8081807F7C78736E696563656A727F8FA0B3C5D5E1E8E9E2D6C3AC91755A422E

1F17161B263445586A7A8791979A9997938E8985817F7E7E7E7F7F808080807F7F7F7F808181

81807F7C78736F6A6766686D758190A1B3C4D3DFE6E7E3D7C6B1987D624A35251B171A222E3D

4E5F6F7E899196979694908B8783807E7D7D7D7D7E7E7F7F8080818182828282817F7C78746F

6C69696B70788492A2B3C3D1DDE4E6E2D8C9B59D846A523D2C201A1A1F283645556574808A90

949594918D8985827F7D7C7B7B7C7D7D7F8081828384848483817F7B7874706D6B6B6E737B86

94A3B3C2D0DBE2E4E1D8CAB8A28A725A4533261E1B1E252F3D4C5B6A77828A909393928F8C88

84807D7B7A797A7A7C7D7F81838485868584827F7B7773706D6C6D70767E8996A5B3C2CFD9E0

E2DFD8CBBBA69079624D3B2D231E1E222B364352606E7A848B909292918E8A86827E7B797878

787A7C7E8184868788878683807C7773706D6D6E7278818C98A6B4C2CED8DEE0DDD7CBBCAA95

7F6A55433429221F2127303C495764717C858C909292908C88847F7B78767676787A7D818487

8989898785817C7873706D6D6F737A838E9BA8B6C3CED6DCDEDBD5CBBDAC9985705D4B3C2F27

2222252C35414E5B68747E878D9092918E8A85817C7976757576797C808386898A8A8886827D

7974716F6F70757B848F9BA8B5C1CCD5DADCDBD5CCBFAF9D8A76635141342A2523242A323C48

55616D7881888C8E8E8D8A86827E7A78767677797C7F82858789898885827E7A777472717377

7D858F9BA7B4C0CAD3D9DBDAD6CDC1B3A28F7C695746392E272424282F38434F5B67727B8288

8B8C8B8986837F7C79787778797B7E81848687878785827F7C7976747476797F87909BA7B2BE

C8D1D7DAD9D5CEC3B6A594816E5C4C3E332B2625282D353F4A55616B757D8387898988868380

7D7B7979797A7B7E8082848686868482807D7A787777787C8188919BA6B1BCC6CED4D8D8D5CE

C4B8A9988674625243382F2927282C333B45505B656F777E828587878583817F7C7B7A7A7A7C

7D7F81838485858482807E7C7A79797B7E838A929CA6B0BBC4CCD2D6D6D4CEC5B9AB9B8A7968

58493D332D2A292C3138414B555F6971787E818485848382807E7C7B7B7B7C7E7F8182838383

8382807E7D7B7B7B7D80858C939CA6B0B9C2CAD0D3D4D2CDC5BAAD9F8E7E6D5D4F4238312D2B

2D30363E47505A636B73797D8082838382807F7E7D7D7D7D7E7F80818282828281807E7D7D7D

7D7F83878D959DA6AFB8C1C8CDD1D2D0CCC5BBAFA19282726355483E36312E2E31353C434C55

5E666D74797D7F81818181807F7E7E7E7E7E7F808081818180807F7E7E7E7E7F82858A8F969E

A6AFB7BFC6CBCECFCECAC3BBB0A3958677685A4E433B35313032353A4148505860686E74787C

7E8081818180807F7F7F7F7F7F808080807F7F7E7E7E7E7F8183878C91989FA7AFB6BDC4C8CB

CCCBC8C2BAB0A4978A7B6D605449413A36333336393F454C545B62696F74787C7E8081818181

81818080807F7F7F7F7E7E7E7D7D7E7E808285898E9399A0A7AFB6BCC2C6C9C9C8C5C0B9B0A5

998C7F72665A4F463F3A373637393D43494F565D646A7074787C7E808182828282828181807F

7E7E7D7D7C7C7D7D7E8083868A8F959BA2A8AFB5BBC0C4C6C7C5C2BEB7AFA59A8F83766B5F55

4C453F3C3A393A3D41464C52585F656B7075797C7F8182838484838281807F7E7D7C7B7B7B7C

7D7E8184878C91979DA3A9AFB5BABEC2C3C4C2BFBBB5ADA59B90857A6F655B534B45413E3C3C

3E4044494E545A60666C71767A7E808284858585848381807E7D7B7A7A7A7A7C7E8084888D92

989EA4AAB0B5BABDC0C1C1BFBCB8B2ABA39B91877D746A6159514B4642403F3F4043464B5055

5B61676D72777C7F8284868686858482807E7C7B7A7979797B7D8084888D92989EA4AAAFB4B8

BBBDBEBEBCB9B5B0AAA39B928980776E655D56504B474442424345484C50555B61666C71767B

7E8183858586858482817F7D7C7A7A797A7B7D7F83878B90969BA1A6ABB0B4B7B9BABAB9B7B3

AFA9A39B938B827A7169625B544F4B48474646484A4E52575C61666C71757A7D808284858585

8483817F7E7C7B7A7A7A7B7D7F82858A8E93989DA2A7ABAFB2B5B6B6B5B4B1ADA8A29B948C84

7C746D665F5954504D4B4A4A4B4D5054585D61666B7075797C7F8183848484848381807E7D7C

7B7B7B7B7D7F8184888C91959A9FA3A7ABAEB0B2B2B2B0AEAAA6A19B948D867F777069635D59

55524F4E4E4F5153565A5E62676B7074787B7E8082838484838281807F7E7C7C7B7B7C7D7F81

83878A8E93979B9FA3A6A9ACADAEADACAAA7A49F9A948E87817A736D67625D59565453525354

56595C6064686C7074777A7D7F81828383838281807F7E7D7C7C7C7C7D7F808386898C909498

9B9FA2A5A7A8A9A9A8A7A4A19D99938E88827C76706B66625E5B59585757585A5C5F6265696C

7074777A7C7E80818282828281807F7F7E7D7D7D7D7E7F808285878A8E9194989B9EA0A2A4A5

A5A4A3A19E9B97928E89837E79736F6A6663605E5C5C5C5C5E5F6264676A6D717477797C7E7F

80818282818180807F7E7E7D7D7D7E7F80828486898C8E9194979A9C9E9FA0A0A09F9D9B9895

918D89847F7B76726E6A6765636161606162636567696C6F717477797B7D7E80808181818180

807F7F7E7E7E7E7E7F80828385878A8C8F91939597999A9B9B9B9A999795928F8C8884807C79

75726F6C6A68666665656667686A6C6E70737577797B7C7E7F808080808080807F7F7F7F7E7F

7F808081838486888A8C8E9091939495969696969593928F8D8A8784817E7B787572706E6D6B

6B6A6A6A6B6C6D6F7172747677797B7C7D7E7F7F80808080807F7F7F7F7F7F80808182838485

8688898B8C8E8F909191919191908F8E8C8A888684817F7D7A787674737170706F6F6F707071

727374767778797B7C7D7D7E7E7F7F7F7F7F7F7F7F7F80808081818282838485868788898A8B

8C8C8C8C8C8C8C8B8A898786848381807E7C7B7978777675757474747475757676777878797A

7B7C7C7D7D7E7E7E7F7F7F7F7F80808080818182828283848485858686878787888888878787

8686858483828281807F7E7D7C7C7B7A7A7A79797979797979797A7A7A7B7B7B7C7C7C7D7D7D

7E7E7E7F7F7F8080818181828282838383838384848484848383838383828282818181818080

80807F7F7F7F7F7F7E7E7E7E7E7E7E7D7D7D7D7D7D7D7C7C7C7C7C7C7D7D7D7D7E7E7E7F7F80

8081818182828282828282828281818180807F7F7F7E7E7E7E7E7E7E7E7E7E7F7F7F80808181

81828282828282828281818080807F7F7E7E7D7D7D7D7D7D7D7D7E7E7F7F8080818181828282

8282818181807F7F7E7D7C7C7B7B7A7A7A7A7A7A7A7B7C7C7D7E7F8081828384858586868686

868685858483838281807F7F7E7E7D7D7D7D7D7E7E7E7F8080818181828282828181807F7E7E

7C7B7A797877777676757576767778797A7C7D7F808284858688898A8A8B8B8B8A8A89888786

85848281807F7F7E7D7D7D7D7D7E7E7F7F808081818282828181807F7E7D7C7B797876757473

727271717272737476787A7C7E80828487888A8C8D8E8E8F8F8E8E8D8C8B8988868583828180

7F7E7D7D7D7D7E7E7F7F808081818282828181807F7D7C7A7977757472706F6E6E6D6D6E6E70

717375777A7D7F8285888A8C8E9091929393939291908E8D8B8987858482817F7F7E7D7D7D7D

7E7E7F8080818182828281807F7E7D7B79777573716F6D6C6B6A69696A6A6C6D707275787B7F

8285898C8E9193959697979796959492908E8C8A88868482807F7E7E7D7D7D7E7E7F7F808181

82828281807F7E7C7A787673716F6C6A69676665656667686A6C6F7276797D8185898D909395

98999A9B9B9A99989694928F8D8A88858382807F7E7D7D7D7D7E7F7F80818182828281807F7E

7C7A7775726F6D6A68666463626162636466696C6F73777C8085898D9195989A9C9E9E9E9E9D

9C9A989592908D8A878583817F7E7E7D7D7D7E7E7F80818182828281807F7D7C797774716E6B

686563615F5E5E5E5F606265696C71757A7F84898E92969A9D9FA1A2A2A2A1A09E9B9996938F

8C89878482807F7E7D7D7D7E7E7F80808182828281807F7D7B797673706D696663605E5C5B5A

5A5B5D5F6265696E73787E83888E93979B9FA1A4A5A6A5A5A3A19F9C9996928F8B888683817F

7E7D7D7D7D7E7F7F808181828281807F7D7B7976736F6C6865615E5C5A58575758595B5E6266

6B70767C82888D93989CA0A4A6A8A9A9A8A7A5A29F9C9995918E8A878482807F7E7D7D7D7E7E

7F808181828281817F7E7B7976726F6B6763605C59575554545456585B5E63686E747A80878D

93989DA2A5A8AAACACACAAA8A6A39F9C9894908C898683817F7E7D7D7D7E7E7F808181828281

817F7E7C7976726E6A66625E5B5755535151515254575B60656B71787E858C92989EA3A7AAAD

AEAFAEADABA8A5A29E9A95918E8A878482807F7E7D7D7E7E7F80808181818181807E7C7A7774

706C6864605C59565351504F505154575C61676E757C848B92999FA4A8ACAEAFB0AFAEABA8A5

A19D9995918D8A878482807F7E7E7E7E7E7F7F808081818180807F7D7B7976736F6C68635F5B

5754514F4E4E4F5154585E646A727A828A92999FA5AAADB0B1B1B0AEACA8A5A09C9894908C89

86848281807F7F7F7F7F7F7F8080808080807F7F7E7C7A7875726F6B67625E5A5652504E4D4D

4E51555A60676F77808891989FA6ABAEB1B2B2B1AFACA8A4A09B97938F8B888684828180807F

7F7F7F7F7F7F808080807F7F7F7E7D7C7A7875726E6A65615C5854504E4C4C4C4E52575D646C

747D868F989FA6ABAFB2B3B3B2B0ADA9A49F9B96928E8A878583828180808080808080807F7F

7F7F7F7F7F7F7E7E7D7B7A7775716D69645F5A56524E4C4B4B4C4F53596068717B848E969FA6

ACB0B3B5B5B3B1ADA9A49F9A95918D89868483828181808080808080807F7F7F7F7E7E7E7E7E

7E7E7D7C7A7774716C67625D58534F4C4A494A4C50565D656E78828C959EA5ACB1B4B6B6B4B1

AEA9A49F99948F8B8885838281818181818181818180807F7F7E7E7E7E7E7E7E7E7E7D7C7A77

74706B66605B56514D4A49494A4E5359616B747F89939CA5ACB1B4B6B6B5B2AEA9A49E99938E

8A8784828180808081818181818181807F7F7E7D7D7D7E7E7E7F7F7F7E7C7A77736F69645E58

534E4B4848494B50565E67717C87919BA4ABB1B5B7B7B6B3AFAAA49E98928D89858381807F80

8081818282828281807F7E7E7D7D7D7D7E7E7F7F807F7E7D7A77726D67615B55504C49474749

4D535B646E79848F99A2AAB0B5B7B8B7B4B0AAA49E98928C888481807F7E7F80808182828382

8281807F7E7D7C7C7C7D7E7F808181807F7D7A76716B655E58524D494747484B5158616B7681

8C97A1A9B0B5B7B8B7B4B0ABA59E97918B8783807E7D7D7E7F8081828383838281807F7E7D7C

7C7C7D7E7F8081828281807D79756F69625B554F4B4846474A4E555E67727E89949FA8AFB4B7

B9B8B5B1ABA59E97908B85817E7D7C7C7D7E8081828384838382817F7E7C7C7B7B7C7D7E8082

83838382807D78736D665F58524D494746484C535B646F7B86929CA6ADB3B7B9B8B5B1ACA59E

97908A84807D7B7A7B7C7D7F81828384848382817F7E7C7B7B7B7B7C7E80828385858583807C

77716A635B554F4A4746474B5058616C77838F9AA4ACB2B6B8B8B6B2ACA59E979089837F7C7A

79797A7C7E8082838484848382807E7D7C7B7B7B7C7E8081838586868583807B756F67605952

4D494646494E545D6874808C98A2ABB2B6B9B8B6B1ACA59D958E88827E7B7979797A7C7D7F81

828383838281807F7E7D7C7C7C7D7E7F81838486868685827F7A746D655E56504B4746474B51

5A64707C8996A1AAB2B6B9B8B6B1ABA49C948D86817D7A7978797A7B7D7F8081828282828180

7F7E7D7D7D7D7D7E7F8182848587878685827E79726B635B544D494646494E56606C7986939F

A9B1B6B9B9B6B1ABA39B938B85807C79787878797B7D7E8081818282818180807F7E7E7D7D7E

7E7F808283858687888785827D7770686058514B4746474B525C687582909DA7B0B6B9B9B6B1

AAA29A928A837E7A78777778797B7C7E7F80808181818080807F7F7F7E7E7E7F7F8081838486

8788888785817C766E655D554E49464649505864717F8D9AA5AFB5B8B9B6B1AAA2999189827D

7977767677797A7C7D7F7F8080808080807F7F7F7F7F7F7F7F7F808182848687898A8A888581

7B736B6259524B4746484D55606D7B8997A3ADB4B8B9B6B1AAA2989087807B7775747576787A

7C7D7E7F7F7F7F7F7F7F7F7F80808080808080808182838587898A8B8B8985807971685E564E

4946474B525C69778594A0ABB3B7B8B6B1AAA1988F867F797573737475777A7B7D7E7E7F7E7E

7E7E7E7F7F80808181818180808181838486898B8C8D8C89857E766D645A524C48474A505965

7381909DA9B1B6B8B6B1AAA1978E857D77747271727477797B7D7E7E7E7E7E7D7D7E7E7F8081

8182828181818181828486888B8D8E8E8D89837C736960564F4A47494E56616F7D8C9AA6AFB5

B7B6B1AAA1978D847C76727070717376787B7D7E7E7E7D7D7D7C7D7D7F808182828282828181

81828385888A8D8F90908D8882796F655B534C49484C535E6B798897A3ADB4B6B6B1AAA1978D

837B74706E6E6F7275787A7C7E7E7E7D7C7C7C7C7D7E7F818283838383828181818284878A8D

909292918D877F756B60574F4A494B515B67758493A0AAB2B5B5B1AAA1978C8279736E6C6C6D

7074777A7C7D7E7E7D7C7B7B7B7C7D7F81828384848383828181828386898D90939494918C84

7B71665C534D4A4B50586471808F9CA8B0B4B4B1AAA2978C8278716C6A6A6C6F7276797C7D7E

7E7D7C7B7A7A7B7C7E80828485858483828181818285888C9093969694908A81776C6158504C

4B4F56606D7C8B99A4ADB2B3B1AAA2978C8178706B68686A6D7175797C7D7E7E7D7C7A7A797A

7C7D80828485858584838281818284878B8F93969797948E867D72675C544E4C4E545D6A7887

95A2ABB1B3B1ABA2988C8178706B68686A6D7175797C7E7E7E7D7C7B7B7A7B7C7D7F81838484

848483828180818285888C9094969795918B82786C6157504C4C5159657483929FAAB1B3B1AB

A3988D8178706B68686A6E7276797C7E7F7F7E7D7C7B7B7B7C7D7F8082838383838281818080

818386898D91949696948F877D72665C534E4C4F56616F7F8E9DA8B0B3B2ACA3998D8278706B

69696B6E72767A7D7E7F7F7F7E7D7C7C7C7D7E7F808182828382828180807F808183868A8E92

959695928B83786C6157504C4D535D6B7A8A99A6AEB2B2ADA4998E8278706B69696B6F73777B

7D7F80807F7E7E7D7D7D7E7E7F7F8081818282818180807F7F808184878B90939696948F887E

72665B524D4D515A67768696A3ADB2B2ADA59A8E8278706B69696B6F74787B7E7F8080807F7E

7E7E7E7E7F7F7F80808081818180807F7F7F7F808285888D91959696938C83786C60564F4D4F

5763718292A0ABB1B2AEA69B8F8378706A68696C7074797C7F808181807F7F7F7F7F7F7F7F7F

7F7F7F80808080807F7F7E7E7E8082858A8F9396979590887E72655A524E4F545F6D7D8E9DA8

AFB1AEA79C908378706A68686B7075797D808181818180807F7F80808080807F7F7F7F7F7F7F

7F7F7F7E7D7D7E8083878C91959797948D83786B5F56504E535C69798999A5ADB0AEA79D9184

79706A67686B70757A7E81828282818080808081818181807F7F7E7E7E7E7F7F7F7E7E7D7C7C

7D8084898E9397989691897E71655A524F515965748595A2ABAFAEA89E928579706967676B70

757A7F8283838382818080818182828181807F7E7D7D7D7E7E7E7E7E7D7C7B7C7D81868B9196

9898958E83776A5E55515157627080909FA9AEAEA89F938679706966676A6F757B7F83848484

82818181818282838281807F7D7D7C7C7D7D7E7E7E7D7B7A7A7B7E82888E9498999892897D70

64595351555F6C7C8C9BA6ACADA9A094877A70696566696F757B808385858483828181818283

838382817F7D7C7B7B7C7D7D7E7D7C7B7A79797B7F858B92979A9A968E8376695E5653555C68

778897A3AAACA9A095887B70686565686E747B81848686868483828182838484848382807E7C

7B7B7B7C7D7D7D7D7B797878797C81888F959A9B9992897C6F635A55555B657383929FA8ABA8

A196897C71686464676D747B81858788878583828282838485858483807E7C7A7A7A7B7C7D7D

7D7B797877777A7E858C93999B9B968E8275685E575559626F7F8E9CA5A9A8A2978A7D716964

64676C737B81858888878583828282828384858483817F7D7B7A7A7B7C7D7D7D7C7A79777778

7C81888F959A9B9892877B6D625955575F6B7A8A99A4A9A9A3998C7F736A6564676D747B8185

8788878583828181828383848382817F7E7C7B7B7C7C7D7E7E7D7B7A7877787A7E848B92979A

9A958C8073665C56565C67768695A1A8A9A49A8E80746B6665676D747B818587878785838281

8181828383838281807E7D7C7C7C7D7D7E7E7E7C7B797877797C81878E94999A979085786B5F

58565A637282929FA7A9A59C9082766C6665686D747B81858787868583828181818182828282

81807F7E7D7D7D7D7E7E7E7E7D7C7A7978787A7D838A91979A99938A7E70645A5658606D7D8E

9CA5A9A69E9184776D6765686D747B8185878786858381818080818181818180807F7F7E7E7E

7E7E7E7F7F7E7D7B7A7877787B80868D949899968F8376695E58575E69798998A3A8A69F9386

796E6765686D747B8185878786848381808080808181808080807F7F7F7F7F7E7E7F7F7F7F7E

7D7B797777797C82899096999892887B6E625A575C66748594A0A7A6A095887A6F6866686D74

7B8286888886848281808080808080807F7F7F7F8080807F7F7F7F7F7F7F7F7E7C7A7877777A

7E858D939899958D8173665D585A637080909DA5A6A1978A7C716966676D747B828688888784

8281807F7F80807F7F7F7F7F7F8080808080807F7F7F807F7F7D7B797776777B818990969997

9186796B605A5A606C7C8C9AA3A6A2988C7E726A66676C747B82878989878482807F7F7F7F7F

7F7E7E7E7E7F8080818181808080808080807E7C7A777676787D858D949898948B7E71645C5A

5F69788896A0A5A29A8E80736A66676C737B82878A89888582807F7F7F7F7F7F7E7D7D7D7E7F

80818282818080808080807F7E7B787675767A8189919799968F8376695F5B5D667483929EA3

A29B8F82756B67676B737B83888A8A888582807F7E7E7F7F7E7E7D7C7D7D7F80828282828180

80808181807F7C79767474777D848D94989892887C6E635D5D64707F8E9AA1A29C9184776D67

666B727B83888B8B898682807E7E7E7E7F7E7D7C7C7C7D7E808283838382818080818181807E

7A77747374798089919799958D817468605E626D7B8A979FA19C9386796E67666A717A82898C

8C8A8783807E7D7E7E7E7E7D7C7B7B7C7D808283848483828181818182817F7C78747272767C

858E9599979186796C635F616A7786939CA09D94887A6F686669707982898C8D8B8783807E7D

7D7E7E7E7D7C7B7B7C7D7F818384848382818181818282807E7A7673727479818A929798938A

7E71666060677382909B9F9E968A7D71696769707881888C8C8A8783807E7D7D7E7E7E7E7D7C

7C7C7D7F808283838382818181818282817F7C78757373777D868E9598958E8375696160656F

7E8C989F9E988C7F736B67696F7880878B8C8A8783807E7D7D7E7E7E7E7D7D7C7C7D7E808182

82828281818081818282807E7A777473757A828A92979791877A6D6460636C7A89959D9F998F

81756C68696F777F868A8B8A8783807E7D7D7E7E7E7E7E7D7D7D7E7E7F808182828181808081

818282817F7C79767474787E868F9597938B7F72676161697685929C9F9A9184776D69696E76

7F868A8B8A8783807E7D7D7E7E7F7F7E7E7E7E7E7F7F80808181818180808081818282817E7B

777574767B828B9296958F84776B63616672808F999E9B9386796F69696E767E858A8B8A8683

807E7D7D7E7E7F7F7F7E7E7E7F7F7F8080808080808080808081828282807D7A767475787F87

8F959691887B6F6561656E7C8B979D9C94897C716A696D757D85898B8986837F7D7D7D7E7E7F

7F7F7F7F7F7F7F7F7F7F808080808080808081818282817F7C787574767B838B9295938C8073

6863646C7887949B9C968B7E736B6A6D747D84898B8A86827F7D7C7D7D7E7F7F7F7F7F7F8080

807F7F7F7F7F80808080808081828382817E7A767475787F889094948F84786C656369758390

999C978D80756D6A6D737C84898B8A86827F7D7C7C7D7E7F7F7F7F7F80808080807F7F7E7F7F

7F808080808182838382807C787574767C848C939591887C70676468717F8D979B988F83776E

6A6C737B83898B8A87827F7C7C7C7D7E7F7F7F7F8080818181807F7E7E7E7E7F7F8080808081

838383827E7A7674747980899094938C81756A65676F7B89949A989185796F6B6C727A83898B

8B87837E7C7B7C7D7E7F7F7F7F8080818281817F7E7D7D7E7E7F808080808182848483807C77

7473767C858D93938F85796E67666D788591989892877B716C6C717982898C8B88837E7B7A7B

7C7E7F7F7F7F808181828281807E7D7D7D7E7F7F8080808182838584827E7975737479818A91

9391897E726A676B75828E969893897D736D6C707881888C8C88837F7B7A7A7C7D7F7F7F7F80

8182828382807E7D7C7C7D7E7F7F7F80808183858584807C777373767D868E93928C82766D68

6A727E8A9397938B7F756E6C707780888C8C89847F7B797A7B7D7F7F7F7F808182838382817F

7D7C7C7D7E7F7F7F7F808182848585827E797472747A828B91928E867A706969707B87919694

8D82776F6C6F767F878B8C89847F7C7A7A7B7D7F7F8080808081828282817F7E7D7D7D7E7F7F

7F7F7F808183858583807B767374787F878F9290897E736B696D77848F95958F8479706D6F75

7E858A8C8985807C7A7A7B7D7F7F808080808181828281807F7E7D7D7E7E7F7F7F7F80818284

8584827D797574767C848C91918C82776D696C74808C949590867B726E6F747C848A8B898580

7D7B7A7C7D7F7F808080808081818181807F7E7E7E7E7E7F7F7F7F7F8081838484837F7B7774

757981898F918E857A706A6B727D89929592897E746E6E737B83898B8985817D7B7B7C7D7F80

808080808081818181807F7F7E7E7E7E7F7F7F7F7F7F8082838484817D797574777D858D918F

897E746C6A6F7A869094928B80766F6E737A82888A8985817D7B7B7C7D7F8080808080808080

8080807F7F7F7F7E7F7F7F7F7F7F7F8081828484837F7B7775767B828A8F908B82776E6B6E77

828D93938C8278716F727981878A8986817D7B7B7C7E7F80808080808080808080807F7F7F7F

7F7F7F7F7F7F7F7F7F8081838484817D797675787F878D908D857B716C6D747F8A92938E847A

726F727880868A8986817D7B7B7C7E7F8080808080808080807F7F7F7F80807F7F7F7F7F7F7F

7E7F7F81828484837F7B7775777C848B8F8E887E746D6C727C8790938F867C747071777F8689

8986827D7B7B7C7E7F80808080808080807F7F7F7F7F808080807F7F7F7F7F7E7E7F80818384

84817D7976767A80888E8F8A8278706D7079848E9290887E757171767E85898986827E7B7A7C

7E7F808181808080807F7F7F7F7F7F80808080807F7F7F7F7E7E7E7F80828484837F7B777578

7D858B8E8C857B726E6F77818B91908A80777271767D84898987827E7B7A7B7D7F8181818080

80807F7F7E7E7E7F80818180807F7F7F7F7E7E7E7E7F81838584817D7876767B82898D8D877E

756F6F757E888F908B82797371757C83888987837E7B7A7B7D7F818181818080807F7F7E7E7E

7F8081818180807F7F7F7E7E7E7E7E80838585837F7A7676797F868C8D898278716F737C868D

8F8C847B7472747B82878988837E7B7A7B7D7F81828181808080807F7E7D7D7E7F8181818180

7F7F7F7E7E7D7D7E7F82848584817C7875777C838A8D8B847C74707279838B8F8D867D757274

7A81878988847F7B797A7C7F81828281808080807F7E7D7D7E7F8081828180807F7F7F7E7E7D

7D7E81838585837E7976767A80878C8C877F7671727780898E8D877F77737479808689888480

7B7A7A7C7F81828281808080807F7E7E7D7E7F8081818180807F7F7F7E7E7D7D7E8082848584

807B7776787E858A8C8981797371757E878D8D8981797473787E85888885807C7A7A7C7F8081

8181808080807F7F7E7E7E7F8080818181807F7F7F7F7E7E7D7E7F81838584827D7977777C82

888B8A847C7471747B848B8D8A837A7574777D84888885817D7A7A7C7E80818181808080807F

7F7E7E7E7F7F8081818080807F7F7F7F7E7E7E7E80828484837F7B78777A80868B8B867E7772

737982898D8B847C7674767C82878886817D7B7B7C7E80818181808080807F7F7F7E7E7F7F80

80808080807F7F7F7F7F7E7E7E7F81838484817D7977797E84898B8881797373777F878C8B86

7E7774767B81868886827E7B7B7C7E8081818180807F7F7F7F7F7F7F7F7F808080808080807F

7F7F7F7E7E7E7E80828484827F7B78787C81878A89837B7573767D858B8C87807975767A8085

8786827E7C7B7C7E8081818180807F7F7F7F7F7F7F7F7F7F80808080808080807F7F7F7E7E7E

7F81838483807C79787A7F858989857E7773757B83898B88827A7675797F848786837F7C7B7C

7E80818181807F7F7F7F7F7F7F7F7F7F7F7F7F808080808080807F7F7F7E7E7E80828384827E

7A78797D83888987807975747981888B89837C7776797E838686837F7C7B7C7E80818181807F

7F7F7F7F7F7F7F80807F7F7F7F7F8080808080807F7F7E7E7E7F81838483807C79797B818689

88827C7675787F868A89857E7876787D83868683807C7B7C7E80818181807F7F7F7F7F7F7F80

8080807F7F7F7F7F8080808080807F7F7E7E7E80828383817E7A797A7F848888847E7875777D

848989867F7976787C82858684807D7B7C7E80818181807F7F7F7F7F7F7F808080807F7F7F7F

7F808080808080807F7E7D7E7F818384827F7B79797D82868886807A76767B82878986817B77

787C81858684817D7B7C7D80818281807F7F7F7F7F7F7F80808080807F7F7F7F7F8080808080

807F7E7E7D7E80828483817D7A797B80858786827C77767A80868887827C78787B8084868481

7D7B7B7D7F818281807F7F7F7F7F7F7F80808080807F7E7E7F7F808080808080807F7E7D7D7F

818384827F7B797A7E838787837E7977797E848887837D79787A7F838585817E7C7B7D7F8182

81807F7F7F7F7F7F7F80808181807F7E7E7E7F7F8080808080807F7E7D7D7E80838483807C7A

7A7D81858785807B78797D828787847F7A787A7E838585827E7C7B7D7F818281817F7F7F7F7F

7F7F7F808081807F7F7E7E7F7F808080808080807F7E7D7E7F828383817E7B7A7C8084868581

7C78787C81868785807B797A7D828585827F7C7C7D7F81828181807F7F7F7F7F7F7F80808080

807F7F7E7F7F808080808080807F7E7D7D7F818283827F7C7A7B7E828686837E79787A7F8487

85817C79797C81848583807D7C7C7E80818181807F7F7F7F7F7F7F80808080807F7F7F7F7F7F

8080808080807F7F7E7D7E80828382807D7B7B7D818486847F7B787A7E838686827D7A797C80

838483807D7C7D7E80818181807F7F7F7F7F7F7F80808080807F7F7F7F7F7F80808080808080

7F7E7E7E7F818283817E7C7B7C80838584817C79797D828586837F7B7A7B7F828483817E7C7D

7E80818181807F7F7F7F7F7F7F7F808080807F7F7F7F7F7F7F8080808080807F7F7E7E7F8082

82827F7D7B7C7E828585827E7A797C80848684807C7A7B7E828483817E7D7D7E80818181807F

7F7F7F7F7F7F7F808080807F7F7F7F7F7F7F7F7F80808080807F7E7E7E7F818282807E7C7B7D

818485837F7B7A7B7F838584817D7A7B7E818383817F7D7D7E7F818180807F7F7F7F7F7F7F7F

808080807F7F7F7F7F7F7F7F7F7F808080807F7F7E7E7F808282817F7D7C7D7F838483807C7A

7B7E828584817E7B7B7D808383827F7D7D7E7F808180807F7F7F7F7F7F8080807F7F7F7F7F7F

7F7F7F7F7F7F7F7F808080807F7E7E7E7F818282807D7C7C7E818484817E7B7B7D818484827F

7C7B7D80828382807E7D7E7F808181807F7F7F7F7F808080807F7F7F7F7F7F80807F7F7F7F7F

7F808080807F7F7E7E7F808182817E7D7C7E808384827F7C7B7C808384837F7C7B7C7F828382

807E7D7E7F808181807F7F7F7F7F808080807F7F7F7F7F7F8080807F7F7F7F7F7F808080807F

7E7E7E808182817F7D7C7D7F828382807D7B7C7F828483807D7C7C7F818282807E7D7E7F8081

81807F7F7F7F7F80808080807F7F7F7F7F8080807F7F7F7F7F7F808080807F7F7E7E7F808181

807E7D7D7E818383817E7C7C7E818383817E7C7C7E818282807F7D7E7F808181807F7F7F7F7F

80808080807F7F7F7F7F808080807F7F7F7F7F7F808080807F7E7E7F808181817F7D7D7E8082

83817F7D7C7E808283817F7D7C7E808282817F7E7E7F808181807F7F7F7F7F80808080807F7F

7F7F7F808080807F7F7F7F7F7F808080807F7F7E7E7F818181807E7D7D7F818282807D7C7D7F

8282817F7D7D7E808182817F7E7E7E808181807F7F7F7F7F80808080807F7F7F7F7F80808080

7F7F7F7F7F7F7F808080807F7E7E7F808181807F7D7D7F818282807E7D7D7F818282807E7D7D

7F8182817F7E7E7E7F8081807F7F7F7F7F7F808080807F7F7F7F7F7F808080807F7F7F7F7F7F

808080807F7F7E7F808181807F7E7D7E808182817F7D7D7E808282807E7D7D7F808181807E7E

7E7F808080807F7F7F7F7F808080807F7F7F7F7F7F808080807F7F7F7F7F7F7F8080807F7F7E

7F7F808181807E7E7E7F8182817F7E7D7E808182817F7E7D7F808181807F7E7E7F808080807F

7F7F7F7F808080807F7F7F7F7F7F7F8080807F7F7F7F7F7F7F808080807F7F7F7F808081807F

7E7E7F808181807E7D7E7F8181817F7E7E7E808181807F7E7E7F808080807F7F7F7F7F808080

807F7F7F7F7F7F7F8080807F7F7F7F7F7F7F7F8080807F7F7F7F7F8080807F7E7E7F80818180

7F7E7E7F808181807E7E7E7F8081807F7F7E7F808080807F7F7F7F7F8080807F7F7F7F7F7F7F

7F7F807F7F7F7F7F7F7F7F7F808080807F7F7F7F808080807F7E7E7F8081807F7E7E7F808181

807F7E7E7F8081807F7F7F7F7F8080807F7F7F7F7F80807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F8080807F7F7F7F808080807F7E7E7F808180807F7E7F808081807F7E7E7F8080

80807F7F7F7F8080807F7F7F7F7F80807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80

80807F7F7F7F7F8080807F7F7F7F808080807F7E7F7F8080807F7F7E7F808080807F7F7F7F80

80807F7F7F7F7F80807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080807F7F7F7F

808080807F7F7F7F8080807F7F7F7F808080807F7F7F7F8080807F7F7F7F8080807F7F7F7F7F

7F807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80807F7F7F7F7F8080807F7F7F

7F8080807F7F7F7F808080807F7F7F7F8080807F7F7F7F8080807F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80807F7F7F7F7F8080807F7F7F7F808080807F7F

7F7F8080807F7F7F7F8080807F7F7F7F7F80807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80807F7F7F7F7F8080807F7F7F7F8080807F7F

7F7F7F80807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F

pop

% End of sampled sound

% End of Graphics

MathPictureEnd


\
\>"], "Sound",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oo`008@0000000`00
Oomoo`3oOolMOol100000003001oogoo02Qoo`04001oo`000004Ool900000goo0000000;00000goo
000000060005Ool00`00Oomoo`34Ool100000003001oogoo02Aoo`H0009ooaT00003Ool0000000L0
0003Ool0000000<00003Ool0000000D0009oo`800;]oo`40000000<007ooOol07Woo4`0000=oo`00
00007`000Woo0P000Woo00<007oo00003@00/goo0@0000000`00Oomoo`0JOol200000goo00000007
000017oo000007oo0`0000=oo`0000000`000Woo2`0000=oo`0000000P0000=oo`000000;000Z7oo
0@0000000`00Oomoo`0HOolV00001Goo00000000Ool00P0000=oo`0000007P0000Aoo`00001oo`80
0005Ool00000001oo`0=002NOol100000003001oogoo01AoocL0009oo`800003Ool0000003H009Ao
o`40000000<007ooOol047oo6@0000=oo`0000002@0000=oo`0000001P0000=oo`000000D000Rgoo
0@0000000`00Oomoo`0:OonC000NOom3000NOol100000003001oo`000?l001`0005oo`40000000<0
07ooOol00gooX00017ooK0002Goo0@0000000`00Oomoo`0=OolG00000goo0000000900000goo0000
000L00000goo0000000n000ZOolf000/Ool100000003001oogoo015oobd00005Ool00000001oo`0Q
00000goo0000000N002GOol100000003001oogoo01IooaH0009oo`<00003Ool0000000L00003Ool0
000000L00003Ool0000003@00:1oo`40000000<007ooOol06Woo300000=oo`0000000P0000=oo`00
00007`0000Aoo`00001oo`@0009oo`800003Ool0000001L00:Uoo`40000000<007ooOol07Goo8`00
00Ioo`00001oo`00Ool50002Ool2000017oo000000000Woo0P0000=oo`0000003`00/goo0@000000
0`00Oomoo`0POol900000goo00000002Ool300000goo001oo`0<00000goo0000000B00000goo0000
0007002mOol100000003001oogoo02Eoo`03001oo`0000H00003Ool0000000h00003Ool0000000l0
00Aoo`03001oogoo0<Aoo`40000000<007ooOol0<goo00@007ooOol000Moo`800003Ool007oo0=Uo
o`40000000<007ooOol0ogoo7Goo0@00003o000Q00000003001oogoo0?mooaeoo`40000000<007oo
Ool0F7oo0P001goo10002Woo00<007ooOol0ZWoo0@0000000`00Oomoo`1EOol2000;Ool00`00Oomo
o`030004Ool300000goo001oo`2ZOol100000003001oogoo05Yoo`8001Ioo`03001oogoo0:Moo`40
000000<007ooOol0C7oo00<007ooOol027oo00@007ooOol000=oo`<000Aoo`03001oogoo009oo`80
009oo`04001oogoo002ZOol100000003001oogoo04Uoo`06001oogooOol007oo0P0000Aoo`000000
009oo`06001oogoo001oo`000goo00<007ooOol01Goo0`000Woo00<007ooOol00P0000=oo`00Ool0
17oo0P00XGoo0@0000000`00Oomoo`1;Ool00`00Oomoo`0MOol00`00Oomoo`05Ool01000Oomoogoo
0P000Woo00<007ooOol0WWoo0@0000000`00Oomoo`19Ool20003Ool00`00Oomoo`0<Ool00`00Oomo
o`02Ool20002Ool01@00Ool007oo000017oo00@007ooOomoo`800003Ool007oo00800003Ool00000
09moo`40000000<007ooOol0DGoo00@007ooOol000Eoo`03001oo`00009oo`03001oogoo009oo`03
001oogoo00Qoo`03001oogoo00800003Ool0000000Aoo`04001oo`00002MOol100000003001oogoo
04ioo`04001oogoo000?Ool00`00Oomoo`05Ool01000Oomoo`0027oo00<007ooOol00Woo00<007oo
Ool0Wgoo0@0000000`00Oomoo`10Ool40003Ool00`00Oomoo`09Ool01P00Oomoo`00Ool000Aoo`03
001oogoo00Moo`03001oogoo00Qoo`03001oogoo009oo`06001oogoo001oo`000Woo00<007ooOol0
VWoo0@0000000`00Oomoo`16Ool01000Oomoogoo0P001Goo00<007ooOol01Goo00<007ooOol03Woo
00<007ooOol01goo00@007ooOol000Aoo`03001oo`00008009]oo`40000000<007ooOol0?Goo00<0
07ooOol017oo00D007ooOomoo`0001]oo`04001oogoo0008Ool01@00Oomoogoo00001Woo00<007oo
Ool00goo00<007oo0000V7oo0@0000000`00Oomoo`0nOol01000Oomoo`000goo00<007ooOol01Goo
00<007ooOol02goo00<007ooOol037oo00@007ooOol000Eoo`03001oogoo00=oo`03001oo`00009o
o`04001oo`00Ool5002EOol100000003001oogoo03moo`03001oogoo00Yoo`8000Moo`8000Moo`03
001oogoo00<000Yoo`04001oogoo0004Ool00`00Ool00006Ool00`00Ool00003Ool4002COol10000
0003001oogoo03aoo`03001oogoo009oo`03001oogoo00Aoo`8000Aoo`04001oo`000005Ool01000
Oomoo`000goo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01goo00<0
07ooOol00goo00<007oo0000UWoo0@0000000`00Oomoo`0gOol00`00Oomoo`0>Ool01000Oomoo`00
0goo0P0000Aoo`00Ool000=oo`800003Ool0000001Qoo`03001oogoo00=oo`03001oo`00009oo`80
00Aoo`04001oo`00002BOol100000003001oogoo03Aoo`03001oogoo00=oo`03001oogoo009oo`80
00=oo`8000=oo`8000Aoo`07001oogooOol007oo00000goo00H007ooOomoo`00Ool30007Ool2000=
Ool200000goo001oo`05Ool00`00Ool00002Ool200000goo001oo`2@Ool100000003001oogoo03=o
o`05001oogoo001oo`020007Ool01000Ool000003Goo00<007ooOol00goo00<007ooOol00goo00@0
07ooOol000moo`03001oogoo00ioo`03001oogoo09Moo`40000000<007ooOol0>goo0`0017oo00@0
07ooOomoo`80009oo`03001oo`00009oo`04001oogooOol20003Ool00`00Oomoo`02Ool20004Ool3
0002Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Ool00006Ool00`00Oomoo`020003Ool01@00
Ool00000Ool01000Sgoo0@0000000`00Oomoo`0eOol01@00Oomoogoo000017oo0P000Woo00<007oo
Ool00Woo00D007oo001oo`0000Aoo`03001oo`0000Moo`03001oogoo009oo`04001oogoo0003Ool2
0005Ool01000Oomoo`000Woo00@007ooOol000=oo`05001oogooOol00004Ool00`00Ool00003Ool0
1000Oomoo`00Sgoo0@0000000`00Oomoo`0`Ool00`00Oomoo`08Ool01000Oomoo`000goo00<007oo
Ool00Woo00<007ooOol03goo00@007ooOol000]oo`03001oogoo01Ioo`05001oogooOol00002Ool0
0`00Oomoo`02002?Ool100000003001oogoo035oo`03001oogoo0080009oo`04001oogoo000@Ool0
0`00Ool00006Ool30007Ool500000goo001oo`02Ool3000>Ool01@00Oomoogoo000037oo00@007oo
000008eoo`40000000<007ooOol0<Woo00<007ooOol00goo0P000Woo00<007ooOol00Woo00<007oo
Ool037oo00<007oo000027oo00<007oo00000goo00@007ooOol000=oo`800003Ool0000000Yoo`03
001oogoo009oo`03001oogoo00Aoo`04001oogooOol200000goo001oo`0200000goo001oo`2;Ool1
00000003001oogoo031oo`05001oogoo001oo`030006Ool30005Ool01000Ool000000Woo00<007oo
Ool00P002Goo00<007oo00000goo00<007ooOol017oo00@007ooOol0009oo`03001oogoo00Moo`05
001oogooOol00005Ool01P00Oomoo`00Ool0009oo`05001oogoo001oo`03002;Ool100000003001o
ogoo02Yoo`03001oogoo00=oo`8000moo`03001oo`00009oo`04001oogoo000KOol00`00Oomoo`0:
Ool00`00Ool0000:Ool2000;Ool01000Oomoogoo0P00RWoo0@0000000`00Oomoo`0]Ool20003Ool0
0`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`0@Ool01@00Oomoogoo00001Goo00<007ooOol0
0goo00<007ooOol01Goo0P000Woo00<007oo000017oo00<007ooOol027oo00<007oo000017oo00H0
07oo001oo`00Ool20029Ool100000003001oogoo02Qoo`800003Ool007oo009oo`04001oogoo0003
Ool00`00Ool0000DOol01@00Oomoogoo00000Woo00<007ooOol00goo0P0017oo0P000goo0P000Woo
00<007oo00000goo00<007ooOol02Goo00<007oo000017oo00<007ooOol017oo00@007oo0000009o
o`@008Uoo`40000000<007ooOol0;goo00<007ooOol01Goo00<007ooOol02goo00<007ooOol02Woo
0P000goo00<007ooOol057oo0P003Goo00<007ooOol01goo0P001Goo00<007ooOol00Woo00<007oo
Ool0QWoo0@0000000`00Oomoo`0WOol00`00Oomoo`02Ool20004Ool01@00Oomoogoo000017oo00<0
07ooOol00Woo00<007oo00000`0000=oo`00000017oo00<007ooOol05goo00<007ooOol00Woo0P00
0Woo0`0000Ioo`00Ool007oo000;Ool00`00Oomoo`03Ool02`00Ool007oo001oo`00Ool007oo0000
Qgoo0@0000000`00Oomoo`0XOol20004Ool00`00Oomoo`08Ool20002Ool20002Ool01`00Ool00000
Ool007oo00<000Ioo`07001oogooOol007oo00000Woo00<007oo00000Woo00@007oo001oo`8000=o
o`04001oogoo0005Ool01@00Ool007oo00001Goo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`04
001oogooOol40027Ool100000003001oogoo02moo`03001oo`0000Aoo`03001oo`0000Aoo`03001o
ogoo009oo`05001oogooOol00003Ool01`00Ool007oo001oo`00009oo`07001oogooOol007oo0000
27oo00<007oo00000Woo00@007ooOol0009oo`03001oogoo009oo`05001oogooOol00009Ool01000
Oomoo`001Woo00<007ooOol00Woo0`000Woo00<007ooOol0QGoo0@0000000`00Oomoo`0TOol00`00
Oomoo`03Ool30002Ool01@00Oomoogoo00001Goo00H007ooOomoo`00Ool20008Ool00`00Ool00003
Ool200000goo00000008Ool01000Oomoo`002Goo0P001goo10002goo00<007ooOol00goo0P000goo
0P0000=oo`00Ool00Woo0P00Qgoo0@0000000`00Oomoo`0UOol40006Ool3000027oo00000000Ool0
07oo0002Ool00`00Oomoo`020006Ool00`00Ool00002Ool2000?Ool00`00Oomoo`02Ool2000:Ool0
1000Ool000000goo00@007oo0000009oo`8000Ioo`03001oogoo00=oo`03001oo`0000Ioo`@008Io
o`40000000<007ooOol09Goo00<007ooOol01Woo00<007ooOol00P001Goo00<007oo000027oo00<0
07ooOol01goo0P001Goo0P000Woo00<007ooOol00goo00<007ooOol027oo00<007ooOol02Woo00<0
07ooOol01Goo00<007ooOol03Goo00<007oo00000P00RGoo0@0000000`00Oomoo`0SOol01@00Oomo
ogoo00000goo00@007ooOomoo`8000]oo`04001oogooOol300000goo001oo`03Ool20003Ool01000
Ool000002goo00<007ooOol02Woo00@007ooOomoo`8000=oo`@00003Ool0000000Uoo`800003Ool0
07oo00Ioo`03001oogoo00=oo`<008Eoo`40000000<007ooOol0:Goo00D007oo001oo`0000=oo`07
001oogooOol007oo000037oo0P000Woo00@007oo000000=oo`03001oogoo009oo`03001oo`0000D0
00Eoo`<000=oo`03001oo`0000Ioo`<0009oo`05001oo`00Ool00004Ool01000Oomoo`0017oo00<0
07ooOol00Woo0`000Woo00<007ooOol00P0000=oo`000000Q7oo0@0000000`00Oomoo`0QOol01P00
Oomoo`00Ool0009oo`04001oogoo0002Ool00`00Oomoo`0?Ool2000@Ool20004Ool2000017oo001o
o`002goo00@007ooOol000=oo`03001oogoo00Aoo`03001oo`0000eoo`<000Ioo`04001oogooOol2
0025Ool100000003001oogoo021oo`03001oo`0000=oo`03001oogoo008000Uoo`05001oogooOol0
000<Ool01000Ool0000027oo00H007oo000007oo0004Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool2
0004Ool01000Oomoo`001Woo00<007ooOol037oo00<007ooOol00P0000=oo`0000000P00Pgoo0@00
00000`00Oomoo`0QOol20004Ool20005Ool00`00Oomoo`04Ool02P00Oomoo`00Ool007oo001oo`00
3Goo00@007oo001oo`800003Ool007oo00=oo`05001oogoo001oo`030004Ool01@00Oomoogoo0000
1Woo00<007oo00000`000goo0P0027oo00<007oo00001goo0P000goo00D007ooOol007oo00<008=o
o`40000000<007ooOol08goo00<007ooOol02goo0P001goo0P0000Eoo`00Oomoo`0000=oo`03001o
ogoo00=oo`04001oogooOol20006Ool01000Ool000000goo00@007ooOol000=oo`03001oogoo009o
o`03001oo`0000Moo`03001oo`0000Aoo`<000Yoo`03001oogoo00Qoo`03001oogoo00=oo`80089o
o`40000000<007ooOol087oo00H007oo000007oo0007Ool40007Ool40004Ool00`00Oomoo`08Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Ool00005Ool01@00Ool007oo00000Woo00<007ooOol0
1Goo00<007ooOol01Woo00<007oo00000P000goo00H007ooOol007oo0006Ool01P00Oomoo`00Ool0
009oo`<00004Ool000000022Ool100000003001oogoo01ioo`<00004Ool000000007Ool200000goo
00000008Ool00`00Oomoo`030002Ool20002Ool20003Ool00`00Oomoo`06Ool30002Ool01@00Ool0
0000Ool00P000Woo00L007ooOomoo`00Ool00002Ool00`00Ool00003Ool20004Ool00`00Oomoo`04
0008Ool01000Ool007oo0P000goo00<007oo000017oo1P007goo2@00FGoo0@0000000`00Oomoo`0P
Ool00`00Oomoo`05Ool00`00Ool0000;Ool00`00Oomoo`0:Ool01000Ool007oo0P001Goo00<007oo
Ool027oo00<007oo00000Woo00<007ooOol00P002Woo00<007ooOol037oo0P0057oo00<007ooOol0
17oo0P007Goo1P0000=oo`00Ool01000Egoo0@0000000`00Oomoo`0MOol40003Ool01`00Oomoo`00
Ool007oo00<00004Ool000000002Ool200000goo00000003Ool00`00Oomoo`06Ool01000Ool00000
0goo00<007ooOol017oo00<007ooOol01Woo00D007ooOomoo`0001Uoo`03001oogoo00<00003Ool0
07oo009oo`03001oogoo00Aoo`8000=oo`03001oo`0000800003Ool007oo008001Yoo`P00003Ool0
07oo00H005Ioo`40000000<007ooOol08Goo00<007oo00000goo0`0017oo00@007oo001oo`<00004
Ool007oo0004Ool600001Goo001oogoo00000Woo00<007ooOol00goo00@007ooOol000=oo`04001o
ogoo0005Ool00`00Ool0000200001Goo001oogoo00000Woo0`001Goo00<007oo00000`0000Aoo`00
Oomoo`@00003Ool007oo00=oo`05001oogooOol00002Ool00`00Ool00005Ool5000HOol4000017oo
000007oo0P0000=oo`00Ool01`00E7oo0@0000000`00Oomoo`0POol00`00Oomoo`03Ool20002Ool0
1000Oomoo`001Goo00<007oo00003Goo0P002Woo0P0047oo00<007oo00000goo0P0047oo00@007oo
Ool000=oo`8000Qoo`03001oogoo009oo`06001oogooOol007oo0P000Woo00<007ooOol05goo0`00
0Woo00@007ooOol000Moo`<00003Ool0000000<0051oo`40000000<007ooOol06goo00<007oo0000
0P000Woo1@0000Aoo`00Ool000=oo`8000=oo`04001oogooOol30003Ool300000goo001oo`030000
0goo00000002Ool01`00Oomoogoo001oo`0000Qoo`04001oogooOol30003Ool500000goo001oo`02
Ool00`00Oomoo`04Ool01@00Oomoo`00Ool00P0000=oo`0000000`0000=oo`0000000goo00H007oo
Ool007oo0006Ool01000Oomoo`000Woo0`005Goo0`0000=oo`0000001@0000=oo`00Ool00`0000Mo
o`00Ool007oo001oo`05001=Ool100000003001oogoo01Yoo`8000=oo`<0009oo`03001oogoo009o
o`03001oogoo00Ioo`06001oogooOol007oo0P0000Aoo`00000000Qoo`03001oogoo009oo`03001o
o`00009oo`80009oo`80009oo`800003Ool007oo00Eoo`06001oogooOol007oo10000goo00H007oo
Ool007oo0004Ool01000Ool0000017oo00<007ooOol00Woo00<007ooOol01Goo00H007oo001oo`00
Ool20002Ool5000DOol5000017oo000007oo10000Woo00<007ooOol01@0000Eoo`00000007oo00<0
04aoo`40000000<007ooOol06Woo00@007oo001oo`800003Ool00000009oo`05001oogooOol00003
Ool01`00Oomoogoo001oo`00009oo`03001oogoo00<0009oo`80009oo`03001oogoo009oo`H0009o
o`04001oo`000002Ool00`00Ool00004Ool01@00Oomoogoo00000Woo00D007oo001oo`0000=oo`03
001oogoo009oo`04001oogoo0002Ool00`00Oomoo`04Ool20003Ool01@00Oomoogoo00000Woo00D0
07oo001oo`00009oo`03001oogoo00=oo`06001oo`00Ool007oo0P004Woo1@0000Ioo`00Oomoo`00
Ool300000goo001oo`0300000goo001oo`02Ool00`00Oomoo`02000017oo00000000BWoo0@000000
0`00Oomoo`0ROol00`00Oomoo`09Ool00`00Oomoo`03Ool01000Oomoo`002Goo0P0017oo00<007oo
Ool00goo0P000goo00<007ooOol01Woo0P001goo0P0000Ioo`00000007oo0006Ool00`00Oomoo`04
Ool01000Oomoo`000Woo00<007oo00005Goo00<007ooOol00Woo0P004Woo0P000Woo1@000Woo00<0
07ooOol01Woo0`000goo0P000Woo00<007ooOol00P00BGoo0@0000000`00Oomoo`0IOol600000goo
001oo`02Ool20002Ool00`00Ool00002Ool300000goo001oo`07Ool20005Ool00`00Oomoo`05Ool2
0005Ool01000Ool000000Woo00<007ooOol00Woo00<007ooOol00goo00D007ooOomoo`0000Eoo`80
00Aoo`@000=oo`03001oo`0000Aoo`D000Eoo`0:001oo`00Ool007oo001oo`00Ool;000AOol50004
Ool00`00Ool0000200000goo001oo`020006Ool00`00Oomoo`02Ool00`00Oomoo`060016Ool10000
0003001oogoo01aoo`05001oogooOol00003Ool00`00Oomoo`04Ool20002Ool00`00Ool00003Ool0
1000Oomoo`000Woo00D007ooOomoo`00009oo`06001oogoo001oo`000goo00D007oo001oo`00009o
o`05001oo`00Ool00007Ool30004Ool01000Oomoogoo0P0000Moo`00Oomoo`00Ool00003Ool00`00
Oomoo`03Ool400001Goo000007oo000027oo00<007oo00001Woo00@007ooOomoo`800003Ool00000
011oo`X000Eoo`8000=oo`07001oo`00001oo`00Ool01P0000Eoo`00Ool007oo00H0049oo`400000
00<007ooOol06Goo00@007oo000000Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00mo
o`04001oogoo0008Ool01P00Oomoogoo001oo`8000Yoo`8000Eoo`03001oogoo008000]oo`03001o
ogoo00=oo`03001oogoo00<000=oo`03001oogoo00Moo`06001oogoo001oo`0017oo00<007oo0000
47oo0P000Woo0P0000Moo`00Ool007oo001oo`020002Ool20005Ool2000>Ool300000goo001oo`10
Ool100000003001oogoo01Moo`@00004Ool00000Ool300000goo001oo`0700001Goo001oogoo0000
1Goo00<007oo00000`0017oo00L007ooOomoo`00Ool00005Ool30006Ool00`00Oomoo`0200000goo
001oo`03Ool00`00Oomoo`02000027oo001oo`00Ool007oo0002Ool01@00Ool007oo00000Woo00<0
07ooOol02Goo00H007oo000007oo0002Ool00`00Oomoo`05Ool01@00Ool00000Ool00P000Woo0`00
3goo0`0000=oo`00Ool00P0000=oo`00Ool017oo0P000goo00<007oo00001Goo00<007ooOol00P00
00Eoo`00Ool007oo00D00003Ool00000008003moo`40000000<007ooOol05goo0P000Woo00<007oo
00000P0000=oo`00Ool00P0000Eoo`00000007oo00<000=oo`05001oo`00001oo`030002Ool00`00
Ool00002Ool00`00Oomoo`04Ool20004Ool40003Ool200001goo001oo`00Ool007oo008000=oo`06
001oogoo001oo`000goo00@007oo000000Moo`03001oogoo00=oo`03001oogoo00Eoo`8000Eoo`03
001oogoo00@000Aoo`03001oo`0000<0009oo`8000ioo`L0009oo`04001oo`00Ool20002Ool20002
Ool00`00Ool00002000027oo001oo`00Ool007oo0003Ool200000goo001oo`02Ool00`00Oomoo`02
000nOol100000003001oogoo01Moo`<00005Ool007ooOol00006Ool3000=Ool20002Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`02Ool2000:Ool00`00Oomoo`02Ool200000goo001oo`05
Ool00`00Oomoo`020002Ool00`00Oomoo`04Ool01000Oomoo`001Woo00D007ooOomoo`0000Ioo`03
001oogoo00=oo`04001oogoo0003Ool01000Ool0000047oo00<007ooOol017oo0P001Woo00D007oo
Oomoo`0000Moo`04001oogoo000>Ool00`00Oomoo`02000mOol100000003001oogoo01Moo`@00005
Ool007ooOol00003Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00goo00@007ooOol0
009oo`8000=oo`03001oogoo009oo`D00003Ool007oo00=oo`<000Aoo`800003Ool0000000@000Yo
o`06001oogoo001oo`002Goo00<007ooOol01Goo00H007ooOol007oo0002Ool00`00Oomoo`06Ool0
0`00Ool00002Ool00`00Oomoo`02Ool4000=Ool5000017oo000000000Woo00<007oo00000P0000=o
o`00Ool00goo00@007ooOol000Moo`800005Ool00000001oo`0300000goo001oo`02Ool4000lOol1
00000003001oogoo01Ioo`05001oo`00001oo`0200001Woo001oogoo001oo`800003Ool007oo009o
o`<00003Ool00000009oo`03001oo`0000@0009oo`D0009oo`800004Ool007ooOol20003Ool00`00
Oomoo`030002Ool00`00Ool000080007Ool00`00Oomoo`03000017oo000007oo0P000Woo00@007oo
Oomoo`L00007Ool00000Ool007oo000017oo00D007oo001oo`0000Aoo`03001oogoo00D00004Ool0
0000000;Ool700001Woo000007oo001oo`80009oo`06001oo`00001oo`000Woo0P0000=oo`00Ool0
10002Woo00D007ooOomoo`00009oo`P003Ioo`40000000<007ooOol05Goo0P0000=oo`0000001Goo
10001Woo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol00goo00@007ooOol000=oo`03001o
ogoo009oo`03001oogoo009oo`05001oogooOol00006Ool2000017oo001oogoo0P0027oo0P0000=o
o`00000017oo00D007ooOomoo`0000=oo`03001oo`0000Ioo`03001oo`00009oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo009oo`03001oo`0000<000]oo`@00004Ool007oo0002Ool00`00
Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0<Ool01000Oomoogoo0P000goo00<007ooOol00Woo
00<007ooOol0>goo0@0000000`00Oomoo`0DOol8000017oo000000000Woo0P0027oo00@007oo001o
o`<00007Ool007ooOol007oo00000Woo00D007oo000007oo00<000Eoo`04001oogoo0006Ool90000
17oo001oo`000goo10000Woo00H007oo000007oo0002Ool50002Ool00`00Ool0000300000goo0000
000500000goo001oo`03Ool20004Ool20002Ool00`00Oomoo`03Ool4000;Ool300000goo001oo`02
000017oo001oogoo0P000Woo00H007oo000007oo0002Ool01000Oomoo`001Woo00H007ooOomoo`00
Ool50002Ool00`00Ool000030002Ool01000Ool007oo0P00=7oo0@0000000`00Oomoo`0COol50000
1Goo000007oo00000goo0P000Woo00<007ooOol00P000Woo00<007oo00000P0000Aoo`00Ool000=o
o`@00003Ool00000008000=oo`80009oo`<00003Ool007oo00Aoo`8000=oo`8000Moo`03001oogoo
00Eoo`07001oogooOol007oo00000Woo00P007oo000007oo001oo`002Woo0P0000=oo`0000000`00
1Woo00D007ooOol007oo00<00005Ool00000001oo`04000:Ool400001Woo001oogoo001oo`80009o
o`05001oo`00Ool00002Ool00`00Oomoo`02000017oo001oogoo0P0000Aoo`00001oo`D00003Ool0
000000/0009oo`<00003Ool00000039oo`40000000<007ooOol05Goo0P000Woo0P000Woo0P000Woo
0P000Woo00<007oo00000Woo00P007ooOol007oo001oo`003Goo00D007oo001oo`00009oo`03001o
ogoo00=oo`8000Aoo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo009oo`8000Ioo`@000Io
o`03001oogoo00=oo`03001oogoo00Moo`03001oo`0000Eoo`03001oogoo00Moo`06001oogooOol0
07oo0`002Woo00H007ooOomoo`00Ool300000goo001oo`02000017oo001oo`0027oo00@007ooOol0
00=oo`03001oogoo0080009oo`H00003Ool0000000H00003Ool007oo009oo`@0035oo`40000000<0
07ooOol04goo2@0000=oo`0000000P0000Eoo`00001oo`0000=oo`T0009oo`800003Ool007oo00Mo
o`<0000:Ool007oo001oo`00Ool007oo000:Ool7000017oo000007oo0P0017oo00<007ooOol00goo
1`0000=oo`00Ool027oo00<007ooOol00P000Woo0`000goo0P000Woo00<007ooOol00P0017oo00<0
07oo000010002Goo1P0000Eoo`00001oo`00009oo`04001oogoo0002Ool00`00Ool00002Ool00`00
Ool00002Ool>0002Ool400000goo0000000:0003Ool4000]Ool100000003001oogoo015oo`d0009o
o`04001oo`000002Ool3000017oo001oo`0017oo0P0017oo1@000Woo00H007ooOomoo`00Ool20002
Ool01P00Ool00000Ool0009oo`@000Aoo`8000Aoo`@0009oo`<00007Ool007oo001oo`00Ool00P00
00Aoo`00Oomoo`@000Moo`03001oo`00009oo`800003Ool0000000<000=oo`04001oogoo0003Ool0
0`00Ool00002Ool70008Ool300001Goo00000000Ool00P000Woo00H007ooOol007oo0002Ool01000
Oomoo`000goo00<007oo00002@0017oo0P0017oo1@0000Aoo`00Oomoo`D00004Ool00000Ool4000[
Ool100000003001oogoo011oo`H00003Ool007oo009oo`<000Qoo`04001oogoo0004Ool00`00Oomo
o`06Ool200001Woo00000000Ool0009oo`03001oogoo00Eoo`03001oo`0000=oo`03001oo`0000Uo
o`03001oogoo00800005Ool00000Ool00005Ool01P00Oomoogoo001oo`H00003Ool007oo008000=o
o`03001oogoo00Eoo`03001oogoo008000aoo`04001oo`000002Ool50008Ool3000017oo001oogoo
0P0000=oo`0000001Woo00<007oo00001goo0P0000=oo`00Ool00`000goo00@007ooOol0009oo`04
001oogooOol20002Ool01000Oomoo`000goo1`0000Aoo`00001oo`8002Uoo`40000000<007ooOol0
47oo100000=oo`0000001@0000=oo`0000000P0000=oo`00Ool00P0000=oo`00Ool00Woo00<007oo
Ool00P0000=oo`000000100000Aoo`00001oo`8000=oo`03001oo`0000@0009oo`03001oo`0000X0
00=oo`03001oogoo00800003Ool0000000<0009oo`08001oogoo001oo`00Ool0009oo`03001oogoo
00<00003Ool0000000Aoo`06001oogoo001oo`000Woo2@0000Aoo`00Oomoo`<000=oo`800004Ool0
0000Ool40007Ool500001Goo00000000Ool00`000Woo00H007ooOol007oo0002Ool200000goo001o
o`060002Ool00`00Oomoo`02Ool200000goo000000040002Ool30002Ool600001Goo00000000Ool0
20009goo0@0000000`00Oomoo`0?Ool700000goo0000000400001Woo000007oo001oo`800005Ool0
0000001oo`020003Ool200000goo00000006Ool00`00Oomoo`020004Ool01@00Ool00000Ool01000
00Ioo`00Oomoo`00Ool40004Ool00`00Ool0000300000goo000000020003Ool300000goo001oo`02
Ool200000goo000000040002Ool20003Ool00`00Ool0000200000goo001oo`060002Ool00`00Oomo
o`02Ool30003Ool80006Ool7000017oo000000000Woo0P000Woo100000=oo`00Ool00goo4@000Woo
00@007oo000000=oo`D00004Ool00000Ool200000goo0000000;000UOol100000003001oogoo00mo
o`@00003Ool0000000D000=oo`800003Ool007oo0080009oo`800003Ool007oo00=oo`04001oogoo
Ool200000goo001oo`030002Ool30005Ool30003Ool200000goo001oo`0300001Goo000007oo0000
0Woo00H007oo000007oo0002Ool01@00Oomoo`00Ool0100000Eoo`00001oo`0000Aoo`<00008Ool0
0000001oo`00Ool000Aoo`03001oogoo00Ioo`<0009oo`03001oogoo00=oo`04001oo`000003Ool2
00000goo00000005Ool300000goo001oo`02Ool01000Oomoogoo0P0000Ioo`00Ool007oo0004Ool0
0`00Ool00002000017oo0000000017oo00<007oo00000goo0P001Goo00<007oo00000Woo0P0017oo
00D007oo001oo`0000Ioo`X0029oo`40000000<007ooOol03Woo1`0000Moo`00000007oo001oo`05
00000goo000000020003Ool20002Ool40002Ool:00000goo001oo`0200000goo000000050002Ool0
0`00Ool0000300001goo000007oo001oo`00009oo`800003Ool0000000=oo`T00006Ool007ooOol0
07oo1@0000Aoo`000000009oo`03001oogoo008000=oo`P00003Ool007oo009oo`800005Ool007oo
Ool00003Ool00`00Ool000040005Ool900000goo00000003Ool200000goo00000002Ool00`00Oomo
o`0=0005Ool40003OolI00000goo0000000300000goo00000002000NOol100000003001oogoo00eo
o`H00003Ool0000000L00003Ool0000000D00004Ool00000Ool;0002Ool400001Goo00000000Ool0
2P0000Ioo`00001oo`00Ool@00000goo001oo`02Ool90003Ool00`00Oomoo`080004Ool40003Ool4
0003Ool40002Ool400000goo001oo`0:0003Ool60002Ool00`00Ool000050003Ool01`00Ool00000
Ool007oo00<00004Ool00000Ool20002Oold000LOol100000003001oogoo00aoo`T000=oo`X000=o
o`800003Ool0000000L000Eoo`04001oogooOol2000017oo000000000Woo0P0000Aoo`00Ool0009o
o`07001oogooOol007oo00000goo0P000Woo00H007ooOol007oo0002Ool20002Ool00`00Ool00006
00000goo00000002Ool60003Ool00`00Oomoo`0300000goo00000006Ool00`00Ool000030006Ool2
00000goo001oo`02Ool01000Ool007oo0`000goo0P0000Aoo`00001oo`@00003Ool007oo00Eoo`03
001oogoo00Aoo`800003Ool00000009oo`06001oo`00001oo`001Goo00@007ooOomoo`<0009oo`<0
0003Ool00000009oo`L00005Ool00000001oo`0300001Goo00000000Ool00P0000=oo`0000001P00
6Woo0@0000000`00Oomoo`0:OolL0002Ool300000goo0000000500000goo001oo`0D0004Ool00`00
Oomoo`0:00000goo0000000;0002Ool30003Ool400001Goo00000000Ool0600000=oo`0000000P00
00=oo`0000000Woo20000goo1`000Woo2@000Woo0P0000=oo`0000003`0000=oo`00Ool05P0000=o
o`00000070005Goo0@0000000`00Oomoo`08OolN00000goo001oo`0E00000goo0000000F00000goo
0000000600001Goo001oo`00Ool01P0000=oo`0000000P0000=oo`0000004`0000Aoo`00Oomoo`X0
009oo`l00003Ool0000002@00003Ool0000001800007Ool00000001oo`00Ool02P0000=oo`000000
5@004Woo0@0000000`00Oomoo`06OolR00000goo0000000500000goo0000000W00000goo0000000W
00000goo0000000;0002OolT00000goo0000000C00000goo0000000o000<Ool100000003001oogoo
00Eoo`T00003Ool0000000<0009oo`L00004Ool00000OolG0002OolG0002Ool;00000goo0000000Z
00000goo0000000600000goo0000000900000goo0000000?00000goo0000000G00000goo0000000;
00000goo0000000P00000goo0000000C0009Ool100000003001oo`0001P00003Ool000000?l00040
005oo`40000000<007ooOol0SP0000=oo`000000R@000Woo0@0000000`00Oomoo`05Ool]00000goo
0000000300000goo00000002Ool70002Ool00`00Oomoo`0700000goo0000000500001Goo00000000
Ool05@0000=oo`0000001P0000=oo`0000003P0000=oo`0000001@0000=oo`000000100000=oo`00
0000<00000=oo`0000001`0000=oo`0000005P0000=oo`0000007P002Woo0@0000000`00Oomoo`06
OolD00000goo0000000;00000goo0000000400000goo0000000D00000goo0000000900000goo0000
000500000goo0000000I00000goo0000000>00000goo0000000900000goo001oo`0?00000goo0000
000d00000goo0000000`000=Ool100000003001oogoo00Qoo``00003Ool0000001000003Ool007oo
01D00003Ool007oo00X00003Ool0000000P00003Ool0000000T00003Ool0000000D00005Ool00000
001oo`0400000goo0000000400000goo0000000:00000goo0000000700000goo001oo`0600000goo
000000060002Ool700001Goo00000000Ool01P000Woo2`0000=oo`0000001P0000=oo`0000003`00
00=oo`0000009`004Woo0@0000000`00Oomoo`0:Ool=00000goo0000000300000goo000000050003
Ool200000goo00000002Ool50004Ool500001Goo001oogoo00000Woo1P000Woo00@007ooOomoo`H0
0003Ool0000000T000=oo`800003Ool007oo00L00003Ool007oo00D0009oo`800004Ool00000Ool2
000017oo001oogoo0P000Woo1P0000Aoo`00Ool0009oo`<0009oo`04001oo`00Ool40003Ool30002
Ool2000017oo000000000Woo00H007ooOol007oo0004Ool50002Ool01@00Oomoo`00Ool00P000Woo
00D007ooOol007oo00H00004Ool000000002Ool5000017oo000007oo0P000Woo0P000Woo0`0000=o
o`0000000`0000=oo`0000000`0000=oo`00000010005Woo0@0000000`00Oomoo`0;OolP00000goo
00000005000017oo001oogoo1P0000Eoo`00000007oo00D00003Ool0000000=oo`D00003Ool00000
00<00003Ool00000008000=oo`03001oo`0000800003Ool0000000800003Ool0000000=oo`H00003
Ool0000000@00003Ool0000000H00003Ool0000000P000Aoo`03001oogoo00800003Ool007oo00L0
00=oo`T0009oo`800003Ool0000000800003Ool007oo00800003Ool0000000L00004Ool00000Ool4
00000goo000000030002Ool9000017oo001oogoo7P006Goo0@0000000`00Oomoo`0=Ool@0002Ool2
000017oo000007oo0`000Woo1`0017oo100000=oo`0000001P0000=oo`000000100000Aoo`000000
009oo`T000=oo`800003Ool007oo00800006Ool00000001oo`000Woo10000goo00<007oo00002000
0Woo0P0000=oo`0000000goo00<007oo00000`0000=oo`0000000Woo00H007oo000007oo0002Ool2
00001Goo001oo`00Ool010000goo1P0000=oo`0000001@0000Aoo`00001oo`<0009oo`800003Ool0
000000<00008Ool00000001oo`00Ool0009oo`04001oo`00Ool200001Woo001oogoo001oob@001ao
o`40000000<007ooOol03Woo1`0000Eoo`00000007oo00D00004Ool007oo0004Ool00`00Oomoo`03
Ool200000goo001oo`02Ool00`00Ool00004000017oo001oo`000goo00@007ooOomoo`80009oo`80
00Ioo`@000=oo`05001oo`00001oo`020003Ool20002Ool60002Ool00`00Oomoo`04Ool40002Ool2
0002Ool00`00Ool000030004Ool50002Ool00`00Oomoo`0200000goo001oo`02Ool01000Ool007oo
1@0017oo0`000Woo00H007oo000007oo0002Ool00`00Oomoo`020003Ool00`00Oomoo`03Ool20000
0goo000000020002Ool00`00Ool00002Ool00`00Oomoo`020005Ool01000Oomoogoo0`000goo00<0
07oo00001`0000=oo`00Ool00Woo00<007oo00000P000Woo0P007goo0@0000000`00Oomoo`0>Ool=
0002Ool00`00Ool0000300000goo00000002Ool01`00Oomoo`00Ool007oo00@000=oo`<0009oo`D0
00=oo`03001oo`0000800004Ool000000004Ool5000017oo001oogoo1`000Woo2@0000Moo`00Oomo
o`00Ool00002Ool600000goo00000003Ool400001goo00000000Ool007oo00@000=oo`04001oogoo
0002Ool800000goo00000005Ool:0002Ool200000goo001oo`04Ool2000017oo001oogoo100000=o
o`0000002@0000=oo`00Ool00`0000=oo`00Ool01P001Goo00<007oo00000`0000=oo`0000002`00
8Goo0@0000000`00Oomoo`0?Ool900000goo0000000400000goo000000040002Ool40006Ool20000
0goo001oo`060002Ool20003Ool30004Ool90004Ool20003Ool20003Ool90004Ool800000goo001o
o`03Ool01000Ool000000Woo00<007oo00002P000goo00<007ooOol00P0000=oo`00Ool00Woo00<0
07ooOol00`001Goo20000Woo0`0000Eoo`00Ool007oo00<0009oo`03001oo`0000d00004Ool007oo
Ool200000goo001oo`0400001Woo001oogoo001oo`P000=oo`/002Aoo`40000000<007ooOol047oo
0P0000=oo`0000000`0000Aoo`00000000Aoo`06001oo`00Ool007oo0`002Woo0P0000Moo`00001o
o`00Ool00003Ool00`00Ool0000200001Goo001oogoo00000goo00<007oo00000P000Woo0P001Woo
00D007ooOol007oo00800003Ool007oo00Aoo`8000=oo`03001oogoo00<00003Ool007oo00=oo`05
001oogooOol00002Ool01@00Oomoo`00Ool0100000Aoo`00Ool0009oo`05001oogooOol00002Ool2
0002Ool00`00Oomoo`050006Ool2000017oo001oogoo0`0000Qoo`00Ool007oo001oo`001Woo00<0
07ooOol00Woo0P000Woo0P0000=oo`00Ool00`001Woo00@007ooOomoo`800003Ool00000009oo`80
0003Ool007oo00@00003Ool00000008000Aoo`03001oogoo02Eoo`40000000<007ooOol047oo1000
00=oo`0000000`0000=oo`0000000`000goo00<007oo00000`0000=oo`00Ool00`0000Eoo`000000
07oo00<00003Ool00000008000=oo`<00003Ool00000009oo`03001oo`0000800003Ool007oo00<0
009oo`08001oo`00Ool007oo001oo`8000=oo`800005Ool00000Ool00002Ool01000Oomoo`000Woo
00@007oo001oo`800003Ool0000000=oo`<000Eoo`800003Ool007oo00D000=oo`05001oo`00Ool0
0002Ool300001Goo00000000Ool00P001goo300000Aoo`000000009oo`03001oogoo008000Eoo`D0
0005Ool00000001oo`0<0002Ool01@00Ool00000Ool0100000=oo`0000001@0000=oo`0000000`00
:7oo0@0000000`00Oomoo`0AOol700000goo000000090002Ool00`00Ool000020002Ool20002Ool3
000017oo001oogoo0P0000Aoo`00Oomoo`@00003Ool007oo009oo`800003Ool007oo009oo`800003
Ool0000000Aoo`80009oo`<00003Ool0000000Moo`80009oo`03001oo`00008000=oo`04001oo`00
0004Ool01000Oomoo`000Woo00@007ooOol0009oo`800003Ool007oo009oo`03001oogoo0080009o
o`03001oogoo009oo`L000Qoo`<0009oo`@0009oo`8000=oo`03001oogoo008000=oo`04001oogoo
OolA00001Goo00000000Ool0100000=oo`0000001P000goo1000;7oo0@0000000`00Oomoo`0COol6
0004Ool01`00Oomoogoo001oo`0000=oo`8000=oo`04001oo`000003Ool00`00Ool00004Ool00`00
Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`020007Ool0
0`00Oomoo`0:Ool20003Ool00`00Oomoo`08Ool01@00Ool007oo000027oo00<007ooOol00goo00<0
07ooOol01Goo00<007ooOol01Woo0P0000=oo`0000001Goo0P001goo00<007ooOol01goo1`0000Ao
o`00001oo`<000=oo`800004Ool000000002Ool01000Oomoogoo0`000goo00<007oo0000;goo0@00
00000`00Oomoo`0COol00`00Ool000050003Ool20003Ool00`00Ool00004Ool20003Ool200000goo
001oo`08Ool01@00Ool00000Ool00P000Woo00D007ooOomoo`0000Ioo`05001oo`00Ool00002Ool0
1P00Ool007oo001oo`@000Eoo`03001oo`00009oo`05001oo`00001oo`040002Ool00`00Oomoo`02
0002Ool00`00Oomoo`090002Ool00`00Oomoo`02Ool01@00Oomoogoo00000Woo100000=oo`000000
0`002Goo1`0000Aoo`000000009oo`L000=oo`T000=oo`H00003Ool0000000h00003Ool007oo00D0
031oo`40000000<007ooOol04goo100000=oo`0000000`0000Aoo`00001oo`800008Ool007oo001o
o`00Ool0009oo`8000=oo`<000Aoo`8000=oo`05001oogoo001oo`0200000goo0000000300001Goo
001oo`00Ool00P001Goo00D007oo001oo`0000=oo`03001oogoo00Eoo`03001oo`0000<00003Ool0
000000T00004Ool000000002Ool00`00Oomoo`02Ool200000goo001oo`03Ool00`00Oomoo`06Ool2
0004Ool300000goo0000000:Ool4000017oo000000000Woo0P0000=oo`00Ool00Woo00<007ooOol0
0P000goo00@007ooOol0009oo`<00004Ool007ooOol?0002Ool3000017oo001oo`00<goo0@000000
0`00Oomoo`0DOol01`00Oomoogoo001oo`00009oo`03001oogoo009oo`03001oo`0000Aoo`03001o
ogoo009oo`800003Ool007oo00=oo`05001oo`00Ool00003Ool00`00Oomoo`02Ool00`00Oomoo`06
Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool01P00Ool007oo001oo`@000Uoo`03
001oogoo00Eoo`8000Eoo`H000Aoo`/000Yoo`03001oo`0000Eoo`80009oo`03001oogoo00Aoo`03
001oogoo00aoo`06001oogooOol007oo0P0027oo00@007ooOol000=oo`04001oo`00000dOol10000
0003001oogoo01Aoo`H000Aoo`05001oo`00Ool00003Ool20003Ool00`00Ool00002Ool20002Ool2
0003Ool20002Ool00`00Ool000080003Ool00`00Ool00002Ool00`00Ool00002Ool200001goo001o
o`00Ool007oo008000=oo`8000Ioo`03001oo`00009oo`04001oogooOol20004Ool00`00Oomoo`03
Ool200001Goo001oogoo00000Woo00D007ooOomoo`0000=oo`8000Aoo`04001oogoo0002Ool00`00
Ool0000<Ool400000goo00000003Ool00`00Oomoo`02Ool00`00Ool000020003Ool01000Oomoo`00
0goo00D007ooOomoo`0000Eoo`04001oo`000002Ool01000Oomoogoo0P000Woo0P0000Aoo`000000
03Aoo`40000000<007ooOol05goo0`0000=oo`0000001@0000=oo`0000000P000goo00<007oo0000
0`000Woo00@007ooOomoo`<00004Ool00000Ool30002Ool01@00Oomoo`00Ool00P000Woo00<007oo
Ool017oo0P0000Aoo`00Oomoo`L000=oo`03001oogoo00=oo`08001oogoo001oo`00Ool0009oo`80
00=oo`03001oogoo00Aoo`06001oogooOol007oo0P0037oo0`000goo0P0000=oo`0000000`0037oo
4@0000=oo`00Ool02Goo00<007ooOol00goo0P000Woo00<007ooOol00`0017oo0P0000=oo`000000
0`00=goo0@0000000`00Oomoo`0FOol700000goo001oo`030002Ool200001Goo001oogoo00000Woo
00<007ooOol00goo10000goo100017oo00D007ooOol007oo00@00004Ool007oo0002Ool00`00Oomo
o`040003Ool300000goo001oo`02Ool60002Ool00`00Ool00003Ool00`00Oomoo`03Ool3000017oo
001oo`0017oo1P002Woo00<007oo00000goo00@007oo001oo`<000eoo`80009oo`<000Eoo`05001o
ogooOol00004Ool50006Ool01000Oomoogoo0`000Woo00<007ooOol00P0000=oo`00Ool00P00?7oo
0@0000000`00Oomoo`0GOol30003Ool01000Oomoogoo0`0000=oo`0000000goo00L007ooOomoo`00
Ool00003Ool01@00Ool007oo00002Goo00<007ooOol027oo00<007ooOol00Woo00<007ooOol01Goo
00D007ooOomoo`0000Aoo`04001oogoo0007Ool00`00Oomoo`0;Ool20002Ool200000goo001oo`04
Ool20003Ool00`00Oomoo`05Ool01000Oomoogoo0P0000=oo`0000003Woo10001goo00<007ooOol0
0Woo00<007oo00000P0017oo0`001Woo00<007ooOol00Woo00<007ooOol017oo1000?Goo0@000000
0`00Oomoo`0HOol200001Woo000007oo001oo`8000=oo`D00003Ool007oo009oo`800004Ool00000
0002Ool01000Ool0000017oo0`0000Aoo`00Oomoo`80000<Ool007oo001oo`00Ool007oo001oo`00
1Goo00<007ooOol017oo0P0000=oo`00Ool017oo0P000Woo00<007ooOol00goo00<007ooOol037oo
00@007ooOol000Aoo`03001oogoo00Ioo`80009oo`P000ioo`D00003Ool0000000@000=oo`03001o
o`00009oo`08001oogooOol007oo001oo`@000Eoo`03001oogoo00800007Ool007ooOol007oo0000
?Woo0@0000000`00Oomoo`0GOol200000goo00000002Ool200002Goo001oogoo001oo`00Ool00003
Ool2000017oo001oo`001Woo00@007ooOol000moo`03001oogoo008000Aoo`<0009oo`03001oogoo
008000Aoo`8000Eoo`03001oo`0000800004Ool007oo0003Ool200001Goo001oogoo00000goo00P0
07ooOol007oo001oo`000goo0P000goo1@0000Aoo`000000009oo`D000ioo`X0009oo`D0009oo`05
001oogooOol00006Ool40002Ool01@00Oomoo`00Ool01`00?goo0@0000000`00Oomoo`0LOol00`00
Oomoo`02Ool30004Ool01@00Ool007oo00000goo00<007ooOol027oo00<007ooOol017oo00@007oo
Ool000=oo`03001oogoo011oo`03001oogoo00Eoo`8000Ioo`03001oogoo00Aoo`0;001oogooOol0
07oo001oo`00Ool00003Ool3000:Ool20004Ool20004Ool4000@Ool00`00Ool0000>Ool00`00Oomo
o`0<Ool00`00Oomoo`05Ool01000Oomoo`00@Woo0@0000000`00Oomoo`0IOol20002Ool00`00Oomo
o`09Ool20002Ool60004Ool00`00Ool000020002Ool01`00Ool007oo001oo`00009oo`80009oo`80
0007Ool007ooOol007oo00001goo00@007ooOol0009oo`8000=oo`80009oo`@000Ioo`03001oogoo
009oo`04001oogooOol40003Ool00`00Oomoo`05Ool20002Ool00`00Oomoo`03Ool20002Ool4000@
Ool90002Ool20003Ool00`00Oomoo`02Ool01000Oomoo`000goo00@007ooOomoo`/004=oo`400000
00<007ooOol077oo100000Aoo`00Ool000Eoo`05001oogoo001oo`020002Ool30002Ool00`00Ool0
0002Ool20004Ool01000Ool007oo0P000Woo00<007oo00000P0000=oo`0000000P001Woo00<007oo
Ool00Woo0P001goo00<007oo000017oo00<007oo00001Goo0P000Woo00@007ooOomoo`8000Yoo`03
001oogoo00=oo`03001oogoo00Aoo`D0019oo`H0009oo`@0009oo`d000=oo`03001oo`00009oo`80
04Qoo`40000000<007ooOol06goo0`0000Aoo`00Ool0009oo`08001oogoo001oo`00Ool000=oo`03
001oo`0000Moo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo00Ioo`05001oogooOol00004Ool01000Oomoo`000Woo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00Woo00D007oo001oo`00009oo`05001oogooOol00004Ool00`00Oomoo`0=Ool0
0`00Oomoo`0@Ool00`00Ool0000200000goo00000004Ool3000<Ool00`00Oomoo`04Ool20019Ool1
00000003001oogoo01Yoo`<000=oo`03001oogoo0080009oo`04001oogooOol20002Ool01P00Oomo
ogoo001oo`<000=oo`03001oo`0000=oo`800003Ool007oo00Eoo`04001oogooOol20007Ool20000
0goo00000008Ool500000goo0000000=Ool00`00Oomoo`03000017oo000000003Woo00<007ooOol0
0Woo00@007ooOomoo`8001=oo`L000Aoo`03001oogoo00=oo`07001oogooOol007oo00000goo1`00
BWoo0@0000000`00Oomoo`0JOol00`00Ool00002Ool30002Ool2000017oo001oo`0027oo0P000goo
00<007ooOol00P0017oo0P000Woo00<007ooOol00Woo0P0000=oo`00Ool00goo0P0000=oo`00Ool0
0Woo00<007ooOol01Goo00<007ooOol00P000goo00<007oo00001Woo00<007ooOol00Woo00D007oo
Oomoo`00009oo`03001oo`0000<000Yoo`04001oogooOol;000DOol600000goo000000020004Ool2
0003Ool00`00Ool00003Ool01000Oomoogoo0P00C7oo0@0000000`00Oomoo`0KOol00`00Oomoo`04
Ool20005Ool00`00Oomoo`0@Ool01000Oomoo`001Woo00@007oo0000011oo`03001oogoo00Ioo`05
001oogooOol00008Ool01000Ool0000027oo00<007oo00002Goo00<007ooOol01Goo00<007ooOol0
27oo00<007ooOol057oo0P0000Aoo`000000009oo`800003Ool0000000/000=oo`8004eoo`400000
00<007ooOol07Woo0`000goo0`0000Aoo`00001oo`800009Ool00000Ool007oo001oo`0000Aoo`03
001oo`00009oo`03001oo`00008000=oo`03001oo`00009oo`04001oogoo0002Ool01000Ool007oo
0`000goo00@007ooOol000=oo`H00003Ool007oo00Aoo`04001oogooOol3000017oo001oogoo0`00
0Woo00<007ooOol017oo10000goo0P0027oo00@007oo000001Moo`D000=oo`<000Aoo`04001oogoo
Ool8001>Ool100000003001oogoo01eoo`03001oo`00009oo`05001oo`00Ool00003Ool00`00Ool0
0005Ool200001goo001oogoo001oo`0000=oo`05001oo`00Ool00002Ool00`00Oomoo`0;Ool00`00
Ool00005Ool01P00Ool007oo001oo`<0009oo`04001oo`000002Ool00`00Ool00006Ool01P00Oomo
ogoo001oo`L0009oo`<0009oo`04001oo`00Ool20007Ool6000IOol70004Ool20002Ool3001EOol1
00000003001oogoo01moo`06001oogoo001oo`000Woo00<007ooOol017oo00<007ooOol01Goo00<0
07oo000017oo0P002goo0`002Woo00<007oo00000goo00<007ooOol02Woo00D007ooOomoo`0000=o
o`03001oogoo00Ioo`8000moo`04001oogoo0004Ool20004Ool00`00Oomoo`0HOol30004Ool:001F
Ool100000003001oogoo01ioo`800003Ool007oo00Eoo`04001oogoo0003Ool01@00Oomoo`00Ool0
0P0000=oo`00Ool00goo00P007ooOomoo`00Ool007oo10001Goo00@007ooOol000Eoo`03001oogoo
00Eoo`04001oo`000006Ool01@00Oomoogoo00002Goo00@007ooOol0009oo`8000Ioo`03001oogoo
00=oo`03001oogoo00=oo`04001oo`000002Ool00`00Ool00002000LOol800000goo00000003001G
Ool100000003001oogoo01ioo`<00003Ool0000000Aoo`03001oogoo009oo`04001oo`000006Ool0
0`00Oomoo`030003Ool20003Ool20003Ool00`00Ool00003Ool20004Ool20006Ool300000goo001o
o`0:Ool00`00Oomoo`03Ool00`00Oomoo`02Ool200000goo001oo`05Ool00`00Ool0000;Ool20000
17oo000007oo10007goo0P0000=oo`0000000`00FWoo0@0000000`00Oomoo`0iOol00`00Ool0000:
Ool00`00Oomoo`0EOol00`00Oomoo`0>Ool01@00Oomoogoo00001goo00<007oo000017oo00<007oo
Ool01Woo00<007ooOol00goo00<007oo00000Woo0P0000=oo`00Ool0PGoo0@0000000`00Oomoo`0Q
Ool300000goo001oo`020003Ool00`00Oomoo`02Ool20005Ool00`00Ool00008Ool00`00Oomoo`04
Ool00`00Oomoo`02Ool20007Ool20006Ool20003Ool20003Ool00`00Oomoo`03Ool300000goo001o
o`020002Ool20006Ool00`00Oomoo`06Ool20003Ool01000Oomoogoo0P000Woo0P00PWoo0@000000
0`00Oomoo`0POol00`00Oomoo`02Ool40003Ool20002Ool01000Ool007oo0`0000Ioo`00000007oo
0002Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01P00Oomoo`00Ool0009oo`H0
00Ioo`80009oo`800003Ool007oo009oo`03001oogoo009oo`80009oo`03001oo`0000]oo`03001o
ogoo00Aoo`03001oo`0000=oo`03001oogoo00@0089oo`40000000<007ooOol09Woo00D007oo001o
o`0000Moo`09001oogooOol007oo001oo`00009oo`03001oogoo00Eoo`03001oogoo00Qoo`03001o
ogoo00Ioo`<000Eoo`03001oogoo00Moo`03001oogoo00Aoo`8000Eoo`03001oogoo00Eoo`03001o
ogoo00Yoo`03001oogoo00Aoo`800003Ool007oo089oo`40000000<007ooOol08Goo0`000goo00L0
07oo001oo`00Ool00002Ool2000;Ool00`00Oomoo`030005Ool20008Ool00`00Oomoo`03Ool00`00
Oomoo`020002Ool20003Ool00`00Oomoo`04Ool01@00Ool007oo000027oo0P0017oo00<007oo0000
0Woo00<007ooOol017oo0P0000=oo`0000000goo00<007oo00001000Pgoo0@0000000`00Oomoo`0S
Ool20005Ool20002Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool20003Ool01000Oomoo`000Woo00<007oo00000Woo00<007ooOol00`000Woo00<007oo000017oo
00D007ooOomoo`0000Ioo`06001oogooOol007oo0P000goo00<007ooOol00goo00<007ooOol01Goo
0`000Woo00<007ooOol00`0000Aoo`00001oo`8008Aoo`40000000<007ooOol0:Woo00L007ooOomo
o`00Ool00004Ool2000@Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomo
o`0FOol00`00Ool0000>Ool00`00Oomoo`07Ool300000goo00000025Ool100000003001oogoo02Qo
o`03001oogoo00=oo`800003Ool007oo00Ioo`05001oogooOol00002Ool00`00Ool00005Ool00`00
Oomoo`040003Ool50003Ool20002Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01P00Oomoogoo001o
o`H0009oo`800003Ool007oo009oo`8000=oo`06001oogoo001oo`001goo00D007ooOol007oo0080
08Eoo`40000000<007ooOol097oo00<007oo00000Woo00<007ooOol027oo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00P000Woo00@007oo000000]o
o`05001oogooOol00002Ool01@00Ool007oo00001goo00<007ooOol03goo00D007ooOomoo`0000Eo
o`05001oogoo001oo`020026Ool100000003001oogoo02Ioo`<0009oo`04001oo`000002Ool30002
Ool00`00Ool00007Ool00`00Ool000020003Ool01@00Oomoogoo00000Woo0P0000=oo`00Ool00goo
0P0017oo00@007ooOol000=oo`03001oogoo00Ioo`8000Aoo`@000Ioo`04001oogoo0003Ool00`00
Oomoo`03Ool300000goo001oo`02Ool30027Ool100000003001oogoo02Eoo`03001oogoo009oo`03
001oogoo00Yoo`04001oogoo0004Ool00`00Oomoo`06Ool01P00Oomoo`00Ool0011oo`05001oogoo
Ool00009Ool00`00Oomoo`02Ool00`00Oomoo`0200000goo001oo`0;Ool00`00Oomoo`06Ool01P00
Oomoogoo001oo`8008Moo`40000000<007ooOol0:Goo00D007ooOomoo`0000=oo`03001oogoo00=o
o`<000=oo`03001oo`00008000Eoo`04001oo`000005Ool00`00Oomoo`08Ool00`00Oomoo`07Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool01@00Ool007oo00001Woo0P0017oo00<007oo00001goo0P00
00=oo`0000001000R7oo0@0000000`00Oomoo`0YOol01000Oomoo`001Woo00@007oo000000Aoo`<0
009oo`04001oo`00Ool200000goo00000007Ool200000goo00000005Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool01P00Ool007oo001oo`800003Ool00000008000=oo`03001oogoo00Moo`04001oogoo
0004Ool00`00Oomoo`05Ool20028Ool100000003001oogoo02Yoo`03001oogoo01Qoo`8001]oo`05
001oogooOol00009Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool01000Oomoo`00
RGoo0@0000000`00Oomoo`0XOol00`00Oomoo`03Ool30006Ool00`00Oomoo`02Ool00`00Ool00002
Ool00`00Ool00004Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`08Ool00`00Oomoo`02
Ool01000Ool007oo0P0000=oo`00Ool02Woo0P001Goo00L007ooOomoo`00Ool00005Ool00`00Oomo
o`020029Ool100000003001oogoo02aoo`05001oogooOol00002Ool00`00Oomoo`04Ool00`00Ool0
0009Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Ool00002Ool01000Oomoo`000Woo0P000Woo
00D007ooOomoo`0000Aoo`05001oogoo001oo`020002Ool01@00Oomoogoo00002goo00<007ooOol0
0goo00<007ooOol00Woo0P0000=oo`0000000P00RGoo0@0000000`00Oomoo`0[Ool00`00Oomoo`03
Ool00`00Oomoo`0FOol00`00Oomoo`04Ool00`00Oomoo`0BOol01@00Oomoogoo00001Woo00<007oo
Ool04goo00<007ooOol00Woo00<007oo00000Woo00<007ooOol0R7oo0@0000000`00Oomoo`0_Ool2
00000goo001oo`02Ool01000Oomoo`001Woo00D007ooOomoo`0000Aoo`07001oogooOol007oo0000
1goo0P000goo00@007ooOol000=oo`04001oogoo0004Ool3000;Ool20002Ool01P00Oomoo`00Ool0
00=oo`03001oo`0000<000=oo`8008]oo`40000000<007ooOol0=7oo00<007ooOol00`001Goo00D0
07ooOomoo`0000Moo`04001oogoo0003Ool00`00Oomoo`05Ool00`00Oomoo`05Ool02P00Ool00000
Ool007oo001oo`0027oo00<007ooOol027oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0
0`00S7oo0@0000000`00Oomoo`0dOol00`00Oomoo`0@Ool00`00Oomoo`0AOol00`00Oomoo`03Ool0
0`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol01Woo00<007ooOol0
17oo00<007oo00000P00SGoo0@0000000`00Oomoo`0aOol01@00Oomoogoo00000Woo00<007oo0000
0P0017oo00@007ooOol000=oo`03001oogoo00Ioo`03001oogoo00Ioo`05001oogooOol00008Ool0
1000Ool000001goo00D007ooOomoo`0000=oo`05001oogooOol00005Ool00`00Oomoo`02Ool00`00
Ool00002002>Ool100000003001oogoo03Qoo`03001oogoo00=oo`800005Ool007ooOol00002Ool0
0`00Oomoo`08Ool2000017oo001oo`0017oo0`0000=oo`00Ool01@0000Aoo`00Ool000ioo`03001o
ogoo009oo`<0009oo`8000=oo`03001oo`00008008moo`40000000<007ooOol0<goo00<007ooOol0
7Woo00<007oo000077oo00<007ooOol02goo0P000Woo00<007ooOol00Woo0P00T7oo0@0000000`00
Oomoo`0bOol00`00Oomoo`02Ool00`00Oomoo`0200000goo00000006Ool00`00Oomoo`02Ool00`00
Ool00002Ool00`00Ool00004Ool01P00Oomoo`00Ool000Aoo`@0009oo`8000Ioo`8000eoo`03001o
ogoo009oo`04001oogooOol200000goo0000002AOol100000003001oogoo03Eoo`03001oogoo0080
00Eoo`D00003Ool0000000Aoo`800003Ool00000009oo`03001oogoo00Aoo`04001oogooOol30003
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool200000goo001oo`05Ool20003Ool0
0`00Ool00002002AOol100000003001oogoo03Ioo`03001oogoo01Ioo`03001oo`0000Yoo`8001io
o`03001oogoo00Ioo`03001oogoo09Aoo`40000000<007ooOol0B7oo0P0017oo00@007oo001oo`<0
0004Ool00000Ool20002Ool01@00Oomoogoo000047oo0P000goo00D007ooOomoo`0000Aoo`05001o
o`00Ool00003Ool2002BOol100000003001oogoo03aoo`03001oogoo00]oo`800003Ool007oo00Io
o`04001oogoo000?Ool01000Oomoo`000Woo0P001Woo00<007ooOol00Woo00D007ooOomoo`0000=o
o`D009Aoo`40000000<007ooOol0?Woo0P001Goo0P000Woo00<007ooOol06Goo00D007ooOomoo`00
00Yoo`05001oogooOol00003Ool00`00Oomoo`02Ool20003Ool00`00Oomoo`2COol100000003001o
ogoo03eoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo00Eoo`04001oogooOol20002Ool0
0`00Oomoo`0=Ool00`00Oomoo`06Ool01000Oomoo`0017oo00<007ooOol02@00UWoo0@0000000`00
Oomoo`11Ool00`00Oomoo`09Ool01000Oomoo`002goo00<007ooOol00Woo00@007ooOol000Qoo`03
001oogoo00Uoo`03001oogoo00Aoo`03001oogoo09Uoo`40000000<007ooOol0@7oo00D007ooOomo
o`0000Moo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00]oo`05001o
ogooOol00003Ool00`00Oomoo`03Ool01000Oomoo`00WWoo0@0000000`00Oomoo`10Ool01000Oomo
o`000goo00<007oo00007Woo00<007oo00001Woo00<007ooOol00Woo00D007ooOomoo`0000Aoo`03
001oogoo09Yoo`40000000<007ooOol0B7oo0P001Woo0P000Woo00<007ooOol00goo00<007ooOol0
0goo00D007ooOomoo`0000Moo`03001oogoo009oo`03001oo`0000Aoo`<00004Ool00000002MOol1
00000003001oogoo04aoo`03001oogoo00Qoo`05001oogooOol00005Ool01@00Oomoogoo00001Goo
00<007oo00000Woo00@007oo001oo`@000=oo`8009moo`40000000<007ooOol0CGoo00<007ooOol0
0Woo0P0017oo00<007ooOol05goo0P0017oo00<007oo0000XGoo0@0000000`00Oomoo`1:Ool20003
Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Ool000020003Ool00`00Oomoo`0200000goo0000
0007Ool00`00Oomoo`04Ool2002QOol100000003001oogoo04ioo`03001oogoo00]oo`03001oogoo
00Qoo`8000Eoo`80009oo`03001oogoo0:Moo`40000000<007ooOol0Egoo0P0000=oo`00Ool01Woo
00D007ooOomoo`0000Aoo`03001oogoo0:ioo`40000000<007ooOol0EGoo0P002Goo00<007oo0000
2Goo1P00ZWoo0@0000000`00Oomoo`1IOol00`00Oomoo`05Ool00`00Ool00002002fOol100000003
001oogoo0?mooaeoo`400000o`008@000000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250053, 
  0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["WindowsSound", "\<\
DTU6ATIF001G@EI5IVed8100000100404B/0014[000100P0I65dHB9F001oOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOh1oOgmoOh1oOgmoOh1oOgmoP81oOgmoP81oOgmoP81oOgn0P7moOgn0
P7moOgn0P7moOgn0P7moOh20P7moOh20OgmoOh20OgmoOh20OgmoP820OgmoP820
OgmoP81oOgmoP81oOgn0P81oOgn0P81oOgn0P7moOgn0P7moOh20P7moOh20P7mo
Oh20P7moOh20OgmoOh20OgmoP820OgmoP820OgmoP81oOgmoP81oOgn0P81oOgn0
P81oOgn0P81oOgn0P7moOh20P7moOh20P7mnOh20P7mnOh20OgmoOh20OgioP820
OgioP860OgioP820OWioP81oOWj0PH1oOWn0PH1oOWn0PH1nOWn1PGmnOX21P7mn
OX21P7mnOh21P7inOh61P7inOh61OginP860OgioP860OWioPH60OWioPH5oOWj0
PH5oOWj0PH1nOWn1PH1nOWn1PGmnOX21PGmnOX21PGmmOX61P7imOh61P7inOh61
OgenP8:1OgenP8:0OWeoPH:0OWeoPH5oOGf0PX5oOGj0PX5nOGj1PX1nOGn1PX1m
OGn2PWmmOH22PGimOX62PGimOh62P7emOh:2OgemP8:1OgenPH:1OWanPH:0OGeo
PX:0OGf0PX9oO7f0Ph5nO7j1Ph5mO7n2Ph1mO7n2PWmlOH23PWilOH63PGelOX:3
P7elOh:3OgalP8>2OWamPH>1OWanPX>1OGaoPX>0O7b0Ph=oO7f1Ph9nNgf1Ph5m
Ngj2Ph1lO7n3PgmlO823PWikOH64PWekOX:4PGakOh>3P7alP8B3OW]lPHB2OG]m
PXB1O7]nPhB0O7]oQ8=oNgb1Q8=nNgf2Q89mNWj3Q85lNgn4Q7mkNh24PgijO865
PWejOH>5PGajOXB4P7]kP8B4OgYkPHF3OGYlPXF2O7YnPhF0NgYoQ8AoNW^0QHAn
NWb2QH9lNGf3QH5kNWj4QH1jNX25Q7iiNh66PgeiO8>6PW]iOXB5P7YjOhF5OgUk
PHJ4OGUlPXJ2O7UmQ8J1NWUoQHEoNGZ0QXAnNG^2QX=lN7b3QX9kNGj5QX1iNH26
QGiiNX66Q7ehO8>7Pg]hOHB6PGYiOhJ6OgUjPHN5OGQkPhN3NgQmQHN1NWQnQXN0
N7V0QhInMgZ2R8ElMg^4R8=jMgf5Qh5iN7n6QWmhNH67QGehNh>7Pg]hOHF7PGUh
OhJ6OgQiPHR5O7MjQ8V4NWIlQXV2N7InQhV0MgMoR8QnMWR1RHImMWV3RHAkMW^5
R89iMgj6Qh1hNH67QGehNh>7PgYgOHJ8PGQgOhR7OWIhPXZ6O7EiQ8^5NWAjQX^4
N7AlR8^2MgEnRHZ0MWJ0RHQnMWR2RHElMW^4R8=jMgj6QgmhNH68QGagNhB9PgUf
OHN9PGIeOhZ9OWAfPXb9O79fQ8f8NW9hQXf6N79jQhb4Mg=lR8^2MgEoR8QoMWR1
R8ElMg^4R89iN7n7QgigNH>9QGYeNXJ;PgMcO8V<PWAbOXb=P79bP8f<OW5cPXj;
O75eQ8j9NW5gQHf6NG=jQX^3N7InQhQoMgV2R8AkMgb6R81gMh29QgedN8B<QgUa
NHN>QWI`NXZ@Q7=_Nhb@Pg9_OHj?PG5`Ohj=Og5cPHf:OG9fPhb7NgAjQHV2NGMo
QhInMgZ4R8=iMWj8RGmdMH6<RWaaMHB@RWU^MHNBRWI/MXZCR7A/Mh^CQg=]NHbA
Q7=_O8b>PG=bOh^:OWEgPXV5NgIlQHN0N7V1R8EkMG^7Rh9fLgj<SH1aLH2@SWe]
L8>CSg][L8FESWUZLHNESGMZLhRDRWI/MXVAQgI`NXV=PgIdOXV8OWMiPhR3NWMo
QhMmMGV5S8EhLGZ:T8AcKWb>TX9_K7fBU85/JgnDU7mZJh6ETgeZKH:DT7a/L8BB
SGY_MHF>R7UcNXJ:PWQgP8N5O7MmQXR0MWN2S8QjL7J7THUfK7J;UHQbJ7N?V8Q_
IWRAVHI]IWVBV8E/J7^BUX=]JgfATX1_L82>S7icMX>:QW]fOHJ6OWQkQ8R2MgEo
Rh]nLG>3THejJg67UXifIW2:VXmdI72<W8ibHg6=VheaI7>>VHYaJ7J=UHMbK7Z<
Sh=dLgj9R7igNX>7PGUiPXR4NGAlRHf1LW1oT95oK6b1UYAlIfZ3VYIkHfV5W9Ii
HVV6W9EhHf^7VY9hIVn7UhigJgB7THQhLGZ7RX9hN827Pg]iP8N6O7AiQhj5M6ij
SYB5KVQkTiV4JFAkV9b3IV9lVYf2I69mVYb1IFAoVIV0IfR0UYAnJfj2THelLGF3
RhIkMgf5QGeiOXJ7OWEgQ8j9N6eeRYJ:LVIdSib;KV5cTj2<JUicUJ:<JEecUZ6;
JUmdU9j9K6=gTIR6KfYkSY22Lg=oRXQmMg^4QWmiNhB8PGMeP8b<O6ibQIF?MfI_
RYbBLem/SJ:ELE]YSZFFLEUXSZFFLUaZS:2CM69^RYV>MFUdRI:7MW5lR8Z0MgV2
Qh9iNH68QGYdO8Z=PG5_P9>BOFQZQ9^HNV1TQJ:MNEYPQJFQNeYNPjBQOEePPInL
OV=VPIREOF]_Pi6;Ng5hQHZ2N7R0QhAkMgj7QgeeNHJ=QGA^NhnDPV]WOIVLPV9N
OJ2TQ5eHNZ:YQeeEMYnYRV9IMIZSRFUQMi>IQVm[O8j>P7=ePXZ5NWMnQhImMg^5
R85gMh:<R7Q_Mh^ER6mUMYFPRVMJLiZYSf=BKI^_U6E@JIN]Uf]EJ96VUG5NKH^K
SWEZMXV@QGIdOhV7O7IkQHR0MgR2RHAiMWj:RWa`M8NDS7ATL8nQTVeHJI>/VVa@
HI6aXG1>G8^^Y7MEGHFUWgaPI8:IUGe[L8>?RGYdO8N8OgMiPhV3NGMoQhMmMW^7
RX1cLX:CT7UUJhRQVGEHHHV[Y7MAEXB_[7iADGfZ[XIJE7NOYhUUGWNDVXI_K7b<
S7meNHB8PGQhPHV6NgIkQHR0N7V3RX=fLWj@TWiXIh6NWWiKFGjX[8AECGJY]HiI
BFfR]IESCVVFZiE^Ffb<VhifJgJ8SH=hN868PgUgOhR8OWIhPXR4NWR0R8EiLW^=
Th=[I7ZJXhMPE7>Q/Y9MB6NO^YeTAEfE]jA`CE^9ZZ5jGF>2VYEnKG62S8MkMgn6
Q7]fO8N9PGMfOhR6OGQmQXIlLgV9ThQ_HgBEYI1WDVRH]9iYAUVB^ZacATn5];20
DE1jYJZ8HUagUIZ7LFilRHUoNGf4QGegNXF:Q7UeO8J8PGYkPhInMGN6TX]dHfj>
YIQ`DUj=/jYfBDf2][N4C4Ed[KVAFTU[W:nEJeU[S9b?MfefQHZ3Ngb3QGmgNH::
QgaeN8>8Q7ajP8B0MgN3THiiIFV7XimjEEJ0[k>5CdAb[KnEEciRX;jQJ4MLSZnR
N5YRPYZFP6maOhR5OWb1Q81iN829RGmeMWn7QWmkOX>0NGN1ShmmIfJ0WjB4FU1d
YkRDFD1QX<:VISeBT;f`N4Y?OjZ/QV1JMYFKRG=^NHF7PGf0Ph5jMgj8RX9gM7b5
Qh9lOH60NWR0SI21JV=iVZN=HTeXWKZRIcmBTL6eMd54OKJlRe=6KJ6aUFYHJhbL
T7Y^M867PgioPX5lN7b5RXEjMGZ3Qh=nOH20O7QmRY25KfAcU:NEJTeNT[V]M496
P;c1RdXjJJ_3Wf53G9:aXWQJHH2HUX9aLWf6QH1nPH9nNGZ2R8ImMgV1QXAoOGn1
OGUlQhn7LfE_SZFKLe1GQ[FfPdPmK[;9WULeEI[4/7=5CH2/[HMQFgBAVHUgLGV3
QH5nP8:0NgYoQXJ0NGUoQ8B0OGj0OWYkQ8f9MfM]R::ONeAANjnlTU8hGJC</6Tf
A8Jo_hQ>@ffQ/YM]FVV8V91mLWJ0Q89oOh61OG]mPhF2O7YnPhB0OGj0Og]kPh^:
NfY[PijRPeY=KjJoX5lgCI?:`7dm=g2db9eL?e^A/ZAkGF5lU9B5MWAlPh>0Oh61
OgamP8>2OW]nPX>0OWj0OgalPHV:OFaZOYZSRV1<IIbo[6hj@H32bi=9;eZTbk1_
@D]o[:j;IEaaS9J<NgAiP8>1Oh21P7imOh61OgenPH:0OWj0P7elPHR:OfmZNYJT
TFM<GI6m]We1=fffdZMJ;DN?al25BT5[X;>JLE]VPYBAPWIfOH:2Ogn0PH1nOWn0
P7n0PH5oOWj0P7imP8N9P75ZMi:TUVm>EHFg_Xe;<U^VdkU_<SMh_<ZKFCaIT;:X
P5mNMhnERG]eNX22P7n0PH60OWenOh21PX5oOGj0P7imP8N9PW9YM8nSVgIAD7Z`
`Y]H<D^Dc/R4?BeR[<n_K3m9OJ^aT6UJJhJET85fMgf2PGmoPH:2OgakOH23Ph5n
O7f0P7imP8J:Pg=YLH^RWgeEC6nWa:QW=3j0aM6JCBU=V<c0PTLoJIneWgIKHGbB
UHQiMGZ0PX1nP8>4PGaiNh24QH9mNgb0PGmmOhJ:Q7EYKXNQXhAKBFFM`k=f>cE]
]mJ^H2`lPL;;V5HjEXjc[8EQFW2;UhmoMGInPX5nOX:5PgihN7j5R8AnNW]oPGmm
OhJ;QWIXJh>OYX]PB5bB_kb5AC1KYmBnMSD`J[?@[FXmAWZ[]II[EfB1UYJ6MgAj
PH9oOH66QX1hMGZ4RXMoNGUnPX1mOXF<R7UXJ7jMZI=WB5B6^/:DDBm<U<k;Rd<Z
EIo>_X16?6JN^JIjFEYeTYZ>Ng9fOh>0OGn5R8=iLgN2Rh^2N7MlPX5mOHB<Rg]Y
IGVIZiY^BTek//JRGc50P/CBX5@[@hW5bYIE>5><][>;HEAYRI^EPG=cO8:1OGf4
RHIlLgAoRXb4NWIkPH9nO8:;S7m/I7BCZImgCTQ_ZLN^KCHeKkSH/fL^<g:idZaX
>TAgZkRKKUIPOYJHR7QcNH62OWf1QhMoMWAlQX^6OGMjP89oOH28Rh9`IW6=YZ>0
EDIUW/JiOCd]G:WHaGdf9e^Wdkmn@cYSW;VXOUaJLXjHSWeeMgn2OgeoQ8J2NWIj
PhV6OgUjOh:0OGn6RXAdJ6n8XZB7G4ILTl;1S4PYBiODdi=48TFBcLfEDSIARK>b
SVMHJ8BETX=hMgb1P7inPXF3OGQjP8J6P7]jOX61OWn4RHAgJfj3WJF=HdQEQkc7
VeDY?8?;gJUG8c=j`]J/ISQ2MJRgWWAKH7V?U8UlMg^0PGmmP8>4P7]jOhB5PGak
OX61Ogn3QhEiKFf0VJBBJd]?O;C:ZF@]<6nmhKi]:REQ/=S0O48hH9RgZXARG6n7
Thj1NGUnPGmnOX63PGilOX63P7elOX61Ogn2QXAkKfimUZ>FLDi<LZ[:]G@e:5b]
h<n4=Qe:V]C?U54dCXF`/iA^G6ImSi67O7UlP81nOWn1PX1nOX21OgemOh61Ogn1
QHAlLFikTZ:IN5=9JJ38_X<o94ZIfM^LB1`fP/SIZf@g?g6T]j=lH5mcR96<PGYk
OX1oOWeoPH:1P7moOWenP8:1Ogn1Q8AlLViiT:6LOEM8H9K4aI=<93^5cn>bGB4W
JKOL_g]1=UbD]Jj;JEaYOhn@QWejO820OWamP8>4Ph1mNg]nPH>2Ogn1Q8AmLVih
SJ2OPea7FHbnbZ5J:31a`>G5M2`MDJ;Hci=@<dZ0[KJKMEeQMHZAS85kNgj0Ogak
OX:5QH9mNGUmPHB3P7j0Q8AmLfefRj2QR658Dh6gc:eY;RQN[^;CS3`J?8[=fJYT
=Sa[X;VYQ6=KJh:AT8ImNWf0P7ejNh26R8EnN7MkPHF4P7j0Q8EnLfadRInTSFI9
CGN_cKQh>2==Vm[NXTlM;76lg;mk@C=GSkFdU6eJHGR=Thb0NW]oPGiiNGj6RhR0
MgAhP8J6PGioQ8EoLf]aQYjVTfa:B6jVbl27@b<oR<kS]VDV8EVXfLjCDC55Njbk
Y7]MFFf6U965NgUnPGmjMg^4S8b3N75eOXN8PginPhJ1M6Y^PYbXVG9=A6BLb<NE
D2DdMKoSaW`d7DB@c]RZICHhIIfl/X]UEF9mTYJ;OWQlPH5kMWR1S8n7NW1aNhJ9
QGmmPXJ3Mf]/OYVXWWUA@UbB`lbSGRXZH[3QeI=46c9h`=foO44aDXZd^I]bFEac
RiB>PGYkP85mN7MnR8f9OWAbNH>8QX1mP8F4NVi/NY>UX81IA5F7^ln_K30SD9kL
hJUF7R9O[]c@U54`@WJX^ZN1HEY[Pi6@QGajOX5oNWQlQ8^9PGMdNH67QX5mOh>4
O79^N8jQX8IPAU1m/lniNcTO@8_CjKi/9QQ8UmGLZfHf=f6G]k6@K5aTNXb@RGmk
OH61OGUjPHN8Pg]fNGn5QH5nOh:3OWA_MhZMX8]VBTedZ/g2RTDN<WS6k=24=1<c
OlOQ`7e2<Dn4[[JNNF5PLHF>Rh=mOH21Og]jOXB6Q7eiNWn3Q85nOX63OgIaMXNJ
Whi/CT][X<W8V58Q9fBej]nKAQ@RIKGQdYEB<D1`XKJYR6YPJWf:S8IoOGn1P7ek
OH64PgmlNgn2Ph5nOX22OgQcMhFGWY5aDTYTUlC<Y60W85:ShnZbG1/FCIoJgZaW
=cELT;:aUWESIGB4RhR2OWj0PGmmO7j1PH1nOWn2PX1nOX21OgUdMhBEWI9fETYO
S[k>/6h`6d:?f>o6LbP?=hK=i<5n@c1;OJReXh=YHVemR8Z5OgioPH5oOGenOgmo
P862PX1nOX21OgYeMh>CW9AiFTYJQ[O?^Gdj6cAkb_3GRcT?9Fbjhm>GEC8mJIZc
[I5cI6MeQ8Z7PWinPH:1OgakO7j0PX>3PWmmOGn1OgYeMh:BW9EmGD]EO[3>`HY6
7BUX^NgTXddD65>Tg=j^JSTcEXR]/imoJ6=^OHR9QH1nP8:3PGejNG]oPhJ5PWil
O7n1OgYfMh:AW9N0H4]AMZS;aiMC8R5GYnC/^6@O43f<cnC2PDH`AGBR]JZ=L69W
MXB:R89nOh:4PgmiMWQmQ8R8Q7ikNgj1P7YeMX6AW9V3Hda>Kj78bj=Q:Ae7U=W`
bW/_3b]c_N?CVEPb>62B/[>KNfERKWj9RXEoOX65QH5jM7AjPhZ;QWmjNGf1P7]e
MGn@WIb7ITa;J9W4cje^<A/jPL__f9924aeJZ=cN/6dk<4j0Z[RXR6]OIWN6RhR1
OH25QhAlLg5fPH^>RX5iMg^0PGaeM7f?WYj;JTe7HI70dKMk?1`_Kk[ZhZMG71E5
T<oSa8E9;Si[W;RdUgEPGfj1Rh^4OWj4RHMnM6ibOX^ASX=iMWUoPWeeLg^<WJ6@
Kdm5FXVjdKn7AQhWGZ[Sj[]]:A4aMkoSe9eL<c=HRk6hXh9WGfUjR8^6Ogj2QhR2
N71aNXN>SHElMgUnPGmhM7V8VInBMEI7EX2bclFDDR8OCYWKl<f3=`lPGj_Ngk=b
?Rm8N:Bg[8iaHVEdPhZ7PGj0QHN4O7AbNH>;S8InN7UmPH1jMWV5UIbDNUa:DgVY
blZOGbPJ?hO?lmfIB1<CAiCCi/N9CC0lIYBa/IYlJ6E_OXN7PgioPhJ5OgQeN828
RXIoNWUmP81lMgV3TIZDOV5=DW:QalbYJc0H<WG1lNZ_GA/;<Wc4i]NPH3LdE8>W
/Z>8L6I/N8>7Q7mnPHB5PG]gN7j4R8J0NgYmP81mNGZ2SYNCPFIADFfI`LjbN3XH
9f>ajo?4LbT886>`hN:fMT8aAW2J[jZCNV]ZM7n5Q85nOh:4PWikNWf2QHB0O7]m
P81nNW^1S9BCPVUDDVVB_<fiQ4DK7e:Ph_SFRSX;4T^Ie^S9SE8c>en:Z:jNQG5[
L7Z2Q89oOX22Ph5nO7f0PX9oOGanP85oO7^1RY>BQ6aGDVF<]/boSe0P6T>=eOST
XDhB2CF0a^SIY6Hk=4iiWJfVT7Y]KGEnPh>0OWn1PX:1OgmoP7mnOGenP85oO7b1
RY6AQ6iIDV:7/<[4VE`W5cMkaoG_]V@O1B=X/n;S^Ga8<d5WSjR[VhAcKG5jP8>1
OgioPH>3Ph60OWelNgeoPH5oOGf1RI2@QG1KDf22ZlS7XVL_5RaZ]nkfbG/_1aE@
W=OXc9=I=cQFOj2/Y8mkKfieOH:2P7emOh:5QXB1OW]iNWb0PX:0OGf1RI2@QG5L
DeemY/K9Zg8h62AJYNCifI523P/jQ<OWfZU]@3=7KIBZZYZ4LfeaNH22PGelOH65
R8R4OgUfMg^0Ph>0OGf1RI2AQW9MDU]iXL?;/We26ai<U=ShiJIG6@LXK;?Qhkf3
CS@kG8FS[JB?NVi]M7f2PWikNgn5RX^8P7UdM7UoQ8F2OWb1RI6BR7ANDEQdW<3=
^8M;81Y0Q<[ckKU]:0PJE9gEilnIH3TcC7BI[J^JPg5[L7V0Ph1kNGb3RXj;PgUb
LGImQ8J3OWb0R96CRWIND5E_V;g>_Y1E9QPeM;[/l/V2>PhA@8G5iMb_M4@a?V:;
Z;2TSGM[K7AnPh5lN7V1RY2@Qg]aKW9kQ8N5OgaoR9:ESGQPCe5ZT[[?`iUO;AP]
IJ_RlmJFCAP<;Vjbg^C2RU@d=E5kWk2[Ugm_Jg5kPX9nNGQnQhn@RWmdKg5iPXN6
PGanQHnDSWaUDe9VS;?;aZ9Z=1TUEicJm^B[H2487ENMe>OBX6Ln<dI[TJV/WXQe
KG1hP89oNWQlPh^>Rh9hLW9hP8J6PWemPhbASGmZF5ATQZc7b:Ud?A/NBHg?m^nn
M2h84467a^KN]7a;=CeLPYnZXi1mLG1fOX:0O7UkP8N;RXAkMGAhOhB5PWimPXV>
S81]G5ISPJK3b:mnAQhJ?Gg3l_O@RCl=1be_/n3VaY5L>cQ?Li>UYIN4MW5eNh21
OW]jOX>8R8AnN7IiOX>4PWmnPHN<Rh5aH5UROJ6nakB6Cb@G<VjejocOWU4F0QaH
WmGXeJI_ASQ5I8JNYIb<OGAdNGn1P7ekO824QXB0NgUjOX:4PWmnP8F:RX5cHe]S
NYbja[N>F2XF:UnUh_g[/VHS0Pm2R<KVh;V4EC/nEWNCXJ2CQ7UeN7f0P7ilO7j1
Ph>0OGalOh:3PWmnP8B8R85dIEiSN9RfaKZEHC4H8e:Feo_ea7/c1`H^LK?Oi/ZI
IT<kBfV7Vj2IRgihMg]oP81nO7enP860OgioPH:3PGmnP8>7Qh5eIemTMiFb`kbL
JSPJ7TJ7b_Kke9153`4NFYoCj=R]NDll@U]iTYjMTXEkN7UmP85oOGalOGioP821
Ph>3PGmnP8>6QX1eJ65TMY:_`KjQLT0M6Sah_>onhZAI704AA8S4i>6oSEm2?Dm[
QiVNV8b0NWUkOh61OgajNW]mOh:4QHF3PGinOh>6QGmeJ65TMI2]`;nVNDLR6C=Z
[^Knk;I]:`D8<G6ag>K?XW1;?DEMNY:MW9>6OGUjOH62P7ejMgMjOX:6R8N5PGim
Oh:6QGmdJ65TM8j[_l2ZP4hW62aNWm[kllJ1?0d48E^Md>KK]HAI@3i@K8RIWiV=
PWYiO823PWmjMWAfNh:7RhZ7PGelOX:6QGmdJ61SLXbY_/:^QUD/6BICTLken=BE
CaT45DN7`>7RaYQYAc]5GW^CWijDQgeiNWj3Q85kMG9bN828SHf9PgekOH66QX1e
J5mQL8ZW_/>bS5`a6R99Q<;^nMjVHRL83CEa[MSUe:akDcdmDFj:W:6KSX5jN7b2
QH=mMG1_M7f7Si2=QGijNh25Qh5fJ5iOKHNV_/FfTV<f71m1N;GUmnJfMCL@2RIL
V<_Sg[j?HT8iAF1nUZ6OU8IlN7^0QHEoMg1]LGZ5SY6>QgmjNWn4QX9hJV1OK8BQ
^/BhV6Xm7adhK:WMn>o6QdHF1QQ7Q;_NhlbRLdhm@EIcS9bNUhYoNWYoPhF2NgA`
LWR2RXn=Qh1kNWj3QH=jKVARJh6L]L6iW7548a/aHIgEmoOEVULP1@ddKj[Ei=Nc
QEe4@4iWPIBLV8j3O7YmPXB3OWQcLgQoQhb<Qh5lNgf1Q8=lLFQUK7jH/;fiX7Q;
:1/[EY7;locRZfP/20DTFYK8h]o2V6e>@TUMMX^GV967Og]mP8>3P7]gMGQmQ8R9
QX5mNgf0Ph9mM6]XKGfD[;ZhXgeB;A`VC8G0k_k]_7/k3P4FAH6hfn;?ZGiKAdME
K8:AUY::PWemOh:3PWijN7UmPXJ7QH5mO7eoPX9mMViZKgfBZ;NgY89H<QdSA7Ve
i_kec8e;5`0;<fbVdN;I^I1YCdM?HWN9TY:=QGmmOX63PX1mNg]mP8>4Ph1nO7eo
PH5mMg1]LGf@YKBeYXIM=b0P?6jYg_ckfImM90<38eRCa=kOaj9jFT]<FFf0S96>
R89nOWn1Ph:0OWenOh61PGmmO7eoPH5mN79_LWj?Xk6dYXUR?2<O=VBMe?Sni;1_
<PX05TAn/mOQd[:;J55;Df=fQHj?RhF0OWj0PX>2PH20OgmoOWelO7eoPH1mN7=`
M7j?XJncYhaW@BHO<EZBbO;okKn1@Q<033=ZXL_Of/6LMe]=CU]/OHV>SHR3Ogio
PH>4Q8>2P7mmO7]jNgeoPH1mN7=aMGn?XJjbYhi[ARTO;E:7_n[nm<fBDal31BAF
S[gJg/f/QfMCCEASM8:;SH^6PGinP8:5QhN5PWmlNGQhNWf0PH1mN7=bMX2?XJjb
Z91^BR`P:T]m]>;kn=RRI2d:0QQ4NZgAgmJlV7EKCTmJJg^7SHf9PgmmOX65R8V8
QH1kMgEfN7b0PX5mN7=bMX2@XJjbZI9aCBlQ:4EdZMWgn^6aMS`C0`lcIY[4fmc9
ZHEVDTaCHG:1RXj;QX5mOH25RHb<R8=lMW=cMWYoPX9nN7=aMH2@XJjcZYAdD38R
9T1[Wm3an^RnQT`O1`XVDhNee=kC^9EcFTe=F6UjQhf=RH=nO7j3RHj?S8ImMW5`
LgQnPX9oNG=`M7n?XJnd[9MgDc@S9CaTU/KZn>c9UEd/3PPK@WBTbMcJaZJ2I51:
D5maPHb?S8EoO7f2RHnAShV0MW1^L7ImPX>0NW=aM7j>X:jd[IUjEcPU93QMSKkT
mo7CY6`i50LB<f6C_=KLck>ALEU>CeY[NhN=S8N1OGaoQH^?SXZ2NG=`LGIlPH>1
O7IcMGf;VjV`ZiYnG3dX93AFQKKOmoON/W]56`H:94n0[LgKeKnOOfADDEQUMH:9
RhN2OWanPXR<S8V3O7IcLgMlP8>1OGQeMWf9V:F/ZIZ0HD8/9C5@O:kImO_X`8]C
9@T563i^WL;Gf<R]SG5ME5MQKgb5RHR3OgemP8F9RXV4OWUfMGQlP8:2OWYgMgf7
UJ6XYiV2I4H_9S1;MJGBl_c_c9YR<0h23RmLS;G?f<nhVgiWFUQNJWN1QXN4P7em
OX:5QhN4P7]hMgUlP8:2Og]iNGj7TijUY9R3IdXc:2m7KYg:kOgeejQa?AD31b5:
NZG6eM?2Z8]bHU]MIW5lPhF4PGimOH22Q8F4PGekNW]mP8:2P7ejNWn7TI^RXIN3
JDdf:Ri3IiG3j?cihKJ0Bal60aHjJ9FicmC:]9UoJf1NHfafOX>4PX1nOGj0PH:2
PGmmOGeoPH:2P7elO827T9VOWiF3Je0i;2i1HXfkhOWljL:?FBX;0@d/EXB[am??
_ZJ<MVMPHVQaNX23PX5nOGemOX20P7moOh21PX:2P7ilOH67T9RMWIB3K58l;blo
GHJcfoGmklfMJ3LC0`PPAW:L_<kAa[6IPFmUHVE]MGb0PX5oOGakO7enOWn0PH:3
Q8>2P7imOX:8T9NLVi:2K5@n<2lmFH2/e?7llmJZMdDM1`DF=f6;[lO@c;bUSWU[
I6AYL7QnPH:1OWajNGYkO7j1PhB6QXF3P7imOX:9T9NKVY61K5E0<S0lEW^UcN_j
mMffQE<Y3@@?:U1jXKg=clBaVXAcJ6AVK7=jOh61OgajN7MhNWf0Q8J8R8N4PGim
OX>9TINKVI21K5E1<c0kDgJOa^Kgm^?0TV4e5@L;845YTK77clZkYi1lKFETJ6if
O862PGejMWAeMg]oQ8R:RhV5PGimOX>:TIRKVI20K5E1=34jDG:I`>3cm^O8WVm2
7``963AIP:Bnc<k4/Yb7MFUSI6YaNGn2PWmjMW=bLgQnQ8V=SH^7PgmmOX::TYVL
VY20K5E1=30iCfjD^][_mN[?Z7a@:a<:4RU:L9Fcalo;_JVBOViUHVI]MGf1PX1k
MW5_L7AkPhZ?T8j:Q7mlOH:9TYVMVY61K5I2=34iCF^?]=G[m>cE/XQL=QX<3Qll
H8FV_/_<`k:LQgEZI6E[LgZ0PX5mN7=aLGAjPHN<SXf:QH1mOH67SiJIV922KeY6
>3<iBfN:[m7YmO7M_IAX?b0=2QL`DGJH/lG;aKRUT7i`JFM[LGQnPH9oNgIcLgEi
OhF9S8b9QH1nOH25S9:FUHj2L5e:?3HkBfF6Z/cVm?CTaimdBRLA2A0U@fJ9Ykc7
a[b/VHMhKV]/L7MlP8:0OGUfMGIiOX>7RHZ8Q85nOGn4RXnCTXb1LEm=@3TmBf>2
YLOSloKZcjZ0EC0F2@/K=UQkV[;1aKnbXI20MFm^L7EkOh61OgaiMgMiOH65QhR6
Q85nOWn3R8f@ShZ0LV5@@c`oBf5oXL?Ol_O^ekF;HCXL2`PD:dY/S:Ni`L2gZ9R8
O7AaLGEiOX21P7ilNWUjOH23QHF4Ph1nOWn2QXZ=SHQoLV9CASm1C61lWKkKkoOa
gKjGK4DT3`P>8CeMOYZ`_;nj[Z2AQ7YeLgEhO7n1PH1nOGalOGn1PX>2PGmnOWn2
QHV;RXImLF=EBD93CF1jVK[Gk?KchlJQN50]5@T;6C5?KhfU]Kbk/jNIRh5iMWIh
Ngj0PH60OginOWn0PH60OgimOWn1Q8N9R8=lL6=FBdA5CV1iU[KBjOCdilf[Pe/g
70`94bM2HGnI[;Nj]ZbPThQoNGMhNWeoPH:2PX60P7moOgmnOGelOGn1Q8J7QX5j
Kf=FC4I7D61hU;;>iO;dj]>dSVM29A4:3algDg6<X[6h]k6WVhn5OWYhNG]nPH>4
Q8>3PX5oOWelNg]kO7j1Q8J6Q81hKV9FCDQ9DF5gTZo;hNocjmRkV79=;QP=3AT]
Af=oUjRc]kB]XYN<PgejNGYmP8:4QXJ5Q8:0OWajNGUiNgj1PhF5PgifK65FCTU:
DV5gTJc7g^cbk=c2XGaH>20A3A@T>eIaRYn]];FaZIjCRH5lNWYlOh:5QhR8QhB1
OW]hMgIgNWf0PhF5PWeeJf1ECDY;Df9gT:[4f^W`k=k7Z8IS@bTG418N<DUTOIBU
/;Fd[ZFJT8IoNgYkOH65R8Z;RHN3OgYgMGAeN7]oPhF5PWadJEiDCDY<E6=gSjW2
enK]jmo:[hm]CS<O518J:CiGL8RLZ[>e/jbRUhb3OGYjO824R8b=S8V5P7]fLg9c
MWYnPXF5PWacJ5eCC4U<E6=gSZO0e>?[j^3=]9MgF3`W6A<G8SA;HgbAXZjd]:nW
W968P7]jNgj3Qh^=SHZ6PGagM79cMGUmPHB4PWadJV1GD4e?EfAgSJFmd^;[jn?C
^imoH4@/71@D7Ba1F726V:J^/:jWWYB;PgikNgf1QHR;RhZ7PWiiMWAdMWUmPH>4
PWefKF=JE55BFFIgS:Bkd>3Zk>KG`ZN8JD/c81DC62DgCFAjSYfW[:bWX9N>QX1m
O7f0PhJ8RHV6PgmkN7IfMgYmP8:3PGegKfINF5EFG6QhS::icMkYk>SKajj@LE@j
9APC5Al_@eU_Pi>OYZRVXIVARH=oOGeoPHB6QhN6Ph1mNWQhN7YmOh62PGehL6UQ
G5UJH6YiS:6gbmcWk>WNc;BHNUa1:a`D51/X>TiTN8VGX:BTX9ZCS8J1OWenP8:4
QHJ5Ph5nO7YiNW]mOh61P7ehLV]TGeeNHfekS:6ebM[UjnWPd;ZOPVE9<R4G51PR
<TEIKGn=V9jQWi^EShV4P7inOh22PhB3PX5oOGakO7enP861OgahLfaWHV1QIVmm
SJ2damOSj^WRdknVRVeB>RLJ5AHN:ca?HWB4T9RLWI^FTH^6PX1nOWn0PH:2PH5o
OWimOGioP860OgahLfiYIF=UJW9oSj2caMGQj>WRe/>/TGEJ@RhO5aHK9SA5F6Yj
Qi6GVYVGThj9QH5oOWinOgn0P820OgmoOh21PH60OgahLfmZIfIXKGF1T:6ca=?O
i^OSelJaV7eRBSDU6aLJ8RhmCUm_OXVAUYNFU92;Qh>0OWemOGenOWmoP821PH:2
PX:1OgahM6m/JFU[L7R4TZ:c`m7Mi>KRf<VeWHAZDSd/81XJ7bPfAEEUM82:T9BE
U96=RHF2OgelNg]lOGeoP862PhB4Q8>1Og]hM71]Jf]^Lg^6U:>c`]3Kh^CQf<Zh
XXYbFTDc9QhK7RD_?DaKJWN2RY2CTi:?S8R4P7ekNWUjNWamOh63Q8F6QHB2Og]g
Lg1]K6e`MWj9UZFc`/oIh>;Of<^kYY1iHTdk;B<N7R8[=T=BH6ijQ8^@TY:ASXZ6
PWikNGQhN7YlOX64QXN8QhJ3P7agLg1]KFibN86<V:Jd`/kHg^3Mel^lZYEoJUE3
=2TR7b4W<3a9EfAaO8F<T9:BT8b8Q7mkN7IfMWQjOH64QhV9RHN5PGahLg1]KFmc
NX>>VjRf`lkFg=kKeL^m[9V5L5e;?2lW8R8U;3E1CU]XM7j7SI2BTHj:QH5lNGIe
MGIiO823QXV:RXR6PWeiM75_Kg1eNhB?VjRe`LcEf]cKeLbo[if:MV=A@C@Z9B<T
:S8lB5EQKGR1R8b>SXf:QX9nNWQfMWMiO7n2QHN9RHR5PWijMgAbLG=gOHF?VjNd
`<[CfM_Je/g1/j:?O6UGAST^9b@T:2lh@dmKIg9kPXR;S8^9QX=oO7UhMgQiNgj1
Q8J7QhN5PWmlNGIdM7IiOhN@VjNb_/SAem[IeLk3]ZFDPFiLC3hc:bHU:2de?dYE
HF]eOH>7RHV8QX>0OG]iNGUjNgj0PXB6QXJ4PX1mNWQgMgQlPHRAVjJa_<K>e=SH
eLk4^:VHQWARDT<h;bTW:2`c>dE@FfE_Mgj2QHN7QH>1OgakNWYjO7eoPH>4QHF4
PX1nO7YiNG]nPhZBW:J`^lC<d]KFe<k5^J^KRWUXF4Tm<bdZ:B`a>45;EEmYLGQn
PHB5Q8>2P7ilNg]kO7ioPH:3Ph>3PX1nOG]kNgf0QHbCW:J`^L;:d=?Dd/g5^ZfO
SWi]GDm2>34]:bd`=Si7D5YSJg=iOH22Ph>2P7mnOGemOGioP862PX:2PH1nOGem
OGn3QhfEWJJ_^<78cM7Bd<c5^jnQTX9bHeE8?SHa;Rha=Ca3C5ENIVedNGeoPH61
PH1oOWinOWioP821PH60P7mnOWinOh:5RXnFWZJ_]ko6blk?c/[3^k2SUHIgJ5Y>
@c/e<C0b=CY1B51HH6Q^M7QlOX21PH60P7moOgmoOh20P81oOginOWioPH>7S96H
WjN_][g4b<_<blS2^[2TUhYkKF1DBD4j=S<c=SToADaDFf9YKgAhO7j0PH61PH61
P820OgmoOginOWemOWj0PXF9SY>IX:N_][c2a/W9b<G0^K2UVHaoLVIJCdHo>SLf
=cTm@dU?EUeTJW1dN7anP862PX:2PX61P7mnOWemO7amOGj0PhJ:SiFKXZR_]K_0
a<K7aL:n]jnUVXn3MV]OEDa5?c`j>CXm@DI<DUQOIF]`MGUlOh62PhB4Ph:1P7mn
OGakNg]lOGj1Q8N<TINMXjV_]KZn`/?4`[nk]JfUVi25NVmUFe=;AD4n?3`n@4A9
CUAJH6I/LGIjOX22Q8F5QHB3PH1nOG]jNWYjO7j0Q8R=TYRNY:Z`]KZm`<71_kbh
/Z^SVi67OGAZHEUABdI2@3lo@4=6Be1EFf5WKG9gO7n2Q8J6QXF4PX1nO7]jNGUi
Ngf0Q8R=TYRNY:Z_];Rk_Kjn_;Ve/:ZSVi:9P7M^IEeFD4]7A492@dE8C51EFf5V
K75fNgj1PhF5QXF4PX5oOGajNWUjNgeoPhN;T9JKXJJ[/;Bg^KZj^KNc[jVSVi>;
PWYaJF9KE4m;B4M6ATQ:CU9GG65VK75eNWf0PXB5QHF4Ph5oOWakNWYjNgeoPXF:
SY>HWJ:WZjnb]KJf]KBa[JRRViB<Q7adKFIOFEA@CD]:BT]=D5AHGF5VJg1eNGao
PH>4Q8B4Ph60OWelNg]kNgeoPHB8S96EVYnSYj^^/;:b/[2^ZZJQViB=QWmgL6US
GEUEDTm>CTmADeIJGV9WJg1dN7]nP8:3Q8B3PX60OgilO7]kO7eoPH>7RXjCUi^O
XjJY[:f^[JbZYjBOVYB>Qh5jLfeWHUeIEUACDU=DEUULH6AXK71dMgYmOh62Ph>3
PX60OgimO7alO7eoP8>6RHb@U9RKWj:UYjRYZJRWY:6MVI>>R89lMW1[IV9NFeUH
EeMHFUaOHVEYK71dMgYlOX21PX:2PX60OgmnOGemOGioP8:5QhZ>TIBHVijPXZBU
YJBSXIjKUi:>RH=nNG=_JVISH5iLG5aLGUmRI6MZKG5dMgUlOWn0PH:2PH60P7mn
OWemOGioP8:4QXV<SY6DUiZLWYnPX:2OWI^HUI6=RHAoNgIbKVYWIF=QHF1QHV=U
IfU/Kg5dMgUkOGj0P861PH60P7moOWinOWioP8:3QHN:S8nATiFGVIZKVi^JVINE
TXn<R8B0O7UeLVm/JVQVIVEUIVMXJVa^L7=eMgUkO7ioP820P820P7moOgmnOgn0
P863Q8J8RXb>T96CU9FFUYJFUI>BShf:QhB1OW]hMG9`KVe[JfYZJV]/KFmaLWAf
MgUkO7enOgn0P820P7moOgmoOh20PH:3Q8F6R8V;S8j?T96ATI6AT8n>S8Z8QXB1
OgejN7IdLg5`L6m_Kg1`LG9cM7IgN7UkO7emOWioOgmoOgmoOgn0P821PH:2PhB5
QXN8RHZ;S8b<S8b<S8^:RHN6Q8>1P7ilNgUhMgIeMGAdM7AeMGIfMgQhNGYkO7am
OGinOWmoOgmoP820P861PX:2PhB4QHF6QXN7QhR8R8N7QhJ6QHB3PX:1P7mnOGal
NgYjNWUiNGUiNGUiNWYjNg]kO7alOGemOWinOgmoP821PH62PX:3Ph>3PhB4Q8B4
Ph>3Ph>2PX:1PH61P820P7moOgmoOginOWinOWimOGemOGemO7alO7alOGemOGin
OWmoP821PH62PX:2PX:2PX:1PH60P7moOginOWinOWinOWioOgn0P861PH:2PX:2
PX:2PH60P81oOginOGemOGemOGenOWmoP821PH62PX:2PX61PH1oOgimO7akNgYj
NWYjNWYkO7amOWn0PH:3Q8F5QXJ6QXJ6QHF4Ph>2PH1oOginOGemOGenOWioP821
PH62PX:2PH60OginO7]jNGQgMgIfMGEfMWMhNGYlOGn0PXB5QXR9RXZ;Rh^:RXV8
QhJ5Q8:1P7moOWemOGemOWioOh20PH62PX:1PH1oOWelNgUhMWEdLg9bLG5bLW=d
MWQjO7j0PXB7R8Z<SHj>Shn>SXf<RhV8QXF3PX60OgimOGemOWioOh20PH62PX:1
PH1oOGajNGMeM79`Kfi^KFe^KW1aLgEgNWeoPXF8RXb>T96BTi>CTY6@SXf;RHN5
Q8:1OgmnOGemOGinOh20PH62PX:1P7mnOG]iMgEcLFm]K6]ZJFUZJVa]L79eN7]o
PXF9S8jATiFFUiNGUYFDTY2>S8Z8QXB2P7mnOWemOGinOgn0PH62PX:1P7mnO7Yh
MW=aKfaZJFMVIFEVIfQZK6mbMWUmPHF9SI2CUIRIVY^KVYVHUYBBShf:R8F3PX1o
OWemOGenOgn0PH62PX:1P7mnO7YgMG9_KFYXIVASHV5RHfAVJFa_LgMlP8F9SI6E
V9ZLWYjNWYfLVYRETY2=RXN5Ph5oOWimOGenOWn0PH62PX:1P7mmO7UgM75^JfQU
Hf5OGUiNGf1RIFU/LGEjOhB9SY:FVYfOXJ:RXZ6PWY^IUY>?S8V7Q8:0OgimOGen
OWn0P862PX:1P7mmNgUfLg1]JFISH5iLFeYJFeeOHVEYKW=hOX>8SY>GVinQY:FV
YJFSXInLVIJBSh^8QX>1OgimOGemOWmoP861PX:1P7mmNgUfLfm/J6EQGUaJF5MG
F5UKGV9VJg1fO8:8SI>HW:2TYZRYZJRWYJ:OW9VETHj:QhB2P7mnOGemOWioP861
PX:1PGmnNgUfLVm[If=PG5UGEEADE5IHFeiSJ6idNX27SI>HWJ:UZ:Z/[:bZZ:JS
WibHU92<RHJ3PGmnOGemOWioP861PX:1PGmnO7UfLViZIV9NFeMEDe5ADE9DEe]P
IF]aN7j5S9:HWZ>WZZf^[jj]ZjRUXYjJUI6>RXN4PX1oOWemOWioP821PH61PH1n
O7YgM71/J6APG5UFDe5@Ce1AE5MLHFM^MGb4Ri:IWjBX[:j_/:n^ZjRUXIfIUI6=
RXN4PX1oOWinOWioOh20PH61P81oOG]iMW=_K6QSGe]GE55?CTi?DEAHGVAZLWZ2
RY:IWjFZ[K2a/K2^[:RUX9bHU92<RHJ4PX60OgmoOgmoOh20P820P7moOWajN7Eb
Kf]WHUiJEU9@CTe=CU5EFV1WKgN0R96HWjJ[[[6b/[6_[:RTX9^GThn;R8J4PX60
P7moOgmoOgn0P820OgmoOWelNWQeLViZIF5LF5A@CTa<C4iBEeeTK7AmQXnHWjJ[
[k:c/k:`[JVTWi^FTXj:QhF3PX60P820P820P7moOgmoOgmoOWimNgYgMG5]JFAO
FUIBCTa;Bda?DeUPJ75kQ8jFWjJ//;>e]K>a[JVTWiZETHf9QXB3PX61P820P820
P7moOgmnOWinOWinOGajMgAaK6MRGEQCCda:BDY<D5IMIFihPXbEWZF//KBf][Ba
[ZVTWiVDSh^8QH>2PH61PH61PH61P81oOginOWinOWinOWelNWMdL6]VH5]FDDe:
BDU:CU=IHF]dOhVCW:F//KBf][Fb[ZVTWYVCSXZ7Q8:1P820PH61PH61PH1oOgim
OGenOWioOgmnO7YgLfmYI5iHDdi;B4Q9Be1FGVMaO8NAVjB[/KFg]kJc[jZTWYRB
SHV5Ph60Oh20PH62PX:2PH1oOWimOGemOWioOh1oOWejMg9]If5KEE1<BDM7BDeC
FfA^NHB?VJ:Z/;Fg^;Nd/:ZTWYRBS8R4PH1oOWn0P862PX>2PX60OgimO7alOGio
P861P7mmNWIaJfENF59=BDM7B4]AF65[MX6<Uj6Y/;Fg^;Nd/:^UWYNARhN3P7im
OGioP862Ph>3PX60OgimO7alOGioP862PX60OGUeKfURFeE?BdQ6AdY>EEiWLWj9
U9nX[kBg^KRe/J^UWYN@RhF1OWelO7enP862PhB3Ph:1OgilO7]kO7enP8:3Ph>2
P7ehLfeVGeQBCDU7ATQ<De]TKg^6TYbV[K>g^KRe/JbUWYN@RXB0OG]jNgamOh62
PhB4Ph:1OgilNg]kNganP8:3QHF5Ph1lMg5ZHe]ECdY7ATM;D5QQK7N3SiZT[;:f
^;Rf/ZbUWYN@RH=oO7YiNGYlOX22PhB4Q8>2P7imO7]kNganP863QHJ6QH>0NgE_
If1IDTe9ATI9CUAMJ7B0S9RRZk:f^KRf/JbUWIF>R89nNgUiNGYlOGn1PX>3Ph:1
P7mnOGalO7enOh63Q8J6QXF2OgYdKFENEU1;AdI7Be5JI71lRIJQZ[:f^KRf/J^T
W9B=QX5mNWUhNGYkOGn0PH:2PX:1P7mnOGemOGenOh62Q8F7QhJ5PWiiLV]SFeA=
BDI6BDiFH6aiQY>OZK6f^KVf/J^SVi>;QH1lNGQhN7UkOGj0PH62PX61P81oOWim
OGinOh22PhF6QhR7QH9mMg1XH5QABdM6Ad]BG6QePY2MYk2f^KVf/JZRVY::Pgij
N7MgN7UkO7ioP821PH60P81oOgmnOWioOh21PhB6QhR8QhF1O7I^IEeECTU6ATU@
F6AaOhfJYJne^;Vf/JZRVI69PWeiMgIfMgUjO7eoOh20P820P7moOgmoOgmoOh21
PXB6QhV:RXR5PG]cJf9IDT]7ATQ=EF1]NhVGXjfd^;Vf/JZRV927P7]gMGAeMWQj
O7enOgmoOgmoOgmoP820P820P821PX>5QhV:Rh^9QH1iLFQNETi9ATM;DUaYMhFD
X:^c]kRf/JZQV8n6OgUeLg=dMGMjNgenOWmnOWinOWmoP821PH61P821PH>4QXV;
S8f<RHEnMVeTFU9<B4M:D5UULh6@WJVa][Rf/JZQUhj5OGMdLW5bM7MiNgenOWin
OWemOWioP861PX:1PH61PH:4QXR;SHj>SHV3O7=YH5I?BTM9CUIQKgf<VZJ_]KNf
/JZQUhf4O7IbL71aLgIhNgenOWimOGelOGeoP862PX:2PX61PH:3QHR:SHn@T8f8
PWU_IE]CC4U8C5=NJgV8Uj>]];Jf/JZQUhf3NgA`KVi_LWEhNWanOWimO7alO7en
Oh62Ph>3Ph:1PH62Q8N:SI2BTY6=QgmeJf1GCdY9Be5KIgF4Tj2Z/[Fe/JZQUhb2
NG=^K6a]L7AgNWamOWimO7]kNgamOh62PhB4Ph>2PH62PhJ9SI2CU9BAS8AkLFIL
Dde:Be1HI760SibX/;Bd/JZRUhb2N75/JVY/Kg9fNGamOWimO7]jNW]lOX22Q8F5
Q8>2PH61PXF8S92CUYJDT8Z1MfaQF51<BdmFH6elRiVT[K:c/JZRUhb1N71[J6QZ
KG5eNGamOWimO7YjNGYlOH22Q8F5QHB3PX61PXB7RhnCUYNGU8j6OG9WG5A>C4iD
GFYhQiFRZk6c/J^RV8b1N71[J6QZKG5eNGanOWimO7]kNW]lOGn1PhB4Q8B3PX60
PH:5R8b@U9JGUI6;PWQ/HEM@C4aAFFEdPi:OZ[6c/J^SV8f1N71[J6QZKW9fNGan
OgmnOGakNg]lOGn0PX>3Ph>2PH60P863QXV=TIBFUYB?QgebIUaCCTa?EV5_OhjM
Z;2c/ZbSVHf2N71[JFU[KW9fNWenOgmoOWelO7amOWn0PH:2Ph:2PH20Oh21PhJ:
SY:EUYFBRh=hK65GD4a=Dee[NXZIYZjb/ZfTVHj2N71[JFU[Kg=gNgeoP81oOWim
OGenOWmoP861PX:1PH20Ogn0PHB7Ri2CUYJDShQnLVIKDTe=DEYWMXJFXjfb/ZfU
VXj2N71[JFU[KgAhNgioP820OginOWinOgmoP820PH61P81oOgmoP8:5R8fAUIJF
Thb3N6aPETm=CeMSLH:BX:^a/ZjVVhn3N71ZJ6U/L7AiO7n0PH60OgmoOgmoOgmo
OgmoP820P81oOginOX22QHZ?TiJGUI28OW9UFU9>CeAOKGf>WJR_/JjWW923N71Z
J6Q[L7EiOH21PH61P81oOh20P820OgmoOgmoOgmoOgimOGj0PhN<TIFGUiB=PgQ[
GeI@CU=LJGV9VJF]/:jWWI64NG1ZIfQ[L7EjOX62PX:1P820P861PH60OgmnOWin
OgmoOWimO7amP8B9SY>GV9JARGiaIEYBCe5IIGB5UJ:[[jjXWY:5NG1YIfM[L7Ej
Oh:3Ph>2PH20PH62PX61P7mnOGemOWinOWimO7]lOH66Ri6FV9RESX=gJUiEDE5G
HW20T9nY[ZjXWi>6NG1YIVMZKgEkOh>4Q8B2PH61PH:2Ph:1P7mmOGalOGenOWim
NgYjNgj2R8jDV9VHTXUmL6AIDe5EGfalS9^V[:fYX9B7NW1YIFIYKgEkP8>5QHB3
PX61PH:3Ph>2PGmmO7]kO7emOWelNgYiNG]oQH^BUiZJUXj3MVUNEU=EG6QgR9NS
ZZbYX9F8Ng1XIFEXKWAkPHB6QXJ4Ph:1PX>4Q8B3PX1nO7]kNgamOGemNgUhN7Ul
PHR?UIZKVI:9O6mSFUEEFfEcPi:OZ:^XXIJ9O75XI6AWKGAkPHF7R8N5Ph:2PX>4
QHF4Ph1nO7YjNW]lOGemNgUhMgMjOXF<TiVKViJ>PWEXGUMEFF9_OhjLYJVXXYN:
OG5YI6AWK7=kPHF8R8N5Ph:2PX:3Q8F4Ph5oOG]jNW]lOGemO7YiMgMhO868SiFJ
ViRBQg]]HUUEEem[NXZIY:VYXiV<Og=ZIFAWKGAkPHF7R8N5Ph:1PH:3PhB3PX5o
OWakNgalOGinOG]jN7MhNWj4Ri:GVYZES81cIUaFEUaWMXJEXJRYY9Z>P7A[IVEW
KGAkPHF7QhN5Ph:1PH62Ph>3PX60OWelO7amOGinOWakNGQgNGb1QhjDVIZGT8Eh
JemHEUYSLX:BWjNYYIb@PWI/IVEXKGAkPHF7QhJ5Ph:1PH61PX:2PX60OgimOGem
OWinOWelNWUhN7YmPhZAUiZIThYnL6AJEUQPKGf>W:FYYYjAQ7M]IfEXKGAkPHF7
QhJ5Ph61P821PH61PH20OgmnOWinOWioOgimNgYhMgQkP8J=U9RIUXn3MVUNF5MN
JGV9V:>XYYnCQWU^IfEXKGAkPHF7QhJ4Ph60P820PH60P820OgmoOgmnOWmoOgmn
OG]iMgMiO8:9T9JIV9:8NfiRFUMLIWB5U:2WYZ2ER7Y_J6IXKGAkPXJ8R8J4PX60
P820P820OgmoOh20P7moOgmoOgmoOWajN7MgNWj5SI>HVIF=PG=VGEQJHg20T9fU
YZ6GRWaaJFIWKGAkPXJ8R8N4PX60Ogn0P7moOgmoOh20P820P7moOh1oOgekNGMf
Mg^1RI2FVINAQWU[H5YJH6alS9ZSYZ:HS7ibJVIWK7AkPXN9RHN4PX1oOgmoOgmn
OWinOh20PH61P820P820P7ilNWMfMWQmQHfDV9RDRgiaI5aJGfUhR9JPYJ:JSX1c
JVIWK7=kPXN:RHR5PX1oOgmoOgmnOGemOWn0PH:2PH20P820P7mnNgQfMGIjPHVA
UiVFSh=fJEmKGFIdPi:NXj:KSh9eJfMWJg=kPhR:RXR5PX1oOWioOginOGamOGn0
PX:2PX60P821PH1oO7UfM7AgOHB=U9RHTXQlKV=MGFA`OhjJXJ:LTHAgKFMVJg9k
PhR;RhV6PX1nOWinOgimO7alOGj0PX>3Ph:1P821PH60OWYgM7=dNH29TINIUHf1
M6QPGV9]NhZGWj6LThIiKVMVJW5jPXV<S8Z7Ph1nOGinOWimO7]kO7f0PX>4Q8>2
PH61PH:1OgahM79bMWb5SYFIUi66NFaSGf5ZMhJCW:2MU8QjKfQVJG1iPXV<SH^7
Ph1nOGenOWimO7]kO7eoPH>4Q8>2PH61PH:2P7ijMW=bM7V1RY:GV9>:OW5VH61W
Lh:@VinNUXYmLFUWJG1hPHR<S8Z7Ph1nOGenOWinOGalO7eoP8:3Ph>2PH61PH:2
PGmlN7EcLgMmQXjEV9F>PgEYHF1UKgj<V9nNV8aoLf]WJFmhP8N;S8Z7Ph1nOGen
OWinOGelO7enP862PX:2PH60PH62PX1nNWMdLgEjPXZBUiNAQgY]I61SK7Z9UIfO
VHn1MFaXJFmgOhJ:RhZ7Ph1nOGenOWinOWemOGinOh21PX:1PH20PH62PX5oO7Uf
M7AhOXJ?UINCRgmbIf5QJGJ5TYbOVY64MfeYJFifOhJ:RhZ7Ph1nOGenOWmoOWin
OWioOh20PH61PH20P861PX:1OW]gMGAfNh:;TYJEShAgJf=QIW:0SiVNVi>6NFmY
JFifOXF:RhZ6Ph1nOGenOWmoOginOWmoOh20P820P820P821PX:2P7ejMWAeN7n7
SiFFTHQkKfEQIFilRiNMW9B9O75ZJFeeOHF9RhV6PgmmOGenOWmoOgmoOgmoOgmo
P820P820P821PH:2PGmlN7EdMW^3Ri:EThb0LfQSI6ahQiBKW9J;OW=[JVedOHB9
RhZ6PWmmO7emOWmoOgmoOh20P7moOgmoP820P820PH:3PX5nNWIdMGQoR92DU8n4
N6aUHfUePi2IW9N=P7E]JVecO8B9RhZ6PWmmO7amOWmoOgmoP820P81oOgioOgn0
P820PH:3Ph:0O7QeM7IlQ8bCUI68O71WI6QaOhfGViR?PgM^JVacNh>9RhZ7PWml
O7amOWmoOgn0P861PH1oOWinOWmoP820P863Ph>2OWYfM7AiP8V@U9><PGEZIFM_
NhVDVYRAQGU_JfabNX>9Rh^7PgilNgamOWmoOgn0P862PH5oOWemOWioP820P862
Q8B3P7agM7=fO8F=Ti>?QGU^IfI]N8FAV9RBQg]aK6aaNH:9S8^8PgikNW]lOWmo
Ogn0PH62PX60OWemOGioOh20P862PhF4PWiiMG=dNH6:TI>ARGibJVM[MH:>UYRC
RGecKFa`N868S8b8PgmkNWYlOGmoOgn0PH:2Ph:0OWelO7enOgmoP821PhF5Q81l
Mg=cMWf6SY>BS89fKFQZLWj:TiNCRgmeKVa`Mh28S8b9Q7mkNGYkOGmoOgn0PH:3
Ph:1OgelO7enOgmoOh21PXB5QH9nNGAbM7Z2Ri6BSXIjL6UYL7^7TIJDSH9gKfa_
MWn7Rhb9Q7mlNWYkOGmoP820P862PX:1OgimOGenOgmoOgn0PH>5QH>0NgIcM7Qo
QhnBT8UnLf]YKGN4SiFEShAiL6e_MGj5RXb9QH1lNWYkOGmoP820P861PX:1P7mn
OGenOWmoOgn0PH:4QHB2OGUeM7IlQ8bATHb2MfeYK7B0S9BET8IkLVi_M7b4RX^9
QH1mNgYlOGmoP820P821PH61P7mnOWinOWmoOgmoP863Q8B3Og]gM7EiPHV?THj5
NW1ZJg9mRI:ETXUnM6i^Lg^3RH^9QH5mNg]lOGn0P820P821PH61P7moOWinOWmo
OgmoOh22PhB4PGeiMGAgOHF=THn9OWA/JVmjQY2DTX^0MVm^LgZ2R8Z9QH5mNg]l
OGn0P820P820P820P7moOgmnOgmoOgmoOh21PXB4PgmkMgEfNh::Si2;PWM^Jfig
PXfCThb2N75_LWV1QhZ9QX5mNg]lOWn0P820P820P820P7moOgmoOgmoOgmoOgn0
PH>4Q85mNGIeN7n7SI2=QG]aK6edOhZBThj4NW9_LWR0QXZ9QX5mNg]lOWn0P820
P820P81oOgmoP81oOgmoOgmoOWmoPH:4Q8=oNgMeMgb4Rhn>R7idKFabO8N@Thn6
O7A`LGMoQXV9QX9mNg]lOWn0P820P820P7moOgmoP820P7moOgmoOWioP863Q8B1
OGUfMWZ0R8j?RX9hL6e`NHB>TY28OWEaLGInQHV9QX9nNgYlOWn0PH60P820Ogmo
OgmoP820P81oOgmoOWinOh22Q8B3Og]gMGQmQH^>S8EkLVi_Mh6;TI2:P7MbLGIm
Q8V9Qh9nNgYkOGn1PH60P820OgmnOWioP861P81oOgmoOWinOWn1PhF4PGehMWIk
PXV=SHMnMFm_MGj8Si2;PWUcLGElPhR9Qh=nNgYkOGn1PH61P820OgmnOWioP861
PH20OgmoOWinOWj0PhF5PgmjMWIiOhJ<SHV2N75_Lgb6SHn<Q7]dLWAkPXN9R8=n
NgYkOGn1PX61P820P7mnOGenOh61PH60OgmoOWimOGioPXB5Q85lN7EgO8>:SH^4
O7A`LWV3Rhn=QWeeLWAjPHN9R8AoNgUjO7n1PX:1P820P7mnOGenOh21PX60P7mo
OginOGenPH>5QH=nNGIfNX27S8b7OgIaLWN0RHj=QgmgLgAiP8J9R8B0NgYjO7n1
PX:1P820P7mnOWenOh21PH60P7moOginOGenP8:4QHB0NgMfN7j5RXb9PGUcLGEn
Qhf=RH5iM7=hOXF8R8F0O7YjO7n0PH61P820P7moOWinOh20PH61P7moOgmnOWen
Oh63QHB2OGUgMgb2R8^:Q7adLGAkQ8^=RX=jMGAgOHB8R8F1OGYjO7j0PH61P820
P7moOWinOgn0PH60P81oOgmoOWinOX22Q8B3Og]hMgZ0QX^;QWigLW=iPXV=RhAl
MWAfO8:7R8J1OG]kO7j0PH61P820P7moOginOgn0P820P81oOgmoOginOWn1PhB4
PGeiMgUnQ8V;R85iLg=gOhN<RhInMgAfNh66R8J2OW]kO7j0PH61P81oOgmoOgmo
Ogn0P820P820OgmoOginOWj0PXB4PWmkN7QlPHN:RH=kMG=fOHF;S8N0NGEfNX25
QhJ2OWakO7j0PH61P81oOgmoOgmoOgmoP820P820P81oOgmnOWioPH>4Ph1lNGQj
OhF9RHEnMg=eNh>9RhR2NWIeNGn4QhJ3OgakO7j0PH61P7moOgmoOgmoOgmoOgn0
P820P820OgmoOWinP8:3Q89nNWQiOH>8RHN0NGEdNH68RhV3O7MfNGj3QXJ3Ogak
O7j0PH61P7moOgmoOgmoP81oOgmoOh20P820P7moOWinOh63Q8>0O7UiNh66RHR2
O7IeN7n6RXV5OWQfN7f3QXJ3P7akO7j0PH61P7moOgmoOgn0P820OgmoOgn0P820
P81oOginOX22Ph>1OWYiNWn4R8R4OWQeMgf4RHV6OgUfN7b2QHJ4P7ekO7j0PH61
P7moOgmoOgn0P820OgmoOgn0P820P820OgimOWn1PhB2Og]iNGf2QXR6P7YfMW^2
QhV6PG]gN7b1QHJ4PGekO7f0PH:1P7moOgmoOgn0P820P7moOgmoP820P820Ogin
OGj0PXB3PGejNG^0QHN6PWagMWZ0QXR7PWahN7^0Q8J4PGekNgeoPH:1P7moOgmo
Ogn0P820P7mnOWmoP820P820P7mnOGeoPH>4PWmkNGYnPhN7PgiiMgUnQ8R7Pgei
N7YoPhF5PGilNgeoPH:1P7moOgmoOgn0P861P7mnOWioOh20P820P7mnOGenP8>4
Ph1lNWYmPHF7QH1kN7UmPXN7Q7mjN7YnPhF5PWilNgeoPH:1PGmoOgmoOgmoP821
P7moOWioOh20P820P81oOWenOh:3Ph5nNgYlP8B6QH5lN7QlPHJ7QH1kNGYmPXF5
PWmlO7eoPH:1PH1oOgmoOgmoP820P81oOgioOh20P820P81oOWemOh62Ph9oO7Yk
OX:6QX=nNGQjOhB7QH5lNGUlPHB5Ph1mO7anP861PH1oOgmoOgmoP820P81oOgmo
Ogn0P820P81oOgimOX22Ph:0OG]kOH64QXAoNgQjOX>6QX9mNWUlP8>4Ph1mO7en
P861PH1oOgmoOgmoP820P81oOgmoOgn0P820P820OginOWn1PX>1OWakO823QHB1
O7UiOH:5QX=oNgYkOh:4Ph5nO7enP861PH1oOgmoOgmoOh20P81oOgmoOgmoP820
P820OgmnOWn0PX:2OgekO7j2QHF2OWYiO824QXB0O7YkOX:4Ph5nOGenP861PH1o
OgmoOgmoOh20P81oOgmoOgmoOgn0P820P7mnOWioPH:2P7ilNgf1Q8F3Og]jNgn3
QHB1OGYkOX63Ph5oOGenOh61P81oOgmoOgmoOh20P81oOgmoOgmoOgmoP820P7mo
OWioP8:2PGmmO7eoPhB3P7ajNgj2QHB1OW]kOH23Ph9oOGenOh21P81oOgmoOgn0
P81oOgmoOgmoOgmoOgmoOh20P81oOWinOh62PX1mO7anPHB4PGikNgf1Q8B2Ogak
OH22Ph:0OWenOh21PH1oOgmoOh20P81oOgmoOgn0P7moOgmoOh20P81oOginOh21
PX5nOGanP8>4PWmlNgb0PhB3OgakO7n2Ph:0OWenOh21PH1oOgmoOh20P81oOgmo
Ogn0P81oOgmoOgn0P820OginOX21PX5oOGamOh:3PX1mNgaoPXB3P7elO7n1PX:0
OWenOh21PH1oOgmoOh20P820OgmoOgn0P81oOgmoOgn0P820OgmnOWn0PH60OWem
OX63Ph5nO7anPH>3PGilO7j1PX:0OgenOh21PH1oOgmoOh20P820OgmoOgn0P820
OgmoOgmoP820P7mnOWn0PH61OgemOX22Ph5oOGanP8:3PGmmO7j0PX:1OginOh21
PH1oOgmoOh20P820OgmoOgn0P820OgmoOgmoP820P7moOWioPH61P7imOGn1PX:0
OGamOh:2PGmmOGj0PH:1OginOX21PH1oOgmoOh20P820OgmoOgn0P820OgmoOgmo
Oh20P81oOWioP861P7mmOGn1PX:0OWemOh62PX1nOGeoPH:1OginOWn0PH1oOgmo
Ogn0P820OgmoOgmoP820P7moOgmoOh20P81oOgioP861P7mnOGj0PH:1OgemOX22
PX1nOGeoP861P7inOWn0P820OgmoOgn0P820OgmoOgmoP820P7moOgmoOgn0P81o
OgioOh21PH1nOWioPH:1OgimOX21PX5oOWeoP861P7mnOWn0P820OgmoOgn0P820
OgmoOgmoOh20P7moOgmoOgn0P820OgmoOh20PH1oOWioP861P7imOWn1PH5oOWin
P861P7mnOWn0P820OgmoOgn0P820OgmoOgmoOh20P7moOgmoOgmoP820OgmoOgn0
P81oOWioP861P7mnOWn0PH60OWinOh21P7moOWn0P820OgmoOgn0P81oOgmoOgmo
Ogn0OgmoOgmoOgmoP820P7moOgn0P820OginOh21P7mnOWn0PH60OginOh21P7mo
OgmoP820OgmoOgn0P7moOgmoOgmoOgmoOgmoOgmoOgmoOh20P7moOgn0P820Ogin
Oh21P81oOWn0P860OginOh20P81oOgmoP820OgmoOgn0P7moOgmoOgmoOgmoOgmo
OgmoOgmoOh20P7moOgmoP820OgmoOh20P81oOWmoP820OgmnOh20P81oOgmoP820
OgmoOgn0P7moOgmoOgmoOgmoOgmoOgmoOgmoOgn0P81oOgmoP820P7moOgn0P81o
OgmoP820P7moOgn0P81oOgmoP820OgmoOgmoP7moOgmoOgmoOgmoOgmoOgmoOgmo
OgmoP81oOgmoOh20P7moOgn0P81oOgmoP820P7moOgn0P81oOgmoP820OgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoP81oOgmoOh20P7moOgn0P820OgmoOh20
P7moOgn0P81oOgmoOh20OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgn0P7moOgmoP820OgmoOh20P7moOgmoP81oOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgl\>"]},
  ImageCacheContents->"Sound",
  CellTags->{"HarmonicWow", "G.3.3"}],

Cell[CellGroupData[{

Cell["Implementation", "SubsubsectionIcon",
  CellTags->{"HarmonicWow", "G.3.3"}],

Cell[BoxData[
    \(\[Psi][{\[Alpha]_, \[Beta]_}, \[ScriptCapitalA]_, f_] := 
      If[\[Beta] > \[Alpha], 
        If[\[Alpha] < t < \[Beta], 
          Sin[\(\[Pi]\ \((t - \[Alpha])\)\)\/\(\[Beta] - \[Alpha]\)]\ \
\[ScriptCapitalA]\ Sin[f\ t], 0], 0]\)], "Input",
  CellTags->{"HarmonicWow", "G.3.3"}],

Cell[BoxData[
    \(Play[
      Evaluate[N[
          Sin[\(\[Pi]\ t\)\/2]\ \(\[Sum]\+\(i = 0\)\%24 \[Psi][
                {i\/12, \(i + 4\)\/12}, \@\((\(i - 24\)\/12)\)\^2, 
                1000\ \((i - 12)\)]\)]], {t, 0, 2}, PlayRange \[Rule] All]
      \)], "Input",
  CellTags->{"HarmonicWow", "G.3.3"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ", "GroupDivider"],

Cell["Electronic Chimes", "Subsection",
  CellTags->{"ElectronicChimes", "G.3.4"}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.0238095 0.952381 0.0147151 0.588604 [

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

% Start of sampled sound

1 string

11025 22050 8

{ currentfile 1 index readhexstring pop }

 false 1 sampledsound

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8C8C8C8C8C8C8C8C8C8C8C

8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C

8C8C8C8C8C8C8C8C8C8C8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8C8C8C8C8C8C8C8C8C8C

8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8D

8D8D8D8D8D8D8D8D8D8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D

8D8D8D8D8C8C8C8C8C8C8C8C8C8C8C8C8C8C8B8B8B8B8B8B8B8B8B8B8B8B8B8A8A8A8A8A8A8A

8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8B8B8B8B8B8B8B8B8B8B8B8B8C8C8C

8C8C8C8C8C8C8C8C8C8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8C8C8C

8C8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A

8A8A8A8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C

8C8C8D8D8D8D8D8D8D8D8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8D8D8D

8D8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8A8A8A8A8A8A8A8A8A89898989898989898989898989898A8A8A8A8A8A8A8A8A8A8A8A

8A8A8B8B8B8B8B8B8B8B8B8B8B8C8C8C8C8C8C8C8C8C8C8C8C8C8C8D8C8B8A8A8A8A8B8D8E8F

9090908F8D8C8B8A8A8A8A8B8D8E8F90908F8E8D8B8A8989898A8B8C8E8F8F8F8E8D8B8A8988

88898A8B8C8D8E8E8E8D8C8B89888888898A8B8D8E8F8F8E8D8C8B898988898A8B8C8E8F8F8F

8F8D8C8B8A8989898A8C8D8F9090908F8E8C8B8A89898A8B8C8E8F8F908F8E8D8B8A89888889

8A8C8D8E8F8E8E8C8B898887878788898B8C8D8D8D8C8B89888686868687898A8B8C8C8C8B8A

88878685868688898B8C8D8D8C8B8A8987878687888A8B8D8E8F8E8E8D8B8A898888898A8C8D

8F9090908F8E8D8B8A8A8A8B8C8E8F91919291908E8D8B8B8A8A8B8D8E90919191908F8D8C8A

8A898A8B8C8E8F9090908F8D8B8A88888888898B8C8E8E8F8E8D8B8A8887878788898B8C8D8E

8E8D8C8B8988878787888A8C8D8E8F8F8E8D8B8A888888898A8B8D8F9090908F8D8C8A898889

8A8B8D8E909090908F8D8B8A8988898A8B8D8E8F908F8E8D8B8988878787888A8B8D8E8E8D8C

8B89878685858687898A8B8C8C8C8A8987868584858687898B8C8D8D8C8B8987868585868789

8B8D8E8F8F8E8D8B8A888888898B8D8F90919291908F8D8C8B8A8B8C8D8F919393939391908E

8C8B8B8C8D8E909293939392908E8C8B8A898A8B8D8E909191908F8D8B8988878788898B8C8E

8E8E8D8C8A888685858586888A8B8D8D8D8C8B89878685858687898B8C8E8E8E8D8B8A888786

8788898B8D8F9090908F8D8B8A8988898A8B8D8F919191918F8D8B8A8988898A8C8E8F919191

8F8E8B8988878787898A8C8E8E8F8E8C8A88868584848587898A8C8D8D8C8A88868483838385

87898A8C8D8C8C8A88868584858687898B8D8F8F8F8E8D8B89888888898B8D90919393939190

8E8C8B8B8C8D8F91939595959493918F8D8C8C8C8E90929394959493918F8C8B8A8A8A8C8D8F

919191908F8C8A8886868687888A8C8D8E8D8C8B8886848383838586888A8C8C8C8B89878583

83838486888A8C8D8E8D8C8A898786858687898B8E8F9091908F8D8B898888898A8C8F919293

9392908E8C8A89898A8B8D8F91929292908E8C8988878788898B8D8F8F8F8E8D8A8886848484

8587898B8C8D8C8B898785838282838486898B8C8D8D8B8A88868484848587898C8E8F90908E

8D8B898888888A8C8F919394959492908E8D8C8C8C8E9093959697979694918F8E8D8C8D8F91

939596969593918E8C8A89898A8C8E8F919191908E8B89878584848687898B8C8D8C8B898684

82818181838587898B8B8B89878583828181838587898C8D8D8D8B89878684848587898C8E90

9192918F8D8B898888898B8D909294949493918E8C8A89898A8C8E9193949493918F8C8A8887

87888A8C8E9090908F8D8A87858483848587898B8D8D8D8B898784828181828486898B8D8D8D

8B89878584838485878A8D8F9091908F8D8B898888898A8D90929496969593918F8D8C8C8D8F

9294969898989694928F8D8C8C8D8F91949596969593918E8B8988898A8B8D8F9191918F8D8A

87858382838486888A8C8C8B8A878582807F7F80828487898A8A8A88868381807F8081848789

8C8D8D8D8B898785848485878A8C8F919292918F8D8B8988888A8C8F919495969594918F8C8B

8A8A8B8D909294959594928F8C8A888787898B8D8F9191918F8D8A878583838485878A8C8D8E

8D8B8986848281818284878A8C8D8E8D8B89878483838385888B8E909192918F8D8B89888889

8B8E91949697979593918E8D8C8C8D8F9295979999989694918F8D8C8C8D8F92949697969593

908C8A888787898B8D8F9091908E8C8885838181828385888A8B8B8A888683807E7D7D7F8184

86888A8A89878582807F7E7F8184878A8C8D8E8D8B888684838385878A8D9092939392908D8B

8988898A8D90939597979694928F8C8B8A8A8C8E919496969695928F8C8A888788898C8E9092

9292908D8A878583838486888B8D8F8F8E8C8986838181818285888B8D8E8E8D8C8986848383

8486898C8F919292918E8C89878686878A8D909394959593918E8C8A89898B8D909396979796

94918E8C8A898A8B8E919395969694918E8B89878687898B8E909192918F8C89858381818284

878A8C8D8D8C8A8784817F7E7E808285888A8B8B8A888582807E7E7F8184878A8C8E8D8C8A87

858382828486898D8F918E8D8C8A8785838385888A8E919496969593918E8C8A8A8B8D909396

9899999895928F8D8C8C8D8F929597999A999794918E8B8A8A8C8E91949697979694918E8B89

88898A8D909395969694928F8C898787888A8D909395969594918E8B8988888A8C8F92959797

9694918E8B8988888A8D909395969694928F8B88878686888B8E909292918F8C898582818081

8385888A8C8C8A8885817E7B7A7A7B7D808385868684827E7B78767576787B7E818384848380

7D7A787777787B7E82858788888684817F7D7C7D7F83868A8D8F90908E8C8987858586898C90

939698989795928F8D8C8C8D9093979A9C9D9C9B9895928F8E8E8F9295989A9C9C9B9995928F

8C8B8C8D9093959899989794908D8A888788898C8F92949594928F8C8986848485888B8E9193

9392908D8A8785848486898C8F92939492908D8A87858585888B8E9193949492908C89868484

85878A8E90929392908D89868382828385888B8E8F8F8E8B8884817E7D7E808286898B8C8C8A

8784817E7C7C7D7F8286898B8C8C8A8784817F7E7E8083878A8E9091908F8C8987858485888B

8F93969899989693908E8C8C8E9094989C9EA0A09E9C98959391919395999C9FA1A2A19E9B98

949290909294979B9D9E9E9C9995918E8B8A8A8C8E919496969593908C888482828284878A8D

8F8F8E8B8884807D7C7C7D808386898A8B898784807D7B7A7B7D8083878A8B8B8A8784807D7C

7B7D7F83868A8C8D8D8B8885827F7E7E7F8286898C8E8F8E8B8885817F7E7E8083878A8D8E8E

8D8A8683807D7D7E8083868A8C8D8D8B8884817E7C7C7E8084888B8D8E8D8B888582807F8082

85898D90929392908D8987858586898D9195989A9A999693908E8C8C8E9195999C9FA09F9D9A

97949190909295989C9FA1A1A09D9A96928F8E8E909396999B9C9C9A96928E8A888787898C8F

92949493918D8984817F7E7F8285888B8C8D8B8985817F7C79797A7D81868A8C8C8A86827D7A

797A7C7F8386898B8C8C8B898784817F7F8082868B90939594928E8986838385888C90939596

969593918E8C898888898C9094989A9B9995908B878686888C8F939597979593918E8B888786

86888C8F93969897948F8A86838384888C909496969694918F8C8A8988888A8D9195989B9B9A

96928D8A88888B8F94989B9D9C9A9895928F8D8C8C8D8F9295999B9C9B98948E8A868586898D

9195969694918D898683818081828486898B8D8C8A86817C777575777B7F8386878683807C78

7674747476787B7E81848584827E7A76737374787D83888A8B8A8784807E7C7C7E8083868A8D

909292918F8B87848283868A9095999B9A9894908C8A898A8B8E919496999A9A9997938F8B88

87888B9094999B9B9995908B88868586898B8E9193949594928F8B8784828284888C91959796

938E8A8683828385898C909294959594918E8B88858586898E93989B9B9996918C888787898C

9093969899989795928E8B888686888B909497999894908A8582808183878B8E9090908E8C89

85827F7D7C7D7F83878B8E8F8D89847E7A78787B7E83878A8C8D8C8A888582807E7E8486898E

9296989895918C87848384888C91959899989693918E8B8988888A8D9195999C9C9B97928D89

8787898D92979A9C9C9A9794908D8B8A8A8B8D9094979A9C9B99948F8A868586898D92969999

9895918D8987858585878A8D9093959594908B86817E7E8084898E919392908C8783807F7E7F

808386898C8E8F8E8C88837E7A79797D82878B8E8F8D8A85817D7B7A7B7D7F8285888B8D8D8B

88847F7B79787B7F848A8E90908D8984807E7C7D7F8185888B8E9090908E8A86827F7D7E8287

8D92959695918D8884828283868A8D909395969594918D8985838385898E94989B9A98938E89

868585888B8F92959798979693908C88868485888D92979A9B9A96908B86848485898C909395

969694928F8B8884828284888C9196989895908A85817F8083878B8F929393918F8C89858280

7F8083878C91949694908B85817E7E8084888D91939392908D8A878482818284878C91959797

95908B8581808184898E9396979694928E8B88868585878A8E92979A9B9A97918C878484868A

9095999B9B9A9793908D8A89898A8C9094989B9D9D9B96918B878586898E93989B9C9B989490

8C8A8887888A8D909497999A9895908A85818182898F94999B9A9894908B88868586888A8D91

9496989795918B8682808083888E93979E9C98928C86827F7E7F808285888A8C8D8C8986827F

7D7E81878D949A9D9D9B96918B878483838486888A8B8C8C8B8885807C7A797A7F858D94999C

9C9995908C8988898B8D9092939493918F8A86817C79797B80868D9397999894908C8988898C

8F9396999A9A9895918C87827D7A7A7C81868C9092928F8B8682818184888E9397999A9A9895

908B86817E7C7C7E82868A8C8C89857F7A7776777B81878D91939494928F8B8783807E7D7F81

85898B8B89847E78726F6F71767C83888C8E8F8E8C8A888584828284878B8F9293928F89827B

757273767B81878B8E8F8E8D8B89888787888A8E92979B9FA09E99938C85807E7F83888D9194

9594928F8D8B8A8A8B8E92979CA1A6A9AAA7A39D96908D8C8E92969B9D9E9C9995908D8A898A

8C8F93989EA3A7A9A9A7A29C9793919295999EA1A3A19E98928C8784838385888C9195999C9E

9D9A96918D8B8B8E93999EA1A19E99928B85807D7C7D7E8184878B8D8E8E8C8985817F7E8186

8D93999C9B98938C85807C7A7A7B7D7F818385858582807C797776787D848B93989B9A97918A

84807D7C7D7F81838586868583807C78747373767C838C93989A9996918C87858486898C8E90

91918F8C88837E7A767475787E858C92969795928D898686888C9095989A9A9996928D88827D

7977787B80868B9091908D8883807F81858A90969A9C9C9A96928D88827E7B7A7A7D8186898B

8A87827C777474777D848B9195979795928E8A86827F7E7E8083878A8C8C89847D7772707075

7B82898F939494928F8C8A87868687898C9093969795918A837D7876787C838A909497979593

918E8D8D8E9093969BA0A4A6A6A39E98908A8685878C92989D9F9F9D9A969392919294979CA1

A6ABAEB0AFACA7A09994919194989EA2A5A5A29E9893908D8D8E9195999EA3A7AAABA9A6A09A

95918F91959A9FA2A2A09B958E888481818285898D919598999997938E88848383878C929699

98958E87807A75737476787C7F8284868684817D78747273767B82888D8F8E8A847D76716F6E

707376797C7E7F7E7D7A77726F6C6B6D727981888D8F8D89837D787575767A7E828587878785

827F7A76737171757A8189909495938E8984807F81858A8F9396979795928E8A85817E7D7E82

878E94999B9B97928C8886868A8F959B9FA2A2A19E9A96918D898686878B9095999C9C98938D

87838183888E949A9EA09F9D9A96928E8A878687898D9195989896918A827C79787B80878D93

969795928F8B888584838486898D92959795918B837C767374787D848A8E908F8D8A80828588

88878584868B929AA0A19C93867B737278818C959998938C86838386898C8C8C8B8C8F969FA7

ABABA49A8E8580838A959FA5A7A39B938D8A8A8D8F9191909091979EA7ADB0ADA59A908A898F

98A3ACB0AEA79E958F8D8D8E90908E8D8C8F949BA2A7A6A1988E8682858E99A4ABACA8A0968E

88868687878683818183888D929390887F75707076818D979D9C978E867F7B7B7C7D7C7A7876

76787D8183817B7268605E616A77838C908E88807A767577797B7B7A7878797C8082827D756B

625C5C626D79848B8D8A847D79787A7E8285868687888B8F9293908A80766E6A6D75808B9396

95908A848283868B909496989A9EA2A6A9A8A49C91888281858D979FA3A39E978F8A888A8E92

979A9DA0A3A8ADB1B3B0AAA298918D8F959DA5A9AAA59D938B868485888C8F9294989CA1A6A9

A9A59F978F8B8B90979FA6A7A49D9388807B797A7B7D7F8183868A8F9294928E87817D7C8189

929A9F9F9A92887E7773727374757576787A7E8183837F7A74706F737B86919A9E9D978F8780

7C7A7B7B7C7C7C7D7E80838484807B746F6C6F76818D989FA2A09B948F8B8A8B8D8E8F8F9090

929394938F888078737277808B97A0A5A5A29C98959496999C9FA0A1A2A3A5A6A5A19A91867E

79797E87919A9FA09D98928F8E9093989C9EA1A3A5A7A9AAA8A2998E837B77797F878F949491

8A837D7A7B7E83878C8F9295999EA1A29F998F847B75757980878C8D8A8279706B686A6D7276

7A7D81868B919596948E857C7675788088909390897F756C6766686B6F726A6C6F747A808485

827C756F6E7179848E959792897E746C69696B6E70727374787D83898C8C88827D7C7F8794A2

ADB4B4AEA59B928E8D8E91939493929294989DA0A09D97908C8C939EADBBC6CAC8C1B7AEA8A6

A7AAACADABA8A5A4A4A5A6A5A19A908883848B97A6B2B9BAB5ACA29B97989B9FA2A29F9B9795

9494928E857A6E6560626A76838C908D857B736E6F737A80848583807E7E7E7F7C776D61554D

4A4F58646F75756F665C56555A626C747A7C7D7D7E818486857F766B615C5D646F7B83858178

6D64606269747F888D909294989DA2A5A49F978E87868A939FA8ADABA295887F7B7E869099A0

A3A4A5A7ACB1B6B9B7B2AAA29FA0A7B2BDC4C4BDB0A0928885888F969C9F9E9C9B9CA0A4A8A8

A59F98939398A2AEB8BDBAB0A191837C7B7E858A8D8C8884828284878988837D78767A83919E

A8ABA79C8D807672757B828687847F7A777678797976716B6869717D8C9AA3A59F95897F7A7C

828B929796928D8884848484817C76706E717A8896A2A8A7A0958B85858B949FA6AAA9A49E99

969594918C857D777579838F9AA2A39E9489807D8089959FA7A9A7A39E9A979694908A827A75

7479818C939692897D726B6A717B8892989A9895918F8F8F8D8A847C7673757B848C908E867A

6D635E60687480898E8F8D8A89898A8C8B8984807D7E828A93999A958A7C6F666367707C868C

8F8E8B89898A8C8E8E8C8987888C949DA4A8A69E918276706F747D868D908F8C888584858687

86848383878E97A1A7A8A4998C7F7672747B838A8E8E8A85807C7A7A7A7A7877777A8089939C

A1A19B90857B76777C848D9395928D87827F7C7B7A797776787C848F99A0A3A19A9088828288

909BA3A8A9A6A19B979491908E8B89898B919AA3ABB0B0ABA29A9392969EA9B3BBBFBEBAB5B0

ACA9A6A3A09D9A9A9DA2AAB1B5B4AFA79C948F90969FAAB2B8B9B7B2ADA9A5A29F9B97939191

959A9FA3A39D94887D7572757C858E959796938E8A8784827F7C797677797E84898A877E7366

5C56565B646D74787976736F6D6C6B6A686766676B717980858580766A6059575B626C747A7C

7B78747271717171717172777E8791999D9B958B807875777E879097999895918D8B89898887

8686898E97A1ABB1B2ADA49A908B8B9099A2A9ADACA8A29C989492908D8A8887898F98A1A8AB

A8A0958A8280838B959DA3A4A09A938D898683807C787574777D858D91908A7F736965666D78

838B908F8B857F7B79787774706D6B6C7178818789857C70655E5D636D7A868E91908C878484

84868685838181858C959DA2A19A8E827773757E8B98A2A7A8A4A09C9B9C9FA1A2A1A09FA2A7

B0B9BFC1BCB2A4968D8B8F99A5B0B6B7B3ADA6A2A1A3A5A7A7A6A5A5A9AFB8C0C5C3BBAE9F92

8A8A909BA5ACAEAAA298908C8B8C8E8E8D8B8A8B9098A1A9ABA79C8E80767376808B9599978F

857A726F6E7071716F6D6C6F76808A90918C81746964666F7C89939591887D736D6B6C6E6F6E

6C6A6A6F7780898E8D857A6F6868707E8D9BA3A49E948A827E7E808282807C7A7B7F878F9596

91877B716D717D8D9DA9AFADA69B928C8B8D9091908D8986878B919698948B7E7168666D7A8B

99A3A5A0978E868385898D8E8D8A8785878B909391897D6E615A5B6472828E94938C827A7576

7A81878A8A8988898D929799948B7D6E635F636E7D8A939590867D7674777E878E929394969A

A0A7ABACA69B8D8179787F8B98A2A6A39A8E837D7C818991979A9C9EA1A7AEB5B9B8B1A6998F

8B8E97A3AEB4B3AB9D8F847D7D81888E92939495999FA6ACAEABA3988E8889909BA7B0B2ADA1

9283787272767B7E807F7F8083898F93938F877E78777D8896A3ABABA497887B737072767A7C

7B7A78797C808486847E77706E727D8C9CA9B0AFA79B8F858182858A8D8E8C8A8888898B8C8A

857D757172798797A6B1B6B2AAA0969191959A9FA2A2A09D9A999897948E857B726F717A8796

A2A9A9A39A908A888B92989EA1A09E9C9A9896928C82776B6360646D78848B8D8980776F6C6D

737C848B8E90908F8F8F8D8981776C625C5C616B757D807D756B625C5C6069737C84898C8F91

949695928B827A7473767E889094928B81756C68696F78828A91969B9FA4A8AAAAA7A29B9695

989FA9B2B7B7B1A6998D848182878E949A9EA1A4A8ACAFB0AEABA5A19FA2A9B2BDC4C7C3B9AB

9D90888585888C8F90909191939494938F8A8582848A95A0ABB1B1ABA092857B767576787A7A

797775757473716C67615D5D636D7B8893989790867C746F6F7275797A7A78767473726F6A64

5C565457606D7C8A9397948E86807D7E838A9195989897969594918D867D746E6D717B8996A1

A7A6A199938F91969FA8AFB4B6B7B7B6B6B4B0A9A0958B848388929DA6ABAAA49A9089878B92

9CA4ABAFB1B2B2B3B3B1ACA4998D847F7F858E969B9A9286796E67676C747D858A8D8F909395

9696918A8077706F747C868D8E887D6E6055505258616A707375777A7E828586837D76717075

7F8B969D9C94867669615F636B737A7E7F808184888D90918E8985848993A1B0BBC0BDB3A495

8A85868C949A9D9D9B9998999C9E9F9D9893909199A6B6C5CED0CABEAFA199989BA2A9ADADA9

A39E9A999999969089827F828B99A9B6BDBBB2A4978C888B929BA2A4A19B948E8A8886837D75

6B646266717F8E989B968A7D716C6D75808B9395928C85817E7D7B7770675E57575D6977848A

898073665E5D64717F8C9395938E8A88888887847C736B6769717D8992938D80716560626C7B

8A959B9C99959393959796928B837D7B7F89949EA19D91817165626672808E96999793908F90

939695928C8582848B96A1A7A79E8E7C6C63616874828C91908C87838385898C8C8884818187

929EA8ADA99E8D7C6E686B74818D9495918B85818285888B8A8885858993A0ADB7B9B4A79788

7F7D84909CA6AAA8A199928E8E909293918E8C8E95A0ADB9C0C0B7AA9B8F8A8D97A4B0B7B7B2

A89E9793929292908C888689909BA7B0B3AEA395877F7F8793A1ABB0ADA59B918A878685837F

7A767578808A9398968E817369656A7584929B9E9A9288817C7A7A7A7875716E6F747C858B8D

887D6F635D5E667585929A9B979089848283858686848282858C959CA09D94887A706D727D8C

9BA5AAA9A39C96949496999B9A9A9A9CA1A8B0B4B4ADA193867D7C838E9BA6ACACA79F97918F

8F919394949495999FA6ACADA99F908276707279848F959691897F76706E6E6F70717172757A

81888C8B84786B5F57565B6570787C7A72695F57535252535455575A60676F7679766F655A53

5257616E7A828480797069646262636567686C717881898E8F8A837A737175808E9CA8AEAFAA

A39C97949394959798999DA2A9B0B5B7B3ACA29995969EAAB9C6CED2D0CAC3BCB8B6B6B6B7B6

B6B8BABFC4C7C7C3BAAEA2999699A1AEBAC3C7C6C1B9B2ADAAA9A8A8A8A7A7A9ACAFB2B3AEA5

988A7D757479828D969B9B978F88827E7D7E7F80818284888D9295948E8375675D595B636E78

7E807D766E68646365676A6C6F737880888F92918A7F726862636A7580888C8A847C746E6C6D

6F7274777B8088929BA2A5A29A8F857F7E848E9AA5ABAAA59B918984828283848586898E969F

A7ACACA69D928A878B94A1AEB6B8B4AB9F948C8885858482818081858C93989A958C81777173

7B8897A3AAA9A3988D847E7B7B7A7976737273777C828481796E6259575D6A7A8A959A989187

7E7977797B7C7B797676787C8185847D72655952535D6C7E8D9698948C847E7D80858A8D8D8C

8B8C90959A9B978D7F706460646F7F8F9A9F9C958C8582848A92989B9C9D9EA1A6ACB0AFA89B

8A7B716E74808F9BA19F988C827B7A7F868E95989A9B9EA4ABB2B5B3AA9C8C7F7879828F9CA4

A49D91837872737880888E9192959AA2ABB2B6B3AA9D9087858B98A6B1B5B1A696877C77797F

868C8F9192949AA3ACB3B5B1A89D939094A0AFBEC7C8C0B1A0918783868B909393919091969D

A5A9A8A2988E888993A2B3C2C8C6BBAA998B838285898C8B87827E7E80858888837A6F666469

76889AA7ABA69A8A7B716E70757A7B78736D6867686A6A675E534841424C5C70818C8E887C6E

65615F666F767876716C69696A6B6962584B413D414E6073828A8981766C676A737F8B939797

94929193949490887C6F67656B798A9AA4A6A0958981808B9098A2ADB7BFC4C5C4C0BAB3ABA4

9D9997989BA1A7ABADABA69E958E8A8A8F98A3AEB7BEC1C1BFBAB5AEA7A19C9997989B9FA1A2

9F988D81766D68686D757F899196989794908C88848180808285898D8F8D887F736659504C4D

535B656E7477787673706E6D6E7074797F868D92959590877C70665F5D5F666F777E8283817E

7B7878797D838A939CA6AFB6B9B9B5AEA49A938E8F939AA1A8ABABA8A29B95918F90949AA2AB

B5BEC6BEC1C1BFAFACAAAAAEB5BFC9D2D6D6D1C7BAACA096908E8F9399A1A9B1B9BEC0BFBAB3

AAA29C99989A9C9C9A93897D70645C58585C646D7680888F9495948F88817A7574777E879097

9B99948B80766D67636261605F5D5A56514B453F3A37373B4553647687949B9D999289807975

7475777A7C7D7E7E7D7B7876737272757C848E989EA19E968B7F746D696B7079828B93989C9D

9C99948F8A86848589919AA3AAAEAFACA8A3A0A1A5ACB5BDC4C8C7C2BAAFA19385776C635F60

656E78838C929493908D8C8E939BA4ADB3B7B6B3ADA69F98918D8A898B90969DA3A6A59F9487

796C636061676F7881878B8C8C8B8A888685868A8F94999C9D9A958D847B747071767E8A98A5

B1B9BDBDB8B0A69C938C88868788898A88858079736D6A6A6D737C869199A0A2A19D97908A85

85888E97A2ADB6BCBEBCB6ADA2968C837E7A7979797977736E67615D5B5C616975818E98A0A3

A29C93897E756E6B6C717880878D91918F8B86817D7C7D7F84898C8E8E8A847B7269635F6064

6B757F898F93928E877E756E69696C727C87919BA2A7A9A9A8A6A6A7ABAFB4B9BCBDBAB3A89B

8D7F736B68696E77828D979EA2A3A09B96918E8E91969DA4ABB0B2B2AFABA6A19E9D9FA4AAB0

B5B8B7B2A99E9083766D68676B727B848D939695928C857E797676777A7E8182827E79736D69

67696E77828E99A2A8A9A59E93877B70696564676B7176797977736D6762605F62676E767C81

8483817C787574777D8794A2B0BCC5C9C8C2B9AEA3988F8A88898C9093969695928E8A88888B

9098A1ABB2B7B9B7B2AAA198928F90959DA8B4BFC8CDCECCC6BEB5ADA7A3A2A3A5A8AAAAA7A2

9C948D878382858A90979DA09F9A92877A6E635C595B616A75808A92969795918D8885848587

898B8B89837B716559504946474C5349525A5F61605B564F4B494A4F5863707C879095969490

928F89807C7F878E908A7E7168625E584F494954677C8D979B9EA2A7A8A4998D85868E979E9E

9B99999C9D999086828692A0ABB0B1B3B6BABBB5A99B92929BA7B1B7BBC0C7CFD3CDBFAC9C92

8F8E8B857E7B7D828582796E686A74818D969EAAB9C9D3D4CABBADA39F9C978F89888E979D9C

9283766E6A67625B55545C6770736E665F5E62676B6C707A8CA1B4BEBEB8B0ABA69F93847771

737D868A87827E7E80807C746E6E7684919897938F8E8E8B83786F6F78889AA7AFB3B9C0C6C6

BEB1A299989EA4A6A5A2A3A6ABACA69A8E898C959FA6A8A8ABB0B4B2A796847874777C808387

909DABB3B2A99D94919293918C898B929A9D998D8078767A7E8181848C99A7AEAB9F8F80756D

655A4E4748515E686B6863606266686764646B798A979C9A949090908E88807B7F8A98A3A6A1

988F888074624D3D3639424C5154575E68747B7D7C7D8696AABBC5C8C9CACBCAC1B19D8A807E

83878987878A90949288796B65666D7377797E87939FA4A1999290959DA4A7A8A9ADB4B8B3A5

917C6E666462605F636F81939FA29F9A989B9E9F9C9694979EA5A59B8C7B6F68645F5853535C

6B7C878A87817F7F807F7974757F90A3B1B8B9B8B9BCBCB7AC9F9694989E9F998D8279746E65

584D4950607587949DA5B0BAC1C0B7ABA2A1A7B0B6B7B6B5B8BDBFBBAFA19795A09E9C9B9EA6

B1B8B3A288716466727E83807A7B879CB2BDB8A89486848A939A9C9B9A9A9B9C9B9996938F89

827F838FA1B0B3A8937C6D686A696151413B455B75878C857A73737A8287878686898C909191

8F8A817464585660738895979088878F999C94806A5E6173899AA09C948E8E9294928C85807E

8084898E93969287776862697B90A0A8ABB0BDD3E9F6F2DDC3ADA4A6AEB1AB9D8F847F7E7C7E

786C5D50494A566C87A0AEAD9F8C7E7E8A9CA9ACA8A3A5B1C2CFD0C5B3A2968E867866544949

515C615D5041342E313C4E657C8E9899928D8F99A6ABA187664C45526D86928C7C6A5E5C6065

6768696E757D828586888A8B89837B77787F8890959BA3ACB3AF9E82645152637B8D91887C77

8197B0C3C8C2B8B0B0B8C6D7E7F1F2E7D1B69D8E8A8F9596918A888F9DAAB0AA9D918C8F9598

948C888EA0B7C9CDC2AE9C9395A2B2C1CBCECAC1B3A79F9EA09F947E624C45536F8C9D9C8B76

6764686D6E696361666E7576726B67676A6D6E6E6F747D8995A0A8AEAFA8967A5C47424E6273

75675242414F6474766A584B4A576B81919B9D9991857A7477808E9BA2A5A6AAB2B9BAB2A290

8481838580777072829BB2BDB6A28E848B9FB8CCD5D4CBC0B5ACA6A3A29E9586736563718DAC

C2C8BEAC9F9CA5B1B8B9B5B4B9C4CFD3CCBDAFA6A4A5A49E92867F7F858B8E8B82735F48342A

2F43627F91938C84889BB5CBD2C6B09B9298A5B2B6AE9D89766453463D3A3F49535B5F62666A

6D6C665F5B5E67717777767A89A1B8C3BBA38571707F97A9ADA3917F736F7072726F6B65605E

64758EAABFC5BCA89488878C908E878080889398948778717582909896908C92A0B3C1C6BFAE

9986787379899FB3BDB9AA988D8F9BA6A7977D63555A6B7E8A887D7066646567696C758497A8

B3B6B2ABA49E978F88848485868380808998A9B0A88E6F56505F788F978A735D51525B666C6C

69676A707C8B9DAFBEC4BFB2A2969499A0A4A39E9C9FA5A8A294817575808E969182726A6F7E

8C9189766153515C718AA4B9C5C6BDB1A8A8B0BCC0B8A58E80808C9CA49F8E796A65686E7172

768091A3AEAEA39180757274777A7C7E808285888F99A2A59C8569534E5E7C99A8A390796C6D

7A8890908B898E9BACBBC6CBCAC4B6A28A73635D5F656C71757C8389887F736A6D7D95AAB3B1

AAA9B4CAE1EDE6CEB099929BAFC6D8E2E2D9CAB8A799918D897F7060575C6E889EA7A4988F8F

96A1A9ADB0B8C9DDEEF2E5CCB09B929194938E868180858D97A0A4A091795D453C455E7A8C8D

7F6A5D5D69777F7A6E625F6776868E8F8981776B5C4A3A2F2F374655636D757A7A746A605D62

6D75756A594D4D5C717E7A6343281E28415D717A7A76716E6D6D6E7071706D68676D7C93A8B6

B8B1A8A2A3A6A8A49C979AA4B0B3A89075625F6A7B888A857E7E879AAEBFC9C8BFB1A195929C

B0C8D9DCD1BFB1AFBBCCD8D8CCBCB1B1B9C1C2BAAA9A8F8882796D625E647386969FA09B9590

8D8C9098A3ACADA59587848DA0AFB1A1866D636C859FADAB9B857266615D5954504F50525556

5E68757E827F7874747A80838381838A92948972574442536E85908C81797C8A9BA7A99E8D7C

706C728093A6B4B6AB98867C7F8B989D988E8789939FA49E8F8077787F868A8B909FB9D8F2FF

FDEEDAC9BFBCBEC2C5C5C0B4A39388878D928F7F654E45517095B0B9B09E8F888A9093939296

9FAEBDC8CECFCECCC6BAAA99877A736F6D6C6D7074736853391D1D3254778F96918B8E9CAFBB

B7A282634E474C5A6A79848783796C63616771787A7672747E8A928F877566606164645F5C62

7693B0C1BEA98D7466656B717574706C6A6B717D8C9AA09C8E7F7984A0C3DFE9E0CAB3A49D9A

9488786B676E7A8489888585888C8C867C7470747E8C9BA7B1B4AFA28F7F7A8499B1BFBDAF9F

9AA3B6C8CCBEA284706D7787959D9E9B948C8279716E7074767674757B86929A9B9794979FA9

ADAAA4A2AABED5E3DFC8A88C7E82909DA39E92868080868E969A988F81716769788FA5AFAB9D

8F89909EADB5B5B3B6BFCCD4D2C5B3A29895928B7C695A565D6C7E8D9597938D87858A99AEC3

CCC5B0937D74798283755B403033476279858783807E7E7E7C7A7C818A9093918D8A8786827D

79797C8286847D75747A8386795A33100007203E545D5C5A5F6F869DAFBABEBDBBB8B8BCC4CE

E1DDCCAF8E72636064696A6B707D8FA0A8A3978A868D98A1A1988E8D98ADC3D1D2C6B29E918C

919EB1C2CDCCBEA9968C8C92948B765F51556C8CA8B7B7AEA49D9A97918982838B97A2A5A196

8B827C78747271747981848993A3B5C3C3B19477666B809BACAC9C867773798080766451433C

3D434C5762696961544841424A535B5F6269737C7F7868574E515D696D675D59647C9AB1B7AB

937A6A666D79858D8F8B81756B686E7B878C877D777E94B4D1E3E4D9CCC4C2C3C1BBB4B2BBCC

DFEBECE2D5CAC7C8CAC8BFB3A599918B8A8C8F8F87765E48404D6D97BBCED0C7C1C5D3E2E9E1

CCB29D918E8F908E8A85807970665D5C626E7E8C97A0A8ACACA3938275727981847D7066697B

96ADB4A6896B57535E6D797D786E63595250525962686967666D7E96AEBCBAAA947F70665B4C

3A2C282F3D47473C2C2224344B606D73757A8698ACBECACEC8B9A48F848697B1C6CDC4AF998F

919AA19C8C77686570808F969897989B9D9B9793949DADBFCED7DAD6CEC3B4A69B979A9FA19A

8C7E798296A8AD9E805E48465670858F8C847B77787A7B7C7B7A787572727883909A9B918375

6E6F73777A7D8799B0C3C9BFA993888A96A0A09380706B7382909794897A6C63636D829BB1BC

B7A691817D8186847765585663798D9A9C9B9A9EA3A6A1978D8A919EABB1AB9C897669616064

6D78818584828591A5B9C1B79B7A615C6C88A2B0AFA7A0A2ACB9C4CACCCDD0D4D7D8D7D4D0C9

BEAB92765E4D44403E4149596F84908E82746F7A90A7B3B0A08F878D9DACB2A9947C6960626D

7E909FA6A39684746B6B6F706A5E54535E7389979C9A999DA6AFB2ADA4A1A8B9CDD9D5C3A88F

7F797B82898E929495979EAABCCDD7D2BFA48F8995AEC5CFC7B39C8C8787867F72655F60676E

72727272757776716A65666D788797A7B7C2C4BAA68F7F7C8897A19B8972646675878F877155

4039405062717C81807C746D6A6C757F878A8C909AA9B9C2C0B5A69A8580786B5B4F4F5E7588

8D816A53464856677377746F6B6B707881888B85766457576987A7BEC4BBACA2A1A8AFAFA79B

9597A1ACB2B0A8A2A0A4A8A9A39A9596A1B2C4D4DEE0DACBB7A294919BAAB7B8AD9B8F91A2B9

C8C7B59C87828CA1B5C1C3BEB5ABA195887D767475777777787D84898982786F6A696761574E

4E5A6F838A7F664B3C41567188949492929AA7B5BFC2BCB09D89786F727E8E9795856F5B5253

595D5C57565E6E818F938D8581868E9491877C777E91A9BDC7C6BBAB9A8C85858D99A2A29683

716A6F7D8786745B4743537191A9B5B8B7B9BDC0BFBAB5B3B6BCC2C4C1BCB6B2ADA8A0999391

91918F9096A6BCD0DAD0B7977F79869AABADA18E7F7B828C93908474645852535A667580827A

6A594D494D535656575F6E80909590857D7E858B897A65534D556674776A5338241A1B27384C

5F6C7375777E8EA3B6BEB7A4918890A4BBC9C9BDADA8A09B958A7E75747C8C8E887C6F67666A

717576736F6B67666A748496A3A499897E8296B2C7CCBDA38B7F828F9A9D968A7F7B7E868F98

9FA6ABACA9A4A0A1A7B0B6B8B5B0ADACA9A29688808390A2ADACA1938D96A9BDC6BEA88E7B75

7C8A969B988D7E6E6057575E697070685D575C6A7B8582735F504A4D52545250546173828781

756B6B77899BA7ACABA9A9ADB3B9BEBFBBAE9B8779798AA5BFCCC5B0978786909B9E96867976

7D8A959B9B9793918E8C89898F9DAFC2D0D9DBD8D1C4B19D8B8180858882725F525260717A74

5E453539507395ADB8B8B3ADA8A5A3A2A2A2A19D989599A5B3BCBBAD9782757071737270737E

8E9DA0947D65565664768488868386909EAAAFA99A836951403D485E758484756152505A6A76

787471798DA9C3D2D3CBBEB2A6988774655E6370808A8D877D70645A5659647587949B9DA0AC

C0D5E0DAC19E827986A2C1D5DAD2C4B8AFA79E9182746A64626367707B85898476665A555962

6D79889EB7CFDBD5BFA1887C7F89908C80736F77899CA6A2917A62524D53657E97ABB2AB9A87

7A757472695A4D49566E8AA0A9A7A19C9A99948A807C859BB6CDD7D3C2AD9A8C837F8083888E

92969DA9BACCD6CFB6937160667F9EB6BFBAB0A8A6A9A9A3978A83848D9AA8B4BFC8CDCBC0AE

9884767071778293A8BCCAC9BAA28B80838F99998E7E75798B9FAAA48C6949332D3548607B93

A6B1B5B5B4B5B9BBB7ADA09899A5B5C0C0B39F8B7A6C5C4731201E2E4B697D817664554F5056

5C5E5F61666F7D8FA4B6C1BEAB8D6E5A58698398A09A8B7E7878776F5F4C3E3C475B708494A4

B5C4CED0C8BAACA3A3A9B5C3D0DADED6C4AB92838088929691888591ADD0EDF8ECD0B19B9498

A2ACB2B5B4B2ACA396897D73685D5148475060717E817D77726F6B61544847577599B4BEB6A5

9690959EA39E9182777479848E95948974583C2926334C66787F7E7D838F9BA19B8C7C73757F

898F8E8A898D929188755E4C464D5D71828D918D8375675D5B5E626056463B3C4E6D8B9C9986

706264758DA2AFB6BCC3CBD2D4D1CAC3BDB9B5B1AEB0B6C1CDD5D7D6D3CFCAC0B2A2999CABC2

D3D6C9B29D949AA9B5B7AB9A8E8C98AABDC8C9BFAF9A85736A6970787D7B72686569737C7E78

6F6B6F7B8992928D8A8D949A96856A503F3E4A5B696F6D67626166707D8D9AA1A19A93939FB5

CCD8D4BEA1897F838D949286786F6C6D6E685E524A47484845403C3D45505C666D7376787978

7B8597ADBEC3B8A38D8184929E9E8D72584A4C5C6E7C807D787679808B98A7B5C0C6C4BFBAB9

BCC2C3BFB5ACA6A6A9A8A29890919BA9B2AFA08D80818FA1ADAC9E89776E6F78838B8E8B8377

6B63646E7B85837662514B52616E71695C52525B677074777C899BACB5B5ADA4A0A4ABB1B2AB

A1958A837E7E82888C887C6A5A56637D9AACAD9E8A7D7D8A9AA4A1968881828B959DA2A4A4A3

A099928B8A8D93989997928E88807363544D515C686E695F5A70839EB2B6AA937F7F808B9AA4

A7A49E989594969A9E9F9A8F8074717C8FA4B1B2A89B918D8B877E726B6E7C8E9DA29C918B8D

98A3A7A3978A82838B97A2A7A498846B53444351677A827E7571798CA4B4B6AA9A8F8F9AA9B5

BABAB7B5B2ACA192837A7A808A959CA2A5A7A5A29C99999EA3A39C918A8EA1BCD5DED4BBA090

91A0B3C1C4BCB1A8A4A2A09C948A7E706359565C6B7F90999A9591919598989491949FADB8B7

A8907A6D6D71736B5A473B3C4B61758081796B5C504C515E718189857A6F6C73808A897C695B

586273818886807B7977706251433F465667757B7C7B7C7E848A929BA2A5A49F9B9DAABCCCCF

C0A07D635C667A8B918C837F838E9AA2A3A09B99999B9FA5AEB8C2C8C6BDB1A69F9B9997979C

A7B7C5CAC2B19F9698A3ADADA18E7F7E8DA6BDC9C7B9A99B9699A3B2C1CFD6D4CBC0B6B2B3B4

AD9D8773696C78858C8B85818184858074676168798D9A9A8F7E6E64616263615D57524E4E54

6174848C846F543F39455B6F7872655A58606B72716A64636976838F98A2ACB6BCBBB2A6998F

8A888A8F97A1A9ABA495867D8190A0A9A5978A8996AFC6D1CBB59B867D808A96A0A7ABADABA7

A3A1A2A4A39E938780818A959B9A928A858687867E76747F98B7D2DEDBCDBFB9BDC5CCCBC2B5

A79D999BA1A8ACA99D89715F5B677E97A7A9A1979397A0A5A1948479767C8386847F7B7A7E7E

7768544338373C454E5558564F43383134404F5B5D564F516382A2B8BAAA917C72757F888B89

837E7A77736F6A68686A6B6D717A89A1B4C1C6C7C6C6C4BEB2A194919AACBBBFB29A80706E76

80837B6E615D6472829096948A7B695C575F7186989F9D9692959DA4A3998A7E7A808A90908A

8484888E8E85766761697E98B1C2CACAC5BDB6B1B0B3B8B9B3A594898B98AAB4AF9A7C62575D

6F828F93929193969691877A706B696969696B70787F8484817D79746F69666B7B91A7B1AA95

7B68656F7E87857A6F6C778CA4B5BBB7AB9D928B8A909CABB8BFBCB3A8A19E9F9D968B83828A

97A3A7A39A94949593877158464451677C88867B6E635F6168727B828583807E828D99A09983

624331313E515F646260636B7479777371768394A3ACB0B2B5B9BDBCB6AA9B8D817A787D8A9B

ACB3AD99806C67708291948C807A8295ADBDC1B7A798909096A0A9B4BCC1BEB5A59485796D5F

5552555C646A6E70747B848E9596938F8F98ABC4DDEBEBDCC3A9958C8D9397958C827B7D8797

A4AAA598887C7B8394A6B6BFC2BFBAB4ADA59A8F878283888F94948F877F787470685B4A392E

2F3B506674766B59483F435163737A7A7673757E888F8C7E69513F383B4756646D7275767778

78777779808C9CABB6BAB8B3ADAAAAAAA79E9285808596AFC7D6D7CBB7A39899A3B1BBBDB8AF

A8A7ACB4BAB8AD9C8B7F7E8797A8B6BFC2C0BCB7AFA69B918A8A8F98A1A6A59E96908E909392

8D82787378889EB1BBB6A48C7569697484919797949398A3AFB9BAB1A29287838790989D9C95

8C81766A5E534C4A505E70818D92918E8D8F9499989183746A6A73818D8F846C4F3628293444

52595A57575C67747E807B71686468748494A1A8ABAAA7A39D958C868489939FA9ACA79D928A

898D939796918D909DB5D2ECFBFBEEDAC9C0C2CCD7DDDACEBFB0A6A19E9A908170625B5D6777

86929A9FA1A09E9991898281868F9AA2A1998A7B716D6F72726D6358545B6B80929A95846E5E

585F7084959E9F9E9DA2AAB4BABAB3A99F999A9FA6ABACA8A29990867A6E635C5D677688969C

9A928985878D93948E81736A6A74828D8E826C53413A4050627178787573757B8286847D746C

6A6E78838D95999C9EA0A09E9A97969CA9BBCCD7D8D0C2B3AAA8ACB0B0A99D918B8F9EB0C0C5

BDAB9686808592A0A8A8A1968C878585837C72675F5C60676F75787877747069605448414148

56646E6F695F57576070808C908F8C8E98ABC0CFD4CAB69E8C8386909CA3A49E979293989FA4

A5A3A1A1A5ADB7C0C5C8C7C4C1BCB4A8998A807D838D979B968977675F5F656C6D675B4F494E

5C6E7D837D6F60575966798D9CA2A29E9A9A9B9C9993897E767374777B7D7F81858A8E91918F

8D8F99A9BED1DBDACFBEAFA5A4A8AAA79C8A796D6C75818A8A7F6C584A464D5A6870716D6661

605D5E5D5A555150545C656D73777B7F8486847E746963656F7E8C9391877A72727C8C9DA7AA

A7A3A5B0C3D8E7ECE5D4C1B3AEB3BCD0CEC6B8ABA29FA2A7ABACABA9A6A4A29F99918A858588

8C8E8A837A74747B8690928D81756D6F7A8894958B7863534D515B64676259504E546273828B

8D8C8A8B929BA4ABAFAEACA9A5A19B9288807C7D82888B88817973747C8891948E82756E707C

8C989C9485746968717F8B908C8277706F747A7D7A72665B5453575C6164676B70777B7E8083

8994A3B4C2C9C7BDB0A6A3A7B0B8B9B1A3948B8C96A5B2B7B4AAA09CA2AFBFCBCFC9BEB3ADAE

B4BCC0BEB6ABA09997999C9FA1A1A1A09D988F83776E6B6E767D7F7A6E6056555B67737A7973

6D6C7482919B9B907E6D62626B7881827B6E61595A616B757B7C7B7B7C8085898B8C8E909396

97938C85808188939EA4A39C938D8D949DA3A2988A7C7577818E95938774645C61708497A2A5

A19B98999EA4A8A8A5A19D9A9997948E87817E7F82848482808086909DA8ADAAA39B989CA7B5

BFC0B7A99C979CAABAC6C8BFAF9E939198A3ACAEA89D928984838483817D7C7E838C94999C9C

9B9C9D9E9D99928A84838588877E6E59463C3C47576469655B514E556578878E8A817671737B

868E8F8B837B787A7F858787848282868B909394939293949594908B888A94A3B3C0C3BDB0A4

9EA2AFBFCCCFC8B8A79A95979C9E998D7E716C707B8790928E878281868E969B9C9995928F8E

8B8783807F82858887827A74737A8797A2A49D837268697586969E9F99939297A2ADB3B1A79A

908E95A2B1BABCB6ABA099969696948F89817B756F69625E5E636E7C8991918C847F7F848A8C

867866554C4E5968757B79726C6B727E898E897B6A5B55596675828A8C8C8C8F96A0AAB2B9BF

C3C7C9C8C2B8AEA6A4A7AEB4B6B2AAA099989BA0A19C908278778092A5B4B9B3A89C9799A1A9

AAA2917B675955585E636564615F5F62666969696868696B6A67615B595D6776859097999B9F

A7B1B9BBB3A28D7D75798796A2A39C8F837F8491A0ACB1ADA69E9C9EA5ACB1B1AEAAA7A7A8A8

A5A0978E86807B746C635B5759616C767A7A7672737A858E91897965554F57687E909999928C

8B919DA9B0B0A99E948E8D8F91908D8885868D97A3ADB4B8BABCBCBBB7AFA69E9B9DA4ACB1AF

A5978A83848B93948D7C67554C4D586671736E645B585B636B6E6A61564E4C50575E63646262

646B747D858A8D8E8D8A847A6D5F55535A697B8C9598969498A3B4C5D1D3CBBEB2ACAEB6C0C4

C0B6A89E9BA0AAB3B6B1A6998D87878B8F908F8B8887898D909396989B9FA19F998D7F746F73

7E8D989C988E847E7E848A8B8578695E5C6472828D918E898890A0B4C7D2D4CDC0B2A7A09B97

928C868280818383838283868B8F918E85786D6769717C84858077706E727B83857E6F5E524E

535E696E6A5F5046444B58666F726F68615D5D5F62666A707A86939FA8ACADADAEB1B2B1ABA0

938882858D979EA09C97959BA8BBCBD4D1C5B5A7A2A5AFB9BDBAB0A39A979DA8B3BBBDB9B3AC

A7A29D989089848284888C8E8D8A8887898A8A867E777375808E9CA5A59D928A8A93A1AEB3AD

9E89776C6A70777B7A756F6D727D8B98A0A29F999591908D8A847E7A797C8085898B8C8E9296

98958C7D6E615D606972757063554B4A546679878B877F77757A838B8F8D867F7C7F87919899

93897E746F6C6C6C6C6D70767E878F95999FA6B1BCC5C8C3B7A89C979BA5B0B6B4AB9F96969E

ACB9C1BFB5A89C9696999C9992887F7D8391A2B1BABDBAB4AEA9A6A39F9B98969594928C8379

716E7178808380786C6361677380898A857E7B7F8B9AA7ACA79B8C7F7A7C81868680766E6B70

7B8A98A1A4A39E98928D87827D7C7E848B929493908E9198A4B0B7B6AEA296908F91928E8475

675F616C7C8B928F84776D6B707A838886807976787E878F939493908D8A86817B7674767B83

8A8D8C8986878D979FA3A0988D86858B949C9E9A9088868FA1B8CCD6D5C9B9A99E999897938B

7F756F6D70767A7D7E7E8083878A8A8884828183868786817B77787E878E908A7E7269676D78

80827C7165606574889BA8AAA59B9491949AA1A4A5A4A4A8B0BAC2C8C9C6C2BEBAB7B2ACA49C

94908D8C89857F7B7C8594A6B5BDBBB1A39893959B9F9C91806F636065707A7F7C7368605D5F

636565605A57575D666F777A7C7C7C7E808181818183888D91918C847C797D8998A5ABA69A89

7B74767C8285827B74747C8A9CABB2B0A89E97949597979186786D656365696D70727477797B

7A77747171757B7F7F7A7168656976889AA5A8A39B95959BA4ABADA9A099979EAAB9C3C6C0B4

A8A09FA3ABB1B4B2AEAAA9ABB0B5BBC0C4C9CED1D1CBC1B5A89F9A979590877A6F6868717D88

8D8A80756C696B70736F64564B474C5A6B7A818079706B6B70767C7D7A756E696563605E5D5E

636A737A7E7D7A78797D858D91918E8C8D95A1AFB9BAB2A39286808287898478695B55586473

828A8C88827F7F8286888884807C7A7A7A7A79797C818992999C9A95908C8B8B8B867E756F6F

78899CACB4B3ACA3A0A5B1C1CDD2CFC5BBB4B4BAC2C8C9C4BBB3ADAAAAAAA8A29B94908E8F91

929495979CA2A7A9A7A198918C8B8A878073655A575D6B7C8A8F8A7E6F6562666D72726A5F55

4F5057616A6F71717278818C959A9A96908A86838280808082878C91928E88807C7D838A908F

897F7673798697A5AAA79D9189878B9196948D8279767980898F908D87828184898D8E8B847C

746E6A68686B727D8B9BA9B1B3AFA9A5A5A9AFB3B0A7998C83838A949C9E9A928A888C96A1A9

A9A399918E929BA6ADAFADA7A3A1A2A6A8A9A7A19B958F88817B767578808A929491877C7470

73787D7D79726D6E7583929EA29E968F8C9099A1A39D8F7D6C605D60686F7476777A7F868E95

9A9D9E9E9F9F9E9B95908E90969FA6A9AEA79E98979A9EA09D958A817F848E9AA1A1998D837F

838D99A1A1998D8079777B81878B8D8D8E8F90918E887F776F6A6663605C595A5F697580878A

8887888D969FA39F95877B767A85919B9D988E86848A95A1AAACA69C928A88898C8E8E8E8F91

969CA1A3A29E9A9795959594929091969CA3A6A49B90858080868D8F8A7F70635D626E7D8B92

94918E9097A2ACB2B1A99E948E8C8E909292919193989FA5A9A9A7A4A09D9A95908A86878C96

A0A7A8A39B95949AA5B2BAB9B0A2938985888D8F8C847A716D6F747979746A5E5653565D666D

7275777A7F8487898885827F7C7770675D555358616D767A78726D6D737F8C949690857C777A

828C939694929297A2B0BBC0BDB3A599918E8F919292908F8E8E8E8E8D8D8D90959BA0A09D97

9290949CA6ADAEA9A09894959AA0A19B8F81757079838F9799979391959EAAB4B9B5AB9E9188

83838486898C8F94999D9F9F9E9D9FA3A8AAA9A2998F8886898D908E89827E7F86909A9D988C

7C6F696A717A7E7D766D66646870777B7A746C65615F60626465686C717679797773706F7173

7574706A656569727D84878684848B97A6B3B9B4A796877E7D848D949694908E9198A1AAB0B1

AEA9A6A4A3A3A29F9B98969798999997959495989B9C99928A8482858D9497958E857F7F8794

9FA4A196877A73747B848B8F8F8D8D90969DA1A29D968E888686878786858485888B8F929497

9BA0A7ABABA5998B7E77777B8184827B726D6E76838F96968E82787373787D7F7D77716E6F74

7A7E7F7B756E6A696B6F727476787A7D7F80807F80838B939B9E9A90847A7578818C94989793

92969EAAB3B7B6AC9F959091969C9E9B96918F929BA5ADB2B3AFAAA5A29E9B98938F8D8B8A89

86817C7A7B828C969B9B93897F7A7B80878B8A857F7C7D848D93948E82756C6B707983898A87

8381838991999E9F9E9B9895928D8884808083878B8E8E8C8C8F959EA6A9A69D91867F7E8286

87847D77757A85929DA19D93877D7A7C82898B89827A747273777B7E80828487898B8B888582

83868A8E91918F8F91969CA1A19B91867E7C818A939897928D8C919CAAB5BAB7ADA0958E8D90

9393908A85828285898D90919293959797948E86807B7878777674737479818B92948F857A72

71767F888C898178727279838D93938D878282868C92959492909094999FA3A5A5A3A2A2A19F

9C97928E8D8E9092929291949CA7B3BCBEB8AB9C8F898A8F9496928A807A7A8089919696918C

898A8D9293918B827B77777A7F8487898A8B8C8C8B888481808286898B8984807E8189939A9E

9B93887F7C7F868D908F8A8482868E98A0A29E968D8683848686837D76706D6E737A81878C90

939595928C847E7A7A7D7F7F7B746D696B737E8990918D878383888F9596928B8481858E99A2

A6A49D969292969CA1A3A29E9B9A9A9DA0A3A6AAADB0B3B3AFA9A0999596999DA09F9B979597

9EA6ADAFABA1978F8B8D90918E85796F6A6D77838F9596928C888687898A88847E7975737271

707071757A80848583807C7B7D81858785817C7B7E868F959691877D77777D858B8C877E7672

747C8892989895908B89888786827E7A7777797C7E808184878C919494908B8784848585837D

7771717783909CA2A19A938F9197A0A6A8A39A908A8A8E959C9FA09E9C9C9EA1A4A5A4A19E9D

9DA0A3A5A6A6A7A8A9AAA8A49D96918F909394928C837C797E88949EA3A0978D858182868785

7E756C68686E757B7F7E7D7B7C7F828585827D76716E6D6D6D6F71757B8287898885817F8187

8E92928D847B76777E889094928C858181868C90908B85807F838B949A9C9A95918E8D8E8F8E

8B87827D7A797878797C828B949B9E9D98918C8B8D9194928D847C787A818B94999895919194

9BA1A5A39B928985878D949B9E9D9A9796979A9C9D9E9D9B9A9F9E9C9893908F909395959089

827D7C80868B8D8A85807E82889094938D837A76777C8286847E756D696A6F767D8182818081

828486878888898B8C8D8B87827F7F81868A8C8C8986868A90989D9E99938D8B8E959DA1A099

8F8681838A93999C99948E8B8B8E9294948E8B8888888989888684838384848482808083888E

9394928C878384878B8C89827A737277818C9496928B8480828991999C9C999693939494928E

8985828386898D8F909192939494928F8C8B8D909597969189827F80868C908F89817A797D86

90989A968E86807F8185888886838183878C9193928F8C8B8B8E929597999A9B9B9A97928C86

85878C94999B9A959190949CA4A9A8A39A928E8F94999D9C968E86828285888A898683818388

8E9395948F8A85817E7C7B7A7A7C7F8283817D77727072787F868886827D7B7D82888B8A847C

7674787F888E908D898686898F959897928D8887898D91949493908E8C8B8A898A8C91979EA3

A5A29D96919091949695918B8685878D9396958F89848389929BA1A29E98938C8F94999B9A96

918D8C8D90939697979797979693908D8C8E92989DA09F9B97949496999A98938D89898E949B

9D9A92877F7B7F81868B8F8F8B837D7C7F868B8C877F7876797E81817D79787A7E817E78746D

6B6F767C7E7E7C7B7D808383817E7C7C7D808386898D90908D88828082888E918F8C898A9098

9C9C968E8A8C939CA09F9A9492959BA0A29F9A9592929495949393949597979796969695938F

8B8A8D949CA09F99928D8D909495918A86868D959B9B958D8785898E9293908E8D8F92949595

93929291908E8C8C8D8F8F8D8A87878B90929089817A7A7F878D8E8A858283888C8B867D7674

787F858786817D7B7A7A79787777787A7B7C7C7D80838483807C7A7D83888B89837E7E838B92

938F888280848B8F908D8A898D949A9D9B97928F8F919496989B9D9E9E9B989593949594928F

8D8E949A9D9C958D88898E959896908A888B919698948E8987898C8E8C8985828386898B8C8C

8C8B8986838182868C90918F8C8B8C9092918B847E7F858D9495918A8483878B8E8C88838285

8A8F91908D8A89898A8A8A898888878583828285898C8B87807C7C7F84878783807F848B9293

8F867F7C7F85878C8E8E8C8A898A8C8C8C89868484878C919595938F8D8D8F93959695928F8F

909497999895918F8E909192908D8A88888C91959694908B8786878A8C8C8C8A8A8B8D8E8F8D

88827E7C7D8186898A88858282838587878583818184888B8C8B8885838486898A8986827F80

82878B8E8D8B888787898B8C8C8B8A8B8E93989B9B98938E8B8C8F9395969594939395969694

918D8B8B8E9397989794918F8F919493928F8B88888A8C8F908E8C8988888A8B8B8884818081

858A8E8E8C868382838587888785838384878A8C8B88858384878B8F918F8D8988898B8E9090

8F8D8C8D8F929392908C8A8A8C90949594908C8A8A8B8E90918F8D8B8B8C8E8F8F8D8A878688

8C8F91908D898685878B8D8F8E8C8A898A8C8E8F8E8B89898B8E929494918D8B8A8C8F939595

93908F8F91939494928F8E8F9295979694908C8B8C8F939494918E8B8B8C8D8E8E8C8A888889

8C8D8D8A8683818285888A8A888482808183858685838181838587888683817F8083878B8B8A

8784838486898B8B8A8888898B8D8F8E8B8987888B8F9293918E8B89898B8E90918F8D8B8B8D

8E908F8D8A88888A8D90918F8C888686888B8D8E8D8A8888888A8C8C8B898787888C8F908F8C

898787898D9092918F8D8C8C8E909291908E8E8F9295969693908D8D8F9296979794918F8F90

929393928F8E8E90929393908C8988898C8F91908D8A878687888A8A89878585868889898784

81808184888A8A88858281828587888887858586888A8A8A87858485888C8E8F8D8A87848587

8A8C8D8B8988888A8B8C8C8A888787898C8E8F8D8A878585878A8C8D8B89878687898A8A8987

858587898C8D8B88858384868A8C8D8C8A8887888A8C8D8D8B8A8A8C8E9192928F8D8B8B8E91

94969593918F8F91939595949291929496979694918F8F909396979693908E8D8F919292918F

8D8D8E8F90908E8B8888898B8E8F8F8C89868687898B8C8B8A8887888A8B8C8A888786878A8D

8F8F8D8A8887888B8E8F8F8E8C8B8B8D8F908F8E8C8B8C8E919292918B8887888A8D8F8F8D8B

8989898B8C8C8A898787898B8D8D8B88858484878A8C8C8B8886858688898A89888787888A8C

8D8C8A888687898D8F908F8D8B8A8B8D8F90908F8E8E8F90929393918F8D8E90939596959390

8E8F909294949391908F90929292908D8B8B8C8F9191908E8A8888898B8D8D8C8A888888898A

8A8987868586898B8C8C8987858486888B8C8B8A888788898B8B8B8A8888898B8D8E8E8C8A88

87888B8D8F8F8D8B89898A8C8D8D8C8A89898B8D8E8E8C89878687898B8D8D8B888686868889

898987868687888A8A898684838487898B8C8A88868686888B8C8C8B8A8A8A8C8E8F8E8D8B8A

8B8D90929392908D8C8D8F91939392908F9091929392918F8E8E8F92939493908D8C8C8D8F91

91908E8C8C8C8D8E8E8D8B89898A8C8E8E8D8B888686888A8C8C8C8A888788898A8B8A898887

888A8C8D8D8B898787898B8E8F8E8D8B8A8A8B8C8D8D8C8B8A8B8C8E8F8E8D8A8888898B8D8E

8E8C8A8887888A8B8B8A898887888A8A8A898785848587898B8B898785848587888989888786

87888A8A8988878687898C8D8E8C8A8988898B8D8F8F8E8D8C8D8E8F90908F8D8D8D8F919393

92908E8D8D8F91929291908E8E8E8F90908F8D8C8C8D8F90908F8D8A89898B8D8E8E8D8C8A89

8A8B8C8C8B8A89898A8B8D8D8D8B898888898C8D8E8D8C8A89898B8C8D8D8C8B8B8B8C8E8F8E

8D8B8A8A8B8D8F908F8D8B8A8A8B8C8D8D8D8B8A8A8B8C8D8C8B898887888A8C8C8C8A888685

868889898988868686878888888685858687898A8A8987868586888A8B8B8A8989898A8C8C8C

8B8A8A8A8C8E8F8F8E8C8B8B8B8D8F90908F8E8D8D8E8F90908F8E8D8D8E909191908E8C8B8C

8D8F90908F8D8C8B8B8C8D8D8D8C8B8B8B8C8D8E8D8B8988898A8C8D8E8D8B8A89898B8C8D8C

8C8B8B8B8C8D8E8D8C8B8A8A8C8D8F908F8D8C8B8B8C8D8E8E8E8D8C8C8D8E8E8E8D8B8A8A8B

8D8E8E8E8C8A8989898B8C8C8B8A898889898A8A8988878687888A8A8A888785858688898A89

888787878889898988878788898B8C8C8B898888898B8C8D8D8C8B8B8B8C8D8E8E8D8C8C8C8D

8F8F8F8E8D8C8B8C8D8F90908F8D8C8C8C8D8E8E8E8D8C8C8C8D8E8E8D8C8A8A8A8B8D8E8E8D

8B8A898A8B8C8C8C8B8B8A8B8C8D8D8C8B8A8A8A8B8D8E8E8E8C8B8A8B8C8D8E8E8D8D8C8C8D

8E8E8E8D8C8C8C8D8E8F8F8F8D8C8B8B8C8D8E8E8D8C8B8B8B8C8C8C8B8A8A898A8B8C8C8B8A

88878788898A8B8A898887888889898988878788898A8A8A8987878788898A8B8B8A8988898A

8A8B8B8B8A8A8A8B8C8D8D8C8B8A8A8B8C8E8E8E8D8C8B8B8C8D8D8E8D8C8C8C8D8D8E8E8D8C

8B8B8B8C8D8E8E8D8B8A8A8B8B8C8D8C8B8B8B8B8C8D8E8D8C8B8B8C8D8E8F8E8E8C8B8B8B8C

8D8E8E8D8D8D8D8D8C8C8C8C8C8C8D8D8D8D8D8D8C8C8C8C8C8C8C8C8D8D8C8C8C8C8B8B8B8B

8C8C8C8C8C8C8B8B8B8B8B8B8B8B8B8C8B8B8B8B8A8A8A8A8B8B8B8B8B8B8B8A8A8A8A8A8A8A

8B8B8B8B8B8A8A8A8A8A8A8A8A8B8B8B8B8A8A8A8A8A8A8A8A8B8B8B8B8B8A8A8A8A8A8A8B8B

8B8B8B8B8B8B8A8A8B8B8B8B8B8C8C8B8B8B8B8B8B8B8B8C8C8C8C8C8C8C8B8B8B8B8C8C8C8C

8C8C8C8C8C8C8C8C8C8C8C8D8D8D8C8C8C8C8C8C8C8C8D8D8D8D8D8C8C8C8C8C8C8C8C8D8D8D

8D8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8B8B8B8B8B8B8C8C8C8C8C

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8A8A8A8B8B8B8B8B8B8B8B

8A8A8A8A8A8B8B8B8B8B8B8B8B8A8A8A8A8B8B8B8B8B8B8B8B8B8B8B8B8B8B8C8C8C8C8C8B8B

8B8B8B8B8B8C8C8C8C8C8B8B8B8B8B8B8B8B8C8C8C8C8B8B8B8B8B8B8B8B8C8C8C8C8B8B8B8B

8B8B8B8B8C8C8C8C8C8B8B8B8B8B8B8B8C8C8C8C8C8B8B8B8B8B8B8B8B8C8C8C8C8B8B8B8B8B

8B8B8B8C8C8C8C8B8B8B8B8B8B8B8B8C8C8C8C8C8B8B8B8B8B8B8B8B8C8C8C8C8B8B8B8B8B8B

8B8B8C8C8C8C8B8B8B8B8B8B8B8B8C8C8C8C8B8B8B8B8B8B8B8B8B8C8C8C8B8B8B8B8B8B8B8B

8B8C8C8C8C8B8B8B8B8B8B8B8B8C8C8C8C8B8B8B8B8B8B8B8B8B8C8C8C8B8B8B8B8B8B8B8B8B

8C8C8C8B8B8B8B8B8B8B8B8B8B8C8C8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B

8B8B8B8B8B8B8B8B8B8B

pop

% End of sampled sound

% End of Graphics

MathPictureEnd


\
\>"], "Sound",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oo`008@0000000`00
Oomoo`3oOolMOol100000003001oogoo09Eoo`03001oogoo00moo`<000Yoo`03001oogoo06Eoo`40
000000<007ooOol0Q7oo00/007oo001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool2
00000goo001oo`04Ool00`00Oomoo`02Ool50008Ool00`00Oomoo`02Ool2001QOol100000003001o
ogoo085oo`03001oo`0000<0009oo`<00003Ool0000000/0009oo`<00003Ool0000000L00004Ool0
0000Ool20002Ool200000goo000000070002Ool00`00Ool00009Ool00`00Oomoo`1>Ool100000003
001oogoo07moo`D00003Ool0000000h00003Ool0000000T00003Ool0000000`00005Ool007oo001o
o`060002Ool700000goo001oo`03Ool00`00Oomoo`030003Ool00`00Oomoo`16Ool100000003001o
ogoo04eoo`03001oogoo011oo`03001oogoo008000Qoo`<0009oo`03001oogoo00Moo`03001oo`00
03L00003Ool0000000H00003Ool0000000D00003Ool0000000H00004Ool000000003Ool300000goo
001oo`02Ool00`00Oomoo`02Ool2000fOol100000003001oogoo049oo`800004Ool00000OonT0000
0goo001oo`08Ool00`00Oomoo`0ROol100000003001oogoo03Uoo`<00003Ool000000;h001moo`40
000000<007ooOol03Wooo`001P002Goo0@0000000`00Ool0003o000L0001Ool100000003001oogoo
025oo`800003Ool007oo0=l00003Ool007oo01Aoo`40000000<007ooOol0>goo00<007ooOol017oo
]@0000=oo`00Ool08Woo0@0000000`00Oomoo`14Ool00`00Oomoo`03Ool2000017oo000000001Goo
00<007oo000010000Woo0P0000=oo`0000001`0000=oo`00000010000Woo00@007oo0000009oo`03
001oo`0006@00005Ool00000001oo`020002Ool00`00Oomoo`02Ool00`00Oomoo`0[Ool100000003
001oogoo06aoo`04001oogoo0003Ool00`00Oomoo`05Ool01000Ool007oo;00000=oo`0000002000
00=oo`0000001P0000=oo`00000010000goo0P000Woo0P0000Ioo`00000007oo0002Ool30002Ool0
0`00Oomoo`0mOol100000003001oogoo089oo`@00003Ool0000000T00003Ool0000000<00003Ool0
000000<00007Ool00000001oo`00Ool01P0000Eoo`00000007oo00<00003Ool007oo00P00003Ool0
07oo01Ioo`03001oogoo049oo`40000000<007ooOol0Pgoo1`0000=oo`00Ool00P0000Eoo`000000
07oo00@00005Ool007ooOol00002Ool300000goo001oo`080003Ool00`00Ool00003Ool20007Ool0
0`00Oomoo`1JOol100000003001oogoo095oo`8000=oo`<000Ioo`03001oo`0000=oo`03001oogoo
00=oo`03001oogoo00Uoo`03001oogoo069oo`40000000<007ooOol0TGoo00<007ooOol0R7oo0@00
00000`00Oomoo`2HOol00`00Oomoo`21Ool100000003001oogoo0?mooaeoo`400000o`008@000000
0`00Oomoo`3oOolMOol100000003001oogoo09Eoo`03001oogoo08Aoo`40000000<007ooOol0ogoo
7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeoo`40000000<007ooOol0UGoo
00<007ooOol0Q7oo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeoo`40000000<0
07ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo09Eoo`03001oogoo08Ao
o`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeo
o`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0:9oo`03
001oogoo07Moo`40000000<007ooOol0XWoo00<007ooOol0Mgoo0@0000000`00Oomoo`2AOol00`00
Oomoo`28Ool100000003001oogoo08ioo`03001oogoo01Uoo`03001oogoo06moo`40000000<007oo
Ool0UGoo00<007ooOol04Woo00<007ooOol0Kgoo0@0000000`00Oomoo`2IOol00`00Oomoo`20Ool1
00000003001oogoo09Uoo`03001oogoo00Ioo`03001oogoo07Moo`40000000<007ooOol0[7oo00<0
07ooOol0KGoo0@0000000`00Oomoo`2>Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`0J
Ool00`00Oomoo`1JOol100000003001oogoo0:aoo`03001oogoo011oo`03001oogoo05Yoo`400000
00<007ooOol0R7oo00<007ooOol0TGoo0@0000000`00Oomoo`2IOol00`00Oomoo`0=Ool00`00Oomo
o`1`Ool100000003001oogoo08Aoo`03001oogoo02=oo`03001oogoo00moo`03001oogoo05eoo`40
000000<007ooOol0R7oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00Woo00<007ooOol0
87oo00<007ooOol0GGoo0@0000000`00Oomoo`24Ool00`00Oomoo`0:Ool00`00Oomoo`0FOol00`00
Oomoo`0:Ool01000Oomoo`00HGoo0@0000000`00Oomoo`2DOol2000COol01000Oomoo`00Kgoo0@00
00000`00Oomoo`24Ool01@00Oomoogoo000047oo00<007ooOol02Goo00D007ooOomoo`0000eoo`03
001oogoo00Eoo`03001oogoo05Yoo`40000000<007ooOol0Lgoo00<007ooOol02Goo00<007ooOol0
2goo00<007ooOol09goo00<007ooOol01Goo00<007ooOol0FWoo0@0000000`00Oomoo`2ROol00`00
Oomoo`0BOol00`00Oomoo`03Ool00`00Oomoo`1LOol100000003001oogoo07=oo`03001oogoo00Uo
o`03001oogoo00Ioo`03001oogoo009oo`05001oogooOol00007Ool00`00Oomoo`02Ool00`00Oomo
o`04Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`1HOol100000003
001oogoo07=oo`03001oogoo00aoo`03001oo`0000Qoo`03001oogoo00Moo`03001oo`0000Ioo`03
001oogoo00Moo`05001oo`00Ool00004Ool01@00Oomoogoo000017oo0P0037oo00<007ooOol0Cgoo
0@0000000`00Oomoo`1_Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Ool0
000<Ool00`00Oomoo`05Ool00`00Oomoo`1[Ool100000003001oogoo07=oo`03001oogoo019oo`03
001oogoo00Yoo`03001oogoo00Aoo`03001oogoo00]oo`04001oogoo0005Ool00`00Ool00004Ool0
1000Oomoo`00GWoo0@0000000`00Oomoo`1_Ool00`00Oomoo`0@Ool01@00Ool007oo00001goo00<0
07ooOol00goo00<007ooOol00P000goo00D007oo001oo`0000Eoo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Moo`8005Uoo`40000000<007ooOol0Kgoo00<007ooOol03Goo00<007ooOol0
17oo00<007ooOol01goo00<007ooOol017oo00<007ooOol0PWoo0@0000000`00Oomoo`28Ool00`00
Oomoo`03Ool00`00Ool00006Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00
Ool00003Ool01000Oomoo`000Woo00<007oo00004Woo00<007ooOol0Agoo0@0000000`00Oomoo`1c
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool01000Ool000000Woo00<007ooOol00Woo00D007ooOomo
o`0000Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Aoo`03001oo`0000Aoo`05001o
o`00Ool00002Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`17Ool1
00000003001oogoo07Yoo`05001oogooOol00007Ool00`00Oomoo`08Ool01000Oomoo`0017oo00<0
07ooOol01Goo00<007ooOol01Woo0P000Woo00<007ooOol00Woo00<007ooOol01goo00<007ooOol0
2Woo00<007ooOol03Goo00<007ooOol0?goo0@0000000`00Oomoo`1_Ool00`00Oomoo`08Ool20002
Ool01@00Oomoo`00Ool00P000goo00<007ooOol037oo0P0000Aoo`00Ool0009oo`04001oogoo0003
Ool01P00Ool00000Ool0009oo`03001oogoo00aoo`03001oogoo009oo`8005Qoo`40000000<007oo
Ool0Bgoo00<007ooOol08Goo00D007ooOomoo`0000Moo`03001oogoo00Eoo`04001oogoo0006Ool0
0`00Oomoo`07Ool00`00Ool00006Ool01@00Oomoogoo00001Goo00<007ooOol00`000goo00<007oo
Ool01Woo00<007oo00001Goo00<007ooOol02goo00<007oo00001Goo00<007ooOol0?goo0@000000
0`00Oomoo`1_Ool00`00Ool00008Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2000;Ool00`00Oomo
o`03Ool00`00Ool00008Ool00`00Oomoo`05Ool01@00Ool007oo000017oo00<007ooOol027oo00<0
07ooOol02goo00@007ooOol000Yoo`03001oogoo03moo`40000000<007ooOol0Bgoo00<007ooOol0
8Goo00<007oo000037oo0P0000Moo`00Oomoo`00Ool00004Ool00`00Ool00003Ool00`00Oomoo`03
Ool20003Ool02@00Oomoogoo001oo`00Ool00003Ool01@00Oomoogoo00000goo00<007ooOol00Woo
00<007oo00002goo0P0000=oo`00Ool00Woo00<007oo00000Woo00<007oo0000BWoo0@0000000`00
Oomoo`1;Ool00`00Oomoo`0BOol00`00Oomoo`0>Ool00`00Oomoo`06Ool20005Ool01P00Ool00000
Ool000=oo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00=oo`<000=o
o`800003Ool0000000Aoo`05001oogooOol00004Ool01`00Ool00000Ool007oo00800003Ool007oo
00Ioo`80009oo`03001oogoo00Qoo`03001oogoo03aoo`40000000<007ooOol0H7oo00<007ooOol0
1Goo00D007ooOomoo`0000Ioo`03001oogoo00Eoo`03001oogoo0080009oo`03001oo`00008000=o
o`8000=oo`03001oo`0000Aoo`800003Ool007oo00Eoo`04001oo`00Ool300001Goo001oogoo0000
0Woo100000Ioo`00Ool007oo0002Ool2000017oo001oo`0017oo00<007oo00000goo00<007ooOol0
17oo00<007ooOol0B7oo0@0000000`00Oomoo`1WOol20003Ool02000Oomoo`00Ool007oo0007Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`000Woo00<007ooOol00Woo0P001Goo00<007oo
00000goo00<007oo00000`001Goo00<007ooOol01Woo00<007ooOol02Woo00@007ooOol000Aoo`80
00Qoo`80011oo`03001oogoo03Moo`40000000<007ooOol0Bgoo00<007ooOol047oo00<007oo0000
1goo00<007ooOol047oo0P000Woo00<007ooOol00Woo00<007ooOol00Woo00T007ooOomoo`00Ool0
07oo00000goo0`001Goo0P000goo00<007oo00000Woo00<007ooOol00P0017oo00<007ooOol00Woo
00<007oo00000goo00<007ooOol00Woo00`007oo001oo`00Ool007oo001oo`00Ool50003Ool00`00
Oomoo`04Ool00`00Ool00004Ool00`00Oomoo`0gOol100000003001oogoo04]oo`03001oogoo00Eo
o`03001oogoo00Qoo`05001oogooOol00004Ool20003Ool00`00Oomoo`04Ool00`00Oomoo`05Ool0
1@00Oomoogoo00000Woo0P000Woo00L007ooOomoo`00Ool00002Ool20003Ool01@00Oomoo`00Ool0
0`000goo100000=oo`00Ool00`0000Aoo`00000000=oo`07001oo`00001oo`00Ool00`000goo00<0
07oo00000Woo0P000goo0P0000=oo`00Ool00Woo0P0027oo00@007oo001oo`8000Aoo`03001oogoo
03Moo`40000000<007ooOol0Bgoo00<007ooOol04Woo00<007ooOol037oo00D007ooOomoo`0000Mo
o`03001oogoo009oo`<000=oo`03001oogoo019oo`03001oogoo00Aoo`03001oogoo00Eoo`80009o
o`03001oogoo009oo`05001oo`00Ool00002Ool00`00Oomoo`03Ool01@00Oomoogoo000027oo00<0
07oo00000Woo00<007ooOol01Woo00<007ooOol017oo00<007ooOol0=goo0@0000000`00Oomoo`1;
Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool01@00Ool007oo000017oo00<007oo
00001Woo0P000Woo00<007ooOol027oo00T007ooOomoo`00Ool007oo00000Woo0P0000Aoo`00Ool0
009oo`04001oogooOol30003Ool300000goo001oo`04Ool01P00Ool00000Ool000Ioo`04001oogoo
0003Ool200001goo001oo`00Ool007oo00<00003Ool007oo00Ioo`05001oo`00Ool00003Ool00`00
Oomoo`0iOol100000003001oogoo04Eoo`03001oogoo00=oo`8000Ioo`03001oogoo009oo`07001o
ogooOol007oo000027oo00@007ooOol000Aoo`05001oo`00Ool00002Ool01000Oomoogoo0`000goo
00X007oo001oo`00Ool007oo001oo`D000=oo`05001oo`00001oo`030002Ool01000Ool007oo0P00
0Woo00<007ooOol00goo00<007oo0000100000=oo`0000000P0000=oo`0000000Woo0P000Woo1P00
00=oo`0000000`0000=oo`0000000P0000=oo`00Ool027oo00<007ooOol00Woo00<007ooOol0>Goo
0@0000000`00Oomoo`1<Ool00`00Oomoo`06Ool00`00Oomoo`06Ool01@00Oomoogoo00000goo00L0
07ooOomoo`00Ool00004Ool00`00Ool00002Ool00`00Oomoo`0:Ool20005Ool00`00Ool000030004
Ool200000goo00000008Ool01000Oomoo`001Woo0P0027oo00<007oo00000P001Woo0P000Woo00<0
07ooOol01Woo00<007ooOol00Woo0P0017oo00<007ooOol00P000Woo00@007oo000003Uoo`400000
00<007ooOol0A7oo00<007ooOol027oo00<007ooOol00goo00D007ooOomoo`0000Moo`8000=oo`80
00Moo`04001oo`00Ool20002Ool01000Ool007oo1P0000Aoo`00Ool0009oo`T0009oo`03001oogoo
00H00003Ool0000000800004Ool00000Ool40002Ool01`00Ool007oo001oo`00009oo`04001oogoo
Ool200000goo00000002Ool01000Ool007oo0`001goo0P0000=oo`0000000P000goo00<007oo0000
0Woo00<007oo00000Woo00D007oo001oo`0003Moo`40000000<007ooOol0A7oo00<007ooOol017oo
0P000Woo00D007ooOomoo`0000Aoo`08001oogooOol007oo001oo`800003Ool0000000=oo`05001o
ogooOol00002Ool01000Oomoogoo1@0000Aoo`000000009oo`03001oo`0000800006Ool007oo001o
o`000Woo0`0000Eoo`00Oomoo`00009oo`05001oo`00Ool00002Ool300000goo001oo`02Ool30000
0goo0000000300000goo00000003Ool00`00Ool00002Ool40006Ool30002Ool30003Ool30002Ool2
00000goo000000020002Ool01000Ool007oo0P0000Aoo`00Ool003Moo`40000000<007ooOol0A7oo
0P001Goo0P001Woo00<007ooOol01Woo00<007ooOol00goo0P0017oo00@007oo000000=oo`05001o
ogooOol00005Ool00`00Ool000050002Ool01P00Ool00000Ool000Aoo`<0009oo`03001oo`00009o
o`<000=oo`8000Qoo`8000=oo`04001oo`000003Ool00`00Ool00003Ool30004Ool20004Ool00`00
Ool00003Ool200001Goo001oogoo00002Woo00D007ooOomoo`00009oo`03001oogoo03Eoo`400000
00<007ooOol0Bgoo0P000Woo0P000Woo00@007oo001oo`<0009oo`03001oo`00009oo`80000:Ool0
07oo001oo`00Ool007oo0002Ool01000Oomoogoo0`0000=oo`00Ool00`000Woo00<007oo00000P00
00=oo`00000010000Woo100000=oo`0000000Woo00H007oo001oo`00Ool200000goo00000002Ool0
1000Oomoogoo0P000Woo00<007oo00000Woo0P0000=oo`00Ool00P0000Aoo`00001oo`800003Ool0
07oo00@0009oo`<00004Ool00000Ool4000017oo001oogoo0P000Woo100017oo0P000Woo00<007oo
Ool0=Goo0@0000000`00Oomoo`19Ool00`00Ool00004Ool01`00Oomoo`00Ool007oo008000Uoo`80
0003Ool0000000800004Ool007oo0002Ool30002Ool00`00Oomoo`02Ool200000goo001oo`040002
Ool00`00Ool000060002Ool01000Ool000000goo1P000Woo00@007oo001oo`80009oo`<00003Ool0
07oo00<000Eoo`8000=oo`04001oogoo0006Ool40003Ool00`00Ool000030002Ool00`00Ool00002
Ool3000017oo000000000Woo00@007oo001oo`8003Ioo`40000000<007ooOol0BGoo00<007ooOol0
17oo00@007ooOol000Yoo`04001oo`00Ool20004Ool00`00Ool00004Ool20002Ool01@00Ool00000
Ool00P0000=oo`0000000P001Goo00@007oo001oo`<0009oo`8000=oo`03001oo`00009oo`03001o
o`0000Aoo`<0009oo`05001oogooOol00004Ool03@00Ool00000Ool007oo001oo`00Ool007oo00<0
00=oo`D0009oo`<000Aoo`05001oo`00Ool00003Ool3000:Ool00`00Oomoo`0gOol100000003001o
ogoo04Aoo`03001oogoo009oo`800003Ool007oo008000=oo`04001oo`00Ool20003Ool20002Ool0
0`00Ool0000300001Goo000007oo000017oo00<007oo00000Woo00<007oo00000`0000Aoo`00001o
o`<00006Ool00000001oo`000Woo0`0000Ioo`00000007oo0002Ool200000goo001oo`02000017oo
000007oo0P000goo00@007oo001oo`@00003Ool000000080009oo`04001oo`00Ool400000goo0000
00020002Ool00`00Ool000020003Ool500001Woo00000000Ool0009oo`D0009oo`<000=oo`800003
Ool007oo00=oo`04001oogoo0002Ool00`00Oomoo`0WOol100000003001oogoo041oo`04001oogoo
Ool20003Ool400000goo00000003Ool01@00Ool007oo000017oo00@007oo001oo`H00007Ool007oo
Ool007oo00000Woo0P000goo00<007oo0000100000=oo`0000000`0000Moo`00Ool007oo001oo`07
0002Ool20002Ool300001Goo001oo`00Ool0200000=oo`0000000goo00@007oo001oo`D00004Ool0
07ooOol2000017oo000007oo10001Goo0P000goo0P0000=oo`0000000`0000=oo`0000000goo1@00
00Eoo`00Ool007oo00800003Ool0000000=oo`8000Aoo`03001oogoo009oo`03001oogoo029oo`40
000000<007ooOol0@7oo00<007ooOol017oo00H007oo000007oo0006Ool01@00Ool007oo000017oo
0`0000=oo`00Ool00`000goo00D007oo001oo`00009oo`03001oogoo009oo`800003Ool007oo00Ao
o`03001oogoo00=oo`03001oogoo009oo`D0009oo`@00004Ool007oo0004Ool200000goo001oo`02
Ool00`00Oomoo`05Ool01@00Oomoogoo000017oo00<007oo000017oo0P000goo00@007oo001oo`80
00=oo`03001oogoo00800003Ool007oo00=oo`@000=oo`03001oogoo009oo`03001oogoo009oo`05
001oogooOol00006Ool00`00Oomoo`0ZOol100000003001oogoo041oo`03001oogoo009oo`04001o
ogooOol400000goo00000003Ool01000Ool007oo0`0000Aoo`00001oo`<00005Ool007oo001oo`03
00002Woo000007oo001oo`00Ool007oo0P0000=oo`0000000`0000=oo`0000001@0000Ioo`00Ool0
07oo0002Ool90003Ool300000goo000000020002Ool2000017oo001oogoo0P0000Eoo`00Ool007oo
00@00004Ool007oo0002Ool01P00Ool00000Ool0009oo`T00004Ool007oo0002Ool300000goo0000
000300001Goo001oo`00Ool00`0000Ioo`00001oo`00Ool20004Ool200001Goo000007oo000017oo
00<007ooOol08Woo0@0000000`00Oomoo`0hOol00`00Oomoo`02Ool01000Oomoo`000goo00D007oo
Ool007oo00@00004Ool007oo0002Ool01@00Ool007oo00000Woo1@0000Aoo`00Ool000=oo`<00004
Ool007oo0002Ool3000017oo000000000goo00<007oo00000P000Woo00<007ooOol00goo1@0000Eo
o`00Ool007oo00@00004Ool007ooOol600001Goo00000000Ool00P0000=oo`0000002@0000Eoo`00
001oo`00009oo`D00005Ool007oo001oo`0600000goo001oo`020003Ool>00000goo000000080003
Ool20002Ool00`00Ool00002Ool00`00Ool0000TOol100000003001oogoo03Qoo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo009oo`8000=oo`04001oo`00Ool20002Ool00`00Oomoo`030000
0goo00000002Ool30002Ool01@00Ool007oo00001Goo00@007oo001oo`<00003Ool007oo009oo`03
001oogoo00=oo`<00005Ool00000Ool00003Ool300000goo001oo`06Ool01`00Ool00000Ool007oo
00800004Ool00000Ool20002Ool02000Ool007oo001oo`00Ool200000goo00000003Ool30002Ool0
0`00Ool00003Ool20003Ool00`00Ool00003Ool01000Ool007oo0P000Woo00<007ooOol00Woo00<0
07oo00000P000goo00<007ooOol00P0000=oo`00Ool0:Woo0@0000000`00Oomoo`0]Ool00`00Oomo
o`08Ool200001Goo001oo`00Ool00P0000Aoo`00Ool0009oo`D00003Ool007oo00800004Ool00000
Ool400000goo0000000300000goo0000000200000goo0000000200000goo00000002000017oo001o
o`000Woo00<007oo00000`000Woo0P0000=oo`00Ool00P000goo1`000Woo10000Woo0`0000Eoo`00
Ool007oo00@00003Ool0000000<00004Ool007ooOol4000027oo000007oo001oo`00Ool2000017oo
000007oo1P0000Moo`00000007oo001oo`0300000goo0000000600000goo000000070002Ool00`00
Ool00003000017oo000007oo0`0017oo00<007oo00009Woo0@0000000`00Oomoo`0TOol00`00Oomo
o`06Ool00`00Oomoo`09Ool00`00Ool0000200001Woo000007oo001oo`800003Ool007oo00P00003
Ool0000000800005Ool007oo001oo`0600000goo001oo`070002Ool01P00Ool007oo001oo`D00004
Ool00000Ool7000017oo001oo`000Woo1`0000=oo`0000001@0000=oo`0000003`0000=oo`000000
0Woo00H007oo001oo`00Ool300000goo001oo`05000017oo000007oo0`0000Aoo`00001oo`800004
Ool007oo0002Ool2000017oo000007oo100000Eoo`00000007oo00T00003Ool0000000<00009Ool0
07ooOol007oo001oo`00029oo`40000000<007ooOol097oo00<007ooOol01Woo00<007ooOol027oo
0P0000Eoo`00000007oo00800003Ool007oo00800005Ool007oo001oo`07000017oo001oogoo0P00
00=oo`0000000Woo0P0000=oo`00Ool00goo00D007oo000007oo00<0009oo`04001oo`00Ool30002
Ool20002Ool30007Ool00`00Ool00002Ool01000Ool000000goo0P000Woo0`000goo00<007oo0000
0P000Woo00<007oo00000P0000=oo`0000000goo0P001Goo1@0000=oo`0000000P000Woo00@007oo
Ool0009oo`04001oogoo0002Ool20005Ool400001goo001oo`00Ool007oo00800005Ool007oo001o
o`020002Ool02@00Ool007oo001oo`00Ool00002Ool01@00Ool007oo00008Woo0@0000000`00Oomo
o`0TOol00`00Oomoo`06Ool01P00Oomoo`00Ool000Eoo`03001oogoo00P00004Ool00000Ool80002
Ool00`00Ool0000200000goo001oo`06000017oo001oo`000Woo100000=oo`000000100000=oo`00
00001`000goo0`000goo2@0000=oo`00Ool01P0000Aoo`00001oo`@00003Ool0000000D00003Ool0
07oo00P000=oo`04001oo`00Ool800000goo0000000700000goo001oo`020003Ool00`00Ool00006
00001Goo00000000Ool00P0000Eoo`00000007oo00H00004Ool00000Ool400001Woo001oo`00Ool0
029oo`40000000<007ooOol08goo0P000goo00H007oo000007oo0002Ool00`00Ool00004Ool20002
Ool3000017oo000000000Woo1P0000=oo`0000000`0000Moo`00Ool007oo001oo`05000017oo0000
07oo0P000goo1@0000=oo`0000002P0000Eoo`00000007oo00L000=oo`07001oo`00001oo`00Ool0
4@0017oo00<007ooOol01`000Woo0P0000=oo`0000000`0000=oo`0000000`0000=oo`00Ool00Woo
00<007oo00000`0000=oo`00Ool00`0000Eoo`00Ool007oo00X00003Ool007oo00800005Ool00000
001oo`0<000027oo00000000Ool007oo000ROol100000003001oogoo02=oo`800003Ool007oo00@0
0003Ool007oo00800003Ool007oo00=oo``00003Ool007oo01000003Ool0000000@00005Ool00000
001oo`0300000goo00000002Ool900000goo0000000@0004Ool3000017oo001oo`000Woo1@0000=o
o`0000000Woo0P000Woo10000Woo0`000Woo1P0000=oo`00Ool00Woo100000Aoo`00Oomoo`@00003
Ool0000000<00003Ool0000000H00003Ool0000000D00003Ool007oo00@00005Ool00000001oo`0=
0002Ool01P00Ool007oo001oo`<001ioo`40000000<007ooOol07Woo00<007ooOol00Woo0P0000=o
o`00Ool0100000=oo`00Ool00P0000=oo`00Ool00Woo0`0000=oo`0000000P0000=oo`0000000P00
00=oo`0000001@0000=oo`0000000`0000Aoo`00Ool0009oo`H0009oo`800005Ool00000001oo`02
00001Goo000007oo00001Goo0`000Woo00<007oo00000Woo0P0000=oo`00Ool00goo00<007oo0000
0Woo00@007ooOol000Eoo`0:001oo`00001oo`00Ool007oo0004Ool30002Ool30002Ool70003Ool0
0`00Ool00002Ool01000Ool0000017oo00D007oo000007oo00800003Ool007oo00=oo`03001oo`00
009oo`03001oo`0000800005Ool00000001oo`03000017oo001oogoo1P000Woo1`0000Moo`00001o
o`00Ool00003Ool00`00Oomoo`0LOol100000003001oogoo01aoo`03001oo`00009oo`07001oo`00
001oo`00Ool0100000=oo`00Ool0100000=oo`00Ool0200000Aoo`000000009oo`/00008Ool00000
Ool007oo001oo`D00003Ool007oo00L00003Ool007oo00L00003Ool0000000H0009oo`/00003Ool0
000000d00003Ool000000080009oo`800003Ool0000000<00003Ool007oo00L00003Ool0000000T0
0003Ool00000008000Aoo`T00003Ool007oo00800003Ool0000000D00005Ool00000001oo`040000
0goo0000000=00001Woo000007oo001oo`D0009oo`03001oogoo01Uoo`40000000<007ooOol06Goo
0P0000Eoo`00000007oo00800006Ool00000Ool007oo100000=oo`00Ool0100000=oo`00Ool02000
00=oo`0000002@0000=oo`0000001@0000=oo`0000000`0000=oo`0000000`0000=oo`0000004@00
00=oo`00Ool03`0000Eoo`00000007oo00<00005Ool007ooOol00003Ool9000017oo000007oo0P00
00Aoo`00001oo`D0009oo`H00004Ool00000Ool400000goo0000000@0002Ool01000Ool007oo3@00
00Aoo`00Oomooa000003Ool007oo00<00006Ool00000Ool007oo0P0067oo0@0000000`00Oomoo`0H
Ool7000017oo000007oo0P0000=oo`00Ool0100000=oo`0000000P0000Eoo`00000007oo00@00005
Ool00000001oo`070003Ool20002Ool6000017oo000007oo0`0000=oo`0000000P0000=oo`000000
0`0000=oo`0000000P0000=oo`0000000`0000Eoo`00Oomoo`00009oo`800003Ool00000008000=o
o`800006Ool007ooOol007oo0`000goo00@007oo001oo`@0009oo`D0009oo`03001oo`0000D00003
Ool007oo008000=oo`8000Eoo`H00003Ool007oo008000Aoo`03001oo`0000D000=oo`<0009oo`80
0005Ool007oo001oo`020003Ool500000goo0000000300000goo0000000600000goo001oo`030000
1Goo000007oo00000Woo00<007ooOol05Woo0@0000000`00Oomoo`0BOol00`00Oomoo`0=00000goo
0000000a0002OolH000017oo000007oo1`0000=oo`0000000P0000=oo`0000000P000Woo100000Ao
o`00Oomoo`P0009oo`D0009oo`D00003Ool0000000D00003Ool0000000H00003Ool0000000@00003
Ool0000000H00003Ool007oo00@00003Ool0000000800003Ool0000000<00005Ool007oo001oo`04
00000goo0000000D00000goo0000000400000goo001oo`020002Ool300000goo001oo`0@Ool10000
0003001oogoo00moo`800003Ool0000000h00003Ool0000002D00003Ool0000000T00007Ool00000
001oo`00Ool02`000Woo1@000Woo00<007ooOol01@0000=oo`0000000P0000=oo`00Ool0100000=o
o`000000100000=oo`0000000P0000=oo`0000005@000Woo1@000goo00<007oo00001P0000=oo`00
Ool0200000=oo`000000400000Eoo`00000007oo02`00003Ool007oo008000aoo`40000000<007oo
Ool03goo900000=oo`0000003@0000=oo`0000001@0000=oo`0000000Woo1P000Woo100000Aoo`00
Ool000=oo`<000Eoo`@0009oo`04001oo`00Ool300001Goo00000000Ool0200017oo00<007ooOol0
0Woo200000=oo`0000000Woo1`000Woo0P0000=oo`00000027oo00@007ooOomoo`80009oo`800004
Ool007oo0002Ool20002Ool01000Oomoogoo0`000Woo00<007oo00000Woo1@000Woo1`0000Aoo`00
Oomoo`800003Ool0000002400003Ool007oo00800003Ool007oo00Uoo`40000000<007ooOol03Goo
<@0000=oo`0000001`0000=oo`0000002`0000=oo`0000004`0000=oo`0000000`0000=oo`000000
0`0000=oo`0000001@0000=oo`000000100000=oo`0000002@0000Aoo`00Ool0009oo`03001oo`00
00D00003Ool0000000D0009oo`H0009oo`03001oogoo00D00003Ool0000000@00003Ool0000000P0
0003Ool0000000l00007Ool00000001oo`00Ool0;0002Woo0@0000000`00Ool0000o00000goo0000
000200000goo0000000300000goo0000000T00000goo0000000400000goo0000000=00000goo0000
000200000goo001oo`0300000goo000000030002Ool00`00Oomoo`0300000goo0000000200000goo
00000002000017oo000007oo3@0000=oo`0000000P0000=oo`0000001@0000Aoo`000000009oo`<0
0003Ool0000000<00003Ool0000000P0009oocH0005oo`40000000<007ooOol00goo?@0000=oo`00
00000P0000Aoo`00Oomoo`<00003Ool00000008000Aoo`@0009oo`800004Ool007ooOol70002Ool6
00000goo001oo`02Ool50003Ool200000goo001oo`0500000goo0000000200000goo001oo`020000
0goo00000002Ool3000017oo001oogoo0P0000=oo`0000000P0000Aoo`00Oomoo`80009oo`80009o
o`80009oo`8000Aoo`H0009oo`800003Ool0000000800007Ool007oo001oo`00Ool00P0000=oo`00
Ool00P0000Aoo`00001oo`D00003Ool000000080009oo`h00003Ool000000280009oo`40000000<0
07ooOol01goo1P0000=oo`000000@`0000=oo`000000200000=oo`0000004P0000=oo`0000002P00
00=oo`00Ool01@0000=oo`0000000`0000=oo`0000000P0000=oo`0000000`000Woo0`0000=oo`00
00004P0000=oo`0000000goo100000Aoo`00001oo`H00003Ool0000000<00003Ool0000001h00003
Ool0000002800003Ool007oo00Ioo`40000000<007ooOol03Woo;@0000=oo`0000005@0000=oo`00
0000300000=oo`0000001P0000Eoo`00000007oo01400003Ool0000000800003Ool007oo00d00004
Ool00000Ool600000goo0000000400000goo000000030002Ool00`00Ool00002000017oo000007oo
7@0000Moo`00000007oo001oo`0e00000goo001oo`08Ool100000003001oogoo011oo`800003Ool0
000000l00005Ool00000001oo`0G00001Goo00000000Ool01P000Woo2@0000Eoo`00000007oo00L0
0006Ool00000001oo`000Woo00<007oo00000P0000Eoo`00000007oo00D00004Ool007ooOol20000
17oo001oo`000Woo0P0000=oo`00Ool010000goo00@007ooOomoo`800003Ool007oo00<0009oo`08
001oo`00Ool007oo001oo`80009oo`80009oo`03001oo`0000<0009oo`<00004Ool007ooOol30000
0goo001oo`0300000goo00000002Ool400000goo001oo`04000017oo000007oo1`0000Eoo`000000
07oo00/00003Ool0000000800003Ool0000000T00003Ool0000000@00004Ool007oo000>Ool10000
0003001oogoo011oo`05001oogoo001oo`0C00000goo0000000X00000goo001oo`0500000goo0000
000;00000goo0000000300000goo0000000D000017oo000000000Woo0`0000=oo`0000001P0000=o
o`0000000`000Woo0`0000=oo`0000000Woo0P0000=oo`0000000P0000=oo`0000000P000Woo1@00
00=oo`0000002@0000=oo`0000000P0000=oo`0000002P000Woo2@0000=oo`000000700000Eoo`00
000007oo00800003Ool007oo00moo`40000000<007ooOol05Woo00@007oo001oo`L00003Ool00000
00@00003Ool0000001000003Ool0000000H00003Ool0000000H00003Ool0000000H00003Ool00000
01000003Ool0000000<00003Ool0000000@0009oo`@0009oo`X00004Ool00000Ool9000017oo0000
07oo0`0000=oo`00Ool01@0000=oo`0000000P0000Aoo`00001oo`800003Ool000000080009oo`L0
0003Ool00000008000=oo`P0009oo`800003Ool0000002d00006Ool007oo001oo`000Woo00<007oo
Ool047oo0@0000000`00Oomoo`0HOol00`00Oomoo`06000017oo000000000Woo00<007oo00003P00
00Aoo`00001oo`P00004Ool007ooOol20003Ool30002Ool01P00Oomoogoo001oo`H00003Ool00000
00<00003Ool0000000<00005Ool00000Ool00002Ool200001Goo00000000Ool01@0000=oo`000000
1`000Woo0P0000Moo`00Oomoo`00Ool00002Ool00`00Ool00002Ool300001Goo001oo`00Ool01@00
0Woo00H007ooOol007oo0002Ool20002Ool01000Ool007oo200000Aoo`00000000=oo`80009oo`80
0004Ool007oo0002Ool40006Ool700000goo0000000300000goo0000000300000goo001oo`060000
0goo001oo`020002Ool01`00Ool007oo001oo`0001Eoo`40000000<007ooOol067oo00D007ooOol0
07oo00@00003Ool0000000800003Ool007oo00@00003Ool0000000800003Ool0000001@00003Ool0
000000L00003Ool0000000X00003Ool0000000L00003Ool0000000800004Ool00000Ool400000goo
0000000400000goo0000000200000goo00000002Ool300000goo000000030002Ool400000goo0000
000200000goo0000000200000goo0000000800000goo0000000A000017oo000000000Woo100000=o
o`00Ool03P0000Aoo`00001oo`<00003Ool0000000H00003Ool0000000/00003Ool007oo00<00006
Ool007oo001oo`005goo0@0000000`00Oomoo`0NOol01P00Oomoogoo001oo`800003Ool007oo00@0
0003Ool0000000800003Ool007oo00P00004Ool00000Ool300000goo00000003000017oo000007oo
400000=oo`000000100000=oo`0000002@0000=oo`0000000`0000=oo`00Ool00P0000=oo`000000
100000Aoo`00Ool0009oo`@00004Ool00000Ool400001Goo00000000Ool00P0000=oo`0000001@00
0Woo00<007oo00001P0000Eoo`00000007oo00X00005Ool00000001oo`0300000goo001oo`060000
0goo001oo`0400000goo0000000200000goo0000000;00000goo00000009000027oo00000000Ool0
07oo000OOol100000003001oogoo02Aoo`800004Ool007ooOol300000goo0000000200000goo001o
o`020002Ool30002Ool2000017oo001oo`000goo00<007ooOol00P0000=oo`00Ool00Woo0`0000=o
o`0000001@0000Aoo`00Oomoo`@00005Ool00000001oo`0200000goo00000002Ool01`00Ool00000
Ool007oo0080009oo`8000=oo`<00003Ool007oo00@0009oo`800003Ool00000009oo`05001oogoo
Ool00002Ool300000goo00000003Ool300000goo00000002Ool20002Ool3000017oo000007oo0P00
0goo00@007ooOol000Aoo`05001oogoo001oo`0400000goo00000004000017oo000007oo0P0000Eo
o`00Ool007oo00H00003Ool0000000<00004Ool007oo0002Ool20002Ool00`00Ool0000200001Goo
001oogoo00007Woo0@0000000`00Oomoo`0TOol200000goo001oo`0200000goo001oo`02Ool20003
Ool300000goo00000002000017oo001oogoo0P0000=oo`0000000`0000=oo`00Ool00P000Woo1`00
00=oo`000000100000Eoo`00000007oo00800004Ool007oo0002Ool400000goo001oo`0500000goo
001oo`0300000goo0000000400000goo0000000200000goo00000002Ool00`00Ool0000800000goo
000000020002Ool01@00Oomoo`00Ool010000goo0P000Woo0`0000Aoo`00001oo`800004Ool007oo
Ool?00001Goo00000000Ool01@0000Aoo`000000009oo`H00003Ool0000001000006Ool00000001o
o`008Goo0@0000000`00Oomoo`0WOol01000Oomoo`002goo00<007ooOol00P000goo0P0000Eoo`00
Ool007oo00`00003Ool007oo009oo`800003Ool0000000<00005Ool007oo001oo`0500000goo001o
o`030002Ool20002Ool20002Ool:00001goo00000000Ool007oo00@0009oo`<00005Ool00000Ool0
0003Ool200000goo001oo`04Ool00`00Ool00002000017oo000000000Woo1`0000Ioo`00Ool007oo
0002Ool700000goo001oo`050002Ool300000goo000000070003Ool400000goo0000000400000goo
0000000200000goo000000020003Ool01@00Ool007oo00008Goo0@0000000`00Oomoo`0WOol01000
Oomoo`003Woo0P000goo0P0000Aoo`000000009oo`T00005Ool00000001oo`0300000goo00000006
00000goo0000000500001Goo001oo`00Ool00P0000Uoo`00000007oo001oo`00Ool0100000=oo`00
Ool0200000Eoo`00000007oo00@0009oo`03001oogoo00800003Ool007oo00/00003Ool0000000<0
0003Ool007oo00<00005Ool007oo001oo`0300000goo00000002Ool60002Ool2000017oo001oogoo
0`0000=oo`0000000P0000=oo`0000000P0000Eoo`00000007oo00H00003Ool00000009oo`800003
Ool0000000800003Ool0000000=oo`03001oo`0002=oo`40000000<007ooOol09goo00<007ooOol0
47oo00@007ooOomoo`800005Ool007oo001oo`0:0003Ool00`00Ool000020002Ool01@00Ool007oo
00000goo0P001Goo0`000Woo0P0000=oo`0000000P000Woo1P0000Aoo`00Oomoo`80009oo`@0009o
o`<00006Ool007ooOol007oo0P0000=oo`00Ool017oo00H007ooOol007oo0002Ool00`00Ool00003
00001Goo00000000Ool02@001Woo00T007oo000007oo001oo`00Ool00`0000=oo`0000000P000goo
0P0000=oo`0000001Goo00D007oo000007oo00L0009oo`05001oo`00Ool00007Ool00`00Ool0000S
Ool100000003001oogoo03Uoo`8000=oo`8000=oo`09001oo`00001oo`00Ool007oo00L00003Ool0
000000D00004Ool00000Ool40002Ool200001Woo001oogoo001oo`800005Ool007oo001oo`030000
0goo0000000400000goo00000002Ool20002Ool200000goo0000000800000goo00000002Ool01`00
Ool007oo001oo`0000=oo`800004Ool007ooOol30002Ool00`00Ool0000400001Goo001oo`00Ool0
1P000goo1`0000=oo`00Ool0100000Aoo`00Oomoo`800003Ool007oo00<00003Ool0000000<00004
Ool000000003Ool02000Ool00000Ool007oo0002Ool00`00Ool0000UOol100000003001oogoo03Uo
o`03001oogoo009oo`8000=oo`07001oo`00001oo`00Ool01@0000Aoo`00000000=oo`03001oo`00
00<00006Ool007oo001oo`000Woo100000Eoo`00000007oo00@00003Ool007oo00D00004Ool007oo
Ool5000017oo000007oo1P000Woo0`000goo00@007oo001oo`L000=oo`800003Ool0000000<00003
Ool007oo009oo`03001oogoo00<00006Ool00000Ool007oo0P0000=oo`00Ool00P0000=oo`000000
0`0000=oo`00Ool00Woo100000=oo`0000000P0000Aoo`000000009oo`P00003Ool0000000800003
Ool007oo00800004Ool007oo0004Ool00`00Oomoo`0SOol100000003001oogoo03Uoo`8000=oo`80
00=oo`09001oogoo001oo`00Ool007oo00D00004Ool007ooOol20002Ool3000017oo001oo`000goo
0`0000Ioo`00Ool007oo0003Ool20006Ool00`00Oomoo`0500000goo00000003Ool01@00Oomoogoo
00000Woo00D007ooOomoo`00009oo`03001oogoo00Ioo`03001oo`00008000=oo`03001oogoo0080
00Ioo`07001oo`00001oo`00Ool00P0000Qoo`00000007oo001oo`0017oo0P0000Eoo`00Ool007oo
00@0009oo`80009oo`03001oogoo00Aoo`@00003Ool00000009oo`8000Aoo`05001oogooOol0000/
Ool100000003001oogoo03Uoo`8000Aoo`06001oogooOol007oo0P0000Eoo`00Ool007oo00L00006
Ool00000001oo`000Woo0`0000=oo`00Ool00P0000=oo`000000100000=oo`00Ool00P000goo00<0
07oo00000Woo0P0000Moo`00000007oo001oo`040002Ool00`00Ool0000400001Goo001oo`00Ool0
0P0000Ioo`00001oo`00Ool600000goo001oo`04000017oo000000000Woo00@007oo001oo`@00003
Ool00000009oo`H00003Ool0000000@0009oo`04001oogooOol400000goo001oo`0200000goo0000
000200000goo001oo`0200000goo000000030002Ool00`00Oomoo`02Ool00`00Ool00004Ool00`00
Oomoo`0UOol100000003001oogoo03Uoo`03001oogoo009oo`8000=oo`09001oogoo001oo`00Ool0
07oo00<0009oo`800004Ool007oo0002Ool3000017oo0000000017oo0`0000=oo`0000000P0000=o
o`0000000P0000Aoo`00Ool0009oo`T00003Ool007oo00@0009oo`800004Ool007ooOol300000goo
00000002Ool01000Ool007oo0`0000=oo`0000000`0000Aoo`00001oo`@00004Ool007ooOol30000
0goo001oo`0200000goo0000000300000goo0000000200000goo00000002000017oo001oogoo0`00
00Ioo`00Ool007oo0002Ool01@00Ool00000Ool00P000Woo00<007ooOol01@0000Qoo`00Ool007oo
001oo`00;7oo0@0000000`00Oomoo`0nOol00`00Oomoo`02Ool00`00Oomoo`04Ool30005Ool01@00
Ool007oo00000Woo0P000Woo00@007ooOol000Ioo`<00003Ool007oo008000=oo`03001oo`0000Mo
o`8000=oo`04001oo`000002Ool00`00Oomoo`02Ool01000Oomoo`001goo0`000Woo00@007ooOol0
00=oo`<00004Ool007ooOol20003Ool200001Woo001oogoo001oo`80009oo`06001oo`00Ool007oo
0P000Woo0P000Woo00<007ooOol00Woo0`0000=oo`00Ool00P000Woo00D007ooOomoo`0000=oo`80
00Eoo`03001oogoo039oo`40000000<007ooOol0?Woo00<007ooOol00Woo00@007ooOol000=oo`04
001oo`000004Ool01P00Ool007oo001oo`<0009oo`05001oogooOol00002Ool200001Woo00000000
Ool000Aoo`04001oo`00Ool30002Ool200001Woo001oo`00Ool0009oo`05001oo`00001oo`020000
17oo000007oo0P0000=oo`00Ool00P0000Aoo`00Oomoo`80009oo`04001oo`00Ool600001Woo0000
07oo001oo`@0009oo`@000Aoo`<000Eoo`03001oo`0000800004Ool007ooOol5000017oo000007oo
0P000goo00@007oo001oo`8000=oo`07001oo`00Ool007oo00000goo00<007ooOol0;7oo0@000000
0`00Oomoo`0nOol00`00Oomoo`02Ool01000Oomoo`001Woo00@007ooOomoo`8000=oo`04001oo`00
Ool200001Woo001oo`00Ool000=oo`800003Ool0000000=oo`8000=oo`05001oo`00001oo`030000
0goo001oo`020002Ool800000goo0000000400000goo000000030004Ool400000goo00000003Ool4
000017oo001oogoo0P0000=oo`00Ool01Goo00L007ooOol007oo001oo`0200001Goo001oo`00Ool0
100000Aoo`00Ool000=oo`09001oogoo001oo`00Ool007oo00@0009oo`04001oogooOol2000017oo
001oo`001Goo00<007ooOol0;7oo0@0000000`00Oomoo`16Ool00`00Oomoo`03Ool00`00Oomoo`03
Ool00`00Ool00004Ool01000Ool007oo100037oo0P000goo00@007ooOol000Eoo`<00006Ool00000
001oo`000goo00@007ooOomoo`800003Ool0000000=oo`03001oogoo0080009oo`8000Uoo`06001o
ogooOol007oo0P000goo0`0000=oo`00Ool00goo00@007ooOomoo`8000Qoo`03001oogoo009oo`03
001oo`0000800003Ool007oo0080009oo`07001oo`00Ool007oo00000Woo00D007ooOomoo`0003Io
o`40000000<007ooOol0AWoo00<007ooOol00Woo0`0017oo00D007oo001oo`0000=oo`800003Ool0
07oo00@0009oo`03001oogoo008000=oo`800004Ool007oo0002Ool00`00Ool0000200000goo001o
o`0200000goo00000009000017oo001oo`000goo00L007oo001oo`00Ool00003Ool200001goo001o
o`00Ool007oo00@00006Ool00000Ool007oo100000=oo`0000000Woo100000Moo`00Oomoo`00Ool0
0002Ool00`00Ool00003Ool400000goo000000020004Ool5000017oo001oogoo0`0000Aoo`00Ool0
00=oo`03001oo`0002ioo`40000000<007ooOol0BWoo0P001Woo00<007ooOol017oo0P0017oo00<0
07ooOol00Woo00<007ooOol00P000Woo00X007oo000007oo001oo`00Ool0009oo`800003Ool007oo
00<00003Ool0000000Eoo`8000=oo`05001oogooOol00002Ool200000goo000000030003Ool01000
Ool000000Woo00<007ooOol00Woo200000Aoo`00Oomoo`T00003Ool00000009oo`07001oogooOol0
07oo00000goo00<007oo00000`0000=oo`0000000Woo00D007oo001oo`0000Ioo`03001oo`0000=o
o`03001oogoo031oo`40000000<007ooOol0C7oo00<007ooOol01goo00<007ooOol00Woo00H007oo
Oomoo`00Ool20006Ool01@00Ool007oo000017oo00<007ooOol00P001Goo00<007ooOol00Woo00H0
07ooOomoo`00Ool2000027oo001oo`00Ool007oo0002Ool2000<Ool01000Ool000000goo1P000goo
0P000Woo00H007ooOomoo`00Ool40004Ool01@00Oomoogoo000017oo0P000Woo00L007ooOomoo`00
Ool0000@Ool00`00Oomoo`0bOol100000003001oogoo04Yoo`04001oo`000004Ool01@00Oomoogoo
00000Woo00L007ooOomoo`00Ool00004Ool20002Ool200000goo001oo`03Ool00`00Oomoo`02Ool0
0`00Oomoo`020002Ool20002Ool20003Ool01000Ool000000Woo0P0000Eoo`00Oomoo`0000=oo`<0
00=oo`800004Ool00000Ool700000goo001oo`02Ool20003Ool3000017oo000007oo0`0000=oo`00
000017oo00d007oo001oo`00Ool007oo001oo`00Ool00004Ool00`00Ool00002000>Ool01@00Ool0
07oo0000<7oo0@0000000`00Oomoo`1;Ool30004Ool01@00Oomoogoo00000Woo00D007ooOomoo`00
00Ioo`8000=oo`03001oogoo00Aoo`04001oo`00Ool2000017oo001oo`000Woo0P000Woo0P0017oo
0P0000Aoo`00Ool000=oo`<000=oo`05001oogooOol00002Ool300000goo00000003Ool00`00Oomo
o`0300001Goo001oogoo00000Woo00@007oo001oo`800003Ool007oo00@00003Ool007oo00Eoo`03
001oo`00009oo`@0009oo`05001oo`00001oo`02000017oo000000001Goo0P0000=oo`00Ool00Woo
00<007ooOol0<7oo0@0000000`00Oomoo`1:Ool00`00Oomoo`05Ool01@00Oomoogoo00002Woo0P00
2goo00<007ooOol02goo00H007ooOol007oo0006Ool01`00Oomoogoo001oo`00009oo`05001oogoo
Ool00002Ool00`00Oomoo`04Ool01P00Ool007oo001oo`80009oo`03001oogoo00Ioo`04001oogoo
0002Ool00`00Ool00002Ool20003Ool00`00Oomoo`09Ool20002Ool00`00Oomoo`03Ool01@00Ool0
07oo00001Woo00<007ooOol0=Woo0@0000000`00Oomoo`1=Ool00`00Oomoo`06Ool00`00Oomoo`04
Ool01000Oomoogoo0P001Woo00<007ooOol027oo100000=oo`00Ool01Goo0P0000=oo`00Ool00Woo
00D007oo001oo`0000=oo`<00004Ool007oo0003Ool01@00Ool007oo00000Woo1@0000Eoo`00Oomo
o`00009oo`800006Ool007ooOol007oo0`000Woo0`0000=oo`0000000goo0P0000Aoo`00Ool000=o
o`80009oo`05001oogoo001oo`020002Ool00`00Oomoo`08Ool00`00Oomoo`05Ool00`00Oomoo`0^
Ool100000003001oogoo059oo`05001oogooOol0000:Ool00`00Oomoo`05Ool00`00Oomoo`02Ool0
1@00Ool007oo00000goo00H007ooOomoo`00Ool20003Ool00`00Oomoo`03Ool01000Ool000000goo
00@007oo001oo`D00003Ool0000000@00005Ool00000001oo`0300000goo001oo`03000017oo0000
00001Woo00@007oo001oo`<00004Ool007oo0003Ool02P00Oomoo`00Ool007oo001oo`000Woo00D0
07ooOomoo`0000=oo`03001oogoo011oo`03001oogoo02ioo`40000000<007ooOol0EWoo00<007oo
Ool027oo00D007ooOomoo`0000Qoo`05001oo`00Ool00009Ool20003Ool00`00Oomoo`03Ool01@00
Oomoogoo000017oo00<007ooOol02goo00@007ooOol000Eoo`04001oo`000002Ool00`00Ool00004
Ool20008Ool01000Ool007oo0P000goo00D007oo001oo`0000Aoo`8000Qoo`03001oogoo00Ioo`03
001oogoo03Ioo`40000000<007ooOol0BWoo00<007ooOol02Goo00<007ooOol047oo00<007ooOol0
0Woo00L007oo001oo`00Ool00004Ool00`00Oomoo`03Ool02`00Ool007oo001oo`00Ool007oo0000
1Goo0P0000=oo`00Ool00Woo00<007oo00000goo00@007oo001oo`8000=oo`06001oo`00001oo`00
0Woo00<007oo00000Woo00<007oo00000Woo0`0000Qoo`00001oo`00Ool007oo0P0000Aoo`00Ool0
00Eoo`03001oogoo00Aoo`09001oogooOol007oo001oo`0003moo`40000000<007ooOol0CGoo00<0
07ooOol01Woo00<007ooOol017oo00<007ooOol02Goo00<007ooOol017oo00D007ooOomoo`0000io
o`04001oo`00Ool2000017oo001oo`001Goo00<007oo00000P0000=oo`00Ool020000goo0`000Woo
00@007oo001oo`80009oo`03001oogoo00=oo`05001oogooOol00006Ool00`00Ool00005Ool00`00
Ool00002Ool01@00Oomoogoo00001Goo00<007oo0000?goo0@0000000`00Oomoo`1FOol00`00Oomo
o`08Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`03Ool01@00Oomoogoo00001Goo00<0
07oo000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo00ao
o`03001oo`00009oo`03001oogoo00Ioo`8000aoo`05001oo`00Ool00007Ool00`00Oomoo`0mOol1
00000003001oogoo04Yoo`03001oogoo011oo`03001oogoo00Uoo`03001oogoo009oo`07001oogoo
Ool007oo00001Goo00@007oo000000Moo`03001oogoo00800003Ool0000000Aoo`03001oogoo009o
o`05001oo`00Ool00002Ool00`00Oomoo`0200000goo0000000:Ool00`00Oomoo`02Ool01@00Ool0
07oo000017oo00<007ooOol00goo00L007oo001oo`00Ool00003Ool01@00Oomoogoo00001Woo00<0
07oo0000@Goo0@0000000`00Oomoo`1:Ool00`00Oomoo`0QOol01`00Oomoogoo001oo`0000Aoo`80
0005Ool007ooOol00005Ool00`00Ool00005Ool200001Goo000007oo000017oo0P0000=oo`000000
0goo00@007ooOol000Eoo`80009oo`03001oogoo00Aoo`03001oogoo00Uoo`04001oogoo0003Ool0
1`00Ool007oo001oo`0000Ioo`03001oogoo00800004Ool007oo000oOol100000003001oogoo04Yo
o`03001oogoo01Aoo`03001oogoo00Eoo`03001oogoo011oo`04001oogoo0005Ool01000Ool00000
0goo00<007ooOol00goo00<007ooOol00goo0P000Woo00@007ooOol000Ioo`04001oogoo0002Ool2
0006Ool00`00Ool00002Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000Qoo`03001oo`0000Mo
o`03001oogoo03moo`40000000<007ooOol0NWoo00<007ooOol02Woo00<007ooOol00goo00H007oo
001oo`00Ool400000goo001oo`02Ool00`00Oomoo`04Ool00`00Ool00002Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Ool00009Ool00`00Ool00008Ool00`00Oomoo`09Ool00`00Oomoo`12Ool1
00000003001oogoo065oo`03001oogoo00Eoo`03001oogoo00ioo`03001oo`0000Qoo`03001oogoo
00Aoo`03001oogoo009oo`04001oogooOol200001Goo00000000Ool00P002Woo0`000Woo00<007oo
Ool01Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007oo
0000?goo0@0000000`00Oomoo`1QOol00`00Oomoo`05Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool0
1@00Oomoogoo00002Goo00<007ooOol017oo00@007ooOomoo`8000Aoo`05001oogoo001oo`020000
1Goo000007oo00001Woo00<007ooOol02goo100000=oo`00Ool00Woo00<007ooOol03Woo00<007oo
Ool0?Goo0@0000000`00Oomoo`1bOol00`00Oomoo`0@Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Ool0000<Ool00`00Oomoo`04Ool00`00Oomoo`07Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool0
0`00Ool00007Ool00`00Oomoo`0oOol100000003001oogoo06Uoo`03001oogoo00Ioo`03001oogoo
00Moo`03001oogoo00Aoo`04001oogooOol2000;Ool01@00Ool007oo000017oo00<007ooOol01Woo
0`000goo0P0027oo00<007ooOol01Woo00<007ooOol03Woo0P002Woo00<007ooOol0?Goo0@000000
0`00Oomoo`1lOol00`00Oomoo`08Ool00`00Oomoo`09Ool20003Ool01000Oomoogoo0P0000=oo`00
Ool01Woo00<007ooOol00Woo0`000goo00<007oo00003Woo00<007oo00002goo0P0017oo00<007oo
Ool0@Woo0@0000000`00Oomoo`1bOol00`00Oomoo`0UOol00`00Oomoo`0;Ool00`00Ool00002Ool0
0`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`0GOol00`00Oomoo`12Ool100000003001oogoo
08Eoo`03001oogoo00Aoo`03001oogoo008000Uoo`04001oo`000007Ool01000Oomoo`0017oo0P00
3Woo00H007ooOol007oo0002Ool00`00Oomoo`1DOol100000003001oogoo08aoo`05001oo`00Ool0
0007Ool00`00Ool00002Ool00`00Ool00002Ool01P00Oomoo`00Ool0009oo`03001oogoo01=oo`05
001oogooOol0001GOol100000003001oogoo0:Eoo`03001oo`0000ioo`03001oogoo00]oo`03001o
ogoo05Eoo`40000000<007ooOol0Pgoo00<007ooOol01goo0P001Woo00<007ooOol097oo00D007oo
Oomoo`0005]oo`40000000<007ooOol0TWoo0P0017oo00<007ooOol017oo00<007ooOol027oo00<0
07ooOol01Goo00D007ooOomoo`0006Eoo`40000000<007ooOol0TWoo00<007ooOol02Woo00<007oo
Ool01Goo00<007ooOol0LWoo0@0000000`00Oomoo`2<Ool00`00Oomoo`06Ool01000Oomoo`00Pgoo
0@0000000`00Oomoo`2COol00`00Oomoo`02Ool00`00Oomoo`21Ool100000003001oogoo08eoo`03
001oogoo03Eoo`03001oogoo05Aoo`40000000<007ooOol0QGoo00<007ooOol017oo00<007ooOol0
=Woo00<007ooOol0E7oo0@0000000`00Oomoo`23Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool00`00
Oomoo`21Ool100000003001oogoo0?mooaeoo`40000000<007ooOol0V7oo00<007ooOol047oo00<0
07ooOol03Woo00@007ooOol000Eoo`03001oogoo05Aoo`40000000<007ooOol0S7oo0P000Woo00<0
07ooOol067oo00<007ooOol04Woo00<007ooOol0FGoo0@0000000`00Oomoo`3oOolMOol100000003
001oogoo08Eoo`03001oogoo09Aoo`40000000<007ooOol0Pgoo00<007oo00001goo00@007ooOol0
08]oo`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`23Ool00`00Oomoo`2FOol100000003
001oogoo0:]oo`03001oogoo06ioo`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`2oOol2
001KOol100000003001oogoo091oo`03001oogoo08Uoo`40000000<007ooOol0T7oo00<007ooOol0
RGoo0@0000000`00Oomoo`3oOolMOol100000?l002400000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250053, 
  0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["WindowsSound", "\<\
DTU6ATIF001G@EI5IVed8100000100404B/0014[000100P0I65dHB9F002;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;S8b<S8b<S8b<
S8b<S8b<S8b<S8b<S8b<S8b<S8b<Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;S8b<S8b<S8b<S8b<S8b<S8b<
S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8b<Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^<S8b<S8b<S8b<
S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8b;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:RX^;Rh^;Rh^;Rh^;Rh^;Rh^;S8b<
S8b<S8b<S8b<S8b<S8b<S8b=SHf=SHf=SHf=S8b<S8b<S8b<S8b<S8b<S8b<S8^;
Rh^;Rh^;Rh^;Rh^;RhZ:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:Rh^;Rh^;Rh^;
Rh^;Rh^<S8b<S8b<S8b<S8b<S8b=SHf=SHf=SHf=SHf=SHf=SHf=SHb<S8b<S8b<
S8b<S8b<Rh^;Rh^;Rh^;Rh^;RhZ:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:
RX^;Rh^;Rh^;Rh^;Rhb<S8b<S8b<S8b<S8f=SHf=SHf=SHf=SHf=SHf=SHf=SHf=
SHf=S8b<S8^;Rh^;Rh^;Rh^;Rh^;Rh^;RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ:RXZ;
Rh^;Rh^;Rh^;Rh^;Rh^;S8b<S8b<S8b<S8b<S8b<S8b<S8b<SHf=SHf=SHf<S8b<
S8b<S8b<S8b<S8b<S8b<S8b;Rh^;Rh^;Rh^;Rh^;Rh^;RhZ:RXZ:RXZ:RXZ:RXZ:
RXZ:RXZ:RXZ;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^<S8b<S8b<S8b<S8b<S8b<S8b<S8b<
S8f=SHf<S8b<S8b<S8b<S8b<S8b<S8b<S8b<S8^;Rh^;Rh^;Rh^;Rh^;Rh^;RXZ:
RXZ:RXZ:RHV9RHV9RHV9RHV9RHV:RXZ:RXZ:RXZ:RXZ:RX^;Rh^;Rh^;Rh^;S8b<
S8b<S8b<S8b<S8b=S8^:RXZ:Rhf>Si2@T8n=S8^:RXZ:Rhf>Si2@Shj=RhZ9RHV:
Rhb>Shn?SXf;RXV8R8V:Rhb=SXj>SHb;RHR8R8V:Rhf>Shn>SHb;RHV8RHZ;S8j?
Shn?SHb;RXV9RHZ<SHn@T92?SXb;RXV9RX^<SXn?T8n>SH^:RHR8RHZ<SHj?SXj<
RhV8QhN7R8V;S8f=SHb;RHR6QXJ6QhV:Rhb<S8^:R8N6QHJ6R8V;S8f=S8^:RHN7
QXN8RX^=SXn>SXf;RXV8R8V:S8f?T92@Shj=RhZ:RX^<SXnATI:AT8j=Rh^:RX^=
SY2ATI6@Shf<RXZ9RX^<SXn@T92?SH^:R8R8R8V;S8j>Shj=RhZ8QhN7R8V;S8f>
SXf<RhV8QhN7R8Z<SHj?Shj=RhZ8R8R9RX^=Si2@T8n=S8Z9R8V:Rhf>T92@T8n=
RhZ9R8V:Rhf>Si2?SXf;RHR7QhN8RX^=SXj=S8^9QhJ5QHJ7RHZ;S8b<RXV7QXF4
QHJ7RH^<SHf<RhV7QXF5QXN9Rhf>Shn>SH^:R8R8RH^=Si2ATY6@Shf<RhZ;S8f?
TI>CTi>AT8j<Rh^<SHj@TY>CTi:@SXb;RXV:Rhf>T96AT8n=RhV8QhN8RH^<SXj>
SHb:R8J5QHF6R8Z;SHf=S8^9QhJ5QHJ7RH^<SXj>SH^:R8N6QhR9Rhf?T92@Shf;
RXV8RHZ;SHnATI6AShf;RXV8RHZ<SXnATI6?SX^9R8N7QhV:S8j>Shj<RXR6QHB4
QHN9RXb=SHb:R8J4Ph>3QHN9RXb=S8b:R8J5Q8F6QhV;SHn?Shj=RhV8R8R9Rhf@
TI>CTi6@SXb;Rhb=Si6CUIFEU9>AShf<S8b>T9:CU9FDTi6?S8^:RXZ<SHnATI6@
Shb:R8J6QXN8RXb=SXf<RhR6Q8>3PhF6R8Z<S8b;RHN5Ph>3Q8J8RXb=SXf<RXV7
QXF6QhV;SXn@TI2?SH^9R8R9RXb?TI:CTi:@SXb:RHV:Rhf?TI:BTY2>S8V8QhN8
RH^=Shn?SXf:R8J4Q8B5QhV;S8f<RhV7QH>2PX>4QXV;S8f=RhZ8QXB4Q8F7RHb>
Si2@SXf;RHR8R8Z<Si6CU9FDTY2>SHb<S8j@TiFFUiNFU96?SXf<SHnATiFFUYFC
THj<RXV9RXb>Si6ATI2>RhV7QHB4QXN9Rhb=S8^9QXB2PH61PhF7RH^;RhV7QH>2
PH63QHN9S8f=SH^9QhJ4Q8F7RHb>T96BTHn=RhV8R8V;SI2BU9BDTi6>S8Z9RHZ<
SY6CU9BCTHn<RXR7QhR:S8j@T92?SHZ7QHB3Q8F7RH^=SHf;RHN4PX61PXB6RH^=
SHf;RHN5Q8>4QHN:SHn@TI2?SH^9R8R9RXf@TYBFUYFCTHn=S8b=Si:DUYRHV9JD
TXn=S8b=Si6DUIJFUI>ASX^9R8V:Rhf?TI6AShf:QhF3PX>4QXR:S8b;RXN5PX1o
Oh22Q8N9RXZ:R8J3PH1oP864QhV<SHf=RhV7QHB4QHN:S8nATY:AShf;RHR8RXb?
TIBEUYFDTHn<RhZ:Rhf@TYBEUIBBShb:R8N7RH^=Si6ATHn=RXN5Ph>4QHN:S8f>
SH^9QXB2PH62Q8N:S8f>SH^9QhB3Ph>5R8^>T96BTHn=RhV8R8V;SY6DUYNGUI>A
SXf<S8f?TYFGVIVHUYBAShf<S8f?TYBFUiJETi2<RXR7QhV;SHn@TI2>S8R5Ph61
PX>5R8Z;RhZ8QX>0OWemOh64QXR:RXV7QH:0OgioPHB7RXb=SXf;R8J4Ph>5QhZ=
T9:CTi:@SH^9R8V:SI2CUINGUYBBShb;RXZ<SY6DUYJFUI:?S8Z8QhR9S8j@TY:B
T8f:QhF3PhB6R8^=Shn>S8V6Ph61PH:5R8^=SXj=S8V6Q8>3Q8J9S8nATY:ASXb9
QhJ6QhZ=T9>DUIFCTHj<RXV9Rhf@TiJGUiJDTHj<RXV:RhjATiFFUYBASX^9QhJ7
RH^>T96BTHn<RHF3PH62Q8N:S8f=S8Z7Q85oOWj0PXF8RX^;RXR5PX1nOWn1Q8N:
S8j=S8Z7QH>2PXB6RHf?THj=S8Z7QH>3QHR:SY6DUYJETi6>S8Z:Rhf@TiJHVIVH
UI:?SHb<SHnBUINIVYVGU96>RhZ:S8jAU9JGUiJDTHj;RHR9RXf@TiFFUYBBShb9
QhN8RXf@TiFFUIBASX^9R8R:S8nBUINGUYBASX^9R8R:SI2CUIJFU9:?RhR7QXJ8
Rhj@TY:AShb9QH:1P863QHR:S8b:R8F1OW]jNW]mP8>5QXJ4PWikN7IeMWQkOX63
Q8B3P7ejN7MgN7]nPXF7R8R6Q85oOGamOh>6RXf?T92>S8V7QHF6RHb@TiJHV9NE
TXn=S8b=T9>GVYbMW9^HUI:?SXj?TYFHVYbLViVETXn<Rhb=T9>EV9VHUiB@SHZ8
QhR9S8nBU9FDTXn<RHJ4Q8F8RhjATi>BT8f:QhF4Q8J9S8nBTiBBT8f:QhF5QHR;
SY6CU9BBT8b9QXB4QHN:SY2BTi:@SHV6Ph:2PhF8Rhj?Shj;R8B1OWenP8:6RH^<
S8Z7Q85nO7amOh:6RH^<S8Z7Q85oOWj0PhN:SY2AT8n<RHN5Q8F8RhnCUYRIV9JC
T8j<S8j@U9RLWZ2PWYbHUI>ATI>EVIbOXJ:QWY^HU9:@T9:DUi^MWYjLVIFASX^:
RXb>TIBFUYFCT8b8Q8:2PXB7RXf?Shj;R8B0OGalOH23QXV:RhV7Q81mNgYkOH23
QhZ;RhZ7Q81mO7]mOh>6RXb=SH^8QH9oOWioPXJ9S8j?SX^8QH5oOWj0PhN:SHj>
SHZ6Ph1mOGj0PhJ:S8f=RhR4PGilO7j0Q8R;SHj=RhR5PX1oP8:5RHf@TY>BT8f9
QhF5QXV=TIFHVYZIUY>@SXb<SY6EVIbOX9nMVYNDTI2@TYFHW9nQXJ2MVYJBShj>
T9>FVI^LW9ZFTXj:R8N7RHb?TYBDTi6=RHB1OgioPXF8Rhb=RhV5PGmlNGUjOH66
RXb<RXJ2OGYiNWaoPhJ9Rhb<RhV7Q85oOh22QX^@TiFDTXj9QX>3QHR<T9>EUYJE
Ti6>S8V8R8V<T9BHVY^IUI2;QhJ6R8b?TiFGUiFCTHj;R8N6QXR<Si>FV9NDShZ6
Ph>4R8b@U9JFUYBAShb:RHR8RXfAUIRKViZFTXf:R8R;SiBHVifLVYRETXn=S8b=
Si:EVI^LViRDSXZ6QHJ9SI6EUYJDTHf9QX>1P862Q8J9Rhf<RXJ1O7MeMGMkOh>6
QhJ3P7ahMWAdM7IhNgj1Q8F4PWijMW=cM7QmPhR:RhZ7Q81nO7anP8>6RXf@TY:A
Sh^7Q8:3QXZ@UIVKVYRDT8b:RHZ;SY6DUYVJVYVGThn;R8N8Ri2DVI^KVIF@RhR6
QHJ9RhjATiBEU9:?RhN4PX:4R8bAUINFThj:QX>2PhF9S92BU9FEU96>RhR5QHJ9
SY>HVi^IUY6<R8N7RHb@TiJHVIRGUI:>RhR6QXR;T9BGVIRDT8Z5PX21PhN;SY2@
T8j<RHF2OgelOGn3Qh^>Shf9Q7ijN7QkOX>7RXb=S8Z8QH:0OWj4QXV>TYJHV9FA
S8N4PhB8S96EV9VHUY>ASX^9R8R:SI6EVIbLViNBSHV7QhV=TYNJW9bJUiB@SH^:
RX^=T9BGVYbKVIB?RXJ5QXV=TYJIVIRETHf9QhF5QHN:SI2CUIFDT8^6PGinP8B9
SY6CTY2<Qh>0OgioP8>6RHb>Shj<R8=nNWUiOH:7Rhj?SHZ5PGekNW]mOh:5R8^=
SH^8Q7mkNGQkOhB:SY2@SHV4P7ilOGn1QHR;SY2@T8j:QX9oOGj2QhfBUIJETHf8
Q8:2PhJ:SI2CUIJEU96=RHF3PhF9SYBHViZHThj9QXF5R8^?TYFGV9NFTi2<R8J4
QHR=TYNJViZFT8^6Q8B5RHb@TiFFUYBBSh^8Q8:2Q8R<TIJHV9F@RXF1Oh23Qh^?
TY>CTHn<RHF2P7n0PhN<TIBFU92;QH5nOX24R8fATi>BT8f:QhB2PH:4QhbAUING
UI2;QH60PHB9SY>FUiJDTXj;R8J5QHN:SY:GVY^JUi6<QhB4QXZ@UIVKViZGTi2=
RXV9RXb@U9RKWIfKUY6;QhF6RHjCV9^LViRDT8b:R8N8RXf@U9NIVYRET8Z5PH62
RHnDVI^JV9B@RhR6QHJ8RXfAU9JHUiFARhJ2P823R8jCUijLV9:<QX9oOWn0PXF8
RXb=S8V6PWmmOX67SIBJWIfKUY6;QhB3PhB6R8Z;S8b;R8F0O7YiNWn5SIBIW9bI
UI2<RHR9Rhf@TY>DTi6?RXJ1O7UiNh26SI>GVIRDT8b9R8V<Si>FVIZJV9FAS8N2
OGYjO866S92BTXn;QX:1PHB8SY>GVIZJV9F@RhJ1OWalOX:6RXb<RHEoNWMfMg^1
QhfATiBDTXn;Qh>0OWeoPHF9Rh^9Q7ihLVm_LGIlPhR<SXn>S8Z8QHB2PXB7RhnB
Ti:?RH9kMG9cMW^1Qh^>Shj=RhV8QhN8RXjBUi^OX9jIThb5P7ioPhR=TIBEU9:?
SH^:RX^>TYNLXJJYZZNSWIJ@SHb>TYJKWIjLVIF@SHZ9RXb?TiRNXjNYZJNRW9NC
TI:EVIjQXj6NV9:<QhB3PhF8S96EVIbNWIZFTHf;RhjCVIjQXIjITX^5P7elOGj1
Q8N;SHj>S8V5PGmnPHJ=TiVLViRCS8F0O7YjNgeoPH>5QHF2P7aiMgIhOHB;TiRK
VYNARXB0OGamOh63QHJ6QH>0O7QdLg=fO8><TiRJVIJAS8N5Q8J9S8j@TI6?S8R3
OWYfM7EhOXF<TYJGUI:=RHJ6R8b@UIRJVYVFTXf8PWeiMgQkP8J;T96@SHR3P7n1
QHZ@UYZLW9ZFTXf8PWikNWYmPHJ9RhZ7PWagM7AgOHB;TIFGUiFBSXZ6PWmnOX23
QhZ<S8V4OGMbL71eNh:9Si>DU9:?S8Z7QXJ7RHb@TiJGUI6:PgehMWQlPhZ@U9NG
UI>ASXf=SY2CUY^PY:JVXijHT8Z6QHN<TYRMWinMVYJCTY6BU9NLXJJ[[[2_[:NP
VIBATIBHWZ:UYJ:NV9>@SHf>TIFIWZ>WZZ^YYZ2JUI6?TIFJWj:RX9^ESXR4PH62
QHV=TIFHVIVGThj8Q8>3QhbBUYVHUHj7P7YeLgAfN7aoPXB6QXB1OGQdLW=fNh:8
SHn>RXAmMW5_KW1cMWUlOWmnOGYgLVm/JfebNH68SHn=RH=mN7EeMWYnPXF7QhN5
PWmjMW=aLGEjPHV@U9FCSXV4P7n1QHZ?TiJGUiFBSXZ5PGimOX:7SYBIVi^GTXb8
QXJ:SiFKWj:RXIjJUY6=RHJ6Qh^@UIVLW9RCSHN3PH>8SYBJWZ2OWIZFTXj:QhJ7
RHfAUIRHUY6:PWaiN7^0QhfCUYNETXn;R8F4PhB6RHfBUINETH^3O7IcM7QmQ8Z>
T8n=RX22QHR8QhF4QX^BVZ2QW9>6Ng=bN86<UIVHThb6Ph>6RHb<S8^<SiJOYj^[
Y9Z>QH23RYFOYJNSVi>=RXZ=Si6AT92AUijW[K2]YIZ@RXV?V:>//:jWWYF?SHf>
T92>SHb?U9^RYjJQV8j6PXF>VJB[[:RPUXj8QXJ7QhJ3PH63R8fBTi28OgE`L7J1
SINMW9N>QWmkNgamO7YhMWIhOH63PG]bJ61NHFYgPhb@SXR0NWIeMgUkNgYhN7Ul
P8:2OGE[HUaLHVeiQ8^=RXAmNGQjOX:5QXJ7R8^?TY>@RX1fKVY]MH2;TiJET8Z4
PX>6Ri2DUYRJWZ:VZJRTW968PX65SINOXj>NUhn:R8Z>TYNJWJ2SZ:fa/k2ZXYRA
SHnEWJFYZZFMTh^6Q8F8S8nBU9RLXJJYZJFOUhn;Ri2GWjJWY9fCR81kNGYkOGn1
PhJ:Si:DTXj7PGelPHVBVYnOVY:8OWMcLW=dMGEfN7YnPH>3OgYdL6mcNhJAVYjM
Uhn7P7ajNg]lO7amOX23Q8B0NgA_K6mfPHfHWj:PViB?RhZ;SHj?Si2@TY>DThn8
P7QcLWN0RiNPYJFRW9REU9JIW9nPXJ:SYJJUXIZAQWiiNGj7TIZOX9fHTXn>T9>H
W9jQXjFWZJZXXYV>Pg]gNGn7SiBDTHZ3OGYkOX>7S8nBUIVNXJ:OVHn4NgEeNH27
S8f:PWU`JfQZKG9fNWf1QX^AUIJDSXElMWEhP8R@Ti29OgE/IfIXJfmbJVa_M7Z0
Q8F2O7E_KW5iQ8jEUi:9OWA/JFU[KW1bLgAhOH>9S8b8PWelOhNDXZfd]:jUVi:>
SHjATiBCTY:DV9fPX9fGT8b<Tij]^lK:b<6g[ZRVYjZ/[J^XYJBTYJJUXIZ@R8>4
RiNV/[Vj]JbRViNHVinRXYnKUiFDU9:>QGY^IF1RJWJ3S92=QG]cKVmcNX24QH>0
OWinOgagKF5ECDY?F6A_MGE_IUaFEEYRK7AjO7emOX64QXEoMV]QG5eTKg^3QH5h
KFAPHVUdOhR=T9:DV9fRYJBOUhj7QXZCWjR]Zj:ER7mkOXJ@VJ2SY:FW[;6f^KNb
ZZ:OX:Nb_LC4_K2PTXR5R8nFW9nNW9^LX:BXZ:FOV9>CV::^^;fj/:6APgakOXF:
SHb8Q8:2Q8N9R8=mN7IjPi6NZ:^WW8f0MW9eNh:6QhAoNWMfN7UiMW5[J6UaOHbJ
XjFOUHUoNWb2Ri:GUY:=R8B4Q8B1O7I`KW5jR9JRZ:NPUH^5QH^DWjJZZJBNVIJE
U96<QGegMGV3SiZRXijDRH1mP8VEWjNYYj>NVYNFU92:PWYeM7V1S9>FTXUmLV]Z
LG^8TYRJV9FAShn?SHZ4O7IcMG^4S92>QWY]HeiPJ7B0RHj?SHZ9RHZ<RhV4P7en
PXZCVIZERWa_IV=WL7b6S8n>RhV9RXb>SXb9QhR<U9fTZ:JNTH9fL6mdOHJ=T8n<
R8F4QHJ7QXB3PhN>Uj6WZ:BIS7mfLWAkPhZ>SXZ5P7ajNWYjN7MgNX29TibQXI^@
QG]fMgb4SI>ETXf7PWmlNgYiMgIhO8B?VJ2SXIZ@R8:2R92KXjRYYZ6KUiBAT8j;
RHV;TIZSZk2`Zj:JTi:FWZVc^knn^[F`[:VVXj2MVYZMXZZa]KB_YibDSi2FWjZb
^;Vg/ZfYYJ:OViNCTI6EVYnSXifDR7eeLWElQHjEUiJCSXZ7Q89oO7UfMgUnQ8V:
QgicIUaFEU]TKGAhNGIcKfe/JfYXIfIWJg5iP8F5P7IZH5UGFf9/M7YlNgQdLW5a
LG5aLG9gOXNAVIfKUH^0N7EgOXN@UiVHUI6=RhV9R8N6QXV>Uj6[/K:]Y9Z@Rh^@
VJ:Y[JbXXYbHU9:@SHZ8QhV?V:6XZjRPUHZ2P8>;UIfSY:2JThf9QX>0O7QeM7Mm
QHfAT8YoLfUUIVehPh^@Sh^5Og]iN7MdL6e[K75hPHN9QGa`IEiMHfejQXjAT8b7
Q8B4QXJ5Ph61QHbEWJ:QVXj2Mg=eOX^HXZNXY:2LVibOXJ:QX9nRYk2i_l6l/ZBF
SH^?VJF`][Nc[JJRXJ>UYjNVYJFY[kS0aL>k[YnBRXZ@VjF/[ZZRV92<Rhb>SXf;
RX^@V:6YZjNLSX1fLgJ0RiFIUhn5NW9_KW1aLFm]K6mfP8Z@THb1M6UTIVmlRI>E
THQmLfe[K6i_KVaZJVmgP8V>SHEjKfQXL7j=Vj>TWYB:PWinP8:2P7ajNgn7SiFF
THMkLFeaOHfMZJn]YY^BS8^=T96@SHV6Qh^AUYRDRgiaJ6I]NX^IXjFPUhj6PhF9
SHj=RXN5Qh^@Ti69OFiQFU]TLX:>U9><PWYeMWZ1QhZ:RHR9SI:GVIB;OFiSGf=^
OHZCUI26OGIdMgj7SY:CU9JJX:N[[:JKSH5iN7n;V::VXiZ>PgelPHVAUiZLWZ6W
[[Fi^;6VVHn;SYNS[[BcZif?Q7emPHR>TY>DUIVOYZb^Zj>HSXR9T9^W/;:]XI:3
N79bMW]nP7moP8>9Si>CShMnN7MmR9JSZj^TUhQkLg1bMWYlNgYhNGb0Q8J4OWM`
KW9mS9bY/:nWVhn5PH:5RXf>S8Z8R8V;S8Z5OGEaLWV7UjJa][:ZX9JATIFJWj:R
X9fJVIRGU8j5Ng9_LGZ7UZ:YZJ>JT8Z8Ri:HWZ6PWYbJV9JBS89gJf=PI6ehQ8^=
RH1gKfa]Lgb4Rhj@T8n?Shf9PGM/HUaLHF]eOH1mMF]RG5aPJG=lQ8V<Si6DUYFB
Rh9jM7=fOXR@U9:;PGE/J6U_N8::TIJKWjBXZZZWXY^FUIROZK:g]k6VVHf4PH:7
SYBJWZ6TZ:b_/:j[YJ6OXZVb_LC7`kV[WI28QHF8S8n@T96ATiBDThn:QH:4RYFP
Zk6aZj2BQG]fMGIhNWYiMgEeM7=aK6MQGEeSKG^8TiRGT8IlM6m_LWEiNWYhMWAc
LVmZI5aFE5MPKGb:TiNDSXJ0OGj3RY6EV9RGUYFDTHf6OGA^KG5kRIJQYjJQVI>?
TIJOZ:nd][Ng][Jd/:VPUH^4PhRBWJJ[ZZBJT8V7Ri:LY:^_/K:b/k>a[:BISHAo
OhF>UY^JTXIiKVMWK7AmQHZ=Si2CUIJFTHZ0Mg1_M7b6SHj8OFiPEE1BF65ZL7=e
MgYnPXF6PgefLG1eOh^FWIbDQWIYHEmSJg=jOWn0PHB8SI2ASXV5Q8VCXK2k`;fc
Y9F:QHJ<U9ZMWI^IV9VLWYnMV9>@TIVV]/G>d<Zn[j6IV9^RZJf]ZJ>NVYVIVIJ@
RH9oPX^IZKJm^k:TUhb8Ri:KXZBQViB>RXR6PgeeJfARIW5oSYRKUXYmLFa]MH2;
TiFBS8F1OWekMg1WGUMGGFUgQ8Z9P7=VGUeTLGn<TiFCSXZ8R8R7Q7acJfMYLGf9
TY>=P75UH69/NhZEVibIUI>CUINFTX^3OG]oRIBNXIfAPG5UHVIbP8jFVINCT8n@
TiJETXb5PXB;UZ6WYij>O6aSHFQdPXbAT8b7Ph>5RHb<R8B1PHNBWZR]ZIj=O6iX
JgB1SIBETH^5PH:5R8^:R8F5RI>P[KNi]:NGR7mmQ92LYZZXXIVBSXj@TY>ASXb>
UJ2]^L30]jZKShZ=UjB`]kNbZ9jGTi:BTY2<R8J9T9^W/;>^XiF7Ogn7Tj6[/:fU
Vi6:QhJ5PgmjMWEhP8ZCV9J>PG=YIFYeQ9:KWYZBR85lNWYjN7EaKVmdO8F;SHQm
Kf=MGVIeQI:JViN@RHB2PhF6QXB2PXF<UIbPWIB8NW1]LWf<VjFZZJ>LUYBDUYVK
VYZJW:6X/;Bd[J6CQWelPhjKYZb/YinGTHn?TI>DU9BEVInV[:fYWi22MW1bNHB?
UIJARGmfL6i^Kg1aLG9eNX68S8^4N6]OEeIKIG1hO7YbJEmGDe9BDeAEEeYPIfmf
NGI_IEYCDUMQKWZ2Q81iL6UTHV9SIFMXK75hPHV>ShZ3NW=aMH2>W:R^[jZSW9ND
TiBEUiRIWJ:Y/;Fg/jbRVIFFWZZia/kBd<[3_;Rf][Jg][Jh^[o4alO3^ZjRVIJI
XJjj`lO6`KVb[JZYZ:RXYjNY[:nb/jjUV8YmMGAiPXfFVi^GShR2OWenOh21PXB8
SI:EU8j3MFMMFE]SKWQnP7efKVQTHfEWJVa_LgR0R8nBTHYoLVQRHfYeP8R<RXAl
M6i/KFmbM7MkP8RBVj:UXYZ?QGmnQ8jJYJ^ZYI^ARHB2PX>4QHJ9SYJOYjb/YYfB
RXN;U:6^][RdZinDS8R5QHB2PH21QHbCV9ZES85gLG=kR9NSZZVSV8f4OW]kNWUf
Lg9cMgb2Q85iKV9IEeeZNXZEVYRAQgiiMgUkO7]iMWIhO865Q7ebIEUBDee/OXfF
V9B<Q7imP8F:SHf<Rhb@UIZKUheoL6API6moSiZOW9F<QH:4RY:HVibMWZ6V[;2_
Z9^:Ng5^M82?Vj6OV8b2NgYoQXjEV9ZKWZB[/[FcZYb<OgQiPXnLY:BMTH=hLW=h
P8R>TI:EVZ:[/[JcZYf@QhF;V:Ja]K6VUXMlMgUoQXb?TI:DVZ>//kFaZ9fCT9BP
[kk7b<2aX967PhJ;T9>CTI2AUYfUZJRRV8j8RI>R/l;8a[^ZVH^3PXF9S8^7PWin
P8F8R8=jKfITJGJ8VZN[YYZ:Ng5^L7EjNgQcKFQWJ6YZIeiCB452C5a`PHb>R7a^
IF5OIVmfN7IaK6UYJV]YHUQ;@Ce1CV1cPXZ9PGI/IfYcOh^CUiNDTY6CU9B@R7a_
IfE[NHZJY:JPUHV1P8^@V::]]ko4aLC0^[>[Y9fIUiRKXJN[[J^VWYF>RXZ?V:>^
]kk1`Knj]JjWXIbIUiRKWj6RWiR=PGI]J6Q]MGn9TIJHUiB@S8R4PH20PXF9SHn=
R7mcIUU@C4eCFfE^M7MhMW=`KVe^L7AiOhJ=TYFET8MlL6IOGEmVKgMnPX>1OW]h
N7UmPhZCW:J_][Vi]JjTVY>>Si>JXJR[ZjRRViFASi2DVZ:[]Kk6_/71_jn/ZZZ^
]Ko9d]KFdLNj[:2FT8j?TiVQZK6i_/2o^[>ZXYbIV9ZLW9ZCRGe`I5aHF5aTKGJ0
R8nDUIB?R85jMGAgOXN@Ui^IU8^0MVeWHf9QH5mMFUIABdDo>SLg>dECI7J7U9^M
VI:9P7UeM7EgNWamOWimNgQfLg9bMGb4SYRNXIjFRgmdKFU[L7V2Ri>HW9fLVIB?
RXJ4QHVAVZ>Z[Zn/Z:>PXJF/]Kg4b<O2^ZnQThEgK6=OH6E^N8><TYBCT8f<SY>K
Y:fc]kJc[JJOV96=RXV;T9JMXjJUWiB7NFaSH65WKgR1Qh^<S8^:R8J5QXZ?U9VL
WIZESHAkM71aMWj:V:Fa^Kfm^;2VW9><R8J7R8V:R8F0NG=]JVY]Lgb6TIVPXZ6M
Ui2:QHF8SYNR[KJl_[bf[J:FS8=nNWUiNGUgLfiWHEeKG65YMH6>V:2SXYbCRGie
KV]/LGR0QhfATHn;QX5mO7eoQ8V<SXj:Q7]bJF=OH6A[MGn9Si>BSXMnMFiYJFab
O8NAVj:WZJVXYZJWZjnd^Kbm^[>XVheoLf]XJFigPXfGWZ:SX9^FTHj>TIJMY:^`
/[:_ZjJQWYfOY:Z`]KRg/ZVNT8=fKFQWJg9kQ8fCUYFBS8EnNGIfMgYnPH:2OWUc
KFUWJFigPXjIXZRYYIjCQg]`JFETIf]aMWUiMg=]If9PGf9WKWIlPHB3PGahMGAg
OHNDX[2laLW8`[V^XiR?RXR9S92CUYJETXj:R8R;T9RQZk:g^KNbZZ6HTXn@UIfX
];o8cLk<a[je[JNSXZ>UZ:ZZYj:LU8f7Ph:5RY2GWJ2OVY:7NViSG5UKHFYeP8ZB
UYNETHf8QHB5QhV;RhV3Ng5UFE19ATM<DdUBFUmQH5]FCd]9BTmHHg1lQi2EUYB@
TXn9P7aoQhj@RWiaJ69NF4m9BEAWO8fGVijRYjRTVHf5QXjGWYjKVIVLWIV@QX:6
TZ2[/;6c][Zk]JVKTY:KYk6g^l37cm?=_jbLTXn>RhEnNgf2QH9iKVQZM86=UYjZ
^LWCe<Zk[J>OW9N?RHR>UifLTX=fKVYWHU]EE5aWL7=^IUmNHVM[K71jS:6d_[jh
/:^VWi>4Mg5cOHJ:Qh9nOX20O7A^KWJ4TIRGThn>SX^3N6m_N8RJYjnc^L36a[ja
XYVHWZBVYJ:SYZ^/YYZ>RHbEWjJXZ:^`];:WUXAhM7MlP8>7T9f[/k:YWIBATY>A
S8V;TYZMVHf0N7IjOX61Q8bIYjj[Whn0MFeUFTi7B55NJ6]XHf1RIVQWI6A[NHZG
W9ZDT92@SXR0Ngn:V:>VXIR?R81dHTdm=SU2C55DEeiXM7]mO7f6UZZkaLS9b/_:
`K6MRX1nPhN9QhN:T9BBR7U[IFI]LgMiOXNCWjBQVI:@UIfTYjRY[KBh/jFAO6iV
I69PGf=_PI>OXYnJV9^NWibFU9NNYJFKS7]_J6AOF5=CG6]lQhZ7PGmoP7miM7Eo
T:>a^;Vh^Kbl]jbOUYBHWYnISH9iM6iUF4e9D61eQiBMYK2j`L2gZj:QYk2f]kJe
^;fo^jnQUiFPWYbKWZJa^;>RR75TIW9nPh1jNhNL/[fhZ9B6Q8ZCVYbKVYZKW9^I
UY>?RH9oPhnQ/;>XTga]J6YYHE51>dEKMHN<QGYcLgZ2QhN6QXV<T96AShZ1M6AH
EV1cR9FGT8R7SiVLU81ZGV5cRIZPW9B>SY:DTXb5P7j0Q8V>TiJBQgMXHVUkT:2X
Zk2mdnWfl]g3[JBV[[6[WHn4OgilOWQ/GE19BUI/Qj2^[In<OWj:W:V/Z:>U/L;?
d<FcXYJ>QWQVE4U9DEaQGE11=2ha?4iUO8jHVI:=SiVVZj67ITa5DVf6TXalJUiL
H6EWJ6U^MGf2QHJ8RX^9Pg]gN7n8T9FKXjbc[ij2I55BHg^=THQlMh6G/<?8`[R`
/;S6enOal^OA]Yf>RXnEUY6:R8nMZ[2ZWI6<SiFHU8b8SZ2gbLg2[YbCUJ:b`L_>
b/6cYinNX9nDOV9<AE=_S9fLRgIWI6Q]KVUSHFI^MGIbJfMWJVe^KVmdOHVEX:R^
[jRFNUa7@TiRLgEWDT91CfAdMVYHBdYGJh6AVifITHEjM7N0SY^RYJJZ/[Vj/Z:@
Q863QH1gL7:2Vk:m]Z:>Q8^O^<cEe<_0]JbVXj:NUHIcIF=aSJc2b;j/WibU/KRi
]KBia<oCc;f_YZBUY9jBQWmoQH^>Rh9cGdPd:Rm3HWnAThb4R9^ebm;6/9^BV:Fb
]ZjMRGITDdHm>Sm9De]OHVIZKFaVGe]NIg5gMgIjRJ6h`k^SQG5`OiNY[J>AOg=_
L79bKf]UH5iTMHjZ_lFlZ9B8Qhb@SXN0P8RCV9B7N75ePY2HUY2<TZ2c`LJo[YV6
N7=iRInc_KVZV8f?VjJWUgeSEEY[OXZ8OG1VI6EWJFaeQ9NX/kJbZjBNUhn8Q8B5
QX>0P8VHZK2XSVmFD5mhSiN:LeeADU]VK6aYIfY`O8^M[kk4_k:RUYBIX:BSWYbO
YJRRU85eMH2>UY62LVY_OXbARGIQDe5LLHZT^LG6_K6XZ;2l`;RUSX20S9bTWhii
JVEXKW5bMX2AXjj^Xi60MG9dMgYlOX22QHR?VJ:UW8EYDdiNO9VXXi1iK6ejR92@
RhV>Vjbka/_:a;JRRW=SGEmUK75eO8>9R7mcJVemUJZc/JZY]<[QkNK>/9VBVjo6
f>;RfLZhYiVASHUoL61GG6j8WZNTV8n?UZ6Y[K2hbMg^l^G</9^BTIBCSXJ1P8F=
Uj2TX95iGDDlAEijS8eoJUeMJGMoNViRGfMfQXj?RH5gJea:>Rl_=dIEHfeeNWYd
JV1MHVeeMFYICDeLLGijHd<X7RQ1GG5jNWIaKVe]KW1aL6eXIfelTjRf^;6XXZ>V
Z:BLUiZT/;>XT7ERGfYkR8Z5OWj7VZjobLRo/J6ETYb`b=WLdKna[k_<f=S<_;6a
^L72^ZZJShR2NFeRGVAcQYJOX9^ET8f<T9RS[:fUUHN4SJ2_/J66KF=/QIn]Zi^5
LVIQGEUDD4m@DUEFGVQeOX9oN7AdNX23Ph63RY:DRG9GA49CKXF@S85iO8ZKYjVN
SGa`K7:0TjJd]Z^HQWaoRiRMV8j7RI>OY9j?P7MhOhJ:Ri2O^MSboog^f/Vo_;k2
aLG0]:>CR8N=TXmoIDi5DG2E/;V`WXn8RY2CTi:FWjjmb<k?c/c6^ZZIQgYcKfe/
KG1dLfQC>AdM<UAgSiJARhjL[k^gXX9SCTM<FVYiQ8N3NFaSHFMaN7YfLWAnRY:?
QgEVH65TI5mLHWJC/<6nZHedIVE[LGEdL6aZJg5mS9ZPW8ioNHBP`moYh<ZcY9fJ
U8QhJfM^NXB9R8F5R8b<QWadL7AnS9^W/KB_XXmoNXBI/Knm[inJXkK8c;jRQ71]
MhNEWIjKU8b2NG5^L7AfMWAeNhJBVY^GU9NOZJfZY::Z_]GSglRXS7j2T9fSWY:6
P826SYJJV8n1LFMYN8nU[j^MShV@WZfe]K>f_lcDd/FcXYRETX]lJEYFGFanSIFG
Thf7QHZI[/?<aK2COGAiPX=eFd0`<dMRNHF7Ph1nOWilNWb1RY2CTHf:QhJ2OGUi
O8:6Q7eeM7Z3QWUJ<a001b0nE5eLFUm_QYf_^[jm^kRh_<C>hMg<[hibHf1TJFY[
L7f?X:RSUhZ6SIRQXIR>SIR]`m7Ba[:NTHbAW[72cLbnZIJ<S9:DRgIODEE/S:Rg
]jjTWIZGTHV2Ph^GXZFQUX^2O7QdLW5dNH64RI>S]L?3/IAgIV^0Vjb/W8IgLgV0
P7ITDD<l?D=<Ef9YJF5DB452BU=KGf9YLgaoN6QGCU5MJFeWGEUTO9Za]j^CNVYV
KGV5SHn;PGE[J6ikQhb7OGMnU;CAhnCIc<C2`l6k];:kc=o[k>;Eb/O8b/Ro/jFI
TH^:S8n?QgINB41=KINkc]37`LGCh^WQc;:MTHj?T8j:QH1iL6IMG69^OXbGX:R/
[:>CPWEbNH64OG1VJG^F[KBVRF]GDei]NGehKV=IDU1BFF9XJFMVKGjF[[bjZYAo
L6IKC3X/:2lmAdLl;28T=4]PKG=eNXJH[;k:c/RiY8n4QYNaa/g4[iV?TIZQW8ag
J6E`P8nFV9NHVifKUi>DWJfoc]OJe/k3]:JKUiZOXIZ<OWV2UZR]WX1NB4IFL8F?
S8AkMgQjNgakNWQeLW9hPi2JVi63MFi_LgMjOHNI/<?9_jVCR8ZFX:2CP71[Lh:@
UiB9NVaSHff2Vk6l]jJAPGf1QXAgIEQFHgV=VYbKVYjSYZ6GSHZAWZ^aZib9MVUQ
H6A]N865Q8:5TJFi`KNKNV5LK8RR/:nWX::/^LC:c<g@e=OHemC@bKj[TWINCDA0
?T59FFn4T8j2M6mjT:Nc/:2?QhfM[;:YU7aYH69]OY2OYZ>FQ7A[Jfm`JUiDDeic
RINLVYVMYZnb[JBQZ;W=fMG3Z8moNG^2RHjBU9FGWZZlcMOB_jB?RIF^aLo7/ib<
QhN6Og9UGf1WKW9bLW9eMgIaJVEVKGR7UjNg`/BjYXmoO8RGXI^9LVAVMHN?Qg5E
@3U0D69aO860O7A]JVaeOhN:S92JZKW2`;FVVXF0N6]KCdmNMHR=PFYCATQFIg=g
M6m[Jg1hPHR;QGITEeMYQjNna;^/XZ6X[jnWViFGXJbb/:RRX:BXZJ>JUIJQ//CD
g^3JbkNRU96KZ[Nh[I^?TJ:ib<NeW8N2S:6e`L>n]J^QUHQmMWAeMgMgN7f4RHV2
N6mZJFMQEdi>FVn3RWmVBca1EW68U9BBTYZW]Ko2_;2MRGQ_LWj>UiF5Ke]BDeUM
G5MFGVj1Si>=QH66SYBAQgagOY6Y_LO6^j^JS8F5SIVRXYJ3LFY_OHN6M5]7@e=a
TJVe^;Ni_L2o^[Fc][c2a<6l][:]Z:2ITi6ATHn@UZJld=[@]iMoNHJJZjfQSWmk
PXbCT8AdI5QBDeYVMH22NVYICDU=DeIFEem^P92ET8EmOXF;RGYUDdeEIWAgJU<h
91XK9cQ<GfacMGMnSZ>f_[NTTHR@Y;_9bKf]Z:2KUHYnMGAlS8j8O6mWIVYaMGIc
Kf]WIVYdQ9JSY9V9OX:F//O<_J>;Oh:?VYfFRWmkOXJ?V9nVZjbYY:2QYk2f^;F`
[JbYXYJ8P8>@XZf/XI>=UZVma[jXSW]eO8ZFViR=OViPEeMNJG1`J5eGG6YkQH9c
Ge1:CE9DDU1DHG>2Qh5eJf]gRI^W[:^YZJfc^Kjo^jjKQgUiRZFoc<F`UhN6T9^N
UXIiMWf:UI^KUi>ASXb9RHnM[l;@fM_HdLBaWH^1P8F8PW9ODU9PLGYdGTDe>E1c
UJfh^;>]Z:FSXZ:RXIfHUIVU/kbk[IN2MG1aLg9`Lgj>WJ2DOFEFEVAfQ8R6PhJ@
WZZ_ZIZ3JE50?DQNMHB4MF5BD5YZMWQdLGV=ZL?Bdl^n/ZJHQgAUGV=`P8Z=Qge`
I5YFFFAeQiBKWJ2/`=GPf/6NPWV6X/7Ef];4^:nWWY62M6YTHV=WL7^5RHAfIUYE
FF9]NHRN]loKeKnQR7aoRI2<P7=_MhVLYZ:ANV9BCE=UOYN[/Z^JQgYeM79YFTe9
EVj:X:VWXIbJVIB:P7b5VkK=em?2[IZ<Pgn0PhR>TYJMZK[<e/nfTg5PIWnN][nj
/:RVZJVSUhZ3Q8fJZ;Bob<g;`:jHQ7I`LGN2TjRlb/VjXX^0PhnIVHinMGV;WjZT
S6U9<bdeB61kTjJa]KFd]KVk]jfPV9VU]L30/in;NVaLAc4P7Ri;JGf1MVAECe1F
G5iOHFI_OHnT]/6nZhe^FUQYPiRPVX]nN7QgKem<?Sa7Fg24U:Bea<k@b;Z/Xj>Y
]L?@f]kFa:^BPh28TYJAR8FA[M3]n>c@/I^DV:://[Fd/ZbSUXUmLfQMDDQ7D61a
OX5mMg9_Jf5DB4MGMIVd_[JUUY2EWZ>NTH9gM7V4SYFDRGAH?2TV<daVN7mnOH>?
Vj6KS7acMGn9Shj:RHfBTHQeGTa6CEeaPXfASH=eIeeKGV9PETHk?4i]RibIQW1R
I7F=XZnf_<?;d]CAb/>m^KFa[[2f`LgEemKCcl[0/Z:IW:_2dmK9/YfDVZVe]j^J
SXbHZ[g8bKn_VXEcJVU`N7ekLVQUJG=lOWQ_JfmkRI:BSHZ=U9ZFQFY@?ci:FfU_
KFMRHFI`OHfJXJ6JTi>O]LcHe;jQRGn3SIBBQWQ_K6e^J5iBBTM8B4E0?3e5D5aV
KG=fN7UhNhFG[Kk3^:>=PHBBWYj=LUQ:C5a^O81mN7IiP8^HYkG0a/Bo^[Vl`/>o
]JbVYZVXXYR@TI^Y/ZnPSH21Sj6][9j9Mfi_N8>;SX^3Mf]SI6ikQH=fHU5;DV5^
LFULDU9KIg1dMgb9Vjbe]JfTX:B[/K:[XIF:PginPXR<R7aZFUISOIZ/[Ij:OGf:
VZBQUXR1PX^EWJ:TY:>PVI:;RXfCV9VGTXj8P7=SE4eAG6Q^JEmJL8>N/[JZTgmo
P8^JY:NTWYREU9JJWYnJSh1dLGb?Y;6bZ9^ASH^7OW9[KWb>WJ:LTH^=V:>WXiN:
PX>;Uj:WY9R4Je=4@e5WNX9nMG5iS:Bd]ZZJShnJZKFj^[Ne/ZbQTX=jNX2:UIbR
YJNUXYbIVIjSXibARXjQ_=GNe;^PT96P/l74_;6XY::PW9B:OW1SFEILJgn@VIZE
TI6EV9RDTIBO[KRgZ91jKFeaLf]JAc/lBf5eP85iJea@C55NLH69QGY_K7>0RXUl
JE]HHW>1R8J0NgUgL69A@cm6EVMeNgakO7j4RY:KXZFTWi^MZ[c<cl2POF=LIWZ;
THb3Oh>>VZ:SX9^IVI^OYJjh`/S6_K6VWi^IUiNLYkO5b/:aWiJHXjf]XHioOXfV
_LW7^JVKUYVS//7?e]C;`;Jb/kB]WHMcJFahQHb;QH61Q8F0M6MQJ7V=VYZ?OViT
HF9SHEeGDTi>E65dQ8b4Ke@o>DEKKgQbIEYHH6]bLFYTHfUfPhnHXZbf_;^bYYV?
RXR:SiNQZJ^TUHImPI2PZJFGRXVF[lKAbkFKQWf0RYJPYj^]ZjNSXJ:TXijCQh21
RYFKVY::QHJ7QWifM7nH]m;Nflfo^Kg5c<_2]JNMVI^QZ:bYWHUaGe]WOYNWZJ6G
TiNPYJ6DQ7UfO8>6Q7mkNWinMfQD@cPg?4E>EEQFCd<h<CA0Ce]METmAHh:R^;ZZ
TGabMGn8RhV3OWYgLfmZJ6QZJfeaNXVQ]<76alK6a;jbXIBAVZbk_k:JP71^MX23
NfiQGFAbPY2FU8YkJEaGGg66V9nMUY:EWJBSVHYnNX2:T92:Q8B8SXj5MVMQJGjH
/L;:b/Fm][6`/kRi/jFDRH^HZ[B_VWaREee_PXnCTY6CUYJAQgY`JfUYJFU[L7Qo
Q8B1OGUdKfUVJg^AYk6ZUG]XIFmnQhEjKfagS:Be^kN[WI:;RY2LZkRo_;>XXIjO
WIJ;Ph::Uj>WXiZDU9FCQg5HATAAIgb8QW]^HemQJ79kPXF3P7j2SIVPVH=R@c4a
?U5OI69PHf]dNGMcLGJ3U:>//;:e^Kfl]ZZKSH5jN7f:Vjbc[IV0K6M`PY6DS81j
PYF]_L6gYiR@T9JPZKBl`KjeYIB5NFeOEE9EG6AZKW1dNhB>UIJCShnHZlCMjn_L
`jVES8fCUiF<PW]mQiNTZZFHR7akPiBV][o2_kZd[JFJShN2PhR?U9B?QgmhM71X
FdXi;RlkD6IdMV]IB3m3DF=cNWYfLgEnR8n<OVUA?cPkAeITKG9eMWMhN7MgNH2<
W:^f^[Rc[JZZZZNNTXF0QIJ_amKGbkNSV9VS/K^m^:nXYjbd^[R]W8]oOXNGZ;Jo
`/2l]jnVVi6:RXnHXJJUWYJ@SY2CTXf2N7=hR9ja^kJTS7EYJGB4TINGU9>HXjni
^[6RTXN3Qi2HWIbES85fJUiCC4Y@GW21SI:ASXf?U9VHTH=dJVYcPHf?Q6a?=RPY
=4ABFEYGEeaWM7j0Ng5XI6QdQ9BQZ:^ZYj>MUHb6Q8VCWjV/YifBRXV=TiNFTHf@
WKGBk?_kk][9`<;<emgJc[n`YZ6NVY21L69KGFMgQY:JWj6PWYVARH:1QXnJXZ6I
RW]aKFmbLVeSF5AKJh2BVYF4KUiHGg24UIjOWYfRZ[Bj^[>YWiVJWjJ[[:RRVI26
NViSG5eWMXRFW9ZBRHF7SI>DSX5cJVYdPXf>PVaC@CY0D69aN7QeLgEkPXJ4OGA/
JVihPhfEVIbNX:2NVYNFW:Vkc=OHd<:cZZR//;2YWI6;Sij``<FmZiJ6P8FBX:RX
XIJ<QhF5PgabIemLH6M_MGQhMgA`JF1DB451B5ITKVmYGeMGH720S92?S8jHZl3?
e<ZfWXb3QY2LXjBNUi:CV9nTYJ>QXJF]]l35b<O4`KbdZ9V:P7f3SINKUXUgIemO
IFa]Ie]?BDiLKWf3OFmPEeUVNHfLXZ:NVYZKW9VCRGifLgAgNgeoPHF:SY6AShf?
VJVndM_Jckj_YJBXZZNLRWU]K7F1RXYoK5Q:ATeJJ71aKFIQH5eNGEYEDE1DG6E]
LgMkOhB6Q7idJF=UKgj<Ti67NW9bO8bMYjZWXjF``mSWk>GD`K>^/kc@c/JhZj:O
XZN[[:^YYZBRWiVARXF5R8b>RX=jM7AkQY2BSH5eKFmjR9BERgQSDdeAFfAWHUU@
CUARLh:;SHb:Ri:KY:^_[ZbYYJ6KTXR0O7f2R8^8PGUcM7b8TIB>PWE^L7b<V9bD
QGAYJ75oRi2<PWM`KgAjOGYbIU]DDeMLHFAWJg1gNgj0PhVDXkC2bLNm/:JSYk2h
^K6SU8^<UZFb]kBZX9bR[ko;clVn/jf^];c0_[J[X9VGVIbOXJ6QX9fHSh=gKV]^
MWeoNViPEUEKIg=jNG=]K7B2TI^KT7i]HV9[N862NfiQFEYQJgEkO7]kO825RH^<
SY2CUYNCS8F0PHRCWZBSW9>=SIBMXj:HRWaeMh6>UI>7M6ALHG24Uj:UXI^HVIjT
Z:RUXIfJVINDSXN1OWn2Q8B2P826T9fX[JZSViRLYkFo`;NYW9NLZ[[6b;n_WY>A
V:>/[ZRMTXV4PhB3PGelOX><U9VLW9^LWIjMVI::Q8>5R8MnKUU6?3a7EfAYIE]A
CUEUN8N>RX5fLG=kQXj?Rh=kN7YoQHN7Q8:2QX^@TiBCTY>DUIB@RhR:U:>c`<>m
/:BNXZnoc<o8^:NJUINLWYV=OW5/L7^7T9:>Qh:1QXjFVibIUI:?SX^7Ph1oPXF8
Qh9jM7=jQiNRY9f3LVQYMHJFWYnITi:GXZfc/JNJT8jEX[6j_;J[X9VFUYJDShV1
NgE_JF9NGV=^O8VATHb4Ogn4RXb6N6IEC4iIJ7EkNG9/Jg9nRHj9NfYKEEUVMH::
S8b<SiJPZ[:i_l?7bLS2^:jVY:N^];JbZZ2IV9^PXIb@PWQgP9:U];VcZ9bGVJ6Y
ZZ:ANfMIEEQNHfETHEmOHVIYJFUXJ6U[JVMQFeUMIgJ5T9NIVinW/KVk/j:=OGEi
QiJRXib?Pgn4TJ2//JfVWYbNYJba/JjZYjNXZ:FPUhj6P7]dK6=KEeUQK7IjNWIb
LgZ5SY69NFEECeMXOY2IVI:<Ri6MZK2`ZIjDSXf?TI2=R8F6SINS[KBh^[bl^kN_
YYjKWJB//JnUUhZ3Q8^CU8elIeE<CEQVLG=^I5]HFf=[KVYQETi<D5MNHfARHVA[
M7f5RXf>SHZ4NVeOEE=JJG^<UIRFU9RS]<GAdl^n/Zb^]/34`;JXWY^PZ[>f/JJI
SHN7Rhn@Sh^8QhV=T9>FV9^OXInISGmdKg=nSIRLV8j4OWj4RX^5N6UNG6AbPXfA
SXV8T:2dam;DcL2bYj2KUi:<QX:0PH>3Ph:3QX^?THj5N6eWJG5lQ8F0Mg1^LW^3
QGi_GU9>DeiYKVYOD4I4BeQVKg9_J65MGEmRIVY`NXJCWjR/[Jf^/K:aZj2CR8:5
SINNX9bGUI^X^l_DdLFeYj:U[kVm^[2SVYNMZ;>k_KVc[:NRWIR@RHB2Q8R<SXf:
R8N9RXZ6OWMcMH2>W:FUWI::RY>Q[[>]WXUgK6Y`Mg]jMFm]LWf;V:2RWiVETI2=
RXAnNWUlP8F9Rhb>TYJHUHamKV5MH6UbMG1SED]:E6IiQh^7OgMeNX>;Shf6Ogao
Qi6HVI>9OWA_K6a/K6e`MWj7SiFIWjJa_<G8`kNXW9NKYK2f]:^OUYJN[;W1_kFX
W9JFVIbITXQoOH>AX[6j_KZd[ZVVXinKV9JEU9:<PgUaKW5hP8>0N6aSHFMcP8V:
QGikOh^JYjbWVhaoNWb1QXJ0MVi[L7^:V:6TXijHTXf7PWelOXB;TYBCT8jAV:B`
]kJ^XYJ@Si6BSXAeIemQK7b;TXn4Mfe[L7Z3R8J0NGIhOXN?TiBCT8f:QX5kMWAf
Nh>:SHb9QXN=UinSX9R=QXF;U9bNVY28QXnQ^<cFeLViZIjIV9NCRgmeKfe`MWYm
OWj0PhN:RXR4PX63QXN6PG]gN7j7SY2:OW9YIfehP89lLFEPIGB8VjRZYI^DTIBJ
XJBUY:BX/;[2b<W6`[jj]k:/Y9bDT8f<RHEoNgb5U:Je_K^aXiRCUI^OW960Kf=P
IG1jOgacJ61MGf=UIF1JEeMMIVmgNWalO7j0PH61PH>8SI6AS8AlNGf9V:F[YYZ9
NgAfO8:5PW]dM7b:W:^b/:RNUiBEUiNAQWQ]IF=UJFe`LWAgNG]jMgAaLGEkOgmj
LFQUJGJ8VZFXXi^EUI^TZjfYX9VGWZZi`lK0]:RPWj>[/KBb[ZZYZk2e^l34bLkA
dL_1]JROVYNET8MjKfQXLGf8SHZ0MFaYJg1cKfAFBdM<FV]jPH1iL6][L7IlOGYe
KVUUHf1NGEiSJW=jOWejN7UmQHfATHj<SIFQ[kVj/Z>BQX22QhV4N6UKEEQTLh::
S8R2Ogn2QXR8Q81lNWYjNWUiO869TYVLVYF@S8^;RhInMFm_N8VL[;Bc[:>PYK71
cM;?aK^d];[2b<W4^k>]ZZZZZ::KU92>Si6BU9FGW::WZJNQV96<RhZ7P7=UFUMM
Jgb:ShYnKfERIVebLVYOEDm@Ef5ZKg5aLWR1S9FJVYJ@RXJ3PX20P8:7S96BSXR0
O7f3RY2?RGmfLgV6UjFZYifARHN;TIJDSH9iMWV0RHn@SHN2PHB9SHj;Q7adKVYX
J6]bOH^KZK6c[jVUYJV_/k2WVHb3PhZDW9jJTXZ8S9JQZJVSVI6>TY^V[Jn]Yj>Q
XZJXZJNQViF?R85kMWEhP8ZBU967O7A`LgQmOGUbKFiePi:NXYjFShb@VJ6SWHmm
K61MH6Q_M7IgNWn6SYFJWIjNWinNViF@SY2FWjJY[ZNNV9NJWZ2MUHZ1OhB>VZ6Q
VHf3Oh>=VJ6QVHf0NGMkPHN;SHf>Si2ASXQoMfmZIV=PG5UJGfUeP8N:R8N8SIJO
XinEQg]fNXFAVifHSXJ4RYFQZZbVW9::R8V<SXj>Si6FW:6SXYjJUiFEUIBBT96F
W:>VY9^@QH20QXf?RWm`HeeRKWf;TYBASY2GXZbb/JVNU8j<SY2BTY6ATiROYJVY
YjBPWIZET8Z6QhbFX:NXXi^EU9ZU/[Zi/::CRHF8SHn<Q7YaKFmdNGUdJUiFDeIM
IVebMGMjOhB7RHR5PWmlMg1WGEECF65]MWYhLVe]Lgn<U9J@QGagNX:<TiJDTY:G
X[2k`;fcYIVASXnATY:@Shj>SXj=SHf@UI^PX9fGTY2DW:J][ZVPV9BEVZ2QVhn1
MG1iPhnGVINCTIFNZ[Bi]J^NTHR3PhB6RHb?U9VMWinNWInSZ:ZYXYV?R8J9SI2>
RH9nOhJ@VYfHS7a_JFYaNWimMVeVI6Q`Mg]jM6aUHEmPHVAUJ6aaMWUiMg=`Kg5c
MGA`JVEUJG9mQ8N6Q8B;UjJc^KBWUXMnOHB=U9JDT8jAV:6Z/;6^ZJJTXj>RWi^H
UYNHVIVGUIBEV9^LVI::Q8:5SIBGUHj5Ogn7U9nTXIJ7NW=dNhB;Shn=SI2FWJ6R
WIJ>R8J6QhN6QHB5R8^?TYBGVj2WZj^UVH]nMgMkPHB2Ng9]KWJ3SiJFSX9hLg=h
OGmmMg5^KgAjOWmkMFiZJF]_LWAfN7YmOh20Oh23Ri>KWYZ@Q7YeN86<U9RGTi:F
WZZc]kJ/WiF@TIJLWY^FTHnBVjF]/[>_ZZFRWY^HThn=RhZ9QX5lNW^2S9JKVi>9
OgYkP8N;RXEoO7f4SI>DSX9eK6]`NH>9RXN3PH>9TIVNWijKV9FBSHR4P823Qh^>
SXb<SiFNYZVVWI66Ogj2QXN4OGMeNXFBWJ6MThMmNWb2RH^9PWYdLW=gNgj0PXB7
RH^;R8F2PhJ:SY6AShnAUYbQXI^AQWilPHZCV9NBSHbAW:Ze^[N]X9F>SI2CTi2:
QH:2QHV=T96BTiFGUiB>QX1kN7QgMWAcM7V1Ri:DShEjLW5fOhR<RH5hLW9iPhfC
Thf7PX:6S9:EU9:@T9BIWj>UYJ>RXZ6OW9NBSXf>T9:BTY6DW:Nc_;jhZib?RHZ?
U9JBRX1jNX29TIJFTHb9RXfBTi6;PW]gMgYoQ8N9RX^<S8^8Q860PXJ9RhV4P7j1
RI>JWY^CR7mlOhJ=T8n:Q8:6SYRPXYjFSHJ3Q8J6PgefL6e^LgZ1Qhb@TiFETXb4
OWYjOGmoNgA]JF]cOXV@THf7Ph>8SiFFTX^4PHF>VJ:VY9fFTY:FW:6SXYjKVYZM
X:>VZZf`/k>_ZJ2IUIJIWJ2OViNEUijV[Jn[XIN?Rhf@THj5NFmZKGN3SiFFTXb8
QXN9RXR4OWUeLg9aL71aMGZ0Q8F3P7akOH65QhF1O7]nQXnEUY67OGMgOHF;S8Mn
MW9dO8RBV9RET8^9R8N6PWijMgMiO7j0PHB7S96DU92;QhB4QHF3OGMaLGN3T9bR
XIZCSi6GX:JXXiZ@RXZ>UIbOX9jLW9jQY:FTXIjMWJ2SYJJVYjRYZZRTWIJASi2C
U9:<PgaiOXRDWZ>PUhf5PH:6QhEnMFaXJ6ieNgmnOG]lOh:5QH9mMW5^KFe]Kg5e
Nh:7RHR5PGn1QhjBTXf4NgIgOXR@U9:<QH61QXb@T8^5P7n3RiBJW9ZETHj=SXn>
RhN2OGYiN7QiO8:;U9^NWIRAS8^=TIBBSHAlN7Z1RiBIV9FATIBKXJFSVi:9QHN=
U9^NWIZGUYNJW9fNWI^JWijLV9>@Si2CUIF@RH9mO826Rhf:QH1nPXR@U9>=PgYf
Mgb2QXAnMFeYJVmfOH62PH21PXB6QhR8RH^<SH^7PWmoPHJ:S8b9QXJ:T9RMWYVC
SH^>UIfQX9V?QX63RY>IW9VDSX^;SY:DU8j;R8R8RHV8QXB3PhB4Q8:0P8>8SY>D
TXb7PhB7Rhb9PWYcLWN1S9BFTX^4P8:9TIVLW9VFTi>DU9:>RHF2PhJ9SHn@TI:C
U9BBShb;SI2EUiJARH9oP8J<T8n9PGYiOHJ@V9ZFSXJ0Oh65R8R6Ph63QhbATi:?
S8^;SY:EUiVJVi^JUi:<QXF7S9BIViZETI2DW:BYZ:>JTXj?U9VMW9J>QX:2QHR:
RHJ3PH>8SY>EU8n:QH5nO7]jNWaoPX>1OGMbL79hOhJ8QX9mNgf2R8^:Q7afM7Qo
R8j@SHV6QXV?UIRGTXf8QhV=TIBDTi2>S8^:RHZ<TINNXjFRWIJAT96DUYFARhJ5
QhfCUYF?RHB3RI:KXJ:NV9><SiBIViZFTHf<SI2CUYNGUiNGUY>@SHb>TYRMX9nK
UiBDUYVJV9>=RHV>U9^MVY:7Og]oPHJ;Shn;PgelOhJ;S8MoN7IiOX61OGUhNWj1
OWQdKF]_MWanOWakOH23Ph5nO7amP8>6RHf@T8f8PX22R8jAShb9RY2HW9bFSXZ<
TibPWiZDTYFKX::OVYFBTYBEU9>CU9FGUiNFUYJEThn;RXfDW:2OVI:=SI2DUI6:
QXJ=UI^KUHf7QHV>TY>@SXf?TYBEUI>BTY6@SXb<SHn?SHZ7Qh^@TY29PGYjOhN=
SXZ5PX>8S8^6OGIdN7n5QhJ1OG]jNWUhMgMhNW]lO7f0PhB3P7ajOH>8RhV3OWj3
Ri:CShR2P8B;Si2=RXV=U9ZMViNBShnAU9JHVifNWY^HUI>DUIBBShf>U9ZMW9F=
R8V>UIRFT8Z8Ri6FV9B>RHN9S8j<RHF2PhJ9Rhb<S8^9QX>1PXJ<T96?S8^<T9:A
RhAnOhF=U9FARXB3Qh^>S8R3PXF:Si6@SHZ9RHZ:RXV8R8N5Ph:2QHV<RhN0O7ao
Q8N7Ph1oQ8^BThn6OgaoQHN<SXj<RXV:S8b<RHJ4Q8N<TIFEThn=SHnCUIJETXn?
T9BGVIRETHn>T96BT8f:R8R<TIFFU92;QhJ7RXb<S8Z:Rhf>Shf8PWilOH66RHZ8
QH:2PhF7QhF3PH64R8^<RhR5PhB6RHZ9QX9oP8:7Rhj=RhR7QhV;S8b;RX^>TiRK
ViRCSX^<Si>EUYFDTi>EUYJDTHf;RhjCUiRGU96?Si6DTi:?RhR8RXb?T8j<RHR8
RX^;R8B1P865RXj>S8J3PX>5QhR7QH>3Q8N:S8^8QH>4Qh^?THn=RHR9Rhj@T8n=
S8f?TY>BT8b:RXb@U9FDT8b:RX^>T96?SH^;S8j?Shf:QhJ8S8nAT8f9QXF7Rhf?
SXb:RHZ<SXn>RhV9RhjBU9BASH^:S8nCUIFCT8n?TI>DU9:?SXnBUINFU92<Rhb?
TiBDTHj;Rhb=SXj<RXR8RHb=SHZ6Ph62QHR:RXR4PX21PhF6QH>1PH>5QhR6Ph5o
P8>7Rh^:QhB3Q8J9Rh^:R8R9Rhf?SX^9QhR;Si:CTHj;RHV;SY2AShf;Rhf>T8n=
RXR8RXf@THn<R8J6R8^=SXf:R8R8RXb<RhV7QhR<Si2?S8V7QhV=T9:AShf<S8j@
TY6@SXj?TYFFUY>@SHf?TYJGUiBAShn@TY>CTXn>SY2BTi>@S8V8RHb?TI2=RXN6
QhR:RXV7QHF6R8V9QhB1P864R8Z:R8F2PH:5QhR8QhF5QXR:RXZ7QHB5R8b>Shf:
QhB5QhZ<SH^9R8R:Rhb<RXR7QhV<SXn=RXN5QHN:S8f;RHN6QhV:RXV7QHF7RHb=
RhR5PhB6RXb=S8Z8QhR:S8f=RhZ:S8jATY:?SH^;SY6DUYFCTHn?TI>EUIBBTI:D
UYNFU96?Si2CUYNFTi2>SHnATY:AShf=SXn@T8j;R8R9Rhj?Shb9QXJ7RH^<RhZ8
QhR:Rhb:R8N6QhZ=Shn=RXR7R8^>Shn>S8^;SHn@Shj<Rhb>TI:BTH^8QhR:SHn?
SH^9RHV;S8b:RHN7RH^=SH^8QHB4QhZ<S8^8QXF6R8V:RHR7QhR:S8f<RXR6QhV=
Si2?SH^:Rhf?T92?SXj?T9:CTi6?SHj@TiFFUI>@SXn@TYBDTi6@Si2BTY:@SH^;
S8nATI2>RXR8RH^=SHb:R8R8RHZ:RHN6QHJ9Rhb<RHN5Q8J8Rhb;RXR7R8V;Rh^:
R8R9Rhf>SXb:R8N8Rhf?Shf;RHV:S8f=S8Z9RH^=SXj<RHN6QhV;SHf;R8J6QXR9
RHV7QXJ7R8Z:RHJ4PhB7RH^<RXR6QXJ8Rhb<RhZ:RXb>Shj=RhZ;SI2BTi:@SHb=
Si6CTi:@Si2ATY>BTHn>SXnBTiBCT8f<S8f?TI6@SXb<S8f>SXf;RHV:S8j>SH^8
QXJ8RXb<S8Z8QhR9RX^:RHR7R8Z<SHf;RHN7RH^>Shj=RhZ:Rhb=SHb;RX^<SXn>
SHZ8R8V;SHj>S8Z8QhR:Rh^:RHR7R8Z:RXV7QHB5QhV;RhV7QHB5QhR9RHR7QXN8
RXZ9R8N6QhV<SHj<RXV8RH^=Shn>SHb=SXn@T8n=SHf?TI>CTY2>SHf?TI:BTI2>
SXj?T92?SHb<SHn@T8n=RXV9Rhf>SXf<RXV:Rhb<RhZ9RHZ;SHf=RhV8R8V<SHj=
S8Z9RH^<SHf<Rh^;S8j?SXf;RXZ;SHn@Shf;RXZ;S8f=SH^:RX^<SHb;RHR7R8Z<
S8b:R8J5QXR9RHV8QXJ6QhR8R8J5QHJ7RHZ:RHN6QHJ8RX^;RXV9RHZ<S8b;RXZ:
S8j?Shj<Rh^;SHn@T8n>SHf>Si2@Shj=SHj@TI6@SXb;S8f?T92?SHb;Rhb=SHf<
Rh^;S8f>SH^9R8V:S8f>SH^:RHV;S8f<S8^;Rhb=SXf<RhZ:S8f?T8n=S8^;S8f>
SXj=S8b=SXj>SH^:RX^=SXj>S8Z9RHV;S8b;RXV8RHV:RXV8QhJ7R8Z:RXR7QHF6
R8V:RHR7QhN8RHV9R8N7R8V;S8b;RHR8RH^<SHf<Rh^;S8f>SXf<S8b=Shn?SXf<
Rhb=Si2@Shf<S8b=SXj>SHb<S8f>SXf<RXZ:Rhf>SXf;RXV:Rhb<S8^;RX^<SHf<
RhZ:RX^=SXj>S8^:Rhb=SXj=SHb<SHj>SXf<S8b=SXn?Shf<Rh^<SHj>SHb;Rh^<
S8b;RXZ9RX^<S8^:R8N7R8V:RhZ9R8N8R8V9RHR7QhR9RXZ:RHN7QhR9RX^;RXV8
RHZ:Rh^;RXZ:Rhb=SHb;RXZ;S8j>SXf<Rh^<SHf>SHb<S8f=SXj=S8^;Rhb=SXj=
RhZ:Rh^<SHb;Rh^;S8f>SHb;Rhb=SXn>SXb;Rh^<SHj>SHf=SHf<S8b<S8b=SHf=
SHf<S8b<S8b<S8f=S8b<S8^;Rh^<S8b<S8b;Rh^;Rh^;Rh^<Rh^;RhZ:RXZ;Rh^;
Rh^;RXZ:RXZ:RX^;Rh^;RXZ:RXZ:RXZ;Rh^;RXZ:RXZ:RXZ;Rh^;RhZ:RXZ:RX^;
Rh^;Rh^;RXZ;Rh^;Rhb<Rh^;Rh^;Rh^<S8b<S8b<Rh^;Rhb<S8b<S8b<S8b<S8b<
S8f=SHb<S8b<S8b<SHf=SHf<S8b<S8b<S8f=SHf<S8b<S8b<S8b<S8b<S8b<S8b<
S8b<S8b<S8^;Rh^;Rhb<S8b<Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;RXZ:
Rh^;Rh^;Rh^:RXZ:RX^;Rh^;Rh^;RXZ:RX^;Rh^;Rh^;Rh^;Rh^;S8b<S8b;Rh^;
Rh^;S8b<S8b;Rh^;Rh^;Rhb<S8b;Rh^;Rh^;Rhb<S8b;Rh^;Rh^;Rhb<S8b<Rh^;
Rh^;Rhb<S8b<Rh^;Rh^;Rh^<S8b<Rh^;Rh^;Rh^<S8b<Rh^;Rh^;Rh^<S8b<S8^;
Rh^;Rh^;S8b<S8^;Rh^;Rh^;S8b<S8^;Rh^;Rh^;S8b<S8^;Rh^;Rh^;Rhb<S8^;
Rh^;Rh^;Rhb<S8b;Rh^;Rh^;Rhb<S8b;Rh^;Rh^;Rh^<S8b;Rh^;Rh^;Rh^<S8b;
Rh^;Rh^;Rh^;S8b;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;Rh^;
Rh^;Rh^;Rh^;Rh^;Rh/\>"]},
  ImageCacheContents->"Sound",
  CellTags->{"ElectronicChimes", "G.3.4"}],

Cell[CellGroupData[{

Cell["Implementation", "SubsubsectionIcon",
  CellTags->{"ElectronicChimes", "G.3.4"}],

Cell[BoxData[
    \(\[Phi][{\[Alpha]_, \[Beta]_}, \[ScriptCapitalA]_, \ f_] := 
      If[\[Alpha] < t < \[Beta], \ \[ScriptCapitalA]\ Sin[f\ t], \ 0]\)], 
  "Input",
  AspectRatioFixed->True,
  CellTags->{"ElectronicChimes", "G.3.4"}],

Cell[BoxData[
    \(SeedRandom[18934934]; 
    Play[Evaluate[
        Sin[\(\[Pi]\ t\)\/2]\ \(\[Sum]\+\(i = 1\)\%36 \[Phi][
              With[{s = Random[Real, {0, 2}]}, {s, Random[Real, {s, 2}]}], 
              Random[], \(1000  i\)\/3\ Random[]]\)], {t, 0, 2}, 
      PlayRange \[Rule] All]\)], "Input",
  CellTags->{"ElectronicChimes", "G.3.4"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ", "GroupDivider"],

Cell["Chittering Warble", "Subsection",
  CellTags->{"ChitteringWarble", "G.3.5"}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.0238095 0.952381 0.0147151 0.588604 [

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

% Start of sampled sound

1 string

11025 22050 8

{ currentfile 1 index readhexstring pop }

 false 1 sampledsound

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

80808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

80808080808080808080808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E

7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7C7C7C7C7C

7C7C7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7E7E7E7E7E7E

7E7E7E7E7E7E7E7E7F7F7F7F7F7F7F7F7F7F7F80808080808080808080818181818181818181

8182828282828282828282828383838383838383838383838383848484848484848484848484

8484848484848484848484848484848484848484848484848484848484848483838383838383

8383838383838383838282828282828282828282828282828282828181818181818181818181

8181818181818181818181818181818181818181818181818181818181818181818181818181

8181818181818181818181818181818080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E

7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7C7C7C7C7C7C7C7C7C7C7B7B7B7B7B7B7B7B7A7A

7A7A7A7A7A797979797979787878787878777777777777767676767676767575757575757575

757575747474747474757575757575757575757676767676777777777878787979797A7A7A7B

7B7C7C7D7D7D7E7E7F7F8080818182828383838484858586868787878888888989898A8A8A8B

8B8B8B8C8C8C8C8C8C8C8C8D8D8D8D8D8D8D8D8C8C8C8C8C8C8C8C8C8B8B8B8B8B8A8A8A8A89

8989898988888888878787878686868686858585858585848484848484848484838383838383

8383838383838383838383838383838383838383838383838383838383838383838383838383

8383838383838282828282828282828282828282828281818181818181818181818181818181

8181818181818181818181818181818181818181818181818181818181808080808080808080

8080808080808080808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E

7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7C7C7C7C7C7C7C7C7C7C7B7B7B7B7B7B7B7B7B7B7B7B7B7A7A7A7A

7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7979797979

787878787777777676767575747473737272717170706F6F6E6E6D6D6C6C6B6B6A6A69696868

6867676767676767676767676767686869696A6A6B6C6D6D6E6F7071727375767778797B7C7D

7F80818384858788898B8C8D8E8F919293949495969797989999999A9A9A9B9B9B9B9B9A9A9A

9A9999999898979796959594949392929190908F8E8E8D8D8C8B8B8A8A8A8989888888888787

8787878686868686868686868686868686868686868686868686868686868686868686868686

8585858585858585848484848484848383838383838383838383838383838383838383838383

8383838383838383838383838383838383838282828282828282828282828281818181818181

8181818181818181818181818181818181818181818181818181818180808080808080808080

80808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E

7E7E7E7E7E7E7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C

7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7B7B7B7B7B7B7B7B7B7A7A7A7A7A7A7979

7979797878787878787777777777777777777777777777777777777777777777787878787777

7777777776767675757473737271706F6E6D6C6B6A686766656362615F5E5D5C5B5A59585756

55555454545454545555565758595B5C5E60616466686B6D707375787B7E8184878A8D8F9295

979A9C9EA1A3A4A6A7A9AAABACACADADADADADADACACABAAA9A8A7A5A4A3A1A09E9D9C9A9997

9695939291908F8E8D8C8B8B8A8A898989888888888888888888888889898989898989898989

8989898989898888888888878787878686868685858585858484848484848484848484848484

8484848484848484848484848484848484848484848383838383838383828282828282828282

8282828282828282828282828282828282828282828282828282828282828181818181818181

8181808080808080808080808080808080808080808080808080808080808080808080808080

808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7C7C7C7C7C7C7C7C

7C7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B

7A7A7A7A79797979787878777777767676767575757575757575757676767676777777777878

787878787777777675747372716F6E6C6A686663615E5C595754524F4D4B484645434240403F

3F3F3F4041434447494C4F53575B5F64696E73787D83888D92979CA1A5AAAEB1B5B8BABDBEC0

C1C2C2C2C2C1C0BFBDBBB9B7B4B2AFACAAA7A4A19E9C99979593918F8D8C8B8A898887878787

868787878787888888898989898A8A8A8A8A8A8A898989888888878787868685858584848484

8484848383838484848484848484848484848484848484848484848484848383838383838282

8282828282828282828282828282828282828282828282828282828282828282828181818181

8181818181818181818181818181818181818181818181818181818181818181818080808080

8080808080808080808080808080808080808080808080808080808080808080808080807F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7F7F7F7F7F7F7F7F7F7F7E7E7E

7E7E7E7E7E7E7E7E7E7E7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7E7E7E7E7E7E7E7E7E7E7E

7E7E7E7E7E7D7D7D7D7D7D7C7C7C7C7C7C7C7B7B7B7B7B7B7C7C7C7C7C7C7C7D7D7D7D7D7D7D

7D7D7D7D7D7D7D7C7C7C7B7B7A7A797978787877777777777777787878797A7A7B7B7C7D7D7E

7E7E7E7E7E7D7C7B79777572706C6965615D5955504C47433F3B3734312E2C2B2A2A2B2C2E30

34383C42484E555C646C747D858D969EA5ADB4BAC0C5CACED1D3D5D6D6D6D5D3D1CECBC7C3BE

BAB5B0ABA7A29D9995918E8B8886848281807F7F7F7F7F808081828283848585868687878787

8787868685858484838382828181808080808080808080808181818282828282828383838383

8282828282818181818080808080808080808080808080808181818181818181818181818181

8181808080808080808080808080808080808080808080808080808080808080808080808080

808080808080808080808080808080808080808080808080808080808080808080807F7F7F7F

7F7F7F7F7F7F7F7F808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F8080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F80808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F8080

8080808080808080818181808080808080808080807F7F7F7F7F7F7F7F7F7F7F808080808080

818181818181818181818181818181808080807F7F7F7F7F7F7F7F7F80808080818182828383

8383848484848483838382818180807F7F7E7E7D7D7D7E7E7F7F808283848687888A8B8C8D8D

8D8D8C8B8986837F7B76716B645E575048413B342E2824201D1A191A1B1E21262D343C454F5A

65717D8994A0ABB5BFC8D0D7DCE1E4E6E6E6E4E1DDD9D3CDC6BFB8B0A9A19A938D87817D7975

73716F6E6E6E6F707173747678797B7C7D7E7F808080807F7F7E7E7D7C7B7B7A7A7979797979

79797A7A7B7B7C7C7D7D7E7E7E7F7F7F7F7F7E7E7E7E7D7D7D7C7C7C7C7C7C7C7C7C7C7D7D7D

7E7E7E7E7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7F7F7F7F7F7F7F80

80808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080

8080807F7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E

7E7E7E7E7E7E7E7E7F7F7F7F7F80808080808080808080807F7F7F7F7F7F7E7E7E7E7E7F7F7F

7F80808081818182828282828282828281818181808080808080808080818182838384858686

87888888888888888787868585848383838383848586888A8C8F9194979A9C9FA0A2A2A2A19F

9C98938D857D756B61574C42382E261E18130F0E0E10141A222B3643505F6E7D8D9CABB9C6D1

DBE4EAEFF1F2F1EDE9E2DBD2C8BEB3A89D93897F776F69645F5C5B5A5A5B5C5E6164676A6E71

737678797B7C7C7C7C7C7B7A7A79787877777777777878797A7B7C7D7E7F8080818181828281

81818080807F7F7F7F7F7F7F7F80808081818282838383838383838383828282818181818080

808080808181818181818282828282828181818181808080807F7F7F7F7F7F7F7F7F7F808080

80808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080808080808080808080

808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080807F7F7F7F7F7F7F7F7F7F7F8080808080

8080818181818181818181818080808080808080808080808181818181818282828282818181

81818080807F7F7F7F7F7F7F7F7F7F808080808080808080807F7F7F7E7E7D7D7C7C7C7C7C7C

7C7C7C7C7D7D7D7E7E7E7E7E7E7E7E7D7D7C7C7B7A7A7A797979797A7A7B7C7D7E7F80818283

848484848483828181807F7F7F7F80818386898D91969BA0A5AAAEB2B4B6B6B5B3AEA8A1978D

817466584A3C2F2419110B0706080C131D293747596C7F92A4B6C7D5E2ECF3F8F9F8F5EEE6DB

CFC2B4A597897B6F645B534D494746474A4D51565C61676C7176797D7F81828282828180807F

7E7D7D7D7D7E7E7F808182848586868787878787878685848483828281818180808181818182

82828282828282818180807F7F7E7E7D7D7D7D7D7D7D7D7E7E7E7E7F7F7F7F7F7F7E7E7E7E7E

7D7D7D7D7D7D7E7E7E7E7F7F8080808081818181818180808080808080808080808080818181

818181818181818181818080808080807F7F7F7F7F7F808080808080808080807F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080807F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7E7E7E7E7F7F7F80808080

808080808080807F7F7F7F7F8080808181818282838384848484848383838282818180808080

80808080818181828282828180807F7E7C7B7A79787776767676767778797A7B7C7C7D7D7D7C

7B7A797775747373737476787C81878E969EA6AEB5BCC1C5C7C6C4BFB7ADA09282715F4E3C2C

1E120904010308111E2D40546A8197ADC1D3E3EFF8FDFEFBF5EBDFD0BFAD9B8978685A4E443D

3937383A3F464D555E676F777D83888B8D8E8F8E8D8C8A888785848383838384858687878888

898888878685848281807E7E7D7C7C7C7C7C7C7D7D7E7E7E7E7E7E7E7E7E7D7D7C7C7C7C7C7C

7D7D7E7E7F7F8080818181818181818181818080808080808081818181818182818181818180

807F7F7F7F7E7E7E7E7E7E7E7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7F7F7F7F808080

818181818181818181808080808080808080808081818181818180808080807F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080

80808080808080808080808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080

80808080808080808080808181818181818181818181808080807F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7E7E7E7D7D7D7C7C7C7C7C7D7D7E7E7F7F8080818181818181818180808080818182

828384858687878787878685848381807E7C7B7A7A79797A7A7B7B7C7C7C7B7A797674716E6A

6865646465686C737A838E99A5B0BBC4CCD1D3D2CEC6BBAC9B88735E49352314090200020915

263A5169839DB5CBDFEEF9FFFFFCF3E6D6C3AE99836F5C4B3E342E2B2C3037404B57636F7A84

8C93989B9D9D9B9996928F8C89868483828282838384848484848382807F7D7C7A7978787777

7879797B7C7D7E7F7F808080808080807F7F7F7F808081818282828383838383838282818080

7F7F7F7E7E7E7E7E7F7F7F7F7F7F7F7F7F7E7E7E7E7E7E7E7E7E7F7F7F808080818181818181

81818080808080808080808080808080808080807F7F7F7F7E7E7E7E7E7E7E7F7F7F7F7F8080

8080808080808080808080808080808181818181818181818080807F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F7E7E7E7E7E7F7F7F7F7F80808080808181818080808080808080808080

80808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F8080808080808081818181818080808080808080807F7F8080808080808080807F7F

7F7F7F7E7E7E7E7E7E7E7E7E7F7F7F7F80808080808080808080808080808081818182828282

828282828181807F7F7E7E7D7D7D7D7D7D7D7E7E7E7E7E7E7E7D7D7C7C7C7C7C7C7D7E7F8082

83858687888989898887868483828180808081818282838282807D7A76716B66615C5957575A

5F66707C8A98A7B6C3CED6DADBD6CDC0AE9A836B523B2615090200051020364E6A86A2BDD4E7

F5FDFFFBF1E2CEB8A0876F5945362B2524272E3845546473818E99A1A7A9AAA8A49F9A948E89

84807E7C7B7B7B7C7C7D7E7E7D7D7C7B7978777776777778797B7D7F80828384858585848483

838282818181818181818181818181807F7F7E7D7D7C7C7C7C7C7D7D7E7E7F7F808080808080

80808080808080808181818181818181818080807F7F7F7E7E7E7E7E7E7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F8080808080808181818180808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7F7F7F7F7F808080808081818181818080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F7F7E7E7E7F7F7F7F7F80808081818181818181808080808080808080808080808080807F7F

7F7F7E7E7E7E7E7E7E7F7F7F7F80808080808080808080808080808080808081818181808080

80807F7F7F7F7E7E7E7E7E7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080818181818181

818181818080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7E7E7E7E7D7D7D7E7E7E7F808081828283

83838383828281818180808080808080808080807F7E7D7C7B7A79787878797A7B7D7E808284

8586868686868585848485858688898B8C8C8B8986817B746C645C55504D4D5056606D7D8EA1

B2C3D0DADFDED8CCBBA58D72573D26140802040D1D334D6B8AA8C4DBEDF9FDFAEFDFC9B09579

604936292120242D3A4A5D6F8292A0AAB1B4B4B1ABA39B9289827B767371717273757778797A

7B7B7A7A7A797A7A7B7C7E8082848687888888888785848281807F7E7D7D7D7D7E7E7E7E7E7E

7E7D7D7D7D7D7D7D7E7E7F8081818283838383828281818080807F7F7F7F7F7F7F7F7F7F7F7F

7E7E7E7E7E7E7E7F7F7F808080818181818181818080808080808080808080807F7F7F7F7F7F

7F7F7F7F7F7F7F7F8080808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F

7F7F7F7F80808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F

80808080808080808080808080808080808080808080807F7F7F7F7F7F7E7E7E7E7F7F7F7F80

808081818181818180808080808080808080808080807F7F7F7E7E7E7E7E7E7E7E7F7F7F8080

8081818181818080808080808080808080808080807F7F7F7E7E7E7D7D7D7E7E7E7F7F808080

8081818181808080808081818181818181818180807F7E7E7D7C7C7C7C7C7D7D7E7F7F808081

818181818181818182828384848484848382817F7D7B7A7877777778797A7B7D7E8080818181

818182828486888C8F92949595938F8880766C61564E4745464C5665768A9FB4C6D4DEE1DDD3

C1AB9073563B231208060D1C324E6D8EADCAE1F0F8F8EEDEC7AC8F71563F2D221E212B394C61

768A9CABB5BABBB8B1A79C90857B736D6968686A6D7175787B7D7E7F7F7F7F7F808182838486

8788898888868583807E7C7B7A7979797A7B7C7D7E7F7F7F8080808080808081828283838383

83828281807F7E7D7D7D7D7D7D7D7E7E7F7F7F80808080808080808081818181818181818180

807F7F7E7E7E7E7E7E7E7F7F7F7F80808080808080808080808080808080808080807F7F7F7F

7F7F7F7F7F7F7F7F8080808080808080808080808080808080808080807F7F7F7F7F7F7F7F7F

7F8080808080808080808080808080808080807F7F7F7F7F7F7F7F7F7F808080808080808080

8080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080808080807F

7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F808081818181818181818080807F7F7F7F7F7F

7F7F7F7F7F7F7E7E7E7E7E7F7F7F808081818282828282818180807F7F7F7E7E7E7E7F7F7F7F

7E7E7E7E7E7E7E7F7F808081828283838383828281807F7E7E7D7D7D7D7D7E7E7E7E7E7E7D7D

7D7D7E7F808183848586878786858482807E7C7B79797979797A7B7B7C7C7B7B7B7B7C7D8083

888D92979B9D9D9A948C817466594D454041475263778EA5BBCDDADFDED4C2AA8E6F51352011

0C101D334F6F91B1CDE3F0F3EDDEC8AC8D6F523B2A21202735485E768DA1B0BBBFBEB9AFA294

86796E67626062656A6F757A7F828486868685858484858585868686858382807D7B7A787878

78797B7C7E808182838383838282828181818181818180807F7E7E7D7C7C7C7C7C7D7E7F8081

82828282828281818080808080807F7F7F7F7F7E7E7E7E7E7E7E7E7F7F808181818282818181

8080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808081818181818080807F7F7F7F7F

7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F

8080808080808080808080808080808080808080808080808080808080808080807F7F7F7F7F

7F7F7F7F7F7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F

7F808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808081

8181818180807F7F7E7E7E7E7E7E7E7E7F7F8080808181818181818181818181818180807F7F

7E7D7D7C7C7C7D7D7E7F80818282838383828281818180808080807F7F7E7D7C7B7B7A7A7B7B

7D7F8183858687888786858382807F7D7D7C7C7C7B7B7A787775747475777B81888F969DA2A4

A29D948879695A4C433E3F4756698099B1C6D5DCDAD0BDA48666482F1D14152135527295B5CF

E2EBEADFCAAF9071543C2B24252F40566F879EB0BCC1C0B9AD9E8E7E70655E5B5C60666E767D

83888B8C8C8B898786848383828281807F7E7C7B7A797878797A7C7E80828485858585848381

807F7F7E7E7E7E7E7E7E7E7E7D7D7E7E7E7F80818282838383828281807F7E7E7E7E7E7E7E7E

7F7F7F7F7F80808080808181818181818180807F7F7E7E7E7E7E7E7F7F7F8080808081808080

80808080808080807F7F7F7E7E7E7E7E7E7F7F808080818181818180808080807F7F7F7F7F7F

7F7F7F7F7F7F7F7F7F8080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F80

8080808080808080808080807F7F7F7F7F7F7F7F7F7F7F808080808080808080808080808080

80808080807F7F7F7F7F7F7F7F7F7F7F808080808080808080808080808080808080807F7F7F

7F7F7F7F7F7F7F7F808080808080808080808080808080807F7F7F7F7F7F7F7E7F7F7F7F8080

8181818181818180807F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8080818182828282828180807F

7E7D7D7D7D7D7D7E7F7F808080818181818282838383838281807F7D7B7A7978797A7B7D7F82

84858686868685848382828181807E7C7A7773716F6E707379818A949DA4A7A7A2988B7A6958

4A413E434E617891AAC0CFD7D4C9B4997A5B3F2A1E1C263A557697B6CFDEE3DDCDB497775941

30292B374A617B94A9B8C0C0B9AD9D8B7A6B6059575A6069737D858C9091918F8C898582807F

7D7D7C7C7C7B7A7A7A7A7B7C7D7F818385868686858482807F7D7C7C7C7C7D7D7E7E7F7F8080

8080818181828282828180807F7E7D7D7D7D7D7E7F7F80808181818181818080808080807F7F

7F7F7E7E7E7E7E7F7F808081818181818180807F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080

818181808080807F7F7E7E7E7E7F7F7F7F80808080808080808080808080807F7F7F7F7F7E7E

7F7F7F7F80808081818181808080807F7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080

80807F7F7F7F7F7F7F7F7F7F7F808080808080808080808080808080807F7F7F7F7F7F7F7F7F

7F80808080808080808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080

80807F7F7F7F7F7F7F7F7F7F7F7F7F7F8080808080808080808080807F7F7F7E7E7E7E7F7F7F

8080808080808080808080808080807F7F7E7E7E7E7E7E7E7F80818182828282828180807F7F

7E7E7E7E7E7E7E7E7E7E7E7F808182838484858483817F7E7C7A7979797A7C7D7F8182838484

8485858686868584817E7975706C6A6A6D737C87929DA5A9A9A398887663534741434D5E748E

A7BCCAD0CBBDA68A6B4F3829262D405A7999B6CCD8D8CEBA9F8063493830323E516A839BAEBA

BEBAAFA08D7B6A5E57565A626C78838C929595938F8A85807D7A797879797A7B7B7C7C7D7E80

818384858686858382807E7C7B7A7B7B7C7D7F80818182828282818181818080807F7F7E7E7D

7D7D7E7E7F808181828282818180807F7F7E7E7E7E7F7F7F7F7F7F8080808080818181808080

7F7F7F7E7E7E7F7F7F8080808080808080808080807F7F7F7F7F7F7F7F7F7F7F808080808080

808080807F7F7F7F7F7F7F7F7F7F808080808080808080808080807F7F7F7F7F7F7F7F7F8080

80808080808080807F7F7F7F7F7F7F7F7F7F7F7F7F808080808181818080807F7F7F7F7F7F7F

7F7F7F80808080808080808080808080807F7F7F7F7F7F7F7F7F80808080808080808080807F

7F7F7F7F7F7F7F7F7F7F7F7F80808080808080808080807F7F7F7F7F7F7F7F7F808080808080

8080808080808080807F7F7F7F7F7F7F7F7F7F808080818181808080807F7F7F7F7F7F7F7F7F

7F7F7F80808080818181818180807F7F7E7E7D7D7E7E7F7F8081818181818181818180807F7F

7E7E7D7C7C7C7D7E7F8082838485858483817F7D7C7B7A7A7B7B7C7D7E7F808283858788898A

8986827D77716B68676A717A86929DA6A9A79E91806D5B4D46464F5F758EA6B9C5C7BFAE9579

5D45353036465F7D9AB4C7CFCBBDA78B6E5542393A44576E879DAEB8B9B2A593806F6158565A

626D7A868F969897938D87807B7775757577797B7D7F8081828384848585848382807E7C7B7A

7A7B7C7D7F818283838383828180807F7E7E7E7E7E7E7E7E7E7F808081818282828181807F7F

7E7E7E7E7E7F7F8080808181818080808080807F7F7F7F7F7F7F7F7F7F808080818180808080

7F7F7F7F7F7F7F7F7F8080808080808080808080807F7F7F7F7F7F7F7F7F8080808080808080

807F7F7F7F7F7F7F7F7F7F808080808080808080807F7F7F7F7F7F7F7F7F8080808080808080

80807F7F7F7F7F7F7F7F7F7F808080808080808080807F7F7F7F7F7F7F7F7F80808080808080

80808080807F7F7F7F7F7F7F7F7F7F8080808181808080807F7F7F7F7F7F7F7F7F7F80808080

80808080808080807F7F7F7F7F7F7F7F7F808080808080808080807F7F7F7F7F7F7F7F7F7F7F

808080808081818080807F7F7F7F7E7E7F7F7F8080808080808080808080807F7F7F7F7E7E7E

7E7F7F8080818181818181807F7F7E7E7E7E7E7E7F7F7F80808181818282828181807F7D7C7C

7C7C7D7E7F8182848484848382807F7E7D7C7B7B7B7B7B7C7E808285888B8C8C8A868078716B

67676A727C89959FA6A6A095857362544C4C55657A91A6B6BEBCB09C836952423B404E65809A

B1BFC4BDAD967C634F44424A5A70879BABB3B2AA9B8A78685E595A626D798690969997938C84

7D7773727375787B7F81838485858584838281807E7D7C7B7B7B7C7D7F808283848483828180

7F7E7D7D7D7D7E7E7F80808181818181818180807F7E7E7E7E7E7E7F7F808181818181818080

7F7F7F7F7F7F7F7F7F7F808080808080808080807F7F7F7F7F7F7F7F80808080808080808080

7F7F7F7F7F7F7F7F7F808080808080808080807F7F7F7F7F7F7F7F808080808080808080807F

7F7F7F7F7F7F7F808080808080808080807F7F7F7F7F7F7F808080808080808080807F7F7F7F

7F7F7F7F8080808080808080807F7F7F7F7F7F7F7F80808080808080808080807F7F7F7F7F7F

7F7F7F8080808080808080807F7F7F7F7F7F7F7F7F808080808080808080807F7F7F7F7F7F7F

7F7F8080808080808080807F7F7F7F7F7F7F7F7F7F808080808080808080807F7F7F7F7E7F7F

7F7F8080808181818080807F7F7F7F7F7F7F7F7F7F8080808181818180807F7F7E7E7E7E7E7F

7F808081818181818180807F7F7E7E7E7E7E7E7F7F80818282838282817F7E7D7C7C7C7C7D7F

808283838483838281807F7D7C7A7979797A7C8084888C8E8E8C878078706A67686D76828E99

A1A39F958776665953545D6D8095A6B1B4AD9E8A735E4E474A576A8299ABB6B7AE9E88715D50

4C505D6F8396A4ABABA2958474675F5D616A76828D949897928B837B75727172757A7E828587

8787858482807E7D7C7C7C7C7C7D7E8081828383838382807F7E7D7C7C7D7E7F808181828282

818180807F7E7E7E7E7E7E7F7F80818181818181807F7F7E7E7E7E7E7F7F8080818181818080

807F7F7F7F7F7F7F7F7F8080808080808080807F7F7F7F7F7F7F7F808080808080808080807F

7F7F7F7F7F7F7F8080808080808080807F7F7F7F7F7F7F7F808080808080808080807F7F7F7F

7F7F7F7F8080808080808080807F7F7F7F7F7F80808080808080808080808080808080808080

808080808080807F7F7F80808080808080808080807F7F7F7F7F7F7F80808080808080808080

7F7F7F7F7F7F7F7F8080808080808080807F7F7F7F7F7F7F7F808080808080808080807F7F7F

7F7F7F7F7F8080808080808080807F7F7F7F7F7F7F7F7F80808080808080807F7F7F7F7F7F7F

7F7F8080808181818080807F7F7F7E7E7E7F7F7F80808181818180807F7F7E7E7E7E7E7F7F80

80818181818181807F7F7E7D7D7D7E7F8081828283838281807F7D7D7C7C7D7D7E7F81828383

84848382807E7B797777777A7E83888C8F8E8B867E766F6A696C747E89949B9E9A928576695F

5B5E68768898A4A9A79C8C7A685A545660708396A4ABAAA0917E6C5E5758606E7F8F9CA3A39C

90827469636267717C87909596928C847C75717072767B80858889888684817E7D7B7B7B7C7D

7E7F8081828283828281807F7E7D7D7D7D7E7F80818282828180807F7E7E7E7E7E7F7F808081

8181818080807F7F7E7E7E7F7F7F80808181818180807F7F7E7E7E7F7F7F8080808080808080

7F7F7F7F7F7F7F7F7F80808080808080807F7F7F7F7F7F7F7F80808080808080807F7F7F7F7F

7F7F7F7F8080808080808080807F7F7F7F7F7F7F80808080808080807F7F7F7F7F7F7F7F8080

8080808080808080807F7F7F7F7F7F80808080808080807F7F7F7F7F80808080808080808080

8080808080807F7F7F7F7F7F80808080808080807F7F8080808080807F7F7F7F7F8080808080

8080807F7F7F7F7F7F808080808080808080808080807F7F7F7F7F7F7F808080808080807F7F

7F7F7F7F7F808080808080808080807F7F7F7F7F7F7F7F7F80808080808080807F7F7F7E7F7F

7F80808181818080807F7F7F7F7F7F7F7F7F8080808181818080807F7E7E7E7E7E7F80818182

828281807F7E7D7D7D7E7F8080818282828181807F7F7E7D7C7C7D7D7F80828486868583807C

797675777A7E84898D8E8D88827A736E6C6E757D87909697948C81766B656469727F8C979D9E

978C7E70656061697584929CA09D9487796C6461656E7B8893999B968D82776E69696D757F88

8F92918D877F79747172757A8085888A898783807C7A79797B7D7F818383838382807F7F7E7E

7E7E7E7F7F7F80808181818181807F7E7E7D7E7E7F808182828181807F7E7E7E7E7F7F808081

808080807F7F7F7F7F7F7F7F7F7F7F808080818180807F7F7E7E7E7F7F808081818080807F7F

7F7F7F7F808080808080808080808080807F7F7F7F7F7F808080808080807F7F7F7F7F7F8080

8080808080807F7F7F7F7F7F7F80808080808080808080807F7F7F7F7F7F7F80808080808080

7F7F7F7F7F7F7F808080808080807F7F7F7F7F7F80808080808080808080808080807F7F7F7F

7F7F808080808080807F7F7F7F7F7F808080808080807F7F7F8080808080807F7F7F7F7F8080

80808080807F7F7F7F7F7F7F808080808080807F7F7F7F7F8080808080807F7F808080808080

807F7F7F7F7F7F808080818180807F7F7E7E7F7F808080808080807F7F7F7F7F8080807F7F7F

7F7F808081818180807F7E7D7E7E7F8081828282817F7E7E7D7E7E7F808181818080807F7F80

80807F7F7E7E7E7E7F808283848382807E7B7A7A7B7D808386878785827E7A787677797D8286

898B8A87827C77737273787E858B8F908D877F77706D6D727A848D9395928B81766E696A6F79

848E9496938B81776F6B6C7179838B91928F898179737070747A80868A8C8B88837E79767576

797D818588888785817D7A7878797C7F8385868584817E7C7B7B7C7E8081828282817F7F7E7E

7F808080807F7F7E7F7F8081818181807F7E7D7D7E7F8081828281807F7E7E7E7E7F80808181

8180807F7F7F7F7F80808080807F7F7F8080808080807F7F7F7F7F7F808080808080807F7F7F

7F7F7F7F808080808080807F7F7F7F7F7F8080808080807F7F7F7F7F7F80808080807F7F7F7F

80808080807F7F7F7F7F7F8080808080807F7F7F7F7F7F808080808080807F7F7F7F7F7F8080

8080808080807F7F7F7F7F7F7F8080808080808080808080807F7F7F7F7F7F80808080808080

7F7F7F7F7F7F8080808080807F7F7F7F7F7F8080808080807F7F7F7F8080808080807F7F7F7F

7F8080808080807F7F7F7F7F7F8080808080807F7F7F7F7F7F8080808080807F7F7F7F7F8080

80807F7F7F7F7F808080808080807F7F7F7F7F7F7F808080808080807F7F7E7E7E7F80808181

8180807F7E7E7E7F8080818181807F7F7E7F7F808181807F7E7E7D7E7F81828383827F7D7B7A

7B7D8083858685837F7C7978797C7F8386878684817D7B797A7B7D80828484848482817F7D7B

7A797B7D818488898986817B767373777D848B8F8F8B837B746F6F737B848C90908C847C7570

70747B82898C8C89847E797776787C7F828485858382807F7D7C7C7C7C7D7F8184858584827F

7B79787A7C8084868786837F7B79797A7D8184858584817E7C7B7C7D7F81828282817F7F7E7E

7F80808080807F7F7F7F7F80808080807F7F7F7F7F7F80808080808080807F7F7F7F7F7F8080

80818180807F7F7E7E7F8080818181807F7F7F7F7F7F8080808080807F7F7F7F7F8080808080

7F7F7F7F7F8080808080807F7F7F7F7F80808080808080807F7F7F7F7F808080808080807F7F

7F7F7F8080808080807F7F7F7F7F7F8080808080807F7F7F7F7F808080808080807F80808080

807F7F7F7F808080808080808080808080807F7F7F7F7F8080808080807F7F7F7F7F80808080

80807F7F7F7F7F7F8080808080807F7F7F7F7F8080808080807F7F7F7F8080808080807F7F7F

7F8080808080808080807F7F7F7F7F7F8080808080807F7F7F7F7F7F8080818180807F7F7E7E

7F7F80818181807F7F7F7F7F7F80808080807F7F7F7F7F80808080807F7F7F7F7F8080808080

807F7F7F7F7F7F7F7F808081818181807E7D7D7D7E8082838484827F7C7A7A7B7E8185868684

807C7978797D8184868684807D7A7A7B7E81838483807E7C7C7E80838483807D7A797A7E8287

8A89857E787373767D858C8F8D877E76706F737B858D908F887F777170747C848A8D8B867F79

7575797E83878785817D7B7A7C7F828483817E7C7B7C7E81848685827E7A79797C8084868785

817D7A79797C8083858584817E7C7B7C7D7F8182828281807F7E7E7E7F7F7F80808081818080

7F7E7E7E7E7F80818181807F7F7E7E7F8080818180807F7F7F7F7F80808080807F7F7F7F7F80

808080807F7F7F7F7F7F80808080808080807F7F7F7F7F7F8080808080807F7F7F7F7F808080

8080807F7F7F7F7F8080808080807F7F7F7F7F7F808080808080807F7F7F7F7F7F8080808080

807F7F7F7F7F8080808080807F7F7F7F8080808080807F7F7F7F7F8080808080808080808080

7F7F7F7F80808080807F7F7F7F7F8080808080807F7F7F7F7F80808080807F7F7F7F7F808080

8080807F7F7F7F7F7F8080808080808080807F7F7F7F7F7F80808080807F7F7F7F7F80808080

80807F7F7F7F7F80808080807F7F7F7F7F80808080807F7F7F7F7F8080808080807F7F808080

7F7F7F7F7F80808080807F7F7E7E7F8080818181807F7E7D7E7E8081828281807F7E7E7E7F7F

808181808080807F7F7F7F7E7E7F7F81828282817F7D7B7B7D7F82858584817D7A797A7E8285

8786827D7977797C82868987837D7875777C83898C8A847C7571737A838C908E877D736D6E75

808B93938D81756D6B707B88919590867A706B6E77838D9291897E746F707680898E8E888078

7373787F868A8A86807A76767A80858888847F7B78787B8084868683807C7A7A7C7F82838382

807E7D7D7E7F80818180807F7F808080807F7E7E7E7F80818281807F7E7D7D7F808182828180

7E7E7E7E7F80818180807F7F7F7F7F7F7F7F7F8080808080807F7F7F7F7F7F80818180807F7F

7F7F7F80808080807F7F7F7F7F80808080808080808080807F7F7F7F8080808080807F7F7F7F

8080808080807F7F7F7F7F80808080807F7F7F7F7F8080808080808080807F7F7F7F7F808080

8080807F7F7F7F8080808080807F7F7F7F7F8080808080808080807F7F7F7F7F808080808080

7F7F7F7F7F80808080807F7F7F7F7F80808080807F7F7F7F7F80808080807F7F80808080807F

7F7F7F80808080807F7F7F7F7F80808080807F7F7F7F7F80808080807F7F7F7F7F808080807F

7F80808080807F7F7F7F7F80808181807F7F7E7E7F8080818180807F7F7F7F7F80808080807F

7F7F808080807F7F7F7F80808181807F7E7E7E7F80818281807F7E7D7E7F80818181807F7E7E

7F80818181807F7E7F7F818181807F7D7D7E80828484827F7C7A7A7D82868886827C7775777D

848A8D8A82797270747D8890928D82766D6A707C8B959891837368656D7C8C999B9384726663

6B7B8D999C94847266646C7B8C989A92837469676F7C8B94958E82756D6D737E898F8F898077

72737880878A89847E7977797D81858584817E7C7C7D80828282807E7E7E7F808181807F7E7E

7E7F818282817F7E7D7E7F80818281807F7E7E7F80818181807F7F7F7F808080807F7F7F7F80

808080807F7F7E7F80808181807F7F7E7F7F80808080807F7F7F7F80808080807F7F7F808080

80807F7F7F7F80808080807F7F7F7F8080808080807F7F7F7F80808080807F7F7F808080807F

7F7F7F80808080807F7F7F7F7F80808080807F7F7F7F7F808080808080808080807F7F7F7F80

80808080807F7F7F7F7F808080808080807F7F7F7F7F808080808080807F7F7F7F8080808080

807F7F7F7F80808080807F8080808080807F7F7F7F80808080807F7F7F7F8080808080807F7F

7F7F808080807F7F7F7F80808080807F7F7F7F80808080807F7F7F7F80808080807F7F7F7F80

808080807F7F7F7F808080807F7F7F7F7F808080807F7F7F7F7F808181807F7F7E7F7F808181

807F7F7E7F80808181807F7E7E7F80818181807E7E7E7F80818281807E7D7D7E80828282807E

7D7D7E808282817F7D7D7D7F828383817E7B7A7B80858888847D7774767C858D8F8B82766E6C

73808D96968D7D6D64667385979F9B8B76645D63768D9FA49B866F5D5A667C94A3A49780695C

5D6C8398A29F8F79675F657588979C95867569676F7D8B93938B7F7570717982898C89827C77

777A80848684817E7C7C7E808283817F7D7D7E80818282807E7D7D7E80828281807E7D7D7F80

818181807F7E7E7F808181807F7E7E7F80818180807F7E7F7F808181807F7F7E7F7F80818080

7F7F7F7F80808080807F7F7F7F808080807F7F7F7F80808080807F7F7F7F80808080807F7F7F

7F808080807F7F7F7F80808080807F7F7F7F808080807F7F7F7F80808080807F7F7F7F808080

80807F7F7F7F808080807F7F7F7F80808080807F7F7F7F80808080807F7F7F7F80808080807F

7F7F8080808080807F7F7F8080808080807F7F7F8080808080807F7F7F8080808080807F7F7F

7F80808080807F7F7F7F80808080807F7F7F80808080807F7F7F7F80808080807F7F7F7F8080

8080807F7F7F7F808080807F7F7F7F80808080807F7F7F7F80808080807F7F7F7F808080807F

7F7F7F80808080807F7F7F7F808080807F7F7F7F80808181807F7E7E7F80818181807F7E7E7F

808181807F7E7E7F808181817F7E7D7E7F818282817F7D7C7D80828382817E7C7C7E80828382

7F7D7C7D80838483807C79797D838889867F7772737B868F928D817369697384949C99897463

5D667B93A4A5967D6355596E8BA4ADA38A6B5551617E9CADAB96785E525A718FA5AA9E856A5A

5A6A8398A29D8C7666626B7C8D97968C7D716D707A858D8D88807876787D838686837E7B7B7D

808383817F7D7C7E80828382807D7C7D7F818282817F7D7D7E7F818281807F7E7E7F80818180

7F7E7E7F808181807F7E7E7F80818181807F7E7F7F808080807F7F7F7F808080807F7F7F7F80

808080807F7F7F7F808080807F7F7F7F80808080807F7F7F80808080807F7F7F80808080807F

7F7F7F808080807F7F7F7F80808080807F7F7F7F808080807F7F7F7F808080807F7F7F7F8080

8080807F7F7F7F808080807F7F7F7F808080807F7F7F7F80808080807F7F7F7F808080807F7F

7F7F80808080807F7F7F7F808080807F7F7F7F80808080807F7F7F80808080807F7F7F7F8080

8080807F7F7F7F808080807F7F7F7F80808080807F7F7F7F808080807F7F7F7F80808080807F

7F7F7F808080807F7F7F7F808080807F7F7F7F80808080807F7F7F7F80808080807F7F7F7F80

8080807F7F7F7F808080807F7E7F7F808181807F7E7E7F80818181807F7E7E7F808181807F7E

7E7F808181807F7D7D7E808283817F7D7C7D7F828383817E7C7C7E808383827F7C7C7E818484

827D79787B82888B8880767071798692968F806F6466748A9CA2988269595A6D8AA3ADA38767

51506586A6B5AB8E694E4A5E81A4B6AF936E524B5C7C9EB1AD95745A525E7996A7A59379645D

667A8E9B9A8D7C6E69707C89908E867C75747980858785807C7A7C7F8283827F7D7C7E808383

827F7D7C7D7F828382807E7D7D7E808282817F7E7E7F808181807F7E7E7F808181807F7E7E7F

808181807F7E7E7F80808180807F7F7F7F808080807F7F7F808080807F7F7F7F808080807F7F

7F7F80808080807F7F7F7F808080807F7F7F808080807F7F7F7F808080807F7F7F7F80808080

807F7F7F7F808080807F7F7F80808080807F7F7F808080807F7F7F7F80808080807F7F7F7F80

8080807F7F7F7F808080807F7F7F80808080807F7F7F7F808080807F7F7F7F808080807F7F7F

7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F7F80808080807F7F7F7F80808080

7F7F7F7F808080807F7F7F7F808080807F7F7F7F80808080807F7F7F7F808080807F7F7F8080

8080807F7F7F80808080807F7F7F7F808080807F7F7F7F80808080807F7F7F808080807F7F7F

7F808081807F7E7E7F80818181807E7E7E7F808181807F7E7E7F808181807E7E7F808182817F

7D7D7E80828382807D7C7C7F828483817E7C7C7E818383817D7C7C808385837F79777980888D

8A82766E6E78879599907D6A60657891A3A594775C525E7B9CB1AE946F50485A80A6BAB29268

49445C86ACBDB08C624748638BADB8A885614D526D8FA8AC9B7E63586077909F9E8E7A6A666F

7F8D938F847872747B838888837E7A7A7E828483807D7C7D808384827F7C7B7D80838482807D

7C7D7F818282807E7D7E7F8181817F7E7E7F808181807F7E7E7F808181807F7E7E7F80818180

7F7E7E7F808080807F7F7F7F8080807F7F7F7F808080807F7F7F7F808080807F7F7F7F808080

807F7F7F7F808080807F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F7F8080

80807F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F8080

80807F7F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F80

8080807F7F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F

808080807F7F7F7F80808080807F7F7F7F808080807F7F7F808080807F7F7F7F808080807F7F

7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F7F8080807F7F7F7F808181807F

7E7E7E80818181807E7E7E7F818181807F7E7F808181807F7E7E808182817F7D7C7D7F828483

807D7B7C7E828483817D7C7C7F8283827F7C7C7E838685807A76777F888E8D83766C6C778998

9B8F79645C667F9BAAA48A6851516A90AFB7A27A54425077A4BEB99667443F5C8BB4C2AE8256

3F4A709DBAB89A704F485E83A5B2A58665555B738FA2A1907866636F8191968E817470747D86

8A87817B797B808384817E7C7D808384827E7B7B7D818484827F7C7B7D808383827F7D7D7E80

8181807F7E7E808181807F7E7E7F818181807E7E7E7F818181807F7E7E7F808181807F7F7F80

8080807F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F80

8080807F7F7F808080807F7F7F7F808080807F7F7F7F808080807F7F7F808080807F7F7F8080

80807F7F7F80808080807F7F7F808080807F7F7F7F808080807F7F7F808080807F7F7F808080

807F7F7F7F808080807F7F7F7F808080807F7F7F808080807F7F7F808080807F7F7F7F808080

807F7F7F7F808080807F7F7F7F808080807F7F7F808080807F7F7F808080807F7F7F7F808180

807F7F7F7F808180807F7F7F7F808080807F7F7F8080807F7F7F7F808081807F7F7E7F808181

807F7F7E7F808081807F7F7F7F8080807F7F7F7F808180807F7E7F80818181807E7E7E808182

81807E7E7E808181807F7E7F808181807F7E7E7F818282807D7C7C7F828483807D7B7C7F8284

83807D7C7D808383807D7B7D828686817A75757D88908F8475696A778C9C9D8D735E5A6B89A5

AE9D7A584A597FA7BBAF885B40486FA0C0BE9966403C5D91BBC5A9774A3B5180ADC1B0865A44

4F739CB4AE906B53556D8DA3A5927764616F8494978D7D716E75818A8B867E79797D8284837F

7C7C7F8284827F7C7B7D818484827E7B7B7E818484817E7C7D7F818281807E7E7F8081817F7E

7E7F818181807E7D7E80818281807E7D7E808181817F7E7E7F808080807F7F7F8080807F7F7F

7F808181807F7E7F7F808180807F7F7F7F808080807F7F7F808080807F7F7F8080807F7F7F7F

808080807F7F7F7F808080807F7F7F7F808080807F7F808080807F7F7F808080807F7F7F7F80

8080807F7F7F80808080807F7F8080808080808080808080808080808080807F7F8080808080

7F7F7F80808080807F7F7F808080807F7F808080807F7F7F80808080807F7F7F808080807F7F

7F7F808080807F7F7F808080807F7F7F808080807F7F7F808080807F7F7F7F808080807F7F7F

7F808080807F7F7F808080807F7F7F808080807F7E7F808081817F7E7E7F808181807F7E7E7F

808080807F7F7F8080807F7F7E7F808181807E7E7E7F818281807E7D7E808182817F7E7E7F80

81807F7E7E808181807F7D7D7F818383807D7B7C7F838583807C7B7C808384827E7C7C7F8283

817D7B7C818688837B74737C889291847367687990A09D886C585B7496AEAB8E664B4D6D9ABA

B896644141669AC0C29C663E3B6097C1C4A16A413C5E92BBC0A16F4943608DB0B69D74555066

89A3A89578625F6E8697998C7A6E6D77848C8C847B77797E8384827E7C7D808383807C7B7D81

8484827E7B7B7E828483807D7C7D7F8282817F7E7E7F8081807F7E7F808181807E7E7E808182

817F7E7D7E808181807F7E7E7F8081807F7F7F7F8080807F7F7F808181807F7E7E7F8181817F

7E7E7F808181807F7F7F7F8080807F7F7F7F8080807F7F7F808080807F7F7F7F808080807F7F

7F808080807F7F7F7F8080807F7F7F808080807F7F7F808080807F7F7F7F808080807F7F7F80

808080807F7F7F808080807F7F808080807F7F7F80808080807F7F7F8080808080807F7F8080

80808080808080808080807F7F80808080807F7F7F80808080807F7F7F808080807F7F7F8080

80807F7F7F808080807F7F7F808080807F7F7F7F808080807F7F7F808080807F7F7F7F808080

7F7F7F8080807F7F7F7F808080807F7E7F7F808180807F7E7F808081807F7F7F808080807F7F

7F8081807F7E7E7F808181807E7D7E7F8182817F7E7D7E808181807F7E7F8081807F7E7E7F81

82817F7D7C7E818483807D7B7C7F8385837F7C7B7D818483807D7C7E8283817D7A7B81878984

7B72727B899392847064697D95A39B8063556182A4B2A17A54475D8AB3BEA270463E5E94BEC3

9F663D3C649DC4C1965E3B426EA3C2B78C5A414E79A5B9A9825B4D5E81A1AA997B625D6D8699

9A8B786C6D79878E8B8279767A808585817D7C7E8183817E7C7D808384827E7B7B7E82848380

7D7B7D808283817F7D7E7F8181807F7F7F8081807F7E7E7F8181817F7E7E7F808281807E7E7E

808181807F7F7F7F8080807F7F7F8080807F7F7F7F8081807F7E7E7F808181807F7E7F808081

807F7F7F7F8080807F7F7F8080807F7F7F7F8081807F7F7E7F808181807F7F7F808080807F7F

7F7F8080807F7F7F8080807F7F7F7F8080807F7F7F7F808080807F7F7F7F8080807F7F7F7F80

80807F7F7F8080807F7F7F7F808080807F7F7F808080807F7F7F7F808080807F7F7F80808080

7F7F808080807F7F7F80808080807F7F7F80808080807F7F7F808080807F7F7F8080807F7F7F

808080807F7F7F7F808080807F7F7F808080807F7F7F7F8080807F7F7F808080807F7F7F8080

807F7F7F7F808080807F7F7F7F8081807F7F7F7F8080807F7F7F8080807F7F7F7F8081807F7E

7E7F808181807E7D7E808182817F7E7E7F8081807F7F7F8081807F7E7E7F8182817F7C7C7E82

8484807C7A7C808485827E7B7C7F8283817E7D7E8183827D797A80878A867B71707A8A959282

6D636B829BA495765B566D92AEAD8D63485179A7BEAC7D4E3D588DBAC39F673E3F69A2C5BB8B

543A4D80B1C2A8754B446392B4B391674E57789CAB9E7F635C6C86999A8B766A6D7B8A908A7F

77757B828684807C7C7F82827F7D7C7F8284827E7B7B7E828483807C7B7D818383817E7D7E80

8181807F7E7F8080807F7E7F808181807E7E7F808181807E7E7E808181807F7E7F7F8080807F

7F7F8080807F7F7F808080807F7F7F808180807F7E7F808080807F7F7F808080807F7F7F8080

807F7F7F808080807F7F7F808080807F7F7F808080807F7F7F808080807F7F7F8080807F7F7F

8080807F7F7F7F808080807F7F7F808080807F7F7F808080807F7F7F8080807F7F7F80808080

7F7F7F808080807F7F7F808080807F7F7F7F8080807F7F7F808080807F7F808080807F7F7F80

8080807F7F7F7F808080807F7F7F808080807F7F7F8080807F7F7F808080807F7F7F80808080

7F7F7F808080807F7F7F7F808080807F7F7F8080807F7F808080807F7F7F808080807F7F7F7F

808080807F7F7F808080807F7F7F8080807F7F7F8080807F7F7F7F8081807F7E7E7F80818180

7E7E7E808181807F7E7F8080807F7F7F8081807F7E7E7F8283827F7C7C7E828483807C7B7D81

8483807D7C7E8182817F7D7E8184827D79797F878B867B71707B8C96917F6A626F899FA18B6A

565D7EA2B09E75514B6A99B9B28857405486B5C09F6841446FA6C3B27F4D3E5B90B9BA946245

517BA6B6A07655526D93A9A285675C6984999B8B75696E7D8C90897D75757D8487847E7C7D80

82817F7D7E818383807C7B7E818483807C7B7D818383807E7C7E808281807F7E7F8080807F7F

7F8081807F7E7E808181807F7E7E808181807F7E7E7F8081807F7F7F8080807F7F7F8080807F

7F7F808080807F7F7F808080807F7F7F7F8080807F7F7F808080807F7F8080807F7F7F808080

807F7F7F808080807F7F7F808080807F7F7F808080807F7F8080807F7F7F808080807F7F7F80

8080807F7F7F808080807F7F7F808080807F7F7F8080807F7F808080807F7F7F808080807F7F

7F808080807F7F7F808080807F7F7F8080807F7F7F8080807F7F7F808080807F7F7F80808080

7F7F7F808080807F7F7F808080807F7F8080807F7F7F7F8080807F7F7F7F8080807F7F7F7F80

8080807F7F7F8080807F7F7F8080807F7F7F808080807F7F7F808080807F7F7F808080807F7F

7F808080807F7F7F8080807F7F808080807F7E7F808181807F7E7E7F8181817F7E7E7F808180

7F7F7F8080807F7F7F8081817F7D7D7F8283817E7C7C7F8284827E7C7C7F8283827F7D7D8082

817F7D7E8184837E79797F878B867B70707D8D968E7A67657691A19A7E61586C90ABA7865E4D

5F8AB0B49262465381AFBC9E6A454A75A8BEA7754A466B9DB9AC80554A6592B0AB8861526488

A3A48C6D5E6781979B8B766A6E7E8D90887B74767F8687837D7B7D8082817E7D7F8282817E7C

7D808383807D7B7D818383807D7C7E808282807E7E7F8081807F7F7F8080807F7E7F8081807F

7E7E7F8181807F7E7E7F8181807F7F7F808080807F7F8080807F7F7F808080807F7F7F808080

7F7F7F7F8080807F7F7F7F8080807F7F7F8080807F7F808080807F7F7F808080807F7F7F8080

807F7F7F7F8080807F7F7F808080807F808080807F7F808080807F7F7F808080807F7F7F8080

80807F7F7F808080807F7F8080807F7F808080807F7F7F808080807F7F7F808080807F7F7F80

8080807F7F808080807F7F8080807F7F7F808080807F7F7F808080807F7F7F808080807F7F7F

8080807F7F7F8080807F7F7F8080807F7F7F808080807F7F7F808080807F7F7F808080807F7F

7F8080807F7F808080807F7F7F8080807F7F7F7F8080807F7F7F7F8080807F7F7F808080807F

7F8080807F7F7F808081807F7E7F808181807F7E7F808181807F7E7F8080807F7F7F8080807F

7E7F8181817F7D7D808283817E7C7D808383817D7C7D808382807E7E7F81817F7D7E8184837E

79797F878B867A70727F8F948A75676A7F979E8E715D627F9EA8936E545A7DA4B0986C4E547C

A7B59B6C4B517BA8B69C6D4C527AA5B39B6F51577AA0AC9771585E7B9AA3927462667D93998C

776B6F7F8C8F867A7477808787817C7B7E8182807E7E8082817F7D7D7F8283817E7C7D808383

807D7C7E808282807E7E7F8081807F7F7F80807F7F7F808181807E7E7F8081817F7E7E7F8181

807F7E7F808080807F7F7F8080807F7F8080807F7F7F808080807F7F7F808080807F7F7F8080

807F7F7F7F8080807F7F8080807F7F7F8080807F7F7F808080807F7F7F808080807F7F7F8080

80807F7F808080807F808080807F7F808080807F7F7F808080807F7F808080807F7F7F808080

8080808080807F80808080807F7F808080807F7F7F808080807F7F808080807F7F7F80808080

7F808080807F7F808080807F7F7F808080807F7F7F8080807F7F7F808080807F7F8080807F7F

7F8080807F7F7F808080807F7F7F808080807F7F7F8080807F7F7F808080807F7F8080807F7F

7F8080807F7F7F7F8080807F7F7F808080807F7F7F8080807F7F7F8080807F7F808080807F7F

7F808181807E7E7F8081807F7E7E7F8081807F7F7F8080807F7F8080807F7E7E7F8181807E7D

7E808282807D7C7E8183827F7D7D7F8182807E7E8081817F7D7E8184837E79797F878A847971

75828F9184716972889996816861728FA29A7C5F5B7497A99A755859799FAD976E535B7FA4AC

9168536086A6A7896556688BA49F82655E718E9E957D6867798E968C7A6E717E8B8D857A7579

818785807C7B7E8182807E7E8081807E7D7E8182817F7D7D7F8283817E7D7E808282807E7E7F

8181807F7F7F8080807F7F8080807F7E7F808181807F7E7F8081817F7E7E7F8081807F7F7F80

80807F7F7F80807F7F7F8080807F7F7F7F8080807F7F7F808080807F7F7F8080807F7F7F8080

807F7F8080807F7F7F808080807F7F7F8080807F7F7F808080807F7F7F808080807F80808080

7F7F808080807F7F808080807F7F7F808080807F7F80808080807F8080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080807F7F808080

807F7F7F8080807F7F7F808080807F7F7F808080807F7F8080807F7F808080807F7F80808080

7F7F7F808080807F7F7F8080807F7F7F808080807F7F8080807F7F808080807F7F7F8080807F

7F7F808080807F7F7F8080807F7F7F8080807F7F8080807F7F7F808080807F7F7F8081807F7E

7F808181807F7F7F8080807F7F7F8080807F7F8080807F7E7E808181807E7D7F8182817F7D7D

7F8282807E7D7F8081807F7F8081807E7D7E8184827E7A7A80878882787479858E8B7E706F7B

8D958B76686D829799866C62708C9F987D63607896A292725D65839EA087695D6E8DA0987D64

6379939D8E74656C82959584716B7688918B7D72737E888B847B777B8286847F7C7C7F828280

7E7F8080807F7E808181807E7D7F8182817F7D7E808181807E7E7F8081807F7F7F8080807F7F

8080807F7F7F8080807F7F7F808080807F7F7F8080807F7F7F8080807F7F7F8080807F7F8080

807F7F7F808080807F7F7F8080807F7F7F8080807F7F7F808080807F7F8080807F7F80808080

7F7F808080807F7F7F8080807F7F7F808080807F7F7F8080807F7F8080807F7F808080807F7F

7F8080807F7F7F808080807F7F7F808080807F808080808080808080807F80808080807F7F80

8080807F7F7F808080807F7F80808080808080808080808080808080808080808080807F7F80

8080807F7F80808080807F808080808080808080807F7F808080807F7F808080807F7F7F8080

80807F7F808080807F7F808080807F808080807F7F7F8080807F7F7F808080807F7F80808080

7F7F7F8080807F7F8080807F7F7F8080807F7F7F8080807F7F7F808080807F7F7F8080807F7F

7F8080807F7F8080807F7F7F8080807F7E7F8081817F7E7E7F8181807E7E7F8081807F7E7F80

80807F7F8081807F7E7F8183827E7B7C8185858079787D868A857B7477828C8C8073707B8A91

89786D72839291816F6B798D968B766A70849493816E6B798D958A776C7283918F8072707B89

8F87797277828A898078777E8587827C7A7C8184827F7D7D808181807F7F8080807F7F808180

7F7E7F8081817F7E7E7F8181807F7E7F8080807F7F7F8080807F7F8080807F7F7F8080807F7F

7F8080807F7F7F8080807F7F7F808080807F7F808080807F808080807F7F8080807F7F7F8080

80807F7F808080807F7F7F8080807F7F7F8080807F808080807F7F808080807F7F808080807F

7F7F8080807F7F7F808080807F7F80808080808080807F7F808080807F7F7F8080807F7F7F80

8080807F7F808080807F7F8080808080808080807F7F808080807F7F808080807F7F80808080

807F808080808080808080808080808080808080808080807F7F80808080807F808080808080

808080808080808080808080808080807F80808080807F7F80808080807F80808080807F8080

80808080808080807F808080807F7F7F808080807F7F808080807F7F808080807F7F80808080

80808080807F7F808080807F7F808080807F7F7F8080807F7F7F8080807F7F7F8080807F7F80

80807F7F808080807F7F7F8080807F7F7F8080807F7F7F808080807F7F8080807F7F8080807F

7F7F8081807F7E7E8082827F7D7D808383807C7B7E8385827D7A7C8286847F797A7F8586817A

787D8487837C787B8287857F79797F8586817B797D8386837D7A7C8184837F7C7C7F8383807D

7D7F8182817F7E7E8081807F7F7F8080807F7F7F8080807F7F8080807F7F7F8080807F7F7F80

80807F7F7F8080807F7F7F808080807F8080808080808080807F7F808080807F7F808080807F

7F80808080807F80808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

8080808080808080808080808080808080808080808080808080808080808080808080808080

80808080808080808080

pop

% End of sampled sound

% End of Graphics

MathPictureEnd


\
\>"], "Sound",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oo`008@0000000`00
Oomoo`3oOolMOol100000003001oogoo0=Uoo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo
00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo025oo`40000000<007ooOol0dgoo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo0P001Goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo0P0077oo0@0000000`00Oomoo`3=Ool00`00Oomoo`03Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool20004Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool20005Ool00`00
Oomoo`03Ool00`00Oomoo`0DOol100000003001oogoo069oo`8000Eoo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo04Qoo`03001oogoo00=oo`8000Aoo`8000Eoo`03001oogoo00=oo`03001o
ogoo00=oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo00=oo`8000Aoo`8000Eoo`03001oogoo00=o
o`03001oogoo00ioo`40000000<007ooOol0Cgoo0P001Goo00<007ooOol00goo00<007ooOol00goo
0P001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo0P001Goo00<007ooOol0>goo
00<007ooOol00goo0P0017oo0P001Goo00<007ooOol00goo00<007ooOol00goo0P0017oo0P0017oo
0P001Goo00<007ooOol00goo0P0017oo0P0017oo0P001Goo00<007ooOol03Woo0@0000000`00Oomo
o`13Ool00`00Oomoo`03Ool20004Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool20004Ool2
0005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool20004Ool20005Ool00`00Oomoo`03Ool00`00Oomo
o`0SOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool20004Ool20004Ool20005Ool0
0`00Oomoo`03Ool20004Ool20004Ool20005Ool00`00Oomoo`03Ool20004Ool20004Ool20005Ool0
0`00Oomoo`03Ool00`00Oomoo`08Ool100000003001oogoo03Ioo`8000Eoo`03001oogoo00=oo`03
001oogoo00=oo`8000Aoo`8000Eoo`03001oogoo00=oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo
00=oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`8000Eoo`03001oogoo
00moo`8000Aoo`8000Aoo`8000Eoo`8000Aoo`8000Aoo`8000Aoo`8000Eoo`8000Aoo`8000Aoo`80
00Aoo`8000Eoo`8000Aoo`8000Aoo`8000Aoo`8000Eoo`03001oogoo00=oo`8000Uoo`40000000<0
07ooOol0:Woo0P0017oo0P0017oo0P001Goo00<007ooOol00goo00<007ooOol00goo0P0017oo0P00
17oo0P001Goo0P0017oo0P0017oo0P0017oo0P001Goo0P0017oo0P0017oo0P0017oo0P001Goo0P00
17oo0P0017oo0P0017oo0`000goo0`0017oo0P0017oo0P0017oo0P0017oo0`0017oo0P0017oo0P00
17oo0`000goo0`000goo0`0017oo0P0017oo0`000goo0`000goo0`0017oo0P0017oo0P0017oo0`00
17oo0P0017oo0P000goo0@0000000`00Ool0003o000L0001Ool100000003001oogoo01ioo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`8000Aoo`8000Eoo`8000Aoo`8000Ao
o`8000Eoo`03001oogoo00=oo`8000Aoo`8000Aoo`8000Aoo`8000Eoo`8000Aoo`8000Aoo`8000Ao
o`8000Eoo`8000Aoo`8000Aoo`8000Aoo`<000=oo`<000Aoo`8000Aoo`8000Aoo`8000Aoo`<000=o
o`<000Aoo`8000Aoo`<000=oo`<000=oo`<000Aoo`<000=oo`<000=oo`<000=oo`<000Aoo`8000Ao
o`<000=oo`<000Aoo`8000Aoo`8000=oo`40000000<007ooOol0<7oo0P001Goo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo0P0017oo0P001Goo00<007ooOol00goo0P0017oo0P0017oo
0P0017oo0P001Goo0P0017oo0P0017oo0P0017oo0P001Goo00<007ooOol00goo0P0017oo0P002goo
00<007ooOol00goo0P0017oo0P0017oo0P001Goo0P0017oo0P0017oo0P0017oo0P001Goo0P0017oo
0P0017oo0P0017oo0P001Goo0P0017oo0P0017oo0P0017oo0P001Goo00<007ooOol00goo0P002Goo
0@0000000`00Oomoo`0gOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomo
o`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool20004Ool20005Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool20004Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`0ROol20005Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool20004Ool20004Ool20005Ool20004Ool20004Ool20004Ool2
0005Ool00`00Oomoo`03Ool20004Ool20004Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`08Ool1
00000003001oogoo04=oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo
00=oo`03001oogoo00=oo`8000Aoo`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`80
00Eoo`03001oogoo02moo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`8000Aoo`8000Eoo`03
001oogoo00=oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo00=oo`8000Aoo`8000Eoo`03001oogoo
00=oo`03001oogoo00ioo`40000000<007ooOol0EWoo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol017oo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0@Woo00<0
07ooOol00goo00<007ooOol00goo0P001Goo00<007ooOol00goo00<007ooOol00goo0P0017oo0P00
1Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo0P001Goo00<007ooOol00goo00<0
07ooOol03Woo0@0000000`00Oomoo`3<Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool20004Ool20005Ool00`00Oomoo`0D
Ool100000003001oogoo0==oo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`8000Eoo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`8001aoo`40000000<007ooOol0fGoo00<007oo
Ool00goo00<007ooOol00goo0P001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol08Goo
0@0000000`00Oomoo`3VOol00`00Oomoo`03Ool00`00Oomoo`0]Ool100000003001oogoo0?mooaeo
o`400000o`008@0000000`00Oomoo`3oOolMOol100000003001oogoo04=oo`03001oogoo00=oo`03
001oogoo00Aoo`03001oogoo0<Uoo`40000000<007ooOol0@goo00<007ooOol00goo00<007ooOol0
17oo00<007ooOol00goo00<007ooOol0`goo0@0000000`00Oomoo`13Ool00`00Oomoo`0@Ool00`00
Oomoo`33Ool100000003001oogoo03eoo`03001oogoo011oo`03001oogoo00Uoo`03001oogoo0;eo
o`40000000<007ooOol0?Goo00<007ooOol00goo00<007ooOol047oo00<007ooOol00goo00<007oo
Ool0_Goo0@0000000`00Oomoo`13Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`39Ool1
00000003001oogoo03eoo`03001oogoo0=aoo`40000000<007ooOol0?Goo00<007ooOol05Woo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol0]goo0@0000000`00Oomoo`0gOol00`00Oomoo`3R
Ool100000003001oogoo03Moo`03001oogoo01Ioo`03001oogoo00moo`03001oogoo0;Moo`400000
00<007ooOol0?Goo00<007ooOol00goo00<007ooOol05Woo00<007ooOol00goo00<007ooOol0]goo
0@0000000`00Oomoo`0gOol00`00Oomoo`03Ool00`00Oomoo`3LOol100000003001oogoo03Moo`03
001oogoo00moo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo011oo`03001oogoo0;1oo`40
000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`0gOol00`00Oomoo`3ROol100000003001oogoo
031oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo0=aoo`40000000<007ooOol0<7oo00<0
07ooOol0:Goo00<007ooOol047oo00<007ooOol0ZWoo0@0000000`00Oomoo`0`Ool00`00Oomoo`0:
Ool00`00Oomoo`0FOol00`00Oomoo`09Ool00`00Oomoo`04Ool00`00Oomoo`2`Ool100000003001o
ogoo031oo`03001oogoo00=oo`03001oogoo00Yoo`03001oogoo01Ioo`03001oogoo011oo`03001o
ogoo0:Yoo`40000000<007ooOol0<7oo00<007ooOol07Goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol00goo0P001Goo00<007ooOol0/7oo0@0000000`00Oomoo`0gOol00`00Oomoo`0ROol0
0`00Oomoo`2mOol100000003001oogoo031oo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo
00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Yoo`03001oogoo0;1oo`40000000<0
07ooOol0<7oo00<007ooOol00goo00<007ooOol047oo00<007ooOol017oo00<007ooOol00goo00<0
07ooOol047oo00<007ooOol00goo00<007ooOol00goo00<007ooOol0Y7oo0@0000000`00Oomoo`0`
Ool00`00Oomoo`0MOol00`00Oomoo`0@Ool00`00Oomoo`2fOol100000003001oogoo03eoo`03001o
ogoo01Ioo`03001oogoo01Ioo`03001oogoo00=oo`03001oogoo0:Aoo`40000000<007ooOol0:Woo
00<007ooOol02Woo00<007ooOol047oo00<007ooOol00goo00<007ooOol02Goo00<007ooOol017oo
00<007ooOol00goo00<007ooOol00goo00<007ooOol0ZWoo0@0000000`00Oomoo`0ZOol00`00Oomo
o`03Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool00`00Oomoo`09Ool00`00Oomoo`03Ool00`00Oomo
o`0FOol00`00Oomoo`2TOol100000003001oogoo02Yoo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo015oo`03001oogoo00=oo`03001oogoo0<Uoo`40000000<007ooOol0:Woo00<007ooOol0
47oo00<007ooOol02Woo00<007ooOol077oo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol0WWoo0@0000000`00Oomoo`0ZOol00`00Oomoo`0_Ool00`00Oomoo`0FOol00`00
Oomoo`2TOol100000003001oogoo05Ioo`03001oogoo00Uoo`03001oogoo0;Moo`40000000<007oo
Ool0:Woo00<007ooOol00goo00<007ooOol05Woo0P005goo0P001Goo00<007ooOol03goo00<007oo
Ool0WWoo0@0000000`00Oomoo`0ZOol00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`04Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0FOol00`00Oomoo`09Ool0
0`00Oomoo`2NOol100000003001oogoo02Yoo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo
00Uoo`03001oogoo029oo`03001oogoo0:Aoo`40000000<007ooOol0A7oo00<007ooOol00Woo00<0
07ooOol02Woo00<007ooOol00goo00<007ooOol047oo00<007ooOol02Woo00<007ooOol0KGoo00<0
07ooOol0;Goo0@0000000`00Oomoo`0ZOol00`00Oomoo`03Ool00`00Oomoo`0:Ool00`00Oomoo`03
Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0F
Ool00`00Oomoo`1DOol00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`0cOol100000003001o
ogoo04=oo`03001oogoo011oo`03001oogoo08eoo`03001oogoo00=oo`03001oogoo02eoo`400000
00<007ooOol097oo00<007ooOol00goo00<007ooOol05goo00<007ooOol00goo00<007ooOol03goo
00<007ooOol02Goo00<007ooOol017oo00<007ooOol00goo00<007ooOol0Fgoo00<007ooOol02Goo
00<007ooOol00goo00<007ooOol017oo00<007ooOol00goo00<007ooOol09goo0@0000000`00Oomo
o`0TOol00`00Oomoo`09Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool00`00Oomoo`0EOol00`00Oomo
o`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0:Ool00`00Oomoo`1DOol00`00Oomo
o`03Ool00`00Oomoo`04Ool00`00Oomoo`09Ool00`00Oomoo`0WOol100000003001oogoo02Aoo`03
001oogoo00=oo`03001oogoo00Uoo`03001oogoo04=oo`03001oogoo00=oo`03001oogoo04ioo`03
001oogoo011oo`03001oogoo03=oo`40000000<007ooOol097oo00<007ooOol00goo00<007ooOol0
2Woo00<007ooOol02Goo00<007ooOol08Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol0
17oo00<007ooOol00goo00<007ooOol0B7oo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
17oo00<007ooOol02Goo00<007ooOol00goo00<007ooOol09goo0@0000000`00Oomoo`0TOol00`00
Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`04Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00
Oomoo`03Ool00`00Oomoo`0FOol00`00Oomoo`1WOol00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00
Oomoo`0QOol100000003001oogoo02Aoo`03001oogoo00=oo`03001oogoo011oo`03001oogoo01ao
o`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Yoo`03001oogoo011oo`03001oogoo049o
o`03001oogoo01Eoo`03001oogoo03Aoo`40000000<007ooOol097oo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Woo00<007oo
Ool00goo00<007ooOol02Goo00<007ooOol0E7oo0P001Goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol02Woo00<007ooOol0;Goo0@0000000`00Oomoo`0TOol00`00Oomoo`0FOol00`00Oomo
o`0:Ool00`00Oomoo`09Ool00`00Oomoo`0FOol00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomo
o`0kOol00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0:Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`0JOol100000003001oogoo02Aoo`03
001oogoo00=oo`03001oogoo00Uoo`03001oogoo02=oo`03001oogoo00Uoo`03001oogoo01Ioo`03
001oogoo00Aoo`03001oogoo07Aoo`03001oogoo01Yoo`40000000<007ooOol097oo00<007ooOol0
0goo00<007ooOol047oo00<007ooOol00goo0P002goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol02Woo00<007ooOol00goo00<007ooOol00goo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol0>goo00<007ooOol017oo00<007ooOol03goo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol06goo0@00
00000`00Oomoo`0TOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`0K
Ool2000;Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00
Oomoo`0kOol00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00
Oomoo`0iOol100000003001oogoo02Aoo`03001oogoo01Ioo`03001oogoo00Uoo`03001oogoo00Ao
o`03001oogoo00moo`8000Eoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo03]oo`03001o
ogoo00=oo`8000Aoo`8000Eoo`03001oogoo00=oo`03001oogoo011oo`03001oogoo00=oo`03001o
ogoo00Aoo`03001oogoo00=oo`03001oogoo01Yoo`40000000<007ooOol097oo00<007ooOol05Woo
00<007ooOol0=Goo00<007ooOol047oo00<007ooOol0CWoo00<007ooOol077oo00<007ooOol02Woo
00<007ooOol057oo0@0000000`00Oomoo`0MOol00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomo
o`0FOol2000;Ool00`00Oomoo`02Ool00`00Oomoo`0AOol00`00Oomoo`03Ool00`00Oomoo`0:Ool0
0`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0_Ool00`00Oomoo`0@Ool0
0`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0KOol100000003001oogoo01eoo`03001oogoo
00Aoo`03001oogoo00Uoo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00Yoo`03001oogoo
009oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00Uoo`8000Eoo`03001oogoo00Aoo`03
001oogoo00=oo`03001oogoo00Uoo`03001oogoo00=oo`03001oogoo049oo`03001oogoo01Ioo`03
001oogoo00=oo`03001oogoo00Yoo`03001oogoo00=oo`03001oogoo01Aoo`40000000<007ooOol0
7Goo00<007ooOol07Goo00<007ooOol0;goo00<007ooOol02Woo00<007ooOol03goo00<007ooOol0
?7oo00<007ooOol02Goo00<007ooOol00goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol0
17oo00<007ooOol00goo00<007ooOol057oo0@0000000`00Oomoo`0MOol20005Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`09
Ool2000AOol00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool20005Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0YOol00`00Oomoo`03Ool00`00Oomoo`03
Ool20004Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`0EOol00`00Oomoo`04Ool00`00
Oomoo`0DOol100000003001oogoo01eoo`8000Aoo`8000Eoo`03001oogoo00Yoo`03001oogoo00=o
o`03001oogoo00Yoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo015oo`03001oogoo00=o
o`03001oogoo00Uoo`03001oogoo011oo`03001oogoo02Uoo`03001oogoo00Uoo`03001oogoo00=o
o`8000Aoo`8000Eoo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo009oo`8000Eoo`03001o
ogoo011oo`03001oogoo01Aoo`40000000<007ooOol07Goo00<007ooOol02Woo00<007ooOol0:Goo
00<007ooOol08Woo00<007ooOol02Woo00<007ooOol0;goo00<007ooOol00goo00<007ooOol017oo
00<007ooOol03goo00<007ooOol02Goo0P002goo00<007ooOol02Goo00<007ooOol02Woo00<007oo
Ool03Woo0@0000000`00Oomoo`0MOol20004Ool2000;Ool00`00Oomoo`04Ool00`00Oomoo`09Ool2
0004Ool00`00Oomoo`03Ool00`00Oomoo`0AOol00`00Oomoo`03Ool00`00Oomoo`09Ool20004Ool0
0`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0YOol00`00Oomoo`03Ool0
0`00Oomoo`03Ool20004Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool20004Ool2
000AOol20005Ool00`00Oomoo`03Ool00`00Oomoo`0DOol100000003001oogoo01eoo`8000Aoo`03
001oogoo00Aoo`03001oogoo00Uoo`8000Eoo`03001oogoo00moo`03001oogoo00Aoo`03001oogoo
00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Yoo`03001oogoo
00Uoo`03001oogoo00=oo`03001oogoo00=oo`8002Yoo`03001oogoo00Uoo`8000]oo`03001oogoo
00=oo`8000Aoo`03001oogoo011oo`8000]oo`03001oogoo00=oo`03001oogoo00ioo`40000000<0
07ooOol07Goo00<007ooOol0@goo00<007ooOol047oo00<007ooOol00goo00<007ooOol00Woo0P00
2goo00<007ooOol0;goo00<007ooOol02Woo00<007ooOol047oo00<007ooOol00goo00<007ooOol0
2Goo00<007ooOol00goo00<007ooOol00goo0P002goo00<007ooOol03Woo0@0000000`00Oomoo`0M
Ool20004Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`09
Ool20005Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`0@Ool00`00Oomoo`0:Ool00`00
Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`0MOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool20005Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool20004
Ool2000<Ool00`00Oomoo`0?Ool00`00Oomoo`0>Ool100000003001oogoo01eoo`8000Aoo`03001o
ogoo00Aoo`03001oogoo00=oo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00=oo`03001o
ogoo00Yoo`03001oogoo00=oo`8000Eoo`03001oogoo01Eoo`8000Eoo`03001oogoo00Uoo`8001eo
o`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo00=o
o`8000Eoo`03001oogoo00moo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo00ioo`40000000<007ooOol05goo00<007ooOol00goo00<007ooOol05goo00<007ooOol00goo
00<007ooOol017oo00<007ooOol077oo00<007ooOol05Goo00<007ooOol00goo00<007ooOol00goo
0P001Goo00<007ooOol08goo00<007ooOol00goo00<007ooOol02Goo00<007ooOol02Woo00<007oo
Ool02Goo00<007ooOol02Woo00<007ooOol00goo00<007ooOol00goo0P0017oo00<007ooOol017oo
00<007ooOol057oo0@0000000`00Oomoo`0GOol00`00Oomoo`03Ool20004Ool20005Ool00`00Oomo
o`0:Ool00`00Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`0AOol00`00Oomoo`08Ool00`00Oomo
o`04Ool00`00Oomoo`09Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomo
o`03Ool20005Ool00`00Oomoo`0EOol20005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool20005Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`04Ool0
0`00Oomoo`03Ool2000@Ool20005Ool00`00Oomoo`0>Ool100000003001oogoo01Moo`03001oogoo
00=oo`8000Aoo`03001oogoo00Yoo`03001oogoo00=oo`8000]oo`03001oogoo00=oo`03001oogoo
00=oo`8000Eoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00Uoo`03001oogoo00=oo`80
00Aoo`03001oogoo00=oo`03001oogoo00=oo`8000Eoo`03001oogoo00=oo`03001oogoo00Aoo`03
001oogoo00moo`03001oogoo00=oo`8000]oo`03001oogoo00Uoo`8000Eoo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo00Uoo`8000Eoo`03001oogoo00=oo`8000Aoo`8000]oo`03001oogoo
00=oo`03001oogoo00Qoo`40000000<007ooOol05goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol017oo00<007ooOol047oo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol017oo00<0
07ooOol05Woo0P005goo00<007ooOol00goo00<007ooOol017oo00<007ooOol05Woo00<007ooOol0
0Woo0P005goo00<007ooOol02Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol02Goo00<0
07ooOol00goo0P002goo00<007ooOol00goo00<007ooOol027oo0@0000000`00Oomoo`0GOol00`00
Oomoo`03Ool20004Ool2000<Ool00`00Oomoo`03Ool00`00Oomoo`0?Ool00`00Oomoo`0:Ool00`00
Oomoo`03Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`03
Ool20005Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`03Ool20004Ool2000AOol00`00Oomoo`03
Ool20004Ool20005Ool20004Ool20004Ool2000;Ool20004Ool20005Ool00`00Oomoo`02Ool20005
Ool20005Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`08
Ool100000003001oogoo01Moo`03001oogoo00=oo`8000Aoo`03001oogoo00Aoo`03001oogoo00Ao
o`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo009o
o`8000Eoo`03001oogoo00Uoo`8000Eoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo00Ao
o`03001oogoo00=oo`03001oogoo009oo`8000Eoo`8000Aoo`03001oogoo00=oo`8000Eoo`03001o
ogoo00=oo`03001oogoo00=oo`8000Aoo`8000Eoo`03001oogoo00Aoo`03001oogoo009oo`8000Ao
o`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`8000]oo`03001oogoo00=oo`8000Uoo`400000
00<007ooOol05goo00<007ooOol00goo00<007ooOol00goo00<007ooOol02Woo0P001Goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol017oo00<007oo
Ool00goo0P002goo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol00goo00<007ooOol017oo
00<007ooOol00goo0P001Goo00<007ooOol00goo00<007ooOol02Goo00<007ooOol00goo00<007oo
Ool02Woo00<007ooOol00goo0P0017oo00<007ooOol04Goo00<007ooOol03Woo00<007ooOol017oo
00<007ooOol02Goo0P0017oo0P001Goo00<007ooOol03Woo0@0000000`00Oomoo`0GOol00`00Oomo
o`03Ool20004Ool20005Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`09Ool00`00Oomo
o`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool20004Ool2000;Ool00`00Oomoo`02Ool20005Ool0
0`00Oomoo`09Ool20005Ool00`00Oomoo`04Ool00`00Oomoo`02Ool20004Ool20005Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool20004Ool20004Ool20005Ool00`00Oomoo`0:Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0FOol00`00Oomoo`03Ool2
0005Ool00`00Oomoo`03Ool20009Ool100000003001oogoo015oo`03001oogoo00=oo`03001oogoo
00=oo`8000Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo00Aoo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo00Uoo`03001oo`0000Eoo`03001oogoo009oo`80
00Aoo`03001oogoo00Yoo`03001oogoo00=oo`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`80
00Aoo`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`8000Aoo`80
00Eoo`03001oogoo00=oo`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`8000]oo`03
001oogoo00=oo`8000Aoo`8000Aoo`8000Aoo`8000Eoo`03001oogoo00=oo`03001oogoo00Qoo`40
000000<007ooOol047oo0P001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol02Woo0P00
1Goo00<007ooOol00goo00<007ooOol00Woo0P001Goo00<007ooOol00goo0P001Goo00<007ooOol0
0goo00<007ooOol017oo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
3goo0P001Goo0P0017oo00<007ooOol00goo0P001Goo00<007ooOol00goo00<007ooOol017oo00<0
07ooOol00Woo00<007ooOol00goo0P001Goo0P0017oo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol04Goo00<007ooOol00Woo0P001Goo00<007ooOol00goo0P004Goo00<007ooOol00goo00<0
07ooOol027oo0@0000000`00Oomoo`0@Ool20004Ool20004Ool30004Ool20004Ool20006Ool00`00
Oomoo`03Ool20009Ool30005Ool00`00Oomoo`03Ool20003Ool00`00Ool00003Ool00`00Ool00004
Ool20004Ool20004Ool20006Ool00`00Oomoo`02Ool20004Ool20004Ool00`00Oomoo`04Ool00`00
Oomoo`03Ool20004Ool20004Ool30003Ool20005Ool20004Ool20004Ool20005Ool20004Ool00`00
Oomoo`03Ool20004Ool20005Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`0@Ool00`00Oomoo`09Ool20004Ool20004Ool20003Ool100000003001oogoo011oo`8000Ao
o`8000Aoo`03001oogoo00Aoo`03001oogoo00=oo`8000Ioo`03001oogoo00=oo`8000=oo`8000Ao
o`8000Eoo`8000Aoo`<000=oo`<000=oo`03001oo`0000Aoo`8000Aoo`<000=oo`<000=oo`<000Ao
o`8000Aoo`8000Aoo`8000Eoo`03001oogoo00=oo`8000Aoo`8000Aoo`<000=oo`<000Aoo`8000Ao
o`8000Aoo`8000Aoo`03001oo`0000Aoo`8000Aoo`8000Aoo`8000Eoo`8000Aoo`8000Aoo`8000Ao
o`8000Aoo`03001oogoo00Aoo`03001oogoo00=oo`8000Aoo`8000Eoo`03001oogoo00=oo`8000Ao
o`8000=oo`40000000<007ooOol02Woo00<007ooOol00goo0P0017oo0P0017oo00<007oo00000goo
0P001Goo0P001Goo0`0017oo0P000goo0P0017oo0`000goo0`0017oo0`000goo0`000goo00<007oo
000017oo0`000Woo10000goo0`000goo0`000goo0`0017oo0P0017oo0`000goo0`0017oo0P0017oo
0P0017oo0`000goo0`0017oo0P0017oo0P0017oo0`000goo0`000goo0`0017oo0`000goo0`000goo
00<007oo00000goo0`0017oo0`000goo0`000goo0`000goo0`0017oo0P0017oo0P001Goo0P0017oo
0P0017oo0P000goo0@0000000`00Oomoo`0:Ool20004Ool20003Ool30003Ool20005Ool00`00Ool0
0003Ool30005Ool30003Ool30003Ool40002Ool40002Ool00`00Ool00003Ool40002Ool40002Ool2
00000goo00000002Ool40002Ool40003Ool30003Ool00`00Ool00003Ool30004Ool30003Ool00`00
Ool00003Ool00`00Ool00003Ool30003Ool40003Ool30003Ool30003Ool40002Ool40003Ool30003
Ool30003Ool30004Ool30003Ool30003Ool30003Ool40002Ool40002Ool40003Ool00`00Ool00003
Ool30004Ool20004Ool30003Ool30004Ool20004Ool20003Ool100000003001oogoo00=oo`<0009o
o`@0009oo`@0009oo`800003Ool007oo009oo`04001oogoo0002Ool20004Ool500000goo00000007
00000goo0000000:00000goo0000000@00000goo0000000300000goo0000000@00000goo0000002X
0002Ool100000003001oo`0000@00003Ool000000080009oo`04001oo`000002Ool01000Ool00000
0Woo00<007ooOol00P000Woo00@007oo000000Aoo`8000=oo``00003Ool0000001`00003Ool00000
01H00003Ool0000001`00003Ool0000006400003Ool0000002H0005oo`40000000<007ooOol02goo
0`000goo00<007oo00001Woo00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo0P000Woo
0P0017oo0P0000Aoo`00Oomoo`800003Ool007oo009oo`@0009oo`04001oo`000002Ool200000goo
001oo`02Ool30003Ool30003Ool40002Ool40002Ool200000goo001oo`02Ool01000Ool000000Woo
10000goo0`000goo0`000goo0`000goo10000Woo0P0000=oo`00Ool00Woo0`000goo0`000goo1000
0Woo10000goo0`000goo00<007oo00000goo0`0017oo0`000goo0`000goo00<007oo00000goo1000
0Woo10000goo0`000goo00<007oo00000goo0`0017oo0`000goo0`000goo0`0017oo0P0017oo0P00
0goo0@0000000`00Oomoo`0;Ool20004Ool30003Ool40003Ool30003Ool30004Ool20002Ool20005
Ool00`00Ool00003Ool00`00Ool00003Ool00`00Ool00003Ool40003Ool30003Ool00`00Ool00003
Ool30003Ool30003Ool40003Ool00`00Ool00003Ool30003Ool30004Ool30003Ool30003Ool30004
Ool20004Ool20004Ool30003Ool30004Ool20004Ool20004Ool30003Ool30003Ool30004Ool20004
Ool30003Ool30003Ool30004Ool30003Ool30003Ool30003Ool30004Ool20004Ool00`00Ool00003
Ool30004Ool20004Ool20003Ool100000003001oogoo015oo`8000Eoo`8000Eoo`03001oogoo00=o
o`03001oogoo009oo`8000Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oo`0000Eoo`04001o
ogooOol30004Ool30003Ool00`00Ool00004Ool20003Ool30004Ool30003Ool30003Ool30003Ool3
0004Ool20005Ool20004Ool20004Ool20004Ool20004Ool30003Ool30004Ool20004Ool20004Ool2
0005Ool20004Ool20004Ool20004Ool20004Ool30003Ool30004Ool20004Ool20005Ool00`00Oomo
o`03Ool20004Ool20005Ool00`00Oomoo`03Ool20004Ool20004Ool20003Ool100000003001oogoo
015oo`8000Eoo`03001oogoo00=oo`8000Eoo`03001oogoo00=oo`03001oogoo009oo`8000Aoo`03
001oogoo00Eoo`03001oogoo009oo`8000=oo`8000Eoo`8000Ioo`03001oogoo00=oo`04001oogoo
Ool20005Ool2000;Ool00`00Oomoo`03Ool20005Ool00`00Oomoo`02Ool30005Ool00`00Oomoo`02
Ool20004Ool20004Ool00`00Ool00004Ool20004Ool00`00Oomoo`04Ool00`00Oomoo`0?Ool20004
Ool00`00Oomoo`04Ool00`00Oomoo`0?Ool20004Ool00`00Oomoo`04Ool20004Ool20004Ool20004
Ool20005Ool00`00Oomoo`04Ool00`00Oomoo`02Ool20003Ool100000003001oogoo015oo`8000Eo
o`03001oogoo00=oo`8000Aoo`8000Eoo`03001oogoo009oo`03001oogoo00=oo`8000Aoo`8000Eo
o`8000Aoo`8000Aoo`8000Aoo`<000Aoo`8000Aoo`03001oogoo00=oo`8000Eoo`03001oogoo00=o
o`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`8000Eoo`8000Aoo`8000Aoo`8000Eo
o`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`8000Aoo`8000Eoo`8000Aoo`8000Aoo`8000Ao
o`03001oogoo00Aoo`03001oogoo00=oo`8000Aoo`03001oogoo00Yoo`8000Eoo`03001oogoo00Qo
o`8000Eoo`03001oogoo00=oo`8000Uoo`40000000<007ooOol04Woo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol017oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool02goo00<007ooOol027oo00<007ooOol00goo0P001Goo00<007ooOol02Woo00<007ooOol00Woo
0P001Goo0P0017oo00<007ooOol00goo0P001Goo00<007ooOol00goo00<007ooOol017oo00<007oo
Ool00Woo0P001Goo00<007ooOol00goo00<007ooOol00goo0P0017oo0P0017oo0P001Goo00<007oo
Ool00goo00<007ooOol00goo0P001Goo00<007ooOol017oo00<007ooOol027oo0P0017oo0P001Goo
00<007ooOol00goo0P0017oo00<007ooOol00goo0P001Goo00<007ooOol00goo0P002Goo0@000000
0`00Oomoo`0BOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`08Ool0
0`00Oomoo`03Ool00`00Oomoo`0;Ool00`00Oomoo`03Ool00`00Oomoo`08Ool00`00Oomoo`04Ool0
0`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`08Ool2
0004Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool20005Ool00`00Oomoo`03Ool2000;Ool00`00Oomoo`09Ool0
0`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`09Ool20005Ool00`00Oomoo`03Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`08Ool100000003001oogoo019oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`8000Aoo`8000Aoo`8000Aoo`80
00Eoo`8000Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`80
00Eoo`03001oogoo00Uoo`03001oogoo00=oo`8000Yoo`8000Eoo`03001oogoo00=oo`8000Aoo`80
00]oo`03001oogoo00=oo`8000Aoo`8000Aoo`8000Eoo`8000Aoo`8000Aoo`8000Aoo`8000Eoo`80
00Aoo`8000Eoo`03001oogoo00=oo`03001oogoo00Uoo`8000Aoo`03001oogoo00Aoo`03001oogoo
00=oo`03001oogoo00=oo`03001oogoo00Qoo`40000000<007ooOol067oo00<007ooOol00goo00<0
07ooOol017oo00<007ooOol03Woo00<007ooOol02goo00<007ooOol00goo00<007ooOol03goo0P00
2Woo0P001Goo00<007ooOol017oo00<007ooOol00goo00<007ooOol00goo00<007ooOol02Goo0P00
17oo0P0017oo0P001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo0P0017oo0P00
1Goo00<007ooOol00goo0P0017oo0P0017oo0P001Goo00<007ooOol00goo00<007ooOol02Woo00<0
07ooOol00goo0P0017oo0P0017oo0P0017oo0P002goo0P002Goo0@0000000`00Oomoo`0HOol00`00
Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`08Ool00`00Oomoo`03Ool00`00
Oomoo`0SOol00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`0:Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0?Ool20004Ool00`00Oomoo`0FOol00`00Oomoo`04
Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`03
Ool00`00Oomoo`09Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`08Ool100000003001oogoo01Qo
o`03001oogoo00=oo`03001oogoo00=oo`8000]oo`03001oogoo009oo`8000Eoo`03001oogoo00=o
o`03001oogoo00Aoo`03001oogoo00Uoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo011o
o`8000Aoo`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`8000Aoo`8000Aoo`80015oo`8000Ao
o`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`8000Eoo`03001oogoo00Uoo`03001oogoo00=o
o`03001oogoo00=oo`03001oogoo00=oo`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`8000]o
o`03001oogoo00=oo`03001oogoo00Qoo`40000000<007ooOol067oo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol017oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol05goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo0P0017oo0P0017oo0P001Woo00<007ooOol00Woo
00<007ooOol00goo00<007ooOol017oo00<007ooOol00goo0P0017oo00<007ooOol017oo00<007oo
Ool03goo00<007ooOol00goo0P001Goo00<007ooOol00goo00<007ooOol017oo00<007ooOol00Woo
00<007ooOol02goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol017oo
00<007ooOol02Goo00<007ooOol017oo00<007ooOol00goo00<007ooOol00goo00<007ooOol027oo
0@0000000`00Oomoo`0HOol00`00Oomoo`03Ool00`00Oomoo`09Ool00`00Oomoo`0?Ool00`00Oomo
o`04Ool00`00Oomoo`04Ool00`00Oomoo`0KOol00`00Oomoo`0AOol00`00Oomoo`03Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool20004Ool20005Ool00`00Oomoo`0LOol00`00Oomoo`03Ool00`00Oomo
o`03Ool2000;Ool00`00Oomoo`09Ool00`00Oomoo`04Ool00`00Oomoo`09Ool00`00Oomoo`03Ool0
0`00Oomoo`09Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`08Ool100000003001oogoo01Qoo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo00moo`03001oogoo00Aoo`03001oogoo00=oo`03
001oogoo00Aoo`03001oogoo009oo`03001oogoo011oo`03001oogoo00Yoo`03001oogoo00=oo`03
001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo01aoo`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Uoo`03001oogoo
00Eoo`03001oogoo009oo`8001Qoo`03001oogoo009oo`8000Eoo`03001oogoo00=oo`03001oogoo
00ioo`40000000<007ooOol067oo00<007ooOol00goo00<007ooOol00goo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol00Woo00<007ooOol047oo0P0017oo0P004Goo00<007ooOol00goo00<0
07ooOol017oo00<007ooOol00goo00<007ooOol00goo00<007ooOol017oo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol017oo00<007ooOol077oo00<007ooOol02Goo00<007ooOol017oo00<0
07ooOol00Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol00goo0P001Goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00goo00<007ooOol017oo00<007ooOol00Woo0P001Goo00<0
07ooOol03Woo0@0000000`00Oomoo`0HOol00`00Oomoo`0QOol00`00Oomoo`04Ool00`00Oomoo`03
Ool2000;Ool00`00Oomoo`09Ool00`00Oomoo`0@Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00
Oomoo`04Ool00`00Oomoo`0LOol00`00Oomoo`03Ool00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool2000AOol00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`02
Ool2000LOol100000003001oogoo01ioo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00Qo
o`80015oo`80015oo`8000Aoo`03001oogoo00=oo`03001oogoo00=oo`8000Eoo`03001oogoo00=o
o`8000Eoo`03001oogoo00Uoo`03001oogoo00=oo`03001oogoo01eoo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001o
ogoo00=oo`8000Eoo`03001oogoo00=oo`03001oogoo00Uoo`03001oogoo00Aoo`03001oogoo00Uo
o`03001oogoo00ioo`40000000<007ooOol07Woo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool02Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<007oo
Ool02Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol017oo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol08goo00<007ooOol00goo00<007ooOol00goo00<007ooOol017oo00<007oo
Ool05Woo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool017oo00<007ooOol00goo00<007ooOol03Woo0@0000000`00Oomoo`0NOol00`00Oomoo`03Ool0
0`00Oomoo`09Ool20004Ool00`00Oomoo`03Ool20005Ool00`00Oomoo`0:Ool00`00Oomoo`03Ool0
0`00Oomoo`0:Ool00`00Oomoo`0?Ool00`00Oomoo`09Ool00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool2
000;Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`09Ool00`00Oomoo`0>Ool100000003
001oogoo02]oo`03001oogoo00Qoo`03001oogoo01Moo`03001oogoo011oo`03001oogoo009oo`03
001oogoo00Aoo`03001oogoo01Ioo`03001oogoo02moo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo00Yoo`03001oogoo00moo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo011oo`03
001oogoo00=oo`03001oogoo00ioo`40000000<007ooOol07Woo00<007ooOol00goo00<007ooOol0
5Woo00<007ooOol047oo00<007ooOol00goo00<007ooOol03goo0P0017oo00<007ooOol017oo00<0
07ooOol047oo00<007ooOol00goo00<007ooOol0:Goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol017oo00<007ooOol00goo00<007ooOol017oo00<007ooOol00Woo0P00
17oo00<007ooOol02goo00<007ooOol00Woo0P001Goo00<007ooOol057oo0@0000000`00Oomoo`0N
Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0?Ool20005Ool00`00Oomoo`03Ool00`00
Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool20004Ool00`00Oomoo`04
Ool00`00Oomoo`0eOol00`00Oomoo`03Ool20004Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00
Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`0DOol10000
0003001oogoo01ioo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo025oo`8000aoo`03001o
ogoo00ioo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo011oo`03001oogoo03Ioo`03001o
ogoo00moo`03001oogoo011oo`03001oogoo00Uoo`03001oogoo00=oo`03001oogoo00Aoo`03001o
ogoo01Aoo`40000000<007ooOol07Woo00<007ooOol047oo00<007ooOol00goo00<007ooOol00goo
00<007ooOol047oo00<007ooOol00goo00<007ooOol05Woo00<007ooOol00goo00<007ooOol00goo
00<007ooOol047oo00<007ooOol0?7oo00<007ooOol02Goo00<007ooOol017oo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo0P001Goo00<007oo
Ool057oo0@0000000`00Oomoo`0NOol00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`02Ool0
0`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`0AOol00`00Oomoo`03Ool00`00Oomoo`03Ool2
0004Ool00`00Oomoo`0:Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomo
o`0_Ool00`00Oomoo`03Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`04Ool00`00Oomo
o`03Ool00`00Oomoo`09Ool2000ROol100000003001oogoo01ioo`03001oogoo00=oo`03001oogoo
029oo`03001oogoo011oo`03001oogoo00Aoo`03001oogoo06Moo`03001oogoo01aoo`03001oogoo
00Uoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo01Aoo`40000000<007ooOol07Woo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol047oo00<007ooOol00goo00<007ooOol017oo00<0
07ooOol00Woo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo0P001Goo00<007ooOol00goo00<007ooOol0=Goo00<007ooOol00goo00<007ooOol0
0goo0P001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol02Woo00<007ooOol05Woo00<0
07ooOol057oo0@0000000`00Oomoo`0TOol00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0E
Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`09Ool00`00Oomoo`0:
Ool00`00Oomoo`11Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`04
Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool20004Ool00`00Oomoo`0KOol100000003001oogoo02Ao
o`03001oogoo02moo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo01Mo
o`03001oogoo00=oo`03001oogoo03]oo`03001oogoo00=oo`03001oogoo01eoo`03001oogoo02eo
o`40000000<007ooOol097oo00<007ooOol047oo00<007ooOol00goo00<007ooOol05Woo00<007oo
Ool08goo00<007ooOol00goo00<007ooOol0B7oo00<007ooOol00goo00<007ooOol03goo00<007oo
Ool017oo00<007ooOol00goo00<007ooOol02Woo00<007ooOol06Woo0@0000000`00Oomoo`0TOol0
0`00Oomoo`03Ool20005Ool00`00Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomo
o`0:Ool00`00Oomoo`03Ool2000;Ool00`00Oomoo`03Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool0
0`00Oomoo`0kOol00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0KOol100000003001oogoo03eoo`03001oogoo
00moo`03001oogoo01eoo`03001oogoo00=oo`03001oogoo00Uoo`03001oogoo00Aoo`03001oogoo
03]oo`03001oogoo01Moo`03001oogoo00moo`03001oogoo00Yoo`03001oogoo01Yoo`40000000<0
07ooOol097oo00<007ooOol02Woo00<007ooOol03goo00<007ooOol02Woo00<007ooOol02Woo00<0
07ooOol03goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol0@Woo00<007ooOol00goo00<0
07ooOol02Goo00<007ooOol017oo00<007ooOol0<goo0@0000000`00Oomoo`0TOol00`00Oomoo`03
Ool2000;Ool00`00Oomoo`0SOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool2001?Ool00`00Oomoo`04Ool00`00Oomoo`09Ool00`00Oomoo`04
Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0QOol100000003001o
ogoo02Aoo`03001oogoo029oo`03001oogoo00Yoo`03001oogoo00Aoo`03001oogoo009oo`8007Eo
o`03001oogoo00=oo`03001oogoo00Yoo`03001oogoo02eoo`40000000<007ooOol097oo00<007oo
Ool077oo00<007ooOol02Woo00<007ooOol05Woo00<007ooOol02Goo00<007ooOol00goo00<007oo
Ool017oo00<007ooOol0B7oo00<007ooOol0:7oo00<007ooOol08Goo0@0000000`00Oomoo`0TOol0
0`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`09Ool00`00Oomoo`0MOol0
0`00Oomoo`0?Ool00`00Oomoo`03Ool00`00Oomoo`03Ool2001@Ool00`00Oomoo`03Ool00`00Oomo
o`09Ool00`00Oomoo`04Ool00`00Oomoo`09Ool00`00Oomoo`0QOol100000003001oogoo02Aoo`03
001oogoo00=oo`03001oogoo029oo`03001oogoo01Moo`03001oogoo00=oo`03001oogoo06Moo`03
001oogoo00=oo`03001oogoo011oo`03001oogoo02Moo`40000000<007ooOol097oo00<007ooOol0
5Woo00<007ooOol00goo00<007ooOol05Woo00<007ooOol00goo00<007ooOol017oo00<007ooOol0
Igoo00<007ooOol00goo00<007ooOol00goo00<007ooOol017oo00<007ooOol00goo00<007ooOol0
;Goo0@0000000`00Oomoo`0[Ool00`00Oomoo`0EOol00`00Oomoo`03Ool20004Ool00`00Oomoo`04
Ool00`00Oomoo`0YOol00`00Oomoo`1JOol00`00Oomoo`03Ool20005Ool00`00Oomoo`03Ool00`00
Oomoo`0WOol100000003001oogoo02Yoo`03001oogoo01Ioo`03001oogoo03Eoo`03001oogoo05]o
o`03001oogoo011oo`03001oogoo02eoo`40000000<007ooOol0:goo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol047oo00<007oo
Ool02Goo00<007ooOol047oo00<007ooOol0WWoo0@0000000`00Oomoo`0aOol00`00Oomoo`03Ool0
0`00Oomoo`0LOol00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`2ZOol100000003001oogoo
02Yoo`03001oogoo01aoo`03001oogoo011oo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo
00=oo`03001oogoo09ioo`40000000<007ooOol0BGoo00<007ooOol02Woo00<007ooOol077oo00<0
07ooOol0Y7oo0@0000000`00Oomoo`0ZOol00`00Oomoo`04Ool00`00Oomoo`0EOol00`00Oomoo`03
Ool2000AOol00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`2TOol100000003001oogoo035o
o`03001oogoo00Uoo`03001oogoo00=oo`03001oogoo011oo`03001oogoo00moo`8000Eoo`03001o
ogoo00=oo`03001oogoo00=oo`03001oogoo09ioo`40000000<007ooOol0:Woo00<007ooOol02Woo
00<007ooOol03goo00<007ooOol0d7oo0@0000000`00Oomoo`0ZOol00`00Oomoo`04Ool00`00Oomo
o`03Ool00`00Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`2mOol100000003
001oogoo02Yoo`03001oogoo011oo`03001oogoo011oo`03001oogoo00Uoo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo00Aoo`03001oogoo0:Yoo`40000000<007ooOol0:Woo00<007ooOol0
7Goo00<007ooOol00Woo00<007ooOol0bWoo0@0000000`00Oomoo`0aOol00`00Oomoo`0ROol00`00
Oomoo`0FOol00`00Oomoo`03Ool00`00Oomoo`2TOol100000003001oogoo035oo`03001oogoo01]o
o`03001oogoo00Aoo`03001oogoo00Uoo`03001oogoo00=oo`03001oogoo0;5oo`40000000<007oo
Ool0=goo00<007ooOol00goo00<007ooOol03goo00<007ooOol017oo00<007ooOol0`goo0@000000
0`00Oomoo`0aOol00`00Oomoo`0XOol00`00Oomoo`09Ool00`00Oomoo`04Ool00`00Oomoo`2ZOol1
00000003001oogoo04=oo`03001oogoo00=oo`03001oogoo00Yoo`03001oogoo00=oo`03001oogoo
00=oo`8000Eoo`03001oogoo00=oo`03001oogoo0:Yoo`40000000<007ooOol0ogoo7Goo0@000000
0`00Oomoo`0aOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`09Ool0
0`00Oomoo`0:Ool00`00Oomoo`2`Ool100000003001oogoo035oo`03001oogoo00=oo`03001oogoo
00Uoo`03001oogoo01aoo`03001oogoo00Yoo`03001oogoo0:Yoo`40000000<007ooOol0ogoo7Goo
0@0000000`00Oomoo`0aOol00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomo
o`39Ool100000003001oogoo03Moo`03001oogoo0>9oo`40000000<007ooOol0=goo00<007ooOol0
;goo00<007ooOol0/7oo0@0000000`00Oomoo`0mOol00`00Oomoo`03Ool00`00Oomoo`0SOol00`00
Oomoo`2`Ool100000003001oogoo03Moo`03001oogoo00=oo`03001oogoo00Uoo`03001oogoo00Yo
o`03001oogoo00=oo`03001oogoo00=oo`03001oogoo0;Moo`40000000<007ooOol0=goo00<007oo
Ool02Goo00<007ooOol047oo00<007ooOol0`goo0@0000000`00Oomoo`0gOol00`00Oomoo`0FOol0
0`00Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`2gOol100000003001oogoo03Moo`03001oogoo
00=oo`03001oogoo00Yoo`03001oogoo01Eoo`03001oogoo0;Moo`40000000<007ooOol0?Goo00<0
07ooOol00goo00<007ooOol02Woo00<007ooOol0bGoo0@0000000`00Oomoo`3oOolMOol100000003
001oogoo03eoo`03001oogoo00=oo`03001oogoo01Ioo`03001oogoo0;eoo`40000000<007ooOol0
?Goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol0`goo0@0000000`00Oomoo`13Ool00`00
Oomoo`0:Ool00`00Oomoo`39Ool100000003001oogoo04=oo`03001oogoo00Aoo`03001oogoo00=o
o`03001oogoo00=oo`03001oogoo0<=oo`40000000<007ooOol0@goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol0bGoo0@0000000`00Oomoo`3oOolMOol100000?l002400000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250053, 
  0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["WindowsSound", "\<\
DTU6ATIF001G@EI5IVed8100000100404B/0014[000100P0I65dHB9F0020P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P81oOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgn0P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820OgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmnOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemOGemO7alO7alO7em
OGemOGemOGemOGemOGemOGemOGemOGemOGemOGinOWinOWinOWinOWinOgmoOgmo
OgmoOgn0P820P820P820PH61PH61PH61PH:2PX:2PX:2PX:2Ph>3Ph>3Ph>3Ph>3
Ph>4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Ph>3
Ph>3Ph>3Ph>3Ph>3Ph:2PX:2PX:2PX:2PX:2PX:2PX61PH61PH61PH61PH61PH61
PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH60
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P7moOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmnOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWin
OWinOWinOWinOWinOWinOWinOWinOWinOGemOGemOGemOGemOGemOGemOGemOGem
O7alO7alO7alO7]kNg]kNg]kNWYjNWYjNWUiNGUiNGQhN7QhN7MgMgMgMgIfMWIf
MWIeMGEeMGEeMGEeMGAdM7AdM7EeMGEeMGEeMGEfMWIfMWMgMgMhN7QiNGUjNWYk
NgalOGemOWioOh20PH62PX>3PhB4QHF6QXN7QhR8R8V9RHZ:RX^;Rh^<S8b<S8b<
S8f=SHf=SHf=S8b<S8b<S8b<Rh^;Rh^:RXZ:RHV9RHV8R8R8QhN7QhJ6QXJ6QHF5
QHF5Q8B4Q8B4Q8B4Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3
Ph>3Ph>3Ph>3Ph>3Ph>2PX:2PX:2PX:2PX:2PX:2PH61PH61PH61PH61PH61PH61
PH61PH61PH61PH61PH61PH61PH61PH61PH61P820P820P820P820P820P820P820
P820P820P820P820P820OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OginOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWim
OGemOGemOGemOGemOGemOGelO7alO7alO7alNg]kNg]kNg]kNg]kNgYjNWYjNWYj
NWYjNWYjNWYjNWYjNWYjNWYjNWYjNWYjNWYjNWYiNGUiNGQhN7QgMgMfMWIeMGAd
Lg=bLW5aL71_Kfi^KFe/K6][JVYYJFQXJ6MWIfMWIfMWIfMWIfMXJ6UYJVY[K6e]
KVm`LG9cMGIgN7UkO7eoP863Q8F7R8V;S8f>Si6BTiBDUIJGUiRIVIVJVYZKVi^K
ViZJVYZIVIVHV9NGUYFEU9BCTY:AT92?SXj=SHb;RhZ:RXV9R8R8R8N7QhN7QXJ6
QXJ6QXJ6QXJ6QXJ6QXJ6QXJ6QXJ6QXJ6QXJ6QXJ6QXJ5QHF5QHF5QHB4Q8B4Q8B3
Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph>3Ph:2PX:2PX:2
PX:2PX:1PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH20P820P820
P820P820P820P820P820P820P7moOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OginOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOWinOGemOGemOGemOGem
OGemO7alO7alO7alO7alO7alO7alO7alO7alO7alO7alO7alO7alO7akNg]kNg]k
Ng]jNWYjNWYiNGUiNGQhN7QhN7MgMgMgMgMgMgMgMgMgMgMgMgMgMgMgN7QhN7Mg
MgMgMgIfMWEeM7=cLW5`Kfi]K6]ZJ6MVIF=RHEmNGEaKFUUHEeIEEEADE5ADE5EE
EUMHFE]LGV1QI6IXJfe`LgEhNgj1Q8N:SHnBUINJW9jQXjBVYjVZZjb/[Jf][Jf]
[:b[ZZVXYjFTXj6PWYfLVYVGUYFCTY6@Shj=S8^;RXZ9RHV8R8R8R8R8R8R8R8V9
RHV9RHV9RHV9RHV9RHV8R8R8R8N7QhN6QXJ6QHF5QHF4Q8B4Q8B4Q8B4Q8B4Q8B4
Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4Q8>3Ph>3Ph>3PX:2PX:2PX:2PX:2PX:2PX:2PX:2
PX:2PX:2PX:2PX:2PX:2PX:2PH61PH61PH61PH20P820P820P820P820P820P820
P820P820P820P820P820P820P820P81oOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmnOWinOWinOWinOWinOWinOWimOGemOGemOGemOGem
OGemOGemOGemOGemOGemOGemOGemOGemOGelO7alO7alO7akNg]kNg]kNg]kNg]k
Ng]kNg]kNg]kNg]kNg]kNg]kNg]kNg]kNWYjNWUiNGUhN7QgMgMfMWIfMGEeMGEe
MGEeMWIfMWIgMgMgN7QhN7QhMgMgMWEdLg9aKfi/JVQVHf5NG5UGE59?CD]8ATE3
@T10?clo?d11@dA7BDa?DeMKGfAYKW=hOH>8SI:GW:6UZZja]KRj_Kk0`L;2`/;1
`;nm^kVg];:_[:ZWY:6NW9VGUI>AShf<RhZ9R8N7QhN6QhN7QhN8R8R9RHV9RXZ:
RXZ:RXV9RHR8R8N7QhJ6QHF5Q8B4Q8B4Q8>3PhB4Q8B4Q8B4Q8B4Q8B4Q8B4Q8B4
Q8B4Q8>3Ph>3Ph:2PX:2PX:2PX:2PX:2PX:2PX:2PX:2PX:2PX:2PX:2PX:2PH61
PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH61PH60P820P820P820P820
P820P820P820P820P820P820P820P820P820P7moOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOWinOWinOWinOWinOWinOWinOWinOgmo
OgmoOgmoOginOWinOWinOWinOWimOGemOGemOGemOGemOGemOGinOWinOWinOWin
OWinOWimOGemOGelO7alO7alNg]kNg]kO7alO7alO7emOGemOGemOGemOGemO7al
Ng]jNWUiN7QhMgMgMgMgMgQhN7UjNW]kO7emOWinOWinOGakNGMeLW1/JFEQGEUE
D4a7@clk=c@a;R`[:RX[;2h`=3Pl@TQ>EEaTK7AmQHfFWZF]];[0aL[>dM?Ee]KF
eM?Ac/_7`kjj]K2[Yj:MVIFASX^8QXB2PH1oOgmoOh20PH:2PhB5QHJ6QhN7QhN7
QXJ5QHB4Ph>2PX61P820P820P820P861PH:2PX:2PX>3Ph>3PX:2PX:1PH61P820
P820P820P820P820PH61PH61PH61PH61PH61PH20P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P81oOgmoOgmoOgmoOgn0P820P820P820P820P820P820OgmoOgmoOgmoOgmoOgmo
Oh20P820P820P820P820P820P7moOgmoOgmoOgmoOgmoOgmoP820P820P820P820
P820P820P81oOgmoOgmoOgmoOgmoOh20P820P820P821PH60P820P820P820Ogmo
OgmoOgmoOgn0P820P821PH61PH61PH61PH61PH60P820OgmoOgmoOgmoP820P861
PX:3Ph>3Q8B4Q8B3Ph>2PH60P7moOWimOGenOWmoP8:3Q8J7R8Z;S8f=SHf<RhV6
PgmkMW5[I5iGD4Q1>c@^:2@P7AXI6Q/N8BH]=3a5CeYULGf9U:2[]Ko8d=OLhNCV
i^KThMgIdlg6_kR`ZJ6JThf7PGeiMG=aKfi^KVm`LG=dMWQiNgamOWn0P820Ogmn
OWelNg]jNWUiNGUiNGUjNW]kO7amOGinOWmoOgmoOWinOWemOGalO7alO7alO7am
OGenOWinOgmoOgmoOgmoOgmnOWinOWinOWinOWinOWioOgmoOgmoP820P820Ogmo
OgmoOgmoOgmoOgmoOgmoOh20P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P81oOgmoOgmoOgmo
OgmoOgmoOgn0P820P7moOgmoOgmoOgmoOginOWinOgmoOgmoOgmoOgmoOgmoOgmo
OgmnOWinOWinOWinOWinOWioOgmoOgmoOgmoOgmoOgmoOWinOWinOWinOWinOWmo
OgmoP820P820P820P81oOgmoOgmnOWinOWmoOgn0P821PH62PX:2PX:2PX:1PH61
P820P820P820PH62Ph>4QHJ6QhR8R8R8R8R7QhJ5QHB3Ph>3PhB5QXR:S8nAU9NJ
W9nPXZ:RXInLV9>=QGeeJf5GC48h;RHN61<?3Ph@51XR:cI3D5m^OHfLZkW6dM_T
j^oal_7]jN;Kd/Rn/jRMThUoMfmYI5mLFeYJFeaNHFAWJViaLgIhNG]lO7alO7]j
NWUhN7MgMgMgN7QiNW]lOGioP821PH62PX61PH20P7moOgmoOgmoP820PH62PX>3
Ph>3Ph>3Ph:2PX61PH60P820P821PH61PH62PX:2PX:1PH61PH20P81oOgmoOgmo
OgmoP820P820P820P81oOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOgmoOgmoOgmoP820P820P820P820P820P820P820P820P820P820P81oOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOh20P820P820P7mo
OgmoOgmoOgmoP820P820P861PH61PH61PH60P820P820P820P821PH61PH62PX:2
PX61PH61P820OgmoOgmoOgmoOh20P820P820P81oOgmnOWemO7alO7alO7alO7em
OGinOWinOWinOGelO7]jNWYiNGUiNWYkO7enOh21PX>4Q8B4Q8>2PH60OgmoOh21
PhJ9SI6FVj2UZZjb];Jf]K>^Z:6GSH5dIUQ:?2lT6A4;1`H831<M:CM7FFaoTZBf
amGRk??hnOSek^KKcl:dYIN9NfmTFe==BDM6AdY=DEILHFM/LGIiOGn1PX:2PX60
P7mnOGemOGinOh21PXB5QXJ7QhN7QhN6QHB4Ph:2PH61P821PH61PX:2PX:2PX:1
PH20OgmnOWemOGemOGemOWinOWmoOgmoOginOWinOGemOGemOWinOWmoP820P861
PH61PH20P820P820P820P821PH61PH61PH61PH61P820P820OgmoOgmoP820P820
P820P7moOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOh20
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P81oOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgin
OWinOWinOWinOWioOgn0P820P820P820P7moOgmoP820PH61PX:3PhB4Q8B4Ph>3
PX:1PH20P820P820PH61PX:2PX60P7mnO7]jNGQgMWIfMWIgN7UjNgalOGemO7]j
NGMeM7=cLgAfN7b1QhjFWZJ^]Kc1aLO6a;ng[J2BPW5OCS`/7Q891043214N;D1D
JX6G[L7ChnohoOkkmN_Od;n]VhUhJ5Y>A3di=cPj?dI=EEiWKgMmPhR;SHj?SXf<
RXR7QHB3Ph>3Q8F6QhN8R8V8R8N6QHB2PH1nOWelO7alO7amOGinOWinOWinOWem
O7alO7alOGenOWmoP821PH61PH61PH61P820P820P861PH61PH:1PH61PH20Ogmo
OginOWinOWioOgmoOgmoOgmoOginOWinOWinOgmoOh20P861PH61PH61PH20P820
P820P820PH61PH61P820P81oOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmo
OgmoOh20P820P820P820P820P820P820P820P820P820P820P820P820P7moOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgmoOgn0P820P820P820P820P820
P820P821PH61PH61PH61PH20P81oOgmoOgmoOgmoOgmoOgmoOWinOGemO7alO7am
OGinOgn0P861PH61PH61P820P861PX:3Q8F6QhN7QhN6QHB3PH1nO7]jNWUiNWYk
NgalO7]jNGIdLFiZJ6ETI6EXK7=jPhjIYK2ka<cAdm;>a[^/VhQcGTTe8a@90P02
2ADV>U5YPifebmo^nOooo??Ve/>^VH=_G4/n=2h[;30g@4]GHfmjQ8bCV9^MWI^I
UY:?S8V6Q8>2PX:3PhB4Q8B4Ph:0OgelNWUhN7MgN7UiNgamOWmoP820P820P7mo
Ogn0P861PX:2Ph>3Ph>3PX:1P81oOgmnOWinOWmoOgmoOgmoOginOWinOWinOWmo
Oh20P861PH61PH61P820P820P820P820P820P820OgmoOginOWinOWioOgmoOh20
P820P820P820P820P820PH61PH61PH61P820OgmoOgmoOgmoOgmoOgmoOgmoOgmn
OWinOWmoOgmoP820P821PH60P820P820P820P820P820P820P820OgmoOgmoOgmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoOh20P820P821PH61PH20P820P820P7moP820
P820P820OgmoOgmnOWinOWinOWioOgmoP820P820P820P820P820PH61PX:2PX:2
PX:1PH1oOginOGemOGemOGinOWinOWimOGalO7alO7enOh22PhF6QhR9RHV8QhJ4
Ph:1P820PH62PX>2PX1mNWIaJfIQG5UGEeYOIW1lRYRW]/?>e][Ke/g0[YZ3Je8k
9QD90P05420fCVZ6X[gDioGmoo_ah/jhX8M_FDDf:bDT9bhhAEATLh6>VJ6WZJZX
Y9nJU8j9Q81nO7]kNgalOGinOGelNgUhMgMfMgMhNG]mOh22PhB5QHF4Q8>3PX:1
PH61PH61PH61PH60OgmnOGelO7alO7emOWioOh20P820P820P820P820PH61PH61
PH61P820OgmoOWinOWinOgmoOgmoOgmoOgmoOgmoP820P820PH61PH20P820Ogmo
OgmoOgmoOgmoOgmoOgmoOgmoOgmoP820P821PH61PH20P820P7moOgmoOgmoOgmo
OgmoOgmoOWinOgmoOgn0P821PH61PH61P820P820P820P820P820P7moOgmnOWin
OWinOgmoOh20P820P820P820P820P820P861PH60P820P7moOgmnOWinOWmoOgmo
OgmoOgmoOgmoOgmoP820P861PH61PH61PH60P81oOgmoOgmoOgmoOgmoOginOWim
OGenOWioP821PX:3Ph>3Ph:2PH61P820P820P820P81oOWelNgYiN7QhNGYkOGj0
PXB5QXJ6QXJ5QHB4QHF6R8V;S8b;RHJ1NgA/I5aED4e=D5IPKGf>XK;3d=[Og]S<
^jF=LULm9Q@80P@=7C==JhZXa=_]nOgjkmo9/9EiH4Tf:B4P92djBUe_PY:PZ[6d
];6[Xi^BRH9kMW=aLG9cMGMhNGYkNgYjNWUjNW]lOX22Q8J7R8R8R8N5Q8:1P7mn
OGemOGinOWinOWimOGemOGemOWioP861PX>3Ph>2PX61P820OgmoOgmoOgmoOgmo
OWinOWinOWmoOh20P861PH61PH60P820P820P820P81oOgmoOgmoOgmoOgmoOh20
P820P820P820P820P820P820P7moOgmoOgmoOgmoOgn0P820P820P820P820P820
P820P7moOgmoOgmoOgmoOgmoP820P820P820P820P820P820P820P81oOgmoOgmn
OWinOgmoOh20P861PH61PH20P820P820P820P820OgmoOWinOWinOWioOgn0P821
PH61PH20P820P820P820P820P7moOginOWemOGinOWmoP820P861PH60P820P861
PH61PH61PH20OginOGalO7alOGenOgn0P861PH61PH61PH:2PhB4Q8B4Ph:1Ogek
NWQgMgMhNGYkOGj0P861PH61PX:4QXR<Si:DUIFCShR0MVaQETi7ADI<EVEfRYnd
a]CNhMgC`J^@LeHk8a881PdL<Ti]SZg:hO3hn>kNajb?LEHo;B8N8B/iC65fRYb[
]KZk^;6WW925Ng=]JFQXJVeaMGQkOGioOgmoOh21PX>4QXN8RHR8QXF3P7ilNgYi
NGUjNgamOWmoOh20P820P821PX:3Ph>3Ph:2PH1oOWemOGemOGenOWmoOh20P820
P820P861PH61PH61PH20OgmnOWinOWinOgmoOh20P820P820P820P820P820P820
OgmoOgmoOgmoOgmoP820P820P820P820P820P820P820OgmoOgmoOgmoOh20P820
P820P820P820P820P7moOgmoOgmoOgn0P820P820P820P820P81oOgmoOgmoOgmo
OgmoOgmoOh20P820P820P820P820OgmoOgmoOgmoOgmoOgmoOgmoOgn0P861PH61
PH61P820OgmoOgmoOgmoOgmoOWinOWioOgn0P861PX:2PX:1PH20OgmoOWinOWmo
OgmnOWinOWinOgn0P862PX>3Ph>2PX60OginOGemOGenOWinOWimOGemOWn0PH>4
QHJ7QhJ5Q8:0OWakNGUiNGUjNg]lO7]kNg]lOH23R8fBUi^MWIZDS85dIUU=AD11
Ae9SMhjU^lgJgmkD`ZZ>Ke4e814<41dcCfnA/LgSl??]g/R/SFmB>bXQ82LeB5if
SJ6`^knn^JnRU8IiKVMRH69UJVmeNWn2Q8J6QXF5Q8B5QHF6QXJ5Ph:0OG]jN7Qh
N7UkO7j0PH:3Ph>3PX:2PH61PH61PH20OginOGalO7alOGioP862PX:2PX:1PH20
P820P7moOgmoOWinOWinOWioOh21PH62PX61PH20P7moOgmoOgmoOgmoOgmoOgmo
Oh20P821PH61PH20P7moOgmoOgmoOgmoOgmoOgmoOh20P820P820P820P81oOgmo
OgmoOgmoOgn0P820P820P820P820P820P820P820P820P820P820P81oOgmoOgmo
OgmoOgmoP820P820P820P820P81oOgmoOgmoOgmoOgmoOgmoOh20P820P820P820
P81oOgmoOgmoOgmoOgn0P820P820P820P861PH61P81oOginOWinOWinOgn0P821
PH61PH61PH61PH61P81oOgimOGalO7emOWn0PH:2Ph>3PX:1PH60P820P7moOWel
Ng]jNW]kOGn1PhF6QhR7QXF3PX1oOGelO7akNgYhMgEdM7EgNh68SiJMXZBRWIB8
NFUJC4<n?dMFJH2I/LKEg=[@_JB6ITP_7A@E8CEBLYFecn;[j]o:[i1aE3`[92D_
@5I_Qij`_<70^JfNSWi`IEiKG61VKWImPhR;S8b;RHN6Q8>3PX:1P7mnO7]jNGQh
NGYlOX22Q8F5QHF4Ph60OgmnOWinOWinOWimOGinOWn0PH:2Ph>3PX:1P7mnOWin
OWinOWmoOgmoP820P821PH61PH61P81oOginOWinOWmoOh20P821P820P820P820
P81oOgmnOWinOWioOh20P861PH61P820P81oOgmoOgmoOgmoOgmoOgn0P820P820
P820P81oOgmoOgmoOgmoOgmoOgmoP820P820P820P820P7moOgmoOgmoOgmoP820
P820P820P820P820P820P81oOgmoOgmoOgmoOh20P820P820P820P820P820P81o
OgmoOgmoOgmoOh20P820P820P820P820P81oOgmoOgmoOWmoOgn0P861PH61PH60
P7moOgmoOgmoOgmoOgmoOgn0P861PX:2PX:1P81oOWemOGemOGioOh20P861PH62
PX>3Ph>2PH1oOG]jNGQiNW]mOh:4QHJ6QXJ5Q8>2PX61P7ilNWMcLFm^L7=iPHZD
WJBWYj:HRgYYF4Y1?T=>HGRAZ/3?emC9]9UjFclZ7Q`V>UEfUkK?g^?McKBGMeU1
<2T[=dYQNiBY^<30^JfMRgY[H5UGFV1YLgf5S92ATHn<RHF2P7mmOGalO7]jNWYj
NgamOh63QHJ6QXF4PX1oOGalO7amOGinOgn0P820PH61PX:2PX60P7mnOGemOGen
Ogn0P861PH61PH20P820P7moOgmnOWinOWmoP821PH61PH60P7moOgmoOgmoOgmo
OgmoP820P821PH60P820OgmnOWinOgmoOh20P820P820P820P820OgmoOgmnOWmo
Ogn0P821PH61P820P7moOgmoOgmoOgmoOgmoP820P820P820P81oOgmoOgmoOgmo
Oh20P820P820P820P820P81oOgmoOgmoOgmoP820P820P820P820P81oOgmoOgmo
OgmoOgmoP820P820P820P820OgmoOgmoOgmoOgmoOgn0P820P820P820P81oOgmn
OWinOgmoP820P820P820P820P820OgmnOWinOWinOh21PH:2PX:2PH20OgmnOWin
OWinOWinOWn0PH:3Q8B5Q8>1OgilNWUiNGYlOGn1PX>4Q8B5QHJ6QXF4PGiiMG1/
JVY]Lgb7TYfUZJVSV8QfHe=7@D==GWB>Ykc:d<^mYXY[CcPY9Re0FWVI]/cHf<jj
Wh1SBCP`<SiAJX>K[[Zn^ZnPSG]ZGUMFFV9/N8><TYFEThn:QH1mNWUhNGUjNg]l
O7enP863Q8F6QXF3PX1nO7]jNg]lOGn0PH62PX:2PH61PH20P7moOWimOGenOWn0
PH62PX:1PH20OgmnOWinOgmoOgmoP820P821PH60P81oOgmnOWioOgn0P820P820
P820P81oOgmoOgmoOgmoOh20P820P820P81oOgmoOgmoOgmoP820P820P820P820
P7moOgmoOgmoOh20P820P820P81oOgmoOgmoOgmoOgmoP820P861PH20P7moOgmo
OgmoOgn0P820P820P820P820P7moOgmoOgmoOh20P820P820P820OgmoOgmoOgmo
OgmoOh20P820P820P820OgmoOgmoOgmoP820P820P820P820P820OgmoOgmoOgmo
Oh20P861PH20P81oOgmoOgmoOgmoOgn0P820PH61PH60P7moOWimOGinOgn0PH61
PH61PH61P81oOginOGalO7enOh22PhB5QHB3PGmmO7]jNW]kO7enOh22PhF7R8V:
RHJ2OGMaJfQWJW5jQY:MYZVWWY60KE]=ATI?GgF>Y[W5akn^UGUMACD`=TIOOIZd
alo;_JN;KUE2>CY4Efj7WJjh^K:UTh1_HEQFFV9]NXJ?UYRGThf7P7]gMGEeMgUk
OGn0PH:3Q8B5QHB3PX1nO7]jNW]lOGn1PX>3Ph>2PH20OginOWinOWinOWn0P861
PX:2PH60OgmnOWinOWmoP820PH61P820P820OgmoOgmoOgmoOh20P861P820P7mo
OgmoOgmoOh20P820P820P820P7moOgmoOgmoOh20P820P820P7moOgmoOgmoOgn0
P820P820P820OgmoOgmoOgmoP820P820P820P7moOgmoOgmoOgn0P820P820P820
OgmoOgmoOgmoP820P820P820P820OgmoOgmoOgmoOh20P861P820P7moOgmoOgmo
Ogn0P820P820P820P81oOgmoOgmoOgn0P820P820P820OgmoOgmoOgmoOgn0P820
P861P820OgmoOginOgmoP820P820P820P820OgmoOginOWioOh20PH61PH61P7mo
OWinOWinOgmoP821PH62PX:1PH1oOGalO7amOWn1PXB4Q8B3PX1oOWelNg]kNg]l
OX22QHR;S8b:QX1hLF]WIfYbO8VEWjJVX9F5Lf9DC4aEIGZAY[Jn_;2LPfUB@S]0
CVF0V[6oa;f]UWaSCdA2BUY`Qi^[/k:ZVhYhJ5iIFV9]NHJ@UYVGThb4OGMcLW=e
N7]oPH>4QHF5Q8>2PH1nOGakNg]lOGn0PX>4Q8>2PH1oOWemOGenOWn0P861PH61
PH60P7mnOWinOWioOh21PH61PH60P7moOgmoOgmoOgn0P820P820P820OgmoOgmo
Ogn0P820P820P820OgmoOgmoOgmoP820P820P820P7moOgmoOgmoP820P820P820
P7moOgmoOgmoP820P820P820P7moOgmoOgn0P820P820P820OgmoOgmoOgn0P820
P820P81oOgmoOgmoOh20P820P820P820OgmoOgmoOgmoP820P820P820OgmoOgmo
OgmoP820P820P820P7moOgmoOgmoOh20P820P820P7moOgmoOgmoOgn0P820P820
P820OgmoOgioOgmoP820PH61P820OgmoOgmoOgmoOh20P861PH60P7moOWinOWio
Oh20PH61PH61P81oOginOWinOWmoP862PX>2PX5oOWelO7alOGn0PX>3Q8>3PX60
OgelNWUiNGYlP8B8S8j>S8N0N71ZIfQ]MX:>VJ6SWiF7MVIIDeAMKH2EY[6d[Ij:
Lei>AdYGJX:IZkJg[Yj8LEe@C51MKh>FY:^[XYF4M6MOGF5ZMX:=U9RGTX^3NgEb
LG9eNWj2QHN7QhF4PX1nOGalO7alOGj0PH:3Ph>3PX1oOWelO7enOh21PH:2PX61
P81oOWinOWinOgn0PH61PH61P7moOWinOWioOh20PH61PH20P7moOgmoOgmoOh20
P820P820P7moOgmoOgmoP820P820P820P7moOgmoOgmoP820P820P820OgmoOgmo
Ogn0P820P820P820OgmoOgmoOgn0P820P820P81oOgmoOgn0P820P820P820P820
P820P820P820P820P7moOh20P820P820P820OgmoOgmoOh20P820P820P81oOgmo
OgmoOh20P820P820P7moOgmoOgmoP820P820P820P7moOgmoOgmoP820P820P820
OgmoOgmoOgmoP820P820P81oOgmoOgmoOgn0P821PH60P81oOgmnOWioOgn0P861
PH60P7moOWinOWioOh20PH61PH61P7moOWemOGioP862PX>3PX60OgemO7amOGio
PH:3PhB4Ph:0OW]iMgMgNWj3R8b?SX^6OWI_JVU/M7j9U9^NVY:5MVUOFeiXMXRH
Y:VWW8ajJ5YDEV1`PiJTZjZPTGi/GUMHH6ioSibSXib@PWAYHf9WLGb7T9FFTXb4
O7EaL79fNh25R8V8QXB1OWekNg]lOGioP862PX>2PX60OgimOGemOWn0PH:2PX60
P7mnOWinOWmoP821PH61P820OgmnOWioOgn0P861PH60P7moOWinOgmoP820P820
P81oOgmoOgmoOgn0P820P820P7moOgmoOgmoP820P820P81oOgmoOgmoOgn0P820
P820P81oOgmoOgmoP820P820P81oOgmoOgmoOh20P820P820P820OgmoOgmoP820
P820P81oOgmoOh20P820P820P820P820P81oOgmoOgn0P820P820P7moP820P820
OgmoOgn0P820P820P7moOgmoOh20P820P820P820P81oOgmoOgmoP820P820P7mo
OgmoOgn0P820P820P820OgmoOgmoOgmoP820P820P81oOgmnOgmoP821PH60P81o
OgmoOgmoOgn0P821PH60P81oOWinOWioP861PX:2PH1oOWemOGioP821PX:2PH60
OgmnOGalOGeoP8:4QXJ5Ph1lNGIeMgYnQ8V=SXf8PWYcKVa^MGf7T9JGU8b1MV]U
I6UbOhbGWIjGS7i`IF1QJGF4TYbPWIB7NFaTHFE^NhRCVI^FSH9gKVUYKGEoR8nB
THf7OgUdLG9eNX25R8Z9Qh>0O7YiNG]mOh63Ph>3PX1oOginOWinOgmoP821PH61
PH1oOWimOWioP862PX61P7mnOWinOgn0P860P820OgmoOgmoOgmoOgn0P821PH20
OgmnOWioOh20PH60P81oOgmoOgn0P820P820P820P820OgmoOgmoP820P820P7mo
OgmoOh20P820P820OgmoOgmoOh20P820P820P820OgmoOgmoOh20P820P81oOgmo
OgmoP820P820P7moOgmoOh20P820P820P820P820OgmoOgmoP820P820P7moOgmo
Oh20P820P81oOgn0P820P81oOgmoOh20P820P81oOgmoOgmoP820P820P7moOgmo
P820P820Ogn0P820P820OgmoOgmoP820PH60P7moOWioOh20P820P81oOgmoOh20
P7moOgmoP821PH60P7mnOGinOh21PX:2PGmnOWenOWn0PH61P820Ogn0P81oOgin
OWioP8:3Q8>2P7ikNWYkOH23QXN7QH9nNWQfMgUmPXJ9RhZ7PWagLg9cN7j5Rhn@
SHMoMg1]KG9jQ8fCUI:;PGI^JFY_NHB>U9JCRh5gKf]/LGV3Ri6BShV1NG=`L7Aj
P8J:S8^8PgiiMWEfNGf1QHR8QhF1OGYhN7UlOh>5QXF4PGilNg]lOX21PX:2PGmo
OWioP820P7moOWmoP861PH60OgimOGioP862PX60OginOWioP821PH60P7moOgmo
P820P81oOgn0P820P81oOgmoOgn0P820P820OgmoOgmoOh20P820P81oOgmoOgn0
P820P81oOgmoOgn0P820P7moOgn0P820P7moOgmoOh20P820P7moOgmoOh20P820
P81oOgmoOgn0P820P820P7moOgmoOgn0P820P820P820P81oOgmoOgn0P820P820
OgmoOgmoP820P820OgmoOgmoP820P820OgmoOh20P820P7moOgmoP820P820Ogmo
OgmoP820P820OgmoOgmoP820P820OgmoOgn0P820OgmoOgn0P820P820OgmoOgmo
Oh20P820P81oOginOWn0P861PH20OginOWn0P861PH1oOgioOh21PH1oOWimOWn1
PX>3PWmmNgYkOH23QHJ5PgmlNGQiO7n3QXN6Q85mNgUjNgf0PXB4Q8B2PGmmNgYi
Ngf1Q8R9RHJ1NgIcLgMmQ8^?Sh^3NgA_Kg=kQ8b@T8b4O7E`L7AkPXV<S8V4OWUg
MWQlOh:4QHF3PX1oOGalO7amOh64QHF4PWmkNGQjO824QXN6PgmkNGUjOH64QHF4
PGilNgamOh62PX:1OgmnOWn0P820P7moOgmoP820P81oOgmoOgn0P820P820P7mo
OgmoOh20P861P81oOginOh20PH61P7moOgmoOh20P820P7moOgmoP820P81oOgmo
Oh20P820P7moOgmoP820P820P81oOgmoOh20P820P81oOgmoOh20P820P7moOgmo
Oh20P820P7moOgmoP820P820P7n0P820P7moOgn0P820P820P820P820OgmoOgn0
P820P81oOgmoOh20P820P7moOgmoOh20P820P7moOgmoP820P820OgmoOh20P820
P7moOgn0P820P820P81oOgmoOgn0P820P81oOgmoOgn0P861P81oOginOgn0PH61
P7moOgmoOh20P820OgmoOgn0P820P7moOgmoP820P820OgmoOgmoOgn0P861PH60
OWemOGj0PX>4Q89oO7YjNgj1QHJ6Q81lNGQiOH64QXJ4P7ejNW]nPH>4Ph1nO7an
P8>4Ph1mNWUjOX:7RXV5OWQcLgImQHb?SHMnMW1_Lg^5SI2?R7mgLG1dO8B:SH^6
OgUeMGUnPhN7QH5mNgYlOh:4Ph5nO7]lOX64QXF2OWYiNGb0Q8J7QH5mNWUiO823
QHF4PGilNgamOh62PX:1P7mnOWioOgn0P821PH20OginOWioP861PH1oOginOh20
PH60P7moOgmoP820P81oOgmoOh20P820OgmoOgmoP820P820P81oOgmoOgn0P820
P81oOgmoOh20P820P7moOgmoP820P820OgmoOgmoP820P820P7moOgmoOh20P820
P7moOgmoP820P820OgmoOh20P820P7moOgmoP820P820P820P81oOgmoP820P81o
OgmoOh20P820P7moOgmoP820P81oOgmoOh20P820P7moOgmoOh20P820P820P7mo
OgmoOh20P820OgmoOgn0P820P81oOgmoOh20P820OgmoOgn0P820P7moOgmoP820
P820Ogn0P81oOgmoOh20P820OgmnOWn0P861PH1oOWenOX21PX:1P7mnOWioOh21
PH20P81oOgmoOWioOh62PX:1OgekNgeoPXF5Q85mNWUjOX:5QhJ2OGUgNGb2QXV7
PgehMGMlPhV<RXAlMG5cNX><T8j7OG=]KWF0Ri>CSH5eKF]`NhRAUI26NW1[KWN3
SI:ARGidKg1fP8V>SXR0N7=cN7n6RXZ6P7YfMWZ0QHR8Q7mkN7QkP8B6QX>0O7Yj
O7n2Ph>2P7imOGioP861P81oOh20P81oOWinOh21PX60OgimOGn0PH:2PH1nOWin
Oh21PH20OgmoOgmoOgmoP820P820OgmoOgmoP861P81oOgmoOh20P820OgmoOgn0
P820P820P820P7moOgn0P820P81oOgmoP820P820OgmoOgn0P820P7moOgmoP820
P820P820OgmoOgn0P820P81oOgmoP820P820OgmoOgn0P820P820P81oOgmoOh20
P820P7moOgmoP820P81oOgmoOh20P820OgmoOgn0P820P7moP820P81oOgmoP820
P81oOgmoOh20P820OgmoOgn0P820P7moOgmoP820P7moP820P81oOgmoOh20PH60
OgmnOWn0P861P81oOgmoOh20P820OgmoP820P7moOgn0P861P7mnOWioP862PH1o
OWenOh21PH60OginOh21PH60OgioOh61PH1oOGenP8:4Q89oO7YjOH:6R8J2O7Me
Mgf4RXf:PWUbL7AmR92BSH9fKFY`O8^EV963LfQUKGb<VI^CQ79VHf]kSIVLU8Ab
IVA/NhbHVY:3M6UWKgb;U9F>PWE]KG=nRHn?RH1gLW=hP8N:RHAnNGMiOH65QHB1
OWalOH22PX:0OWinOh21PH1oOWinOh62PX5oOWenOh21PX60OginOh21PH60Ogmo
Oh20P81oOgmoP820P81oOgioP821PH1oOgioOh20P820OgmoOh20P820OgmoP820
P81oOgmoP820P81oOgmoP820P820OgmoOh20P820OgmoP820P7moOgn0P820P7mo
OgmoP820P81oOgmoOh20P820P820P81oOgmoP820P820OgmoOgn0P820P820Ogmo
Ogn0P820P820OgmoOh20P820P7moOgn0P820P7n0P820P81oOgmoP820P81oOgmo
P820P820OgmoOh20P81oOgmoP820P81oOgmoP820P81oOgmoP820P81oOgmoP820
P81oOgmoP820P7moOgmoP820P7moOgmoP861P7moOWmoP861P7moOWn0P861P7mn
OWn0PH61P7inOWn0PH:1P7imOGj0PX:2P7imOGj0PX:1OgemOGn2Ph>1OW]jNh25
R8R4OGMdMWb5SHn;PWI^K7>0SIJFSGe]I6IcQINOVh]fI5eSMXfOY9^6KeeJIWbD
XjBGP6ULGFb3V::OSgUWGfEeR9NLUHIeJFM_OH^CTh]oMG1aNH:9S8V2O7MgNX24
QXB1OWalOX22Ph5oOGenP862PX1nOGenP8:2PH1nOGeoP861PH1oOWioP861P7mn
OWn0PH60P7mnOgn0PH60OgmnOgn0PH20OgmoOh20P820OgmoOh20P81oOgmoP820
P81oOgmoP820P81oOgmoP820P7moOgn0P820P7moOgn0P820OgmoOh20P820Ogmo
Oh20P820OgmoOh20P81oOgmoP820P81oOgmoP820P81oOgmoP820P81oOgn0P820
P81oOgn0P820P81oOgn0P820P81oOgn0P820P81oOgmoP820P81oOgmoP820P81o
Ogn0P820P7moOgn0P820P7moOgn0P820P7moOgn0P820OgmoOh20P820OgmoOh20
P820OgmoOh20P81oOgmoP820P81oOgmoP820P7moOgn0P861P7mnOWn0PH61P7mn
OWn0PH60OginOh21PH5oOWenOh62PX5oOGamP8:3PX5nO7anP8:3PWmmO7f0PhB3
P7aiNGf3R8V6OgMbLg^6Si:=PG=YJG>4U9bIRGASGFIkTjBUUWeSEEU^RjB]XhY[
EE5QOYb]ZiIhGU9JLHnUZYj5JUYJJX>HXYf<MVIRJgb=UiJ<OG5]L7Z5SHf8P7Qf
N7f3QXJ3OW]kOH23Ph5oOGanP8:3PX1mO7eoPH:2PGmmOGioPH:1P7mnOWn0PH60
OginOh21PH1oOWioP861PH1oOWmoP820P7moOgn0P820OgmoOh20P820OgmoOh20
P81oOgmoP820P81oOgn0P820P7moOh20P820OgmoOh20P81oOgmoP820P81oOgmo
P820P7moOgn0P820OgmoOh20P820OgmoOh20P81oOgmoP820P7moOgn0P820P7mo
Ogn0P820OgmoOh20P820OgmoOh20P81oOgmoP820P81oOgn0P820P7moOgn0P820
P7moOgn0P820OgmoOh20P820OgmoOh20P81oOgmoP820P81oOgmoP820P7moOgn0
P820OgmoOh20P820OgmoOh20P820OgmoOh20P81oOgmoP820P7mnOgn0PH60Ogin
Oh21PH60OginOh21PH1oOWioP861P7mmOGj0PX>1OgelOGn2Ph>1OWalOX23Ph9o
O7anPHB4PWeiN7^2R8^8P7I`LGV6TYJ?P6mTIWB:W::HPVUIFVf:XjfSQfMAD6F6
Y[F[SVU>BUj1Y;J_TfiBBealW[6]UGAJDUiiUZNUTgUTGFIjSY^JSGa^JG1lRI2>
QWaeM7V0QHN5P7ajO7n2Ph9oOGanP8>3PWmmO7eoPX>2P7imOGj0PX:1OginOh21
PH1oOWioP861P7mnOWn0PH60OginOh20PH20OgmoOh20P81oOgn0P820OgmoOh20
P81oOgmoP820P81oOgmoP820P7moOh20P81oOgmoP820P7moOgn0P820P7moOgn0
P820OgmoP820P81oOgn0P820OgmoOh20P820OgmoOh20P81oOgmoP820P7moOh20
P820OgmoOh20P81oOgmoP820P7moOgn0P820OgmoOh20P81oOgmoP820P7moOgn0
P820P7moOgn0P820OgmoOh20P81oOgmoP820P7moOgn0P820P7moOgn0P820Ogmo
P820P81oOgn0P820P7moOgn0P820OgmoOh20P820OgmoP820P7moOgn0P860Ogin
Oh21PH60OWinOh21PH1oOWioP861P7inOh21PX5oOGenP8:3PX1mO7aoPXB3PGil
O7j1Ph>1OGalP8>5PgmiMgV0R8f:PWI^KWR7UIV@OFYPIGRAXjFDMeaBGW^L/JjD
Ke18FX2V^[:BJ4U4G8J/_K2<HTM8Hh^]^:R5HDeBKHnX[9]nHeQPMi2OWXijJVI_
OhfCShAhLWAkPhR8PgijNWj2Q8>0OGamP8>4PWmlNgf0PhB2P7elOGn1PX:0OWen
Oh61PGmnOWn0PH60OginOh21PH1oOWioP861P7mnOWn0P820OgmoOh20P7moOgn0
P820OgmoOh20P81oOgmoP820P7moOgn0P820OgmoP820P7moOgn0P820OgmoOh20
P81oOgmoP820P7moOh20P81oOgmoP820P7moOgn0P820OgmoOh20P81oOgn0P820
OgmoOh20P81oOgmoP820P7moOgn0P820OgmoOh20P81oOgn0P820OgmoOh20P81o
OgmoP820P7moOgn0P820OgmoOh20P81oOgn0P820OgmoOh20P820OgmoOh20P81o
Ogn0P820OgmoOh20P81oOgmoP820P7moOgn0P820OgmoOh20P81oOgmoP820Ogmo
Oh21PH1oOWinP861PH1nOWioPH61P7mnOh21PH1oOWj0PH:1OgelOGn2Q8>0OG]l
OX:4Ph5mO7aoPX>2OgalOX>6QH1jMWMoR8j=PgI/K7N9V9^?NFALIWnKZZB:J55A
JY2_]j9jE49@MjBn^IIWA3mLRkC2[X9F?dY`WKZhVW1?B5j3YK:UQVEEFg>?XZ6@
N6ISKh6AUXj1M71dOHJ:Qh5kNG^0PhB1OWamP8>4PWikNgf1Q8B2OgakOH23Ph9o
OGenP861P7mnOX21PH1oOWioPH61P7inOWn1PH60OginOh21PH1oOgn0P820Ogmo
P820P7moOgn0P820OgmoOh20P81oOgmoP820P7moOh20P81oOgn0P820OgmoOh20
P81oOgmoP820P7moOh20P81oOgn0P820OgmoP820P81oOgn0P820OgmoOh20P81o
Ogn0P820OgmoP820P7moOgn0P820OgmoOh20P81oOgn0P820OgmoP820P7moOgn0
P820OgmoOh20P81oOgmoP820P7moOh20P81oOgn0P820OgmoOh21P81oOgmoP860
P7moOgn0P820OgmoP820OgmoOh20PH1oOgioP861P7moOWn0P860OgmoOh20P7mo
Ogn0PH20OgioP861PH1nOWj0PH:1P7inOX21PH1oOWn0PH60OginOh62PX1mO7ao
PXB3P7ekO7n2Q8>0OGamP8>3P7ekOH:6QX5jMGEmR92?Q7EYJWN<W9f=LeiJJhVU
[YejF4YIOjNk[hQK@4Q_X<2nVFI0?5fA^lFYMdXkDH2]`K26FTA?Libd[Y1[DeE]
SJ>UTWMTHFn4U9N=OG5^MH6:RhInNGUmPXB3OgalOh:4PWmlNgf1Q8B2OW]kOX64
Q85nO7eoPH:1P7inOh21PGmnOWn1PH60OWenP862PH1nOGj0PH61OginOh20P81o
Ogn0P81oOgmoP861P7mnOgn0PH20OgmoOh20P81oOgn0P820OgmoP820OgmoOh20
P81oOgmoP820P7moOgn0P820Ogn0P820OgmoP820P7moOgn0P820OgmoP820P81o
Oh20P820P820P820P820P820P7moP820P81oOgn0P820P7moOh20P81oOh20P81o
Ogn0P820P7moOh20P81oOgmoP820P7moOh20P81oOgn0P820OgmoP820P7moOgn0
P820OgmoOh20P81oOgn0P820OgmoP820P7mnOh20PH5oOWioP861P7mnOWn0P820
OgmoP820OgmnOh21PH1nOWioPH:1P7imOX21PX5oOWioP860OginP861P7mmOGn1
Ph>0OG]lOh>5Ph1lNgb0PhB2OWalOh:3PGekO866R8=kM7=lR9:AQ7=WJ7V@X9f8
K5QKM9J^ZhiVBde]V[ZhUVA1@FJJ`<:LIShkH9O1a:5Z@CaNT[_0XFm9@f2=/;JM
M5E@IXVSZ9EhHUm^QYNIS7Y^KGN4S8b4NgMiOX>4PWilOH23Ph1lNgf1Q8B2OW]k
OX:4Ph1mO7eoPX:1OginOh21P7mnOh21PH1nOWj0PH:1OgimOX21PH1oOWioP860
OgmoOh20P7moOh21PH1oOWioPH61OginOh21PH1oOgmoP820OgmoOh20P7moOh20
P81oOgmoP820P7moOh20P81oOgmoP820OgmoP820P7moOh20P81oOgmoP820P7mo
Oh20P820OgmoP820P7moP820P7moOh20P820OgmoP820P820Ogn0P820P820P820
P820Ogn0P820P7moOh20P820OgmoP820P7moOh20P81oOgn0P820OgmoP820P7mo
Ogn0P820OgmoP820P7moOgn0P81oOgn0P81oOgmoP820P7mnOgn0PH20OgioP821
P7moOh20P81oOgn0PH1oOWioP861P7imOWn1PX5oOWenP861P7mnOh21P7mnOWn1
PX5oOGanPHB3P7ekO7n3QH=oO7]mPHB3P7elOX:3PGejNh67RHAkLW9kRI>BQ71T
JGfEXi^0HeEQPZBbXGYDAef:/kjRL4HnGYBn`imV?CaTWLC1UUhk@VjS`[N<FT5>
NJFiZH9KCEj1XJZINf9MKHJIVX]hK6eiQhj;PWUfNX25QH5mO7j1Ph5nO7f0PhB2
OW]kOX:4Ph1mNgf0PX>1OgenOh61P7moOh21P7mnOWn1PH5oOWioP8:1P7inOX21
PH1oOgmoP820OgmoP820OgmoOh21P7mnOWn0PH60OgioP821P7moOgn0P81oOgn0
P81oOgmoP860OgmnOh21PH1oOgn0P820OgmoOh20P7moOh20P7moOgn0P81oOgmo
P820P7moOgn0P81oOgmoP820OgmoP820OgmoOh20P81oOgn0P820OgmoOh20P81o
Ogn0P820Ogn0P820OgmoP820P81oOgn0P820P7moOh20P81oOgn0P81oOgn0P820
OgmoOh20P81oOgn0P820OgmoOh20P7moOh20P81oOgn0P81oOgmoP820P7moOgn0
PH1oOgmoP820OgmoP820OgmoOh21P7mnOWn0PH60OWenP862PGmnOWn0PH1oOgn0
PH1oOWioPH:1OgalOX:4Q81lNWb0Q8F2OW]lOh:3PGimOX63PWeiNX27RXIkLG1j
RYFBPVeSJh:KY9EfFeI]TZj]SF=8DGVW_ZamCSeHSK[3WfLn?fVRaK^;E3Y=P;72
Z7E;A6>B];>AIdiGN9b[WWmSG6b6VIZ;MVY]NhZ@RWmgMG^2QXB0O7aoPX9oOGao
PXB2OW]kOX:4Ph1lNgf1Ph>1OWenP861P7mnOh20P7mnOh21PH1nOWn0PH60OWin
P861P7mnOgn0P81oOgn0P81oOgn0P820OgmoP860P7mnOh20P81oOgn0P820Ogmo
P820OgmoP820P7moOh20P81oOgn0P820OgmoP820P7moOh20P7moOh20P7moOgn0
P820OgmoP820P7moOh20P81oOgn0P81oOgn0P820OgmoP820P7moOh20P81oOgmo
P820OgmoP820P7moP820P7moOh20P81oOgmoP820P7moOh20P81oOgn0P81oOgn0
P820OgmoP820P7moOh20P81oOgmoP820P7moOh20P7moP820P7moOh20P81oOgmo
P820P7moOh20P81oOgn0P81oOgn0P81oOgmoP860OginOh21PH1nOWj0PH60Ogio
P820OgmoP860OginOh:3PWmlO7j2Q8>0O7]mPHB3P7elOX62PGmmOX64PWeiNGn7
RhIkLG1kS9JAOfYRKhVOXH]ZEUenX[2NME5;JYVi/XQG@5B6]L2OJ454KjK3/Wm=
?U^@^KZDHTEANjJfX7IEDVfCZJ:5IeaYQ9VKRgEYKWf<T8UmMGEmQ8N4OWamP8:1
OgenPH>3P7akOX64Ph1lNgf1Ph>0OWanP8:1P7mnOh20P7moOh21P7mnOX21PH1o
OWj0PH60OginOh21P7moOh20P7moOh20P7moOh20P81oOgn0P820OgmoOh20P7mo
Oh20P81oOh20P7moOh20P81oOgn0P820OgmoP820P7moOh20P81oOh20P7moOh20
P81oOgn0P820OgmoP820P7moOh20P81oOgn0P81oOh20P81oOgn0P820OgmoP820
P7moOh20P81oOgn0P81oOgn0P81oOgn0P820OgmoP820P7moOh20P81oOgn0P820
Ogn0P81oOgmoP820OgmoOh20P7moOgn0P820OgmoP820OgmoP820OgmoP820P7mo
Oh20P81oOgn0P820OgmoP820P7moOh20P7moP820P7mnOh21PH1oOWioPH61Ogin
Oh21P7moOh20P7moOh21PGmmOGn2Ph5nO7aoPXB2OWalOh:3PWmmOH22PGmmOX64
PgiiNGn7RhIkL71mSIJ>NVMUMY6QVWiQF6b@ZjN6GTeOR[2dTV96Dh6__9iZADYe
Z;jWMDY6Jifi[81EBVFB/:^8HE9TR:>TS6eNIh6GVh]fJVinSI28NgAfOhJ7Pgek
OH22PGimOh:2PGilOH23Ph1mNgf1Ph>0OGanP8:2P7inOh21P7moOh20P7mnOh21
P7mnOWn1PH1oOWioPH60OgmoP820P7moP820OgmoP820P7moOh20P7moOgn0P81o
OgmoP820OgmoP820Ogn0P820OgmoP820P7moOh20P7moOgn0P81oOgn0P820Oh20
P81oOh20P81oOgn0P820OgmoP820P7moOh20P81oOh20P7moP820P7moOh20P81o
Ogn0P820OgmoP820P7moP820P7moP820OgmoP820P7moOh20P81oOgn0P820Ogmo
P820OgmoP820OgmoP820OgmoP820P7moOh20P81oOgn0P820OgmoP820Ogn0P820
OgmoP820OgmoOh20P7moOgn0P81oOgn0P820Ogn0P81oOgn0P860OgioP861P7mn
Oh21PH1oOWn0P81oOgn0P81oOWn1PH5oOGf0PX>1OWamP8>3PGelOH23PX1nOWn1
PGmmOX64PgiiNGn7RhIjL79oSiB:MFMZOiNNSW5MHWnNZ9=^E5YmY;2HK4iDO:Ne
Vfa;DG^X]Ya]C59jYK>KKe5GNZ2/Ug5HGW^JXi9dHVImTiV<Mf]_Ohb?QWYdMh27
Qh5lNgj1PX1nOX22PGmmOGn2Ph5nO7f0Ph>0OGanP8:2P7inOh21P7moOh20Ogmo
P861P7inOh21PGmnOWn1PH1oOWn0P820OgmoP820Ogn0P81oOgn0P820OgmoP820
P7moOh20P7moOgn0P81oOh20P7moOh20P7moOh20P81oOgn0P820OgmoP820P7mo
P820P7n0P820Ogn0P820OgmoP820P7moP820P7moOh20P820P820P7n0P820P7mo
P820P7moOh20P81oOh20P81oOgn0P820Oh20P81oOh20P81oOgn0P820OgmoP820
OgmoP820P7moP820OgmoP820OgmoP820P7moOh20P81oOgn0P81oOgn0P820Ogn0
P81oOgn0P81oOgmoP820OgmoP820P7moOh20P7moOh20P7moP820P7moOh21PH1n
OWn0PH1oOWioP860OgmoP820Ogn0P81oOWioPH60OWenP8:2P7elOX63PWmmOGn1
PX1nOX21PGmmOX64PgiiNGn7RXAiLGF2Si64LFUbR9VFPFQQLXnRVWaOFgBGZIYe
F5UiWjfGKU=KOjB/TFQCH8JVYhUUEVR;Y9n2IEiaSYjEOFQWNHjFS7Y^LGj;SHEj
MGV1QhF0O7]nPH:0OWj0PH1nOGj1PX5oOGeoPX>1OWenP8:2P7inOh61P7moOh20
P7moP820OgioP861P7mnOh21PGmnOWn0PH1oOgn0P81oOgn0P7moOh20P7moOgn0
P81oOgn0P820OgmoP820OgmoP820Ogn0P81oOgn0P820OgmoP820OgmoP820P7mo
Oh20P81oP820P7moP820P7moP820P7moOh20P81oOh20P820Oh20P820P820P820
P820P820P820P820P820P820P820P820P820P820P820Ogn0P820OgmoP820Ogmo
P820P7moOh20P81oOh20P7moP820P7moP820P7moOh20P81oOgn0P81oOgn0P820
Ogn0P81oOh20P81oOgn0P81oOgn0P820OgmoP820OgmoP820Ogn0P81oOgn0P820
OgmoP860OgioP861P7moOh20P7moOh20P7moP820OginP861P7imOh62PGmmOGn2
PX1nOGn0PH1oOh21P7imOX64PWijNX27R89hM7V5SX]nL6mkSIF;MVQ]PYNIQVaR
L8bOV7eSH7RFXY9bGFF3WZ27JEe^SJ2HOFASNI>MSWAUK8:EUHAaJgJ8TH]mLW=n
R8^4NgMkPXJ4OgalOh:2P7ioP820Ogj0PH60OWeoPH:1OgenP861P7inOh21P7mo
Oh20P7moP820OgmoP820OgmoP820P7moOh20P7moOh20P7moOh20P7moP820Ogmo
P820P7moOh20P7moOh20P7moOh20P81oOh20P7moP820P7moP820P7moOh20P7mo
Oh20P81oOgn0P81oOh20P7moP820P7moOh20P7moOh20P81oOgn0P820Oh20P820
P820P81oP820P81oOh20P81oOgn0P820Ogn0P820P820P820P820P820P820P820
P7moP820P7moP820P81oP820P820P820P7moP820P7moP820P7moOh20P81oOh20
P81oOh20P81oP820P7moOh20P7moOh20P81oOh20P81oOgn0P81oOh20P7moOh20
P7moOh20P7moOh20P81oOgn0P81oOgn0P81oOh20P7moOh20P7mnOh21PGmnOWn1
PH1nOWn0PH1oOWn0P81oOh21P7mnOh63PWikO865QH1iN7f6RXEkM7N2S8b0Lg1k
RY69N6ebPi:APFm[NHfFRgIZL8BDTh5^JgV=UHYgK7:3THn0LW1kRHn7NG9gPXZ9
P7QgOXF7PWajO864PWmmOH21PH1oOh20P7moP860OgioP861OginOh61P7mnOh20
P7moOh20P7moP820OgmoP820OgmoP820OgmoP820OgmoP820P7moP820P7n0P820
Ogn0P81oOgn0P820Ogn0P820OgmoP820OgmoP820Oh20P81oOh20P81oOh20P81o
Ogn0P81oOgn0P820Ogn0P820P820P7moP820P7moOh20P7moOh20P81oOh20P81o
Oh20P820P820P7moP820P7moP820P7moP820P81oP820P820P820P820P820P820
P820P7moP820P81oP820P820P820P820P820P820P820P7n0P820P7moP820P81o
P820P81oP820P820P820P7n0P820OgmoP820P7moP820P7moP820P7moP820P820
P820Ogn0P820Ogn0P820OgmoP820OgmoP820OgmoP820Ogn0P81oOh20P81oOgn0
P81oOgn0P81oOgn0P820Ogn0P81oOh20P7moOh21P7mnOX22PWmmOH23Ph1lNgj3
QH9mNWb2QXAoNGYoQHJ1NWQmQ8N3O7QkPXN5OgUiOhF6PG]iOH>6PgejO864Pgml
O7n3Ph1mOGn1PX5oOWj0PH1oOgn0P81oOgn0P81oOh20P7moOh20P7moOh20P7mo
Oh20P7moOh20P81oP820P820P820Ogn0P820Ogn0P820Ogn0P820P7n0P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820P820
P820P820P820P820P80\>"]},
  ImageCacheContents->"Sound",
  CellTags->{"ChitteringWarble", "G.3.5"}],

Cell[CellGroupData[{

Cell["Implementation", "SubsubsectionIcon",
  CellTags->{"ChitteringWarble", "G.3.5"}],

Cell[BoxData[
    \(\[Psi][{\[Alpha]_, \[Beta]_}, \[ScriptCapitalA]_, f_] := 
      If[\[Beta] > \[Alpha], 
        If[\[Alpha] < t < \[Beta], 
          Sin[\(\[Pi]\ \((t - \[Alpha])\)\)\/\(\[Beta] - \[Alpha]\)]\ \
\[ScriptCapitalA]\ Sin[f\ t], 0], 0]\)], "Input",
  CellTags->{"ChitteringWarble", "G.3.5"}],

Cell[BoxData[
    \(Play[
      Evaluate[N[
          Sin[\(\[Pi]\ t\)\/2]\ \(\[Sum]\+\(i = 0\)\%84 \[Psi][
                {i\/42, \(i + 14\)\/42}, \@\((i\/42 - 1)\)\^2, 
                \(1000  i\)\/7]\)]], {t, 0, 2}, PlayRange \[Rule] All]\)], 
  "Input",
  CellTags->{"ChitteringWarble", "G.3.5"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ", "GroupDivider"],

Cell["Riemann Zeta", "Subsection",
  CellTags->{"RiemannZeta", "G.3.6"}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.0238095 0.952381 0.0147151 0.588604 [

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

% Start of sampled sound

1 string

11025 33075 8

{ currentfile 1 index readhexstring pop }

 false 1 sampledsound

7778797A7B7B7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7B7B7B7B7B7B7B7A7A7A7A7A79797979

78787878777777777776767676767676767676767676767676777777787879797A7B7B7C7D7E

7F80818182838485868788898A8B8C8C8D8D8E8E8E8E8E8E8E8E8D8D8C8B8A89888786858382

817F7E7D7C7A797978777776767676777778797A7B7D7E8081838586888A8B8D8E8F90919192

92929191908F8E8C8B8987868482817F7E7C7B7B7A7A7A7A7A7B7C7D7F8082848688898B8D8E

9091929292929291908F8D8B89878582807E7C7A7877757574747475757678797B7D7F808283

858686878786868483817F7D7A787573716E6C6B6969686868696B6C6E707375777A7C7E8082

83848484848382807E7D7B7977767473737273737476787A7D808285888B8D8F909192929291

8F8D8B888683807D7B797775747474747577787A7C7E7F81828383838382807E7C797673706D

6B69676665656567686B6D7073777A7D80828486868787868583817F7D7B7978767676767778

7A7C7F818486888A8B8C8C8C8B898684807D7976726F6D6B696868696A6C6E7174777A7C7F81

828384838381807E7C7B7978777777787A7C7E8285898C8F939597999999989694918E8A8683

807D7A79787878797B7D7F828487898A8B8C8C8B8A888684827F7D7C7B7B7B7C7E8184878B8E

9295989A9C9C9C9B9996928F8B87837F7C797776767677787A7C7E808182838382807E7C7977

74716F6E6D6D6E6F7275787C8084888B8E909191908E8C8985817E7A7775737272737476787B

7D808284858686858482807E7C7A797878797B7D8084898D92969A9D9FA0A1A09E9C9895918C

888582807E7D7E7F80828486888A8B8B8B8A888683807D7A7876757576787A7D8184888C8F91

939393918F8C88837F7A7673706E6E6E6F717376797C7F82848585858483817F7D7C7B7B7C7D

8083868A8E9396999B9D9D9C9A96928E89847F7B77757373737476797C7F8184858686858381

7E7C7976747372727375777A7D808284858584827F7B77726D696562605F606164676C70757A

7E8284868787868482807E7C7B7B7B7C7D80828587898A8B8B8987837F7A76716D6967656566

686B6F73787C80838687878684827E7B787472706F70717275777A7D7F818282817F7D7B7876

7473737476797D82878D92979B9EA0A09F9C9995908B86827E7B7A79797A7C7E808283848483

817F7C797673717070717376797D8185898B8D8D8C8A87837E7974706D6A69696B6D7175797D

8185878889888684817E7C7978777778797B7D7F818282817F7B77726D68635F5C5A595A5D60

656B70767B80838586868583807E7B79787777797B7E818487898A8B8A898784817D7A787776

77797C8085898D9194959594918D88827C77726E6B69696A6C6F73777A7D7F818181807E7C7B

7979797A7C7F83868A8E909292918F8B86807A756F6B68666566696C71757A7E818384848380

7E7A77757372727375777B7E8184868788878583807E7C7A7A7B7E81868B91979CA1A4A6A6A5

A29D98928C86817E7B7A7A7B7C7F8184868787878583817F7C7B7A7B7C7F82868B8F93959797

96938F8B85807B7774727273767A7E83888C8F9191908E8B87837F7C79777777787A7D7F8283

848483817F7C7977767576797C81878E949A9EA2A4A4A29F9A958E88837E7A787677787A7C7E

808181817F7C797673706E6E6E6F7275797D8082848483807D78746F6B686767686C70767C82

878C8F9191908D8985807C797675747577797C7E808181817F7D7B78777676777A7E848A9096

9B9FA2A3A29F9B96908A847F7B7978787A7D818487898B8B8A8885817E7B797777787A7D8084

87898B8B8A8885817E7B7978787A7D82888F959CA1A4A6A6A4A19C96908A85817E7C7C7C7E80

828485868584827F7C7A7878787A7D81858A8E91939493908B868079736E6B6868696C707579

7E8284858583817D797572706F6F7173767A7E818384858483817F7D7C7C7E81858A8F959B9F

A2A3A2A09B958E867F7973706E6D6F7175797D8082838483817F7D7B7A7A7B7D8083878B8E90

908F8D8A85817C7875737375787C82878C90939494918D88827C77726F6D6D6E7174787C7F81

8282817F7D7A78777677787A7D8082848483807C767069625C57545354575C626970767B7F82

8282807E7B79777677797B7F8386898B8C8C8A8784807D7A79787A7C7F83878A8D8E8D8B8781

7B756E6965636365696E747B81868A8C8D8C8A8784807D7B7A7A7B7C7E808181807E7B77736F

6B6968696B6F757B82898E929495938F8A857F79757270707275797C8083848584817E7A7774

7170707274777B7E81828382807E7B78767576787C828991989FA5A9AAAAA7A29C958E87827E

7B7A7B7C7F818385858483807D7B78777677797C8084878A8B8B8985807A746E6A666566686C

71777D8285878786827E79746F6C6A6A6B6E72767A7E81838383817F7D7B7A797A7C7F828588

898987847E787169635E5A595A5D636971787F85898B8C8A8885827F7D7C7C7E808285878888

8784817C7873706E6D6E7174787C7F8182807D79736D68635F5E5E61666C737A81868A8C8C8B

8884807C79777677797B7E8183848483827F7D7C7B7B7E81868C93999FA3A5A4A19D968F877F

797471707173777B7F82848483817D7976737170717376797D8183858584817E7B7876767679

7C81868A8E90908E8A847D756D66605D5C5D60656B72787D8184858483817F7E7D7E7F818487

8A8B8C8B8884807B7773717173777C82898F9498999895918B857F7A76747476797D8185888A

8B8986837E7A7774737375777B7E81838383827F7D7B7A7A7C80868D959DA4AAAEB0AFACA69F

978F88827E7C7B7D808386898B8C8B898684817F7E7F8183878B8E9091908E8A86807B777473

73767A7F858A8E90918F8B857F78726D6A69696C71767C8185888989888582807E7C7C7D7F82

8486878785827E7975716F6F71757C838C949CA2A6A7A6A29D968F89837F7D7C7D7F81838585

84827F7B76726F6E6E6F7275797D80828382807D7976747374787C838990969A9D9C9A958E87

7F78726E6C6C6E72767B7F82848483817F7C7A79797A7C7F81838483817D77716B65615E5E60

656B727A81878B8D8D8A86817C7774727274777B8084878A8A8987837F7C797878797C7F8386

898A8B898784817F7E7F82878D959DA4AAAEAFAEAAA49C938A827C77747475787B7E81828281

7F7D7A7878787A7D8185898C8D8D8B88837E7976737375797E858C92979A9B9996918B857F7C

797A7C7F84898E92949593918D8884807D7C7C7D7E80828282807D7975726F6F70747A818992

9AA0A4A5A39F999189827B77747475787B7F82848584827F7C7A7878797C7F84888B8E8F8E8B

88837E7A787677797D82878B8D8E8C88827A726A635E5B5B5E62686E757A7F8182817E7C7977

7676777A7D8082848483807D7A787677797D848B949CA2A7AAAAA7A19A928A837E7A797A7C7F

838688898885827D7976747374777A7F8387898A8A888582807E7E7F82868B8F939696948F89

81787069636161646970777F858A8D8D8C898683807D7C7D7E80818282817F7B77726E6B6A6A

6D72777E83888B8C8A86807A736D686666686C72787E8386878684807B777371707274787C80

8486868583807D7A7978797C7E81838483807B746B6259524D4B4C50565E6770797F83858584

817E7C7B7B7C7F8286898B8B8B8885817E7B7A7A7C8084898E919393908C87817B7673737478

7E848B90949695918C857E78726E6D6D6F73777B7E8182817F7D7B7979797B7D818486868582

7D777069635F5E5F646A737C858C92959694908A857F7B7877787A7D7F8182817F7B77736F6C

6B6C6E72767B7F82848482807D7A79797C80868E959DA2A6A6A49F978F867E7772707073777C

808487888785827F7D7B7B7C7E8082848584827E79746F6C6B6C6F757D858E959B9E9F9C9892

8B85807D7C7D8084898D9091918E8A85807B78767577797D8082848482807C79767575777A7E

8286898987837C73696057514E4E51565E666E767C7F81817F7D7B7979797B7E818385858481

7D7874706E6E6F73787D8286898986827C766F6A6766686C727981878C8E8E8C88837D797574

74777B7F84888A8C8B8A8784817F7F7F8183858686837F7971696059555254585F67717A8389

8D8D8C88847F7A777676787B7E81838483817E7A77747374767A7F84888B8C8B8985817C7977

787A7F848B90959796938D857C736C66636365696F767C8084858583817F7E7E7E808387898B

8C8B8885807D7A797A7E848B939BA2A6A8A6A29B9289807974717173767A7D80807F7D797470

6D6B6C6E72767B8083858584817E7B7978797B7F8386888886827B736A625B5654565A616A73

7C83888A8A8884807C787676777A7C7F818281807D7B7978797C80868C92979A9B99958F8881

7B7776777A7F868C92959795928C867F7A767474777B7F838789898885817D7A777777797C7F

818382817E7A76747374787F87919BA5ACB0B1AFAAA2988F86807B79797A7D80828383817E7B

787676777A7E83888C8E8F8E8B87837F7D7C7E82878D93989B9C9A968F88817B7675767A8086

8D93989A9996928C86817D7B7B7C7E8082848483817E7C7B7B7C80858A90949696938E867C73

6A635F5D5F646B727A8085878684817C79767576787B7F82848584817D7874716F6F7174797D

8285868583807D7B7A7B7F858D969FA7ADB0B0ACA69D938A827C7877787B7F8284858583807D

7A7877787A7C7F8182817F7B76706C6968696E757D868E95999A98948D867F79757475787C80

84878786837E78736F6C6B6D7074787C7F80807E7C7A7877787B7F83888B8D8C89837B726962

5D5B5D6169727C868D939595928E8A85817F7E7F8082838382807C7874716F6F71767B808689

8B8B88837E7874717174787F868E93979896918B837C76727172757A8085888B8B8986827F7C

7A7A7C7E81848687878583807E7E80858C959EA8B1B7BAB9B5AEA49A9087817D7C7D80848789

8A8986827E7A7877787A7D818587888784807C7774727375797E8286888885817B746F6B6A6C

7078808A92999D9E9C98918A837E7A78787A7D808384858482807E7D7E8084888D909292908B

857E77716E6E70767E8790989DA09F9C979089837F7D7D7F828588898886817C77726F6E6F71

757A7F8284858482807E7E7F82868C92979B9B99938B80756B625C595A5E646C747B80838382

7F7C797777787A7E81838484827F7C797777797D83898F95989996918A837B74706E6F73797F

84888A8A86817A746E6968686B70757B7F828382807D7A7877787A7D818486878684807D7A79

7A7F858E98A2ABB1B4B3AEA69D92887F797675777A7E81848584827F7D7B7B7C7F84888D9091

918E8A857F7B7877787B7F84878888847E776F67615E5D60666D757D83878987837D77726E6C

6C6F73777C7F818282807E7D7C7D7F8386898B8A87827B726A625D5A5B6067707A838B8F918F

8C86807B777576787B7F83858584817D787472717275797E82848584827E7975737273767A7F

828484807A72685E56504D4E535B646E7880868989888582807F7F818386888A8A8885817D7A

79797C80858A8D8F8E8B857D746B64605E60656C747C82868887847F7A767474767A7F858A8D

8F8E8B86827D797777787B7E808282807E7B7877777A8088919AA2A7AAA9A49C92877D746F6C

6D70767B818587888683807D7B7A7A7C7E8081817F7B756F6A666464676B71777C80807F7B75

706A6766686D757D858C9193928E88817A7471707174787D81848584827E7B7978787A7C7F82

8383817D7975717072777F89949FA9B0B3B2ADA69C9289827D7A7A7C7F818282807D7974716F

6F71757A7F8487888784817D7A78787B7F84898D8F8E8B867F78726D6C6E737B848D969C9F9E

9B958D867F7A7877797B7F81838382817E7C7B7C7D8184888A8B89857F776F68636162666D76

7F868C8E8E8A847D76706D6B6D70757A7E8081807D797572707174787D83878A8B8A8884817E

7D7D7F81848686847F776D62584F4947494E57626D767E838584817D7976757576797C7F8181

7F7C7976747475787D8286898A88847E77706B68686B707880888E91928F8B857F7A77777A7F

858C92969897948F89837F7C7B7C7D7F8182817F7C7875737375797E84888B8B8882796F645A

534F50545B656F788085878785827F7C7B7C7E8184868685827E7974716F7073787D83878A8B

8986817D7A7A7B80868D959B9E9E9B948C8278706A68696D72787E828484827F7B7875757678

7B7F82838483817F7E7F82878E969EA4A9AAA7A1988D8277706B6A6C70767D82858684817C78

757373767A7E8386888785817C78757374767A7E82848584817D797574767A808890979B9C9A

948B80756B635F5E60666C737A7F8182817F7D7C7C7E808386878786827D78736F6E6F73787E

84888A89857E756C645F5C5D61676F777D8283827F7B77747373777C82888D9091908D898481

7E7E7F818486888786837F7C7A7B7F858E99A4ADB4B8B7B2A99F9389807A77787B7F83868888

86827F7B7978797B7E818384827F7B76726F6E70747B82888E91918F8B85807B797A7E858D95

9CA0A2A09A938A827B767475787C818587888784817E7C7C7D7F828587888784807C7977787C

838C96A0A8ADAEABA59B90857B74717072767B80838484827F7D7C7C7E82878D92959695928D

88837F7D7D7F8284868684807A736C67646569717A848D939797938D857C756F6C6D70747A7F

83858584827F7D7D7D7F8284868684807B756F6B6A6C7179828B93999B9A958E867D76727172

767C8186898987837D7874717072767A7E828383817D797572717274787C7F81817F7C787574

757A828D99A6B0B8BBBBB6ADA3988D857F7D7D7E81838484827F7C797676777A7D8184858481

7C77726E6D6E72777E858A8D8C89827B726B666465696F767D828484807B756F6B69696C7177

7D8285868583807D7B7B7B7D7F81817F7C77706A66636469707B8690999E9F9C968D837A736E

6D6F73787D8184858482807E7D7E81858A8D90908E8A857F79757373767A7E828484827E7872

6D6B6C7178818B959CA0A09C968E857D77737375787C80838483807D7A79787A7C8083868786

84807D7A797B8189939EA8B0B5B6B2ABA2978D847F7C7C7F8386898988847F7A76747375797F

84898C8D8B8885817E7D7D8084878B8D8C8A85807B7877797F87919CA4ABADABA59D92887E77

7373757A7F83878988878481807F808284868786837E78726C6867696D737B81868887837C75

6D686565696F7880888D8F8F8C87827E7C7B7E82878C909292908C87827E7C7B7D7F81838483

807D7977777A7F88939EA8B0B4B3AEA59A8E8278716E6E71767A7E80807F7C79767576787C80

84868786827E7A767474777C82878C8E8D8A847D756F6C6B6E737A81868A8A8680776F67615E

5F62686F777C818282817E7C7C7C7E81858889898784807D7B7B7E848B939BA0A2A09A908579

6E65616063686F777D828383817D7A79797A7E8286888988847F7A74706F6F72767C80838584

82807D7C7E8289929BA4AAADACA79F94887E75706F71767C8286898987847F7B787778797C7F

8081807D7B7877787C828991989D9E9D978F857C736E6C6E737A81888D8F8E8A85807B78777A

7E83898D90908D89847F7B79797A7D80838484817E7976737375797E8387888680776B5F544B

46464A525D68737B818484827F7D7B7B7C7E818283827F7A75716D6C6E71767B808383817D77

716C69696D737B848C9194928E878079737172757B82888C8F8E8B86807A777575777B7F8284

8483817F7E7D7F82868A8D8E8B857C716459504A4A4D545E69737B8082807C7873706F707377

7C808282817E7B7978797D82878D9193928F8A847F7A78797C8084878887827B7269625E5D60

67717C878F959795918B85807C7B7C7E8183858583817E7B7A7A7C8084888A8A87827C756F6B

6B6F76808C97A0A6A8A6A0988F867F7B7A7B7D808282807C77716C69686A6E747A7F83858583

807D7B7A7B7E82858888858079726B6664676D76828D979EA19F9A9289807873717275787C7F

807F7D7A787676777A7D8081807D78726B666362656B737C83898B8A868079726E6D6F747B83

8B9092928E88827B777575787C8185878785827D79767576797C8083848482807E7D7E838B95

A1ADB7BDBEBBB4A89B8E837A7574767A7E82858584817E7B797A7C7F8387898986827D787370

7072767B808384827D77706A6766696E767F878D8F8E8A837B746E6C6D717880878E9192918D

8984817F7F80818282817E7A76737172757B82898F92928D857B70665E5A5A5F667079818789

8986827D7A78797B7E82848584807B76716E6D6E72777D81848584807D797777797D82868989

867F75695D524B48494F58636E777E8182807D7A7877797C808487888785827F7D7C7D808487

8A8A87827A7167605B5B5E656E7982898D8E8B86807B7776787C82888C8F8F8C87817B767474

767A7E82858685827F7C7A7A7B7E82858786837D756D656160636B76828E99A0A3A19B938A82

7B7776777A7D808282817F7D7C7D7F83888D9193928F89827B76727274787D818483807A7168

605B585A5F676F787E82827F79736D69686A6D73797F828483817E7B7878787B7E808282807D

7A7776777D85909CA8B1B6B6B2A99E91857C757373777B7F8283827F7B77757476797E838789

898784807C7A7A7D81878C919393908B86807D7C7F848A91969998938B807469605C5B5F656D

757C818383817E7B7A7A7B7E81838484817E7A7877787C81878D9293918B82786E666261656C

7680898F92928E89837E7A797A7D80838584817C76706B69696C70767C80838382807E7E7E81

868B8F92918D867B70645A5453565D67737E868B8D8B86817B777576787C8083858483817F7E

7E81858A8E9192908C857E77727172777F8790969998948E867F7A797A7E858C929697959089

827B777575787C80838584827F7C7A7A7B7E82868A8B8B8884807D7D8087929EABB6BEC2C0BA

AFA39589807A78797B7F8182817F7C787676787B808488898986817B76727172757A7F838484

807B746F6B6B6E747D8790979A99948D847C767272757B82888D8F8F8C8884807D7C7D7F8284

858482807E7D7F838A939CA4A9ABA8A1988C8178727073798189909495938F89837F7C7C7E81

85888887847F7A767373767A8085898B8B8985817D7B7C7F83878A8B89837B70655B5553565E

6875818B929695918C87827F7E7F80828383817E7A76747374777C808384827E79726D6A6A6E

76808B959DA1A19D968E857F7A797B7F83868887837D77706B68686B70767B7F8282807D7A79

787A7D80838585827D78736F6F737A85919EA8AFB2AFA89E92887F7978797D82868A8B8A8783

807E7D7E80828484827E79726C6867696D747B82878988847F7A7776787D858E979DA09F9A92

897F77727072767C81858685827E7975737375787B7F81817F7D7B7A7A7D81878D9192908A7F

7265584F4A4A4E57616C767D8182807C797676777B7F828484827E79736F6D6E70757A7F8283

827F7C7876777A80868D939695918A827A74727379828C979FA5A6A49E958D857F7C7B7D7F82

848483817E7C7C7E8185898C8D8B87817A736F6E70767F89939A9D9C988F867C75706F71767C

81868786837F7A7776777A7F85898C8C8985807B777576787C8083858583807F7F8188919CA9

B4BCC0BEB8ADA092857B7674767A7F83868684817D7A7878797C8083858583807C7A797B8086

8E94999B99948D847D7775767B828A919697959089827C78787B80878E939696928D86807B79

787A7C7F80807E7B78757475777C81858786827B7268605B5B5F6874828F99A0A29F9A928A82

7D7B7B7C7E80807E7C78757373757A80878D90918F8B86817D7C7D8085898C8D8A857D756D68

66697079848D959998948D857D777373767B8084878786837F7C7A7A7C7E81838483807D7A78

797E85909BA6AEB2B2ADA3978B80777372757A7F838584817C76716E6D6F73787D8081807D78

7471707174797F83868684807C7977777A7F85898C8B867D7164584F4B4B505964707A828687

85817D7A79797B7E818383817F7C7A797B7F858B919596948F89827D7A7B8087919AA1A6A6A1

9A90867E7876767A7E828484827D77716C6A6B6F757C82878989888582807F8083858787847F

79726C696A6E7783909DA6ACACA79F94887E777474777C8084868583807C7A7A7B7E81848686

84807B767372757A81888F9394928D87807B797A7E858C929696928B81776D6764666B727A82

878A8A8885817F7F8184878B8D8D8B8784807E7E8083868989857E74675B50484648505B6875

7F86898985807B777677797C7F81807D79746F6C6C6E73787E83868785817C797777797D8184

84827C746B625B58595F68737E878C8E8B857D756E6A696C71777C81838482807E7D7D7F8184

8584817C756F6A67686D757E878F93938F887F766E6A6A6D747C848B8E8E8C87827D7B7B7E82

878C8F8F8D89847E7A78797C7F8387888785817D7A7A7B7F84888B8A857C706153473F3D3F47

535F6C767D8181807D7B7B7C7F838689898884807C7A797A7E82878A8B89847E77726F70747B

858E969A9B99938B837E7B7C80868D949798958F877F79757375797E8386888785817E7C7C7D

80828483817C76706C6A6C727C88949EA5A6A39B91857A716D6C70757C8286878684807C7A7A

7B7E8082827F7A746D686463666B71787D80817F7C7977787C838B949BA0A09B93887C726A66

676C737B83888A8986817C797777797D808283817F7C7977787A7D818484827C746A60595657

5D6875828E979B9B97918A84807F8083878A8A88847E77726E6D6E72787D818383817E7B7979

7B7F858A8D8F8D8A857F7C7B7E848E99A4ACB0AEA89E918478706C6B6F747A7F828382807E7D

7D7F818587888885807B7775767A80888F959897938C847D7776787E8790989D9E9C968E867F

7B797B7F83888A8986817B75716F7073777C81838382807D7B7B7C7F8284837F786D60544942

41454E5A687681898B8A86807A7775777A7E82858685837F7D7B7C7F83888C8E8D8A857E7975

74757A80878C8E8D89827A736E6D6F757C848B8E8E8A82786E666261636970777D8081807E7C

7A7A7C7E81848483807B77737172757B81878A8883796D60544B47484E58636F797F8282807D

7A797A7D8184878786817C7672707073797F84888A8986827F7D7D7F83888C8D8B857D726860

5B5B606A76828E969A99958F88827F7E7F83878B8D8C8A8783807D7D7E7F81807E7A736C6661

60646B75808B939797928B837B7573757980878D90908D87817B7776787C81868A8B8986817C

7977787A7F8386878784817D7C7C7F848B9094938F86796B5E534D4C505965727D868A8B8985

817E7D7D7F818282807D7974717072767B82878B8B89857F7B78797C838B939A9D9B968E847A

726E6D70767C828585817B746C676465696F767C808383817F7D7C7D808386888886827E7B79

7B818A96A3AEB5B8B5ADA294887D7775777B82878B8C8A87827E7B7A7C7F82858786837F7A77

75767A7F868C9192918D88827D7B7C7F83888A89857C716559514C4D535D68737D838685817C

787675777A7E818382807D7A7776777A7E8182817D7770696564676E7986929CA2A29E968C82

79737173777B7F82817F7B77737274787F868C9091908C86817D7A7A7C7E80807F7B76706C6A

6B7078828B9296948E84786C625C5B5F67717B83898B8A87837F7D7C7E80828383817E7B7878

797E848B92979896918A827C79797D848C959B9D9C978F867F79787A7F868D939695918B857F

7C7B7C8084888A8A88837F7A7877787B7E8181807D797675777E8997A6B4BFC5C6C0B6A89A8C

827C7A7B7E818383817D79757374767A7E828484817D79757374787D84898D8E8C87807A7675

777D858D949797938B8279726F70757D868E949796928B847E7A797A7C7F828382817E7D7C7E

81868A8E8F8D8880776E6866686F798590989C9B958C8278706C6C6F74797E8182807E7C7B7D

80868D93979897938D87827F7E8083878A8B8A87827E7C7D828A949EA7ADADA99F9385786E68

676B71787F848685827F7B7A7A7B7F82848584827E7A78787A7D8286878680786D6258525155

5C67727C838685817C777373757B81888C8E8D88827B75717072757A7E8181807C7976757679

7E82868786827E7977787D86919FABB3B7B6AFA395877B736F7073787E828383807D7A79797B

7D8081807D78726C6867686D747C82878886827D7977797E87919AA1A5A49F968D837C78787C

81878C8F8E8A847D77737273777C818486868481807F80838688888680786E655E5B5D64707E

8C99A1A4A29B9289807A78797C80838584817D78757374777C81848584807B76727071757A80

848686827D77716F6F737A81878B8A857C706459524F5259636E788085868583807F7F818386

88898784807C79797A7E83878987837B726A6360626973808D979D9F9C968D857E7B7A7D8185

878785817C777373757A80878C8E8E8B87827D7B7A7C7E8182827F7A757271737A8592A0ACB4

B6B3ABA093887F7B7B7E848A8F92928F8A85817E7D7F81838383807D7977777A7F878F969A9B

979189807A76767B81898F93938F887F766F6C6C70777E85898987827B75716F7073787D8082

817F7C7978797C8185898B8A87837F7D7E848D9AA9B6C0C6C5BEB2A495887E79787A7D818485

84827F7E7E8084898E9192918C86807B78787B7F83868785807A736E6C6D727A828A90918E87

7E756D69696E767F888F9393908A837E7A797A7D8083858483807E7C7D7F82858786837C7369

605B5A5E6773808C959998928A827A7675777D83898D8E8D8985817E7E8084888B8C8A867F79

736F6E70757A7F838584827F7E7F838A939CA3A7A69F948676695F5A5B6069737C8286868480

7D7C7C7E818588898886827F7E7E81868B9092918D877F787372757D87939DA4A6A49D948A82

7B79797C808384827D766F686464666C737A7F838482807D7B7B7D8084868785817C77737376

7C858F979C9C968C7E70625954555A636D767C80817F7C7977787A7D808282807D7875737478

7E858C9192908B847D777475787E84888A8781786E655F5E6067717C858B8E8D88827D797779

7C8186898A8885817D7A7A7B7D808383827F7C7A7A7E86919FADB9C0C2BEB5A8998C817B797B

8085898B8A87827E7A797A7D81858787847F7974706E7074797E8182807C77737171747A8188

8C8C8981786F6763646A747F8B94999A968F867E77747375797C7F80807F7E7D7F82868B8F91

918D87807A7675797F8890979A9892887C70676161656C747C828484817D7A78797C82878C8E

8E8A857E78747273767A7E8181807D797777787C818587857F7567584B423E40485462707C83

8786837F7B797A7D818588888784807C79797A7C7F81807D787069636162676F7982898C8B86

7F77716D6E727981888C8C888178706A66676B71787E8283827F7B7876777A7E81848583817D

7B7A7C81878D919390887D70645A55565C6875838F979A98948D87827F7F80838484827F7B77

76767A80878D9294938F89837E7B7B7D808384827D756B625B58595F69747E868988837B736C

68686B727A8186898986837F7D7C7E8083858684827F7C7C7E838A92989B9993887B6D615956

59606A757E848684807B767474777C8287898985817B777475777B80848584817C7773717276

7B81858786837F7B7A7D848F9DABB7BFC1BDB4A7988A807977787B7F838483807D7A79797B7F

828484827E79757272757B81878B8C8881786E67636368717B858D90908B847C75717072767B

7F807F7A746D676464676C73797E80817F7D7B7B7C7F828484827C746C6561626872808E9BA4

A7A59E93887E777475797F858A8C8B8884817F7E8082848584807B756F6C6B6E747B82878988

847E787372737980888E908F8981776E686669717A848D9395938E88827E7C7C7E8184858380

7C78757476797C7F81807D7874717176808D9CABB7BDBEB8ADA091857C7776787C7F807F7C78

757272757A80868A8B8A86817C7977797D82878A8B8A86817E7C7E828991979B9A958C80756B

66656A737E89919696938C857F7A797A7D8083858483807E7D7E808386878580786E655D595A

5E6770798082807A7168605D5D626A737C838686837F7B78787B7F85898C8B88837C77737273

777C808383827F7D7B7B7E83888D8E8C84796A5C4F464448515E6D7A858B8C8A86817D7B7B7D

808283827F7B777574767A7F84878785817C7774757A818A92989B9992897F766F6D6F747A80

8484817A726A6462646A717A8287898884807D7A7A7B7E8081807D7974717071757A7F82817C

73685B4F474448515E6C7A848A8C89837D787575787C80838584827F7E7E80848A9095969590

89827B7775777A7E8283827E78737070757E8A97A2AAADABA3998D837B78797D82878A8B8884

7E79767576787C7F807F7E7B7A7A7C80868B8F908C84796C615855575E6976828B90908C8680

7A78787B8084878785807A74717073787E84888A8986827F7D7D8084888C8D8B87817B767578

7E868F969997908475665A5250535A646F787E8181807E7D7D7F8285878784817C7876777A80

868C90908D867F787372767D8790989C9C968E847A737071757A808485837E78716D6C6D7278

7E838584817D78757475787C7F80807F7D7C7D828A96A3B0BABEBDB5A898887A716C6D72787F

848685817C787676787C8084868583807E7C7E81878D929595918B837B757374787E83878783

7C746B6563666D77818B91928F887F766F6B6B6E73797E8181807D7B7A7B7D8084868684807B

767475797F878D91908A807264574E4B4E57626F7A82868784817D7B7B7D808384837F79726C

6867696E757C818484827F7D7C7D81868B8F908D877F766F6C6E747F8C98A2A7A7A2998E847C

78787B8086898B8A8783807E7D7F81838584827E7B78787C828A939A9E9D978D81756B656468

6F777E8383807A736D69696C727A81868887847F7B79797C80868B8D8D8B86827D7B7B7E8185

878784807C79797E8795A4B4C0C7C7C1B6A7988A817C7B7E828689898784807E7D7F81858788

86827D77737273787E858A8D8C89837D79787B838C97A0A6A8A49D948B83808084898F939390

898178706C6A6D72777C8081817F7D7C7C7E81848685827C76706C6D727B87939EA4A49F9588

7A6F6866696F77808689898683807E7F8286898C8C8A86817C7A7A7D82898F9293918B857F7B

797B7F838686837C7369615C5C626D7A88959DA09E989088817D7C7E81838584817D79767576

797D81848583817E7D7F848D98A2ABAFAEA79C8D7F736B686B717981868988847F7B797A7D82

878C8D8C88817B75727274797E828484817E7B79797B80848787847E756B635F6066717E8B96

9C9D9990857A726D6D70767C81848483807E7D7D7E8082827F7A736C666364686F777E838583

7D766F6B6B6F77818B949898938B827A7473757A80858888857F7973706F72767C8184858481

7E7B7B7C8083868786827D797779808B9BABBAC5CAC9C0B3A49588807C7B7D808282807B7773

717275797E8182817D7874717173787E828584807A726B67666970787F8485827C746C67666A

737E8A949A9C99938B827C79797B7F82848583807D7B7B7C7F828484827D77716D6D7179848F

989D9D988E81746A6463676F7881888B8A87827E7B7B7C7F8283837F79736D69696B71787F85

88888683807E7F818588898781776B5F55505057626F7D888F908D867D75706E6F73797E8182

807D7A7878797C808283827F7B7776777C848D969D9F9C958A7E746D6B6D747D868D91918D88

827F7E81878E95999A98928B847E7A797B7E8182827F7B76737274777C818585837F7A77767B

8491A0AFBAC0C0B9AC9D8E81787374777C80838482807E7D7E8185898B8C8985807B77777A80

878E9294928D86807D7D808790989D9E9A92887C736D6C6F767D84898986817A74717174797F

85898B8A8783807F7F808283827F7A74706E707783919FABB3B4B0A6998B807875777D83898D

8E8B86807B78787A7D8082827F7B76727172767C83898D8E8B87827E7C7E82888E9292908981

7A747377808C9AA6AEB1AEA69C90867F7B7C7E8285878684827F7E7F8285898B8A87827D7875

75797E85898A877F7365584E494A505B68747D8284827E7A79797D82878A8C89847E77716E6F

72777D828585837F7C7A7A7C80848686827C756F6B6B717B8998A5AEB1ADA5998C807875767A

8085888986827E7A78787A7D8081807E7B78787A808891999FA19E988F857E7A7A7E848A8F90

8D867C72696463676E777F848684807A74717073777D828585837F7B7877787B7F8284848380

7D7D7F86909CA7AFB2AFA5968574675E5B5E666F7880848483807E7D7E8084868786817C7570

6D6D71767C818383807B777474777E858C90918D867C726B67686D757E858988837A7066605E

60666D767C818281807E7D7E818487888885817D7B7B7F868E959A9B978E8174685F5D606772

7E878D8E8B857E797576787D82868786827E7B797A7E83898E91908C87807B78787A7E828586

85827E7D7E848E9BA9B6BFC1BDB3A4948579727072767C7F81807C78757373767A7E8182817F

7C7A7B7D82888D91908C857B726B686B727C88929A9C9A938A827C797A7D83888B8B87817A74

706F72787F868B8D8B88847F7D7C7D7F81817F7A756F6B6A6C727A83888A877E7264574E4B4E

5663717E888D8D8B86817D7C7D7F818383817E7B79797C8289909597959089827D7A7B7F8489

8C8B877F766D6765676E78828B8F8F8A8178706A696B71777E8283817D78757374767B7F8182

817E7B79797B7E8183827C726455473C3739414E5E6E7A828584807B7775777A7F848686837E

79757273767B7F8383817D7873707074798086898A88837E7B7B7E848D969C9E9B9387796D64

61636A747F898F918F8A847F7C7B7C7E8081807E7B7877787B81868A8C89847C746D696B7079

838C92928E85796D635E5D616871797E81817F7C7C7D82888F96999A969089827D7A7B7D8184

8584827F7C7B7D81878D90908A807364574E4B4F586674828B908F8B857E7978797C80838483

817D7A78787A7E828484817D77726F70757D879097999790877E767272767D83888A8780786E

6764656A727B84898C8A86827D7B7B7D8184868684807B7876777A7D8082807C756E69696D77

8697A8B5BDBFB9AFA19489827F808386898987837F7C7B7C7E828586847F78716A6766696F75

7B7F807E7B7877787E8690989E9F9B93877B716B6B6F7680888D8E8B847C75706E6F74797F82

8483817E7C7B7C7E80807D79726B6562646A737F8A9296938C807368615E616871798083827E

79747272757A7F8384837F7A75717072767C818485827E79757373777C808383807B75706F73

7C8999A9B5BDBDB7AC9D8F837B78787A7E8181807E7B7A7A7C8085898C8C8985817E7D80848A

9092918C83786E6663656C76818B91939089827B7675787D83878987827B736D6A6B6E747B80

8484837F7C7A7A7C80838585827E7A77787D8794A2AEB6B8B4AA9D8E817874767C848C919492

8D87817D7B7B7D7F80807E7A777575797F868D9294928C847C757272757A7E807F7A7269605B

5B606975808A8F8F8B847B74706F72787F84888886827E7B7B7C7F82848583807B777676797E

8284827C716254473F3E434F5E6F7D888E8F8B86817E7D7F82858685817C75706E6E72787E84

878785817C79797B7F84888988837C756F6C6E737B848A8D8A8276695D5451535B66717C8285

85817D7A797A7C8083858583817F7F81858A8F92928D867C736B68697079848D92928D857A71

6B696B717A82878A88847F797676787D818485837D77706B696A6E747A7E80807F7D7C7E8186

8B8E8E897E706153484447505E6F7E8990928F89837F7D7E8185898A8987837F7D7D7F828688

88858079736F6F727880878B8B867E756C6563666D7680878B8A867F79757579808A939A9E9D

989088827D7C7C7E8181817E7B7877787B8085898A88847D7874757C8694A2AEB4B4AEA29384

776F6B6D72787E8182807E7B7A7C7F83868988857F78726E6E71767D828686837E7974727377

7C818280796F63574E4B4D56626F7B848786827B75717173787E83868684807C7A797A7D8083

8483807E7D7F858E9AA5AFB3B2AB9F9081756E6C70767E858888847D76716F7074797E81827F

7A75706E6F72787E838685837E7A78787B7F84888A88847E7976777D87939FA8ABA89F918173

676161666E777E838584827F7E7E80828485837F7A767272757B828A8F918F8A847F7C7D838C

97A1A8ABA8A095897F7876787C828687847F78726E6D70767D858A8C8C88837F7C7B7D7F8284

84827F7C7B7C80878F9699978F8272615249464953606D798083837F7B78787A7F84898B8B89

85817E7E7F82858787837C746C6663656A72797F82817D77726F70747C868E93938E84786B62

5C5C6169727A7F81807D797776787C8084868583807D7B7C7F83868887837B736B66676D7887

96A3ABADA89F92867B7573757A7F838584827F7D7E81878D929595918B837C7775767A7E8283

83817D7B7B7E848C959B9E9C958A7E736C6A6D76818D969A99948B827A747375797E82848483

817F808285888B8B89857F7976777C848E98A0A3A0998F83797473777E878E92938F88807A76

76797F858A8C8B86807A7675767A7E838584817C77737273777C808282807D7B7C818C9BACBE

CCD4D4CEC1B09F9085807F8185888A8885817E7C7C7F8386888885817C7876787C82888B8C88

827A736E6D717881898F908C857B716A67696E767E8486837E766F6A686B717981878A8A8884

817E7E7F818282817D797574767C858F979C9C968C7E716762636A75828E969A98938C847F7D

7D808386878683807E7E81868D939799969189827C797A7C81848584807A747070757D88929A

9D9A9285776B625F6168717B8287888683807E7F82868A8C8C8A87827F7E7F81848686827C74

6C66656A748393A1ABB0AEA79C90867F7C7C7F8384837F79726D6A6B6F767D838686837E7976

75777B7F838584817D797676797E848888847C71655B56575E6B7A89959D9E9A92887F797677

7A7E8183827F7C7A797A7C7F80807C766E676260636A737C838686827B75727277808B969FA2

A19A91877E7977797E828686837D766F6B6A6D73797F848584827F7C7C7E81848585827D7875

767B8694A4B3BDC1BEB4A695867B7474777D8388898884807D7C7D8084878886827D77737274

787D8183827E78726C6A6D727B848B8F8E8A837C77767A828C969EA09E968B7E736C696B7077

7D818383807E7D7D7F82858786837F7A757475797E8284827B7062564C484A53606F7D878D8C

888179747273767B7F81817E7A7776787C838A8F92918D867F797676787C808282807D7A7A7D

848E99A4ABACA79C8D7D6E64606269727A8183827E7873707073777C808282817F7D7D7F8285

8786827B7269625F6168737E878D8D8880766D6766697079818586847E787472747981888E91

908D88827E7D7F82868A8B8A87837F7E7E82878C8F8F8B857D7774777F8D9EAFBCC5C6BFB4A5

9689807B7B7D7F81817F7C7A797A7D82878A8B89847E787575787D84898C8C88827B77767981

8B959DA1A09A91877F7A7A7F868E9496958F877E777373767B80858686837F7B797A7C7E8182

817E7B797A7E8793A0ABB3B5AFA49584766C686A7078808587857F7974717174787D8182817E

7B797A7D82888E92928E88817A7574767B80848584807B777679818D9AA6AEB0ACA294867A72

6F71777F868A8B8985817E7C7D7F828383817D797574767A7F848786827B736D6A6C74818F9D

A8ADACA59A8E837C78797D82858685817D7A797C818991989B9B979089837F7E7F8182817F7A

75706E6E72787F838480776B5F544F50576473828F9697938C837C7877797D81838483807D7B

7B7D80838484807A746E6B6C717A838C9293908981797474787F878E91908A81766D67666970

7880858785807B7876787C8186898A88847F7B79797B7E8081807C7976777D8795A5B4BFC4C0

B6A79584776F6D70767C818383807C79797B7E8387898885807B78787B81878E9192908B8581

7F80858B9094938D84796E6662646A737B81827F776C625B57595F68717A7F81807E7B79797B

7D7F807F7C787574767B828A9194938D83786F6A6B717C8996A0A5A39C92877E7876777B7F81

817E7A757272757A8086898986817A757272757B80848685837F7D7D81878E9496948B7E6D5C

4E46454B5664727D848685817D7B7B7E8286898987837F7B797A7C7F8283817D787371737A84

909CA5A9A7A0968A807A797C838A9093918C857D7877797F868D91928F89827C7877797D8185

8685837F7D7D7F82878B8D8B867F7974747A8492A1AEB5B6B0A495867A7271747A81888B8C89

86827F7F7F8181807D77706A666669707880868988847F7B7A7C818990949591887C71676263

69727C848989857E77716F71767D848A8D8D8A85817E7E7F82848685827E7B7A7B7F848A8E8D

867B6B5A4B413D414B596977808585827D7A797B7F84898B8A87817C7876787C81858786837E

797575777D838A8D8E8B86807B797B80878D908E877B6D5F534E4F5662707D878C8D8A85817E

7D7F81848584827E7A7777797C8081817C766E67636368717B858B8B877D71655C585A606A75

7E848684807C79797C81868989868078716B696B70767C8082827F7C7A7A7C7E80817D766C61

575150566271818E9698938A7E746C696B70777E838583817D7B7B7C8083858684817D7B7B7F

868E959A9C999289807A797B828B93989A968F867E78777B828A92969691887F76706E70747A

7F8383827F7C7B7C8084898C8C8A86817E7C7D81858786807566554539353842526475828A8C

8B87827F7F818487898885807C79797C81878D90908D87817C797A7E83888B8B87817A757376

7D8791999D9B93887C7169686B727B838889857F78726E6E70757A7E80807F7D7D7E80848687

8580786F6864656C7885929CA19F988D827975757A828B9195948F88827D7B7B7E818383807B

746F6C6C70767D83868785817D7A7A7D81868989857F787270747D8A9BAAB6BCBAB2A595877C

7674777B7F8282807D7A79797C80838484807B76727072767B80817F7A7168615E616975838F

989C9A948B827B797A7D828586827C736A6462646971787E82827F7C7977787B7F828483807D

79787A7F868D92938E84766658504D525D6C7B878E918E88817B78787B7F83858583807D7B7C

7E828586847F776F686363676F777F858786827F7E8187919CA6ACADA89E91857B76767B828A

9092918C86807C7B7D8185898A8986817E7B7B7D7F81807E79736E6D70788594A2ADB2AFA698

88796E696A70777F85878683807E7E81868B8E8F8D88817A757374787D828585837F7B797A7D

848A9092908B837A7573767E88939B9D9A91837568605D5F666F777E8282807E7C7C7E808384

83807B777474787D848A8D8C877F766E6A6B727D89959D9F9C948A817A77797E858C90908D88

837F7E80858A8F91908C857E787474767A7E8182807C7977787A7F82837F76685745362E2C33

405162717B807F7C787574777C8186888885817D7A7A7B7E80817F7B746E6A686B727A83898B

888279706A686B727B83898A8780776F6B6B6F7781898E8F8B847C75717073777C818383817F

7E7E8185898C8D8A857E7977787E8790989B988F806F5F524C4C535F6C77808484827E7C7B7D

7F8283817E78726E6D70757D848A8D8C88837E7B7A7D818587868179706864656C76838E9698

948B80756D696A707881878A8986827E7C7C7F8286888886827F7D7D7F8183827E766A5E534C

4C525D6C7C8991928F877F777474787E84898987817B757373777D83878987837F7B7A7B8086

8C90918F8B86817E7E8184868682796E635A565962718394A1A8A8A3998D847D7A7B7F838686

8582807E7F8184888A898580797472747980888E908D88807874747A84909BA4A7A59E948980

7B7A7C808384817B746C6664666B747C83878886827F7D7D7F828383817C777372757C858F97

9A968C7D6C5C514B4D55606D787F817F7B76727273787C8082817F7C7A797C80868B8D8C8881

7A7572747981898F91908B847E7A7A7E868D939591887B6D6159575A626D777F8383817D7A79

7B7F8387898986827F7D7D7F8387898985817C797B828E9EAEBBC3C4BDB0A08F827976787C81

8586847F7B7776777B7F8384827D77706B696B70777E838584817E7C7C7F84898C8C887F756A

6360636C788691979791877C726B6A6E757D858A8B8A86827F7E7E808283827F7C79797B828A

939A9E9D978E847B77777C858F979B9993887D736C6B6E747B8082817D77727070747B81878A

8986817B78777A7E82868785827D7978787B7F8180796E5F4F4239373E4C5E71838F9595918A

837E7C7D7E80807E7A75716E6E71767B7F81807D787575777D858D9395928B8278726F727982

8B919390898179747478808991959590887F77717072767A7E807F7D7A7877797D808383807C

7875757B84909DA7ACABA39687796F6C6E76818B939796918B847F7D7E81838584827E7B7A7C

818890979B9B979089827E7C7E818485837E77716E7076818F9CA6AAA79E928479716F737981

888C8B88837D7A787A7D81838483807D7B7B7E82868989868079726F71798695A4AFB5B3AC9F

91857C78797C818484817C77727072787F868C8E8C88827C7877797C808383817D797575787D

848A8E8E8B857F7B7C838F9FAFBDC5C6C0B3A494877E7B7C7F83858683807C7A797B7E808180

7C77737070747B848C91918E877F7874757A838C9396938C81766D67676C747D848888847E79

76777A81888D908F8B847E7977777A7E818282817F7F82878F969B9B968B7A68584C47495361

6F7C858886817A757375797E83868684807D7C7D8085898C8C88837C7775777C838A9092908B

847E7B7C818992999D9B948B81797679808B97A1A6A5A0978D847E7B7B7D7F80807E7B78787A

7E83888B8B8984807D7D8189929A9E9C9487766659515157626F7B84888784807C7B7C7F8284

837F79726C68686C72797F82817E7A75727275797D80817E797572747A8593A1ACB2B0A89A8B

7D726D6F747C84898A88837D7977777A7F82848483807E7D7E8185868681786E635B5759616C

7883898B877F77716E70767F888E918E888079737274797F8385847F7974706F71767B7F8181

7E7B7776787B808485847F78716E6F778495A7B6BEBFB9AC9C8B7E757274787D8082807E7B7A

7A7D808485837F79736E6C6E747B82878A8885807E7E838C97A1A9ACA9A1968B827D7D82898F

93928D847A726C6B6F767E858A8B8985807D7C7C7E8082817E7A7775777B81878B8B857B6D5F

544E4F58657685919797928A837D7C7E82878B8C8B86817C7A797C7F8282807B746E69676A70

777F848685817D79787A7E8387868177695B4F48474E5B6B7A868E8F8C86807B7A7B7F838686

85817D7A797A7D80838583807C7A7A7D848E979EA09C9385776B64646A74808C9396948E8781

7D7D7F828585827C756D6866686E767D83868683807D7D7E82858787847E787472767D88939B

9F9C9386776B636267727F8C959998938C85807E7E7F8182807E7B78787A7E84898C8B878078

716E6F747C858D908F898179747377808A959C9E9B948B827D7B7F858C929695918B85807E80

83888B8C8B87827E7B7A7C7F8283827F7B797A808C9DB0C2CFD6D3C9B9A694867E7B7C808485

84807B777575787D828585837F7A7676787D83888B8A868079747274797F868988837B736C69

6B727C878F93918A7F736A65656A727C83888986827E7A7A7B7E818282817F7D7E828890979C

9D9991887F7A7A808A97A3ABADA89E9082787170747A8186888784817F7F81868B8D8D8A837A

726C6A6C70777C80817F7D7B7A7D81878C8E8C857B6F6661626B798A9AA7ADADA69C9087807E

7F83868887847F7B78787A7E828485837F7C7B7C80878E939490877B6F645F5F65707C878F91

8F8A837E7D7F858C939696918980787271747A7F848685827F7C7B7C8085898B8A87837E7C7C

8085898B8880726253484346505F71818D93928D857E7876777B7E8181807D7B7A7B7F84888B

8A867F77706C6C70767E848787847F7B7B7E86919CA5AAA8A095887C747173797F8485827C73

6C6665686E757C818382807E7E7F818587898784817E7F848D99A6B0B5B4AB9D8C7C706A6A71

7A858D90908B85807C7C7E82868887837E797574777B8186898985807B78787B81888E91908C

85807C7D81888F94948E837363544B494E5966747E848684807C7A7A7C7F81817F7B77737273

777C8083827E7973717278828D989FA09A8F8172666060656D767E81817D78747274787E8386

86827C75706D6E737A8186898886827F7E7F828485837E766E68666A748393A2ACAFAAA09283

787170747B82878987827D787575787B7F8181807E7E80858C949A9E9D978E847B7574777D84

898A867E746B6563676F7982888A867E756E69696E757D84878784807B78787B7F8386868481

7D7B7B7E83878A8A8680797474798597AABCC8CECBC1B2A19186807E8083858583807D7B7C80

858B8E8F8C8780797574777B808484827D777270737880888D8D8980766D67676C76818B9191

8C82776D6664666D747B8081807D7978787A7D8082817F7C7A7A7D838A909291897D6F615753

555D69757F84837E756D6765686F788085888784807E7F82878C90908D877F797574777D8388

8A8A87837F7E7F828687857E716252453F3F48566879868E8F8B837B767375797D818383807D

7B7B7D8084878886817C7775777B82888C8C877D7268615F646E7A869094938E867E79777A7E

838686817970686261646B737B808382807D7C7D7F838586847F79747071757B828787817668

594D4647505E70808D9394908A837E7C7D80838585827F7B7A7A7D818587868179716A66666A

70787E81807C7772707279828B929490877B6E645F6066707B858A8B88837E7B7B7E83898D8E

8D89847F7C7C7D808282807D7A797C838E9BA8B1B4AFA392806F645F6169737C838684817C79

797C81878B8D8C88837E7C7D81868C90908E88817C78787A7E8182807B736C67666A727C858A

8A84796C6058565B6674818C9393908A847F7C7C7E8081807E7B79787B7F858A8C8B867E7670

6D6F757D858B8B857B6E61585557606B7882878886817D7B7C80858A8D8C878078726E6F7378

7F838584817D7A7A7C7F84868785817D7B7E8794A5B5C2C9C8BFAF9D8B7C747174797F838481

7C78747375797E8182807D797675777B7F81817D756C635E5D6169747F878A88837D78767980

8A939A9C9991877C7572747A82898E8F8D87817C7A7A7C7F8283817E7A7776777B7F8384817C

756F6C6F788696A6B1B5B2A899897A716E70767E8488898683807E7F818384827E766E676363

666D757C80817F7B7876787C818688857E74685E58585E6975808788847B7168636368717A82

868785817C79787A7D808282807D7B7B7D82888C8E8B847A6F6561636B798897A1A4A29A9086

7F7C7E82888B8C89837C767273767C81868785817D79787A7F858A8E8E8A857F7B797A7D8183

827D766E68666B77899CAFBCC3C1B8AA9B8D837D7D7E8182817E7A767474777B7F8282807C79

77797D858D9395948E867E78777B848E989FA09B918579716D6E737A7F82817C76706D6E737B

838B8F908D87817C79797B7E8181807E7C7C7E848B929796908577695E595C6573828F979994

8B8076706E71767B8082817F7C7A7A7C808384837F78716C6A6D727A82888A88827C7774767B

82898D8C867D726965666D788591989A968E847C7674777B81848685827F7D7E8085898C8D8B

87827E7D7E81848581796B5A483B33343C4B5D6F7D8587847F7A7676787D8082817E78737070

747A81878A8A86817B7877797D818484817C75716F71767D8385827A6E60544C4C525D6C7984

88878179716C6A6D72787E8181807E7C7C7D808283817C76716D6E737C8791999C9992887F7A

7A7F88929B9F9F988E8379727174797F8384827D787575797F868D91928F89837D7B7B7D8083

83817E7A78797D848C91928D81705E4D413D414D5D6D7C868A89847F7B7A7B7E8183827F7A76

737275797E8182807B75716F71767E858989857C7269636368717C868C8D8A847E7B7B818A95

9FA5A6A29A8F857E7A7A7C808282807C797676787C8082817E7A75727379818B9397958C7E6D

5D524E515B6877828A8B89847E7B7A7C8085878885827F7D7F83898F939390898077716F7175

7B7F81817F7C7B7E85909CA8AFB0AA9E8F7F726C6B7079828A8D8C87807B77777A7F84888987

84807E7D7E808282807B75706E7077828F9BA2A39D9283756A65666C767F858886807A757374

787D8283817C756E6967696E757B7F807E7B79787A7F858A8E8E8A847F7A7A7E858D93959085

75635347434751606F7C848786827E7B7A7C7E80817F7C7977777A80878D91928E88827E7D80

878F969A9993897D746E6E747D889095948F867E7774767B81878987827B736E6C6E747A8083

84827F7C7A7B7D818384837F7B7A7C8490A1B2C0C8C8BFB09E8B7D7471747A808485827C7671

7071757B7F81817F7C7B7B7E83898D8F8D867E756E6B6D72787E82817D77716D6E737D879196

958E83766B646368717C868C8E8C87827D7B7C7E818484827F7C7A7A7D828689898680797473

767E89949C9E988C7C6A5B514E525B67727B7F807F7D7D8084898D8F8D888179737172777E85

898B8986817F7E81848889878179716A686C75818D979A978E8071655D5C626B767F85878580

7C7A797C7F838585827F7B7A7A7C7F81807C74695F575558616D79838888827A716B6A6E757F

878B8B867E76706D6F747C83878886827D7A7A7D82888D8F8E8A85807E7D8083868886837E7C

7D8491A1B3C2CCCDC6B8A591817773757A8186898885817D7C7E80848585827D787575787F86

8C90908C86807C7B7E848C91938F877C706864666D77828A8D8C867F7977797F88929A9D9C96

8E867F7B7A7C7E80807F7D7B7B7E83898E91908B837B76757B8594A3AEB4B3AA9C8D7F757274

7A82888C8C88837E7B7A7C808283807C76716E6F737A81878A88847E787575797F8489898782

7E7B7E8692A1AFB8BBB7AB9B8A7B716D6E747A7F82817E7A78777A7E8387898885817E7C7E80

8485848079706A676A748293A2ADB1AEA5998C837E7E83898E908F8B847F7C7C80878D91928F

89827B7776797D82868785817D7B7B7D818586847E756B6461646D7A88939998908374665D5B

5E66717A818483807D7B7B7C7F8182817E7B797A7F868F979C9D999188807A797C8187898881

766A5F58575C65717C8385837D777373767E868E9293908A847F7D7E8286898A8985817D7B7C

7E80817F7A736B66666C798BA0B2BEC3BFB4A493857B77787C8082827F7B7876787D83888C8D

8B86817E7D7F84898C8D89837B746F6F737A82888B89847C7673747B8590989C999184766A63

61666E777F8384827E7A78787A7D7F807F7B787575777C818485817A706762626873818F989C

988F82756C67686F778087898884807D7C7D808383817B736B646162676F777E8182807D7C7C

7E8286888680776E676569748495A5AFB2AEA4978A817C7E82898F91908C86807C7B7C7E8081

7F7C787675777C818688867F776D676569737F8C969B9993887E767273787F8486847D756D68

676B727A82878885807B7776777A7E80807D79757272757A80858786837E7C7F8795A6B9C8D0

D0C8B8A591827874767A7F8383827F7C7B7C7F83868786817C7876777C828A8F908D87807975

75787E8386847D73685F595A616C7883898A867E76706F717880878C8D89837C777475787D80

8282817E7D7D7F8284847F766A5D524D4E566475848F9390887D726B696C737B83878784807B

797A7D81858786827D787575797F868C8E8D88817B7776797D8183827C756D68676D7784919A

9C978C7D6D615A595E6771797F81807F7E7E8184888A8986827D7A797C8186898A87817A7574

78828F9EA9B0AFA79A8B7D736F70757B8183827F7B78787B828A9195959089817A7675787C7F

81807D79767576797E81817E7870696669728193A3AFB4B2A8998A7E7674777E84888987827C

7876777A7D8081807E7C7C80868D95999A968E847A7371747A82898D8C877F7975777D8895A0

A6A7A39A8F86807F82878D90908C867F7977787C8185878785827F7F8184888B8C89837D7879

7F8B9CAEBEC8CAC3B5A390817874767B808485827F7B797A7D818485837E77716C6B6E757C82

868785817E7D80868E959998938A7F767070757D868D8E8A817569615E616A75818A8E8E8B86

817F7E80828484827E7B797A7D82878988837B726B686B73808E9AA0A0998D80746D6B6F7780

878A8985807B797A7D83878A8985807B79797D848B9193928D87807C7A7B7E80807E7A747172

798596A9B9C3C5BFB2A18F817876787E84888987827E7B7B7E8286888986827E7B7B7D808383

7F786F655D5A5C646E798285827A70665E5D6069737C8385827E7977787E868F979A9A948D84

7E7A7A7D81848584817E7D7D81858A8D8D89827B757478818D9AA3A5A09484726359575C6672

7D85888885817F7E808283827F7B757171737981888D8E8A847C767374787E8284827C736B65

646A737F8A91938E85796F68676B727B828686827C777474777B80848483807C7A7A7C7F8283

817E7976767C8999ACBCC7CAC4B7A694857B77787D8183827E78726E6E71767D8284827F7A77

77797F858B8E8E8A847F7B7A7D83888D8E8C87817C7C8088929BA1A0988A79695C56575E6A76

7F8585827E797777797D808282817F7E80848A8F93938F887F777272767E868B8C867C6F6157

54565F6C78838889857F7A77787B7F82827F7870686362656B737B8082817E7C7A7B7E818484

817C76727277818E9CA6A9A5998976665C585C65717C838685817D7B7B7E8286898986827F7C

7D7F838788868179726E6D727A858F9799958E867E7B7C81899095958F867B726E6F757F8B94

9999958E87817F7F82848584817C777473767A7F838483807E7F838C97A3ACAFAB9F8D796659

54565F6C7983888885817D7B7C7E828483817C777575797F878D908F8B847D7876777B808384

817D7875777D8996A3ACAFACA29689807D7F868E969A9892897F76717073787C7F807F7C7A7A

7B7E8081807B756F6B6B707A86929A9C988E81746B686B747F8A9194918B837C79797D828688

87837D777475787E85898A88837E7977787C80848684807A757273777C7F7F796C5B48372C29

2F3D5063747F8585827E7B7B7D80838584807C7877787C81858786827D7876777C838A8F908B

817468605D616A7581898C8A847D7876797F878E92928D867E7875777D848A8E8F8C88837F7D

7E8081817F7B767272767D868F93928A7C6B5A4E494B5563717D84847F78716C6A6D72787D80

807E7C7B7C7E828585827B72696260626870797F82817D7A787A808992989A968D8073696567

6F7B868E92908981797473757A80848583807C7A797C7F838585827E7A797A7E83888A867D6E

5E4E444147546578879194918B847E7B7C7E8182807B756F6C6C717880878C8C8A86827F8083

888D8F8E8A847D79787C82888D8D8980746A64646B788896A1A5A2998D80777272757A7E8181

7F7C7B7B7E8185878785817E7D7F858E979EA19E958A7E7571737A838C9190897F7369636267

6F78808383807C79797D838A8F92918C857E7876787C8185878784817F7F8285878680756655

48404049596D8090989A958C827B78797C81858685817C7977797C7F81817D78736F6F727880

868887827A736E6E747D889197979289807875777D858C8F8D867C716864656A737D84898987

83807F7F82848584807C7775767A80878B8B88817A74747A8798ABBBC5C7C0B3A393867F7D7F

828586837F7A7776787B7F807F7B746D6765676D757D8284837F7A77777A7F84878681786F67

64687281919FA7A9A3988C807976787D838686837E78737273777C808282807E7E7F83878A8A

857C70645A5557606E7E8B949692897F767273787F868A8A8680797473757A808586847F7974

7172767C81858684807B79797C81868888837D7672737A8694A1AAACA5988674655C5B606973

7C8182817E7C7B7C7E80807E7A746F6D6E72797F8486837D76706E70757E8589888276695E57

565B65717C8385837F7B797C828B939A9C999289817B78797D818384827F7B7A7A7D81858684

807B77787E8B9CAEBEC8CAC3B6A493857D7C80878E92928E88837F7E8084888A8A87837F7C7C

7F8488898781796F6864656B737C8284837F7B797B828B969EA29E9587776A6261656F798388

8986817C79797C8085878784817E7C7D8185888987837D7A797E86929DA5A6A0938271625959

5F6A7680878886817C79797C7F81817E79726D6A6C727A838A8E8D8A85807D7C7E80817F7A73

6B6563666F7A858C8E897F72665D5B616C7A879196958F87807B7A7C8083858583817E7E7F82

8586847F776F6866686F7982898A857B70655F5E636D78818686827A736F6E737B848B8E8E89

837D79797C8186898985807A7574767A7F838584817D7C7D80868A8C877C6B564131292B3546

5A6D7B838684817E7D7F8387898986817C7877797D8183837F79736E6D70767E858988837B74

6F6E737B868F93928C82776E6A6B71798085847F766C6561626870787F8383817E7D7D7F8284

8584817D7B7B8088919A9F9E978B7D7069686F7B8A979FA19C92867B747173787E828383817F

7F82878C9193918B837B747273787E838685817C7775767A7F83837E74685B524F545F6F7F8D

959590867C736F6F72787D80817F7C7A797C8085898A8986817E7D7E828586837B6F61544C4A

515E6F808E95969189817C7B7D82878A8A857F787371747A82898D8E8B85807C7B7D81858786

837E797575777C8183827D756C66656C798A9DACB4B5ADA091837A76787D84898B8A86827F7D

7E808283827E7A77777B828B949B9D9B948B837D7C7F858A8D8A8276695E58585E68747E8485

817B757171767C838788857E76706C6C70757B7F81807F7E7E8084888B8A857D756F6D737F90

A3B2BCBDB6A7968578717073797E81807D787575777B81858685817C7877787D83888A89847E

777373767D858A8C888178706B6A6F767D8180796D5F5148464B5562707A8082807C7A797B7E

818483817D7A78797D82878988857F7A787A828E9BA5ABA9A09281716763666F79838A8B8984

7F7C7C7E82868786817B757273787F888E91908C86817D7C7E82848584807C7B7D8591A0AEB8

BBB5A99886776F6D717A83898B89827B74717174797D80817F7D7B7A7C7F8284827E77706B6B

707A86939B9E9B9389807A7A7F8891999B9991877E7876797F858989857E766E6A6B6E757B80

82817E7B7B7C80868B8E8D8A85807D7D81868B8B867B6A57463B383E4D6074859095938D8782

7F7F818384827F7B78787B80878D908F8A847D79787A7F858888847C746D6A6C737D878E908C

83786E68686D7680888B898279706B696D737A808383817D7978797C808283827F7E7E828992

9A9E9C94857464585357616F7E898F8F8A827B77777B82898D8E8C87817D7B7C7F81827F7972

6A6564676E767E8385837F7B797A7E838788847C71665E5D637080919FA6A69F93877C757477

7B808382807C79787A7D81858684817D7B7C81878F9496948D857D7A7D8694A4B1BABBB4A899

8B817C7C7F828484807B7674767C858E959897928B847E7C7E8184878684817E7E80868C9194

918B827A75767D8A9AA9B3B5AFA39282746D6C71787F848684817E7C7C7F82858685827E7C7C

80858C91928E877C726A67696F777F83827D766F6B6D747F8B969C9B958B81787374787F8588

88847E797575787E83878886827D7A797B7E8182817D79777A8290A3B7C8D2D3CCBCA996877E

7C80868C8F8E8A847F7B7B7D8082827F7A746F6C6E7279808485827D777372757B818586837C

736C696C737E89919491897E756F6F757F8C969D9D9990877E79787A7D8081817F7E7F81868B

9091908A837D79797F8891999B978D7F70655F616A76848E94948F88817C7B7D818485837E79

747273787F878C8D8B857F7977787B80848584817D7B7C80878E93928A7C6956463C3C445364

7581888986827F7F81858A8D8D8A857F7B7A7B7E8182827F7B78787B838D979FA19D94877B72

6F727A858E9495918A827D7C7F868F9598958F857D7674767B82868887837E7A78787C7F8283

817E7B797B80878E93938E83776B65656E7C8FA0ADB3B0A79A8D827C7A7C808384827F7C7B7B

7D8083837F7970696463676E7880858785817E7E818891989B98908375696160656E79808381

7A716965656A727C838786837E7A78797B7F8182807D7A77787A7E81817D74685C5351566275

899AA6AAA69C90857E7B7D81858785817A757172757B808484817C77737275797F82837F7972

6C6A6B70777E8282807C797A818D9CABB7BCB9AE9E8B7B706C6E757E85898987837F7E7F8285

8686837F7B797A7D82878A88837C746E6E737D88939A9B958A7D716A6A707A858F9494908A84

807F81858887837C726A6462666C757C818382807E7E8083868887827C777577808D9DAAB3B4

AD9F8D7D706B6C737E878E8F8C867F7977777A7E8181807D7B7A7C8085898A88827A726C6C70

7780888C8A847C736E6D727A838B8E8C857C736E6E747E8A949A9A968E857F7B7B7E82848481

7D797676797D828585827E7A78797D828788827664503D2F2A2F3C4F62747F8585817D7A7A7D

808383817C76716F71767B8183837E78726E6D71777E848685827E7C7D838C969EA29F968A7E

7470737B87929A9D9990867C7674777D83888987837F7B7A7B7D7F807E7C7A797C828C97A0A4

A39B8F81756F6E757F8A929491887C716966696F777E81817E7A7676797E84888A87827B7471

71757C8287898784807E7F82878B8C8881786F6A6C758598ABBAC1BFB5A696877E7B7C808588

888683807F8184888A8A87827C7775767A7F8384807A726C6B6E7885929DA3A29A8F837A7576

7B82888B89837C7673757C858F979A98938B847F7D7E808384827F7B79797B8085898A87827C

797B8390A1B1BDC2BFB3A290807674777E868C8E8B86807A78787A7E80807E7C79797D838B92

9797938B827A7575797F85898986817D7C818A96A3ADB0ADA29384776F6E72787F8484807972

6D6C6E73797E80807D7A7877797C7F807F7C77747479828F9BA3A59F92806D5E55545A65727D

8486837F7B797B7F84878886817A7573757B82898E8F8D8984807F8185898B8A857D76717074

7C848B8D8A81766C66676F7D8F9FABB0AEA59A8E847F7D7E8081807E7A7877797C808383807B

757272767E879095948F867C75747883909CA5A8A59C9186807E81868C8F8F8B857E79787A80

868B8C89837C767373767B81848584817E7E7F82858480756656473D3C4454697E8F999C978E

857D7A7B7F838787847F7A7674767A7E81817F7C7A7A7D838B939898948B81787373777F868A

89837A706864666E78818788837A706865676E7882898C8B87827D7B7C7E8182827F7B78787A

7F858B8E8D89837D7A7E8794A3B0B8B6AD9D89776963636A737C828483817E7D7E808384827D

756E6866686F777F858785817D7B7B7F84898C8B857E7672727983909BA19F978A7B6E656469

717B838787827C777474787D82858583817F7F8185888B8A87827E7C808A98A7B4BCBDB6A898

897D78797F858A8B877F776F6C6D7279808485827D787575787E838787847E78737273787D81

83817D7976777A808689877D6E5B493C363A46576A7B868A88837C7876787C808283817E7C7B

7D81858888857E77706D6E747B838888847E7672727984929EA7A9A4998D817976777B7F807E

786F676261666E7982888987837E7B7B7C7F8182817E7B7A7C81889094948E82756860606776

8798A5AAA79E92857C78787C818485837F7B78797C8185888784807C7B7E848C949A9B979088

807C7B7F85898B89827A7370727A8795A0A6A59C8F80746C6A6D747B818483817E7D7E82888C

8F8E8B86817E7E7F8182817B736B656469758698A8B0B0A89A8A7B716D6F757C8183817D7876

76797E838685817A736E6C6F757D83888886827E7D7E81858888847E76706F737D8B98A2A6A3

988A7D726E717A85909799968E867E7A797B7D8081807E7C7C7E83878A8A857D736A65646971

7B8285827A7066606066707C868C8C867D746D6B6D737A7E807E79726E6D70767E858A8C8A86

827F8083878B8D8C88837F7D7F828688847A69543E2C22222C3D5266768083817E7B7A7C8084

8686837E7A77777A7F848787847F7A77777B81888C8C877E746B66676D7781888A878078716F

727A85909698938A7F75706F737A81868887837F7C7B7C7F8283817E7B78797C82898D8D887E

71655D5B616D7D8C979B988E81756C696C727A818484817E7B7B7D808283807B736C68686C74

7E868B8C89847F7C7C7E80817E776D615752535C6A7A8890918B80736963636871798082817D

797676787C808282807C7977787B7F82817D756D6765697382919DA3A2998C7D716A6A6F7780

868886837F7F828891999E9F9C948C847F7E8084868785807B7776787D83878987837E7A797D

858E95979285735F4E43404653647480878885817E7D7E8184868683807D7C7E83888C8C8983

7C75727379828B9295938C857F7D818A95A0A6A7A196897D7674767D838888857E787473777E

868D91918D88827E7D7E808283817E7C7B7E848C9397948A7A6653453F424C5C6D7B8384817A

747172767D83878886827F7D7D80848787837D756F6B6B70767D81817D77706C6C707880878A

8882797370737C8996A0A4A197897B706A6A6F767D828482807D7C7C7F8283827E7974717174

7A808485827C7672757D8C9EAFBCC1BDB1A190827976787D8284837F7B7776797E838788857E

766F6B6B6F757C8184827F7B797A7D82868886817A7573788291A2B0B8B7AFA08F807571747B

848A8D8B87807B797A7D8285878683807D7D7E80817F7970655B55545A64717D8587837C746E

6D727B858E93928C8379727072787F858886817A747172767C818484817D787576797D818483

817E7B7D818992999A94877663534A4A53637587939998928A837F7D7E7F7F7E7A7672717479

7F858988847D777272757A818586827C76727278828F9AA1A29D93887F7A7A7F878D908D8579

6E6560626870797F82827F7D7C7D8083868684817D7B7C80858B8D8A8275665A53545D6C7E8E

9A9E9B92887F7A7A7F858B8F8F8B86807D7E8084878886817C7776797F878F9495928B847F7C

7D808486847F797371768091A3B4C0C3BDB09F8E8179787B808486847F7A7674767A7E828382

7F7D7B7D80858A8C8A857E7774767E8A98A4AAA9A19384766E6C717982888B89847E7A7A7D82

878B8A857D746C68696D747B818383817E7D7F82868786817A716A6769707A8287847B6C5B4D

44434B596979848988837D7876777A7E818281807F7F82888D91918E877E767272777F878C8E

8A837B7573767F8993989892877C736F7178818A90918D857D767475797F8384827D78737173

767B7F81807D7A797A7D818381796B5945362D2E394B61768790928E87817D7E818588898681

7C7776787C82868886827D79787C82898F918F89827A7675797E8385827A70655D5B606A7682

888983786C625C5D646E7982878785817E7D7E81838483807C7A7A7D82888B8B877E73696362

68727E868A867B6D5E534F515A66737D8283807D7C7C7F838787847D756E69686C747C838787

84807D7C7E82868888847F7B797D8794A2AEB4B1A69481706561656F7A848B8C89847F7D7D80

84878785817C7977797C7F81807C77727072798490999D9A9184766B66666C757D81817D7670

6D6F75808A9396958F867F7A797C82878A8A87837F7C7D8084878987827C7775767A7E807E75

6857473D3B4251667B8D989B989087807D7E8286888986837F7D7D808284827D756C65616268

7079808383807D7B7E848C959A9A94897B6E66656A74808A908F8A837B77787D858D9496948E

87807C7B7C7F8182817F7D7D80858A8E8F8A82766C66666E7C8E9EAAAEA99E90837975777D83

888A88837E7A7A7D82878B8B88837D79787B80868B8C8A847E7977797F858B8D8C88827E7D81

89939B9E9A8E7C68564A464A5563717C8182807D7B7C7E818383817C77747375797E8283807C

7775777D87929CA09D9486776C6668707C889195938D857E7A7B7E8285858079706966686D75

7D8284817D787575777B7F8282817F7E8188919BA3A59F93816E5E55545B6876828989847B73

6D6B6E747B818483817F7D7E80838585827C77737377808B949B9C989188817D7F848A8E8E88

7E71665E5C616B767F84837D756C68676C747D848787847F7C7B7D8185878785807C7A7A7E82

868886817A75757C8A9EB3C7D3D6CFC1AD9A8B817E8083878886837F7D7E82878B8D8B867F77

727173797F848684807B78787C838A8F908C847A726F7077818A8F8E877A6C5F58575D68757F

8586837D777474777B808282807D7C7C7E8183837F79716966676F7B889298968D8073686366

6D7882898A857E756F6D6F757C82868683807F80858C939899968F867E7876787C7F81807D7A

78797D848B8E8C8273604E423D424F6174838D8F8C857D79777A7E828483807C7977797C8082

827F7B767373777E868C8D8A8279716E717986949FA4A39C91867E7A7C8085878580776E6766

69727C868D908E8A84807E7F8082817E7A74706F71767B7F807C756C66666C798A9BA9AFACA1

917F7066646870787F8282807D7C7E8185888986827D79797C838A90928F898078727073797F

8383807A757377818E9DA9AFAEA6998B7F78777C848B8F8F8B847E79787B8085888886827E7B

7B7D808283827F7D7E838E9DAEBCC5C4BCAC99877A74767D878F93938E86807C7C7F84898A89

847F7A787A7F868C908F8C86807C7C7F83888A8A857F7A77797F868E92918A7E7269666A7686

96A3AAA8A093867B7574777B7F81817F7D7C7C7F8283837E78716C6A6C737B8286858079726E

70798694A0A7A69E9284797271757B8183827E797473767C848B8F8E8A837B7674767B808486

8582807F8084898C8C88817973737A889BB0C2CCCEC5B6A391837C7A7D8083827E78736F6F72

787D8182817F7D7D80858A8E8E8981776E69696E7882898D8B857D7775787F889094938B7F73

6A6769727D889092908B85807E8084898C8C8A85817E7E80838585837D777372767E878E918C

81705E4E45454E5D6E7E898E8C867F7A77787B7E807F7C7978797E858E959998938B837D7A7C

8084878785817D7D8189939DA2A29B8F80736B6A707A858E918D84796E6765686F777E828280

7E7C7C7F82858685827E7C7C80868B8F8E877B6D6057565C6877858F918D857B7471747A8289

8C8B86807A787A7F868C908F8C86817E7E81868B8D8B867F787473757A7E81817F7C7C808A9A

ADBFCCD1CCBEA99380726D6E757C828584817D7B7B7D808384827E79757375797D80807D766E

6765676E778085847E7469615F626C79848D8F8C857C7673757A80858581796F676263687078

7F8282817E7C7D7F8183827E797472747B8590999C988D7E6D615B5E68778692989790877E78

76787C808383807D7A7A7B7F8283817C746B6562656B747C81827F7A7675787E878F93928C83

7A74737A8695A3ABADA79C8F827A77797D828584817D7978797D81858685817D79797A7E8182

7F786F6763656F8095AAB9C0BEB4A595877F7C7D8082817D78726F70747B82878987817B7675

777D83898B8A86817D7C7E82878A8A867F77727278828F9AA09F968776675E5D626D7A848A8B

87817B7777797D818282807E7D7F82858888837B7168636369737E888D8D877F797679818D9A

A3A7A39A8E827A76777B7F81807C76706D6E737B838A8D8B87817D7A7B7E828585837F7C7B7D

82888B8A83756351423C3F4B5E73869398968F867F7B7C7F83868684817D7C7E82878C8E8D88

827C79797C81848580786E645D5C616A747D817F79706864656B747D83837D73675E595B626D

7881868785817E7E7F82848584807B7876787C828586837D7672737B8899AAB6BAB6A999877A

72727881898E8E8A857F7B7B7D8082827F7B76737479818A9195948F88807B7A7B7F83858480

7C7A7D85919FACB4B4AC9D8C7B706B6E77818A8E8E89827C797A7E83898C8C8A868280808182

82807B75706F727A8590989994897A6D64626873818D9596928B847F7E81868C8F8D88817974

73767C83888A89847E7A78797C808383807B7673747980878C8D88817A76798394A8BCCACFCB

BEAC99897E797A7D8082827F7D7C7D8085898A8985807C7B7D848C939797928B848080858D96

9C9C968B7D7169676C757F8689867F77706E70767E868A89857E77727174797F838583807D7B

7B7D8081817D787473788494A8B9C5C7C1B29F8D7E77777D858C8F8E89817B78787B81858887

84817E7E8084898B89847C736C696B7179818586827D7877797F878E908C8274665B575A6371

7E888C8A8379716C6C6F757B8081807F7E7F82868B8D8C88837D7A7B7E84888A867D71655C5A

616F8194A2A9A8A094877D78787C808384827F7D7D828992999D9C978E857D79797C7F81817F

7A7775777C82888B89827A726E70798899A7B0B1A99B8B7D7472767E868C8E8C88827F7D7E81

848685827E7B7B7D818587847D7469615F626C78858F9290887F7875777E889094938C81776F

6C6E757D848787837D7977797E84898B89857E797575787C7F807F7C7A797D848D9498948876

5F4A3B353946586B7A848785817D7C7D8186898A8884807E7F82878B8D8A857D767171757B82

888987827D7A7D84909CA6AAA89F93877E7A7B81878B8A847A6D635C5C626B757D8283807C7A

797A7D8082817F7D7C7E848C93999A958D827A76798392A1ADB2AFA49484766E6D72797F8383

807B7776777B808383807B757171757B83898B89847C767373767C8082807C787679818D9BA7

ACAA9F8D79675A5659626E787F817F7C7A7A7C81868A8B88847F7C7C7D81848685817D7B7D84

8F9CA7AEADA59685756B676A737D8588868078726F70757B8082807A736D6B6D737B848A8C8A

85817E7D7F828586847F7A7675787D84888881756759515057667788939692877B6F68676A71

787E80807E7D7C7D7F81817E78716B67686E7780878B89837C7674777D858B8D897F73675F5D

626D79848B8C88817A77777D848C91928E877F797676797D8181807D7978797C81858786837F

7E838E9EB1C3CFD3CCBCA7907E726E70777E8385837F7C7B7E83898E908E8A847F7C7D818589

89857F787270737981878A89837B747071757D8386837A6E625A585D6A7A8B979D9C968D847E

7D7F82868786837F7D7C7E81848685817D7A7A7E8790999E9D968B7F76737883919FA9ACA69B

8E817874757A7E81817E7A7776787D838788847D736B6565686F767C7F807F7D7E81858A8C8A

82776A5F5A5D677789979F9F978A7C706A6B707981868785807C7A7B7E82858685827F7D7E82

878B8B8881776D68676D77828C908E877B70676568707A8184827D75706E727A858E9495918A

817B77787B7E81807D79757475797F848787847F7B7A7C818789867C6A543F2E262834475C6E

7B82817E797676787C8081807D7A797A7E84898D8D89827B7574767C83888A88827A7573757B

83898A857B6D5F565358626E7981827E77716D6E747D878E91908B847E7B7B7D7F81817F7D7B

7C7F84898B898175685D5759647486969FA19C92877E7B7E858D959897918A837F7E7F828381

7C766F6A696D737B8184837E78747273787E8384827D7874757B848F979994867562524A4B54

62717E868987827E7B7C7E8182827F7B7776777C81868886827C7776787E858B8B867A6B5B50

4B4F5A6A79858C8C88827D7B7D81868988837B726C696C737B83888986817D7A7B7E83868886

83807E7F848A90928E85786A5F5B5F6C7E91A0A9AAA2978A807A7A7F84888A88847F7B7A7B7F

82848482807F8288919BA3A6A39B8F837A7575797D807E776E645D5C626D7B8890928D847971

6D6F757D848887837D7775767A8085878784807C7B7C7F8283827E7976767C8795A2ACADA595

816C5B52535B687681878886827F7F81848787847F787371737980878B8B87817B77777A7E82

83807A716B6769717B858C8D8980766F6D737E8C99A1A29D918478706E71767D818383817F7F

8184868786817C7775767B818788847B6E6259565B6776848E918C83786E6A6B707981858682

7C777474787C7F807D776F6966686D757D8283817D7977777B7F8384827F7C7C8290A3B8CBD8

DCD5C6B19C8B817D8085898A88837C7775767A7E8283827F7C7A7B7F838687847E76706E7179

848F969792887C726D6E75808A90928E867D7775787F868C8D8880766D68686D747B8083827F

7C7A7B7D8081807B756E6B6B6F767D8180796E6258555B697C91A3AEB0A99D90847C7A7B7E81

82817E7B7A7C80848787837C746D6A6B7179818687847F7976777B828789867D72665D5B5F6A

7782898983796D6561646B747D8283817D79787A7F84898B8B8783807F7F8181807B736B6666

6D7B8DA0AFB7B6AB9C8A7B7270747B818584807A7573757B81888B8A86807B78797D82868784

7E76706D6F737A808484827E7B7C818A93999A95897A6B615E647283939FA4A29A8F857F7C7E

808384827F7C7A7A7C8082827E79726D6C6F7780888D8D887F7874767E8B99A4A8A59C8E7F74

6E6E737A7F82827F7C7A7D848D969D9F9D958C847E7C7D80838583817E7C7D81868A8B888178

706D717D8EA1B2BCBDB5A693837772747A808586847F797675777B7F80807C797676797E8387

87827B736E6C717A858F959590887F79777A80878A877F73655A55575F6B78828786817B7674

75797E8284827E7B79797D8286898885807D7C7F83888A877C6B5744373238465A6E7E888A87

807976767A7F848685827E7C7D81878C8E8D877E756F6C6E737A808383807D7C7E838B929593

8B7E716661646D7A87919490877C726E6F7680899093908B847F7C7C7E80807F7C7978797D82

8687837B6F635B585D66737E84847C70645A5659626E7A8184827D7876777C82888C8B87807A

7676797F858887837D777373767B8083827F7B77777B81878B897F6E5A4636303442556A7D89

8E8D88827F7D7F8182817D78737171757B80848583807D7D818891989C9A92887D767479838E

989D9B94897E7673757B82868580776E6765687079828787847E797676787C7F807F7C797879

7C8083837D74685D5758617183939D9F998D7E716A6A707A838A8D8B86807C7A7B7D80807E7B

7877797F8891989A9890877F7A797C80858785807A76777D8895A1A8A79F9182756E6E747E88

8F918E87807977787C82858785817E7C7C7F838586837F797675787E83858176655240343138

475A6D7C8587847F7B7A7D81868989847E7976777C848C91928F89837D7B7C7F8283817B756E

6B6C71787F83837E77716F747F8FA0AEB5B3A89886766C696C737A7F807E7A777576797C7F80

7F7C7A7B7E848C9294928B8178727176808B9396938B807772747B87939C9F9C948A817C7B7E

828687837D777270747A838B8F908D87827F7E8083858583817F8187919EA8AEABA08E786354

4F525E6D7C868B89837D7876787D818483807C7876777B7F82827F7A747070757C858B8E8B85

7D7673757D879095948E8378706D70777F84857F75675C545358626E787E81807E7D7D808386

8785807B7776787D828686827B7470717A8798A6AFAFA696826F625C5E6670797F81807D7C7D

81868A8B89847E7875777C838A8E8E89827B7674777B7F82817E7976777D8894A0A6A49B8B79

685D5A5F69757E83837E77716F71767C828585827E7B7A7B7E818382807D7D808893A0A9ADAA

9F9080726B6C737D878D8E898077716F737B83898C89847D79777A7F858A8A87817974717276

7B7F817F7B7876777C83898D8C88827D7C8390A1B4C3CAC8BCA994827570727880868887837F

7D7D7E80817F7B76716F71777F878D8E8C867F7B7A7E858B8E8C8477695C55565C68737D817F

79736E6D717982898B888178706B6B70777E838584817F7E7F82858786827E7A787B828A9193

8E816E59473B39414F61717C81807B7673747980868A8A87827D7B7B7D8183827F7974717277

808A9296948F877F7B7A7D8184847F766D66646A768797A4A9A59B8D80767273798085878682

7E7B7C7F8387898885817E7D7E828586847D756D686A727F8E9AA09E938371635A5A616C7780

8584817D7B7B7E8284837F776E66626469727A8082817E7A78797C818485827D7876787F8B98

A3A8A59D908279777D8998A6AEAFA99D91857E7C7D81838483807D7C7D80838686837E797677

7D86909799968D81777070757F8990918C83786F6B6D747D868C8C87807974747980878C8E8B

87817E7E82878C8F8F8B86807C7C7D8082817D7975757C8B9FB6CAD8DBD3C2AB95837874767B

8082817D7977777B808689898783807F81868C9193918B837D7A7C81899093918A817873747A

848F9698948A7F7671737A848D93938D8379716E6F757C82868785817F7E7F80817F7B756F6C

6C727A848B8D887F726761636D7C8E9DA5A69F93867C77777C82878988858280808387898984

7D736B66676B737C828584817F7E80858B90928F88807A797F8A9AAAB5B8B2A59380726B6B70

777E82827F7B78777A7E838686837F7B797A7D818484817C787679828F9EABB2B1A79886786F

6D717A83898B88837E7C7E858D959998938A817B787A7E838787847F7A77777A7F8385847F7A

7675777C8285837A6D5D4F474751627689959A968C8176706F73797E8182807E7D7E81848788

85807B77787D8690999D9D978E857F7D7F848787817667594F4C505B69768084827E79777980

899196969189807976777A7F838483807D7B7C7F8284837F7A7573788393A5B3BBB9AE9C8876

6A676B757F888C8B87817D7B7D818486847F79737071767B8083827E787472757C848A8E8C86

7E767272777E8487847D736A6568728193A2ABABA5998B7F7876787C7F81807D7A797A7D8285

8684807B77777A7F84878680766C65656D7B8D9FABB0ADA294877E7B7D83898D8D8A847E7B7B

7E8284848078706965666C747C828583807C7A7A7D7F817F7A726C696C768596A4ABAA9F8F7C

6C6260656E787F817E78726D6C70757B808282807E7D7E8182827E766D645F5E646D78808481

7A6F6661636A7580878A867E756E6B6F7680888B8A847C747071767E858A8B8884807D7E8185

888986827D79797C8186888781797271768599B1C6D4D8D1C1AD99897F7C7D8082817F7B7978

7B7F838685817A736F6E71777D8284817B757171757D84898A857C726A686C75818D93948E84

7A7371757F899297958F867D7776777C8082817F7B7877797C7F80807D7A797C8491A0ADB5B4

AB9C89796F6C717B868D8F8B8379706C6D72787E81817E7A78787B808587858079726D6D7178

81878A88847F7B7A7B7E807E786D605550525D6E82939FA29C918377706F747B82878886827F

7E7F82858684807B767475797E81827F78716B6A707A87939B9A928474665D5C626C77808585

827F7E81878F9598958E8479716E70757C818484817F7E7F82868988857E77716F7279808584

7C6E5C4C403E4554687A888F8F89817A76777A7F8384827F7B7A7A7D8082827E78726E6F757F

899297969088807C7C81888F918F877C726C6D74808D989D9C94897E7774767A7F817F7B746E

6B6C70777D828382807E7E8184888986817B76777F8DA1B6C6CFCDC1AE99877A75777D848989

86817D7B7C81868A8C8A86817E7E8289909596928C847E7B7C808486858078706C6C727C8891

9491897F767376808E9CA6A9A59A8D80777374787D8182817E7D7C7E818383817B75716F737A

828A8D8B847A716C6E778595A2A8A69D8F81757071767D838685817E7C7D82898F92918C847C

7775787E83888886817B78777A7E8182807B77777C8799ADBECACBC3B29D897972727880888B

8B87837F7F82868B8E8D8A85807D7D7F8284837F797472757D8A97A2A8A79F93877F7C7F868D

92918B81766D696B727A8285837C746C67686D747D838584817E7D7F83878B8C8A85817F7F83

898D8E8A817468616069798C9EABAEA99C8B7C716D6F757C818382807D7C7D7F82827F79716A

67686E7781888C8B87827E7E80858A8C8981766B64646A768491989993897F78777B848E9699

9790877F7A7A7C81858685827F7C7C7E818484817C7775777E89949C9E9789756151494A5361

707B81827F7B797A80878E92918D86807B7A7D81868785817A7573757A81878B8A86807B787A

7E848989867F7773768090A5B9C8CDC9BCAA9889807D7F83868684807C797A7C80848583807D

7B7C80868C8E8C867C736C6B707882898A84796A5C54525863707B82827F797573767B808483

7E766E68666A717A83888987837F7D7E7F81807E7973707177818D979C988D7C6A5B5456606F

7E8A8F8E877D757070747A7F8282807E7D7E82868A8A88837D79797D858E969A989289807A79

7D848B8F8D867C726B6A7079858D918D84786C6563687079808484807C79797C808383817C76

727072767C8081807E7D818B9AADC0CED2CDBDA78F7B6E6A6D757E848684807C7A7B7E828484

7F79726D6D70777E8486847F7A7675797F868A8B88837E7C7E858F989C9B9284746760616874

818A8D8981766E6A6B717981868785827F7E7F818383817E7B797C828B949B9C968B7D706867

6D77828A8C877D7167616269747E868987837E7B7B7E838788857E76706D6E737B8388898783

7F7E7F83878A8A86817C7B7F8895A2AAAAA19079625047474F5D6C777E807F7C7B7D80858889

86827D7A797C80858785807A747071767D838582796C6057545A657380898C8A847E7B7D838B

9295928A7F736A67696F777E82827F7B78777A7E828483817D7B7B7E848A8D8C857B71696970

7F92A4B1B6B2A59484777172777E8384827D787574777B7F80807D7B7B7E868F99A0A29F978E

85807F81868A8A88827E7C7F8997A6B1B7B4A99A897D76777D858D908F89817A76767A808587

86837E7B797B7D8081807D7A787A8089929999928472615450546171818C918E877E7774767A

7F82827E797574777D868E92928E88817C7A7C7F82827F7A746F6E71777F8587857F7874747C

8897A4AAA89E8C79685E5C616B7781878885827F7E7F8182817D78747172777D838685807972

70727A8590979893897C736E717A85919899948A807875777B8184848079726E6F737B83898B

88837D7876777B7E80807E7B79797D8285857E705C463328273143596D7C84847F7975757980

878B8C8A85807D7D7F83858684807D7B7D838B939898938A7F7773747A80858681786E656164

6B767F84837B70655D5B606A76818788847E787575787C7F807F7D7A797B7F848788847E7670

6E71788085857D6E5B483B373D4B5F72828B8E8B85807E7E818383817C777373777E868C8F8D

867E777373767B808382807C7B7E858E979E9E988D8177737782909FA9ACA69B8D807774767C

818484807B767475787D8081807E7B7B7C808485827A6E61575256606F808C9290887E746E6E

737C8387868078706B6B6F767E8383817C7774767A81868988837D777474787E828584827F7E

81878F96989386735D4B3F3E47586C7E8A8F8D877F7A787A7E818483817E7D7E8185898B8882

7B747171767D848888837C7572747C87929A9A94887A6D66656A737C8283807B77777C85909B

A3A5A1998F87817F808182807D7A77787B8084868580787270747F8E9FACB2AEA18F7C6D6565

6C7681878986817B78787B7F838583807D7B7D81888E91908B847D79797E868E9394918A837D

7C7E8386867F7465564C4A505E70818E94928B827A7676797D81817E7A767475797E83858582

7E7C7C7E8285858076695D56576172

pop

% End of sampled sound

% End of Graphics

MathPictureEnd


\
\>"], "Sound",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oo`008@0000000`00
Oomoo`3oOolMOol100000003001oogoo0=9oo`03001oogoo015oo`03001oogoo00Eoo`06001oogoo
001oo`0037oo00<007ooOol00Woo00<007ooOol02Woo00<007oo00000Woo00<007oo00000Woo0@00
00000`00Oomoo`2AOol00`00Oomoo`0?Ool00`00Ool00004Ool01000Oomoo`000goo0P0000=oo`00
Ool01Woo00<007ooOol00Woo00<007ooOol00P0000Aoo`00Ool0009oo`04001oo`000002Ool01000
Oomoo`000Woo00<007ooOol00P0000=oo`0000000P0000Eoo`00001oo`0000Aoo`800003Ool007oo
00800003Ool007oo00800004Ool007ooOol300000goo000000030002Ool00`00Ool0000300000goo
001oo`0200000goo001oo`02Ool50001Ool100000003001oogoo04ioo`03001oogoo00Qoo`03001o
ogoo00Qoo`8000Uoo`800006Ool007ooOol007oo0P0000=oo`0000000P000Woo1P0000Eoo`000000
07oo00@0009oo`03001oo`0000<00004Ool00000Ool200000goo001oo`0700000goo001oo`020000
0goo0000000400001Woo000007oo001oo`800004Ool007ooOol700000goo0000000700000goo0000
0002Ool;00000goo0000000300000goo0000000400000goo0000000200000goo001oo`02000017oo
000007oo0`0000=oo`0000003@0000=oo`0000001P000Woo0P000Goo0@0000000`00Oomoo`0_Ool0
0`00Ool00002Ool00`00Ool00002Ool01000Ool007oo0P0000=oo`00Ool01@0000Eoo`00000007oo
00l00006Ool00000Ool007oo7P0000=oo`000000100000=oo`0000000`0000=oo`0000004@0000=o
o`0000005@0000Eoo`00000007oo00@00003Ool0000000<00005Ool00000001oo`0U00000goo0000
000900000goo001oo`0500000goo0000000200000goo0000000>0001Ool100000003001oogoo01mo
o`800003Ool007oo00H00003Ool0000000<00004Ool00000Ool600000goo0000000200000goo0000
000600000goo0000000400000goo0000000800000goo0000000200000goo0000000200000goo0000
000<00000goo0000000>00000goo0000000:00000goo0000000E00000goo0000000900000goo0000
000200000goo0000000A00000goo0000000800000goo0000000400000goo0000000c00000goo0000
00020001Ool100000003001oogoo00]oo`03001oogoo00P00003Ool0000000D00003Ool000000?X0
005oo`40000000<007ooOol017ooo`0060000Goo0@0000000`00Ool0003o000L0001Ool100000003
001oo`000?l001`0005oo`40000000<007ooOol0o`0070000Goo0@0000000`00Oomoo`02Oooo000J
0001Ool100000003001oogoo00Uoo`800003Ool000000?l000h0005oo`40000000<007ooOol067oo
00<007oo00000Woo2@0000=oo`000000100000=oo`000000j`000Goo0@0000000`00Oomoo`0YOol0
0`00Oomoo`0:Ool00`00Ool00002Ool01@00Oomoo`00Ool00P0000=oo`00Ool0100000=oo`000000
0`0000=oo`0000004P0000=oo`000000<00000=oo`0000002P0000=oo`0000004`0000=oo`000000
7P0000=oo`0000003P0000=oo`0000000P0000=oo`0000009@0000=oo`00Ool00@0000000`00Oomo
o`1LOol01000Oomoo`001goo00D007oo000007oo008000Aoo`06001oo`00001oo`000Woo00@007oo
Oomoo`@0009oo`05001oo`00Ool00002Ool00`00Oomoo`04000017oo001oo`000Woo0P0000=oo`00
Ool00goo00T007ooOol007oo001oo`00Ool01P0000=oo`00Ool00Woo1@0000=oo`00Ool0100000=o
o`0000001P0000=oo`0000000P0000=oo`0000002`000Woo00@007ooOomoo`800006Ool00000Ool0
07oo10000Woo1P0017oo0`0000Aoo`00001oo`<0009oo`@0009oo`@00003Ool007oo009oo`03001o
ogoo00<0005oo`40000000<007ooOol0LWoo00<007ooOol02goo00<007ooOol00goo00@007ooOol0
00Aoo`06001oogoo001oo`000Woo00@007oo000000=oo`03001oo`0000Eoo`07001oogoo001oo`00
Ool00`0000=oo`00Ool00Woo0P0000Qoo`00Oomoo`00Ool007oo0P0000Ioo`00Oomoo`00Ool20000
1Goo000007oo00000Woo00@007oo000000=oo`07001oo`00001oo`00Ool00P0000=oo`0000000Woo
00<007oo00000Woo00<007oo00000`000Woo00L007oo000007oo001oo`0200000goo000000030002
Ool200000goo0000000400000goo00000002000017oo000007oo0P0000=oo`0000000P000Goo0@00
00000`00Oomoo`2XOol00`00Oomoo`0ROol00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Ool00002
Ool01@00Oomoogoo00000goo0P002Woo00@007ooOomoo`8000=oo`03001oogoo00Eoo`03001oogoo
009oo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`02Ool100000003001oogoo0?moo`]o
o`03001oogoo00moo`40000000<007ooOol0ogoo7Goo0@00003o000Q00000003001oogoo0?mooaeo
o`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeo
o`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeo
o`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeo
o`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeo
o`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeo
o`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeo
o`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0=9oo`03
001oogoo04Moo`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3cOol00`00Oomoo`0VOol1
00000003001oogoo0?=oo`03001oogoo025oo`03001oogoo009oo`40000000<007ooOol0]7oo00<0
07ooOol01Goo00<007ooOol0GGoo0@0000000`00Oomoo`2lOol00`00Oomoo`0:Ool00`00Oomoo`1@
Ool100000003001oogoo08Aoo`03001oogoo02eoo`03001oogoo01]oo`03001oogoo00Ioo`03001o
ogoo03ioo`40000000<007ooOol0Q7oo00<007ooOol0E7oo00<007ooOol05Goo00<007ooOol09Woo
0@0000000`00Oomoo`2dOol00`00Oomoo`0BOol00`00Oomoo`0aOol00`00Oomoo`0LOol100000003
001oogoo0;aoo`03001oogoo03eoo`04001oogoo000GOol00`00Oomoo`02Ool100000003001oogoo
08Aoo`03001oogoo01Qoo`03001oogoo07Eoo`03001oogoo009oo`40000000<007ooOol0P7oo00<0
07ooOol077oo00<007ooOol06Woo00<007ooOol0;goo00<007ooOol00goo00<007ooOol01Woo00<0
07oo000077oo0@0000000`00Oomoo`1WOol00`00Oomoo`0JOol00`00Oomoo`02Ool00`00Oomoo`0X
Ool00`00Oomoo`0HOol00`00Oomoo`09Ool00`00Oomoo`0NOol2000JOol01000Oomoogoo0@000000
0`00Oomoo`20Ool00`00Oomoo`0nOol00`00Oomoo`0hOol01000Oomoo`0077oo0@0000000`00Oomo
o`1WOol00`00Oomoo`0FOol00`00Oomoo`06Ool00`00Oomoo`13Ool00`00Oomoo`09Ool00`00Oomo
o`0@Ool00`00Oomoo`0BOol00`00Oomoo`0FOol100000003001oogoo06Moo`03001oogoo03Aoo`80
025oo`05001oogooOol00003Ool01`00Oomoogoo001oo`0000eoo`03001oogoo00Uoo`03001oogoo
009oo`03001oogoo019oo`03001oogoo019oo`04001oogooOol100000003001oogoo041oo`03001o
ogoo03Yoo`03001oogoo021oo`03001oogoo015oo`03001oogoo019oo`05001oogooOol00004Ool0
0`00Oomoo`08Ool01@00Oomoogoo0000=Woo00@007ooOomoo`40000000<007ooOol0@7oo00<007oo
Ool03Woo00<007ooOol067oo00<007ooOol06Woo00<007ooOol037oo00<007ooOol09Woo00<007oo
Ool03Woo00@007ooOol001=oo`03001oogoo00Moo`03001oogoo01Ioo`03001oogoo00Yoo`03001o
ogoo0040000000<007ooOol0@goo00<007ooOol02goo00<007ooOol04goo00<007ooOol04goo00<0
07ooOol017oo00<007ooOol06Goo00<007ooOol04Woo00<007oo000017oo00<007ooOol05Woo00<0
07ooOol09goo00D007ooOomoo`0000Qoo`03001oogoo00eoo`40000000<007ooOol0@goo00<007oo
Ool02goo00<007ooOol0;7oo00<007ooOol01Woo00<007ooOol0BGoo00<007ooOol01Goo00D007oo
Oomoo`0000Moo`03001oogoo015oo`03001oogoo01aoo`40000000<007ooOol0EWoo0P0057oo0P00
9Goo00<007ooOol037oo00<007ooOol047oo00<007ooOol03Goo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol00Woo00<007ooOol07goo00<007ooOol067oo00<007ooOol00Woo0@0000000`00
Oomoo`0^Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`0GOol00`00
Oomoo`09Ool01@00Oomoogoo00000goo00<007ooOol037oo00<007ooOol00Woo0P008Woo00H007oo
Ool007oo0003Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`03Ool01000Oomoo`001Woo
00<007ooOol01Woo00<007ooOol02goo0P003Woo00<007ooOol027oo00<007ooOol00Woo0@000000
0`00Oomoo`0TOol00`00Oomoo`0IOol01@00Oomoogoo00004Woo00<007ooOol03Goo00<007ooOol0
0Woo0P007Woo00D007ooOomoo`0000Qoo`03001oogoo00Ioo`03001oogoo011oo`03001oogoo01Eo
o`03001oogoo00eoo`03001oogoo01Aoo`03001oogoo00Qoo`05001oogooOol00003Ool00`00Oomo
o`0:Ool00`00Oomoo`02Ool00`00Oomoo`0100000003001oogoo02Aoo`03001oogoo00]oo`03001o
ogoo00Uoo`03001oogoo009oo`8000aoo`03001oogoo009oo`8000Yoo`03001oogoo00Qoo`04001o
ogoo0005Ool00`00Oomoo`0COol01@00Oomoogoo00000Woo00<007oo00000Woo00<007ooOol00goo
00<007ooOol04goo00@007ooOol000Moo`03001oogoo00eoo`03001oogoo03ioo`03001oogoo00Eo
o`04001oogooOol100000003001oogoo01Eoo`03001oogoo01Ioo`80009oo`03001oogoo00Aoo`05
001oogooOol00006Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool00`00Oomoo`05Ool01`00Oomoogoo
001oo`0000Eoo`03001oogoo00Eoo`03001oogoo00=oo`8000Uoo`03001oogoo00]oo`03001oogoo
00Moo`03001oogoo019oo`03001oogoo00Ioo`03001oo`0001Qoo`04001oo`000002Ool00`00Oomo
o`08Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0HOol00`00Oomoo`05Ool30001Ool1
00000003001oogoo01Eoo`03001oogoo02eoo`8002moo`03001oogoo00aoo`80009oo`04001oogoo
000BOol00`00Oomoo`0KOol00`00Oomoo`0EOol00`00Oomoo`0`Ool01@00Oomoogoo00003Goo0@00
0Goo0@0000000`00Oomoo`0EOol00`00Ool00009Ool01000Oomoo`002Woo00<007ooOol01goo00<0
07ooOol01goo10004goo00<007ooOol01Goo00@007ooOomoo`<000Eoo`8000aoo`03001oo`0000=o
o`03001oogoo009oo`03001oogoo00Eoo`8000Aoo`05001oogooOol00006Ool20002Ool00`00Oomo
o`04Ool00`00Oomoo`06Ool2000;Ool00`00Oomoo`0AOol00`00Oomoo`02Ool00`00Oomoo`04Ool0
1@00Oomoogoo0000=Woo0@0000000`00Oomoo`0EOol00`00Oomoo`09Ool00`00Oomoo`020009Ool0
1000Oomoo`001Woo00@007ooOomoo`8000Ioo`03001oogoo00=oo`03001oogoo00Qoo`800003Ool0
07oo00Eoo`03001oo`0000Eoo`04001oogooOol2000<Ool01000Oomoogoo0P000Woo00<007ooOol0
17oo00<007ooOol00goo0P000Woo00<007ooOol00goo00<007ooOol067oo00<007ooOol01Woo00<0
07ooOol02Goo00<007ooOol03goo00<007ooOol00goo00<007ooOol037oo00<007ooOol00Woo00<0
07ooOol027oo00@007ooOol000=oo`80009oo`03001oogoo00Ioo`8000Aoo`40005oo`40000000<0
07ooOol05Goo00@007oo000001Eoo`05001oogooOol0000COol01000Oomoogoo0P002Woo0P0000=o
o`00Ool04Goo00D007ooOomoo`0000ioo`800003Ool007oo00@000Eoo`03001oogoo00Qoo`03001o
ogoo00Aoo`06001oo`00001oo`001Woo00<007ooOol03goo00<007oo00001goo00<007ooOol027oo
00<007oo00001Woo00<007oo00002goo00<007ooOol017oo00<007ooOol00Woo00<007oo00001goo
0P001Woo00<007ooOol00Woo00@007ooOomoo`8000Ioo`04001oogooOol100000003001oogoo00ao
o`03001oogoo019oo`05001oogooOol0000?Ool01000Oomoo`001goo00<007ooOol00Woo0P004Woo
00<007ooOol047oo0P000Woo00<007ooOol00goo00<007ooOol01Goo00<007ooOol017oo0P001Goo
00<007ooOol017oo00D007ooOomoo`0000Yoo`03001oogoo01eoo`06001oogoo001oo`0037oo0P00
0Woo00@007ooOol001Qoo`04001oogoo0008Ool00`00Oomoo`0=Ool00`00Oomoo`09Ool100000003
001oogoo00aoo`03001oogoo00Uoo`03001oo`0000Yoo`03001oogoo00Ioo`8000Eoo`04001oogoo
000:Ool20005Ool00`00Oomoo`02Ool01000Ool000001Goo00<007ooOol01Goo00<007ooOol017oo
00<007ooOol00Woo00<007ooOol02goo00<007ooOol00goo00<007ooOol017oo00<007ooOol01Goo
00<007ooOol00goo00<007oo00000Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol02Woo
0P0000Aoo`00001oo`8000Aoo`03001oo`0000aoo`8000Aoo`03001oogoo009oo`8000Eoo`8001=o
o`03001oo`0000=oo`05001oo`00Ool00002Ool00`00Ool00008Ool20004Ool200000goo00000006
Ool100000003001oogoo00aoo`03001oogoo00Ioo`03001oo`00009oo`03001oogoo00Aoo`04001o
ogoo000@Ool00`00Oomoo`020007Ool00`00Oomoo`0>Ool20004Ool00`00Ool00005Ool00`00Oomo
o`03Ool00`00Ool00005Ool20004Ool00`00Ool00003Ool300000goo00000004Ool01000Ool00000
1Goo0P0027oo0P0000=oo`00Ool027oo00D007ooOomoo`00009oo`06001oogooOol007oo0P001Goo
0P000Woo00<007ooOol00Woo0P000Woo00<007oo00001Goo00<007oo000017oo00<007ooOol01Woo
0P0000=oo`00Ool017oo00<007ooOol017oo00@007ooOol000=oo`04001oogoo0003Ool40003Ool0
0`00Oomoo`0=Ool00`00Ool00003Ool01000Ool007oo0@0000000`00Oomoo`0HOol00`00Oomoo`09
Ool00`00Oomoo`0;Ool00`00Ool00004Ool01`00Oomoogoo001oo`0000Aoo`03001oogoo00=oo`03
001oogoo00Aoo`03001oo`0000Aoo`03001oogoo00Moo`03001oogoo00=oo`03001oogoo01=oo`05
001oogooOol00009Ool01000Oomoo`002Woo00<007oo00001goo00D007ooOomoo`0000Qoo`03001o
ogoo00Yoo`05001oogooOol0000MOol00`00Oomoo`0;Ool01`00Oomoogoo001oo`0000Aoo`08001o
ogoo001oo`00Ool0011oo`03001oogoo00Eoo`03001oogoo0040000000<007ooOol01goo00<007oo
Ool017oo00<007ooOol017oo00H007ooOol007oo0004Ool20004Ool00`00Oomoo`07Ool01@00Oomo
o`00Ool00P001goo00P007oo001oo`00Ool007oo0P0017oo00<007ooOol00P000Woo0P000Woo00@0
07ooOol0025oo`04001oo`000007Ool20005Ool20006Ool01@00Oomoogoo000017oo00<007ooOol0
2Woo00D007ooOomoo`00009oo`03001oo`00009oo`800004Ool007oo000?Ool00`00Oomoo`08Ool2
000017oo000000003Goo00@007ooOol0009oo`03001oo`0000<00003Ool007oo009oo`<00005Ool0
07oo001oo`020003Ool00`00Oomoo`09Ool01000Oomoo`0017oo0@0000000`00Oomoo`07Ool00`00
Oomoo`02Ool01000Oomoo`0017oo00<007ooOol00goo00D007ooOol007oo00<000=oo`8000aoo`<0
009oo`04001oogoo0002Ool20004Ool01000Oomoo`000Woo0P000Woo00@007ooOomoo`80009oo`80
00Eoo`03001oogoo009oo`03001oo`0000Ioo`8000Aoo`04001oogoo0006Ool200000goo001oo`07
Ool00`00Oomoo`04Ool00`00Ool00009Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`8000Io
o`03001oo`00009oo`03001oogoo009oo`05001oo`00Ool00009Ool00`00Oomoo`05Ool01000Oomo
ogoo0`0000Aoo`00Oomoo`8000=oo`03001oogoo00Aoo`80009oo`06001oogoo001oo`0017oo1000
00Eoo`00Oomoo`0000=oo`@000Aoo`05001oogooOol00004Ool20003Ool30003Ool100000003001o
ogoo00Moo`03001oogoo00Aoo`8000]oo`03001oo`00009oo`03001oogoo00=oo`03001oogoo00Eo
o`80009oo`04001oogoo000;Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00
Oomoo`0<Ool01000Oomoo`000goo00<007ooOol04goo0P000Woo00<007ooOol03Woo00D007ooOomo
o`0000=oo`<0009oo`04001oogoo0003Ool01@00Oomoogoo000017oo00<007ooOol017oo00<007oo
Ool017oo00<007ooOol03Woo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`06001o
ogoo001oo`001Woo100000Eoo`00Oomoo`00009oo`03001oo`00009oo`03001oogoo00=oo`03001o
ogoo009oo`03001oogoo00Eoo`05001oogoo001oo`020001Ool100000003001oogoo00Eoo`03001o
o`0000Ioo`06001oogooOol007oo1@000Woo00@007ooOomoo`<000Aoo`03001oogoo00=oo`@0009o
o`@0009oo`04001oogoo0003Ool20004Ool00`00Ool00003Ool01P00Oomoo`00Ool0009oo`03001o
ogoo00<000Eoo`03001oo`0000=oo`800006Ool00000Ool007oo0P001Woo00@007ooOol0009oo`80
009oo`07001oogoo001oo`00Ool00P000Woo00<007ooOol00goo00D007ooOomoo`0000Aoo`800007
Ool00000Ool007oo00000goo00<007ooOol00P000Woo0P0000Aoo`00001oo`80009oo`04001oogoo
Ool3000017oo000000000Woo00@007ooOol000Ioo`03001oogoo00Ioo`03001oogoo00=oo`04001o
ogooOol20004Ool00`00Ool000030003Ool01@00Oomoo`00Ool00P0000Aoo`00Oomoo`<000Aoo`80
00Qoo`03001oogoo00Uoo`06001oo`00Ool007oo0@0000000`00Oomoo`05Ool00`00Ool00006Ool2
0002Ool00`00Ool00002Ool200001Goo001oogoo00000Woo0P0000Eoo`00Oomoo`0000Eoo`800003
Ool007oo009oo`<000=oo`03001oo`0000Aoo`800003Ool0000000Moo`04001oo`00Ool5000017oo
001oo`0017oo0P001Goo0P0000Aoo`00001oo`800003Ool007oo00<0009oo`@000Ioo`800004Ool0
07oo0003Ool20003Ool00`00Ool00004Ool01000Ool007oo1P000Woo00H007ooOol007oo0002Ool3
000017oo001oogoo0P0000Aoo`00Oomoo`80009oo`H000=oo`80009oo`8000Uoo`03001oo`000080
00=oo`03001oogoo00<00004Ool007oo0004Ool20002Ool00`00Oomoo`02000:Ool2000017oo001o
o`0017oo0P0000Aoo`00Oomoo`<000=oo`800003Ool0000000D00003Ool007oo0040000000<007oo
Ool01Goo00<007ooOol017oo00<007ooOol01Goo0P0017oo00D007ooOol007oo0080009oo`8000Qo
o`05001oo`00Ool00003Ool00`00Oomoo`07Ool01@00Oomoogoo00000goo00H007ooOol007oo0002
Ool00`00Ool0000300000goo00000002Ool01000Oomoo`000Woo00<007ooOol01goo00<007oo0000
0Woo00@007oo001oo`D000=oo`03001oo`0000800006Ool007ooOol007oo0P001Goo00@007ooOol0
009oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo009oo`03001oogoo00Eoo`04001oogoo
Ool20003Ool00`00Ool00002Ool00`00Oomoo`05Ool30006Ool00`00Oomoo`05Ool01P00Oomoo`00
Ool000Uoo`800003Ool00000009oo`D00003Ool0000000800003Ool007oo009oo`03001oogoo0080
009oo`06001oogoo001oo`000Woo00<007ooOol017oo0P001goo0@0000000`00Oomoo`05Ool00`00
Ool00004Ool00`00Ool00005Ool00`00Ool00002Ool00`00Ool00003Ool00`00Ool00002000017oo
000007oo0`000Woo00<007oo0000100000=oo`00Ool01Woo0P000Woo00<007oo00000`0017oo0P00
0Woo0P0000Aoo`00Ool0009oo`03001oo`000080009oo`8000=oo`03001oogoo00H0009oo`03001o
o`00009oo`05001oo`00Ool00002Ool5000017oo000000000Woo10001Goo00<007oo00000Woo00<0
07oo0000100000=oo`0000000goo00L007oo000007oo001oo`0300000goo001oo`02Ool30002Ool0
0`00Ool0000200000goo00000004Ool00`00Ool00002Ool200000goo00000004Ool2000017oo0000
07oo0P0000=oo`0000000Woo00@007ooOol0009oo`8000Aoo`D00004Ool007oo0004Ool00`00Ool0
0002Ool200000goo001oo`02Ool00`00Oomoo`0200000goo001oo`02Ool00`00Oomoo`03Ool30004
Ool00`00Oomoo`02Ool100000005001oogooOol00003Ool01000Ool000000goo10000Woo00D007oo
Ool007oo00<000Ioo`@00004Ool00000Ool300000goo00000002Ool4000017oo001oogoo0P000Woo
00<007oo00000Woo00<007oo00000`000Woo00<007oo00000goo100000Aoo`000000009oo`@00003
Ool00000009oo`06001oo`00Ool007oo1@0000=oo`0000000P000Woo00@007ooOol0009oo`800006
Ool00000Ool007oo0P0000Aoo`00Ool000Eoo`05001oo`00001oo`06000017oo000007oo0`000goo
00D007oo000007oo00@00004Ool007ooOol40002Ool00`00Ool0000500001Woo001oo`00Ool0009o
o`@00003Ool007oo00X00003Ool00000009oo`T00003Ool0000000800005Ool007ooOol00002Ool0
1000Ool0000017oo0P0000Uoo`00000007oo001oo`00Ool00P0000Aoo`00Oomoo`800003Ool007oo
00=oo`800006Ool007ooOol007oo0P000Goo0@0000001@00Oomoogoo00000goo00D007ooOomoo`00
00]oo`04001oogoo0007Ool00`00Ool00003Ool00`00Ool00002Ool20002Ool200000goo00000002
0003Ool00`00Oomoo`02Ool200000goo001oo`02Ool01000Ool007oo0P000goo00<007oo00000P00
00Aoo`00Ool000Aoo`05001oogooOol00003Ool40002Ool00`00Oomoo`03Ool02@00Ool007oo001o
o`00Ool00002Ool00`00Oomoo`020003Ool00`00Oomoo`07Ool00`00Oomoo`020005Ool20002Ool0
0`00Ool00005Ool00`00Ool00002Ool00`00Ool000030003Ool00`00Oomoo`02Ool200000goo001o
o`06Ool01000Ool000000Woo00<007ooOol00goo00D007oo001oo`00009oo`8000Eoo`03001oogoo
009oo`04001oo`000002Ool4000017oo001oo`000goo0P0000=oo`00Ool00Woo00<007ooOol00goo
00@007ooOol000Eoo`03001oo`0000Ioo`80009oo`8000Moo`40000000@007ooOomoo`80009oo`D0
0003Ool000000080009oo`03001oogoo00H0009oo`800003Ool007oo00D0009oo`T00003Ool007oo
0080009oo`800003Ool0000000<00003Ool007oo00@0009oo`800003Ool000000080009oo`L0009o
o`H00003Ool0000000<00003Ool0000000@000=oo`05001oo`00001oo`03000017oo000007oo2@00
0Woo00@007ooOomoo`800006Ool00000Ool007oo1P0000=oo`0000000P0000=oo`00000010000goo
100000=oo`0000000P0000=oo`0000002P000Woo00<007oo000010000Woo00<007ooOol020000goo
400000=oo`0000000P0000Aoo`00Oomoo`D00004Ool000000003Ool300000goo000000020003Ool2
00000goo00000002Ool600000goo001oo`02Ool10001Ool100000004001oogooOol20002Ool30000
1Goo001oo`00Ool00`0000Aoo`00001oo`T00003Ool0000000L00009Ool00000001oo`00Ool007oo
00800005Ool00000001oo`020004Ool600001goo000007oo001oo`00009oo`06001oogooOol007oo
0P0000Aoo`000000009oo`L0009oo`T00003Ool00000009oo`03001oo`0000<00003Ool000000080
0003Ool0000000<00003Ool0000000D000Eoo`800003Ool0000000<00005Ool00000001oo`040000
0goo0000000300000goo00000003000017oo000007oo0P0000=oo`0000000`000Woo0`000Woo1@00
00=oo`0000000P0000=oo`0000000Woo0P0000=oo`0000000P0000=oo`0000000Woo100000=oo`00
Ool00Woo00D007oo001oo`00009oo`<00003Ool0000000@00005Ool00000001oo`070002Ool50000
0goo0000000400000goo0000000400000goo000000020002Ool100000004001oogooOol20002Ool0
0`00Ool0000200001Goo001oogoo00000Woo00@007ooOomoo`D0009oo`03001oo`0000D0009oo`04
001oo`00Ool300001Woo001oo`00Ool0009oo`05001oogooOol00003Ool00`00Ool0000300001Woo
000007oo001oo`80009oo`06001oo`00Ool007oo0`0000Eoo`00000007oo00800005Ool00000Ool0
0004Ool00`00Oomoo`02Ool200000goo000000020002Ool01000Ool007oo10000goo10000Woo1P00
00=oo`0000000P000Woo00<007oo00000Woo00<007ooOol00P000Woo0P0000=oo`0000000P000goo
0P0000Aoo`00Ool000=oo`800003Ool0000000Eoo`800006Ool007ooOol007oo0P000Woo0P0000Ao
o`000000009oo`04001oo`00Ool200000goo001oo`0900000goo00000003Ool00`00Oomoo`02Ool3
0006Ool20003Ool30002Ool02000Oomoo`00Ool007oo0002Ool700001Goo000007oo000017oo0P00
0Goo0@0000001000Oomoogoo1`0000=oo`0000001@0000Aoo`00Oomoo`H0009oo`03001oo`000100
0003Ool0000000@00003Ool0000000800003Ool007oo00800003Ool0000000<00003Ool007oo00<0
0003Ool0000000800003Ool0000000@00003Ool0000000X00003Ool0000000800003Ool0000000/0
0003Ool0000000800004Ool000000002Ool800000goo000000040002Ool700000goo0000000:0000
1Goo00000000Ool0100000Ioo`00Oomoo`00Ool300000goo00000002Ool600000goo000000050000
0goo0000000600000goo00000007000017oo000007oo7@000Woo1@0000=oo`0000002@000Woo1@00
0Goo0@0000001000Oomoogoo1`0000=oo`00Ool01@0000=oo`00Ool01`0000=oo`000000100000=o
o`0000001`0000Aoo`00001oo`@00004Ool00000Ool4000017oo000007oo3@0000=oo`0000001000
00=oo`0000005@0000=oo`000000100000=oo`0000001`0000=oo`0000001`000Woo200000=oo`00
00004@0000=oo`0000000`0000Aoo`00001oo`H00003Ool0000001@00003Ool007oo00L00005Ool0
0000001oo`09000017oo000007oo200000=oo`0000000P0000=oo`0000003@0000=oo`0000003P00
00Moo`00000007oo001oo`0100000004001oogooOol6000017oo001oogoo20000Woo00<007ooOol0
0P0000=oo`0000000P000Woo1@000Woo0`0000=oo`0000000`0000Eoo`00000007oo0080009oo`07
001oo`00001oo`00Ool00`0000Eoo`00000007oo00D0009oo`03001oo`0000L000=oo`P00003Ool0
07oo00<00003Ool00000008000=oo`8000=oo`/00004Ool000000002Ool30002Ool00`00Oomoo`06
000017oo000007oo1`0000=oo`00000010000Woo1`0000=oo`0000001P0000=oo`0000000`0000=o
o`0000000goo100000Ioo`00Oomoo`00Ool400000goo000000030003Ool700001Goo001oogoo0000
0Woo0P0000=oo`00Ool00P0000=oo`000000100000=oo`0000000`0000=oo`0000000P0000Eoo`00
000007oo00<00003Ool0000000800003Ool0000000<00004Ool007ooOol100000004001oogooOol;
00000goo0000000T00000goo0000000C00000goo0000000b0002Ool200000goo0000000A00000goo
0000000300000goo0000000800000goo0000000P00000goo0000000@00000goo0000000F00000goo
00000005000017oo000007oo6@000Goo0@0000000`00Oomoo`0:00000goo0000001?00000goo0000
000S00000goo0000000D00000goo0000000E00000goo000000060002OolY00000goo0000000c0001
Ool100000003001oo`0001800004Ool00000Ool900000goo0000000=00000goo0000000?00000goo
00000005000017oo000007oo0`0000=oo`0000000`0000=oo`0000001P0000=oo`0000006P0000=o
o`000000300000=oo`000000100000Eoo`00000007oo00800003Ool0000000D00003Ool0000000D0
0003Ool0000000<00003Ool0000000<00003Ool0000000<00003Ool0000000800005Ool00000001o
o`020002Ool500000goo0000000?00000goo0000000:00000goo0000000300000goo0000000U0001
Ool100000003001oo`0004@00003Ool0000008/00003Ool0000004H0005oo`40000000<007oo0000
o`0070000Goo0@0000000`00Ool0003o000L0001Ool100000003001oo`0000P00003Ool0000003<0
0003Ool000000</00003Ool0000000`0005oo`40000000<007oo0000o`0070000Goo0@0000000`00
Ool0003o000L0001Ool100000003001oo`000>`00003Ool0000000800003Ool0000002L0005oo`40
000000<007oo0000o`0070000Goo0@0000000`00Ool0003o000L0001Ool100000005001oo`00001o
o`0200000goo0000000S00000goo0000000b00000goo0000000800000goo0000000B00000goo0000
000C00000goo0000000800000goo0000000500000goo0000000600000goo0000000500000goo0000
000U000017oo000007oo2`0000=oo`000000:0000Goo0@0000000`00Ool0000?00000goo0000000H
00000goo0000002F00000goo0000000Q00000goo0000000a0001Ool100000003001oo`0000T00003
Ool0000001H00003Ool0000002D00003Ool0000001L00003Ool0000002T00003Ool0000000800003
Ool0000004l00003Ool0000002800003Ool0000000`0005oo`40000000D007oo000007oo00<00003
Ool007oo00800004Ool00000Ool900000goo00000004000017oo000007oo10000Woo0P0000=oo`00
00000Woo0P000Woo0P0000Moo`00000007oo001oo`040002Ool300000goo0000000;00000goo001o
o`04000017oo000000000goo2`0017oo1@0000Moo`00000007oo001oo`0500000goo000000050000
17oo000000000Woo2P0000Moo`00Ool007oo001oo`0200000goo00000007000017oo001oogoo0`00
00=oo`0000000`000Woo0`0000=oo`0000001@000Woo100000Eoo`00000007oo00L00004Ool00000
Ool3000017oo000007oo1@0000=oo`00Ool01`0000Eoo`00Ool007oo0080009oo`<00005Ool007oo
Ool00002Ool01000Ool0000017oo1@0000=oo`00000010000goo0@0000000`00Ool0000>00000goo
0000000400000goo0000000200000goo0000000@00000goo0000000=00000goo0000000C00001Goo
00000000Ool01P0000=oo`0000002@0000Moo`00000007oo001oo`030002Ool;00000goo00000006
00000goo0000000L000017oo000007oo2`000Woo0P0000=oo`0000002`0000=oo`0000000P0000=o
o`0000000P0000=oo`00Ool01@0000=oo`0000002@0000=oo`0000002P0000=oo`0000001`0000=o
o`000000200000=oo`0000002P0000Eoo`00000007oo0040000000<007ooOol01@0000=oo`000000
100000=oo`00Ool00`0000Aoo`00001oo`800005Ool00000001oo`05000017oo000007oo0`0000=o
o`00Ool0300000=oo`0000001P0000=oo`00Ool00P0000Eoo`00Ool007oo00D00003Ool0000000<0
009ooaT00005Ool00000001oo`0G0002Ool700000goo0000000600000goo0000000>00000goo0000
00050003Ool300000goo0000000200000goo0000000300000goo0000000200000goo000000040000
0goo0000000700000goo0000000E00000goo0000000300001Goo00000000Ool0200000=oo`000000
0P0000=oo`0000001@0000Eoo`00000007oo0040000000<007ooOol01@000Woo1@0000Aoo`00Oomo
o`800004Ool007ooOol20002Ool00`00Oomoo`04000017oo001oo`000Woo00D007ooOomoo`00009o
o`<00003Ool007oo00<00003Ool0000000@000=oo`8000=oo`<00003Ool007oo00800003Ool00000
0080009oo`8000=oo`04001oogoo0002Ool600000goo001oo`02Ool01000Oomoogoo0`0000=oo`00
Ool02@0000=oo`000000100000=oo`0000001@0000Aoo`00001oo`L000=oo`03001oo`0000<00004
Ool00000Ool8000017oo001oo`000Woo00<007oo00000`000Woo100000=oo`00Ool01@000goo00@0
07ooOol000Ioo`800003Ool007oo00@00004Ool00000Ool60003Ool00`00Oomoo`04Ool400001Goo
000007oo00000Woo1@000Woo0`000Woo00<007ooOol01P0000Aoo`00Oomoo`8000=oo`40005oo`40
000000<007ooOol01@0000Eoo`00000007oo00800004Ool007oo0002Ool3000017oo000007oo2000
00Aoo`000000009oo`80009oo`<00003Ool0000000/0009oo`D00003Ool0000000@00003Ool00000
00<00003Ool0000000D0009oo`T0009oo`03001oo`0000@00005Ool00000001oo`0600000goo0000
0004000017oo000007oo0P000Woo0P0000Aoo`00001oo`800003Ool0000000<0009oo`H00003Ool0
000000@0009oo`@00003Ool0000000<00004Ool00000Ool800000goo00000002Ool4000017oo0000
07oo1@0000Aoo`00Ool0009oo`04001oo`00Ool6000017oo000007oo1`0000=oo`00Ool01@0000Yo
o`00Oomoo`00Ool007oo001oo`L00003Ool0000000H00003Ool0000000@00003Ool0000000L0005o
o`40000000<007ooOol00Woo0`0000=oo`000000100000Aoo`00Oomoo`D00004Ool00000Ool50000
17oo001oogoo2@000Woo00<007oo00000P0017oo0`0000=oo`0000000`0000Eoo`00000007oo00L0
009oo`<00003Ool00000009oo`800005Ool007oo001oo`060003Ool20002Ool00`00Ool00002Ool0
0`00Ool000020002Ool00`00Oomoo`0600001Goo001oo`00Ool01@0000Eoo`00000007oo00800004
Ool00000Ool400001Woo000007oo001oo`800003Ool0000000<00004Ool007ooOol2000017oo0000
07oo0P0000Aoo`00001oo`L00003Ool00000009oo`H00004Ool000000002Ool200000goo00000002
Ool20002Ool20002Ool4000017oo001oogoo0P000Woo00<007oo00001@000goo10000goo2P0000Mo
o`00000007oo001oo`04000017oo001oogoo10000Woo0P000Goo0@0000000`00Oomoo`02Ool30003
Ool00`00Ool00004Ool01000Ool007oo0P0000Ioo`00Oomoo`00Ool300000goo001oo`02Ool30002
Ool00`00Ool0000:Ool200000goo001oo`02000027oo000007oo001oo`00Ool5000017oo001oo`00
0Woo00<007oo000017oo00@007oo000000Aoo`03001oo`0000=oo`03001oogoo00800003Ool007oo
00Aoo`@00006Ool00000Ool007oo0`000Woo00<007ooOol00goo00<007oo00000Woo00<007oo0000
0Woo0`0000=oo`00Ool01Woo00@007ooOol000=oo`80009oo`05001oogooOol00002Ool20004Ool0
1`00Ool00000Ool007oo00800004Ool007oo0002Ool30004Ool200000goo001oo`04Ool200000goo
00000005Ool20003Ool00`00Ool00004Ool200000goo00000003Ool300000goo001oo`02Ool01000
Oomoo`000goo00H007oo001oo`00Ool50003Ool01@00Oomoo`00Ool00P001Goo00<007ooOol00@00
00000`00Oomoo`02Ool3000017oo001oo`0017oo00@007ooOol0009oo`06001oogooOol007oo1`00
17oo00@007oo001oo`800004Ool007ooOol30004Ool300000goo000000020003Ool3000017oo001o
ogoo0`000Woo00D007oo000007oo00@00003Ool0000000800003Ool0000000D00003Ool007oo0080
0003Ool0000000Aoo`04001oo`00Ool20005Ool20004Ool300001Goo001oo`00Ool010000Woo00H0
07oo000007oo0002Ool20005Ool400001Goo001oogoo00000Woo0`0000Moo`00Ool007oo001oo`03
00000goo000000030003Ool01000Oomoo`000Woo00@007oo000000=oo`800003Ool0000000D00004
Ool00000Ool30002Ool01@00Ool007oo00000goo00H007oo001oo`00Ool40003Ool500000goo001o
o`03Ool300000goo001oo`060002Ool300000goo0000000300000goo000000030002Ool100000003
001oogoo009oo`<00005Ool007ooOol00005Ool300000goo00000005Ool60002Ool01000Oomoogoo
1@0000=oo`0000000Woo00D007ooOol007oo00<00003Ool0000000<0009oo`04001oo`00Ool20002
Ool00`00Ool0000400000goo000000020002Ool4000017oo001oogoo1P0000Moo`00Oomoo`00Ool0
0003Ool300000goo00000002000017oo000000001Goo0`0000Aoo`00Oomoo`800004Ool007ooOol2
0002Ool00`00Ool000040004Ool200002Goo00000000Ool007oo001oo`0300000goo000000080000
1Woo00000000Ool0009oo`06001oogooOol007oo2P0000Aoo`00Oomoo`<00003Ool007oo009oo`04
001oogooOol300000goo0000000200000goo00000005000017oo001oo`000Woo00H007ooOol007oo
0002Ool00`00Oomoo`020005Ool7000027oo00000000Ool007oo0002Ool20002Ool00`00Oomoo`01
00000003001oogoo00=oo`800003Ool007oo009oo`8000Moo`06001oogooOol007oo0`000goo00H0
07ooOomoo`00Ool200000goo00000003Ool01`00Oomoogoo001oo`0000Moo`8000=oo`8000=oo`06
001oo`00Ool007oo0P001Woo0P0000=oo`0000001goo00<007ooOol00goo00D007oo001oo`0000Mo
o`8000Ioo`03001oogoo00Aoo`800003Ool007oo0080009oo`800003Ool00000009oo`8000Moo`09
001oogooOol007oo001oo`0000Aoo`05001oogooOol00006Ool00`00Oomoo`0:Ool00`00Ool00002
Ool02P00Ool00000Ool007oo001oo`000Woo00D007oo001oo`0000Aoo`03001oogoo009oo`<0009o
o`04001oo`000008Ool01@00Ool007oo00000goo00<007ooOol017oo00L007ooOomoo`00Ool00008
Ool00`00Oomoo`04Ool00`00Oomoo`02Ool20002Ool100000003001oogoo00=oo`800006Ool007oo
001oo`000Woo00<007oo00000`0000=oo`00Ool00P000goo0P0000Eoo`00Ool007oo0080009oo`80
009oo`80009oo`03001oogoo00=oo`03001oogoo00D0009oo`05001oogooOol00002Ool01@00Ool0
07oo00000Woo00@007oo000000=oo`03001oo`0000=oo`03001oo`0000L00005Ool00000Ool00002
Ool20002Ool01@00Oomoo`00Ool00`0000Eoo`00000007oo0080009oo`H000Aoo`80009oo`800003
Ool0000000<00003Ool007oo00=oo`07001oo`00Ool007oo00000Woo00<007oo00000`0000Aoo`00
Ool000=oo`03001oo`0000Eoo`80009oo`8000=oo`@00004Ool00000Ool200000goo00000002Ool0
1000Oomoo`000goo00H007ooOomoo`00Ool200001goo00000000Ool007oo00800003Ool007oo0080
0007Ool00000Ool007oo00000Woo1@0000Eoo`00001oo`0000=oo`05001oo`00Ool00002Ool70000
0goo001oo`07Ool100000003001oogoo00Aoo`03001oo`00009oo`<00003Ool007oo0080009oo`05
001oogooOol00004Ool30004Ool01@00Ool007oo00000Woo1@0000=oo`00Ool00Woo00@007oo001o
o`@0009oo`03001oogoo008000Aoo`0:001oo`00001oo`00Ool007oo0003Ool00`00Oomoo`04Ool3
0002Ool40003Ool00`00Ool00004Ool200000goo00000002Ool30008Ool01000Ool000000goo1@00
00Aoo`00Oomoo`<0009oo`8000Ioo`03001oo`0000800003Ool0000000Moo`03001oogoo00=oo`0:
001oogooOol007oo001oo`00Ool20002Ool00`00Ool00002Ool00`00Ool000020002Ool00`00Oomo
o`020003Ool01000Ool007oo0P0017oo10000Woo00T007ooOomoo`00Ool007oo00000Woo1P001Goo
0P000Woo00H007oo001oo`00Ool400001Goo001oogoo00000Woo0P0017oo0P0000Eoo`00Ool007oo
0040000000<007ooOol017oo00H007oo001oo`00Ool20003Ool01000Oomoogoo0P002Goo00<007oo
Ool017oo00H007oo000007oo0002Ool00`00Oomoo`0200000goo001oo`02Ool3000017oo001oo`00
0goo00<007ooOol01Woo0`0027oo00<007ooOol017oo0P000goo00<007oo00001Goo00<007ooOol0
17oo00@007oo001oo`<00004Ool007ooOol30002Ool00`00Oomoo`03Ool00`00Ool00004Ool01000
Ool000000goo0`001Goo0P001Goo00H007oo000007oo0004Ool300000goo001oo`03Ool00`00Oomo
o`020002Ool200000goo001oo`03Ool20003Ool20003Ool00`00Ool00003Ool50004Ool01000Oomo
ogoo0`000goo00<007ooOol00Woo00<007oo000017oo00P007oo000007oo001oo`000Woo1@0000=o
o`00Ool01Goo00<007oo00001Woo0P000goo0P000Goo0@0000000`00Oomoo`08Ool400000goo001o
o`02Ool01000Oomoo`000Woo00@007oo000000Aoo`04001oogoo0004Ool01`00Oomoogoo001oo`00
00eoo`03001oogoo00Qoo`8000=oo`03001oogoo00Yoo`06001oogoo001oo`003Goo00@007ooOol0
00Ioo`05001oogooOol00009Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool01000Oomoogoo0P001Goo
00<007ooOol02Goo00@007ooOol000=oo`03001oogoo00aoo`04001oo`000005Ool00`00Ool00002
Ool20003Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool20002Ool00`00Oomoo`0<
Ool01@00Oomoo`00Ool00P0017oo0P001Woo0@0000000`00Oomoo`08Ool40003Ool200000goo0000
0003Ool00`00Oomoo`03Ool00`00Oomoo`02Ool03000Oomoo`00Ool007oo001oo`00Ool000Eoo`03
001oogoo0080009oo`03001oo`0000Aoo`8000=oo`04001oogooOol2000017oo0000000017oo00@0
07ooOomoo`80009oo`04001oogoo0005Ool00`00Oomoo`09Ool20002Ool01000Ool000000Woo00<0
07oo000027oo0P000Woo0P001Woo00<007ooOol017oo00@007ooOol000Aoo`03001oogoo009oo`04
001oo`000002Ool2000017oo001oogoo0P000goo0P0000=oo`00Ool00goo00@007ooOomoo`8000Eo
o`<0000:Ool007oo001oo`00Ool007oo0002Ool00`00Oomoo`03Ool01000Ool007oo0P000goo0P00
1Goo00<007ooOol017oo00<007oo00000P001Woo00@007oo000000Aoo`03001oogoo00Uoo`80009o
o`03001oogoo0040000000<007ooOol027oo00<007oo00000Woo00<007oo00000P0000=oo`00Ool0
0Woo00H007oo000007oo0003Ool01000Oomoo`0017oo0P0000=oo`0000000goo00<007ooOol01goo
00<007oo00000P000Woo00<007ooOol017oo00<007oo00000goo0P0017oo00<007ooOol01Goo00<0
07ooOol00goo0`002Woo00<007ooOol00goo00<007ooOol01@0017oo0`000goo00@007ooOol0009o
o`06001oogooOol007oo0P001Woo0P000goo00<007ooOol00Woo00@007oo001oo`80009oo`03001o
o`00008000Aoo`03001oogoo008000Eoo`03001oo`0000Aoo`05001oogoo001oo`020002Ool30002
Ool00`00Oomoo`04Ool01000Oomoo`000Woo00<007oo00000goo00<007ooOol017oo0P0000=oo`00
Ool00Woo00@007ooOomoo`8000Eoo`07001oo`00001oo`00Ool00P0017oo00@007ooOol000=oo`03
001oogoo0080009oo`40000000<007ooOol03Goo00D007ooOomoo`00009oo`03001oogoo00Eoo`03
001oogoo00=oo`04001oogoo0007Ool00`00Oomoo`0>Ool00`00Oomoo`08Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool20006Ool30006Ool00`00Oomoo`0=Ool01000Oomoo`000Woo00<007oo00002Woo
00@007ooOol000=oo`03001oogoo009oo`03001oogoo01Ioo`8000Yoo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo00Ioo`8000Aoo`03001oogoo00aoo`04001oogooOol20003Ool00`00Oomo
o`02000<Ool00`00Oomoo`06Ool00`00Oomoo`05Ool01000Oomoo`002Goo0@0000000`00Oomoo`0=
Ool00`00Oomoo`09Ool01@00Oomoogoo000017oo0P0000=oo`00Ool00P000Woo0P000goo0P000Woo
00<007ooOol00P000Woo00<007ooOol017oo00<007ooOol00goo0P000goo00@007ooOol000Qoo`04
001oogoo0008Ool01000Oomoogoo0P0017oo0`001goo00@007ooOol000Eoo`05001oogooOol00006
Ool00`00Ool00002Ool00`00Ool00004Ool01000Oomoo`0017oo00<007ooOol027oo00<007oo0000
0Woo00<007ooOol017oo00<007ooOol01Goo00<007ooOol00P0027oo00<007oo00000P001goo00<0
07ooOol00Woo00@007ooOomoo`80009oo`04001oogooOol60002Ool01@00Oomoogoo00000Woo0P00
0goo0`0000Aoo`00000000Uoo`8000Eoo`800003Ool007oo009oo`40000000<007ooOol03Goo00P0
07ooOol007oo001oo`001Goo00<007ooOol00goo00<007oo00000Woo00@007ooOol0009oo`03001o
o`0000Qoo`80019oo`03001oo`0000Ioo`03001oo`00009oo`03001oogoo009oo`03001oo`00009o
o`03001oogoo00Ioo`04001oogooOol30002Ool00`00Oomoo`020008Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool01@00Ool007oo00001Woo00D007ooOomoo`0000Aoo`03001oogoo00Uoo`03001oogoo
009oo`03001oo`0000Ioo`03001oogoo00Aoo`800005Ool007ooOol00002Ool00`00Oomoo`06Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Ool00004Ool20005Ool01000Oomo
o`001Woo00<007oo00000Woo0`0000Aoo`00Ool000=oo`03001oo`00009oo`03001oo`0000Eoo`40
000000<007ooOol047oo00<007ooOol01goo00<007oo000047oo00<007ooOol03Woo00D007ooOomo
o`0000Uoo`03001oogoo019oo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo009oo`03001o
o`0000Qoo`03001oogoo00Eoo`800004Ool000000006Ool00`00Oomoo`0GOol01000Ool000001Goo
00<007ooOol00Woo00<007ooOol08Goo0P001Woo0P0017oo00<007oo00000goo00<007ooOol07goo
00@007oo001oo`40000000<007ooOol047oo00<007oo00002Goo0P000Woo00@007ooOol000=oo`<0
0004Ool000000003Ool00`00Oomoo`07Ool20005Ool01@00Oomoogoo00000Woo00<007ooOol017oo
00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`8000Moo`04001oogoo0002Ool01000
Oomoo`0017oo00D007ooOomoo`0000Aoo`8000Aoo`03001oogoo00Moo`80019oo`800003Ool007oo
009oo`03001oogoo00Yoo`07001oogooOol007oo00001Goo0`000goo0`003Goo00H007oo001oo`00
Ool20002Ool00`00Ool00006Ool20005Ool01000Oomoo`001Goo0P0000Aoo`00Ool000=oo`@00004
Ool000000002Ool00`00Oomoo`05Ool10001Ool100000003001oogoo011oo`03001oo`0000Moo`03
001oo`0000Ioo`03001oogoo00=oo`04001oo`000009Ool00`00Ool00009Ool00`00Oomoo`05Ool0
0`00Oomoo`0<Ool01@00Oomoogoo00000goo0P0000=oo`00Ool00goo00<007ooOol00goo00H007oo
Ool007oo0002Ool30003Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01P00Oomoo`00Ool000=oo`06
001oogoo001oo`000Woo00D007oo001oo`0000=oo`03001oo`00009oo`04001oogoo0002Ool00`00
Oomoo`03Ool2000?Ool01000Oomoo`001Goo0`000Woo00<007ooOol00Woo0P0000=oo`00Ool01goo
00<007oo000027oo00<007oo00002Goo00<007ooOol01Goo00@007ooOol000Aoo`03001oogoo011o
o`40000000<007ooOol06Woo00@007ooOol0009oo`03001oogoo015oo`03001oogoo02]oo`8003Eo
o`04001oogoo000:Ool00`00Oomoo`0IOol00`00Oomoo`05Ool00`00Oomoo`08Ool00`00Oomoo`03
Ool00`00Oomoo`0?Ool01000Oomoo`001Woo00<007ooOol037oo00@007ooOol000Yoo`03001oogoo
00Aoo`40000000<007ooOol087oo00@007ooOol000=oo`04001oogooOol20007Ool01@00Oomoogoo
00000goo00<007ooOol02goo00@007oo0000015oo`05001oogoo001oo`020009Ool00`00Oomoo`03
Ool01000Oomoo`0027oo00<007oo00001goo00<007oo000027oo00<007ooOol00goo00<007ooOol0
17oo00D007oo000007oo0080009oo`03001oo`0000Qoo`03001oogoo00Eoo`05001oogooOol00002
Ool00`00Ool00002Ool00`00Oomoo`0BOol00`00Oomoo`09Ool01000Oomoo`002goo00D007ooOomo
o`0000Ioo`<000Ioo`03001oogoo00=oo`03001oogoo009oo`40005oo`40000000<007ooOol07Goo
00@007ooOol000Ioo`04001oogooOol20004Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Ool0
0003Ool01@00Oomoogoo00000Woo00<007ooOol00goo00@007ooOol000Eoo`03001oogoo00Aoo`<0
009oo`03001oogoo00Aoo`06001oogoo001oo`000Woo00<007ooOol02goo00<007ooOol01Woo00<0
07ooOol00Woo00@007oo000000Uoo`03001oo`0000=oo`80011oo`03001oo`00009oo`03001oogoo
009oo`03001oo`0000Aoo`03001oogoo00Moo`04001oogoo000;Ool00`00Ool0000@Ool01@00Oomo
ogoo00000Woo00D007ooOomoo`0000Aoo`03001oogoo00Moo`03001oogoo00Aoo`40000000<007oo
Ool0:Goo00<007oo000027oo00<007oo00004Goo00@007oo001oo`8000ioo`03001oogoo00Ioo`03
001oogoo00=oo`03001oogoo00aoo`04001oogoo0003Ool00`00Oomoo`0:Ool00`00Oomoo`0YOol0
0`00Oomoo`02Ool00`00Oomoo`0<Ool2000DOol00`00Oomoo`03Ool00`00Oomoo`0<Ool00`00Oomo
o`09Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool100000003001oogoo01eoo`03
001oogoo00Moo`03001oo`0000Moo`03001oogoo00Moo`03001oogoo00Qoo`05001oogooOol00008
Ool00`00Ool0000DOol2000aOol00`00Oomoo`05Ool20003Ool00`00Oomoo`03Ool00`00Oomoo`0=
Ool01@00Oomoogoo00000Woo00<007ooOol017oo00<007ooOol01Woo00<007ooOol07Woo0P0037oo
00<007ooOol037oo00<007ooOol017oo0@0000000`00Oomoo`0MOol00`00Oomoo`0FOol00`00Oomo
o`0GOol00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Ool00007Ool00`00Oomoo`0EOol00`00Oomo
o`0:Ool01000Oomoo`0067oo00D007ooOomoo`0001Aoo`05001oogooOol00002Ool00`00Oomoo`0K
Ool01@00Ool007oo00006goo00<007ooOol01Woo00<007ooOol027oo0@0000000`00Oomoo`0YOol0
0`00Oomoo`05Ool00`00Oomoo`1DOol00`00Oomoo`0KOol00`00Oomoo`0>Ool00`00Oomoo`06Ool0
1000Oomoo`00A7oo00<007ooOol04Goo0@0000000`00Oomoo`0aOol00`00Oomoo`07Ool00`00Oomo
o`0EOol00`00Ool00003Ool00`00Oomoo`09Ool01000Oomoogoo0P002Woo00@007ooOol000Qoo`03
001oogoo00Aoo`04001oogoo000:Ool00`00Oomoo`04Ool00`00Oomoo`0@Ool00`00Oomoo`0<Ool0
0`00Oomoo`02Ool01000Oomoo`000goo00D007ooOomoo`0000Ioo`04001oogoo0009Ool00`00Oomo
o`05Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`04Ool00`00Oomoo`0<Ool20009Ool1
00000003001oogoo035oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo
009oo`04001oogoo0002Ool00`00Ool00003Ool00`00Oomoo`09Ool01@00Oomoogoo000027oo00@0
07ooOol0009oo`03001oo`0001=oo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo009oo`03
001oogoo009oo`8000]oo`03001oogoo00eoo`8001Yoo`03001oo`00009oo`03001oogoo025oo`03
001oogoo00Yoo`40000000<007ooOol0=Woo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol0
0Woo00@007ooOol000]oo`06001oogoo001oo`0067oo00<007ooOol03Woo00<007ooOol05Goo00<0
07ooOol04Goo00<007ooOol07goo00<007ooOol037oo00<007ooOol09goo00<007ooOol01goo0@00
00000`00Oomoo`0fOol00`00Oomoo`0GOol01000Oomoo`0027oo00<007ooOol01Woo00<007ooOol0
2Woo00@007ooOol001]oo`03001oogoo009oo`03001oogoo009oo`03001oo`0000Moo`03001oogoo
029oo`8000Yoo`03001oogoo00Moo`05001oogooOol00007Ool00`00Oomoo`0FOol00`00Oomoo`02
Ool01000Oomoo`003Woo0@0000000`00Oomoo`1jOol00`00Oomoo`0;Ool00`00Oomoo`0BOol00`00
Oomoo`08Ool00`00Oomoo`02Ool200000goo001oo`08Ool00`00Oomoo`0LOol00`00Oomoo`07Ool0
0`00Oomoo`0;Ool00`00Oomoo`0>Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool100000003001oogoo
04Qoo`03001oogoo009oo`03001oogoo00moo`03001oogoo01Ioo`03001oogoo011oo`03001oogoo
021oo`03001oogoo00Ioo`03001oogoo02Uoo`8000Moo`03001oogoo02eoo`40000000<007ooOol0
B7oo00<007ooOol00Woo00<007ooOol037oo00<007ooOol06Goo00<007ooOol047oo00<007ooOol0
5goo00<007ooOol027oo00<007ooOol017oo00<007ooOol09Woo00<007ooOol02Goo00<007ooOol0
2Goo00<007ooOol03goo00@007ooOol000ioo`40000000<007ooOol0Ggoo00<007ooOol0;goo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol017oo00@007ooOol000aoo`03
001oogoo00Moo`03001oogoo03]oo`03001oogoo00aoo`03001oogoo00Qoo`40000000<007ooOol0
Ggoo00<007ooOol0=7oo00<007ooOol057oo00@007ooOol000Uoo`03001oogoo02ioo`03001oogoo
00Yoo`03001oogoo00Moo`04001oogoo0009Ool00`00Oomoo`0:Ool100000003001oogoo079oo`03
001oogoo031oo`03001oogoo01aoo`03001oogoo01eoo`03001oo`0000Yoo`03001oogoo02Qoo`40
000000<007ooOol0LWoo00<007ooOol08Goo00<007ooOol037oo00<007ooOol0?7oo00<007ooOol0
9Woo00@007ooOomoo`8000Uoo`40000000<007ooOol0TGoo00<007ooOol05Woo00<007ooOol0<goo
00<007ooOol027oo00<007ooOol00goo00<007ooOol06Goo00<007ooOol037oo0@0000000`00Oomo
o`3VOol00`00Oomoo`0QOol00`00Oomoo`0?Ool100000003001oogoo095oo`03001oogoo031oo`03
001oogoo01Uoo`03001oogoo00ioo`03001oogoo015oo`03001oogoo00Yoo`03001oogoo00Moo`40
000000<007ooOol0LWoo00<007ooOol0Pgoo00<007ooOol03goo00<007ooOol03goo0@0000000`00
Oomoo`2AOol00`00Oomoo`1<Ool00`00Oomoo`0iOol100000003001oogoo0?Qoo`03001oogoo00Yo
o`03001oogoo009oo`03001oogoo00moo`40000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3o
Ool6Ool00`00Oomoo`0DOol100000003001oogoo0?Qoo`03001oogoo025oo`40000000<007ooOol0
ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeoo`40000000<007ooOol0
ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeoo`40000000<007ooOol0
ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeoo`40000000<007ooOol0
ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeoo`40000000<007ooOol0
ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeoo`40000000<007ooOol0
ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeoo`40000000<007ooOol0
ogoo7Goo0@0000000`00Oomoo`3oOolMOol100000003001oogoo0?mooaeoo`400000o`008@000000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250053, 
  0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["WindowsSound", "\<\
DTU6AUN1001G@EI5IVed8100000100404B/0014[000100P0I65dHC>1001gN7Uj
Ng]kO7alO7alO7alO7alO7alNg]kNg]kNgYjNWYjNGUiNGQhN7QgMgMgMgIfMWIf
MWIfMWIfMWIfMWIgMgMhN7UiNW]kO7enOh21PH:3Q8F6QhR9RX^<S8f=SXj>SXj>
SXj=SHb;RXV8QhJ5Ph:1OgimO7YiNGQgMgIfMWIgMgQiNW]mOX21PhF6R8Z;SHj?
T96ATY:BTI6@Shj<RhV7QXB2PGmnO7]kNWYjNWYkO7eoP8:4QXR9Rhf>T96BTY:B
TY6@Shf;RHN5PX1nO7YhMgEeM7AdMGEfN7UkOGn0PX>5QXJ7QhJ6Q8>1OgejN7Ec
LFi/JfUYJ6QXJF]/KW1cMGMjO7j0PX>4Q8B4Ph:0OWekNGMfM7=cLW=cM7IhNWf0
PXF8Rhf?T96BTY:AShf;R8J3P7ekNGMeM7AdM7EgN7YlOWn1PX>3Ph>2P7ilNGIc
L6e[JFMVIFEUIfQ[KG1cMgYmP8:4QXJ7QhJ5Ph5oOG]iN7IfMWIgN7YlOh64QXR:
Rhb<S8^9QXB0OGUfLVm]JfUXJ6UZK6iaM7MjO7n1PX>4Ph>1P7ilNgUhMgMgN7Yl
OX:5RHb?TiFGVIVIV9JDTHj:QX>0OGYiN7QhNG]mOh:4QhV:Rhb<RhZ8QXB2Ogel
Ng]kO7j1Q8N;SY:EV9ZLW9bKVIJBSh^7PgmlNGMfMWIgN7YlOX21PX>3PX1nO7Ug
M75_KVe]KVmbMGQlP8B8Rhj@TI6@SXb9QH5nNWMeLg9bLgAfN7]mP8:4QHJ6QHB2
P7ilNWUhN7UkOH24RHfBUYZMWj2QX9jLV9FAS8R5PX1nOGioP8:4QXR:Rh^;RXR6
Ph1mNWQfMGEfN7YmPHB8S8nATi>CTHn<R8=oNWIcL6i^KVmaLgIiO7n2Q8F5QHB3
PGmmO7]kO7f0PhJ:SY>FVI^MWIbJUY:>RHAoNgMeLg=cM7IiO7n1Q8F6QXF3PGil
NGIdLg9bLgEgNWf0PXB5QHB2Og]gLVeYIF9PGf1QI6M/L7EjOX:4QXN7QXB2P7il
Ng]kO7f0PXF7RHZ;RhV7PgmjMW5]JFMUIFIXJfmcN7b0PhJ7QhJ4PWikN7AbL6m`
LG9eMgYmOh62PX5oOG]hMWAcLgAfNGf2QhfBUi^NX:2OW9VET8^6PWikNWUiNWan
P8:3Q8B3PGmlNGIcLG1`LG=fNGf1QHV;SHf<RXN3OWUdL6eZJFU[KG5eNGf1QHN8
RHR6Q85nO7UhMgMhNG]mOh62PX5oNgMbKFQSGeaJFEYMH6E[L7IkP8>5QXJ5Ph1n
NgUhMgMiNgj1Q8N9RX^:RHN4PGejN7MfMgUlP8F9SI6DUIFDTHf8PWagLVi[JFUZ
K6mcMgYmOh61PH1nO7]iNGUjO7n3QXZ>T9:BTHn;QX1jMFm[J6IUIVU/LGEjOX63
Q8B3P7ijMgEcLW9cMGMkOX64QXN8QhF3P7ilNWYkOX66Ri6GW:6TYZJUXYfHTXb6
PGikNWYkO7n1Q8J7QhN5Ph5oO7]jNgaoPXJ;Si>EUiNFThn;QH1kMgAbLW=fNWj3
R8b?TI6@SX^7PgmlNGMgMgQjOGn2PhB4Ph5oO7UgMWEfNGb1QhjDVYjRY:BRWiZE
SXR3OWYhMWMhNWanP861PGmlNGIcL6i^KVmbMGUmP8:4Q8>0OGQdKf]XIfMXK71f
O8:7S8nATI2=RHF0O7UfMGAeMgUlOX21PH5oOG]hMgIfMgYnQ8Z@UY^OXZ>RWi^F
T8Z4Og]iN7QjOH64QhV;RhZ8QH5nNgUgMgQjOH24QhV;RhZ8QH5nNgUhN7YmPXR?
UIbQY:JVY:6LUY2:QH5nO7alOX22Q8F6QHB2OgajN7QhNWf1QHZ>TI>DTi2;QX1i
Lfi[J6QYK71eNGj2Q8F5Ph5mNGEbL6m_LG=fNWj1PhB5Q8>1OgelO7j1QHZ?UI^O
XZ>RX9^ESXIoNG=`KVe_LGEiOH22PhB3PGmmNgYjNgf0PhN;SY2@Shf:QH5lN7Ec
LgEhO8:7S92CU9BASHR2O7MbKfe]KW5dN7aoPH:2PGmmNWQgMWMhNWf0PXB4Ph1l
MW1YHUaGE5=DEeaRJG1fNgn2PX:0OW]iMgIgNG]oPhJ9Rhb<RXN4P7ejNGQjO7n3
QhZ=SXf;Qh5kMFiYIF=SIFU^M7^1QXZ<SHb:QhB0OG]jNW]lOX21PH1nNgMcKf]Y
J6U[KgEkPXV>TYBEThn:QGmiMG9`L79eNGb0PhB5Q85nNWMdLG1`LWAgNgj1PX>2
P7ikN7IeMWQlPXVAV9nUZJZZYj:LUHj7PWikNW]lOh63QHF4Ph1mNgQgMWMiO824
QhZ;RhV5P7YdKVYVIFIXK75gOH:5QhN6PWiiM6m/JVY[KW9fNWj1Ph>3PGmmNgYi
NWaoPXF8RHV7Q7ihLFUSGUYIFUeSJG5hOhF9Rhb:R8F2OgelO7j0PXF7R8R7Q85l
N7=`KVe^LGAhO7n1PX1mNG=]J6=OGUiQIVacNX66RXb<RhR4P7aiMgIgNG]nPH>4
Q8>2OgelNg]nPHJ<TiVOXjFTXIfFShMoNGAaL75cMg]oPXB4Ph5mNGIcLG1aLgIi
OH63QHF4PGikN7IfMWUlPHJ:SY2@SXZ4OGE]IV1MG5ePIF]bN7f1Q8F4Ph5oOWen
Oh64QhZ;S8^8Q81kMg=aLG=gO8:9SiBHVIRETH^5OgYfM7AfNGf1QHR:RhV6Pgij
MgAcLgEgNgj1Ph>3PWmmNgYjO826SIFMY:Z^/:n/YYnGShR2OWakOH23QXV;S8^9
QXB1OgioPH>7Rhj@TI2>RXJ0NgMdLg=fNWn5RXj@THn;QGmhLVeZJFU/LGIlPHF8
RHV8QH:0OWalOGn2Q8J7QhF2OWUeLFm_LGElPhbDW::VYjJRWIJ?RH=oOGamOh63
QHF4PWmkMW9_KVi_LWEiOH22Ph:0OGUfM7=dN7b3RI2FVYfLVYF>QgmhLVi/K6ib
MW]oPXB4Ph5oO7YiNGYlOh63Q8>1OGMaJfEQGUiPIF]bNX67Rhf=RXJ1O7MdLW9d
Mg^0Q8N:RXV7PgmlNGQhNGaoPhJ9RX^9QhB1OgioPXN=UIfTZZj_[ZZTW9>:PWag
M7AeN7]nPH:2PGmmNWQhN7YmPHF9S8f=RhR3OWUfLg=eNGj5S9:GVY^IUY6;QGml
NGYlOhB9SY:DUI>ASHR4P7elO7enP8:2PX1mNGEbKfm`M7Z1RI:JX:BUXinITHV2
NgMdM7EhNgn2Q8F4PWmlNWQhNGaoQ8R;SXn>RhR3OWYhMWMiOH:7Rhf>S8R2NW9Z
HeiKFeiRJ6ieNWn1PX5nO7UgMWIgNWf0PXB4Ph1mNWQfMgUmQ8^DW::WZZZWXIZB
RX=nNWUjO7n3QXR9R8F2OGUfM7=dMgYoPhN9RXZ8QH:0OWioPXJ;Si>FUYB?RH5h
L6USHF5TJG1gOhF:SHf<RHJ3P7elOGj0PH:2PGmkMg9^JfYZKG9gOX>8Rhb:QX1j
LfeXIVIXK79hOX>6QhJ4P7]gLg5`LWAhO824QXJ5Ph1mNWUhNGanPH>4Ph1kM6]R
FE9=Bda@EUiWL7UoPhF5Q85nO7]kO7n2QXV;Rh^8QH5nNgYjO824RHjATi>@S8N1
NgIcLgAhOXB;T9BFUI6<QGihLVi]KFmcMg]nPH:1OgekNGUiNgf1Q8J6QH9mMg1Y
HemNGfAZLgb5S9:EUYB@RXEoNgQgN7YmOh62PGmkMg=_K6]/KW9fNgn2Q8B2P7ej
NGUlP8J>UIfRYZJTWiN?QWigLW1`LgMlP8B7R8N5PWmmNg]lOX22Q8F4PWiiM6m/
Jfa_MGf5SYFKWYnLV9:;QH1mO7f0Q8V=T96ASXZ5P7]hMWEgNGf0PXB4PX1lNGIe
MGMjOX:6RHV7PgacJF1GDDi>DEINIVifO7n1PGmmNgUiNG]nPH>5QHB1OGQdL6i^
Kg=hOH:6RHV6PWafKfYWIVQ/LWV1Qhb>SXb8PgeiMGAdMg]oQ8R:S8^:QhB1Ogmo
PH>5QXJ3OgUaJF1IEE9DF5mWLGZ3RHf=S8R4OgYgMWIhNgj1PhB3PGijMgAcM7Ij
OhB8Rhb;RHF1O7UgN7YoQ8^@UINFThf5O7=/IV=SIFU_MWb0Q8F5Ph5oOWinP8>7
RH^<RhR5P7ejNGYnQ8^CVj:VZ:JRVi:9P7UdLG5cMWYmP81oOGUdL6e[K6ibMW^0
PhF5Q85nNgUhNG]oPhJ8R8J2Ng=ZHU]FE5IJHFYcO8>8RXZ8Q81lN7IfMgYlOh62
PH1mNgUhNGb0QXbBUiZKVIF?R85kMgIgNWn6S9:EUiFBS8IoNWIdM7MkOh>7RHV8
QH5mNWMgMgUlOh63PX5nNWIdLgAhOhNAVjF//;6_ZZ:HShJ0NgUiNWf0PX>3PGik
N7IfMgYnPhR<SXn>RhN3OgelOX:7SI>HVibJUXn8PG]fMGIjP8J=TiRJVIJBS8J1
OG]kO7j0PXB4Ph5nO7]kO825RY2DUYJCSXIlLfYSGeeOI6]bNX25QhJ4PGaiMWEf
N7]oPXB5Q85mN7AaKfmaM7UmPXF6QH>0OG]jNgn5SIJOYjf`/:bVWI>:PWahMgQk
Oh:4QHF3P7ejN7MhNWaoPH:1Og]fL6aYJ6U^MGf6SYFIVYRDSHIoNGEdMGQlP8B7
QhJ3OWQcKfa[KG1dN7aoP81nO7YhMgQkOh>8Rhf<RH=kLVURGE]MHFUbO8J=TiFE
TXj:QH5oOWn0PX>3PX1lN7AaKfmaMW^0QXV;RhR3OWQdLG5dN7n6SY>GV9JARh=l
MW9aLWEjP8F8Rh^9QX9oO7YjO7j1Q8J7QhF3P7inP8F<UIjX/KNj^KF^Y9Z@Qh5m
O7f0Q8N9RXV6PWijN7MhNWf1QHN8QhB0O7MdLW=eNGj2QXR8QH5kM6m[JVa`N82:
TYVMWYbHTHZ3OWYhN7YmP8>4QHB2P7imOX24R8f@TY:@RhEnMg5^KW1fOXN@V9fP
WibGT8V3OgemOh:5R8V8QX5lMg9_KVmaMGYoPXB5Q8:0OWioPXJ<TYNKViVCRh1e
Jf9LFEYNI6adNh23Ph9oO7UgMgQjOX63Q8B2OgaiMgMiOH>9SiFHVIJARX=kM71^
Kg=iOhB8RXZ6PGYdKVUXJ6]`MG]oPX>2P7ejN7MhNWf1Q8J7QXB0OGYiNWn5SYRR
Zk6d/jjVWI:8OgUfMGMjOX64QHB2OgekNgaoQ8R=T96ASXZ5Og]hMgQkOhB7R8R4
OWM_If5NGF1VKGEmPhN9Qh=mMg9^K6a_LgMlOh62PX1nOGamOh>6RH^:Qh9kLVYR
GEYKH6M`NX>;Si6?S8J0NgMeMWQkOh>5QHB1OGQdLW5bMGUnPXB5Q89nNGEcLW=f
NWn2Q8B0NW9XGUI@CDiCFfA^N826RHV8QH:0Ogn1PhJ8RXZ8QH5mNWUiO825RXf?
SX^5OGA[I61NH6E/M7b2QXR7Q7mjMWAdMWYoQHZ=Shj;QX9mNGMgN7]nP8:2P7ik
N7MgNX28TIZRYjZYY9bBQgedKfa]L7IkPHF7R8J3P7ekNWYlOX21PGmkMFmZIVAT
If]aMgb0P7mkMG1ZIfIXKGEmQHbATi:>R85jM75`LGAhOH64QHB2OW]iN7QjO7n2
Ph>1OGUeLG1bMgn9U9nY/;>b[JJLTXV2OGYjO7n1PX:0OGUdLFm_LGEjOhB7R8N4
PGejN7QkOhB9SHn>RhIoN79]K6icNhB=UYbOWY^ESHIoNWQgNG]oPH>3PX5nO7]l
OH64R8Z;RHEoMfmXHf5RIVefOhJ<SXj:Q7efL6e[KG1eNWj0PH1mNGEbL75dN7f3
QhZ;RXR4PGimOGn1Q8J6Q7mgKF9HCdU7BDiGHVefOX>5Q85mNGIeMGIiO7n1PGml
NGIdM7EhOH:6RHZ8Q7igL6]XJ6]`N828SY6BSh^5OgYgMgYoQHbBUYRGU8n9Pgml
NgamOh62PGmlN7EcLgEiOXB8Rh^8PWU_I5YCCe1DFfE_N825QhN5PWmlNganPHB6
QXF2OWUdLFm`LgQmPhN:RhV6PGejNW^0QXfEVijNViB<PWQ`JVQYKG9hOX:4Q89o
NgQeMGIhNgn2PhB3PGmnOh:7SYJNY:VZYj6HSH9gL6]ZK71fOH:5QXB1O7QeLg=f
NWj3QXR7QH5lN7EcM7IjOX:4QHB1OGUeM7IjP8R@Ui^LVYB;P7E[HemNH6I/LgYo
PH:1OgelO7j0PhJ7QhJ2OGQcKfi_LgQnQ8R:RHEnMFaTGeaMHFM_Mgf2Ph9oNgMd
Lg=gO8:8SI2AT8f9Q85nOWn1Q8J8QhJ3OgajNgn5SYVT[KBh]k:YWi>9P7YgN7]o
PhJ8R8J2Og]iN7UkOX63Q89oNgIbKfi`M7^2R8jATHn;QH1kNGYnQHfEW:2RX9ZC
RX9kMWAeN7b1QHN8QhB1OWalOGn2QHN8QhB0O7UgN7b3S9JPZ:f^ZjFKT8EkM75`
LWIkP8>4Q89oOGalOX:7SI:EUYFBSHR3OgemOh:4QXJ4P7YcK6MTIFUaNXB=TiNG
Thf5O7E_K6e`M7YoPhF5Q89oOGemOh:4QXJ4P7]eKf]ZK75iPX^CVI^JUHj6OGIb
LG9fO866RHV7PgehM75`LWIjOX:3Ph5mNGEbLG9dN7aoPH5oO7QeM7EjPXfIY[2h
^k^f[J>HSHEoOGenPH>4Q89oO7UfMWMjOH64QHB1O7MbKVe^LWMnQHZ=S8V2Ng9[
IVAUJFmfOH:4Q81kMFm[JFU/LGMmPXF6QH>0OG]kNgeoPH5oO7M`JVISI6U`NhJ@
VIjOW9J=PgYcKVe_LgQmPHB5Q8:0OWenPHF:SI2@SXZ5OgUeLg=fNWj2Q8B2OWQb
KF]/LGR1RiFLX:2LUXj5OGMcLgEhO823Q8>0OGYiN7YlP8>6QhJ4P7ejNG^1RI>N
Z;2e][:[XYN=Q7mlO7n3QXV9R8AoNWIdLgEiOhB9S8f;R8F1OWemP8B7Rhf<RXF0
NgQgNGn7TIbTZjf[YIfBR7igLg=eNWn3QhV8QhB1P7n0PXB6QhJ3OWQbK6QWJFec
Nh66R8N3O7E]J6EUJFmhP8R=Shn<Qh9nO7]nPXN<T9:BT8b7PWilNgeoPH>4Ph1m
NGMgNWn8TijX/;Bc[ZFJSX9hLFi^LGIjOX20OgaiMWEfN7b0Q8J7QX9nNWIdM7Ml
PXN<SXf:Q7eeKfa[KW=jPHJ:RXJ0MfmWHEiOHVQ_Mgb1PX:1OWalO7j1QHR9RHN4
P7ekNgj4Ri>KX::PVY25NFiUHF1SJ6mgOH:3Ph5mNWUiNWj2QXR9R8AoNWA`Kfmb
MWb0PhF4PX1mO7j2RI:KY:Z][:NOU8QnMG1_LGIlPXJ9RHN4Og]hMgQiO7n0PH1m
NgQgN7b2RI6HWIjMUhn5O7=^K6icNX68SHn>RXF0NgQgNWj3RHf@T8f9Q7mkNGUj
OH23Q8B1OWUfLg=eNGj3QhR6P7M[GeA;ATI:DUeXLg^1Q8B2OgekNganPH:3PWmj
MG5]K6iaMW^0Ph>1OGMaK6UYKG=kQ8bAU9:>Qh1iLg5bMG^2R8b?SX^6P7YgMGEg
Ngn2Q8B3PGmnOGn2QXZ=SX^5O75TFE1:BTeDGVUcNh22P7ahLg1_L7=gO822PX5n
NgUhNGf2QhfATi:?RXAoNWQiO824QhR7PW]bJF9NGF1WLGb7SiFGUI6;QH1lNgan
PH>5QH>1OW]jNWb0Q8R:RXN2O7E_Jf]_MX2<Uj2VZ:JPV8n6Og]jNgf0PX:0O7Ma
K6UXJVidNWn3QHF3P7ekNW]nPXF8R8F0NG9[IVAWKGJ2SINNXInJTXV0N7=aLWEh
O7n0OgejN7IfMgYmP860OGQbJfISHVE[Lgb3RH^:QX1iLVi]KgAkPh^@TY:>R89k
MgEeN7b1QHN7QH9mNGIeMWUlP8>4Q8:0OWenPh^EXJfg_Kjk]:RKSX=jMGAfNWj2
QHF4PGikNGYlOh>7RHV6PWehLg1`LWIkP8>4PWegL6YWIVU^MWn7SHn>RX=kM6i/
KG5hP8N>TI:ASHV4PGmoP862PX5nNWIcLG9eNh:9Si:BSHEkL6INFUYOIW1iPHN9
RHJ2OGYhNG]nPXB5Q81kMW5^KFibMgf1Q8F4P7eiMgMiOH:6RHV6OgEYGE9;B4U?
F6=^Mgj1PX1mNWQgNGb0Q8N8QhF2OgelOH24QhZ:Qh9jLFMPFe]NIFiiPXV=SX^6
P7]gMWQlPXR<Shn<Qh5kMWAdMWYnPXF6QH9oO7YjNgj2QHN6PgeeKFEQH6=[MX:>
VJ2SXI^CRX9kMgIgNWf0PX:1OgelOGn3R8fATi:?RH9kMW9bM7QmPHB3P7YaJ61K
F5YOIfmhOX:2OgUcKFUXJVecNGn2Q8>1OW]hN7QkOX22PX1mNWMfMgf5T9bX/KJf
/ZVNTHElMG=cMg]oPX>2Og]gMGAfNGj3QhV9QhB0O7YjOH67S96CTi2;QX1mO7n4
RY6FVIRCRh1dJF1LFemUKGElPH>3PGikNWYkOX63Q8B1OWYhMgQlPHN=TY>ARh9h
KVIRHFE/MX29Si:BSXV3OWYiNWf0PhF4PGafL6]YJFa`MWb0Ph>2P7inOX66RhnB
THf6Ng1TFUACEUeWLgj6Rhf;QX5kMgEfN7b0PhF4Ph5oOWj1QHZ>TI:@S8EnMg9a
LWMoQi2FVIRDSXIoNWUjOXF<TYJGUI29PW]gMGEhO823QHB2OgajNW]nPXJ:Rh^8
Q81mOH27TYj[][k2`;Z_XiF9P7YhNG]oPH:1OgahMWIhNh24R8V9QX5kMW9aLWEj
Oh>4Q81kM6m[JfidOHN@UiZIU8f4O7IbLWEkPXR=Shn<R8B0OGamOh:4QHB2P7im
Oh>:TibTZJ^XXIR<PGQbL7=iPHV@U9FCShV3OgalOX65R8R7Q7mjMW=cMWZ0QHV;
RhV5PGekO7n3QhZ;RH=kL6EKEE=FGVQePH^BUYFAS8N2OgioP8:3Ph5nNWIdLgAg
O823Q89nNG9]JVY^MX2;UIfQXIfFSXEoNWUkOh>6R8N3OGM`JfQXJg1fNgn2PX1m
NWUhNWf0PhF5PWehLfm_LgZ5TIjX[k:_Z9jBR7miN7UmPXJ:RhZ7Ph1nOGj0PXB4
PWiiLVaXIfU]M7^2QhV8Q7mjMgIhOHF>UifPWiZBRGmgLW1bMWb1QHJ5PWiiMG=c
MGQkOh61OgekNWYmPHN=TI:@RWmbIEQ?BTY>Ef5/MWf1PX1lNGIfMg]oPXB4PWii
Lfm]KW1eNWn2Ph9oO7QfMgZ0QXfCUYFARX9jM79cNH:<UinUYZBNUHf5OgakOGn2
Q8B3PGilO7j1QHV<SH^7PGYcKfi`MWn9TiZMW9R?QWaeL6maMWb1QXN6PgmjMgIg
NWn5RHb<RHF0NgMeMWQlP8>5QH>0Ogn1R96LZKBl`;jh[J2BQG]fM7IjOh>6QXB1
OGYhN7UlP8>5QH>0O7YiNh26SYBIViVDSHAmMgEfNh::TIJGUI29PWahN7^0QhjC
UYJBSHJ0NgUhNWaoP81nNgQeM7EgO865QhJ2Ng9XH5]KGfQdPXnIX::OVY::PWek
NganP81nO7QeLg=eNX27SI2ASh^6PGelOH25RHb=RXEmMFeXIVU`NHB=UIVHU8f5
OGMcLgIkP8B7QhJ3OgajNWanPH>4Ph1mNWQiOXF@VjJ^/[:]XiN;P7McLWEjOh>5
Q85lMW5^KFmcN7f0PH1mN7AaL75dNGn3QXJ4P7aiMgMjOhF9S8^6OG5TF4m;Be1I
I71jPXJ7QH5mNWUiNgj1Ph>1OgajNG]oQH^AUIJDShV2OGYkP8NAVZ6VYZ6JT8In
N7IfNWj2Q8B2OGMaK6Y[KgElPXN9RHR5PX1oP8>5QhN4OgUbK6UZKWN3T9fV[:bW
WiB8OWMdM7MlP8B6QH>0O7YjNgj1Q8J6Q81kMW=bMGZ1R8nCU9:=Qh1kNGYnQHbB
UYJBRh5gKFMTIV]bNX:7RXZ8QH5oOh64Qh^=SH^7Q81nOX23QXV9QGidIe]@B4I8
D5]XMGn6RHV5P7]gMWMiO7n1P7eiM6m/K6icN7j3QXN5PGaiMgMiOH64Q89lM6]R
FeQIGfQcOXN<SX^5OGE^JVU/LGMlPH>4PX1nOGeoPHB5Q85lMFmZIfQ]MGj7Si>C
ShQoMViZJVedO8B;SXj<Qh9mNg]nPXN<Shn=RHAnNWQiO7n3QhR7QH5mNWYkOhB8
RhZ5O71QDdLo?Cm7Dem/MWf1PH1mNg]lOh>6RHV8Q81lNWUjOX:7RX^9Q7igLVm`
M7^5SYJJViVCRh=nNgb0QXfDUiREShMoNGEcMGUnPhJ8QhF1OWalOH22Q8>1O7I`
K6Y/LWb8U9jUYZ>KTHEjLFe/L7ElPXJ7QXB0O7YjNgj0PX9oNWA]J6ASIV]aN7f0
PGmlNGMhO8>;U9^PX9^CR7abJVIWK7=kPhR:RHJ1O7UgMgUmP8:3PGmlNGMhNWf1
Q8B2O7AZH5UFEeeXMH:>Ui^KUi6:Q81oP8>7RXZ8Q7igLVi]KW9hOH63Ph5nNgUi
Ngn5RXf?SHZ5OgakOXB>VJB//:jXWY64N71/JfmdNWn2Ph:0OWemOh65QhR8QH1k
MgEfNX28SiFHUi><Q7egMWQnQi2HWIjLUXj6Og]iNgn3R8Z9QX5kMG5_L7=gO863
Ph:0OG]kO7n2Q8=oN6ePE4U2@DE>FVQfPHV;RXJ0NWMeMgYnPXF6QH=oOG]lOh>8
S8j=RXEnNGEdMGZ0Qhb>SHV2NW=^KFmeO8B;SXj:PWQ^IV9QHfU`Mgf0PH1nO7Yj
O7j1Q8B3P7]gLg5bMG^1QhZ8PgU]H5A;AdQ>F6=_NGn2PX1mNWUjOH64QhN6PGaf
LW1`LgUoQ8R:RHJ2OgemOh>8S8f;QGebJ61KFf1ZMX:>UYZIUHn8PWmnOh>7Rhf<
RXN3P7emOWn1P7ijLfaVHF1TJgF0Ri>GUi:;Pg]eLgEiP8N=T92=Qh5kMgIhO866
RX^9QX5lNGMhNWn3QXN7Q85mO7aoQ8^@U9>?QWU[GU==C51IIG9mQXZ;RHF1OWem
Oh62PX1mNGAaL79fNh:7Rh^9QGmkN7UlPh^CVYfKUXj4NW9^KG1fO8:5QH5kM6aW
I6EYKgIlP8>3PGmmO7f0PhJ8R8J2OW]iNh6:UZ>^]KRe[J:DR7egMGMkPXN;S8Z7
PWikNWaoPXF7QX=oNWMeMWYoQXbATY6=R89mNgaoPhR:RHElLFEIDDa=DeeXLgf3
QXF1O7QfMGMjOX63PX1mNWMfMgYnPH:1OGM`JFETIfiiQY:LXZ:NUXb2NG=aLgMk
Oh:1Og]gLg9dN7n6S92AT8b6PGejNWanP81oNgI`K6Y[L7R2Ri:FU8j4N6aRG5]O
Ig5kPhV;RXN3OgelOX22Ph>1OW]hN7UnQ8^BUiRFTHZ2O7UiOHB<UI^MW9N?QWmi
N7YoQXfCUYFARhEoO7]lP8B8RXZ8PgmjN7MhNgj1PH1mNGIeMgj9UjJd_lG6`;JX
VXb2O7YkOX63Ph5mNGEcM7IjOX:4Q85mNGEcM7QmQ8V=SXb7P7YfMGMmQHfDUiNC
Rh9iLVm`MGf6SYBGUY:;Q7ijNGYlOh:3PX5nOGanPHJ:SXn=R81gKVQVJ6miQI2H
W9^ES89hL6a/KgAiOX62P7ilNgf0QXfCUiRGThf7PWmnP8>7RX^:Qh9nO7f2RYBN
Yjf]ZInCQGQ^J6M[LGQoQ8J5PWmkNWYkOh:4QHB2OWYhN7YmPXJ7QX1hKF9HDU5E
G6MbO8>6QH5lMg=cMG^1R8b>SHR2NgEaL79eNWj1PH1lNGIeMWUnPXJ7QX9nNGMh
OHJAWj^c]kJ_XiF7Ng=_L7=hOX:3Ph1mNWUiNgf0PH1mN79/J6MXKGAlPXN8QX9m
NGMiOXNAVZ6UY9nFSH=lN7QlPHN<Shj:Q7egLg9cMgb1Q8J6Q860Oh23QXR8QX1h
KVENFeeTL7j<VJ6TXY^BRH1jN7UlP8>5Q85mN7EcM7MlPHB5Q81kMW9`LGEjP8B6
QX9mMg5_Kg=jPHN;RXElL6AIDTmBFF=^N825QXF3P7moPH>6R8V7Q81lNGUjOX>7
RHN3Ng9ZHf1RJG>0SINMWibFSHEnNgYmPHF7QhF1O7McLgEjP8N<SXj;Qh9mNgYl
OX62PWmjMG9aLgZ5TZ2/];JcZj2CR7mkNgj4RXnBTXn:QH5nOGn1Ph>3P7eiMgMj
OhN?UYZKUi69P7YfMW^1RHnCThn8OgI_K6a`Mgj5RHV7PW]eLFm`LgQmP8:1Ogai
N7UlPHF9RhZ7PgmmOXB=VZVf`<K5_[:TUHQnNGQjOH64QHB2OginP8B9SY6BTHb6
P7]hN7]oPhJ7QH1jLfi/KG9jPXZ@THj7OWE]JFU^MWn8Si>CT8Z3OWYiNWf0PhF4
Ph1nO7eoPXF7QX=lLfUPFeYNIg>0S9FIV9::PWYfMGMmPhV=SXf9QH5nOX24R8^<
RXIoNG=_KW1eNWn3QHB2OgioPhZCW:>WYYnDQWIYGeYKH6UcO8:6QXB0OGalOX65
R8V8QX9oOWj1QX^@TY6=QgmhLg9eOHNCWJBVY9fDRX9kNGUlP8>4PWefKfQTI6I/
LgYoPhB2P7ekNgf0Q8J7QH5lMg=cMWb5SiNLW9J<OW1RFEAEFV=]MWb0PGmlNGMh
NWf0PX:0OGQeLgAhOXF<TI:@RhAmMgAeN7j4R8Z7PGQ^IEmNH6MaO8F;SXf8PWei
MgUlPHJ9RXR5PGejNW]mP8>3PWmlNWYnQY6O[KW0`[jeZ9V<PG]iNh25RH^:Qh9n
NWUjOH65QhN4OgUdL6i`M7UnPH:0O7McLG5dNX68S8b9PGQ_If=TJWAoRiBIVYJ?
QWigM7=eNGaoP81oOWeoPXJ;Si6ASHN0NWIeNGn8T9NJV9:8O71WHF5UK7AlPXB4
PGejN7UlPXN<SXj:QGihM79cMWYnPH60OGUgMgQlPHF7QGmeIeQ;@Si0B5ARL7b3
QhJ3Og]iNWf1QHR8QhB0O7UiNWaoPH1mN71YHf5RIfmiPXV<RhIoMg5]KW9iPHR<
S8R1N71ZIVM[LGQnPX>2Og]hMWMjOX64QH>1OG]jO867SI6CT8QmL6AJEEILJ7F3
SiNJV9B=Qh9oOh23Q8B2Og]gMWIjP8N=TYBCShV3OW]kOH23Q89mMF]RFeQIGfUd
OXJ9R8=kLfaXJ6]bNX66RHV6PgmmO7j0PhF6Q89oO7anPhZBV9^IThQkKF5IEUUP
JWEnQ8J4P7]fM7AgO8:7RHV5PG]gM7EgNh24QHB1O7McLG9fNh65QhJ3Og]jOHB?
WJ^g_l6m]:NHRX1iMgQkOh>4Ph1mNWUiNgn2Q8B2OWUeLW9eNh67Rhb8PGQ^If=S
J75kQHf@T8^4O7EaL79fNgn0OgYdKFMTI6M/LgUnP85oOG]kO7n2Q8B2O7A/IF5R
J7:0SY^TYjFNThQnMgAeNGn5RXb;R8B1Ogj0PXB5Q81kMFm/JfidNh:7RHR4OWQc
LW=iP8R>T8n9PGM^J6IYLGZ4SI>EThj8PWilO7j1Q8F3P7ahMGAfNGaoPH1mN7Aa
LGJ0SIb[]kfn^:fPTHElMgIhO7n0OgahMG9bMGZ0QXZ;RXJ1O7UgNGf2QhZ;RXJ1
OWanPXVAUi^JUHb0MF]VIFYcOXVAUYJCS8EoNWUjOH23QHB3P7imOX23QXN5P7Q^
IEeIFUiWL7V0PX1jLFQPGEeRJW=lPhJ6PgmkN7QkOhF9S8^8PgagLg9cMgb0Ph>2
OgekNgj3R8f>S8AiJUa?ATA8DEi]NXF;S8Z6PGekNgf0PX>2Og]gMGAfNWn4QhN5
PGagM7EjPHZBV9^ITXUoMVm]KgAjP8B4PGYbJVARI6YaNX:7RHR4P7ejNW]nP860
OGUdLG1aMGYoPX5lLfQKCdM4B55NK7Z4RXb9PgehMGEhO823QHB2OginP8B:T9FF
UI29PW]gMGMjOX:3PWihLg1`MGj:Uj:Z[J^SVHf3NgQiOH:7RX^8Q7iiMWEfN7ao
P7mnNgYjO826Rhn@S8AiK65HEEMNJGJ2Ri2@S8J0NWQhNh24QhN5P7YdLG1cN7j4
R8Z9QX9oOGf0Q8R<SH^7PG]fMGQnQXnFVIN@Q7EVFU9@DeYTKgQnPH60OWemOh:5
QhN4PGahMWMjP8J<T92=QWmhLg9fOHN@V9bLUXj4NW=`LGEjP8B5PgihLFe/KG9h
OX>5Q85mN7EdMGQlOh20OgelOH::UZ>`^[jm]JRHR7YaK6ebN7n4QXF1O7QfMWQl
P8B6QH>0OWanPHN=TYFETH^3NgEcM7QnPhN7PgadJfESIVegPH^ATXn8OgI_Jf]^
LgUnPH60OG]jNgf0Q8J6Q81kMWAeNGn7SI6@RX1bI5M>BdiGHVmjPXJ7Q85mNg]m
P8>4PgmiLVaXIfU^MGb1Q8B2OgelOH66Rhn@SHMoMVm/KWAoS9RRYjNRVHj4O7Qh
Nh26RH^:Qh>0OWeoPH>5Q89nNgQhO8::TiZNWIN=PGE[IFAXKgMnPh>0NW=]JFU/
LWZ1QXR7Q7mkNGUlP8J;SHf;QX9mNg]nPHF7QhB0O7UiOXNEY;C0alO1]ZNHRX5l
Ngj2QXV9QhB0OWeoPHF7R8J2OGMcLW=hOXF:SHb9PgeiN7^3S9NPYZRTWIB;Ph20
Q8V?Ti>@RH5hL6aZKG9gO821PGmmO7anPHB6QH9lMW1/KG9kQi>NY:BOUHQjKfQV
JFmgP8J9RHJ3P7ioPXJ9S8b:QX5lNWYmPXV?TY>ARhEoNgUkOh>6QX=lLfUQG5aR
KGZ8UIfPWYR@R85mO7j1PhF4PGeiMWEfNGf1Q8F3PGimOhB=V::[[jjWW8eoLf]X
Jg5iPHJ9R8AoNgUjOH:7S8f<R85kMG9bM7UnPXB4PGikNGUkP8B7QhAnMF]SGf1V
LGj;UYbMVI25NW9]KG1fO864Q8>0OWemOX22PWmjLfaVHfAXKgMnPhF3OGI_Jf]_
Mh6;U9RHTh^2NWAcMGZ0QHR8QGmiLg1_LWIlPHB5Q85nNg]lP8>6QhJ2OGUgNH2;
Vj^jaL[9`;>TUHR0O7]mP8:2P7]gLg5bMGUnPH:1OGQdLG5cN7j2QHB0NW9[IfIY
L7QoQ8F2O7A/IfIZLgj:U9ZLVI>;PWaiNG]oPXB5Ph1mNg]lOh:4Q89mMg5]KG5i
Q8nHWIfHSX5dJVASIfmhPHR;RXN2OW]kO7n2Ph=oNG=]JFU[LGQoQHR8QX>0OWn1
QHR9Qh5gJemED51GHVmmR8n@SHImMG1^Kg=iOX62P7ejN7QiO822Ph9oNgMfMgb4
SIJMWibERWidKF]]M7f6SI6ASHR2Ogj1QhjEVIZHTX^4OWYiNgj1PX9oNgIcLWAg
O865QH=oNWMfNhBAX:nj`<2i[9f>PGQcM7MlP8>4PX1nOGj1QHV;S8V5P7]gMgZ0
QhjBU9:=QX1mOH27T9RMWYZBR7acKFa_MWf4RHV6PGYdLG5dNGn5RH^:Qh>0Ogn0
PX>2OgYdL6i`Mh>AWj^c];2VVH^0N7EgOH>9SHj;QX1kN7QjOH22PWmkMW9aLWIl
PhV=SX^7PWilOX:8SY:BT8V1NWAcMh2<VZJ^/JjVW926Og]lOX:5QhJ4PWmnOh:5
RH^:Qh9mN7EeNGj5RHZ7Og=UF4i9BU1KJ7AmPXB2OWYiNGf2QhZ<RHAnMg5^Kg9g
OH:5QH=oO7YjO824QXJ2O7E_Jf]aNhVHYJja[JFIS81hMGIjP8F8RHJ2OWYhN7Ym
P860OW]hN7Z0R96IWj6NV8n5OWYjOXB:Si2=QWabJFASIfigOhB6Q81jM75`LgMm
PXF5PgmkN7MhNgn2Q8B3P7emOhJ@W:N_/ZnUUXEdIeiKGVI_N824Q8>0OWenP8B6
QhJ1O7E`KFeaMWb1Ph>0NgMdM7MnQHb@THf6O79[IfQ]MGj5RHR3NW1VH5iPIVef
O862PH1nOGj1Q8N8R8F1OG]kOhJ>UIZKUhj1M6QOGF1WLWj7SHj;QGiiMGIhOH:6
QhJ2OW]iNWj3RHjAT8b7P7]hN7YnPXF6QH9nOGj4SY^Y][o1_K>TU8EiLW1bMWao
PH1lN7EcLgIjOX62PGmlNW]mPXR=TI2<QG]bJfQ[LWb8TYZLVY>:PWaiNWf3R8^;
Qh5jM71_LWQoQX^=RhR4OgelOGn1PGmjMFm[JVabNX>8RXMnLVAGCT]>EV=aOXR=
SH^6PGelOGn1Ph>1OW]iNGb2RI2EUiF@RH9mNW]oQ8V<RhMoMVeWIFM^N8:;Shn:
PGQ`JVU[LGMnPX>1OGQeLgAfNgn1PX5nNgUiNgj1Ph9lLVAEAc`g>D5>GVijPXF4
P7]gMGMjOhB6QX=nNGEbLgIkOh>3PGehLg1`M7V0QXV:R8=nNg]nQ8fFW9jKThMi
KFAQHfYdOhV?THn:Q7mlNganP860OW]hMgQkPHJ:S8V4O7A]JF]`NH><TY:>QGU]
HeiMHFQaNGj1PGmlO7f2R8nFVIZFT8V2OGYkOH64QHB2OgakOH67SI2@RX1cI5M>
BdmHIWB2Ri2?RhEnNGQiO823Q8>1OGYhN7YnPXB4PGegLVm`MGf7T9NIUi27OWIb
LWImPhR:Qh1hKVMTIFYbNhB9S8Z6PWekNgf1Q8J6Q81kN7IgNWf0PX1lMFiYJFeg
QYNX]Kfo^JnQU8V2Oh23QXV9Qh=oO7]lOX:5QXAoN75ZIfIYKgEkOh1nNgQgN7j6
T9RNWi^CQg]aJf]_MX28SHj;Q7aeL6i_M7UoPXB3PGilNganP81mNG9[IF9TJW=o
RY:FThb0LfQQGV5XLGV0Ph9nNGAbLWEjOh>4PgmjMG5`LWIlPHB5PWiiMG=cMgb0
Ph>0NgE`Kg=lRIVY]Kfm]jbMSh=kN7QjOX61P7ikNWYlP8F9S8b9QH5nOH24RY2B
THb3N6iVHfE/MX6;TI>@RH9kMWEhOH>7RHN2Ng=]JV]^M7^0Q8B3OgajNWb0PhF5
PWijMgQmQiBR[[Jh]:ZMSX5hM7IlQ8bAU9:=Qh5mNg]mOh20OWYgMGEiOhJ=TYBB
S8AlMG9bMGYnP7mjLVUPFe]PJGF0RXn?RhAkM71_LWQoQ8R8QX9nNg]lOh:4QH>0
NgMfMWUnPXB2O75RE4Lo?T=?GVmmR8j?RhJ1OWeoPXF6QH5lMG1^KW9hOXB7QhF1
O7UiNgn4R8V8PgaeKfa^Lg^4RXf:PWIYGEAADe]VLGb2QHF1OGYiNWb0PhF5Ph5o
Oh65RXnBTXf6O7=[J6U`NHB=TY:=QGYaJfU[LGZ2QhZ8Q7miMWIhOH64QH=mMg1[
JFY^M7YnP81oOGanPHJ;SXj9OW1QDdQ4Ae1NKgj9T9:?RH=oOGj1QHV:RHN3Ogem
Oh:6R8R5P7UcKfmbN827Rh^6OWE/IF=VKGJ0Qh^:QWmiMGEiP8ZCVYjMV928PWel
O7j1PH5nNgQgN7^0QHV:R8AmN7AeO8JDXZjd]:jRThAgKf]]LWQnPH:0OW]jO7n3
QXV8QGmhLVi^LGImPXJ6PgiiM79cMgb1PX1iKf=GCT]=EV9_NhB7QX9kMG5aLgQn
PhJ6Q81lNWUjOH23Q8>0OWeoQHjJYJnc/Z^OT85eKVa`MWj5R8R4OGIaKg1dNGj1
PWmjMG1^Kg9hOX>6QH=nNWQhNgn4R8Z8Q7iiMWMmQi>OZ:^XWi61LfMQHFI^Mgj3
QHB2OginP8:4QH=oNWIbLWEkPXZ?THn:Q7mlOH><Uj6XZjRPUHUoN7IhO8:6QhAo
N79^KG1fOHF:S8b8PgmlNgeoPXB4PWmlNgb0QhnFVIN?PW9QDTU6BE=PKGV0Ph=o
NgQhNWn4RH^;RHF1OWioPXF7Qh=lM6aVHfEZLWUoPX5mMg9_L7AlQXjCThj4N6]R
G5aQJG9jOh60OGUgMWQlP8B6QH>0OG]lOh>6R8N3Ng=[IVM]N8NFXj^]Z9nBQW]e
LgEjOh>5Q89oOGj1QhfBUIFARh=lMgEfNWj2Ph>1OG]kOXB<UI^NW9F:OW=/JVef
PHfFVYVDRh9jM7=eNGj2Q8B3PGn0PXF8Rh^9QGmiMWMlQ8jHX:>PVHn3NGAcMgj7
SY:CShR0NWIfNGn5RXb;QX1jMWEfNWj3QHB1O7McLW=gO822PX1mNgb1S9^/_/cD
e<k1/9n@QH1oPHF8RXR5PGilO7n3QXR8QH5lN7IhO8:8Rhb8PWYcKVeaN869Si2<
QG]aJVMYKWInQ8J3OWI_JVQ[LGV1QhZ:R8B1OWioPH:2PGeiMGAfO8F?UibLUXan
LFMRHfYePXjFVYRCS8AoOGf0PhJ7QX>0OWj1QXfCUiVFTHV2O7UjO864QHB0NWA`
L7EmR9:JWIZBQGM[HUmQJ75kPXN8QX>0OWn2QXZ<S8Z7PWmnOh64QXJ2O7A/IVEZ
M8>CXJ^`[ZNLT8IoO7aoPhB3OgUbKFY[KgImPhJ6PgiiMWEgNgn3QHB1OGUfMWUn
Q8R8Q7aaIE]FEei[NXVEWIjJTXQoNGIgNWj1Ph9oO7YiNWaoP81lMViWHV1SJW=l
PhJ6PW]eLW9gP8^FWj:QVY67OWUgNGj2QXJ3OGI_JfY]LgUoQ8F4PWmlO7j1Q8F5
PWehMGIkQYBT/kg1_[BVUHIkM7AgOH>8RHR4P7elOH24QhR6PWegLg9dN7f1Ph9n
N79/JVebNhB;Shj:PgagMWZ2S9JNX9jFRgicK6U[L7MmPH>3P7imOGn2QHN6Pgmj
MGAeNGj2Q89kL69FC4Q:Df1_OHN=S8R1NGAbLgIkOh61OWYgMWQlPhZ?TY6=QWmi
MWIhO822PX1mNWYmQ8jIY:^/Yib=OFiTH69YLWZ1Ph9nN7=`L7=gO822PX5oOGeo
PXF7QX9kLVURGf5XLgj7SHf8P7I]IfIYL7V1QHJ4OWQdLWAiPHR>TI2=R89nOGn2
QXZ;RXN3OginPXN<Shn;QGegM7MoSIj__<G6_kBUUXV0Ng]mOh61OgajNGYmPXN:
RhV4OWQeMGQmQ8V<S8R2NgMfNH6;UIfQX9ZAQgmjNWn6SYBFUHn7OWMcLgIkP8F6
QX=oNgUjO7j1PX5nNgUjOXNCX:^c]JnTUHAfK6QZL7R0QHN5OgUdLG5dN7f1PX5n
NgUjOH:8SY:BSXR1NWEdMW^0Q8F4P7]gMWV1SIZV[[2/XYB6NW9_LGMoQXZ;RHF1
OWamOh:3Ph5mNGEdMWYoQ8N6PW]cKFY/M86?WJR][:FJSX=lN7UmPXF6QH5mNWUl
PHVAV9^KUi29PgmnOh62PGmjMG1^KW9hOh>4P7M[GeA?D5MTLh:?UYNCS8=lN7Mi
OH63Q8>0OG]kOH23Q8B0NWA^JfaaNX><TY>@RH5iM7AhOhN>TI2:PGI]IfIYL7R0
QHN5P7]hMWQlPHJ9RXR4Og]iNG]nP860O7UfMgf7UJFd_lC0]ZNEQ7M_KG1fO863
Ph1lNGUkOX>7RHR5P7]hN7^1QhjATY2;QH5oP8F;T9BCSHAiKVIRI6YcNh62OgM/
HU]GFEmXLGYoPH1nNgUiNgeoP7mlN7EdMW^2RY6DThf3N6mZJg5lRIJPYJ>LTXMn
N7IgNgn1PGijMG9bMGZ0QXV9QX5jMG9bMG^0Q8J5PgmmOH67SYBFU8]nKEa>ATE;
EVAbOHB6QH5mNg]nPXJ9RHN3Og]iNWaoPX>1OGQcLG=jQ92LYJVWX9J:P7YiO8>:
T9>AS8EmN7MiOhJ=TI:?RH9lN7MiOH65QXF3OgemOh:7Rhf;QWmiM7AjQ9:Q[[Ff
/:BEQWYbLGAjPHR;S8V6PWmoOh61P7egL6YVIVU`N826RHR4Og]jO869T9BETHQl
LFMRHfUbO8B9RHEnMg5_LGImQ8Z=SHZ5PGinOh:4QXF2OW]jNgn4RXj=QW][FT]1
?D5;FFUgP8F5PWejNG]oQ8V;RXN1O7QfN7b1QHN6PgiiMGEgOH>:SHj;QX1kNG^0
Qhf@SXMkKEmCCTmFHW1mQhb=RXF1OWeoPHB5Q89nNWMgNGb0PH5lMViWHf=XLG^5
Rh^7OG5UG5QJH6YeOXB6Q81lNGUlPHJ9RHJ0N75[JF]`MWb0PX9oO7YjO7j0PGef
K65GDE1FHW61SYJHThYnM6aYJg1gOX>5Ph5mNg]lP8>5QXB1OG]kOhJ>UIZLVI:9
P7YiNh:;TiRJUXn6OWQgNh::TYJFTHQoMW1^L7AjOh>3PWmlNgb0Q8V<S8Z6PGil
OH65QhJ0MFIEACTe>49BI7F2RXb;Qh9oOh64QhV8QH1lNGUlPHN=T92=Qh5lNGYn
PhR;RhN1NWEcMWf7TIVMVi>8O75YJ6]bNh>8RHEoN79^KW1eNWj0P7mmOGj0Q8J7
QH1hKfQTIFahQI:LXInHSH9iMGEjPX^AUIB?R89mNg]nPH>3P7]dKfa/L7ImPhJ7
QH5mNWYmPHJ9RHEoN79`M7f:VjZf_;ZbYIF7O7IdMg]oPX:0OGYiNGb0PhB4P7]f
LW1bMW^0PGmjLFQQGV5YMH>?V9bJU8^2NgUjOH:5QX9lLfYTHVAYLGQnPX9oO7Ug
N7]oPXB3P7eiN7YoQXfBThj4MVIHD4eBGFakQhjASXR1NgQhNgn3QHF3P7ekO7j2
QHJ4OgM_J6=SIfmgOhF7QX9oOX67TIbV[:fXWY65NgIfNh::T9:AS8J0O7]mPHF9
RXV6PGikNgeoPH1nNG=^KG1hQIBR[K:_YYR8NFiYJW1gOhF7QX>0OWj1QX^>Shf8
PGYeLgAhOH:5QH=oNgUjOHB:T9:@Rh=jMG=fOXRCVifJTH=eJ61MGfI_Mgj2PX1n
O7anP8>4Ph1kMgAdN7f4RXf<QgmfKVY[LWf9UIfOW9B:PGYgNGj5S92@SHR3Ogj0
QHZ?TI2<QGihM7AfNWj1PX1lNGMhNWn2PgmfJ5M5=Rh/<d1AHW5kP7mlN7EdMgb1
QXR8QH5mNWYkOX21Og]dKVYXJg9jPhV;R89iL6YXJg9kPhV:Qh1gKf][KgN1RHj?
RhAlMG5`LgMlPH>3PGmnOX65RHb=RXEnNGMhOXN@V9^HSh1_Ge9<C5=OK7N0Q8B2
OWakOGn2Ph5nN79^KG1eOHB:SHb8PgikNWf1QHN6PGU`J6AUK7J3SYJHU8^0MFeY
JW1hPHN:RHJ2OWalOh:6R8R6PWmmOGn1Ph9nMVYNDda<DUe/O8VATXn7OgMdM7Qn
Q8V9Qh5kMG=cMgf3QhV7PgmkNW^0QXb@THn;QX5nOX64QXJ2NFiSFUIIHW63U:6X
Z:>ISHAmNW]oPhJ6QH:0OWn1Q8R:RHF0NGAbM7V0R8j@SHR0N7AdNXB@VjBWYIjD
RH1kNWb0PhB1NgA/IVAVJgAlPhN8QX9oOGeoPX>3PGagLg9eO8F?UiZFS7e/G55;
CEEPKGQoPGmkMW9bLgQlP8:1OgajNGb0QX^=S8R1NWEbM7V1RHnAT8^4OWYjOXJ=
TiFAR7]]HEUGFV9]Mgn3Ph5mNWUkOh>7RHV6PWmmOGn3QhV9QH5lNG^2SYj^^l?4
_K2PSh9iMWQlPHF6Q7mkMgIgNgn3Q89mMg1[JF]`Mgj3QHB1OWalOhB9S8b8OgEZ
Hf1SK7R6TINGTHMlLV]ZKWEmQHZ;RXJ2OginP8:3PWmlNGUkPXZCVYjMUhj4NgMg
O8F?Ui^IThQmLfa[KWAkP8:1OGMbL71dNh67RXV6PG]hMgYnPXJ7QH9mNGQhNgn1
P7U^Gdm2>CLnC5iaPhnEUI6:PgilOGj0P7ijMG5^KW5fNgn1P7ehMGEgOHF=TiFB
Rh9hLVmbNH:;TI>@RH5iM7AhP8VAUIF@R7mgLG1bMWYnP7mmNWQgNGf0Ph>0O7Qe
MG^4T9fW[:^SUXMiKfa^MX6;TiNFTH^4OgenPH>5Q89nNgYlPHR@Ui^KUi29PWil
OX64QH=nMg5^L7J1SibVZZNNTXAiLFmcNH68S8^8PgejN7YmPH>4Ph1mNg]nPXJ9
RHJ0NG9_LGV6UJB_]K>/Wi65O7QiO864Q85lMg9`LWQoQXb>S8R2O7QgNGb0Ph>1
OGUeMGQmQ8Z>SX^5Og]lPhnO[kg5a/2cY9B7OW]lOh>5QX>0O7YiNgj0PH1lMg=`
L7AkQ8bATHj7OgQdMGZ3S9>FThb1MVeWIfadOHB8R8AnNGIgNX68SI2?RhAnNGMg
NWj1PX:1Ogn2QhnFVi^FRgYXF4a7BE=QKgb5R8J1NWEcMGUnPhJ6Q81mO7f0QHV<
S8R3O7MeMgb3RY2BT8^4OW]lPHVBVIfKU8^1NGIiP8^GXJJUX9N=Q7ikNgeoP81n
NgQhNWj3R8^;RHB0OGf1RI:JWYbDQgIVFE5AEf9_NhB8QhB0O7]lOh:4PgmiLVaX
J6abNGn2PGijMG9bMGUmP85nNGEbM7Z5Tj6//[2XVX]mLVe_M7b4RHZ8PgeiMgMj
Oh:4Q8>0OWenPHF6QX5hKV=KEeUQK7R3RH^7OgMaKW1fOhR>THj8P7UcLWAiOh>5
Q7miM71_LGIkOh61OW]gMWQkP8B5Q7mhLFi_MhBEYkJn_kV/W8]nMG9dN7f0PX1n
NgYjOH24QH=oNG=^K6idNh:7RXR5P7inPhbGXJV/ZJ6FRh9mOH:9Si>BSHAjLVa[
KgInQHZ;RHF0OGalOX22PGijMgEgNh67Rh^5NfeOE4i?F6EfQI6GUi::PgelOX:7
Rhb;QX5lNWUlOh:2P7]dKVUWJW1gOhB6QH5mNGQjOX>7QX5gJE]?B4M>Ff]jQXj?
S8J0NgYkOh>6QXF1OGYiNWf0PhF3P7ajNWf4SYNNX9bCQGM[I6AZM82<TiJDSXN1
OGeoPXF5PWaeKFQVJ6ifOH>6QX>0OGenPXF7QhAnN7AbMWf8Ti^OW9>6Mf]SHVMb
OhbEVIRCS8F0OWioPH:0OW]hN7YnQ8V<RhN0N75^KgAlQHf@ShV1NGAcMh2:UIbN
ViB;PWekOhF<TYJETH^5P7j0PhR;S8^7PWikNWaoPX>2Og]iNX2<WK32cmKCbKVV
U8InNgb0Q8F4P7]gMGEhOH:5QH=oNWIfN7f3R8^:QX1iM79dNGn6RHR3Ng=/JF]b
O8N?Ti6:Og=ZIFEZLWb3R8V6PWijNW]nPH:2PGmmOX:8T9NLWIVAR7mjNX2:Uj>[
[JRNT89hLG1dNX66R8N4PGmoPHJ;SHf:PgYbK6Y/L7MlP85oOG]jOH67S8j<QG]_
IV5RJgV:VZN][JJLT8N0OWn3QXR7Q7mkN7QjOX:4QH=oO7]lP8N>TiB@Qg]_I5mO
IG1lQhnAShZ3OWeoQHbCUYJARH1hLW5dNWn4QXF2OgakO825RH^:Qh=nO7b0QHV;
R81bHU=8@dI@Gg61SI>BSHEnN7IgNgj1PH1mNgYkOhB8RhZ6OgM`K6a`MWj4QhN4
Og]kOXJAW:FZZ:2ER7adLG=iOhB5PWacK6IUJ6ieO863PX1nOWn1QHN9QhB1OWn4
SIVV/;FdZif<O71ZJW5jQHf@T8^5P7alOX:6R8N3OWUeM7MkPHJ9RHF0NgQhNh68
SY6@S8F0O7f1R8nDU8j3Lf=DBdU>FFIdOXB6Q81lNWYlOh61Og]gLg9cMgb0Ph9n
NG=aLWR2SIROX9Z?PG9VH61UKGInPH5mN7AbM7QnPhJ6PWaeL6e^LgZ1QXV8QX9o
OWn2Q8F3OWI^J6IZM8>CXZb_ZZ2BPgQaL7AkPXN9Qh9mN7EeN7]oPH60OWj0QHbD
VYjMUhj4NgEdMgf4RHZ6OWA[IF=WKgV2R8Z6OWE^JFU^MGf4QhN4P7]hN7]oPhJ6
Q85mNg]nPhN:RXJ0NGAdNHFGZ[c8c/_1/Z6AQX1nP8>5QH>0OG]lP8F;SXn<Qh1i
MGAgNh24Q89mMg9`LgR0R8f=RH1fKFMWK7J1Ri6AS89gKFITIVedNh21P7eiN7Qj
OH22PGmlNWYmPhZ@TY69OFmQEe=EGFUeOhB3OWE]IfEXKgR0QHR7Q81nOh:7S92@
SHMoNGEdMgf3R8Z:Qh=oOWn2QXN5OW5RDTDo?dQFJ7V6SXn;Pg]fLgEiOH63Ph1m
Ng]mP8B7R8J1O7MeMg^2R8b<QgebJ65OI6ijQY2DThj6OWUgNWj3QXJ1NG1XHV5T
Jg=kP8>2P7elOGn3QHJ4OgUdL75eNh:7Qh5fJ5U=ATM@GW20SI>DT8Z3OWamP8>5
QH9oNgYjOH65QhJ1NG5ZIVIZL7QnPH1lMg9`LWV2Ri:DT8MkKVAOH6I`NhF:RhR3
OW]kOX>9SHj=RHAoO7amP8:2P7ejNGb3SY^X/KB_Xi:0KfAOHFUcO8>6Q85lNGUl
PHN;SHb8PgilOH66S92@SXR1O7QhNWj1PX1kLfaWIVYbO8F:RXAiK61HEU]VM86<
Ti>@RXAoO7anP860OW]iN7]oQHZ<RhInMW1]KgEmQH^;QG]^HEQEEf1[N8:7R8J1
OG]lP8F:SHb7P7QbKVmcN7n3QHB1OGYjO7n4QXN5PGekOXNDYKG2bLRo[if;O7Aa
M7UoPhB1O7QdLgEiOX62P7eiMWEgNgn1PGeeK6=NGF5YM7n7RXR3OGQfNH2:TiZL
VI67O7EbM7Z2RHj?SHN1O7YjO7n2Ph5nNWMfMg]oPhB1O7E_K6mhQYJV/KFbZ9V9
NW5^L7InQ8R9QX>0OWn1PhB2OWI^If=SIVeeO821Og]hMWQlPHJ8QGidJ5iHF5iY
MH27R8AkLFQSHfQaNX:6QhF1O7UhNWf0PX:0OG]kOH:8S8j;Q7Y_IF5SJgV8Uj6T
XYZ@QWmlOX:8Rhb9PgafLW=fO866QhF1OGUhNWn5RXj>RXEoNgUjOH63PWefKVQV
JgN9W:nl`l6hZY^=PgemOX62PGijMWAdMg]oPX:0O7UgNGf5SI>EU8j6OWQgNhB>
V9nPVi65NG5]KW=jOh:1O7I`KFicNh>;Si2=Qh5lNGUkOX61P7ilO7j4Ri:GUY25
MfUNFEaULh:?UiVDRh1fL6iaMW^0PX5oO7YjO823Q8=oN75/JVebNX:8RXR2O7Md
MW^2RHf<QWebJFEVKGR5TIRJUXj4O7IdMg^1Q8J5PWmmOX25RHb=RhN2OWenPHB5
PGU[FTPk<c@lBee_OHF7Q7mjMWIhOH22PGihLg1`M7Z1QhZ:QX5kN7MiOH64Q85l
MG5_LGImPhF2NViPE4a<DUe/NHB8Qh5iLFaZKG9hOX61P7ilO7f0PX>1O7IaKFic
O8NAVIbITXQoNWYoR9:KWinHSX=iLW5dNGn3Q89mN7EeNGn6SI6BShV3OG]kOH23
Ph5nNWQiOHB<TI:=PG1NCD4m@DeMKGb6RXV4Og]jNgj1Ph9oNWIcLWEiOX62P7]e
LFmaMWj5RHV5O79YHf=XLGb6S8f:Q7ikNh6:UInUYZ:JShEnNWYlP8:2P7aiMWIh
O822PGijMG9cNH6;TiNES7i]GE9>DE]XMh::RhV4OW]jO825QhR5PWmmOh>9Si>C
T8V0Mg5_LGEkOh61OgakOXF@W:R_/:ZNSgmbK6]`NH::SHb7P7]gMgYoQ8R9QhB0
OWenP8:2P7]eL6i`Mh:?Vj:SWI:3MFYUIVafOhF8QX1jMG=dN7f2Ph5lMFiYIfU^
MG]oP7ikNGQjOhF:SXj:Q7mjNWj5SI>ET8EeHe=7@dMAH6mlQ8N6PWikNWanP85o
O7UgMgZ0QhfATXj8PWimP8N?UYZIThUmM6i^M7f8T9FDShInMgAfNh67RHN2Ng=^
K6idNX23Q89oO7YkOH63Q8=oNgYlQ92Q//38b;n`WX]mM75dNX24QH9lMW5`LGEk
Oh61OgakNgj3RHf?SHInMFi[KG9hOX:1OGMaKFicOHNAUYF>PgI[I6=XLGb6S8j<
Qh9mNganPHB4PWmlNWYmPXJ9RHJ0NGAcMWj9U9bNV8alJU]ACU9KIg9kOh1oOGf0
Q8V=Shf8PGUcLG9gOXF9RhV6PGmnPHB8RHN1NG5ZJ6aePHfGVYN>P75UGEaRJgIo
QHN5P7ajNGaoPhF5PWmkNWYlOh60O7AYGeMEF65]NH>8R89jLF]ZKWEoQh^;QWif
L6e_M7b3QhR6PWejNWf2R8f?SXZ5P7imP8>6R8J3OWamQ96Q/l;<cLJhYI61Mg=e
NX66RHR5PGelOX24QHF2OGQeMGQoQXb@T8b6P7akOXB<TI>?Qga`J6AVKGN2RXf<
QWmiMgUoR9:JWIbFSXIoNgYlOX20OgekNgj3RHjAT8^3NgIeNhFDXjjd/jZLSGme
LWAjPXR<S8R3OW]jO822Ph1lMW5^Kg=jPHN:R8AnN7EeNGn4RHV7PWikOXJBXJnh
^kN[VhYkLFe^M7YoPX5nNWQgNWj3QhV8QH5nO7j0Q8F4P7U`JVMZM8:CXZfa[ZFI
S8=nOX>9SY2?RhAoO7b0QhfATXn9PW]gMWUmPXJ7QH5mNg]mPHF6Q7ieJfAQI6ej
R9>IV923M6IMFeiVLGZ1Q8>0OG]kO7n1PX5nNgUjOhJ?UibMVI68P7YiO867RHR1
MVYOF5MLIG5lPhF3OGMcLgInQXjBTi2:Q7mmOX:6RHZ9QH5mNganP85oNW=[IVI/
NH^P/[k3_kBTThEkMgQlP8:2Og]hMWQmPhR<SH^6PGimOhB9S8f9Pg]dKfmcNX:8
RhV4O7IcM7^5T9RLVI64MVYSHFI^Mgn3Q89nNWQhNWeoP7mkN7EeMgb1Q8F1NW1W
HV9XLh6?V9bHSh9eK6MXKgN0QhV8Q81mO7f0Ph>1Ng=[I65RIfmgOX62P7elO7j2
QXR6P7M^IfEYM8BEYJnb[ZBGRX5lOX:9Si6@S8J0O7]lOX21OgahMWEgO866R8Io
MfeWIFUcOhbFViVCR7ifLW=hOhB6Q7eeKFQWJg9jPXN8QH1kMgIgNWj0P7eiMG9b
MGZ0QHN6PgilOhNEY[W8d=38^:FAPWQdMWYoPh>2OgakO7n3QXN6PGahMWMlPXZ?
T8f7P7UeMGQnPhJ4OG=XGeUJHFahPhV:QWifL6maN827S8f9PgagM7EhOH22PX5n
OGeoPXB4OgIZGE9=CUITMHB?Ti28OG9[JFacNh>7QhB0NgUjOH65QhJ2OGQeMGUo
QXb>SHR1NgMfNGf1Ph9lMFeXIfegQ96JW9N<OFeQFUUNIg5iOh60OginPHB8RXV6
PWejNGb1QXV:Qh5jMGAhPXnNZK2_YiZ;OG=_L7EkPH>2Og]hN7^2RY6EUI29PGYf
MGQlOh60OGUfMGIiOX61OWQ`JFIYLX6CXjnd/ZRIRWifM7MnQ8R9Qh9lN7IgNWf0
PH1nO7b0QXfEVIZFSXAjLg5dNX:9SHb7OgUeMgf8UJ2VYj>JShJ0Oh:7SI2@S8Io
NGMhO865QhN5PWmoPHB8Rhb9PgehNGn;W:jnb<[3]J>@PGQdMW^0Q8F2Og]iNWf1
Q8F3OWMaK6]^MGb2QXN5PGimP8J>UIVHThYoMW1`MGf6SHj:PGEYHEiQJWF1RXj>
RhJ1Ogj0PXB4PWikNGYmPXN9R8=kLV]XJg>0SYZPX9V=P7A]JfmgP8N:RHF0NgUj
OH>7RXV5P7]iNGf4Ri6CTXf7P7ajNgj0P7ijM75bNHFFZKW3aKnbXHn1N7IhOXB8
RHN2OW]kOX:6R8V6PWikNgf0Ph=oN6mUGEYLI6iiPXF2NW1VGUePJG=lPhF2OWUg
N7j6SiNJVYB=Q7ijNWf1Q8F4PGimOH65RXf=RH9kMGAhPHfJXjFPU8AbHeUGG6Ib
OHF8R8F1Ogj0PX>2Og]eLG5cNH68SHj:Q7afLgAhOX:4PWacJfETJW=oRY6CSXEi
KfQWJg9kPXJ6PWagM7AgNh24Q8>0O7YjO7n2Ph5nNGIfO8VI[;c7b/BgYYB5NgMh
OH63PWihLVi^LGImPXB2OgYgMgUoQH^>SXZ4Og]jOH>8SHj<Qh5lO828TY^QX9R:
NFULEUMNJWIoQHF2OWUgMgUmP8:2PGmnP8B:Si>CShQoMg9bMWj6Rhb6O6mQEeAF
GfahPhR9QGmjMgQkOh:2OgQ`J6=RIF]cNh22PGilNW]nPHB4PGafLW9gPHjLYZVU
VHUfIUaHG6EaO8>6QH5mNg]nPXJ9RHJ2OgamOh>7R8J1NG9^KG9jQHnGVIF>QWik
O869T9FEShIkLVi_MGn;U9VIUHj7PGmoPXB5Q85lMgAcMWYoPhB3P7ioPhbGXjb_
Zin=NFIIE5IOK7V3R8R5PGekO7j2Q8>1O7MeMGUoQhf@Sh^4OGQfMg^0PhB1OGQe
Mgf9UZ>/[jbRUXV0OGn6SYJJV9:9OgIaL7=hO7n0OgajNW]nP860NgE_Jf]`NXJB
VYbHSX5dJfQ[M7n:TIBARh=lNGUmPXJ8Qh=mMgAeN7j5RHZ8PgiiMgQlP8B6Q81j
MG9cMgaoOgU/FdPg;2T_?E1SM7n5QH9nNg]mP8>5Q81lN7MhO865QhJ2OGQfMgb3
RXn@Rh5dJ61MHFYePHV<RXAmN7IiOhN>TY:=QWihMGMmQ8Z>Shb8PgmmOX21PGmk
MW9bMWf6Si>BRWa[FTi9BeESLGf4Q7mhLFaZKG9hOH20OWakO7j2QHF2Ng9YHV1R
J71iOh:1OGYhNX29TYRJUXf0LfUUIfmkQXjBT8V1NGAcMGZ0Q8F3P7ajNGaoPhF5
PWijNGYnPhR:QWe^GTi4@DMDIGR7TIBARhAnNganPH:0NgE_K6aaN827S8b:QX9o
P8>8SHn>RXAmNGQlPXR=SHV0M6YTI6]hR9JQYJ:ISH1gLW9eNWj1PGmlNg]nPHF7
QhF1OWeoQHjGWZ6NUHYnMG5cNX><TI29Og=YHf9WKgR0Ph>0O7UiOH>:Si:AS8En
N7IhO865QhN4PGmoPXF7QX1eIUE8@419FFf0T9RJUHb2NgQiO865QXF1O7UgNGao
PH5mN7=_Kg9hP8J8Qh9jLfi^M7f8TINGTXV0N7EgOHF<Shf6O75XI6EZLgf4RHV7
Ph1oOh:4QHB0O7MeMWZ0Qh^;R85jM7AjQiR[^lG7`;>SThIoOGn2QHJ3OgYgMWQk
Oh1oNgA]IfEWKGEmPXB3OgYgMgYoQ8N6PGQ_IfAXLX6AWjNYXiR<P7UfN7f3QXJ3
OWQcLW=gO822PX1nOWn3QhZ:QGa`I5YEEf1^OX^DUY:9OgIbLgQoQXZ:QX1iM7=e
NX25QXAoNGAaLWIlPHF6Q81kNGUlPHJ8R8=mMW9cNXJDXJZ/YIR6M6ELFf1YLgb1
PX5nO7]lOX20OWYdKfe^LWUoQ8J3OGI`KW1eOXF9R89fJEiGEU]ULGb3QH=oNgUl
PX^CVYbITXV1NgQiOH63Q89oNgYjOH65QXB0NgMhOX^L[[k8b/>fY9>5OGb0QhjB
TXj8PgmnP8B8RXZ7PgmlO7n4R8V7PGU_J6AUJg=lPXB3Og]iNh:;UYjRWYF7MfYR
HFE_NH>8RHJ1O7UiO825QhN4PGilOH65R8V7PgejNGj6TYfUYZ2CPW5RFEUOJWJ0
QhR6PGaiNGaoPH5nNG9]JVabNX>:SXf:QH1mO7j0PGmjLf]UHfI_NXF<SXUoLVIM
Ff5/NXNAUYF?Qh1kNWb0PhF5Ph5nOWn2QHJ4OgM_J6IXKgV2RHZ5Ng1UGeiSKGR1
QXJ2NW=_KW=kQ8^>SXV3OGUiO866RHV5P7YeM7IjOh>5Q85mO7f0QXZ<Qga[ET4a
:B/eAUY]Nh>6Q85nOGn3QhV9QX5lN7MiOH63PgmiLfi]L7InQHV8Pg]dKficNhJ?
Ti:<PWM^JV]aNH25Q7mfK6EQHVQ`N7n3Ph5nOGeoPXB5Q85mNg^0R96JWijGRge`
JFQ_NhZGWj6LTXIkM75cN7j2Ph>1Ogn2QhbATi6;Pg]dLW=hOX>6QH5lMgEfNWn3
PgidJ5]BCeAOKgn=UIF@QWacKfmbN7f0PGmlNWUlP8F9RXV6PGimOX:5QX=kKf5D
C4YAGVn0SYFFTHV1O7]mPXN:RXEoN7=aM7Z2RHf>RhF0O7]mPHF7QX=nNGEeMgb1
Ph9mMFaVIFaiRYf/];F]X963NWIhOHB9RhZ6PWmmOX22Ph9nNWMgNh:;U9^MViB;
PgelOhF:SHZ2MVUNF5QNJ7AnQ8F1NgEaLGIlPhN8QGifL6a/L7EkOh60OginP8B8
RhZ5OGE_KG=oT:>b_;ffYiJ5N75`LgUnPH1mN7EeMg^1QHJ5PGahMgQmPhR:RHAn
Mg=cMWf5RXb8PGQ`JfY_MWf1P7U]Ge58AT]EHW1jP8:0O7YiNgj1Q8>1OGYhNGf2
QhV8QGmjN7Z2SY^UZjVPTX5aIf=VKgV3RX^9Q7mlO7j2QXN6PG]eLW=hOhR>TI2<
QX5mO7j2Q8F4P7akOHFAX:jh^kFYV8IgKfeaNX>9RhV2NgAaLGAiOH21OgekNWao
PXB2OWM`Jf]`NXJCVijKThV0NWYoR96IViVAQgihMWUoQHV9QGifKVY[KWEkP8:1
OW]kO826Rhj=RXF0OGf1QX^;QW]ZEdHk>3i=H7B5T9FCSHN2Ogn1PhB2Og]hN7^0
Qhf@ShZ4OGUhNWn5R8R4O7A]JVacOHN>T8b3N6iXJ6efP8R;RH9iL6]YKG=jP8>3
PGeiN7UlP8:3PWmnOX:9TYZNW9B5M6AHDeMQKgj9Shn:PW]gMg^2RHf>S8N1OG]l
Oh62OgUbJVETIfifOX>5PgmkNGYnPhN8Q7aaIUiMHg20TInVYYnCQgaeM7MkP8>2
P7aiN7YmPHF6Q85mNgb1QhnDUYB=QGejOHJDY;6j^kBXVH^1O7aoPXB4P7]fM7Il
QHjEV9NBRhAnO7j1Q8N6Q85nOX26S96DTH^2NWEfOHZJZK>e[j>BPWA]K75hOhB6
Q85nO7aoPXF6QH9nO7b0QHbATXj7O79ZIfU_Mgn3PWefKf]]M7n;UYbKUH^1N7=d
N7n5R8R4OWUeMGQnPhN8QX9mNWUkOX62PGeiMgZ2T:>gb=;Cc;bYUXMnO826S8n>
RXAoNg]mP8:2OgYdKfa^LWV0Q8F2OGMcLWEkPHF6PgacK6U/Lgj9TIBARGieKfme
OhbFWIfIT8MnNGQjOH21PGmnOh66Ri2AT8Z3OGUiOhRAVI^GSGm`IEmQJWJ4SYBD
ShR1O7]mPHB5PgiiM79cN7n7S8f;QGmiMgQkP8B5Q85mNgb0QhjCTXYlJEI6?3a4
DfAePHR9QX9oOh65RXf=RXEoNgYkOX62PWmkN7QkPhfGWj6MU8MkLVmbNXF>U9FA
RX9mO7n6SiFHUHn5OGIdMW^2QXR7PgijN7QlOh:3PGikNG^0QhjCThj3Mf]UIFil
Sj2]/k2WVXf2O7YlP8>4PWmlNg]mP8>3OgU`JFASIfihP8F7QH5nOX68TIRKV923
MFUQH6E^NH23PGYaJFEUJW9lPhN6PgijN7UkOh62P7ejMgQjOX61OGAXG5=AEV9e
RIZVZZJLT8EnNgf1QHN5PGYeLG9eNh24Q85lMg=bMGUoPX=oNG9/JV]`Mgj2PX1l
NGZ1SIb[]kbi[Yj;Ng1/KWEnQHV9Qh=oOWn2QHJ6PgmkNGYmPXN:R8=lM6i^Lgf8
TiZKUHYmLFYZL7Z5SiBDT8Z4P7n1QHR7PgabJVARIVaeO863PX1nOX23QXR7PWag
MGN0SIfZ/kB]WhemL6]/Lgj7SXn<QWmiMgMjOX61P7ekNWb0QHV:R89jLVa/L7N0
R8b:Q7acKVebNX>;SXb5O7=^KWAnRYBJVYJ>QGmkNgj2Q8B1OGUfMWUmPXF5PWij
N7UmPXN8PWITD3d_:RllCf9dOhF5PGejNWf0Ph>1O7IaKg5fNh63PgihLVi]LGMn
Q8J5PWilOH><UYjRWiJ:OWA`Lg^7TYZMVI26O7IdMgf3R8V7PgmkNW]mOh1nO7Yi
O8:<Uj2TXi^?PGE_KWEoRY:DTHQlLFUVJFmgOX61OWYfMWUnQ8R:Qh9kM75aMGb2
QhV7Q81nOh:7Rhb8PGQ_JVaeQIR[^/6o]JJFQgikO825R8R6Ph1oPHB8RXZ7PWag
MGIjOh>4P7YbK6]^N8FBWJ>RVXn3NWEfNh:8RhV3O7IcMGb5SiNJV9>;Q7mmOX23
Q89oNgUiNh25RHZ7PWaiNh>@XK6m`[ncXY20MWAgOXJ<SX^6P7YhN7YnP81nO7Ui
OH>;TYNGTh^2NWEeNGn5RHV6PGelPHZFXjf`[J:CQ7M_KW9hOhB4P7UbKFa^LgUn
P81mNWQgNGaoP7mlMgAdNH:?Vj>UWi:0KEiEE5YULWf4QX=oNgUkOhB7R8J1NWEc
MG^2RHj?SHV4P7n1QHV;RXEmMW5`M7b4Rhf:PGI/IVM_OHnOZk2^YIZ>Q7mmOX21
P7ijN7MiO823Ph1kMG9bMWj7T9FDShIlMGAhPi2LYJRUW966P7j1QXb?Sh^5OWUh
NX26Rhb9PgafLg=fNh64QHB1OWioPXF4P7EVETLm?4ADJGj?VIbGSXEmNW]oPhN7
Q7mjMWAfNWj1PGmlNWYmPh^CV9RDRh5hLg=gOhJ:RH=jL6QTIVihPHN8PgY`J6EW
KWR2RHb;Qh9mNganPH:2Og]hN7YoQH^>SHV3OGYnQiBS/;Rf[If9MfUSHfYcO8:4
Ph5nOGj0PhB2OGE^J6IXKgMoQHN5PGekNgn4RHb;QGifLW9iPi2KXInGRW]^IFAY
LG^3QhN2O7MdM7QmPXF5Ph5oOh65R8^:Qh9nO82:V:Nd_;ffZ9R9OGQiOhF:RhMo
Mfm/KG9iP8B5PWehMGEhOX>7QhAnN7=bLgQmPH>1OGUfMgZ0QXV7OFiKBC`f>TIG
JW^6RXR3O7QfN7b0PX>1OWakOH65R8R5OWM`KFidNh>8R8AnMW9bNHBBWZNYY9V=
PGUfMg]oP7ihKfMRHFI^NH:8RHN3OW]kO7n1PX5nNgYlPHR@U9B>PWEXH61WMXNH
YJZWWY:5O7QhO864QH=oNgQiO865R8N4P7akOXB<U9ZKUi28P7akOhF9RhV2NW=`
LWZ7UJ2VYIb?P7A/JVedNh64Ph5nOGj2R8b?SX^6PGinOh62PG]cJfETJGF6V:R`
/:RJRW]aKFmeO863PGehMWIiOX>6QH5jLfi/KgEmPhR8QX9nOGj1QHR8Q7ifL6mc
OH^HXZJSV8YmLViaNXF@UiVFSXInNWUkOH21P7ilO7j3QhZ:QGecJVETJG5kPXF2
NW1VH61VL7b6S8b6OGA]JfecNWj0OWUbKVe`MWj5RXb:QX9oP8>7Rhf<R8=oOGn2
QXR4NVUD?R`R8R`mDVIfP8>1OW]jO824QXJ3OWYgMgYoQ8N7Q7mjMgMkPHR<S8Mn
M6]VIfegPHR:Qh1hLFmbNXF@UYRCRWmeL6mcNX66R8N3OgakO7n2Ph5nNgQiO8:9
SHf8OW5UGE]QKGf<Ui^HSX5eK6U/LWZ1Q8B1OW]kOH22Ph1kLfaXJ6adOXJ;S8V4
OgalOX21OWM]HEMBDeaZNXR@TH^0LfUSHfQaNH22PGeiMWIhO822PX1lNGMhNgn2
PGeeKFMUJG>2TIfSXYV<OG5ZJVmgP8J8QX=oOh:8TIVNWibDS8AoOX24QXN5P7]g
MWQmPhN9Qh=nNWUmQHjEUi:5Lem>@d16DfAdP8N8QH5nOGj1Q8J6Ph1mO7j3R8b<
RH=lMG9cNH:;TYFCS8EoOH6:UJ2VYj6FRGefM7ImPhR8QGihM7=gOXJ=TI6=R89n
OGj0PX>1OWakOXB<TiNDRWYVDdDo@TaLKG^3Q85jM75bMWf3QhR6PWmmOH24QhN3
OGE_Jf]`MWf1PGegL6a/L7R0QhZ8PWUcL7=lRIJPY:6GRG]`JVY_MWf2Q8:0OGal
Oh:3PWiiM75aM7Z0Q8F2O7IbMGf<WZnl`KfaXI22NGIhOH:4PgmkMgIiOX>7R8En
MVm[JfmeO864PWmkNGYmPXJ8QX5jMG=hPY6R/;Rg[j2?P7EaM7^4RXf;Qh1kNGYm
PXF7QX>0OGenP85oNG1UFeEDFVAaOHF7PgadKVebNhF>Ti:<PgUbL79hOhF8QX5j
M75bMWb1Q8B1OGQeMWUmPHB3PGikOH69TYVJU8MfHe=:BU=SMHNCVIRBRX=oOGio
OgijMW9aM7UoQHV8Q7egLW9eNX65QX9lMW9bN8:?VZ6RWI>8OgYjOhN=T8f5NFiU
H69XL7UoPX9oOGamP8>6QXB1OG]lP8F;SHZ2MFIJDeAMK7j>VYjKTXQoNWYoQH^?
Sh^6P7enP8B7R8J1O7MfNGn7SiBETX^4OgamP8B6Q7miLg5fP96S]<33_K2OSX5i
N7^0Q8J4OgYfM7IjOX:3PWmmNgf0QHZ<RXEnMgAfOXZHY:ZYXI>4MVi/LGV2R8^9
Q7ijNWf2Qh^:QGedK6QYKGAkPH>3PGimOh:6QhJ1NW5ZIfU`NX:7Q7]/Fde4@d]I
JGV4RHR3OGQfMgYnPH:1P7moPXR=TI6>QgifLW9gOhN<SXZ3NgEcMWn9TiRHTXMl
LfmaN86:T96=QGefM7EiOh>4PWehLg5cMW]oPH1mNWUjOH63PGU[FDDf;BhiBf5f
Qi2BSXN1OGj1QHR9QX5lMgIhO8:6R8J2OGUhO8:9Si6?RH9jMWEiOX>5PWY`IEeK
H6YfPXR9PgQ/HUaMI6iiPXN7QH5nOGj1PhB3P7ajNWf2R8^;QgicJF=RJ79nQXZ6
NfeNDdmAFVIcOH:3P7elO7n3QhN4OGE^JFQ/M7b3QhN4P7elOX:6R8R4Og]iOHND
XZjd/JJDPG1UHFE_NXB;S8V4OgemP8B7QhF1O7UgNGaoPH1lMg9`LWV4T9VMVY64
MV]VIVaeOH61OGI`KFmeP8ZCUYF?QWmjNGb2QhZ:Qh=oO7f0Q8N9Qh9lMgEfNWj0
OWEXEdLm>d9AIW^=V9^HT8N0OGj2QXR9QX=oOGf0PXB2OGE/IF5RJ71iP8>3P7ek
OXB<UIZJU8UkKVIUJWB0RY2?RX=kMgQmQHfDUYB>Qh1lNgaoPH:1OgemP8F:SXn:
PWI/IVI^O8jNZZjYWY23NGEgOH>8RXR3OWYjOH:7Rh^8PgeiN7^0QX^<RXAnNGMi
OhF;SHb8PWimPHVCVijJSWaXETY6BUESLGb1PX1mNganPH>3PGagM7=eNGj2Ph1l
MgEgOHNBW:2MU8IgK6IXL7b8TIFCSHEnNW]nPXF5P7U`JFIXKGEmPXB1OGQeMGMk
Oh:2PGmnPHRAVj>UWi>1KUiEE5]XMX:9RHAkLfe[KWAkPHB3PGmmOX23QHF2O7Mc
LgN0RiBKW9RAR85mOhB:SXj8OW5VGUaQJgIoQ8=mMFaXIfadOHB7QhAoO7]mPHF7
QhF0O7YjOX:6R8J1NWEeO8ZN/lOCe/o1[IZ;PGj0PhN8QX=oOGj2Qh^=RhIoMg9a
LgUoQ8J4P7]hN7b3RXn@S8AjLVm`Mh6:Shj7NVaOF5MMJ7EoQHJ3OGMdM7MkP8:2
P7elO7j1Ph=oNG5YIVM_NhRBV9J=P7=XHfI]N8:9RXEnMFm]KgElPXJ6Ph1oP8F<
TiRIUXn6OWQfN7aoPH1mNWQiOHB;SXb2Lf1>@Se2Cf5dPhf?S8EmNGMjOX:4Ph1l
NGMiO822PWmkMW=cMgj6S8f:PWUaKW5iQYBOY:>LTHInNWb0QHN5P7M^IfIYLWb6
SI2>RXB0OWn0PX5nNWA`Kg5fNgn0O7E/IVI/NHZKZJn/XI5oL6ITJ71hOh:2P7el
OX65R8V6PWeiNGb3RY2BShV0N79`LgUoPh>0NWEcMh6>WJV_[ZJIRgmhMgb4Rhn?
RhAnNGQkP8F8R8J2OW]kOH22Ph9oOGj3SYf^_<G4_:bIQgYdMWf7Si>CSXJ0O7ao
Q8V:RHAoNWQjOhJ<T8n<QX1lO7n3R8Z:QGmjMgUoQXjBTHYnLVUVJWJ6UZ>ZZ:2C
QW]eM7MkOh61OgelO7n2Ph=nN75/JVacNh:6QH1iLVi`NHJDX:NVWY:4NG9aMG^1
Ph9nNGAcMWb4Rhn>RX=kMWAfNh24QXF2P7n0Q8V<S8R1NG=cNXRK/<;<c/FfXi63
O7YmP8>2OWQcKfmbN7f1PX5oOGf0QHZ>SXV1MfiYJFihPXV=RhEmMgEhOhR@U9>;
Og=ZIfUbOHR@TY2;QH1nP8B9S8b:QH5nOX23QHF3OGMcLWInQhjAS85`GTi5ADiM
KWj9SXb6OgYgN7]nP7mlNGQiOXF>UIVHTh^3OGYlP8B7QhF1OGf1RI>MXZ:KSh1c
JfY`NXF>THf4NFiWIFQ_Mgj2PX1nO7aoPXF6QH9nO7b0QX^?SXMkKF1GEUaXMhF?
THf5NgAaM7Z2RHb;QX1jN7YoQXb@Shb6PGinPHJ;SH^6OgQdLgEjOX61OgalP8ZJ
[Ko<dLbnZI>0LVe^MGb2QHB1OG]kOH23Q89nNGEcMGUmP81mMViWIFM^Mh25Q7id
JF5OHVaiQ8f?S8ElMW=eNX25QH5iKfMRHfQ`N7n2PX5nO7eoPH>2OWUdLWAkQI2I
W9R=OVeQFeiXMhJBV9N@QgihMWQlP8>3P7ejNW]oPX>1O7A[IF9UJgAlPH9oNWIe
N7j7Si>BS8=jM7=jQYFSZjfWW8n2NWMiOH:5Q85mNGQiOH65QXF1OGUiNWj1PWmh
KfMSIFn0UJZi`;jdYIF7OgamP8:1OGQbKg1dNh:7RHN1NgIeMgf3RH^:QX5mO7j2
QhZ:QWmgLW9hPXnJX9nFQgIWGUeRKGZ4RX^7PG]gMgUmPH:2P7imOh:5R8R3Ng5X
Hf=YLgj8SHf7OgUfNH6=VZ>WXiZ>PWYfMg]oPH1lMW1]KW=kPhZ=RhN1OGYkOX:5
QH=oO7]mPXR;RX=eHe52?3m;GW>6TiRFShIoNgaoPhJ6Q85mO7j2Qhb>SHR2O7Ui
O864QH1hKVAMG65ZM7f1OgU`J6AUJgAmPh=mLfMNFE]RKGR1QXN5PGinOh:4QHB0
NgQfN7b2QHJ3OGIbLg^8VJZf^[JYVHMjLW9hPHV>SXZ5Og]kOH22PWmkMW=dNH6:
TIFDShR0NgYkOh>5Q81lNWf5TIn/];B/WHakL6]^Mh6:SXj9PWaiNWj3RHb<RXJ2
P821PX:0NgE`Kg9jQI2HVIB9NVeTHVQcPHfEUY:;Q7mnPHJ<Shf8PGUdLgIlPhR:
RHAnNWQiO823Ph1kMW=dNH27S8f8PGYfNH>DZ;c:cl^n[9V9OWUjOH22PWmmO7f0
QHV:RHF0O7]mQ8bCUiNBRhB0P8F=UYbLUX]mLFUWK7EoQXV6OgM`KW1fOXJ:RHEn
Mg9aM7UoPhF3P7ekNgf0PH5mN7AcN8BDZ;W5al6bWhenMgMmQHb?SXV1NgQhNh65
R8N4PGinP8B9RhV4O7=/JF]aNH65QX9mN7MiOhN>T8b2M6IKEeYSLGj8S8Z3NG5/
K6meNh21P7mnOh:6Rhf<R8=mNW]nQ8R:QWeaIEaJHFn1U::YZ:2DQgehN7b0PhB2
OgemPXVBVIfLUhj5OGUiO7n1PGmjMgEgO8:8RhV2NW9^L7V8VJN`/JVKRgedLWIn
QXb>S8R2OgenPHB6QH9nNg]mPHF7Q7edJF5OHVahQHnBT8QoN7EgOXR@U9><PGM_
K6ieOHB7Qh=mNGMiOXB9RhV5OWUeMGQlOh1oO7YiOHB=U9RDR7IOBS/e>DIHJgZ4
QhF1OGamPHJ9RXR4P7ioPXN;SHZ5OGIaLGEkPXR9Qh9mNWf4T9bVZZROThMnNW^1
Qh^:Q7Y]HeaLHV]eOH:3P7ajNGYmP8:1OgelOXB<TiVJUHf2NWIiPi:Q[K:_Y9B4
MVi]LWUoPh>0NgMfMg^0Ph>0NgEaLGEkPhV;RHAlMW=cMWb0PX1lN7IiPHfKYjbZ
WheiIeYFFF9^N7n1OgajNWb1QXZ;R8AoO7amPHB6QH5mNgf4SibW[ZfUUXEeJfMZ
Lgf5R8J0N79_L7EkP8:0NW=]JfecNhB:S8Z5PGimOh:5QXAoNWIeN7f4R8R1MFMI
DE1GIWN8TiJBQg]_J6MZLGQnP81nOGamOh61OWQaJfMXKWN0Qh^9PgafM7MmQH^=
RGmcIemMHVeiQ8^<R85jMgMmQ8bATXj7OgUfMWUmPH60OGUhNGb1QHN6PgmnPhjN
/L??dlblYi1nLVi`Mgj3QH=oO7]nPhV>T8j:Q7mlOH65RHV5OgQbL7=iPHN:RH=k
M71aMGf3QX=jKV9JF5eZNX^GWIbFSHAnOGn2QXN6PgmmO7j1Q8J5PGejNWj7T9VN
WIJ;OgIcN8>AWjV/YY^>PGQdMGYnPH5nNWMfN7f3QhR4OG=[IFEXKgIlOh1oOGj1
QHZ<RX9gJUmJGFMgRINOWiN:O71ZJg1iPHJ7QH1lNW]nPXF6QH9oOGj2Qh^;R85g
KFQWKGN2S92>Qg]`IfEXL7Z1Q89mMG1^LWZ5SYBETHZ1NgMhNgj1P7eiMGAeNGn4
QhN4Og]jO867RHIlJU@o;RHX=4MLKW^2PGiiMWIhO821P7ejNGYnQ8V=SHV2NgEd
MWb3R8Z8PWYeLgEkPhV:QG]]GeICF69^NH62OWMaKFidOHN>TI2;Q7ikNgeoPH5o
OG]lOhB9RhV1MFQMEeUTM8JFWj6LTXMnNgj5SIFHUi6:PgmnOh:3PGafKfYYKG=k
PHB3OWQdLW=hOX>4PWehM7EkQ8nGVIB6MF9BBT]DHW5nQXV7PWikO7j1PX9oNgMf
Mgb1QXR6PWagMWQnQH^;QWY[Fe1;CeYZNHF<S8R2OG]mPHJ9R8=kLVaYK7=kPhR9
QX5mNW]nPhJ8QX>0OWn4RY2BSXEhJUmKGfanTJ2YZZ:GRX1jNWn4R8Z8Q7mkNW]o
PXB4PX1oPXRAVj>VXi^?PgYeMGUmP7igKVAMG69]NhR@TXf4NG5]KgEmQ8R7Pgeg
MGIjP8F7QhB0O7]lOh:3PWiiMWIlQiFR[:fUUH5/Fe9CFfQfPHN8QX9oOh64QhN4
OgQcLG=iP8N;RhN1NgMgNWj2Ph1jLF]WJG5kQHb=RH1fKfecOXbIXJ:MTHAhL6ia
MWf1Ph>1Ogn1Q8J7QX5lMgEfNh67R8AkKV9IEU]WMXB>THb3N6iZJg1iPHF6PWag
M7AhO7n0OGM_JFIXKGEmPX>1OGUgMg]oPhB2OgalPY2S^<_Hg=G6/Ib;PGf0QHV:
R8=lMgEfNWj2Ph9oO7YkOh>6QhAnMW1^LGV4SiJGTXQlLVe^MH2:T9:>QWegMGQo
QXb=R81fKFQXKGAkP8>2OgajNgf0PH1kMFi[JfmfOH60NFiRF5EKJGbAXjj`ZIf@
Q7ajNgj1PX5nNgYlP8B7Qh=lM6eZJg5iPHJ7Q7miMWMkPXN9QWebIUeKGfYgPXV9
PgU]IF5TJgAmPX>1OGUhNWn4RH^;Qh>0Ogn1PH1kLf]VIVekSJ2_]kJ[W8YkLW1d
Nh65Q81jMG=eNh68RhZ6P7]hNGf2QXN4OWI`KFmcNX24Q89nNgb1RY>IVYF9NV]Q
GVAbPi>OY::JShEoO7j0PhB2OgajNWb0PX9nNG9]K6mgP8R=SHQoN7AfOX^IY:RU
W8ioM6i^LgYoPX9oO7YmQ8fFWInMUHb4OWamP8>5Ph5nO7f1QXZ;R85hL6eaOHjQ
/[bm]JJCPgMbM7Z0QHJ4OgUfMGMkOh20O7UfMWUnPhN7PW]cKVaaNXF?UIF@R7mi
MgZ0QhZ7Og=UFUEGGf]hPXN6PG]fM7EiOX:4PWikNGUmPXJ9R8F0OGaoPhR:Qga[
Ed@g<SQ6FVinR8Z7P7UfMWYoQ8J5PWilOH67S8j=QgieKfa^LgZ0Ph>0OGanPh^B
UI>;OW5VHFA]NXNAU927O79^KgJ0RI2CT8^4OgalOX20OgaiN7UmPXJ7Pg]_He]H
GFIcOXB4O71TFUIIHVijPHB2OGQfMgb2R8b;Qh1jMWIiOhF8Qh=mMg=cMW^0Ph9o
NgMgNh67RhUoKUY6=S0d@UEZOHV>SHR2OgeoPH:1OGQcLG5eNh24QH>0OGf1R96H
W9ZBR7efM7V3SYRMViB9OWIcMG^2QXF0MfiWIFQ`NH:7QhAnNGIfN7aoP7mlNGQi
O823PgedJ5eGF65aPi>MWiV=OW5ZJW1jPhZ=RhJ0O7YkOH20OW]hMgUoR96HVYR@
QgmjNGb0QHN5P7YfMgf8UJ6XYinAPWE^KWAnR8nASXN0NGMhO8:5QhF1OWalOh>5
QX=oNGIeN7j3QH5fIE90=34hAeY]O8F7Q7mkNWf1QXV9Q7iiMWMlQ8bATXn9Pgek
O7n2Ph5kMFi[K75hOh>3OWMaKgAoSj2^]K>XV8IfK6U/LgYoP7ijMgEfNGaoP7ml
NW]nQ8bBU9:;PGQbLGJ0Ri>FTh^0Mg9dNhNCW9nLU8Z1O7]nPXJ7PgegLW1dNX>;
Si2=Qh9oOX23QHF3PGn1Qi6NZ:j[X8ihHeA?DUi]O8J;RH=mN7IhOH64Ph1lN7Ig
Ngn2PWmjM71`MGb5Rhj;QGefLgEmQi2EU8j3N71]L7MoQ8EoMFMLE5=HHVihOX60
OWemP8>6QhF0NgMfN7f2QXJ2NgA`LGZ7V:J_[jJFPVmRG5iVL7UoPH1mO7f1QXZ;
RHAnN7EgO8>:SXj9PW]fM7MkOh:1OWUfMgf8U:2VY9^;NFQMFUmYMGj3PgigLFma
MWb2QHF2OW]jNgj1Ph:0OGf0R9>PZJfZWi20LV]/Lgf7SHj9P7MaKg=kPhV<RHAm
NGMjOhF:RXN1NGAaLWIkOh5oNgQfMgb3RHf<R89mO8>@XKC3b/RlZIB2MG1bN826
R8N3OgemOX21Og]fLFmaMgn7SHj<QWmkNWj5Rhj<Q7MYG5EFG6QcOH5oNG=^KG5i
PXV;R85hL6][L7MnPhF4PGmnOh:5QhJ2OWYhNh::TI>>PFiIAc/i@DmQLGb1P7]f
LgAiP8J:RXN2OG]kOH63PWmiM75bMh2:TYJDShMoNgYmPHB4OgI]IVAZMXNGY:VU
Vhf0MW9cNH25QhJ2OW]lOh>7RHR5PGimOX:5QXAmMFeXJW9oSYZPWY>3LF=JFV5/
Mh25Q85mNg]nPXB3OgM^IV9TJG9jP8:1OWYhNGb1Q8F2OGQfN7n;V:>XYIf@PWUg
OHVHYZj_ZIfAQGilOH63Q8>0OGamP8>6QX=nNGIgOHJ@UiVFSH5gL71eOhV@THb3
N6m[KGAmQXb<Qh1iM7AiP8N<SX^7PGinPXN<Shn;QX1lO7f0PX5mNGEeO8^O]/[H
fm?2ZiF3N7AfNh22PGeiMgMkP8J9RHN3P7n1QXbATi6;PgejO869T9>ARX5hLgAj
Q8nFV9B:OgIaLgZ4SI>CSH=iLFi_MGb2QXN5PGmnOh21Og]eKfa/LWZ4Rhf8Og9W
HF=]O8jMYJJOThIlMgMlPXN9R8F2P823QhV9Q7ecJfIWJg=lPXF4PGmnP8F;T9:?
R81jNGn:VZZe^;:UTh1bJf]`Mgj2PWmkN7MjOX>6QX=oNgUjOH64Q85lN7IiPXnN
Zk:aYiR6N6m]LGZ3RH^8PgilOXF=UIVHThZ1NgQjOX>7QhAoNWMgNWn3QHAoNWIe
Mgb2QH=jKEe?AdMAHWJ9UIZFS85fL6mcNGj1PX1nOGj1Q8N8QH1kMgQmQY2IWIfG
SXEoOGn4QhN1MVMICda@FfUfP8B2OWUgNH29TIJFTHV0NGIgNWn3Q8>0OG]lOh:4
PgmjMG=hPi>U/k^i[Yb8MVYWJgEoR8b;Qh5mNgf1Q8J4OgUcL75fNh23PWihM79e
O8B:SXb6OWIbLWMnQ8N4OG=ZIFQbPI>RZj^UVH]oN7IhO7n1P7ejNGYmPXF6Q81k
MgMjOhB7QX1fK6EUKG^=Wj^`[J:DQgikOH>9SHf:Q7ikNgj2Q8B0N71YIFI/M7b2
QH>0O7YjOGn1OgYbK6U/MXFFY:^ZWhmlK69PIFihOh5nN79]K71eNh22PX1nOGj1
PX9nMVeTGeiTKGR0Q85jKfIQHfYeP8N:QWieKV]_MX28RhZ4O7A`LGInQHZ;R8B0
OGj1QHR9QX9mNGUlPHJ8Qh5iLW5fQIVaa]CHdL6]VHUoO7f0PX5oNgUhNgn3QXF1
NW=_KW5gOH:4PG]eLG5eOHB9RXElLVYXK7F1SI>DSXAjLg5eOhVBUiF?QWegMWMl
P8:1Og]hMgUlOh20OGYiO8BAX:fe]:^LRGU_K75kQXf?Rh=iL6a]LWQnPH5nNWQh
Nh25QhF0NG9]KG5hPHN:R8AoNgYkOX1nN6ePEE1BGFj2TinRW963Mg1_M7^2QhR6
PWmnOh:5QXB0NgIdMGUnPH9oN75[JW1jQi>KVY:4M6IMG69/Mh25QH9oOX67SiFH
UHj4NG5^L7ElPHB4PGmnOh:6RHR5OWMaKg9iP8F4O6iLC40nAEAXNXR?ShV1NWIg
NWn3Q89oNgYjOH22PWihLVi_MGn9TYNFT8R0O7b1R8nAShMlLVa]M82=V9fLU8Un
MgAfNWn1Og]dKV]/L7MmPX>2P7inPHB8RHJ1NgIgOhfQ]/K?cL6^VHMjMGMmQ8V9
QX5mNgb1QXZ<RXJ1OWj2RI2EUY:<Q7ikO824QXF0N71/K79lR96DTHUoMW=fP8jL
YZVUVXf0Mg=dN7f1PX5nOGanPH>3PG]eLFmcNX::SH^4NW5/KWN5UJ:XYYf?PGE`
LGImPhJ5PGilOH:9Si:AS8AlMgEhOX>8R8J1NgQgNWj1PX1kMgMlQiV]_/[;`k:M
RGUbLWR0R8^;Qh=oOh:6Rhj=RXF0OGeoPXB3OgUdLWEmRYNRZ:NOThMoO7n6SI:A
Rh5fKFU[LWZ2QH=lM6aWJ6edOH>5Q85nOGn3Qh^<RXF1Ogn3RHf>RX5dJ65PJGV<
WZ^^ZIb;O75]KgElPH>2P7elOGn2PWmiLFYWJ6igPHR<RhN2OWj0QHZ<RH5fJfAT
JWJ4TIRIThUoN7MkQ8jFVIN@QgmjNWb1QHJ5PWmlO7j1Q8B1O7MeMgj9U9bNUhUe
HE59BU=QL7^1PWmkNGZ0QhjBTHf6P7]jOH66QhF1NWEcMGZ1Qh^:QX1kN7YnQ8V9
QWmgLgJ0T:Fib<g9_:ZHRH1mOh>6QXB0O7UjO824QH>0OG]lP8J<SXb6O7=/Jg1h
PXV:Q7UZG5ABF6=`Nh:2OgUeLgIkP8B3OWI^J6IZLGZ3R8V7PgmmOWn1P7iiLg1a
Mh6=UibHSGaZFeAFH6mnRXn>QgeeL71dNWn2PX1nOGj2QXZ:R8=mNGUmQHjFVYRB
RH1jNGf4Rhn=QWabJfY`NHF=THf4N6aUHfQ`NH24Q81lNGUlP8>3PGafLW1bMWb0
PH1nOH6;VZg0c];=_JN?NfiZKGEnQ8J4P7ajNgj2Q8AoNG9]KG1gOXB6Q7mjMWEi
OhJ:RhR3OWanQHnHW9^BQ7AWH65XM86:SHV1MViZJg5iPHJ7QH9oOWn1Ph>1OW]i
O8:;U9^LUX]mL6QWKGN2RXb7OG5WHF9YM7j6RHN3OW]kOX>7R8EnMW1]KW=kPhR9
Qh=oOWn3QhZ:QX5lNgn8UJ:ZZZ6@NF9@AdM?GFagOX1oO7]mP8F8RHJ2OGYiO825
QhF0NWA`LGImPhF2NFaPEeAJIG>0RHb:Q7ikOH>;TYFBRWmcJVMYKgMnPX9oNgQg
NWj2Q8>1OG]kOXB:SHb5Ng5YJG1oTZBa][:UU8AgLG9gOX>4PWehMGAgNgn0P7ek
Ngj6SiVPXYnGSXF0Oh66RXZ8PWilOhVGY[6g]:VJRGefMgf5SI2?RH5jMWIjP8F7
QX=nNgUkOH21P7ejN7Z0RI:IVI:4LV5DD5AQLH6<THj7OWMdMWYoPX9nNGEdMgf6
SY:BSXR1O7YlOh:2OgYdKfiaMgn5QhEoN7AdO8RGY:ZXWXaiJ5iLHF]gPHN8QH9o
OWn1PX5mN7AaLWMmPhJ5P7UbL79jQI2GV9>9O7=^LGZ5TIRIU8Z0N7EgNh64Q81i
LVi_Lg^3RH^8PgehMWMkOX20OW]iNGf2QHEnL5a6<bPW<D=IKGb4Q7miMGEiP8N;
S8Z5P7emOh>5QXB0OG]mPh^CV9RCRWmgLgAjP8F6PGQ^IF5TJgIoQ8=kL6EMFf1Z
MX67R8AnN7EeN7aoP7mmNWUkOhB7R8AnMW1^LGR0QHEmKU]8>cLmBembPX^>RhF0
OWj1Ph>1O7McLgMnQXb?SHInMg=cMW^0Ph:0O7]nQHjGWYjHSH5gLgN2T9nY[:JK
SH1gM7IlPHB4P7]fM7EhOH21P7ikNgb0Q8F2NViQEe9FH6n0S9:@R7idKVicO8>7
QX1hL6][KgInPh>1O7MdMWZ1QXV8PgegM7AhOX:5Q89oOX67SiJHThIcGD/o?TMH
K7j:Shf7OgYhNWj1Q8>1OWenPHF9RhR2NgAaLGImQ8R8PgaeLWAlQi:JVYB8NVeV
IFYcO8:3P7]gMgb5T9^SYJ6IShN1Oh21PX1mNWMhNh24QXF0N79`M7n>Wjbb[Z6?
O6eUIFafPHN9QX5kN7QkOh>5Ph1mNgf1R8jAT8^4OGUiOXJ>TiBARX=mO7j3QXIo
M6EFC4Y@GW21SYBBRh9jMWIiOH61OWYfM7EiOX>5QH9nO7anPXF5P7IYGEIGHG8\>"]},
  ImageCacheContents->"Sound",
  CellTags->{"RiemannZeta", "G.3.6"}],

Cell[CellGroupData[{

Cell["Implementation", "SubsubsectionIcon",
  CellTags->{"RiemannZeta", "G.3.5"}],

Cell[BoxData[
    \(Play[RiemannSiegelZ[2000\ t], \ {t, \ 0, \ 3}, 
      PlayRange\  -> \ {\(-20\), 20}]\)], "Input",
  CellTags->{"RiemannZeta", "G.3.6"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ", "GroupDivider"],

Cell["Logistic Map", "Subsection",
  CellTags->{"LogisticMap", "G.3.7"}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.0238095 0.952381 0.0147151 0.588604 [

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

% Start of sampled sound

1 string

2000 8001 8

{ currentfile 1 index readhexstring pop }

 false 1 sampledsound

2F7FBD8BBA8FB892B694B595B597B497B398B399B299B29AB29AB19BB19BB19BB19CB19CB09C

B09CB09CB09DB09DB09DB09DB09DB09DB09DAF9DAF9DAF9DAF9DAF9EAF9EAF9EAF9EAF9EAF9E

AF9EAF9EAF9EAF9EAF9EAF9EAF9EAF9EAF9EAF9EB09EB09DB09DB09DB09DB09DB09DB09DB09D

B09DB09DB09DB09DB09DB09DB09DB09DB19DB19CB19CB19CB19CB19CB19CB19CB19CB19CB19C

B19CB29BB29BB29BB29BB29BB29BB29BB29BB29BB29BB29AB39AB39AB39AB39AB39AB39AB39A

B39AB39AB399B399B399B499B499B499B499B499B499B499B499B498B498B498B498B598B598

B598B598B598B598B598B598B597B597B597B597B597B597B597B697B697B697B697B697B697

B696B696B696B696B696B696B696B696B696B796B796B796B796B796B795B795B795B795B795

B795B795B795B795B795B795B795B795B895B895B895B894B894B894B894B894B894B894B894

B894B894B894B894B894B894B894B894B994B993B993B993B993B993B993B993B993B993B993

B993B993B993B993B993B993B993B992B992B992BA92BA92BA92BA92BA92BA92BA92BA92BA92

BA92BA92BA92BA92BA92BA92BA92BA91BA91BA91BA91BA91BA91BB91BB91BB91BB91BB91BB91

BB91BB91BB91BB91BB91BB91BB91BB91BB90BB90BB90BB90BB90BB90BB90BB90BB90BB90BC90

BC90BC90BC90BC90BC90BC90BC90BC90BC90BC8FBC8FBC8FBC8FBC8FBC8FBC8FBC8FBC8FBC8F

BC8FBC8FBC8FBC8FBC8FBD8FBD8FBD8FBD8FBD8FBD8FBD8FBD8EBD8EBD8EBD8EBD8EBD8EBD8E

BD8EBD8EBD8EBD8EBD8EBD8EBD8EBD8EBD8EBD8EBD8EBD8EBD8EBE8EBE8EBE8DBE8DBE8DBE8D

BE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8DBE8D

BE8DBE8CBE8CBF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8C

BF8CBF8CBF8CBF8CBF8CBF8CBF8CBF8BBF8BBF8BBF8BBF8BBF8BBF8BC08BC08BC08BC08BC08B

C08BC08BC08BC08BC08BC08BC08BC08BC08BC08BC08BC08BC08BC08AC08AC08AC08AC08AC08A

C08AC08AC08AC08AC08AC08AC08AC08AC18AC18AC18AC18AC18AC18AC18AC18AC18AC18AC18A

C18AC18AC189C189C189C189C189C189C189C189C189C189C189C189C189C189C189C189C189

C189C189C189C289C289C289C289C289C289C289C288C288C288C288C288C288C288C288C288

C288C288C288C288C288C288C288C288C288C288C288C288C288C288C288C288C288C288C288

C287C387C387C387C387C387C387C387C387C387C387C387C387C387C387C387C387C387C387

C387C387C387C387C387C387C387C387C387C387C387C386C386C386C386C386C386C386C386

C486C486C486C486C486C486C486C486C486C486C486C486C486C486C486C486C486C486C486

C486C486C486C485C485C485C485C485C485C485C485C485C485C485C485C485C485C485C485

C485C585C585C585C585C585C585C585C585C585C585C585C585C585C585C584C584C584C584

C584C584C584C584C584C584C584C584C584C584C584C584C584C584C584C584C584C584C584

C584C584C584C584C684C684C684C684C684C684C683C683C683C683C683C683C683C683C683

C683C683C683C683C683C683C683C683C683C683C683C683C683C683C683C683C683C683C683

C683C683C683C683C683C682C682C682C682C782C782C782C782C782C782C782C782C782C782

C782C782C782C782C782C782C782C782C782C782C782C782C782C782C782C782C782C782C782

C782C781C781C781C781C781C781C781C781C781C781C781C781C781C781C781C881C881C881

C881C881C881C881C881C881C881C881C881C881C881C881C881C881C881C881C881C881C880

C880C880C880C880C880C880C880C880C880C880C880C880C880C880C880C880C880C880C880

C880C880C880C880C880C880C880C980C980C980C980C980C980C980C980C980C97FC97FC97F

C97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97F

C97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97FC97EC97ECA7E

CA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7E

CA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7ECA7DCA7DCA7D

CA7DCA7DCA7DCA7DCA7DCA7DCA7DCA7DCA7DCA7DCA7DCA7DCA7DCA7DCB7DCB7DCB7DCB7DCB7D

CB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7DCB7C

CB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7C

CB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCB7CCC7CCC7CCC7CCC7CCC7CCC7CCC7CCC7C

CC7CCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7B

CC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7BCC7B

CC7BCC7BCC7BCC7BCC7BCC7ACC7ACC7ACC7ACC7ACC7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7A

CD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7A

CD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD7ACD79CD79CD79CD79CD79CD79CD79CD79CD79

CD79CD79CD79CD79CD79CD79CD79CD79CD79CD79CD79CD79CD79CD79CE79CE79CE79CE79CE79

CE79CE79CE79CE79CE79CE79CE79CE79CE79CE79CE79CE79CE79CE79CE79CE79CE78CE78CE78

CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78

CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78CE78

CE78CF78CF78CF78CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77

CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77

CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF77CF76CF76CF76CF76CF76CF76CF76

CF76CF76CF76CF76CF76CF76CF76CF76CF76CF76D076D076D076D076D076D076D076D076D076

D076D076D076D076D076D076D076D076D076D076D076D076D076D076D076D076D076D076D076

D076D076D076D075D075D075D075D075D075D075D075D075D075D075D075D075D075D075D075

D075D075D075D075D075D075D075D075D075D075D075D075D075D075D075D075D075D075D075

D075D075D175D175D175D175D175D175D175D175D175D175D175D175D174D174D174D174D174

D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174

D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174D174

D174D174D174D174D174D174D173D173D173D173D173D173D173D173D173D173D173D273D273

D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273

D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273D273

D273D272D272D272D272D272D272D272D272D272D272D272D272D272D272D272D272D272D272

D272D272D272D272D272D272D272D272D272D272D272D272D272D272D272D272D272D372D372

D372D372D372D372D372D372D372D372D372D372D372D372D372D372D372D371D371D371D371

D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371

D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371D371

D371D371D371D371D371D371D371D371D371D371D371D371D370D370D370D370D370D370D370

D370D470D470D470D470D470D470D470D470D470D470D470D470D470D470D470D470D470D470

D470D470D470D470D470D470D470D470D470D470D470D470D470D470D470D470D470D470D470

D470D470D470D470D470D470D470D470D470D46FD46FD46FD46FD46FD46FD46FD46FD46FD46F

D46FD46FD46FD46FD46FD46FD46FD46FD46FD46FD46FD46FD46FD46FD46FD46FD46FD46FD46F

D46FD46FD46FD46FD46FD46FD46FD46FD56FD56FD56FD56FD56FD56FD56FD56FD56FD56FD56F

D56FD56FD56FD56FD56FD56FD56FD56FD56FD56ED56ED56ED56ED56ED56ED56ED56ED56ED56E

D56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56E

D56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56ED56E

D56ED56ED56ED56ED56ED56ED56ED56ED56ED56DD56DD56DD56DD56DD56DD56DD56DD56DD66D

D66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66D

D66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66D

D66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66DD66CD66CD66CD66CD66CD66CD66CD66C

D66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66C

D66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD66CD76CD76CD76CD76CD76C

D76CD76CD76CD76CD76CD76CD76CD76CD76CD76CD76CD76CD76CD76CD76CD76BD76BD76BD76B

D76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76B

D76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76B

D76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76BD76B

D76BD76AD76AD76AD76AD76AD76AD76AD76AD76AD76AD76AD76AD76AD76AD86AD86AD86AD86A

D86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86A

D86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86AD86A

D86AD86AD86AD86AD86AD86AD86AD869D869D869D869D869D869D869D869D869D869D869D869

D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869

D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869D869

D869D969D969D969D969D969D969D969D969D969D969D969D969D969D969D968D968D968D968

D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968

D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968

D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968D968

D968D968D968D968D968D967D967D967D967D967D967D967D967D967D967D967D967D967D967

D967D967D967D967D967D967D967D967D967D967D967DA67DA67DA67DA67DA67DA67DA67DA67

DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67

DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA67DA66DA67DA66DA67

DA66DA67DA66DA67DA66DA67DA66DA67DA66DA67DA65DA67DB65D968DB64D969DC63D86BDC60

D76FDE5DD574DF5AD279DF59D17CDF59D17CDF59D17CDF59D17CDF59D17CDF59D17CDF59D17C

DF59D17CDF59D17CDF58D17CDF58D17CE058D17CE058D17CE058D17DE058D17DE058D17DE058

D17DE058D17DE058D17DE058D17DE058D17DE058D17DE058D17DE058D17DE058D17DE058D17D

E057D17DE057D17EE057D17EE057D17EE057D17EE057D07EE057D07EE057D07EE057D07EE057

D07EE057D07EE057D07EE057D07EE057D07EE057D07EE057D07EE057D07FE056D07FE056D07F

E056D07FE056D07FE056D07FE156D07FE156D07FE156D07FE156D07FE156D07FE156D07FE156

D07FE156D07FE156D07FE156D07FE156D080E156D080E156D080E156D080E155D080E155D080

E155D080E155D080E155D080E155D080E155D080E155D080E155D080E155D080E155D080E155

D080E155D080E155D081E155D081E155D081E155D081E155D081E155D081E155D081E154D081

E154D081E154D081E154CF81E154CF81E154CF81E154CF81E154CF81E254CF81E254CF81E254

CF82E254CF82E254CF82E254CF82E254CF82E254CF82E254CF82E254CF82E254CF82E254CF82

E254CF82E253CF82E253CF82E253CF82E253CF82E253CF82E253CF82E253CF82E253CF83E253

CF83E253CF83E253CF83E253CF83E253CF83E253CF83E253CF83E253CF83E253CF83E253CF83

E253CF83E253CF83E253CF83E253CF83E253CF83E252CF83E252CF83E252CF83E252CF84E252

CF84E252CF84E252CF84E252CF84E252CF84E252CF84E252CF84E252CF84E352CF84E352CF84

E352CF84E352CF84E352CF84E352CF84E352CF84E352CF84E352CF84E351CE85E352CF84E351

CE85E252CF83E350CD88E254D17EE44ECA8EDF5CD96CE254D17FE44ECB8DDF5BD86FE351CE86

E352CF83E350CD89E255D27CE54CC991DE60DB65DF5CD96DE253D081E44ECB8DE059D672E44E

CB8DE059D673E44DCB8EE05AD770E44FCD89E254D27DE54CC992DD61DD62DD61DD62DE5FDC65

DF5BD96CE352D083E44ECB8DE058D673E54CCA90DF5CDA6AE254D27EE54BC894DC64DF5CDA6A

E254D27DE54AC795DC65E05AD86EE44FCD88E352D082E54CCA90DF5BD96CE351CF84E44DCB8D

E158D673E54BC894DD62DE5FDC65E05AD86EE44ECC8AE253D27EE649C697DB68E254D37BE649

C599D96DE44FCD88E350CF85E54DCB8DE156D576E648C699D96CE44FCE88E44FCE87E44ECD8A

E351D082E64AC894DD62DF5DDC66E157D673E649C698DA69E352D180E648C699DA6BE450CF85

E54BCA91E05AD96BE44FCE88E44ECD89E44FCE86E54DCB8EE255D577E747C39ED676E747C49D

D674E747C59CD870E649C796DD64E159D86FE64AC993DF5DDC64E158D870E649C797DC65E256

D674E746C49ED675E746C39FD578E745C2A2D27EE745C2A0D37BE845C1A3D181E746C49ED675

E745C2A1D37BE844C1A4D083E747C59BD96DE64AC993E05CDC67E352D37DE844C1A4D084E748

C699DB68E450D083E746C49DD771E746C49ED774E844C2A3D27FE844C1A4D182E746C39FD577

E843BFA7CD8AE54DCE89E54CCC8DE351D27FE843C0A6CE88E64ACA91E157D86FE746C49DD871

E845C3A0D579E942BEAAC993E05BDC66E451D280E843C0A7CE89E64BCB90E255D774E842BFA7

CD8BE54DCE88E649C994E05BDC65E352D37DE941BDACC799DC66E451D27EE941BDABC896DE60

E05BDD64E352D47AE940BBAFC3A0D676E940BCAEC59DD96EE845C49FD774E941BDACC897DE60

E15ADC67E54DCF88E747C69BDB69E64ACB90E353D578EA3FBAB1C0A7CE88E747C799DD65E450

D27FEA3FBBB0C2A4D27FEA3FBBB0C2A3D37DEA3EBAB2BFAACB91E353D578EA3EB9B4BBB0C3A1

D579EA3DB8B5BAB1C0A7CF88E845C49ED870E941BEACC996E05CDE61E255D871E940BDADC799

DD63E452D57AEB3CB7B8B6B9B4BCAEC59DDA6CE844C3A2D579EB3CB6B9B4BCAFC4A0D775EB3D

B8B6B9B4BCAFC4A0D873EA3DB9B4BCAFC59ED96EE941BFA9CC8EE64BCD8CE749CA93E256D96E

E940BEACC897E05DE05DE05CDF5EE05BDE61E354D871EA3DB9B4BDAEC79ADD64E54ED183EA3D

B9B5BCB0C3A2D677EC3AB3BEACCA94E256DA6DEA40BEADC897E05BDF5FE257DB69E845C69DDB

69E844C59FD970EB3DB9B5BBB1C3A3D47BEC38B1C2A5D37FEC39B3C0A9CE8BE844C59FDA6EEA

3EBBB1C2A5D37FEC39B2C1A6D183EB3BB6BAB4BEACCA93E452D677EC38B0C4A1D873EC39B2C0

A8CF88EA3FBDAFC69DDC68E845C69DDB6AE942C1A7D184EB3BB6BAB3BFAACD8EE748CB92E450

D47CED36AEC899E05EE257DD66E846C898E05CE05CE15BE05DE159DE61E550D47CED35ACCA94

E353D872EC38B1C4A2D775ED36ADC997E258DD65E747CA95E354DA6FEC3AB5BDAFC79CDE63E6

4ACE8BE941C1A7D185EC39B4BFABCC8FE747CA94E452D775ED35ABCC90E74ACD8DE943C4A1D8

73ED35ADCA95E353D96FEC38B1C3A4D678EE33A8D086EC3AB5BEAEC998E258DF61E64DD282ED

35ADCA95E452D971ED35ADCA95E451D775EE33A9D087EC3AB5BDAFC79BDF60E54FD57CEE32A6

D47EEE32A7D283ED35ACCC92E74ACF8BEB3DBCB2C2A6D47DEE31A5D47DEF31A5D57BEF31A4D6

79EF30A4D678EF30A4D678EF30A4D777EF30A4D677EF30A3D776EF30A4D678EF30A3D874EF31

A5D57CEF30A2D873EE32A6D47FEF30A3D776EF30A2D873EF31A5D57BEF2FA1DA6EED35AEC997

E354DC6AEC3AB6BDB1C5A2D970EE32A8D185EE33AACF8AEC3AB7BCB3C3A6D57CF02E9FDC68EB

3BB9B8BAB6BDB1C5A0DB6BED37B2C4A3D875F02EA0DC6AEC38B4C0AACF8AEC38B4C1AAD088ED

35AECA97E452DA6FEE32A8D283EF30A3D874F02E9FDD67EB3DBCB3C2A7D380F02D9EDE65EA3F

C0ABCF8BEC39B6BDB0C79DDF61E846CB94E749CF8CEC3AB7BCB3C3A5D679F12B99E355DE65EA

3FC0ACCD8FEA3FC1AAD089ED36AFC999E356DF61E845CA97E54FD776F12A98E453DB6CEE33AA

D088EE33ABCF8BED37B3C3A6D67AF12996E64CD381F12B9AE357E05EE64CD381F12B9AE356DF

62E943C79EDF60E846CB94E748CF8BED36B1C79EDF62E942C6A0DE66EC3BB9B9B9B9BAB7BCB3

C3A6D67AF22792EA42C6A0DD68ED36B1C79EDF61E942C69FDE64EB3DBEB0C99AE356DF60E944

CA98E54FD973F12895E847CE8FEC3AB9B9B9B9BAB9BAB8BCB5C0ACCF8CEE35AFCA98E550D973

F22894E945CA97E64CD57DF2268EED38B6BFAECC93E943C89CE259E357E15CE64ED777F2258D

EE35B0CA99E54FD972F22792EA40C3A8D57DF3248BEE33ABD188F02EA1DD68EF32AAD284F129

96E847CF8DEE35B0CA98E64CD57DF3248AF02FA3DB6EF12A99E54FDA71F22691EC3BBCB6C1AC

CF8CEF32A9D481F3258DEE33ADCF8EEE35B0CA97E74AD383F22690EC3AB9BBB7BFB0CB97E749

D286F22895E944CA98E74AD382F3248CEF31A8D67CF42184F2258EEE34AFCB96E945CC94EA41

C6A1DE66EE33ACD08BF02EA2DD69F02DA0DF62EC3CBEB3C6A2DD67EF30A7D77AF41F80F42184

F3248CEF30A6D876F42081F42185F3258DEF31A9D57EF41F80F42183F32288F22894EA40C5A4

DB6DF22690EE35B2C89EE25BE74AD57FF41F80F41F80F41F80F41F80F41F80F41F7FF41F7EF5

1E7DF51D7BF51D7AF51D7AF51D79F51D79F51D79F51D79F51D79F51C79F51C78F51C78F51C78

F51C78F51C78F51C78F51C78F51C77F51C77F51C77F51C77F51C77F51C77F51C77F51C77F51C

76F51C76F51B76F51B76F51B76F51B76F51B76F51B76F51B76F51B75F51B75F51B75F51B75F5

1B75F51B75F51B75F61B75F61B75F61B75F61B75F61B74F61B74F61B74F61B74F61B74F61B74

F61B74F61A74F61A74F61A74F61A74F61A74F61A73F61A73F61A73F61A73F61A73F61A73F61A

73F61A73F61A73F61A73F61A73F61A73F61A73F61A72F61A72F61A72F61A72F61A72F61A72F6

1A72F61A73F61970F61B75F7176BF42186F51E7CF71669F3258FF02DA2E060EE37B6C3AAD67D

F71667F22793EE36B4C6A4DD6AF3238AF42288F42082F6186EF51C78F71565F12C9FE358E74D

DB70F61970F61971F6186EF51C78F71462F030A9D878F71462F030A9D779F81461EF33B0CE93

EF33AFD08DF22794EE36B6C4A9D879F8135FED37B8C0B2CB99EA43CD95ED37B8BFB2CA9AE947

D287F61B77F8135EED39BBBBBABDB7C1AED08CF3238AF41F82F71565F22897EC3BC0B2CB99EB

40C99FE553E25BEA41CA9BE946D287F61A74F8125DED3ABDB7C3ABD580F8125CEC3DC2ADD385

F7176BF51C79F91056E650DF65F22795EE34B3C99EE64EDD69F51D7CF90F55E552E25BEB40C8

A1E359E945D08DF42288F61A73F8115AEA43CD94EF32ADD387F7176BF61A74F91056E64FDE67

F42085F71565F32590F22797ED38BABEB7C4ABD77CF90D4EDE69F51C78FA0D4DDC6DF71668F5

1D7DFA0D4DDC6DF71566F42186F71565F3248EF42188F7176BF7176CF7166AF61870F8115AEB

40CA9DE848D67FFA0D4CDC6FF8115CED3ABFB5C8A1E457E947D484F91057E849D879FA0A45D2

89F7176DF81361F12A9EE74CDC6FF91058EA45D18BF61A74FA0C49D87AFB0942CD97EE35B4C8

A0E554E552E359EA42CD97EF34B3CA9CEA44D18CF61B77FB0940CB9BEA42CE94F02DA6DF66F5

1E7FFB0942CD96F030ACD680FB0942CD95F02FA9DB72FA0A45D387F91058EA42CE94F22A9EE8

49D978FB073ABFB5C7A4E25DEF32AFD28AF71566F51C7BFB0637BBBEB7C5AADA75FB073BC1B1

CF92F32592F32593F22898EE36B9C2B0D18BF71669F71567F61971FB0941CC99EE36B9C1B1CF

92F3238EF61B78FC0431AFD387FA0D4EE063F51F83FB0840CA9DEA44D28AF8125DF031AED485

FB0943D090F51E82FB0638BDBBBFB7C6A7DE68F81361F4238EF71870FB083EC7A5E25FF22A9F

E849DA74FC032EA9DC6FFB0940CC99EE36B9C1B2CE94F32594F32696F12CA4E25DF02EA8DD6C

FA0C4BDD6CFA0B47D77CFD012593F4228CF81362F42087FB0942D090F61C7BFD00218AF90E53

E650E35BEF33B2CE94F32593F42188FA0B48D87BFD001E82FC022AA0E84BDE6BFA0B4ADC71FC

032DA6E063F61B7AFE001B79FE001B78FE001B78FE001A77FE001B7AFE001973FD00238EF814

64F61972FD002491F61B79FE00176CFB073BC4ACD979FE001568F90E53E84CDF66F8125FF325

93F52086FC0430AED77FFE001870FD012696F2289BEE38BEBAC2B1D28BFA0C4CE066F8125FF4

238FF81465F81362F61B79FE000D50E556EB40CD99F02FACDA76FE000E54E946D77DFF000D4F

E35BF12DA8DF67F90E51E650E555EA43D389FB0638BFB7C7A7E163F7176EFD002492F61A76FF

000941CF94F52086FD012595F42189FC0536BBC0B6CAA1E948DA75FF00073CC7A7E160F61B7B

FF00002492F61974FF00073BC4ADD97AFF00001C7DFF0000218BFB073AC4AED77FFF00032EAB

DB72FF000942D28CFB083FCD99F12DA8E064F90F57EE38C0B7C9A3E74FE457EE37BDBEBCBFB8

C7A8E066FA0C4BDF67FB0941D190F9115CF3279BF0

pop

% End of sampled sound

% End of Graphics

MathPictureEnd


\
\>"], "Sound",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oo`008@0000000`00
Oomoo`3oOolMOol100000003001oogoo0?]oob00005oo`40000000<007ooOol0iWoo00<007oo0000
6P0000Eoo`00Ool007oo00<0009oo`L00004Ool000000004Ool100000003001oogoo0<eoo`03001o
o`0000P00007Ool00000001oo`00Ool02`002Goo1@0000Eoo`00Ool007oo00<0009oo`H00003Ool0
07oo00800003Ool007oo009oo`03001oo`0000Aoo`80005oo`40000000<007ooOol0/Woo7`000Woo
400000=oo`0000000P0000=oo`00Ool02Goo00<007ooOol0200000=oo`000000100000Ioo`000000
07oo0006Ool01`00Ool00000Ool007oo0080005oo`40000000<007ooOol0Tgoo800000=oo`000000
2P000Woo0`000Woo00<007oo00001`000goo00@007oo001oo`D00003Ool007oo00800004Ool007oo
0004Ool00`00Oomoo`08Ool01P00Oomoogoo001oo`<0009oo`@00003Ool007oo00Aoo`03001oogoo
00800004Ool007ooOol20003Ool00`00Oomoo`0100000003001oogoo08Qoo``0015oo`P00004Ool0
0000Ool200000goo00000002Ool6000017oo001oogoo10000Woo10000Woo0P0017oo2`000Woo0P00
17oo00@007ooOol000Uoo`03001oogoo00=oo`D000Eoo`03001oo`00009oo`@00006Ool00000Ool0
07oo0`0000=oo`00Ool00P000Goo0@0000000`00Oomoo`1=Ooll0005Ool2000EOolD00001Goo0000
0000Ool02`0000=oo`000000100000=oo`0000001@0000Moo`00000007oo001oo`0300001Woo001o
ogoo001oo`8000]oo`<000Ioo`D0009oo`<000=oo`D00005Ool007ooOol00002Ool20003Ool10000
0003001oogoo02QoobH0045oob80009oo`P00004Ool000000004Ool00`00Ool0000500000goo001o
o`0?0002Ool200000goo0000000400000goo00000009Ool00`00Oomoo`070002Ool400001Woo0000
0000Ool000Qoo`800004Ool007ooOol20002Ool100000003001oo`0000mooaX007aoo`h00003Ool0
000000L00003Ool00000009oo`<0009oo`03001oo`0000L000=oo`04001oo`00Ool300000goo001o
o`0400000goo00000002000@Ool500001Goo001oogoo00000Woo0`0000=oo`0000001P001Goo00<0
07oo00000Woo0P000Goo0@0000001@00Ool00000Ool03P00X7oo4`0000=oo`0000000`0000=oo`00
Ool00P000Woo00@007ooOomoo`H00003Ool0000000<0009oo`04001oo`00Ool200000goo001oo`09
Ool01@00Oomoo`00Ool0100000Moo`00Oomoo`00Ool00002Ool20002Ool20005Ool01000Oomoogoo
1P000Goo0@0000000`00Oomoo`03002fOol@0002Ool00`00Oomoo`030003Ool2000017oo00000000
0goo10000goo0P0000=oo`00Ool03Woo10000goo00@007ooOol000Aoo`<00004Ool007oo0005Ool2
00000goo000000040001Ool100000003001oo`0000L00;9ooaP000=oo`H00003Ool0000000D00003
Ool0000000<00003Ool007oo00Uoo`03001oogoo00D0009oo`06001oogoo001oo`000Woo0`0000Eo
o`00Ool007oo00d0005oo`40000000<007oo00001Woo4`00VGoo2@0000=oo`0000000`0000=oo`00
Ool01`0000=oo`0000003P0000=oo`00Ool00P0000Eoo`00Ool007oo00@000Yoo`05001oo`00001o
o`0300000goo00000005Ool800000goo0000000:0003Ool100000003001oo`0001Qooad007=oo`03
001oo`0000d00003Ool0000000<00003Ool0000000/00004Ool000000002Ool=0002Ool30003Ool0
1000Ool000002Goo0P000Woo3`0000=oo`0000001P0000=oo`00Ool01@0000Aoo`00001oo`400000
00<007oo0000=7oo;`00;7oo8`000Woo00<007oo00000`000Woo00<007oo00000goo00@007oo001o
o`/000=oo`04001oo`00Ool?00000goo0000000G00000goo0000000G0001Ool100000003001oogoo
069oocL000aooad00003Ool0000001<00003Ool0000000<00003Ool0000000/000Moob400003Ool0
000000@0005oo`40000000<007ooOol0V7oo>@0000=oo`000000A`000Goo0@0000000`00Oomoo`3o
Ool:Ool4000017oo000007oo1@0000=oo`00Ool00P000Goo0@0000000`00Oomoo`3oOolMOol10000
0?l00240000000<007ooOol0ogoo7Goo0@0000000`00Oomoo`3oOol>Ool=0002Ool100000003001o
ogoo0?moo`aoo`05001oogooOol00008Ool01000Oomoogoo0@0000000`00Oomoo`3oOol:Ool00`00
Oomoo`06Ool00`00Oomoo`07Ool100000003001oogoo0?moo`Moo`05001oogooOol0000:Ool20005
Ool100000003001oogoo0?moo`Moo`800004Ool007oo0005Ool00`00Oomoo`03Ool30002Ool10000
0003001oogoo0?moo`Aoo`<0009oo`06001oo`00001oo`0027oo00<007ooOol00P000Goo0@000000
0`00Oomoo`3oOol2Ool01@00Oomoogoo00001Woo00@007oo000000aoo`40000000<007ooOol0oWoo
0`0000=oo`00Ool01Goo00@007ooOol000Ioo`8000Eoo`40005oo`40000000<007ooOol0ogoo3goo
00@007ooOol0009oo`8000Ioo`40000000<007ooOol0ngoo0`000goo0P000Woo00<007ooOol04Goo
00<007ooOol00@0000000`00Oomoo`3jOol01000Oomoo`000Woo0P001goo00<007ooOol01Woo0P00
1Woo0@000Goo0@0000000`00Oomoo`3gOol20009Ool00`00Oomoo`05Ool01000Oomoo`001Goo00<0
07ooOol01Woo0@0000000`00Oomoo`3eOol20002Ool00`00Oomoo`02Ool20006Ool00`00Ool00007
Ool200000goo001oo`07Ool100000003001oogoo0?=oo`8000Ioo`04001oo`00Ool200000goo001o
o`04Ool00`00Oomoo`06Ool01@00Oomoogoo00001Woo0@0000000`00Oomoo`3eOol20009Ool00`00
Oomoo`07Ool00`00Oomoo`05Ool00`00Oomoo`07Ool100000003001oogoo0?1oo`@00003Ool00000
00=oo`04001oo`000004Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`03Ool20004Ool1
00000003001oogoo0>aoo`D0009oo`06001oo`00001oo`000Woo00@007ooOol000Eoo`05001oo`00
Ool00004Ool00`00Ool0000200000goo001oo`02Ool20003Ool100000003001oogoo0>]oo`03001o
ogoo00ioo`04001oogoo000LOol100000003001oogoo0>Qoo`@000Moo`03001oogoo00=oo`03001o
ogoo00Qoo`03001oogoo009oo`8000=oo`03001oogoo00]oo`40000000<007ooOol0iWoo00@007oo
000000Uoo`03001oo`0000Moo`03001oo`0000eoo`8000=oo`07001oogooOol007oo00000goo0@00
00000`00Oomoo`3YOol00`00Oomoo`09Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`0<
Ool100000003001oogoo0>9oo`80009oo`03001oo`0000]oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo00Ioo`03001oo`0000Eoo`800006Ool007oo001oo`0017oo0@0000000`00Oomoo`3P
Ool20002Ool300000goo00000009Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`02Ool3
0003Ool01@00Oomoogoo00001Goo0@0000000`00Oomoo`3MOol00`00Ool000020003Ool01@00Oomo
ogoo00002Woo00P007ooOol007oo001oo`000Woo00<007ooOol01Woo00<007ooOol027oo00<007oo
Ool01Goo0@000Goo0@0000000`00Oomoo`3KOol00`00Oomoo`04Ool00`00Oomoo`0gOol100000003
001oogoo0=Uoo`@000Ioo`03001oogoo01aoo`04001oogoo0005Ool01@00Oomoogoo000037oo0@00
00000`00Oomoo`3GOol00`00Oomoo`0=Ool00`00Oomoo`0:Ool2000>Ool00`00Oomoo`05Ool01000
Oomoo`0017oo00<007ooOol00Woo00<007ooOol00@0000000`00Oomoo`3EOol3000:Ool00`00Oomo
o`02Ool00`00Oomoo`0QOol2000;Ool01000Oomoogoo0@0000000`00Ool0003AOol30003Ool00`00
Oomoo`09Ool01000Oomoogoo0P003Goo00<007ooOol02goo0P0037oo00<007oo00001goo0@000000
0`00Oomoo`3?Ool60002Ool00`00Oomoo`08Ool01`00Ool007oo001oo`0001Aoo`03001oogoo00Io
o`04001oogoo000BOol100000003001oogoo0<ioo`8000Aoo`03001oogoo00=oo`03001oogoo00Eo
o`03001oo`00009oo`03001oogoo00eoo`03001oogoo01Aoo`03001oogoo00]oo`40000000<007oo
Ool0bWoo00<007oo000010000Woo00@007ooOol000Qoo`04001oo`00Ool200001Goo001oogoo0000
4Goo00<007ooOol01Goo00<007ooOol05Woo0@0000000`00Oomoo`39Ool00`00Ool00009Ool01P00
Oomoogoo001oo`800003Ool007oo01Aoo`03001oogoo008000eoo`<0009oo`03001oogoo00Qoo`06
001oogooOol007oo0@0000000`00Oomoo`35Ool00`00Ool00002Ool01000Oomoo`0027oo00<007oo
Ool01goo00<007ooOol06goo00<007ooOol02Goo00<007ooOol01Goo00@007ooOol000=oo`03001o
ogoo0040000000<007ooOol0a7oo00@007oo000000=oo`800003Ool0000000Aoo`05001oogooOol0
0006Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Ool00006Ool00`00Oomoo`02Ool00`00Oomo
o`0?Ool01000Oomoogoo0@0000000`00Oomoo`30Ool00`00Oomoo`04Ool2000<Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool01000Oomoo`004Goo00<007ooOol02goo00<007ooOol01goo00<007ooOol0
0goo00<007ooOol00Woo0@0000000`00Oomoo`2nOol02000Oomoo`00Ool007oo000:Ool00`00Oomo
o`04Ool00`00Oomoo`04Ool00`00Oomoo`0JOol00`00Oomoo`0NOol100000003001oogoo0;aoo`<0
00Moo`03001oo`0000moo`80035oo`03001oogoo00]oo`03001oogoo0040000000<007ooOol0^Goo
0`000goo00H007oo000007oo0007Ool00`00Oomoo`0COol01@00Oomoogoo00000Woo00<007ooOol0
3Goo0P0000=oo`00Ool00Woo00D007ooOomoo`0000=oo`800003Ool007oo00Moo`03001oo`0000=o
o`40005oo`40000000<007ooOol0^7oo0P003Woo00<007ooOol04Woo0P0097oo0`001goo00<007oo
Ool02Goo00<007ooOol00@0000000`00Oomoo`2cOol60007Ool00`00Oomoo`02Ool20006Ool00`00
Oomoo`0<Ool00`00Ool00002Ool01@00Oomoogoo00004Woo00<007ooOol00Woo00<007ooOol00goo
00<007ooOol00goo0P002Woo00<007ooOol017oo0@0000000`00Oomoo`2bOol2000017oo00000000
0goo00@007ooOol000Ioo`03001oogoo008000ioo`05001oo`00Ool00003Ool00`00Oomoo`03Ool0
0`00Oomoo`0AOol00`00Ool00004Ool20002Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool100000003
001oogoo0;1oo`80009oo`03001oogoo00Eoo`03001oogoo00aoo`80019oo`05001oogooOol0000D
Ool00`00Oomoo`06Ool00`00Oomoo`09Ool00`00Oomoo`0<Ool100000003001oogoo0:aoo`800003
Ool007oo0080009oo`05001oogooOol00008Ool00`00Oomoo`04Ool00`00Oomoo`0<Ool01@00Oomo
ogoo000027oo00<007ooOol067oo0`000goo00<007ooOol00Woo00@007ooOol000Qoo`03001oogoo
009oo`40000000<007ooOol0ZGoo0`000Woo0P0000Eoo`00Oomoo`00009oo`8000=oo`03001oogoo
00=oo`03001oogoo00Moo`80009oo`03001oogoo019oo`8000=oo`03001oogoo01moo`04001oogoo
000:Ool10001Ool100000003001oogoo0:Ioo`06001oo`00001oo`002Woo00<007ooOol08Woo00<0
07ooOol00Woo00@007ooOol001aoo`03001oo`0000ioo`03001oo`0000Qoo`40000000<007ooOol0
YGoo00H007oo001oo`00Ool400000goo001oo`04Ool01000Oomoo`000Woo00<007ooOol017oo00<0
07ooOol027oo00<007ooOol047oo00<007ooOol04Goo00<007ooOol017oo00@007oo000000Uoo`03
001oogoo011oo`40000000<007ooOol0YGoo0P0000Aoo`00Ool0009oo`@000Aoo`03001oogoo00Eo
o`03001oogoo00Uoo`8000Aoo`03001oogoo00Qoo`03001oogoo009oo`<00003Ool007oo01Ioo`03
001oo`00011oo`03001oogoo00=oo`8000=oo`03001oogoo0040000000<007ooOol0XGoo1P000Woo
0`000Woo0P0017oo00@007oo001oo`<000Aoo`03001oogoo00Eoo`03001oogoo009oo`04001oo`00
0006Ool00`00Oomoo`0SOol00`00Oomoo`04Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool100000003
001oogoo09ioo`@000Eoo`03001oogoo009oo`03001oogoo00eoo`03001oo`0000]oo`04001oogoo
000<Ool00`00Oomoo`0MOol00`00Oomoo`0AOol01000Oomoo`002Woo0@0000000`00Oomoo`2HOol7
0006Ool200001Woo00000000Ool000=oo`03001oogoo00Eoo`03001oogoo00Aoo`05001oogooOol0
0007Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`0POol00`00Oomoo`04Ool00`00Oomo
o`0>Ool20006Ool100000003001oogoo09=oo`H001Aoo`8000=oo`03001oogoo009oo`03001oogoo
00Qoo`03001oo`0000Aoo`03001oogoo00ioo`<00005Ool007ooOol0000IOol00`00Ool00003Ool0
0`00Oomoo`0@Ool00`00Oomoo`02Ool00`00Oomoo`0100000003001oogoo091oo`@001Eoo`03001o
o`0000Ioo`03001oogoo01Ioo`04001oogoo000VOol00`00Oomoo`0:Ool01000Oomoo`005Woo0@00
00000`00Oomoo`2?Ool2000FOol01P00Oomoo`00Ool0009oo`03001oo`0000Uoo`03001oogoo00ao
o`03001oogoo01Aoo`03001oogoo01Qoo`80009oo`04001oogoo000HOol100000003001oogoo0:Eo
o`L000Qoo`04001oogooOol30004Ool00`00Oomoo`030004Ool2000FOol00`00Oomoo`06Ool00`00
Oomoo`0=Ool00`00Ool00004Ool00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`03Ool10001
Ool100000003001oogoo08moo`03001oogoo01aoo`04001oogoo000@Ool00`00Oomoo`05Ool00`00
Oomoo`0]Ool00`00Oomoo`09Ool01000Oomoo`000Woo00<007ooOol03Goo0@0000000`00Oomoo`2X
Ool01@00Oomoogoo00005Woo0P0017oo00<007ooOol03goo00<007ooOol06Goo0P004Woo00<007oo
Ool017oo0P0027oo0@0000000`00Oomoo`2?Ool00`00Oomoo`0DOol00`00Ool0000AOol20003Ool0
1@00Oomoogoo00001Woo00@007ooOomoo`8000Qoo`07001oo`00Ool007oo00005Goo00<007oo0000
2goo00<007ooOol01Goo00<007ooOol02Woo00<007ooOol00Woo0@0000000`00Oomoo`2XOol01000
Oomoo`000Woo00<007ooOol0:goo00<007ooOol027oo00<007ooOol037oo00<007ooOol057oo00<0
07ooOol00goo00<007ooOol01Woo0@0000000`00Oomoo`2?Ool00`00Oomoo`0HOol00`00Oomoo`04
Ool00`00Oomoo`06Ool00`00Oomoo`02Ool01@00Oomoogoo00001goo00<007ooOol047oo00<007oo
Ool0:7oo00<007ooOol00goo0P0017oo00D007ooOomoo`00009oo`40000000<007ooOol0SGoo0P00
5goo00T007oo001oo`00Ool007oo00000goo00<007ooOol00goo0`000Woo00<007ooOol02Goo00<0
07oo000037oo0P000goo00<007ooOol01goo00<007ooOol02goo00L007ooOomoo`00Ool00002Ool2
0004Ool00`00Ool0000:Ool00`00Ool00006Ool10001Ool100000003001oogoo08Qoo`L002Eoo`03
001oogoo00Aoo`03001oogoo01Uoo`03001oogoo00eoo`03001oogoo00Yoo`03001oogoo00Ioo`03
001oogoo00Qoo`03001oogoo00Yoo`03001oogoo009oo`40005oo`40000000<007ooOol0Ogoo2P00
1Goo0P0077oo00@007ooOol000Eoo`03001oogoo00Aoo`03001oogoo00Ioo`04001oogoo000<Ool0
0`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool0
1000Ool0000027oo00<007oo00001Woo00<007ooOol027oo0@0000000`00Oomoo`1fOol:000?Ool0
0`00Oomoo`0GOol20004Ool00`00Oomoo`0FOol00`00Oomoo`09Ool3000LOol20006Ool00`00Ool0
0002Ool00`00Oomoo`0<Ool00`00Oomoo`0:Ool100000003001oogoo079oo`D002ioo`09001oogoo
Ool007oo001oo`00019oo`03001oogoo01Moo`03001oogoo02=oo`03001oogoo00Uoo`03001oogoo
009oo`03001oogoo00Qoo`40000000<007ooOol0JWoo2@00=7oo00D007ooOol007oo008000Ioo`03
001oogoo00Aoo`03001oogoo00=oo`800004Ool007oo000<Ool00`00Oomoo`0=Ool00`00Oomoo`03
Ool00`00Oomoo`09Ool20008Ool01000Oomoo`004Woo00<007ooOol017oo0@0000000`00Oomoo`1R
Ool9000TOol00`00Oomoo`0DOol00`00Ool00008Ool20004Ool00`00Oomoo`05Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool00`00Ool00006Ool01000Oomoo`006goo00<007oo00002Woo0`0027oo00<0
07ooOol017oo00<007ooOol01goo0@0000000`00Oomoo`1NOol5001BOol00`00Ool00007Ool01@00
Oomoogoo00002Woo00<007ooOol04Woo00<007ooOol047oo00<007ooOol03goo00<007ooOol017oo
00<007ooOol02Woo0@0000000`00Oomoo`1GOol80018Ool01@00Ool007oo00000Woo00<007ooOol0
47oo00<007ooOol00goo00@007ooOol0009oo`03001oogoo00=oo`03001oogoo00Uoo`<000moo`<0
00Uoo`03001oogoo00Eoo`03001oogoo00Qoo`03001oogoo00Eoo`04001oogooOol100000003001o
ogoo051oo`P003Moo`03001oogoo01moo`<00005Ool007ooOol00002Ool00`00Oomoo`03Ool00`00
Oomoo`07Ool20002Ool01000Oomoo`000goo0P005Woo100000=oo`00Ool01Goo00@007ooOol000Ao
o`03001oogoo009oo`05001oogooOol0000;Ool00`00Oomoo`02Ool100000003001oogoo04aoo`D0
05aoo`04001oogoo000:Ool00`00Oomoo`0DOol20006Ool00`00Oomoo`0;Ool00`00Oomoo`02Ool2
000UOol00`00Ool00005Ool100000003001oogoo04Ioo`L006=oo`03001oo`0000=oo`03001oogoo
00=oo`03001oo`0000Eoo`04001oogoo0005Ool01000Oomoogoo0P003Woo00<007ooOol027oo0P00
1goo0P0000=oo`00Ool017oo00<007ooOol00goo00D007oo001oo`0000Ioo`8000]oo`40000000<0
07ooOol0@7oo1`00B7oo00<007ooOol09Goo00@007ooOol000=oo`03001oo`00011oo`03001oogoo
00Eoo`05001oo`00Ool0000:Ool00`00Oomoo`020009Ool20003Ool00`00Oomoo`03Ool2000<Ool3
00000goo001oo`03Ool01000Oomoogoo0@0000000`00Oomoo`0jOol7001>Ool3000DOol00`00Oomo
o`03Ool00`00Oomoo`04Ool00`00Oomoo`0?Ool01000Oomoogoo0P0017oo00<007oo00000P0000=o
o`00Ool03goo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Woo00<007oo00001goo00<0
07ooOol017oo0P0027oo00<007ooOol00Woo0@0000000`00Oomoo`0gOol4001FOol3000DOol00`00
Ool00009Ool00`00Oomoo`02Ool01@00Oomoogoo00004Woo0P003Woo00@007oo000000Moo`03001o
ogoo00Ioo`03001oogoo00Qoo`03001oogoo019oo`05001oogooOol00003Ool100000003001oo`00
039oo`H005]oo`D000eoo`05001oogooOol00002Ool00`00Oomoo`04Ool01@00Ool007oo00000Woo
00@007ooOol000Qoo`03001oogoo00Moo`04001oogoo000EOol2000EOol01@00Oomoogoo00003Goo
00<007ooOol00goo00@007ooOomoo`40000000<007ooOol0;7oo1`00IGoo1@002Woo00<007ooOol0
1Goo00D007ooOomoo`0000Aoo`03001oogoo01aoo`05001oogooOol00008Ool01000Oomoogoo0`00
3goo00<007ooOol027oo00<007ooOol057oo0@0000000`00Oomoo`0ZOol3001_Ool4000;Ool01000
Oomoo`001goo00<007ooOol05Goo00<007ooOol05Goo00<007ooOol037oo00D007ooOomoo`00011o
o`05001oogooOol0000=Ool100000003001oogoo02Eoo`H007Aoo`P0009oo`03001oo`0000Qoo`80
00eoo`04001oogooOol20007Ool00`00Oomoo`04Ool00`00Oomoo`08Ool00`00Oomoo`0200000goo
0000000GOol00`00Oomoo`05Ool00`00Oomoo`0@Ool100000003001oogoo025oo`D007ioo`03001o
o`0000Ioo`04001oo`00000KOol00`00Ool00005Ool00`00Oomoo`0>Ool01000Oomoo`002Woo00<0
07ooOol01Goo00<007ooOol00P002Woo00<007ooOol01Goo00D007ooOomoo`0000Eoo`40000000<0
07ooOol07goo0`00S7oo00<007ooOol07Woo00<007ooOol09Woo00<007oo00000Woo00<007ooOol0
1Goo00D007ooOomoo`0000=oo`03001oogoo00aoo`40000000<007ooOol06goo1@00QGoo0P0000Ao
o`00Ool0009oo`800003Ool007oo00Aoo`@0009oo`03001oo`0000Uoo`03001oogoo00]oo`03001o
ogoo008000Moo`03001oogoo00Aoo`03001oogoo00Uoo`03001oogoo00Aoo`04001oogooOol2000<
Ool00`00Oomoo`04Ool20005Ool100000003001oo`0001Moo`D0091oo`03001oo`0000Moo`04001o
ogoo000<Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00D007oo001oo`00009oo`8000Eoo`80
00=oo`03001oogoo00]oo`05001oogooOol00008Ool01000Oomoogoo0P0000=oo`00Ool00Woo00<0
07ooOol00goo00<007ooOol00Woo00@007ooOomoo`40000000<007ooOol05Woo0P00ZWoo00<007oo
Ool04goo00<007ooOol017oo00<007ooOol00Woo00D007oo001oo`00011oo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Uoo`03001oogoo0040000000<007ooOol04Woo1000Sgoo00T007oo
001oo`00Ool007oo00000Woo00<007ooOol00goo00<007ooOol02Goo00<007ooOol017oo00D007oo
Oomoo`00019oo`800007Ool00000Ool007oo00003Woo00<007ooOol00Woo00@007ooOol000Qoo`03
001oo`0000Eoo`03001oogoo00Uoo`40000000<007oo00003goo1000UWoo00<007oo000037oo00D0
07ooOomoo`0000moo`8000]oo`03001oogoo00=oo`03001oogoo00=oo`05001oogooOol0000:Ool0
0`00Oomoo`07Ool00`00Oomoo`09Ool01000Oomoo`001Goo00<007ooOol017oo0@000Goo0@000000
0`00Oomoo`0>Ool2002FOol00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`0SOol00`00Oomoo`0ZOol00`00Oomoo`08Ool100000003001oo`0000]oo`@009Uoo`03001oogoo
00Ioo`04001oogoo0003Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Ool00006Ool00`00Oomo
o`0:Ool00`00Oomoo`02000BOol01000Oomoo`003goo0P0017oo0P000goo00@007ooOomoo`8000Ao
o`40000000<007oo00002Goo0`00WWoo0P000Woo00<007ooOol027oo00<007ooOol027oo00<007oo
Ool00goo1P0027oo00D007ooOomoo`00009oo`8000Aoo`80009oo`03001oogoo00]oo`80009oo`03
001oo`0000Ioo`8000Ioo`03001oo`0000Moo`03001oogoo00=oo`40000000<007ooOol027oo0P00
Ygoo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol06Goo00<007ooOol017oo00D007ooOomo
o`0001eoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Moo`40000000<007oo00001Woo
0`00Xgoo00@007ooOol0009oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oo`0000Aoo`03001o
o`00009oo`03001oogoo00=oo`03001oo`0000=oo`07001oogooOol007oo00000Woo0`004goo00<0
07ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0001Aoo`40000000<007oo00001Goo0P00YWoo
00<007oo00001Goo00D007ooOomoo`0000=oo`03001oo`0000=oo`03001oogoo00=oo`03001oogoo
00eoo`@00007Ool007ooOol007oo000057oo0P003Woo00@007ooOol000Qoo`03001oogoo009oo`03
001oogoo0040000000@007oo000000=oo`800:ioo`03001oogoo00Eoo`03001oogoo011oo`03001o
ogoo02Qoo`03001oogoo00Moo`03001oogoo00]oo`03001oogoo00Eoo`40005oo`40000000<007oo
Ool01@00[7oo00L007ooOomoo`00Ool00003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomo
o`000Woo00<007ooOol02Woo00<007ooOol01Woo00<007ooOol077oo00@007ooOol000Eoo`03001o
ogoo011oo`40000000@007ooOomoo`800:eoo`05001oo`00001oo`020004Ool01`00Oomoogoo001o
o`0000=oo`8000ioo`03001oo`0000Aoo`03001oo`0000]oo`03001oogoo00Qoo`07001oogooOol0
07oo00001Woo00@007ooOol000Eoo`03001oogoo00ioo`40000000<007ooOol0/goo00D007ooOomo
o`00009oo`05001oogooOol00002Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool0
1000Ool000001Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol04Woo00<007ooOol00Woo
00<007oo00002goo00<007ooOol017oo00<007ooOol00goo0@0000000`00Oomoo`2bOol00`00Oomo
o`0;Ool01@00Oomoogoo00001Goo00<007ooOol01Goo0`004Woo00<007ooOol02Woo00<007ooOol0
9Goo0@0000000`00Oomoo`2cOol40006Ool00`00Oomoo`05Ool00`00Oomoo`05Ool01000Oomoogoo
0`0000Aoo`00Ool000]oo`03001oogoo00=oo`03001oogoo00Qoo`03001oogoo00moo`03001oogoo
00=oo`03001oogoo00Yoo`03001oogoo0040000000<007ooOol0]goo00<007ooOol037oo0P0027oo
100000=oo`00Ool00Woo00D007oo001oo`0000Yoo`03001oogoo01Uoo`03001oogoo00Aoo`05001o
ogooOol0000<Ool100000003001oogoo0;Ioo`04001oo`000002Ool00`00Ool00009Ool01@00Oomo
ogoo00000goo00<007ooOol017oo00<007ooOol03Woo00<007ooOol07goo00<007ooOol027oo00<0
07oo000017oo0@0000000`00Oomoo`32Ool01000Oomoogoo0P001Woo0P0017oo00@007ooOol000Yo
o`05001oo`00Ool00002Ool00`00Oomoo`0:Ool2000=Ool00`00Oomoo`03Ool20008Ool01000Oomo
ogoo0P000Goo0@0000000`00Oomoo`2hOol00`00Ool00003Ool00`00Oomoo`08Ool01000Oomoo`00
1goo00@007oo001oo`@000Ioo`03001oogoo00moo`03001oogoo00=oo`05001oogooOol00008Ool0
0`00Oomoo`0>Ool01000Oomoogoo0@0000000`00Oomoo`2iOol00`00Ool00003Ool01P00Oomoo`00
Ool0009oo`04001oogoo0005Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01000
Oomoo`0077oo00<007ooOol02Woo00@007ooOol000Moo`40000000<007ooOol0^goo00@007ooOomo
o`80009oo`8000Aoo`04001oo`00Ool30004Ool00`00Ool00009Ool01@00Oomoogoo000057oo00D0
07oo001oo`0000]oo`03001oogoo00Ioo`03001oogoo00=oo`04001oogooOol100000003001oogoo
00@00;Ioo`03001oogoo00800003Ool00000009oo`03001oogoo0080009oo`05001oogooOol00008
Ool20004Ool01@00Ool00000Ool0100047oo00<007ooOol037oo0P0000=oo`00Ool04Goo0@000000
1000Ool000000Woo0P00]goo00<007oo00001Woo0P000goo00@007ooOol000Ioo`8000Ioo`03001o
o`0002Qoo`8000Yoo`03001oogoo00Ioo`40000000<007oo000017oo0`00]Woo00<007ooOol017oo
00<007oo00000P001goo00<007ooOol00Woo00T007oo001oo`00Ool007oo00002Goo00<007oo0000
3Goo0`0000=oo`00Ool01Woo00<007ooOol01Woo00<007oo00003Goo0@0000000`00Ool00006Ool2
002fOol02P00Ool00000Ool007oo001oo`000goo0P0000=oo`0000001Woo00<007ooOol01Woo00<0
07ooOol04Woo00<007ooOol02Woo00<007oo00000Woo00<007ooOol04goo0@0000000`00Ool00008
Ool2002fOol20005Ool2000;Ool20002Ool00`00Oomoo`05Ool01@00Oomoogoo00003goo00@007oo
Ool001ioo`03001oogoo00=oo`40000000<007oo00002Goo0`00/Woo00@007oo000001=oo`04001o
ogoo0004Ool00`00Ool00005Ool00`00Oomoo`0?Ool40003Ool00`00Oomoo`06Ool01000Oomoo`00
2Woo00@007ooOomoo`80005oo`40000000<007oo00002goo1000[Goo0`0000Qoo`00001oo`00Ool0
07oo0P0037oo00<007ooOol01Goo00<007oo00001Goo00<007ooOol047oo00<007ooOol00goo00<0
07ooOol01Woo0P000goo00<007ooOol017oo00<007ooOol01Woo0@0000000`00Oomoo`0>Ool3002Y
Ool00`00Oomoo`020006Ool2000NOol00`00Oomoo`0@Ool00`00Oomoo`0;Ool01@00Oomoogoo0000
2goo00<007ooOol00goo0@0000000`00Ool0000@Ool5002TOol30003Ool300000goo00000003Ool0
1000Oomoo`000goo0P000goo0P0000Aoo`00000000=oo`03001oo`0000Aoo`03001oogoo015oo`03
001oo`0000moo`03001oogoo00eoo`40005oo`40000000<007ooOol057oo1@00WGoo00@007oo0000
00=oo`03001oo`00009oo`03001oo`00009oo`8000=oo`03001oo`0000moo`03001oo`0000Aoo`03
001oo`00011oo`03001oogoo00=oo`04001oogoo0004Ool01@00Oomoogoo00001goo00@007ooOol0
00Aoo`40005oo`40000000<007ooOol067oo0`00W7oo0P000goo00<007oo00001goo0P003Woo00@0
07oo000000Eoo`03001oogoo01Eoo`03001oo`0001aoo`04001oogoo0002Ool100000003001oogoo
01Yoo`H0099oo`D000Ioo`03001oogoo00Eoo`800003Ool007oo009oo`05001oogooOol00005Ool2
00000goo001oo`09Ool00`00Oomoo`0BOol00`00Ool0000;Ool20003Ool00`00Oomoo`04Ool00`00
Oomoo`06Ool100000003001oogoo01moo`H008]oo`05001oo`00001oo`030002Ool20002Ool40002
Ool200001Goo001oogoo00000Woo00<007ooOol01Goo00T007ooOomoo`00Ool007oo000017oo00<0
07ooOol03goo00@007ooOol0009oo`05001oogooOol0000BOol00`00Oomoo`03Ool20003Ool10000
0003001oogoo02Aoo`@008Aoo`03001oogoo009oo`04001oogoo0006Ool00`00Oomoo`02Ool20003
Ool2000=Ool2000COol00`00Oomoo`0KOol00`00Oomoo`0BOol100000003001oogoo02Moo`L007ao
o`07001oo`00001oo`00Ool00P000Woo00D007ooOomoo`00009oo`04001oogoo0003Ool00`00Ool0
0002Ool01000Oomoo`000goo00<007ooOol01Woo00@007ooOomoo`<000Moo`8000aoo`03001oogoo
00moo`04001oogooOol20009Ool00`00Ool00002Ool10001Ool100000003001oogoo02eoo`P0075o
o`04001oo`00Ool20002Ool01000Oomoo`000Woo00@007ooOomoo`@000=oo`06001oogoo001oo`00
17oo00<007oo00000Woo00<007ooOol00goo00<007ooOol00goo00D007ooOomoo`00009oo`03001o
ogoo00Eoo`03001oogoo00eoo`04001oo`000004Ool00`00Ool0000EOol00`00Oomoo`0100000003
001oogoo03Aoo`T006Qoo`0:001oo`00Ool007oo001oo`00Ool20006Ool20003Ool00`00Ool00003
Ool00`00Ool00002Ool00`00Ool000060006Ool02P00Ool007oo001oo`00Ool007oo0P0000=oo`00
00000P004Goo0`001Goo00<007ooOol00P0017oo00<007ooOol02Woo00<007ooOol00goo0@000000
0`00Oomoo`0lOol5001[Ool00`00Oomoo`07Ool00`00Oomoo`09Ool00`00Oomoo`07Ool01@00Oomo
ogoo00003goo00<007ooOol00goo00<007ooOol07goo00@007ooOol0011oo`40000000<007ooOol0
@7oo2P00FWoo0`0000Aoo`00Ool0009oo`800003Ool007oo00Aoo`@0009oo`03001oogoo00=oo`05
001oogooOol00002Ool00`00Oomoo`02000;Ool00`00Oomoo`03Ool00`00Oomoo`0EOol20004Ool0
0`00Oomoo`03Ool30006Ool00`00Ool00005Ool00`00Oomoo`02Ool00`00Oomoo`0100000003001o
ogoo04Uoo`X0045ooa@00005Ool007oo001oo`030004Ool20006Ool00`00Ool00009Ool00`00Oomo
o`03Ool30003Ool01000Ool007oo1@000Woo00@007ooOomoo`80009oo`03001oogoo00eoo`03001o
o`00009oo`03001oogoo00Qoo`800005Ool007ooOol00008Ool00`00Oomoo`03Ool100000003001o
ogoo059oo`H003Moo`H0011oo`03001oogoo00Moo`05001oogooOol00002Ool00`00Oomoo`0:Ool0
1000Oomoogoo0P000goo00<007ooOol01Goo00<007ooOol02goo00<007ooOol07Goo0P000goo00<0
07ooOol047oo0@000Goo0@0000000`00Oomoo`1GOol<000/Ool00`00Oomoo`0DOol00`00Ool00002
00000goo001oo`05Ool300000goo000000020002Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00
Ool00006Ool01@00Oomoogoo00001Woo00<007ooOol00P004Goo00H007oo000007oo0003Ool01000
Oomoogoo0P000Woo00<007ooOol01goo00<007oo00000goo00<007ooOol00@0000000`00Oomoo`1R
Ool=000POol00`00Oomoo`0KOol01P00Oomoo`00Ool000=oo`80009oo`07001oo`00Ool007oo0000
17oo00@007ooOomoo`8000Aoo`D00003Ool007oo00Uoo`03001oo`00008000Aoo`8000moo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo011oo`40000000<007ooOol0KWoo2000<Goo00D007oo
001oo`00009oo`03001oo`0000<000Ioo`03001oogoo00Moo`04001oogoo0005Ool01000Oomoogoo
0P001Woo00D007oo001oo`0000Qoo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo009oo`03
001oogoo01Aoo`40000000<007ooOol0MGoo3`002goo00<007ooOol057oo00L007oo001oo`00Ool0
0004Ool20002Ool01000Ool000000Woo00T007ooOomoo`00Ool007oo00000goo00D007ooOol007oo
00800003Ool007oo00<0009oo`80009oo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00]o
o`8000Ioo`03001oogoo008000Yoo`8000=oo`03001oo`0000=oo`04001oogooOol100000003001o
ogoo08=oo`d001Eoo`04001oo`00Ool3000017oo001oo`0017oo00<007ooOol017oo00<007ooOol0
0Woo0`0000Aoo`00000000Aoo`04001oo`000004Ool20002Ool00`00Oomoo`05Ool300000goo001o
o`0QOol20003Ool00`00Oomoo`03Ool01000Oomoo`000Woo0P000goo0@0000000`00Oomoo`2>Ool0
0`00Oomoo`0EOol00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`06Ool0
1000Oomoo`0037oo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00goo00<007ooOol02Goo
00<007ooOol03Goo00<007ooOol047oo00@007ooOomoo`40000000<007ooOol0Sgoo00<007ooOol0
5Woo00<007oo00000P0000Aoo`00Oomoo`800003Ool007oo009oo`@00004Ool007oo0003Ool00`00
Oomoo`02Ool200000goo001oo`07Ool40005Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Oomoo`05Ool00`00Oomoo`0200000goo001oo`07Ool20002Ool00`00Oomoo`0:Ool1
00000003001oogoo08moo`<001=oo`800003Ool0000000<00005Ool007ooOol00008Ool20003Ool0
1000Oomoogoo0P001Goo0P000Woo0P0027oo0`0000Aoo`00000000Qoo`03001oogoo015oo`04001o
o`000005Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Ool00003Ool00`00Oomoo`02Ool10001
Ool100000003001oogoo095oo`H0011oo`06001oo`00001oo`000Woo00<007ooOol00Woo00@007oo
Oomoo`<000Aoo`03001oogoo00<000Aoo`80011oo`03001oogoo01Ioo`03001oogoo019oo`03001o
ogoo00=oo`05001oogooOol00005Ool20001Ool100000003001oogoo09IooaT00004Ool000000004
Ool20002Ool01@00Oomoogoo00000Woo00<007oo000017oo0`000Woo00<007ooOol047oo00<007oo
Ool01Woo00<007ooOol03Goo00<007oo00002Goo00<007ooOol00Woo0P0027oo00<007oo000017oo
0@0000000`00Oomoo`2SOol>0003Ool300001Goo00000000Ool010000goo00H007ooOomoo`00Ool7
0004Ool00`00Ool00002Ool400001Goo001oogoo00004goo00<007ooOol017oo00<007ooOol00Woo
00<007oo00002Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00@0000000`00Oomoo`2V
Ool00`00Ool0000300000goo001oo`020005Ool01P00Oomoo`00Ool000Moo`03001oogoo00Aoo`03
001oogoo009oo`03001oogoo00Qoo`06001oogooOol007oo0P0000=oo`00Ool057oo00@007ooOol0
00Ioo`03001oogoo00ioo`8000Ioo`40000000<007ooOol0[7oo3P000Woo00<007ooOol00goo00<0
07ooOol017oo00<007oo00000`0000=oo`00Ool01Woo00<007ooOol00P000goo0P0000Aoo`00Ool0
00Aoo`03001oogoo00Qoo`03001oogoo00=oo`03001oo`0000Aoo`03001oogoo00Uoo`03001oogoo
00Aoo`05001oogooOol00002Ool100000003001oogoo0;=oo`T0009oo`D0009oo`800003Ool00000
009oo`8000Yoo`06001oo`00Ool007oo1@000Woo0P004Goo00D007oo001oo`0000=oo`8000=oo`03
001oogoo00=oo`07001oogooOol007oo00000Woo00@007ooOol000Aoo`40000000<007ooOol0_7oo
0`000Woo00P007oo000007oo001oo`003goo0P000goo00<007ooOol00Woo00D007ooOomoo`00009o
o`03001oogoo00aoo`03001oo`00009oo`03001oogoo009oo`@000=oo`03001oogoo00Uoo`03001o
ogoo00Aoo`40000000<007ooOol0`7oo0P000Woo1@0000=oo`0000001@000goo1@0017oo0`0017oo
0P0000=oo`00Ool047oo00@007oo000000=oo`03001oogoo015oo`03001oogoo00Eoo`40000000<0
07ooOol0bGoo20000Woo1@0000=oo`0000000P0000=oo`0000001@0000Eoo`00001oo`0000Yoo`03
001oogoo00800003Ool00000009oo`06001oogoo001oo`000goo0P000Woo00<007ooOol017oo00<0
07ooOol017oo0P000Goo0@0000000`00Oomoo`3AOol30003Ool00`00Oomoo`08Ool01000Ool007oo
0`003Woo00<007ooOol00goo00<007ooOol00goo00@007ooOol000Moo`03001oogoo00]oo`400000
00<007ooOol0eGoo0`0000Aoo`00000000=oo`03001oogoo008000=oo`03001oogoo00Yoo`<000]o
o`04001oo`000003Ool01000Oomoo`001goo00<007ooOol00Woo0P000Goo0@0000000`00Oomoo`3M
Ool00`00Oomoo`0700000goo00000009Ool20002Ool01@00Ool007oo00000Woo0P001Goo00@007oo
0000009oo`800003Ool007oo009oo`03001oogoo00Eoo`40005oo`40000000<007ooOol0iWoo00<0
07oo00001`000goo00@007oo0000009oo`03001oo`0000@000Aoo`03001oo`00009oo`80009oo`80
00=oo`80009oo`03001oogoo00=oo`40000000<007ooOol0kgoo1@0000Qoo`00001oo`00Ool007oo
0P000Woo00D007oo001oo`0000=oo`03001oogoo009oo`03001oo`0000800004Ool007ooOol20004
Ool100000003001oogoo0?=oo`T00003Ool0000000@000=oo`03001oo`000080009oo`03001oogoo
00800004Ool007oo0006Ool100000003001oogoo0?]oo`P0009oo`05001oogooOol00002Ool02P00
Ool00000Ool007oo001oo`000goo0P000Goo0@0000000`00Oomoo`3oOol4Ool900000goo001oo`02
Ool01@00Oomoogoo00000Woo0`000Goo0@0000000`00Oomoo`3oOol9Ool01@00Oomoo`00Ool01000
00Aoo`00Oomoo`8000Eoo`40000000<007ooOol0ogoo47oo1P0000Aoo`00000000=oo`40000000<0
07ooOol0ogoo7Goo0@00003o000Q00000001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250053, 
  0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["WindowsSound", "\<\
DTU6AVDO001G@EI5IVed810000010040d0L00=07000100P0I65dHD4O000_Okf;
^XnhT[JD]IFeUkBG/iRcVK:I/YZbV[6K/I^aVk6L/Ib`W;2L/9b`WK2M/9f`WK2M
/9f`WJnM[if_WJnM[ij_WZnN[ij_WZnN[ij_WZnN[ij_WZnN[ij_WZnN[ij`W[2M
/9f`WK2M/9f`WK2M/9f`WK2M/9f`WK2M/9f`WK2M/IfaW;6L/IbaW;6L/IbaW;6L
/IbaW;6L/Y^bVk:K/Y^bVk:K/Y^bVk:K/Y^bV[>J/iZcV[>J/iZcV[>J/iZcV[>I
/iVcVKBI]9VdVKBI]9VdVKBI]9VdV;BH]9RdV;FH]IReV;FH]IReV;FH]IReUkFG
]INeUkFG]INeUkJG]YNfUkJG]YNfUkJF]YJfU[JF]YJfU[JF]YJfU[NF]iJgU[NF
]iJgUKNE]iFgUKNE]iFgUKNE]iFgUKNE]iFgUKRE^9FhUKRD^9BhU;RD^9BhU;RD
^9BhU;RD^9BhU;RD^9BhU;RD^IBiTkVC^I>iTkVC^I>iTkVC^I>iTkVC^I>iTkVC
^I>iTkVC^I:iT[VB^Y:jT[ZB^Y:jT[ZB^Y:jT[ZB^Y:jT[ZB^Y:jT[ZB^Y:jTKZA
^Y6jTKZA^Y6kTK^A^i6kTK^A^i6kTK^A^i6kTK^A^i6kTK^A^i2kT;^@^i2kT;^@
^i2kT;^@^i2lT;b@_92lT;b@_92lT;b@_92lT;b?_8nlSkb?_8nlSkb?_8nlSkb?
_8nlSkb?_8nlSkf?_HnmSkf?_HnmSkf?_HjmS[f>_HjmS[f>_HjmS[f>_HjmS[f>
_HjmS[f>_HjmS[f>_HjmS[j>_XjnSKj=_XfnSKj=_XfnSKj=_XfnSKj=_XfnSKj=
_XfnSKj=_XfnSKj=_XfnSKj=_XfnS;j<_hboS;n<_hboS;n<_hboS;n<_hboS;n<
_hboS;n<_hboS;n<_hboS;n<_hboS;n;_h^oRkn;_h^oRkn;`8_0Rl2;`8_0Rl2;
`8_0Rl2;`8_0Rl2;`8_0Rl2;`8_0Rl2;`8[0R/2:`8[0R/2:`8[0R/2:`8[0R/2:
`8[0R/6:`H[1R/6:`H[1R/6:`H[1R/6:`H[1R/6:`HW1RL69`HW1RL69`HW1RL69
`HW1RL69`HW1RL69`HW1RL69`HW1RL:9`XW2RL:9`XW2RL:9`XS2R<:8`XS2R<:8
`XS2R<:8`XS2R<:8`XS2R<:8`XS2R<:8`XS2R<:8`XS2R<:8`XS2R<:8`XS2Ql>7
`hO3Ql>7`hO3Ql>7`hO3Ql>7`hO3Ql>7`hO3Ql>7`hO3Ql>7`hO3Ql>7`hO3Ql>7
`hO3Ql>7`hO3Q/>6`hK3Q/>6`hK3Q/>6a8K4Q/B6a8K4Q/B6a8K4Q/B6a8K4Q/B6
a8K4Q/B6a8K4Q/B6a8K4Q/B6a8K4QLB5a8G4QLB5a8G4QLB5a8G4QLB5a8G4QLB5
a8G4QLB5aHG5QLF5aHG5QLF5aHG5QLF5aHG5QLF5aHG5QLF4aHC5Q<F4aHC5Q<F4
aHC5Q<F4aHC5Q<F4aHC5Q<F4aHC5Q<F4aHC5Q<F4aHC5Q<F4aHC5Q<J4aXC6Q<J4
aXC6Q<J3aX?6PlJ3aX?6PlJ3aX?6PlJ3aX?6PlJ3aX?6PlJ3aX?6PlJ3aX?6PlJ3
aX?6PlJ3aX?6PlJ3aX?6PlJ3aX?6PlJ2aX;6P/J2ah;7P/N2ah;7P/N2ah;7P/N2
ah;7P/N2ah;7P/N2ah;7P/N2ah;7P/N2ah;7P/N2ah;7P/N2ah;7P/N2ah77PLN1
ah77PLN1ah77PLN1ah77PLN1ah77PLN1b878PLR1b878PLR1b878PLR1b878PLR1
b878PLR1b878PLR1b878PLR1b838P<R0b838P<R0b838P<R0b838P<R0b838P<R0
b838P<R0b838P<R0b838P<R0b838P<R0bH39P<V0bH39P<V0bH39P<V0bGo9OlUo
bGo9OlUobGo9OlUobGo9OlUobGo9OlUobGo9OlUobGo9OlUobGo9OlUobGo9OlUo
bGo9OlUobGo9OlUobGo9OlUobGo9OlUnbGk:O/YnbWk:O/YnbWk:O/YnbWk:O/Yn
bWk:O/YnbWk:O/YnbWk:O/YnbWk:O/YnbWk:O/YnbWk:O/YnbWk:O/YnbWk:O/Yn
bWk:OLYmbWg:OLYmbWg:OLYmbWg:OLYmbWg:OLYmbWg:OLYmbgg;OL]mbgg;OL]m
bgg;OL]mbgg;OL]mbgg;OL]mbgg;OL]mbgg;OL]mbgg;OL]lbgc;O<]lbgc;O<]l
bgc;O<]lbgc;O<]lbgc;O<]lbgc;O<]lbgc;O<]lbgc;O<]lbgc;O<]lbgc;O<]l
c7c<O<alc7c<O<alc7c<O<alc7_<Nlakc7_<Nlakc7_<Nlakc7_<Nlakc7_<Nlak
c7_<Nlakc7_<Nlakc7_<Nlakc7_<Nlakc7_<Nlakc7_<Nlakc7_<Nlakc7_<Nlak
c7_<Nlakc7[<N/ajc7[<N/ajcG[=N/ejcG[=N/ejcG[=N/ejcG[=N/ejcG[=N/ej
cG[=N/ejcG[=N/ejcG[=N/ejcG[=N/ejcG[=N/ejcG[=N/ejcG[=N/ejcG[=NLei
cGW=NLeicGW=NLeicGW=NLeicGW=NLeicGW=NLeicGW=NLeicGW=NLeicWW>NLii
cWW>NLiicWW>NLiicWW>NLiicWW>NLiicWW>NLiicWW>NLiicWS>N<ihcWS>N<ih
cWS>N<ihcWS>N<ihcWS>N<ihcWS>N<ihcWS>N<ihcWS>N<ihcWS>N<ihcWS>N<ih
cWS>N<ihcWS>N<ihcWS>N<ihcWS>N<ihcgS?N<mhcgO?MlmgcgO?MlmgcgO?Mlmg
cgO?MlmgcgO?MlmgcgO?MlmgcgO?MlmgcgO?MlmgcgO?MlmgcgO?MlmgcgO?Mlmg
cgO?MlmgcgO?MlmgcgO?MlmgcgO?MlmgcgO?M/mfcgK?M/mfcgK?M/mfcgK?M/mf
cgK?M/mfcgK?M/mfd7K@M]1fd7K@M]1fd7K@M]1fd7K@M]1fd7K@M]1fd7K@M]1f
d7K@M]1fd7K@M]1fd7K@M]1fd7K@M]1fd7K@MM1ed7G@MM1ed7G@MM1ed7G@MM1e
d7G@MM1ed7G@MM1ed7G@MM1ed7G@MM1ed7G@MM1ed7G@MM1ed7G@MM1ed7G@MM1e
d7G@MM5edGGAMM5edGGAMM5edGGAMM5edGGAMM5ddGCAM=5ddGCAM=5ddGCAM=5d
dGCAM=5ddGCAM=5ddGCAM=5ddGCAM=5ddGCAM=5ddGCAM=5ddGCAM=5ddGCAM=5d
dGCAM=5ddGCAM=5ddGCAM=5ddGCAM=5ddGCAM=5ddG?ALm5cdG?ALm5cdG?ALm5c
dG?ALm9cdW?BLm9cdW?BLm9cdW?BLm9cdW?BLm9cdW?BLm9cdW?BLm9cdW?BLm9c
dW?BLm9cdW?BLm9cdW?BLm9cdW?BLm9cdW?BLm9cdW?BLm9cdW?BL]9bdW;BL]9b
dW;BL]9bdW;BL]9bdW;BL]9bdW;BL]9bdW;BL]9bdW;BL]9bdW;BL]9bdW;BL]9b
dW;BL]9bdW;BL]9bdg;CL]=bdg;CL]=bdg;CL]=bdg;CL]=bdg;CL]=bdg;CL]=a
dg7CLM=adg7CLM=adg7CLM=adg7CLM=adg7CLM=adg7CLM=adg7CLM=adg7CLM=a
dg7CLM=adg7CLM=adg7CLM=adg7CLM=adg7CLM=adg7CLM=adg7CLM=adg7CLM=a
dg7CLM=adg7CLM=`dg3CL==`dg3CL==`dg3DL=A`e73DL=A`e73DL=A`e73DL=A`
e73DL=A`e73DL=A`e73DL=A`e73DL=A`e73DL=A`e73DL=A`e73DL=A`e73DL=A`
e73DL=A`e73DL=A`e73DL=A`e73DL=A_e6oDKmA_e6oDKmA_e6oDKmA_e6oDKmA_
e6oDKmA_e6oDKmA_e6oDKmA_e6oDKmA_e6oDKmA_e6oDKmA_e6oDKmA_e6oDKmA_
eFoEKmE_eFoEKmE_eFoEKmE_eFoEKmE_eFoEKmE_eFoEKmE_eFoEKmE^eFkEK]E^
eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^
eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^eFkEK]E^
eFkEK]E^eFkEK]E]eFgEKME]eFgEKME]eFgEKMI]eVgFKMI]eVgFKMI]eVgFKMI]
eVgFKMI]eVgFKMI]eVgFKMI]eVgFKMI]eVgFKMI]eVgFKMI]eVgFKMI]eVgFKMI]
eVgFKMI]eVgFKMI]eVgFKMI]eVgFKMI]eVgFKMI]eVgFK=I/eVcFK=I/eVcFK=I/
eVcFK=I/eVcFK=I/eVcFK=I/eVcFK=I/eVcFK=I/eVcFK=I/eVcFK=I/eVcFK=I/
eVcFK=I/eVcFK=I/eVcFK=I/efcGK=M/efcGK=M/efcGK=M/efcGK=M/efcGK=M/
efcGK=M/efcGK=M[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[
ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[
ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJmM[ef_GJ]MZef[GJ]MZ
ef[GJ]MZef[GJ]MZef[GJ]MZf6[HJ]QZf6[HJ]QZf6[HJ]QZf6[HJ]QZf6[HJ]QZ
f6[HJ]QZf6[HJ]QZf6[HJ]QZf6[HJ]QZf6[HJ]QZf6[HJ]QZf6[HJ]QZf6[HJ]QZ
f6[HJ]QZf6[HJ]QZf6[HJ]QZf6[HJMQYf6WHJMQYf6WHJMQYf6WHJMQYf6WHJMQY
f6WHJMQYf6WHJMQYf6WHJMQYf6WHJMQYf6WHJMQYf6WHJMQYf6WHJMQYf6WHJMQY
f6WHJMQYf6WHJMQYf6WHJMQYf6WHJMQYf6WIJMUYfFWIJMUYfFWIJMUYfFWIJMUY
fFWIJMUYfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UX
fFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UX
fFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFSIJ=UXfFOIImUW
fFOIImUWfFOIImUWfFOIImUWfFOIImUWfFOIImUWfFOIImUWfFOIImUWfFOJImYW
fVOJImYWfVOJImYWfVOJImYWfVOJImYWfVOJImYWfVOJImYWfVOJImYWfVOJImYW
fVOJImYWfVOJImYWfVOJImYWfVOJImYWfVOJImYWfVOJI]YWfVKJImYVfVOJI]YW
fVKJImYVfVOJI]YWfVGJIm]UfFSKI=UYg6?HJmaPefoNGMEdge[BNMmIdGcOFM5l
geWAO=mIdGcOFM5lgeWAO=mIdGcOFM5lgeWAO=mHdGcOF=5lh5SAO>1HdGcPF=5m
h5SAON1HdGgPF=5mh5SAON1HdGgPF=5mh5SAON1HdGgPF=5mh5SAON1HdGgPF=5m
h5OAON1GdGkPEm5nh5OAO^1GdGkPEm1nh5O@O^1Gd7kPEm1nh5O@O^1Gd7kPEm1n
h5O@O^1Gd7kPEm1nh5O@O^1Gd7oPE]1oh5K@On1Fd7oPE]1oh5K@On5Fd7oQE]1o
hEK@On5Fd7oQE]1ohEK@On5Fd7oQE]1ohEK@On5Fd7oQE]20hEK@P>5Fd83QE]20
hEG@P>5Ed83QEM20hEG@P>5Ed83QEM20hEG@P>5Ed83QEM20hEG@P>5Ed83QEM20
hEG@P>5Ed87QEM21hEG@PN5Ed87QEM21hEG@PN5Ed87QE=21hEC@PN5Dd87QE<n1
hEC?PN5Dch7QE<n1hEC?PN9Dch7RE<n1hUC?P^9Dch;RE<n2hUC?P^9Dch;RE<n2
hUC?P^9Dch;RE<n2hUC?P^9Dch;RDln2hU??P^9Cch;RDln2hU??P^9Cch;RDln2
hU??Pn9Cch?RDln3hU??Pn9Cch?RDln3hU??Pn9Cch?RDln3hU??Pn9Cch?RDln3
hU??Pn9Cch?RDln3hU??Pn9Bch?RD/n3hU;?Pn9BchCRD/n4hU;?Q>9BchCRD/n4
hU;?Q>9BchCRD/n4hU;?Q>=BchCSD/n4he;?Q>=BchCSD/n4he;?Q>=BchCSD/n4
he;?Q>=AcXGSD/n4he7>QN9Bch?SD<f8hUCAO^A>bXkOG=U/hUCAOnA>bhgOFmQ_
he7>Q^=Bch?SD<f9hUGBO>E<bI7NH=]UgecIKN9Cd87TC/^=h5WFL^A>bhgPFMIc
i4g;S^1Jeg3TClf9hUCBONE<bI;MHMeRgF7MH]iOg6GOFmU/he;@PnA>bhgPF=Ic
iDc:T=mLfV[RE=9niD_8U=aTgecJJ^9DdWgUB/NEg6GPF]Q^i4o=R>=Bd8;UC<Z@
ge_IK>=AchCTCL^=hESFLnE;b9CMH]iOg6GPF]Q^i4k<R^9CdWkVBLJGffSRE==k
iTW5VMU]i4o=R>=@chGUCL^=hEKEM^I8aYWIK>A?cXSTClj7i4k=R^=Ad8;VB/RD
gF;OGMaVhEOFLnI9aYSJJN=BdH3VB<JIfV_TD<n5iD_:TN1JfF_TClj8i4k=RNA?
cXKUCL^>hUGEMnM7`ikFM^M7a9gFM>M7aIcHL>I9aiKMI>5If6oVB/VCgegLI>5H
f73VBLNGg6GRE]IdidK4W]IeidK3WmEhidG2X]9nidG2X==kj4G1Xm61idK4W]Ie
idG2XM=kj4C1Y=23idO5VmU]iT[9Tn1Lg6OSD]=mj4C1Y=24idS6VM]Xi53@PnM6
a9gGLNM6a9kGM>Q4`Z?BOnQ4`JCAP^M6`ioEMnQ3_jO=R^E=cXWUC<b=he7BOnQ3
`:K>R>I:bY7QEmQ_idK4WMQaj4G3X=EijD:nZ/VCh5_LI^AAdX3X@l2WcXWVBl^@
hUGGM>Q2_jO=RnE=cXSVBLVDh5_LIN=BdggY@Kf/aiWLI^AAdWkY@Kf[b9KNH>1K
gFCSD]AjjD2k[l>PeWKY@;b^aIgIK^Q5a9oGM>U1_Jc8UmiPhE[LInE=chSWAlJK
ffWVB/^@he?EN>Xo^[70Ylj8idO7VMeUi53BOnXo^k32Y=9ojSnk/<:SdggZ?[Zb
_j[;TN=CeGSZ?[Vd^k33XMEijSfh]KZa`:O?R>Q5a9kHL>U1_Zc9U^1LgV7REMQa
jD2m[LNIgF?TD]Ejjcbg^;Ji];b^aIgJK>Q4`j;ENN/l][Vd_:o4X=Mejcfh][Vd
_:o4X=QcjSfi];b_aIkIK^U1_jW<S^I;cHcWBLZChUKIK^U0_Zc8Un1Mh5gPG=mN
h5_NHN=Df77Z?KVd_Jk7V]eTiDkAPnXm^KFl/<>ReWO/>[>n[<ZDhUKJKNY0_Zg8
Un1KgeoREm]Yj4G6WM]Yj4C5WmU`jcfi]K^a`j?DNn`h/L:Udgo/>K?0ZLj;j4C5
WmY^jSjk/L:Udgo/>K;1Y]63jc^f^[Bn[<ZCi5;FMn`h/<BQf7?/>K;0Z<n8jSnm
[lJMg6SXALJMff[Y@/6WdHC[>kJj/knZcHkWB<^Bi53DO>df[/RIh5kREmeVj4K8
V>1Lh5cQFn1MhEWNHNE@e7c]=Jc:U>=Cf7;/>;74X]MekCJ]bIORF=eUidO:UN=D
fVo/>[Fm[lNLgV?VB/j;jD71Ym65k3Vd_j_<SnM7bYCTD]MekCF[c93WB/f=jD?4
XMQckCF]bYGSDmU_k3Ra`jCFN>hcZ=26k3Ze_Zk9V>9Hgf7VCM:2kCF]bYGTD]Ua
kCF]bYGTDMMekS>Yd8O/>[Fm[lNKgf3UCmElkS:Ve7k^<ZOBPnde[<bBid[?Rn/m
_;;2Y]AmkS6Ue7g_<JGENnlaY=Iikc2TeWS_<:CFN>l`Y=Mgkc2TeWO_<:?GM^l`
Y=Ihkc2Sf7C_<JGEO>l`X]QckS:Ve7o_<:?GM^l`X]Qckc6UeG__;j7JK^de[/VG
heCLJ^`j][faaJ;IL>hbZ=65kS>Zch[/>[Nl/l>VeGc`;YoLJ>/k^KRj][faaJ3K
Jndg//BSf7G`;Z3LJ^`h]<2Zch[/>;C1Z]28kCF^bYOTD]Y_kS:XdX?_<:?HM?0^
WmeWjcfl/l:Wdh3`;IkNINXo`:_?Rn`i][f`aigOHNQ6biCWBLn<k3Zg_;?3YMIi
lB^IheGNINXo`:c=SnXo`J[@RNdf[lVIheKOHNQ5bYOUCmMflBZHi5?KK>hcZ]28
kS>[ch_]=k?3Y]IjlBVFiTcCPO4[V^=Gh5kVC=>1lB^JheKOH^U3aikOH>Q6biCW
B<n;kCJaaikOH^U2aZ3NI^`k^KVi^KZg_;?3Y]IjlRNBjT;6X=eXkCJaaikOHNU2
aYoNI>/m_[39V^=Fgf3YA<ZHiDoILo4XUNQ7cXo/>[Vi^KVj^KZh_;G0[<n<kSF_
bYSUD=UclRRDjDG:UnI<eGgb9Xk]>;Jo[/bCjD?8W>9IheOQG>I>egOb9Hg^=K3:
VNE?fG;b9i;Z@<>XeGgc98_^<j_AR?0^XMeXkc:ZdXCa:IKXAln=kSF`bYSVC=Em
lbB:l2nSffka:YWUCmYalRJAk3^l]/6/chc_<ZWDPO<USNhc[Ln>kSF`bYOWB]>3
lRJ@k3Zi^kNo/<^GidWBQ_8XUNU4bYSWB]>2lbB<kc6XeWcd8HCb9Hk^=:o;U^U5
c9CZ@LJQgVK^<jc@Ro0^X]eYl2fPgf;/?;jcaZ;MInl`YmMjm1n0m264lbB<kc2V
f7Kd887d8HGc9Hg_<JWEO_@OP?@QPo<RR?8XU>Y0aJCKKO8VT>he//RNhU_WB]Eo
m1n0m1n0m1n0m1n0m1n0m1mom1mnmAimmAekmAejmAejmAeimAeimAeimAeimAei
mAaimAahmAahmAahmAahmAahmAahmAahmAagmAagmAagmAagmAagmAagmAagmAag
mAafmAafmA]fmA]fmA]fmA]fmA]fmA]fmA]fmA]emA]emA]emA]emA]emA]emA]e
mQ]emQ]emQ]emQ]emQ]dmQ]dmQ]dmQ]dmQ]dmQ]dmQ]dmQYdmQYdmQYdmQYdmQYd
mQYcmQYcmQYcmQYcmQYcmQYcmQYcmQYcmQYcmQYcmQYcmQYcmQYcmQYbmQYbmQYb
mQYbmQYbmQYbmQYbmQYcmQU`mQ]emaM[m266mAilmaIYlbF?l2fRh63^=kK3Z]Im
maIWlRNCkSJdaZCMJ_<SR_@RR?@PP_HHK_DLN?LEIO4/Wn=HidgKL?HIL?HILOHH
K_DLN?LDH_0`ZMQhmaARl32YegWh567_<k3>Tnlc[m2=lRNDkSJfa:WHNOPCGndg
^<2bbiWZ@lfEkCNh_k;:V^U7dXOf6gOh4ek]>K^k^[fg`Jk@S?<SR_@OP_LEIO8X
Un`k`;;;VN]0bIoUDn9KjT7:VnU6dXOf6WCh4Ug]>[fg`j_EP?PBG>`m`ZgCQOLG
JoDLNOT@E^I@gfGb9iG^=;?9W^I>gFWe7Gci3eGUD^9Kjd38XN=IjDG@SO@RR?HJ
LoPAF^Y3cIC_<ZgCQoLGJoHJM?T@E^I?gVOd88Gg5FGc9I3b9iO]>;Zn]lB[egci
3DkNJODLN?X=CMa]maIXmAemnPe=g6gg5FKd8HKg5FGc98kd8HSg5f_g5fcg5V[f
673h4E[[@<ZMj4SFOoX=C=a_n15LkCZo]LRQi5OYAmB4nA1Gj4WHNOX:AM:9maM]
n1=QlBZNidcLKoT@F>Y5dH_f6WCj34WHN_/9@/fGkSFdb:3UE>EBheWZ@/fGkcBc
bYcZA=6<mQ]gn`U0bi_Z@/jDl2fVgfKe7Wok2D;=U_0`[=J0n`U2cIG`;jWKL_X:
AM>7nA1HjT;>U?8ZW^Q9fGSk1cZo]LNThUg_<ZoBR_LEI_DLNo/6=k^n]lFZfWGk
1c_1/LnBlbFBlbFClRRHkSJi`[3ARoLFJOLEIoHILO/9@LbIkSJi`K7?T_<SS_HK
N?`4<JoCQoX=C^1SmAn3n`Q0bYgZA=::n19Ml36^e8Gk2D?@T?DNP_/6>;fk_kO6
YmiXn1=Qm2>>maQ`n`PnajGRGo8ZWnQ9fWCl0bjYg6ok2D3<VNhf^L6bcYCc9ICc
9YKa;:CRGO0^Z=e/nPa;gFcj2dOGO?d19I?d8Xch4f;d88Ok2D;@T?HLNod08H[i
3U?VD>=Kkc>bcYCc9I?d8HSj2dSHNod07X;l0RZPj4_NJoX;B]aao0<]Y^1SmQ]j
oP0KNOh06gSn01]hoP0JMoh06g[n01Uco@0SS_PDI?HIL_d0997f6gWn01M/n`Lk
a:cINOh05FSi3U?XC=mVn19OlbFCmB26o0@`[]MooP0HL?d19YKb:9_^>;jj`[7B
RoX<C>1Vn19Om2>?n1AUn1=RmQ]ioP0=D>EFjd3=VO0_[=YfoP0>E>U6eggo00e?
he_a;JSOIoT>DNI@iEGZ@m>9n`Hh_kO7Yn5SmaM^o@0TT_HJM_l02D7?U?DPQ_d1
9IGd8HWl1CJk`;K:XNU8fWGo00LlajOQH?HKNol002BBmQUdo`07>lB]fG[o000L
OOl0026;n`Lja:kGOol00bj[fg;o00U2dXck23o=VO4]Z>1Tn@mGkSS0]lVSidoT
Enhg_Kjl_kS7Z>1VnPa;gfOk2D7AT?TAG?<WVo0\>"]},
  ImageCacheContents->"Sound",
  CellTags->{"LogisticMap", "G.3.7"}],

Cell[CellGroupData[{

Cell["Implementation", "SubsubsectionIcon",
  CellTags->{"LogisticMap", "G.3.7"}],

Cell[BoxData[
    \(logistic[n_Integer] := 
      Module[{f, t, x}, 
        f = Compile[{x, t}, Evaluate[\((3 + t\/n)\)\ x\ \((1 - x)\)]]; 
        FoldList[f, 0.223, Range[n]]]\)], "Input",
  CellTags->{"LogisticMap", "G.3.7"}],

Cell[BoxData[
    \(ListPlay[logistic[8000], \ SampleRate\  -> 2000]\)], "Input",
  CellTags->{"LogisticMap", "G.3.7"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ", "GroupDivider"],

Cell["Arpeggio", "Subsection",
  CellTags->{"Arpeggio", "G.3.8"}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.0238095 0.952381 0.0147151 0.588604 [

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

% Start of sampled sound

1 string

8192 24575 8

{ currentfile 1 index readhexstring pop }

 false 1 sampledsound

A8CCE8FAFFF8E5C7A27A522F140400091E3D628BB2D4EEFDFFF4DDBE976F48270E01010D2546

6D96BCDCF3FFFDEFD6B38C643E1F090003132E5178A1C6E4F8FFFAE9CDA98159351806000619

375B84ABCFEAFBFFF7E2C49E764E2C1203000A2040668FB6D7F0FDFEF2DBBA936B44240C0102

0F284A719AC0DFF5FFFCEDD2B088603B1C0800041531547CA5C9E6F9FFF9E7CAA57D55311604

00081C3A5F88AFD2ECFCFFF5E0C09A724B291002010C23446A93B9DAF2FEFEF0D8B68F674121

0B0002112B4E759EC3E2F7FFFBEBCFAC845C371A07000517345880A8CCE9FAFFF8E4C6A17951

2E130300091E3D638CB3D5EFFDFFF4DDBD966E47260E01010E26476E97BDDDF4FFFDEED5B38B

633D1E090003132E5279A2C7E4F8FFFAE8CCA8805834170500071A375C84ACD0EBFBFFF6E2C3

9D754E2B1102000B21416790B7D8F0FEFEF2DAB9926A43230C010210294B729BC0E0F5FFFCEC

D2AF875F3A1C0800041632557DA5CAE7F9FFF9E6C9A47C5431150400081C3B6088B0D3EDFCFF

F5DFBF9A714A280F02010C24446B94BADBF2FEFDF0D7B68E6640200A0003122C4F769FC4E2F7

FFFBEACFAB835B361906000618355981A9CDE9FAFFF8E4C6A178502E1303000A1F3E648CB4D6

EFFDFFF3DCBC966D46250D01010E27486F98BEDEF4FFFDEED4B28A623C1E090004142F527AA2

C7E5F8FFFAE8CBA77F5733170500071A385D85ADD0EBFBFFF6E1C29D744D2A1102000B224268

90B7D9F1FEFEF1D9B8926943220C0002102A4C739BC1E0F6FFFCECD1AE865E391B0700051632

567EA6CBE7FAFFF9E6C8A47B5330150400081D3B6189B1D3EDFCFFF5DEBF997049280F01010D

24456C94BBDBF3FEFDF0D7B58E653F200A0003122D4F779FC5E3F7FFFBEACEAA825A36190600

0619365A82AACEEAFBFFF7E3C5A077502D1203000A203F658DB5D6EFFDFEF3DCBB956C45250D

01010F27497098BEDEF4FFFCEED4B18A613C1D0800041430537BA3C8E5F9FFFAE7CBA77E5632

160500071B395E86AED1ECFCFFF6E0C19C734C2A1002000C22426991B8D9F1FEFEF1D9B89168

42220B0002112A4D749CC2E1F6FFFCEBD0AD865D381B0700051733577FA7CBE8FAFFF8E5C7A3

7A532F140400091E3C628AB2D4EEFDFFF4DEBE986F48270E01010D25466D95BCDCF3FEFDEFD6

B48D643E1F0A0003132D5078A0C5E3F7FFFAE9CDA98259351806000619365B83ABCEEAFBFFF7

E2C49F764F2C1203000A2040668EB5D7F0FDFEF2DBBA946B45240D01020F284A7199BFDFF5FF

FCEDD3B089603B1D0800041531547CA4C9E6F9FFF9E7CAA67D5632160500081C3A5F87AFD2EC

FCFFF5E0C19B724B291002010C23436A92B9DAF2FEFEF1D8B7906741210B0002112B4D759DC3

E1F6FFFBEBD0AC855C381A07000517345880A8CCE8FAFFF8E4C7A279522F140300091E3D638B

B2D5EEFDFFF4DDBD976E47260E01010E26476E96BDDDF3FFFDEFD5B38C633E1F090003132E51

79A1C6E4F8FFFAE9CDA9815834180500061A375C84ACCFEBFBFFF7E2C39E754E2C1103000B21

41678FB6D8F0FEFEF2DABA936A44230C010210294A729AC0DFF5FFFCEDD2AF885F3A1C080004

1531557DA5C9E6F9FFF9E6C9A57D5531150400081C3A6088B0D2EDFCFFF5DFC09A714A290F02

010C24446B93BADBF2FEFEF0D7B68F6640210A0003122C4E769EC3E2F7FFFBEACFAC845B3719

06000518345981A9CDE9FAFFF8E4C6A179512E130300091F3E638CB3D5EFFDFFF3DDBC966D47

260E01010E26486F97BDDDF4FFFDEED5B28B623D1E090004142F527AA2C7E5F8FFFAE8CCA880

5834170500071A385D85ADD0EBFBFFF6E1C39D754D2B1102000B21416790B7D8F1FEFEF2DAB9

926943230C000210294B739BC1E0F5FFFCECD1AF875F391B0700051632567EA6CAE7F9FFF9E6

C9A47C5430150400081D3B6089B0D3EDFCFFF5DFBF997149280F02010D24456B94BBDBF3FEFD

F0D7B58E6540200A0003122C4F779FC4E3F7FFFBEACEAB835B361906000618355A82AACDE9FB

FFF7E3C5A078502D1303000A1F3F648DB4D6EFFDFEF3DCBC956D46250D01010F27486F98BEDE

F4FFFDEED4B18A623C1D090004142F537BA3C8E5F8FFFAE8CBA77F5733170500071B385D86AD

D1ECFCFFF6E1C29C744C2A1102000B22426891B8D9F1FEFEF1D9B8916942220B0002102A4C73

9CC2E1F6FFFCECD1AE865E391B0700051633577FA7CBE8FAFFF8E5C8A37B5330140400081D3C

618AB1D4EEFDFFF4DEBE987049270F01010D25466C95BBDCF3FEFDEFD6B48D653F1F0A000313

2D5077A0C5E3F7FFFBE9CEAA825A351806000619365A83ABCEEAFBFFF7E3C49F774F2D120300

0A203F658EB5D7F0FDFEF3DBBB946C45240D01020F28497099BFDFF5FFFCEDD3B189613B1D08

00041530547BA4C8E6F9FFF9E7CAA67E5632160500071B395E87AED1ECFCFFF6E0C19B734C29

1002000C23436992B9DAF2FEFEF1D8B7906841220B0002112B4D749DC2E1F6FFFBEBD0AD855D

381A0700051733577FA8CCE8FAFFF8E5C7A27A522F140400091E3D628BB2D4EEFDFFF4DDBE97

6F48270E01010D25466D96BCDCF3FFFDEFD6B48C643E1F090003132E5178A1C6E4F8FFFAE9CD

A98159351806000619375B84ABCFEAFBFFF7E2C49E764E2C1203000A2040668FB6D7F0FDFEF2

DBBA936B44240C01020F284A719AC0DFF5FFFCEDD2B088603B1C0800041531547CA5C9E6F9FF

F9E7CAA57D5531160400081C3A5F88AFD2ECFCFFF5E0C09A724B291002010C23446A93B9DAF2

FEFEF0D8B68F6741210B0002112B4E759EC3E2F7FFFBEBCFAC845C371A07000517345880A8CC

E9FAFFF8E4C6A179512E130300091E3D638CB3D5EFFDFFF4DDBD966E47260E01010E26476E97

BDDDF4FFFDEED5B38B633D1E090003132E5179A2C7E4F8FFFAE8CCA8805834170500071A375C

84ACD0EBFBFFF6E2C39D754E2B1102000B21416790B7D8F0FEFEF2DAB9926A43230C01021029

4B729BC0E0F5FFFCECD2AF875F3A1C0800041632557DA5CAE7F9FFF9E6C9A47C543115040008

1C3B6088B0D3EDFCFFF5DFBF9A714A280F02010C24446B94BADBF2FEFDF0D7B68E6640200A00

03122C4F769FC4E2F7FFFBEACFAB835B361906000618355981A9CDE9FAFFF8E4C6A178502E13

03000A1F3E648CB4D6EFFDFFF3DCBC966D46250D01010E27486F98BEDEF4FFFDEED4B28A623C

1E090004142F527AA2C7E5F8FFFAE8CBA77F5733170500071A385D85ADD0EBFBFFF6E1C29D74

4D2A1102000B22426890B7D9F1FEFEF1D9B8926943220C0002102A4C739BC1E0F6FFFCECD1AE

865E391B0700051632567EA6CBE7FAFFF9E6C8A47B5330150400081D3B6189B1D3EDFCFFF5DE

BF997049280F01010D24456C94BBDBF3FEFDF0D7B58E653F200A0003122D4F779FC5E3F7FFFB

EACEAA825A361906000619365A82AACEEAFBFFF7E3C5A077502D1203000A203F658DB5D6EFFD

FEF3DCBB956C45250D01010F27497098BEDEF4FFFCEED4B18A613C1D0800041430537BA3C8E5

F9FFFAE7CBA77E5632160500071B395E86AED1ECFCFFF6E0C19C734C2A1002000C22426991B8

D9F1FEFEF1D9B8916842220B0002112A4D749CC2E1F6FFFCEBD0AD865D381B0700051733577F

A7CBE8FAFFF8E5C7A37A532F140400091E3C628AB2D4EEFDFFF4DEBE986F48270E01010D2546

6D95BCDCF3FEFDEFD6B48D643E1F0A0003132D5078A0C5E3F7FFFAE9CDAA8259351806000619

365B83ABCEEAFBFFF7E2C49F764F2C1203000A2040668EB5D7F0FDFEF2DBBA946B45240D0102

0F284A7199BFDFF5FFFCEDD3B089603B1D0800041531547CA4C9E6F9FFF9E7CAA67D56321605

00081C3A5F87AFD2ECFCFFF5E0C19B724B291002000C23436A92B9DAF2FEFEF1D8B790674121

0B0002112B4D759DC3E1F6FFFBEBD0AC855C381A07000517345880A8CCE8FAFFF8E4C7A27952

2F140300091E3D638BB2D5EEFDFFF4DDBD976E47260E01010E26476E96BDDDF3FFFDEFD5B38C

633E1F090003132E5179A1C6E4F8FFFAE9CDA9815834180500061A375C84ACCFEBFBFFF7E2C3

9E754E2C1103000B2140678FB6D8F0FEFEF2DABA936A44230C010210294A729AC0DFF5FFFCED

D2AF885F3A1C0800041531557DA5C9E6F9FFF9E6C9A57D5531150400081C3A6088B0D2EDFCFF

F5DFC09A714A290F02010C24446B93BADBF2FEFEF0D7B68F6640210A0003122C4E769EC3E2F7

FFFBEACFAC845B371906000518345981A9CDE9FAFFF8E4C6A179512E130300091F3E638CB3D5

EFFDFFF3DDBC966D47260E01010E26486F97BDDDF4FFFDEED5B28B623D1E090004142F527AA2

C7E5F8FFFAE8CCA8805834170500071A385D85ADD0EBFBFFF6E1C39D754D2B1102000B214167

90B7D8F1FEFEF2DAB9926943230C000210294B739BC1E0F5FFFCECD1AF875F391B0700051632

567EA6CAE7F9FFF9E6C9A47C5430150400081D3B6089B0D3EDFCFFF5DFBF997149280F02010D

24456B94BBDBF3FEFDF0D7B58E6540200A0003122C4F779FC4E3F7FFFBEACEAB835B36190600

0618355A82AACDE9FBFFF7E3C5A078502D1303000A1F3F648DB4D6EFFDFEF3DCBC956D46250D

01010F27486F98BEDEF4FFFDEED4B18A623C1D090004142F537BA3C8E5F8FFFAE8CBA77F5733

170500071B385D86ADD1ECFCFFF6E1C29C744C2A1102000B22426891B8D9F1FEFEF1D9B89169

42220B0002102A4C739CC2E1F6FFFCECD1AE865E391B0700051633577FA7CBE8FAFFF8E5C8A3

7B5330140400081D3C618AB1D4EEFDFFF4DEBE987049270F01010D25466C95BBDCF3FEFDEFD6

B48D653F1F0A0003132D5077A0C5E3F7FFFBE9CEAA825A351806000619365A83ABCEEAFBFFF7

E3C49F774F2D1203000A203F658EB5D7F0FDFEF3DBBB946C45240D01020F28497099BFDFF5FF

FCEDD3B189613B1D0800041530543C18030110305B8BBAE0F9FFF4D7AE7E4F260A0007204776

A6D1F0FFFBE6C194633715020213356191BFE4FAFFF1D3A9784922080009244C7CACD5F3FFF9

E2BC8E5D32110103173A6797C4E8FCFEEECEA372441E06000C295282B2DAF5FFF7DEB788572D

0E00041A3F6D9DCAEBFDFDEBC99D6C3E1A04000F2D5888B7DEF7FFF5DAB18252280C00061E44

73A3CEEEFEFCE8C497663916030112325E8EBCE2F9FFF3D5AC7C4C24090008224979A9D3F1FF

FAE4BF91603413020215376394C2E6FBFFF0D1A676472007000B264F7FAFD8F4FFF8E0BA8B5B

30100103183C699AC7E9FDFEEDCCA070411C05000D2B5585B4DCF6FFF6DCB485552B0D00051C

416FA0CCEDFEFDE9C79A6A3C180401102F5A8BBAE0F8FFF4D8AF7F4F260B0007204775A6D1F0

FFFBE6C294643715020213346091BFE4FAFFF1D3A9794A22080009244C7BABD5F2FFF9E2BD8E

5E3212010316396697C4E7FCFEEECEA373441E06000C285282B1DAF5FFF7DEB788582D0F0004

1A3E6C9DC9EBFDFDEBCA9D6D3F1A04000E2D5788B7DEF7FFF5DAB28252290C00061E4472A3CE

EEFEFCE8C597673A17030111325D8EBCE2F9FFF3D6AC7C4D24090008224978A8D3F1FFFAE4BF

91613513020215376394C1E6FBFFF0D1A676472007000A264F7EAED7F4FFF9E0BA8B5B301001

03183C699AC6E9FCFEEDCCA170421C05000D2A5484B4DBF6FFF6DCB585552B0D00051C416F9F

CBECFEFDEAC79B6A3D190401102F5A8AB9E0F8FFF4D8AF7F50270B0007204675A5D0EFFFFBE6

C295643715020113346090BEE3FAFFF1D4A9794A23080009244C7BABD5F2FFFAE2BD8F5E3312

010316396696C4E7FCFEEFCFA473451E06000B285181B1D9F5FFF8DEB889582E0F00041A3E6C

9CC9EBFDFDEBCA9E6D3F1B05000E2D5787B6DDF7FFF5DAB28353290C00061D4372A2CEEEFEFC

E8C598673A17030111315D8DBCE1F9FFF3D6AD7D4D250A0008214978A8D2F1FFFBE4C0926135

14020214366393C1E5FBFFF0D1A777482107000A264E7EAED7F3FFF9E1BB8C5C30110103183B

6899C6E9FCFEEDCDA171421D05000D2A5484B3DBF6FFF7DDB586562C0E00051B406E9FCBECFE

FDEAC89B6B3D1904000F2F5A8AB9DFF8FFF4D8B08050270B00071F4674A5D0EFFEFBE6C39565

3815020113335F90BEE3FAFFF2D4AA7A4B23090009234B7AABD4F2FFFAE3BD8F5F3312010316

386596C3E7FCFEEFCFA474451F06000B285181B0D9F5FFF8DFB889592E0F0004193E6B9CC8EA

FDFDECCA9E6E401B05000E2C5687B6DDF7FFF6DBB383532A0C00061D4371A2CDEEFEFCE8C598

683B17030111315C8DBBE1F9FFF3D6AD7D4E250A0008214877A7D2F1FFFBE5C0926236140202

14366293C0E5FBFFF0D2A777482108000A254E7DADD6F3FFF9E1BB8C5C31110103173B6899C6

E8FCFEEDCDA171431D06000C2A5383B3DBF6FFF7DDB686562C0E00051B406E9FCBECFDFDEAC8

9C6B3D1904000F2E5989B8DFF8FFF5D9B08051280B00071F4574A4CFEFFEFCE7C39665381602

0112335F8FBEE3FAFFF2D4AA7A4B23090009234B7AAAD4F2FFFAE3BE905F3312010216386595

C3E7FBFEEFD0A574451F07000B275080B0D8F4FFF8DFB98A592F0F0004193D6B9BC8EAFDFDEC

CB9F6E401B05000E2C5686B5DDF7FFF6DBB384542A0D00061D4271A1CDEDFEFCE9C699683B18

030111305C8CBBE1F9FFF3D7AD7E4E260A0008214877A7D2F0FFFBE5C1936236140202143562

92C0E5FBFFF1D2A878482108000A254D7DADD6F3FFF9E1BB8D5C31110103173A6798C5E8FCFE

EECDA271431D06000C295383B2DAF5FFF7DDB687572C0E00051B3F6D9ECAECFDFDEAC99C6B3E

1A04000F2E5989B8DFF8FFF5D9B08151280B00061F4573A4CFEFFEFCE7C39666391603011233

5E8FBDE3FAFFF2D5AB7B4B24090009234A7AAAD4F2FFFAE3BE90603413010215386495C2E6FB

FEEFD0A575461F07000B275080AFD8F4FFF8DFB98A5A2F100004193D6A9BC8EAFDFEECCB9F6F

411C05000D2B5586B5DCF7FFF6DBB384542A0D00051D4270A1CCEDFEFCE9C699693B18030110

305B8CBAE0F9FFF4D7AE7E4E260A0007204776A7D1F0FFFBE5C193633614020213356192C0E4

FAFFF1D3A878492208000A254D7CACD6F3FFF9E2BC8D5D31110103173A6798C5E8FCFEEECEA2

72431E06000C295282B2DAF5FFF7DEB687572D0E00041A3F6D9ECAEBFDFDEBC99D6C3E1A0400

0F2E5888B7DEF8FFF5D9B18151280C00061E4473A3CFEEFEFCE7C497663916030112325E8EBD

E2FAFFF2D5AB7B4C24090008224A79A9D3F1FFFAE4BF91603413010215376494C2E6FBFFF0D0

A675462007000B274F7FAFD8F4FFF8E0B98B5A2F100104183C6A9AC7EAFDFEECCCA06F411C05

000D2B5585B4DCF6FFF6DCB485552B0D00051C4170A0CCEDFEFDE9C79A693C18030110305B8B

BAE0F8FFF4D7AE7F4F260A0007204776A6D1F0FFFBE6C294633715020213356191BFE4FAFFF1

D3A9784922080009244C7CACD5F3FFF9E2BC8E5D32110103173A6797C4E8FCFEEECEA372441E

06000C295282B1DAF5FFF7DEB788582D0F00041A3F6C9DC9EBFDFDEBC99D6C3F1A04000F2D58

88B7DEF7FFF5DAB18252290C00061E4473A3CEEEFEFCE8C497663917030112325D8EBCE2F9FF

F3D5AC7C4C24090008224979A9D3F1FFFAE4BF91613413020215376394C2E6FBFFF0D1A67647

2007000A264F7FAED7F4FFF8E0BA8B5B30100103183C699AC7E9FDFEEDCCA070411C05000D2B

5585B4DCF6FFF6DCB485552B0D00051C416FA0CCEDFEFDE9C79A6A3C180401102F5A8BB9E0F8

FFF4D8AF7F4F270B0007204675A6D0F0FFFBE6C294643715020113346091BFE4FAFFF1D3A979

4A22080009244C7BABD5F2FFF9E2BD8E5E3212010316396697C4E7FCFEEECFA373441E06000C

285281B1D9F5FFF8DEB788582D0F00041A3E6C9DC9EBFDFDEBCA9D6D3F1A04000E2D5787B7DE

F7FFF5DAB28252290C00061E4472A2CEEEFEFCE8C598673A17030111325D8DBCE2F9FFF3D6AC

7C4D250A0008224978A8D3F1FFFAE4C092613513020214366393C1E5FBFFF0D1A67647200700

0A264E7EAED7F4FFF9E0BA8C5B30100103183B6999C6E9FCFEEDCCA170421C05000D2A5484B4

DBF6FFF7DCB586552B0D00051C416F9FCBECFEFDEAC79B6A3D190401102F5A8AB9E0F8FFF4D8

AF8050270B00071F4675A5D0EFFEFBE6C295643815020113346090BEE3FAFFF2D4AA794A2308

0009244B7BABD5F2FFFAE3BD8F5E3312010316396696C4E7FCFEEFCFA473451F06000B285181

B1D9F5FFF8DFB889592E0F00041A3E6C9CC9EBFDFDECCA9E6D3F1B05000E2C5787B6DDF7FFF5

DAB28353290C00061D4372A2CDEEFEFCE8C598673A17030111315D8DBBE1F9FFF3D6AD7D4D25

0A0008214878A8D2F1FFFBE5C092623514020214366293C1E5FBFFF0D2A777482107000A264E

7EADD7F3FFF9E1BB8C5C30110103183B6899C6E9FCFEEDCDA171421D06000D2A5484B3DBF6FF

F7DDB586562C0E00051B406E9FCBECFEFDEAC89B6B3D1904000F2F598AB9DFF8FFF4D8B08050

270B00071F4674A5D0EFFEFBE7C395653816020112335F90BEE3FAFFF2D4AA7A4B2309000923

4B7AAAD4F2FFFAE3BE8F5F3312010216386596C3E7FCFEEFCFA474451F07000B285180B0D9F5

FFF8DFB889592E0F0004193D6B9CC8EAFDFDECCB9E6E401B05000E2C5686B6DDF7FFF6DBB383

532A0C00061D4371A2CDEDFEFCE8C699683B17030111315C8CBBE1F9FFF3D6AD7D4E250A0008

214877A7D2F0FFFBE5C093623614020214366292C0E5FBFFF0D2A777482108000A254E7DADD6

F3FFF9E1BB8D5C31110103173B6898C5E8FCFEEECDA271431D06000C2A5383B3DBF6FFF7DDB6

87562C0E00051B406E9ECAECFDFDEAC89C6B3D1904000F2E5989B8DFF8FFF5D9B08051280B00

071F4574A4CFEFFEFCE7C396653816030112335F8FBDE3FAFFF2D4AA7A4B23090009234B7AAA

D4F2FFFAE3BE905F3313010215386595C3E7FBFEEFD0A574461F07000B275080B0D8F4FFF8DF

B98A592F0F0004193D6B9BC8EAFDFEECCB9F6E401B05000E2C5686B5DDF7FFF6DBB384542A0D

00051D4271A1CDEDFEFCE9C699683B18030111305C8CBBE1F9FFF3D7AE7E4E260A0007214877

A7D1F0FFFBE5C193623614020214356192C0E5FBFFF1D2A878492108000A254D7DADD6F3FFF9

E1BC8D5D31110103173A6798C5E8FCFEEECEA272431D06000C295383B2DAF5FFF7DDB687572C

0E00051B3F6D9ECAEBFDFDEBC99C6C3E1A04000F2E5889B8DFF8FFF5D9B18151280B00061F45

73A4CFEFFEFCE7C496663916030112335E8FBDE2FAFFF2D5AB7B4C24090008234A79AAD4F2FF

FAE3BE90603413010215376495C2E6FBFFEFD0A575462007000B27507FAFD8F4FFF8E0B98A5A

2F100104193D6A9BC7EAFDFEECCB9F6F411C05000D2B5585B5DCF6FFF6DBB484542A0D00051C

4270A1CCEDFEFCE9C699693C18030110305B8CBAE0F9FFF4D7AE7E4F260A0007204776A6D1F0

FFFBE5C194633615020213356192BFE4FAFFF1D3A878492208000A254D7CACD6F3FFF9E2BC8E

5D32110103173A6798C5E8FCFEEECEA372441E06000C295282B2DAF5FFF7DEB788572D0E0004

1A3F6D9DCAEBFDFDEBC99D6C3E1A04000F2D5888B7DEF7FFF5D9B18152280C00061E4473A3CF

EEFEFCE7C497663916030112325E8EBDE2F9FFF2D5AB7B4C24090008224A79A9D3F1FFFAE4BF

91603413020215376494C2E6FBFFF0D0A675462007000B274F7FAFD8F4FFF8E0BA8B5A2F1001

04183C6A9AC7E9FDFEEDCCA06F411C05000D2B5585B4DCF6FFF6DCB485552B0D00051C4170A0

CCEDFEFDE9C79A693C18030110305B8BBAE0F8FFF4D7AE7F4F260A0007204776A6D1F0FFFBE6

C294633715020213346091BFE4FAFFF1D3A9794922080009244C7CACD57FB9E7FEF8D8A36730

0B00113C75B1E2FDFBDEAC70370F000D346CA9DCFAFDE4B4793F1300092D63A0D5F7FFE9BD82

47180106265A97CEF4FFEEC48B4F1E030320528EC7F0FFF3CC94582405021A4985BFEBFFF6D3

9D612B080015417CB7E6FEF9DAA66A320C00103972AEE0FCFCE0AF733A10000C3269A6DAF9FE

E6B77C411500082B609DD3F6FFEBBF854A1A0205245894CCF2FFF0C78E522004031E4F8BC4EE

FFF4CE975B260601184782BCE9FFF7D5A0642D0900133F79B4E4FDFADCA96D340D000F376FAC

DEFBFDE2B1763C12000B2F66A3D8F8FEE8BA7F44170107295D9AD1F5FFEDC2884C1C02042255

91C9F1FFF1C991552204021C4C88C2EDFFF5D19A5E29070117447FBAE8FEF8D8A366300B0012

3C76B1E2FDFBDEAC6F370F000D346CA9DCFAFDE4B4793F1300092D63A0D5F7FFE9BC82471801

06265B97CEF4FFEEC48B4F1E030420528EC7F0FFF3CC94582405021A4985BFEBFFF6D39D602B

080015417CB7E6FEF9DAA669320C00103973AFE0FCFCE0AE723910000C326AA6DAF9FEE6B77C

411500082B619DD3F6FFEBBF85491A0205245894CCF3FFF0C78E522003031E4F8BC4EEFFF4CE

975A260601184782BCE9FFF7D5A0632D0900133F79B4E4FDFADCA96C340D000F3770ACDEFBFD

E2B1753C11000B3067A3D8F8FEE8BA7F44160107295E9AD1F5FFEDC2884C1C0204225591C9F1

FFF1C991552204021C4C88C2EDFFF5D19A5D28070117447FBAE8FEF8D7A3662F0A00123C76B2

E2FDFBDEAB6F370E000D356DA9DCFAFDE4B4783E1300092D64A0D5F7FFE9BC8246180106275B

97CEF4FFEEC48B4F1E030420528EC7F0FFF2CC94572405021A4A85BFEBFFF6D39D602B080015

417CB7E6FEF9DAA669320C00103A73AFE0FCFCE0AE723910000C326AA6DAF9FEE6B77B411500

082B619DD3F6FFEBBF85491A0105245894CCF3FFF0C78E522003031E4F8BC5EEFFF4CE975A26

0601184782BDEAFFF7D5A0632D0900133F79B4E4FDFADCA86C340D000F3770ACDEFBFCE2B175

3C11000B3067A3D8F9FEE7B97E44160107295E9AD1F5FFECC1884C1C0204225591CAF1FFF1C9

91542204021C4D88C2EDFFF5D09A5D28070117447FBAE8FEF8D7A3662F0A00123C76B2E2FDFB

DEAB6F370E000D356DA9DCFAFDE4B4783E1300092D64A0D6F8FFE9BC8146180106275B97CFF4

FFEEC48B4F1E030420528EC7F0FFF2CC94572405021A4A85BFEBFFF6D39D602B080015427CB7

E6FEF9D9A569320C00103A73AFE0FCFCE0AE723910000C326AA6DAFAFEE6B77B411500082B61

9DD3F6FFEBBF84491A0105255895CCF3FFEFC68E512003031E4F8BC5EEFFF4CE975A26060119

4782BDEAFFF7D5A0632D0900133F79B5E4FDFADCA86C340D000F3770ACDEFBFCE2B1753C1100

0B3067A3D8F9FEE7B97E43160107295E9BD1F5FFECC1874C1C0204225592CAF1FFF1C9905422

04021C4D88C2EDFFF5D09A5D28070117447FBAE8FEF8D7A2662F0A00123C76B2E2FDFBDEAB6F

360E000D356DA9DCFAFDE4B4783E13000A2E64A1D6F8FFE9BC8146180106275B98CFF4FFEEC4

8A4E1E030420528FC7F0FFF2CB93572405021B4A85C0EBFFF6D39C602A080015427CB8E6FEF9

D9A569310C00103A73AFE0FCFCE0AE723910000C326AA7DAFAFEE5B67B411400082B619ED4F7

FFEBBE84491A0105255895CCF3FFEFC68D512003031E508CC5EFFFF4CE965A260601194782BD

EAFFF7D59F632D0900143F79B5E4FDFADBA86C340D000F3770ACDEFBFCE2B1753B11000B3067

A4D8F9FEE7B97E43160107295E9BD1F5FFECC1874C1C0205235592CAF2FFF1C990542204021D

4D89C2EDFFF5D0995D28070117457FBAE8FEF8D7A2662F0A00123D76B2E2FDFBDDAB6F360E00

0D356DAADCFAFDE3B3783E13000A2E64A1D6F8FEE9BC8146180106275B98CFF4FFEEC48A4E1D

030421538FC8F0FFF2CB93572405021B4A86C0EBFFF6D29C602A080015427CB8E6FEF9D9A569

310B00103A73AFE1FCFCDFAE723910000C336AA7DAFAFEE5B67B411400082B619ED4F7FFEBBE

84491A0105255895CDF3FFEFC68D511F03031F508CC5EFFFF3CE965A260601194783BDEAFFF7

D59F632C0900143F7AB5E4FDFADBA86C340D000F3870ADDFFBFCE1B1753B11000B3067A4D8F9

FEE7B97E43160007295E9BD1F5FFECC1874B1B0205235692CAF2FFF1C990542104021D4D89C2

EDFFF5D0995D280701174580BBE8FEF8D7A2662F0A00123D77B2E3FDFBDDAB6F360E000E356D

AADDFBFDE3B3783E13000A2E64A1D6F8FEE9BC8146180106275C98CFF4FFEEC38A4E1D030421

538FC8F0FFF2CB93572305021B4A86C0ECFFF6D29C5F2A080015427DB8E6FEF9D9A568310B00

113A74AFE1FCFCDFAE723910000C336AA7DAFAFEE5B67B401400092C619ED4F7FFEABE84481A

0105255995CDF3FFEFC68D511F03031F508CC5EFFFF3CD965A260601194883BDEAFFF7D49F62

2C090014407AB5E5FDFADBA86B340D000F3871ADDFFBFCE1B0743B11000B3068A4D8F9FEE7B9

7E43160007295F9BD2F6FFECC1874B1B0205235692CAF2FFF1C890542104021D4D89C3EDFFF5

D0995C280701174580BBE8FEF8D7A2652F0A00123D77B2E3FDFBDDAB6E360E000E356EAADDFB

FDE3B3773E13000A2E65A1D6F8FEE9BB8146180106275C98CFF4FFEEC38A4E1D030421538FC8

F0FFF2CB93572305021B4B86C0ECFFF6D29C5F2A080015427DB8E7FEF9D9A568310B00113A74

B0E1FCFCDFAD71380F000C336BA7DBFAFEE5B67A401400092C629ED4F7FFEABE844819010625

5995CDF3FFEFC68D511F03031F508CC5EFFFF3CD9659250601194883BDEAFFF7D49F622C0900

14407AB5E5FDFADBA86B330D000F3871ADDFFBFCE1B0743B11000B3168A4D8F9FEE7B97D4316

00082A5F9BD2F6FFECC1874B1B0205235692CAF2FFF1C890542104021D4D89C3EDFFF5D0995C

280701174580BBE8FEF8D7A2652E0A00123D77B3E3FDFBDDAA6E360E000E356EAADDFBFDE3B3

773D12000A2E65A1D6F8FEE9BB8045180107275C98CFF4FFEEC38A4E1D020421538FC8F0FFF2

CB93562305021B4B86C0ECFFF6D29C5F2A080016427DB8E7FEF9D9A568310B00113B74B0E1FC

FCDFAD71380F000C336BA7DBFAFDE5B67A401400092C629ED4F7FFEABE8348190106255995CD

F3FFEFC68D511F03031F508CC6EFFFF3CD9659250601194883BEEAFFF7D49F622C090014407A

B6E5FDFADBA76B330C000F3871ADDFFBFCE1B0743B11000B3168A4D9F9FEE7B87D431600082A

5F9CD2F6FFECC0864B1B0205235693CBF2FFF0C890532104021D4E89C3EDFFF4CF995C270701

174580BBE8FEF8D6A1652E0A00123D77B3E3FDFBDDAA6E360E000E366EAADDFBFDE3B3773D12

000A2E65A2D6F8FEE8BB8045170107275C99D0F4FFEDC3894E1D0204215390C8F0FFF2CB9256

2305021B4B86C0ECFFF6D29C5F2A080016437DB8E7FEF9D9A468310B00113B74B0E1FCFBDFAD

71380F000C336BA7DBFAFDE5B57A401400092C629FD4F7FFEABE8348190106255996CDF3FFEF

C58C501F03031F518DC6EFFFF3CD9559250601194883BEEAFFF7D49E622C090014407AB6E5FD

FADBA76B330C000F3871ADDFFCFCE1B0743B11000B3168A5D9F9FEE7B87D421600082A5F9CD2

F6FFECC0864B1B0205235693CBF2FFF0C88F532104021D4E8AC3EEFFF4CF985C270701184580

BBE9FEF8D6A1652E0A00123D77B3E3FDFBDDAA6E350E000E366EAADDFBFDE3B3773D12000A2F

65A2D7F8FEE8BB8045170107285C99D0F5FFEDC3894D1D0204215490C8F1FFF2CA9256230502

1B4B87C1ECFFF6D29B5F2A080016437DB9E7FEF9D8A468310B00113B74B0E1FCFBDFAD71380F

000D336BA8DBFAFDE5B57A401400092C629FD4F7FFEABD8348190106255996CDF3FFEFC58C50

1F03031F518DC6EFFFF3CD9559250601194884BEEAFFF7D49E622C090014407AB6E5FEFADBA7

6B330C000F3871ADDFFCFCE1B0743A11000B3168A5D9F9FEE6B87D421500082A5F9CD2F6FFEC

C0864B1B0205235793CBF2FFF0C88F532104031D4E8AC3EEFFF4CF985C270601184681BBE9FE

F8D6A1652E0A00133E77B3E3FDFBDDAA6E350E000E366EABDDFBFDE3B2773D12000A2F65A2D7

F8FEE8BB8045170107285C99D0F5FFEDC3894D1D0204215490C8F1FFF2CA92562305021B4B87

C1ECFFF6D29B5F29070016437EB9E7FEF9D8A467300B00113B75B0E1FCFBDFAD71380F000D34

6BA8DBFAFDE5B57A401400092C629FD5F7FFEABD8348190106265A96CDF3FFEFC58C501F0303

1F518DC6EFFFF3CD95592505011A4984BEEAFFF7D49E612C090014407BB6E5FEFADAA76A330C

00103972AEDFFCFCE1AF743A11000B3168A5D9F9FEE6B87D421500082A609CD2F6FFECC0864A

1B0205245793CBF2FFF0C88F532104031D4E8AC3EEFFF4CF985B270601184681BCE9FEF8D6A1

642E0A00133E78B3E3FDFBDDAA6D350E000E366FABDDFBFDE3B2773D12000A2F66A2D7F8FEE8

BA8045170107285D99D0F5FFEDC2894D1D0204215490C9F1FFF2CA92562305021B4B87C1ECFF

F5D19B5E29070016437EB9E7FEF9D8A467300B00113B75B1E1FCFBDFAC70380F000D346CA8DB

FAFDE4B5793F1400092D639FD5F7FFEABD8347190106265A96CEF3FFEFC58C501F03031F518D

C6EFFFF3CD95582505011A4984BEEBFFF7D49E612B080014417BB6E5FEFADAA76A330C001039

72AEDFFCFCE1AF733A10000B3169A5D9F9FEE6B87C421500082A609CD2F6FFEBC0864A1B0205

245793CBF2FFF0C78F532104031D4E8AC4EEFFF4CF985B270601184681BCE9FEF8D6A1642E0A

00133E78B3E3FDFADCAA6D350D000E366FABDDFBFDE2B2763D12000A2F66A2D7F8FEE8BA7F45

170107285D99D0F5FFEDC2894D1C0204225490C9F1FFF1CA92552304021C4C87C1ECFFF5D19B

5E290701164367B7F1FEDA92430C022972C1F5FCD287390705327ECAF9F9C97C3004083B89D3

FCF5BF7128020D4594DBFEF0B5662000124F9FE3FFEAAB5B19001859AAE9FFE3A05013001F64

B4EFFEDC95460D01276FBEF4FDD48A3C09042F7AC8F8FACB7F3305073886D1FCF6C2742A020B

4291D9FEF1B8692200104C9CE1FFECAE5E1B001656A7E7FFE5A35314001D61B1EEFFDE98490F

01256CBBF3FDD68D3F0A032D77C5F7FBCE823506063683CEFBF7C5772D030A3F8ED7FDF3BB6C

24010F4999DEFFEDB1611D001554A4E6FFE7A65616001B5EAEECFFE09B4C10002369B8F1FED9

90420B022B74C2F6FBD085380705337FCCFAF8C77A2F04093D8BD4FDF4BE6F27010D4696DCFF

EFB4641F001351A1E4FFE9A9591800195BABEAFFE29E4E12002066B6F0FEDB93440C022871C0

F5FCD3883B0804317CC9F9F9CA7D3104083A87D2FCF5C07229020C4493DAFEF0B6672100114E

9EE2FFEBAC5C1A001758A8E9FFE4A15113001E63B3EEFFDD97470E01266EBDF4FDD58B3D0903

2E79C6F8FACC803405073784CFFBF6C3752B020B4190D8FEF2B96A2301104B9BE0FFECAF5F1C

001655A5E7FFE6A45415001C60B0EDFFDF9A4A0F01246BBAF2FDD78F400A032C76C4F7FBCF83

3706063581CDFAF8C6782E03093E8CD6FDF3BC6D25010E4897DEFFEEB2621E001452A2E5FFE8

A75717001A5DADEBFFE19D4D11002268B7F1FED992430C022A73C1F6FCD187390705327ECAF9

F9C87B3004083B89D3FCF5BF7028010D4594DBFEF0B5652000124F9FE3FFEAAA5A1900185AAA

EAFFE3A05012002065B4EFFEDC95460D012770BEF4FCD48A3C0804307BC8F8FACB7E33050739

86D1FCF6C1732A020B4291D9FEF1B8682200114C9CE1FFEBAD5D1B001757A7E8FFE5A3531400

1D62B2EEFFDE98480E01256DBCF3FDD68D3E0A032D78C5F7FBCD823506063683CEFBF7C4762C

030A408ED7FDF2BA6B24010F4A99DFFFEDB0601D001554A4E6FFE7A65616001B5FAFECFFE09B

4B1000236AB9F2FED890410B022B75C3F6FBD0853807053480CCFAF8C77A2F03093D8BD5FDF4

BD6E26010E4796DDFFEFB3631F001351A1E4FFE9A95918001A5CACEBFFE29E4E12002166B6F0

FEDA93440C022972C0F5FCD2883A0804317DC9F9F9C97D3104083A88D2FCF5C07129020C4493

DAFEF0B6662100124E9EE2FFEAAC5C1A001859A9E9FFE4A15113001F63B3EFFFDD96470E0126

6EBDF4FDD58B3D09032F7AC7F8FACC803405073885D0FBF6C3752B020B4190D8FEF2B96A2300

104B9BE0FFECAF5F1B001656A6E7FFE6A45415001D60B0EDFFDF994A0F01246BBAF2FDD78E40

0A032C76C4F7FBCE833606063582CDFBF7C5782D030A3E8DD6FDF3BC6D25010E4898DEFFEEB2

621D001453A3E5FFE8A75717001B5DADEBFFE19C4C11002268B8F1FED991420B022A73C2F6FC

D186390705337FCBFAF8C87B3004083C8AD4FDF4BE7027010D4695DCFEEFB4651F001250A0E3

FFE9AA5A1800195AAAEAFFE39F4F12002065B5F0FEDB94450D012870BFF5FCD3893B0804307B

C8F9F9CA7E3205073987D1FCF6C1732A020C4392DAFEF1B7682200114D9DE1FFEBAD5D1A0017

57A8E8FFE5A25214001E62B2EEFFDE97480E01256DBCF3FDD68C3E09032E78C6F8FACD813506

063783CFFBF7C4762C030A408FD7FDF2BA6B24010F4A9ADFFFEDB0601C001554A5E6FFE7A555

16001C5FAFECFFE09A4B1001236AB9F2FED88F410B022B75C3F6FBCF843707053480CCFAF8C6

792E03093D8BD5FDF4BD6E26010E4797DDFFEEB3631E001351A1E4FFE8A85817001A5CACEBFF

E29E4E11002167B6F0FEDA93440C022972C0F5FCD2873A0804327DCAF9F9C97C3104083B88D3

FCF5C07128020C4493DBFEF0B6662000124F9EE2FFEAAB5B19001859A9E9FFE4A15113001F64

B4EFFFDC96460D01276FBEF4FDD48B3D09042F7AC7F8FACC7F3305073885D0FBF6C2742B020B

4290D9FEF1B8692300104C9BE0FFECAE5E1B001656A6E7FFE6A45315001D61B1EDFFDE99490F

01246CBBF3FDD78E3F0A032D77C5F7FBCE833606063582CEFBF7C5772D030A3F8DD6FDF3BB6C

25010F4998DEFFEEB1611D001453A3E5FFE7A75616001B5EAEECFFE19C4C10002269B8F1FED9

91420B022A74C2F6FCD086380705337FCBFAF8C87A2F04093C8AD4FDF4BE6F27010D4695DCFE

EFB4641F001350A0E3FFE9AA591800195BABEAFFE39F4F12002066B5F0FEDB94450D022871BF

F5FCD3893B0804307CC9F9F9CA7E3205083A87D2FCF5C17229020C4392DAFEF1B7672100114D

9DE1FFEBAD5C1A001758A8E8FFE4A25214001E63B2EEFFDD97480E01266EBCF3FDD58C3E0903

2E79C6F8FACD813405063784CFFBF7C3762C030B408FD8FEF2BA6A2301104A9ADFFFEDAF5F1C

001555A5E6FFE6A55515001C5FAFEDFFDF9A4A1001236ABAF2FED88F400B032C76C3F7FBCF84

3706053481CDFAF8C6792E03093E8CD5FDF3BC6E26010E4897DDFFEEB2621E001452A2E5FFE8

A85817001A5CADEBFFE19D4D11002167B7F1FEDA92430C022972C1F5FCD2873A0705327ECAF9

F9C97C3004083B89D3FCF5BF7128020D4594DBFEF0B5662000124F9FE3FFEAAB5B19001859AA

E9FFE3A05013001F64B4EFFEDC95460D01276FBEF4FDD48A3C09042F7AC8F8FACB7F33050738

86D1FCF6C2742A020B4291D9FEF1B8692200104C9CE1FFECAE5E1B001656A7E7FFE5A3531400

1D61B1EEFFDE98490F01256CBBF3FDD68D3F0A032D77C5F7FBCE823506063683CEFBF7C5772D

030A3F8ED7FDF3BB6C24010F4999DEFFEDB1611D001554A4E6FFE7A65616001B5EAEECFFE09B

4C10002369B8F1FED990420B022B74C2F6FBD085380705337FCCFAF8C77A2F04093D8BD4FDF4

BE6F27010D4696DCFFEFB4641F001351A1E4FFE9A9591800195BABEAFFE29E4E12002066B6F0

FEDB93440C022871C0F5FCD3883B0804317CC9F9F9CA7D3104083A87D2FCF5C07229020C4493

DAFEF0B6672100114E9EE2FFEBAC5C1A001758A8E8FFE4A15113001E63B3EEFFDD97470E0126

6EBDF4FDD58B3D09032E79C6F8FACC803405073784CFFBF6C3752B020B418FD8FEF2B96A2301

104B9BE0FFECAF5F1C001655A5E7FFE6A45415001C60B0EDFFDF9A4A0F01246BBAF2FDD78F40

0A032C76C4F7FBCF833706063581CDFAF8C6782E03093E8CD6FDF3BC6D25010E4897DEFFEEB2

621E001452A2E5FFE8A75717001A5DADEBFFE19D4D11002268B7F1FED992430C022A73C1F6FC

D187390705327ECAF9F9C87B3004083B89D3FCF5BF7028010D4594DBFEF0B5652000124F9FE3

FFEAAA5A1900185AAAEAFFE3A05012002065B4EFFEDC95460D012770BEF4FCD48A3C0804307B

C8F8FACB7E3305073986D1FCF6C1732A020B4291D9FEF1B8682200114C9CE1FFEBAD5D1B0017

57A7E8FFE5A35314001D62B2EEFFDE98480E01256DBCF3FDD68D3E0A032D78C5F7FBCD823506

063683CEFBF7C4762C030A408ED7FDF2BA6B24010F4A99DFFFEDB0601D001554A4E6FFE7A656

16001B5FAFECFFE09B4B1000236AB9F2FED890410B022B75C3F6FBD0853807053480CCFAF8C7

7A2F03093D8BD5FDF4BD6E26010E4796DDFFEFB3631F001351A1E4FFE9A95918001A5CACEBFF

E29E4E12002166B6F0FEDA93440C022972C0F5FCD2883A0804317DC9F9F9C97D3104083A88D2

FCF5C07229020C4493DAFEF0B6662100124E9EE2FFEAAC5C1A001859A9E9FFE4A15113001F63

B3EFFFDD96470E01266EBDF4FDD58B3D09032F7AC7F8FACC803405073885D0FBF6C3752B020B

4190D8FEF2B96A2300104B9BE0FFECAF5F1B001656A6E7FFE6A45415001D60B0EDFFDF994A0F

01246BBAF2FDD78E400A032C76C4F7FBCE833606063582CDFBF7C5782D030A3E8DD6FDF3BC6D

25010E4898DEFFEEB2621D001453A3E5FFE8A75717001B5DADEBFFE19C4C11002268B8F1FED9

91420B022A73C2F6FCD186390705337FCBFAF8C87B3004083C8AD4FDF4BE7027010D4695DCFE

EFB4651F001250A0E3FFE9AA5A1800195AAAEAFFE39F4F12002065B5F0FEDB94450D012870BF

F5FCD3893B0804307BC8F9F9CA7E3205073987D1FCF6C1732A020C4392DAFEF1B7682200114D

9DE1FFEBAD5D1A001757A7E8FFE5A25214001E62B2EEFFDE97480E01256DBCF3FDD68C3E0903

2E78C6F8FACD813506063783CFFBF7C4762C030A408FD7FDF2BA6B24010F4A9ADFFFEDB0601C

001554A5E6FFE7A55516001C5FAFECFFE09B4B1001236AB9F2FED88F410B022B75C3F6FBCF84

3707053480CCFAF8C6792E03093D8BD5FDF4BD6E26010E4797DDFFEEB3631E001351A1E4FFE8

A85817001A5CACEBFFE29E4E11002167B6F0FEDA93440C022972C0F5FCD2873A0804317DCAF9

F9C97C3104083B88D3FCF5C07128020C4493DBFEF0B6662000124F9EE2FFEAAB5B19001859A9

E9FFE4A15113001F64B4EFFFDC96460D01276FBEF4FDD48B3D09042F7AC7F8FACC7F33050738

85D0FBF6C2742B020B4290D9FEF1B8692300104C9BE0FFECAE5E1B001656A6E7FFE6A4531500

1D61B1EDFFDE99490F01246CBBF3FDD78E3F0A032D77C5F7FBCE833606063582CEFBF7C5772D

030A3F8DD6FDF3BB6C25010F4998DEFFEEB1611D001453A3E5FFE7A75616001B5EAEECFFE19C

4C10002269B8F1FED991420B022A74C2F6FCD086380705337FCBFAF8C87A2F04093C8AD4FDF4

BE6F27010D4695DCFEEFB4641F001350A0E3FFE9AA591800195BABEAFFE39F4F12002066B5F0

FEDB94450D022871BFF5FCD3893B0804307CC9F9F9CA7E3205073A87D2FCF5C17229020C4392

DAFEF1B7672100114D9DE1FFEBAD5C1A001758A8E8FFE4A25214001E63B2EEFFDD97480E0126

6EBCF3FDD58C3E09032E79C6F8FACD813405063784CFFBF7C3762C030B408FD8FEF2BA6A2301

104A9ADFFFEDAF5F1C001555A5E6FFE6A55515001C7EB9E7FEF9D8A468300B00113B74B0E1FC

FBDFAD71380F000D336BA8DBFAFDE5B57A401400092C629FD4F7FFEABD8348190106265996CD

F3FFEFC58C501F03031F518DC6EFFFF3CD9559250601194884BEEAFFF7D49E622C090014407B

B6E5FEFADBA76B330C000F3871AEDFFCFCE1B0743A11000B3168A5D9F9FEE6B87D421500082A

5F9CD2F6FFECC0864A1B0205235793CBF2FFF0C88F532104031D4E8AC3EEFFF4CF985C270601

184681BBE9FEF8D6A1642E0A00133E78B3E3FDFBDDAA6D350E000E366EABDDFBFDE3B2773D12

000A2F65A2D7F8FEE8BB8045170107285D99D0F5FFEDC3894D1D0204215490C9F1FFF2CA9256

2305021B4B87C1ECFFF5D19B5E29070016437EB9E7FEF9D8A467300B00113B75B0E1FCFBDFAD

70380F000D346BA8DBFAFDE5B57A3F1400092C639FD5F7FFEABD8348190106265A96CEF3FFEF

C58C501F03031F518DC6EFFFF3CD95592505011A4984BEEBFFF7D49E612C090014407BB6E5FE

FADAA76A330C00103972AEDFFCFCE1AF733A10000B3169A5D9F9FEE6B87D421500082A609CD2

F6FFECC0864A1B0205245793CBF2FFF0C88F532104031D4E8AC4EEFFF4CF985B270601184681

BCE9FEF8D6A1642E0A00133E78B3E3FDFBDCAA6D350E000E366FABDDFBFDE3B2763D12000A2F

66A2D7F8FEE8BA8045170107285D99D0F5FFEDC2894D1D0204225490C9F1FFF2CA9256230502

1C4B87C1ECFFF5D19B5E29070116437EB9E7FEF9D8A467300B00113B75B1E1FCFBDEAC70380F

000D346CA8DBFAFDE4B5793F1400092D639FD5F7FFEABD8347190106265A96CEF4FFEFC58C50

1E030320518DC6EFFFF3CC95582505011A4984BEEBFFF7D49E612B080014417BB6E5FEFADAA7

6A330C00103972AEE0FCFCE0AF733A10000B3169A5D9F9FEE6B87C421500082A609CD2F6FFEB

C0864A1B0205245793CBF2FFF0C78F532004031E4E8AC4EEFFF4CF985B270601184681BCE9FF

F8D6A1642E0A00133E78B4E4FDFADCA96D350D000E366FABDEFBFDE2B2763D12000A2F66A2D7

F8FEE8BA7F45170107285D99D0F5FFEDC2894D1C0204225490C9F1FFF1CA92552204021C4C87

C1ECFFF5D19B5E29070116437EB9E7FEF9D8A467300B00113B75B1E2FCFBDEAC70370F000D34

6CA8DBFAFDE4B5793F1300092D639FD5F7FFEABD8247190106265A97CEF4FFEFC58C501E0303

20518DC6EFFFF3CC95582505011A4984BFEBFFF6D39E612B080015417BB6E5FEFADAA66A320C

00103972AEE0FCFCE0AF733A10000C3269A5D9F9FEE6B77C421500082A609DD3F6FFEBBF854A

1A0205245794CBF2FFF0C78E522004031E4F8AC4EEFFF4CF985B270601184681BCE9FFF8D6A0

642E0900133E78B4E4FDFADCA96D350D000E376FABDEFBFDE2B2763C12000A2F66A3D7F8FEE8

BA7F44170107285D9AD0F5FFEDC2884D1C0204225491C9F1FFF1CA91552204021C4C87C1ECFF

F5D19A5E29070116447EB9E7FEF9D8A367300B00113C75B1E2FCFBDEAC70370F000D346CA8DC

FAFDE4B5793F1300092D63A0D5F7FFEABD8247190106265A97CEF4FFEEC58B4F1E030320528E

C7F0FFF3CC94582405011A4984BFEBFFF6D39D612B080015417BB7E6FEF9DAA66A320C001039

72AEE0FCFCE0AF733A10000C3269A6DAF9FEE6B77C421500082B609DD3F6FFEBBF854A1A0205

245794CCF2FFF0C78E522004031E4F8BC4EEFFF4CF975B270601184682BCE9FFF7D6A0642D09

00133E78B4E4FDFADCA96D350D000E376FABDEFBFDE2B2763C12000A2F66A3D7F8FEE8BA7F44

170107285D9AD0F5FFEDC2884C1C0204225591C9F1FFF1CA91552204021C4C88C1EDFFF5D19A

5E29070116447FB9E7FEF8D8A367300B00113C75B1E2FDFBDEAC70370F000D346CA9DCFAFDE4

B4793F1300092D63A0D5F7FFE9BD8247180106265A97CEF4FFEEC48B4F1E030320528EC7F0FF

F3CC94582405021A4985BFEBFFF6D39D612B080015417CB7E6FEF9DAA66A320C00103972AEE0

FCFCE0AF733A10000C3269A6DAF9FEE6B77C411500082B609DD3F6FFEBBF854A1A0205245894

CCF2FFF0C78E522004031E4F8BC4EEFFF4CE975B260601184782BCE9FFF7D5A0642D0900133F

79B4E4FDFADCA96D340D000F376FACDEFBFDE2B1763C12000A2F66A3D7F8FEE8BA7F44170107

295D9AD1F5FFEDC2884C1C0204225591C9F1FFF1C991552204021C4C88C2EDFFF5D19A5E2907

0117447FBAE8FEF8D8A366300B00123C76B1E2FDFBDEAC70370F000D346CA9DCFAFDE4B4793F

1300092D63A0D5F7FFE9BC8247180106265B97CEF4FFEEC48B4F1E030420528EC7F0FFF3CC94

582405021A4985BFEBFFF6D39D602B080015417CB7E6FEF9DAA669320C00103973AFE0FCFCE0

AE723910000C3269A6DAF9FEE6B77C411500082B619DD3F6FFEBBF85491A0205245894CCF3FF

F0C78E522003031E4F8BC4EEFFF4CE975A260601184782BCE9FFF7D5A0632D0900133F79B4E4

FDFADCA96C340D000F3770ACDEFBFDE2B1753C11000B3067A3D8F8FEE8BA7F44160107295E9A

D1F5FFEDC2884C1C0204225591C9F1FFF1C991552204021C4C88C2EDFFF5D19A5D2807011744

7FBAE8FEF8D7A3662F0A00123C76B2E2FDFBDEAC6F370E000D356DA9DCFAFDE4B4783E130009

2D64A0D5F7FFE9BC8247180106265B97CEF4FFEEC48B4F1E030420528EC7F0FFF2CC94572405

021A4A85BFEBFFF6D39D602B080015417CB7E6FEF9DAA669320C00103A73AFE0FCFCE0AE7239

10000C326AA6DAF9FEE6B77B411500082B619DD3F6FFEBBF85491A0205245894CCF3FFF0C78E

522003031E4F8BC5EEFFF4CE975A260601184782BDEAFFF7D5A0632D0900133F79B4E4FDFADC

A96C340D000F3770ACDEFBFCE2B1753C11000B3067A3D8F9FEE7B97E44160107295E9AD1F5FF

ECC1884C1C0204225591CAF1FFF1C991542204021C4D88C2EDFFF5D09A5D28070117447FBAE8

FEF8D7A3662F0A00123C76B2E2FDFBDEAB6F370E000D356DA9DCFAFDE4B4783E1300092D64A0

D6F8FFE9BC8146180106275B97CFF4FFEEC48B4F1E030420528EC7F0FFF2CC94572405021A4A

85BFEBFFF6D39D602B080015427CB7E6FEF9D9A569320C00103A73AFE0FCFCE0AE723910000C

326AA6DAFAFEE6B77B411500082B619DD3F6FFEBBF84491A0105255895CCF3FFF0C68E512003

031E4F8BC5EEFFF4CE975A260601194782BDEAFFF7D5A0632D0900133F79B5E4FDFADCA86C34

0D000F3770ACDEFBFCE2B1753C11000B3067A3D8F9FEE7B97E44160107295E9BD1F5FFECC187

4C1C0204225592CAF1FFF1C990542204021C4D88C2EDFFF5D09A5D28070117447FBAE8FEF8D7

A2662F0A00123C76B2E2FDFBDEAB6F360E000D356DA9DCFAFDE4B4783E13000A2E64A1D6F8FF

E9BC8146180106275B98CFF4FFEEC48A4E1E030420528FC7F0FFF2CB93572405021B4A85C0EB

FFF6D39C602A080015427CB7E6FEF9D9A569310C00103A73AFE0FCFCE0AE723910000C326AA6

DAFAFEE5B67B411400082B619ED3F7FFEBBE84491A0105255895CCF3FFEFC68D512003031E50

8CC5EFFFF4CE965A260601194782BDEAFFF7D59F632D0900143F79B5E4FDFADBA86C340D000F

3770ACDEFBFCE2B1753B11000B3067A4D8F9FEE7B97E43160107295E9BD1F5FFECC1874C1C02

04235592CAF1FFF1C990542204021D4D89C2EDFFF5D0995D28070117457FBAE8FEF8D7A2662F

0A00123D76B2E2FDFBDDAB6F360E000D356DAADCFAFDE3B3783E13000A2E64A1D6F8FEE9BC81

46180106275B98CFF4FFEEC48A4E1D030421538FC8F0FFF2CB93572405021B4A86C0EBFFF6D2

9C602A080015427CB8E6FEF9D9A569310B00103A73AFE1FCFCDFAE723910000C336AA7DAFAFE

E5B67B411400082B619ED4F7FFEBBE84491A0105255895CDF3FFEFC68D511F03031F508CC5EF

FFF3CE965A260601194783BDEAFFF7D59F632C0900143F79B5E4FDFADBA86C340D000F3870AD

DFFBFCE1B1753B11000B3067A4D8F9FEE7B97E43160007295E9BD1F5FFECC1874B1B02052356

92CAF2FFF1C990542104021D4D89C2EDFFF5D0995D280701174580BBE8FEF8D7A2662F0A0012

3D77B2E3FDFBDDAB6F360E000E356DAADDFBFDE3B3783E13000A2E64A1D6F8FEE9BC81461801

06275C98CFF4FFEEC38A4E1D030421538FC8F0FFF2CB93572305021B4A86C0ECFFF6D29C5F2A

080015427DB8E6FEF9D9A568310B00113A74AFE1FCFCDFAE723910000C336AA7DAFAFEE5B67B

401400092C619ED4F7FFEABE84491A0105255995CDF3FFEFC68D511F03031F508CC5EFFFF3CD

965A260601194883BDEAFFF7D59F622C090014407AB5E5FDFADBA86B340D000F3871ADDFFBFC

E1B0743B11000B3068A4D8F9FEE7B97E43160007295F9BD2F6FFECC1874B1B0205235692CAF2

FFF1C890542104021D4D89C3EDFFF5D0995C280701174580BBE8FEF8D7A2652F0A00123D77B2

E3FDFBDDAB6E360E000E356EAADDFBFDE3B3773E13000A2E65A1D6F8FEE9BB8146180106275C

98CFF4FFEEC38A4E1D030421538FC8F0FFF2CB93572305021B4B86C0ECFFF6D29C5F2A080015

427DB8E6FEF9D9A568310B00113A74B0E1FCFCDFAD71380F000C336BA7DBFAFEE5B67A401400

092C629ED4F7FFEABE8448190106255995CDF3FFEFC68D511F03031F508CC5EFFFF3CD965925

0601194883BDEAFFF7D49F622C090014407AB5E5FDFADBA86B330D000F3871ADDFFBFCE1B074

3B11000B3168A4D8F9FEE7B97D431600082A5F9BD2F6FFECC1874B1B0205235692CAF2FFF1C8

90542104021D4D89C3EDFFF5D0995C280701174580BBE8FEF8D7A2652E0A00123D77B3E3FDFB

DDAA6E360E000E356EAADDFBFDE3B3773D12000A2E65A1D6F8FEE9BB8045180107275C98CFF4

FFEEC38A4E1D020421538FC8F0FFF2CB93562305021B4B86C0ECFFF6D29C5F2A080016425484

B3DBF6FFF7DDB586562C0E00051B406E9FCBECFEFDEAC89B6B3D1904000F2F598AB9DFF8FFF4

D8B08050270B00071F4674A5D0EFFEFBE7C395653816020112335F90BEE3FAFFF2D4AA7A4B23

090009234B7AAAD4F2FFFAE3BE8F5F3312010216386596C3E7FCFEEFCFA474451F07000B2851

80B0D9F5FFF8DFB889592E0F0004193D6B9CC8EAFDFDECCB9E6E401B05000E2C5686B6DDF7FF

F6DBB383532A0C00061D4371A2CDEDFEFCE8C699683B17030111315C8CBBE1F9FFF3D6AD7D4E

250A0008214877A7D2F0FFFBE5C093623614020214366292C0E5FBFFF0D2A777482108000A25

4E7DADD6F3FFF9E1BB8D5C31110103173B6898C5E8FCFEEECDA271431D06000C2A5383B3DBF6

FFF7DDB687562C0E00051B406E9ECAECFDFDEAC89C6B3D1904000F2E5989B8DFF8FFF5D9B080

51280B00071F4574A4CFEFFEFCE7C396653816030112335F8FBDE3FAFFF2D4AA7A4B23090009

234B7AAAD4F2FFFAE3BE905F3313010215386595C3E6FBFEEFD0A574461F07000B275080B0D8

F4FFF8DFB98A592F0F0004193D6B9BC8EAFDFEECCB9F6E401B05000E2C5686B5DDF7FFF6DBB3

84542A0D00051D4271A1CDEDFEFCE9C699683B18030111305C8CBBE1F9FFF3D7AE7E4E260A00

07214877A7D1F0FFFBE5C193623614020214356192C0E5FBFFF1D2A878492108000A254D7DAD

D6F3FFF9E1BC8D5D31110103173A6798C5E8FCFEEECEA272431D06000C295383B2DAF5FFF7DD

B687572C0E00051B3F6D9ECAEBFDFDEBC99C6C3E1A04000F2E5889B8DFF8FFF5D9B18151280B

00061F4573A4CFEFFEFCE7C496663916030112335E8FBDE2FAFFF2D5AB7B4C24090008234A79

AAD4F2FFFAE3BE90603413010215376495C2E6FBFFEFD0A575462007000B27507FAFD8F4FFF8

E0B98A5A2F100104193D6A9BC7EAFDFEECCB9F6F411C05000D2B5585B5DCF6FFF6DBB484542A

0D00051C4270A1CCEDFEFCE9C699693C18030110305B8CBAE0F9FFF4D7AE7E4F260A00072047

76A6D1F0FFFBE5C194633615020213356192BFE4FAFFF1D3A878492208000A254D7CACD6F3FF

F9E2BC8E5D32110103173A6798C5E8FCFEEECEA372441E06000C295282B2DAF5FFF7DEB78857

2D0E00041A3F6D9DCAEBFDFDEBC99D6C3E1A04000F2D5888B7DEF7FFF5D9B18152280C00061E

4473A3CFEEFEFCE7C497663916030112325E8EBDE2F9FFF2D5AB7B4C24090008224A79A9D3F1

FFFAE4BF91603413020215376494C2E6FBFFF0D0A675462007000B264F7FAFD8F4FFF8E0BA8B

5A2F100104183C6A9AC7E9FDFEEDCCA06F411C05000D2B5585B4DCF6FFF6DCB485552B0D0005

1C4170A0CCEDFEFDE9C79A693C18030110305B8BBAE0F8FFF4D7AE7F4F260B0007204776A6D1

F0FFFBE6C294633715020213346091BFE4FAFFF1D3A9794922080009244C7CACD5F3FFF9E2BC

8E5E3212010317396697C4E8FCFEEECEA373441E06000C295282B1DAF5FFF7DEB788582D0F00

041A3F6C9DC9EBFDFDEBC99D6D3F1A04000E2D5888B7DEF7FFF5DAB28252290C00061E4472A3

CEEEFEFCE8C497673A17030111325D8EBCE2F9FFF3D5AC7C4C24090008224978A9D3F1FFFAE4

BF91613513020215376394C1E6FBFFF0D1A676472007000A264F7EAED7F4FFF9E0BA8B5B3010

0103183C699AC7E9FCFEEDCCA070421C05000D2B5485B4DCF6FFF6DCB485552B0D00051C416F

A0CCECFEFDEAC79A6A3C190401102F5A8BB9E0F8FFF4D8AF7F4F270B0007204675A5D0F0FFFB

E6C294643715020113346091BFE4FAFFF1D3A9794A22080009244C7BABD5F2FFFAE2BD8F5E32

12010316396697C4E7FCFEEECFA373441E06000C285181B1D9F5FFF8DEB788582E0F00041A3E

6C9CC9EBFDFDEBCA9E6D3F1B04000E2D5787B6DEF7FFF5DAB28252290C00061E4372A2CEEEFE

FCE8C598673A17030111315D8DBCE2F9FFF3D6AC7C4D250A0008224978A8D2F1FFFAE4C09261

3514020214366393C1E5FBFFF0D1A776472107000A264E7EAED7F4FFF9E1BA8C5B3010010318

3B6999C6E9FCFEEDCCA170421D05000D2A5484B3DBF6FFF7DCB586562B0E00051C416F9FCBEC

FEFDEAC89B6A3D190400102F5A8AB9DFF8FFF4D8AF8050270B00071F4675A5D0EFFEFBE6C295

643815020113346090BEE3FAFFF2D4AA7A4A23090009234B7BABD5F2FFFAE3BD8F5E33120103

16396596C3E7FCFEEFCFA474451F06000B285181B0D9F5FFF8DFB889592E0F0004193E6B9CC8

EAFDFDECCA9E6E401B05000E2C5787B6DDF7FFF6DBB28353290C00061D4371A2CDEEFEFCE8C5

98683A17030111315C8DBBE1F9FFF3D6AD7D4D250A0008214877A8D2F1FFFBE5C09262351402

0214366293C1E5FBFFF0D2A777482108000A254E7DADD7F3FFF9E1BB8C5C31110103183B6899

C6E9FCFEEDCDA171421D06000D2A5484B3DBF6FFF7DDB586562C0E00051B406E9FCBECFDFDEA

C89B6B3D1904000F2E598AB8DFF8FFF4D9B08050270B00071F4574A5D0EFFEFBE7C395653816

020112335F90BEE3FAFFF2D4AA7A4B23090009234B7AAAD4F2FFFAE3BE8F5F33120102163865

96C3E7FBFEEFCFA474451F07000B275080B0D9F4FFF8DFB889592E0F0004193D6B9CC8EAFDFD

ECCB9F6E401B05000E2C5686B5DDF7FFF6DBB383532A0D00061D4371A1CDEDFEFCE9C699683B

17030111315C8CBBE1F9FFF3D7AD7D4E250A0008214877A7D2F0FFFBE5C19362361402021435

6292C0E5FBFFF1D2A877482108000A254D7DADD6F3FFF9E1BB8D5C31110103173A6898C5E8FC

FEEECDA271431D06000C295383B3DBF6FFF7DDB687562C0E00051B406E9ECAECFDFDEAC89C6B

3E1904000F2E5989B8DFF8FFF5D9B08151280B00061F4574A4CFEFFEFCE7C396653816030112

335F8FBDE3FAFFF2D4AB7B4B23090009234A7AAAD4F2FFFAE3BE905F3413010215386495C3E6

FBFEEFD0A575461F07000B275080AFD8F4FFF8DFB98A5A2F100004193D6A9BC8EAFDFEECCB9F

6F401B05000E2C5686B5DDF7FFF6DBB384542A0D00051D4270A1CDEDFEFCE9C699693B180301

10305B8CBAE1F9FFF3D7AE7E4E260A0007214776A7D1F0FFFBE5C193633614020214356192C0

E4FBFFF1D2A878492108000A254D7DACD6F3FFF9E1BC8D5D31110103173A6798C5E8FCFEEECE

A272431D06000C295383B2DAF5FFF7DDB687572D0E00051B3F6D9ECAEBFDFDEBC99C6C3E1A04

000F2E5889B8DEF8FFF5D9B18151280C00061E4573A4CFEFFEFCE7C496663916030112325E8F

BDE2FAFFF2D5AB7B4C24090008224A79A9D3F1FFFAE4BF90603413010215376495C2E6FBFFEF

D0A575462007000B27507FAFD8F4FFF8E0B98A5A2F100104193C6A9BC7EAFDFEECCBA06F411C

05000D2B5585B5DCF6FFF6DCB484542A0D00051C4270A0CCEDFEFCE9C69A693C18030110305B

8BBAE0F9FFF4D7AE7E4F260A0007204776A6D1F0FFFBE6C194633715020213356191BFE4FAFF

F1D3A8784922080009244D7CACD6F3FFF9E2BC8E5D32110103173A6797C5E8FCFEEECEA37244

1E06000C295282B2DAF5FFF7DEB788572D0E00041A3F6D9DCAEBFDFDEBC99D6C3E1A04000F2D

5888B7DEF7FFF5DAB18252280C00061E4473A3CEEEFEFCE7C497663916030112325E8EBDE2F9

FFF2D5AC7C4C24090008224A79A9D3F1FFFAE4BF91603413020215376494C2E6FBFFF0D1A675

472007000B264F7FAFD8F4FFF8E0BA8B5B2F100104183C699AC7E9FDFEEDCCA06F411C05000D

2B5585B4DCF6FFF6DCB485552B0D00051C416FA0CCEDFEFDE9C79A693C180401102F5B8BBAE0

F8FFF4D8AF7F4F260B0007204775A6D1F0FFFBE6C294643715020213346091BFE4FAFFF1D3A9

794A22080009244C7CACD5F2FFF9E2BD8E5E3212010316396697C4E7FCFEEECEA373441E0600

0C285282B1DAF5FFF7DEB788582D0F00041A3E6C9DC9EBFDFDEBCA9D6D3F1A04000E2D5788B7

DEF7FFF5DAB28252290C00061E4472A3CEEEFEFCE8C597673A17030111325D8EBCE2F9FFF3D6

AC7C4D24090008224978A8D3F1FFFAE4BF91613513020215376394C1E6FBFFF0D1A676472007

000A264F7EAED7F4FFF9E0BA8B5B30100103183C699AC6E9FCFEEDCCA070421C05000D2A5484

B4DCF6FFF6DCB585552B0D00051C416FA0CBECFEFDEAC79B6A3C190401102F5A8AB9E0F8FFF4

D8AF7F50270B0007204675A5D0EFFFFBE6C295643715020113346090BFE4FAFFF1D3A9794A22

080009244C7BABD5F2FFFAE2BD8F5E3212010316396696C4E7FCFEEFCFA473451E06000C2851

81B1D9F5FFF8DEB889582E0F00041A3E6C9CC9EBFDFDEBCA9E6D3F1B05000E2D5787B6DDF7FF

F5DAB28353290C00061D4372A2CEEEFEFCE8C598673A17030111315D8DBCE1F9FFF3D6AC7D4D

250A0008214978A8D2F1FFFBE4C092613514020214366393C1E5FBFFF0D1A776472107000A26

4E7EAED7F3FFF9E1BB8C5B30100103183B6999C6E9FCFEEDCDA170421D05000D2A5484B3DBF6

FFF7DDB586562C0E00051B406E9FCBECFEFDEAC89B6A3D190400102F5A8AB9DFF8FFF4D8B080

50270B00071F4675A5D0EFFEFBE6C395643815020113345F90BEE3FAFFF2D4AA7A4A23090009

234B7BABD4F2FFFAE3BD8F5F3312010316386596C3E7FCFEEFCFA474451F06000B285181B0D9

F5FFF8DFB889592E0F0004193E6B9CC8EAFDFDECCA9E6E401B05000E2C5687B6DDF7FFF6DBB3

83532A0C00061D4371A2CDEEFEFCE8C598683B17030111315C8DBBE1F9FFF3D6AD7D4D250A00

08214877A8D2F1FFFBE5C092623514020214366293C1E5FBFFF0D2A777482108000A254E7DAD

D7F3FFF9E1BB8C5C31110103173B6899C6E9FCFEEDCDA171431D06000C2A5383B3DBF6FFF7DD

B686562C0E00051B406E9FCBECFDFDEAC89C6B3D1904000F2E5989B8DFF8FFF4D9B08050270B

00071F4574A4CFEFFEFCE7C3966790B7D8F1FEFEF2DAB9926A43230C000210294B729BC1E0F5

FFFCECD2AF875F391B0700051632567EA6CAE7F9FFF9E6C9A47C5430150400081D3B6089B0D3

EDFCFFF5DFBF99714A280F02010D24456B94BADBF2FEFDF0D7B58E6640200A0003122C4F769F

C4E3F7FFFBEACEAB835B361906000618355982AACDE9FBFFF7E3C5A078502D1303000A1F3E64

8DB4D6EFFDFEF3DCBC956D46250D01010E27486F98BEDEF4FFFDEED4B28A623C1D090004142F

537AA3C8E5F8FFFAE8CBA77F5733170500071B385D86ADD1EBFCFFF6E1C29C744C2A1102000B

22426891B8D9F1FEFEF1D9B8916942220B0002102A4C739CC2E1F6FFFCECD1AE865E391B0700

051633567FA7CBE7FAFFF8E5C8A37B5330140400081D3C618AB1D4EEFDFFF4DEBE987049270F

01010D25466C95BBDCF3FEFDEFD6B48D653F1F0A0003122D5077A0C5E3F7FFFBE9CEAA825A35

1806000619365A83AACEEAFBFFF7E3C59F774F2D1203000A203F658EB5D7F0FDFEF3DBBB946C

45240D01020F28497099BFDEF5FFFCEDD3B189613B1D0800041530547BA4C8E6F9FFF9E7CAA6

7E5632160500071B395E87AED1ECFCFFF6E0C19B734C2A1002000C23436992B8DAF1FEFEF1D9

B7906842220B0002112B4D749DC2E1F6FFFBEBD0AD855D381A0700051733577FA8CCE8FAFFF8

E5C7A27A522F140400091E3D628BB2D4EEFDFFF4DEBE976F48270E01010D25466D96BCDCF3FF

FDEFD6B48C643E1F090003132E5178A1C6E4F8FFFAE9CDA98159351806000619375B83ABCFEA

FBFFF7E2C49E764E2C1203000A2040668FB6D7F0FDFEF2DBBA936B44240C01020F284A719AC0

DFF5FFFCEDD3B088603B1C0800041531547CA5C9E6F9FFF9E7CAA57D5531160400081C3A5F87

AFD2ECFCFFF5E0C09A724B291002010C23446A93B9DAF2FEFEF0D8B68F6741210B0002112B4E

759EC3E2F6FFFBEBCFAC845C371A07000517345880A8CCE9FAFFF8E4C6A179512E130300091E

3D638BB3D5EEFDFFF4DDBD976E47260E01010E26476E97BDDDF4FFFDEED5B38B633D1E090003

132E5179A2C6E4F8FFFAE8CCA8805834170500071A375C84ACCFEBFBFFF6E2C39E754E2B1102

000B21416790B6D8F0FEFEF2DAB9936A44230C010210294B729BC0E0F5FFFCECD2AF875F3A1C

0800041632557DA5CAE7F9FFF9E6C9A47C5431150400081C3B6088B0D3EDFCFFF5DFC09A714A

280F02010C24446B93BADBF2FEFDF0D7B68F6640200A0003122C4F769EC4E2F7FFFBEACFAB83

5B371906000618355981A9CDE9FAFFF8E4C6A178512E130300091F3E648CB4D6EFFDFFF3DCBC

966D46250D01010E27486F97BEDEF4FFFDEED4B28B623D1E090004142F527AA2C7E5F8FFFAE8

CCA77F5733170500071A385D85ADD0EBFBFFF6E1C29D744D2B1102000B22426890B7D9F1FEFE

F1D9B8926943230C0002102A4C739BC1E0F6FFFCECD1AE875E391B0700051632567EA6CAE7F9

FFF9E6C8A47B5330150400081D3B6189B1D3EDFCFFF5DEBF997049280F01010D24456C94BBDB

F3FEFDF0D7B58E653F200A0003122D4F779FC5E3F7FFFBEACEAA825A361906000618355A82AA

CEEAFBFFF7E3C5A077502D1203000A203F658DB4D6EFFDFEF3DCBB956C46250D01010F274970

98BEDEF4FFFCEED4B18A613C1D0800041430537BA3C8E5F8FFFAE7CBA77E5633160500071B39

5E86AED1ECFCFFF6E1C19C734C2A1002000B22426991B8D9F1FEFEF1D9B8916842220B000211

2A4C749CC2E1F6FFFCEBD0AD865D381B0700051733577FA7CBE8FAFFF8E5C8A37A532F140400

091D3C628AB2D4EEFDFFF4DEBE986F48270E01010D25466D95BCDCF3FEFDEFD6B48D643E1F0A

0003132D5078A0C5E3F7FFFBE9CDAA8259351806000619365B83ABCEEAFBFFF7E3C49F764F2C

1203000A2040668EB5D7F0FDFEF2DBBA946B45240D01020F284A7199BFDFF5FFFCEDD3B08960

3B1D0800041530547CA4C9E6F9FFF9E7CAA67E5632160500081B3A5F87AFD2ECFCFFF5E0C19B

724B291002000C23436A92B9DAF2FEFEF1D8B7906741210B0002112B4D759DC3E1F6FFFBEBD0

AD855C381A07000517345880A8CCE8FAFFF8E4C7A27A522F140300091E3D638BB2D5EEFDFFF4

DDBD976E48260E01010E26476E96BCDDF3FFFDEFD5B38C633E1F090003132E5179A1C6E4F8FF

FAE9CDA9815934180500061A375C84ACCFEBFBFFF7E2C39E764E2C1203000B2140668FB6D8F0

FEFEF2DABA936A44230C010210294A729AC0DFF5FFFCEDD2AF885F3A1C0800041531557DA5C9

E6F9FFF9E6C9A57D5531150400081C3A5F88AFD2EDFCFFF5DFC09A714A291002010C23446A93

BADAF2FEFEF0D8B68F6640210B0003122C4E769EC3E2F7FFFBEACFAC845C371A060005183459

81A9CDE9FAFFF8E4C6A179512E130300091F3E638CB3D5EFFDFFF3DDBC966D47260E01010E26

486E97BDDDF4FFFDEED5B28B623D1E090003142F527AA2C7E5F8FFFAE8CCA880583417050007

1A385C85ADD0EBFBFFF6E1C39D754D2B1102000B21416790B7D8F1FEFEF2DAB9926A43230C00

0210294B729BC1E0F5FFFCECD2AF875F391B0700051632567EA6CAE7F9FFF9E6C9A47C543015

0400081D3B6089B0D3EDFCFFF5DFBF99714A280F02010D24456B94BADBF2FEFDF0D7B58E6640

200A0003122C4F769FC4E3F7FFFBEACEAB835B361906000618355982AACDE9FBFFF7E3C5A078

502D1303000A1F3E648DB4D6EFFDFEF3DCBC956D46250D01010E27486F98BEDEF4FFFDEED4B2

8A623C1D090004142F537AA3C8E5F8FFFAE8CBA77F5733170500071B385D86ADD1EBFCFFF6E1

C29C744C2A1102000B22426891B8D9F1FEFEF1D9B8916942220B0002102A4C739CC2E1F6FFFC

ECD1AE865E391B0700051633567FA7CBE7FAFFF8E5C8A37B5330140400081D3C618AB1D4EEFD

FFF4DEBE987049270F01010D25466C95BBDCF3FEFDEFD6B48D653F1F0A0003122D5077A0C5E3

F7FFFBE9CEAA825A351806000619365A83AACEEAFBFFF7E3C59F774F2D1203000A203F658EB5

D7F0FDFEF3DBBB946C45240D01010F28497099BFDEF5FFFCEDD3B189613B1D0800041530547B

A4C8E6F9FFF9E7CAA67E5632160500071B395E87AED1ECFCFFF6E0C19B734C2A1002000C2343

6992B8DAF1FEFEF1D9B7906842220B0002112B4D749DC2E1F6FFFBEBD0AD855D381A07000517

33577FA8CCE8FAFFF8E5C7A27A522F140400091E3D628BB2D4EEFDFFF4DEBE976F48270E0101

0D25466D96BCDCF3FFFDEFD6B48C643E1F090003132E5178A1C6E4F8FFFAE9CDA98159351806

000619375B83ABCFEAFBFFF7E2C49E764E2C1203000A2040668FB6D7F0FDFEF2DBBA936B4424

0C01020F284A719AC0DFF5FFFCEDD3B088603B1C0800041531547CA5C9E6F9FFF9E7CAA57D55

31160400081C3A5F87AFD2ECFCFFF5E0C09A724B291002010C23446A93B9DAF2FEFEF0D8B68F

6741210B0002112B4E759EC3E2F6FFFBEBCFAC845C371A07000517345880A8CCE8FAFFF8E4C6

A179512E130300091E3D638BB3D5EEFDFFF4DDBD976E47260E01010E26476E97BDDDF4FFFDEE

D5B38B633D1E090003132E5179A1C6E4F8FFFAE8CCA8805834170500071A375C84ACCFEBFBFF

F6E2C39E754E2B1102000B21416790B6D8F0FEFEF2DAB9936A44230C010210294B729BC0E0F5

FFFCECD2AF875F3A1C0800041632557DA5CAE7F9FFF9E6C9A47C5431150400081C3B6088B0D3

EDFCFFF5DFC09A714A280F02010C24446B93BADBF2FEFDF0D7B68F6640200A0003122C4F769E

C4E2F7FFFBEACFAB835B371906000618355981A9CDE9FAFFF8E4C6A178512E130300091F3E64

8CB4D6EFFDFFF3DCBC966D46250D01010E27486F97BEDEF4FFFDEED4B28B623D1E090004142F

527AA2C7E5F8FFFAE8CCA77F5733170500071A385D85ADD0EBFBFFF6E1C29D744D2B1102000B

22426890B7D9F1FEFEF1D9B8926943230C0002102A4C739BC1E0F6FFFCECD1AE875E391B0700

051632567EA6CAE7F9FFF9E6C8A47B5330150400081D3B6189B1D3EDFCFFF5DEBF997049280F

01010D24456C94BBDBF3FEFDF0D7B58E653F200A0003122D4F779FC5E3F7FFFBEACEAA835A36

1906000618355A82AACEEAFBFFF7E3C5A077502D1203000A203F658DB4D6EFFDFEF3DCBB956C

46250D01010F27497098BEDEF4FFFCEED4B18A613C1D0800041430537BA3C8E5F8FFFAE7CBA7

7E5633160500071B395E86AED1ECFCFFF6E1C19C734C2A1002000B22426991B8D9F1FEFEF1D9

B8916842220B0002112A4C749CC2E1F6FFFCEBD0AD865D381B0700051733577FA7CBE8FAFFF8

E5C8A37A532F140400091D3C628AB2D4EEFDFFF4DEBE986F48270E01010D25466D95BCDCF3FE

FDEFD6B48D643E1F0A0003132D5078A0C5E3F7FFFBE9CDAA8259351806000619365B83ABCEEA

FBFFF7E3C49F764F2C1203000A2040668EB5D7F0FDFEF2DBBA946B45240D01020F284A7199BF

DFF5FFFCEDD3B089603B1D0800041530547CA4C9E6F9FFF9E7CAA67E5632160500081B3A5F87

AFD2ECFCFFF5E0C19B724B291002000C23436A92B9DAF2FEFEF1D8B7906741210B0002112B4D

759DC3E1F6FFFBEBD0AD855C381A07000517345880A8CCE8FAFFF8E4C7A27A522F140300091E

3D638BB2D5EEFDFFF4DDBD976E48260E01010E26476E96BCDDF3FFFDEFD5B38C633E1F090003

132E5179A1C6E4F8FFFAE9CDA9815934180500061A375C84ACCFEBFBFFF7E2C39E764E2C1203

000B2140668FB6D8F0FEFEF2DABA936A44230C010210294A729AC0DFF5FFFCEDD2AF885F3A1C

0800041531557DA5C9E6F9FFF9E6C9A57D5531150400081C3A5F88AFD2EDFCFFF5DFC09A724A

291002010C23446A93BADAF2FEFEF0D8B68F6640210B0003122C4E769EC3E2F7FFFBEACFAC84

5C371A06000518345981A9CDE9FAFFF8E4C6A179512E130300091F

pop

% End of sampled sound

% End of Graphics

MathPictureEnd


\
\>"], "Sound",
  ImageSize->{288, 177.938},
  ImageMargins->{{1, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oo`008@0000000`00
Oomoo`3oOolMOol100000003001oogoo051oo`03001oogoo02EoobX007Yoo`40000000<007ooOol0
N7oo:P00NWoo0@0000000`00Oomoo`1@Oomj001BOol100000003001oogoo02Mool`002Uoo`400000
00<007oo0000o`0070000Goo0@0000000`00Ool0003o000L0001Ool100000003001oo`000?l001`0
005oo`40000000<007oo0000o`0070000Goo0@0000000`00Ool0003o000L0001Ool100000003001o
o`000?l001`0005oo`40000000<007oo0000o`0070000Goo0@0000000`00Ool0003o000L0001Ool1
00000003001oogoo02Mool`002Uoo`40000000<007ooOol0D7ooNP00DWoo0@0000000`00Oomoo`1h
OolZ001jOol100000003001oogoo07QoobX007Yoo`40000000<007ooOol0ogoo7Goo0@0000000`00
Oomoo`2QOol00`00Oomoo`1hOol100000003001oogoo0?mooaeoo`400000o`008@0000000`00Oomo
o`3oOolMOol100000003001oo`000?l001`0005oo`40000000<007oo0000X@0000=oo`000000M`00
0Goo0@0000001000Ool000000Woo0`0000Aoo`000000009oo`<00003Ool0000000800005Ool007oo
001oo`03000017oo000007oo100000=oo`0000000P0000Aoo`00001oo`800004Ool00000Ool20000
17oo000007oo0P0000=oo`00Ool00P0000Aoo`00001oo`800004Ool00000Ool200000goo00000002
Ool3000017oo000007oo0P0000Eoo`00000007oo00800004Ool00000Ool2000017oo000007oo0P00
00Aoo`00001oo`800004Ool00000Ool3000017oo000007oo0P000Woo00D007oo000007oo00800004
Ool00000Ool2000017oo000007oo0P0000Aoo`00Oomoo`800005Ool00000Ool00003Ool00`00Oomo
o`02000017oo000007oo0P0000Aoo`00001oo`<00004Ool00000Ool2000017oo000007oo0P0000Ao
o`00001oo`800003Ool0000000800004Ool00000Ool200001Woo000007oo001oo`800004Ool00000
Ool2000017oo000007oo0P0000Ioo`00001oo`00Ool2000017oo000007oo1@0000Aoo`00001oo`@0
0004Ool000000002Ool01000Ool007oo100000Eoo`00Ool007oo00@00003Ool007oo0080005oo`40
000000@007oo001oo`/00003Ool0000000H00003Ool0000000l00003Ool0000000X00004Ool00000
Ool@000017oo000007oo0P0000=oo`000000:`0000=oo`0000005`0000=oo`0000000`0000=oo`00
00003P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000=oo`0000005P0000Ao
o`00001oo`800003Ool0000001P00003Ool0000001800003Ool0000000X0005oo`40000000<007oo
Ool01P0000=oo`0000000P0000Eoo`00000007oo00@00003Ool0000000H00003Ool0000000@00003
Ool0000000X00003Ool0000001H00003Ool0000001d00004Ool00000Ool2000017oo000007oo1P00
00=oo`0000000`0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000=oo`000000
0`0000=oo`0000000`0000Aoo`00001ooa000003Ool0000000l00004Ool00000OolD00000goo0000
000200000goo0000000D00000goo0000000400000goo001oo`0200001Goo00000000Ool0100000Eo
o`00000007oo00@00003Ool000000080005oo`40000000@007oo001oo`800003Ool007oo009oo`06
001oo`00001oo`000Woo00<007ooOol00P0000Eoo`00Oomoo`0000=oo`03001oo`00009oo`03001o
o`0000=oo`800005Ool00000Ool00002Ool01000Oomoo`000Woo00D007ooOol007oo00800005Ool0
07ooOol00002Ool01000Oomoo`000Woo00L007ooOol007oo001oo`02000017oo000007oo0P0000Eo
o`00Oomoo`00009oo`05001oo`00001oo`02000017oo000007oo0P000Woo00@007ooOol0009oo`07
001oogoo001oo`00Ool00P000Woo0P000goo0`0000Moo`00000007oo001oo`030003Ool20002Ool2
00000goo001oo`0400001Goo000007oo00000Woo00D007oo000007oo00800004Ool00000Ool20000
0goo001oo`020002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01@00Oomo
o`00Ool00P0000Eoo`00Oomoo`00009oo`04001oogoo0002Ool01@00Ool00000Ool00P0000Eoo`00
Oomoo`0000Aoo`06001oogooOol007oo0P0000=oo`00Ool00Woo00H007oo000007oo0002Ool00`00
Oomoo`0200000goo001oo`020002Ool01`00Oomoo`00Ool007oo0040000000<007ooOol03@0000=o
o`0000001P0000=oo`0000001@0000=oo`0000000P0000=oo`0000000P0000Aoo`00001ooa000004
Ool00000OolA000017oo000007oo0P0000Aoo`00001oo`800003Ool0000001H00003Ool0000000<0
0003Ool007oo00<00006Ool00000Ool007oo0`0000=oo`00Ool01@0000Aoo`00001oo`<00003Ool0
07oo00800003Ool0000000T00004Ool00000Ool2000017oo000007oo0P0000=oo`0000000Woo0P00
00Aoo`00001oo`800004Ool00000Ool;000017oo000007oo3@0000Aoo`00001oo`800003Ool00000
00/00003Ool0000000800003Ool0000000H00003Ool0000000H00003Ool0000000H00004Ool00000
Ool100000005001oo`00001oo`0;00000goo0000000600000goo00000006000017oo000007oo0P00
00=oo`0000001P0000Aoo`00001oo`800004Ool00000Ool:000017oo000007oo0P0000Aoo`00001o
o`800003Ool0000001400004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800003Ool0
000000<00004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool20000
17oo000007oo0P0000Aoo`00001oo`800003Ool0000000800004Ool00000OolI00001Goo001oogoo
00000Woo00@007ooOomoo`800004Ool00000Ool7000017oo000007oo0P0000Aoo`00001oo`d00003
Ool0000000P00003Ool0000000<00003Ool0000000<00004Ool00000Ool500000goo000000030000
17oo000007oo0P000Goo0@0000001@00Ool007oo00000Woo00H007ooOomoo`00Ool200000goo001o
o`05Ool00`00Ool00002Ool01`00Oomoogoo001oo`00009oo`03001oogoo00=oo`04001oogoo0003
Ool2000017oo000007oo0P000Woo00<007ooOol00goo00L007ooOol007oo001oo`0200000goo0000
0002Ool00`00Oomoo`06Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000
Oomoo`000Woo00@007ooOol0009oo`04001oogoo0004Ool01000Ool007oo10000Woo0P000goo00<0
07oo00000goo0P0000=oo`00Ool00`0000Aoo`00Ool000=oo`04001oogoo0002Ool01000Oomoo`00
0Woo00@007ooOol000Ioo`04001oogoo0002Ool01000Oomoo`000Woo00D007ooOomoo`00009oo`<0
0005Ool00000Ool00002Ool01000Oomoo`000Woo0P0000Aoo`00001oo`800004Ool007oo0002Ool0
1000Oomoo`000Woo0P0000=oo`0000000Woo00L007ooOomoo`00Ool00002Ool01`00Oomoogoo001o
o`00009oo`03001oo`0000Aoo`03001oo`00009oo`07001oogooOol007oo00000goo0@0000001@00
Oomoo`00Ool00P0000Eoo`00000007oo00@00003Ool0000000@00003Ool007oo00800007Ool00000
001oo`00Ool00P0000=oo`000000100000Aoo`00001oo`800004Ool00000Ool200000goo00000008
000017oo000007oo0P0000Aoo`00001oo``00004Ool00000Ool2000017oo000007oo0P0000Aoo`00
001oo`800004Ool00000Ool2000017oo000007oo0P0000=oo`0000000goo0P0000Eoo`00Oomoo`00
009oo`05001oogoo001oo`0300000goo001oo`020002Ool01@00Oomoo`00Ool00P000Woo00@007oo
0000009oo`800004Ool00000Ool2000017oo000007oo0P0000=oo`000000100000Aoo`00001oo`80
0004Ool00000Ool20002Ool00`00Oomoo`02000017oo000007oo0P0000=oo`0000002`0000Aoo`00
001oo`800004Ool00000Ool200000goo00000005000017oo000007oo0`0000=oo`00Ool00P0000Eo
o`00000007oo00@00003Ool0000000H00004Ool00000Ool300000goo001oo`020001Ool100000003
001oogoo00@00005Ool00000001oo`0400001Goo00000000Ool0100000=oo`0000001@0000=oo`00
00000P0000Aoo`00001oo`<00004Ool00000Ool:000017oo000007oo0P0000Aoo`00001oo`X00006
Ool00000Ool007oo0P0000Aoo`00001oo`800004Ool00000Ool200000goo0000000A000017oo001o
ogoo0P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800004
Ool00000Ool200001Goo000007oo00000Woo1P0000Aoo`00001oo`800004Ool00000Ool2000017oo
000007oo0P0000Aoo`00001oo`80009oo`03001oogoo00800004Ool00000Ool9000017oo000007oo
0P0000Aoo`00001oo`L00004Ool00000Ool2000017oo000007oo0P0000Eoo`00000007oo00800005
Ool00000001oo`04000017oo000007oo100000=oo`0000001P0000=oo`0000001@0000Eoo`000000
07oo0040000000@007oo001oo`800003Ool007oo009oo`0:001oogoo001oo`00Ool007oo0002Ool0
1@00Ool007oo000017oo00T007ooOol007oo001oo`00Ool00P0000=oo`00Ool00P0000Eoo`00Oomo
o`0000Eoo`800004Ool00000Ool2000017oo001oo`001Goo00<007ooOol00P0000Eoo`00000007oo
00800004Ool00000Ool200000goo00000002Ool01000Oomoo`000Woo00<007ooOol02Goo00@007oo
Ool0009oo`04001oo`00Ool20004Ool20004Ool200000goo001oo`02Ool01000Ool0000017oo0P00
17oo0P0000=oo`00Ool00Woo00@007ooOol0009oo`800004Ool00000Ool2000017oo000007oo0P00
00=oo`00Ool00P0000Eoo`00Oomoo`00009oo`04001oogoo0006Ool01000Oomoogoo0P0000Aoo`00
001oo`80009oo`03001oogoo00=oo`07001oogoo001oo`00Ool00P0000=oo`0000000Woo00D007oo
Oomoo`0000Aoo`06001oo`00001oo`000goo00P007ooOol007oo001oo`0017oo00D007oo001oo`00
00Aoo`06001oo`00Ool007oo0@0000001000Ool000000Woo0`0000=oo`0000000P0000Eoo`000000
07oo00@00005Ool007oo001oo`0300000goo0000000500001Goo00000000Ool00P0000=oo`00Ool0
0P0000=oo`0000000Woo00D007oo000007oo00800004Ool00000Ool200001Woo001oogoo001oo`80
0004Ool00000Ool200001Goo001oogoo00000Woo00@007ooOol0009oo`800004Ool00000Ool20000
17oo000007oo0P0000Aoo`00001oo`<00004Ool00000Ool20002Ool00`00Oomoo`02000017oo001o
ogoo10000Woo00<007oo00000P0000Aoo`00Oomoo`@0009oo`05001oo`00001oo`0200001Goo0000
0000Ool00P0000=oo`0000000Woo00@007ooOol0009oo`04001oogoo0002Ool2000017oo000007oo
0P0000Aoo`00001oo`800003Ool0000000Aoo`05001oo`00001oo`02000017oo000007oo0P0000Eo
o`00001oo`00009oo`800003Ool007oo00800004Ool00000Ool200001Woo000007oo001oo`@00003
Ool00000009oo`<00003Ool0000000800005Ool00000001oo`0400001Goo001oo`00Ool0100000=o
o`0000000P000Goo0@0000000`00Oomoo`0600000goo000000020002Ool200000goo000000020000
1Goo00000000Ool00P0000=oo`00Ool00P000Woo0P0000Aoo`00Oomoo`800004Ool00000Ool20000
0goo00000002000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool4000017oo000007oo
0P000goo0P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000=oo`0000001000
00=oo`0000000Woo00@007ooOol0009oo`03001oo`0000H0009oo`D00005Ool00000001oo`030000
0goo000000030002Ool00`00Ool00004000017oo001oogoo0P0000Aoo`00001oo`800004Ool00000
Ool20002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`060000
17oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool4000017oo000007oo0P0000Aoo`00001o
o`800003Ool0000000800006Ool00000Ool007oo0`0000Ioo`00001oo`00Ool20002Ool200000goo
0000000200001Goo00000000Ool00P0000=oo`00Ool00P000goo0@0000000`00Ool00003Ool00`00
Oomoo`02Ool02000Oomoo`00Ool007oo0002Ool00`00Ool00003Ool00`00Oomoo`02Ool00`00Oomo
o`020002Ool01000Ool000000Woo00@007ooOol0009oo`03001oogoo009oo`05001oogoo001oo`02
0002Ool01000Oomoo`000Woo00<007ooOol00Woo00D007ooOol007oo00<00004Ool00000Ool20000
0goo00000002Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo009oo`04001oogoo0002
Ool02000Oomoo`00Ool007oo0003Ool01P00Ool00000Ool000=oo`03001oo`0000=oo`03001oo`00
009oo`03001oogoo00800003Ool007oo009oo`03001oo`0000=oo`04001oogoo0002Ool01000Oomo
o`000Woo00D007oo000007oo00800005Ool00000Ool00002Ool01000Oomoo`000Woo00@007ooOol0
009oo`03001oogoo009oo`04001oogoo0002Ool200001Goo001oogoo00000Woo00<007ooOol00Woo
00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`02Ool01P00Oomoo`00Ool000=oo`06001o
ogoo001oo`000Woo00L007oo001oo`00Ool00002Ool01@00Oomoogoo00000Woo00<007oo00000Woo
0P000Goo0@0000001000Ool007oo100000Eoo`00Ool007oo00800004Ool000000002Ool300000goo
0000000200001Goo001oo`00Ool0100000Ioo`00Ool007oo0002Ool01@00Ool00000Ool00P0000Ao
o`00001oo`800005Ool007ooOol00002Ool01@00Ool00000Ool00P0000Aoo`00001oo`800003Ool0
07oo009oo`04001oogoo0002Ool00`00Oomoo`02000017oo000007oo0P0000=oo`0000000Woo00@0
07ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00D007oo000007oo00800003Ool00000
009oo`05001oo`00001oo`02000017oo000007oo0P0000Aoo`00Oomoo`800004Ool00000Ool20000
0goo00000002000017oo000007oo0P0000=oo`000000100000Aoo`00001oo`800004Ool00000Ool2
0002Ool01000Oomoo`000Woo00@007ooOol0009oo`800004Ool00000Ool200001Woo001oogoo001o
o`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00Oomoo`800003Ool007oo00800003Ool0
0000009oo`<00003Ool0000000800005Ool007oo001oo`04000017oo001oogoo0`0000=oo`000000
0P0000Eoo`00Ool007oo00<0005oo`40000000@007ooOol0009oo`04001oo`00Ool30002Ool01000
Ool007oo0P0000Eoo`00Ool007oo00800007Ool007oo001oo`00Ool00P0000Aoo`00Ool000Aoo`03
001oogoo00800003Ool007oo00800005Ool00000Ool00002Ool01000Oomoo`000Woo0P0000Ioo`00
001oo`00Ool200001Goo001oogoo00000Woo0P0000Aoo`00001oo`800003Ool0000000800003Ool0
07oo00800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool20000
0goo001oo`020002Ool2000017oo001oogoo0P0000=oo`00Ool00P000Woo00@007oo0000009oo`05
001oogoo001oo`020002Ool2000017oo000007oo0P0000Eoo`00Oomoo`00009oo`04001oogoo0002
Ool01000Oomoo`000Woo0P0000Aoo`00001oo`800004Ool00000Ool4000017oo000007oo0P000Woo
00D007ooOol007oo00800006Ool00000Ool007oo0P0000=oo`0000000Woo00D007ooOol007oo0080
0005Ool00000001oo`0200001Goo001oo`00Ool00P0000Ioo`00Ool007oo0002Ool01000Ool007oo
0`000Woo00<007oo00000Woo00H007oo001oo`00Ool20001Ool100000003001oogoo00Eoo`05001o
o`00Ool00004Ool00`00Ool000020007Ool20002Ool00`00Oomoo`02Ool200000goo00000007Ool2
000017oo000007oo0P0000=oo`00Ool02Goo0P0000Aoo`00001oo`8001Aoo`800004Ool00000Ool2
000017oo000007oo0P0000Aoo`00001oo`800005Ool00000Ool00002Ool00`00Oomoo`03Ool00`00
Oomoo`020004Ool00`00Oomoo`03Ool00`00Oomoo`02Ool20002Ool00`00Oomoo`02Ool20004Ool0
0`00Oomoo`02000GOol2000017oo000007oo0P0000Aoo`00001oo`800003Ool0000000Yoo`05001o
o`00001oo`0200000goo00000009Ool2000017oo000007oo10001goo00<007oo00000P0017oo00<0
07oo00000P001goo0`0000=oo`00Ool00goo0@0000001000Ool007oo0P0000=oo`00Ool00Woo00/0
07oo000007oo001oo`00Ool007oo00800003Ool007oo008000=oo`03001oo`00009oo`06001oo`00
Ool007oo0P0000Ioo`00001oo`00Ool200000goo00000002Ool01@00Ool00000Ool00P0000=oo`00
00000P0000Aoo`00001oo`800005Ool007ooOol00002Ool200001Woo000007oo001oo`800003Ool0
07oo0080009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002
Ool01P00Ool00000Ool0009oo`800004Ool00000Ool2000017oo000007oo0P0000Eoo`00001oo`00
009oo`800004Ool00000Ool200000goo000000020002Ool00`00Oomoo`02000017oo000007oo0P00
00Aoo`00001oo`800004Ool00000Ool200000goo00000002Ool01000Oomoo`000Woo00<007ooOol0
0P0000Ioo`00001oo`00Ool200000goo00000002Ool01@00Ool00000Ool00P0000Ioo`00001oo`00
Ool200001Goo000007oo00000Woo00/007ooOol007oo001oo`00Ool007oo00800003Ool007oo009o
o`0;001oo`00001oo`00Ool007oo001oo`0200000goo001oo`020003Ool01P00Ool007oo001oo`40
000000<007ooOol010000Woo00<007ooOol0100000=oo`0000000Woo00D007oo000007oo00800006
Ool00000Ool007oo100000Ioo`00Oomoo`00Ool200001Goo000007oo00000Woo00<007ooOol00P00
00=oo`00Ool00P0000Eoo`00001oo`00009oo`04001oogoo0002Ool01@00Ool00000Ool0100000Ao
o`00001oo`800005Ool007oo001oo`0200000goo001oo`02000017oo000007oo0P0000Aoo`00001o
o`800004Ool00000Ool2000017oo001oo`000Woo00D007ooOol007oo0080009oo`05001oo`00001o
o`02000017oo001oogoo0P0000Aoo`00001oo`800005Ool007ooOol00002Ool20002Ool200000goo
001oo`02000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool200001Woo000007oo001o
o`800004Ool00000Ool20002Ool01@00Oomoo`00Ool00P0000Aoo`00001oo`800005Ool007ooOol0
0002Ool01@00Oomoo`00Ool00P0000Aoo`00001oo`@00005Ool00000Ool00002Ool00`00Oomoo`04
0002Ool00`00Oomoo`0400000goo00000002Ool01@00Ool00000Ool00P0000Aoo`00001oo`800004
Ool00000Ool100000003001oogoo00Eoo`03001oo`0000Qoo`04001oogoo0005Ool200000goo001o
o`07Ool00`00Oomoo`0200000goo0000000<Ool2000017oo000007oo0P002goo00L007oo001oo`00
Ool00002Ool2000017oo000007oo0P000Woo00<007ooOol05Woo00<007oo00000goo0P0017oo0P00
17oo00D007ooOomoo`0000Aoo`8000Aoo`8000=oo`03001oogoo00Ioo`04001oogoo0002Ool01000
Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`0@Ool2000017oo000007oo
0P002Woo00D007oo000007oo00800003Ool007oo00Ioo`800003Ool007oo00Eoo`03001oo`0000Qo
o`04001oogoo0005Ool01000Oomoo`001Woo0@0000000`00Oomoo`040002Ool00`00Oomoo`040000
0goo00000002Ool200000goo001oo`0200000goo001oo`02Ool01P00Ool00000Ool000=oo`<00005
Ool00000Ool00002Ool01000Oomoo`000Woo00D007ooOol007oo00800005Ool007ooOol00002Ool0
1000Oomoo`000Woo00D007ooOol007oo0080009oo`04001oogoo0002Ool01@00Oomoo`00Ool00P00
00Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800005Ool00000
Ool00002Ool200001Woo001oogoo001oo`80009oo`04001oogoo0002Ool01@00Oomoo`00Ool00P00
0Woo00@007oo0000009oo`800007Ool00000Ool007oo00000Woo00D007oo000007oo00800004Ool0
0000Ool200001Woo001oogoo001oo`800004Ool00000Ool2000017oo000000000Woo00@007ooOol0
009oo`06001oo`00001oo`000Woo00@007ooOol0009oo`05001oogoo001oo`0200001Goo000007oo
00000Woo00<007ooOol00P000Woo0P0000=oo`00Ool00P0000=oo`00Ool00Woo100000=oo`000000
0Woo100000=oo`0000000P000goo00D007oo000007oo0040000000D007oo001oo`00009oo`06001o
o`00Ool007oo0P0000Ioo`00Ool007oo0002Ool00`00Ool00002Ool01`00Ool007oo001oo`00009o
o`04001oo`00Ool200001Goo000007oo00000Woo00<007ooOol00P0000Aoo`00001oo`800004Ool0
07oo0002Ool01000Oomoo`000Woo00<007ooOol00P0000Aoo`00001oo`800005Ool00000Ool00002
Ool01@00Ool00000Ool00P0000=oo`0000000Woo00@007ooOol0009oo`04001oogoo0002Ool01000
Oomoo`000Woo00X007ooOomoo`00Ool007oo001oo`@0009oo`800009Ool007oo001oo`00Ool007oo
00800003Ool007oo00<00007Ool007oo001oo`00Ool00`0000Aoo`00001oo`800003Ool00000009o
o`03001oogoo00800004Ool00000Ool20002Ool01000Oomoo`000Woo00@007ooOol0009oo`03001o
ogoo009oo`04001oogoo0002Ool01`00Ool00000Ool007oo00800003Ool00000009oo`04001oogoo
0002Ool01`00Ool00000Ool007oo00800003Ool00000009oo`80009oo`03001oo`00009oo`07001o
o`00Ool007oo00000Woo00D007oo001oo`00009oo`03001oo`00009oo`07001oo`00Ool007oo0000
0goo0@0000001000Ool000000Woo100000=oo`0000001Goo100000=oo`0000000Woo100000=oo`00
000017oo0P0000Qoo`00001oo`00Ool007oo0P0000Aoo`00001oo`800004Ool00000Ool20003Ool2
000017oo000007oo0P0000Aoo`00001oo`800003Ool0000000Moo`04001oogoo0002Ool01000Oomo
o`000Woo00<007ooOol00P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0`0000Ao
o`00001oo`8000Aoo`80009oo`05001oo`00001oo`02000017oo001oogoo0P0017oo00<007ooOol0
0P0000=oo`00Ool00Woo00@007ooOol0009oo`04001oogoo0002Ool20005Ool00`00Oomoo`020000
17oo000007oo0P0000Aoo`00001oo`800003Ool0000000800004Ool00000Ool200000goo001oo`03
Ool2000017oo000007oo0P0000Aoo`00001oo`800004Ool007oo0002Ool00`00Oomoo`0200000goo
0000000300000goo00000002Ool400000goo00000005Ool01P00Ool00000Ool000=oo`@00003Ool0
000000Aoo`40000000H007ooOol007oo0007Ool300000goo001oo`03Ool01@00Ool007oo00001Woo
00H007oo000007oo0004Ool01@00Oomoogoo00000Woo00<007ooOol017oo00@007ooOol0009oo`80
009oo`04001oogoo0006Ool01000Oomoo`0017oo0P0000Eoo`00Oomoo`00009oo`04001oogoo0002
Ool01000Oomoo`003Goo00@007ooOol0009oo`05001oogooOol00004Ool20004Ool01`00Oomoogoo
001oo`0000=oo`03001oogoo009oo`03001oogoo00=oo`05001oogooOol00003Ool01000Oomoo`00
0Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001o
ogoo0009Ool01000Oomoo`000goo00@007ooOol0009oo`05001oogooOol00002Ool01000Oomoo`00
0goo00@007ooOol000Aoo`03001oogoo00Aoo`03001oo`0000Ioo`06001oo`00001oo`001Woo00<0
07oo00001Woo00D007oo000007oo0040000000@007ooOomoo`80009oo`03001oo`00009oo`07001o
ogooOol007oo00000Woo00H007oo001oo`00Ool200001Goo001oogoo00000Woo00@007ooOol000Ao
o`04001oogoo0002Ool01P00Ool00000Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00H0
07oo000007oo0002Ool01P00Oomoo`00Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@0
07ooOol0009oo`800003Ool007oo00800005Ool00000Ool00002Ool02@00Ool00000Ool007oo001o
o`0300000goo001oo`04000017oo001oo`000goo00D007oo000007oo00<00003Ool007oo00<00003
Ool0000000=oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`800004Ool00000
Ool2000017oo000007oo0P0000Ioo`00Oomoo`00Ool200001Goo000007oo00000Woo00@007ooOol0
009oo`04001oogoo0002Ool00`00Ool00002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001o
o`000002Ool2000017oo001oogoo0P0000Eoo`00001oo`00009oo`07001oogooOol007oo00000Woo
00H007oo001oo`00Ool200001Goo001oogoo00000goo0@0000001000Oomoo`000Woo00D007ooOol0
07oo00800003Ool00000009oo`06001oo`00001oo`000goo00H007ooOol007oo0002Ool20002Ool0
0`00Ool000020002Ool01000Oomoogoo0P0000Aoo`00001oo`80009oo`04001oogoo0002Ool01`00
Oomoo`00Ool007oo00800003Ool00000009oo`05001oogoo001oo`02000017oo000007oo0P0000Eo
o`00Oomoo`00009oo`05001oo`00001oo`02000017oo000007oo0P000Woo00@007ooOol0009oo`05
001oogooOol00002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomo
o`000Woo00@007ooOol0009oo`05001oogoo001oo`0300001Goo000007oo00000Woo00D007ooOol0
07oo00800006Ool00000Ool007oo0P0000=oo`0000000Woo00@007ooOol0009oo`09001oogoo001o
o`00Ool007oo00800005Ool007ooOol00002Ool01000Oomoo`000Woo0P0000Moo`00001oo`00Ool0
0002Ool01000Oomoo`000Woo0P0000Eoo`00001oo`00009oo`03001oo`0000=oo`05001oogoo001o
o`0200000goo00000002Ool01P00Ool00000Ool000=oo`06001oo`00001oo`000Woo0P000Goo0@00
00001000Ool007oo0P0000=oo`00Ool01Goo00<007oo00001Woo00D007oo001oo`0000Moo`03001o
o`0000]oo`06001oogoo001oo`000Woo00@007ooOol000Qoo`06001oogoo001oo`000Woo00<007oo
Ool03goo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04
001oogoo0005Ool20007Ool20003Ool20004Ool20007Ool20004Ool01000Oomoo`000Woo00@007oo
Ool0009oo`03001oogoo00ioo`04001oogoo0002Ool01@00Oomoo`00Ool00P0000Aoo`00Ool0009o
o`03001oogoo00Ioo`05001oogoo001oo`0200001Goo001oogoo000027oo00H007ooOol007oo0005
Ool01P00Ool00000Ool000Ioo`03001oo`0000Ioo`05001oo`00Ool00006Ool01000Ool007oo0@00
00000`00Ool00004Ool200001Goo000007oo00000Woo0P0000=oo`0000000P001Goo10000Woo00<0
07ooOol00P0000Aoo`000000009oo`04001oogoo0002Ool01000Oomoogoo0P0000Aoo`00001oo`80
0003Ool00000009oo`04001oogoo0003Ool2000017oo000007oo0`0000Aoo`00001oo`800004Ool0
0000Ool2000017oo000007oo0P0000=oo`00000027oo00D007ooOomoo`00009oo`03001oogoo0080
0004Ool007ooOol2000017oo000007oo0P000Woo00D007oo000007oo00800004Ool007ooOol20000
17oo000007oo0P000Woo00H007oo001oo`00Ool2000017oo000007oo0P0000Aoo`00001oo`800004
Ool00000Ool200000goo00000002Ool01000Oomoo`000Woo00@007ooOol000Aoo`05001oogooOol0
0002Ool2000017oo000007oo0P0000=oo`0000001Woo00@007ooOol0009oo`800004Ool00000Ool2
0003Ool400000goo001oo`03Ool200000goo000000020002Ool200000goo000000020005Ool40000
0goo00000003Ool100000004001oogoo0002Ool01`00Ool007oo001oo`00009oo`03001oo`0000=o
o`06001oogoo001oo`000Woo00H007oo001oo`00Ool200000goo001oo`03Ool200000goo00000002
Ool00`00Oomoo`020002Ool00`00Oomoo`02000017oo000007oo0P000Woo00<007ooOol00P000Woo
00<007ooOol00P000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007oo
Ool00P0000Aoo`00001oo`800003Ool00000009oo`04001oogooOol20003Ool00`00Ool00003Ool0
1P00Oomoo`00Ool000=oo`03001oo`00009oo`800005Ool007ooOol00003Ool00`00Ool00002Ool0
1000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0
009oo`04001oogoo0002Ool01P00Oomoo`00Ool0009oo`80009oo`03001oogoo00800004Ool00000
Ool20002Ool200000goo00000002Ool2000017oo000007oo0P0000=oo`0000000Woo0`0017oo00@0
07oo001oo`800003Ool007oo009oo`06001oogoo001oo`000goo00H007ooOol007oo0002Ool01P00
Oomoogoo001oo`80005oo`40000000<007ooOol017oo00D007ooOomoo`0000Moo`800003Ool007oo
00Aoo`04001oogoo0008Ool00`00Oomoo`06Ool01000Oomoo`000Woo00@007ooOol000Yoo`04001o
ogoo0002Ool01000Oomoo`0057oo00@007ooOol0009oo`800004Ool00000Ool200000goo00000002
Ool01000Oomoo`000Woo00<007oo00000goo00<007ooOol00Woo00L007ooOomoo`00Ool00003Ool0
0`00Ool00003Ool00`00Oomoo`02Ool02000Oomoogoo001oo`00Ool20002Ool01000Oomoo`0067oo
00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`002Woo00@007ooOol0009oo`03001oogoo
00]oo`03001oogoo009oo`800003Ool007oo00Aoo`03001oogoo008000Moo`800003Ool007oo00Ao
o`04001oogoo0006Ool100000004001oo`00Ool30004Ool02000Ool00000Ool007oo0002Ool01000
Ool007oo0`0017oo00<007oo00000`0000Eoo`00Ool007oo00800004Ool00000Ool20005Ool01@00
Ool00000Ool00P0000Ioo`00001oo`00Ool20005Ool01@00Ool00000Ool00`0000Aoo`00001oo`80
0004Ool00000Ool2000017oo000007oo0P0000=oo`0000000Woo00<007ooOol00goo00<007ooOol0
0P0000Eoo`00001oo`00009oo`04001oogoo0002Ool40002Ool200001Goo001oogoo00000Woo00@0
07oo0000009oo`05001oo`00001oo`020002Ool00`00Ool00002Ool2000017oo000007oo0P0000Ao
o`00001oo`800004Ool00000Ool2000017oo000007oo0P0000Ioo`00001oo`00Ool200001Goo001o
ogoo00001Goo00D007oo000007oo00800004Ool00000Ool2000017oo001oogoo0P0000Ioo`00001o
o`00Ool2000017oo000007oo0P0000Aoo`00Ool0009oo`04001oo`00Ool30002Ool01000Ool007oo
0P0000Ioo`00Ool007oo0002Ool01@00Ool007oo00000Woo00@007oo001oo`<0005oo`40000000@0
07oo001oo`<0009oo`03001oo`00009oo`05001oo`00Ool00002Ool01000Ool007oo0`000Woo00<0
07oo00000Woo0P000Woo00D007oo000007oo00800003Ool007oo0080009oo`04001oogoo0002Ool0
1@00Ool00000Ool00P0000Eoo`00Oomoo`00009oo`05001oogoo001oo`0200001Goo00000000Ool0
0P0000Aoo`00001oo`800004Ool00000Ool20002Ool01000Oomoo`000Woo00@007ooOol0009oo`04
001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool200001Goo001o
ogoo00000Woo00@007oo0000009oo`04001oogoo0002Ool01P00Oomoo`00Ool0009oo`04001oogoo
0002Ool2000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool200000goo00000002Ool0
1@00Oomoogoo00000Woo00@007ooOol0009oo`05001oo`00001oo`0200001Goo000007oo00000Woo
00@007ooOol0009oo`05001oo`00001oo`0200001Goo000007oo00000Woo00<007oo00000Woo00@0
07oo001oo`<0009oo`03001oo`00009oo`80009oo`07001oogoo001oo`00Ool00`000Woo00<007oo
00000Woo0P000Goo0@0000000`00Oomoo`04Ool01`00Oomoogoo001oo`0000=oo`03001oo`00009o
o`03001oogoo00=oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol02Goo00@007ooOol0
009oo`03001oogoo00Moo`05001oogooOol00002Ool00`00Oomoo`0FOol01@00Oomoo`00Ool00P00
00Aoo`00001oo`800005Ool00000Ool00002Ool01`00Oomoogoo001oo`0000Eoo`8000Eoo`03001o
o`0000=oo`03001oo`0000Aoo`03001oo`0000Eoo`04001oo`00Ool200001Goo001oogoo00006Goo
00@007ooOol0009oo`800004Ool007ooOol2000<Ool01000Oomoo`000Woo00<007ooOol02goo00<0
07ooOol00Woo00@007ooOol000Eoo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol000Eo
o`04001oogoo0002Ool01000Oomoogoo0@0000001P00Oomoo`00Ool0009oo`05001oo`00Ool00002
Ool00`00Ool00002Ool01`00Ool007oo001oo`00009oo`06001oo`00Ool007oo0P0000Aoo`00Ool0
009oo`800004Ool00000Ool20006Ool2000017oo000007oo0P0000Aoo`00001oo`8000Ioo`800003
Ool00000009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0009
Ool01000Oomoo`000Woo00<007oo00000goo00@007oo0000009oo`06001oo`00001oo`000goo00<0
07oo00000goo00H007oo000007oo0002Ool200000goo001oo`02Ool00`00Ool00002Ool01000Oomo
o`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`80
0003Ool007oo00Moo`800004Ool00000Ool2000017oo000007oo0P000goo00<007ooOol00P0000Ao
o`00001oo`800003Ool0000000Aoo`0:001oogoo001oo`00Ool007oo0002Ool01@00Ool007oo0000
0Woo00<007oo00000Woo0P000Woo00<007oo00000Woo00H007oo001oo`00Ool20001Ool100000004
001oogoo0002Ool3000017oo0000000017oo00<007oo00000P000Woo00<007ooOol0100000=oo`00
000017oo0P0000=oo`0000000Woo00@007ooOol0009oo`06001oo`00001oo`000Woo00@007ooOol0
009oo`04001oogoo0002Ool01P00Ool00000Ool0009oo`03001oo`0000800004Ool00000Ool20000
17oo000007oo0P0000Eoo`00Oomoo`00009oo`05001oogoo001oo`0200001Goo000007oo00000Woo
00@007ooOol000=oo`05001oogoo001oo`020004Ool2000017oo001oogoo0P0000Eoo`00001oo`00
009oo`8000Aoo`800007Ool007ooOol007oo00000Woo00@007ooOol0009oo`05001oo`00001oo`02
000017oo000007oo0P0000Aoo`00001oo`80009oo`04001oogoo0002Ool01000Oomoo`000Woo0P00
00Eoo`00Oomoo`00009oo`800005Ool00000Ool00002Ool00`00Ool00002Ool01000Oomoo`000Woo
00@007ooOol0009oo`05001oo`00001oo`040002Ool01`00Oomoo`00Ool007oo00<000Aoo`03001o
o`000080009oo`03001oo`00009oo`<00003Ool007oo00=oo`40000000@007oo001oo`8000Moo`04
001oogoo0005Ool01000Oomoo`0027oo00@007ooOol000Yoo`04001oogoo0002Ool20002Ool00`00
Oomoo`07Ool00`00Oomoo`0200000goo00000002Ool00`00Oomoo`0AOol01000Oomoo`000Woo00@0
07ooOol0009oo`04001oogoo0002Ool01@00Oomoogoo00000Woo00H007ooOol007oo0003Ool20004
Ool20007Ool20004Ool20003Ool00`00Ool00005Ool01000Oomoo`000Woo00<007ooOol04goo00@0
07ooOol0009oo`03001oogoo00@00003Ool00000009oo`03001oogoo00Moo`03001oogoo0080009o
o`03001oogoo00Yoo`04001oogoo0005Ool01P00Ool00000Ool000Eoo`04001oogoo0005Ool01000
Oomoo`000Woo00<007ooOol00goo00@007ooOomoo`40000000<007oo000017oo00D007oo001oo`00
009oo`06001oo`00Ool007oo0P0000=oo`00Ool00Woo00P007oo000007oo001oo`000Woo00@007oo
001oo`<0009oo`04001oogoo0002Ool00`00Oomoo`02Ool01000Oomoo`000Woo00@007ooOol0009o
o`03001oogoo00Eoo`04001oogoo0002Ool01@00Ool00000Ool00P0000Aoo`00001oo`800004Ool0
0000Ool20002Ool00`00Oomoo`09Ool01@00Oomoo`00Ool00P000Woo00L007ooOomoo`00Ool00002
Ool01000Oomoo`000Woo00@007oo0000009oo`04001oogoo0002Ool01P00Oomoo`00Ool000=oo`03
001oo`00009oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800006Ool00000
Ool007oo0P0000Eoo`00001oo`00009oo`03001oogoo00Moo`04001oogoo0002Ool01000Oomoo`00
0Woo00<007ooOol00Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000goo0`0000=o
o`00Ool00goo00D007oo001oo`00009oo`06001oo`00Ool007oo0P0000=oo`00Ool00Woo00P007oo
000007oo001oo`000goo0@0000000`00Oomoo`040005Ool400000goo00000003Ool300000goo0000
0004Ool00`00Ool0000300000goo001oo`04Ool01000Oomoo`000Woo00H007oo000007oo0002Ool0
1000Oomoo`000Woo00@007ooOol0009oo`800003Ool0000000=oo`06001oogoo001oo`000Woo00@0
07ooOol0009oo`04001oogoo0002Ool00`00Oomoo`02000017oo000007oo0P0000Aoo`00001oo`80
009oo`04001oogoo0006Ool00`00Oomoo`0200001Goo001oogoo00001Goo00<007ooOol00goo00D0
07ooOol007oo0080009oo`03001oogoo009oo`<0009oo`04001oogoo0002Ool01000Oomoo`000Woo
00@007ooOol0009oo`80009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol00P0000=o
o`0000000Woo00@007ooOol0009oo`05001oogoo001oo`0200000goo001oo`020002Ool01000Oomo
o`000Woo00D007ooOol007oo00800003Ool007oo00Aoo`@000Eoo`@00003Ool0000000Aoo`800003
Ool0000000Aoo`800004Ool00000Ool100000003001oogoo00Eoo`03001oo`0000Qoo`03001oogoo
00Ioo`04001oogoo0008Ool00`00Oomoo`05Ool01000Oomoo`0017oo00@007ooOol000Qoo`04001o
ogoo0004Ool01000Oomoo`003Goo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`0017oo
00@007ooOol0009oo`08001oogoo001oo`00Ool000=oo`03001oogoo009oo`07001oogooOol007oo
00000goo00<007oo00000goo00<007ooOol00Woo00@007ooOomoo`8000=oo`04001oogoo0002Ool0
1000Oomoo`000Woo00<007ooOol02Goo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`00
17oo00@007ooOol000Eoo`04001oogoo0002Ool00`00Oomoo`02Ool01000Oomoo`001Goo00@007oo
Ool000Eoo`800003Ool007oo00Eoo`03001oo`0000Qoo`04001oogoo0005Ool01000Oomoo`001Woo
0@0000000`00Oomoo`0400000goo001oo`03Ool300000goo001oo`03Ool01000Ool007oo0P0000=o
o`00Ool00Woo00H007oo000007oo0004Ool200000goo00000002Ool00`00Oomoo`020002Ool00`00
Oomoo`02000017oo000007oo0P000Woo00<007ooOol00P000Woo00@007ooOol000Aoo`800004Ool0
0000Ool200001Goo000007oo00000Woo00@007ooOol0009oo`06001oogoo001oo`000Woo00@007oo
Ool0009oo`04001oogoo0003Ool00`00Ool00002Ool20002Ool01000Ool000000Woo00<007oo0000
0Woo0P0000Aoo`00Oomoo`80009oo`03001oo`0000=oo`05001oogooOol00002Ool01@00Oomoo`00
Ool00P0000=oo`0000000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@0
07ooOol0009oo`80009oo`03001oogoo00800004Ool00000Ool20002Ool00`00Oomoo`020002Ool0
0`00Oomoo`0200000goo00000002Ool00`00Oomoo`030004Ool01000Ool007oo0P0000=oo`00Ool0
0goo0`0000=oo`00Ool00goo0`0000Aoo`00000000Aoo`05001oo`00001oo`0100000003001oo`00
00Aoo`04001oo`00Ool20005Ool01P00Ool00000Ool000Aoo`<00003Ool0000000Aoo`800003Ool0
000000Eoo`800004Ool00000Ool20002Ool01000Oomoo`000goo00<007ooOol00P0000Aoo`00001o
o`800003Ool00000009oo`03001oogoo00Eoo`04001oogoo0002Ool01000Oomoo`000Woo00@007oo
Ool0009oo`03001oogoo00800004Ool00000Ool2000017oo000007oo0`0000Aoo`00Oomoo`8000Ao
o`80009oo`05001oo`00001oo`02000017oo001oogoo0P0017oo00L007ooOomoo`00Ool00003Ool0
1000Oomoo`000Woo00@007ooOol0009oo`03001oogoo00Qoo`05001oogoo001oo`02000017oo0000
07oo0P0000=oo`0000000P0000Aoo`00001oo`80009oo`05001oogooOol00002Ool2000017oo0000
07oo0P0000=oo`0000001Woo00@007ooOol0009oo`D00003Ool007oo00=oo`<00003Ool0000000Eo
o`06001oo`00001oo`0017oo0`0000=oo`00000017oo0@0000001@00Oomoogoo000027oo0P0000=o
o`00Ool01goo00<007ooOol01Woo00@007ooOol000Aoo`06001oo`00001oo`002goo00H007ooOol0
07oo0002Ool00`00Oomoo`09Ool00`00Oomoo`0200001Goo000007oo00000Woo00@007ooOol0009o
o`04001oogoo000DOol00`00Oomoo`03Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`07Ool00`00
Oomoo`02Ool20004Ool00`00Oomoo`08Ool01000Oomoo`000Woo00@007ooOomoo`800004Ool00000
Ool20002Ool01000Oomoo`000Woo00<007ooOol03Woo00H007ooOol007oo0002Ool00`00Oomoo`06
Ool01@00Oomoo`00Ool00P0000Eoo`00Oomoo`0000]oo`03001oogoo00Ioo`04001oogoo0008Ool0
0`00Oomoo`06Ool01000Oomoogoo0@0000000`00Ool00004Ool300000goo001oo`03Ool00`00Ool0
000300000goo001oo`03Ool300000goo001oo`03Ool300000goo000000020002Ool01000Oomoo`00
0Woo00@007ooOol000=oo`03001oogoo0080009oo`04001oogoo0002Ool01000Oomoo`000Woo00@0
07ooOomoo`80009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol00P000Woo00@007oo
Ool0009oo`04001oogoo0002Ool01000Oomoo`000goo00L007ooOomoo`00Ool00002Ool01000Oomo
o`000Woo00L007oo001oo`00Ool00002Ool00`00Ool00003Ool00`00Ool00003Ool00`00Ool00002
00000goo00000002Ool01000Oomoo`000Woo00@007ooOol0009oo`80009oo`04001oogoo0002Ool0
1000Oomoo`000Woo00@007ooOol000Aoo`04001oogoo0002Ool00`00Oomoo`020003Ool01000Oomo
o`000Woo00@007ooOol0009oo`05001oogooOol00002Ool00`00Oomoo`020002Ool300000goo001o
o`03Ool3000017oo001oo`000Woo00@007oo001oo`800003Ool007oo00=oo`<00004Ool007oo0003
Ool100000005001oogoo001oo`020005Ool400000goo001oo`05Ool01000Ool000001Goo00H007oo
000007oo0007Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0004Ool01000Oomoo`00
0Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`03Ool01000Oomoo`000Woo00D007oo
Ool007oo00800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800003Ool007oo00Ao
o`04001oogoo0002Ool01000Oomoo`001Goo00<007ooOol00goo00D007ooOol007oo0080009oo`03
001oogoo00=oo`800004Ool00000Ool20003Ool01000Oomoo`000Woo00<007ooOol00Woo00@007oo
Ool0009oo`05001oogoo001oo`02000017oo000007oo0`000Woo00@007ooOol0009oo`03001oogoo
009oo`04001oogoo0002Ool01000Oomoo`000Woo00H007ooOol007oo0002Ool01000Oomoo`000Woo
0P001Goo00@007oo000000Eoo`05001oo`00001oo`020005Ool01000Ool000001Goo00D007oo0000
07oo0040000000<007ooOol01Goo00<007oo000027oo00@007ooOol000Ioo`03001oo`0000Qoo`03
001oogoo00800005Ool007ooOol0000;Ool01P00Ool00000Ool000]oo`07001oogoo001oo`00Ool0
0P0000Eoo`00001oo`00009oo`04001oogoo000IOol01000Ool000000goo00<007ooOol00Woo00<0
07ooOol00Woo0P000goo0P0017oo00<007ooOol00Woo00@007ooOomoo`8000]oo`04001oogoo0002
Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo000@Ool01@00Oomoo`00Ool00P0000=o
o`00Ool02Woo00H007ooOol007oo0002Ool00`00Oomoo`05Ool200000goo001oo`05Ool00`00Ool0
0008Ool01000Oomoo`001Woo00<007oo00001Woo0@0000000`00Oomoo`030002Ool00`00Ool00002
Ool300000goo001oo`03Ool3000017oo001oo`000Woo00<007ooOol010002Goo00@007ooOol0009o
o`800004Ool00000Ool20006Ool01000Oomoo`000Woo00<007ooOol00P000Woo00<007ooOol02Goo
00@007ooOol0009oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800004Ool0
0000Ool20002Ool2000017oo001oogoo0P000Woo00<007oo00000goo00<007oo00000Woo0P0000Ao
o`00Oomoo`80009oo`03001oo`0000=oo`04001oogoo0002Ool00`00Oomoo`020002Ool00`00Oomo
o`09Ool00`00Oomoo`02000017oo000007oo0P0000Aoo`00001oo`80009oo`04001oogoo0002Ool0
0`00Oomoo`04Ool200000goo00000002Ool01000Oomoo`000Woo00D007ooOomoo`00009oo`800003
Ool0000000Eoo`800005Ool00000Ool00005Ool300000goo001oo`03Ool3000017oo001oo`001Goo
0`000Goo0@0000000`00Oomoo`03Ool200000goo001oo`020005Ool01000Ool000001Goo00H007oo
Ool007oo0006Ool01@00Ool00000Ool00P0000=oo`0000000Woo00D007ooOomoo`00009oo`03001o
ogoo00800003Ool00000009oo`04001oogoo0003Ool00`00Oomoo`0200000goo0000000200001Woo
000007oo001oo`800005Ool007ooOol00002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001o
ogoo0002Ool01000Oomoo`000Woo00<007ooOol00goo00<007ooOol00Woo0P000Woo00<007oo0000
0goo00<007ooOol00Woo0P0017oo00@007ooOol0009oo`03001oo`0000=oo`04001oogoo0002Ool2
000017oo000007oo0P0000Aoo`00001oo`800003Ool00000009oo`04001oogoo0002Ool01000Oomo
o`000Woo00D007ooOomoo`00009oo`800004Ool00000Ool20002Ool00`00Oomoo`020002Ool00`00
Oomoo`02000017oo000007oo0P000Woo00<007ooOol00P000Woo00<007ooOol00goo00D007ooOol0
07oo008000Eoo`04001oo`000005Ool01P00Ool00000Ool000Eoo`40000000@007oo001oo`800003
Ool007oo00Aoo`800003Ool007oo00Aoo`800005Ool007ooOol00005Ool40005Ool200001Goo0000
07oo00000Woo00<007oo00000Woo00@007ooOol0009oo`800005Ool00000Ool00002Ool00`00Ool0
0002Ool01000Oomoo`000Woo0P0000Aoo`00001oo`80009oo`800003Ool00000009oo`04001oogoo
0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0004Ool2000017oo001oogoo0P00
0Woo00@007oo0000009oo`03001oo`00009oo`800004Ool007ooOol20002Ool01000Ool000000Woo
00<007oo00000Woo00@007ooOol0009oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00
001oo`80009oo`04001oogoo0002Ool01`00Oomoogoo001oo`00009oo`04001oo`000002Ool01000
Oomoo`000Woo00<007ooOol00Woo00D007ooOol007oo00800003Ool00000009oo`04001oogoo0007
Ool01P00Ool00000Ool000Eoo`800003Ool007oo00Aoo`800003Ool007oo008000Eoo`04001oo`00
Ool100000003001oogoo00Eoo`04001oo`000007Ool20008Ool30008Ool20008Ool00`00Oomoo`02
0002Ool00`00Oomoo`0:Ool00`00Oomoo`020002Ool00`00Oomoo`0COol01000Oomoo`000Woo00D0
07ooOol007oo00800005Ool007ooOol00002Ool01000Oomoo`000Woo00<007ooOol00goo00D007oo
Oomoo`0000Aoo`03001oogoo00=oo`03001oogoo009oo`05001oogooOol00004Ool20004Ool01000
Oomoo`000Woo00<007ooOol057oo00@007ooOol0009oo`05001oogoo001oo`020002Ool00`00Oomo
o`0:Ool00`00Oomoo`020002Ool00`00Oomoo`07Ool00`00Oomoo`020002Ool20008Ool01000Ool0
00001goo0P0027oo0`001Woo0@0000001000Oomoo`000Woo00<007ooOol00goo00H007ooOol007oo
0003Ool01P00Oomoo`00Ool000Ioo`06001oo`00001oo`000goo00@007ooOol0009oo`04001oogoo
0004Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0004Ool01000Oomoo`000Woo00@0
07ooOol0009oo`03001oogoo00800003Ool00000009oo`04001oogoo0002Ool01000Oomoo`001Woo
00@007ooOol0009oo`06001oogoo001oo`000Woo00@007ooOol0009oo`04001oogoo0005Ool01000
Oomoo`000Woo00@007ooOol0009oo`04001oogoo0005Ool01000Oomoo`000Woo00@007ooOol0009o
o`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomo
o`020004Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0004Ool01000Oomoo`000Woo
00@007ooOol0009oo`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`001Goo00H007ooOol0
07oo0003Ool01P00Oomoo`00Ool000Ioo`05001oo`00001oo`0100000003001oogoo00Aoo`800004
Ool000000004Ool00`00Ool000030005Ool2000017oo001oo`0017oo00<007oo00000Woo00D007oo
Oomoo`00009oo`800004Ool00000Ool20002Ool00`00Oomoo`03Ool01`00Oomoo`00Ool007oo0080
0003Ool00000009oo`03001oogoo00Moo`04001oogoo0002Ool01@00Oomoo`00Ool00P0000Aoo`00
001oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00Oomoo`80009oo`03001oo`00009o
o`<000=oo`03001oogoo009oo`8000=oo`<0009oo`03001oo`00009oo`8000=oo`08001oo`00001o
o`00Ool0009oo`04001oogoo0007Ool01000Oomoo`000Woo00D007ooOol007oo00800004Ool00000
Ool200000goo001oo`0200001Goo001oogoo00001Goo0P0000Aoo`00001oo`800004Ool007oo0002
Ool01000Oomoo`000Woo0P0000Eoo`00000007oo00800003Ool007oo00Aoo`800004Ool000000004
Ool00`00Ool000030005Ool400000goo001oo`03Ool100000004001oogooOol20007Ool200000goo
001oo`07Ool20007Ool200000goo001oo`04Ool01000Oomoo`000Woo00<007ooOol027oo00@007oo
Ool0009oo`03001oogoo00Qoo`04001oogoo0002Ool20002Ool01000Oomoo`000Woo00@007ooOol0
009oo`03001oogoo01=oo`03001oogoo00=oo`03001oogoo00Qoo`07001oogooOol007oo00000goo
00<007ooOol027oo00D007ooOomoo`0000Moo`04001oogoo0002Ool00`00Oomoo`0200000goo0000
0002Ool01000Oomoo`000Woo00@007ooOol000ioo`04001oogoo0002Ool01000Oomoo`002Woo00@0
07ooOol0009oo`04001oogoo000<Ool20007Ool01000Oomoo`0027oo00<007ooOol01Woo00@007oo
Oomoo`40000000<007oo00000goo00H007ooOol007oo0004Ool00`00Ool00002Ool00`00Ool00003
Ool01P00Oomoo`00Ool000=oo`06001oogoo001oo`000goo00@007ooOol0009oo`800004Ool00000
Ool20002Ool01@00Oomoogoo00000Woo0P0000Aoo`00001oo`80009oo`06001oogoo001oo`0017oo
00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo
0002Ool01000Oomoo`000Woo00<007oo00000goo00D007oo000007oo0080009oo`03001oo`0000=o
o`03001oo`00009oo`03001oogoo00800003Ool007oo009oo`04001oo`00Ool200001Goo000007oo
00000goo00@007ooOol0009oo`05001oogooOol00002Ool01000Oomoo`000Woo00@007ooOol0009o
o`04001oogoo0002Ool200000goo00000002Ool01000Oomoo`000goo00<007ooOol00P0000Aoo`00
001oo`80009oo`03001oogoo00Aoo`03001oogoo00800003Ool00000009oo`03001oo`0000=oo`06
001oogoo001oo`000Woo00H007oo001oo`00Ool200000goo001oo`02Ool01P00Oomoo`00Ool0009o
o`80005oo`40000000@007oo001oo`<000Eoo`<00004Ool007oo0004Ool00`00Ool000020004Ool0
0`00Ool000020002Ool01000Oomoo`000Woo00@007ooOol0009oo`05001oo`00001oo`0200001goo
001oogoo001oo`0000=oo`05001oogoo001oo`0200001Goo001oogoo00000Woo00<007ooOol00P00
0Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`02000017oo000007oo0P0000Aoo`00
001oo`800008Ool007ooOol007oo001oo`8000Aoo`8000Aoo`800004Ool00000Ool200000goo0000
0004Ool20004Ool200000goo00000002Ool01000Oomoo`000Woo00@007ooOol0009oo`06001oogoo
001oo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01@00Ool00000Ool00P0000Eoo`00001o
o`0000=oo`06001oogoo001oo`000Woo00D007oo000007oo00800005Ool007ooOol00002Ool20000
1Woo001oogoo001oo`800003Ool007oo00=oo`03001oo`00008000Aoo`03001oo`0000<00003Ool0
07oo00=oo`03001oo`00008000Aoo`03001oo`000080005oo`40000000<007ooOol017oo00D007oo
Oomoo`0000Eoo`03001oo`00009oo`03001oogoo00=oo`04001oogoo0005Ool01000Oomoo`000Woo
00D007ooOomoo`00009oo`03001oogoo00Moo`03001oogoo0080009oo`04001oogoo0006Ool01000
Oomoo`0017oo00D007ooOomoo`00009oo`04001oogoo0002Ool01000Oomoo`004Woo00@007ooOol0
00Eoo`8000Aoo`8000eoo`8000=oo`03001oo`0000Qoo`04001oogoo0002Ool01000Oomoo`000goo
00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol02Woo00@007ooOol0
00=oo`04001oogoo0009Ool01000Oomoo`000goo00@007ooOol000Ioo`04001oogoo0005Ool01000
Oomoo`0027oo00@007ooOol000Eoo`04001oogoo0006Ool100000006001oogoo001oo`000Woo00D0
07oo001oo`00009oo`03001oo`00009oo`07001oo`00Ool007oo00000Woo00L007oo001oo`00Ool0
0002Ool00`00Ool00003Ool00`00Ool00002Ool01000Oomoo`000Woo00@007ooOol0009oo`03001o
ogoo009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oo`00009oo`04
001oogoo0002Ool01@00Oomoo`00Ool00P0000Ioo`00001oo`00Ool2000017oo000007oo0P000Woo
00D007ooOol007oo00800005Ool007ooOol00002Ool01000Oomoo`000Woo0P0000=oo`00Ool00P00
0Woo00@007ooOol0009oo`05001oogoo001oo`020002Ool200001Goo001oogoo00000Woo00@007oo
Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`800004Ool00000Ool3
0002Ool01000Oomoo`000Woo00<007oo00000Woo00@007ooOol0009oo`04001oogoo0002Ool01P00
Oomoo`00Ool0009oo`04001oogoo0002Ool02P00Oomoo`00Ool007oo001oo`000Woo00D007oo001o
o`00009oo`03001oo`00009oo`80009oo`03001oo`00009oo`06001oo`00Ool007oo0P000Goo0@00
00001000Oomoo`000Woo00L007oo001oo`00Ool00002Ool00`00Ool00002Ool20002Ool01@00Oomo
o`00Ool00P000Woo00H007ooOol007oo0002Ool4000017oo000007oo0P001goo0P0000Aoo`00001o
o`800004Ool007oo0006Ool01@00Ool00000Ool00P0000Eoo`00Oomoo`00009oo`04001oogoo0002
Ool01000Oomoo`000Woo00<007ooOol03Goo0P0000=oo`0000000Woo00@007ooOol0009oo`04001o
ogoo0002Ool01000Oomoo`001Goo00@007ooOol0009oo`04001oogoo0002Ool01000Ool000001Woo
00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`02000017oo000007oo0P0000Aoo`00001o
o`80009oo`03001oogoo00Qoo`05001oo`00001oo`02000017oo000007oo0P001goo0P0000Ioo`00
001oo`00Ool200000goo001oo`03Ool01000Ool000000Woo00X007ooOol007oo001oo`00Ool000Ao
o`03001oogoo0080009oo`03001oo`00009oo`80009oo`03001oogoo009oo`40000000<007oo0000
17oo00D007ooOomoo`0000Aoo`04001oogoo0002Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo
00<007oo00003Goo00@007ooOol000eoo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Ool00000
Ool00P000Woo00@007ooOol0009oo`03001oogoo00Qoo`03001oo`0000=oo`8000Moo`03001oogoo
009oo`03001oo`0000=oo`03001oo`0000Ioo`80025oo`04001oogoo0004Ool01000Oomoo`003Goo
00@007ooOol0011oo`04001oogoo0003Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00@007oo
Ool0009oo`03001oogoo00=oo`04001oogoo0006Ool100000004001oo`00Ool200000goo001oo`02
Ool02000Ool00000Ool007oo0004Ool01@00Ool007oo000017oo00<007oo00000Woo00<007oo0000
0Woo00L007oo000007oo001oo`020007Ool2000017oo000007oo0P0000=oo`0000002Goo0P0000Eo
o`00000007oo00800004Ool00000Ool2000017oo000007oo0P0000=oo`0000004Goo00L007oo0000
07oo001oo`020004Ool20004Ool200000goo00000002Ool01000Ool0000017oo0P0017oo0P0000=o
o`0000000Woo0P0000Aoo`00001oo`800004Ool00000Ool200001Woo000007oo001oo`800004Ool0
0000Ool200001Goo000007oo00003Goo0P0000Aoo`00001oo`800003Ool0000000Eoo`04001oo`00
Ool2000017oo000007oo0P0000=oo`00000017oo00H007ooOomoo`00Ool200000goo001oo`02Ool0
2000Ool00000Ool007oo0004Ool01@00Ool007oo000017oo00<007oo00000goo0@0000001000Oomo
o`000Woo00@007ooOol0009oo`04001oogoo0002Ool01P00Ool00000Ool000=oo`06001oo`00001o
o`000goo00D007ooOol007oo00800004Ool007oo0002Ool01000Oomoo`000Woo00@007ooOol0009o
o`06001oogoo001oo`000Woo00@007oo0000009oo`04001oogoo0002Ool01000Oomoogoo0P000Woo
00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`03001oogoo
0080009oo`03001oogoo0080009oo`05001oogoo001oo`0200000goo00000002Ool00`00Ool00002
Ool01000Oomoo`000Woo0P0000Eoo`00001oo`00009oo`04001oogoo0003Ool01000Oomoo`000Woo
00@007ooOol0009oo`03001oogoo0080009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007oo
Ool00P0000=oo`0000000P0000Eoo`00001oo`00009oo`03001oo`00009oo`04001oogoo0002Ool0
1000Oomoo`000Woo00H007ooOol007oo0002Ool01000Oomoo`000goo00@007oo0000009oo`04001o
ogoo0002Ool01@00Oomoo`00Ool00P000Woo00H007oo000007oo0003Ool01P00Ool00000Ool0009o
o`80005oo`40000000@007ooOomoo`8000Moo`80009oo`03001oogoo00Aoo`03001oo`0000Moo`80
0003Ool007oo00Aoo`05001oogooOol00002Ool00`00Oomoo`04Ool01000Oomoo`000Woo00D007oo
Oomoo`00009oo`03001oogoo00Aoo`04001oogoo0002Ool00`00Oomoo`02Ool01000Oomoo`000Woo
00@007ooOol0009oo`03001oogoo00ioo`04001oogoo0002Ool01@00Oomoogoo00002Woo00L007oo
Oomoo`00Ool00003Ool00`00Oomoo`08Ool01@00Oomoogoo00000goo00@007ooOol0009oo`04001o
ogoo0002Ool00`00Oomoo`02Ool01000Oomoo`000goo00@007ooOol0009oo`03001oogoo00Yoo`04
001oogoo0003Ool01000Oomoo`002Goo00@007ooOol000=oo`04001oogoo0004Ool00`00Oomoo`05
Ool20007Ool01@00Oomoogoo00001Woo00<007oo00001Woo00<007ooOol00Woo0@0000000`00Oomo
o`05Ool00`00Ool00006Ool00`00Ool00002Ool00`00Oomoo`03Ool200000goo001oo`05Ool00`00
Ool00004Ool01000Oomoo`000Woo00H007oo000007oo0002Ool01000Oomoo`000Woo00@007ooOol0
009oo`06001oo`00001oo`000Woo00H007ooOol007oo0002Ool01000Oomoo`000Woo00@007ooOol0
009oo`03001oogoo00800004Ool00000Ool2000017oo000007oo0P000Woo00D007ooOomoo`00009o
o`80009oo`8000Aoo`80009oo`03001oo`0000=oo`8000=oo`8000Aoo`80009oo`80009oo`80009o
o`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomo
o`000Woo00H007oo000007oo0002Ool200001Goo001oogoo00000Woo00@007ooOol0009oo`05001o
o`00001oo`0200001Goo001oogoo00000Woo00@007ooOol0009oo`04001oo`000002Ool200000goo
001oo`05Ool00`00Ool00008Ool01000Oomoo`001Goo00@007ooOol000Ioo`40000000<007ooOol0
10001Goo10000Woo00<007ooOol00Woo0P0000=oo`0000001Goo00H007oo000007oo0006Ool01000
Oomoo`000Woo0P0000Aoo`00001oo`8000=oo`04001oogoo0002Ool00`00Oomoo`0200000goo0000
0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo0P00
00Aoo`00001oo`800004Ool00000Ool200000goo00000002Ool00`00Oomoo`04Ool00`00Oomoo`02
00001Goo001oogoo00001Goo00<007ooOol00goo00D007ooOol007oo0080009oo`03001oogoo00=o
o`800003Ool00000009oo`04001oogoo0002Ool01000Oomoo`001Goo00@007ooOol000=oo`04001o
ogoo0002Ool01000Oomoo`000Woo0P0000=oo`0000000Woo00@007ooOol000=oo`03001oogoo0080
0004Ool00000Ool20002Ool00`00Oomoo`03Ool01000Oomoogoo0P0000=oo`0000001Goo00@007oo
000000Eoo`@00003Ool0000000Aoo`800003Ool0000000Eoo`05001oo`00001oo`0100000003001o
ogoo00Ioo`03001oogoo00Qoo`8000Moo`8000Yoo`<0009oo`04001oogoo000:Ool01000Oomoo`00
0Woo00@007ooOol000Moo`04001oogoo0002Ool01P00Oomoo`00Ool0009oo`04001oogoo0002Ool0
1000Oomoo`004goo00<007ooOol00Woo00<007ooOol037oo00<007ooOol00goo00<007ooOol037oo
00<007ooOol01Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Ool00002Ool01000Oomoo`00
0Woo00@007ooOol000ioo`04001oogoo0002Ool01000Oomoo`002Woo00@007ooOol0009oo`04001o
ogoo0007Ool20007Ool2000:Ool20007Ool20007Ool100000005001oo`00Ool00002Ool01P00Oomo
ogoo001oo`800004Ool007oo0004Ool00`00Ool00002Ool01`00Oomoogoo001oo`00009oo`03001o
o`0000=oo`04001oogoo0002Ool01`00Ool00000Ool007oo0080009oo`03001oogoo00=oo`05001o
ogoo001oo`0200001Goo000007oo00000Woo00<007ooOol00Woo00D007ooOomoo`00009oo`04001o
ogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo
00<007ooOol00Woo00@007oo001oo`@0009oo`8000=oo`03001oo`0000=oo`800003Ool007oo00<0
0003Ool0000000Aoo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`05001oogoo
Ool00002Ool01000Oomoo`000Woo00H007ooOomoo`00Ool20002Ool300001Goo000007oo00000Woo
00@007ooOol0009oo`05001oogoo001oo`0200001Goo001oogoo00000Woo00@007ooOol0009oo`80
0003Ool00000009oo`07001oogooOol007oo00000Woo00L007ooOomoo`00Ool00002Ool00`00Ool0
0004Ool00`00Ool00002Ool01`00Oomoogoo001oo`0000=oo`40000000<007oo000017oo0`0000=o
o`00Ool00goo00<007ooOol00`0000=oo`00Ool00goo0`0000=oo`00Ool00goo00@007oo001oo`80
009oo`04001oogoo000:Ool01000Oomoo`000Woo00@007ooOol000Yoo`03001oogoo00800004Ool0
0000Ool2000017oo000007oo0P0000Aoo`00001oo`80015oo`800006Ool007oo001oo`000Woo0P00
17oo0P000Woo00<007oo00000goo00<007oo00000Woo0P0017oo00L007ooOomoo`00Ool00004Ool0
1@00Ool00000Ool00P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00
001oo`8000ioo`04001oogoo0002Ool01000Oomoo`001goo00@007ooOol0009oo`04001oogoo0002
Ool00`00Oomoo`03Ool300000goo001oo`03Ool300000goo001oo`06Ool300000goo001oo`03Ool3
00000goo001oo`04Ool100000004001oogoo0002Ool00`00Oomoo`03Ool01000Oomoo`000Woo00<0
07ooOol00goo00@007ooOol000Eoo`06001oogoo001oo`0037oo00D007oo000007oo008000eoo`06
001oo`00001oo`006Woo00D007oo000007oo00800004Ool00000Ool200000goo001oo`05Ool01000
Oomoo`001Goo00<007ooOol00goo00H007ooOol007oo0002Ool00`00Oomoo`09Ool01@00Oomoo`00
Ool00P008Goo00<007ooOol00P000Woo0P0000=oo`00Ool037oo0P0000=oo`0000003goo0P0000=o
o`00Ool017oo00@007ooOol000Eoo`06001oogoo001oo`001Woo00@007ooOol000Eoo`03001oogoo
009oo`40000000H007ooOol007oo0002Ool00`00Ool00002Ool20002Ool00`00Ool00002Ool01@00
Ool007oo00000Woo00L007oo001oo`00Ool00002Ool00`00Ool00002Ool2000017oo000007oo0P00
1goo00D007oo000007oo00800004Ool00000Ool20006Ool00`00Oomoo`020002Ool01000Oomoo`00
0Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`0=Ool01P00Oomoo`00Ool000=oo`06
001oo`00001oo`000Woo0P0000=oo`00Ool00Woo00<007oo00000goo00H007oo000007oo0002Ool2
00000goo001oo`02Ool00`00Oomoo`02Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo
0002Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo00Qoo`800004Ool00000Ool20000
0goo00000009Ool2000017oo000007oo0P0000=oo`00000017oo00X007ooOol007oo001oo`00Ool0
009oo`07001oo`00Ool007oo00000Woo00<007oo00000Woo00D007oo001oo`00009oo`06001oo`00
Ool007oo0P000Goo0@0000001000Oomoogoo0P000Woo00<007oo00000Woo0P000Woo00<007oo0000
0Woo00<007ooOol00P0000Eoo`00Oomoo`00009oo`800005Ool007ooOol00004Ool01000Oomoo`00
0Woo0P0000=oo`0000000Woo00@007ooOol000=oo`04001oogoo0002Ool200000goo00000002Ool0
1P00Oomoo`00Ool000Aoo`04001oogoo0002Ool01000Oomoo`000Woo00D007oo000007oo00800004
Ool00000Ool2000017oo000007oo0P0000=oo`00Ool00Woo00D007oo001oo`0000=oo`03001oo`00
009oo`05001oo`00Ool00003Ool01000Ool000000goo00<007oo00000goo00H007oo001oo`00Ool2
00001Goo001oogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`04001oogoo0002Ool01000
Oomoo`000goo0P0000Ioo`00001oo`00Ool200000goo00000002Ool01000Oomoo`000goo00<007oo
Ool00P0000Aoo`00001oo`80009oo`03001oogoo0080009oo`04001oogoo0002Ool00`00Ool00002
Ool00`00Oomoo`0200001Goo001oogoo00000Woo00L007ooOomoo`00Ool00002Ool01`00Ool007oo
001oo`00009oo`04001oogoo0003Ool100000004001oogoo0002Ool00`00Oomoo`03Ool01000Oomo
o`001goo00D007ooOomoo`0000Aoo`05001oogooOol00005Ool00`00Ool00002Ool00`00Oomoo`09
Ool01P00Oomoo`00Ool0009oo`03001oogoo00Uoo`04001oogoo0002Ool20002Ool01000Oomoo`00
0Woo00@007ooOol001Qoo`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`001Goo00<007oo
Ool00goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`03Ool01000Oomoo`000Woo00@0
07ooOol0009oo`80009oo`04001oogoo0002Ool01000Oomoo`004Woo00H007ooOol007oo0002Ool0
0`00Oomoo`06Ool01000Oomoo`0017oo00@007ooOol000Aoo`03001oogoo009oo`05001oogooOol0
0005Ool01000Ool000000Woo00<007ooOol00Woo00D007ooOomoo`0000Aoo`03001oogoo0080005o
o`40000000<007oo000017oo00D007oo001oo`0000Ioo`06001oo`00001oo`000goo00H007ooOol0
07oo0006Ool01@00Ool007oo00000goo00@007ooOol0009oo`04001oogoo0003Ool01000Oomoo`00
0goo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`07Ool01000Oomoo`000Woo00@007oo
Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool0
1`00Oomoogoo001oo`00009oo`04001oogoo0002Ool00`00Oomoo`03Ool01000Oomoo`000Woo00H0
07ooOol007oo0003Ool00`00Oomoo`02Ool01000Oomoo`000Woo00@007ooOol0009oo`03001oogoo
00Aoo`04001oogoo0003Ool01@00Oomoo`00Ool00P0000Aoo`00001oo`80009oo`04001oogoo0002
Ool01@00Oomoogoo00000goo00@007ooOol0009oo`04001oogoo0002Ool01@00Oomoogoo00000Woo
00L007ooOomoo`00Ool00002Ool00`00Ool00004Ool01@00Ool007oo00001Woo00H007oo000007oo
0003Ool01P00Ool00000Ool000Eoo`40000000@007oo001oo`800003Ool007oo009oo`06001oo`00
001oo`001Goo00@007ooOol0009oo`04001oogoo0002Ool40006Ool00`00Ool00002Ool01000Oomo
o`000Woo00@007ooOol0009oo`06001oogoo001oo`000Woo00@007ooOol0009oo`04001oogoo0002
Ool01000Ool007oo0P0000Eoo`00Oomoo`00009oo`04001oogoo0002Ool01@00Oomoo`00Ool00P00
00Aoo`00001oo`800003Ool00000009oo`04001oogoo0002Ool01@00Ool007oo00000goo0P0017oo
0P0000Moo`00000007oo001oo`020004Ool20003Ool01000Ool007oo0`000Woo00@007ooOol0009o
o`04001oogoo0002Ool01P00Ool00000Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@0
07ooOol0009oo`04001oogoo0002Ool01P00Oomoo`00Ool0009oo`04001oogoo0002Ool01000Oomo
o`000Woo00H007ooOol007oo0002Ool01000Oomoo`0017oo00H007ooOomoo`00Ool200000goo001o
o`02Ool01P00Ool00000Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00L007ooOol007oo
001oo`0100000004001oogoo0002Ool01`00Ool007oo001oo`0000Aoo`03001oo`000080009oo`03
001oo`00009oo`80009oo`03001oogoo009oo`05001oo`00001oo`0200001Goo000007oo000027oo
00D007oo000007oo00800005Ool00000Ool00008Ool01@00Ool00000Ool00P000Woo00@007ooOol0
009oo`04001oogoo0002Ool01000Oomoo`003goo00<007ooOol00P0000Ioo`00Oomoo`00Ool20004
Ool200000goo001oo`02Ool00`00Ool00002Ool00`00Oomoo`020004Ool200001Goo001oogoo0000
0Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol00P0000Aoo`00
001oo`800003Ool00000009oo`03001oogoo00Uoo`05001oo`00001oo`0200001Goo000007oo0000
1Goo00D007ooOol007oo00800005Ool00000Ool00002Ool02`00Oomoogoo001oo`00Ool007oo0000
0Woo00L007oo001oo`00Ool00004Ool00`00Oomoo`020002Ool00`00Ool00002Ool20002Ool00`00
Oomoo`02Ool100000004001oogoo0002Ool00`00Oomoo`03Ool01000Oomoo`0027oo00<007oo0000
1Woo00@007oo000000eoo`03001oogoo0080009oo`03001oogoo00Yoo`04001oogoo0003Ool00`00
Oomoo`0FOol00`00Oomoo`02000017oo000007oo0P0000Aoo`00Ool0009oo`03001oogoo00Eoo`03
001oogoo00=oo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00=oo`03
001oogoo00=oo`04001oogoo000MOol01P00Oomoo`00Ool000=oo`04001oogoo000<Ool20002Ool0
1000Oomoo`002Goo00<007ooOol00P001goo00@007ooOol000Qoo`03001oogoo00Ioo`03001oo`00
00Qoo`03001oogoo0040000000<007ooOol017oo0P0000=oo`0000001Goo00<007oo00000`001Goo
0P0000=oo`00Ool01Goo00H007oo001oo`00Ool200001Goo000007oo00001Goo00D007ooOol007oo
00800005Ool00000Ool00002Ool00`00Oomoo`03Ool01@00Ool00000Ool00`0000Aoo`00001oo`80
0004Ool00000Ool200001Goo000007oo00000Woo00<007ooOol02goo00@007ooOol0009oo`800004
Ool007ooOol20004Ool20002Ool01@00Ool00000Ool00P0000Aoo`00Oomoo`8000Aoo`80009oo`05
001oo`00Ool00002Ool01@00Oomoo`00Ool00P0000Aoo`00001oo`800003Ool00000009oo`04001o
ogoo0002Ool01000Oomoo`000Woo00@007ooOol000Uoo`05001oo`00001oo`0200001Goo000007oo
000027oo00D007oo000007oo00800005Ool00000Ool00003Ool01P00Ool00000Ool000Eoo`800004
Ool000000004Ool00`00Ool000030005Ool400000goo001oo`03Ool100000004001oo`00Ool20000
0goo001oo`04Ool200000goo001oo`05Ool00`00Ool000020006Ool4000;Ool01@00Ool00000Ool0
0P0000Eoo`00001oo`0000Eoo`05001oo`00001oo`0200001Goo000007oo00000Woo00<007ooOol0
2Goo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo0P0000Aoo`00001oo`800005
Ool00000Ool00005Ool01000Oomoogoo0P000goo0P0017oo00<007ooOol00Woo0P000goo0P000Woo
0P0017oo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`0;Ool01000Oomoo`000Woo00D0
07oo000007oo00800003Ool0000000800005Ool00000Ool00002Ool00`00Oomoo`03Ool01@00Ool0
0000Ool00P0000Eoo`00001oo`0000Qoo`06001oo`00001oo`001Goo00<007oo00000P001Woo0P00
00=oo`00Ool01Goo00D007oo001oo`0000Ioo`<0005oo`40000000<007ooOol01Woo00<007oo0000
1Woo00@007ooOol000Qoo`03001oo`0000Ioo`04001oo`00Ool200000goo0000000<Ool00`00Oomo
o`020002Ool00`00Oomoo`0:Ool01@00Oomoo`00Ool00P0000Eoo`00001oo`00009oo`04001oogoo
000KOol00`00Oomoo`03Ool01000Oomoo`001Goo00<007ooOol00goo00<007ooOol00goo00@007oo
Ool000Eoo`03001oogoo00Uoo`07001oogoo001oo`00Ool00P0000Aoo`00001oo`80009oo`04001o
ogoo000COol01@00Oomoogoo00000Woo00<007ooOol02Woo0P0000=oo`00000027oo00@007ooOol0
00Qoo`03001oo`0000Ioo`03001oo`0000Uoo`03001oo`0000Eoo`40000000@007oo001oo`<000Eo
o`07001oo`00Ool007oo00000Woo00@007oo001oo`<000Aoo`03001oogoo0080009oo`03001oo`00
00Ioo`05001oo`00001oo`0200001Goo000007oo000027oo00D007oo000007oo00800005Ool00000
Ool0000=Ool01000Oomoo`000Woo0P0000=oo`0000000Woo00@007ooOol0009oo`04001oogoo0002
Ool01000Oomoo`000goo00@007ooOol0009oo`04001oogoo0002Ool200001Goo001oogoo00000Woo
00@007oo0000009oo`04001oogoo0002Ool01@00Oomoo`00Ool00`0000Aoo`00001oo`80009oo`04
001oogoo000<Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oo`00Ool200001Goo000007oo
000027oo00D007oo000007oo00800005Ool00000Ool00005Ool01@00Ool00000Ool00P0000Qoo`00
Oomoo`00Ool007oo0`0017oo00<007ooOol00P000Woo00L007ooOol007oo001oo`030002Ool00`00
Ool00002Ool20001Ool100000003001oogoo00Aoo`800005Ool007ooOol00003Ool01P00Ool00000
Ool000Eoo`800005Ool007ooOol00002Ool01000Oomoo`0017oo00@007ooOol0009oo`06001oogoo
001oo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Ool00002Ool01000Oomoo`000Woo
00<007oo00000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00D007ooOol0
07oo00800005Ool007ooOol00002Ool02000Oomoo`00Ool007oo0003Ool01P00Ool00000Ool000=o
o`03001oo`0000=oo`03001oo`0000=oo`800004Ool007oo0003Ool00`00Ool00002Ool01000Oomo
o`000Woo00D007ooOomoo`00009oo`05001oo`00001oo`0200001Goo000007oo00000Woo00@007oo
Ool0009oo`04001oogoo0002Ool00`00Ool00002Ool01000Oomoo`000Woo00@007ooOol0009oo`06
001oogoo001oo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo0P0000=o
o`00Ool017oo00@007ooOol0009oo`04001oogoo0002Ool200000goo001oo`04Ool01000Oomoo`00
0Woo00@007ooOomoo`40000000<007ooOol00Woo00<007ooOol017oo00<007ooOol00Woo00<007oo
Ool00Woo00D007ooOomoo`0000Ioo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0003Ool0
1000Oomoo`001Goo00@007ooOol000Aoo`04001oogoo000@Ool01000Oomoo`000Woo00D007ooOomo
o`00009oo`03001oogoo00Aoo`04001oogoo0002Ool01000Oomoo`000goo00<007oo00001Woo00<0
07oo00000goo00<007oo00000goo00<007oo00001Woo00<007oo00000goo00D007ooOomoo`00009o
o`04001oogoo0002Ool00`00Oomoo`0<Ool01000Oomoo`000Woo00@007ooOol0009oo`03001oogoo
009oo`04001oogoo0008Ool01000Oomoo`000goo00@007ooOol000Uoo`06001oogoo001oo`0017oo
00D007oo001oo`00009oo`05001oogooOol00004Ool01@00Oomoogoo00000Woo00<007oo00000Woo
00D007ooOomoo`0000Aoo`40000000@007ooOol0009oo`03001oo`0000=oo`06001oogoo001oo`00
0goo00@007ooOol0009oo`03001oo`0000=oo`06001oo`00001oo`000goo0P000Woo0P0000Moo`00
Oomoo`00Ool00002Ool01000Oomoo`000Woo00@007ooOol0009oo`06001oogoo001oo`000Woo00@0
07ooOol000Aoo`800004Ool00000Ool20002Ool01000Oomoo`000Woo00@007ooOol0009oo`03001o
ogoo0080009oo`04001oogoo0002Ool00`00Oomoo`020002Ool00`00Ool00003Ool01P00Oomoo`00
Ool000=oo`03001oo`00009oo`04001oogoo0002Ool01`00Oomoogoo001oo`00009oo`05001oogoo
Ool00002Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`00
0Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Ool00002Ool01000Oomoo`000Woo00@007oo
Ool0009oo`06001oogoo001oo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Ool00000
0Woo00@007ooOol0009oo`03001oo`0000=oo`06001oogoo001oo`000goo00H007ooOol007oo0002
Ool01P00Oomoogoo001oo`80005oo`40000000<007oo00000Woo00<007oo00000Woo0P0000Eoo`00
Oomoo`00009oo`800005Ool007ooOol00002Ool01`00Ool007oo001oo`00009oo`04001oo`00Ool2
0002Ool01000Oomoo`000Woo00D007ooOomoo`00009oo`03001oogoo00800003Ool00000009oo`04
001oogoo0003Ool01000Oomoo`000Woo100000=oo`00Ool00P0000Aoo`00001oo`8000=oo`04001o
ogoo0002Ool01000Oomoo`0017oo00@007ooOol0009oo`07001oogoo001oo`00Ool00P000Woo00H0
07oo000007oo0002Ool200000goo001oo`02Ool01000Ool000000Woo00`007oo000007oo001oo`00
Ool007oo0003Ool01000Oomoo`000Woo00D007ooOol007oo00800004Ool00000Ool2000017oo0000
07oo0P0000Eoo`00Oomoo`00009oo`04001oogoo0002Ool20003Ool01000Oomoo`000Woo0P0000=o
o`0000000Woo00@007ooOol000=oo`04001oogoo0002Ool200000goo00000002Ool00`00Oomoo`02
Ool20002Ool00`00Ool00002Ool00`00Oomoo`0200001Goo001oogoo00000Woo0P0000Eoo`00Oomo
o`00009oo`07001oo`00Ool007oo00000goo0@0000001@00Ool007oo00000Woo00<007ooOol017oo
00<007oo00001Woo00D007oo001oo`0000Ioo`04001oogoo000=Ool01P00Oomoo`00Ool0009oo`03
001oogoo00Eoo`07001oogooOol007oo00000Woo00@007ooOol0015oo`04001oogoo0002Ool01000
Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`02Ool00`00Ool00004Ool00`00Oomoo`05Ool00`00Oomoo`03Ool20003Ool01000Oomo
o`000Woo00<007ooOol047oo00@007ooOol0009oo`04001oogoo0003Ool01@00Oomoogoo00000Woo
00<007ooOol01Goo00H007ooOol007oo0002Ool00`00Oomoo`09Ool01000Oomoo`001Woo00<007oo
Ool00Woo00<007ooOol017oo00<007oo00001Woo00D007ooOomoo`0000Ioo`04001oogooOol10000
0003001oogoo00=oo`05001oogoo001oo`020005Ool01000Ool000001Goo00H007oo000007oo0006
Ool00`00Ool0000300000goo00000002Ool01000Oomoo`000goo00<007ooOol00P0000Aoo`00001o
o`80009oo`05001oogooOol00002Ool00`00Oomoo`02000017oo000007oo0P0000=oo`0000000Woo
0P000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`05
001oogooOol00005Ool01000Oomoo`001Goo00<007ooOol00goo00<007ooOol00goo00@007ooOol0
00Eoo`05001oogooOol00002Ool01000Oomoo`000Woo0P0000Aoo`00001oo`800004Ool00000Ool2
00000goo00000002Ool01000Oomoo`000Woo00@007ooOol000Aoo`04001oogoo0002Ool200000goo
00000002Ool01000Oomoo`000goo00@007ooOol0009oo`800003Ool00000009oo`04001oogoo0002
Ool40008Ool01000Ool000001Goo00@007oo000000Moo`800003Ool007oo00Aoo`40000000<007oo
Ool00`000Woo00<007ooOol00Woo0`0000=oo`00Ool00goo0`0000Aoo`00Ool000Eoo`<00003Ool0
07oo00Uoo`04001oogoo0002Ool01000Oomoo`002Woo00@007ooOol0009oo`04001oogoo000@Ool2
000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000=oo`00
00000Woo00<007oo00000goo00<007oo00000Woo00<007oo00000goo00L007ooOomoo`00Ool00002
Ool00`00Ool00003Ool00`00Ool00002Ool00`00Oomoo`02000017oo000007oo0P004Goo0P0000Ao
o`00001oo`800004Ool00000Ool30002Ool01000Oomoo`001goo00@007ooOol0009oo`04001oogoo
0002Ool00`00Oomoo`05Ool01000Oomoo`000Woo00<007ooOol00Woo00<007oo00000`0000=oo`00
Ool00goo0`0000=oo`00Ool00goo0`0000Aoo`00000000Aoo`05001oo`00001oo`0100000003001o
ogoo00Moo`03001oogoo00Ioo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo00800003Ool0
000000eoo`800004Ool007oo000>Ool20002Ool01000Oomoo`000Woo0P007goo00<007ooOol00goo
00<007ooOol00Woo00<007ooOol00goo00D007ooOomoo`0000Eoo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00aoo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol067oo0P0000=o
o`0000003Goo0P0000Aoo`00Ool000Qoo`8000Yoo`03001oogoo00Ioo`03001oogoo00Uoo`03001o
ogoo00Aoo`40000000<007ooOol00`000Woo00<007ooOol00Woo0`0000=oo`00Ool00goo0`0000Ao
o`00Ool000Aoo`06001oo`00001oo`002goo00@007ooOol0009oo`04001oogoo0007Ool01000Oomo
o`000Woo00@007ooOol0009oo`03001oogoo00aoo`04001oo`00Ool2000017oo000007oo0P0000Ao
o`00001oo`800004Ool00000Ool2000017oo000007oo0P000goo00<007oo00000Woo0P000Woo00@0
07oo0000009oo`03001oo`00009oo`800004Ool007ooOol20002Ool00`00Ool00003Ool01P00Ool0
07oo001oo`800003Ool00000015oo`800004Ool00000Ool2000017oo000007oo0P000Woo00@007oo
Ool0009oo`03001oogoo00Eoo`04001oogoo0002Ool01000Oomoo`002Woo00<007ooOol00P0017oo
00@007oo001oo`800003Ool007oo00=oo`<00003Ool007oo00=oo`<00004Ool000000004Ool01@00
Ool00000Ool00@0000000`00Oomoo`03Ool01@00Oomoo`00Ool00P001Goo00@007oo000000Eoo`05
001oo`00001oo`020004Ool2000017oo000007oo0P0000Aoo`00Ool0009oo`04001oogoo0002Ool0
0`00Oomoo`0200000goo00000002Ool01000Oomoo`000goo00<007ooOol00P0000=oo`0000000P00
0Woo00@007ooOol0009oo`04001oogoo0003Ool01000Oomoo`000Woo00@007ooOol0009oo`04001o
ogoo0002Ool01000Oomoo`000Woo00<007ooOol00Woo0P0017oo0P0017oo0P0000=oo`00000017oo
0P0017oo00<007ooOol00goo00@007ooOol0009oo`04001oogoo0002Ool2000017oo000007oo0P00
00Aoo`00001oo`800003Ool00000009oo`04001oogoo0002Ool01000Oomoo`000Woo00D007ooOomo
o`00009oo`800004Ool00000Ool20002Ool01000Oomoo`000goo00<007ooOol00P0000Aoo`00001o
o`80009oo`04001oogooOol40007Ool200000goo00000005Ool01000Ool000001goo0P0000=oo`00
000017oo0@0000001@00Ool007oo00000Woo00<007ooOol017oo00<007oo00001Woo00<007oo0000
0Woo00<007ooOol00goo00@007ooOol000]oo`04001oogoo0002Ool01000Oomoo`002Woo00@007oo
Ool0009oo`04001oogoo000BOol01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool0
1000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00goo0P001Goo00<007ooOol01Goo00<007oo
Ool00goo0P001Goo00D007ooOomoo`00009oo`04001oogoo000FOol01000Oomoo`000Woo00@007oo
Ool000=oo`03001oo`00009oo`03001oogoo00Qoo`04001oogoo0002Ool01000Oomoo`001goo00@0
07ooOol0009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03001oo`0000Ioo`03
001oogoo009oo`03001oogoo00=oo`04001oogooOol100000005001oo`00Ool00002Ool01`00Ool0
07oo001oo`00009oo`03001oogoo0080009oo`03001oo`00009oo`07001oo`00Ool007oo00000Woo
00H007oo001oo`00Ool200000goo00000002Ool01000Oomoo`000goo00<007ooOol00P0000Aoo`00
001oo`80009oo`05001oogooOol00002Ool00`00Oomoo`0200000goo001oo`02000017oo000007oo
0P0000=oo`0000000Woo00@007ooOol000=oo`04001oogoo0004Ool01000Oomoo`000Woo00@007oo
Ool0009oo`07001oo`00Ool007oo00000goo0P0000]oo`00Ool007oo001oo`00Ool007oo00800003
Ool007oo009oo`09001oo`00Ool007oo001oo`00009oo`04001oogoo0002Ool01@00Ool00000Ool0
0P0000Aoo`00001oo`800004Ool00000Ool200001Goo001oogoo00000Woo00@007ooOol0009oo`04
001oogoo0002Ool00`00Oomoo`02000017oo000007oo0P000Woo00D007ooOomoo`00009oo`03001o
ogoo00800003Ool00000009oo`04001oogoo0003Ool20002Ool00`00Ool00002Ool01`00Ool007oo
001oo`00009oo`03001oogoo00800005Ool007ooOol00002Ool01`00Ool007oo001oo`0000=oo`40
000000@007ooOol0009oo`03001oo`0000=oo`04001oo`000002Ool01000Oomoo`000Woo00H007oo
Ool007oo0003Ool01P00Ool00000Ool000=oo`04001oogoo0002Ool01000Oomoo`000Woo00<007oo
00000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Ool00002Ool01@00Oomoo`00Ool00P00
0Woo0P0000Aoo`00001oo`80009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol00P00
0Woo00@007ooOol0009oo`06001oogoo001oo`000Woo00@007ooOol0009oo`04001oogoo0002Ool0
1000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007oo0000
0Woo00@007ooOol0009oo`80009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009o
o`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`03001oogoo00800007Ool007oo
Ool007oo00000Woo00@007ooOol0009oo`04001oogoo0002Ool01P00Oomoo`00Ool0009oo`04001o
ogoo0002Ool00`00Ool00003Ool01P00Ool00000Ool000=oo`04001oogoo0002Ool00`00Ool00003
Ool01@00Ool00000Ool00@0000000`00Oomoo`02Ool01000Oomoo`0017oo00D007ooOomoo`0000Ao
o`05001oogooOol00002Ool01@00Oomoogoo000017oo00<007ooOol01goo00@007ooOol000=oo`04
001oogoo0009Ool01000Oomoo`000goo00@007ooOol000moo`04001oogoo0002Ool01000Oomoo`00
0goo00<007ooOol017oo00@007ooOol0009oo`04001oogoo0002Ool00`00Ool00002Ool01000Oomo
o`001Goo00<007ooOol00goo00@007ooOol0009oo`03001oo`0000=oo`03001oo`0000Ioo`04001o
ogoo0002Ool00`00Oomoo`0?Ool01000Oomoo`000Woo00@007ooOol0009oo`03001oo`0000=oo`04
001oogoo0009Ool01000Oomoo`000goo00@007ooOol000Eoo`05001oogooOol00002Ool00`00Oomo
o`02Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000Aoo`03001oogoo009oo`05001oogooOol0
0002Ool01@00Oomoogoo000017oo0@0000000`00Oomoo`02Ool01P00Oomoo`00Ool0009oo`06001o
ogooOol007oo0P0000=oo`00Ool00Woo00<007oo00000Woo00@007ooOol0009oo`04001oogoo0002
Ool01000Oomoo`000Woo00H007ooOol007oo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`06
001oogoo001oo`000Woo00@007ooOol000=oo`04001oogoo0002Ool01000Oomoo`000Woo00@007oo
Ool0009oo`04001oogoo0002Ool01P00Ool00000Ool0009oo`04001oogoo0002Ool01000Oomoo`00
0goo0P0017oo0P0017oo0P0000=oo`00000017oo0P0017oo0P000goo00D007oo001oo`00009oo`04
001oogoo0002Ool01000Oomoo`000Woo0P0000Aoo`00001oo`800005Ool00000Ool00002Ool01000
Oomoo`000Woo00P007ooOol007oo001oo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01P00
Oomoo`00Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007oo001oo`800003Ool007oo
00Aoo`04001oogoo0002Ool01`00Oomoogoo001oo`00009oo`03001oogoo00=oo`04001oogoo0002
Ool01000Oomoogoo0@0000000`00Oomoo`0200001Goo001oogoo00000Woo00@007oo0000009oo`0:
001oogoo001oo`00Ool007oo0002Ool00`00Ool00002Ool20002Ool00`00Ool00006Ool200001Woo
000007oo001oo`800003Ool0000000Moo`800004Ool00000Ool2000017oo001oo`0047oo0P0000Ao
o`00001oo`800004Ool00000Ool20002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oo`00
0002Ool01000Ool000000Woo00H007oo000007oo0003Ool01P00Ool00000Ool0009oo`800005Ool0
07ooOol00002Ool01@00Ool00000Ool00P0000Aoo`00001oo`80019oo`04001oogoo0002Ool01000
Oomoo`000Woo0P0000Aoo`00001oo`8000Moo`800003Ool007oo00800005Ool00000Ool00008Ool2
00001Goo000007oo00000Woo00@007oo001oo`<0009oo`05001oogoo001oo`020002Ool01@00Oomo
o`00Ool00P0000Eoo`00001oo`00009oo`03001oogoo0080005oo`40000000D007oo001oo`00009o
o`05001oo`00Ool00002Ool01`00Ool007oo001oo`00009oo`05001oo`00Ool00002Ool00`00Ool0
0002Ool20002Ool00`00Ool00003Ool01000Oomoo`000Woo00H007ooOol007oo0002Ool01000Oomo
o`000Woo00@007ooOol0009oo`03001oogoo009oo`04001oogoo0002Ool2000017oo000007oo0P00
00Aoo`00001oo`80009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001o
ogoo0002Ool01000Ool007oo0P000Woo00H007oo000007oo0002Ool200000goo001oo`02Ool01000
Ool000000Woo00H007oo000007oo0002Ool200000goo001oo`02Ool01000Oomoo`000Woo00<007oo
Ool00P0000Aoo`00001oo`800003Ool007oo00800005Ool00000Ool00002Ool01000Oomoo`000Woo
00@007ooOol000Aoo`04001oogoo0002Ool01000Oomoo`000Woo00H007ooOol007oo0002Ool01000
Oomoo`000Woo00@007ooOol0009oo`06001oogoo001oo`000Woo00D007oo001oo`00009oo`05001o
o`00Ool00002Ool01`00Ool007oo001oo`00009oo`05001oo`00Ool00002Ool02000Ool007oo001o
o`00Ool100000003001oo`00009oo`03001oo`0000Eoo`04001oogoo0005Ool01000Oomoo`000Woo
00<007ooOol00goo00@007ooOol000aoo`04001oogoo0003Ool01000Oomoo`001Woo00@007ooOol0
009oo`80009oo`03001oogoo00moo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009o
o`05001oogooOol00002Ool01000Oomoo`001Goo00<007ooOol017oo00<007ooOol00goo00<007oo
00001Goo00<007ooOol017oo00<007ooOol00goo00@007ooOol0009oo`04001oogoo000BOol01000
Oomoo`000Woo00@007ooOol0009oo`03001oogoo0080009oo`03001oogoo00Moo`04001oogoo0003
Ool01000Oomoo`002Goo00@007ooOol000Moo`06001oogoo001oo`001Goo00@007ooOol000Eoo`03
001oogoo00=oo`03001oogoo00=oo`04001oogooOol100000003001oogoo00=oo`04001oo`00Ool3
0004Ool00`00Ool000020004Ool00`00Oomoo`0300000goo001oo`03Ool01@00Ool00000Ool00P00
00Eoo`00001oo`00009oo`03001oo`0000=oo`05001oogoo001oo`0200001Goo001oogoo00000Woo
00<007oo00000Woo00<007ooOol00P0000=oo`00Ool00P0000Aoo`00001oo`800005Ool007ooOol0
0002Ool01000Oomoo`000Woo00H007ooOol007oo0002Ool01000Oomoo`000Woo00<007ooOol00Woo
0P0000Eoo`00Oomoo`00009oo`8000Aoo`03001oogoo009oo`80009oo`04001oo`000002Ool00`00
Oomoo`02Ool20002Ool01000Oomoo`000Woo00D007ooOol007oo00800004Ool00000Ool200000goo
00000002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Ool00002Ool0
1@00Ool00000Ool00P0000=oo`00Ool00Woo00H007ooOol007oo0002Ool01@00Ool00000Ool00P00
00Eoo`00Oomoo`00009oo`@00003Ool007oo00=oo`04001oo`00Ool30004Ool00`00Ool000020004
Ool00`00Oomoo`0300000goo001oo`03Ool100000004001oogoo0002Ool00`00Ool00003Ool01P00
Oomoo`00Ool000=oo`06001oogoo001oo`000Woo00H007ooOomoo`00Ool200000goo001oo`02Ool0
1@00Ool00000Ool00P000Woo00D007ooOomoo`00009oo`03001oogoo00800004Ool00000Ool20002
Ool01@00Oomoogoo00000Woo0P0000Eoo`00001oo`00009oo`04001oogoo0002Ool01000Oomoo`00
0Woo00@007ooOol0009oo`04001oogoo0003Ool01000Oomoo`000goo00@007ooOol000=oo`03001o
o`00009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool0
1P00Oomoo`00Ool000=oo`80009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009o
o`04001oogoo0002Ool200001Goo001oogoo00000Woo00D007ooOomoo`0000=oo`03001oogoo0080
0004Ool00000Ool20002Ool01000Oomoo`000goo00<007ooOol00P0000Aoo`00001oo`80009oo`04
001oogoo0004Ool00`00Ool00002Ool00`00Ool00003Ool01P00Oomoo`00Ool000=oo`06001oogoo
001oo`000Woo00L007ooOomoo`00Ool00002Ool100000003001oogoo00Aoo`03001oogoo008000Mo
o`8000Moo`04001oogoo0008Ool00`00Oomoo`07Ool01000Oomoo`000Woo00@007ooOol000Yoo`04
001oogoo0002Ool00`00Oomoo`0AOol01000Oomoo`000Woo00@007ooOol0009oo`800003Ool00000
009oo`04001oogoo0002Ool01@00Oomoogoo00000goo00<007oo00000goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol00Woo0P000goo00<007oo00000goo00D007ooOomoo`00009oo`04001o
ogoo000HOol01000Oomoo`000Woo00<007ooOol00Woo00@007ooOol000Yoo`04001oogoo0002Ool0
1000Oomoo`002Woo00@007ooOol0009oo`8000Moo`03001oogoo008000Moo`8000Moo`04001oo`00
0006Ool100000004001oo`00Ool200000goo001oo`02Ool01P00Ool00000Ool000Eoo`800004Ool0
00000006Ool40005Ool2000017oo000007oo0P001Goo00@007ooOomoo`800004Ool00000Ool20002
Ool00`00Oomoo`03Ool01@00Oomoo`00Ool00`0000Aoo`00001oo`800004Ool00000Ool200001Goo
001oogoo00000Woo00@007ooOol000Moo`04001oogoo0002Ool00`00Oomoo`03Ool20004Ool20002
Ool01000Ool000000Woo00<007oo00000Woo0P0017oo0P0017oo0P000Woo0P000Woo00D007ooOol0
07oo00800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800005Ool007ooOol00002
Ool01000Oomoo`001goo00<007ooOol00P0000Moo`00001oo`00Ool00002Ool01000Oomoo`000Woo
0P0000Aoo`00001oo`800003Ool0000000=oo`03001oogoo00=oo`800004Ool000000006Ool20000
0goo001oo`04Ool2000017oo001oo`001Woo0`000Goo0@0000000`00Ool00003Ool01000Oomoo`00
0Woo00<007ooOol00goo00H007ooOol007oo0003Ool01P00Oomoo`00Ool000Ioo`03001oo`0000Ao
o`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol000Aoo`04001oogoo0002Ool01000Oomo
o`000Woo00@007ooOol000Moo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04
001oogoo0002Ool01000Oomoo`000Woo00P007ooOol007oo001oo`000goo00<007ooOol00Woo0P00
0Woo00<007oo00000goo00<007oo00000Woo00<007ooOol00goo00L007ooOomoo`00Ool00003Ool0
1000Oomoo`000Woo00@007ooOol0009oo`03001oogoo00Moo`04001oogoo0002Ool00`00Oomoo`02
00000goo00000002Ool20002Ool01000Oomoo`000Woo00<007ooOol00Woo00@007ooOol0009oo`04
001oogoo0002Ool00`00Oomoo`05Ool01000Oomoo`000goo00H007ooOol007oo0003Ool01P00Oomo
o`00Ool000Ioo`06001oo`00001oo`000goo00H007ooOol007oo0005Ool100000004001oogooOol2
0007Ool30009Ool20007Ool30006Ool20002Ool00`00Oomoo`0:Ool00`00Oomoo`020002Ool00`00
Oomoo`0:Ool01@00Oomoo`00Ool00P0000Eoo`00Oomoo`00009oo`04001oogoo000FOol00`00Oomo
o`04Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`07Ool00`00Oomoo`02Ool20004Ool00`00Oomo
o`08Ool01000Oomoo`000Woo00D007ooOol007oo00800005Ool00000Ool00002Ool01000Oomoo`00
4goo00<007ooOol00P000Woo00<007ooOol01goo00<007ooOol00P0000=oo`0000000Woo00<007oo
Ool02Woo0P0027oo0P002Goo0P0027oo0P000Goo0@0000000`00Oomoo`04Ool200000goo001oo`05
Ool01P00Ool00000Ool000Eoo`800003Ool007oo00Aoo`06001oogoo001oo`0017oo00<007ooOol0
0P0000Aoo`00001oo`800007Ool007ooOol007oo00000Woo00@007ooOol0009oo`03001oogoo0080
0007Ool007ooOol007oo00000Woo00@007ooOol0009oo`04001oogoo0002Ool2000017oo000007oo
0P0000Aoo`00001oo`800004Ool00000Ool20002Ool01000Oomoogoo0P000Woo0P0017oo0P000goo
0`0000Aoo`00000000=oo`8000=oo`03001oo`00009oo`800005Ool00000001oo`020002Ool01000
Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo0P000Woo0P0000=o
o`0000000goo00@007ooOol0009oo`06001oogoo001oo`000Woo00D007oo000007oo0080009oo`04
001oogoo0004Ool01@00Oomoo`00Ool00P000Woo0P0000=oo`00Ool017oo0P0000Eoo`00Oomoo`00
009oo`03001oogoo00@000Eoo`800005Ool007ooOol00003Ool100000005001oogoo001oo`020005
Ool01P00Oomoo`00Ool000Ioo`04001oo`000005Ool01P00Ool00000Ool000Eoo`80009oo`03001o
ogoo00800004Ool00000Ool20002Ool01@00Oomoogoo00000Woo00<007ooOol00P0000=oo`000000
0Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`800004
Ool00000Ool2000017oo000007oo0P0000=oo`0000000Woo00<007ooOol017oo00@007ooOol0009o
o`04001oogoo0005Ool00`00Oomoo`03Ool01@00Oomoo`00Ool00P000Woo00<007ooOol00goo0P00
00=oo`0000000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0
009oo`05001oogoo001oo`0200000goo001oo`0200000goo00000002Ool01000Oomoo`000goo00<0
07ooOol00P0000Aoo`00001oo`80009oo`03001oogoo0080009oo`03001oogoo00800003Ool00000
00Eoo`04001oo`000005Ool01P00Oomoo`00Ool000Ioo`04001oo`000005Ool01@00Ool00000Ool0
0@0000000`00Oomoo`05Ool00`00Ool00008Ool30007Ool20008Ool02000Ool00000Ool007oo0002
Ool00`00Oomoo`08Ool00`00Oomoo`0200001Goo001oogoo00001goo00@007ooOol0009oo`06001o
o`00001oo`000Woo00@007ooOol0009oo`04001oogoo000COol00`00Oomoo`02Ool00`00Oomoo`0<
Ool00`00Oomoo`03Ool00`00Oomoo`0;Ool20008Ool01000Oomoo`000Woo00D007ooOol007oo0080
0005Ool007ooOol00002Ool01000Oomoo`000goo00<007ooOol02goo00@007ooOol0009oo`04001o
ogoo000:Ool01P00Oomoo`00Ool000=oo`03001oogoo00Eoo`8000Moo`8000Yoo`8000Moo`8000Mo
o`40000000@007oo001oo`800003Ool007oo009oo`06001oo`00001oo`001Goo00@007ooOol0009o
o`07001oogooOol007oo00000Woo00<007ooOol00goo00D007ooOomoo`00009oo`800004Ool00000
Ool200000goo00000006Ool00`00Oomoo`02000017oo000007oo0P000Woo00<007ooOol01Woo00@0
07ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002
Ool00`00Oomoo`020003Ool01000Ool007oo0`0000Eoo`00001oo`0000=oo`03001oo`0000=oo`80
0003Ool007oo00<00004Ool007oo0003Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo
0006Ool01000Oomoo`000Woo00<007ooOol00P0000Aoo`00001oo`800004Ool00000Ool200000goo
00000003Ool01000Oomoo`000Woo0P0000Aoo`00001oo`800003Ool00000009oo`05001oogooOol0
0002Ool200000goo00000002Ool01`00Oomoogoo001oo`00009oo`06001oogooOol007oo0P0000Eo
o`00Oomoo`00009oo`04001oogoo0002Ool01`00Oomoogoo001oo`0000=oo`40000000<007ooOol0
17oo00@007oo001oo`8000Eoo`06001oo`00001oo`000goo00D007oo000007oo008000Eoo`04001o
o`000002Ool01000Oomoo`000Woo00<007ooOol00Woo00@007ooOol0009oo`04001oogoo0002Ool0
1000Oomoo`0017oo00@007ooOol0009oo`800004Ool00000Ool2000017oo000007oo0P0000Eoo`00
Oomoo`00009oo`04001oogoo0004Ool01000Oomoo`000goo00@007ooOol0009oo`03001oo`0000=o
o`03001oogoo009oo`80009oo`03001oo`00009oo`800004Ool007ooOol20004Ool02@00Oomoogoo
001oo`00Ool00002Ool01@00Oomoo`00Ool00P0000Aoo`00001oo`800004Ool00000Ool200001Woo
000007oo001oo`80009oo`04001oogoo0002Ool00`00Ool00004Ool01000Oomoo`000Woo00@007oo
Ool0009oo`06001oogoo001oo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`02
Ool400000goo001oo`03Ool01000Ool007oo0P001Goo00H007oo000007oo0003Ool01P00Ool00000
Ool000Eoo`40000000<007ooOol00P0000=oo`00Ool01Woo0P001goo0P000Woo00<007ooOol01Goo
0P003Goo00<007ooOol00P000Woo00@007ooOol000Uoo`03001oogoo0080009oo`03001oogoo011o
o`04001oogoo0002Ool01000Oomoo`000Woo0P000Woo00@007ooOol0009oo`04001oogoo0005Ool0
0`00Oomoo`02Ool20004Ool20007Ool20004Ool20004Ool00`00Oomoo`03Ool01000Oomoo`000Woo
00@007ooOol0019oo`04001oogoo0002Ool01000Oomoo`000goo0P000goo00<007ooOol01Woo00@0
07ooOol000=oo`04001oogoo0009Ool00`00Oomoo`020007Ool40007Ool20007Ool200000goo0000
0007Ool20001Ool100000003001oogoo009oo`06001oogoo001oo`000Woo00L007ooOomoo`00Ool0
0002Ool01`00Oomoogoo001oo`00009oo`03001oo`0000Aoo`03001oo`00009oo`03001oogoo0080
0007Ool007ooOol007oo00000Woo00@007ooOol0009oo`04001oogoo0002Ool01P00Oomoo`00Ool0
009oo`04001oogoo0003Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000
Oomoo`000Woo0P0000=oo`0000000goo00@007ooOol0009oo`800003Ool00000009oo`8000Aoo`80
009oo`05001oo`00001oo`030003Ool20004Ool20002Ool2000017oo001oo`000Woo00@007ooOol0
009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol00P0000Eoo`00Oomoo`00009oo`04
001oogoo0004Ool00`00Ool00002Ool01000Oomoo`000Woo00@007ooOol0009oo`06001oo`00001o
o`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Ool007oo0P0000=oo`00Ool01Goo00<0
07oo00000Woo00L007ooOomoo`00Ool00002Ool00`00Oomoo`03Ool01P00Oomoo`00Ool000Aoo`40
000000<007ooOol010001Goo100000=oo`00Ool00goo0`0000=oo`0000001Goo00H007oo000007oo
0003Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo00800004Ool00000Ool200000goo
00000002Ool01@00Oomoogoo00000Woo0P0000Eoo`00000007oo00800004Ool00000Ool2000017oo
000007oo0P0000Eoo`00Oomoo`00009oo`03001oogoo00Eoo`04001oogoo0002Ool01000Oomoo`00
17oo00<007ooOol00P0000Eoo`00Oomoo`0000Eoo`03001oogoo00=oo`05001oogoo001oo`020002
Ool00`00Oomoo`02Ool20002Ool01@00Ool00000Ool00P0000Aoo`00001oo`800003Ool00000009o
o`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`03001oo`0000=oo`03001oogoo
00800004Ool00000Ool200000goo00000006Ool00`00Oomoo`02000017oo000007oo0P000Woo00<0
07ooOol00P001Goo00@007oo000000Eoo`@00003Ool0000000Aoo`800003Ool0000000Eoo`05001o
o`00001oo`0100000003001oogoo00Ioo`03001oogoo00Ioo`04001oo`000007Ool20007Ool00`00
Oomoo`020008Ool01@00Ool00000Ool00P0037oo0P0000Eoo`00001oo`0001Qoo`04001oogoo0002
Ool00`00Oomoo`02000017oo000007oo0P001goo00<007ooOol037oo00<007ooOol00goo00<007oo
Ool037oo00<007ooOol00Woo00<007ooOol077oo00<007ooOol00P0000Aoo`00001oo`80009oo`03
001oogoo00Yoo`800003Ool0000000eoo`04001oo`000003Ool20007Ool2000:Ool20007Ool20007
Ool100000005001oo`00Ool00002Ool01P00Oomoogoo001oo`800004Ool007oo0004Ool00`00Ool0
0002Ool01`00Oomoogoo001oo`00009oo`03001oo`0000=oo`800004Ool00000Ool200000goo001o
o`04Ool01@00Ool00000Ool00P0000Eoo`00001oo`0000Eoo`05001oo`00001oo`0200000goo001o
o`02000017oo000007oo0P0000Aoo`00001oo`800005Ool00000Ool00002Ool00`00Oomoo`06Ool0
0`00Oomoo`0200000goo00000004Ool01000Ool007oo10000Woo0P000goo00<007oo00000goo0P00
00=oo`00Ool00`0000=oo`00000017oo0P000Woo00D007oo000007oo00800006Ool00000Ool007oo
0P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P000Woo00<007ooOol00goo00D0
07oo000007oo00800004Ool00000Ool200000goo001oo`04Ool01@00Ool00000Ool00P0000Aoo`00
001oo`800003Ool007oo00=oo`07001oogooOol007oo00000Woo00H007ooOomoo`00Ool2000017oo
001oo`0017oo00D007oo001oo`0000Aoo`03001oo`0000=oo`40000000<007oo00000goo100000=o
o`0000001Goo100000=oo`00Ool00Woo100000=oo`00000017oo0P0000=oo`0000000P0000Eoo`00
001oo`00009oo`04001oogoo0002Ool00`00Oomoo`02000017oo001oo`000Woo00@007ooOol0009o
o`03001oogoo00800005Ool00000Ool00002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001o
ogoo0002Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Ool00002
Ool20004Ool20002Ool01@00Ool00000Ool00P0000Aoo`00Oomoo`8000Aoo`80009oo`03001oo`00
009oo`04001oogoo0002Ool01000Oomoo`000Woo0P0000Aoo`00001oo`800004Ool00000Ool20002
Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Ool007oo0P0000=oo`00
00000Woo00@007ooOol0009oo`05001oogoo001oo`0200000goo001oo`020002Ool01000Oomoogoo
100000=oo`00Ool00goo0`0000=oo`00000017oo00<007oo00000`001Goo0`0000=oo`00000017oo
0@0000001P00Oomoo`00Ool000Uoo`03001oogoo00Ioo`03001oo`0000Qoo`8000eoo`04001oogoo
0002Ool01000Oomoo`001goo00@007ooOol0009oo`04001oogoo000COol01000Oomoo`000Woo00@0
07ooOol0009oo`06001oo`00001oo`000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo
009oo`8000Aoo`8000Moo`8000Aoo`03001oogoo00=oo`03001oogoo00=oo`04001oogoo0002Ool0
0`00Oomoo`0BOol01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`08
Ool01000Oomoo`000Woo00@007ooOol000Yoo`04001oogoo0007Ool01000Ool000001goo0P0027oo
00@007oo000000Moo`80005oo`40000000<007ooOol01Goo00<007oo00000Woo00H007ooOomoo`00
Ool200000goo001oo`04Ool2000017oo001oo`0017oo00H007oo001oo`00Ool200001Goo000007oo
00001Goo00D007oo000007oo00800004Ool00000Ool200000goo001oo`04Ool01@00Ool00000Ool0
0P000Woo0P0000Aoo`00001oo`800004Ool00000Ool200000goo00000002Ool01000Oomoo`001Woo
00@007ooOol0009oo`03001oogoo00800004Ool007ooOol20004Ool20002Ool01@00Ool00000Ool0
0P0000Aoo`00Oomoo`8000Aoo`80009oo`04001oo`000003Ool01000Ool000000Woo00@007ooOol0
009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00
Oomoo`04Ool01@00Ool00000Ool00P0000Aoo`00001oo`800005Ool007ooOol00002Ool01@00Ool0
0000Ool00P0000Eoo`00001oo`00009oo`800005Ool00000Ool00005Ool2000017oo001oo`0017oo
00<007oo00000Woo00<007ooOol00goo0P0000Aoo`00Ool000Aoo`40000000@007oo001oo`<000Eo
o`@00003Ool00000009oo`04001oo`00Ool30004Ool00`00Ool0000300001Goo001oo`00Ool00P00
00Eoo`00Oomoo`00009oo`04001oogoo0002Ool01@00Oomoo`00Ool00P0000Ioo`00Oomoo`00Ool2
0002Ool01000Oomoo`000Woo00L007oo000007oo001oo`020002Ool01000Oomoo`000goo00D007oo
Ool007oo00800004Ool00000Ool2000017oo000007oo0P0000Eoo`00Oomoo`0000Eoo`03001oogoo
00800005Ool007ooOol00005Ool00`00Oomoo`02Ool20002Ool01000Ool000000Woo00<007ooOol0
0Woo00@007ooOol0009oo`04001oogoo0002Ool01@00Oomoo`00Ool00P0000Eoo`00001oo`00009o
o`04001oogoo0002Ool01@00Oomoo`00Ool00P0000=oo`0000000P0000Eoo`00001oo`00009oo`06
001oo`00001oo`000Woo00@007ooOol0009oo`800007Ool007ooOol007oo00000Woo00@007ooOol0
009oo`8000Aoo`03001oo`00008000Eoo`@00003Ool0000000Aoo`800003Ool0000000Aoo`03001o
o`000080005oo`40000000<007ooOol01Woo00<007oo00001Woo00<007oo00002Goo00<007oo0000
1Woo00<007oo00001Goo00@007ooOol0009oo`05001oogooOol00002Ool00`00Oomoo`04Ool01000
Oomoo`000goo00@007ooOol0009oo`03001oogoo00Qoo`04001oogoo0002Ool01000Oomoo`000Woo
00@007ooOol000Eoo`04001oogoo0002Ool01000Oomoo`000goo00<007ooOol00goo00@007ooOol0
00Eoo`03001oogoo00=oo`03001oogoo00=oo`04001oogoo0005Ool01000Oomoo`000Woo00D007oo
Oomoo`00009oo`04001oogoo0009Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0004
Ool01000Oomoo`000Woo00<007ooOol017oo00@007ooOol000=oo`04001oogoo0002Ool01@00Oomo
ogoo00000Woo00@007ooOol0009oo`04001oogoo0008Ool00`00Ool00006Ool01000Ool000001goo
0P0000=oo`00Ool017oo0@0000001000Ool007oo0P0000=oo`00Ool00Woo00H007oo000007oo0005
Ool200000goo001oo`020002Ool00`00Oomoo`040007Ool01000Oomoo`000Woo00H007ooOol007oo
0002Ool01000Oomoo`000Woo00@007ooOol0009oo`03001oo`00009oo`05001oo`00001oo`040000
17oo000007oo0P000Woo00<007ooOol00P000Woo00@007ooOol0009oo`04001oogoo0002Ool01000
Oomoo`000Woo00<007ooOol00P000goo00@007oo0000009oo`8000=oo`<0009oo`8000=oo`<000=o
o`80009oo`800007Ool007ooOol007oo00000Woo00<007ooOol00P0000Aoo`00001oo`800004Ool0
0000Ool2000017oo000007oo0P0000=oo`0000000Woo00@007ooOol0009oo`05001oogooOol00002
Ool01000Oomoo`000Woo00<007ooOol00P0000Moo`00Oomoo`00Ool00002Ool01000Oomoo`000Woo
00@007ooOol0009oo`04001oogoo0006Ool01P00Ool00000Ool000Eoo`800003Ool007oo00Aoo`80
0003Ool007oo008000Eoo`04001oo`00Ool100000004001oogoo0002Ool01`00Ool007oo001oo`00
009oo`04001oo`00Ool30002Ool00`00Ool00002Ool20002Ool01`00Ool00000Ool007oo00800005
Ool007ooOol00002Ool01@00Ool00000Ool00P0000Eoo`00001oo`00009oo`04001oogoo0002Ool0
1@00Ool00000Ool00P0000Eoo`00Oomoo`0000Aoo`04001oogoo0003Ool01000Oomoo`000Woo0P00
00Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000=oo`0000000Woo0P000Woo00@0
07oo0000009oo`06001oo`00001oo`000Woo0P0000=oo`0000000Woo00H007oo000007oo0002Ool2
00001Goo001oogoo00000goo0P0000=oo`0000000Woo00@007ooOol0009oo`04001oogoo0002Ool0
1000Oomoo`000Woo00<007ooOol00P0000Aoo`00001oo`800003Ool0000000800005Ool00000Ool0
0002Ool01000Oomoo`000Woo00D007oo000007oo00800005Ool00000Ool00002Ool01000Oomoo`00
0Woo0P0000Eoo`00Ool007oo00800004Ool007oo0002Ool01000Ool007oo0`000Woo00@007oo001o
o`<0009oo`03001oo`00009oo`<00004Ool007oo0002Ool100000004001oogoo0002Ool3000017oo
0000000017oo00<007oo00000P000Woo00@007oo001oo`800004Ool007oo0004Ool00`00Ool00002
Ool01@00Oomoo`00Ool00P0000Ioo`00001oo`00Ool200000goo00000005Ool01@00Ool00000Ool0
0P0000Ioo`00001oo`00Ool2000:Ool01000Oomoogoo0P0000Aoo`00001oo`800004Ool00000Ool2
000017oo000007oo0P0000Aoo`00001oo`800004Ool000000002Ool01000Ool0000017oo0P0000Ao
o`00Oomoo`800003Ool00000009oo`04001oo`000004Ool200001Goo001oogoo00000Woo00@007oo
001oo`800004Ool00000Ool20002Ool00`00Oomoo`06Ool00`00Oomoo`02000017oo000007oo0P00
00Aoo`00001oo`@00004Ool00000Ool200000goo001oo`04Ool200000goo001oo`02000017oo0000
07oo0P0000Aoo`00Oomoo`800004Ool00000Ool300001goo000007oo001oo`00009oo`04001oo`00
Ool30004Ool00`00Ool000020002Ool00`00Ool00002Ool300000goo001oo`03Ool100000004001o
o`00Ool20007Ool01000Oomoo`001Goo00<007ooOol00P001goo00@007ooOol000Moo`04001oogoo
000:Ool01000Oomoo`000Woo00@007ooOol000Yoo`03001oogoo00<00003Ool00000009oo`04001o
ogoo0002Ool00`00Oomoo`0KOol00`00Ool00003Ool20004Ool20007Ool20004Ool20003Ool00`00
Ool0000:Ool01000Oomoo`000Woo0P0000Aoo`00001oo`800004Ool00000Ool20002Ool00`00Oomo
o`0@Ool01000Oomoo`000Woo00@007ooOol000Yoo`04001oogoo0002Ool00`00Oomoo`09Ool00`00
Oomoo`0200000goo001oo`04Ool01000Oomoo`001Goo00@007ooOol0009oo`03001oogoo00=oo`04
001oogooOol100000003001oo`0000Aoo`04001oo`00Ool200001goo001oo`00Ool007oo00800003
Ool007oo009oo`06001oogoo001oo`000Woo0P000Woo00@007oo001oo`800003Ool00000009oo`80
0004Ool00000Ool20002Ool00`00Oomoo`020002Ool00`00Oomoo`02000017oo000007oo0P000Woo
00D007ooOol007oo00800005Ool00000Ool00002Ool01000Oomoo`000Woo00@007ooOol0009oo`04
001oogoo0002Ool01000Oomoo`000Woo00@007ooOol000=oo`04001oogoo0002Ool01000Oomoo`00
0Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007oo00000goo00<007oo
00000P0000Eoo`00001oo`0000=oo`04001oogoo0002Ool2000017oo000007oo0P000Woo00@007oo
Ool0009oo`04001oogoo0002Ool01000Oomoogoo0P0000=oo`0000000Woo00<007ooOol00P000Woo
00<007ooOol00P0000Aoo`00001oo`80009oo`800003Ool00000009oo`800005Ool00000Ool00002
Ool00`00Ool00003Ool01P00Oomoo`00Ool0009oo`06001oo`00Ool007oo0P0000=oo`00Ool00Woo
00H007ooOol007oo0002Ool20001Ool100000004001oo`00Ool40002Ool00`00Oomoo`0300000goo
001oo`03Ool200000goo000000020002Ool00`00Oomoo`04000:Ool200000goo00000002Ool01000
Oomoo`000Woo00@007ooOomoo`800004Ool00000Ool2000017oo000007oo0P000Woo00<007ooOol0
27oo00@007ooOol0009oo`04001oogoo0002Ool2000017oo000007oo0P0000Aoo`00001oo`800004
Ool00000Ool20002Ool00`00Ool00003Ool20003Ool3000017oo001oo`000goo0`000Woo00<007oo
00000goo00@007oo001oo`80009oo`04001oogoo0002Ool00`00Oomoo`0200000goo00000008Ool2
000017oo000007oo0P0000Aoo`00001oo`800003Ool0000000800004Ool00000Ool200000goo0000
0003Ool01000Oomoo`000Woo0P0000Aoo`00001oo`8000Ioo`04001oogoo0002Ool00`00Oomoo`02
Ool200000goo000000020002Ool00`00Oomoo`040005Ool200000goo000000020002Ool00`00Oomo
o`030001Ool100000003001oogoo00Eoo`03001oo`0000Ioo`06001oo`00001oo`001Woo00<007oo
00001Woo00H007oo001oo`00Ool200001Goo001oogoo000027oo00H007ooOol007oo0002Ool00`00
Oomoo`06Ool01000Oomoo`000Woo00<007ooOol00P0000Eoo`00001oo`00009oo`04001oogoo0002
Ool00`00Oomoo`0AOol00`00Oomoo`020004Ool20004Ool20008Ool00`00Oomoo`02Ool20004Ool2
0009Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@0
07ooOol0009oo`03001oogoo00Yoo`04001oogoo0002Ool00`00Ool00002Ool00`00Oomoo`06Ool0
1@00Oomoo`00Ool00P0000Eoo`00Oomoo`0000Eoo`800003Ool007oo00Eoo`03001oo`0000Qoo`<0
00Moo`03001oo`0000Ioo`40000000D007ooOol007oo00800003Ool007oo009oo`06001oogoo001o
o`000goo00D007ooOol007oo00800003Ool007oo009oo`06001oo`00001oo`000goo0`0000=oo`00
00000Woo00@007ooOol0009oo`04001oogooOol2000017oo000007oo0P000Woo00@007ooOol0009o
o`05001oogoo001oo`0200001Goo001oogoo00000Woo00@007ooOol0009oo`04001oogoo0002Ool2
00000goo001oo`02000017oo000007oo0P0000Eoo`00001oo`00009oo`<0009oo`03001oo`00009o
o`80009oo`04001oo`000002Ool00`00Ool00002Ool200001Goo001oogoo00000goo00<007oo0000
0Woo0P0000Eoo`00Oomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02000017oo000007oo0P00
00Aoo`00001oo`800006Ool007ooOol007oo0P0000=oo`0000000Woo00@007ooOol0009oo`800003
Ool007oo00800005Ool007ooOol00002Ool00`00Oomoo`02000017oo000007oo0P0000=oo`000000
0goo0`000Woo00D007ooOol007oo00800003Ool007oo009oo`06001oo`00001oo`000goo00D007oo
Ool007oo00800003Ool007oo009oo`05001oo`00001oo`0100000004001oo`00Ool2000017oo001o
ogoo0P0000Eoo`00001oo`00009oo`800005Ool007ooOol00002Ool01`00Ool007oo001oo`00009o
o`06001oo`00Ool007oo0P0000Eoo`00Oomoo`00009oo`04001oogoo0002Ool01@00Oomoo`00Ool0
0P0000Eoo`00Oomoo`00009oo`04001oogoo0002Ool01`00Oomoo`00Ool007oo00800005Ool00000
Ool00002Ool01@00Ool00000Ool00P0000Aoo`00001oo`800003Ool00000009oo`04001oogoo0002
Ool01000Oomoo`000Woo00@007oo0000009oo`06001oo`00001oo`000Woo0P0000Aoo`00001oo`80
0003Ool00000009oo`0;001oo`00001oo`00Ool007oo001oo`04000017oo000007oo0P0000Eoo`00
Oomoo`00009oo`07001oo`00001oo`00Ool00P000Woo00@007ooOol0009oo`04001oogoo0002Ool0
1000Oomoo`000Woo00@007ooOol0009oo`06001oo`00001oo`000Woo00@007ooOol0009oo`04001o
ogoo0002Ool00`00Ool00002Ool01000Oomoo`0017oo0P000Woo00<007oo00000Woo00H007oo001o
o`00Ool2000017oo001oogoo0P0000Eoo`00Oomoo`00009oo`07001oo`00Ool007oo00000goo0@00
00000`00Ool00004Ool01@00Ool007oo00001Woo00<007oo00000Woo00<007ooOol00Woo00D007oo
001oo`0000Ioo`03001oo`0000Eoo`04001oogoo0002Ool20002Ool01000Oomoo`001Woo00@007oo
Ool0009oo`80009oo`04001oogoo000;Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo
0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0003Ool00`00Ool00002Ool01000
Oomoo`000Woo00<007ooOol00goo00@007ooOol0009oo`06001oogoo001oo`000goo00<007ooOol0
0Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`08Ool01000Oomoo`000Woo00@007oo
Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol017oo00@007ooOol000=oo`04
001oogoo0002Ool01@00Oomoogoo00000Woo00@007ooOol000=oo`80009oo`03001oogoo009oo`05
001oo`00Ool00006Ool00`00Ool00002Ool01@00Oomoogoo00000Woo00<007oo00001Goo0@000000
0`00Oomoo`040002Ool00`00Oomoo`0400000goo00000002Ool400001Goo000007oo00000goo00D0
07oo000007oo0080009oo`05001oo`00001oo`020002Ool01000Oomoogoo0P0000Aoo`00001oo`80
0004Ool00000Ool200000goo00000003Ool2000017oo000007oo0`0000Aoo`00001oo`800004Ool0
0000Ool2000017oo000007oo0P0000Aoo`00001oo`8000Ioo`04001oogoo0002Ool01P00Oomoo`00
Ool0009oo`03001oogoo00800005Ool007ooOol00002Ool01000Oomoo`000Woo00@007ooOol0009o
o`04001oo`000002Ool01@00Oomoo`00Ool00P0000Aoo`00001oo`800004Ool00000Ool2000017oo
000007oo0P0000=oo`0000000Woo00@007ooOol0009oo`04001oogoo0002Ool01P00Oomoo`00Ool0
00=oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00Ool0009oo`800004Ool00000Ool2
000017oo000007oo0P0000Aoo`000000009oo`03001oogoo00@0009oo`03001oogoo00@00003Ool0
0000009oo`05001oo`00001oo`02000017oo001oogoo0P0000Aoo`00001oo`40000000@007ooOomo
o`80009oo`03001oo`00009oo`80009oo`03001oo`00009oo`07001oo`00Ool007oo00000Woo00D0
07oo001oo`00009oo`03001oo`00009oo`800004Ool00000Ool2000017oo001oo`000Woo00@007oo
Ool0009oo`03001oogoo00800007Ool00000Ool007oo00000Woo00@007ooOol000=oo`04001oogoo
0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool200000goo00000002Ool0
0`00Oomoo`0200000goo00000002000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool2
000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool3000017oo001oo`000Woo00@007oo
Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`800004Ool00000Ool2
00000goo001oo`03Ool01000Ool007oo0P000Woo00@007ooOol0009oo`05001oogoo001oo`020000
0goo001oo`0200000goo00000002Ool01000Oomoo`000Woo00@007oo001oo`800006Ool007oo001o
o`000Woo00<007oo00000Woo0`0000Aoo`00Ool0009oo`07001oo`00Ool007oo00000Woo00@007oo
001oo`80005oo`40000000@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00H007oo
Ool007oo0003Ool00`00Ool00003Ool01P00Oomoo`00Ool000=oo`03001oogoo00=oo`05001oogoo
001oo`0200001Goo001oogoo000027oo00D007ooOol007oo00800005Ool007ooOol0000AOol01000
Oomoo`000Woo00D007oo000007oo00800004Ool00000Ool200001Goo001oogoo00000goo00H007oo
Ool007oo0006Ool01P00Oomoo`00Ool0009oo`04001oogoo0002Ool00`00Oomoo`03Ool01000Oomo
o`000Woo00H007oo000007oo0002Ool01000Oomoo`004goo00@007ooOol0009oo`07001oogoo001o
o`00Ool00P0000Eoo`00Oomoo`0000Qoo`05001oo`00001oo`0200000goo001oo`0:Ool01P00Ool0
0000Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol00goo00H007ooOol007oo
0003Ool00`00Ool00003Ool00`00Oomoo`02Ool100000005001oo`00Ool00002Ool01P00Ool007oo
001oo`800006Ool007oo001oo`000Woo00<007oo00000Woo00L007oo001oo`00Ool00002Ool01@00
Ool007oo00000goo00D007ooOol007oo00800004Ool00000Ool200001Goo001oogoo00000Woo00D0
07ooOol007oo00800004Ool00000Ool2000017oo001oogoo0P0000Aoo`00001oo`800004Ool00000
Ool20002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo
00@007oo001oo`80009oo`06001oo`00001oo`000Woo0P0000Aoo`00001oo`800003Ool00000009o
o`06001oo`00001oo`000Woo0P0000=oo`0000000Woo00@007ooOol0009oo`03001oogoo00800004
Ool00000Ool2000017oo000007oo0P0000=oo`0000000Woo0P0000Aoo`00001oo`80009oo`07001o
o`00001oo`00Ool00P000Woo00@007ooOol0009oo`05001oo`00001oo`0200001Goo000007oo0000
0Woo00D007ooOol007oo00800003Ool00000009oo`80009oo`03001oo`00009oo`06001oo`00Ool0
07oo0P0000Ioo`00Ool007oo0002Ool01@00Ool007oo00000Woo00D007oo001oo`0000=oo`400000
00@007ooOol0009oo`@00003Ool00000009oo`03001oogoo00@0009oo`03001oogoo00@00004Ool0
0000Ool2000017oo000007oo0`000Woo0P0000=oo`00Ool00P0000Aoo`00001oo`800005Ool007oo
Ool00002Ool01@00Oomoo`00Ool00P0000Eoo`00001oo`00009oo`05001oogoo001oo`02000017oo
000007oo0P0000Ioo`00001oo`00Ool2000017oo000007oo0P0000Aoo`00001oo`800004Ool00000
Ool200000goo00000003Ool00`00Oomoo`02000017oo001oogoo10000Woo00@007ooOol0009oo`05
001oogoo001oo`020002Ool01000Ool000000Woo00<007ooOol00P0000Ioo`00001oo`00Ool20000
17oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool200000goo001oo`0200001Goo001oo`00
Ool00P0000Aoo`00001oo`800005Ool007ooOol00002Ool01@00Oomoo`00Ool00P0000Aoo`00001o
o`800005Ool007ooOol00002Ool01@00Oomoo`00Ool00P0000=oo`0000000`0000=oo`0000000Woo
100000Aoo`00001oo`800003Ool007oo00@00004Ool007ooOol4000017oo000007oo0P000Goo0@00
00001P00Oomoo`00Ool0009oo`03001oo`00009oo`05001oogooOol00004Ool01@00Ool007oo0000
0Woo00D007oo001oo`0000Aoo`06001oogooOol007oo0P000Woo00<007ooOol027oo00D007oo0000
07oo00800003Ool0000000Uoo`800005Ool00000Ool00002Ool01000Oomoo`000Woo00@007ooOol0
01eoo`03001oo`00009oo`04001oogoo0002Ool01000Oomoo`001Goo00@007ooOol0009oo`03001o
o`0000=oo`03001oo`0000Yoo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04
001oogoo000COol2000017oo000007oo0P0037oo0P0000Aoo`00001oo`8000Eoo`03001oogoo009o
o`05001oo`00Ool00002Ool01@00Oomoogoo000017oo00<007ooOol00Woo00D007oo001oo`00009o
o`05001oogooOol00004Ool100000004001oo`00Ool40002Ool00`00Ool0000300000goo001oo`02
000017oo000007oo10000Woo0P0000=oo`0000000P000Woo00<007ooOol00P0000Aoo`00001oo`<0
0004Ool00000Ool20002Ool2000017oo000007oo0P000Woo0P0000Aoo`00001oo`<00006Ool00000
Ool007oo0P0000Aoo`00001oo`800004Ool00000Ool4000017oo000007oo0P0000Aoo`00001oo`80
0004Ool00000Ool200001Woo000007oo001oo`<00004Ool00000Ool2000017oo000007oo0P0000Ao
o`00001oo`800004Ool00000Ool2000017oo000007oo0P0000Eoo`00Ool007oo00<00006Ool00000
Ool007oo0P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000Eoo`00000007oo
00800005Ool00000Ool00002Ool20002Ool2000017oo000007oo0P0000Eoo`00000007oo00800004
Ool00000Ool3000017oo000007oo0P0000Eoo`00000007oo0080009oo`800004Ool00000Ool40002
Ool00`00Oomoo`03000017oo001oo`000Woo0`0000Aoo`000000009oo`03001oogoo00<0005oo`40
000000@007oo001oo`800007Ool007oo001oo`00Ool00P0000Eoo`00Ool007oo00800006Ool007oo
001oo`000Woo00@007oo001oo`<0009oo`04001oo`00Ool2000017oo000007oo0P0000Eoo`00Oomo
o`00009oo`800006Ool00000Ool007oo0P0000Eoo`00Oomoo`00009oo`03001oogoo00800005Ool0
0000001oo`02000017oo000007oo0P0000Aoo`00001oo`800003Ool00000009oo`04001oogoo0002
Ool01000Oomoo`000Woo00D007ooOol007oo00800003Ool007oo0080009oo`05001oo`00001oo`02
000017oo000007oo0P000Woo00H007oo000007oo0002Ool2000017oo001oogoo0P0000=oo`000000
0Woo00<007ooOol00P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000Ioo`00
001oo`00Ool4000017oo000007oo0`000Woo00L007ooOol007oo001oo`02000017oo000007oo0P00
0Woo00D007ooOol007oo00800004Ool00000Ool200000goo001oo`020003Ool01`00Oomoo`00Ool0
07oo00800005Ool007oo001oo`0400001Goo001oo`00Ool00P0000Moo`00Ool007oo001oo`020000
0goo001oo`030001Ool100000003001oo`0000Aoo`03001oogoo008000Aoo`03001oogoo00800003
Ool007oo00Aoo`04001oo`000005Ool00`00Oomoo`020008Ool01000Oomoo`000Woo00@007ooOol0
00Moo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol03Woo00@007ooOol0009oo`800004
Ool00000Ool2000017oo000007oo0P0000=oo`0000000Woo00D007ooOomoo`0000=oo`03001oo`00
00=oo`8000=oo`04001oogooOol20004Ool20003Ool00`00Ool00003Ool00`00Oomoo`0200000goo
00000002Ool01000Oomoo`004Woo00@007ooOol0009oo`04001oogoo0004Ool01000Oomoo`000Woo
00<007ooOol01Goo00@007ooOol0009oo`04001oogoo000:Ool01000Oomoo`000Woo0P0000=oo`00
Ool017oo00<007ooOol00P0017oo00<007ooOol00P0000=oo`00Ool017oo00@007oo000000Ioo`40
000000@007ooOol0009oo`07001oo`00Ool007oo00000Woo00<007oo00000goo00H007ooOol007oo
0002Ool01P00Ool007oo001oo`800003Ool007oo009oo`03001oo`0000D0009oo`04001oogoo0002
Ool00`00Oomoo`0200001Goo00000000Ool00P0000=oo`0000000Woo00@007ooOol0009oo`@0009o
o`03001oogoo00800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800006Ool00000
Ool007oo0P0000Eoo`00001oo`00009oo`800005Ool007ooOol00002Ool01000Oomoo`000Woo00D0
07ooOol007oo0080009oo`04001oogoo0002Ool01@00Oomoo`00Ool00P000Woo0P0000Aoo`00001o
o`800004Ool00000Ool200000goo00000002Ool01@00Oomoo`00Ool01@0000Aoo`00001oo`800006
Ool00000Ool007oo0P0000Aoo`00001oo`800005Ool00000001oo`020002Ool01000Oomoo`000Woo
0P0000=oo`000000100000=oo`0000000Woo00@007ooOol0009oo`05001oo`00Ool00002Ool01`00
Ool007oo001oo`00009oo`03001oo`00009oo`80009oo`03001oo`00009oo`80009oo`03001oo`00
009oo`40000000@007oo001oo`800003Ool007oo009oo`07001oo`00001oo`00Ool00`0000Aoo`00
001oo`@0009oo`800003Ool0000000800005Ool00000001oo`03000017oo000007oo0P0000Aoo`00
001oo`800004Ool00000Ool4000017oo000007oo0P0000Aoo`00001oo`800003Ool0000000<00004
Ool00000Ool20002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool2000017oo
000007oo0P0000Aoo`00001oo`<00006Ool00000Ool007oo0`0000Aoo`00001oo`800004Ool00000
Ool2000017oo000007oo0P0000=oo`0000000`0000Aoo`00001oo`80009oo`04001oogoo0002Ool0
1000Oomoo`000Woo0P0000=oo`000000100000Aoo`00001oo`800004Ool00000Ool2000017oo0000
07oo0P0000Aoo`00001oo`800004Ool00000Ool4000017oo000007oo0P0000Aoo`00001oo`800006
Ool00000Ool007oo0P0000Aoo`00001oo`800004Ool00000Ool300000goo000000020003Ool01`00
Ool00000Ool007oo00<00006Ool00000Ool007oo0P000Woo0P0000Eoo`00000007oo0040000000<0
07oo00000goo00@007ooOol0009oo`04001oogoo0002Ool01P00Oomoo`00Ool000=oo`06001oogoo
001oo`000goo00H007ooOol007oo0006Ool00`00Oomoo`0200001goo000007oo001oo`00009oo`03
001oogoo00=oo`03001oogoo00800003Ool00000009oo`03001oogoo00Yoo`04001oogoo0002Ool0
1@00Oomoo`00Ool00P0000=oo`0000000Woo00@007ooOol0009oo`04001oogoo0002Ool01P00Oomo
o`00Ool000=oo`04001oogoo0002Ool01P00Oomoo`00Ool000=oo`03001oo`00009oo`07001oogoo
Ool007oo00000Woo00D007ooOol007oo00800005Ool007ooOol00002Ool01000Oomoo`002Woo00@0
07ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo0P0000=oo`0000000Woo00<007ooOol0
0goo00@007ooOomoo`800004Ool00000Ool20002Ool00`00Oomoo`03Ool01`00Oomoo`00Ool007oo
0080009oo`03001oo`0000=oo`06001oogoo001oo`000goo00@007ooOol0009oo`03001oo`0000=o
o`06001oogoo001oo`000goo0@000Goo0@0000000`00Oomoo`0300001Woo000007oo001oo`<0009o
o`07001oo`00001oo`00Ool00`0000Ioo`00001oo`00Ool300001Goo000007oo00000Woo00D007oo
Ool007oo00800006Ool00000Ool007oo0P0000Aoo`00001oo`80009oo`05001oo`00001oo`020000
17oo000007oo0P0000=oo`00Ool00Woo00@007ooOol0009oo`800004Ool00000Ool200001Woo0000
07oo001oo`800004Ool00000Ool2000017oo000007oo0P0000=oo`0000000`0000=oo`0000001P00
00=oo`0000000`0000Eoo`00000007oo00<00003Ool0000000H00003Ool0000000<00005Ool007oo
001oo`02000017oo000007oo0P0000Eoo`00000007oo00800004Ool00000Ool=000017oo000007oo
100000Aoo`00001oo`800004Ool007ooOol200000goo001oo`02000017oo000007oo0P0000Eoo`00
001oo`00009oo`800004Ool00000Ool300001Woo000007oo001oo`<00006Ool00000Ool007oo0`00
00Aoo`00001oo`800003Ool007oo00<00006Ool00000Ool007oo0`000Woo0@0000001@00Ool00000
Ool0100000=oo`0000000P0000Eoo`00000007oo00@00004Ool00000Ool400000goo000000060000
0goo00000006000017oo000007oo0P0000Aoo`00001oo`X00004Ool00000Ool2000017oo000007oo
200000Aoo`00001oo`800003Ool00000009oo`03001oogoo00800004Ool00000Ool2000017oo0000
07oo0P0000Aoo`00001oo`800006Ool00000Ool007oo0`0000Aoo`00Oomoo`D00003Ool007oo00<0
0003Ool007oo00800003Ool00000009oo`03001oo`0000800003Ool007oo00800005Ool007ooOol0
0002Ool200000goo0000000@000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool20000
0goo00000008000017oo000007oo0P0000Aoo`00001oo`L00004Ool00000Ool200000goo00000002
00001Goo00000000Ool0100000=oo`0000001@0000=oo`0000000P0000Aoo`00001oo`@00003Ool0
000000<0005oo`40000000D007oo001oo`00009oo`05001oo`00Ool00002Ool01`00Ool007oo001o
o`00009oo`03001oo`00009oo`07001oo`00Ool007oo00000Woo00D007oo001oo`0000Ioo`800003
Ool00000009oo`04001oogoo0009Ool2000017oo000007oo0P000Woo00<007ooOol037oo00D007oo
Oomoo`00009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002
Ool00`00Ool00003Ool01P00Ool00000Ool000=oo`03001oo`0000=oo`03001oo`0000=oo`06001o
o`00001oo`000goo00@007oo001oo`800003Ool00000009oo`04001oogoo000BOol01000Oomoo`00
0Woo00@007ooOol0009oo`800004Ool00000Ool20009Ool00`00Oomoo`02000017oo000007oo0P00
1Woo00@007ooOol0009oo`04001oo`000002Ool00`00Oomoo`02Ool01@00Ool007oo00000Woo00L0
07oo001oo`00Ool00002Ool01@00Oomoogoo00000Woo00D007oo001oo`0000=oo`40000000<007oo
Ool0100000Eoo`00000007oo00@00005Ool00000001oo`0400000goo0000000200001Goo001oo`00
Ool00P0000Eoo`00Ool007oo00H00003Ool00000009oo`04001oogoo0002Ool00`00Ool000060002
Ool01000Oomoo`000Woo00D007ooOol007oo00P00003Ool0000000800004Ool00000Ool2000017oo
000007oo0P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo1P0000Aoo`00001oo`80
0004Ool00000Ool2000017oo000007oo1@0000Aoo`00001oo`800004Ool00000Ool50002Ool20000
17oo000007oo0P0000=oo`000000400000Aoo`00001oo`800004Ool00000Ool20002Ool01000Oomo
o`000Woo100000Eoo`00001oo`00009oo`04001oogoo0002Ool200000goo000000070002Ool70000
0goo0000000200001Goo00000000Ool0100000Eoo`00000007oo00@00003Ool0000000800005Ool0
0000001oo`020001Ool100000003001oo`0000D00003Ool007oo00P00003Ool0000000<00003Ool0
000000<00003Ool0000000H00003Ool0000000800004Ool00000Ool:000017oo000007oo0P0000Ao
o`00001oo`800003Ool0000000D00004Ool00000Ool200000goo00000002Ool01000Oomoo`000Woo
00<007oo000060000Woo00<007ooOol00P0000Eoo`00001oo`00009oo`05001oogoo001oo`030000
1Goo001oogoo00000Woo00D007oo000007oo0080009oo`03001oo`0000800003Ool0000000@00004
Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool;000017oo000007oo
0P0000Aoo`00001oo`800004Ool00000Ool7000017oo000007oo0P0000Aoo`00001oo`/00003Ool0
000000@00003Ool007oo00P00004Ool00000Ool2000017oo000007oo0P0000=oo`0000000`000Goo
0@0000000`00Ool0000600000goo0000000200000goo0000000500000goo0000000600000goo0000
000600000goo0000000:000017oo000007oo400000Aoo`00001oo`L00004Ool00000Ool2000017oo
000007oo0P0000Aoo`00001oo`<00004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`80
0005Ool00000001oo`02000017oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool2000017oo
000007oo0P0000Aoo`00001oo`D00003Ool00000009oo`800003Ool0000001T00004Ool00000Ool2
00000goo0000000200000goo0000000>000017oo000007oo3@0000Aoo`00001oo`D00003Ool00000
00H00003Ool0000000D00003Ool0000000800003Ool0000000D00003Ool0000000<0005oo`400000
00<007ooOol00Woo00H007oo000007oo0002Ool01P00Oomoogoo001oo`800003Ool007oo009oo`06
001oo`00001oo`000Woo00@007ooOol0009oo`03001oogoo009oo`04001oogoo0002Ool01P00Ool0
0000Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00H007oo000007oo0002Ool01P00Oomo
o`00Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol00P0000=oo`00Ool00P00
00Aoo`00001oo`800005Ool00000Ool00002Ool01P00Ool007oo001oo`<00003Ool007oo00@00004
Ool007oo0003Ool01@00Ool00000Ool00`0000=oo`00Ool00`0000Aoo`00Ool0009oo`04001oogoo
0002Ool01000Oomoo`000Woo00<007ooOol00P0000Aoo`00001oo`800005Ool00000Ool00002Ool0
1@00Oomoo`00Ool00P0000Aoo`00001oo`800005Ool007ooOol00002Ool01000Oomoo`000Woo00D0
07oo000007oo00800005Ool007ooOol00002Ool01000Oomoo`000Woo00@007oo0000009oo`800004
Ool007ooOol200001Goo000007oo00000Woo00L007ooOomoo`00Ool00002Ool01P00Ool007oo001o
o`800005Ool007ooOol00003Ool100000004001oo`00Ool400000goo001oo`0600000goo00000004
00000goo001oo`0200001Goo00000000Ool0100000Eoo`00000007oo01P00003Ool0000000T00003
Ool0000000800004Ool00000Ool2000017oo000007oo3P0000Aoo`00001oo`l00003Ool007oo00H0
0003Ool0000000<00003Ool007oo00D00003Ool0000000H00003Ool0000000`00004Ool00000Ool2
00000goo0000000K000017oo000007oo100000=oo`0000004@0000=oo`0000002`0000=oo`000000
0P0000=oo`0000001P0000=oo`000000100000=oo`00Ool01P0000Eoo`00000007oo0040000000<0
07oo00001P0000=oo`0000001P0000=oo`0000004P0000=oo`0000000`0000=oo`0000003P0000Ao
o`00001oo`800003Ool0000001h00004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`P0
0003Ool0000000<00004Ool00000Ool500000goo0000000300000goo00000003000017oo000007oo
1@0000=oo`0000000P0000Aoo`00001oob800003Ool007oo00800004Ool00000Ool200000goo0000
000>000017oo000007oo2P0000Aoo`00001oo`P00003Ool0000000H00003Ool0000000/00003Ool0
00000080005oo`40000000@007oo001oo`@00004Ool007ooOol4000017oo000007oo100000=oo`00
00000P0000Eoo`00Ool007oo00@00003Ool007oo00800004Ool00000Ool200000goo001oo`020000
17oo000007oo0P0000Aoo`00001oo`800004Ool00000Ool200000goo001oo`02000017oo000007oo
0`0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800005Ool0
0000001oo`02000017oo000007oo0P0000Aoo`00Oomoo`800004Ool007ooOol40002Ool01000Ool0
00000Woo00<007ooOol010000Woo00@007oo0000009oo`05001oo`00001oo`02000017oo000007oo
0P0000Aoo`00001oo`800004Ool00000Ool2000017oo000007oo0P0000Aoo`00001oo`800005Ool0
0000001oo`0200001goo00000000Ool007oo00800004Ool00000Ool2000017oo000007oo0P0000Io
o`00001oo`00Ool2000017oo000007oo0P0000Aoo`00001oo`800004Ool007oo0002Ool300000goo
0000000200001Goo001oo`00Ool00`0000Aoo`00001oo`@00003Ool0000000800005Ool007oo001o
o`030001Ool100000003001oo`0008`00003Ool0000008`0005oo`40000000<007oo0000o`007000
0Goo0@0000000`00Oomoo`3oOolMOol100000?l002400000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0263022, -0.0250053, 
  0.00366761, 0.00593432}},
  ImageSoundCache->{{{0, 287}, {176.938, 0}} -> GraphicsData["WindowsSound", "\<\
DTU6AR=P001G@EI5IVed8100000100400200000P000100P0I65dHOmO002Xc>Sj
ooSUaj9jDRlD10097SeRRk;Dk_gom=fnUfm89`h10@dUAVfF_=ccoog_e[><I3hO
2@034biAN:76i?Son^W=ZH5I=AP600HI=e^4ZloZnoogh/BNMTh/4P<02R10IXnf
eo3mo_;K^Y=[A2@<0@8?:4YaV/3OmOolkM:`R60k70P011DaE7bUbNKiooWWbZEm
EC4F100873YOR:oBk?comN30VW9;:A020@`SA6ZC^M[bo_k`f;J?Id4Q2`024B]>
MIk3h_Oonn_?[8AL=aX700DG=5R0Z<cYn_ohi<JQNE4^4`<02AhmHhbceNomooCM
_II^AbH>0@4>9TM^UkgMm?omk]FcRf<m7PT00a<^DWVRanChoo[Xc:R0F3@G1@07
6SMLQ:c@jo_om^;3WGE>:a4200/Q@FN@]mS`o_kbf[VBJT<S304242U;LY_0h?Go
o>cB[hMO>Q`800@F<UEmYL[WnOoii/VTO5@a5@@021`kH8R`dnglooGO_iYaBRP?
0P4<94A[U;[Kl_kml=NfSVI080X00a8/CgJOa>;goo_Zcj^3FcHI1P0663EIPJW=
jO[on>C6XGQ@;Q<300XO?VB<]=K_oOocg;bFKDHU3@413RM8KiRng_CooNkD/XYR
?1h900@D;e9jX/OUn?ojj<^WOeLc5`D01aXhGHF]d>_kooKQ`YedCBXA0P0;8T9X
T;OIlOknlMVhTVU38P`00Q0ZC7>K`N3fooc/dJj6GSTK1`055S9FOZK;io[onNK8
Y7]C<1D400PM>f69/M?]o?oeg[nIL4TX3`413BA5K9Bkfo?noO3G]HiU?b0:00<B
;DmgWlGSmookj/jZPUXf6@H01QTfFX:Zc^[kooOSaJ1gD2dB0`0:83mUSKGFkogn
lmbkUFa59@d10@lWBG2H_]kdooc^e;6:HC`M2004531CNj?8iOWon^O;YgiF<QH5
00LK>Ej6[]7/o?ofh<6LLd`Z40803292JI6hfO7no_7I^95X@R8;008A:TedW<;Q
m_oljm2]QUdh6`L01ALcEgnWbnSjooSUaj=jDblD10097SaRR[;Dk_gom=jnV6m8
9`h10@dUAVfE_=cco_g_e[B=I3hO2P034be@N:35hoOon^W=ZH9I=AP600HI=U^3
ZlkZnoogh/BOMTl/4P<02R10IXjeeo3mo_;K^YA[AB@=0@8?:4YaVKoOmOolkM>`
RF0k7@P011DaE7bTbNKiooWWbZImES8F1@0873YOQjoBk?comN31Vg9;:A020@`S
@fZB^M[bo_kaf;N@Id4Q2`024B]=MIg3hOKonn_@[8EL>1X700DG=5R0Z<cXn_oh
i<NRNE8_50<02AhmHh^beNkmooCM_IM^AbH>0@4>9TM^U[gMloomkmFcS6<n7`T0
0a<^DGVQa^Choo[YcJV1F3@H1@066SMLQ:c?jo_omn;3WWE>;14300/Q@FN?]]S`
o_kbf[ZCJT@S304242U:LY[0goGoo>gB[hQO>Q`800@E<EEmYLWVnOoii/VUOEDa
5@@021`jH8R`d^glooGO`9YaBRT?0P4<94A[Tk[Kl_knl=NfSfI08@X00a8/CWJN
`n;goo_Zcjb4FcLI1P0563AIPJW=jO[on>C6XGUA;Q<300TO?V></mG_oOocgKbF
KDLV3P413RI8KiNmgOCooNkE/X]R?Ah900@D;e9jX/OUn?ojj<bXP5Pd5`D01aXh
GHF]d>_kooKQ`ieeCB/A0P0;8D5WT;OHlOknl]ZiTVU38``00Q0YBg>K`N3eooc/
dJn7GcTK1`055S9FOZK:ioWonNK9Y7aD<1D400PM>f29/=?]o?oegknILDTX3`81
3BA5JiBkfo?noO3G]HiU@20:00<B;4mgWlCSmookj/j[Pe/f6@H01QPeFX:ZcNWk
ooOSaJ1hD2dC0`0:7cmTSKCFkognlmblUFe69@d10@lWB6nH_]kdoog^e;6:HS`M
2@0452mCNj?8iOSon^S;YgmG<aL500LK>5f6[M7/o?ofhL:LM4`Z4@802b92J96h
fO7no_7I^95Y@R8;008@:TacW<;Qm_olk=6^QUhi6`L01AHcEgnWbnSjooSUb:=k
Dc0D10087CaQR[7Dk_gom=jnV7199`l10@dUAVbE^mcco_g_e[B=IClO2P034be@
Mj35hoOonnW>ZX9J=AP600HI=UZ3ZlkZnooghlBOMdl]4P<02R0oIHjeeo3mo_?K
^iA/AB@=0@8?:4U`VKoOmOolkM>aRF4k7@P011D`E7^Tb>KiooWWbZInES8F1@07
6cUNQjkAk?com^31Vg=<:A0200`S@fVB^M[bo_kaf;N@J44R2`024B]=M9g2hOKo
nn_@[HEM>1X700DG<eMoZ<cXn_ohiLNRNU8_50@02AhmHX^be>kmooCM_YM_B2L>
0@4=9DI]U[cLloomkmJdS6@n7`T00a<^DGRQa^Choo[YcJV1FCDH1P066CMKQ:_?
j__omn;4WWI>;18300XP@6J?]]O`oOkbfkZCJd@T30423bQ:LI[0goGoo>gB/8QP
>a`800@E<EAlYLWVnOoiilZUOEDa5P@021`jGhR_d^clooGP`9YbBbT@0P4<8dAZ
TkWJl_knl=RfSfM18@/00Q4[CWFN`n;goo_[cjb4G3LJ1`055cAHP:S<jO[on>C6
XGUA;Q<300TN?F></mG_oOodgKfFKTLV3P413RI7KYNmgOCooNkE/h]S?Ah900<C
;U5iX/OTn?ojj<bXP5Pd5`D01aXgG8B/d>_kooKR`ieeCR/A0P0;8D5WT;OHl?kn
l]ZiTVY38``10Q0YBg:K`>3eooc/dZn7GcXL20045S9EOJG:ioWonNK9Y7aD<AD4
00PL>f28/=?]o?oegknJLDXX3`8132A4JiBjfo;noO3G]XiV@20:00<B;4mfWlCR
mookj/n[Pe/f6@H01QPeFH6YcNWjooSTaZ5hD2hC0`0:7ciTS;CFkogolmblUVe6
9@d10@hWB6nH_]kdoog^e;::HS`N2@0452mBNZ;7iOSon^S;YgmG<aL500LJ>5f5
[M3[noofhL:MM4dZ4@802b92J92gfO7no_7I^99Y@b8<008@:TacVl7Pm_olk=6^
QUhi6`L01AHbEWjVbnOjooWVb:AkDc0E10087C]QRK7CkOcomMjoVG19:0l10@dT
AFbD^m_co_g`ekF>IClP2P034Re?Mio5hoOonn[>ZX9J=QT600HI=UZ2Z/kZnoog
hlFPMe0]4P<02R0oIHfee^omo_?L^iE/ABD=0@4?9dU`V;kNm?olk]BaRV4l7@P0
11@`Dg^Sb>Gioo[WbjMnES8F1@076cUNQZkAk?com^31W7=<:Q0200`R@VVA^=Wa
o_kafKRAJ48R2`024BY=M9c2hOKoo>_@[HIM>1/700DG<eMoYl_Xn_ohiLNSNU<_
50@02AhlHXZbe>kmooCN_YQ_B2L>0@4=9DI]UKcLlokmkmJdSF@n7`X00a<]D7RP
aN?goo[YcJZ2FCDH1P066CIKPj_>j__omn;4WgI?;18300XP@6J>]MO`oOkbfkZD
JdDT3@423bQ:LIVogoGoo>gC/8UP>ad800@E<EAlY<WVnOoiilZVOEHb5PD021`j
GhN_d^clooGP`I]bBbT@0P0<8d=ZT[WJl_knlMRgT6M18@/00Q4[CGFM`n7foo_[
d:b5G3PJ1`055cAHP:S<j?[on>C7XWUB;a@300TN?F>;/]G^oOodgKfGKTLV3P41
3RI7KYJmgO?ooNoE/haS?Ql900<C;U5iXLKTn?ojjLfYPEPd60D01QXgG8B/cn_k
ooOR`iieCR`A0`0;8D1WSkKHl?knl]ZjTfY48``10Q0YBW:J`=oeooc]dZn8GcXL
20045C5EOJG9i_WonNK9YGeE<AD400PL>V28/=;]o?oegl2JLDXY3`8132A4Ji>j
fo;no_3G]XmV@24:00<B;4ifW/?Rmookj/n/Q5/g6@H01APdFH6YcNWjooSTaZ5i
DBhC0`097ciSS;?EkogolmflUVe79Ph10@hVB6nG_Mgdoog^eK:;HSdN2@0452mB
NZ;7iOSon^S<Z81H=1L500LJ>5f5[M3[noofhL>MMDd[4@802b51Ii2gf?7no_;J
^I9Y@b<<008@:D]cVl7PmOolk=6_Qeli6`L01AHbEWjVb^OiooWVbJAlE30E1008
7C]PRK3CkOcomMnoVG59:0l20@dTAF^D^m_co_g`ekF>ID0P2P034Ra?Mio4hoOo
nn[>Zh=K=QT600HH=EZ2Z/gYnooghlFPN50]4`<02QloI8fde^omo_?L_9E]ARD=
0@4?9dQ_V;kNm?omk]BaRV8l7@T011@_Dg^Sb>Ghoo[XbjMoEc<G1@076cQMQZgA
k?com^72W7A<:Q4200/R@VRA^=Wao_kafKRAJD8R2`0242Y<Lic2hOKoo>cA[XIN
>A/700DF<eMoYl_Xn_ohiLRSNe<`50@021dlHHZae>kmooCN_YQ`BBL?0@4=9DI/
UK_LlokmkmJdSFDo7`X00a<]D7NPaN?goo_YcZZ2FSDH1P066CIJPj_>j__omn?4
WgM?;A8300XP?fF>]MO`oOkcfk^DK4DT3@423bQ9L9VogoGoo>gC/HUQ>ad800@E
<5@l60<1431KRk[PnOodejinCbH:00LPAgJVdO3onnK1U6<g5@824cEQTKoTn_oa
djUhBB8800TTC7b/eO?onN:lSUdb4@435cYWUlCXo?k^cZ=bA1h600`YDX:bf_Go
mmjgR5L]3P046Sm]WL[[oOg[bIe/?QX400l]F8Rgg_OomMZaPU8X30067TAcXlk^
o_cXa9MV>AH30A8bGXjlh_WolmF/O4`T2@088TUiZM?aoo[T_i5P=1<20QDgHiC2
i__ol=6VMTLP1`0;9Tmo[mSdooSP^X]K<1010aPlJI[7jOgnkLbPL44L1@0=:eF5
]=cfooKL]8EE:`d01Aa1Kj3<kOkmjLNJJS`H104@;eZ;^^3hooCH[gm?9P/01b17
MJKAl?oki/:DI3LE0P8C=62A_nCjoo7CZGU:8PP02BA<Nj_El_oih[f>GS8B0@<F
>FJGa>Olo^k>Xg=47PH032QBP[7JmOogg[N8F2d?00@J?VbMbN_moN_:WFdo6P@0
3ReGR;ONmooef[:2DRT<00HNA7:Sc^kno>S5UfLj5`<14C9MS[cRnOoceZalCB@9
00PRBGRXdo7on^BoTF4e4`825CMSU<7Vnoo`dJIfAb0700XVCgj^eoConN2jRe/`
404363aYV/KYo?k]c:5`@Q`500dZE8BdfoKom]beQED[3@05745_Wl_/o_gZai]Z
?AT40A0_FXZih?Som=R_Oe0W2`0784IeYM3_oo_V`YET=aD20A<dH92nho[olMBY
NDXS200994akZmGboo[R_HmN<a810aHiIYK4iocnklnTLdDN1P0;:561/MWeooSN
^8UH;Pl011XnK9c9jogmjlZNKClK1@0>;EN7]]ggooGJ/X=C:@`01Qe3LZ;>k_kl
j<FHIcXG0`4A<Ef=_>7ioo?F[Ge=9@X02259N:SBlOoki<2BHCDD0P8D=V>C`NGk
oo3AYgM88@L02RI>OZkGlooihK^<G30A0@<H>fRIa^Wlo^g=XG527@D03BYDQ;?K
m_oggKF6ER`>00DK@6jObncnoN[8Vf/m6@@03bmJR[WOn?odf;20D2L;00LOAWBU
d>onnnK3UFDh5@814c=OT;kSn_obe:YjBb<900TSBgZ[e?;on^>mSelc4P435SQU
U/?Wo?k_cjAdAAl600/XDH6`fOGon=nhRET^3`046Ci[W<SZoOg/bYi^@1/500h/
EXNfgOOom]^cPe<Z30067D=aX/g^o_cXaIQX>aL30A4aG8fkhOWolmJ]ODhU2P08
8DQgYm;aoo_U`99R=Q@20Q@fHY?0iO_ol=:WMdPQ200:9Dim[MKcooWQ^haL<A41
0aLkJ9W6j?cnkLfQLD<M1P0<:U>3/m_fooOM]XIF;0h01A]0KYo;k?gmj/RLJcdI
100?;UV9^=ohooGI/81A:0/01am5M:C?koklil>FICPF0P4B<en?_^?joo;DZWY;
8`T02B=;NZ[Dl_ojhkj@Gc<B0@8F>6FE`nOko^o@YGA57`L02bM@P;3Hm?ohgkV:
FBl?00@I?F^Kb>[moNc;Wfi06`D03RaFQ[GMmooffk>4E2X=00HM@W6QcNgno>W6
VFPk60<14C1LS;_QnOocejenCRH:00PQB7NWd_3onnG1Tf8f508253ERT/3Unooa
dZQhB24800XUCGf]e_?onN6kSE`a4@435cYWV<GXo?k^cJ9a@ad600`YDh>bf_Go
mmffQeL/3P056cm]W/[/oOgZbIa[?QX400l^FHVhgoSomMV`PE4X2`067dEcY<o_
o_cW`iIV>AH30A8cGXnmho[ol]F[Nd/T2@098dYjZ]Cboo[S_Y1P=1<10QDhI9G2
i__nkm2UMDHO1`0;9e20[mSdooSO^HYJ;a0011TmJY_8j_gnk<^OKd4L1@0=:eF6
]McgooKK/hAD:Pd01Ae2L:7<kOkljLJIJC/H0`4@<5^<^^3iooCG[Wi>9PX01b17
MZOAl?okiL6CHcHD0P8C=F6B`>Cjoo7CZ7Q98PP02RE=O:cFlooih[b=GC4A0@<G
>VNHaNSlo^k>XW937PH032UBP[;JmOogg[J7Ebd>00@J?ffNb^_moN_9WF`n6P@0
3biHR;ONn?oefK61DBP<00HNA7>Scnkno>O4UfHi5P<14S9NS[gRn_obeJ]kC2@9
00PRBWVYdo7on^BoTF0d4`425CMTU<;Vnoo`d:IeAR0700/WCgn_f?Con>2iReX_
404463aZV/OZoOk/c:1_@A`500d[EHFdg?Kom]bdQED[3@05745`X<c]o_gYaiYY
?1P30A0`Fh^jh?Som=N^OdlV2P0784MfY]7`oo_V`YAS=aD20Q<eHI6oi?[olM>Y
N4TR200994al[=GcooWR_8iM<Q410aLjIiO4j?cnk/jSLT@N1P0<:E:2/M[eooON
]hQH;@l011XoK9g9jogmjlVMK3lJ100?;ER8]mkgooGJ/H9B:@`01Qi4Lj?>k_kl
j<BGISTG0`4B<Uf>_>;ioo?E[7a<90T02299NJWClOoji;nAHC@C0P8E=f>D`^Kk
oo3AYWI780L02RI?OjkGm?ohh;Z;Fc0@0@<H?6VJanWmo^g<X71170D03B]EQKCL
m_ofg;B5EB/=00DL@FnPc>gnoNW7VVXl60@142mJRkWPn?odf:moCbL;00LPAWFV
d?3onnK2U6@g5@814cAPTKoTn_oadjUiBR8800TTC7^[eO;onN:mSUhb4P435SUV
UlCWo?k^cj=cA1h600`XDX6afOGon=jgR5P]3`046Si/WLW[oOg[bYe]?aX400h]
EhNgg_OomMZbPU8Y30067TAbX/k^o_cXaIQW>QL30A4bGHflh_WolmJ/O4dU2P08
8TUhZ=?aoo[T`99Q=A<20Q@fHi?1iO_ol=6VMTLP1`0:9Tin[]OdooWP^XaK<101
0aPkJIW6jOcnkLbQL48L1@0=:UB4]=_fooOL]HIE:`d01Aa1Kio;k?kmj/NKJSdI
104@;eZ:^N3hooCH[h1@9`/01am6MJG@kokki/:EI3PE0P4C=62@_^?joo;DZWU:
8`P02BA;Nj_El_ojhkf?GS<B0@<F>FJFa>Olo^o?Y7=57`H02bQAPK7ImOohgkR9
FBh?00@J?VbLbN_moNc:WVdo6`D03RaGQkKMmooef[:3DbT<00HM@g:RcNkno>S5
V6Lj5`<14C5MSK_QnOoceZemCBD:00PQB7RXd_7onnG0TV8e508253IRTl7Unoo`
dZMgB24700XVCWj]eo?onN6kS5``4@4363]XVLKYo?k]cJ5a@Qd600dZE8BcfoKo
mmfeQUH/3P056d1^Wl_/o_gZb9][?AT400l_FHZigoSom=R`P50W2`077dIdYM3_
o__W`iEU>1H20A8cGi2nho[ol]BZNT/S2@098d]jZ]Cboo[S_XmO<a810QHhIIK3
iocnklnTM4DO1`0;:560/=WeooSO^8UI;Pl011TmJic8j_gmk<^NKT0K1@0>;5J6
]]ggooKK/h=C:P`01Qe3LJ;=kOklj<JIJ3/G0`4A<Eb<^n7ioo?F[Ge>9@X02258
MjOBl?okiL2CHSHD0P8D=V:B`>Gkoo3BYgM88@P02RE>OJgFlooihK^=G34A0@<G
>fRHaNSlo^k=XW537@H032YCPk?Km_oggKJ7ER`>00DK@6jNb^cmoN[8W6/m6@@0
3biIRKSOn?oefK20DBP;00LOAGBTcnono>O3UVDh5P<14S=OSkgSn_obe:YjBb<9
00TSBgZZe?;on^>nT5lc4`425CQUUL?Wnok_d:EdAQl700/WD82`f?Con=niRUT_
3`046Ce[VlSZoOk/bim^@1/500h/EXJegOOom]^cQ5@Z3@057D9aXLg]o_cYaYUX
>aP30A4`G8bkhOWolmN^OThV2P078DQgYm7`oo_U`I=R=Q@20Q@eHI;0iO_olM:X
N4TQ200:9Dem[MKcooWQ_8eM<A410aLjIiS5j?cnk/jRLT<M1P0<:E>3/][eooOM
]XMG;0h01A/oKIk:jogmjlVLK3hJ100?;UR9^=ohooGI/H5A:0/01Qm5LjC?kokl
ilBFISTF0`4B<ej?_N;joo;EZg]<90T022=:NJ[Dl_ojhkj@H3@C0@8E=fBE`^Kk
ono@YGE680L02bM@OjoHm?ohh;V:FRl@0@@I?FZKan[mo^c;Wfm170D03B]EQKGL
m_offkB4E2X=00DL@W2Qc>gno>W6VFTl60<1431KS;[PnOodejinCbH:00LPAgJV
dO3onnG1U6<f5@824cEQT[oTn_oadjQhBB8800XUCGb/e_?onN:lSUdb4@435cYW
V<GXo?k^cZ=bA1h600`YDX:bf_GommjgR5L]3P046Sm]WL[[oOg[bIe/?QX400l]
F8Rgg_OomMVaPE8X30067TAcXlo^o_cWa9MV>AH30A8bGXjmh_Wol]F[Nd`T2@08
8TYiZM?aoo[T_i5P=1<20QDgI9C2i__ol=2VMDHP1`0;9dmo[mSdooSP^X]J;a01
11PlJY[7jOgnkLbPKd4L1@0=:eF5]=cfooKL]8EE:`d01Aa1L:3<kOkmjLNJJC`H
0`4@<5^;^^3hooCG[Wm?9PX01b17MZKAl?oki/:DHcLE0P8C=62A_nCjoo7CZGU9
8PP02BA<O:cEOkWWo_SHXfL`2`0A?7Fah_gkgZa`=`l03CA/ZMcjoNBdNClC00T]
Hj3EmooY_H9760469UZGc_Cok/B;Cah30b1BS/O`oo?<U5PT1@8JBHFojoofdieQ
:`P05D5l]nKnnMZVJS8<010iLZkPo?cP[g<j400<<VVVf_Wni[Ml@AD022]PWM?f
on^oQDXJ0PDTF9C<l_o`ahiB80@37Tn;a>kom<jGFbH60AQ7P[cYooOEX6@]2@0C
?gVdi?gjg:U]=0d03cM_[=kkoN:aMS`B00/_IZ?Hn?kX^Wm45`47:EfJdOGokL:8
C1`2129ETLWaoo79TEDR108LC8S2kOoedIYN:@L15dAo^^Snn=RSIS0;018lM[7R
oO_N[6lg3`0==6bYg?[mi;Ai?a<02BeSX=GgonVlPTLH0@HVFiO>m?o^a8]?7P<4
85:>ao3ollbDF2@50QY9QKo[ooKCWF0[200E@Gbgi_kifZIY<P`043Uc[n3lo>2^
LST@00`bJZKJnOkV]ga15@08:f6MdoKojkn5BAX21BAHU<ccoo37SU8P0`<NCh_4
k_odcYMJ9PH164N2_>WommFPHbd901<oNKCToO[LZF`d3@0?=g2/g__mh[5e?140
2c1WXmSho^RjOd@F0@LYGY[AmOo]`XQ<70848UFAbO7olLVAEB840Qa<R<;]ooGA
VUdX1`4GA7njj?khej=V;`X04Saf/^;mnmj[KcL>00deKJWLn_gT]7Pn4`09;FBP
eOOojKb2AQP11RMKUlkdonk4RdlN0`@PDXk7l?obc9AG90D26TZ5_n_om]>MH2/8
01E1O;OVo_WJYVTb300@>W>_h?clh:ib>A00339ZY][io^JgNd4E00P[HIgCm_o[
_hE96P4595RDc??ol<N>DR030ai?RlG^ooC>UeXV1P4HAh:mj_ogeJ1S;@T04cmi
]>Cmn]bXK3@=00lgL:cNnocR/GDl4@0;<6NSf?WnikUnA1H11bUNV]7eonc1R4`L
0P@REI7:lOoabI5D8P@274f8`^gomM2JGBP70AM4Ok[Xo_SGXfH_2P0B?7Jbh_gk
gZ]_=`h03CE]ZMcjoNBdN3hC00T]I:3Fn?oY_85660469e^GcoCok/B;Cah3121B
S/O`oo;<U5LT1@8JBXFojoofdieP:`P05D9l]nKnnMVUJC8<010jLjoPo?cP[W8i
400<<VZVf_[ni[Mk@AD022]QWM?fon^oQ4TJ0@DUF9G<loo_aXiA80<37Tn;aNko
m<jGFRH60AU7P[gZooOEX6<]2@0C?gVei?gjg:Q/=0d03cM`[=kko>:aMC`A00/`
Ij?HnOkW^Gi35P47:EjKdOGok<67C1`2129ET/[aoo79T5@R108LCHS2kOoed9YM
:0L15dAo^^Snn=NRIRl:018lM[;RoO_NZflf3P0==FfYg?[mi;Ah?Q<02RiTXMKh
onVlPDHH0@HWFiS?m?o^a8Y>7P<485:?ao3ol/^CEb@50Q]:QL3[ooKCW60Z200E
@Wbhi_kifJEY<@`043Yc[n3lo>2^LST@00`bJZOJn_kU]W]15008:f6Ne?Oojkj4
BAX11BEHULccono6SE4P0`<ND8c5koodcYIJ9PH16DN2_N[ommFOHbd901@oNKGT
oO[KZ6`d3@0?=g2/g__lh[5e>a402c1WY=Sio^NiOT<F0@LYGY_AmOo/`HM<7085
8eFBb_;olLV@E2840Qe=RL;]ooG@VEdX1`4GAGnjj?khej9V;`X04Sef/^;mnmf[
KcH>00deKJ[Ln_gS/gPn4`0:;VBQe_SnjKb1AQP11RMKV<odonk4RThM0`@QDho8
l?obbi=G90D26dZ6`>_om]:LH2X801E2O;SVo_WIYFTa2`0@>W>_hOclgjib>A00
33=ZYm[jo^FfNd4D00P[HIkDmoo[_XA96P459EREcO?oklJ=DAl30am@S<G_oo?>
UUXV1P4IAh>mj_ogeImS;0T053mj]NCmn]^XK3@=00lhL:gOnocQ/GDk4@0;<6NT
f?WnikUn@aH01bUNVm7eonc1Qd/K0PDSEY;:l_oabI1D8@@27Df9`^gomM2IGBP7
0AM5P;_Xo_SGXVH_2P0B?GNbhogkgJ]_=Ph03SE]Z]gkoN>cN3hC00X^I:7Fn?kY
_85660469ebHcoCok/>:CQd3125CSlS`oo;;TeLS1@8KBXK0k?ofdYaO:PP05D9m
^>KnnMVUJ34;014jM:oQo?cO[W8i400<<fZWf_[niKIk@1@02BaQW]CgonZnQ4PJ
0@DUFIG=loo_aXeA7`<37e2<aNoollfFFRH60AU8PkgZooODWf8/2@0D@7ZeiOgj
fjQ[=0d03cQa[Moko>6`M3/A00/`J:CHnOkW^Gi35P07:EnKd_Kok<67Ba/21B=F
T/[boo78T5@Q108MCHW3kOoed9UL:0L15dF0^nSnn=NRIBl:018mMk;SoO_MZfhf
3P0>=FjZgO_mhk=g?Q<02RiUXMKho^VkPDHH0@HWG9S?m?o^`hY>7@<48E>?b?3o
l/^CEb<50Q];Q/3/ooKBW5lZ200E@WfhiokifJEX<@/04CYd/>7lo=n]LCP?00`c
JjOKn_kU]WY05009;6:Ne?Ooj[j4B1T11REIULgcono6SE4O0`<OD8c5kooccIII
9@H16DR3_N[ommBOHR`901A0N[GUoO[KZ6/c3@0?>76]go_lhK1d>a402c5XY=Si
o^NiOD<F00PZGi_Bm_o/`HM;6`858eJBb_;olLR@E2440Qe=RL?]ooG@VE`X1`4G
AH2kj?khej9U;PX04Seg/n?mnmfZKSH>00heKZ[MnogS/gLm4P0:;VFQe_SnjK^0
AAP11bMLV<odonk3RThM0P@QDho8l?obbi=F8`D26d^6`>com]:LGbX801I2OKSW
o_WIYFPa2`0A>gB`hOclgjea>0l033=[Ym_joNFfNT0D00T/HYkDmooZ_X=86@46
9EVEcO?oklJ=DAl30am@S<K_oo?=UUTU1P4IB8>nj_oge9mR;0T0541j]^Gmn]^W
Jc<<00lhLJgOnocQ/7@k4@0;<FRTfOWnikQm@aH022YOW=;fonc0QT/K0PDSEY?;
l_o`b91C8@@27Dj9`ngom<nIG2L70AM5P;_Xo_SFXFD^2P0B?GNchogkgJY^=Ph0
3SI^Z]gkoN>cMcdB00X^IJ;Fn?kX^h155`479ebId?CokL>9CQd2125CT<S`oo;;
TUHS1@8KBhK0k?ofdYaO:PP05T=m^>OnnMVTJ34;014kM;3Qo?_O[G4h3`0<<f^W
fo[miKEj@1@02BaRWmCgonZnPdPI0@HUFIK=loo_aHa@7`<37e6=a^oollfEFBD6
0AU8PkkZooODWV8/2@0D@7ZfiOgjfjM[<``03cQa[Molo>6`M3/A00/aJ:GInOkW
^7e25P08:UnLd_Kok<26Ba/21B=FTl_boo38Se<Q108MCX[3k_odciQL9`L164F0
^nWnn=JQIBh:018mMk?SoO_MZVhe3P0>=VjZgO_mhk=g?A802RmUX]Oho^RkP4DG
0@LXG9W@mOo]`hU=7@848EB@b?7ol/ZBER<50Q];Ql7/ooKBVelZ200F@gfiioki
f:AX<@/04C]d/>7lnmn]LCP?00dcJjSKn_gU]GY05009;6:Oe?Ooj[f3B1T11REI
U/gcono5S50O0`<ODHg6kooccIEI9@H16DR4_^[ommBNHR`901A0N[KUo_[KYf/c
300?>76]goclhK1d>Q402c5XYMWio^JhOD8E00PZGicBm_o/`8I;6`858eNCbo;o
l<R?Db440ae>R/?^ooC?V5`W1P4HAX6kjOkheZ5U;PX04cig/n?mnmfZKSD>00hf
KZ_MnogS/WLm4P0:;fFReoSnj;^0AAL11bQLVM3eong3RDdM0P@QE938lOobbY9F
8`D26d^7`Ncom]:KGbT701I3O[WWo_WHY6L`2`0A>gF`hOckgjea>0l03CA[Z=_j
oNFeNT0D00T/HYoEmooZ_H=86@469UZFcO?oklF<D1l30amASLK_oo?=UETU1@4J
BHBnj_oge9iQ;0T0541k]^Gnn]ZWJS<<010iLZkOo?cQ[g@j4@0;<FRUfOWni[Qm
@QD022YPW=;fonc0QTXK0PDTEi?;l_o`b8mC8@@37Dj:`nkom<nHFbL60AQ6PKcY
o_SFXF@^2P0C?WRchogkgJY]=@h03SI_ZmgkoN>bMcdB00X_IZ;Gn?kX^X155`47
:5fId?GokL:9CAd2125DT<Waoo;:TUHS1@8KBhO1k?oedI]N:@L05T=n^NOnnMRT
Ic0;014kMK7Qo?_O[70h3`0==6bXfo[mi;Ei?a@02BeSWmGgonZmPdLI0@HVFYK>
loo_aHa@7`<37e6=a^oollfEF2D50AY9Q;k[ooODWV4[200D@G^fiOkjfZMZ<``0
43Ub[]olo>6_LcX@00/aJJGInOkV^7a25@08:V2Ld_Kojl26BQ/21BAGTl_boo37
Se<Q10<MCX[4k_odciQK9`H164J1_>Wnn=JQI2h:01<nN;?SoO[LZVde3@0>=Vn[
gO_mh[9f?A802RmVX]Oho^RjOdDG0@LXGIW@mOo]`XU=70848UB@bO7olLZBEB<4
0Qa<Ql7/ooGAVehY1`4F@fNglOkJTT<<0RUb`OGldXLi1`DbO/[inLUl<0@8>hWC
o?FoLBP23DFDfok`]FHP019?Wn?ojZ]K6@0HFJ[Yon>PD1<07fBdkokLUDH=0BM_
__Cme8Xl2@@_N/Shn/]o<`D7>8KAo?K2M2X22d:AfOka^6TR011<W>7ok:iN6`0F
EZOWonFSDa@07F6ak_oNV4T?0BE/^o?meXdo2P<]MlGgnlj2=@H6=X?>noO5Mbd3
2Sn>eogc^f`T0@m9VMkokK5Q7@0EE:CVonNVEQH06ej^k?oPVd`@02=Y^?7nfI12
2`8[M<;fnm25>0L5<go<n_S7NRl42Cf;e?gd_VlW0@e6U]cokkAT7`0CDJ7TonVY
FAP06E^[j_oRWThB021V]_3nfi=4308XLL3eo=>8>`P4<Gc9nOW:OC4423Z7d_ce
`78Y0Pa4Tm[nl;IW8@0ACYkRon^/G1X05eRXjOoTXE4C01iS/nkogIM73P4VK[gd
oMF;?@T3;WW6n?[<P3@51cN4co_f`gD[0P]1T=Snl[UZ8`4@Bi_Ponb_Ga`05UFU
iooVY5@E01aP/>gogiY:3`4TJk[boMN?@0X3;7K4mo_?PcL61SF1cO[haWP^0`Tn
S=Kmlka]9@4>B9ONonjbHQh055:RiOoXYeLG01YM[N_ohIe=4@0RJ;Oao]VB@``2
:W?1m_cAQcT71C9nb_Wib7/`10PkRM?lmKm`:04=AICKo_2eIB004TnOhooZZUXI
01QJZ^[ohj1@4P0PIKC_o]bEAPd19g2nm?cDRS`8131kb?Sjbghc1@LiQ]7lm/5c
:P8;@Y7Io_6hJ2804DbLhOo[[EdK01MGYnSoiJ=C500MH[;^omjHB0h19FfllogF
SCh:0behaOOkcH8e1PHfPlkkmlAf;0<:@8kGoO:jJb@13dZIgoo]/60M01EDY>Ko
ijIF5P0KGjo/on2KBa008fZil_kHT44;0R]e`oKkd8Dh1`DdP<cjn<Mj;`<9?H_E
oOBmKRH13TNFgOo_/f<O01=AXNCojJUI600JG:c[on:NCQ808FJfl?kJTd@<0RUb
`?GldXPj20@aOLWinLUm<@@8>XSBo?G0LBT234BCf_k`]VHQ019>W^;ojZaL6P0H
FJWYonBQDA<07f>ckooMUTL>0BI^_OCmeH/m2@<_N/Ohn/b0=0D7>8G@noK3MB/2
2d6@f?kb^FXS011;Vn3ok:mO6`0FEZKWonJTE1D07F2`kOoOVDX?0BA[^_;mehi0
2P</M/Cgnlj3=PH6=H;=noO5N2d32Sj=e_gc_6dU0@i8V=kok[9R7@0DDj?UonRW
EaL06ef]jooQW4`A029X^?7nfI522`8ZLl;fo=66>@L5<go;n_S8Nc0423b:e?gd
_W0W0@e6UMcnkkAU7`0BD:3SonVZFQP06EZZj_oSWdlB021U]O3nfiA53@4XL;oe
o=>9>`P4<7_8nOW:OS851cV7dOcf`G<Z0Pa3T][nlKMX8P0ACIgQon^]GAX05eNX
j?oUXU8D01iR/^kogYM83P4UKKccoMJ<?PT3;WS6n?[=PCD61SN3co_ga7H/0`Y0
SmOml[Y[904?BY[Oonf`H1`05EBUi_oWYEDF01aO[ncoh9Y;404SJ[Wbo]R?@@/2
:gG3m__?Q3L71CB0c?[haWT^0`TmRmGmm;e^9P4>AiOMonjcHah04e6Qi?oXZ5PG
01YL[>_ohYi>4@0QIkK`o]ZCA0`2:G;0mOcBQcX8139mb_WibG`a10PkR=?lmL1a
:08<A9?Ko_2fIR004TnNh_oZZe/I01QIZNWoi:5A4`0OI;C_ombFAPd19fnnm?gD
Rcd912mjaoSjc7lc1@LhQM3km/9d:`8;@Y3Io_6hJB<044bKh?o/[UhK01IFY^Oo
iZAC5@0MHK7]omjIB@l196bklogGSSl:0begaOOkcX<f