(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   6469473,      83390]*)
(*NotebookOutlinePosition[   7157543,      95911]*)
(*  CellTagsIndexPosition[   7136910,      95378]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Installing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsection",
  CellTags->{
  "Installing to hard disk", "Hard disk: installing to", "MathInstaller", 
    "Running MathInstaller", "Standard installation", "Custom installation", 
    "installhd", "i:97", "gs:0.1"}],

Cell[TextData[{
  "Follow these basic instructions to install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on your computer. For more detailed instructions, check the installation \
card that comes with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or see ",
  ButtonBox["documents.wolfram.com/installation",
    ButtonData:>{
      URL[ "http://documents.wolfram.com/installation"], None},
    ButtonStyle->"Hyperlink"],
  ".\n\nFor installation troubleshooting, visit ",
  ButtonBox["support.wolfram.com/installation",
    ButtonData:>{
      URL[ "http://support.wolfram.com/installation"], None},
    ButtonStyle->"Hyperlink"],
  " or refer to the ",
  ButtonBox["troubleshooting section",
    ButtonData:>{"Troubleshooting on Windows", None},
    ButtonStyle->"GettingStartedLink"],
  " for your platform in this manual."
}], "Highlight",
  CellTags->{"installhd", "i:97", "gs:0.1"}],

Cell[TextData[{
  "See ",
  ButtonBox["Upgrading from Version 4 and Earlier",
    ButtonData:>{"Upgrading from Version 4 and Earlier", none},
    ButtonStyle->"GettingStartedLink"],
  " if you are upgrading from an earlier version of ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "MoreInfo",
  CellTags->{"installhd", "i:97", "gs:0.1"}],

Cell[TextData[{
  StyleBox["Network Mathematica",
    FontSlant->"Italic"],
  ": System administrators should use the instructions in the ",
  StyleBox["Mathematica Products System Administration Guide",
    FontSlant->"Italic"],
  " or at ",
  ButtonBox["documents.wolfram.com/installation",
    ButtonData:>{
      URL[ "http://documents.wolfram.com/installation"], None},
    ButtonStyle->"Hyperlink"],
  " to install the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " license manager, ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  ". Once ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " is installed, you can use the instructions on this page to install a copy \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "MoreInfo",
  CellTags->{"installhd", "i:97", "gs:0.1"}],

Cell[CellGroupData[{

Cell["On Windows:", "Subsubsection",
  CellTags->{"installhd", "i:98", "b:0.0", "gs:0.1"}],

Cell[TextData[{
  "Insert the CD. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " CD window appears on your screen."
}], "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->{"installhd", "i:98", "b:0.0", "gs:0.1"}],

Cell[TextData[{
  "Click the button labeled ",
  StyleBox["Install Mathematica to a hard disk", "SR"],
  " and follow the instructions on the screen."
}], "ItemizedList",
  CellTags->{"installhd", "i:98", "b:0.0", "gs:0.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["On Mac OS X:", "Subsubsection",
  CellTags->{"installhd", "i:99", "b:0.1", "gs:0.1"}],

Cell[TextData[{
  "Insert the CD. Then double-click the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  "5.2",
  ".dmg icon that appears on your desktop. A new window appears on your \
screen."
}], "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->{"installhd", "i:99", "b:0.1", "gs:0.1"}],

Cell[TextData[{
  "Drag the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  "5.2",
  " icon from this window to the location on your hard drive where you want \
to install it."
}], "ItemizedList",
  CellTags->{"installhd", "i:99", "b:0.1", "gs:0.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["On Unix/Linux:", "Subsubsection",
  CellTags->{"installhd", "i:100", "b:0.2", "gs:0.1"}],

Cell[TextData[{
  "Mount the CD. For mounting commands on specific platforms, visit ",
  ButtonBox["documents.wolfram.com",
    ButtonData:>{
      URL[ "http://documents.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->{"installhd", "i:100", "b:0.2", "gs:0.1"}],

Cell["Run the commands:", "ItemizedList",
  CellTags->{"installhd", "i:100", "b:0.2", "gs:0.1"}],

Cell[TextData[{
  StyleBox["# cd /", "MR"],
  StyleBox["cdrom", "TI"],
  StyleBox["/Unix/Installer\n# ./MathInstaller", "MR"]
}], "ListNote",
  CellTags->{"installhd", "i:100", "b:0.2", "gs:0.1"}],

Cell["Follow the instructions provided by the installer.", "ItemizedList",
  CellTags->{"installhd", "i:100", "b:0.2", "gs:0.1"}],

Cell[TextData[{
  "TIPS\n\[Bullet] ",
  StyleBox["Windows:", "SB"],
  " If the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " CD window does not appear, the CD autorun feature might be disabled on \
your computer. To install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", open the CD-ROM drive icon, open the Windows directory, and double-click \
the setup.exe icon.\n\[Bullet] ",
  StyleBox["Windows:", "SB"],
  " If your CD-ROM driver is not able to read files with long filenames, open \
the Windows directory on the CD and run setup.exe to install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[Bullet] ",
  StyleBox["Unix/Mac OS X/Windows NT, 2000, and XP:", "SB"],
  " If you want all users to have access to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as root or administrator."
}], "UserTips",
  CellTags->{"installhd", "i:100", "b:0.2", "gs:0.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Registering Your Copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "MathUser: receiving", "Newsletter", "Technical support: receiving", 
    "Upgrades: information on", "Conferences", "Seminars", 
    "Registration card", "Registration instructions", 
    "Customer Service address", "Email registration", "Web registration", 
    "Phone registration", "register", "i:101", "gs:0.2"}],

Cell[TextData[{
  "Help us improve ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by registering your copy. Knowing who uses ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " helps us focus our development efforts and allows us to continue making \
the kinds of products that will serve you best."
}], "Highlight",
  CellTags->{"register", "i:101", "gs:0.2"}],

Cell[CellGroupData[{

Cell["Additional benefits of registering", "Subsubsection",
  CellTags->{"register", "i:102", "b:1.0", "gs:0.2"}],

Cell["Free installation support via email and phone for 60 days.", \
"BulletedList",
  CellTags->{"register", "i:102", "b:1.0", "gs:0.2"}],

Cell[TextData[{
  "A complimentary subscription to ",
  StyleBox["MATHwire",
    FontSlant->"Italic"],
  ", the Wolfram Research electronic newsletter. Keep on top of what\
\[CloseCurlyQuote]s new in the world of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", get valuable tips and tricks, and learn about ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " events."
}], "BulletedList",
  CellTags->{"register", "i:102", "b:1.0", "gs:0.2"}],

Cell[TextData[{
  "Automatic notification about ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "upgrades."
}], "BulletedList",
  CellTags->{"register", "i:102", "b:1.0", "gs:0.2"}],

Cell[TextData[{
  "Invitations to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conferences, presentations, seminars, and other events near you."
}], "BulletedList",
  CellTags->{"register", "i:102", "b:1.0", "gs:0.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Premier Service",
  FontSlant->"Italic"]], "Subsubsection",
  CellTags->{"register", "i:103", "b:1.1", "gs:0.2"}],

Cell[TextData[{
  "Subscribe to ",
  StyleBox["Premier Service", "TI"],
  " for automatic upgrades, extended technical support, a free home-use copy \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", a complimentary copy of web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Amateur", "TI"],
  ", and discounts on Wolfram Research products and services ranging from \
application packages to training. See ",
  StyleBox[ButtonBox["Premier Service",
    ButtonStyle->"GettingStartedLink"], "TI"],
  " for more details."
}], "Text",
  CellTags->{"register", "i:103", "b:1.1", "gs:0.2"}],

Cell["\<\
Wolfram Research respects your privacy. Your registration data is \
held in confidence, and we will not sell, rent, or give your personal \
information to anyone.\
\>", "MoreInfo",
  CellTags->{"register", "i:103", "b:1.1", "gs:0.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["How to register", "Subsubsection",
  PageBreakAbove->True,
  FontFamily->"Arial",
  FontSize->14,
  CellTags->{"register", "b:1.1", "gs:0.2"}],

Cell[TextData[StyleBox["Choose one of four convenient options:", "SR"]], \
"Text",
  CellTags->{"register", "b:1.1", "gs:0.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Web", "Subsubsection",
  CellTags->{"i:104", "b:1.1", "gs:0.2"}],

Cell[TextData[{
  "Complete the registration form on the web at ",
  ButtonBox["register.wolfram.com",
    ButtonData:>{
      URL[ "http://register.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{"register", "i:104", "b:1.1", "gs:0.2"}],

Cell[TextData[{
  "In Europe, complete the registration form at ",
  ButtonBox["register.wolfram.co.uk",
    ButtonData:>{
      URL[ "http://register.wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{"register", "i:104", "b:1.1", "gs:0.2"}],

Cell[TextData[{
  "If you have problems registering on the web, send email to ",
  ButtonBox["register@wolfram.com",
    ButtonData:>{
      URL[ "mailto:register@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ", including your name, license number, and postal address."
}], "Text",
  CellTags->{"register", "i:104", "b:1.1", "gs:0.2"}],

Cell[TextData[{
  "In Europe, please send email to ",
  ButtonBox["register@wolfram.co.uk",
    ButtonData:>{
      URL[ "mailto:register@wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{"register", "i:104", "b:1.1", "gs:0.2"}],

Cell["\<\
For all electronic submissions, please use English characters only. \
Our automated system will acknowledge receipt of your message within 24 \
hours. If you do not receive a message from us, please send your registration \
again or contact us by other means.\
\>", "Text",
  CellTags->{"register", "i:104", "b:1.1", "gs:0.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Fax", "Subsubsection",
  CellTags->{"i:105", "b:1.1", "gs:0.2"}],

Cell[TextData[{
  "A printed registration form is in your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box. Fax the completed registration form to \
+1\[Dash]217\[Dash]398\[Dash]1108."
}], "Text",
  CellTags->{"register", "i:105", "b:1.1", "gs:0.2"}],

Cell["\<\
In Europe, please fax the completed registration form to \
+44\[Dash](0)1993\[Dash]883800.\
\>", "Text",
  CellTags->{"register", "i:105", "b:1.1", "gs:0.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Mail", "Subsubsection",
  CellTags->{"i:106", "b:1.1", "gs:0.2"}],

Cell[TextData[{
  "A printed registration form is in your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box. Mail the completed registration form to:"
}], "Text",
  CellTags->{"register", "i:106", "b:1.1", "gs:0.2"}],

Cell["\<\
Customer Service
Wolfram Research, Inc.
100 Trade Center Drive
Champaign, IL 61820-7237 
USA\
\>", "Text",
  CellTags->{"register", "i:106", "b:1.1", "gs:0.2"}],

Cell["In Europe, mail the completed registration form to:", "Text",
  CellTags->{"register", "i:106", "b:1.1", "gs:0.2"}],

Cell["\<\
Wolfram Research Europe Ltd. 
10 Blenheim Office Park 
Lower Road, Long Hanborough
Oxfordshire OX29 8RY 
UNITED KINGDOM\
\>", "Text",
  CellTags->{"register", "i:106", "b:1.1", "gs:0.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Phone", "Subsubsection",
  CellTags->{"i:107", "b:1.1", "gs:0.2"}],

Cell["\<\
Call us at +1\[Dash]800\[Dash]WOLFRAM or at +1\[Dash]217\[Dash]398\
\[Dash]5151, Monday\[Dash]Friday, 8am\[Dash]5pm U.S. Central Time.\
\>", \
"Text",
  CellTags->{"register", "i:107", "b:1.1", "gs:0.2"}],

Cell["\<\
In Europe, call +44\[Dash](0)1993\[Dash]883400, \
Monday\[Dash]Friday, 9am\[Dash]5pm GMT.\
\>", "Text",
  CellTags->{"register", "i:107", "b:1.1", "gs:0.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Starting",
  StyleBox[" Mathematica",
    FontSlant->"Italic"]
}], "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Starting Mathematica", "Running Mathematica", "Front end: starting", 
    "Executing commands", "Kernel: starting", "Enter key", 
    "Taskbar: listing of programs in", "MathKernel", 
    "Front end: relation to kernel", "Kernel: relation to front end", 
    "starting", "i:9", "gs:0.3"}],

Cell[CellGroupData[{

Cell["On Windows:", "Subsubsection",
  CellTags->{"starting", "i:1", "b:2.0", "gs:0.3"}],

Cell[TextData[{
  "Click ",
  StyleBox["Start", "SR"],
  ", point to",
  StyleBox[" All Programs", "SR"],
  ", and choose ",
  StyleBox["Mathematica ", "SR"],
  "5.2 from the ",
  StyleBox["Mathematica ", "SR"],
  "5.2",
  " program group."
}], "Text",
  CellTags->{"starting", "i:1", "b:2.0", "gs:0.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["On Mac OS X:", "Subsubsection",
  CellTags->{"starting", "i:2", "b:2.1", "gs:0.3"}],

Cell[TextData[{
  "Double-click the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  "5.2",
  " icon. If you have placed it in the Dock, you can single-click to launch \
from there."
}], "Text",
  CellTags->{"starting", "i:2", "b:2.1", "gs:0.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["On Unix or Linux:", "Subsubsection",
  CellTags->{"starting", "i:3", "b:2.2", "gs:0.3"}],

Cell["In a shell, type", "Text",
  CellTags->{"starting", "i:3", "b:2.2", "gs:0.3"}],

Cell[TextData[StyleBox["mathematica", "MR"]], "ListNote",
  CellTags->{"starting", "i:3", "b:2.2", "gs:0.3"}],

Cell["Here is a typical screen after startup.", "Text",
  CellTags->{"starting", "i:4", "b:2.2", "gs:0.3"}],

Cell["On the left is a new notebook.", "HelpLabels",
  CellTags->{"starting", "i:4", "b:2.2", "gs:0.3"}],

Cell["\<\
On the right is the Basic Input palette. You can use the Basic \
Input palette to enter common mathematical symbols and notation.\
\>", \
"HelpLabels",
  CellTags->{"starting", "i:4", "b:2.2", "gs:0.3"}],

Cell["\<\
Click a button in the Startup palette to watch the introductory \
tutorial, open the Help Browser, or visit the Wolfram Research home \
page.\
\>", "HelpLabels",
  CellTags->{"starting", "i:4", "b:2.2", "gs:0.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "ItemizedPicture",
        ImageSize->{54, 13},
        ImageMargins->{{0, 0}, {0, 0}},
        ImageRegion->{{0, 1}, {0, 1}}],
      ButtonFunction:>(FrontEndExecute[ {
          FrontEnd`SelectionMove[ 
            FrontEnd`SelectedNotebook[ ], All, ButtonCell], 
          FrontEndToken[ "OpenCloseGroup"]}]&),
      Active->True,
      ButtonFrame->"None"]], "OpenCloseItemizedPicture",
  CellTags->{"starting", "i:4", "b:2.2", "gs:0.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008L0001QB000`400?l00000o`00003oool0@83o
o`10P1ko0420003oo`10P?oo04207_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420
003oo`10P?oo04207_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420003oo`10P?oo
04207_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420003oo`10P?oo04207_l0@800
0?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420003oo`10P?oo04207_l0@8000?oo0420ool0
@80No`10P000ool0@83oo`10P1ko0420003oo`10P?oo04207_l0@8000?oo0420ool0@80No`10P000
ool0@83oo`10P1ko0420003oo`10P?oo04207_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10
P1ko0420003oo`10P?oo04207_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420003o
o`10P?oo04207_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420003oo`10P?oo0420
7_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420003oo`10P?oo04207_l0@8000?oo
0420ool0@80No`10P000ool0@83oo`10P1ko0420003oo`10P?oo04207_l0@8000?oo0420ool0@80N
o`10P000ool0@83oo`10P1ko0420003oo`10P?oo04207_l0@8000?oo0420ool0@80No`10P000ool0
@83oo`10P1ko0420003oo`10P?oo04207_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko
0420003oo`10P?oo04207_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420003oo`10
P?oo04207_l0@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420003oo`10P?oo04207_l0
@8000?oo0420ool0@80No`10P000ool0@83oo`10P1ko0420003oo`10P?oo04207_l0@8000008o`0l
OOl1>7_o03Mho`0gN_l2=g_o03Eko`0gN_l0>7]8o`0gNP03o`0gN?l0=g[o03Ii00Co03Mj00Go03Mh
o`0gN_l0=WWo03Mjo`0fN@09o`0gNP05o`4hNol0=WWo03Mjo`0gN_l0=gP00_l0=gX00ol0=gSo03Mj
o`0fO003o`0gN00:o`0gN_l0=WWo03Mjo`0gN?l0=WOo03Mho`4hNol0=G_o03Mjo`0gN0;o03Mj0_l0
=gQbo`0gNP03o`4hNol0=g[o03Mj00;o03Mh0_l0=gX01?l0=gOo03Mjo`0fO?l1>7T3o`0gNP08o`0f
O?l1=WSo0CIjo`4fN_l0=g[o0cEjo`4nOol0@Gkoo`10P1Go042000002?mFJh[oKh2Nofn3W_m]PYoo
L86Moff2Wom_PikoKX6OBOm]PYl01?m^Pj3oKH:Qoff2Wom^Pj02off2X@03ofb1W_m]PYooKX>P00Co
KH:O00?oK86Noff2Wom^Pj000om]PYl01?m/PIkoKH:Oofj3X?m/PIh2off2W`06ofj3X?m]PYooKX>N
off2Wom/PIkoKX>N0om]PYl02Om^Pj3oK86Noff2Wom^Pj3oKH:Oofb1W_m]PZ7oKH:Ooff2W@02off2
W`03off2WOm]PYooKH:O06ooKH:O00GoKX>Pofb1W_m/PIkoKH:Oofb1WP02off2W`03off2XOm^PIoo
KH:O00;oKX>P00coKH:Oofj3X?m]PYooKH:Qoff2Wom^PJ7oK86Loff2Wom]PYgoKWnMobiDPOl2>h3o
o`10P1Go042000002?n][KWoo^;NokRf`Onh]lGo^KG3okVg`_nh]Kko][S4B?nj]l803?nj]l3o^;Fn
okZg`_nk^<?o^[O2ok^h`oni]/7o^kS3okZh`oni]l;o^[S3okVg`P;o^[S300Go^[S5okVga?ni]l;o
^[S3okVg`P02okZh``;o^KO200Wo^[S3okZhaOni]l;o^KO4okZhaOnj^<?o^KO4ok^ia_ni^<001?nj
]/@02?nk]lGo^[O2okZfa?nj]/Co^KO2okRf`ong]L;o^;K10_ni]l@2okVg`PSo^;K12_ni]/401?nj
]l;o^KK1okVf`Onj]l85okVf`@05okZg`_ni]/7o^KK1okZg`_ni]/404?ni]l88okVf`@So^;K12Oni
]/401?nj]l;o^KK1okVf`Onj]l82okVf`@03okZg`_ni]l;o^KO200Ko^KO22?nh]/401Oni]/7o^[O2
okVf`Oni]/7o^[O200_o^KK10_nh]/44okZg`P0Bok^gaOnj]/Co^KG4okZfa?nj]l;o^;K3okZh`onj
^L7o^[K4okZg`?nj]kko^KG3okZhaOnf]<7o_KW7ooonjomIL9;o0CMmool0@80Eo`10P00000So[Zbi
oifN/_nSXjoo_[c7okZiaonj^/Ko^kW7okbia4So^[[400Ko^[[6okblb?n`/;coZJVeoj^Z^?nZZ[H7
oj^[]`05ojZZ]_n[Z[SoZjZhoj^Z^?n/ZkT01On[Z[P00onZZKOoZjZhoj^[]`02oj^Z^0?oZj^g00Co
[jngojVYZonTY:KoXj>U0_nTY:H01onSXjGoYZJXok>c]Onf][ko]KG1okBd`?nf]/000_ne]L400one
]Koo]KG1okFe_`0?okFe_`;o];C000Co]KG1okBd`?nd]<3o]KG10_nd]<001?ne]Koo];BnokFe_one
]Kl2okBd_P03okFe_ond];ko]KFo02Oo]KFo00Go];C0okFe`Ond]<3o];C0okFe`@02okBd`003okFe
`One]Koo]KFo00ko]KFo00Co];C0okFe`Ond]<3o];C00_ne]L401Ond]<3o]KG1okFe_ond];ko]KFo
00;o];Bn01_o]KFookBd__ne]Koo]KG1okJf`_nb/[[oZZ^_oj>TY_nRXjGoXj>UojBTY?nSXj?oY:BV
ojf^/?na/KWoZZVgoj^Z^?n`[koo/Jnmojb^^on_[[co[jnkokFe`On9R9[oa;k8oe]cUOl0=g`0ool0
@80Eo`10P00000So[:^ioi^L[_na/;Koko3boncZjooXjN_ojn_[on[ZjTSoj^[/01CojNW[oo7aloo^
k_3oiNCYonKUj_o]kNoolo?eonOWjOo]kNool_;don[Zk?o[jngolo?eong]kooUi>WojNS]ong]kooX
j>[ol_;don_[k@Coi^KX00Woi^GZonKVj?oWi^_oi^GZonKVj?oViN[oiNGWooKfm?ohn?000_oemNd0
1_ofm^kom_K/oo;bj?ohn?3ol_;Zoo;ckP;on?Sj00Gon?ShooOgmoogmoOon?ShooOgm`0AooShn006
ooOgmoohn?SomoOgooOgmoohn?SomoOg4Oohn?P8ooOgmaSon?Sh00ComoOgooShn?ohn?SomoOg0_oh
n?P00oogmoOon?ShooShn00HooShn003ooOgmoohn?Son?Sh00;on?Sh01[omoOgooShn?ohn?SomoOg
ooWimoohnO7om?K[ooCdj_ofm^kom?CZoo?cioodlnkomoO_onOXh_oUi>WoiNGWomKFc_o_k^cofMK=
oo3/jOoKf=?ol?3Xoj^Z^_nm_<CoFg>Io`4gOOoo04205Ol0@8000008oj^]^_nLWZgoYZF]onGSj?oO
g>?ogmkTomkMhooOg^A8omoNh`0GomgLhOoYjN_ojNW[omgLhOoViN[oY:BVofIVJ?oNgN;o];BfofQX
J_o;blgoa<C6ofEUIong]kWoj>SZol_:cona/K?ogMgOohV9Roo4`lSohn;WomoNhooPgn@00_oOg^<0
1?oTi>Kohn;WonCSj?oQh>D2on3Oi00Aono_kOoYjN7oj^[Ronc/i?oQhMWohn?IonWYgooVi]kojNWQ
onCUh?oalO?ol?3bono_koo_ko7ol?3bono_koo_ko404?o_knl8ono_lC3okno_2?o_ko4@ono_k`So
knoa2?o_knl2ono^l`0FooCdm?oZjnGojNWQon[Zh_oOgmOoj^[PonWYgOoTi=cokNgUom[Jd_oQgnCo
h=kSol_;`ooKf]Sod]7=om_KfooCe<koh=oKojFT]?o0_LKoFW:Do`4hNOoo04205Ol0@8000008ojb[
^onNWJgoYjJ/onKVj?oRg]ooh=oTon3NhooPgnE8omoNh`0:omkMh_oXj>[oj^[/omkMh_oXincoZZZZ
oeUIFOoAdM?oLG5cokBd]P;oLW9d00Wo]KFgof9RI?oJfMkofm[OogmoPOn9RH_oNg]mofQXJ_oUi>T0
0_oOg^<05_oPgnCog=_Pom;Be?oKfmgof=OLomGDfOoOg^Coh=oToo3`l?o[jn?ol_;Zon?Sfoo:b/;o
h>3Hon_[hooZj^;ojNWQonGUhooalO?oknkcono_lOo`ko@2ono_l@03ono^loo`k_7ol>ka00Kol>ka
6?o_ko4@oo3^l@Soknoa2?o`k_4@ono_lA3ol>ka4?o_ko406?o`l?3okng^ooGdl_o]kNGok^kTon_Z
iOo;b/Gof=OBon_[hooXj=kokNgUomcKeooPg^?oh=gTonCRiooPg^?oeMC@on_[jOoHemGolNg/ojRX
]?no^lWoFg>Io`0iNOoo04205Ol0@8000008ojf/^_nOWJ_oYZJ`onKTiooNgnCohMoRomoNhooPg^58
omoNh`0JomgLh_oYj>gojNS]omkMhooWi^co`L73ohV9RooAd=GoNWYloooooom/K6coLW9bookno_mh
N7[o`L73ojBSZ?nATI?oS8b>ohZ:S?nj^[coi>?Xon3Oi?oOg^?oi>?Xom[Jg?l20P82o`000009oi2@
T_oZjNkoh>3Roo3`k_o`l>Soi>CLolS7`_oOg]Wok^kV00;ojn_S00SojNWQonCUh?oalO7oknoaoo3`
l_o_ko7okno_oo3`l1coknoa00Col?3bono_lOo_ko7ol?3b@_o_ko401?o`l?;oknoaono_lOo`l?8<
ono_l@0Gonk]l_oemOGokNkXono`j?o_l>[oinSRolW:`_oFem;oj>WSong_i?oJfmGoh>3Ron3Oi?oO
g^CohN3Uol_8`OoHem;od/o:omkKe?nWY[Ko_[_6oeYbU_l0>Gd0ool0@80Eo`10P00000Ko[:^ioijM
[OnVYJgoi^KXomoNhooPgnA:omoNh`0TomkMh_oYj>goj^W^omgLhOoZjNkoU9BFogEeMooDe=KoLG5c
om?CeOmYJF_oKVi`omGEeomgMgWoLG5coginP?n1PH?oP822om_KgOoXj>[ogmoQomoNhooPgnCogmkS
onKUj_o5a<Wo0002oeEEEooUi>WohN3Uon3Ph_o`l?3olO3[onWXhoo=c<OoemO?0oo[jn<00ooZj^;o
iNGSoo7al@02ono_l@;okno_L_o_ko403?o_knook^k`ooCdm?o_l>[olO;Zoo3_j_oQh=_obLW1omgM
eOo[jn?oknoWomWJe0;oh=oT0_oOg^<02?oQh>Koh]oVomOHdooal>coYjJfokjka_mILiKo03Qmool0
@80Eo`10P00000Go[JbjoifL[_nWYZkoiNGWon3Oi01;omoNh`0DomgLhOoZjNkojNS]omgLhOoWi^_o
Z:RZoi>CUOo[j^ooVi^Mod51@onf][So/;2bodA4A_nUYJOo^KVkofm_LOo9b<goY:>Xok^j_ooViNX2
on3Oi0?ogmkS00Coj>O/om;Be?oPh>;oh^7V0_oOg^<02oobl_;ol_7/ooGdkoo[j^Goc<c4on3Pf?o_
knOok>cTon_[hooWinGol?3b00;oknoa00?okno_ono_lOo_ko40LOo_ko42onk^l00:ooGemOoblngo
l_?[onc]ioo<blKohN7Ioo7ajOo[jn?ok^oYomkOf@;ogmkS00[oh=oTomoNhooOg^Coh^3SolW9`OoH
em;oYjJfoknlaomJLYCo03Uiool0@80Eo`10P00000Ko[JbjoifL[_nXYjooj>SZon;Qi_oSh^M;on;Q
iP09on_ZkooYj>gogMcQomoNhooViN[oiNCYon3Oi?oThnSogmkS00;oiNCY00Gog]gRonGTjOoUi>Wo
hN3UonCSj002on;QiP;ogmkS0_oPgn@3omoNh`0@on?RiooRhNKoh=oTomoNhooNgN;ol_;booKel?ob
lNcol>oZon_ZiOo[jn?ok>cTon[Yi?o`kn[oj^[Zoo3`lWOoknoa00cok^k`ooCdm?ofmo;olO;/ono`
j_oYj^Cok^kVonc[i_oXjN?olO;/on;Sg_oNgN82omoNh`09omoOhOoPh>;oh=gTon;PiOoXi^WoXj:`
oknl`omJLYCo0CMo0?oo04205Ol0@8000007oj^]^_nOW[3oWYfUom7Adoo<bm3oc<c>olg=c`19olc;
d005olW8cOoMgMooj>SZom_JgooMg>400_oMgMl2omgLh@05omkMh_oMg>7ogMcQomkMh_oMg>400ooN
gN83omgLh@03omkMh_oMg>7ogMcQ00;og]gR013ogMcQomkMh_oLg=kog]gRomgLhOoMgMool?3`ooOh
loodmO3oloC_oo;ck_oblngolO;/ooGflOocm>oojn_[NOo^k_001Oodm?ComoScooGflOoblnkoloC_
00;ol_?]00ooloC^ooKfm?oVi^Cog]gRomoNhooOg^Cog]gSomoNhooPgNKoh=gTonKTjOnRXK7o_kc5
oeYbU?l1>7/0ool0@80Eo`10P00000KoZZbiojBS/oo1`<KogmoOom_KgOoIfM]:om[Jg004omSHf_oT
i>Con?Shoo;bm0;olo?e00Col_;doo?cmOocloGol_;d1?ocloD00oobl_Colo?eoo?cm@02oo?cm@06
oo;bm?ocloGolo?eooCdm_obl_Colo?e0_obl_@01Oodm?Kolo?eooCdm_oalO7om_Kd00;onOWg00Ko
n?SfooWimooinOOon_[hooShm_oinOL2ooWin@03ooWinooinOWonOWi00;onOWkLooinOT05_ogmoOo
n?SfooShm_oinOOon_[hooWimoojn_Son?Wdoo[jn?oal^gohnCOom_Le?oGf=3of=[?omOHd?oHf=3o
f=S>on[Zh_nZZ[Ko_[[8oe]cUol1>7Woo`10P1Go042000000onYZkSoY:>con?Tj@02ooknoP;ooooo
00?oo_knooooooooool0A_ooool01?ono_koooooooooooono_h2ooooo`03ookno_oooooooooo00Ko
oooo0_ono_h02?ooooooo_knooooooono_koooooookno_ooooooo_kn0_ono_l02?ooooooo_knoooo
ooooooooooomookno_ooooooo_kn0_ooool01Oono_koooooookno_ooooooo_kn07Oooooo00CooOgm
ooooooono_kooooo1?ono_h03ooooogoo_knooSim?oal^gok^oWong^j?o]kNGokNkVong]iOo^kNSo
n?S`oj>SZonn^lKoFW:Fo`4hN`3oo`10P1Go042000002?nYZkSoYJBdon3Qi_ono_coooooookno_oo
ooooo_knBOooool00oono_koooooooooo`02ooknoP03ooooooono_koo_kn00;ooooo00?oo_knoooo
ooono_h00_ooool00oono_koooooooooo`03ooknoP03ooooooono_koo_kn00;oo_kn0_ooool01Oon
o_koooooookno_ono_kooooo00Koo_kn00Soooooookno_ooooooo_knooooooono_koooooooknoW;o
oooo00?oo_knooooooono_h00_ooool2ooknoP0?oooooOono_konO[eono`j_oVimook>_Von_[hooY
j^;ojNWOonGUfooclnOoWIjRol2ma_mJLYCo0CQh0?oo04205Ol0@8000006ojV[^?nUY;CohN;Woooo
oOono_koooooBoono_h01_ooooooo_knooooooono_kooooooogmo@;oo_kn1?ooool00oono_kooooo
ooooo`03ooooo`04ookno_ooooooooooooknoP;ooooo00?oo_knooooooooool01Oooool4ooknoP03
ooooooono_kooooo00;oo_kn00?oooooookno_ooool00_ooool00ooooogoooooooooo`1_ooooo`;o
o_kn0oooool04_ono_kooooooooooooooogoo_knooWjmOo`lN_ojn_Qoo7`jooJf];oe]OAon_[hooX
j>3olo?WoijOY?no_<OoFg>Go`4hNooo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_kn
ooomoP3cooooo`0>ookno_ohnOColO;/onc]iOoIf];obL[4ol_;`ooGe]7oj>SPooCdk?nNWj?o_[[8
oeYbU_l0>GWoo`10P1Go042000001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool04?on
o_koooooookno_ohn?Kom?G_onKWhOo=c/Soi^OQonGUgOo=c<Oohn?KooKfk_nNWj?o_k_:oeYbU_l0
>7_oo`10P1Go042000001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0m?ooool01_ohn?KoloC_
ono`j_o]k^Sol?7[onk^iP;oj^[R00Gom_K^oinPYOo0_<[oFW:Fo`0hN`3oo`10P1Go042000001on[
Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool04?ono_kooooooooooOohn?KomOKaoo?dk_o`
lN_oko3Zonk_ioo^k^KojN[RooKfk_nSY:Wo_kc7oeUaTol0>Gcoo`10P1Go042000001on[Z[SoXZBc
on7Ri_ono_koooooookno_oooOh0m?ooool03OogmoGonOWgoo?dkoocm>ool?7/ono`joo_k^[ok>gX
oooononWYjoo_[_6oe]cUOl0=gX0ool0@80Eo`10P00000OoZjZhoj:T/ooQh^Koo_knooooooono_ko
oogn0?;ooooo0_ono_h01?oinOWol_;booGemOoclo<3ooCdm006ooGemOolnoWo[ZjjokfjaOmJLYCo
03Qkool0@80Eo`10P00000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?Cooooo00gomoOionc/
k_o]kNook^k`ono_lOo^k_3ok^k^onk^l?ofm_KoZjZhokjka_mKLiOo03Mj0?oo04205Ol0@8000007
oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooo_knooOgmoo^k_001?o_
ko401oo_knooknoaooOgmon/ZkWo_[_6oeYbU?l0>7/0ool0@80Eo`10P00000OoZjZhoj:T/ooQh^Ko
o_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo
_[_6oeYbU_l0>7/0ool0@80Eo`10P00000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo
00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0ool0@80Eo`10
P00000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^
l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0ool0@80Eo`10P00000OoZjZhoj:T/ooQh^Koo_kn
ooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6
oeYbU_l0>7/0ool0@80Eo`10P00000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Go
o_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0ool0@80Eo`10P000
00OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006
ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0ool0@80Eo`10P00000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYb
U_l0>7/0ool0@80Eo`10P00000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_kn
oooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0ool0@80Eo`10P00000Oo
ZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_
l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3oo`10P1Go042000001on[Z[SoXZBcon7Ri_on
o_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOoh
m_Oo[:^iokjka_mJLYKo0CQk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooom
oP3aooooo`05ookno_ooooooo_knooShn?o^k_001?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYb
U_l1>7/0ool0@80Eo`10P00000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_kn
ooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3oo`10P1Go
042000001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?So
k^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk0?oo04205Ol0@8000007oj^Z^?nR
Y;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooo_knooShn?o^k_001?o_ko401oo`
k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/0ool0@80Eo`10P00000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[
^Onn^lKoFW:Fo`4hN`3oo`10P1Go042000001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOoo
ool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk
0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oooooo
ooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nR
Y;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Ooh
m_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooom
oP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo
04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oooooooooo
ooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?o
hN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo
[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3a
ooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo0420
5Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooSh
n?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;V
ookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^i
okjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aoooo
o`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0
@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^
k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookn
o_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjk
a_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05
ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@800
0007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_00
1_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_oo
ooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJ
LYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookn
o_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007
oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_
ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_oooooo
o_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo
03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oo
ooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z
^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko40
1Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_kn
ooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk
0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oooooo
ooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nR
Y;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Ooh
m_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooom
oP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo
04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oooooooooo
ooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0?oo04205Ol0@8000007oj^Z^?nRY;?o
hN;Vookno_ooooooo_knooomoP3cooooo`03ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo
[:^iokjka_mJLYKo0CQk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3c
ooooo`03ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk0?oo0420
5Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3cooooo`03ookno_ogmoOok^k`00Co
knoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;V
ookno_ooooooo_knooomoP3cooooo`03ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^i
okjka_mJLYKo0CQk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3coooo
o`03ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk0?oo04205Ol0
@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3cooooo`03ookno_ogmoOok^k`00Coknoa
00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookn
o_ooooooo_knooomoP3cooooo`03ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjk
a_mJLYKo0CQk0?oo04205Ol0@8000007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3cooooo`03
ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk0?oo04205Ol0@800
0007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`?oo_kn00?on?Shonk^l?o_ko400oo_
ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/0f?l0@8000ol0?ggo0420o`11OP02o`10P003
o`0oP_l0@83o041m00So042000?o0D61o`0oOol0@8001?l0@8000ol1@H7o0420o`10P00Oo`10P07o
041n0Ol0@801o`10P00000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo0oono_h00ooh
n?Sok^k`ono_l@03ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Io`10P007o`0oPOl0
@Woo0Sn0o`51Ool1?Woo03Aho`0fO00:o`0eN@03o`0dN?l0=GWo03Ei00Go03Ei0_l0=7PMo`0eN@7o
03Ah0Ol0?7/1o`10P00000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo0oono_h00ooh
n?Sok^k`ono_l@03ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Ho`10P008o`10O_l0
@83o0d21o`4nPOl1?Gco75>;of21[?mHOJL=oe]nZ003oeYmYomKOZSoFgjX023oFgjX00?oFWfWoen2
Z_lUF8l00Ol0?7/00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`?oo_kn00?on?Sh
onk^l?o_ko400oo_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/0fOl0@8001ol0@7ko041m
o`11Pol0=g[oA6jNooknooonood02Oooo_T01oonoOSoookiooonnOooo_WoooojooonnOonoOP08?oo
o_T00oooo_coo?oooeaoY`01o`0eN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo
0oono_h00oohn?Sok^k`ono_l@03ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Ho`10
P008o`11P?l0@8;o03n2o`10P?l0=gSo@FfJoooon?oIg><2omKFh0?oemOQ00?oe]KPomOGhOoGen40
0ooGen400ooFe^3oemOQomKFh004omOGh@;oe]KP0ooGen400ooFe^3oemOQomOGh@0@omOGh@04omKF
h?oGen7oemOQomOGh@;oe]KP00?ofmWTookon_mFNjP00Ol0=gP00007oj^Z^?nRY;?ohN;Vookno_oo
ooooo_knooomoP3aooooo`?oo_kn00?on?Shonk^l?o_ko400oo_ko401oo`k_7oknoaooSfmon/ZkWo
_[_6oeYbU_l1>7/0f?l0@8002Ol2?h3o0420o`8oP?l0@Gko0CMmod5]W_oooO3oemSMomkNh002omoO
h@03on3Ph_oOgn7ogmoQ00CogmoQ00Soh>3RomkNh?oOgn7oh>3RomkNh?oOgn7og]kPomoOh@?oh>3R
5ooOgn401ooPh>;ogmoQomoOhOoNg^3ofMcQookno?mENZH00Ol0=GT00007oj^Z^?nRY;?ohN;Vookn
o_ooooooo_knooomoP3aooooo`?oo_kn00?on?Shonk^l?o_ko400oo_ko401oo`k_7oknoaooSfmon/
ZkWo_[_6oeYbU_l1>7/0f?l0@8002_l0@7ko0422o`10P?l0@83o0CMmod9^Woonoo7of=SPomkMh_oO
g^<2on3Oi0?ogmkS00?oh=oTomoNhooOg^<00_oOg^<01_oMg>7oiNCYon[Yk_oUi>Wog]gRomoNh`;o
h=oT0ooOg^<00ooPgnCogmkSomoNh`0>omoNh`04on3Oi?oOg^?ogmkSomoNh`;oh=oT00GogmkSomkM
h_oLg>Coo_knoeIkY`01o`0gNP0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo0oon
o_h00oohn?Sok^k`ono_l@03ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Ho`10P00:
o`10O_l0@8;o049oo`10P?l1=W[o@VbLooknl_oHfMkog]gRomoNh`?oh=oT0_oOg^<02ooPgnCogmkS
on3Oi?oOg^?oh=oTon;Qi_o8alcoXZ6Vol?2aooRhNKohN3U01KogmkS00?oh=oTomoNhooOg^<00ooP
gn@01OoOg^?og]gRomcMh_oooogoEGZT007o03Il00001on[Z[SoXZBcon7Ri_ono_koooooookno_oo
oOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`3L
o`10P005o`0gN_m2K9coo_kbomSIg_oOgn400_oPgn@2omoNh`04on3Oi?oOg^?ogmoQon3Oi0?ogmkS
00GokNcaogEeMOm8B4SoEeMGonSWk002omoNh`03on3Oi?oOg^?oh=oT00CogmkS00?oh=oTomoOhOoP
h>800ooOg^<2on3Oi0CogmkS0_oPgn@01OoOgn7oh>3RomoOhOoOg^?oh=oT00?ogmkS00?og=gRookn
o?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oooooo
ooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=co042000Co03Mjod9/W?ono_;o
f=WN0_oNgN801_oQh>GogmoQon3Ph_oQh>Goi^GZonCSj0;ogmkS00Ooh=oTomkMh_o/jo3oQ8B6ob`/
;?mXJ6[oj>O/00?oh=oT00OogmkSomkMh_oPgnCogmkSon3Oi?oNgN;oh=oT00;ogmoQ00KogmkSon3O
i?oOg^?oh=oTomkMh_oPgn@2omoNh`04omkMh_oOg^?ogmkSomoNh`?oh=oT0ooOg^<01?oNgN;og=gR
ookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooo
oooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0g?l0@8003ol0=g[o@VbLookn
l_oHfMkog]gRon3Oi?oOg^?ogmoQon3Ph_oHemco_[g2olo?dOoQh>GogmoQomoNh`02on3Oi004omWH
gOo7alWoemKKon7Pi@CogmkS00Goh=oTomoNhooOg^?ogmkSon3Oi003omoNh`05on7PiOoNgN;ogmkS
omoNhooPgn@00ooOg^<01?oPgnCogmkSomoNhooPgn@2omoNh`Coh=oT00CogmoQomcMh_ono_coEW^W
0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooSh
n?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=co042000go03Mjod9/W?ono_;of=WNomoO
hOoNgN;oj>O/oo3_m?onoOooSXj@ocLg>Om=CDgohn;W00;ogmkS013oh=oTomkMh_oYj>gooooooo;b
m?oRhNKog]gRon3Oi?oNgN;oh=oTomkMh_oXincol?3bono_lOoQh>Gog]gR0_oPgn@01OoNgN;oh^7V
onk^l?o`l?;oinK[00CogmkS00Kog]gRon;Qi_o^kO;ol>odonSWk?oNgN82omoNh`05on3Oi?oOg^?o
g=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookn
o_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=co042000ko03Mjod9/
W?ono_;of=WNomoOhOoViN[oZJR]ogEeMon@T9;oO7anoeIFF?m8B4Sohn;Won7Pi@;ogmkS01SoinK[
ojn_/OmfMWSoOgn1olo>dooSh^Oog]gRon3Oi?oOg^?oi^GZojb/[_mfMWSoP822om;Ae_oThnSoh=oT
omoNhooSh^Ood]7Foh61PomfMWSoZZZ/onKUj_oOg^<2on3Oi007onCSj?o@cmCoOgn1ogIfN?n_[k7o
inK[omoNh`02on3Oi004omoNhooLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_kooooo
ookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:F
o`0hN`3Lo`10P00=o`0gN_m2K9coo_kbomSIg_oNgN;ok^gbof1PH_l0003o0@41okRh^_ne]KOoa/K8
on;QiP02omoNh`0<on3Oi?o`koCoKfmao`410Ol0003o^[VnonWXkOoPgnCog]gRomoNhoo`koCoJFU[
0_l000801_no_l7ojNS]omoNhooOg^?ojNS]ol71``;o000200?oIFEWono^looOg^<00_oPgn@01_oX
inco_Kc1o`000?l20P;oKfmaono_l@?ogmkS00Cog]gRomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nR
Y;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Ooh
m_Oo[:^iokjka_mJLYKo03Qk0=co042000co03Mjod9/W?ono_;of=WNomkMh_o_k_?oFEUKo`410Ol0
003ob<S:oo;am_oViNX2on3Oi008omoNhooPgnCoknkcog5aLol0003o0@41okZi__oYj>d3on3Oi00>
ono^lomXJ6[o0002o`000?o0`<;oj>O/on3Oi?oOg^?oinK[olW9bol0003o0002ofi^L?ocl_L2omoN
h`07on3Oi?oYj>go_;_0o`410Ol000;oLG5cono^l`04omoNh`03omcMh_ono_coEW^W007o03Ii0000
1on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Ko
knoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`3Lo`10P00;o`0gN_m2K9coo_kbomSIg_oNgN;ohn;WolC3
b?nZZZco/;2bomWHgOoQh>D00_oOg^<04_oPgnCogmkSomoNhooThnSoalO9oj^[[On^[[3oemKKon;Q
i_oNgN;oh=oTomoNhooSh^Oob<S:ojVYZonb/[CofMSMon7Pi@;oh=oT017oi^GZojf//OmTI6KoHF5S
oh20P_oKf]oohN3Uon3Oi?oOg^?ohN3Uom[Ig_n?Si7oPX:4okjm`_oUi>WogmkSon3Oi002omoNh`03
omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oon
o_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`3Ho`10P008o`0oOol1
@Goo0420o`10P?l0=g[o@VbLoogmlOoGf=d2omoNh`05onGTjOo/jo3oj^W^on7PiOoOg^<00_oPgn@0
1OoOg^?oh=oTomoNhooNgN;oiNCY00;ojn[_00?oh^7VomoNhooPgn@00_oPgn@04?oXj>[oUYJHofQX
J_nEUIOoj^[/omoNhooPgnCogmkSon?Rione]KOoWYjPoj>RYonQX:Goe]GJon7PiOoPgn@2omoNh`03
onOVjonf]K[oUIBI00;ohN3U0ooOg^<01?oNg^3og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQ
h^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/
ZkWo_[_6oeYbU_l0>7/0f?l0@8004?l0@H7o03mmo`51POl0@83o03Mjod=]WOoooo?oemSMomkMh_oO
g^?oh=oTomoNhooPgnCogmkSon3Oi?oOg^<2on3Oi0;ogmkS00?oh=oTomoNhooPgn@00_oOg^<02OoP
gnCogmkSomoNhooOg^?ok>_`ogQhN_m^KW3oLG5conWXk@02omoNh`04on3Oi?oOg^?oi^GZong]k`;o
jn[_00coh=oTomoNhooOg^?ogmkSon3Oi?oOg^?oi>?Xon?RiooRhNKogmkSon3Oi?oNgN82omoNh`03
omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oon
o_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`3Io`10P008o`51Ool0
@83o03moo`4hNom2K9coo_kbomWJgooUiNL3onKVj006onOWjOoVi^Soi^KXonKVj?oWinWoi^KX0_oW
inT01OoVi^SoinOYonKVj?oWinWoinK[00;oi^GZ00goinK[onOWjOo/k>ko^k^mohR8R_nf][SokNca
onOVjooUi>WoinK[onGTjOoWi^_oi^KX00;oi^GZ0_oWi^/2onKUjP;oinK[00_oinOYonKVj?oVi^So
iNGWonOVjooViN[ohN3UomkMh_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYb
U_l0>7/0fOl0@8002Ol0@7ko03moo`51POl0=g[o@VbLooknl_oBdmSo^;NlokJe^P02okNf^`Ko][Fj
0_ng][/2okJe^P03okNf^onf]K[o][Fj00;o]kJk0_nf]KX01Ong][_o_[g2olG4bOnn_L;o]KBi00?o
][Fj00Oo^;NlokFd^Ong][_o][FjokNf^onf]K[o]KBi00;o]kJk1?nf]KX2okNf^`07okFd^Oni^;go
fMSNomoNi?oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7o
oooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0f?l0@800
3?l0?goo041no`10P?l0@83o03IiodA^W_ono_;obL[?og=cLom[Jf_oLg=cogEeM@CoMWIf1?meMGD5
ogIfMP03ogEeMOmdM7CoMGEe00;oMgMg0_mmOGd01?mlO7coMgMgogIfM_meMGD2ogAdM007ogEeMOmf
MWKoMGEeogIfM_mdM7CoMGEeogAdM002ogEeM@CoMWIf00SoM7AdofQXJ?meMGGod=3@on;Ri?oLgN;o
o_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_kooooo
ooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`3Io`10P009o`10O_l0@83o0420
o`4hNom2K9coo_kbomWJgooYj>goj^W^00;ojn[_00?oj^W^onc[l?oZjNh00_oZjNh2on_Zk`;oj^W^
0_o[j^l2on[YkP05on_ZkooZjNkok>_`on[Yk_o[j^l01OoZjNh01oo[j^ooj^W^on[Yk_oZjNkojn[_
on[Yk_o[j^l01?oZjNh03Oo[j^ooj^W^on[Yk_o[j^ooj^W^on_ZkooZjNkojNS]on;Qi_oLfn3og=gR
ookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oo
ooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=Wo042000So041no`10P?l0
?goo03Mjod9/W?ono_;of=WNomgLh@;oh=oT00Kok>_`onOVjooSh^Ook^gbon7PiOoNgN83omoNh`06
on3Oi?o/jo3ojn[_ong/lOoRhNKog]gR0ooOg^<2on3Oi003ong/lOoWi^_ogmkS00?ogmkS00Coh=oT
omoNhooWi^_okNca1?oOg^<03_oPgnCog]gRonWXkOo/jo3ohN3Uong/lOoWi^_ogmkSon3Oi?oNgN;o
gmkSomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05
ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=Wo0420013o0D5o
o`10P?l0@83o0CQkod9/W?ono_;of=WNomkMh_oRhNKof=OLohb;T?nh]kcobLS=oh^:Soo?c]?ohn;W
0_oOg^<01ooRhNKoe]GJohf<TOn=S97oRXV>olo>dooThnP00_oOg^<01ooOgn7oh>3Ron7QhonGUiWo
^;NlonSWk?oPgn@00ooOg^<01OoUi>Wo/:ndohn>TooHemcohN3U00;ogmkS00Soh=oTonCSj?nVYJ[o
U9BFom;Ae_n>SI;o[ZfbonKUjP;oh=kS00CogmgPomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nRY;?o
hN;Vookno_ooooooo_knooomoP3aooooo`?oo_kn00?on?Shonk^l?o_ko400oo_ko401oo`k_7oknoa
ooSfmon/ZkWo_[_6oeYbU_l1>7/0g?l0@8003Ol0=g[o@VbLooknl_oHfMkog]kPon;Qi_oMg>7oSXj@
oh61POn/[:co0002om[Ig_oRhNH00_oOg^<04?oThnSobLS=og1_M?ng][_oPH63okbk`?oWi^_ogmkS
on3Oi?oOg^?oinOYok^k_Ol0003oF5QJomkNh?oSh^L3on3Oi006on_[kOnSXjGo<S8bonOVjooPgnCo
gmkS0_oPgn@01ooWinWoIFEUob8R8_o7alOo0@43ohB4Q_oZjNh00_oPgn@01?oOgN;og=gRookno?mF
NjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo0oono_h00oohn?Sok^k`
ono_l@03ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Lo`10P004o`0gN_m2K9coo_kb
omSIgP;ogmkS00KoiNCYomWIfom1@D?oKVi^oifMWoo/jo03omoNh`07omkMh_oViN[ogMgOof9RI?nA
TI7ok>_`omkMhP02omoNh`07onKUj_o4a<KoNGUkofIVI_mgMgWoQ8B6onOVj`02omoNh`0Fon7PiOoQ
hN?oMGEgo`000?o1`L?oj>O/on3Oi?oOg^?oh=oTonWXkOnc/kGoTY:Bookno_n9RH_o_KfoonKUj_oO
g^?og]gRon3NhooLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0
lOooool3ooknoP03ooShn?o^k_3oknoa00?oknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk
0=co042000co03Mjod9/W?ono_;of=WNomkMh_oOg^?oh=oTong/lOn7QhWo:2PZolO7bOoWi^/2omoN
h`0Yon3Oi?oQh>Gofm_MokNg^OmLG5coIFEUom[Ig_oQh>GogmkSon3Oi?oQh>GofMSMoi2@T_lP82;o
HV9Tok2`/_oUi>Woh=oTomoNhooYj>goYJFWofa/K_mbLW;oOGeoom[Ig_oRhNKoh=oTomoNhooWi^_o
^KRmoh20P_oVi^SoKFe_olC3b?oThnSogmkSon3Oi?oNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z
^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`?oo_kn00?on?Shonk^l?o_ko400oo_ko401oo`
k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/0g?l0@8001?l0=g[o@VbLooknl_oHfMh2omoNh`07on3O
i?oXincoZZZ/ofATI_oYj>goh=oTomoNh`02on3Oi00JonCSj?o8alco4A4CogemOOlT92Co^KRmonSW
k?oOg^?og]gRon3Oi?oThnSofm_Mo`D51on8R8[ok^gbon3Oi?oOg^?oh=oTon7PiOo5a<WoS8b>obDU
9Oni^K_oeMCIon7PiOoPgn@2omoNh`06onOVjon][Joo>3PjokNf^ooUi>Woh=oT0_oOg^<01?oNgN;o
g=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo0oono_h0
0oohn?Sok^k`ono_l@03ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Lo`10P00Do`0g
N_m2K9coo_kbomSIg_oNgN;ogmkSon3Oi?oMg>7oi^GZon7PiOoPgnCogmkSomoOhOoQh>Gog]gRon3O
i?oOg^?of=OLolo?dOoFe]P2omoNh`08on3Oi?oOg^?ogmkSon3Oi?oMgMoof=SJom[Ig_oPgn@2omoN
h`05on3Oi?oOg^?oi^GZom_JgooFe]P00_oRhNH2on3Oi008omoNhooPgnCogmoQon?RiooEe=WoiNCY
omoNhooPgn@3omoNh`03omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookn
o_oooOh0lOooool3ooknoP03ooShn?o^k_3oknoa00?oknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJ
LYKo0CQk0=co042000[o03Mjod9/W?ono_;of=WNomoNhooPgnCogmkSon3Oi?oOg^?oh=oT0_oOg^<0
2OoOgn7ogmkSomoNhooPgnCogmkSon3Oi?oQh>Goh^7Von3Oi002omoNh`05on3Oi?oOg^?oh=oTon3O
i?oRh^@00_oPgn@00ooOg^?oh=oTomkMhP03on3Oi00Con7PiOoPgnCogmkSomoNhooOgn7ohN3UomoN
hooPh>;ogmkSon7PiOoNgN;oh=oTomoNhooPgnCogmkSomkMh_oLgN;oo_kloeIkY`01o`0fN@0000Oo
ZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo0oono_h00oohn?Sok^k`ono_l@03ono_l@07
oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Lo`10P007o`0gN_m2K9coo_kbomSIg_oNgN;ogmkS
on3Oi002omoNh`;oh=oT00?ogmkSon3Oi?oPgn@00ooOg^<2on3Oi003omoNhooPgnCogmkS00;ogmkS
00?oh=oTomoNhooNgN800_oOg^<00ooNgN;ogmkSon3Oi002on3Oi003omoNhooPgnCoh=oT00?ogmkS
00SogmoQomoNhooOg^?oh=oTomoNhooPgnCogmkSon3Oi0?ogmkS00Cog]gRomcMh_ono_coEW^W0Ol0
=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`?oo_kn00?on?Shonk^l?o_ko40
0oo_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/0g?l0@8001?l0=g[o@VbLooknl_oHfMh2
omoNh`04omkNh?oRhNKoi^GZomkMhP?oh=oT00?ogmkSon3Oi?oNgN800ooOg^<01?oPgnCogmkSomoN
hooOg^<2on3Oi005omoNhooPgnCoh=oTomoNhooPgn@00_oOg^<3on3Oi004omoNhooOgn7ogmkSon3O
i0;ogmoQ0_oPgn@3omoNh`09on3Oi?oOg^?ogmkSon3Oi?oOg^?og]gRomcMh_ono_coEW^W007o03Ii
00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0loooool00oono_komoOgonk^l004ono_l@07
oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Lo`10P00<o`0gN_m2K9coo_kbomSIg_oNgN;oh=oT
on;Ri?oBd]Co_Kc1onc[l?oOg^?oh=oT0_oOg^<03_oPgnCogmkSon7PiOo[j^ookNcaonc[l?oRh^Co
g]gRomoNhooOgn7oh=oTon7PiOo/k>koinK[1OoOg^<01OoNgN;oinK[onk]l_o[j^ookNca00;oh=oT
00OogmkSon3Oi?oOg^?oh=oTonSWk?o/jo3oh^7V00;ogmkS00Koh=oTomoNhooNgN;og=gRookno?mF
NjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0??ooooo00?oo_knooOgmoo^k_00
1?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/0g?l0@8001?l0=g[o@VbLooknl_oHfMh2
omoNh`05onGTjOo7alWo4A4CokFe]ooViNX01?oOg^<03ooRhNKof=SJoiFEUon?Si7oSXj@omGEeooU
i>WogmkSon3Ph_oRhNKoe]GJoi2@T_ne];WoiNCYomoNh`03on3Oi007onCSj?n_[k7oS8b>oi2?U?nC
TYOoemKKon7Pi@02on3Oi006omoNhooYj>goZjZ_oi2?U?oMg>7oiNCY0_oOg^<01OoPgnCogmkSomcM
h_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0loooool00oono_ko
moOgonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Lo`10P00Fo`0gN_m2K9co
o_kbomSIg_oNg^3oh=oTonWXkOnBTYCoATI6odi>C_o1`L?oi^GZomoNhooPgnCogmkSonKUj_no_l7o
De=Eofe]KolS8bGoXZ6VonOVk0;oh=oT00GohN3Uon3Ph_l<30coZJVYonWXk@02omoNh`0Hon3Oi?oO
g^?oj^[/oiZJW?m?Ce7oVi^MobTY:ooMg>7ohN3UomoNhooPgnCoi^GZojVX[OnBTYCoYjNYohj>T?oK
f]ooh^7VomoNhooPgnCog]gRomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_oooooo
o_knooomoP3cooooo`03ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo
0CQk0=co042000co03Mjod9/W?ono_;of=WNomkNh?oOg^?ojNS]oi:BU?m[Jf_oBDU9okBd]_oYj>d2
omoNh`0@on3Oi?oUi>Wo^k^moh^;SOn^[[3o^;Rjof][JooQhN?oh>3RomoOhOoOg^Cojn[_oh61Poo3
`/OojNS]on;QiP;oh=oT00OogmkSonGUioo3`lGoShnAok^k_On@T9;ojNS]00;oh=oT00kogmkSon;Q
i_mmOGooOgmoogUiNOmbLWCo_Kc1onOVjooOg^?oh=oTomoNhooLgN;oo_kloeIkY`7o03Ii00001on[
Z[SoXZBcon7Ri_ono_koooooookno_oooOh0loooool00oono_komoOgonk^l004ono_l@07oo3^lOo_
ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Lo`10P00<o`0gN_m2K9coo_kbomSIg_oNg^3ogmkSonOVjonZ
ZJkoWYjNoc4a<OnQXJ?oiNCY0_oOg^<04OoPgnCoh^7Vom[Ig_nBTIKoe]GJomSGg?mnOWkohN7Son3P
h_oNg^3oh=oUon[Yk_mlO7koa/G:om7AdooDe=Koh^7V00;ogmkS00Koh=oTonWXkOn6QXSo@412ol?3
aOoViNX2omoNh`09on3Oi?oUi>WoQ8B6oe]KFomNGUkoFEUKolS7c?oThnSoh=oT00;ogmkS00?og=gR
ookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3cooooo`03ookno_og
moOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk0=co0420023o03Mjod9/W?on
o_;of=WNomoNhooPgnCogmkSomkMh_oJf]co_Kfoon3Oi?oOg^?ogmoQon7PiOoNgN;ogmkSon?RiooP
gnCogMcQon7PiOoPgnCogmkTomoNhooPgnCoh^7VomOGfOl820SoB4Q8o`L72Onn_/3oi^GZomoNh`;o
h=oT00koiNCYojb[/?mkNggof][Lon7PiOoOg^?oh=oTomoNhooRhNKoeMCIoh20P_mbLWCo]KFgonKU
jP;oh=oT0_oOg^<00ooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_ko
oogn0??ooooo00?oo_knooOgmoo^k_001?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/0
g?l0@8001Ol0=g[o@VbLooknl_oHfMkog]gR00;ogmkS0_oQh>D02OoWi^_oh=oTon3Oi?oPgnCog]gR
on7PiOoOg^?oh=oTon7Pi@02omoNh`0=on3Ph_oOg^?ogmkSon3Ph_oQh>GogMcQomGEeoo?c]?odm;G
on3Oi?oOg^?oh=oTomkMhP02on3Oi006on;Qi_oQh>Goh^7Von3Oi?oOg^?oh=oT0_oOg^<01?oThnSo
fm[Oom7@eOoUi>T2omoNh`;oh=oT00Cog]gRomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nRY;?ohN;V
ookno_ooooooo_knooomoP3cooooo`03ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^i
okjka_mJLYKo0CQk0=co042000Ko03Mjod9/W?ono_;of=WNomkMh_oPgn@2omoNh`?oh=oT0_oOg^<0
1?oPgnCogmkSon3Oi?oPgn@3omoNh`07omoOhOoOg^?ogmkSomoOhOoOg^?oh=oTon;Ri002on;QiP;o
gmkS00Cog]gRon3Oi?oOg^?ogmkS0ooPgn@3omoNh`?oh=oT00Koh^7Von?RiooOg^?oh=oTomoNhooP
gn@2omoNh`03omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0
lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`3Lo`10
P004o`0gN_m2K9coo_kbomSIgPOogmkS00Goh=oTomoNhooOg^?ogmkSon3Oi002omoNh`04on3Oi?oO
g^?ogmkSon3Oi0;ogmoQ00?oh=oTomoNhooOg^<00_oOg^<01_oPgnCogmkSon3Ph_oOgn7ogmkSon3O
i0?ogmkS0_oPgn@01ooPh>;ogmkSomoNhooPgnCogmkSon3Oi?oOg^<00_oPgn@2omoNh`04omkMh_oL
gN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_ko
ooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`3Lo`10P004o`0gN_m2K9co
o_kbomSIgP?ogmkS00?oh=oTomoNhooOg^<00ooOg^<00ooPgnCogmkSomoNh`02on3Oi004omoNhooP
gnCogmkSomoNh`;oh=oT0_oOg^<01OoRhNKoinK[omkMh_oOg^?oh=oT00;ogmkS00?oh=oTon7PiOo/
k>h00_oPgn@02_oOg^?oh=oTomoNhooOg^?oh=oTonGTjOoQh>Goj>O/onOVjooNgN82on3Oi005omkM
h_oOg^?og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aoooo
o`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=co042000Ko
03Mjod9/W?ono_;of=WNomkMh_oOg^<2on3Oi003on[Yk_oRhNKog]gR00;oh=oT00WogmkSon3Oi?oO
g^?oh=oTomoNhooViN[oh^7VomkMh_oPgn@00_oOg^<01OoPgnCohN3UomOFfono_l7oiNCY00?ogmkS
00Koh=oTon?RiooEe=WoVi^MomkMh_oRhNH2omoNh`08on3Oi?oOg^?oh^7Vok:a]_oPh>;o[Jf_ojj]
/_oViNX2omoNh`05on3Oi?oNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_oo
ooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJ
LYKo03Qk0=co042000ko03Mjod9/W?ono_;of=WNomkMh_oOg^?ohN3UomWHgOnHUicoe=CFonKUj_oN
gN;ogmkSon3Oi0?ogmkS00kohn;Wol2oa?oAd=Goh^7Von3Oi?oOg^?oh=oTomoNhooYj>goWinQoa4A
4ooPh>;oi>?XomkMhP;oh=oT00Goi>?Xom3@d_l10@?o[Jf_onc[l002on3Oi008omkMh_oPgnCoi>?X
ok2_]?nDU9KoE5AFojj^/?oViNX3omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBc
on7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kg
ojb[^Onn^lKoFW:Fo`0hN`3Lo`10P00<o`0gN_m2K9coo_kbomSIg_oNgN;ogmkSon[Yk_n;RhgoRHV;
ohj>T?oHf=[oh^7V1OoOg^<01?o_k_?oQHF7okFe]ooWi^/2on3Oi008omoNhooViN[oa<?8of1PH_m:
BTcoPh>5om_KgOoQh>D2omoNh`07onGTjOn<S8koEeMGoeADE?nk^kgoiNCYon7Pi@02omoNh`07on3O
i?oZjNko^KVko`410oo@d=;oinOYon3Oi002omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[
Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa
00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`3Lo`10P004o`0gN_m2K9coo_kbomSIgP;ogmkS00SojNW[oh>3
QOnn_/3oTI6Cojj^/?oXj>[ogmoQon7Pi@;ogmkS00Koh^7Vom3@d_moOh7oDE5Conc[l?oNgN82omoN
h`0?onGTjOo1`<GoQXJ8oi>CUOmGEeOo][JhonSWk?oOg^?oh=oTonGTjOmmOGoo];Bfoe]KFon3PhGo
jNW[00;ogmkS00Ooh=oTomoNhooUi>WobLW;of5QHonDU9Kog=_P00;oh=oT0_oOg^<00ooLgN;oo_kl
oeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooo
oooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0g?l0@8003Ol0=g[o@VbLooknl_oH
fMkog]gRon3Oi?oQh>Goh>3Rohj>T?l;2`go9RHXolg=cooThnP00ooOg^<08OoUi>Wo^;Nlod=3AOl1
0@?oc/gBonGTjOoOg^?oh=oTomoNhooWi^_o_Kc1o`000_l`<3;og=cNon?RiooOg^?oh=oTonGTjOn[
ZZooZJV[oginP?mcLgGoj^W^omoNhooPgnCog]gRon3Oi?oYj>goOWj0oi:BU?nIVI_o_kk3onKUjP02
omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0
lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`3Lo`10
P00?o`0gN_m2K9coo_kbomSIg_oNgN;oh=oTomoNhooRh^CogmoQomOGfOoFe]Sog=_Pon3Oi?oOg^?o
h=oT00;ogmkS00Goi>?XomOGfOoHf=[og=_Pon3Oi002omoNh`;oh=oT00goiNCYolo?dOnh^;[oi^KX
omkMh_oPgnCogmkSon3Oi?oRhNKogmkSon3Oi?oMg>7oh=oT00;ogmkS00Koh>3RomoOhOoOgn7ofMWK
omkNh?oOgn44omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_kooooo
ookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:F
o`0hN`3Lo`10P004o`0gN_m2K9coo_kbomSIgP;ogmoQ00GogmkSon3Oi?oPh>;ohN7Son;Ri002omoN
h`03on3Oi?oOg^?ogmkS00;ogmkS00?ohN3Uon7QhooOg^<00_oOg^<2on3Oi005omoNhooPgnCohn;W
onKUj_oNgN800_oOg^<01OoPgnCog]gRon3Oi?oPgnCohN3U00;oh=oT00CogmkSon3Oi?oOg^?ogmkS
0_oPgn@01?oQh>Goh=oTon3Oi?oOg^<2on3Oi004omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[So
XZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Go
n?Kgojb[^Onn^lKoFW:Fo`0hN`3Lo`10P008o`0gN_m2K9coo_kbomSIg_oNgN;ogmkSon7PiOoOg^<2
on3Oi0;ogmkS00?oh=oTomkMh_oQh>D01?oOg^<01?oPgnCogmkSomoNhooPgn@3omoNh`03on3Oi?oO
g^?ogmkS00;ogmkS00?oh=oTomkMh_oPgn@00_oOg^<00ooNgN;ogmkSomoNh`02on3Oi0GogmkS00Wo
h=oTomoNhooOg^?oh=oTomoNhooNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookn
o_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjk
a_mJLYKo03Qk0=co042000Go03Mjod9/W?ono_;of=WNomkMhP02omoNh`0:on3Oi?oNgN;oh=oTomoN
hooPgnCogmkSon3Oi?oNgN;ogmkSon3Oi0?ogmkS00Coh=oTomoNhooOg^?oh=oT1_oOg^<02OoPgnCo
gmkSomoNhooOg^?oh=oTomoNhooPgnCogmkSon3Oi002omoNh`05on7PiOoOg^?ogmkSomoNhooPgn@0
0_oOg^<01ooPgnCogmkSon3Oi?oNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookn
o_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjk
a_mJLYKo03Qk0=co042000_o03Mjod9/W?ono_;of=WNomkMh_oOg^?og]gRonKUj_oQh>GogmkSon3O
i009omoNh`?oh=oT0_oOg^<01?oPgnCoh^7VonGTjOoPgn@2omoNh`05on3Oi?oOg^?oh=oTomoNhooP
gn@00_oOg^<02_oPgnCogmkSon3Oi?oNgN;ogmkSonWXkOoUi>Wog]gRon3Oi?oOg^<2on3Oi0;ogmkS
00?og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05
ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=co042000_o03Mj
od9/W?ono_;of=WNomoNhooPgnCohn;Wokbk`?oMgMooknoaon7Pi@03on3Oi006omoNhooPgnCoh=oT
on7PiOoUi>Woh=oT0ooOg^<2on3Oi006omoNhooKfmgo`L73on;Qi_oPgnCogmkS0ooPgn@01?oUiNOo
h^;Ton[Yk_oPgn@2omoNh`07omkMh_oOg^?oi>?Xoj>RYoo0_lCok>_`omkMhP02on3Oi0;ogmkS00Co
g]gRomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05
ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=co042000go03Mj
od9/W?ono_;of=WNomkMh_oOg^?ojn[_ofATI_mdM7KoVIVKomCDe_oRhNKoh=oT00?ogmkS00CohN3U
omOFfonl_;koi^KX0_oPgn@06OoOg^?og]gRomoNhooViN[o]KFgo`000_o5a<WoiNCYomoNhooPgnCo
gmkSon7PiOnm_KoodM7CoijNX?oFeM[ohN3Uon3Oi?oNgN;oh=oTonWXkOnHV9[o1@D7ol?3aOoZjNh0
0ooOg^<01OoPgnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookn
o_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0h
N`3Lo`10P00>o`0gN_m2K9coo_kbomSIg_oOg^?oh=oTonc[l?mkNggoMGEgocDe=ooNg^3oh^7VomoN
hooPgn@2omoNh`0QonGTjOo:b/co0002okBd]_oYj>goh=oTomoNhooQh>GogmkSonc[l?m@D5;oKFe_
omkMh_oQh>Goh=oTomoNhooPgnCoinK[ojVYZom/K6koJf]]on7QhooQh>GogmkSon3Oi?oNgN;oj>SZ
okNg^OmHF5SoShnAok^k_OoUi>Woh=oT00?ogmkS00?og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nR
Y;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Ooh
m_Oo[:^iokjka_mJLYKo03Qk0=co042000go03Mjod9/W?ono_;of=WNomkMh_oOg^?oi^GZok6a/on2
PXCoQ8B6om[Jg?oRhNKogmoQ00;ogmkS00ooh=oTonCSj?o6a/SoBd]=ofm_KooHemcoh^7Von3Oi?oO
g^?oh=oTonKUj_nh^;[oHf=UojZY[_oXin`00ooOg^<01_oSh^Oo`/;4ofa/K_m_Kg7oc<c>onGTj@;o
gmkS00Ooh=oTonKVj?ni^K_oS8b<olG5aOm/K6kojNS]00;ogmkS00Goh=oTomkMh_oLgN;oo_kloeIk
Y`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooo
n?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0g?l0@8005_l0=g[o@VbLooknl_oHfMko
g]gRomoNhooSh^Oob/[<oi>CUOnPX:;o]KFgonOVjooPgnCog]gRon3Oi?oNgN;oinK[ojFUYonf][So
WinQok>c]OoXin`2omoNh`07on3Oi?oThnSoc/gBofm_LOn[Zjgof][Lon7Pi@02on3Oi006onGTjOnb
/[Co5QHHo`000_nFUYSoj^[/0_oOg^<03_oPgnCogmkSonOVjon^[[3o?cm1okRh^_oUi>WogmkSon3O
i?oOg^?og]gRomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3a
ooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=co0420
00Go03Mjod9/W?ono_;of=WNomkMhP02omoNh`04on3Oi?oOgn7oh>3RomoNh`;oh=oT0_oOg^<01?oP
gnCogmkSom[Ig_oShnD2on3PhP0;omoNhooPgnCoh=oTomoNhooPgnCojn[_ohb<S_l000;o_ko1onSW
k?oNgN800_oOg^<01ooRh^CoemOIomKFf?oIfM_oh>3RomoNhooPgn@00_oOg^<01OoPgnCohn;WomGD
fOoUi>Woh=oT00;ogmkS00Goh=oTomgLhOoLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Ko
o_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo
_[_6oeYbU_l0>7/0g?l0@8001_l0=g[o@VbLooknl_oHfMkogmkSomkMhP;oh=oT00KohN3Uon3Oi?oO
g^?ogmkSomkMh_oQh>D3omoNh`?oh=oT00oogmkSon3Oi?oOg^?ogmkSon3Oi?oOg^?oh=oTomkMh_oP
gnCogMcQomoNhooPgnCog]gRomoNhooPgn@00ooQh>D01OoOg^?oh=oTomoNhooOg^?oh=oT00;ogmkS
00?oh^7VomoNhooPgn@01?oOg^<00ooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_kn
ooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6
oeYbU_l0>7/0g?l0@8001Ol0=g[o@VbLooknl_oHfMkog]gR00;ogmkS00Ooh=oTomoNhooPgnCoh=oT
omoNhooPgnCogmkS00;oh=oT0ooOg^<02?oPgnCogmkSon3Oi?oOg^?oh=oTomkMh_oPgnCogmkS0ooQ
h>D02?oOg^?oh=oTomoNhooPgnCogmkSon3Oi?oOg^?oh=oT0_oOg^<2on3Oi00=omoNhooPgnCoh=oT
omoNhooPgnCogmkSon3Oi?oOg^?oh=oTomkMh_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQ
h^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/
ZkWo_[_6oeYbU_l0>7/0g?l0@8001_l0=g[o@VbLooknl_oHfMkog]gRon3Oi0?ogmkS00?oh=oTomoN
hooPgn@00ooPgn@01?oOg^?oh=oTomoNhooPgn@2omoNh`04on3Oi?oOg^?ogmkSon3Oi0CogmkS00Oo
h=oTomoNhooOg^?ogmkSon3Oi?oOg^?oh=oT00;ogmkS00?oh=oTomoNhooPgn@00_oOg^<2on3Oi0Go
gmkS00Goh=oTomoNhooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_ko
oogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0
g?l0@8001_l0=g[o@VbLooknl_oHfMkog]gRon3Oi0;ogmkS00?oiNCYon;Qi_oQh>D00_oOg^<3on3O
i0;ogmkS00Goh=oTonOVjooOg^?ogmkSon3Oi004omoNh`03on3Oi?oOg^?ogmkS00?oh=oT00SogmkS
on3Oi?oOg^?ogmkSon3Oi?oNgN;oh=oTomoNh`;oh=oT0_oOg^<3on3Oi007omoNhooPgnCog]gRomoN
hooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Go
o_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0g?l0@8001?l0=g[o
@VbLooknl_oHfMh2omoNh`05on3Oi?oThnSob<S:om?CeOoQh>D00_oPgn@02?oNgN;oh=oTomoNhooN
gN;oinK[om_KgOni^K_ohN7S0_oOg^<01_oPgnCog]gRon3Oi?oRhNKojNW[on;QiP?ogmkS00Koh=oT
omkMh_oRhNKoiNCYonCSj?oQh>D4omoNh`06omkMh_oSh^OoiNCYon7PiOoYj>goh=oT1?oOg^<00ooL
gN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_kn
oooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0g?l0@8002ol0=g[o@VbL
ooknl_oHfMkog]gRon3Oi?oQh>GohN7SoeEEEom8B4[oj^[/00?ogmkS0_oPgn@01_oThnSo`L73ol71
`omVIVSoj>SZomkMhP;ogmkS00Ooh=oTon7PiOoJfMkoWinQomOGfOoQh>Goh=oT00;ogmkS013ohn;W
om;Ae_o9bL_oaLC9om7@eOoRhNKog]gRon3Oi?oOg^?ohn;Wolg<dOo7alWoh>3RoijNX?oFeM[oh^7V
0_oOg^<01?oNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn
0??ooooo00?oo_knooOgmoo^k_001?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/0g?l0
@8002ol0=g[o@VbLooknl_oHfMkog]gRomoNhooUi>Woa<C6ob<S9Oo3`lGohn;W00;ogmkS0_oPgn@0
2?oOg^?oj^W^ohb;T?nOWj7oPh>5omOFfooQh>GogmkS0_oPgn@02_oXincoTY:Doh:2Q?nBTYCoj^W^
on3Oi?oOg^?oh=oTonWXkOnd/kP2ohF5Q`03olO7bOoThnSoh=oT00;ogmkS00goinK[okZi__n2PX;o
ShnAoi2@T_oKf]ooh^7VomoNhooPgnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7R
i_ono_koooooookno_oooOh0loooool00oono_komoOgonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[
^Onn^lKoFW:Fo`4hN`3Lo`10P00>o`0gN_m2K9coo_kbomSIg_oNgN;ogmkSon7PiOoLg=koTY:Dol30
`_oZjNkogmkSomoOhOoOg^<2on3Oi007onCSj?o:b/coKFe_oh^;SOn][;7ojNS]on3Oi002omoNh`06
on_ZkomjNWcoTi>EodI6B?o4`lSoi^GZ0_oPgn@02?oViN[ob<O<o`000_mQHF?oi^KXon7PiOoOg^?o
h=oT0_oOg^<03?oWi^_o/k>eo`000_oCdmGoi^GZomoNhooPgnCog]gRomoNhooLgN;oo_kloeIkY`7o
03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0loooool00oono_komoOgonk^l004ono_
l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Lo`10P00<o`0gN_m2K9coo_kbomSIg_oNgN;o
h=oTomoNhooWinWoc/k@o`000_ne];WoiNCY0_oOgn42omoNh`0?onWXkOnNWZ3o7AdOoc0`<_ni^;go
inK[omoNhooPgnCogmkSonSWk?nPX:;o<S8doeeMGone];WojNS]00;ogmkS00Ooh=oTonOVjon;Rhgo
UYJHojFUYooUi>WohN3U00;ogmkS00Koh=oTomoNhooalO?oL71bol?3aOoViNX2omoNh`05on3Oi?oN
gN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3cooooo`03
ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk0=co042000go03Mj
od9/W?ono_;of=WNomkMh_oPgnCogmkSon;Qi_oHf=[oZJV[okFd^OoQh>Goh=oT00;ogmkS00Goh=oT
on7PiOoIfM_oh>3Rom_Kg@03omoNh`08on3Oi?oOg^?oh^7VomoOhOn;RhgoPh>5omCCf?oRhNH2on3O
i005omoNhooPgnCogmoQon?SiOoJf]`00ooOg^<02?oPgnCog]gRonOVjonLW9koKfmaom_KgOoRhNKo
h=oT0ooOg^<00ooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn
0??ooooo00?oo_knooOgmoo^k_001?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/0g?l0
@8001_l0=g[o@VbLooknl_oHfMkog]gRon3Oi0;ogmkS00?oh=oTonWXkOoUi>T00ooOg^<01?oPgnCo
g]gRon3Oi?oRhNH2on7Pi@;oh=oT00[ogmkSomkMh_oOg^?oh=oTon?RiooIf=goeMGGonCSj?oPgnCo
g]gR0_oOg^<01?oPgnCohN3Uon3Oi?oPgn@2omoNh`09on3Oi?oOg^?oh=oTon7PiOo?cm7ofm_Mon?R
iooOg^?og]gR00;oh=oT00CogmkSomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_oo
ooooo_knooomoP3cooooo`03ookno_ogmoOok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJ
LYKo0CQk0=co042000Co03Mjod9/W?ono_;of=WN0ooOg^<01_oPgnCogmkSomoNhooPgnCogmkSon3O
i0;ogmkS00Koh=oTomoNhooOg^?ohN3UomoNhooPgn@3omoNh`05on3Oi?oNgN;oh=oTon7PiOoShnD0
0_oOg^<00ooPgnCogmkSon3Oi002omoNh`;oh=oT0_oOg^<2on3Oi0;ogmkS00_ohn?Uon7PiOoOg^?o
gmkSon3Oi?oOg^?oh=oTomkMh_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0??ooooo00?oo_knooOgmoo^k_001?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYb
U_l1>7/0g?l0@8001?l0=g[o@VbLooknl_oHfMh2omoNh`03on7PiOoNgN;oh=oT00;ogmkS0ooPgn@3
omoNh`04on3Oi?oOg^?oh=oTon3Oi0KogmkS00Goh=oTomoNhooPgnCogmkSon3Oi003omoNh`03on3O
i?oOg^?oh=oT00;ogmkS00?oh=oTomoNhooOg^<00_oOg^<01?oPgnCogmkSon3Oi?oPgn@2omoNh`04
omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0loooool0
0oono_komoOgonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`3Lo`10P008o`0g
N_m2K9coo_kbomSIg_oOg^?oh=oTomoNhooPgn@6omoNh`07on3Oi?oOg^?ohN3UonGTjOoPgnCogmkS
on3Oi003omoNh`04on3Oi?oOg^?ohN3UonGTj@;ogmkS00Goh=oTomoNhooOg^?ogmkSon3Oi002omoN
h`?oh=oT0_oOg^<01OoPgnCogmkSomoNhooOg^?oh=oT00;ogmkS00Koh=oTomoNhooNgN;og=gRookn
o?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooo
oooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0g?l0@8001_l0=g[o@VbLookolOoH
fMkog]gRomoNh`;oh=oT00?oj^W^onc[l?oQh>D00ooOg^<02?oPgnCoh^7Vom;Be?nm_KoojNW[ong]
kooRh^CogmkS0_oPgn@01OoOg^?oh^7Vom7@eOnm_KooiNCY00;ogmkS00Woh=oTomoNhooPgnCog]gR
onSWk?oWi^_og]gRomoNhooPgn@01?oOg^<01_oRhNKokNcaonGTjOoNgN;ogmkSon3Oi0;ogmkS00?o
g=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookn
o_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk0=co042001Ko03Mjod9/
W?onoo7of=WNomkMh_oOg^?ohN3UomkMh_nMWIooV9RJom7@eOoRhNKogmkSon7PiOoNgN;oh^7VomoN
homUIFOoY:BVoiNGVOoGemWoh^7V0_oOg^<01_oPgnCoi>?XolW8cOmJFUcoh=oTon;QiP?ogmkS00Go
h=oTonOVjonc/[Oo^KRmonKUjP05omoNh`05on;Qi_oIf=goUIBIokZi__oThnP01?oOg^<00ooLgN;o
o_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooo
oooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0g?l0@8003?l0=g[o@VbLooko
lOoHfMkogmkSon3Oi?oZj^coShnAog]kOOlK6agoZJV[onCTiP;ogmkS00Woh=oTomoNhoo]k?7oQ8B6
oc0`<_nRXZCoOGemonCTi_oPgn@00ooOg^<03_oalO?oO7aloi^KWOo[jngoh=oTomoNhooPgnCoi^GZ
okno`OmbLWCoN7QjolW9booThnSoh=oT0ooOg^<01OoWi^_oR8R:ohZ:S?no_l7oiNCY00;ogmkS00Go
h=oTomoOhOoLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7o
oooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0g?l0@800
1?l0=g[o@VbLookolOoHfMh2omoNh`07onWYjon7QhWoXj>Uoc0`<_nc/kGoinOYon3Oi002omoNh`07
on3Oi?oSh^Ooa<C6oh>3QOnj^[[oOGemon?Si@02on3Oi007omoNhooQh>Goe]KHodM7Aol000;ohn?U
on7Pi@02omoNh`06onOVjonj^[coRXZ<oh^;SOnk^kgoinK[1?oOg^<03?oZjNkoC4a>oe5ADone]KOo
i^GZomoNhooPgnCogmkSomoOhOoLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_kooooo
ookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:F
o`0hN`3Lo`10P00=o`0gN_m2K9coo_oaomSIg_oNgN;ogmkSon7PiOoNg^3oMgMiofATI_nHV9[oaLC9
onGTj@03omoNh`06on;Qi_oPh>;oN7QjogQhN_n9RH_oi>?X0ooOg^<01_oViN[o[ZfbohZ:S?n<S8ko
^[VnonKUjP?ogmkS00ooinK[ojRXZ_l10@?oc/k@onCSj?oOg^?oh=oTomkMh_oPgnCoi^GZoj^[[OlP
82;oXJ6SonWXkOoPgn@00_oOg^<01?oNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Ko
o_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo
_[_6oeYbU_l0>7/0g?l0@8001Ol0=g[o@VbLookolOoHfMkog]gR00;ogmkS00Soi>?XomgMgooMgMoo
h=oTom_JgooQh>GogmkSon3Oi0;ogmkS00KojNS]okZj_?mNGV3oWIfOonGTjOoOg^<2on3Oi004omoN
hooQh>GohN7Son7Pi@?ogmkS00[oh=oTomoNhooUi>Wob/W>o`000_nWYjWoj>O/on3Oi?oNgN;oh=oT
0_oOg^<01?oTi>KodM7ComOFfooQh>D3omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[So
XZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Go
n?Kgojb[^Onn^lKoFW:Fo`0hN`3Lo`10P006o`0gN_m2K9coo_oaomSIg_oNgN;oh=oT0_oOg^<00ooR
hNKohN3Uon3Oi002on3Oi0CogmkS00?oh=oTonCSj?o>cM800_oQh>D2omoNh`05omkMh_oQh>GogmkS
on3Oi?oRhNH01OoPgn@01_oOg^?oh=oTolg<dOoAd=Goh=oTomoNh`?oh=oT00KogmkSon3Oi?oRhNKo
h^7VomoNhooPgn@3omoNh`03omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_kooooo
ookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:F
o`0hN`3Lo`10P007o`0gN_m2K9coo_oaomSIg_oZjNkojn[_onc[l007on_Zk`06onc[l?o[j^oojn[_
on_Zkoo/jo3ok^gb0oo/jo02onc/kPCojn[_00Gok>_`on_Zkoo/k>kojn_]onc[l002on_Zk`03oo3_
m?o^kO;ok>_`00;ojn[_00?ok>_`on_Zkoo[j^l01Oo[j^l01_oZjNkohN3UomkMh_oLgN;oo_kloeIk
Y`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_kooooooooooooh
n?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`08o`10P003o`10O_l0?h;o042000;o0420
00?o03n2o`10P?l1@Gl0/?l0@8004?l0?h;o0420o`0oOol0?h;o0420o`51O_l0@7ko03n2o`10P?l0
@H3o03j1o`10O_l2?gko0460o`8oP?l0@889o`10P00@o`10O_l0@83o0D61o`0gN_m2K9coo_kbol[;
d?moOgooMGEeogmoOon0P83oPX:2oh61POn0PX7oOh60oh61P@?oP82000CoPH61oh:2P_n2PX;oQ8B6
0_n1PH44oh22P@;oPH6100?oP8:1ogn0P_moPGh00_moPH001_n0PWooPX>5oh:4Pon5QHGoQ8B6oh:2
Q0CoPH6100coPX:4oh61Pon2PX;oPX:2oh61PomeMGOoOgmoom7AdooRhNKog=gRookno?mFNjL1o`0f
N@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^
l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/02?l0@8002?l2?h3o0420o`10O_l2?h;o0Sn0o`10
P?l2?gko04222?l0@7jYo`10P004o`51Ool0@7ko0420o`10P0;o042400Go041no`4nOol0@7ko0D61
o`0oO`0=o`10P00:o`10O_l0@83o0420o`0gN_m2K9coo_kbom7Beone]KOo/[:dok>c]@;o/[:d00Co
/k>eok:b]?nc/kGo/[:d0_nc/kD3ok:b]008ok>c]Onb/[Co/[6fok:b]?nc/kGo/K6cok>c]Onb/[@2
ok>c]@07ok:b]?nc/[Oo/k>eok:b]?nc/kGo/[:bok>b]`02okBd]P;o/[6f013o/k>eok6a/onc/kGo
/k>eok>b]onc/kGo/[:dok>c]Onb/[Co/K6cokJf^?oGe]_oh=oUomcMh_ono_coEW^W0Ol0=WT00007
oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_
ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00[o042000Ko041mo`8oP?l0@7go0D61o`4nOol0@8:ao`10
P0;o041n00So0420o`51Ool0@7ko041no`10P?l0@H?o0420o`11OP?o042000?o0Sn0o`10O_l0@800
2?l0@8002?l0?ggo0420o`10P?l0=g[o@VbLooknl_oHfMkoinK[0_oYj>d3onSWk004onWXkOoXinco
j>O/onSWk0?ojNS]00KoinK[onSWk?oYj>gojNS]onSWk?oYj>d2onSWk00@on[Yk_oYj>goj>O/onWX
kOoWi^_oj>O/onWXkOoXincoj>SZonc[l?oXincohN3Uonc[l?oYj>goj>O/onWXk@;oj>O/00coj^W^
onSWk?oXj>[oj^[/onWXkOoXincoinOYon3Oi?oNgN?og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T
/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSf
mon/ZkWo_[_6oeYbU_l0>7/02?l0@8002?l0@8;o0420o`10O_l0?h;o03mmo`10P?l0@7ko03mm/?l0
@8002_l0@7ko0420o`10P?l0@83o03n2o`10P?l0@7ko03moo`90Nol0?h@2o`10P003o`4nOol0@83o
042000[o042000go041no`10P?l0?goo03Mjod=]WOono_;ofM[OomkMh_oPgnCogmkSomkMh_oPgnCo
g]gR00;ohn;W0_oOg^<02OoPgnCogmkSomoNhooThnSohN3Uon;Qi_oQh>Goh=oTomoNh`02on3Oi004
omoNhooQh>GoiNCYon?Ri`;oh=oT01Sog]gRomoNhooRh^Cog=_Poh60QOll>d3o^KRmonOVjooPgnCo
gmkSon3Oi?oRh^CoPh>5om;Ae_o[j^ooTi>Eol;1a_oUi>Wog]gRomoNhooNgN;og=gRookno?mFNjL1
o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Sh
onk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/02_l0@8001_l0@7go0Smno`11POl0?h;o?39a
ogAbRPCoIfQl[?mVIg/03OmXIW_oJFMmofUXN_mXIgWoJFMmofQVNomYIggoLg2?ocXdM?l0?hCo0420
o`8oO_l0@H403?l0@8004Ol0@7ko0420o`10P?l0=g[o@VbLooknl_oHfMkog]gRomoNhooPgnCohN3U
onOVjoo^kO;odm7Fom;@eOoQh>GogmkS00;oh=oT00Koj>O/oi>BUooBdMKoYjNYokJe^_oXj>X3omoN
h`05on7PiOoNgN;oTI6CokFe]ooUiNL00_oOg^<05ooOgn7oi^KXogUiNone]KOohn?Uofa/K_o2`/Co
iNCYomoNhooPgnCohn?Uoda<C?o?c]?okNg_of][KOni^K_oi^GZon3Oi?oOgn7ogmkSomcMh_ono_co
EW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_kooooooooo
ooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`0:o`10P006o`=0POl0@8;o03j1o`12
OomeKioooogn0oono_85oogmlJSooocc00oooOgcooclm?oooO7ooOgaoocll_oooo;ooOgaooonoOmf
KI[o0420o`=0Ool0@Gko03n2o`10P?l0@7h02_l0@8001ol0@7ko0420o`10P?l0=g[o@VbLoooolooH
fMh00_oOg^<04OoPgnCofm[Oojb/[_n`/;;o>3PjojZXZooZjNkoh=oTomoNhooPgnCoi^KXojZZ[?n3
PhGoOgn1olo>dooSh^OogmkS00;oh=oT01WoiNCYolK5b_l_;c7oPX66onWYjooOg^Coh=oTomoNhooU
i>WoGemQolo?dOo`l?;oQhN9okBd]_oWi^_ogmkSon3Oi?oShnGoDU9Dolo>doo]kNooLG5aokVi^ooW
i^_ogmkS00;ogmoQ00?og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_kn
ooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk
00So042000So045no`50Pol0?h7o0420o`11POl0@7koKFJ@ooonk`GoiNGU0ooTi>BXonGUi@0@onCT
h_oUiNGoiNGUonCTh_oUiNGoi>CVonGVhOomoo7oL6Z@o`0lNol0@7ko0D61o`=0Pol0?goo0d1oo`0o
O`Wo042001Wo041no`10P?l0@83o03Mjod9/W?ono_;of=WNomkMh_oOg^?ohN3Uom[Ig_nBTIKoQXJ8
ohV9Roo@d=;oi>?XomkMh_oPgnCogmkSonKUj_o;blgoBDU;oh>3QOoYj>gog]gR00;oh=oT01WogmkS
onKUj_ne]KOoGemQogimP_oMgMooh^7WomoNhooPgnCoiNCYoeIFF?o:b/coknoaogalO_nd];KoinOY
on3Oi?oNgN;ohn;WoeIFF?oGe]_oooooogmoOonh^;[oi^GZ00;ogmkS00Cog]gRomcMh_ono_coEW^W
0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooSh
n?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo042000Oo03moo`10P?l0@7ko0Sn0o`51
Oom_IY?oo_oa00SoiNGUZ?oTi>@04?oUiNOoi>CTonCTi?oUiNGoi>GPonGUiooUiNGoo?k`og=WUol1
>Woo03moo`10P_l0@H3o0d1oo`10OOl0?h88o`10P008o`0oOol0@7ko0420o`10P?l0=g[o@ffMookn
l_oHfMh2omoNh`;oh=oT0_o[j^l00oo]k?7oh^7VomoNh`03omoNh`0Won7PiOoJf]coMGEgoj2PX_oV
iN[ogmkSon3Oi?oOg^?oh=oTonSXj_mjNWcoc<c<oiFEUonf][SoinK/omoNhooOgn7oiNCYod];Boo;
blgokng`og=aM?ne/kCoj>SZomkMh_oPgnCoi^GZoibLW_nHUico/K6coh>3QOoFeM[oh^7WomoNi?oP
gnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOoo
ool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`09o`10P003
o`10O_l0@83o042000;o042000?oKfJEoooml?oUiND09ooUiND00ooTi>CoiNGUonCTi002onCTi0;o
iNGU0_oTi>@01?oUiNGoi>CTonGUiOoTi>@4onGUi@03onCTi?oUiNGoiNGU00?oiNGU00?oi>CTonGU
iOoUiND00_oUiND01?oTi>CoiNGUonGUiOoTi>@2onGUi@;oi>CT00?oiNGUonCTi?oTi>@00_oUiND0
1_oTi>CoiNGUonGUiOoUiNGoi>CTonGUi@;oi>CT00?oiNGUonCTi?oUiND00ooTi>@3onGUi@03onKV
i_oTi>CoiNGU00GoiNGU00Goi>CTonGUiOoUiNGoiNGUonCTi004onGUi@03onCTi?oUiNGoi>CT00Co
iNGU00Goi>CTonGUiOoUiNGoiNGUonCTi003onGUi@07onCTi?oUiNGoiNGUonCTi?oUiNGoi>CTonGU
i@02onCTi003onGUiOoTi>CoiNGU00;oi>CT9ooUiND00ooooO3oLFREo`0kO@0Bo`10P009o`0gN_m2
K9coo_kbomSIg_oNgN;ogmkSon3Oi?oOg^?oh=oT00;ogmkS00Soh=oTomoNhooOg^?ogmkSon3Oi?oO
g^?ohn;WomcKh0;ohN3U00Woh=oTomoNhooPgnCogmkSon7PiOoIf=gohN3Uom_JgooLfn000_oPgn@0
2OoOg^?oh^7VojZY[_oEe=Woi^GZok:a]_o:bLkohn;WomoNh`02on3Oi005onOVjonJVYcoIFEWomCD
e_oUi>T00_oOg^<01OoPgnCogmkSomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_ko
ooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKo
FW:Fo`0hN`09o`10P003o`10O_l0@83o042000;o042000?oKfJEoooml?oUiND09ooUiND00ooTi>Co
iNGUonCTi002onCTi0;oiNGU0_oTi>@01?oShn?oi>CTon;Rh_oTi>@2on?Sh`Coi>CT00?ohn?SonCT
i?oShn<00_oTi>@2on?Sh`;oi>CT00Cohn?SonCTi?oShn?ohn?S0_oTi>@00ooShn?oi>CTonCTi004
on?Sh`04onCTi?oShn?oi>CTonCTi0;ohn?S0_oTi>@01OoShn?oi>CTonCTi?oTi>Cohn?S00;oi>CT
00?ohn?SonCTi?oShn<00_oTi>@01?oShn?oi>CTon?ShooTi>@2on?Sh`;oi>CT00Cohn?SonCTi?oS
hn?oi>CT0ooShn<01_oTi>Cohn?SonCTi?oTi>Cohn?SonCTi0;ohn?S00?oi>CTon?ShooUiND00_oT
i>@00ooShn?oiNGUon?Sh`02onCTi003on?ShooTi>Coi>CT00;oi>CT00?oiNGUonCTi?oTi>@0:OoU
iND00ooooO3oLFREo`0kO@0Bo`10P005o`0gN_m2K9coo_kbomSIg_oNgN800_oOg^<00ooPgnCogmkS
on3Oi002omoNh`04on3Oi?oOg^?oh=oTomoNh`;oh=oT0_oQh>D02OoPgnCogmkSon3Oi?oOg^?ohN3U
omkMh_oQh>GogmkSon;QiP02on3Oi00:omoNhooPgnCoh=oTonSWk?oPgnCogmkSonOVjooRhNKog]gR
on3Oi0;ogmkS00Goh=oTonWYjooZj^coh^7VomkMhP02omoNh`05omkMh_oOg^?og=gRookno?mFNjL0
0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooSh
n?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo042000?o041no`10P?l0@8000_l0@800
0om_IYGooog`onGUi@0WonGUi@05onCTi?oUiNGoiNGUonGUiOoTi>@00_oUiND2on?Sh`09on7QhOoR
h^;ohn?SonSXj?oUiNGohN7Qon?ShooXj>SoiNGU00;oh^;R00GohN7QonOWiooYjNWojNWYonCTi002
on;RhP?oj>SX00Goi>CTonSXj?oShn?oh>3Pon7Qh@02onOWi`05on;Rh_oWinOoinOWonSXj?oVi^H0
0_oQhN404OoUiNGoinOWonKVi_oWinOohn?Son;Rh_oVi^KohN7QonKVi_oWinOoh^;RonGUiOoRh^;o
iNGUon?ShooRh^;oinOW00;oj>SX01_oh^;Ron7QhOoVi^KojNWYonKVi_oQhN7ohn?SonOWiooXj>So
i^KVon;Rh_oVi^Koi>CTon3Ph?oRh^;ohn?SonCTi?oShn?oiNGUon;Rh_oTi>Cohn?Son;Rh_oQhN7o
iNGUonWYjOoXj>P00_oRh^801ooUiNGoh^;Ron7QhOoShn?oiNGUon;Rh_oQhN400_oTi>@2onGUi@03
onCTi?oUiNGoiNGU02GoiNGU00?ooog`og5XUOl0>gd04_l0@8001_l0=g[o@VbLooknl_oHfMkog]gR
on3Oi0GogmkS0ooPgn@2omoNh`03on3Oi?oNgN;oh=oT00CogmkS00Goh=oTomoNhooPgnCog]gRon3O
i003omoNh`06on3Oi?oOg^?ogmkSon3Oi?oOg^?oh=oT1OoOg^<01OoPgnCogmkSomoNhooPgnCogmkS
00;oh=oT00KogmkSon3Oi?oNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYb
U_l0>7/02Ol0@8000ol0@7ko0420o`10P002o`10P003ofmVUOoooO3oiNGU02OoiNGU00?oi>CTonGU
iOoUiND00ooUiND03?oTi>Cohn?Son7QhOoRh^;ohn?SomoOgoo?cloofMWIonCTi?oMgMgoc/k>omcL
g0;ohn?S00SojNWYomOGeonh^;So`/;2on;Rh_oYjNWogMgMolo?c`;oc<c<00?ofMWIolk>c_oKfm/0
0_oShn<02ooAdM7oeMGEonGUiOoDe=Coa/K6ol_;booHf=SoinOWonSXj?oKfm_oc<c<00;odM7A0_oQ
hN406_oIfMWoiNGUomOGeoo>c/kogMgMomKFe_oTi>Cog=cLomKFe_oQhN7ocLg=ol;2`_o5aLGogMgM
onKVi_oBd];o[jn_omGEeOoVi^Koh>3Polc<c?o1`L7oalO7omoOgooGemOog]kN0_oShn<04ooOgmoo
eMGEomoOgooFe]Koi>CTomcLg?oEeMGohn?SonSXj?oDe=Co[Zj^okjn__oPh>3ohN7QomOGeooOgmoo
h^;RomoOgooGemL00_oRh^801?oShn?oiNGUonGUiOoTi>@XonGUi@03oooml?maJ9Go03]m01;o0420
00Co03Mjod9/W?ono_;of=WN1?oOg^<2on3Oi0?ogmkS00Goh=oTomkMh_oPgnCogmkSon3Oi002omoN
h`0;on3Oi?oOg^?ogmkSon3Oi?oNgN;ogmkSon7PiOoNgN;oh=oTomoNhooPgn@01?oOg^<2on3Oi004
omoNhooPgnCogmkSon3Oi0;ogmkS0ooPgn@00ooNgN;ogmkSomoNh`02omoNh`04omkMh_oLgN;oo_kl
oeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_kooooooooo
ooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`09o`10P003o`10O_l0@83o042000;o
042000?oKfJEoooml?oUiND0;OoUiND04?oTi>Coh^;Ron;Rh_oQhN7ok>c/ojNWYol0003oLG5aookn
o_n:RX[o0000ohN7Qoo^k^kojNWYoj>SXol10@42o`00000doeaLG?oKfm_o_;blo`000?l10@7o0000
ohR8R?l0003oWinOoo[jn_oMgMgo71`Lof1PH?nj^[[o0@41of5QHOld=3Co?3`lon?ShooalO7oJ6QX
oaXJ6_mfMWKo0@41olg=cOnWYjOoD51@oooooombLW;o2@T9okfm_On0P83ohN7Qofa/K?ni^KWoe]KF
oaDE5OmLG5coMGEeomWIfOo:b/[oADE5ogemOOmGEeOodm?ColS8b?lN7QkoH61Pog]kNooMgMgoU9BD
oj:RXP;olo?c01Go/[:bohR8R?oCdm?oLg=con3Ph?m`L73o/K6aoo3`l?nc/k?oCDe=oh>3PomOGeoo
YZJVon7QhOmJFU[odM7Aon_[joo2`/;oIFEUonOWiooRh^800_oTi>@00ooUiNGoi^KVonCTi00WonGU
i@03oooml?maJ9Go03]m01;o042000Go03Mjod9/W?ono_;of=WNomkMhP02omoNh`05on3Oi?oOg^?o
h=oTomoNhooPgn@01?oOg^<00ooNgN;oh^7VonGTj@02on3Oi0;ogmkS0_oPgn@03ooOg^?oi>?Xong]
koo[j^oohN3UomoNhooPgnCogmkSon3Oi?oRhNKojn[_onc/k_oVi^SogmkSon3Oi002omoNh`07on3O
i?oOg^?ogmkSomoNhooPgnCogmkSon3Oi002omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[
Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa
00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`09o`10P003o`10O_l0@83o042000;o042000?oKfJEoooml?oU
iND0;OoUiND0@_oTi>Coh^;Ron;Rh_oRh^;oj^[Zog5aLOl10@7o=cLgoooooomGEeOo0000oe9BD_oo
oooo`/;2o`000?lY:BWoX:2PohF5QOl0003oHV9RokBd]?l0003oJFUYok2`/?nQXJ7o0000oiVIVOoo
oooolO7aobl_;om7AdOoE5ADoc4a<OooooooR8R8o`000?l_;boo>3Pho`000?mcLg?o[Zj^o`000?nl
_;coIVIVo`410Oo7alOoFEUIochn?_o7alOoNg]koijNW_n<S8cok^k^olK6a_mfMWKok>c/on[Zj_oW
inOo]kNgokFe]OooooooTI6AoinOWoo2`/;oNWYjooknoP;oj>SX01Woa/K6od];BonPX:3oYZJVoeMG
Eonf][KoeMGEogQhN?nNWYkoRh^;on[Zj_o8b<SoCTi>olW9bOo_knooh>3Polg=cOoLg=coFEUIomGE
eOogmoOoaLG5of5QHOoUiNGoh^;R00;oi>CT00?oiNGUonCTi?oUiND09ooUiND00ooooO3oLFREo`0k
O@0Bo`10P008o`0gN_m2K9coo_kbomSIg_oNgN;ogmkSon3Oi?oYj>d2on[Zk00=on_ZkooQh>Gog]gR
omoNhooQh>GogmkSon7PiOoKf]oob/W>ong]kooQhN?ogmkSon3Oi002omoNh`0>onGTjOnk^kgoUYJH
ojJVZ?oGemWoh^7Von3Oi?oOg^?ohN3UomWIfonVYZSoUIFGokVi^ooThnP3omoNh`06on3Oi?oRhNKo
i>CVomgMgooNgN;oh=oT0_oOg^<01OoPgnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBc
on7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kg
ojb[^Onn^lKoFW:Fo`0hN`09o`10P003o`10O_l0@83o042000;o042000?oKfJEoooml?oUiND0:OoU
iND00ooTi>CoiNGUonGUi@02onGUi@0ion?ShooRh^;oiNGUomWIfOld=3Co?clooc@d=?mkNg_o?Shn
odA4A?lL71coi^KVohb<S?l10@7o_[jnookno_ooooooLG5ao`X:2_nBTY;o3Ph>oiZJV_ono_ko^;Rh
o`000?m5ADGoKfm_om7AdOmADE7o4a<Co`000?mWIfOoo_knomkNg_l20P;oGUiNog5aLOl0003o^KVi
onKVi_l@413oJFUYocHf=_l:2P[oIfMWochn?_mVIVKoo_knode=COlD51Co][JfoogmoOo:b/[oEeMG
okFe]Onl_;cofMWI00;oj^[Z00Go/[:boeMGEono_kooa/K6ofEUI@02ok^k^`0JomcLg?o[jn_oLg=c
og=cLon4Q8CoBd];onOWiooDe=CoADE5oa8B4_nc/k?oo_knoi^KVonJVY[ok^k^on;Rh_oTi>Coj>SX
omcLg?mMGEgoYJFUokbl_?nIVIWoJf][on[Zj_oRh^82onCTi003onGUiOoTi>CoiNGU02OoiNGU00?o
oog`og5XUOl0>gd04_l0@8003_l0=g[o@VbLooknl_oHfMkogmkSon7PiOoKf]oo[Jf_oj^[[On/[:ko
Zj^]omKEf_oRhNKoh=oT0_oOg^<01_oXinco[jnaobLW:Onb/[Coe]KHon;QiP;ogmkS017oh=oTon?R
ioo1`L?oUIFGocHf>?o;blgoi>?Xon3Oi?oNgN;oi^GZol_;cOle=COoUIFGol71`ooSh^Ooh=oTomoN
h`02on3Oi00<omcKh?n:RX[oHf=UogQhN_oCd]Oohn;WomoNhooPgnCogmkSomcMh_ono_coEW^W0Ol0
=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^
k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo042000?o041no`10P?l0@8000_l0@8000om_
IYGooog`onGUi@0YonGUi@;oi>CT0ooUiND03ooShn?oh^;Ron_[jonc/k?o0000oiBDU?mIFEWo1`L7
ochn?_nl_;co0@41oi6ATOnCTi?o0000okFe]@02ooooo`0Rofm_Kol=3@goU9BDo`@41?nEUIGooooo
okBd]?l0003o@d=3ofi^K_oQhN7oBd];odA4A?n8R8So0000oi6ATOooooooFe]Kod92@_mEEEGo@d=3
ooooooo/k>co?cloo`L71om4A4CoMGEeoa`L7?l0003oQhN7ooGemOmRHV;oUIFEog1`L0;od=3@02[o
;Bd]oh:2P_n?Shooe]KFon;Rh_n8R8SoKVi^ol30`?oclo?o`<30oc8b<_n6QXKoT92@omCDe?o/k>co
]kNgoi6ATOnJVY[oX:2Poo3`l?oAdM7oGEeMoiBDU?m`L73od=3@ojBTY?nHV9Sokno_on7QhOoShn?o
inOWon3Ph?mADE7oMgMgoh^;RomZJV[oHF5Qon[Zj_oQhN7ohn?SonGUiOoTi>@YonGUi@03oooml?ma
J9Go03]m01;o042002Oo03Mjod9/W?ono_;of=WNomkMh_oThnSod];DocLg>Ole=CGo?3`lobDU9oo5
aLOoi^KXomoNhooPgnCogmkSonSWk?nRXZCo0@41ob0P8?o<c<koi^GZomoNhooPgnCogmkSon;Qi_o=
cLooW9bNoifMWOoHf=[ohN3UomoNhooPgnCohN3UomWIfonNWYkoWIfOolc<c_oSh^L00_oOg^<02OoP
gnCojNS]okFd^Ol30`?oL71`ogEeMooEe=Woh^7Von3Oi002omoNh`03omcMh_ono_coEW^W007o03Ii
00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?Sok^k`
00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00So042000?o03moo`10P?l0@8000_l0
@8000ol0@WooKfJCooklk`0_onGUi@;ohn?S027ojn_[ogYjN_l0003ol?3`oi2@T?l0003oHf=Soooo
oolW9bOoCDe=olg=cOl0003o410@ohn?SomeMGGo0000ofYZJ_nb/[;o0000oi:BT_oooooo/k>co`00
0?mXJ6SoYZJVomkNg_m3@d?o@D51ohV9ROl0003oO7aloooooonPX:000_l000004_n4Q8CoooooooCd
m?m>CTko0000ogalO?ono_ko4a<Co`000?nQXJ7od];Bog=cLoooooooM7Adokbl_?o<c<coM7Adoo3`
l0;oj^[Z02Co_[jnodi>C_oTi>CoeMGEon3Ph?nj^[[oN7QhoooooooWinOoh^;RonCTi?oQhN7oHf=S
ocXj>_oFe]KojNWYolc<c?mbLW;oo_knogMgMonf][Kodm?CoeIFE_o1`L7ojNWYom[Jf_o:b/[ofm_K
oeUIFOoDe=Con?Shol?3`omRHV;oi^KVon;Rh_oShn<2onGUi@03onCTi?oUiNGoiNGU01ooiNGU00Co
i>CTonGUiOoUiNGoi>CT0ooUiND00ooooO3oLFREo`0kO@0Bo`10P008o`0gN_m2K9coo_kbomSIg_oN
gN;oh^7VomSGg?nJVIh2oiBCV004oiFDVOoAd=Goh^7Von3Oi0;ogmkS00goiNCYokjn`?mmOGoo10@6
omSGg?oRhNKogmkSon3Oi?oOg^?oi^GZok>c]Om:BTcoUIBI00?oh=oT017ogmkSon3Oi?oPgnCoUiJK
odY:C?nb/[Coi^KXomoNhooPgnCogmkSon?RiooCd]OoMGEgode=ComNGV3odm?EonCSj002on3Oi004
omoNhooLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool0
1Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00go
042000?o049oofmVTooooO00;?oUiND04_oTi>CoiNGUonGUiOoRh^;ohn?Son3Ph?lb<S;o>3Phoo;b
l_o4a<Co0000oi^KVoooooooPX:2o`000?oBd];o]KFeob/[:`;o000000OoKFe]onOWionn_[ko0000
oinOWooinOWo_;bl00;o000000co0`<3ojn_[omWIfOo10@4o`H61_mADE7ob<S8on_[jooDe=Co=SHf
o`<30oo4a<@2onSXj00doginO_l0003o^KViookno_mgMgOo0000ol71`OoJf][oATI6oe=CDon8R8So
h^;Rom?CdolX:2SoF5QHog1`L?oEeMGogmoOohN7QomSHf?oOWinomcLg?o;bl_o;Bd]oe]KFomcLg?o
e]KFonCTi?o/k>coWinOohF5QOoYjNWoiNGUomKFe_m4A4CoDE5AohJ6Q_oLg=cok>c/ok^k^omCDe?o
N7QhodU9BOnSXj?oh^;Rog5aLOoAdM7oj^[Zol?3`omhN7SoinOWon7Qh@;oi>CT:OoUiND01?oTi>Co
o_c_og5XUOl0>gdBo`10P008o`0gN_m2K9coo_kbomSIg_oMg>7ogmkSon7PiOoZjNh2onc[l003on_Z
kooRhNKogMcQ00;ogmkS00Ooh=oTomkMh_oXj>[oh^;TokNg^OoThnSog]gR00;ogmkS00Ooh=oTomkM
h_oYjN_ohN7Sojf//Oo=c=7oi>?X00;ogmkS00Ooi>?Xolg<dOn][;7oh^;TonWYjooNgN;oh=oT00;o
gmkS00Kog]gRonCSj?oKfmgoc<c>olg=cooMgMl2on3Oi005omoNhooNgN;og=gRookno?mFNjL00Ol0
=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooo_knooShn?o^
k_001?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/03Ol0@8000ol0@GkoKfJCooklk`0/
onGUi@0TonCTi?oUiNGoiNGUon?ShooRh^;oh>3Pom7AdOoIfMWohn?Son;Rh_oFe]KogmoOonGUiOoN
g]kod=3@omcLg?oZj^[ogmoOolG5aOo;bl_oi^KVonOWiooLg=codm?Com_KfooUiNGogMgMom;Bd_oA
dM7od];BomgMgOoGemOodM7Aom?CdooShn?oi^KV0_oRh^808?oHf=Soe=CDon;Rh_oQhN7ohn?Som[J
f_oDe=Coh>3PonCTi?oKfm_odM7Aon7QhOoRh^;odM7Aom3@d?oVi^Kohn?Son7QhOo@d=3oalO7olW9
bOoNg]koiNGUomkNg_no_koofMWIonCTi?oOgmooclo?olK6a_o;bl_og]kN0_oShn<00ooNg]kofMWI
on?Sh`02on;RhP0@om7AdOo?clooiNGUonCTi?oQhN7oj>SXom[Jf_nl_;cobLW9on?ShooRh^;ofMWI
on3Ph?oRh^;oh>3Pom[JfP;ohN7Q00Coi>CTonGUiOoUiNGoi>CT:?oUiND00ooooO3oLFREo`0kO@0B
o`10P004o`0gN_m2K9coo_kbomSIgP?ogmkS00?oh=oTomoNhooPgn@01?oOg^<02ooPgnCogmkSomoN
hooNgN;ohN3UonKUj_oOg^?og]gRon3Oi?oOg^?oh=oT00;ogmkS00?oh^7VonKUj_oRhNH01?oOg^<0
0ooRhNKoi^GZon7Qh`02omoNh`03on7PiOoOg^?ogmkS00;ogmkS00CohN3Uon?RiooSh^Ooh=oT0_oO
g^<01OoPgnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oo
oOh0lOooool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJ
LYKo0CQk00go042000?o049oofmVTooooO00:_oUiND00ooTi>CoiNGUonCTi002onCTi006on?ShooQ
hN7ohN7QonKVi_oTi>Coh^;R0ooShn<00ooRh^;ohn?SonKViP02on;RhP0:on?ShooWinOoinOWon;R
h_oQhN7ohn?SonGUiOoShn?oh^;Ron?Sh`;oi^KV00?oiNGUon?ShooTi>@00_oVi^H2on;RhP05on7Q
hOoRh^;oiNGUonGUiOoShn<00_oRh^801_oShn?oiNGUon?ShooPh>3oi>CTonKViP;oh^;R0_oUiND0
1ooQhN7oh^;Ron;Rh_oVi^KoiNGUonKVi_oQhN400_oRh^801OoWinOohn?Son;Rh_oRh^;oi^KV00;o
iNGU00Goh^;Ron7QhOoRh^;ohn?SonCTi003on;RhP04onGUiOoTi>Coh^;Ron;RhP;ohN7Q00?oi>CT
onOWiooUiND00_oRh^800ooTi>Coh^;Ron;RhP02on?Sh`03on7QhOoRh^;oi>CT00;oi>CT00?oi^KV
onCTi?oUiND07ooUiND00ooTi>CoiNGUonCTi003onCTi004onGUiOono>ooLFREo`0kOA;o042000Co
03Mjod9/W?ono_;of=WN0_oOg^<02OoPgnCogmkSon7PiOoOg^?oh=oTomoNhooNgN;oh=oTomoNh`03
on3Oi0;ogmkS00Soh=oTomoNhooOg^?ogmkSomkMh_oPgnCogmkSon3Oi0OogmkS00Coh=oTomoNhooO
g^?oh=oT0ooOg^<00ooPgnCogmoQomoNh`02omoNh`;oh=oT0_oOg^<01?oNgN;og=gRookno?mFNjL1
o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_kon?Sh
onk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`0=o`10P003o`12Oom_IY?oo_c_
02goiNGU00Ooi>CTonGUiOoTi>Coi>CTonGUiOoShn?oi>CT00;ohn?S0ooTi>@01?oShn?oi>CTonCT
i?oShn<2onCTi0;ohn?S00GoiNGUon?ShooUiNGoiNGUon?Sh`02onCTi005on?ShooTi>Coi>CTonCT
i?oShn<00_oTi>@01?oShn?oi>CTon?ShooShn<5onCTi003on?ShooTi>Coi>CT00;ohn?S0ooTi>@0
1?oShn?oiNGUon?ShooShn<4onCTi003on?ShooTi>Coi>CT00?oi>CT00Cohn?SonCTi?oTi>Coi>CT
0_oShn<01OoTi>Cohn?SonCTi?oTi>Cohn?S00?oi>CT00?ohn?SonCTi?oTi>@00ooTi>@2on?Sh`04
onGUiOoRh^;oi>CTon?Sh`;oi>CT00Gohn?SonGUiOoUiNGoiNGUon?Sh`0QonGUi@04onCTi?oUiNGo
i>CTonCTi0;oiNGU00Coi>CTooklkomaJ9Go03]m4_l0@8001?l0=g[o@VbLooknl_oHfMh3omoNh`05
on3Oi?oOg^?oh=oTomoNhooPgn@00_oOg^<00ooPgnCogmkSomoNh`02omoNh`;oh=oT0_oOg^<00ooO
gn7oh=oTomoNh`02omoNh`03on3Oi?oOg^?ogmkS00KogmkS00?oh=oTomkMh_oOg^<00_oPgn@4omoN
h`09on7PiOoOg^?ogmkSon3Oi?oOg^?og]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7R
i_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_
lOohm_Oo[:^iokjka_mJLYKo0CQk00go042000?o045nofmVUOoooO00;OoUiND02_oTi>CoiNGUonCT
i?oVi^Kohn?SonGUiOoTi>CoiNGUonCTi?oUiND2onCTi0;oiNGU00Goi>CTonGUiOoTi>Coi>CTonGU
i@02onCTi0;oiNGU0ooTi>@01_oUiNGoi>CTonGUiOoTi>Coi^KVonGUi@;oi>CT00CoiNGUonCTi?oT
i>CoiNGU0_oTi>@2onGUi@03onCTi?oUiNGoi>CT00;oiNGU0_oTi>@00ooUiNGoi>CTonGUi@02onGU
i@;oi>CT00?oiNGUonCTi?oUiND01?oTi>@00ooUiNGoi>CTonGUi@02onGUi@03onCTi?oUiNGoiNGU
00;oiNGU00Woi>CTonGUiOoUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiND00ooTi>@2onGUi@04on?S
hooUiNGoiNGUonGUi@;oi>CT00?oi^KVonGUiOoTi>@00_oUiND00ooTi>CoiNGUonGUi@0NonGUi@0:
onCTi?oUiNGoi>CTonCTi?oUiNGoi>CTonGUiOoooO3oLFREo`0kOA;o042000Go03Mjod9/W?ono_;o
f=WNomkMhP02omoNh`03on3Oi?oOg^?oh=oT00;ogmkS0_oPgn@2omoNh`03on3Oi?oOg^?oh=oT00;o
gmkS00Goh=oTomoNhooOg^?ogmkSon3Oi009omoNh`;oh=oT00?og]gRon3Oi?oOg^<00ooOg^<2on3O
i004omoNhooNgN;oh=oTon3Oi0?ogmkS00?og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;V
ookno_ooooooo_knooomoP3aooooo`05ookno_ooooooo_knooShn?o^k_001?o_ko401oo`k_7oknoa
ooSfmon/ZkWo_[_6oeYbU_l1>7/02_l0@8001_l0@Woo041no`10P?l0@WooKfJEookll2goiNGU00Ko
i>CTonGUiOoUiNGoiNGUonKVi_oTi>@3onGUi@07onCTi?oUiNGoiNGUonGUiOoTi>CoiNGUonCTi002
onGUi@04onCTi?oUiNGoiNGUonCTi0?oiNGU0ooTi>@2onGUi@03onCTi?oUiNGoiNGU00;oi>CT0_oU
iND2onCTi005onGUiOoTi>Coi>CTonGUiOoTi>@00_oUiND01OoTi>CoiNGUonGUiOoUiNGoi>CT00?o
iNGU00?oi>CTonGUiOoUiND00_oUiND00ooTi>CoiNGUonCTi003onGUi@03onCTi?oUiNGoiNGU00;o
iNGU00?oi>CTonGUiOoUiND00ooUiND01?oTi>Coi^KVonGUiOoTi>@5onGUi@;oi>CT00Coi^KVonGU
iOoTi>CoiNGU0_oTi>@01_oShn?oiNGUonCTi?oUiNGoi^KVonCTi23oiNGU00Goi>CTonCTh_oUiNGo
iNGUonCTi002onGUi@03ookll?maJ9Go03]m01;o042000Go03Mjod9/W?ono_;of=WNomoNh`02on3O
i003omoNhooPgnCogmkS00;oh=oT0_oOg^<03?oPgnCogmkSomoNhooNgN;oiNCYon7PiOoOg^?og]gR
on3Oi?oOg^?oh=oTomkMhP;oh=oT00?ogmkSon3Oi?oOg^<00ooOg^<4on3Oi007omoNhooPgnCogmkS
on3Oi?oOg^?oh=oTomoNh`02on3Oi008omoNhooPgnCoh=oTomoNhooNgN;og=gRookno?mFNjL1o`0f
N@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^
l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`0:o`10P006o`12Ool0@7ko041no`11
POm]I9?on?KZ:_oShn<01?oRh^;ohn?Son?ShooRh^83on?Sh`?oh^;R1OoShn<01?oRh^;ohn?Son?S
hooShn<3on;RhP?ohn?S0_oRh^88on?Sh`03on;Rh_oShn?ohn?S00?oh^;R1_oShn<00ooRh^;ohn?S
on?Sh`02on?Sh`0Don;Rh_oShn?oh^;Ron;Rh_oShn?oh^;Ron?ShooRh^;ohn?Son;Rh_oShn?oh^;R
on?ShooRh^;ohn?Son;Rh_oShn?oh^;Ron?ShooRh^83on?Sh`05on;Rh_oShn?oh^;Ron?ShooRh^80
1?oShn<2on;RhP07on?ShooRh^;oh^;Ron?ShooRh^;ohn?Son;RhP02on?Sh`03on;Rh_oShn?oh^;R
00;ohn?S00?oh^;Ron?ShooShn<08?oShn<02OoRh^3ohn?Son;Rh?oRh^;ohn?Son;Rh_ohm^[oLFRE
o`0kO@0Bo`10P006o`0gN_m2K9coo_kbomSIg_oOg^?oh=oT0_oOg^<01?oSh^Ooi^GZon7PiOoOg^<2
on3Oi0;ogmkS00Goh=oTon?Rioo4a<Kodm?Eon7Pi@05omoNh`04on?RiooViN[ohN3Uon3Oi0KogmkS
00?ohN3UonCSj?oOg^<00ooOg^<01_oPgnCogmkSon3Oi?oOg^?oh=oTonGTj@;ogmkS00Goh=oTomkM
h_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Go
o_knooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`08o`10
P0;o041n00Ko0D61o`0oOol1@H7o045nog=ZUoomo_TTong]k@?ok>c/00?okNg]onc/k?o/k>`00oo]
kNd2onc/k8;okNg]00Wok>c/ong]kOo/k>cokNg]onc/k?o/k>[oo_ojogI]V_l0>W`01?l0@8000ol0
?goo0420o`10P00;o`10P00=o`0gN_m2K9coo_kbomSIg_oNgN;oh=oTon;Qi_oCd]OoW9bNol71`onO
Wj7oi>CVon3Oi004omoNh`06onGTjOo6a/Soe=CFon;Qi_oOg^?oh=oT0_oOg^<01?oQh>Gobl_=olG5
aooGe]/3on3Oi007omoNhooPgnCohN3Uon[Yk_n[Zjgo^[ZlonGTj@02omoNh`08on3Oi?oQh>GoZJR]
omWIfoo[jngo[:b^okNg^OoThnP3omoNh`03omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7R
i_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_
lOohm_Oo[:^iokjka_mJLYKo0CQk00go042000?o049oogU`Woooood08Oooool2ooknoP;ooooo00?o
o_knooooooooool0S?ooool01_ono_koooooookno?oooogoO7>Po`4lOQ;o042000go03Mjod9/W?on
o_;of=WNomoNhooNgN;oh=oTonOVjonQXJ?o820RolW9booTi>KogmkS00;oh=oT02;ogmkSonOVjonX
YjcoAdM9oe9BE?o<bm3oiNCYomoNhooPgnCog]gRonWXkOnMWIoo6QXLom3?e?oThnSogmkSomkMh_oP
gnCoiNCYoifLXOm<Be3o<c<eo`000_oFeM[oi>?Xon3Oi?oOg^?oh=oTonKUj_nNWZ3oBd]=ob8R9?m4
A4Kok>_`0ooOg^<00ooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_ko
oogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKo
FW:Fo`4hN`09o`10P007o`51POl0@83o0420o`0oOol0@GkoNW6Pookno00@ooknoPSooooo2?ono_h0
0oooooooo_knooknoP02ooooo`;oo_kn2Ooooon0ooknoP;ooooo00[oo_knooooooono_koo_knoooo
ooono_koO7>Po`0jO?l0@83o0D614?l0@8003_l0=g[o@VbLooknl_oHfMkog]gRon3Oi?oRhNKoeMCI
oiFEUonYZJ_oWinQonCTi_oPgnCog]gR0ooPgn@03OoLfn3oXZ:TokVi^ooQh>Goh=oTomoNhooQh>Go
hn;Wom3?e?nATI?o/k>eomCCf?oQh>D00ooOg^<01_oPgnCoe]GJomCCf?nEUIOoW9bNon?Ri`?oh=oT
00gohN3Uojf//Oo=cLooe]KHoiJFV?nQXJ?oinK[omoNhooPgnCog]gRomcMh_ono_coEW^W007o03Ii
00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?Sok^k`
00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00go042000?o0461ogU_XOooool04?on
o_h8ooooo`Soo_kn1?ooool3ooknoP03ooooooono_koo_kn00KoooooPOono_h4ooooo`;oo_kn00?o
ooooog]bWol0>W`04_l0@8002ol0=g[o@VbLooknl_oHfMkog]gRomoNhooPgnCog=_Pom[Ig_oWinWo
emOI00;ogmkS013oh=oTomoNhooNgN;ogmkSon;Qi_oIfM_ogMgOon3Oi?oOg^?oh=oTomkMh_oQh>Go
f]WNomcLg_oXj>[ohN3U0ooPgn@2omoNh`07on7PiOoSh^Oof][Lon?SiOoQh>GogmkSon3Oi002omoN
h`06omGDfOoOg^?oh^;Tom[Jg?oSh^Oog]gR0_oOg^<01?oNgN;og=gRookno?mFNjL1o`0fN@0000Oo
ZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_
l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`09o`10P007o`0oOol0@83o0420o`10P?l0@Woo
NFnQooooo`0@ooknoP?ooooo00?oo_knooooooooool00_ooool8ooknoP?ooooo0oono_h3ooooo`;o
o_kn0_ooool2ooknoP03ooooooono_koo_kn083oo_kn0_ooool01_ono_koooooooooooono_koO7>P
o`0jO1;o042000Co03Mjod9/W?ono_;of=WN0_oOg^<2on3Oi0?ohN3U00?oh=oTomoNhooPgn@00ooP
gn@03?oOg^?oh^7Von3Oi?oOg^?oh=oTomoNhooPgnCogmkSon3Oi?oRhNKogmkSon3Oi0;ogmkS0ooP
gn@01OoOg^?oh=oTon7PiOoPgnCogmkS00Coh=oT00GohN3Uon3Oi?oPgnCohN3Uon3Oi004omoNh`03
omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oon
o_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00Wo0420
00Ko041no`10P?l0@83o03moo`11O_mjLJ0BooknoPCooooo3Oono_h01?ooooooo_knookno_ono_h3
oooooh[oo_kn00?oooooookno_ono_h00_ooool00omlLj3o03Ylo`10P00Ao`10P008o`0gN_m2K9co
o_kbomSIg_oNgN;oh=oTomoNhooPgn@2omoNh`;oh=oT0ooOg^<2on3Oi003omoNhooPgnCoh=oT00;o
gmkS00Coh=oTomoNhooNgN;ohN3U1?oOg^<02?oQh>GogmkSomoNhooOg^?ohN3UomoNhooNgN;oh=oT
0_oOg^<00ooPgnCog]gRon3Oi003omoNh`;oh=oT00Oog]gRomoNhooOg^?ogmkSomcMh_ono_coEW^W
007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_oh
n?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00go042000?o045nog]bXOoo
ool08?ooool01?ono_koooooooooooono_h2ooooo`Coo_kn0_ooool01?ono_koooooooooooono_j0
ooooo`03ookno_ooooooo_kn00Cooooo00?oo_knogacX?l0>W`04_l0@8001?l0=g[o@VbLooknl_oH
fMh2omoNh`04on3Oi?oOg^?oh=oTon3Oi0;ogmkS00Goh=oTomoNhooPgnCogmkSon3Oi003omoNh`03
on3Oi?oOg^?ogmkS00;oh=oT00CogmkSon3Oi?oPgnCoh=oT0_oOg^<00ooPgnCogmkSon3Oi003omoN
h`06on3Oi?oOg^?oh=oTomoNhooQh>Gog]gR0_oOg^<02_oPgnCogmkSomoNhooPgnCogmkSon3Oi?oN
gN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Go
o_knooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`0=o`10
P003o`11O_miL9ooooom013ooooo00OooOgmooclo?olo?cono_kooclo?omoOgoo_kn00cooooo00Oo
o_knoooooooooooooOgmooclo?okno_oo_kn00;ooooo00?oo_knooooooooool0Q?ooool3ooknoP;o
oooo00CoO7>Po`0jO?l0@83o03mo4?l0@8002?l0=g[o@VbLooknl_oHfMkogmkSon3Oi?oOg^?oh=oT
0ooOg^<3on3Oi004omkMh_oPgnCog]gRon3Oi0?ogmkS00?oh=oTomoNhooOg^<01?oOg^<00ooPgnCo
gmkSomoNh`02omoNh`;oh=oT0ooOg^<01?oPgnCogmkSon3Oi?oOg^<3on3Oi0;ogmkS0_oPgn@01_oO
g^?oh=oTomkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0
lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`09o`10
P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP09ooooo`05ookno_ooooooooooooooooono_h0
0_ooool06_o_knood];BomKFe_oHf=Soe]KFoo7alOono_koooooookoooonoO_ooOchooknoooooo_o
ookloo_mo?ooooooi<^eoo;TfOoooOkoooomoogoo_ono?gonoolooK]i_oJ^I[on_7X0_onool00oon
o_koo?ghooomo`02ookoo`0gooonoooooooooOchooomooono_cooooooognoooooooooognoooooOoo
ooooo_knoooooOooo_ooooooookno?omo?[oookoookoooomoO_ooOgmoognooomookoookooogmoOoo
oogooOkoookno_olnoWoooklooomo_olnoOoo_goookno_onn_Woooooookno?oono[ooockooojo?on
o_cooOkoooomooomookooOgkookon_omo?[ooOononoVeOoWc[[oo_koooono?omoocoooooooomoP1@
ooooo`03ogibX?l0>Wco042000ko042000Oo041no`10P?l0@83o03Mjod9/W?ono_;of=WN00;ogmkS
00Koh>3RomoNhooPgnCogmkSon3Oi?oPh>85omoNh`06on3Oi?oOg^?ogmkSomoNhooPgnCogmkS0_oO
gn45omoNh`0;on3Oi?oOg^?oh=oTon3Oi?oOg^?oh=oTomoNhooPgnCogmkSon3Ph_oOgn400ooOg^<0
1_oNgN;oh=oTomoNhooPgnCogmkSon3Oi0;ogmkS00?og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nR
Y;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Ooh
m_Oo[:^iokjka_mJLYKo03Qk00Wo042000Oo03n2o`10O_l0@83o0420o`11POmjLIkoo_kn00[ooooo
00Coo_knoooooooooooooooo0_ono_h0F?obl_;on?Shon?Shon;Rh_oe]KFooOgmoooooooo_knoo_j
m_oD[fSodZ]Xoo7UfOodimooiM2komVkVOo/e/Wogl6WolZNAooYelWolN?Hon75[ooE/XcoeJZ8onSF
`_oE/i3ogL:Wooooooono_kolNCDomFeQ?oL_:?oo?kkonOE`OoM`:3om^cRomk4[OoL_iooooomookm
nooN_j;oiLbfon38/?oVdKcok]_=onoOcooVdKkokmoBon_Kc_o[f<OocZUKon;;^OofjnGoe;67omfn
XOo]flgoek2?onoSeooD/7Koo?WdookooOo/fL[od:QPombmW_objN3oek9^ooObk?oooOoog;^Hon79
/Oo_h];of;JJomNiUoo@ZFkojm[:onOB_ooklo3oj]W9omZoXOo_hMKoeJn0omZlV_o_gm3oc9Y1omFb
S?oZg<ooo_ooooomo?onoom@ooooo`03ogibX?l0>Wco042000ko042000_o041no`10P?l0@83o03Mj
od9/W?ono_;of=WNomkMh_oPgnCogmkSon;QiP02onGTj@04on3Oi?oOg^?ogmkSon3Oi0?ogmkS00Co
hN3UonGTjOoTi>Koh=oT0_oOg^<04?oPgnCogmkSomoNhooPgnCoi^GZonSXj_oQh>GogmkSon7PiOoO
g^?og]gRonKUj_o[j^ooiNCYonOVjooRhNH5omoNh`0;omkMh_oPgnCoh=oTomoNhooPgnCogmkSon3O
i?oNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aoooo
o`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo042000Oo
03n2o`10O_l0@83o0420o`11POmjLIkoo_kn00[ooooo00Coo_knoooooooooooooooo0_ono_h0F?oe
mOGok^k^og=cLomEEEGoT92@ooCdm?ono_koooooooW`iooF]iSom>_TomFgToo[eLOog;^LomF_Roo/
flWoh<J_on77[?oJ_9[oj=K0om^nX?oK^j;obiaTom:/QooBZh;oe:j9ookmnoono_koiM2konOA_?oJ
]iWom^oYomfoXoo@Xf;ok^GLomZkW?oM_jGoo_knookloOo=X4oocJ9[olRJCOoG^IOoh/Raon[C`ooJ
^ikoi<jfon?;/OoN_j?oh<R^omk4ZOoQajkoiLnhon77/?o:VU;obiiUoljWO?o:T3colNCDookoooo_
gm;od:Q]olnWM_oZelKohLN^oooooOomn_?oeJiconO?]ooScKSokMO9on??]oo8USgohlReom^nW_oe
kn?oh/B/oo3Tf?oUck[oh/RaomfjW_oYf<Kog;ZNongLb_oG]X_oooomooooooono_i@ooooo`03ogib
X?l0>Wco042000ko042001Wo041no`10P?l0@83o03Mjod9/W?ono_;of=WNomkMh_oOg^?oinK[ojVX
[On^[[3oEUIHolg=cooSh^Ooh=oTomoNhooQh>GogmkSon7PiOoRh^CoUIFGoahN7_o@d=;ohn;W00;o
h=oT00oogmkSon?RiooBdMKo7alQof1PH_oNg^3oh^7VomoNhooPgnCoh^7Vol?3aOnRXZCob<O<okBc
^?oNgN800_oPgn@00ooOg^?oh=oTomoNh`03omoNh`08on3Oi?oOg^?ogmkSomoNhooNgN;og=gRookn
o?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooo
oooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/02Ol0@8001ol0?h;o041no`10P?l0
@83o0461ogYaW_ono_h02_ooool2ooknoP;ooooo00Soo_knoogmoOohn?Soi>CTojFUYOoemOGoTI6A
okBd]0;ooooo04oon?3]omZiV_ojln_oek>AonkRe_oOa:Koe:mjooC]iOoSc[WocZMLonWD`OoXdl3o
j=?2on_Jb?oC[h_of[VJonKA_?oSbk7omN_RoooooooG[gcocZ^1om:XP?oB[8Gof[bPon;7[?oaimgo
eZiaonWD_oomoOgolnWMon75[OoJ^ioog;nQonG=]OoQaJgol>CHomVfU_oAZVWoknKGonSF`_o=Y6Co
gKjOoo?YgooC[X;of;JJomReVOoUdkgod:]gon_Jb_oUckSoookoooWdk_oM_9_oh/J`om^hV_o=TCWo
oO_looSglooBZE[olMgBom:ZKooD/Xook^;Dom>`R?o_iMWog/>XomJeT_o9T3KogL:UonWG`oo^gLgo
i/fgonkRe?o?Yf7odZidonSGaOooooooo_ko057ooooo00?oOW:Po`0jO?l0@8003_l0@8006Ol0@7ko
0420o`10P?l0=g[o@VbLooknl_oHfMkog]gRon3Oi?oThnWob/W>of9RI?mbLW;ohN7Son7PiOoOg^?o
h=oTomoNhooPgnCoi>?XolO7bOm>CU3oIfMWon7QhooRhNH00ooOg^<01_oViN[o`<32ofa/K?m<C4ko
cLg?onCSj0;ogmkS00koinK[odQ8B_mlO7ko?3`noginP?nATI?oj>SZomkMh_oPgnCogmkSon3Oi?oQ
h>Goh^7Von3Oi0;ogmkS00Koh=oTomkMh_oOg^?og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQ
h^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/
ZkWo_[_6oeYbU_l0>7/02Ol0@8001ol0?h;o041no`10P?l0@83o0461ogYaW_ono_h02_ooool2ookn
oP;ooooo00?oo_knoogmoOo^k^h00_obl_80A_ojn_[oe=CDodA4A?oYjNWoooooooSilooBZE[ocZUI
onWHb?oil>Wol^KJoogmoOomo?[oooglooOgmOoooOooiLfeonGA^Oooo_coo?SeookmnOoooooooOki
oogoo?ono_kokMk;onoNc_oG]YGomNcUoooooooah=Komo;/ookno?oin_Coo_ooookloOomoO_ooooo
ookno?ooooool^CGooG^i?omo_oonoOdooomooooo_ook^3ComRhTOoooOkoo?Seoogin?oono[oookl
ooknooono_coo_cmookno_ono_oomoSbooooooo`h]OojMS6ooonoooloogono[hoo_oo_oZfLWol>3A
ooomo_olmo@2ookno`0:oogln_oYe<7olNGGooooooono_ooo_kloooooookn_Soo?Oaoogmn`;oooko
00?oo_okooooooooool0C_ooool00omnLZ3o03Ylo`10P00>o`10P007o`10O_l0@83o0420o`0gN_m2
K9coo_kbomSIgP02omoNh`07onKUjong][_oE5AFoa4A4OnSXjGojNS]omoNh`03on3Oi007on7PiOoL
g=koOGeoo`000?n5QHOoi^GZon3Oi002omoNh`06on?RiooDe=KoJf][oda<C_ng]kWoj>O/0_oOg^<0
1ooViN[oY:BVoh20P_n5QHOoHF5Sode=CooYjN/00ooOg^<03?oQh>GogMcQomOFfooRhNKogmkSon3O
i?oNgN;oh=oTomoNhooLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oo
oOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`09
o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP0:ooooo`04ookno_ooooooooooooooo`;o
o_kn013ok^k^on;Rh_oShn?ohN7Qon_[jonLW9coU9BDookno_ooo_oonOK_ooObk?ooo_coo?[moo[h
nOooooooookl0_ooool0AOono_ool^WPoo?Yh?onoooooOonooomo_ono_koo_omooomooooo_oooOol
ooknooo_g/koo?Sgookno?ojnOOooo_jookoooooo_ooo_ooookooOono_koo_klookooOono_oon_[h
oogln_ooooooookooognooooo_con_GaongOd_ooo_oooooooooooOolooooooomooonoooooOkoooko
ookno?oooo_ooooooogoo_oooo_oooklooooooooo_coo_ooooonoooooogooognookoooomookoooom
ooono?onooooooklooonooooooooo_omoo_oo_ooo_ooooooookno_ooo_ooo_klooomo`1Aooooo`03
ogibX?l0>Wco042000ko042002;o041no`10P?l0@83o03Mjod9/W?ono_;of=WNomkMh_oOg^?ohn;W
olk=d_n2PXCoIVIXoinOXOoViN[oh=oTomoNhooPgnCogmkSon3Oi?oThnSofMWKoh20P_nEUIOoi>?X
on3Oi?oOg^?oh=oTon7PiOoLfn3oOWj0odQ8B_oAdM?ohn;W0ooPgn@03_oShnGoc/k@onSWk?o:bLko
emKKon3Oi?oOg^?oh=oTomoNhooWi^_oViZOocLf>ooJfMkoh^7V0_oOg^<01OoPgnCogMcQomcMh_on
o_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_kooooo
ooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`09o`10P007o`0oP_l0@7ko0420
o`10P?l0@H7oNW6NooknoP0:ooooo`04ookno_ooooooooooooooo`;oo_kn00Soooooookno_ono_ko
o_knooooooobl_;o>SXjolW9b@;oo_ko00Soooooooknoooooo_onoonoocnoOoooogoo_knookno0;o
oooo00_oo_omooomo_ooo_ooo_kloooooOoooOooookmoogoo?oooooooOonoogno`02ooooo`06ookn
o_ooo_[ooognoognooooo_ooo_kn0_ooool03Oono_koookooogoo_ooo_ooo_knookno?ooooooo_ko
ookoooono_koooomooglooooood00_ooool01oomoocoooooooonoooooooooOkoooooooooood00_oo
ool03Ookookoo_knoooonoono_koookooooooOonooooooooooomooomo_oooookooomooooool01?oo
o_l01_onoogoo_kloo_ooooooogooooooogoo53ooooo00?oOW:Po`0jO?l0@8003_l0@8001ol0@7ko
0420o`10P?l0=g[o@VbLooknl_oHfMh00ooOg^<01OoRhNKok>_`onk]l_oXincog]gR00CogmkS00ko
h=oTomoNhooQh>GokNg_on[Yk_oNgN;ogmkSon3Oi?oNgN;oh=oTon;Qi_oPgnCo_[k0onOVj`CogmkS
00Ooh=oTon;Qi_oPgnCoi>?Xon;Qi_oOg^?oh=oT00;ogmkS00Goi>?Xol2oa?nXYjcohN3Uon3Oi002
omoNh`05on3Oi?oNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_kn
ooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk
00Wo042000Oo03n2o`10O_l0@83o0420o`11POmjLIkoo_kn00Wooooo00Goo_knoooooooooooooooo
ooknoP05ooooo`;oo_kn00Woooooom?CdooDe=CoooomookooooooOoooOonoooooOooo_l00oooool0
?OoooOkooOkoooknooono_cooogoooonoookoocoo_knoooooookoocoooooooolnoooo_oooOoloooo
oOoooOkoo_omoognoooooogonooloooooooooo_ooOkooooooOooo_ooooomoooooooooOkoo_oooooo
ooono_koo_omooomo_ooo_ooo_ojookno_ono_ooo_klookno_ooooooo_knoogoo_ono_koooomooom
o_ooo_ooo_ooookno_ono_ooooooookno?omookoo_knookooOoooOooooomookno_ooo_oooOkooooo
oOomooh00_ooood01OoooooooOonoooooooooooooook00;oo_knDOooool00omnLZ3o03Ylo`10P00>
o`10P00:o`10O_l0@83o0420o`0gN_m2K9coo_kbomSIg_oPgnCoh^7Von7Qh`;ohN3U00?oh^7Von7P
iOoRh^@00_oQh>D2on7Qh`04on3Oi?oRhNKohN3Uon;QiP?ohN3U0_oQhN<01?oRhNKohN3Uon?RiooV
iNX2on7Pi@;oh^7V00?ohN3Uon;Qi_oQh>D00ooQh>D2on7Qh`05on7PiOoRhNKohN3UonKUj_oYj>d0
0ooQh>D01_oRhNKogmkSomkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_kooooo
ookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:F
o`0hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP2hooooo`03ogibX?l0>Wco0420
00ko042000Oo041no`51POl0@83o03Mjod=]WOono_;oe]OL00;od]7F0_oCd]L01ooBdMKodm;Gom?B
eooBdMKodm?Eom;Be?oCd]L00ooBdMH01ooCd]Ood]7Fom?BeooBdMKodm;Gom;Ae_oCd]L00ooBdMH2
om?Be`04om;Ae_oCd]Oodm;Gom;AeP;odm;G00Cod]7Fom?BeooBd]Cod];D0ooCd]L03?oCdmGod];D
om?BeooBdMKodm;Gom;Be?oDdmSogMcQomkMhooLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7R
i_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[
^Onn^lKoFW:Fo`0hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP2hooooo`03ogib
X?l0>Wco042000ko042000_o0D5oo`0oOol1@H7o03Mjod9/W?ono_;oa/O<oe5ADOm7AdOoCdm?oe9B
DP02oe=CD`05oe9BD_mADDooDU9@oe=CDOmADE400omCDe<00omBDU;oDe=Coe9DD`02oe5CDP03oe5C
D?m@DTooDUAA00;oDE=B2OmBDU02oe9BDP0@oe=CDomBDU3oDe=Aoe5ADOmBDU;oDe=Coe5ADomBDUCo
D51BodE5AOmADE?ocloAon;Ri?oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_kooooo
ookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:F
o`0hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP2hooooo`03ogibX?l0>Wco0420
00ko042000Wo041no`51POl0@83o03Mjod9/W?ono_;of=WNon3Oi?oQh>D00_oRhNH5on7Pi@?oh^7V
00?ohN3Uon;Qi_oQh>D00_oRhNH3on7Pi@;oh^7V00?ohN3Uon;Qi_oQh>D00_oRhNH4on7Pi@;oh^7V
00?oh=oTon7QhooQhN<00_oQh>D00ooRhNKohN7Son7Pi@05on7Pi@05on3Oi?oNgN;og=gRookno?mF
NjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oooooooooo
ooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo042000Oo03n2o`10O_l0@83o0420
o`11POmjLIkoo_kn0;Sooooo00?oOW:Po`0jO?l0@8003_l0@8008?l0@7ko0D61o`0oOol0=g[o@ffM
ooknl_oHfMkog]gRon3Oi?oOg^?oh=oTomoNhooPgnCogmkSomkMh_oPgnCogmkSon7PiOoYjN_ojn_]
onCTi_oWinWojn[_onKVj?oNg^3oh>3RomoOhOoPgnCogmkSon3Oi?oOg^?oh>3R0_oOgn43on3PhP;o
gmoQ00Wog]gSon3Oi?oOgn7ogmkSon3OiOoOg^CogmkSomoOhOoPgn@00_oOg^<00ooPgnCogmkSon3O
i002omoNh`03omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0
lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`09o`10
P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP2hooooo`03ogibX?l0>Wco042000ko042000So
03mmo`0oOol1@H7o0CQkod5[Voono_;of=WNomkMhP;oh=oT00?og]gRon3Oi?oOg^<00_oOg^<03OoS
h^OoinK[om[Ig_n^[K;oYZJXolW9bonh]kcoXj:WolG4bOoXincoh=oTomoNhooPgn@00ooOg^<00ooP
gnCogmkSon3Oi005omoNh`0=on3Ph_oOg^?oj>O/onSWk?oQhN?ogmoQon7QhooXincoinK[omoNhooP
gnCog]gRon3Oi002omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_ko
ooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKo
FW:Fo`0hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP2hooooo`03ogibX?l0>Wco
042000go042000ko03moo`10O_l1@H7o03moo`0gN_m3KIgoo_kbomSIg_oNgN;oh=oTomoNhooPgnCo
gmkSomkMhP;oh=oT00_oemOIojNWZOn][JooA4A6oh:2Q?mOGf7oI6AVohj>T?l000;o][JhonKVj002
omoNh`05on3Oi?oOg^?oh=oTomoNhooPgn@01?oOg^<03?oPgnCogmkSon3Oi?oOg^?o_Kc1okFd^OoK
f]ooj^W^omOFfond/kSo_Kc1on7Pi@;oh=oT00OogmkSomkMh_oOg^?ogmkSomcMh_ono_coEW^W007o
03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?So
k^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7o
NW6NooknoP2hooooo`03ogibX?l0>Wco042000go042001co0D61o`10O_l0@83o0420o`0gN_m2K9co
ooocomOHgOoNgN;oh=oTomoNhooPgnCoh=kSon3Oi?oOg^?oj^W^oi^KWOnNWZ3o]kNioginP?nc/kGo
H61RogYjO?o0`<;oDU=EogAeMooFem_ogn3T0_oNgn<00ooOh>Cog]oSon3Oi003omoNh`0?on3Oi?oO
g^?oh=oTon3Oi?oThnSodM7Co`h>3_lG5aOo]kNiol?2aoo9bL_o3Ph>o`D51Oo@d=;oi>CV00;ogmoQ
00Koh>3RomoOhOoNg^3og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_ko
oogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0
2Ol0@8001ol0?h;o041no`10P?l0@83o0461ogYaW_ono_h0^?ooool00omnLZ3o03Ylo`10P00>o`10
P008o`10O_l0@83o0420o`0gN_m3KIgoo_kbomSIg_oOgn42omoNh`0Aon3Oi?oPg^?oh=kSon3Oi?oJ
fMkoD51BomkNh?o>c]3oO7anogQhN_nSXjGoRh^=ogIfN?nVYZSoVi^MoijMX_oZjNh00_oPgn@00ooO
g^?oh=oTomoNh`02on3Oi0?ogmkS00kojNS]oo3_m?oooooocLg?ofUYJomlO7koIfMYoeEEEonQXJ?o
SHf?ofUYJoo:bLkohn;Won3Oi0;ogmkS0_oNgN800ooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T
/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_l@07oo3^
lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6Nookn
oP0@ooooo`0Googoo_ooooooooomooonooomookoo_kooooonoooooooooomooonooooooooo_kooogo
n_onooooo_kooooooOoooOkooogoon?9/?oajMkoo_koookoooomooh00_ono_h2ooono`03oogoo_on
o_ooookl00;oooom00?oo_knookoooomo_l00_ooo_l02OoooOkooOonookno?ono_koookloooooOon
o_kooOolooono`0Jooooo`05ooonooono_koooooookno?oooOh01?ooool02oonoooooognoooooOom
oocoooomookoooooooooo_knoocooooooogooOko00;oooom00Coo_koooonooooo_oooOon0_ooood0
7oooo_coookoookno_oooo_oookooocoooomoocoo_kloo_oooooo_ooooklooonooomookoookooooo
ooooo_oooooooogoo_ooooooookooooooOooooooookloooooOono_ooooooookno?ono_koo_oooogo
o?ooo_l00_ooool02ooooOooo?ooooooooooo_coo_knoooooOooo_ooo_knoooooOooo_oooOon01So
oooo00?oOW:Po`0jO?l0@8004Ol0@8001?l0=g[o@VbLooknl_oHfMh3omoNh`?oh=oT00kohN3UomWH
gOmBDU;og=cNon;Qi_o]k?;ojn[_onWXkOo[j^oojn[`ooknoonJVYcoVi^Monc/kPSogmkS01Ooh=oT
onKVj?nPX:;oKFe]oh>3Poo2`/CoJVY/ogIfN?mUIFOoFEUKoj2PX_n7QhWoIFEWolc<c_oThnSogmkS
on3Oi?oOg^?oh=oTomoNhooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooon
o_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn
^lKoFW:Fo`4hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP0@ooooo`0@oooooOon
o_kooOkiooono?ooooooo_koookno_oooooonOGbonkPdoono_com>KKooW`jookm_;oglN]on_Fa@;o
m>gU01kocjQoomJ[R?oUckSoo__fooomo_olo?[oj=W4on38[_objn?onO3Woo7Wfoono_kol>3Aom^k
X_ocjN3oookoonkRe?odj=comO;[on[Gb?olnoWoi/Zdon;9]OomnocolNSIon30ZOobi][ol^GLoo[c
kOoooo/Iooooo`17ookno_ooooooooooooooooono_koooooookmnOono_cooOonooonooonooooooko
oooloooZf/[ol^WRoocgm?oWdk_ooOWfooK]i_ocjN3omOK`oo;TfOobj=cogl>[on_KboomnOSojM_>
onSF__omookoj]_8omnoZ?ohm>_oo_kloocgm?o`h]OoooomoncNdOo]i=Goo?_ionK7/_oScKSoo_co
oo7Qd_obi][ono7_on[Gb?olo?cooOkoooojmoo/h]KolnoVoo7TfookmoKok^3CoocnoOono_koimK6
omViToocjN3oo?ghoncKboonoO_omNgRoo7Yg?ooooooo_knoogoo_ooooooo_knookoooono_l06?oo
ool00omnLZ3o03Ylo`10P00Ao`10P005o`0gN_m2K9coo_kbomSIg_oNgN800_oPgn@3omoNh`0@on3O
i?oIf=goDE5Aom[Jg?oRhNKok>_`ong/lOoWinWojn[_ong/lOolo?koV9RJoibLW_oZjNkogmkSon3O
i0;ogmkS01?oh=oTomoNhooPgnCoh=oTomoNhoo]kNooAdM9o`000?l000;o]kNiofIVJ?m`L7;oaLG7
okZj_?oGemWoLG5codU9Boo<c<koi>?X00;ogmkS00KohN3UomoNhooNgN;og=gRookno?mFNjL1o`0f
N@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^
l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`09o`10P007o`0oP_l0@7ko0420o`10
P?l0@H7oNW6NooknoP0@ooooo`0_ooknooomo_oonOGYonoJVoojl=Goookooogoo_ooooookn7DolbE
@oooo_oodjn=onK@^OoI]YSocJ1fon?=]_oL^i[og;VMomB`S?oF/8cocjEmon?=]_oooooon??_olR=
;ooG/i?odZMmom^jVooJ^9com_7[olnRGooL_j7odJIioo[el_o7T3God:V2on77[?nhF`3om>SLongM
c_o4SC;og;nQolbNK?oG/Hgoi]G1om2XKOoZfLL06oooool0A_oooogoo_knookno_oooooooognooWf
kOo^fISomo3FoooooOonooooookloo_hlonkD@3oe:b8onOD`ond>@3ok^7Aon?;/ooJ^9cok]o<om:X
O_oD/H_od:V0olND@oo/fL[ocYmGonKE`OoooOkol>KLolRE??oH/hWoo_kooo3Vg?o>XU_om^gTokYK
0OoB[H?og/B[olZLHOoP`jGom>gWolJ@=_oAZHGog/:ZokU>0?oeimkoooomooSajoo>WDkoh/Zbom>]
ROoajmoocH/doogin?ooo_gok^7Iomo5Z_o=WTcon?3]onC;]Oono_kog/>VomFdKOono_koo_oooooo
oOoooOooooomookno_ooo_lHooooo`03ogibX?l0>Wco0420017o042000Co03Mjod9/W?ono_;of=WN
0ooOg^<04ooPgnCogmkSomoNhooQh>GofMSMoe5ADOoOgn7oe=?Hohn>Ton8R8[o/k>eoibLW_n6QH[o
][JhoifMWonKVigojn[_omoNhooPgn@00ooOg^<04ooQh>Gog]gRon3Oi?oOg^?okNg_od51@ol0003o
0002olG5aomaLG?o>3Pjolo?dOocl_Ooc<_@obd];om@D5;of=SJon;Qi_oPgn@00_oOg^<01OoPgnCo
g]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool0
1Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00Wo
042000Oo03n2o`10O_l0@83o0420o`11POmjLIkoo_kn013ooooo033ooOonookooOolm^Soi<@Ton?0
7_o^fY_oo?WZooomooocim_oaHDTombnX_o4U4;oi]6noljTN_oH]9;oeZ^8omJ`S?oM_j?oeJZ7onOE
_ooR`:OoekRIoogmoOoimNcobIUKomJ_S_oE/i3ogl6Yom>[Qoo^gLgodZMmooKeoOo>XgKoiL^bolbQ
M_oB[Xcobiabom>YPooN`:KoekFBomJdS_oXe/3oaYA?omnjWooE[h_ocJ5TonC;]Oooo_`Hooooo`13
ookno_ono_ooooomooooooomookoo_ooooonooojmnSoi<D]onJm5Oo]f9Oon_SYookno_oYe/Oob9eZ
om>`R_oJ^I[obY]aon77[_oTc[WofKJFonSFb?oBZhCokmgAomRiV_o4T4Goj=K0olbPLoohlngoooko
omjoX_o>Xfcok^;Dooonoooci]kodZ^4omJhU_o5U5[ofkRHomB]S?oB[Xcoe:j:om^iWOo?XWSodJ^6
olZIK_oAZX7og/2Vookon_oflNkocZ=Oon?;/ooBXW[ok^GFolZJA_okn_SooOgooo_bkOoRb[;oahhe
ooSdlOooo_ooo_knomo6YooK]I3oooooookno002ookno`03oooooOonoooooogn01Sooooo00?oOW:P
o`0jO?l0@8004Ol0@8007?l0=g[o@VbLooknl_oHfMkogmkSon3Oi?oOg^?oh=oTomoNhooNgN;ohN3U
omWHgOmCDeGoiNGWojf//OmcLWOoXJ6Sof5QHomaLG?oZ:RZogIfN?nMWIooVi^Mon_ZkooOg^?oh=oT
omoNhooPgn@4omoNh`0Gon3Oi?oRhNKoaLG7ojn_/Ong]kWog=_Pon[Yk_oXj>[oh>3RomoNhooPgnCo
jNW[onSXj_oQhN?oh=oTomoNhooPgnCogmkSon3Oi?oNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z
^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooo_knooShn?o^k_001?o_ko40
1oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/02Ol0@8001ol0?h;o041no`10P?l0@83o0461ogYa
W_ono_h04?ooool0<?oooOcooooooogciooU`S3og[/0onW>Ioohl^;oooomoo7Tg?o7QbgojMO3ol^I
E?oXdL7oj]S:ol^NF_oJ]iWogL:Wom^nX?oM_Z;obJ1NolbRC_o_i]Oooooooo[ckOo8VE?oekFBom>Y
POoUdkgoc9Y5on79/OoI]YKodJASon38[_oQbkCohlN_on?;/OoAZ7ColN?HomRjU_oD[X[oe:f<ooKY
hooJ_IoobIeDon;:/_oM_Z7ocHdfoo;Sg1Sooooo04Soo_knooknoooooogooooooogoo_onooooooko
oo[gj?oUa3OohK/0onW=H?ojln7oooomomNfUOoN`:Koe:j9olBAD_oUc;SoeJZ8on;7[?o7UTWocJ9]
onG;/_objn7ocZE]omBaRooXd[go^4l0omZoX_oQb;;of[NGolbTGoo^hM7ooOonoo?/h_nnJ`7ocZ=h
on?7/OoG]I3okn?GolbPHooD/8cogK^OonG;]?oSbK3ocZaoongMd?oK_9goo_oooocdlOoH^I[oj]W9
olVG@_o>X5?ofkVMoooooOoooooocjMYolRH@oo`g]3oo_omoogoo_oej=ooaWhJomFgToomookooogn
oooooOonoooooOgoooooooono_hHooooo`03ogibX?l0>Wco0420017o042000Go03Mjod9/W?ono_;o
f=WNomkMhP03omoNh`;oh=oT00oogmkSom[Ig_mGEeWoi^KXok2_]?mSHfGoU9BFoemOHOm/K6koVi^M
ogAdM_nRXZCoViZOon[Yk_oPgn@00ooOg^<2on3Oi0CogmkS00?oi^GZon_[kOoXj>X00_oPgn@00ooP
h>;ogmkSon3Oi002omoNh`03omoOhOoOg^?ogmkS00;ogmkS00Koh=oTomoNhooNgN;og=gRookno?mF
NjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_ko
n?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`09o`10P007o`0oP_l0@7ko
0420o`10P?l0@H7oNW6NooknoP0@ooooo`0`oogoo_oooogon_CTonWAIOobhkSoo_ghooooooono_ko
l>SMomB_N?oooOkof;fOonSEa?ono_kom>gSooknoooQaZWofKFCoooooooglo3ono7_oooooooooogo
n_GboljOCoo;Wf3oe[BAookno?onnoKonOCaoogln_ofknOooOoloogko?oooOkooOolookloOooo_oo
o?kkoookn_ock>;oo?_ioo_knOofk>;oo?kmooknooojmNoonoOd6oooool0AOono_ooo_knoooooooo
oOkonOO[on[?J?o`h[?ooOkhookno_olnoWodYm<oo;Ug?oG^IOoa8hdoo[el_oD/Xgoek>?omNdU?ol
nOCooOgooogmnoogk>Soo?[mooWgn?oOa:Oomo3Xom>/Joo_gm3on?3]oocglooooOcom?3UokmV0?o[
f<WojMW:omVkVOono_comNkVoo_fl_olo__oo_coooooooono?goo_omoogln_ooooooo?Kfomo7[Ooj
mO7oo_giooK[iOolo?kooogooogoo_oG]Y?obhliomo3ZooooOooookoooSdjoo>WdooglFZookooooo
o_ooookloogoo_oooooooognoogoo00Hooooo`03ogibX?l0>Wco0420017o042000So03Mjod9/W?on
o_;of=WNomkMh_oOg^?oh=oTomkMhP;ogmkS00koh=oTonKUj_n<S8koZj^]omoOhOnHV9[oTi>EokZj
_?nUYJOoT92Bok6a/omiNG_obLS=onCSj0?ogmkS00?oh=oTomoNhooOg^<00ooOg^<01?oQh>GogmkS
omoNhooOgn46omoNh`0<on3Oi?oOg^?oh=oTomoNhooPgnCogmkSon3Oi?oOg^?og]gRomcMh_ono_co
EW^W0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooo_kn
ooShn?o^k_001?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1>7/02Ol0@8001ol0?h;o041n
o`10P?l0@83o0461ogYaW_ono_h04?ooool2ookoo`04ooojmookn_Goo_ooooono0;oo_oo02Soo_cm
oookn?oooogoo_gkoogln_oooogoo_koookoooock>;olnKMooono?oooooooOkoooooooono_oooooo
oochmoohlngoo_cmookoooono_kooooooognooooooooo_kooooooooooOooooomooknoookookoooom
ooknoooooOoooOolooonooono_koookoookno_omookoo_oo6Oooool0:Oono_kooooooooooooooooo
o_knooooooonoOSooO[aoooooOoooOkoo_ooookno_omnOSoooklooklooolnoOooooooogmoOodimko
l^KJookonooooOooooooookooOono_koooooooomo_omookoo_gkoocjnoomoocoo_gooooooOooo_co
o?_googmooono_koo_[kooonoooooogooOgo00;ooooo00_ooOkoookno?oooOkoookoooknooonn_Oo
lN?Hoo[imoooooooo_knookoo`02ooooo@0:oocln_oflnconOC^ooooooono_koooomooomo_ono_co
o_knooono`;ooOon00?oooooookno?omo_l06?ooool00omnLZ3o03Ylo`10P00Ao`10P005o`0gN_m2
K9coo_kbomSIg_oNgN800ooOg^<01ooPgnCogmkSomoNhooUi>Wobl[?oh60QOoRhNH00_o/jo001_oV
iN[oj^W^oo?bmonl_;koV9NLonWXk@;ogmkS01;oh=oTomkMh_oOg^?ogmkSomkMh_oOg^?oh=oTomoN
hooNgN;ohN3UomoNhooNg^3oh=oTomoNhooPgnCog]gRon7PiOoOg^<2on3Oi003omoNhooPgnCogmkS
00;oh=oT0_oOg^<00ooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_ko
oogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKo
FW:Fo`4hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP0Aooooo`0_ookno_onoogo
oognookoooooo_oooooooooooOooooooooomookoooooo_ooo_oooognooooo_ooooomooknoooooogo
noooooono?ooooooo_knookooOono_koo_ojooknoooooooooogoookooOono_koooomookno_onoooo
ooomooooooonooooooooooomoooooOkoooooooonooolooooo_knoooooOomookoooooooomo?ono_l0
6?ooool01_ooo_ooo_knooooooono_kooognooooo`;oooom00Oooooooogoo?ooooooookoooooooom
oocoo_om00;oooko00Coo_knookoooono_coo_kn0_ooool01?ono_coo_knooomo_onood2ooooo`03
oogmooonoo_oo_ko00;oooom01;ooOonooooooonooooooomoogoo_oooogoookoookoooolo_goo_kn
ookno?ooooooooglookoooooooooo_omookno?ooool2ookoo`03ookno?ooo_oooogo00;ooooo00go
ookjookoooooooooooooookno_ooo_ooo_kloogoo_oooooooOonoooooOooo_oooOon01Sooooo00?o
OW:Po`0jO?l0@8004Ol0@8001_l0=g[o@VbLooknl_oHfMkog]gRon3Oi0CogmkS00Goh=oTomoNhooT
hnSog=_PomkMhP02omoNh`06on3Oi?oOg^?oh=oTom[Ig_oRhNKoh=oT0_oOg^<00ooNgN;oh=oTomoN
h`02omoNh`04on3Ph_oOgn7ogmkSon3Oi0;ogmkS00Ooh>3RomoNhooPgnCogmkSon3Oi?oNgN;oh=oT
00CogmkS00?oh=oTomoNhooOg^<00_oOg^<00ooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQ
h^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_l@07oo3^lOo_
ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP2h
ooooo`03ogibX?l0>Wco0420017o042000Co03Mjod9/W?ono_;of=WN1?oOg^<00ooPgnCogmkSon3O
i002omoNh`03on3Oi?oOg^?oh=oT01SogmkS00Coh=oTomoNhooOg^?oh=oT1_oOg^<01OoPgnCog]gR
omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oon
o_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00Wo0420
00Oo03n2o`10O_l0@83o0420o`11POmjLIkoo_kn0;Sooooo00?oOW:Po`0jO?l0@8004Ol0@8002?l0
=g[o@VbLooknl_oHfMkog]gRomoNhooPgnCog]gR0_oPgn@00ooOg^?oh=oTon3Oi003omoNh`03on3O
i?oOg^?ohN3U00WogmkS00?ogmoQomoNhooOg^<00_oPgn@00ooOg^?oh=oTomoNh`02omoNh`03on3O
i?oOg^?ogmkS00;oh=oT00?ogmoQomoNhooOg^<01?oOg^<01OoPgnCog]gRomcMh_ono_coEW^W007o
03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?So
k^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00Wo042000Oo03n2o`10O_l0@83o
0420o`11POmjLIkoo_kn0;Sooooo00?oOW:Po`0jO?l0@8004Ol0@8001?l0=g[o@VbLooknl_oHfMh3
omoNh`04on3Oi?oOg^?ogmkSon3Oi0;ogmkS00Koh=oTomoNhooOg^?ogmkSon3Oi?oNgN89omoNh`06
omoOhOoPh>;oh=oTomoNhooPgnCog]gR0_oPgn@01OoOg^?oh=oTomkMh_oPgnCog]gR00;ogmkS00?o
h>3RomoNhooOg^<01?oOg^<01OoPgnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7R
i_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_
lOohm_Oo[:^iokjka_mJLYKo0CQk00Wo042000Oo03n2o`10O_l0@83o0420o`11POmjLIkoo_kn0;So
oooo00?oOW:Po`0jO?l0@8004Ol0@8004?l0=g[o@VbLooknl_oHfMkog]gRon3Oi?oNgN;oh=oTomoN
hooNgN;ohn;Wonk^l?oYj>goinK[ong/lOoWi^/2on_Zk`03on;Qi_oOg^?ogmkS00OogmkS00ooh=oT
omoNhooPgnCogmkSon7PiOo^kO;ojNS]onKUj_o/jo3oi^GZon_Zkoo/jo3ohn;WomkMh_oPgn@01ooO
g^<01OoPgnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oo
oOh0lOooool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJ
LYKo0CQk00Wo042000Oo03n2o`10O_l0@83o0420o`11POmjLIkoo_kn0;Sooooo00?oOW:Po`0jO?l0
@8004Ol0@8001ol0=g[o@VbLooknl_oHfMkogmkSomkMh_oPgn@00_oOg^<02ooUi>WoaLG7ohR8R_nX
Yjco/k:goiJEV_nk^kgoV9RJoiJFV?oIfM_ohN3U00SogmkS00koh=oTomoNhooOg^?oi>?Xolo>don;
RhgoXJ6SokNf^onEUIOo^;RjoijNX?n?Si7oclkConCSj0SogmkS00Goh=oTomkMh_oLgN;oo_kloeIk
Y`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_ko
n?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`09o`10P007o`0oP_l0@7ko
0420o`10P?l0@H7oNW6NooknoP2hooooo`03ogibX?l0>Wco0420017o042000Go03Mjod9/W?ono_;o
f=WNomkMhP04omoNh`0;onc[l?n>SY3oI6AVofe]Kon1PH?o:b/]ohB4Q_m^KVkoBDU9okjn`?oVi^P0
2_oOg^<03?oPgnCoj^[/ojFUYomHF5[oKFe_ohB4Q_lO7aooQ8B4ofe]KOmGEeOoYjNYon_[k@SogmkS
00Goh=oTomkMh_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn
0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:F
o`4hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP2hooooo`03ogibX?l0>Wco0420
017o042000Go03Mjod9/W?ono_;of=WNomkMhP02on3Oi00=omoNhooPgnCojNS]oj>SYOl^;S3oNGUk
okZj_?nWYjWo/;2boe=CEOm0@4;ob/[<onCSj008omoNh`;oh=oT00gogmkSonOVjonf][So=3@fofUY
Jong]kWoYZJXokNg^OmVIVKo=cLgokVi^ooWinWoh=oT00OogmkS00Goh=oTomkMh_oLgN;oo_kloeIk
Y`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_ko
n?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`09o`10P007o`0oP_l0@7ko
0420o`10P?l0@H7oNW6NooknoP2hooooo`03ogibX?l0>Wco0420017o042000Go03Mjod9/W?ono_;o
f=WNomkMhP02omoNh`0=on3Oi?oOg^?oh=oTon;Ri?oOgn7oh=oTonOVjoo/jo3oiNCYomkNh?oOg^?o
h=oTon3Oi@0:omoNh`0;on3Oi?oOg^?oh^7VomkMh_oPgnCoi^GZon_Zl?oViN[ogmkSomkNh?oQhN<0
0_oPgn@7omoNh`05on3Oi?oNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_oo
ooooo_knooomoP3aooooo`05ookno_ooooooo_knooShn?o^k_001?o_ko401oo`k_7oknoaooSfmon/
ZkWo_[_6oeYbU_l1>7/02Ol0@8001ol0?h;o041no`10P?l0@83o0461ogYaW_ono_h04Oooool0B?on
oogoookooooooOono_koooooookno?oooOkoookooogmnoomnocoooklooWbk?ocj^7ooOgmooclo?oo
oOcooO_lookno_ooooooo_knoogln_olo_goo?cjoocnnoomoOgoo_gkooclo?omnocoookloogko?oo
oooonOC^ooK]i_omnokonoonooWak_oim?3oo?clooCWgooin?Coooomooomoooooogoo?cjoooooOoj
nOColn[Qoo[jn?oooooomoKbooSajOomoOoom^SOooKel?oooogoo?cjoogoo_ono?goooklooWhm?of
k>?oo?cloooko?onoOWoo_koookno_ono_coo_knooooooomo_ooooooookno`;ooooo01;oo_knookn
ooono_ooooomooono?oooooooOolooonooonoogoo_knooooooolnoWoo_koooono?oln__oookooo_m
o?ooo?d2oogmo@0YookjnOodk>7ono_iookno_ojm_GomO3ZooonooohknKol^[Oookno_oooooooOon
oookn?ono_oooO_loookn?onoooom?3WooC[h_ooo_ooo?cloogln_omoOgoo?[kookno_ooooooo_ko
ookmnOolo?cooO_lookno?oln_gooooooogon_ohk^coknKGoogmnoono_coo_ooookno_ooo_l08?oo
ool00omnLZ3o03Ylo`10P00Ao`10P005o`0gN_m2K9coo_kbomSIg_oNgN801_oOg^<01?oQh>GohN3V
omoNi?oPgnD2on3Oi003on7PiOoOgn7ogmoQ00?oh=oT00?ogmkSon3Oi?oOg^<00_oOg^<03?oOgn7o
gmkSomoNhooPgnCogmkTon3Oi?oPh>;oh=oTomoNhooPgnGogmkSon7Pi@;ogmkS00KogmoQomoNhooO
g^?ogmkSon3Oi?oOg^<2on3Oi005omoNhooNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?o
hN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooo_knooShn?o^k_001?o_ko401oo`k_7o
knoaooSfmon/ZkWo_[_6oeYbU_l1>7/02Ol0@8001ol0?h;o041no`10P?l0@83o0461ogYaW_ono_h0
4?ooool01oonoooooognoocjk_ofk=7oookjoo[noOokooh00_ooool0>ooYe/Gog<6Voo;Ug?o;XEWo
fKBGonkNcooI/hoonO3YomNaP?odkN?ooOoloo?Uf_oH]iSoj]G2omk0Y?oVc;_oi<Z_omk4ZooUckSo
f;BBooG^i_oI_9coj=K2olnYN?o@Yg?odJQdooCZh?o<XEcoim:oomZfU?o<Y5oojMC1oogoo_ono_co
o?[komB/IoohkNOofKFEolfQH_o<WU?ol^CKomF]R_oP`jGohLF_olbOFooC[8?olNGGomJ^OOolo_go
g/FWonG;]?oG/8ood:V2om>/PooH]IGoiM2kookno_ooooooookl00;ooooo00Koooomoooooooooooo
o_knookno?ono_h2ooooo`0jookno?okn_Gomnk?ookmnoonoOoooOoloooooOono_cob8`/ombnX_o^
iMCo_fP1oo?Xi?oYdkcog/J/onoSeooJ^ISog;jRoljSK_o>YGOolNOMomF]O?oM`ZOoo_koon[Ea?o<
SSOoh/Raooknooocj^7oe;:2oo[km_o;W5CoekJEonoOd_o=WEgogKZLooWilOoCZH7og;^JoncF`Oo6
Nakon?C[ookno_ojln_oe[5monSC`?oI^Ygom^gTomB_J?onn_Woookoon?9/?o>Vd[of;ZHooomooon
o_koooooooknoR3ooooo00?oOW:Po`0jO?l0@8004Ol0@8004ol0=g[o@VbLooknl_oHfMkog]gRomoN
hooPgnCogmkSon3Oi?oNgN;ohn;Wong]kooal?Gom_Gjoo?bmoodloSol>odonSWk?oNgN800_oPgn@2
omoNh`;oh=oT00GogmkSon3Oi?oOg^?oh>3RomoNh`02on3Oi004omoNi?oWinWol?3bon?Ri`;ogmkS
00Gojn_]ong]kooQh>Gog]gRon3PhP02omoNh`03on3Oi?oOg^?ogmkS00;ogmkS00Goh=oTomkMh_oL
gN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_kn
ooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`09o`10P007
o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP0@ooooo`18ooonooomookoo?GUonG49ooZdGoon_3G
ookno_oooOkoo_ooonGA^OoJ/iCoekJEom2SO?oM`jSoi<V^olfVOooek^KocZM^onWD`OoP_Z?ogL:U
om>[QooUc[coek>?omo4ZOoL_IkofkZKon77[_o>Y7col^_SomF]R_oK_9oodZJ1oo;Yi?o;Wg;ojM;2
om:[P_obj=koa8hdomk2Z_oI_Z3ooo_loooooOokn_Soc9m:onoRd_o:XF_olNCKolbPNOoXdl;ocZMn
oo;Xg_o;Wfkomo3ZomFcT?oM_jGodJ9ZoogmoOoI]i_oh<:XomW1WooH]9;oaYMSom2XQ?oPb:koooom
ooomo_ono_koooooookno_oooogoo_kn0_ooool0=_oooogooooooooooooooooooognooWgjooUaRgo
j/mnooO`e?oooogoo_cooo;Vf_o1NacodJb2on32Z_nnNQWoj=?2on;>/ooK^Y_ok=o?om2YP_oQajco
fkVMol>BCOoXeLCod:5cooKck?oooogokMoDolnRIooQaZ_oooomoo;UgOo?Z7oohlfeokaZ1?oF/Y3o
e:f6omF]ROoM_j?oiM2molRFEoo@ZX?odJj8olB<;ooWd[goo_koooKbjOo=XUgohl^aom>[Qoocj^?o
biA1oochm@;ooooo00Kol^KJolQe5Ooil^cooOonooomo_omoohPooooo`03ogibX?l0>Wco0420017o
042000go03Mjod9/W?ono_;of=WNomkMh_oPgnCog]gRon3Oi?oOg^?oi^GZokZj_?l_;c7oB4Q:00;o
@41200Co?3`noc@d=_nSXjGojNS]0_oOg^<2on3Oi0;ogmkS00Coh=oTomoNhooOg^?oh=oT0ooOg^<0
2ooViN[oUYJHob<S9Onb/KKoj>O/omgLhOmfMWSo@410olc;d?oUi>WogmoQ00;oh=oT00Cog]gRomoN
hooPgnCogmkS0_oPgn@01?oNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[
^Onn^lKoFW:Fo`4hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP0@ooooo`16oogo
n_oooooonOKUon?5?ooN]`3oi/DRooSaeoooooooooomonOA_?oK]YWojMO3olVMK_o;WFWohlVbolNE
??oH]9CocIeAooG[h_obk>3ojMS4olF69oo?YG_obY]SoljRNooPb[?ogK^OonC:/oo9VUCoe[2;olbP
HooQbkCocjUhooS_j?o@Xfcog;^Lol:07ooYflkodJJ3olbRJ?oEZg7oookoooknoooknO[oc:9`oo3T
f?o?Y77om>ONom2[POoK_J7o_g/FonS?^ooG]YGog;ZNom6ZOooZeL;ob9Y5ombmX?oG]9Coi<jgonkP
doo:WVgocj=lomReUOoQbJgoo_knooomo_onooooooooooknoP;ooooo043oo_knooooooono_cooooo
ookno_ooooooookooo_hjOoWaDOog[P0onC46Oofkm?oooooon34[_oG/i7oeK2Com2SN_oI_9koekJG
onG<]_o:WW7oe:f<omVgU?odj^7odJZ1olVGF_oSckKo_G8<on?=]_ofknOodJZ3olfODOoejn;ooOon
oo?ZhOo9VEOocJ5jomNhVOoL^Ykoh/Vcol^MJoo=XWGodjf9omZgVOoH]9Coa90jon?7/OoF/X;ooooo
ooKbjOoAYfgohljkolF17_oH/XkocJEMoooooOono_kofl2RolRJC?oO`j_oo_knookoooonoogoo_ko
8?ooool00omnLZ3o03Ylo`10P00Ao`10P007o`0gN_m2K9coo_kbomSIg_oOg^?og]gRon3Oi002omoN
h`0=on?RiooJf]co51@Fo`000?mVIVKoGEeMof=SHol0003oGEeOonk^l?oQhN?ogmkSon3Oi003omoN
h`03on3Oi?oOg^?ogmkS00?ogmkS00goh=oTon[Yk_nPX:;o0@41ol[9c_oUi>Wok>_`of=SIOl10@7o
iNCYon3Oi?oOg^?oh=oT00KogmkS00Goh=oTomoNhooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T
/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004ono_l@07oo3^
lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6Nookn
oP0@ooooo`12ookoooono_oon_GRonC78oo]cWcomngDooomooonoo[ol^OSolfRE?o5P27oj=O5onKA
_?oYe<7oo?[konkQdOoOb:Wok]k?oogoo_oooooonoScon_Ja_oSbK;ok=_;onC<]?okn??oj=O3oo7Q
e?obiMcoh<Naon_Haooln?OolNCKookjnOobj]oohljiolN>=?oflN_om>SLon76Zoogl>[oo_omoo_g
m?oSa:oo_6<0omVfV?o[f<[oo?cloo?Zhoo_gm3obHT_on_Kbooin?Coh/N/onkNdOoooOkol>OHonSC
`_oVdKcolN?FooS_i_oQaJgon>oXomNdU_oQ`Z?oo_oo0oono_h0@?ooooooooklooknooono_koo_ko
ookno_ooooooo_knooooooooo_oon_SYonG6;OoXcg;om^oBooomo_oooooobY4gonSGaOoAZX?o_6/2
oo;Xg?o>XgKoekRIom2RLOoUckSom_;YooKel?oRa[3olN?Hoo7XhOo9TSOojmC4oljQD?oVdl;ohlfe
oo?Vg_onoogom>_TokHd0_oL_Ikoj=:momF_R?omookoh/Z`oncMb_odjN?omo3ZooC`iOodi=OonOSc
oo;UgOooooooo?WdonC;]Oogk^OojMS8omk4Zoodj^3oo_knookno?o<XeCobY@lonSGaOooo_l2ookn
oR7ooooo00?oOW:Po`0jO?l0@8004Ol0@8003_l0=g[o@VbLooknl_oHfMkog]gRomoNhooPgnCogmkS
on3Oi?oNgN;oiNGWon?SiOnEUIOob/[<0_ooool01On8R8SoE5AFonk^l?oNg^3oi>?X00;oknkc00Go
iNCYomkMh_oNgN;oh=oTomoNh`02on3Oi0;ogmkS00Woj^W^ok6a/ol0003of][Lon?Riooal?GoNGUk
o`X:2_ogm_`00_oOg^<03?oYj>goknkcong/lOoQh>Goh=oTomoNhooPgnCogmkSomkMh_oLgN;oo_kl
oeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooookn
o_ohn?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00Wo042000Oo03n2o`10
O_l0@83o0420o`11POmjLIkoo_kn013ooooo01Goookooooooooln>gom^_;ooolmoolooooo_omoooo
oOocjMgogLR]on;:/_oYe/Gooogoookno_ooo_ooo_klookoooono?ooo_ooooooooooo_l00_ooool0
2?oooogoo_knooknoooZelKokn?Coogoo_onoo_oo_kl0_ooool05_ono_coookoookloOohmO3oooko
ooonn_omookoookoookoooohmo;ohlngonC8/?oRc;GonOGbookno?ono_koookooo_dk_okn_Sooooo
ooomooonool2ooknoP03oooooooYf<SokmoB00;ooOko00Ooo_omon;9/ooYf<SooOkoookno_onoooo
o_kn00;ooooo00?oo_knooooooooool01?ooool0>_ono_koo?W`ooG/boooo?Ooooglookoooolo?co
k=W8oo_gm?oahmSoj=K2oogoo_oah=KohLbaonO>^?ooo_oooognooknooonooooo_klooomooogm>oo
o?kmonkRd_ogk^Goo_koooonooono_koo?SeonKD_?ommO;omO;[onoSeOoooooonooooooloooooogo
oooooooooOoooOkoo_koookooooooogoo?Oaon?;/ookm_;ooOkooocooOoooOkoooooooomo_oahm[o
gLR]onSEa_ono_ooooooookno_oooOhPooooo`03ogibX?l0>Wco0420017o042000Ko03Mjod9/W?on
o_;of=WNomkMh_oPgn@3omoNh`;oh=oT00[oiNGWomgLhOn4PhSo^kZoono_lOo@d=;oYZFZonCSj?oU
i>Wo`L730_n4Q8H00oo3`lGoiNCYomoNh`02omoNh`0Don3Oi?oNgN;oh=oTomoNhooYj>go[Zj`o`00
0?oGemWohn;Woo3_m?mgMW_o1`L7oo?bn?oOg^?oi>?XojRXZ_n1PH?oTI6Com[Ig_oQh>D3on3Oi004
omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool0
1Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00Wo
042000Oo03n2o`10O_l0@83o0420o`11POmjLIkoo_kn017ooooo01Soo_koooooooono_ooo_kooooo
oooooOkoooooookno_oooooooogoooooooonoo[oo_ooookno_omookoo_ooooonoOooo_oooogooooo
ooonoogooookooomooono_l2ooono`0]ooomo_ono_koookoooooooomookooocoookonoomo_ooo_oo
ooono?ono_oooooooognooooo_oooOolooooooonoogoooomooonooono_kooognoooooOoloogooogo
oooonoooooooo_knookooOoooogoo_omoogoo?ooo_ooo_omoooooooooogoo_koookonoomo_oooooo
ooono?okooooooooooomo_onooooo_kn00?ooooo00Wooognooooooooooooooooooonn_ooooooo_kn
oognooonool00_ooool05ooooOkoookoooonoOoloogoooooookno_ooooooo_knoooonoonoogoo_oo
oooooookookoookoookooOoooOcoo_goooonooonooooo_knooooooono_ooo_oo00;oooko01Oooooo
ooonooono_koooomookno?onooooooooookno_ono_coooomookno?onoogoooklookno_omookoooom
oognoooooooooognookoooooo_coo?ooookoo`02oooooB3ooooo00?oOW:Po`0jO?l0@8004Ol0@800
1?l0=g[o@VbLooknl_oHfMh3omoNh`0Yon3Oi?oOg^?og]gRomkMh_oPgnCoi>?XomcKh?n;RXoo^[Vn
onOVjooThnSogmkSong/lOnDU9Ko0002o`410onKVigok>c^on3Oi?oOg^?oh=oTomoNhooPgnCog]gR
on3Oi?oYj>go[jnao`000?oGe]_ohn;Wono_lOmgMW_o1`L7oo;anOoOgn7okNcaoc@d=?l0003o0002
om7AdooViNX00_oOg^<01OoNgN;ogmkSomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_on
o_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_lOoh
m_Oo[:^iokjka_mJLYKo0CQk00Wo042000Oo03n2o`10O_l0@83o0420o`11POmjLIkoo_kn013ooooo
00cooognoogoo?oooooooooooooooOono_coookoookoooono_ooooomooonooonool2ooooo`0Dooko
ooooo_goooomoooooookoooooookoognoooooogoo_ooooknoooooogoo_klookon_oooooooOonoooo
oOooo_goo?ooooooooonool2ooomoP03ooonooonooooookl00;ooooo00Koo_omooknooooooooo_om
ooonooonood2ooooo`0Cookno_oooooooOkoookno?oooooooOolooooooomookooogoookno?oooOoo
oOolookno_onooooookoooooooooo_ooooomooknoP02ooono`0Ooognoooooogoooooookno_ooo_oo
oognooooooonoooooOonoooooooooogoooooookno?ono_ooookjookno_oloogooognookoooooo_co
o_ooookno?ooo_ooo_ooooknoooooOkoooooooomo_oooogooogooogooP02ooknoP0>ookooOooo_[o
o_ooooooooonooooooklooooooonooooo_knoogoo?oooooooognoo_oo_ono_`3ooooo`09ooomo_oo
oooonoooooonooomoocooogooooooOoooooooOol00Cooooo00?oo_klooooooooo_l08?ooool00omn
LZ3o03Ylo`10P00Ao`10P006o`0gN_m2K9coo_kbomSIg_oNgN;oh=oT0ooOg^<03?oPgnCogmkSon3O
i?oNg^3oo_kooi:BU?l10@?ohN7Son;Qi_oPgnCok^gboiBDU0;o000000?oVYZLong]kooOg^<00_oP
gn@04?oOgn7ogmkSomoNhooPgnCojNS]ojj^/?l0003oemKKon?Rioo_ko7oMWEjo`L71OoblOWoh>3R
onc/k_la<C42o`000003om;Be?oUi>Woh=oT00;ogmkS00Cog]gRomcMh_ono_coEW^W0Ol0=WT00007
oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_
ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo042000Oo03n2o`10O_l0@83o0420o`11POmjLIkoo_kn
09Sooooo013oo_knooooooomookoo_knooomo_ooooooooomookooooooogoo_knooooooono_kooooo
ooknooomookooOol4?ooool00omnLZ3o03Ylo`10P00Ao`10P005o`0gN_m2K9coo_kbomSIg_oNgN80
0ooOg^<2on3Oi0;ogmkS00Gol>oeoiZIW_l10@7oaLC9onWXk@02on3Oi007on?Rioo<bm3oXJ2Uoj:Q
Y_o=c=7ohn;Won3Oi002omoNh`;oh=oT01;ogmkSon3Oi?oYjN_o[Zj`o`000_oHf=[ohn;Woo?bmomg
MgWo20P8oo?bn?oPgnCoh^7VokZi__nPWjCoZZV^om_JgooQh>D2omoNh`05on3Oi?oNgN;og=gRookn
o?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oooooo
ooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo042000Oo03n2o`10O_l0@83o
0420o`11POmjLIkoo_kn09Sooooo0_ono_h01_oooOooo?oooogoo_omo_ooooomooomoP;ooOko0_oo
ool01?omookooOolooonooono_h@ooooo`03ogibX?l0>Wco0420017o042000Go03Mjod9/W?ono_;o
f=WNomkMhP04omoNh`0<on3Oi?oOg^?ol>odoj:RY?l000;oe=?HooknoonNWZ3ob/W>on?SiOoOg^?o
hn;W0_o]k?400ooSh^Oog]gRomoNh`03omoNh`0<omkMh_oPgnCogmkSon[Yk_nb/[Co0002ong]kooa
l?Goo_koogalO_l@413on?Om0_oOg^<01?oWi^_ok>_`on_ZkooPgn@2omoNh`06on3Oi?oOg^?og]gR
omcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookn
o_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo042000Oo03n2o`10
O_l0@83o0420o`11POmjLIkoo_kn09Sooooo00_oo_ooookooOonoogoo_knooomooonooooo_cooooo
ooooo__oooooookno`02ooknoP03ookoooomoocoooko013ooooo00?oOW:Po`0jO?l0@8004Ol0@800
1_l0=g[o@VbLooknl_oHfMkog]gRomoNh`;oh=oT013ogmkSon3Oi?oWi^_oUIBIo`000?nFUI[o_[k0
oj6QXol000;obl_=onGTj_oPh>;oh=oTomkMh_oOg^?oh=oT0_oOg^<00ooPgnCogmkSon3Oi003omoN
h`0;on[Yk_nGUiWo0002ojRXZ_nb/[Co^k^moeEEEol0003ogmkTon;Qi_oOg^<00_oPgn@3omoNh`07
on3Oi?oOg^?ogmkSomoNhooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooon
o_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0
>7/02Ol0@8001ol0?h;o041no`10P?l0@83o0461ogYaW_ono_h0V?ooool03oolooooooooooonoooo
o_ooo_knoooooooooogoo_knookoooomoocoookmooonooonoooooooooogooP0Aooooo`03ogibX?l0
>Wco0420017o042001?o03Mjod9/W?ono_;of=WNomoNhooPgnCogmkSomkMh_oOg^?oh=oTon;Qi_n@
SiCoO7anoiJFV?nCTYSoQXJ8ohB4Q_oKf^3oh^7V00;ogmkS0_oPgn@00ooOg^?oh=oTomoNh`05omoN
h`0=on3Oi?oThnSoXj>Uog]kOOn>SY3oTY:Dohf=Son1PH?oPh>5olg<dOoThnSogmkSon3Oi003omoN
h`;oh=oT00Kog]gRon7PiOoNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYb
U_l0>7/02Ol0@8001ol0?h;o041no`10P?l0@83o0461ogYaW_ono_h0VOooool03oono_coooooookn
o_oooogon_kmookno_ooooooooklookoooono_cooognooooooono_koooooooknoP0@ooooo`03ogib
X?l0>Wco0420017o042000Co03Mjod9/W?ono_;of=WN0_oOg^<00ooPgnCogmkSon3Oi002omoNh`06
on[Yk_ooooooWIfOogUiNOnl^l3omoKl0_oOg^<01OoPh>;oh=oTomoNhooOg^?oh=oT00OogmkS00co
h=oTomoNhooWi^_oooooojb/[_mgMgWo[Jf_ooknooo]kNooh^;TomgLhOoPgn@2omoNh`05on3Oi?oO
g^?ogmkSomoNhooPgn@00_oNgN800ooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_kn
ooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6
oeYbU_l0>7/02Ol0@8001ol0?h;o041no`10P?l0@83o0461ogYaW_ono_h0V?ooool03ooooOkoo_oo
ookno?onoo_oookoookooooooogooOkoooooooono_ooo?ooookno?oooogoo_koooknoP0Aooooo`03
ogibX?l0>Wco0420017o042001;o03Mjod9/W?ono_;of=WNomkMh_oOg^?oh=oTomkMh_oOg^?oh=oT
omoNhooPgnCoh^7Voe]KFOmaLG7oRHV;onc[l?oOg^<2omoOh@03omoNhooPgnCoh=oT00;oh=oT0_oO
g^<00ooPgnCogmkSomoNh`02on3Oi0;ogmkS00Soj^[/og=cMOmbLWCoMgMion[Zk?oOg^?ogmoQon3O
i0GogmkS00Soh=oTomoNhooNgN;oh=oTomoNhooLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7R
i_ono_koooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[
^Onn^lKoFW:Fo`0hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP2Hooooo`07oooo
oOonoooooOonooomoooll^WooncNooogm@02ooooo`05ookoooono_ooo_oooogoo?ooo_l04_ooool0
0omnLZ3o03Ylo`10P00Ao`10P005o`0gN_m2K9coo_kbomSIg_oNgN800_oOg^<03OoPgnCogmkSomkM
h_oPgnCogmkSon?SiOn=SHoo@T92ojb/[_oXincogmoQomoNhooOgn400_oOg^<2on3Oi0;ogmkS00Co
h=oTomoNhooOg^?oh=oT1?oOg^<01ooWi^_oVi^Mod10@_nKVigoinOYon3OiOoOgn401OoOg^<01?oN
gN;oh=oTomoNhooPgn@2omkMhP03omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_ko
ooooookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKo
FW:Fo`0hN`09o`10P007o`0oP_l0@7ko0420o`10P?l0@H7oNW6NooknoP2Hooooo`0@oogoo_oooOoo
oOKVoon]BOonPP3ooWL1ooj?0OonZ3_oom:XookloOooooooookloocoooooo__ooOkoookno13ooooo
00?oOW:Po`0jO?l0@8004Ol0@8002_l0=g[o@VbLooknl_oHfMkog]gRon3Oi?oOg^?oh=oTomoNhooP
gn@2omoNh`09on3Ph_oWi^_ojn[`onKUj_oNg^3oh=oTomoNhooPgnCogmkS00;oh=oT1OoOg^<03OoP
gnCogmkSomoNhooPgnCogmkSon3Oi?oOg^?oinK[on[Zk?oWinWogmoQon3OiOoOgn401OoOg^<02OoP
gnCogmkSon3Oi?oPgnCogmkSomkMh_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_kn
ooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6
oeYbU_l0>7/02_l0@8001_l0@7ko0420o`10O_l0@83oNW6PooknoQ3ooooo00ooooomooonoooooogo
oOkoookno_onoogoo_ooooonooonooooo_knoooooooooOooo_omookno_ooo_l00_ono_`01?onoOoo
ooomoogoo_ono_`3ooknoP04ooono?onoooooOkoooooo@;oo_kn00Soooooooonoooooogoookoookn
ooonooooooooooooo@?oo_oo017oo_kloooooOooo_ooo_ooookno_ono_ooooomoooooookookoooko
oogoo?oooogooogooogoo_onoogoo_knooooo`02ooono`0Cooknooooo_[oooooooomo_ooooooooko
oooonoomookooOkooooooOomookooogoookoooono_koooooooonooono_conoooooooo@02ooooo`04
oooooOooo_ooooomooknoP;oo_oo00goooomoocoooooo_ooookoookoooono_ooooooookno_oooooo
ookoookno_ooo_ooo_om00;oooom00Soo_koookno_ono_coookooooooooooogoookoookno0?oooko
00Ooo_ooookno_ono_ooookoookno_oooogoo_ko00?ooooo00Woooomooomo_ono_koookoookno_on
oogooOonooonooono_`00_onool04_omoo[ooognooonooonoogoo^SCooeM0?ooBP?ooh@2oon[Fooo
Ydgoof/0ooj/A_onmNkoooooookno_omo_ooo_knooooo@;oo_kn0_ooool2ooknoP;ooooo00goo_ko
ookno_ono_coo_knooooooono_koo_omookno?mkLYoo03Yjo`0oP_l0@83o041n00oo042000Go03Mj
od9/W?ono_;of=WNomkMhP04omoNh`04on3Oi?oOg^?oh=oTon3Oi0;ogmkS00?oh=oTomoNhooOg^<0
0_oPgn@:omoNh`04on3Oi?oOg^?ogmkSon3Oi0;ogmkS0_oPgn@00ooOg^?oh=oTomoNh`05on3Oi003
omoNhooPgnCogmkS00;ogmkS00Cog]gRomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nRY;?ohN;Vookn
o_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjk
a_mJLYKo03Qk00So042000So041mo`0oP_l0?h;o0420o`10OOl0@GkoNW6Pookno13ooooo02oooogn
ookooooooogoo_klooknooooooooo_ojookoooono_coooooookloOoooogoo_kooooooOooo_oooooo
ooomooonooooookoookno_onooooooklooooooonooooooooookno_oooogooognooonooono_ooooko
ooooooonoooooognoogoo_oooOkooogoooooooono_cooognooklooonooooo_omooomo_onoogoo_oo
ooono`02ooknoP0Gooonoooooooooockoogoo_ooo_ooo_knooonoooooooooognookooOomoOooo_kn
ookoooono_cooOonooooooooo?ooo_ojooonooono_ooookooooooOonood00_ono_`02_oooooooOon
ooonoooooogoookoookno_ono_ooooomoogoo_ooood2ooono`0>ooomo_ooo_ooooooooonooomooko
o_knooonooonoogoooomooooooonooooo_omookloOomo_l2ooooo`09oo_ooooooogoo_ooookno_oo
ooooooklooonooonoooooOol00?ooOon02Ooookoooooooomoocoo_oooocnnoooooooo_koooooooom
ookoo_ooooonooonoogooooooooooOooo_ooooooooonooomookoookoooknooonooooookoookoooon
oOoooooooooK]oooa8coo>K?oocooOooooooo]:[oomH0?onY3;ooo[oooooooono_ooo_oooognooon
o_h01oooool01?ono_koooooooooooonool3ooooo`03ooomo_mlLj;o03Yl01;o042000Ko03Mjod9/
W?ono_;of=WNomkMh_oPgn@3omoNh`03on3Oi?oOg^?ogmkS00;ogmkS00Coh=oTomoNhooOg^?oh=oT
2ooOg^<01?oQh>GogmkSomoNhooPgn@2omoNh`;oh=oT00?og]gRomoNhooOg^<00ooPgn@4omoNh`08
on3Oi?oOg^?ogmkSomoNhooNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYb
U_l0>7/02ol0@8001Ol0@8;o045no`11POmiL9ooooom013ooooo00coooomookmooomoocooogoooon
oooloOooookooooooOono_ooookoookoooono_h2ooooo`04oo_ooooooooooooooogonP;oooko01go
o?kmooknooooooooo_ojooooooomookoo_klooonooono_koookloocooOonoooooooooogoo_oooooo
o_kloocooOoooOkoo_knookooOoooogoo_knoognooooo_oooognookoooooooooo_knooooo@02ookn
oP05ookno?ono_oooOkooogoo?onoOl00_ooool00ooooOkoo_oooogooP02ooomoP03ooonoooooogo
oooo00;oo_kl00Koooomookno_onoogoookoooknooooood2ooknoP0>oooooOono_cooooooooooooo
o_oonoolooooooooo_ooooooookno_onoooooOonoognoooooOh2ookoo`0Aooomo_ono_koo_knookn
oooooogooognoogoo_onooooookoooomo_ono_oooOolooolooonooooo_klookooOomo_l00_ooool0
5_onoooooocoooonooomoocooognooono?ooooooooomooonooonoogoo_cmookooooooOkoo_kooooo
oOooooooo_knookmoooooOooooomoogoo?ooo_`2ooooo`0Aookno?ono_kooookookno?omookoooko
ooooooono_koo_klooonoool]G?ooe81oonmPOomoocoo_oooooonoonool00oooool01Oono_kooooo
ookno_ono_kooooo00;oooom0_ono_h2ooooo`05ooomo_ooooooOW>No`0jO?l0@Gh04Ol0@8003_l0
=g[o@VbLooknl_oHfMkogmkSomgLhOoViN[oj^W^onCSj?oNgN;oj>O/on[Yk_oSh^Oog]gR0_oPgn@2
omoNh`;oh=oT2_oOg^<00ooQh>GogmkSomoNh`02omoNh`07on3Oi?oOg^?ogmkSomoNhooPgnCogmkS
on3Oi003omoNh`Coh=oT0_oOg^<01?oNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Ko
o_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo
_[_6oeYbU_l0>7/02ol0@8001Ol0?h;o0420o`12O_miKY3oookU013ooOKI00goo?GHooogf_oom]Oo
no[KooglgOonmm[oooOJoooffOomn=[oo?GIoo_deoonnMcoooOF00?oooKI06?oo_WKookmg_ono]So
oo[LoogffOoom]Woo?_Mookkg?onlmGoo?OIoooef_olmMSooOCGookgf_oooMkoo__Lookgf_omm]Wo
o_GHoooefOonnmcoo_gNoookfooom]OonoCGooggeooom]Woo?KFookgf_oon][ooOgKooojg?onmMSo
oOKIookgfoonmMSooOKIoookfoonom_oooWJookef?oom][oo_GHooohfooonmkooooNoooieoomn=_o
ooKIoogffOoon=_ono[Looolg_oolmWoooOHooolgOoomm_onoCHooogf_oom]GoooKGoogjfooommSo
ooKIoo_ge?onmMSoo_OJookmgoonoMkoo_WIookdfOomn=[ooOgKookgf_olm]Koo_CIoooffOokm=Oo
oOCEooojf_oooMkoo__LooofeoolmMWoo?KFoooff_oon]gooOkNooojf_ommmOoooCHooofeooom]Wo
oO7Goocfe_oonMgooOkLoooig_okmmX00_onmMP02_onmm[oookOooglg_o`jLooiMo9ongVb_onmm[o
oooMoookgOojlmH2ooojg00GoogffOomm=Goo?OIoogff_onl]Soo_GFoookg_omo]ooo_WKookef?om
mmOoo_GHoooffOoomM[ooOKIoooljoomg:OoogX0oof40?ooi;Wooo[Pooodf_oom]T02?oomMX01?om
m]WoooKIoooef_oomM/2oooff@05oooef_ooo]ooOW2Co`0jO?l0@7h04Ol0@8003_l0=g[o@VbLookn
l_oHfMkogmkSon?Rioo4`lSoXj:WolW9booVi^So][JhojZZ[?oFeM[oh^7V0_oOg^<01OoPgnCogmkS
omoNhooNgN;ogmkS00Koh=oT0_oOg^<01_oPgnCogmkSon3Oi?oOg^?oh=oTomoNh`;oh=oT0_oOg^<2
on3Oi0WogmkS00Goh=oTomoNhooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYb
U_l0>7/02_l0@8001_l0@Ggo041no`0oP_l0@83oMf]ioogo[a3oonbX09Sooo6/olNjPolU70[o@3HK
oeI=;?l/8@goPW=8oogXYOomkZWoonj/ogmdA_nRU6goo_F`oood[?o=_XOo:28:ochg6omUGcooJfA8
of=D<omPES;oDD/[odY19?m;@2;o@CLLomc<TOoomJkoln6SofiU?_m9?R;oJF11ofMQ?olj<1OoXiIZ
oifAIoll<QOoIETcofaSA_mRFS?o<BHBok^^N_omljkoo^fWoiV=FolU80coHU@_ofYSAomIBbko?SHO
omO8SOolijKoLf]6ocD]6?mWF3WoJ6=3oeM<=_m@A2codLF;oinBJ?l`:AOoJ5/hofQSAOmSECSoCT@Y
ocli8om0>2?oACXXobLR3onaYG?o/ZIfochh8_mBBB[o?3@Ooge_B?oci:7oo_B]ongIW_m=AbOoi=6F
ooch[ooKbYCo?CLQodU2:?mYH3ooJVA2of5F=_mWFS[oCdP/odm:;?lb:QgoXIAWooo]Z?oml[3o`[F0
ocXd7?mSFCKoK6=4oeA=<?mDCRkoe/F=oiF8G?le<acoIUhiofaS@_m:ABSoC48Yon?CUOoolj_ooo6`
okfbO?l/9aCoCT8XofaR?_mWGSgo=2/IojnQL?onm:ooonjYokBVMOln<aoo0000oeY<<OmRG3[o:BLB
ogAZA_nm/7coTXURodPm9omEDBco>C4LokZ^O?oom:goo_2YojVJKolk=AooJV8nof]PA?ln>R7oGePk
onoMWOonkj[oonb]ook[Yoook:Soo^n/oooNUoomRPgoog@1oonjGOoolK3oon^Vook/ZPCoo^fX1?oo
k:P02_onkJSoonbXooo/Z_ook:SoonbWoog/Y_onkJSooof`oge[POl0>W`2o`10P004o`11O_l0@83o
0420o`10OPco0420017o03Mjod9/W?ono_;of=WNomkMh_o]k?7o>3Pjo`000_mmOGooa<C6oeADE_m0
@4;oXJ2Uon[Yk_oPgnCog]gRon3Oi002omoNh`03on3Oi?oOg^?ogmkS00OogmkS00?oh=oTomoNhooO
g^<01_oOg^<2on3Oi003omoNhooPgnCoh=oT00;ogmkS00?oh=oTomoNhooPgn@00ooOg^<01?oNgN;o
g=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_kn
oooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/02Ol0@8001ol2?h;o0420
o`10O_l1@Goo0D61ogYXO_oooKH04?ookJd0Qoonkjkoim^OokfaPOm1@Coo0@00oj6EKooB`XkooNf_
ook_[_onm:go000<o`803_onoJgoo_>con_KX?o0/X7oUhUVo`000?l00@3oDd`iolRlR?ni[7oo0002
oeiEA?oEa93olN6Sook_[_onjJSofl^Goh=mFOl20@3o0000oiN;HooRdYOog<fFokj`Pol111Go0040
oaTG8_o4]8?oi]FMooo`[oook:gogLbHokNYN_l000go0000odM8=_o6^HGol=^Joog[XooE`XOo/ZEa
o`012_l0003oF54eol^kP?o]gYWogLj9ojFNJ_l000Co0@41ogU`DOo0/gco]jMcokFYMonlZgOo<2l[
o`000_o>_X?o[Z1_o`000_mUGT;of/>=ooSNXOomij_oe;f;o`000?nJSF?oooZ/ongDW?o:]XCoXIAX
o`000_l00@3oSX9LomBoR?n6NEKo0002ojbNKooIbHkoo>VTook[Y_oPdYGo_jj0ocPc;Ol000;o0@06
okj^OOoagY[oc/6<oijBJ?l1003o0@43ofYNA_o8^H3okMBLooOQYOoiiJKoi]:ColBgPomLET3o0002
o`001oncYGKog/nFooo_Z_n[X7?o0081o`000?nk[Gcok]JJomW9S_nER6Go0@05o`010?o1/H3oD4/e
o`000?nkZWkogLfBoo3PYOoii:GoiLnEojfQK`02o`01000=ofQQAOoC`i3on>JTook[Y_onk:;ooNVR
oo[WXoomjJ[oom^Aoon94oooL`3ooj]8oog[Z@02oocYY0CooNVT00konnJSoo[UX_oliJ;oo>FRookU
YOomi:;on^FToo_VXoomjZGoo^VVoocWY?oonj[oNfUeo`0jO0;o042000Co045no`10P?l0@8;o041n
3?l0@8004?l0=g[o@VbLooknl_oHfMkogmkSon3Oi?oHf=[ojn_]ojf][on3PhGoJVY/oc4a<onWYZ_o
jNS]on3Oi?oNgN83on3Oi004omoNhooPgnCogmkSomoNh`;oh=oT0_oOg^<01_oPgnCogmkSomoNhooO
g^?oh=oTomoNh`;oh=oT0_oOg^<01_oPgnCohN3UomoNhooPgnCog]gRon3Oi0;ogmkS1?oPgn@2omoN
h`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOoo
ool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`08o`10P003
o`11POl2?h3o042000;o042000?o0D5nogYYNOooo[404?ookJd0VOookJ_oo^n^ooko^ooGbY?o4aHU
on_QXoonn[[oon^/ooo_[oolj:7o004@o`000?nfYgkoo_jfook_[_onn[?oook5odY7=_l20@3oT8QT
oooneOoooLGoVhi[odi=B?ono[Koo?>^ooo[[oookJgoo_niojJOLol0003oBD<cooko]Oonmk?oo_>a
oool_omfLECo0004oeUD?_onoLGooo>_ooo][OookJoooO:boooo__n4Neco0004ogE_COooolWoo^^V
oo_XW?ookjOoo_fZofYT@_l00@3oO7A@ooomZ?olj9ooonfSooco[?mHDCOo0@00ojJML_ono/;oonfY
ooo[Y?ookZSoonFPo`L46OmjL4coooo6of=N@On7OUGoooj/oocUXOookjOo^ZYgo`000_l;3R7oo]^G
oooYXoonmjOooojJo`lI6ol3003obkIoooon_Ooljigo6aLVol2`O?oomjcoo>FQoocTW_onjJKoo?je
oeaH>ol1003oO7=<oooo[oolkJcol^:ToogoZomWGDCo0000oiV;I?olojkomMZSooCLW_oehZ3oonJS
ooon]?no^X?o0000oc8_9_omoicooojWonc>V_lA3bGo0000okNYN_oooZkooNfRooSPY?onjjWo^jEl
o`000?n/VW;olm:?o`d?9?oNbi7oonFXoo;JW_oagIkoooV_oogbVOl000So0000olNhOOooojkooNJR
oo_WX?oojIkoo^nNoocZW_oikjSoo<Yaoomm0OooMP3oojU6oo[/Xookj9coo>RSoocXX@02oocXW`04
oo[VWooki:3on^>Ooo[SW`;onn:O00Woo>BNoo_WX_omiZ3oo>ROoocXXoojiYooo_ZSogaXM?l0>gl0
0_l0@8001?l0@Gko0Sn0o`10P_l0@7h<o`10P00Bo`0gN_m2K9coo_kbomSIg_oNgN;ogmkSonCSj?oU
i>WocLcAogYjO?oEeMOoalO9omkMh_oPgnCogmkSon3Oi?oOg^?oh=oT0ooOg^<2on3Oi0;ogmkS0_oP
gn@6omoNh`0;on3Oi?oNgN;oj>O/onk]l_oXincod]7FonCSj?o^kO;ojn[_omoNhooPgn@01ooOg^<0
1?oNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo
00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/02Ol0@8001ol2
?h3o0420o`10P?l0@83o0461ogUZOOono[@04OookJd0Z_ookJooonj^ooWWYol011[o^Zamoooh/_oo
kJ_oooFeom?3Sol00@3o0`00oalO9oomk:Kooo6^ook_[_ooojgoJ655o`000?maJU3ooOncoocb[Ooa
hjKo3`dRolRlR?oon;;oonj/ooka[Oono[SoJfA8o`800on0N5Cooojdoog^[OoojjkooOfcoj2CJOl0
003o?3d]ooon[?ool:goonb]ook/[?ookJ_oo_^dojZNM_l10@3oDd`iooko[oookJSon^JOoo_WW_on
mjKoOG1>o`410omKDCSoo^ZQooSPX?ojgYooonNUoh=eD?l0003oMVi:ooobY?oghikon^FRook]Z?ol
kJSog<VAofaYE_oohigo/j=`o`X:8_omiZ3oonfQoocoY?nBQe[o0000o`400_n:OUKooOnYooocWoom
m9Wo824So`401?nWVfOooojWoogfZ?nQU6Oo6AX^ookWXoooj:;oo^NQooo_Y?oooIko8b<Qo`000_ng
ZGSoooZ`ooKTY_o_fj3oooj/ohV1G?l0003oM6I9ook]YOohfiooln2NooGRX?oliIoooo2]onSCV_l0
003o0@00onc8S?omoj_oZ9]ao`000_m@BBooo?nXook_[?okjZComn:Qoo;IXOohij;oTXIPobPb?_oo
ojOoLfY;ogM^CooljJGomMfMooKQX?onoJ[oa[J3o`000_l000[onm>;ooo_Y?omiiconnVOoogVX?ok
iikooNj[oocWY_ooUb[oogP2ooig0Oon_5coo>jUoocXXOomiikoo>RQoo_WW_ojiYgon^>Moo[SWooj
hj3onn:Poo_RWoojiYooo>ROoo_YXOoliIoon^JMoocXXoolj:7oo_jTog]YMol0>h7o045n0_l0@800
0ol2?h3o03n2o`10P00<o`10P00Do`0gN_m2K9coo_kbomSIg_oNgN;oh=oTomoNhooThnSoa/G:ofAS
J?o[j^ooi>?Xon3Oi?oOg^?oh=oTomoNhooRhNKohn;Won7PiOoOg^<2on;QiP04on7PiOoOg^?ogmkS
on7Pi@;oh^7V1?oOg^<2on;QiP0>onOVjonVYJ[oHV9Tojn_/Onn_/3oJ6QZogalO_nDU9Kohn?Uon3P
h_oSh^Ooh^7Von7PiOoPgn@3omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7R
i_ono_koooooookno_oooOh0lOooool3ooknoP03ooShn?o^k_3oknoa00?oknoa00Ool>kaono_lOoh
m_Oo[:^iokjka_mJLYKo0CQk00ko042000?oNFYmookn]?ookJd03oookJd0X?ook:SooNfaooo][Ooo
m;;o>cXoohImG_oomk;oo^j`oogj]OnhZWgo0002o`052olF5acoUhmZooog]?onkjcooojcoh5iE?l1
00;oFU@nooko/OonkjkoooNdoiJ<J?n9OecooOndoooc[Oonok?oo_jnochk:_l0003oYIU_ookj/oon
k:coonb]oogh]?o5]8Ko0000oa/N9ooom:Sooo6`ooo/[OookZcoonf]oo_h/oo;^hSo0002oa`O9_on
l:Ooo>nYookVX?olj9ooo_:Voi27G_l1003o=34XoooNVOooiZ?onnBQooo/YonYUfWo0000of1F?Ooo
nj;oo^bRonkOW_o<_8Woo>FQook^XOolj:7oo^ZSon?>Sol000gof<F:oooaY?oloj;oJ6=5o`400?mW
GT7o=SL_omW;R_ollZ[ooo:OodQ3;ol00@3oWXeRoogjZOookj7oln6Io`014?njZWOooon/oogYX_oo
oZComMV6o`000_l0003oeL:8oo_XXoobgYoolmjOooom/?nHT6Wo0002oeE=>?ongioolmjOoo3NX?oa
gJ3oln2NooWSYoonjioo10/No`000?o4]8?ooOniohAgEol00@3oMfe:ooknY_oagZ?okmZQongKWOo]
fYool]jOoncGW_o5]83ommnOolNfP_lE62Ooi=6Goo_QY?ooh:3oo_naoj^MK?l000;o8RLSook`V?on
lJ;oo^fMooo_Y?oolK3oo>fZoocPUoolZD?oogP2ooih0?ooQ0gonmJ5ooo[Y_olj9oon^RNoo_WX?ol
j:7ooNJPoocSX?okhYoon^6Noo_TW_onj9l2oocXX@09oo[VWoojhioonN:NooSSX_omj:Oooon/ogeX
NOl0>goo042000;o041n00?o0420o`10O_l0@8003?l0@800;?l0=g[o@VbLooknl_oHfMkog]gRon3O
i?oOg^?ohn?UolO6bomNGUkoi^GZomoNhooPh>;ogmkSon3Oi?oOg^?ogMcQomcLg_oMg>7oi>?XomGE
eooBd]CogMcQonGTjOoOg^?ogMcQolg<dOoFe]Soh=oTon3Ph_oOg^?oh=oTomWIfooDe=Kol>oeogAc
N?m`L73oN7QjooknoommOGgoKfm_odm?DOoNgN;oh>3R0_oLg=h02OoNgN;ogmkSomoNhooPgnCogmkS
omkMh_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo
0oono_h00oohn?Sok^k`ono_l@03ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`0>o`10
P003ogUZOOono[Coonf]00ooonf]09goonf_ook/Z_ookJooooVeojjQMol71AgonnV[oooa/?oookGo
QGeIo`800om1>b_ocKJ0o`L87OoUf:7ooo:aookn^?nNTFko0`02oc<g:Oook:Ooo_2_ooke/_oTdi_o
004Eoe]EAOmWHd[oKF=8oemI?ol100Go0@00ok^]P?onnKOoon^/ook/[?onmKCog<bHo`020?l00@Ko
k=JMoogb/_ookZcoo^^`ook/[_ool[7okmJPo`011_l00@3olMjJooke/_oojIooo^ZQooooYOnm[7Ko
0000o`005oobeiCoon^RooSTWoonkJGo`:ilo`020Ol^;BSoo_ZGooomZ_o@`XGo0005ongMT_onlZKo
o^bToocXXoonk:CoB4I9ojjNKOoooZ_ooonKobl_9Ol000Cod/EfoiJ:H?n2ME?ooo^YoogoX_mRFcko
0004oi64F_oonZSon^>Mook`YOnWUV_o0@0DofeRA_mPFTCoKFA7odi8<_l0003o?SdYooklYooiiJKo
kmZQoo3KW?ooiJSoZII^o`<00?lK82Col/fIooSIXooaeYool]NOoo3HW?ocf:3ooMZPoe58=_l0003o
ZII^ooonaomcJTgo0000og]bDOolhj?ol=ZNonoIWooagJ;om=^Roo?KVoofhJ3om^2TonoIWOodh:7o
LfaBob@[=OmTG4OoG5Y1ofeTAoln>BKo0000ofmYAoonoZKoo^fMooo`ZoonjZ_ooM1ooon]BoooSQco
ogT0oomg0?onN@3ooKQKooWVX_oki:3ooNBQoo_WX?oliY_onnNNoocXXOojiYoonnBN00;ooNJP00co
mn>NooWRW_ojhIkon^6Ooo_OX?okh9gonmnNoo_OX?olmJGoOFQio`0kOol0@802o`10OP03o`10P?l0
@7ko042000co042000Co03Mjod9/W?ono_;of=WN0_oOg^<01_oPgnCoi>CVolK5b_mMGEgoi^GZomoN
h`;oh=oT02;oi^KXolS8b_l10@7o0000ogYjO?o>cM;oKFe]o`T92OlG5aWoalO9onk^l?mfMWSoBTY:
oalO7oo5a<Woi>CVomoNhooSh^Oo<30boe]KGOo9b<goVIRMod10?_nEU9Wolo;hok2_]?ln?SkoPH61
on[Yk_o2`LOo0@41o`000_n1PH?okNca0_oOg^<01OoPgnCog]gRomcMh_ono_coEW^W007o03Ii0000
1on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool3ooknoP03ooShn?o^k_3oknoa00?oknoa
00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00ko042000?oNFYmookn]?ookJl03oookJl03ooo
kZkoonb_oog][ooolK;oj]^Po`410oo?`XkoooRgooco/?mIE3ko0000oe1>=oooon?oMFiAoj6CL002
oogo]P0<okJ[OOl000;o0P0HooCGWOonl[GooNf_oooi]OmUH4go0080oiV=IOnERfOoN6m@0_l00000
O?oDbI?ooOBaooo^/?omkJooo_2_oooTYOl:327o0@02olc1RooomkKoo>b^ooo][oookJgooo2book/
Y?l>41oo0000olNeQOooo:[ok]fHoo3NW_onlYcohlMno`801_l000Soi/V=oog[Xooki:3oonjVolnl
Q?l0003o000BonoEPOokoico[j5`o`420?oQd9SoooBdookX[?oki:3ooo2ZojbNKonDR5koooj]oo?A
ROl100ko0000on35O_oknYgo<blnon7=S_olo[?oP7=Ao`000?n6NUCoooZVoo_RX?omjJ;ol]ZLo`H8
7OmcID[oUH=Moi:5H_m0>R[o0@43og5XBooml:[ommfPooCLX?ojfj;oonBUokVTNOl10@3o0008omZn
S?oohZCon=VPooCIXOohfYkol]VPookRXomdJdko0P03ohYkF_ono/coPgQHo`400?mWFd7oo_2Uoo_S
WOoiiJ3onnJSooWWZOoafj;om=ZMoo;MW_o/f9gom^BVojnPMOl00@3oP7QDohj0GOn:PESo3a<Fo`00
0_nOSFGoo_bYoocaWooldX3ooY`aooin0?omMP3oogH4ooie0OooN@3ooj@mooORWoohiJ3omn>Noo[S
WookhZ3ooNBQoo_TX?oliIl2oo_WX00?oo_WX_ojiZ7onNFNoo[SWookhYoon^>Ooo_TX?oli9konnBP
oo[SWoono:GoO6Mho`0kOol0@83o041n00;o042000?o041no`10P?l0@8002ol0@8002ol0=g[o@VbL
ooknl_oHfMkog]gRon3Oi?oOg^?ohn;WolK5b_mNGUkoi^GZ00?ogmkS01koinOYolG5aOl0003o0000
ofi^L?nJVIko[Zfboi:BU?lj>Sco][JhoogmoomfMWSod=3Boh>3QOng]kWoinK[on3Oi?oQhN?oNg]m
okFe]omeMGOof][Lon[Yk_oViN[ogMcQonGUiooXincoinK/onSWk?nm_Kl2o`000003og1`L_o_ko7o
h=oT00?ogmkS00?og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooom
oP3aooooo`?oo_kn00?on?Shonk^l?o_ko400oo_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1
>7/03_l0@8000omiJWgoo_jdooo][`0?ooo][`1]ooo/[oomkZgoonb]ook^/_onmKCo?Sa1ohf3Goon
ok_ooonWocHd:?l100;oHeY8ookoeOoAa8go004EonSIX?omo[[obKV8o`000?l1003ogLbHoood/_oo
kJgoo?Neolo3Sol^:3Coo_JSoocnlOoLahKo0000oalS9_oolZ_ooo6eooo[[?ookJgooNj]ooko[omE
C3[o0002okFZO?oon;Coonj`ook/[_ookJgooNn`ookf[Olg>bco0000odI3<?mYHdWo;c<lob/_>_m<
D47oGePno`000?l1003od/:7ook[Y_oliIooonjRomg:Q_l000[o0@00oeiG?Om]IdOo0P0=o`000?o?
_Hgoo?6aoogUYOohiYcooN^Qomk<S?mRG4cooOjQokb`M_l0003o0045on_9R_oooZgoP7QAogm`Coon
o/[oUhMSo`000?mcJ4coo_FVooWPW_ohfiooonfUohImE_nCQ5goo_o<oooobomECCSo0@00oj6>I_on
jZGonN2MooSTWOokhj?oonJTomG3Pol100;o0000olVeP?ookZWomn:OooOVX@02ooONWP0]ooghY_nD
S5go0000of]QB?omol;o[9U^o`000_le<bOoomZIoo_RX?oghZ7onnVQoooZXOoiiZ;ok]RLoo?KWoo^
g9cojmRNon7AU_ld=cko/:5foogoeoooojoo71dHo`010?o7]Wkoo^fUooc^YOoo/DcooW40oome0_oo
M`3oogh2oojD9_ok^f?on^6OooWTXOomhJ3onn:Poo[SWooliJ7ooNBRookUX_oliIoonnBN00;on^JQ
00kon^JOoogWW_oliYgon^>Moo_TX?oliJ7ooNNLoocXWoojiYgooOfSogaWN?l0>goo0420o`10OP;o
042000?o041no`10P?l0@8002ol0@8001?l0=g[o@VbLooknl_oHfMh3omoNh`0Non?Rioo6aL[oGUiN
onOVjooOg^?oiNGWon?RiooYjN_ob/[<o`T92ol10@?oQHF7om;Ae_n>SXkoMWIfog]kOOnKVigoo?cn
ohJ6R?m1@D7o;Rh^olW9booUi>WogmkSon?SiOoFeM[oPX:4oa0@4?oAdM?ohn;W0_oPgn@2omoNh`03
on3Oi?oWi^_oa/K800;o000000CoS8b>onc/k_oNgN;ohN3U0_oOg^<00ooLgN;oo_kloeIkY`01o`0f
N@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo0oono_h00oohn?Sok^k`ono_l@03
ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`0>o`10P003ogUZOOono[Coonf]00ooonf]
09ooo^b/ooo/[oonk:coonb]oooh]?n]YGOo6APZooon/OommJ3o5ADMo`000?n2O5coooniooko/olP
7bgoP7MHooonboomg9Wo0040o`000?o8^XWoooNhoooZ[_ook:ooooRgofm]E?nESFKoookYohQmGOl0
003oJ5i5oogo]?omkZgoo^n^ook/[?ook:ooo_jdogQ_D_l0003oTXQToooi^?oojjkoonf]ook/[_oo
k[3oooj^oe=>>ol0003oOW=EooKJVOoLb8WoflN:omk:RooheXco?CXWo`810?o1/7SoonnToo_XW?ol
kj7ooN2Lo`005Ol0003o[Ymfooo`X?nhWWWo0040ojRFK_oniJ?on=nLoocUWoolj:7ooN2LobHW>OoA
_XCoYiAZo`000_l@4Qkoo/^DoooPYooN_i3o0@0:on>kR?neVG;o0000oeE==_oneikonMBMooWFW_oo
j:;odkj7o`015_ofcY3ooonKo`066?l1003ock^8ooo/Z?okhYoomnBPooORXOonk:;oo>:Go`P?8Ol1
003o^:9cookYZ_oghYoom]nKooSQW_oifioooo:TojNJK_l00@3oAT<`ooonX_omgXko0P0Ho`400?o=
_8Coo^JPooGHX?odfYgon^>Ooo[YXOoli9kok]RLoo3JW_oZeicolN6UojBHK_lF5bcooOn[omBdNol0
0`?o000JooWKToooj:;onnV[oog0IoonN@;oohTCoobV@ookagCon]nJooWWYoojhiooo>FRooSUX?oj
higonnNNoocUWoojii_oo>JMoocUWoomiIooo>JMoogWW_okiih00_oiiI`02ooiiIkon^JOooWUX?ok
iIcoo>JMoocTW_onn:;oO6Mfo`0jO_l0@83o041n00;o042000?o041no`10P?l0@8002ol0@8001?l0
=g[o@VbLooknl_oHfMh2omkMhP0:on3Oi?oSh^OoalK;oeeMGOoWi^_ohN3Uog=cLol`<3;oZZZ/on[Y
kP;oinK[02Gohn;WonOVjoo:bLkoP822oclo@Om5ADGoemOGonCTi_oKf]ooh=oTon7QhooPgnGogmkS
omkNh?oWi^_oWYjPodA4A?oDe=Koh^;TomoNhooOg^CogmkSon3Ph_oOgn7ogmkSon3Oi?oVi^Soj>SZ
on?RiooOg^?oh=oTomkMh_oOg^?og]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_on
o_koooooookno_oooOh0lOooool3ooknoP03ooShn?o^k_3oknoa00?oknoa00Ool>kaono_lOohm_Oo
[:^iokjka_mJLYKo0CQk00ko042000?oNFYmookn]?ookJd03oookJd0XOookJooo^b^ooo^/?omkJoo
oo2bonGFWOlP8S7oo_JUoooSUOl00@go0@40ojbQLooooK;oooJholNkQol10@7ohm>Hoogn^?l02ASo
0080ok>TNoomm[;oonf[ook^/?omlkGod/RCog5YD_ooolkoIUi7o`010?nES6GooOncook^/?oojk;o
onf]oog][oomn[OoVheZo`000?m^J4Soo_baooo^[_onk[3oo^b^ooo_/Oonok7oKVM;o`400_n0Me[o
o_jdooo]XOookj7oonbUooknY?mWHCoo0000oif;IOooiJ?on=^OooWOX_ooi9oo<cDXo`410?n_VVgo
oonUooonY?lf>CkoL75?ooodY?oliY_onn:Poo_TW_ookZKoMG5>oiN9I?nFREoo0000oe59<_ool9oo
n^6NoocZZ?n7NECoLVA9onG2O_l1003o;c4VoooQW_olhj7on]nLooWRWooojZOoIf9>oi62Foogf8Ko
0`00o`045ooVd9CoonBSoocUWooehIconNJJoogXYOonlj7oB4<_o`410OnUTf_ooNJSooGRW_oggYko
nn>MooCKVoookJWo/j9do`400_l32Q[oomfCookn]?mVFdGo0000ohAgE?ooojOoo>VLooKQW_ocfIco
l]RMooKNW_ogiIgonN2Poo;JW?o/fJ7oimBLob0S<_o0[WcoZim_o`400?mBBSGooO>NoooWXOokj:Co
oLIcooj10?oiaW?on^JdooSYZ?oiiZ;onnBNoo_TX?okiIcoo>>PoocZW_oljiWoonjLooo]YOokij3o
nnBNoocTW_oliIoon^JMoocXWooljIgon^RN00;onnVM00Oon^RNoo[VWOojiYooo>FOooonX_mlIgKo
03]o00Co042000?o041no`10P?l0@8002ol0@8004?l0=g[o@VbLooknl_oHfMkog]gRon3Oi?oOg^?o
i>?XolG4bOm]KFgoj^W^omcKh?m@D4koIFEUoi2@T_o]k?42on3Oi006on7QhooOgn7oj>O/omKEf_n8
QhcoWijT0_oPgnD00ooQh>Goh=oTomoNh`02on3Oi005omoNhooSh^Oob<O<ol;2a?oThnP00_oOg^<2
on3PhP07omoNhooOg^Coh=oTomoOhOoQh>Goh=oTon7Pi@04omoNh`04omoOhOoLgN;oo_kloeIkY`7o
03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool3ooknoP03ooShn?o^k_3oknoa
00?oknoa00Ool>kaono_lOohm_Oo[:^iokjka_mJLYKo0CQk00ko042000?oNFYmookn]?ookJl03ooo
kJl0H_ook:goo>n[ook/[?ookJ_oonfboocd/on4Ne[o`;F7olN_Ool000;o0000omK5TOoom;Goonb]
ookf]omNEdgoN75Dooolgolo?2Wo0040oiN9I_oomkSoonbaooo][Oonkjcooo6`og5]D_nUVG7o@Ch_
o`000?o6]XGoooJcook_[_ool[?ooNjYooo][Ooon;Co_K5oo`010?m?BSOooo^aook`/Oonk:coo^j`
oogd/OoooKCoThaRo`400?m[I4Soo_jToo[VWOoiiIcoo>BLooobY?n9OEOo0004ogU_C?onl:GonnBN
oo_SVoonn:3oJ5doo`000?nJSf7ooonWookcXooA`h;o`;AgoooZW_ook:?onnNNoo_RX?ook:Oo`kAk
ofAK??mQFSko0P01ogidD?onoZKonnBNookWXoo/fY;o=T0hokBPK_l12Poo00XJooSKUOolj9oonN2N
ooWPWOomiZ?oflF;of]R@on@PF3o0000oe=>>?onm9oonmnP0_omjJ00=_ofj9oonn:Ooog[XOmYHTKo
0002oi9oGooniJ;om]nKooKNW_omiIoon]fQoocYYOo4/7ko0044o`011_o]a8koo?o:ojnRN?l00@3o
000DoooIV?ookj;oo^nJooc[VOogh9colmVLoo;EVoo5[gkoi/fEoo?KWooehJKoZIa`ohYlEommKToo
0000ohAhD_oooZWooNJRoo[WYOohdh?oohL2oo^mI_oijJgonnBPooWVX_oki:7onnZRoo[VWOojiYoo
nnRKoog/W?oljJGooNZXoo_VX`?onnBN00?onNFNoo[VWOojii/00_omii`02?okj9coo>ROoocYWOoh
iYcon^JMooonX_mmJ7Oo03]o4_l0@8004?l0=g[o@VbLooknl_oHfMkog]gRon3Oi?oOg^?ohN3UomkM
h_mUIFGob<O<ooclo_nRXZ;oOGeool70aOoUi>T5omoNh`06on?Rioo]kNoojn_]on3Ph_oPgnCogmkS
0_oPgn@4omoNh`07on;Qi_oViN[ogmkSomoNhooPgnCogmkSomoOh@02omoNh`06on3Oi?oOgn7ogmkS
on3Oi?oOg^?oh=oT0_oOg^<01OoPgnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7R
i_ono_koooooookno_oooOh0lOooool3ooknoP03ooShn?o^k_3oknoa00?oknoa00Ool>kaono_lOoh
m_Oo[:^iokjka_mJLYKo0CQk00ko042000?oNFYmookn]?ookJl03oookJl2ooo//@2Cooo[/Oolk:ko
onf_oooh]onRVG;oSH=Poi::IOl0003o3a<OooOMX_omm;?ooNf_ooof]OoDbI?o6aPYoooo]OmLDd7o
0000oh5kFoomoK?ooNf_ooo][oomkJooooNholNeQOlM72co0080o`401OobeI_oo_flol2bQOnHT6Wo
o_Fjook`/ooolkKogLRAo`000_l>32;oo>RSoooa/?ookK;oonj^oiB<J?oTeIko]:Qno`400?mHD3_o
o_RPoocVWOohi9_on^6Nooo[Y?nQU6Oo0@00oeeC>_oolj7onn>Moo[QW_omlZ?oQ7ICo`000_moM5Co
ooj/ooSUXOokij3ooNVPook]YondY77o]jMcookZXoooiiooonbMoe]D>_l100Ko0040ojFIIOolljCo
n^>OookXW?oomZOoX99UogI[COl`;Aco0@0>onK6SOoniJ?on^6Noo[SWOojhZ;oo^ZSoif>HolA5Q[o
0000og]cCooomZ7ooNBQoi68Gonn[GGooORToo[QWooomJ?oRGeEo`000?mZIDSoonVQoo[LW?olj:?o
j=NAoiV7HOoof9gom/f;o`002?l00@3ohkf<ooko]oooi9ooJEY3o`000?n<OEcooonWook[Woomk9ko
n^RLoog[Woo[eY?o824eom2lR_ofgIgomM^NonSEV_mQFDCo00<Do`000?nbX6koo_RRonC<S_oggioo
n>6MoonA6?omXSOon^Bcoo[SWookh9WooN2JoocWU_ojiYgomnNL00;onNFN01?onNFPooSSX?oihYko
n^>Moo_UW?okiI[onNFLoo_TW_oki:3onN:LoocVWOokj9con^JMooSTWOofhYgon>BMooonX_mmJ7Oo
03]o01;o042000Co03Mjod9/W?ono_;of=WN0ooOg^<03OoPgnCoj>O/okBd]?n<Ri3oW9bNol;1a_oe
m?Woi>?XomkMh_oPgnCogmkSon3Oi?oOg^@00_oOg^<01OoPgnCogmkSon3OiOoOg^?oh=oT00;ogmkS
00Goh>3Ron3Oi?oPgnCogmoQon3Oi005omoNh`;ogmoQ1?oPgn@3omoNh`;oh=oT0_oOg^<00ooLgN;o
o_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooo
ooono_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`0;o`10P005o`10
O_l0@83o0D61ogUZOOono[H04?ookJl05oomkZgooNf_ooo][ooojk3oonf]ooke]?oGb97oDdXhocll
;Ol000;oD4/googn[_ookk7oonbaook_[?onm[OoM6m?ohUnG_mlMUKo0002ofYSBOonok7oo^j`00;o
onba013oonj`oogk/?mXHT[o0002od0n<_onnjcoooJeomg=VOl0003oXYA]oogo]_ono/3oo_jno`lB
8Ol1003okmbH0_ooo/D0P_o1]8Oo0000ooonYoonoJ7o0002oa4F7?oooY_ooOJVoooYW_oiiIcoo?nV
omNjP_l1003o71dQooooVoook:Sonn:OooooYon]VVoo0000oe]A>?omojWoo^ZSoooXX_omojWoa[9m
o`000?nHSUgoonfUookXWooooK3oVHaRo`010?l0003ob;Emooo[X_omjYgooNjKook/X_oYe97o>C`Y
o`002?l000CodKN4oogoZoonj9oonnRLooWPWOoniZKog<B8o`020Ol1003oRh5NookUYOonk:;oXiUT
o`400_o:/ggoooj[ooko/OngYgKo0@00ode8=?oooJ[ooo:Too_oY_nBQ5go7Q`dookoXOomojWo:bdP
o`000?o;]h;ooOkBoooZZOoadiGoFUDho`400_n@P5coon>QooORXoobgigoon^Zokj^Nol00@3ock^8
ooOOWoobf9_on^6Ooj2AJ?l0003o0008onG;POn]WFcoMW=@ok>QLOofh:CooZm@oomo0?onVBoooYX[
oo^E:OooUBOooILXoofI:_onaFkonnNPooOUVOohiYkonnBNooKMVoohg9_on^:Loo[TVookiIcoo>BN
oogUWoojhIkonN:LoogWW?omjY_onnRKoo_TW_ojhigooobUogYXM_l0>goo0D5oo`10P?l0?gl?o`10
P00@o`0gN_m2K9coo_kbomSIg_oNg^3oh=oTomoNhooPgnCogmkSonWYjonc/kGo<c<eokjm`_oViN[o
gmkSon3Oi0?ogmkS00?oh=oTomoNhooOg^<03_oOg^<3on3Oi0_ogmkS00Goh=oTomkMh_oLgN;oo_kl
oeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooon
o_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`0;o`10P005o`10O_l0
@83o0D61ogUZOOono[H04?ookJl00ooojjooo^b^ook^/P02ooo//@2Vooo`[oomo[;oFeI2o`400?l0
003oN7AAoool^?ookJgooNf_ooo[/?oomkKobK^<obXZ:_m]IT[o0@00oe58=_omo:[oonj^ooc^/Ooo
kJgoonf_oooe]OoJbYKo0000ogAZDOoon;CooNnbookn^?n@R6?o0040og9XCono/HCo^Jaoo`L:7Ol0
003oPgeKolZjROnWVg?o0081o`425oomi9CoUXiWo`000?l10@7oRGeGoljkPOo`g9OooNJPom[6Ron;
Peco0000o`010?n;OUCoc[anoo7ITooHa8WoN6]9o`400_l000;oX8mQokjZMoo9]7_o]JQao`003?l0
003ob[Elooo^Z?o/fIGoc;b1ofAK??l10@3o004@on;?SOoolZ7ono6Hoog[VOofhikoo>jSohQjEol0
003o0040og9TBOo?^h3ojMJDoooZXOojiJ;oo>2Qooo]XomfIdKo0P01ojZLKOooj:;ooNNNookgWOl0
1R;o0080oi63G?o1/7SoS7aHo`010?l00@GoXI9YoknTMon1M5Co0002oh9dDOoojYcoZ9U^o`006?l1
003oFU<iolRjROoFbICon>>PooobVOm3@3Oo0040of=KA?oC_hgoiM>EolRdPOl00AKo0002okBVMooi
gjCol=RLooGJX_onfYco7AdYo`002OoM`X[oR7mDoc`j?on6OUWom>6Oooc8L_ooN@3oog00ooma0Ooo
L`3oo7<1ooma0OooK@3oo9/dooOIWOoeeYgonN6Koo[WV_oiiIkon^6NoocQW?oji9_on>BKooOSW?ol
i9koo^>NoocUWoojhigonNFNoocVVoomii_onnRKoognXOmjJ7Ko03]oo`10OQ7o042000Co03Mjod9/
W?ono_;of=WN0_oNgN82on3Oi005omoNhooPgnCoiNGWonk^l?oSh^L00ooOg^<2on3Oi1KogmkS00Co
h=oTomoNhooOg^?oh=oT1_oOg^<01OoPgnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBc
on7Ri_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>ka
ono_lOohm_Oo[:^iokjka_mJLYKo0CQk00_o042000Go041no`10P?l1@H7oNFYmookn]P0@ooo][`;o
onj`00Koonf[ooo][OomkJooo_FbookofOnER6D2o`00002CoifEL?onn[?oo^j`oog_[_ookK3oonf]
ookk]_m_J4_o0PHBo`010?la;b;ooOngookn^?ool[7oonj^ooo][oomkk;ooo:cofUVEOnQV77oooJe
ooo^/?onm[GodlRBo`010?l0003o92Hboc8_>?lU:Rko9bH^ob0S<_lZ:CWo4aDRo`010?mSGDGoNW=G
o`8:7olZ:bgo92PYo`<15ol00ACockeoooOSV_lo?T?o000BobPY:olU9R_o004@o`lI9Oo?_8;oJVm?
o`804?l^<2go8BHYoaTL;olE6Rgo3aHYo`<;7_l100Ko6b8bon?>Soool:Soc;V1o`006?l:42So0P4Q
oemK@?ogiYKooO6MooSVV_oji9_omn>Looo`X_oPeXko<Bl`o`/=9?lA6bOo004@ok^/LooklZOonNFV
ooONW?ooj:;oe;V4o`814Oo?_87oo^JPooSUVOookj[oZI]/o`001?l00Ago:2/bob``;ol_=B_o72HW
obTZ;olN9S?o0P@Io`010?n]UFooXiEXo`005olK82Ko=3HYo`L98_l100coU8YWoo3JX?ookj7ooNjI
oiN;HOl20A?o000HocLj?ol301[o:20eohYjF?o</H;on]^Roo3FVOo]eIWoo>2OojVGJOl];c_okMRE
okVXL_mfMeOob;=nookRXooiehgooi/aoo^>6OooTB;ooI4ToofC8oooUBGoo8T:oon70?ojdXcomMZR
ooSJV_ogh9[omnBHoo[WVoojhigonn:O00?on^BK00_onnFLooWUW?okiIconn:PooWKVoojgI_ooNFK
ooooX_mlJWKo03]oo`10OP0Ao`10P005o`0gN_m2K9coo_kbomSIg_oNgN800_oPgn@3omoNh`?oh=oT
00Gog]gRomoNhooPgnCoh=oTomkMhP0ComoNh`;oh=oT1?oOg^<00ooPgnCogmkSomoNh`04omoNh`05
on3Oi?oNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3a
ooooo`05ookno_ooooooo_knooShn?o^k_001?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6oeYbU_l1
>7/02ol0@8001Ol0@7ko0420o`51POmiJWgoo_jf013oonf_09_oonj^oog][oookJooo^nZook^/_oF
aY?o/jIjodI0<?l0003o0040okjaQ?onnKGoo^jboog^[OookZkoonj`ooke]?oLdIWo0`00o`010?l2
0@3oPGQKokjaQ?oVeIooo_2aoog_/_ookZkoo^j`oocZ[?ojjZcooNn^ook^/?ook[3ooN^[onkIX?oi
iZ_omnBYooOUYooojJgooO2/oo[XZ?oeiJOoo>R[oo;RYoo]gj;omN:Xoo?SZ?oojJ3oo^RLoo?MU?o]
f9Gom^BHoo[VWOo^eI;okm>DookTVOoom9komNBNoo7RXOofiZ_ok=>Jonc@TOoofY_onmbIooGJUoo[
f9?ojMBAon_FToo`fIGol]VFooOPV_oiiIkom^:Ion_FUOodgIWon]nHooOWVOokj9_om^:KooSOW?oj
gicon^RLook^VOomk9[ommjLoo[SUOogiI_ok=RCooGQV?odh9_okmZIoocOWOoih9gonN2NonoHU?od
gIWonn2KooWUW_oigY_om]^HonWAUOodf9WolmREoo;IU_onii_okMBKonO<UOoWbIGomMJFon_BT_o]
cYOokMFEomK6T_oYdIGoom>Hong@V?oXcY7om^:WonoKW_ofgI[ooNjKoo7MX_oSci[of;n9omBeQ_oN
bXoomn2LoooZWooliYgomnBHonkIV_oQdYWoimBJoo7IVOo`eiCommnIoocPWooggY_on^6OooSOW?oi
h9gonMbFoocKU_oigI?onmfEoo[PU_ogh9[onMR9oojeE_ohfHWon>FQooWKVoogfi[olmZHooKOV@02
ooWVVP;onn>M00con^BIoo_SVoojhigoo>JMoo[WVookiI[onN>JooWSV?oooJ3oO6Yfo`0kOol0@7hA
o`10P004o`0gN_m2K9coo_kbomSIgP?ogmkS00_oh=oTon_Zkoo[j^oohN3UomkMh_oOg^?ohN3UomkM
h_oPgnCogmkSon3Oi00BomoNh`03on3Oi?oOg^?ogmkS00;oh=oT0_oOg^<00ooPgnCogmkSomoNh`04
omoNh`05on3Oi?oNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_kn
ooomoP3aooooo`05ookno_ooooooo_knooShn?o^k_001?o_ko401oo`k_7oknoaooSfmon/ZkWo_[_6
oeYbU_l1>7/02ol0@8001Ol0@7ko0420o`51POmiJWgoo_jf013oonj`0:_oo^j`ooo^[_ookJgoonj`
oooa]?mgLF7o0@00ob0T;ola<C7o:2Hdon3DV_onlk7oonf^ooo]/_onkjkon_2[ooo^/oomm[;oS8QS
o`h?8Olg>S7o2@`Mo`000_n_Y7KoooJaook_[_ook:ooonj/ook`/OoolK;oonj/ooo//Oook[3ooNn`
oood]oonmKCoo_Bfooca[ooml[;ooo6`ooga]?oolK;ooo>dooof/oonl[Goo_2_ook_[_omjJ;oo^^N
oooZWoonjZ?oo>JMoo_UV_okj9coonfNooo^Y?onk:koo^JZoo[OZ?oceYkom]JMooKFVOoff9con]jO
oo_UV_oohiooo>>PookTV_omi:7ooN2Joo[RW?oliYgooNFMoooSWoooj9coo^nLoo[SWOohgI[on>:I
ooGEV?off9[onn2IookSW?oihYcoo>VLookcV_onj9coonJLoogZWOoghi[onnRKooSOW?oegY_onn2M
oooSX_oig9[omn>Loo[RV_oifY[onnFLookVW_okgj3ooN6PoocPWoo^fY_omMRLoo?IW_obdicoo=VQ
oo_RWoojeigojm:JonWBW?offIoojmBNoo7DV_oifY[oo>6NongKVoo`fIKom>2Ion7@V_o/eY[onm^N
oo_OW_okgIgooNFMoogZVoonkYWoon^HonoLV?oMd9WoiM:Joo3GW_okgj3onmjLooKOVoolhI[onn2M
ooKMV_ohgiconN:LooWTXOokhigon^>Ooo[SWOohi9gomN>Qoo[WX_oiiIcon^BIoogSVOokhigonM^M
ooKJVOoghISom^FGooWVV_okhi_ooN:KooWSV?ojhigoo>BLooWSV_oghISomn2JooOQV?onnIkoO6Qd
o`0kOol0@7h04Ol0@8003_l0=g[o@VbLooknl_oHfMkog]gRon3Oi?oRh^CofMWKoiNGVOnEUIOoemKK
on?RiooPgnCog]gR0ooPgn@IomoNh`03on3Oi?oOg^?ogmkS00GogmkS00Goh=oTomkMh_oLgN;oo_kl
oeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooon
o_kon?Shonk^l004ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`0;o`10P005o`10O_l0
@83o0D61ogUZOOono[H04?ook[004?ookK3oonf_ook^/?ookK?ooNn`ooOWZOodhJOon^Z/ooo[[?og
ij_oonfbook_[_ook;7oo^n^ooo]/?onk[02ook^/P06ooc]/_ofiZ_oon^^oo[W[OobgjGon>RZ0_on
k[80T?oom;Ooo?Bfooo^/oonl;7oooBdookc/oook:gono6dookc/oogi:;ooN^]oooa/_ool;Cooo2g
ook^/?onm[Gon^fYooWUY_ool:oooO>foo_WX_oggI?oon^RoogTXOoji9_oo>JJooOOUooeg9col=RJ
oo?DVoocfIkol]>JooOKW?ohh9[ol=F>oo_PVooihi[on>:GooSRVOojgicooNFMoo_PVOojgi[oo>VM
ookUX_offiConnBQoo_YWOoihiOommZHooGDW_oheI_olmFIooGBV_obdi[omMFJooWMW_ojhIkon^BH
ooWVVOolgigonNFLoo_ZW?olkIconn>KooWNVooggiWonMjKooOOVOohgISonnBNooWLV_oig9Son>6K
oo;JV_offYWon]fIooGIV_oYe9Gon]NMonOGVooPciOokm:HooOJV?ohf9_oj/nJon[?Uoocdi[ol=6J
onk@W?o/dIWon=JIoo7DW?oVdi_ohm>GomkAV_oYdiWol]:EooOSV_oaf9KommVKoo[TVOoljiWooo2K
ooCUT_oRdI_ohm2HoncFW?ogg9Oomm^JooWNVooegIOon]bLooWNVooggYconN6KooSQWOoih9gonn>I
ooGRU_oihI_omn>Joo?QUooihYcon^2Foo[TVookhi_oo>BLoo_PVoojgicommnIooKSUoogi9Son^BK
oocTW?ojhY[onn>Koo_TW_ohhI_on>2Joo_NW?onk:3oNVEdo`0jOQ;o042000Co03Mjod9/W?ono_;o
f=WN0_oOg^<01ooTi>KodM7Co`000_mgMgWoR8R:onSWk?oOg^<00_oPgn@01?oNgN;oh=oTomoNhooP
gn@BomoNh`;oh=oT2ooOg^<01OoPgnCog]gRomcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7R
i_ono_koooooookno_oooOh0lOooool01Oono_koooooookno_ohn?Sok^k`00Coknoa00Ool>kaono_
lOohm_Oo[:^iokjka_mJLYKo0CQk00_o042000Go041no`10P?l1@H7oNFYmookn]P0@ooo][`1gooo^
/?omkK7ooNnbooo]/_ook[3oo^j`oocc/_ool;;oo_2aoooa]?omkK7oonf]ook_[_onk[3oonfboog]
/OookJooo^j`ooo_/OoolKCooo6`ook`/Oool[?oo_2_ook_]?onjZ_o`hQ4olF>COookk7olm>FokA<
1OoM]GOooORhooWTYOo=UESo_WLeol=n>Oobf9gohKilolbFE_ookkGoj/J8okUG5_nmEQ?ok=2?onoA
TonkMc3o^F0JoljEC_oehISoeJQUolR=Aooaei[o`895om^_K_o^b8Oo_gDfoo;KSoo`dH7o`X8kol63
>_o<TD_om]bBooSVV_oji9SoonBOonFoM_nbAPKof:USooKLT_o1PSgo]elPolN6A?o`dI3onMVNooGB
V_ofe9OomM>FooKFVooge9[om]JIooSKUoojhY[onN6KooSMV_oihiSoo>:Hoo_XW?okjYSon^>GooGL
VOobgi[omm^Joo[MVooggYcon]fKoo_PVOoigYOonM^KongHUooag9_om]JIooKMV_oefISolmNHooKJ
VOo/e9Kokm:HonSDVOoae9[ommNJongCV?o`dISomM2IooCAUoo`d9Ool<nIoo7BVOobdiX00_oUdIH0
<OoMd9_okM2Foo?FV_okh9Wonn>Koo7HV?oefISonN>Hooo]VOolji_ohM>Fomg>Uoo]diSol]VGooKM
Voohg9gonMjGooKMVoofgi_on]fKooOOVOochIWomMjHooWQVoofhiOon^2Foo[QW_ojhYSol^2DooGQ
W?ohh9[oo>:HooWSV?oihi[onn>Koo_PVooih9gonN:LooOTUooihi[on^BIoo[SUooji9_on^>OooWR
W_ojhY[oooRNogUTLol0>X004_l0@8001_l0=g[o@VbLooknl_oHfMkog]gRon3Oi0;ogmkS00Goi^KX
ong]kon0P8;o^[ZlonOVj`02omoNh`05on3Oi?oOg^?oh=oTomkMh_oPgn@04OoOg^<00ooPgnCogmkS
omoNh`02on3Oi003omoNhooPgnCogmkS00GogmkS00Goh=oTomkMh_oLgN;oo_kloeIkY`01o`0fN@00
00OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knooooooono_kon?Shonk^l004
ono_l@07oo3^lOo_ko7on?Kgojb[^Onn^lKoFW:Fo`4hN`0;o`10P005o`10O_l0@83o0D61ogUZOOon
o[H04?ook[003_omkJooonfbooo]/?onk[;oonj^ook^/_ookK?oo^j`ooo^/?omkJooon^booo]/?om
kJooonj`0_ookZh0?OomkJooonf_oog^[Oomkk3ooNf_ooo]/_ook:goo^jboooe^?o/cXkoYb02ojPe
0?oghjKof:a]oih00?nnO3ooo_oEomBRHondHAgojlf?on>mO_oggJ;oeJ=TokIM5oogijWo]EPColR:
COo`e9Gol]^HokAH5Oo8S4goj<9kojm72_oCYV?ocYADok5R8?oljj?o[d`8om>QF?o[a87oYRH1onc<
POnmPCSoahI4onS6OooP^Voom=f?ook[W?okhi_onnNNokeh=OngM33ommfCol:2>_nnMcGojlR4okE[
:_o4Q4Con]jMooWKVoohg9d00ooigYT0BOoigY_onmjJooOOUoojgI_on=nLooSPV?okiIconnRIooWS
Uooig9[okMZFooSMV_ohfY[onMbHooOKW?ogg9OonMbJoo?FV_o^dIOokmFJooCFV?oeeISommNLooKI
Uoocdi[oklVHoo;:Uoo`biKok/ZHoo?>VOofe9OolM6Hoo3AV?o^cISol<nJonk>VooadYWomMJFoo7B
VOo/dIWoi=6Ion?>UooadISom]fKoo[OV_ohi9_onnFIoo;FUOoffiSonNJJooo[V?oXfIKofljGon[B
U_ode9Oom=^IooOKV_ocfYSommbIooWLU_oigY_on]fKooKMV_o_g9Son=fJoo[RV_ojhYSon>2JooWQ
VoojgIWolmnHooKPUoojhYP00_oihIT04oojhY[on>2JooSMV_oigYWon>:IooSRU_oghi[on^BKooOT
V?okhiWonn2KooWNVOonm9ooNVEdo`0kPOl0@83o03moo`10P?l0@Gh03_l0@8001?l0=g[o@VbLookn
l_oHfMh2omoNh`?oh=oT00OokNcaoiBDU_nVYZSoj^W^on3Oi?oOg^?oh=oT00;ogmkS00?oh=oTomoN
hooOg^<03ooOg^<01ooQh>GojNS]on[Yk_oRhNKog]gRomoNhooPgn@01ooOg^<01OoPgnCog]gRomcM
h_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_ko
ooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`0=o`10P003o`11O_miJWgo
o_jh00[oo^jb0oonk[0Dook^/P05ooo//OookK;oo^jboog]/OookK800_onk[80E_omnK[oeZIXok]e
=ongLS7oj<J9olN<B?noPdCo]g8aooW_]?o7STWo[e/KolZCDonnNCSog;IeomRVJonmNCSolmVLoj/^
0?oYcHkoookoonoCU?nY:P7oj<9ioogoj_nlNcOoaHE5olfHE?nhKRgoo_o6ok9W9?oFYF3ol<V4oj]9
2?oT^gWo/VTTok]h<Oo7RTOo]fd`on_?Noool9_om]fJoooYWOnkN3;obYA>ooonc_nY>`3of:QVooko
joo?WESo]54FooSPU_oki9kon^>GooWQVookg9_on=fFooKMV_ohgISonMjIooOOVOoig9[on]fIoocW
V?ohiISonMbJooOJU_oig9SooN:KooSRUoogg9Won=^GooOLVOodeYSoklZEonc:V_o_bYKok<JEoo7<
V?ofeY_on=JGoo;:VOo/aYGol<RGonk8VOo^b9Ool/RH0_oddIL0??oac9OokLVGoo38UOoabISokLVE
oo3:VOoccYWokMBDonOAV?oZciOoklnFooCKVOofgi_oo>:Hook/V?okiYGokm:HooSIU_oliY[olMnM
omg<U?oXciOom]BGoo7HU_ogfi[om=^Hoo;KV?oeg9WonMjIooWLV?ojgi[om^>GonkKUooegiKonN6G
oo[PU_oigiGon]nJooSMV_oegIOol^2FooOQU_olhYOon^:HooSRVOojgiSonMjGooKNU_oigiGonN6K
ooWQVOoihiSonN>Joo[TVookh9Woo?2NogUTMOl1>Wgo03moo`10P0?o041n00?o03moo`10P?l0@800
2_l0@8001Ol0=g[o@VbLooknl_oHfMkogmkS00;oh=oT00cogmkSon3Oi?o[j^ooSXfBojJVZ?o[jNko
hMoTonCSj?oViN[oiNCZon3OiOoRh>D2onOUjP0=on3Oi?oOg^?ohN3UonKTjOoWiN[oh^7VomoNi?oO
g^?oh=oTomoNhooPgnCogmkSon3Oi002onKUjP0:om?BeomVIVKoDU9@olS8b_oUi>Woh=oTonCSj?oW
i^_oiNCYomoNh`?oh=oT0ooOg^<00ooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_kn
ooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6
oeYbU_l0>7/03Ol0@8000ol0@GkoNFYmookn^00Qook^/P;oonfb0_onk[80UOookK;oo^jbook`/ooo
l;;o`H51olnHEoo9UUGobiEEok]g>?oN]gKo^gLfonK4Q?oK[Foo]G0]onS6QondEa;og[QgomV/Jonj
MSOooO:jokM^:_o3PdGoilB2oo3CSOneJbCoa8E2on2cL_n_APGogjiYolbIF?nW<@7ofJYTojQ=1onm
O3[ociQGoj]10oobeXco`H0lolN=A?oN]6So/CX0ongGPOoojYWon>2Joo;BQon`IBCo^WXcon[>SOnm
P3go^gHconBlM_ncFR;od9E?oooeW?onlI7on^RDoo_UV_ogg9Oon^:Hoo[MUoohfiOommbGooGMTooh
gISon>2HoogWVooggY_omn6Hoo_SVOoki9KooNRIooWNVOogfYSon=^GooOEU_o^b9OokLBFono6V_o_
aiKokLNFoo38U?oedYSom=6Goo;:U_oac9Soll^Hoo;:Uoo`biOoklVJoo7<UoobciWolLNEong7V_o]
aiKok/JEono6V_o_aiCok/VEoo7>U_o[d9Wok]6Eono>VOoZbiCol=>GooSPV_oljYCoo_BCoo?PToob
ciOonMjIoo3IUOoLcICog/fGooCAUooaf9Som=RGooSJV_oeg9[olmZGooOJV?ohfiOom]jHooSPV?ok
iYGolN2Joo?LVOoggiOonMjGooOOUoojh9Kom]NFooCIU_odgYGomN:FooWQUookhIOonN6IooSPV?oh
gISon=fJooOOVOoigYOonN6Koo[RV?oji9Son^:HookbW_mjIGKo03]m00;o042000?o041no`10P?l0
@7h03Ol0@8001?l0=g[o@VbLooknl_oHfMh3omoNh`0Eon3Oi?oOg^?ok>_`ohf<TOnVYZSoj^W^on3O
i?oCdmGobl_=olk=d_oRhNKof=OLokno`Oo7aL[oh^7Von7QhooLg=ko`l;7okfk`?oGe]_ohN7S00Co
gmkS00gohN3UomgLhOo0`<;ofm_Mol[9c_mBDU;oFEUIok:b]?oYj>gogmkSom?CeOo;blgoclkC00Co
gmkS0_oPgn@01?oNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_ko
oogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/0
3Ol0@8000ol0@GkoNFYoookn^00<ook^/P;oo^jc4oonk[82ooo]/P;oo^jb07Koonbaook^/_ool[Go
m^:Uoj`^0?oUaHSog;=cojU70?nhK33om^^eol64AOo>UE;oo_>mom2KFOo1N3CodIiOooo_^ooCYf[o
]fPSooki_oo^e9Oo`G8jokaO6OobfHWok]65ol:7@onjJR7oeJESoocUXOoL[f_oahY7olF4@?o6RD[o
e:=Nok]h<_oEYEWoo>^Monc;R?o3Qcoo`Ghhon2jJOomkY_om]jHoooTWooP^W7oZ1`1ojXd0_oS]gKo
l]FAolJ:A?niKRgoc95;ooGPSoomliCom]jFooOOVOofh9Ooo>:HooSPV_offiKon=^EooWLV?ohfiOo
mmfCoo_UV_oghIKon=fHoo[PUOohfiOolM>Gonk>Too]bYCommFHooOHV?obciWok/VEooG>UOodciSo
m=:EooODV_ocfi?om]jHooSPV?ohgIKom]^HooWLV?ogfYCom]fJoo[QXOogg9Wom]fMooOJX?o`d9?o
l]2Coo3=UOo_bYGok/VEonk5UooaaYWol/fHoo7>U_o^biGoklJHonc9TooYbY?olmBDooOPV_oiiYWo
kmNGoo?AU?oefYOog<fDomg:T_o]cYOomm>GooCGUOogfIWon=^I0_offIL07OohfiWonMbHooWQVooi
hi[onn2KonkKUoobfiSon>2FooWOU?ojgiSommnGooSKVOocfiGol]bCooGOU_ohhYOonN6GooSPV?oh
gISommbIooSMV?ogg9Oon=fHooWNUooggiOon>2HooohWOmlIgSo03]o00;o042000?o041no`10P?l0
@8003Ol0@8001_l0=g[o@VbLooknl_oHfMkog]gRon3Oi0?ogmkS01?ojn[_ohf<TOnVYZSoj^W^on_[
kOm1@D?o0000o`000_o;blgoSXj@oc0`<_l000;oQ8>8oockoon`[kCo:RXZoeQFEon3PhGok>_`00Co
gmkS00oojNS]ojj]/_l51@OoTY:Dolg<dOn2PXCoK6a^olg=cooUi>Woj^[/obTY:Ol0003o0002omSH
f_oSh^L00_oPgn@3omoNh`03omcMh_ono_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_kooooo
ookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:F
o`0hN`0=o`10P003o`12OomiJWooooni00Soo^jb1oonk[<Cook^/P1hooo]/_onk[;oo^jbook^/_oo
kk?oooBgonFlQ?nW503om^:Uonc@SonI007o^G4YoooodooCYFWo^Tl7oo[^/Ooom;[on^N/oooc]oom
nKcoe9aOokHk0_oojk;oo_Fjoo_XY?oigXoon^BIoooZVoonjI[oo>BLoocZ[?ofeY_omMZEoocTV_oe
gI?ommnIoogWW?oihYKooNFKooSRU_okiIWonnJCooc[TOomjiWom=VFooGLVOoihiSooNRIom>NF?o?
WESoonVMoo[TVOoniYkomMnFookXWooljYKolM:Boo;DV?ojgiSommnEooWRU_obe9ConN>JooOLUoog
fYSon=^GooWNUoojhiOommbEooCAVOoaaiGoj/BConc1Uoo^`YGoklNDooCEUOoffIGom]^FooWNUoo`
fIKom]^DooKIUOooiYKomnJHoo_YUOomkIKom^>FooGMUoojh9Komn2DoocYY?ook:OonN:FoogXYooo
kk?on^:Loo[KV?oefYOol=NEoo7DV?obdi;ol=2Eoo3=UOo_bYGok/VDonc3UOo^`iSokL:Eonc1U?o^
`iKol/jDoo?FU?o`ciWollnEon7>U?oGbY?oj<ZDoo;?UOoeeiOomMRF0_ohfIH05ooffiSommZHooWJ
UooigYWomn6UooWPX?ogfIWok]^Foo7MU_oggiOon]fGoo[NUOoggiWonMbHooOJU_ocgICol]nCooSP
U_okhIOonMjIooSKUoohgIKon=^E00;on=^G00Gom]jHooSTWOonoZSoOFYmo`0kO`02o`10P003o`10
O_l0@83o042000go042000Oo03Mjod9/W?ono_;of=WNomoNhooNgN;oh=oT00;ogmkS00Kok>_`ohf<
TOnVYZSojNS]ong]kolc<c<2o`00000;okFe]on2PXCoa/K8of9RI?mlO7koo_knojJVZ?n>SY3o^KVk
oh20P_o[jnd00_oOg^<2on3Oi00?onGTjOo2`/CoSHf?oifMWOn5QHOoo_koonc/k_oSh^OogmkSon[Z
k?lJ6Q[o0000o`410ooGemWoi>?X00CogmkS00Cog]gRomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nR
Y;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Ooh
m_Oo[:^iokjka_mJLYKo03Qk00go042000?o0461ogUZOoooo[/03oonk[<00oonk[;oo^jcook^/`0>
ook^/`;oo^jb00?oonncook^/_omkK400_onk[807Oool[Gom=^Kon[<S_omk[?ooNN]onK3ROo]e9;o
oO>hooWQYOoWahcoonRbook`/Ooml[;oo^jboooe^?oS`83odj1Qook^/oomjZSon>:GoogWVoojiIKo
nnBDoocVVookgZ;om=6GooKIToohh9KommbG00;onMbH03konn2Ioo[RV?oghIKonMfDooSUU_omli;o
nNNConkBTooeeYKon=jDoo[TV?oki9Son=^IooSST?ojjY?onmfEooWRU_okhi_onN6Ionc8U?o`bI;o
mmfCoo[MUooliIOol]BDooGMUoojiIKommZDooKIUooffiKon^2FooSKUOo`cIGoj[nDon_0UOo/aYGo
lLVEooG>UOofeiCon>2FookZU?omk9Com>6Bom[;T?o`dYCommbEoo_VUOokiI[onnVEoo_[ToobgYGo
lmFEooSKUOokhiWoon^/oogYY?ojh9?onn>Uooo_/ookiI[on=^EooCKV0;ojmRD01SomN:CooCSToo[
eYGokmJConk>UOo`biCojlNEonk4T_o_`9;ok<BCong1U?o]`I3oj/JBoo38UOo[c9?of<REon?:T_o[
c9Gol]JEooOHUoofeiCom]VEooOHUooffID2ooOJUP0JooOCUoogf9oonmnPooSKVOo/f9?ol]^GooOO
UooggiGon=jDooOMToohfiGon=fHooGMUOodg9;om]jDoo[OV?ohfiGommZFooSJU?ohgYCon>2Hoo_W
X_onk:kooonioge/O_l0>glBo`10P00Mo`0gN_m2K9coo_kbomSIg_oMg>7ohN3UomoNhooPgnCogmkS
onc[l?n=S97oYZJXonWXk_oXincoPX:4ob<S8omPH6;ofm_MojJVZ?miNG_oK6a/ohZ:S?o:bLkob<O<
odM7BOm4A4KoWijSonSWkOoPgn@00_oOg^<01ooPgnCog]gRon[Zk?o0`<;o;Rh^ogajOOo/k>h00ooO
g^<01_oWi^_oO7anob4Q8OmPH6;of][Lon7Pi@;oh=oT00KogmkSon3Oi?oNgN;og=gRookno?mFNjL1
o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Sh
onk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/03Ol0@8000ol0@H7oNFYoooon^`0Sooo_]0;o
o^jc00ooonndook^/oonkkCooO6eookd^OonkkCooo2eooof^oool[_oo^jcooga]OonmK[oonjcooo]
/oookk<00_omk[D0KOool[_oooNloogZ[oohhIGoo>:Eoo[STooiiiGon^>Goo?EUoobe9Com]^DooOM
ToojhYSon^NRooGJToodgY?oo>:GooOQV?oigIComnFCooo_TookiY?olMFFoo;GT_ofeiKon>2Foo[R
V?offIGon>6CooocTOohhIGom]jFooSRU_ojhi?om=NCon_3T?oef9Kon]fGookUUOoggiGom=NCoo_Y
UOokhIKom]RBooOHUOogfYKommREoo7=TooZ`Y7olLRBoo?AT_obdi?omMZCooWQUookiYGoo>ZDoog^
TOohhi3oh]2@omc5SoofeiKooNNBooKPUoomhiKomnFCooSWUOobg9?om=NEooOMToohiYCooNZUoo[W
V_oihhkonN:Noo_XW?olji7onNF?ooKKU?oaf9Koj]JAon_HU?obhI?ojMJBooKUUOo_f9;om=NEoo3E
T_oVbiCokLZBon_6TOoY`9Cok;nFonjoTOo/a9?okLRConK8U?oNbI;ojlNConk@U?ogf9Gom]NDooGF
UOoffIGom]NDooOJU_ogfYCon=fFooGHU?oceID00_oheYT05Oo/eiCol=VEooSNU?ohgY?omn2DooSN
U?ohfiOonM^EooSNU?ohh9KommnEooWOUOogfYKon=ZDooWQUoomjZKoonncooo^]_oookkoOFano`0l
O`0Bo`10P004o`0gN_m2K9coo_kbomSIgP?ogmkS0_oPgn@07OoZjNkoSXfBojNWZOo[j>oog]gRonWY
joo_ko7ok>_`on;Qi_oViN[o];:godm?DOl=3@ooXZ:Tonk^l?oXincoiNCYonKUj_oOg^?og]gRon7P
iOoPgnCogmkSon3Oi?oSh^Ooe]KHofm_LOnMVikoj>O/00;ogmkS00Kog]gRomoNhooZjNkok^k`on_[
kOoPh>82omoNh`07omkMh_oPgnCogmkSomoNhooLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQ
h^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/
ZkWo_[_6oeYbU_l0>7/03Ol0@8000ol0@H7oNFYoooon^`0Sooo_]0;oo^nd0_ookk@00oonk[?ooo2e
ook^/`02ooo_]00Pooo^/oonk[?ooNjcooo^/oonl;?oonfcooc`/oomk[?oonneook^/_oolKKonn^`
ooSPV?oghY?on^FFoogTU?omhiKolmBCooKDU?ogfYComn6Foo[XW_okjikom^BLooGHT_ojgYGon>6C
ooOMT_ojhi?oo^n@oo_WTOogfY@2ooGJT`1AooKJTOoii9GommZDooGNT?ool9?onN:BooKHT_oghISo
nN6GooSPV?o]b9?olmBAooWOT_oki9Kon>VDooSNTOojiIConn6Doo3=ToocdICon=ZDooGGTOogdiGo
l/jDoo;BUooeei7ol]JEooSLTooki9ConNNCooWWTOonkI7oo>^Con_GT_oMc9CokM6Boo[VT?oii97o
n^2EoocWU?ofi9;on^FFooGJTooef9;onn6GoocZU?oliiSonnJEoo_VToohgYConnN@oo_/SoomkXoo
n>:FooCGToo/di7ojM6AonkEToo]e9ConMnEonoMTooZeI;ommZDon[BU_oVdI3ollnCon_8T_oY_hoo
k[nConVnTOo/a9?okLZBonK8U?oWaY7oj/VCooCGTooeeY?om=FEooKITooff9;ommRE00;om]bB00[o
nM^CooKIToofeiOom]:Foo??TOoZeY7ol=VCooSNU?oigiCommfC0ooffI<03?oggI?om]jDooWNUooh
gY?on^2FoocXZOonkkKooo2gook^/oonok_oNfaoo`0lOa;o042000Co03Mjod9/W?ono_;of=WN1OoO
g^<01_o/jo3oSXfBojZZ[?o[j>ooh=oTomkMhP;ogmkS0_oPgn@01ooYinco/k>eoj2PX_oCd]Ooh^7V
on3Oi?oPh>800ooPgn@00ooOg^?oh=oTomoNh`02on3Oi007on7Qhoo5aLOog]cOon3Oi?oOg^?ogmoQ
on3PhP02omoNh`03on3Ph_oOg^?oh=oT00;ogmkS00OohN3UomkMh_oPgnCog]gRomcMh_ono_coEW^W
007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_kooooooooooooh
n?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`0=o`10P003o`11POmjJh3ooojk00Soonnd
00?oonjfooo_]?ookk@05oookk@3ook_]0?oonnd00_oo^jcook_]_onk[?oo^ndooo_]?oll;Koonnd
ook^/oookk?oo^nhooo_]002ooo^]P0]ook`/oomj:oommbGooSNTooki9Kon^FDooKTT_o_dY3olmFE
ooSOSOoii9?onNVKooOVU?o`hI3om]ZAooOITOohhIGommfCoo[TTOolji7on>>@ooGHU?offiKomMjB
ooCEU?oegi?onM^EooKJT?omkY7om>:>oo;EToohfiGon^2CooORToodeICoklNCooSST_ojj9ConnVC
oogXUOoffY7ol=2Con[2TOoV^I3ol<VB00;omMRB04SommVAooKHT_oaeIColMJAooOPU?omii7onN>@
oo[UU?ojjIOonnb?ooWYU?oXfIKok=2AooWNTOoki9Con]bFooSRU_oijI;olMjBooSST_ogfYConMnE
oo?KTOohihgooNNAoo[UT_oij9SonmnEoo_ZT_olji7oo_6Cook[YooegY;oj=2BonKAS_o^dY7okm6C
onkCS_o_e8ookMJ@ongDTOoefYGoi<jBonW?T_o`dI7ojLZConS2TOo[_i3oj;nConS3Soo`aI;ojlJB
onO6TOoadXoolmBAoo7CToodeY3ommJAooGHU?oefI3ommVCoo?HToo`f93omM^AooKITooedi?ol/jB
onW?T_oafI7ommfCooSLT_ogfi82ooGJT`0=ooKITooef9;omm^BooOPU?omj:Gooo2gook_]_onk[;o
onjdooko_OmlKH3o03aoo`10OP04o`10P003o`10O_l0@83o042000[o042000Go03Mjod9/W?ono_;o
f=WNomoNh`02on3Oi007omoNhooPgnCoi>?Xol;1a_mRHVCoj^W^onSWk002omoNh`07on3Oi?oOg^?o
gmkSon3Oi?oYj>gojn[_on?Ri`04omoNh`05omoOhOoOg^?oh=oTomoNhooPgn@00ooOg^<01?oThnSo
h>3RomoNhooPgn@2omoOh@;oh=oT00OogmoQomoNhooOg^?ogmkSon3Oi?oOg^?ohN3U00;ogmkS00?o
g=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookn
o_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00go042000?o049oogY[
P?onokd0:?ook[H01OookkCoo^ndoog^]Oook[Koonng00Coonjf06koonndooo^]_onkkSooo2ioo[V
ZOodfICon]fAooSVU?ojiI;on=jAonoBT?o_e8oonN>@ooOWSooci8ool^2<oo;MS?ofgi?ol]R>ooOK
T_ohgY7omn:?oo[YSooffY7om=J@ong=T?oadY;omMNAoo?GS_ohg9?om=R?oogYT?ocfHkol=6@ooKH
T_oigIConMnEooOPT_oeei7om^6BoogYTookjI?on>>Boo;@TOoY_I3ojKVAonZnTOo`bI3om=FBoo?F
T?offY3ommf@oo?HUOofg97oo>JAoo[XT_oigXool]bAooWTUOoihi[ooNn>oog]X_oghJSolM:?oooW
Soogh9;on>6Eoo[STooehhgom^2Doo_UT?ohgHkonn6Doo7PT_oZfXgooNB@ooSNTooji97onn:Boo_/
TOolji?oonnaooo^Y_okihkol]NBonC?T?o_dY3oklnBoo3AT?o_d93ok]:Conc@Soo`eI;ol=RBonC?
T?oYci;okm:@on_=SooXa9;oiKn@onZnSoo[`HoojlJ?on_3T_oZbiCol]F?on_BT?odeI;om]F>ooGG
T@;omMRB01ComMN?onkFT?oaehgomMRBooSJTOoffI?ol/jBonO=T_o^eY3on]bCooSMT?oefI3ommRE
ooGIT?off9;ommV@ooSSX?ook[KooNjeooo_]0;oonjf00?oo_nkoga]P_l0>gd01?l0@8000ol0@8;o
0420o`10P00;o`10P006o`0gN_m2K9coo_kbomSIg_oOg^?oh=oT1?oOg^<02?oViN[oU9>Hoi>CUOmV
IVSog=cNon3Ph_oOg^?oh=oT0_oOg^<00ooPgnCogmkSon3Oi002omoNh`;oh=oT0_oOg^<01OoPgnCo
gmkSon3Oi?oOg^?oh=oT00;ogmkS00Coh=oTomoNhooPgnCoh=oT2_oOg^<01OoPgnCog]gRomcMh_on
o_coEW^W007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_kooooo
ooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`0=o`10P003o`12OomjJh3oo_nm
02Soo^nf00Koonndooo^]_onkkKooNjeook_]?ook[H2ook_]P2:ooc`]_ook[Koo^nhoooa^?okhjOo
lmF?ooSNTOojiI;omn2BonoDSoo]eHgomMj>ooCPR_o^eh_okM:=oo;ESoocd8kol/n?oo;@T?odeY3o
nMjAooWPT?ohgY7olmN=oo7BSoo_bhoolLR@oo3<T?oadXoommVAoo?GSOoghHcol=J<onk?S?obd97o
nM^BooSQToogh9;om]Z@ooWRU?okk97onnFBoo7?T?oY_I3oj;V=on_0SOoccHoom]F@ooKLSooefhko
m=fAooKMSOohfhoonN>>oo[YTOoihY;olmF?oo;ETOoggX[om]ZAoo_WS_oljhoonMnEoo;?UOojiXgo
n^BAooOPT_ohhI?on>6AooSQTookiI3on>>@ooWOU?okhY;onn^<oo7PT?oegY3on^6AooWUSoojhHoo
o>b<oocYWOonk[[oo>ZPoo3FS?obeI7ok=>@onO@SOo]dXook]6=ong@S_o]d8cok/n<onk?S_o`dhoo
k=>@onC?S_o_e97ojM6Conc>T?oWbXkohL2=onJnSOoX`8ook<>?onC4Roo`dhookLn?ono@T?ohei3o
m=FBooOFTOodeXkomMNAonoDSooXd9;om=J>ooGIT?odfHcomm^BooGFUOo/ch_ol=>?ooSNU?ohg9;o
m]R@ooCHS_off8oommfCoogYZ_ookkOoo^nfook_]?ook[Koonngooko_OmlKH;o03]m1?l0@8000ol0
@8;o0420o`10P00;o`10P007o`0gN_m2K9coo_kbomSIg_oNgN;ogmkSon3Oi002omoNh`08on3Oi?oQ
h>Goi>?XoiVHWOnCTiGoh>3Ron7PiOoOg^<2on3Oi0;ogmkS00Koh=oTomoNhooOg^?oh=oTomoNhooP
gn@2omoNh`;oh=oT1_oOg^<00ooQh>GogmkSomoNh`02on3Oi003omoNhooPgnCogmkS00GogmkS00Go
h=oTomkMh_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7o
oooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/03Ol0@800
0ol0@WooNV^2ookn_P0Xooo`]`04ooo`^Oook[Kooo2eooo`]@;ooO6g08coo^nfooo`]Oonk[[ooO2i
ooo_]oojgJ?olm:=ooWLS_ogh93ok]R?onoDSooae8kolmF=oo3AS_o]bhkok<N@oo78T?ocaX_ok/N@
ono8SOoachoom=J>oo?HRoodf8kolm:=oo;<SOo]bHgol<V>oo7:Soo^bXcol=6@oo;ESoocehgol]B<
onk;TOobdHkonMN@ooSLTooigi;om]ZAooWST?okiXgolm2>onRnS_oW]X_ok/2<oo3<S_obeI?ol=F>
ooGKT?ocfHcok]FBoo;KSOoeghcoo>RBoo_USoohg9;ol]6>oo7@SOoegY3ommVCooSOSoomkXOonNF>
oo79S?ofgHgon^V?ooKOTOojh9?on>6AooOQS_oigi;oo>>?ooORSoojh9?on^6AooWUSoofiHgom^2;
ooCMTOoihhkonN2>oocYV_okij3ooo2gooSPV_o[c8_okLj=oo3DRooXe8ool=>?oo3DRoo^dH_oj/n:
oncAS_oZchcojm2;oncDS_oUdHcojM2>onG=SOoUc8coi/j@onO=T_o[aXooj/2>onJnSOoY_hgolLn?
onkASOoUcHgolmBAooKCTOodeXgomMN>ooCFS_ofeHkoj]6?onC?T?oef8colmR;ooGISooifI3omMV@
oo7DT?obeXgomm^AooSJT_odeXgommN>ooSQVoookkCooo2gooo`^OonkkKooo2gooo_^OonokgoO6f2
o`0kO@Co042000?o0422o`10P?l0@8002ol0@8001?l0=g[o@VbLooknl_oHfMh6omoNh`07on3Oi?oO
g^?ojNS]on[Yk_oPgnCogmkSon3Oi002omoNh`04on3Oi?oOg^?ogmkSon3Oi0[ogmkS00?og]gRon3O
i?oOg^<00ooOg^<01?oPgnCogmkSon3Oi?oPgn@7omoNh`05on3Oi?oNgN;og=gRookno?mFNjL00Ol0
=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^
k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00go042000?o049oogY[P_ono[h0:?ool;T07_ol
kk[ooo2gooo`]OonkkSooo2iooo`]oonkkKooo2iooo`^_onjk7om]ZIoo3BROodf8kolmRAonkASOo_
dXcom=><onk;Roo_ahcol<J<ono7S?o`ahook/N>ono8SOo^b8[ok/^9oo?BRooadh_ol<n<oo3<T0;o
k/N>05kol<R=oo37TOo^ahkolLj<onk@R_o]d8cok]2:onk;Roo_ahcolm:?ooKLSooig8kon=ZAooWS
S_oih8cojL6=onBbSOo[_8kom<j=onoDSoo[eHcok=J;oo3FS?o^dHgojm>;oo;NR?ohi8_on>:=ooST
RoohghgomMZ=oo7GR_ohgHcomMV@ooSOSoomjXcooO28oo7?SooaeHcoo>b<oo[OS_ohghoon=jCooWO
T_oih8kon>:?oo[TTOoihi3on^6Aoo[OT?oigi;omn6>oo_RS_oaehgomMn<ooWNTOojiZOoo>VMook/
[_obe9Cojlb;ong>SOofeX_ol]R=oo7ES?o_eH_ojm>;onSARooVch_ojM2=onS?S?oWcX_oiln9on?;
SooRbXcohLV;omo;S_oRcHcoiLf=on[;RooZ`hcojK^:onO7S_o[d8goiLV8onkARoodeY3olmF=oo;F
SOogeHgolm:;oo7CRooScXgoj=6>0_ofeXd04_oefXgom]^>ooKHT?off8oomMN>ooKJT?oefHoomMB?
ooSUXooolK[ooo2gooo`^OonkkSooo2gooo_^Oono[koO6f2o`0kO@Co042000?o0422o`10P?l0@800
2ol0@8001_l0=g[o@VbLooknl_oHfMkogmkSon3Oi0;ogmkS0_oPgn@3omoNh`03on3Oi?oNgN;ogmkS
00;ogmkS0_oPgn@2omoNh`04on3Oi?oOg^?oh=oTon3Oi0CogmkS00Koh=oTomoNhooPgnCoh=oTomoN
hooPgn@2omoNh`04on3Oi?oOg^?oh=oTomoNh`;oh=oT1_oOg^<01OoPgnCog]gRomcMh_ono_coEW^W
007o03Ii00001on[Z[SoXZBcon7Ri_ono_koooooookno_oooOh0lOooool01Oono_kooooooooooooh
n?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:Fo`0hN`0=o`10P003o`12OomjJh;oo_jn02Sooo2i
01Oooo2gooo`^Oonk[[ooO2koooa^_ook[Sooo2ioogb_?omj[3om=NEoo3>Qoo^d8[ok<n=oo3?S?ob
chgokLZ:ono5Roo]aHSoklV;oo3:S?o`bX_ol/b;oo3=R`02oo3>SP1boo?BSooadXoolLn?ono<S?o`
b8[ol<R;onk6ROo]ahSoklJ>oo38Roo^cH[ok<Z:ong:R_o_ahcok/J;oo;;R_ogeXoomMV?ooGKS_og
hH_onMj?onJlR_oW^8colL^<ooOLRooZdhgoiLj8ooCNRoogghWoh/R;ongFQ_okiXWonN2<onoER_oe
fhkon=n?oo[UR_ofh8[om]^>ooOGS_ohhXcon=n;oo_XR_ogiX[ol<n:oogYR?ohhXgonMjAoo[QSooh
hXgonNF>oo[VSOokihkon^J=ooSQTOogh93on^6=ooWOT_oih93on^6Aon[BR_obf8_onMj?ooWTXool
jIcommnSon_<S?oYc8[ol]B;ooOGS?odeh_olmJ8oo;FSOobeHookM>9on[BR?oVchWoi=2;on7=Q_oS
c8Soh<f;on;:R_oObXWohLV;omg7RooNb8kohlZ:onK=Roo/b8coikn;on_<S?oVcHgoiLb:ooCASOod
dhkok]6;ooGCS?oddhkokm6;ooCFSOoPc8goj<n=ooKFRoodf8komMN>oo?ESOofeHkomMN>ooKKS_of
fHgom]R@oocZ[?oml;_ooo2g0_ool;T01Oool;Oooo2iookn__mlKH;o03]m00?o042000?o041no`10
P?l0@7h03?l0@8002Ol0=g[o@VbLooknl_oHfMkogmkSon3Oi?oOg^?oh=oTomoNh`02on3Oi005omoN
hooPgnCogmkSon7PiOoPgn@01ooOg^<01?oPgnCogmkSomkMh_oQh>D2omoNh`03omkMh_oOg^?oh=oT
00;ogmkS00?oh=oTomoNhooPgn@01?oOg^<00ooPgnCogmkSon3Oi006omoNh`05on3Oi?oNgN;og=gR
ookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_oo
ooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00go042000?o049oogY[P_on
o[h0:?ool;T05oool;OooO2kooo_^oookkWooNjgooga_OoolK[onnNZooGBS_o`bX_ok<V9oo3>S_o`
chcoklZ6oo7:ROoabH_olLj<oo?EUOofgZ;on^J[oocX[Ookijcoo>V_00;onnZb03Koo^^coocY/Ook
j:konnN/ooSTYooihJGolmVNoo7?T_o]bH_ok/R7ong7R?o]ahWok/J;onk5SOo[a8_ol=::ooOFSoog
ehcom^:<ooCKROoY_XWol<R=ooKFRookhh_okM^7oncIR_ojiHcon^6=onWCR_ofiXKon^F8onG5R?oZ
bhSon=j:ooWUS_oiiHcooNR;ooKKR_ohf8gon>:<ooSOSOoji8kooNj9ooGCRoohhhKon^J=ooWNSOog
hhgon^N;oo_/Qoolk8[on^Z;oo[VSoojih/3ooSRS@0hooSNTOojhHgom^2=on_CRoo_eH[onMn;ooWQ
Vookj9_ol=F@onS9ROo]d8[ommR8oo?FR?oceX[ol]V9onoER_oefXgom]V=oo?FR_o^dhKol=B;onoA
RooWd8[oh<^<omo:QooNbHSohLN<omk9R_oPb8cogLR9omc8RooObXOoj/Z=oo;?SOo[c8_ohl^;onk=
R_ogdXcojlb9oo3BR_ofdH_ol]6<onoAR?o`dX[og/R>onWBS?ode8WommF=ooGDSooceHgom=B;ooKF
SOogehcomm^Book^/ooml;/5ooo`^@03ookn`?mlKH;o03]m00?o042000?o041no`10P?l0@7h03?l0
@8001?l0=g[o@VbLooknl_oHfMh2omoNh`05on3Oi?oOg^?ogmkSomkMh_oPgn@00_oOg^<01OoPgnCo
i^GZon3Oi?oOg^?oh=oT00;ogmkS0_oPgn@2omoNh`;oh=oT0ooOg^<01OoPgnCogmkSomoNhooOg^?o
h=oT00;ogmkS00Goh>3RonGTjOoOg^?ogmkSomkMhP02omoNh`03on3Oi?oOg^?ogmkS00CogmkS00Go
h=oTomkMh_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7o
oooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/03Ol0@800
0ol0@WooNV^2ookn`00Xooo`^@0Dooo_^ooml;_oo^nhooo_^OoolKgooo2iooSRY_o_c8[ojlR8ong:
R?oac8Kol/b5ono=Q_ocdXoonM^OooSTZOoljJooonjfooo`_?ool[h3ooka_005oog`_?ookk_ooo2i
ooob^ooolKX00_onlK`0<?ool[gooo2ioo_/]OoijJkomn6Woo7AU?o[`hKok<6:on[2QOoabXWom=J>
oo?ESOoeh8OonMf:oo39R?oddX[olmR9oo[XQ_ofiH_oj]R6oo_WQ_olj8OomN68oo_XROojhhKoh/:9
on_?Q_oii8_oo>Z8ooWYQooljXKom]^<ooOJS_ogiX[omnR=oocTS?ojkHOonnN6ooOOQOojih_omn:9
oo_YQoojkHGoo>n6oo_YQookhhgom]f;ooKOS`;onN>=00?onNB;ooOQS_oih8`00_ohgh/03_ofgH_o
k]B7ooGJROoigICon>6Eon_?Q_oZb8Som=N;ooOHQ_ofgXKomMb:onc?ROoaeH_ol=F60_oef8`09Ooe
fhOokM:5ooKES_oigh[ok=F5onG?Q_oLbX[ogLV<omc8ROoKahcofLN9om_7R_oKaXOofLF6omg9R_o[
c8_oj/^:on[=Rooddhcoj/f9on[<Q?ocdh[olm69onc@QoocdH[ojlb;omc6R_o^dXWom]B:ooCDRooc
dh[om=><ooCBRoocdHWomMZCooo^^?onlKX00_ookk/01_ool;WooO2kooo_^oono/3oO6f2o`0kO@?o
042000?o041no`10P?l0@7h03?l0@8006?l0=g[o@VbLooknl_oHfMkog]gRon3Oi?oNgN;ogmkSon3O
i?oOg^?oh=oTomoNhooXinco[jnaoemOHOoUi>Woh=oTomoNhooUi>Wok^gbong/lOoSh^Oog]gRon3O
i0KogmkS00koh=oTomoNhooPgnCog]gRomoNhoo/jo3oOWj0oi^KWOoXj>[oh=oTomoNhooZjNkokNca
on[YkPKogmkS00Goh=oTomkMh_oLgN;oo_kloeIkY`01o`0fN@0000OoZjZhoj:T/ooQh^Koo_knoooo
ooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_l@05ooSfmon/ZkWo_[_6oeYb
U_l0>7/03Ol0@8000ol0@H7oNV^2ookn`00Yooo_^`0>ooo`^_oml;_ooO?0ook_^?ogfYkokLN6ong4
P_o`bhOom=6=ooKGUooggJ;oo>F_ook]]oonlK`2ooob_P03oog`^ooml;Woonnk00;oonnk0_ool;T0
1?oml;_oo_6loog`^oookk/2ooo__00Xoog`^oonlK[ooo2mooo`_?oom;konnjiooKQZ?o/c8ooj<F5
oo?AR_oeeH[ommf8oo_OS?ocdh[olmJ:oo;IROo]g8Con^^6on?BSOo]eH_omMf7ooKWP_olkHSon^::
onO:Q?o`ehOooNj7oo_WR?obgHConN:5ooCIR?ofg8Ooo>R7oo[UR?oii8WonnJ;ooc]Q_oll8Coo>f6
oo[UR0;oo>j304;on^^6ooOYR?o]eXSollj8oo3;QooggHKonNJ8oo[RR_ojhXcon>2:ooSORoogghWo
mmj:ooWORoodfXKolmR;ooSMS?o`eX_oilF6onk<QOodehWomMR8oo[XP_ohiHKoglR5onC<Q_o_e8Oo
lm>8ooKFRooffh[ok]B7onkBR?offh[on^R2onoGSOoHahoog/^6on?;PooTbhSoi/R:on79ROoKahSo
fLF8omG1S_oCaHKohLR8onO9ROo`dXWol]B>onK8R?o^cHSom=::oo7>R_o`ch[omM29onS9R?oKahSo
k]27ooGFQ_oddXSom=:;ooCBR_oedHOom]ZAooo^^?onlKX2ooo_^`06oog`^Ooml;_oo^jjoooo`Oml
KH;o03]o0ol0@8000ol0@7ko0420o`10OP0<o`10P007o`0gN_m2K9coo_kbomSIg_oNgN;ogmkSon3O
i002omoNh`0Bon3Oi?oOg^?oh=oToo7alolY:B_o0@43on7QhooRhNKoi>?Xol;1a_nEU9WoVYVNom3?
e?oSh^OogmkSon3Oi?oOg^?oh=oT0_oOg^<03ooPgnCogmkSon3Oi?oOg^?ohN3UonGTjOoCd]Oo0000
odi>C_oalO?ogmkSon7PiOn[ZZooUIBIojJVZ006omoNh`05on3Oi?oNgN;og=gRookno?mFNjL00Ol0
=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^
k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo04200_l0@7h2o`10P003o`51POmjK8?oo_o5
02Soo_6m00_oo_6looka_Oonl[kooNZboo?EUOo_bHSol/n=ooGGUoohi:oooNbfooo`_002ookb_P03
ooka_Oookkcooo2m013oo_6m03Goo_6look`_oool;cooO2kookd`OoljkOol]FCooCDROoefhOom]b8
oo?CQ_obcHOojLR3onK@Qoofih;oi=>3onS@R?oihXGok]63ooGKQ?oik8ColMJ5ooOUOoollHGolMb3
onS2Q?o`d8OomMZ9ooWPQ_ojjhKomnJ:ooWVR_oii8Oon>R6ooc`Q?oklH;on_1oooc`P?oolI;ol^BK
ooCVQOobhYOohLV9oo;:QOodchSol]b7ooGPQoojhhKon>>8ooORROohh8SonMn;ooWNQ`02ooSNR@0b
ooGLR?ofg8SojlZ5onK4QOo^dHGommR5ooGHR?okjH?omn>4on7:Q?oTbHKolMB6oo7HR?o`dhOomMF8
ooOHR?oaeXGok]63oogTR_obe8_og/F?omK6R_oXdH?ojL^5onk<QOoac8Gok<^4onK9QooRbHWoflJ5
omC4R?oD`HOoh/V7ooSIU_o[chkoj<V6oo;BQoofd8Wol/f7oo3@Qoocc8Oohl>6omc7R?o_e8Oon=B8
ooCCQ_ocdXGomLn8ooGHT_ool;T2ooo`_0;oo_6m00Goo?2looka^_ooo/SoO6j5o`0kO@0Bo`10P006
o`0gN_m2K9coo_kbomSIg_oNgN;oh=oT0_oOg^<02ooPgnCogmkSon3Oi?oXinco];Bfo`410om^KW3o
`L35onGTjOo`koCoOWj000;o000000?o[Zj`on_[kOoOg^<00ooOg^<2on3Oi00<omkMh_oPgnCoh=oT
on3Oi?oNgN;ol_7fogAdM_l@40koPH63omcLg_oSh^Ooi^KX0_l000003?l10@3og=_Pon;Qi_oOg^?o
h=oTomoNhooPgnCogmkSomkMh_oLgN;oo_kloeIkY`7o03Ii00001on[Z[SoXZBcon7Ri_ono_kooooo
ookno_oooOh0lOooool01Oono_koooooooooooohn?Sok^k`00Koknoa00Gon?Kgojb[^Onn^lKoFW:F
o`0hN`09o`10P007o`10O_l0@83o0420o`10P?l1@H7oNVb3ookoaP0Xooka_@0>ook`_oool[goo>V_
ooKLXOohgZ?oo>V_ooc_^_omkkkooo6moooa__onlKgooO2looga_oonlKd2oog`_13oo_6m0_ool;d0
J_oml;cooo2mookc_Oook;Oom]F>ooCHQ?oefHGolln5onk2QOoW_h;oi/V5oo7QP_oQdHCog<B6oo_R
Q_ocg7kokL^3ongBQOokkh7ooNb4oo_/Q?o/aXGoh[:1oo7BOooggHWonNF6ooSYQ?oiiHKomnB5oo_T
QooiiHKonnb4oo__POookX;oo>^3ook`YookkKcohm>Eoo_/QooYfYoohL64oo?;PoocgX7ok=J;ooWV
VOohh8KonNB7ooWUQ_oafhKom]j8ooKNQ_ofgHWomMf7ooSNR_oefhOojLJ4onO8QOofehGomMN1ooGI
Q_oeh8GomM^6onW?Q?oVbHGom=B1ooGFPooeeXColM66ooCDROoeeH[ok=64onoCROoachOoi/N7oljj
QOoUb8KojlZ3on[<Q_oYc8Kok/R7oo3:PooZbH;ok<^8ono=Q_oYbXOoh<fBonK>S_o`c8koh/F1ong=
Q?occhGom<j5oo;<QOo`d8GolLB3omg0Q?oOaHSolmB2oo;EROodd8ColM23ooKHSoookk_oo_6mooo`
_Oonl;l2ooka_@04ooka_?ooo/SoO6j5o`0kOA;o042000Co03Mjod9/W?ono_;of=WN0_oOg^<04OoP
gnCogmkSomoNhooQh>Goh=oTohZ9S_l000;oQHF5okfm_On<S8kok>_`oo3`l_mnOX3o0000o`000_n^
[[3oj^W^00;oh=oT01GogmkSon3Oi?oOg^?og]gRon7PiOoNgN;ogmkSonCSj?o=c=7oBd]=o`000_o6
a/SoTI2FokRg_?oXingoi^GZo`000?l10@?o0000omcKh?oSh^L00_oOg^<01ooPgnCog]gRon3Oi?oN
gN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05
ookno_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00Wo042000Oo041n
o`10P?l0@83o0420o`51POmjK8?oo_o602Soo_2o00CooO6oooo`_OonkKWoo>nk0_ooll401?onl;oo
oO6mooga_oomlKl5ook`_`03ooka_Oonl;ooo_2o00koo_2o06_oo_6mook`_ooolL;oo?:mooo_`Ooh
fiWolmB2oo;GQ_oYaX;oj;moonfjPooT_X3oj]5oonGEO_oJ_HGok=:5oo7NP_o`fh3oj<N4omo<Oooo
kXKon^^4onS5PooT/X7ok]F3oo_SOoojih7on^J3oo[RR?oki8Kon>F7oo_YPoojkX;oo>mooocbOooi
hgkomM^@ooo``_oZgZkoi]MlooocV_oVd9kojKn3ooKFPOoZf8;ok]^PoogYX?ofhX7omn:5ooSSR?oU
ch?olmZ6ooCNROoefhOom]j8ooKLR?ofg8OojLJ2on[<Poohf87omMj0ooKMPoodfHSon=f6on?=P_oH
`8;om=>2oo3?P_oefHGolMN3oo3DPOocdhKol=>3on_>P_ocdXGolln1om6hP_oL`h3olM23onc?Poo[
bh;oj/b3onc:Poo^bH?ojlR4onS7P_o`cXComm:<oo3FVOoYc8SoilB0onC8OoocchGollf4oo7<QOod
cX?olm6:oo76P_oP_H?ohLR5oo?BPOoedHOol<n0ooKFSOonk[[ooo70ooka_@03ook`_`04ooka_Ooo
o/SoO6j5o`0kOA;o042000Ko03Mjod9/W?ono_;of=WNomkMh_oPgn@2omoNh`0?on3Oi?oOg^?ogmkS
om[Ig_nJVIkodm;GokZj_?n5Q8WoiNCYonKUj_nn_L;oSHf?oi:BU?o?cm7ohn;W00Coh=oT017ogmkS
on3Oi?oOg^?ogmkSon3Oi?oOg^?ohN3Uolo?dOnRXZCoo_knohn?TOnZZZcoinK[on7PiOnWYjWoS8^@
oj2OY002omoNh`03on3Oi?oOg^?oh=oT00?ogmkS00?og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nR
Y;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Ooh
m_Oo[:^iokjka_mJLYKo03Qk00Wo042000Oo041no`10P?l0@83o0420o`51POmjK8?oo_k802[oo_2o
00Gooo70ookb`?oolL3oono1ook`_`02ooga_`;oo_2o0oool;lBook`_`1Zooga_oonlKgoo_31oocd
`ookijcomMB3ooOOVOoljK7oi/VAonRgOooU^7oog/20on;@O_oM^gcoiLB1ooGLP_ochGool=B0omo0
OooUeGgonnb4on[=POoS]Wgom=Z3oocVPOojj8;omnB6ooWWQOohjH;onniloo[]OOolk7gono9mooga
Nookl7[omn20ooSOW?onl<7ohmJBooSYP_oolK;olLbEoo7:OOoggX;of/>0ooCU[?okj9con^B?oo[T
S_ocgh3oi<j3ooKNQ?ogghOomMV6ooCJPoofg8Oom]b5onW7P?o_ch;ommN4oo[YOOokjg[ommV1ooON
P_o?^H3oak>0oncAP?obdh7okmF0ooGKQ?o^dWool=5oooCCQ?oadX;ok/j1ooGDPooR`87ocK]konk>
POodd8Cojl^2on[9P_o]bh7oj/Yoonc7P?o/ah7oiLN1onS;OooecXWojLf4on?6Q?oS`H7ojl^0ooC=
P_obbXCol/f6oo7AQ_oce8Com<Z0onC0P_oVb8;ol]62oo;<POocdHWooNbfookb`P?oo_2o00Goo_31
ooka_OooolOoO6j5o`0kO@0Bo`10P004o`0gN_m2K9coo_kbomSIgP;ogmkS00Coh=oTomoNhooOg^?o
h=oT0_oOg^<02_oZjNkoiNGWonGUiomLG5kobLW;on;Qi_oUi>Wok^k`ong/lOoRhNH2omoNh`;oh=oT
00GogmkSon3Oi?oPgnCogmkSon3Oi002omoNh`0;onKUj_nEUIOoL71`ojJVZ?oAd=GoHV9TonKVj?oQ
hN?ojNW[onk]l_o/k>h00ooPgn@02?oOg^?oh=oTon3Oi?oPgnCog]gRomcMh_ono_coEW^W0Ol0=WT0
0007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_00
1_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00go042000?o0D61ogY/QOono/P0:?onl;l02_ool;go
o_6mooga_ooolL3oo_2oooga_oonl;oooo70ook`_ooolL0Fook`_`1Zooka_?ookl7oo_;0ooo__?of
giWoo^JZooobaOonm/GolN2/onFfO_oN]gkodKakom^kP?oT]h3oj/b4ooOQO_o`gW[ok/Z0on31O_o^
iGkommV1onBkOOochGgonnYnoocVPOohiX3oo>V2oo[]NoojjGoon=f4ooGLP?ojjGgooneooog]O?om
lGWomn5loogY[_o]h[CohM9moocVT?oeg:?ok/5nooOIOooXb7_of/F2ook_]_ojii[oo>JMooo]ZooZ
eWooh<Qnoo[RP_ogh8;omM^7oo?IQ?odfX?omM^4onk>PooeeH3om=F2ooWVOOoolhoon=bBooGJOooM
a87oc[Yoon;8OOogeh3okm1noo;CPOoadX;oj/Ymoo7@OooddXSojlj2onk?Ooobc8?oa[5jomc4O?oe
d8;okLaoong9OOoWbH7ojl^2oo3<P?oVaGkoi/=oonG4OooYagoollR3onW7P?oQ`ggohl9konk<Q?o_
bh7ol/b3oo7@POocch7olM:0ooC>PooU_h3okLaooo;>P_occHCoo>N^ookd``?oo_2o00Goo_31ook`
_oonolKoO6j5o`0kO@0Bo`10P008o`0gN_m2K9coo_kbomSIg_oNgN;oh=oTomoNhooQh>D4omoNh`06
on3Oi?oOgn7oi^KXofATI_o>c]3ohn?U0ooOg^<01?oPgnCogmkSon3Oi?oNgN82on3Oi00BomoNhooP
gnCoh=oTomoNhooPgnCogmkSonSWk?mRHVCoLG5aoh>2QooEe=WoMWIhon_ZkooNgN;oh=oTon3OiOoO
g^?ogmoQ0_oOg^<02?oPgnCogmkSomoNhooPgnCog]gRomcMh_ono_coEW^W0Ol0=WT00007oj^Z^?nR
Y;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookno_ooooooooooooShn?o^k_001_o_ko401Ooh
m_Oo[:^iokjka_mJLYKo03Qk00go042000?o0D61ogY/QOono/X0:?oolL002Ooml/Coo_;2oooa`_on
l/3ooO6oook`_ooolL3oo_;0ook`_`02oooa`0;oo_;000?oo_;2ooga`Oonl/804?oolL00F?oolL;o
oo70ooob__ookkkoo^jjooobaOollL?oo?C5ooWY]OoL^7koe;AkomFdOooX]Gcog;UoongEOoo_h7So
j]AoonS3OOoRcG[omN5nonk;N_ohj7Wonniloog[Oookjg[ooO5iooWTNoo`e87omM63ooSFOooeggco
mNAjooSNOoojkgWono5fooSTQOolj[[of/nGongIN?oddh;oj/61oo?>OOoii97oh<61onOEPoookK?o
n>:=oo[WVooom<KohLjCon77O?oji87om>21ooGQP_oefhCom=Z3ooGKQ?oeeh7olmB1oo;GO_ohfgoo
oNj]oo7LVOoceG_ommb1on?<O?oK`Woom=Aooo;AP_o`ch3om]N4onG7O_oTbGcolM1ooo;AP_o[c7co
l/j0ombmOOo<^GOok<emooC>Poo]c7ook/Qoon[:POoUb7cok/Z0omg0O_oI`7d2on?5O`0Hong6POoV
aWgohl=jon_7OOocbGoolL^2oo;=Ooo^bWcol/j0oo7=Ooodd8Cok/R1ono>Ooo`cGconn>Uookd`oon
l/;ooo70ookb`?oolL;oo_;0ooknb?mlKXGo03]m4_l0@8001_l0=g[o@VbLooknl_oHfMkog]gRon3O
i0OogmkS00_ohN3UonKUj_nDTiSoZZV^ooGdnOo/jo3ojn[_on_[kOo]kNoojNS]omkMhP02on3Oi004
omkMh_oPgnCogmkSomoNh`?oh=oT013oiNCYoinOXOmIFE_o[Jf_on;Ri?mjNW[oe=CFoo7`mOo[j^oo
jn[`onc[l?o/k>koiNGWomkMh_oOg^?oh=oT0_oOg^<01?oNgN;og=gRookno?mFNjL1o`0fN@0000Oo
ZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?7ooooo00Goo_knoooooooooooon?Shonk^l006ono_
l@05ooSfmon/ZkWo_[_6oeYbU_l0>7/03Ol0@8000ol1@H7oNVb5ooknbP0Xookb`P04oooa`_onl/;o
o_;2ookb`P;oo_7400Cooo?3oogc`_ooll?oo_;20_omlL400oonl/;ooo?3ookb`P0Aookb`P1booka
aOonl/;ooo35oooc`ooml/Coo_;2ookb`?ool/Ooo>^oomRkPOoB/WGojKEkonB`O_oRb7komN9ioo;T
NOo^d7[oilMloo3RMooihggon^YiooofMoojjgSokLejoo3CMoofh7gol<n2oo?DPOoef7coklmjon?B
N?oZdW[om=YkoocbNOohkg3onNNAoo;S^?oSf7oommUgonboO?o]`G[onNF6oo_[[ooH`hCol=ElooCG
ToocfG[on^RNoocda_oFa9Coj]9jooSROOoegGgonN5moo?EOOocf7oom=UnooGGPOoceGgolmN3ooCD
OooghY7ojmF9ongBNoogfWkol]UlomS1Noo_d7gol]>0oo?BPOoceGoojLimomW0OOo]cG[olLimoo3?
P?oZbGcol<anoljfN?oH`7Koj/f1oo;>P?o]bWWok<Qnonc=R_oSb87oiLElomRkNOoD_G[of;mlomo1
NooYa7gohlEmonG3O?o_agool/Ujoo3=O?oX`gcoklYlono:N_oabWool<n0oo7=Ooo`cG_on=fJoooc
`oool/Goo_;2oooc`ooolL;oo_;2oooobomlKXOo03]m4_l0@8001?l0=g[o@VbLooknl_oHfMh2omoN
h`;oh=oT013ogmkSon3Oi?oOg^?ogmkSon3Ph_oOgn7oinK[ol?3aOl10@?oQhN9oh20P?mnOX3oNWYl
ofIVJ?nIV9goh^7V0_oOg^<00ooPgnCogmkSon3Oi003omoNh`0Gon3Oi?oOg^?oj>SZonk^l?oViN[o
kNcaohj>S_lV9RSoR8R:oginO_mlO7coNGUgoeaLG_ne]KOoi^KXon3Oi?oNgN;ogmkSon3Oi?oNgN;o
g=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`05ookn
o_ooooooooooooShn?o^k_001_o_ko401Oohm_Oo[:^iokjka_mJLYKo03Qk00go042000?o0D61ogY/
QOono/`0:?onlL@00oonl/;oo_74ookaa002ookaa0;ooo7400Cooo;5ookaa?onlLCooo;50ooolL@B
ookaa01[oog``ooolL;oo_?5ook``ooolLKooO;5ooobaOooll?onnk1omVnROoO/7Soik=jombdNOoZ
d7WomNEdonoKN_oYaG_ojm5jooO[LoollG?ooOIdooSVM_oS/7Woi[AgooKINoobcggomMMmoo;BNoo^
`7Gol==eomoBM_obdgWom=Ymook`MOomkg;onNNOom[=X?o/gW7ol<UlonZjN_odf7OooNjAonkR^_oA
`X7ol]1fono3O?odegWoo>ZNooWZ_ooC`8Golmejoo?OO?obdgWoklmlong8N_obdWgolmQooo7FOOoc
eGoolM9ooo;DO?oef7coiLYiomBiM_oaegSon]b2om>kNooTa7Oolm=noo;BOOocd7colM=iomW1NooV
aGSojlQgoo7>O?o]cWcok/]gon2oO?o9]WCoi<=fon_7Nooac7kojlMkong8P_oYaHOog;elon30MooE
^7KodKQfom>jMooI_7Koh;mhon?1N_o[aggol<elonk9NooV`WKojLEkoo7:Noo^bG_oklQmoo7<Noo`
bg_olmJ@oog``ooolLH00_onlL@01OoolL;oo_74oooocOmlKXOo03]m01;o042000Wo03Mjod9/W?on
o_;of=WNomkMh_oOg^?oh=oTomoNhooPgn@00ooOg^<01_oPgnCogmkSon7PiOoMg>7o_Kc1ok>c]@;o
];Bf00Co]KFeok>c]Onn_/3oh=oT1ooOg^<04_oPgnCogmkSomoNhooOg^?ogmoQon3Oi?oQh>GoeMGG
okFe]onc/[Oo];BfokBc^?ne]KOo/K6colc<c_oRh^CogmkSon3Oi0?ogmkS00?og=gRookno?mFNjL0
0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3booooo`04ookno_oooooon?Sjonk^
l0Coknoa00Ook^k^ono_lOohm_Wo[:^iokjka_mKLiGo0CQk00Wo042000?o041no`10P?l0@8000_l0
@8000omiK8Koook>oooba@17oooba@03ookcaOool/Gooo;500?ooo;503Gooo;6ooodaookl<;og;^5
on>YMooQ[7Soe[MgonoKN?oeiW7ofL5gombfN?oghGCoo>acoo[`MoofiG7oh:Idon>fMOoggWOol/eo
ooGFNoo`cWGoiZieooKIOOoLaGWoj]Ieoo31NOobeW?ooO9boog^MooWdiSodlMmooOLLOoZ]gSok/Mh
ooWWMoonlYcoe/fTomk:Looab7Sok[mkoo;IMOookJGolN>nom_5O?ojiG[ok]ahonS8Loo]aW_ok/Ee
oo78NOoaeWgom=Ejoo;CN002oo;BO@0Koo?CO?o]cW_ofKmeon_=MOoigG[oel5holnfLoocdWGolLij
oo;?O_ocdWGok/mlonG4LooS_WOojlQfonk>NooZbWOoj/YeomRkNOoO_G?oilIeonS7M_o^bGWoilMd
oo;6OOoG/gOo^JUe00;od[Yd00cod;MdolfiM?o<]gSockYgomfoNOo_bGSol/]nonc:P?oT_gSokLIg
ong6NOo_aGT2onc7M`05oo7?QOookkkoo_;8ooobaOonllH00_onllD00oooolooOFn9o`0kO@0Bo`10
P006o`0gN_m2K9coo_kbomSIg_oNgN;oh=oT2OoOg^<02_oPgnCoj>O/onOVjooWi^_oj>O/onOVjooX
incoiNCYon3Oi?oOg^<2on3Oi0WogmkS00[oh=oTomkMh_oRhNKoj>SZonOWjOoWi^_oi^GZonOVjooX
incohn;W0_oOg^<01ooPgnCogmkSomoNhooNgN;og=gRookno?mFNjL00Ol0=WT00007oj^Z^?nRY;?o
hN;Vookno_ooooooo_knooomoP3aooooo`0@ookno_ooooooo_knooShn?o_ko7ok^k`ono_lOo_knoo
knoaoo3`l?o_ko7on?Kgoj^Z^?nn^lKoFW:Do`4hN`Wo042000?o041no`10P?l0@8000_l0@8000omj
KHOoook>ooobaP17ooobaP04ookca_ool/Kooo;6ookcaP;ooo;604Koo_;8ooocbOokk/;ogKV7on:Z
KooLZWGohlUdoo[aK_oPcG7oc:5donG5L?oikW;on>Ihoo3FMooNY7Cohk=aooKMN?o`cG_omMifoo7?
MOoLXW3om=Amoo;ZZooOe7[om=9aonJ_M_ocfg7onoE[ooc[NOoNbhWok=iaonc3M?oZ^gOom^5hooSW
MOonkZ3ofLZCoo3BL?o]_WKok<5cooCMLoookZKohMJYon78M_okjWKokmUconW2MOo]a7Gok<Efong7
M?odeGSom=Amoo7CNOobd7Wolm1loo3AMooedg[ol=5gonc:LoobdgKokMAhomk1Loo`e77ol=5foo3>
MooacW[ol=1ionK6LooR_WCoklYi0_o^c7D03?oZbW?og/5eom6kL_o/b7Coj<AhonG4Moo^agSoj<Ed
ong1N?nkY73o^Z]bom2lM@;oc[Ye00[obkIeolRfN?o3]GCofkUaoo?>P?omk;kojlb;on>nL?o`agOo
k/Ef0_o]`W@01?o]b7[onnZdooodc?ool/H2ookbb004ooodaoooom7oOFn9o`0kOA;o042000Ko03Mj
od9/W?ono_;of=WNomkMh_oPgn@9omoNh`03on3Oi?oOg^?oh=oT00?ogmkS0_oPgn@00ooOg^?oh=oT
on3Oi002on3Oi0WogmkS0_oPgn@01_oOg^?oh=oTomoNhooPgnCoh>3Ron3Oi0?ogmkS0ooPgn@01?oN
gN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_knooooooono_kooogn0?;ooooo00oo
o_knooooooohn?Sok^k`ono_lOo_kO3ol>kaono^loo_kO3ok^k`ooSfmon/[;So_[_6oeYbU?l1>7/0
2Ol0@8000ol0@7ko0420o`10P002o`10P003ogY]Qoooo]3oo_;804Woo_;806Gooo?9ookbb?oollWo
oo;8ookbb?omm<_onno9ombgPooQY6koe;1bonkLK_oTg6go^YeaoljRLoo`fG7on>eaoo;CN?oJVg;o
i;5`ooCKM_ocdGOom^5dooSTLOoTZFook/acooof[ooLdYgolnA_onZiMooV/7;onNI`ooofKOo_gG_o
e/Ujoo?HKOoX]7Sokm1cooGJLoojjGGom>:JomK2OOo_aWCok;adoo?ELoofhGSonnZUolo0UOoVcG7o
o>Ifoo;AM?o]`WCok/1con[4Looce7Wol==goo?DNOoceW[ol]=hoo;@Moo`d7WollmiooC@N_oacgKo
lLmeooSHMOoZc7Koj<]_onG5K_oZbW?olLegoo3>Moo/c7Goi/=aonS1M?oT_fooil9bonc:LOoWagCo
f[eaom^nK_oV_gCohka]omk2KooZaGOokLAeomnhMOnYVfcob[EbomRoKooO_gCoiKmdomnnLOoH`7Ko
c/:5ombnMOoefJOon>Rdon:lLooY_g?oj/Eeon_4M`02onc3M003ooSPX_oom/oooO7700;oo_;800Co
oo?9ookmdOmmKhWo03]m4_l0@8001_l0=g[o@VbLooknl_oHfMkog]gRon3Oi0KogmkS00Coh=oTomoN
hooOg^?oh=oT0ooOg^<00ooPgnCogmkSomoNh`02omoNh`03on3Oi?oOg^?ogmkS00WogmkS00CogmoQ
omoNhooNgN;oh=oT0_oOg^<00ooPgnCogmoQomoNh`02on3Oi0CogmkS00Cog]gRomcMh_ono_coEW^W
0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`0@ooknooooooooo_knooWi
mooXjN?ohN7IomkNe_oMgM?og=gEomoOeooMg]KolO3[ojb/]?nn^lKoFW:Fo`4gO@Wo042000Oo041n
o`10P?l0@83o0420o`11POmjKHWoookB04oooo?906_oooK=ooWa`ooI]83oeZ5_omZmLOo`iV_oYieZ
ojn=J_oF]G3omnM]ooSTM?oNY7Coh:e/ooOOLOoddgKomNA`ooc/L_o[`W;ojkaZooo_UooXgkSogmI_
oo7?K_oSYg?olM1aooccJ_oom6[oe<M[omc<K?o`_g?okL=_oo;EKoo_aWCooNafomK5OOoA]Vook[ib
on[4LooghGCon>1foo7OXOo4/X;ok=AbooGCL_o[`Fook<9`onk0L_obd7Koj<efomVoL_odeWKolmMc
ooCHMOoadWOol=5foo7?M_o`d7WolLmfoo7>M?oedWCokm5gonK8L?oK^G7ohL9_oo7=Koo`c7Cok/md
onc:LOoT_G3oh;Q`on6kL_oV`G3ojlM_onC1KooK_VkohKa/on2kKOoP^Fkog<5`onO2L_o/`g7ocJ]^
okVVJooL`6gohl1_onO0Looa`7ColLYooo_Y^ooZh:gog[]iooCL[?o`f9[oh[Q/onc3Loo/`WKok<5b
ong0Kooae8kooOC;ookec?oom<[ooo?;ooocbOooom?oOFn9o`0kO`0Bo`10P006o`0gN_m2K9coo_kb
omSIg_oNgN;oh=oT2?oOg^<00ooPgnCogmkSon3Oi006omoNh`04on3Oi?oOg^?oh=oTon3Oi0_ogmkS
00KoiNCYonKVj?oVi^Soh=oTomkMh_oPh>87omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ii00001on[
Z[SoXZBcon7Ri_ono_koooooookno_oooOh0loooool03_ono_komoOeoo;akOo^kNSokNcWonk]j?o]
kNGojn_Sonk^i_ofmO3oXZ>XoknlaomJLYKo03Qk2Ol0@8001ol0@7ko0420o`10P?l0@7ko0461ogY]
ROooom<0B_oollT0L_ooll_ooo?9ooocbOoollWooo?;ooofcOogk/OofK22om2QJOoWd73o_k=YoiR8
Ion[TFcogLE_oog`KOoT]G7ohJmZooGMKoodfG;omnI`ooWYL?oadg7oj[a^oo[XK?oii:oohMfFoo7G
I_oUYgKoklQ]ooOTJoojkVSon>iZomO>JOoae6cojKA`oo?KMoo/_W?oklYaooSXKoo3]VOoi<5_onfl
KOocfW?olmEcooONMooUdi7obKEfonoAK_o]`6oojl5_onfoL_o`bg;omMUeomFiL?oG_6oommMdoo7B
MooffWKom]Qeong?Kooad77ol<idoo;>M_o`cWGol<e_oo;DM?obe77ofKA^omflJooccW?okLY^onk=
L?o/bW3oil5/on:hK_oP^FkogkY/onFoK?oXaG7ogKmWomnlJooS]g3ohKY_on:hK?oK_6WoiL9`onNn
K?o1Y6coaK=[onK0KooQ_Vgog[e^onboK_oacH?oonk2oncJZ?oO_7Sol]^_onS3OOoU_6cokL9confo
L_o^_fookLUmoo_]__oom/ooooC:ooocbooollWoo_oCoge_ROl0>goo0420o`10OP;o042000?o041n
o`10P?l0@8002ol0@8001_l0=g[o@VbLooknl_oHfMkog]gRon3Oi0KogmkS00Ooh=oTomoNhooPgnCo
gmkSon3Oi?oOg^?oh=oT00?ogmkS0_oPgn@00ooOg^?oh=oTon3Oi00:omoNh`06onWXkOnVYZSo=SHf
ohB4Q?oTi>Koh=oT2?oOg^<01?oNgN;og=gRookno?mFNjL1o`0fN@0000OoZjZhoj:T/ooQh^Koo_kn
ooooooono_kooogn0?;ooooo00Ooo_knoooooOohnOCoko3ZonSXh?o]kNGoj^[R00;ojNWO00Koi^KL
oo;bj?nNWj?o_kc7oe]cUol0>7/9o`10P007o`10O_l0@83o0420o`10O_l0@H7oNVf;ooone@18oooc
b`04ooodc?ooll_ooo?=ooodc0;ooo?;06koo_G>ooogd?ogjlGodZIgomNfIOo6^fWo^IY/ok>OJ_nW
UfKolMe/oo7AK_oR/V[olm]]ooWOK_ofiVgon>AaooKRL_oae6con^aYoocXMooRdI_ogl]ZonJ]J_oW
]f_olMMXoo7=K?oolVSoj^9VonSII_o_aVcol]AbooSSR_o[_gKolM=`oo7RJooGb6WokL1]onk;Koob
dVookL=aooWSM_oJah?oe/5boo;>K_o[_6kojke_on_3K?odeg7ommMbol^bL?oM_Vkok/e`ooGJKoob
fG;omMe_omFjJOoTaVkolm1bono<L_o^cWOokliaoo3@KOoef7;oh[m[on6jKOoW`G3ohke/ong8Koo/
bfcoj/M]on>iKOoQ]f_oh;U^on6gJooP_F_oh/AZomVmJ_oP^FcogkQ[on2fK?oO^6_of;UWon32J_oJ
]Fko`jaYomBgJOoW^Fcog[M/omZiK?oU^fWolLElooWT]OoWf:7oi;imoo3FYOoR_Fooj;Y]onfoLOo]
_Vkoj[maooSQZoonm]7ooo?=ooodc_onmLcoookEoge_ROl0>goo0420o`10OP;o042000?o041no`10
P?l0@8002ol0@8001_l0=g[o@VbLooknl_oHfMkog]gRon3Oi0KogmkS0_oPgn@3omoNh`04on3Oi?oO
g^?ogmkSon3Oi13ogmkS00Gok>_`ohV9RomYJFWoCdm?on?Si@05omoNh`Coh=oT00CogmkSomcMh_on
o_coEW^W0Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3aooooo`;oo_kn00kooooo
ooOgmOoblnkoj>ORon3Ofoo_k^[ok^gXomoNf_oTi=comOG]oijOXono^lWoFW:Do`0jNPWo042000Oo
041no`10P?l0@83o041no`11POmjKH_oookG04SooOC=00?oo_G>oooccOoom<h00_onmLh0Kooollgo
o_G>ooogd_ofil3oaZ9bokfZJ?njVfcoe:]]ojfOH_ngZ6Gom=iVonJlJ?oghFWon^I]ooKVK?oghg;o
nN=/ooGVJOojkVKooOERooCQQOoNcG_oiKEYon>VKOohi7Cok/=donk=K?oilVCohmQTonc>JooabFWo
m^5doo?JLooaf77omn9_oncMJ_oRa6[ok/9YooKONOoY_G;ojKaWooOQL_o@^G?ohlY^ono8KOoZ^F[o
jki]oo;AL?o]c6gok<M^olF]KOoUafooil=]ooCJK?odgVkom=abonG?K?oE^6Sokle[oo7?K_o]bg7o
l<econk;KOo`dVookLeZon:iJ_oL]FSogkE]onFlJ_o[b6[oj/UZonFlK?oP]6WogkIWomneJOoP]FOo
hKUTom_0IOoL^FSoh[AYon2eIooS/fWoh;AYomZfJ?oL_VSoe;A[olZcIOoK]fWoi;IYomZbK?oF]V_o
hKQXonk3MOobgJCohljEonS1Q_oVa8Coh[UWonfnK_oZ_6kojka/ooKGU_omn=;ooo?@ooodc_omm<go
ookGoge^Rol0>goo0420o`10OP02o`10P003o`10O_l0@83o042000_o042000Ko03Mjod9/W?ono_;o
f=WNomkMh_oPgn@8omoNh`04on3Oi?oOg^?oh=oTomoNh`;oh=oT0ooOg^<00ooPgnCogmkSon3Oi00:
omoNh`06on3Oi?oViN[o][JhofQXJ_nKVigohn;W1OoOg^<3on3Oi005omoNhooMg>7og=gRookno?mF
NjL00Ol0=WT00007oj^Z^?nRY;?ohN;Vookno_ooooooo_knooomoP3cooooo`0>ookno_ojn_SolO;/
onGVg_o=cLGofm_ComcLe?o9b<?ohn?IooGejonNWj7o_k_9oe]cUol0>7/8o`10P0;o041n0_l0@800
1?l0@7ko0461ogY]Roooo]M9ookecP;oooC>0oonmLh0K_onm=3oooSConkO]_n[V6go[YE/olnJJ?oH
_FcoY99RolVoH?ohgfWomNMToo[XJ_ohiV[on>YWoo_ZI_ogkf[on_9SoocaI?ojlFKog<MfomfjJOoR
YFKom=QZooSXT?obd7Komn5YooO[HOo^h6Kol]5XooCMKOobfg?ol]M`oo;IL_oghVgoi=5XonBkJooe
e6_omn1jon[3M?oZ_F[omM]]olbeIOo[dV_ojl5[onVjK?o_b6WolmMdonK0KooF/VKo`jU/ongAK_o_
b6_ol]=YooWOK_oaefWom=a`onC5J_oYaVSol<mXoo3<Joo^bfgoklYaoo3?J?o`d6Woi[e[ombbI_oO
]6Kog[9Yon6kI_oXb6GojL9Won2dJOoO]VCohKURon>jJ?oP_F_ohL=[omk2K_oN^f[ofkMSomjdH_oK
/V?ogK5VombcI?oF]V?oc[EUolndIOoO/fSog[EVom^dIOoC/fSogkIWonflKoobe9Sog/J:onK0POoM
]W?oi;UZon^nKOo/^FKol<^4oo_fc_oom=7oooK?ookdd?ooo]OoOFj;o`0kOol0@83o041n0_l0@800
0ol0@7ko0420o`10P00;o`10P006o`0gN_m2K9coo_kbomSIg_oNgN;oh=oT1ooOg^<03OoNgN;oj^W^
oo3_m?o^kO;oh=oTomoNhooPgnCogmkSon3Oi?oOg^?oh=oTomoNhooPgn@02_oOg^<02?oOgn7ogmkS
onGTjOo^kO;ojNS]omkMh_oPgnCogmoQ0ooOg^<02?oPgnCogmkSomoNhooOg^?og]gRomcMh_ono_co
EW^W0Ol0=WT00003ojV[]onTXkGohN7S00;ooooo00?oo_koooooooono_h00_ono_h4ooooo`;oo_kn
0oooool00oono_koooooooknoP02ooknoP;ooooo00Goo_knooooooooooooo_knooooo`06ooknoP;o
oooo00?oo_knooooooono_h01?ooool2ooknoZSooooo00?oo_knooooooono_h00oono_h01Ooooooo
o_knooooooono_coo_kn00Cooooo00_oo_ooookno?omookoookoookon_onooooooooookooOoooogo
o_knooooo@02ooooo`03oooooOono_koo_kn00;ooooo00ooookooogoo?oin_GolO;/oo3ak?oYj>Co
bLW1olW8`ooRhm_ojncVooGekOnNWj7o_kc7oeYdUol0>7P02Ol0@8003?l2?gko0420o`10P?l0@7ko
0461ogY]Roomom[oooCBookddOoomM7oo_C@oooed@;oo_C@1?oomM42ookdd003oooedOonm=3oo_C@
033oo_C@00CoooGAookdd?onm=3oooGA0_onm=001?oomM7oo_C@ookddOonm=02oooed@1^oooddOon
m=7oo_KBoooieOoPdZgoXXmUom6GIOoIYFWohl][oi^AG?oVfV3oo_=UoocaI?omkV7on?MOooc_Hooj
kf;ono=PooSbG_olm6?oknMRom?6H?oTZfKok<UUooKXJoobe77om=Q]ooKSJ_ogkekomN=SooGOJ?oc
ffgol=Q^oo?HKoocf77om=mZong>H_o]dVWomMe_oo3HK_oceVkol=AYonkHJoo;]VOokm5_onViIOo/
_f[ol]I[oo;HMoo`bhGobZMWoknWJOocdg3ol==]oo7=K?oehfOolmUZooCJK?o]cfcok<QXono=JOoa
d6WoklaVono:Koo_bf[olM1UonK1I_oL/fCogK=YomfbHooN/6GohKUTonO3HooW`VOoj<Ufoo;KUoog
i[;omnZfooS[__oik<3om^Rioo7PZ?o[eYGoiLf7omboLooJ]FGoe[=OolbbFoo;/Egoe[9TomfcIooP
/VGog;9VomZ^IOoN/6GojKY/onk;QooK_Wcof[=XomjcIOoY_6_ok;aXonZkJoohi;;oooSDookddOon
m=3ooooIoge`S?l1>Wd2o`10P004o`0oP_l0@7ko0420o`10OPWo042000So0Sn0o`10P?l0@83o03Mj
od5]W?omoo;oemSLomkMhPOogmkS00WogmkTonKUj_nNWZ3oMWIfohJ6R?oJfMkohN3VomoNhooPgn@0
1OoOg^<00ooPgnCogmkSomoNh`08omoNh`;oh=oT00Gojn[_onc[l?oUi>WogmkSon3Oi007omoNh`04
omkMh_oLgN;oo_kloeIkY`7o0CIj00001?nZ[;SoXj:domCCf?obl_02ong]k@03ong]joo^k^kokNg]
00Cok^k^00?okNg]onk^k_o^k^h01?o^k^h01Oo]kNgok^k^ong]kOo^k^kokNg]00?ok^k^00?okNg]
onk^k_o]kNd00_o^k^h3ong]k@;ok^k^00?okNg]onk^k_o^k^h00_o^k^h00oo]kNgok^k^ong]k@2[
onk^kP?okNg]1?o^k^h05oo]kNook^k/onk^k_o]kNook^k^ong]kOo^k^kokNg[onk^k_o_kNkol>_a
onk^k_o]k^WolNg^ono]l?o]kNgok^k^ong^jOo^k^cok^k^onk^l?o]kNgok^k/00;okNg]00ookNg_
onk^k_o^l>gom?G`ono^j_oem>ooiNSOon?Sfoo^k^Coj^WTooCfjonQX:Ko_k_9oeUcU?l2=g/02_l0
@8002ol0@8;o041no`10OOl0@83oNff>ooknf?onm]7oo_KBoogedOoomm?ooOGA00;oo_KB00?ooOGA
ookddOoomM800_oomM800oonm=7oooGBoooedP0coooedP04ookddOoomM;oo_CAoooedP;oo_CA03So
ooGBoogedOonm];oo_KBookddOoomM;ooOGAoooje_oBa9goaYASomZFIOoE[fSohl][ol^oFoonm5ko
o?ELoo[`GOokkfWoj[][onBaH_ogiEgooNiOoogaHOomlf3oh=MPon:eI?o[`f?on^MVooCEJoo_ef_o
l]I[ooOUIOojkF3on>AWooGKJ_oaeVgol]M`oo;FJoocfF_om=mXoo?JI?oeff[ol]][oo7GJOobefko
m]a]onS?J_oE_FGol<UZonNiI?o^dF_om=]gooCIO_ocfY[oaJI_okjVIP;ol]9[01Sokl]]ooGLJ?og
hfKol]IYooONJ_oJ_6KoilIWono?J?oVa6;oklaTonk;Ioo_c6CokLMRomjcI?oK/67ofk1Ron2aHooU
_Ekokm1moo_W]OomlLWoooCDooogf?oommH2oogge@0RooofeOoomm?oooKCoooed_okklOolnRjoncI
WooOagoocKMRolb]F_oG[Ukog[1RomfbHooL/fCogJiVomF]Ioo[^6Goi;Ybolj[JOoO/F?oh;9TonNj
IooZ]fCoklV2oogedOoolmKoo_KBoogng?mmL8co03Ulo`10O_l0@83o03n2o`10OPco042000Oo0D61
o`10P?l0=g[o@ffMoogmlOoHfMgog]gR00SogmkS00Sok>c^obd];Ol0003o0@41om;Be?oVi^Soh>3R
omoNh`;oh=oT1?oOg^<00ooPgnCogmkSomoNh`06omoNh`08omoOhOoQhN?oemOIoi>CUOmmOGoo_ko1
on?SiOoOgn42on3Oi003omoNhooPgnCogmkS00;ogmkS00Cog]gRomcMh_ono_coEGbW0Ol0=GT0000:
ojb[^onRXK?oHf=Sog=cJomWIV;oI6ARof=TG_mSI5ooIFAPofASG`CoIFAP0_mTHel03?mSI5ooI6EP
of=TGomSI5ooI6EPof=TGomTIF3oHfAOofAUH?mSI5ooIFIQof=TG`?oI6EP1OmSI5l01_mTIF3oHfAO
of=TGomTIF3oIFAPofASG`?oIFAP00?oI6=OofETH?mTHel0N?mSI5l`ofASG`KoHfAO0_mTIF000omS
I5ooI6EOof9SG@02of=TGP06ofAUH?mUI6;oIFARofASGomSI5ooIFAO0_mSI5l06omSI5koHV=NofET
H?mTHf7oIFARofASHOmUI63oI6=OofETH?mUI5ooI6=Qof=UH?mRHV3o@T90ok>d[ooooOSom??^oo7b
k?oblNcoko3Zonk[i_oZj^3omoKaojBT[?nm_LOoGG6Fo`4hN`0<o`10P007o`10O_l0@WooNVn?ooko
foommm?oo_SDookheP02ooogeP03ooofeOonn=Koo_SF00GoooSD00?oooOCooohe?oon=@0<_oommH0
1oonmMCoooOFoooge_oommKoooKEoooge_oon=@00_ommm<0Coonn=CoooOCooohe?oonMOoo?KDolja
QooLTekobi=Pomg3I?o/e6SolnQJookiNoodfWWog/5SonJcLOoLTV?ol<]Poo7?HOoikEgoo_QLooK[
FooQbEgok;QRooWUH?ogg6OolmMYooOGJ_ocfF[oo>ePoog/H?ojhF[om=QZooCHJoodf6[om]QZooGI
JoohhfKomn5WooKMJOodf6[om=UXooCHJoofgFWojLiUonS;Hoo^a6;olLUWoo7@IOo`c6comMQ`oo_W
Z?o6[X3oaZYQooSJK?occF[ol<YYoo;?Ioobg6Col=1Yoo[QJ_oG_V7ofkUPoo3AIooL^6;oklaToo?>
HoobcV3olLYSonJjHOoM[63ohKAQonc6IOoggI;oo_G>oo_jfoomnMKoooOFooggdooon=@00_oommH0
9?oom]Goo_SFookhe_oln=Goo_[GoookgOonnmcoooOBooW[__oZfJ7oglN1omZaH_oL[ekogZmOomnb
HOoM[V3odjaQonNgHooI[f?oc:UUomnbHOoU^6Goj[]Son^hIOogh:[ooo[Hoocfe?onomooOFn@o`4k
Nol0?ggo041no`10P?l0@7ko0420o`0oO`So042000Wo041no`11O_l0?goo0D61o`0fO?m3Jikoo_kb
omSIg_oNgN801ooOg^<01_oPgnGok>_`obPX:_l10@?o0002omCCf0;ogmkS00?oh=oTomoNhooOg^<0
3OoOg^<01ooPgnCogmkSomcKh?nc/kGoZj^]ol_:cooQh>D00_oOg^<01?oPgnCogmkSon3NhooPg^<2
omoNh`04omkMh_oLgN;oo_kloeIkY`7o03Ei00002?n/[;SoXZ6_on3Oi?oooogoo_knooonooono_ko
oooo0_ono_h01Oooooooo_knookno_ooooooo_kn00?ooooo00Coo_knooooooooooooo_kn0_ooool3
ooknoP03ooooooono_kooooo00;oo_kn00Koooooookno_ooooooo_knooooooono_h3ooooo`;oo_kn
0oooool2ooknoZcooooo00Koo_knooooooooooooo_knoooooOono_h2ooooo`?oo_kn0_ooool02oom
o_ooo_knooonoooooOooo_oooogoo_ooo_ooooomookno_ooooooo_kl00;ooooo01;ooOgmooooooon
o_coookoookooooimoSon_WgooOhlooem_7om?3]oo;ak?o_l^_ok_7VooonnOnXZJko_K[5oe]bU?l0
>Gl;o`10P007o`11O_l0@83o0420og=XR_omo]Cok^O:oo3WbP02onoVb@03onkUb?o_i/WoknK900Go
l>O:0_o_i/T00oo`il[oknK9onkWbP0`onkWbP0`oncUb?o_j<_okNK9onkWb_o]i/Wok^O:ongVbOo_
i/Ool>O8ongWaoo_i/OolNS9onoVbOocj/goh]^noknHKoo<S63o_i]Qon38J?oMb5goj]YQon_HW_o>
[GSodjUMol^7H_oNaF3oi/APomb^HOoZh5[ojnEMon3HG?oK^5coj==PonG?JOoPaf[oh/YZon;8IooT
cFGoj]aOonSGIOoSbfOohl]Yon?<I_oTcFOohl]WonC<J?oXdfKoi]5X1?oRbVP08ooSbfOoglQRomo6
HOoN]V7oi<YYomVbIOoH[f3oi<QTon[IXoni[8co`JIOonK:I_oN]UoogK]Ton2lJ?oL_VKof[YWonC;
IooPb6KodK9PomRiI_o<[6?og;YQomVgH?oQ`67oh;eOomRbGoo=YEoof[MKonOCV?o_j<_olNK:oo7U
boo/ilOokNS:00Cok^O:00?okNO7onkXb?o^j<P00_o`ilP07_o_i/OokNO7onoXboo_j<colNc?oncV
a?oMdJOobKAcolZXHOo?Y5oocZIPolfTH_o0WF?oeZ]VolVSH_o5Wf3od:QRomZ^IOoJ[67og;E`onoR
_ooaj<_oook@ogAXS?l0>Gco0D61o`10O_l0?goo041no`0oO`[o042000So0461o`10P?l0@83o03Mj
od=[W?omoo;oemSLomoNh`;oh=oT00oogmkSon3Oi?oPgnCogmkSon3Oi?oOg^?oh^;Tokno`OnYZJ_o
_Kfoohb<S_lg=cWoPH63onSWk?oPgn@01_oOg^<8on3Oi007omoNhoo[j^ooVYZLo`000_m_Kg7ojn_]
on3Oi002omoNh`0:on3Oi?oQgnCohMoTon3NhooQgnCoh=oTomkMh_oLgN;oo_gkoeIkY`7o03Ei0000
1?nVZ;OoYjVhoijL/On/Zkd2ojRW^@05ojZY^onXYkWoZJRjojVX^_nXYkT00_nYZ;X01OnXYkWoZJRj
ojRW^OnYZ;[oZ:Ni00;oZJRj00GoZ:NiojZY^onXYkWoZJRjojRW^@04ojVX^P05ojRW^OnYZ;[oZJRj
ojVX^_nXYkT02?nYZ;X01?nXYkWoZJRjojVX^_nYZ;X2ojRW^J[oZJRj0_nXYkT4ojVX^P04ojZY^on`
[/?o[jg2ojn^_P;o[Jnn0_n^/;l02?n][kko/:nmojb[^onXY[_o[:^kojj]^on`[koo[jk00_n^/;l3
ojf__P0:ojn^_?n_[[koZ:NiojVW_?n][/;o[;;2ojV__on]/<7oZk;2ojZc`P;o[;7400Oo[k76ojb_
`_nZZK_oT96Vol:oa_mILiCo03Mj00So042000So0Sn0o`4nOOl1@8?o03n2o`10P?l0@WooFE60olC1
_0;o];Bb00Co][Jdok^k^Onm_[Wo^k^i0_ne]K<00ond];;o]KFcokFe/`04okBd/S7o]KFc00?o];Bb
okFe/ond];800_nd];84okFe/`1BokBd/_nd][?o]KFcok>c/One]K?o];Bbok>c/Ona[ZWo/jj[ok6`
[_ne/Z_o/kB^ok>cZonc[jco/K:/okRg/_nc[Z_o]KF]ok6`Zone[J[o];BXokFe[Onc/j_o];6ZokNd
[one/Z_o]K:Yok>d[?ne/Z_o/[>[okNd[Onc/j_o];B/okFbZOnf/jco];B/ok>cZond/jko/k>[okBd
Z_nd]:co/k>[ok>b[Onb/Z[o];>^okJcZ_ne/Z_o];2]ok>cZond[[3o/ZnZok>cZond/k7o[jn_okBa
[?nc/Zgo]:n[ok>b[Onf/ZWo]K6Xok>b[Onb/Jco];B/ok6`Zonc/Zgo/[6]ok>`Zonb[Z_o]K:[okFa
[_nd/JSo/[6/ok>_[?ne]KGo/kFdokBd/_nd/joo]KB`okFc]?ne];;o];BbokBe/0;o/kB_01go];Bb
okBc/One/kCo];BdokBd/_ne];;o]k>bokBf/ond];Co]kFfokNg]Ond];;o[k2[ok6`Zond[j_o/[6]
ok2`Z?na/:co]K2Zojj^[?na/:_o/jn/okB`[Onb/Z[o/k:^okFe/oo0`KWoGE9lo`8mP@02o`10P004
o`51POl0@Gko0461o`0oO`[o042000Ko0D61o`0oOol1>7_o@VbLoocnlOoHfMd2omoNh`03on3Oi?oO
g^?ogmkS00?ogmkS00Woh>3RomoOhOoVi^Sojn_]oooooommOGooHV9Toe]KFooXin`00_oOg^<00ooP
gnCogmkSomoNh`0:omoNh`03on3Oi?o_ko7oQHF700;o000000Goj^[/omkNh?oPgnCogmkSon3Oi005
omoNh`04omkMh_oLgN;oooomoeAkYP7o0CIj00002?nYZKGojnc^omSIgOoGe]_of=WNomOHgOoFe]ko
emSL1OoGf=d00ooHfMkoemSMomOHg@02omOHg@07omSIg_oGf=gof=WNomOHgOoHfMkoemSMomSIgP02
omOHg@04omSIg_oGf=goemSMomSIgP?oemSM00?of=WNomOHgOoHfMh00ooGf=d01ooHfMkoemSMomSI
g_oHfMkoe]OLomOHgOoHfMh0[ooGf=d2omSIgP05om7Beonk^lOo][S4okRka?nh^/H00ong^LD02?nh
^lCo][W2ol[:e?oJf]coeMCLok^mbOnf^L;o^;_40_nh^/H02Ong^LGo^KW5okZja?ng]l?oaLOComOK
f_oEfN;oa[c4ol:]]P02olF`]`0;olBa]oo6[kOoaK2iolF^]_o2[k?oaL;9omOLh?oMg>7ooOGXoe=[
TOl2>G`02?l0@802o`11OP0@o`0oOol0@83o03n2o`11O_mVGXgoin?Hom?Ad_oDe=CodM7CokFf^?nY
ZZco/K:dolc<c?oEeMGod];Bom7Ad@Cod];B00?odM7Aom;Bd_oBd]@0;ooBd]@3om7Ad`0gom?CeOoA
dM?odM7Com?CeOoIfM_ofm_KomGEeOoGemOofMWKomSHf_oLg=kofm_MomSHf_oHf]Ood]?EomWJg?oJ
f=_of=SJomcMgooNg^3ob<S8ojf[[_oLgN7ofMSMom7Cd_oBdmSof=WMom?De_oAd]Koe=OLom_Lg_oK
f]oof=WMomKGfOoDeMOog=_Qom[Ig_oDeMWof]_MomGEeooIfM_oemSLomKGfooKg>3oemSLom?Bf?oB
e=?od]?Gom;Cf?oBdmGodM;Fom;CeOoCe=Wodm?Eom3De@02om3De`0IoloCe_oCdmGodm?Com;DdooB
dMKod=CEom3Cf?oBdMOodm?EoloCe?oDd]Oodm;Gom?CeOoBdmOod]CCom;Be?oCd]OodM;Fom?Df?oA
d]Cod=7ComCCfOoAdM?od];Bom7Ad`02om7CdP05om7AcooCdM;odm7Bom?Ad_oAdM<01?oBd]@06_oA
dm3od];@om;Bd_oAdM?odm7Dom7AdOoAdm;od=7Com3DeOoCeMCodm?Eom?Df?oCdmGoe=?Hom7DfOoD
e=KodMGHom?CdooEdmKoe=CFom;CeOoDd]GodM3EonCTg?mXGhco03]o0_l0@8001?l0?goo0461o`0o
Ool1@H49o`10P007o`8oP?l0@83o0420o`4hNom1KIcoooocomSIg@02omoNh`03on3Oi?oOg^?ogmkS
00?ogmkS0_oPg^<2on3Oi005onCSj?nm_KooS8Z=okFc]_oThnP00_oPgn@3omoNh`;oh=oT2?oOg^<0
2?oPgnCoiNCYol?2aonBTYCo[Jf_on;Qi_oQh>GogmkS0_oPgn@6omoNh`03omgLh_omoocoEGbW007o
03Ei00001_nUX[Goo_knoooooooooogoooooooknoP;ooooo00Goo_knooooooooooooooooooknoP04
ooooo`;oo_kn00Coooooookno_ooooooo_kn0_ooool2ooknoP06ooooooono_koooooookno_oooooo
o_kn0_ooool00oomoOgoooooooknoP02ooknoP06ooooooono_koo_knookno_ooooooo_kn[_ooool2
ooknoP0Booooooono_koZK33ogb1W_moPjKoOX:Uogf1Y_mnPZOoOhBToh66Y_mnQZ[oOH>WohnE[Oon
ooWo`<3<og^2WomnQ:KoOH>S0_mmPjL05_mmPJCoOX>Sogb2X_mnQ:SoQ8nUongmlooFbm7oYSUFok4_
Bona?E3o[Sm@ok11D_n[?dko[Sm?oj`oD_n_:SooYDmXon3IhOonooooo_kbod]WS_l0>7/8o`10P00B
o`0oOol1@Goo041no`10P?l0?h;o049nofIPS_o]i]coeMGCom?De_nJWZ7oXZN]om7Hg_ni_/;oU9RK
olS9booHf=Soe=CD0_oEeMD00ooDe=CoeMGEomCDe00bomGEe@1IomCDe?oEeMGoe=CDomGEeOoGemOo
c/k>oiBDU?n@T93ob/[:okZj^_nSXj?o][Jfoi>CTonMWIgo/k>cokRh^_oPg=goZjb`ojZ[[Onf]kWo
SXj<ojNYY_ng]kWoATY;ohb<R_nh^K_of]WGomKFf?n`/Zooa/C7omcLf_o5`<CoT9FAoiVIUona/K7o
][Beom?CdonHUi?oVYZLol_;bOnOWioo_knoojj^[?n/[:[o_[k0oh^;Rona/:kof=OLomCDe?oEeMOo
e=CFomGEeOoDe=;oeMGEomCDe?oEdmCoe=KEomKEdooFe=GoeMGEomGCe?oFe=Ooe=CFomCDe?oCeMCo
e=KComGDfOoEeMOod]CComKDeOoEeMGoeM?Dom?CeOoDe]GoeMGEomCDd_oEeMGoe=CBomGEeOoFeM?o
dmCFomKDeOoEdmCoe=GGomGEeOoEdmCod]KGomCDe_oEeML00_oDe=@2omGEe@;odmGD01_oe=CFomGE
eooDe]GodmGDomGEeOoEeMOoe=CFomGEeOoGdm;oeMGGomCFdooDe]Goe]CEomCDd_oEe=3oe=CDomCD
d_oFe=Goe=CDomCEeooEeMGodMGDomCFdooZi]goJF2=o`0kOOl1@H400_l0@8000ol0@H7o0420o`10
P008o`10P008o`0oOol1@H7o0420o`8oO_l0=WWo@VjMoooklooGf=d2omkMhP04omoNhooNgN;og]gR
omoNh`;og]gR0_oOg^<01ooMg>7ogmkSomkNh?oTi>Kok^k`onKUj_oMg>400ooNgN800ooOg^?og]gR
omkMhP09omkMhP0:omoNhooMg>7oi>?Xong/lOoXincogMcQomkMh_oOg^?og]gRomoNh`Gog]gR00Co
gMcQom_Khoooo_coEGZV0Ol0=gX00008oj2PZ_ohn_WoloChonSYkOoJfn3ofM_JomWJg?oKfnD2omWJ
gP0UomSIgOoYj^kom?Gioo;cmooin_kon?WmooSgo?ofmO[omOCioo_joooblOKooOcooo7`mOojnOko
mOCioo?bmoojnOkolO3eoogloooblOKomOCioo[io_ogm__onOSmooSgo?oem?Won?Oloo[io_ohmoco
m_Gjoo7bm_obloOoloChoo;cmoojnooom?Gioo7bmP1ioo?dn3;oloCf00?ol_?eoo?dm_obloD00_oc
m?H0:Oo^ko7oT9B]oifP_onZ[/Wo]kW>okJhconh^]?o[Jk:oj6R`?nTXl;oY:G1ohZ?[?oAe]coX:Fk
oiNL^_n[[<So^[[DokVidOnh^=3o^;SBokVidonc]LcoXZG4ohZ?[oo:e=gobhRAokPcA_o7EU[oadaA
olUAF_o9EUgobEENolM?FOo8C5CobEALokDM<_o?WZCon_oloog^jOm=IHWo03Un00[o042001?o03n2
o`11O_l2?h3o049nofUQT?oklNOohN7OokNh^_moQ8[obm?NonG_nooLiNkoTiZPoiNLX?oRh^;ofm_K
om[Jf_oKfm_of][J00?ofm_K<_oJf]X2om_Kf`0^om[Jf_oLg=codm?CokVi^On=SHgoOWinog]kNonU
YJGoP820ofMWIomNGUkoUiNGohN5Q_oNh^7oGV9Qojj^/?mkNWSoQHF7odQ6BOn`/ZooKVi`oi^IV_me
MgKof=SHon?ShOmSHFCoYjNYookno_nCTICoFEUGodU:C?nKVi_oOG]loi:BT_mPHF?o/K6aok:b/_m[
Jf_oalO9ofi^K_n][J_oHVASohF5QOnl^[_og]kLom_Kg@;ofm_I00_of][Lom[Jf?oKfmWofm_KomcJ
gOoIfm[ofm_IomcJfooJf]cof]cIom_Kf@02om[JfP06omcJgOoJf]SofM_Jom_If_oKfmgof][H0_oK
fm/02?oJg=_of]cIom[Jf_oKfm_ofm_Mom[Jg?oKfM[of]cK0_oKfm/2om_Kf@05om_If_oLf]_of][J
om[Jf_oKfm/01OoJf]X01_oKfm_ofm_IomcJgOoKfmgof][Hom_Kf@;og=[K00CofmcGom_KgOoKfm_o
f]cK1?oKfm/03ooJf]cofm_MomWKf_oLg=cofM_Jom_KfooKfmgog=_IooK_iOm/Hi3o0Celo`10P?l0
?goo0D61o`0oO`0<o`10P007o`11P?l3?X3o03Mlod9^WoomkncogMcTomgNh`07omkOi0;og]kV00Oo
gmoWomkNi_oNgnCog]oTomgMiOoNg^KogMkS00Kog]oT00?ogn3UomkOi?oNgn@01_oNgn@8omkNiP05
omkQj?oPhn[oh>?Zon3Sj_oOh^T00_oPhnX01?oMh>OofmkUooobmOmJOj/1o`0eN@00033oVifZono^
looXjNko^kflojj`[oo;bL[o`L:mokZ/TOo8alcob;nholG6b?o5a/[oj>W[oo7aoOo2`lOoCDi@oemI
IooCd=_og]oTogUjOoo3a<WoPH6;ol2nbOo0`LGoRXZBol[>dOmgM7gofmWToj6RYonNWjCohNCYohR5
S?nIV9koMGAlogAcNoo@d=cod];JogMfNom@CEKoTi2Kon_[loo[ko3oin[aon_^lon>Si7oXZ:/onc]
lOoUj>ehonOXkC;oi^O[02koi^O/onKWjooWj>coinS/onSYk_oQh^OoVZ2fokFfbooGen?o/;76ok>a
a_nXYkWoWZ2_ok:bb_n`//Wo][C<oifR^?o5c=CoY:^mok6baoo?cMSoUYJPoiBBWonDU9koU9BLoiBC
VOnIV:So];C<oinT^_nmbmSobHR<olY8D?o<Gf;oj[ZjomE[KOoBEUSoce=EomajNooWZjgobUEKolI7
C_o:VIgojoonooCOi?m=Ih[o03Qm2_l0@8003ol0@Gko0420o`8oO_l0@GgoK6BCookkj?oYj>goY:FW
od9DK?nOZ;7oY[>kojF_^Om/OHOoO7f2onWYj@03omoOg`;og]kN<_oOgml01?oNg]kogmoOomoOgooN
g]h2omoOg`0aonCTi?o;bl_oEEEEoifMWOmlO7koaLG5olk>c_nHV9KoJVYXojNWYombLW;of=SHogYj
N_o:b/[oN7QholK6a_mjNW[o[Zj^og5aLoo5aLGoFEUIom7AdOo[jngoMWIdoe5ADonZZZ[oc/k>ojZZ
Z_mGEeOo[jn_ohF5QOn9RHWoHf=SogemOOnOWiooRXZ:omGEeOmjNW[oalO7oeEEEOmaLG7oS8b<onGU
iOoOgmoog]kNomoOgooNg]kogmoOomkNgP0komoOg`0>omoOgOoNh=oog^3MomoOgooOgN3om_KZofiU
U?l0?7_o03moo`0oQ?l0@Gko041no`0oP_l0@Gh;o`10P005o`=0Ool0=g[o@FfNooofmoolo_d08?oh
nO/04oojn_[onO_jooSjnOohnO_onO[loo[jn_oinOWon?cmoo7em_o/j>GojNSVoncVj?o/inCojnGU
on_[kOoeno_on_cioooooomOQ:h00Ol1<gP0000`oibJ[ooPhnSofMcUojVX[Oo3b<koj=;WolfOI?oQ
/P;ojjQAomfeT_oXiMco`L;4on3Rk_nj_/7o0`00ojFU[OmeMW[oBdY@ok^ia?l0003o[jbgo`010?nT
Y:ko5aXCohR6TOnc][go0@00okBc^Ol00@3o_;[5ohJ9S_lJ61_o9B@Rofi]Lom]K7;o][FmoeeMGomS
I6WoGEiRoc8`=OoKfNCo^k_3olo?eooUiNgo0@41og=aO?oWiO;of][TN?oHfn@aomSKhP;of=_T0ooH
fn80:_oJgNKod]GNoi^Q]oo3a=Wo_kk<o``:<OlU8DKo0P0EogEfR_o3`m_o^[_=ol6oe?nPYKWo^/3<
oj:W_Onn_m?o^KW3ofm]PonWZ[goWjBhoinQ]_na/<3oMWF7okfnd_nUZ[ko]/;BolB3ROoBCeCo]E=B
olSKeOomo_oofV5VomecMoomo_oo^J^Xol5@D_o8CE3o`Y>MomgZl_oRfMcoBfF:o`0iP0So042001;o
045no`0oOol0@83o0D61o`10O_l0@H7oJf>BoogokOo[jnWo_;bjo`073_n6T9Wo]KZnoj>S[ol<72Wo
TI6Cong]kOoShn<2on;RhPCohn?S<OoRh^83on?Sh`0]on;Rh_oTi>Cog]kNoc<c<on_[K3onOWio`<3
0On:RXSoc<c<oginO_nNWYko`/;0oemOGonGUiOo0@41oiZJV_nOWioocLg=oiZJV_o5aLGoPGn0ofIT
IOnOWIkoj>KWon_Yj_mnO7goXZ6OoeQFEona[k3oTY2Aohn=T?no_[coOG]lolo=c_mlNW_oViZHoj6P
W_l40`7oZjVZo`400?nXYZOo[:Z[ofQVJOnh][WoinOW00?ohn?S00Coh^;Ron?ShooRh^;ohn?S>?oR
h^82on;Ri0;oh^;R00[ohn?Son?Qi_oTh^?oooo[og5UUOl3>W_o045no`51POl0?Gko04200_l0?h8;
o`10P005o`8oP?l0=g[o@FfNooofmoojo?/08OoinOT4ooShn00>ooWgn?oinOWon_koom:b]OoCJf;o
gHIoomV8QOoMQH?ogXMmola[I?oTf]Woo_knooomoomOQJ`1o`0dN00002ooVIRZomKIg_o>dM[oY:B^
okJWT_oP^VOoi:l1okbk0?nBKP3ocY`9omk>V_no_/KofmkWohR9S_l00@?ooognok:g_Ol00@3o[:Zh
o`000_nm^LSo2`/9oj6S[ol`<S7oWYbWokFg`ol82`Co][G7o`430?odl_ooM7MnodA4A_lc=3SoGeiV
ocdl>?nGU9ooCdiCoh1nROmfMWkoFEYOok:d`?m:CTgo^;_4ooOhoOlF5a;oNgZ0om_Ki`0aolg?fdSo
c]3L=_o=cm/0:_o>d=coalWEoibS]_o9bm[o`l;Bojb^_On][kko[J_0okfoc_o5a]Soa<GGol_:f_nV
Zkoo/;K4oj6V^_o7b=co_[k8ohZ<VooBdN?oalSJolS6fooDdn7oQ8>AolW8f?n_//Go[;S8ol9lQ_oF
EUGohf=TojmBCOo8`;konmgOooK`l_nkZJGo^Dm?on9XIoo?DECo_8bHom7KiooHdMSoCFN8o`0iO0So
042000?o03moo`=0Ool1?Wl00_l0@8003?l0@H?oKfJEookokooWiNSoi^CUohB6QOm^Kg7oZ:N/oh62
Q?mZJe_oe=KEonWYj@?oi>CT0_oUiND2onCTi33oiNGU00?oi>CTonGUiOoUiND00_oUiND02OoVi^Ko
h^;TohV9Ron3PH;o_;bjol30`?oCdm?oi>CVomkNh003onKViP04om_Kfonh^;SofMWIonOWi`?oi^KV
01coinOWomoOgooXj>Koi^KVonc/j_n;RhgoCe1:ogUiNooHf=[ogmoOonc/k?o8bLCoM7E_onc/k?oQ
hMooinOYomGEeOnn_[kog=cLokZj^_oLg=coinOWon7QhOoXj>SoiNGUonCTi?oUiNGoi>CT0_oUiND0
0ooTi>CoiNGUonGUi@0gonGUi@0?onCTi?oUiNGoi>CTonCTi?oUiNGoi>CTonGUhoononooL6VEo`0j
O_l0?h;o03moo`11POl0@Gko0cmn00co042000Go0D61o`0gN_m1KIkooO7coo;bm00Qoo3al`;oko3b
013olO3eono`m?o_l?;ol?7coo;gn_oVY:GooJVWooo3`?om/k;oo[Zgooo3`_odUYKojLO8oo?hnoon
oo[oGHB_0Ol0=7H0000`oiREZ_o:dMWoa<OFoifPYonSVHgogk<jooZi0?n?K`3oEd@0oonZ0OoRbZSo
^ko8ol_Bh_n5R97o0000onoaoonQYK3o0P84ojFU/Olm@ScoLg=koc0e;_nKWZOo0@00ogEeOOn3QXoo
:2XWohZ:T_l00@3oXZ2^ogEeOOm9B4koFe]SofETJ_lP8AcoWZ2]ogAgO_mADUOoA4=8oeQGGooGfO3o
blkOolC6d_nWYk7o6QdFogUjOoo@d]oo`lKE<?o4a]=8ol?7dcGoa<KC02_o`lGBolG7e?nm_lkoVj6g
olk@g?o>cMgod=;Oom3BhOoBdMooc]3Lol_=f_o;c=kod]7OojZ_`onY[kooWZ>fom7Bi?nm_LGoT9>L
omgOk?oBe^;odmGRomWLiOn5Qi?od<oMok:gbonV/lKo^W^3omQJFooSJfcohV5KokU]Koo`o_koi>O/
okYBBOoUIFCohV]Uom9EDonfQiOob=;Nolk;e?m<IX_o0cYk00Wo042000oo045no`11POl0@7oo0d21
o`10O_mhKicoooojookoloooooooo_kool[;aOn[[:Ko_KjioooomOomo_l00_ono_@00oooooGoo_kd
oooom@03oooomC3oo_kd017oooogooknm_ooooGooooeooknm?ooooOoo_kfooonnOohn=koo_o_oooo
nooooogooOkhooknm?ooooGooOcgoognn003ookon@?oo_og00?ooOkfoogom?omo_T00_omo_H02Oon
ooGoo_gooocoioooooooo_kloooon?onoo[ooOoaonOYg002ookom`06ookon_ooooooo_knookno_oo
oogooOkh0_onooL00oonooGoo_kdoooom@06oooomCSoo_kd00gooOodoooomOooooOoooohoogol_on
oo;oo_giooonoomiLYko03ako`8oP_l0@7go03mo00co042000Oo041no`10P?l0@83o03Mjod9^Woon
kO?ojn[_023oin[_01?ojN[_onOZkooXjNkojN[_onOZkooYj^ooin[_onK_m?oUZ:OonjZWooS@d?ok
blWomm7@ooW8`oogVI[ohlK8onSam_ommoOoGXF^007o03Ei0000<?nCUZWoaLSGok^ncOnJWJKo_;Vd
om:MEooRNP3o/4`1oiX00?odP17oilNFokZi__o7b]_oP7n7o`400?oOgOGoVI^Wo`000?nd/l7o/kK5
oiJIX_n]/Kgo]KW5o`410OmhN83oW9bXog=bN_nCTY[o0040ojRW]Om[Jg?o<c<WomkJlOnAT9koXJF`
ol?6eOnm`LgoXZJaobDV8Om@CDSob/cIokfnd?o2a=?oFEYNo`000?mnOXSob/WIokfoc2So_;o>D?nk
_/ddokfocP;o_;k=02[o_Ko>okFfb?nNXkOoe]KRom?CgooAdmoodm;Pom?Cgoo@d]ooe=CPom?CgooI
f>Ko[kG5oj:W^_nMX[Goe]WRolO7dOnFV:Ood]3Nolc;fOo<bm_oa<C@ogimRooIfNGo]kg=oif/_onm
Mh7ogemPon=YI_oUQXCooogookVPW?o8];?oookoonEgM_oVK6_oeEUIokJ4T?nlb=KoaL?@od]WS?l0
>gh8o`10P00Ao`0oP_l0@7ko0420o`10P?l0@Gko0D61ocdfNOn4N:KoQ7VSoh=hXon5NJ7oRH6Xohj3
[On=P:_oQ7^VohEhXon4Mj800_n5N:<00on4Mj;oQGRSohEhX`0bohAgXP03oh=fX_n4Mj;oQ7NR00;o
Q7NR00[oPgJRohEhY?n6NJGoRg^XohEhY?n4Mj?oQ7NRoh=fXOn5NJ7oPgNO0_n5N:<02?n4Mj?oQGRT
ohAgXon4Mj;oPgJQohAgX_n5N:?oQ7NS0_n4Mj803?n5N:CoQ7NSohMkXon7NZKoQWVTohEhXon4Mj;o
Q7NSohIiYOn9OJGoQGRVohAhWP?oQ7NR00KoQWVUohAgXon5N:CoQGRTohAgXon5N:@4ohEhX`;oQ7NR
0_n5N:<hohAgXP0<ohAgYOn5NJ7oPgJQohAgYOn5N:CoQ7NRohAhX?n9OJGo@cMgo`0mO?l0?h;o0d21
3Ol0@8001ol0@7ko0420o`10P?l0=g[oA6jPoogZl?oSi>T09_oRhnP03OoPhn[ohNS^onBSYoooWISo
n[F^ooSJf_ohd<koojBQooJ@RooP`<Goh^Waook^lOmNPjd00Ol0=GT0000_oiBCYOno_]3o];O8oi:F
XOnc/ZgogLVTomnd5oo[Z`7o]7L2olRLKooZj?ko^KW1okbod_n;SYOoATQ3ol31donOXK3o<S@_ok:d
`onk_/oo_Ko>okZmd?nh^lkoVi^Wok>faonPX[7o>Sdfok>b`?nJW:_o_;o@oganR_mSHVOo`L;Doko1
c_nk_M;o]KS9okJib_o7b=[oMWInofe/M?no`]Go]KO6okRibonc]L;o=CXfohN9U_nn_m<0:Onf^<L8
okJgbDSo]KS9=_nf^<L0:_ng^LSo[k32oibQ]OoKfnGofMOUomOGhooHenGoemKVomSGiOoGe^Cof=OW
omoMjon^/lKoW::boi^O^?oJf^Kodm7Nob0KDol@3D;o71U@ob4NEOl102co@T9NonGSl?nj_LcoVZJl
okUeP?oPHV?oigYeoo[noOniZZGo`3XkokU3@oo5`Kkon_OnonMaKooKGego[h6<okRodOo0`<coBFF<
o`4jO`Wo0420017o0D61o`8oP?l0@83o0Smno`50Pol0@83o0cEjo`0^M_l0;WWo031ho`8^Mol0;gOo
02mio`8^MOl2;G_o02mio`0`NP0fo`0_N@Go02mg00?o031ho`0_NOl0;gT00_l0;gL03Ol0<7[o031h
o`0_Mol0;gOo0C5ko`0_Nol0;GSo0Bmjo`0^NOl0;GSo02iio`8`Nol0;GP00_l0;WT02ol1;g[o02eh
o`4_N_l0;WWo02iko`4`M_l0;W_o02iio`0_Mol1;ggo02if00;o02ii00?o0C1ho`0_Mol0;gL01?l0
;gL00ol0;WKo02mgo`4`N010o`0_N@;o02ii00Co0Bmlo`4_N_l0;gOo031j0_l0;WT00ol1>Wgo0462
o`@oP@02o`10P003o`11O_l0@7go041n00Wo042000Oo041no`10P?l0?goo03Mjod=_W_olinkogmoW
027og]kX01;og=oVomkNi_oNg^Sog=oXomkNi_oLgnSog>G^on6OX?omUI;omlo=oo^g^?ofa/CooKfm
ooJ2P_oL_l7og>C_ooo/k_mMQ:l1o`0eN@0001CoTY>WokbmdOnb]<?oRh^Col6naOoglMOom?7Poo?D
W_oXdZ7on?WnooOcj_ne^L;o/;75okFfb_nf^lko/KC7okBfaOnj^loo/kG4ok:ca@;o/kC901[o/[G6
okVlcOne^<Wo];O:okVlcone]/_o^Kc?ok6fbOne^<_o^;W=ok2eb?nc]LCo]KC6ok>ea?nc]<So/[?5
okNhc?nf^L[o/[G6ok:dbOnb]LKo];O:okZmd?ne^<Wo/[G8ok>ebZko/kC600Wo];G7ojb]`OnOY;So
hn?]on3NjOoOgnOogmkVon7Oj_oPg^/00_oPg^T07ooVi?7o]K_;oiVN]?nKX;Coh^;^omSFi?nZZ[;o
Z:NeojRX/_nZZ[KoYjNcok^kaooZio;o`L;DoiNS^OniLGoojg9ZonZ3O?nTOGKo`WabooJHS?o^UHOo
^WY^ojf0NoobPg[oi6UTojeoS?nd_<oo`;c:odiVS?l0>Gh02?l0@8001?l0@7go0420o`11P?l2?h83
o`10OP09o`10P?l0@H7o0420o`12Ool0@83o049no`10P?l0@Woo041n00?o04200ol0@H400ol0@83o
0461o`11P@0_o`11P@04o`11O_l0@Woo045no`11OP?o049o0_l0@8001?l0@H7o049oo`12Ool0@Wl2
o`10P005o`11POl0@7ko0D5oo`10O_l2@X000_l0@7h00ol2@X3o041no`11OP04o`11OP0;o`11POl0
@Ggo0461o`11O_l0@H7o045no`12Ool0@Wko0D:2o`10OOl1@h000_l0@Wl3o`11P@03o`10P?l0@H7o
042000?o04611Ol0@80ho`11P@0:o`12Ool0@7ko0420o`10OOl0@Woo0461o`10O_l1@Gko0465o`11
OP;o041n00?o0420o`0oOol1@H402Ol0@8002?l0?goo045no`10P?l0@83o03Mjod9^WOoih^[of=SR
8OoGfND00ooGf^?of=SRomWIi@02omOIi@0=omKHi?oFg^WogYfKoo^:S?oiWIkonH^<ooZCU?oiWj7o
lhF4omVi__oGh>WomnK/oef4Z`01o`0eN@0002OoTYFXokfkdOn^ZlKoVib^okBb]Oo4aL[o`lK=ol?2
b?o3`/3ob<S@olG6b_n_[k_o[Zk:ojf_a_n`/LKo/Jo7ok6^bon_[lWo[Jo4ojn_aon^[/Ko[k34ojj_
a?n^[/So/:k4ojj^b?n`/<So[Zo3ok6_aon^[/Ko[Zo4ok2`c?n`[/Ko[jo7ojn_bon^[/Ko[[35ojf_
a_n_/LP00_n_[lL01on^[/So[Zk6ojj^b?n`/<So[Zk6ojn`a?n`[/@0<?n^[/I8ojn_ac;o[Zk60on_
[lL02On^[/Ko[jo7ojNW`OnFVk7oj^[boo[io_ohmogonOSmooWgnP02ooSgo00PooWinoohmoco[;74
oiJJ/onDVJooh>3Zooomo_omookooognoooooOooooooo_knooooooomnoco^[c;oi>N^_naMhGolG]]
oob^V?oe_igonlVXooK8Y_ofbZGonLNTooBnV_omZiKoiG1WojaoU?n_]lko_kk@odiUS_l0>G/8o`10
P003o`51POl0?hCo041n00Co042000Wo041no`12Ool0@83o0Sn0o`50Pol0?goo041no`10P?l1@H40
>_l0@8000ol1@H7o0420o`51P@06o`10P005o`51POl0?goo0420o`10P?l0@7h01?l0@8001_l1@H7o
0420o`10P?l0?h;o0420o`0oO`?o042000Ko03moo`10O_l0@83o0D61o`10P?l1@H43o`10P006o`50
Pol0@83o0420o`10P?l0?goo04201?l0@7i1o`10P00?o`10O_l0@83o041no`10P?l0?h;o0D5oo`0o
P_l0@7ko0Smno`10P_l0@Gko0420o`<nP?l0?goo041n00Wo042000Oo045no`10P?l0@83o03Mjod=_
W_omi^kog=oX023ogMgW01?og]cWomgMiooNg>Oog]cWomgMiooNg>OogMgYomgQkOo=];SoiI:<onbE
S?oZUHkojYJ<onbCSOoIUICodL_GomoOjooljo7oH8>]007o03Ei00001OnHUJSobl[LojNU_OnUYKgo
X:2l00;oXYnj00KoX9nnoj6Q_OnOWk_oWinkoj:R__nUYL43ojBT`0SoY:Bn2?nTY<14ojBT_P03ojFU
_onTY;koY:Bn01?oY:Bn1_nTY<0:ojBT_P04oj>S_OnTY;koY:BnojFU_`SoY:Bn00?oYJFoojBT__nT
Y;h05onTY;h00onUYKooY:BnojBT_P0]ojBT_P05ohfBY_nDVJgoZJk1ojR^__nW[Kd00onX[[h08?nZ
/<3oWjBgohZ<YOnRXkooTY>_oi:D[OnY[/7oZ:jnojR^_?nY[kgoYjfmojR^__nY[/7oXjRlohR=XonN
X[_oWI^coje_O?o7OWOoa8Yool:7Ooo4RWoo`XQmol>9O_o4RH?ob7YfojMaOonIWKSo]K;=onO9eOm=
IHOo03Ylfol0@8001Ol0@H3o03Mhod9]X?onjO3ohN3V02SogmoY00?og^7ZomcOj?oKg^L00ooKg^L0
1OoLgnSog^7ZomcPjOookO7oGX>]007o03Ek00002?mSLiCooo?SomWIiOnj_M3o^;;:okJca?nc]<Wo
]KC60one/lP2okJdb@;o]K?800?o][C9okFcbOne/lT01_ne/lT9okFcb0Co][C9??ne/lP00onf]<Wo
]K?8okJdb@02okFcb003okJdbOne/lSo]K?8013o]K?800?o][C9okFcb?nf]<T00one/lP00onf]<Wo
]K?8okFcb007okFcb003okJdbOne/lSo][C900;o]K?80_nf]<T2okFcb008okJdbOne/lSo][C9okJd
bOnd//Oo][C9okFcb?nf]<T7okFcb004okJdbOne/lSo]K?8okJdb@Go]K?800Ko][C9okFcb?ne/lSo
]K?8okJdbOne/lP2okJdb@?o]K?80_nf]<TYokFcb004okFecOn/[<CoZj_3ojVZ_`?oZZ_00_nZZ/80
1_n[[<7o/kC8okBeaone]/So[k34ojVZ_`;oZZ[201OoZJZoojZ[`?nZZkooZZ^oojVZ__nc]<Wo]KK;
okFgc?n`/lKo/:RoojnU__n`Z;oo[jFnojnW_on`Y[ko/:RoojfX__nb]<WoalCGookhj?oS_lgo9Df1
o`8kOP3Ho`10P008o`11P_l2?gko0T1mo`8oP_l0=gSoA6jNoocnnOokmOTXooCcn0Som?Gi00?om??h
ooomo_mQQjh00Ol1<gP00007o`13O?n@TJKoo_gYooomm_oYjoOoinc`onS[lP05on[[l003onWZkooZ
jo3oj^_`05Coj^_`00GojncaonWZkoo[k?7ojN[_on_/l@0Con[[l004onWZkoo[k?7oj^_`on_/l@[o
j^_`00?ojN[_on[[l?oZjo002_oZjo000oo[k?7ojN[_on[[l00;on[[l003onWZkoo[k?7oj^_`00So
j^_`00?ojN[_on[[l?oZjo00;ooZjo001?o[k?7oj^_`on_/lOo[k?43on[[l006on[Zl_o[jo?oj^[b
on[[l?o[k?7oj^[b0_o[jo<01Oo[joGoj^[bon_[looZj_;ojNWa00Coj^_`00ooj?3con[_looXl_?o
jO7con_`m?oWl_Coj_3`onSblOo/lOGok_Odoooon_oRcmGoFFb=o`0lOol0?Wh0f?l0?gl02?l1?Woo
03moo`0oPol4?H3o0CMmocQVV?ocgN3odMGQ:_o=dn401?o>e>;ocM?QolgChOo>e>82olgCh@03olkD
h?onl^KoD7VU007o0SAi00002?l0>7go01]bodILPOn6PiKoS8ZPohZ;X?n9RYkoRhVO3?n9RYl3ohZ;
X4WoRHZO00GoRX^PohV:Won9RYooRHZOohZ;X00DohV:W`03ohZ;X?n8RIkoRX^P00coRHZO00SoS8ZP
oh^9Won;RIooRhVOohb:X?n:R9koRhVOohb:XP;oRHZO00KoRX^PohV:Won9RYooRX^PohV:Won:Rj02
ohV:W`03ohZ;X?n9RYooRHZO00;oRX^P1On9RYl01?n:Rj3oRHZOohZ;X?n9RYl5oh^9W`04ohZ8W_n;
RIooRhVOohV:W`?oRX^P;?n9RYl00on;RIooS8ZPoh^9W`02oh^9W`04ohb:X?n;RIooS8ZRohb:X0;o
RhVO00?oS8ZPoh^9Won;RIl00_n;RIl3oh^9WP0>ohb:Won;RIooRhVOohb:X?n;RIooRHZOoh^9W_n;
RIooS8ZRoh^9XOn<RZ3oRHZOohZ;X?n9RYl2ohb8W`05ogQjTol5?G[o01Ueo`0gMol0>gL0f?l0>GP0
2?l0>7Oo0cUgo`0hMol1>GKo03Mgo`0dN_l28G_o0@ei2?l027LPo`07MP?o00Qg0_l01gH3o`08M`03
o`4=Nol17Gko02mg007o03ak00002?mfOY?oUZ6goi:M[onOWZcoWij^oi^L[_nNWJ_oWIn^2?nLWZ/8
oibN[@SoW9j[1_nLWZd2oifO[SWoW9j]00GoWIn^oibN[OnLWZgoVif/oifO[P0ToibN[@06oifO[_nL
WZgoW9j]oibN[OnMWjkoVif/2?nLWZd00onMWjkoW9j]oifO[P05oibN[@;oW9j[00?oWIn/oibN[OnL
WZd02?nLWZd00onMWjcoW9j[oi^MZP08oibNZbcoW9j]0_nMWjh01onKWJcoW9j[oibN[OnLWZgoWIn^
oi^MZ_nMWj`01OnLWZd05_nMWjkoVif/oibN[OnLWZgoVif/oibN[OnLWZ_oWIn^oiZM[?nMW:[oWin[
oibNZonOW:goW9f_oibNZonNWJgoW:2/oifN/?nBV[7oUJ2foiRN]?nIW[;HoiNO/P08oiRP]onEX;Co
VYjgoiJR/_nHX;GoUinboi2L/_nBWJl`oi:M/@03oi6N[onAW;3oVJ6d007oMWbF00002?n_[K[oblOE
ojFT/_nVZ;OoYJNdojBX]?nXYkGoY:Nh1_nUYkH2ojJX]`GoYJNf00?oYZRgojFW]_nUYkH03onUYkH0
0onVZ;OoYJNfojFW]P1>ojFW]P05ojJX]onUYkKoYJNfojFW]_nVZ;L03_nUYkH2ojJX]`SoYJNf00?o
YZRgojFW]_nUYkH01?nUYkH01OnVZ;OoYJNfojJX]onUYkKoYZRg00;oYJNf00KoYZRgojFW]_nUYkKo
YZRgojFW]_nVZ;L2ojFW]P05ojJX]onUYkKoYJNfojFW]_nVZ;L0<?nUYkH2ojJW^@CoYJNf00SoYZRg
ojFW]_nVZ;OoY:JeojFW]_nVZ;OoYJNfojNY^0;oYJNf00CoYZNiojFV^?nTYKOoYZRg1?nUYkH01?nV
Z;GoYZFeojJX]onTYkH2ojFV^00:ojJW^OnXYkWoYJNfojFX]onUY[SoZ:NgojbX]_n/YKGoZJRfoj^Y
]mSoZZRf00KoZjNeoj^Y]_nZZ;KoZJNeojbX]_nYYkD2ojZW^2SoZZRf2?nYZ;H00onZZ;GoYjBeolW8
d001ojn]^`0000So[:^koinN/?n/Zkgo`lOBoko1d?o0`/ko`l7?ol34d0So`/7?1Oo0`/l2ol73d003
ol32coo2`Loo`/7?00Ko`/7?00CofmkWomcOj?oMh>Wog^7Z?OoMh>T01OoLgnSog^7ZomgPjOoMh>Wo
g^7Z01;ogN3Y00?og=oXomkQj_oMh>T00_oMh>T00ooNhN[og=kZomgOj`09omgPj@04omoRjooMh>Wo
hnK_onOZl`?oj>_d00Coin[con7TkOoNhN[oh>?/1?oOh^/01_oNhN[oh>?/omoRjooNhN[oh>?/omkQ
jPCogn;[00Goh>?/omkQj_oOh^_ogn;[onKYlP03onS[m005on3Sk?oOh^_ogn;[on3Sk?oSi^l00_oO
h^/00ooNhN[ogN3YomgPj@03omgPj@03omcOj?oMh>WogN3Y02_ogN3Y00Gog=oXomgPjOoMh>Wog=oX
omkQjP04omgPj@08omkQj_oMh>WogN3WomgPiooNhNSog=oVomgPiooLgnP2omgPj@0@on3OiooLh>Wo
gN3YomgPjOoPh>[ogN3WomcQiOoJgNKo_l??ol34coo1`Lgo`/;>ol70d?o0a=3o`/7Aol;2c]So`/7?
00Co`<;?okg4c?o0`/ko`/7?0_o0`/l00oo1`m3o_l7>ol32c`0Zol32c`;o_l7>0oo0`/l00oo6aM?o
ZJbkoj2M[P01ojZ/^@0000SoZj^goj6T/oo;c]Ooj^gdonSVlOoTinkohnK_onCTk0;oi>O^0_oUj>l0
2?oVjO3oiNS_onGXkooUj>ooi>O`onGXlOoVjO;oiNSa0ooSi^l00ooTio3oiNS_onGXk`06onGXk`?o
gn;Y00Gog^7XomgPiooMh>OogN3WomkQj00iomoRj@04oj2SZ_nJWJCoVYfTom3CfQ?ogn;Y00Ko^;_2
oiVLXonJWJCo/kJmomoRjOoNhNX2omoRj`[ogn;Y00?oiNS_olG8conLWjH00_nKWZD03_nLWjKoXJB[
omgPiooTinkog^7Xon;Uk?oPhn[oi>O^on?VkOoPhn[oi>O^on;Uk?oOh^WohNC[0_oPhnX04?oOh^Wo
gn;[omoRjooOh^_oh>?ZomoRjOoRiNco/;>joiZMY?nKWZGoXJB[omcOi_oVjO3ohNC[omoRjoo5b=42
on7Tk@05on3Sk?oOh^_og^7ZomoRjooPhn`00_oOh^/XomoRj@03omoRjooPhncogn;[01Gogn;[00Co
g^;[on7QkOoQhNWogn;Y0_oOhNd02_oOh^_ohN7[onOWlOoUj?7oi^W`onOWkooUio?oi>O^onGXlOoT
io3HonGXk`08onOWlOoUj>goj>KaonGXkooWio7oinO_onGXkooWj>d`onGXk`03onc/m?o;cMWoX:>d
007oZjZh00003on[Z[[oXJ:dolK9d_oTi_;oi>O`oiRGWOm6B4?o@T90okFh_oo^lOSoiNSaonCWl?oU
j?7oh^C`omkQjP02omoRj`09omoRjOoQhnoofmkUohB5ROm^L6ooIfUXolg=eOoYjoOoj>Sb00;oinOa
017oi>KbomoRjOoOh^WohN7[on7QjOoOhNgoin[aojb/]?lf=SCoFEUGod];Bon`/;SomoOoonOZlOoU
j?7oj^[don;UkP03omoRj`0GomkQj_oOh^Woin[aomoQkOoNhNSohnGaong]moobl_[o[jngob8T8On4
QHWojn_conGWlooSi^goiNOconGXkoo/koSoj^gfonKVk_oYk?Goh>;^omoRjOoPhnX00_oOh^T08?oU
iO7oblkEoda<C?mBE57ofmcQon?UlOoWj_?ojNceon_^mooPhn[oin[conc_n?oUiNooinOcomkQj?oV
i_3oj^chon3Sj_oOh^Woh>?/omoRjOoOh^_ogn;YomkRkOn?T9GoQhR<ohJ7S?o>c]SohN7[omoRjOoN
h^_ohN7[0_oOh^/00ooNhN[oh>?/omoRj`03omoRj`04on7QjooQhNgogn;YomoRj`;ohN7Y00kogn;[
ok2`^?n8RHkoQhR=ojRX/?omookohN?`omoRjooPhncoh^;ZomoRjooPh^kogn;YomoQk@;ogn;[0_oO
h^T05ooOh^_oiNSaoko2bOn0PHKoPhB8ohB5ROn1PXOoSi2Eom3@f_oIg>?og^7ZomOJhooOh>Go_;g2
ol_9e?oSi^go_<33om3Cg?oSi^ooeMOSomkQj_oEf=oog^7Z00;ohN7[01Cogn;YomoRjooOh^_ohnK_
oiRHX?n8RHgoPhB8ohV<TOo>dMSo_/76on3Sk?oFe]ko@T=7ok>c^ooMgNGoiNG_omoQkOoOh^_oh>?Z
omoRjOoogn;[HooOh^/00ooTinkoa/SEoj6R]001oj^Z^00001ooZj^goj6R]?o7bMKoi>O`omkQj_nA
T9Kod];LomkLionOX:GoT96FokVj_on0PHKoSHjCom[Jh_oRiNkog^7ZomoRjooPh^kohnK_omOGhOm;
CDcoDeEDoi:CUonc/k_oEeUFogMhOOnLW:Co]KJkofUZK_oEf=ooh^C`00;ogn;[00kog^7Xon7Qjoo]
kOOo[Jjcoe9DDon1PXCob/[Dodi@ConGVYoo]kRmoi:CV?no`/_oiNSaon7Qj@;ogn;[02kof=SToijN
Y_oPhncoiNSaolW9dolg>CKoXJ6[ok2`^?o8b=3o^k_3okNg`On[Zk?o_;o6ojb_]_nY[;?oC4i=ohZ;
Soo0`LKoF5UMomcOi?oQhnoogn7]omoRjOoOh^_oiNG_ol[=e?m0@3koSHjCojf]]OoNhN[oWj:Woh21
Q_miO87oh>?/oi^LX?ln@3oo^Kc1oj6TZooUio?o`<76odQ:AooIg>Gogn7]omoRjOoOhNgog^7X0_oO
h^/09Ol000;oo_klo`410oomooko0040ooWjoooZk?_o0000ooooool0003o0P84oocmoooin_ko0004
ooOho?oYjOGo0040on7QjOoPhncogn;[omkQj_oOhNgogn;Yo`000_ono_coookoo`000_l0003o0040
on?Ul_oOh^_oh^;/o`001?oQhN_og^7Zon3Sk?oOh^T00_oOh^/0;?oNhN[ogn;[omgOjoo`locoYZN/
okRi__o3a<WoY:B/onGTm?mCE5KoQhR=om_NiOmfMgcoSi2EofYZJ_l[:bgoVIVQoeEGE_mhNGkoalO?
ogUiPOoTi>coGf5PomOGhOoQi>goh>?/omkQj_oOh^_oh>?/omcOi_mjNgooooooolW9dOn8RHkoS8bF
ogEfN_nHV:;oOGj2od12?Om[JVooP866omgMiOoNhN[oh>?/0_oOh^T00ooOh^_og^7ZomoRj`3oomoR
jf3ogn;[00?oi>O^olK8eOnQX[@00On[Z[P0001Noj^[]onRXkGoaLOConCWk_oMh>WoIFEWonKUmOon
ooooPh>=ofe^LomRHfOoSi2EoiRHX?o3a<Woi^K^on3RkooOh^_oh>?/on?Vkoo6a/koMWMloognoooC
dm_oKVmcon?Rl?mfMg_oL75fofAUJOo2`/[oiNGaomoRiooNh>cog^;[omoRjooWinoo]kNoohF5SOo7
b]?odM;GogMhN_nd];co/;>logamP_ll?3coYZN/onc_n?oPhncogn;[omoRiooBd][oBT]=ong/n_o]
ko_oKW1]okbm`_n7R8goD59?ol?3cOnPX:SoUYJNoh62Q_nWZ:goDeAFog]lP?o2`/coHF9Vofe]MOo2
`/coh>?/omoRjooOh^Wogn;[omoRjOoPh^kohNC]oeYJF_nHVIkoO7b4om[Mi?mVIfWoh>;_of]/L?mC
De?oQhR:olK6d?nEUIgoLG9gon_]o?mTIFOo^k_7on?SjooOh^Wogn;[on3SjP;ogn;[00Cohn;`o`41
0oono_co00000_l000801ol10@?ooOolo`000?oooooo0@41o`000?ooool00ol000001Oonoooo0002
on7QkOoOh^Oogn;Y00;ogn;[00Woh^Gdo`000_l0003o0000o`010?l0003o0040oo[joooOh^/00_l0
00801?oPh>Soh^;ZomoQkOoNh>`2on3Sk0;ogn;[01Soh>?/omOJhom]KW?oMWMlogIfO_maLWOo/k>k
of9SIOn8R93oo?goof9SIOm[K73oo_klohB3R?mDEEWooOkooiJGVom/KG;oKVmcogioQ?m?D5;oY:FZ
on_^mooOh^T2omoRj`0AomoQkOoQhNWoJ6YWookno_o5aLooH65Sof5RI?n/[;KoUIJJofm`MOmcLWOo
ooooog=dN?o6a/kogn;[omkQj_oOh^T0oooOh^]TomoRj`03onCWk_o6b=GoXJ:d007oZjZh00007on[
Z[[oXJ>bolW9eOoSi^goi>C`oc<d;om_LWOoUIFOoh21QOm_L7GoIVM[od11@olE5QSo]kNoonW/mOoO
h^Woh>;^omkQj?oUj?7oc<cDoaHG6On6QHgoc/kFogAeNOnl_<CoK6eaog=bMomRHFKoZj^con?SkOoP
hnX00_oOh^T0BOoPhncokNggogYkOOn^[[Kom?CnooKfoom1@d3oI6ATofAUJOmjNh3oI6AVojVZ[_o[
k_OohN7]omoRjOoPhn[oeMGOocLh>_nSXj_o];C0ofIXHoomo_ooTY>GocPj=OnXZ;3oYZJ^oj:RZ_n7
R8co[JfeogenP_nSY:WoJ6U^oc/m??meMW_oinOaon7TjOoOh^_ogn7]omoRjOoOh^_og^3/onOZlOn0
OhGoYJF]ohJ7ROomoocoKVeboeYJF_nLWJ;o[jngoa@D5_m_Kg7oKVmdof1TIooEeMooNGQmon7QjOoT
i>koh>?/omoRjooOh^Wogn;[omoQkOoWi_Co0002o`410OonoOooooomo`000?ofmocokNcjo`000?oo
ool00_l00080=_omo_oonO[lo`000_oloOoonO[no`010?oQhN_ogn;Yon3Sk?oOh^_ogn;Yon;Vl_l0
00;oo_koookno_l10@?o0002o`010?oWio?ogn;[ono_nol00P7ohN7Yon7QjooOh^Woh>?ZomoRjOoN
hN[ogn;[omoRjOoSi^oobLcCog=dN?mfMg_oM7EjogYkP?nQXZOoH65Sof]/K_n`/KKoM7AlogMgOona
/[OoK6]aog1aMOnXZJgoQhR=oeYKGonDUI[oMWMloh^<TOn:Ri3okO3iomoRj@;og^7Z017oh>;^onGU
kOlT9B3oC4a>oc<e<_mWJ6goGEiPof1QHomOH6CoMgMooeeMFonb/KOoIFIZolo?eooPhncog^7Zon3S
k03oomoRjfCogn;[00?oi>O^olK8eOnQX[@00On[Z[P0000?ojb[^onRY;?oalOConGWlooRh^coA4I3
oiRKX?nc][_oZ:V^ofm_Mong]kooU9FJoinOYooQhN_ogn7]00;oh>?/03Kogn;[onCVl_o9b/oo>cdh
ojVZ[_o=cMGo`L7;ogIgNom0@T7oXJ2VoeADD_mOHF3og=cXon;Uk?oOhNkohN7YomoRjOoZk?SoRhjC
oj>TZOonoooon__oojFX[Om@CdgoOh25ohZ:T_mOH6GoZJbaon_^mooPh>[oh^;ZomoRjOoHf>Co;Bl^
ohf>T_nUYZ_oY:B/odA6@on6QXkoPhB8oe1ADon:RY;o418?ogUjOom@DU7o_Kg5okNg_omCEE3oWIjS
ocTj??mKGEcog^7Zon7TkOoOh^T2omoRj`0Ron3Rk_oWj^ooPhB9okJf__lF5aWoCe5@oj:QZOnGV9go
JVYXojf//_moP8CoDeAFoiZIXOm2@dGoRXjAocLg=om5AdKogMgWomoQkOoNhNSoh>?/omkQj?oPhnco
gn;[o`010?l000;ok>cfon7QjooQhNWoh^;^omkPkOoOh^Wog^7XomoRj@Cogn;[01Ooh>?/omoQkOl0
0@3oh^;ZomkQj_oOh^_ogn7]omoRjooOh^Wo0040o`020?l00@3o0002ookooOoWi_Coh>?/omkQj_oQ
hNWo0040on;Rk?oOhNkoh>;^omgPj@02omoRj`0[omoRjOoOh^_okO3gogn2Qona/[OoZ:V^oiZKX?o1
`LWoJfe/ok>c_On6R8OoKG9^om?FgOo;bm?oMgQlobLZ8oo;bmGoN7Umoj^[]Oo1`LWob<SBokRh`?o6
alco_;c6onGXlOoOh^Wogn;[omoRjOoOhNgoh>3ZodI8AooFeMgo[Jfeoh:3R?o1`L_oPH:7ol[:d_mh
NGkoTY:Jog9cN?nh^Kkoj>S`omkQjP04omoRj`03omoRjOoOh^_ogn;[0?oogn;[GooOh^/00ooTinko
alWFoj6R]001oj^Z^00002koZjZhoj:T/Oo8b=Coi>O`onCVlon=SY?oJVmYohf@UOno`/WoKW9eol;3
b?obl_coj^[don3Sj_oOh^Woh>?/omoRjooPhncoh^G^omWJgomeMWSoJVa[oi^KYoo/k?Kok^khog]l
POn][[?oXj>[omgMiooTio3og^7XomoRjOoQhN_og^7Zon7TkOoHfnCoMGIjogMgNOnCU9Soh^C`olS8
d_oWjOGoUYNLoc4a<onVYjcok>kj0_oOh^/0=?oOh^WoemOQoaHH5on>SiCoWYnSonGUlOo8b=;oe]WR
on?SkooLg>Cof=WNol[:d_oIf]oocloGonOWlOoEeMoob<W>omoOiom6Ad_o`L79on3Sk?oOh^Wogn;[
omkQj_oOh^WohNC]om?FgOl00@3oX:2XomSHh?o4am3oiNG]on?SkOo5b<gof=[VomWIhOo6al_ohNC]
omkQj_oGf^7o@453okZja?oShn_og^7Xon3Sk?oNhNSogn;[omoRjOoOhNgogn;Yon7QjooOhNd2omoR
j`0?omkQj_oOh^Wogn;[on3Sk?oNhN[oh>?/omoRjooOh^Woh>?ZomkQj?oOh^_ogn;Yon3Pk?oPhn[o
h>?/00;ohN7[0_oOh^T01?oSh_;oj>Oion7QjooQhN/2omoRj@0RomoRjooOhNgogn;YomoQkOoPhn[o
gn;Yon3Sk?oNhNSoh>?/omoRjooOhNgoin[aojNZ/Oo2`/co_;c4okFf^oo<c=KoT92HokJi`?obmOko
k_3lon7TjooSi^gomoOooe]MG?o;c]Ool_GnonKYl?oTio3oh^G/onKYl_oSi^goi>O`omkQjP;ogn;[
00oogn;Yon3Sk?oNhN[oUiRMon3Pk?o6a/koWZ6Xonobnoo`l_kof=_Pod=5@_oYjO7ol?3honOWkooP
h>X00_oPhn`2omoRj`03on3Sk?oOh^Wogn;[0?oogn;[H?oOh^/00ooTinkoalWFoj6R]001oj^Z^000
00ooZjZhoj6S/_o:bMWoiNS_on3Sj_o/k?Koj^chonOYmOoVjO3oeMSQom_NiooQi>goh>?/on7TkOoO
h^/00ooPhn`0B?oPhnSoh>;^ong]mOo[jo?oi^W`on3Sj_oPhncoe=CLonCTk_o/k?Coh^G/omoRjooQ
i>_ogn7]on3Pk?oPhncogn;[onGXkooDe=koXJ6Yojn_]ooOh^_oh^K_on__n?nUYZSoLW1aokNf__o[
joOogn;[omkRjooOhNgohN7[okFe_OnPXjSo[K2gon;Rk?oTi>kohNC[on3Sk?oRiNcoh>?Zon?UlOoQ
i>_oh^G^omoRjOoQi>_ohnK]on3Sj_o:b];ohn?[on3Sk?oOh^_oh>?/on7QjooOh^_oh^G/om?FgOnZ
Zjoo`/C@onSXl_oTi_;oh^;/on7TjooSiO7oh>?/on;Uk?oSi^ooh>?Zon3Sk?oQi>gobl_Gon7Qj`;o
h>?/00cog^7ZomkQj?oPhn[ogn7]omoRjooQhNWohN7[omoQkOoOh^_ogn;Yon3Sj_oNh>`5omoRj`Co
gn7]0_oQhNT2omoQk@0>on7RiooRh^cogn;[omoRjooOh^Wog^3/omoRjooOh^Wogn;[on3Sk?oOh^Wo
gn;[on3TiooOh^/2omoQk@03omoRjOoPhncogn;[00?ogn;[00Soi>O`on?VkooSi^ooi>O`on7TkOoY
jO7ohnK_omkQjP;ogn;[00_ogn7]on3Rk_o4alcof]gRon7SkooOh^Wog^7ZomoRjOoNhN[oh>;^omoR
j@02omoRj`0>on3Sk?oOh^_ogn;[omoRjooVjO;oh>?/on;Tl?oVjO3og^7XomoQk_oMh>OoaLS?omgP
jOoPh^h2on7Qj`?ogn;[00?oh>?/omkQj_oPhnX0B?oOh^_oon3Sk1Woh>?/00?oiNS_olO9e_nQX[@0
0On/ZkT0000;oj^Z^_nOXJkoa/GCon;Uj_oMh>OogmoYomgPjOoMh>OogN3Yon7TkOoNhNX00_oMh>L0
6_oLgnSogN3YomgPjOoOgnWogN3WomgOjooMh>Wog=kZomgPjOoMh>OogMo[omkQj?oQhnoogMo[omcN
j_oMh>Wog^7XomcOj?oMh>Wogn;YomkQj_oOh^Wog^3/on;Uk?oXj_Koin[a0_oQhN/01OoOh^_oh^G^
onKVl?oQi>gogn;Y00;ohN7Y00Oogn;Yon7QjooVi^kohnK_on;Uk_oNh>coh>;^00;ogn;[00Gog^7Z
omoRjooOh^_ogn;[on3Sk002omoRj`03omoQkOoOh^Woh^G^00;ogn;Y00cogn7]on3Pj_oQhN_ogn;[
omoQkOoPh^koiNG_on;Uk?oOh^_og^;[omoRjOoOh^/2omoRj@;ogn;[00Kog^7ZomoRjOoQhNgoi>C/
omoRjOoPhn`2omoRj`04omoQkOoNhN[ogn;YomoRi`;ohN7[00Cogn;YomoRjooOhNgogn7]1ooOh^/2
omoRj@03omoRjooQhN_ohN7[00;ogn;[00Gogn;WomoQk_oOh^_ogn;[omoQk@02omoRj@0>omoQkOoP
hn[ohN7[on7QkOoOh^Wogn7]omoRjooPhnSogn;[omoRjOoQhN_ohN7YomoRjooOh^T4omoRj`0EomoQ
kOoOh^_ohN7[omkPk?oPhn[og^7ZomoQkOoOh^Wogn;[onCWl?oPhncogn;YomoQkOoOh^Wogn7]omoR
jooNhN[oh>?/omoRjOoPhncohN7[00?ogn;[00[oh>?/omoRjOoOh^Wogn7]omoRjOoOhNgogn;YonCW
k_oOhNgogn;Y0_oQhN/00ooOh^_ogn;Yon3Sk002omoRj`03on3Sk?oOh^_ogn;[04Kogn;[oooMh>TI
omgPj@03on;Uk?o4a]?oWj2b007oZjZh00006OnWZ;[oZjZhoiFG/?nQWkGoWYncoifO]?nNX;GoWInf
oifP/onMWKGoWYndoifN/onNWk?oWJ2coj2N]?nMX;?oWIj`oijN^?nNWk?oWYndoifN/_nNWkCoWYnc
oifO]?nNWk@00_nNWk<3oijO]004oifN/_nNWkCoWYncoifN/`CoWYnd00WoWYncoijO]?nNWk?oWIjb
oj2N]?nNW[KoX9jdoijO/onPW[@00onNWk<6oijO]004oijO/OnMWkCoWYndoijO/`;oWInd00CoWYnd
oifP/onNWk?oWYnd0_nMW[<2oijO/`07oifN/onNWk?oWYndoibO/_nNWk?oWIfeoinP]@02oijO/`08
oinM/onMW[;oWYndoijO/OnMWkKoW9nboj2N/onKX;<3oijO]0;oWIjc00?oWYjfoifN/_nOX;@00_nN
Wk@02OnNWk?oWYjfoifN/_nNWkCoWYjfoijO]?nMW[?oWYndoifM]@02oijO/`04oifM]OnNW[SoWYna
oijO/`;oWYnd00GoWYnaoijO]?nMW[?oWj2eoijN]P3ooijO]7[oWYnd01?oWInfoifP/OnMWkCoWInd
oijO]?nOX;GoXjBfojNU^_nTYKOoYJJhojBU^OnUY[[oYZBiojNV^?nXY[_oY:FioijO/onNW[KoXjBf
00;oYjJh01KoY:FgojFV^?nUY[[oYJJjojFV^?nWY[SoYJBfoijP]OnPW[CoXZFhoj:Y_?nRZ;koXZVl
oj>X^onSZ[goXZRnoj:Z_OnRYk_oXZVkoj2S]_nEUZ_oZjZl0OnYZ;H0000hojVW]?o`l?3og>3QomoP
iOoMg^?ogmoQomoMh_oQgnCogmkSon3NhOoNgn?ogmkTomkOhooPgnGoh=gTomkOi?oOg^?og]kPomoN
hooPgnCogmkSon3Ph_oOg^Cog]oQomkOhooMg^3ogn3TomgNh?oNgnCog]oSomoPh_oNgn?ogmkSon3O
i?oNgn?ogmkSomgNh?oOg^?og]oQomoNi?oMg^;og]kVomoNhooNgn?og]kNomkOhooOg^Cog]oSomoN
hooNgnCog]gRomoOhOoNg^3ogmkTon3Ph_oNgN83omoNi00MomkOhooOg^Cog]gSomkNi_oNgN?og]oT
omgNh_oOg^?oh=oTomkOhooNgnCoh=oUomoOhOoNgn7ogn3Ton3Qi_o[j^oojNS]omoPiOoNgn?ogmkS
on3OiOoOg^?oh>3RomoNhooNgnCoh=gTomkOi?oOg^<00_oNgn<01OoOh>Cog]oQomkOhooOh>CogMkR
00;ogn3T00[ogMkRomkOhOoNgn?ogMkSomkOhOoNgnCog]oSomoNi?oOh>;og]oS0_oOg^<02ooMg^3o
hN;Vonc[lOoYj>kogn3TomoPh_oNgn?ogn3TomkNh?oOg^?og]oQ043ogmkSoooNgn<iomkOh`09on3N
hOoQgn;ogmkTon7NiOoQgn3og=gQol76c?ne]l?o]kW500;o^;[6023o][S4okRka?ng^LKo][S5oko2
booLgMoogn3RolG8dOng]/Co^KS6okRja_nj^/Co^KW3okNl`_ni^LGo^;O5okbob?oIf]kohN;Wolk;
e_o8ZK7obJ^eolN//oo8Z[;oajbeolF//?o8Zjoob:ZdolNb^ooGg>;oh^3Soo3`lP7oZ:Ne00005_nQ
Xk3ooognooooooono_coookoookooOono_ooooomooono?omookooogooooooooooogoo?goookooOoo
o_coo_knoooooOooooooo_klooooooomoOd2ooooo`05ooknooonoo[oo_knookno_ono_`00_ooool0
0oono_koooomooomoP02ooknoP0Mooooooooo_coooooooooooono_ooooooooono?omoocoo_gooooo
oOono_kooooooogoo_ooooooo_knoogoo?onoooooooooogmoOomoocoo_ojooooooono_koo_ooookn
o?oooooooOgkooonooooood00_ooool01Oono_koooooookno?oooooooogn00;ooooo00OonOWgol2n
`On/ZZookNg[ookno_ooooooo_kn00;ooooo00KooogoookooOooo_ooo_knooooooono_l4ooooo`0F
ookno?ooooooo_klooknoooooooooOgooooooOono_koo_klookno_ono_cooognookno_ooooooo_kl
ooonooomo_Wol?3`ok2^/oni]kcol>odookno`Cooooo00?oo_knooooooooool0oooooomjooooo`06
ookno_oooogod=COogb2X_mnPZOoO86W0_mlPZH03?mmPjGoOhBTogn3Z?mnQ:KoO8>OoloBfooUj^ko
PXRRogf1Y?mnPZOoNX>Togb0Y@;oOH6T01;oO8:Togn5ZOmgP9go_<C?ooGoo_nXJ7SoZQhiojhkC?n_
?4go[cm?ojdlC_n/?T_o/3aAok4cBonV6c[o_in/ooooooomoo`1ojBT/00004CoWij/ooSioOocl_Oo
l?Ceoo3alooen_ooiNOTomg8ZoohoOool_;boo3`l?o`m?GolO3fooShn_ogmO[om?SiooKgo?ohnO_o
loChooSioOodm?Kom_Knono`mOohnO_olo;hoo;bm?oin?golo;gooShn_odloWonOWkoo?bn?oem?Wo
n_Wooo;am_oin_col_7gooSinoodloWonOWkoo?bmooem?[olO3eooSinoocl_OolO;fooWhoOodm?Ko
n_Wgoo7anOodmOWon_[looGbnooem?[ol_7foo7`mOoal_Koko?fooSioOoemOOomoSjooCenOoinOWo
l_?hoo;cmooknogol_?goo?dmP;ol_?g033olO;foo?cmOobloOono_mol[;d?l1003oSHZConk_m?om
oOoolo;hooCcn?ocm?SomOKhooWgn_oal_KonOWkoo3_mOojnogolO3eooCemoofmO[om?Cdoo[jn_o]
kNoom_OkooSgo?ogmoWolo;gooKenooal?Gon_WoooGemooem?col_7ioo3amOodm?Kol_?hoo?dn?oi
n?gom_Gmon7Ri?mRI6?o0002omkMhoogm__oloChoo7bm_obl_@2oo?cmNSol_?gT?oal_@0:ooal_Ko
l_?gonocm?obl_Con_[lojne`onAU[CoZjc8okZmd?nk_]7o_;kCokVkd_nTYL?oYJK2ojJWaOnEV;Wo
/KC5olG9e?n>TK3oZjc8ok^me_nk_MCo_;cFokfkdonl_=Ko^kgFojbYb?nLW;koWZ^lon?4b_nb8SWo
bUEMol]BFOo8CeCocEENolMHGoo<E5gobDaDolYEFoo0B57o]eeYoo7gmOoin_`00OnOWZ`0001hoibN
Zoo/jo3oi^O/onKZkOoXj?3ohl_9omK7Z_oNZ`3oo]V/onnmR?oXhn[oi^W^onk^m_nh_;ooMgAmok6_
^_nRXJOoSHbDoiFDW?nTXjSoIFAZodA2COo1_l[o^;VkohF4S?o9bM7oJFQ^olC3bOmbLW[o][Jnogal
O_mKFFCoYjF`ogioQ?n_[[CoS92Aoj:PZonJVj3oSXbGojFVZomWIVko@3m7okfka_nk_<3oPH26ol[;
d?maL7Ko^KO2ogMfO?le=3[o[:Zeok>d^OmTIF[o=34lojJU[Oo]kOOoinO_ong]mOnQXZKo0040oi>D
V?oCd]So?Si0omSIg_oKg^GoPhF4omcMh_oUj>goi^K^onCWk_oUj>gokNkconKYk_o^k_Ko^[k1o`00
0?oKfNKoo_oooj:QYole=S[oIfI^on3Njoo9b<goJfE_olC4c_mUI6coeM7OoijMX_nHUioo^;Vmog9`
O_oOgnOoP863okNe`?o>cm?oNWUoohj=TomXIfooMgN1omoOjonh^KgoH65Uoc8a=_nSXJcok_7fong/
l_oYjO7oh>GXodmAD?nf];ooo_oookJj^ol000;oeMGMon_[looTincoiNG]onKWk?oUi^_oi^K^@?oT
inbXonGVj`SoiNKZR?oSi^/0:ooVin_oiNKZonCWk?oUiNgok>cdojnb`onSYKkod]3NokbkbonTY;co
Z:Vmoi2BXOn_[lOo/K7;ok6baonZ[<?o[[G5okg3conMXK[oc<kJojRX/_n6RI;oSHfGohn?VOn<SiSo
RXfFojR[__na/LWoXk33omFiaOo1BU3obE1GomnOX?oVW9godE1Dom9GF_oEG6?okm3=olecMOo9C5;o
_V9]on;Uj_o/ko@00OnMW:X0001hoi^I[_oQhNWoem_TomWGg?oNg=oodiYoom2=0?o>^03ocgd0okYl
<ooD_8kogmBhonCXlon;Si;o1`07oda9D?lU9BOoBDQ=ode<D_l0003oY:>Yo`000_nUYJgo4aDBohf<
T_ne]Kgo0000ojn/]ol00P3oDe9Jochl?on6QhcoQHB:o`010?nFTico?ClnogikQ_mRHfSoA497o`00
0?nRXJWo0000oj6PZ?lO8AkoPX2;okbla?l10@7oCTeCoeIEF_nZZ[;oVYfTo`010?nDTiWo51L@ogao
Q_oTi>cofMcSomgMionZZ[;oSXnDo``<3?n/Z[GoQXZ;omCDg?o6a/ko0000olW9dooKg^Oof][Rom_K
hoo<cmSo/:ngolS:e_oShn_o/;>jo`000?oNfncoWIjSo`410Ono_/?oGemQofe/L_nRXjSo0@02oj^Z
/_l10@7o/[2ko`010?nd/k_oRHZ>o`l=4_nUYJoo0040oo[hoOmNGf7oATE=o``<3_n1P8SoKFadol;2
c_l930GoQhF@oahN7?mjNH7ocm;Iok>`^ooFe^3odmKMo`410OnPWJSoo_oooj:U[_l0003ocloGom_K
hooGf^7oem[SomOJhOoEf=oof=_ToooGf^=iomOJh`0[omWIhooGf^7oe][SomOJhOoLgnKoYjfmoj^`
a_oEe>CoJ6Ilo`/9<OlF53Wo8R<hokRicOnk_=7o^kc@ok6cb?nY[kgo]KS7ojNY`_oBdMooOG^9oifN
/onZZkooYJNlokRibon9RIGoVIZ_ol2ldonQ[<3ob;2molI=D_o;DeCo[h63oo;moooXUiKoeU5DooGU
iOoFo_ko[EUGomEDF?nnHf[oeMSOomoRj@01oiVJ[00007SoV9V[omCIgoo=dMgoblO6olfU=_o/_@_o
mmH0okNn0?lQH`;oa9`0onW2BOo<dMOodmGTojja^?lN8R?oBT]?oe5AFOl^<2ooT92HoeaLI_m]KW?o
0040ojRW]old>3OoW9ZUok2`_?lG5aOocLWJobPZ9Om=CEGo>SLnof1QI_m@CeGo:2PZoiZHYOm@D5;o
Q8:?ofIUJ_mCDU[oHfAYofm^M?l000;oXj6^od11@onASicobl[Lob@T9?m4@dSoHf1Yooono?oCd>7o
H65Vofa[Lol1003oP7j9omSJioo;cm[oc<oHom;DhOo`kooo7QlGojZZ]_oLh>_odmKOoknobOl?40[o
_ko7om3Cg?o>c]SodMCMojfa_?m2@DKo];O0om[IionWZkCo0000onk[o_mPI6OoAD=6oooooon:SICo
7alMoibNZ_l>3`[o][G5o`010?nf]LGo1PP3om[FkOn9RIGoAD=4oijNY_lB50ooookooeEGE_mAD5Go
71dGofi]L_lE617oYjNao`h@2onQXJWoCdmAogmnQ_nTYk3oJV]`ol[<f?oHfN_o0@00oj2NZOoamOoo
VYfRo`000?o7am?od=;Nolc>f_o<c]_oc<kJolg?foo;cMU0olc>f[3ocLoKR?o<c]X0:oo<cmSoc/kH
olc>foo<cmSod=;Noj:W^_ne^/kob/WIokRjbOnd]/Go/kG2okZlbOo5a][oa<GGolC7e_nk_]7oY:^m
ojZ``?n//LOof]WWohV9UOno`=Cob<[IolG6f?oHenOoVijUojBV]Oo7b=coWZVkoknY]Oo:CeCoi6QZ
olQDE?nXOggolOoooogMg_oGd<[oZ5MDommOG_oLGe_o_6=Yol[>f_oDf>400OnGV:X0001eoiRGYoo<
c][oaLCFol?6eOno_JkoeihKooRN0?nHEP3o;`X1oonG0_odYS[ob/2nol;5e?o?e?7o5ALDoeYIG_me
M7co0000ooWhoOnTX[3oCDe?ocLh<onOWj_o0040og=bN?nUYk?o0000ofASJOm>DUGoQHJ8ode<DOmH
FEkoI6M/oeUJGom/LGGo>c/iofa`Lold=BooS8jJojV[]om?D5Co;2hYoinN[?l00P3oJFUaohR8T_la
<RgoMgMoodU8A?m?DDkoPHB;okNfa_mGF5go0002oinRZoo9cMWoaLOFolS:e_mZJW;o51D@obh`:onh
^<Cob/WGolC7e_nUYkCo6Q/FokFga?o5b=Wo`lGBol;4dOo6bM[od=3JolK8eOo<c=SoWj>^o`010?o]
j_ooHFEXode;C?ono_koOX68ocHe<OnMWj_oC4a>ofMVK?mDDeWoTi:Po`010?n>S9OoHfMZoe9AEome
MGgo0040ol[6gOmBEEcoH5mUoeACFomXJFgo:R`WokVhb?mQHVOoG5eRo`L91_mmNhKoeMKXoloAg_nj
`L_oT9:No`400?nIVjOoi>[ooiBFXol00@3o`l;@olG7e?o2a]7o`lOC00;o`/KA00?o`lOCol;6d_o2
a]80?_o2a]:Xol?7d`So`lGBR?o4a]80:oo2a];o`lGAolC6eOo4a];oa/[Foj2S]_nl`];oc]3Mom7@
h?oAd=kodM?Pom7@h?o>cM_oc/kJolk@gOo3a=KoX:FiojNZ^Ond]lSogmo[ohV9TOo?dMkof][VomKH
i?oXj?;oX9jYojZ/^oo?d^?oW:NiokZP[Oo;DUOohF]WonEXI?o<CDOoe<S8oo_oooo1RhWog5YHomm/
JOoPHeoo_65Zokk4d_o=cm/00OnFUjT0001hoiBEZOo4a]?o_;k;okjodonhYi?oag<0on1g0OnmI@7o
RA40onYT0ooTX4oob;20ok^ncOo1a=?o0@02oi2@W?n/[[[o0044okVi`on`/L?oV9bWokFiaOni^lSo
0002ogn2RonNWZ[o0081oiJEXonh^lCoaLSGoj:U]?nJW:Wo_/3=okNia_nTY[?oYjVfojZ/^OnPXZoo
a<KCojna__nIVjSo];K3ok^mb_l00P?oLgIkoinQ[_mVIW3o`;oAoj6U/OnJWZ[o_L7=ok:f`_nIWJWo
Zjnkol34d?nj_/[o_<3;ol31dom9Bd[oFU]Pok>ea?no`]7o_L3?okc0c?lc<c7o0000okFda_no`Lko
^kk=ok^obonk_/go_;o>okc0c?o2aMCoVYb[o`010?o9a]WoG5]QocDf<?odl_ooMgN1o`020?o1`]Co
/kG2oiVMZOnm_lcoXJ>`o`000_nGVJKoRHVAogmmR?n0P8[o0040olk?holk?C[oIFAZolo@iOnEV:7o
[k;1ol;5e?nl`<coXZB`o`000_mfMWkobL_Jokk1d?ng^/Wo92LPo`000_nLWjSoc]3UohF5Sol00@3o
_;k;okjodOnk_l_o_<3<okboc_nk_l_o^kk=@?nk_l^Xok^ncI3o_Ko<00[o_Ko;okfnd?nl_/go_Ko>
okk2bonMX;7oaLODomSFhooCd^3oe=CP0_oCdml07ooCd^3od];NomGDh_o;b]SoWJ:eoj6S^?nk_L[o
i>C/oiNFY?nk_<koa/GEolG4e?o>cMooQXFEok2c_?oEenCoVZFiokBIZ?o=EU[oiVaYon=_Koonl?3o
elg>ojR0P?odo_ookjFTonAXJ?oSJ6?o^f5ZokRkb_o4amH00OnFUJL0000Roi>AY_nn_m7o][S7okJj
`one/K3o/iQjon6^0oocZ`3o/gP@okE]6OnkYZ_o/[cEokFiaOng]/SoLgIooj^]_?nd]/GoMgN3ojn^
_?nl_Loo_Ko>ok^lc_ni^/coX:2ZokBeaonQX;3oCU1;okjmconk_=3o]KO6okbmconm_lco^;W;okVj
c0;o_;g?023o^kc>okfnd?nf]lWo^K[<okjodOnj^lgo^[_?oinQ/?nb/lSoZ:NeocDg<_nb/Koo_l3B
okfnd?ng^<[o^;W;oko0d_nj^lgo]kS:okFfb?ng^<co_Kc>oe9DCol00P7oGF1Yojf__?ni^l[o^[c;
oiREY_lD5`co[:^kokZkc`?o][S7037o][O9okFhaonl_LooXjFdobd`9omcM7WoM7B0ofm_NOo5a]So
S8bHoeaMGonk_<ko^kg:okfnd?nj^loo]kK8oinN[?nl_M7oRhZHof5QJoni^<SoWZ2]ol31eOmZKGKo
O7b8ol;3f?nn`<go^K[<okFfb?ng^<[o`lGDofEUKOn8QiGo_[oAokJib_nk_<koZZVioc/l=_nSYKCo
YZNiodQ;A?mBDeGo^;O5okNhc?nf]lWo][O;okFfb?ng^LSo]KK80?oo][O9NOnf]lT02?nf^<Go][O9
okJhaOnd]lKo][c8oiJK[oo4amSofM_Z0_oHenD00ooHf>Cof=OUomSGi@02omWHiP0Lol_=g?nHWk7o
Vj2fokfoc_o[joGoOWjFo`02:olB54Go5QI:oa<CAol000[o`;o=om[Ji_nGY;Oo[i>QolmKG?oVKfWo
ll:nomCNj?n_EEOocD=3ojb4P_oaoooojhf=onUYI_nmHV_o/[G6oko0dP7oTY>W00007onAU:Go^[cA
ok:caOnc]/Oo[[C>ojjTP?o0]Y;oaZ9XolRTJ?nUYkCoZYZJok6fb_nf]<Wo/kC8okVlcone]/So];O:
okVlcond]LOo/[G6ok:eb?na]<Oo/[G8okZkcone^<Wo/kK7okbmcona]<Go/[G4ok:eb?nb]LH00_nb
]LP00onc]/Wo/KC7ok:eb004ok:eb00:ok:ea_nc]/Oo/[G8okRkc_ne^<Wo/[G6ok^ncond]lKo/KC7
ok>fb@Go/[G802_o/kK9ok:ea?nd]L[oY:Jeohj?XOnCUZGo/KC3ok:ea_nb]<Wo^;_>oj^_^on_//7o
/[G4ok:dbOnb]LKo/K?8okBeaona]<Go/[G4okBgb_nl_lko/kG:okNjcOni_<go[kC8okJic?nj_Lko
/[G8ok:ea?nb]LSo/[G6ok>faonj_<_o/kK7okFhboni_<go];O:okRkc_n_]LGo^Kc?okNjcOna]<Oo
/[G400;o/kK90_nb]LP04Oni_<_o]k[;ok6daOn_]LGo/[G4okJgbonl_M7o]KS;ok:ea_ng^<[o^kg<
okBeb_na]<Oo/kK7ok:ea_nc]/Oo/KC30?oo/[G8N_nb]LP02Onb]LKo/[G8okBfaOnc]<So]KK:oiNI
/?oAdn3oiNCZon7OjP02on;Pj`0Pon7Oj_oRh>_ohN3Xon?SkooHenGoV9jdoiNL/?o:bMOoj^Obol6m
bonb/;go];:mokFc`?nb/[ko]KO3omkLjOoPg^_oVJBjoj^>X?oIHVComX=lokenNOn_NFook9N3ooBN
TOoMQWcoV7M^omj1O?obNg?o`6=[ojjaa?nk_/l1oi6CZ00001WoTYFVokbmdOn][/?o[Zk8ok2/`on_
[k_oZjkAojjX]_nfYIgo[K;@ojj_c_n_/<Go[Zk6ojn`aOn^/<Go[Zo4ojj^a_n_[lOo[Zk6ojj_a?n_
[lOo[Zo4ojn`aOn^[/Ko[jo700;o[Zk600Co[jo7ojn`aOn_[lOo[Zo40_n_[lL00on^[/Ko[jo7ojn_
a`04ojj^aP07ojn`aOn^[lCo[Zk6ojj_a?n_/<Go[jo9ojj^b003ojn_a`?o[Zk600[o[jo7ojj^a_n_
[lOo[Zo4ojn_aonc/<_o][K@okBdc?n][LGo[Zo40_n^[/H01_na/Lgo[jo9ojj_a?n^[/So[k35ojn_
a`;o/:g800oo/:k4ojn`aOn^[/So[Zk6ojn`aOn^[/Ko[jo7ojn_bOn_[lOo[Zk6ojj_a?n_[lOo[Zk6
ojn`aOn^[/H00_n^[l@03?na[lOo[k35ojn_aon^[/Ko[Zk8ojj^a_n^[lCo[jo7ojj_a?n^[/Ko[jo7
ojj^b0;o[Zk600oo[jo9ojj^a_n_/<Go[Zo4ok6^bOn][/?o[Zo4ok6_aon_/<Go[Zk6ojn_aon^[/Ko
[jo9ok2^a_n_/<D0oon^[/Ikojj^aP09ojn_aon^[lCo/:g8ok2`b?nDU:coa/GCooWho_oimocomoKk
00;omoKl00WomoKkooSgo?ojnOooc/kHoi:G[OnFV[Go^kc>ooSinoooood00oonood04oono_ooooom
oookn_oIf>KoSYZ`ojJCYooAJ6Cooj2@ooNnX?oib:3on<ZXooG7YOoic:Gom/JRoo^hVooiR7[o/fYc
ojRYaOnl_M400OnBUJH00009ohn=Xoo?b]koYjNooj6S_?nVY;coYZ?0oj>U__nTY[goY:?300;oYZBl
00CoXj>mojJS__nSXkgoYJ:o0onUX[d01?nUX[ooYZ?0ojFR_OnUX[d2ojJS_P0AojJS`_nUX[goYJ>k
ojJS`?nUX/7oYJ:mojNT`OnUX[ooYJ:mojJS__nUX[goYZ>nojFR_OnVXkkoYJ:mojJS__nUX[d00onV
Xl001OnUX[ooYJ:mojBT_?nSXkooYJ:m00;oYZ>n0_nUX[d2ojJS_P0>ojFR_OnUX/7oYJ>kojJT_?nU
Xk_oY:Bnoj>S_onVXkkoYJ>kojJS__nUXk_oYZ?2ojFR_onVXkh2ojFS^`06ojJS`?nUXk_oYJ:oojFR
_OnVXl3oYZ>n0_nUX[d01_nVY;coY:BnojFR_OnVXkkoYJ:oojJS_PCoYJ:o00?oYjFmojFR_OnUX[l0
0_nUX[d04onUXk_oYJ:oojJS__nUX[ooYJ:mojJS__nUX[goYZ?0ojFR_onUX[goYJ>kojJS`?nSXkgo
YJ>kojJS__nUX[ooYZ>nojFR_OnUX[l00onUX[d01?nVXl3oYJ:oojFR_OnVXl3oojFR_GWoYJ:m00Wo
YZ?0ojFR_onSXk_oYJ:mojFU_onJW;GoRHjToj:U^?nUZ;T00onRYkX02OnSZKWoXZRhoj6V^On:SjGo
VYbeoijO^on9SJKoWj6fojBZ^P02oj:X^00Doj:W^onVYkWoXJRhojJW^On<TZ[oU9Faoj:V`onOO9;o
_W9dokj5O_noQG[o_HAmokj3OonoQ7co_hB0okmoOOndKWKoUY2XojVYaOo=c=h1oi2=XP0001CoYjVh
om?Ag?oNg^So`/7CokVgc?nf]/ko^[S=okVgcOni^<[o]kS:okNhc?nj]l[o]kS<okJgc?nh^Lgo^;K<
okJgbong^<[o]kS<okJgc0;o^KO<00co]kS<okNhb_ng^<[o^;W;okNgcong^<[o^KS:okVgc?nh]/_o
]kS=okNhc?nf]l/2okNhc004okRicOng^<co^;W=okNhc0;o^KO<00Go^[W;okVgc?nh^L_o][O9okRh
d002okRic@04okJgbong^<co]kS<okNhc0;o][O;00Ko^;W=okNhc?ng^<co]kS=okNhc?nf]l`3okNh
c00=okVhb_nj^<go^KS:okVgc?ng^<go][O9okNhc?ng^<[o][O;okNhcOng^<[o][O;okNhc002okVg
c00GokVgcOng^<co]kS<okVhb_ni]lgo^;W=okNhb_nf]l_o^KS8okRibonf]l_o^;W=okNhcOng^<[o
][O9okNhb_nf]lco^KO<okZhcOni]lco^;K;okVhb_ni]l`00_ng^<`03?ng^<go][O;okJfc_nh^Lko
][O<okZiboni]lco^KS:okJfc_nh^Lko^;W;okNhbP;o^KS:00?o^[S=okJgbong^<`0oong^<ahokNh
c0?o^KO<00[o^;K;okVgc?nh^Lgo]KS;ok2aaOn_/<Co[Zo3ok2aaOn_/<Go[Zo30_n`/LD07?nc]Lco
^KS:okRicOnf]lWo/;75ojn`a?n^[lCo/[36ok:_a?n_//Go/Jo4ojj`aOnb]LSo^kW>okZibonf^Lco
];?5okF]aOnc[l[o/jg7okJ]b?nb[lCo/jg7ok:_`_nd]L[o`<?Don3Mi_oAdMd1ojRZ]`00023ofmcQ
oiJEYooBeM[om?KeonS[l?oZjO7oj^_`onWZkooXjo;ojN[_onOZlOoZjO7oj^_`on_Zl?oZjNooj^Wa
on_Zl_oYj^ooj^_`onWYlOo[j_3ojn[bon[YlOoZjo3oj^W_onWYlOoYj^oojNWaon[YkooYj?3ojNWa
onWZk`;ojNWa00[oj^[bonWYlOoYjO7oj^[bonWYlOoZj_;oj^Waon_Zl?oZjO7oj^[b0_oYjO400ooZ
jnoojNWaon[Yl@02on_ZlP?oj^Wa02kojn[bon[YlOoZjO7oj^_`onWZkooYj^koj^Waon_Zl?oYjO7o
jN[_on[XlooZjNooj^_`on[Zl_oXj?3oj^[donWYlOoZjo3oj^W^onWYlOoZj_;oj^__onWYlOoZj_;o
j>W^on[Zl_oYjO7ojn[_on[Xloo[k?7ojN[_onWYlOoZjo3ojNS^on[Zl_oYjO7oj^_`onSYk_oYj^oo
j^SconWYlOoZjnooj^Waon[YkooZjO7ojn[`0ooZjNl04OoZjO7ojN[_on[YlOo[j_;ojN[_on[[kooZ
jO7ojn[bonWYlOo[j^oojNS]onWZkooZj_;ojn[bon[YlOoZj_;oj^_`043ojn[`Z?oZjo2AonWYl@05
on[Zl_oXj?3ojnWdonWWl_oZjNl00_o[j_002_oZj_;ojncaonWZkoo[jo?ok>_con_Zl?oZjo3ojn_c
on_XlOo[j_83on[ZlP0Fon[Zm?oZjo3ojn_]on[Zl_o[j_;ojNWaong/l_oWj_7ojnS_on[^koo[l??o
jO7concbl_oYlo;ojO7conSblOoYloCojo7aonc`lOodnOGoe=?KoiNFZ07og=_Q00005?oooogogMgU
oinL[On1OiOoSXbRohZ;X?n<RYooSH^Sohb:X?n>Rj3oS8ZOohf;XOn;Rj?oSH^SohZ;Won=Rj3oS8ZR
ohf;XOn:RiooRhbP0_n<RZ002_n=Rj7oRX^Pohf;XOn=Rj?oRhbPohZ;X?n=Rj7oS8ZPohZ;X?n:Ril4
ohb:X00=ohf;XOn<RZ3oSH^Qohf;XOn<RYooSH^Sohb:X?n<RYooS8ZPohf;Xon<RZ3oS8ZRohf;X@02
ohb:X00=ohf;XOn<RZ3oSH^Qohb:X?n=Rj7oSH^Pohb:X?n:Rj3oS8ZOohb:X_n<RYooS8ZPoh^<X@03
ohZ;X00JohZ;WOn;S9koS8ZRohf;XOn=Rj3oS8ZPohb:Won=Rj?oSH^Qohb:X_n<RZ3oSH^Poh^<XOn=
Rj7oS8ZPohf;XOn<RYooRhbQoh^<X?n<RZ3oSH^Sohf;XOn=Rj3oRX^Pohf;XOn<RZ02ohf;X@;oS8ZP
00SoS8ZOohf;XOn<RZ3oSH^Qohb:X?n=Rj3oS8ZRohZ;W`;oSH^Q00WoRX^Poh^<X?n=Rj7oSH^QohZ;
X?n<RZ3oSH^Qohf;Xon<RZ000_n=Rj000on<RZ3oS8ZOohf;X@3oohf;XGSoSH^Q00OoS8ZRohb:X?n;
S:3oS8ZPohf;XOn<RYooS8ZP00;oSH^Q00goS8ZPohf;X?n<RZ3oSH^Qohb:X?n=Rj3oRX^Oohf;XOn:
Rj3oRhbQohf;XOn<RYooSH^P00;oRX^P01?oSH^Pohb:Won=Rj7oS8ZPohZ;X?n=Rj3oRXZRohf;XOn:
RiooS8ZRohV9XOn>Rj3oS8ZOohj:XOn=Rj?oRXbQogmoUonKW:kogMkS007oo_kn0000\
\>"], "ItemizedPicture",
  Evaluatable->False,
  ImageSize->{540, 389},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"starting", "i:4", "b:2.2", "gs:0.3"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "First steps with ",
  StyleBox["Mathematica...",
    FontSlant->"Italic"]
}], "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"starting", "i:5", "b:2.3", "gs:0.3"}],

Cell[TextData[{
  "Type ",
  StyleBox["2+2", "MR"],
  " and then press ",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey]", "KeyboardChars"],
  " (hold down the S",
  StyleBox["HIFT", "SmallCaps"],
  " key and press E",
  StyleBox["NTER", "SmallCaps"],
  ") to tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to evaluate your input."
}], "Text",
  CellTags->{"starting", "i:5", "b:2.3", "gs:0.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000420000B1000`40O003h00Oogoo0goo0003Ooon
0001Ool00003Ool000000?h0005oo`0000=oo`00IcT0o4ic0P000Goo00000goo001oo`3kIcT00dic
00000001Ool00003Ool007oo0?]W>@03CW<00000005oo`0000=oo`00Ool00VLimgoo0VLi00=>L`00
00000Goo00000goo001oo`02IcT00dic0000003c000017ooIcUW>Dic0P000Goo00000goo001oo`02
IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol0
1@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P00
0Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02
IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol0
1@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P00
0Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02
IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol0
1@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P00
0Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02
IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol0
1@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P00
0Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02
IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol0
1@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P00
0Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02
IcT00dic001oo`3bOol01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol0
1@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`3bOol01@00OomW>FLiCW<00P00
0Goo00000goo001oo`02IcT00dic001oo`3QOol523l<Ool01@00OomW>FLiCW<00P000Goo00000goo
001oo`02IcT00dic001oo`0iOol00`00Oomoo`2YOol00`PoOomoo`0:Ool01@00OomW>FLiCW<00P00
0Goo00000goo001oo`02IcT00dic001oo`0iOol00`00Oomoo`2YOol00`PoOomoo`0:Ool01@00OomW
>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`0iOol00`00Oomoo`2YOol00`PoOomoo`0:
Ool01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`0LOol60007Ool00`00Oomo
o`05Ool60002Ool00`00Oomoo`2YOol00`PoOomoo`0:Ool01@00OomW>FLiCW<00P000Goo00000goo
001oo`02IcT00dic001oo`0LOol20002Ool20007Ool00`00Oomoo`05Ool20002Ool20002Ool00`00
Oomoo`2YOol00`PoOomoo`0:Ool01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001o
o`0MOol20008Ool50006Ool20005Ool00`00Oomoo`2YOol00`PoOomoo`0:Ool01@00OomW>FLiCW<0
0P000Goo00000goo001oo`02IcT00dic001oo`0NOol20009Ool00`00Oomoo`07Ool20004Ool00`00
Oomoo`2YOol00`PoOomoo`0:Ool01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001o
o`0OOol20008Ool00`00Oomoo`08Ool20003Ool00`00Oomoo`2YOol00`PoOomoo`0:Ool01@00OomW
>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`0POol2000COol20002Ool00`00Oomoo`2Y
Ool00`PoOomoo`0:Ool01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`0LOol2
0002Ool2000?Ool20002Ool20002Ool00`00Oomoo`2XOol223l<Ool01@00OomW>FLiCW<00P000Goo
00000goo001oo`02IcT00dic001oo`0MOol4000AOol40003Ool00`00Oomoo`2WOol00`PoOol8?`0<
Ool01@00OomW>FLiCW<00P000Goo00000goo001oo`02IcT00dic001oo`0iOol00`00Oomoo`2VOol0
10PoOomoo`Po37oo00D007ooIcUW>Dic0080005oo`0000=oo`00Ool00VLi00=>L`00Ool0>Goo00<0
07ooOol0YGoo00D8?gooOomoo`Po00aoo`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03
CW<007oo0>1oo`H8?`aoo`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9o
o`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`02
0001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`020001Ool00003Ool007oo
009W>@03CW<007oo0?9oo`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9o
o`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`02
0001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`020001Ool00003Ool007oo
009W>@03CW<007oo0?9oo`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9o
o`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`02
0001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`020001Ool00003Ool007oo
009W>@03CW<007oo0?9oo`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9o
o`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`02
0001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`020001Ool00003Ool007oo
009W>@03CW<007oo0?9oo`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9o
o`05001oofLiIcU>L`020001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`02
0001Ool00003Ool007oo009W>@03CW<007oo0?9oo`05001oofLiIcU>L`020001Ool00003Ool007oo
009W>@03CW<000000?<00004OomW>FLiCW<20001Ool00003Ool007oo009W>OM>L`9W>@03CW<00000
005oo`0000=oo`00Ool0nfLi00=>L`0000000Goo00000goo001oo`3kIcT00dic00000001Ool00003
Ool007oo0?]oo`03CW<007oo005oo`0000=oo`000000o@000Woo003oOol3Ool00001\
\>"], "ItemizedPicture",
  ImageSize->{258, 72},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"starting", "i:5", "b:2.3", "gs:0.3"}],

Cell["Labels are added automatically.", "Text",
  CellTags->{"starting", "i:5", "b:2.3", "gs:0.3"}],

Cell["Output is placed below the input.", "Text",
  CellTags->{"starting", "i:5", "b:2.3", "gs:0.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000450000Eb000`400?l00000o`00003oo`3oool6
0?ooo`00o`3oool60?ooo`00103ooooo0000004000000@3oool00080ooooo`00000300000040oooo
00020?ooo`030000003=cLd0VIVI0?d0VIVI0P0000010?ooo`000P3oool00`000000oooo0<g=c@3l
0<g=c@0309VIV@00000000000040oooo00020?ooo`030000003oool0cLg=0?`0cLg=00<0VIVI0000
000000000@3oool00080oooo00@000000?ooo`3=cLd0cLg=n@3oool20<g=c@0309VIV@0000000000
0040oooo00020?ooo`050000003oool0cLg=0<g=c@2IVIT0m`000000103oool0cLg=0<g=c@2IVIT2
00000040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT00000m@3oool01@000000oooo0<g=
c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00003e0?ooo`05
0000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI
00000?D0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0
cLg=0<g=c@2IVIT00000m@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo
00H000000?ooo`3=cLd0cLg=09VIV@00003e0?ooo`050000003oool0cLg=0<g=c@2IVIT00P000001
0?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI00000?D0oooo00D000000?ooo`3=cLd0cLg=
09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT00000m@3oool01@000000
oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00003e
0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool01P000000oooo0<g=c@3=
cLd0VIVI00000?D0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000
003oool0cLg=0<g=c@2IVIT000007`3oool00oooool0oooo0?ooo`3C0?ooo`050000003oool0cLg=
0<g=c@2IVIT00P0000010?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI000001l0oooo00?o
oooo0?ooo`3oool0d`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H0
00000?ooo`3=cLd0cLg=09VIV@00000O0?ooo`03ooooo`3oool0oooo0=<0oooo00D000000?ooo`3=
cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT000007`3oool0
0oooool0oooo0?ooo`3C0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool0
1P000000oooo0<g=c@3=cLd0VIVI000001l0oooo00?ooooo0?ooo`3oool0d`3oool01@000000oooo
0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00000O0?oo
o`03ooooo`3oool0oooo0=<0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?oo
o`060000003oool0cLg=0<g=c@2IVIT000006P3oool00oooool0oooo0?ooo`030?ooo`03ooooo`3o
ool0oooo0=80oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003o
ool0cLg=0<g=c@2IVIT000006P3oool00oooool0oooo0?ooo`030?ooo`03ooooo`3oool0oooo0;D0
oooo1@0E3od20?ooo`D05@om4@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080
oooo00H000000?ooo`3=cLd0cLg=09VIV@00000J0?ooo`03ooooo`3oool0oooo00<0oooo00?ooooo
0?ooo`3oool0^@3oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3oool0oooo00l0oooo00D00000
0?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT00000
6P3oool00oooool05@om01D?o@030?ooo`03ooooo`0E3od05@om0;T0oooo00<05@om0?ooo`3oool0
103oool00`0E3od0oooo0?ooo`0?0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`00
0P3oool01P000000oooo0<g=c@3=cLd0VIVI000001X0oooo00?ooooo01D?o@3oool00`3oool00ooo
ool0oooo01D?o@2i0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03`3oool01@00
0000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00
000?0?ooo`<05@om0`3oool201D?o@80oooo00<05@omooooo`0E3od00`3oool0100E3ogooooo0?oo
o`0E3od?0?ooo`<00000Y`3oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3oool0oooo00l0oooo
00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=c@2I
VIT000003P3oool03P0E3od0oooo0?ooo`3oool05@om0?ooo`0E3od0oooo01D?o@3oool05@om0?oo
ooooool05@om0`3oool01@0E3ogooooo0?ooo`0E3od0oooo00@05@om2`3oool00`000000oooo0?oo
o`2V0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03`3oool01@000000oooo0<g=
c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00000>0?ooo`0>
01D?o@3oool0oooo0?ooo`0E3od0oooo01D?o@3oool05@om0?ooo`0E3od0ooooooooo`0E3od30?oo
o`0401D?oOooool0oooo01D?o@`0oooo1P00002W0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om
0?ooo`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H00000
0?ooo`3=cLd0cLg=09VIV@00000>0?ooo`0>01D?o@3oool0oooo0?ooo`0E3od0oooo01D?o@3oool0
5@om0?ooo`0E3od0ooooooooo`0E3od30?ooo`0501D?oOooool0oooo01D?o@3oool0100E3od70?oo
o`050000003oool0oooo0?ooo`000000Z03oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3oool0
oooo00l0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0
cLg=0<g=c@2IVIT000003P3oool02P0E3od0oooo0?ooo`3oool05@om0?ooo`0E3od0oooo01D?o@3o
ool201D?o@03ooooo`0E3od0oooo0080oooo00@05@omooooo`3oool05@om3@3oool010000000oooo
0?ooo`00002U0?ooo`@05@om1P3oool00`0E3od0oooo0?ooo`0?0?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI000000h0oooo00D05@om
0?ooo`3oool0oooo01D?o@050?ooo`0401D?o@3ooooooooo01D?o@80oooo0P0E3od00oooool0oooo
01D?o@0>0?ooo`030000003oool000000:P0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo
0?ooo`0?0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool01P000000oooo
0<g=c@3=cLd0VIVI000000l0oooo0`0E3od80?ooo`03ooooo`0E3od05@om0080oooo00@05@omoooo
o`0E3od05@om3`3oool200000:L0oooo0P0E3od60?ooo`0301D?o@3oool0oooo00l0oooo00D00000
0?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT00000
6P3oool00oooool0oooo0?ooo`030?ooo`03ooooo`3oool0oooo0100oooo00<000000?ooo`3oool0
Y03oool00`0E3od0oooo01D?o@060?ooo`0301D?o@3oool0oooo00l0oooo00D000000?ooo`3=cLd0
cLg=09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT000006P3oool00ooo
ool0oooo0?ooo`030?ooo`03ooooo`3oool0oooo0;H0oooo00@05@om0?ooo`3oool05@om1P3oool0
0`0E3od0oooo0?ooo`0?0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool0
1P000000oooo0<g=c@3=cLd0VIVI000001X0oooo00?ooooo0?ooo`3oool00`3oool00oooool0oooo
0?ooo`2e0?ooo`0501D?o@3oool0oooo0?ooo`0E3od01P3oool00`0E3od0oooo0?ooo`0?0?ooo`05
0000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI
000001l0oooo00?ooooo0?ooo`3oool0]@3oool601D?o@H0oooo00<05@om0?ooo`3oool03`3oool0
1@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VI
V@00000O0?ooo`03ooooo`3oool0oooo0<40oooo00<05@om0?ooo`3oool03`3oool01@000000oooo
0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00000O0?oo
o`03ooooo`3oool0oooo0<40oooo00<05@om0?ooo`3oool03`3oool01@000000oooo0<g=c@3=cLd0
VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00000O0?ooo`03ooooo`3o
ool0oooo0<40oooo00<05@om0?ooo`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI00800000
0@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00000O0?ooo`03ooooo`3oool0oooo0<40
oooo00<05@om0?ooo`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080
oooo00H000000?ooo`3=cLd0cLg=09VIV@00000O0?ooo`03ooooo`3oool0oooo0<40oooo00<05@om
0?ooo`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H00000
0?ooo`3=cLd0cLg=09VIV@00000O0?ooo`03ooooo`3oool0oooo0<40oooo00<05@om0?ooo`3oool0
3`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0
cLg=09VIV@00000O0?ooo`03ooooo`3oool0oooo0<40oooo00<05@om0?ooo`3oool03`3oool01@00
0000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00
000O0?ooo`03ooooo`3oool0oooo0<40oooo00<05@om0?ooo`3oool03`3oool01@000000oooo0<g=
c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00000O0?ooo`03
ooooo`3oool0oooo0<40oooo00<05@om0?ooo`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI
008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00000K0?ooo`03ooooo`3oool0
oooo0<D0oooo00<05@om0?ooo`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3o
ool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00000K0?ooo`03ooooo`3oool0oooo0;X0oooo
1@0E3od60?ooo`0301D?o@3oool0oooo00l0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040
oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT000006`3oool00oooool0oooo0?ooo`2n0?oo
o`0301D?o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03`3oool01@000000oooo0<g=c@3=cLd0
VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00000F0?ooo`805@om0`3o
ool00oooool05@om01D?o@2n0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03`3o
ool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=
09VIV@00000F0?ooo`0301D?o@3oool0oooo0080oooo00?ooooo0?ooo`0E3od0_P3oool00`0E3od0
oooo0?ooo`040?ooo`0301D?o@3oool0oooo00l0oooo00D000000?ooo`3=cLd0cLg=09VIV@020000
0040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT00000403oool01`0E3od0oooo01D?o@3o
ool05@om0?ooo`0E3od00`3oool01P0E3ogooooo0?ooo`0E3od0oooo01D?o@h0oooo1P0000070?oo
o`030000003oool0oooo00D0oooo1P00002C0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om0?oo
o`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?oo
o`3=cLd0cLg=09VIV@00000@0?ooo`0701D?o@3oool05@om0?ooo`0E3od0oooo01D?o@030?ooo`04
01D?oOooool0oooo01D?o@<0oooo100E3od90?ooo`8000000P3oool2000000L0oooo00<000000?oo
o`3oool01@3oool200000080oooo0P00002C0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om0?oo
o`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?oo
o`3=cLd0cLg=09VIV@00000@0?ooo`0701D?o@3oool05@om0?ooo`0E3od0oooo01D?o@030?ooo`04
01D?oOooool0oooo01D?oA40oooo0P0000080?ooo`D000001P3oool2000009H0oooo00<05@om0?oo
o`3oool0103oool00`0E3od0oooo0?ooo`0?0?ooo`050000003oool0cLg=0<g=c@2IVIT00P000001
0?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI00000100oooo00L05@om0?ooo`0E3od0oooo
01D?o@3oool05@om00<0oooo00@05@omooooo`3oool05@om0`3oool401D?o@/0oooo0P0000090?oo
o`030000003oool0oooo00L0oooo0P00002E0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om0?oo
o`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?oo
o`3=cLd0cLg=09VIV@00000@0?ooo`0401D?o@3oool05@om01D?o@80oooo00X05@om0?ooo`3oool0
oooo01D?oOooool0oooo01D?o@3oool05@om4@3oool2000000P0oooo00<000000?ooo`3oool0203o
ool2000009@0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0?0?ooo`050000003o
ool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI00000100
oooo00<05@om0?ooo`3oool00`3oool00`0E3od0oooo0?ooo`0201D?o@03ooooo`3oool05@om01@0
oooo0P00000C0?ooo`800000T`3oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3oool0oooo00l0
oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=
c@2IVIT00000403oool00`0E3od0oooo0?ooo`030?ooo`805@om00Cooooo0?ooo`0E3ogooooo0P0E
3od@0?ooo`8000000P3oool2000000l0oooo0P0000020?ooo`800000TP3oool201D?o@H0oooo00<0
5@om0?ooo`3oool03`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H0
00000?ooo`3=cLd0cLg=09VIV@00000H0?ooo`04ooooo`3oool0oooooooooa<0oooo1000000A0?oo
o`@00000TP3oool00`0E3od0oooo01D?o@060?ooo`0301D?o@3oool0oooo00l0oooo00D000000?oo
o`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT00000603o
ool01?ooool0oooo0?oooooooonm0?ooo`0401D?o@3oool0oooo01D?o@H0oooo00<05@om0?ooo`3o
ool03`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=
cLd0cLg=09VIV@00000H0?ooo`04ooooo`3oool0oooooooook`0oooo00D05@om0?ooo`3oool0oooo
01D?o@060?ooo`0301D?o@3oool0oooo00l0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040
oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT00000603oool01?ooool0oooo0?oooooooonk
0?ooo`H05@om0P3oool501D?oA40oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo0002
0?ooo`060000003oool0cLg=0<g=c@2IVIT00000603oool01?ooool0oooo0?ooooooool30?ooo`03
ooooo`3oool0oooo0=<0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`06
0000003oool0cLg=0<g=c@2IVIT00000603oool01?ooool0oooo0?ooooooool30?ooo`03ooooo`3o
ool0oooo0=<0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003o
ool0cLg=0<g=c@2IVIT00000603oool01?ooool0oooo0?ooooooool30?ooo`03ooooo`3oool0oooo
0=<0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0cLg=
0<g=c@2IVIT00000603oool01?ooool0oooo0?oooooooooI0?ooo`050000003oool0cLg=0<g=c@2I
VIT00P0000010?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI000001P0oooo00Cooooo0?oo
o`3ooooooooof@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H00000
0?ooo`3=cLd0cLg=09VIV@00000K0?ooo`03ooooo`3oool0oooo0=L0oooo00D000000?ooo`3=cLd0
cLg=09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT000006`3oool00ooo
ool0oooo0?ooo`3G0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool01P00
0000oooo0<g=c@3=cLd0VIVI000001/0oooo00?ooooo0?ooo`3oool0e`3oool01@000000oooo0<g=
c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00003e0?ooo`05
0000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI
00000?D0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00020?ooo`060000003oool0
cLg=0<g=c@2IVIT00000m@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo
00H000000?ooo`3=cLd0cLg=09VIV@00003e0?ooo`050000003oool0cLg=0<g=c@2IVIT00P000001
0?ooo`000P3oool01P000000oooo0<g=c@3=cLd0VIVI00000?D0oooo00D000000?ooo`3=cLd0cLg=
09VIV@0200000040oooo00020?ooo`060000003oool0cLg=0<g=c@2IVIT00000m@3oool01@000000
oooo0<g=c@3=cLd0VIVI008000000@3oool00080oooo00H000000?ooo`3=cLd0cLg=09VIV@00003e
0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`000P3oool01@000000oooo0<g=c@3=
cLd0VIVI0?L0000000@0oooo0<g=c@3=cLd0VIVI0P0000010?ooo`000P3oool010000000oooo0<g=
c@3=cLgi09VIV@80cLg=00<0VIVI0000000000000@3oool00080oooo00<000000?ooo`3=cLd0o03=
cLd00`2IVIT00000000000010?ooo`000P3oool00`000000oooo0<g=c@3l0<g=c@0309VIV@000000
00000040oooo00020?ooo`030000003oool0oooo0?`0oooo00<0VIVI0000003oool00@3oool00080
ooooo`00000200000080oooo003o0?ooo`H0oooo0000\
\>"], "ItemizedPicture",
  ImageSize->{261, 87},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"starting", "i:5", "b:2.3", "gs:0.3"}],

Cell[TextData[{
  "Your first calculation will take longer than subsequent calculations \
because the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel has to start up."
}], "Text",
  CellTags->{"starting", "i:5", "b:2.3", "gs:0.3"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is made of two parts: a kernel and a front end. The kernel is the part \
that does calculations. The front end is the part that handles notebooks and \
interaction with the user."
}], "Highlight",
  CellTags->{"starting", "i:5", "b:2.3", "gs:0.3"}],

Cell[TextData[{
  "TIPS\n\[Bullet] On the Macintosh, ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ReturnKey] ", "KeyboardChars"],
  "is equivalent to ",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey]", "KeyboardChars"],
  ".\n\[Bullet] On extended keyboards, you can use the ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  " key at the lower right corner of the numeric keypad to evaluate your \
input. Pressing the ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  " key in the main keypad by itself gives you a new line in the same cell. \
See ",
  ButtonBox["Working with Cells and Notebooks",
    ButtonStyle->"GettingStartedLink",
    ButtonNote->"page 14"],
  " for a discussion of cells.\n\[Bullet] You can run the ",
  ButtonBox["kernel directly",
    ButtonData:>{"Special Ways to Run the Kernel", None},
    ButtonStyle->"GettingStartedLink"],
  " from a command line; see ",
  ButtonBox["Special Ways to Run the Kernel",
    ButtonData:>{"Special Ways to Run the Kernel", None},
    ButtonStyle->"GettingStartedLink",
    ButtonNote->"page 26"],
  " to find out how."
}], "UserTips",
  CellTags->{"starting", "i:5", "b:2.3", "gs:0.3"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Your First ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Calculations"
}], "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
    "Executing calculations", "Entering input", "Conventions: Mathematica", 
    "Input cell", "Output cell", "Capital letters", 
    "Built-in functions: conventions for", "Arguments to functions", 
    "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
    "Brackets: conventions for", "Syntax: Mathematica", 
    "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
    "Tour of Mathematica", "Notebooks", "Help Browser examples", 
    "Examples to try", "firstcalc", "i:10", "gs:0.4"}],

Cell[TextData[{
  "You can use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " just like a calculator. Type your input, press ",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey]", "KeyboardChars"],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns the answer. "
}], "Highlight",
  CellTags->{"firstcalc", "gs:0.4"}],

Cell[TextData[{
  "See ",
  ButtonBox["\[OpenCurlyDoubleQuote]Tour of ",
    ButtonData:>{"Mathematica as a Calculator"},
    ButtonStyle->"GettingStartedLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"Mathematica as a Calculator"},
    ButtonStyle->"GettingStartedLink"],
    FontSlant->"Italic"],
  ButtonBox["\[CloseCurlyDoubleQuote]",
    ButtonData:>{"Mathematica as a Calculator"},
    ButtonStyle->"GettingStartedLink"],
  " in the Help Browser or in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  " for a quick look at some of",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s capabilities."
}], "MoreInfo",
  CellTags->{"firstcalc", "gs:0.4"}],

Cell[TextData[{
  "Type the input ",
  StyleBox["9.7^200", "MB"],
  " and press ",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey]", "KeyboardChars"],
  "."
}], "Text",
  CellTags->{"firstcalc", "gs:0.4"}],

Cell["Here is the result.", "Text",
  CellTags->{"firstcalc", "gs:0.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004G0000ER000`400?l00000o`00003oo`3ooolH
0?ooo`000`3ooooo000001@000000@3oool000030?ooo`00000000000?l00000500000010?ooo`00
00<0oooo0000003>c/h0o`2LW9`B09bLW08000000@3oool000030?ooo`000000oooo0?l0c/k>4@3>
c/h00`2LW9`00000000000010?ooo`0000<0oooo0000003oool0o`3>c/hA0<k>cP0309bLW0000000
00000040oooo00000`3oool000000?ooo`020<k>c_l0oooo3@3oool20<k>cP0309bLW00000000000
0040oooo00000`3oool000000?ooo`020<k>cP0309bLW000000000000?l000002@000000103oool0
c/k>0<k>cP2LW9`200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0
oooo203oool01@000000oooo0<k>cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080
c/k>00<0W9bL0000003oool0o`3oool80?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?oo
o`0000<0oooo0000003oool00P3>c/h00`2LW9`000000?ooo`3o0?ooo`P0oooo00D000000?ooo`3>
c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0
oooo203oool01@000000oooo0<k>cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080
c/k>00<0W9bL0000003oool0o`3oool80?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?oo
o`0000<0oooo0000003oool00P3>c/h00`2LW9`000000?ooo`3o0?ooo`P0oooo00D000000?ooo`3>
c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0
oooo203oool01@000000oooo0<k>cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080
c/k>00<0W9bL0000003oool0o`3oool80?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?oo
o`0000<0oooo0000003oool00P3>c/h00`2LW9`000000?ooo`3o0?ooo`P0oooo00D000000?ooo`3>
c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0
oooo203oool01@000000oooo0<k>cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080
c/k>00<0W9bL0000003oool0o`3oool80?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?oo
o`0000<0oooo0000003oool00P3>c/h00`2LW9`000000?ooo`3o0?ooo`P0oooo00D000000?ooo`3>
c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0
oooo203oool01@000000oooo0<k>cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080
c/k>00<0W9bL0000003oool0k03oool50108o`80oooo1@0@2?l?0?ooo`050000003oool0c/k>0<k>
cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>c/h00`2LW9`000000?ooo`3`0?ooo`03
0108o`3oool0oooo00@0oooo00<040So0?ooo`3oool03@3oool01@000000oooo0<k>cP3>c/h0W9bL
008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0703oool20108o`@0
oooo0P0@2?o<0?ooo`030108o`3oool0oooo00@0oooo00<040So0?ooo`3oool03@3oool01@000000
oooo0<k>cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003o
ool0703oool00`0@2?l0oooo0?ooo`040?ooo`030108o`3oool0oooo0<X0oooo00<040So0?ooo`3o
ool0103oool00`0@2?l0oooo0?ooo`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?oo
o`0000<0oooo0000003oool00P3>c/h00`2LW9`000000?ooo`0@0?ooo`<040So0`3oool20108o`80
oooo00@040So0?ooo`0@2?l0oooo100@2?l00`3oool040So0?ooo`0=0?ooo`D000000`3oool00`00
0000oooo0?ooo`030?ooo`D000000`3oool3000000<0oooo1@0000020?ooo`D00000103oool30000
00@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool5000000<0oooo0`00001g
0?ooo`030108o`3oool0oooo00@0oooo00<040So0?ooo`3oool03@3oool01@000000oooo0<k>cP3>
c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool03`3oool0
2`0@2?l0oooo0?ooo`3oool040So0?ooo`0@2?l0oooo0108o`3oool040So0080oooo00<040So0?oo
o`0@2?l0103oool00`0@2?l0oooo0108o`030108o`T0oooo00D000000?ooo`3oool0oooo00000009
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3o
ool0103oool010000000oooo0?ooo`0000060?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo0000001f0?ooo`030108o`3oool0oooo00@0oooo00<040So0?ooo`3oool03@3oool0
1@000000oooo0<k>cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL
0000003oool03`3oool02`0@2?l0oooo0?ooo`3oool040So0?ooo`0@2?l0oooo0108o`3oool040So
0080oooo00@040So0?ooo`3oool040So0`3oool00`0@2?l0oooo0?ooo`0=0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`H000001P3oool2000000L0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000007H0oooo00<040So0?ooo`3oool0
103oool00`0@2?l0oooo0?ooo`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`00
00<0oooo0000003oool00P3>c/h00`2LW9`000000?ooo`0?0?ooo`0;0108o`3oool0oooo0?ooo`0@
2?l0oooo0108o`3oool040So0?ooo`0@2?l00P3oool01@0@2?l0oooo0?ooo`3oool040So0080oooo
00<040So0?ooo`0@2?l00`0@2?l;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool2000000L0oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool0000007H0oooo00<040So0?ooo`3oool0103oool0
0`0@2?l0oooo0?ooo`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo
0000003oool00P3>c/h00`2LW9`000000?ooo`0?0?ooo`0:0108o`3oool0oooo0?ooo`0@2?l0oooo
0108o`3oool040So0?ooo`8040So00<0oooo0108o`3oool00`3oool00`0@2?l0oooo0108o`0A0?oo
o`030000003oool0oooo00/0oooo00@000000?ooo`3oool0oooo100000050?ooo`030000003oool0
oooo00D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00@0
00000?ooo`3oool000001P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
0000MP3oool00`0@2?l0oooo0?ooo`040?ooo`030108o`3oool0oooo00d0oooo00D000000?ooo`3>
c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo00l0
oooo00D040So0?ooo`3oool0oooo0108o`050?ooo`060108o`3oool0oooo0108o`3oool040So0P3o
ool00`0@2?l0oooo0108o`0>0?ooo`050000003oool0oooo0?ooo`0000002@3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`000000MP3oool00`0@2?l0oooo0?ooo`040?ooo`030108o`3oool0oooo00d0oooo00D00000
0?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000
oooo0100oooo0`0@2?l90?ooo`8040So00@0oooo0108o`0@2?l0oooo0P0@2?l>0?ooo`050000003o
ool0oooo0?ooo`0000002@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool00`3oool3000000@0oooo00D000000?ooo`3oool0oooo000000040?ooo`8000003P3oool30000
00@0oooo00H000000?ooo`3oool0oooo0000003oool5000000030?ooo`000000000000D0oooo00<0
00000?ooo`3oool0HP3oool40108o`H0oooo00<040So0?ooo`3oool03@3oool01@000000oooo0<k>
cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0<`3o
ool3000000/0oooo0`0000050?ooo`<00000103oool00`000000oooo0?ooo`030?ooo`<000001P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1U0?ooo`030108o`3o
ool0oooo00@0oooo00<040So0?ooo`3oool03@3oool01@000000oooo0<k>cP3>c/h0W9bL00800000
0@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0O@3oool00`000000oooo0?oo
o`020?ooo`<00000103oool00`000000oooo0?ooo`1S0?ooo`8040So1P3oool00`0@2?l0oooo0?oo
o`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>
c/h00`2LW9`000000?ooo`1m0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0680oooo00<040So0?ooo`0@2?l01P3oool00`0@2?l0oooo
0?ooo`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool0
0P3>c/h00`2LW9`000000?ooo`1k0?ooo`<000000`3oool01P000000oooo0?ooo`000000oooo0000
0080oooo00<000000?ooo`3oool0H@3oool0100@2?l0oooo0?ooo`0@2?l60?ooo`030108o`3oool0
oooo00d0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`02
0<k>cP0309bLW0000000oooo07d0oooo00<000000?ooo`3oool00P3oool200000080oooo1000001R
0?ooo`050108o`3oool0oooo0?ooo`0@2?l01P3oool00`0@2?l0oooo0?ooo`0=0?ooo`050000003o
ool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>c/h00`2LW9`000000?oo
o`3[0?ooo`H040So1P3oool00`0@2?l0oooo0?ooo`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`0
0P0000010?ooo`0000<0oooo0000003oool00P3>c/h00`2LW9`000000?ooo`3g0?ooo`030108o`3o
ool0oooo00d0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3oool000000?oo
o`020<k>cP0309bLW0000000oooo0?L0oooo00<040So0?ooo`3oool03@3oool01@000000oooo0<k>
cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0m`3o
ool00`0@2?l0oooo0?ooo`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0
oooo0000003oool00P3>c/h00`2LW9`000000?ooo`3g0?ooo`030108o`3oool0oooo00d0oooo00D0
00000?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW000
0000oooo0?L0oooo00<040So0?ooo`3oool03@3oool01@000000oooo0<k>cP3>c/h0W9bL00800000
0@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0m`3oool00`0@2?l0oooo0?oo
o`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>
c/h00`2LW9`000000?ooo`3g0?ooo`030108o`3oool0oooo00d0oooo00D000000?ooo`3>c/h0c/k>
09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?L0oooo00<0
40So0?ooo`3oool03@3oool01@000000oooo0<k>cP3>c/h0W9bL008000000@3oool000030?ooo`00
0000oooo0080c/k>00<0W9bL0000003oool0m`3oool00`0@2?l0oooo0?ooo`0=0?ooo`050000003o
ool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>c/h00`2LW9`000000?oo
o`3g0?ooo`030108o`3oool0oooo00d0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo
00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo0>`0oooo1@0@2?l60?ooo`030108o`3o
ool0oooo00d0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3oool000000?oo
o`020<k>cP0309bLW0000000oooo0?00oooo00<040So0?ooo`3oool0103oool00`0@2?l0oooo0?oo
o`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>
c/h00`2LW9`000000?ooo`0G0?ooo`8040So103oool20108om40oooo00<040So0?ooo`3oool0103o
ool00`0@2?l0oooo0?ooo`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0
oooo0000003oool00P3>c/h00`2LW9`000000?ooo`0G0?ooo`030108o`3oool0oooo00@0oooo00<0
40So0?ooo`3oool0c`3oool00`0@2?l0oooo0?ooo`040?ooo`030108o`3oool0oooo00d0oooo00D0
00000?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW000
0000oooo0140oooo00P040So0?ooo`0@2?l0oooo0108o`3oool040So0?ooo`@040So00@0oooo0108
o`3oool040So3`3oool3000000D0oooo0P0000070?ooo`8000003`3oool6000000<0oooo10000004
0?ooo`@00000R@3oool00`0@2?l0oooo0?ooo`040?ooo`030108o`3oool0oooo00d0oooo00D00000
0?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000
oooo0140oooo00T040So0?ooo`0@2?l0oooo0108o`3oool040So0?ooo`0@2?l0103oool0100@2?l0
oooo0?ooo`3oool40108o``0oooo0P00000=0?ooo`8000003`3oool200000080oooo0P0000020?oo
o`8000000P3oool200000080oooo0P0000020?ooo`800000R03oool00`0@2?l0oooo0?ooo`040?oo
o`030108o`3oool0oooo00d0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3o
ool000000?ooo`020<k>cP0309bLW0000000oooo0140oooo00L040So0?ooo`0@2?l0oooo0108o`3o
ool040So0080oooo00D040So0?ooo`3oool0oooo0108o`0D0?ooo`800000303oool200000100oooo
0P0000050?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000R03oool00`0@2?l0oooo
0?ooo`040?ooo`030108o`3oool0oooo00d0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040
oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo0140oooo00L040So0?ooo`0@2?l0
oooo0108o`3oool040So00<0oooo00@040So0?ooo`3oool040So0`3oool40108o`X0oooo1@00000=
0?ooo`800000403oool2000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P000028
0?ooo`030108o`3oool0oooo00@0oooo00<040So0?ooo`3oool03@3oool01@000000oooo0<k>cP3>
c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool04@3oool0
100@2?l0oooo0108o`0@2?l20?ooo`030108o`3oool0oooo0080oooo00D040So0?ooo`0@2?l0oooo
0108o`0>0?ooo`8000000P3oool2000000d0oooo0P00000A0?ooo`8000000`3oool200000080oooo
0P0000020?ooo`8000000P3oool2000008P0oooo00<040So0?ooo`3oool0103oool00`0@2?l0oooo
0?ooo`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool0
0P3>c/h00`2LW9`000000?ooo`0A0?ooo`030108o`3oool0oooo00<0oooo00<040So0?ooo`0@2?l0
0P3oool00`0@2?l0oooo0108o`0@0?ooo`8000000P3oool2000000h0oooo0P0000030?ooo`800000
0P3oool2000000P0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000
R03oool00`0@2?l0oooo0?ooo`040?ooo`030108o`3oool0oooo00d0oooo00D000000?ooo`3>c/h0
c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>cP0309bLW0000000oooo0140oooo
00<040So0?ooo`3oool00`3oool20108o`040?ooo`0@2?l040So0?ooo`8040So403oool200000080
oooo0P00000:0?ooo`8000000P3oool2000000@0oooo100000050?ooo`8000000P3oool200000080
oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000270?ooo`8040So1P3oool00`0@2?l0
oooo0?ooo`0=0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003o
ool00P3>c/h00`2LW9`000000?ooo`0`0?ooo`@000002`3oool6000000D0oooo0P0000070?ooo`@0
0000103oool4000000@0oooo100000270?ooo`030108o`3oool040So00H0oooo00<040So0?ooo`3o
ool03@3oool01@000000oooo0<k>cP3>c/h0W9bL008000000@3oool000030?ooo`000000oooo0080
c/k>00<0W9bL0000003oool0k@3oool0100@2?l0oooo0?ooo`0@2?l60?ooo`030108o`3oool0oooo
00d0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`020<k>
cP0309bLW0000000oooo0>`0oooo00D040So0?ooo`3oool0oooo0108o`060?ooo`030108o`3oool0
oooo00d0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo00000`3oool000000?ooo`02
0<k>cP0309bLW0000000oooo0>/0oooo1P0@2?l20?ooo`D040So3`3oool01@000000oooo0<k>cP3>
c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0o`3oool8
0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>c/h0
0`2LW9`000000?ooo`3o0?ooo`P0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo0000
0`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0oooo203oool01@000000oooo0<k>cP3>
c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0o`3oool8
0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>c/h0
0`2LW9`000000?ooo`3o0?ooo`P0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo0000
0`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0oooo203oool01@000000oooo0<k>cP3>
c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0o`3oool8
0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>c/h0
0`2LW9`000000?ooo`3o0?ooo`P0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo0000
0`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0oooo203oool01@000000oooo0<k>cP3>
c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0o`3oool8
0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>c/h0
0`2LW9`000000?ooo`3o0?ooo`P0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo0000
0`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0oooo203oool01@000000oooo0<k>cP3>
c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0o`3oool8
0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>c/h0
0`2LW9`000000?ooo`3o0?ooo`P0oooo00D000000?ooo`3>c/h0c/k>09bLW00200000040oooo0000
0`3oool000000?ooo`020<k>cP0309bLW0000000oooo0?l0oooo203oool01@000000oooo0<k>cP3>
c/h0W9bL008000000@3oool000030?ooo`000000oooo0080c/k>00<0W9bL0000003oool0o`3oool8
0?ooo`050000003oool0c/k>0<k>cP2LW9`00P0000010?ooo`0000<0oooo0000003oool00P3>c/h0
0`2LW9`000000000003o000000T0000000@0oooo0<k>cP3>c/h0W9bL0P0000010?ooo`0000<0oooo
0000003oool00P3>c/ko09bLW0d0W9bL0P3>c/h00`2LW9`00000000000010?ooo`0000<0oooo0000
003oool0o`3>c/hA0<k>cP0309bLW000000000000040oooo00000`3oool000000?ooo`3o0<k>cQ40
c/k>00<0W9bL0000000000000@3oool000030?ooo`000000oooo0?l0oooo4@3oool00`2LW9`00000
0?ooo`010?ooo`0000<0oooo000000000000o`00000C00000080oooo003o0?oooaP0oooo0000\
\>"], "ItemizedPicture",
  ImageSize->{279, 86},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"firstcalc", "gs:0.4"}],

Cell[TextData[{
  "Here is an example from algebra. The first bracket after the function name \
",
  StyleBox["Factor", "MR"],
  " is a special color until the closing bracket is typed."
}], "Text",
  CellTags->{"firstcalc", "gs:0.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004F0000IB000`400?l00000o`00003oo`3ooolG
0?ooo`000`3ooooo000001<000000@3oool000030?ooo`00000000000?l000004`0000010?ooo`00
00<0oooo0000003=cLd0o`2IVIT>09VIV@80cLg=00<0VIVI0000000000000@3oool000030?ooo`00
0000oooo0?l0cLg=403=cLd00`2IVIT00000000000010?ooo`0000<0oooo0000003oool0o`3=cLd@
0<g=c@0309VIV@00000000000040oooo00000`3oool000000?ooo`020<g=cOl0oooo303oool20<g=
c@0309VIV@00000000000040oooo00000`3oool000000?ooo`020<g=c@0309VIV@00000000000?l0
000020000000103oool0cLg=0<g=c@2IVIT200000040oooo00000`3oool000000?ooo`020<g=c@03
09VIV@000000oooo0?l0oooo1`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00003
0?ooo`000000oooo0080cLg=00<0VIVI0000003oool0o`3oool70?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o0?ooo`L0
oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@03
09VIV@000000oooo0?l0oooo1`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00003
0?ooo`000000oooo0080cLg=00<0VIVI0000003oool0o`3oool70?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o0?ooo`L0
oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@03
09VIV@000000oooo0?l0oooo1`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00003
0?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3oool00oooool0oooo0?ooo`3a0?ooo`05
0000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT0
00000?ooo`0B0?ooo`03ooooo`3oool0oooo00@0oooo00?ooooo0?ooo`3oool0jP3oool01@000000
oooo0<g=c@3=cLd0VIVI008000000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003o
ool04P3oool00oooool0oooo0?ooo`040?ooo`03ooooo`3oool0oooo0>X0oooo00D000000?ooo`3=
cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0180
oooo00?ooooo0?ooo`3oool0103oool00oooool0oooo0?ooo`3Z0?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0B0?ooo`03
ooooo`3oool0oooo00@0oooo00?ooooo0?ooo`3oool0jP3oool01@000000oooo0<g=c@3=cLd0VIVI
008000000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3oool01Oooool0
oooo0?ooo`3ooooooooo0=@0oooo1@0E3od20?ooo`D05@om3`3oool01@000000oooo0<g=c@3=cLd0
VIVI008000000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3oool01Ooo
ool0oooo0?ooo`3ooooooooo0=P0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0=
0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd0
0`2IVIT000000?ooo`0B0?ooo`05ooooo`3oool0oooo0?ooooooool07@3oool00`000000oooo0?oo
o`1o0?ooo`030000003oool0oooo03H0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?oo
o`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=
cLd00`2IVIT000000?ooo`0B0?ooo`05ooooo`3oool0oooo0?ooooooool0703oool00`000000oooo
0?ooo`210?ooo`030000003oool0oooo03D0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo
0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool0
0P3=cLd00`2IVIT000000?ooo`0B0?ooo`05ooooo`3oool0oooo0?ooooooool06`3oool00`000000
oooo0?ooo`020?ooo`D000003@3oool2000000<0oooo0P00000C0?ooo`8000000`3oool2000001T0
oooo0P0000030?ooo`800000603oool2000000<0oooo0P00000?0?ooo`030000003oool0oooo03@0
oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0B0?ooo`05
ooooo`3oool0oooo0?ooooooool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000d0oooo00<00000
0?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000001<0oooo00<000000?ooo`3oool01@3o
ool01@000000oooo0?ooo`3oool000000180oooo00<000000?ooo`3oool01@3oool01@000000oooo
0?ooo`3oool000000100oooo00<000000?ooo`3oool0=03oool00`0E3od0oooo0?ooo`040?ooo`03
01D?o@3oool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool0
00000?ooo`020<g=c@0309VIV@000000oooo0180oooo00Gooooo0?ooo`3oool0ooooooooo`0K0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0000000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000D0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`0000004`3oool00`000000oooo0?ooo`060?oo
o`030000003oool000000140oooo00<000000?ooo`3oool0=03oool00`0E3od0oooo0?ooo`040?oo
o`0301D?o@3oool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3o
ool000000?ooo`020<g=c@0309VIV@000000oooo0180oooo00Gooooo0?ooo`3oool0ooooooooo`0K
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool5000000L0oooo00<00000
0?ooo`3oool02`3oool5000000L0oooo00<000000?ooo`3oool04@3oool5000000L0oooo00<00000
0?ooo`3oool0403oool5000000L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0d
0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo0<g=c@3=
cLd0VIVI008000000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3oool0
1Oooool0oooo0?ooo`3ooooooooo01/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000003P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0000001@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000
000C0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000004@3oool00`000000oooo0?oo
o`0d0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo0<g=
c@3=cLd0VIVI008000000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3o
ool01Oooool0oooo0?ooo`3ooooooooo01/0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00@0oooo0`000000103oool0000000000000000<0?ooo`03
0000003oool0oooo00@0oooo0`000000103oool0000000000000000B0?ooo`030000003oool0oooo
00@0oooo0`000000103oool0000000000000000A0?ooo`030000003oool0oooo00@0oooo0`000000
103oool0000000000000000?0?ooo`030000003oool0oooo03@0oooo00<05@om0?ooo`3oool0103o
ool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0
oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0B0?ooo`05ooooo`3oool0oooo0?ooooooool0
703oool010000000oooo0?ooo`3oool3000001L0oooo0`00000F0?ooo`D000000P3oool2000001L0
oooo1@000000103oool0000000000000000G0?ooo`@000000P3oool2000000D0oooo00<000000?oo
o`3oool0=@3oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3oool0oooo00d0oooo00D000000?oo
o`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo
0180oooo00Gooooo0?ooo`3oool0ooooooooo`0M0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0E0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0503o
ool2000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0f0?ooo`0301D?
o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI0080
00000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3oool01Oooool0oooo
0?ooo`3ooooooooo03d0oooo00<000000?ooo`3oool05@3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
01H0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0j0?ooo`0301D?o@3oool0
oooo00@0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3o
ool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3oool01Oooool0oooo0?ooo`3o
oooooooo03X0oooo0`00000H0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`0F0?ooo`040000003oool0oooo0?ooo`<000006P3oool00`000000oooo000000020?ooo`03
0000003oool0oooo03X0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0=0?ooo`05
0000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT0
00000?ooo`0B0?ooo`05ooooo`3oool0oooo0?ooooooool0>P3oool00`000000oooo0?ooo`0F0?oo
o`<000000`3oool010000000oooo0?ooo`00000F0?ooo`<000000`3oool00`000000oooo0?ooo`0G
0?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`0j0?ooo`0301D?
o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI0080
00000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3oool01Oooool0oooo
0?ooo`3ooooooooo03X0oooo0`00000H0?ooo`030000003oool0oooo0080oooo0P00000I0?ooo`04
0000003oool0oooo0?ooo`<00000603oool2000000<0oooo0P00000m0?ooo`0301D?o@3oool0oooo
00@0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool0
00030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3oool01Oooool0oooo0?ooo`3ooooo
oooo0=P0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0
cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0B
0?ooo`05ooooo`3oool0oooo0?ooooooool0f03oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3o
ool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?oo
o`020<g=c@0309VIV@000000oooo0180oooo00Gooooo0?ooo`3oool0ooooooooo`3H0?ooo`0301D?
o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI0080
00000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04P3oool01Oooool0oooo
0?ooo`3ooooooooo0=P0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0=0?ooo`05
0000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT0
00000?ooo`0B0?ooo`05ooooo`0E3od05@om0?ooooooool00P3oool201D?oA80oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo06T0oooo00<000000?oo
o`3oool0803oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3oool0oooo00d0oooo00D000000?oo
o`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo
0180oooo00Gooooo01D?o@3oool0ooooooooo`030?ooo`0301D?o@3oool0oooo00l0oooo00<00000
0?ooo`3oool0903oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo06/0oooo00<00000
0?ooo`3oool07`3oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3oool0oooo00d0oooo00D00000
0?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@0309VIV@000000
oooo00L0oooo0`0E3od30?ooo`805@om0P3oool00`0E3ogooooo01D?o@020?ooo`805@om00<0oooo
ooooo`0E3od0403oool00`000000oooo0?ooo`090?ooo`D000003P3oool2000000<0oooo0P000003
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool5000000d0oooo0P000003
0?ooo`8000003@3oool2000000<0oooo0P00000C0?ooo`8000000`3oool2000001<0oooo0P000003
0?ooo`8000002P3oool00`000000oooo0?ooo`0N0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om
0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool000030?ooo`000000
oooo0080cLg=00<0VIVI0000003oool01P3oool0400E3od0oooo0?ooo`3oool05@om0?ooo`0E3od0
oooo01D?o@3oool05@om0?ooooooool05@om0?ooo`0E3od20?ooo`0401D?oOooool05@om0?ooo`@0
5@om2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool01@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3o
ool0000000d0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000d0oooo
00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3o
ool07P3oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3oool0oooo00d0oooo00D000000?ooo`3=
cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo00H0
oooo00h05@om0?ooo`3oool0oooo01D?o@3oool05@om0?ooo`0E3od0oooo01D?o@3ooooooooo01D?
o@@0oooo00<05@omooooo`0E3od0403oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo000000050?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`060?ooo`030000003oool00000
00h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000>0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`000000303oool00`000000oooo0?ooo`0N0?ooo`0301D?o@3oool0oooo
00@0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool0
00030?ooo`000000oooo0080cLg=00<0VIVI0000003oool01P3oool03P0E3od0oooo0?ooo`3oool0
5@om0?ooo`0E3od0oooo01D?o@3oool05@om0?ooooooool05@om0`3oool01@0E3od0ooooooooo`0E
3od0oooo00@05@om2`3oool00`000000oooo0?ooo`020?ooo`D00000103oool00`000000oooo0?oo
o`050?ooo`D000001`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`D000001P3oool00`000000oooo0?oo
o`050?ooo`D000001`3oool00`000000oooo0?ooo`0;0?ooo`D000001`3oool00`000000oooo0?oo
o`0;0?ooo`D000001`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01h0oooo00<0
5@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT0
0P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`060?ooo`0:01D?o@3o
ool0oooo0?ooo`0E3od0oooo01D?o@3oool05@om0?ooo`805@om00?ooooo01D?o@3oool00`3oool0
0`0E3ogooooo01D?o@0@0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo000000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000003P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0000000<0?ooo`030000003oool0oooo01h0oooo00<05@om0?ooo`3oool0103oool0
0`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo
0000003oool00P3=cLd00`2IVIT000000?ooo`060?ooo`0501D?o@3oool0oooo0?ooo`0E3od01@3o
ool01P0E3od0ooooooooo`0E3od0oooo01D?o@80oooo00<05@omooooo`0E3od0403oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool300000004
0?ooo`0000000000000000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool3000000040?ooo`0000000000
000000H0oooo00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000`0oooo00<0
00000?ooo`3oool0103oool3000000040?ooo`0000000000000000`0oooo00<000000?ooo`3oool0
103oool3000000040?ooo`0000000000000000X0oooo00<000000?ooo`3oool07P3oool00`0E3od0
oooo0?ooo`040?ooo`0301D?o@3oool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@020000
0040oooo00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo00L0oooo0`0E3od80?ooo`04
ooooo`0E3od05@om0?ooo`805@om00Cooooo01D?oOlE3ogooooo403oool00`000000oooo0?ooo`08
0?ooo`<000006@3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo0?ooo`<00000:`3o
ool4000001D0oooo0`00000I0?ooo`<00000103oool00`000000oooo0?ooo`0L0?ooo`@05@om1P3o
ool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0
oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0B0?ooo`03ooooo`3oool0oooo00<0oooo00Co
oooo0?oooooooooooooo4@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02T0oooo
0P00000J0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0P0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo
0<g=c@3=cLd0VIVI008000000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool0
4P3oool00oooool0oooo0?ooo`030?ooo`04ooooo`3oooooooooooooogL0oooo00<000000?ooo`3o
ool05@3oool2000001P0oooo1000000U0?ooo`805@om1P3oool00`0E3od0oooo0?ooo`0=0?ooo`05
0000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT0
00000?ooo`0B0?ooo`03ooooo`3oool0oooo0080oooo00Cooooo0?ooo`3oooooooooN@3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`0000009@3oool00`0E
3od0oooo01D?o@060?ooo`0301D?o@3oool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@02
00000040oooo00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0180oooo00?ooooo0?oo
o`3oool00P3oool01?ooool0oooo0?oooooooomf0?ooo`040000003oool0oooo000001D0oooo00@0
00000?ooo`3oool00000603oool2000002@0oooo00@05@om0?ooo`3oool05@om1P3oool00`0E3od0
oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003o
ool00P3=cLd00`2IVIT000000?ooo`0B0?ooo`03ooooo`3oool0oooo00@0oooo00?ooooo0?ooo`3o
ool0MP3oool2000001L0oooo0P00000J0?ooo`030000003oool0oooo0240oooo00D05@om0?ooo`3o
ool0oooo01D?o@060?ooo`0301D?o@3oool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@02
00000040oooo00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0180oooo00?ooooo0?oo
o`3oool0103oool00oooool0oooo0?ooo`3>0?ooo`H05@om1P3oool00`0E3od0oooo0?ooo`0=0?oo
o`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2I
VIT000000?ooo`0B0?ooo`03ooooo`3oool0oooo00@0oooo00?ooooo0?ooo`3oool0fP3oool00`0E
3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000
003oool00P3=cLd00`2IVIT000000?ooo`0B0?ooo`03ooooo`3oool0oooo00@0oooo00?ooooo0?oo
o`3oool0fP3oool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P000001
0?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0B0?ooo`03ooooo`3oool0oooo
00@0oooo00?ooooo0?ooo`3oool0fP3oool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=
0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0B0?oo
o`04ooooo`3oool0ooooooooo`@0oooo00?ooooo0?ooo`3oool0f@3oool00`0E3od0oooo0?ooo`0=
0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd0
0`2IVIT000000?ooo`0A0?ooo`;ooooo1`3oool00oooool0oooo0?ooo`3I0?ooo`0301D?o@3oool0
oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`02
0<g=c@0309VIV@000000oooo0140oooo00?ooooo0?ooo`3oool01@3oool00oooool0oooo0?ooo`3J
0?ooo`0301D?o@3oool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo0000
0`3oool000000?ooo`020<g=c@0309VIV@000000oooo0140oooo00?ooooo0?ooo`3oool0hP3oool0
0`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo
0000003oool00P3=cLd00`2IVIT000000?ooo`0A0?ooo`03ooooo`3oool0oooo0>80oooo00<05@om
0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool000030?ooo`000000
oooo0080cLg=00<0VIVI0000003oool04@3oool00oooool0oooo0?ooo`3R0?ooo`0301D?o@3oool0
oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`02
0<g=c@0309VIV@000000oooo0140oooo00?ooooo0?ooo`3oool0hP3oool00`0E3od0oooo0?ooo`0=
0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd0
0`2IVIT000000?ooo`0A0?ooo`03ooooo`3oool0oooo0=L0oooo1@0E3od60?ooo`0301D?o@3oool0
oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`02
0<g=c@0309VIV@000000oooo0140oooo00?ooooo0?ooo`3oool0f`3oool00`0E3od0oooo0?ooo`04
0?ooo`0301D?o@3oool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo0000
0`3oool000000?ooo`020<g=c@0309VIV@000000oooo00h0oooo0P0E3od0103ooooooooo0?ooo`3o
ool201D?oD40oooo1000000j0?ooo`@00000EP3oool00`0E3od0oooo0?ooo`040?ooo`0301D?o@3o
ool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?oo
o`020<g=c@0309VIV@000000oooo00h0oooo00@05@om0?ooo`3ooooooooo0`3oool00`0E3od0oooo
0?ooo`0o0?ooo`800000?P3oool2000005H0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo
0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool0
0P3=cLd00`2IVIT000000?ooo`080?ooo`0701D?o@3oool05@om0?ooo`0E3od0oooo01D?o@020?oo
o`805@om00D0ooooooooo`0E3od0oooo01D?o@0=0?ooo`D00000103oool6000000<0oooo10000005
0?ooo`<00000103oool4000000<0oooo1@0000040?ooo`800000103oool6000000d0oooo1P000003
0?ooo`@00000403oool6000000@0oooo0P00001F0?ooo`0301D?o@3oool0oooo00@0oooo00<05@om
0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool000030?ooo`000000
oooo0080cLg=00<0VIVI0000003oool0203oool02@0E3od0oooo01D?o@3oool05@om0?ooo`0E3od0
oooo01D?o@020?ooo`0301D?oOooool05@om00<0oooo100E3od90?ooo`8000001@3oool200000080
oooo0P0000030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`80
00000P3oool2000000<0oooo0P0000060?ooo`8000001@3oool4000000h0oooo0P0000020?ooo`80
00000P3oool200000080oooo0P00000A0?ooo`8000001P3oool2000005H0oooo00<05@om0?ooo`3o
ool0103oool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?oo
o`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`080?ooo`0701D?o@3oool05@om0?oo
o`0E3od0oooo01D?o@040?ooo`0301D?oOooool05@om0100oooo0P0000050?ooo`8000000P3oool2
000000<0oooo0P0000070?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001P3oool2
000000H0oooo0P00000@0?ooo`8000002@3oool2000000D0oooo1@0000070?ooo`8000001P3oool2
000005H0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0
cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`08
0?ooo`0701D?o@3oool05@om0?ooo`0E3od0oooo01D?o@030?ooo`0401D?o@3ooooooooo01D?o@<0
oooo100E3od90?ooo`@00000103oool5000000<0oooo0P0000070?ooo`8000001@3oool200000080
oooo0P0000030?ooo`8000001P3oool2000000H0oooo0P00000A0?ooo`800000103oool200000080
oooo0P00000A0?ooo`8000001P3oool2000005H0oooo00<05@om0?ooo`3oool0103oool00`0E3od0
oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003o
ool00P3=cLd00`2IVIT000000?ooo`080?ooo`0401D?o@3oool05@om01D?o@80oooo00<05@om0?oo
o`3oool00P3oool01@0E3ogooooo01D?o@3oool05@om00h0oooo100000030?ooo`8000000P3oool2
000000<0oooo0P0000020?ooo`8000000`3oool2000000D0oooo0P0000020?ooo`8000000`3oool3
000000D0oooo0P0000050?ooo`@000004@3oool2000000<0oooo1@00000B0?ooo`8000001P3oool2
000005H0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0
cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`08
0?ooo`0301D?o@3oool0oooo00<0oooo00<05@om0?ooo`0E3od00P3oool00`0E3ogooooo01D?o@0@
0?ooo`@00000103oool4000000D0oooo100000030?ooo`D00000103oool4000000<0oooo1P000003
0?ooo`800000103oool6000000<0oooo0P0000020?ooo`800000203oool200000080oooo0P00000C
0?ooo`@000001P3oool2000005H0oooo00<05@om0?ooo`3oool0103oool00`0E3od0oooo0?ooo`0=
0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd0
0`2IVIT000000?ooo`080?ooo`0301D?o@3oool0oooo00<0oooo0P0E3od0103oool05@om01D?oOoo
ool201D?oA00oooo0P0000020?ooo`8000004`3oool2000001H0oooo0P00000>0?ooo`@000001@3o
ool200000080oooo0P0000020?ooo`800000503oool3000000H0oooo0P00001E0?ooo`805@om1P3o
ool00`0E3od0oooo0?ooo`0=0?ooo`050000003oool0cLg=0<g=c@2IVIT00P0000010?ooo`0000<0
oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0C0?ooo`03ooooo`3oool0oooo00l0oooo1`00
000C0?ooo`8000005P3oool4000000d0oooo0P0000070?ooo`@000000`3oool600000140oooo0P00
00040?ooo`@00000E03oool00`0E3od0oooo01D?o@060?ooo`0301D?o@3oool0oooo00d0oooo00D0
00000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@0309VIV@00
0000oooo01<0oooo00?ooooo0?ooo`3oool0eP3oool0100E3od0oooo0?ooo`0E3od60?ooo`0301D?
o@3oool0oooo00d0oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool00000
0?ooo`020<g=c@0309VIV@000000oooo01<0oooo00?ooooo0?ooo`3oool0e@3oool01@0E3od0oooo
0?ooo`3oool05@om00H0oooo00<05@om0?ooo`3oool03@3oool01@000000oooo0<g=c@3=cLd0VIVI
008000000@3oool000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool04`3oool00oooool0
oooo0?ooo`3D0?ooo`H05@om0P3oool501D?o@l0oooo00D000000?ooo`3=cLd0cLg=09VIV@020000
0040oooo00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo01<0oooo00?ooooo0?ooo`3o
ool0l03oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool000030?ooo`000000oooo0080
cLg=00<0VIVI0000003oool04`3oool00oooool0oooo0?ooo`3`0?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o0?ooo`L0
oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@03
09VIV@000000oooo0?l0oooo1`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00003
0?ooo`000000oooo0080cLg=00<0VIVI0000003oool0o`3oool70?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o0?ooo`L0
oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@03
09VIV@000000oooo0?l0oooo1`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00003
0?ooo`000000oooo0080cLg=00<0VIVI0000003oool0o`3oool70?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o0?ooo`L0
oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@03
09VIV@000000oooo0?l0oooo1`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00003
0?ooo`000000oooo0080cLg=00<0VIVI0000003oool0o`3oool70?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o0?ooo`L0
oooo00D000000?ooo`3=cLd0cLg=09VIV@0200000040oooo00000`3oool000000?ooo`020<g=c@03
09VIV@000000oooo0?l0oooo1`3oool01@000000oooo0<g=c@3=cLd0VIVI008000000@3oool00003
0?ooo`000000oooo0080cLg=00<0VIVI0000003oool0o`3oool70?ooo`050000003oool0cLg=0<g=
c@2IVIT00P0000010?ooo`0000<0oooo0000003oool00P3=cLd00`2IVIT000000000003o000000P0
000000@0oooo0<g=c@3=cLd0VIVI0P0000010?ooo`0000<0oooo0000003oool00P3=cLgo09VIV@`0
VIVI0P3=cLd00`2IVIT00000000000010?ooo`0000<0oooo0000003oool0o`3=cLd@0<g=c@0309VI
V@00000000000040oooo00000`3oool000000?ooo`3o0<g=cA00cLg=00<0VIVI0000000000000@3o
ool000030?ooo`000000oooo0?l0oooo403oool00`2IVIT000000?ooo`010?ooo`0000<0oooo0000
00000000o`00000B00000080oooo003o0?oooaL0oooo0000\
\>"], "ItemizedPicture",
  ImageSize->{278, 101},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"firstcalc", "gs:0.4"}],

Cell[CellGroupData[{

Cell[TextData[{
  "Some ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conventions"
}], "Subsubsection",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[TextData[{
  "Built-in functions are capitalized. Arguments to functions are wrapped \
with square brackets.\n",
  StyleBox["Sin[x]", "MB"]
}], "NoteBox",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[TextData[{
  "Each of these represents multiplication:\n",
  StyleBox["a*b  a", "MB"],
  StyleBox["\[SpaceKey]", "KeyboardChars"],
  StyleBox["b  a(b+1)", "MB"],
  "\n",
  StyleBox["2x", "MB"],
  " means ",
  StyleBox["2*x", "MB"],
  "."
}], "NoteBox",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[TextData[{
  "These are standard arithmetic operations:\n",
  StyleBox["2+3\n2-3\n2/3\n2^3", "MB"]
}], "NoteBox",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[TextData[{
  "Uppercase and lowercase letters are recognized as different characters. \
Lists are wrapped with curly brackets.\n",
  StyleBox["{a, b, B}", "MB"]
}], "NoteBox",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[TextData[{
  "Built-in symbols are capitalized. Commas are used to separate arguments. A \
semicolon suppresses output, but the command is still evaluated.\n",
  StyleBox["N[Pi, 50];", "MB"]
}], "NoteBox",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[TextData[{
  "Variables are usually lowercased. Entire words can be used.\n",
  StyleBox["x = 5\nxvalue = 3", "MB"]
}], "NoteBox",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[TextData[{
  StyleBox["Integrate", "MR"],
  " is just one of over a thousand built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions."
}], "Text",
  PageBreakAbove->True,
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[TextData[{
  StyleBox["Plot3D", "MR"],
  " produces a three-dimensional plot."
}], "Text",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell["Graphics appear directly in your notebook.", "Text",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "PictureGroup",
        ImageSize->{54, 13},
        ImageMargins->{{0, 0}, {0, 0}},
        ImageRegion->{{0, 1}, {0, 1}}],
      ButtonFunction:>(FrontEndExecute[ {
          FrontEnd`SelectionMove[ 
            FrontEnd`SelectedNotebook[ ], All, ButtonCell], 
          FrontEndToken[ "OpenCloseGroup"]}]&),
      Active->True,
      ButtonFrame->"None"]], "OpenCloseItemizedPicture",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000790001UR000`400?l00000o`00003oooooooo:
ooooo`000oooooooo`000<Ko00000Oooool00003ooooool0003o00000?oo0000a_l00001ooooo`00
00?oooooo`000?o=cLd0oonIVIW1oiVIV@;ocLg=00?oVIVIo`000?l000000Oooool00003ooooool0
003ooooo0?oocLg=`oo=cLd00onIVIWo0000o`000001ooooo`0000?oooooo`000?ooool0ooo=cLg3
olg=c@03oiVIVOl0003o0000007ooooo00000ooooooo0000ooooo`02olg=cOoooooo_oooool2olg=
c@03oiVIVOl0003o0000007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003o00000?oo
0000^ol000001?oooooocLg=olg=cOnIVIT2o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003
ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05o`000?oooooocLg=olg=
cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3ooooook[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003
ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05o`000?oooooocLg=olg=
cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3ooooook[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003
ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05o`000?oooooocLg=olg=
cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3ooooook[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003
ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonRooooo`Go003o0_ooool5o`00o`co
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo07kooooo1?l0003oooooobCooooo00?o003oooooooooool01?ooool00ol00?oo
ooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?oo
ool00_o=cLd00onIVIWo0000ooooo`0Hooooo`;o003o1_ooool2o`00oegooooo00?o0000oooooooo
ool0oooooolTooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003o
ooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?oo
ool06?ooool00ol00?ooooooooooo`06ooooo`03o`00oooooooooooo05_ooooo00?o0000oooooooo
ool0oooooolTooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003o
ooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?oo
ool02oooool2o`00o`Cooooo00?o003oooooool00?l00_ooool00ol00?ooooooo`00o`03ooooo`;o
003o0oooool00ol00?ooooooooooo`0Eooooo`Co00001?ooool2o`000004ooooool0003o0000oooo
o`Co00000oooool4o`0000Cooooo0_l000000ooooooo0000o`000002ooooo`?o00001?ooool3o`00
00Cooooo1?l00002ooooo`Co00001?ooool2o`000006ooooool0003o0000ooooool0003ooooo0_l0
0002ooooo`?o000000Goooooo`000?l0003o0000ooooo`05o`0000?ooooo0ol00003ooooo`Co0000
ooooool7ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003ooooo
olg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0
2_ooool01?l00?ooooooooooool00?l2ooooo`06o`00oooooooo003oo`00oooooooo003o0_ooool0
1?l00?ooooooooooool00?l2ooooo`05o`00ooooooooooooo`00ooooool01?l00?lBooooo`05o`00
0?ooooooooooooooool000000_ooool00ol0003oooooooooo`02o`0000?ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;o00000_ooool01Ol0003o
oooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooo
ooooooooool000000oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;o00000_oo
ool2o`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooooooooooo
ool00000ooooool6ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0
003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`00
0?ooool02Oooool00ol00?ooooooooooo`02ooooo`03o`00oooooooo003o00;ooooo00?o003ooooo
ool00?l00_ooool00ol00?ooooooooooo`03ooooo`04o`00ooooooooooooo`00o`kooooo0ol0000:
ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000006ooooo`03o`00
0?oooooooooo00?ooooo00Oo0000ooooooooooooooooo`000?oooooo000000Kooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000001Oooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`00
0003ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00000:ooooo`;o0000
1_ooool3o`000?cooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`09ooooo`03o`00oooooooooooo00;ooooo00?o003oooooool00?l00_ooool00ol00?oooooo
o`00o`02ooooo`03o`00oooooooooooo00?ooooo00Go003ooooooooooooo003oooooo`04o`00o`Wo
oooo0ol00008ooooo`?o00000_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`04ooooo`Co000000?oooooo`000?ooool01Oooool6o`00
0004ooooool0003oooooooooo`Co00000_ooool00ol0003oooooooooo`04ooooo`Co00000_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool00_ooool0
1Ol0003ooooooooooooooooo000000Sooooo0_l00008ooooo`?o0000o?ooool00ol00?oooooooooo
o`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo
00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo00Wooooo00?o003oooooooooool00_oo
ool00ol00?ooooooo`00o`02ooooo`06o`00oooooooo003oo`00oooooooo003o0_ooool3o`00o`?o
oooo00?o003oooooooooool05Oooool3o`0000Cooooo00Go0000ooooooooooooooooo`000003oooo
o`;o00001Oooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000
oooooooooooo00000oooool00ol0003oooooo`000008ooooo`;o00002?ooool00ol0003ooooooooo
o`02o`0000;ooooo00?o0000ooooooooool00_l00002ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooooooo
ooooo`00003oooooo`?ooooo1?l00?l6ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=
cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo00[o
oooo00Co003ooooooooooooo003o1oooool01?l00?ooooooooooool00?l2ooooo`03o`00oooooooo
oooo00?ooooo00?o003oooooooooool05Oooool00ol0003oooooooooo`03ooooo`;o00000_ooool2
o`0000;ooooo0_l000000ooooooo0000o`000002ooooo`Go00000_ooool4o`0000Cooooo1?l00003
ooooo`?o00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o000000?ooooo
o`000?l000000_ooool4o`0000;ooooo0_l000000ooooooo0000o`000003ooooo`04o`000?oooooo
0000o`0000?ooooo0ol00005ooooo`Co00000oooool4o`000?oooooo1_ooool00ol00?oooooooooo
o`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo
00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo00_ooooo0_l00?l;ooooo`;o003o00?o
ooooo`00ool00?l00_l00?l00ooooooo003oo`00o`0Gooooo`05o`000?ooooooooooooooool00000
4Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00;o00005oooool00ol0003ooooo
ooooo`3ooooooacooooo0_l00?l6ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgo
cLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo03[ooooo
1?l0000Booooo`?o00006?ooool2o`000003ooooool0003ooooo01Gooooo0_l00008ooooo`03o`00
0?oooooooooo0?oooooo4_ooool00ol00?ooooooo`00o`06ooooo`03o`00oooooooooooo00[ooooo
00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVI
VOl0003ooooo0?ooooooXoooool01?l00?ooooooooooool00?l6ooooo`03o`00oooooooooooo00[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo0?ooooooX_ooool01Ol00?oooooooooooooooooo003o00Kooooo00?o003ooooo
ooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo
00;ocLg=00?oVIVIo`000?ooool0oooooonQooooo`Ko003o1_ooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`3oooooojgooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgo
VIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooon]oooo
o`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooo
oooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0?oooooo[Oooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`3oooooojgooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgo
VIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooon]oooo
o`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooo
oooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0?oooooo[Oooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`3oooooojgooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgo
VIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooon]oooo
o`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooo
oooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0?oooooo[Oooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`3ooooooj;ooooo1Ol00?l6ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
0?ooooooY_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
0?ooooooY_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
0?ooooooY_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
0?ooooooY_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
0?ooooooY_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
0?ooooooY_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
0?ooooooY_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
0?ooooooY_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
0?gooooo0_l0002Vooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0
003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`00
0?ooool0n_ooool3o`000003ooooool0003ooooo0:Gooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`3Gooooo`Go00007?ooool2o`0000Cooooo0_l0002Uoooo
o`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgo
VIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0f?ooool01?l0
003oooooooooool0000Iooooo`?o00001_ooool00ol0003oooooo`00002Tooooo`03o`00oooooooo
oooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Ooo
ool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0fOooool00ol0003oooooooooo`0F
ooooo`?o00002Oooool00ol0003oooooo`00002Tooooo`03o`00oooooooooooo00Cooooo00?o003o
ooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003o
oooo00;ocLg=00?oVIVIo`000?ooool0f_ooool00ol0003oooooooooo`0Cooooo`;o00003?ooool0
1?l0003oooooooooool0002Sooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool0eoooool01Ol0003ooooooooooooooooo0000017ooooo0ol0000>ooooo`05o`00
0?ooooooooooooooool00000X_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo0=Oooooo00Go0000ooooooooooooooooo`00000?ooooo`;o00000_ooool00ol0
003oooooooooo`0<ooooo`05o`000?ooooooooooooooool00000X_ooool00ol00?ooooooooooo`04
ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo0000
0ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0=Sooooo0ol0000=ooooo`?o00002_ooool3
o`0000Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2Oooooo`03o`00oooooooo
oooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Ooo
ool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0i_ooool2o`0000[ooooo0ol00003
oj7Lo003o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`2N
ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=
cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0hoooool3
o`0000Wooooo0ol00007oj7Lo003o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`2Nooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool0
1Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVI
o`000?ooool0hOooool2o`0000_ooooo0_l00009oj7Lo0?o00000oooool00ol0003oooooooooo`03
ooooo`;o0000W_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000
ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003o
oooo0=kooooo0ol0000=ooooo`03o`000?obm;Oo000000GoXMcl0ol000000onXao3o0000o`9Uf@02
o`000003ooooool0003ooooo00Cooooo0_l0002Nooooo`03o`00oooooooooooo00Cooooo00?o003o
ooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003o
oooo00;ocLg=00?oVIVIo`000?ooool0foooool4o`0000kooooo00Ko0000oo;d]oobm;Ool_Bgo`00
0?nQg?`3o`0000GoZ<O`00?o0000o`9UfOl000000ol00005ooooo`03o`000?oooooooooo09cooooo
00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnI
VIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3Iooooo`;o0000
1?ooool00ol0003oooooooooo`0;ooooo`03o`000?obm;Ool_Bg00;ol_Bg00?o0000ojS7l?nXao00
1onXao001Ol0003o0VGIo`000?l0003o01N>00;o00001?ooool00ol0003oooooooooo`2Kooooo`03
o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0e_ooool3o`0001?o
oooo00?o0000oo;d]oobm;L00oobm;L00ol0003oZ<O`ojS7l008ojS7l003o`000?l2IMWo000000Go
00000_ooool00ol0003oooooooooo`2Kooooo`03o`00oooooooooooo00Cooooo00?o003ooooooooo
ool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;o
cLg=00?oVIVIo`000?ooool0e?ooool2o`0001Kooooo00?o0000oo;d]oobm;L00_obm;L00ol0003o
jOC>o`000009ojS7l0Ko00000_l2IMT01?l0003oooooooooool0002Looooo`03o`00oooooooooooo
00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool0
0003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0dOooool3o`0001Oooooo00?o0000oo;d
]oobm;L00_obm;L01Ol0003ojOC>onWdc_oYm<ko000000GoZ<O`0ol000000onX/n3o0000o`000003
ofjFi`Go000000?oooooo`000?ooool03?ooool5o`0008Wooooo00?o003oooooooooool01?ooool0
0ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?ooooo
o`000?ooool00_o=cLd00onIVIWo0000ooooo`3?ooooo`;o00006Oooool00ol0003ol_Bgoo;d]`02
oo;d]`03o`000?oYm<kojOC>00?ojOC>00?o0000ojS7l?l000000_l00005ojRch003o`000?m^U^Oo
KYKW00KoKYKW0_l0000>ooooo`04o`000?ooooooooooo`0008Wooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3<ooooo`Co00006_ooool01Ol0003ol_Bgoo;d
]oobm;Oo000000KojOC>0_l00008ojRch0;o00002?m^U^L2o`0000Kooooo1Ol00003ooooo`03o`00
0?oooooooooo08Wooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`3:ooooo`;o00007Oooool00ol0003ol_Bgoo;d]`02oo;d]`03o`000?oYm<kojOC>00?ojOC>
00?o0000om;WiOl000002?nX/n02o`0000OoKYKW1?l0000>ooooo`03o`000?oooooooooo08Sooooo
00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnI
VIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`37ooooo`?o0000
7oooool01Ol0003ol_Bgoo;d]oobm;Oo000000GojOC>00Go0000om;WiOoBinGod^OUo`000007ojRc
h003o`000?nX/n3o000000;oKYKW1?l00002ojBSe0;o00002oooool01Ol0003ooooooooooooooooo
000008Wooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooo
cLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`34
ooooo`?o00008Oooool01Ol0003ol_Bgoo;d]oobm;Oo000000CojOC>0_l00005om;Wi@03o`000?nX
/n3oZ;?P00CoZ;?P00?o0000ojRch?l000000_l00007ojBSe0;o00002_ooool01Ol0003ooooooooo
oooooooo000008Wooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`32ooooo`;o00009?ooool01?l0003ol_Bgoo;d]ol00004onWdcP03o`000?oBinGod^OU00Go
d^OU00?o0000ojRch?nX/n000onX/n03o`000003ojJSdol0003oY:?D00SoY:?D0_l0000:ooooo`?o
0000R_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=
cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0;oo
oooo0ol0000Uooooo`Ko00000_oYm<h00ol0003od^OUom;Wi@07om;Wi@03o`000?nX/n3o000000;o
000000?oYZ?Co`000?nVXm<00_nVXm<00ol0003oY:?DojBSe006ojBSe0;o0000Uoooool00ol00?oo
ooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00
007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo09cooooo0_l0000Oooooo`;o
000000?oooooo`000?ooool09Oooool01?l0003ooMn9oogOROl00002oocRSP?o00002OoBinD2o`00
00GoYZ?C00Co0000ojJSdonVXm?o00001onTXm@01?l0003o^jC2o`000?l0002Fooooo`03o`00oooo
oooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o0000
0Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0Voooool01?l0003ooooooooo
ool0000Kooooo`?o0000:Oooool01Ol0003ooMn9oogOROomghWo000000?oo>:>00?o0000oo_WVOl0
00001OoBinD3o`000003ojK5kol0003oYZ?C00CoYZ?C00Go0000ojJSdonVXm?oYZ?Co`000005ojBS
e004o`000?nkY<;o^jC2ok^T`P;o0000UOooool00ol00?ooooooooooo`04ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo09_ooooo00Co0000oooooooooooo00006Oooool2o`0002cooooo00Co
0000oogOROomghWo00000oolhXh01_l0003onnNIoo_WVOokiiWo0000om;Wi@?o00001OnVaNl00ol0
003oYZ?CojJSd`02ojJSd`05o`000?nVXm?oYZ?CojJSdol000001?nTXm@00ol0003o^jC2ok^T`P03
ok^T`P03o`000?oooooooooo09?ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:
ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd0
0onIVIWo0000ooooo`2Kooooo`04o`000?ooooooooooo`0001Kooooo0ol0000^ooooo`04o`000?om
ghWooMn9o`0000?oo>:>00?o0000oo_WVOokiiT00_okiiT00ol0003oY/G_ojK5k`06ojK5k`03o`00
0?nVXm?oYZ?C00;oYZ?C00?o0000ojJSdonVXm<00_nVXm<01?l0003oY:?DojBSe?l00006ok^T`P;o
0000U?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=
cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo09_o
oooo00Co0000oooooooooooo00005?ooool2o`00033ooooo00Go0000oogOROomghWooMn9o`000003
oocRSP03o`000?okiiWonnNI00;onnNI00?o0000ojK5konVaNl01onVaNl01Ol0003oYZ?CojJSdonV
Xm?o000000CoYZ?C00?o0000ojBSe?l000002?nkY<82o`0009?ooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`2Kooooo`04o`000?ooooooooooo`00017ooooo
0ol0000booooo`04o`000?omghWooMn9o`0000?oo>:>00?o0000oo_WVOokiiT00_okiiT00ol0003o
n>j/o`000008ojK5k`05o`000?nVXm?oYZ?CojJSdol000001?nVXm<2o`0000[o^jC200?o0000oooo
ooooool0TOooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
09cooooo0_l0000?ooooo`?o000000?oooooo`000?ooool0<_ooool01?l0003ooMn9oogOROl00003
oocRSP03o`000?okiiWonnNI00;onnNI00Co0000ooS^[?ohkZco00001onVaNl01Ol0003oYZ?CojJS
donVXm?o000000;oYZ?C0_l000000onTV<Wo0000ok^T`P09ok^T`P;o0000T_ooool00ol00?oooooo
ooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007o
oooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0:_ooooo0_l0000gooooo`05o`00
0?omghWooMn9oogOROl000000oolhXh01Ol0003onnNIoo_WVOokiiWo000000Con>j/00?o0000ojK5
konVaNl01OnVaNl00ol0003oYZ?CojJSd`03o`0000CoY9S900?o0000ok^T`_nkY<801_nkY<801?l0
003oajBeo`000?l0002Aooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool0
1Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVI
o`000?ooool0Z?ooool3o`0003Wooooo00Co0000oogOROomghWo00000oolhXh00ol0003onnNIoo_W
V@02oo_WV@03o`000?ohkZcon>j/00?on>j/1Ol00002ojK5k`04o`000?nVXm?o0000o`0000KoY9S9
00?o0000ok^T`_nkY<801OnkY<800ol0003oajBeolNT]@03o`00093ooooo00?o003oooooooooool0
1?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`00
00?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`2Vooooo`;o00002?ooool5o`0002oooooo
00Co0000oogOROomghWo00000oolhXh01Ol0003onnNIoo_WVOokiiWo000000Kon>j/00?o0000og2F
i_m`U^H00_m`U^H4o`000003ojBHbOl0003oY9S900GoY9S900?o0000ok^T`_nkY<801OnkY<801?l0
003oajBeolNT]Oo7Y;D2o`00093ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:
ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd0
0onIVIWo0000ooooo`2Sooooo`?o00002_ooool01Ol0003ohO;Jo`000?l0003oBZki00Ko0000:?oo
ool01Ol0003ooMn9oogOROomghWo000000;oo>:>00?o0000oo_WVOokiiT00_okiiT00ol0003on>j/
ooS^[003ooS^[003o`000?o/l/_o000000KoL9KV00?o0000ojBHbOl000001onTV<T00ol0003o^jC2
ok^T`P03ok^T`P03o`000?o7Y;GoajBe00;oajBe00?o0000ooooool00000Soooool00ol00?oooooo
ooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007o
oooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0:7ooooo0_l0000<ooooo`03o`00
0?oQl][ohO;J00;ohO;J00Go0000odZ^nOm:[_WoBZkio`000002om1D00?o00009Oooool01?l0003o
oMn9oogOROl00003oocRSP05o`000?okiiWonnNIoo_WVOl000001OohkZ`01Ol0003ok?;;oncbboo/
l/_o000000KoL9KV0_l00007ojBHb@03o`000?nkY<;o^jC200;o^jC200?o0000olNT]Oo7Y;D01?o7
Y;D2o`0008oooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oo
oooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000oooo
o`2Nooooo`?o00000_ooool00ol0003oooooooooo`08ooooo`03o`000?oQl][ohO;J00?ohO;J1_l0
0002om1D0003o`000?n_:`3o000002Cooooo00Co0000oogOROomghWo00000oolhXh01Ol0003onnNI
oo_WVOokiiWo000000Con>j/00?o0000oncbboo/l//00_o/l//00ol0003oL9KVog2FiP04og2FiP;o
00002?nTV<T01?l0003o^jC2ok^T`_l00007olNT]@03o`000?oooooo000008kooooo00?o003ooooo
ooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001
ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`2Kooooo`?o00003oooool00ol0
003ohO;Jon7bfP03on7bfP03o`000?o@i>Ko000000?oRKKc00Oo0000om1D0?o@E03od5@0o`000?n_
:`3o000002;ooooo00Go0000oogOROomghWooMn9o`000002oocRSP03o`000?okiiWonnNI00;onnNI
00Go0000ooS^[?ohkZcon>j/o`000006oncbb`03o`000?m`U^KoL9KV00CoL9KV00?o0000ojBHbOnT
V<T01_nTV<T01?l0003o^jC2ok^T`_l00008olNT]@;o0000S_ooool00ol00?ooooooooooo`04oooo
o`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooo
oooo0000ooooo`02olg=c@03oiVIVOl0003ooooo09Wooooo0_l0000Aooooo`03o`000?oQl][ohO;J
00?ohO;J00Go0000om3Ti_o@i>Kod>CVo`000003ohVfl`07o`000?o@E03od5@0om1D0?l0003o[b/0
o`00000Qooooo`04o`000?omghWooMn9o`0000?oo>:>00Go0000oo_WVOokiiWonnNIo`000004ooS^
[003o`000?o/l/_ok?;;00Cok?;;0ol00004og2FiP03o`000?nTV<WoY9S900KoY9S900?o0000ok^T
`_l000002Oo7Y;D00ol0003oooooo`00002=ooooo`03o`00oooooooooooo00Cooooo00?o003ooooo
ooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo
00;ocLg=00?oVIVIo`000?ooool0U_ooool3o`0001;ooooo00?o0000on7bf_oQl]X00_oQl]X2o`00
00God>CV00Go0000ohVflon9]_?oRKKco`000002om1D0003o`000?n_:`3o[b/000;o00007oooool0
1?l0003ooMn9oogOROl00003oocRSP05o`000?okiiWonnNIoo_WVOl000000oohkZ`00ol0003ok?;;
oncbb`04oncbb`04o`000?o4i>oo0000od9Yd`;o00000_m`U^H00ol0003oY9S9ojBHb@06ojBHb@;o
00002Oo7Y;D01Ol0003ocZB]o`000?oooooo000008cooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`2Dooooo`;o00005?ooool00ol0003ohO;Jon7bfP02on7b
fP03o`000?o@i>Kod>CV00Kod>CV00Co0000ohVflon9]_?o00000oo@E0001Ol0003o[b/0ojl[0?n_
:`3o000001gooooo00Go0000oogOROomghWooMn9o`000002oocRSP05o`000?okiiWonnNIoo_WVOl0
00000oohkZ`00ol0003ok?;;oncbb`03oncbb`;o00000oo4i>l00ol0003o@VWCod9Yd`04o`0000Co
Y9S90ol000000onRTL;o0000olNT]@08olNT]@05o`000?o>Y:go0000ooooool00000S?ooool00ol0
0?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02
o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo097ooooo1?l0000Doooo
o`?o00000_oQl]X00ol0003od>CVom3TiP07om3TiP?o000000?oY:gMo`000?o@E0000_o@E0001?l0
003o[b/0ojl[0?n_:`02o`0001_ooooo00Co0000oogOROomghWo00000oolhXh01Ol0003onnNIoo_W
VOokiiWo000000;on>j/00?o0000oncbboo/l//00_o/l//2o`0000Goa>C_00?o0000od9Ydom2JM<0
0_m2JM<2o`000004ojBHbOl0003o0000o`0000GoXY7200?o0000olNT]Oo7Y;D01Oo7Y;D01?l0003o
cZB]oljT[Ol00002ooooo`03o`000?oooooooooo08Wooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`2?ooooo`;o00006?ooool00ol0003oo>:QoocRX@03o`00
00Ood>CV0_l000001Onebn_o0000ojB]gOnT[Mgo000000Cod5@000?o0000ojl[0?n_:`000_n_:`00
0ol0003oooooooooo`0Hooooo`04o`000?omghWooMn9o`0000?oo>:>2Ol00002oncbb`03o`000?o4
i>ooa>C_00Goa>C_00?o0000od9Ydom2JM<00om2JM<2o`0000SoXY7200?o0000olNT]Oo7Y;D01Oo7
Y;D01Ol0003ocZB]oljT[Oo>Y:go000000;ooooo00?o0000ooooooooool0R?ooool00ol00?oooooo
ooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007o
oooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo08cooooo0ol0000Iooooo`03o`00
0?olhZ7oo>:Q00;oo>:Q00Co0000oo[UZ_l0003o00001?o@i>H00ol0003o]L_[okG;j`02okG;j`04
o`000?nT[MgoY:gMo`0000?od5@000?o0000ojl[0?n_:`000on_:`000ol0003oooooooooo`0Foooo
o`06o`000?omghWooMn9oogOROl0003oo>:>0ol00002oo[VT@04o`000?oij9?onNRCo`0000;onNbK
0ol00008olCTk`03o`000?m2JM?o@VWC00;o@VWC0_l00008oj:A`P03o`000?o7Y;GoajBe00CoajBe
00?o0000oljT[Oo>Y:d00_o>Y:d00ol0003oooooooooo`02o`0008Wooooo00?o003oooooooooool0
1?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`00
00?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`2:ooooo`;o00007?ooool01Ol0003oo>:Q
oocRXOolhZ7o000000Con^FZ00Co0000om3Ti_l0003o00001Onebn/01Ol0003oY:gMojB]gOnT[Mgo
000000?od5@000Co0000ojl[0?n_:`3o[b/01Ol0000Eooooo`03o`000?omghWooMn900?o000000Go
nnJDo`000?ojiY7on^JAo`000002ooWXT`03o`000?oik9_onNbK00;onNbK00?o0000ooK`Zol00000
1oo4i>l00ol0003o@VWCod9Yd`02od9Yd`03o`000?m2JM?o000000SoXY7200?o0000olNT]Oo7Y;D0
0_o7Y;D00ol0003ocZB]oljT[@03oljT[@05o`000?ooooooooooooooool00000ROooool00ol00?oo
ooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00
007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo08Oooooo0ol0000Mooooo`03
o`000?olhZ7oo>:Q00;oo>:Q00?o0000oo[UZ_ojiJX00oojiJX00ol0003o]L_[okG;j`06okG;j`04
o`000?nT[MgoY:gMo`0000;od5@01Ol00002omi^:P03o`000?oLJ1Wog6PI00?o00004_ooool01?l0
003ooMn9o`000?l00002oo_VU005o`000?ojiY7on^JAoo[VTOl000000_oij9<01Ol0003onNbKooW/
Vooik9_o000000?om_2[00?o0000olCTkoo4i>l01?o4i>l00ol0003o@VWCod9Yd`02od9Yd`03o`00
0?m2JM?o000000SoXY7200?o0000olNT]Oo7Y;D00_o7Y;D00ol0003ocZB]oljT[@04oljT[@05o`00
0?ooooooooooooooool00000R?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo06;ooooo1Ol0000Mooooo`?o00008?ooool01Ol0003oo>:QoocRXOolhZ7o0000
00Kon^FZ0_l00008okG;j`03o`000?nT[MgoY:gM00;o00000_oLKc000ol0003ogVhZomi^:P03omi^
:P05o`000?oLJ1Wog6PIo`000?oAE`000_l0000?ooooo`?o000000Goo>NKo`000?okiYConnJDo`00
0003oo[VT@04o`000?oij9?onNRCo`0000?onNbK00?o0000ooK`Zoofl:/00_ofl:/9o`0000;o@VWC
00?o0000od9Ydol000002?nRTL801Ol0003oajBeolNT]Oo7Y;Go000000OocZB]00Go0000oooooooo
ooooooooo`000028ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0
003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`00
0?ooool0Hoooool01?l0003oooooooooool0000Kooooo`;o00000_ooool00ol0003oooooooooo`0N
ooooo`05o`000?olhZ7oo>:QoocRXOl000001OojiJX01?l0003omNViooGY^Ol00007okG;j`04o`00
0?nT[Mgo0000o`0000Cog6l`00?o0000omi^:_oNKRX00_oNKRX01Ol0003og6PIomaX6OoLJ1Wo0000
00;odEL000?o0000ooooooooool03?ooool01?l0003oo>NKoocWVol00003oo_VU004o`000?ojiY7o
n^JAo`0000;onNRC00Go0000ooW/Vooik9_onNbKo`000005ooK`Z`03o`000?m[YoCoJjOd00CoJjOd
00Go0000ob98`?l0003o@VWCo`000002od9Yd`03o`000?nRTL;oXY7200KoXY7200Co0000olNT]Oo7
Y;Go00001oo>Y:d00ol0003oooooooooo`02ooooo`03o`000?oooooooooo08Gooooo00?o003ooooo
ooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001
ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1Looooo`Go00000oooool00ol0
003oooooooooo`0Hooooo`?o00009?ooool01Ol0003oo>:QoocRXOolhZ7o000000Gon^FZ00?o0000
ooGY^OoejKT00_oejKT00ol0003o]L_[okG;j`02okG;j`Co00000_n`YLd01Ol0003og6l`oma_<?oL
Kc3o000000GogVhZ00Ko0000omaX6OoLJ1Wog6PIo`000?oAE`02o`0000gooooo00Co0000oocWVool
ii_o00000_okiY@01Ol0003on^JAoo[VTOojiY7o000000;onNRC00Go0000ooW/Vooik9_onNbKo`00
0004ooK`Z`03o`000?o_ll?o000000KoJjOd00Co0000ob98`?l0003o00000_m2JM<00ol0003oXY72
oj:A`P06oj:A`P03o`000?o7Y;Go000000OocZB]00?o0000om>UZ?l000001?ooool00ol0003ooooo
ooooo`24ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003ooooo
olg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0
IOooool00ol0003oooooooooo`0Eooooo`;o00009oooool01Ol0003oo>:QoocRXOolhZ7o000000Go
n^FZ00?o0000ooGY^OoejKT00ooejKT4o`0000?oU:_V00Co0000ok2UcOn`YLgo00001?oLKc000ol0
003ogVhZomi^:P02omi^:P05o`000?oLJ1Wog6PIomaX6Ol000000_oAE`02o`0000_ooooo00Go0000
oocWVoolii_oo>NKo`000002oo_VU004o`000?ojiY7on^JAo`0000;onNRC00Go0000ooW/Vooik9_o
nNbKo`000004ooK`Z`05o`000?o_ll?oko?3onoc`ol000001Om[Yo@00ol0003o8TS0ob98`002o`00
0003od9Ydol0003oXY7200OoXY7200?o0000olNT]Ol000001oo>Y:d00ol0003odjFXo`000004oooo
o`03o`000?oooooooooo08Cooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`1Rooooo`05o`000?ooooooooooooooool000004oooool3o`0002Sooooo00Go0000
oocRXOolhZ7oo>:Qo`000005oo[UZP03o`000?oejKWomNVi00ComNVi00?o0000oiB[i_nDZnH01OnD
ZnH00ol0003o/:G=o`000004oma_<003o`000?oNKR[ogVhZ00;ogVhZ00?o0000omaX6OoLJ1T00_oL
J1T00ol0003odEL0om5G0002o`0000[ooooo00Co0000oocWVoolii_o00000_okiY@01Ol0003on^JA
oo[VTOojiY7o000000;onNRC00Go0000ooW/Vooik9_onNbKo`000003ooK`Z`03o`000?o_ll?oko?3
00?oko?30_l00004of^Wm007o`000?lRB<3o0000ob98`?l0003o@VWCo`000007oj:A`P;o00002?o>
Y:d00ol0003odjFXo`000005ooooo`03o`000?oooooooooo08?ooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1Rooooo`05o`000?ooooooooooooooool00000
4Oooool2o`0002_ooooo00Go0000oocRXOolhZ7oo>:Qo`000005oo[UZP03o`000?oejKWomNVi00?o
mNVi00?o0000onS[d?l000001_nDZnH01?l0003o/:G=ok2UcOl00004oma_<003o`000?oNKR[ogVhZ
00;ogVhZ00Go0000omaX6OoLJ1Wog6PIo`000003om5G00?o00002?ooool01?l0003oo>NKoocWVol0
0002oo_VU004o`000?ojiY7on^JAo`0000;onNRC00Go0000ooW/Vooik9_onNbKo`000003ooK`Z`03
o`000?o_ll?oko?300?oko?30_l000000ol;E<oo0000of^Wm002of^Wm003o`000?lRB<3o000000;o
8TS00_l00004oj:A`P?o000000?oXHbno`000?o>Y:d01_o>Y:d01Ol0003odjFXom>UZ?oCYJSo0000
00Gooooo00?o0000ooooooooool0P_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo
00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=
c@03oiVIVOl0003ooooo06?ooooo0ol0000?ooooo`?o000000?oooooo`000?ooool0:Oooool00ol0
003oo>:QoocRX@02oocRX@03o`000?ojiJ[on^FZ00;on^FZ00?o0000ooGY^OoejKT00ooejKT01Ol0
003oj>_@onS[d?oXjm3o000000KoU:_V00?o0000ok2UcOl000001?oLKc000ol0003ogVhZomi^:P02
omi^:P03o`000?oLJ1Wog6PI00;og6PI00Oo0000om5G0?oAE`3odEL0o`000?nS8`3o000000Kooooo
00Co0000oocWVoolii_o00000ookiY@01?l0003on^JAoo[VTOl00002ooWXT`05o`000?oik9_onNbK
ooW/Vol000000oofl:/00ol0003oko?3onoc``02onoc``05o`000?oJkN3of^gPo`000?l;E<l00_l0
00001?m[YoCo0000ob98`?l00003ob98`003o`000?nRTL;o000000;o00001OnQS;h00ol0003ocZB]
oljT[@04oljT[@05o`000?oCYJSodjFXom>UZ?l000001Oooool00ol0003oooooooooo`22ooooo`03
o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0Loooool2o`0002oo
oooo00Go0000oocRXOolhZ7oo>:Qo`000004oo[UZP03o`000?oejKWomNVi00?omNVi00?o0000onS[
d?oXjm000_oXjm000ol0003oU:_VoiB[iP04oiB[iP03o`000?n`YLgo000000Gog6l`00?o0000omi^
:_oNKRX00_oNKRX00ol0003og6PIomaX6@02omaX6@06o`000?oAE`3odEL0om5G0?l0003oXb<00_l0
0004ooooo`04o`000?olii_oo>NKo`0000;onnJD00Go0000oo[VTOojiY7on^JAo`000002ooWXT`04
o`000?oik9_onNbKo`0000?om_2[00?o0000onoc`oo_ll<00_o_ll<00ol0003of^gPom[]h002om[]
h003o`000?l;E<oo2eC?00Co00001?lRB<000ol0003oXHbnoj6<_P06oj6<_P03o`000?o>Y:gocZB]
00?ocZB]00?o0000om>UZ?oCYJP00_oCYJP00ol0003oooooooooo`04ooooo`;o0000P_ooool00ol0
0?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02
o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo073ooooo0ol0000aoooo
o`05o`000?olhZ7oo>:QoocRXOl000001?ojiJX00ol0003omNViooGY^@02ooGY^@03o`000?oXjm3o
j>_@00Coj>_@00?o0000oiB[i_nDZnH01?nDZnH00ol0003o/:G=o`000004oma_<003o`000?oNKR[o
gVhZ00;ogVhZ00?o0000omaX6OoLJ1T00_oLJ1T00ol0003odEL0om5G0002om5G0004o`000?nS8`3o
Xb<0o`0000;ooooo00Go0000oocWVoolii_oo>NKo`000002oo_VU004o`000?ojiY7on^JAo`0000;o
nNRC00Go0000ooW/Vooik9_onNbKo`000002ooK`Z`03o`000?o_ll?oko?300;oko?300?o0000om[]
h?oJkN000ooJkN000ol0003o2eC?o`]Dc`02o`]Dc`;o00001?lRB<000ol0003oXHbnoj6<_P06oj6<
_P03o`000?o>Y:gocZB]00?ocZB]00?o0000om>UZ?oCYJP00ooCYJP00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo083ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`1]ooooo`?o0000<oooool01Ol0003oo>:QoocRXOolhZ7o000000Con^FZ00?o0000
ooGY^OoejKT00ooejKT00ol0003oj>_@onS[d004onS[d0Ko000000CoU:_Vo`000?n`YLgo00001?oL
Kc000ol0003ogVhZomi^:P03omi^:P03o`000?oLJ1Wog6PI00;og6PI00?o0000om5G0?oAE`000_oA
E`001_l0003oXb<0oj<S0?l0003oooooo`0000;oo>NK00Co0000oo_VU?okiYCo00000oojiY401?l0
003onNRCooWXTol00002ooW/V`04o`000?ofl:_om_2[o`0000Coko?300?o0000om[]h?oJkN001OoJ
kN000ol0003o2eC?o`]Dc`02o`]Dc`03o`000?lRB<3o8TS000?o8TS000?o0000oj6<__nQS;h01_nQ
S;h00ol0003ocZB]oljT[@02oljT[@03o`000?oCYJSodjFX00?odjFX00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`20ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool0Joooool2o`0000Wooooo0ol0000Zooooo`05o`000?olhZ7oo>:QoocRXOl00000
1?ojiJX00ol0003omNViooGY^@02ooGY^@03o`000?oXjm3oj>_@00?oj>_@0_l000000oo1g^ko0000
og>9fP03og>9fP?o000000?o]Yo1o`000?oLKc000ooLKc000ol0003ogVhZomi^:P02omi^:P03o`00
0?oLJ1Wog6PI00;og6PI00?o0000om5G0?oAE`000_oAE`06o`0000;oo>NK00Co0000oo_VU?okiYCo
00000_ojiY401?l0003onNRCooWXTol00003ooW/V`Go00000_o_ll<00ol0003of^gPom[]h006om[]
h0;o00000ol;E<l00ol0003o8TS0ob98`003ob98`003o`000?nQS;koXHbn00KoXHbn00Go0000oljT
[Oo>Y:gocZB]o`000006om>UZ003o`000?oooooooooo00Gooooo00?o0000ooooooooool0Ooooool0
0ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVI
V@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo06Sooooo1?l00008
ooooo`;o00000oo1io43o`0002Kooooo00Go0000oocRXOolhZ7oo>:Qo`000004oo[UZP03o`000?oe
jKWomNVi00;omNVi00?o0000onS[d?oXjm000ooXjm000ol0003o`Mk^ol7NkP02ol7NkP03o`000?mc
RM[oLhWJ00?oLhWJ00?o0000okJO`Ol000001?oLKc000ol0003ogVhZomi^:P02omi^:P03o`000?oL
J1Wog6PI00?og6PI00Ko0000om5G0?l0003o0000oklo2Ol00002okXd0004o`000?olii_oo>NKo`00
00?onnJD00Co0000oo[VTOojiY7o00000_oij9<00ol0003onNbKo`000002o`0000Co]?_N0ol00005
om[]h0?o000000?oZ<gco`000?l;E<l00ol;E<l00ol0003o8TS0ob98`002ob98`003o`000?nQS;ko
XHbn00KoXHbn00Go0000oljT[Oo>Y:gocZB]o`000007om>UZ003o`000?oooooooooo00Gooooo00?o
0000ooooooooool01_ooool2o`0007Kooooo00?o003oooooooooool01?ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`1Vooooo`;o00001?ooool00ol0003oooooooooo`04ooooo`03o`000?o1
io7o`NOa00Go`NOa1?l0000Sooooo`06o`000?olhZ7oo>:QoocRXOl0003on^FZ2_l00002onS[d0;o
00001Oo1g^h00ol0003oLhWJog>9fP04og>9fP;o00001OoLKc000ol0003ogVhZomi^:P02omi^:P03
o`000?oLJ1Wog6PI00;og6PI0_l00004oklo2@03o`000?nj=03o000000;oo>NK00Co0000oo_VU?ok
iYCo00000_ojiY401?l0003onNRCooWXTooij9<4o`0000?o]?_N0_l00003okgdl@03o`000?oJkN3o
000000;o00001OnXcO<01?l0003o2eC?o`]Dcol;E<l2o`0000Co8TS000?o0000oj6<__nQS;h01_nQ
S;h00ol0003ocZB]o`000008om>UZ003o`000?oooooooooo00Gooooo00?o0000ooooooooool01Ooo
ool01?l0003oooooooooool0001eooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool0
2_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=
00?oVIVIo`000?ooool0Hoooool3o`0000_ooooo0_l00007ol7Wl@05o`000?ngdNgo0000o`000?ml
00000ol0000Oooooo`03o`000?olhZ7oo>:Q00Co00000_omgYd00ol0003ooN2NoogPWP02oogPWP03
o`000?olhj?oo>>S00?o00001oo1g^h00ol0003oLhWJog>9fP03og>9fP03o`000?nfWl7o000000Co
g6l`00?o0000omi^:_oNKRX00_oNKRX00ol0003og6PIo`000002o`000003okm14Ol0003o_cl900Co
_cl900Go0000oocWVoolii_oo>NKo`000002oo_VU005o`000?ojiY7on^JAo`000?oij9<01?l00004
okCkgP03o`000?nmm?7o_OCa00?o_OCa0ol00007ojS=l`;o00000_l;E<l00ol0003o3cBco`000003
ob98`003o`000?nQS;koXHbn00KoXHbn00?o0000oljT[Ol000001ooCYJP00ol0003oeZJUo`000007
ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo0000MOooool00ol00?oooooooooo
o`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo
00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo067ooooo0_l0000=ooooo`?o00001Oo1
io42o`0000Co]m7]1ol0000Looooo`?o000000?ooMfNo`000?omgYd00_omgYd00ol0003ooN2NoogP
WP02oogPWP03o`000?olhj?oo>>S00;oo>>S00?o0000ooWV[Ol000001oo1g^h00ol0003oLhWJog>9
fP03og>9fP;o00001OoLKc001?l0003ogVhZomi^:_oNKRX2o`0000Go_d4A00?o0000oklo2Ono?`T0
0_no?`T01?l0003oo>NKoocWVol00002oo_VU004o`000?ojiY7on^JAoo[VT@Go00000ondnmh2o`00
00?o_OCa0ol00003okWNlP03o`000?nXcO?oZ<gc00GoZ<gc0_l000001Ol;E<oo0000o`000?l?=;?o
000000;o8TS000?o0000oj6<__nQS;h01_nQS;h00ol0003ocZB]o`000007om>UZ003o`000?oFYZGo
000000Oooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0001eooooo`03o`00oooo
oooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o0000
0Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0G_ooool3o`0000oooooo00?o
0000ooGS]ooehkL00ol000000oo1io7o0000okOAk@05okOAk@03o`000?oQNT;ohGY200;ohGY200?o
0000on1b;_l000000_l0000Iooooo`04o`000?omgIkooMfNo`0000CooMjM00?o0000oogPW_omh9h0
0_omh9h01Ol0003oo>>SoocSXoolhj?o000000?onNJ]00?o0000ol7Nk_o1g^h01?o1g^h00ol0003o
LhWJog>9fP03og>9fP;o00001OoLKc001_l0003ogVhZo`000?l0003o^S/>o`0000Ko_d4A00Go0000
oklo2Ono?`Wo_cl9o`000002oocWV`05o`000?okiYConnJDo`000?ojiY403?l000000onmm?7o0000
o`000007okWNlP03o`000?nXcO?oZ<gc00CoZ<gc00?o0000o`0IYol000000_l00002o`ld/`04o`00
0?lRB<3o8TS0o`0000OoXHbn0_l00008om>UZ003o`000?oFYZGo000000Sooooo00?o0000oooooooo
ool00oooool01?l0003oooooooooool0001eooooo`03o`00oooooooooooo00Cooooo00?o003ooooo
ooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo
00;ocLg=00?oVIVIo`000?ooool0G?ooool2o`00017ooooo00?o0000ooGS]ooehkL01?oehkL2o`00
00Ko]m7]00?o0000on5j@_oQNT800ooQNT801?l0003oh78^on1b;_oPLRh2o`0001Kooooo00Go0000
oogMW_omgIkooMfNo`000004oogNW@03o`000?omh9kooN2N00;ooN2N00Go0000oocSXoolhj?oo>>S
o`000004ooWV[@Wo00000omcRMX00ol0003o]Yo1o`000004oma_<0;o00001?nj>`h00ol0003o_d4A
okm14@04okm14@03o`000?no?`Wo000000;oo>NK00Co0000oo_VU?okiYConnJD1ol00004obJ4jPGo
00002?nig_84o`0000CoZ<gc1?l00003o`ld/`03o`000?lRB<3o000000GoXHbn0_l000000onQR[_o
0000om>UZ006om>UZ005o`000?oFYZGoeZJUomJVYOl000002?ooool2o`0000?ooooo00Co0000oooo
oooooooo0000MOooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000
ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003o
oooo05Wooooo0ol00002ooooo`03o`000?oooooooooo00kooooo00?o0000ooGS]ooehkL01?oehkL0
0ol0003ol>G2o`000006okOAk@03o`000?oQNT;ohGY200;ohGY200Oo0000on1b;_oPLRkoh78^o`00
0?oCFP3o000001Gooooo00Go0000oogMW_omgIkooMfNo`000003oogNW@03o`000?omh9kooN2N00;o
oN2N00Go0000oocSXoolhj?oo>>So`000005ooWV[@03o`000?ocjkko000000CoIjKe00?o0000oeU^
cOl000000_l000000omcRM[o0000o`000002oma_<0;o000000?o[b/0o`000?nj>`h01?nj>`h00ol0
003o_d4Aokm14@04okm14@;o00000_olii/00ol0003onnJDo`000005o`0000?o/j751?l00005ohJS
i`03o`000?nig_;o^Mkb00;o^Mkb0ol000001?n^`^So0000of:CjOmRTnT5o`000004o`0IYol0003o
2eC?o`0000?o3cBc0_l00003oj6<_P;o00000onQR[/00ol0003odjFXom>UZ005om>UZ005o`000?oF
YZGoeZJUomJVYOl000001oooool2o`0000Gooooo0_l0001fooooo`03o`00oooooooooooo00Cooooo
00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003oooo
ool0003ooooo00;ocLg=00?oVIVIo`000?ooool0E_ooool3o`0001Gooooo00?o0000ooGS]ooehkL0
1?oehkL01Ol0003ol>G2oo3U`_o`iL;o000000;o]m7]1?l00004on5j@P03o`000?oPLRkoh78^00;o
h78^00?o0000om=J0?l000004oooool01Ol0003ooMfNoogMW_omgIko000000CooMjM00?o0000oogP
W_omh9h00_omh9h01Ol0003oo>>SoocSXoolhj?o000000ConNJ]00Go0000oo?[__ocjkkoln^no`00
0004ofNVm@04o`000?mIK/goFFk=oeU^c@?o000000?og6l`o`000?n_:`000on_:`000ol0003o^S/>
okXk3P03okXk3P03o`000?no@A7o_d4A00?o_d4A00Co0000oocWVoolii_oo>NK1_l00005ok>Qa@03
o`000?n6XnOoQZ?W00OoQZ?W00Co0000okWNl_l0003o00001On^`^P00ol0003oHY?Yof:Cj@03of:C
j@Go00001?l?=;<4o`0000KoXHZk00?o0000om>UZ?oCYJP01?oCYJP01Ol0003oeZJUomJVYOoFYZGo
000000Wooooo00?o0000ooooooooool0N_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo05Cooooo0_l0000Hooooo`03o`000?oehkOomN>g00?omN>g00?o0000
oo3U`_o`iL800oo`iL82o`0000?oZKWT00?o0000on5j@_oQNT800ooQNT801Ol0003oh78^on1b;_oP
LRko000000;odeX000?o0000ooooooooool04?ooool01Ol0003ooMfNoogMW_omgIko000000CooMjM
00Go0000oogPW_omh9kooN2No`000004oocSX`03o`000?oiiZgonNJ]00;onNJ]00?o0000oo?[__oc
jkh00_ocjkh01Ol0003oIjKeofNVmOmWY_Go000000GoFFk=0ol00005ojl[0003o`000?nj>`ko^S/>
00?o^S/>00?o0000okm14Ono@A400_no@A400ol0003oo>NKo`000005o`0000Ko/j7500?o0000olNT
]Ol000002?n6XnL2o`0000Oo[/;X00Co0000of:CjOmRTnWoHY?Y1Ol000000ol06JOo0000o`ld/`04
o`ld/`03o`000?nQR[_oXHZk00KoXHZk00?o0000om>UZ?oCYJP00ooCYJP00ol0003oeZJUomJVY@03
omJVY@03o`000?oooooooooo00Oooooo00?o0000ooooooooool0NOooool00ol00?ooooooooooo`04
ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo0000
0ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo057ooooo0ol0000Iooooo`03o`000?oehkOo
mN>g00ComN>g00?o0000oo3U`_o`iL800oo`iL82o`0000CoZKWT00?o0000on5j@_oQNT800_oQNT80
0ol0003oh78^on1b;P02on1b;P04o`000?oCFP3odeX0o`00017ooooo00Go0000oogMW_omgIkooMfN
o`000003oogNW@03o`000?omh9kooN2N00;ooN2N00Go0000oocSXoolhj?oo>>So`000004ooWV[@03
o`000?ocjkkoln^n00Coln^n0_l00002ofNVm@03o`000?mIK/goFFk=00;oFFk=00Co0000okVL^_ni
W;[o00001On_:`000ol0003o^S/>okXk3P02okXk3P03o`000?no@A7o_d4A00;o_d4A0_l000001?nG
k[_o0000o`000?l00007ok>Qa@05o`000?o7Y;GoajBeolNT]Ol000001?n6XnL3o`000003oj^UdOl0
003o[/;X00Oo[/;X0ol00004of:Cj@;o000000?o01VWo`000?l?=;<00ol?=;<00ol0003oXHZkoj6:
^`06oj6:^`03o`000?oCYJSodjFX00?odjFX00?o0000omJVYOoFYZD00ooFYZD00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo07Wooooo00?o003oooooooooool01?ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`1@ooooo`;o00006oooool00ol0003omN>gooGS]`03ooGS]`03o`000?o`
iL;ol>G200?ol>G200Co0000on?Te?oSi=Co00000onY^N@00ol0003ohGY2on5j@P02on5j@P03o`00
0?oPLRkoh78^00;oh78^00Go0000om=J0?oCFP3odeX0o`00000?ooooo`05o`000?omgIkooMfNoogM
W_l000001?omgYd01Ol0003ooN2NoogPW_omh9ko000000Coo>>S00Go0000ooWV[OoiiZgonNJ]o`00
0006oo?[_P;o000000Co04S8o`000?mWY_Go00001OmIK/d01?l0003o^IbjokVL^_l00005ojl[0003
o`000?nj>`ko^S/>00;o^S/>00?o0000okm14Ol000000_l000001OnGk[_o0000o`000?oBYJWo0000
00Ko/j7500?o0000olNT]Oo7Y;D00_o7Y;D00ol0003oQZ?Wo`000002o`0000GoZjGA00?o0000ojk2
j?n^`^P00_n^`^P4o`0000KoHY?Y1?l00005o`ld/`03o`000?nQR[_oXHZk00KoXHZk00?o0000om>U
Z?oCYJP00_oCYJP00ol0003oeZJUomJVY@03omJVY@03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool0N?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo
053ooooo0ol0000Iooooo`03o`000?oehkOomN>g00?omN>g00?o0000oo3U`_o`iL800oo`iL800ol0
003ohnCDon?Te002on?Te004o`000?nY^NCoZKWTo`0000GohGY200?o0000on1b;_oPLRh00_oPLRh0
1Ol0003odeX0om=J0?oCFP3o000000kooooo00Go0000oogMW_omgIkooMfNo`000004oogNW@05o`00
0?omh9kooN2NoogPW_l000000oolhj<00ol0003onNJ]ooWV[@02ooWV[@03o`000?ocjkkoln^n00?o
ln^n00Go0000on7[f?oQjmSo0000o`18b002o`0000GoFFk=00Go0000okVL^_niW;[o^Ibjo`000005
ojl[0004o`000?nj>`ko^S/>okXk3PCo000000?oUnjko`000?l000000ooBYJT00ol0003o/j75ok>Q
a@02ok>Qa@03o`000?o7Y;GoajBe00CoajBe00?o0000oj^UdOn[YM401on[YM44o`0000;o[/;X1?l0
0004of:Cj@;o000000?o01VWo`000?l000001?l?=;<00ol0003oXHZkoj6:^`06oj6:^`05o`000?oC
YJSodjFXom>UZ?l000001ooFYZD00ol0003oooooooooo`08ooooo`03o`000?oooooooooo07Oooooo
00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnI
VIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`18ooooo`?o0000
1Oooool01?l0003oooooooooool0000Gooooo`03o`000?oehkOomN>g00ComN>g00?o0000oo3U`_o`
iL800_o`iL800ol0003ohnCDon?Te004on?Te004o`000?nY^NCoZKWTo`0000CohGY200?o0000on1b
;_oPLRh00_oPLRh00ol0003odeX0om=J0002om=J0003o`000?oooooooooo00[ooooo00?o0000oogM
W_omgIh00_omgIh01Ol0003ooMjMoogNWOomgYgo000000CooN2N00Go0000oocSXoolhj?oo>>So`00
0003ooWV[@03o`000?ocjkkoln^n00?oln^n00Go0000on7[f?oQjmSohN_Ho`000002o`18b0;o0000
1?mIK/d00ol0003o^IbjokVL^P02okVL^P03o`000?n_:`3o[b/000?o[b/00ol000001onUmmCo0000
oiO^^onGk[_o0000olbT/?l000000ooBYJT00ol0003o/j75ok>Qa@02ok>Qa@03o`000?o7Y;GoajBe
00CoajBe00?o0000oj^UdOn[YM401On[YM43o`0000;o[/;X0ol00002oj:Yg003o`000?lVF/oo0000
00CoHY?Y1Ol00003o`ld/`03o`000?nQR[_oXHZk00KoXHZk00Go0000om>UZ?oCYJSodjFXo`000007
omJVY@03o`000?oooooooooo00Sooooo00?o0000ooooooooool0Moooool00ol00?ooooooooooo`04
ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo0000
0ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo04Wooooo00?o0000ooooooooool01?ooool0
1Ol0003ooooooooooooooooo000001Kooooo00?o0000ooGS]ooehkL00ooehkL00ol0003ol>G2oo3U
`P02oo3U`P03o`000?oSi=CohnCD00GohnCD1?l00004on5j@P03o`000?oPLRkoh78^00?oh78^00?o
0000om=J0?oCFP000_oCFP04o`0000Sooooo00Go0000oogMW_omgIkooMfNo`000004oogNW@05o`00
0?omh9kooN2NoogPW_l000000oolhj<00ol0003onNJ]ooWV[@02ooWV[@03o`000?ocjkkoln^n00;o
ln^n00?o0000on7[f?oQjmP00ooQjmP01?l0003o04S8o`18b?l00005oeU^c@03o`000?niW;[o^Ibj
00;o^Ibj00?o0000ojl[0?n_:`000_n_:`000ol0003oYOODojGge004o`000003olbT/?l0003odZFY
00CodZFY00Co0000ok>QaOncXLGo00001_o7Y;D00ol0003odJF/o`000003oj^Ud@?o00000_n[YM43
o`0000KoXZWL00Co0000obIJcol0003o00000_mRTnT2o`000004o`0IYol0003o1RV[o`0000?o3cBc
00?o0000oj6:^onQR[/01_nQR[/01?l0003odjFXom>UZ?l00006omJVY@;o00002oooool00ol0003o
ooooooooo`1fooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003o
ooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?oo
ool0@Oooool5o`0000?ooooo00?o0000ooooooooool00oooool3o`0000?ooooo00?o0000oooooooo
ool04_ooool00ol0003omN>gooGS]`03ooGS]`03o`000?o`iL;ol>G200;ol>G200?o0000on?Te?oS
i=@01?oSi=@2o`000004ol?Jj_l0003oW:?Jo`0000GohGY200?o0000on1b;_oPLRh00_oPLRh01?l0
003odeX0om=J0?oCFP09o`0000Cooooo00Go0000oogMW_omgIkooMfNo`000003oogNW@03o`000?om
h9kooN2N00;ooN2N00Go0000oocSXoolhj?oo>>So`000003ooWV[@03o`000?ocjkkoln^n00;oln^n
00?o0000on7[f?oQjmP01?oQjmP01?l0003o04S8o`18b?l0B<P2o`0000?oFFk=00?o0000okVL^_ni
W;X00oniW;X00ol0003o[b/0o`000005o`0000Coc:B`00?o0000om:UZOoBYJT00ooBYJT00ol0003o
/j75o`000007olNT]@04o`000?oAYJco0000oj^Ud@;o00001?n[YM400ol0003o^Z?1o`000007oj:Y
g004o`000?lVF/oo9U[?obIJc`?o000000Ko002>o`000?l06JOo0000o`HYZol00002o`ld/`03o`00
0?nQR[_oXHZk00KoXHZk00?o0000om>UZ?l000001ooFYZD00ol0003ofJRTo`00000;ooooo`03o`00
0?oooooooooo07Gooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`19ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oehkOomN>g00?omN>g00Go0000oo3U`_o`iL;ol>G2o`000006on?Te003
o`000?o3f^[o`m[Z00;o`m[Z0_l00005on5j@P03o`000?oPLRkoh78^00;oh78^1?l00002omad@`03
o`000?oML3KogG0f00;ogG0f00?o0000omQS6?l000000ol00004oogMWP05o`000?omgYgooMjMoogN
WOl000000oomh9h00ol0003oo>>SoocSX`02oocSX`04o`000?oiiZgonNJ]o`0000Coln^n00?o0000
on7[f?oQjmP01OoQjmP2o`0000;o04S800?o0000odIJ`ol000000_mIK/d00ol0003o^IbjokVL^P03
okVL^PCo000000?o_9Zeo`000?o<Y;001?o<Y;000ol0003odZFYom:UZ@05om:UZ@03o`000?o7Y;Go
ajBe00GoajBe00?o0000om6U[?l000000_l00004oj^Ud@;o00000onjXl400ol0003oXZWLoj:Yg005
oj:Yg003o`000?lVF/oo9U[?00;o9U[?0_l000002?l008ko0000o`000?l0003o1RV[o`000?l?=;?o
00002?nQR[/00ol0003odjFXo`000007omJVY@03o`000?oIZ:Co000000_ooooo0_l0001fooooo`03
o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0BOooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03oooool00ol0003o
mN>gooGS]`03ooGS]`03o`000?o`iL;o000000Go00000_oSi=@2o`0000Go`m[Z00?o0000oibSf_l0
00001?oQNT800ol0003oh78^o`000002o`000003omYdAol0003og7A300Cog7A300?o0000ome`=_oM
L3H00_oML3H01Ol0003of6<HomQS6?oHHaSo000000?ooMfN00?o0000oogNWOomgYd00_omgYd01Ol0
003ooN2NoogPW_omh9ko000000?oo>>S00Go0000ooWV[OoiiZgonNJ]o`000003oo?[_P03o`000?oQ
jmSohN_H00CohN_H0_l000000on^eOCo0000o`18b002o`18b006o`000?m6F/?o0000o`000?mIK/go
00000oniW;X00ol0003o_9ZeokbJ]@04okbJ]@03o`000?o<Y;3oc:B`00;oc:B`00?o0000om:UZOoB
YJT01OoBYJT00ol0003oajBeolNT]@04olNT]@?o00000ooAYJ`01?l0003oZjGAoj^UdOl00006okZS
`@03o`000?nRZMcoXZWL00GoXZWL00?o0000obIJcolVF/l00_lVF/l00ol0003o002>o`000002o`00
0005o`HYZol0003o3cBco`ld/ol000002?nQR[/2o`0000KoeZJU00Co0000omVXY?oIZ:Co00003?oo
ool00ol0003oooooooooo`1dooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool0B?ooool2o`0000Gooooo0_l00007ooooo`03o`000?oooooooooo00kooooo00?o
0000ooGS]ol000001Ol00002ooWHYP04o`000?oifj[onM^ZooWKZP?o00001oo3f^X2o`0000CohGY2
0_l00005omYdA`03o`000?oLM4?og7A300;og7A300?o0000ome`=_oML3H00_oML3H01?l0003of6<H
omQS6?l00004oogMWP05o`000?omgYgooMjMoogNWOl000000oomh9h00ol0003oo>>SoocSX`02oocS
X`_o00000_oQjmP2o`0000Co[]Gd00Co0000o`18b?l0B<So00000om6F/<2o`0000;o^Ibj00?o0000
okbJ]OnlV[D01OnlV[D00ol0003oc:B`olbT/002olbT/003o`000?oBYJWodZFY00CodZFY00?o0000
omJVYOl000000_o7Y;D3o`000003olNT]Ol0003odJF/00?odJF/00?o0000oj^UdOl000001onjXl40
0ol0003oXZWLoj:Yg005oj:Yg003o`000?lVF/oo9U[?00;o9U[?00?o0000o`00S_l008h00ol00000
1?l6:J_o0000o`ld/ol00007oj6:^`;o00001ooFYZD01Ol0003ofJRTomVXY?oIZ:Co000000cooooo
00?o0000ooooooooool0Loooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo
00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVI
VOl0003ooooo04Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00cooooo0ol00003ooWFY@05o`000?oif:KonMRVooWHY_l000001OoifjX01?l0003o
m]jao`000?l00006ol?JjP03o`000?oQNT;ohGY200;o000000?oeg17o`000?oJM4L01?oJM4L00ol0
003og7A3omad@`03omad@`03o`000?oML3KogG0f00;ogG0f00?o0000omQS6?l000001?omgIh01Ol0
003ooMjMoogNWOomgYgo000000?ooN2N00?o0000oocSXoolhj<00ol00002onci^005o`000?o[n/7o
jo[1on_j`Ol000000ooWn<h3o`0000Go[]Gd0_l000000ol0B<So0000odIJ``03odIJ``03o`000?ni
W;[o000000So_9Ze00Go0000olbT/?o<Y;3oc:B`o`000007om:UZ@03o`000?oFYZGo000000;o0000
0oo7Y;D00ol0003odJF/om6U[004om6U[003o`000?njXl7o^Z?100Oo^Z?100?o0000oj:Yg?nRZM`0
0_nRZM`4o`0000Co9U[?00Oo0000o`00S_l0003o0000o`HYZol0003o1RV[00;o00001?nQR[/3o`00
0003oj69^ol0003oeZJU00KoeZJU00Go0000omVXY?oIZ:CofJRTo`00000<ooooo`03o`000?oooooo
oooo07?ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooo
cLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1?
ooooo`;o00002Oooool00ol0003oooooooooo`0;ooooo`03o`000?oieZGonMJU00;onMJU00?o0000
ooWHY_oif:H00_oif:H00ol0003onM^ZooWKZP02ooWKZP03o`000?ofg[7om]ja00;om]ja00?o0000
ol?Jj_o3f^X00oo3f^X3o`0000Coeg1700?o0000omYdAooJM4L00_oJM4L00ol0003og7A3omad@`03
omad@`03o`000?oML3KogG0f00;ogG0f00?o0000omQS6?l000000oomgIh00ol0003ooMjMoogNW@02
oogNW@04o`000?omh9kooN2NoogPWP?o000000GokOVeo`000?o/nKSok?Vho`000003on_j`@03o`00
0?oWn<koioS>00;oioS>00Co0000omgagOoMlMgo00001On^eO@2o`000003o`18b?l0003oAU[300?o
AU[300?o0000okbJ]OnlV[D02?nlV[D01?l0003oc:B`olbT/?l00006om:UZ@Co00001Oo7Y;D00ol0
003odJF/om6U[004om6U[003o`000?njXl7o^Z?100So^Z?11?l00003oiRGd@;o00000olVF/l01_l0
003o002>o`00S_l0003o1RV[o`0000;o1RV[1Ol00005oj69^`03o`000?oFYZGoeZJU00?oeZJU00?o
0000omVXY?oIZ:@00_oIZ:@00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo07;ooooo00?o
003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1>ooooo`;o00002ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oieZGonMJU00?onMJU00Go0000ooWHY_oif:KonMRV
o`000005ooWKZP03o`000?ofg[7om]ja00?om]ja1ol00005omM`A`03o`000?oJM4OofWA700?ofWA7
00?o0000omad@ooLM4<00_oLM4<00ol0003ogG0fome`=P03ome`=P03o`000?omgIkooMfN00;ooMfN
00Go0000oogNWOomgYgooMjMo`000002oogPWP;o00000oo]nKD01?l0003ok?Vhonci^?l00003on_j
`@03o`000?oWn<koioS>00;oioS>00?o0000omgagOoMlMd00_oMlMd00ol0003o[]GdojkEm002ojkE
m004o`000?l009?o0000o`0000CoAU[300?o0000okbJ]OnlV[D02?nlV[D00ol0003oc:B`o`000005
om:UZ@?o00000ooFYZD01Ol0003oajBeolNT]Oo7Y;Go000000KodJF/00?o0000omJVYOl000002Onj
Xl400ol0003oV9OAoiRGd@05oiRGd@;o00000_lVF/l2o`0000;o002>00?o0000o`HYZol000000_l6
:J/00ol0003oXHVkoj69^`06oj69^`03o`000?oFYZGoeZJU00?oeZJU00?o0000omVXY?oIZ:@00ooI
Z:@00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo077ooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1>ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool02?ooool00ol0003onMJUooWFY@02ooWFY@03o`000?oif:KonMRV00;onMRV00?o
0000ooWKZ_oifjX00_oifjX00ol0003om]jaooKN/@04ooKN/@;o00001?mj[_@00ol0003oeg17omM`
A`03omM`A`03o`000?oJM4OofWA700?ofWA700?o0000omad@ooLM4<00ooLM4<00ol0003ogG0fome`
=P02ome`=P03o`000?omgIkooMfN00;ooMfN00Co0000oogNWOomgYgooMjM0ol000001Oo]nKOo0000
ongi]Oo]nKGo000000?ok?Vh00Co0000on_j`Oo[n/7o00001?oWn<h00ol0003ogO7Momgag@03omga
g@Co00000_n^eO@2o`000003o`18b?l0003oAU[300?oAU[300?o0000okbJ]OnlV[D01onlV[D00ol0
003oc:B`o`000002om:UZ@?o00000_oBYJT01Ol0003oeZJUomJVYOoFYZGo000000?oajBe00?o0000
om6U[?oAYJ`01?oAYJ`00ol0003oeZJUo`000008okZS`@03o`000?o3XKOo000000KoV9OA00?o0000
o`0b]_l000000_lVF/l2o`000007o`00S_l0003o1RV[o`HYZol0003o1RV[o`000008oj69^`03o`00
0?oFYZGoeZJU00?oeZJU00?o0000omVXY?oIZ:@00ooIZ:@00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo077ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`1>ooooo`;o00003Oooool00ol0003oooooooooo`07ooooo`03o`000?oieZGonMJU00;onMJU
00?o0000ooWHY_oif:H00_oif:H00ol0003onM^ZooWKZP02ooWKZP03o`000?ofg[7om]ja00?om]ja
00Co0000oo7R_ooah[oo00001?mj[_@00ol0003oeg17omM`A`03omM`A`03o`000?oJM4OofWA700;o
fWA700?o0000omad@ooLM4<00ooLM4<00ol0003ogG0fome`=P02ome`=P05o`000?omgIkooMfNoogM
W_l000001?omgYd01?l0003okOVgongi]ol00002ongi]@05o`000?o/nKSok?Vhonci^?l000000_o[
n/400ol0003oioS>onOhcP02onOhcP03o`000?oMlMgogO7M00?ogO7M00Go0000olWOjOo9gnWo0000
odF=k@03o`000003o`00Tol0003o000000CoAU[300?o0000okbJ]OnlV[D02?nlV[D4o`0000CodZFY
00?o0000omJVYOoFYZD00ooFYZD00ol0003oajBeo`000007om6U[004o`000?oFYZGoeZJUo`0000Ko
^Z?100Co0000ol>Q]oo3XKOo00001onHUm401?l0003o03:fo`000?lVF/l2o`0000;o002>00Ko0000
o`HYZol6:J_o0000o`HYZol00008oj69^`05o`000?oFYZGoeZJUomJVYOl000001_oIZ:@00ol0003o
ooooooooo`0<ooooo`03o`000?oooooooooo073ooooo00?o003oooooooooool01?ooool00ol00?oo
ooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?oo
ool00_o=cLd00onIVIWo0000ooooo`1>ooooo`03o`000?oooooooooo00gooooo0_l00006ooooo`03
o`000?oieZGonMJU00;onMJU00?o0000ooWHY_oif:H00_oif:H00ol0003onM^ZooWKZP02ooWKZP03
o`000?ofg[7om]ja00?om]ja00?o0000oo7R_ooah[l00_oah[l01Ol0003oNZkdogZ^m?mj[_Co0000
00Goeg1700?o0000omYdAooJM4L00ooJM4L00ol0003og7A3omad@`03omad@`04o`000?oML3KogG0f
o`0000CooMfN00?o0000oogNWOomgYd00_l00002ongi]`05o`000?o]nKGokOVeongi]Ol000000_o/
nKP01?l0003ojo[1on_j`Ol00004onOhcP03o`000?oMlMgogO7M00;ogO7M0_l00004olWOj@07o`00
0?m5SNgoAHg]odF=kOl0003o002Co`000004odIJ``03o`000?nlV[Go_9Ze00Ko_9Ze0ol00007om:U
Z@03o`000?oFYZGoeZJU00?oeZJU00?o0000olNT]Ol000001_oAYJ`01Ol0003oeZJUomJVYOoFYZGo
000000Go^Z?100?o0000ol>Q]oo3XKL00_o3XKL00ol0003oV9OAoiRGd@04oiRGd@05o`000?l0<[Ko
03:fo`000?lVF/l00_l000001ol008ko0000o`000?l6:J_o0000o`HYZol000002?nQRK/01Ol0003o
eZJUomJVYOoFYZGo000000OofJRT00?o0000ooooooooool03?ooool00ol0003oooooooooo`1_oooo
o`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgo
VIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0C_ooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo00?o0000ooWFYOoieZD00_oieZD00ol0
003onMRVooWHYP02ooWHYP03o`000?oifj[onM^Z00;onM^Z00?o0000ooKN/Oofg[400oofg[400ol0
003olN:ooo7R_`03oo7R_`;o000000?oNZkdo`000?oGL4L01?oGL4L00ol0003ofWA7omYdA`03omYd
A`03o`000?oLM4?og7A300?og7A300Co0000ome`=_oML3Ko00001?omgIh3o`000005onci__l0003o
kOVgongi]ol000000_o]nKD01?l0003ok?Vhonci^?l00002on_j`@03o`000?oWn<koioS>00;oioS>
00?o0000omgagOoMlMd00_oMlMd00ol0003obMoYolWOj@05olWOj@04o`000?m5SNgoAHg]o`0000;o
002C0_l00003odIJ``03o`000?nlV[Go_9Ze00;o_9Ze1?l00002okfI/`03o`000?oBYJWodZFY00Co
dZFY00?o0000omJVYOoFYZD00ooFYZD00ol0003oajBeo`000006om6U[005o`000?oFYZGoeZJUomJV
YOl000001?njXl400ol0003o`j6gol>Q]`03ol>Q]`03o`000?nHUm7oV9OA00GoV9OA00?o0000o`0b
]_l0<[H00ol000001Ol008ko0000o`@UZ?l0003o1RV[00;o00002?nQRK/01Ol0003oeZJUomJVYOoF
YZGo000000OofJRT00?o0000ooooooooool03?ooool2o`00073ooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1>ooooo`;o00004Oooool01Ol0003ooooooooo
oooooooo000000GonMJU00Go0000ooWHY_oif:KonMRVo`000004ooWKZP03o`000?ofg[7om]ja00?o
m]ja00?o0000oo7R_ooah[l01?oah[l01Ol0003o2eWBo`000?mj[_Co000000Goeg1700?o0000omYd
AooJM4L00ooJM4L00ol0003og7A3omad@`03omad@`;o00000oomgIh2o`0000?ok?Vn00Co0000ongi
]oo]nKOo00000_o]nKD01?l0003ok?Vhonci^?o/nKP:o`0000;ogO7M00?o0000olWOjOo9gnT01_o9
gnT2o`0000;oAHg]00Go0000o`00Tol0003o>Tfko`000002odIJ``03o`000?nlV[Go000000;o0000
0_nlV[D01Ol0003o_IVcokfI/onmVK?o000000GodZFY00?o0000omJVYOoFYZD01OoFYZD00ol0003o
dJF/om6U[004om6U[003o`000?oFYZGoeZJU00?oeZJU00Co0000okZS`OnjXl7o00001_o3XKL00ol0
003oV9OAoiRGd@05oiRGd@08o`000?l0<[Ko03:fo`0b]_l0003o0021o`000?l008h2o`0000;o1RV[
0_l00008oj69^`03o`000?oFYZGo000000SofJRT00?o0000ooooooooool03Oooool00ol0003ooooo
ooooo`1^ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003ooooo
olg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0
>oooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000ooooooooool0
4Oooool01?l0003oooooooooool00004ooWFY@03o`000?oif:KonMRV00;onMRV00?o0000ooWKZ_oi
fjX00_oifjX00ol0003om]jaooKN/@02ooKN/@03o`000?oah[oolN:o00ColN:o00Co0000on7Ue_l0
003o2eWB0_l00005omM`A`03o`000?oJM4OofWA700?ofWA700?o0000omad@ooLM4<00ooLM4<2o`00
0005oogMW_l0003o0000on[hbOl000000_o/nKh01?l0003okOVgongi]ol00003ongi]@03o`000?o/
nKSok?Vh00;o00000_n4Umh:o`0000GobMoY0ol000001On/`n_o0000odF=kOm5SNgo000000;o002C
00?o0000ocY=^ol000000ol00004okbJ]@03o`000?nmVK?o_IVc00;o_IVc00?o0000om:UZOoBYJT0
0ooBYJT00ol0003oeZJUomJVY@05omJVY@03o`000?oAYJcodJF/00CodJF/00?o0000omJVYOoFYZD0
0ooFYZD00ol0003o^Z?1o`000008ol>Q]`Wo00000ol0<[H2o`000004o`00S_l0003o12FXo`0000;o
1RV[00?o0000oj69^onQRK/01_nQRK/00ol0003oeZJUo`000007omVXY003o`000?oKZjGo000000ko
oooo00?o0000ooooooooool0K_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo03[ooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo
000000?ooooo00?o0000ooooooooool04oooool2o`0000GonMJU00Go0000ooWHY_oif:KonMRVo`00
0005ooWKZP03o`000?ofg[7om]ja00;om]ja00?o0000oo7R_ooah[l00ooah[l01ol0003ohNGFon7U
e_oQiMKo0000o`]Id_l000001OoGL4L00ol0003ofWA7omYdA`03omYdA`03o`000?oLM4?og7A300?o
g7A30ol00002on[hb@05o`000?o/nKkok?Vnonci__l000000_o]nKL01Ol0003okOVeongi]Ol0003o
k?Vh00;o00000_n4Umh2o`0000;o/j7600?o0000oh:gmon2]oL01On2]oL2o`000003olWOjOl0003o
000000Go[<?[00Go0000odF=kOm5SNgo0000o`00T`04o`000003odIJ`ol0003o_9Ze00;o_9Ze00?o
0000okfI/onmVK<01?nmVK<00ol0003odZFYom:UZ@02om:UZ@03o`000?oFYZGoeZJU00CoeZJU0_l0
0006om6U[003o`000?oFYZGoeZJU00CoeZJU00?o0000ol>Q]oo3XKL01oo3XKL00ol0003oT8[9oi2:
b@05oi2:b@06o`000?l0<[Ko03:fo`0b]_l0003o00210_l00002o`@UZ003o`000?l6:J_o000000So
XHVk00?o0000omJVYOl000001ooIZ:@00ol0003ofj^Uo`00000?ooooo`03o`000?oooooooooo06go
oooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=
cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`0cooooo`Go
00000_ooool01?l0003oooooooooool0000;ooooo`04o`000?ooooooooooooooo`;o00005Oooool0
0ol0003onMJUooWFY@02ooWFY@03o`000?oif:KonMRV00;onMRV00?o0000ooWKZ_oifjX00_oifjX0
0ol0003om]jaooKN/@02ooKN/@03o`000?oah[oolN:o00?olN:o00?o0000on7Ue_oQiMH00ooQiMH0
0ol0003o2eWBo`000005omM`A`03o`000?oJM4OofWA700?ofWA700?o0000omad@ooLM4<00_oLM4<0
1Ol0003oj_S9on[hbOoZn<Wo000000?ok?Vn00Co0000ongi]oo]nKOo00000_o]nKD3o`0000?oQ9ON
00?o0000ok>Qa_ncXLH00oncXLH00ol0003oP[Ogoh:gm`04oh:gm`?o00001on/`n/2o`000004odF=
kOl0003o0000o`0000?o>Tfk0_l00002okbJ]@03o`000?nmVK?o_IVc00Go_IVc00Go0000om:UZOoB
YJWodZFYo`000007omJVY@03o`000?oIYj?o000000CodJF/00?o0000omJVYOoFYZD01OoFYZD00ol0
003o`j6gol>Q]`06ol>Q]`03o`000?o7X;3o000000KoT8[90_l00003o`0b]P;o000000Oo002>o`00
0?l49JSo12FXo`000?l6:J_o000000SoXHVk00?o0000omVXY?oIZ:@01_oIZ:@00ol0003ofj^Uo`00
000@ooooo`03o`000?oooooooooo06cooooo00?o003oooooooooool01?ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`0jooooo`04o`000?ooooooooooo`0000_ooooo00Go0000oooooooooooo
ooooo`00000Fooooo`03o`000?oieZGonMJU00;onMJU00Go0000ooWHY_oif:KonMRVo`000005ooWK
ZP05o`000?ofg[7om]jaooKN/Ol000001Ooah[l00ol0003ohNGFon7UeP05on7UeP;o00001OoGL4L0
0ol0003ofWA7omYdA`03omYdA`03o`000?oLM4?og7A300?o00000ooZn<T01?l0003ok?Vnonci__l0
0002ongi]`04o`000?o]nKGo0000o`0000;ocJB^00Co0000ohBGg_l0003o00001oncXLH00ol0003o
P[Ogoh:gm`03o`0000?oXjkO00?o0000ojc3jon/`n/01?n/`n/5o`000003o`00Tol0003o>Tfk00;o
>Tfk00?o0000okbJ]Ol000002?nmVK<01Ol0003odZFYom:UZOoBYJWo000000OoeZJU00?o0000omVW
Xol000001?oAYJ`00ol0003oeZJUomJVY@04omJVY@03o`000?oJYj;o000000Oo`j6g00?o0000olNP
/?l000001on@R/T2o`0000;o03:f00Co0000o`00POl0003o00000_l49JP01?l0003o1RV[o`000?l0
0006oj69^`;o00001ooIZ:@01Ol0003ofj^Uom^[YOoKZjGo000000oooooo00?o0000ooooooooool0
K?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgo
cLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo03[ooooo
00Co0000oooooooooooo00001oooool4o`0000Cooooo00?o0000ooooooooool04oooool00ol0003o
nMJUooWFY@02ooWFY@03o`000?oif:KonMRV00;onMRV00?o0000ooWKZ_oifjX00_oifjX00ol0003o
m]jaooKN/@02ooKN/@03o`000?oah[oolN:o00;olN:o00?o0000on7Ue_oQiMH01_oQiMH2o`0000Go
eg1700?o0000omYdAooJM4L00ooJM4L01Ol0003og7A3o`000?nF4`3o000000?oj_S900Go0000onci
__o/nKkok?Vno`000002ongi]`;o00001Oo=Y:h00ol0003o/j76ok>QaP08ok>QaP;o00001onS[]l0
0ol0003o[<?[ojc3j`03o`000003ojc3jol0003o02nh00Co00001?ljCK/00ol0003o_IVcokfI/`08
okfI/`03o`000?oBYJWo000000OoeZJU00Co0000omVWXooIYj?o00001?oAYJ`00ol0003oeZJUomJV
Y@04omJVY@03o`000?oJYj;o000000Ko`j6g00Go0000olNP/?o7X;3oaj2`o`000006oi2:b@04o`00
0?l06jKo0000o`0b]P;o000000?o0021o`000?l49JP00_l49JP2o`000004oj69^ol0003oXHVkoj69
^`?o000000?oXH^lo`000?oIZ:@01_oIZ:@01Ol0003ofj^Uom^[YOoKZjGo0000013ooooo00?o0000
ooooooooool0Joooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000
ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003o
oooo03[ooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`05ooooo`;o00005?oo
ool00ol0003onMJUooWFY@02ooWFY@05o`000?oif:KonMRVooWHY_l000001OoifjX01Ol0003om]ja
ooKN/Oofg[7o000000ColN:o00?o0000on7Ue_oQiMH01?oQiMH3o`000003ojgFm_l0003o000000Go
eg1700?o0000omYdAooJM4L00_oJM4L4o`0000?oj_S900Go0000onci__o/nKkok?Vno`000002ongi
]`03o`000?o=Y:kocJB^00GocJB^00?o0000ok>Qa_ncXLH02?ncXLH00ol0003oXjkOoj>^g`06oj>^
g`?o00001?n/`n/00ol0003o02nho`0_^003o`0000Co>Tfk00?o0000okfI/onmVK<02?nmVK<00ol0
003odZFYo`000007omJVY@05o`000?oIYj?ofJNSomVWXol000000_oAYJ`00ol0003oeZJUomJVY@05
omJVY@03o`000?oJYj;o000000Ko`j6g00Go0000olNP/?o7X;3oaj2`o`000006oi2:b@03o`000?l0
6jKo000000;o03:f00Co0000o`00POl0003o00000ol49JP5o`0000GoXH^l00?o0000omVXY?oIZ:@0
1?oIZ:@01Ol0003ofj^Uom^[YOoKZjGo0000017ooooo00?o0000ooooooooool0J_ooool00ol00?oo
ooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00
007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo03_ooooo0_l00008ooooo`Go
00000oooool00ol0003oooooooooo`0Booooo`03o`000?oieZGonMJU00;onMJU00?o0000ooWHY_oi
f:H00_oif:H00ol0003onM^ZooWKZP02ooWKZP03o`000?ofg[7om]ja00[o00000_oQiMH2o`0000Go
[MKf00?o0000omM`AooGL4L00ooGL4L00ol0003ofWA7omYdA`02o`0000;oS0D000?o0000on[hbOoZ
n<T00_oZn<T01Ol0003ok?Vnonci__l0003okOVg00?o00001_o=Y:h00ol0003odZBXo`000008ok>Q
aP03o`000?o4XkOo000000CoXjkO0ol000000onS[]oo0000o`000006o`0000;o02nh0ol00004ocY=
^`03o`000?nmVK?o_IVc00Oo_IVc00?o0000om:UZOl000001ooFYZD01Ol0003ofJNSomVWXooIYj?o
000000;odJF/00?o0000omJVYOoFYZD01?oFYZD01Ol0003ofZNRomZWX_oJYj;o000000Co`j6g00?o
0000olNP/?o7X;000_o7X;000ol0003oT8[9oi2:b@05oi2:b@04o`000?l06jKo0000o`0b]P;o0000
00?o0021o`000?l49JP00ol49JP00ol0003oXH^lo`000006oj6;_003o`000?oIZ:CofJRT00?ofJRT
00?o0000om^[YOoKZjD00ooKZjD00ol0003oooooooooo`0>ooooo`;o0000Joooool00ol00?oooooo
ooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007o
oooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo04cooooo00?o0000ooooooooool0
4oooool00ol0003onMJUooWFY@02ooWFY@03o`000?oif:KonMRV00;onMRV00?o0000ooWKZ_oifjX0
0_oifjX3o`000003ooSU/Ol0003omnNe00?omnNe00Co0000oo?X_?ocj;colnRl0ol00006ojgFmP03
o`000?oGL4Ooeg1700?oeg1700?o0000omYdAol000000on<1@000ol0003oj_S9on[hb@02on[hb@04
o`000?o/nKkok?Vnonci_P;o000000?o`Z>io`000?o=Y:h01_o=Y:h00ol0003odZBXo`000007ok>Q
aP06o`000?o4XkOoa:>golBS]ol0003oXjkO0_l000001_nS[]oo0000o`000?l0003o/:G=o`0000Go
Rj7S00Ko0000o`0_^?l0;kSo0000o`00L_l00004ocY=^`03o`000?nmVK?o_IVc00So_IVc00?o0000
omJVYOoFYZD01OoFYZD00ol0003ofJNSomVWX`02omVWX`03o`000?oAYJco000000OoeZJU00Go0000
omZWX_oJYj;ofZNRo`000003ol>Q]`03o`000?o7X;3oaj2`00Coaj2`00?o0000oi2:bOn@R/T01?n@
R/T00ol0003o01^Vo`0KYP03o`000003o`00POl0003o12FX00?o12FX00Co0000oj6;_?nQRkco0000
1OnQRk`00ol0003ofJRTomVXY003omVXY003o`000?oKZjGofj^U00?ofj^U00?o0000ooooooooool0
3_ooool2o`0006_ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`1<ooooo`;o00005?ooool01Ol0003onMJUooWFYOoieZGo000000ConMRV00Co0000ooWKZ_oi
fj[onM^Z0_l00003ooSU/@03o`000?ogikGomnNe00;omnNe00?o0000oo?X_?ocj;`00oocj;`00ol0
003okNW8o`000002o`0000Co[MKf00?o0000omM`AooGL4L01Ol00003oh`50005o`000?oZn<Woj_S9
on[hbOl000000oo/nKh2o`000003ol:S^Ol0003ocJB^00OocJB^00Co0000om:TZ?oBY:So00001Onc
XLH01?l0003oa:>golBS]oo4XkL3o`000003oj>^gol0003o000000Go/:G=00?o0000oh^Qhon;XN<0
0on;XN<00ol0003o02nho`0_^002o`0000Co>Tfk00?o0000okfI/onmVK<02?nmVK<00ol0003oeZJU
omJVY@05omJVY@03o`000?oIYj?ofJNS00;ofJNS00?o0000om6U[?l000001ooFYZD00ol0003ofZNR
omZWXP02omZWXP04o`000?o3XKOo`j6go`0000Koaj2`00?o0000oi2:bOn@R/T01?n@R/T01Ol0003o
01^Vo`0KY_l0003o03:f00;o000000?o0021o`000?l49JP00ol49JP00ol0003oXH^lo`000006oj6;
_003o`000?oIZ:CofJRT00;ofJRT00?o0000om^[YOoKZjD00ooKZjD00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo06Sooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`1<ooooo`03o`000?oooooooooo01;ooooo00?o0000ooWFYOoieZD00_oieZD00ol0
003onMRVooWHYP02ooWHYPCo000000?on>Bao`000?ohiK400_ohiK400ol0003omnNeooOW]@02ooOW
]@03o`000?ocj;colnRl00;olnRl00?o0000ongYb?o]jLP00oo]jLP2o`0000;o[MKf0ol00005ogH0
00?o00001?oZn<T02?l0003ok?Vno`000?l0003oain`o`000?o2XkWo00001oo=Y:h01Ol0003odZBX
om:TZ?oBY:So000000Co/j7600?o0000olBS]ol000000_l00003olBS]`03o`000?n`YLgo/:G=00Ko
/:G=00?o0000oh^Qhon;XN<00_n;XN<2o`000004o`0_^?l0003o001bo`0000Co>Tfk00?o0000okfI
/onmVK<01_nmVK<00ol0003o_iZbo`000006omJVY@03o`000?oIYj?ofJNS00?ofJNS0_l00006omJV
Y@03o`000?oJYj;ofZNR00?ofZNR00?o0000ol>Q]ol000002?o7X;05o`0000;oT8[900?o0000o`0K
Y_l06jH00ol000000ol0087o0000o`000003o`@UZ004o`000?nQRkcoXH^lo`0000GoXH^l00Go0000
omVXY?oIZ:CofJRTo`000007om^[Y@03o`000?oooooooooo00oooooo00?o0000ooooooooool01Ooo
ool5o`0005kooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oo
oooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000oooo
o`1<ooooo`03o`000?oooooooooo01;ooooo00?o0000ooWFYOoieZD00_oieZD00ol0003onMRVooWH
YP03o`0000?on>Ba00Go0000ooSU/OohiK7on>Fao`000004ooOW]@03o`000?ocj;colnRl00;olnRl
00?o0000ongYb?o]jLP01?o]jLP01Ol0003o77[Uo`000?l0003o[MKf00Co00001?mf00000ol0003o
j_S9on[hb@02on[hb@?o00001?o7Wk000ol0003ocJB^olfT[P06olfT[P03o`000?oBY:SodZBX00;o
dZBX00?o0000ok>Qa_ncXLH00ol00006olBS]`03o`000?n`YLgo/:G=00Ko/:G=00?o0000oh^Qhon;
XN<00on;XN<00ol0003o02nho`000003o`0000?o>Tfk00?o0000okfI/onmVK<01OnmVK<01?l0003o
_iZboknJ/_l00005omJVY@03o`000?oIYj?ofJNS00CofJNS00?o0000omJVYOoFYZD01OoFYZD00ol0
003ofZNRomZWXP03omZWXP03o`000?o3XKOo000000Soaj2`00?o0000oh^2`on;P/<00_n;P/<3o`00
00?o01^V00Ko0000o`00O?l0003o0000o`TXZOl00002o`@UZ005o`000?nQRkcoXH^loj6;_?l00000
1?nQRk`01Ol0003ofJRTomVXY?oIZ:Co000000Oofj^U00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`05ooooo`04o`000?ooooooooooo`0005kooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`1<ooooo`;o00004_ooool00ol0003onMJUooWFY@02ooWF
Y@06o`000?oif:Ko0000o`000?oghk?o00001?ohi;401Ol0003on>FaooSU/OohiK7o000000ComnNe
00?o0000oo?X_?ocj;`00_ocj;`00ol0003okNW8ongYb003ongYb003o`000?oOiMSo000000;o77[U
0_l000000ol01iWo0000o`000002o`000003ogH00?l0003oj_S900Co00001oo7Wk000ol0003ocJB^
olfT[P05olfT[P03o`000?oBY:SodZBX00?odZBX0ol00008olBS]`03o`000?o<Xjko000000Oo/:G=
1?l00003oh^Qh`04o`000?l0;kSo0000o`00LP;o00000_ljCK/00ol0003o_IVcokfI/`04okfI/`05
o`000?noV[;o_iZboknJ/_l000001OoFYZD00ol0003ofJNSomVWX`04omVWX`03o`000?oFYZGoeZJU
00GoeZJU00?o0000omZWX_oJYj801?oJYj800ol0003oaj2`olNP/006olNP/003o`000?o;XJgo0000
00GoRh;300?o0000o`0KY_l06jH00_l06jH2o`000003o`00POl0003o000000?o12FX00Go0000oj6;
_?nQRkcoXH^lo`000004oj6;_004o`000?oIZ:CofJRTo`0000Oofj^U00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo05kooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1<ooooo`03o`000?oooooooooo017ooooo00?o
0000ooWFYOoieZD00_oieZD2o`0000;omn>c00?o0000ooST/Oohi;400_ohi;401Ol0003on>FaooSU
/OohiK7o000000ComnNe00?o0000oo?X_?ocj;`00_ocj;`00ol0003okNW8ongYb003ongYb005o`00
0?oOiMSognGHomoUf?l000000olLN^D2o`0000?oPgc31?l00009olNO/003o`000?o:X:go000000Ko
cJB^00?o0000om:TZ?oBY:P00ol000000ooBY:So0000olBS]`08olBS]`03o`000?o<Xjko000000Ko
/:G=00?o0000okJO`Ol000000_m]PMH8o`000005ocE7]ol0003o>TfkocY=^ol000001?nmVK<00ol0
003o_iZboknJ/P03oknJ/P03o`000?oFYZGoeZJU00;oeZJU00?o0000omVWXooIYj<00ooIYj<00ol0
003og:VRo`000005omJVY@03o`000?oJYj;ofZNR00GofZNR00?o0000olNP/?o7X;001_o7X;000ol0
003obj6]o`000006oh^2``06o`000?l06jKo01^Vo`0KY_l0003o001l0_l000001Ol9::Wo0000o`@U
Z?l49JSo000000?oXH^l00?o0000oj6;_?nQRk`00_nQRk`00ol0003ofJRTo`000007om^[Y@03o`00
0?oM[jSo000001;ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1Mooooo`03o`00
oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o
00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0Boooool00ol0003ooooo
ooooo`0Aooooo`04o`000?oieZGonMJUooWFY@;o00001?oghk<00ol0003on>BaooST/@02ooST/@05
o`000?ohiK7on>FaooSU/Ol000000oogikD00ol0003olnRloo?X_002oo?X_003o`000?o]jLSokNW8
00?okNW800?o0000omoUf?oOiMP00ooOiMP01_l0003o77[UoaajiOl0003o00NIo`0000GoPgc300?o
0000olNO/?o7Wk001oo7Wk000ol0003obZ2]o`000005olfT[PCo00001?oBY:P00ol0003oa:>golBS
]`06olBS]`05o`000?o<Xjkoc:>^olbS[_l000001?n`YLd01Ol0003o]Yo1okJO`OnfWl7o000000Co
KH7F1Ol00002ocE7]`03o`000?ljCK_o000000?o_IVc00?o0000oknJ/_noV[801?noV[801Ol0003o
eZJUomJVYOoFYZGo000000KofJNS00?o0000ombYX_l000001OoFYZD00ol0003ofZNRomZWXP05omZW
XP03o`000?o7X;3oaj2`00Goaj2`00Co0000ol^Q[Oo;XJgo00001_n;P/<2o`0000?o01^V0ol00002
o`TXZ@03o`000?l49JSo000000CoXH^l00Oo0000oj6;_?nQRkcoXH^lo`000?oIZ:Co000000Oofj^U
00?o0000omf_Z?l000004oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool0
0000G_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=
cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo04_o
oooo0ol0000=ooooo`Go000000GonMJUo`000?l0003om>:ho`000003ooOS/`03o`000?ohi;7on>Ba
00;on>Ba00Go0000ooSU/OohiK7on>Fao`000004ooOW]@05o`000?ocj;colnRloo?X_?l000001Oo]
jLP00ol0003ognGHomoUf004omoUf0;o00000_lLN^D2o`0000KoPgc300?o0000olNO/?o7Wk001Oo7
Wk001?l0003obZ2]olZP[Ol00004olfT[P;o00001_oBY:P00ol0003oeZFUo`000007olBS]`03o`00
0?o<Xjkoc:>^00;oc:>^00Co0000ok2UcOn`YLgo00001?nfWl400ol0003oKH7Foff1eP03off1ePGo
00000_leAkL2o`0000;o_IVc00?o0000oknJ/_noV[801OnoV[801Ol0003oeZJUomJVYOoFYZGo0000
00KofJNS00?o0000ombYX_l000001OoFYZD00ol0003ofZNRomZWXP04omZWXP03o`000?oMZJ3o0000
00Koaj2`00Go0000ol^Q[Oo;XJgobj6]o`000005oh^2``;o00000ol06jH01?l0003o001lo`000?l0
0002o`TXZ@03o`000?l49JSo000000CoXH^l00Co0000oj6;_?nQRkcoXH^l0_l00007om^[Y@03o`00
0?oM[jSo000001Cooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo05co
oooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=
cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`14ooooo`;o
00001Oooool00ol0003oooooooooo`0:ooooo`?o000000Codg1Ao`000?oEKdcoeFm<0_l00002ooCR
^003o`000?oghk?omn>c00;omn>c00?o0000ooST/Oohi;400_ohi;401?l0003on>FaooSU/Ol00004
ooOW]@03o`000?ocj;colnRl00;olnRl00?o0000ongYb?o]jLP00_o]jLP00ol0003ognGHomoUf002
omoUf0?o000000Co`MOZo`000?lLN^Go77[U0_l00006oh=l``03o`000?o7Wk3oain`00Goain`00Co
0000olZP[Oo:X:gobZ2]1?l000000oo=Y:ko0000om:TZ005om:TZ003o`000?oFYJGo000000Koa:>g
00?o0000olbS[_o<Xjh00oo<Xjh00ol0003o/:G=o`000006okJO`@03o`000?m]PMKoKH7F00?oKH7F
1?l00003ocE7]`?o00002OnoV[801?l0003oeZJUomJVYOl00005omVWX`05o`000?oLZJ;og:VRombY
X_l000000ooFYZD00ol0003ofZNRomZWXP05omZWXP03o`000?oMZJ3o000000Goaj2`00?o0000ol^Q
[Oo;XJd00_o;XJd00ol0003oRh;3oh^2``04oh^2``;o00000_l06jH4o`0000;o2BRY00?o0000o`@U
Z?l000001OnQRk`01?l0003oXH^lo`000?l00007om^[Y@05o`000?oM[jSogJnXomf_Z?l000004_oo
ool3o`0000?ooooo0ol0001Oooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool0@oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Sooooo
0_l00005om=`D@;o00001?odh[P01Ol0003omn>cooOS/ooghk?o000000Con>Ba00Go0000ooSU/Ooh
iK7on>Fao`000004ooOW]@05o`000?ocj;colnRloo?X_?l000001?o]jLP01?l0003ognGHomoUf?oO
iMP2o`0000Go`MOZ00?o0000oaajiOlLN^D00_l00005oh=l``03o`000?o7Wk3oain`00Coain`00?o
0000olZP[Oo:X:d00ol00003olfT[P03o`000?oBY:SodZBX00GodZBX00?o0000omJUYOl000001Oo4
XkL00ol0003oc:>^olbS[P05olbS[P03o`000?nfWl7o]Yo100Go]Yo100?o0000off1e_m]PMH00om]
PMH01?l0003o0027o`000?l00004ocE7]`03o`000?noV[;o_iZb00So_iZb00?o0000omJVYOl00000
1_oIYj<01Ol0003og:VRombYX_oLZJ;o000000?oeZJU00?o0000omZWX_oJYj801OoJYj800ol0003o
gJVPo`000004olNP/003o`000?o;XJgobj6]00Cobj6]00?o0000oh^2`on;P/<00on;P/<00ol0003o
012Mo`000002o`0KYP03o`000?l007co000000?o2BRY0_l00004oj6;_0?o000000?oXXjoo`000?oK
ZjD01_oKZjD01Ol0003ogJnXomf_Z?oM[jSo000001Cooooo00?o0000ooooooooool0Hoooool00ol0
0?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02
o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo04?ooooo00Co0000oooo
oooooooo00001?ooool2o`0000Oooooo0_l000000oo@KE7o0000om=`D@04om=`D@;o00000oodh[P0
0ol0003omn>cooOS/`02ooOS/`03o`000?ohi;7on>Ba00;on>Ba00Co0000ooSU/OohiK7o00001?og
ikD00ol0003olnRloo?X_00<o`0000Oo`MOZ00Co0000oaajiOl0003o00001_n3O<<00ol0003oain`
olNO/002olNO/0Co00000_o:X:d01Ol0003ocJB^olfT[_o=Y:ko000000KodZBX00Go0000omJUYOoF
YJGoeZFUo`000004olBS]`03o`000?o<Xjkoc:>^00Goc:>^00?o0000okJO`OnfWl401_nfWl400ol0
003oKH7Foff1eP03off1ePCo00000oleAkL00ol0003o_iZboknJ/P08oknJ/P03o`000?oFYZGo0000
00KofJNS00Go0000ombYX_oLZJ;og:VRo`000003omJVY@03o`000?oJYj;ofZNR00CofZNR00Go0000
omfYX?oMZJ3ogJVPo`000003olNP/003o`000?o;XJgobj6]00Cobj6]00?o0000oh^2`on;P/<01?n;
P/<01?l0003o012Mo`000?l06jH4o`0000?o2BRY1Ol00002oj:>_`04o`000?nRS[ooXXjoo`0000Ko
fj^U00Go0000omf_Z?oM[jSogJnXo`00000Eooooo`03o`000?oooooooooo06;ooooo00?o003ooooo
ooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001
ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`13ooooo`04o`000?oooooooooo
o`0000Cooooo00?o0000ooooooooool01?ooool2o`0000?od6eA00?o0000om=`DOoCL5400ooCL540
0ol0003om>:hooCR^002ooCR^005o`000?oghk?omn>cooOS/ol000001?ohi;401Ol0003on>FaooSU
/OohiK7o000000ComnNe0ol00002of;HgP?o00000_n?ho`2o`0000?oY=;h0_l00006ol7GjP?o0000
1_n3O<<00ol0003oain`olNO/003o`0000KobZ2]00?o0000olfT[_l000001ooBY:P01Ol0003oeZFU
omJUYOoFYJGo000000?oa:>g00?o0000olbS[_o<Xjh01Oo<Xjh00ol0003odJBYo`000007okJO`@03
o`000?m]PMKoKH7F00?oKH7F00Co0000o`00Qol0003o00001?leAkL00ol0003o_iZboknJ/P08oknJ
/P;o00001OoIYj<00ol0003og:VRombYXP03ombYXP03o`000?oFYZGo000000OofZNR00Go0000omfY
X?oMZJ3ogJVPo`000002olNP/003o`000?o;XJgobj6]00Gobj6]00?o0000oh^2`on;P/<01?n;P/<0
1?l0003o012Mo`000?l06jH2o`000003o`00O?l0003o2BRY00?o2BRY00?o0000oj:>_onRS[l01?nR
S[l00ol0003oXXjoo`000005om^[Y@03o`000?oM[jSogJnX00?ogJnX00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`1Rooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool0@oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00;ooooo
0_l00006om1]D@03o`000?oCL57odg1A00;odg1A00Go0000ooCR^?odh[Som>:ho`000004ooOS/`03
o`000?ohi;7on>Ba00;on>Ba00Co0000ooSU/OohiK7o00000oogikD8o`0000;oSn?l0_l00007ojCB
n004o`000?o1en[o`MOZol7GjPKo00001On3O<<3o`000003olNO/?l0003obZ2]00KobZ2]00?o0000
olfT[_l000001ooBY:P00ol0003oeZFUomJUY@02omJUY@04o`000?o4XkOoa:>go`0000Ooc:>^00?o
0000om6TZOl000001onfWl43o`0000?oKH7F1?l00004ocE7]`03o`000?noV[;o_iZb00So_iZb00?o
0000omVWXooIYj<01?oIYj<00ol0003og:VRombYXP03ombYXP03o`000?oFYZGo000000OofZNR00Go
0000omfYX?oMZJ3ogJVPo`000002olNP/003o`000?o;XJgobj6]00Kobj6]1Ol000001_n;P/?o0000
o`0@WOl049go0000o`0KYP?o00001?l9::T00ol0003oXXjooj:>_`05oj:>_`;o00001OoKZjD00ol0
003ogJnXomf_Z003omf_Z003o`000?oooooooooo01?ooooo00?o0000ooooooooool0HOooool00ol0
0?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02
o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo04?ooooo00Co0000oooo
oooooooo00000oooool2o`000006ooooool0003o0000o`000?o<ID[o00001_o@KE401Ol0003odg1A
om=`DOoCL57o000000Com>:h00?o0000ooOS/ooghk<00_oghk<01Ol0003on>BaooST/Oohi;7o0000
00?on>Fa1?l00003ooooo`So00002?nTd_P4o`0000?oR;;a0ol00002oh=l``?o000000GoPgc3o`00
0?o7Wk3oain`o`000007olZP[@03o`000?o=Y:ko000000KodZBX00?o0000omJUYOoFYJD00ooFYJD0
0ol0003oa:>go`000007olbS[P04o`000?oAY:WodJBYo`0000Ko]Yo100Co0000okVK^_l0003oEVW:
0ol000000om]PMKo0000o`000002o`0000?o=DNg00?o0000oknJ/_noV[802?noV[800ol0003ofJNS
omVWX`04omVWX`03o`000?oLZJ;og:VR00?og:VR00?o0000omJVYOl000001_oJYj800ol0003ogJVP
omfYX002omfYX003o`000?o7X;3o000000Wobj6]00?o0000ohQl`?n8O<000_n8O<03o`0000;o012M
0ol000000ol007co0000o`TXZ@03o`TXZ@03o`000?nRS[ooXXjo00CoXXjo00?o0000oj:>_ol00000
1?oKZjD00ol0003ogJnXomf_Z003omf_Z003o`000?oooooooooo01Cooooo00?o0000ooooooooool0
H?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgo
cLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo04Cooooo
0_l00004ooooo`?o00001?o<IDX00ol0003od6eAom1]D@04om1]D@05o`000?oCL57odg1Aom=`DOl0
00000oodh[P00ol0003omn>cooOS/`02ooOS/`03o`000?ohi;7on>Ba00;on>Ba00?o0000ooSU/Ol0
00000_l00006ooooo`03o`000?nDXMgoU:7M00GoU:7M0ol00002ojCBn0?o00000_nX^nL00ol0003o
R;;aohRbl@03ohRbl@Co00001?n3O<<00ol0003oain`o`000009olZP[@03o`000?oBY:SodZBX00Go
dZBX00?o0000omJUYOoFYJD00ooFYJD00ol0003oa:>go`000007olbS[P05o`000?oAY:WodJBYom6T
ZOl000001?nfWl401Ol0003o^I^jokVK^_niVk[o000000?oEVW:1Ol00004ocE7]`03o`000?noV[;o
_iZb00Ko_iZb0_l00005omVWX`03o`000?oLZJ;og:VR00Gog:VR00?o0000omZWX_oJYj801OoJYj80
0ol0003ogJVPomfYX003omfYX0;o00002?o;XJd2o`0000KoR7c000?o0000o`0@WOl049d00_l00000
1?l007ko0000o`000?l00003o`TXZ@03o`000?nRS[ooXXjo00GoXXjo0_l00003om^[Y@03o`000?oM
[jSogJnX00GogJnX00?o0000ooooooooool04oooool00ol0003oooooooooo`1Pooooo`03o`00oooo
oooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o0000
0Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0B_ooool00ol0003oc6E:olaU
BP05olaUBP03o`000?o@KE7od6eA00Cod6eA00?o0000om=`DOl000001?odh[P00ol0003omn>cooOS
/`02ooOS/`04o`000?ohi;7on>BaooST/@?o00002_ooool00ol0003oU:7MoiBQg@06oiBQg@?o0000
1_nX^nL01?l0003oR;;aohRblOn8/_48o`000004oh=l`ol0003oain`o`0000WobZ2]00?o0000om:T
Z?oBY:P01OoBY:P00ol0003oeZFUomJUY@04omJUY@03o`000?o<Xjkoc:>^00Koc:>^00Go0000om6T
ZOoAY:WodJBYo`000003okJO`@03o`000?niVk[o^I^j00;o^I^j00?o0000oeIYb_mFJLX00omFJLX4
o`0000?o=DNg00?o0000oknJ/_noV[801OnoV[801?l0003o`9bcol2L/ol00004omVWX`03o`000?oL
ZJ;og:VR00Gog:VR00?o0000omZWX_oJYj801OoJYj800ol0003ogJVPomfYX003omfYX003o`000?o;
XJgobj6]00Oobj6]00?o0000olfQZol000001_n8O<000ol0003o012Mo`0@W@04o`000005oa<a[ol0
003o2BRYo`TXZOl000002?nRS[l01Ol0003ofj^Uom^[YOoKZjGo000000OogJnX00?o0000oooooooo
ool05?ooool00ol0003oooooooooo`1Oooooo`03o`00oooooooooooo00Cooooo00?o003ooooooooo
ool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;o
cLg=00?oVIVIo`000?ooool0B_ooool00ol0003oc6E:olaUBP05olaUBP03o`000?o@KE7od6eA00Co
d6eA00?o0000om=`DOl000001?odh[P01Ol0003omn>cooOS/ooghk?o000000Con>Ba00?o0000oooo
ooooool02oooool00ol0003oU:7MoiBQg@03oiBQg@;o00000_neX/D00ol0003oZ;_WojRki`05ojRk
i`?o00000_n8/_42o`0000CoOgNo0ol00009olZP[@03o`000?o<XJco000000GodZBX00?o0000omJU
YOoFYJD01OoFYJD00ol0003oc:>^olbS[P05olbS[P03o`000?oAY:WodJBY00;odJBY00Co0000okJO
`OnfWl7o00001_niVkX00ol0003oEVW:oeIYbP02oeIYbPGo00000_leAkL00ol0003o_iZboknJ/P04
oknJ/P05o`000?o0W;?o`9bcol2L/ol000001?oIYj<00ol0003og:VRombYXP04ombYXP03o`000?oN
[:?o000000GofZNR00?o0000omfYX?oMZJ001?oMZJ000ol0003obj6]ol^Q[@06ol^Q[@04o`000?o=
XJ_ocJ6[o`0000KoR7c000Co0000o`0@WOl049go012M0_l000001?l007co0000oa<a[ol00002o`TX
Z@03o`000?nRS[ooXXjo00GoXXjo0_l00002om^[Y@03o`000?oM[jSogJnX00GogJnX00?o0000oooo
ooooool05?ooool2o`00063ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`1:ooooo`;o00001_o<IDX00ol0003od6eAom1]D@04om1]D@;o00001?odh[P00ol0
003omn>cooOS/`02ooOS/`03o`000?ohi;7on>Ba00;o00003_ooool00ol0003oU:7MoiBQg@02oiBQ
g@03o`000?neX/Go]J;500?o]J;500Co0000ojRkionX^nOoZ;_W1_l00002ohRbl@?o00001OmoMkl0
0ol0003obZ2]olZP[@06olZP[@04o`000?o<XJcoc:6/o`0000GodZBX00?o0000omJUYOoFYJD01?oF
YJD00ol0003ofJNSo`000006olbS[P03o`000?oAY:WodJBY00?odJBY0_l00007okVK^P03o`000?mF
JL[oEVW:00;oEVW:1?l000001OleA[Ko0000ocE7]oleAkOo000000Co_iZb00?o0000ol2L/oo0W;<0
0_o0W;<01Ol0003ofJNSomVWXooIYj?o000000Oog:VR00?o0000omj/Xol000001OoJYj800ol0003o
gJVPomfYX004omfYX0;o00001oo;XJd01?l0003ocJ6[olfQZol00006ohQl`0;o00000_l049d01?l0
003o001no`000?l00002oa<a[`03o`000?l9::Wo000000SoXXjo00?o0000om^[YOl000001ooM[jP0
0ol0003og[J^o`00000Fooooo`03o`000?oooooooooo05kooooo00?o003oooooooooool01?ooool0
0ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?ooooo
o`000?ooool00_o=cLd00onIVIWo0000ooooo`1:ooooo`;o00001oo<IDX00ol0003od6eAom1]D@03
om1]D@03o`000?odh[Som>:h00?om>:h00Ko0000ooOS/ooghk?omn>co`000?ohi;42o`00017ooooo
00Co0000oiBQgOl0003o00001oneX/D6o`000003ojRYeol0003o>W?N00;o000000?oR;;ao`000?l0
00001OmoMkl00ol0003obZ2]olZP[@06olZP[@04o`000?o<XJcoc:6/o`0000GodZBX00?o0000omJU
YOoFYJD01?oFYJD00ol0003ofJNSo`000005olbS[P03o`000?oAY:WodJBY00CodJBY00?o0000okVK
^_niVkX01oniVkX00ol0003oEVW:oeIYbP02oeIYbP?o00000_leA[H00ol0003o=DNgo`000003oknJ
/P03o`000?o0W;?o`9bc00?o`9bc00Go0000omVWXooIYj?ofJNSo`000007ombYXP03o`000?oN[:?o
000000GofZNR00?o0000omfYX?oMZJ000ooMZJ000ol0003ogjbOo`000006ol^Q[@03o`000?o=XJ_o
cJ6[00;ocJ6[00?o0000ohQl`?n8O<001?n8O<000ol0003o012Mo`0@W@04o`0000;o4c6_00?o0000
o`TXZOl000002?nRS[l3o`0000OogJnX00?o0000omjf[_l000005oooool00ol0003oooooooooo`1M
ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=
cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0BOooool4
o`0000Koc6E:00?o0000om1]DOo@KE400oo@KE400ol0003om>:hooCR^002ooCR^003o`000?oghk?o
mn>c00;omn>c0_l0000Dooooo`03o`000?neX/Go]J;500Co]J;50ol000000oneX/Go0000o`000005
ojRYe`03o`000?ljLmko>W?N00?o00001_moMkl00ol0003obZ2]olZP[@04olZP[@03o`000?o<XJco
c:6/00;oc:6/00Go0000om:TZ?oBY:SodZBXo`000007omJUY@03o`000?oIYj?o000000Goc:>^00?o
0000om6TZOoAY:T01?oAY:T00ol0003o^I^jokVK^P07okVK^P03o`000?mFJL[oEVW:00;oEVW:1?l0
0002ocE6]P;o00000_noV[800ol0003o`9bcol2L/`05ol2L/`04o`000?oIYj?ofJNSo`0000Kog:VR
00Go0000omj/XooN[:?ogZbSo`000003omZWXP03o`000?oMZJ3ogJVP00CogJVP00?o0000omn/Wol0
00001_o;XJd00ol0003ocJ6[olfQZ`02olfQZ`03o`000?n8O<3oR7c000CoR7c00_l00002o`0@W@04
o`000?l007ko0000o`0000;o4c6_00?o0000o`TXZOl000002?nRS[l2o`0000OogJnX00?o0000omjf
[_l000005oooool00ol0003oooooooooo`1Mooooo`03o`00oooooooooooo00Cooooo00?o003ooooo
ooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo
00;ocLg=00?oVIVIo`000?ooool0BOooool01?l0003oooooooooool00006olaUBP03o`000?o@KE7o
d6eA00;od6eA00?o0000ooCR^?odh[P00oodh[P00ol0003omn>cooOS/`02o`0001Kooooo00?o0000
okFRaOneX/D00_neX/D2o`0000Co]J;500?o0000ojRYeonXZML01OnXZML00ol0003o>W?NocYcgP03
o`0000GoOgNo00?o0000olZP[Oo:X:d01?o:X:d00ol0003oc:6/olbQ[002olbQ[005o`000?oBY:So
dZBXom:TZ?l000001_oFYJD01Ol0003ofJNSomVWXooIYj?o000000?oc:>^00?o0000om6TZOoAY:T0
1?oAY:T00ol0003oe:FVo`000009okVK^P;o00000_mFJLX4o`0000?o=DJf0ol00008ol2L/`03o`00
0?oIYj?o000000Oog:VR00Go0000omj/XooN[:?ogZbSo`000003omZWXP03o`000?oMZJ3ogJVP00Co
gJVP00Co0000omn/WooO[9oo00001?o;XJd00ol0003ocJ6[olfQZ`03olfQZ`03o`000?n8O<3oR7c0
00CoR7c00_l00002o`0@W@Co00000olC<Jl2o`0000KoXXjo1?l00006omf_Z005o`000?oN]Zkog[J^
omjf[_l000005oooool00ol0003oooooooooo`1Looooo`03o`00oooooooooooo00Cooooo00?o003o
ooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003o
oooo00;ocLg=00?oVIVIo`000?ooool0BOooool01Ol0003ooooooooooooooooo000000Koc6E:00Go
0000om1]DOo@KE7od6eAo`000004ooCR^004o`000?oghk?o0000o`0001Wooooo1?l00005okFRa@03
o`000?o1XKSo000000KoZ:WG00Co0000ocYcg_ljLmko>W?N0_l00005ogmg_`03o`000?o:X:gobZ2]
00?obZ2]00?o0000olbQ[?o<XJ`00oo<XJ`01Ol0003odZBXom:TZ?oBY:So000000KoeZFU00Go0000
omVWXooIYj?ofJNSo`000003olbS[P03o`000?oAY:WodJBY00CodJBY00?o0000omBUY_l000002?ni
VkX2o`000004odIH`Ol0003oEVW:oeIYbP?o00001?leA[H00ol0003o`9bcol2L/`07ol2L/`03o`00
0?oIYj?o000000Oog:VR00Go0000omj/XooN[:?ogZbSo`000003omZWXP03o`000?oMZJ3ogJVP00?o
gJVP00Go0000omn/WooO[9oogjbOo`000004ol^Q[@03o`000?o=XJ_ocJ6[00?ocJ6[00?o0000ohQl
`?n8O<001On8O<02o`000005o`0@WOl0003o0000o`00O_l000001?lC<Jl00ol0003oXXjooj:>_`04
o`0000;oY9C500?o0000omf_Z?l000001OoM[jP01Ol0003og[J^omjf[_oN]Zko000001Sooooo00?o
0000ooooooooool0Foooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go
0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0
003ooooo04Wooooo0ol000000ooooooo0000olaUBP05olaUBP04o`000?o@KE7od6eAo`0000Gom>:h
0_l0000Iooooo`?o00001oneX/D01Ol0003o`J6hol6Q^?o1XKSo000000KoZ:WG00?o0000ocYcg_lj
Lmh00_l00006ogmg_`05o`000?o:X:gobZ2]olZP[Ol000001oo<XJ`00ol0003odZBXo`000007omJU
Y@03o`000?oIYj?ofJNS00;ofJNS00Co0000olbS[_o<Xjko00001_oAY:T01?l0003oe:FVomBUY_l0
0006okVK^P03o`000?nkVKKo000000;oAUS100?o0000oeIYb_l000000ol00003ocE6]P03o`000?o0
W;?o`9bc00Oo`9bc00?o0000omVWXol000001_oLZJ800ol0003ogZbSomj/X`03omj/X`03o`000?oJ
Yj;o000000KogJVP00Go0000omn/WooO[9oogjbOo`000003ol^Q[@03o`000?o=XJ_ocJ6[00GocJ6[
00?o0000ohQl`?n8O<001?n8O<001Ol0003o00fJo`000?l0003o002600?o00001?lC<Jl2o`0000Oo
Y9C500?o0000omf_Z?l000000ooM[jP00ol0003og[J^omjf[P02omjf[P03o`000?oooooooooo01Ko
oooo00?o0000ooooooooool0Foooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo03Kooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`05
o`000?ooooooooooooooool000001_o<IDX01Ol0003od6eAom1]DOl0003om>:h00Co00006?ooool3
o`0000?ooooo00?o0000okFRaOneX/D00oneX/D00ol0003o`J6hol6Q^002ol6Q^003o`000?nXZMOo
Z:WG00CoZ:WG0ol000000oljLmko0000o`000005ogmg_`05o`000?o:X:gobZ2]olZP[Ol000001oo<
XJ`00ol0003odZBXo`000006omJUY@03o`000?oIYj?ofJNS00?ofJNS00?o0000olbS[_l000001_oA
Y:T01Ol0003oe:FVomBUY_oDYJKo000000Go^I^j00Go0000ok^I]_nkVKKo^iVfo`000002odIH`@Go
00001?leA[H00ol0003o`9bcol2L/`07ol2L/`03o`000?oLZJ;og:VR00Gog:VR00?o0000omj/XooN
[:<00ooN[:<00ol0003ofZNRo`000006omfYX003o`000?oO[9oogjbO00;ogjbO00Co0000ol^Q[Oo;
XJgo00001oo=XJ/5o`0000;oR7c000Co0000o`0=V_l0003o012M0_l000000ol007ko0000oa<a[`03
oa<a[`03o`000?nTU<GoY9C500KoY9C500Co0000omf_Z?oM[jSo00000_oM[jP00ol0003og[J^omjf
[P03omjf[P03o`000?oooooooooo01Kooooo00?o0000ooooooooool0F_ooool00ol00?oooooooooo
o`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo
00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo03Gooooo00Co0000oooooooooooo0000
1oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00_ooool00ol0003o
c6E:olaUBP03olaUBPKo00006?ooool3o`0000Kooooo00?o0000okFRaOneX/D00_neX/D00ol0003o
`J6hol6Q^004ol6Q^003o`000?nXZMOoZ:WG00?o000000?oYYc<o`000?l0=;X00ol00005ogmg_`04
o`000?o:X:gobZ2]o`0000Soc:6/00?o0000om:TZ?l000001_oFYJD00ol0003ofJNSomVWX`03omVW
X`03o`000?o<Xjko000000KodJBY00Go0000omBUY_oDYJKoe:FVo`000004okVK^P03o`000?nkVKKo
^iVf00;o^iVf00Co0000odIH`Om6F<7oAUS11?l00004ocE6]P03o`000?o0W;?o`9bc00Oo`9bc00?o
0000ombYX_oLZJ801OoLZJ800ol0003ogZbSomj/X`03omj/X`03o`000?oJYj;o000000KogJVP00?o
0000omn/WooO[9l00_oO[9l00ol0003obj6]o`000008olfQZ`03o`000?n6N[koQWZn00;oQWZn1?l0
00001?l03I[o0000o`000?l008H3o`0000Co4c6_00?o0000ojBDaOnTU<D01OnTU<D01?l0003ogJnX
omf_Z?l00002omf_Z003o`000?oN]Zkog[J^00?og[J^00?o0000ooooooooool05Oooool3o`0005_o
oooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=
cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`0eooooo`04
o`000?ooooooooooo`0000_ooooo00Co0000oooooooooooooooo0ol00003ooooo`03o`000?o<ID[o
c6E:00Ko00006?ooool3o`0000[ooooo00Co0000okFRaOneX/Go00002?o1XKP2o`0000GoYYc<00Co
0000o`0d^_l0003o00001OmoMkl01?l0003obZ2]olZP[Ol00009olbQ[003o`000?oFYJGoeZFU00Co
eZFU00?o0000omVWXooIYj<01OoIYj<00ol0003odJBYom6TZ@04om6TZ@03o`000?oDYJKoe:FV00?o
e:FV00Co0000okVK^_niVk[o00001OnkVKH00ol0003oAUS1odIH`@02odIH`@Co00000oleA[H00ol0
003o`9bcol2L/`07ol2L/`03o`000?oLZJ;og:VR00Cog:VR00?o0000omj/XooN[:<01OoN[:<00ol0
003ogJVPomfYX004omfYX003o`000?oO[9oogjbO00?ogjbO00?o0000ol^Q[Ol000001oo=XJ/00ol0
003ocj>[o`000006ohIj_P07o`000?l03I[o0000o`000?l008Ko0000o`00OP02o`0000?o4c6_00?o
0000ojBDaOnTU<D01_nTU<D00ol0003ogJnXomf_Z002o`0000Kog[J^00?o0000ooooooooool04_oo
ool3o`0000;ooooo00?o0000ooooooooool0FOooool00ol00?ooooooooooo`04ooooo`03o`00oooo
oooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000oooo
o`02olg=c@03oiVIVOl0003ooooo03Gooooo00Co0000oooooooooooo00002oooool01Ol0003ooooo
oooooooooooo000000Kooooo0ol0000Jooooo`?o00003Oooool00ol0003o]J;5o`000009ol6Q^003
o`000?nVW<coYYc<00CoYYc<00?o0000o`0d^_l0=;X01Ol00002ogmg_`;o00002_o<XJ`00ol0003o
eZFUomJUY@04omJUY@03o`000?oIYj?ofJNS00GofJNS00?o0000om6TZOoAY:T01?oAY:T00ol0003o
e:FVomBUYP03omBUYP03o`000?niVk[o000000Oo^iVf00Ko0000odIH`Om6F<7oAUS1o`000?l005h3
o`0000?o=DJf00?o0000ol2L/oo0W;<01Oo0W;<00ol0003o`Info`000005ombYXP03o`000?oN[:?o
gZbS00GogZbS00?o0000omfYX?oMZJ001?oMZJ000ol0003ogjbOomn/W`04omn/W`03o`000?o=XJ_o
cJ6[00KocJ6[00?o0000olnSZol000001_n6N[h2o`000004o`0=V_l0003o0026o`00QP;o000000Go
9D2go`000?lC<Joo4c6_o`000008ojBDa@05o`000?oM[jSogJnXomf_Z?l000001ooN]Zh00ol0003o
ooooooooo`0>ooooo`?o00001Oooool00ol0003oooooooooo`1Iooooo`03o`00oooooooooooo00Co
oooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003
ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0=Oooool01?l0003oooooooooool00007oooo
o`Co00001?ooool00ol0003oooooooooo`0Oooooo`;o00004Oooool00ol0003o`J6hol6Q^007ol6Q
^003o`000?o7XK7o000000KoYYc<00Co0000o`0d^_l0003o00000omnM;h3o`0000[oc:6/0_l00006
omJUY@03o`000?oIYj?ofJNS00CofJNS0_l00006om6TZ@03o`000?oDYJKoe:FV00Coe:FV00?o0000
ok^I]_nkVKH01_nkVKH00ol0003oAUS1odIH`@02odIH`@?o000000Go>T^io`000?leA[Ko=DJfo`00
0006ol2L/`04o`000?o1WkKo`Info`0000Gog:VR00?o0000omj/XooN[:<01OoN[:<00ol0003ogJVP
omfYX004omfYX003o`000?oO[9oogjbO00CogjbO00?o0000olfQZoo=XJ/01Oo=XJ/01?l0003ocj>[
olnSZol00007ohIj_P05o`000?l03I[o0000o`000?l008H00_l00002obE0]`04o`000?lC<Joo4c6_
o`0000SoY9C500Go0000omf_Z?l0003og[J^o`000006omjf[P03o`000?oooooooooo00[ooooo1?l0
0008ooooo`03o`000?oooooooooo05Wooooo00?o003oooooooooool01?ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`0eooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool0
1Oooool2o`0001gooooo0ol0000Cooooo`03o`000?o1XKSo`J6h00Ko`J6h00Co0000olNQ/Oo7XK7o
00001onVW<`01?l0003o03Bjo`000?l00004ogid_P03o`000?o<XJcoc:6/00Soc:6/00?o0000oljS
[?l000001?oFYJD00ol0003ofJNSomVWX`05omVWX`03o`000?oKZJ?o000000CodJBY00?o0000omBU
Y_oDYJH01OoDYJH00ol0003o^iVfok^I]P06ok^I]P03o`000?m6F<7oAUS100;oAUS11?l000001?lj
BkWo0000ocE6]_l00005ol2L/`05o`000?o1WkKo`Infol6O]_l000001?oLZJ800ol0003ogZbSomj/
X`05omj/X`03o`000?oP/JKo000000GogJVP00?o0000omn/WooO[9l01?oO[9l2o`0000KocJ6[00Go
0000olnSZoo?Xj_ocj>[o`000006ohIj_P;o000000Co00fJo`000?l008Ko00260_l00002obE0]`03
o`000?lC<Joo000000SoY9C500Go0000omf_Z?l0003og[J^o`000005omjf[P03o`000?oO`;Wo0000
00Sooooo0ol0000=ooooo`03o`000?oooooooooo05Sooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`0fooooo`;o00002?ooool5o`0000?ooooo00?o0000oooo
ooooool06Oooool3o`0001Oooooo00?o0000ol6Q^?o1XKP01Oo1XKP01Ol0003oaj6aolNQ/Oo7XK7o
000000KoYYc<00Co0000o`0d^_l0003o00001OmnM;h00ol0003oc:6/olbQ[006olbQ[004o`000?o>
XjcocZ>/o`0000CoeZFU00?o0000omVWXooIYj<01OoIYj<00ol0003ofjVSo`000004om6TZ@03o`00
0?oDYJKoe:FV00Coe:FV00?o0000omNVYOl000002?nkVKH01_l0003oAUS1odIH`Om6F<7o0000o`00
GP;o00000_ljBkT00ol0003o=DJfo`000003ol2L/`03o`000?o1WkKo`Inf00?o`Inf00Go0000ombY
X_oLZJ;og:VRo`000007omj/X`03o`000?oP/JKo000000CogJVP00?o0000omn/WooO[9l01?oO[9l0
0ol0003ohZnQo`000006olfQZ`05o`000?o?Xj_ocj>[olnSZol000001_n6N[h2o`000004o`0=V_l0
003o0026o`00QP;o00000olU@;L00ol0003o4c6_o`000007ojBDa@03o`000?oM[jSo000000;og[J^
00?o0000omjf[_oN]Zh00_oN]Zh00ol0003ogl2io`000005ooooo`?o00004?ooool00ol0003ooooo
ooooo`1Hooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003ooooo
olg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0
B?ooool00ol0003oooooooooo`0Fooooo`?o00006_ooool00ol0003o`J6hol6Q^004ol6Q^003o`00
0?o7XK7oaj6a00?oaj6a00?o0000ojJLc?nVW<`00onVW<`4o`0000GoOWBn00?o0000olbQ[?o<XJ`0
1Oo<XJ`01Ol0003ocZ>/oljS[?o>Xjco000000?oeZFU00?o0000omVWXooIYj<01OoIYj<01?l0003o
fjVSom^YXol00004om6TZ@03o`000?oDYJKoe:FV00Coe:FV00?o0000omNVYOl000002?nkVKH2o`00
00?oAUS10ol00003ocY;^@;o00000_o0W;<00ol0003o`Infol6O]P04ol6O]P05o`000?oLZJ;og:VR
ombYX_l000001ooN[:<00ol0003oh;6Vo`000004omfYX003o`000?oO[9oogjbO00CogjbO00?o0000
on:_XOl000001Oo=XJ/00ol0003ocj>[olnSZ`02olnSZ`03o`000?n6N[koQWZn00CoQWZn00Go0000
o`0AW?l0003o00fJo`000002o`00QP03o`000?lU@;Oo9D2g00;o9D2g0_l00006ojBDa@?o00001?oN
]Zh01?l0003og[J^omjf[_l00002omo0^@03o`000?oooooo000000?o00004oooool00ol0003ooooo
ooooo`1Hooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003ooooo
olg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0
B?ooool2o`0001Cooooo0ol0000Nooooo`03o`000?o1XKSo`J6h00;o`J6h00?o0000olNQ/Oo7XK40
1?o7XK400ol0003oYYc<ojJLc003o`000003ojBCa?l0003o03Bj00;o00001?mnM;h00ol0003oc:6/
olbQ[005olbQ[003o`000?o>XjcocZ>/00;ocZ>/00Co0000omJUYOoFYJGo00001ooIYj<01Ol0003o
fjVSom^YXooKZJ?o000000;odJBY00?o0000omBUY_oDYJH01OoDYJH00ol0003oejJUo`000008ok^I
]P03o`000?lmC[[o000000;oAUS100Co0000o`00G_l0003o00000oljBkT00ol0003o`9bco`000007
ol6O]P04o`000?oLZJ;og:VRo`0000OogZbS00Go0000on2aY_oP/JKoh;6Vo`000003omfYX003o`00
0?oO[9oogjbO00CogjbO00Co0000on:_XOoR[j7o00001?o=XJ/00ol0003ocj>[olnSZ`03olnSZ`03
o`000?n6N[koQWZn00CoQWZn0_l000001?l03I[o0000o`000?l008H2o`0000Co9D2g00?o0000ojBD
aOnTU<D01?l00002ojFNcP03o`000?oN]Zkog[J^00;og[J^00?o0000omjf[_l000001?oO`;T00ol0
003oooooooooo`0Eooooo`03o`000?oooooooooo05Sooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`17ooooo`;o00004_ooool3o`00027ooooo00Go0000ol6Q
^?o1XKSo`J6ho`000008olNQ/@;o00001OnTTl@3o`0000GoOWBn00?o0000olbQ[?o<XJ`00oo<XJ`0
0ol0003ocZ>/oljS[003oljS[004o`000?oFYJGoeZFUo`0000OofJNS00Go0000om^YXooKZJ?ofjVS
o`000002om6TZ@03o`000?oDYJKoe:FV00Coe:FV00Go0000omNVYOoGYZGoejJUo`000006ok^I]P06
o`000?nlVK?o0000oce>^_l0003oAUS11?l00004ocY;^@03o`000?o1WkKo`Inf00Oo`Inf00?o0000
ombYX_l000001ooN[:<01Ol0003oh;6Von2aY_oP/JKo000000;ogJVP00?o0000omn/WooO[9l01?oO
[9l01Ol0003ohZnQon:_XOoR[j7o000000?ocJ6[00?o0000olnSZoo?Xj/01?o?Xj/00ol0003oQWZn
ohIj_P04ohIj_P03o`000?l04Ico000000;o00000_l008H00ol0003o9D2gobE0]`03obE0]`;o0000
1onUW/h00ol0003og[J^omjf[P02omjf[P;o00001?oO`;T00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo05Sooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`17ooooo`03o`000?oooooooooo00oooooo0_l0000Uooooo`04o`000?o1XKSo`J6ho`0000So
aj6a00?o0000ojBCa?nTTl@01?nTTl@3o`0000GoOWBn00?o0000olbQ[?o<XJ`00oo<XJ`00ol0003o
cZ>/oljS[003oljS[003o`000?oFYJGo000000OofJNS00?o0000om^YXooKZJ<00_oKZJ<00ol0003o
dJBYo`000007omBUYP05o`000?oGYZGoejJUomNVYOl000001OnkVKH01?l0003o_9VcokbI/ol00002
oce>^P03o`000?m6F<7o000000;o00001?ljBkT00ol0003o`Infol6O]P07ol6O]P03o`000?oLZJ;o
000000OogZbS00Go0000on2aY_oP/JKoh;6Vo`000002omfYX003o`000?oO[9oogjbO00CogjbO00Go
0000on:_XOoR[j7ohZnQo`000003olfQZ`03o`000?o?Xj_ocj>[00Cocj>[00?o0000ohIj__n6N[h0
1?n6N[h00ol0003o016Lo`0AW003o`000003o`00Q_l0003o9D2g00Co9D2g00?o0000ojFNc_nUW/h0
1_nUW/h00ol0003og[J^omjf[P02omjf[P;o00001OoO`;T00ol0003oooooooooo`0Dooooo`03o`00
0?oooooooooo05Sooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`17ooooo`03o`000?oooooooooo00cooooo0ol0000Wooooo`03o`000?o1XKSo000000Soaj6a
00?o0000ol^Q[Ol000001_nTTl@3o`0000CoOWBn00?o0000olbQ[?o<XJ`00_o<XJ`00ol0003ocZ>/
oljS[004oljS[003o`000?oFYJGo000000OofJNS00?o0000om^YXooKZJ<00_oKZJ<00ol0003odJBY
o`000007omBUYP05o`000?oGYZGoejJUomNVYOl000001?nkVKH01Ol0003o_9VcokbI/onlVK?o0000
00?o?Djj1Ol00004ocY;^@03o`000?o1WkKo`Inf00Ko`Inf0_l00007omj/X`03o`000?oP/JKoh;6V
00?oh;6V00?o0000omfYX?l000001_oO[9l00ol0003ohZnQon:_X@02on:_X@03o`000?o=XJ_o0000
00Socj>[00?o0000ohIj__n6N[h00on6N[h00ol0003o016Lo`0AW002o`000003o`04U?l0003o0026
00;o00001?lU@;L00ol0003oYIk>ojFNcP05ojFNcP03o`000?oN]Zkog[J^00;og[J^00?o0000omo0
^Ol000001?oO`;T00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo05Sooooo00?o003ooooo
ooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001
ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`17ooooo`;o00002_ooool3o`00
02_ooooo00?o0000olNQ/Oo7XK401oo7XK400ol0003obj6]o`000006ojBCa0?o00001OmnM;h01Ol0
003oc:6/olbQ[?o<XJco000000OocZ>/0_l00007omVWX`03o`000?oKZJ?ofjVS00?ofjVS0_l00006
omBUYP03o`000?oGYZGoejJU00?oejJU00Go0000ok^I]_nkVKKo^iVfo`000004okbI/`04o`000?lm
C[[o?Djjoce>^PCo00001?ljBkT00ol0003o`Infol6O]P07ol6O]P03o`000?oN[:?ogZbS00GogZbS
00?o0000on2aY_oP/JH00ooP/JH00ol0003ogJVPo`000006omn/W`03o`000?oR[j7ohZnQ00;ohZnQ
00?o0000olfQZol000002?o?Xj/5o`0000;oQWZn00[o0000o`0AW?l04Ico0000o`04U?l0003o0026
o`000?lnElCo00000olU@;L00ol0003oYIk>ojFNcP06ojFNcP04o`000?oN]Zkog[J^o`0000;ogl2i
00?o0000omo0^OoO`;T00_oO`;T00ol0003oooooooooo`0<ooooo`?o00001_ooool00ol0003ooooo
ooooo`1Gooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003ooooo
olg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0
Aoooool00ol0003oooooooooo`06ooooo`?o0000;_ooool00ol0003oaj6aolNQ/@06olNQ/@04o`00
0?o;XJgobj6]o`0000OoY9?40_l00005ogid_P04o`000?o<XJcoc:6/o`0000SocZ>/00?o0000omVW
XooIYj<01OoIYj<00ol0003ofjVSom^YX`04om^YX`03o`000?oDYJKoe:FV00Goe:FV00?o0000omNV
YOoGYZD00ooGYZD01?l0003o^iVfok^I]_l00005okbI/`03o`000?lmC[[o?Djj00;o?Djj0ol00004
ocY;^@03o`000?o1WkKo`Inf00Oo`Inf00?o0000omj/XooN[:<01?oN[:<00ol0003oh;6Von2aYP04
on2aYP;o00001_oO[9l00ol0003ohZnQon:_X@03on:_X@03o`000?o=XJ_o000000Socj>[00?o0000
ohIj__n6N[h00_n6N[h3o`0000;o016L0_l000001_l019Co0000o`00Q_l0003o?UO4o`0000;o9D2g
00?o0000ojFNc_nUW/h01_nUW/h00ol0003og[J^o`000004omo0^@03o`000?oO`;Wogl2i00;ogl2i
00?o0000ooooooooool02?ooool3o`000003oa000?l0003o000000Kooooo00?o0000ooooooooool0
Eoooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgo
cLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo04Oooooo
0_l00004ooooo`?o0000<_ooool00ol0003oaj6aolNQ/@05olNQ/@05o`000?o;XJgobj6]ol^Q[Ol0
00001_nTTl@5o`0000;oOWBn00?o0000olbQ[?l000002Oo>Xj`00ol0003ofJNSomVWX`05omVWX`03
o`000?oKZJ?ofjVS00CofjVS00?o0000omBUY_oDYJH01OoDYJH00ol0003oejJUomNVY@03omNVY@03
o`000?nkVKKo000000Oo_9Vc00Co0000oce>^_lmC[[o?Djj1Ol00003ocY;^@03o`000?o1WkKo`Inf
00Go`Inf00?o0000ol:U_?l000001OoN[:<00ol0003oh;6Von2aYP05on2aYP03o`000?oO[9oogjbO
00CogjbO00?o0000on:_XOoR[j401?oR[j400ol0003ocj>[olnSZ`06olnSZ`03o`000?oAYZco0000
00GoQWZn00Go0000o`0AW?l04Ico016Lo`000002o`04U0;o00000_lnEl@2o`000003obE0]ol0003o
YIk>00KoYIk>00?o0000omjf[_l000001OoO`;T01Ol0003ogl2iomo0^OoO`;Wo000000Oooooo1ol0
0002olmF6003o`000?oooooooooo00?ooooo00?o0000ooooooooool0Eoooool00ol00?oooooooooo
o`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo
00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo04Kooooo0_l00002ooooo`?o0000=Ooo
ool00ol0003oaj6aolNQ/@04olNQ/@03o`000?o;XJgobj6]00;obj6]00?o0000ojBCa?nTTl@01?nT
Tl@3o`0000;oOWFo1Ol00008oljS[003o`000?o?YJgo000000GofJNS00?o0000om^YXooKZJ<01OoK
ZJ<2o`0000Goe:FV00?o0000omNVYOoGYZD01OoGYZD00ol0003o_9VcokbI/`06okbI/`03o`000?lm
C[[o?Djj00;o?Djj0ol000001Om4EKoo0000ocY;^OljBkWo000000Ko`Inf00Co0000ol:U_?o2YKco
00001OoN[:<00ol0003oh;6Von2aYP05on2aYP03o`000?oO[9oogjbO00CogjbO00?o0000on:_XOoR
[j401?oR[j400ol0003ocj>[olnSZ`06olnSZ`03o`000?oAYZco000000KoQWZn00Co0000o`0AW?l0
4Ico00000_l019@00ol0003o0026o`000003ociGa0;o00001_nUW/h3o`0000Oogl2i00Go0000omo0
^Ol0003og=3=o`000005ooooo`Co00000_ld0002o`0000?oceHH00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`1Gooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool0
1Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVI
o`000?ooool0?_ooool3o`0000Gooooo1?l0000hooooo`03o`000?o7XK7oaj6a00?oaj6a00?o0000
ol^Q[Oo;XJd00oo;XJd01?l0003oY9?4ojBCa?nTTl@3o`000004oj>>_ol0003o0000o`0000CoOWFo
00?o0000oljS[?o>Xj`01oo>Xj`00ol0003ocjF]o`000005omVWX`03o`000?oKZJ?ofjVS00CofjVS
00?o0000omf/Y?l000001OoDYJH00ol0003oejJUomNVY@05omNVY@03o`000?nlVK?o_9Vc00Ko_9Vc
00?o0000oce>^_lmC[X00_lmC[X4o`000004odAE_ol0003o>T^io`0000Go`Inf00Go0000ol:U_?o2
YKco`ZFlo`000004omj/X`03o`000?oP/JKoh;6V00Goh;6V00?o0000on:gZol000001OoO[9l00ol0
003ohZnQon:_X@03on:_X@03o`000?oT]:Co000000Kocj>[00Co0000om6V[?oAYZco00001_n6N[h2
o`0000;o016L00?o0000o`04U?l019@00_l00004ociGa003o`000?nUW/koYIk>00Co00000_nW[M/0
0ol0003ogl2iomo0^@05omo0^@;o00000_oLd<d00ol0003oooooooooo`03ooooo`03o`000?ld003o
=00000?o00000_o@G2L01Ol0003oceHHolmF6?o?EQSo000000?ooooo00?o0000ooooooooool0Eooo
ool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=
oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo03oooooo00?o
0000ooooooooool01?ooool2o`0003_ooooo00?o0000olNQ/Oo7XK400_o7XK400ol0003obj6]ol^Q
[@04ol^Q[@?o00001?nSS[l3o`0000CoOWFo00?o0000oljS[?o>Xj`01_o>Xj`01?l0003ocjF]olnU
[Ol00005omVWX`03o`000?oKZJ?ofjVS00CofjVS00?o0000omf/Y?l000001OoDYJH00ol0003oejJU
omNVY@04omNVY@;o00002OnlVK<01?l0003o?Djjoce>^_lmC[X2o`000007o`00Jol0003oA5FoodAE
_ol0003o>T^io`000003ol6O]P03o`000?o2YKco`ZFl00?o`ZFl00Go0000omj/XooN[:?ogZbSo`00
0007on2aYP03o`000?oR]j_o000000CogjbO00?o0000on:_XOoR[j401?oR[j400ol0003oi;BTo`00
0006olnSZ`05o`000?oAYZcodJJ/om6V[?l000001On6N[h2o`0000;o016L00Go0000o`04U?l019Co
00BDo`000005ociGa0;o00001onW[M/00ol0003ogl2iomo0^@04omo0^@;o00000_oLd<d00ol0003o
ooooooooo`02ooooo`Co00000_m200001Ol0003od5`Wom1L9oo@G2Oo000000?oceHH00Co0000oooo
oooooooo0000FOooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000
ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003o
oooo03oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0hooooo`05o`000?o7XK7o
aj6aolNQ/Ol000001oo;XJd00ol0003oXhjooj>>_`05oj>>_`;o00001OmnMKl00ol0003ocZ>/oljS
[005oljS[005o`000?o?YJgocjF]olnU[Ol000000ooIYj<00ol0003ofjVSom^YX`05om^YX`04o`00
0?oM[:CogJbTo`0000?oe:FV00?o0000omNVYOoGYZD01OoGYZD00ol0003ofJRUo`000008okbI/`;o
00000olmC[X3o`0000?oA5Fo0_l00002ol6O]P03o`000?o2YKco`ZFl00Co`ZFl00Go0000omj/XooN
[:?ogZbSo`000007on2aYP03o`000?oR]j_o000000CogjbO00?o0000on:_XOoR[j401?oR[j400ol0
003oi;BTo`000005olnSZ`03o`000?oAYZcodJJ/00;odJJ/00?o0000ohIj__n6N[h01?n6N[h2o`00
00;o016L00?o0000o`04U?l019@00_l00004ociGa003o`000?nW[M_oYjgK00OoYjgK00?o0000omo0
^OoO`;T00_oO`;T01?l0003og=3=omc@cOl00002omc@c@03o`000?oooooooooo00;o00001?m20000
0ol0003ocU/]o`000003om1L9`04o`000?o?EQSoceHHo`0000?ooooo00?o0000ooooooooool0E_oo
ool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=
oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo03oooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`0hooooo`04o`000?o7XK7oaj6ao`0000Oobj6]
00?o0000oj>>_onSS[l01OnSS[l3o`0000CoOWFo00?o0000oljS[?o>Xj`01?o>Xj`00ol0003ocjF]
olnU[@02olnU[@05o`000?oIYj?ofJNSomVWXol000001_oKZJ<01Ol0003ogJbTomf/Y?oM[:Co0000
00?oe:FV00?o0000omNVYOoGYZD01OoGYZD00ol0003ofJRUo`000007okbI/`04o`000?nnVK;o0000
o`0000;o?Djj1?l00003odAE_`03o`000?o1WkKo000000So`ZFl00?o0000omj/Xol000001ooP/JH0
1Ol0003oh[N[on:gZooR]j_o000000?ogjbO00?o0000on:_XOoR[j400ooR[j401Ol0003oi;BTonBd
Y?oT]:Co000000Cocj>[00?o0000om6V[?oAYZ`00_oAYZ`00ol0003oQWZnohIj_P04ohIj_P04o`00
0?l07:?o0000o`0AW0;o00000_l019@00ol0003o?UO4ociGa003ociGa003o`000?nW[M_oYjgK00Ko
YjgK00Go0000omo0^OoO`;Wogl2io`000004omc@c@03o`000?oLd<go000000;ooooo00?o0000od80
0?m200000ol00003oliK;@05o`000?o@G2Ood5`Wom1L9ol000000_o?EQP01?l0003oooooooooool0
001Hooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0?ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo03Oooooo00?o0000olNQ/Ol000001oo;
XJd00ol0003ocZ6[o`000006oj>>_`?o00001?mnMKl00ol0003ocZ>/oljS[004oljS[003o`000?o?
YJgocjF]00;ocjF]00Go0000omVWXooIYj?ofJNSo`000006om^YX`05o`000?oM[:CogJbTomf/Y?l0
00000ooDYJH00ol0003oejJUomNVY@04omNVY@04o`000?oIZ:GofJRUo`0000Ko_9Vc00Oo0000okjI
/_nnVK;o0000ocY9^?l0003o?Djj00;o000000?o001[o`000?m4EKl00om4EKl00ol0003o`ZFlol:U
_007ol:U_003o`000?oN[:?o000000Ooh;6V00Go0000on:gZooR]j_oh[N[o`000002omn/W`03o`00
0?oR[j7ohZnQ00CohZnQ00Go0000onBdY?oT]:Coi;BTo`000004olnSZ`03o`000?oAYZcodJJ/00?o
dJJ/00?o0000ohIj__n6N[h00on6N[h00ol0003o01bSo`0LX`02o`000004o`0PYol0003o00BDo`04
U0;o00000olnEl@00ol0003oYjgKojN]f`07ojN]f`03o`000?oO`;Wo000000Gog=3=00Co0000omc@
cOl0003ooooo1?l00002od@00003o`000?o>FbgocU/]00;ocU/]00Go0000om1L9oo@G2Ood5`Wo`00
0002olmF6003o`000?oooooo000005Sooooo00?o003oooooooooool01?ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`0nooooo`;o00002oooool2o`0003Oooooo00?o0000olNQ/Ol000001oo;
XJd00ol0003ocZ6[o`000007oj>>_`;o00001OmnMKl00ol0003ocZ>/oljS[002oljS[003o`000?o?
YJgocjF]00CocjF]00?o0000omVWXol000001ooKZJ<00ol0003ogJbTomf/Y002omf/Y003o`000?oD
YJKo000000OoejJU00Go0000omVXYOoIZ:GofJRUo`000004okbI/`05o`000?nnVK;o_YVbokjI/_l0
00000_ljBKP00ol0003o?Djjo`000002o`0000CoA5Fo00?o0000ol:U_?o2YK`01oo2YK`00ol0003o
gZbSo`000006on2aYP03o`000?oR]j_oh[N[00;oh[N[00Co0000omn/WooO[9oo00001_oR[j401Ol0
003oi;BTonBdY?oT]:Co000000?ocj>[00?o0000om6V[?oAYZ`01?oAYZ`00ol0003oQWZnohIj_P04
ohIj_P04o`000?l07:?o0000o`0AW0;o00000_l019@01?l0003oHGSCo`000?l00002ociGa003o`00
0?nW[M_oYjgK00KoYjgK0_l00007omc@c@Co00001?m400000ol0003obEH[o`000003oliK;@05o`00
0?o@G2Ood5`Wom1L9ol000000oo?EQP2o`0005Sooooo00?o003oooooooooool01?ooool00ol00?oo
ooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?oo
ool00_o=cLd00onIVIWo0000ooooo`0oooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool0=Oooool00ol0003obj6]ol^Q[@05ol^Q[@05o`000?o>XJ_ocZ6[oljQZol000001_nSS[l3o`00
00CoOWFo00?o0000oljS[?o>Xj`00_o>Xj`00ol0003ocjF]olnU[@04olnU[@03o`000?oIYj?o0000
00KofjVS00?o0000omf/Y?oM[:@00ooM[:@00ol0003oe:FVo`000007omNVY@05o`000?oIZ:GofJRU
omVXYOl000000onlVK<00ol0003o_YVbokjI/P03okjI/P03o`000?ljBKSo>TVh00?o000000?o001[
o`000?m4EKl00om4EKl00ol0003o`ZFlol:U_007ol:U_003o`000?oP/JKoh;6V00Goh;6V00?o0000
on:gZooR]j/00ooR]j/00ol0003ogjbOo`000005on:_X@03o`000?oT]:Coi;BT00?oi;BT00Co0000
olnSZoo?Xj_o00001_oAYZ`00ol0003oQWZnohIj_P04ohIj_P03o`000?l07:?o01bS00;o000000Go
022Wo`000?l019Co00BDo`000002of5hd`;o000000?o?UO4o`000?nW[M/00onW[M/3o`000003ojK2
k_l0003og=3=00Kog=3=0ol00005od@00004o`000?o9ER_obEH[o`0000?ocU/]00Go0000om1L9oo@
G2Ood5`Wo`000003olmF6003o`000?oooooooooo05Kooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`1>ooooo`03o`000?oooooooooo03Cooooo00?o0000ol^Q
[Oo;XJd01Oo;XJd01Ol0003ocZ6[oljQZoo>XJ_o000000KoXhjo0ol00004ogie_`05o`000?o>Xjco
cZ>/oljS[?l000001oo?YJd00ol0003ofJNSo`000006om^YX`03o`000?oM[:CogJbT00?ogJbT00?o
0000omBUY_l000001_oGYZD00ol0003ofJRUomVXY@02omVXY@04o`000?nlVK?o_9Vco`0000Ko_YVb
00Co0000ocY9^?ljBKSo>TVh1?l00004odAE_`03o`000?o2YKco`ZFl00Ko`ZFl0_l00006on2aYP03
o`000?oR]j_oh[N[00Coh[N[00?o0000omn/Wol000001OoR[j400ol0003oi;BTonBdY003onBdY003
o`000?o?Xj_o000000SodJJ/1Ol000000on6N[ko0000o`0LX`02o`0LX`;o000000Co022Wo`000?l0
19Co00001?mQN=<2o`000004ojN]fol0003o0000o`0000GoY/;^00?o0000omc@cOoLd<d00_oLd<d2
o`000003olCXkol0003oa>S_00Go00000oo9ER/00ol0003ocU/]oliK;@02oliK;@05o`000?o@G2Oo
d5`Wom1L9ol000000_o?EQP00ol0003oooooooooo`1Fooooo`03o`00oooooooooooo00Cooooo00?o
003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0Coooool00ol0003oooooooooo`0cooooo`03o`000?o;
XJgobj6]00Cobj6]00?o0000oljQZoo>XJ/00_o>XJ/00ol0003oXhjooj>>_`05oj>>_`;o00001Omn
MKl01?l0003ocZ>/oljS[?l00008olnU[@03o`000?oKZJ?ofjVS00GofjVS00?o0000omf/Y?oM[:@0
1?oM[:@00ol0003oejJUomNVY@05omNVY@03o`000?oIZ:GofJRU00?ofJRU0_l00007okjI/P03o`00
0?ljBKSo>TVh00;o>TVh0ol00005odAE_`03o`000?o2YKco`ZFl00Co`ZFl00Co0000ol:]aOo2[LGo
00001OoP/JH00ol0003oh[N[on:gZ`04on:gZ`;o00001_oR[j400ol0003oi;BTonBdY003onBdY003
o`000?o?Xj_o000000SodJJ/00?o0000ohMl`?n7O<000_n7O<03o`0000;o01bS0_l00002o`0PY`;o
00001_mQN=<00ol0003oY/;^ojK2kP07ojK2kP04o`000?oLd<gog=3=o`0000Coa>S_0_l00002oc/0
00;o00001?o9ER/00ol0003ocU/]oliK;@02oliK;@04o`000?o@G2Ood5`Wom1L9`?o0000F?ooool0
0ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVI
V@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo053ooooo0_l0000d
ooooo`03o`000?o;XJgobj6]00?obj6]00?o0000oljQZoo>XJ/00oo>XJ/00ol0003oXhjooj>>_`03
oj>>_`Ko00000_mnMKl00ol0003ocZ>/o`000009olnU[@03o`000?oKZJ?ofjVS00CofjVS00?o0000
omf/Y?oM[:@01OoM[:@00ol0003oejJUomNVY@05omNVY@03o`000?oIZ:GofJRU00?ofJRU00?o0000
okjI/_nnVK801onnVK801?l0003o>TVhocY9^?ljBKP5o`0000?oA5Fo00?o0000ol:U_?o2YK`00oo2
YK`01Ol0003o`Zg5ol:]aOo2[LGo000000Goh;6V00?o0000on:gZooR]j/01OoR]j/00ol0003ohZnQ
on:_X@03on:_X@03o`000?oT]:Coi;BT00Goi;BT00?o0000om6V[?oAYZ`01_oAYZ`2o`0000KoQgc0
00Go0000o`0LXol07:?o01bSo`000002o`0PY`03o`000?l019Co000000GoHGSC00?o0000ojK2k_nV
`^h01onV`^h00ol0003og=3=o`000006olCXk`?o00000_o1B2000ol0003obEH[olUF:`02olUF:`05
o`000?o>FbgocU/]oliK;Ol000001?o@G2L00ol0003oooooo`00001Gooooo`03o`00oooooooooooo
00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool0
0003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0D_ooool00ol0003oooooooooo`0aoooo
o`03o`000?o;XJgobj6]00;obj6]00?o0000oljQZoo>XJ/01?o>XJ/00ol0003oXhjooj>>_`03o`00
0004oj>;_?l0003o0000o`0000;oP7W20ol000000oo>Xjco0000olnU[@07olnU[@03o`000?o@ZK7o
000000GofjVS00?o0000omf/Y?oM[:@01?oM[:@00ol0003ogZnVo`000005omNVY@03o`000?oIZ:Go
fJRU00CofJRU00?o0000okjI/_nnVK801onnVK801?l0003o>TVhocY9^?ljBKP4o`000005oe=Ub?l0
003o0000odAE_ol000001?o2YK`00ol0003o`Zg5ol:]a@03ol:]a@05o`000?oP/JKoh;6Von2aY_l0
00002?oR]j/00ol0003ohZnQon:_X@03on:_X@03o`000?oT]:Coi;BT00Goi;BT00?o0000om6V[?oA
YZ`01_oAYZ`00ol0003odZZ_o`000006ohMl`005o`000?l07:?o01bSo`0LXol000000_l08:L2o`00
00KoHGSC00?o0000ojK2k_nV`^h01OnV`^h4o`0000Ooa>S_0_l00003ol588003o`000?o9ER_obEH[
00;obEH[00Go0000oliK;Oo>FbgocU/]o`000003om1L9`03o`000?oooooo000005Oooooo00?o003o
ooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0
0001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1Cooooo`03o`000?oooooo
oooo033ooooo00?o0000ol^Q[Oo;XJd00_o;XJd00ol0003ocZ6[oljQZ`05oljQZ`;o00001OnSRk`2
o`0000GoP7W200?o0000olnU[Oo?YJd01oo?YJd00ol0003od:Vao`000005om^YX`03o`000?oM[:Co
gJbT00CogJbT00?o0000omj_Y_l000001OoGYZD00ol0003ofJRUomVXY@03omVXY@03o`000?oKZjKo
000000So_YVb00?o0000ocY9^?ljBKP00_ljBKP4o`0000;oDfG800?o0000odAE_ol000000_o2YK`0
0ol0003o`Zg5ol:]a@04ol:]a@05o`000?oP/JKoh;6Von2aY_l000001ooR]j/2o`0000GohZnQ00?o
0000onBdY?oT]:@01?oT]:@2o`0000OodJJ/00Co0000om:Z[ooBZZoo00001_n7O<02o`0000;o01bS
0_l00002o`0PY`03o`000?mQN=?oHGSC00GoHGSC00?o0000ojK2k_nV`^h01?l00004oiSLoP03o`00
0?o4j>ooa>S_00Coa>S_0ol00003ol588005o`000?o9ER_obEH[olUF:ol000001?o>Fbd00ol0003o
d5`Wo`000002ooooo`03o`000?oooooooooo05Gooooo00?o003oooooooooool01?ooool00ol00?oo
ooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?oo
ool00_o=cLd00onIVIWo0000ooooo`1Dooooo`03o`000?oooooooooo033ooooo00Co0000ol^Q[Oo;
XJgo00002?o>XJ/00ol0003oXh^loj>;_004oj>;_0?o00001?n0NL800ol0003ocjF]olnU[@06olnU
[@04o`000?o@ZK7od:Vao`0000CofjVS00?o0000omf/Y?oM[:@01OoM[:@00ol0003ogZnVo`000005
omNVY@03o`000?oIZ:GofJRU00?ofJRU00?o0000om^[Y_l000002OnnVK801?l0003o>TVhocY9^?lj
BKP2o`000003o`00O_l0003oDfG800;oDfG80_l000000oo2YKco0000ol:]a@06ol:]a@04o`000?oP
/JKoh;6Vo`0000Soh[N[00?o0000on?1]_l000000ooR[j400ol0003oi;BTonBdY005onBdY003o`00
0?oV^j[o000000KodJJ/00Co0000om:Z[ooBZZoo00001_n7O<000ol0003o2bf^o`000002o`0LX`;o
00000_l08:L:o`0000OoV=cn3?l00003ol588005o`000?o9ER_obEH[olUF:ol000001?o>Fbd01Ol0
003ooooooooooooooooo000005Oooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:
ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd0
0onIVIWo0000ooooo`1Eooooo`;o0000<?ooool01?l0003obj6]ol^Q[Ol00007oljQZ`;o00001_nS
Rk`3o`0000GoP7W200?o0000olnU[Oo?YJd01Oo?YJd01Ol0003od:Vaom2Y/Oo@ZK7o000000?ofjVS
00?o0000omf/Y?oM[:@01?oM[:@01Ol0003ogZnVomj_Y_oN[jKo000000?oejJU00?o0000omVXYOoI
Z:D01?oIZ:D00ol0003ofj^Vo`000009okjI/P04o`000?ljBKSo>TVhocY9^0;o000000?o001no`00
0?l000001?mCILP00ol0003o`Zg5ol:]a@07ol:]a@03o`000?oP/JKo000000Ooh[N[00Co0000on?1
]_oS`KKo00000ooR[j400ol0003oi;BTonBdY005onBdY003o`000?oV^j[o000000GodJJ/00?o0000
om:Z[ooBZZl00_oBZZl00ol0003oQgc0ohMl`004ohMl`009o`000?l;;Jko0000o`0LXol0003o9TRo
o`000?l08:Oo000000WoSJ7Q00?o0000oiSLo_nHg?h01?l00002of;Hi@Go00000old^]/00ol0003o
[b`4o`000003ol588005o`000?o9ER_obEH[olUF:ol000000oo>Fbd01Ol0003ooooooooooooooooo
000005Oooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooo
cLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1G
ooooo`03o`000?oooooooooo02gooooo00?o0000ol^Q[Ol000002?o>XJ/00ol0003od:>Yo`000006
oj>;_0;o00001On0NL800ol0003ocjF]olnU[@04olnU[@03o`000?o@ZK7od:Va00;od:Va00Go0000
om^YXooKZJ?ofjVSo`000006omf/Y005o`000?oN[jKogZnVomj_Y_l000000ooGYZD00ol0003ofJRU
omVXY@03omVXY@05o`000?oKZjKofj^Vom^[Y_l000001onnVK83o`0000?o>TVh0_l000000ol007ko
0000oe=Ub003oe=Ub003o`000?o2[LGo`Zg500Oo`Zg500?o0000on2aY_l000001ooR]j/01?l0003o
hl6fon?1]_l00003on:_X@03o`000?oT]:Coi;BT00Coi;BT00Co0000onJkZ_oV^j[o00001?oAYZ`0
0ol0003odZZ_om:Z[`03om:Z[`03o`000?n7O<3oQgc000CoQgc000[o0000o`/][_l;;Jko0000o`0L
Xol0003o9TRoo`000?l08:Oo00002?n=XN44o`0000;oH]SU1ol000002?oooooo0000o`000?l0003o
=;[Ko`000?n_;0Co00000_o1B2001Ol0003obEH[olUF:oo9ER_o000000;ocU/]00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`1Eooooo`03o`00oooooooooooo00Cooooo00?o003ooooooooo
ool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;o
cLg=00?oVIVIo`000?ooool0F?ooool00ol0003oooooooooo`0]ooooo`;o00001oo>XJ/01?l0003o
d:>Yom2SZOl00006oj>;_0?o00001?n0NL800ol0003ocjF]olnU[@03olnU[@03o`000?o@ZK7od:Va
00?od:Va00Co0000om^YXooKZJ?o00001ooM[:@01Ol0003ogZnVomj_Y_oN[jKo000000?oejJU00?o
0000omVXYOoIZ:D00ooIZ:D01Ol0003ofj^Vom^[Y_oKZjKo000000Ko_YVb00?o0000oknK/onoVk<0
0_l00002ocY9^0;o000000?o001no`000?mCILP01?mCILP00ol0003o`Zg5ol:]a@06ol:]a@;o0000
1ooR]j/00ol0003ohl6fon?1]P02on?1]P03o`000?oR[j7o000000Ooi;BT00Go0000onJkZ_oV^j[o
i[^Zo`000003om6V[003o`000?oBZZoodZZ_00?odZZ_00?o0000ohMl`?n7O<001On7O<001Ol0003o
2bf^o`000?l07:?o000000;o9TRo0_l00006ohfQh@;o00001?nmc>D9o`0000Cooooo0ol000001On_
;0Co0000ol588?o1B23o000000?obEH[00?o0000oliK;Ol000001Oooool00ol0003oooooooooo`1D
ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=
cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0FOooool0
0ol0003oooooooooo`0/ooooo`03o`000?o>XJ_ocZ6[00KocZ6[00Co0000om2SZOo@XjWo00001onS
Rk`2o`0000GoP7W200?o0000olnU[Oo?YJd00_o?YJd00ol0003od:Vaom2Y/@04om2Y/@03o`000?oK
ZJ?o000000KogJbT00?o0000omj_Y_oN[jH00ooN[jH00ol0003oejJUo`000006omVXY@05o`000?oK
ZjKofj^Vom^[Y_l000001OnnVK802?l0003o_i^coknK/onoVk?o0000oc]:^?l0003o>TVh0ol00000
0ol007ko0000oe=Ub003oe=Ub003o`000?o2[LGo`Zg500Go`Zg500?o0000ol6jdol000001_oR]j/0
0ol0003ohl6fon?1]P03on?1]P03o`000?oR[j7o000000Koi;BT00?o0000onJkZ_oV^jX00_oV^jX0
1?l0003odJJ/om6V[?l00006om:Z[`03o`000?n7O<3oQgc000GoQgc000?o0000o`/][_l;;Jh00_l0
0003obI8_`;o00000on=XN42o`0000Go_LcU00Co0000on;[f?l0003olOFj1_l00006ooooo`;o0000
00Go[b`4o`000?o1B23o`DPPo`000003olUF:`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0E?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=
cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo05[o
oooo0_l0000/ooooo`03o`000?o>XJ_ocZ6[00KocZ6[00Go0000om2SZOo@XjWod:>Yo`000006oj>;
_0;o00001On0NL801Ol0003ocjF]olnU[Oo?YJgo000000Ood:Va00?o0000om^YXol000001_oM[:@0
0ol0003ogZnVomj_YP03omj_YP03o`000?oGYZGo000000GofJRU00?o0000om^[Y_oKZjH00ooKZjH0
1Ol0003o_YVbokjI/_nnVK;o000000Co_i^c00?o0000oc]:^?lkB[P00_l000001?l0073o0000o`00
O_l00005oe=Ub003o`000?o2[LGo`Zg500;o`Zg50_l00003ol6jd`03o`000?oR]j_oh[N[00?oh[N[
00?o0000on?1]_oS`KH00ooS`KH00ol0003ohZnQo`000006onBdY003o`000?oV^j[oi[^Z00;oi[^Z
00Co0000om6V[?oAYZco00001ooBZZl00ol0003oQgc0ohMl`004ohMl`004o`000?l;;Jko2bf^o`/]
[P;o00000olVB;l01?l0003oSJ7Qo`000?l00006okg<i@06o`000?oRjmSo0000oo7e^_l0003ol?6J
0ol000000ooig7Oo0000ooooo`06ooooo`;o000000Oo[b`4o`000?o1B23o`DPPo`000?o9ER_o0000
00Oooooo00?o0000ooooooooool0E?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo
00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=
c@03oiVIVOl0003ooooo05cooooo00?o0000ooooooooool0:_ooool00ol0003ocZ6[oljQZ`04oljQ
Z`03o`000?o@XjWod:>Y00;od:>Y00?o0000oj>;_?nSRk`01?nSRk`2o`0000KoP7W200Co0000olnU
[Oo?YJgo00001oo@ZK42o`0000OogJbT00?o0000omj_Y_oN[jH00ooN[jH00ol0003oejJUo`000005
omVXY@03o`000?oKZjKofj^V00?ofj^V00Co0000okjI/_nnVK;o00001_noVk<00ol0003o>dZhoc]:
^004o`000004o`00O_l0003o0000o`0000?oDfG800Co0000ol:]aOo2[LGo00001Oo1^]<00ol0003o
h[N[on:gZ`02on:gZ`03o`000?oS`KKohl6f00Gohl6f00?o0000onBdY?oT]:@01?oT]:@00ol0003o
i[^ZonJkZP03onJkZP03o`000?oAYZco000000SodZZ_2Ol00003o`/][P03o`000?lVB;oo9TRo00;o
9TRo00?o0000okg<iOnmc>D01Onmc>D01Ol0003oh^_Hon;[f?l0003olOFj00Go000000?onMago`00
0?ooool01oooool4o`000003ol588?l0003o000000Sooooo00?o0000ooooooooool0E?ooool00ol0
0?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02
o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo05gooooo00?o0000oooo
ooooool0:Oooool00ol0003ocZ6[oljQZ`04oljQZ`03o`000?o@XjWod:>Y00;od:>Y00?o0000oj>;
_?nSRk`00onSRk`4o`0000GoP7W200?o0000olnU[Ol000002Oo@ZK400ol0003ogJbTomf/Y004omf/
Y003o`000?oN[jKogZnV00GogZnV00?o0000omVXYOoIZ:D01?oIZ:D00ol0003ofj^Vom^[YP03om^[
YP03o`000?nnVK;o000000Oo_i^c00Ko0000oc]:^?lkB[So>dZho`000?l00703o`0000;oJGgD1?l0
00000oo2[LGo0000ol6jd`06ol6jd`05o`000?oR]j_oh[N[on:gZol000001ooS`KH00ol0003oi;BT
onBdY004onBdY003o`000?oV^j[oi[^Z00Coi[^Z0_l00008om:Z[`03o`000?n9PLCoRH7400GoRH74
00?o0000o`/][_l;;Jh00_l;;Jh2o`0000?o9TRo00?o0000okg<iOnmc>D00onmc>D01ol0003oh^_H
on;[f?l0003olOFjo`000?o`lIX01Ol00009ooooo`05o`000?ooooooooooooooool000002_ooool0
0ol0003oooooooooo`1Dooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool0
1Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVI
o`000?ooool0G_ooool00ol0003oooooooooo`0Xooooo`03o`000?o>XJ_ocZ6[00?ocZ6[00?o0000
om2SZOo@XjT01?o@XjT00ol0003oXh^lo`000002o`0000;oXXZk1_l000001?n0NL;o0000olnU[Ol0
0009om2Y/@03o`000?oM[:CogJbT00CogJbT00?o0000omj_Y_oN[jH01OoN[jH00ol0003ofJRUomVX
Y@03omVXY@03o`000?oKZjKofj^V00Gofj^V00?o0000oknK/onoVk<01_noVk<01_l0003o>dZhoc]:
^?lkB[So0000o`00L0;o000000?o001no`000?mYOM@00omYOM@2o`0000Wo`K[C00?o0000on:gZol0
00002?oS`KH00ol0003oi;BTonBdY004onBdY003o`000?oV^j[oi[^Z00Coi[^Z00?o0000om:Z[ooB
ZZl01_oBZZl00ol0003oe;6fo`000006ohV1a0;o00000ol;;Jh00ol0003oIWcDo`000002o`000003
obI8_ol0003o_LcU00;o_LcU00Ko0000on;[f?oRjmSoh^_Ho`000?oamKX2o`000003onSXPOl0003o
000000;o00002_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo05Cooooo00?o003o
ooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0
0001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1Oooooo`;o0000:Oooool0
0ol0003ocZ6[oljQZ`02oljQZ`03o`000?o@XjWod:>Y00Cod:>Y0_l00005oj::^`;o00001?n3PLP3
o`0000Wod:Va00?o0000om6`^?l000001OoM[:@00ol0003ogZnVomj_YP04omj_YP;o00001OoIZ:D0
0ol0003ofj^Vom^[YP05om^[YP03o`000?noVk?o_i^c00Ko_i^c00?o0000oc]:^?lkB[P00_lkB[P5
o`0000GoJGgD00?o0000ol6jdoo1^]<01oo1^]<00ol0003oh[N[o`000007on?1]P03o`000?oQe<_o
000000Coi;BT00?o0000onJkZ_oV^jX01OoV^jX00ol0003odZZ_om:Z[`06om:Z[`03o`000?oD/KKo
000000OoRH740_l00003o`/][P04o`000?mVO=CoIWcDofIle0?o000000?o_LcUo`000?oRjmP00_oR
jmP01?l0003olOFjo`000?o`lIX3o`000003oocPQ_l0003o000000_ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`1Dooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool0
2_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=
00?oVIVIo`000?ooool0HOooool00ol0003oooooooooo`0Vooooo`05o`000?o>XJ_ocZ6[oljQZol0
00001oo@XjT00ol0003oXXZkoj::^`05oj::^`;o00001On3PLP00ol0003od:Vaom2Y/@06om2Y/@04
o`000?oA/;SodK2ho`0000CogJbT00?o0000omj_Y_oN[jH01OoN[jH00ol0003oh;F[o`000004omVX
Y@03o`000?oKZjKofj^V00Cofj^V00?o0000omb`ZOl000002?noVk<01_l0003o>dZhoc]:^?lkB[So
0000o`00L0?o00001_mYOM@00ol0003o`K[Col6jd`06ol6jd`;o00001ooS`KH01?l0003ohMC;on7D
bol00004onBdY003o`000?oV^j[oi[^Z00Coi[^Z00?o0000onO8]ol000001_oBZZl01Ol0003oe;6f
omBa]_oD/KKo000000KoRH7400?o0000obU8_Ol000000_l;;Jh00ol0003oIWcDofIle004ofIle0;o
00000_oRjmP01Ol0003olOFjoo7e^_l0003ol?6J00Co000000?onMago`000?ooool02_ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo05?ooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`1Rooooo`03o`000?oooooooooo02Gooooo00Go0000oljQ
Zoo>XJ_ocZ6[o`000006om2SZ@03o`000?oAY:[o000000KoXXZk0_l00006oh>1b003o`000?o@ZK7o
d:Va00God:Va00Go0000om6`^?oA/;SodK2ho`000003omf/Y003o`000?oN[jKogZnV00GogZnV00?o
0000on2eZol000000ooIZ:D00ol0003ofj^Vom^[YP05om^[YP03o`000?oL/:Wo000000So_i^c0_l0
0002oc]:^0?o000000?o00^Ko`000?l000001_mYOM@00ol0003o`K[Col6jd`03ol6jd`;o000000?o
]lk[o`000?oS`KH01OoS`KH00ol0003ohMC;on7Db`02on7Db`04o`000?oT]:Coi;BTo`0000Ooi[^Z
00?o0000onO8]ol000001_oBZZl01Ol0003oe;6fomBa]_oD/KKo000000KoRH7400Ko0000obU8_OlY
B;go0000o`/][_l00008ofIle004o`000?oRjmSo0000oo7e^PCo000000CooN>Lo`000?l0003o0000
3Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo05?ooooo00?o003oooooooooool0
1?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`00
00?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1Sooooo`03o`000?oooooooooo02Gooooo
00Co0000oljQZoo>XJ_o00001_o@XjT00ol0003odJBZo`000006oj::^`?o00001On3PLP00ol0003o
d:Vaom2Y/@04om2Y/@03o`000?oA/;SodK2h00;odK2h00Go0000omf/Y?oM[:CogJbTo`000006omj_
YP04o`000?oP]J_oh;F[o`0000?ofJRU00?o0000om^[Y_oKZjH01OoKZjH00ol0003og;2Yo`000008
oknK/`03o`000?m1D;_o000000;o>dZh0ol000000ol02i_o0000ofUme005ofUme003o`000?o1^]?o
`K[C00;o`K[C00?o0000okO>jongc^/00_ngc^/00ol0003ohl6fon?1]P02on?1]P03o`000?oQe<_o
hMC;00CohMC;00?o0000onBdY?l000001_oV^jX01Ol0003oilRgonO8]ooWb;Oo000000CodZZ_00?o
0000omBa]_oD/KH00_oD/KH00ol0003oRH74ohV1a005ohV1a006o`000?lYB;go:DRmo`000?l;;Jko
00001omVO=@3o`000003oo7e^_l0003og=?@00;o000000CooN>Lo`000?l0003o00003_ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo05?ooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`1Tooooo`03o`000?oooooooooo02Cooooo00?o0000oljQ
Zol000001_o@XjT01?l0003odJBZom6TZ_l00007oj::^`;o00001_n3PLP00ol0003od:Vaom2Y/@02
om2Y/@03o`000?oA/;SodK2h00?odK2h00Co0000omf/Y?oM[:Co00001ooN[jH01Ol0003oh;F[on2e
ZooP]J_o000000;ofJRU00?o0000om^[Y_oKZjH01?oKZjH01Ol0003og;2Yomb`ZOoL/:Wo000000Ko
_i^c00Ko0000ol2N]_l0003o@E2ko`000?lkB[P5o`0000OoJGgD00Co0000ol6jdol0003o00001_ng
c^/01?l0003ohl6fon?1]_l00007on7Db`03o`000?oT]:Co000000Koi[^Z00Go0000onO8]ooWb;Oo
ilRgo`000003om:Z[`03o`000?oD/KKoe;6f00Coe;6f00?o0000ohV1a?n9PL@01?n9PL@01?l0003o
:DRmobU8_OlYB;d2o`0000CoIWcD0ol00003ojV_g004o`000?oLdm3o0000ooGQ]P;o000000?oo>26
o`000?l000003oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo05?ooooo00?o003o
ooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0
0001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1Uooooo`;o00009?ooool0
0ol0003ocZ6[o`000006om2SZ@05o`000?oAY:[odJBZom6TZ_l000001_nRR[/2o`0000KoPh7800Go
0000om2Y/Oo@ZK7od:Vao`000007om6`^003o`000?oM[:Co000000KogZnV00?o0000on2eZooP]J/0
0_oP]J/00ol0003ofJRUo`000007om^[YP05o`000?oL/:Wog;2Yomb`ZOl000001OnoVk<01?l0003o
`9jfol2N]_l00002od5@^`03o`000?lkB[So000000co00002?ngc^/00ol0003ohl6fo`000008on7D
b`;o00001_oV^jX00ol0003oilRgonO8]`02onO8]`05o`000?oBZZoodZZ_om:Z[ol000001_oD/KH0
0ol0003oRH74ohV1a004ohV1a003o`000?lYB;go:DRm00;o:DRm00?o0000ofIle?l000000_l00005
ojV_g003o`000?oLdm3og=?@00;o000000GooN>Lo`000?l0003onMago`00000?ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool0Doooool00ol00?ooooooooooo`04ooooo`03o`00oooo
oooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000oooo
o`02olg=c@03oiVIVOl0003ooooo06Oooooo00?o0000ooooooooool08_ooool00ol0003od:>Yom2S
Z@05om2SZ@05o`000?oAY:[odJBZom6TZ_l000001_nRR[/00ol0003o001co`000006oh>1b004o`00
0?o@ZK7od:Vao`0000OodK2h00?o0000omf/Y?l000001_oN[jH00ol0003oh;F[on2eZ`02on2eZ`03
o`000?oIZ:Go000000Kofj^V00?o0000omb`ZOoL/:T00_oL/:T00ol0003o_i^coknK/`02oknK/`05
o`000?o0W[Ko`9jfol2N]_l000000om1D;/4o`000003oa@o_?l0003oQYgR00OoQYgR00?o0000okO>
jongc^/01?ngc^/3o`0000SohMC;00?o0000oko`l_l000001_oV^jX00ol0003oilRgonO8]`03onO8
]`03o`000?oBZZoo000000Soe;6f1Ol00002ohV1a003o`000?lYB;go:DRm00;o:DRm00?o0000ojV_
g?nY[m`01OnY[m`01ol0003og=?@omcCd?l0003omN6fo`000?omhi`00ol0000Aooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool0Doooool00ol00?ooooooooooo`04ooooo`03o`00oooo
oooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000oooo
o`02olg=c@03oiVIVOl0003ooooo06Sooooo00?o0000ooooooooool08Oooool00ol0003od:>Yom2S
Z@04om2SZ@03o`000?oAY:[odJBZ00;odJBZ00?o0000oj::^onRR[/01OnRR[/2o`0000KoPh7800?o
0000om2Y/Ol000002OoA/;P00ol0003ogZnVomj_YP04omj_YP03o`000?oP]J_oh;F[00Coh;F[0_l0
0006om^[YP03o`000?oL/:Wog;2Y00?og;2Y00Go0000oknK/onoVk?o_i^co`000004ol2N]P06o`00
0?m1D;_o@E2kod5@^ol0003o00260_l000000olD?kco0000ohJMhP07ohJMhP03o`000?ngc^_o]lk[
00?o00000on4foh00ol0003ohMC;on7Db`03on7Db`;o00000onol?800ol0003oi[^ZonJkZP03onJk
ZP03o`000?oWb;OoilRg00?oilRg00?o0000om:Z[ol000002?oD/KH00ol0003oSH[;ohf:b`02ohf:
b`Co00000olYB;d00ol0003oZJoLojV_g004ojV_g006o`000?oLdm3og=?@omcCd?l0003omN6f0_l0
00000oolh8Ko0000o`00000Booooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0Dooo
ool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=
oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo06Wooooo00?o
0000ooooooooool08?ooool00ol0003od:>Yom2SZ@04om2SZ@03o`000?oAY:[odJBZ00?odJBZ00?o
0000oj::^onRR[/00onRR[/2o`000003o`00Lol0003o000000Ko00002_oA/;P00ol0003ogZnVomj_
YP04omj_YP03o`000?oP]J_oh;F[00Coh;F[00?o0000om^[Y_oKZjH01OoKZjH00ol0003og;2Yomb`
Z@03omb`Z@04o`000?noVk?o_i^co`0000Go`9jf00?o0000od5@^om1D;/00_m1D;/3o`0000;o53nl
00?o0000ohJMh_n6WN801?n6WN84o`0000OoQ=_n00Go0000on7DbooQe<_ohMC;o`000005oko`lP03
o`000?oV^j[oi[^Z00;oi[^Z00?o0000onO8]ooWb;L01OoWb;L00ol0003oe;6fomBa]P06omBa]P03
o`000?oD^l7o000000GoSH[;00Co0000oe=/col0003o00000_lYB;d00ol0003oZJoLojV_g002ojV_
g00:o`000?oLdm3og=?@omcCd?l0003omN6fo`000?omhico0000oocPQP;o00004oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo05;ooooo00?o003oooooooooool01?ooool00ol00?oo
ooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?oo
ool00_o=cLd00onIVIWo0000ooooo`1Zooooo`;o00008Oooool00ol0003od:>Yom2SZ@02om2SZ@03
o`000?oAY:[odJBZ00CodJBZ00Co0000oj::^onRR[_oXXZk0_l000001?nSRk_o0000o`000?l00006
ohV=d003o`000?oA/;SodK2h00OodK2h00?o0000om6j`ol000001OoN[jH00ol0003oh;F[on2eZ`04
on2eZ`03o`000?oKZjKofj^V00Cofj^V00?o0000omb`ZOoL/:T01?oL/:T00ol0003o_i^co`000007
ol2N]P07o`000?m1D;_o@E2kod5@^ol0003o0026o`000003oa@o_003o`000?n6WN;oQYgR00?o0000
1?nX`^`2o`0000KoQ=_n00?o0000on7Dbol000001onol?801Ol0003oi[^ZonJkZ_oV^j[o000000Oo
ilRg00?o0000omBa]_oD/KH01OoD/KH01?l0003oe;_1omBk`Ol00006ohf:b`03o`000?mCK<ooDfc?
00;o000000Go:DRmo`000?nY[mcoZJoLo`000003omcCd005o`000?oehKKomN6fo`000?omhi`00_l0
00000ooig7Oo0000ooooo`0Booooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0D_oo
ool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=
oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo06cooooo00?o
0000ooooooooool07_ooool00ol0003od:>Yom2SZ@02om2SZ@03o`000?oAY:[odJBZ00CodJBZ00Co
0000oj::^ol0003o00001?nSRk/3o`0000KoRHg@00?o0000om6`^?oA/;P01OoA/;P01?l0003odK[3
om6j`ol00004omj_YP03o`000?oP]J_oh;F[00Coh;F[00?o0000on:o]?l000001OoKZjH00ol0003o
g;2Yomb`Z@05omb`Z@03o`000?o0W[Ko`9jf00Ko`9jf00?o0000od5@^om1D;/00_m1D;/00ol0003o
0026o`000003oa@o_0;o00002?nX`^`;o`0000Oo_o3b00?o0000onJkZ_l000001ooWb;L00ol0003o
h^3Bo`000005omBa]P05o`000?oD^l7oe;_1omBk`Ol000001_n=R//00ol0003oDfc?oe=/c`02oe=/
c`;o000000?oZJoLo`000?oLdm000ooLdm001Ol0003omN6fooGQ]_l0003ooN>L00;o000000?onMag
o`000?ooool04oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo05;ooooo00?o003o
ooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0
0001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1]ooooo`03o`000?oooooo
oooo01gooooo00Go0000om2SZOo@XjWod:>Yo`000008om6TZP03o`000?nSRk_oXh^k00CoXh^k0ol0
0006ohV=d003o`000?oA/;SodK2h00CodK2h00?o0000om6j`ooA^/<00_oA^/<01Ol0003ogZnVomj_
Y_oN[jKo000000Koh;F[00?o0000on:o]?l000001OoKZjH00ol0003og;2Yomb`Z@05omb`Z@03o`00
0?o0W[Ko`9jf00Ko`9jf00?o0000od5@^om1D;/00_m1D;/3o`0000Co53nl00?o0000ojS2k?nX`^`0
1?nX`^`2o`0000;ob>G/00Go0000om_jfooKn]_o0000omkn_`02o`000003oo[QZ_l0003o000000Co
00000_nol?800ol0003oi[^Zo`000006onO8]`04o`000?oRh=;oh^3Bo`0000Coe;6f00?o0000omBk
`OoD^l400ooD^l400ol0003oSH[;ohf:b`04ohf:b`03o`000?mCK<ooDfc?00?oDfc?00?o0000omcC
d?oLdm000_oLdm001ol0003omN6fooGQ]_l0003ooN>Lo`000?olh8H00_l0000Fooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0D_ooool00ol00?ooooooooooo`04ooooo`03o`00oooo
oooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000oooo
o`02olg=c@03oiVIVOl0003ooooo06kooooo00?o0000ooooooooool07Oooool01?l0003od:>Yom2S
ZOl00008om6TZP03o`000?nSRk_oXh^k00CoXh^k1?l00006ohV=d003o`000?oA/;SodK2h00;odK2h
00?o0000om6j`ooA^/<00ooA^/<01?l0003ogZnVomj_Y_l00006on2eZ`05o`000?oR_kCoh[ndon:o
]?l000000ooKZjH00ol0003og;2Yomb`Z@05omb`Z@03o`000?oN]Zoo000000So`9jf0_l00002od5@
^`;o000000Co0026o`000?l0003o00000_lD?k`00ol0003oZ<;/ojS2k002ojS2k005o`000?o8iNco
b>G/olSUk?l000000_oKn]/02ol0003og_joo`000?l0003on^6Zo`000?omhI_o0000ookQTOl0003o
oN2;00Go00001_oWb;L00ol0003oh^3Bon;PdP02on;PdP05o`000?oD/KKoe;6fomBa]_l000001OoD
^l400ol0003oSH[;ohf:b`05ohf:b`03o`000?mCK<ooDfc?00;oDfc?00?o0000omcCd?oLdm000_oL
dm001ol0003omN6fooGQ]_l0003ooN>Lo`000?olh8H00_l0000Gooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0D_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo06oooooo0_l0000Mooooo`04o`000?o@XjWod:>Yo`0000OodJBZ0_l00007oj>;
^`03o`000?l00YCo000000KoRHg@00?o0000om6`^?oA/;P00_oA/;P00ol0003odK[3om6j``04om6j
``03o`000?oN[jKo000000Koh;F[00Go0000on:o]?oR_kCoh[ndo`000003om^[YP03o`000?oL/:Wo
g;2Y00Gog;2Y00?o0000omjf[ol000001oo0W[H2o`000004odaK`_l0003o@E2kod5@^`?o00000_mR
OML4o`000003ojS2k?l0003o000000?ob>G/00Co0000om_jfooKn]_ofo[K1?l000000oojhJ[o0000
oogQV`02o`0000;ooN2;00?o0000ooooool000000_l00005onO8]`03o`000?oRh=;oh^3B00?oh^3B
00Co0000omBa]_oD/KKo00001_oD^l400ol0003oSH[;ohf:b`05ohf:b`03o`000?mCK<ooDfc?00?o
Dfc?00Co0000omcCd?oLdm3o00000ooehKH01?l0003ooN>Lo`000?olh8H2o`0001Oooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`1Booooo`03o`00oooooooooooo00Cooooo00?o003o
ooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003o
oooo00;ocLg=00?oVIVIo`000?ooool0LOooool00ol0003oooooooooo`0Jooooo`03o`000?o@XjWo
000000SodJBZ00?o0000om>W[?l000001_nSRk/4o`0000KoRHg@00Co0000om6`^?oA/;So00001ooA
^/<00ol0003ogZnVo`000006on2eZ`05o`000?oR_kCoh[ndon:o]?l000000_oKZjH00ol0003og;2Y
omb`Z@05omb`Z@04o`000?oN]Zoog[J_o`0000Ko`9jf00?o0000ol6S^ol000000_m<Fl801?l0003o
@E2ko`000?l06J@2o`0000CoHWgG0ol00003olSUk006o`000?oKn]_ofo[Kom_jfol0003og_jo0_l0
0002oo[QZP06o`000?omhI_o0000o`000?omh8_o00001?ooool2o`0000?oilRg00?o0000on;Pd_oR
h=801?oRh=800ol0003oe;6fo`000008omBk`@04o`000?n=R/_oSH[;ohf:b`Wo000000CoDfc?o`00
0?oLdm3o00000_oehKH00ol0003ooN>LoogSW003o`0001Wooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`1Aooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool0
1Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVI
o`000?ooool0L_ooool00ol0003oooooooooo`0Jooooo`;o00001ooAY:X01?l0003odjN/om>W[?l0
0006oj>;^`;o000000?o00:Do`000?n9SM001On9SM000ol0003odK2ho`000008om6j``;o00001_oP
]J/00ol0003oh[ndon:o]003on:o]003o`000?oKZjKo000000Oog;2Y00Go0000omjf[ooN]Zoog[J_
o`000004ol2N]P05o`000?o1Xk_o`J>kol6S^ol000000_m<Fl800ol0003o@E2ko`000002o`0000Oo
HWgG00?o0000olSUk?l000000ooKn]/3o`00000:oo3M_?l0003on^6Zo`000?omhI_o0000ookQTOl0
003ooN2;o`0000Kooooo00?o0000onO8]ol000001ooRh=82o`0000Woe;_11?l00004oi>He@03o`00
0?n7VMgoQiWM00;oQiWM1?l00002ooGQ]P03o`000?omhico000000?o00006_ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo057ooooo00?o003oooooooooool01?ooool00ol00?oooooo
ooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool0
0_o=cLd00onIVIWo0000ooooo`1cooooo`03o`000?oooooooooo01Wooooo00?o0000om6TZ_oAY:X0
1_oAY:X01?l0003odjN/om>W[?l00007oj>;^`;o000000?o00:Do`000?l000001_l00008om6j``03
o`000?o=c=Wo000000Koh;F[00?o0000on:o]?oR_k@00ooR_k@00ol0003ofj^Vo`000006omb`Z@03
o`000?oN]Zoog[J_00;og[J_00Go0000ol2N]_o0W[Ko`9jfo`000004ol6S^`04o`000?m<Fl;oC5_2
odaK`P;o000000?o01VTo`000?l000001_mROML7o`00000<omW@d?l0003ol=flo`000?ojhJ[o0000
oogQVol0003oo^6Ao`000?omh8_o00001oooool2o`0000Coh^3B0ol000000on;jnoo0000omBk`@07
omBk`@;o00002?nCV=D00ol0003oQiWMohNIg@05ohNIg@03o`000?oehKKo000000;o000000?oi>?A
o`000?l000006_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo057ooooo00?o003o
ooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0
0001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1dooooo`;o00006Oooool0
0ol0003odJBZom6TZP05om6TZP03o`000?oCYjcodjN/00;odjN/00?o0000oj>;^onSRk/01?nSRk/4
o`0000KoTYkL00?o0000om6j`ooA^/<01OoA^/<01Ol0003ocLcIolg<fOo=c=Wo000000Coh;F[00?o
0000on:o]?oR_k@01OoR_k@00ol0003og;2Yomb`Z@05omb`Z@03o`000?oN]Zoog[J_00;og[J_00Co
0000ol2N]_o0W[Ko00001Oo1Xk/00ol0003oC5_2odaK`P02odaK`P04o`000?l06JCo0000o`0000?o
HWgG0ol00005oj^bgP05o`000?oId=3o0000oo3M_?l000000_ojhJX01ol0003ooN6Ko`000?onhI7o
0000oogPRol000002Oooool01?l0003oh^3Bo`000?l00005oh_[k`03o`000?oD^l7oe;_100Coe;_1
00Co0000om3<e_o@c=Ko00001onCV=D00ol0003oQiWMohNIg@05ohNIg@?o000000Co_LGQo`000?l0
003o00007?ooool01Ol0003ooooooooooooooooo000005?ooooo00?o003oooooooooool01?ooool0
0ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?ooooo
o`000?ooool00_o=cLd00onIVIWo0000ooooo`1fooooo`03o`000?oooooooooo01Oooooo00?o0000
om6TZ_oAY:X01?oAY:X00ol0003odjN/om>W[002om>W[003o`000?nSRk_oXh^k00CoXh^k00?o0000
o`00Q?l000000_l00006oi:Ng003o`000?oA^/?odK[300?odK[300?o0000olg<fOo=c=T00_o=c=T0
0ol0003oh;F[on2eZ`02on2eZ`03o`000?oR_kCoh[nd00Goh[nd00?o0000omb`ZOoL/:T01?oL/:T0
0ol0003og[J_omjf[`04omjf[`;o00001oo1Xk/00ol0003oC5_2odaK`P02odaK`P?o000000?oHWgG
o`000?l000001on[/]h02?l0003ofM3@omW@d?l0003ol=flo`000?ojhJ[o00000_omhI/2o`000003
oogPRol0003ooooo00[ooooo1Ol00004oh_[k`03o`000?oD^l7oe;_100;oe;_100?o0000om3<e_o@
c=H00_o@c=H00ol0003oTiSEoi>He@05oi>He@04o`000?n7VMgoQiWMohNIg@?o00000onmaN401?l0
003oi>?Ao`000?l0000Mooooo`04o`000?ooooooooooo`0005?ooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1gooooo`03o`000?oooooooooo01Kooooo00?o
0000om6TZ_oAY:X00ooAY:X00ol0003odjN/om>W[003om>W[003o`000?nSRk_oXh^k00?oXh^k1?l0
00000ol9>kco0000o`000006oi:Ng005o`000?oA^/?odK[3om6j`ol000001_o=c=T01?l0003oh;F[
on2eZol00007on:o]003o`000?oQdLOo000000Gog;2Y00?o0000omjf[ooN]Zl01?oN]Zl00ol0003o
`J>kol6S^`06ol6S^`03o`000?m<Fl;oC5_200;oC5_200Co0000obY@aOl0003o00002?n[/]h01?l0
003ofM3@omW@d?l00002oo3M_009o`000?ojhJ[o0000oogQVol0003oo^6Ao`000?omh8_o0000013o
oooo0ol000000on;jnoo0000omBk`@02omBk`@03o`000?o@c=Kod<cF00?od<cF00?o0000oi>HeOnC
V=D01OnCV=D01?l0003oQiWMo`000?l00005okg5h@04o`000?oThm7o0000o`0001oooooo00?o0000
ooooool00000Doooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000
ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003o
oooo07Sooooo00?o0000ooooooooool05Oooool00ol0003odJBZom6TZP03om6TZP03o`000?oCYjco
djN/00CodjN/00?o0000oj>;^ol000000_l00002oj>=_@05o`000?l008Co0000o`Tk_?l000001onB
W]`00ol0003odK[3o`000008olg<f@03o`000?oP]J_o000000Koh[nd00Co0000on7AaooQdLOo0000
1OoL/:T00ol0003og[J_omjf[`04omjf[`03o`000?o1Xk_o`J>k00Ko`J>k00?o0000odaK`_m<Fl80
0om<Fl800ol0003o:U35o`000007oj^bgP04o`000?oId=3ofM3@o`0000;ol=fl00[o0000oo[QZ_oj
hJ[o0000oogQVol0003oo^6Ao`000?omh8_o00004oooool3o`000003omBk`Ol0003od<cF00Kod<cF
00?o0000oi>HeOnCV=D00_nCV=D4o`0000Ko_LGQ00?o0000onCSdOoThm400_l0000Oooooo`03o`00
0?oooooo000005?ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`1iooooo`;o00005_ooool00ol0003odJBZom6TZP02om6TZP03o`000?oCYjcodjN/00CodjN/
0_l00005oj>=_@?o00000_l9>k`00ol0003oTYkLoi:Ng002oi:Ng0Go00002?o=c=T00ol0003oh;F[
o`000005on:o]003o`000?oQdLOohM7700;ohM7700Go0000omb`ZOoL/:Wog;2Yo`000006omjf[`03
o`000?oO`[_o000000So`J>k00?o0000odaK`_m<Fl800_m<Fl801?l0003o:U35obY@aOl00005oj^b
gP05o`000?oId=3ofM3@omW@d?l000000_o`gK`00ol0003on^6Zo`000002oogQV`03o`000?onhI7o
000000;o00005Oooool2o`0000Sod<cF1Ol00003oi^]i003o`000?nmaN7o_LGQ00?o_LGQ00Ko0000
onCSdOoThm7o0000ooK^]_l0000Pooooo`03o`000?oooooo000005;ooooo00?o003oooooooooool0
1?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`00
00?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1kooooo`03o`000?oooooooooo01?ooooo
00Go0000om6TZ_oAY:[odJBZo`000007om>W[003o`000?nSSKgoXhfm00GoXhfm00?o0000o`00Q?l0
00000_l9>k`4o`0000GoWKO[00?o0000olg<fOo=c=T01?o=c=T3o`0000Goh[nd00?o0000on7AaooQ
dLL00ooQdLL01Ol0003og;2Yomb`ZOoL/:Wo000000Kog[J_00?o0000omo2^ol000002?o1Xk/2o`00
00CoC5_200Co0000obY@aOlZD<Go00000on[/]h01Ol0003ofM3@omW@d?oId=3o000000;ol=fl00Oo
0000oo[QZ_ojhJ[o0000oogQVol0003oo^6A00?o00005oooool00ol0003od<cFom3<eP04om3<eP;o
000000?o/NCho`000?nK[N@01_nK[N@01Ol0003o_LGQokg5hOnmaN7o000000;oi>?A00?o0000ooK^
]_l000008_ooool2o`0005;ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`1looooo`03o`000?oooooooooo01?ooooo00Co0000om6TZ_oAY:[o00001_oCYj`0
0ol0003oe:b_o`000006oj>=_@?o00000_l9>k`00ol0003oWKO[oifgj`07oifgj`03o`000?o=c=Wo
cLcI00?o00000_nUho/00ol0003oh[ndon:o]003on:o]003o`000?oQdLOohM7700CohM7700?o0000
omb`ZOl000001_oN]Zl01Ol0003ogl:komo2^ooO`[_o000000Ko`J>k0_l000001_mLKL_o0000o`00
0?l0003oC5_2o`0000?o:U3500?o0000oj^bg_l000001?oId=001?l0003ol=floo3M_?l00002oo[Q
ZP07o`000?omhI_o0000ookQTOl0003onn6Vo`00000Hooooo`03o`000?o@c=Kod<cF00;od<cF00?o
0000ok7Tn?nai?P00_nai?P00ol0003oVjgToi^]i005oi^]i003o`000?nmaN7o000000?oi>?A00?o
0000ooK^]_l000008Oooool3o`0005;ooooo00?o003oooooooooool01?ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`1mooooo`03o`000?oooooooooo01;ooooo00?o0000om6TZ_l000001ooC
Yj`00ol0003oe:b_o`000006oj>=_@Go000000?o2C^lo`000?nM]n/01onM]n/3o`0000KoYN?k00Go
0000on:o]?oR_kCoh[ndo`000007on7Aa`03o`000?oL/:Wo000000Kog[J_00Go0000omo2^ooO`[_o
gl:ko`000005ol6S^`04o`000?o1Z/?o`J[3o`0000?oG6g;0_l00004obY@a@03o`000?oId=3ofM3@
00;ofM3@00Oo0000oo3M_?o`gKcol=flo`000?ojhJ[o000000;ooN6K0ol000000ookhJKo0000oooo
o`0Hooooo`04o`000?o@c=Ko0000o`0000Ko/NCh00?o0000oi^]i?nK[N@00onK[N@4o`0000;oi>?A
00?o0000ooK^]_l000007_ooool4o`0005Gooooo00?o003oooooooooool01?ooool00ol00?oooooo
ooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool0
0_o=cLd00onIVIWo0000ooooo`1nooooo`;o00004_ooool00ol0003odJBZo`000006om>W[004o`00
0?oD[:ooe:b_o`0000OoXhfm0ol000001?mMOM[o0000o`000?l00004oifgj`?o00000onWe_P2o`00
00GoYN?k00?o0000on:o]?l000002?oQdLL2o`0000Kog[J_00?o0000omo2^ooO`[/00_oO`[/00ol0
003o`J>kol6S^`02ol6S^`05o`000?o1Z/?o`J[3ol6Z`ol000001OmLKL/3o`0000;o:U3500Co0000
omW@d?oId=3o00000oo`gK`01Ol0003on^6Zoo[QZ_l0003ooN6K00?o000000?onn6Vo`000?ooool0
6_ooool3o`0000Ko/NCh00?o0000oi^]i?nK[N@00ol00004oj?<m@05o`000?oThm7o0000ooK^]_l0
00006oooool3o`0005Wooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`20ooooo`03o`000?oooooooooo013ooooo00?o0000om>W[?oCYj`01OoCYj`01Ol0003o
e:b_omB/[ooD[:oo000000KoXhfm1?l00002oeemfP;o000000?oWKO[o`000?l000001onWe_P9o`00
00KohM770_l000000oo0l_7o0000omjf[`05omjf[`03o`000?oO`[_ogl:k00?ogl:k00Co0000ol6S
^oo1Xk_o00001Oo1Z/<00ol0003oG6g;oea]b`02oea]b`03o`000?miSM_oNHgK00Co000000?ofM3@
o`000?o`gK`00_o`gK`00ol0003on^6Zoo[QZP03o`000004ooCN]ol0003onn6Vo`0001kooooo2Ol0
0007oj?<m@?o000000?om^jfo`000?ooool05_ooool4o`0005cooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`21ooooo`03o`000?oooooooooo00oooooo00?o
0000om>W[?oCYj`01OoCYj`01Ol0003oe:b_omB/[ooD[:oo000000KoXhfm00Co0000o`03U?l0003o
00001?mMOMX2o`0000GoYmKh0ol000000onXl?Ko0000oiCae@02o`000003onWMa_l0003om>6g00;o
00001?oQdLL00ol0003o`?;aol3bl@02ol3bl@03o`000?oN]Zoog[J_00;og[J_00?o0000omo2^ooO
`[/01?oO`[/00ol0003o`J>ko`000006ol6Z``03o`000?mLKL_oG6g;00?oG6g;00?o0000ogV=fomi
SM/00_miSM/4o`0000;ol=fl00[o0000oo[QZ_l0003o0000on7Ebol0003om=jgo`000?okhJKo0000
8_ooool3o`000003o`>F^?l0003oXlce00?oXlce0ol00002oj7/n@;o00005?ooool4o`00063ooooo
00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnI
VIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`22ooooo`03o`00
0?oooooooooo00oooooo00?o0000om>W[?oCYj`00ooCYj`00ol0003oe:b_omB/[`03omB/[`03o`00
0?nSSKgoXhfm00CoXhfm1?l00005oeemfP;o000000?oYmKho`000?l000000_nXl?H4o`0000;ojMg6
00Oo0000ooCQ]oodhKOo0000oo[S[?l0003ohM7700;o00001_o0l_401Ol0003og[J_omjf[ooN]Zoo
000000Oogl:k00?o0000ol6Z`oo1Z/<01_o1Z/<00ol0003oG6g;oea]b`02oea]b`03o`000?miSM_o
NHgK00KoNHgK1Ol000001_oQeL_o0000ooCN]ol0003onn6Vo`0002Kooooo0ol000000onSc?Go0000
o`000003oj7/n@;o00004_ooool4o`0006Cooooo00?o003oooooooooool01?ooool00ol00?oooooo
ooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool0
0_o=cLd00onIVIWo0000ooooo`23ooooo`;o00003oooool00ol0003odjN/om>W[003om>W[003o`00
0?oD[:ooe:b_00?oe:b_00?o0000oj>=_OnSSKd00onSSKd2o`000004o`03U?l0003o001no`0000Go
GGgJ1ol00002om;@e`06o`000?oYgLKojMg6o`000?odhKOo00000_ojhj`4o`0000Ko`?;a00Co0000
omjf[ooN]Zoo00001ooO`[/2o`0000So`J[300?o0000oea]bomLKL/00omLKL/00ol0003oNHgKogV=
f`03ogV=f`;o00001?nj_=/01ol0003ohMG;o`000?odg[Oo0000oo_QY_l00000:Oooool3o`000003
oj7/nOl0003o0000017ooooo0ol0001Xooooo`03o`00oooooooooooo00Cooooo00?o003ooooooooo
ool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;o
cLg=00?oVIVIo`000?ooool0QOooool00ol0003oooooooooo`0=ooooo`05o`000?oCYjcodjN/om>W
[?l000001_oD[:l00ol0003oXhfmoj>=_@03o`000003ojBA`_l0003o00>D00?o00000_mMOMX3o`00
00?oYK;R00?o0000om;@eooBd=L00_oBd=L01?l0003ojMg6onWMa_l00002ooCQ]`06o`000?ojhjco
0000oocTY?l0003oo>FO1ol000001?o0l_7o0000omjf[ol00006omo2^`04o`000?oKfMCofmWDo`00
00Oo`J[31?l00003oea]b`05o`000?miSM_oNHgKogV=fol000001Onj_=/00ol0003ohMG;o`000002
ooCN]`03o`000?okhJKo000002cooooo00?o0000ooooooooool03Oooool4o`0006_ooooo00?o003o
ooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0
0001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`26ooooo`03o`000?oooooo
oooo00cooooo00Go0000om>W[?oCYjcodjN/o`000007omB/[`;o00001OnTTL800ol0003o00>Do`00
0003o`0000GoYK;R00?o0000om;@eooBd=L00_oBd=L01ol0003ojMg6onWMa_oYgLKo0000ooCQ]ol0
00000_ojhj`02?l0003oo>BTo`000?l0003ommR[o`000?okfJ?o00000oooool3o`0000Kogl:k00Go
0000om_Ie?oKfMCofmWDo`000006ol6Z``03o`000?o0]]3o000000;oLXKH1?l000000omiSM_o0000
o`000005okZlf`08o`000?oQeL_ohMG;o`000?odg[Oo0000oo_QY_l0000iooooo`Co0000Koooool0
0ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVI
V@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo08Oooooo00?o0000
ooooooooool02oooool01?l0003odjN/om>W[?l00008omB/[`03o`000?nTTL;oY97200CoY9720ol0
00000ol2=k[o0000ojFbhP04ojFbhP03o`000?oBd=Ood]3G00?od]3G00Co0000onWMa_oYgLKo0000
0_odhKL01_l0003on^>/oo[S[?l0003oo>BTo`0000;ommR[0_l00006ooooo`03o`000?oO`[_ogl:k
00?ogl:k00?o0000om_Ie?oKfM@00ooKfM@01?l0003o`J[3ol6Z`oo1Z/<2o`0000?o`;K@00?o0000
og:6f?mbQ]P00_mbQ]P2o`0000Ko^[cK00Co0000on7EbooQeL_o00000_odg[L00ol0003onn6Vo`00
000eooooo`Co0000Loooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go
0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0
003ooooo08Sooooo0_l0000<ooooo`03o`000?oCYjco000000Ooe:b_00?o0000omFb]_l000001_nT
TL83o`000003o`8g^_l0003oYK;R00;oYK;R00?o0000om;@eooBd=L00ooBd=L01?l0003ojMg6onWM
a_l00003ooCQ]`05o`000?ojhjco0000oocTY?l000000_ogf:/00ol0003onmVSo`000007ooooo`05
o`000?oO`[_ogl:komo2^ol000001_oKfM@01?l0003o`J[3ol6Z`ol00005ol2fd003o`000?mbQ]So
LXKH00?oLXKH00?o0000okZlfonj_=/00onj_=/01ol0003ohMG;on7EbooQeL_o0000ooCN]ol00000
0_okhJH00ol0003oooooooooo`0`ooooo`?o0000Moooool00ol00?ooooooooooo`04ooooo`03o`00
oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000
ooooo`02olg=c@03oiVIVOl0003ooooo08[ooooo00?o0000ooooooooool02Oooool00ol0003odjN/
o`000006omB/[`04o`000?oE/[KoeK:fo`0000KoY9720ol00002o`8g^P03o`000?nU/^;o000000Go
d]3G00Go0000onWMa_oYgLKojMg6o`000002ooCQ]`03o`000?ojhjcon^>/00?o00000_ogf:/00ol0
003onmVSo`000008ooooo`03o`000?oO`[_o000000OofmWD00?o0000ol6Z`ol000001oo0]]000ol0
003oLXKHog:6f003og:6f005o`000?nj_=_o^[cKokZlfol000000ooQeL/01_l0003om=jgooCN]ol0
003onn6Vo`0002oooooo1?l0001jooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool0
2_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=
00?oVIVIo`000?ooool0Roooool00ol0003oooooooooo`09ooooo`03o`000?oD[:ooe:b_00Goe:b_
00Go0000omFb]_oE/[KoeK:fo`000005ojBA`P04o`000?l09:co0000o`0000;o0SNj0_l00004om;@
e`05o`000?oYgLKojMg6onWMa_l000000oodhKL00ol0003on^>/oo[S[002o`0000?ommR[00?o0000
oo_IXol000002Oooool2o`0000OofmWD0_l00008ol2fd003o`000?mbQ]SoLXKH00CoLXKH00?o0000
okZlfol000001?oQeL/01_l0003om=jgooCN]ol0003onn6Vo`0002_ooooo1?l0001nooooo`03o`00
oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o
00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0S?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oD[:ooe:b_00Coe:b_00?o0000omFb]_oE/[H00_oE/[H00ol0003oY972
ojBA`P04ojBA`P03o`000?l09:co000000Co0SNj00Go0000om;@eooBd=Ood]3Go`000003onWMaP05
o`000?odhKOom>6go`000?ojhj`00_l000001oo_e;Oo0000ooOHZoogf:_o0000oo_IXol000003?oo
ool2o`0000;ofmWD0ol000000on=jOCo0000ol2fd007ol2fd0[o00000ooQeL/01?l0003om=jgooCN
]ol00002oo_QYP03o`000?oooooooooo02Gooooo1?l00022ooooo`03o`00oooooooooooo00Cooooo
00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003oooo
ool0003ooooo00;ocLg=00?oVIVIo`000?ooool0SOooool2o`0000Wooooo00?o0000omB/[ooD[:l0
0_oD[:l00ol0003oeK:fomFb]P03omFb]P03o`000?nTTL;oY97200CoY97200?o0000o`0T[?l09:`0
1?l000001?l2=k[o0000om;@eol00003onWMaP04o`000?odhKOom>6gooCQ]`;o000000Coglg7o`00
0?o_e;Oo00000_ogf:/00ol0003onmVSo`00000>ooooo`Go00000_n=jO@00ol0003o`;K@ol2fd004
ol2fd003o`000?nibnSo000000SoT:OU0_l000001ooQeL_o0000ooCN]oodg[Oo0000oo_QY_l00000
9Oooool3o`0008Kooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`2?ooooo`03o`000?oooooooooo00Kooooo00?o0000omB/[ooD[:l00_oD[:l00ol0003oeK:f
omFb]P04omFb]P03o`000?nTTL;oY97200?oY9721?l00003og::g0Go00000_oYgLH4o`0000;oglg7
00?o0000onoD]ol000000oogf:/00ol0003onmVSo`00000Cooooo`Co00000oo0]]02o`0000?o^L_X
00?o0000oi2WiOn@YnD01_n@YnD4o`000004ooCN]ol0003o0000o`00027ooooo1?l00029ooooo`03
o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0T?ooool00ol0003o
ooooooooo`06ooooo`04o`000?oD[:ooe:b_o`0000OoeK:f00?o0000ojBA`_nTTL800ol000000onV
VLSo0000obUAaP02o`0000OoLX[L0ol00002okbjf006o`000?oOcLOoglg7o`000?o_e;Oo00000_og
f:/00ol0003onmVSo`00000Gooooo`;o000000?o`;K@o`000?nibnP01OnibnP00ol0003oT:OUoi2W
i@02oi2Wi@?o00000onbcNh4o`0001kooooo1?l0002=ooooo`03o`00oooooooooooo00Cooooo00?o
003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0TOooool00ol0003oooooooooo`05ooooo`04o`000?oD
[:ooe:b_o`0000SoeK:f0_l00005ojJIb004o`000?lYDLKo0000o`0000GoLX[L00?o0000okbjf?nl
^]P00_nl^]P01?l0003oglg7omo=aol00002onoD]`06o`000?ogf:_ommR[o`000?okfJ?o00006Ooo
ool00ol0003o^L_XokW;j006okW;j004o`000?n@YnGo0000o`0000Go//g^00Co0000olo^jOo?k^Wo
00006oooool4o`00097ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`2Booooo`;o00001Oooool00ol0003oe:b_o`000009omFb]P03o`000?nVVLSoYYW800Co
YYW800Co0000obUAa_lYDLKo00000ombR]`2o`0000Co_;[H00Oo0000omo=aooOcLOoglg7o`000?o_
e;Oo000000?ommR[00?o0000oo_IXol000006_ooool00ol0003o^L_XokW;j004okW;j0?o00001Onb
cNh2o`0000;ocnkY00?o0000ooooooooool05oooool3o`0009Gooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`2Dooooo`03o`000?oooooooooo00?ooooo00?o
0000omFb]_oE/[H01ooE/[H00ol0003oe[k2o`000006ojJIb006o`000?lYDLKo:E76o`000?mbR]co
00001Onl^]P01Ol0003oglg7omo=aooOcLOo000000;okmBg00Co0000ooOHZoogf:_o00000_okfJ<0
0ol0003oooooooooo`0Iooooo`03o`000?nibnSo^L_X00?o00000on7g?h01Ol0003o//g^ok;=k_nb
cNko000000?ocnkY00?o0000ooooooooool05?ooool4o`0009Sooooo00?o003oooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?o
ooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`2Eooooo`03o`000?oooooooooo00;ooooo00?o
0000omFb]_oE/[H01_oE/[H01?l0003oe[k2omJn`_l00006ojJIb005o`000?lYDLKo:E76obUAa_l0
00001Onl^]P01Ol0003oglg7omo=aooOcLOo000000?okmBg00Ko0000ooOHZoogf:_o0000oo_IXol0
000Mooooo`?o00001_n7g?h00ol0003o//g^o`000003olo^j@03o`000?oooooooooo017ooooo1?l0
002Looooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0U_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oE/[KoeK:f00CoeK:f00?o0000omJn`_oF_/800_oF
_/800ol0003oYYW8ojJIb003ojJIb005o`000?lYDLKo:E76obUAa_l000001Onl^]P01Ol0003oglg7
omo=aooOcLOo000000;okmBg00Oo0000ooOHZoogf:_ommR[o`000?okfJ?o0000023ooooo2_l00000
0oo?k^Wo0000ooooo`0?ooooo`Co0000X?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo09Oooooo00?o0000ooooooooool00_ooool00ol0003oeK:fomFb]P02
omFb]P03o`000?oF_/;oe[k200?oe[k200?o0000ojJIb?nVVLP00onVVLP4o`000003obUAa_l0003o
_;[H00;o_;[H00Go0000omo=aooOcLOoglg7o`000003onoD]`04o`000?ogf:_ommR[o`0000;onmVS
00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0<ooooo`?o0000Y?ooool00ol00?oooooo
ooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007o
oooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo09Sooooo0_l00002ooooo`05o`00
0?oE/[KoeK:fomFb]_l000001_oF_/800ol0003oYYW8ojJIb003o`000004ojNTdol0003oIhGLofN5
g0?o000000?o_;[Ho`000?oOcLL00ooOcLL01Ol0003okmBgonoD]oo_e;Oo000000;ommR[00?o0000
oo_IXol00000=_ooool4o`000:Oooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:
ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd0
0onIVIWo0000ooooo`2Jooooo`06o`000?ooooooooooo`000?oE/[Ko00001ooF_/83o`0000GoYjCC
00?o0000ofN5g?mWQM`00_mWQM`2o`0000?oglg700Go0000onoD]oo_e;OokmBgo`000003ooOHZ`?o
0000<_ooool4o`000:_ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`2Kooooo`04o`000?ooooooooooo`0000Ooe[k200?o0000om3EgOl000001onWY=<00ol0
003oIhGLofN5g003ofN5g0;o000000?oglg7o`000?o_e;L00_o_e;L00ol0003ommR[ooOHZ`02o`00
0003onOSc_l0003ooooo02kooooo0ol0002_ooooo`03o`00oooooooooooo00Cooooo00?o003ooooo
ooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo
00;ocLg=00?oVIVIo`000?ooool0W?ooool01?l0003oooooooooool00005omJn`P05o`000?o@eMgo
d=GMom3EgOl000001_nWY=<00ol0003oIhGLofN5g004ofN5g0Co00000_o_e;L4o`000003onOSc_l0
003ooooo02_ooooo1?l0002booooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool0WOooool2o`000003ooooool0003oe[k200;oe[k200?o0000om3EgOo@eMd00oo@
eMd00ol0003oYjCCojNTd`04ojNTd`03o`000?mWQMcoIhGL00?o00001?nS]>D3o`0000;oc]?N00?o
0000onOSc_l00000:?ooool4o`000;Kooooo00?o003oooooooooool01?ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`2Oooooo`05o`000?oooooo0000omJn`_l000001_o@eMd00ol0003oYjCC
ojNTd`04ojNTd`?o00001_nS]>D00ol0003oc]?NolkCgP02olkCgP03o`000?oWhlko000002Gooooo
1?l0002jooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003ooooo
olg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0
X?ooool01?l0003oooooo`000?l00007om3Eg@03o`000?nWY=?oYjCC00?o00000_nX]n@00ol0003o
XkCUoj>di@03oj>di@03o`000?o>dmkoc]?N00;oc]?N00Co0000onOSc_oWhlko00008_ooool3o`00
0;kooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=
olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`2Qoooo
o`03o`000?oooooooooo00;o00000oo@eMd5o`0000KoZ;OT00Go0000oj>diOnS]>GoXkCUo`000004
olkCgP04o`000?oWhlkoin?>o`0001oooooo1?l00031ooooo`03o`00oooooooooooo00Cooooo00?o
003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0X_ooool2o`0000;ooooo1ol00008ojRgi003o`000?nS
]>Go000000Coc]?N00Co0000onOSc_oWhlko00007?ooool4o`000<Gooooo00?o003oooooooooool0
1?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`00
00?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`2Tooooo`03o`000?oooooooooo00Gooooo
0_l00006ojRgi0Co00000oo>dmh01Ol0003oin?>onOSc_oWhlko000001Sooooo1?l00039ooooo`03
o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0YOooool00ol0003o
ooooooooo`06ooooo`03o`000?nX]nCoZ;OT00?o00001?nPd_T00ol0003oc]?No`000003onOScP03
o`000?oooooooooo01Cooooo0ol0003=ooooo`03o`00oooooooooooo00Cooooo00?o003ooooooooo
ool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;o
cLg=00?oVIVIo`000?ooool0Y_ooool00ol0003oooooooooo`06ooooo`;o00001onPd_T4o`0000;o
in?>00?o0000ooooooooool04?ooool4o`000=3ooooo00?o003oooooooooool01?ooool00ol00?oo
ooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?oo
ool00_o=cLd00onIVIWo0000ooooo`2Wooooo`;o00002?ooool2o`0000;oX=;i0ol00002og;MlPCo
00003oooool4o`000=Cooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`2Yooooo`03o`000?oooooooooo00Gooooo00?o0000ooooool000001_l0000?ooooo`Co
0000f?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=
cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0:[o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Booooo`?o0000g?ooool00ol00?oo
ooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00
007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0:_ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0>ooooo`Co0000goooool00ol00?ooooooooooo`04ooooo`03
o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo
0000ooooo`02olg=c@03oiVIVOl0003ooooo0:cooooo0_l00003ooooo`03o`000?oooooooooo00[o
oooo1?l0003Sooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003o
ooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?oo
ool0[_ooool01?l0003oooooooooool00008ooooo`Co0000ioooool00ol00?ooooooooooo`04oooo
o`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooo
oooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0:oooooo00?o0000ooooool000001Oooool3o`00
0>_ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=
olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`2`oooo
o`;o000000?oooooo`000?l000000_l0003^ooooo`03o`00oooooooooooo00Cooooo00?o003ooooo
ooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo
00;ocLg=00?oVIVIo`000?ooool0/Oooool2o`000?;ooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`3oooooojKooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`3oooooojKooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`3oooooojKooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`3oooooojKooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`3ooooooj?ooooo1?l00?l6ooooo`03o`00oooooooooooo
00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=
c@03oiVIVOl0003ooooo0?ooooooY_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo
00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=
c@03oiVIVOl0003ooooo0?ooooooX_ooool5o`00o`Kooooo00?o003oooooooooool02_ooool01Ol0
003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`00
0?ooool0oooooon]ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02
o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0?oooooo[Oooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`3oooooojgooooo00?o003oooooooooool02_ooool01Ol0
003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`00
0?ooool0oooooon]ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02
o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0?oooooo[Oooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`3oooooojgooooo00?o003oooooooooool02_ooool01Ol0
003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`00
0?ooool0oooooon]ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02
o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0?oooooo[Oooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`3oooooojgooooo00?o003oooooooooool02_ooool01Ol0
003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`00
0?ooool0oooooonRooooo`Go003o1_ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=
olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3ooooo
ojKooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=
olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1Moooo
o`Co00006oooool4o`0000;ooooo1?l0000Zooooo`Co00005Oooool4o`0000?ooooo1?l0000Boooo
o`;o0000?Oooool2o`0001?ooooo0_l00003ooooo`Co0000=_ooool2o`0000Cooooo1?l0000Roooo
o`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgo
VIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool04Oooool2o`00
o`Kooooo0_l00?m2ooooo`;o00007Oooool2o`0000Gooooo0_l0000[ooooo`;o00006Oooool2o`00
00Gooooo0_l00004ooooo`;o00002oooool2o`0000gooooo0_l0000Jooooo`;o00005?ooool2o`00
00Cooooo0_l0000;ooooo`;o00001Oooool2o`0000Kooooo0_l0000Kooooo`;o00004oooool2o`00
00Gooooo0_l0000Rooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0
003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`00
0?ooool04Oooool00ol00?ooooooooooo`06ooooo`03o`00oooooooooooo00kooooo1Ol00004oooo
o`Ko00000oooool4o`0000Gooooo0ol00004ooooo`Co00000_ooool5o`0000Gooooo0_l00004oooo
o`Go00000oooool6o`000003ooooool0003o000000Ko00000_ooool2o`0000Kooooo0_l00009oooo
o`03o`000?oooooooooo00Gooooo1Ol00003ooooo`Ko000000?oooooo`000?l000001_l00002oooo
o`;o00001Oooool4o`0000Kooooo1_l00004ooooo`;o00001Oooool2o`0000Gooooo0_l0000:oooo
o`;o00001?ooool6o`0000Cooooo0_l0000Aooooo`Co00001Oooool2o`0000[ooooo1?l00005oooo
o`;o00001Oooool2o`0000[ooooo0_l00006ooooo`;o00001_ooool2o`0001;ooooo1?l00005oooo
o`;o00002Oooool4o`0000Gooooo0_l00005ooooo`;o00008_ooool00ol00?ooooooooooo`04oooo
o`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooo
oooo0000ooooo`02olg=c@03oiVIVOl0003ooooo00[ooooo00?o003oooooool00?l00_ooool00ol0
0?ooooooo`00o`03ooooo`;o003o0oooool01?l00?ooooooooooool00?l>ooooo`;o00002?ooool2
o`0000Cooooo0_l00002ooooo`;o00000oooool2o`000003ooooool0003o000000;ooooo0_l00002
ooooo`;o00000_ooool2o`000003ooooool0003o000000Cooooo0_l00004ooooo`;o00000_ooool2
o`0000Cooooo0_l00004ooooo`;o00000_ooool2o`0000?ooooo0_l00006ooooo`;o00002Oooool0
0ol0003oooooooooo`05ooooo`;o00000_ooool2o`0000Cooooo0_l00004ooooo`;o00000_ooool2
o`0000?ooooo0_l00004ooooo`;o00000_ooool2o`0000Kooooo1?l00005ooooo`;o00001Oooool2
o`00017ooooo0_l00005ooooo`Co00005oooool2o`0000;ooooo0_l0000?ooooo`;o00000_ooool2
o`0000Cooooo0_l0000Aooooo`;o00001_ooool2o`0001Wooooo0_l00002ooooo`;o00003_ooool2
o`0000;ooooo0_l00004ooooo`;o00001Oooool2o`0002;ooooo00?o003oooooooooool01?ooool0
0ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?ooooo
o`000?ooool00_o=cLd00onIVIWo0000ooooo`0:ooooo`03o`00oooooooo003o00;ooooo00?o003o
ooooool00?l00_ooool01?l00?ooooooooooool00?l2ooooo`03o`00oooooooooooo00;ooooo1?l0
0?l9ooooo`;o00002?ooool2o`0000Cooooo0_l00002ooooo`;o00000oooool2o`0000Wooooo0_l0
0002ooooo`;o00000_ooool2o`0000?ooooo0_l00008ooooo`;o00001?ooool2o`0000Cooooo0_l0
0002ooooo`;o00000oooool2o`0000Gooooo1?l00006ooooo`Go00002Oooool2o`0000Cooooo0_l0
0004ooooo`;o00000_ooool2o`0000?ooooo0_l00008ooooo`;o00001oooool2o`0000Kooooo0_l0
0005ooooo`;o00004?ooool2o`0000Oooooo0_l0000Aooooo`Go00001_ooool2o`0001?ooooo0_l0
0005ooooo`;o00003oooool2o`0000Kooooo1?l0000@ooooo`Go00001oooool2o`0001;ooooo0_l0
0005ooooo`;o00001?ooool2o`0002;ooooo00?o003oooooooooool01?ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`0:ooooo`03o`00oooooooo003o00;ooooo00?o003oooooool00?l01Ooo
ool01?l00?ooooooooooool00?lAooooo`Go00001Oooool2o`0000Cooooo0_l00002ooooo`;o0000
0oooool2o`0000Wooooo0_l00002ooooo`;o00000_ooool2o`0000?ooooo0_l00008ooooo`;o0000
1?ooool2o`0000Cooooo0_l00002ooooo`;o00000oooool2o`0000Gooooo1?l00008ooooo`03o`00
0?oooooooooo00Wooooo0_l00004ooooo`;o00001?ooool2o`0000;ooooo0_l00003ooooo`;o0000
2?ooool2o`0000Oooooo0_l00006ooooo`;o00001Oooool2o`00017ooooo0_l00006ooooo`;o0000
7?ooool2o`0001?ooooo0_l00004ooooo`;o00004Oooool2o`0000Gooooo1?l0000Looooo`;o0000
4_ooool2o`0000Cooooo0_l00005ooooo`;o00008_ooool00ol00?ooooooooooo`04ooooo`03o`00
oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000
ooooo`02olg=c@03oiVIVOl0003ooooo00[ooooo00So003oooooool00?oo003oooooool00?oooooo
o`00o`Gooooo00Co003ooooooooooooo003o1?ooool4o`00o`Wooooo0_l00002ooooo`;o00001?oo
ool2o`0000Cooooo0_l00002ooooo`;o00000oooool2o`0000Oooooo0ol00003ooooo`;o00000_oo
ool2o`0000?ooooo0_l00005ooooo`Co00001Oooool2o`0000Cooooo0ol000000ooooooo0000o`00
0003ooooo`;o00001?ooool2o`0000;ooooo0_l00007ooooo`03o`000?oooooooooo00Kooooo1?l0
0005ooooo`;o00001?ooool3o`000003ooooool0003o000000?ooooo0_l00006ooooo`?o00001ooo
ool4o`0000Gooooo0_l00005ooooo`;o00004Oooool2o`0000Gooooo1?l0000Iooooo`?o00004_oo
ool3o`0000Gooooo0_l0000Aooooo`;o00001?ooool2o`0000;ooooo0_l0000Iooooo`?o00004Ooo
ool3o`0000Gooooo0_l00005ooooo`;o00008_ooool00ol00?ooooooooooo`04ooooo`03o`00oooo
oooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000oooo
o`02olg=c@03oiVIVOl0003ooooo00[ooooo00Go003oooooool00?ooooooo`00o`02ooooo`03o`00
oooooooooooo00?o003o0oooool01?l00?ooooooooooool00?l>ooooo`;o00000_ooool2o`0000Co
oooo0_l00005ooooo`Co00000oooool5o`0000Oooooo0_l00002ooooo`;o00000_ooool2o`0000?o
oooo0_l00004ooooo`;o00001_ooool4o`0000?ooooo1_l00004ooooo`;o00000oooool8o`0000ko
oooo0_l00006ooooo`Co00000oooool6o`0000Cooooo0_l00008ooooo`;o00001Oooool6o`0000Co
oooo0_l00005ooooo`;o00004Oooool2o`0000Cooooo1_l0000Jooooo`;o00004oooool2o`0000Co
oooo0_l0000Aooooo`;o00000oooool8o`0001[ooooo0_l0000Booooo`;o00001?ooool2o`0000Go
oooo0_l0000Rooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003o
ooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?oo
ool02_ooool00ol00?ooooooooooo`04ooooo`04o`00ooooooooooooo`00o`Gooooo00?o003ooooo
ooooool03oooool2o`0000;ooooo0_l00004ooooo`;o00003Oooool2o`0000Gooooo0_l00002oooo
o`;o00000_ooool2o`000003ooooool0003o000000Cooooo0_l00004ooooo`;o00000_ooool2o`00
01?ooooo0_l0000Iooooo`;o00000_ooool2o`0001?ooooo0_l00004ooooo`;o00000_ooool2o`00
00oooooo0_l00005ooooo`;o00004Oooool2o`00023ooooo0_l00002ooooo`;o00003oooool2o`00
00;ooooo0_l00004ooooo`;o00004Oooool2o`00027ooooo0_l00002ooooo`;o00003_ooool2o`00
00;ooooo0_l00004ooooo`;o00001Oooool2o`00027ooooo0_l00?l6ooooo`03o`00oooooooooooo
00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=
c@03oiVIVOl0003ooooo00[ooooo00?o003oooooooooool01?ooool2o`00o`03ooooool00?oo003o
00;o003o00?oooooo`00ool00?l04?ooool6o`0000?ooooo1?l0000=ooooo`;o00001_ooool4o`00
00;ooooo1Ol00005ooooo`Co00000oooool5o`0000Cooooo0_l0000=ooooo`Co00006?ooool5o`00
00Cooooo0_l0000=ooooo`Co00000oooool4o`0000kooooo1?l00003ooooo`Co00004_ooool2o`00
023ooooo1?l0000Aooooo`Co00001?ooool2o`0001?ooooo0_l0000Qooooo`Co00004?ooool4o`00
00Cooooo0_l00004ooooo`Co00008?ooool00ol00?ooooooo`00o`06ooooo`03o`00oooooooooooo
00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=
c@03oiVIVOl0003ooooo0?ooooooXoooool01?l00?ooooooooooool00?l6ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo0?ooooooX_ooool01Ol00?oooooooooooooooooo003o00Kooooo00?o
003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonQooooo`Ko003o0_ooool5o`00o`cooooo00Go
0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0
003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3ooooook[ooooo00Go
0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0
003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3ooooook[ooooo00Go
0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0
003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3ooooook[ooooo00Go
0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0
003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3ooooook[ooooo00Go
0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0
003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3ooooooj;ooooo1Ol0
0?l2ooooo`Go003o3?ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0IOooool00ol0003oooooooooo`3oooooockooooo00?o
003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1Uooooo`03o`000?oo
oooooooo0?oooooo?_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go
0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0
003ooooo06Cooooo0_l00008ooooo`?o0000ooooooleooooo`03o`00oooooooooooo00Cooooo00?o
003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0I?ooool00ol0003oooooo`000006ooooo`05o`000?oo
ooooooooooooool00000ooooooldooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool0
2_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=
00?oVIVIo`000?ooool0Hoooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo0?oo
oooo<_ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=
cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo067o
oooo00?o0000ooooool000000_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo03So
oooo0ol0001Pooooo`?o0000Toooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[o
oooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003ooooo06;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`;o
0000>_ooool01Ol0003ooooooooooooooooo000005kooooo00Go0000ooooooooooooooooo`00002B
ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=
cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0Ioooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo03_ooooo00?o0000ooooooooool0G?ooool0
1Ol0003ooooooooooooooooo000009;ooooo00?o003oooooooooool01?ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`0booooo`;o0000<oooool00ol0003oooooooooo`03ooooo`05o`000?oo
ooooooooooooool00000?Oooool00ol0003oooooooooo`1Looooo`05o`000?ooooooooooooooool0
0000HOooool2o`0002oooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`0aooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool01?ooool3o`0003co
oooo0_l0001Oooooo`Co0000I?ooool00ol0003oooooooooo`0/ooooo`03o`00oooooooooooo00Co
oooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003
ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0<Oooool00ol0003oooooooooo`0dooooo`03
o`000?oooooooooo04Cooooo00?o0000ooooooooool0G?ooool00ol0003oooooooooo`1Uooooo`03
o`000?oooooooooo02cooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`0aooooo`03o`000?oooooooooo03Cooooo00?o0000ooooooooool0@?ooool01Ol0003o
oooooooooooooooo000005oooooo00?o0000ooooooooool0I?ooool00ol0003oooooooooo`0/oooo
o`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgo
VIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0<Oooool00ol0
003oooooooooo`0dooooo`co0000>?ooool3o`0001Sooooo1?l00015ooooo`?o00005oooool4o`00
04Sooooo00?o0000ooooooooool0;?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo
00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=
c@03oiVIVOl0003ooooo01Oooooo0_l00?l6ooooo`;o003o4?ooool00ol0003oooooooooo`2Foooo
o`;o00001?ooool2o`0002Kooooo0_l0000cooooo`;o00001?ooool2o`0003Wooooo0_l00006oooo
o`03o`000?oooooooooo02cooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onI
VIWo0000ooooo`0Gooooo`03o`00oooooooooooo00Kooooo00?o003oooooooooool03_ooool00ol0
003oooooooooo`2Gooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool09_ooool00ol0
003oooooooooo`0booooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0>Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo02cooooo00?o003oooooooooool01?ooool00ol0
0?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`00
0?ooool00_o=cLd00onIVIWo0000ooooo`0:ooooo`;o003o1?ooool00ol00?ooooooo`00o`02oooo
o`03o`00oooooooo003o00Gooooo00Co003ooooooooooooo003o4?ooool00ol0003oooooooooo`24
ooooo`Ko00000oooool3o`0000Cooooo0_l000000ooooooo0000ooooo`03ooooo`03o`000?oooooo
oooo00Wooooo1Ol0000>ooooo`;o00000oooool2o`0000?ooooo00?o0000ooooooooool07oooool6
o`0000?ooooo0ol00004ooooo`;o000000?oooooo`000?ooool00oooool00ol0003oooooooooo`02
ooooo`Go00003_ooool2o`0000?ooooo0_l0000<ooooo`;o00000oooool2o`0000[ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0/ooooo`03o`00oooooooooooo00Cooooo00?o003o
ooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003o
oooo00;ocLg=00?oVIVIo`000?ooool02Oooool01?l00?ooooooooooool00?l2ooooo`06o`00oooo
oooo003oo`00oooooooo003o0_ooool00ol00?ooooooooooo`03ooooo`05o`00ooooooooooooo`00
ooooool01?l00?l:ooooo`03o`000?oooooooooo06gooooo00?o0000ooooooooool05_ooool01Ol0
003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oo
oooooooo00;o00001?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool01Oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0
8?ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002oooo
o`03o`000?oooooooooo00;o00001?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000
ooooooooool01Oooool01Ol0003ooooooooooooooooo000000_ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`0[ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool02?ooool00ol00?ooooooooooo`02ooooo`03o`00oooooooo003o00;ooooo00?o
003oooooool00?l00_ooool00ol00?ooooooooooo`04o`00o`;ooooo00?o003oooooooooool03?oo
ool00ol0003oooooooooo`0<oooooeWo00002Oooool00ol0003oooooooooo`06ooooo`[o00001_oo
ool01ol0003ooooooooooooooooo0000ooooool000001Oooool2o`0000Cooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool01_ooool00ol0003oooooo`000005ooooo`03o`000?oooooooooo013ooooo2_l00006ooooo`07
o`000?ooooooooooooooool0003oooooo`000005ooooo`;o00001?ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`06
ooooo`03o`000?oooooo000000Oooooo00?o0000ooooooooool01_ooool00ol0003oooooo`00000<
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0:_ooool00ol00?ooooooooooo`04
ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo0000
0ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo00Sooooo00?o003oooooooooool00_ooool0
0ol00?ooooooo`00o`02ooooo`03o`00oooooooo003o00;ooooo00Co003ooooooooooooo003o0_oo
ool01Ol00?ooooooooooool00?oooooo00Co003o2_ooool00ol0003oooooooooo`03ooooo`Go0000
Hoooool5o`0001Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`;o0000
1?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo1Ol00004ooooo`03o`00
0?oooooooooo00Gooooo1Ol00007ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1Oooool5o`0001Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`;o0000
1?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1Oooool5o`0000Oooooo00?o0000ooooooooool01?ooool5o`0000Oooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02_ooooo00?o003oooooooooool0
1?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`00
00?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`08ooooo`03o`00oooooooooooo00;ooooo
00?o003oooooool00?l00_ooool01_l00?ooooooo`00ool00?ooooooo`00o`?ooooo00?o003ooooo
ool00?l00_ooool00ol00?ooooooooooo`0>ooooo`03o`000?oooooooooo06cooooo00?o0000oooo
ooooool05_ooool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool000000_ooool0
0ol0003oooooooooo`02o`0000Cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooool000001Oooool00ol0003oooooooooo`0P
ooooo`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oo
oooooooo00;o00001?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool01_ooool00ol0003oooooo`000007ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooool000003?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02cooooo00?o
003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`09ooooo`04o`00oooo
ooooooooo`00o`Oooooo00Co003ooooooooooooo003o1?ooool2o`00o`;ooooo00?o003ooooooooo
ool03_ooool00ol0003oooooooooo`1/ooooo`03o`000?oooooooooo01Kooooo00?o0000oooooooo
ool01Oooool3o`0000Cooooo0_l000000ooooooo0000o`000003ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`04ooooo`?o000000Coooooo`000?l0
003o00000oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00Gooooo0ol00004oooo
o`;o000000?oooooo`000?l000000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01?ooool3o`000004ooooool0003o0000o`0000Gooooo00?o0000
ooooooooool01?ooool3o`000004ooooool0003o0000o`0000[ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0/ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool02_ooool2o`00o`_ooooo0_l00?l4ooooo`04o`00oooooooo003oo`00oa3ooooo
00?o0000ooooooooool0Aoooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool02Oooool3o`0001[ooooo00?o0000ooooooooool08?ooool00ol0003ooooo
ooooo`0Dooooo`03o`000?oooooooooo00;ooooo0ol0000[ooooo`Co00001Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo02cooooo00?o003oooooooooool01?ooool00ol00?oooooo
ooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool0
0_o=cLd00onIVIWo0000ooooo`0aooooo`03o`000?oooooooooo04Oooooo00?o0000ooooooooool0
>_ooool4o`0001Cooooo0_l0000<ooooo`03o`000?oooooooooo01Oooooo0_l0000Qooooo`Co0000
5?ooool2o`0000Gooooo00?o0000ooooooooool0:Oooool2o`0000Kooooo0_l00006ooooo`03o`00
0?oooooooooo02cooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`0aooooo`03o`000?oooooooooo04Kooooo0_l0003/ooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool0;?ooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo
00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVI
VOl0003ooooo037ooooo00?o0000ooooooooool0AOooool00ol0003oooooo`00003]ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool0;?ooool00ol00?ooooooooooo`04ooooo`03o`00
oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000
ooooo`02olg=c@03oiVIVOl0003ooooo037ooooo00?o0000ooooooooool0@_ooool01_l0003ooooo
ooooool0003oooooo`0000Gooooo0ol0000Wooooo`Go0000G_ooool5o`0005?ooooo00Co0000oooo
oooooooo00003?ooool00ol0003oooooooooo`0/ooooo`03o`00oooooooooooo00Cooooo00?o003o
ooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003o
oooo00;ocLg=00?oVIVIo`000?ooool0<Oooool00ol0003oooooooooo`13ooooo`;o00000oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0H?ooool0
0ol0003oooooooooo`1Dooooo`;o00003Oooool00ol0003oooooooooo`0/ooooo`03o`00oooooooo
oooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Ooo
ool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0<_ooool2o`0004Cooooo00Go0000
ooooooooooooooooo`000005ooooo`;o0000:Oooool00ol0003oooooooooo`1Pooooo`03o`000?oo
oooooooo067ooooo0_l0000_ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool0O?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02Kooooo00?o
0000ooooooooool0H?ooool00ol0003oooooooooo`2Booooo`03o`00oooooooooooo00Cooooo00?o
003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0
003ooooo00;ocLg=00?oVIVIo`000?ooool0KOooool2o`0000gooooo00?o0000ooooooooool00_oo
ool01?l0003oooooooooool0000<ooooo`;o00006_ooool00ol0003oooooooooo`1Pooooo`03o`00
0?oooooooooo09;ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`1]ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00oooool2o`0000kooooo
00?o0000ooooooooool06?ooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo09;ooooo
00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnI
VIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`1]ooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Fooooo`?o0000
H?ooool3o`0009Cooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`1]ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo063ooooo00?o0000ooooooooool0T_ooool00ol00?oooooo
ooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007o
oooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo06gooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?oooooo4Oooool00ol00?oooooo
ooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007o
oooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo06gooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?oooooo4Oooool00ol00?oooooo
ooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007o
oooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo06gooooo00?o0000ooooooooool0
3Oooool:o`0000_ooooo00?o0000ooooooooool0oooooolAooooo`03o`00oooooooooooo00Cooooo
00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003oooo
ool0003ooooo00;ocLg=00?oVIVIo`000?ooool0@?ooool3o`000005ooooool0003o0000o`000?oo
ool01?l00004ooooo`?o00000oooool5o`0000?ooooo0_l000000ooooooo0000o`000003o`000004
ooooool0003o0000o`0000?ooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`3ooooo
oa7ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=
olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`11oooo
o`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`03ooooo`05o`000?oooooo
ooooooooool000001?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o00000_oo
ool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool08_ooool00ol0003ooooo
ooooo`3ooooooa7ooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`00
0?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000
ooooo`11ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo0000
00;ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00?ooooo6_l00005
ooooo`03o`000?oooooooooo0?oooooo4Oooool00ol00?ooooooooooo`04ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo047ooooo1Ol00003ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`03ooooo`Co00000_ooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`3ooooooa7ooooo00?o
003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`12ooooo`03o`000?oo
oooo000000Cooooo0_l00004ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00;o00000_ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo02;ooooo00?o0000ooooooooool0oooooolAooooo`03o`00oooooooooooo00Cooooo
00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003oooo
ool0003ooooo00;ocLg=00?oVIVIo`000?ooool0@_ooool00ol0003oooooo`000003ooooo`;o0000
00?oooooo`000?l000000oooool4o`000005ooooool0003oooooooooool000000_ooool00ol0003o
ooooo`000003o`0000;ooooo0_l000000ooooooo0000o`000005ooooo`03o`000?oooooooooo02;o
oooo00?o0000ooooooooool0oooooolAooooo`03o`00oooooooooooo00Cooooo00?o003ooooooooo
ool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;o
cLg=00?oVIVIo`000?ooool0@oooool00ol0003oooooooooo`0?ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`04ooooo`Go00000oooool01?l0
003oooooooooooooool4o`0000;ooooo0_l000000ooooooo0000o`000007ooooo`03o`000?oooooo
oooo0?oooooo4Oooool00ol00?ooooooooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000
ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003o
oooo047ooooo0ol0000Aooooo`Oo00004Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00?ooooo00Co0000oooooooooooooooo0_l00005ooooo`?o00002?ooool00ol0003ooooooooo
o`3oooooo`kooooo1?l00?l6ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=
oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo06gooooo00?o
0000ooooooooool01_ooool01?l0003oooooooooooooool5o`0000?ooooo00?o0000ooooooooool0
0_ooool00ol0003oooooo`000008ooooo`03o`000?oooooooooo0?oooooo4Oooool00ol00?oooooo
ooooo`04ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007o
oooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo06gooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
0_l000000ooooooo0000o`000007ooooo`03o`000?oooooooooo0?oooooo4?ooool2o`00o`Kooooo
00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003oooo
ool0003ooooo00;ocLg=00?oVIVIo`000?ooool0KOooool00ol0003oooooooooo`04ooooo`?o0000
1Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool03?ooool00ol0003o
ooooooooo`3oooooo`oooooo00?o003oooooool00?l01_ooool00ol00?ooooooooooo`0:ooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`1]ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02?ooool2o`0000oo
oooo00?o0000ooooooooool0ooooool>ooooo`04o`00ooooooooooooo`00o`Kooooo00?o003ooooo
ooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo
00;ocLg=00?oVIVIo`000?ooool0KOooool2o`0002;ooooo0_l0003oooooo`oooooo00Go003ooooo
ooooooooooooo`00o`06ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVI
V@02o`00007ooooo00000ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo0?ooooooXOooool6
o`00o`Kooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Ooo
ool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooon]ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo0?oooooo[Oooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooo
cLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3o
ooooojgooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Ooo
ool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooon]ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo0?oooooo[Oooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooo
cLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3o
ooooojgooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Ooo
ool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooon]ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo0?oooooo[Oooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooo
cLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3o
ooooojgooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Ooo
ool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooon]ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo0?ooooooX_ooool5o`00o`Kooooo00?o003oooooooooool02_ooool0
1Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVI
o`000?ooool0oooooonVooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool0
1Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVI
o`000?ooool0COooool4o`0002Gooooo1?l0000Gooooo`;o0000=Oooool2o`0001Wooooo1?l0002n
ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=
cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool04_ooool2
o`00o`Kooooo0_l00?ldooooo`;o00009?ooool2o`0000kooooo00?o0000ooooooooool01oooool2
o`0003Oooooo0_l00004ooooo`;o00005?ooool2o`000;kooooo00?o003oooooooooool01?ooool0
0ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?ooooo
o`000?ooool00_o=cLd00onIVIWo0000ooooo`0Booooo`03o`00oooooooooooo00Kooooo00?o003o
ooooooooool03oooool6o`000003ooooool0003o000000Ko00000oooool3o`0000Cooooo1?l00003
ooooo`Go00000oooool5o`0000?ooooo1_l00004ooooo`?o00001?ooool4o`0000Cooooo0_l00004
ooooo`Ko00001?ooool2o`0000Sooooo0_l00004ooooo`Ko00003oooool4o`00013ooooo1_l00004
ooooo`;o00001Oooool2o`0000Wooooo1_l00004ooooo`;o0000__ooool00ol00?ooooooooooo`04
ooooo`03o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo0000
0ooooooo0000ooooo`02olg=c@03oiVIVOl0003ooooo00_ooooo00?o003oooooool00?l00_ooool0
0ol00?ooooooo`00o`05ooooo`04o`00ooooooooooooo`00o`;ooooo00?o003oooooooooool03_oo
ool2o`0000Cooooo0_l00002ooooo`;o00000oooool2o`000003ooooool0003o000000;ooooo0_l0
0002ooooo`;o000000?oooooo`000?l000000_ooool2o`0000Cooooo0_l00004ooooo`;o00000_oo
ool2o`0000Cooooo0_l000000ooooooo0000o`000002ooooo`;o00000_ooool2o`0000?ooooo0_l0
0006ooooo`;o00001oooool00ol0003oooooooooo`06ooooo`;o00001Oooool4o`0000oooooo0_l0
0002ooooo`;o00004Oooool2o`0000Kooooo0_l0000Aooooo`Co00001Oooool2o`000;kooooo00?o
003oooooooooool01?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT0
0_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`0;ooooo`03o`00oooo
oooo003o00;ooooo00?o003oooooool00?l01Oooool01?l00?ooooooooooool00?l4ooooo`Co003o
2oooool2o`0000Cooooo0_l00002ooooo`;o00000oooool2o`0000Gooooo0_l00005ooooo`;o0000
0_ooool2o`0000Cooooo0_l00004ooooo`;o00000_ooool2o`0000Cooooo0_l00005ooooo`;o0000
1oooool2o`0000Kooooo0_l00007ooooo`;o00001_ooool2o`0000Oooooo0_l0000Dooooo`;o0000
1Oooool5o`0000Oooooo0_l00007ooooo`;o00004Oooool2o`0000Kooooo0_l0002nooooo`03o`00
oooooooooooo00Cooooo00?o003oooooooooool02_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o
00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool02oooool00ol00?oooooo
o`00o`02ooooo`03o`00oooooooo003o00;ooooo1?l00?l2ooooo`03o`00oooooooooooo017ooooo
0_l00004ooooo`;o00000_ooool2o`0000?ooooo0_l00005ooooo`Ko000000?oooooo`000?l00000
0_ooool2o`0000Cooooo0_l00005ooooo`Go00001?ooool2o`0000Gooooo1_l00003ooooo`;o0000
1_ooool2o`0000Sooooo00?o0000ooooooooool01Oooool2o`0000Kooooo0_l0000Dooooo`;o0000
4Oooool2o`0000Kooooo0_l0000Booooo`;o00001_ooool2o`000;kooooo00?o003oooooooooool0
1?ooool00ol00?ooooooooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`00
00?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`0;ooooo`08o`00oooooooo003oo`00oooo
oooo003oooooool00?l2ooooo`04o`00ooooooooooooo`00o`;ooooo00?o003oooooooooool00_oo
ool4o`00o`_ooooo0_l00004ooooo`?o000000?oooooo`000?l000000oooool2o`0000Gooooo0_l0
0002ooooo`;o000000?oooooo`000?l000000_ooool2o`0000Cooooo0ol00003ooooo`;o00000_oo
ool2o`0000Cooooo0_l00005ooooo`;o00000_ooool2o`0000?ooooo0_l00006ooooo`;o00002?oo
ool2o`0000Kooooo0_l00005ooooo`Co00004Oooool3o`0001;ooooo0_l00006ooooo`;o00004Ooo
ool4o`0000Gooooo0_l0002nooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool02_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?o
VIVIo`000?ooool02oooool01Ol00?ooooooo`00oooooooo003o00;ooooo00Oo003ooooooooooooo
ooooo`00oooooooo003o00;ooooo00Co003ooooooooooooo003o4?ooool2o`0000?ooooo1_l00003
ooooo`Go00001?ooool4o`0000?ooooo1_l00002ooooo`Ko00000_ooool4o`0000Cooooo1Ol00004
ooooo`Co00001?ooool2o`0000Cooooo1?l00009ooooo`03o`000?oooooooooo00Cooooo0_l00004
ooooo`Ko00001?ooool2o`0000;ooooo0_l00008ooooo`;o00003oooool4o`0000Kooooo0_l0000@
ooooo`Ko00001?ooool2o`000;kooooo00?o003oooooooooool01?ooool00ol00?ooooooooooo`0:
ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd0
0onIVIWo0000ooooo`0;ooooo`03o`00oooooooooooo00Cooooo00?o003oooooooooool00_ooool2
o`00o`;ooooo00?o003oooooooooool04Oooool2o`0000gooooo0_l0000Vooooo`;o00003_ooool2
o`0000Gooooo0ol00009ooooo`;o00001Oooool2o`0000oooooo1?l00005ooooo`;o00000_ooool2
o`00013ooooo0ol00006ooooo`;o00006_ooool2o`000;gooooo0_l00?l6ooooo`03o`00oooooooo
oooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo0000ooooo`02
olg=c@03oiVIVOl0003ooooo00_ooooo00?o003oooooooooool01?ooool2o`00o`Cooooo00Co003o
ooooool00?oo003o4Oooool6o`0000_ooooo0_l0000Vooooo`;o00003_ooool4o`0000Cooooo0_l0
000:ooooo`03o`000?oooooooooo00Cooooo0_l0000?ooooo`;o00001oooool4o`0001;ooooo0_l0
0005ooooo`;o00006Oooool4o`000;cooooo00?o003oooooool00?l01_ooool00ol00?oooooooooo
o`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=
cLd00onIVIWo0000ooooo`3ooooooj?ooooo00Co003ooooooooooooo003o1_ooool00ol00?oooooo
ooooo`0:ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool0
0_o=cLd00onIVIWo0000ooooo`3ooooooj;ooooo00Go003oooooooooooooooooo`00o`06ooooo`03
o`00oooooooooooo00[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo
0000ooooo`02olg=c@03oiVIVOl0003ooooo0?ooooooXOooool6o`00o`;ooooo1Ol00?l<ooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`3ooooook[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo
0000ooooo`02olg=c@03oiVIVOl0003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`3ooooook[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo
0000ooooo`02olg=c@03oiVIVOl0003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000ooooo`3ooooook[ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00007ooooo00000ooooooo
0000ooooo`02olg=c@03oiVIVOl0003ooooo0?oooooo^_ooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o00000Oooool00003ooooool0003ooooo00;ocLg=00?oVIVIo`000?ooool0oooooonjooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l00001ooooo`0000?oooooo`000?ooool00_o=cLd00onIVIWo
0000o`00003oo`000;_o000000Coooooolg=cOo=cLgoVIVI0_l00001ooooo`0000?oooooo`000?oo
ool00_o=cLgooiVIVKooVIVI0_o=cLd00onIVIWo0000o`000001ooooo`0000?oooooo`000?ooool0
ooo=cLg3olg=c@03oiVIVOl0003o0000007ooooo00000ooooooo0000ooooo`3oolg=cL?ocLg=00?o
VIVIo`000?l000000Oooool00003ooooool0003ooooo0?oooooo`oooool00onIVIWo0000ooooo`01
ooooo`0000?oooooo`000?l00000ool00035o`0000;ooooo003ooooool[ooooo0000\
\>"], "ItemizedPicture",
  ImageSize->{457, 406},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}]
}, Closed]],

Cell[TextData[{
  "TIPS\n\[Bullet] For information about a function, type ",
  StyleBox["?", "MR"],
  ", the function name, and press ",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey]", "KeyboardChars"],
  ".\n\[Bullet] You can use palettes to enter mathematical notation. See ",
  ButtonBox["Using Palettes",
    ButtonData:>{"Using Palettes", None},
    ButtonStyle->"GettingStartedLink",
    ButtonNote->"page 10"],
  " for more information.\n\[Bullet] You can use Greek letters or other \
mathematical symbols as variables. See ",
  ButtonBox["Entering Mathematical Notation",
    ButtonData:>{"Entering Mathematical Notation", None},
    ButtonStyle->"GettingStartedLink",
    ButtonNote->"page 12"],
  " for more information.\n\[Bullet] To abort a calculation, press ",
  StyleBox["\[AltKey]\[LeftModified]", "KeyboardChars"],
  StyleBox[".", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  " on Windows, ",
  StyleBox["\[CloverLeaf]\[LeftModified]", "KeyboardChars"],
  StyleBox[".", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  " on Macintosh, or \[Mod1Key]\[LeftModified]",
  StyleBox[".", "MR"],
  "\[RightModified] on Unix. On Unix, to find out which keys represent Mod1 \
and Mod2, choose ",
  StyleBox["Help ", "SB"],
  "\[RightTriangle]",
  StyleBox[" Environment Information", "SB"],
  ". Typically the ",
  StyleBox["\[AltKey]", "KeyboardChars"],
  " key represents Mod1.\n\[Bullet] To complete a given command name, press \
",
  StyleBox["\[ControlKey]\[LeftModified]", "KeyboardChars"],
  StyleBox["K", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  " on Windows, ",
  StyleBox["\[CloverLeaf]\[LeftModified]", "KeyboardChars"],
  StyleBox["K", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  " on Macintosh, or ",
  StyleBox["\[ControlKey]\[LeftModified]", "KeyboardChars"],
  StyleBox["K", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  " on Unix.\n\[Bullet] To see a template, press ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
    "KeyboardChars"],
  StyleBox["K", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  " on Windows, ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CloverLeaf]\[LeftModified]", 
    "KeyboardChars"],
  StyleBox["K", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  " on Macintosh, or ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
    "KeyboardChars"],
  StyleBox["K", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  " on Unix."
}], "UserTips",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}],

Cell[TextData[{
  "For more information\n",
  "\[Bullet] ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ", Part 1: ",
  ButtonBox["A Practical Introduction to ",
    ButtonData:>{"1", None},
    Active->True,
    ButtonStyle->"MainBookLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"1", None},
    Active->True,
    ButtonStyle->"MainBookLink"],
    FontSlant->"Italic"],
  "."
}], "MoreInfo",
  CellTags->{"firstcalc", "i:11", "b:3.0", "gs:0.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using Online Help", "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Help Browser", "Getting help", "Help: on-line", 
    "Built-in functions: help with", "Mathematica functions: help with", 
    "Add-on packages: help with", "MathLink: help with", 
    "Documentation: on-line", "On-line documentation", 
    "Getting Started on line", "Mathematica Book: The: on-line", 
    "Browsing on-line help", "Keywords used in Help Browser", 
    "Searching help by keyword", "Go To: in Help Browser", 
    "Back: in Help Browser", "View previous topic in Help Browser", 
    "Printing help information", "Magnifying help information on screen", 
    "Why the Beep? menu item", "Print items in Help Browser", "browser", 
    "i:12", "gs:0.5"}],

Cell[TextData[{
  "Use the Help Browser to get immediate access to thousands of pages of \
documentation and examples, or go to ",
  ButtonBox["documents.wolfram.com",
    ButtonData:>{
      URL[ "http://documents.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Highlight",
  CellTags->{"browser", "i:13", "gs:0.5"}],

Cell[TextData[{
  "Use the text field to enter search terms. Click ",
  StyleBox["Go", "SR"],
  " to display the associated notebook."
}], "HelpLabels",
  CellTags->{"browser", "i:113", "gs:0.5"}],

Cell["The highlighted items in the columns track your search path.", \
"HelpLabels",
  CellTags->{"browser", "i:113", "gs:0.5"}],

Cell[TextData[{
  "The resulting help notebook is displayed below the columns. You can \
evaluate input, copy and paste from the Help Browser to another notebook, or \
print out information with the ",
  StyleBox["Print", "SR"],
  " menu command."
}], "HelpLabels",
  CellTags->{"browser", "i:113", "gs:0.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "ItemizedPicture",
        ImageSize->{54, 13},
        ImageMargins->{{0, 0}, {0, 0}},
        ImageRegion->{{0, 1}, {0, 1}}],
      ButtonFunction:>(FrontEndExecute[ {
          FrontEnd`SelectionMove[ 
            FrontEnd`SelectedNotebook[ ], All, ButtonCell], 
          FrontEndToken[ "OpenCloseGroup"]}]&),
      Active->True,
      ButtonFrame->"None"]], "OpenCloseItemizedPicture",
  CellTags->{"browser", "gs:0.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:Y0002QR000`400?l00000o`00003ooomVIWko
ofIVOZ_oIVIn00000omVIWkonocmoo_lo@3ooo_loOoonocmYooko?d1ofIVOP0000?oIVInoo_loOnX
ZK/0oonXZK_oojRY^jKoZ:Vk0Ooko?d1ofIVOP0000?oIVInoo_loOnXZK/0oomVIWkoofIVOZGoIVIn
0OnXZK/1oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWjHooooo`03onc]m?n;S9WoWIj[00coWIj[
00CoRX^Ion?VkOo^kNGo^KZnoonMWZ/WoifNZ`03okfm_oo^kNGoiNK^0:_oiNK^00?ok>gdoh^<VOnM
WZ/03?nMWZ/00on:RiWohnK]on3Oh`0@on3Oh`03ofIVO_nXZK_onocm007oIVIn00001OmVIWkonocm
ojRY^omVIWkoWIfQ09Koh=oS00?ooooooiBEX_oMg^403OoIf^@01?oMg^7oU9FRoiBEX_oJfmkoolO8
eROoalSF00?of]_Noj6R[_oknoh0Zooknoh00onDUJ;ogMkQomWJi00<omWJi003omgNhOnDUJ;oh=oS
00Goh=oS0_ooool2on3Oh`;ooooo0_oPgn<2ooooo`04on3OhomVIWkoZ:Vkoo_lo@7oIVIn00001OmV
IWkonocmojRY^omVIWkoWIfQ09Koh=oS00?ooooooiBEX_ooool03Oo;c=X01?ooooooU9FRoiBEX_oo
ooooolg>g2OocLkL00?ooooooiBEX_oknoh0Zooknoh00onDUJ;ooooool_<fP0<ol_<fP03oooooonD
UJ;oh=oS00Coh=oS00oo^;BSokReXOooooooh=oSokRdXonh]J7oooooon3Ohonh]:?o^;FQoooooooP
gn?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooU9FR
ooooo`0=ol_<fP04oooooonDUJ;oU9FRooooooooc<gK9oo<cM/00oooooooU9FRoo_koP2[oo_koP03
oiBEX_ooooooblcJ00coblcJ00?ooooooiBEX_oPgn<01?oPgn<01_nh]:?o^;BQon3OhooPgn?o^;BS
okRdX@;oh=oS00Oo^;BSokRdXOoPgn?oh=oSofIVO_nXZK_onocm007oIVIn00001OmVIWkonocmojRY
^omVIWkoWIfQ09Koh=oS00?ooooooiBEX_ooool01_o;c=X00olo?CgoblcJol_<fP04ol_<fP07oooo
oonDUJ;oU9FRooooooo>cmgoc/oLolk@g@0`olk?g1SocloM6?o?cm`Holk@gASoc/oM6?o>cm`Holk@
gC3oc/oL6?o?cmdHolo?g005olk@gOo>cmgoc/oMoooooonDUJ80[?ojn_d00onDUJ;ooooool_<fP04
ol_<fP03oclm?Oo;c=[oblcJ00GoblcJ00?ooooooiBEX_oPgn<04?oPgn<00omVIWkoZ:Vkoo_lo@01
ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00GoblcJ0olo?Cd5
ol_<fP04oooooonDUJ;oU9FRoooooa_oe=GP<?oDeN4HomGEhASoe=GQ5OoDeN001on>UJ;oe=GPohjE
X_oDeN3oSYFRomCEh?n>UJ80A?oDeN0`omCEhASoeMGQ0ooDeN400oooooooU9FRooWin`2[ooWin`03
oiBEX_ooooooblcJ00?oblcJ0olo?Cd6ol_<fP03oooooonDUJ;oh=oS00Woh=oS0_ooool2on3Oh`;o
oooo00Coh=oSofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00ooo
ooooU9FRooooo`04olc=f`?o?cdm1_o<cM/01?ooooooU9FRoiBEX_ooool2om_KiP03om_KiOoKg>Go
fmcU05kofmcU;?oKfnH02?ooooooSYFRoooooon>UJ;oooooohjEX_ooooooSYFR5?oKfnHHom_KiF3o
fmcU0_oKfnH00ooKg>GooooooiBEXP2/ooWin`03oiBEX_ooooooc<gK00Coc<gK0olo?Cd5olc=f`03
oooooonDUJ;oh=oS00Soh=oS00_o^;BSokReXOooooooh=oSokRdXonh]J7oooooon3OhomVIWkoZ:Vk
oo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00?odM;P
0olo?Cd7om7Bh004oooooonDUJ;oU9FRooooo`;ofm_V00?ofm_Uom_LiOoKg>D0G_oKg>D/om_KiP08
oooooon>UJ;oooooohjEX_ooooooSYFRoooooon>UJ8Dom_KiQSofm_UH?oKg>D2om_KiP03om_LiOoo
ooooU9FR0:con?Sk00?oU9FRoooooooAd^001OoAd^03oclm?@CodM;P00?ooooooiBEX_oPgn<02?oP
gn<01_nh]:?o^;BQon3OhooPgn?o^;BSokRdX@;oh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIV
O_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooU9FRooooo`02omWJi0?o?cdm2?oIf^@01ooooooo
U9FRoiBEX_oooooohn?Zon?RjooRh^X06?oShnXHon?RjQSoh^;Z6?oRhnX/on?SjP08oooooon>UJ;o
ooooohjEX_ooooooSYFRoooooon>UJ8Don?RjaSoh^;Z6?oShnXHon?RjQSoh^;Z6?oRhnX01OoShn[o
h^;[on;SjoooooooU9FR0:comoOi00?oU9FRoooooooIf^@01_oIf^@3oclm?@?ofM[T00?ooooooiBE
X_oPgn<04?oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3O
h`03oooooonDUJ;ooooo00?ohn?[0olo?Cd7on?Sj`07oooooonDUJ;oU9FRoooooooYjNkoj>W^onSX
k`0HonWYkQSojNS^<?oXjNhHonSYkaCojNW^00SoooooohjEX_ooooooSYFRoooooon>UJ;oooooohjE
XQCoj>W^6?oXj>lHonWYkQSojNS^<?oXjNh01OoXjNooj>S^onSXk_ooooooU9FR0:com?Gi00?oU9FR
oooooooShn/01OoShn/3oclm?@Cohn?[00?ooooooiBEX_oPgn<03OoPgn<2ooooo`04on3OhomVIWko
Z:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?ooooooiBEX_ooool01?o/
k?43oclm?@Kok>ca00OooooooiBEX_nDUJ;oooooonWYk_oXjNkoj>S_01SojNW^6?oYj>h`onSYkQSo
j>W_5?oYjNh02?ooooooSYFRoooooon>UJ;oooooohjEX_ooooooSYFR5?oXjNhHonSXkaSojNW^6?oY
j>h`onSYkP05onSYkooXj>koj>S^oooooonDUJ80[?ocloL00onDUJ;oooooonc/l@04onc/l@?o?cdm
1Oo/k?400oooooooU9FRon3Oh`0<on3Oh`07okRdXonh]J7oooooon3OhomVIWkoZ:Vkoo_lo@01ofIV
OP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00Gom?Cg0olo?Cd5ooCd
m`04oooooonDUJ;oU9FRooooohook>ca00Ooooooonc/lOooooook>caooooooo/k?7ooooo093ok>ca
00?ooooooiBEX_o`lOH0Zoo`lOH00onDUJ;oooooooCdm`03ooCdm`?o?cdm1_odm?L00oooooooU9FR
on3Oh`0<on3Oh`07okRdXonh]:7oh=oSon3OhomVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnX
ZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00Konocl00?o?cdmoo_lo?oko?`01?oko?`01?oo
ooooU9FRoiBEX_ooooooonc/lBOok>ca00?ooooooiBEX_o_l?D0Zoo_l?D00onDUJ;ooooooo_lo004
oo_lo003oclm?Ooko?conocl00Gonocl00?ooooooiBEX_oPgn<04?oPgn<00omVIWkoZ:Vkoo_lo@01
ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00kooooo0_nDUJ80
0ooooooomoOiooOgn@3oooOgnBGomoOi00?ooooooiBEX_o^ko@0Zoo^ko@00onDUJ;oooooooooo`0=
ooooo`03oiBEX_oPgn?oh=oS00ooh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:Vk
ofIVO_nMWJ40U_oPgn<00oooooooU9FRomKFf`0=ooooo`04omKFfonDUJ;oU9FRoo[jnooooooo9ooo
ool00oojn__oU9FRonc_m02[onc_m003oiBEX_oFe]_ooooo00cooooo00?oe]KKoiBEX_oPgn<04?oP
gn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`05oooooooF
fmWoSi2NokFe__nd];h01ond];d02?nc];go];BmokBd_Onc/kgoS8fLomKKfOoEe]Wo[Znioong]klW
okNg_`03ojFX]_o;c]Gok>kc0:_ok>kc00Coe]_Iohn@W_ne]Kko];Bn1ond];d01_nc];go];BmokBd
_Onc/kgoS8fLomKKfA7oh=oS00?oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOYOo
WIfQ00?oooooonk]iOo^kND03oo^kNGoon_[ib_ojn_W[?oUi^hAonk]iA7oh=oS00?oIVInojRY^ook
o?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`03onk]iOo/kOCoRhbI00co
WIj[00GoRX^Ion?VkOmVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooo
oi;ooooo00?ok^gUoiBEX_oMg^403?oIf^@01OoMg^7oU9FRofIVO_nXZK_onocm007oIVIn00001?mV
IWkonocmojRY^omVIWkoooooooooooooT_ooool00oo^kNGoU9FRooooo`0<ol_<fP05oooooonDUJ;o
IVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`03onk]iOnD
UJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooooooooooooi;ooooo00?ok^gUoiBEX_ooool03?o;c=X01OooooooU9FRofIVO_nXZK_onocm007o
IVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool00oo^kNGoU9FRooooo`05ol_<fP03
oclm?Oo;c=[oblcJ00CoblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooooooooi;ooooo00?ok^gUoiBEX_ooool01?o;c=X3oclm?@GoblcJ00GooooooiBE
X_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00?ok^gU
oiBEX_ooool00oo<cM/5oclm?@Coc<gK00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooooooooi;ooooo00?ok^gUoiBEX_ooool00_oAd^03oclm?@04om7Bh?lo
?Cgo?cdmoclm?@?odM;P00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_o
IVInoooooooooooooi;ooooo00Cok^gUoiBEX_oooooofM[T0olo?Cd3omWJi0?o?cdm0_oIf^@01Ooo
ooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWjOooooo`?o0000Koooool3
o`000:oooooo0_l0003;ooooo`03onk]iOnDUJ;ooooo00;ohn?[00?o?cdmon?SjooShn/00ooShn/0
2Olo?Cgohn?[on?SjooShn_ooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_o
IVInW_ooool01Ol0003ooooooooooooooooo000005Wooooo0ol0000Cooooo`03o`000?oooooooooo
07gooooo0ol0000`ooooo`03o`000?oooooooooo0<Sooooo00?ok^gUoiBEX_ooool03?o/k?401Ooo
ooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWjNooooo`05o`000?oooooo
ooooooooool00000G?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo07kooooo00?o
0000ooooooooool0;oooool00ol0003oooooooooo`38ooooo`03onk]iOnDUJ;ooooo00com?Cg00Go
oooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn9Oooool3o`0000Cooooo
1Ol00003ooooo`?o00001Oooool3o`0000?ooooo0ol00002ooooo`Co00001_ooool6o`000004oooo
ool0003o0000ooooo`;o00000_ooool3o`0000;ooooo1?l000000ooooooo0000o`000003o`000003
ooooool0003o000000;ooooo0ol00006ooooo`Co00000oooool3o`0000?ooooo0_l00003ooooo`;o
00000_ooool2o`000003ooooool0003o000000Co000000Coooooo`000?l0003ooooo0ol00004oooo
o`?o00000_ooool3o`0000;ooooo0ol00005ooooo`;o000000Goooooo`000?l0003o0000ooooo`02
o`000003ooooool0003o000000Gooooo0ol000001?oooooo0000o`000?l00002ooooo`Co00000_oo
ool4o`0000;ooooo0ol000000ooooooo0000o`000004o`0000?ooooo00?o0000ooooooooool02?l0
00001?oooooo0000o`000?l00002ooooo`Co00000oooool4o`0000Gooooo0ol00003ooooo`04o`00
0?oooooo0000o`0000?ooooo0_l000001Ooooooo0000o`000?l0003ooooo00?o00000_ooool3o`00
0003ooooool0003o000000?ooooo1_l000000ooooooo0000o`000004ooooo`;o000000Goooooo`00
0?l0003o0000ooooo`02o`000003ooooool0003o000000Kooooo00Co0000ooooool0003o00001?oo
ool2o`000004ooooool0003o0000ooooo`Go00000_ooool5o`0000?ooooo1Ol00002ooooo`?o0000
1?ooool4o`0000?ooooo0ol00003ooooo`Go00000oooool5o`000003ooooool0003o000000;o0000
0_ooool3o`000005ooooool0003o0000o`000?ooool01Ol00003ooooo`?o00000oooool4o`0000Ko
oooo0ol00003ooooo`?o00000oooool00ol0003oooooooooo`02o`0000?ooooo0_l00003ooooo`;o
00001?ooool3o`000003ooooool0003o000000Cooooo0ol00002ooooo`;o00000oooool2o`0000?o
oooo1ol000001Ooooooo0000o`000?l0003ooooo00Go00000oooool00ol0003oooooooooo`28oooo
o`03onk]iOnDUJ;ooooo00conocl00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn7?ooool5o`0000Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02
ooooo`05o`000?ooooooooooooooool000000oooool01ol0003ooooooooooooooooo0000ooooool0
00000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Cooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Ko
0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool0
00000_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Cooooo00Ko0000oooo
oooooooo0000ooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000oooooooooooo
ooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00002?ooool01?l0003oooooooooool0
0003ooooo`04o`000?ooooooooooo`0000Kooooo00Go0000ooooooooooooooooo`000002ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo0000
00;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000
ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooooooo
ooooool000000_ooool00ol0003oooooooooo`06ooooo`05o`000?ooooooooooooooool000000_oo
ool2o`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooo`000003ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002oooo
o`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool00oooool2o`0000;ooooo00Co0000oooooooooooo00000_oo
ool2o`0000?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`05o`000?oo
ooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000oooooooo
ool01?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool00oooool01Ol0
003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oo
ooooooooooooool000001?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool0
00000_ooool01Ol0003ooooooooooooooooo000000Cooooo00Oo0000ooooooooooooooooo`000?oo
oooo000000?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;o
oooo00Co0000oooooooooooo00001_ooool01?l0003oooooooooool00006ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00000oooool01?l0003oooooooooool00002ooooo`05
o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo
08_ooooo00?ok^gUoiBEX_ooool03Oooool01?nDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn7?ooool5o`0000Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02
ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`07ooooo`04o`000?oo
ooooooooo`0000?ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002ooooo`03
o`000?oooooo000000Gooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000003oooo
o`03o`000?oooooo000000Kooooo0_l00004ooooo`04o`000?ooooooooooo`0000Kooooo0_l00000
0ooooooo0000ooooo`04ooooo`05o`000?ooooooooooooooool000000oooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo00;o00001_ooool01?l0003oooooooooool00003ooooo`04
o`000?ooooooooooo`0000Kooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
000000Sooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Sooooo00Co
0000oooooooooooo00000oooool01?l0003oooooooooool00002ooooo`05o`000?oooooooooooooo
ool000000oooool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000?ooooo00Co
0000oooooooooooo00002?ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooo
ooooooooo`000002ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`04o`000?oo
ooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo0000
00cooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo000000Kooooo00?o
0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool000000oooool00ol0003o
ooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`07o`000?ooooooooooooooool0003o
ooooo`000003ooooo`06o`000?ooooooooooo`000?oooooo00001?ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00001_ooool01?l0003ooooooooo
ool00005ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00003oooo
o`04o`000?ooooooooooo`0000?ooooo0_l0002=ooooo`03onk]iOnDUJ;oe]KK00cooooo00Goe]KK
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool5o`0000Gooooo0ol0
0005ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`00
0?oooooooooo00Oooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`03ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooool000001Oooool01?l0003oooooooooool00002
ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000000ol000000ooooooo0000o`000007
ooooo`?o00001?ooool2o`0000?ooooo1?l00002ooooo`05o`000?ooooooooooooooool000000ooo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0
0oooool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000Kooooo00Go0000oooo
ooooooooooooo`000002ooooo`03o`000?oooooo000000?o00001Oooool01Ol0003oooooo`000?oo
oooo000000;ooooo1Ol00003ooooo`?o00000oooool01Ol0003ooooooooooooooooo000000;ooooo
1?l00004ooooo`Co00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooo
ooooooooo`000002ooooo`Go00001?ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000
ooooooooooooooooo`000002ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oo
oooo000000?o00002Oooool01?l0003oooooooooool00003ooooo`05o`000?ooooooooooooooool0
00001_ooool00ol0003oooooooooo`04ooooo`Co00000_ooool00ol0003oooooooooo`04ooooo`Go
00000_ooool00ol0003oooooooooo`03o`0000;ooooo00?o0000ooooooooool01?ooool4o`0000;o
oooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000001?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo0ol00005ooooo`07o`000?oooooo
ooooooooool0003oooooo`000003ooooo`05o`000?ooooooooooo`000?ooool01?l000000ooooooo
0000ooooo`04ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00001_ooool00ol0
003oooooooooo`04o`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0000?ooooo00Go0000oooooooooooo0000ooooo`02o`0008oooooo00Gok^gUomKKfOn?T9ko
]KFnokBd_P05okBd_@0:ok>d_Ond];go/kBmokBd_Onc/kgoS8fLomKKfOmVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWhLooooo`Go00001Oooool01?l0003oooooooooool00004ooooo`03
o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo
00Gooooo0_l00003ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`02
o`000004ooooool0003oooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01_l0003ooooo
ooooool0003oooooo`0000;ooooo0_l000001ooooooo0000oooooooooooo0000ooooool000000_oo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Cooooo00Ko0000oooooooooooo
0000ooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`00
0002ooooo`;o000000Coooooo`000?oooooo00000_ooool00ol0003oooooooooo`03ooooo`04o`00
0?ooooooooooo`0000?ooooo00?o0000ooooooooool00_l00005ooooo`04o`000?oooooooooooooo
o`;o000000Coooooo`000?oooooo00000_ooool00ol0003oooooooooo`03ooooo`05o`000?oooooo
0000ooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooooooo
ooooo`000002ooooo`;o00000_ooool01?l0003oooooooooool00003ooooo`04o`000?oooooooooo
o`0000?ooooo00?o0000ooooooooool00_l00002ooooo`04o`000?ooooooooooo`0000;ooooo0_l0
0002ooooo`05o`000?ooooooooooooooool000001?ooool01Ol0003ooooooooooooooooo000000;o
oooo0_l00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool000000oooool00ol0
003oooooooooo`02o`000003ooooool0003ooooo00Cooooo00?o0000ooooooooool00_l000000ooo
oooo0000ooooo`04ooooo`04o`000?ooooooooooooooo`;o000000Coooooo`000?oooooo00000_oo
ool00ol0003oooooooooo`04ooooo`?o00000oooool01Ol0003ooooooooooooooooo000000?ooooo
0_l00005ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`05
o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000
ooooooooool01Oooool2o`0000Cooooo00Go0000ooooooooooooooooo`000002ooooo`;o00000_oo
ool00ol0003oooooooooo`02o`0000;ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`02ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000Co
oooo00Ko0000ooooooooooooooooo`000?ooool2o`0000;ooooo00Ko0000oooooooooooo0000oooo
ool00002ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooooooo00001_ooool01?l0003o
ooooooooool00006ooooo`;o000000Goooooo`000?ooooooooooo`000002ooooo`05o`000?oooooo
ooooooooool000000_ooool00ol0003oooooooooo`02o`0000;ooooo0_l000001?oooooo0000oooo
ool00002ooooo`03o`000?oooooooooo08_ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVOQcooooo1Ol00005ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000
ooooooooool00oooool3o`0000?ooooo1Ol00006ooooo`04o`000?ooooooooooo`0000?ooooo00?o
0000ooooooooool00_ooool2o`000005ooooool0003o0000ooooool000000oooool3o`0000;ooooo
00Go0000ooooool0003o0000ooooo`02o`0000;ooooo0_l000001?oooooo0000ooooooooool2o`00
00?ooooo0ol00005ooooo`;o00001_ooool3o`0000;ooooo0_l00002ooooo`?o000000Goooooo`00
0?l0003o0000ooooo`02o`000005ooooool0003o0000ooooool000000oooool4o`0000?ooooo0ol0
0002ooooo`?o00000_ooool2o`000003ooooool0003ooooo00;ooooo0ol00002ooooo`03o`000?oo
oooo000000?ooooo0_l00006ooooo`;o000000?oooooo`000?l000000oooool3o`0000Cooooo1?l0
0002ooooo`04o`000?oooooo0000o`0000?ooooo00Go0000ooooooooooooooooo`000003ooooo`?o
00000_ooool2o`000003ooooool0003o000000Cooooo0_l000000ooooooo0000o`000002ooooo`?o
00001_ooool3o`0000;ooooo0_l000000ooooooo0000o`000002ooooo`?o000000?oooooo`000?l0
00000_ooool3o`0000;ooooo0_l000000ooooooo0000ooooo`04ooooo`;o000000Goooooo`000?l0
003oooooo`000005ooooo`?o00000_ooool00ol0003oooooo`000003ooooo`;o00001_ooool00ol0
003oooooooooo`03ooooo`;o00000_ooool2o`0000;ooooo0_l000000ooooooo0000o`000002oooo
o`Go00000oooool3o`0000Cooooo1?l00003ooooo`?o00000oooool00ol0003oooooooooo`04oooo
o`;o000000?oooooo`000?l000000oooool3o`0000;ooooo0_l000000ooooooo0000o`000003oooo
o`04o`000?oooooo0000o`0000?ooooo0ol00005ooooo`Co00000oooool4o`0000Gooooo0ol00002
ooooo`04o`000?oooooo0000o`0000;ooooo0_l00002ooooo`;o00000oooool3o`000004ooooool0
003o0000o`0000Cooooo0_l000001?oooooo0000o`000?l00004ooooo`;o000000?oooooo`000?oo
ool00_l00002ooooo`?o000000Coooooo`000?l0003ooooo0_l000001?oooooo0000o`000?ooool3
o`000003ooooool0003ooooo00;ooooo0ol0002=ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWhVooooo`04o`000?ooooooooooo`0000Cooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool01?l0
003oooooooooool0000Dooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool07oooool0
1Ol0003ooooooooooooooooo000001Cooooo00?o0000ooooooooool03_ooool01Ol0003ooooooooo
oooooooo000000gooooo0_l000000ooooooo0000o`00000@ooooo`03o`000?oooooooooo00Cooooo
00Go0000ooooooooooooooooo`00000^ooooo`03o`000?oooooooooo01oooooo00Go0000oooooooo
ooooooooo`00000=ooooo`03o`000?oooooooooo00;o00004Oooool00ol0003oooooooooo`0Hoooo
o`05o`000?ooooooooooooooool000005oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo0:7ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?oj
n_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORGooooo
1?l00004ooooo`;o00004oooool3o`0000;ooooo1?l0000Eooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool07oooool01Ol0003ooooooooooooooooo000001Cooooo00Co0000oooooooo
oooo00003Oooool01Ol0003ooooooooooooooooo000000cooooo0ol000001?oooooo0000o`000?l0
000>ooooo`;o00001Oooool5o`0002oooooo00?o0000ooooooooool07oooool01Ol0003ooooooooo
oooooooo000000kooooo0_l000000ooooooo0000ooooo`0Aooooo`?o00006?ooool4o`0001Kooooo
0_l00008ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0XOooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInD_ooool00ol0003oooooooooo`0:oooo
o`;o00002_ooool2o`0002Wooooo00?o0000ooooooooool03oooool3o`00013ooooo0_l0001Poooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool03?ooool2o`0007gooooo0_l00006oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool0]?ooool02_oUi^kok>kconc_m?o^koCo
ko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_
m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^
koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCo
k^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_
m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/
koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?o
k>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/
k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGV
k_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWiJooooo`?o0000D_ooool2o`000?oo
ooooH_ooool2o`0007cooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVOUWooooo00Go0000ooooooooooooooooo`00001Cooooo`03o`000?oooooooooo02cooooo1?l0
000Uooooo`03o`000?oooooooooo097ooooo00?o0000ooooooooool0M?ooool00ol0003ooooooooo
o`1iooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[m
oo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWiIooooo`05
o`000?ooooooooooooooool00000E?ooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo
02Gooooo00?o0000ooooooooool0TOooool00ol0003oooooooooo`1cooooo`03o`000?oooooooooo
07Wooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORKooooo0ol0
0003ooooo`?o000000Coooooo`000?l0003ooooo0_l00005ooooo`?o00000_ooool3o`000004oooo
ool0003o0000ooooo`Co000000?oooooo`000?l000002Ol000001?oooooo0000o`000?ooool3o`00
00Cooooo0ol00003ooooo`Oo000000Coooooo`000?l0003ooooo0_l00003ooooo`;o000000Gooooo
o`000?l0003o0000ooooo`03o`0000;ooooo0ol000000ooooooo0000o`000003ooooo`?o00001Ooo
ool3o`000004ooooool0003o0000ooooo`;o00000_ooool7o`0000?ooooo0_l00007ooooo`04o`00
0?ooooooooooooooo`?o000000?oooooo`000?l000000_ooool3o`000003ooooool0003o000000?o
00001Oooool3o`0000?ooooo1Ol00003ooooo`Go00000oooool00ol0003oooooooooo`02ooooo`Go
00000oooool4o`0000Cooooo00?o0000ooooooooool00oooool4o`0000;ooooo1Ol000000ooooooo
0000o`000004ooooo`?o000000Coooooo`000?l0003o00000_ooool2o`000003ooooool0003o0000
00;ooooo1?l00005ooooo`?o00000_ooool3o`0000Cooooo0ol00003ooooo`03o`000?oooooooooo
00?o00000_ooool5o`0000Cooooo0ol00004ooooo`?o00000oooool5o`0000?ooooo0ol00003oooo
o`Go00001Oooool;o`0000;ooooo0_l00003ooooo`;o00000oooool2o`000004ooooool0003o0000
o`0000;ooooo00?o0000ooooooooool00_ooool2o`0000;ooooo0ol00002ooooo`;o00001Oooool3
o`0000;ooooo0ol00005ooooo`04o`000?oooooo0000o`0000Cooooo0_l000001?oooooo0000o`00
0?ooool5o`0000;ooooo1Ol00003ooooo`Go00000_ooool3o`0000Cooooo1?l00003ooooo`?o0000
1?ooool3o`0000?ooooo1Ol00003ooooo`?o00000oooool5o`0000Gooooo0ol00003ooooo`?o0000
0oooool00ol0003oooooooooo`02o`0000?ooooo0_l00003ooooo`;o000000Coooooo`000?l0003o
00000oooool00ol0003oooooooooo`1Sooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmood
mOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWhLooooo`Go00001_ooool00ol0003oooooooooo`03ooooo`06o`000?oooooo
ooooo`000?oooooo00000_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;o
oooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000?ooooo00Co0000
oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000Sooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Gooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00Co0000
oooooooooooo00001oooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00Ko
0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooo
ooooooooo`000003ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000004
ooooo`;o00001?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooool000000oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Sooooo00Go
0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00;o00000_ooool00ol0003ooooo
ooooo`06ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`04ooooo`05
o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000
ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000Cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool01Oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000
oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Co0000oooooooo
oooo00000oooool01Ol0003ooooooooooooooooo000000?ooooo00Ko0000oooooooooooo0000oooo
ool00002ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`000002ooooo`03
o`000?oooooooooo00Cooooo0_l00002ooooo`04o`000?ooooooooooo`0000;ooooo0_l00003oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo
000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Cooooo00Go
0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003o
ooooooooo`02ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`05oooo
o`07o`000?ooooooooooooooool0003oooooo`000003ooooo`06o`000?ooooooooooo`000?oooooo
00000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo0000J?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
7?ooool5o`0000Kooooo00?o0000ooooooooool00oooool01_l0003oooooooooool0003oooooo`00
00Wooooo0_l00002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooo`00
0003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool2o`0000Ko
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000
ooooool000001Oooool01ol0003ooooooooooooooooo0000ooooool000000oooool01?l0003ooooo
ooooool00002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool01?l0003o
ooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooooooo0_l0
0002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooool000000oooool00ol0003oooooo`00
0005ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooo
oooooooo000000?ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000?o
oooo00?o0000ooooool000001?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooool000000oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
00Sooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`06ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003ooooo
ooooo`04ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000002oooo
o`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`04ooooo`05o`000?oooooo
ooooooooool000001?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool00000
0oooool00ol0003oooooooooo`05ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool01Ol0
003ooooooooooooooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`04
ooooo`;o00001oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool02?oo
ool01?l0003oooooooooool00003ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003o
ooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo
000000Cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o
0000ooooooooool01Oooool01ol0003ooooooooooooooooo0000ooooool000000oooool01_l0003o
ooooooooool0003oooooo`0000Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`;o0000J?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
7?ooool5o`0000Kooooo00?o0000ooooooooool00oooool01Ol0003oooooooooool0003ooooo00Co
00001?ooool2o`0000Cooooo00Co0000oooooooooooo00000_ooool3o`000003ooooool0003ooooo
00;ooooo00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo
00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooo`000005ooooo`07o`000?ooooooooooooooool0003oooooo`00
0003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`04ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0
003oooooo`000?l00004ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00000ooo
ool00ol0003oooooo`000003o`0000;ooooo00?o0000ooooool000000oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00?o00000_ooool00ol0003oooooooooo`04ooooo`Co00000ooo
ool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo1Ol00002ooooo`05o`00
0?ooooooooooooooool000000_ooool5o`0000Cooooo00?o0000ooooooooool02?ooool01Ol0003o
oooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`Go00001?ooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool01?ooool4o`0000?ooooo00?o
0000ooooooooool00ol000000ooooooo0000ooooo`02ooooo`04o`000?ooooooooooo`0000Kooooo
00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooo
ooooooooo`000003ooooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`000002
ooooo`04o`000?ooooooooooo`0000;ooooo1?l000000ooooooo0000ooooo`04ooooo`05o`000?oo
ooooooooooooool000000_ooool00ol0003oooooo`000002ooooo`Co000000?oooooo`000?l00000
2Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool02?ooool01?l0003o
ooooooooool00003ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`04
ooooo`Co00000_ooool00ol0003oooooooooo`04ooooo`Go00000_ooool00ol0003oooooooooo`04
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`02ooooo`05o`000?oo
ooooooooooooool000000oooool00ol0003oooooooooo`05ooooo`07o`000?ooooooooooooooool0
003oooooo`000003ooooo`05o`000?ooooooooooo`000?ooool01?l000000ooooooo0000ooooo`04
ooooo`03o`000?oooooooooo00;o0000J_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOo
m?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVIn7?ooool5o`0000Kooooo00?o0000ooooooooool00oooool2o`000004oooo
ool0003oooooo`0000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002oooo
o`;o000000Coooooo`000?oooooo00000_ooool00ol0003oooooo`000002ooooo`;o00000_ooool0
0ol0003oooooooooo`02o`000004ooooool0003oooooo`0000;ooooo00?o0000ooooooooool00ooo
ool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool00_l000001?oooooo0000
ooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool000000oooool00ol0
003oooooooooo`02o`000003ooooool0003ooooo00Cooooo00?o0000ooooooooool01Oooool2o`00
0005ooooool0003o0000ooooool000000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo
00Co0000oooooooooooo00001_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000oooo
ool000000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo0_l00005ooooo`03o`000?oo
oooooooo00Gooooo0_l00004ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000?ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo0000
00;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000001?oo
ool00ol0003oooooooooo`08ooooo`Go00000_ooool01Ol0003ooooooooooooooooo000000;ooooo
00Go0000ooooooooooooooooo`000004ooooo`05o`000?ooooooooooooooool000000_ooool2o`00
00Gooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Cooooo1?l00003
ooooo`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooooooo00;ooooo00Go0000ooooooooooooooooo`000003ooooo`;o00001_ooool00ol0003ooooo
ooooo`02o`0000;ooooo00?o0000ooooooooool00_l000001ooooooo0000oooooooooooo0000oooo
ool000000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooo000000?ooooo00?o0000
ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Gooooo00Go0000
ooooooooooooooooo`000002ooooo`;o00001_ooool3o`0000?ooooo00Go0000oooooooooooooooo
o`000003ooooo`;o00001Oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool0
00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002
ooooo`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooooooo00;ooooo00Go0000ooooooooooooooooo`000003ooooo`;o00001_ooool01_l0003ooooo
oooooooooooo0000ooooo`;o00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o
0000ooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0006So
oooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_n
oo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00006
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000oooool2o`0000Kooooo0ol00002
ooooo`03o`000?oooooo000000?ooooo0_l00003ooooo`;o000000?oooooo`000?ooool00_l00000
1Ooooooo0000o`000?oooooo000000?ooooo1?l00003ooooo`?o000000Coooooo`000?l0003ooooo
0_l000001Ooooooo0000o`000?oooooo000000?ooooo0ol000001Ooooooo0000o`000?l0003ooooo
00;o00000_ooool3o`0000;ooooo0_l000000ooooooo0000ooooo`06ooooo`;o00001?ooool2o`00
0005ooooool0003oooooooooool000000_ooool2o`000003ooooool0003o000000;ooooo0ol00000
1?oooooo0000o`000?l00004ooooo`?o000000?oooooo`000?l000000ol00002ooooo`;o00000ooo
ool00ol0003oooooooooo`02o`000003ooooool0003ooooo00Cooooo00?o0000ooooooooool01?oo
ool2o`000003ooooool0003o000000?ooooo0ol00002ooooo`?o000000Coooooo`000?l0003o0000
0_ooool00ol0003oooooooooo`04ooooo`?o00000_ooool3o`000004ooooool0003o0000o`0000;o
oooo0ol00005ooooo`03o`000?oooooooooo00Sooooo00Ko0000ooooooooooooooooo`000?ooool2
o`0000;ooooo0_l00003ooooo`?o00001_ooool3o`0000;ooooo0_l000000ooooooo0000ooooo`03
ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`04ooooo`05o`000?oo
ooooooooooooool000000_ooool00ol0003oooooooooo`05ooooo`?o00001Oooool00ol0003ooooo
ooooo`03ooooo`?o00000oooool2o`000003ooooool0003o000000Gooooo0_l000000ooooooo0000
ooooo`02o`000006ooooool0003o0000ooooool0003ooooo0_l00003ooooo`?o000000Goooooo`00
0?l0003o0000ooooo`05o`0000;ooooo0_l000000ooooooo0000o`000003ooooo`?o00002?ooool3
o`0000;ooooo0_l000000ooooooo0000ooooo`03ooooo`03o`000?oooooooooo00?ooooo0_l00002
ooooo`;o00000_ooool2o`000003ooooool0003o000000;ooooo1Ol00003ooooo`?o00001?ooool4
o`0000?ooooo0ol00003ooooo`03o`000?oooooooooo00Gooooo0ol00005ooooo`03o`000?oooooo
oooo00?ooooo0ol00003ooooo`;o000000?oooooo`000?l000001Oooool3o`0000;ooooo00Co0000
ooooool0003o00000_ooool2o`0000;ooooo0_l00003ooooo`?o000000Coooooo`000?l0003o0000
0_ooool3o`0006Sooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oi
nO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
OROooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
02oooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00?ooooo00Go0000ooooooooooooooooo`00000Hooooo`03o`000?oooooooooo01[ooooo00?o0000
ooooooooool02?ooool01Ol0003ooooooooooooooooo0000023ooooo00Go0000oooooooooooooooo
o`000002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo0000
00;ooooo00Go0000ooooooooooooooooo`00000;ooooo`03o`000?oooooooooo01Kooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00;o00004Oooool0
0ol0003oooooooooo`0Hooooo`05o`000?ooooooooooooooool000002oooool00ol0003ooooooooo
o`0Hooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0K?ooool02_oUi^kok>kconc_
m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9?ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0001;ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0A
ooooo`04o`000?ooooooooooo`00017ooooo00?o0000ooooooooool0;oooool00ol0003ooooooooo
o`0Cooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool4o`0001Oooooo0ol0
000Jooooo`;o00002Oooool3o`000004ooooool0003o0000o`0001kooooo1Ol00004ooooo`Co0000
00?oooooo`000?l000000ol00004ooooo`Co00002_ooool2o`0001Sooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Xooooo`;o000000?oooooo`000?ooool04Oooool3o`0001Sooooo
1?l0000:ooooo`;o00006_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo06cooooo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_k
o_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORCooooo1ol000000ooo
oooo0000o`00000Aooooo`;o00003?ooool2o`0000;ooooo00?o0000ooooooooool03oooool3o`00
01Gooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`04ooooo`;o00001?ooool2o`00
0:cooooo0_l00002ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0O_ooool2o`00
00Kooooo00?o0000ooooooooool0NOooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCe
nOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmood
mOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOo
m?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?c
moodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_oc
loOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKo
lo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3a
m_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Go
l?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWiSooooo`;o00008?ooool3o`000;gooooo0ol0000:ooooo`;o
0000oooooolmooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk
00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWiU
ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool0MOooool00ol0003oooooooooo`13
ooooo`05o`000?ooooooooooooooool000002oooool00ol0003oooooooooo`3ooooooc[ooooo00[o
iNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_ok
nokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOVKooooo00?o0000oooooooo
ool07Oooool00ol0003oooooooooo`1fooooo`03o`000?oooooooooo04;ooooo00Go0000oooooooo
ooooooooo`00000<ooooo`03o`000?oooooooooo0?oooooo>Oooool02_oUi^kok>kconc_m?o^koCo
ko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9_ooool5o`000003ooooool0003o000000?ooooo0_l0
0002ooooo`;o00000_ooool3o`000005ooooool0003o0000o`000?ooool00_l000000ooooooo0000
o`000006o`000004ooooool0003o0000ooooo`;o00000oooool5o`0000Cooooo0ol00005ooooo`03
o`000?oooooooooo00Gooooo0_l000001Ooooooo0000o`000?l0003ooooo00;o000000?oooooo`00
0?l000001_ooool3o`0000?ooooo00Co0000ooooool0003o00000oooool2o`000005ooooool0003o
0000o`000?ooool00ol00002ooooo`?o000000?oooooo`000?l000001Oooool3o`0000Cooooo0ol0
0003ooooo`Go00000oooool3o`0000?ooooo1Ol00002ooooo`?o00001Oooool2o`000003ooooool0
003o000000?o000000Coooooo`000?l0003o00000_ooool3o`0000Gooooo0ol00002ooooo`Go0000
0oooool3o`0000;ooooo0ol000001Ooooooo0000o`000?l0003ooooo00;o00001?ooool2o`000005
ooooool0003o0000o`000?ooool00_l000000ooooooo0000o`000006ooooo`Go000000?oooooo`00
0?l000000_ooool3o`0000;ooooo1?l00002ooooo`Oo000000?oooooo`000?l000001?ooool6o`00
00Kooooo0ol000001?oooooo0000o`000?l00002ooooo`Co00000oooool00ol0003oooooooooo`04
ooooo`?o000000?oooooo`000?l000001?ooool00ol0003oooooooooo`02ooooo`;o00000_ooool6
o`0000?ooooo00?o0000ooooooooool0oooooolFooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWhUooooo`07o`000?ooooooooooooooool0003oooooo`000002oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002oooo
o`03o`000?oooooo000000;ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`02oooo
o`05o`000?ooooooooooooooool000000oooool00ol0003oooooo`000006ooooo`05o`000?oooooo
ooooooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Go
0000ooooooooooooooooo`000002ooooo`;o00000_ooool01?l0003oooooooooool00003ooooo`03
o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03oooo
o`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;o00000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000003ooooo`05o`000?oooooooooo
ooooool000000oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000000_oo
ool01Ol0003ooooooooooooooooo000000Sooooo00Go0000ooooooooooooooooo`000002ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooooooool00_ooool01ol0003ooooooooooooooooo0000
ooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00006ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`04o`000?oooooooooo
o`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000Kooooo00?o0000ooooool00000
0_ooool01Ol0003ooooooooooooooooo000000?ooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooo`000002ooooo`03o`000?oooooooooo0?oooooo6Oooool02_oUi^kok>kconc_m?o^koCo
ko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9Oooool01ol0003ooooooooooooooooo0000ooooool0
00001Oooool01?l0003oooooooooool00005ooooo`05o`000?ooooooooooooooool000000_ooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool00000
1?ooool01Ol0003ooooooooooooooooo000000Cooooo00Go0000ooooooooooooooooo`000003oooo
o`03o`000?oooooo000000Kooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
000000Oooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool00000
0_ooool01ol0003ooooooooooooooooo0000ooooool000000oooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool0
00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002
ooooo`05o`000?ooooooooooooooool000002?ooool01Ol0003ooooooooooooooooo000000;ooooo
00?o0000ooooool000001oooool01ol0003ooooooooooooooooo0000ooooool000001Oooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooooooo`;o00001Oooool2o`0000?o
oooo00Co0000oooooooooooo00000_ooool01ol0003ooooooooooooooooo0000ooooool000001_oo
ool00ol0003oooooo`000005ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool00ooo
ool01?l0003oooooooooooooool2o`000?oooooo6oooool02_oUi^kok>kconc_m?o^koCoko3eoo3a
m_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVIn9Oooool01_l0003ooooooooooooooooo0000ooooo`Co00000_oo
ool00ol0003oooooooooo`04o`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000003o`00
0003ooooool0003ooooo00;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo
000000;ooooo00Co0000oooooooooooo00001_ooool01Ol0003ooooooooooooooooo000000;ooooo
00?o0000ooooool000000ol00004ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003o
oooooooooooooooo000000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Cooooo
00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooo
ooooooooo`000003ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool000000oooool01Ol0
003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`05o`000?oo
ooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000Sooooo00Go0000oooooooo
ooooooooo`000002ooooo`03o`000?oooooo000000?o00001?ooool01_l0003ooooooooooooooooo
0000ooooo`Co00000_ooool01?l0003oooooooooooooool3o`0000;ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00006ooooo`04o`000?oooooo0000o`0000Kooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooooooool3o`0000;ooooo00Co0000oooooooooooo
00001_ooool00ol0003oooooo`000003o`0000;ooooo00?o0000ooooool000000_ooool4o`0000;o
oooo00Co0000ooooool0003o0000oooooolMooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?c
moodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWhUooooo`03o`000?oooooooooo00;o000000Goooooo`000?oooooooooo
o`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_l00002ooooo`;o
000000Goooooo`000?l0003oooooo`000002ooooo`03o`000?oooooooooo00;o000000Coooooo`00
0?oooooo00000_ooool00ol0003oooooo`000002ooooo`;o00001?ooool2o`0000;ooooo00Co0000
oooooooooooo00000oooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooooooo`;o0000
00Coooooo`000?oooooo00000_ooool00ol0003oooooooooo`02ooooo`05o`000?oooooooooooooo
ool000000_ooool2o`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooo`000003
ooooo`03o`000?oooooooooo00;o000000?oooooo`000?ooool01?ooool00ol0003oooooooooo`04
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`02ooooo`05o`000?oo
ooooooooooooool000000oooool2o`0000Gooooo0ol00003ooooo`05o`000?ooooooooooooooool0
00000_ooool2o`0000;ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo
000000Oooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo0_l0
0002ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooooooo0_l000001?oooooo0000
ooooool00002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_l000001Ooooooo
0000oooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
o`000002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool2o`000005
ooooool0003oooooooooool000000_ooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000
ooooool000000_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00Ko0000
oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo0?oooooo6Oooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9_ooool2o`000004ooooool0003ooooo
ooooo`;o00000_ooool3o`0000;ooooo0_l00002ooooo`;o000000Koooooo`000?l0003o0000oooo
ool00002ooooo`03o`000?oooooooooo00;o000000Goooooo`000?l0003oooooo`000003ooooo`;o
00000oooool2o`000003ooooool0003ooooo00?ooooo00Co0000ooooool0003o00000_ooool3o`00
0004ooooool0003o0000o`0000?ooooo0ol00002ooooo`03o`000?oooooo000000?ooooo0_l00006
ooooo`?o00000_ooool2o`000003ooooool0003o000000;ooooo0ol000000ooooooo0000o`000002
ooooo`?o00000_ooool2o`000003ooooool0003ooooo00Gooooo00?o0000ooooooooool01Oooool3
o`0000Gooooo00?o0000ooooooooool00oooool3o`0000?ooooo0_l000000ooooooo0000o`000003
ooooo`03o`000?oooooo000000;ooooo0_l00002ooooo`;o000000Coooooo`000?l0003ooooo0_l0
0004ooooo`Co00000_ooool5o`0000;ooooo0ol00005ooooo`?o00000_ooool2o`000003ooooool0
003o000000?ooooo00?o0000ooooooooool00_ooool3o`0000;ooooo00?o0000ooooool000000ooo
ool2o`0000Kooooo0_l000001?oooooo0000ooooooooool2o`0000;ooooo0ol00002ooooo`;o0000
0_ooool2o`000003ooooool0003o000000;ooooo00?o0000ooooool000000_l00004ooooo`;o0000
0_ooool3o`0000Gooooo1_l000000ooooooo0000ooooo`02o`0000;ooooo0ol000001?oooooo0000
o`000?l00004ooooo`03o`000?oooooooooo00;o000000Coooooo`000?l0003o00000_ooool2o`00
0003ooooool0003o000000?ooooo00?o0000ooooooooool00ol0003ooooooa_ooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORWooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03_oo
ool01Ol0003ooooooooooooooooo000001[ooooo00?o0000ooooooooool04oooool01Ol0003ooooo
oooooooooooo000000_ooooo00?o0000ooooooooool04Oooool01Ol0003ooooooooooooooooo0000
01Oooooo00?o0000ooooooooool07_ooool01Ol0003ooooooooooooooooo0000013ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0<ooooo`04o`000?ooooooooooo`0002Wooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`3ooooooakooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORWooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0Tooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03_ooool01Ol0003o
oooooooooooooooo000001[ooooo00?o0000ooooooooool05?ooool4o`0000[ooooo0_l0000Boooo
o`Ko00007oooool00ol0003oooooooooo`0Fooooo`05o`000?ooooooooooooooool000004?ooool0
0ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000_ooooo00Co0000oooooooooooo0000
:Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo0?oooooo7_ooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn:?ooool2o`0001gooooo00?o0000oooo
ooooool03Oooool2o`0000?ooooo0_l0000Cooooo`;o00007_ooool00ol0003oooooooooo`1coooo
o`;o00003oooool2o`0000Sooooo0ol0000:ooooo`;o00002Oooool00ol0003oooooooooo`0Ooooo
o`;o00004Oooool2o`000?oooooo8?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCe
nOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmood
mOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOo
m?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?g
ooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?c
moodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkNooooo`?o0000Aoooool3o`000;Sooooo0ol0000Pooooo`?o0000Aooo
ool3o`0003gooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/0
2?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOSoo
oooo0ol0000Pooooo`?o0000N?ooool01Ol0003ooooooooooooooooo000004Oooooo00?o0000oooo
ooooool08_ooool00ol0003oooooooooo`2Aooooo`05o`000?ooooooooooooooool000007_ooool0
1Ol0003ooooooooooooooooo000004Gooooo00Go0000ooooooooooooooooo`00000looooo`0:onGV
k_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_n
onGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWi2ooooo`03o`000?oooooooooo
023ooooo00?o0000ooooooooool0MOooool01Ol0003ooooooooooooooooo000004Oooooo00?o0000
ooooooooool08oooool00ol0003oooooooooo`2@ooooo`05o`000?ooooooooooooooool000007_oo
ool01Ol0003ooooooooooooooooo000004Gooooo00Go0000ooooooooooooooooo`00000looooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhTooooo`?o000000Cooooo
o`000?l0003o00001Oooool5o`0000;ooooo1Ol00003ooooo`Co000000Goooooo`000?l0003o0000
ooooo`03o`0000?ooooo0ol00002ooooo`Go000000Goooooo`000?l0003o0000ooooo`03o`0000;o
oooo1?l00008ooooo`;o00001_ooool3o`0000Gooooo1Ol000000ooooooo0000o`000003o`0000;o
oooo1?l00004ooooo`Co00001Oooool7o`000004ooooool0003o0000ooooo`Go00000oooool3o`00
0004ooooool0003o0000ooooo`?o00001Oooool3o`0000;ooooo0ol000001?oooooo0000o`000?oo
ool4o`000003ooooool0003o000000Wo000000Coooooo`000?l0003ooooo0ol00004ooooo`?o0000
0oooool7o`000004ooooool0003o0000ooooo`;o00000oooool2o`000005ooooool0003o0000o`00
0?ooool00ol00002ooooo`?o000000?oooooo`000?l000000oooool3o`0000Gooooo1_l00005oooo
o`?o00000oooool01?l0003oooooo`000?l00003ooooo`;o00000oooool2o`0000;ooooo1_l00000
1Ooooooo0000o`000?l0003ooooo00;o00000oooool7o`0000Gooooo0_l000001Ooooooo0000o`00
0?l0003ooooo00;o000000?oooooo`000?l000001Oooool3o`0000Cooooo1ol000001?oooooo0000
o`000?l00002ooooo`Co000000?oooooo`000?l000000oooool2o`0000Gooooo1_l00005ooooo`?o
00000_ooool3o`000004ooooool0003o0000ooooo`Co000000?oooooo`000?l000000ol000000ooo
oooo0000o`000003ooooo`Go00001?ooool4o`000003ooooool0003o000000?ooooo0_l00003oooo
o`?o00000_ooool3o`0000;ooooo2ol000001?oooooo0000o`000?ooool3o`0000Gooooo0_l00002
ooooo`?o00001Oooool3o`000004ooooool0003o0000ooooo`;o00000_ooool3o`000005ooooool0
003o0000o`000?ooool00ol000001?oooooo0000o`000?ooool2o`0000;ooooo00?o0000oooooooo
ool01?ooool3o`0000?ooooo0ol000001?oooooo0000o`000?ooool2o`0000Gooooo0ol00002oooo
o`?o000000Coooooo`000?l0003ooooo1?l000000ooooooo0000o`000009o`000004ooooool0003o
0000ooooo`?o00001?ooool6o`0003?ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCe
nOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVOQcooooo1Ol00004ooooo`05o`000?ooooooooooooooool000001oooool01?l0
003oooooooooool00004ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`05o`000?ooooooooooooooool000000oooool01Ol0003ooooooooooooooooo000000?o
oooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooo
ooooooooooooo`00000:ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool0
1Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`06
o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooooooo`03ooooo`06o`000?oooooo
ooooo`000?oooooo00000oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;o
oooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000?ooooo00Co0000
oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000Sooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooool0
00000_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo0_l00002oooo
o`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool01?l0003oooooooooool00002
ooooo`07o`000?ooooooooooooooool0003oooooo`000002ooooo`03o`000?oooooo000000?ooooo
00?o0000ooooooooool01_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool0
00000_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Ko0000oooooooooooo0000
ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool00oooool00ol0003o
ooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01_l0
003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool000000oooool00ol0003oooooo`00
0002ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool00_ooool01_l0003ooooooooo
ool0003oooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000003ooooo`04
o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooool000002?ooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`06o`000?oooooooooo
o`000?oooooo00001Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool00oooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000oooo
ooooool00_ooool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oooooo0000
0_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooo
oooo0000ooooool00008ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0<?ooool0
2_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_n
oo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool5o`0000Cooooo
00Go0000ooooooooooooooooo`000007ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000oooo
ooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`00
0003ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Go0000ooooooooooooooooo`00000;ooooo`;o00001?ooool00ol0003o
ooooooooo`03ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`06oooo
o`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00000_ooool01_l0003ooooooooo
ool0003oooooo`0000?ooooo00?o0000ooooooooool00oooool01_l0003oooooooooool0003ooooo
o`0000?ooooo00?o0000ooooooooool01?ooool2o`0000;ooooo00Ko0000oooooooooooo0000oooo
ool00002ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00002ooooo`;o00001_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooo`000005ooooo`07o`000?ooooooooooooooool0003o
ooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`03ooooo`04o`000?ooooooooooooooo`;o00001_ooool2o`0000;ooooo00Oo0000
ooooooooooooooooo`000?oooooo000000Cooooo00?o0000ooooooooool00oooool01?l0003ooooo
ooooool00003ooooo`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`000008oooo
o`05o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000009ooooo`;o00000_ooool0
1?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool000000_ooool01_l0003ooooo
ooooool0003oooooo`0000Cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool2
o`0000Kooooo0_l00002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003ooooo
o`000003ooooo`03o`000?oooooo000000Cooooo00Go0000ooooooooooooooooo`000004ooooo`06
o`000?ooooooooooo`000?oooooo00001?ooool00ol0003oooooooooo`02ooooo`05o`000?oooooo
ooooooooool000000_ooool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00000_ooool2o`0000Kooooo00Co0000oooooooooooo00000oooool0
0ol0003oooooooooo`03ooooo`06o`000?ooooooooooo`000?oooooo00001Oooool00ol0003ooooo
ooooo`02o`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo00?ooooo00Ko0000oooooooooooo0000ooooool00009ooooo`;o00000_ooool0
1_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool000000oooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo0_l00006ooooo`04o`000?oooooooooo
ooooo`;o0000<_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
7?ooool5o`0000Cooooo00Go0000ooooooooooooooooo`000007ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooo
ooooooooooooo`000003ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`Go0000
1_ooool01ol0003ooooooooooooooooo0000ooooool000001?ooool4o`0000Cooooo00?o0000oooo
ooooool00oooool3o`0000?ooooo1Ol00005ooooo`?o00000_ooool01_l0003oooooooooool0003o
ooooo`0000?ooooo00?o0000ooooooooool00oooool01_l0003oooooooooool0003oooooo`0000?o
oooo00?o0000ooooooooool00_ooool2o`0000Cooooo00Co0000oooooooooooo00000_ooool3o`00
0003ooooool0003ooooo00;ooooo00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0
003oooooo`0000;ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;o
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000005ooooo`07o`000?oooooooooo
ooooool0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`04ooooo`04o`000?oooooo0000o`0000Kooooo0_l00004ooooo`06
o`000?ooooooooooooooool0003ooooo1?l000000ooooooo0000ooooo`04ooooo`04o`000?oooooo
ooooo`0000?ooooo00?o0000ooooool000000ol000000ooooooo0000ooooo`02ooooo`03o`000?oo
oooooooo00Kooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000?o0000
1?ooool2o`0000Cooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo0000
00?ooooo0ol000000ooooooo0000ooooo`03ooooo`Co00001Oooool01?l0003oooooo`000?l00006
ooooo`;o00001?ooool01?l0003oooooooooool00002ooooo`?o000000?oooooo`000?ooool00_oo
ool00ol0003oooooo`000003o`000003ooooool0003ooooo00;ooooo00?o0000ooooooooool00ooo
ool3o`000003ooooool0003ooooo00?ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo00000oooool01?l0003oooooooooool00002oooo
o`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`03ooooo`04o`000?oo
ooooooooo`0000?ooooo00?o0000ooooooooool00oooool01Ol0003oooooooooool0003ooooo00Co
00000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00002oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooo`000?ooool01?l0
0004ooooo`;o00001?ooool01?l0003oooooooooool00002ooooo`?o000000?oooooo`000?ooool0
0_ooool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool0
0ol0003oooooooooo`03ooooo`04o`000?oooooo0000o`0003Cooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00004ooooo`05o`000?oooooooooooooo
ool000001oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool00_l00002ooooo`;o00000_ooool01Ol0003ooooooooooooooooo000000Oooooo00?o0000
ooooooooool00_ooool2o`0000;ooooo00Co0000oooooooooooo00000_ooool2o`0000_ooooo0_l0
0004ooooo`?o00000oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0
0_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000004oooo
o`04o`000?ooooooooooo`0000;ooooo0_l000001?oooooo0000ooooool00002ooooo`;o00001Ooo
ool2o`000004ooooool0003oooooo`0000?ooooo00?o0000ooooooooool00_ooool01?l0003ooooo
ooooool00002ooooo`;o000000Coooooo`000?oooooo00000_ooool00ol0003oooooo`000002oooo
o`;o00000_ooool00ol0003oooooooooo`02o`000004ooooool0003oooooo`0000;ooooo00?o0000
ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool00_l0
00001?oooooo0000ooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool0
00000oooool00ol0003oooooooooo`02o`000003ooooool0003ooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooo
oooo00000_ooool2o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002oooo
o`04o`000?ooooooooooo`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo
00?o0000ooooool000000_ooool2o`0000Sooooo00Co0000oooooooooooooooo0_l000001?oooooo
0000ooooool00002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooool00002ooooo`;o00000_ooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`;o
000000Coooooo`000?oooooo00000_ooool00ol0003oooooo`000002ooooo`;o000000Ooooooo`00
0?ooooooooooo`000?oooooo000000;ooooo0_l00004ooooo`06o`000?ooooooooooo`000?oooooo
00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000?ooooo00?o0000oooooooo
ool00_l000001?oooooo0000ooooooooool2o`0000;ooooo00?o0000ooooooooool00_l000001?oo
oooo0000ooooool00002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000ooo
ool00ol0003oooooooooo`03ooooo`;o000000Coooooo`000?oooooo00000_ooool01_l0003ooooo
ooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_l000001Ooooooo0000oooooooooooo
000000_ooooo00?o0000ooooooooool00oooool2o`000004ooooool0003oooooo`0000;ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`;o000000Coooooo`000?oooooo
00000_ooool00ol0003oooooo`000002ooooo`;o00000_ooool00ol0003oooooooooo`02o`000004
ooooool0003oooooo`0000;ooooo00?o0000ooooooooool00oooool00ol0003oooooo`000002oooo
o`03o`000?oooooooooo033ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVOQcooooo1Ol00004ooooo`03o`000?oooooooooo00?o00001_ooool00ol0003ooooooooo
o`03ooooo`?o00001Oooool2o`000006ooooool0003o0000ooooool0003ooooo0_l00003ooooo`Go
00000_ooool3o`0000?ooooo0_l000000ooooooo0000o`000004ooooo`;o000000?oooooo`000?l0
00002Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo000000Cooooo0ol00005ooooo`03
o`000?oooooooooo00?ooooo1?l00003ooooo`?o00001_ooool2o`0000;ooooo0_l000000ooooooo
0000ooooo`02ooooo`;o000000?oooooo`000?ooool00oooool2o`000003ooooool0003ooooo00;o
oooo0ol00006ooooo`?o00000_ooool00ol0003oooooo`000003ooooo`;o00000oooool2o`000003
ooooool0003ooooo00;o000000Goooooo`000?l0003oooooo`000003ooooo`Co00000oooool3o`00
0004ooooool0003o0000ooooo`;o000000Goooooo`000?l0003oooooo`000003ooooo`?o000000Go
ooooo`000?l0003o0000ooooo`02o`0000;ooooo0ol00002ooooo`;o000000?oooooo`000?ooool0
1_ooool2o`0000Cooooo0_l00002ooooo`?o00001Oooool3o`000004ooooool0003o0000ooooo`;o
00000oooool2o`0000?ooooo0ol000001?oooooo0000o`000?ooool3o`000003ooooool0003o0000
00;ooooo0_l00003ooooo`;o000000?oooooo`000?ooool01_ooool3o`0000;ooooo00?o0000oooo
ool000000oooool2o`0000Kooooo0ol000001?oooooo0000o`000?ooool2o`000004ooooool0003o
0000ooooo`Co00000_ooool2o`0000?ooooo0ol00002ooooo`;o00001Oooool2o`0000;ooooo0ol0
0005ooooo`?o00000_ooool00ol0003oooooo`000003ooooo`;o00000oooool2o`000004ooooool0
003oooooooooo`;o00000oooool2o`000003ooooool0003ooooo00Cooooo0_l00003ooooo`?o0000
0_ooool3o`0000;ooooo0ol00002ooooo`;o000000?oooooo`000?ooool00_l000000ooooooo0000
ooooo`02o`000005ooooool0003o0000ooooool000000oooool4o`0000?ooooo0ol00002ooooo`?o
00001_ooool00ol0003oooooo`000003ooooo`;o00000_ooool2o`0000;ooooo1?l000001?oooooo
0000ooooool00002ooooo`?o00002_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo0000
00?ooooo0_l00006ooooo`?o00000_ooool00ol0003oooooo`000003ooooo`;o00000oooool2o`00
0003ooooool0003ooooo00;o000000Goooooo`000?l0003oooooo`000003ooooo`Co00000oooool2
o`0000;ooooo0ol0000booooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooSh
n`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWhUooooo`05o`000?ooooooooooooooool000001oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool07_ooool2o`0000Oooooo00Go0000oooooooo
ooooooooo`00000:ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool05oooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0oooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool01_ooool01Ol0
003ooooooooooooooooo000001cooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0BOooool02_oUi^kok>kconc_m?o^
koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9Oooool01Ol0003ooooooooooooooooo000000;o
oooo00Co0000oooooooooooooooo0ol00006ooooo`03o`000?oooooooooo00Sooooo0_l0000?oooo
o`03o`000?oooooooooo01kooooo1_l00009ooooo`;o00008oooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04Oooool01?l0003oooooooooool0000A
ooooo`03o`000?oooooooooo03oooooo00Co0000oooooooooooo00002oooool00ol0003ooooooooo
o`06ooooo`05o`000?ooooooooooooooool000007?ooool01?l0003oooooooooool0000Rooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Oooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0@ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0001;ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`19
ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_k
o_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhTooooo`?o0000
0oooool3o`0007cooooo0_l0000Hooooo`;o00003?ooool2o`0000;ooooo00?o0000ooooooooool0
3oooool3o`0001Gooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Nooooo`04o`00
0?ooooooooooooooo`Co00002Oooool2o`0000_ooooo0_l0000Mooooo`?o00004_ooool00ol0003o
ooooooooo`0<ooooo`;o00003?ooool2o`0000Wooooo0_l0000Pooooo`;o00000_ooool00ol0003o
ooooooooo`0Jooooo`;o00002_ooool00ol0003oooooooooo`04ooooo`;o00003_ooool7o`000003
ooooool0003o0000017ooooo0_l0000<ooooo`;o00000_ooool00ol0003oooooooooo`0>ooooo`03
o`000?oooooooooo03Gooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooSh
n`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOoh
n?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOog
moWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWo
moOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCe
nOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmood
mOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOo
m?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInHOooool2o`00053ooooo0_l0000fooooo`;o0000<oooool2o`000?oooooo
Koooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOok
nokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInHoooool00ol0
003oooooooooo`1=ooooo`03o`000?oooooo000003Gooooo00?o0000ooooool00000=?ooool00ol0
003oooooooooo`3oooooofcooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVOVCooooo00?o0000ooooooooool0C_ooool00ol0003oooooooooo`0fooooo`03o`000?oo
oooooooo03;ooooo00?o0000ooooooooool0oooooom[ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Go
l?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWhUooooo`?o00001?ooool7o`000004ooooool0003o0000o`00
00;ooooo1?l000000ooooooo0000o`000003ooooo`;o00001_ooool4o`000003ooooool0003o0000
00Gooooo1ol000000ooooooo0000o`000003ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool00_ooool7o`0000;ooooo1?l000000ooooooo0000o`000002ooooo`?o00001_ooool3o`00
00;ooooo0ol00004ooooo`04o`000?ooooooooooo`0000Gooooo1ol000001?oooooo0000o`000?oo
ool5o`0000Cooooo00?o0000ooooooooool01?ooool3o`0000;ooooo0ol00002ooooo`?o00001_oo
ool01?l0003oooooooooool00003ooooo`?o000000?oooooo`000?l000000ol000000ooooooo0000
o`000002ooooo`?o000000?oooooo`000?l000000oooool00ol0003oooooooooo`04ooooo`Go0000
00Coooooo`000?l0003o00000oooool2o`0000;ooooo0ol00005ooooo`?o000000Coooooo`000?l0
003ooooo0ol00003ooooo`;o00001oooool01?l0003oooooooooooooool3o`000003ooooool0003o
000000;ooooo0ol000000ooooooo0000o`000003o`0000Cooooo1?l00003ooooo`?o00000_ooool2
o`0000?ooooo1ol00003ooooo`?o000000?oooooo`000?l000000_ooool7o`000004ooooool0003o
0000ooooo`;o000000Coooooo`000?l0003o00000oooool2o`0000;ooooo0ol00006ooooo`03o`00
0?oooooooooo00;ooooo1ol00002ooooo`Co000000?oooooo`000?l000000oooool00ol0003ooooo
ooooo`3eooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhUoooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
oooo00?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooo000000Oooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`00
00;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooo`000004ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooo
oooo0000ooooool00003ooooo`03o`000?oooooooooo00?ooooo0_l00006ooooo`04o`000?oooooo
ooooo`0000?ooooo00Co0000oooooooooooo00001oooool01?l0003oooooooooool00004ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool01ol0003ooooooooooooo
oooo0000ooooool000000oooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo
00?o0000ooooooooool00oooool01_l0003oooooooooool0003oooooo`0000?ooooo00Co0000oooo
oooooooo00001oooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00Ko0000
oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
00001Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00Co0000oooo
oooooooo00001Oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;o
oooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000
oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000oooooooo
ool0n?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[j
oOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9oooool2
o`0000;ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000;ooooo
00Ko0000oooooooooooo0000ooooool00004ooooo`03o`000?oooooooooo00Gooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00000oooool00ol0003oooooo`000006ooooo`03o`000?oooooo000000;ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo0000
00Kooooo0_l00004ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool01_l0003ooooooooo
ool0003oooooo`0000?ooooo00?o0000ooooooooool00oooool00ol0003oooooo`000005ooooo`04
o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00001_ooool01_l0003oooooo`000?l0
003oooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000005ooooo`04
o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool00_ooool01ol0003ooooooooooooooooo
0000ooooool000000oooool00ol0003oooooo`000006ooooo`;o00001Oooool01_l0003ooooooooo
ool0003oooooo`0000?ooooo00Co0000oooooooooooo00001oooool00ol0003oooooo`000003oooo
o`03o`000?oooooo000000Gooooo00?o0000ooooool000000oooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0000Gooooo00Co0000oooooooooooo00001?ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000oooool0
0ol0003oooooo`000005ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool000000_ooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool00000
oOooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOok
nokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9Oooool2o`00
00Cooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000?ooooo0ol0
00000ooooooo0000ooooo`03ooooo`Co00001Oooool3o`0000;ooooo00?o0000ooooooooool01?oo
ool3o`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00006ooooo`03
o`000?oooooo000000?ooooo0ol00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ool000000ol000000ooooooo0000o`000006ooooo`05o`000?ooooooooooooooool000000_ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo0ol00002ooooo`06o`000?oooooo
ooooo`000?oooooo00000oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000Gooooo
00Co0000oooooooooooo00000oooool01?l0003oooooooooool00006ooooo`06o`000?oooooooooo
o`000?oooooo00000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000Gooooo
00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02ooooo`07o`000?oooooooooooooo
ool0003oooooo`000003ooooo`03o`000?oooooo000000?o000000?oooooo`000?l000001oooool0
1_l0003oooooooooool0003oooooo`0000?ooooo00Co0000oooooooooooo00001_ooool01?l0003o
ooooooooool00003ooooo`03o`000?oooooo000000?o00000_ooool00ol0003oooooo`000003oooo
o`03o`000?oooooooooo00?ooooo0ol00005ooooo`03o`000?oooooooooo00Co00000_ooool3o`00
00;ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000003ooooo`03o`00
0?oooooo000000?o00000_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo000000?ooooo
0ol00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000ol0003jooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhUooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00000_ooool2o`0000;ooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooo
oooooooo00000_ooool2o`000005ooooool0003oooooooooool000000oooool00ol0003ooooooooo
o`02ooooo`07o`000?ooooooooooooooool0003oooooo`000002ooooo`04o`000?ooooooooooo`00
00;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0
1Oooool2o`0000Cooooo00Co0000oooooooooooo00000_ooool2o`000004ooooool0003oooooo`00
00;ooooo0_l00005ooooo`03o`000?oooooo000000Gooooo00Co0000oooooooooooo00000oooool0
0ol0003oooooooooo`02o`0000Gooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`02o`000007ooooool0003oooooooooool0003oooooo`000002ooooo`03o`000?oooooooooo00;o
000000?oooooo`000?ooool01?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o
000000?oooooo`000?ooool00_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;o
oooo00?o0000ooooooooool00oooool2o`000004ooooool0003oooooo`0000?ooooo00Co0000oooo
oooooooo00001_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000000_oo
ool01_l0003oooooooooool0003oooooo`0000;ooooo0_l00004ooooo`04o`000?ooooooooooo`00
00Gooooo0_l000001ooooooo0000oooooooooooo0000ooooool000000_ooool01?l0003ooooooooo
ool00005ooooo`;o000000Goooooo`000?ooooooooooo`000002ooooo`03o`000?oooooooooo00;o
000000Koooooo`000?l0003oooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000_ooool0
0ol0003oooooooooo`02o`0000Cooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo
00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000
ooooooooool0n?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
9_ooool3o`000004ooooool0003o0000ooooo`;o000000Coooooo`000?l0003ooooo1?l00002oooo
o`;o00000oooool3o`0000;ooooo0_l00006ooooo`;o00000_ooool3o`0000Gooooo0_l00002oooo
o`;o000000Coooooo`000?oooooooooo0ol000001?oooooo0000o`000?l00002ooooo`?o00000_oo
ool2o`000003ooooool0003o000000?ooooo00Go0000ooooool0003o0000ooooo`02o`0000;ooooo
0_l00003ooooo`?o00001Oooool3o`0000;ooooo0ol00005ooooo`;o000000?oooooo`000?ooool0
0oooool2o`0000;ooooo0_l000000ooooooo0000ooooo`02ooooo`;o000000?oooooo`000?ooool0
0oooool2o`000003ooooool0003ooooo00?ooooo0ol00002ooooo`?o00000_ooool2o`000003oooo
ool0003ooooo00;ooooo0_l000001Ooooooo0000o`000?l0003ooooo00;o000000Coooooo`000?oo
oooo00000_ooool2o`0000;ooooo0ol00002ooooo`03o`000?oooooo000000Gooooo0ol00004oooo
o`;o000000Coooooo`000?oooooooooo0ol00003ooooo`;o00000oooool3o`0000Cooooo0_l00000
0ooooooo0000ooooo`02ooooo`?o00000_ooool3o`0000Cooooo0ol000000ooooooo0000o`000003
o`0000;ooooo0_l00003ooooo`03o`000?oooooooooo00;o000000?oooooo`000?ooool01?ooool2
o`0000Gooooo0_l000000ooooooo0000ooooo`02o`0000?ooooo0_l00003ooooo`03o`000?oooooo
oooo00;ooooo0_l000001?oooooo0000ooooooooool2o`000004ooooool0003o0000ooooo`;o0000
00Goooooo`000?ooooooooooo`000002ooooo`04o`000?oooooo0000o`0000?ooooo0_l00002oooo
o`;o000000Coooooo`000?oooooooooo0ol00002ooooo`;o000000?oooooo`000?l000000oooool0
1Ol0003oooooo`000?l0003ooooo00;o00000_ooool2o`000?_ooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOSGooooo00?o0000ooooooooool06?ooool00ol0003o
ooooooooo`0Tooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool06_ooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool07oooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06Oooool00ol0003o
ooooooooo`0Gooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0ooooool4ooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWheooooo`04o`000?oooooo
ooooo`0001Oooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Iooooo`04o`000?oo
ooooooooo`0001Wooooo00?o0000ooooooooool02oooool01?l0003oooooooooool0000Fooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool01oooool00ol0003oooooo`000005ooooo`03
o`000?oooooooooo01oooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo01Wooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Kooooo`03
o`000?oooooooooo0?oooooo1?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn=_ooool3o`0003gooooo0_l0000Looooo`?o00006?ooool2o`0000kooooo0ol0000E
ooooo`;o00001Oooool00ol0003oooooooooo`04ooooo`;o00002_ooool2o`0000Cooooo0_l0000_
ooooo`03o`000?oooooooooo00Cooooo0_l00004ooooo`;o00006_ooool2o`0001Sooooo0_l0000L
ooooo`;o0000ooooool6ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooSh
n`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOoh
n?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOog
moWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVOV;ooooo0_l0000[ooooo`?o0000_?ooool2o`000?oooooo@Oooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInH_ooool00ol0003oooooo`00000Yoooo
o`05o`000?ooooooooooooooool00000^oooool00ol0003oooooo`00003ooooood3ooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOVGooooo00?o0000ooooooooool0
9_ooool01Ol0003ooooooooooooooooo00000;gooooo00?o0000ooooooooool0oooooolnooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhVooooo`?o00000oooool3
o`000004ooooool0003o0000ooooo`;o00001Oooool3o`0000?ooooo1ol000001?oooooo0000o`00
0?ooool2o`0000?ooooo0_l000001Ooooooo0000o`000?l0003ooooo00?o00000_ooool3o`000003
ooooool0003o000000?ooooo00?o0000ooooooooool00oooool3o`0000;ooooo0ol000001?oooooo
0000o`000?ooool3o`0000Cooooo1ol000000ooooooo0000o`000003o`0000Cooooo0ol000001?oo
oooo0000o`000?l00002ooooo`03o`000?oooooooooo00;ooooo0_l00006ooooo`Co00000oooool3
o`0000;ooooo0_l00003ooooo`Oo00000oooool3o`000003ooooool0003o000000;ooooo1ol00000
1?oooooo0000o`000?ooool2o`000004ooooool0003o0000o`0000?ooooo0_l00002ooooo`?o0000
1?ooool3o`0000;ooooo0ol00002ooooo`?o00001Oooool:o`0000Gooooo00?o0000ooooooooool0
0_ooool7o`0000;ooooo1?l000000ooooooo0000o`000002ooooo`?o00001_ooool3o`0000;ooooo
0ol00004ooooo`04o`000?ooooooooooo`0000Gooooo1ol000001?oooooo0000o`000?ooool5o`00
00Cooooo00?o0000ooooooooool01Oooool4o`000003ooooool0003o000000Kooooo00Co0000oooo
oooooooo00000oooool3o`000003ooooool0003o000000?o000000?oooooo`000?l000000_ooool3
o`000003ooooool0003o000000?ooooo0ol000000ooooooo0000o`000004ooooo`Ko00001_ooool2
o`0000Cooooo00?o0000ooooooooool00_ooool7o`0000;ooooo1?l000000ooooooo0000o`000002
o`000003ooooool0003o000000;ooooo0_l00003ooooo`Go000000?oooooo`000?ooool01Oooool3
o`0000?ooooo0ol000001?oooooo0000o`000?ooool2o`0000;ooooo0ol00002ooooo`;o00001ooo
ool01?l0003oooooooooool00003ooooo`Wo00001?ooool3o`0000?ooooo0_l00005ooooo`?o0000
00Coooooo`000?l0003ooooo0ol00002ooooo`?o000000?oooooo`000?l000000_ooool3o`0000Go
oooo1_l000000ooooooo0000o`000004ooooo`;o000000Goooooo`000?l0003o0000ooooo`02o`00
0003ooooool0003o000000Gooooo0ol000000ooooooo0000o`000004o`000004ooooool0003o0000
ooooo`Oo0000<oooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
7?ooool5o`0000Kooooo00?o0000ooooooooool00oooool01_l0003oooooooooool0003oooooo`00
00;ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo
00?o0000ooooool000000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002ooooo`06o`000?oooooooooo
o`000?oooooo00000oooool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oo
oooo00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00Go0000oooo
ooooooooooooo`000003ooooo`04o`000?ooooooooooo`0000Cooooo00Co0000oooooooooooo0000
1Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooo
oooo00001Oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo
00Co0000oooooooooooo00001_ooool01?l0003oooooooooool00003ooooo`04o`000?oooooooooo
o`0000Gooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00006ooooo`05o`00
0?ooooooooooooooool000000_ooool01?l0003oooooooooool00002ooooo`06o`000?oooooooooo
o`000?oooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Go
0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool00000
1?ooool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oooooo00000oooool0
0ol0003oooooooooo`03ooooo`;o00001Oooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00Gooooo00Co0000oooooooooooo00001?ooool01?l0003oooooooooool00002ooooo`03
o`000?oooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03oooo
o`04o`000?ooooooooooo`0000Kooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`00
0?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool00oooool01_l0003oooooooooool0003oooooo`0000;ooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooool00006ooooo`04o`000?ooooooooooo`0000Co
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02ooooo`07o`000?oooooooooo
ooooool0003oooooo`000002ooooo`03o`000?oooooooooo00?ooooo00Ko0000oooooooooooo0000
ooooool00003ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooo`000002
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`03ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000002ooooo`03o`00
0?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool01?l0003oooooooooool0000dooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Go
l?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWhLooooo`Go00001_ooool00ol0003oooooooooo`03ooooo`06
o`000?ooooooooooo`000?oooooo00002?ooool01Ol0003ooooooooooooooooo000000;ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooo`000005ooooo`07o`000?ooooooooooooooool0
003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`04ooooo`;o00000_ooool01_l0003oooooooooool0003oooooo`0000?ooooo
00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000?ooooo00?o0000
ooooooooool00oooool2o`0000?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`00
0?oooooooooo00Gooooo00Co0000oooooooooooo00001Oooool01?l0003oooooooooool00004oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooo`000003ooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool01?ooool01?l0003o
ooooooooool00003ooooo`04o`000?ooooooooooo`0000Gooooo00Co0000oooooooooooo00000_oo
ool01?l0003oooooooooool00005ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000Kooooo0_l00004oooo
o`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00?ooooo00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000?o
oooo00?o0000ooooooooool00oooool00ol0003oooooo`000004ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool01?ooool01_l0003oooooo`000?l0003oooooo`0000?ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooo`000005ooooo`04o`000?ooooooooooo`0000Go
oooo00Co0000oooooooooooo00001_ooool01?l0003oooooooooooooool2o`0000Cooooo00?o0000
ooooooooool00oooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000[ooooo00?o0000oooo
ooooool00oooool01_l0003oooooooooool0003oooooo`0000Gooooo00Co0000oooooooooooo0000
2?ooool01_l0003oooooo`000?l0003oooooo`0000?ooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`02ooooo`07o`000?ooooooooooooooool0003oooooo`000008ooooo`06o`00
0?ooooooooooo`000?oooooo00000oooool01_l0003oooooooooool0003oooooo`0000Kooooo0_l0
0005ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000000;ooooo00?o0000ooooool000002?ooool01Ol0003ooooooooooooooooo0000
00;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`000?ooooooooooo`0003Cooooo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_k
o_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00006oooo
o`03o`000?oooooooooo00?ooooo00Go0000oooooooooooo0000ooooo`04o`0000Gooooo00Go0000
ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool00000
1Oooool01ol0003ooooooooooooooooo0000ooooool000000oooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool2o`0000Cooooo00Ko0000
oooooooooooo0000ooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooo
oooo0000ooooool00003ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_oo
ool01_l0003oooooooooool0003oooooo`0000;ooooo1?l00005ooooo`?o00001Oooool00ol0003o
ooooooooo`04o`0000;ooooo0ol00002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooool000000oooool00ol0003oooooo`000003o`0000;ooooo00?o0000ooooooooool01?oo
ool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000Kooooo0ol00002ooooo`04
o`000?ooooooooooo`0000Gooooo00?o0000ooooool000000oooool3o`0000;ooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooo`000003o`000003ooooool0003o000000Kooooo00Go0000
ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?oo
ool3o`0000;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooool000001Oooool3o`0000;ooooo00?o0000ooooooooool01?ooool01_l0003o
ooooooooool0003oooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`00
0005ooooo`04o`000?ooooooooooo`0000Gooooo00Co0000oooooooooooo00001_ooool01?l0003o
ooooo`000?l00006ooooo`Co00000_ooool00ol0003oooooo`000003ooooo`?o00000_ooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00?o00000_ooool00ol0003oooooooooo`04
o`000003ooooool0003ooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03
ooooo`05o`000?ooooooooooo`000?ooool01?l00002ooooo`03o`000?oooooooooo00Co00001Ooo
ool01_l0003oooooooooool0003oooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`02ooooo`06o`000?ooooooooooooooool0003ooooo1?l00005ooooo`06o`000?oo
ooooooooo`000?oooooo00000oooool01Ol0003oooooooooool0003ooooo00Co000000?oooooo`00
0?l000001oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo00Go0000
ooooooooooooooooo`000002ooooo`03o`000?oooooo000000?o00001Oooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo00000_ooool3o`0000;ooooo00?o0000oooooooo
ool0<_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[j
oOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool5
o`0000Kooooo00?o0000ooooooooool00oooool2o`000004ooooool0003oooooo`0000;ooooo00?o
0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0
0_l000001?oooooo0000ooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000oooo
ool000000oooool00ol0003oooooooooo`02o`000003ooooool0003ooooo00Cooooo00?o0000oooo
ooooool00_ooool01?l0003oooooooooool00002ooooo`;o000000Coooooo`000?oooooo00000ooo
ool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool2o`00
00Cooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00005ooooo`;o000000Oo
ooooo`000?ooooooooooo`000?oooooo000000;ooooo00Co0000oooooooooooo00001Oooool2o`00
0005ooooool0003oooooooooool000000_ooool00ol0003oooooooooo`02o`000006ooooool0003o
0000ooooool0003ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0
0_l00005ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_l00004ooooo`04
o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001?ooool01ol0003ooooooooooooo
oooo0000ooooool000000_ooool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Go0000
ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Gooooo0_l00004ooooo`04o`000?oo
ooooooooo`0000;ooooo0_l000001?oooooo0000ooooool00002ooooo`;o00001Oooool00ol0003o
ooooo`000004ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00;o000000Ooooooo`000?ooooooooooo`00
0?oooooo000000;ooooo00?o0000ooooooooool00_l000000ooooooo0000ooooo`04ooooo`04o`00
0?ooooooooooo`0000Kooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`02ooooo`06
o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooo`000002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`;o00002_ooool00ol0003ooooooooo
o`03ooooo`;o000000Coooooo`000?oooooo00000_ooool00ol0003oooooooooo`02o`000005oooo
ool0003oooooooooool000001Oooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00001?ooool2o`0000;ooooo00?o0000ooooool000000_oo
ool00ol0003oooooooooo`03ooooo`;o000000Coooooo`000?oooooo00000oooool01_l0003ooooo
ooooool0003oooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00;o000000?oooooo`000?ooool01?ooool01?l0003oooooooooooooool2
o`000004ooooool0003oooooo`0000;ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooo
oooooooo000000;ooooo0_l000001?oooooo0000ooooool00002ooooo`04o`000?ooooooooooo`00
03Cooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol0
0006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000oooool2o`0000Gooooo0ol0
00001?oooooo0000o`000?ooool2o`000005ooooool0003o0000ooooool000000oooool3o`000005
ooooool0003o0000o`000?ooool00_l00002ooooo`?o00000_ooool2o`000003ooooool0003ooooo
00Cooooo0ol00004ooooo`?o00000_ooool00ol0003oooooo`000003ooooo`?o00000_ooool2o`00
0003ooooool0003o000000;ooooo00?o0000ooooooooool00_l000000ooooooo0000ooooo`04oooo
o`Wo00000_ooool2o`000003ooooool0003o000000Kooooo0_l00005ooooo`;o000000?oooooo`00
0?ooool00_l00003ooooo`;o00000oooool00ol0003oooooooooo`02ooooo`;o000000Coooooo`00
0?oooooooooo0_l000001?oooooo0000o`000?ooool2o`000005ooooool0003oooooooooool00000
0_ooool01?l0003oooooo`000?l00003ooooo`;o00000_ooool2o`000003ooooool0003ooooo00;o
oooo0ol00002ooooo`?o00000_ooool2o`000003ooooool0003ooooo00?ooooo0_l00003ooooo`04
o`000?ooooooooooo`0000?ooooo0ol00002ooooo`;o000000?oooooo`000?l000000oooool01Ol0
003oooooo`000?l0003ooooo00;o00000_ooool2o`0000?ooooo0ol00005ooooo`?o00000_ooool3
o`0000Gooooo0_l000000ooooooo0000ooooo`03ooooo`;o00000_ooool2o`000003ooooool0003o
oooo00;ooooo0_l000000ooooooo0000ooooo`03ooooo`;o000000?oooooo`000?ooool01?ooool2
o`0000;ooooo0ol00004ooooo`;o000000Goooooo`000?l0003o0000ooooo`02o`000004ooooool0
003oooooo`0000;ooooo0_l00002ooooo`?o00000_ooool00ol0003oooooo`000005ooooo`;o0000
00Coooooo`000?l0003o00001?ooool2o`0000;ooooo0ol00005ooooo`;o000000Coooooo`000?l0
003o00000_ooool2o`000003ooooool0003o000000?ooooo00Go0000ooooool0003o0000ooooo`02
o`0000;ooooo0_l00002ooooo`?o00000_ooool2o`0000?ooooo0_l000000ooooooo0000ooooo`09
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000oooool2o`0000;ooooo0_l00000
0ooooooo0000ooooo`02o`0000Gooooo0_l000001Ooooooo0000o`000?l0003ooooo00Co00000_oo
ool01?l0003oooooooooool00004ooooo`04o`000?oooooo0000o`0000?ooooo0_l00006ooooo`03
o`000?oooooo000000?ooooo0ol00003ooooo`03o`000?oooooooooo00;o00000oooool3o`0000Co
oooo0_l000001Ooooooo0000o`000?oooooo000000Gooooo0ol00002ooooo`03o`000?oooooo0000
00?ooooo0_l00005ooooo`?o000000Coooooo`000?l0003ooooo0_l000000ooooooo0000ooooo`02
ooooo`;o00000oooool00ol0003oooooooooo`0booooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWhWooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
;oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
4oooool01?l0003oooooooooool0000@ooooo`03o`000?oooooooooo01Wooooo00?o0000oooooooo
ool06_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01oooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Pooooo`04o`000?ooooooooooo`0000Cooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01Wooooo00Go0000oooo
ooooooooooooo`00000=ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0<_ooool0
2_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_n
oo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9?ooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`0000gooooo00Co0000oooooooooooo00004Oooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooo000000Oooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool05oooool0
0ol0003oooooooooo`0@ooooo`04o`000?ooooooooooo`0001;ooooo00Co0000oooooooooooo0000
4?ooool00ol0003oooooooooo`0Iooooo`04o`000?ooooooooooo`0001Wooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00008_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00cooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`0Iooooo`05o`000?ooooooooooooooool00000
3Oooool01?l0003oooooooooool0000>ooooo`03o`000?oooooooooo03;ooooo00[oiNK^onc^loo/
koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORCooooo1ol000000ooooooo0000o`00000>
ooooo`?o00005Oooool00ol0003oooooooooo`0Aooooo`;o00001_ooool2o`00013ooooo0_l00004
ooooo`;o00002_ooool00ol0003oooooooooo`0Sooooo`;o00006?ooool2o`0001?ooooo0ol0000A
ooooo`;o000000?oooooo`000?l000003oooool2o`0001cooooo0ol0000Hooooo`;o00008Oooool2
o`0000Gooooo00?o0000ooooooooool01?ooool2o`0000Sooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0Gooooo`;o00006?ooool2o`0000Oooooo1ol000000ooooooo0000o`00000O
ooooo`05o`000?oooooo0000o`000?ooool00_l00003ooooo`;o00003Oooool2o`0000[ooooo0_l0
000?ooooo`03o`000?oooooooooo00cooooo0_l0000>ooooo`Co00003?ooool2o`0003Cooooo00[o
iNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_ok
nokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool0
2_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_n
oo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_k
o_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBoooo
o`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_ok
nokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_oo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;o
oooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_n
oo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonB
ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_k
o_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo
T_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOok
nokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooo
oi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooo
oonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[m
oo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooo
ooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[j
oOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInmOooool2
o`000?ooooooV_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
a?ooool3o`00033ooooo00?o0000ooooooooool0oooooonGooooo`0:onGVk_o/k_?ok>odonk_m?o_
l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWk5ooooo`03o`000?oooooooooo02oooooo00?o0000oooo
ooooool0oooooonGooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;o
nOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWhUooooo`?o00001?ooool5o`0000?ooooo0ol00005ooooo`?o00000oooool3o`0000;ooooo1?l0
0006ooooo`?o00000_ooool2o`0000?ooooo0_l00003ooooo`Oo000000Goooooo`000?l0003o0000
ooooo`05o`0000Kooooo1?l00004ooooo`04o`000?oooooo0000o`0000Cooooo0_l000001?oooooo
0000o`000?ooool5o`0000;ooooo1Ol00003ooooo`Go00000_ooool3o`0000Cooooo1?l00003oooo
o`?o00000oooool5o`0000?ooooo1Ol000000ooooooo0000o`000002o`0000;ooooo0ol000001Ooo
oooo0000o`000?l0003ooooo00Go00000oooool3o`0000?ooooo1?l00006ooooo`?o00000oooool3
o`0000?ooooo00?o0000ooooooooool00_l00003ooooo`;o00000oooool2o`0000;ooooo00?o0000
ooooooooool0oooooon6ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooSh
n`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWhLooooo`Go00001Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo
00Go0000ooooooooooooooooo`000003ooooo`07o`000?ooooooooooooooool0003oooooo`000003
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool01?l0003ooooooooo
ool00002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_ooool01Ol0
003ooooooooooooooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooo`0000Gooooo0_l00002ooooo`04o`000?ooooooooooo`0000;ooooo
0_l00003ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool01Ol0003ooooo
oooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo
00Cooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00?ooooo00Go0000
ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000Cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo0000
00;ooooo00Go0000ooooooooooooooooo`000004ooooo`07o`000?ooooooooooooooool0003ooooo
o`000003ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooo`000002oooo
o`04o`000?ooooooooooo`000?ooooooS?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOo
m?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVIn7?ooool5o`0000Gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`02ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`07ooooo`04
o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00005
ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00003ooooo`04o`00
0?ooooooooooo`0000?ooooo0_l00004ooooo`04o`000?ooooooooooo`0000Wooooo00Co0000oooo
oooooooo00000oooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000ooooooooool00ooo
ool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`04ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000
ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`02ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`06
o`000?ooooooooooo`000?oooooo00001?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo0?ooooooR_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
7?ooool5o`0000Gooooo0ol00005ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooooooo
ooooo`000003ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00000oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00Co00000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00Co0000oooooooooooo00000oooool01Ol0003oooooooooool0003ooooo00;o0000
1oooool3o`0000Wooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo0000
00Kooooo00?o0000ooooooooool01?ooool4o`0000;ooooo00?o0000ooooooooool01?ooool5o`00
00;ooooo00?o0000ooooooooool00ol00002ooooo`03o`000?oooooooooo00Cooooo1?l00002oooo
o`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`?o00001Oooool01ol0003ooooooooo
oooooooo0000ooooool000000oooool01Ol0003oooooooooool0003ooooo00Co000000?oooooo`00
0?ooool01?ooool00ol0003oooooooooo`3ooooooh[ooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00005ooooo`04o`000?ooooooooooo`0000Cooooo
00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooooooo
ool01Oooool2o`0000?ooooo00Go0000ooooooooooooooooo`000005ooooo`;o000000Goooooo`00
0?ooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003ooooooooo
o`02o`0000;ooooo0_l000001?oooooo0000ooooool00002ooooo`03o`000?oooooooooo00;ooooo
00Co0000oooooooooooo00001_ooool3o`0000?ooooo00Go0000ooooooooooooooooo`000003oooo
o`;o00001Oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`00
0?oooooooooo00Gooooo0_l00004ooooo`05o`000?ooooooooooooooool000000_ooool2o`0000;o
oooo00?o0000ooooooooool00_l00002ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000004
ooooo`06o`000?ooooooooooooooool0003ooooo0_l00002ooooo`06o`000?ooooooooooo`000?oo
oooo00000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`000?ooooooS?ooool0
2_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_n
oo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool5o`0000Gooooo
00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`03ooooo`?o00000oooool5o`0000Ko
oooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`;o000000?oooooo`00
0?ooool00_l00002ooooo`?o000000Coooooo`000?l0003ooooo0_l000001?oooooo0000o`000?oo
ool3o`000003ooooool0003ooooo00;ooooo0ol00005ooooo`;o00001_ooool00ol0003ooooooooo
o`03ooooo`;o00000_ooool2o`0000;ooooo0_l000000ooooooo0000o`000002ooooo`Go00000ooo
ool3o`0000Cooooo1?l00003ooooo`?o00000oooool00ol0003oooooooooo`04ooooo`;o000000?o
ooooo`000?l000000oooool3o`0000;ooooo0_l000000ooooooo0000o`000003ooooo`04o`000?oo
oooo0000o`0000?ooooo0ol00005ooooo`Co00000oooool4o`0000Gooooo0ol00002ooooo`04o`00
0?oooooo0000o`0000;ooooo0_l00002ooooo`;o00000oooool3o`000004ooooool0003o0000o`00
0?ooooooRoooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08
oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9_oo
ool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
0oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00003oooool00ol0
003oooooooooo`0Qooooo`03o`000?oooooooooo00;o00004Oooool00ol0003oooooooooo`0Hoooo
o`05o`000?ooooooooooooooool000005oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool0oooooon:ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWhUooooo`Co00001?ooool2o`0001?ooooo0ol00002ooooo`Co0000
4?ooool00ol0003oooooooooo`0Rooooo`;o000000?oooooo`000?ooool04Oooool3o`0001Sooooo
1?l0000Fooooo`;o00002?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool0oooooon:ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWo
moOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWk_ooooo`;o00001_ooool00ol0003oooooooooo`3ooooooiOooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/
k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGV
k_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^ko
k>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oU
i^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGV
k_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_n
onGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oU
i^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_k
o_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[o
iNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_ok
nokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool0
2_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_n
oo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_k
o_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBoooo
o`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_ok
nokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_oo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInX?ooool3o`0003Ko
oooo0ol0003ooooookGooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVOZ7ooooo00?o0000ooooooooool0=?ooool01Ol0003ooooooooooooooooo00000?oooooo]?oo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInXOooool00ol0003o
ooooooooo`0dooooo`05o`000?ooooooooooooooool00000oooooondooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhUooooo`?o00001?ooool5o`0000?ooooo0ol0
0005ooooo`?o00000oooool3o`0000;ooooo1?l00006ooooo`?o000000Coooooo`000?l0003ooooo
1ol00006ooooo`;o000000Goooooo`000?l0003o0000ooooo`02o`000003ooooool0003o000000Ko
oooo1Ol000000ooooooo0000o`000002ooooo`?o00000_ooool4o`0000;ooooo1ol000000ooooooo
0000o`000005ooooo`?o00000oooool01?l0003oooooo`000?l00003ooooo`;o000000Goooooo`00
0?l0003o0000ooooo`03o`0000;ooooo0ol000000ooooooo0000o`000003ooooo`?o00000oooool2
o`0000?ooooo0_l00002ooooo`;o000000?oooooo`000?l000001?l000001?oooooo0000o`000?oo
ool3o`0000Cooooo0ol000000ooooooo0000o`000003o`0000;ooooo0_l00003ooooo`Co00000_oo
ool4o`0000cooooo0_l0000:ooooo`?o00000oooool5o`0000?ooooo0_l000000ooooooo0000o`00
0002ooooo`Co00000_ooool00ol0003oooooooooo`3oooooof7ooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00005ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo00Oo0000oooo
ooooooooooooo`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
ooooo`04ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooo`000002oooo
o`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool00_ooool01ol0003ooooooooooooooooo0000ooooool00000
0_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00005ooooo`05o`000?ooooooooooooooool00000
0_ooool2o`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooo`000003ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003o
ooooo`0000;ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooooooo000000;o
oooo00Ko0000oooooooooooo0000ooooool00008ooooo`05o`000?ooooooooooooooool000000_oo
ool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Cooooo00Go0000oooooooooooo
ooooo`00000=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;o00000_ooool00ol0003oooooooooo`3oooooofSo
oooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_n
oo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00005
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooo
oooo000000?ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`000?oooooooooo
ooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000001ooo
ool01ol0003ooooooooooooooooo0000ooooool000001Oooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`03ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooooooo`04ooooo`;o000000?oooooo`000?ooool01?ooool01Ol0003ooooooooo
oooooooo000000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02o`0000Ko
oooo1Ol00003ooooo`;o00001?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00co
oooo0_l00008ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool0oooooomXooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhLooooo`Go00001Oooool3o`0000Gooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool0
1oooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooo
oooo00000_ooool3o`000003ooooool0003o000000Oooooo00Go0000ooooooooooooooooo`000002
ooooo`03o`000?oooooo000000?o00001?ooool01_l0003ooooooooooooooooo0000ooooo`Co0000
0_ooool01?l0003oooooooooooooool3o`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0
003oooooooooool00005ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`02ooooo`;o00000oooool4o`0000;ooooo00Go0000
ooooooooooooooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool00000
0_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo000000Cooooo0_l00004ooooo`Go0000
0oooool3o`0000Kooooo1Ol00006ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool5o`000?oo
ooooI_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[j
oOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool5
o`0000Gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`02ooooo`05o`000?oo
ooooooooooooool000000oooool00ol0003oooooooooo`05ooooo`;o00000oooool01Ol0003ooooo
oooooooooooo000000Gooooo0_l000001?oooooo0000ooooool00002ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooooooool00oooool01?l0003oooooooooooooool2o`000004ooooool0003o
ooooo`0000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02o`000005ooooool0
003oooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`05o`000?oooooo
ooooooooool000000_ooool2o`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003ooooo
o`000003ooooo`03o`000?oooooooooo00;o000000?oooooo`000?ooool00oooool01_l0003ooooo
ooooool0003oooooo`0000;ooooo00Co0000oooooooooooo00000oooool01Ol0003ooooooooooooo
oooo000000;ooooo0_l000001?oooooo0000ooooool00002ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooool000000oooool01?l0003oooooooooool00003ooooo`05o`000?oooooooooooooo
ool000000_ooool01Ol0003ooooooooooooooooo000000kooooo0_l00008ooooo`03o`000?oooooo
oooo00?ooooo0_l00004ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooo
oooooooo00000?ooooooI_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOoh
n?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVIn7?ooool5o`0000Gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`03
ooooo`?o00000oooool5o`0000Kooooo00Co0000oooooooooooo00000oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooo000000?ooooo0_l00003ooooo`?o00001?ooool3o`0000;ooooo00?o
0000ooooool000000oooool2o`0000Kooooo0_l000001?oooooo0000ooooooooool2o`0000;ooooo
0ol00002ooooo`;o00000_ooool2o`000003ooooool0003o000000;ooooo00?o0000ooooool00000
0_l00005ooooo`?o00000_ooool2o`000003ooooool0003o000000;ooooo0ol000000ooooooo0000
o`000002ooooo`?o00000_ooool2o`000003ooooool0003ooooo00Gooooo0ol00002ooooo`;o0000
0_ooool3o`000005ooooool0003o0000o`000?ooool00_l000001Ooooooo0000o`000?oooooo0000
00?ooooo1?l00005ooooo`03o`000?oooooo000000;ooooo0_l00002ooooo`;o00000oooool3o`00
00Cooooo1?l0000=ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool2o`00
0004ooooool0003o0000ooooo`;o00000_ooool2o`0000?ooooo0ol0003oooooofOooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORKooooo00Co0000oooooooooooo
00001?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0000Kooooo00?o0000ooooooooool04?ooool0
1Ol0003ooooooooooooooooo0000013ooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`0<ooooo`04o`000?ooooooooooo`0001?ooooo00?o0000ooooooooool07Oooool01Ol0003ooooo
oooooooooooo000001Kooooo00?o0000ooooooooool08?ooool2o`0000Sooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`3oooooogSooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVORGooooo1?l00004ooooo`;o00004oooool3o`0000;ooooo1?l0
0007ooooo`03o`000?oooooooooo013ooooo00Go0000ooooooooooooooooo`00000@ooooo`03o`00
0?oooooooooo00Gooooo00Co0000oooooooooooo00002oooool01?l0003oooooooooool0000Coooo
o`03o`000?oooooooooo01gooooo00Go0000ooooooooooooooooo`00000Eooooo`;o0000;?ooool7
o`000?ooooooN_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
DOooool2o`0001Gooooo0_l0000?ooooo`;o00002?ooool3o`0000[ooooo0_l0000Jooooo`03o`00
0?oooooooooo027ooooo00?o0000ooooooooool0oooooonnooooo`0:onGVk_o/k_?ok>odonk_m?o_
l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCo
ko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_
m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^
koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCo
k^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_
m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/
koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?o
k>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/
k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGV
k_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^ko
k>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oU
i^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooooooh_ooool3o`0000oooooo
0ol0002Jooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooo
on?ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`2Iooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooon?ooooo00?o0000ooooooooool03ooo
ool00ol0003oooooooooo`2Iooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWhVooooo`?o00001?ooool5o`0000?ooooo0ol00005ooooo`?o00000_ooool3o`0000Go
oooo0ol00003ooooo`Go000000Goooooo`000?l0003o0000ooooo`03o`0000?ooooo0ol00002oooo
o`Co0000K_ooool5o`0000?ooooo0ol0002Vooooo`;o000000Goooooo`000?l0003o0000ooooo`02
o`000003ooooool0003o000000Gooooo0ol000000ooooooo0000o`000002ooooo`Oo000000Cooooo
o`000?l0003ooooo0_l000001?oooooo0000o`000?l00003ooooo`;o00000_ooool3o`0000Gooooo
0ol00002ooooo`?o00001Oooool3o`0000?ooooo1ol000001?oooooo0000o`000?ooool2o`000003
ooooool0003ooooo00;o00000_ooool3o`000003ooooool0003o000000Kooooo00Co0000ooooool0
003o00000oooool3o`0000;ooooo1_l000001?oooooo0000o`000?ooool2o`000004ooooool0003o
0000o`0000Gooooo1_l000000ooooooo0000o`000004ooooo`;o00000oooool4o`000003ooooool0
003o000000;ooooo0ol000000ooooooo0000o`000004ooooo`_o00000_ooool2o`0000?ooooo0_l0
0003ooooo`;o000000Goooooo`000?l0003o0000ooooo`03o`0000;ooooo0ol000000ooooooo0000
o`00000]ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhWoooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo
000000?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00?ooooo00Go
0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooooooo
ooooo`000003ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`03o`000?oooooo
oooo06gooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo00000:Gooooo00Go
0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0
0oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00Co0000
oooooooooooo00001Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0
1?ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooool00002ooooo`;o00000_ooool01_l0003oooooooooool0003oooooo`0000;o
oooo00?o0000ooooooooool00oooool2o`0000;ooooo00?o0000ooooool000000oooool01?l0003o
ooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0
0_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool000000_ooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00002oooo
o`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool000000oooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooooooo02cooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCe
nOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVOROooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`05
o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00?ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00Go0000
ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0KOoo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0:?ooooo00Go0000oooooooooooooooo
o`000002ooooo`03o`000?oooooo000000Sooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000oooool0
0ol0003oooooo`000005ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`00
0002ooooo`03o`000?oooooooooo00Kooooo0_l000001Ooooooo0000oooooooooooo000000;ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00003ooooo`06o`000?oooooooooo
o`000?oooooo00002?ooool01ol0003ooooooooooooooooo0000ooooool000000oooool01?l0003o
ooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_ooool2
o`0000Gooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00;ooooo00Ko0000oooooooooooo0000ooooool00005ooooo`04o`000?ooooooooooo`00
00Cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`07o`000?ooooooooooooooool0003o
ooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0;?ooool02_oU
i^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_k
o_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9oooool3o`0000Gooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool0
1?ooool3o`0000?ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;o
oooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00Cooooo0ol0001`oooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0Xoooool01Ol0003ooooooooooooooooo
000000;ooooo00?o0000ooooool000000ol00005ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000?o
oooo00?o0000ooooool000000ol00002ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooo
ooooooooo`000002ooooo`03o`000?oooooooooo00Cooooo0_l00004ooooo`?o00000_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00Go0000oooooooooooo0000
ooooo`04o`0000Gooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;o00001ooo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo1?l00002ooooo`?o0000
00?oooooo`000?ooool01?ooool01?l0003oooooooooool00004ooooo`05o`000?oooooooooooooo
ool000000_ooool01?l0003oooooooooool00002ooooo`Co000000?oooooo`000?ooool01?ooool0
1ol0003ooooooooooooooooo0000ooooool000000oooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo02cooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:Vk
ofIVOROooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`02ooooo`05o`000?oo
ooooooooooooool000000oooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000;o
oooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo0_l00002oooo
o`05o`000?ooooooooooooooool000001Oooool01Ol0003ooooooooooooooooo000006oooooo00?o
0000ooooooooool00oooool3o`000:Kooooo00Co0000oooooooooooooooo0_l000001?oooooo0000
ooooool00002ooooo`03o`000?oooooooooo00?ooooo0_l000001Ooooooo0000oooooooooooo0000
00;ooooo00?o0000ooooooooool00_l000001_oooooo0000o`000?oooooo0000ooooo`;o00000_oo
ool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00;o00001?ooool01Ol0003ooooooooo
oooooooo000000;ooooo00?o0000ooooooooool01?ooool01_l0003oooooooooool0003oooooo`00
00;ooooo00?o0000ooooooooool00_l000001Ooooooo0000o`000?oooooo000000;ooooo0_l00002
ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`03ooooo`;o0000
0_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo0_l000001Ooooooo
0000oooooooooooo000000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02
o`000003ooooool0003ooooo00?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool00_l000000ooooooo0000ooooo`03ooooo`03o`00
0?oooooooooo00;o00000_ooool00ol0003oooooooooo`02o`000007ooooool0003oooooooooool0
003oooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool000000oooool0
0ol0003oooooooooo`02o`000003ooooool0003ooooo02gooooo00[oiNK^onc^loo/koCok^odono`
mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVOROooooo00Co0000oooooooooooo00001?ooool00ol0003o
ooooooooo`03ooooo`?o00000oooool5o`0000?ooooo00Co0000oooooooooooo00000oooool3o`00
00?ooooo0ol00003ooooo`;o000000?oooooo`000?l000000oooool5o`0000?ooooo1?l0001_oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0YOooool3o`0000;ooooo00?o0000oooo
ool000000oooool2o`0000Gooooo0_l000001?oooooo0000ooooooooool2o`000004ooooool0003o
0000ooooo`;o000000Goooooo`000?ooooooooooo`000002ooooo`04o`000?oooooo0000o`0000?o
oooo0_l00002ooooo`;o000000?oooooo`000?ooool00oooool3o`0000;ooooo0ol00006ooooo`?o
00000_ooool2o`0000;ooooo0_l000001Ooooooo0000oooooooooooo000000;ooooo0_l000000ooo
oooo0000o`000003ooooo`03o`000?oooooooooo00;o00001Oooool2o`000003ooooool0003o0000
00?ooooo0ol00002ooooo`;o000000Goooooo`000?l0003oooooo`000002ooooo`?o00000_ooool3
o`0000Cooooo0_l000001Ooooooo0000o`000?oooooo000000Kooooo0_l00003ooooo`;o00000ooo
ool3o`0000;ooooo00?o0000ooooool000001_ooool2o`000003ooooool0003ooooo00;o000000Ko
ooooo`000?l0003oooooo`000?ooool2o`0000?ooooo0ol000001Ooooooo0000o`000?l0003ooooo
00;o00000_ooool3o`0000;ooooo0_l000000ooooooo0000ooooo`0^ooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhWooooo`04o`000?ooooooooooo`0000Cooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0001So
oooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:Ko
oooo00Go0000ooooooooooooooooo`00000Qooooo`03o`000?oooooooooo01Kooooo00?o0000oooo
ooooool07oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo02Cooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo03cooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORKooooo1?l00004ooooo`;o00004_oo
ool4o`0000cooooo00?o0000ooooooooool0Poooool2o`0000Gooooo1?l0002Uooooo`05o`000?oo
ooooooooooooool000008Oooool00ol0003oooooooooo`0Fooooo`04o`000?ooooooooooo`0001ko
oooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0looooo`0:onGVk_o/k_?ok>odonk_
m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooohcooooo0_l0000Pooooo`;o00006Oooool3
o`0001gooooo0_l0000Gooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool05oooool2
o`0000[ooooo0_l00002ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0>?ooool0
2_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_n
oo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_k
o_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBoooo
o`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_ok
nokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_oo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;o
oooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_n
oo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonB
ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_k
o_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooooooo
T_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOok
nokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooo
oi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooo
oonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[m
oo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooooo
ooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[j
oOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooC
ooooo`?o0000G?ooool3o`0005cooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOog
moWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVOS[ooooo0ol0003ooooooiOooooo00?o0000ooooooooool0G?ooool00ol0003ooooo
ooooo`1Kooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00So
n_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhkoooo
o`03o`000?oooooooooo0?ooooooU_ooool00ol0003oooooooooo`1Looooo`03o`000?oooooooooo
05_ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOROooooo0ol0
0004ooooo`?o00000_ooool7o`000003ooooool0003o000000;o00000oooool5o`0000;ooooo1Ol0
0003ooooo`Co00000oooool5o`0007_ooooo0ol00003ooooo`Go00000oooool2o`000003ooooool0
003o000000;ooooo1?l0002Hooooo`04o`000?ooooooooooo`0000?ooooo0ol000001?oooooo0000
o`000?ooool2o`0000?ooooo0_l000001Ooooooo0000o`000?l0003ooooo00;o000000?oooooo`00
0?l000000_ooool3o`0000Gooooo0_l00002ooooo`?o00001_ooool2o`0000?ooooo0ol00002oooo
o`?o000000Coooooo`000?l0003ooooo0_l000000ooooooo0000ooooo`02o`0000;ooooo1_l00000
0ooooooo0000o`000006ooooo`;o000000Goooooo`000?l0003o0000ooooo`02o`000003ooooool0
003o000000Gooooo0ol00003ooooo`Oo000000Coooooo`000?l0003ooooo0_l00003ooooo`;o0000
00Goooooo`000?l0003o0000ooooo`03o`0000;ooooo0ol000000ooooooo0000o`000004ooooo`;o
00000_ooool3o`0000Kooooo00Co0000ooooool0003o00000_ooool3o`000004ooooool0003o0000
o`0000?ooooo0_l0001<ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooSh
n`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWhVooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo0000
00;ooooo00Go0000ooooool0003oooooo`000002ooooo`05o`000?ooooooooooooooool000001?oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01?oo
ool01Ol0003ooooooooooooooooo000007gooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00;o00000_ooool00ol0003oooooooooo`2Jooooo`04o`00
0?ooooooooooo`0000Cooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`000?oooooo
ooooo`0000?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`000?ooooooooooo`00
00Kooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`06o`000?oooooo
ooooo`000?oooooo00000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo0_l00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooo`00
0002ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool01?l0003oooooooooool00003oooo
o`03o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00oooool2o`0000;ooooo00Ko
0000oooooooooooo0000ooooool00003ooooo`04o`000?ooooooooooo`0004gooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORKooooo00?o0000ooooooooool01?oo
ool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooool0003oooooo`000002ooooo`05
o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000007gooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`2Iooooo`06o`000?oooooo0000o`000?oooooo00000oooool01_l0003o
ooooooooool0003oooooo`0000Gooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oo
oooo000000Gooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00003ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooool000002?ooool01Ol0003ooooooooooooooooo000000;ooooo
00?o0000ooooool000002?ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooo`000005ooooo`07o`000?ooooooooooooooool0003oooooo`00
0003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0003ooooo
ooooool00003ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002oooo
o`03o`000?oooooo000000?ooooo00Co0000oooooooooooo0000COooool02_oUi^kok>kconc_m?o^
koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9_ooool00ol0003oooooooooo`04ooooo`05o`00
0?ooooooooooooooool000000_ooool01Ol0003oooooo`000?oooooo000000;ooooo00Go0000oooo
ooooooooooooo`000004ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool5
o`0000;ooooo00Go0000ooooooooooooooooo`00001mooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo1Ol0002Gooooo`06o`00
0?ooooooooooo`000?oooooo00000oooool01Ol0003oooooooooool0003ooooo00Co00000_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000000ol00002ooooo`03o`000?oo
oooooooo00Cooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00000oooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooo000000?o00001Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool00000
0ol00005ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002oooo
o`03o`000?oooooo000000Gooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000?o
oooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000oooo
ool000000oooool01?l0003oooooooooool0001=ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWhVooooo`03o`000?oooooooooo00Cooooo00Go0000oooooooooooo
ooooo`000002ooooo`05o`000?oooooo0000ooooool000000_ooool2o`0000;ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00Go0000oooo
ooooooooooooo`000002ooooo`03o`000?oooooooooo00;o0000OOooool00ol0003oooooooooo`03
ooooo`;o00001?ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooooooooooo
o`00002Gooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_l000001?oooooo
0000ooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo0_l000001?oooooo0000ooooool0
0002ooooo`03o`000?oooooooooo00;o00001Oooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo
00;o000000Goooooo`000?l0003oooooo`000002ooooo`;o00000_ooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool00oooool01?l0003ooooooooo
ooooool2o`000004ooooool0003oooooo`0000;ooooo00?o0000ooooooooool00oooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool00_l000001?oooooo0000ooooool00002
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool000000oooool00ol0003ooooooooo
o`02o`000003ooooool0003ooooo00Cooooo00Co0000oooooooooooo00000oooool00ol0003ooooo
ooooo`03ooooo`;o00000_ooool01_l0003oooooooooool0003oooooo`0000?ooooo00Co0000oooo
oooooooo0000COooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
9_ooool00ol0003oooooooooo`05ooooo`?o00000_ooool3o`000004ooooool0003oooooooooo`;o
000000?oooooo`000?l000000oooool3o`0000Kooooo00?o0000ooooooooool00oooool3o`0000Co
oooo0_l000000ooooooo0000ooooo`1looooo`03o`000?oooooooooo00;ooooo0_l000001?oooooo
0000o`000?ooool2o`0000;ooooo0_l00003ooooo`?o0000Uoooool2o`000005ooooool0003o0000
o`000?ooool00_l000001?oooooo0000ooooool00003ooooo`;o00000_ooool3o`0000;ooooo00?o
0000ooooool000000oooool2o`0000;ooooo0_l000000ooooooo0000ooooo`02ooooo`?o00000_oo
ool3o`0000Kooooo0ol00002ooooo`?o00000_ooool2o`000005ooooool0003oooooooooool00000
0_ooool2o`000003ooooool0003o000000;ooooo0_l00002ooooo`03o`000?oooooooooo00;o0000
1Oooool3o`0000;ooooo00?o0000ooooool000000oooool2o`0000Gooooo0ol000001?oooooo0000
o`000?ooool2o`000005ooooool0003o0000ooooool000000oooool3o`000005ooooool0003o0000
o`000?ooool00_l00002ooooo`?o00000_ooool2o`000003ooooool0003ooooo00Cooooo0ol00002
ooooo`?o00001Oooool2o`000003ooooool0003o000000?ooooo00?o0000ooooooooool00ol00002
ooooo`?o0000C?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
9_ooool01Ol0003ooooooooooooooooo0000023ooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`1hooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0/_ooool00ol0
003oooooooooo`08ooooo`05o`000?ooooooooooooooool000004Oooool00ol0003oooooooooo`0X
ooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0Aooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool0Boooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_oc
loOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVIn9oooool4o`0001Wooooo00?o0000ooooooooool00oooool2o`0000ko
oooo0_l0001jooooo`Oo0000]?ooool00ol0003oooooooooo`08ooooo`05o`000?oooooooooooooo
ool000004Oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Sooooo00Go0000oooo
ooooooooooooo`00000=ooooo`04o`000?ooooooooooo`00017ooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0Booo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooonAooooo`;o
00003Oooool2o`0003Wooooo00Co0000ooooool0003o00003Oooool2o`0000kooooo0ol0000Eoooo
o`03o`000?oooooooooo02;ooooo0_l0001Fooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?c
moodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_oc
loOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKo
lo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3a
m_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Go
l?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`
mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_
l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCo
ko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_
m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^
koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInUoooool3o`000>oooooo0ol0003oooooo`Gooooo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_k
o_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOYSooooo00?o0000oooo
ooooool0LOooool3o`00023ooooo00?o0000ooooooooool0E_ooool01Ol0003ooooooooooooooooo
00000?oooooo1?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWi
n`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
V?ooool00ol0003oooooooooo`1booooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0
EOooool01Ol0003ooooooooooooooooo00000?oooooo1?ooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVIn9Oooool3o`0000Cooooo1Ol00003ooooo`?o00001Oooool3
o`0000?ooooo0ol00002ooooo`Co00001_ooool3o`000004ooooool0003o0000ooooo`Oo00001_oo
ool2o`000005ooooool0003o0000o`000?ooool00_l000000ooooooo0000o`000005ooooo`?o0000
0oooool7o`000004ooooool0003o0000ooooo`;o000000?oooooo`000?l000001_ooool3o`0000?o
oooo00Co0000ooooool0003o00000oooool2o`000005ooooool0003o0000o`000?ooool00ol00002
ooooo`?o000000?oooooo`000?l000000ol00006ooooo`Oo00001_ooool01?l0003oooooo`000?l0
0004ooooo`;o000000Coooooo`000?l0003ooooo1Ol00002ooooo`Go00000oooool5o`0000;ooooo
0ol00004ooooo`Co00000oooool3o`0000?ooooo1Ol00003ooooo`Go000000?oooooo`000?l00000
0_l00002ooooo`?o000000Goooooo`000?l0003o0000ooooo`05o`0000?ooooo0ol00003ooooo`Co
00000_ooool2o`0000Kooooo00Co0000oooooooooooo00000oooool3o`000004ooooool0003o0000
ooooo`?o000000?oooooo`000?l000001?ooool2o`000005ooooool0003o0000o`000?ooool00_l0
00000ooooooo0000o`000005ooooo`?o00000_ooool3o`0000;ooooo1_l000001?oooooo0000o`00
0?l00004ooooo`04o`000?ooooooooooo`0000?ooooo1_l000001?oooooo0000o`000?ooool3o`00
00Gooooo1?l000000ooooooo0000o`000003o`000003ooooool0003o000000Ko000000Coooooo`00
0?l0003ooooo0ol000001?oooooo0000o`000?l00002ooooo`?o000000?oooooo`000?l000000ol0
0003ooooo`03o`000?oooooooooo0=3ooooo00?ok^gUong`l_n;S9X01OnMWZ`00onMWZ_oWIj/oifN
[003oifN[006oifO[?n=Si_ok^gUofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQco
oooo1Ol00005ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool01Ol0003o
oooooooooooooooo000000?ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`04ooooo`06o`000?ooooooooooo`000?oo
oooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00?ooooo00Go0000oooo
ooooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool00_ooool0
1_l0003oooooooooool0003oooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01_l0003o
ooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooo
oooo000000;ooooo0_l00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool00000
0oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000oooooooo
ool00_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool00oooool2
o`0000;ooooo00Co0000oooooooooooo00000_ooool2o`0000?ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000
ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
ooooo`02ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo0000
00Wooooo00Co0000oooooooooooo00001?ooool01?l0003oooooooooool00003ooooo`04o`000?oo
ooooooooo`0000Gooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000;o
oooo00?o0000ooooooooool00oooool01?l0003oooooooooool00003ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooool000000oooool01Ol0003ooooooooooooooooo000000;ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000Oooooo
00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooo000000?ooooo00Co0000oooo
oooooooo00000_ooool01ol0003ooooooooooooooooo0000ooooool000000oooool01?l0003ooooo
ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0doooool00oo^kNGo
U9FRomgNh@0<om3Ag`05omgNhOnDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIV
OQcooooo1Ol00005ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool01Ol0
003ooooooooooooooooo000000?ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool0
0003ooooo`03o`000?oooooooooo00?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04
o`000?ooooooooooooooo`;o00001Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000
ooooool000002Oooool2o`000005ooooool0003oooooooooool000000_ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooo000000Oooooo00Go0000ooooooooooooooooo`000002ooooo`05
o`000?ooooooooooooooool000000_ooool01ol0003ooooooooooooooooo0000ooooool000000ooo
ool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooooooo`;o00001?ooool01?l0003o
ooooooooool00003ooooo`;o00002Oooool01?l0003oooooooooool00003ooooo`05o`000?oooooo
ooooooooool000001_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool00000
0_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00Go0000oooooooooooo
ooooo`000003ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002oooo
o`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Kooooo00Ko
0000ooooool0003o0000ooooool00003ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooo
oooooooo00001Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000002?oo
ool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool0
00000oooool01Ol0003oooooooooool0003ooooo00;o000000?oooooo`000?ooool00_ooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00;o00001Oooool01_l0003oooooooooool0
003oooooo`0000?ooooo00?o0000ooooool000000oooool01?l0003oooooooooool00002ooooo`07
o`000?ooooooooooooooool0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooooooo0_l0003Eooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>h03?oRhn_o
fmcUom_LiOoDeN7oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWhLooooo`Go00001Oooool3o`0000Gooooo00?o0000ooooooooool00_ooool01Ol0003o
oooooooooooooooo000000?ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00003
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool3o`000003ooooool0
003o000000Oooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000?o0000
1?ooool2o`0000Cooooo0ol00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool0
00000ol00004ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooo`000?l00007ooooo`?o000000?oooooo`000?l000002oooool01?l0
003oooooooooool00003ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003ooooooooo
o`04ooooo`Co00000_ooool00ol0003oooooooooo`04ooooo`Go00000_ooool00ol0003ooooooooo
o`03o`0000;ooooo00?o0000ooooooooool01?ooool4o`0000;ooooo00Go0000oooooooooooooooo
o`000002ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00Gooooo0ol00009ooooo`06o`000?ooooooooooo`000?oooooo00000oooool0
1?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000Gooooo00Go0000oooooooooooo
ooooo`000002ooooo`03o`000?oooooo000000?o00001Oooool01?l0003oooooooooool00003oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000oooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
o`000002ooooo`03o`000?oooooooooo00?ooooo0ol000000ooooooo0000ooooo`02ooooo`03o`00
0?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01ol0003ooooooooooooooooo0000
ooooool000000oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo0000o`000=Oooooo
00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXkP0<on;RjooKfnKofm_VomCEhOo>cmgoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00005ooooo`04
o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo
000000?ooooo00?o0000ooooooooool01Oooool2o`0000?ooooo00Go0000ooooooooooooooooo`00
0005ooooo`;o000000Coooooo`000?oooooo00000_ooool00ol0003oooooo`000002ooooo`03o`00
0?oooooooooo00?ooooo00Co0000oooooooooooooooo0_l000001?oooooo0000ooooool00002oooo
o`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oo
oooooooo00;o000000Ooooooo`000?l0003oooooo`000?oooooo000000;ooooo00?o0000oooooooo
ool00_ooool01Ol0003ooooooooooooooooo000000;ooooo0_l00002ooooo`04o`000?oooooooooo
o`0000?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`02o`000004ooooool0003o
ooooo`0000;ooooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003oooooo`0000;o
oooo00?o0000ooooooooool01?ooool3o`0000?ooooo00Go0000ooooooooooooooooo`000003oooo
o`;o00001Oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`00
0?oooooooooo00Gooooo0_l00004ooooo`05o`000?ooooooooooooooool000000_ooool2o`0000;o
oooo00?o0000ooooooooool00_l00002ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000008
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooooooool2o`000003ooooool0003ooooo00Cooooo00Co0000oooooooooooooooo0_l000001?oo
oooo0000ooooool00002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000ooo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;o000000Coooooo`00
0?oooooo00000_ooool00ol0003oooooooooo`02ooooo`06o`000?ooooooooooo`000?oooooo0000
0_ooool2o`000004ooooool0003oooooooooo`;o00000_ooool01?l0003oooooooooool00003oooo
o`03o`000?oooooo000000?ooooo00?o0000ooooooooool00_l000001?oooooo0000ooooool00002
ooooo`03o`000?oooooooooo0=?ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?Sj_oK
fnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVOQcooooo1Ol00005ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool0
0oooool3o`0000?ooooo1Ol00006ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooo`000003ooooo`;o00000oooool3o`0000Cooooo0ol00002ooooo`03
o`000?oooooo000000?ooooo0_l00006ooooo`?o00000_ooool2o`0000;ooooo0_l000001Ooooooo
0000oooooooooooo000000?ooooo0_l00006ooooo`?o00000_ooool2o`000003ooooool0003o0000
00;ooooo0ol000000ooooooo0000o`000002ooooo`?o00000_ooool2o`000003ooooool0003ooooo
00;ooooo0ol00005ooooo`;o00000oooool3o`0000Gooooo00?o0000ooooooooool00oooool2o`00
00;ooooo0_l00002ooooo`;o000000?oooooo`000?l000000_ooool5o`0000?ooooo0ol00004oooo
o`Co00000oooool3o`0000?ooooo00?o0000ooooooooool01?ooool2o`000003ooooool0003o0000
00?ooooo0ol00002ooooo`;o000000?oooooo`000?l000000oooool01?l0003oooooo`000?l00003
ooooo`?o00001Oooool4o`0000?ooooo1?l00007ooooo`;o000000Goooooo`000?l0003o0000oooo
o`04o`000004ooooool0003o0000o`0000;ooooo00?o0000ooooool000001Oooool3o`0000;ooooo
00?o0000ooooool000000oooool2o`0000Gooooo0ol00002ooooo`?o00000oooool01?l0003ooooo
ooooool00002ooooo`?o00000_ooool2o`000005ooooool0003o0000o`000?ooool01?l000001Ooo
oooo0000o`000?oooooo000000?ooooo1?l00004ooooo`;o00000oooool2o`000004ooooool0003o
ooooooooo`;o000000?oooooo`000?ooool00_l000001Ooooooo0000o`000?l0003ooooo00;o0000
0_ooool3o`0000;ooooo0_l000000ooooooo0000ooooo`02ooooo`?o00000_ooool00ol0003ooooo
ooooo`3@ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloL
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhVooooo`04
o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03oooo
o`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00006ooooo`03o`000?oo
oooooooo013ooooo00Go0000ooooooooooooooooo`00000eooooo`03o`000?oooooooooo02Gooooo
00?o0000ooooooooool00_l0000Aooooo`03o`000?oooooooooo01Sooooo00Go0000oooooooooooo
ooooo`00000Gooooo`03o`000?oooooooooo02_ooooo00Go0000ooooooooooooooooo`000008oooo
o`05o`000?ooooooooooooooool000003Oooool00ol0003oooooooooo`07ooooo`04o`000?oooooo
ooooo`0002[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo0>Sooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?
cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORGooooo
1?l00004ooooo`;o00004oooool3o`0000;ooooo1?l00007ooooo`03o`000?oooooooooo013ooooo
00Go0000ooooooooooooooooo`00000eooooo`03o`000?oooooooooo02Kooooo0_l000000ooooooo
0000ooooo`0Aooooo`?o00006?ooool4o`0001Kooooo0_l00008ooooo`03o`000?oooooooooo02;o
oooo00Go0000ooooooooooooooooo`000008ooooo`05o`000?ooooooooooooooool000003Oooool0
1?l0003oooooooooool00006ooooo`04o`000?ooooooooooo`0002[ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0>Sooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_o
nocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOU7ooooo0_l0000Eooooo`;o0000>Oooool00ol0003o
ooooooooo`2Iooooo`03o`000?oooooooooo00?ooooo0_l0000;ooooo`;o00003_ooool3o`0000Go
oooo0_l000000ooooooo0000o`00000Aooooo`03o`000?oooooooooo01Gooooo0_l00004ooooo`;o
00000_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0>Cooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool01?o^kNGoU9FRooooooog
moT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool01?o^kNGoU9FRooooooogmoT2onc/
l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42
onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
jNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^
00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<
on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oR
h^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkoooooooooooooT_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Z
om_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInJoooool3o`0006_ooooo0_l0001Fooooo`?o0000S_ooool3o`0000Cooooo0ol00034
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWi/ooooo`03o`000?oo
oooooooo06cooooo00?o0000ooooooooool0E?ooool00ol0003oooooooooo`2>ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0`oooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^
00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInK?ooool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo05?ooooo
00?o0000ooooooooool0S_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0<?ooooo
00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORGooooo0ol00003ooooo`Oo
000000Coooooo`000?l0003ooooo0_l00003ooooo`;o000000Goooooo`000?l0003o0000ooooo`03
o`0000;ooooo0ol000000ooooooo0000o`000004ooooo`;o00000_ooool3o`0000Kooooo0ol00003
ooooo`;o00001_ooool01?l0003oooooo`000?l00002ooooo`?o000000Coooooo`000?l0003o0000
0oooool2o`0000;ooooo0_l00002ooooo`;o00000oooool5o`0000?ooooo1_l00005ooooo`;o0000
00Goooooo`000?l0003o0000ooooo`08o`0000Kooooo0_l00003ooooo`Oo000000?oooooo`000?l0
00000oooool3o`0000?ooooo1ol00002ooooo`;o00000_ooool3o`0000?ooooo00?o0000oooooooo
ool01Oooool3o`0000?ooooo0_l00006ooooo`Go000000Coooooo`000?l0003o00000_ooool3o`00
0004ooooool0003o0000ooooo`;o00001_ooool3o`0000?ooooo0_l00002ooooo`?o00000_ooool3
o`0000;ooooo0ol00002ooooo`;o00001Oooool3o`0000?ooooo00Co0000ooooool0003o00000ooo
ool2o`0000?ooooo0_l00002ooooo`Ko000000Goooooo`000?l0003o0000ooooo`02o`0000Gooooo
0ol000000ooooooo0000o`000002ooooo`Oo000000Coooooo`000?l0003ooooo0_l000000ooooooo
0000o`000002ooooo`?o000000Goooooo`000?l0003o0000ooooo`02o`0000?ooooo1ol00005oooo
o`03o`000?oooooooooo00;ooooo1ol00002ooooo`Co000000?oooooo`000?l000000_ooool3o`00
00Kooooo1ol00002ooooo`;o00001Oooool3o`0000Cooooo1?l000000ooooooo0000ooooo`02o`00
00?ooooo00Co0000ooooool0003o00000_ooool6o`000003ooooool0003o000000?ooooo1Ol00000
0ooooooo0000ooooo`2/ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_L
iOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWhVooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002ooooo`03
o`000?oooooo000000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooo`000003oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0
0003ooooo`03o`000?oooooooooo00;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000;o
oooo00?o0000ooooooooool00oooool2o`0000;ooooo00Ko0000oooooooooooo0000ooooool00003
ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
o`000003ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00001_ooool01Ol0003o
oooooooooooooooo000000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oo
oooooooo00;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`07o`000?oooooooooooooo
ool0003oooooo`000005ooooo`07o`000?ooooooooooooooool0003oooooo`000002ooooo`03o`00
0?oooooooooo00;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Oo0000
ooooooooooooooooo`000?oooooo000000;ooooo00Co0000oooooooooooo00000_ooool01Ol0003o
oooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooo`0000;ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00?o
0000ooooool000000_ooool01?l0003oooooooooool00002ooooo`07o`000?ooooooooooooooool0
003oooooo`000002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool00000
0_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool0
00000_ooool01?l0003oooooooooool00006ooooo`05o`000?ooooooooooooooool000000_ooool0
1?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003o
ooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_oo
ool01?l0003oooooooooool00002ooooo`;o00000_ooool00ol0003oooooooooo`02o`0000;ooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000?o
oooo00?o0000ooooooooool0[_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_L
iOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVIn9_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_oo
ool00ol0003oooooo`000005ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00003
ooooo`03o`000?oooooooooo00;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000Sooooo
00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooo
oooo00000oooool01?l0003oooooooooool00004ooooo`05o`000?ooooooooooooooool000001Ooo
ool01?l0003oooooooooool00006ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003o
ooooooooool00003ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00001_ooool2o`000005ooooool0003oooooooooool00000
0_ooool01?l0003oooooooooool00005ooooo`07o`000?ooooooooooooooool0003oooooo`000005
ooooo`07o`000?ooooooooooooooool0003oooooo`000007ooooo`07o`000?ooooooooooooooool0
003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000001oooool0
1ol0003ooooooooooooooooo0000ooooool000001Oooool01?l0003oooooooooool00003ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01oooool2o`0000;ooooo00Oo0000oooo
ooooooooooooo`000?oooooo000000Cooooo00?o0000ooooooooool00oooool01?l0003ooooooooo
ool00003ooooo`03o`000?oooooo000000Sooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000001Oooool0
1ol0003ooooooooooooooooo0000ooooool000001?ooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooool000000_ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000001_ooool2o`0000Cooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooool00009ooooo`;o00000_ooool01?l0003ooooo
ooooool00002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo
000000;ooooo00Ko0000oooooooooooo0000ooooool00004ooooo`05o`000?ooooooooooooooool0
0000/?ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9_ooool01Ol0
003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`00
0005ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00003ooooo`03o`000?oooooo
oooo00;ooooo00Ko0000ooooooooooooooooo`000?ooool4o`0000Gooooo00Go0000oooooooooooo
ooooo`000002ooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo00000oooool00ol0
003oooooooooo`04o`000003ooooool0003ooooo00;ooooo00?o0000ooooooooool00oooool01?l0
003oooooooooool00006ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooo
ool0003ooooo00;o00001_ooool00ol0003oooooooooo`03ooooo`?o00000_ooool01?l0003ooooo
ooooool00004ooooo`;o00001?ooool3o`0000;ooooo00?o0000ooooooooool01?l00002ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01_l0003ooooooooooooooooo
0000ooooo`Co00001?ooool01ol0003ooooooooooooooooo0000ooooool000000oooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooo000000?o00001?ooool01_l0003ooooooooooooooooo
0000ooooo`Co00000_ooool01?l0003oooooooooool00003ooooo`04o`000?ooooooooooo`0000;o
oooo1?l00004ooooo`;o00001?ooool01_l0003ooooooooooooooooo0000ooooo`Co000000?ooooo
o`000?ooool01?ooool01?l0003oooooooooool00003ooooo`03o`000?oooooo000000Sooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooool000000ol00002ooooo`07o`000?ooooooooooooooool0003oooooo`00
0005ooooo`?o00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000?ooooo0ol0
0002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000ol000000ooooooo0000
o`000007ooooo`?o00000_ooool00ol0003oooooooooo`04o`0000Cooooo0_l00004ooooo`04o`00
0?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooooooo
ooooool000000_ooool01Ol0003oooooooooool0003ooooo00Co000000?oooooo`000?ooool00_oo
ool00ol0003oooooooooo`2^ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcU
om_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWhVooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`02o`000004
ooooool0003oooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooo`000003
ooooo`03o`000?oooooooooo00;o000000?oooooo`000?ooool01?ooool01?l0003oooooooooool0
0003ooooo`03o`000?oooooooooo00;ooooo0_l00002ooooo`03o`000?oooooo000000;ooooo00?o
0000ooooooooool00oooool2o`0000;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`04
o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002
ooooo`;o00001Oooool01?l0003oooooooooool00006ooooo`04o`000?ooooooooooooooo`;o0000
00Ooooooo`000?ooooooooooo`000?oooooo000000;ooooo00?o0000ooooooooool00_ooool01_l0
003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_l000000ooooooo0000oooo
o`03ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003ooooooooo
o`02ooooo`;o00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool00_l000000ooooooo0000ooooo`02ooooo`03o`000?oooooooooo00;o000000Co
ooooo`000?oooooo00000_ooool00ol0003oooooooooo`02ooooo`;o00000_ooool00ol0003ooooo
o`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002oooo
o`;o000000Goooooo`000?ooooooooooo`000004ooooo`04o`000?ooooooooooo`0000;ooooo0_l0
0002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool01?l0003ooooooooo
ool00002ooooo`07o`000?ooooooooooooooool0003oooooo`000002ooooo`03o`000?oooooooooo
00?ooooo0_l000001Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooooooool00_l00000
1ooooooo0000o`000?oooooo0000ooooool000000_ooool00ol0003oooooooooo`02o`0000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000Co
oooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo00Co0000oooooooooooo00000_oo
ool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo0_l000001Ooooooo0000oooooooooooo
000000Cooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`;o0000
0_ooool00ol0003oooooooooo`02o`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooo`000002ooooo`03o`000?oooooo000000;ooooo0_l0002`ooooo`04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWhUooooo`?o000000Coooooo`000?l0003ooooo0_l00000
1Ooooooo0000o`000?oooooo000000?ooooo0ol000001Ooooooo0000o`000?l0003ooooo00;o0000
0_ooool3o`0000;ooooo0_l000000ooooooo0000ooooo`04ooooo`?o00000_ooool3o`0000Gooooo
00Co0000ooooool0003o00000oooool2o`0000Gooooo0_l000000ooooooo0000o`000003ooooo`03
o`000?oooooooooo00?o00000_ooool3o`000004ooooool0003o0000o`0000;ooooo0_l00003oooo
o`;o000000?oooooo`000?ooool00oooool2o`000004ooooool0003o0000o`0000Cooooo0ol00002
ooooo`03o`000?oooooo000000;ooooo0_l00002ooooo`?o00001Oooool3o`0000;ooooo0_l00002
ooooo`;o000000?oooooo`000?ooool01Oooool3o`0000;ooooo0_l00002ooooo`?o00000_ooool2
o`0000?ooooo00?o0000ooooool000000_l000001?oooooo0000o`000?l00003ooooo`04o`000?oo
oooo0000o`0000?ooooo0_l00006ooooo`;o000000Coooooo`000?oooooooooo0ol00002ooooo`;o
000000?oooooo`000?ooool00_ooool2o`0000Gooooo00Co0000ooooool0003o00000oooool2o`00
00;ooooo0ol00002ooooo`?o00000_ooool2o`000003ooooool0003ooooo00;o00001_ooool3o`00
0004ooooool0003o0000ooooo`;o00000oooool2o`0000?ooooo0ol000001?oooooo0000o`000?oo
ool3o`000003ooooool0003o000000;ooooo0ol00004ooooo`;o000000Coooooo`000?oooooooooo
0_l000001?oooooo0000o`000?ooool2o`000005ooooool0003oooooooooool000000oooool2o`00
00;ooooo0_l000001?oooooo0000o`000?l00002ooooo`?o00000_ooool2o`0000?ooooo00Co0000
oooooooooooooooo0ol00002ooooo`;o000000?oooooo`000?l000000oooool01Ol0003oooooo`00
0?l0003ooooo00;o00000_ooool2o`0000?ooooo0ol00005ooooo`;o00000_ooool2o`000003oooo
ool0003ooooo00;o00001_ooool3o`000004ooooool0003o0000ooooo`;o000000Coooooo`000?l0
003ooooo0_l00002ooooo`;o000000?oooooo`000?l000000oooool01?l0003oooooo`000?l00002
ooooo`;o00000oooool2o`000003ooooool0003ooooo0:oooooo00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVORKooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Cooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool04oooool00ol0003ooooooooo
o`06ooooo`05o`000?ooooooooooooooool000002oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00000]ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01?o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0/ooooo`03o`000?oooooooooo03Oo
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool0[_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_L
iOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVIn9_ooool01?l0003oooooooooool0000Aooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Kooooo00Go0000
ooooooooooooooooo`00000;ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo0000
0oooool01Ol0003ooooooooooooooooo000002gooooo00Co0000oooooooooooo00001Oooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool04oooool00ol0
003oooooooooo`09ooooo`04o`000?ooooooooooo`0002_ooooo00Co0000oooooooooooo0000=_oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`2^ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcU
om_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWhWooooo`?o00005Oooool00ol0003oooooooooo`0Jooooo`;o00005?ooool2o`0001Oooooo
0_l00005ooooo`04o`000?ooooooooooooooo`?o00001_ooool2o`0000Gooooo00?o0000oooooooo
ool09_ooool3o`0000Cooooo0_l0000:ooooo`;o00004?ooool2o`0001Cooooo0_l0000<ooooo`?o
0000:?ooool01?l0003oooooooooooooool4o`0002Sooooo00?o0000ooooooooool02Oooool2o`00
00oooooo0_l0000nooooo`;o00000_ooool00ol0003oooooooooo`07ooooo`;o0000/?ooool01?o^
kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonD
UJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00Cok^gU
oiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FR
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWjIooooo`?o0000Roooool2o`000?ooooooJ?ooool0
1?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooo
oonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInV?ooool01Ol0003ooooooooo
oooooooo000008cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0goooooa_oADjI
00?o0000ooooooooool0ooooool6ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[o
fmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWjHooooo`05o`000?ooooooooooooooool00000SOooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo05Cooooo00?o0000ooooooooool0ooooool5ooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhUooooo`?o00001?ooool5o`0000?ooooo0ol00005
ooooo`?o00000oooool3o`0000;ooooo1?l00007ooooo`;o00001?ooool00ol0003oooooooooo`02
ooooo`Oo00000_ooool4o`000003ooooool0003o000000;o000000?oooooo`000?l000000_ooool2
o`0000;ooooo0ol00005ooooo`?o000000Coooooo`000?l0003ooooo0ol00006ooooo`Oo00000_oo
ool3o`0000?ooooo1ol000001?oooooo0000o`000?ooool2o`000003ooooool0003o000000;ooooo
0ol000001?oooooo0000o`000?ooool2o`000004ooooool0003o0000o`0000Gooooo1_l000000ooo
oooo0000o`000004ooooo`Co00000oooool3o`000004ooooool0003o0000ooooo`?o00000_ooool3
o`000003ooooool0003o000000Cooooo0ol00003ooooo`;o00000_ooool7o`000004ooooool0003o
0000ooooo`Go000000?oooooo`000?l000001Ol00002ooooo`Go00001Oooool01?l0003ooooooooo
ool00004ooooo`Co00000oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?o0000
0oooool2o`0000?ooooo0_l00005ooooo`Co00000oooool2o`0000?ooooo0_l00003ooooo`;o0000
00Goooooo`000?l0003o0000ooooo`03o`0000;ooooo0ol000000ooooooo0000o`000003ooooo`?o
ADjI0_ooool3odE>V@;ooooo00?oADjIooooooooool00oooool01Om5CYWooooooooooom5CYWooooo
00GoADjI0_ooool01Ol0003ooooooooooooooooo000000Kooooo0ol00004ooooo`?o00001?ooool4
o`0000?ooooo0ol00002ooooo`?o000000Coooooo`000?l0003ooooo0ol00004ooooo`Oo000000?o
ooooo`000?l000000ol00005ooooo`Oo00000oooool2o`0000Gooooo1_l00004ooooo`03o`000?oo
oooooooo00?ooooo1Ol000000ooooooo0000o`000003o`0000?ooooo0_l000000ooooooo0000o`00
0002ooooo`Go00000oooool3o`0000?ooooo1?l00005ooooo`;o00000_ooool3o`0000Kooooo0_l0
0004ooooo`03o`000?oooooooooo00;ooooo1ol00002ooooo`Co000000?oooooo`000?l000000_l0
00000ooooooo0000o`000002ooooo`;o00001_ooool2o`000005ooooool0003o0000o`000?ooool0
0_l000000ooooooo0000o`00000booooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oSh^[o
fmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWhLooooo`Go00001Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;o
oooo00Go0000ooooooooooooooooo`000003ooooo`07o`000?ooooooooooooooool0003oooooo`00
0003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0003ooooo
ooooool00003ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002
ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01?l0003oooooooooool00002ooooo`06
o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`03ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00001?ooool01?l0003oooooooooool00002ooooo`04
o`000?ooooooooooo`0000Gooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Gooooo00Ko0000oooooooooooo0000
ooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooooooo
00000_ooool01Ol0003ooooooooooooooooo000000Kooooo00Co0000oooooooooooo00000oooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooo000000Gooooo00Go0000oooooooooooooooo
o`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003ooooo
ooooo`02ooooo`07o`000?ooooooooooooooool0003oooooo`000002ooooo`03o`000?oooooo0000
00;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooo`000003ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooooooool00oooool00om5CYWoooooooooo`02ooooo`03odE>VOoo
oooooooo00Oooooo00?oADjIooooooooool00oooool01?m5CYWooooooooooom5CYT3ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Co0000oooooooooooo00001?ooool01?l0003oooooooooool00002ooooo`06o`000?oooooo
ooooo`000?oooooo00000oooool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`00
0?oooooo00000oooool00ol0003oooooooooo`03ooooo`06o`000?ooooooooooo`000?oooooo0000
0_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooo
ooooo`000003ooooo`03o`000?oooooo000000?ooooo00Go0000ooooooooooooooooo`000004oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_l00002ooooo`05o`000?oooooooooo
ooooool000000oooool01ol0003ooooooooooooooooo0000ooooool000002Oooool01?l0003ooooo
ooooool00003ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000oooool01Ol0
003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01_l0003ooooooooo
ool0003oooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005
ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oo
oooooooo02oooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>
cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo
1Ol00005ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool01Ol0003ooooo
oooooooooooo000000?ooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00003oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooo`000002oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`00
0002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool2o`0000Gooooo
00Co0000oooooooooooo00001?ooool2o`0000Cooooo00Co0000oooooooooooo00000_ooool01?l0
003oooooooooooooool2o`0000?ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooo000000Gooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`02ooooo`;o00001Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
00;ooooo00Co0000oooooooooooo00001Oooool01_l0003oooooooooool0003oooooo`0000?ooooo
00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002o`0000?ooooo0_l00002ooooo`04
o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000003
ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooo
oooooooo000000Gooooo00Ko0000ooooool0003o0000ooooool00002ooooo`04o`000?oooooooooo
o`0000?ooooo00?o0000ooooool000001Oooool00ol0003oooooooooo`03ooooo`;o000000?ooooo
o`000?ooool00oooool00ol0003oooooooooo`09ooooo`03o`000?oooooo000000Cooooo00?o0000
ooooooooool00oooool01ol0003ooooooooooooooooo0000ooooool000000oooool01?l0003ooooo
ooooool00002ooooo`03o`000?oooooooooo00?ooooo00?oADjIooooooooool00_ooool00om5CYWo
ooooooooo`03ooooo`KoADjI1Oooool00om5CYWoooooooooo`03ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooo
oooooooo00001_ooool2o`0000;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`04o`00
0?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooo
oooo00?ooooo00Co0000oooooooooooo00000oooool2o`000003ooooool0003ooooo00Oooooo00?o
0000ooooooooool01Oooool00ol0003oooooo`000003ooooo`05o`000?ooooooooooooooool00000
1?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003o
oooooooooooooooo000000?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07oooo
o`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`06ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooo`00000doooo
o`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]co
oooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhLooooo`Go00001Oooool3
o`0000Gooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o
0000ooooooooool01oooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00;ooooo
1?l00002ooooo`03o`000?oooooo000000?ooooo0ol00002ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool00ol00002ooooo`03o`000?oooooooooo00Co000000?oooooo`000?l0
00001oooool01?l0003oooooooooool00002ooooo`;o00001oooool3o`0000;ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo
00Go0000oooooooooooo0000ooooo`04o`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`02o`0000Oooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03
ooooo`?o00001Oooool01_l0003oooooooooool0003oooooo`0000?ooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`03ooooo`;o00001?ooool01?l0003oooooooooooooool3o`00
00;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00?o00000_oo
ool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00Ko0000oooooooooooo
0000ooooool00003ooooo`?o00000_ooool01?l0003oooooooooool00005ooooo`04o`000?oooooo
ooooooooo`;o00000oooool4o`000003ooooool0003o000000;o00002?ooool00ol0003oooooo`00
0003o`000003ooooool0003ooooo00Cooooo00Oo0000ooooooooooooooooo`000?oooooo000000?o
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`04ooooo`CoADjI1_ooool01Om5
CYWoooooooooooooooooADjI00Oooooo00?oADjIooooooooool00_ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000Cooooo0_l00004ooooo`06o`000?ooooooooooo`000?oooooo00000oooool01?l0
003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003ooooo
ooooo`03ooooo`05o`000?ooooooooooo`000?ooool00_l00003ooooo`Co00001Oooool00ol0003o
ooooo`000004ooooo`05o`000?ooooooooooooooool000000oooool4o`0000Cooooo00?o0000oooo
ooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo1?l00003ooooo`03o`000?oooooo
oooo00?ooooo1Ol00005ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_oo
ool4o`0000;ooooo00?o0000ooooool000000oooool3o`0000;ooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`03o`0000;ooooo00?o0000ooooooooool01?l00005ooooo`05o`00
0?ooooooooooooooool000000_ooool00ol0003oooooo`000003o`00037ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00005ooooo`04o`000?oooooooooo
o`0000Cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o
0000ooooooooool01Oooool2o`0000?ooooo00Go0000ooooooooooooooooo`000004ooooo`06o`00
0?ooooooooooo`000?oooooo00000oooool00ol0003oooooo`000002ooooo`04o`000?oooooooooo
o`0000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`000?ooooooooooo`0000;o
oooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00?ooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooool00004ooooo`04o`000?ooooooooooo`0000;o
oooo0_l000001Ooooooo0000oooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool2
o`000007ooooool0003o0000ooooool0003oooooo`000002ooooo`03o`000?oooooooooo00;o0000
00Goooooo`000?ooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooo
ooooool00_l000000ooooooo0000ooooo`03ooooo`04o`000?ooooooooooo`0000Gooooo0_l00000
1?oooooo0000ooooool00003ooooo`03o`000?oooooooooo00;o000000?oooooo`000?ooool01?oo
ool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool00_l000001?oooooo0000ooooool00002ooooo`;o000000Goooooo`000?ooooooooooo`000002
ooooo`;o000000Coooooo`000?oooooooooo0_l00005ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooool000000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00;o
oooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000oooo
ool000000_ooool00ol0003oooooooooo`04ooooo`;o00000_ooool01_l0003oooooooooool0003o
ooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooo`000003ooooo`03o`00
0?oooooooooo00;o000000?oooooo`000?ooool01Oooool01?m5CYWooooooooooom5CYT7ooooo`04
odE>VOooooooooooodE>V@Sooooo00GoADjIooooooooooooooooo`000009ooooo`03o`000?oooooo
000000?ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Cooooo
00Co0000oooooooooooo00000_ooool2o`000004ooooool0003oooooo`0000?ooooo00Co0000oooo
oooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo0_l00005ooooo`06o`00
0?ooooooooooo`000?oooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo
00?ooooo0ol00004ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo
00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooo
ooooooooo`000005ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool0
1_l0003oooooooooool0003oooooo`0000?ooooo00?o0000ooooool000000_ooool01?l0003ooooo
ooooool00002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000Gooooo00Co0000oooooooooooooooo0_l000001?oooooo
0000ooooool00002ooooo`03o`000?oooooooooo02oooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42
onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00005ooooo`04o`000?ooooooooooo`0000Cooooo00?o
0000ooooooooool00oooool3o`0000?ooooo1Ol00006ooooo`04o`000?ooooooooooo`0000?ooooo
00?o0000ooooooooool00oooool2o`000004ooooool0003o0000o`0000;ooooo0_l000000ooooooo
0000o`000003ooooo`05o`000?oooooo0000o`000?ooool00_l00002ooooo`;o00000_ooool3o`00
00;ooooo0_l00003ooooo`?o00001?ooool2o`000004ooooool0003o0000o`0000;ooooo0ol00005
ooooo`;o00000_ooool2o`000003ooooool0003ooooo00Ko000000Coooooo`000?l0003ooooo0_l0
00001Ooooooo0000oooooooooooo000000?ooooo0_l00002ooooo`;o000000Coooooo`000?oooooo
oooo0ol00002ooooo`?o00001?ooool2o`000005ooooool0003o0000ooooool000001_ooool2o`00
00Gooooo0_l000000ooooooo0000ooooo`02ooooo`?o00000_ooool2o`000003ooooool0003ooooo
00Kooooo0ol000001?oooooo0000o`000?l00002ooooo`;o00000_ooool2o`000003ooooool0003o
oooo00;ooooo0_l000001?oooooo0000ooooooooool2o`0000;ooooo0_l000000ooooooo0000oooo
o`02o`000003ooooool0003ooooo00?ooooo0_l000001Ooooooo0000o`000?l0003ooooo00;o0000
00?oooooo`000?l000000_ooool3o`000004ooooool0003o0000o`0000?ooooo00?o0000oooooooo
ool00_ooool3o`0000;ooooo0_l00003ooooo`;o00001_ooool00ol0003oooooooooo`03ooooo`;o
00000oooool3o`000005ooooool0003o0000o`000?ooool00_l00002ooooo`?o00000_ooool2o`00
0003ooooool0003ooooo00Kooooo00?oADjIoooooom5CYT02Oooool00om5CYWoooooodE>V@08oooo
o`05odE>VOooooooooooooooool000002Oooool00ol0003oooooo`000004ooooo`?o00000_ooool2
o`000003ooooool0003o000000Gooooo0ol00002ooooo`03o`000?oooooo000000?ooooo0ol00002
ooooo`;o000000?oooooo`000?l000000_ooool00ol0003oooooooooo`02o`000003ooooool0003o
oooo00?ooooo0_l000000ooooooo0000o`000002ooooo`?o00000_ooool2o`0000Kooooo00?o0000
ooooool000000oooool3o`000004ooooool0003o0000o`0000;ooooo0ol00005ooooo`04o`000?oo
ooooooooooooo`;o00000_ooool2o`0000?ooooo0ol00003ooooo`Go00000oooool3o`0000Gooooo
0ol00002ooooo`?o00001_ooool2o`000004ooooool0003o0000o`0000;ooooo0_l000000ooooooo
0000o`000003ooooo`05o`000?oooooo0000o`000?ooool00_l00002ooooo`;o00000_ooool3o`00
00;ooooo0_l00005ooooo`?o00000_ooool00ol0003oooooo`000003ooooo`;o0000<_ooool01?o^
kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonD
UJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9_ooool01?l0003oooooooooool0
0004ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo00005_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0hooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Kooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Dooooo`03
odE>VOooooooADjI00Wooooo00?oADjIoooooom5CYT02?ooool01?m5CYWoooooooooool0000:oooo
o`04o`000?ooooooooooo`0001Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo01Kooooo00Go0000ooooooooooooooooo`00000Booooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Jooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool02Oooool01Ol0003ooooooooooooooooo000003Wooooo
00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORGooooo1?l00004ooooo`;o
00004oooool3o`0000;ooooo1?l0000Gooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo03Sooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01_ooooo00?o0000oooooooo
ool04_ooool01Ol0003ooooooooooooooooo000000cooooo00?o0000ooooooooool05Oooool00om5
CYWoooooooooo`09ooooo`;oADjI1?ooool01Om5CYWoooooooooooooooooADjI00;ooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Cooooo00?o0000
ooooooooool03oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Gooooo1_l0000A
ooooo`;o00008oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02Oooool01Ol0003ooooooooooooooooo000003Wooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVOV7ooooo0_l0000Nooooo`03o`000?oooooooooo043ooooo
00?o0000ooooooooool0?Oooool2o`0000gooooo0_l0000Nooooo`03o`000?oooooooooo01;ooooo
1?l0000@ooooo`03o`000?oooooooooo017ooooo00?oADjIooooooooool02_ooool00om5CYWooooo
ooooo`03ooooo`?oADjI0_ooool00ol0003oooooooooo`07ooooo`?o00000_ooool3o`0001Cooooo
0_l0000@ooooo`;o00001?ooool2o`0006oooooo0_l0000Looooo`;o0000>Oooool01?o^kNGoU9FR
ooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool01?o^kNGoU9FRooooooog
moT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00Cok^gUoiBEX_oooooomoOi
0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool01?o^kNGoU9FRooooooogmoT2onc/
l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42
onSXk`0<on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
j>l03?oRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_
00coh^;Zom_KiOoKfnGoe=GPolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<
on;Rj_oKfnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oooooooooooonBooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oR
h^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkoooooooooooooT_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_00coh^;Z
om_KiOoKfnGoe=GPolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoono/HgooknaSI;o_k6=00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oK
fnGofm_UomCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oom^gFooofkMJBooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_U
om_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooK]e_oom^gFT_ofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_00coh^;Zom_KiOoK
fnGoe=GPolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInooofkMKoooK]eY;om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXk`0<on;Rj_oKfnGofm_U
omCEh?o>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
O_oom^gFooofkMJBooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_Uom_KiOoD
eN3oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWko
ooK]e_oom^gFT_ofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>S_00coh^;Zom_KiOoKfnGoe=GP
olk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooof
kMKoooK]eY;om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on?RjooKfnKofm_VomCEh?o>
cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oom^gF
ooofkMJBooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oSh^_ofm_Vom_Ki_oDeN3oc/oL
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooK]e_oo
m^gFT_ofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00cohn;[om_Ki_oKfnKoe=GPolk?g?o<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooofkMKoooK]
eY;om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on?RjooKfnKofm_VomCEh?o>cmcoc<gK
olg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOU[om^gF0ol0000/
ooK]eP;o00001OofkMH2o`00053om^gF0ol0000DooK]eP?o0000;?ofkMH2o`000?oom^gFIoofkMH0
1?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00cohn;[om_Ki_oKfnKoe=GPolk?g?o<cM_ocLkLoooo
oonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInFoofkMH00ol0003om^gFooK]
eP0]ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_l000000oofkMH00ol0003om^gFooK]
eP18ooK]eP05o`000?ofkMKom^gFooK]e_l000005?ofkMH00ol0003om^gFooK]eP0]ooK]eP03o`00
0?ofkMKom^gF0?oom^gFI?ofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00cohn;[om_Ki_oK
fnKoe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVInFoofkMH00ol0003om^gFooK]eP0^ooK]eP03o`000?ofkMKom^gF00Com^gF00Go0000ooK]e_of
kMKom^gFo`000019ooK]eP05o`000?ofkMKom^gFooK]e_l000005?ofkMH00ol0003om^gFooK]eP0^
ooK]eP03o`000?ofkMKom^gF0?oom^gFHoofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00co
hn;[om_Ki_oKfnKoe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVIn9OofkMH3o`0000Com^gF1ol000001?ofkMKo0000o`000?l00002ooK]ePCo0000
00?om^gFo`000?l000000oofkMH2o`0000Gom^gF1_l00005ooK]eP?o00000oofkMH01?l0003om^gF
o`000?l00003ooK]eP;o00000oofkMH2o`0000;om^gF1_l000001OofkMKo0000o`000?l0003om^gF
00;o00000oofkMH5o`0000Com^gF0ol00005ooK]eP03o`000?ofkMKom^gF00Com^gF00?o0000ooK]
e_ofkMH00_l00005ooK]ePOo000000Com^gFo`000?l0003om^gF1Ol00004ooK]eP;o000000Gom^gF
o`000?l0003o0000ooK]eP02o`000003ooK]e_l0003o000000Gom^gF0ol00002ooK]eP?o000000Co
m^gFo`000?l0003om^gF1?l000000oofkMKo0000o`000009o`000004ooK]e_l0003o0000ooK]eP?o
00001?ofkMH6o`0000Gom^gF0ol00003ooK]eP04o`000?ofkMKo0000o`0000?om^gF0_l00003ooK]
eP;o00000_ofkMH6o`000005ooK]e_l0003o0000o`000?ofkMH00_l00003ooK]ePGo00001?ofkMH3
o`0000Gom^gF00?o0000ooK]e_ofkMH01?ofkMH3o`0000?om^gF00?o0000ooK]e_ofkMH0ooofkMIF
ooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oSh^_ofm_Vom_Ki_oDeN3oc/oLolc=foo=
c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhUooK]eP04o`000?of
kMKom^gFo`0000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH01Ol0003om^gFooK]e_ofkMKo0000
00;om^gF00Ko0000ooK]e_ofkMKo0000ooK]e_l00002ooK]eP03o`000?ofkMKo000000;om^gF00?o
0000ooK]e_ofkMH00oofkMH00ol0003om^gFo`000002ooK]eP03o`000?ofkMKom^gF00;om^gF00Co
0000ooK]e_ofkMKo00000_ofkMH2o`0000;om^gF00?o0000ooK]e_l000000_ofkMH00ol0003om^gF
o`000002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Oo0000ooK]e_ofkMKom^gFo`000?ofkMKo
000000;om^gF00?o0000ooK]e_l000000oofkMH00ol0003om^gFooK]eP02ooK]eP05o`000?ofkMKo
m^gFooK]e_l000000oofkMH00ol0003om^gFo`000005ooK]eP03o`000?ofkMKom^gF00Kom^gF00Co
0000ooK]e_ofkMKo00000_ofkMH01_l0003om^gFooK]e_l0003om^gFo`0000?om^gF00?o0000ooK]
e_ofkMH00oofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00?o0000ooK]e_l000000_ofkMH0
0ol0003om^gFooK]eP02ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Ko0000ooK]e_ofkMKo0000
ooK]e_l00002ooK]eP03o`000?ofkMKo000000?om^gF00Co0000ooK]e_ofkMKo00000_ofkMH01_l0
003om^gFooK]e_l0003om^gFo`0000Som^gF00?o0000ooK]e_l000000_ofkMH00ol0003om^gFooK]
eP02ooK]eP04o`000?ofkMKom^gFo`0000;om^gF0_l00002ooK]eP03o`000?ofkMKo000000;om^gF
00?o0000ooK]e_l000000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP07o`000?ofkMKom^gFooK]
e_l0003om^gFo`000002ooK]eP03o`000?ofkMKo000000?om^gF00?o0000ooK]e_ofkMH00_ofkMH0
1Ol0003om^gFooK]e_ofkMKo000000?om^gF00?o0000ooK]e_l000001OofkMH01?l0003om^gFooK]
e_l0003oooK]eU_om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on?RjooKfnKofm_VomCE
h?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOROo
m^gF0_l00002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Go0000ooK]e_ofkMKom^gFo`000002
ooK]eP06o`000?ofkMKom^gFo`000?ofkMKo00001?ofkMH00ol0003om^gFooK]eP06ooK]eP04o`00
0?ofkMKom^gFooK]eP;o00001_ofkMH2o`0000;om^gF00Oo0000ooK]e_ofkMKom^gFo`000?ofkMKo
000000Com^gF00?o0000ooK]e_ofkMH00oofkMH01?l0003om^gFooK]e_l00003ooK]eP03o`000?of
kMKo000000Com^gF00Go0000ooK]e_ofkMKom^gFo`000004ooK]eP05o`000?ofkMKom^gFooK]e_l0
00000oofkMH00ol0003om^gFo`000006ooK]eP03o`000?ofkMKom^gF00Gom^gF00Co0000ooK]e_of
kMKo00000_ofkMH01_l0003om^gFooK]e_l0003om^gFo`0000?om^gF00?o0000ooK]e_ofkMH00oof
kMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00?o0000ooK]e_l000002OofkMH2o`0000;om^gF
00Ko0000ooK]e_ofkMKo0000ooK]e_l00002ooK]eP03o`000?ofkMKo000000?om^gF00Co0000ooK]
e_ofkMKo00000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP;o00001_ofkMH01?l0003om^gFooK]
e_ofkMH2o`0000Kom^gF0_l00002ooK]eP07o`000?ofkMKom^gFooK]e_l0003om^gFo`000004ooK]
eP03o`000?ofkMKom^gF00?om^gF00Co0000ooK]e_ofkMKo00000oofkMH00ol0003om^gFo`000004
ooK]eP05o`000?ofkMKom^gFooK]e_l000001?ofkMH01Ol0003om^gFooK]e_ofkMKo000000?om^gF
00?o0000ooK]e_l000002?ofkMH00ol0003om^gFooK]eP3oooK]eUWom^gF00Cok^gUoiBEX_oooooo
moOi0_o/k?46ohjEXP08olk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVIn9OofkMH2o`0000Com^gF00Co0000ooK]e_ofkMKo00000_ofkMH01Ol0003om^gF
ooK]e_ofkMKo000000?om^gF0ol000000oofkMKo0000ooK]eP03ooK]ePCo00001OofkMH01?l0003o
m^gFo`000?l00006ooK]eP;o00001?ofkMH01_l0003om^gFooK]e_ofkMKo0000ooK]ePCo000000?o
m^gFo`000?ofkMH01?ofkMH01?l0003om^gFooK]e_l00003ooK]eP03o`000?ofkMKo000000?o0000
00?om^gFo`000?ofkMH00_ofkMH00ol0003om^gFooK]eP02ooK]eP05o`000?ofkMKom^gFooK]e_l0
00000_ofkMH01?l0003om^gFooK]e_l00006ooK]eP03o`000?ofkMKom^gF00Kom^gF0ol00002ooK]
eP06o`000?ofkMKom^gFo`000?ofkMKo00000oofkMH00ol0003om^gFooK]eP03ooK]eP05o`000?of
kMKom^gFooK]e_l000000_ofkMH00ol0003om^gFo`000003o`0000Com^gF0_l00004ooK]eP04o`00
0?ofkMKom^gFo`0000;om^gF0ol000000oofkMKo0000ooK]eP02ooK]eP04o`000?ofkMKom^gFo`00
00;om^gF00Ko0000ooK]e_ofkMKo0000ooK]e_l00002ooK]eP03o`000?ofkMKom^gF00?om^gF00Co
0000ooK]e_l0003o00001_ofkMH2o`0000Com^gF00Ko0000ooK]e_ofkMKom^gFo`000?ofkMH4o`00
0003ooK]e_l0003om^gF00Com^gF00Co0000ooK]e_ofkMKo00000oofkMH00ol0003om^gFo`000003
o`000003ooK]e_l0003om^gF00;om^gF00?o0000ooK]e_ofkMH00_ofkMH01Ol0003om^gFooK]e_of
kMKo000000;om^gF00Co0000ooK]e_ofkMKo00001oofkMH00ol0003om^gFooK]eP3oooK]eU[om^gF
00Gok^gUoiBEX_oooooomoOionc/l@06ooooo`09omCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWhUooK]eP04o`000?ofkMKom^gFo`0000;om^gF
00Co0000ooK]e_ofkMKo00000_ofkMH2o`0000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0
003om^gFo`000002ooK]eP03o`000?ofkMKo000000;om^gF00?o0000ooK]e_ofkMH00oofkMH00ol0
003om^gFo`000002ooK]eP03o`000?ofkMKom^gF00;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH2
o`0000;om^gF00?o0000ooK]e_l000000_ofkMH00ol0003om^gFo`000002ooK]eP04o`000?ofkMKo
m^gFo`0000;om^gF00Oo0000ooK]e_ofkMKom^gFo`000?ofkMKo000000;om^gF00?o0000ooK]e_l0
00000_ofkMH2o`0000Com^gF0_l00002ooK]eP04o`000?ofkMKom^gFo`0000?om^gF00?o0000ooK]
e_ofkMH00oofkMH00ol0003om^gFooK]eP05ooK]eP04o`000?ofkMKom^gFo`0000;om^gF0_l00000
1?ofkMKo0000ooK]e_l00002ooK]eP;o00001OofkMH01?l0003om^gFooK]e_ofkMH2o`000004ooK]
e_l0003om^gFo`0000;om^gF00?o0000ooK]e_ofkMH00_ofkMH01?l0003om^gFooK]e_l00002ooK]
eP;o000000Com^gFo`000?ofkMKo00000_ofkMH00ol0003om^gFo`000002ooK]eP;o00000_ofkMH0
0ol0003om^gFooK]eP02o`000004ooK]e_l0003om^gFo`0000;om^gF00?o0000ooK]e_ofkMH00oof
kMH00ol0003om^gFo`000002ooK]eP03o`000?ofkMKom^gF00;om^gF00Co0000ooK]e_ofkMKo0000
0_ofkMH2o`0000;om^gF00?o0000ooK]e_l000000_ofkMH00ol0003om^gFo`000002ooK]eP04o`00
0?ofkMKom^gFo`0000;om^gF00Oo0000ooK]e_ofkMKom^gFo`000?ofkMKo000000;om^gF00?o0000
ooK]e_l000000_ofkMH2o`0000Com^gF0_l00002ooK]eP04o`000?ofkMKom^gFo`0000?om^gF00?o
0000ooK]e_ofkMH00oofkMH00ol0003om^gFooK]eP3oooK]eU_om^gF00Cok^gUoiBEX_oooooomoOi
0_o/k?46ohjEXP08olk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn9_ofkMH3o`000004ooK]e_l0003o0000ooK]eP;o000000Com^gFo`000?l0003om^gF
1?l00002ooK]eP;o00000oofkMH3o`0000;om^gF0_l00005ooK]eP;o00000_ofkMH3o`0000Gom^gF
0ol000001?ofkMKo0000o`000?ofkMH2o`0000?om^gF0_l00003ooK]eP?o000000Com^gFo`000?l0
003om^gF0ol000000oofkMKo0000o`000002ooK]eP;o00000oofkMH2o`000003ooK]e_l0003om^gF
00?om^gF00Co0000ooK]e_l0003o00000_ofkMH3o`000004ooK]e_l0003o0000o`0000?om^gF0ol0
0007ooK]eP;o00000_ofkMH2o`000003ooK]e_l0003om^gF00;om^gF0_l000000oofkMKo0000ooK]
eP03ooK]eP?o00000_ofkMH00ol0003om^gFo`000003ooK]eP;o00001_ofkMH3o`0000;om^gF00?o
0000ooK]e_l000000oofkMH2o`0000?om^gF0_l000000oofkMKo0000ooK]eP02o`000005ooK]e_l0
003o0000ooK]e_l000000oofkMH4o`0000?om^gF0_l00002ooK]eP?o00001OofkMH3o`000004ooK]
e_l0003o0000ooK]eP;o00000oofkMH2o`0000?om^gF0ol000001?ofkMKo0000o`000?ofkMH3o`00
0003ooK]e_l0003o000000;om^gF0_l00003ooK]eP;o000000?om^gFo`000?ofkMH00oofkMH01?l0
003om^gFo`000?l00002ooK]eP?o000000Com^gFo`000?l0003o00001OofkMH2o`000?oom^gFFoof
kMH01Oo^kNGoU9FRooooooogmoWok>ca00Kooooo00Woe=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOSGom^gF00?o0000ooK]e_ofkMH0=oofkMH0
0ol0003om^gFooK]eP0<ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_ofkMH03_ofkMH0
0ol0003om^gFooK]eP0DooK]eP03o`000?ofkMKom^gF00?om^gF00Go0000ooK]e_ofkMKom^gFo`00
000BooK]eP03o`000?ofkMKom^gF00_om^gF00?o0000ooK]e_ofkMH0=OofkMH00ol0003om^gFooK]
eP0<ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_ofkMH0ooofkMI/ooK]eP04onk]iOnD
UJ;oooooooOgn@;ok>ca1_n>UJ802?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVOSGom^gF00Co0000ooK]e_ofkMKo0000=_ofkMH01?l0003om^gFooK]
e_l0000;ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_ofkMH03oofkMH00ol0003om^gF
o`00000CooK]eP03o`000?ofkMKom^gF00?om^gF00Go0000ooK]e_ofkMKom^gFo`00000BooK]eP03
o`000?ofkMKom^gF00_om^gF00?o0000ooK]e_ofkMH0=OofkMH01?l0003om^gFooK]e_l0000;ooK]
eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_ofkMH0ooofkMI/ooK]eP05onk]iOnDUJ;ooooo
ooOgnOo/k?401_ooool02OoDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP00
00CoIVInoo_loOnXZK_oIVIn=_ofkMH3o`0001;om^gF00?o0000ooK]e_ofkMH07_ofkMH01?l0003o
m^gFooK]e_ofkMH4o`0000Wom^gF0_l00003ooK]eP;o00004_ofkMH2o`0001;om^gF0_l00008ooK]
eP;o00004OofkMH2o`0000com^gF0_l00002ooK]eP03o`000?ofkMKom^gF00kom^gF00?o0000ooK]
e_ofkMH07_ofkMH01?l0003om^gFooK]e_ofkMH4o`0000Wom^gF0_l00003ooK]eP;o0000ooofkMI^
ooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca1_n>UJ802?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oom^gFooofkMJBooK]eP05onk]iOnDUJ;ooooo
ooOgnOo/k?401_ooool02OoDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP00
00CoIVInoo_loOnXZK_oIVInooofkMKoooK]eY;om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onWY
kP0<on?Sj_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004
ofIVO_oko?goZ:VkofIVO_oom^gFooofkMJBooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh0
3?oShn[ofm_Vom_Ki_oDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWkoooK]e_oom^gFT_ofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00co
hn?Zom_Ki_oKfnKoe=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVInooofkMKoooK]eY;om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?S
j_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVOUOom^gF0_l00022ooK]eP;o00003OofkMH2o`0001oom^gF0_l0000YooK]eP?o0000
RoofkMH3o`00067om^gF0ol0001UooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[o
fm_Vom_Ki_oDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWi@ooK]eP?o00001?ofkMH00ol0003om^gFo`000005ooK]eP03o`000?ofkMKom^gF00_o
m^gF00?o0000ooK]e_ofkMH00oofkMH00ol0003om^gFooK]eP07ooK]eP03o`000?ofkMKom^gF00Oo
m^gF00?o0000ooK]e_ofkMH07_ofkMH00ol0003om^gFooK]eP0OooK]eP03o`000?ofkMKom^gF00?o
m^gF00?o0000ooK]e_ofkMH01oofkMH2o`000003ooK]e_l0003om^gF00Gom^gF00?o0000ooK]e_of
kMH00oofkMH00ol0003om^gFo`00000HooK]eP03o`000?ofkMKom^gF00?om^gF00?o0000ooK]e_l0
00006OofkMH00ol0003om^gFooK]eP03ooK]eP?o00001OofkMH01Ol0003om^gFooK]e_ofkMKo0000
08_om^gF00?o0000ooK]e_ofkMH0GoofkMH01Ol0003om^gFooK]e_ofkMKo000006Com^gF00Cok^gU
oiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?ooooooU9FR
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOU3om^gF00?o0000ooK]e_ofkMH00oof
kMH01Ol0003om^gFooK]e_ofkMKo000000Com^gF0_l0000=ooK]eP03o`000?ofkMKom^gF00;om^gF
0_l00007ooK]eP03o`000?ofkMKom^gF00Som^gF0_l0000OooK]eP;o00008OofkMH00ol0003om^gF
ooK]eP02ooK]eP;o00001oofkMH01Ol0003om^gFooK]e_ofkMKo000000Kom^gF0_l00006ooK]eP03
o`000?ofkMKom^gF01Kom^gF0_l00006ooK]eP03o`000?ofkMKom^gF01Som^gF00?o0000ooK]e_of
kMH01?ofkMH00ol0003om^gFooK]eP03ooK]eP05o`000?ofkMKom^gFooK]e_l00000RoofkMH00ol0
003om^gFooK]eP1OooK]eP05o`000?ofkMKom^gFooK]e_l00000I?ofkMH01?o^kNGoU9FRooooooog
moT2onc/l@;ojNW^00cohn?Zom_Ki_oKfnKoe=GPolk?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9OofkMH3o`0000Com^gF1Ol00003ooK]eP?o00001Oof
kMH3o`0000?om^gF0ol00002ooK]ePCo00001OofkMH00ol0003om^gFooK]eP03ooK]eP05o`000?of
kMKom^gFooK]e_l000001OofkMH00ol0003om^gFooK]eP04ooK]eP?o00001?ofkMH00ol0003om^gF
ooK]eP03ooK]eP03o`000?ofkMKom^gF00Gom^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP03
o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_ofkMH01?ofkMH01_l0003om^gFooK]e_l0003om^gF
o`0000;om^gF00?o0000ooK]e_ofkMH00_l000001OofkMKo0000o`000?ofkMKo000000;om^gF0_l0
0004ooK]eP03o`000?ofkMKom^gF00Com^gF00Ko0000ooK]e_ofkMKo0000ooK]e_l00002ooK]eP03
o`000?ofkMKom^gF00;o000000Com^gFo`000?l0003om^gF0_l000001OofkMKo0000ooK]e_ofkMKo
000000?om^gF00?o0000ooK]e_ofkMH00oofkMH00ol0003om^gFooK]eP05ooK]eP03o`000?ofkMKo
m^gF00;om^gF00?o0000ooK]e_ofkMH01?ofkMH00ol0003om^gFooK]eP05ooK]eP05o`000?ofkMKo
m^gFooK]e_l000000_ofkMH00ol0003om^gFooK]eP02o`000005ooK]e_l0003o0000ooK]e_l00000
0_ofkMH2o`0000Com^gF00?o0000ooK]e_ofkMH01OofkMH01Ol0003om^gFooK]e_ofkMKo000000;o
m^gF00?o0000ooK]e_ofkMH00_l000001?ofkMKo0000o`000?ofkMH2o`000005ooK]e_l0003om^gF
ooK]e_l000000oofkMH00ol0003om^gFooK]eP04ooK]eP03o`000?ofkMKom^gF00Com^gF0ol00002
ooK]eP;o00000_ofkMH3o`000004ooK]e_l0003o0000ooK]eP;o00000_ofkMH3o`0000;om^gF1?l0
00000oofkMKo0000o`000002ooK]eP;o00000_ofkMH3o`0000Kom^gF1?l00004ooK]eP;o000000Go
m^gFo`000?l0003o0000ooK]eP05o`0000;om^gF0_l00003ooK]eP;o00001oofkMH;o`000004ooK]
e_l0003o0000ooK]eP;o000000?om^gFo`000?l000000_ofkMH3o`000003ooK]e_l0003o000000?o
00000_ofkMH3o`000004ooK]e_l0003o0000o`0000;om^gF0ol000001?ofkMKo0000o`000?ofkMH7
o`0000Com^gF00Co0000ooK]e_l0003o00000_ofkMH3o`000004ooK]e_l0003o0000o`0000?om^gF
0_l00004ooK]ePKo000000?om^gFo`000?l000001OofkMH01?l0003om^gFooK]e_l00003ooK]eP?o
000000?om^gFo`000?l000000ol000000oofkMKo0000o`000002ooK]eP?o000000?om^gFo`000?l0
00001?ofkMH2o`000005ooK]e_l0003o0000o`000?ofkMH00_l000000oofkMKo0000o`000005ooK]
eP?o000000Com^gFo`000?l0003om^gF0_l00002ooK]eP?o000000Gom^gFo`000?l0003o0000ooK]
eP03o`000004ooK]e_l0003o0000ooK]eP;o00001OofkMH3o`0000;om^gF0ol00005ooK]eP;o0000
00Gom^gFo`000?l0003o0000ooK]eP02o`000003ooK]e_l0003o000003gom^gF00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWYkP0<on?Sj_oKfnKofm_VomCEh?o>cmgoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcom^gF1Ol00005ooK]eP03o`000?ofkMKom^gF
00Gom^gF00?o0000ooK]e_ofkMH00_ofkMH01Ol0003om^gFooK]e_ofkMKo000000?om^gF00Oo0000
ooK]e_ofkMKom^gFo`000?ofkMKo000000?om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003o
m^gFooK]eP02ooK]eP03o`000?ofkMKom^gF00?om^gF00Go0000ooK]e_ofkMKom^gFo`000005ooK]
eP;o00001OofkMH01?l0003om^gFooK]e_l00003ooK]eP03o`000?ofkMKom^gF00?om^gF0_l00006
ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_l000001?ofkMH2o`0000Kom^gF00Go0000
ooK]e_l0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Co0000ooK]e_ofkMKo
00000_ofkMH00ol0003om^gFooK]eP03ooK]eP;o00001_ofkMH01Ol0003om^gFo`000?ofkMKo0000
00;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH01?l0003om^gFo`000?l00003ooK]eP03o`000?of
kMKo000000?om^gF00?o0000ooK]e_ofkMH00oofkMH2o`0000Kom^gF00?o0000ooK]e_ofkMH00_of
kMH2o`0000Gom^gF0_l00006ooK]eP;o00000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP04o`00
0?ofkMKom^gFo`0000;om^gF00Co0000ooK]e_ofkMKo00001OofkMH2o`0000Kom^gF0_l00002ooK]
eP04o`000?ofkMKom^gFo`0000;om^gF00Go0000ooK]e_ofkMKo0000ooK]eP02o`0000?om^gF00?o
0000ooK]e_l000000oofkMH00ol0003om^gFooK]eP04ooK]eP03o`000?ofkMKom^gF00?om^gF00?o
0000ooK]e_ofkMH00_ofkMH01?l0003om^gFooK]e_l00002ooK]eP06o`000?ofkMKom^gFo`000?of
kMKo00000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Co
0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFo`000002ooK]eP03o`000?ofkMKom^gF00;om^gF
00Co0000ooK]e_ofkMKo00001OofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00Co0000ooK]
e_ofkMKo00000_ofkMH01_l0003om^gFooK]e_l0003om^gFo`0000;om^gF00?o0000ooK]e_ofkMH0
0oofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH01_l0
003om^gFooK]e_l0003om^gFo`0000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gF
o`000002ooK]eP06o`000?ofkMKom^gFo`000?ofkMKo00000oofkMH01?l0003om^gFooK]e_l00002
ooK]eP03o`000?ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo00001OofkMH2o`0000;om^gF00Ko
0000ooK]e_ofkMKo0000ooK]e_l00003ooK]eP04o`000?ofkMKom^gFo`0000Kom^gF00Co0000ooK]
e_ofkMKo00000_ofkMH00ol0003om^gFooK]eP04ooK]eP04o`000?ofkMKom^gFo`0000Com^gF00Co
0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`0000;o
m^gF00?o0000ooK]e_ofkMH00oofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00?o0000ooK]
e_l000000_ofkMH00ol0003om^gFooK]eP03ooK]eP06o`000?ofkMKom^gFo`000?ofkMKo00000_of
kMH01_l0003om^gFooK]e_l0003om^gFo`0000Gom^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0
003om^gFooK]eP03ooK]eP05o`000?ofkMKom^gFooK]e_l000000_ofkMH00ol0003om^gFooK]eP04
ooK]eP05o`000?ofkMKom^gFooK]e_l000000_ofkMH00ol0003om^gFo`000002ooK]eP03o`000?of
kMKom^gF03[om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>
d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcom^gF
1Ol00005ooK]eP03o`000?ofkMKom^gF00Gom^gF00?o0000ooK]e_ofkMH00_ofkMH01Ol0003om^gF
ooK]e_ofkMKo000000?om^gF00?o0000ooK]e_ofkMH01oofkMH01?l0003om^gFooK]e_l00003ooK]
eP05o`000?ofkMKom^gFooK]e_l000001OofkMH00ol0003om^gFooK]eP02ooK]eP03o`000?ofkMKo
m^gF00com^gF00Go0000ooK]e_ofkMKom^gFo`00000=ooK]eP03o`000?ofkMKom^gF00?om^gF00?o
0000ooK]e_ofkMH03?ofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo
00000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP03o`000?ofkMKom^gF00_om^gF00Go0000ooK]
e_ofkMKom^gFo`000002ooK]eP06o`000?ofkMKom^gFo`000?ofkMKo00000_ofkMH00ol0003om^gF
ooK]eP02ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_ofkMH02oofkMH00ol0003om^gF
ooK]eP02ooK]eP03o`000?ofkMKo000000com^gF00?o0000ooK]e_l000000_ofkMH01?l0003om^gF
ooK]e_l00002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Co0000ooK]e_ofkMKo00003?ofkMH0
0ol0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00?o0000ooK]e_l000000_of
kMH00ol0003om^gFooK]eP02ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_ofkMH01?of
kMH00ol0003om^gFooK]eP04ooK]eP;o00000_ofkMH00ol0003om^gFooK]eP03ooK]eP06o`000?of
kMKom^gFo`000?ofkMKo00001OofkMH01?l0003om^gFooK]e_l00002ooK]eP04o`000?ofkMKom^gF
o`0000;om^gF00?o0000ooK]e_ofkMH01?ofkMH2o`0000Com^gF00Co0000ooK]e_ofkMKo00001Oof
kMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003o
m^gFooK]eP02ooK]eP03o`000?ofkMKom^gF00;om^gF0ol000000oofkMKo0000ooK]eP02ooK]eP04
o`000?ofkMKom^gFo`0000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFo`000005
ooK]eP04o`000?ofkMKom^gFo`0000?om^gF0_l00002ooK]eP03o`000?ofkMKo000000?om^gF00Co
0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`0000Go
m^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP03o`000?ofkMKo000000?om^gF00Co0000ooK]
e_ofkMKo00001_ofkMH01?l0003om^gFooK]e_l00002ooK]eP03o`000?ofkMKom^gF00?om^gF00Ko
0000ooK]e_l0003o0000ooK]e_l00003ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00?o0000ooK]
e_l000001OofkMH01?l0003om^gFooK]e_l00005ooK]eP05o`000?ofkMKom^gFooK]e_l000000_of
kMH00ol0003om^gFo`000008ooK]eP06o`000?ofkMKom^gFo`000?ofkMKo00001OofkMH00ol0003o
m^gFooK]eP02o`0000?om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFooK]eP03ooK]
eP05o`000?ofkMKom^gFooK]e_l000000_ofkMH00ol0003om^gFooK]eP04ooK]eP05o`000?ofkMKo
m^gFooK]e_l000000_ofkMH00ol0003om^gFo`00000oooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca
0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWhLooK]ePGo00001OofkMH3o`0000Gom^gF00?o0000ooK]e_ofkMH0
0_ofkMH01Ol0003om^gFooK]e_ofkMKo000000?om^gF00?o0000ooK]e_ofkMH01oofkMH01?l0003o
m^gFooK]e_l00003ooK]eP05o`000?ofkMKom^gFooK]e_l000001?ofkMH00ol0003om^gFooK]eP03
ooK]eP03o`000?ofkMKom^gF00_om^gF00?o0000ooK]e_ofkMH00oofkMH00ol0003om^gFooK]eP09
ooK]eP03o`000?ofkMKom^gF00Com^gF00?o0000ooK]e_ofkMH03?ofkMH01Ol0003om^gFooK]e_of
kMKo000000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP03
o`000?ofkMKom^gF00_om^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP06o`000?ofkMKom^gF
o`000?ofkMKo00000oofkMH01Ol0003om^gFooK]e_ofkMKo000000Gom^gF00?o0000ooK]e_ofkMH0
2OofkMH00ol0003om^gFooK]eP03ooK]eP03o`000?ofkMKo000000com^gF00?o0000ooK]e_l00000
0_ofkMH01?l0003om^gFooK]e_l00002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Co0000ooK]
e_ofkMKo00003?ofkMH00ol0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00?o
0000ooK]e_l000000oofkMH01Ol0003om^gFooK]e_ofkMKo000000Gom^gF00?o0000ooK]e_ofkMH0
0oofkMH00ol0003om^gFooK]eP03ooK]eP05o`000?ofkMKom^gFo`000?ofkMH01?l00002ooK]eP05
o`000?ofkMKom^gFo`000?ofkMH01?l00002ooK]eP04o`000?ofkMKom^gFooK]eP?o00000_ofkMH0
0ol0003om^gFooK]eP04o`000003ooK]e_l0003o000000Oom^gF0ol00005ooK]eP05o`000?ofkMKo
m^gFooK]e_l000000_ofkMH01?l0003om^gFooK]e_l00002ooK]ePCo000000?om^gFo`000?l00000
0_l00005ooK]eP05o`000?ofkMKom^gFooK]e_l000000_ofkMH01?l0003om^gFooK]e_l00002ooK]
eP05o`000?ofkMKom^gFo`000?ofkMH01?l00002ooK]eP05o`000?ofkMKom^gFo`000?ofkMH00_l0
0004ooK]eP03o`000?ofkMKo000000?om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gF
ooK]eP03o`0000;om^gF00?o0000ooK]e_ofkMH00oofkMH01Ol0003om^gFooK]e_ofkMKo000000;o
m^gF00?o0000ooK]e_l000000oofkMH01?l0003om^gFooK]e_l00006ooK]eP04o`000?ofkMKom^gF
o`0000;om^gF00?o0000ooK]e_ofkMH00oofkMH01_l0003om^gFooK]e_l0003om^gFo`0000?om^gF
00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFo`000005ooK]eP04o`000?ofkMKom^gFo`00
00Gom^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP03o`000?ofkMKo000000?o00001OofkMH0
1Ol0003om^gFooK]e_l0003om^gF00Co00000_ofkMH00ol0003om^gFo`000002ooK]eP04o`000?of
kMKom^gFo`0000;om^gF00Co0000ooK]e_ofkMKo00001OofkMH01Ol0003om^gFooK]e_ofkMKo0000
00;om^gF00?o0000ooK]e_ofkMH01?ofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00?o0000
ooK]e_l000000ol0000looK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNl03?oShn[ofm_Vom_K
i_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWhLooK]ePGo00001OofkMH01?l0003om^gFooK]e_l00004ooK]eP03o`000?ofkMKom^gF00;om^gF
00Go0000ooK]e_ofkMKom^gFo`000003ooK]eP03o`000?ofkMKom^gF00Gom^gF0_l00003ooK]eP05
o`000?ofkMKom^gFooK]e_l000000oofkMH00ol0003om^gFooK]eP03ooK]eP03o`000?ofkMKom^gF
00;om^gF00?o0000ooK]e_ofkMH02_ofkMH00ol0003om^gFooK]eP03ooK]eP03o`000?ofkMKom^gF
00_om^gF00?o0000ooK]e_ofkMH00oofkMH2o`0000gom^gF0_l00002ooK]eP;o000000Gom^gFo`00
0?l0003om^gFo`000002ooK]eP03o`000?ofkMKom^gF00;o000000?om^gFo`000?ofkMH03?ofkMH2
o`0000;om^gF0_l000001OofkMKo0000o`000?ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo0000
0oofkMH2o`0000?om^gF00?o0000ooK]e_ofkMH02oofkMH00ol0003om^gFooK]eP02ooK]eP03o`00
0?ofkMKo000000com^gF00?o0000ooK]e_l000000_ofkMH2o`000005ooK]e_l0003o0000ooK]e_l0
00000_ofkMH00ol0003om^gFooK]eP02o`000003ooK]e_l0003om^gF00_om^gF00?o0000ooK]e_l0
00000_ofkMH2o`000005ooK]e_l0003o0000ooK]e_l000000_ofkMH01?l0003om^gFooK]e_l00003
ooK]eP;o00000oofkMH00ol0003om^gFooK]eP04ooK]eP03o`000?ofkMKom^gF00?om^gF00Ko0000
ooK]e_ofkMKo0000ooK]e_l00002ooK]eP03o`000?ofkMKom^gF00;o000000Com^gFo`000?ofkMKo
00000_ofkMH00ol0003om^gFooK]eP02o`000005ooK]e_l0003om^gFooK]e_l000000_ofkMH01?l0
003om^gFooK]e_l00002ooK]eP03o`000?ofkMKo000000;om^gF00?o0000ooK]e_ofkMH00_ofkMH0
1?l0003om^gFooK]e_l00005ooK]eP04o`000?ofkMKom^gFooK]eP;o000000Com^gFo`000?ofkMKo
m^gF0_l000001oofkMKo0000ooK]e_ofkMKo0000ooK]e_l000000_ofkMH00ol0003om^gFooK]eP03
ooK]eP03o`000?ofkMKom^gF00;o00000_ofkMH00ol0003om^gFooK]eP02o`000007ooK]e_l0003o
0000ooK]e_l0003om^gFo`000002ooK]eP03o`000?ofkMKom^gF00;o000000Com^gFo`000?ofkMKo
00000_ofkMH01_l0003om^gFooK]e_l0003om^gFo`0000?om^gF00?o0000ooK]e_ofkMH00_l00000
1?ofkMKo0000ooK]e_l00002ooK]eP04o`000?ofkMKom^gFo`0000Gom^gF0_l00002ooK]eP06o`00
0?ofkMKom^gFo`000?ofkMKo00000oofkMH01?l0003om^gFooK]e_l00006ooK]eP03o`000?ofkMKo
m^gF00;o000000?om^gFo`000?ofkMH01?ofkMH01?l0003om^gFooK]e_l00002ooK]eP03o`000?of
kMKom^gF00;o000000Oom^gFo`000?ofkMKom^gFo`000?ofkMKo000000;om^gF00?o0000ooK]e_of
kMH00_l000000oofkMKo0000ooK]eP04ooK]eP04o`000?ofkMKom^gFooK]eP;o000000Com^gFo`00
0?ofkMKo00000_ofkMH00ol0003om^gFooK]eP03ooK]eP;o000000Com^gFo`000?ofkMKo00000_of
kMH01_l0003om^gFooK]e_l0003om^gFo`0000;om^gF00?o0000ooK]e_ofkMH00_l000001OofkMKo
0000ooK]e_ofkMKo000000Gom^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP03o`000?ofkMKo
m^gF00Com^gF00Co0000ooK]e_ofkMKom^gF0_l000001?ofkMKo0000ooK]e_l00002ooK]eP03o`00
0?ofkMKom^gF03[om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?Sj_oKfnKofm_VomCE
hOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQco
m^gF1Ol00005ooK]eP04o`000?ofkMKom^gFo`0000Com^gF00?o0000ooK]e_ofkMH00oofkMH3o`00
00?om^gF1Ol00006ooK]eP04o`000?ofkMKom^gFo`0000?om^gF00Go0000ooK]e_ofkMKom^gFo`00
0005ooK]eP04o`000?ofkMKom^gFooK]eP?o00003?ofkMH2o`0000?om^gF00?o0000ooK]e_ofkMH0
2oofkMH00ol0003om^gFooK]eP02ooK]eP;o000000?om^gFo`000?ofkMH02_ofkMH2o`000005ooK]
e_l0003o0000o`000?ofkMH00_l000001?ofkMKo0000o`000?ofkMH2o`000004ooK]e_l0003o0000
ooK]eP;o00003?ofkMH2o`000005ooK]e_l0003o0000o`000?ofkMH00_l000000oofkMKo0000o`00
0003ooK]eP?o00000_ofkMH2o`000005ooK]e_l0003om^gFooK]e_l000003OofkMH01?l0003om^gF
ooK]e_ofkMH2o`000003ooK]e_l0003om^gF00[om^gF0_l000000oofkMKo0000ooK]eP02o`000004
ooK]e_l0003o0000ooK]eP;o000000Com^gFo`000?l0003om^gF0_l000000oofkMKo0000o`00000;
ooK]eP;o000000?om^gFo`000?ofkMH00_l000001?ofkMKo0000o`000?ofkMH2o`0000?om^gF0ol0
0002ooK]eP;o000000Gom^gFo`000?ofkMKom^gFo`000006ooK]eP03o`000?ofkMKom^gF00Com^gF
1?l000000oofkMKo0000o`000002ooK]eP;o000000?om^gFo`000?ofkMH00_ofkMH2o`0000;om^gF
0_l000000oofkMKo0000ooK]eP02o`0000;om^gF0ol00002ooK]eP;o00000oofkMH3o`0000Gom^gF
0_l00005ooK]eP?o00000_ofkMH00ol0003om^gFo`000002ooK]eP;o000000?om^gFo`000?ofkMH0
0_l00003ooK]eP;o00001oofkMH2o`000003ooK]e_l0003om^gF00;o000000Gom^gFo`000?l0003o
m^gFo`000002ooK]eP04o`000?ofkMKom^gFooK]eP;o00000_ofkMH2o`000003ooK]e_l0003om^gF
00;om^gF0ol000000oofkMKo0000o`000002ooK]eP?o00000_ofkMH2o`000003ooK]e_l0003om^gF
00;om^gF0_l00003ooK]eP03o`000?ofkMKom^gF00;om^gF0_l000000oofkMKo0000o`000003ooK]
eP03o`000?ofkMKom^gF00?o00000_ofkMH3o`0000Com^gF0_l000001OofkMKo0000o`000?ofkMKo
000000Gom^gF0_l000001OofkMKo0000o`000?l0003om^gF00;o000000Com^gFo`000?ofkMKo0000
0_ofkMH2o`0000;om^gF0ol00002ooK]eP03o`000?ofkMKo000000Gom^gF0ol00002ooK]eP03o`00
0?ofkMKo000000?om^gF0_l00006ooK]eP03o`000?ofkMKo000000?om^gF0_l00002ooK]eP;o0000
0_ofkMH4o`000004ooK]e_l0003om^gFo`0000;om^gF0ol00005ooK]eP?o00000_ofkMH3o`0000Co
m^gF0ol00002ooK]eP03o`000?ofkMKo000000?om^gF0_l0000mooK]eP04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWhVooK]eP04o`000?ofkMKom^gFo`0000Com^gF00?o0000
ooK]e_ofkMH02_ofkMH00ol0003om^gFooK]eP03ooK]eP05o`000?ofkMKom^gFooK]e_l000000_of
kMH01?l0003om^gFooK]e_l00004ooK]eP03o`000?ofkMKom^gF00?om^gF00?o0000ooK]e_ofkMH0
0_ofkMH00ol0003om^gFooK]eP0@ooK]eP03o`000?ofkMKom^gF00_om^gF00?o0000ooK]e_ofkMH0
C?ofkMH00ol0003om^gFooK]eP0;ooK]eP03o`000?ofkMKom^gF04com^gF00?o0000ooK]e_ofkMH0
1?ofkMH00ol0003om^gFooK]eP0RooK]eP03o`000?ofkMKom^gF01Kom^gF00Go0000ooK]e_ofkMKo
m^gFo`00000JooK]eP03o`000?ofkMKom^gF033om^gF00?o0000ooK]e_ofkMH02_ofkMH00ol0003o
m^gFooK]eP06ooK]eP03o`000?ofkMKom^gF01Wom^gF00?o0000ooK]e_ofkMH02oofkMH00ol0003o
m^gFooK]eP06ooK]eP05o`000?ofkMKom^gFooK]e_l000003OofkMH00ol0003om^gFooK]eP0@ooK]
eP03o`000?ofkMKom^gF00?om^gF00?o0000ooK]e_ofkMH02_ofkMH00ol0003om^gFooK]eP04ooK]
eP05o`000?ofkMKom^gFooK]e_l00000A?ofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W_00co
hn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVIn9OofkMH4o`0000Com^gF0_l0000CooK]eP?o00000_ofkMH4o`0000Gom^gF0ol0
0003ooK]eP03o`000?ofkMKom^gF00?om^gF00?o0000ooK]e_l000003oofkMH00ol0003om^gFooK]
eP0;ooK]eP03o`000?ofkMKom^gF023om^gF00?o0000ooK]e_ofkMH0:OofkMH00ol0003om^gFooK]
eP0;ooK]eP03o`000?ofkMKom^gF023om^gF00?o0000ooK]e_ofkMH0:OofkMH00ol0003om^gFooK]
eP02ooK]eP?o00009?ofkMH00ol0003om^gFooK]eP0FooK]eP05o`000?ofkMKom^gFooK]e_l00000
6_ofkMH00ol0003om^gFooK]eP0`ooK]eP03o`000?ofkMKom^gF00[om^gF00?o0000ooK]e_ofkMH0
1_ofkMH00ol0003om^gFooK]eP0IooK]eP03o`000?ofkMKom^gF00_om^gF00?o0000ooK]e_ofkMH0
1_ofkMH01Ol0003om^gFooK]e_ofkMKo000000gom^gF00?o0000ooK]e_ofkMH04?ofkMH00ol0003o
m^gFooK]eP03ooK]eP03o`000?ofkMKom^gF00[om^gF00Co0000ooK]e_ofkMKo00000oofkMH01Ol0
003om^gFooK]e_ofkMKo000004Com^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0<on?Sj_oK
fnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVOUOom^gF00?o0000ooK]e_ofkMH00oofkMH2o`0000kom^gF00?o0000ooK]e_ofkMH03Oof
kMH00ol0003om^gFooK]eP1:ooK]eP03o`000?ofkMKom^gF00gom^gF00?o0000ooK]e_ofkMH0B_of
kMH00ol0003om^gFooK]eP16ooK]eP;o00006OofkMH2o`0000;om^gF00?o0000ooK]e_ofkMH06Oof
kMH00ol0003om^gFooK]eP0@ooK]eP;o00002oofkMH2o`0000oom^gF00?o0000ooK]e_ofkMH04Oof
kMH2o`0000Gom^gF00?o0000ooK]e_ofkMH01?ofkMH2o`0000_om^gF0_l0000<ooK]eP;o00002_of
kMH00ol0003om^gFooK]eP04ooK]eP;o00004oofkMH3o`0000Kom^gF0_l00014ooK]eP04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooK]e_oom^gFT_ofkMH01?o^kNGoU9FR
ooooooogmoT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooofkMKoooK]eY;om^gF00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onSYk`0<on?Sj_oKfnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oom^gFooofkMJBooK]eP04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oXjNl03?oShn[ofm_Vom_Ki_oDeN7oc]3Molc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooK]e_oom^gFT_ofkMH01?o^kNGoU9FRooooooog
moT2onc/l@;oj>W_00cohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooofkMKoooK]eY;om^gF00Cok^gUoiBEX_oooooomoOi
0_o/k?42onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oom^gFooofkMJBooK]eP04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooK]e_oom^gFT_ofkMH01?o^kNGoU9FRooooooogmoT2onc/
l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInooofkMKoooK]eY;om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42
onSYkP0<on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oom^gFooofkMJBooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
jNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooK]e_oom^gFT_ofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^
00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInooofkMKoooK]eY;om^gF00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<
on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVOU;om^gF0_l0001^ooK]eP;o00003OofkMH2o`0001oom^gF0_l0000YooK]eP?o
0000RoofkMH3o`0001kom^gF0_l0001^ooK]eP;o0000D_ofkMH01?o^kNGoU9FRooooooogmoT2onc/
l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInD?ofkMH3o`000003ooK]e_l0003om^gF00Com^gF00?o0000ooK]
e_ofkMH01oofkMH00ol0003om^gFooK]eP07ooK]eP03o`000?ofkMKom^gF01kom^gF00?o0000ooK]
e_ofkMH07oofkMH00ol0003om^gFooK]eP03ooK]eP03o`000?ofkMKom^gF00Oom^gF0_l000000oof
kMKo0000ooK]eP05ooK]eP03o`000?ofkMKom^gF00?om^gF00?o0000ooK]e_l000006?ofkMH00ol0
003om^gFooK]eP03ooK]eP03o`000?ofkMKo000001Wom^gF00?o0000ooK]e_ofkMH00oofkMH3o`00
00Gom^gF00Go0000ooK]e_ofkMKom^gFo`00002;ooK]eP03o`000?ofkMKom^gF01gom^gF00?o0000
ooK]e_l00000KOofkMH00ol0003om^gFo`00001AooK]eP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
jNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWi@ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_ofkMH00_of
kMH2o`0000Oom^gF00?o0000ooK]e_ofkMH02?ofkMH2o`0001oom^gF0_l0000QooK]eP03o`000?of
kMKom^gF00;om^gF0_l00007ooK]eP05o`000?ofkMKom^gFooK]e_l000001_ofkMH2o`0000Kom^gF
00?o0000ooK]e_ofkMH05_ofkMH2o`0000Kom^gF00?o0000ooK]e_ofkMH06?ofkMH00ol0003om^gF
ooK]eP04ooK]eP03o`000?ofkMKom^gF00?om^gF00Go0000ooK]e_ofkMKom^gFo`00002;ooK]eP03
o`000?ofkMKom^gF023om^gF00?o0000ooK]e_ofkMH0K?ofkMH00ol0003om^gFooK]eP1?ooK]eP04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhUooK]eP?o00001?ofkMH5o`00
00?om^gF0ol00005ooK]eP?o00000oofkMH3o`0000;om^gF1?l00005ooK]eP03o`000?ofkMKom^gF
00;om^gF00?o0000ooK]e_ofkMH00oofkMH00ol0003om^gFooK]eP05ooK]eP05o`000?ofkMKom^gF
ooK]e_l000000_ofkMH00ol0003om^gFooK]eP02ooK]eP03o`000?ofkMKom^gF00Com^gF00Ko0000
ooK]e_ofkMKo0000ooK]e_l00002ooK]eP03o`000?ofkMKom^gF00;o000000Gom^gFo`000?l0003o
m^gFo`000002ooK]eP;o00001?ofkMH00ol0003om^gFooK]eP04ooK]eP06o`000?ofkMKom^gFo`00
0?ofkMKo00000_ofkMH00ol0003om^gFooK]eP02o`000004ooK]e_l0003o0000ooK]eP;o000000Go
m^gFo`000?ofkMKom^gFo`000003ooK]eP03o`000?ofkMKom^gF00?om^gF00?o0000ooK]e_ofkMH0
1OofkMH00ol0003om^gFooK]eP02ooK]eP03o`000?ofkMKom^gF00Com^gF00?o0000ooK]e_ofkMH0
1OofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00?o0000ooK]e_ofkMH00_l000001OofkMKo
0000o`000?ofkMKo000000;om^gF0_l00004ooK]eP03o`000?ofkMKom^gF00Gom^gF00Go0000ooK]
e_ofkMKom^gFo`000002ooK]eP03o`000?ofkMKom^gF00;o000000Com^gFo`000?l0003om^gF0_l0
00001OofkMKo0000ooK]e_ofkMKo000000?om^gF00?o0000ooK]e_ofkMH01?ofkMH00ol0003om^gF
ooK]eP04ooK]eP?o00000_ofkMH2o`0000;om^gF0ol000001?ofkMKo0000o`000?ofkMH2o`0000;o
m^gF0ol00002ooK]ePCo000000?om^gFo`000?l000000_ofkMH2o`0000;om^gF0ol00006ooK]ePCo
00001?ofkMH2o`000005ooK]e_l0003o0000o`000?ofkMH01Ol00002ooK]eP;o00000oofkMH2o`00
00Oom^gF2ol000001?ofkMKo0000o`000?ofkMH2o`000003ooK]e_l0003o000000;om^gF0ol00000
0oofkMKo0000o`000003o`0000;om^gF0ol000001?ofkMKo0000o`000?l00002ooK]eP?o000000Co
m^gFo`000?l0003om^gF1ol00004ooK]eP04o`000?ofkMKo0000o`0000;om^gF0ol000001?ofkMKo
0000o`000?l00003ooK]eP;o00001OofkMH3o`0000;om^gF0ol00004ooK]eP03o`000?ofkMKom^gF
00Com^gF1ol00006ooK]ePCo00000oofkMH3o`0000?om^gF1ol000001?ofkMKo0000o`000?ofkMH2
o`0000?om^gF0_l000001OofkMKo0000o`000?l0003om^gF00?o00000_ofkMH3o`000003ooK]e_l0
003o000000Com^gF0ol00002ooK]eP?o00001?ofkMH01?l0003om^gFooK]e_l00005ooK]ePOo0000
00Com^gFo`000?l0003om^gF1Ol00004ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_of
kMH0BOofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<
cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ofkMH5o`00
00Gom^gF00?o0000ooK]e_ofkMH01OofkMH00ol0003om^gFooK]eP02ooK]eP05o`000?ofkMKom^gF
ooK]e_l000000oofkMH01ol0003om^gFooK]e_ofkMKo0000ooK]e_l000000oofkMH01?l0003om^gF
ooK]e_l00002ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]e_ofkMH00_ofkMH00ol0003o
m^gFooK]eP03ooK]eP;o00001_ofkMH00ol0003om^gFooK]eP02ooK]eP03o`000?ofkMKo000000Co
m^gF0_l00006ooK]eP05o`000?ofkMKo0000ooK]e_l000000_ofkMH01?l0003om^gFooK]e_l00002
ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00?o0000ooK]e_ofkMH00oofkMH2o`0000Kom^gF00Go
0000ooK]e_l0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Co0000ooK]e_l0
003o00000oofkMH00ol0003om^gFo`000003ooK]eP03o`000?ofkMKom^gF00?om^gF0_l00006ooK]
eP03o`000?ofkMKom^gF00;om^gF0_l00005ooK]eP;o00001_ofkMH2o`0000;om^gF00Co0000ooK]
e_ofkMKo00000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP04o`000?ofkMKom^gFo`0000Gom^gF
0_l00006ooK]eP;o00000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP05o`000?ofkMKom^gFo`00
0?ofkMH00_l00003ooK]eP03o`000?ofkMKo000000?om^gF00?o0000ooK]e_ofkMH01?ofkMH00ol0
003om^gFooK]eP03ooK]eP03o`000?ofkMKom^gF00;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH0
1_l0003om^gFooK]e_l0003om^gFo`0000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH01?l0003o
m^gFooK]e_l00002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00?o0000ooK]e_l000000_ofkMH0
0ol0003om^gFooK]eP02ooK]eP04o`000?ofkMKom^gFo`0000Gom^gF00Go0000ooK]e_ofkMKom^gF
o`000002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Ko0000ooK]e_ofkMKo0000ooK]e_l00002
ooK]eP03o`000?ofkMKom^gF00?om^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP04o`000?of
kMKom^gFo`0000;om^gF00Ko0000ooK]e_ofkMKo0000ooK]e_l00002ooK]eP04o`000?ofkMKom^gF
o`0000;om^gF00?o0000ooK]e_l000000_ofkMH01_l0003om^gFooK]e_l0003om^gFo`0000?om^gF
00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`00
00Gom^gF0_l00002ooK]eP06o`000?ofkMKom^gFo`000?ofkMKo00000oofkMH01?l0003om^gFooK]
e_l00005ooK]eP05o`000?ofkMKom^gFooK]e_l000000_ofkMH00ol0003om^gFooK]eP03ooK]eP03
o`000?ofkMKom^gF00?om^gF00Ko0000ooK]e_ofkMKo0000ooK]e_l00002ooK]eP03o`000?ofkMKo
m^gF00;om^gF00Co0000ooK]e_ofkMKo00001OofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF
00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`00
00?om^gF00?o0000ooK]e_l000000oofkMH01?l0003om^gFooK]e_l00002ooK]eP03o`000?ofkMKo
m^gF00;om^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP03o`000?ofkMKom^gF00Com^gF00?o
0000ooK]e_l000001?ofkMH01?l0003om^gFooK]e_l00002ooK]eP06o`000?ofkMKom^gFo`000?of
kMKo00000oofkMH00ol0003om^gFooK]eP03ooK]eP;o0000CoofkMH01?o^kNGoU9FRooooooogmoT2
onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1
ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ofkMH5o`0000Gom^gF00?o0000ooK]e_ofkMH01OofkMH0
0ol0003om^gFooK]eP02ooK]eP05o`000?ofkMKom^gFooK]e_l000000oofkMH00ol0003om^gFooK]
eP07ooK]eP04o`000?ofkMKom^gFo`0000?om^gF00Go0000ooK]e_ofkMKom^gFo`000005ooK]eP03
o`000?ofkMKom^gF00[om^gF00?o0000ooK]e_ofkMH00oofkMH00ol0003om^gFooK]eP0<ooK]eP05
o`000?ofkMKom^gFooK]e_l000000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP04o`000?ofkMKo
m^gFo`0000;om^gF00?o0000ooK]e_ofkMH02oofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF
00Ko0000ooK]e_ofkMKo0000ooK]e_l00002ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]
e_ofkMH00_ofkMH00ol0003om^gFooK]eP0;ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000ooK]
e_l000003?ofkMH00ol0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Co0000
ooK]e_ofkMKo00000_ofkMH01?l0003om^gFooK]e_l0000<ooK]eP03o`000?ofkMKo000000;om^gF
00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFo`000002ooK]eP03o`000?ofkMKom^gF00;o
m^gF00?o0000ooK]e_ofkMH00_ofkMH00ol0003om^gFooK]eP04ooK]eP03o`000?ofkMKom^gF00Co
m^gF0_l00002ooK]eP03o`000?ofkMKom^gF00?om^gF00Ko0000ooK]e_ofkMKo0000ooK]e_l00005
ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gF
ooK]eP04ooK]eP;o00001?ofkMH01?l0003om^gFooK]e_l00005ooK]eP05o`000?ofkMKom^gFooK]
e_l000000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP03o`000?ofkMKom^gF00;om^gF00?o0000
ooK]e_ofkMH00_ofkMH3o`000003ooK]e_l0003om^gF00;om^gF00Co0000ooK]e_ofkMKo00000_of
kMH01?l0003om^gFooK]e_l00002ooK]eP03o`000?ofkMKo000000Gom^gF00Co0000ooK]e_ofkMKo
00000oofkMH2o`0000;om^gF00?o0000ooK]e_l000000oofkMH01?l0003om^gFooK]e_l00002ooK]
eP03o`000?ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo00001OofkMH01Ol0003om^gFooK]e_of
kMKo000000;om^gF00?o0000ooK]e_l000000oofkMH01?l0003om^gFooK]e_l00005ooK]eP05o`00
0?ofkMKom^gFooK]e_l000000_ofkMH00ol0003om^gFooK]eP04ooK]eP03o`000?ofkMKom^gF00;o
m^gF00Co0000ooK]e_ofkMKo00000oofkMH2o`0000Com^gF00Co0000ooK]e_ofkMKo00001OofkMH0
1Ol0003om^gFooK]e_ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gF
o`000005ooK]eP07o`000?ofkMKom^gFooK]e_l0003om^gFo`000003ooK]eP04o`000?ofkMKom^gF
o`0000;om^gF00?o0000ooK]e_ofkMH00_ofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00?o
0000ooK]e_ofkMH01OofkMH00ol0003om^gFooK]eP03ooK]eP04o`000?ofkMKom^gFo`0000;om^gF
00Ko0000ooK]e_ofkMKo0000ooK]e_l00003ooK]eP03o`000?ofkMKom^gF00?om^gF00?o0000ooK]
e_l00000C_ofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^?Zom_LiOoKg>GoeMGQolo?
g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ofkMH5
o`0000Gom^gF0ol00005ooK]eP03o`000?ofkMKom^gF00;om^gF00Go0000ooK]e_ofkMKom^gFo`00
0003ooK]eP03o`000?ofkMKom^gF00Oom^gF00Co0000ooK]e_ofkMKo00000oofkMH01Ol0003om^gF
ooK]e_ofkMKo000000Gom^gF00?o0000ooK]e_ofkMH02OofkMH00ol0003om^gFooK]eP04ooK]eP03
o`000?ofkMKom^gF00com^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP04o`000?ofkMKom^gF
o`0000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH00ol0003om^gFooK]eP0;ooK]eP05o`000?of
kMKom^gFooK]e_l000000_ofkMH01_l0003om^gFooK]e_l0003om^gFo`0000?om^gF00Go0000ooK]
e_ofkMKom^gFo`000005ooK]eP03o`000?ofkMKom^gF00Wom^gF00?o0000ooK]e_ofkMH00oofkMH0
0ol0003om^gFo`00000<ooK]eP03o`000?ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo00000_of
kMH01?l0003om^gFooK]e_l00002ooK]eP04o`000?ofkMKom^gFo`0000com^gF00?o0000ooK]e_l0
00000_ofkMH01?l0003om^gFooK]e_l00002ooK]eP03o`000?ofkMKo000000?om^gF00Go0000ooK]
e_ofkMKom^gFo`000005ooK]eP03o`000?ofkMKom^gF00?om^gF00?o0000ooK]e_ofkMH00oofkMH0
1Ol0003om^gFooK]e_l0003om^gF00Co00000_ofkMH01Ol0003om^gFooK]e_l0003om^gF00Co0000
0_ofkMH01?l0003om^gFooK]e_ofkMH3o`0000;om^gF00?o0000ooK]e_ofkMH01?l000000oofkMKo
0000o`000007ooK]eP?o00001OofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00Co0000ooK]
e_ofkMKo00000_ofkMH4o`000003ooK]e_l0003o000000;o00001OofkMH01Ol0003om^gFooK]e_of
kMKo000000;om^gF00Co0000ooK]e_ofkMKo00000_ofkMH01Ol0003om^gFooK]e_l0003om^gF00Co
00000_ofkMH01Ol0003om^gFooK]e_l0003om^gF00;o00001?ofkMH00ol0003om^gFo`000003ooK]
eP04o`000?ofkMKom^gFo`0000;om^gF00?o0000ooK]e_ofkMH00ol00002ooK]eP03o`000?ofkMKo
m^gF00?om^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP03o`000?ofkMKo000000?om^gF00Co
0000ooK]e_ofkMKo00001OofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF00?o0000ooK]e_of
kMH01?ofkMH00ol0003om^gFooK]eP03ooK]eP?o000000?om^gFo`000?l000001oofkMH3o`0000Go
m^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP04o`000?ofkMKom^gFo`0000;om^gF00?o0000
ooK]e_l000001OofkMH01ol0003om^gFooK]e_ofkMKo0000ooK]e_l000000oofkMH01?l0003om^gF
ooK]e_l00002ooK]eP03o`000?ofkMKom^gF00;om^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]
eP03o`000?ofkMKom^gF00Gom^gF00?o0000ooK]e_ofkMH01?ofkMH3o`0000;om^gF00Ko0000ooK]
e_ofkMKo0000ooK]e_l00003ooK]eP03o`000?ofkMKom^gF00?om^gF00?o0000ooK]e_l00000C_of
kMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkL
oooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ofkMH5o`0000Gom^gF
00Co0000ooK]e_ofkMKo00001?ofkMH00ol0003om^gFooK]eP02ooK]eP05o`000?ofkMKom^gFooK]
e_l000000oofkMH00ol0003om^gFooK]eP05ooK]eP;o00000oofkMH01Ol0003om^gFooK]e_ofkMKo
000000?om^gF00?o0000ooK]e_ofkMH00oofkMH00ol0003om^gFooK]eP0:ooK]eP03o`000?ofkMKo
m^gF00?om^gF0_l0000=ooK]eP;o00000_ofkMH2o`000005ooK]e_l0003o0000ooK]e_l000000_of
kMH00ol0003om^gFooK]eP02o`000003ooK]e_l0003om^gF00com^gF0_l00002ooK]eP;o000000Go
m^gFo`000?l0003om^gFo`000002ooK]eP04o`000?ofkMKom^gFo`0000?om^gF0_l00003ooK]eP03
o`000?ofkMKom^gF00_om^gF00?o0000ooK]e_ofkMH00_ofkMH00ol0003om^gFo`00000<ooK]eP03
o`000?ofkMKo000000;om^gF0_l000001OofkMKo0000o`000?ofkMKo000000;om^gF00?o0000ooK]
e_ofkMH00_l000000oofkMKo0000ooK]eP0;ooK]eP03o`000?ofkMKo000000;om^gF0_l000001Oof
kMKo0000o`000?ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo00000oofkMH2o`0000?om^gF00?o
0000ooK]e_ofkMH01?ofkMH00ol0003om^gFooK]eP03ooK]eP06o`000?ofkMKom^gFo`000?ofkMKo
00000_ofkMH00ol0003om^gFooK]eP02o`000004ooK]e_l0003om^gFo`0000;om^gF00?o0000ooK]
e_ofkMH00_l000001OofkMKo0000ooK]e_ofkMKo000000;om^gF00Co0000ooK]e_ofkMKo00000_of
kMH00ol0003om^gFo`000002ooK]eP03o`000?ofkMKom^gF00;om^gF00Co0000ooK]e_ofkMKo0000
1OofkMH01?l0003om^gFooK]e_ofkMH2o`000004ooK]e_l0003om^gFooK]eP;o000000Oom^gFo`00
0?ofkMKom^gFo`000?ofkMKo000000;om^gF00?o0000ooK]e_ofkMH00oofkMH00ol0003om^gFooK]
eP02o`0000;om^gF00?o0000ooK]e_ofkMH00_l000001oofkMKo0000o`000?ofkMKo0000ooK]e_l0
00000_ofkMH00ol0003om^gFooK]eP02o`000004ooK]e_l0003om^gFo`0000;om^gF00Ko0000ooK]
e_ofkMKo0000ooK]e_l00003ooK]eP03o`000?ofkMKom^gF00;o000000Com^gFo`000?ofkMKo0000
0_ofkMH01?l0003om^gFooK]e_l00005ooK]eP;o00000_ofkMH01_l0003om^gFooK]e_l0003om^gF
o`0000?om^gF00Co0000ooK]e_ofkMKo00001OofkMH01Ol0003om^gFooK]e_ofkMKo000000;om^gF
00?o0000ooK]e_ofkMH01?ofkMH00ol0003om^gFooK]eP02ooK]eP06o`000?ofkMKom^gFo`000?of
kMKo00000_ofkMH00ol0003om^gFooK]eP02ooK]eP04o`000?ofkMKom^gFo`0000Gom^gF00Go0000
ooK]e_ofkMKom^gFo`000002ooK]eP03o`000?ofkMKom^gF00;o000000Com^gFo`000?ofkMKo0000
0_ofkMH01?l0003om^gFooK]e_l00003ooK]eP03o`000?ofkMKo000000?om^gF00?o0000ooK]e_of
kMH00_l000000oofkMKo0000ooK]eP03ooK]eP05o`000?ofkMKom^gFooK]e_l000000_ofkMH00ol0
003om^gFooK]eP05ooK]eP;o00001?ofkMH01?l0003om^gFooK]e_l00002ooK]eP;o000000Com^gF
o`000?ofkMKo00000_ofkMH2o`0000Gom^gF00?o0000ooK]e_l00000C_ofkMH01?o^kNGoU9FRoooo
ooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ofkMH5o`0000Gom^gF00Co0000ooK]e_ofkMKo
00001?ofkMH00ol0003om^gFooK]eP03ooK]eP?o00000oofkMH5o`0000Kom^gF00Co0000ooK]e_of
kMKo00000oofkMH01Ol0003om^gFooK]e_ofkMKo000000Com^gF0ol0000;ooK]eP03o`000?ofkMKo
m^gF00;om^gF0_l000000oofkMKo0000ooK]eP0:ooK]eP;o000000Gom^gFo`000?l0003o0000ooK]
eP02o`000004ooK]e_l0003o0000ooK]eP;o000000Com^gFo`000?l0003om^gF0_l0000<ooK]eP;o
000000Gom^gFo`000?l0003o0000ooK]eP02o`000003ooK]e_l0003o000000?om^gF0ol00002ooK]
eP;o000000Gom^gFo`000?ofkMKom^gFo`00000=ooK]eP04o`000?ofkMKom^gFooK]eP;o000000?o
m^gFo`000?ofkMH02_ofkMH2o`000003ooK]e_l0003om^gF00;o000000Com^gFo`000?l0003om^gF
0_l000001?ofkMKo0000o`000?ofkMH2o`000003ooK]e_l0003o000000_om^gF0_l000000oofkMKo
0000ooK]eP02o`000004ooK]e_l0003o0000ooK]eP;o00000oofkMH3o`0000;om^gF0_l000001Oof
kMKo0000ooK]e_ofkMKo000000Kom^gF00?o0000ooK]e_ofkMH01?ofkMH4o`000003ooK]e_l0003o
000000;om^gF0_l000000oofkMKo0000ooK]eP02ooK]eP;o00000_ofkMH2o`000003ooK]e_l0003o
m^gF00;o00000_ofkMH3o`0000;om^gF0_l00003ooK]eP?o00001OofkMH2o`0000Gom^gF0ol00002
ooK]eP03o`000?ofkMKo000000;om^gF0_l000000oofkMKo0000ooK]eP02o`0000?om^gF0_l00007
ooK]eP;o000000?om^gFo`000?ofkMH00_l000001OofkMKo0000o`000?ofkMKo000000;om^gF00Co
0000ooK]e_ofkMKom^gF0_l00002ooK]eP;o000000?om^gFo`000?ofkMH00_ofkMH3o`000003ooK]
e_l0003o000000;om^gF0ol00002ooK]eP;o000000?om^gFo`000?ofkMH00_ofkMH2o`0000?om^gF
00?o0000ooK]e_ofkMH00_ofkMH2o`000003ooK]e_l0003o000000?om^gF00?o0000ooK]e_ofkMH0
0ol00002ooK]eP?o00001OofkMH3o`0000;om^gF0ol00004ooK]eP?o00001?ofkMH2o`0000?om^gF
0ol00005ooK]eP;o00001OofkMH3o`000004ooK]e_l0003o0000ooK]eP;o000000Gom^gFo`000?l0
003om^gFo`000003ooK]eP?o000000Gom^gFo`000?l0003o0000ooK]eP02o`0000;om^gF0ol00002
ooK]eP;o000000?om^gFo`000?ofkMH01OofkMH3o`0000;om^gF0ol00005ooK]eP;o000000?om^gF
o`000?ofkMH00oofkMH2o`0000;om^gF0_l000000oofkMKo0000ooK]eP02ooK]eP;o000000?om^gF
o`000?ofkMH00oofkMH2o`000003ooK]e_l0003om^gF04gom^gF00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVORKom^gF00Co0000ooK]e_ofkMKo00001?ofkMH00ol0003om^gF
ooK]eP0:ooK]eP03o`000?ofkMKom^gF00?om^gF00Go0000ooK]e_ofkMKom^gFo`000002ooK]eP04
o`000?ofkMKom^gFo`0000Com^gF00?o0000ooK]e_ofkMH00oofkMH00ol0003om^gFooK]eP0:ooK]
eP03o`000?ofkMKom^gF04com^gF00?o0000ooK]e_ofkMH02oofkMH00ol0003om^gFooK]eP1<ooK]
eP03o`000?ofkMKom^gF00Com^gF00?o0000ooK]e_ofkMH08_ofkMH00ol0003om^gFooK]eP0FooK]
eP05o`000?ofkMKom^gFooK]e_l000006_ofkMH00ol0003om^gFooK]eP0`ooK]eP03o`000?ofkMKo
m^gF00[om^gF00?o0000ooK]e_ofkMH01_ofkMH00ol0003om^gFooK]eP0:ooK]eP03o`000?ofkMKo
m^gF00Com^gF00?o0000ooK]e_ofkMH06?ofkMH00ol0003om^gFooK]eP0BooK]eP03o`000?ofkMKo
m^gF01Wom^gF00?o0000ooK]e_ofkMH06_ofkMH00ol0003om^gFooK]eP1DooK]eP04onk]iOnDUJ;o
ooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhUooK]ePCo00001?ofkMH2o`0001?om^gF0ol0
0002ooK]ePCo00001OofkMH3o`0000Com^gF00?o0000ooK]e_l000002OofkMH00ol0003om^gFooK]
eP0PooK]eP03o`000?ofkMKom^gF02Wom^gF00?o0000ooK]e_ofkMH02oofkMH00ol0003om^gFooK]
eP0PooK]eP03o`000?ofkMKom^gF02Wom^gF00?o0000ooK]e_ofkMH00_ofkMH3o`0002Com^gF00?o
0000ooK]e_ofkMH05_ofkMH01Ol0003om^gFooK]e_ofkMKo000001[om^gF00?o0000ooK]e_ofkMH0
<?ofkMH00ol0003om^gFooK]eP0:ooK]eP03o`000?ofkMKom^gF00Kom^gF00?o0000ooK]e_ofkMH0
2_ofkMH01?l0003om^gFooK]e_l00004ooK]eP03o`000?ofkMKo000001Oom^gF00Co0000ooK]e_of
kMKo00004OofkMH00ol0003om^gFooK]eP0IooK]eP04o`000?ofkMKom^gFo`0001Wom^gF00?o0000
ooK]e_ofkMH0E?ofkMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQ
olo?gOo<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInF?of
kMH2o`0000[om^gF00?o0000ooK]e_ofkMH0B_ofkMH00ol0003om^gFooK]eP0=ooK]eP03o`000?of
kMKom^gF04[om^gF00?o0000ooK]e_ofkMH0A_ofkMH2o`0001Wom^gF0_l00002ooK]eP03o`000?of
kMKom^gF01Wom^gF00?o0000ooK]e_ofkMH04?ofkMH2o`0000_om^gF0_l0000FooK]eP?o00001Oof
kMH2o`0001Som^gF0ol0000EooK]eP03o`000?ofkMKom^gF01Kom^gF0ol0000HooK]eP;o0000E_of
kMH01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkL
oooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooofkMKoooK]eY;om^gF
00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?oo
ooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oom^gFooofkMJBooK]eP04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooK]e_oom^gFT_ofkMH01?o^
kNGoU9FRooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonD
UJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooofkMKoooK]eY;om^gF00Cok^gU
oiBEX_oooooomoOi0_o/k?42onSYkP0<on;Rj_oKg>GofmcUomCEhOo?cmgoc<gKolg>g?ooooooU9FR
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oom^gFooofkMJBooK]eP04onk]iOnD
UJ;oooooooOgn@;ok>ca0_oXjNh03?oRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_mV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooK]e_oom^gFT_ofkMH01?o^kNGoU9FR
ooooooogmoT2onc/l@;oj>W^00coh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooofkMKoooK]eY;om^gF00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oom^gFooofkMJBooK]eP04onk]iOnDUJ;ooooo
ooOgn@;ok>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooK]e_oom^gFT_ofkMH01?o^kNGoU9FRooooooog
moT2onc/l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInooofkMKoooK]eY;om^gF00Cok^gUoiBEX_oooooomoOi
0_o/k?42onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm
0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oom^gFooofkMJBooK]eP04onk]iOnDUJ;oooooooOgn@;o
k>ca0_oYj>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooK]e_oom^gFT_ofkMH01?o^kNGoU9FRooooooogmoT2onc/
l@;ojNS^00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoono/HgooknaSI;o_k6=00Cok^gUoiBEX_oooooomoOi0_o/k?42
onWXkP0<on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oomN2Zoooeh:ZBooGPZP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oY
j>h03?oSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn0000
1?mVIWkonocmojRY^omVIWkoooGPZ_oomN2ZT_oeh:X01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^
00cohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooeh:[oooGPZY;omN2Z00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<
on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVO_oomN2Zoooeh:ZBooGPZP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h03?oS
h^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkoooGPZ_oomN2ZT_oeh:X01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00cohn;Z
om_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoooeh:[oooGPZY;omN2Z00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0<on?Rj_oK
g>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oomN2Zoooeh:ZBooGPZP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcU
om_LiOoDeN3oc/oLolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY
^omVIWkoooGPZ_oomN2ZT_oeh:X01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoK
g>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVIn6ooeh:X00omgKE;o0000o`000002o`000003ogM]D_oeh:[omN2Z00ComN2Z00?oMfeBo`000?l0
00001?l000000omgKE;omN2ZooGPZP03ooGPZP05oj2CKom:A3?o0000ofAKAOnPTfl01_oeh:X01_oP
c9_oU8MWo`000?l0003oMfeBokn^Q0;omN2Z00?oim>Poj2CKomTFdD00_l000000om:A3?oU8MWomS5
UP03ooGPZP03ogM]D_l0003o000000?o000000?oMfeBokFVO_oeh:X0oooeh:[oooGPZSOomN2Z00Co
k^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?oooooo
U9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQ_omN2Z00?oMfeBo`000?l00000
0_l000000omgKE;omN2ZooGPZP04ooGPZP03ogM]D_l0003o000000Co000000KoMfeBooGPZ_oeh:[o
mN2ZonOCX?m:A3<5o`000003odY4<ooWdj3omN2Z00?omN2Z00?oI5]5o`000?l000000ol000000omg
KE;omN2ZodY4<`07o`000004olRgR_oeh:[omN2ZogM]DPOo000000?oX9=_ooGPZ_oeh:X0oooeh:[o
ooGPZSGomN2Z00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmco
c<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcomN2Z0_l0
000<ooGPZP;o00001_oeh:X02OnDQfOo0000ogM]D_oWdj3omN2ZonOCX?mgKE;o0000oiB7I`04ooGP
ZP;o000000Woim>PooGPZ_oPc9_oU8MWogM]D_oeh:[oMfeBoiB7IooWdj000_oeh:X01?oWdj3o]JIn
o`000?mTFdD3ooGPZP;o00000ooeh:X01?o@_Y3oBT@co`000?neYWkoooGPZ_oomN2Z=_oeh:X01?o^
kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonD
UJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?oeh:X2o`0000comN2Z0_l00006
ooGPZP;o00001Ooeh:X2o`0000ComN2Z0_l0000=ooGPZP;o00000ooeh:X2o`0000ComN2Z00?od;j@
o`000?mgKE80oooeh:[oooGPZSKomN2Z00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<on?Sj_oK
g>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVOQcomN2Z1Ol000000omgKE;ob;N:ooGPZP06ooGPZP;o00001_oeh:X00om:A3?o0000onOC
X003ooGPZP03onOCX?l0003oBT@c00ComN2Z0_l0000;ooGPZP04on3<VomgKE;o0000ogM]DP?omN2Z
0_l00005ooGPZP;o0000oooeh:[oooGPZSKomN2Z00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0<
on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVOQcomN2Z1ol000000oo8]h[omN2ZooGPZP04ooGPZP;o00001_oeh:X02OnPTfoo
0000ogM]D_oWdj3omN2ZonOCX?mgKE;o0000oj2CK`04ooGPZP;o00002Ooeh:X01_mgKE;o0000o`00
0?l0003oBT@con3<V`?omN2Z0_l00005ooGPZP;o0000oooeh:[oooGPZSKomN2Z00Cok^gUoiBEX_oo
oooomoOi0_o/k?42onWYkP0<on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOQcomN2Z0_l00003ooGPZP03okFVO_l0003oI5]5
00KomN2Z0_l00007ooGPZP03ogM]D_l0003o000000?o000000GoMfeBooGPZ_oeh:[omN2ZogM]DP06
o`000003ogM]D_oeh:[omN2Z00?omN2Z00?oMfeBo`000?l000000_l000001?o@_Y3omN2ZooGPZ_oe
h:X2o`0000GomN2Z0_l0003oooGPZ_oomN2Z=_oeh:X01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^
00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000Co
IVInoo_loOnXZK_oIVIn7?oeh:X2o`0000ComN2Z0_l00006ooGPZP;o00002?oeh:X01On[WGOoI5]5
o`000?mTFdGo]JIn00ComN2Z00?oMfeBo`000?l000001?l000000omgKE;omN2ZooGPZP06ooGPZP03
oj2CKol0003oI5]500?omN2Z0_l00004ooGPZP03okFVO_l0003oU8MW0?oomN2Zoooeh:XfooGPZP04
onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh03?oShn[ofmcUom_LiOoDeN3oc/oLolc=foo=c]cooooo
oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhLooGPZP;o00000ooeh:X00one
YWko0000ofAKA@06ooGPZP;o00004ooeh:X2o`0000gomN2Z0_l00003ooGPZP;o00000ooeh:X01?no
[XCo0000o`000?oHaIKoooGPZ_oomN2Z=_oeh:X01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00co
hn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVIn6ooeh:X00omgKE;o0000o`000005o`000003om2nT?oeh:[omN2Z00;omN2Z00Co
MfeBo`000?l0003o00004ooeh:X2o`0000OomN2Z0_mgKE801_oHaIKomN2ZooGPZ_neYWko0000ofAK
A@;omN2Z00?oMfeBo`000?l000001Ol000000on[WGOomN2ZooGPZP3oooGPZ_oomN2Z=Ooeh:X01?o^
kNGoU9FRooooooogmoT2onc/l@;ojNW^00cohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonD
UJ;oIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn6ooeh:X00omgKE;o0000o`000003
o`000003ogM]D_o@_Y3omN2Z00ComN2Z00CoMfeBo`000?l0003o00004ooeh:X2ogM]DPOomN2Z00?o
MfeBo`000?l000001?l000001?o@_Y3omN2ZooGPZ_mgKE85o`000003ohMkGOo@_Y3omN2Z0?oomN2Z
oooeh:XgooGPZP04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>l03?oRh^[ofm_Uom_KiOoDeN3oc]3M
olc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWi9ooGPZP06
okFVO_mgKE;o0000o`000?mgKE;od;j@oooeh:[oooGPZT?omN2Z00Cok^gUoiBEX_oooooomoOi0_o/
k?42onSYkP0<on?RjooKfnKofm_VomCEh?o>cmcoc<gKolg>g?ooooooU9FRofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVO_oomN2Zoooeh:ZBooGPZP04onk]iOnDUJ;oooooooOgn@;ok>ca
0_oYjNh03?oShn[ofm_Vom_Ki_oDeN3oc/oMolc=foo=c]cooooooiBEX_mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoooGPZ_oomN2ZT_oeh:X00oo^kNGoU9FRomKFf`0<ooooo`05omKF
fonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oomN2Zoooeh:ZBooGPZP03
onk]iOomoO[oT96O00Go]kNo00?o];BmokNg_ong]kl01?ng]kl01On@TIook^gUofIVO_nXZK_onocm
007oIVIn00001?mVIWkonocmojRY^omVIWkoooGPZ_oomN2ZT_oeh:X00oo^kNGok>gdoh^<V@0<oifN
Z`05ohZ;VOoSi^goIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oomN2Zoooeh:ZB
ooGPZP03onk]iOnDUJ;ogMkQ00cofM[T00GogMkQoiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVIn
oo_loOnXZK_oIVInoooeh:[oooGPZY;omN2Z00?ok^gUoiBEX_ooool03?o;c=X01OooooooU9FRofIV
O_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooGPZ_oomN2ZT_oeh:X00oo^kNGoU9FR
ooooo`0<ol_<fP05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oo
mN2Zoooeh:ZBooGPZP03onk]iOnDUJ;ooooo00coblcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooeh:[oooGPZY;omN2Z00?ok^gUoiBEX_ooool03?o;c=X01Ooo
ooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooGPZ_oomN2ZT_oeh:X0
0oo^kNGoU9FRooooo`02ol_<fP03oclm?Oo;c=[oblcJ00?oblcJ00Wo?cdmol_<f_o;c=[oblcJoooo
oonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oomN2Zoooeh:ZBooGPZP04
onk]iOnDUJ;oooooolc=f`?o?cdm0oo<cM/3oclm?@;oc<gK00GooooooiBEX_mVIWkoZ:Vkoo_lo@01
ofIVOP0000CoIVInoo_loOnXZK_oIVInoooeh:[oooGPZY;omN2Z00?ok^gUoiBEX_ooool00_oAd^03
oclm?@04om7Bh?lo?Cgo?cdmoclm?@?odM;P00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000Co
IVInoo_loOnXZK_oIVInoooeh:[oooGPZY;omN2Z00?ok^gUoiBEX_ooool00ooIf^@5oclm?@CofM[T
00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooeh:[oooGPZY;o
mN2Z00?ok^gUoiBEX_ooool01?oShn/3oclm?@Gohn?[00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooeh:[oooGPZY;omN2Z00?ok^gUoiBEX_ooool01Oo/k?400olo
?Cgok>caonc/l@04onc/l@05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:Vk
ofIVO_oomN2Zoooeh:ZBooGPZP03onk]iOnDUJ;ooooo00com?Cg00GooooooiBEX_mVIWkoZ:Vkoo_l
o@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooeh:[oooGPZY;omN2Z00?ok^gUoiBEX_ooool03?ok
o?`01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoooGPZ_oomN2Z
T_oeh:X00oo^kNGoU9FRooooo`0=ooooo`04oiBEX_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooGPZ_oomN2ZT_oeh:X00oo^kNGoU9FRomKFf`0<ooooo`05omKFfonDUJ;oIVInojRY
^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oomN2Zoooeh:ZBooGPZP05onk]iOoFfmWoSi2N
okFe__nd];h01Ond];d02_nc];go];Bmok>d_Ond];go/k>mohb=W?oFfmWoIVInojRY^ooko?d1ofIV
OP0000GoIVInoo_loOnXZK_oIVInoi6KW03oog5_I?ooLFmTXOmaKf@01?nAVicoIVInojRY^ooko?d1
ofIVOP0000GoIVInoo_loOnXZK_oIVInoi6KW03oon3Ohoooh=oSTOoPgn<00ooakn;oWIfQoifMX@0<
oifMX@05og5_I?nAVicoIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nAVi`0oooP
gn?oon3Ohi7oh=oS00?olNoRoooooooPgn<02ooPgn<01_nMWJ7oLFmToi6KW?mVIWkoZ:Vkoo_lo@7o
IVIn00001OmVIWkonocmojRY^omVIWkoTI^L0?ooh=oSoooPgn>Aon3Oh`03oo7_h_oooooooooo00_o
oooo00KoWIfQog5_I?nAVicoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInoi6KW03o
on3Ohoooh=oSTOoPgn<?oo7_hP05og5_I?nAVicoIVInojRY^ooko?d00OmVIWh00006ofIVO_oko?go
Z:VkofIVO_nAVicoooooooolo?kooocloYooo?cn00Gooooooi6KW?mVIWkoZ:Vkoo_lo@01ofIVOP00
00CoIVInoo_loOnXZK_oIVInY_moWKT2oocloZKoOifi0_olo?jVognM^@;oo?cnZOmoWKT00omVIWko
Z:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@2Tooooo`04ognM^Oolo?koo?cnognM
^JCooooo00CoOifiooclo_olo?koOifiY?ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmV
IWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi00?ooooo00?o0000ooooool00000
0_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00Ko0000oooooooooooo
ooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000oooool00ol0003oooooo`000003oooo
o`05o`000?oooooo0000ooooool000000_ooool01Ol0003ooooooooooooooooo000005Oooooo0ol0
0003ooooo`03onk]iOo/kOCoRhbI00coWIj[00CoRX^Ion?VkOooooooOifi0_olo?h01OmoWKWooooo
oooooooooooo000000Kooooo00Ko0000ooooooooooooooooo`000?ooool2o`000006ooooool0003o
ooooooooool0003ooooo0_l00002ooooo`05o`000?oooooo0000ooooool000000oooool00ol0003o
ooooo`000003ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000oooool00ol0003o
ooooo`000003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool0B?ooool3o`0000?o
oooo00?ok^gUonc]m?n;S9T03?nMWZ/01?n:RiWohnK]oooooomoWKT2oocloP03ognM^Ooooooooooo
0:;ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVIn
oo_loOnXZK_oIVInognM^@03ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool00ol0
00001?oooooo0000o`000?l00002ooooo`?o00000_ooool01?l0003oooooo`000?l00003ooooo`?o
00000oooool3o`0000;ooooo00Co0000oooooooooooo00000_ooool3o`0005Sooooo0_l00004oooo
o`03onk]iOnDUJ;ogMkQ00cofM[T00CogMkQoiBEX_ooooooOifi0_olo?h01OmoWKWooooooooooooo
oooo000000Oooooo0ol00002ooooo`03o`000?oooooo000000?o00000_ooool01?l0003oooooo`00
0?l00002ooooo`03o`000?oooooo000000?o00000oooool3o`000006ooooool0003o0000o`000?oo
oooo00000_ooool3o`0000;ooooo1?l00003ooooo`?o0000Boooool2o`0000Cooooo00?ok^gUoiBE
X_oMg^403?oIf^@01?oMg^7oU9FRoooooomoWKT2oocloP03ognM^Ooooooooooo0:;ooooo00CoOifi
ooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVIn
ognM^@03ooooo`;o00000oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`1Nooooo`03o`000?oooooooooo00?ooooo
00?ok^gUoiBEX_ooool03?o;c=X01?ooooooU9FRoooooomoWKT2oocloP03ognM^Ooooooooooo00;o
oooo00Go0000ooooooooooooooooo`00000?ooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0GOooool00ol0003oooooooooo`03ooooo`03onk]iOnDUJ;ooooo00coblcJ00CooooooiBE
X_ooooooOifi0_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo00Co
OifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_moWKT00oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo06Cooooo00?ok^gUoiBEX_ooool03?o;c=X01?ooooooU9FR
oooooomoWKT2oocloP03ognM^Ooooooooooo00?ooooo0ol0000@ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool02oooool01?l0003oooooooooool0001Rooooo`03onk]iOnDUJ;ooooo
00coblcJ00CooooooiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Oolo?ko
o?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_moWKT0
T_ooool00oo^kNGoU9FRooooo`0<ol_<fP04oooooonDUJ;oooooognM^@;oo?cn00?oOifioooooooo
ool0T?ooool00oo^kNGoU9FRooooo`0<ol_<fP04oooooonDUJ;oooooognM^@;oo?cn00?oOifioooo
ooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn0000
1OmVIWkonocmojRY^omVIWkoOifi09;ooooo00?ok^gUoiBEX_ooool01Oo;c=X00olo?CgoblcJol_<
fP04ol_<fP04oooooonDUJ;oooooognM^@;oo?cn00?oOifiooooooooool0T?ooool00oo^kNGoU9FR
ooooo`05ol_<fP03oclm?Oo;c=[oblcJ00CoblcJ00CooooooiBEX_ooooooOifi0_olo?h00omoWKWo
ooooooooo`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh0
0005ofIVO_oko?goZ:VkofIVO_moWKT0T_ooool00oo^kNGoU9FRooooo`04ol_<fP?o?cdm1Oo;c=X0
1?ooooooU9FRoooooomoWKT2oocloP03ognM^Ooooooooooo093ooooo00?ok^gUoiBEX_ooool01?o;
c=X3oclm?@GoblcJ00CooooooiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`2Rooooo`04ognM
^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIV
O_moWKT0T_ooool00oo^kNGoU9FRooooo`03olc=f`Go?cdm1?o<cM/01?ooooooU9FRoooooomoWKT2
oocloP03ognM^Ooooooooooo093ooooo00?ok^gUoiBEX_ooool00oo<cM/5oclm?@Coc<gK00Cooooo
oiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo
00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_moWKT02oooool00ol0003o
ooooooooo`0eooooo`03o`000?oooooooooo04cooooo00?ok^gUoiBEX_ooool00_oAd^03oclm?@04
om7Bh?lo?Cgo?cdmoclm?@?odM;P00CooooooiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`2@
ooooo`03onk]iOnDUJ;ooooo00;odM;P0olo?Cd01?oAd^3o?cdmoclm?Olo?Cd3om7Bh004oooooonD
UJ;oooooognM^@;oo?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04
ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi00_ooooo00?o0000oooo
ooooool0=Oooool00ol0003oooooooooo`1<ooooo`04onk]iOnDUJ;oooooomWJi0?o?cdm0ooIf^@3
oclm?@;ofM[T00CooooooiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`2@ooooo`04onk]iOnD
UJ;oooooomWJi0?o?cdm0ooIf^@3oclm?@;ofM[T00CooooooiBEX_ooooooOifi0_olo?h00omoWKWo
ooooooooo`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh0
0005ofIVO_oko?goZ:VkofIVO_moWKT00oooool00ol0003oooooo`000003ooooo`04o`000?oooooo
0000ooooo`;o00000oooool2o`000003ooooool0003ooooo00;o00001Oooool2o`000004ooooool0
003oooooo`0000?ooooo00?o0000ooooooooool00_l000000ooooooo0000ooooo`05ooooo`?o0000
1?ooool2o`000003ooooool0003ooooo00;o000000?oooooo`000?ooool00_l00003ooooo`;o0000
00?oooooo`000?ooool00_l00011ooooo`03onk]iOnDUJ;ooooo00;ohn?[00?o?cdmon?SjooShn/0
0ooShn/02?lo?Cgohn?[on?SjooShn_ooooooiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`02
ooooo`Co00000oooool3o`0000?ooooo0_l000001?oooooo0000ooooool00003ooooo`03o`000?oo
oooooooo00;o000000?oooooo`000?ooool01Oooool3o`0000Cooooo0ol00002ooooo`05o`000?oo
ooooooooooooool000000_ooool3o`0000;ooooo00?o0000ooooooooool00_ooool2o`000003oooo
ool0003ooooo00;o000000Coooooo`000?oooooooooo0ol00002ooooo`05o`000?oooooooooooooo
ool00000>Oooool00oo^kNGoU9FRooooo`02on?Sj`03oclm?OoShn_ohn?[00?ohn?[00So?cdmon?S
jooShn_ohn?[oooooonDUJ;oooooognM^@;oo?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cn
ooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi
00?ooooo00?o0000ooooool000000oooool01?l0003oooooo`000?l00002ooooo`03o`000?oooooo
000000;ooooo0_l000000ooooooo0000ooooo`04ooooo`03o`000?oooooooooo00;o000000?ooooo
o`000?ooool00_ooool00ol0003oooooo`000002ooooo`;o00001Oooool01Ol0003ooooooooooooo
oooo000000;ooooo00?o0000ooooooooool00_l000001?oooooo0000ooooooooool2o`0000;ooooo
00?o0000ooooool000000_ooool2o`000003ooooool0003ooooo047ooooo00?ok^gUoiBEX_ooool0
3?o/k?401?ooooooU9FRoooooomoWKT2oocloP05ognM^Oooooooooooooooool000001?ooool00ol0
003oooooo`000003ooooo`03o`000?oooooo000000;ooooo0_l000000ooooooo0000ooooo`02oooo
o`03o`000?oooooo000000;ooooo0_l00005ooooo`05o`000?ooooooooooooooool000000_ooool0
1ol0003ooooooooooooooooo0000ooooool000000oooool00ol0003oooooo`000003ooooo`03o`00
0?oooooo000000?ooooo00?o0000ooooooooool00_l000001ooooooo0000oooooooooooo0000oooo
ool000000oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo03Oooooo00?ok^gUoiBE
X_ooool03?o/k?401?ooooooU9FRoooooomoWKT2oocloP03ognM^Ooooooooooo0:;ooooo00CoOifi
ooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVIn
ognM^@03ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000000oooool00ol0003ooooo
o`000003ooooo`03o`000?oooooo000000Gooooo00Oo0000ooooooooooooooooo`000?oooooo0000
00?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooool000000oooool00ol0003oooooo`000002ooooo`07o`000?oooooooooo
ooooool0003oooooo`000003ooooo`03o`000?oooooo000003cooooo00?o0000ooooooooool00ooo
ool00oo^kNGoU9FRooooo`0<ooCdm`04oooooonDUJ;oooooognM^@;oo?cn00?oOifiooooooooool0
1_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool00000
0oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0oooool00ol0003oooooo`000005ooooo`07o`000?ooooooooooooooool0003oooooo`000005oooo
o`05o`000?ooooooooooooooool000000oooool00ol0003oooooo`000002ooooo`03o`000?oooooo
000000?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`0aooooo`03o`000?oooooo
oooo00?ooooo00?ok^gUoiBEX_ooool03?odm?L01?ooooooU9FRoooooomoWKT2oocloP03ognM^Ooo
oooooooo0:;ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIVOP00
00GoIVInoo_loOnXZK_oIVInognM^@03ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool0
00000oooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000Kooooo1?l000000ooooooo
0000ooooo`02ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000000_ooool01ol0003o
oooooooooooooooo0000ooooool000000oooool00ol0003oooooo`00000looooo`;o00001?ooool0
0oo^kNGoU9FRooooo`0<oo_lo004oooooonDUJ;oooooognM^@;oo?cn00?oOifiooooooooool01?oo
ool2o`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o0000ooooool0
00000oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooo
oooooooo0ol000000ooooooo0000o`000003o`000003ooooool0003ooooo00;ooooo00?o0000oooo
ool000001?l000000ooooooo0000ooooo`03ooooo`Co000000Ooooooo`000?ooooooooooo`000?oo
oooo000000?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`0aooooo`;o00001?oo
ool00oo^kNGoU9FRooooo`0<oo_lo004oooooonDUJ;oooooognM^@;oo?cn00?oOifiooooooooool0
X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWko
nocmojRY^omVIWkoOifi00?ooooo00?o0000ooooool000000oooool01?l0003oooooo`000?l00002
ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000001Oooool01ol0003ooooooooooooo
oooo0000ooooool000000oooool00ol0003oooooo`000002ooooo`;o00001?ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000000_ooool2o`0000;ooooo
00?o0000ooooool000000oooool00ol0003oooooo`00000looooo`?o00000oooool00oo^kNGoU9FR
ooooo`0=ooooo`03oiBEX_ooooooOifi00;oo?cn00?oOifiooooooooool00_ooool2o`0000Cooooo
00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o0000ooooool000000oooool00ol0
003oooooo`000002ooooo`;o00001?ooool00ol0003oooooooooo`05ooooo`07o`000?oooooooooo
ooooool0003oooooo`000003ooooo`03o`000?oooooo000000?ooooo00Co0000ooooool0003o0000
0_ooool01ol0003ooooooooooooooooo0000ooooool000000_ooool00ol0003oooooo`000003oooo
o`03o`000?oooooo000000?ooooo00?o0000ooooooooool0<Oooool3o`0000?ooooo00?ok^gUoiBE
X_ooool03Oooool00onDUJ;oooooognM^@02oocloP03ognM^Ooooooooooo0:;ooooo00CoOifioocl
o_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM
^@03ooooo`03o`000?oooooo000000?o00000_ooool01?l0003oooooo`000?l00002ooooo`04o`00
0?ooooooooooooooo`Co00001Oooool3o`0000;ooooo1?l00003ooooo`;o000000?oooooo`000?oo
ool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000?ooooo1?l000000ooooooo
0000ooooo`02o`0000;ooooo00Co0000oooooooooooooooo1?l0000kooooo`;o00001?ooool00oo^
kNGoU9FRomKFf`0<ooooo`04omKFfonDUJ;oooooognM^@;oo?cn00GoOifiooooooooooooooooo`00
0007ooooo`?o00000_ooool01_l0003ooooooooooooooooo0000ooooo`Co00000oooool2o`000003
ooooool0003ooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03o`0000;o
oooo1?l00003ooooo`?o00000_ooool00ol0003oooooo`000002ooooo`?o000000Koooooo`000?l0
003o0000ooooool00002ooooo`?o00000_ooool4o`0003Cooooo0_l00004ooooo`03onk]iOnDUJ;o
e]KK00cooooo00Coe]KKoiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Ool
o?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_mo
WKT00oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool00oooool01Ol0003ooooooooooooooooo000000Sooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`0jooooo`03o`000?oooooooooo00?ooooo00Gok^gUomKKfOn?T9ko]KFnokBd_P05
okBd_@09ok>d_Ond];go/kBmokBd_Onc/kgoS8fLomKKfOooooooOifi00;oo?cn00GoOifioooooooo
ooooooooo`000004ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool00oooool01Ol0
003ooooooooooooooooo000001kooooo00?o0000ooooooooool0@?ooool00ol0003oooooooooo`03
ooooo`05onk]iOoFfmWoSi2NokFe__nd];h01Ond];d02Onc];go];Bmok>d_Ond];go/k>mohb=W?oF
fmWoooooognM^@02oocloP03ognM^Ooooooooooo0:;ooooo00CoOifiooclo_olo?koOifiYoooool0
1?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@03ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`?o00002Ooo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo043ooooo00[oiNK^onc^loo/koCok^od
ono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT0
0_olo?h00omoWKWoooooooooo`02ooooo`Co00006?ooool00ol0003oooooooooo`04ooooo`?o0000
7oooool01?l0003oooooooooool00015ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmood
mOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifioooo
ooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn0000
1OmVIWkonocmojRY^omVIWkoOifi09;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCe
nOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWooooo
ooooo`2@ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oo
n_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0X_ooool01?moWKWo
o?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWko
Oifi09;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01ooj
n_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2@ooooo`0:onGVk_o/
k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGV
k_ooooooOifi00;oo?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04
ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi09;ooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^
oooooomoWKT00_olo?h00omoWKWoooooooooo`2@ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?o
Oifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7o
IVIn00001OmVIWkonocmojRY^omVIWkoOifi09;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKo
lo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omo
WKWoooooooooo`2@ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;o
nOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0X_ooool0
1?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY
^omVIWkoOifi01?ooooo1?l0000Tooooo`Co0000Doooool02_oUi^kok>kconc_m?o^koCoko3eoo3a
m_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM^@02oocloP03
ognM^Ooooooooooo023ooooo00?o0000ooooooooool0KOooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM^@02oocl
oP03ognM^Ooooooooooo0:;ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ook
o?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@0Gooooo`03o`000?oooooooooo02Gooooo00?o
0000ooooooooool0D?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2
ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM^@02oocloP03ognM^Ooooooooooo027ooooo
00?o0000ooooooooool0K?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOoh
n?/2ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM^@02oocloP03ognM^Ooooooooooo0:;o
oooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_l
oOnXZK_oIVInognM^@03ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool3
o`0000?ooooo0_l000001?oooooo0000ooooool00004ooooo`;o000000Coooooo`000?oooooo0000
0_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00So0000oooooooooooo0000ooooool0
003oooooo`0000?ooooo00?o0000ooooooooool00_l000000ooooooo0000ooooo`1Aooooo`0:onGV
k_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_n
onGVk_ooooooOifi00;oo?cn00CoOifioooooooooooooooo1?l00004ooooo`?o00000_ooool01Ol0
003ooooooooooooooooo000000;ooooo0ol00002ooooo`04o`000?oooooo0000o`0000?ooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o00000_oo
ool2o`0000;ooooo0ol0001Cooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0
X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWko
nocmojRY^omVIWkoOifi00?ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo
000000?ooooo00?o0000ooooool000000_ooool2o`000003ooooool0003ooooo00;ooooo00?o0000
ooooooooool00_l000001Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooool000000_oo
ool02?l0003oooooooooool0003oooooo`000?oooooo00000oooool00ol0003oooooo`000002oooo
o`;o0000D_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`07
oo[joOoknokono_noo_ko_oUi^koooooognM^@02oocloP05ognM^Oooooooooooooooool000000ooo
ool01?l0003oooooooooool00003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool00000
0oooool01Ol0003oooooo`000?oooooo000000Cooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000000_ooool01Ol0003o
oooooooooooooooo000005;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2R
ooooo`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_ok
o?goZ:VkofIVO_moWKT00oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool0
00000oooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000?ooooo00Oo0000oooooooo
ooooooooo`000?oooooo000000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`08o`00
0?ooooooooooo`000?oooooo0000ooooool00003ooooo`03o`000?oooooo000000?ooooo00?o0000
ooooooooool0B_ooool00ol0003oooooooooo`03ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00Go
Oifiooooooooooooooooo`000004ooooo`03o`000?oooooo000000Gooooo00Go0000oooooooooooo
ooooo`000004ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooo`000005
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000oooool00ol0003oooooo`000005
ooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool00oooool02_oUi^kok>kconc_m?o^
koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM
^@02oocloP03ognM^Ooooooooooo0:;ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVIn
ojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@03ooooo`Co00000_ooool01Ol0003o
oooooooooooooooo000000?ooooo00?o0000ooooool000000oooool00ol0003oooooo`000004oooo
o`Co000000Goooooo`000?ooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo00So0000
oooooooooooo0000ooooool0003oooooo`0000?ooooo00?o0000ooooool000000oooool00ol0003o
ooooooooo`1:ooooo`;o00001?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM^@02oocloP05ognM^Ooooooooooo
ooooool000001?ooool00ol0003oooooo`000004o`000003ooooool0003ooooo00;ooooo00?o0000
ooooooooool00_l00003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000001Oooool4
o`0000;ooooo00?o0000ooooool000000oooool00ol0003oooooo`000003ooooo`;o0000C_ooool2
o`0000Cooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01ooj
n_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Ool
o?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_mo
WKT00oooool01_l0003ooooooooooooooooo0000ooooo`;o00000_ooool01ol0003ooooooooooooo
oooo0000ooooool000000_ooool2o`000003ooooool0003o000000;ooooo00Ko0000oooooooooooo
ooooo`000?ooool2o`000006ooooool0003oooooooooool0003ooooo0_l000002Ooooooo0000oooo
oooooooo0000ooooool0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo0_l0001<oooo
o`?o00000oooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`07
oo[joOoknokono_noo_ko_oUi^koooooognM^@02oocloP05ognM^Oooooooooooooooool000001?oo
ool00ol0003oooooo`000003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000000ooo
ool01Ol0003oooooo`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000004ooooo`09
o`000?ooooooooooooooool0003oooooo`000?oooooo000000?ooooo00?o0000ooooool000000_oo
ool01Ol0003ooooooooooooooooo000004cooooo0ol00003ooooo`0:onGVk_o/k_?ok>odonk_m?o_
l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;o
o?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vk
oo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi00?ooooo00Wo0000ooooooooooooooooo`00
0?oooooo0000ooooool000000_ooool3o`0000?ooooo0_l000001_oooooo0000ooooool0003ooooo
o`0000;ooooo0ol00002ooooo`03o`000?oooooo000000?o00000_ooool00ol0003oooooo`000003
o`0000;ooooo00?o0000ooooool000000ol00003ooooo`;o000000?oooooo`000?ooool0Boooool2
o`0000Cooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01ooj
n_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h01OmoWKWooooooooooooooooo000000Cooooo
00?o0000ooooooooool00ol00002ooooo`Co00000oooool3o`0000;ooooo1?l000000ooooooo0000
ooooo`02ooooo`03o`000?oooooooooo00;ooooo00Oo0000ooooooooooooooooo`000?oooooo0000
00;ooooo0ol000001?oooooo0000o`000?l00002ooooo`?o0000COooool2o`0000Cooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_oknoko
iNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo
00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_moWKT00oooool01Ol0003o
oooooooooooooooo000008Cooooo00?o0000ooooooooool00oooool02_oUi^kok>kconc_m?o^koCo
ko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM^@02
oocloP05ognM^Oooooooooooooooool000000oooool00ol0003oooooooooo`0Dooooo`03o`000?oo
oooooooo00Wooooo00Oo0000ooooooooooooooooo`000?oooooo000000Oooooo00?o0000oooooooo
ool0DOooool00ol0003oooooooooo`03ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmood
mOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifioooo
ooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn0000
1OmVIWkonocmojRY^omVIWkoOifi00?ooooo1?l0000/ooooo`03o`000?oooooooooo05cooooo00[o
iNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_ok
nokoiNK^oooooomoWKT00_olo?h01?moWKWoooooooooooooool4o`0001Gooooo00?o0000ooooool0
00002oooool4o`0000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1Gooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknoko
no_nonGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVW
ooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi09;ooooo00[o
iNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_ok
nokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2@ooooo`0:onGVk_o/k_?ok>odonk_m?o_
l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;o
o?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vk
oo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi09;ooooo00[oiNK^onc^loo/koCok^odono`
mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT00_ol
o?h00omoWKWoooooooooo`2@ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0
X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWko
nocmojRY^omVIWkoOifi09;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2@
ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_k
o_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cnoocl
o_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi09;o
oooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_n
oo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2@ooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_oooooo
Oifi00;oo?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmV
IWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi00;oooooSonMWJ402oooooooiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk00;onOWk00Oon_[moo_ko_oknokono_n
onGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0T?ooool02_oUi^kok>kconc_m?o^koCoko3e
oo3am_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM^@02oocl
oP03ognM^Ooooooooooo0:;ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ook
o?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@2Booooo`0:onGVk_o/k_?ok>odonk_m?o_l?Go
l?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn
00?oOifiooooooooool0T?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOoh
n?/2ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM^@02oocloP03ognM^Ooooooooooo0:;o
oooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000KoIVInoo_l
oOnXZK_oIVInognM^OoooonAok:d_`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0
0oooool3o`0000?ooooo0ol00002ooooo`06o`000?ooooooooooooooool0003ooooo0_l00002oooo
o`?o00000oooool2o`000004ooooool0003oooooo`0000Kooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`03o`0000;ooooo0_l00002ooooo`?o0000DOooool02_oUi^kok>kconc_m?o^
koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_noo_ko_oUi^koooooognM
^@02oocloP03ognM^Ooooooooooo0:;ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVIn
ojRY^ooko?d1ofIVOP0000KoIVInoo_loOnXZK_oIVInognM^OoooolDok:d_`03o`000?nb];oo/[Bo
07[o/[Bo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_go
no_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`02ooooo`07o`000?oooooo
ooooooooool0003oooooo`000003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool00000
0_ooool01ol0003ooooooooooooooooo0000ooooool000000_ooool2o`000003ooooool0003ooooo
00Gooooo00?o0000ooooooooool00oooool00ol0003oooooo`000003ooooo`03o`000?oooooo0000
00;ooooo00Go0000ooooooooooooooooo`00001@ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7f
oo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?o
Oifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7o
IVIn00001_mVIWkonocmojRY^omVIWkoOifioooooaCo/[Bo00?o0000ok:d_onb];l0N_nb];l02_oU
i^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_noo_k
o_oUi^koooooognM^@02oocloP05ognM^Oooooooooooooooool000001_ooool01ol0003ooooooooo
oooooooo0000ooooool000000oooool00ol0003oooooo`000002ooooo`07o`000?oooooooooooooo
ool0003oooooo`000003ooooo`03o`000?oooooo000000Kooooo00?o0000ooooooooool00oooool0
0ol0003oooooo`000003ooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool0BOooool0
0ol0003oooooooooo`03ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooSh
n`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0X_oo
ool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001_mVIWkonocm
ojRY^omVIWkoOifiooooo`Co/[Bo0ol00003ok:d_`03o`000?nb];oo/[Bo00;o/[Bo0_l000001Onb
];oo0000ok:d_ol0003o/[Bo00;o00000_nb];l01ol0003o/[Book:d_onb];oo0000ok:d_ol00000
0_nb];l3o`0000?o/[Bo0ol00006ok:d_`;o000000Co/[Boo`000?nb];oo00000onb];l00ol0003o
/[Book:d_`02o`000003ok:d_ol0003o/[Bo00Co/[Bo1?l00003ok:d_`?o00000onb];l2o`000004
ok:d_ol0003o/[Boo`0000?o/[Bo00?o0000ok:d_onb];l00_l000000onb];oo0000ok:d_`0/ok:d
_`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_ok
nokono_nonGVk_ooooooOifi00;oo?cn00GoOifiooooooooooooooooo`000006ooooo`07o`000?oo
ooooooooooooool0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00Oo0000oooooooo
ooooooooo`000?oooooo000000?ooooo00?o0000ooooool000001_ooool4o`0000;ooooo00?o0000
ooooool000000oooool00ol0003oooooo`000003ooooo`;o0000C?ooool2o`0000Cooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_oknoko
iNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo
00CoOifiofIVO_nXZK_onocm0OmVIWh00006ofIVO_oko?goZ:VkofIVO_moWKWooooo0onb];l01Ol0
003o/[Book:d_onb];oo000000;o/[Bo00Go0000ok:d_onb];oo/[Boo`000002ok:d_`;o000000?o
/[Boo`000?l000000_nb];l00ol0003o/[Boo`000003ok:d_`05o`000?nb];oo0000ok:d_ol00000
0onb];l00ol0003o/[Boo`000003ok:d_`03o`000?nb];oo/[Bo00;o/[Bo00?o0000ok:d_onb];l0
0_l000000onb];oo0000ok:d_`02ok:d_`03o`000?nb];oo000000;o/[Bo0_l00004ok:d_`03o`00
0?nb];oo/[Bo00;o/[Bo00?o0000ok:d_ol000000onb];l00ol0003o/[Boo`000002ok:d_`;o0000
00?o/[Boo`000?nb];l00_nb];l00ol0003o/[Boo`000002ok:d_`;o0000;Onb];l02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_noo_ko_oUi^ko
ooooognM^@02oocloP05ognM^Oooooooooooooooool000001_ooool01ol0003ooooooooooooooooo
0000ooooool000000oooool00ol0003oooooo`000002ooooo`07o`000?ooooooooooooooool0003o
ooooo`000003ooooo`04o`000?oooooo0000o`0000Gooooo00Wo0000ooooooooooooooooo`000?oo
oooo0000ooooool000000oooool00ol0003oooooo`000002ooooo`05o`000?ooooooooooooooool0
0000B_ooool3o`0000?ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk
0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2Roooo
o`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00006ofIVO_oko?go
Z:VkofIVO_moWKWooooo0_nb];l00ol0003o/[Book:d_`03ok:d_`03o`000?nb];oo000000?o/[Bo
00Oo0000ok:d_onb];oo/[Boo`000?nb];oo000000?o/[Bo00?o0000ok:d_ol000000onb];l01Ol0
003o/[Boo`000?nb];oo000000So/[Bo00?o0000ok:d_onb];l00onb];l01ol0003o/[Book:d_onb
];oo0000ok:d_ol000000onb];l00ol0003o/[Boo`000003ok:d_`03o`000?nb];oo/[Bo00Oo/[Bo
00?o0000ok:d_ol000000onb];l00ol0003o/[Boo`000003ok:d_`03o`000?nb];oo000000?o/[Bo
00?o0000ok:d_ol000000onb];l00ol0003o/[Book:d_`0Uok:d_`03o`000?nb];oo/[Bo00?o/[Bo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_k
o_oknokoiNK^oooooomoWKT00_olo?h01OmoWKWooooooooooooooooo000000Oooooo0ol00002oooo
o`Co000000Coooooo`000?l0003o00000_ooool3o`0000;ooooo00Wo0000ooooooooooooooooo`00
0?oooooo0000ooooool000001?ooool01ol0003ooooooooooooooooo0000ooooool000000_ooool3
o`000004ooooool0003o0000o`0000;ooooo0ol0001;ooooo`;o00001?ooool02_oUi^kok>kconc_
m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_noo_ko_oUi^kooooo
ognM^@02oocloP03ognM^Ooooooooooo0:;ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWo
IVInojRY^ooko?d1ofIVOP0000KoIVInoo_loOnXZK_oIVInognM^Oooool2ok:d_`04o`000?nb];oo
/[Book:d_`?o000000?o/[Boo`000?nb];l00onb];l4o`000003ok:d_ol0003o/[Bo00;o/[Bo00?o
0000ok:d_ol000000onb];l01Ol0003o/[Boo`000?nb];oo000000Ko/[Bo0_l00007ok:d_`Co0000
00?o/[Boo`000?nb];l00_nb];l00ol0003o/[Boo`000003ok:d_`03o`000?nb];oo/[Bo00Go/[Bo
0_l00002ok:d_`07o`000?nb];oo/[Book:d_ol0003o/[Boo`000003ok:d_`03o`000?nb];oo0000
00?o/[Bo00?o0000ok:d_ol000000onb];l00ol0003o/[Book:d_`0Uok:d_`;o00001?nb];l00oo^
kNGokO3boh^<VP05oifN[003oifNZonMWZcoWIj/00?oWIj/00GoWIn/ohf?Voo^kNGoooooognM^@02
oocloP03ognM^Ooooooooooo00;ooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`000?oo
oooooooo01?ooooo00Oo0000ooooooooooooooooo`000?oooooo000000Oooooo00?o0000oooooooo
ool0Coooool00ol0003oooooooooo`03ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmood
mOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifioooo
ooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn0000
1_mVIWkonocmojRY^omVIWkoOifiooooo`;o/[Bo00?o0000ok:d_onb];l01Onb];l2o`0000;o/[Bo
00Ko0000ok:d_onb];oo/[Boo`000?nb];l2o`0000;o/[Bo00Co0000ok:d_ol0003o00000_nb];l0
1Ol0003o/[Boo`000?nb];oo000000?o/[Bo00?o0000ok:d_ol000000onb];l00ol0003o/[Book:d
_`02ok:d_`07o`000?nb];oo/[Book:d_ol0003o/[Boo`000003ok:d_`03o`000?nb];oo000000;o
/[Bo0_l00005ok:d_`;o00001?nb];l01ol0003o/[Book:d_onb];oo0000ok:d_ol000000onb];l0
0ol0003o/[Boo`000003ok:d_`03o`000?nb];oo000000;o/[Bo0_l0000Wok:d_`?o00000onb];l0
0oo^kNGoU9FRomgNh@0<om3Ag`04omgNhOnDUJ;oooooognM^@;oo?cn00?oOifiooooooooool00ooo
ool3o`0000kooooo00?o0000ooooooooool04oooool4o`0000;ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`1Eooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_ooooooOifi00;oo?cn00?oOifiooooooooool0
X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001_mVIWko
nocmojRY^omVIWkoOifiooooo`;o/[Bo00?o0000ok:d_onb];l00onb];l01Ol0003o/[Boo`000?nb
];oo000000;o/[Bo0ol00002ok:d_`04o`000?nb];oo0000o`0000;o/[Bo00Co0000ok:d_ol0003o
00000_nb];l00ol0003o/[Book:d_`03o`0000?o/[Bo0ol00006ok:d_`?o00000_nb];l4o`0000?o
/[Bo0_l000000onb];oo0000ok:d_`03ok:d_`03o`000?nb];oo/[Bo00Go/[Bo0ol00002ok:d_`06
o`000?nb];oo/[Book:d_ol0003o/[Bo1?l00003ok:d_`;o000000?o/[Boo`000?nb];l09_nb];l2
o`0000Co/[Bo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSXkP0;on;SjooKg>GofmcUomCEhOo>cmgo
c<gKolg>g?ooooooU9FRoooooomoWKT00_olo?h00omoWKWoooooooooo`2@ooooo`0:onGVk_o/k_?o
k>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGVk_oo
ooooOifi00;oo?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM
^OmVIWkoZ:Vkoo_lo@7oIVIn00001_mVIWkonocmojRY^omVIWkoOifiooooo`?o/[Bo00Go0000ok:d
_onb];oo/[Boo`00000Bok:d_`03o`000?nb];oo/[Bo02Co/[Bo00?o0000ok:d_onb];l00_nb];l0
0ol0003o/[Book:d_`02ok:d_`03o`000?nb];oo/[Bo01Go/[Bo00?o0000ok:d_onb];l09Onb];l0
0ol0003o/[Book:d_`03ok:d_`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>h02ooRh^_ofm_Vom_K
i_oDeN7oc/oMolc=foo=c]cooooooiBEX_ooooooOifi00;oo?cn00?oOifiooooooooool0T?ooool0
2_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`07oo[joOoknokono_n
oo_ko_oUi^koooooognM^@02oocloP03ognM^Ooooooooooo0:;ooooo00CoOifiooclo_olo?koOifi
Yoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000KoIVInoo_loOnXZK_oIVInognM^Oooool4ok:d
_`?o00004onb];l00ol0003o/[Book:d_`03ok:d_`03o`000?nb];oo/[Bo01ko/[Bo00?o0000ok:d
_onb];l00onb];l4o`0001So/[Bo00?o0000ok:d_onb];l0:onb];l01?o^kNGoU9FRooooooogmoT2
onc/l@;oj>W_00_ohn?Zom_Ki_oKfnKoe=GQolk@gOo<cM_ocLkLoooooonDUJ;oooooognM^@02oocl
oP03ognM^Ooooooooooo093ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2R
ooooo`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00006ofIVO_ok
o?goZ:VkofIVO_moWKWoooooTOnb];l01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00_oh^?Zom_L
iOoKg>GoeMGQolo?g?o<cM_ocLkLoooooonDUJ;oooooognM^@02oocloP03ognM^Ooooooo/[Bo093o
/[Bo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_n
oo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Oolo?koo?cn
ognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00006ofIVO_oko?goZ:VkofIVO_moWKWooooo
TOnb];l01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00_oh^?Zom_LiOoKg>GoeMGQolo?g?o<cM_o
cLkLoooooonDUJ;oooooognM^@02oocloP03ognM^Ooooooo/[Bo093o/[Bo00?ok^gUong`l_n;S9X0
1OnMWZ`00onMWZ_oWIj/oifN[003oifN[005oifO[?n=Si_ok^gUoooooomoWKT00_olo?h00omoWKWo
ooooooooo`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh0
0006ofIVO_oko?goZ:VkofIVO_moWKWoooooTOnb];l01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^
00_oh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_ocLkLoooooonDUJ;oooooognM^@02oocloP03ognM^Ooo
oooo/[Bo093o/[Bo00?ok^gUoiBEX_oMg^403?o@dMl01?oMg^7oU9FRoooooomoWKT2oocloP03ognM
^Ooooooooooo0:;ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIV
OP0000GoIVInoo_loOnXZK_oIVInognM^@2Booooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYj>h0
2ooSh^[ofmcUom_LiOoDeN7oc/oLolc=foo=c]cooooooiBEX_ooooooOifi00;oo?cn00?oOifioooo
oonb];l00_nb];l3o`0000;o/[Bo1?l00006ok:d_`03o`000?nb];oo/[Bo00?o/[Bo00?o0000ok:d
_onb];l00ol00002ok:d_`;o00000_nb];l3o`0006[o/[Bo00Cok^gUoiBEX_oooooomoOi0_o/k?42
onSXkP0;on;SjooKg>GofmcUomCEhOo>cmgoc<gKolg>g?ooooooU9FRoooooomoWKT00_olo?h00omo
WKWoooooooooo`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmV
IWh00005ofIVO_oko?goZ:VkofIVO_moWKT0T_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^
00_ohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;oooooognM^@02oocloP05ognM^Ooo
oooo/[Book:d_ol000000onb];l00ol0003o/[Boo`000003ok:d_`03o`000?nb];oo/[Bo00?o/[Bo
00?o0000ok:d_onb];l00onb];l00ol0003o/[Boo`000003ok:d_`03o`000?nb];oo000000;o/[Bo
00Go0000ok:d_onb];oo/[Boo`00001Yok:d_`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXj>h02ooR
h^_ofm_Vom_Ki_oDeN7oc/oMolc=foo=c]cooooooiBEX_ooooooOifi00;oo?cn00?oOifioooooooo
ool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmV
IWkonocmojRY^omVIWkoOifi09;ooooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0;on?Sj_oK
g>GofmcUomCEh?o>cmcoc<gKolg>g?ooooooU9FRoooooomoWKT00_olo?h00omoWKWooooook:d_`05
ok:d_`03o`000?nb];oo000000Co/[Bo00?o0000ok:d_onb];l00_nb];l00ol0003o/[Book:d_`03
ok:d_`03o`000?nb];oo000000?o/[Bo00?o0000ok:d_ol000001Onb];l00ol0003o/[Book:d_`1R
ok:d_`03o`000?nb];oo/[Bo00?o/[Bo00Cok^gUoiBEX_oooooomoOi0_o/k?42onSYk`0;on?Sj_oK
fnKofm_VomCEhOo>d=goc<gKolg>g?ooooooU9FRoooooomoWKT00_olo?h00omoWKWoooooooooo`2R
ooooo`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_ok
o?goZ:VkofIVO_moWKT00oooool5o`000004ooooool0003oooooooooo`?o00000_ooool2o`0000;o
oooo0ol00006ooooo`;o000000Coooooo`000?oooooo00000oooool00ol0003oooooooooo`02o`00
0003ooooool0003ooooo00?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02
o`000003ooooool0003ooooo00;o000000?oooooo`000?ooool00_ooool00ol0003oooooooooo`03
o`0000?ooooo0ol00003ooooo`?o0000>Oooool01?o^kNGoU9FRooooooogmoT2onc/l@KoSYFR00Oo
c/oLolc=foo=c]cooooooiBEX_ooooooOifi00;oo?cn00?oOifioooooonb];l01Onb];l00ol0003o
/[Boo`000004ok:d_`03o`000?nb];oo/[Bo00;o/[Bo1?l00002ok:d_`03o`000?nb];oo000000?o
/[Bo00?o0000ok:d_ol000000onb];l2o`0006Go/[Bo0_l00004ok:d_`04onk]iOnDUJ;oooooooOg
n@;ok>ca0_oXjNh02ooRhn[ofmcUom_LiOoEeN7ocloLolc=foo=c]cooooooiBEX_ooooooOifi00;o
o?cn00GoOifiooooooooooooooooo`000006ooooo`;o000000Coooooo`000?oooooo00001?ooool2
o`000004ooooool0003oooooo`0000;ooooo00Co0000oooooooooooo00000_ooool3o`0000;ooooo
0_l000000ooooooo0000ooooo`02ooooo`03o`000?oooooooooo00?o00000_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00?o00000_ooool2o`0000;ooooo0ol00002ooooo`Co0000
Doooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWko
nocmojRY^omVIWkoOifi00?ooooo00?o0000ooooooooool00oooool00ol0003oooooo`000003oooo
o`03o`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo00;o000000?oooooo`000?ooool00_ooool00ol0003oooooo`000002ooooo`;o00001?ooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo0_l000001Ooooooo0000oooo
oooooooo000000?ooooo00?o0000ooooool000000oooool00ol0003oooooo`000003ooooo`03o`00
0?oooooo000000?ooooo00?o0000ooooooooool0=_ooool01Oo^kNGoU9FRooooooogmoWok>ca00Ko
oooo00Soe=GPolk@gOo<cM_ocLkLoooooonDUJ;oooooognM^@;oo?cn00?oOifioooooonb];l00onb
];l2o`0000;o/[Bo00?o0000ok:d_onb];l00_nb];l00ol0003o/[Book:d_`02ok:d_`09o`000?nb
];oo/[Book:d_ol0003o/[Boo`000?nb];oo000000?o/[Bo00?o0000ok:d_ol000000_nb];l01Ol0
003o/[Book:d_onb];oo000006?o/[Bo0ol00003ok:d_`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oX
jNh02ooRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_ooooooOifi00;oo?cn00GoOifi
ooooooooooooooooo`000005ooooo`03o`000?oooooooooo00;o000000?oooooo`000?ooool00_oo
ool00ol0003oooooooooo`02o`000005ooooool0003oooooooooool000000_ooool00ol0003ooooo
o`000003ooooo`03o`000?oooooo000000;ooooo00Oo0000ooooooooooooooooo`000?oooooo0000
00?ooooo00?o0000ooooool000001Oooool00ol0003oooooo`000003ooooo`03o`000?oooooo0000
00;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o0000ooooooooool0D?oo
ool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocm
ojRY^omVIWkoOifi00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool00oooool01ol0003ooooooooooooooooo
0000ooooool000000oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo00;ooooo00Wo
0000ooooool0003oooooo`000?oooooo0000ooooool000000oooool00ol0003oooooo`000002oooo
o`07o`000?ooooooooooooooool0003oooooo`000005ooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool0<Oooool00ol0003oooooooooo`03ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca
1_n>UJ801oo>cmcoc<gKolg>g?ooooooU9FRoooooomoWKT00_olo?h00omoWKWooooook:d_`05ok:d
_`03o`000?nb];oo000000Co/[Bo00?o0000ok:d_onb];l00_nb];l01ol0003o/[Book:d_onb];oo
0000ok:d_ol000000_nb];l3o`000004ok:d_ol0003o0000o`0000;o/[Bo0ol0001Tok:d_`;o0000
1?nb];l01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00_oh^;Zom_LiOoKg>Goe=GQolo?gOo<cM_o
cLkLoooooonDUJ;oooooognM^@02oocloP05ognM^Oooooooooooooooool000001Oooool01ol0003o
oooooooooooooooo0000ooooool000000oooool01ol0003ooooooooooooooooo0000ooooool00000
0_ooool01_l0003oooooooooool0003oooooo`0000Gooooo00Co0000oooooooooooo00000oooool0
0ol0003oooooo`000005ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000oooool0
0ol0003oooooo`000006ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool0Coooool0
1?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY
^omVIWkoOifi00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02o`0000?ooooo
00Co0000oooooooooooooooo0_l00007ooooo`Co000000?oooooo`000?ooool00_ooool00ol0003o
ooooo`000003ooooo`03o`000?oooooooooo00;ooooo00Oo0000ooooool0003oooooo`000?oooooo
000000;ooooo1?l000001Ooooooo0000oooooooooooo000000?ooooo00?o0000ooooool000001Ooo
ool5o`0000;ooooo0_l0000dooooo`;o00001?ooool01Oo^kNGoU9FRooooooogmoWok>ca00Kooooo
00Soe=GPolk?g?o<cM_ocLkLoooooonDUJ;oooooognM^@;oo?cn00GoOifioooooonb];oo/[Boo`00
0003ok:d_`03o`000?nb];oo000000?o/[Bo00?o0000ok:d_onb];l00onb];l01ol0003o/[Book:d
_onb];oo0000ok:d_ol000001onb];l00ol0003o/[Book:d_`1Xok:d_`03o`000?nb];oo/[Bo00?o
/[Bo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWXkP0;on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>
g?ooooooU9FRoooooomoWKT00_olo?h01?moWKWoooooooooooooool4o`0000?ooooo1?l000000ooo
oooo0000ooooo`03ooooo`Co000000Goooooo`000?ooooooooooo`000002ooooo`03o`000?oooooo
000000Co000000Goooooo`000?ooooooooooo`000003ooooo`03o`000?oooooo000000Gooooo1?l0
0002ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000001_ooool00ol0003oooooo`00
0004ooooo`03o`000?oooooooooo04oooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVIn
ojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@03ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooool000000oooool00ol0003oooooo`000002ooooo`05o`000?oooooooooooooo
ool000001?ooool01ol0003ooooooooooooooooo0000ooooool000000oooool00ol0003oooooo`00
0002ooooo`;o00001?ooool02Ol0003oooooo`000?oooooo0000ooooool0003oooooo`000003oooo
o`03o`000?oooooo000000;ooooo0_l00002ooooo`03o`000?oooooo000000?ooooo00?o0000oooo
ool000000oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo033ooooo0ol00003oooo
o`04onk]iOnDUJ;oooooooOgn@;ok>ca1_n>UJ801oo>cmgoc<gKolg>g?ooooooU9FRoooooomoWKT0
0_olo?h00omoWKWooooook:d_`02ok:d_`?o00000_nb];l4o`0000Ko/[Bo1?l00002ok:d_`03o`00
0?nb];oo/[Bo00Go/[Bo00?o0000ok:d_onb];l0K_nb];l01?o^kNGoU9FRooooooogmoT2onc/l@;o
jNW^00_ohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oooooognM^@02oocloP05ognM
^Oooooooooooooooool000000oooool00ol0003oooooo`000003ooooo`04o`000?oooooo0000o`00
00;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`000007ooooool0003oooooooooool0003o
ooooo`000003ooooo`03o`000?oooooo000000;ooooo0_l00002ooooo`03o`000?oooooo000000?o
oooo00?o0000ooooool000000oooool01Ol0003oooooo`000?oooooo000000?ooooo00?o0000oooo
ool000001?ooool2o`0000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1?oooo
o`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?go
Z:VkofIVO_moWKT00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o000000Co
ooooo`000?l0003o00000_ooool3o`0000Kooooo0ol00002ooooo`Co00000oooool2o`000003oooo
ool0003ooooo00?ooooo0_l00003ooooo`;o00000_ooool3o`00000:ooooool0003o0000o`000?oo
oooo0000ooooool0003oooooo`0000;ooooo0ol00003ooooo`?o00000oooool3o`0003?ooooo0_l0
0004ooooo`05onk]iOnDUJ;oooooooOgnOo/k?401_ooool02?oDeN3oc/oMolc=foo=c]cooooooiBE
X_ooooooOifi0_olo?h00omoWKWooooook:d_`2@ok:d_`04onk]iOnDUJ;oooooooOgn@;ok>ca1_n>
UJ801oo>cmcoc<gKolg>g?ooooooU9FRoooooomoWKT00_olo?h01OmoWKWooooooooooooooooo0000
00?ooooo00?o0000ooooooooool00ol00002ooooo`03o`000?oooooo000000;ooooo0ol00002oooo
o`03o`000?oooooo000000?o00000oooool3o`00000:ooooool0003o0000o`000?oooooo0000oooo
ool0003oooooo`0000;ooooo0ol00002ooooo`07o`000?ooooooooooooooool0003oooooo`000002
ooooo`?o000000Coooooo`000?l0003o00001Oooool00ol0003oooooo`000004ooooo`03o`000?oo
oooooooo04oooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIVOP00
00GoIVInoo_loOnXZK_oIVInognM^@03ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool06Oooool00ol0003oooooooooo`02ooooo`;o00000oooool2o`0000Oooooo00?o0000oooooooo
ool0BOooool00ol0003oooooooooo`03ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca1_n>UJ801oo>
d=goc<gKolg>g?ooooooU9FRoooooomoWKT00_olo?h00omoWKWooooook:d_`2@ok:d_`05onk]iOnD
UJ;oooooooOgnOo/k?401_ooool02?oDeN3oc]3Molc=foo=c]cooooooiBEX_ooooooOifi0_olo?h0
1OmoWKWooooooooooooooooo000000?ooooo00?o0000ooooooooool07Oooool00ol0003ooooooooo
o`0<ooooo`07o`000?ooooooooooooooool0003oooooo`000007ooooo`04o`000?ooooooooooo`00
00?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`1@ooooo`04ognM^Oolo?koo?cn
ognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_moWKT00ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool06Ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo04Sooooo00Gok^gUoiBEX_oooooomoOi
onc/l@06ooooo`08omGEhOo?cmcoc<gKolg>g?ooooooU9FRoooooomoWKT2oocloP03ognM^Ooooooo
/[Bo093o/[Bo00Cok^gUoiBEX_oooooomoOi0_o/k?46ohjEXP07olk?g?o<cM_ocLkLoooooonDUJ;o
ooooognM^@02oocloP04ognM^Oooooooooooooooo`Co00008?ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Gooooo1?l00002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooo
oooooooooooo0ol00002ooooo`Co0000Doooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmV
IWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi09;ooooo00Cok^gUoiBEX_oooooo
moOi0_o/k?42onSYkP0;on;Sj_oKg>GofmcUomGEhOo?cmcoc<gKolg>g?ooooooU9FRoooooomoWKT0
0_olo?h00omoWKWoooooooooo`2@ooooo`05onk]iOnDUJ;oooooooOgnOo/k?401_ooool02?oDeN3o
c/oMolc=foo=c]cooooooiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Ool
o?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_mo
WKT0T_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00_oh^;Zom_LiOoKg>Goe=GQolo?gOo<
cM_ocLkLoooooonDUJ;oooooognM^@02oocloP03ognM^Ooooooooooo093ooooo00Cok^gUoiBEX_oo
oooomoOi0_o/k?46ohjEXP07olk?gOo<cM_ocLkLoooooonDUJ;oooooognM^@02oocloP03ognM^Ooo
oooooooo0:;ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVInojRY^ooko?d1ofIVOP00
00GoIVInoo_loOnXZK_oIVInognM^@2Booooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh02ooR
h^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_ooooooOifi00;oo?cn00?oOifioooooooo
ool0T?ooool01Oo^kNGoU9FRooooooogmoWok>ca00Kooooo00Soe=GQolk@gOo<cM_ocLkLoooooonD
UJ;oooooognM^@;oo?cn00?oOifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04
ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi09;ooooo00Cok^gUoiBE
X_oooooomoOi0_o/k?42onWXkP0;on?Rj_oKg>GofmcUomCEhOo>cmcoc<gKolg>g?ooooooU9FRoooo
oomoWKT00_olo?h01?moWKWoooooooooooooool5o`000003ooooool0003o000000;o00001_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o00000_ooool2o`0000;ooooo0ol0001Z
ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca1_n>UJ801oo?cmcoc<gKolg>g?ooooooU9FRoooooomo
WKT00_olo?h00omoWKWoooooooooo`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIV
O_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_moWKT0T_ooool01?o^kNGoU9FRooooooog
moT2onc/l@;ojNW^00_ohn?Zom_LiOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oooooognM^@02
oocloP03ognM^Ooooooooooo00;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooo
oooo000000Gooooo00?o0000ooooooooool00oooool00ol0003oooooo`000003ooooo`03o`000?oo
oooo000000;ooooo00Go0000ooooooooooooooooo`00001Yooooo`05onk]iOnDUJ;oooooooOgnOo/
k?401_ooool02?oEeN7ocloLolc=foo=c]cooooooiBEX_ooooooOifi0_olo?h00omoWKWooooooooo
o`2Rooooo`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIV
O_oko?goZ:VkofIVO_moWKT0T_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNW^00_ohn?Zom_L
iOoKg>Goe=GPolk?g?o<cM_ocLkLoooooonDUJ;oooooognM^@02oocloP03ognM^Ooooooooooo00?o
oooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool00oooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000Gooooo00?o0000oooo
ooooool0H_ooool00ol0003oooooooooo`03ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oXjNh0
2ooRh^[ofmcUom_LiOoDeN7ocloMolc=foo=c]cooooooiBEX_ooooooOifi00;oo?cn00?oOifioooo
ooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn0000
1OmVIWkonocmojRY^omVIWkoOifi00?ooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
ooooo`02o`000003ooooool0003ooooo00;o000000?oooooo`000?ooool00_ooool00ol0003ooooo
ooooo`03o`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02o`000003
ooooool0003ooooo00;o000000Coooooo`000?oooooooooo0ol00003ooooo`;o000000Coooooo`00
0?oooooo00001?ooool00ol0003oooooooooo`04ooooo`;o000000Coooooo`000?oooooo00000ooo
ool00ol0003oooooooooo`03o`0000;ooooo0_l000001?oooooo0000ooooooooool3o`0000;ooooo
00Go0000ooooooooooooooooo`000002ooooo`?o00008Oooool01?o^kNGoU9FRooooooogmoT2onc/
l@;oj>S_00_oh^;Zom_KiOoKfnGoe=GPolk@gOo<cM_ocLkLoooooonDUJ;oooooognM^@02oocloP03
ognM^Ooooooooooo00Cooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`02oooo
o`Co00000_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000?ooooo0_l0001Uoooo
o`;o00001?ooool01?o^kNGoU9FRooooooogmoT2onc/l@;ojNS^00_ohn;Zom_LiOoKg>Goe=GQolk?
g?o<cM_ocLkLoooooonDUJ;oooooognM^@02oocloP04ognM^Oooooooooooooooo`Go000000Cooooo
o`000?oooooooooo0ol00002ooooo`;o000000?oooooo`000?ooool01?ooool00ol0003ooooooooo
o`03o`0000;ooooo0_l00002ooooo`?o00000_ooool4o`0007Gooooo00CoOifiooclo_olo?koOifi
Yoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@03ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool2o`000005ooooool0003ooooo
ooooool000000oooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00Ko0000
oooooooooooo0000ooooool00002ooooo`;o000000Ooooooo`000?ooooooooooo`000?oooooo0000
00?ooooo00?o0000ooooool000000_ooool2o`000003ooooool0003ooooo00?ooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`02o`000003ooooool0003ooooo00;ooooo00?o0000oooo
ool000000oooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000?ooooo00?o0000oooo
ool000000oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo01kooooo00Cok^gUoiBE
X_oooooomoOi0_o/k?42onSYkP0;on?RjooKfnKofm_VomCEh?o>cmcoc<gKolg>g?ooooooU9FRoooo
oomoWKT00_olo?h00omoWKWoooooooooo`05ooooo`03o`000?oooooo000000Cooooo00?o0000oooo
ooooool00_ooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`000003ooooo`03o`00
0?oooooo000000;ooooo00Go0000ooooooooooooooooo`00001Sooooo`?o00000oooool01?o^kNGo
U9FRooooooogmoT2onc/l@;ojNS^00_ohn;Zom_LiOoKg>Goe=GQolk?g?o<cM_ocLkLoooooonDUJ;o
ooooognM^@02oocloP05ognM^Oooooooooooooooool000001Oooool00ol0003oooooo`000003oooo
o`03o`000?oooooo000000;ooooo00?o0000ooooooooool00oooool00ol0003oooooo`000003oooo
o`03o`000?oooooo000000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o
0000ooooooooool0L_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7o
IVIn00001OmVIWkonocmojRY^omVIWkoOifi00?ooooo00Wo0000ooooool0003oooooo`000?oooooo
0000ooooool000000oooool00ol0003oooooo`000002ooooo`07o`000?ooooooooooooooool0003o
ooooo`000005ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000oooool00ol0
003oooooo`000002ooooo`03o`000?oooooo000000Gooooo00Oo0000ooooooooooooooooo`000?oo
oooo000000Cooooo00?o0000ooooooooool00oooool01ol0003ooooooooooooooooo0000ooooool0
00000oooool00ol0003oooooo`000005ooooo`06o`000?ooooooooooo`000?oooooo00000oooool0
0ol0003oooooo`000003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool06Oooool0
0ol0003oooooooooo`03ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca0_oYjNh02ooShn[ofm_Vom_K
i_oDeN3oc/oMolc=foo=c]cooooooiBEX_ooooooOifi00;oo?cn00?oOifiooooooooool01Oooool0
0ol0003oooooo`000004ooooo`03o`000?oooooooooo00;ooooo00Oo0000ooooooooooooooooo`00
0?oooooo000000;ooooo0ol000001?oooooo0000o`000?l00002ooooo`?o0000I?ooool2o`0000Co
oooo00Cok^gUoiBEX_oooooomoOi0_o/k?42onWYkP0;on?Sj_oKg>GofmcUomCEh?o>cmcoc<gKolg>
g?ooooooU9FRoooooomoWKT00_olo?h01OmoWKWooooooooooooooooo000000Gooooo00?o0000oooo
ooooool00_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooool000000oooool00ol0003oooooo`000006ooooo`03o`000?oooooo000000Cooooo00?o0000
ooooooooool0LOooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn
00001OmVIWkonocmojRY^omVIWkoOifi00?ooooo00Oo0000ooooool0003oooooo`000?oooooo0000
00;ooooo1?l000001Ooooooo0000oooooooooooo000000?ooooo00?o0000ooooool000001?l00000
1Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooooooool01?l000001ooooooo0000oooo
oooooooo0000ooooool000001_ooool4o`000003ooooool0003ooooo00?ooooo00?o0000oooooooo
ool00oooool01ol0003ooooooooooooooooo0000ooooool000000oooool00ol0003oooooo`000005
ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooo`000003ooooo`03o`00
0?oooooooooo00;o00007?ooool2o`0000Cooooo00?ok^gUoiBEX_oFe]/03?ooool01?oFe]_oU9FR
oooooomoWKT2oocloP05ognM^Oooooooooooooooool000000oooool00ol0003oooooo`000003oooo
o`03o`000?oooooooooo00?ooooo00Oo0000ooooooooooooooooo`000?oooooo000000Oooooo00?o
0000ooooooooool0J?ooool00ol0003oooooooooo`03ooooo`04onk]iOnDUJ;oooooooOgn@;ok>ca
0_oXj>l02ooRh^[ofm_Uom_KiOoDeN3oc]3Molc=foo=c]cooooooiBEX_ooooooOifi00;oo?cn00Go
Oifiooooooooooooooooo`000005ooooo`03o`000?oooooooooo00;o00000oooool00ol0003ooooo
ooooo`04o`0000;ooooo00?o0000ooooool000000oooool00ol0003oooooo`000006ooooo`03o`00
0?oooooo000000Cooooo00?o0000ooooooooool0LOooool01?moWKWoo?cnooclo_moWKVWooooo`04
ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi00?ooooo00Wo0000oooo
ool0003oooooo`000?oooooo0000ooooool000000oooool00ol0003oooooo`000002ooooo`;o0000
0_ooool00ol0003oooooo`000003ooooo`06o`000?oooooo0000o`000?oooooo00000_ooool00ol0
003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000oooool00ol0
003oooooo`000003ooooo`03o`000?oooooo000000Cooooo1?l00002ooooo`07o`000?oooooooooo
ooooool0003oooooo`000003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000000_oo
ool00ol0003oooooo`000003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000000ooo
ool00ol0003oooooooooo`0Hooooo`?o00000oooool00oo^kNGooOgjoi2AW`05okNg_`03okBd_Ong
]koo]kNo00Co]kNo00CoT96Oonk]iOooooooOifi0_olo?h00omoWKWoooooooooo`02ooooo`?o0000
0_ooool4o`0000Kooooo1?l00002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
K_ooool01?o^kNGoU9FRooooooogmoT2onc/l@;oj>W^00_ohn;[om_Ki_oKfnKoe=GPolk?g?o<cM_o
cLkLoooooonDUJ;oooooognM^@02oocloP05ognM^Oooooooooooooooool000001Oooool00ol0003o
ooooo`000003ooooo`03o`000?oooooo000000;ooooo00Wo0000ooooooooooooooooo`000?oooooo
0000ooooool000000oooool00ol0003oooooo`000004ooooo`;o00000_ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo077ooooo00CoOifiooclo_olo?koOifiYoooool01?moWKWoIVIn
ojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@03ooooo`;o00000oooool2o`0000;o
oooo0ol000001ooooooo0000o`000?l0003oooooo`000?ooool00_l00003ooooo`?o00000_ooool0
0ol0003oooooo`000003o`0000?ooooo0ol000001_oooooo0000o`000?l0003oooooo`0000;ooooo
0ol00003ooooo`?o00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo
00Ko0000ooooooooooooooooo`000?ooool4o`0000?ooooo0ol000001_oooooo0000o`000?l0003o
ooooo`0000;ooooo0ol00002ooooo`Co00000oooool3o`0001_ooooo0_l00004ooooo`0:onGVk_o/
k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Oon_[moo_ko_oknokono_nonGV
k_ooooooOifi00;oo?cn00?oOifiooooooooool0T?ooool01?o^kNGoU9FRooooooogmoT2onc/l@;o
jNW^00_ohn?Zom_Ki_oKfnKoe=GPolk?gOo<cM_ocLkLoooooonDUJ;oooooognM^@02oocloP05ognM
^Oooooooooooooooool000001Oooool00ol0003oooooooooo`03o`000006ooooool0003o0000o`00
0?oooooo00000oooool00ol0003oooooo`000002ooooo`?o000000Coooooo`000?l0003o00001Ooo
ool00ol0003oooooo`000004ooooo`03o`000?oooooooooo077ooooo00CoOifiooclo_olo?koOifi
Yoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@03ooooo`;o
00000oooool2o`0000Oooooo00Co0000oooooooooooo00006Oooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0]oooo
o`03o`000?oooooooooo00?ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h00omoWKWoooooooooo`2@
ooooo`03onk]iOnDUJ;oe]KK00cooooo00Coe]KKoiBEX_ooooooOifi0_olo?h01OmoWKWooooooooo
oooooooo000000gooooo00Co0000oooooooooooo00000oooool00ol0003oooooo`000007ooooo`04
o`000?ooooooooooo`0000?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`1boooo
o`04ognM^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?go
Z:VkofIVO_moWKT00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo00Co
0000oooooooooooo00006Oooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo00;o
oooo1Ol0000Cooooo`04o`000?ooooooooooo`0003;ooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/01oojn_gono_noo_ko_oknokoiNK^oooooomoWKT00_olo?h0
0omoWKWoooooooooo`2@ooooo`03onk]iOomoO[oT96O00Go]kNo00?o];BmokNg_ong]kl01?ng]kl0
1?n@TIook^gUoooooomoWKT2oocloP05ognM^Oooooooooooooooool000001Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Co00000_ooool00ol0003oooooooooo`05ooooo`04o`00
0?ooooooooooooooo`?o00000_ooool4o`0007Gooooo00CoOifiooclo_olo?koOifiYoooool01?mo
WKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@2Booooo`03onk]iOo/kOCo
RhbI00coWIj[00CoRX^Ion?VkOooooooOifi0_olo?h00omoWKWoooooooooo`2@ooooo`03onk]iOo/
kOCoRhbI00coWIj[00CoRX^Ion?VkOooooooOifi0_olo?h00omoWKWoooooooooo`2Rooooo`04ognM
^Oolo?koo?cnognM^JOooooo00CoOifiofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIV
O_moWKT0T_ooool00oo^kNGoU9FRomgNh@0<omWJi004omgNhOnDUJ;oooooognM^@;oo?cn00?oOifi
ooooooooool0SonMWJ401?ooooook^gUoiBEX_oMg^4<omWJi004omgNhOnDUJ;oooooognM^@;oo?cn
00?oOifiooooooooool0X_ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_l
o@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi09;ooooo00?ok^gUoiBEX_ooool03?o;c=X01?oo
ooooU9FRoooooomoWKT2oocloP03ognM^Ooooooooooo093ooooo00?ok^gUoiBEX_ooool03?o;c=X0
1?ooooooU9FRoooooomoWKT2oocloP03ognM^Ooooooooooo0:;ooooo00CoOifiooclo_olo?koOifi
Yoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@2Booooo`03
onk]iOnDUJ;ooooo00coblcJ00CooooooiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`2@oooo
o`03onk]iOnDUJ;ooooo00coblcJ00CooooooiBEX_ooooooOifi0_olo?h00omoWKWooooook:d_`2Q
ok:d_`05oooooomoWKWoo?cnooclo_moWKT0Yoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000Go
IVInoo_loOnXZK_oIVInognM^@0=ooooo`Co0000>?ooool00ol0003oooooooooo`16ooooo`03onk]
iOnDUJ;ooooo00coblcJ00CooooooiBEX_ooooooOifi0_olo?h00omoWKWoooooooooo`03ooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool0B_ooool4o`0000;ooooo00?o0000oooooooo
ool0:oooool00oo^kNGoU9FRooooo`0<ol_<fP04oooooonDUJ;oooooognM^@;oo?cn00?oOifioooo
oonb];l0XOnb];l01OooooooOifiooclo_olo?koOifi0:Oooooo00CoOifiofIVO_nXZK_onocm0OmV
IWh00005ofIVO_oko?goZ:VkofIVO_moWKT04Oooool00ol0003oooooooooo`0eooooo`03o`000?oo
oooooooo04Kooooo00?ok^gUoiBEX_ooool03?o;c=X01?ooooooU9FRoooooomoWKT2oocloP03ognM
^Ooooooooooo00;ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`1>ooooo`04o`00
0?ooooooooooo`0002cooooo00?ok^gUoiBEX_ooool03?o;c=X01?ooooooU9FRoooooomoWKT2oocl
oP03ognM^Ooooooo/[Bo0:7o/[Bo00GoooooognM^Oolo?koo?cnognM^@2Wooooo`04ognM^OmVIWko
Z:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi00?ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooo`000002ooooo`;o000000Coooooo`000?oooooooooo0ol00002ooooo`04o`00
0?oooooo0000o`0000;ooooo00?o0000ooooooooool00_ooool2o`000004ooooool0003oooooo`00
00;ooooo0ol00007ooooo`?o00000oooool3o`0000;ooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooo`000?ooool2o`0000?ooooo0_l000000ooooooo0000ooooo`02o`0000;ooooo0_l0
00000ooooooo0000ooooo`02o`000004ooooool0003oooooooooo`?o00000_ooool01Ol0003ooooo
oooooooooooo000002Cooooo00?ok^gUoiBEX_ooool00_o;c=X00olo?CgoblcJol_<fP03ol_<fP08
oclm?Oo;c=[oblcJol_<f_ooooooU9FRoooooomoWKT2oocloP05ognM^Oooooooooooooooool00000
0oooool00ol0003oooooooooo`03ooooo`06o`000?oooooo0000ooooool0003ooooo0_l00002oooo
o`05o`000?ooooooooooooooool000000_ooool2o`000005ooooool0003oooooo`000?ooool00_l0
0003ooooo`?o00000_ooool2o`000004ooooool0003oooooooooo`?o00000oooool2o`000004oooo
ool0003oooooo`0000Cooooo1Ol000001?oooooo0000ooooooooool3o`0000;ooooo0_l000001?oo
oooo0000ooooool00003ooooo`03o`000?oooooooooo00;o000000?oooooo`000?ooool00_ooool0
0ol0003oooooooooo`0Yooooo`03onk]iOnDUJ;ooooo00;oblcJ00?o?cdmol_<f_o;c=X00oo;c=X0
2?lo?CgoblcJol_<f_o;c=[ooooooiBEX_ooooooOifi0_olo?h01OmoWKWooooook:d_onb];oo0000
00Go/[Bo00?o0000ok:d_onb];l00ol00002ok:d_`;o00000_nb];l3o`0000;o/[Bo1?l00025ok:d
_`05oooooomoWKWoo?cnooclo_moWKT0Yoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVIn
oo_loOnXZK_oIVInognM^@03ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooool0003ooooo
o`000002ooooo`;o000000?oooooo`000?ooool00_ooool01?l0003oooooo`000?l00002ooooo`03
o`000?oooooo000000?ooooo00?o0000ooooooooool00_l000001?oooooo0000ooooool00003oooo
o`03o`000?oooooooooo00?ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o
0000ooooool000000_ooool01Ol0003oooooooooool0003ooooo00;o00000_ooool00ol0003ooooo
o`000002ooooo`;o000000Goooooo`000?ooooooooooo`000002ooooo`;o000000Ooooooo`000?oo
ooooooooo`000?oooooo000000?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`0R
ooooo`04onk]iOnDUJ;oooooolc=f`?o?cdm0oo<cM/3oclm?@;oc<gK00CooooooiBEX_ooooooOifi
0_olo?h01OmoWKWooooooooooooooooo000000?ooooo00?o0000ooooooooool00oooool01?l0003o
ooooo`000?ooool2o`0000;ooooo00?o0000ooooool000000oooool00ol0003oooooo`000002oooo
o`;o000000?oooooo`000?l000000_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooool000000oooool00ol0003oooooo`000002ooooo`;o000000?oooooo`00
0?ooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000?ooooo00?o0000oooo
ool000000_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo0_l00003oooo
o`03o`000?oooooooooo02Wooooo00Cok^gUoiBEX_ooooooc<gK0olo?Cd3olc=f`?o?cdm0_o<cM/0
1?ooooooU9FRoooooomoWKT2oocloP05ognM^Ooooooo/[Book:d_ol000001Onb];l00ol0003o/[Bo
o`000003ok:d_`03o`000?nb];oo000000;o/[Bo00Oo0000ok:d_onb];oo/[Boo`000?nb];oo0000
00?o/[Bo00?o0000ok:d_onb];l0P_nb];l01OooooooOifiooclo_olo?koOifi0:Oooooo00CoOifi
ofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_moWKT01?ooool5o`0000;ooooo00?o
0000ooooool000000oooool00ol0003oooooo`000005ooooo`07o`000?ooooooooooooooool0003o
ooooo`000003ooooo`09o`000?ooooooooooooooool0003oooooo`000?oooooo000000Sooooo00?o
0000ooooooooool01?ooool01ol0003ooooooooooooooooo0000ooooool000000_ooool01_l0003o
ooooooooool0003oooooo`0000?ooooo00?o0000ooooool000000oooool00ol0003oooooo`000002
ooooo`07o`000?ooooooooooooooool0003oooooo`000002ooooo`03o`000?oooooo000000?ooooo
00?o0000ooooool000000oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo00?ooooo
00?ok^gUoiBEX_ooool00_oAd^03oclm?@04om7Bh?lo?Cgo?cdmoclm?@?odM;P00CooooooiBEX_oo
ooooOifi0_olo?h01OmoWKWooooooooooooooooo000000Cooooo1Ol00002ooooo`03o`000?oooooo
000000?ooooo00?o0000ooooool000000oooool00ol0003oooooo`000003ooooo`03o`000?oooooo
000000?ooooo00?o0000ooooool000001Oooool01_l0003oooooooooool0003oooooo`0000Gooooo
00Oo0000ooooooooooooooooo`000?oooooo000000Cooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000oooool0
0ol0003oooooo`000003ooooo`05o`000?ooooooooooooooool00000:oooool00oo^kNGoU9FRoooo
o`02om7Bh0?o?cdm00CodM;Poclm?Olo?Cgo?cdm0ooAd^001?ooooooU9FRoooooomoWKT2oocloP05
ognM^Ooooooo/[Book:d_ol000001Onb];l00ol0003o/[Boo`000003ok:d_`03o`000?nb];oo0000
00Ko/[Bo00?o0000ok:d_ol000001?nb];l00ol0003o/[Book:d_`21ok:d_`05oooooomoWKWoo?cn
ooclo_moWKT0Yoooool01?moWKWoIVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM
^@04ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000003ooooo`03o`00
0?oooooo000000Co000000?oooooo`000?ooool00_ooool00ol0003oooooo`000004ooooo`Co0000
00Coooooo`000?oooooo00002?ooool00ol0003oooooooooo`04ooooo`07o`000?oooooooooooooo
ool0003oooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003ooooo
o`000003ooooo`03o`000?oooooo000000?ooooo1?l000001ooooooo0000oooooooooooo0000oooo
ool000000oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo01cooooo0_l00004oooo
o`03onk]iOnDUJ;ooooo00?ofM[T1Olo?Cd4omWJi004oooooonDUJ;oooooognM^@;oo?cn00GoOifi
ooooooooooooooooo`000004ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003ooooo
o`000003ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool01?l000000ooooooo0000
ooooo`02ooooo`03o`000?oooooo000000Co000000Ooooooo`000?ooooooooooo`000?oooooo0000
00Kooooo1?l000000ooooooo0000ooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool00_l00003ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooo`00
0003ooooo`05o`000?ooooooooooooooool00000:oooool00oo^kNGoU9FRooooo`03omWJi0Go?cdm
1?oIf^@01?ooooooU9FRoooooomoWKT2oocloP04ognM^Ooooooo/[Book:d_`Co00000_nb];l00ol0
003o/[Boo`000003ok:d_`03o`000?nb];oo000000Ko/[Bo00?o0000ok:d_ol000001?nb];l00ol0
003o/[Book:d_`21ok:d_`05oooooomoWKWoo?cnooclo_moWKT0Yoooool01?moWKWoIVInojRY^ook
o?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@05ooooo`03o`000?oooooo000000?ooooo00?o
0000ooooool000000_ooool2o`000003ooooool0003ooooo00;ooooo00Co0000ooooool0003o0000
0_ooool01?l0003oooooo`000?l00002ooooo`09o`000?ooooooooooooooool0003oooooo`000?oo
oooo000000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`06o`000?oo
ooooooooooooool0003ooooo0_l000001_oooooo0000oooooooooooo0000ooooo`;o00000_ooool0
0ol0003oooooo`000003ooooo`03o`000?oooooo000000;ooooo00Oo0000ooooooooooooooooo`00
0?oooooo000000;ooooo00?o0000ooooool000000oooool00ol0003oooooo`000003ooooo`03o`00
0?oooooooooo01cooooo0ol00003ooooo`03onk]iOnDUJ;ooooo00Cohn?[0olo?Cd5on?Sj`04oooo
oonDUJ;oooooognM^@;oo?cn00GoOifiooooooooooooooooo`000005ooooo`03o`000?oooooo0000
00?ooooo00Co0000ooooool0003o00000_ooool01?l0003oooooo`000?l00002ooooo`03o`000?oo
oooo000000?ooooo00Co0000ooooool0003o00000_ooool00ol0003oooooo`000003ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooool000000oooool00ol0003oooooo`000003ooooo`03o`00
0?oooooo000000Cooooo00?o0000ooooooooool00oooool00ol0003oooooo`000003ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooool000000oooool00ol0003oooooo`000002ooooo`;o0000
0oooool00ol0003oooooooooo`0Yooooo`03onk]iOnDUJ;ooooo00Cohn?[0olo?Cd5on?Sj`04oooo
oonDUJ;oooooognM^@;oo?cn00GoOifioooooonb];oo/[Boo`000003ok:d_`05o`000?nb];oo0000
ok:d_ol000000onb];l00ol0003o/[Boo`000004ok:d_`;o00000_nb];l00ol0003o/[Book:d_`02
ok:d_`03o`000?nb];oo/[Bo087o/[Bo00GoooooognM^Oolo?koo?cnognM^@2Wooooo`04ognM^OmV
IWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi00Gooooo00?o0000ooooool00000
0oooool00ol0003oooooooooo`02o`000004ooooool0003oooooooooo`?o00000_ooool01?l0003o
ooooo`000?l00002ooooo`03o`000?oooooo000000;ooooo0ol00002ooooo`03o`000?oooooooooo
00?o00001Oooool00ol0003oooooooooo`05ooooo`?o00000_ooool00ol0003oooooo`000003o`00
00;ooooo00Co0000ooooool0003o00000_ooool01?l0003oooooooooooooool4o`0000;ooooo0ol0
00001_oooooo0000o`000?l0003oooooo`0000;ooooo0ol00002ooooo`Co00007oooool2o`0000Co
oooo00?ok^gUoiBEX_ooool01Oo/k?400olo?Cgok>caonc/l@04onc/l@04oooooonDUJ;oooooognM
^@;oo?cn00GoOifiooooooooooooooooo`000005ooooo`03o`000?oooooo000000?ooooo00Co0000
ooooool0003ooooo0_l00002ooooo`04o`000?oooooo0000o`0000?ooooo0ol00002ooooo`04o`00
0?oooooo0000o`0000?ooooo0ol000001_oooooo0000o`000?l0003oooooo`0000;ooooo0ol00003
ooooo`?o00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00ol000001ooooooo0000o`000?l0003oooooo`000?ooool01?l00003ooooo`;o0000
00?oooooo`000?ooool00_ooool00ol0003oooooooooo`0Yooooo`03onk]iOnDUJ;ooooo00Gok>ca
00?o?cdmonc/lOo/k?401?o/k?401?ooooooU9FRoooooomoWKT2oocloP05ognM^Ooooooo/[Book:d
_ol000000onb];l00ol0003o/[Boo`000002ok:d_`?o000000Co/[Boo`000?l0003o00001Onb];l0
0ol0003o/[Boo`000004ok:d_`03o`000?nb];oo/[Bo087o/[Bo00GoooooognM^Oolo?koo?cnognM
^@2Wooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi00Gooooo
00?o0000ooooool000000oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Wooooo
00Go0000ooooooooooooooooo`00000Kooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool0:oooool00ol0003oooooooooo`03ooooo`03onk]iOnDUJ;ooooo00com?Cg00CooooooiBEX_oo
ooooOifi0_olo?h00omoWKWoooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ool000000oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo02[ooooo00?ok^gUoiBE
X_ooool03?odm?L01?ooooooU9FRoooooomoWKT2oocloP05ognM^Ooooooo/[Book:d_ol000000onb
];l00ol0003o/[Boo`000007ok:d_`04o`000?nb];oo/[Boo`0000?o/[Bo00?o0000ok:d_ol00000
0onb];l00ol0003o/[Book:d_`22ok:d_`05oooooomoWKWoo?cnooclo_moWKT0Yoooool01?moWKWo
IVInojRY^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInognM^@06ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
00[ooooo0ol0000Looooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo0000<?ooool0
0oo^kNGoU9FRooooo`0<oo_lo004oooooonDUJ;oooooognM^@;oo?cn00?oOifiooooooooool00ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Wooooo00Co0000oooooooooooo0000
3Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
1Oooool01?l0003oooooooooool0000=ooooo`03o`000?oooooooooo02_ooooo00?ok^gUoiBEX_oo
ool03?oko?`01?ooooooU9FRoooooomoWKT2oocloP04ognM^Ooooooo/[Book:d_`Co00000_nb];l0
0ol0003o/[Book:d_`05ok:d_`04o`000?nb];oo/[Book:d_`?o00000_nb];l4o`0008Go/[Bo00Go
ooooognM^Oolo?koo?cnognM^@2Wooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocm
ojRY^omVIWkoOifi09;ooooo00?ok^gUoiBEX_ooool03Oooool00onDUJ;oooooognM^@02oocloP03
ognM^Ooooooooooo093ooooo00?ok^gUoiBEX_ooool03Oooool00onDUJ;oooooognM^@02oocloP03
ognM^Ooooooo/[Bo0:7o/[Bo00GoooooognM^Oolo?koo?cnognM^@2Wooooo`04ognM^OmVIWkoZ:Vk
oo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi09;ooooo00?ok^gUoiBEX_oFe]/03?ooool0
1?oFe]_oU9FRoooooomoWKT2oocloP03ognM^Ooooooooooo093ooooo00?ok^gUoiBEX_oFe]/03?oo
ool01?oFe]_oU9FRoooooomoWKT2oocloP03ognM^Ooooooo/[Bo0:7o/[Bo00GoooooognM^Oolo?ko
o?cnognM^@2Wooooo`04ognM^OmVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoOifi
09;ooooo00Gok^gUomKKfOn?T9ko]KFnokBd_P05okBd_@09ok>d_Ond];go/kBmokBd_Onc/kgoS8fL
omKKfOooooooOifi00;oo?cn00?oOifiooooooooool0T?ooool01Oo^kNGoe]_Iohn@W_ne]Kko];Bn
00Go];Bm00Wo/kBmokBd_Onc];go];Bmok>c_On<SIcoe]_IoooooomoWKT00_olo?h00omoWKWooooo
ok:d_`2Qok:d_`05oooooomoWKWoo?cnooclo_moWKT0Yoooool01?moWKWoIVInojRY^ooko?d1ofIV
OP0000GoIVInoo_loOnXZK_oIVInognM^@2Tooooo`04ognM^Oolo?koo?cnognM^JCooooo00CoOifi
ooclo_olo?koOifiY?ooool01?moWKWoo?cnooclo_moWKVWooooo`04ognM^OmVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWjVognM^@;oo?cnY_moWKT2oocloZKoOifi0_olo?jYognM^@03
ofIVO_nXZK_onocm007oIVIn00001_mVIWkonocmojRY^omVIWkoTI^Looooooooo?cnooolo?jOoocl
oP05oooooonAVicoIVInojRY^ooko?d00OmVIWh00006ofIVO_oko?goZ:VkofIVO_nAVicooooooool
o?kooocloYooo?cn00Gooooooi6KW?mVIWkoZ:Vkoo_lo@01ofIVOP0000KoIVInoo_loOnXZK_oIVIn
oi6KW?ooooooooclo_ooo?cnWoolo?h01OooooooTI^LofIVO_nXZK_onocm007oIVIn00001_mVIWko
nocmojRY^omVIWkoTI^Looooooooo?cnooolo?jOoocloP05oooooonAVicoIVInojRY^ooko?d00OmV
IWh00006ofIVO_oko?goZ:VkofIVO_nAVicoooooooolo?kooocloYooo?cn00Gooooooi6KW?mVIWko
Z:Vkoo_lo@01ofIVOP0000KoIVInoo_loOnXZK_oIVInoi6KW?ooooooooclo_ooo?cnWoolo?h01Ooo
ooooTI^LofIVO_nXZK_onocm007oIVIn00001_mVIWkonocmojRY^omVIWkoTI^Looooooooo?cnoool
o?jOoocloP05oooooonAVicoIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nAVi`0
[?olo?koooooooCooooo00CoTI^LofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nA
Vi`0Zoolo?kooi6KW?KoTI^L00?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nA
Vi`0Zoolo?h01?nAVico_[kHokjof?nn_mRYokjnf003oi6W]?oShmooTJNd00;o_[kH0_nn_mS2okjn
f003oi6W]?oShmooTJNd00;o_[kH0_nn_mQeokjnf006oi6W]?oShmoohn?OofIVO_nXZK_onocm0OmV
IWh00005ofIVO_oko?goZ:VkofIVO_nAVi`0Zoolo?h00onAVicoa/SMolK8g@2ZolK8g@03oi6W]?oS
hmooTJNd0<Koa/SM00?oTJNdon?SgonAYk@0NOo6b=d01_nAYkCohn?Oon?SgomVIWkoZ:Vkoo_lo@7o
IVIn00001OmVIWkonocmojRY^omVIWkoTI^L0:_oo?cn00?oTI^Lolc=h_o<cN80Z_o<cN800onAYkCo
hn?Ooi6W]036olc=hP03oi6W]?oShmooTJNd07Woc<gR00KoTJNdon?SgooShmooIVInojRY^ooko?d1
ofIVOP0000GoIVInoo_loOnXZK_oIVInoi6KW02[oocloP03oi6KW?oEenWoeMOY0:[oeMOY00?oTJNd
on?SgonAYk@0a_oEenT00onAYkCohn?Ooi6W]01iomGGj@06oi6W]?oShmoohn?OofIVO_nXZK_onocm
0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nAVi`0Zoolo?h00onAVicofmg]om_Mk@0Uom_Mk@;o0000
1?oKgNd2o`0000;ofmg]1Ol00002om_Mk@Go00001_oKgNd4o`0000;ofmg]0_l00002om_Mk@;o0000
0_oKgNd3o`000003om_MkOoKg>gofmc]00Cofmc]1Ol00005om_Lk@Ko000000Cofmc]o`000?l0003o
fmg]0_l00002om_Mk@;o000000?ofmg]o`000?l000000_oKgNd2o`0000;ofmg]0ol0000Zom_Mk@04
om_LkOnAYkCohn?Ooi6W]2Cofmg]0_l00004om_Mk@;o00000_oKgNd2o`0000;ofmg]1?l00006om_M
k@;o00001?oKgNd2o`0000?ofmg]1Ol00002om_Mk@;o000000?ofmg]o`000?l000000_oKgNd2o`00
00;ofmg]1?l00002om_Mk@;o000000Cofmg]o`000?l0003ofmc]0_l00002om_Lk@Go00000_oKg>d2
o`000003om_LkOl0003o000000;ofmc]1?l00003om_Lk@Go00001OoKgNd5o`0000Cofmg]1?l00003
om_Mk@Co00000_oKgNd2o`0000;ofmg]0_l0000Qom_Mk@04om_LkOnAYkCohn?Ooi6W]2;ofmg]0_l0
0005om_Mk@;o00000ooKg>d4o`0000;ofmc]0_l00002om_Lk@;o00000_oKg>d2o`0000Gofmg]1_l0
0002om_Mk@;o00000_oKgNd2o`0000;ofmg]1Ol0000Pom_Mk@07om_LkOnAYkCohn?Oon?SgomVIWko
Z:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoi6KW02[oocloP03oi6KW?oOgo7ogmoa02Go
gmoa0_l00004omoOl@;o000000?ogmoao`000?l000000_oOgo42o`000003omoOlOl0003o000000;o
gmoa0_l00005omoOl@;o00000_oOgo42o`000003omoOlOl0003o000000;ogmoa0_l000001?oOgo7o
0000o`000?oOgo42o`0000Gogmoa0_l000000ooOgo7o0000o`000006omoOl@;o00001OoOgo42o`00
0003omoOlOl0003o000000;ogmoa0_l000001?oOgo7o0000o`000?oOgo42o`0000;ogmoa0_l00000
0ooOgo7o0000o`00000ZomoOl@03oi6W]?oShmooTJNd02Cogmoa0_l00004omoOl@;o00000_oOgo42
o`000003omoOlOl0003o000000;ogmoa0_l00005omoOl@;o000000Cogmoao`000?l0003ogmoa0_l0
0002omoOl@;o00000_oOgo42o`000003omoOlOl0003o000000;ogmoa0_l00002omoOl@;o000000?o
gmoao`000?l000000_oOgo42o`000004omoOlOl0003o0000omoOl@;o000000Cogmoao`000?l0003o
gmoa0_l00002omoOl@;o000000?ogmoao`000?l000000_oOgo42o`000003omoOlOl0003o000000;o
gmoa0_l000000ooOgo7o0000o`000002omoOl@;o00001OoOgo42o`0000;ogmoa0_l00002omoOl@;o
00000_oOgo42o`000003omoOlOl0003o000000;ogmoa0_l000001?oOgo7o0000o`000?oOgo42o`00
02?ogmoa00?oTJNdon?SgonAYk@08_oOgo42o`0000Gogmoa0_l00002omoOl@;o00000_oOgo42o`00
0003omoOlOl0003o000000;ogmoa0_l000000ooOgo7o0000o`000006omoOl@;o00001_oOgo42o`00
00;ogmoa0_l000000ooOgo7o0000o`000002omoOl@;o00008OoOgo401_nAYkCohn?Oon?SgomVIWko
Z:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoTI^L02Coo?cn1Ol00004oocloPGo000000Co
o?cno`000?l0003oo?cn0_l00002oocloP;o00001Oolo?h2o`000003ooclo_l0003o000000;oo?cn
0_l00005oocloP;o00001_olo?h5o`000003ooclo_l0003o000000;oo?cn0_l00002oocloPCo0000
0oolo?h2o`000003ooclo_l0003o000000;oo?cn1?l00002oocloP;o00000_olo?h2o`0000;oo?cn
0ol0000WoocloP03oi6KW?oUi_CoiNKd02KoiNKd1_l00002onGVm0;o00000_oUi_@2o`000003onGV
m?l0003o000000;oiNKd0_l00005onGVm0;o00000_oUi_@2o`000003onGVm?l0003o000000;oiNKd
0_l00003onGVm0;o00001_oUi_@2o`000003onGVm?l0003o000000KoiNKd0_l00005onGVm0;o0000
00?oiNKdo`000?l000000_oUi_@2o`000003onGVm?l0003o000000;o00001OoUi_@2o`0002_oiNKd
00?oTJNdon?SgonAYk@09?oUi_@2o`0000CoiNKd0_l00002onGVm0;o000000?oiNKdo`000?l00000
2OoUi_@2o`000004onGVm?l0003o0000onGVm0;o00000_oUi_@2o`0000;oiNKd0_l000000ooUi_Co
0000o`000002onGVm0;o00000_oUi_@2o`000003onGVm?l0003o000000GoiNKd0_l000001?oUi_Co
0000o`000?oUi_@2o`000003onGVm?l0003o000000;oiNKd0_l000000ooUi_Co0000o`000002onGV
m0;o000000?oiNKdo`000?l000001OoUi_@2o`0000;oiNKd0_l00005onGVm0;o00000_oUi_@2o`00
00;oiNKd0_l00002onGVm0;o000000?oiNKdo`000?l000000_oUi_@2o`000003onGVm?l0003o0000
00;o00009?oUi_@00onAYkCohn?Ooi6W]00RonGVm0;o00001OoUi_@2o`0000;oiNKd0_l00002onGV
m0;o000000?oiNKdo`000?l000000_oUi_@2o`000003onGVm?l0003o000000KoiNKd0_l00006onGV
m0;o00000_oUi_@2o`000003onGVm?l0003o000000;oiNKd0_l0000QonGVm006oi6W]?oShmoohn?O
ofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nAVi`09?olo?h2o`0000;oo?cn0_l0
0002oocloP;o000000Goo?cno`000?l0003o0000oocloP02o`000004ooclo_l0003o0000oocloP;o
00001_olo?h2o`000003ooclo_l0003o000000;oo?cn0_l00005oocloP;o00001Oolo?h2o`000005
ooclo_l0003o0000o`000?olo?h00_l00002oocloP;o000000?oo?cno`000?l000000_olo?h2o`00
0003ooclo_l0003o000000;oo?cn0_l000000oolo?ko0000o`000002oocloP;o000000?oo?cno`00
0?l000000_olo?h2o`000004ooclo_l0003o0000oocloP;o00009_olo?h00onAVicoj^[hon[Zn00V
on[Zn0;o00000_oZj_P2o`0000;oj^[h0_l00002on[Zn0;o000000?oj^[ho`000?l000000_oZj_P2
o`000005on[Zn?l0003o0000o`000?oZj_P00_l00002on[Zn0;o000000?oj^[ho`000?l000000_oZ
j_P2o`0000;oj^[h0_l00007on[Zn0Ko00001OoZj_P2o`0000Goj^[h0_l000000ooZj_So0000o`00
0002on[Zn0;o000000Coj^[ho`000?l0003o00001OoZj_P2o`0002coj^[h00?oTJNdon?SgonAYk@0
9?oZj_P2o`0000Coj^[h0_l00002on[Zn0;o000000?oj^[ho`000?l000001?l00005on[Zn0So0000
0ooZj_P5o`000003on[Zn?l0003o000000;oj^[h0_l00002on[Zn0;o000000?oj^[ho`000?l00000
1?l000001?oZj_So0000o`000?oZj_P2o`000003on[Zn?l0003o000000;oj^[h1Ol000000ooZj_So
0000o`000002on[Zn0;o000000?oj^[ho`000?l000001_oZj_P5o`0000Goj^[h0_l00002on[Zn0;o
00000_oZj_P2o`0000;oj^[h0_l000000ooZj_So0000o`000002on[Zn0;o000000Coj^[ho`000?l0
003o00009OoZj_P00onAYkCohn?Ooi6W]00Ron[Zn0;o00001OoZj_P2o`0000;oj^[h0_l00002on[Z
n0;o000000?oj^[ho`000?l000000_oZj_P2o`000003on[Zn?l0003o000000Koj^[h0_l00006on[Z
n0;o00000_oZj_P2o`000003on[Zn?l0003o000000;oj^[h0_l0000Qon[Zn006oi6W]?oShmoohn?O
ofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nAVi`09?olo?h2o`0000;oo?cn0_l0
0002oocloP;o00000_olo?h2o`000004ooclo_l0003o0000oocloP;o000000?oo?cno`000?l00000
1_olo?h2o`000003ooclo_l0003o000000;oo?cn0_l00005oocloP;o00001Oolo?h2o`0000;oo?cn
0_l000000oolo?ko0000o`000002oocloP;o000000?oo?cno`000?l000001Oolo?h2o`0000;oo?cn
0_l000000oolo?ko0000o`000002oocloP;o000000?oo?cno`000?l000000_olo?h2o`0000?oo?cn
0_l0000WoocloP03oi6KW?oZj_Woj^[i02Koj^[i0_l00002on[Zn@;o00000_oZj_T2o`0000;oj^[i
0_l000000ooZj_Wo0000o`000002on[Zn@;o00001OoZj_T2o`0000;oj^[i0_l000001OoZj_Wo0000
o`000?l0003oj^[i00;o000000Coj^[io`000?l0003oj^[i0_l00006on[Zn@;o00002?oZj_T2o`00
00Goj^[i0_l000001OoZj_Wo0000o`000?l0003oj^[i00;o000000?oj^[io`000?l000000_l00003
on[Zn@;o000000?oj^[io`000?l00000:_oZj_T00onAYkCohn?Ooi6W]00Ton[Zn@;o00001?oZj_T3
o`000004on[ZnOl0003o0000on[Zn@;o00000_oZj_T2o`0000Goj^[i2?l00006on[Zn@;o000000?o
j^[io`000?l000000_oZj_T3o`000004on[ZnOl0003o0000on[Zn@;o00000_oZj_T2o`000004on[Z
nOl0003o0000on[Zn@;o000000?oj^[io`000?l000001OoZj_T2o`000003on[ZnOl0003o000000;o
j^[i0_l000000ooZj_Wo0000o`000002on[Zn@;o00001OoZj_T2o`0000Goj^[i1Ol00003on[Zn@;o
00000_oZj_T2o`000003on[ZnOl0003o000000;oj^[i0_l000000ooZj_Wo0000o`000002o`0002Co
j^[i00?oTJNdon?SgonAYk@08_oZj_T5o`0000;oj^[i0_l00002on[Zn@;o00000_oZj_T2o`000005
on[ZnOl0003o0000o`000?oZj_T00_l000000ooZj_Wo0000o`000006on[Zn@Go00000ooZj_T3o`00
0004on[ZnOl0003o0000on[Zn@;o00000_oZj_T2o`00027oj^[i00KoTJNdon?SgooShmooIVInojRY
^ooko?d1ofIVOP0000GoIVInoo_loOnXZK_oIVInoi6KW00ToocloP;o00000_olo?h2o`0000;oo?cn
0_l00002oocloP;o000000Coo?cno`000?l0003oo?cn0_l000000oolo?ko0000o`000002oocloP?o
000000Coo?cno`000?l0003oo?cn0_l00002oocloP;o00001Oolo?h2o`0000Goo?cn0_l00002oocl
oP;o000000?oo?cno`000?l000000_olo?h2o`000003ooclo_l0003o000000Goo?cn0_l00002oocl
oP;o000000?oo?cno`000?l000000_olo?h2o`000003ooclo_l0003o000000;oo?cn0_l00002oocl
oP;o0000:?olo?h00onAVicolO7moo7ao@0Woo7ao@Co00001?oalOd5o`0000;olO7m1Ol00006oo7a
o@Co00000_oalOd5o`0000?olO7m0ol00007oo7ao@;o00002?oalOd2o`0000GolO7m0_l000000ooa
lOgo0000o`000003o`0000;olO7m0_l000000ooalOgo0000o`000003oo7ao@?o0000:ooalOd00onA
YkCohn?Ooi6W]00Too7ao@;o00001?oalOd5o`0000?olO7m1?l00006oo7ao@?o00000_oalOd3o`00
00?olO7m1?l00002oo7ao@?o000000?olO7mo`000?l000000ol00003oo7ao@Co00000_oalOd7o`00
00?olO7m1?l00002oo7ao@?o000000?olO7mo`000?l000000_oalOd4o`0000?olO7m1?l00006oo7a
o@;o00000_oalOd2o`0000?olO7m1?l00003oo7ao@Co00000_oalOd2o`000003oo7aoOl0003o0000
02?olO7m00?oTJNdon?SgonAYk@08_oalOd2o`0000GolO7m0ol00002oo7ao@Co00000_oalOd5o`00
00;olO7m0ol00005oo7ao@;o00001_oalOd5o`0000?olO7m1Ol0000Qoo7ao@06oi6W]?oShmoohn?O
ofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nAVi`09?olo?h5o`0000?oo?cn0_l0
0002oocloP;o000000Coo?cno`000?l0003oo?cn0_l000000oolo?ko0000o`000006oocloP;o0000
00Goo?cno`000?l0003o0000oocloP02o`0000Goo?cn1Ol00002oocloP;o00000_olo?h2o`000005
ooclo_l0003o0000o`000?olo?h00_l000000oolo?ko0000o`000002oocloP;o000000?oo?cno`00
0?l000000_olo?h2o`000003ooclo_l0003o000000;oo?cn0_l000001Oolo?ko0000o`000?l0003o
o?cn00;o000000Coo?cno`000?l0003oo?cn0_l0000VoocloP03oi6KW?ofm?gomOCm02OomOCm1?l0
0007ooGdo@;o00001Ooem?d2o`0001gomOCm1?l00007ooGdo@;o00003ooem?d2o`0003ComOCm00Go
TJNdon?SgonAYkComOCmooKdo@0RooGdo@;o00001?oem?d2o`00013omOCm0ol00002ooGdo@?o0000
2Ooem?d2o`0000;omOCm0_l0000LooGdo@;o00005ooem?d2o`0000;omOCm0_l0000@ooGdo@;o0000
9_oem?d01OnAYkCohn?Ooi6W]?oem?gom_Cm023omOCm0_l0000GooGdo@;o00001_oem?d2o`00017o
mOCm0_l0000QooGdo@06oi6W]?oShmoohn?OofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:Vk
ofIVO_nAVi`09?olo?h2o`0000;oo?cn0_l00002oocloP;o00000_olo?h2o`000004ooclo_l0003o
0000oocloP;o000000Coo?cno`000?l0003o00001Oolo?h2o`000003ooclo_l0003o000000?o0000
1_olo?h2o`0000Goo?cn0_l00002oocloP;o000000?oo?cno`000?l000000ol00003oocloPCo0000
0_olo?h3o`000003ooclo_l0003o000000;oo?cn1?l00002oocloPGo00000oolo?h3o`0002Ooo?cn
00?oTI^Loo[io_ojnOh0:?ojnOh2o`0000Son_Wn0_l00005oo[ioP;o00007OojnOh4o`0000Oon_Wn
0_l0000?oo[ioP;o0000=?ojnOh00onAYkCohn?Ooi6W]00Too[ioP;o00001?ojnOh2o`00013on_Wn
0_l00004oo[ioP;o00002OojnOh2o`0000;on_Wn0_l0000Loo[ioP;o00005oojnOh2o`0000;on_Wn
0_l0000@oo[ioP;o00009_ojnOh00onAYkCohn?Ooi6W]00Roo[ioP;o00005oojnOh2o`0000Kon_Wn
0_l0000Aoo[ioP;o00008OojnOh01_nAYkCohn?Oon?SgomVIWkoZ:Vkoo_lo@7oIVIn00001OmVIWko
nocmojRY^omVIWkoTI^L02Coo?cn0_l00002oocloP;o00003?olo?h2o`000003ooclo_l0003o0000
01Coo?cn0_l0000JoocloP;o0000?_olo?h00onAVicoooooooooo`0Xooooo`;o00002?ooool2o`00
00Gooooo0_l0000Nooooo`;o00002?ooool2o`0000Gooooo0_l00008ooooo`;o0000=?ooool00onA
YkCohn?Ooi6W]00Rooooo`Ko00000_ooool2o`00013ooooo0_l00004ooooo`;o00003Oooool2o`00
023ooooo0_l0000Cooooo`Go00004Oooool2o`0002Kooooo00?oTJNdon?SgonAYk@08_ooool6o`00
01_ooooo1_l0000=ooooo`;o00008Oooool01_nAYkCohn?Oon?SgomVIWkoZ:Vkoo_lo@7oIVIn0000
1OmVIWkonocmojRY^omVIWkoTI^L02Coo?cn0_l00002oocloP;o00003?olo?h2o`000003ooclo_l0
003o000001Coo?cn0_l0000JoocloP;o0000?_olo?h00onAVicoooooooooo`2Zooooo`03oi6W]?oS
hmooTJNd0<Kooooo00?oTJNdon?SgonAYk@0NOooool01_nAYkCohn?Oon?SgomVIWkoZ:Vkoo_lo@7o
IVIn00001OmVIWkonocmojRY^omVIWkoTI^L02Coo?cn1Ol0000:oocloP;o000000?oo?cno`000?l0
00002Oolo?h2o`0000coo?cn1_l0000JoocloP;o0000>_olo?h00onAVicoooooooooo`2Yooooo`05
ooKdl_nAYkCohn?Ooi6W]?omoO`0a?ooool01Oofm?;oTJNdon?SgonAYkCooOgl07Oooooo00Oom_Cb
oi6W]?oShmoohn?OofIVO_nXZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoTI^L0:_oo?cn
00?oTI^Lookno_ooool0Z?ooool01oono_gohnW[ojVi_ooShmooZKVoon?Yk?ono_h0`_ooool01oon
o_gohnW[ojVi_ooShmooZKVoon?Yk?ono_h0MOooool00oono_gohnW[ojVi_`02on?Sg`03ofIVO_nX
ZK_onocm007oIVIn00001OmVIWkonocmojRY^omVIWkoTI^L0:_oo?cn00?oTI^LonCYk?ooool0Z?oo
ool01oo]lO?o]/C=om3Fd?oShmood=K@okK4cOoTjN`0`_ooool01oo]lO?o]/C=om3Fd?oShmood=K@
okK4cOoTjN`0MOooool00oo]lO?o]/C=om3Fd002on?Sg`03ofIVO_nXZK_onocm007oIVIn00001_mV
IWkonocmojRY^omVIWkogJ5CooVh>:WoolLl00?onKPhomfQDonY^Kl0ZOnAYk@00onQ/k_ob=7=on?S
g`02on?Sg`03om3Fd?nY^KooTJNd0<7oTJNd00?oXK>kolSAcOoShml00_oShml00oo@e]3oZKVooi6W
]01doi6W]003oj6c^oo8dLgohn?O00;ohn?O00?oIVInojRY^ooko?d00OmVIWh00007ofIVO_oko?go
Z:VkofIVO_oQaXkokYlaooVi>02Wooo8?003oo^n>Oo^Wc7ohLJ>01Oo_[kH00?oTJNdon?SgonAYk@0
0_nn_]P2okjof8[o_[kH00?oTJNdon?SgonAYk@00_nn_]P2okjof8go_[kH00?oTJNdon?SgonAYk@0
0_nn_]P2okjof:ko_[kH00KoTJNdon?SgooShmooIVInojRY^ooko?d1ofIVOP0000OoIVInoo_loOnX
ZK_oIVInon?SgooQaXkojiL^0:OoiX//00?oi9Llomg2SOoakml05oo6b=d00onAYkCohn?Ooi6W]02>
olK8g@03oi6W]?oShmooTJNd097oa/SM00?oTJNdon?SgonAYk@0/_o6b=d01_nAYkCohn?Oon?SgomV
IWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh2on3Oh`03oi6W]?o<cN;oc<gR05Koc<gR
1Ol0001Tolc=hP03oi6W]?oShmooTJNd08koc<gR00?oTJNdon?SgonAYk@0TOo<cN800onAYkCohn?O
oi6W]02bolc=hP06oi6W]?oShmoohn?OofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIV
OP;oh=oS00?oTJNdomGGjOoEenT0F_oEenT2o`0006?oeMOY00?oTJNdon?SgonAYk@0S_oEenT00onA
YkCohn?Ooi6W]02AomGGj@03oi6W]?oShmooTJNd0;;oeMOY00KoTJNdon?SgooShmooIVInojRY^ook
o?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn0_oPgn<00onAYkCofmg]om_Mk@0eom_Mk@Ko00000ooK
gNd4o`0000?ofmg]0_l00002om_Mk@;o000000Cofmg]o`000?l0003ofmg]0_l00002om_Mk@;o0000
0_oKgNd5o`0000?ofmg]0ooKg>d4o`0000Cofmc]0_l00002om_Lk@Go000000?ofmc]o`000?l00000
0ooKg>d2o`0000;ofmc]1?l00003om_Mk@Go0000=OoKgNd01?oKg>goTJNdon?SgonAYk@hom_Mk@;o
00001OoKgNd4o`0000?ofmg]1Ol000000ooKg>go0000o`00000@om_LkBoofmg]00Cofmc]oi6W]?oS
hmooTJNd=_oKgNd5o`0000Gofmg]1?l00002om_Mk@;o000000Cofmg]o`000?l0003ofmc]0_l00002
om_Lk@Co00000ooKg>d3o`0000Kofmc]<?oKgNd01?oKg>goTJNdon?SgonAYk@fom_Mk@;o00001?oK
gNd2o`0000?ofmg]1Ol00002om_Mk@?o00000ooKgNd2o`0000;ofmg]1?l00002om_Mk@;o00001_oK
g>d2o`0000;ofmc]0_l00002om_Lk@;o00000_oKg>d5o`0000;ofmc]1?l00002om_Mk@;o000000?o
fmg]o`000?l00000<ooKgNd01ooKg>goTJNdon?SgooShmooIVInojRY^ooko?d00OmVIWh00004ofIV
O_oko?goZ:VkofIVOP;oh=oS00?oTJNdomoOlOoOgo40=?oOgo42o`0000;ogmoa0ol00002omoOl@;o
00000_oOgo42o`000003omoOlOl0003o000000;ogmoa0_l00002omoOl@;o000000?ogmoao`000?l0
00000_oOgo42o`000003omoOlOl0003o000000;ogmoa0_l00005omoOl@;o00000_oOgo42o`0000;o
gmoa0_l00002omoOl@;o00000_oOgo42o`000003omoOlOl0003o000000;ogmoa0_l00002omoOl@;o
00000_oOgo42o`000003omoOlOl0003o000000;ogmoa0_l0000fomoOl@03oi6W]?oShmooTJNd03So
gmoa0_l00004omoOl@;o00000_oOgo42o`000004omoOlOl0003o0000omoOl@?o000000?ogmoao`00
0?l00000@?oOgo400onAYkCohn?Ooi6W]00fomoOl@;o00000_oOgo42o`0000?ogmoa0_l00002omoO
l@;o000000Cogmoao`000?l0003ogmoa0_l000001?oOgo7o0000o`000?oOgo42o`0000;ogmoa0_l0
00001?oOgo7o0000o`000?oOgo42o`0003Kogmoa00?oTJNdon?SgonAYk@0=_oOgo42o`000004omoO
lOl0003o0000omoOl@;o00000_oOgo42o`0000;ogmoa0_l000001?oOgo7o0000o`000?oOgo42o`00
0003omoOlOl0003o000000;ogmoa0_l00002omoOl@;o000000?ogmoao`000?l000001_oOgo42o`00
00;ogmoa0_l00002omoOl@;o000000?ogmoao`000?l000000_oOgo42o`000003omoOlOl0003o0000
00;ogmoa0_l000001?oOgo7o0000o`000?oOgo42o`0003Cogmoa00KoTJNdon?SgooShmooIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn0_oPgn<00onAYkCoiNKdonGVm00donGVm0;o0000
0ooUi_@2o`0000;oiNKd0_l00005onGVm0;o00000_oUi_@2o`0000;oiNKd0_l000000ooUi_Co0000
o`000002onGVm0;o000000?oiNKdo`000?l000000_oUi_@2o`0000WoiNKd0_l00002onGVm0;o0000
0_oUi_@2o`0000;oiNKd0_l000000ooUi_Co0000o`000002onGVm0;o00000_oUi_@2o`0000GoiNKd
0_l00002onGVm0;o0000=_oUi_@00onAYkCohn?Ooi6W]00honGVm0;o00001?oUi_@2o`0000;oiNKd
0_l000000ooUi_Co0000o`000002onGVm0;o000000?oiNKdo`000?l00000@?oUi_@00onAYkCohn?O
oi6W]00fonGVm0;o00000ooUi_@2o`0000;oiNKd0_l00005onGVm0;o000000CoiNKdo`000?l0003o
iNKd0_l000000ooUi_Co0000o`000002onGVm0;o00000ooUi_@2o`0003OoiNKd00?oTJNdon?SgonA
Yk@0=_oUi_@2o`000004onGVm?l0003o0000onGVm0;o00000_oUi_@2o`0000;oiNKd0_l00003onGV
m0;o00000_oUi_@2o`0000;oiNKd0_l00005onGVm0;o00001_oUi_@2o`0000;oiNKd0_l00002onGV
m0;o000000?oiNKdo`000?l000000_oUi_@2o`000003onGVm?l0003o000000KoiNKd0ol0000eonGV
m006oi6W]?oShmoohn?OofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOP;oh=oS00?o
TJNdon[Zn?oZj_P0=?oZj_P2o`0000?oj^[h0_l00002on[Zn0Ko000000?oj^[ho`000?l000000_oZ
j_P2o`0000;oj^[h0_l000000ooZj_So0000o`000002on[Zn0;o000000?oj^[ho`000?l000000_oZ
j_P2o`0000Woj^[h0_l00002on[Zn0;o00000ooZj_P5o`000003on[Zn?l0003o000000;oj^[h0_l0
0002on[Zn0Ko000000?oj^[ho`000?l000000_oZj_P2o`0003Koj^[h00?oTJNdon?SgonAYk@0>?oZ
j_P2o`0000Coj^[h0_l00002on[Zn0;o000000?oj^[ho`000?l000000_oZj_P2o`000003on[Zn?l0
003o0000043oj^[h00?oTJNdon?SgonAYk@0=_oZj_P2o`0000?oj^[h0_l00002on[Zn0Ko000000Co
j^[ho`000?l0003oj^[h0_l000001?oZj_So0000o`000?oZj_P2o`0000;oj^[h0_l00002on[Zn0;o
0000>?oZj_P00onAYkCohn?Ooi6W]00fon[Zn0So00000ooZj_P5o`0000;oj^[h0_l00003on[Zn0;o
00000_oZj_P6o`000003on[Zn?l0003o000000Koj^[h0_l00002on[Zn0;o00000_oZj_P2o`000003
on[Zn?l0003o000000;oj^[h0_l000000ooZj_So0000o`000004o`0000;oj^[h0ol0000eon[Zn006
oi6W]?oShmoohn?OofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOP;oh=oS00?oTJNd
on[ZnOoZj_T0=?oZj_T2o`000003on[ZnOl0003o000000;o00000_oZj_T2o`0000;oj^[i0_l00000
0ooZj_Wo0000o`000002on[Zn@;o00000_oZj_T2o`000005on[ZnOl0003o0000o`000?oZj_T00_l0
00000ooZj_Wo0000o`000002on[Zn@;o00001_oZj_T4o`0000?oj^[i0_l00006on[Zn@;o000000?o
j^[io`000?l000000_oZj_T2o`0000;oj^[i0_l00002on[Zn@;o000000?oj^[io`000?l000000_oZ
j_T2o`0003Koj^[i00?oTJNdon?SgonAYk@0>?oZj_T2o`0000Coj^[i0_l00002on[Zn@;o000000?o
j^[io`000?l000000_oZj_T2o`000003on[ZnOl0003o0000043oj^[i00?oTJNdon?SgonAYk@0=_oZ
j_T2o`0000?oj^[i0_l00002on[Zn@;o00000_oZj_T2o`000004on[ZnOl0003o0000on[Zn@;o0000
00Coj^[io`000?l0003oj^[i0_l00002on[Zn@;o000000Coj^[io`000?l0003oj^[i0_l0000fon[Z
n@03oi6W]?oShmooTJNd03Koj^[i2?l00006on[Zn@;o000000Coj^[io`000?l0003oj^[i0_l00000
0ooZj_Wo0000o`000002on[Zn@;o00000_oZj_T2o`000003on[ZnOl0003o000000Koj^[i0_l00002
on[Zn@?o000000Coj^[io`000?l0003oj^[i0_l00002on[Zn@;o000000?oj^[io`000?l000000_oZ
j_T2o`000004on[ZnOl0003o0000on[Zn@;o0000=?oZj_T01_nAYkCohn?Oon?SgomVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWh2on3Oh`03oi6W]?oalOgolO7m03ColO7m0_l00008oo7a
o@Co00000_oalOd3o`000005oo7aoOl0003o0000o`000?oalOd00_l000000ooalOgo0000o`000003
o`0000?olO7m1Ol00005oo7ao@;o00001_oalOd3o`0000;olO7m1?l00002oo7ao@?o000000ColO7m
o`000?l0003o00000_oalOd4o`0000?olO7m1Ol0000foo7ao@03oi6W]?oShmooTJNd03SolO7m0_l0
0005oo7ao@Co00000_oalOd2o`0000;olO7m0_l000001?oalOgo0000o`000?l0000ooo7ao@03oi6W
]?oShmooTJNd03KolO7m0_l00003oo7ao@;o00000ooalOd4o`0000;olO7m1ol00003oo7ao@Co0000
0ooalOd3o`0003OolO7m00?oTJNdon?SgonAYk@0=_oalOd3o`0000;olO7m0ol00003oo7ao@Co0000
0ooalOd3o`0000;olO7m0ol00002oo7ao@Co00000_oalOd3o`0000GolO7m0_l00002oo7ao@Go0000
0ooalOd5o`0000;olO7m1?l00002oo7ao@;o000000?olO7mo`000?l00000=?oalOd01_nAYkCohn?O
on?SgomVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh2on3Oh`03oi6W]?oem?gom_Cm
03ComOCm0_l0000>ooGdo@;o00000_oem?d2o`0001OomOCm0_l00006ooGdo@;o00003Ooem?d2o`00
00gomOCm0_l0000fooGdo@05oi6W]?oShmooTJNdooGdoOofm?d0=_oem?d2o`0005ComOCm00GoTJNd
on?SgonAYkComOCmooKdo@0dooGdo@;o00000ooem?d2o`0005ComOCm00GoTJNdon?SgonAYkComOCm
ooKdo@0dooGdo@?o00000_oem?d3o`0000oomOCm0_l0000AooGdo@;o00003Ooem?d2o`00047omOCm
00KoTJNdon?SgooShmooIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn0_oPgn<00onA
YkCon_Wnoo[ioP0doo[ioP;o00000oojnOh2o`0000Won_Wn0_l00002oo[ioP;o00005oojnOh2o`00
00;on_Wn0_l00002oo[ioP;o00003OojnOh2o`0000gon_Wn0_l0000foo[ioP03oi6W]?oShmooTJNd
03Son_Wn0_l0001Doo[ioP03oi6W]?oShmooTJNd03Kon_Wn0_l00002oo[ioP;o0000EOojnOh00onA
YkCohn?Ooi6W]00foo[ioP;o00001?ojnOh2o`0000oon_Wn0_l0000Aoo[ioP;o00003OojnOh2o`00
047on_Wn00KoTJNdon?SgooShmooIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn0_oP
gn<00onAYkCoooooooooo`0eooooo`Go00004_ooool2o`0001Cooooo1?l0000Qooooo`;o0000=_oo
ool00onAYkCohn?Ooi6W]00fooooo`Ko0000D_ooool00onAYkCohn?Ooi6W]00fooooo`Go0000E_oo
ool00onAYkCohn?Ooi6W]00fooooo`;o00001?ooool2o`0002;ooooo0_l0000=ooooo`;o0000@Ooo
ool01_nAYkCohn?Oon?SgomVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh2on3Oh`03
oi6W]?oooooooooo0;oooooo00?oTJNdon?SgonAYk@0S_ooool00onAYkCohn?Ooi6W]02Aooooo`03
oi6W]?oShmooTJNd0;;ooooo00KoTJNdon?SgooShmooIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn0_oPgn<00onAYkCooOglooooo`2nooooo`05ooKdl_nAYkCohn?Ooi6W]?omoO`0S?oo
ool01Oofm?;oTJNdon?SgonAYkCooOgl08oooooo00Gom_Cboi6W]?oShmooTJNdoogmo02`ooooo`07
ooKdl_nAYkCohn?Oon?SgomVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn0_oPgn<0
0onY^KoohnW/ooknoP2mooooo`07ooknoOoSjN_oZKVoon?SgonY^KoohnW/ooknoP2:ooooo`07ookn
oOoSjN_oZKVoon?SgonY^KoohnW/ooknoP2=ooooo`07ooknoOoSjN_oZKVoon?SgonY^KoohnW/ookn
oP2^ooooo`03ooknoOoSjN_oZKVo00;ohn?O00?oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?go
Z:VkofIVOP;oh=oS00?od=K@okK4cOoTjN`0_Oooool01oo]lO?o]/C=om3Fd?oShmood=K@okK4cOoT
jN`0R_ooool01oo]lO?o]/C=om3Fd?oShmood=K@okK4cOoTjN`0SOooool01oo]lO?o]/C=om3Fd?oS
hmood=K@okK4cOoTjN`0[_ooool00oo]lO?o]/C=om3Fd002on?Sg`03ofIVO_nXZK_onocm007oIVIn
00001?mVIWkonocmojRY^omVIWh2on3Oh`03on?Sgoo@e]3oZKVo0;goTJNd00?oXK>kolSAcOoShml0
0_oShml00oo@e]3oZKVooi6W]029oi6W]003oj6c^oo8dLgohn?O00;ohn?O00?od=K@ojVi_onAYk@0
S?nAYk@00onQ/k_ob=7=on?Sg`02on?Sg`03om3Fd?nY^KooTJNd0:goTJNd00?oXK>kolSAcOoShml0
0_oShml00omVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooPgn?oon3Ohj?oh=oS
00?oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooh=oSoooPgn>Son3Oh`03ofIV
O_nXZK_onocm007oIVIn00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oSXooPgn<00omVIWkoZ:Vk
oo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooPgn?oon3Ohg_oh=oS:?o[jn/00omVIWkoZ:Vk
oo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooPgn?oon3Ohg_oh=oS00?ojn_[omkNg_oNg]h0
3?oNg]h03?oLg=cofMWIomCDe?oEeMGoemOGomWIfOoGemOoe=CDom;Bd_oDe=Cof][JomgMg@cog]kN
00CoZ:RXofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooh=oSoooPgn=kon3Oh`03
on_[jooLg=cog=cL00Cog=cL00Cofm_KomWIfOoHf=Sof=SH0ooIfMT03OoGemOoc/k>ol30`?nf][Ko
]kNgokfm_Oo0`<3o^k^kok>c/on^[Zko]KFeolO7aooEeMD01_oIfMT00ooJf][ofm_KomcLg003omcL
g004ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oSNooPgn<0
0oo[jn_ofMWIomWIf@03omWIf@03omSHf?oCdm?oalO700;o`L7100Ko`l?3olG5aOo5aLGo_knook2`
/?nSXj<2oifMW@08oj2PX?nQXJ7oWinOoibLW?nJVY[oWIfMoj^[Zonm_Kd3olG5a@05olC4a?o3`l?o
alO7om3@d?oGemL01?oIfMT01?nXZ:SoIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn
oooPgn?oon3Ohg_oh=oS00?ojn_[omOGeooGemL00ooGemL01?oEeMGob/[:okJf]_nVYZH2oj:RXP;o
Xj>S00?oX:2PoiZJV_nGUiL01onFUYH00onGUiOoVIVIoinOW`03oj>SX`05ojBTY?nZZZ[o^[Zjolc<
c?oEeMD01?oGemL01?nXZ:SoIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooPgn?o
on3Ohg_oh=oS00?ojn_[omCDe?oDe=@00ooDe=@01_oBd];obl_;okVi^OnSXj?oUYJFoiBDU0;oUIFE
3OnDU9@3oiFEU@05oiRHV?nWYjOo_[jnolg=cOoBd]801?oDe=@01?nXZ:SoIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInoooPgn?oon3Ohg_oh=oS00?ojn_[om7AdOoAdM400ooAdM401Oo@
d=3ob/[:okRh^?nQXJ7oU9BD01;oTY:B00KoTi>CoiNGUonTY:Co]KFeol?3`oo>c/h4om7Ad@04ojRX
Z?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh8on3Oh`05on7Pi?oViNSok>_^oo3`
l_obl_@02?oclo@7ooSgn0;olo?d00Golo?eooCdmOoemOKom??eonGTj03oon3Oha3oh=oS00GohN3T
onKUj?o/jnkol?3boo;bm008oo?cm0Oon?Oh0_oclo@01OocloGom?CeooGem_odloGoiNCX00Koh=oS
00GohN3TonKUj?o/jnkol?3boo;bm008oo?cm0Oon?Oh0_oclo@01OocloGom?CeooGem_odloGoiNCX
00?oh=oS00GohN3TonKUj?o/jnkol?3boo;bm008oo?cm0Oon?Oh0_oclo@01OocloGom?CeooGem_od
loGoiNCX0>goh=oS00?ojn_[olo?coo?cll00oo?cll01Oo<c<co_[jnojNWYonGUiOoTI6A01;oT92@
00KoTY:Boi^KVon_[joo_;blolG5aOo=cLd4olo?c`04ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWh8on3Oh`04omgLgooTh^3oNiN/obEFQ1?o03ad00Co5Tenof^;YOoalNgol_7c
2?oPgn<00oo@clkoaLC1olC3_`0ColC3_`03olg<booPgn?oh=oS0>koh=oS00CogMcOonCRh?mkUjco
9EJ44ol0?7@01?lFCGkoJh^Uoo7akOoblO<6on3Oh`04omgLgooTh^3oNiN/obEFQ1?o03ad00Co5Ten
of^;YOoalNgol_7c0ooPgn<01?oMg=ooi>;Pog^G[?lUEX@Co`0lM004oaI=O_m[RjGolO7]oo;alngo
h=oS00?ojn_[olc<c?o<c<`00oo<c<`01?o7alOo][JfoinOWonFUYH3oiFEU@06oiBDU?nBTY;oShn?
ohj>S_miNGWoSHb<0on>SXh01?n3Ph?oLd@Oof=OE_n@T903oi6AT@06oi:BT_nKVi_o/k>col;2`_o9
bLWobl_;1?o<c<`01?nXZ:SoIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn2?oPgn<0
1?oJf=WoIHFQodYaTonb_L<ColK5e`04ol36aOm8KY3oJHZSono_l@Ooh=oS00?ocLc;om?Bc_oVi^80
4ooalNd00ooZj^Kodm;>olg<b`07on3Ohn?oYJbb1OoPgn<01?oJf=WoIHFQobM=QOm=OL4DofV2kP03
obM=QOmYRZ?oknoa00Koh=oS00Cof]SIofF5XOm:LI?o/[g34oo6aML01?o0a/GoB6j@ofV:Xoo_ko43
on3Oh`04om[HfOmUQJ7oBW6Cok:m`a?oa/GG00Co`<K5odQ^T?mYRZ?oknoakOoPgn<00oo[jn_obLW9
olW9b@03olW9b@04olO7aonm_Kgo/;2`oj^[Z`?oZJVY00goYjNWoj2PX?nEUIGoRh^;oiiT6omcGTGo
Ti>Coi2@T?n2PX;oL3<QonF37?nAQC_oVYZJ00?oWinO00GoWYjNoj:RX_n][Jgo_;blolK6aP05olW9
b@04ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh8on3Oh`03omSEe_lFCGko
_lO:01Goa/GG00?o][fmoaI=O_o[j^d01ooPgn<00oo4`kooj^[Voo7ak@0Doo7ak@03on[Zi_o4`koo
h=oS00Koh=oS00?oYJbbooooooooool0goooool00onU[;;oh=oSon3Oh`03on3Oh`03omSEe_lFCGko
RJgT01KoRJgT00?o5Tenon_ZkOoPgn<01OoPgn<00ooHeMKo5Tenoko7bP0EolK5e`03okJm_OlFCGko
jn[]00?oh=oS00?of=GFoaI=O_noalX05Oo6aML00onf_Kgo5Tenon_Zk@3]on3Oh`03on_[joo6a/Ko
a/K600?oa/K600CoaLG5olC4a?o1`L7o`<300_no_kl03_nn_[ko_KfmokRh^?nXZ:SoKVMMoonS6?oo
WASoPFi?ohR8ROn4@1oo]SL>omVO8_ohg37oWinO1_nj^[X00ono_kooa<C4olK6aP04olK6aP04ojRX
Z?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh8on3Oh`03omSEeOl0?7Cooooo01Go
cLcO00?oooooo`0lM?oXinX01ooPgn<00oo4`koolO7]oo7ak@0Eoo7ak@03olC3_ooPgn?oh=oS00Go
h=oS00?oYJbbooooooooool0goooool00onU[;;oh=oSon3Oh`03on3Oh`04omSEeOl0?7CoRJgToooo
oa?ocLcO00CoooooohV]i?l0?7Coj>OZ1_oPgn<00ooHeMGo03adooooo`0Eolg<g`03ooooool0?7Co
j>OZ00?oh=oS00?of=GEo`0lM?ooool05Oo=c=l00ooooooo03adonSWjP3]on3Oh`03on_[joo3`l?o
`l?300_o`l?300co`L71ok2`/?o1Magooi/GoonK6?oNPaKoWSl>ol133onP>@oojl/[oooo>_n7PVl5
ol;2`P;o`L711_o3`l<01?nXZ:SoIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn2?oP
gn<00ooHeMGo03adooooo`0Eom;Ai003ooooool0?7CoinKY00Ooh=oS00?oa<>ooo7akOoalNd05Ooa
lNd00oo4`kooh=oSon3Oh`05on3Oh`03ojF//_oooooooooo0=oooooo00?oYJbbon3OhooPgn<00ooP
gn<01?oHeMGo03adoh^]i?oooolCom;Ai004oooooon;[nGo03adonOVj@Koh=oS00?of=GEo`0lM?oo
ool05OoBdN@00ooooooo03adonOVj@03on3Oh`03omSEeOl0?7Cooooo01God]7T00?oooooo`0lM?oW
i^T0kOoPgn<00oo[jn_o`L71ol71`@0<ol71`@0;ohAaFOooWASod7lBojYP2onL?@ko]D8@oj/e3OnZ
EQComNLboooo>?nZUTL03Oo1`L401?nXZ:SoIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVIn2?oPgn<00ooHeMGo03adooooo`0EomKGi`03ooooool0?7CoinKY00Ooh=oS00?oa<>ooo7akOoa
lNd05OoalNd00oo4`kooh=oSon3Oh`05on3Oh`03ojF//_oooooooooo0=oooooo00?oYJbbon3OhooP
gn<00ooPgn<01?oHeMGo03adohj_i_oooolComKGi`04oooooon=[nGo03adonOVj@Koh=oS00?of=GE
o`0lM?ooool05OoFenL00ooooooo03adonOVj@03on3Oh`03omSEeOl0?7Cooooo01Goe]OW00?ooooo
o`0lM?oWi^T0kOoPgn<00oo[jn_o_[jnokjn_P04okjn_P03okFd]?nASXcoY:BT00Co_[jn00goXZ:P
omF06OokTaGo_IQFok1h=?ngA`3o/T0?ojHa3Oo4QAkoooPfoooo>?oMeCCoYJBS00co_[jn00CoZ:RX
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOPSoh=oS00?of=GEo`0lM?ooool03?oI
f^L00ooAc<Ooa<6jomWJi`06omWJi`03ooooool0?7CoinKY00Ooh=oS00?oa<>ooo7akOoalNd01Ooa
lNd00oo;bL7olO7]oo7ak@0=oo7ak@03olC3_ooPgn?oh=oS00Goh=oS00?oYJbbooooooooool0gooo
ool00onU[;;oh=oSon3Oh`03on3Oh`04omSEeOl0?7CoTK7Wooooo`CofM[W0ol000000ooIf^Oo0000
omWJi`02omWJi`?o00001?oIf^L01?ooooooTK7Vo`0lM?oWi^T6on3Oh`03omSEeOl0?7Cooooo01Go
fM[W00?oooooo`0lM?oWi^T00ooPgn<00ooHeMGo03adooooo`0EomWJi`03ooooool0?7CoinKY0>go
h=oS00?ojn_[ok^k^onk^k/01?nk^k/06oni^KWoM5]5oj108_nN717oRcTboh1MF_n7QHGoS6]3oonK
5_o?QB3oglZLon3<TooAMaGo`TD1oilb4?oL^2Sooo@eonc:<?oO`2koNFmBoh9oNOn1NF[oQW]QohIi
FOn?NTgoXh<logM`H@05ok^k^`04ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWh8on3Oh`03omSEeOl0?7Cooooo00_ofM[W00?ob/JoojZYYOnDU9<01ooIf^L00ooooooo03adonOV
j@07on3Oh`03olC3_ooalNgolO7]00GolO7]00?o^kRaokbj]?oalNd03OoalNd00oo4`kooh=oSon3O
h`05on3Oh`05ojF//_ooooooooooooooool000001_ooool00ol0003oooooooooo`03o`0000?ooooo
00?o0000ooooooooool00ol00002ooooo`Co0000`_ooool00onU[;;oh=oSon3Oh`03on3Oh`04omSE
eOl0?7CoU;CXooooo`?ofM[W00Co0000omWJiooIf^OofM[W0_l00002omWJi`05o`000?oIf^OofM[W
omWJiol000000ooIf^L01?ooooooUKCXo`0lM?oWi^T6on3Oh`03omSEeOl0?7Cooooo00GofM[W00?o
aL6moiBDTonBTY801OnBTY800onBTI7o^;FbomWJi`05omWJi`03ooooool0?7CoinKY00?oh=oS00?o
f=GEo`0lM?ooool02OoIf^L00onm^kKo]K>_omWJi`09omWJi`03ooooool0?7CoinKY0>goh=oS00?o
jn_[okVi^Oni^KT01Oni^KT06_maKfko/Xm/oiQF=Oo17`OoiA<0ojhK1?nnMQOod88?ol6KF_o_e9_o
k]FPolVVJOo0B`3oYCl?on_L;_ojgSOoiJm1oo6kA?ooaTGoom5:oooCBooofdgooma>oooODOoicDSo
TI6@1Oni^KT01?nXZ:SoIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn2?oPgn<00ooH
eMGo03adooooo`0:omkOk004okVf/_nHUiKoSXj>oi:BT@Oog]o/00?oooooo`0lM?oWi^T01ooPgn<0
0oo4`koolO7]oo7ak@05oo7ak@04okbj]?nf/Zoo^KBbolC0^`colO7]00?oa<>oon3OhooPgn<01OoP
gn<01OnU[;;ooooooooooooooooo000000Kooooo00?o0000ooooool000000oooool00ol0003ooooo
o`000002ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`03o`000?oooooooooo
0;oooooo00?oYJbbon3OhooPgn<00ooPgn<01?oHeMGo03adoiRhj_ooool3omkOk003o`000?oNgnco
g]o/00;og]o/00Co0000omkOk?oNgnco00000ooNgn`02?l0003og]o/omkOk?oNgncooooooiRhjOl0
?7CoinKY1_oPgn<00ooHeMGo03adooooo`05omkOk003om7<a_nXYZCoSXj>00CoSXj>00?oQHF5ogim
O?o9aKl01_oNgn`00ooooooo03adonOVj@03on3Oh`03omSEeOl0?7Cooooo00Sog]o/00Cocl_5oj:Q
WonCTi;oal>l2OoNgn`00ooooooo03adonOVj@3]on3Oh`04on_[jonf][Ko][JfokFe]@?o][Jf01[o
NWAWohagC?o3UT;oajE:okRE>ooGVCCogJXkonFf?_neUTOog<2>onc:R_oYbHgokMVTokUm@?ngJPOo
oo`foooQ>oomaDSoo<A8ooc6B_oobdcoo/E8oo[1Aook_dKooma=ohahB`Ko][Jf00CoZ:RXofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOPSoh=oS00?of=GEo`0lM?ooool02?oSiO000oo0
_[OoXj:Pohj>SP02ohj>SP03ogemOOoSiO3ohnG`00GohnG`00?oooooo`0lM?oWi^T01ooPgn<00oo4
`koolO7]oo7ak@05oo7ak@05ok^i/ond/Zgo];:]okFb/?nj^;802ooalNd00oo4`kooh=oSon3Oh`05
on3Oh`05ojF//_ooooooooooooooool000001_ooool00ol0003oooooo`000003ooooo`03o`000?oo
oooo000000Kooooo00?o0000ooooool000001?ooool00ol0003oooooooooo`2nooooo`03ojF//_oP
gn?oh=oS00?oh=oS00Cof=GEo`0lM?nL^n[ooooo0ooSiO000ol0003ohnG`on?Ul002on?Ul004o`00
0?oSiO3ohnG`o`0000?ohnG`00So0000on?Ul?oSiO3ohnG`oooooonL^n_o03adonOVj@Koh=oS00?o
f=GEo`0lM?ooool01_oSiO002?o5`[coOgmnoginO_n:RX[oR8R8og=cLomHF5SoZJNR1ooSiO000ooo
oooo03adonOVj@03on3Oh`03omSEeOl0?7Cooooo00SohnG`00Co^[Ncohn?Son>SXkoZjZV2OoSiO00
0ooooooo03adonOVj@3]on3Oh`03on_[jond];Co];Bd00Co];Bd01[oMFmSooo8A?oma4;oolU6ooo?
BOooe4goomI<on^g@ooD]7KojlfFonW;SooYbXoojlbComg0T_o0S2ooonLWoooR??oi`DWonlM;ooZo
@_oJX37okK]5ooo8BOoobTWoll55oh^:RPKo];Bd00CoZ:RXofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVOPSoh=oS00?of=GEo`0lM?ooool01_oYjoD00oo6a;coZJRToi>BTP03ohj>SP03
ohN7QomgMgKojN_e00KojN_e00?oooooo`0lM?oWi^T01ooPgn<00oo4`koolO7]oo7ak@05oo7ak@08
ok^i/ond/Zgo];:]okBb[?nd/Zgo];:^okfk]Oo8a[h8oo7ak@03olC3_ooPgn?oh=oS00Goh=oS00Go
YJbbooooooooooooooooo`000006ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool00000
1_ooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo0;kooooo00?oYJbbon3OhooPgn<0
0ooPgn<01?oHeMGo03adoj2nk?ooool3onW[m@03o`000?oYjoGojN_e00?o00000_oYjoD01Ol0003o
jN_eonW[mOoYjoGo000000?ojN_e00Cooooooj6nk?l0?7CoinKY1_oPgn<00ooHeMGo03adooooo`07
onW[m@06ojj[YomdM7CoOWinogUiNOmOGeooP7il2?oYjoD00ooooooo03adonOVj@03on3Oh`03omSE
eOl0?7Cooooo00OojN_e00KobLK0oiZJVOn>SXkoSXj>oi2@Soo0_[T8onW[m@03ooooool0?7CoinKY
0>goh=oS00?ojn_[ok:b/_nb/[801Onb/[806?n;NeKoomA<oo_4Aooj`dOonl97ooVo@Oo;YU?oh<F@
on_;T?oU^7gok=2BoncDU_o]fJ;ock:2om:J6?oohSKonlY=ooF`=Oo_U1cohX<BokAk8?oM[D7oonYF
oi9lAPOo/[:b00CoZ:RXofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOPSoh=oS00?o
f=GEo`0lM?ooool01_o`lO`02?o2`;WoSXf<ogYjN_mmOGgoQHF5ohZ:R_n2PX;oMgMf1oo`lO`00ooo
oooo03adonOVj@07on3Oh`03olC3_ooalNgolO7]00GolO7]00So^kVcokBb[Onc/Jco[jbXojRVXOnQ
X9_oXj6Lokjk]0SolO7]00?oa<>oon3OhooPgn<01OoPgn<01?nU[;;oooooooooooooool5o`0000;o
oooo00?o0000ooooool000000oooool00ol0003oooooo`000004ooooo`;o00000_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0;kooooo00?oYJbbon3OhooPgn<00ooPgn<01?oHeMGo
03adojG1kOooool3oo3ao003o`000?o`lOcol?7l00Kol?7l0ol00004oo3ao004oooooonU`^ko03ad
onOVj@Koh=oS00?of=GEo`0lM?ooool01oo`lO`01_o>b/CoShf;og5aLOmUIFGoGeiNokbh/`Sol?7l
00?oooooo`0lM?oWi^T00ooPgn<00ooHeMGo03adooooo`07oo3ao003ok2^Zon>SXkoSXj>00;oSXj>
00?oX9nMoo3ao?o`lO`01_o`lO`00ooooooo03adonOVj@3]on3Oh`03on_[jona/K7o/K6a00Go/K6a
01SoZJVYojb>A_ooeTKonl55ooc3A_oS/T?ocK9ionc>Uoo[cY3o^8eSokZ1EOoSXF_olL>6onoOZ?o4
[g3ohI<Oonn=7?oZSQGok9@Hoo6D6?oUQa?o^7LKomV[?_n4Pg`7ok6a/@04ojRXZ?mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWh8on3Oh`03omSEeOl0?7Cooooo00Oom?Gm00Oob<BloiJD
SomMGEcoH61PogAdM?miNGWoM7Ac00Oom?Gm00?oooooo`0lM?oWi^T01ooPgn<00oo4`koolO7]oo7a
k@05oo7ak@07ok^i/onc/JcoZ:JQoifKU_nDTXgoZjRRolS4_009oo7ak@03olC3_ooPgn?oh=oS00Go
h=oS00GoYJbbooooooooooooooooo`000004ooooo`03o`000?oooooo000000;ooooo0ol00002oooo
o`;o00001Oooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo0;kooooo00?oYJbbon3O
hooPgn<00ooPgn<01?oHeMGo03adojW5koooool3ooCeo@03o`000?odmOgom?Gm00gom?Gm00Cooooo
ojW5kol0?7CoinKY1_oPgn<00ooHeMGo03adooooo`08ooCeo@04okRf[omYJ6SoCdm?oiBCSPWom?Gm
00?oooooo`0lM?oWi^T00ooPgn<00ooHeMGo03adooooo`06ooCeo@05olG1_?nBTY;oSXj>ohj>S_n:
RXX00_n>SXh00one/jkom?GmooCeo@05ooCeo@03ooooool0?7CoinKY0>goh=oS00?ojn_[ojn_[on_
[jl01_n_[jl05on;Rh[ol;Toooo<B?oi`D;ohKEDon?8V?oZc9OokM2Aol2JKOnJIdGoYTl/ol8f4?oX
E2Wok8QFolmB8OoO6`3oj4<7on]F2ooQOACoki8HooZB5_nmLaCoPH2000Oo[jn_00CoZ:RXofIVO_nX
ZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOPSoh=oS00?of=GEo`0lM?ooool02Oofmod01Onk
]k;oOG]ioeIEEOmNGUkoIfMV00Oom_Om00?oooooo`0lM?oWi^T01ooPgn<00oo4`koolO7]oo7ak@05
oo7ak@05okZh/_nUXikoUYB@oj2LV?no_;@02ooalNd00oo4`kooh=oSon3Oh`05on3Oh`05ojF//_oo
ooooooooooooool000001?ooool00ol0003oooooo`000007ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooool000001?ooool00ol0003oooooooooo`2nooooo`03ojF//_oPgn?oh=oS00?oh=oS
00Cof=GEo`0lM?n]b?3ooooo0oofmod00ol0003om_OmooKgo@02ooKgo@03o`000?ofmogom_Om00So
m_Om00Coooooojc7l?l0?7CoinKY1_oPgn<00ooHeMGo03adooooo`08ooKgo@04om7>aon7QX?oGEeK
olG3_0Wom_Om00?oooooo`0lM?oWi^T00ooPgn<00ooHeMGo03adooooo`06ooKgo@09oijMVon:RX[o
LW9bofIVI_mUIFGoJFUYog5aLOmoOgkoa<6j00Kom_Om00?oooooo`0lM?oWi^T0kOoPgn<8on_[j`0I
onCTi?n4Ed_o/6/SooS:BOok`T;on/=7ooG6GooZbHSoj<fHol6GJOnbQ5co[XUQoj5_BonP=aWobPl0
onXH0_oV4@3og@00okTZ0oo>QQKokI4Honf?6?ooUAOoag`Poj^WX@06on_[j`04ojRXZ?mVIWkoZ:Vk
oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh8on3Oh`03omSEeOl0?7Cooooo00[on?cm00CoblS2
ojNUWomNGEcoDU9A1ooho?d00ooooooo03adonOVj@07on3Oh`03olC3_ooalNgolO7]00GolO7]00Co
[ZbVoiVFTOnf/jcoc<W23?oalNd00oo4`kooh=oSon3Oh`05on3Oh`05ojF//_ooooooooooooooool0
00001?ooool00ol0003oooooo`000007ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000oooo
ool000000oooool00ol0003oooooooooo`2oooooo`03ojF//_oPgn?oh=oS00?oh=oS00Cof=GEo`0l
M?nabo;ooooo1?oho?d4o`0000_on?cm00Cooooook7<l_l0?7CoinKY1_oPgn<00ooHeMGo03adoooo
o`09ooSlo@03oknk]_nh];3on?cm00Won?cm00?oooooo`0lM?oWi^T00ooPgn<00ooHeMGo03adoooo
o`05ooSlo@0:okjl]omjNGSoJVYXof1OGOmNGE_oGEeKoeiMG?mQH5koI6=RojBQW@Kon?cm00?ooooo
o`0lM?oWi^T0kOoPgn<00ooYjNWojn_[on_[j`04on_[j`0KonKVi_n7CcOo`T@?okER3ooIXSCoo/U:
ooW2B?ok`T?onLE=oo7<M?nnTfSo[gaEok60F?n`R63o[XeToim]BOn]<1Ooc1<1okej5?oNdB?okiHI
onb>6?o[SaSokHlHoonF5?oWPPooVi6400Gojn_[00CoZ:RXofIVO_nXZK_onocm0OmVIWh00004ofIV
O_oko?goZ:VkofIVOPSoh=oS00?of=GEo`0lM?ooool03?omoOd00oo6`kgoWYbGoogmo@06oogmo@03
ooooool0?7CoinKY00Ooh=oS00?oa<>ooo7akOoalNd01OoalNd00onn^kCoal>koo7ak@0=oo7ak@03
olC3_ooPgn?oh=oS00Goh=oS00CoYJbboooooooooooooooo1Ol00002ooooo`03o`000?oooooooooo
00Wooooo0ol00002ooooo`Co0000`_ooool00onU[;;oh=oSon3Oh`03on3Oh`04omSEeOl0?7Co]<gc
oooooa?ooOgm00CooooookG>lol0?7CoinKY1_oPgn<00ooHeMGo03adooooo`0Eoogmo@03ooooool0
?7CoinKY00?oh=oS00?of=GEo`0lM?ooool05OomoOd00ooooooo03adonOVj@3]on3Oh`03onWYjOo[
jn_ojn_[00Cojn_[01_oj^[Zoha`IOnXC@oom98FomF46OoP[Scoola=oo[4BOoh_CkomJX/okmM7_n^
@QWoXUDPojf3EonaPeco]XYSoj1jGoni_BcoooPYooBC4oo_QP[ok8L4onR20?oOO`3oh8PGooZ/@_n^
N2/01Oo[jn/01?nXZ:SoIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn2?oPgn<00ooH
eMGo03adooooo`0Eoogmo@03ooooool0?7Coi^KY00Ooh=oS00?oa<>ooo7akOoalNd05OoalNd00oo4
`kooh=oSon3Oh`05on3Oh`03ojF//_oooooooooo0=oooooo00?oYJbbon3OhooPgn<00ooPgn<01?oH
eMGo03adokO@m?oooolCoogmo@04oooooonhd?Go03adonKVj@Koh=oS00?of=GEo`0lM?ooool05Oom
oOd00ooooooo03adonKVj@03on3Oh`03omSEeOl0?7Cooooo01GooOgm00?oooooo`0lM?oVi^T0kOoP
gn<00ooYjNWojn_[on_[j`05on_[j`0JonGUiOnjL1CooiTIonb<5?o:PakojkM2ooF[<?o/TA[ojhTC
ol1?3OnS9PGoZf`Dol2HF?n`PUco/7ePojN<AOodi13ohgX0om=a0OoAQbKo`hm8ol6TLoo;aj;oe^_T
oh^HW_n]/K@5on_[j`04ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh8on3O
h`03omODdol0?7Cooooo01GooOgm00?oooooo`0lM?oUiNP01ooPgn<00oo4`koolO7]oo7ak@0Eoo7a
k@03olC3_ooPgn?oh=oS00Goh=oS00?oYJbbooooooooool0goooool00onU[;;oh=oSon3Oh`03on3O
h`04omODdol0?7Co^]?eoooooa?ooOgm00Cooooook[Cm_l0?7CoiNGX1_oPgn<00ooGe=?o03adoooo
o`0Eoogmo@03ooooool0?7CoiNGX00?oh=oS00?oemCCo`0lM?ooool05OomoOd00ooooooo03adonGU
j03]on3Oh`03onWYjOo[jn_ojn_[00Gojn_[01WoVHUboonM6?o[SQOok8lGonJ:5_oQS1[okXdEonf<
4oo^SAKo`4lAoiPZ3?oL/BGodJUAojmoGonWMECo]kDjol:gO?nl^kCoaMCDol?Ef_oFn?ooh?ooolKd
o_nIY:_oi^KW00Kojn_[00CoZ:RXofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOPSo
h=oS00?of=GEobEFQ?noc]`05Oooool00onoc]_o9EJ4on7Qi007on3Oh`03olG4`OoVi^;olO7]01Co
lO7]00?oi^KRolG4`OoPgn<01_oPgn<00onU[;;oooooooooo`3Oooooo`03ojF//_oPgn?oh=oS00?o
h=oS00?of=GEobEFQ?nle?H05_nle?H00olUEXCohN7Ton3Oh`05on3Oh`03omSEeOlUEXCo_lkL01Go
oooo00?o_lkKobEFQ?oQhN@00ooPgn<00ooHeMGo9EJ4oko>g00Eooooo`03oko>folUEXCohN7T0>go
h=oS00?ojNWYon_[joo[jn/01?o[jn/06?nm_Kcogh<Doo^C5_o]S17okH/<onf:2Oo]Q`Koi8L@omb>
8OoCQb?o[ch?oj8n4?oagbcogKI;ojA_HonYTc?oi_UeonC`oOoUiLgok=fcomVnROo@/GcoiN:VoinJ
IPSojn_[00CoZ:RXofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOPSoh=oS00Cof=GE
ogRDZOmEOJ;o`<oM4oooool01?oEgnSoEGfRogVDZ_oNgN07on3Oh`03om3?c_oCd/koi^KR01?olO7]
00?oj^[Vom?Bc_o@clh01ooPgn<00onU[;;oooooooooo`3Oooooo`03ojF//_oPgn?oh=oS00?oh=oS
00?of=GEogRDZOlWCHD05Oo>iol00olWCHGoNIBZomkMh006on3Oh`04omSEeOmhU:WoEGfRol3?gA?o
oooo00CoeMoXoeEmX_miU:[og]gP0ooPgn<01?oHeMGoN9BYoeEmX_o0cmdCooooo`04omGOj?mEOJ;o
NIBZomkMh>goh=oS00?ojNWYon_[joo[jn/01?o[jn/06OnUND;ooiX=onF51OoEOa?od8T]olJEC?no
Zg_o^kZNok6?L_nTERkoZ30<ok9R5ookmc;oj;e7oiE[F?oAeRgoonM0ono2K_oYahcoj<R?oncAUoo<
TT[ohW/0omBf<OoDeM<01oo[jn/01?nXZ:SoIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_o
IVIn2?oPgn<01?oIe]Sogm_GogRDZOlUEX@Co`0lM004oaI=O_mVQZ7oh=kIomcKg0Soh=oS00?od<o>
olG4`Oo4`kl04oo4`kl00oo=c<_oh=oSon3Oh`06on3Ohn?oYJbb1OoPgn<01?oIe]Sogm_GogRDZOlU
EX@Co`0lM004oaI=O_mVQZ7oh=kIomcKg0Koh=oS00CofMKHomoKeomhU:Wo9EJ44ol0?7@01?lFCGko
IXJQon3NfOoLfm`3on3Oh`04omWFf?oOfmOoN9BYobEFQ1?o03ad00Co5TenofJ6XOoPg]Wog=_LkOoP
gn<00ooYjNWojn_[on_[j`04on_[j`0IohmX<On`V6[o^;b]ol3JeOo6joSoe_oool_DgonkK5?o]40<
okDk1_nV<0kob8lQoook=_ocbSgoZHloooOe;OondSkon/13ooC6HOo]bhOoj/^BonSAWOo?RcOoaX03
okjn^@07on_[j`04ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWh8on3Oh`03
omkMh?oIe]SoemCC00[oe]?C1ooBc//3omKCd`04omODdooHeMGofMKHomkMh?ooh=oS4?oPgn<00ooN
gN3ofMKHomODd`0:omKCd`Ood/k;0ooFdm<01?oGe=?of=GEomWFf?oNgN06on3Oh`03omkMh?oIe]So
emCC00[oe]?C1ooBc//3omKCd`04omODdooHeMGofMKHomkMh0?oh=oS00?og]gPomWFf?oGe=<02_oF
dm<7om;>b`?oe]?C00CoemCComSEeOoIe]Sog]gPkOoPgn<00ooYjNWojn_[on_[j`04on_[j`0IomOH
f?n;THgoemS1olWB`_o<elcoa=SEojJ<M_nS7P3o/S`7ok0n3onT>`oog;/Yooof>?omgcGolmPaooo`
<_olcD7on/56ooo3?_oV]TSog;n6ong@V?oadYGoYFXVol_;b`07on_[j`04ojRXZ?mVIWkoZ:Vkoo_l
o@7oIVIn00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oSNooPgn<00ooYjNWojn_[on_[j`04on_[
j`0IolK6a_oO`HCoon>IoogGTOoidY3oj/Z:oo7LW?n_MdSoZCH5ok4k3?nZDA?ol=h`oooa=_ook3Co
onhdook/<_ojcD3onl58ooW1@Oo>YE3ohLB>on_;T?obeikok<=ooi24M`07on_[j`04ojRXZ?mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oSNooPgn<00ooYjNWojn_[on_[
j`04on_[j`0JoiBAR_nkYWco]:1gokJQN?o0ZW[oaJamomG2RooCaHkoW5T]ojP[0onlNAWooolcooo/
<_odg33okM0`onBl<?oa_D3oo/A6ooO0A?oO_WgoonJXoooRW_oohYoooo^colZSIOo3`l<6on_[j`04
ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oSNooPgn<00ooY
jNWojn_[on_[j`04on_[j`0JonGUiOoPh>3ofM[JomGEe?o:bLSobLW7olS6`onMVHkoS6i>oi<o7Oo2
Sacofl/donNm=OoP/CKogjdmonZe@ooi`DKoole8okNEBon@RWgoXiInoj2DNonSUGOoZIYjokJQN?mn
N6d6on_[j`04ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oS
NooPgn<00ooYjNWojn_[on_[j`0;on_[j`0=onGUiOnBM5Wo/XEKojEhC?nKQCgoaZDeooo7Boom`dSo
oLA;oog4BOoobdSoWibFon_[j`02onWYj@;oh^;Q00?ogMcJolo?c_o[jn/01Oo[jn/01?nXZ:SoIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooPgn?oon3Ohg_oh=oS00?ojNWYon_[joo[
jn/03?o[jn/02_n7Ng3ob9=[ol6DH?nDVDgo[JjXonNbAooocTOonl5;oooGDonkUdP>on_[j`04ojRX
Z?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oSNooPgn<00ooYjNWo
jn_[on_[j`0<on_[j`0:ojj^[_nnRf;oVH<mokk0^oo[jn_oWYAooooKC_ooadOoomI:oi^FR@kojn_[
00CoZ:RXofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_ooh=oSoooPgn=kon3Oh`03
onWYjOo[jn_ojn_[00gojn_[00?oOVQ:oj>SVoo[jn/00_o[jn/01?nSS5OoooEGolnU@OoPh>0>on_[
j`04ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oSNooPgn<0
0ooYjNWojn_[on_[j`0=on_[j`03olg=b_o[jn_ojn_[00;ojn_[00?obl_9onBiA?nOSVP03oo[jn/0
1?nXZ:SoIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooPgn?oon3Ohg_oh=oS00?o
jNWYon_[joo[jn/04oo[jn/00onRW93o][Faon_[j`0>on_[j`04ojRXZ?mVIWkoZ:Vkoo_lo@7oIVIn
00001?mVIWkonocmojRY^omVIWkoon3Ohoooh=oSNooPgn<00ooWinOoZ:RXojRXZ00UojRXZ003ofIV
O_nXZK_onocm007oIVIn00000omVIWkomoOioiRHY`3oogMgT_ooMgNBYOmgMi81oiRHY`7omoOi0OmV
IWh00003ofIVO_ogmoWo_;g=0?oo_;g=oonl_LfVokbmc@7omoOi0OmVIWh00003ofIVO_ogmoWoi>?S
00?oi>?S1oo6a/H00oo7alOoa/K6olK6aP02olK6aP04olO7aoo6a/Koa/K6on3Ogoooi>?SoooThn>C
onCSh`7omoOi0OmVIWh00003ofIVO_o`lOCooooo00?ooooo00Cog]kNojNWYonSXZ?oXZ:R0_nQXJ40
0onPX:3oW9bLoifMW@02oinOW`;oX:2P0_nQXJ400onWYjOoooooooooo`1Fooooo`03olO2dOoooooo
oooo0?ooooooooooool6ooooo`03onCShonLY;WoJgF?00;oJgF?0_m/MY05of]eS`06oibT^OoThn?o
oooooooooooThn?oW:Bi0om[MHl2ofafT0GoJgF?00KoW:BionCShooooooooooooncZj_nLY;T3ojHi
A0;oYcY41OnV>D@00onLY;Wok>[Zooooo`03ooooo`7ol?7d0OmVIWh0000FofIVO_oRhN;onocloo_k
o?oko?goo?_moibLWOnKVi_o[:b/onWYjOoXj>SojNWYon[Zj_n[Uekoh<><onc/k?o]kNgoim_;onKH
b?o`l?3ol_;boj>SX`;oo?cl00Coo?cmooclo?oknogoo?cmDOolno`00ol>413oal;Aoocko01joock
o<konocl_Ooko?d00onLY;WoJgF?ohF9/009ohF9/006of]eSonLY;Wonocmoo_loOnLY;WoJgF?2_n5
RK001_m[MHooW:Bioo_ko?oko?goW:BiojHiA0[oZSaE00OoYSU4oibT^Ooko?coo?cloockoOoko?go
h^7R007oIVIn00001?mVIWkoh>3QooKgnOogmoT2ooKgn@0Aolg=c_nPX:3oj^[ZonWYjOoMa[Sof/6a
on7QhOo;[AWomZLJom[<]_oOb:Sohh`don3KeOobl_;olo?coj>SXoogmoT00oofmoT01OofmoSoal;A
ooOgnOogmoWoal;A00;omoOi00?oal;AooOgnOogmoT01?o7`]43ooOgn@;oal;A00?omoOiolO2dOog
moT00_ogmoT00oo7`]7omoOiooOgn@03olO2d@;omoOi00Coal;AooOgnOogmoWoal;A0_ogmoT00oo7
`]7omoOiooOgn@04olO2d@?omoOi0_o7`]42ooOgn@03olO2dOogmoWomoOi00?oal;A0oogmoT4olO2
d@ComoOi00?oal;AooOgnOogmoT00_ogmoT00oo7`]7omoOiooOgn@03olO2d@;omoOi00?oal;Ao`h@
4?o7`]400oo7`]45ooOgn@Coal;A0oogmoT00oo7`]7omoOiooOgn@02ooOgn@?oal;A0oogmoT01Oo7
`]7omoOiooOgnOogmoWoal;A00;omoOi0oo7`]43ooOgn@?oal;A0oogmoT00oo7`]7omoOiooOgn@1;
ooOgnLkom_Oi_OogmoT00om[MHooQHV`oibN_P09oibN_P06ohF9/?m[MHoomoOiooOgnOm[MHooQHV`
2_nLW[h02?n5RK3oJgF?ooOgn?ogmoWoYSU4ojXlEOo2DU_oaUAJ1_o6EE`02Oo6E5[o`U9KojXlEOnV
>DComoOhooOgnOogmoSomoOion3Ph@01ofIVOP0002?oIVInomkMhOoalOColO7doo3am?o`l_CoY:FV
ohn?Son>SXkojNWYonKVi_o8C@go^fdgolc01ooLX`3ooIP0on]k0?oBRdOoh>3PonSUi?oTel?oY:BT
oo7am?o`l_GolO7doo7bm?l>413oal;Aoo3amOl>413oal;Aoo3amOl>413oal;Aoo3am@04o`h@4003
olO2dOo`lOGol?7e00;o3Q0@00?ol?7eo`h@4?o7`]400_o`lOD00ol>413oal;Aoo3am@03o`h@400;
oo3amOo7`]7o3Q0@olO2dOo`lOGo3Q0@olO2dOo`lOGo3Q0@olO2dOo`lOD01?l>41000oo7`]7ol?7e
oo3am@02o`h@40;ol?7e00?o3Q0@olO2dOo`lOD00ol>41000oo`lOGoal;Aoo3am@04o`h@4006olO2
dOo`lOGol?7eoo3amOl>413oal;A0oo`lOD00ol>413oal;Aoo3am@03o`h@4004oo3amOo7`]7o3Q0@
olO2d@Co3Q0@00?ol?7eolO2dOo`lOD00_o`lOD4o`h@4005oo3amOo7`]7ol?7eo`h@4?o7`]400oo`
lOD3o`h@400:oo3amOo7`]7ol?7eo`h@4?o`lOGoal;Aoo3amOl>413ol?7eolO2d@?o3Q0@00?ol?7e
olO2dOo`lOD00ol>41001Oo`lOGoal;Aoo3amOl>413oal;A0?ool?7e7?o`lOFmoo3am003of]eSonb
]M3oYjS200WoYjS200Ko/[G@of]eSoo`lOCol?7dof]eSonb]M07ooooo`?oYjS200Go/[G@of]eSoo`
lOCol?7dojHiA002ol9BF`03ol]DFOo=FEkocEUN00CocEUN00CobeAIol9BFoo2DU_oYSU40_o`lO@0
0ooalOCol?;domkMh@01ofIVOP0001KoIVInomcKh?oZjo3oj^_`on[/l?oYjnooUiRKoj>SXooRhN3o
gmcComcJeooEIROogYd0omGC0?n[W`3o`9@0oiiO0?n=I`_oc94oomZ_;?oLd:CoY:BT0_oZjo003?oZ
jnooj^_`o`h@4?o7`]7oj^_`o`h@4?oZjo3oal;Ao`h@4?o7`]7o3Q0@olO2d@;oj^_`00Go3Q0@olO2
dOoZjo3o3Q0@olO2d@02on[[l008o`h@4?o7`]7oj^_`on[[l?l>413oal;Ao`h@4?o7`]42on[[l00<
o`h@4?oZjo3o3Q0@olO2dOoZjo3o3Q0@olO2dOoZjo3o3Q0@olO2dOl>413oal;A0_oZjo001Ol>413o
al;Aon[[l?l>413oal;A00?oj^_`00Co3Q0@olO2dOl>413oal;A0_oZjo001?l>413oj^_`o`h@4?o7
`]42on[[l003o`h@4?o7`]7oj^_`00;oj^_`00?o3Q0@olO2dOoZjo000_oZjo001?l>413oal;Ao`h@
4?o7`]42on[[l006o`h@4?oZjo3o3Q0@olO2dOl>413oal;A0_oZjo000ol>413oal;Aon[[l002on[[
l009o`h@4?o7`]7oj^_`on[[l?l>413oal;Aon[[l?l>413oal;A00;oj^_`00ko3Q0@olO2dOoZjo3o
j^_`o`h@4?o7`]7o3Q0@olO2dOl>413oal;Ao`h@4?o7`]7o3Q0@olO2d@?oj^_`00Co3Q0@on[[l?l>
413oal;A0_oZjo001Ol>413oj^_`on[[l?l>413oal;A04goj^_`c_oZk?2mon[[k`03of]eSonf^M7o
[Jk600Kooooo0_n][/H00on/[/Ko][WAof]eS`02on[[k`03of]eSonf^M7ooooo00KoKVf?00Go9BDf
ojf^a_n/[/Ko][WAof]eS`02on[[l003ojHiA?o=FEkobeAI00;ooooo0oo@FUl2ooooo`06oleFFoo;
E5WocEUNojHiA?oZjnooj^_`0_oZjnl1omcKh07oIVIn00000omVIWkoemSNomcNiP03omcNiP0Aol31
aon5QXGo/h]Noln84?o^b1?om]<4ooCT0?oUh@3oXjH0of=Y0?mXH`3oj</0ooo10?oFdjoomOGeojBU
YOoLg^H00_oLg^D02ooLg^Ko3Q0@olO2dOl>413oal;Ao`h@4?o7`]7o3Q0@olO2dOl>413og=kU00;o
al;A00Go3Q0@olO2dOoLg^Go3Q0@olO2d@02omcNi@07o`h@4?o7`]7og=kUomcNiOl>413oal;Ao`h@
4005olO2d@0:o`h@4?o7`]7og=kUo`h@4?o7`]7og=kUo`h@4?o7`]7o3Q0@omcNi@;oal;A00Go3Q0@
olO2dOoLg^Go3Q0@olO2d@03omcNi@04o`h@4?o7`]7o3Q0@olO2d@Cog=kU00Ko3Q0@omcNiOo7`]7o
al;Ao`h@4?o7`]43omcNi@03o`h@4?o7`]7og=kU00;og=kU00?o3Q0@olO2dOl>41001Oo7`]401?l>
413oal;Ao`h@4?o7`]42omcNi@03o`h@4?o7`]7og=kU00;og=kU00Wo3Q0@olO2dOoLg^Gog=kUo`h@
4?o7`]7og=kUo`h@4?o7`]400_oLg^D03_l>413oal;AomcNiOoLg^Go3Q0@olO2dOl>413oal;Ao`h@
4?o7`]7o3Q0@olO2dOl>413oal;A0_oLg^D01?l>413og=kUomcNiOl>4105olO2d@03omcNiOl>413o
al;A0?oog=kUfOoLg^D01?m[MHoo_l7FokRic_ooool4ofi]S`06obDU=_nh^Lko^;W>okRic_no`MKo
JgF?0_oLg^D01?m[MHoo_l7Foooooom^KHl4okRicP06oooooolU9CKo^;W>okRic_no`MKoJgF?0_oL
g^D00onV>DCocEUNom5JGP03ooooo`08omIOHooooooooooooooooooDGF7odEYNoleIG_nV>D@2omcN
i@03omcNi_oLg^GoemSN007oIVIn00001?mVIWkoeMKMomGHh?oFf>42omGHh00@oginQ?nDU9CoNGEl
om77R?o9W0cok;<0onna0?oog@3oOhT0ob/S0?nVO03ookD0ooF`;Oo>c/kon?ShojFTY@;oeMSQ00Wo
eMOPomKHh?l>413oe]OQo`h@4?o7`]7o3Q0@olO2dOl>41000_oFen04o`h@4004olO2dOoFen3o3Q0@
olO2d@;oe]OP00Ko3Q0@olO2dOoFen3oe]OPo`h@4?o7`]45o`h@400:olO2dOl>413oal;AomKGh?l>
413oal;AomKGh?l>413oal;AomKGh0Co3Q0@00Coal;AomKGh?l>413oal;A0ooFen001?l>413oal;A
o`h@4?o7`]43omKGh003olO2dOoFen3o3Q0@00?o3Q0@00Goal;AomKGh?oFen3oe]OPo`h@4004olO2
d@03o`h@4?o7`]7o3Q0@00Co3Q0@00Goal;Ao`h@4?o7`]7o3Q0@olO2d@02omKGh003o`h@4?o7`]7o
e]OP00;oe]OP00Go3Q0@olO2dOo7`]7oal;Ao`h@4002omKGh006o`h@4?o7`]7oal;AomKGh?l>413o
al;A0_oFen003?l>413oal;Ao`h@4?o7`]7o3Q0@omKGh?l>413oe]OPo`h@4?o7`]7oe]OPo`h@40?o
e]OP1Ol>41000oo7`]7oe]OPo`h@4002olO2dDcoe]OPc_oFf>2momGHh@03of]eSoo;c=kob<[I00Ko
9BDf00Gob<[IolS9fOo8b]WoblcNof]eS`02omGHh@04of]eSoo;c=koooooofi]S`?ob<[I00gob<WI
oooooolU9CKob<WIolS:fOo;c=koJgF?omKHhOoFf>3oYSU4omMOGooKI6CoAQhJ00Gooooo00[oAQhJ
on1WIOoKI6CoeemOojHiA?oFf>3oeMSQomGGh?oEf>7oeMKM0OmVIWh0000FofIVO_oBe=gocm;Lom3B
g?o@d]god=;Lok>e__nGUiOo]kNgonc/k?oC/6oohXh0ooJD0?oKM@3oK1`0oc`A0?oKJP3oohd0oofB
0?oVXeGoe]39ojFUY@?od=;L00Gocm;Lom3Bg?l>413o3Q0@om3Bg002o`h@4004olO2dOo@d]cod=;L
om3Bg0;oal;A00Co3Q0@om3Bg?o@d]co3Q0@0oo7`]402?l>413oal;AolO2dOo7`]7o3Q0@om3Bg?l>
413od=;L0_o7`]400ol>413od=;Lo`h@4002olO2d@04o`h@4?o7`]7oal;Ao`h@40?od=;L0_o7`]40
1?l>413od=;Lom3Bg?l>4103olO2d@05om3Bg?l>413oal;Ao`h@4?o@d]`00_o7`]401?l>413od=;L
om3Bg?o@d]`2olO2d@03o`h@4?o@d]cod=;L00;od=;L1_l>41000oo7`]7o3Q0@om3Bg002olO2d@05
o`h@4?o@d]co3Q0@olO2dOl>41000oo7`]400ol>413od=;Lom3Bg002om3Bg0Co3Q0@00?od=;LolO2
dOo@d]`00_l>41001?o@d]coal;Ao`h@4?o@d]`2olO2d@0<o`h@4?o@d]co3Q0@olO2dOo@d]co3Q0@
olO2dOo@d]co3Q0@olO2dOl>413od=;L0oo7`]401Ol>413od=;LolO2dOo7`]7o3Q0@00;od=;L0_l>
41000oo@d]coal;Aom3Bg01:om3Bg<kocm;M_Oo@d]`00om[MHoodm?Rolo@g@09olo@g@08om?Ch_m[
MHood=;Lom3Bg?m[MHoodm?Roooooom^KHl4olo@g@0=oooooolU9CKocm3Molo@gOoCdn;oJgF?om3B
g?o?d]coYSU4om]TI?oQJFGoh6aYodHN6P03ooooo`07odHN6_oPK6Woh6aYon5YIOoKI6CoYSU4om3B
g@02om3Bg07ocm;L0OoBe=d1ofIVOP0001goIVInom3Bfoo;cMSob/gIol_>f?o:cMSoOH26oiVIVOnV
YjKoh=O?olQn3OoBMP3ogVL0olAG0?nS@P3oFA80okPl0?ooL@7onXT=onf]Coo/ahkoYZJVol_=f?o;
cMWob/gIol_>f?o:cMSo3Q0@olO2d@02ol_=f@04o`h@4?o7`]7oblgIol_=f@?o3Q0@0_o;cMT4o`h@
4003ol_=fOl>413o3Q0@00;o3Q0@0oo;cMT3o`h@40;oblgI1_l>4103ol_=f@?o3Q0@0_o;cMT4o`h@
4003ol_=fOl>413o3Q0@00;oblgI0ol>4103ol_=f@?o3Q0@1Oo;cMT00ol>413oal;Aol_=f@02ol_=
f@03o`h@4?o7`]7oblgI00?o3Q0@0_o;cMT00ol>413oal;Ao`h@4003o`h@40GoblgI00[o3Q0@olO2
dOo;cMWoblgIo`h@4?o7`]7oblgIo`h@4?o;cMWo3Q0@0_o;cMT3o`h@40;oblgI00Co3Q0@ol_=fOo;
cMWo3Q0@0_o;cMT00ol>413oblgIol_=f@03o`h@40;oblgI0ol>4103ol_=f@03o`h@4?o;cMWo3Q0@
04coblgIc_o;c]Vmol_=f004of]eSooFe^Cof=SUomSHiP;of=SU0_oHf>H01_oHf>Gof=SVomSHiOoH
f>Goe]KTof]eS`;oblgH00CoJgF?omKFi?ooooooKVf?1Oooool02olU9CKof=SUomSHiOoFe^CoJgF?
ol_=fOo:c]SoYSU4onA^KOoTM6ooig5_00Gooooo00Ooi7A_onMaKooTM6ooi6i]ojHiA?o:c]Sob/kI
00;oblgI0Oo@d]/1ofIVOP0000?oIVInolo?f_o5b=@00oo5b=@04OnTY[3oWYjMon7Nf_o7U4CocJE/
om5k9?oQZ03onl80on^F0?nSG`3oS4H0ooeX0onn^;7olO7aoo_knonVYZKoaLSD00;oaLOD0_o5amD0
1_l>413oal;AolC7eOo4amGo3Q0@olO2d@Soa<OE00Ko3Q0@olO2dOo4amGoa<OEo`h@4?o7`]4IolC7
e@03o`h@4?o7`]7oa<OE00?oa<OE00?oal;AolC7eOo4amD03Oo4amD00ol>413oal;AolC7e@02olC7
e@03o`h@4?o7`]7oa<OE00Goa<OE00?o3Q0@olO2dOo4amD02?o4amD01Ol>413oal;AolO2dOo7`]7o
3Q0@06ooa<OEc_o4b=BmolC7e003of]eSooEe>?oh=oZ00Woh=oZ00OoeMCSof]eSoo4amCoa<ODof]e
SooEe>?ooooo00KoKVf?00[o9BDfon3Oj_oPgn[oeMCSof]eSoo5b=Coa<SDojHiA?oZNG?ojGah0ooo
ool02Om67Q[oooooooooooooooookh5jonUlN?oZNG?oYSU4olC8e@02olC8e07oaLOE0Oo?cmX1ofIV
OP0000CoIVInolc>f_o2a=;o`LCA0_o1a=804?n4QhooSHf=ogYhM?o/j^Gol?3`olB>?OoYb@3olKH2
omZ>0?o7N@7oXgHHojaR0?oQ/IKof][JooWinOnVYZH3ol74dP03ol;4dOo1a=;o3Q0@00?o`LCA00?o
3Q0@ol74dOo1a=401oo1a=401Ol>413o`LCAol74dOo1a=7o3Q0@01[o`LCA00?o3Q0@ol74dOo1a=40
0_o1a=400ol>413o`LCAol74d@0>ol74d@03o`h@4?o1a=7o`LCA00;o`LCA00?o3Q0@ol74dOo1a=40
1Oo1a=400ol>413o`LCAol74d@08ol74d@Co3Q0@L?o1a=7>ol74d[go`/CB00?oJgF?ong[looYj?40
2OoYj?401oo]jo?oJgF?ol;4d_o2a=;oJgF?ong[looYj?401olU9CH2onWXl@07ong[lom[MHoo`/CA
ol74dOnV>DColH1eoo24O002ooooo`03odHN6_oa/Y_oAQhJ00;ooooo00WomHb4oo24O?oaP7GoYSU4
ol74d_o2a=7o`LCAol74d_o<c]X00OmVIWh00004ofIVO_o:c=So_/3?okg0c`;o_/3>01GoSY2KoijN
W_oEe=Col?3`oo;bl_oAYaWoiM:3oo;Zd?oXXakod90@olk>c_oQf/KocZ9^ongPfOogmoOoYZNWokk0
c_nn`<oo_/3>okk0conm`<h0conn`<k>okg0c[go_/3>00?oJgF?om;AhooblOL02OoblOL01_oBdN?o
JgF?okk0c_nn`<koJgF?om;Ah`[ol_7g00Ood]7Sof]eSonm`<ko_/3>ojHiA?odRWgomI2500;oAQhJ
0oob^9h2odHN6P;omI2500?om8YmojHiA?nm`<l00_nn`<l1okk0cP7ob/cH0OmVIWh0000LofIVO_o9
b]So][S8okVlbonj_<_o^[c<oi>EXOn6QXKoU9BCoo;bl_oUe[kolo2moo;bl_ofm_Kol<NBonBU=ooW
inOono_kooShmOomm>koo_knojNWYoni_<co^[_<okVlbonj_<_o^Kc<okVlblko^Kc<c_nj_<bmokZl
b`04ohB<X_m[MHooc<_Moo_ko0Kooooo00Cono_lolc;gOm[MHooQ8bR0_nj_</01?n4S:;oJgF?olc;
gOokno`6ooooo`0;oo_ko?o<bmgoJgF?ohB<X_nj_<co^Kc<oi6HZ_nV>DCooin=oojoY?ojg;L00_oj
jKH2ooWY]P0:oo[L]oon_jCooin=ojHiA?nAV:[o^[c<okZkc?ni_<_o][S8olW:f07oIVIn00000omV
IWkoa/SGokRgc`03ojn^a`0=ogAcQ?nPX:3ohN3Qoo?clooemNkomOGeooKfm_ohn?SomO;/on[BYOoi
nOWoo?cloogmo@02ooknoP03ojNWYon_[/Oo[jk70?oo[jk7oon_[/MPojn^a`03ohB<X_m[MHooJgF?
00SoJgF?00?oQ8bRojn^aon_[/L00_n_[/L00on4S:;oJgF?of]eS`08of]eS`03ohB<X_n_[/Oo[jk7
00;o[jk700?oQ8bRojHiA?nV>D@02?nV>D@00on4S:;o[jk7ojn^a`02ojn^a`7o^;O?0Oo6b=L1ofIV
OP0000?oIVInol31dOo7am@00on/Zl@00onLW;;oSHf=ojZZZP0=ojZZZ_oo[:_4oon/ZlBBojb[a07o
alOD0Oo0`M41ofIVOP0000KoooooojRW_ooVi^god];Pokblcona/<CoojRW_oooZ:NoWonXYkl01Ona
/<Co_;c?om;Bh?oVi^goZ:No007ooooo00001oooooooQhNKomOHh_olo?coi>?Xom3@h?o:b]X0oonl
_<oookblcigo_;c?00Kob/[Jom3@h?oThnSoo?clomOHh_n7Qi/1ooooo`000_ooool01_nEU:_oemSR
ooclo?oblO?ok>_^on7RjoooemSRoooGf>:KomOHhP06on7Rjoo/jnkol_7cooclo?oGf>;oUIB[0_oo
ool000?ooooo0_mVIWh00on8QigoUIB[ojRW_`3oojRW_oooZ:NoW?nXYkl01?nEU:_oR8NMofIVO_mV
IWh3ooooo`001OooooooofIVO_ooIVInXOmVIWh5ooooo`00\
\>"], "ItemizedPicture",
  Evaluatable->False,
  ImageSize->{681, 646},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"browser", "gs:0.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Use the buttons for different search categories:", "Subsubsection",
  CellTags->{"browser", "i:110", "b:4.0", "gs:0.5"}],

Cell[TextData[StyleBox["Built-in Functions", "SR"]], "CaptionHead",
  CellTags->{"browser", "i:14", "b:4.0", "gs:0.5"}],

Cell[TextData[{
  "Information on built-in functions in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel, including further examples."
}], "CaptionText",
  CellTags->{"browser", "i:14", "b:4.0", "gs:0.5"}],

Cell[TextData[StyleBox["Add-ons & Links", "SR"]], "CaptionHead",
  CellTags->{"browser", "i:15", "b:4.0", "gs:0.5"}],

Cell[TextData[{
  "Information on application packages installed with your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system, including ",
  Cell[BoxData[
      \(TraditionalForm\`MathLink\^\[RegisteredTrademark]\)]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["J",
            FontSlant->"Italic"], 
          StyleBox["/",
            FontSlant->"Italic"], 
          SuperscriptBox[
            StyleBox["Link",
              FontSlant->"Italic"], "\[Trademark]"]}], TraditionalForm]]],
  "."
}], "CaptionText",
  CellTags->{"browser", "i:15", "b:4.0", "gs:0.5"}],

Cell[TextData[{
  StyleBox["The Mathematica Book", "SR"],
  " "
}], "CaptionHead",
  CellTags->{"browser", "i:16", "b:4.0", "gs:0.5"}],

Cell[TextData[{
  "The complete text of Stephen Wolfram\[CloseCurlyQuote]s",
  StyleBox[" The Mathematica Book",
    FontSlant->"Italic"],
  "."
}], "CaptionText",
  CellTags->{"browser", "i:16", "b:4.0", "gs:0.5"}],

Cell[TextData[StyleBox["Front End", "SR"]], "CaptionHead",
  CellTags->{"browser", "i:21", "b:4.0", "gs:0.5"}],

Cell["\<\
Information about menu commands, front end options, style sheets, \
expression input, and much more.\
\>", "CaptionText",
  CellTags->{"browser", "b:4.0", "gs:0.5"}],

Cell[TextData[StyleBox["Getting Started", "SR"]], "CaptionHead",
  CellTags->{"browser", "i:18", "b:4.0", "gs:0.5"}],

Cell["An online version of this manual.", "CaptionText",
  CellTags->{"browser", "i:18", "b:4.0", "gs:0.5"}],

Cell[TextData[StyleBox["Tour", "SR"]], "CaptionHead",
  CellTags->{"browser", "i:19", "b:4.0", "gs:0.5"}],

Cell[TextData[{
  "An overview of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", including examples."
}], "CaptionText",
  CellTags->{"browser", "i:19", "b:4.0", "gs:0.5"}],

Cell[TextData[StyleBox["Demos", "SR"]], "CaptionHead",
  CellTags->{"browser", "i:20", "b:4.0", "gs:0.5"}],

Cell[TextData[{
  "A collection of notebooks and palettes demonstrating a few of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]",
  "s capabilities."
}], "CaptionText",
  CellTags->{"browser", "i:20", "b:4.0", "gs:0.5"}],

Cell[TextData[StyleBox["Master Index", "SR"]], "CaptionHead",
  CellTags->{"browser", "i:17", "b:4.0", "gs:0.5"}],

Cell["The master index of all the items in the Help Browser.", "CaptionText",
  CellTags->{"browser", "i:17", "b:4.0", "gs:0.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["To get information on a built-in function:", "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"browser", "i:22", "b:4.1", "gs:0.5"}],

Cell[TextData[{
  "With the cursor immediately after a function name, press F1 on Windows or \
the H",
  StyleBox["ELP", "SmallText"],
  " key on Macintosh. The Help Browser opens and displays the information \
from ",
  StyleBox["Built-in Functions", "SR"],
  "."
}], "Text",
  CellTags->{"browser", "i:22", "b:4.1", "gs:0.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "PictureGroup",
        ImageSize->{54, 13},
        ImageMargins->{{0, 0}, {0, 0}},
        ImageRegion->{{0, 1}, {0, 1}}],
      ButtonFunction:>(FrontEndExecute[ {
          FrontEnd`SelectionMove[ 
            FrontEnd`SelectedNotebook[ ], All, ButtonCell], 
          FrontEndToken[ "OpenCloseGroup"]}]&),
      Active->True,
      ButtonFrame->"None"]], "OpenCloseItemizedPicture",
  CellTags->{"browser", "i:22", "b:4.1", "gs:0.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005O0000IR000`400?l00000o`00003ooooooomP
ooooo`000oooooooo`0005go000000000ooooooo0000o`00003oo`0005go000000000ooooooo0000
olg=c@3ooiVIVE_oVIVI0_l000000003ooooool0003ooooo0?oocLg=F_o=cLd1oiVIV@7o00000Ol0
00000003ooooool0003ooooo0?oocLg=F_o=cLd1oiVIV@7o00000Ol000000003ooooool0003ooooo
00;ocLg=oooooomFooooo`;ocLg=0OnIVIT1o`00007o000000000ooooooo0000ooooo`02olg=c@03
oiVIVOl0003o00000?oo0000D_l000001?oooooocLg=olg=cOnIVIT2o`00000000?oooooo`000?oo
ool00_o=cLd00onIVIWo0000ooooo`3ooooooe7ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00
000000?oooooo`000?ooool00_o=cLd00onIVIWo0000ooooo`3oooooodgooooo00H0oooooooooooo
ooooooooo`000?ooool2olg=c@7oVIVI0Ol00001o`00000000<0oooo0000003oool00P3=cLd00`2I
VIT000000?ooo`3oooooodgooooo00H0ooooooooooooooooooooo`000?ooool2olg=c@7oVIVI0Ol0
0001o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3oooooodgooooo00H0oooo
ooooooooooooooooo`000?ooool2olg=c@7oVIVI0Ol00001o`00000000<0oooo0000003oool00P3=
cLd00`2IVIT000000?ooo`3oooooodgooooo00H0ooooooooooooooooooooo`000?ooool2olg=c@7o
VIVI0Ol00001o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3oooooodgooooo
00H0ooooooooooooooooooooo`000?ooool2olg=c@7oVIVI0Ol00001o`00000000<0oooo0000003o
ool00P3=cLd00`2IVIT000000?ooo`3oooooodgooooo00H0ooooooooooooooooooooo`000?ooool2
olg=c@7oVIVI0Ol00001o`00000000<0oooo0000003oool00P3=cLd0102IVIT000000?oooooooooo
0?oood@0oooo1oooool20?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo
0000003oool00P3=cLd00`2IVIT000000?ooo`3o0?ooocD0oooo1oooool@0?ooo`03ooooo`3ooooo
oooo00;ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd0
0`2IVIT000000?ooo`3o0?ooocD0oooo1oooool@0?ooo`03ooooo`3ooooooooo00;ooooo00Go0000
ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o
0?ooocD0oooo1oooool@0?ooo`03ooooo`3ooooooooo00;ooooo00Go0000ooooooo=cLgocLg=oiVI
V@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o0?ooocD0oooo1oooool:
0?ooo`D0003o00<0ooooooooo`3oool00oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000000
0`3oool000000?ooo`020<g=c@0309VIV@000000oooo0?l0oooo=@3oool7ooooo`h0oooo00@0003o
0?ooooooool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?oo
o`020<g=c@0309VIV@000000oooo05L0oooo1000003I0?ooo`Oooooo3P3oool010000?l0oooooooo
o`3oool3ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=
00<0VIVI0000003oool0;03ooolZ000000030?ooo`00000000000=/0oooo1oooool>0?ooo`040000
o`3ooooooooo0?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003o
ool00P3=cLd00`2IVIT000000?ooo`0/0?ooo`8000001@3oool4000000@0oooo0`0000060?ooo`@0
00000P3oool5000000@0oooo0`0000000`3oool000000000003K0?ooo`Oooooo3P3oool010000?l0
ooooooooo`3oool3ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo
0080cLg=00<0VIVI0000003oool0;03oool200000080oooo0P0000020?ooo`8000000P3oool20000
0080oooo100000020?ooo`H000000P3oool400000080oooo0P0000020?ooo`80000000<0oooo0000
00000000f`3oool7ooooo`h0oooo00@0003o0?ooooooool0oooo0oooool01Ol0003oooooolg=cOo=
cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo02`0oooo1P000002
0?ooo`8000000P3oool200000080oooo100000020?ooo`D00000103oool300000080oooo1P000000
0`3oool000000000003K0?ooo`Oooooo3P3oool010000?l0ooooooooo`3oool3ooooo`05o`000?oo
oooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool0;03o
ool600000080oooo0P0000020?ooo`8000000P3oool400000080oooo1@0000040?ooo`<000001P3o
ool2000000030?ooo`00000000000=/0oooo1oooool>0?ooo`040000o`3ooooooooo0?ooo`?ooooo
00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT00000
0?ooo`0/0?ooo`<00000103oool300000080oooo0P0000020?ooo`@000000P3oool400000080oooo
0P0000020?ooo`8000000P3oool200000080oooo0P0000000`3oool000000000003K0?ooo`Oooooo
3P3oool010000?l0ooooooooo`3oool3ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l000000003
0?ooo`000000oooo0080cLg=00<0VIVI0000003oool0;03oool200000080oooo1`0000040?ooo`D0
00000P3oool3000000P0oooo0P0000040?ooo`<0000000<0oooo000000000000f`3oool7ooooo`h0
oooo00@0003o0?ooooooool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3o
ool000000?ooo`020<g=c@0309VIV@000000oooo02`0oooo0P0000020?ooo`8000000P3oool<0000
0080oooo500000000`3oool000000000003K0?ooo`Oooooo3@3oool20000o`030?ooooooool0oooo
00?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2I
VIT000000?ooo`0/0?ooo`<000001@3oool:000000@0oooo500000000`3oool00000000000020000
0=T0oooo1oooool<0?ooo`060000o`3oool0003o0?ooooooool0oooo0oooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo02`0oooo:P00
003N0?ooo`Oooooo2`3oool01`000?l0oooo0?ooo`000?l0ooooooooo`3oool00oooool01Ol0003o
ooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0?l0
oooo=@3oool7ooooo`X0oooo00P0003o0?ooo`3oool0oooo0000o`3ooooooooo0?ooo`?ooooo00Go
0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?oo
o`3o0?ooocD0oooo1oooool90?ooo`H0003o00<0ooooooooo`3oool00oooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0?l0oooo=@3o
ool7oooooa00oooo00?ooooo0?ooooooool00_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o0000
00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0?l0oooo=@3oool7oooooa00oooo00?o
oooo0?ooooooool00_ooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?oo
o`020<g=c@0309VIV@000000oooo0?l0oooo=@3oool7oooooa00oooo00?ooooo0?ooooooool00_oo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@00
0000oooo0?l0oooo=@3oool7oooooa00oooo00?ooooo0?ooooooool00_ooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0?l0oooo=@3o
ool7oooooa80oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?oo
o`020<g=c@0309VIV@000000oooo0?l0oooo=@3oool7oooooa80oooo0oooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0?l0oooo=@3o
ool7oooooa80oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?oo
o`020<g=c@0309VIV@000000oooo0?l0oooo=@3oool7oooooa80oooo0oooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0?l0ooooCP3o
ool3ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0
VIVI0000003oool0o`3ooom>0?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0
oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o0?ooodh0oooo0oooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0?l0ooooCP3o
ool3ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0
VIVI0000003oool0o`3ooolo0?ooo`D0003o0P3oool50000o`<0oooo0oooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0?l0oooo@`3o
ool00`000?l0oooo0?ooo`040?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000ooooooo=cLgo
cLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0G0?ooo`80003o
1@3oool20000oa40oooo00<0ZJVY0000003oool0:@3oool3000005T0oooo0`00000N0?ooo`<00000
1P3oool00`000000^[Zj0?ooo`1L0?ooo`030000o`3oool0oooo00@0oooo00@0003o0?ooo`3oool0
oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@03
09VIV@000000oooo01L0oooo00<0003o0?ooo`3oool01@3oool00`000?l0oooo0?ooo`0?0?ooo`03
0000003MgMd0oooo02X0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0`0?ooo`03
0000003oool0oooo01h0oooo00<000000?ooo`3oool01@3oool00`3MgMd000000?ooo`1L0?ooo`03
0000o`3oool0oooo00@0oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgo
VIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo00P0oooo10000?l30?oo
o`<0003o0P3oool20000o`030?ooo`000?l0oooo0080oooo00D0003o0?ooo`3oool0oooo0000o`0A
0?ooo`030000003oool0oooo0080oooo0`000000103oool000000?ooo`3oool2000000030?ooo`00
0000000000`0oooo00<000000?ooo`3oool0103oool5000000D0oooo00<000000?ooo`3oool07P3o
ool3000000D0oooo00<000000?ooo`3oool01@3oool7000000040?ooo`00000000000?ooo`800000
3@3oool00`000000oooo0?ooo`040?ooo`<0000000@0oooo00000000000000000`3oool00`000000
oooo0?ooo`0M0?ooo`@000001@3oool00`000000oooo0?ooo`1K0?ooo`030000o`3oool0oooo00@0
oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3o
ool000000?ooo`020<g=c@0309VIV@000000oooo00L0oooo00<0003o0?ooo`3oool00P3oool00`00
0?l0oooo0000o`020?ooo`040000o`3oool0oooo0000o`80oooo00D0003o0?ooo`3oool0oooo0000
o`030?ooo`030000o`3oool0003o00@0003o2P3oool00`3MgMd000000?ooo`020?ooo`050000003o
ool0oooo0?ooo`000000103oool00`000000oooo0000000=0?ooo`030000003oool0oooo00D0oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00`0oooo1@0000020?ooo`D0
00001@3oool01@000000oooo0?ooo`3oool0000000d0oooo00D000000?ooo`000000oooo00000003
0?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3o
ool0000000@0oooo00<000000?ooo`3oool0303oool500000080oooo1@0000050?ooo`050000003o
ool0oooo0?ooo`000000103oool00`000000c<c<0?ooo`1K0?ooo`030000o`3oool0oooo00@0oooo
00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool0
00000?ooo`020<g=c@0309VIV@000000oooo00L0oooo00<0003o0?ooo`3oool00P3oool00`000?l0
oooo0000o`020?ooo`040000o`3oool0oooo0000o`80oooo00D0003o0?ooo`3oool0oooo0000o`03
0?ooo`030000o`3oool0oooo00h0oooo00<0000009RHV03oool00P3oool01@000000oooo0?ooo`3o
ool0000000D0oooo00<000000?ooo`3oool02P3oool5000000D0oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0000001h0oooo00<000000?ooo`3oool03`3oool01@000000oooo
0000003oool0000000@0oooo00<000000?ooo`3oool02`3oool5000000D0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0000001h0oooo00D000000?ooo`3oool0oooo00000004
0?ooo`0308N7Q`000000oooo05/0oooo00<0003o0?ooo`3oool0103oool010000?l0oooo0?ooo`3o
ool3ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0
VIVI0000003oool01`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080oooo00@0
003o0?ooo`3oool0003o0P3oool01@000?l0oooo0?ooo`3oool0003o00<0oooo00<0003o0?ooo`00
0?l010000?l:0?ooo`030<c<c0000000oooo00<0oooo100000050?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`0000003@3oool500000080oooo1@0000050?ooo`030000003oool0oooo00l0oooo00D000000?oo
o`000000oooo000000040?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000003@3oool500000080oooo1@00
00050?ooo`050000003oool0oooo0?ooo`000000103oool00`000000c<c<0?ooo`1K0?ooo`030000
o`3oool0oooo00@0oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo00L0oooo00<0003o0?ooo`3o
ool00P3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o0080003o00<0oooo0000o`3o
ool00P3oool01@000?l0oooo0?ooo`3oool0003o0140oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000003@3oool00`000000oooo0?ooo`05
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000001d0oooo
00D000000?ooo`3oool0oooo0000000=0?ooo`050000003oool000000?ooo`0000000`3oool00`00
0000oooo0000000>0?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`3oool06`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool0F`3oool00`000?l0oooo0?ooo`040?ooo`040000o`3oool0oooo0?ooo`?ooooo
00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT00000
0?ooo`070?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`3oool01@3oool010000?l0oooo
0?ooo`000?l20?ooo`80003o0`3oool00`000?l0oooo0?ooo`0?0?ooo`030000003oool0oooo0080
oooo0`0000040?ooo`80000000<0oooo000000000000503oool400000080oooo0`000000103oool0
000000000000000M0?ooo`<000003@3oool3000000030?ooo`000000oooo0080oooo0P0000000`3o
ool000000000000D0?ooo`80000000<0oooo0000000000000P3oool3000000040?ooo`0000000000
000001/0oooo1@0000050?ooo`030000003oool0oooo05/0oooo00<0003o0?ooo`3oool0103oool0
10000?l0oooo0?ooo`3oool3ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0000000030?ooo`00
0000oooo0080cLg=00<0VIVI0000003oool0203oool40000o`/0oooo0P000?l20?ooo`030000o`3o
ool0oooo0080003o4@3oool00`0@4100c<c<0?ooo`0?0?ooo`@000003`3oool00`000000oooo0?oo
o`0:0?ooo`@00000=`3oool4000001d0oooo1000000P0?ooo`030<c<c00Q8B40oooo05T0oooo1000
0?l60?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`000000
00<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0a0?ooo`030:VYZ@000000oooo0100oooo
00<000000?ooo`3oool03P3oool2000000d0oooo00<000000?ooo`3oool0>03oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo0200oooo00<000000<c<c03oool0G03oool00`000?l0oooo
0?ooo`040?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00
000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`150?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo07d0
oooo0P000?l60?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02
o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`160?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
07/0oooo00<0003o0?ooo`000?l01P3oool010000?l0oooo0?ooo`3oool3ooooo`05o`000?oooooo
cLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool0@`3oool0
10000000oooo0?ooo`00000L0?ooo`040000003oool0oooo000003L0oooo00@000000?ooo`3oool0
00007@3oool010000000oooo0?ooo`00001l0?ooo`040000o`3oool0oooo0000o`H0oooo00@0003o
0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?oo
o`020<g=c@0309VIV@000000oooo04@0oooo0P00000N0?ooo`800000>@3oool2000001l0oooo0P00
001l0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool010000?l0oooo0?ooo`3oool3ooooo`05
o`000?oooooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0VIVI0000003o
ool0bP3oool00oooool0oooo0?ooo`1`0?ooo`H0003o1P3oool010000?l0oooo0?ooo`3oool3oooo
o`05o`000?oooooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0VIVI0000
003oool0bP3oool00oooool0oooo0?ooo`1l0?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000
ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3:
0?ooo`03ooooo`3oool0oooo07`0oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=
cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo0<X0oooo00?o
oooo0?ooo`3oool0O03oool010000?l0oooo0?ooo`3oool3ooooo`05o`000?oooooocLg=olg=cOnI
VIT00_l0000000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool0bP3oool00oooool0oooo
0?ooo`1l0?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00
000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3:0?ooo`03ooooo`3oool0oooo07`0
oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3o
ool000000?ooo`020<g=c@0309VIV@000000oooo0<X0oooo00?ooooo0?ooo`3oool0L@3oool50000
o`H0oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000000
0`3oool000000?ooo`020<g=c@0309VIV@000000oooo05h0oooo00@0gMgM05EEE@0@41000000J03o
ool00oooool0oooo0?ooo`1?0?ooo`80000000<0EEEE0=gMg@3oool08@3oool00`000?l0oooo0?oo
o`040?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`000000
00<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`1N0?ooo`03010@40000000^[Zj06T0oooo
00?ooooo0?ooo`3oool0D03oool00`2YZJT00000010@400R0?ooo`030000o`3oool0oooo00@0oooo
00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool0
00000?ooo`020<g=c@0309VIV@000000oooo05h0oooo0P00001Z0?ooo`03ooooo`3oool0oooo0540
oooo0P00000R0?ooo`030000o`3oool0oooo00@0oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0
003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo
01@0oooo0P000?l50?ooo`80003o703oool400000240oooo0P00000`0?ooo`@00000<`3oool01?oo
ool0oooo0?oooooooolX0?ooo`@00000703oool4000000L0oooo0P00000R0?ooo`030000o`3oool0
oooo00@0oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o0000
00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo01@0oooo00<0003o0?ooo`3oool01@3o
ool00`000?l0oooo0?ooo`0K0?ooo`8000008P3oool200000340oooo0P00000W0?ooo`8000002`3o
ool01?ooool0oooo0?oooooooolY0?ooo`8000007P3oool2000000P0oooo0P00000R0?ooo`030000
o`3oool0oooo00@0oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI
00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000oooo00`0oooo00<0003o0?ooo`00
0?l00P3oool010000?l0oooo0?ooo`000?l30?ooo`050000o`3oool0oooo0?ooo`000?l00P3oool0
0`000?l0oooo0?ooo`0=0?ooo`@00000103oool5000000030?ooo`000000000000H0000000<0oooo
0000000000000`00000C0?ooo`800000103oool600000080oooo1P00000>0?ooo`030000003oool0
oooo00@0oooo1P0000050?ooo`8000007P3oool4000000D0oooo0P0000070?ooo`<0000000Co0000
00000000003o00000`0000000`3oool0000000000004000000h0oooo00<000000?ooo`3oool0103o
ool8000000<0oooo0P00000M0?ooo`D000001@3oool200000280oooo00<0003o0?ooo`3oool0103o
ool010000?l0oooo0?ooo`3oool3ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0000000030?oo
o`000000oooo0080cLg=00<0VIVI0000003oool0303oool00`000?l0oooo0000o`020?ooo`040000
o`3oool0oooo0000o`<0oooo00D0003o0?ooo`3oool0oooo0000o`040?ooo`D0003o203oool20000
0080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool20000
0080oooo0P0000060?ooo`D000001P3oool00`3<c<`00000010@40030?ooo`8000000P3oool20000
00@0oooo1000000?0?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`800000103oool20000
00l0oooo0`0000020?ooo`<000001P3oool200000080oooo0P00000>0?ooo`80000000Cooooo0000
0000003ooooo0P0000030?ooo`@000003`3oool00`000000oooo0?ooo`050?ooo`8000000P3oool2
000000@0oooo0P00000?0?ooo`<000000P3oool3000000H0oooo0P0000020?ooo`800000103oool0
0`0@410000000<c<c00Q0?ooo`030000o`3oool0oooo00@0oooo00@0003o0?ooo`3oool0oooo0ooo
ool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@00
0000oooo00`0oooo00<0003o0?ooo`000?l00P3oool010000?l0oooo0?ooo`000?l30?ooo`050000
o`3oool0oooo0?ooo`000?l04@3oool2000000H0oooo0P0000020?ooo`8000000P3oool200000080
oooo0P0000060?ooo`8000004@3oool20000000409RHV03oool0oooo0?ooo`8000000P3oool20000
00D0oooo0P00000>0?ooo`D000001@3oool200000080oooo0P0000030?ooo`@00000703oool20000
0180oooo0P0000001?ooool0000000000?ooool2000000@0oooo0P00000>0?ooo`D000001@3oool2
00000080oooo0P0000030?ooo`@00000703oool200000080oooo0P0000040?ooo`0309RHV0000000
00000240oooo00<0003o0?ooo`3oool0103oool010000?l0oooo0?ooo`3oool3ooooo`05o`000?oo
oooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool0303o
ool00`000?l0oooo0000o`020?ooo`040000o`3oool0oooo0000o`<0oooo00D0003o0?ooo`3oool0
oooo0000o`040?ooo`D0003o203oool600000080oooo0P0000020?ooo`8000000P3oool200000080
oooo0P0000030?ooo`@000001`3oool5000000H0oooo00<0c<c<0000000@4100103oool5000000D0
oooo0P00000@0?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`8000000`3oool4000000h0
oooo0`0000020?ooo`<000001P3oool200000180oooo0P0000001?ooool0000000000?ooool20000
00@0oooo0P00000@0?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`8000000`3oool40000
00h0oooo0`0000020?ooo`<000001P3oool200000080oooo0P0000040?ooo`03010@40000000c<c<
0240oooo00<0003o0?ooo`3oool0103oool010000?l0oooo0?ooo`3oool3ooooo`05o`000?oooooo
cLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0VIVI0000003oool0303oool0
0`000?l0oooo0000o`020000o`<0oooo00D0003o0?ooo`3oool0oooo0000o`030?ooo`040000o`3o
ool0oooo0000o`h0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`<00000
00<0oooo0000000000000P3oool200000080oooo0P00000B0?ooo`8000000`3oool200000080oooo
0P0000040?ooo`@000003`3oool00`000000oooo0?ooo`050?ooo`8000000P3oool200000080oooo
0P0000020?ooo`8000006`3oool200000080oooo0P00000>0?ooo`0300000?l0003o000000800000
00?o00000000000000000`3oool4000000l0oooo00<000000?ooo`3oool01@3oool3000000030?oo
o`00000000000080oooo0P0000020?ooo`8000006`3oool200000080oooo0P0000040?ooo`800000
8P3oool00`000?l0oooo0?ooo`040?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000ooooooo=
cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0<0?ooo`03
0000o`3oool0oooo00D0oooo00<0003o0?ooo`3oool00P000?l30?ooo`030000o`3oool0oooo0100
oooo100000040?ooo``00000103oool4000001<0oooo0P0000040?ooo`@00000103oool6000001H0
oooo1@0000020?ooo`P000006`3oool4000000h0oooo0`0000001Oooool0000000000?ooool00000
00<0oooo1P00000E0?ooo`H000000P3oool8000001T0oooo1P0000050?ooo`8000008P3oool00`00
0?l0oooo0?ooo`040?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVI
V@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`0<0?ooo`030000o`3oool0
oooo00D0oooo0P000?l20?ooo`030000o`3oool0oooo0080003o@@3oool2000001<0oooo1@00000@
0?ooo`8000003@3oool5000002/0oooo00Cooooo0?ooo`3ooooooooo2`3oool5000001l0oooo1@00
000O0?ooo`8000008P3oool00`000?l0oooo0?ooo`040?ooo`040000o`3oool0oooo0?ooo`?ooooo
00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT00000
0?ooo`1N0?ooo`800000503oool200000140oooo0`00000>0?ooo`800000<03oool00oooool0oooo
0?ooo`0:0?ooo`8000008P3oool200000240oooo0P00000R0?ooo`030000o`3oool0oooo00@0oooo
00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool0
00000?ooo`020<g=c@0309VIV@000000oooo05h0oooo0P0000000`2YZJT0oooo0?ooo`0B0?ooo`80
00008P3oool2000002l0oooo00?ooooo0?ooo`3oool02`3oool200000280oooo0P00000O0?ooo`03
0:VYZ@000000410@0240oooo0P000?l60?ooo`040000o`3oool0oooo0?ooo`?ooooo00Go0000oooo
ooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`1N0?oo
o`040<c<c014A4@0410@000001@0oooo0P00000R0?ooo`800000;P3oool00oooool0oooo0?ooo`0<
0?ooo`8000008P3oool2000001d0oooo0P0000000`1EEED0gMgM0?ooo`0O0?ooo`030000o`3oool0
003o00H0oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o0000
00000`3oool000000?ooo`020<g=c@0309VIV@000000oooo07<0oooo0P0000000`3oool000000000
000O0?ooo`80000000<0oooo000000000000;P3oool00oooool0oooo0?ooo`090?ooo`80000000<0
oooo0000000000007`3oool2000000030?ooo`00000000000400oooo00@0003o0?ooo`3oool0003o
1P3oool010000?l0oooo0?ooo`3oool3ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l000000003
0?ooo`000000oooo0080cLg=00<0VIVI0000003oool0M03oool300000240oooo0`00000_0?ooo`03
ooooo`3oool0oooo00X0oooo0`00000Q0?ooo`<00000@03oool01@000?l0oooo0?ooo`3oool0003o
00H0oooo00@0003o0?ooo`3oool0oooo0oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o00000000
0`3oool000000?ooo`020<g=c@0309VIV@000000oooo0<X0oooo00?ooooo0?ooo`3oool0L03oool6
0000o`80oooo1@000?l30?ooo`?ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo
0000003oool00P3=cLd00`2IVIT000000?ooo`3:0?ooo`03ooooo`3oool0oooo0800oooo0oooool0
1Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?ooo`020<g=c@0309VIV@000000
oooo02<0oooo0_oooomk0?ooo`03ooooo`3oool0oooo02L0oooo00?ooooo0?ooo`3oool0:03ooomK
ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0000000030?ooo`000000oooo0080cLg=00<0VIVI
0000003oool08`3oool2ooooog/0oooo00?ooooo0?ooo`3oool09`3oool00oooool0oooo0?ooo`0X
0?oooe_ooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd0
0`2IVIT000000?ooo`3d0?oooecooooo00Go0000ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo
0000003oool00P3=cLd00`2IVIT000000?ooo`3d0?oooecooooo00Go0000ooooooo=cLgocLg=oiVI
V@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3d0?oooecooooo00Go0000
ooooooo=cLgocLg=oiVIV@02o`00000000<0oooo0000003oool00P3=cLd00`2IVIT000000?ooo`3o
0?oood`0oooo1Oooool01Ol0003oooooolg=cOo=cLgoVIVI00;o000000000`3oool000000?ooo`02
0<g=c@0309VIV@000000oooo0?l0ooooC03oool5ooooo`05o`000?oooooocLg=olg=cOnIVIT00_l0
000000030?ooo`000000oooo0080cLg=00<0VIVI000000000000o`00001<000000Ko000000Cooooo
olg=cOo=cLgoVIVI0_l0000000030?ooo`000000oooo0080cLg=o`2IVIU?09VIV@OoVIVI0_o=cLd1
oiVIV@7o00000Ol0000000030?ooo`000000oooo0?l0cLg=D@3=cLd9olg=c@7oVIVI0Ol00001o`00
000000<0oooo0000003oool0o`3=cLeA0<g=c@WocLg=0OnIVIT1o`00007o000000000`3oool00000
0?ooo`3o0?oooe40oooo2Oooool1oiVIV@7o00000Oooool000030?ooo`00000000000?l00000D@00
000;o`00007ooooo003o0?oooe@0oooo3?ooool00001\
\>"], "ItemizedPicture",
  ImageSize->{351, 102},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"browser", "i:22", "b:4.1", "gs:0.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:Y0002QR000`400?l00000o`00003ooomVIWko
ofIVOZ_oIVIn00000omVIWkonocmoo_lo@3ooo_loOoonocmYooko?d1ofIVOP0000?oIVInoo_loOnX
ZK/0oonXZK_oojRY^jKoZ:Vk0Ooko?d1ofIVOP0000?oIVInoo_loOnXZK/0oomVIWkoofIVOZGoIVIn
0OnXZK/1oo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWjHooooo`03onc]m?n;S9WoWIj[00coWIj[
00CoRX^Ion?VkOo^kNGo^KZnoonMWZ/WoifNZ`03okfm_oo^kNGoiNK^0:_oiNK^00?ok>gdoh^<VOnM
WZ/03?nMWZ/00on:RiWohnK]on3Oh`0@on3Oh`03ofIVO_nXZK_onocm007oIVIn00001OmVIWkonocm
ojRY^omVIWkoWIfQ09Koh=oS00?ooooooiBEX_oMg^403OoIf^@01?oMg^7oU9FRoiBEX_oJfmkoolO8
eROoalSF00?of]_Noj6R[_oknoh0Zooknoh00onDUJ;ogMkQomWJi00<omWJi003omgNhOnDUJ;oh=oS
00Goh=oS0_ooool2on3Oh`;ooooo0_oPgn<2ooooo`04on3OhomVIWkoZ:Vkoo_lo@7oIVIn00001OmV
IWkonocmojRY^omVIWkoWIfQ09Koh=oS00?ooooooiBEX_ooool03Oo;c=X01?ooooooU9FRoiBEX_oo
ooooolg>g2OocLkL00?ooooooiBEX_oknoh0Zooknoh00onDUJ;ooooool_<fP0<ol_<fP03oooooonD
UJ;oh=oS00Coh=oS00oo^;BSokReXOooooooh=oSokRdXonh]J7oooooon3Ohonh]:?o^;FQoooooooP
gn?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooU9FR
ooooo`0=ol_<fP04oooooonDUJ;oU9FRooooooooc<gK9oo<cM/00oooooooU9FRoo_koP2[oo_koP03
oiBEX_ooooooblcJ00coblcJ00?ooooooiBEX_oPgn<01?oPgn<01_nh]:?o^;BQon3OhooPgn?o^;BS
okRdX@;oh=oS00Oo^;BSokRdXOoPgn?oh=oSofIVO_nXZK_onocm007oIVIn00001OmVIWkonocmojRY
^omVIWkoWIfQ09Koh=oS00?ooooooiBEX_ooool01_o;c=X00olo?CgoblcJol_<fP04ol_<fP07oooo
oonDUJ;oU9FRooooooo>cmgoc/oLolk@g@0`olk?g1SocloM6?o?cm`Holk@gASoc/oM6?o>cm`Holk@
gC3oc/oL6?o?cmdHolo?g005olk@gOo>cmgoc/oMoooooonDUJ80[?ojn_d00onDUJ;ooooool_<fP04
ol_<fP03oclm?Oo;c=[oblcJ00GoblcJ00?ooooooiBEX_oPgn<04?oPgn<00omVIWkoZ:Vkoo_lo@01
ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00GoblcJ0olo?Cd5
ol_<fP04oooooonDUJ;oU9FRoooooa_oe=GP<?oDeN4HomGEhASoe=GQ5OoDeN001on>UJ;oe=GPohjE
X_oDeN3oSYFRomCEh?n>UJ80A?oDeN0`omCEhASoeMGQ0ooDeN400oooooooU9FRooWin`2[ooWin`03
oiBEX_ooooooblcJ00?oblcJ0olo?Cd6ol_<fP03oooooonDUJ;oh=oS00Woh=oS0_ooool2on3Oh`;o
oooo00Coh=oSofIVO_nXZK_onocm0OmVIWh00005ofIVO_oko?goZ:VkofIVO_nMWJ40U_oPgn<00ooo
ooooU9FRooooo`04olc=f`?o?cdm1_o<cM/01?ooooooU9FRoiBEX_ooool2om_KiP03om_KiOoKg>Go
fmcU05kofmcU;?oKfnH02?ooooooSYFRoooooon>UJ;oooooohjEX_ooooooSYFR5?oKfnHHom_KiF3o
fmcU0_oKfnH00ooKg>GooooooiBEXP2/ooWin`03oiBEX_ooooooc<gK00Coc<gK0olo?Cd5olc=f`03
oooooonDUJ;oh=oS00Soh=oS00_o^;BSokReXOooooooh=oSokRdXonh]J7oooooon3OhomVIWkoZ:Vk
oo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00?odM;P
0olo?Cd7om7Bh004oooooonDUJ;oU9FRooooo`;ofm_V00?ofm_Uom_LiOoKg>D0G_oKg>D/om_KiP08
oooooon>UJ;oooooohjEX_ooooooSYFRoooooon>UJ8Dom_KiQSofm_UH?oKg>D2om_KiP03om_LiOoo
ooooU9FR0:con?Sk00?oU9FRoooooooAd^001OoAd^03oclm?@CodM;P00?ooooooiBEX_oPgn<02?oP
gn<01_nh]:?o^;BQon3OhooPgn?o^;BSokRdX@;oh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIV
O_oko?goZ:VkofIVO_nMWJ40U_oPgn<00oooooooU9FRooooo`02omWJi0?o?cdm2?oIf^@01ooooooo
U9FRoiBEX_oooooohn?Zon?RjooRh^X06?oShnXHon?RjQSoh^;Z6?oRhnX/on?SjP08oooooon>UJ;o
ooooohjEX_ooooooSYFRoooooon>UJ8Don?RjaSoh^;Z6?oShnXHon?RjQSoh^;Z6?oRhnX01OoShn[o
h^;[on;SjoooooooU9FR0:comoOi00?oU9FRoooooooIf^@01_oIf^@3oclm?@?ofM[T00?ooooooiBE
X_oPgn<04?oPgn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3O
h`03oooooonDUJ;ooooo00?ohn?[0olo?Cd7on?Sj`07oooooonDUJ;oU9FRoooooooYjNkoj>W^onSX
k`0HonWYkQSojNS^<?oXjNhHonSYkaCojNW^00SoooooohjEX_ooooooSYFRoooooon>UJ;oooooohjE
XQCoj>W^6?oXj>lHonWYkQSojNS^<?oXjNh01OoXjNooj>S^onSXk_ooooooU9FR0:com?Gi00?oU9FR
oooooooShn/01OoShn/3oclm?@Cohn?[00?ooooooiBEX_oPgn<03OoPgn<2ooooo`04on3OhomVIWko
Z:Vkoo_lo@7oIVIn00001OmVIWkonocmojRY^omVIWkoWIfQ09Koh=oS00?ooooooiBEX_ooool01?o/
k?43oclm?@Kok>ca00OooooooiBEX_nDUJ;oooooonWYk_oXjNkoj>S_01SojNW^6?oYj>h`onSYkQSo
j>W_5?oYjNh02?ooooooSYFRoooooon>UJ;oooooohjEX_ooooooSYFR5?oXjNhHonSXkaSojNW^6?oY
j>h`onSYkP05onSYkooXj>koj>S^oooooonDUJ80[?ocloL00onDUJ;oooooonc/l@04onc/l@?o?cdm
1Oo/k?400oooooooU9FRon3Oh`0<on3Oh`07okRdXonh]J7oooooon3OhomVIWkoZ:Vkoo_lo@01ofIV
OP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00Gom?Cg0olo?Cd5ooCd
m`04oooooonDUJ;oU9FRooooohook>ca00Ooooooonc/lOooooook>caooooooo/k?7ooooo093ok>ca
00?ooooooiBEX_o`lOH0Zoo`lOH00onDUJ;oooooooCdm`03ooCdm`?o?cdm1_odm?L00oooooooU9FR
on3Oh`0<on3Oh`07okRdXonh]:7oh=oSon3OhomVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnX
ZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00Konocl00?o?cdmoo_lo?oko?`01?oko?`01?oo
ooooU9FRoiBEX_ooooooonc/lBOok>ca00?ooooooiBEX_o_l?D0Zoo_l?D00onDUJ;ooooooo_lo004
oo_lo003oclm?Ooko?conocl00Gonocl00?ooooooiBEX_oPgn<04?oPgn<00omVIWkoZ:Vkoo_lo@01
ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`03oooooonDUJ;ooooo00kooooo0_nDUJ80
0ooooooomoOiooOgn@3oooOgnBGomoOi00?ooooooiBEX_o^ko@0Zoo^ko@00onDUJ;oooooooooo`0=
ooooo`03oiBEX_oPgn?oh=oS00ooh=oS00?oIVInojRY^ooko?d00OmVIWh00005ofIVO_oko?goZ:Vk
ofIVO_nMWJ40U_oPgn<00oooooooU9FRomKFf`0=ooooo`04omKFfonDUJ;oU9FRoo[jnooooooo9ooo
ool00oojn__oU9FRonc_m02[onc_m003oiBEX_oFe]_ooooo00cooooo00?oe]KKoiBEX_oPgn<04?oP
gn<00omVIWkoZ:Vkoo_lo@01ofIVOP0000GoIVInoo_loOnXZK_oIVInoifMX@2Fon3Oh`05oooooooF
fmWoSi2NokFe__nd];h01ond];d02?nc];go];BmokBd_Onc/kgoS8fLomKKfOoEe]Wo[Znioong]klW
okNg_`03ojFX]_o;c]Gok>kc0:_ok>kc00Coe]_Iohn@W_ne]Kko];Bn1ond];d01_nc];go];BmokBd
_Onc/kgoS8fLomKKfA7oh=oS00?oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOYOo
WIfQ00?oooooonk]iOo^kND03oo^kNGoon_[ib_ojn_W[?oUi^hAonk]iA7oh=oS00?oIVInojRY^ook
o?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOT_ooooo0ol0000Hooooo`?o0000G_ooool2o`000;oo
oooo0_l0000gooooo`?o0000Coooool2o`0000gooooo0ol0001[ooooo`03onk]iOo/kOCoRhbI00co
WIj[00GoRX^Ion?VkOmVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInB_ooool01Ol0
003ooooooooooooooooo000001Kooooo00Go0000ooooooooooooooooo`00001Oooooo`03o`000?oo
oooooooo0;kooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`1@ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool0J_ooool00oo^kNGoU9FRomgNh@0<omWJi005omgNhOnD
UJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOT[ooooo00Go0000oooooooooooo
ooooo`00000Fooooo`05o`000?ooooooooooooooool00000H?ooool00ol0003oooooooooo`2noooo
o`03o`000?oooooooooo03Cooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo06[ooooo00?ok^gUoiBEX_ooool03?o;c=X01OooooooU9FRofIVO_nXZK_o
nocm007oIVIn00001?mVIWkonocmojRY^omVIWhUooooo`04o`000?oooooo0000o`0000Cooooo0ol0
0003ooooo`Go00001?ooool00ol0003oooooooooo`03ooooo`Co00001Oooool3o`000004ooooool0
003o0000o`0000;ooooo00?o0000ooooooooool00_ooool2o`0000;ooooo0ol00006ooooo`?o0000
0_ooool2o`0000;ooooo0ol000001?oooooo0000o`000?ooool2o`0000;ooooo0ol000001Ooooooo
0000o`000?l0003ooooo00;o00001Oooool3o`0000?ooooo0ol00002ooooo`?o00000_ooool4o`00
0004ooooool0003o0000ooooo`?o000000Coooooo`000?l0003o00000_ooool3o`000003ooooool0
003o000000?o00001_ooool3o`0000;ooooo0ol000000ooooooo0000o`000003o`0000?ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`?o00000_ooool2o`0000Gooooo2ol0
0003ooooo`;o00000oooool7o`0000;ooooo2?l00005ooooo`?o00000oooool3o`0000;ooooo0ol0
0002ooooo`Co000000Coooooo`000?l0003ooooo0ol000001?oooooo0000o`000?l00002ooooo`?o
000000?oooooo`000?l000000ol00006ooooo`;o000000Goooooo`000?l0003o0000ooooo`02o`00
0003ooooool0003o000000;o000000?oooooo`000?l000001Oooool7o`0000;ooooo0_l00007oooo
o`03o`000?oooooooooo00;ooooo2_l000000ooooooo0000o`000003o`0000Cooooo0ol00002oooo
o`?o000000?oooooo`000?l000000ol00003ooooo`03o`000?oooooooooo00Kooooo00Co0000oooo
oooooooo00000oooool3o`000004ooooool0003o0000ooooo`;o00000_ooool3o`000003ooooool0
003o000000Cooooo0_l000001Ooooooo0000o`000?l0003ooooo00;o000000?oooooo`000?l00000
1_ooool01?l0003oooooo`000?l00003ooooo`Oo00000_ooool7o`000004ooooool0003o0000oooo
o`;o000000?oooooo`000?l000000oooool2o`0000;ooooo0_l00002ooooo`?o000000Coooooo`00
0?l0003o00001Oooool3o`0000?ooooo1?l000001?oooooo0000o`000?ooool6o`0000;ooooo0ol0
0004ooooo`03o`000?oooooooooo00Cooooo0ol00003ooooo`04o`000?oooooo0000o`0000?ooooo
0_l00003ooooo`;o00000_ooool3o`000003ooooool0003o000000Go00001?ooool2o`0000?ooooo
0ol00002ooooo`?o000000Coooooo`000?l0003ooooo2?l0000eooooo`03onk]iOnDUJ;ooooo00co
blcJ00GooooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool5o`00
00Cooooo0_l00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000oooool01_l0003ooooooooo
ool0003oooooo`0000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`000?oo
ooooooooo`0000?ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`02ooooo`06o`00
0?ooooooooooo`000?oooooo00000oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Go0000oooo
ooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Oo0000oooooooooooooooo
o`000?oooooo000000Wooooo00Go0000ooooooooooooooooo`000005ooooo`05o`000?oooooooooo
ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooool000000_ooool01?l0003oooooooooool00002ooooo`07o`000?ooooooooooooooool0003o
ooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooo0000ooooool00003
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01ol0003ooooo
oooooooooooo0000ooooool000000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo00?o
0000ooooool000000_ooool01?l0003oooooooooool00005ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`04ooooo`05o`000?oooooooooo
ooooool000000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000?ooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo
00000_ooool01ol0003ooooooooooooooooo0000ooooool000001oooool01?l0003oooooooooool0
0004ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01?l0003oooooooooool00002oooo
o`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool00oooool2o`0000;ooooo00?o0000ooooool000000_ooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00Ko
0000oooooooooooo0000ooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000oooo
ool000000_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooo000000Gooooo00Co0000
oooooooooooo00000_ooool2o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`00
0002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool01?l0003oooooooooool00004oooo
o`06o`000?ooooooooooo`000?oooooo00000oooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooo000000?ooooo00Co0000oooooooooooo0000=_ooool00oo^kNGoU9FRooooo`0<ol_<fP05
oooooonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00008oooo
o`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool01oooool2o`0000?ooooo00Ko0000
oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00Cooooo0_l00005ooooo`;o0000
0_ooool00ol0003oooooooooo`03ooooo`06o`000?ooooooooooo`000?oooooo00001Oooool01ol0
003ooooooooooooooooo0000ooooool000002Oooool2o`000003ooooool0003ooooo00;ooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`07o`000?oooooooooooooo
ool0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooooooo
0_l00004ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002oooo
o`07o`000?ooooooooooooooool0003oooooo`000009ooooo`05o`000?ooooooooooooooool00000
1Oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooooooo0_l000000ooo
oooo0000ooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000ooo
ool01?l0003oooooooooooooool2o`0000Kooooo0_l000000ooooooo0000ooooo`02ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01ol0003ooooooooooooooooo
0000ooooool000000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooooooo`;o
00001Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000000_ooool01?l0
003oooooooooool00005ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
2?ooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooo
oooo0000ooooool00003ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`04o`000?ooooooooooo`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo0000
00Kooooo00Ko0000ooooool0003o0000ooooool00003ooooo`06o`000?ooooooooooo`000?oooooo
00001Oooool01?l0003oooooooooool00005ooooo`05o`000?ooooooooooooooool000000_ooool0
0ol0003oooooo`000008ooooo`07o`000?ooooooooooooooool0003oooooo`000002ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002
ooooo`03o`000?oooooo000000Gooooo00Co0000oooooooooooo00001Oooool00ol0003ooooooooo
o`02ooooo`;o00001_ooool2o`000005ooooool0003oooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000?ooooo0_l00002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool0
00001oooool2o`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000Cooooo00?o0000
ooooooooool00oooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`0000Cooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Ko0000oooooooooooo
0000ooooool00003ooooo`05o`000?ooooooooooo`000?ooool00ol0000booooo`03onk]iOnDUJ;o
oooo00GoblcJ00?o?cdmol_<f_o;c=X01?o;c=X01OooooooU9FRofIVO_nXZK_onocm007oIVIn0000
1?mVIWkonocmojRY^omVIWhLooooo`Go00002?ooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;o
oooo1Ol00004ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool0
0002ooooo`Co000000?oooooo`000?l000001_ooool01Ol0003oooooooooool0003ooooo00Co0000
0_ooool01Ol0003oooooooooool0003ooooo00Co00000_ooool01ol0003ooooooooooooooooo0000
ooooool000001oooool2o`0000?ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooo`000003ooooo`04
o`000?ooooooooooo`0000;ooooo00Co0000ooooool0003o00001_ooool01Ol0003ooooooooooooo
oooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`000005ooooo`05o`000?oooooooooo
ooooool000000_ooool01?l0003oooooo`000?l00003ooooo`03o`000?oooooooooo00?ooooo0ol0
0002ooooo`04o`000?ooooooooooo`0000?ooooo00Co0000ooooool0003o00001_ooool2o`0000?o
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00000oooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo
00Co0000ooooool0003o00001oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000oooo
ooooool00ol00002ooooo`03o`000?oooooooooo00Cooooo0ol00002ooooo`03o`000?oooooooooo
00Co00001Oooool00ol0003oooooo`000003ooooo`?o00000_ooool01_l0003oooooooooool0003o
ooooo`0000?ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
00Cooooo00Ko0000oooooooooooo0000ooooool00003ooooo`05o`000?ooooooooooo`000?ooool0
1?l00002ooooo`04o`000?ooooooooooo`0000Gooooo00Go0000ooooooooooooooooo`000002oooo
o`03o`000?oooooo000000?o00001Oooool01Ol0003ooooooooooooooooo000000;ooooo0ol00002
ooooo`04o`000?ooooooooooooooo`?o00000_ooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooo000000?o00000_ooool00ol0003oooooooooo`04o`0000;ooooo00?o0000ooooooooool0
0_l00006ooooo`;o00001?ooool3o`0000;ooooo00Ko0000ooooooooooooooooo`000?ooool2o`00
00Cooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00?ooooo0_l00004
ooooo`06o`000?ooooooooooooooool0003ooooo1?l000000ooooooo0000ooooo`04ooooo`03o`00
0?oooooooooo00?o00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo
00Go0000ooooooooooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000oooool0
1?l0003oooooooooool0000fooooo`03onk]iOnDUJ;ooooo00CoblcJ0olo?Cd5ol_<fP05oooooonD
UJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00005ooooo`?o0000
0oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00_ooool01Ol0003o
oooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`000004ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooool000000oooool00ol0003oooooo`000002ooooo`03o`000?oo
oooo000000;ooooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003oooooo`0000;o
oooo00?o0000ooooooooool00_l000001?oooooo0000ooooool00002ooooo`03o`000?oooooooooo
00;o00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooo
oooooooo0000ooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo
00000_ooool01ol0003ooooooooooooooooo0000ooooool000000oooool00ol0003oooooooooo`02
o`000004ooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooo
oooooooo000000;ooooo0_l000001Ooooooo0000oooooooooooo000000;ooooo00Go0000oooooooo
ooooooooo`000008ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`02
o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooo
000000;ooooo00?o0000ooooooooool00_l000001?oooooo0000ooooooooool2o`000005ooooool0
003oooooooooool000001?ooool01_l0003oooooooooool0003oooooo`0000?ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00002ooooo`07o`000?ooooooooooooooool0003o
ooooo`000003ooooo`03o`000?oooooooooo00;o000000Coooooo`000?oooooo00000_ooool00ol0
003oooooooooo`03ooooo`04o`000?ooooooooooooooo`;o000000Coooooo`000?oooooo00000_oo
ool01?l0003oooooooooool00005ooooo`04o`000?ooooooooooo`0000;ooooo0_l000001Ooooooo
0000oooooooooooo000000Cooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`;o00001?ooool01Ol0003ooooo
oooooooooooo000000;ooooo0_l000001Ooooooo0000oooooooooooo000000;ooooo00Go0000oooo
ooooooooooooo`000005ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_l0
00001?oooooo0000ooooool00002ooooo`03o`000?oooooooooo00;o000000?oooooo`000?ooool0
1?ooool01?l0003oooooooooooooool2o`000004ooooool0003oooooo`0000;ooooo00?o0000oooo
ooooool00oooool2o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`02o`00
0005ooooool0003oooooooooool000000_ooool2o`000007ooooool0003o0000ooooool0003ooooo
o`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool2o`00
0005ooooool0003oooooooooool000001?ooool01_l0003oooooooooool0003oooooo`0000;ooooo
00Co0000oooooooooooo00000oooool00ol0003oooooo`000002ooooo`04o`000?ooooooooooo`00
00?ooooo00Go0000ooooooooooooooooo`000004ooooo`04o`000?ooooooooooo`0000;ooooo0_l0
0002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool01_l0003ooooooooo
ool0003oooooo`0000;ooooo00Co0000oooooooooooo00001?ooool01_l0003oooooooooool0003o
ooooo`0000?ooooo00?o0000ooooooooool00_l000001?oooooo0000ooooool00002ooooo`;o0000
0_ooool00ol0003oooooooooo`0dooooo`03onk]iOnDUJ;ooooo00?oc<gK1Olo?Cd4olc=f`05oooo
oonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVOQcooooo1Ol00004ooooo`03
o`000?oooooooooo00Gooooo0ol00005ooooo`04o`000?ooooooooooooooo`?o000000Coooooo`00
0?l0003o00000_ooool3o`0000Kooooo2Ol00002ooooo`;o000000?oooooo`000?l000000oooool3
o`0000Gooooo1?l000000ooooooo0000o`000002ooooo`;o000000?oooooo`000?ooool00_ooool2
o`0000;ooooo0_l000001?oooooo0000o`000?l00002ooooo`?o00001Oooool3o`0000;ooooo0ol0
0003ooooo`05o`000?oooooo0000o`000?ooool00_l000001Ooooooo0000o`000?l0003ooooo00;o
00000_ooool3o`0000;ooooo0_l000000ooooooo0000ooooo`02ooooo`?o00001Oooool3o`0000;o
oooo0_l000000ooooooo0000ooooo`02ooooo`03o`000?oooooo000000;o000000Coooooo`000?l0
003o00001oooool00ol0003oooooooooo`03o`0000Gooooo0_l000000ooooooo0000ooooo`02o`00
00;ooooo0ol00002ooooo`?o00000_ooool2o`0000;ooooo0_l000000ooooooo0000ooooo`02o`00
0004ooooool0003oooooooooo`?o00001Oooool3o`0000;ooooo0ol00003ooooo`05o`000?oooooo
0000o`000?ooool00_l000001Ooooooo0000o`000?l0003ooooo00;o00000_ooool3o`0000;ooooo
0_l000000ooooooo0000ooooo`02ooooo`?o00001?ooool3o`0000;ooooo00?o0000ooooool00000
0oooool2o`0000;ooooo0ol00005ooooo`;o00000_ooool2o`000003ooooool0003ooooo00;o0000
1?ooool3o`0000;ooooo0_l000000ooooooo0000o`000003ooooo`04o`000?oooooo0000o`0000;o
oooo0_l000000ooooooo0000ooooo`04ooooo`?o00000_ooool2o`000003ooooool0003ooooo00;o
oooo00?o0000ooooool000000_l000001?oooooo0000o`000?l00003ooooo`;o000000Goooooo`00
0?l0003o0000ooooo`02o`000004ooooool0003oooooo`0000?ooooo0_l00002ooooo`;o000000?o
ooooo`000?ooool01?ooool3o`0000;ooooo00?o0000ooooool000000oooool2o`0000Gooooo0_l0
00000ooooooo0000o`000003ooooo`;o00000_ooool2o`000003ooooool0003ooooo00;o00000_oo
ool2o`000005ooooool0003oooooooooool000000oooool2o`0000;ooooo0ol00002ooooo`;o0000
0_ooool2o`000003ooooool0003ooooo00?o00001Oooool3o`0000;ooooo0_l00002ooooo`?o0000
00?oooooo`000?l000000_ooool3o`000005ooooool0003o0000o`000?ooool00ol000001?oooooo
0000o`000?l00004ooooo`?o000000Coooooo`000?l0003ooooo0_l00003ooooo`;o00000oooool3
o`000003ooooool0003o000000;ooooo0_l00003ooooo`03o`000?oooooooooo00?ooooo0ol00002
ooooo`?o00000_ooool2o`000003ooooool0003ooooo00;ooooo0_l000000ooooooo0000ooooo`02
o`0003Kooooo00?ok^gUoiBEX_ooool00_oAd^03oclm?@04om7Bh?lo?Cgo?cdmoclm?@?odM;P00Go
oooooiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVIn9Oooool00ol0003ooooo
ooooo`02o`0000_ooooo00?o0000ooooooooool0GOooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo02Cooooo00?o0000ooooooooool03Oooool01Ol0003ooooooooooooooooo000000Wo
oooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool06?ooool01Ol0003ooooooooooooooooo000000[ooooo00?o0000oooo
ooooool08?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool04oooool00ol0003oooooooooo`0Aooooo`05o`000?ooooooooooooooool00000<?ooool0
0ol0003oooooooooo`0Looooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0:Oooool0
0ol0003oooooooooo`0Gooooo`03o`000?oooooooooo03Oooooo00Cok^gUoiBEX_oooooofM[T0olo
?Cd3omWJi0?o?cdm0_oIf^@01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY
^omVIWhVooooo`;o000000?oooooo`000?ooool02Oooool2o`0005oooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo00gooooo00Go0000oooooooooooo
ooooo`000009ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool04oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo01Sooooo00Go0000ooooooooooooooooo`00000:oooo
o`03o`000?oooooooooo023ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool04Oooool01Ol0003ooooooooooooooooo
0000033ooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`09ooooo`04o`000?oooooo
ooooo`0002Sooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0gooooo`03onk]iOnD
UJ;ooooo00;ohn?[00?o?cdmon?SjooShn/00ooShn/02Olo?Cgohn?[on?SjooShn_ooooooiBEX_mV
IWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInD?ooool00ol0003oooooooooo`0/oooo
o`03o`000?oooooooooo01;ooooo0_l0000<ooooo`03o`000?oooooooooo01oooooo0_l0000>oooo
o`?o00002oooool2o`0000;ooooo00?o0000ooooooooool05Oooool2o`0001Cooooo0_l0000<oooo
o`03o`000?oooooooooo01Oooooo0_l0000/ooooo`;o00000_ooool00ol0003oooooooooo`02oooo
o`;o00004?ooool2o`0001Cooooo0_l0000Fooooo`;o0000Doooool00ol0003oooooooooo`06oooo
o`?o00008?ooool00ol0003oooooooooo`04ooooo`;o00006?ooool2o`0000;ooooo00?o0000oooo
ooooool0=?ooool00oo^kNGoU9FRooooo`0<onc/l@05oooooonDUJ;oIVInojRY^ooko?d00OmVIWh0
0004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`03onk]iOnDUJ;ooooo00com?Cg00Gooooo
oiBEX_mVIWkoZ:Vkoo_lo@01ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00?o
k^gUoiBEX_ooool03?oko?`01OooooooU9FRofIVO_nXZK_onocm007oIVIn00001?mVIWkonocmojRY
^omVIWkoooooooooooooT_ooool00oo^kNGoU9FRooooo`0=ooooo`04oiBEX_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool00oo^kNGoU9FRomKFf`0<ooooo`05
omKFfonDUJ;oIVInojRY^ooko?d00OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBoooo
o`05onk]iOoFfmWoSi2NokFe__nd];h01Ond];d02_nc];go];Bmok>d_Ond];go/k>mohb=W?oFfmWo
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/
k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGV
k_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool02_oUi^ko
k>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oU
i^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:onGV
k_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_n
onGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkooooooaCoooooL?m5CYWooooo
o`kooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_go
no_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOUKooooo0ol0
0017ooooo`?o00008_ooool3o`000?oooooobOooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_oc
loOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP00
00CoIVInoo_loOnXZK_oIVIn?Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo04Go
oooo00Go0000ooooooooooooooooo`00000Pooooo`05o`000?ooooooooooooooool00000ooooooo8
ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_k
o_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhnooooo`03o`00
0?oooooooooo01Kooooo00?o0000ooooooooool0AOooool01Ol0003ooooooooooooooooo0000023o
oooo00Go0000ooooooooooooooooo`00003oooooolSooooo00[oiNK^onc^loo/koCok^odono`mOo`
lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmV
IWh00004ofIVO_oko?goZ:VkofIVORKooooo0_l000001Ooooooo0000o`000?l0003ooooo00?o0000
0_ooool3o`000003ooooool0003o000000?o00000_ooool2o`0000Gooooo0ol00004ooooo`Co0000
00?oooooo`000?l000001Oooool01?l0003oooooo`000?l00002ooooo`?o000000?oooooo`000?l0
00001?l000001?oooooo0000o`000?ooool2o`000004ooooool0003o0000o`0000Kooooo1?l00005
ooooo`04o`000?ooooooooooo`0000Cooooo1ol000001Ooooooo0000o`000?l0003ooooo00So0000
00Coooooo`000?l0003ooooo0ol00004ooooo`?o000000Coooooo`000?l0003ooooo0_l000000ooo
oooo0000o`000002ooooo`?o00000_ooool3o`0000?ooooo1?l000001?oooooo0000o`000?l00002
ooooo`;o00000oooool00ol0003oooooooooo`02ooooo`Co00000oooool2o`0000?ooooo0_l00005
ooooo`?o000000Coooooo`000?l0003ooooo0ol00003ooooo`;o00000_ooool2o`0000;ooooo0ol0
0006ooooo`?o00000_ooool3o`000003ooooool0003o000000Cooooo1Om5CYT01OooooooADjIodE>
VOm5CYWooooo00?oADjI0oooool00om5CYWoooooooooo`03ooooo`CoADjI0_ooool5odE>V@;ooooo
1?m5CYT4ooooo`CoADjI0_ooool3odE>V@Gooooo0_m5CYT00oooooooADjIodE>V@03odE>V@04oooo
oom5CYWoADjIodE>V@;ooooo0om5CYT5ooooo`?oADjI0_ooool5odE>V@?ooooo0om5CYT2ooooo`?o
ADjI00GoooooodE>VOm5CYWoADjIooooo`04odE>V@?ooooo00?o0000ooooooooool0ooooool:oooo
o`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_ok
nokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhVooooo`07o`000?oo
ooooooooooooool0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ool000000_ooool00ol0003oooooooooo`05ooooo`05o`000?ooooooooooooooool000000_ooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Cooooo0_l00002ooooo`04o`000?oo
ooooooooo`0000?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000Cooooo00Co0000oooooooooooo00001_ooool01?l0003ooooooooo
ool00003ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000002oooo
o`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00008ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03
o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000004ooooo`04
o`000?ooooooooooo`0000Oooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo00?o
0000ooooool000000_ooool00ol0003oooooooooo`03ooooo`06o`000?ooooooooooo`000?oooooo
00000oooool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oooooo00000_oo
ool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooo
ooooool00007ooooo`03odE>VOoooooooooo00;ooooo00GoADjIooooooooooooooooodE>V@03oooo
o`03odE>VOooooooADjI00?ooooo00?oADjIooooooooool01Oooool00om5CYWoooooooooo`03oooo
o`05odE>VOoooooooooooooooom5CYT00_ooool00om5CYWoooooooooo`05ooooo`03odE>VOoooooo
oooo00?ooooo00?oADjIooooooooool00_m5CYT2ooooo`05odE>VOoooooooooooooooom5CYT00_oo
ool01Om5CYWoooooooooooooooooADjI00?ooooo00GoADjIooooooooooooooooodE>V@03ooooo`03
odE>VOoooooooooo00;ooooo00GoADjIooooooooooooooooodE>V@02ooooo`05odE>VOoooooooooo
oooooom5CYT00_ooool01Om5CYWoooooooooooooooooADjI0?oooooo3oooool02_oUi^kok>kconc_
m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9_ooool01ol0003ooooooooooooooooo0000
ooooool000000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooooooo`;o0000
1oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`04ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooo
oooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02ooooo`;o0000
1?ooool01?l0003oooooooooool00005ooooo`06o`000?oooooo0000o`000?oooooo00000_ooool0
1?l0003oooooooooool00002ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo0_l00006ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooool000001_ooool2o`0000?ooooo0_l000001Ooooooo0000oooooooo
oooo000000;ooooo0_l00002ooooo`03o`000?oooooooooo00cooooo00?o0000ooooool000001?oo
ool00ol0003oooooooooo`06ooooo`06o`000?ooooooooooo`000?oooooo00000oooool01?l0003o
ooooooooool00002ooooo`03o`000?oooooooooo00Cooooo0_l00004ooooo`05o`000?oooooooooo
ooooool000000_ooool01?l0003oooooooooool00007ooooo`03odE>VOoooooooooo00;ooooo00Go
ADjIooooooooooooooooodE>V@03ooooo`03odE>VOooooooADjI00?ooooo00?oADjIooooooooool0
1Oooool00om5CYWoooooooooo`07ooooo`04odE>VOooooooooooodE>V@Oooooo00?oADjIoooooooo
ool00oooool01Om5CYWoooooooooooooooooADjI00;ooooo00GoADjIooooooooooooooooodE>V@02
ooooo`03odE>VOoooooooooo00Gooooo00?oADjIooooooooool01Oooool00om5CYWoooooooooo`02
ooooo`05odE>VOoooooooooooooooom5CYT00_ooool01Om5CYWoooooooooooooooooADjI00Kooooo
00?oADjIooooooooool0ooooool=ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWo
moOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWhVooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`04o`000?oo
ooooooooo`0000;ooooo00Co0000ooooool0003o00002Oooool01Ol0003ooooooooooooooooo0000
00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`04ooooo`05o`000?oooooo
ooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`02o`0000Oooooo0ol00005ooooo`06o`000?ooooooooooo`00
0?oooooo00000oooool3o`0000;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo
00?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000003o`000003ooooool0003o
000000?ooooo0_l00004ooooo`?o000000Koooooo`000?ooooooooooo`000?ooool4o`0000_ooooo
00?o0000ooooool000000ol000000ooooooo0000o`000002o`0000Gooooo00Ko0000oooooooooooo
0000ooooool00003ooooo`04o`000?ooooooooooo`0000;ooooo1?l000000ooooooo0000o`000006
ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00007ooooo`03odE>
VOoooooooooo00;ooooo00GoADjIooooooooooooooooodE>V@02ooooo`05odE>VOoooooooooooooo
oom5CYT00_ooool5odE>V@?ooooo00?oADjIooooooooool01?ooool3odE>V@?ooooo1Om5CYT3oooo
o`03odE>VOooooooADjI00?ooooo00GoADjIooooooooooooooooodE>V@02ooooo`05odE>VOoooooo
oooooooooom5CYT00_ooool00om5CYWoooooooooo`05ooooo`03odE>VOoooooooooo00Gooooo00?o
ADjIooooooooool00_ooool01Om5CYWoooooooooooooooooADjI00;ooooo00GoADjIoooooooooooo
ooooodE>V@03ooooo`?oADjIooooool@ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmood
mOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWhVooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`03o`00
0?oooooooooo00;o000000Coooooo`000?oooooo00000_ooool00ol0003oooooooooo`05ooooo`;o
00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Kooooo0_l00002
ooooo`03o`000?oooooooooo00;o00000_ooool00ol0003oooooooooo`02o`000005ooooool0003o
ooooooooool000000_ooool01?l0003oooooooooool00004ooooo`04o`000?ooooooooooo`0000Go
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo
00;o00000_ooool2o`000005ooooool0003oooooooooool000000_ooool2o`000004ooooool0003o
ooooo`0000;ooooo00?o0000ooooooooool00oooool2o`000007ooooool0003o0000ooooool0003o
ooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooooooo`07ooooo`;o00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000
ooooooooool00oooool2o`000004ooooool0003oooooo`0000?ooooo00Co0000oooooooooooo0000
0_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_ooool01Ol0
003ooooooooooooooooo000000;ooooo0_l000000ooooooo0000ooooo`06ooooo`03odE>VOoooooo
oooo00;ooooo0_m5CYT2ooooo`04odE>VOooooooooooodE>V@?ooooo00CoADjIooooooooooooADjI
0oooool01?m5CYWoooooooooooooool2odE>V@Cooooo00GoADjIooooooooooooooooodE>V@02oooo
o`05odE>VOoooooooooooooooom5CYT00oooool3odE>V@?ooooo00GoADjIooooooooooooooooodE>
V@02ooooo`;oADjI0_ooool01?m5CYWooooooooooom5CYT3ooooo`05odE>VOoooooooooooooooom5
CYT01oooool00om5CYWoooooooooo`02ooooo`05odE>VOoooooooooooooooom5CYT00_ooool2odE>
V@;ooooo00CoADjIooooooooooooADjI0oooool00om5CYWoooooooooo`3oooooo`gooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORGooooo0ol000000ooooooo0000
o`000002ooooo`?o00000_ooool2o`000003ooooool0003ooooo00;ooooo0ol00007ooooo`04o`00
0?oooooo0000o`0000;ooooo0_l000001?oooooo0000o`000?ooool3o`0000Cooooo0_l000000ooo
oooo0000o`000002ooooo`;o000000Goooooo`000?l0003o0000ooooo`02o`000004ooooool0003o
ooooooooo`?o00000_ooool3o`0000Gooooo0_l00005ooooo`;o000000Goooooo`000?l0003o0000
ooooo`02o`000003ooooool0003o000000;ooooo0_l000001_oooooo0000o`000?l0003oooooo`00
00;ooooo0_l000001Ooooooo0000o`000?oooooo000000?ooooo1?l00003ooooo`;o000000Gooooo
o`000?ooooooooooo`000003ooooo`;o00000oooool3o`0000;ooooo0ol00002ooooo`;o00000ooo
ool4o`000003ooooool0003o000000Wooooo00?o0000ooooooooool00oooool2o`0000?ooooo0_l0
0005ooooo`;o000000?oooooo`000?ooool00_ooool3o`0000;ooooo0ol00002ooooo`;o00000ooo
ool3o`0000Gooooo0ol00002ooooo`;o000000?oooooo`000?ooool01oooool01?m5CYWooooooooo
ooooool2odE>V@03oooooom5CYWoADjI00;ooooo0om5CYT01?ooooooADjIodE>VOm5CYT2ooooo`?o
ADjI0oooool2odE>V@03oooooom5CYWoADjI00?ooooo1?m5CYT3ooooo`?oADjI1?ooool00om5CYWo
ooooodE>V@02ooooo`;oADjI0_ooool2odE>V@04oooooom5CYWoADjIooooo`;oADjI1?ooool4odE>
V@;ooooo1Om5CYT2ooooo`?oADjI1Oooool3odE>V@;ooooo0_m5CYT00oooooooADjIodE>V@04oooo
o`CoADjIooooool?ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;o
nOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWhVooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0Hooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool07Oooool00ol0003ooooooooo
o`0Oooooo`03odE>VOoooooooooo02gooooo00GoADjIooooooooooooooooodE>V@0Gooooo`03odE>
VOoooooooooo0?oooooo;?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOoh
n?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVIn9_ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool06?ooool00ol0003oooooooooo`1Vooooo`05o`000?ooooooooooooooool000006oooool0
0ol0003oooooooooo`0Mooooo`GoADjI;?ooool6odE>VAoooooo00?oADjIooooooooool0oooooolT
ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_k
o_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhZooooo`03o`00
0?oooooooooo01Gooooo0_l0000Nooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool0
>oooool4o`000?oooooo^?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOoh
n?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOog
moWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWo
moOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWi1ooooo`?o0000:?ooool3o`000?oooooooooooolSooooo`0:onGVk_o/k_?ok>od
onk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWko
Z:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWi0ooooo`05o`000?ooooooooooooooool00000
:?ooool00ol0003oooooooooo`3oooooofOooooo00?o0000ooooooooool0]oooool02_oUi^kok>kc
onc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^ko
IVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn@?ooool01Ol0003ooooooooooooooooo
000002Sooooo00?o0000ooooooooool0oooooomXooooo`03o`000?oooooooooo0;Kooooo00[oiNK^
onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknoko
iNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORGooooo0ol000001?oooooo0000
o`000?ooool2o`000004ooooool0003o0000o`0000;ooooo0ol00002ooooo`;o00001_ooool3o`00
00;ooooo0_l00002ooooo`?o000000Coooooo`000?l0003ooooo0_l00002ooooo`?o00000_ooool7
o`0000Cooooo0_l00003ooooo`;o000000?oooooo`000?ooool00_ooool4o`000003ooooool0003o
000000;o000000Coooooo`000?l0003ooooo0ol000001?oooooo0000o`000?l00002ooooo`?o0000
00?oooooo`000?l000000ol00003ooooo`03o`000?oooooooooo00Cooooo0ol00003ooooo`?o0000
00Coooooo`000?l0003ooooo0_l00006ooooo`Go000000?oooooo`000?l000000_ooool3o`0000;o
oooo1?l00002ooooo`Oo000000?oooooo`000?l000001?ooool6o`0000Kooooo1Ol000001Ooooooo
0000o`000?l0003ooooo00?o00000oooool00ol0003oooooooooo`03ooooo`Co00000_ooool5o`00
00;ooooo1?l00004ooooo`Co00000_ooool3o`0000Gooooo0_l000000ooooooo0000o`000003o`00
0004ooooool0003o0000o`0000;ooooo0ol00005ooooo`?o00000_ooool5o`0000?ooooo0ol00002
ooooo`?o000000Goooooo`000?l0003o0000ooooo`04o`0000Wooooo0_l00005ooooo`?o000000Co
ooooo`000?l0003o00000_ooool2o`000003ooooool0003o000000?ooooo0ol00003ooooo`?o0000
0_ooool7o`0000;ooooo1Ol00003ooooo`?o00000_ooool5o`0000?ooooo0ol00003ooooo`03o`00
0?oooooooooo00;ooooo0ol000001Ooooooo0000o`000?l0003ooooo00;o00001?ooool2o`000005
ooooool0003o0000o`000?ooool02?l00006ooooo`;o00000oooool7o`0000?ooooo0_l00002oooo
o`;o00001Oooool01?l0003oooooo`000?l00004ooooo`?o00000oooool5o`0000Cooooo00?o0000
ooooooooool00oooool4o`0000Gooooo0_l00003ooooo`Oo000000?oooooo`000?l000001Oooool7
o`0000?ooooo0_l00005ooooo`Ko000000?oooooo`000?l000000_ooool00ol0003oooooooooo`02
ooooo`;o00000_ooool3o`000004ooooool0003o0000o`0000?ooooo0_l00005ooooo`?o00000ooo
ool7o`000004ooooool0003o0000ooooo`;o0000<?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3a
m_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVIn9_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
000000?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00004ooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0003ooooo
o`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooooooo00;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`;o00000_ooool01_l0
003oooooooooool0003oooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003ooooo
o`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000_ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00?ooooo00Ko0000oooooooooooo0000ooooool00002
ooooo`03o`000?oooooooooo00;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00001_ooool00ol0003oooooo`000002ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000?ooooo
00?o0000ooooool000000oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo
00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`02o`0000;ooooo00Go0000ooooooooooooooooo`000002oooo
o`05o`000?ooooooooooooooool000000oooool01Ol0003ooooooooooooooooo000000?ooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooooooo
ooooo`000002ooooo`05o`000?ooooooooooooooool000002_ooool00ol0003oooooooooo`03oooo
o`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`02o`0000?ooooo00Oo0000
ooooooooooooooooo`000?oooooo000000?ooooo00So0000oooooooooooo0000ooooool0003ooooo
o`0000;ooooo00Go0000ooooooooooooooooo`000003ooooo`05o`000?ooooooooooooooool00000
0oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000002?ooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo
000000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo00;ooooo
00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;ooooo00?o0000oooo
ool000000_ooool00ol0003oooooooooo`06ooooo`;o00000_ooool01?l0003oooooooooool00003
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooo`000003
ooooo`03o`000?oooooooooo00Kooooo00Ko0000oooooooooooo0000ooooool00002ooooo`04o`00
0?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01_l0003oooooooooool0003ooooo
o`0000;ooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`03ooooo`04o`000?oooooo
ooooo`0000;ooooo00Go0000ooooooooooooooooo`000003ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo
00?ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooool000000_ooool00ol0003oooooooooo`0]ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Go
l?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7o
IVIn00001?mVIWkonocmojRY^omVIWhVooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ool000000oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Kooooo0_l00002
ooooo`03o`000?oooooooooo00?ooooo00Ko0000oooooooooooo0000ooooool00005ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`02oooo
o`05o`000?ooooooooooooooool000000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo
00Co0000oooooooooooo00000oooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooooooo0_l0000:ooooo`03o`000?oooooooooo00?ooooo00Ko0000
oooooooooooo0000ooooool00007ooooo`07o`000?ooooooooooooooool0003oooooo`000005oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooooooo0_l00007ooooo`03
o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooo0000
00?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`07ooooo`04o`000?oooooooooo
o`0000Oooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000;ooooo00Go
0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003o
oooooooooooooooo000000Kooooo00?o0000ooooooooool02Oooool2o`0000?ooooo1Ol00002oooo
o`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`03ooooo`05o`000?oooooo
ooooooooool000000_ooool01Ol0003oooooo`000?oooooo000000;ooooo00Go0000oooooooooooo
ooooo`000003ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0:ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`03oooo
o`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00003ooooo`;o00001?oo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000?ooooo0_l000000ooooooo0000
ooooo`0>ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool0
1?l0003oooooooooool00003ooooo`;o000000?oooooo`000?ooool01oooool01?l0003ooooooooo
ool00002ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00;ooooo0_l000000ooooooo0000ooooo`07ooooo`05o`000?oooooooooo
ooooool000000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000Cooooo0ol0
000[ooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[m
oo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWhVooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooool000000oooool01?l0003oooooooooool00002
ooooo`Co00001?ooool01Ol0003oooooooooool0003ooooo00Co00000_ooool01Ol0003ooooooooo
ool0003ooooo00Co00000_ooool01?l0003oooooooooooooool3o`0000;ooooo00?o0000oooooooo
ool00_ooool4o`000003ooooool0003ooooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`03o`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooo`000?l0000<ooooo`03o`000?oooooooooo00?o
oooo00Go0000oooooooooooo0000ooooo`04o`0000Cooooo00Ko0000ooooooooooooooooo`000?oo
ool4o`0000;ooooo00Co0000oooooooooooooooo0ol00002ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00001_ooool01?l0003oooooo`000?l00009ooooo`03o`000?oooooo
oooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool00000
0_ooool5o`0000?ooooo00?o0000ooooooooool01?ooool3o`0000?ooooo1Ol00003ooooo`03o`00
0?oooooo000000?ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooooooooooo
ool000000_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000ooooooooooooooooo`00
0003ooooo`?o00000oooool5o`0000Kooooo00Oo0000ooooooooooooooooo`000?oooooo000000?o
oooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00?ooooo00Go0000oooo
ooooooooooooo`000002ooooo`05o`000?oooooo0000ooooool000000oooool4o`0000?ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo00Go
0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooo
ooooo`000002ooooo`05o`000?ooooooooooo`000?ooool00_l00006ooooo`03o`000?oooooooooo
00?ooooo0ol000000ooooooo0000o`000003ooooo`Co00003?ooool01?l0003oooooooooool00003
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooo
oooo000000;ooooo1Ol00004ooooo`03o`000?oooooooooo00?ooooo0ol00002ooooo`04o`000?oo
ooooooooo`0000Gooooo00Go0000oooooooooooo0000ooooo`02o`0000?ooooo1?l00005ooooo`04
o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`Co00000_oo
ool00ol0003oooooooooo`02o`0000?ooooo1?l00005ooooo`05o`000?ooooooooooooooool00000
0_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000003;ooooo00[oiNK^onc^loo/
koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORKooooo0_l000001ooooooo0000o`000?oo
oooo0000ooooool000000oooool00ol0003oooooooooo`02o`000005ooooool0003oooooooooool0
00001?ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_l00000
1?oooooo0000ooooool00002ooooo`03o`000?oooooooooo00;o000000Goooooo`000?oooooooooo
o`000002ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooo0000ooooool00002oooo
o`;o00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Co0000oooooooooooo0000
0oooool00ol0003oooooo`000003ooooo`03o`000?oooooooooo00;o000000Coooooo`000?oooooo
00000_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo0_l000001?oooooo
0000ooooool00002ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_l000001Ooo
oooo0000oooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooo`000002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool2o`0000;o
oooo00Co0000oooooooooooo00000oooool01?l0003oooooooooool00003ooooo`04o`000?oooooo
ooooooooo`;o00001?ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooooooo
ooooo`000003ooooo`?o00000oooool01Ol0003ooooooooooooooooo000000;ooooo0_l00002oooo
o`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000007ooooo`03o`000?oo
oooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`;o00000_ooool01?l0003ooooo
ooooool00003ooooo`03o`000?oooooooooo00Wooooo0_l00004ooooo`03o`000?oooooo000000?o
oooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00?ooooo00Go0000oooo
ooooooooooooo`000002ooooo`05o`000?oooooo0000ooooool000000_ooool01Ol0003ooooooooo
oooooooo000000?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`05o`00
0?ooooooooooooooool000002?ooool01?l0003oooooooooooooool2o`000003ooooool0003ooooo
00Cooooo00Co0000oooooooooooooooo0_l000001ooooooo0000oooooooooooo0000ooooool00000
0_ooool00ol0003oooooooooo`02ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0
003oooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01oooool3o`00
00?ooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00Go0000
ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000001?ooool01_l0003ooooo
ooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_l000000ooooooo0000ooooo`04oooo
o`06o`000?ooooooooooo`000?oooooo00000_ooool00ol0003oooooo`000002ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_l000001?oooooo0000ooooool00003ooooo`03o`00
0?oooooo000000;ooooo00?o0000ooooooooool00_l000001ooooooo0000oooooooooooo0000oooo
ool000000_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool0
0ol0003oooooooooo`02o`000004ooooool0003oooooo`0000;ooooo00?o0000ooooooooool0;Ooo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9Oooool2o`000005
ooooool0003oooooooooool000000oooool3o`0000;ooooo0_l000000ooooooo0000ooooo`02o`00
00Kooooo1?l000000ooooooo0000o`000002ooooo`;o000000?oooooo`000?ooool00_ooool2o`00
00;ooooo0_l000000ooooooo0000ooooo`02o`0000?ooooo00?o0000ooooooooool00oooool2o`00
00?ooooo0_l000000ooooooo0000ooooo`02o`000003ooooool0003o000000;ooooo0_l00002oooo
o`?o000000?oooooo`000?l000000_ooool3o`0000;ooooo0_l000000ooooooo0000ooooo`02oooo
o`?o00002_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000?ooooo0_l00006oooo
o`;o000000Coooooo`000?oooooooooo0_l00002ooooo`?o00000_ooool2o`0000;ooooo0_l00000
0ooooooo0000o`000002ooooo`03o`000?oooooo000000;o00001?ooool2o`0000;ooooo0ol00007
ooooo`04o`000?ooooooooooooooo`;o000000?oooooo`000?l000000_ooool3o`000004ooooool0
003o0000o`0000;ooooo0ol00003ooooo`;o000000?oooooo`000?l000000oooool4o`0000?ooooo
0ol00004ooooo`03o`000?oooooo000000;ooooo0_l00002ooooo`;o000000Coooooo`000?l0003o
oooo0_l00004ooooo`Co00000_ooool5o`0000;ooooo0ol00005ooooo`?o00000_ooool2o`000003
ooooool0003o000000Cooooo1?l0000:ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool0
00000_ooool2o`0000;ooooo0_l00002ooooo`Go00000oooool3o`0000;ooooo0ol000000ooooooo
0000ooooo`03ooooo`?o00000oooool5o`0000;ooooo0ol00005ooooo`Co00002?ooool00ol0003o
ooooooooo`02o`000003ooooool0003ooooo00Cooooo0ol00002ooooo`03o`000?oooooo000000;o
oooo0_l00002ooooo`?o00001Oooool3o`0000;ooooo0_l00003ooooo`?o00000_ooool2o`0000Wo
oooo00?o0000ooooooooool01Oooool3o`0000Gooooo00Co0000oooooooooooooooo0ol000001?oo
oooo0000o`000?l00002ooooo`?o00001_ooool3o`0000;ooooo0_l00002ooooo`;o000000?ooooo
o`000?ooool01?ooool2o`000003ooooool0003o000000;ooooo0ol00002ooooo`;o00001Oooool2
o`000006ooooool0003o0000ooooool0003ooooo0ol00002ooooo`;o000000?oooooo`000?l00000
0_ooool2o`000003ooooool0003ooooo00?o00000_ooool2o`0000Gooooo0ol000001?oooooo0000
o`000?ooool2o`000005ooooool0003o0000ooooool000000oooool3o`0002oooooo00[oiNK^onc^
loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^
ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOUoooooo00?o0000ooooooooool06Ooo
ool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00cooooo00Co0000oooooooooooo0000
4oooool00ol0003oooooooooo`0]ooooo`05o`000?ooooooooooooooool000005oooool00ol0003o
ooooooooo`0Uooooo`;o00002?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Wo
oooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0:ooooo`05o`000?oooooooooooooo
ool00000:_ooool00ol0003oooooooooo`02o`0000_ooooo00?o0000ooooooooool0G_ooool00ol0
003oooooooooo`0oooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;o
nOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omV
IWiOooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool06_ooool01?l0003ooooooooo
ool00002ooooo`04o`000?ooooooooooo`00013ooooo00?o0000ooooooooool01Oooool01?l0003o
ooooooooool0000;ooooo`04o`000?ooooooooooo`00017ooooo1Ol0000/ooooo`Ko00007oooool0
0ol0003oooooooooo`0Vooooo`;o0000<?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo00[ooooo00Go0000ooooooooooooooooo`00000[ooooo`;o000000?oooooo`000?ooool02Ooo
ool2o`00063ooooo00Co0000oooooooooooo0000?_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3a
m_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIV
OP0000CoIVInoo_loOnXZK_oIVInG_ooool2o`0001oooooo00?o0000ooooooooool05_ooool7o`00
0003ooooool0003o000000oooooo0_l00008ooooo`?o00002_ooool2o`0000Wooooo00?o0000oooo
ooooool0b_ooool3o`0000kooooo0_l00005ooooo`03o`000?oooooooooo06kooooo00?o0000oooo
ooooool08oooool3o`0003kooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWo
n?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?go
Z:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOi
ooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocm
ojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVInoooooooooooooi;ooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOog
moWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_ok
o?goZ:VkofIVO_oooooooooooonBooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWo
moOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWko
nocmojRY^omVIWkoooooooooooooT_ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?Gi
ooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVIn
oo_loOnXZK_oIVIn@?ooool3o`0009;ooooo0ol0003ooooooaKooooo0_l0002Qooooo`0:onGVk_o/
k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGV
k_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWi1ooooo`03o`000?oooooooooo09;o
oooo00?o0000ooooooooool0oooooolGooooo`03o`000?oooooooooo09kooooo00[oiNK^onc^loo/
koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_oknokoiNK^ofIV
O_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVOT7ooooo00?o0000ooooooooool0T_ooool0
0ol0003oooooooooo`3ooooooaSooooo00?o0000ooooooooool0WOooool02_oUi^kok>kconc_m?o^
koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY
^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9_ooool3o`0000?ooooo0ol000001?oooooo0000
o`000?ooool2o`0000Kooooo0ol00003ooooo`04o`000?oooooo0000o`0000?ooooo0_l000001Ooo
oooo0000o`000?l0003ooooo00?o00000_ooool3o`000003ooooool0003o000000Cooooo1Ol00000
1Ooooooo0000o`000?l0003ooooo00?o00000oooool00ol0003oooooooooo`03ooooo`Co00000_oo
ool5o`0000;ooooo1?l00004ooooo`Co00000_ooool3o`0000Gooooo0_l000000ooooooo0000o`00
0003o`000004ooooool0003o0000o`0000;ooooo0ol00005ooooo`?o00000_ooool5o`0000?ooooo
0ol00002ooooo`?o000000Goooooo`000?l0003o0000ooooo`04o`0000Gooooo0ol00003ooooo`04
o`000?oooooo0000o`0000?ooooo0_l00003ooooo`;o00000_ooool6o`000005ooooool0003o0000
o`000?ooool00_l00002ooooo`?o00001oooool01?l0003oooooooooool00003ooooo`?o000000Co
ooooo`000?l0003ooooo0_l00003ooooo`;o000000Goooooo`000?l0003o0000ooooo`02o`000003
ooooool0003o000000;ooooo0ol00005ooooo`04o`000?oooooo0000o`0000Cooooo0ol00003oooo
o`Go00001?ooool00ol0003oooooooooo`03ooooo`Co00001?ooool3o`0000;ooooo0ol000001?oo
oooo0000o`000?ooool3o`0000Cooooo1ol000000ooooooo0000o`000003o`0000Gooooo1ol00003
ooooo`;o00001Oooool6o`000003ooooool0003o000000;ooooo00?o0000ooooooooool00_ooool2
o`0000;ooooo0ol000001?oooooo0000o`000?l00003ooooo`;o00001Oooool3o`0000?ooooo1ol0
00001?oooooo0000o`000?ooool2o`0000?ooooo0_l000001Ooooooo0000o`000?l0003ooooo00?o
00000_ooool3o`000003ooooool0003o000000?o00001_ooool2o`0000;ooooo0ol00006ooooo`;o
000000Coooooo`000?l0003o00001?ooool00ol0003oooooooooo`05ooooo`Oo000000Coooooo`00
0?l0003ooooo1Ol00003ooooo`?o000000?oooooo`000?l000001?l000001?oooooo0000o`000?oo
ool5o`0000?ooooo0ol00003ooooo`?o00000_ooool3o`0000;ooooo1?l000001?oooooo0000o`00
0?ooool3o`000004ooooool0003o0000o`0000;ooooo0ol000000ooooooo0000o`000003o`0000Ko
oooo0_l00002ooooo`?o0000>?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn7?ooool5o`0000Kooooo00?o0000ooooooooool00oooool01_l0003oooooooooool0
003oooooo`0000;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;o
oooo0_l00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool000000oooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool0
1Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooool000000oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02o`0000;ooooo
00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000000oooool01Ol0
003ooooooooooooooooo000000?ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooo
oooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool0
00001?ooool01?l0003oooooooooool00002ooooo`;o00000_ooool00ol0003oooooo`000002oooo
o`03o`000?oooooo000000;ooooo00Co0000oooooooooooo00000_ooool01ol0003ooooooooooooo
oooo0000ooooool000000_ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Cooooo
00Co0000oooooooooooo00001?ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Co0000
oooooooooooo00000oooool01_l0003oooooooooool0003oooooo`0000;ooooo00Co0000oooooooo
oooo00001_ooool2o`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`06
ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`04
o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oo
oooooooo00?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooo000000;o
oooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002ooooo`05o`000?oooooooooo
ooooool000000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooool000000_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool0
00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000;ooooo00Co0000oooo
oooooooo00000oooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooool000000_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000?ooooo
00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool0
00001Oooool01?l0003oooooooooool00002ooooo`06o`000?ooooooooooo`000?oooooo00000ooo
ool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000000_ooool01_l0003ooooo
ooooool0003oooooo`0000?ooooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003o
ooooo`0000?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`07
o`000?ooooooooooooooool0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooool000000_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000?ooooo
00?o0000ooooooooool0=Oooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOoh
n?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnX
ZK_oIVIn7?ooool5o`0000Kooooo00?o0000ooooooooool00oooool01_l0003oooooooooool0003o
ooooo`0000Oooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool0
00000_ooool01ol0003ooooooooooooooooo0000ooooool000000oooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooo
oooooooo000000?ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo00Oooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`03ooooo`05
o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00Go0000
ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000001_ooool00ol0003ooooo
ooooo`04ooooo`;o00000_ooool01ol0003ooooooooooooooooo0000ooooool000001?ooool00ol0
003oooooooooo`03ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool000001_ooool2
o`0000Gooooo00Ko0000ooooool0003o0000ooooool00003ooooo`06o`000?ooooooooooo`000?oo
oooo00001Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooool000001Oooool0
0ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool02?oo
ool2o`0000;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`04o`000?ooooooooooo`00
00;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00?ooooo00Co
0000oooooooooooo00000oooool2o`000003ooooool0003ooooo00Oooooo00Co0000oooooooooooo
00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`02ooooo`;o000000?oooooo`000?ooool01oooool01Ol0003ooooooooooooo
oooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000005ooooo`07o`00
0?ooooooooooooooool0003oooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooooooo0_l00005ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool0
0oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooool000001Oooool01?l0003o
ooooooooool00002ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003ooooooooo
o`03ooooo`05o`000?ooooooooooooooool000000_ooool01_l0003oooooooooool0003oooooo`00
00?ooooo00?o0000ooooooooool01?ooool2o`000003ooooool0003ooooo00;ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00002ooooo`07o`000?ooooooooooooooool0003o
ooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooooooo0_l00005
ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool0=Oooool02_oUi^kok>kconc_
m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVIn
ojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn7?ooool5o`0000Kooooo00?o0000oooooooo
ool00oooool01Ol0003oooooooooool0003ooooo00Co00001?ooool01Ol0003ooooooooooooooooo
000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`07o`000?ooooooooooooooool0003o
ooooo`000003ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`02ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooo
oooo000000;ooooo1Ol00003ooooo`03o`000?oooooooooo00Cooooo0ol00003ooooo`Go00000ooo
ool00ol0003oooooo`000003ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?oooooooooo
ooooool000000oooool3o`0000Gooooo0_l00004ooooo`06o`000?ooooooooooooooool0003ooooo
1?l000000ooooooo0000ooooo`04ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool0
00000ol000000ooooooo0000o`000007ooooo`06o`000?ooooooooooo`000?oooooo00000oooool0
1Ol0003oooooooooool0003ooooo00Co00000_ooool01Ol0003ooooooooooooooooo000000;ooooo
00?o0000ooooool000000ol00002ooooo`03o`000?oooooooooo00Sooooo00Co0000oooooooooooo
00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooo
ooooooooo`000002ooooo`Go00001?ooool2o`0000Cooooo00Ko0000oooooooooooo0000ooooool0
0003ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00003oooo
o`03o`000?oooooooooo00?ooooo00Go0000oooooooooooo0000ooooo`02o`0000?ooooo1?l00005
ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`Co
00000_ooool00ol0003oooooooooo`02o`0000?ooooo1?l00005ooooo`05o`000?oooooooooooooo
ool000000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo000000Gooooo00Oo0000
ooooooooooooooooo`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooo`000?l00007ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00oooool0
1Ol0003ooooooooooooooooo000000?ooooo00Co0000oooooooooooo00001_ooool3o`0000;ooooo
00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo00?ooooo00Go0000oooo
ooooooooooooo`000002ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003ooooo
ooooo`02ooooo`;o00000oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooo000000?ooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooo`000?l00007ooooo`04o`000?ooooooooooo`0000?o
oooo00?o0000ooooooooool0=Oooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn7?ooool5o`0000Kooooo00?o0000ooooooooool00oooool2o`000004ooooool0003o
ooooo`0000;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000;ooooo
0_l00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool000000oooool00ol0003o
ooooooooo`02o`000003ooooool0003ooooo00Kooooo00?o0000ooooooooool00_ooool2o`0000;o
oooo00Co0000oooooooooooo00000oooool01?l0003oooooooooool00003ooooo`04o`000?oooooo
ooooooooo`;o00001?ooool01Ol0003ooooooooooooooooo000000;ooooo00Go0000oooooooooooo
ooooo`000003ooooo`?o00000oooool01Ol0003ooooooooooooooooo000000;ooooo0_l00002oooo
o`04o`000?ooooooooooo`0000?ooooo00Go0000ooooooooooooooooo`000007ooooo`03o`000?oo
oooooooo00;ooooo00Go0000ooooooooooooooooo`000002ooooo`;o00000_ooool01?l0003ooooo
ooooool00003ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool2o`00
00;ooooo00?o0000ooooool000000_ooool00ol0003oooooo`000002ooooo`04o`000?oooooooooo
o`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo00?o0000ooooool00000
0_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool00_l000001?oooooo0000ooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo0_l00000
1?oooooo0000ooooool00002ooooo`03o`000?oooooooooo00;o00001_ooool3o`0000?ooooo00Go
0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00;ooooo00Go0000oooooooooooo
ooooo`000002ooooo`05o`000?ooooooooooooooool000001?ooool01?l0003oooooooooool00002
ooooo`;o000000Coooooo`000?oooooo00000oooool01?l0003oooooooooool00002ooooo`06o`00
0?ooooooooooo`000?oooooo00000_ooool2o`0000Gooooo00Ko0000oooooooooooo0000ooooool0
0002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`02o`000004ooooool0003oooooo`0000?ooooo00?o0000ooooool000000_ooool00ol0003ooooo
ooooo`02o`000007ooooool0003oooooooooool0003oooooo`000002ooooo`03o`000?oooooooooo
00?ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo00;o000000Cooooo
o`000?oooooo00000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooo000000?ooooo
00?o0000ooooooooool00_l000001?oooooo0000ooooool00002ooooo`03o`000?oooooooooo00?o
oooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`03ooooo`04o`000?oooooooooo
ooooo`;o00000_ooool01Ol0003ooooooooooooooooo000000Cooooo00Co0000oooooooooooo0000
0_ooool2o`000004ooooool0003oooooo`0000;ooooo0_l00005ooooo`05o`000?oooooooooooooo
ool000000_ooool2o`000004ooooool0003oooooo`0000;ooooo0_l00004ooooo`06o`000?oooooo
ooooo`000?oooooo00000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o0000ooooooooool00_l0
00001?oooooo0000ooooool00002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo
00000oooool00ol0003oooooooooo`0eooooo`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmood
mOWomoOiooShn`;onOWk00Son_[moo_ko_oknokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mV
IWkonocmojRY^omVIWhLooooo`Go00001_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
000000?ooooo0_l00006ooooo`?o00000_ooool2o`000003ooooool0003o000000;ooooo0ol00000
0ooooooo0000o`000002ooooo`?o00000_ooool2o`000003ooooool0003ooooo00Oooooo00Co0000
oooooooooooooooo0_l000000ooooooo0000o`000002ooooo`?o000000Coooooo`000?l0003o0000
0_ooool3o`0000?ooooo0_l000000ooooooo0000o`000003ooooo`Co00000oooool3o`0000Cooooo
00?o0000ooooool000000_ooool2o`0000;ooooo0_l000001?oooooo0000o`000?ooool2o`0000Co
oooo1?l00002ooooo`Go00000_ooool3o`0000Gooooo0ol00002ooooo`;o000000?oooooo`000?l0
00001?ooool4o`0000Gooooo0ol000001?oooooo0000o`000?ooool2o`0000?ooooo0_l00003oooo
o`?o000000Coooooo`000?l0003ooooo0ol000000ooooooo0000o`000002ooooo`;o00000oooool3
o`0000Cooooo0_l000001Ooooooo0000o`000?l0003ooooo00;o000000Coooooo`000?oooooo0000
0oooool2o`0000;ooooo0ol00002ooooo`03o`000?oooooo000000?ooooo0_l00002ooooo`;o0000
00?oooooo`000?ooool00oooool00ol0003oooooooooo`05ooooo`?o00001Oooool01?l0003ooooo
ooooooooool3o`000004ooooool0003o0000o`0000;ooooo0ol00006ooooo`?o00000_ooool00ol0
003oooooo`000003ooooo`?o00000_ooool2o`000003ooooool0003o000000;ooooo00?o0000oooo
ooooool00_l000000ooooooo0000ooooo`03ooooo`;o000000?oooooo`000?l000000_ooool3o`00
00;ooooo0_l00005ooooo`;o000000Koooooo`000?l0003oooooo`000?ooool3o`0000;ooooo0_l0
00000ooooooo0000o`000002ooooo`;o000000?oooooo`000?ooool00ol00002ooooo`;o00001Ooo
ool3o`000004ooooool0003o0000ooooo`;o000000Goooooo`000?l0003oooooo`000003ooooo`?o
000000Goooooo`000?l0003o0000ooooo`02o`0000;ooooo0ol00002ooooo`;o000000?oooooo`00
0?ooool00_ooool3o`0000Cooooo0ol00002ooooo`?o00001Oooool3o`000004ooooool0003o0000
ooooo`Co000000Coooooo`000?l0003o00001?ooool2o`0000;ooooo0_l000000ooooooo0000oooo
o`02ooooo`;o000000?oooooo`000?ooool00oooool3o`000004ooooool0003o0000ooooo`;o0000
00?oooooo`000?ooool00_ooool2o`000003ooooool0003ooooo00Cooooo0ol00002ooooo`?o0000
0oooool01Ol0003oooooo`000?l0003ooooo00;o000000Goooooo`000?l0003o0000ooooo`02o`00
00;ooooo0ol00002ooooo`;o000000?oooooo`000?ooool00_ooool3o`0000Cooooo0ol00002oooo
o`?o0000>?ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08
oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVIn9ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool05Ooo
ool00ol0003oooooooooo`0]ooooo`05o`000?ooooooooooooooool000005oooool00ol0003ooooo
ooooo`0kooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02?ooool01Ol0003ooooo
oooooooooooo0000017ooooo00?o0000ooooooooool00_l0000;ooooo`03o`000?oooooooooo01So
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03_o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00go
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01So
oooo00?o0000ooooooooool0??ooool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOg
nOohn?/2ooWin`08oo[joOoknokono_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l
oOnXZK_oIVIn9?ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0001[ooooo
00?o0000ooooooooool04oooool5o`0002cooooo1_l0000Oooooo`03o`000?oooooooooo03?ooooo
00Co0000oooooooooooo00006Oooool00ol0003oooooooooo`08ooooo`05o`000?oooooooooooooo
ool000004_ooool2o`000003ooooool0003ooooo00Wooooo0_l0000Jooooo`03o`000?oooooooooo
00oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0kooooo`04o`000?oooooooooo
o`00017ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo01gooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0000<ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Hooooo`03o`000?oo
oooooooo03cooooo00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/0
2?ojn_gono_noo_ko_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVORCo
oooo1ol000000ooooooo0000o`00000Nooooo`03o`000?oooooooooo09Sooooo00Co0000oooooooo
oooooooo1?l0000Gooooo`;o00003Oooool2o`0003_ooooo0_l0000@ooooo`;o00001?ooool2o`00
01Sooooo00?o0000ooooooooool08oooool3o`0001Gooooo00?o0000ooooooooool0@?ooool2o`00
00Kooooo1?l0000:ooooo`;o00003oooool2o`0000cooooo00?o0000ooooooooool0Doooool02_oU
i^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_noo_k
o_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo00[o
iNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_ko_ok
nokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBooooo`0:
onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_oknoko
no_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_ooool0
2_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknokono_n
oo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_loOnXZK_oIVInoooooooooooooi;ooooo
00[oiNK^onc^loo/koCok^odono`mOo`lOKolo?gooCenOogmoWon?Sk0_oinO/02?ojn_gono_noo_k
o_oknokoiNK^ofIVO_nXZK_onocm0OmVIWh00004ofIVO_oko?goZ:VkofIVO_oooooooooooonBoooo
o`0:onGVk_o/k_?ok>odonk_m?o_l?Gol?7foo?cmoodmOWomoOiooShn`;onOWk00Son_[moo_ko_ok
nokono_nonGVk_mVIWkoZ:Vkoo_lo@7oIVIn00001?mVIWkonocmojRY^omVIWkoooooooooooooT_oo
ool02_oUi^kok>kconc_m?o^koCoko3eoo3am_ocloOom?GiooOgnOohn?/2ooWin`08oo[joOoknoko
no_noo_ko_oUi^koIVInojRY^ooko?d1ofIVOP0000CoIVInoo_l