(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    250658,       4621]*)
(*NotebookOutlinePosition[    502972,       9239]*)
(*  CellTagsIndexPosition[    496187,       9037]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["File Layout", "Subsection",
  CellTags->{
  "Versions on CD-ROM", "CD-ROM: versions available on", 
    "Additional versions", "Front end only versions", "High school versions", 
    "Student versions", "MathLink Developer's Kits", 
    "Developer kits: MathLink", "Installation details", 
    "Installation: types of", "Types of installation", 
    "Sizes of installations", "Minimal installation", 
    "Front end only: installing", "Installation: front end only", 
    "Kernel only: installing", "Installation: kernel only", 
    "Documentation: installing", "Standard add-on packages: installing", 
    "Custom installation directions", "Initialization files", "Startup files",
     "Memory requirements", "Removing all files", "Uninstalling Mathematica", 
    "init.m: for front end", "ConfigurationPath", "PreferencesPath", 
    "Preferences: front end", "Preferences: kernel", "Resources: front end", 
    "Resources: kernel", "init.m: for kernel", "Site administration", 
    "Configuration folder", "Fonts", "Documentation configuration", 
    "BrowserIndex", "Location of packages", 
    "Standard add-on packages: location", "Packages: location of", 
    "Application packages: location", "Autoload packages: location", 
    "Loading packages automatically", "layout", "gs:0.19"}],

Cell[TextData[{
  "For general technical information on the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel or front end, please refer to ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  "."
}], "Highlight",
  CellTags->{"layout", "gs:0.19"}],

Cell[CellGroupData[{

Cell["Initialization files and resources", "Subsubsection",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],

Cell["\<\
Initialization files are stored in two directories: the systemwide \
base directory and the user-specific preferences directory. Within each of \
these directories are several possible subdirectories with titles such as \
FrontEnd, Kernel, and Licensing.\
\>", "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will first load settings from files in the base directory and then load \
settings from files in the preferences directory. This allows systemwide \
configuration information to be stored in the base directory (see ",
  ButtonBox["below",
    ButtonData:>{"File Layout", "Configuration_subsection"},
    ButtonStyle->"GettingStartedLink",
    ButtonNote->"page 47"],
  ")."
}], "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            StyleBox["Platform",
              "SB"], 
            StyleBox[\(Base\ directory\),
              "SB"]},
          {\(Windows\ 98, \ Me\), 
            RowBox[{"C", ":", 
              
              RowBox[{\(\(\(\\\)\(Windows\)\)\\All\), 
                " ", \(Users\\Application\), " ", 
                RowBox[{"Data", "\\", 
                  StyleBox["Mathematica",
                    FontSlant->"Plain"]}]}]}]},
          {\(Windows\ NT\), 
            RowBox[{"C", ":", 
              
              RowBox[{\(\(\(\(\\\)\(WINNT\)\)\\Profiles\)\\All\), 
                " ", \(Users\\Application\), " ", 
                RowBox[{"Data", "\\", 
                  StyleBox["Mathematica",
                    FontSlant->"Plain"]}]}]}]},
          {\(Windows\ 2000, \ XP\), 
            RowBox[{"C", ":", 
              RowBox[{
                RowBox[{
                  StyleBox["\\",
                    "TR"], "Documents"}], " ", "and", " ", 
                RowBox[{"Settings", 
                  StyleBox["\\",
                    "TR"], 
                  StyleBox["All",
                    FontSize->9]}], 
                StyleBox[" ",
                  FontSize->9], 
                RowBox[{
                  StyleBox["Users",
                    FontSize->9], 
                  StyleBox["\\",
                    FontSize->9], "Application"}], " ", 
                RowBox[{"Data", "\\", 
                  StyleBox["Mathematica",
                    FontSlant->"Plain"]}]}]}]},
          {\(Mac\ OS\ X\), 
            RowBox[{\(\(/\)\(Library\)\), "/", 
              StyleBox["Mathematica",
                FontSlant->"Plain"]}]},
          {\(Unix\ and\ Linux\), 
            RowBox[{\(\(\(/\)\(usr\)\)/share\), "/", 
              StyleBox["Mathematica",
                FontSlant->"Plain"]}]}
          }],
      "SR",
      FontSize->10]], "2ColumnBox",
  GridBoxOptions->{ColumnAlignments->{Left}},
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],

Cell[TextData[{
  "To set the location of the base directory, you can set the environment \
variable MATHEMATICA_BASE. In all cases, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " refers to the location of the base directory as ",
  StyleBox["$BaseDirectory", "MR"],
  "."
}], "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            StyleBox["Platform",
              "SB"], 
            StyleBox[\(Preferences\ directory\),
              "SB"]},
          {\(Windows\ 98, \ Me\), 
            RowBox[{"C", ":", 
              RowBox[{
                RowBox[{
                  StyleBox["\\",
                    "TR"], "Windows", 
                  StyleBox["\\",
                    "TR"], "Application"}], " ", 
                RowBox[{"Data", 
                  StyleBox["\\",
                    "TR"], 
                  StyleBox["Mathematica",
                    FontSlant->"Plain"]}]}]}]},
          {\(Windows\ NT\), 
            RowBox[{"C", ":", 
              RowBox[{
                RowBox[{"\\", "WINNT", "\\", "Profiles", "\\", 
                  StyleBox["username",
                    "TI"], "\\", "Application"}], " ", 
                RowBox[{"Data", 
                  StyleBox["\\",
                    "TR"], 
                  StyleBox["Mathematica",
                    FontSlant->"Plain"]}]}]}]},
          {\(Windows\ 2000, \ XP\), 
            RowBox[{"C", ":", 
              RowBox[{\(\(\\\)\(Documents\)\), " ", "and", " ", 
                RowBox[{"Settings", "\\", 
                  StyleBox["username",
                    "TI"], "\\", "Application"}], " ", 
                RowBox[{"Data", "\\", 
                  StyleBox["Mathematica",
                    FontSlant->"Plain"]}]}]}]},
          {\(Mac\ OS\ X\), 
            RowBox[{\(\(~\)\(\(/\)\(Library\)\)\), "/", 
              StyleBox["Mathematica",
                FontSlant->"Plain"]}]},
          {\(Unix\ and\ Linux\), 
            RowBox[{" ", 
              RowBox[{"~", 
                RowBox[{"/.", 
                  StyleBox["Mathematica",
                    FontSlant->"Plain"]}]}]}]}
          }],
      "SR",
      FontSize->10]], "2ColumnBox",
  GridBoxOptions->{ColumnAlignments->{Left}},
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],

Cell[TextData[{
  "To define where preferences should be stored, you can set the environment \
variable MATHEMATICA_USERBASE. In all cases, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " refers to the location for preferences as ",
  StyleBox["$UserBaseDirectory", "MR"],
  ". "
}], "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],

Cell[TextData[{
  "In the following documentation, replace the variables ",
  StyleBox["$BaseDirectory", "MR"],
  " and ",
  StyleBox["$UserBaseDirectory", "MR"],
  " with the appropriate directories for your system."
}], "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Front end", "Subsubsection",
  CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],

Cell[TextData[{
  "The file FrontEnd/init.m stores preferences for the front end. The Option \
Inspector lists two paths that are searched to find this file: ",
  StyleBox["ConfigurationPath", "MR"],
  " and ",
  StyleBox["PreferencesPath", "MR"],
  ". Any init.m file found on either path is read. If a setting is listed in \
more than one file, the most recent setting from the last init.m file read is \
used."
}], "Text",
  CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],

Cell[TextData[{
  "In addition, any directory in the ",
  StyleBox["$BaseDirectory", "MR"],
  "/Autoload or ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/Autoload directories may contain a file called FrontEnd/init.m. If such a \
file exists, it is loaded automatically."
}], "Text",
  PageBreakAbove->True,
  CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],

Cell["\<\
Caches store the locations and names of all system and text \
resources used by the front end. If the caches are missing, they are rebuilt \
automatically when the front end is started. \
\>", "Text",
  CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            StyleBox["Platform",
              "SB"], 
            StyleBox[\(Location\ of\ caches\),
              "SB"]},
          {\(Windows\ 98, \ Me, \ NT\), 
            RowBox[{"C", ":", 
              
              RowBox[{\(\(\(\\\)\(Windows\)\)\\Local\), 
                " ", \(Settings\\Application\), " ", 
                RowBox[{"Data", "\\", 
                  StyleBox["Mathematica",
                    FontSlant->"Plain"], "\\", "FrontEnd"}], "\\5", ".2", " ",
                 "Caches"}]}]},
          {\(Windows\ 2000, \ XP\), 
            RowBox[{"C", ":", 
              RowBox[{\(\(\\\)\(Documents\)\), " ", "and", " ", 
                RowBox[{"Settings", "\\", 
                  StyleBox["username",
                    "TI",
                    FontSlant->"Italic"], "\\", "Local"}], 
                " ", \(Settings\\Application\), " ", 
                RowBox[{"Data", "\\", 
                  StyleBox["Mathematica",
                    FontSlant->"Plain"], "\\", "FrontEnd"}], "\\5", ".2", " ",
                 "Caches"}]}]},
          {\(Mac\ OS\ X\), 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{\(\(~\)\(\(/\)\(Library\)\)\), "/", 
                    StyleBox["Mathematica",
                      FontSlant->"Plain"]}], "/", "FrontEnd"}], "/", "5.2"}], 
              " ", "Caches"}]},
          {\(Unix\ and\ Linux\), 
            RowBox[{"~", 
              RowBox[{"/.", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["Mathematica",
                        FontSlant->"Plain"], "/", "FrontEnd"}], "/", "5.2"}], 
                  "_Caches"}]}]}]}
          }],
      "SR",
      FontSize->10]], "2ColumnBox",
  GridBoxOptions->{ColumnAlignments->{Left}},
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel", "Subsubsection",
  CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],

Cell[TextData[{
  "The file Kernel/init.m stores preferences for the kernel. Two files are \
read on startup: ",
  StyleBox["$BaseDirectory", "MR"],
  "/Kernel/init.m and ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/Kernel/init.m."
}], "Text",
  CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],

Cell[TextData[{
  "Any subdirectory in ",
  StyleBox["$BaseDirectory", "MR"],
  "/Autoload or ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/Autoload may contain a file called Kernel/init.m. If such a file exists, \
it is loaded automatically when the kernel is started."
}], "Text",
  CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Systemwide defaults", "Subsubsection",
  CellTags->{
  "layout", "Configuration_subsection", "i:6", "b:18.3", "gs:0.19"}],

Cell[TextData[{
  "You can set up systemwide defaults for both the front end and kernel by \
creating init.m files in subdirectories of ",
  StyleBox["$BaseDirectory", "MR"],
  ". This is ideal for setting up ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for use in computer labs and classrooms."
}], "Text",
  CellTags->{"layout", "i:6", "b:18.3", "gs:0.19"}],

Cell["To set up a configuration file for the front end:", "Subsubsubsection",
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],

Cell[TextData[{
  "On one machine, set up any changes to the front end that you need in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". An example of a front end change is changing the default open palettes."
}], "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],

Cell[TextData[{
  "Quit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "ItemizedList",
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],

Cell[TextData[{
  "Go to the ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/FrontEnd directory, and copy the file init.m to ",
  StyleBox["$BaseDirectory", "MR"],
  "/FrontEnd. "
}], "ItemizedList",
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],

Cell[TextData[{
  "These preferences will now be used with the front end unless overridden by \
the local init.m file stored in ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/FrontEnd."
}], "Text",
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],

Cell["To set up a configuration file for the kernel:", "Subsubsubsection",
  CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}],

Cell[TextData[{
  "Launch ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " and create a new file. Add any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands that should be evaluated at startup. Enter all the commands in \
the same cell, separating commands with semicolons. Make this cell an \
initialization cell by selecting the cell bracket and then choosing ",
  StyleBox["Cell", "SR"],
  " \[RightTriangle] ",
  StyleBox["Cell Properties", "SR"],
  " \[RightTriangle] ",
  StyleBox["Initialization Cell", "SR"],
  ". Using ",
  StyleBox["File", "SR"],
  " \[RightTriangle] ",
  StyleBox["Save As Special ", "SR"],
  "\[RightTriangle] ",
  StyleBox["Package Format", "SR"],
  ", save the file as ",
  StyleBox["$BaseDirectory", "MR"],
  "/Kernel/init.m."
}], "Text",
  CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Fonts", "Subsubsection",
  CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],

Cell[TextData[{
  "Several fonts with names such as \[OpenCurlyDoubleQuote]Mathematica1\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]Mathematica1Bold\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]Mathematica2\
\[CloseCurlyDoubleQuote], and \[OpenCurlyDoubleQuote]Mathematica2Bold\
\[CloseCurlyDoubleQuote] are installed when you install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". You do not need to know which font a particular character is from in \
order to use it; this is handled automatically by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],

Cell["\<\
On Mac OS X, after you run the front end for the first time, the \
fonts will be available to any program on your system. \
\>", "Text",
  PageBreakAbove->True,
  CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],

Cell["\<\
Some printers allow you to download fonts for faster printing. You \
may be able to do this from the Properties dialog box for your printer.\
\>", \
"Text",
  CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Documentation", "Subsubsection",
  PageBreakAbove->Automatic,
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],

Cell[TextData[{
  "The notebooks used by the Help Browser are stored in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s Documentation directory in a language subdirectory, \
such as English or Japanese. The notebooks are split into categories that are \
presented as buttons in the browser. "
}], "Text",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],

Cell["\<\
Other documentation files can be stored in any of the following \
directories:\
\>", "Text",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],

Cell[TextData[{
  StyleBox["$BaseDirectory", "MR"],
  "/Applications "
}], "BulletedList",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],

Cell[TextData[{
  StyleBox["$BaseDirectory", "MR"],
  "/Autoload "
}], "BulletedList",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],

Cell[TextData[{
  StyleBox["$UserBaseDirectory", "MR"],
  "/Applications "
}], "BulletedList",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],

Cell[TextData[{
  StyleBox["$UserBaseDirectory", "MR"],
  "/Autoload "
}], "BulletedList",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],

Cell[TextData[{
  "Documentation files must be stored in a Documentation/",
  StyleBox["language", "TI"],
  " directory. When the front end is started, each subdirectory is searched \
for a file called BrowserCategories.m, which defines the categories and \
notebooks."
}], "Text",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Application package locations", "Subsubsection",
  CellTags->{"layout", "b:18.6", "gs:0.19"}],

Cell["Standard packages", "Subsubsubsection",
  CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],

Cell[TextData[{
  "Standard application packages are installed in ",
  StyleBox["$InstallationDirectory", "MR"],
  "/AddOns/StandardPackages. The standard packages are subdivided by topic, \
so that within the StandardPackages directory are directories with names such \
as Algebra, Calculus, and NumericalMath. "
}], "Text",
  CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],

Cell["Application packages", "Subsubsubsection",
  CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],

Cell[TextData[{
  "Products from the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Applications Library should be installed in ",
  StyleBox["$BaseDirectory", "MR"],
  "/Applications or ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/Applications. "
}], "Text",
  CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],

Cell[TextData[{
  "Applications installed in ",
  StyleBox["$BaseDirectory", "MR"],
  " will be available to all users, while applications installed in ",
  StyleBox["$UserBaseDirectory", "MR"],
  " will only be available to the specified user. See ",
  StyleBox["Add-ons & Links", "SR"],
  " \[RightTriangle] ",
  StyleBox["Working with Add-ons", "SR"],
  " in the Help Browser for more information."
}], "Text",
  CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],

Cell["The Autoload subdirectory", "Subsubsubsection",
  CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],

Cell[TextData[{
  "Application packages installed in ",
  StyleBox["$BaseDirectory", "MR"],
  "/Autoload and ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/Autoload will be loaded automatically when you start ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". To autoload a standard application package, copy the entire directory, \
such as ",
  StyleBox["AddOns/StandardPackages/Algebra", "MR"],
  ", to the ",
  StyleBox["$BaseDirectory", "MR"],
  "/Autoload or ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/Autoload directory."
}], "Text",
  CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],

Cell[TextData[{
  "Any init.m file located in any directory within ",
  StyleBox["Autoload", "MR"],
  " is loaded automatically by the front end."
}], "Text",
  CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],

Cell[TextData[{
  "For more information about installing application packages, see ",
  StyleBox["Add-ons & Links", "SR"],
  " \[RightTriangle] ",
  StyleBox["Working with Add-ons", "SR"],
  " in the Help Browser."
}], "Text",
  CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["MathLink",
  FontSlant->"Italic"]], "Subsubsection",
  CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],

Cell[TextData[{
  "On Windows, the transport mechanisms available when using ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " are TCP, TCPIP, SharedMemory, and Filemap. The SharedMemory and Filemap \
mechanisms are used for linking programs that are running on the same \
machine."
}], "Text",
  CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],

Cell[TextData[{
  "On Macintosh and Unix, the transport mechanisms available when using ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " are TCP, TCPIP, and Pipes."
}], "Text",
  CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Troubleshooting on Windows", "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Installation difficulties", "Conflicts during installation", 
    "Preferences: rebuilding", "init.m", "Resetting to defaults", 
    "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
    "Help files: assistance with", "Graphics: problems with", 
    "Problems: with graphics", "Rerendering graphics", 
    "Graphics: rerendering", "Packages: problems with", 
    "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
    "gs:0.20"}],

Cell[TextData[{
  "Check the Technical Support web pages at ",
  ButtonBox["support.wolfram.com",
    ButtonData:>{
      URL[ "http://support.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  " for further assistance.\n\nIf you do not find the information you need, \
please contact ",
  ButtonBox["Technical Support",
    ButtonData:>{
      URL[ "mailto:support@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ". Include your license number in all correspondence. The license number is \
located on your license certificate. It also is available after installation \
by choosing ",
  StyleBox["Help", "SB"],
  " \[RightTriangle] ",
  StyleBox["About Mathematica", "SB"],
  ".\n\nYou must be a registered customer to receive installation support. \
You must have a current ",
  StyleBox["Premier Service",
    FontSlant->"Italic"],
  " subscription to receive technical support."
}], "Highlight",
  CellTags->{"Troubleshooting_Win", "i:16", "gs:0.20"}],

Cell[CellGroupData[{

Cell["Installation difficulties", "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],

Cell[TextData[{
  "If the installation fails, open the Windows directory on the CD and run \
setup.exe to install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],

Cell[TextData[{
  "If problems persist or for late-breaking news, check the FAQs for your \
platform at ",
  ButtonBox["support.wolfram.com/mathematica/systems",
    ButtonData:>{
      URL[ "http://support.wolfram.com/mathematica/systems"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Front end preferences", "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}],

Cell[TextData[{
  "Front end preferences, such as the names of recent palettes and style \
sheets or the locations of recently opened and saved files, are stored in a \
front end initialization file called init.m. This file is located in ",
  StyleBox["$UserBaseDirectory", "MR"],
  "\\",
  "Mathematica",
  "\\FrontEnd. "
}], "Text",
  CellTags->{"i:69", "b:19.1", "gs:0.20"}],

Cell[TextData[{
  "The most convenient way to reset the front end preferences to their \
default values is to hold down ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]", "KeyboardChars"],
  " during startup. This will cause the initialization file to rebuild \
automatically. "
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Caches", "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],

Cell[TextData[{
  "Information about your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system layout, such as the locations of text resource files and Help \
Browser files, is stored in caches. These caches are located in \
C:\\Windows\\Local Settings\\Application Data\\Mathematica\\FrontEnd\\5.2 \
Caches on Windows 98, Me, and NT and C:\\Documents and Settings\\",
  StyleBox["username", "TI"],
  "\\Local Settings\\Application Data\\Mathematica\\FrontEnd\\5.2 Caches on \
Windows 2000 and XP."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],

Cell[TextData[{
  "A corrupted cache may cause the front end to produce an error or quit \
immediately on startup. The most convenient way to restore the caches to \
their default values is to hold down ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]", "KeyboardChars"],
  " during startup. This will cause the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " caches and the initialization file to be rebuilt automatically. "
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],

Cell[TextData[{
  "If you want to rebuild your caches but retain your preferences, hold down \
",
  StyleBox["\[ShiftKey]", "KeyboardChars"],
  " during startup. This will delete and rebuild the cache without rebuilding \
your front end initialization file."
}], "Text",
  CellTags->{"b:19.2", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Help files", "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is unable to locate information in the Help Browser, make sure that the \
documentation has been installed. By default, a minimal installation will not \
load help files."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics", "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}],

Cell[TextData[{
  "Bitmap caches are created for graphics to allow for quick retrieval of \
images. If you change the display settings on your system, the colors in your \
graphics may appear strange. To rerender all graphics after changing any \
setting to your monitor, select the graphics and use ",
  StyleBox["Cell", "SR"],
  " \[RightTriangle] ",
  StyleBox["Rerender Graphics", "SR"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Standard application packages", "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],

Cell["\<\
If you are unable to load any standard application packages, check \
that the packages have been installed. Make sure a backquote (`) is used in \
the loading command, as in\
\>", "Text",
  CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],

Cell[TextData[StyleBox["<<Graphics`Graphics3D`", "MR"]], "Text",
  CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],

Cell["\<\
The backquote character is usually located with the ~ character on \
the upper left-hand side of the keyboard.\
\>", "Text",
  CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Crashes", "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],

Cell["\<\
In the event that the front end crashes, do the following before \
restarting the front end.\
\>", "Text",
  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica 5.2 Kernel", "SR"],
  " is still present in the taskbar, click it using the right mouse button \
and choose ",
  StyleBox["Close", "SR"],
  " from the pop-up menu."
}], "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],

Cell["\<\
If you are running Windows 98 or Me, there is a small chance that a \
front end crash may destabilize your system. If you experience further \
problems after a front end crash, restart your computer.\
\>", "ItemizedList",\

  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],

Cell[TextData[{
  "If the front end crashes again before any notebook is open, restart the \
front end while holding down ",
  StyleBox["\[ShiftKey]", "KeyboardChars"],
  "\[KeyBar]",
  StyleBox["\[ControlKey]", "KeyboardChars"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SCANDISK and DriveSpace incompatibility", "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],

Cell[TextData[{
  "The SCANDISK program that comes with Windows 98 and Me is limited to \
working with files whose complete pathnames in DOS mode are no more than 66 \
characters long. Some files in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " layout have longer pathnames than this, and SCANDISK treats this as a \
possible error. If you run SCANDISK interactively, tell it to ignore these \
errors."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],

Cell[TextData[{
  "Unfortunately, the DriveSpace 3 disk compression software uses SCANDISK to \
check the disk before compressing it. Therefore, you will not be able to use \
DriveSpace 3 to compress a drive that has ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installed on it. You can, however, uninstall ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", compress the drive, and then reinstall ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Memory", "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " performs best on Windows systems with at least 64 megabytes of RAM. \
Physical memory is supplemented by Windows\[CloseCurlyQuote] virtual memory \
management."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],

Cell[TextData[{
  "If there is a shortage of disk space for virtual memory, you might run out \
of memory when using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Even if there is plenty of virtual memory available, large memory \
demands can hurt your system\[CloseCurlyQuote]s efficiency.",
  " "
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Display", "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " requires at least an 8-bit display."
}], "Text",
  CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Troubleshooting on Mac OS X", "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Troubleshooting", "Installation difficulties", 
    "Conflicts during installation", 
    "Extension: conflicts during installation", 
    "Control panel: conflicts during installation", "Preferences: rebuilding",
     "init.m", "Resetting to defaults", "Defaults: resetting to", 
    "Shift-Option", "Trouble with help files", "Help files: assistance with", 
    "Graphics: problems with", "Problems: with graphics", 
    "Monitors control panel", "Rerendering graphics", "Graphics: rerendering",
     "Packages: problems with", "Problems: with packages", 
    "MathLink: problems with", "Problems: with MathLink", 
    "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],

Cell[TextData[{
  "Check the Technical Support web pages at ",
  ButtonBox["support.wolfram.com",
    ButtonData:>{
      URL[ "http://support.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  " for further assistance.\n\nIf you do not find the information you need, \
please contact ",
  ButtonBox["Technical Support",
    ButtonData:>{
      URL[ "mailto:support@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ". Include your license number in all correspondence. The license number is \
located on your license certificate. It also is available after installation \
by choosing ",
  StyleBox["Help", "SB"],
  " \[RightTriangle] ",
  StyleBox["About Mathematica", "SB"],
  ".\n\nYou must be a registered customer to receive installation support. \
You must have a current ",
  StyleBox["Premier Service",
    FontSlant->"Italic"],
  " subscription to receive technical support."
}], "Highlight",
  CellTags->{"Troubleshooting_MacOSX", "i:27", "gs:0.21"}],

Cell[CellGroupData[{

Cell["Installation difficulties", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],

Cell[TextData[{
  "If you are unable to copy the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application to your hard drive, you may not have write privileges to the \
destination folder. Copy the application to another location, such as your \
home folder, or log on as administrator."
}], "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],

Cell[TextData[{
  "If problems persist or for late-breaking news, check the FAQs for your \
platform at ",
  ButtonBox["support.wolfram.com/mathematica/systems",
    ButtonData:>{
      URL[ "http://support.wolfram.com/mathematica/systems"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Bundles", "Subsubsection",
  CellTags->{
  "Troubleshooting_MacOSX", "Bundles_subsection", "i:29", "b:20.1", "gs:0.21"}
    ],

Cell[TextData[{
  "When you first installed ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.2 for Mac OS X, you probably noticed that there was a single icon \
rather than a folder full of other folders, as was the case with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for Mac OS 9 and earlier. This is because the icon is both an application \
and a folder."
}], "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}],

Cell[TextData[{
  "In the Finder, you can double-click the icon to launch ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", just like a normal application. If you \
\[ControlKey]\[NegativeThinSpace]-\[NegativeThinSpace]click the icon, a \
pop-up menu appears that allows you to show the contents of the bundle, \
revealing the folder structure underneath. Apple usually calls these \
packages. To avoid confusion with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application packages, they are called bundles in this guide."
}], "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["To optimize available memory:", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],

Cell["Close notebooks when you are finished with them.", "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],

Cell[TextData[{
  "Clear the Clipboard by copying something small to replace large data. Or, \
use ",
  StyleBox["Edit", "SR"],
  " \[RightTriangle] ",
  StyleBox["Paste As", "SR"],
  " \[RightTriangle] ",
  StyleBox["Paste and Discard", "SR"],
  " instead of ",
  StyleBox["Paste", "SR"],
  "."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],

Cell["\<\
If you only need to edit a notebook, run the front end without \
starting the kernel.\
\>", "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],

Cell["Set your monitor to fewer colors.", "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],

Cell["Save notebooks after large results and plots.", "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["To reduce memory use in the kernel:", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],

Cell[TextData[{
  "Use a setting such as ",
  StyleBox["$HistoryLength=10", "MR"],
  " to limit the number of stored input and output lines."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],

Cell[TextData[{
  "Use ",
  StyleBox["Remove[", "MR"],
  StyleBox["vars", "TI"],
  StyleBox["]", "MR"],
  " to remove any unnecessary variables."
}], "BulletedList",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],

Cell[TextData[{
  "Use the command ",
  StyleBox["Share", "MR"],
  " periodically to share the storage of common subexpressions."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Window title bars", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}],

Cell[TextData[{
  "When you make changes to a file, the red ",
  StyleBox["Close", "SR"],
  " button changes to indicate that the file has been changed since the file \
was last saved."
}], "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Pathnames", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}],

Cell["\<\
Pathnames now use a POSIX-style forward slash instead of the older \
Macintosh colon. The root of the system is designated by / on Mac OS X, and \
the current directory on Mac OS X is . (a period).\
\>", "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Front end preferences", "Subsubsection",
  CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],

Cell["\<\
Front end preferences, such as the names of recent palettes and \
style sheets or the locations of recently opened and saved files, are stored \
in a front end initialization file called init.m. This file is located in the \
directory ~/Library/Mathematica/FrontEnd. \
\>", "Text",
  CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],

Cell["\<\
If you want to restore the default settings for your preferences, \
drag the init.m file out of ~/Library/Mathematica/FrontEnd and restart the \
front end. The init.m file will rebuild automatically.\
\>", "Text",
  CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],

Cell[TextData[{
  "The most convenient way to reset the front end preferences to their \
default values is to hold down ",
  StyleBox["\[ShiftKey]\[KeyBar]\[OptionKey]", "KeyboardChars"],
  " during startup. This will cause the initialization file to rebuild \
automatically. "
}], "Text",
  CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Caches", "Subsubsection",
  CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],

Cell[TextData[{
  "Information about your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system layout, such as the locations of text resource files and Help \
Browser files, is stored in caches. These caches are located in the directory \
specified by ",
  StyleBox["$UserBaseDirectory", "MR"],
  StyleBox["/FrontEnd/5.2 Caches", "TR"],
  ". To find the exact location of ",
  StyleBox["$UserBaseDirectory", "MR"],
  " on your machine, evaluate the command ",
  StyleBox["$UserBaseDirectory", "MR"],
  " in a notebook."
}], "Text",
  CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],

Cell[TextData[{
  "A corrupted cache may cause the front end to produce an error or quit \
immediately on startup. The most convenient way to restore the caches to \
their default values is to hold down ",
  StyleBox["\[ShiftKey]\[KeyBar]\[OptionKey]", "KeyboardChars"],
  " during startup. This will cause the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " caches and the initialization file to rebuild automatically. "
}], "Text",
  CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],

Cell[TextData[{
  "If you want to rebuild your caches but retain your preferences, hold down \
",
  StyleBox["\[ShiftKey]", "KeyboardChars"],
  " during startup. This will delete and rebuild the cache without rebuilding \
your front end initialization file."
}], "Text",
  CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}],

Cell[TextData[{
  "Bitmap caches are created for graphics to allow for quick retrieval of \
images. If you change the settings in ",
  StyleBox["/Applications/System Preferences/Display", "TR"],
  ", graphics may appear strange. To rerender all graphics after changing any \
setting to your monitor, select the graphics and choose ",
  StyleBox["Cell", "SR"],
  " \[RightTriangle] ",
  StyleBox["Rerender Graphics", "SR"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Standard application packages", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],

Cell["\<\
If you are unable to load any standard application packages, check \
that the packages have been installed. Make sure a backquote (`) is used in \
the leading command as in \
\>", "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],

Cell[TextData[StyleBox["<<Graphics`Graphics3D`", "MR"]], "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],

Cell["\<\
The backquote character is usually located with the ~ character on \
the upper left-hand side of the keyboard.\
\>", "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["File extensions", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],

Cell["\<\
Mac OS X can work with several different file systems, including \
HFS/HFS+ (the native Macintosh file system), Unix File System (UFS), and \
Network File System (NFS).\
\>", "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],

Cell[TextData[{
  "If you save a file on a non-HFS/HFS+ volume, you must name the file with a \
.nb extension to have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " launch when you double-click the file\[CloseCurlyQuote]s icon. On an HFS \
or HFS+ volume, the extension is optional."
}], "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Front end command-line options", "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],

Cell[TextData[{
  StyleBox["-cleanStart", "MR"],
  ". Tells the front end to ignore caches stored in the directory ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/FrontEnd/5.2 Caches, and rebuilds the front end preferences file, ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/FrontEnd/init.m."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],

Cell[TextData[{
  StyleBox["-mathLink", "MR"],
  StyleBox[". ", "Text"],
  "Causes the front end to run in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " mode. In ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " mode, the front end runs as a child process that is capable of accepting \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " packets. This option may be useful when the front end is used as a \
typesetting or graphics rendering service."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],

Cell[TextData[{
  StyleBox["-singleLaunch", "MR"],
  StyleBox[". ", "Text"],
  "Allows only one copy of the front end per display."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel command-line options", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],

Cell[TextData[{
  StyleBox["-initfile", "MR"],
  ". Lists the name of a file that contains commands that should be run on \
startup."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],

Cell[TextData[{
  StyleBox["-mathlink", "MR"],
  ". Specifies that the kernel should be run in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " mode. In ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " mode, the front end runs as a child process that is capable of accepting \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " packets. This option may be useful when the front end is used as a \
typesetting or graphics rendering service."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],

Cell[TextData[{
  StyleBox["-noinit", "MR"],
  ". Specifies that no initialization file should be read at startup."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],

Cell[TextData[{
  StyleBox["-password", "MR"],
  ". Takes one argument, which should be a valid password. The argument \
should have the form",
  StyleBox[" \[OpenCurlyDoubleQuote]machine MathID licensenumber password\
\[CloseCurlyDoubleQuote]",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],

Cell[TextData[{
  StyleBox["-pwfile", "MR"],
  ". Specifies the name of a file that has a valid password."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],

Cell[TextData[{
  StyleBox["-run", "MR"],
  ". Is followed by a command to run immediately on startup."
}], "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Fonts", "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}],

Cell[TextData[{
  "Several ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts are installed in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " bundle. After you run the front end for the first time, the fonts will be \
available to any program on your system. You do not need to know which font a \
particular character is from in order to use it; this is handled \
automatically by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Troubleshooting on Unix/Linux", "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Troubleshooting", "Installation difficulties", "Preferences: rebuilding", 
    "init.m", "Resetting to defaults", "Defaults: resetting to", 
    "Trouble with help files", "Help files: assistance with", 
    "Graphics: problems with", "Rerendering graphics", 
    "Graphics: rerendering", "Packages: problems with", 
    "Problems: with packages", "Troubleshooting_Unix", "i:45", "gs:0.22"}],

Cell[TextData[{
  "Check the Technical Support web pages at ",
  ButtonBox["support.wolfram.com",
    ButtonData:>{
      URL[ "http://support.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  " for further assistance.\n\nIf you do not find the information you need, \
please contact ",
  ButtonBox["Technical Support",
    ButtonData:>{
      URL[ "mailto:support@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ". Include your license number in all correspondence. The license number is \
located on your license certificate. It also is available after installation \
by choosing ",
  StyleBox["Help", "SB"],
  " \[RightTriangle] ",
  StyleBox["About Mathematica", "SB"],
  ".\n\nYou must be a registered customer to receive installation support. \
You must have a current ",
  StyleBox["Premier Service",
    FontSlant->"Italic"],
  " subscription to receive technical support."
}], "Highlight",
  CellTags->{"Troubleshooting_Unix", "i:45", "gs:0.22"}],

Cell[CellGroupData[{

Cell["Installation difficulties", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}],

Cell[TextData[{
  "If the installation fails or for late-breaking news, check the FAQs for \
your platform at ",
  ButtonBox["support.wolfram.com/mathematica/systems",
    ButtonData:>{
      URL[ "http://support.wolfram.com/mathematica/systems"], None},
    ButtonStyle->"Hyperlink"],
  ", as well as",
  StyleBox[" Mathematica Products System Administration Guide", "TI"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Help files", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is unable to locate information in the Help Browser, make sure that the \
documentation has been installed. By default, a minimal installation will not \
load help files."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Front end preferences", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],

Cell["\<\
Front end preferences, such as the names of recent palettes and \
style sheets or the locations of recently opened and saved files, are stored \
in  ~/.Mathematica/FrontEnd.\
\>", "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],

Cell["\<\
If you want to restore the default settings for your preferences, \
delete the init.m file from the FrontEnd directory and restart the front end. \
The init.m file will rebuild automatically.\
\>", "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],

Cell["\<\
The most convenient way to reset the front end preferences to their \
default values is to use the command\
\>", "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],

Cell[TextData[StyleBox["mathematica -cleanStart", "MR"]], "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],

Cell["\<\
This will cause the initialization file to rebuild automatically.\
\
\>", "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Caches", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],

Cell[TextData[{
  "Information about your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system layout, such as the locations of text resource files and Help \
Browser files, is stored in caches. These caches are located in \
~/.Mathematica/FrontEnd."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],

Cell[TextData[{
  "A corrupted cache may cause the front end to produce an error or quit \
immediately on startup. The most convenient way to reset the caches to their \
default values is to launch ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with the option ",
  StyleBox["-cleanStart", "MR"],
  ". This will cause the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " caches and the initialization file to rebuild automatically. "
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],

Cell[TextData[{
  "If you want to rebuild your caches but retain your preferences, hold down \
",
  StyleBox["\[ShiftKey]", "KeyboardChars"],
  " during startup. This will delete and rebuild the cache without rebuilding \
your front end initialization file."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics", "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],

Cell[TextData[{
  "Bitmap caches are created for graphics to allow for quick retrieval of \
images. If you change the display settings for your monitor, graphics in your \
notebook may appear strange. To rerender all graphics after changing any \
setting to your monitor, select the graphics and choose ",
  StyleBox["Cell", "SR"],
  " \[RightTriangle] ",
  StyleBox["Rerender Graphics", "SR"],
  "."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],

Cell["\<\
If the front end is using a private colormap, the screen will \
flicker as you move your mouse from the front end to other applications. This \
is normal.\
\>", "Text",
  CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Standard application packages", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],

Cell["\<\
If you are unable to load any standard application packages, check \
that the packages have been installed. Make sure a backquote (`) is used in \
the loading command, as in \
\>", "Text",
  CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],

Cell[TextData[StyleBox["<<Graphics`Graphics3D`", "MR"]], "Text",
  CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],

Cell["\<\
The backquote character is usually located with the ~ character on \
the upper left-hand side of the keyboard.\
\>", "Text",
  CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Crashes", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],

Cell["\<\
If the front end crashes, the kernel may be left running in the \
background. To stop the kernel:\
\>", "Text",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],

Cell["Find the process ID of the kernel.", "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],

Cell[TextData[{
  StyleBox["%", "MR"],
  " ",
  StyleBox["ps", "MR"],
  " ",
  StyleBox["-c", "MR"]
}], "ListNote",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],

Cell[TextData[{
  "Using that process ID, issue a ",
  StyleBox["kill", "MR"],
  " command."
}], "ItemizedList",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],

Cell[TextData[{
  StyleBox["%", "MR"],
  " ",
  StyleBox["kill", "MR"],
  " ",
  StyleBox["pid", "TI"]
}], "ListNote",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Keyboard settings", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],

Cell[TextData[{
  "If you are having trouble with the M",
  StyleBox["OD", "SmallCaps"],
  "1 or M",
  StyleBox["OD", "SmallCaps"],
  "2 key, go to ",
  StyleBox["Help", "SR"],
  " \[RightTriangle] ",
  StyleBox["X Environment Information", "SR"],
  " to find out which keys represent M",
  StyleBox["OD", "SmallCaps"],
  "1 and M",
  StyleBox["OD", "SmallCaps"],
  "2 and reset the key assignment."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],

Cell[TextData[{
  StyleBox["Note:", "TB"],
  " To change the M",
  StyleBox["OD", "SmallCaps"],
  "1 and M",
  StyleBox["OD", "SmallCaps"],
  "2 keys, you need to use the ",
  StyleBox["xmodmap", "MR"],
  " command."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Fonts", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}],

Cell[TextData[{
  "If you see the error message ",
  StyleBox["xset:bad", "MR"],
  " ",
  StyleBox["font", "MR"],
  " ",
  StyleBox["path", "MR"],
  " ",
  StyleBox["element", "MR"],
  ", check to see if the fonts included with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are on the font path for the server and are accessible. See ",
  StyleBox["man", "MR"],
  " ",
  StyleBox["xset", "MR"],
  " for more details on how to set up your font path."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Display errors", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],

Cell[TextData[{
  "If you see the error message ",
  StyleBox["XMathematica:", "MR"],
  " ",
  StyleBox["can\[CloseCurlyQuote]t", "MR"],
  " ",
  StyleBox["open", "MR"],
  " ",
  StyleBox["display", "MR"],
  ", you need to make sure that you have the ",
  StyleBox["DISPLAY", "MR"],
  " environment variable set correctly."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],

Cell[TextData[{
  "If you are running the front end remotely, you must give permission to the \
remote machine to display to your monitor. See ",
  ButtonBox["support.wolfram.com/mathematica/systems/unix/interface/\
remotedisplay.html",
    ButtonData:>{
      URL[ 
      "http://support.wolfram.com/mathematica/systems/unix/interface/\
remotedisplay.html"], None},
    ButtonStyle->"Hyperlink"],
  " for more information."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Window managers", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],

Cell[TextData[{
  "Some window managers use keyboard shortcuts for special commands that \
conflict with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s menu shortcuts. An example of this is ",
  StyleBox["fvwm", "TI"],
  " and ",
  StyleBox["\[ControlKey]\[LeftModified]", "KeyboardChars"],
  "\[RightArrow]",
  StyleBox["\[RightModified]", "KeyboardChars"],
  ". If this occurs, you must access the menu command with the pointer."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],

Cell[TextData[{
  "Other window managers bind keysyms when holding down either M",
  StyleBox["OD", "SmallCaps"],
  "1 or M",
  StyleBox["OD", "SmallCaps"],
  "2 and another key. In order for some front end keybindings to work \
correctly, the front end option ",
  StyleBox["-pureKeys", "MR"],
  " may need to be set. See ",
  ButtonBox["Front End Resources",
    ButtonData:>{"Troubleshooting on Unix/Linux", "FEResources_subsection"},
    ButtonStyle->"GettingStartedLink",
    ButtonNote->"page 46"],
  " for more information."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],

Cell[TextData[{
  "In some window managers, N",
  StyleBox["UM", "SmallCaps"],
  "L",
  StyleBox["OCK", "SmallCaps"],
  " turns the cursor into a hand when it passes over the window. When you \
click in the window, all you can do is drag the window."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a very complex program that makes sophisticated use of \
standards-conforming window managers. For this reason, use of prerelease \
versions of window managers may cause problems."
}], "Text",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Front end resources", "Subsubsection",
  PageBreakAbove->Automatic,
  CellTags->{
  "Troubleshooting_Unix", "FEResources_subsection", "i:55", "b:21.11", 
    "gs:0.22"}],

Cell[TextData[{
  "The standard X resources that control colors, fonts, sizes, and so on are \
supported by the X front end. For a list of such resources, see the ",
  StyleBox["X Window System User\[CloseCurlyQuote]s Guide", "TI"],
  " from O\[CloseCurlyQuote]Reilly & Associates."
}], "Text",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell["\<\
The X front end also has the following specialized resources:\
\>", \
"Text",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*applicationDepth", "MR"],
  ". Sets the color depth for the front end."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*background", "MR"],
  ". Sets the menu and dialog background colors (a standard X toolkit \
option)."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*backgroundTaskDelay", "MR"],
  ". Typically set to 200 milliseconds, this is the time the front end will \
wait for background events, such as typing, until doing tasks like PostScript \
rendering. When running the front end over a network, this number may need to \
be increased to a figure such as 300 or 400."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*cleanStart", "MR"],
  ". If specified, this tells the front end to ignore caches stored in the \
user\[CloseCurlyQuote]s home directory."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*Menu*fontlist", "MR"],
  ". Sets the fonts to be used in the menus."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*mod1KeySym", "MR"],
  ". Specifies which key will represent M",
  StyleBox["OD", "SmallText"],
  "1."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*mod2KeySym", "MR"],
  ". Specifies which key will represent M",
  StyleBox["OD", "SmallText"],
  "2."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*preferencesDirectory", "MR"],
  ". Specifies the location where preferences are stored. By default this is \
set to ~/.Mathematica."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*printCommand", "MR"],
  ". Specifies the command that will send the file to the printer, such as ",
  StyleBox["lpr", "MR"],
  " or ",
  StyleBox["lp", "MR"],
  ". This command will appear in the Print dialog box."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*pureKeys", "MR"],
  ". When set to ",
  StyleBox["True", "MR"],
  ", the front end prevents manufacturer keycodes from being modified by \
anything except the ",
  StyleBox["\[ShiftKey]", "KeyboardChars"],
  " key. For example, some systems may have ",
  StyleBox["\[ControlKey]\[LeftModified]", "KeyboardChars"],
  StyleBox["6", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  " mapped to the onequarter keysym, and this will not work with the X front \
end."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*singleLaunch", "MR"],
  ". Takes values ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["False", "MR"],
  ", and ",
  StyleBox["Query", "MR"],
  ". It allows only one copy of the front end to exist per ",
  StyleBox["DISPLAY", "MR"],
  " setting if set to ",
  StyleBox["True", "MR"],
  ", and allows multiple front ends to run if set to ",
  StyleBox["False", "MR"],
  ". Setting this resource to ",
  StyleBox["Query", "MR"],
  " will cause the front end to ask if you wish to have each file opened by a \
separate front end."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*standardColormap", "MR"],
  ". Defines what colormap should be used."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*tileWidth", "MR"],
  ". If lines appear in dithered graphics, try setting this to ",
  StyleBox["8", "MR"],
  " or ",
  StyleBox["16", "MR"],
  "."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*usePrivateColormap", "MR"],
  ". If set to ",
  StyleBox["True", "MR"],
  ", this will cause a private colormap to be established."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*useStandardColormaps", "MR"],
  ". Gives control over colormaps. If this is set to ",
  StyleBox["True", "MR"],
  ", then the front end will use a standard colormap if available. If the ",
  StyleBox["*standardColormap", "MR"],
  " resource is set, it will try to use that one first. Otherwise, for color \
visuals it searches for (in order): ",
  StyleBox["RGB_DEFAULT_MAP", "MR"],
  ", ",
  StyleBox["RGB_BEST_MAP", "MR"],
  ", and ",
  StyleBox["RGB_GRAY_MAP", "MR"],
  ". For grayscale visuals it searches for (in order): ",
  StyleBox["RGB_GRAY_MAP", "MR"],
  " and ",
  StyleBox["RGB_DEFAULT_MAP", "MR"],
  "."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*visualClass", "MR"],
  ". This should be set to one of the following: ",
  StyleBox["PseudoColor", "MR"],
  ", ",
  StyleBox["TrueColor", "MR"],
  ", ",
  StyleBox["DirectColor", "MR"],
  ", ",
  StyleBox["StaticColor", "MR"],
  ", ",
  StyleBox["StaticGray", "MR"],
  ", or ",
  StyleBox["GrayScale", "MR"],
  "."
}], "BulletedList",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],

Cell[TextData[{
  StyleBox["*visualID", "MR"],
  ". Allows the selection of a specific ",
  StyleBox["visualID", "MR"],
  " on a ",
  StyleBox["DISPLAY", "MR"],
  " connection."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Front end command-line options", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-appHelper", "MR"],
  ". Combines the options ",
  StyleBox["-querySingleLaunch", "MR"],
  " and ",
  StyleBox["-forceSaveAs", "MR"],
  ". This option is typically used when configuring ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a helper application for web browsers."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-backgroundTaskDelay", "MR"],
  ". Specifies the time the front end delays background tasks like PostScript \
rendering when waiting for input. The delay is measured in milliseconds; the \
default setting is 100."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-best", "MR"],
  ". Asks the front end to use an optimal visual, depth, and colormap \
combination."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-cleanStart", "MR"],
  ". Tells the front end to ignore caches stored in ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/FrontEnd/5.2_Caches, and rebuilds the front end preferences file, ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/FrontEnd/init.m. This option can also be abbreviated as ",
  StyleBox["-clean", "MR"],
  "."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-copyright", "MR"],
  ". Tells the front end to display copyright information from the command \
line."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-font", "MR"],
  ". Specifies the font that the front end uses in menus, buttons, and so on. \
The X program ",
  StyleBox["xfontsel", "MR"],
  " can be used to obtain a font name. The font name may be expressed as an X \
Logical Font Description or a valid font alias."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-forceSaveAs", "MR"],
  ". Forces the front end to bring up the Save dialog box when closing a file \
passed to it on the command line. This option is typically used when \
configuring ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a helper application for web browsers."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-help", "MR"],
  ". Prints a listing of all available command-line options."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-lmverbose", "MR"],
  ". Prints diagnostic information to ",
  StyleBox["stderr", "MR"],
  " on connecting to the license manager. This is useful for diagnosing \
problems related to the license server."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-mathlink", "MR"],
  ". Causes the front end to run in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " mode. In ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " mode, the front end runs as a child process that is capable of accepting \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " packets. This option may be useful when the front end is used as a \
typesetting or graphics rendering service."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-noSplashScreen", "MR"],
  ". Prevents the splash screen from being displayed on startup."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-nostderrWindow", "MR"],
  ". Tells the front end not to display ",
  StyleBox["stderr", "MR"],
  " messages in a pop-up window."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-nowatchCLIPBOARD", "MR"],
  StyleBox[". If specified, the X front end will not watch the ", "Text"],
  StyleBox["CLIPBOARD", "MR"],
  StyleBox[" property for change in ownership. The ", "Text"],
  StyleBox["CLIPBOARD", "MR"],
  StyleBox[" property allows items to be shared between X applications ", 
    "Text"],
  "via ",
  StyleBox["Copy", "SR"],
  " and ",
  StyleBox["Paste", "SR"],
  " commands.",
  StyleBox[" ", "Text"],
  "If this option is specified, you can only paste items within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "; items pasted into the ",
  StyleBox["CLIPBOARD", "MR"],
  " from other applications are ignored."
}], "BulletedList",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-preferencesDirectory", "MR"],
  ". Allows you to specify the location where preferences are stored. By \
default this is set to ~/.Mathematica."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-primaryModifierMask", "MR"],
  ". Specifies the modifier mask to use as the command key. The default is \
Mod1Mask."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-printCommand", "MR"],
  ". Takes one argument that should be a command that sends the file to the \
printer, such as ",
  StyleBox["lpr", "MR"],
  " or ",
  StyleBox["lp", "MR"],
  ". This command appears in the Print dialog box. If the -",
  StyleBox["printCommand", "MR"],
  " option has been used before and it is used again without first clearing \
the \[OpenCurlyDoubleQuote]Print To\[CloseCurlyDoubleQuote] field in the \
Print dialog box, the option will not work. If ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is started with the -",
  StyleBox["cleanStart", "MR"],
  " option, the -",
  StyleBox["printCommand", "MR"],
  " option will work again."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-pureKeys", "MR"],
  ". Disables keybindings involving modifier keys that are defined by the \
operating system. This option may need to be given in order for some front \
end keyboard commands to work correctly. For example, some systems may \
reserve ",
  StyleBox["\[ControlKey]\[LeftModified]", "KeyboardChars"],
  "6",
  StyleBox["\[RightModified]", "KeyboardChars"],
  " for internal use and then the front end cannot use this to typeset \
superscripts. Keybindings involving the ",
  StyleBox["\[ShiftKey]", "KeyboardChars"],
  " key are not disabled by this option."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-pwfile", "MR"],
  ". Tells the front end to get its password from the specified file."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-querySingleLaunch", "MR"],
  ". Brings up a dialog box to ask the user if a file specified on the \
command line should be opened in the currently running front end. The dialog \
box appears only if the current front end was also launched with the -",
  StyleBox["querySingleLaunch", "MR"],
  " option."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-screenXResolution", "MR"],
  ". Specifies the horizontal screen resolution of the notebook display in \
dots per inch. For example, if the default screen resolution is 75 dpi, \
setting the option to 150 causes the contents of the notebook window to scale \
horizontally by a factor of two."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-screenYResolution", "MR"],
  ". Specifies the vertical screen resolution of the notebook display in dots \
per inch. For example, if the default screen resolution is 75 dpi, setting \
the option to 150 causes the contents of the notebook window to scale \
vertically by a factor of two."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-secondaryModifierMask", "MR"],
  ". Gives the modifier mask to use as the option key. The default is \
Mod2Mask."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-singleLaunch", "MR"],
  ". Allows only one copy of the front end to exist per display. Multiple \
launches are prevented only if the currently running front end was launched \
with the -",
  StyleBox["singleLaunch", "MR"],
  " or -",
  StyleBox["querySingleLaunch", "MR"],
  " option."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-topDirectory", "MR"],
  ". Specifies the directory where ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is installed, typically /",
  StyleBox["usr", "TI",
    FontSlant->"Plain"],
  "/local/Wolfram/Mathematica/5.2."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-version", "MR"],
  ". Prints the version number of the front end from the command line."
}], "BulletedList",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-visualChooser", "MR"],
  ". Starts the front end by first putting up the Visual Chooser. This is a \
dialog box that allows you to specify system parameters such as visual ID, \
depth, and colormap."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-watchCLIPBOARD", "MR"],
  ". Tells the front end to watch the ",
  StyleBox["CLIPBOARD", "MR"],
  " property for a change in ownership. This is the default. The ",
  StyleBox["CLIPBOARD", "MR"],
  " property allows items to be shared between X applications. If this option \
is set, then you can paste items into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from other applications."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-wwwBrowser", "MR"],
  ". Specifies a command to open URL links from the front end. The command \
can include a ",
  StyleBox["%s", "MR"],
  " format argument that is replaced with the URL."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel command-line options", "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-initfile", "MR"],
  ". Lists the name of a file that contains commands that should be run on \
startup."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-mathlink", "MR"],
  ". Specifies that the kernel should be run in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " mode."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-noinit", "MR"],
  ". Specifies that no initialization file should be read at startup."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-password", "MR"],
  ". Takes one argument, which should be a valid password. The argument \
should have the form",
  StyleBox[" \[OpenCurlyDoubleQuote]machine MathID licensenumber password\
\[CloseCurlyDoubleQuote]", "TI"],
  "."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-pwfile", "MR"],
  ". Specifies the name of a file that has a valid password."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],

Cell[TextData[{
  StyleBox["-run", "MR"],
  ". Followed by a command to run immediately on startup."
}], "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Upgrading from Version 4 and Earlier", "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Updating over Version 2", "Installing over Version 2", 
    "Previous versions: installing over", "Notebook format: from Version 2", 
    "Converting notebooks: to Version 3", "Kernels: from earlier versions", 
    "NotebookConvert", "Converting notebooks: via kernel", "updating", "i:58",
     "gs:0.23"}],

Cell[CellGroupData[{

Cell["Installation", "Subsubsection",
  CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}],

Cell["\<\
By default, Version 5 is installed in a separate directory and not \
over earlier versions. The files used to save default settings are also \
separate and will not overwrite any previous preferences files. You must use \
a new password for Version 5. \
\>", "Text",
  CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Remote kernels ", "Subsubsection",
  CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}],

Cell["\<\
Version 5.2 supports remote kernel connections to kernels from \
Version 5.0 or later. \
\>", "Text",
  CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Using the Applications Library with Version 5", "Subsubsection",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],

Cell[TextData[{
  "The performance of application packages written for earlier versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " may be affected by changes made to some functions in Version 5. However, \
most ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications from the Applications Library will run normally. Visit ",
  ButtonBox["www.wolfram.com/products",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products"], None},
    ButtonStyle->"Hyperlink"],
  " for more information about individual application packages or see \
Appendix ",
  ButtonBox["A.13",
    ButtonData:>{"A.13", None},
    Active->True,
    ButtonStyle->"MainBookLink"],
  " in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  " for a list of incompatibilities."
}], "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],

Cell["\<\
Application packages need to be copied into a specific directory, \
based on whether you have administrative privileges:\
\>", "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],

Cell[TextData[{
  StyleBox["Administrator:", "TB"],
  " ",
  StyleBox["$BaseDirectory", "MR"],
  "/Applications"
}], "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],

Cell[TextData[{
  StyleBox["Nonadministrator:", "TB"],
  " ",
  StyleBox["$UserBaseDirectory", "MR"],
  "/Applications"
}], "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],

Cell["\<\
You can use the same command from an earlier version to load the \
package. If Version 2 notebooks are included in the package, you can convert \
them simply by opening them in Version 5.\
\>", "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebooks in Version 5", "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],

Cell[TextData[{
  "Notebooks created before Version 3 in 1996 carry the .ma file extension \
and have a different structure than notebooks created in Version 3 and later. \
A notebook is now a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression stored in a platform-independent file with the extension .nb. \
All the information necessary to open the notebook is stored in the .nb \
file."
}], "Text",
  CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],

Cell[TextData[{
  "When you open a notebook that was created with Version 2.2 or earlier in \
Version 5, a dialog box will appear that allows you to convert your notebook \
automatically. You have the option of converting input and output cells into \
",
  StyleBox["StandardForm", "MR"],
  " cells, which will automatically typeset characters and formulas."
}], "Text",
  CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}]
}, Closed]],

Cell[CellGroupData[{

Cell["NotebookConvert", "Subsubsection",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],

Cell[TextData[{
  "You can also use the kernel function ",
  StyleBox["NotebookConvert", "MR"],
  " to convert notebooks to the newer format. ",
  StyleBox["NotebookConvert", "MR"],
  " is useful for converting a large number of notebooks without opening them \
individually in the front end."
}], "Text",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],

Cell[CellGroupData[{

Cell[BoxData[
    ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000f00003B000`400?l00000o`00003o=_lH61P0
0003oaPH6?nGD53oUe1@03;oUe1@0OlH61P00003oaPH6?nGD53oUe1@03;oUe1@0OlH61P0000:oaPH
6?nGD53oUe1@oiM@D?ncOgooj]cLomc5aOooooooUe1@ooooo`;oUe1@00?ooooooiM@D?ooool00_nG
D5001?nNG5coooooojacLoooool3oiM@D00;oooooonGD53oUe1@oooooonGD53ooooooiM@D?ncOgoo
hm3@on[Lg?o8XZ804_nGD501oaPH600001Go61PHoiM@D?nGD53oUe1@oo7Xj?nNG5coUe1@oooooonG
D53ooooooiM@D?n/Lg?ohm3@oiM@D?oSd=3oj]cLomc5aOoZg=cog<G5ojacLoooool00onGD5002?oo
ooooUe1@oiM@D?ooooooUe1@oooooonGD53ohm3@0_nNG5`00ooaj>SoUe1@oiM@D007oiM@D0;oWU]K
1onGD501oaPH600001Co61PHoiM@D?nGD53oUe1@oooooonGD53ocZf]oooooonGD53ooooooiM@D?o8
XZ;og<G5oiM@D?o8XZ;ohm3@oiM@D?oooooo/gmoojacL`;ooooo00?ocZf]oiM@D?ooool00_nGD500
1OooooooUe1@oooooonGD53ooooo00_oUe1@00CoWU]KoncOgoo/gmooWU]K1_nGD501oaPH600000Go
61PHoiM@D?nGD53oUe1@ooooo`04oiM@D00@oooooooLaLGolNSXol6FU_nGD53oWUaLoooooonGD53o
oooooiM@D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;og<G500GooooooiM@D?ooooooUe1@ooooo`0:
oiM@D006oiiKFoo/gmooooooooooooo/gmooWU]K1OnGD501oaPH600000Go61PHoiM@D?nGD53oUe1@
ooooo`02oiM@D006ok=oOonGD53ooooooiM@D?nNG5coj]cL0_nGD5002_oooooo/gmoon[Lg?nGD53o
[7=coooooonGD53oooooojacLoooool2oiM@D005oooooonGD53ooooooiM@D?ooool02OnGD5000onN
Fe_ok=oOooooo`03ooooo`03oncOgonNFe_oUe1@00?oUe1@0OlH61P0000=oaPH6?nGD53oUe1@oiM@
D?oZg=co[7=coiM@D?ooooooUe1@oooooonGD53oWUaLooooo`02oiM@D00:omFi^OoZg=cocZf]oiM@
D?n/Lg?ooooooiiLG?ooooooWUaLooooo`;oUe1@00SooooooiM@D?ooooooUe1@on[Lg?nNG5coUe1@
on?@d0GoUe1@00?oWU]KoncOgoooool01Oooool00oo/gmooWU]KoiM@D002oiM@D07o61PH00003OlH
61SoUe1@oiM@D?nGD53o/gmooo7Xj?oSd=3og<G5oiM@D?oooooog<G5oo7Xj?o8XZ800_nGD5001Onc
OgoooooooiiLG?nGD53o[7=c00;ooooo00?ocZf]oiM@D?ooool00_nGD5002?ooooooUe1@oooooonG
D53o/gmoon[Lg?oaj>Sob::R1OnGD5000oo/gmooooooooooo`06ooooo`04oncOgonGD53oUe1@oiM@
D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH00000olH61SoUe1@oiM@D00boiM@D07o61PH
000foaPH6000\
\>"], "PictureGroup",
        ImageSize->{54, 13},
        ImageMargins->{{0, 0}, {0, 0}},
        ImageRegion->{{0, 1}, {0, 1}}],
      ButtonFunction:>(FrontEndExecute[ {
          FrontEnd`SelectionMove[ 
            FrontEnd`SelectedNotebook[ ], All, ButtonCell], 
          FrontEndToken[ "OpenCloseGroup"]}]&),
      Active->True,
      ButtonFrame->"None"]], "OpenCloseItemizedPicture",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007_0001MB000`400?l00000o`00003ooomVIWk`
ofIVOP0000?oIVInoo_loOoko?d0oooko?g/oo_lo@7oIVIn00000omVIWkonocmojRY^`3oofIVO^[o
IVIn0OnXZK/1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn
00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3o
on3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_l
o@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocm
ofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmV
IWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omV
IWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[o
h=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn
00000omVIWkonocmofIVOP3con3Oh`05on7Pi?oViNSok>_^oo3`l_obl_@08?oclo@OooSgn0;olo?d
00Golo?eooCdmOoemOKom??eonGTj005on3Oh`05on7Pi?oViNSok>_^oo3`l_obl_@08?oclo@OooSg
n0;olo?d00Golo?eooCdmOoemOKom??eonGTj006on3Oh`05on7Pi?oViNSok>_^oo3`l_obl_@08?oc
lo@OooSgn0;olo?d00Golo?eooCdmOoemOKom??eonGTj00:on3Oh`7oIVIn0Ooko?d1ofIVOP0000?o
IVInoo_loOmVIWh0looPgn<01?oMg=ooi>;Pog^G[?lUEXA3o`0lM004oaI=O_m[RjGolO7]oo;al`Go
h=oS00CogMcOonCRh?mkUjco9EJ4@ol0?7@01?lFCGkoJh^Uoo7akOoblO<6on3Oh`04omgLgooTh^3o
NiN/obEFQ4?o03ad00Co5Tenof^;YOoalNgol_7c2_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_ok
o?goIVIn0??oh=oS00Cof]SIofF5XOlWCHGoCGg1A?mYP^h00olWCHGoJHZSono_l@05on3Oh`04om[H
fOmUQJ7oBW6Cok:m`d?oa/GG00Co`<K5odQ^T?mYRZ?oknoa1_oPgn<01?oJf=WoIHFQodYaTonb_L=3
olK5e`04ol36aOm8KY3oJHZSono_l@[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3c
on3Oh`03omSEe_lFCGkoRJgT04KoRJgT00?o5Tenon_ZkOoPgn<01?oPgn<00ooHeMKo5Tenoko7bP15
olK5e`03okJm_OlFCGkojn[]00Koh=oS00?of=GFoaI=O_noalX0AOo6aML00onf_Kgo5Tenon_Zk@0:
on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0looPgn<01?oHeMGo03adohV]i?oooom3
olg<g`04oooooon9[NCo03adonSWjPGoh=oS00?of=GEo`0lM?ooool0AOo=c=l00ooooooo03adonSW
jP06on3Oh`03omSEeOl0?7Cooooo04GocLcO00?oooooo`0lM?oXinX02_oPgn<1ofIVOP7onocm0OmV
IWh00003ofIVO_oko?goIVIn0??oh=oS00Cof=GEo`0lM?n;[NCooooo@ooBdN@01?ooooooRjoUo`0l
M?oWi^T5on3Oh`03omSEeOl0?7Cooooo04God]7T00?oooooo`0lM?oWi^T01_oPgn<00ooHeMGo03ad
ooooo`0Xom;Ai003o`000?oBdNCod]7T01[od]7T00?oooooo`0lM?oWi^T02_oPgn<1ofIVOP7onocm
0OmVIWh00003ofIVO_oko?goIVIn0??oh=oS00Cof=GEo`0lM?n>[nKooooo@ooFenL01?ooooooSJoU
o`0lM?oWi^T5on3Oh`03omSEeOl0?7Cooooo04Goe]OW00?oooooo`0lM?oWi^T01_oPgn<00ooHeMGo
03adooooo`0XomKGi`03o`000?oFenOoe]OW01[oe]OW00?oooooo`0lM?oWi^T02_oPgn<1ofIVOP7o
nocm0OmVIWh00003ofIVO_oko?goIVIn0??oh=oS00Cof=GEo`0lM?nA/NOooooo4OoIf^L4o`0000?o
fM[W0ol00002omWJi`05o`000?oIf^OofM[WomWJiol000000ooIf^L00ol0003ofM[WomWJi`02omWJ
i`?o00000_oIf^L01Ol0003ofM[WomWJiooIf^Oo000000oofM[W00Cooooooi6ai_l0?7CoinKY1OoP
gn<00ooHeMGo03adooooo`0DomWJi`Co00000ooIf^L4o`000003omWJiol0003ofM[W00;ofM[W00?o
0000omWJiooIf^L00ol00003omWJi`?o00000_oIf^L00ol0003ofM[WomWJi`0@omWJi`03ooooool0
?7CoinKY00Koh=oS00?of=GEo`0lM?ooool06?oIf^L00ol0003ofM[WomWJi`02omWJi`04o`000?oI
f^OofM[WomWJi`?o00000_oIf^L00ol0003ofM[Wo`000003o`0001WofM[W00?oooooo`0lM?oWi^T0
2_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0??oh=oS00Cof=GEo`0lM?nD]>Sooooo
4?oIf^L00ol0003ofM[WomWJi`02omWJi`03o`000?oIf^Oo000000?ofM[W00?o0000omWJiol00000
0ooIf^L01Ol0003ofM[WomWJiooIf^Oo000000?ofM[W00Oo0000omWJiooIf^OofM[Wo`000?oIf^Oo
000000;ofM[W00?o0000omWJiooIf^L03_oIf^L01?ooooooUKCXo`0lM?oWi^T5on3Oh`03omSEeOl0
?7Cooooo01?ofM[W00?o0000omWJiooIf^L00_oIf^L00ol0003ofM[Wo`000003omWJi`03o`000?oI
f^Oo000000?ofM[W00?o0000omWJiol000000ooIf^L00ol0003ofM[Wo`000003omWJi`03o`000?oI
f^Oo000001;ofM[W00?oooooo`0lM?oWi^T01_oPgn<00ooHeMGo03adooooo`0HomWJi`03o`000?oI
f^OofM[W00;ofM[W00Co0000omWJiooIf^Oo00000ooIf^L01Ol0003ofM[Wo`000?oIf^Oo000000?o
fM[W00?o0000omWJiooIf^L05_oIf^L00ooooooo03adonOVj@0:on3Oh`7oIVIn0Ooko?d1ofIVOP00
00?oIVInoo_loOmVIWh0looPgn<01?oHeMGo03adoiRhj_ooool@omkOk003o`000?oNgncog]o/00Co
g]o/00Oo0000omkOk?oNgncog]o/o`000?oNgnco000000?og]o/00Ko0000omkOk?oNgnco0000omkO
k?l00002omkOk003o`000?oNgncog]o/00?og]o/00Co0000omkOk?oNgnco00004?oNgn`01?oooooo
V;SYo`0lM?oWi^T5on3Oh`03omSEeOl0?7Cooooo01?og]o/00?o0000omkOk?oNgn`01?oNgn`01ol0
003og]o/omkOk?oNgnco0000omkOk?l000000ooNgn`00ol0003og]o/o`000005omkOk003o`000?oN
gncog]o/00?og]o/00?o0000omkOk?oNgn`04?oNgn`00ooooooo03adonOVj@06on3Oh`03omSEeOl0
?7Cooooo01Sog]o/00?o0000omkOk?oNgn`00_oNgn`01?l0003og]o/omkOk?l00005omkOk003o`00
0?oNgnco000000?og]o/00?o0000omkOk?oNgn`05_oNgn`00ooooooo03adonOVj@0:on3Oh`7oIVIn
0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0looPgn<01?oHeMGo03adoibkj_ooool@on?Ul003o`00
0?oSiO3ohnG`00CohnG`00Oo0000on?Ul?oSiO3ohnG`o`000?oSiO3o000000?ohnG`00Ko0000on?U
l?oSiO3o0000on?Ul?l00002on?Ul0Go000000GohnG`o`000?oSiO3ohnG`o`00000@on?Ul004oooo
oonL^n_o03adonOVj@Goh=oS00?of=GEo`0lM?ooool04ooSiO000ol0003ohnG`on?Ul005on?Ul0Co
000000?ohnG`o`000?oSiO000_oSiO000ol0003ohnG`o`000005on?Ul0Go000000?ohnG`o`000?oS
iO004OoSiO000ooooooo03adonOVj@06on3Oh`03omSEeOl0?7Cooooo01SohnG`00?o0000on?Ul?oS
iO000_oSiO000ol0003ohnG`on?Ul005o`000004on?Ul?l0003ohnG`o`0000?ohnG`00?o0000on?U
l?oSiO005_oSiO000ooooooo03adonOVj@0:on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmV
IWh0looPgn<01?oHeMGo03adoj2nk?ooool@onW[m@03o`000?oYjoGojN_e00CojN_e00Ko0000onW[
mOoYjoGojN_eo`000?oYjoD2o`0000;ojN_e00?o0000onW[mOl000000ooYjoD00ol0003ojN_eo`00
0003onW[m@03o`000?oYjoGo000000;ojN_e00?o0000onW[mOoYjoD03_oYjoD01?ooooooXKk/o`0l
M?oWi^T5on3Oh`03omSEeOl0?7Cooooo01?ojN_e00?o0000onW[mOoYjoD02?oYjoD01?l0003ojN_e
o`000?l00002onW[m@03o`000?oYjoGo000000?ojN_e00?o0000onW[mOl000000ooYjoD00ol0003o
jN_eo`00000BonW[m@03ooooool0?7CoinKY00Koh=oS00?of=GEo`0lM?ooool06?oYjoD6o`0000;o
jN_e00Wo0000onW[mOoYjoGojN_eo`000?oYjoGo0000onW[mOl000000ooYjoD00ol0003ojN_eonW[
m@0FonW[m@03ooooool0?7CoinKY00[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3c
on3Oh`04omSEeOl0?7CoYL7]oooooa3ol?7l00?o0000oo3ao?o`lO`01Oo`lO`3o`0000;ol?7l00Co
0000oo3ao?l0003o00000_o`lO`01Ol0003ol?7loo3ao?o`lOco000000;ol?7l0ol00002oo3ao0;o
000000?ol?7lo`000?l000003oo`lO`01?ooooooYL;^o`0lM?oWi^T5on3Oh`03omSEeOl0?7Cooooo
01?ol?7l00?o0000oo3ao?o`lO`01Oo`lO`3o`0000;ol?7l00Co0000oo3ao?l0003o00000oo`lO`3
o`0000?ol?7l0ol00002oo3ao003o`000?o`lOcol?7l013ol?7l00?oooooo`0lM?oWi^T01_oPgn<0
0ooHeMGo03adooooo`0Hoo3ao003o`000?o`lOcol?7l00;ol?7l00Co0000oo3ao?o`lOcol?7l0ol0
0002oo3ao003o`000?o`lOco000000?o00006Oo`lO`00ooooooo03adonOVj@0:on3Oh`7oIVIn0Ook
o?d1ofIVOP0000?oIVInoo_loOmVIWh0looPgn<01?oHeMGo03adojW5koooool@ooCeo@03o`000?od
mOgom?Gm01oom?Gm00?o0000ooCeoOodmOd03_odmOd01?ooooooZLG_o`0lM?oWi^T5on3Oh`03omSE
eOl0?7Cooooo01?om?Gm00?o0000ooCeoOodmOd07?odmOd00ol0003om?GmooCeo@0@ooCeo@03oooo
ool0?7CoinKY00Koh=oS00?of=GEo`0lM?ooool06?odmOd00ol0003om?GmooCeo@02ooCeo@03o`00
0?odmOgom?Gm00Kom?Gm00?o0000ooCeoOodmOd07?odmOd00ooooooo03adonOVj@0:on3Oh`7oIVIn
0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0looPgn<01?oHeMGo03adojg8l?ooool@ooKgo@03o`00
0?ofmogom_Om00;om_Om00?o0000ooKgoOofmod06_ofmod00ol0003om_OmooKgo@0>ooKgo@04oooo
oon/ao3o03adonOVj@Goh=oS00?of=GEo`0lM?ooool04oofmod00ol0003om_OmooKgo@02ooKgo@03
o`000?ofmogom_Om01Oom_Om00?o0000ooKgoOofmod04?ofmod00ooooooo03adonOVj@06on3Oh`03
omSEeOl0?7Cooooo01Som_Om00?o0000ooKgoOofmod00_ofmod00ol0003om_OmooKgo@06ooKgo@03
o`000?ofmogom_Om01com_Om00?oooooo`0lM?oWi^T02_oPgn<1ofIVOP7onocm0OmVIWh00003ofIV
O_oko?goIVIn0??oh=oS00Cof=GEo`0lM?nabo;ooooo4Ooho?d4o`0002kon?cm00Cooooook7<l_l0
?7CoinKY1OoPgn<00ooHeMGo03adooooo`0DooSlo@Co00006_oho?d00ol0003on?cmooSlo@0@ooSl
o@03ooooool0?7CoinKY00Koh=oS00?of=GEo`0lM?ooool06?oho?d00ol0003on?cmooSlo@02ooSl
o@03o`000?oho?gon?cm00Kon?cm00?o0000ooSloOoho?d07?oho?d00ooooooo03adonOVj@0:on3O
h`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0looPgn<01?oHeMGo03adokC=looooom3oogm
o@04oooooonec_?o03adonOVj@Goh=oS00?of=GEo`0lM?ooool0AOomoOd00ooooooo03adonOVj@06
on3Oh`03omSEeOl0?7Cooooo04GooOgm00?oooooo`0lM?oWi^T02_oPgn<1ofIVOP7onocm0OmVIWh0
0003ofIVO_oko?goIVIn0??oh=oS00Cof=GEo`0lM?ngd?Cooooo@oomoOd01?oooooo^=3eo`0lM?oV
i^T5on3Oh`03omSEeOl0?7Cooooo04GooOgm00?oooooo`0lM?oVi^T01_oPgn<00ooHeMGo03adoooo
o`15oogmo@03ooooool0?7Coi^KY00[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3c
on3Oh`04omODdol0?7Co^]?eoooood?ooOgm00Cooooook[Cm_l0?7CoiNGX1OoPgn<00ooGe=?o03ad
ooooo`15oogmo@03ooooool0?7CoiNGX00Koh=oS00?oemCCo`0lM?ooool0AOomoOd00ooooooo03ad
onGUj00:on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0looPgn<00ooHeMGo9EJ4okcD
mP16okcDmP03obEFQ?oQhNCoh=oS00Coh=oS00?of=GEobEFQ?noc]`0AOooool00onoc]_o9EJ4on7Q
i006on3Oh`03omSEeOlUEXCo_lkL04Gooooo00?o_lkKobEFQ?oQhN@02_oPgn<1ofIVOP7onocm0OmV
IWh00003ofIVO_oko?goIVIn0??oh=oS00?of=GEogRDZOlWCHD0AOo>iol00olWCHGoNIBZomkMh005
on3Oh`04omSEeOmhU:WoEGfRol3?gD?ooooo00CoeMoXoeEmX_miU:[og]gP1_oPgn<01?oHeMGoN9BY
oeEmX_o0cme3ooooo`04omGOj?mEOJ;oNIBZomkMh0[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWko
nocmofIVOP3con3Oh`04omWFf?oOfmOoN9BYobEFQ4?o03ad00Co5TenofJ6XOoPg]Wog=_L1OoPgn<0
1?oIe]Sogm_GogRDZOlUEXA3o`0lM004oaI=O_mVQZ7oh=kIomcKg0Koh=oS00CofMKHomoKeomhU:Wo
9EJ4@ol0?7@01?lFCGkoIXJQon3NfOoLfm`:on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmV
IWh0looPgn<00ooNgN3ofMKHomODd`0RomKCdaood/k;0ooFdm<01?oGe=?of=GEomWFf?oNgN05on3O
h`03omkMh?oIe]SoemCC02;oe]?C7ooBc//3omKCd`04omODdooHeMGofMKHomkMh0Koh=oS00?og]gP
omWFf?oGe=<08_oFdm<Oom;>b`?oe]?C00CoemCComSEeOoIe]Sog]gP2_oPgn<1ofIVOP7onocm0OmV
IWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn
0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7o
nocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_ok
o?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1
ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003
ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oS
j_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmV
IWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn
0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7o
nocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_ok
o?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1
ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003
ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oS
j_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmV
IWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn
05Soh=oS0_l0003oon3Ohi3oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP1Jon3Oh`03
o`000?oPgn?oh=oS01koh=oS00?o0000on3OhooPgn<04OoPgn<01oo;d=WoUjZmoeAjW?lSEX?oE7ZL
oiNZ_Oo;d=T0K?oPgn<01oo;d=WoUjZmoeAjW?lSEX?oE7ZLoiNZ_Oo;d=T0A?oPgn<01oo;d=WoUjZm
oeAjW?lSEX?oE7ZLoiNZ_Oo;d=T05_oPgn<00ol0003oh=oSon3Oh`1lon3Oh`7oIVIn0Ooko?d1ofIV
OP0000?oIVInoo_loOmVIWh03?oPgn<01?l0003oh=oSon3Ohol00005on3Oh`05o`000?oPgn?oh=oS
on3Ohol000000_oPgn<3o`0000?oh=oS00Go0000on3OhooPgn?oh=oSo`000005on3Oh`06o`000?oP
gn?oh=oSo`000?oPgn?o00000_oPgn<3o`0000Koh=oS1?l000001?oPgn?o0000on3Ohol00003on3O
h`?o00000ooPgn<4o`0000;oh=oS1?l00002on3Oh`03o`000?oPgn?oh=oS00Goh=oS0ol00002on3O
h`06o`000?oPgn?oh=oSo`000?oPgn?o00000_oPgn<2o`0000?oh=oS00?o0000on3OhooPgn<00_l0
0003on3Oh`03o`000?oPgn?oh=oS00koh=oS00_og]gRojFeaOlPE87oKY2]ok[9e_ocmOKo_<_Iog2A
[olPE87oYKG5omkMhP1Xon3Oh`0;omkMh_nU]LGo85B1ofj?[?nib=Gol_Ceokc;f?m`TJoo85B1ojFe
aOoNgN80@?oPgn<02ooNgN;oYKG5ob1DPOm^Sjco^LSEoo;dmOnlbmSoL96_ob1DPOnU]LGog]gR01Co
h=oS00?o0000on3OhooPgn<0O?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00coh=oS
00Co0000on3OhooPgn?o00001OoPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<0
1?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?oh=oS00?oh=oS00So0000on3OhooPgn?o0000
on3Ohol0003oh=oSo`0000?oh=oS00?o0000on3OhooPgn<00_oPgn<02Ol0003oh=oSon3OhooPgn?o
0000on3Ohol0003oh=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3O
h`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_l00005on3Oh`07o`000?oPgn?oh=oS
on3Ohol0003oh=oSo`000002on3Oh`05o`000?oPgn?o0000on3Ohol000000_oPgn<00ol0003oh=oS
o`000002on3Oh`04o`000?oPgn?oh=oSo`0001?oh=oS00_oYKG5oeb1X_nfaM;omoOfooWin?ojn_Wo
o?ckoogmoOnlc=WoH8FVojFea@04on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<0
0_l00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000001?oPgn<01?l0003oh=oSon3OhooPgn<3o`00
00;oh=oS00?o0000on3OhooPgn<00ooPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS0ol00003
on3Oh`05o`000?oPgn?oh=oSon3Ohol000001OoPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS
1?l000001OoPgn?o0000on3OhooPgn?o000000;oh=oS00?o0000on3OhooPgn<00ol0000@on3Oh`0;
ojFeaOmKPJ7o]LC@ooGem?ogmoKonOWhoo_kn_omoOco_<cIof25Y_nU]LD01_oPgn<4o`0000Goh=oS
00?o0000on3OhooPgn<00_oPgn<3o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`04
o`000?oPgn?oh=oSo`0000;oh=oS00Co0000on3OhooPgn?o00000_oPgn<3o`00013oh=oS00_oYKG5
oe^1XOnea=3omOGdooOgm_oinOSono_joogmo?nlc=WoH8FVojFea@06on3Oh`?o00000ooPgn<02?l0
003oh=oSon3OhooPgn?o0000on3Ohol0003oh=oS1?l0001kon3Oh`7oIVIn0Ooko?d1ofIVOP0000?o
IVInoo_loOmVIWh03?oPgn<01?l0003oh=oSon3Ohol00005on3Oh`07o`000?oPgn?oh=oSon3Ohol0
003oh=oSo`000005on3Oh`07o`000?oPgn?o0000on3Ohol0003oh=oSo`000004on3Oh`08o`000?oP
gn?oh=oSo`000?oPgn?o0000on3Ohol00008on3Oh`09o`000?oPgn?oh=oSon3Ohol0003oh=oSo`00
0?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00ooPgn<01ol0003oh=oSon3OhooPgn?o0000on3O
hol000000ooPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3O
hooPgn<01?oPgn<2o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`03o`000?oPgn?o
h=oS00;oh=oS00?o0000on3OhooPgn<04OoPgn<03Oo;d=Wo85B1ok?3cooclo7omOGcooOgm_oinOSo
n_[iooclnoomoOgo_<cIob1DPOo;d=T00ooPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?o
000000;oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`04o`000?oPgn?o
h=oSo`0000?oh=oS00?o0000on3Ohol000001OoPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol0
00000ooPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Oo0000on3O
hooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01_l0003oh=oSon3O
hol0003oh=oSo`0000?oh=oS00?o0000on3OhooPgn<03?oPgn<03Oo;d=Wo85B1ok;1cOoalNoolo?a
ooGem?ogmoKonOWhoo_kn_omoOco_<cIob1DPOo;d=T01?oPgn<00ol0003oh=oSon3Oh`02on3Oh`03
o`000?oPgn?oh=oS00;oh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`03o`000?oPgn?o0000
00?oh=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o0000
0_oPgn<01Ol0003oh=oSon3OhooPgn?o000000koh=oS00gobm3Iob1DPOnb`LgolO7_oo?clOoemOCo
moOfooWin?okno[ooOglokc<fOlPE87obm3I00Coh=oS00Go0000on3OhooPgn?oh=oSo`000002on3O
h`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`1h
on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<01?l0003oh=oSon3Ohol00005
on3Oh`06o`000?oPgn?oh=oSon3Ohol0003oh=oS1Ol000002?oPgn?o0000on3Ohol0003oh=oSo`00
0?oPgn?o00001?oPgn<01ol0003oh=oSon3Ohol0003oh=oSo`000?oPgn<01Ol00005on3Oh`Co0000
00Coh=oSo`000?oPgn?o00000_oPgn<5o`0000;oh=oS1?l000000ooPgn?o0000on3Oh`02on3Oh`03
o`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00_oPgn<5o`0000;oh=oS0_l00002on3Oh`04
o`000?oPgn?oh=oSo`0000?oh=oS00Go0000on3OhooPgn?oh=oSo`00000Don3Oh`0=oiNZ_OmYRjOo
kno/oo7akooXk^KoV/bHobBF9?nHbIOok_?]ooclnoomoOgoL96_oiNZ_@04on3Oh`Go00001?oPgn<0
1_l0003oh=oSon3Ohol0003oh=oSo`0000Koh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003o
h=oSo`000005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000005on3Oh`07o`000?oPgn?o
0000on3Ohol0003oh=oSo`000004on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3O
h`03o`000?oPgn?o000000;oh=oS00Ko0000on3OhooPgn?o0000on3Ohol0000Bon3Oh`0=oiNZ_OmX
RJKok>cYono_k?oalNoolo?aooGem?ogmoKonOWhoo_kn_omoOcoL96_oiNZ_@04on3Oh`03o`000?oP
gn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS00?o0000on3OhooP
gn<00ooPgn<03?l0003oh=oSon3Ohol0003oh=oSo`000?oPgn?o0000on3Ohol0003oh=oSo`0000;o
h=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`0@on3Oh`0=oiNZ_OmXRJKok>cYono_
k?oalNoolo?aooGem?ogmoKonOWhoo_kn_omoOcoL96_oiNZ_@08on3Oh`06o`000?oPgn?oh=oSo`00
0?oPgn?o00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS07Soh=oS0OmVIWh1
oo_lo@7oIVIn00000omVIWkonocmofIVOP0<on3Oh`04o`000?oPgn?oh=oSo`0000Goh=oS0_l00002
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol0
0004on3Oh`08o`000?oPgn?oh=oSo`000?oPgn?o0000on3Ohol00003on3Oh`03o`000?oPgn?oh=oS
00Koh=oS00Go0000on3Ohol0003oh=oSo`000002on3Oh`05o`000?oPgn?oh=oSon3Ohol000001OoP
gn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00_oP
gn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000_oPgn<01Ol0003oh=oSo`000?oPgn?o0000
00;oh=oS00?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol0000Bon3Oh`0=oeAjW?n^_/So
k>cYono_k?nPdYko:ZPWob:R8?lCTQ3oV<RGoo[jnOolo?_o_<_IoeAjW004on3Oh`05o`000?oPgn?o
h=oSon3Ohol000000ooPgn<01?l0003oh=oSon3OhooPgn<2o`0000Ooh=oS00Co0000on3OhooPgn?o
00000ooPgn<00ol0003oh=oSo`000005on3Oh`06o`000?oPgn?oh=oSon3Ohol0003oh=oS1Ol00000
2?oPgn?o0000on3Ohol0003oh=oSo`000?oPgn?o00001?oPgn<01Ol0003oh=oSon3OhooPgn?o0000
00;oh=oS1?l000001OoPgn?o0000on3OhooPgn?o000000;oh=oS00?o0000on3Ohol000001?l0000>
on3Oh`0=oeAjW?n[^/Koj>SUonc/jOo_kncolO7_oo?clOoemOComoOfooWin?okno[o_<_HoeAjW004
on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS
1Ol000003OoPgn?o0000on3OhooPgn?o0000on3Ohol0003oh=oSo`000?oPgn?o0000on3Ohol00000
0_oPgn<00ol0003oh=oSo`000002on3Oh`Go00003_oPgn<03OmDNYcoZk[6onSXiOo/k>Wokno/oo7a
kooclo7omOGdooOgm_oinOSono_jokc;f?mDNY`02?oPgn<00ol0003oh=oSon3Oh`02o`0000Coh=oS
00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`1hon3Oh`7oIVIn0Ooko?d1ofIVOP0000?o
IVInoo_loOmVIWh03?oPgn<00ol0003oh=oSon3Oh`02o`0000Coh=oS00Co0000on3Ohol0003o0000
0ooPgn<3o`0000;oh=oS00Co0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`;o
000000Coh=oSo`000?oPgn?o00000_oPgn<3o`0000Koh=oS0ol00002on3Oh`04o`000?oPgn?o0000
o`0000;oh=oS0ol00003on3Oh`?o00000ooPgn<4o`000005on3Ohol0003oh=oSon3Ohol000001OoP
gn<3o`0000;oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00002on3Oh`;o00000_oPgn<2o`0000;o
h=oS0_l0000Con3Oh`0=ob=FPooOhMooj^[Vonc/jOm=_d[o@/<oocRi=OlQXB7o9YHSooWin?ojn_Wo
loGfob=FP`04on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<02?l0003oh=oSon3Ohol0003o
h=oSo`000?oPgn?o00001_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000Go
h=oS0_l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01?l0003o
h=oSon3Ohol00004on3Oh`;o00000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?o0000
00;oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00003on3Oh`03o`000?oPgn?oh=oS00coh=oS00go
8eJ3om[Lf_oUiN;oj>SUonc/jOo_kncolO7_oo?clOoemOComoOfooWin?obm?Go8eJ300Coh=oS00?o
0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000?oh=oS
00?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?o000000;o
h=oS00?o0000on3Ohol000000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000koh=oS00go8eJ3om[L
f_oUiN;oj>SUonc/jOo_kncolO7_oo?clOoemOComoOfooWin?obm?Go8eJ300Goh=oS0ol00003on3O
h`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`1hon3O
h`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<01?l0003oh=oSon3Ohol0000Lon3O
h`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<03_oPgn<00ol0003oh=oSon3Oh`0Bon3O
h`03o`000?oPgn?oh=oS01Woh=oS00?o0000on3OhooPgn<05_oPgn<03OmDNYcoZk[5onOWhooZj^Ko
ZMbVoeGEDOm3`coo:JPVoi[<V?ogmoKonOWhok[9e_mDNY`01OoPgn<00ol0003oh=oSo`000004on3O
h`;o00000_oPgn<01?l0003oh=oSon3Ohol00005on3Oh`;o00000_oPgn<3o`0000;oh=oS0_l00004
on3Oh`04o`000?oPgn?o0000o`0000?oh=oS0ol00002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS
00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oSo`000?l00003on3Oh`?o00000_oPgn<3o`000003
on3Ohol0003o000000?oh=oS0ol0000?on3Oh`0=oeAjW?nW]l7oh^;NonGUh_oXj>Gok>cYono_k?oa
lNoolo?aooGem?ogmoKo^LSEoeAjW004on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooP
gn?o00000ooPgn<00ol0003oh=oSon3Oh`03o`0000;oh=oS0_l000001OoPgn?o0000on3OhooPgn?o
000000;oh=oS00Oo0000on3Ohol0003o0000on3Ohol0003oh=oS00;o00000_oPgn<3o`0000ooh=oS
00goE7ZLojNg`OoRh]koiNGRonSXiOo/k>Wokno/oo7akooclo7omOGdooOgm_nib=GoE7ZL00Coh=oS
00?o0000on3OhooPgn<01?oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?o000000?o
0000NooPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00coh=oS00Co0000on3OhooPgn?o
00007?oPgn<00ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS00koh=oS00?o0000on3OhooP
gn<04_oPgn<00ol0003oh=oSon3Oh`0Ion3Oh`03o`000?oPgn?oh=oS01Koh=oS00goUjZmofJ7XooU
iN7oinOSon;Xg_nYg:KoCKm:oj3BW_oXk^KomOGcooOgm_m^T:goUjZm00Goh=oS00?o0000on3Ohol0
00002?oPgn<00ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS04[oh=oS00goUjZmofB6XOoP
h=_oh^;NonGUh_oXj>Gok>cYono_k?oalNoolo?aooGem?m^SjcoUjZm00Coh=oS00?o0000on3OhooP
gn<00_oPgn<00ol0003oh=oSon3Oh`0Lon3Oh`03o`000?oPgn?oh=oS01?oh=oS00goUjZmofB6XOoP
h=_oh^;NonGUh_oXj>Gok>cYono_k?oalNoolo?aooGem?m^SjcoUjZm00Coh=oS00?o0000on3OhooP
gn<01?oPgn<00ol0003oh=oSon3Oh`24on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0
3?oPgn<01Ol0003oh=oSon3OhooPgn?o000001coh=oS00Go0000on3Ohol0003oh=oSo`00000@on3O
h`03o`000?oPgn?oh=oS01;oh=oS00?o0000on3OhooPgn<04_oPgn<00ol0003oh=oSon3Oh`0Mon3O
h`0=ol_@fOlPE87oZKW3onGUhOoWin?oj^[Vonc/jOo_kncolO7_oo?clOnfaM;o85B1ol_@f@06on3O
h`03o`000?oPgn?oh=oS00Ooh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003oh=oSon3Oh`1:on3O
h`0=ol_@fOlPE87oY[Foon3PfooRh]koiNGRonSXiOo/k>Wokno/oo7akonea=3o85B1ol_@f@04on3O
h`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<07?oPgn<00ol0003oh=oSon3Oh`0Con3O
h`0=ol_@fOlPE87oY[Foon3PfooRh]koiNGRonSXiOo/k>Wokno/oo7akonea=3o85B1ol_@f@04on3O
h`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<00ol0003oh=oSon3Oh`24on3Oh`7oIVIn0Ooko?d1
ofIVOP0000?oIVInoo_loOmVIWh0SOoPgn<02onU]LGoEgbLojVi`ooUiN7oinOSon[Zi_o/k>Wokno/
ok?3comLPJ;oYKG500Ooh=oS00?o0000on3OhooPgn<01ooPgn<00ol0003oh=oSon3Oh`07on3Oh`03
o`000?oPgn?oh=oS04[oh=oS00_oYKG5oeEjV_nV]Kooh>3Kon;Rg_oUiN;oj>SUonc/jOnb`LgoFh6Q
ojFea@06on3Oh`Co00007OoPgn<00ol0003oh=oSon3Oh`0Fon3Oh`0;ojFeaOmENY[oY[Foon3PfooR
h]koiNGRonSXiOo/k>Wo//7=oe^1XOnU]LD01_oPgn<3o`0000?oh=oS00?o0000on3OhooPgn<00ooP
gn<00ol0003oh=oSon3Oh`1non3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0SOoPgn<0
2ooNgN;oYKG5ob1DPOmVQj?oZk[5omoQgon^_/SoJH^Wob1DPOnU]LGog]gR06Soh=oS00_og]gRojFe
aOlPE87oI8JQojNg`OoJg=[oZk[6ofR9Y_lPE87oYKG5omkMhP10on3Oh`0;omkMh_nU]LGo85B1ofB6
XOnW]l7of]cJoj^ja_mXRJKo85B1ojFeaOoNgN80TooPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_ok
o?goIVIn08ooh=oS00Oobm3IoiNZ_OmDNYco8eJ3oeAjW?nGZ[gobm3I06coh=oS00Oobm3IoiNZ_OmD
NYco8eJ3oeAjW?nGZ[gobm3I04Coh=oS00Oobm3IoiNZ_OmDNYco8eJ3oeAjW?nGZ[gobm3I09Goh=oS
0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn0000
0omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3O
hn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7o
IVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIV
OP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1
oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWko
nocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0;on3Oh`gob/Rk
oooPgn?Bon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh02ooPgn<00oo:b;_ooooooooo
o`09ooooo`03ol[8^ooPgn?oh=oS0?ooh=oSd?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?go
IVIn00_oh=oS00?ob/Rkooooooooool02Oooool00oo:b;_oh=oSon3Oh`03on3Oh`CoXJ6B0ooPgn<3
oj6QTP;oh=oS00GoXJ6Bon3OhooPgn?oh=oSoj6QTP03on3Oh`03oj6QT_oPgn?oh=oS00;oh=oS0onQ
XI82on3Oh`05oj6QT_oPgn?oh=oSon3OhonQXI801OoPgn<4oj6QTP04on3OhonQXI;oh=oSoj6QTPGo
h=oS0_nQXI83on3Oh`;oXJ6B00?oh=oSoj6QT_oPgn<01?nQXI85on3Oh`04oj6QT_oPgn?oh=oSon3O
h`?oXJ6B0_oPgn<00onQXI;oh=oSon3Oh`04oj6QTP;oh=oS0onQXI82on3Oh`04oj6QT_oPgn?oh=oS
on3Oh`;oXJ6BoooPgn=Xon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh02ooPgn<00oo:
b;_oooooooooo`09ooooo`03ol[8^ooPgn?oh=oS00;oh=oS00?oXJ6Bon3OhooPgn<00_oPgn<00onQ
XI;oh=oSoj6QTP03on3Oh`03oj6QT_oPgn?oXJ6B00?oh=oS00GoXJ6Bon3OhooPgn?oh=oSoj6QTP03
on3Oh`07oj6QT_oPgn?oh=oSon3OhonQXI;oh=oSoj6QTP02on3Oh`03oj6QT_oPgn?oh=oS00?oh=oS
00WoXJ6Bon3OhooPgn?oh=oSoj6QT_oPgn?oXJ6Bon3OhonQXI801?oPgn<01_nQXI;oh=oSon3OhonQ
XI;oh=oSoj6QTP;oh=oS0_nQXI800ooPgn?oXJ6Bon3Oh`02on3Oh`03oj6QT_oPgn?oh=oS00;oh=oS
00CoXJ6Bon3OhooPgn?oXJ6B0ooPgn<01OnQXI;oh=oSoj6QT_oPgn?oXJ6B00?oh=oS00?oXJ6Bon3O
honQXI800ooPgn<00onQXI;oh=oSoj6QTP02on3Oh`04oj6QT_oPgn?oh=oSoj6QT_ooh=oSIooPgn<1
ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00_oh=oS00?ob/Rkooooooooool02Oooool00oo:
b;_oh=oSon3Oh`02on3Oh`03oj6QT_oPgn?oh=oS00Coh=oS00OoXJ6Bon3OhooPgn?oh=oSoj6QT_oP
gn?oXJ6B00?oh=oS00KoXJ6Bon3OhooPgn?oXJ6Bon3OhonQXI82on3Oh`03oj6QT_oPgn?oh=oS00?o
h=oS00CoXJ6Bon3OhooPgn?oXJ6B1OoPgn<02OnQXI;oh=oSon3OhooPgn?oXJ6Bon3OhonQXI;oh=oS
oj6QTP06on3Oh`04oj6QT_oPgn?oh=oSoj6QTP?oh=oS00?oXJ6Bon3OhonQXI800ooPgn<00onQXI;o
h=oSon3Oh`02on3Oh`04oj6QT_oPgn?oh=oSoj6QTP?oh=oS00GoXJ6Bon3OhonQXI;oh=oSoj6QTP03
on3Oh`03oj6QT_oPgn?oXJ6B00Goh=oS00?oXJ6Bon3OhooPgn<00_oPgn<00onQXI;oh=oSon3Oh`3o
on3OhfKoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0;on3Oh`03ol[8^ooooooooooo
00Wooooo00?ob/Rkon3OhooPgn<00_oPgn<00onQXI;oh=oSon3Oh`04on3Oh`07oj6QT_oPgn?oh=oS
on3OhonQXI;oh=oSoj6QTP03on3Oh`06oj6QT_oPgn?oh=oSoj6QT_oPgn?oXJ6B0_oPgn<5oj6QTP05
on3OhonQXI;oh=oSon3OhonQXI801_oPgn<4oj6QTP04on3OhonQXI;oh=oSoj6QTPGoh=oS00GoXJ6B
on3OhooPgn?oh=oSoj6QTP03on3Oh`03oj6QT_oPgn?oXJ6B00?oh=oS00KoXJ6Bon3OhonQXI;oXJ6B
on3OhonQXI82on3Oh`09oj6QT_oPgn?oh=oSon3OhonQXI;oh=oSoj6QT_oPgn?oXJ6B00?oh=oS00?o
XJ6Bon3OhonQXI801?nQXI800ooPgn?oXJ6Bon3Oh`02on3Oh`03oj6QT_oPgn?oh=oS0?ooh=oSIooP
gn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00_oh=oS00?ob/Rkooooooooool02Oooool0
0oo:b;_oh=oSon3Oh`02on3Oh`03oj6QT_oPgn?oh=oS00Coh=oS00KoXJ6Bon3OhooPgn?oh=oSoj6Q
T_oPgn<2oj6QTP;oh=oS00?oXJ6Bon3OhonQXI800ooPgn<00onQXI;oh=oSoj6QTP03on3Oh`03oj6Q
T_oPgn?oXJ6B00;oh=oS00?oXJ6Bon3OhooPgn<01ooPgn<01OnQXI;oh=oSoj6QT_oPgn?oXJ6B00Co
h=oS00KoXJ6Bon3OhooPgn?oXJ6Bon3OhonQXI83on3Oh`03oj6QT_oPgn?oXJ6B00?oh=oS00?oXJ6B
on3OhooPgn<00_oPgn<01?nQXI;oh=oSon3OhonQXI83on3Oh`05oj6QT_oPgn?oXJ6Bon3OhonQXI80
0ooPgn<00onQXI;oh=oSoj6QTP03on3Oh`03oj6QT_oPgn?oXJ6B00;oh=oS00CoXJ6Bon3OhooPgn?o
XJ6BoooPgn=Won3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh02ooPgn<00oo:b;_ooooo
ooooo`09ooooo`03ol[8^ooPgn?oh=oS00;oh=oS00?oXJ6Bon3OhooPgn<01OoPgn<3oj6QTP;oh=oS
00CoXJ6Bon3OhonQXI;oXJ6B0_oPgn<01OnQXI;oh=oSon3OhooPgn?oXJ6B00;oh=oS0onQXI82on3O
h`;oXJ6B00?oh=oSoj6QT_nQXI801OoPgn<3oj6QTP;oh=oS00?oXJ6Bon3OhonQXI801OoPgn<2oj6Q
TP;oh=oS00KoXJ6Bon3OhooPgn?oh=oSoj6QT_oPgn<4oj6QTPGoh=oS0_nQXI82on3Oh`?oXJ6B0_oP
gn<00onQXI;oh=oSon3Oh`04oj6QTP;oh=oS0onQXI82on3Oh`;oXJ6B0_oPgn<2oj6QT_ooh=oSJ?oP
gn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00_oh=oS00?ob/Rkooooooooool02Oooool0
0oo:b;_oh=oSon3Oh`02on3Oh`03oj6QT_oPgn?oh=oS01ooh=oS00?oXJ6Bon3OhooPgn<02OoPgn<0
0onQXI;oh=oSoj6QTP0?on3Oh`03oj6QT_oPgn?oh=oS00Koh=oS00?oXJ6Bon3OhooPgn<01_oPgn<0
0onQXI;oh=oSon3Oh`03on3Oh`03oj6QT_oPgn?oh=oS0?ooh=oSLooPgn<1ofIVOP7onocm0OmVIWh0
0003ofIVO_oko?goIVIn00_oh=oS00?ob/Rkooooooooool02Oooool00oo:b;_oh=oSon3Oh`02on3O
h`03oj6QT_oPgn?oh=oS00;oh=oS00?oXJ6Bon3OhooPgn<06_oPgn<00onQXI;oh=oSon3Oh`09on3O
h`03oj6QT_oPgn?oXJ6B00ooh=oS00?oXJ6Bon3OhooPgn<01_oPgn<00onQXI;oh=oSon3Oh`06on3O
h`03oj6QT_oPgn?oh=oS00?oh=oS00?oXJ6Bon3OhooPgn<0oooPgn=con3Oh`7oIVIn0Ooko?d1ofIV
OP0000?oIVInoo_loOmVIWh02ooPgn<00oo:b;_oooooooooo`09ooooo`03ol[8^ooPgn?oh=oS00?o
h=oS1?nQXI8Yon3Oh`03oj6QT_oPgn?oXJ6B00ooh=oS00?oXJ6Bon3OhooPgn<01ooPgn<00onQXI;o
h=oSon3Oh`05on3Oh`03oj6QT_oPgn?oh=oS00?oh=oS00?oXJ6Bon3OhooPgn<0oooPgn=con3Oh`7o
IVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh02ooPgn<00oo:b;_oooooooooo`09ooooo`03ol[8
^ooPgn?oh=oS0?ooh=oSd?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00_oh=oS3Oo:
b;_oon3Ohm;oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1
oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWko
nocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS
0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn0000
0omVIWkonocmofIVOP0;on3Oh`go7560oooPgn?Bon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_l
oOmVIWh02ooPgn<02OlLDH3olO7_oo?clOoemOComoOfooWin?okno[ooOglooknoP03ooooo`03oaaA
P?oPgn?oh=oS0?ooh=oSd?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00_oh=oS00[o
7560ono_k?oalNoolo?aooGem?ogmoKonOWhoo_kn_omoOcoo_kn0_ooool00olLDH3oh=oSon3Oh`03
on3Oh`Co00000ooPgn<3o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`03o`000?oP
gn?oh=oS00;oh=oS0ol00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000001OoPgn<4o`000004on3O
hol0003oh=oSo`0000Coh=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`?o00000ooPgn<00ol0
003oh=oSon3Oh`03o`0000;oh=oS1?l00003on3Oh`?o00000ooPgn<3o`0000;oh=oS00Go0000on3O
hooPgn?oh=oSo`000002on3Oh`;o00001OoPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o
h=oS00?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`;o00001OoPgn<0
1?l0003oh=oSon3OhooPgn<3o`0000;oh=oS00?o0000on3OhooPgn<01?l00002on3Oh`?o00000_oP
gn<00ol0003oh=oSon3Oh`3oon3Ohbcoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0;
on3Oh`0=oaaAP?o/k>Wokno/oo7akooclo7omOGdooOgm_oinOSono_joogmo?ono_kooooooaaAP004
on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003
on3Oh`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol0
00000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`09o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000?oP
gn?o000000Coh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol0
00000_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol0
0002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3O
h`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00Go0000on3Ohol0003oh=oSo`000002on3Oh`03
o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00000ooPgn<01Ol0003oh=oSo`000?oPgn?o
000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`00003oon3Ohbkoh=oS0OmVIWh1
oo_lo@7oIVIn00000omVIWkonocmofIVOP0;on3Oh`0=oaaAP?oXj>Gok>cYono_k?oalNoolo?aooGe
m?ogmoKonOWhoo_kn_omoOcoo_knoaaAP004on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Oo0000on3O
hooPgn?oh=oSo`000?oPgn?o000000?oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00002on3Oh`03
o`000?oPgn?oh=oS00?oh=oS00Co0000on3OhooPgn?o00001OoPgn<02Ol0003oh=oSon3OhooPgn?o
0000on3Ohol0003oh=oSo`000004on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3O
h`03o`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00ooPgn<01ol0003oh=oSon3OhooPgn?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3Ohol00000
1OoPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<0
0_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooP
gn<00ooPgn<01?l0003oh=oSon3Ohol00003on3Oh`05o`000?oPgn?o0000on3Ohol000000ooPgn<0
0ol0003oh=oSo`000005on3Oh`03o`000?oPgn?oh=oS0?ooh=oS;?oPgn<1ofIVOP7onocm0OmVIWh0
0003ofIVO_oko?goIVIn00_oh=oS00go7560onGUh_oXj>Gok>cYono_k?oalNoolo?aooGem?ogmoKo
nOWhoo_kn_omoOco756000Coh=oS00?o0000on3OhooPgn<01?oPgn<01ol0003oh=oSon3OhooPgn?o
0000on3Ohol000000ooPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000;oh=oS1Ol000001OoPgn?o
0000on3OhooPgn?o000000Koh=oS1?l000001?oPgn?o0000on3Ohol00004on3Oh`07o`000?oPgn?o
h=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS1Ol000000ooPgn?o0000
on3Oh`02on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<01?l0003oh=oS
o`000?l00005on3Oh`03o`000?oPgn?oh=oS00Coh=oS00?o0000on3Ohol000000ooPgn<00ol0003o
h=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0
003oh=oSon3Oh`04on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00Go0000on3Ohol0003oh=oSo`00
0003on3Oh`03o`000?oPgn?o000000Co000000?oh=oSo`000?oPgn<0oooPgn<]on3Oh`7oIVIn0Ook
o?d1ofIVOP0000?oIVInoo_loOmVIWh02ooPgn<03OlLDH3oh^;NonGUh_oXj>Gok>cYono_k?oalNoo
lo?aooGem?ogmoKonOWhoo_kn_lLDH001?oPgn<00ol0003oh=oSon3Oh`04on3Oh`06o`000?oPgn?o
h=oSon3Ohol0003oh=oS0_l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00Ooh=oS00Go0000on3Ohol0003o
h=oSo`000004on3Oh`;o00000_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;o
h=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<0
0ol0003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3Ohol000000ooPgn<01?l0003oh=oSon3O
hol00004on3Oh`04o`000?oPgn?o0000o`0000;oh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003o
h=oSon3Oh`02o`0000;oh=oS00Go0000on3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS
00;oh=oS00Co0000on3OhooPgn?o00000ooPgn<01Ol0003oh=oSo`000?oPgn?o000000?oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`00003oon3Ohbkoh=oS0OmVIWh1oo_lo@7oIVIn0000
0omVIWkonocmofIVOP0;on3Oh`0=oaaAP?oPh=_oh^;NonGUh_oXj>Gok>cYono_k?oalNoolo?aooGe
m?ogmoKonOWhoaaAP004on3Oh`03o`000?oPgn?oh=oS00Goh=oS0ol00002on3Oh`04o`000?oPgn?o
0000o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`?o00000_oPgn<2o`000003on3O
hol0003o000000Goh=oS0ol00002on3Oh`03o`000?oPgn?o000000Coh=oS00Co0000on3Ohol0003o
00000ooPgn<3o`0000;oh=oS0_l00002on3Oh`?o00000_oPgn<4o`0000?oh=oS0ol00003on3Oh`?o
00000_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`;o00001OoPgn<01?l0003oh=oSo`000?oPgn<2
o`0000Goh=oS0_l000000ooPgn?o0000on3Oh`02o`0000;oh=oS00?o0000on3OhooPgn<00_l00005
on3Oh`;o00000_oPgn<3o`0000;oh=oS00?o0000on3OhooPgn<01?l00002on3Oh`?o00000_oPgn<2
o`000?ooh=oS;OoPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00_oh=oS00go7560omkN
fOoPh=_oh^;NonGUh_oXj>Gok>cYono_k?oalNoolo?aooGem?ogmoKo756000Coh=oS00?o0000on3O
hooPgn<07ooPgn<00ol0003oh=oSon3Oh`09on3Oh`03o`000?oPgn?o0000013oh=oS00?o0000on3O
hooPgn<01_oPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS01Koh=oS00Co0000on3O
hooPgn?o00003ooPgn<00ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000
on3OhooPgn<0oooPgn<don3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh02ooPgn<03OlL
DH3og=cGomkNfOoPh=_oh^;NonGUh_oXj>Gok>cYono_k?oalNoolo?aooGem?lLDH001?oPgn<00ol0
003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS01[oh=oS00?o0000on3OhooPgn<02OoPgn<00ol0
003oh=oSo`00000@on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<03ooPgn<00ol0
003oh=oSon3Oh`0Fon3Oh`04o`000?oPgn?oh=oSo`0000ooh=oS00?o0000on3OhooPgn<01_oPgn<0
0ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS0?ooh=oS=?oPgn<1ofIVOP7onocm0OmVIWh0
0003ofIVO_oko?goIVIn00_oh=oS00go7560omcLeooLg=Oog]kIon3PfooRh]koiNGRonSXiOo/k>Wo
kno/oo7akooclo7o756000Goh=oS1?l0000Yon3Oh`03o`000?oPgn?o000001Woh=oS00?o0000on3O
hooPgn<03ooPgn<00ol0003oh=oSon3Oh`0;on3Oh`03o`000?oPgn?oh=oS00_oh=oS00?o0000on3O
hooPgn<00ooPgn<00ol0003oh=oSon3Oh`08on3Oh`03o`000?oPgn?oh=oS00Goh=oS00?o0000on3O
hooPgn<00ooPgn<00ol0003oh=oSon3Oh`3oon3OhcCoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWko
nocmofIVOP0;on3Oh`0=oaaAP?oLg=Oog=cGomcLeooNg]Woh>3Kon;Rg_oUiN;oj>SUonc/jOo_knco
lO7_oaaAP03oon3Ohm;oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0;on3Oh`go7560
oooPgn?Bon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ook
o?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_l
oOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7o
IVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?o
IVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Z
on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIV
OP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0
oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ook
o?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_l
oOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7o
IVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?o
IVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<=
oaaAP4coh=oS00?o0000on3OhooPgn<0B?oPgn<4o`0000_oh=oS00?o0000on3OhooPgn<0oooPgn<O
on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<02OlLDH3olO7_oo?clOoemOCo
moOfooWin?okno[ooOglooknoP03ooooo`03oaaAP?oPgn?oh=oS04[oh=oS00?o0000on3OhooPgn<0
C?oPgn<00ol0003oh=oSon3Oh`08on3Oh`03o`000?oPgn?oh=oS0?ooh=oS7ooPgn<1ofIVOP7onocm
0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00[o7560ono_k?oalNoolo?aooGem?ogmoKonOWhoo_k
n_omoOcoo_kn0_ooool00olLDH3oh=oSon3Oh`03on3Oh`?o000000?oh=oSo`000?oPgn<00_oPgn<3
o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`?o00000_oPgn<01?l0003oh=oSon3O
hooPgn<4o`0000;oh=oS00?o0000on3OhooPgn<00ol00005on3Oh`Co00000_oPgn<01_l0003oh=oS
on3Ohol0003oh=oSo`0000;oh=oS00Co0000on3OhooPgn?o00000_oPgn<4o`000003on3Ohol0003o
000000;o00001_oPgn<3o`0000?oh=oS1?l00002on3Oh`?o00000_oPgn<01Ol0003oh=oSon3OhooP
gn?o000000;oh=oS0ol00003on3Oh`;o00001OoPgn<01?l0003oh=oSon3OhooPgn<3o`0000;oh=oS
00?o0000on3OhooPgn<01?oPgn<4o`000004on3Ohol0003oh=oSo`0000Goh=oS1?l000000ooPgn?o
0000on3Oh`02on3Oh`Co000000?oh=oSo`000?l000000_l00002on3Oh`07o`000?oPgn?oh=oSon3O
hol0003oh=oSo`000002on3Oh`?o00000ooPgn<2o`0000Koh=oS0ol00003on3Oh`?o00000_oPgn<0
0ol0003oh=oSo`000002on3Oh`;o0000l_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn
01Goh=oS00go7560onc/jOo_kncolO7_oo?clOoemOComoOfooWin?okno[ooOglookno_oooooo7560
00Coh=oS00Co0000on3OhooPgn?oh=oS0_l00002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oS
o`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01ol0003oh=oS
on3OhooPgn?o0000on3Ohol000000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000Coh=oS00Wo0000
on3OhooPgn?oh=oSo`000?oPgn?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol00002on3O
h`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3O
h`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00?o
0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000Goh=oS
00Wo0000on3OhooPgn?oh=oSo`000?oPgn?o0000on3Ohol000001?oPgn<01ol0003oh=oSon3OhooP
gn?o0000on3Ohol000000_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0
003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002
on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS
00Oo0000on3Ohol0003oh=oSo`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<0kooPgn<1ofIV
OP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00go7560onSXiOo/k>Wokno/oo7akooclo7o
mOGdooOgm_oinOSono_joogmo?ono_ko756000Coh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003o
h=oSon3Ohol00005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000005on3Oh`04o`000?oP
gn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`06on3Oh`09o`00
0?oPgn?oh=oSon3Ohol0003oh=oSo`000?oPgn?o000000;oh=oS00Co0000on3OhooPgn?o00000_oP
gn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oP
gn<00ol0003oh=oSon3Oh`03on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000005on3Oh`07
o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000007on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Co0000
on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000005on3Oh`09o`000?oPgn?oh=oSon3Ohol0003o
h=oSo`000?oPgn?o000000Coh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS00Oo
0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<01Ol0003o
h=oSo`000?oPgn?o000000Ooh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSon3Oh`03on3O
h`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`3`on3O
h`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<03OlLDH3oiNGRonSXiOo/k>Wokno/
oo7akooclo7omOGdooOgm_oinOSono_joogmo?lLDH001?oPgn<00ol0003oh=oSon3Oh`02on3Oh`03
o`000?oPgn?oh=oS00Go000000?oh=oSo`000?oPgn<00_oPgn<00ol0003oh=oSo`000004o`000003
on3Ohol0003oh=oS00;oh=oS1?l000001?oPgn?o0000on3OhooPgn<5o`0000Coh=oS00Wo0000on3O
hooPgn?oh=oSo`000?oPgn?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03
o`000?oPgn?oh=oS00Co000000?oh=oSo`000?oPgn<00_oPgn<00ol0003oh=oSon3Oh`02on3Oh`03
o`000?oPgn?oh=oS00Coh=oS1?l000000ooPgn?o0000on3Oh`04on3Oh`06o`000?oPgn?oh=oSon3O
hol0003oh=oS1Ol00002on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Co0000on3OhooPgn?o00000ooP
gn<00ol0003oh=oSo`000006on3Oh`Co000000Coh=oSo`000?oPgn?o00001?oPgn<01ol0003oh=oS
on3OhooPgn?o0000on3Ohol000000ooPgn<4o`000003on3Ohol0003oh=oS00;oh=oS00?o0000on3O
hol000000ooPgn<01Ol0003oh=oSo`000?oPgn?o000000Koh=oS00?o0000on3OhooPgn<01?oPgn<0
0ol0003oh=oSon3Oh`03on3Oh`Go000000Coh=oSo`000?oPgn?o00000_oPgn<00ol0003oh=oSon3O
h`3aon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<03OlLDH3oh^;NonGUh_oX
j>Gok>cYono_k?oalNoolo?aooGem?ogmoKonOWhoo_kn_lLDH001?oPgn<00ol0003oh=oSon3Oh`03
o`0000;oh=oS00Ko0000on3OhooPgn?oh=oSo`000?oPgn<2o`0000;oh=oS00?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSo`000006on3Oh`03o`000?oPgn?o000000;oh=oS00Go0000on3OhooPgn?o
h=oSo`000004on3Oh`09o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000?oPgn?o000000;oh=oS00Co
0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?o000000?oh=oS
00?o0000on3OhooPgn<00_oPgn<01Ol0003oh=oSon3OhooPgn?o000000Goh=oS00?o0000on3Ohol0
00000ooPgn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3O
hol000000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000
on3Ohol000002OoPgn<01Ol0003oh=oSo`000?oPgn?o000000Coh=oS00Oo0000on3OhooPgn?oh=oS
o`000?oPgn?o000000Koh=oS00?o0000on3Ohol000000ooPgn<01?l0003oh=oSo`000?l00002on3O
h`05o`000?oPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?o
h=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00Oo0000on3Ohol0003o
h=oSo`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<0kooPgn<1ofIVOP7onocm0OmVIWh00003
ofIVO_oko?goIVIn01Goh=oS00go7560on3PfooRh]koiNGRonSXiOo/k>Wokno/oo7akooclo7omOGd
ooOgm_oinOSo756000Coh=oS00?o0000on3OhooPgn<01_oPgn<3o`0000;oh=oS00Co0000on3Ohol0
003o00000ooPgn<3o`0000;oh=oS0_l00002on3Oh`?o00000_oPgn<2o`0000;oh=oS0ol00005on3O
h`Co00000_oPgn<01Ol0003oh=oSo`000?l0003oh=oS00?o000000?oh=oSo`000?l000000ooPgn<3
o`0000;oh=oS1?l00006on3Oh`?o00000ooPgn<3o`0000?oh=oS0ol00002on3Oh`04o`000?oPgn?o
0000o`0000?oh=oS0ol00003on3Oh`;o00001OoPgn<2o`0000;oh=oS0ol00002on3Oh`;o00001OoP
gn<3o`0000;oh=oS00?o0000on3Ohol000001OoPgn<4o`000003on3Ohol0003o000000;oh=oS0ol0
0002on3Oh`Co00000_oPgn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oPgn?oh=oS00?o0000
0ooPgn<2o`0000Koh=oS0ol00003on3Oh`?o00000_oPgn<00ol0003oh=oSo`000002on3Oh`;o0000
l_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00go7560omkNfOoPh=_oh^;N
onGUh_oXj>Gok>cYono_k?oalNoolo?aooGem?ogmoKo756000Coh=oS00?o0000on3OhooPgn<08?oP
gn<00ol0003oh=oSon3Oh`09on3Oh`03o`000?oPgn?oh=oS00Goh=oS00?o0000on3OhooPgn<0:OoP
gn<00ol0003oh=oSon3Oh`0Aon3Oh`03o`000?oPgn?oh=oS01;oh=oS00?o0000on3Ohol000006OoP
gn<00ol0003oh=oSon3Oh`0Oon3Oh`03o`000?oPgn?o00000?Koh=oS0OmVIWh1oo_lo@7oIVIn0000
0omVIWkonocmofIVOP0Eon3Oh`0=oaaAP?oLg=Oog]kIon3PfooRh]koiNGRonSXiOo/k>Wokno/oo7a
kooclo7omOGdoaaAP004on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<06ooPgn<0
0ol0003oh=oSon3Oh`09on3Oh`03o`000?oPgn?oh=oS00Goh=oS00?o0000on3OhooPgn<0:OoPgn<0
0ol0003oh=oSon3Oh`0Aon3Oh`03o`000?oPgn?oh=oS01;oh=oS00?o0000on3Ohol000006OoPgn<0
0ol0003oh=oSon3Oh`0Oon3Oh`03o`000?oPgn?o00000?Koh=oS0OmVIWh1oo_lo@7oIVIn00000omV
IWkonocmofIVOP0Eon3Oh`0=oaaAP?oLg=Oog=cGomkNfOoPh=_oh^;NonGUh_oXj>Gok>cYono_k?oa
lNoolo?aoaaAP005on3Oh`Co0000:_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS
02_oh=oS00?o0000on3OhooPgn<04_oPgn<00ol0003oh=oSon3Oh`0Aon3Oh`03o`000?oPgn?o0000
01Woh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSon3Oh`0Ion3Oh`03o`000?oPgn?o0000
0?Koh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0Eon3Oh`0=oaaAP?oLg=Oog=cGomcL
eooNg]Woh>3Kon;Rg_oUiN;oj>SUonc/jOo_kncolO7_oaaAP03oon3OhlSoh=oS0OmVIWh1oo_lo@7o
IVIn00000omVIWkonocmofIVOP0Eon3Oh`go7560oooPgn?8on3Oh`7oIVIn0Ooko?d1ofIVOP0000?o
IVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Z
on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIV
OP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0
oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0GOoPgn<2o`0000Soh=oS00?o
0000on3OhooPgn<0<OoPgn<2o`0001coh=oS00?o0000on3OhooPgn<0oooPgn<^on3Oh`7oIVIn0Ook
o?d1ofIVOP0000?oIVInoo_loOmVIWh0GooPgn<00ol0003oh=oSon3Oh`04on3Oh`03o`000?oPgn?o
h=oS03Coh=oS00?o0000on3OhooPgn<06_oPgn<00ol0003oh=oSon3Oh`3oon3Ohbgoh=oS0OmVIWh1
oo_lo@7oIVIn00000omVIWkonocmofIVOP0=on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3O
hooPgn<00ol00002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<00ooPgn<4
o`0000;oh=oS0_l000001OoPgn?o0000on3OhooPgn?o000000;oh=oS0ol00002on3Oh`04o`000?oP
gn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<01?l00002on3Oh`03o`000?oPgn?o000000;oh=oS
0ol00003on3Oh`Co000000Coh=oSo`000?oPgn?o00000_oPgn<00ol0003oh=oSon3Oh`04on3Oh`04
o`000?oPgn?oh=oSon3Oh`?o00000ooPgn<4o`000003on3Ohol0003oh=oS00;oh=oS00?o0000on3O
hooPgn<00_oPgn<4o`0000?oh=oS0ol00007on3Oh`03o`000?oPgn?oh=oS00;oh=oS0ol00002on3O
h`05o`000?oPgn?oh=oSon3Ohol000001ooPgn<2o`0000;oh=oS00?o0000on3OhooPgn<00ol00003
on3Oh`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<00ol0003oh=oSo`00003oon3Ohbgoh=oS0OmV
IWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0<on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000Coh=oS
00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS0_l000001OoPgn?o0000on3OhooPgn?o
000000?oh=oS00?o0000on3Ohol000000_oPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS
00?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS
00Go0000on3Ohol0003oh=oSo`000002on3Oh`;o00001OoPgn<01?l0003oh=oSon3Ohol00003on3O
h`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3O
h`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Go
0000on3OhooPgn?oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS0_l00005on3Oh`08o`00
0?oPgn?oh=oSo`000?oPgn?o0000on3Ohol00003on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00Go
0000on3OhooPgn?oh=oSo`00003oon3Ohbooh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIV
OP0<on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000001OoPgn<01?l0003oh=oS
on3Ohol00002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o
000000?oh=oS00?o0000on3Ohol000000_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol00000
0_oPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0
003oh=oSo`000005on3Oh`0;o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000?oPgn?o0000on3Ohol0
00000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000Goh=oS00Oo0000on3O
hooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3O
hooPgn?o0000on3Ohol000002OoPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00?o
h=oS00Co0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`04on3Oh`06o`000?oPgn?oh=oS
o`000?oPgn?o00000ooPgn<02Ol0003oh=oSo`000?oPgn?o0000on3Ohol0003oh=oSo`000002on3O
h`03o`000?oPgn?oh=oS0?ooh=oS;OoPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00co
h=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000004o`000005on3Ohol0003oh=oS
on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`Co000000?oh=oSo`000?oPgn<00_oPgn<0
0ol0003oh=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`04o`00
0?oPgn?oh=oSo`0000;oh=oS1?l000001ooPgn?o0000on3OhooPgn?o0000on3Ohol000001_oPgn<4
o`000006on3Ohol0003oh=oSo`000?oPgn?o00000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`00
0?oPgn?oh=oSo`0000Koh=oS1?l000000ooPgn?o0000on3Oh`02on3Oh`03o`000?oPgn?oh=oS00;o
h=oS00Ko0000on3OhooPgn?oh=oSo`000?oPgn<5o`0000Goh=oS00?o0000on3Ohol000000_oPgn<5
o`000005on3Ohol0003oh=oSon3Ohol000000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`07o`000?oP
gn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`09o`000?oPgn?o0000on3Ohol0003oh=oSo`000?oP
gn?o000000;oh=oS00?o0000on3OhooPgn<0oooPgn<]on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVIn
oo_loOmVIWh03?oPgn<00ol0003oh=oSon3Oh`02o`0000;oh=oS00?o0000on3Ohol000000ooPgn<0
0ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000Soh=oS00?o0000on3Ohol000000ooP
gn<00ol0003oh=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`04
o`000?oPgn?oh=oSo`0000Goh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`000003on3O
h`03o`000?oPgn?oh=oS00?oh=oS00Oo0000on3Ohol0003oh=oSo`000?oPgn?o000000;oh=oS00?o
0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?oh=oS00?oh=oS
00Co0000on3Ohol0003o00000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3O
hol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`00
0?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol00004on3Oh`08
o`000?oPgn?oh=oSo`000?oPgn?o0000on3Ohol00003on3Oh`03o`000?oPgn?o000000;oh=oS00Co
0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`3oon3Ohbgoh=oS0OmVIWh1oo_lo@7oIVIn
00000omVIWkonocmofIVOP0<on3Oh`;o000000?oh=oSo`000?oPgn<00_l00003on3Oh`?o00000_oP
gn<3o`000003on3Ohol0003o000000Koh=oS0ol00002on3Oh`06o`000?oPgn?oh=oSon3Ohol0003o
h=oS0_l00002on3Oh`?o00000_oPgn<3o`000003on3Ohol0003o000000?oh=oS0ol00002on3Oh`;o
000000Coh=oSo`000?oPgn?oh=oS0ol00003on3Oh`?o00000_oPgn<01Ol0003oh=oSo`000?oPgn?o
000000;oh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3OhooPgn<3o`0000?oh=oS0ol0
0002on3Oh`04o`000?oPgn?o0000o`0000Goh=oS1?l00003on3Oh`?o00001OoPgn<01Ol0003oh=oS
on3OhooPgn?o000000;oh=oS0ol00002on3Oh`;o000000Goh=oSo`000?oPgn?oh=oSo`000005on3O
h`;o00000_oPgn<00ol0003oh=oSon3Oh`03o`0000;oh=oS00Co0000on3OhooPgn?o00000_oPgn<0
1?l0003oh=oSon3Ohol0003oon3Ohbooh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0<
on3Oh`04o`000?oPgn?oh=oSo`0002;oh=oS00?o0000on3OhooPgn<05?oPgn<00ol0003oh=oSon3O
h`0>on3Oh`03o`000?oPgn?o000000Woh=oS00?o0000on3OhooPgn<05OoPgn<00ol0003oh=oSon3O
h`0Xon3Oh`03o`000?oPgn?oh=oS00koh=oS00?o0000on3OhooPgn<0oooPgn<]on3Oh`7oIVIn0Ook
o?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<01?l0003oh=oSon3Ohol0000Ron3Oh`03o`000?oP
gn?oh=oS01Coh=oS00?o0000on3OhooPgn<03_oPgn<00ol0003oh=oSo`000009on3Oh`03o`000?oP
gn?oh=oS01Goh=oS00?o0000on3OhooPgn<0:?oPgn<00ol0003oh=oSon3Oh`0>on3Oh`03o`000?oP
gn?oh=oS0?ooh=oS;OoPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00ooh=oS00?o0000
on3OhooPgn<0>_oPgn<00ol0003oh=oSon3Oh`0;on3Oh`03o`000?oPgn?o000000[oh=oS00?o0000
on3OhooPgn<05?oPgn<00ol0003oh=oSon3Oh`0Xon3Oh`03o`000?oPgn?oh=oS00goh=oS00?o0000
on3OhooPgn<0oooPgn<^on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3O
h`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP00
00?oIVInoo_loOmVIWh09_oPgn<00ol0003oh=oSon3Oh`1Ron3Oh`03o`000?oPgn?oh=oS0<Coh=oS
00?o0000on3OhooPgn<0BooPgn<4o`0004Goh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIV
OP0Von3Oh`03o`000?oPgn?oh=oS06;oh=oS00?o0000on3OhooPgn<0a?oPgn<00ol0003oh=oSon3O
h`1?on3Oh`03o`000?oPgn?oh=oS04;oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0<
on3Oh`Co00000ooPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000;oh=oS00Co0000on3OhooPgn?o
00000_oPgn<4o`000003on3Ohol0003o000000;o00001_oPgn<3o`0000?oh=oS1?l00002on3Oh`?o
00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS0ol00003on3Oh`;o00001OoPgn<01?l0
003oh=oSon3OhooPgn<3o`0000;oh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSon3Oh`05
on3Oh`?o00000ooPgn<2o`0000?oh=oS00?o0000on3OhooPgn<00ol00004on3Oh`?o00000_oPgn<0
1Ol0003oh=oSon3Ohol0003oh=oS00Co00000ooPgn<00ol0003oh=oSon3Oh`03on3Oh`?o00000ooP
gn<3o`0000;oh=oS00?o0000on3Ohol000000_oPgn<2o`0000Koh=oS0ol00003on3Oh`Co000000?o
h=oSo`000?oPgn<00_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00?o00000ooP
gn<00ol0003oh=oSon3Oh`02on3Oh`Co00000ooPgn<3o`0000Koh=oS0ol00003on3Oh`?o00000_oP
gn<01Ol0003oh=oSon3OhooPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<3o`0000;oh=oS
00Go0000on3OhooPgn?oh=oSo`000002on3Oh`?o00000ooPgn<4o`000003on3Ohol0003oh=oS00Go
h=oS1?l00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<3o`0000?oh=oS0ol00002on3O
h`05o`000?oPgn?oh=oSon3Ohol000001OoPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o
h=oS00?o00001_oPgn<3o`0000;oh=oS1?l00003on3Oh`03o`000?oPgn?o000000;oh=oS0ol00002
on3Oh`05o`000?oPgn?oh=oSon3Ohol000001?oPgn<4o`0000?oh=oS0ol00002on3Oh`03o`000?oP
gn?oh=oS00?o00000ooPgn<01Ol0003oh=oSon3OhooPgn?o000000Koh=oS00?o0000on3OhooPgn<0
0ol00005on3Oh`04o`000?oPgn?oh=oSon3Oh`?o00000ooPgn<4o`0000;oh=oS0ol00002on3Oh`05
o`000?oPgn?oh=oSon3Ohol000000_oPgn<3o`0000;oh=oS00Co0000on3OhooPgn?oh=oS1?l00002
on3Oh`03o`000?oPgn?oh=oS00?o00008OoPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn
00coh=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`03o`000?oPgn?o000000;oh=oS00Co0000
on3OhooPgn?o00000_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o
0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003o
h=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003o
h=oSo`000002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0
003oh=oSo`000005on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Oo0000on3OhooPgn?oh=oSo`000?oP
gn?o000000;oh=oS00?o0000on3Ohol000000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS
00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0
003oh=oSo`000005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`07o`000?oP
gn?o0000on3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooP
gn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000001OoPgn<01ol0003oh=oSon3OhooP
gn?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0
003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00Go0000on3OhooPgn?oh=oSo`000003
on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000?o
h=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`05on3Oh`03o`000?oPgn?oh=oS00;o
h=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?o
h=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`04o`000?oPgn?oh=oSo`00
00?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oS
on3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00?o0000on3Ohol000000ooP
gn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oS
o`000?oPgn?o000000?oh=oS00Go0000on3Ohol0003oh=oSo`000003on3Oh`04o`000?oPgn?oh=oS
o`0000?oh=oS00?o0000on3OhooPgn<00ooPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oP
gn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`00
0?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`00
0?oPgn?o000000;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS00Go0000on3O
hooPgn?oh=oSo`00000Pon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<01Ol0
003oh=oSon3OhooPgn?o000000;oh=oS00?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol0
0002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3O
h`02on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000Go
h=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000Ooh=oS00?o0000on3OhooPgn<00ooPgn<0
1?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000Goh=oS00?o0000on3OhooPgn<01?oP
gn<01Ol0003oh=oSon3OhooPgn?o000000?oh=oS00Co0000on3OhooPgn?o00001_oPgn<01?l0003o
h=oSon3Ohol00005on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o00000ooPgn<00ol0003oh=oSo`00
0005on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSo`00
0003on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<00ooPgn<01ol0003oh=oSon3O
hooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?o
h=oS00?o0000on3Ohol000001OoPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000002?oPgn<0
0ol0003oh=oSon3Oh`03on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`06o`00
0?oPgn?oh=oSo`000?oPgn?o00000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`04o`000?oPgn?oh=oS
o`0000;oh=oS00?o0000on3OhooPgn<00ooPgn<01Ol0003oh=oSon3OhooPgn?o000000Ooh=oS00?o
0000on3OhooPgn<01?oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000001OoPgn<00ol0003o
h=oSon3Oh`03on3Oh`03o`000?oPgn?o000000Koh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0
003oh=oSo`000008on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oP
gn?o000000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oP
gn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000Goh=oS00?o0000on3Ohol0
00000ooPgn<02Ol0003oh=oSo`000?oPgn?o0000on3Ohol0003oh=oSo`000004on3Oh`04o`000?oP
gn?oh=oSo`0000?oh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol00005on3Oh`07
o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oS
o`000005on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003o
h=oSon3Oh`0Ron3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<01Ol0003oh=oS
on3OhooPgn?o000000;oh=oS00?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol00002on3O
h`03o`000?oPgn?oh=oS00Co000000?oh=oSo`000?oPgn<00_oPgn<00ol0003oh=oSon3Oh`02on3O
h`03o`000?oPgn?oh=oS00Coh=oS1?l000000ooPgn?o0000on3Oh`04on3Oh`06o`000?oPgn?oh=oS
on3Ohol0003oh=oS1Ol00002on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Co0000on3OhooPgn?o0000
0ooPgn<00ol0003oh=oSo`000005on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Go0000on3OhooPgn?o
h=oSo`000002on3Oh`05o`000?oPgn?oh=oSon3Ohol000001_oPgn<01?l0003oh=oSon3Ohol00005
on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o00000ooPgn<00ol0003oh=oSo`000005on3Oh`03o`00
0?oPgn?oh=oS00?oh=oS1Ol000001?oPgn?o0000on3Ohol00002on3Oh`03o`000?oPgn?oh=oS00Co
h=oS00?o0000on3OhooPgn<01?oPgn<4o`000003on3Ohol0003oh=oS00;oh=oS00?o0000on3Ohol0
00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000Goh=oS00Ko0000on3OhooP
gn?oh=oSo`000?oPgn<5o`0000Coh=oS00?o0000on3OhooPgn<00ooPgn<01ol0003oh=oSon3OhooP
gn?o0000on3Ohol000000ooPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000;oh=oS1Ol000001OoP
gn?o0000on3OhooPgn?o000000;oh=oS1Ol000000ooPgn?o0000on3Oh`02on3Oh`03o`000?oPgn?o
h=oS00Goh=oS00?o0000on3OhooPgn<01?oPgn<01_l0003oh=oSon3OhooPgn?o0000on3Oh`Go0000
00?oh=oSo`000?oPgn<01?oPgn<2o`0000Ooh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003o
h=oSo`000004o`0000Coh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000
on3Ohol000000_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000
on3OhooPgn<00_oPgn<01_l0003oh=oSon3OhooPgn?o0000on3Oh`Go000000Coh=oSo`000?oPgn?o
00000ooPgn<02Ol0003oh=oSo`000?oPgn?o0000on3Ohol0003oh=oSo`000004on3Oh`04o`000?oP
gn?oh=oSo`0000?oh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oSon3Oh`05o`000003on3O
hol0003oh=oS00;oh=oS00?o0000on3Ohol000001?l000000ooPgn?o0000on3Oh`02on3Oh`03o`00
0?oPgn?o000000Co000000?oh=oSo`000?oPgn<00_oPgn<4o`000004on3Ohol0003oh=oSon3Oh`Go
00008?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00coh=oS1?l00003on3Oh`03o`00
0?oPgn?o000000;oh=oS00Co0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03
o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01Ol0003oh=oSon3OhooPgn?o0000
00Goh=oS00?o0000on3Ohol000000ooPgn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oPgn?o
000000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?o
h=oSo`0000?oh=oS00?o0000on3Ohol000001OoPgn<5o`0000;oh=oS00Oo0000on3OhooPgn?oh=oS
o`000?oPgn?o000000;oh=oS00?o0000on3Ohol000000ooPgn<3o`0000?oh=oS00Oo0000on3OhooP
gn?oh=oSo`000?oPgn?o000000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000005
on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`07o`000?oPgn?o0000on3Ohol0
003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Go0000on3OhooPgn?oh=oSo`000005
on3Oh`04o`000?oPgn?o0000o`0000;oh=oS00Co0000on3Ohol0003o00000_oPgn<00ol0003oh=oS
o`000003on3Oh`03o`000?oPgn?o000000Goh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o0000
00?oh=oS00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooP
gn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol0
00000ooPgn<00ol0003oh=oSon3Oh`05on3Oh`03o`000?oPgn?oh=oS00Coh=oS0_l00002on3Oh`03
o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<01Ol0003oh=oSo`000?oPgn?o0000
00Koh=oS00?o0000on3OhooPgn<00_l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3O
hooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`00
0002on3Oh`03o`000?oPgn?o000000?oh=oS00Co0000on3Ohol0003o00000_oPgn<00ol0003oh=oS
on3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`05o`000?oPgn?o0000
on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000Coh=oS00Co
0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?o
h=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`04o`000?oPgn?o0000o`00
00;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000006on3Oh`03o`000?oPgn?o0000
00;oh=oS00Go0000on3OhooPgn?oh=oSo`00000Pon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_l
oOmVIWh03?oPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS00Go0000on3Ohol0003o0000on3O
h`03o`000003on3Ohol0003o000000?oh=oS0ol00002on3Oh`Co00001_oPgn<3o`0000?oh=oS0ol0
0003on3Oh`?o00000_oPgn<01?l0003oh=oSo`000?l00003on3Oh`?o00000ooPgn<2o`0000Goh=oS
0_l00002on3Oh`?o00000_oPgn<2o`0000Coh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oS
on3Oh`03o`0000?oh=oS0_l00002on3Oh`;o000000?oh=oSo`000?oPgn<01_oPgn<3o`0000;oh=oS
0_l000000ooPgn?o0000on3Oh`04o`0000;oh=oS0_l00005on3Oh`?o00000ooPgn<3o`0000;oh=oS
00?o0000on3Ohol000000_oPgn<2o`0000Koh=oS0ol00003on3Oh`?o00000_oPgn<01?l0003oh=oS
o`000?l00002on3Oh`04o`000?oPgn?o0000o`0000?oh=oS0ol00002on3Oh`;o00001?oPgn<4o`00
00?oh=oS0ol00006on3Oh`?o00000ooPgn<3o`0000;oh=oS00Co0000on3Ohol0003o00000_oPgn<0
1Ol0003oh=oSon3OhooPgn?o000000;oh=oS0ol00002on3Oh`;o000000?oh=oSo`000?l000000_oP
gn<3o`0000?oh=oS1?l00007on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Co0000on3Ohol0003o0000
0ooPgn<3o`0000?oh=oS0ol00002on3Oh`04o`000?oPgn?oh=oSo`0000Goh=oS0_l000000ooPgn?o
0000on3Oh`02o`0000?oh=oS0ol00006on3Oh`?o00000_oPgn<4o`0000;oh=oS0_l000001?oPgn?o
0000on3OhooPgn<3o`0000;oh=oS00Co0000on3Ohol0003o00001OoPgn<4o`0000?oh=oS0ol00002
on3Oh`03o`000?oPgn?oh=oS00?o00000_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oP
gn?oh=oS00;oh=oS0_l00002on3Oh`?o00001OoPgn<2o`0000;oh=oS0ol00003on3Oh`Co00000_oP
gn<3o`0000;oh=oS00Co0000on3Ohol0003o00000ooPgn<3o`0000;oh=oS0_l00002on3Oh`?o0000
0_oPgn<2o`0000;oh=oS0ol0000Qon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oP
gn<01Ol0003oh=oSon3OhooPgn?o000000Coh=oS00?o0000on3OhooPgn<0:OoPgn<00ol0003oh=oS
on3Oh`0Aon3Oh`03o`000?oPgn?oh=oS00coh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oS
on3Oh`0:on3Oh`04o`000?oPgn?oh=oSo`0001Ooh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003o
h=oSo`00000Won3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<0;OoPgn<00ol0003o
h=oSon3Oh`0:on3Oh`03o`000?oPgn?oh=oS00Goh=oS00?o0000on3OhooPgn<01?oPgn<00ol0003o
h=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS00Koh=oS00Co0000on3OhooPgn?o00006_oPgn<00ol0
003oh=oSon3Oh`0Aon3Oh`03o`000?oPgn?oh=oS00Woh=oS00?o0000on3OhooPgn<04?oPgn<00ol0
003oh=oSon3Oh`0con3Oh`03o`000?oPgn?oh=oS02Goh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWko
nocmofIVOP0<on3Oh`05o`000?oPgn?oh=oSon3Ohol000001?oPgn<00ol0003oh=oSon3Oh`0Yon3O
h`03o`000?oPgn?oh=oS017oh=oS00?o0000on3OhooPgn<03?oPgn<00ol0003oh=oSon3Oh`02on3O
h`03o`000?oPgn?oh=oS00[oh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSon3Oh`0A
on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3Ohol000009ooPgn<00ol0003oh=oSon3Oh`03
on3Oh`03o`000?oPgn?oh=oS02goh=oS00?o0000on3OhooPgn<02_oPgn<00ol0003oh=oSon3Oh`05
on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3Ohol000004OoPgn<00ol0003oh=oSon3Oh`06
on3Oh`04o`000?oPgn?oh=oSo`0001[oh=oS00?o0000on3OhooPgn<04OoPgn<00ol0003oh=oSon3O
h`09on3Oh`03o`000?oPgn?oh=oS013oh=oS00?o0000on3OhooPgn<0<ooPgn<00ol0003oh=oSon3O
h`0Uon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<4o`0000?oh=oS00?o0000
on3OhooPgn<0:ooPgn<00ol0003oh=oSon3Oh`0Bon3Oh`03o`000?oPgn?oh=oS00_oh=oS1Ol0000A
on3Oh`?o00003?oPgn<00ol0003oh=oSon3Oh`0Gon3Oh`03o`000?oPgn?o000002goh=oS00?o0000
on3OhooPgn<0>_oPgn<00ol0003oh=oSon3Oh`06on3Oh`Co00000_oPgn<00ol0003oh=oSon3Oh`0?
on3Oh`03o`000?oPgn?oh=oS00Woh=oS00?o0000on3OhooPgn<06ooPgn<00ol0003oh=oSon3Oh`0>
on3Oh`03o`000?oPgn?oh=oS00Woh=oS00?o0000on3OhooPgn<0K_oPgn<1ofIVOP7onocm0OmVIWh0
0003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?oo
h=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm
0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?go
IVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIV
OP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIV
O_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oP
gn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh0
0003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?oo
h=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm
0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?go
IVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIV
OP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS3OlLDH1`on3Oh`;o0000oooPgn=Fon3Oh`7o
IVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<02OlLDH3olO7_oo?clOoemOComoOfooWi
n?okno[ooOglooknoP03ooooo`03oaaAP?oPgn?oh=oS073oh=oS00?o0000on3OhooPgn<0oooPgn=C
on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<02_lLDH3okno/oo7akooclo7o
mOGdooOgm_oinOSono_joogmo?ono_h2ooooo`03oaaAP?oPgn?oh=oS00;oh=oS00?o0000on3OhooP
gn<01?oPgn<01?l0003oh=oSon3OhooPgn<3o`0000?oh=oS0_l00003on3Oh`?o00000_oPgn<00ol0
003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS00;oh=oS0ol00006on3Oh`?o00000ooPgn<2o`00
0004on3Ohol0003oh=oSon3Oh`;o00000ooPgn<00ol0003oh=oSon3Oh`03o`0000;oh=oS00Co0000
on3OhooPgn?o00000_oPgn<01?l0003oh=oSo`000?oPgn<4o`0000;oh=oS0ol00003on3Oh`Co0000
1OoPgn<2o`0000?oh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSon3Oh`03o`0000Ko
h=oS0_l00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<3o`0000?oh=oS0ol00003on3O
h`03o`000?oPgn?oh=oS0?ooh=oS;?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Go
h=oS00go7560onc/jOo_kncolO7_oo?clOoemOComoOfooWin?okno[ooOglookno_oooooo756000Co
h=oS00?o0000on3OhooPgn<01?oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o0000
00;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000004on3Oh`05o`000?oPgn?oh=oS
on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oS
o`000002on3Oh`;o000000Ooh=oSo`000?oPgn?oh=oSo`000?oPgn?o000000;oh=oS00Oo0000on3O
hooPgn?oh=oSo`000?oPgn?o000000;oh=oS00So0000on3OhooPgn?o0000on3Ohol0003oh=oSo`00
00Coh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oP
gn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS0_l00002on3Oh`03o`000?oPgn?o000000?o
h=oS00?o0000on3OhooPgn<00_oPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS00?o0000
on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o00000?ooh=oS;ooPgn<1
ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00go7560onSXiOo/k>Wokno/oo7akooc
lo7omOGdooOgm_oinOSono_joogmo?ono_ko756000Coh=oS00?o0000on3OhooPgn<01?oPgn<01?l0
003oh=oSon3Ohol00007on3Oh`04o`000?oPgn?oh=oSo`0000Goh=oS00Oo0000on3OhooPgn?oh=oS
o`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003oh=oSon3Oh`03on3Oh`05
o`000?oPgn?oh=oSon3Ohol000000ooPgn<01?l0003oh=oSon3Ohol00002on3Oh`07o`000?oPgn?o
h=oSon3Ohol0003oh=oSo`000002on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o00000_oPgn<01Ol0
003oh=oSon3OhooPgn?o000000Goh=oS00Go0000on3OhooPgn?oh=oSo`000006on3Oh`04o`000?oP
gn?oh=oSo`0000;oh=oS00So0000on3OhooPgn?o0000on3Ohol0003oh=oSo`0000[oh=oS00Co0000
on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000005on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o
0000on3OhooPgn<0oooPgn<]on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<0
3OlLDH3oiNGRonSXiOo/k>Wokno/oo7akooclo7omOGdooOgm_oinOSono_joogmo?lLDH001?oPgn<0
0ol0003oh=oSon3Oh`04on3Oh`03o`000?oPgn?oh=oS00Go00000_oPgn<01?l0003oh=oSon3OhooP
gn<5o`000003on3Ohol0003oh=oS00;oh=oS00?o0000on3Ohol000000_oPgn<5o`0000Coh=oS00?o
0000on3OhooPgn<00ooPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS00Go0000on3OhooPgn?o
h=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`06o`000?oPgn?o
h=oSo`000?oPgn?o00000ooPgn<00ol0003oh=oSon3Oh`05o`000003on3Ohol0003oh=oS00;oh=oS
00?o0000on3OhooPgn<00ooPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS00Oo0000on3OhooP
gn?o0000on3Ohol0003oh=oS00Go00001OoPgn<01Ol0003oh=oSon3OhooPgn?o000000?oh=oS00?o
0000on3Ohol000001?l000000ooPgn?o0000o`000003o`000003on3Ohol0003oh=oS0?ooh=oS;_oP
gn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00go7560on;Rg_oUiN;oj>SUonc/
jOo_kncolO7_oo?clOoemOComoOfooWin?okno[o756000Coh=oS1Ol00002on3Oh`04o`000?oPgn?o
h=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oP
gn?o000000;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3OhooP
gn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002
on3Oh`03o`000?oPgn?o000000;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS
00Ko0000on3OhooPgn?o0000on3Ohol00004on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3O
hol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o00000_oP
gn<02?l0003oh=oSon3Ohol0003oh=oSo`000?oPgn?o00000ooPgn<00ol0003oh=oSon3Oh`02on3O
h`05o`000?oPgn?oh=oSo`000?oPgn<00_l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000
on3Ohol000000ooPgn<00ol0003oh=oSo`00003oon3Ohbooh=oS0OmVIWh1oo_lo@7oIVIn00000omV
IWkonocmofIVOP0Eon3Oh`0=oaaAP?oPh=_oh^;NonGUh_oXj>Gok>cYono_k?oalNoolo?aooGem?og
moKonOWhoaaAP004on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3Ohol0003o00000_oPgn<3
o`0000?oh=oS0_l00003on3Oh`?o00000_oPgn<2o`000003on3Ohol0003oh=oS00;oh=oS00?o0000
on3OhooPgn<00ol00006on3Oh`?o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS0_l0
0002on3Oh`;o00000_oPgn<3o`0000;oh=oS0ol000000ooPgn?o0000o`000002on3Oh`03o`000?oP
gn?o000000?o00000_oPgn<3o`0000?oh=oS1?l00005on3Oh`;o00000_oPgn<2o`000007on3Ohol0
003oh=oSon3Ohol0003oh=oSo`000002on3Oh`?o00001_oPgn<2o`0000;oh=oS00Co0000on3Ohol0
003o00000ooPgn<3o`0000?oh=oS0ol00002on3Oh`;o0000oooPgn<^on3Oh`7oIVIn0Ooko?d1ofIV
OP0000?oIVInoo_loOmVIWh05OoPgn<03OlLDH3og]kIon3PfooRh]koiNGRonSXiOo/k>Wokno/oo7a
kooclo7omOGdooOgm_lLDH001?oPgn<00ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS03Ko
h=oS00?o0000on3OhooPgn<07ooPgn<00ol0003oh=oSon3Oh`07on3Oh`03o`000?oPgn?oh=oS00Go
h=oS00?o0000on3OhooPgn<03OoPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS0?oo
h=oS;OoPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00go7560omcLeooNg]Wo
h>3Kon;Rg_oUiN;oj>SUonc/jOo_kncolO7_oo?clOoemOCo756000Coh=oS00?o0000on3OhooPgn<0
0_oPgn<00ol0003oh=oSon3Oh`0fon3Oh`03o`000?oPgn?oh=oS01ooh=oS00?o0000on3OhooPgn<0
1ooPgn<00ol0003oh=oSon3Oh`05on3Oh`03o`000?oPgn?oh=oS00goh=oS00?o0000on3OhooPgn<0
3ooPgn<00ol0003oh=oSon3Oh`3oon3Ohbgoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIV
OP0Eon3Oh`0=oaaAP?oLg=Oog=cGomkNfOoPh=_oh^;NonGUh_oXj>Gok>cYono_k?oalNoolo?aoaaA
P004on3Oh`Go0000B_oPgn<00ol0003oh=oSon3Oh`0>on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o
0000on3OhooPgn<03OoPgn<00ol0003oh=oSon3Oh`3oon3Ohcooh=oS0OmVIWh1oo_lo@7oIVIn0000
0omVIWkonocmofIVOP0Eon3Oh`0=oaaAP?oLg=Oog=cGomcLeooNg]Woh>3Kon;Rg_oUiN;oj>SUonc/
jOo_kncolO7_oaaAP03oon3OhlSoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0Eon3O
h`go7560oooPgn?8on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7o
IVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?o
IVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Z
on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIV
OP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0
9?oPgn<4o`0002[oh=oS0_l0003oon3OhiKoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIV
OP0Xon3Oh`03o`000?oPgn?oh=oS02Woh=oS00?o0000on3OhooPgn<0oooPgn>Con3Oh`7oIVIn0Ook
o?d1ofIVOP0000?oIVInoo_loOmVIWh03OoPgn<3o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`00
0002on3Oh`Co000000?oh=oSo`000?oPgn<00_oPgn<00ol0003oh=oSon3Oh`04o`0000;oh=oS0ol0
0003on3Oh`Co00001OoPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00?o00001_oP
gn<2o`0000?oh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSon3Oh`03o`0000Koh=oS
1?l00002on3Oh`?o00000_oPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS00?o0000on3O
hol000000_oPgn<00ol0003oh=oSo`000002on3Oh`?o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o
000000;oh=oS0_l00005on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00ooPgn<0
0ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS0_l00005on3Oh`05o`000?oPgn?o
h=oSon3Ohol000000_oPgn<3o`0000?oh=oS00?o0000on3OhooPgn<00ol00002on3Oh`Co00000ooP
gn<3o`0000?oh=oS0ol00002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`00003oon3Oh`Wo
h=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0<on3Oh`07o`000?oPgn?oh=oSon3Ohol0
003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0
003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0
003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000ooPgn<0
0ol0003oh=oSon3Oh`02on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o00000ooPgn<2o`0000;oh=oS
00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0
003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00?o0000on3Ohol000000ooPgn<01Ol0
003oh=oSo`000?oPgn?o000000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003
on3Oh`03o`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oSo`000003
on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00000ooPgn<01Ol0003oh=oSo`00
0?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3O
hol000000ooPgn<00ol0003oh=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`00
0003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`00
0002on3Oh`03o`000?oPgn?oh=oS0?ooh=oS2_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?go
IVIn00coh=oS00?o0000on3OhooPgn<00ooPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol00000
1OoPgn<01Ol0003oh=oSon3OhooPgn?o000000Coh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0
003oh=oSo`00000:on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00So0000on3OhooPgn?o0000on3O
hol0003oh=oSo`0000Soh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000Goh=oS00Ko0000
on3OhooPgn?o0000on3Ohol00003on3Oh`05o`000?oPgn?o0000on3Ohol000000_oPgn<00ol0003o
h=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00Go0000on3OhooPgn?oh=oSo`000005on3O
h`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol00003
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00ooPgn<01ol0003oh=oSon3OhooP
gn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00?oh=oS
00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<01Ol0
003oh=oSo`000?oPgn?o00000?ooh=oS3OoPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn
00coh=oS00?o0000on3OhooPgn<00ooPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS1?l00000
0ooPgn?o0000on3Oh`02on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000001?l00000
0ooPgn?o0000on3Oh`02on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00000ooP
gn<00ol0003oh=oSo`000004o`0000Goh=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`07o`00
0?oPgn?oh=oSo`000?oPgn?o0000on3Oh`05o`0000Coh=oS00Ko0000on3OhooPgn?oh=oSo`000?oP
gn<5o`000007on3Ohol0003oh=oSon3Ohol0003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3O
hol000000_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00Co0000on3O
hooPgn?o00001_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000
on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Oo
0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<5o`000003
on3Ohol0003oh=oS00;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`04
o`000?oPgn?o0000o`000?ooh=oS3_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00co
h=oS00Ko0000on3OhooPgn?oh=oSo`000?oPgn<2o`0000;oh=oS00?o0000on3OhooPgn<00ooPgn<0
1?l0003oh=oSo`000?l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooP
gn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<00_l0
0002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01_l0003oh=oSon3O
hol0003oh=oSo`0000;oh=oS00So0000on3OhooPgn?o0000on3Ohol0003oh=oSo`0000?oh=oS00?o
0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003o
h=oSo`000002on3Oh`04o`000?oPgn?o0000o`0000;oh=oS00Go0000on3Ohol0003oh=oSo`000002
on3Oh`03o`000?oPgn?o000000?oh=oS00Co0000on3Ohol0003o00000_oPgn<00ol0003oh=oSo`00
0002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3Ohol0003o00000_oPgn<00ol0003oh=oS
on3Oh`02on3Oh`03o`000?oPgn?oh=oS00;o00000_oPgn<01Ol0003oh=oSo`000?oPgn?o000000;o
h=oS00?o0000on3OhooPgn<00_oPgn<2o`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003o
h=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o
000000?oh=oS00?o0000on3Ohol000000ooPgn<01Ol0003oh=oSo`000?oPgn?o00000?ooh=oS3OoP
gn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00goh=oS0ol00002on3Oh`04o`000?oPgn?o
0000o`0000?oh=oS0ol00002on3Oh`04o`000?oPgn?o0000o`0000?oh=oS1?l00002on3Oh`?o0000
0ooPgn<4o`0000Coh=oS0_l000000ooPgn?o0000on3Oh`02o`0000?oh=oS0ol00006on3Oh`;o0000
0_oPgn<2o`000007on3Ohol0003oh=oSon3Ohol0003oh=oSo`000002on3Oh`?o00001_oPgn<4o`00
00;oh=oS0ol00002on3Oh`;o000000Goh=oSo`000?oPgn?o0000on3Oh`02o`0000;oh=oS00Ko0000
on3Ohol0003o0000on3Ohol00002on3Oh`?o00000_oPgn<01?l0003oh=oSo`000?l00003on3Oh`;o
00001OoPgn<01?l0003oh=oSo`000?oPgn<2o`0000Goh=oS0_l000000ooPgn?o0000on3Oh`02o`00
00;oh=oS00?o0000on3OhooPgn<00_l00005on3Oh`04o`000?oPgn?o0000o`0000?oh=oS0ol00002
on3Oh`;o00000_oPgn<3o`0000;oh=oS1?l00003on3Oh`?o00000ooPgn<3o`0000;oh=oS00Co0000
on3OhooPgn?o0000oooPgn<<on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh04_oPgn<0
0ol0003oh=oSon3Oh`0Oon3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00004ooP
gn<00ol0003oh=oSon3Oh`05on3Oh`03o`000?oPgn?oh=oS00coh=oS00?o0000on3OhooPgn<01OoP
gn<00ol0003oh=oSon3Oh`0:on3Oh`03o`000?oPgn?oh=oS027oh=oS00Co0000on3OhooPgn?o0000
6ooPgn<00ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<0
oooPgn<=on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh04_oPgn<00ol0003oh=oSon3O
h`0Oon3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00004ooPgn<00ol0003oh=oS
on3Oh`05on3Oh`03o`000?oPgn?oh=oS00coh=oS00?o0000on3OhooPgn<01OoPgn<00ol0003oh=oS
on3Oh`0:on3Oh`03o`000?oPgn?oh=oS027oh=oS00Co0000on3OhooPgn?o00006ooPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<0oooPgn<=on3Oh`7o
IVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh04_oPgn<00ol0003oh=oSon3Oh`0Oon3Oh`03o`00
0?oPgn?oh=oS00Goh=oS00?o0000on3OhooPgn<06OoPgn<00ol0003oh=oSon3Oh`0<on3Oh`03o`00
0?oPgn?oh=oS00Koh=oS00?o0000on3Ohol000001ooPgn<00ol0003oh=oSon3Oh`02on3Oh`03o`00
0?oPgn?oh=oS01?oh=oS00?o0000on3OhooPgn<02ooPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`00
0?oPgn?oh=oS01coh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003oh=oSon3Oh`3oon3Oh`goh=oS
0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn0000
0omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP1Con3O
h`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<0AOoPgn<00ol0003oh=oSon3Oh`0jon3O
h`;o0000JOoPgn<00ol0003oh=oSon3Oh`13on3Oh`;o00003_oPgn<2o`0004Soh=oS0OmVIWh1oo_l
o@7oIVIn00000omVIWkonocmofIVOP1Con3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooP
gn<0AOoPgn<00ol0003oh=oSon3Oh`0lon3Oh`03o`000?oPgn?oh=oS06Koh=oS00?o0000on3OhooP
gn<0AOoPgn<00ol0003oh=oSon3Oh`0=on3Oh`03o`000?oPgn?oh=oS04Goh=oS0OmVIWh1oo_lo@7o
IVIn00000omVIWkonocmofIVOP0>on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?o
h=oSo`000?oPgn?o000000;oh=oS0_l00007on3Oh`03o`000?oPgn?oh=oS00;oh=oS0ol00002on3O
h`04o`000?oPgn?oh=oSon3Oh`;o00000_oPgn<00ol0003oh=oSon3Oh`03o`0000;oh=oS00Go0000
on3OhooPgn?oh=oSo`000005on3Oh`;o00000ooPgn<2o`000003on3Ohol0003oh=oS00Co00000_oP
gn<4o`0000?oh=oS0ol00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<2o`0000Koh=oS
1?l00004on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<00ol00002on3Oh`04
o`000?oPgn?oh=oSon3Oh`?o00001_oPgn<2o`0000?oh=oS0ol00002on3Oh`Co00000_oPgn<01ol0
003oh=oSon3OhooPgn?o0000on3Ohol000000_oPgn<2o`0000?oh=oS00?o0000on3Ohol000000_oP
gn<3o`0000?oh=oS1?l00002on3Oh`03o`000?oPgn?oh=oS00?o00000ooPgn<4o`0000Goh=oS0_l0
0003on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3OhooPgn<00ol00006on3Oh`;o0000
0_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS0ol00003on3Oh`?o00000ooPgn<00ol0003o
h=oSo`000006on3Oh`Co00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS0ol00003on3O
h`?o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000Goh=oS00?o0000on3Ohol000000ooPgn<0
0ol0003oh=oSon3Oh`03o`0000Koh=oS0ol00002on3Oh`Co00000ooPgn<00ol0003oh=oSo`000002
on3Oh`?o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000Coh=oS1?l00003on3Oh`?o00000_oP
gn<00ol0003oh=oSon3Oh`03o`0000?oh=oS00Go0000on3OhooPgn?oh=oSo`000006on3Oh`?o0000
0_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`04on3O
h`03o`000?oPgn?o000000Koh=oS00?o0000on3OhooPgn<00_oPgn<3o`0000?oh=oS0_l000000ooP
gn?o0000on3Oh`03on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<4o`0000?oh=oS00?o0000
on3OhooPgn<00_oPgn<3o`0001ooh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0>on3O
h`03o`000?oPgn?oh=oS00;oh=oS00Wo0000on3OhooPgn?oh=oSo`000?oPgn?o0000on3Ohol00000
0_oPgn<00ol0003oh=oSon3Oh`04on3Oh`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<00ol0003o
h=oSo`000002on3Oh`08o`000?oPgn?oh=oSo`000?oPgn?o0000on3Ohol00003on3Oh`03o`000?oP
gn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000;o
h=oS0_l000000ooPgn?o0000on3Oh`02on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol0
00000ooPgn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3O
hooPgn<00_oPgn<01Ol0003oh=oSon3OhooPgn?o000000Coh=oS00Co0000on3OhooPgn?o00000_oP
gn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00Go0000on3OhooPgn?oh=oS
o`000004on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o00000ooPgn<00ol0003oh=oSo`000003on3O
h`03o`000?oPgn?o000000?oh=oS00Go0000on3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?o
000000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o
000000;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<0
0_oPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS0_l00002on3Oh`03o`000?oPgn?o0000
00?oh=oS00?o0000on3OhooPgn<00_oPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000Soh=oS00?o
0000on3OhooPgn<00_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Co
0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS
00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0
003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01ol0
003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<01Ol0003oh=oSo`000?oPgn?o000000?oh=oS
00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSon3Oh`03on3Oh`07o`000?oPgn?oh=oSon3O
hol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS0_l00005on3Oh`03o`000?oPgn?o
000000Koh=oS0_l00002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`;o0000
1?oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<01Ol0003oh=oSon3OhooPgn?o
000000?oh=oS00Go0000on3OhooPgn?oh=oSo`00000Non3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVIn
oo_loOmVIWh03_oPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oS
o`000003on3Oh`03o`000?oPgn?oh=oS00Coh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oS
on3Oh`03on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00003on3O
h`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<01?oPgn<01?l0003oh=oSon3Ohol00003
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003
on3Oh`03o`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oSon3Oh`03
on3Oh`05o`000?oPgn?oh=oSon3Ohol000001?oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`00
0?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`08on3Oh`04o`00
0?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03
o`000?oPgn?o000000?oh=oS00Co0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSo`000005on3O
h`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Go
0000on3OhooPgn?oh=oSo`000006on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00So0000on3OhooP
gn?o0000on3Ohol0003oh=oSo`0000[oh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oS
o`000005on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003oh=oS
on3Oh`04on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000005on3Oh`03o`000?oPgn?oh=oS
00?oh=oS00?o0000on3Ohol000001_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o
000000Soh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol00000
0_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<0
0_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000001OoPgn<00ol0003oh=oSo`000003on3O
h`09o`000?oPgn?o0000on3Ohol0003oh=oSo`000?oPgn?o000000Coh=oS00Oo0000on3OhooPgn?o
h=oSo`000?oPgn?o000000?oh=oS00Go0000on3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?o
h=oS00;oh=oS00?o0000on3Ohol000001OoPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS
00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0
003oh=oSo`000003on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o00000_oPgn<00ol0003oh=oSon3O
h`0Pon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03_oPgn<00ol0003oh=oSon3Oh`02
on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00Goh=oS
00?o0000on3Ohol000000_oPgn<5o`000003on3Ohol0003oh=oS00;oh=oS00Oo0000on3OhooPgn?o
h=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`03on3O
h`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o
000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`05o`000?oPgn?o
h=oSon3Ohol000001ooPgn<4o`0000Coh=oS00Co0000on3OhooPgn?o00000_oPgn<00ol0003oh=oS
o`000003on3Oh`03o`000?oPgn?o000000;oh=oS1Ol00005on3Oh`05o`000?oPgn?oh=oSon3Ohol0
00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol0
00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS00?o0000on3Ohol000001_oPgn<4o`00
0004on3Ohol0003oh=oSon3Oh`Go000000?oh=oSo`000?oPgn<00_oPgn<00ol0003oh=oSon3Oh`03
on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<01ol0003oh=oSon3Ohol0003oh=oSo`000?oP
gn<01Ol00005on3Oh`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<00ol0003oh=oSo`000004o`00
0003on3Ohol0003o000000?o000000?oh=oSo`000?oPgn<01ooPgn<00ol0003oh=oSon3Oh`04on3O
h`06o`000?oPgn?oh=oSon3Ohol0003oh=oS1Ol000000ooPgn?o0000on3Oh`04on3Oh`;o00001ooP
gn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000Co00001?oPgn<01ol0003oh=oS
on3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?o0000
00?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`06o`000?oPgn?oh=oS
on3Ohol0003oh=oS1Ol000001?oPgn?o0000on3Ohol00003on3Oh`09o`000?oPgn?o0000on3Ohol0
003oh=oSo`000?oPgn?o000000Coh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS
00Go0000on3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3Ohol0
00001OoPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS00?o0000on3Ohol000000ooPgn<0
0ol0003oh=oSon3Oh`02on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<4o`0000;oh=oS00?o
0000on3Ohol000000_oPgn<5o`0001koh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0>
on3Oh`03o`000?oPgn?oh=oS00;oh=oS0_l00002on3Oh`05o`000?oPgn?o0000on3Ohol000000_oP
gn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03
o`000?oPgn?o000000;oh=oS00So0000on3OhooPgn?o0000on3Ohol0003oh=oSo`0000?oh=oS00Co
0000on3Ohol0003o00000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`06o`000?oPgn?oh=oSo`000?oP
gn?o00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3O
hol000000ooPgn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000
on3OhooPgn<01_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`05o`000?oPgn?oh=oSon3Ohol00000
1?oPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000?oh=oS00?o0000on3Ohol000000ooPgn<01?l0
003oh=oSo`000?l00002on3Oh`05o`000?oPgn?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`00
0002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSo`00
0002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;o
h=oS00Ko0000on3OhooPgn?o0000on3Ohol00002on3Oh`08o`000?oPgn?oh=oSo`000?oPgn?o0000
on3Ohol00003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Go0000on3OhooPgn?o0000on3Oh`02o`00
00;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o0000
00Soh=oS00?o0000on3OhooPgn<01?oPgn<2o`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0
003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3Ohol000001_oPgn<00ol0003oh=oSon3Oh`02
o`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?o
h=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00?o0000on3Ohol00000
0ooPgn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooP
gn?oh=oSo`000?oPgn?o000000?oh=oS00Go0000on3Ohol0003oh=oSo`000003on3Oh`03o`000?oP
gn?o000000;oh=oS00Co0000on3OhooPgn?o00001?oPgn<01_l0003oh=oSon3OhooPgn?o0000on3O
h`;o00000_oPgn<01Ol0003oh=oSo`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00_oPgn<0
0ol0003oh=oSo`000005on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o00000ooPgn<00ol0003oh=oS
o`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS0_l00002on3Oh`03o`000?oPgn?oh=oS00?oh=oS
00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS01coh=oS
0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0>on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co
0000on3Ohol0003o00000_oPgn<00ol0003oh=oSon3Oh`02o`0000Goh=oS00Go0000on3OhooPgn?o
h=oSo`000002on3Oh`?o00000_oPgn<2o`0000;oh=oS0_l00002on3Oh`03o`000?oPgn?oh=oS00?o
00000_oPgn<01?l0003oh=oSo`000?l00006on3Oh`;o00000_oPgn<01_l0003oh=oSon3OhooPgn?o
0000on3Oh`Co00000_oPgn<4o`0000?oh=oS0ol00002on3Oh`;o000000?oh=oSo`000?l000000_oP
gn<2o`0000Koh=oS0ol00005on3Oh`?o000000?oh=oSo`000?l000000ooPgn<3o`0000;oh=oS0_l0
0002on3Oh`?o00001_oPgn<2o`0000?oh=oS0ol00002on3Oh`Co00000_oPgn<01?l0003oh=oSo`00
0?l00002on3Oh`03o`000?oPgn?oh=oS00;o00000_oPgn<2o`000004on3Ohol0003oh=oSon3Oh`?o
00000ooPgn<3o`0000;oh=oS0_l00002on3Oh`?o00000ooPgn<4o`0000Goh=oS0_l00002on3Oh`;o
000000Ooh=oSo`000?oPgn?oh=oSo`000?oPgn?o000000;oh=oS0ol00006on3Oh`;o00000_oPgn<0
1?l0003oh=oSo`000?l00003on3Oh`?o00000ooPgn<3o`0000;oh=oS0_l00007on3Oh`03o`000?oP
gn?oh=oS00Coh=oS00Co0000on3Ohol0003o00000ooPgn<3o`0000?oh=oS0ol00002on3Oh`04o`00
0?oPgn?oh=oSo`0000Goh=oS0_l000000ooPgn?o0000on3Oh`02o`0000?oh=oS0ol00006on3Oh`?o
00000_oPgn<4o`0000;oh=oS0_l000001?oPgn?o0000on3OhooPgn<3o`0000;oh=oS00Co0000on3O
hol0003o00001OoPgn<4o`0000?oh=oS0ol00002on3Oh`03o`000?oPgn?oh=oS00?o00000_oPgn<0
1?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?oh=oS00?oh=oS0ol00002on3Oh`04o`000?oP
gn?o0000o`0000;oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`00
0?oPgn?o0000o`0000Coh=oS00Co0000on3OhooPgn?o00000_oPgn<3o`0000;oh=oS00Go0000on3O
hooPgn?oh=oSo`000004on3Oh`04o`000?oPgn?o0000o`0000?oh=oS0ol00002on3Oh`05o`000?oP
gn?oh=oSon3Ohol000000_oPgn<3o`0001ooh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIV
OP0>on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<0D_oPgn<00ol0003oh=oSon3O
h`0lon3Oh`03o`000?oPgn?oh=oS00[oh=oS00?o0000on3OhooPgn<03_oPgn<00ol0003oh=oSon3O
h`0:on3Oh`03o`000?oPgn?oh=oS00Ooh=oS00?o0000on3OhooPgn<01OoPgn<00ol0003oh=oSon3O
h`0=on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003oh=oSon3O
h`04on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<01_oPgn<01?l0003oh=oSon3O
hol0000Jon3Oh`03o`000?oPgn?oh=oS017oh=oS00?o0000on3OhooPgn<02OoPgn<00ol0003oh=oS
on3Oh`0Lon3Oh`03o`000?oPgn?oh=oS00Woh=oS00?o0000on3OhooPgn<05ooPgn<00ol0003oh=oS
on3Oh`0bon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03_oPgn<00ol0003oh=oSon3O
h`02on3Oh`03o`000?oPgn?oh=oS05;oh=oS00?o0000on3OhooPgn<0??oPgn<00ol0003oh=oSon3O
h`0:on3Oh`03o`000?oPgn?oh=oS00koh=oS00?o0000on3OhooPgn<02_oPgn<00ol0003oh=oSon3O
h`07on3Oh`03o`000?oPgn?oh=oS00Goh=oS00?o0000on3OhooPgn<03OoPgn<00ol0003oh=oSon3O
h`0?on3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oSo`00
000Aon3Oh`03o`000?oPgn?oh=oS00Koh=oS00Co0000on3OhooPgn?o00006_oPgn<00ol0003oh=oS
on3Oh`0Aon3Oh`03o`000?oPgn?oh=oS00Woh=oS00?o0000on3OhooPgn<07?oPgn<00ol0003oh=oS
on3Oh`09on3Oh`03o`000?oPgn?oh=oS01Ooh=oS00?o0000on3OhooPgn<0<_oPgn<1ofIVOP7onocm
0OmVIWh00003ofIVO_oko?goIVIn00coh=oS1Ol00002on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o
0000on3OhooPgn<06ooPgn<00ol0003oh=oSon3Oh`1]on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o
0000on3OhooPgn<01ooPgn<00ol0003oh=oSon3Oh`0Hon3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o
0000on3OhooPgn<03OoPgn<00ol0003oh=oSon3Oh`0Ion3Oh`Co00000_oPgn<00ol0003oh=oSon3O
h`0?on3Oh`03o`000?oPgn?oh=oS00Woh=oS00?o0000on3OhooPgn<06ooPgn<00ol0003oh=oSon3O
h`0>on3Oh`03o`000?oPgn?oh=oS00Woh=oS00?o0000on3OhooPgn<07?oPgn<00ol0003oh=oSon3O
h`07on3Oh`04o`000?oPgn?oh=oSo`0001Soh=oS00?o0000on3OhooPgn<0<_oPgn<1ofIVOP7onocm
0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?go
IVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIV
OP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIV
O_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oP
gn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh0
0003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?oo
h=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm
0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?go
IVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIV
OP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS3OlLDH0mon3Oh`03o`000?oPgn?oh=oS0?oo
h=oSR?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00Wo7560oo7akooclo7o
mOGdooOgm_oinOSono_joogmo?ono_h00oooool00olLDH3oh=oSon3Oh`0kon3Oh`03o`000?oPgn?o
h=oS0?ooh=oSR?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00[o7560ono_
k?oalNoolo?aooGem?ogmoKonOWhoo_kn_omoOcoo_kn0_ooool00olLDH3oh=oSon3Oh`03on3Oh`Co
00000ooPgn<3o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS
00;oh=oS0ol00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000001OoPgn<4o`0000Coh=oS0_l00000
1_oPgn?o0000on3OhooPgn?o0000on3Oh`Co00000ooPgn<2o`000005on3Ohol0003oh=oSon3Ohol0
00001OoPgn<3o`0000?oh=oS0ol00002on3Oh`03o`000?oPgn?o000000;oh=oS0_l00006on3Oh`03
o`000?oPgn?oh=oS00?o00001_oPgn<3o`0000Coh=oS00?o0000on3OhooPgn<01?l000000ooPgn?o
0000on3Oh`02on3Oh`03o`000?oPgn?oh=oS00Co00000_oPgn<4o`000003on3Ohol0003oh=oS00;o
h=oS1?l000000ooPgn?o0000on3Oh`05on3Oh`?o00000_oPgn<01?l0003oh=oSon3Ohol00002on3O
h`04o`000?oPgn?oh=oSo`000?ooh=oS5?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn
01Goh=oS00go7560onc/jOo_kncolO7_oo?clOoemOComoOfooWin?okno[ooOglookno_oooooo7560
00Coh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o0000
00?oh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oS
o`000002on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oS
on3Ohol00002on3Oh`;o000000Goh=oSo`000?oPgn?oh=oSo`000003on3Oh`03o`000?oPgn?o0000
00;oh=oS0_l000000ooPgn?o0000on3Oh`04on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`00
0003on3Oh`07o`000?oPgn?o0000on3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00;o
h=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`05o`000?oPgn?oh=oS
on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000?oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00Oo
0000on3OhooPgn?oh=oSo`000?oPgn?o000000Goh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o
000000;oh=oS00Co0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`3oon3Oha;oh=oS0OmV
IWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0Eon3Oh`0=oaaAP?oXj>Gok>cYono_k?oalNoolo?a
ooGem?ogmoKonOWhoo_kn_omoOcoo_knoaaAP004on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Oo0000
on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00002on3O
h`03o`000?oPgn?oh=oS00?oh=oS00Co0000on3OhooPgn?o00001OoPgn<00ol0003oh=oSon3Oh`02
on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<01ol0003oh=oSon3O
hooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000005on3Oh`03o`000?oPgn?oh=oS00?o
h=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00?o
h=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSon3Oh`06on3Oh`04o`000?oPgn?oh=oS
o`0000;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00Oo0000on3OhooPgn?o
h=oSo`000?oPgn?o000000Goh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS00Co
0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`3oon3Oha;oh=oS0OmVIWh1oo_lo@7oIVIn
00000omVIWkonocmofIVOP0Eon3Oh`0=oaaAP?oUiN;oj>SUonc/jOo_kncolO7_oo?clOoemOComoOf
ooWin?okno[ooOgloaaAP004on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Oo0000on3OhooPgn?oh=oS
o`000?oPgn?o000000?oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00002on3Oh`Go000000Goh=oS
o`000?oPgn?oh=oSo`000005on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o0000
0ooPgn<00ol0003oh=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3O
h`03o`000?oPgn?o000000Goh=oS00?o0000on3OhooPgn<00ooPgn<5o`000004on3Ohol0003oh=oS
o`0000;oh=oS00?o0000on3OhooPgn<01?oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oP
gn?oh=oS00Koh=oS00Co0000on3OhooPgn?o00000ooPgn<4o`000003on3Ohol0003oh=oS00;oh=oS
00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`04o`000005on3Ohol0003oh=oSon3Ohol0
00000ooPgn<00ol0003oh=oSo`000005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002
on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<0oooPgn<Bon3Oh`7oIVIn0Ook
o?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<03OlLDH3oh^;NonGUh_oXj>Gok>cYono_k?oalNoo
lo?aooGem?ogmoKonOWhoo_kn_lLDH001?oPgn<00ol0003oh=oSon3Oh`04on3Oh`06o`000?oPgn?o
h=oSon3Ohol0003oh=oS0_l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<0
0_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000;oh=oS00Oo0000on3OhooP
gn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000001OoPgn<01ol0003oh=oSon3OhooP
gn?o0000on3Ohol000000ooPgn<01ol0003oh=oSo`000?oPgn?o0000on3Ohol000000_oPgn<00ol0
003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3OhooPgn<00ooPgn<3
o`0000?oh=oS00?o0000on3OhooPgn<01?oPgn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oP
gn?o000000?oh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSo`000002on3Oh`06o`000?oP
gn?oh=oSon3Ohol0003oh=oS1?l00002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002
on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<0oooPgn<Bon3Oh`7oIVIn0Ook
o?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<03OlLDH3oh>3Kon;Rg_oUiN;oj>SUonc/jOo_knco
lO7_oo?clOoemOComoOfooWin?lLDH001?oPgn<00ol0003oh=oSon3Oh`05on3Oh`?o00000_oPgn<0
1?l0003oh=oSo`000?l00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<3o`0000;oh=oS
0_l000000ooPgn?o0000o`000004on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o
00000ooPgn<01Ol0003oh=oSo`000?l0003oh=oS00Co00000_oPgn<01_l0003oh=oSon3OhooPgn?o
0000on3Oh`;o00001OoPgn<3o`0000?oh=oS0ol00002on3Oh`03o`000?oPgn?o000000;oh=oS0_l0
0005on3Oh`;o00000_oPgn<3o`0000Goh=oS00?o0000on3OhooPgn<01?oPgn<2o`0000;oh=oS0ol0
0002on3Oh`04o`000?oPgn?o0000o`0000?oh=oS1?l00002on3Oh`?o00000_oPgn<2o`0000;oh=oS
1?l000000ooPgn?o0000on3Oh`05on3Oh`?o00000_oPgn<2o`000005on3Ohol0003o0000o`000?oP
gn<00_l0003oon3OhaGoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0Eon3Oh`0=oaaA
P?oNg]Woh>3Kon;Rg_oUiN;oj>SUonc/jOo_kncolO7_oo?clOoemOComoOfoaaAP004on3Oh`03o`00
0?oPgn?oh=oS01ooh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSon3Oh`02on3Oh`03o`00
0?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<03?oPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`00
0?oPgn?o000000Woh=oS00?o0000on3OhooPgn<02OoPgn<00ol0003oh=oSon3Oh`04on3Oh`03o`00
0?oPgn?oh=oS013oh=oS00?o0000on3OhooPgn<03?oPgn<00ol0003oh=oSo`00003oon3OhbWoh=oS
0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0Eon3Oh`0=oaaAP?oLg=Oog]kIon3PfooRh]ko
iNGRonSXiOo/k>Wokno/oo7akooclo7omOGdoaaAP004on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o
0000on3OhooPgn<06_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o
0000on3OhooPgn<01_oPgn<00ol0003oh=oSon3Oh`0<on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o
0000on3Ohol000002OoPgn<00ol0003oh=oSon3Oh`09on3Oh`05o`000?oPgn?oh=oSon3Ohol00000
0_oPgn<00ol0003oh=oSon3Oh`0@on3Oh`03o`000?oPgn?oh=oS00coh=oS00?o0000on3Ohol00000
oooPgn<Yon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<03OlLDH3og=cGomcL
eooNg]Woh>3Kon;Rg_oUiN;oj>SUonc/jOo_kncolO7_oo?clOlLDH001OoPgn<4o`0002Coh=oS1?l0
000Zon3Oh`03o`000?oPgn?o000001Koh=oS0ol0000Fon3Oh`03o`000?oPgn?oh=oS00coh=oS00?o
0000on3Ohol000001?l0003oon3OhbGoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0E
on3Oh`0=oaaAP?oLg=Oog=cGomcLeooNg]Woh>3Kon;Rg_oUiN;oj>SUonc/jOo_kncolO7_oaaAP03o
on3OhlSoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0Eon3Oh`go7560oooPgn?8on3O
h`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP00
00?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooP
gn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1
ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmV
IWh05OoPgn<=oaaAP3Goh=oS00?o0000on3OhooPgn<0oooPgn>@on3Oh`7oIVIn0Ooko?d1ofIVOP00
00?oIVInoo_loOmVIWh05OoPgn<02OlLDH3olO7_oo?clOoemOComoOfooWin?okno[ooOglooknoP03
ooooo`03oaaAP?oPgn?oh=oS03?oh=oS00?o0000on3OhooPgn<0oooPgn>@on3Oh`7oIVIn0Ooko?d1
ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<02_lLDH3okno/oo7akooclo7omOGdooOgm_oinOSono_j
oogmo?ono_h2ooooo`03oaaAP?oPgn?oh=oS00?oh=oS1?l00003on3Oh`?o00000_oPgn<01Ol0003o
h=oSon3OhooPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<3o`0000;oh=oS00Go0000on3O
hooPgn?oh=oSo`000004on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000ol0
0003on3Oh`;o000000Goh=oSo`000?oPgn?oh=oSo`000005on3Oh`?o00000ooPgn<3o`0000;oh=oS
00?o0000on3Ohol000000_oPgn<2o`0000Koh=oS00?o0000on3OhooPgn<00ol00006on3Oh`?o0000
1?oPgn<00ol0003oh=oSon3Oh`04o`000003on3Ohol0003oh=oS00;oh=oS00?o0000on3OhooPgn<0
1?l00002on3Oh`Co000000?oh=oSo`000?oPgn<00_oPgn<4o`000003on3Ohol0003oh=oS00Goh=oS
0ol00002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00Co0000on3OhooPgn?o0000oooPgn<Lon3O
h`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<03OlLDH3ok>cYono_k?oalNoolo?a
ooGem?ogmoKonOWhoo_kn_omoOcoo_knoooooolLDH001?oPgn<00ol0003oh=oSon3Oh`02on3Oh`03
o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<01Ol0003oh=oSon3OhooPgn?o0000
00?oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00ooP
gn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol00000
0_oPgn<2o`000003on3Ohol0003oh=oS00Coh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o0000
00?oh=oS00Oo0000on3Ohol0003oh=oSo`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<00_oP
gn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Go0000on3OhooPgn?o
h=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0
003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01ol0
003oh=oSon3OhooPgn?o0000on3Ohol000001OoPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol0
00000_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?oh=oS0?ooh=oS6_oPgn<1ofIV
OP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00go7560onSXiOo/k>Wokno/oo7akooclo7o
mOGdooOgm_oinOSono_joogmo?ono_ko756000Coh=oS00?o0000on3OhooPgn<01?oPgn<01ol0003o
h=oSon3OhooPgn?o0000on3Ohol000000ooPgn<01_l0003oh=oSon3Ohol0003oh=oSo`0000;oh=oS
00?o0000on3OhooPgn<00ooPgn<01?l0003oh=oSon3Ohol00005on3Oh`04o`000?oPgn?oh=oSo`00
00?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o0000
00Goh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?o0000
00?oh=oS00?o0000on3OhooPgn<00ooPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o
h=oS00Koh=oS00Co0000on3OhooPgn?o00000_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol0
00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol0
00000_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000001OoPgn<01ol0003oh=oSon3OhooP
gn?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?oh=oS0?oo
h=oS6_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00go7560onGUh_oXj>Go
k>cYono_k?oalNoolo?aooGem?ogmoKonOWhoo_kn_omoOco756000Coh=oS00?o0000on3OhooPgn<0
1?oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<01_l0003oh=oSon3Ohol0003o
h=oSo`0000;oh=oS1Ol000001OoPgn?o0000on3OhooPgn?o000000Goh=oS00Co0000on3OhooPgn?o
00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol0
00001OoPgn<00ol0003oh=oSon3Oh`03on3Oh`Go000000Coh=oSo`000?oPgn?o00000_oPgn<00ol0
003oh=oSon3Oh`04on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3OhooPgn<01_oPgn<0
1?l0003oh=oSon3Ohol00003on3Oh`Co000000?oh=oSo`000?oPgn<00_oPgn<00ol0003oh=oSo`00
0003on3Oh`03o`000?oPgn?oh=oS00Co000000Goh=oSo`000?oPgn?oh=oSo`000003on3Oh`03o`00
0?oPgn?o000000Goh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS00Co0000on3O
hooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`3oon3Oha[oh=oS0OmVIWh1oo_lo@7oIVIn00000omV
IWkonocmofIVOP0Eon3Oh`0=oaaAP?oRh]koiNGRonSXiOo/k>Wokno/oo7akooclo7omOGdooOgm_oi
nOSono_joaaAP004on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Ko0000on3OhooPgn?oh=oSo`000?oP
gn<2o`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oP
gn?o000000;oh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSon3Oh`02o`0000;oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000Goh=oS00Oo
0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00Oo0000on3Ohol0003oh=oSo`000?oPgn?o
000000;oh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oP
gn?oh=oS00?oh=oS0ol00003on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Co0000on3Ohol0003o0000
0_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3Ohol00000
0_oPgn<01_l0003oh=oSon3OhooPgn?o0000on3Oh`Co00000_oPgn<01ol0003oh=oSon3OhooPgn?o
0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?oh=oS0?ooh=oS
6_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn01Goh=oS00go7560on3PfooRh]koiNGR
onSXiOo/k>Wokno/oo7akooclo7omOGdooOgm_oinOSo756000Coh=oS00?o0000on3OhooPgn<01OoP
gn<3o`0000;oh=oS00Co0000on3Ohol0003o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;o
h=oS0ol00002on3Oh`;o000000?oh=oSo`000?l000001?oPgn<01Ol0003oh=oSon3Ohol0003oh=oS
00;o00000_oPgn<4o`0000;oh=oS00Ko0000on3OhooPgn?oh=oSo`000?oPgn<2o`0000Goh=oS0ol0
0003on3Oh`?o00000_oPgn<00ol0003oh=oSo`000002on3Oh`;o00001OoPgn<2o`0000;oh=oS0ol0
0005on3Oh`03o`000?oPgn?oh=oS00Coh=oS0_l00002on3Oh`?o00000_oPgn<01?l0003oh=oSo`00
0?l00003on3Oh`Co00000_oPgn<3o`0000;oh=oS0_l00002on3Oh`Co000000?oh=oSo`000?oPgn<0
1OoPgn<3o`0000;oh=oS0_l000001OoPgn?o0000o`000?l0003oh=oS00;o0000oooPgn<Mon3Oh`7o
IVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh05OoPgn<03OlLDH3og]kIon3PfooRh]koiNGRonSX
iOo/k>Wokno/oo7akooclo7omOGdooOgm_lLDH001?oPgn<00ol0003oh=oSon3Oh`0Oon3Oh`03o`00
0?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<04_oPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`00
0?oPgn?o000000Woh=oS00?o0000on3OhooPgn<02OoPgn<00ol0003oh=oSon3Oh`04on3Oh`03o`00
0?oPgn?oh=oS013oh=oS00?o0000on3OhooPgn<03?oPgn<00ol0003oh=oSo`00003oon3Ohc7oh=oS
0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0Eon3Oh`0=oaaAP?oLg=Oog]kIon3PfooRh]ko
iNGRonSXiOo/k>Wokno/oo7akooclo7omOGdoaaAP004on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o
0000on3OhooPgn<06_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS01;oh=oS00?o
0000on3OhooPgn<03ooPgn<00ol0003oh=oSo`000009on3Oh`03o`000?oPgn?oh=oS00Woh=oS00Go
0000on3OhooPgn?oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS013oh=oS00?o0000on3OhooPgn<0
3?oPgn<00ol0003oh=oSo`00003oon3Ohc7oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIV
OP0Eon3Oh`0=oaaAP?oLg=Oog=cGomkNfOoPh=_oh^;NonGUh_oXj>Gok>cYono_k?oalNoolo?aoaaA
P005on3Oh`Co00008ooPgn<00ol0003oh=oSon3Oh`0Ton3Oh`03o`000?oPgn?o000001Koh=oS0ol0
000Fon3Oh`03o`000?oPgn?oh=oS00coh=oS00?o0000on3Ohol000001?l0003oon3Ohbgoh=oS0OmV
IWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0Eon3Oh`0=oaaAP?oLg=Oog=cGomcLeooNg]Woh>3K
on;Rg_oUiN;oj>SUonc/jOo_kncolO7_oaaAP03oon3OhlSoh=oS0OmVIWh1oo_lo@7oIVIn00000omV
IWkonocmofIVOP0Eon3Oh`go7560oooPgn?8on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmV
IWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn
0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVIn
oo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3O
h`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0oooPgn?Zon3Oh`7oIVIn0Ooko?d1ofIVOP00
00?oIVInoo_loOmVIWh0DooPgn<2o`000?ooh=oSUOoPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_ok
o?goIVIn05Goh=oS00?o0000on3OhooPgn<0oooPgn>Bon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVIn
oo_loOmVIWh03?oPgn<5o`000003on3Ohol0003o000000;o00001ooPgn<01?l0003oh=oSon3OhooP
gn<3o`0000;oh=oS00Co0000on3OhooPgn?o00000_oPgn<01?l0003oh=oSon3Ohol00005on3Oh`;o
000000Coh=oSo`000?oPgn?oh=oS0_l00003on3Oh`?o00000ooPgn<4o`0000Coh=oS1?l00003on3O
h`03o`000?oPgn?oh=oS00Goh=oS1?l00002on3Oh`?o00000_oPgn<01?l0003oh=oSon3OhooPgn<4
o`0000;oh=oS0_l000001?oPgn?o0000on3Ohol00002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?o000000?oh=oS00?o
0000on3Ohol000000_oPgn<2o`0000Ooh=oS00?o0000on3OhooPgn<00_oPgn<3o`0000;oh=oS00Co
0000on3OhooPgn?oh=oS0_l00002on3Oh`03o`000?oPgn?oh=oS00?o00000_oPgn<01ol0003oh=oS
on3OhooPgn?o0000on3Ohol00000oooPgn<Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmV
IWh03?oPgn<00ol0003oh=oSon3Oh`03on3Oh`05o`000?oPgn?oh=oSon3Ohol000001_oPgn<01?l0
003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000;oh=oS00Co0000on3OhooPgn?o00000_oP
gn<00ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS00;o000000Ooh=oSo`000?oPgn?oh=oS
o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`05
o`000?oPgn?oh=oSon3Ohol000000_oPgn<2o`0000Goh=oS00Oo0000on3OhooPgn?oh=oSo`000?oP
gn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol0
00000_oPgn<2o`000004on3Ohol0003oh=oSo`0000Goh=oS00?o0000on3Ohol000000ooPgn<00ol0
003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00Go0000on3Ohol0003oh=oSo`00
0002on3Oh`03o`000?oPgn?oh=oS00Coh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`03o`00
0?oPgn?o000000;oh=oS00So0000on3OhooPgn?o0000on3Ohol0003oh=oSo`0000?oh=oS00?o0000
on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`3oon3Ohb[oh=oS0OmVIWh1oo_lo@7oIVIn00000omV
IWkonocmofIVOP0=on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<00_oPgn<00ol0
003oh=oSon3Oh`03on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<0
1?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Go0000on3OhooPgn?oh=oS
o`000003on3Oh`04o`000?oPgn?oh=oSo`0000Goh=oS00Go0000on3OhooPgn?oh=oSo`000004on3O
h`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo
0000on3OhooPgn?oh=oSo`000?oPgn?o000000Goh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0
003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3Ohol000001OoPgn<00ol0003oh=oSo`000003
on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`00
0003on3Oh`03o`000?oPgn?oh=oS00Coh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3O
h`03on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00003on3Oh`03
o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<0oooPgn<Zon3Oh`7oIVIn0Ooko?d1ofIVOP00
00?oIVInoo_loOmVIWh03_oPgn<01Ol0003oh=oSon3OhooPgn?o000000Coh=oS00?o0000on3OhooP
gn<00ooPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000;oh=oS00Co0000on3O
hooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oP
gn<01?l0003oh=oSon3OhooPgn<5o`000003on3Ohol0003oh=oS00;oh=oS00?o0000on3OhooPgn<0
0_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`02on3O
h`06o`000?oPgn?oh=oSon3Ohol0003oh=oS1Ol000000ooPgn?o0000on3Oh`02on3Oh`Co000000?o
h=oSo`000?oPgn<00_oPgn<01Ol0003oh=oSo`000?oPgn?o000000Goh=oS00?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol0
00000_oPgn<00ol0003oh=oSon3Oh`05on3Oh`03o`000?oPgn?o000000;oh=oS1Ol000000ooPgn?o
0000on3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o
000000?oh=oS00?o0000on3OhooPgn<0oooPgn<Zon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_l
oOmVIWh03ooPgn<01?l0003oh=oSon3Ohol00004on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Co0000
on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS
00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000_oPgn<00ol0
003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01ol0
003oh=oSon3OhooPgn?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oP
gn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000Koh=oS00?o0000on3Ohol0
00000ooPgn<01Ol0003oh=oSo`000?oPgn?o000000Goh=oS00Co0000on3Ohol0003o00000_oPgn<0
0ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS00;o00000_oPgn<01Ol0003oh=oSo`000?oP
gn?o000000;oh=oS00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol0
00000ooPgn<00ol0003oh=oSo`000002on3Oh`08o`000?oPgn?oh=oSo`000?oPgn?o0000on3Ohol0
0003on3Oh`04o`000?oPgn?o0000o`0000;oh=oS00?o0000on3OhooPgn<0oooPgn<Zon3Oh`7oIVIn
0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh04?oPgn<00ol0003oh=oSo`000004on3Oh`03o`000?oP
gn?oh=oS00?oh=oS0_l00002on3Oh`?o00000_oPgn<2o`000005on3Ohol0003o0000o`000?oPgn<0
0_l00005on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<2o`0000?oh=oS0ol00003on3Oh`Co
00001?oPgn<4o`0000;oh=oS00Co0000on3OhooPgn?o00001OoPgn<4o`0000;oh=oS0ol00002on3O
h`;o00000_oPgn<3o`0000;oh=oS00So0000on3OhooPgn?oh=oSo`000?oPgn?o0000on3Oh`;o0000
1?oPgn<01?l0003oh=oSo`000?oPgn<2o`0000Goh=oS0_l000000ooPgn?o0000on3Oh`02o`0000;o
h=oS00?o0000on3OhooPgn<00_l00005on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<3o`00
00;oh=oS0_l00002on3Oh`;o00000_oPgn<00ol0003oh=oSon3Oh`03o`0000;oh=oS00Co0000on3O
hol0003o0000oooPgn<]on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh04?oPgn<00ol0
003oh=oSo`000004on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<0:OoPgn<00ol0
003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<01OoPgn<00ol0
003oh=oSon3Oh`0<on3Oh`03o`000?oPgn?o0000013oh=oS00Co0000on3OhooPgn?o0000oooPgn=L
on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<01ol0003oh=oSon3OhooPgn?o
0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`04on3Oh`03o`000?oPgn?oh=oS02Woh=oS00?o
0000on3OhooPgn<00_oPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS00Goh=oS00?o
0000on3OhooPgn<03?oPgn<00ol0003oh=oSo`00000@on3Oh`04o`000?oPgn?oh=oSo`000?ooh=oS
G?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00goh=oS0ol00002on3Oh`Co00002?oP
gn<00ol0003oh=oSon3Oh`0Xon3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<03ooP
gn<00ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00_oh=oS00?o0000on3OhooPgn<01OoP
gn<00ol0003oh=oSon3Oh`0;on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<06ooP
gn<00ol0003oh=oSon3Oh`3oon3OhcKoh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3o
on3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_l
o@7oIVIn00000omVIWkonocmofIVOP0_on3Oh`;o0000L?oPgn<2o`0004?oh=oS00?o0000on3OhooP
gn<0@OoPgn<00ol0003oh=oSon3Oh`2lon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0
<OoPgn<00ol0003oh=oSon3Oh`1_on3Oh`03o`000?oPgn?oh=oS043oh=oS00?o0000on3OhooPgn<0
@OoPgn<00ol0003oh=oSon3Oh`1eon3Oh`03o`000?oPgn?oh=oS04Coh=oS0OmVIWh1oo_lo@7oIVIn
00000omVIWkonocmofIVOP0>on3Oh`03o`000?oPgn?oh=oS00?oh=oS0ol00003on3Oh`;o000000?o
h=oSo`000?oPgn<00ooPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?oh=oS00Co0000
0_oPgn<00ol0003oh=oSon3Oh`05on3Oh`?o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;o
h=oS0ol00003on3Oh`?o00000ooPgn<2o`0000?oh=oS0ol00006on3Oh`03o`000?oPgn?oh=oS00?o
00001_oPgn<4o`0000;oh=oS0_l000001OoPgn?o0000on3OhooPgn?o000000;oh=oS0ol00002on3O
h`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<01?l00002on3Oh`03o`000?oPgn?o
000000;oh=oS0ol00003on3Oh`Co000000Coh=oSo`000?oPgn?o00000_oPgn<00ol0003oh=oSon3O
h`05on3Oh`?o00000ooPgn<3o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`03o`00
0?oPgn?oh=oS00;oh=oS0ol00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000001OoPgn<4o`000004
on3Ohol0003oh=oSo`0000Coh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003o`00
00?oh=oS0_l000001OoPgn?o0000on3OhooPgn?o000000Goh=oS1?l000000ooPgn?o0000on3Oh`02
on3Oh`03o`000?oPgn?oh=oS00Co000000?oh=oSo`000?oPgn<01?oPgn<3o`0000;oh=oS00?o0000
on3OhooPgn<01?oPgn<3o`0000?oh=oS0_l000001_oPgn?o0000on3OhooPgn?o0000on3Oh`Co0000
0ooPgn<2o`000005on3Ohol0003oh=oSon3Ohol000001OoPgn<3o`0000?oh=oS0ol00002on3Oh`03
o`000?oPgn?o000000;oh=oS0_l00006on3Oh`03o`000?oPgn?oh=oS00?o00001_oPgn<3o`0000Co
h=oS00?o0000on3OhooPgn<01?l000000ooPgn?o0000on3Oh`02on3Oh`03o`000?oPgn?oh=oS00Co
00000_oPgn<4o`000003on3Ohol0003oh=oS00;oh=oS1?l000000ooPgn?o0000on3Oh`05on3Oh`?o
00000_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000
on3OhooPgn<00ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00?o00001_oPgn<3
o`0000?oh=oS1?l000001OoPgn?o0000on3OhooPgn?o000000;oh=oS1?l000000ooPgn?o0000o`00
0002o`0000;oh=oS00?o0000on3OhooPgn<00ol0000<on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVIn
oo_loOmVIWh03_oPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oS
o`000002on3Oh`;o00001?oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?o000000?o
h=oS00?o0000on3OhooPgn<00_l00005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol0
0003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;o
h=oS0_l000001OoPgn?o0000on3OhooPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01_l0
003oh=oSon3Ohol0003oh=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`00
0003on3Oh`03o`000?oPgn?o000000?oh=oS00Go0000on3Ohol0003oh=oSo`000002on3Oh`;o0000
1OoPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3O
h`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol00000
0_oPgn<00ol0003oh=oSon3Oh`03on3Oh`09o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000?oPgn?o
000000Coh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o
000000;oh=oS0_l000000ooPgn?o0000on3Oh`04on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oS
o`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000001?oPgn<01ol0003oh=oS
on3OhooPgn?o0000on3Ohol000001OoPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000_oP
gn<2o`000005on3Ohol0003oh=oSon3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`;o0000
00?oh=oSo`000?oPgn<01?oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<01ol0
003oh=oSo`000?oPgn?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oP
gn?oh=oSo`0000?oh=oS00?o0000on3OhooPgn<00_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;o
h=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o0000
00?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`07o`000?oPgn?oh=oS
on3Ohol0003oh=oSo`000005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`04
o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<01OoPgn<01?l0003oh=oSon3Ohol00003
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooP
gn?o0000on3Ohol000000ooPgn<01Ol0003oh=oSo`000?oPgn?o000000;oh=oS00Oo0000on3OhooP
gn?oh=oSo`000?oPgn?o000000?oh=oS00Go0000on3Ohol0003oh=oSo`000003on3Oh`03o`000?oP
gn?oh=oS00Woh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0>on3Oh`03o`000?oPgn?o
h=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<0
0_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol0
00000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Oo0000on3OhooP
gn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<01Ol0003oh=oSon3OhooP
gn?o000000;oh=oS00?o0000on3OhooPgn<01_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`00
0?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3O
hol000000_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000_oPgn<01_l0003oh=oSon3O
hol0003oh=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`000005on3Oh`0;
o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000?oPgn?o0000on3Ohol000000_oPgn<00ol0003oh=oS
on3Oh`02on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o0000
00?oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00002on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Co
0000on3OhooPgn?o00001OoPgn<02Ol0003oh=oSon3OhooPgn?o0000on3Ohol0003oh=oSo`000004
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003
on3Oh`03o`000?oPgn?o000000Goh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS
00?o0000on3Ohol000000ooPgn<01?l0003oh=oSon3Ohol00003on3Oh`07o`000?oPgn?oh=oSon3O
hol0003oh=oSo`000005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`00
0?oPgn?o000000;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3O
hol000001OoPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3O
hol000000ooPgn<00ol0003oh=oSon3Oh`03on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000
on3OhooPgn<01_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003o
h=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003o
h=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000005on3Oh`07o`000?oPgn?o
h=oSon3Ohol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooP
gn<01OoPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000Soh=oS00?o0000on3O
hooPgn<00ooPgn<02Ol0003oh=oSon3OhooPgn?o0000on3Ohol0003oh=oSo`000002on3Oh`07o`00
0?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3Ohol000003ooPgn<1
ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00koh=oS00?o0000on3OhooPgn<00_oPgn<01ol0
003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oP
gn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<01?l000001OoPgn?o0000on3OhooPgn?o000000Co
h=oS00?o0000on3OhooPgn<00ooPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<0
0ol0003oh=oSo`000003on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS1Ol00004on3Oh`04o`000?oP
gn?oh=oSo`0000?oh=oS00?o0000on3OhooPgn<00ooPgn<4o`000003on3Ohol0003oh=oS00;oh=oS
00?o0000on3Ohol000000_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000_oPgn<01?l0
003oh=oSon3Ohol00002on3Oh`Co000000Ooh=oSo`000?oPgn?oh=oSo`000?oPgn?o000000Koh=oS
1?l000001_oPgn?o0000on3Ohol0003oh=oSo`0000;oh=oS00?o0000on3OhooPgn<00_oPgn<00ol0
003oh=oSon3Oh`03on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`06o`000?oP
gn?oh=oSo`000?oPgn?o00000_oPgn<5o`000005on3Ohol0003oh=oSon3Ohol000001_oPgn<4o`00
0004on3Ohol0003oh=oSo`0000Coh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003
on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000001_oPgn<4o`000003on3Ohol0003o
h=oS00;oh=oS00?o0000on3Ohol000000ooPgn<01?l0003oh=oSon3Ohol00003on3Oh`07o`000?oP
gn?oh=oSon3Ohol0003oh=oSo`000005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003
on3Oh`03o`000?oPgn?o000000;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS
00?o0000on3Ohol000001OoPgn<00ol0003oh=oSon3Oh`03on3Oh`Go000000Coh=oSo`000?oPgn?o
00000_oPgn<00ol0003oh=oSon3Oh`04on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3O
hooPgn<01_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`Co000000?oh=oSo`000?oPgn<00_oPgn<0
0ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00Co000000Goh=oSo`000?oPgn?oh=oSo`00
0003on3Oh`03o`000?oPgn?o000000Goh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;o
h=oS00Co0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`05on3Oh`04o`000?oPgn?oh=oS
o`0000?oh=oS00?o0000on3Ohol000001?l00004on3Oh`Go000000?oh=oSo`000?oPgn<00_oPgn<0
1Ol0003oh=oSo`000?oPgn?o000000?oh=oS1?l000000ooPgn?o0000on3Oh`02on3Oh`04o`000?oP
gn?o0000on3Oh`Go00002ooPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00koh=oS00?o
0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003o
h=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<00ooPgn<00ol0
003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Ko0000on3OhooPgn?oh=oSo`000?oP
gn<2o`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oP
gn?o000000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oP
gn?oh=oSo`0000?oh=oS00?o0000on3OhooPgn<01_oPgn<00ol0003oh=oSo`000003on3Oh`03o`00
0?oPgn?o000000;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS00Co0000on3O
hooPgn?o00001OoPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000
on3OhooPgn<00ooPgn<01ol0003oh=oSo`000?oPgn?o0000on3Ohol000000_oPgn<00ol0003oh=oS
on3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`04o`000?oPgn?o0000
o`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o
000000;oh=oS00?o0000on3OhooPgn<01ooPgn<01Ol0003oh=oSo`000?oPgn?o000000Coh=oS00Co
0000on3Ohol0003o00000_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS
00?o0000on3Ohol000002OoPgn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oPgn?o000000?o
h=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`00
0005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;o
h=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000001OoPgn<0
1ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<01ol0003oh=oSo`000?oPgn?o0000on3O
hol000000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000
on3OhooPgn<00ooPgn<3o`0000?oh=oS00?o0000on3OhooPgn<01?oPgn<01?l0003oh=oSo`000?l0
0002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSo`00
0002on3Oh`06o`000?oPgn?oh=oSon3Ohol0003oh=oS1?l00002on3Oh`07o`000?oPgn?oh=oSon3O
hol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<01OoP
gn<00ol0003oh=oSon3Oh`02o`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3O
h`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3O
hol000001_oPgn<00ol0003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3Ohol000000ooPgn<0
0ol0003oh=oSon3Oh`09on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03OoPgn<00ol0
003oh=oSo`000004on3Oh`?o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000Coh=oS0ol00000
0ooPgn?o0000o`000003on3Oh`?o00000_oPgn<01?l0003oh=oSon3Ohol00005on3Oh`?o00000_oP
gn<01?l0003oh=oSo`000?l00003on3Oh`?o00000ooPgn<3o`0000?oh=oS0_l00003on3Oh`?o0000
1OoPgn<2o`0000;oh=oS0ol00006on3Oh`?o00000_oPgn<01_l0003oh=oSon3OhooPgn?o0000on3O
h`;o00000_oPgn<3o`0000;oh=oS0ol000000ooPgn?o0000o`000003on3Oh`?o00000_oPgn<2o`00
0004on3Ohol0003oh=oSon3Oh`?o00000ooPgn<3o`0000;oh=oS00Go0000on3Ohol0003oh=oSo`00
0002on3Oh`03o`000?oPgn?oh=oS00?oh=oS0ol00003on3Oh`?o00000_oPgn<01?l0003oh=oSo`00
0?l00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<3o`0000;oh=oS0_l000000ooPgn?o
0000o`000005on3Oh`?o00000_oPgn<00ol0003oh=oSo`000004on3Oh`04o`000?oPgn?o0000on3O
h`;o00000_oPgn<4o`0000;oh=oS00Ko0000on3OhooPgn?oh=oSo`000?oPgn<2o`0000Goh=oS0ol0
0002on3Oh`04o`000?oPgn?o0000o`0000?oh=oS1?l00003on3Oh`04o`000?oPgn?oh=oSon3Oh`?o
00000_oPgn<2o`0000Goh=oS0ol00002on3Oh`06o`000?oPgn?oh=oSon3Ohol0003oh=oS0_l00000
0ooPgn?o0000o`000002o`0000;oh=oS00Ko0000on3OhooPgn?oh=oSo`000?oPgn<2o`0000Goh=oS
0ol00003on3Oh`?o00000_oPgn<00ol0003oh=oSo`000002on3Oh`;o00001OoPgn<2o`0000;oh=oS
0ol00005on3Oh`03o`000?oPgn?oh=oS00Coh=oS0_l00002on3Oh`?o00000_oPgn<01?l0003oh=oS
o`000?l00003on3Oh`Co00000_oPgn<3o`0000;oh=oS0_l00002on3Oh`Co000000?oh=oSo`000?oP
gn<01OoPgn<3o`0000;oh=oS0_l000001OoPgn?o0000o`000?l0003oh=oS00;o00002?oPgn<2o`00
0003on3Ohol0003oh=oS00;o00000ooPgn<3o`0000Koh=oS0ol00003on3Oh`Co000000?oh=oSo`00
0?oPgn<00_l00002on3Oh`?o00000_oPgn<4o`0000;oh=oS00?o0000on3OhooPgn<00ol0000<on3O
h`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<01Ol0003oh=oSon3OhooPgn?o0000
02goh=oS00?o0000on3OhooPgn<07OoPgn<00ol0003oh=oSon3Oh`0Eon3Oh`03o`000?oPgn?oh=oS
01Coh=oS00?o0000on3OhooPgn<03_oPgn<00ol0003oh=oSo`00000Zon3Oh`03o`000?oPgn?oh=oS
00Woh=oS00?o0000on3Ohol000006?oPgn<00ol0003oh=oSon3Oh`0Con3Oh`03o`000?oPgn?oh=oS
00;oh=oS00?o0000on3OhooPgn<05ooPgn<00ol0003oh=oSon3Oh`0<on3Oh`03o`000?oPgn?oh=oS
00ooh=oS00?o0000on3Ohol000002OoPgn<00ol0003oh=oSon3Oh`09on3Oh`03o`000?oPgn?oh=oS
00Coh=oS00?o0000on3OhooPgn<04?oPgn<00ol0003oh=oSon3Oh`0<on3Oh`03o`000?oPgn?o0000
01coh=oS00Co0000on3OhooPgn?o00006?oPgn<01Ol0003oh=oSon3OhooPgn?o000000Soh=oS00?o
0000on3OhooPgn<00ooPgn<00ol0003oh=oSon3Oh`0?on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVIn
oo_loOmVIWh02ooPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS02[oh=oS00?o0000
on3OhooPgn<07OoPgn<00ol0003oh=oSon3Oh`0Eon3Oh`03o`000?oPgn?oh=oS01Coh=oS00?o0000
on3OhooPgn<03_oPgn<00ol0003oh=oSo`00000Zon3Oh`03o`000?oPgn?oh=oS00Woh=oS00?o0000
on3Ohol000006?oPgn<00ol0003oh=oSon3Oh`0Con3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000
on3OhooPgn<05ooPgn<00ol0003oh=oSon3Oh`0<on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000
on3Ohol000002OoPgn<00ol0003oh=oSon3Oh`09on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oP
gn<00ol0003oh=oSon3Oh`0@on3Oh`03o`000?oPgn?oh=oS00coh=oS00?o0000on3Ohol000007?oP
gn<01?l0003oh=oSon3Ohol0000Hon3Oh`05o`000?oPgn?oh=oSon3Ohol000002?oPgn<00ol0003o
h=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS00ooh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocm
ofIVOP0;on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<0:_oPgn<00ol0003oh=oS
on3Oh`1?on3Oh`03o`000?oPgn?oh=oS00_oh=oS00?o0000on3Ohol00000=_oPgn<00ol0003oh=oS
o`000004on3Oh`03o`000?oPgn?oh=oS02Ooh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oS
on3Oh`0hon3Oh`03o`000?oPgn?o000001Koh=oS0ol0000Fon3Oh`03o`000?oPgn?oh=oS00coh=oS
00?o0000on3Ohol000001?l0000Kon3Oh`03o`000?oPgn?oh=oS01Koh=oS00?o0000on3Ohol00000
2_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS00ooh=oS0OmVIWh1oo_lo@7oIVIn
00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3o
on3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_l
o@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocm
ofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmV
IWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omV
IWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[o
h=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn
00000omVIWkonocmofIVOP3oon3Ohn[oh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP2c
on3Oh`03o`000?oPgn?oh=oS0<[oh=oS1?l0001Uon3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_l
oOmVIWh0/ooPgn<00ol0003oh=oSon3Oh`3>on3Oh`03o`000?oPgn?oh=oS06;oh=oS0OmVIWh1oo_l
o@7oIVIn00000omVIWkonocmofIVOP0=on3Oh`?o00000ooPgn<2o`000004on3Ohol0003oh=oSo`00
00;oh=oS00Co0000on3OhooPgn?oh=oS0ol00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oP
gn<00ol0003oh=oSon3Oh`02on3Oh`06o`000?oPgn?oh=oSo`000?oPgn?o00000_oPgn<3o`0000Go
h=oS00Co0000on3OhooPgn?oh=oS0ol00002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00Co0000
on3OhooPgn?o00000_oPgn<4o`0000;oh=oS00?o0000on3OhooPgn<00_oPgn<4o`0000?oh=oS0ol0
0002on3Oh`04o`000?oPgn?oh=oSon3Oh`?o00000_oPgn<01?l0003oh=oSon3OhooPgn<3o`0000Go
h=oS00Co0000on3OhooPgn?o00001OoPgn<3o`0000?oh=oS1?l000000ooPgn?o0000on3Oh`02on3O
h`03o`000?oPgn?oh=oS00;oh=oS1?l00003on3Oh`?o00001_oPgn<3o`0000;oh=oS1?l00003on3O
h`?o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS0ol00003on3Oh`Co000000?oh=oS
o`000?oPgn<01_oPgn<00ol0003oh=oSon3Oh`02on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oP
gn<3o`0000Goh=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`?o00000ooPgn<01Ol0003oh=oS
on3OhooPgn?o000000Goh=oS00Ko0000on3OhooPgn?o0000on3Ohol00002on3Oh`?o00001_oPgn<0
1Ol0003oh=oSon3OhooPgn?o000000;oh=oS00Go0000on3Ohol0003oh=oSo`000004on3Oh`05o`00
0?oPgn?oh=oSon3Ohol000000_oPgn<4o`0000?oh=oS00?o0000on3OhooPgn<00_oPgn<3o`0000Ko
h=oS1?l00004on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<4o`000005on3Ohol0003oh=oS
on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`03o`0000Koh=oS0ol00002on3Oh`05o`000?oPgn?o
h=oSon3Ohol000000_oPgn<4o`000004on3Ohol0003oh=oSo`0000?oh=oS00?o0000on3OhooPgn<0
1?l00004on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oS
on3Ohol00003on3Oh`03o`000?oPgn?o000000?o00000_oPgn<00ol0003oh=oSon3Oh`13on3Oh`7o
IVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<01ol0003oh=oSon3OhooPgn?o0000on3O
hol000000_oPgn<2o`000005on3Ohol0003oh=oSon3Ohol000000_oPgn<01ol0003oh=oSon3OhooP
gn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000005on3Oh`08o`000?oPgn?oh=oSo`000?oP
gn?o0000on3Ohol00003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00000ooP
gn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSo`000005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3O
h`03o`000?oPgn?o000000;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS00Go
0000on3OhooPgn?oh=oSo`000004on3Oh`03o`000?oPgn?o000000Goh=oS00Oo0000on3OhooPgn?o
h=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3O
h`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo
0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003o
h=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003o
h=oSon3Oh`07on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o
000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol00000
0ooPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?oh=oS00?oh=oS00So0000on3OhooP
gn?o0000on3Ohol0003oh=oSo`0000?oh=oS00?o0000on3OhooPgn<00ooPgn<01Ol0003oh=oSon3O
hooPgn?o000000;oh=oS00Go0000on3Ohol0003oh=oSo`000004on3Oh`07o`000?oPgn?oh=oSon3O
hol0003oh=oSo`000003on3Oh`05o`000?oPgn?oh=oSon3Ohol000000ooPgn<01Ol0003oh=oSon3O
hooPgn?o000000Coh=oS00Go0000on3OhooPgn?oh=oSo`000004on3Oh`07o`000?oPgn?oh=oSon3O
hol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00Ko0000on3OhooPgn?o0000on3O
hol00003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o0000
00?oh=oS00?o0000on3Ohol000000ooPgn<01Ol0003oh=oSo`000?oPgn?o000000?oh=oS00?o0000
on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000
on3OhooPgn<01OoPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oS
on3Oh`15on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03?oPgn<00ol0003oh=oSon3O
h`03on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`00
00Goh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000Goh=oS00So0000on3OhooPgn?o0000
on3Ohol0003oh=oSo`0000Soh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000002
on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`00
0005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000005on3Oh`04o`000?oPgn?oh=oSo`00
00?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?o0000
00Goh=oS00?o0000on3OhooPgn<00ooPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooP
gn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000008on3Oh`07
o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000Goh=oS00Oo0000
on3OhooPgn?oh=oSo`000?oPgn?o000000Goh=oS00Go0000on3OhooPgn?oh=oSo`000009on3Oh`03
o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000Soh=oS00Oo0000
on3OhooPgn?oh=oSo`000?oPgn?o000000Goh=oS00Oo0000on3Ohol0003oh=oSo`000?oPgn?o0000
00Coh=oS00So0000on3OhooPgn?o0000on3Ohol0003oh=oSo`0000Soh=oS00go0000on3Ohol0003o
h=oSo`000?oPgn?o0000on3Ohol0003oh=oSo`000?oPgn?o000000Coh=oS00Oo0000on3OhooPgn?o
h=oSo`000?oPgn?o000000?oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00002on3Oh`03o`000?oP
gn?oh=oS00Koh=oS00Go0000on3OhooPgn?oh=oSo`000004on3Oh`07o`000?oPgn?oh=oSon3Ohol0
003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00Ko0000on3OhooPgn?o0000on3Ohol0
0008on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?o
h=oS00Go0000on3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3O
hooPgn<00_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00Goh=oS00Oo0000on3O
hooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<0AOoPgn<1ofIVOP7onocm0OmV
IWh00003ofIVO_oko?goIVIn00coh=oS00?o0000on3OhooPgn<00ooPgn<01ol0003oh=oSon3OhooP
gn?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`05o`000003on3Ohol0003oh=oS00;oh=oS
00?o0000on3Ohol000001OoPgn<01ol0003oh=oSon3Ohol0003oh=oSo`000?oPgn<01Ol00004on3O
h`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol000000_oPgn<01?l0003oh=oSon3Ohol0
0002on3Oh`03o`000?oPgn?oh=oS00Co000000?oh=oSo`000?oPgn<01?oPgn<01_l0003oh=oSon3O
hooPgn?o0000on3Oh`Go000000Goh=oSo`000?oPgn?oh=oSo`000003on3Oh`03o`000?oPgn?o0000
00;oh=oS1Ol00004on3Oh`03o`000?oPgn?o000000Goh=oS00?o0000on3OhooPgn<01?oPgn<4o`00
0003on3Ohol0003oh=oS00;oh=oS00?o0000on3OhooPgn<00_oPgn<01_l0003oh=oSon3OhooPgn?o
0000on3Oh`Go00001?oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003o
h=oSo`000004o`000003on3Ohol0003oh=oS00;oh=oS00?o0000on3Ohol000001?l000000ooPgn?o
0000on3Oh`02on3Oh`03o`000?oPgn?oh=oS00Ooh=oS00?o0000on3OhooPgn<00_oPgn<01_l0003o
h=oSon3OhooPgn?o0000on3Oh`Go00001?oPgn<01_l0003oh=oSon3OhooPgn?o0000on3Oh`Go0000
00Soh=oSo`000?oPgn?o0000on3Ohol0003oh=oSo`0000Coh=oS00Oo0000on3OhooPgn?o0000on3O
hol0003oh=oS00Go00001?oPgn<03Ol0003oh=oSo`000?oPgn?o0000on3Ohol0003oh=oSo`000?oP
gn?o0000on3Ohol000001?oPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS1?l00002on3Oh`03
o`000?oPgn?o000000;oh=oS1Ol00005on3Oh`Co00001?oPgn<01Ol0003oh=oSon3OhooPgn?o0000
00;oh=oS1?l000001OoPgn?o0000on3OhooPgn?o000000;oh=oS00?o0000on3Ohol000001?l00004
on3Oh`Go000000?oh=oSo`000?oPgn<00_oPgn<00ol0003oh=oSo`000003on3Oh`05o`000?oPgn?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o
0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`05on3Oh`07o`000?oPgn?oh=oSon3Ohol0003o
h=oSo`000003on3Oh`03o`000?oPgn?oh=oS04Goh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocm
ofIVOP0<on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o0000
00;oh=oS00Co0000on3OhooPgn?o00000ooPgn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oP
gn?o000000Goh=oS00So0000on3OhooPgn?o0000on3Ohol0003oh=oSo`0000?oh=oS00?o0000on3O
hooPgn<00_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000;oh=oS00Co0000
on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?o000000Goh=oS00Oo
0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01ol0003o
h=oSon3OhooPgn?o0000on3Ohol000000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000Coh=oS00?o
0000on3Ohol000001OoPgn<01Ol0003oh=oSon3OhooPgn?o000000Goh=oS00Co0000on3Ohol0003o
00000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003
on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS
00?o0000on3Ohol000000ooPgn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oPgn?o000000?o
h=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`07on3Oh`03o`000?oPgn?oh=oS00;o
h=oS0_l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<2o`0000;o
h=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`00
00Coh=oS00So0000on3OhooPgn?o0000on3Ohol0003oh=oSo`0000?oh=oS00?o0000on3OhooPgn<0
0_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`07o`000?oPgn?o0000on3Ohol0003oh=oSo`000004
on3Oh`;o00000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000
on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00;oh=oS0_l00002
on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3Ohol000000_oPgn<01_l0003oh=oSon3Ohol0
003oh=oSo`0000?oh=oS00?o0000on3OhooPgn<00_oPgn<01_l0003oh=oSon3OhooPgn?o0000on3O
h`;o00000_oPgn<00ol0003oh=oSo`000003on3Oh`04o`000?oPgn?o0000on3Oh`;o00000_oPgn<0
0ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3Ohol0003o00000_oP
gn<00ol0003oh=oSon3Oh`05on3Oh`;o00000_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oP
gn?oh=oS04Goh=oS0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0=on3Oh`?o00000_oPgn<0
1_l0003oh=oSon3OhooPgn?o0000on3Oh`;o000000?oh=oSo`000?l000000_oPgn<3o`0000;oh=oS
00Co0000on3Ohol0003o00000_oPgn<2o`0000Coh=oS0_l000001?oPgn?o0000on3Ohol00002on3O
h`?o00001OoPgn<2o`0000;oh=oS0ol00002on3Oh`;o000000Goh=oSo`000?l0003o0000on3Oh`02
o`0000?oh=oS0ol00002on3Oh`;o00001?oPgn<4o`0000?oh=oS0ol00002on3Oh`;o00000_oPgn<3
o`0000;oh=oS0_l00002on3Oh`?o00001OoPgn<01?l0003oh=oSo`000?l00005on3Oh`?o00000ooP
gn<3o`0000;oh=oS00Co0000on3Ohol0003o00001OoPgn<4o`0000?oh=oS0ol00006on3Oh`?o0000
0_oPgn<4o`0000?oh=oS0ol00002on3Oh`04o`000?oPgn?o0000o`0000?oh=oS0ol00003on3Oh`Co
00002OoPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?o0000o`0000?oh=oS0ol00005on3O
h`04o`000?oPgn?o0000o`0000?oh=oS0ol00002on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o
0000on3OhooPgn<00_oPgn<2o`000004on3Ohol0003oh=oSo`0000;oh=oS0ol00005on3Oh`04o`00
0?oPgn?oh=oSo`0000;oh=oS00Oo0000on3Ohol0003oh=oSo`000?oPgn?o000000Coh=oS00Co0000
on3Ohol0003o00000ooPgn<3o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000002on3Oh`?o0000
1_oPgn<3o`0000Goh=oS00Co0000on3Ohol0003o00000ooPgn<3o`0000;oh=oS0ol000000ooPgn?o
0000o`000003on3Oh`?o00001_oPgn<3o`0000;oh=oS00Co0000on3Ohol0003o00000ooPgn<4o`00
0005on3Ohol0003oh=oSo`000?oPgn<00_l00003on3Oh`Co00001?oPgn<01?l0003oh=oSo`000?oP
gn<2o`0000Soh=oS00Co0000on3Ohol0003o00000_oPgn<4o`0004Soh=oS0OmVIWh1oo_lo@7oIVIn
00000omVIWkonocmofIVOP0Zon3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<00_oP
gn<00ol0003oh=oSon3Oh`08on3Oh`03o`000?oPgn?oh=oS01Ooh=oS00?o0000on3OhooPgn<00ooP
gn<00ol0003oh=oSon3Oh`09on3Oh`03o`000?oPgn?oh=oS01Coh=oS00?o0000on3OhooPgn<06?oP
gn<00ol0003oh=oSon3Oh`0^on3Oh`03o`000?oPgn?oh=oS00Ooh=oS00?o0000on3OhooPgn<00_oP
gn<00ol0003oh=oSon3Oh`0Son3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<04_oP
gn<00ol0003oh=oSo`000004on3Oh`03o`000?oPgn?oh=oS04koh=oS00?o0000on3OhooPgn<09?oP
gn<00ol0003oh=oSon3Oh`19on3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh0:_oPgn<0
0ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<02?oPgn<0
0ol0003oh=oSon3Oh`0Gon3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<02OoPgn<0
0ol0003oh=oSon3Oh`0Don3Oh`03o`000?oPgn?oh=oS01Soh=oS00?o0000on3OhooPgn<0;_oPgn<0
0ol0003oh=oSon3Oh`07on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<08ooPgn<0
0ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS01;oh=oS00?o0000on3Ohol000001?oPgn<0
0ol0003oh=oSon3Oh`1>on3Oh`03o`000?oPgn?oh=oS02Coh=oS00?o0000on3OhooPgn<0BOoPgn<1
ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn037oh=oS00Go0000on3Ohol0003oh=oSo`00000;
on3Oh`03o`000?oPgn?oh=oS01coh=oS00?o0000on3OhooPgn<02_oPgn<00ol0003oh=oSon3Oh`0A
on3Oh`03o`000?oPgn?oh=oS01[oh=oS00?o0000on3OhooPgn<0;_oPgn<00ol0003oh=oSon3Oh`05
on3Oh`Go00000_oPgn<00ol0003oh=oSon3Oh`0Ton3Oh`05o`000?oPgn?o0000on3Ohol000004_oP
gn<01Ol0003oh=oSo`000?oPgn?o000000Coh=oS00?o0000on3OhooPgn<0C_oPgn<00ol0003oh=oS
o`00000@on3Oh`03o`000?oPgn?oh=oS017oh=oS00?o0000on3OhooPgn<0BOoPgn<1ofIVOP7onocm
0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?go
IVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn057oh=oS0_l00015on3O
h`03o`000?oPgn?oh=oS0?ooh=oSCooPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn05?o
h=oS00?o0000on3OhooPgn<0@_oPgn<00ol0003oh=oSon3Oh`3oon3Ohdooh=oS0OmVIWh1oo_lo@7o
IVIn00000omVIWkonocmofIVOP0>on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Go0000on3OhooPgn?o
h=oSo`000002on3Oh`?o00001OoPgn<01Ol0003oh=oSon3OhooPgn?o000000;oh=oS0ol00003on3O
h`03o`000?oPgn?oh=oS00?o00000_oPgn<4o`0000?oh=oS0ol00003on3Oh`?o00000_oPgn<01Ol0
003oh=oSon3OhooPgn?o000000Goh=oS00?o0000on3OhooPgn<00_oPgn<3o`0000?oh=oS0_l00000
0ooPgn?o0000on3Oh`04on3Oh`Co00000_oPgn<2o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`00
0002on3Oh`?o00000ooPgn<4o`0000Goh=oS00?o0000on3OhooPgn<00ol00006on3Oh`?o00000_oP
gn<4o`0000?oh=oS0ol00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000001?oPgn<00ol0003oh=oS
on3Oh`02o`0000Goh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`03on3Oh`Co0000
00?oh=oSo`000?oPgn<00_oPgn<00ol0003oh=oSon3Oh`03on3Oh`?o00000_oPgn<00ol0003oh=oS
on3Oh`04o`0000Coh=oS00Ko0000on3OhooPgn?o0000on3Ohol00002on3Oh`?o00001OoPgn<01?l0
003oh=oSon3OhooPgn<3o`0000;oh=oS00Co0000on3OhooPgn?o00000_oPgn<01?l0003oh=oSon3O
hol00002on3Oh`Co00000_oPgn<00ol0003oh=oSo`000007on3Oh`03o`000?oPgn?oh=oS00?oh=oS
0ol00003on3Oh`;o000000?oh=oSo`000?oPgn<00ooPgn<01?l0003oh=oSon3Ohol00002on3Oh`03
o`000?oPgn?oh=oS00;o000000Coh=oSo`000?oPgn?oh=oS0_l00003on3Oh`03o`000?oPgn?oh=oS
00?oh=oS0ol00003on3Oh`?o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000?oh=oS00?o0000
on3OhooPgn<00_oPgn<3o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000005on3Oh`03o`000?oP
gn?o000000?oh=oS00?o0000on3OhooPgn<00ol00005on3Oh`05o`000?oPgn?oh=oSon3Ohol00000
0_oPgn<3o`0000?oh=oS00?o0000on3OhooPgn<00ol00002on3Oh`Co00000ooPgn<3o`0000?oh=oS
0ol00002on3Oh`05o`000?oPgn?oh=oSon3Ohol000001OoPgn<00ol0003oh=oSon3Oh`03o`0000Ko
h=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`03o`0002?oh=oS0OmVIWh1oo_lo@7o
IVIn00000omVIWkonocmofIVOP0>on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?o
h=oSo`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`07o`000?oPgn?oh=oSon3Ohol0003o
h=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0003o
h=oSo`000002on3Oh`03o`000?oPgn?oh=oS00Coh=oS0_l00002on3Oh`07o`000?oPgn?oh=oSon3O
hol0003oh=oSo`000002on3Oh`;o00001?oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol00000
0_oPgn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3Ohol0
00000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3O
hooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`00
0003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003oh=oSo`00
0002on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3O
h`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;o
h=oS00Wo0000on3OhooPgn?oh=oSo`000?oPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3O
h`02on3Oh`08o`000?oPgn?oh=oSo`000?oPgn?o0000on3Ohol00003on3Oh`03o`000?oPgn?oh=oS
00;oh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000002on3Oh`04o`000?oPgn?o
h=oSo`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`00000:on3Oh`03o`000?oP
gn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000;oh=oS0_l00004on3Oh`04
o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3Ohol000000_oPgn<2o`000007on3Ohol0003oh=oS
on3Ohol0003oh=oSo`000005on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03
o`000?oPgn?o000000?oh=oS00Go0000on3OhooPgn?oh=oSo`000003on3Oh`07o`000?oPgn?oh=oS
on3Ohol0003oh=oSo`000002on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Co0000on3OhooPgn?o0000
0ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?o
h=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<01ol0003oh=oSon3OhooPgn?o
0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000?oh=oS00?o
0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`03on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS
00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000?o
h=oS00?o0000on3OhooPgn<08?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn00koh=oS
00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000002?oPgn<01ol0
003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000002on3Oh`03o`000?oP
gn?oh=oS00?oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol0
00000ooPgn<01Ol0003oh=oSo`000?oPgn?o000000Koh=oS00Ko0000on3OhooPgn?o0000on3Ohol0
0003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01Ol0003oh=oSon3O
hooPgn?o000000?oh=oS00Ko0000on3OhooPgn?o0000on3Ohol00003on3Oh`03o`000?oPgn?oh=oS
00?oh=oS00Go0000on3OhooPgn?oh=oSo`000004on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o
0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003o
h=oSo`000005on3Oh`05o`000?oPgn?oh=oSon3Ohol000001?oPgn<01Ol0003oh=oSon3OhooPgn?o
000000Goh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?o
h=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Wo0000on3OhooPgn?o
h=oSo`000?oPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`08o`000?oPgn?o
h=oSo`000?oPgn?o0000on3Ohol00008on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000on3O
hol000000_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000
on3Ohol000002_oPgn<00ol0003oh=oSon3Oh`02on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oS
o`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00000_oPgn<00ol0003o
h=oSo`000003on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<00ol0003oh=oSon3Oh`03on3O
h`03o`000?oPgn?oh=oS00?oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00Ko
0000on3OhooPgn?o0000on3Ohol00002on3Oh`03o`000?oPgn?oh=oS00?oh=oS00Co0000on3OhooP
gn?o00001OoPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000000Soh=oS00Oo0000
on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oS
on3Oh`03on3Oh`07o`000?oPgn?oh=oSon3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?o0000
00?oh=oS00Go0000on3Ohol0003oh=oSo`000006on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o
0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o000002Koh=oS
0OmVIWh1oo_lo@7oIVIn00000omVIWkonocmofIVOP0>on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Ko
0000on3OhooPgn?oh=oSo`000?oPgn<5o`0000Coh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o
000000?oh=oS00?o0000on3Ohol000000_oPgn<5o`000003on3Ohol0003oh=oS00;oh=oS00?o0000
on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`04o`000?oPgn?o0000o`0000Ooh=oS00Ko
0000on3OhooPgn?o0000on3Ohol00003on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooP
gn<00ooPgn<4o`0000;oh=oS00Co0000on3OhooPgn?oh=oS0_l00004on3Oh`Go000000?oh=oSo`00
0?oPgn<00_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000?oh=oS00?o0000
on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oS
o`000004o`000003on3Ohol0003oh=oS00;oh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oS
on3Ohol00006on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00ooPgn<4o`000003
on3Ohol0003oh=oS00;oh=oS00?o0000on3OhooPgn<00_oPgn<02Ol0003oh=oSon3OhooPgn?o0000
on3Ohol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?o0000
on3Ohol0003oh=oS00Go00001?oPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?o0000
00;oh=oS00Co0000on3OhooPgn?o00000_oPgn<00ol0003oh=oSon3Oh`04o`000003on3Ohol0003o
h=oS00Woh=oS00?o0000on3OhooPgn<00_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3Ohol0
00000ooPgn<01?l0003oh=oSon3Ohol00003on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3O
hooPgn<00ooPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<01_l0003oh=oSon3O
hol0003oh=oSo`0000;oh=oS1Ol000001OoPgn?o0000on3OhooPgn?o000000Goh=oS00Co0000on3O
hooPgn?o00000ooPgn<00ol0003oh=oSo`000004o`0000Coh=oS00Oo0000on3OhooPgn?oh=oSo`00
0?oPgn?o000000?oh=oS00?o0000on3Ohol000000_oPgn<5o`000003on3Ohol0003oh=oS00;oh=oS
00?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`000003on3Oh`04o`000?oPgn?o0000o`0000Oo
h=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oPgn?oh=oS
o`0000?oh=oS00?o0000on3Ohol000001?l0000Ron3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_l
oOmVIWh03_oPgn<00ol0003oh=oSon3Oh`02on3Oh`;o00000_oPgn<00ol0003oh=oSo`000003on3O
h`03o`000?oPgn?oh=oS00;oh=oS0_l00002on3Oh`03o`000?oPgn?o000000?oh=oS00?o0000on3O
hol000000_oPgn<01ol0003oh=oSon3OhooPgn?o0000on3Ohol000000ooPgn<00ol0003oh=oSo`00
0003on3Oh`03o`000?oPgn?o000000?oh=oS00Go0000on3Ohol0003oh=oSo`000006on3Oh`06o`00
0?oPgn?oh=oSo`000?oPgn?o00000ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?oh=oS
00Koh=oS00?o0000on3Ohol000000_oPgn<01Ol0003oh=oSo`000?oPgn?o000000?oh=oS00Oo0000
on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oS
on3Ohol00003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o
000000?oh=oS00?o0000on3Ohol000000ooPgn<01?l0003oh=oSo`000?l00002on3Oh`03o`000?oP
gn?oh=oS00;oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSon3Oh`02on3Oh`04o`000?oP
gn?o0000o`0000;oh=oS00?o0000on3OhooPgn<01_oPgn<01?l0003oh=oSo`000?l00002on3Oh`03
o`000?oPgn?oh=oS00;oh=oS00Wo0000on3OhooPgn?oh=oSo`000?oPgn?o0000on3Ohol000000ooP
gn<00ol0003oh=oSon3Oh`02on3Oh`08o`000?oPgn?oh=oSo`000?oPgn?o0000on3Ohol00003on3O
h`03o`000?oPgn?oh=oS00;oh=oS00Co0000on3OhooPgn?o00000ooPgn<00ol0003oh=oSo`000002
on3Oh`04o`000?oPgn?oh=oSo`0000;oh=oS00?o0000on3OhooPgn<00ooPgn<00ol0003oh=oSo`00
000:on3Oh`03o`000?oPgn?oh=oS00;oh=oS00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?o
h=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oSon3Ohol00002on3Oh`03o`000?oPgn?o0000
00?oh=oS00?o0000on3Ohol000000_oPgn<00ol0003oh=oSo`000005on3Oh`07o`000?oPgn?oh=oS
on3Ohol0003oh=oSo`000003on3Oh`04o`000?oPgn?o0000o`0000;oh=oS00?o0000on3Ohol00000
0ooPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS00?o0000on3OhooPgn<0
0ooPgn<00ol0003oh=oSon3Oh`02o`0000;oh=oS00?o0000on3Ohol000000ooPgn<00ol0003oh=oS
on3Oh`02on3Oh`;o00000_oPgn<00ol0003oh=oSo`000003on3Oh`03o`000?oPgn?o000000;oh=oS
00Oo0000on3OhooPgn?oh=oSo`000?oPgn?o000000?oh=oS00?o0000on3Ohol000000ooPgn<00ol0
003oh=oSo`000003on3Oh`05o`000?oPgn?o0000on3Ohol000001_oPgn<01?l0003oh=oSon3Ohol0
0003on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<00_l00002on3Oh`03o`000?oP
gn?o000000?oh=oS00?o0000on3OhooPgn<08?oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?go
IVIn00koh=oS00?o0000on3OhooPgn<00_oPgn<01?l0003oh=oSo`000?l00003on3Oh`?o00001OoP
gn<01?l0003oh=oSo`000?l00003on3Oh`?o00000_oPgn<2o`0000;oh=oS0ol00002on3Oh`Co0000
0ooPgn<3o`0000?oh=oS0ol00002on3Oh`04o`000?oPgn?oh=oSo`0000Goh=oS00Co0000on3OhooP
gn?o00000_oPgn<3o`0000;oh=oS00Go0000on3OhooPgn?oh=oSo`000005on3Oh`?o00000ooPgn<2
o`0000;oh=oS00Co0000on3OhooPgn?o00000ooPgn<3o`0000?oh=oS1?l00004on3Oh`;o00000_oP
gn<3o`0000Koh=oS0ol00002on3Oh`Co00000ooPgn<3o`0000;oh=oS00Co0000on3Ohol0003o0000
1OoPgn<00ol0003oh=oSon3Oh`02o`0000Goh=oS00Co0000on3Ohol0003oh=oS0_l00006on3Oh`?o
00000_oPgn<01?l0003oh=oSo`000?l00006on3Oh`?o00000_oPgn<00ol0003oh=oSon3Oh`04o`00
00Coh=oS0_l000001?oPgn?o0000on3Ohol00002on3Oh`?o00001OoPgn<2o`0000;oh=oS0ol00002
on3Oh`;o000000Goh=oSo`000?l0003o0000on3Oh`02o`0000?oh=oS0ol00002on3Oh`;o00002?oP
gn<00ol0003oh=oSo`000004on3Oh`?o00000_oPgn<01Ol0003oh=oSon3OhooPgn?o000000Coh=oS
0ol000000ooPgn?o0000o`000002on3Oh`05o`000?oPgn?oh=oSon3Ohol000000_oPgn<2o`0000;o
h=oS0_l00005on3Oh`?o00000ooPgn<3o`0000;oh=oS00Co0000on3Ohol0003o00000_oPgn<01Ol0
003oh=oSon3OhooPgn?o000000;oh=oS0ol00002on3Oh`;o000000?oh=oSo`000?l000001?oPgn<2
o`000003on3Ohol0003oh=oS00;o00000ooPgn<3o`0000Goh=oS00Co0000on3Ohol0003o00000ooP
gn<3o`0000;oh=oS0_l00002on3Oh`?o00000_oPgn<4o`0000?oh=oS0ol00003on3Oh`?o00000_oP
gn<01?l0003oh=oSon3Ohol00005on3Oh`;o00000_oPgn<3o`0000Goh=oS0_l000000ooPgn?o0000
on3Oh`02o`0000?oh=oS0ol0000Son3Oh`7oIVIn0Ooko?d1ofIVOP0000?oIVInoo_loOmVIWh03_oP
gn<00ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS01Soh=oS00?o0000on3OhooPgn<01_oP
gn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS02Goh=oS00?o0000on3OhooPgn<03OoP
gn<00ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS04koh=oS00?o0000on3OhooPgn<00ooP
gn<00ol0003oh=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS00;oh=oS00?o0000on3OhooPgn<02?oP
gn<00ol0003oh=oSon3Oh`0Gon3Oh`03o`000?oPgn?oh=oS00Koh=oS00Go0000on3OhooPgn?oh=oS
o`00000Ton3Oh`03o`000?oPgn?oh=oS02Coh=oS00?o0000on3OhooPgn<00ooPgn<01?l0003oh=oS
on3Ohol0000Jon3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003o
h=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00Woh=oS00Co0000on3OhooPgn?o0000;?oPgn<1ofIV
OP7onocm0OmVIWh00003ofIVO_oko?goIVIn00koh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003o
h=oSon3Oh`0Hon3Oh`03o`000?oPgn?oh=oS00Koh=oS00?o0000on3OhooPgn<03ooPgn<00ol0003o
h=oSon3Oh`0Uon3Oh`03o`000?oPgn?oh=oS00goh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003o
h=oSon3Oh`1>on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<00_oPgn<00ol0003o
h=oSon3Oh`02on3Oh`03o`000?oPgn?oh=oS00Soh=oS00?o0000on3OhooPgn<05ooPgn<00ol0003o
h=oSon3Oh`05on3Oh`03o`000?oPgn?oh=oS00?oh=oS00?o0000on3OhooPgn<08OoPgn<00ol0003o
h=oSon3Oh`0Ton3Oh`03o`000?oPgn?oh=oS00?oh=oS00Co0000on3OhooPgn?o00006_oPgn<00ol0
003oh=oSon3Oh`06on3Oh`03o`000?oPgn?oh=oS00ooh=oS00?o0000on3OhooPgn<01_oPgn<00ol0
003oh=oSon3Oh`09on3Oh`04o`000?oPgn?oh=oSo`0002coh=oS0OmVIWh1oo_lo@7oIVIn00000omV
IWkonocmofIVOP0<on3Oh`Go00000_oPgn<00ol0003oh=oSon3Oh`0Qon3Oh`03o`000?oPgn?oh=oS
00ooh=oS00?o0000on3OhooPgn<09OoPgn<00ol0003oh=oSon3Oh`0=on3Oh`03o`000?oPgn?oh=oS
02Woh=oS00?o0000on3OhooPgn<01ooPgn<00ol0003oh=oSon3Oh`0Mon3Oh`03o`000?oPgn?oh=oS
00?oh=oS00?o0000on3OhooPgn<00ooPgn<01Ol0003oh=oSo`000?oPgn?o000000_oh=oS00?o0000
on3OhooPgn<07_oPgn<00ol0003oh=oSon3Oh`03on3Oh`03o`000?oPgn?oh=oS057oh=oS00?o0000
on3OhooPgn<08OoPgn<00ol0003oh=oSon3Oh`0?on3Oh`03o`000?oPgn?oh=oS01Goh=oS00?o0000
on3OhooPgn<0:_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIV
OP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIV
O_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oP
gn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh0
0003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?oo
h=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm
0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?go
IVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIV
OP7onocm0OmVIWh00003ofIVO_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIV
O_oko?goIVIn0?ooh=oSj_oPgn<1ofIVOP7onocm0OmVIWh00003ofIVO_ogmoWoV9RW0?ooMgNBj_mg
Mi81oiRHY`7omoOi0OmVIWh00003ofIVO_ogmoWo_;g=0?oo_;g=jonl_Ld1ooOgn@7oIVIn00000omV
IWkomoOionCSh`02onCSh`Ooa/K600?oalO7olK6a_o6a/H00_o6a/H01?o7alOoa/K6olK6a_oPgmoo
onCShmWoi>?S0OogmoT1ofIVOP0000?oIVInoo3am?ooool00_ooool01?oNg]koYjNWoj>RXonRXZ82
oj6QX@03oj2PX?nLW9coWIfM00;oWinO0_nPX:02oj6QX@03ojNWYooooooooooo00_ooooo00?oal;A
ooooooooool0oooooonhooooo`03oncZj_nLY;WoYSU400;oYSU40_nW>T@5ojHiA003oibT^Oo/j^[o
oooo00;ooooo0Oo`lO@1ofIVOP0001OoIVInon3PhOofmoWomoOiooKgnOnHVI[oVi^Kojb/[?oYjNWo
j>SXonWYjOoZj^[oZiMNon33S?o/k>cokNg]onOKbooVf<Sol?3`oo;bl_nSXj?om_OiooOgn@03ooKg
n@03ooKgn?ogmoWomoOi00ComoOi00?o3Q0@olO2dOogmoT0R?ogmoV@ooKgnI3omoOi00Com_OhooKg
nOogmoWom_Oh0_ofmoT00oofmoSomoOhooKgn@02ooKgn003ooOgn?ofmoWomoOh00;omoOi00?oW:Bi
ojHiA?nZ?5D02OnZ?5D01_nV>DCoW:BiooOgnOogmoSomoOion3Ph@7oIVIn00007?mVIWkog]gQoo7a
m?oalOCol?7dolS9bonPX:3oj^[ZonWYjOoMa[Sof/6aon7QhOo;[AWomZLJom[<]_oOb:Sohh`don3K
eOobl_;olo?coj>SXooal_ColO7doo3bmOoalOColO;doo3bm?oalO@3olO2d@;ol?7e00?o3Q0@olO2
dOo7`]400_o7`]43oo3am@?oal;A0_o`lOD01Oo7`]7ol?7eoo3amOo`lOGoal;A00Ool?7e00?oal;A
oo3amOo`lOD00_o`lOD3olO2d@?ol?7e00Coal;Aoo3amOo`lOGol?7e0oo7`]43oo3am@03olO2dOo`
lOGol?7e00?oal;A0_o`lOD01Oo7`]7ol?7eoo3amOo`lOGoal;A00Col?7e1Oo7`]44oo3am@03olO2
dOo`lOGol?7e00;ol?7e00?oal;Aoo3amOo`lOD00oo7`]44oo3am@;oal;A0_o`lOD3olO2d@;ol?7e
1?o7`]43oo3am@?oal;A0oo`lOD3olO2d@;ol?7e00Goal;Aoo3amOo`lOGol?7eolO2d@2Too3amI3o
l?7d0_oalO@02oo`lOCol?7eoo3bm?oalOCol?7eoo7bm?oalOGolO;doo3am?oalOCol?7e00;ol?7d
00GolO;eojHiA?nZ?5Go`U9KolIDFP06olIEG008olIDF_o2DU_oZSaEojHiA?o`lOColO7doo3bm?oN
gN41ofIVOP0001KoIVInomcKh?oZjo3oj^_`on[/l?nOX:?oShn?ohj>S_oYjNWoi^KVolQ=3OnkKCOo
c<07ombS0?omV03ojg/0om:;AooPh>3oj>GTonCG`onTY:Coj^c_0_oZjo000ooZjnooj^_`on[[l003
o`h@4003on[[l?o7`]7oj^_`00Co3Q0@00?oj^_`olO2dOoZjo000ol>41001?oZjo3oal;Ao`h@4?o7
`]42on[[l003o`h@4?o7`]7oj^_`00Goj^_`00?o3Q0@on[[l?o7`]400_oZjo03o`h@4005on[[l?o7
`]7oj^_`o`h@4?o7`]400_oZjo03o`h@4006on[[l?o7`]7oj^_`o`h@4?o7`]7oj^_`0ol>41001?oZ
jo3oal;Ao`h@4?o7`]42on[[l003o`h@4?o7`]7oj^_`00;oj^_`1Ol>4104on[[l003o`h@4?o7`]7o
j^_`00;oj^_`00?o3Q0@olO2dOoZjo000ol>41001?oZjo3oal;Aon[[l?oZjo02o`h@40;oj^_`0ol>
41000ooZjo3oal;Ao`h@4003o`h@4003on[[l?o7`]7oj^_`00?o3Q0@00?oj^_`olO2dOoZjo000ol>
41001?oZjo3oal;Ao`h@4?o7`]42on[[l003o`h@4?oZjo3oj^_`01?oj^_`T?oZk?2Aon[[k`?oj^_`
00?oj^__on[[l?oZjo000_oZjo000ooZjnooj^_`on[[l004on[[l004ojHiA?o2DU_o`U9Kol]DF@Ko
cEUN00GobeAIol9BFoo2DU_oYSU4on[[l002on[[k`7og=_P0OmVIWh0000LofIVO_oIfMoohnGZon?T
j_oSiN_oTiBHoj>SXooRhN3ogmcComcJeooEIROogYd0omGC0?n[W`3o`9@0oiiO0?n=I`_oc94oomZ_
;?oLd:CoY:BTon?Uj_oSi>[ohnC[on?Uj_oSi>[o3Q0@on?Tj`;ohnG[00Go3Q0@on?Ujoo7`]7o3Q0@
olO2d@02on?Uj`04o`h@4?o7`]7o3Q0@olO2d@;ohnG[00Co3Q0@on?Ujol>413oal;A0_oSiN/00ol>
413oal;Aon?Uj`04on?Uj`07o`h@4?o7`]7o3Q0@olO2dOoSiN_o3Q0@olO2d@02on?Uj`05o`h@4?oS
iN_ohnG[o`h@4?o7`]401OoSiN/01ol>413ohnG[on?Ujol>413oal;Ao`h@4?o7`]400_oSiN/01?l>
413oal;Ao`h@4?o7`]42on?Uj`03o`h@4?o7`]7ohnG[00?ohnG[00?o3Q0@on?Ujoo7`]401OoSiN/0
1?l>413oal;Aon?UjooSiN/2o`h@4003olO2dOl>413oal;A00;ohnG[00Go3Q0@olO2dOoSiN_o3Q0@
olO2d@02on?Uj`08o`h@4?o7`]7ohnG[on?Ujol>413ohnG[o`h@4?o7`]42on?Uj`04o`h@4?o7`]7o
3Q0@olO2d@;ohnG[00Co3Q0@olO2dOl>413oal;A0_oSiN/01_l>413oal;Ao`h@4?o7`]7ohnG[o`h@
41KohnG[T?oSi>Z@on?UjP;ohnC[00CohnG[on?TjooSi>_ohnG[0_oSi>/00ooSiN[ohnCZon?Uj`05
on?Uj`03ojHiA?o=FEkobeAI00;ooooo0oo@FUl2ooooo`08oleFFoo;E5WocEUNojHiA?oSiN[ohnCZ
on?UjooIfMl1ofIVOP0000?oIVInomOHg_oLg^H00_oLg^H04_o0`LSoQHJ5ok>;G_o?R13ok/PCooKC
1?odi03oiN40oj>V0?mSJ@3oJ6<0onS;0?oo`@3oe]>_ooGemOnTYJGog=gVomcNiP;og=kU00?o3Q0@
olO2dOoLg^H00ooLg^D01?l>413oal;Ao`h@4?o7`]42omcNi@03o`h@4?o7`]7o3Q0@00Goal;A00Ko
3Q0@olO2dOoLg^Gog=kUo`h@4?o7`]45omcNi@06o`h@4?o7`]7o3Q0@olO2dOoLg^Go3Q0@1Oo7`]40
0ooLg^Go3Q0@olO2d@04omcNi@08o`h@4?oLg^Gog=kUomcNiOl>413oal;Ao`h@4?o7`]42omcNi@04
o`h@4?o7`]7o3Q0@olO2d@;og=kU00?o3Q0@olO2dOoLg^D01?oLg^D00ol>413og=kUolO2d@04omcN
i@09o`h@4?o7`]7og=kUo`h@4?o7`]7o3Q0@olO2dOl>413oal;A00;og=kU00Go3Q0@olO2dOoLg^Go
3Q0@olO2d@02omcNi@03o`h@4?o7`]7oal;A00?oal;A00So3Q0@olO2dOoLg^Gog=kUo`h@4?o7`]7o
3Q0@olO2d@;og=kU00Co3Q0@olO2dOl>413oal;A0_oLg^D01Ol>413oal;Ao`h@4?o7`]7o3Q0@0?oo
g=kU>?oLg^D00ooLg^Kog=kUomcNi@02omcNi@08omgNiOoLg^Kog=kUomcNi_oLg^Gog=kVomcNiOoM
gND3omcNi@03ojHiA?o=FEkodEYN00?ooooo00coeUmSooooooooooooooooomAMHOoAFUkocEUNojHi
A?oLg^Gog=kVomcNiOoGf=h1ofIVOP0001KoIVInomGFgOoEf>3oe]SQomGHh?mmOhCoU9BDogUeO?oA
ahSobI`<onbc0?o_/@3oomd0ogn90?l[8`3oYW`0oone0?oe/2goc/k>ooShn?nUY:GoeMSP0_oEf>40
1?oEen3o3Q0@olO2dOoFen43omKGh004o`h@4?o7`]7o3Q0@olO2d@;oe]OP00?o3Q0@olO2dOl>4100
1?l>41000oo7`]7o3Q0@olO2d@02omKGh003o`h@4?o7`]7oe]OP00Coe]OP00Go3Q0@omKGh?l>413o
e]OPolO2d@05o`h@4003olO2dOoFen3o3Q0@00;oal;A0_oFen000ol>413oe]OPomKGh002omKGh004
o`h@4?o7`]7o3Q0@olO2d@;oe]OP00Co3Q0@olO2dOl>413oal;A0_oFen000ol>413oal;AomKGh005
omKGh003o`h@4?o7`]7oe]OP00?oe]OP00Wo3Q0@olO2dOoFen3o3Q0@omKGh?l>413oal;Ao`h@4?o7
`]400_oFen001Ol>413oal;AomKGh?l>413oal;A00;oe]OP1Ol>41000oo7`]7o3Q0@olO2d@02omKG
h004o`h@4?o7`]7o3Q0@olO2d@;oe]OP00Co3Q0@olO2dOl>413oal;A0_oFen001_l>413oal;Ao`h@
4?l>413oe]OPolO2dAKoe]OPT?oFf>2@omGHh@0;omKGh?oFf>7oeMOPomGHh?oFen7oe]SQomKGh?oE
en7oeMOPomGGhOoFf>400_oFen401ooFf>7oe]SPomGGh?nV>DCoeemOom]TI?m67QX01Oooool02Om6
7Q[oh6MUom]TI?oGGeooYSU4omGHhOoEen3oeMSQomGFg@01ofIVOP0001GoIVInom;DgOo?d]cod=;L
om3BgOnc]KkoUiNGokNg]oo/k>codk1_on:>0?ofU03ofgD0of`L0?ll4@3offX0oon=0?omTP3oiZ=E
omK@bOnUYJD01?o@d]`00ol>413oal;AoloBg003om3Bg003o`h@4?o7`]7o3Q0@00?oal;A00Co3Q0@
om3Bg?l>413od=;L0_o7`]400ol>413od=;Lo`h@4003olO2d@03o`h@4?o@d]cod=;L00?od=;L00So
3Q0@olO2dOo@d]cod=;Lo`h@4?o7`]7o3Q0@om3Bg0;oal;A00?o3Q0@om3Bg?o@d]`00_l>41001?o@
d]coal;Ao`h@4?o@d]`3olO2d@05om3Bg?l>413oal;Ao`h@4?o@d]`00_o7`]400ol>413od=;Lo`h@
4003olO2d@03o`h@4?o@d]cod=;L00God=;L00?o3Q0@om3Bg?o7`]400oo@d]`02Ol>413oal;Ao`h@
4?o7`]7od=;Lo`h@4?o7`]7o3Q0@om3Bg002olO2d@04o`h@4?o@d]cod=;Lo`h@40?oal;A00Oo3Q0@
om3Bg?o7`]7oal;Ao`h@4?o@d]co3Q0@00?oal;A00Co3Q0@om3Bg?l>413od=;L0_o7`]401?l>413o
d=;Lo`h@4?o@d]`2olO2d@07o`h@4?o@d]co3Q0@olO2dOl>413od=;LolO2d@0Eom3Bg93ocm;MT?o@
d]`3oloBg003oloBgOo@d]cod=;L00;ocm;L0_o@d]`2oloBg009om3BgOo@d]cocm;LoloBg?nV>DCo
ffATon5YIOoPK6WoAQhJ00?ooooo00KoAQhJon1/JOoPK6WohFUUom]TI?nV>D@2om3Bg07ocm;L0OoB
e=d1ofIVOP0000?oIVInolo?f_o5b=@00_o5b=@04_mjO8?oVIVIojJWY_oPeloob7h=om9f0?oNI`3o
a5L0oj=20?mI4P3o^3`0ooma0OojR@gokJe?onc7S_nVYZKoaLODolG8e0;oaLOD00?o3Q0@olG7eOo7
`]400oo4amD00ol>413oa<OEo`h@4003o`h@40?oa<OE0ol>4102olC7e@Co3Q0@1_o4amD01ol>413o
al;AolC7eOo4amGo3Q0@olO2dOo4amD00ol>4103olC7e@03o`h@4?o4amGo3Q0@00;oa<OE0ol>4100
0oo4amGo3Q0@o`h@4002olC7e@?o3Q0@0_o4amD4o`h@40Koa<OE00Goal;AolC7eOo4amGo3Q0@olO2
d@03olC7e@03o`h@4?o7`]7o3Q0@00;oa<OE00?o3Q0@olO2dOo4amD00ol>4102olC7e@Co3Q0@0_o4
amD3o`h@40;oa<OE1?l>4103olC7e@?o3Q0@0oo4amD3o`h@40;oa<OE00Co3Q0@olO2dOo4amGo3Q0@
5_o4amF@olC8e93oa<OD00GoaLSDolG7e?o4b=CoaLSDolG7e@02olG7e003olC7e?o5b=GoaLOD00;o
aLOD0_o5b=@01_o4b=CoaLODojHiA?oTKVgoi7A_onMaK`Gooooo00Goi7A_onMaKooTM6ooi6i]ojHi
A002olC8e07oaLOE0Oo?cmX1ofIVOP0001KoIVInolc>f_o2a=;o`LCAol74d_nPXjooWYjMon7Nf_o7
U4CocJE/om5k9?oQZ03onl80on^F0?nSG`3oS4H0ooeX0onn^;7olO7aoo_knonVYZKo`/CB0oo1a=80
0oo2a=7o3Q0@ol74dP02olO2d@03o`h@4?o1a=7o`LCA01Ko`LCA00Oo3Q0@ol74dOo1a=7o`LCAo`h@
4?o1a=7oal;A017o`LCA00?oal;Aol74dOo1a=403Oo1a=401Ol>413o`LCAolO2dOo7`]7o3Q0@00Co
`LCA0_l>4103ol74d@03o`h@4?o7`]7o`LCA00Ko`LCA00?o3Q0@olO2dOo1a=401oo1a=400ol>413o
al;Aol74d@0?ol74d@03o`h@4?o7`]7o`LCA01Oo`LCAT?o1a=:@ol;4dP03ol74d_o2a=7o`LCB00;o
`LCB00Co`/CAol;4d_o1a=7o`LCB0_o2a=800oo1a=7o`/CBol;4d@02ol74d@03ojHiA?oZNG?ojGah
00?ooooo00coAQhJooooooooooooooooonn1N_oYO7SojWUcojHiA?o2a=7o`LCAol74d_o<c]X1ofIV
OP0001_oIVInol[<f?nn`<oo_L3?okk0c_n2Q8goSHf=ogYhM?o/j^Gol?3`olB>?OoYb@3olKH2omZ>
0?o7N@7oXgHHojaR0?oQ/IKof][JooWinOnVYZKo_/3?okk0c_nn`<oo_/3>okk0conm`<h00ol>410H
okk0cP03o`h@4?nn`<ko_/3>00?o_/3>00?o3Q0@okk0c_nn`<h03onn`<h00ol>413o_/3>okk0cP0?
okk0cP?o3Q0@1Onn`<h00ol>413o_/3>okk0cP02okk0cP03o`h@4?nn`<ko_/3>00Ko_/3>00?o3Q0@
okk0c_nn`<h01onn`<h00ol>413o_/3>okk0cP0?okk0cP03o`h@4?nn`<ko_/3>01Oo_/3>T?nm`<jA
okk0cP;o_L3>00Co_L3?okg0c_nn`<ko_/3?0_nn`<h02_nm`<oo_/3?okg0conn`<ko_L3>okk0c_nn
`<ooYSU4oo60MOo`Q7`2ooooo`03odHN6_oa/Y_oAQhJ00;ooooo00ComHb4oo24O?oaP7GoYSU40_nn
`<l1okk0cP7ob/cH0OmVIWh0000EofIVO_o9b]So][S8okVlbonj_<_oRhfIoijNW_oEe=Col?3`oo;b
l_oAYaWoiM:3oo;Zd?oXXakod90@olk>c_oQf/KocZ9^ongPfOogmoOoYZNW00;o^Kc<00Go^[_<okVl
bonj_<_o^Kc<okVlb`2@okVlc93o^[c<TOnj_</01?nj_<co^Kc;okVlc?nj_<`2okZlb`;o^[c<00[o
^Kc<okZlc?nj_<_o^Kc;okZlc?ni_<co^Kc;ojHiA?odRWgomI250_m67QX3oo:hWP;oAQhJ0_oeT8D0
1_odRWgoYSU4okZkc?ni_<_o][S8olW:f07oIVIn00000omVIWkoa/SGokRgc`02ojn^a`0@oh^:W_n6
QXKoU9BCoo;bl_oUe[kolo2moo;bl_ofm_Kol<NBonBU=ooWinOono_kooShmOomm>koo_knojNWYooo
[jk7b?n_[/L01OnAV:[oYSU4oonOSOon_jCon]bg00;on^Vf0_oijKH01Oojg;Ooo[nToonOSOnV>DCo
TIRZ00;o[jk70Onh]ll1olK8e`7oIVIn00000omVIWko`<7AolO7e002ojb[a00=og9aP_nPX:3ohN3Q
oo?clooemNkomOGeooKfm_ohn?SomO;/on[BYOoinOWoo?cloogmo@02ooknoP03ojNWYon/ZlCo[:_4
0?oo[:_4aon/Zl@00on4S:;oYSU4ojHiA008ojHiA006ohB<X_n/ZlCo[:_4ojb[a?o7amCo`<7A0OmV
IWh00007oooooonXYkooi^K]om;Bh?nl_<ooXJ2bohf=S@0>ojZZZ_ooZ:NoeOnXYkl01Ona/<Co_;c?
om;Bh?oVi^goZ:No007ooooo00001oooooooQhNKomOHh_olo?coi>?Xom3@h?o:b]X0oonl_<oRokbl
c`06ol[:f_o@d>3oi>?Xooclo?oGf>;oQhNK0Oooool000;ooooo00KoUIB[omOHh_olo?col_7conc[
k_oQh^_oomOHh^3oemSR00KohN;[onc[k_oblO?oo?clomOHh_nEU:/2ooooo`000oooool2ofIVOP03
ohR7WOnEU:_oZ:No0?ooZ:NohOnXYkl01?nEU:_oR8NMofIVO_mVIWh3ooooo`001OooooooofIVO^Ko
IVIn1Oooool00001\
\>"], "ItemizedPicture",
  Evaluatable->False,
  ImageSize->{495, 373},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}]
}, Closed]],

Cell[TextData[{
  StyleBox["NotebookConvert[", "MR"],
  StyleBox["notebook", "TI"],
  StyleBox["]", "MR"],
  " converts notebooks to the new format and saves the result in a file. The \
name of the new notebook is based on the name of the old notebook, except \
that the extension .nb is used in place of the .m or .ma extension that was \
used in previous versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],

Cell[TextData[{
  "Although ",
  StyleBox["NotebookConvert", "MR"],
  " is a kernel function, the actual conversion is handled by the front end, \
so notebook names must be specified in a way that is appropriate for the \
front end, rather than for the kernel. If the notebooks that you want to \
convert are not in the same directory as the directory from which you \
launched the front end, then the notebooks should be specified by giving the \
directory path relative to the front end directory or by giving an absolute \
pathname. "
}], "Text",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],

Cell[TextData[{
  "You can use ",
  StyleBox["Scan[", "MR"],
  StyleBox["NotebookConvert", "MR"],
  ", ",
  StyleBox["list", "TI"],
  StyleBox["]", "MR"],
  " to convert all of the notebooks listed in ",
  StyleBox["list", "TI"],
  ". If the kernel and the front end are running on the same computer, you \
can use ",
  StyleBox["NotebookConvert[", "MR"],
  StyleBox["dir", "TI"],
  StyleBox["]", "MR"],
  " to convert all of the files in the directory ",
  StyleBox["dir", "TI"],
  "."
}], "Text",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],

Cell[TextData[{
  StyleBox["T I P S", "UserBoxHeading"],
  "\n\[Bullet] You can specify the name of the new notebook explicitly using \
",
  StyleBox["NotebookConvert[", "MR"],
  StyleBox["old, new", "SO"],
  StyleBox["]", "MR"],
  ", which saves the result in a notebook with the name ",
  StyleBox["new", "SO"],
  ".\n\[Bullet] ",
  StyleBox["NotebookConvert", "MR"],
  " also supports the ",
  StyleBox["Interactive", "MR"],
  " option, which allows you to specify whether you want to see the Save \
dialog box if a notebook with the same name as the new notebook already \
exists."
}], "UserTips",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 938}},
ScreenStyleEnvironment->"Working",
PrintingStyleEnvironment->"Printout",
WindowToolbars->{},
WindowSize->{550, 500},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->63,
PrintingPageRange->{Automatic, Automatic},
TaggingRules:>{"NextIndexingNumber" -> 70, "PaginationCache" -> {{2003, 5, \
16, 13, 1, 15.2773993`8.936624378024012}, {45, 45, 45, 45, 45, 45, 45, 45, \
45, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 47, \
47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, \
48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, \
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, \
51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 53, 53, 53, 53, 53, \
53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, \
54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, \
56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 58, 58, 58, 58, 58, \
58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 59, \
59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, \
61, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 63, 63, \
63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, \
64, 64, 64, 64, 64, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, \
66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66}}, "IndexEntries" -> {{"i:1", \
"Configuration information"}, {"i:1", "Initialization files"}, {"i:1", \
"MATHEMATICA_PREFERENCES"}, {"i:1", 
  StyleBox[ "$BaseDirectory", "MR"]}, {"i:1", 
  StyleBox[ 
  "$UserBaseDirectory", 
    "MR"]}, {"i:10", "BrowserCategories.m"}, {"i:14", "Autoloading \
packages"}, {"i:15", "Filemap"}, {"i:15", "SharedMemory"}, {"i:15", "TCP"}, \
{"i:2", "Caches"}, {"i:2", "Rebuilding caches"}, {"i:2", "System resources"}, \
{"i:2", "Text resources"}, {"i:2", 
  StyleBox[ "ConfigurationPath", "MR"]}, {"i:2", 
  StyleBox[ 
  "PreferencesPath", "MR"]}, {"i:20", "Rerendering graphics"}, {"i:20", 
  StyleBox[ 
  "Rerender Graphics", 
    "SR"]}, {"i:22", "Restarting front end"}, {"i:23", "DriveSpace"}, \
{"i:23", "SCANDISK"}, {"i:27", "Troubleshooting on Mac OS X"}, {"i:29", \
"Bundles"}, {"i:32", {
  StyleBox[ "Remove[", "MR"], 
  StyleBox[ "vars", "TI"], 
  StyleBox[ "]", "MR"]}}, {"i:32", 
  StyleBox[ "Share", "MR"]}, {"i:32", 
  StyleBox[ "$HistoryLength", "MR"]}, {"i:37", 
  StyleBox[ "Rerender Graphics", "SR"]}, {"i:39", 
  StyleBox[ "rsh", "MR"]}, {"i:4", 
  StyleBox[ 
  "$Path", "MR"]}, {"i:40", "NFS"}, {"i:40", "UFS"}, {"i:45", \
"Troubleshooting on Unix/Linux"}, {"i:45", "Unix/Linux troubleshooting"}, \
{"i:48", "Private colormaps"}, {"i:50", 
  StyleBox[ "kill", "MR"]}, {"i:51", "Resetting key assignments"}, {"i:51", 
  StyleBox[ 
  "xmodmap", 
    "MR"]}, {"i:54", "Front end keybindings"}, {"i:58", "Upgrading"}, \
{"i:64", "Converting notebooks to Version 5 format"}, {"i:64", "Format of \
notebook files"}, {"i:64", 
  StyleBox[ "NotebookConvert", "MR"]}, {"i:67", 
  StyleBox[ 
  "mathematica -cleanStart", 
    "MR"]}, {"i:9", "Downloading fonts to printer"}, {"i:9", "Properties \
dialog box"}, {"i:10", "Language subdirectory", "for documentation"}, \
{"i:12", "Packages", "location of standard packages"}, {"i:12", "Standard \
packages", "location"}, {"i:13", "Application package locations", "from \
Applications Library"}, {"i:14", "Application package locations", "and \
Autoload subdirectory"}, {"i:15", "Mac OS X", "available transport \
mechanisms"}, {"i:15", "Mac OS X", "TCP"}, {"i:15", "Unix/Linux", "and \
TCPIP"}, {"i:15", "Windows", "available transport mechanisms"}, {"i:15", \
"Windows", "Filemap"}, {"i:15", "Windows", "SharedMemory"}, {"i:15", \
"Windows", "TCP"}, {"i:15", 
  StyleBox[ 
  "MathLink", FontSlant -> 
    "Italic"], "transport mechanisms"}, {"i:16", "Windows", \
"troubleshooting"}, {"i:17", "Installation", "Windows troubleshooting"}, \
{"i:17", "Troubleshooting on Windows", "installation"}, {"i:18", "Caches", \
"Windows"}, {"i:19", "Minimal installation", "and Help Browser files"}, \
{"i:2", "Front end", "init.m"}, {"i:2", "Front end", "preferences"}, {"i:2", \
"Preferences", "front end"}, {"i:20", "Graphics", "Windows troubleshooting"}, \
{"i:20", "Troubleshooting on Windows", "graphics"}, {"i:20", "Windows \
troubleshooting", "graphics"}, {"i:21", "Application packages", "Windows \
troubleshooting"}, {"i:21", "Standard application packages", "Windows \
troubleshooting"}, {"i:21", "Troubleshooting on Windows", "application \
packages"}, {"i:22", "Crashes", "Windows"}, {"i:22", "Troubleshooting on \
Windows", "crashes"}, {"i:23", "Long pathnames", "Windows"}, {"i:23", \
"Troubleshooting on Windows", "and DriveSpace"}, {"i:23", "Troubleshooting on \
Windows", "long pathnames"}, {"i:23", "Troubleshooting on Windows", \
"SCANDISK"}, {"i:23", "Windows troubleshooting", "and DriveSpace"}, {"i:23", \
"Windows troubleshooting", "and long pathnames"}, {"i:23", "Windows \
troubleshooting", "and SCANDISK"}, {"i:25", "Memory", "Windows"}, {"i:25", \
"Troubleshooting on Windows", "memory"}, {"i:26", "Display", "Windows \
requirements"}, {"i:26", "Troubleshooting on Windows", "display"}, {"i:26", \
"Windows troubleshooting", "display"}, {"i:27", "Mac OS X", \
"troubleshooting"}, {"i:28", "Installation", "Mac OS X troubleshooting"}, \
{"i:28", "Mac OS X troubleshooting", "installation"}, {"i:28", \
"Troubleshooting on Mac OS X", "installation"}, {"i:29", "Mac OS X", \
"bundles"}, {"i:29", "Mac OS X troubleshooting", "bundles"}, {"i:29", \
"Troubleshooting on Mac OS X", "bundles"}, {"i:31", "Mac OS X \
troubleshooting", "optimizing memory"}, {"i:31", "Optimizing memory", "Mac OS \
X"}, {"i:31", "Troubleshooting on Mac OS X", "optimizing memory"}, {"i:32", \
"Kernel", "and memory on Mac OS X"}, {"i:32", "Memory", "and kernel use on \
Mac OS X"}, {"i:32", "Troubleshooting on Mac OS X", "kernel memory use"}, \
{"i:33", "Mac OS X troubleshooting", "window title bars"}, {"i:33", \
"Troubleshooting on Mac OS X", "window title bars"}, {"i:34", "Mac OS X \
troubleshooting", "pathnames"}, {"i:34", "Pathnames", "and Mac OS X"}, \
{"i:34", "Troubleshooting on Mac OS X", "pathnames"}, {"i:37", "Graphics", \
"troubleshooting on Mac OS X"}, {"i:37", "Mac OS X troubleshooting", \
"graphics"}, {"i:37", "Troubleshooting on Mac OS X", "graphics"}, {"i:38", \
"Mac OS X troubleshooting", "application packages"}, {"i:38", \
"Troubleshooting on Mac OS X", "application packages"}, {"i:39", "Mac OS X \
troubleshooting", "and remote kernels"}, {"i:39", "Remote kernels", \
"troubleshooting on Mac OS X"}, {"i:39", "Troubleshooting on Mac OS X", "and \
remote kernels"}, {"i:4", "Kernel", "preferences"}, {"i:40", "File \
extensions", "troubleshooting on Mac OS X"}, {"i:40", "File systems", "and \
Mac OS X"}, {"i:40", "Mac OS X troubleshooting", "file extensions"}, {"i:40", \
"Troubleshooting on Mac OS X", "file extensions"}, {"i:41", "Front end \
command-line options", "Mac OS X"}, {"i:41", "Mac OS X troubleshooting", \
"front end command line options"}, {"i:42", "Kernel command-line options", \
"Mac OS X"}, {"i:42", "Mac OS X troubleshooting", "kernel command-line \
options"}, {"i:42", "Troubleshooting on Mac OS X", "kernel command-line \
options"}, {"i:44", "Fonts", "Mac OS X"}, {"i:44", "Mac OS X \
troubleshooting", "fonts"}, {"i:44", "Troubleshooting on Mac OS X", "fonts"}, \
{"i:46", "Installation", "Unix/Linux troubleshooting"}, {"i:46", \
"Troubleshooting on Unix/Linux", "installation"}, {"i:46", "Unix/Linux \
troubleshooting", "installation"}, {"i:48", "Graphics", "Unix/Linux \
troubleshooting"}, {"i:48", "Troubleshooting on Unix/Linux", "and private \
colormap"}, {"i:48", "Troubleshooting on Unix/Linux", "graphics"}, {"i:48", \
"Unix/Linux troubleshooting", "and private colormap"}, {"i:48", "Unix/Linux \
troubleshooting", "graphics"}, {"i:49", "Application packages", "Unix/Linux \
troubleshooting"}, {"i:49", "Troubleshooting on Unix/Linux", "application \
packages"}, {"i:49", "Unix/Linux troubleshooting", "application packages"}, \
{"i:50", "Crashes", "Unix/Linux"}, {"i:50", "Troubleshooting on Unix/Linux", \
"crashes"}, {"i:50", "Unix/Linux troubleshooting", "crashes"}, {"i:51", \
"Keyboard settings", "and Unix/Linux"}, {"i:51", "Troubleshooting on \
Unix/Linux", "keyboard settings"}, {"i:51", "Unix/Linux troubleshooting", \
"keyboard settings"}, {"i:52", "Fonts", "Unix/Linux troubleshooting"}, \
{"i:52", "Troubleshooting on Unix/Linux", "fonts"}, {"i:52", "Unix/Linux \
troubleshooting", "fonts"}, {"i:53", "Display", "Unix/Linux \
troubleshooting"}, {"i:53", "Troubleshooting on Unix/Linux", "display"}, \
{"i:53", "Unix/Linux troubleshooting", "display"}, {"i:54", "Troubleshooting \
on Unix/Linux", "window managers"}, {"i:54", "Unix/Linux troubleshooting", \
"window managers"}, {"i:54", "Window managers", "Unix/Linux \
troubleshooting"}, {"i:55", "Front end", "Unix/Linux resources"}, {"i:55", \
"Troubleshooting on Unix/Linux", "front end resources"}, {"i:55", "Unix/Linux \
troubleshooting", "front end resources"}, {"i:56", "Front end command-line \
options", "Unix/Linux"}, {"i:56", "Troubleshooting on Unix/Linux", "front end \
command-line options"}, {"i:56", "Unix/Linux", "front end command-line \
options"}, {"i:57", "Kernel command-line options", "Unix/Linux"}, {"i:57", \
"Troubleshooting on Unix/Linux", "kernel command-line options"}, {"i:57", \
"Unix/Linux", "kernel command-line options"}, {"i:59", "Installing", "over \
previous versions"}, {"i:59", "Previous versions", "installing over"}, \
{"i:59", "Upgrading", "installation"}, {"i:60", "Application packages", {"and \
earlier versions of ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"]}}, {"i:60", "Packages", {"created with earlier versions of ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"]}}, {"i:61", "Remote kernels", {"and earlier versions of ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"]}}, {"i:62", "Applications library", {"and earlier versions of \
", 
  StyleBox[ 
  "Mathematica", FontSlant -> "Italic"]}}, {"i:63", "Notebooks", {"in ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " 5"}}, {"i:64", "Notebooks", "converting from Version 2.2"}, \
{"i:65", "Front end", "preferences"}, {"i:65", "Mac OS X troubleshooting", \
"initialization file"}, {"i:65", "Mac OS X troubleshooting", "preferences"}, \
{"i:65", "Preferences", "Mac OS X troubleshooting"}, {"i:65", \
"Troubleshooting on Mac OS X", "initialization file"}, {"i:65", \
"Troubleshooting on Mac OS X", "preferences"}, {"i:66", "Caches", "Mac OS \
X"}, {"i:66", "Help Browser", "troubleshooting on Mac OS X"}, {"i:66", "Mac \
OS X troubleshooting", "caches"}, {"i:66", "Mac OS X troubleshooting", "Help \
Browser"}, {"i:66", "Text resource files", "Mac OS X"}, {"i:66", \
"Troubleshooting on Mac OS X", "caches"}, {"i:66", "Troubleshooting on Mac OS \
X", "Help Browser"}, {"i:67", "Preferences", "Unix/Linux troubleshooting"}, \
{"i:67", "Troubleshooting on Unix/Linux", "initialization file"}, {"i:67", \
"Troubleshooting on Unix/Linux", "preferences"}, {"i:67", "Unix/Linux \
troubleshooting", "initialization file"}, {"i:67", "Unix/Linux \
troubleshooting", "preferences"}, {"i:68", "Help Browser", "troubleshooting \
on Unix/Linux"}, {"i:68", "Text resource files", "Unix/Linux"}, {"i:68", \
"Troubleshooting on Unix/Linux", "caches"}, {"i:68", "Troubleshooting on \
Unix/Linux", "Help Browser"}, {"i:68", "Unix/Linux troubleshooting", \
"caches"}, {"i:68", "Unix/Linux troubleshooting", "Help Browser"}, {"i:69", \
"Preferences", "Windows troubleshooting"}, {"i:69", "Troubleshooting on \
Windows", "preferences"}, {"i:69", "Windows troubleshooting", "initialization \
files"}, {"i:69", "Windows troubleshooting", "preferences"}, {"i:7", \
"Configuration file", "front end"}, {"i:7", "Front end", "configuration \
file"}, {"i:7", "Palettes", "and front end configuration"}, {"i:8", \
"Configuration file", "kernel"}, {"i:8", "Evaluations", "at startup"}, \
{"i:8", "Kernel", "configuration file"}, {"i:9", "Fonts", "installation"}, \
{"i:9", "Fonts", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"]}, {"i:9", "Windows", "Properties dialog box"}, {"i:1", "Base \
directory", "", ""}, {"i:1", "Preferences", "directory", ""}, {"i:10", \
"Documentation", "location in layout", ""}, {"i:12", "Application package \
locations", "standard packages", ""}, {"i:13", "Packages", "location of \
application packages", ""}, {"i:15", "Mac OS X", "Pipes", ""}, {"i:15", "Mac \
OS X", "TCPIP", ""}, {"i:15", "TCPIP", "", ""}, {"i:15", "Windows", "TCPIP", \
""}, {"i:17", "setup.exe", "", ""}, {"i:17", "Windows troubleshooting", \
"installation", ""}, {"i:19", "Help Browser", "troubleshooting on Windows", \
""}, {"i:19", "Troubleshooting on Windows", "Help Browser", ""}, {"i:19", \
"Windows troubleshooting", "Help Browser", ""}, {"i:2", "Preferences", \
"stored in cache", ""}, {"i:21", "Windows troubleshooting", "application \
packages", ""}, {"i:22", "Windows troubleshooting", "crashes", ""}, {"i:25", \
"Windows troubleshooting", "memory", ""}, {"i:32", "Mac OS X \
troubleshooting", "kernel memory use", ""}, {"i:33", "Window title bars", \
"and Mac OS X", ""}, {"i:38", "Application packages", "Mac OS X \
troubleshooting", ""}, {"i:4", "Kernel", "init.m", ""}, {"i:40", "HFS/HFS+", \
"", ""}, {"i:41", "Troubleshooting on Mac OS X", "front end command-line \
options", ""}, {"i:6", "Base directory", "and systemwide defaults", ""}, \
{"i:6", "Systemwide defaults", "", ""}, {"i:68", "Caches", "Unix/Linux", ""}, \
{"i:9", "Fonts", "downloading to printer", ""}}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Versions on CD-ROM"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "CD-ROM: versions available on"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Additional versions"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Front end only versions"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "High school versions"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Student versions"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "MathLink Developer's Kits"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Developer kits: MathLink"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Installation details"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Installation: types of"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Types of installation"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Sizes of installations"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Minimal installation"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Front end only: installing"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Installation: front end only"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Kernel only: installing"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Installation: kernel only"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Documentation: installing"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Standard add-on packages: installing"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Custom installation directions"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Initialization files"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Startup files"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Memory requirements"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Removing all files"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Uninstalling Mathematica"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "init.m: for front end"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "ConfigurationPath"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "PreferencesPath"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Preferences: front end"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Preferences: kernel"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Resources: front end"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Resources: kernel"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "init.m: for kernel"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Site administration"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Configuration folder"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Fonts"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Documentation configuration"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "BrowserIndex"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Location of packages"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Standard add-on packages: location"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Packages: location of"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Application packages: location"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Autoload packages: location"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "Loading packages automatically"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}]},
  "layout"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}],
    Cell[3076, 75, 277, 9, 70, "Highlight",
      CellTags->{"layout", "gs:0.19"}],
    Cell[3378, 88, 111, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[3492, 91, 330, 6, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[3825, 99, 509, 12, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[4337, 113, 2040, 56, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[6380, 171, 348, 9, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[6731, 182, 1984, 54, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[8718, 238, 354, 9, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[9075, 249, 281, 7, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[9393, 261, 86, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[9482, 264, 477, 10, 70, "Text",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[9962, 276, 360, 9, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[10325, 287, 262, 5, 70, "Text",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[10590, 294, 1914, 49, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[12541, 348, 83, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[12627, 351, 297, 8, 70, "Text",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[12927, 361, 335, 8, 70, "Text",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[13299, 374, 127, 2, 70, "Subsubsection",
      CellTags->{
      "layout", "Configuration_subsection", "i:6", "b:18.3", "gs:0.19"}],
    Cell[13429, 378, 373, 9, 70, "Text",
      CellTags->{"layout", "i:6", "b:18.3", "gs:0.19"}],
    Cell[13805, 389, 129, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[13937, 392, 337, 7, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14277, 401, 156, 6, 70, "ItemizedList",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14436, 409, 250, 7, 70, "ItemizedList",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14689, 418, 249, 6, 70, "Text",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14941, 426, 126, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}],
    Cell[15070, 429, 850, 25, 70, "Text",
      CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}],
    Cell[15957, 459, 82, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16042, 462, 651, 14, 70, "Text",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16696, 478, 222, 5, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16921, 485, 218, 5, 70, "Text",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[17176, 495, 120, 2, 70, "Subsubsection",
      PageBreakAbove->Automatic,
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17299, 499, 387, 8, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17689, 509, 155, 4, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17847, 515, 143, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17993, 521, 139, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18135, 527, 147, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18285, 533, 143, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18431, 539, 334, 7, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18802, 551, 99, 1, 70, "Subsubsection",
      CellTags->{"layout", "b:18.6", "gs:0.19"}],
    Cell[18904, 554, 98, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],
    Cell[19005, 557, 378, 7, 70, "Text",
      CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],
    Cell[19386, 566, 101, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[19490, 569, 326, 10, 70, "Text",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[19819, 581, 466, 11, 70, "Text",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[20288, 594, 106, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[20397, 597, 605, 17, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21005, 616, 211, 5, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21219, 623, 279, 7, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21535, 635, 129, 2, 70, "Subsubsection",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
    Cell[21667, 639, 353, 8, 70, "Text",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
    Cell[22023, 649, 236, 6, 70, "Text",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}]},
  "gs:0.19"->{
    Cell[1776, 53, 1297, 20, 36, "Subsection",
      CellTags->{
      "Versions on CD-ROM", "CD-ROM: versions available on", 
        "Additional versions", "Front end only versions", 
        "High school versions", "Student versions", 
        "MathLink Developer's Kits", "Developer kits: MathLink", 
        "Installation details", "Installation: types of", 
        "Types of installation", "Sizes of installations", 
        "Minimal installation", "Front end only: installing", 
        "Installation: front end only", "Kernel only: installing", 
        "Installation: kernel only", "Documentation: installing", 
        "Standard add-on packages: installing", 
        "Custom installation directions", "Initialization files", 
        "Startup files", "Memory requirements", "Removing all files", 
        "Uninstalling Mathematica", "init.m: for front end", 
        "ConfigurationPath", "PreferencesPath", "Preferences: front end", 
        "Preferences: kernel", "Resources: front end", "Resources: kernel", 
        "init.m: for kernel", "Site administration", "Configuration folder", 
        "Fonts", "Documentation configuration", "BrowserIndex", 
        "Location of packages", "Standard add-on packages: location", 
        "Packages: location of", "Application packages: location", 
        "Autoload packages: location", "Loading packages automatically", 
        "layout", "gs:0.19"}],
    Cell[3076, 75, 277, 9, 70, "Highlight",
      CellTags->{"layout", "gs:0.19"}],
    Cell[3378, 88, 111, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[3492, 91, 330, 6, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[3825, 99, 509, 12, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[4337, 113, 2040, 56, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[6380, 171, 348, 9, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[6731, 182, 1984, 54, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[8718, 238, 354, 9, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[9075, 249, 281, 7, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[9393, 261, 86, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[9482, 264, 477, 10, 70, "Text",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[9962, 276, 360, 9, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[10325, 287, 262, 5, 70, "Text",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[10590, 294, 1914, 49, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[12541, 348, 83, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[12627, 351, 297, 8, 70, "Text",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[12927, 361, 335, 8, 70, "Text",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[13299, 374, 127, 2, 70, "Subsubsection",
      CellTags->{
      "layout", "Configuration_subsection", "i:6", "b:18.3", "gs:0.19"}],
    Cell[13429, 378, 373, 9, 70, "Text",
      CellTags->{"layout", "i:6", "b:18.3", "gs:0.19"}],
    Cell[13805, 389, 129, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[13937, 392, 337, 7, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14277, 401, 156, 6, 70, "ItemizedList",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14436, 409, 250, 7, 70, "ItemizedList",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14689, 418, 249, 6, 70, "Text",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14941, 426, 126, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}],
    Cell[15070, 429, 850, 25, 70, "Text",
      CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}],
    Cell[15957, 459, 82, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16042, 462, 651, 14, 70, "Text",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16696, 478, 222, 5, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16921, 485, 218, 5, 70, "Text",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[17176, 495, 120, 2, 70, "Subsubsection",
      PageBreakAbove->Automatic,
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17299, 499, 387, 8, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17689, 509, 155, 4, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17847, 515, 143, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17993, 521, 139, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18135, 527, 147, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18285, 533, 143, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18431, 539, 334, 7, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18802, 551, 99, 1, 70, "Subsubsection",
      CellTags->{"layout", "b:18.6", "gs:0.19"}],
    Cell[18904, 554, 98, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],
    Cell[19005, 557, 378, 7, 70, "Text",
      CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],
    Cell[19386, 566, 101, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[19490, 569, 326, 10, 70, "Text",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[19819, 581, 466, 11, 70, "Text",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[20288, 594, 106, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[20397, 597, 605, 17, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21005, 616, 211, 5, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21219, 623, 279, 7, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21535, 635, 129, 2, 70, "Subsubsection",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
    Cell[21667, 639, 353, 8, 70, "Text",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
    Cell[22023, 649, 236, 6, 70, "Text",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}]},
  "i:1"->{
    Cell[3378, 88, 111, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[3492, 91, 330, 6, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[3825, 99, 509, 12, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[4337, 113, 2040, 56, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[6380, 171, 348, 9, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[6731, 182, 1984, 54, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[8718, 238, 354, 9, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[9075, 249, 281, 7, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[10590, 294, 1914, 49, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}]},
  "b:18.0"->{
    Cell[3378, 88, 111, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[3492, 91, 330, 6, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[3825, 99, 509, 12, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[4337, 113, 2040, 56, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[6380, 171, 348, 9, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[6731, 182, 1984, 54, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[8718, 238, 354, 9, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[9075, 249, 281, 7, 70, "Text",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
    Cell[10590, 294, 1914, 49, 70, "2ColumnBox",
      CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}]},
  "i:2"->{
    Cell[9393, 261, 86, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[9482, 264, 477, 10, 70, "Text",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[9962, 276, 360, 9, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[10325, 287, 262, 5, 70, "Text",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}]},
  "b:18.1"->{
    Cell[9393, 261, 86, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[9482, 264, 477, 10, 70, "Text",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[9962, 276, 360, 9, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
    Cell[10325, 287, 262, 5, 70, "Text",
      CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}]},
  "i:4"->{
    Cell[12541, 348, 83, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[12627, 351, 297, 8, 70, "Text",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[12927, 361, 335, 8, 70, "Text",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}]},
  "b:18.2"->{
    Cell[12541, 348, 83, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[12627, 351, 297, 8, 70, "Text",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
    Cell[12927, 361, 335, 8, 70, "Text",
      CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}]},
  "Configuration_subsection"->{
    Cell[13299, 374, 127, 2, 70, "Subsubsection",
      CellTags->{
      "layout", "Configuration_subsection", "i:6", "b:18.3", "gs:0.19"}]},
  "i:6"->{
    Cell[13299, 374, 127, 2, 70, "Subsubsection",
      CellTags->{
      "layout", "Configuration_subsection", "i:6", "b:18.3", "gs:0.19"}],
    Cell[13429, 378, 373, 9, 70, "Text",
      CellTags->{"layout", "i:6", "b:18.3", "gs:0.19"}]},
  "b:18.3"->{
    Cell[13299, 374, 127, 2, 70, "Subsubsection",
      CellTags->{
      "layout", "Configuration_subsection", "i:6", "b:18.3", "gs:0.19"}],
    Cell[13429, 378, 373, 9, 70, "Text",
      CellTags->{"layout", "i:6", "b:18.3", "gs:0.19"}],
    Cell[13805, 389, 129, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[13937, 392, 337, 7, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14277, 401, 156, 6, 70, "ItemizedList",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14436, 409, 250, 7, 70, "ItemizedList",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14689, 418, 249, 6, 70, "Text",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14941, 426, 126, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}],
    Cell[15070, 429, 850, 25, 70, "Text",
      CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}]},
  "i:7"->{
    Cell[13805, 389, 129, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[13937, 392, 337, 7, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14277, 401, 156, 6, 70, "ItemizedList",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14436, 409, 250, 7, 70, "ItemizedList",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
    Cell[14689, 418, 249, 6, 70, "Text",
      CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}]},
  "i:8"->{
    Cell[14941, 426, 126, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}],
    Cell[15070, 429, 850, 25, 70, "Text",
      CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}]},
  "i:9"->{
    Cell[15957, 459, 82, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16042, 462, 651, 14, 70, "Text",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16696, 478, 222, 5, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16921, 485, 218, 5, 70, "Text",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}]},
  "b:18.4"->{
    Cell[15957, 459, 82, 1, 70, "Subsubsection",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16042, 462, 651, 14, 70, "Text",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16696, 478, 222, 5, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
    Cell[16921, 485, 218, 5, 70, "Text",
      CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}]},
  "i:10"->{
    Cell[17176, 495, 120, 2, 70, "Subsubsection",
      PageBreakAbove->Automatic,
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17299, 499, 387, 8, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17689, 509, 155, 4, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17847, 515, 143, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17993, 521, 139, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18135, 527, 147, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18285, 533, 143, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18431, 539, 334, 7, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}]},
  "b:18.5"->{
    Cell[17176, 495, 120, 2, 70, "Subsubsection",
      PageBreakAbove->Automatic,
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17299, 499, 387, 8, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17689, 509, 155, 4, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17847, 515, 143, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[17993, 521, 139, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18135, 527, 147, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18285, 533, 143, 4, 70, "BulletedList",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
    Cell[18431, 539, 334, 7, 70, "Text",
      CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}]},
  "b:18.6"->{
    Cell[18802, 551, 99, 1, 70, "Subsubsection",
      CellTags->{"layout", "b:18.6", "gs:0.19"}],
    Cell[18904, 554, 98, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],
    Cell[19005, 557, 378, 7, 70, "Text",
      CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],
    Cell[19386, 566, 101, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[19490, 569, 326, 10, 70, "Text",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[19819, 581, 466, 11, 70, "Text",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[20288, 594, 106, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[20397, 597, 605, 17, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21005, 616, 211, 5, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21219, 623, 279, 7, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}]},
  "i:12"->{
    Cell[18904, 554, 98, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],
    Cell[19005, 557, 378, 7, 70, "Text",
      CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}]},
  "i:13"->{
    Cell[19386, 566, 101, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[19490, 569, 326, 10, 70, "Text",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
    Cell[19819, 581, 466, 11, 70, "Text",
      CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}]},
  "i:14"->{
    Cell[20288, 594, 106, 1, 70, "Subsubsubsection",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[20397, 597, 605, 17, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21005, 616, 211, 5, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
    Cell[21219, 623, 279, 7, 70, "Text",
      CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}]},
  "i:15"->{
    Cell[21535, 635, 129, 2, 70, "Subsubsection",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
    Cell[21667, 639, 353, 8, 70, "Text",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
    Cell[22023, 649, 236, 6, 70, "Text",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}]},
  "b:18.7"->{
    Cell[21535, 635, 129, 2, 70, "Subsubsection",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
    Cell[21667, 639, 353, 8, 70, "Text",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
    Cell[22023, 649, 236, 6, 70, "Text",
      CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}]},
  "Installation difficulties"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Conflicts during installation"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}]},
  "Preferences: rebuilding"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "init.m"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Resetting to defaults"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Defaults: resetting to"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Shift-Control"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}]},
  "Trouble with help files"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Help files: assistance with"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Graphics: problems with"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Problems: with graphics"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}]},
  "Rerendering graphics"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Graphics: rerendering"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Packages: problems with"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Problems: with packages"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Crashes"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}]},
  "Troubleshooting_Win"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[22870, 673, 966, 24, 70, "Highlight",
      CellTags->{"Troubleshooting_Win", "i:16", "gs:0.20"}],
    Cell[23861, 701, 116, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[23980, 704, 252, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[24235, 713, 363, 9, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[24635, 727, 112, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}],
    Cell[25130, 741, 356, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}],
    Cell[25523, 753, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[25623, 756, 589, 12, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[26215, 770, 514, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[27074, 794, 101, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}],
    Cell[27178, 797, 330, 8, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}],
    Cell[27545, 810, 123, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}],
    Cell[27671, 814, 475, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}],
    Cell[28183, 829, 120, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28306, 832, 263, 5, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28572, 839, 130, 1, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28705, 842, 200, 4, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28942, 851, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29043, 854, 182, 4, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29228, 860, 344, 9, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29575, 871, 299, 6, 70, "ItemizedList",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29877, 879, 313, 8, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[30227, 892, 130, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[30360, 895, 497, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[30860, 907, 558, 14, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[31455, 926, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[31555, 929, 310, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[31868, 938, 390, 9, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[32295, 952, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}],
    Cell[32396, 955, 186, 5, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}]},
  "i:16"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[22870, 673, 966, 24, 70, "Highlight",
      CellTags->{"Troubleshooting_Win", "i:16", "gs:0.20"}]},
  "gs:0.20"->{
    Cell[22308, 661, 559, 10, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Installation difficulties", "Conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Rerendering graphics", 
        "Graphics: rerendering", "Packages: problems with", 
        "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
        "gs:0.20"}],
    Cell[22870, 673, 966, 24, 70, "Highlight",
      CellTags->{"Troubleshooting_Win", "i:16", "gs:0.20"}],
    Cell[23861, 701, 116, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[23980, 704, 252, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[24235, 713, 363, 9, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[24635, 727, 112, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}],
    Cell[24750, 730, 377, 9, 70, "Text",
      CellTags->{"i:69", "b:19.1", "gs:0.20"}],
    Cell[25130, 741, 356, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}],
    Cell[25523, 753, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[25623, 756, 589, 12, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[26215, 770, 514, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[26732, 782, 305, 7, 70, "Text",
      CellTags->{"b:19.2", "gs:0.20"}],
    Cell[27074, 794, 101, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}],
    Cell[27178, 797, 330, 8, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}],
    Cell[27545, 810, 123, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}],
    Cell[27671, 814, 475, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}],
    Cell[28183, 829, 120, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28306, 832, 263, 5, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28572, 839, 130, 1, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28705, 842, 200, 4, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28942, 851, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29043, 854, 182, 4, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29228, 860, 344, 9, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29575, 871, 299, 6, 70, "ItemizedList",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29877, 879, 313, 8, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[30227, 892, 130, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[30360, 895, 497, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[30860, 907, 558, 14, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[31455, 926, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[31555, 929, 310, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[31868, 938, 390, 9, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[32295, 952, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}],
    Cell[32396, 955, 186, 5, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}]},
  "i:17"->{
    Cell[23861, 701, 116, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[23980, 704, 252, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[24235, 713, 363, 9, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}]},
  "b:19.0"->{
    Cell[23861, 701, 116, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[23980, 704, 252, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
    Cell[24235, 713, 363, 9, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}]},
  "i:69"->{
    Cell[24635, 727, 112, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}],
    Cell[24750, 730, 377, 9, 70, "Text",
      CellTags->{"i:69", "b:19.1", "gs:0.20"}],
    Cell[25130, 741, 356, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}]},
  "b:19.1"->{
    Cell[24635, 727, 112, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}],
    Cell[24750, 730, 377, 9, 70, "Text",
      CellTags->{"i:69", "b:19.1", "gs:0.20"}],
    Cell[25130, 741, 356, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}]},
  "i:18"->{
    Cell[25523, 753, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[25623, 756, 589, 12, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[26215, 770, 514, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}]},
  "b:19.2"->{
    Cell[25523, 753, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[25623, 756, 589, 12, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[26215, 770, 514, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
    Cell[26732, 782, 305, 7, 70, "Text",
      CellTags->{"b:19.2", "gs:0.20"}]},
  "i:19"->{
    Cell[27074, 794, 101, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}],
    Cell[27178, 797, 330, 8, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}]},
  "b:19.3"->{
    Cell[27074, 794, 101, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}],
    Cell[27178, 797, 330, 8, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}]},
  "i:20"->{
    Cell[27545, 810, 123, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}],
    Cell[27671, 814, 475, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}]},
  "b:19.4"->{
    Cell[27545, 810, 123, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}],
    Cell[27671, 814, 475, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}]},
  "i:21"->{
    Cell[28183, 829, 120, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28306, 832, 263, 5, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28572, 839, 130, 1, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28705, 842, 200, 4, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}]},
  "b:19.5"->{
    Cell[28183, 829, 120, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28306, 832, 263, 5, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28572, 839, 130, 1, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
    Cell[28705, 842, 200, 4, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}]},
  "i:22"->{
    Cell[28942, 851, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29043, 854, 182, 4, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29228, 860, 344, 9, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29575, 871, 299, 6, 70, "ItemizedList",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29877, 879, 313, 8, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}]},
  "b:19.6"->{
    Cell[28942, 851, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29043, 854, 182, 4, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29228, 860, 344, 9, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29575, 871, 299, 6, 70, "ItemizedList",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
    Cell[29877, 879, 313, 8, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}]},
  "i:23"->{
    Cell[30227, 892, 130, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[30360, 895, 497, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[30860, 907, 558, 14, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}]},
  "b:19.7"->{
    Cell[30227, 892, 130, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[30360, 895, 497, 10, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
    Cell[30860, 907, 558, 14, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}]},
  "i:25"->{
    Cell[31455, 926, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[31555, 929, 310, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[31868, 938, 390, 9, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}]},
  "b:19.8"->{
    Cell[31455, 926, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[31555, 929, 310, 7, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
    Cell[31868, 938, 390, 9, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}]},
  "i:26"->{
    Cell[32295, 952, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}],
    Cell[32396, 955, 186, 5, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}]},
  "b:19.9"->{
    Cell[32295, 952, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}],
    Cell[32396, 955, 186, 5, 70, "Text",
      CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}]},
  "Troubleshooting"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "Extension: conflicts during installation"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}]},
  "Control panel: conflicts during installation"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}]},
  "Shift-Option"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}]},
  "Monitors control panel"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}]},
  "MathLink: problems with"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}]},
  "Problems: with MathLink"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}]},
  "Troubleshooting_MacOSX"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[33391, 981, 969, 24, 70, "Highlight",
      CellTags->{"Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[34385, 1009, 119, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[34507, 1012, 382, 8, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[34892, 1022, 366, 9, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[35295, 1036, 131, 3, 70, "Subsubsection",
      CellTags->{
      "Troubleshooting_MacOSX", "Bundles_subsection", "i:29", "b:20.1", 
        "gs:0.21"}],
    Cell[35429, 1041, 468, 11, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}],
    Cell[35900, 1054, 629, 13, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}],
    Cell[36566, 1072, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[36692, 1075, 141, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[36836, 1078, 384, 12, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37223, 1092, 186, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37412, 1098, 126, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37541, 1101, 138, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37716, 1107, 129, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[37848, 1110, 230, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38081, 1117, 258, 8, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38342, 1127, 218, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38597, 1137, 111, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}],
    Cell[38711, 1140, 266, 6, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}],
    Cell[39014, 1151, 103, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}],
    Cell[39120, 1154, 290, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}],
    Cell[39447, 1164, 115, 1, 70, "Subsubsection",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[39565, 1167, 360, 6, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[39928, 1175, 292, 5, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[40223, 1182, 358, 7, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[40618, 1194, 100, 1, 70, "Subsubsection",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[40721, 1197, 613, 15, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[41337, 1214, 513, 10, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[41853, 1226, 339, 7, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[42229, 1238, 102, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}],
    Cell[42334, 1241, 509, 11, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}],
    Cell[42880, 1257, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43006, 1260, 266, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43275, 1267, 133, 1, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43411, 1270, 203, 4, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43651, 1279, 110, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[43764, 1282, 262, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[44029, 1289, 377, 8, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[44443, 1302, 149, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[44595, 1306, 382, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[44980, 1316, 561, 16, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[45544, 1334, 221, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[45802, 1344, 122, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[45927, 1347, 223, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46153, 1354, 549, 15, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46705, 1371, 205, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46913, 1377, 367, 9, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47283, 1388, 196, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47482, 1394, 193, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47712, 1403, 100, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}],
    Cell[47815, 1406, 554, 15, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}]},
  "i:27"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[33391, 981, 969, 24, 70, "Highlight",
      CellTags->{"Troubleshooting_MacOSX", "i:27", "gs:0.21"}]},
  "gs:0.21"->{
    Cell[32631, 966, 757, 13, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Conflicts during installation", 
        "Extension: conflicts during installation", 
        "Control panel: conflicts during installation", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Shift-Option", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Problems: with graphics", "Monitors control panel", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "MathLink: problems with", "Problems: with MathLink", 
        "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[33391, 981, 969, 24, 70, "Highlight",
      CellTags->{"Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
    Cell[34385, 1009, 119, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[34507, 1012, 382, 8, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[34892, 1022, 366, 9, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[35295, 1036, 131, 3, 70, "Subsubsection",
      CellTags->{
      "Troubleshooting_MacOSX", "Bundles_subsection", "i:29", "b:20.1", 
        "gs:0.21"}],
    Cell[35429, 1041, 468, 11, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}],
    Cell[35900, 1054, 629, 13, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}],
    Cell[36566, 1072, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[36692, 1075, 141, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[36836, 1078, 384, 12, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37223, 1092, 186, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37412, 1098, 126, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37541, 1101, 138, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37716, 1107, 129, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[37848, 1110, 230, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38081, 1117, 258, 8, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38342, 1127, 218, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38597, 1137, 111, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}],
    Cell[38711, 1140, 266, 6, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}],
    Cell[39014, 1151, 103, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}],
    Cell[39120, 1154, 290, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}],
    Cell[39447, 1164, 115, 1, 70, "Subsubsection",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[39565, 1167, 360, 6, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[39928, 1175, 292, 5, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[40223, 1182, 358, 7, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[40618, 1194, 100, 1, 70, "Subsubsection",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[40721, 1197, 613, 15, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[41337, 1214, 513, 10, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[41853, 1226, 339, 7, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[42229, 1238, 102, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}],
    Cell[42334, 1241, 509, 11, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}],
    Cell[42880, 1257, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43006, 1260, 266, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43275, 1267, 133, 1, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43411, 1270, 203, 4, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43651, 1279, 110, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[43764, 1282, 262, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[44029, 1289, 377, 8, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[44443, 1302, 149, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[44595, 1306, 382, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[44980, 1316, 561, 16, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[45544, 1334, 221, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[45802, 1344, 122, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[45927, 1347, 223, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46153, 1354, 549, 15, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46705, 1371, 205, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46913, 1377, 367, 9, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47283, 1388, 196, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47482, 1394, 193, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47712, 1403, 100, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}],
    Cell[47815, 1406, 554, 15, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}]},
  "i:28"->{
    Cell[34385, 1009, 119, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[34507, 1012, 382, 8, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[34892, 1022, 366, 9, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}]},
  "b:20.0"->{
    Cell[34385, 1009, 119, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[34507, 1012, 382, 8, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
    Cell[34892, 1022, 366, 9, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}]},
  "Bundles_subsection"->{
    Cell[35295, 1036, 131, 3, 70, "Subsubsection",
      CellTags->{
      "Troubleshooting_MacOSX", "Bundles_subsection", "i:29", "b:20.1", 
        "gs:0.21"}]},
  "i:29"->{
    Cell[35295, 1036, 131, 3, 70, "Subsubsection",
      CellTags->{
      "Troubleshooting_MacOSX", "Bundles_subsection", "i:29", "b:20.1", 
        "gs:0.21"}],
    Cell[35429, 1041, 468, 11, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}],
    Cell[35900, 1054, 629, 13, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}]},
  "b:20.1"->{
    Cell[35295, 1036, 131, 3, 70, "Subsubsection",
      CellTags->{
      "Troubleshooting_MacOSX", "Bundles_subsection", "i:29", "b:20.1", 
        "gs:0.21"}],
    Cell[35429, 1041, 468, 11, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}],
    Cell[35900, 1054, 629, 13, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}]},
  "i:31"->{
    Cell[36566, 1072, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[36692, 1075, 141, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[36836, 1078, 384, 12, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37223, 1092, 186, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37412, 1098, 126, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37541, 1101, 138, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}]},
  "b:20.2"->{
    Cell[36566, 1072, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[36692, 1075, 141, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[36836, 1078, 384, 12, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37223, 1092, 186, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37412, 1098, 126, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
    Cell[37541, 1101, 138, 1, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}]},
  "i:32"->{
    Cell[37716, 1107, 129, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[37848, 1110, 230, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38081, 1117, 258, 8, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38342, 1127, 218, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}]},
  "b:20.3"->{
    Cell[37716, 1107, 129, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[37848, 1110, 230, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38081, 1117, 258, 8, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
    Cell[38342, 1127, 218, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}]},
  "i:33"->{
    Cell[38597, 1137, 111, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}],
    Cell[38711, 1140, 266, 6, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}]},
  "b:20.4"->{
    Cell[38597, 1137, 111, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}],
    Cell[38711, 1140, 266, 6, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}]},
  "i:34"->{
    Cell[39014, 1151, 103, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}],
    Cell[39120, 1154, 290, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}]},
  "b:20.5"->{
    Cell[39014, 1151, 103, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}],
    Cell[39120, 1154, 290, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}]},
  "i:65"->{
    Cell[39447, 1164, 115, 1, 70, "Subsubsection",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[39565, 1167, 360, 6, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[39928, 1175, 292, 5, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[40223, 1182, 358, 7, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}]},
  "b:20.6"->{
    Cell[39447, 1164, 115, 1, 70, "Subsubsection",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[39565, 1167, 360, 6, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[39928, 1175, 292, 5, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
    Cell[40223, 1182, 358, 7, 70, "Text",
      CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}]},
  "i:66"->{
    Cell[40618, 1194, 100, 1, 70, "Subsubsection",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[40721, 1197, 613, 15, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[41337, 1214, 513, 10, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[41853, 1226, 339, 7, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}]},
  "b:20.7"->{
    Cell[40618, 1194, 100, 1, 70, "Subsubsection",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[40721, 1197, 613, 15, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[41337, 1214, 513, 10, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
    Cell[41853, 1226, 339, 7, 70, "Text",
      CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}]},
  "i:37"->{
    Cell[42229, 1238, 102, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}],
    Cell[42334, 1241, 509, 11, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}]},
  "b:20.8"->{
    Cell[42229, 1238, 102, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}],
    Cell[42334, 1241, 509, 11, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}]},
  "i:38"->{
    Cell[42880, 1257, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43006, 1260, 266, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43275, 1267, 133, 1, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43411, 1270, 203, 4, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}]},
  "b:20.9"->{
    Cell[42880, 1257, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43006, 1260, 266, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43275, 1267, 133, 1, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
    Cell[43411, 1270, 203, 4, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}]},
  "i:40"->{
    Cell[43651, 1279, 110, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[43764, 1282, 262, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[44029, 1289, 377, 8, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}]},
  "b:20.11"->{
    Cell[43651, 1279, 110, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[43764, 1282, 262, 5, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
    Cell[44029, 1289, 377, 8, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}]},
  "i:41"->{
    Cell[44443, 1302, 149, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[44595, 1306, 382, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[44980, 1316, 561, 16, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[45544, 1334, 221, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}]},
  "b:20.12"->{
    Cell[44443, 1302, 149, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[44595, 1306, 382, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[44980, 1316, 561, 16, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
    Cell[45544, 1334, 221, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}]},
  "i:42"->{
    Cell[45802, 1344, 122, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[45927, 1347, 223, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46153, 1354, 549, 15, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46705, 1371, 205, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46913, 1377, 367, 9, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47283, 1388, 196, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47482, 1394, 193, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}]},
  "b:20.13"->{
    Cell[45802, 1344, 122, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[45927, 1347, 223, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46153, 1354, 549, 15, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46705, 1371, 205, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[46913, 1377, 367, 9, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47283, 1388, 196, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
    Cell[47482, 1394, 193, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}]},
  "i:44"->{
    Cell[47712, 1403, 100, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}],
    Cell[47815, 1406, 554, 15, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}]},
  "b:20.14"->{
    Cell[47712, 1403, 100, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}],
    Cell[47815, 1406, 554, 15, 70, "Text",
      CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}]},
  "Troubleshooting_Unix"->{
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}],
    Cell[48905, 1437, 967, 24, 70, "Highlight",
      CellTags->{"Troubleshooting_Unix", "i:45", "gs:0.22"}],
    Cell[49897, 1465, 117, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}],
    Cell[50017, 1468, 459, 11, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}],
    Cell[50513, 1484, 94, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}],
    Cell[50610, 1487, 323, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}],
    Cell[50970, 1500, 113, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51086, 1503, 264, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51353, 1510, 282, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51638, 1517, 197, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51838, 1523, 132, 1, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51973, 1526, 158, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[52168, 1535, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[52269, 1538, 342, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[52614, 1548, 534, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[53151, 1563, 337, 7, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[53525, 1575, 124, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[53652, 1579, 479, 10, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[54134, 1591, 245, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[54416, 1601, 121, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54540, 1604, 265, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54808, 1611, 131, 1, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54942, 1614, 201, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[55180, 1623, 99, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55282, 1626, 188, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55473, 1632, 170, 2, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55646, 1636, 182, 7, 70, "ListNote",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55831, 1645, 179, 5, 70, "ItemizedList",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[56013, 1652, 185, 7, 70, "ListNote",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[56235, 1664, 109, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[56347, 1667, 478, 15, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[56828, 1684, 295, 10, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[57160, 1699, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}],
    Cell[57260, 1702, 541, 18, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}],
    Cell[57838, 1725, 106, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[57947, 1728, 402, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[58352, 1743, 503, 12, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[58892, 1760, 108, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[59003, 1763, 542, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[59548, 1778, 611, 15, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60162, 1795, 330, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60495, 1805, 359, 8, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60891, 1818, 175, 4, 70, "Subsubsection",
      PageBreakAbove->Automatic,
      CellTags->{
      "Troubleshooting_Unix", "FEResources_subsection", "i:55", "b:21.11", 
        "gs:0.22"}],
    Cell[61069, 1824, 362, 6, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61434, 1832, 155, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61592, 1838, 188, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61783, 1844, 218, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62004, 1851, 429, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62436, 1860, 254, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62693, 1867, 185, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62881, 1873, 218, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63102, 1881, 218, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63323, 1889, 249, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63575, 1896, 331, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63909, 1906, 587, 14, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[64499, 1922, 645, 19, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65147, 1943, 186, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65336, 1949, 264, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65603, 1959, 248, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65854, 1967, 733, 19, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[66590, 1988, 455, 17, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[67048, 2007, 265, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[67350, 2020, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[67476, 2023, 403, 11, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[67882, 2036, 329, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68214, 2044, 216, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68433, 2051, 441, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68877, 2063, 219, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69099, 2070, 386, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69488, 2080, 402, 9, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69893, 2091, 192, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70088, 2097, 319, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70410, 2106, 535, 15, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70948, 2123, 206, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[71157, 2129, 245, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[71405, 2137, 791, 22, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72199, 2161, 261, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72463, 2168, 233, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72699, 2175, 789, 20, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[73491, 2197, 690, 14, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74184, 2213, 203, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74390, 2219, 420, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74813, 2229, 408, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75224, 2238, 404, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75631, 2247, 230, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75864, 2254, 402, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76269, 2266, 345, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76617, 2278, 229, 5, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76849, 2285, 316, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[77168, 2293, 514, 12, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[77685, 2307, 306, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[78028, 2319, 120, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78151, 2322, 221, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78375, 2329, 245, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78623, 2338, 203, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78829, 2344, 346, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[79178, 2354, 194, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[79375, 2360, 188, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}]},
  "i:45"->{
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}],
    Cell[48905, 1437, 967, 24, 70, "Highlight",
      CellTags->{"Troubleshooting_Unix", "i:45", "gs:0.22"}]},
  "gs:0.22"->{
    Cell[48418, 1427, 484, 8, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Troubleshooting", "Installation difficulties", 
        "Preferences: rebuilding", "init.m", "Resetting to defaults", 
        "Defaults: resetting to", "Trouble with help files", 
        "Help files: assistance with", "Graphics: problems with", 
        "Rerendering graphics", "Graphics: rerendering", 
        "Packages: problems with", "Problems: with packages", 
        "Troubleshooting_Unix", "i:45", "gs:0.22"}],
    Cell[48905, 1437, 967, 24, 70, "Highlight",
      CellTags->{"Troubleshooting_Unix", "i:45", "gs:0.22"}],
    Cell[49897, 1465, 117, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}],
    Cell[50017, 1468, 459, 11, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}],
    Cell[50513, 1484, 94, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}],
    Cell[50610, 1487, 323, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}],
    Cell[50970, 1500, 113, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51086, 1503, 264, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51353, 1510, 282, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51638, 1517, 197, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51838, 1523, 132, 1, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51973, 1526, 158, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[52168, 1535, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[52269, 1538, 342, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[52614, 1548, 534, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[53151, 1563, 337, 7, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[53525, 1575, 124, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[53652, 1579, 479, 10, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[54134, 1591, 245, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[54416, 1601, 121, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54540, 1604, 265, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54808, 1611, 131, 1, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54942, 1614, 201, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[55180, 1623, 99, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55282, 1626, 188, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55473, 1632, 170, 2, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55646, 1636, 182, 7, 70, "ListNote",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55831, 1645, 179, 5, 70, "ItemizedList",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[56013, 1652, 185, 7, 70, "ListNote",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[56235, 1664, 109, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[56347, 1667, 478, 15, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[56828, 1684, 295, 10, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[57160, 1699, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}],
    Cell[57260, 1702, 541, 18, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}],
    Cell[57838, 1725, 106, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[57947, 1728, 402, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[58352, 1743, 503, 12, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[58892, 1760, 108, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[59003, 1763, 542, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[59548, 1778, 611, 15, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60162, 1795, 330, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60495, 1805, 359, 8, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60891, 1818, 175, 4, 70, "Subsubsection",
      PageBreakAbove->Automatic,
      CellTags->{
      "Troubleshooting_Unix", "FEResources_subsection", "i:55", "b:21.11", 
        "gs:0.22"}],
    Cell[61069, 1824, 362, 6, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61434, 1832, 155, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61592, 1838, 188, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61783, 1844, 218, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62004, 1851, 429, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62436, 1860, 254, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62693, 1867, 185, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62881, 1873, 218, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63102, 1881, 218, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63323, 1889, 249, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63575, 1896, 331, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63909, 1906, 587, 14, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[64499, 1922, 645, 19, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65147, 1943, 186, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65336, 1949, 264, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65603, 1959, 248, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65854, 1967, 733, 19, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[66590, 1988, 455, 17, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[67048, 2007, 265, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[67350, 2020, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[67476, 2023, 403, 11, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[67882, 2036, 329, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68214, 2044, 216, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68433, 2051, 441, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68877, 2063, 219, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69099, 2070, 386, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69488, 2080, 402, 9, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69893, 2091, 192, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70088, 2097, 319, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70410, 2106, 535, 15, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70948, 2123, 206, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[71157, 2129, 245, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[71405, 2137, 791, 22, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72199, 2161, 261, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72463, 2168, 233, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72699, 2175, 789, 20, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[73491, 2197, 690, 14, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74184, 2213, 203, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74390, 2219, 420, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74813, 2229, 408, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75224, 2238, 404, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75631, 2247, 230, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75864, 2254, 402, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76269, 2266, 345, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76617, 2278, 229, 5, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76849, 2285, 316, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[77168, 2293, 514, 12, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[77685, 2307, 306, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[78028, 2319, 120, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78151, 2322, 221, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78375, 2329, 245, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78623, 2338, 203, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78829, 2344, 346, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[79178, 2354, 194, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[79375, 2360, 188, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}]},
  "i:46"->{
    Cell[49897, 1465, 117, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}],
    Cell[50017, 1468, 459, 11, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}]},
  "b:21.0"->{
    Cell[49897, 1465, 117, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}],
    Cell[50017, 1468, 459, 11, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}]},
  "b:21.1"->{
    Cell[50513, 1484, 94, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}],
    Cell[50610, 1487, 323, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}]},
  "i:67"->{
    Cell[50970, 1500, 113, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51086, 1503, 264, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51353, 1510, 282, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51638, 1517, 197, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51838, 1523, 132, 1, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51973, 1526, 158, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}]},
  "b:21.2"->{
    Cell[50970, 1500, 113, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51086, 1503, 264, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51353, 1510, 282, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51638, 1517, 197, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51838, 1523, 132, 1, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
    Cell[51973, 1526, 158, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}]},
  "i:68"->{
    Cell[52168, 1535, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[52269, 1538, 342, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[52614, 1548, 534, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[53151, 1563, 337, 7, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}]},
  "b:21.3"->{
    Cell[52168, 1535, 98, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[52269, 1538, 342, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[52614, 1548, 534, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
    Cell[53151, 1563, 337, 7, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}]},
  "i:48"->{
    Cell[53525, 1575, 124, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[53652, 1579, 479, 10, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[54134, 1591, 245, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}]},
  "b:21.4"->{
    Cell[53525, 1575, 124, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[53652, 1579, 479, 10, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
    Cell[54134, 1591, 245, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}]},
  "i:49"->{
    Cell[54416, 1601, 121, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54540, 1604, 265, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54808, 1611, 131, 1, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54942, 1614, 201, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}]},
  "b:21.5"->{
    Cell[54416, 1601, 121, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54540, 1604, 265, 5, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54808, 1611, 131, 1, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
    Cell[54942, 1614, 201, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}]},
  "i:50"->{
    Cell[55180, 1623, 99, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55282, 1626, 188, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55473, 1632, 170, 2, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55646, 1636, 182, 7, 70, "ListNote",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55831, 1645, 179, 5, 70, "ItemizedList",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[56013, 1652, 185, 7, 70, "ListNote",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}]},
  "b:21.6"->{
    Cell[55180, 1623, 99, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55282, 1626, 188, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55473, 1632, 170, 2, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55646, 1636, 182, 7, 70, "ListNote",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[55831, 1645, 179, 5, 70, "ItemizedList",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
    Cell[56013, 1652, 185, 7, 70, "ListNote",
      CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}]},
  "i:51"->{
    Cell[56235, 1664, 109, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[56347, 1667, 478, 15, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[56828, 1684, 295, 10, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}]},
  "b:21.7"->{
    Cell[56235, 1664, 109, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[56347, 1667, 478, 15, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
    Cell[56828, 1684, 295, 10, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}]},
  "i:52"->{
    Cell[57160, 1699, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}],
    Cell[57260, 1702, 541, 18, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}]},
  "b:21.8"->{
    Cell[57160, 1699, 97, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}],
    Cell[57260, 1702, 541, 18, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}]},
  "i:53"->{
    Cell[57838, 1725, 106, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[57947, 1728, 402, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[58352, 1743, 503, 12, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}]},
  "b:21.9"->{
    Cell[57838, 1725, 106, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[57947, 1728, 402, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
    Cell[58352, 1743, 503, 12, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}]},
  "i:54"->{
    Cell[58892, 1760, 108, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[59003, 1763, 542, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[59548, 1778, 611, 15, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60162, 1795, 330, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60495, 1805, 359, 8, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}]},
  "b:21.10"->{
    Cell[58892, 1760, 108, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[59003, 1763, 542, 13, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[59548, 1778, 611, 15, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60162, 1795, 330, 8, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
    Cell[60495, 1805, 359, 8, 70, "Text",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}]},
  "FEResources_subsection"->{
    Cell[60891, 1818, 175, 4, 70, "Subsubsection",
      PageBreakAbove->Automatic,
      CellTags->{
      "Troubleshooting_Unix", "FEResources_subsection", "i:55", "b:21.11", 
        "gs:0.22"}]},
  "i:55"->{
    Cell[60891, 1818, 175, 4, 70, "Subsubsection",
      PageBreakAbove->Automatic,
      CellTags->{
      "Troubleshooting_Unix", "FEResources_subsection", "i:55", "b:21.11", 
        "gs:0.22"}],
    Cell[61069, 1824, 362, 6, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61434, 1832, 155, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61592, 1838, 188, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61783, 1844, 218, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62004, 1851, 429, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62436, 1860, 254, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62693, 1867, 185, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62881, 1873, 218, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63102, 1881, 218, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63323, 1889, 249, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63575, 1896, 331, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63909, 1906, 587, 14, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[64499, 1922, 645, 19, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65147, 1943, 186, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65336, 1949, 264, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65603, 1959, 248, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65854, 1967, 733, 19, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[66590, 1988, 455, 17, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[67048, 2007, 265, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}]},
  "b:21.11"->{
    Cell[60891, 1818, 175, 4, 70, "Subsubsection",
      PageBreakAbove->Automatic,
      CellTags->{
      "Troubleshooting_Unix", "FEResources_subsection", "i:55", "b:21.11", 
        "gs:0.22"}],
    Cell[61069, 1824, 362, 6, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61434, 1832, 155, 4, 70, "Text",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61592, 1838, 188, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[61783, 1844, 218, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62004, 1851, 429, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62436, 1860, 254, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62693, 1867, 185, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[62881, 1873, 218, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63102, 1881, 218, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63323, 1889, 249, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63575, 1896, 331, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[63909, 1906, 587, 14, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[64499, 1922, 645, 19, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65147, 1943, 186, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65336, 1949, 264, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65603, 1959, 248, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[65854, 1967, 733, 19, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[66590, 1988, 455, 17, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
    Cell[67048, 2007, 265, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}]},
  "i:56"->{
    Cell[67350, 2020, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[67476, 2023, 403, 11, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[67882, 2036, 329, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68214, 2044, 216, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68433, 2051, 441, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68877, 2063, 219, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69099, 2070, 386, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69488, 2080, 402, 9, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69893, 2091, 192, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70088, 2097, 319, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70410, 2106, 535, 15, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70948, 2123, 206, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[71157, 2129, 245, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[71405, 2137, 791, 22, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72199, 2161, 261, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72463, 2168, 233, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72699, 2175, 789, 20, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[73491, 2197, 690, 14, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74184, 2213, 203, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74390, 2219, 420, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74813, 2229, 408, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75224, 2238, 404, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75631, 2247, 230, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75864, 2254, 402, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76269, 2266, 345, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76617, 2278, 229, 5, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76849, 2285, 316, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[77168, 2293, 514, 12, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[77685, 2307, 306, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}]},
  "b:21.12"->{
    Cell[67350, 2020, 123, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[67476, 2023, 403, 11, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[67882, 2036, 329, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68214, 2044, 216, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68433, 2051, 441, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[68877, 2063, 219, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69099, 2070, 386, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69488, 2080, 402, 9, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[69893, 2091, 192, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70088, 2097, 319, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70410, 2106, 535, 15, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[70948, 2123, 206, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[71157, 2129, 245, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[71405, 2137, 791, 22, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72199, 2161, 261, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72463, 2168, 233, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[72699, 2175, 789, 20, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[73491, 2197, 690, 14, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74184, 2213, 203, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74390, 2219, 420, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[74813, 2229, 408, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75224, 2238, 404, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75631, 2247, 230, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[75864, 2254, 402, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76269, 2266, 345, 10, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76617, 2278, 229, 5, 70, "BulletedList",
      PageBreakAbove->True,
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[76849, 2285, 316, 6, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[77168, 2293, 514, 12, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
    Cell[77685, 2307, 306, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}]},
  "i:57"->{
    Cell[78028, 2319, 120, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78151, 2322, 221, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78375, 2329, 245, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78623, 2338, 203, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78829, 2344, 346, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[79178, 2354, 194, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[79375, 2360, 188, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}]},
  "b:21.13"->{
    Cell[78028, 2319, 120, 1, 70, "Subsubsection",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78151, 2322, 221, 5, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78375, 2329, 245, 7, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78623, 2338, 203, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[78829, 2344, 346, 8, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[79178, 2354, 194, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
    Cell[79375, 2360, 188, 4, 70, "BulletedList",
      CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}]},
  "Updating over Version 2"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}]},
  "Installing over Version 2"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}]},
  "Previous versions: installing over"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}]},
  "Notebook format: from Version 2"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}]},
  "Converting notebooks: to Version 3"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}]},
  "Kernels: from earlier versions"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}]},
  "NotebookConvert"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}]},
  "Converting notebooks: via kernel"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}]},
  "updating"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}],
    Cell[80043, 2381, 92, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}],
    Cell[80138, 2384, 331, 6, 70, "Text",
      CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}],
    Cell[80506, 2395, 95, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}],
    Cell[80604, 2398, 166, 4, 70, "Text",
      CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}],
    Cell[80807, 2407, 125, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[80935, 2410, 866, 24, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[81804, 2436, 199, 4, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82006, 2442, 179, 6, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82188, 2450, 186, 6, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82377, 2458, 266, 5, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82680, 2468, 126, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[82809, 2472, 474, 10, 70, "Text",
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[83286, 2484, 425, 8, 70, "Text",
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[83748, 2497, 95, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[83846, 2500, 360, 8, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[84231, 2512, 2386, 36, 70, "OpenCloseItemizedPicture",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[86620, 2550, 161677, 2000, 70, 161508, 1995, "GraphicsData", 
    "Bitmap", "ItemizedPicture",
      Evaluatable->False,
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[248312, 4553, 496, 12, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[248811, 4567, 604, 11, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[249418, 4580, 553, 18, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[249974, 4600, 656, 17, 70, "UserTips",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}]},
  "i:58"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}]},
  "gs:0.23"->{
    Cell[79612, 2370, 406, 7, 36, "Subsection",
      PageBreakAbove->True,
      CellTags->{
      "Updating over Version 2", "Installing over Version 2", 
        "Previous versions: installing over", 
        "Notebook format: from Version 2", 
        "Converting notebooks: to Version 3", 
        "Kernels: from earlier versions", "NotebookConvert", 
        "Converting notebooks: via kernel", "updating", "i:58", "gs:0.23"}],
    Cell[80043, 2381, 92, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}],
    Cell[80138, 2384, 331, 6, 70, "Text",
      CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}],
    Cell[80506, 2395, 95, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}],
    Cell[80604, 2398, 166, 4, 70, "Text",
      CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}],
    Cell[80807, 2407, 125, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[80935, 2410, 866, 24, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[81804, 2436, 199, 4, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82006, 2442, 179, 6, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82188, 2450, 186, 6, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82377, 2458, 266, 5, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82680, 2468, 126, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[82809, 2472, 474, 10, 70, "Text",
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[83286, 2484, 425, 8, 70, "Text",
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[83748, 2497, 95, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[83846, 2500, 360, 8, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[84231, 2512, 2386, 36, 70, "OpenCloseItemizedPicture",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[86620, 2550, 161677, 2000, 70, 161508, 1995, "GraphicsData", 
    "Bitmap", "ItemizedPicture",
      Evaluatable->False,
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[248312, 4553, 496, 12, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[248811, 4567, 604, 11, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[249418, 4580, 553, 18, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[249974, 4600, 656, 17, 70, "UserTips",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}]},
  "i:59"->{
    Cell[80043, 2381, 92, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}],
    Cell[80138, 2384, 331, 6, 70, "Text",
      CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}]},
  "b:22.0"->{
    Cell[80043, 2381, 92, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}],
    Cell[80138, 2384, 331, 6, 70, "Text",
      CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}]},
  "i:61"->{
    Cell[80506, 2395, 95, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}],
    Cell[80604, 2398, 166, 4, 70, "Text",
      CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}]},
  "b:22.2"->{
    Cell[80506, 2395, 95, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}],
    Cell[80604, 2398, 166, 4, 70, "Text",
      CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}]},
  "i:62"->{
    Cell[80807, 2407, 125, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[80935, 2410, 866, 24, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[81804, 2436, 199, 4, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82006, 2442, 179, 6, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82188, 2450, 186, 6, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82377, 2458, 266, 5, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}]},
  "b:22.3"->{
    Cell[80807, 2407, 125, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[80935, 2410, 866, 24, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[81804, 2436, 199, 4, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82006, 2442, 179, 6, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82188, 2450, 186, 6, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
    Cell[82377, 2458, 266, 5, 70, "Text",
      CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}]},
  "i:63"->{
    Cell[82680, 2468, 126, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[82809, 2472, 474, 10, 70, "Text",
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[83286, 2484, 425, 8, 70, "Text",
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}]},
  "b:22.4"->{
    Cell[82680, 2468, 126, 2, 70, "Subsubsection",
      PageBreakAbove->True,
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[82809, 2472, 474, 10, 70, "Text",
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
    Cell[83286, 2484, 425, 8, 70, "Text",
      CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}]},
  "i:64"->{
    Cell[83748, 2497, 95, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[83846, 2500, 360, 8, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[84231, 2512, 2386, 36, 70, "OpenCloseItemizedPicture",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[86620, 2550, 161677, 2000, 70, 161508, 1995, "GraphicsData", 
    "Bitmap", "ItemizedPicture",
      Evaluatable->False,
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[248312, 4553, 496, 12, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[248811, 4567, 604, 11, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[249418, 4580, 553, 18, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[249974, 4600, 656, 17, 70, "UserTips",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}]},
  "b:22.5"->{
    Cell[83748, 2497, 95, 1, 70, "Subsubsection",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[83846, 2500, 360, 8, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[84231, 2512, 2386, 36, 70, "OpenCloseItemizedPicture",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[86620, 2550, 161677, 2000, 70, 161508, 1995, "GraphicsData", 
    "Bitmap", "ItemizedPicture",
      Evaluatable->False,
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[248312, 4553, 496, 12, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[248811, 4567, 604, 11, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[249418, 4580, 553, 18, 70, "Text",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
    Cell[249974, 4600, 656, 17, 70, "UserTips",
      CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Versions on CD-ROM", 264947, 4852},
  {"CD-ROM: versions available on", 266395, 4876},
  {"Additional versions", 267833, 4900},
  {"Front end only versions", 269275, 4924},
  {"High school versions", 270714, 4948},
  {"Student versions", 272149, 4972},
  {"MathLink Developer's Kits", 273593, 4996},
  {"Developer kits: MathLink", 275036, 5020},
  {"Installation details", 276475, 5044},
  {"Installation: types of", 277916, 5068},
  {"Types of installation", 279356, 5092},
  {"Sizes of installations", 280797, 5116},
  {"Minimal installation", 282236, 5140},
  {"Front end only: installing", 283681, 5164},
  {"Installation: front end only", 285128, 5188},
  {"Kernel only: installing", 286570, 5212},
  {"Installation: kernel only", 288014, 5236},
  {"Documentation: installing", 289458, 5260},
  {"Standard add-on packages: installing", 290913, 5284},
  {"Custom installation directions", 292362, 5308},
  {"Initialization files", 293801, 5332},
  {"Startup files", 295233, 5356},
  {"Memory requirements", 296671, 5380},
  {"Removing all files", 298108, 5404},
  {"Uninstalling Mathematica", 299551, 5428},
  {"init.m: for front end", 300991, 5452},
  {"ConfigurationPath", 302427, 5476},
  {"PreferencesPath", 303861, 5500},
  {"Preferences: front end", 305302, 5524},
  {"Preferences: kernel", 306740, 5548},
  {"Resources: front end", 308179, 5572},
  {"Resources: kernel", 309615, 5596},
  {"init.m: for kernel", 311052, 5620},
  {"Site administration", 312490, 5644},
  {"Configuration folder", 313929, 5668},
  {"Fonts", 315353, 5692},
  {"Documentation configuration", 316799, 5716},
  {"BrowserIndex", 318230, 5740},
  {"Location of packages", 319669, 5764},
  {"Standard add-on packages: location", 321122, 5788},
  {"Packages: location of", 322562, 5812},
  {"Application packages: location", 324011, 5836},
  {"Autoload packages: location", 325457, 5860},
  {"Loading packages automatically", 326906, 5884},
  {"layout", 328331, 5908},
  {"gs:0.19", 335127, 6039},
  {"i:1", 341919, 6170},
  {"b:18.0", 342839, 6189},
  {"i:2", 343756, 6208},
  {"b:18.1", 344197, 6218},
  {"i:4", 344635, 6228},
  {"b:18.2", 344952, 6235},
  {"Configuration_subsection", 345287, 6242},
  {"i:6", 345441, 6246},
  {"b:18.3", 345696, 6252},
  {"i:7", 346732, 6273},
  {"i:8", 347319, 6285},
  {"i:9", 347540, 6290},
  {"b:18.4", 347984, 6300},
  {"i:10", 348426, 6310},
  {"b:18.5", 349307, 6328},
  {"b:18.6", 350188, 6346},
  {"i:12", 351229, 6367},
  {"i:13", 351451, 6372},
  {"i:14", 351775, 6379},
  {"i:15", 352197, 6388},
  {"b:18.7", 352518, 6395},
  {"Installation difficulties", 352858, 6402},
  {"Conflicts during installation", 354837, 6439},
  {"Preferences: rebuilding", 356287, 6466},
  {"init.m", 358243, 6503},
  {"Resetting to defaults", 360214, 6540},
  {"Defaults: resetting to", 362186, 6577},
  {"Shift-Control", 364149, 6614},
  {"Trouble with help files", 364781, 6626},
  {"Help files: assistance with", 366758, 6663},
  {"Graphics: problems with", 368731, 6700},
  {"Problems: with graphics", 370704, 6737},
  {"Rerendering graphics", 372151, 6764},
  {"Graphics: rerendering", 374122, 6801},
  {"Packages: problems with", 376095, 6838},
  {"Problems: with packages", 378068, 6875},
  {"Crashes", 380025, 6912},
  {"Troubleshooting_Win", 380653, 6924},
  {"i:16", 384806, 6998},
  {"gs:0.20", 385530, 7012},
  {"i:17", 389853, 7090},
  {"b:19.0", 390213, 7097},
  {"i:69", 390571, 7104},
  {"b:19.1", 390908, 7111},
  {"i:18", 391243, 7118},
  {"b:19.2", 391604, 7125},
  {"i:19", 392044, 7134},
  {"b:19.3", 392292, 7139},
  {"i:20", 392538, 7144},
  {"b:19.4", 392815, 7150},
  {"i:21", 393090, 7156},
  {"b:19.5", 393562, 7165},
  {"i:22", 394032, 7174},
  {"b:19.6", 394680, 7186},
  {"i:23", 395326, 7198},
  {"b:19.7", 395688, 7205},
  {"i:25", 396048, 7212},
  {"b:19.8", 396407, 7219},
  {"i:26", 396764, 7226},
  {"b:19.9", 397011, 7231},
  {"Troubleshooting", 397267, 7236},
  {"Extension: conflicts during installation", 398657, 7262},
  {"Control panel: conflicts during installation", 399528, 7278},
  {"Shift-Option", 400367, 7294},
  {"Monitors control panel", 401216, 7310},
  {"MathLink: problems with", 402066, 7326},
  {"Problems: with MathLink", 402916, 7342},
  {"Troubleshooting_MacOSX", 403765, 7358},
  {"i:27", 410888, 7480},
  {"gs:0.21", 411833, 7498},
  {"i:28", 418956, 7620},
  {"b:20.0", 419328, 7627},
  {"Bundles_subsection", 419712, 7634},
  {"i:29", 419888, 7639},
  {"b:20.1", 420300, 7648},
  {"i:31", 420710, 7657},
  {"b:20.2", 421471, 7670},
  {"i:32", 422230, 7683},
  {"b:20.3", 422770, 7693},
  {"i:33", 423308, 7703},
  {"b:20.4", 423564, 7708},
  {"i:34", 423818, 7713},
  {"b:20.5", 424074, 7718},
  {"i:65", 424328, 7723},
  {"b:20.6", 424816, 7732},
  {"i:66", 425302, 7741},
  {"b:20.7", 425792, 7750},
  {"i:37", 426280, 7759},
  {"b:20.8", 426537, 7764},
  {"i:38", 426792, 7769},
  {"b:20.9", 427280, 7778},
  {"i:40", 427766, 7787},
  {"b:20.11", 428142, 7794},
  {"i:41", 428515, 7801},
  {"b:20.12", 429061, 7811},
  {"i:42", 429604, 7821},
  {"b:20.13", 430497, 7836},
  {"i:44", 431387, 7851},
  {"b:20.14", 431647, 7856},
  {"Troubleshooting_Unix", 431920, 7861},
  {"i:45", 444396, 8075},
  {"gs:0.22", 445045, 8088},
  {"i:46", 457521, 8302},
  {"b:21.0", 457774, 8307},
  {"b:21.1", 458027, 8312},
  {"i:67", 458260, 8317},
  {"b:21.2", 458968, 8330},
  {"i:68", 459674, 8343},
  {"b:21.3", 460154, 8352},
  {"i:48", 460632, 8361},
  {"b:21.4", 461027, 8369},
  {"i:49", 461420, 8377},
  {"b:21.5", 461900, 8386},
  {"i:50", 462378, 8395},
  {"b:21.6", 463158, 8409},
  {"i:51", 463936, 8423},
  {"b:21.7", 464304, 8430},
  {"i:52", 464670, 8437},
  {"b:21.8", 464922, 8442},
  {"i:53", 465172, 8447},
  {"b:21.9", 465540, 8454},
  {"i:54", 465906, 8461},
  {"b:21.10", 466536, 8473},
  {"FEResources_subsection", 467181, 8485},
  {"i:55", 467393, 8491},
  {"b:21.11", 469961, 8536},
  {"i:56", 472526, 8581},
  {"b:21.12", 476175, 8642},
  {"i:57", 479821, 8703},
  {"b:21.13", 480699, 8718},
  {"Updating over Version 2", 481593, 8733},
  {"Installing over Version 2", 482061, 8743},
  {"Previous versions: installing over", 482538, 8753},
  {"Notebook format: from Version 2", 483012, 8763},
  {"Converting notebooks: to Version 3", 483489, 8773},
  {"Kernels: from earlier versions", 483962, 8783},
  {"NotebookConvert", 484420, 8793},
  {"Converting notebooks: via kernel", 484895, 8803},
  {"updating", 485346, 8813},
  {"i:58", 488129, 8868},
  {"gs:0.23", 488579, 8878},
  {"i:59", 491362, 8933},
  {"b:22.0", 491589, 8938},
  {"i:61", 491814, 8943},
  {"b:22.2", 492041, 8948},
  {"i:62", 492266, 8953},
  {"b:22.3", 492903, 8966},
  {"i:63", 493538, 8979},
  {"b:22.4", 493897, 8987},
  {"i:64", 494254, 8995},
  {"b:22.5", 495215, 9014}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 1297, 20, 36, "Subsection",
  CellTags->{
  "Versions on CD-ROM", "CD-ROM: versions available on", 
    "Additional versions", "Front end only versions", "High school versions", 
    "Student versions", "MathLink Developer's Kits", 
    "Developer kits: MathLink", "Installation details", 
    "Installation: types of", "Types of installation", 
    "Sizes of installations", "Minimal installation", 
    "Front end only: installing", "Installation: front end only", 
    "Kernel only: installing", "Installation: kernel only", 
    "Documentation: installing", "Standard add-on packages: installing", 
    "Custom installation directions", "Initialization files", "Startup files",
     "Memory requirements", "Removing all files", "Uninstalling Mathematica", 
    "init.m: for front end", "ConfigurationPath", "PreferencesPath", 
    "Preferences: front end", "Preferences: kernel", "Resources: front end", 
    "Resources: kernel", "init.m: for kernel", "Site administration", 
    "Configuration folder", "Fonts", "Documentation configuration", 
    "BrowserIndex", "Location of packages", 
    "Standard add-on packages: location", "Packages: location of", 
    "Application packages: location", "Autoload packages: location", 
    "Loading packages automatically", "layout", "gs:0.19"}],
Cell[3076, 75, 277, 9, 70, "Highlight",
  CellTags->{"layout", "gs:0.19"}],

Cell[CellGroupData[{
Cell[3378, 88, 111, 1, 70, "Subsubsection",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
Cell[3492, 91, 330, 6, 70, "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
Cell[3825, 99, 509, 12, 70, "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
Cell[4337, 113, 2040, 56, 70, "2ColumnBox",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
Cell[6380, 171, 348, 9, 70, "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
Cell[6731, 182, 1984, 54, 70, "2ColumnBox",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
Cell[8718, 238, 354, 9, 70, "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}],
Cell[9075, 249, 281, 7, 70, "Text",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{
Cell[9393, 261, 86, 1, 70, "Subsubsection",
  CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
Cell[9482, 264, 477, 10, 70, "Text",
  CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
Cell[9962, 276, 360, 9, 70, "Text",
  PageBreakAbove->True,
  CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
Cell[10325, 287, 262, 5, 70, "Text",
  CellTags->{"layout", "i:2", "b:18.1", "gs:0.19"}],
Cell[10590, 294, 1914, 49, 70, "2ColumnBox",
  CellTags->{"layout", "i:1", "b:18.0", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{
Cell[12541, 348, 83, 1, 70, "Subsubsection",
  CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
Cell[12627, 351, 297, 8, 70, "Text",
  CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}],
Cell[12927, 361, 335, 8, 70, "Text",
  CellTags->{"layout", "i:4", "b:18.2", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{
Cell[13299, 374, 127, 2, 70, "Subsubsection",
  CellTags->{
  "layout", "Configuration_subsection", "i:6", "b:18.3", "gs:0.19"}],
Cell[13429, 378, 373, 9, 70, "Text",
  CellTags->{"layout", "i:6", "b:18.3", "gs:0.19"}],
Cell[13805, 389, 129, 1, 70, "Subsubsubsection",
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
Cell[13937, 392, 337, 7, 70, "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
Cell[14277, 401, 156, 6, 70, "ItemizedList",
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
Cell[14436, 409, 250, 7, 70, "ItemizedList",
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
Cell[14689, 418, 249, 6, 70, "Text",
  CellTags->{"layout", "i:7", "b:18.3", "gs:0.19"}],
Cell[14941, 426, 126, 1, 70, "Subsubsubsection",
  CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}],
Cell[15070, 429, 850, 25, 70, "Text",
  CellTags->{"layout", "i:8", "b:18.3", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{
Cell[15957, 459, 82, 1, 70, "Subsubsection",
  CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
Cell[16042, 462, 651, 14, 70, "Text",
  CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
Cell[16696, 478, 222, 5, 70, "Text",
  PageBreakAbove->True,
  CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}],
Cell[16921, 485, 218, 5, 70, "Text",
  CellTags->{"layout", "i:9", "b:18.4", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{
Cell[17176, 495, 120, 2, 70, "Subsubsection",
  PageBreakAbove->Automatic,
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
Cell[17299, 499, 387, 8, 70, "Text",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
Cell[17689, 509, 155, 4, 70, "Text",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
Cell[17847, 515, 143, 4, 70, "BulletedList",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
Cell[17993, 521, 139, 4, 70, "BulletedList",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
Cell[18135, 527, 147, 4, 70, "BulletedList",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
Cell[18285, 533, 143, 4, 70, "BulletedList",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}],
Cell[18431, 539, 334, 7, 70, "Text",
  CellTags->{"layout", "i:10", "b:18.5", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{
Cell[18802, 551, 99, 1, 70, "Subsubsection",
  CellTags->{"layout", "b:18.6", "gs:0.19"}],
Cell[18904, 554, 98, 1, 70, "Subsubsubsection",
  CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],
Cell[19005, 557, 378, 7, 70, "Text",
  CellTags->{"layout", "i:12", "b:18.6", "gs:0.19"}],
Cell[19386, 566, 101, 1, 70, "Subsubsubsection",
  CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
Cell[19490, 569, 326, 10, 70, "Text",
  CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
Cell[19819, 581, 466, 11, 70, "Text",
  CellTags->{"layout", "i:13", "b:18.6", "gs:0.19"}],
Cell[20288, 594, 106, 1, 70, "Subsubsubsection",
  CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
Cell[20397, 597, 605, 17, 70, "Text",
  CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
Cell[21005, 616, 211, 5, 70, "Text",
  CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}],
Cell[21219, 623, 279, 7, 70, "Text",
  CellTags->{"layout", "i:14", "b:18.6", "gs:0.19"}]
}, Closed]],

Cell[CellGroupData[{
Cell[21535, 635, 129, 2, 70, "Subsubsection",
  CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
Cell[21667, 639, 353, 8, 70, "Text",
  CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}],
Cell[22023, 649, 236, 6, 70, "Text",
  CellTags->{"layout", "i:15", "b:18.7", "gs:0.19"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[22308, 661, 559, 10, 36, "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Installation difficulties", "Conflicts during installation", 
    "Preferences: rebuilding", "init.m", "Resetting to defaults", 
    "Defaults: resetting to", "Shift-Control", "Trouble with help files", 
    "Help files: assistance with", "Graphics: problems with", 
    "Problems: with graphics", "Rerendering graphics", 
    "Graphics: rerendering", "Packages: problems with", 
    "Problems: with packages", "Crashes", "Troubleshooting_Win", "i:16", 
    "gs:0.20"}],
Cell[22870, 673, 966, 24, 70, "Highlight",
  CellTags->{"Troubleshooting_Win", "i:16", "gs:0.20"}],

Cell[CellGroupData[{
Cell[23861, 701, 116, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
Cell[23980, 704, 252, 7, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}],
Cell[24235, 713, 363, 9, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:17", "b:19.0", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{
Cell[24635, 727, 112, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}],
Cell[24750, 730, 377, 9, 70, "Text",
  CellTags->{"i:69", "b:19.1", "gs:0.20"}],
Cell[25130, 741, 356, 7, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:69", "b:19.1", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{
Cell[25523, 753, 97, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
Cell[25623, 756, 589, 12, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
Cell[26215, 770, 514, 10, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:18", "b:19.2", "gs:0.20"}],
Cell[26732, 782, 305, 7, 70, "Text",
  CellTags->{"b:19.2", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{
Cell[27074, 794, 101, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}],
Cell[27178, 797, 330, 8, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:19", "b:19.3", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{
Cell[27545, 810, 123, 2, 70, "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}],
Cell[27671, 814, 475, 10, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:20", "b:19.4", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{
Cell[28183, 829, 120, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
Cell[28306, 832, 263, 5, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
Cell[28572, 839, 130, 1, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}],
Cell[28705, 842, 200, 4, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:21", "b:19.5", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{
Cell[28942, 851, 98, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
Cell[29043, 854, 182, 4, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
Cell[29228, 860, 344, 9, 70, "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
Cell[29575, 871, 299, 6, 70, "ItemizedList",
  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}],
Cell[29877, 879, 313, 8, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:22", "b:19.6", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{
Cell[30227, 892, 130, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
Cell[30360, 895, 497, 10, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}],
Cell[30860, 907, 558, 14, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:23", "b:19.7", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{
Cell[31455, 926, 97, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
Cell[31555, 929, 310, 7, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}],
Cell[31868, 938, 390, 9, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:25", "b:19.8", "gs:0.20"}]
}, Closed]],

Cell[CellGroupData[{
Cell[32295, 952, 98, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}],
Cell[32396, 955, 186, 5, 70, "Text",
  CellTags->{"Troubleshooting_Win", "i:26", "b:19.9", "gs:0.20"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[32631, 966, 757, 13, 36, "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Troubleshooting", "Installation difficulties", 
    "Conflicts during installation", 
    "Extension: conflicts during installation", 
    "Control panel: conflicts during installation", "Preferences: rebuilding",
     "init.m", "Resetting to defaults", "Defaults: resetting to", 
    "Shift-Option", "Trouble with help files", "Help files: assistance with", 
    "Graphics: problems with", "Problems: with graphics", 
    "Monitors control panel", "Rerendering graphics", "Graphics: rerendering",
     "Packages: problems with", "Problems: with packages", 
    "MathLink: problems with", "Problems: with MathLink", 
    "Troubleshooting_MacOSX", "i:27", "gs:0.21"}],
Cell[33391, 981, 969, 24, 70, "Highlight",
  CellTags->{"Troubleshooting_MacOSX", "i:27", "gs:0.21"}],

Cell[CellGroupData[{
Cell[34385, 1009, 119, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
Cell[34507, 1012, 382, 8, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}],
Cell[34892, 1022, 366, 9, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:28", "b:20.0", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[35295, 1036, 131, 3, 70, "Subsubsection",
  CellTags->{
  "Troubleshooting_MacOSX", "Bundles_subsection", "i:29", "b:20.1", 
    "gs:0.21"}],
Cell[35429, 1041, 468, 11, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}],
Cell[35900, 1054, 629, 13, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:29", "b:20.1", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[36566, 1072, 123, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
Cell[36692, 1075, 141, 1, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
Cell[36836, 1078, 384, 12, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
Cell[37223, 1092, 186, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
Cell[37412, 1098, 126, 1, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}],
Cell[37541, 1101, 138, 1, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:31", "b:20.2", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[37716, 1107, 129, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
Cell[37848, 1110, 230, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
Cell[38081, 1117, 258, 8, 70, "BulletedList",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}],
Cell[38342, 1127, 218, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:32", "b:20.3", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[38597, 1137, 111, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}],
Cell[38711, 1140, 266, 6, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:33", "b:20.4", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[39014, 1151, 103, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}],
Cell[39120, 1154, 290, 5, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:34", "b:20.5", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[39447, 1164, 115, 1, 70, "Subsubsection",
  CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
Cell[39565, 1167, 360, 6, 70, "Text",
  CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
Cell[39928, 1175, 292, 5, 70, "Text",
  CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}],
Cell[40223, 1182, 358, 7, 70, "Text",
  CellTags->{"i:65", "Troubleshooting_MacOSX", "b:20.6", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[40618, 1194, 100, 1, 70, "Subsubsection",
  CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
Cell[40721, 1197, 613, 15, 70, "Text",
  CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
Cell[41337, 1214, 513, 10, 70, "Text",
  CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}],
Cell[41853, 1226, 339, 7, 70, "Text",
  CellTags->{"i:66", "Troubleshooting_MacOSX", "b:20.7", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[42229, 1238, 102, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}],
Cell[42334, 1241, 509, 11, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:37", "b:20.8", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[42880, 1257, 123, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
Cell[43006, 1260, 266, 5, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
Cell[43275, 1267, 133, 1, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}],
Cell[43411, 1270, 203, 4, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:38", "b:20.9", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[43651, 1279, 110, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
Cell[43764, 1282, 262, 5, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}],
Cell[44029, 1289, 377, 8, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:40", "b:20.11", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[44443, 1302, 149, 2, 70, "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
Cell[44595, 1306, 382, 8, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
Cell[44980, 1316, 561, 16, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}],
Cell[45544, 1334, 221, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:41", "b:20.12", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[45802, 1344, 122, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
Cell[45927, 1347, 223, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
Cell[46153, 1354, 549, 15, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
Cell[46705, 1371, 205, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
Cell[46913, 1377, 367, 9, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
Cell[47283, 1388, 196, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}],
Cell[47482, 1394, 193, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_MacOSX", "i:42", "b:20.13", "gs:0.21"}]
}, Closed]],

Cell[CellGroupData[{
Cell[47712, 1403, 100, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}],
Cell[47815, 1406, 554, 15, 70, "Text",
  CellTags->{"Troubleshooting_MacOSX", "i:44", "b:20.14", "gs:0.21"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[48418, 1427, 484, 8, 36, "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Troubleshooting", "Installation difficulties", "Preferences: rebuilding", 
    "init.m", "Resetting to defaults", "Defaults: resetting to", 
    "Trouble with help files", "Help files: assistance with", 
    "Graphics: problems with", "Rerendering graphics", 
    "Graphics: rerendering", "Packages: problems with", 
    "Problems: with packages", "Troubleshooting_Unix", "i:45", "gs:0.22"}],
Cell[48905, 1437, 967, 24, 70, "Highlight",
  CellTags->{"Troubleshooting_Unix", "i:45", "gs:0.22"}],

Cell[CellGroupData[{
Cell[49897, 1465, 117, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}],
Cell[50017, 1468, 459, 11, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:46", "b:21.0", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[50513, 1484, 94, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}],
Cell[50610, 1487, 323, 8, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "b:21.1", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[50970, 1500, 113, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
Cell[51086, 1503, 264, 5, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
Cell[51353, 1510, 282, 5, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
Cell[51638, 1517, 197, 4, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
Cell[51838, 1523, 132, 1, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}],
Cell[51973, 1526, 158, 4, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:67", "b:21.2", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[52168, 1535, 98, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
Cell[52269, 1538, 342, 8, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
Cell[52614, 1548, 534, 13, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}],
Cell[53151, 1563, 337, 7, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:68", "b:21.3", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[53525, 1575, 124, 2, 70, "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
Cell[53652, 1579, 479, 10, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}],
Cell[54134, 1591, 245, 5, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:48", "b:21.4", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[54416, 1601, 121, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
Cell[54540, 1604, 265, 5, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
Cell[54808, 1611, 131, 1, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}],
Cell[54942, 1614, 201, 4, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:49", "b:21.5", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[55180, 1623, 99, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
Cell[55282, 1626, 188, 4, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
Cell[55473, 1632, 170, 2, 70, "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
Cell[55646, 1636, 182, 7, 70, "ListNote",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
Cell[55831, 1645, 179, 5, 70, "ItemizedList",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}],
Cell[56013, 1652, 185, 7, 70, "ListNote",
  CellTags->{"Troubleshooting_Unix", "i:50", "b:21.6", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[56235, 1664, 109, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
Cell[56347, 1667, 478, 15, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}],
Cell[56828, 1684, 295, 10, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:51", "b:21.7", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[57160, 1699, 97, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}],
Cell[57260, 1702, 541, 18, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:52", "b:21.8", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[57838, 1725, 106, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
Cell[57947, 1728, 402, 13, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}],
Cell[58352, 1743, 503, 12, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:53", "b:21.9", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[58892, 1760, 108, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
Cell[59003, 1763, 542, 13, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
Cell[59548, 1778, 611, 15, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
Cell[60162, 1795, 330, 8, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}],
Cell[60495, 1805, 359, 8, 70, "Text",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:54", "b:21.10", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[60891, 1818, 175, 4, 70, "Subsubsection",
  PageBreakAbove->Automatic,
  CellTags->{
  "Troubleshooting_Unix", "FEResources_subsection", "i:55", "b:21.11", 
    "gs:0.22"}],
Cell[61069, 1824, 362, 6, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[61434, 1832, 155, 4, 70, "Text",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[61592, 1838, 188, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[61783, 1844, 218, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[62004, 1851, 429, 7, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[62436, 1860, 254, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[62693, 1867, 185, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[62881, 1873, 218, 6, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[63102, 1881, 218, 6, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[63323, 1889, 249, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[63575, 1896, 331, 8, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[63909, 1906, 587, 14, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[64499, 1922, 645, 19, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[65147, 1943, 186, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[65336, 1949, 264, 8, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[65603, 1959, 248, 6, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[65854, 1967, 733, 19, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[66590, 1988, 455, 17, 70, "BulletedList",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}],
Cell[67048, 2007, 265, 8, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:55", "b:21.11", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[67350, 2020, 123, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[67476, 2023, 403, 11, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[67882, 2036, 329, 6, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[68214, 2044, 216, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[68433, 2051, 441, 10, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[68877, 2063, 219, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[69099, 2070, 386, 8, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[69488, 2080, 402, 9, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[69893, 2091, 192, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[70088, 2097, 319, 7, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[70410, 2106, 535, 15, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[70948, 2123, 206, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[71157, 2129, 245, 6, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[71405, 2137, 791, 22, 70, "BulletedList",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[72199, 2161, 261, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[72463, 2168, 233, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[72699, 2175, 789, 20, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[73491, 2197, 690, 14, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[74184, 2213, 203, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[74390, 2219, 420, 8, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[74813, 2229, 408, 7, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[75224, 2238, 404, 7, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[75631, 2247, 230, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[75864, 2254, 402, 10, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[76269, 2266, 345, 10, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[76617, 2278, 229, 5, 70, "BulletedList",
  PageBreakAbove->True,
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[76849, 2285, 316, 6, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[77168, 2293, 514, 12, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}],
Cell[77685, 2307, 306, 7, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:56", "b:21.12", "gs:0.22"}]
}, Closed]],

Cell[CellGroupData[{
Cell[78028, 2319, 120, 1, 70, "Subsubsection",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
Cell[78151, 2322, 221, 5, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
Cell[78375, 2329, 245, 7, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
Cell[78623, 2338, 203, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
Cell[78829, 2344, 346, 8, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
Cell[79178, 2354, 194, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}],
Cell[79375, 2360, 188, 4, 70, "BulletedList",
  CellTags->{"Troubleshooting_Unix", "i:57", "b:21.13", "gs:0.22"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[79612, 2370, 406, 7, 36, "Subsection",
  PageBreakAbove->True,
  CellTags->{
  "Updating over Version 2", "Installing over Version 2", 
    "Previous versions: installing over", "Notebook format: from Version 2", 
    "Converting notebooks: to Version 3", "Kernels: from earlier versions", 
    "NotebookConvert", "Converting notebooks: via kernel", "updating", "i:58",
     "gs:0.23"}],

Cell[CellGroupData[{
Cell[80043, 2381, 92, 1, 70, "Subsubsection",
  CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}],
Cell[80138, 2384, 331, 6, 70, "Text",
  CellTags->{"updating", "i:59", "b:22.0", "gs:0.23"}]
}, Closed]],

Cell[CellGroupData[{
Cell[80506, 2395, 95, 1, 70, "Subsubsection",
  CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}],
Cell[80604, 2398, 166, 4, 70, "Text",
  CellTags->{"updating", "i:61", "b:22.2", "gs:0.23"}]
}, Closed]],

Cell[CellGroupData[{
Cell[80807, 2407, 125, 1, 70, "Subsubsection",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
Cell[80935, 2410, 866, 24, 70, "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
Cell[81804, 2436, 199, 4, 70, "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
Cell[82006, 2442, 179, 6, 70, "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
Cell[82188, 2450, 186, 6, 70, "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}],
Cell[82377, 2458, 266, 5, 70, "Text",
  CellTags->{"updating", "i:62", "b:22.3", "gs:0.23"}]
}, Closed]],

Cell[CellGroupData[{
Cell[82680, 2468, 126, 2, 70, "Subsubsection",
  PageBreakAbove->True,
  CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
Cell[82809, 2472, 474, 10, 70, "Text",
  CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}],
Cell[83286, 2484, 425, 8, 70, "Text",
  CellTags->{"updating", "i:63", "b:22.4", "gs:0.23"}]
}, Closed]],

Cell[CellGroupData[{
Cell[83748, 2497, 95, 1, 70, "Subsubsection",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
Cell[83846, 2500, 360, 8, 70, "Text",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],

Cell[CellGroupData[{
Cell[84231, 2512, 2386, 36, 70, "OpenCloseItemizedPicture",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
Cell[86620, 2550, 161677, 2000, 70, 161508, 1995, "GraphicsData", "Bitmap", \
"ItemizedPicture",
  Evaluatable->False,
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}]
}, Closed]],
Cell[248312, 4553, 496, 12, 70, "Text",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
Cell[248811, 4567, 604, 11, 70, "Text",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
Cell[249418, 4580, 553, 18, 70, "Text",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}],
Cell[249974, 4600, 656, 17, 70, "UserTips",
  CellTags->{"updating", "i:64", "b:22.5", "gs:0.23"}]
}, Closed]]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

