(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     75424,       2096]*)
(*NotebookOutlinePosition[    116357,       3162]*)
(*  CellTagsIndexPosition[    113990,       3067]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "6. ",
  StyleBox["Mathematica", "SO"],
  " Administration on Unix and Linux"
}], "Chapter",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 2.0}, {Inherited, Inherited}}, CellFrameMargins -> {{0.0, 50.0}, {8.0, 0.0}}, ParagraphIndent -> -30.0, FontSize -> 27.0, Background -> GrayLevel[ 0.9999847409781033]}}],

Cell[TextData[{
  "This chapter contains information and techniques useful for Unix and Linux system administrators managing larger ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " environments. Alternate installation methods designed to save time and resources are explained here. This chapter also includes information about configuring initialization files, setting systemwide defaults, and troubleshooting on Unix and Linux."
}], "Text"],

Cell[CellGroupData[{

Cell["6.1 Alternate Installation Methods", "Section",
  CellTags->{"c:1", "b:6.0.4"}],

Cell[TextData[{
  "Basic ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installation instructions are included in Section 3.3, Installing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " Client on Unix and Linux. For large sites, however, it is often impractical and time-consuming to install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from a CD on each machine on the network. This section contains alternate methods for installing and running ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on Unix and Linux."
}], "Text",
  CellTags->"b:6.0.4"],

Cell[TextData[{
  "With Unix and Linux, you are not limited to a single-platform environment. A single ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installation directory can support multiple Unix and Linux platforms. Use the ",
  StyleBox["MathInstaller", "MR"],
  " option ",
  StyleBox["-platforms", "MR"],
  " to choose which platforms to install. Note that the installer for any platform can be run on any other platform. Section 6.1.3, ",
  ButtonBox["Installer Command-Line Options and Automatic Installation",
    ButtonData:>{"Automatic Installation"},
    ButtonStyle->"GettingStartedLink"],
  ", contains further information."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 0.0}, {Inherited, Inherited}}}},
  CellTags->{"i:1", "b:6.0.4"}],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.1 Installing ",
  StyleBox["Mathematica", "SBO"],
  " from a File Server"
}], "Subsection",
  CellTags->{"c:2", "i:2", "b:6.0.0"}],

Cell[TextData[{
  "One convenient way to install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on a client is to run the installer remotely from a file server. This is an efficient way of making ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " available to a large number of users without having to supply a CD to each one. You can install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from a file server on a client running any supported Unix or Linux platform. It is not necessary that the client platform be the same as the file server platform."
}], "Text",
  CellTags->"b:6.0.0"],

Cell[TextData[{
  "To install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from a file server, you first must make the installer and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " files available to the clients. You can do this by copying the contents of the CD to the file server and exporting the directory, or by exporting the CD mount point on the file server. Then, mount the directory with the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution on the client, change to this directory, and run ",
  StyleBox["MathInstaller", "MR"],
  " to install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on the client machines. (Note that you must run ",
  StyleBox["MathInstaller", "MR"],
  " from the directory in which it is located.) If you are installing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in a mixed-platform environment, you may need to use the ",
  StyleBox["MathInstaller", "MR"],
  " option  ",
  StyleBox["-platform", "MR"],
  " ",
  StyleBox["platformname", "TI"],
  " to ensure that the correct files for your platform are installed."
}], "Text",
  CellTags->{"i:45", "b:6.0.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.2 Running ",
  StyleBox["Mathematica", "SBO"],
  " from a File Server"
}], "Subsection",
  CellTags->{"c:3", "i:3", "b:6.0.1"}],

Cell[TextData[{
  "Rather than installing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on every client machine, you can install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on a file server and export the installation directory to the clients. To display the front end, the clients must have access to the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts. For information about configuring the X server on the client machines to find the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts, see Section 6.6, ",
  ButtonBox["Fonts",
    ButtonData:>{"Fonts"},
    ButtonStyle->"GettingStartedLink"],
  ". Once the fonts are properly configured, the client machines can run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as though it were a local installation."
}], "Text",
  CellTags->"b:6.0.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
6.1.3 Installer Command-Line Options and Automatic Installation\
\>", "Subsection",
  CellTags->{"c:4", "i:6", "b:6.0.2"}],

Cell[TextData[{
  "If you are installing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on multiple machines, it can be time-consuming to respond to all of the installer prompts on each individual machine. By supplying command-line options to the ",
  StyleBox["MathInstaller", "MR"],
  " command, you can customize various features of the installation process or automate it entirely. "
}], "Text",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  "The ",
  StyleBox["MathInstaller", "MR"],
  " command supports the following command-line options. "
}], "Text",
  CellTags->{"i:5", "b:6.0.2"}],

Cell[TextData[StyleBox["-auto", "MR"]], "IndentedText",
  CellTags->"b:6.0.2"],

Cell["\<\
Causes the installation to proceed automatically without prompting the user for any information. Default values are used for any options that are not specified explicitly on the command line. \
\>", "ItemizedTextNote",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  StyleBox["-createddir=", "MR"],
  StyleBox["value", "TI"]
}], "IndentedText",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  "Specifies whether any directories required for the installation should be created if they do not exist. The allowed values are ",
  StyleBox["y", "MR"],
  " or ",
  StyleBox["n", "MR"],
  ", with ",
  StyleBox["y", "MR"],
  " as the default value. This option only works with an automatic installation (that is, when one of the options ",
  StyleBox["-auto", "MR"],
  " or ",
  StyleBox["-silent", "MR"],
  " is also specified)."
}], "ItemizedTextNote",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  StyleBox["-execdir=", "MR"],
  StyleBox["dir", "TI"]
}], "IndentedText",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  "Specifies the path to be used for the symbolic links to the executable scripts. The default is ",
  StyleBox["/usr/local/bin", "MR"],
  ". This option only works with an automatic installation."
}], "ItemizedTextNote",
  CellTags->"b:6.0.2"],

Cell[TextData[StyleBox["-help", "MR"]], "IndentedText",
  CellTags->"b:6.0.2"],

Cell["Displays information about the installer options.", "ItemizedTextNote",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  StyleBox["-method=", "MR"],
  StyleBox["value", "TI"]
}], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {PageBreakAbove -> True}},
  CellTags->"b:6.0.2"],

Cell[TextData[{
  "Specifies the type of installation to be performed. The allowed values are ",
  StyleBox["Full", "MR"],
  " and ",
  StyleBox["Minimal", "MR"],
  ", with ",
  StyleBox["Full", "MR"],
  " as the default value. This option only works with an automatic installation."
}], "ItemizedTextNote",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  StyleBox["-overwrite=", "MR"],
  StyleBox["value", "TI"]
}], "IndentedText",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  "Specifies whether the installer should overwrite any files that already exist in the target directory. The allowed values are ",
  StyleBox["y", "MR"],
  " or ",
  StyleBox["n", "MR"],
  ", with ",
  StyleBox["y", "MR"],
  " as the default value. This option only works with an automatic installation."
}], "ItemizedTextNote",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  StyleBox["-platforms=", "MR"],
  StyleBox["value", "TI"]
}], "IndentedText",
  CellTags->{"i:40", "b:6.0.2"}],

Cell["\<\
Specifies the system ID of the Unix platform or platforms (e.g., Linux, Solaris, and so forth) for which you want to do the installation. The default value is the system you are installing on, if that information is available to the installer. This option only works with an automatic installation.\
\>", "ItemizedTextNote",
  CellTags->"b:6.0.2"],

Cell[TextData[StyleBox["-silent", "MR"]], "IndentedText",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  "Forces an automatic installation (equivalent to using the ",
  StyleBox["-auto", "MR"],
  " option) and suppresses any output from being displayed on the screen. The output is instead written to a file named ",
  StyleBox["InstallerLog-", "MR"],
  StyleBox["number", "TI"],
  ". If the installation is unsuccessful, the log file is saved in the ",
  StyleBox["/tmp", "MR"],
  " directory. Otherwise, the file is moved to the target directory and renamed ",
  StyleBox["InstallerLog", "MR"],
  "."
}], "ItemizedTextNote",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 14.0}, {Inherited, Inherited}}}},
  CellTags->"b:6.0.2"],

Cell[TextData[{
  StyleBox["-targetdir=", "MR"],
  StyleBox["dir", "TI"]
}], "IndentedText",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  "Specifies the directory where the installed files will be copied. This corresponds to the value of the global variable ",
  StyleBox["$InstallationDirectory", "MR"],
  ". The default value is ",
  StyleBox["/usr/local/Wolfram/Mathematica/5.2", "MR"],
  ". This option only works with an automatic installation."
}], "ItemizedTextNote",
  CellTags->"b:6.0.2"],

Cell[TextData[StyleBox["-verbose", "MR"]], "IndentedText",
  CellTags->"b:6.0.2"],

Cell["\<\
Displays detailed information about the files and directories being installed. \
\>", "ItemizedTextNote",
  CellTags->"b:6.0.2"],

Cell["\<\
To complete the installation in one step, run a command like the following.\
\>", "Text",
  CellTags->"b:6.0.2"],

Cell[TextData[StyleBox["./MathInstaller -auto -targetdir=/home/mathematica", "MR"]], "Text",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  "This allows you to complete the installation automatically in one step, while still being able to customize various details such as the directory to install to. You are not prompted to enter your password using this method, so you will need to enter a password the first time ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is launched."
}], "Text",
  CellTags->"b:6.0.2"],

Cell[TextData[{
  "If you are doing many installations, you might find it convenient to include the ",
  StyleBox["MathInstaller", "MR"],
  " command with all the relevant options in a shell script. Running the shell script is then an easy way to do an identical customized installation on multiple machines. You can further simplify the installation process by including a line in your script that copies an existing ",
  StyleBox["mathpass", "MR"],
  " file to the appropriate location on the newly installed machine. Note that ",
  StyleBox["MathInstaller", "MR"],
  " must be run from the directory in which it is located, so your script may require a command to change directory. "
}], "Text",
  CellTags->"b:6.0.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.1.4 Installing a Single-Machine Copy of ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->{"c:5", "i:7", "b:6.0.3"}],

Cell[TextData[{
  "While it is typically most convenient for larger sites to run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with a network license, you may need to install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with a single-machine license under certain circumstances. Follow these instructions to install a standalone copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that does not get a license from the license server. Depending on your license type, this may require contacting Wolfram Research to purchase additional licenses."
}], "Text",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  "To install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on Unix and Linux, you may need ",
  StyleBox["root", "MR"],
  " privileges. "
}], "Text",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  "To install a single-machine copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on Unix and Linux:"
}], "Subsubsubsection",
  TaggingRules:>{"PrintOptions" -> {}},
  CellTags->"b:6.0.3"],

Cell[TextData[{
  "Mount the CD. For information on mounting a CD, see ",
  ButtonBox["Mounting a CD on Unix and Linux",
    ButtonData:>{"Mounting a CD on Unix and Linux"},
    ButtonStyle->"GettingStartedLink"],
  " in the Appendix."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CounterAssignments -> {{"ItemizedList", 0}}}},
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.0.3"],

Cell[TextData[{
  StyleBox["Note: ", "TB"],
  "This step may not be required on some Linux and Unix platforms, as some operating systems automatically handle mounting."
}], "ListNote",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  "Change directory to ",
  StyleBox["/", "MR"],
  StyleBox["cdrom", "TI"],
  StyleBox["/Unix/Installer", "MR"],
  ". Note that the exact location of the CD mount point might be different for your platform."
}], "ItemizedList",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  StyleBox["cd /", "MR"],
  StyleBox["cdrom", "MO"],
  StyleBox["/Unix/Installer", "MR"]
}], "ListNote",
  CellTags->"b:6.0.3"],

Cell["Run the installer.", "ItemizedList",
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["./MathInstaller", "MR"]], "ListNote",
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["-----------------------------------------------------------------\n                  Mathematica 5.2 Installer\n-----------------------------------------------------------------\n\nCopyright (c) 2005 Wolfram Research, Inc. All rights reserved.\n\nWARNING: Mathematica 5.2 is protected by copyright law and international\ntreaties. Unauthorized reproduction or distribution may result in severe civil\nand criminal penalties, and will be prosecuted to the maximum extent possible\nunder law.", "MR10"]], "ListNoteBox",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  "You are asked to select the platform for which you are doing the installation. Select one of the available options and press ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  " to continue. "
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}, PageBreakAbove -> True}},
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["For which of the following platforms would you like to install \nMathematica?", "MR10"]], "ListNoteBox",
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["Type your selection (multiple choices can be separated with spaces), or press\nENTER to select (1):", "MR10"]], "ListNoteBox",
  CellTags->"b:6.0.3"],

Cell["\<\
You can do either a full or a minimal installation. Select one of the two options and press \[EnterKey] to continue.\
\>", "ItemizedList",
  CellTags->"b:3.1"],

Cell[TextData[StyleBox["The following installation methods are available:\n\n  (1) Full\n  (2) Minimal\n  \nType your selection, or press ENTER to select (1):", "MR10"]], "ListNoteBox",
  CellTags->"b:3.1"],

Cell[TextData[{
  "The installer prompts you to specify the directory in which ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should be installed. The default location is ",
  StyleBox["/usr/local/Wolfram/Mathematica/5.2", "MR"],
  ". Press ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  " to accept the default, or type in a new location and then press ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  "."
}], "ItemizedList",
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["Enter the installation directory, or press ENTER to select\n/usr/local/Wolfram/Mathematica/5.2:", "MR10"]], "ListNoteBox",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  StyleBox["Note:", "TB"],
  " If you specify a directory that does not exist, the installer will give you the option of creating the directory. If a copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " already exists in the directory you specify, the installer will inform you before overwriting the files. "
}], "ListNote",
  CellTags->"b:6.0.3"],

Cell["\<\
Once you have answered all the questions, the installer begins copying files from the CD to the directory you specified. The progress is indicated by a progress bar on the screen. \
\>", "ItemizedList",
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["Now installing...\n\n[***************                                                    ]", "MR10"]], "ListNoteBox",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  "You are asked for the location in which to copy the executable scripts. You should choose a directory that is present on each user\[CloseCurlyQuote]s PATH. The scripts are also installed in the ",
  StyleBox["Executables", "MR"],
  " subdirectory of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installation directory. Type a location or accept the default and press ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  "."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 10.0}, {Inherited, 6.0}}, PageBreakAbove -> True}},
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["Type the directory path in which the Mathematica scripts will be created,\nor press ENTER to select /usr/local/bin:", "MR10"]], "ListNoteBox",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  StyleBox["Note:", "TB"],
  " The installer checks to see if any other ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " scripts exist in the specified directory. If they do, you are given the chance to rename the scripts. "
}], "ListNote",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  "You are given several options for configuring the password. Type ",
  StyleBox["1", "MR"],
  " and press ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  " to run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using a single-machine license."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 12.0}, {Inherited, Inherited}}}},
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["Please choose how you want to configure the password for Mathematica 5.2.\n\n(1) Single machine\n    Install a password specific to this machine. Mathematica will launch\n    and you can enter your password.\n\n(2) Network license\n    Obtain a license from a MathLM License Server on your network each time\n    Mathematica is launched.\n\n(3) Enter license information later\n    Input your password and register when you start Mathematica.\n\nType your selection, or press ENTER to select (1):1", "MR10"]], "ListNoteBox",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  "Your machine name and MathID number are displayed. To obtain your password, contact Wolfram Research (see ",
  ButtonBox["Registration and Passwords",
    ButtonData:>{"Registration and Passwords"},
    ButtonStyle->"GettingStartedLink"],
  " in the Introduction for details). You will need to supply your MathID number and the license ID number printed on your license certificate."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 2.0}, {Inherited, Inherited}}}},
  CellTags->"b:6.0.3"],

Cell[TextData[{
  StyleBox["Configuring Single-Machine Password...\n\nMathematica 5.2 for Linux\nCopyright 1988-2005 Wolfram Research, Inc.\n\nYou will need to get a password from your\nlicense certificate or from Wolfram Research\n(register.wolfram.com).\nMachine name: ", "MR10"],
  StyleBox["hostname", "MO10"],
  StyleBox["\nMathID:\txxxx-xxxxx-xxxxx\n\nYou will need a valid license ID and password in order\nto proceed. Go to register.wolfram.com or\nconsult your Getting Started documentation.", "MR10"]
}], "ListNoteBox",
  CellTags->"b:6.0.3"],

Cell["\<\
Enter your name, the name of your organization, your license ID number (printed on your license certificate), and your password, and press \[EnterKey] when you are done.\
\>", "ItemizedList",
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["Enter your name:\n\nEnter the name of your organization:\n\nEnter your license ID [format Lxxxx-xxxx]:\n\nEnter your password:", "MR10"]], "ListNoteBox",
  CellTags->"b:6.0.3"],

Cell[TextData[{
  "The installer creates the ",
  StyleBox["mathpass", "MR"],
  " file and displays its location. The installation is now complete. "
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {}},
  CellTags->"b:6.0.3"],

Cell[TextData[StyleBox["Creating password file entry in\n/usr/share/Mathematica/Licensing/mathpass.\n\nSee your Getting Started documentation if you need to\nset up a sitewide password file.", "MR10"]], "ListNoteBox",
  CellTags->"b:6.0.3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["6.2 Testing the Installation", "Section",
  CellTags->{"c:6", "i:10", "b:6.1.2"}],

Cell[TextData[{
  "The following simple commands allow you to test the installation of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Running these commands does not guarantee that the installation was successful, but a failed command can indicate that a serious problem occurred during installation. "
}], "Text",
  CellTags->"b:6.1.2"],

Cell[TextData[{
  "Before running these commands, make sure that ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " is already installed and running on a license server on the network. You should run these tests as a regular user and not as ",
  StyleBox["root", "MR"],
  "."
}], "Text",
  CellTags->"b:6.1.2"],

Cell[CellGroupData[{

Cell[TextData[{
  "6.2.1 Testing the ",
  StyleBox["Mathematica", "SBO"],
  " Kernel"
}], "Subsection",
  CellTags->{"c:7", "i:9", "b:6.1.0"}],

Cell[TextData[{
  "To start the kernel, type ",
  StyleBox["math", "MR"],
  " in a shell and press \[EnterKey]."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CounterAssignments -> {{"ItemizedList", 0}}}},
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.1.0"],

Cell[TextData[StyleBox["In[1]:=", "MR10"]], "ListNoteBox",
  CellTags->"b:6.1.0"],

Cell[TextData[{
  "Type ",
  StyleBox["N[Pi, 20]", "MR"],
  " and press ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  ". The number in the output should match the output shown here."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}, PageBreakAbove -> True}},
  CellTags->"b:6.1.0"],

Cell[TextData[StyleBox["In[1]:= N[Pi, 20]\n\nOut[1]= 3.1415926535897932385\n\nIn[2]:=", "MR10"]], "ListNoteBox",
  CellTags->"b:6.1.0"],

Cell[TextData[{
  "To exit the kernel, type ",
  StyleBox["Exit", "MR"],
  " and press ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  "."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {}},
  CellTags->"b:6.1.0"],

Cell[TextData[{
  "On Unix and Linux, you can test the kernel on a remote machine by using the command ",
  StyleBox["ssh ", "MR"],
  StyleBox["hostname", "TI"],
  StyleBox[" /usr/local/bin/math", "MR"],
  ". (The exact pathname could be different depending on how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " was installed.) This command will launch the kernel on the remote machine ",
  StyleBox["hostname", "TI"],
  ". When you see the ",
  StyleBox["In[1]", "MR"],
  " label, follow step 2 and step 3 in the previous instructions."
}], "Text",
  CellTags->{"i:11", "b:6.1.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.2.2 Testing the ",
  StyleBox["Mathematica", "SBO"],
  " Front End"
}], "Subsection",
  CellTags->{"c:8", "i:8", "b:6.1.1"}],

Cell[TextData[{
  "Make sure that you are running X. Launch ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by typing ",
  StyleBox["mathematica", "MR"],
  " in a shell and pressing \[EnterKey]."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CounterAssignments -> {{"ItemizedList", 0}}}},
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.1.1"],

Cell["\<\
A splash screen with initialization information appears briefly, after which three windows appear. \
\>", "ListNote",
  CellTags->"b:6.1.1"],

Cell[TextData[{
  "Click anywhere inside the leftmost empty window. This window is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {}},
  CellTags->"b:6.1.1"],

Cell[TextData[{
  "Type ",
  StyleBox["N[Pi, 20]", "MR"],
  ". Then hold down the ",
  StyleBox["\[ShiftKey]", "KeyboardChars"],
  " key and press ",
  StyleBox["\[EnterKey]", "KeyboardChars"],
  " to evaluate. This should send the command to the kernel and return the same result as before. The ",
  StyleBox["In[1]", "MR"],
  " and ",
  StyleBox["Out[1]", "MR"],
  " labels are prepended once the evaluation is completed."
}], "ListNote",
  CellTags->"b:6.1.1"],

Cell["\<\
In the notebook window, there should be a horizontal line across the notebook; this is the horizontal insertion bar. If you do not see one, move the pointer until it becomes a horizontal I\[Hyphen]beam and click once to see the insertion bar.\
\>", "ListNote",
  CellTags->"b:6.1.1"],

Cell[TextData[{
  "Press the ",
  StyleBox["\[EscapeKey]", "KeyboardChars"],
  " key. You should see three small horizontal lines in a column (\[AliasIndicator]). Type ",
  StyleBox["int", "MR"],
  " and press ",
  StyleBox["\[EscapeKey]", "KeyboardChars"],
  " again. You should see an integral sign (\[ThinSpace]\[ThinSpace]\[Integral]\[ThinSpace]\[ThinSpace]). As an additional font check, typing ",
  StyleBox["\[Backslash][CheckmarkedBox]", "MR"],
  " and ",
  StyleBox["\[Backslash][CirclePlus]", "MR"],
  " should print the symbols ",
  StyleBox["\[CheckmarkedBox]", "MR"],
  " and ",
  StyleBox["\[CirclePlus]", "MR"],
  ", respectively. If the symbols show up correctly, the fonts have been properly installed."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {}},
  CellTags->"b:6.1.1"],

Cell[TextData[{
  "From the ",
  StyleBox["Help", "SR"],
  " menu, choose ",
  StyleBox["Help Browser", "SR"],
  ". The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Help Browser should appear."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {}},
  CellTags->"b:6.1.1"],

Cell[TextData[{
  "On Unix and Linux, you can test the X front end remotely, provided the ssh server on the remote machine allows X forwarding. You must be running X on the local machine to do this. In a shell, type \[LineSeparator]",
  StyleBox["ssh -X ", "MR"],
  StyleBox["hostname", "TI"],
  StyleBox[" /usr/local/bin/math", "MR"],
  ". (The exact pathname could be different depending on how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " was installed.) This command will launch ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on the remote machine ",
  StyleBox["hostname", "TI"],
  ". When the splash screen appears on your screen, follow step 2 and step 3 in the previous instructions."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 2.0}, {Inherited, Inherited}}}},
  CellTags->{"i:12", "b:6.1.1"}],

Cell[TextData[{
  "If you run into problems when doing these tests, see the troubleshooting tips in Section 6.7, ",
  ButtonBox["Troubleshooting",
    ButtonData:>{"Unix and Linux Troubleshooting"},
    ButtonStyle->"GettingStartedLink"],
  ". If you do not find the answer there, check the Technical Support website at ",
  ButtonBox["support.wolfram.com/mathematica",
    ButtonData:>{
      URL[ "http://support.wolfram.com/mathematica"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 0.0}, {Inherited, Inherited}}, TextJustification -> 0.0}},
  CellTags->"b:6.1.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["6.3 Command-Line Options", "Section",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 26.0}}}},
  CellTags->{"c:9", "b:6.2"}],

Cell[CellGroupData[{

Cell["math", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->{"c:10", "i:14", "b:6.2"}],

Cell[TextData[{
  "The ",
  StyleBox["math", "MR"],
  " command starts the kernel from within a shell. The kernel is the part of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that handles calculations. This commmand is also used by the front end. "
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 5.0}}}},
  CellTags->"b:6.2"],

Cell["Command\[Hyphen]Line Options", "Subsubsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-initfile ", "MR"],
  StyleBox["file", "TI"]
}], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 5.0}}}},
  CellTags->"b:6.2"],

Cell["\<\
Specifies the name of a file containing commands to be run on startup.\
\>", "ItemizedTextNote",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {3.0, Inherited}}}},
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-lmverbose", "MR"]], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 5.0}}}},
  CellTags->"b:6.2"],

Cell[TextData[{
  "Prints diagnostic information to ",
  StyleBox["stderr", "MR"],
  " on connecting to the license manager. This is useful for debugging problems related to the license server."
}], "ItemizedTextNote",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {3.0, Inherited}}}},
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-mathlink", "MR"]], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 5.0}}}},
  CellTags->"b:6.2"],

Cell[TextData[{
  "Specifies that the kernel should be run in ",
  StyleBox["MathLink", "TI"],
  " mode. See ",
  ButtonBox["www.wolfram.com/solutions/mathlink",
    ButtonData:>{
      URL[ "http://www.wolfram.com/solutions/mathlink"], None},
    ButtonStyle->"Hyperlink"],
  " for additional information about ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "ItemizedTextNote",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {3.0, Inherited}}}},
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-noinit", "MR"]], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 5.0}}}},
  CellTags->"b:6.2"],

Cell["\<\
Specifies that no initialization file should be read at startup.\
\>", "ItemizedTextNote",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {3.0, Inherited}}}},
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-password ", "MR"],
  StyleBox["str", "TI"]
}], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 5.0}}}},
  CellTags->"b:6.2"],

Cell[TextData[{
  "Specifies a password to use instead of the password or passwords stored in the ",
  StyleBox["mathpass", "MR"],
  " file. The password should have the form \[OpenCurlyDoubleQuote]",
  StyleBox["!servername", "TI"],
  "\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]",
  StyleBox["machinename mathid licensenumber password", "TI"],
  "\[CloseCurlyDoubleQuote]."
}], "ItemizedTextNote",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {3.0, Inherited}}}},
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-pwfile ", "MR"],
  StyleBox["file", "TI"]
}], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 5.0}}}},
  CellTags->"b:6.2"],

Cell["Specifies the name of a file that has a valid password.", "ItemizedTextNote",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {3.0, Inherited}}}},
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-run", "MR"]], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 5.0}}}},
  CellTags->"b:6.2"],

Cell["Takes a command to be run on startup as an argument.", "ItemizedTextNote",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {3.0, Inherited}}}},
  CellTags->"b:6.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["mathematica ", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->{"c:11", "i:15", "b:6.2"}],

Cell[TextData[{
  "The ",
  StyleBox["mathematica", "MR"],
  " command runs the X front end. In order for the front end to run, the ",
  StyleBox["DISPLAY", "MR"],
  " environment variable must be set and the front end must be able to locate the fonts included with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". "
}], "Text",
  CellTags->"b:6.2"],

Cell["Command\[Hyphen]Line Options", "Subsubsubsection",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-appHelper", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Combines the options ",
  StyleBox["-querySingleLaunch", "MR"],
  " and ",
  StyleBox["-forceSaveAs", "MR"],
  ". This option is typically used when configuring ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a helper application for web browsers."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-backgroundTaskDelay", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell["\<\
Specifies the time the front end delays background tasks like PostScript rendering when waiting for input. The delay is measured in milliseconds and the default setting is 100.\
\>", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-best", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell["\<\
Tells the front end to use an optimal visual, depth, and colormap combination.\
\>", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-cleanStart", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Tells the front end to ignore caches stored in the directory ",
  StyleBox["$UserBaseDirectory/FrontEnd/5.2_Caches", "MR"],
  ", and rebuilds the front end preferences file, ",
  StyleBox["$UserBaseDirectory/FrontEnd/init.m", "MR"],
  ". This option can also be abbreviated as ",
  StyleBox["-clean", "MR"],
  "."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-copyright", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell["\<\
Tells the front end to display copyright information from the command line.\
\>", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-font ", "MR"],
  StyleBox["f", "TI"]
}], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Specifies the font the front end uses in menus, buttons, and so on. The X program ",
  StyleBox["xfontsel", "MR"],
  " can be used to obtain a font name. The font name may be expressed either as an X Logical Font Description or as a valid font alias."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-forceSaveAs", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Forces the front end to bring up the Save dialog box when closing a file passed to it on the command line. This option is typically used when configuring ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a helper application for web browsers."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-help", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell["\<\
Prints a listing of all available command\[Hyphen]line options.\
\>", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-lmverbose", "MR"]], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}, PageBreakAbove -> True}},
  CellTags->"b:6.2"],

Cell[TextData[{
  "Prints diagnostic information to ",
  StyleBox["stderr", "MR"],
  " on connecting to the license manager. This is useful for diagnosing problems related to the license server."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-mathlink", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Causes the front end to run in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " mode. In ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " mode, the front end runs as a child process that is capable of accepting ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " packets. This option may be useful when the front end is used as a typesetting or graphics-rendering service."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-noSplashScreen", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell["Prevents the splash screen from being displayed on startup.", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-nostderrWindow", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Tells the front end not to display ",
  StyleBox["stderr", "MR"],
  " messages in a pop-up window."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-nowatchCLIPBOARD", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "If specified, the X front end does not watch the ",
  StyleBox["CLIPBOARD", "MR"],
  " property for change in ownership. The ",
  StyleBox["CLIPBOARD", "MR"],
  " property allows items to be shared between X applications via copy and paste commands. If this option is specified, you can only paste items within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "; items pasted into the ",
  StyleBox["CLIPBOARD", "MR"],
  " from other applications are ignored."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-preferencesDirectory ", "MR"],
  StyleBox["dir", "TI"]
}], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Specifies the location where preference settings are stored. The default location is ",
  StyleBox["~/.Mathematica", "MR"],
  "."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-primaryModifierMask ", "MR"],
  StyleBox["mask", "TI"]
}], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Specifies the modifier mask to use as the command key. The default is ",
  StyleBox["Mod1Mask", "MR"],
  "."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-printCommand ", "MR"],
  StyleBox["command", "TI"]
}], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Specifies a command for sending a file to the printer, such as ",
  StyleBox["lpr", "MR"],
  " or ",
  StyleBox["lp", "MR"],
  ". This command appears in the Print dialog box."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-pureKeys", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Disables key bindings involving modifier keys that are defined by the operating system. This option may need to be given in order for some front end keyboard commands to work correctly. For example, some systems may reserve ",
  StyleBox["\[ControlKey]\[LeftModified]", "KeyboardChars"],
  "6",
  StyleBox["\[RightModified]", "KeyboardChars"],
  " for internal use and then the front end cannot use this to typeset superscripts. Key bindings involving the ",
  StyleBox["\[ShiftKey]", "KeyboardChars"],
  " key are not disabled by this option."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-pwfile ", "MR"],
  StyleBox["file", "TI"]
}], "IndentedText",
  CellTags->"b:6.2"],

Cell["Specifies the name of a file containing a valid password.", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-querySingleLaunch", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Brings up a dialog box to ask the user if a file specified on the command line should be opened in the currently running front end. The dialog box appears only if the current front end was also launched with the ",
  StyleBox["-querySingleLaunch", "MR"],
  " option."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-screenXResolution ", "MR"],
  StyleBox["x", "TI"]
}], "IndentedText",
  CellTags->"b:6.2"],

Cell["\<\
Specifies the horizontal screen resolution of the notebook display in dots per inch. For example, if the default screen resolution is 75 dpi, setting the option to 150 causes the contents of the notebook window to scale horizontally by a factor of two.\
\>", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-screenYResolution ", "MR"],
  StyleBox["y", "TI"]
}], "IndentedText",
  CellTags->"b:6.2"],

Cell["\<\
Specifies the vertical screen resolution of the notebook display in dots per inch. For example, if the default screen resolution is 75 dpi, setting the option to 150 causes the contents of the notebook window to scale vertically by a factor of two.\
\>", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-secondaryModifierMask", "MR"],
  StyleBox[" mask", "TI"]
}], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Specifies the modifier mask to use as the option key. The default is ",
  StyleBox["Mod2Mask", "MR"],
  "."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-singleLaunch", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Allows only one copy of the front end per display. Multiple launches are prevented only if the currently running front end was launched with the ",
  StyleBox["-singleLaunch", "MR"],
  " or ",
  StyleBox["-querySingleLaunch", "MR"],
  " option."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-topDirectory ", "MR"],
  StyleBox["dir", "TI"]
}], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Specifies the directory in which ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is installed. The default location is ",
  StyleBox["/usr/local/Wolfram/Mathematica/5.2", "MR"],
  "."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-version", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell["\<\
Prints the current version of the front end from the command line.\
\>", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-visualChooser", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell["\<\
Starts the front end by first putting up the Visual Chooser. This is a dialog box that allows you to specify system parameters such as visual ID, depth, and colormap.\
\>", "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[StyleBox["-watchCLIPBOARD", "MR"]], "IndentedText",
  CellTags->"b:6.2"],

Cell[TextData[{
  "Tells the front end to watch the ",
  StyleBox["CLIPBOARD", "MR"],
  " property for change in ownership. This is the default. The ",
  StyleBox["CLIPBOARD", "MR"],
  " property allows items to be shared between X applications. If this option is set, then you can paste items into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from other applications."
}], "ItemizedTextNote",
  CellTags->"b:6.2"],

Cell[TextData[{
  StyleBox["-wwwBrowser ", "MR"],
  StyleBox["command", "TI"]
}], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {PageBreakAbove -> True}},
  CellTags->"b:6.2"],

Cell[TextData[{
  "Specifies the command to execute when opening URL links from the front end. The command can include a ",
  StyleBox["%s", "MR"],
  " format argument that is replaced with the URL."
}], "ItemizedTextNote",
  CellTags->"b:6.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.4 ",
  StyleBox["Mathematica", "SBO"],
  " Configuration Files"
}], "Section",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 26.0}}}},
  CellTags->{"c:12", "i:18", "b:6.3"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " stores preference settings and initialization data in two directories, ",
  StyleBox["$BaseDirectory", "MR"],
  " and ",
  StyleBox["$UserBaseDirectory", "MR"],
  ". Within each of these directories are several possible subdirectories with titles such as FrontEnd, Kernel, and Licensing."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {5.0, 5.0}}}},
  CellTags->{"i:20", "b:6.3"}],

Cell[TextData[{
  "Global settings that affect all users are stored in subdirectories of the directory ",
  StyleBox["$BaseDirectory", "MR"],
  ". The default value of ",
  StyleBox["$BaseDirectory", "MR"],
  " on Unix and Linux is ",
  StyleBox["/usr/share/Mathematica", "MR"],
  ". To redefine the location of global preference settings and initialization data, set the environment variable MATHEMATICA_BASE."
}], "BulletedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 3.0}}}},
  CellTags->"b:6.3"],

Cell[TextData[{
  "Settings that only affect a particular user are stored in subdirectories of the directory ",
  StyleBox["$UserBaseDirectory", "MR"],
  ", which is typically a subdirectory of the user\[CloseCurlyQuote]s home directory. The default value of ",
  StyleBox["$UserBaseDirectory", "MR"],
  " on Unix and Linux is ",
  StyleBox["~/.Mathematica", "MR"],
  ". To redefine the location of user preferences and initialization data, set the environment variable MATHEMATICA_USERBASE."
}], "BulletedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 6.0}, {Inherited, 3.0}}}},
  CellTags->"b:6.3"],

Cell[TextData[{
  "Settings in the directory ",
  StyleBox["$UserBaseDirectory", "MR"],
  " override global settings defined in the directory ",
  StyleBox["$BaseDirectory", "MR"],
  "."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {5.0, 5.0}}}},
  CellTags->"b:6.3"],

Cell[TextData[{
  "In the pathnames that follow, replace the variables ",
  StyleBox["$BaseDirectory", "MR"],
  " and ",
  StyleBox["$UserBaseDirectory", "MR"],
  " with the appropriate directories for your system. To find their locations on your system, evaluate the command ",
  StyleBox["$BaseDirectory", "MR"],
  " (or ",
  StyleBox["$UserBaseDirectory", "MR"],
  ") in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {5.0, 5.0}}}},
  CellTags->"b:6.3"],

Cell[CellGroupData[{

Cell["Kernel", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->{"c:13", "i:21", "b:6.3"}],

Cell[TextData[{
  "The initialization files used by the kernel contain ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands that are evaluated at startup, such as function definitions, packages to load, or kernel option settings. These commands are also available to the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {5.0, 5.0}}}},
  CellTags->"b:6.3"],

Cell[TextData[StyleBox["$BaseDirectory/Kernel/init.m", "MR"]], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 4.0}}}},
  CellTags->"b:6.3"],

Cell["\<\
This file is used to initialize the kernel and therefore should store any kernel commands that are appropriate for all users running the kernel.\
\>", "ItemizedTextNote",
  CellTags->"b:6.3"],

Cell[TextData[StyleBox["$UserBaseDirectory/Kernel/init.m", "MR"]], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 4.0}}}},
  CellTags->"b:6.3"],

Cell["\<\
This file stores user-specific commands used to initialize the kernel. \
\>", "ItemizedTextNote",
  CellTags->"b:6.3"],

Cell["Kernel initialization files are not created automatically.", "Text",
  CellTags->"b:6.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Front End", "Subsubsection",
  CellTags->{"c:14", "i:19", "b:6.3"}],

Cell[TextData[{
  "Front end initialization files store preference settings such as the values of global options in the Option Inspector. These files are automatically updated by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " when you change a setting in the front end. To modify this file, make your changes from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " rather than editing the file directly."
}], "Text",
  CellTags->"b:6.3"],

Cell[TextData[StyleBox["$BaseDirectory/FrontEnd/init.m", "MR"]], "IndentedText",
  CellTags->"b:6.3"],

Cell[TextData[{
  "This file stores systemwide defaults used by all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front ends. The settings in this file affect all users. Section 6.5, ",
  ButtonBox["Setting Systemwide Defaults",
    ButtonData:>{"Setting Systemwide Defaults on Unix and Linux"},
    ButtonStyle->"GettingStartedLink"],
  ", explains how to implement changes to this global file."
}], "ItemizedTextNote",
  CellTags->"b:6.3"],

Cell[TextData[StyleBox["$UserBaseDirectory/FrontEnd/init.m", "MR"]], "IndentedText",
  CellTags->"b:6.3"],

Cell["\<\
This file defines settings within the front end that are specific to each user. \
\>", "ItemizedTextNote",
  CellTags->"b:6.3"],

Cell[TextData[StyleBox["$UserBaseDirectory/FrontEnd/5.2_Caches/", "MR"]], "IndentedText",
  CellTags->{"i:17", "b:6.3"}],

Cell["\<\
This directory within the user\[CloseCurlyQuote]s home directory stores information on system settings that are read by the front end.\
\>", "ItemizedTextNote",
  CellTags->"b:6.3"],

Cell[TextData[{
  StyleBox["~/.Xdefaults", "MR"],
  " or ",
  StyleBox["~/.Xresources", "MR"]
}], "IndentedText",
  CellTags->"b:6.3"],

Cell["\<\
This file within the user\[CloseCurlyQuote]s home directory stores font choices, menu color choices, and other resources used by the front end.\
\>", "ItemizedTextNote",
  CellTags->"b:6.3"],

Cell["Front end initialization files are created automatically.", "Text",
  CellTags->"b:6.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Passwords", "Subsubsection",
  CellTags->{"c:15", "i:22", "b:6.3"}],

Cell[TextData[{
  "Passwords are stored in the ",
  StyleBox["mathpass", "MR"],
  " file, described in further detail in ",
  ButtonBox["Registration and Passwords",
    ButtonData:>{"Registration and Passwords"},
    ButtonStyle->"GettingStartedLink"],
  " in the Introduction. In the following pathname, replace the variable ",
  StyleBox["$InstallationDirectory", "MR"],
  " with the directory where you installed ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The default value of ",
  StyleBox["$InstallationDirectory", "MR"],
  " on Unix and Linux is ",
  StyleBox["/usr/local/Wolfram/Mathematica/5.2", "MR"],
  ". To find the value of ",
  StyleBox["$InstallationDirectory", "MR"],
  " on your system, evaluate the command ",
  StyleBox["$InstallationDirectory", "MR"],
  " in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook."
}], "Text",
  CellTags->{"i:46", "b:6.3"}],

Cell[TextData[StyleBox["$BaseDirectory/Licensing/mathpass", "MR"]], "IndentedText",
  CellTags->"b:6.3"],

Cell["This is the default location for the global password file. ", "ItemizedTextNote",
  CellTags->"b:6.3"],

Cell[TextData[StyleBox["$InstallationDirectory/Configuration/Licensing/mathpass", "MR"]], "IndentedText",
  CellTags->"b:6.3"],

Cell["\<\
This is an alternative location for the global password file. \
\>", "ItemizedTextNote",
  CellTags->"b:6.3"],

Cell[TextData[StyleBox["$UserBaseDirectory/Licensing/mathpass", "MR"]], "IndentedText",
  TaggingRules:>{"PrintOptions" -> {PageBreakAbove -> True}},
  CellTags->"b:6.3"],

Cell[TextData[{
  "While this is not normally the location for the password file, a user-specific ",
  StyleBox["mathpass", "MR"],
  " file can be stored here."
}], "ItemizedTextNote",
  CellTags->"b:6.3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["6.5 Setting Systemwide Defaults", "Section",
  CellTags->{"c:16", "i:23", "b:6.4"}],

Cell[TextData[{
  "If you have installed ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in a location where multiple users run it (for example, on a file server or multi-user machine), then you can set up systemwide defaults for the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end and kernel. This is ideal for setting up ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for use in computer labs and classrooms. If you share the directory ",
  StyleBox["$BaseDirectory", "MR"],
  " across the network, these defaults will also take effect on local installations that use the shared ",
  StyleBox["$BaseDirectory", "MR"],
  "."
}], "Text",
  CellTags->"b:6.4"],

Cell[TextData[{
  "The following instructions assume that ",
  StyleBox["$BaseDirectory", "MR"],
  " and ",
  StyleBox["$UserBaseDirectory", "MR"],
  " have their default values, ",
  StyleBox["/usr/share/Mathematica", "MR"],
  " and ",
  StyleBox["~/.Mathematica", "MR"],
  " respectively. "
}], "Text",
  CellTags->"b:6.4"],

Cell["To set up a configuration file for the front end:", "Subsubsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->"b:6.4"],

Cell[TextData[{
  "Launch ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and set up any changes to the front end that you need. ",
  "For example, you may want to modify default file locations, language options, or menu settings."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CounterAssignments -> {{"ItemizedList", 0}}}},
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.4"],

Cell[TextData[{
  "Quit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "ItemizedList",
  CellTags->"b:6.4"],

Cell[TextData[{
  "Copy the file ",
  StyleBox["~/.Mathematica/FrontEnd/init.m", "MR"],
  " to the directory ",
  StyleBox["/usr/share/Mathematica/FrontEnd", "MR"],
  "."
}], "ItemizedList",
  CellTags->"b:6.4"],

Cell[TextData[{
  "These settings will now be used by the front end unless overridden by the local ",
  StyleBox["init.m", "MR"],
  " file stored in the user\[CloseCurlyQuote]s directory ",
  StyleBox["~/.Mathematica/FrontEnd", "MR"],
  "."
}], "Text",
  CellTags->"b:6.4"],

Cell["To set up a configuration file for the kernel:", "Subsubsubsection",
  CellTags->"b:6.4"],

Cell[TextData[{
  "Launch ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and create a new file."
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CounterAssignments -> {{"ItemizedList", 0}}}},
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.4"],

Cell[TextData[{
  "Add any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands that should be evaluated on startup. For example, you may want to add a function definition or display a message at startup. ",
  "Enter all the commands in the same cell, separating commands with semicolons."
}], "ItemizedList",
  CellTags->"b:6.4"],

Cell[TextData[{
  "Make this cell an initialization cell by selecting the cell bracket and then choosing ",
  StyleBox["Cell", "SR"],
  " \[RightTriangle] ",
  StyleBox["Cell Properties", "SR"],
  " \[RightTriangle] ",
  StyleBox["Initialization Cell", "SR"],
  ". "
}], "ItemizedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 6.0}, {Inherited, 6.0}}, PageBreakAbove -> True}},
  CellTags->"b:6.4"],

Cell[TextData[{
  "Using ",
  StyleBox["File", "SR"],
  " \[RightTriangle] ",
  StyleBox["Save As Special ", "SR"],
  "\[RightTriangle] ",
  StyleBox["Package Format", "SR"],
  ", save the file as ",
  StyleBox["/usr/share/Mathematica/Kernel/init.m", "MR"],
  "."
}], "ItemizedList",
  CellTags->"b:6.4"],

Cell[TextData[{
  "These commands will be evaluated when users launch ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". If you added a function definition, that function will be available to all users."
}], "Text",
  CellTags->"b:6.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["6.6 Fonts", "Section",
  CellTags->{"c:17", "i:28", "b:6.5"}],

Cell[TextData[{
  "Dealing with fonts under Unix can sometimes be tricky. The important issues in dealing with fonts in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are presented here for your convenience. "
}], "Text",
  CellTags->"b:6.5"],

Cell[CellGroupData[{

Cell["Font Formats", "Subsubsection",
  CellTags->{"c:18", "i:27", "b:6.5"}],

Cell[TextData[{
  "BDF and Type1 fonts are installed by ",
  StyleBox["MathInstaller.", "MR"],
  " PCF fonts are included on the CD but not installed. If your X server requires PCF fonts, copy them from the CD and install them according to the instructions that follow. If you need fonts in another format, convert them using utilities included in your X installation. Your license gives you permission to convert the fonts to an appropriate format for your X server."
}], "Text",
  CellTags->{"i:27", "b:6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Font Installation", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->{"c:19", "i:26", "b:6.5"}],

Cell[TextData[{
  "All machines that display the front end must have access to the fonts included with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". If the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " process is running on a remote machine and the front end is displayed on the local machine, the X server on the local machine must know where to find the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts. To do this, add the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts to the local font path by running a command like the following on the local machine."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 4.0}, {Inherited, Inherited}}}},
  CellTags->{"i:35", "b:6.5"}],

Cell[TextData[StyleBox["xset fp+ /usr/local/Wolfram/Mathematica/5.2/SystemFiles/Fonts/Type1; xset fp rehash", "MR"]], "Text",
  CellTags->"b:6.5"],

Cell[TextData[{
  "Be sure to execute ",
  StyleBox["xset fp rehash", "MR"],
  " to make the fonts available to the local X server."
}], "Text",
  CellTags->"b:6.5"],

Cell[TextData[{
  "For optimal onscreen performance, Type1 fonts should appear before BDF or PCF fonts in the font path. Hence, ",
  StyleBox["$InstallationDirectory/SystemFiles/Fonts/Type1", "MR"],
  " should appear before ",
  StyleBox["$InstallationDirectory/SystemFiles/Fonts/BDF", "MR"],
  " or ",
  StyleBox["$InstallationDirectory/SystemFiles/Fonts/PCF", "MR"],
  ". You can check the order of the font path by executing the command ",
  StyleBox["xset q", "MR"],
  "."
}], "Text",
  CellTags->"b:6.5"],

Cell[TextData[{
  "Most platforms only require the BDF bitmap fonts, but some platforms, such as HP Tru64 Unix\[CloseCurlyQuote]s X server, require PCF instead of BDF. Some Windows-based X servers, for example SCO\[CloseCurlyQuote]s XVision, require PCF fonts as well. Note that some Windows-based X servers, such as Hummingbird\[CloseCurlyQuote]s Exceed, require that you compile fonts into a format specific to the X server. For further information, visit ",
  ButtonBox["support.wolfram.com/mathematica/systems/unix/interface",
    ButtonData:>{
      URL[ "http://support.wolfram.com/mathematica/systems/unix/interface"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 6.0}, {Inherited, Inherited}}, TextJustification -> 0.0}},
  CellTags->"b:6.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Font Servers", "Subsubsection",
  CellTags->{"c:20", "i:29", "b:6.5"}],

Cell[TextData[{
  "You may prefer not to install local copies of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts on all machines. You can instead set up a font server with all the necessary ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts. The other machines on the network can then find the fonts as needed by reading them from the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directory on the font server. Consult your operating system\[CloseCurlyQuote]s documentation for further information."
}], "Text",
  CellTags->"b:6.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Font Errors", "Subsubsection",
  CellTags->{"c:21", "i:31", "b:6.5"}],

Cell[TextData[{
  "On some systems, the font path is limited in length, and it is possible to receive ",
  StyleBox["xset: bad font path element", "MR"],
  " errors even if the fonts are available to the server. In this case, try reordering the font path and adding the directories for the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts earlier in the path. The directory ",
  StyleBox["$InstallationDirectory/SystemFiles/Fonts/Type1", "MR"],
  " must be listed before ",
  StyleBox["$InstallationDirectory/SystemFiles/Fonts/BDF", "MR"],
  " on the font path for optimal onscreen performance."
}], "Text",
  CellTags->{"i:25", "b:6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Fonts and Printing", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->{"c:22", "i:32", "b:6.5"}],

Cell[TextData[{
  "When the X front end prints a notebook, it uses AFM files for the font metrics needed for printing. If you want to print using a particular font not included with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you will need the AFM files for the font. These files are installed in either ",
  StyleBox["$InstallationDirectory/Configuration/Fonts/AFM", "MR"],
  ", ",
  StyleBox["/usr/lib/AFM", "MR"],
  ", or ",
  StyleBox["/usr/lib/afm", "MR"],
  ". Fonts are normally downloaded to the printer by the front end when printing. You may be able to download the fonts and store them on the printer. See the documentation and programs that came with your printer for more information."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 4.0}, {Inherited, Inherited}}}},
  CellTags->{"i:24", "b:6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["GhostScript", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->{"c:23", "i:30", "b:6.5"}],

Cell[TextData[{
  "If you want to view ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics using GhostScript, you need to make GhostScript aware of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts. For more information, contact Technical Support by sending email to ",
  ButtonBox["support@wolfram.com",
    ButtonData:>{
      URL[ "mailto:support@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ", or visit  ",
  ButtonBox["support.wolfram.com/mathematica/graphics/export/ghostscript.html",
    ButtonData:>{
      URL[ "http://support.wolfram.com/mathematica/graphics/export/ghostscript.html"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {TextJustification -> 0.0}},
  CellTags->"b:6.5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["6.7 Troubleshooting", "Section",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}, PageBreakAbove -> True}},
  CellTags->{"c:24", "i:37", "b:6.6"}],

Cell[TextData[{
  "If you have problems using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on Unix or Linux, check this list for solutions. Troubleshooting issues involving ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " are covered in Chapter 4, ",
  StyleBox[ButtonBox["MathLM",
    ButtonData:>{"Diagnostics"},
    ButtonStyle->"GettingStartedLink"],
    FontSlant->"Italic"],
  ButtonBox[" Troubleshooting",
    ButtonData:>{"Diagnostics"},
    ButtonStyle->"GettingStartedLink"],
  "."
}], "Text",
  CellTags->"b:6.6"],

Cell[CellGroupData[{

Cell["CD", "Subsubsection",
  CellTags->{"c:25", "i:43", "b:6.6"}],

Cell[TextData[{
  "Make sure the CD is properly mounted with the correct ",
  StyleBox["mount", "MR"],
  " command (see ",
  ButtonBox["Mounting a CD on Unix and Linux",
    ButtonData:>{"Mounting a CD on Unix and Linux"},
    ButtonStyle->"GettingStartedLink"],
  " in the Appendix). If the filenames on the CD appear in the wrong case, it means the CD is mounted incorrectly."
}], "BulletedList",
  CellTags->"b:6.6"],

Cell[TextData[{
  "On HP-UX, be sure to use the ",
  StyleBox["pfs_mount", "MR"],
  " command and not the ",
  StyleBox["mount", "MR"],
  " command. The ",
  StyleBox["pfs_mount", "MR"],
  " command mounts the CD with Rock Ridge extensions. If you use the ",
  StyleBox["mount", "MR"],
  " command, the filenames on the CD may appear in all uppercase letters and some filenames may be truncated. Note that the ",
  StyleBox["pfs_mount", "MR"],
  " command needs a daemon to be running in the background."
}], "BulletedList",
  CellTags->{"i:41", "b:6.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Installation", "Subsubsection",
  CellTags->{"c:26", "i:36", "b:6.6"}],

Cell["\<\
Make sure to run the installer from the directory in which it is located. \
\>", "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Passwords", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->{"c:27", "i:38", "b:6.6"}],

Cell[TextData[{
  "If the front end password dialog box appears when you launch ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", either ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " could not locate the ",
  StyleBox["mathpass", "MR"],
  " file or there was no valid password in the ",
  StyleBox["mathpass", "MR"],
  " file. To resolve this problem, first check that there is a ",
  StyleBox["mathpass", "MR"],
  " file in one of these directories: ",
  StyleBox["/usr/share/Mathematica/Licensing", "MR"],
  ", ",
  StyleBox["$InstallationDirectory/Configuration/Licensing", "MR"],
  ", or ",
  StyleBox["~/.Mathematica/Licensing", "MR"],
  ". If you did not find a ",
  StyleBox["mathpass", "MR"],
  " file in these locations, follow the instructions in Section 4.3.1, ",
  ButtonBox["Entering a Single-\[InvisibleSpace]Machine Password in the Front End",
    ButtonData:>{"Entering a Single-Machine Password"},
    ButtonStyle->"GettingStartedLink"],
  ", to re-enter your password. "
}], "Text",
  CellTags->"b:6.6"],

Cell[TextData[{
  "If there is a ",
  StyleBox["mathpass", "MR"],
  " file in one of those directories, the password or passwords are invalid. Make sure that your MathID number matches the MathID number used to issue your password. If your MathID number changes, you will need to contact Customer Service to get a new password. Contact information is provided in ",
  ButtonBox["Registration and Passwords",
    ButtonData:>{"Registration and Passwords"},
    ButtonStyle->"GettingStartedLink"],
  " in the Introduction."
}], "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Paths", "Subsubsection",
  CellTags->{"c:28", "i:39", "b:6.6"}],

Cell[TextData[{
  "By default, the front end runs the command ",
  StyleBox["math", "MR"],
  " to start the kernel. If ",
  StyleBox["math", "MR"],
  " is not on the path, then you must use the ",
  StyleBox["Kernel Configuration Options", "SR"],
  " command in the ",
  StyleBox["Kernel", "SR"],
  " menu to specify the full pathname of the ",
  StyleBox["math", "MR"],
  " command."
}], "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Front End Preferences", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->{"c:29", "i:44", "b:6.6"}],

Cell[TextData[{
  "Front end preferences, such as the names of recently opened and saved files, are stored in  ",
  StyleBox["~/.Mathematica/FrontEnd", "MR"],
  ". The most convenient way to reset the front end preferences to their default values is to restart ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using the command ",
  StyleBox["mathematica -cleanStart", "MR"],
  ". This will cause the initialization file to be rebuilt automatically."
}], "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Caches", "Subsubsection",
  CellTags->{"c:30", "i:33", "b:6.6"}],

Cell[TextData[{
  "Information about your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " layout, such as the locations of text resource files and Help Browser files, is stored in caches. These caches are located in the directory ",
  StyleBox["~/.Mathematica/FrontEnd/5.2_Caches", "MR"],
  ". A corrupted cache may cause the front end to produce an error or quit immediately on startup. The most convenient way to reset the caches to their default values is to use the option ",
  StyleBox["-cleanStart", "MR"],
  " at startup. This will cause the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " caches and the initialization file to be rebuilt automatically. If you want to rebuild your caches but retain your preferences, hold down ",
  StyleBox["\[ShiftKey]", "KeyboardChars"],
  " during startup. This will delete and rebuild the cache without rebuilding the front end initialization file."
}], "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Fonts ", "Subsubsection",
  CellTags->{"c:31", "i:34", "b:6.6"}],

Cell["\<\
Make sure that the fonts are installed on the machine that displays the front end or on a font server.\
\>", "BulletedList",
  CellTags->"b:6.6"],

Cell[TextData[{
  "If you see the error ",
  StyleBox["xset: bad font path element", "MR"],
  ", either the fonts are not properly installed on your machine, or your font path is too long and exceeds the allowable limit. Make sure the fonts are properly installed, or copy the fonts to a directory that is already on the font path. "
}], "BulletedList",
  CellTags->"b:6.6"],

Cell[TextData[{
  "On HP-UX, you may get ",
  StyleBox["xset", "MR"],
  " errors for a different reason. Visit ",
  ButtonBox[" support.wolfram.com/mathematica/systems/unix/hpux/xset.html",
    ButtonData:>{
      URL[ "http://support.wolfram.com/mathematica/systems/unix/hpux/xset.html"], None},
    ButtonStyle->"Hyperlink"],
  " for a description of the problem and how to fix it."
}], "BulletedList",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Key Bindings", "Subsubsection",
  CellTags->{"c:32", "b:6.6", "i:47"}],

Cell[TextData[{
  "If some keyboard shortcuts or typesetting commands, such as  ",
  StyleBox["\[ControlKey]\[LeftModified]", "KeyboardChars"],
  StyleBox["6", "MR"],
  StyleBox["\[RightModified]", "KeyboardChars"],
  ", do not work, see if the window manager and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are trying to use the same keyboard shortcuts. In some cases, using the option ",
  StyleBox["-pureKeys", "MR"],
  " may correct this problem."
}], "BulletedList",
  CellTags->"b:6.6"],

Cell[TextData[{
  "Keyboard shortcuts for menus and typesetting commands are based on the layout of U.S. keyboards. On international keyboards, you may have to use an alternative key combination to activate the menu command. Some key sequences may not work if the character that constitutes the shortcut is accessed through the ",
  StyleBox["\[Mod1Key]", "KeyboardChars"],
  ", ",
  StyleBox["\[Mod2Key]", "KeyboardChars"],
  ", or ",
  StyleBox["\[ControlKey]", "KeyboardChars"],
  " key."
}], "BulletedList",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Technical Support", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {Inherited, 6.0}}}},
  CellTags->{"c:33", "b:6.6"}],

Cell[TextData[{
  "For further assistance, check the Technical Support FAQs on the web at ",
  ButtonBox["support.wolfram.com",
    ButtonData:>{
      URL[ "http://support.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ". If you do not find the information you need, please contact Technical Support by sending email to ",
  ButtonBox["support@wolfram.com",
    ButtonData:>{
      URL[ "mailto:support@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  " or by calling +1-217-398-6500. Include your license ID number in all correspondence. Your license ID number is printed on your license certificate. It is also available after installation by going to the ",
  StyleBox["Help", "SR"],
  " menu and clicking ",
  StyleBox["About Mathematica", "SR"],
  ". You must be a registered customer in order to receive installation support. You must have a current ",
  StyleBox["Premier Service",
    FontSlant->"Italic"],
  " subscription to receive Technical Support."
}], "Text",
  CellTags->"b:6.6"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 938}},
ScreenStyleEnvironment->"Brackets",
PrintingStyleEnvironment->"EnhancedPrintout",
WindowSize->{570, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->Automatic,
PrintingCopies->1,
PrintingStartingPageNumber->77,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
          CounterBox[ "Page"]], "PageNumber"], Inherited, Cell[ 
      "Mathematica Products System Administration Guide", "PageHeader"]}, {
    Cell[ "6. Mathematica Administration on Unix and Linux", "PageHeader"], 
      Inherited, Cell[ 
        TextData[ 
          CounterBox[ "Page"]], "PageNumber"]}},
PageFooters->{{Inherited, None, Inherited}, {Inherited, None, Inherited}},
PageFooterLines->{False, False},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"FirstPageHeader"->False,
"FirstPageFooter"->False},
TaggingRules:>{"OptionsEnvironment" -> "Online", "NextIndexingNumber" -> 48, \
"IndexEntries" -> {{"i:24", "AFM files"}, {"i:29", "Font servers"}, {"i:36", \
"Installation troubleshooting on Unix and Linux"}, {"i:37", "Troubleshooting \
Unix and Linux"}, {"i:41", 
  StyleBox[ "pfs_mount", "MR"]}, {"i:5", {
  StyleBox[ 
  "MathInstaller", 
    "MR"], " command-line options"}}, {"i:1", "Unix and Linux", "multiple \
platform environments"}, {"i:1", "Unix and Linux", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on different platforms"}}, {"i:1", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on Unix and Linux"}, "installing for different platforms"}, \
{"i:10", "Installation testing", "Unix and Linux"}, {"i:10", "Unix and \
Linux", "testing the installation"}, {"i:11", 
  StyleBox[ 
  "ssh", "MR"], "and testing remote kernel on Unix and Linux"}, {"i:12", 
  StyleBox[ 
  "ssh", "MR"], "and testing remote front end on Unix and Linux"}, {"i:14", \
"Command-line options", "Unix and Linux kernel"}, {"i:14", "Unix and Linux", \
{
  StyleBox[ 
  "math", "MR"], " command-line options"}}, {"i:15", "Command-line options", \
"Unix and Linux front end"}, {"i:15", "Command-line options", 
  StyleBox[ "mathematica", "MR"]}, {"i:15", "Unix and Linux", {
  StyleBox[ 
  "mathematica", 
    "MR"], " command-line options"}}, {"i:17", "Front end", "caches on Unix \
and Linux"}, {"i:18", "Configuration files", "Unix and Linux"}, {"i:18", \
"Initialization files", "Unix and Linux"}, {"i:18", "Location of \
configuration files", "Unix and Linux"}, {"i:18", "Unix and Linux", \
"configuration files"}, {"i:18", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on Unix and Linux"}, "configuration files"}, {"i:19", "Front \
end", "configuration files on Unix and Linux"}, {"i:19", "Preferences", "Unix \
and Linux"}, {"i:20", 
  StyleBox[ "$BaseDirectory", "MR"], "Unix and Linux"}, {"i:20", 
  StyleBox[ 
  "$UserBaseDirectory", 
    "MR"], "Unix and Linux"}, {"i:21", "Kernel configuration files", "Unix \
and Linux"}, {"i:22", "Location of password file", "Unix and Linux"}, \
{"i:22", "mathpass file", {"locations for ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on Unix and Linux"}}, {"i:22", "Unix and Linux", "location \
of mathpass file"}, {"i:23", "Defaults, systemwide", "Unix and Linux"}, \
{"i:23", "Global configuration files", "Unix and Linux"}, {"i:23", \
"Systemwide defaults", "Unix and Linux"}, {"i:23", "Unix and Linux", \
"systemwide defaults"}, {"i:24", "Printing", "and Unix and Linux fonts"}, \
{"i:25", "Fonts on Unix and Linux", "reordering font path"}, {"i:26", "Unix \
and Linux", "font installation"}, {"i:26", "X servers", "and font \
installation"}, {"i:27", "X servers", "and font formats"}, {"i:28", "Unix and \
Linux", "fonts"}, {"i:29", "Unix and Linux", "font servers"}, {"i:31", "Unix \
and Linux", "font errors"}, {"i:32", "Unix and Linux", "fonts and printing"}, \
{"i:33", "Troubleshooting Unix and Linux", "caches"}, {"i:33", "Unix and \
Linux", "caches troubleshooting"}, {"i:34", "Fonts on Unix and Linux", \
"troubleshooting"}, {"i:34", "Troubleshooting Unix and Linux", "fonts"}, \
{"i:34", "Unix and Linux", "fonts troubleshooting"}, {"i:35", "Front end", \
"displaying fonts on Unix and Linux"}, {"i:36", "Troubleshooting Unix and \
Linux", "installation"}, {"i:36", "Unix and Linux", "installation \
troubleshooting"}, {"i:37", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on Unix and Linux"}, "troubleshooting"}, {"i:38", \
"Troubleshooting Unix and Linux", "passwords"}, {"i:38", "Unix and Linux", \
"password troubleshooting"}, {"i:39", "Paths", "troubleshooting on Unix and \
Linux"}, {"i:39", "Troubleshooting Unix and Linux", "paths"}, {"i:39", "Unix \
and Linux", "path troubleshooting"}, {"i:40", "Platforms", {"specifying to ", \

  StyleBox[ 
  "MathInstaller", 
    "MR"]}}, {"i:43", "CD-ROM on Unix and Linux", "troubleshooting"}, \
{"i:43", "Troubleshooting Unix and Linux", "CD"}, {"i:43", "Unix and Linux", \
"CD-ROM troubleshooting"}, {"i:44", "Troubleshooting Unix and Linux", "front \
end preferences"}, {"i:44", "Unix and Linux", "front end preferences \
troubleshooting"}, {"i:45", "CD-ROM on Unix and Linux", "exporting to remote \
machine"}, {"i:46", 
  StyleBox[ 
  "$InstallationDirectory", 
    "MR"], "Unix and Linux"}, {"i:47", "Unix and Linux", "key bindings \
troubleshooting"}, {"i:5", "Command-line options", 
  StyleBox[ "MathInstaller", "MR"]}, {"i:5", "Unix and Linux", {
  StyleBox[ 
  "MathInstaller", 
    "MR"], " command-line options"}}, {"i:6", "Automatic installation", "Unix \
and Linux"}, {"i:6", "Installer command-line options", "Unix and Linux"}, \
{"i:6", "Silent installation", "Unix and Linux"}, {"i:6", "Unix and Linux", {
  StyleBox[ "MathInstaller", "MR"], " command-line options"}}, {"i:6", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on Unix and Linux"}, "installing from a script"}, {"i:6", \
{"Installing ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " from a script"}, "Unix and Linux"}, {"i:7", {"Standalone \
copy of ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"]}, "installing on Unix and Linux"}, {"i:8", "Front end", \
"testing on Unix and Linux"}, {"i:9", "Kernel", "testing on Unix and Linux"}, \
{"i:1", "Platforms", "multiple", ""}, {"i:10", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on Unix and Linux"}, "installation testing", ""}, {"i:10", \
{"Testing ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " installation"}, "Unix and Linux", ""}, {"i:14", \
"Command-line options", {
  StyleBox[ 
  "math", "MR"], " on Unix and Linux"}, ""}, {"i:14", "Kernel command-line \
options", "Unix and Linux", ""}, {"i:14", {
  StyleBox[ 
  "math", "MR"], " command-line options"}, "Unix and Linux", ""}, {"i:15", \
"Front end command-line options", "Unix and Linux", ""}, {"i:15", {
  StyleBox[ 
  "mathematica", 
    "MR"], " command-line options"}, "", ""}, {"i:17", "Caches", "Unix and \
Linux location", ""}, {"i:2", "Unix and Linux", {"installing ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " from a file server"}, ""}, {"i:2", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on Unix and Linux"}, "installing from a file server", ""}, \
{"i:2", {"Installing ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " from a file server"}, "Unix and Linux", ""}, {"i:22", \
"Passwords", "file locations for Unix and Linux", ""}, {"i:24", "Fonts on \
Unix and Linux", "AFM files", ""}, {"i:24", "Fonts on Unix and Linux", \
"printing", ""}, {"i:25", "Fonts on Unix and Linux", "font path \
restrictions", ""}, {"i:26", "Fonts on Unix and Linux", "installation", ""}, \
{"i:27", "Fonts on Unix and Linux", "formats", ""}, {"i:28", "Fonts on Unix \
and Linux", "", ""}, {"i:3", "Unix and Linux", {"running ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " from a file server"}, ""}, {"i:3", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on Unix and Linux"}, "running from a file server", ""}, \
{"i:30", "GhostScript", "", ""}, {"i:33", "Caches", "Unix and Linux \
troubleshooting", ""}, {"i:38", "Passwords", "troubleshooting on Unix and \
Linux", ""}, {"i:47", "Troubleshooting Unix and Linux", "key bindings", ""}, \
{"i:7", "Unix and Linux", {"installing a single-machine copy of ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"]}, ""}, {"i:7", {"Single-machine copy of ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"]}, "installing on Unix and Linux", ""}, {"i:7", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " on Unix and Linux"}, "installing a single-machine copy", \
""}}, "PaginationCache" -> {{2004, 9, 2, 12, 18, \
30.4683418`9.236423726285777}, {77, 77, 77, 77, 77, 77, 77, 78, 78, 78, 78, \
78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 79, 79, 79, 79, 79, 79, 79, 79, 79, \
79, 79, 79, 79, 79, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 81, \
81, 81, 81, 81, 81, 81, 81, 81, 81, 82, 82, 82, 82, 82, 82, 82, 83, 83, 83, \
83, 83, 83, 83, 83, 83, 83, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, \
85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, \
85, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, \
86, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, \
87, 87, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, \
88, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 90, 90, 90, 90, \
90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 91, 91, 91, 91, 91, \
91, 91, 91, 91, 91, 91, 91, 91, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, \
92, 93, 93, 93, 93, 93, 93, 93, 93, 93, 94, 94, 94, 94, 94, 94, 94, 94, 94, \
94, 94, 94, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 96, 96}, Automatic}},
DefaultNewCellStyle->"Text",
AutoItalicWords->{
  "Mathematica", "MathLM", "MathSource", "MathReader", "MathScript"},
PrivateFontOptions->{"OperatorSubstitution"->False},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[2599, 69, 85, 1, 61, "Section",
      CellTags->{"c:1", "b:6.0.4"}]},
  "b:6.0.4"->{
    Cell[2599, 69, 85, 1, 61, "Section",
      CellTags->{"c:1", "b:6.0.4"}],
    Cell[2687, 72, 655, 18, 70, "Text",
      CellTags->"b:6.0.4"],
    Cell[3345, 92, 792, 15, 70, "Text",
      CellTags->{"i:1", "b:6.0.4"}]},
  "i:1"->{
    Cell[3345, 92, 792, 15, 70, "Text",
      CellTags->{"i:1", "b:6.0.4"}]},
  "c:2"->{
    Cell[4162, 111, 153, 5, 70, "Subsection",
      CellTags->{"c:2", "i:2", "b:6.0.0"}]},
  "i:2"->{
    Cell[4162, 111, 153, 5, 70, "Subsection",
      CellTags->{"c:2", "i:2", "b:6.0.0"}]},
  "b:6.0.0"->{
    Cell[4162, 111, 153, 5, 70, "Subsection",
      CellTags->{"c:2", "i:2", "b:6.0.0"}],
    Cell[4318, 118, 620, 12, 70, "Text",
      CellTags->"b:6.0.0"],
    Cell[4941, 132, 1171, 28, 70, "Text",
      CellTags->{"i:45", "b:6.0.0"}]},
  "i:45"->{
    Cell[4941, 132, 1171, 28, 70, "Text",
      CellTags->{"i:45", "b:6.0.0"}]},
  "c:3"->{
    Cell[6149, 165, 150, 5, 70, "Subsection",
      CellTags->{"c:3", "i:3", "b:6.0.1"}]},
  "i:3"->{
    Cell[6149, 165, 150, 5, 70, "Subsection",
      CellTags->{"c:3", "i:3", "b:6.0.1"}]},
  "b:6.0.1"->{
    Cell[6149, 165, 150, 5, 70, "Subsection",
      CellTags->{"c:3", "i:3", "b:6.0.1"}],
    Cell[6302, 172, 863, 22, 70, "Text",
      CellTags->"b:6.0.1"]},
  "c:4"->{
    Cell[7202, 199, 132, 3, 70, "Subsection",
      CellTags->{"c:4", "i:6", "b:6.0.2"}]},
  "i:6"->{
    Cell[7202, 199, 132, 3, 70, "Subsection",
      CellTags->{"c:4", "i:6", "b:6.0.2"}]},
  "b:6.0.2"->{
    Cell[7202, 199, 132, 3, 70, "Subsection",
      CellTags->{"c:4", "i:6", "b:6.0.2"}],
    Cell[7337, 204, 434, 8, 70, "Text",
      CellTags->"b:6.0.2"],
    Cell[7774, 214, 163, 5, 70, "Text",
      CellTags->{"i:5", "b:6.0.2"}],
    Cell[7940, 221, 78, 1, 70, "IndentedText",
      CellTags->"b:6.0.2"],
    Cell[8021, 224, 251, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[8275, 229, 118, 4, 70, "IndentedText",
      CellTags->"b:6.0.2"],
    Cell[8396, 235, 495, 13, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[8894, 250, 113, 4, 70, "IndentedText",
      CellTags->"b:6.0.2"],
    Cell[9010, 256, 260, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[9273, 263, 78, 1, 70, "IndentedText",
      CellTags->"b:6.0.2"],
    Cell[9354, 266, 100, 1, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[9457, 269, 176, 5, 70, "IndentedText",
      CellTags->"b:6.0.2"],
    Cell[9636, 276, 330, 9, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[9969, 287, 117, 4, 70, "IndentedText",
      CellTags->"b:6.0.2"],
    Cell[10089, 293, 368, 9, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[10460, 304, 127, 4, 70, "IndentedText",
      CellTags->{"i:40", "b:6.0.2"}],
    Cell[10590, 310, 357, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[10950, 315, 80, 1, 70, "IndentedText",
      CellTags->"b:6.0.2"],
    Cell[11033, 318, 660, 13, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[11696, 333, 115, 4, 70, "IndentedText",
      CellTags->"b:6.0.2"],
    Cell[11814, 339, 377, 7, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[12194, 348, 81, 1, 70, "IndentedText",
      CellTags->"b:6.0.2"],
    Cell[12278, 351, 138, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.0.2"],
    Cell[12419, 356, 122, 3, 70, "Text",
      CellTags->"b:6.0.2"],
    Cell[12544, 361, 115, 1, 70, "Text",
      CellTags->"b:6.0.2"],
    Cell[12662, 364, 402, 6, 70, "Text",
      CellTags->"b:6.0.2"],
    Cell[13067, 372, 721, 9, 70, "Text",
      CellTags->"b:6.0.2"]},
  "i:5"->{
    Cell[7774, 214, 163, 5, 70, "Text",
      CellTags->{"i:5", "b:6.0.2"}]},
  "i:40"->{
    Cell[10460, 304, 127, 4, 70, "IndentedText",
      CellTags->{"i:40", "b:6.0.2"}]},
  "c:5"->{
    Cell[13825, 386, 153, 4, 70, "Subsection",
      CellTags->{"c:5", "i:7", "b:6.0.3"}]},
  "i:7"->{
    Cell[13825, 386, 153, 4, 70, "Subsection",
      CellTags->{"c:5", "i:7", "b:6.0.3"}]},
  "b:6.0.3"->{
    Cell[13825, 386, 153, 4, 70, "Subsection",
      CellTags->{"c:5", "i:7", "b:6.0.3"}],
    Cell[13981, 392, 621, 12, 70, "Text",
      CellTags->"b:6.0.3"],
    Cell[14605, 406, 202, 8, 70, "Text",
      CellTags->"b:6.0.3"],
    Cell[14810, 416, 220, 7, 70, "Subsubsubsection",
      CellTags->"b:6.0.3"],
    Cell[15033, 425, 406, 9, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->"b:6.0.3"],
    Cell[15442, 436, 207, 4, 70, "ListNote",
      CellTags->"b:6.0.3"],
    Cell[15652, 442, 266, 7, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[15921, 451, 143, 5, 70, "ListNote",
      CellTags->"b:6.0.3"],
    Cell[16067, 458, 65, 1, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[16135, 461, 84, 1, 70, "ListNote",
      CellTags->"b:6.0.3"],
    Cell[16222, 464, 564, 1, 70, "ListNoteBox",
      CellTags->"b:6.0.3"],
    Cell[16789, 467, 373, 6, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[17165, 475, 151, 1, 70, "ListNoteBox",
      CellTags->"b:6.0.3"],
    Cell[17319, 478, 173, 1, 70, "ListNoteBox",
      CellTags->"b:6.0.3"],
    Cell[17876, 489, 463, 12, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[18342, 503, 169, 1, 70, "ListNoteBox",
      CellTags->"b:6.0.3"],
    Cell[18514, 506, 378, 7, 70, "ListNote",
      CellTags->"b:6.0.3"],
    Cell[18895, 515, 235, 3, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[19133, 520, 164, 1, 70, "ListNoteBox",
      CellTags->"b:6.0.3"],
    Cell[19300, 523, 615, 11, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[19918, 536, 189, 1, 70, "ListNoteBox",
      CellTags->"b:6.0.3"],
    Cell[20110, 539, 289, 7, 70, "ListNote",
      CellTags->"b:6.0.3"],
    Cell[20402, 548, 414, 11, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[20819, 561, 571, 1, 70, "ListNoteBox",
      CellTags->"b:6.0.3"],
    Cell[21393, 564, 542, 8, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[21938, 574, 552, 5, 70, "ListNoteBox",
      CellTags->"b:6.0.3"],
    Cell[22493, 581, 224, 3, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[22720, 586, 200, 1, 70, "ListNoteBox",
      CellTags->"b:6.0.3"],
    Cell[22923, 589, 232, 6, 70, "ItemizedList",
      CellTags->"b:6.0.3"],
    Cell[23158, 597, 240, 1, 70, "ListNoteBox",
      CellTags->"b:6.0.3"]},
  "b:3.1"->{
    Cell[17495, 481, 169, 3, 70, "ItemizedList",
      CellTags->"b:3.1"],
    Cell[17667, 486, 206, 1, 70, "ListNoteBox",
      CellTags->"b:3.1"]},
  "c:6"->{
    Cell[23447, 604, 87, 1, 35, "Section",
      CellTags->{"c:6", "i:10", "b:6.1.2"}]},
  "i:10"->{
    Cell[23447, 604, 87, 1, 35, "Section",
      CellTags->{"c:6", "i:10", "b:6.1.2"}]},
  "b:6.1.2"->{
    Cell[23447, 604, 87, 1, 35, "Section",
      CellTags->{"c:6", "i:10", "b:6.1.2"}],
    Cell[23537, 607, 350, 6, 70, "Text",
      CellTags->"b:6.1.2"],
    Cell[23890, 615, 313, 8, 70, "Text",
      CellTags->"b:6.1.2"],
    Cell[29734, 792, 643, 13, 70, "Text",
      CellTags->"b:6.1.2"]},
  "c:7"->{
    Cell[24228, 627, 142, 5, 70, "Subsection",
      CellTags->{"c:7", "i:9", "b:6.1.0"}]},
  "i:9"->{
    Cell[24228, 627, 142, 5, 70, "Subsection",
      CellTags->{"c:7", "i:9", "b:6.1.0"}]},
  "b:6.1.0"->{
    Cell[24228, 627, 142, 5, 70, "Subsection",
      CellTags->{"c:7", "i:9", "b:6.1.0"}],
    Cell[24373, 634, 283, 7, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->"b:6.1.0"],
    Cell[24659, 643, 81, 1, 70, "ListNoteBox",
      CellTags->"b:6.1.0"],
    Cell[24743, 646, 349, 8, 70, "ItemizedList",
      CellTags->"b:6.1.0"],
    Cell[25095, 656, 135, 1, 70, "ListNoteBox",
      CellTags->"b:6.1.0"],
    Cell[25233, 659, 222, 8, 70, "ItemizedList",
      CellTags->"b:6.1.0"],
    Cell[25458, 669, 594, 14, 70, "Text",
      CellTags->{"i:11", "b:6.1.0"}]},
  "i:11"->{
    Cell[25458, 669, 594, 14, 70, "Text",
      CellTags->{"i:11", "b:6.1.0"}]},
  "c:8"->{
    Cell[26089, 688, 145, 5, 70, "Subsection",
      CellTags->{"c:8", "i:8", "b:6.1.1"}]},
  "i:8"->{
    Cell[26089, 688, 145, 5, 70, "Subsection",
      CellTags->{"c:8", "i:8", "b:6.1.1"}]},
  "b:6.1.1"->{
    Cell[26089, 688, 145, 5, 70, "Subsection",
      CellTags->{"c:8", "i:8", "b:6.1.1"}],
    Cell[26237, 695, 377, 10, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->"b:6.1.1"],
    Cell[26617, 707, 150, 3, 70, "ListNote",
      CellTags->"b:6.1.1"],
    Cell[26770, 712, 237, 7, 70, "ItemizedList",
      CellTags->"b:6.1.1"],
    Cell[27010, 721, 463, 13, 70, "ListNote",
      CellTags->"b:6.1.1"],
    Cell[27476, 736, 293, 3, 70, "ListNote",
      CellTags->"b:6.1.1"],
    Cell[27772, 741, 803, 18, 70, "ItemizedList",
      CellTags->"b:6.1.1"],
    Cell[28578, 761, 290, 11, 70, "ItemizedList",
      CellTags->"b:6.1.1"],
    Cell[28871, 774, 860, 16, 70, "Text",
      CellTags->{"i:12", "b:6.1.1"}]},
  "i:12"->{
    Cell[28871, 774, 860, 16, 70, "Text",
      CellTags->{"i:12", "b:6.1.1"}]},
  "c:9"->{
    Cell[30426, 811, 171, 2, 35, "Section",
      CellTags->{"c:9", "b:6.2"}]},
  "b:6.2"->{
    Cell[30426, 811, 171, 2, 35, "Section",
      CellTags->{"c:9", "b:6.2"}],
    Cell[30622, 817, 165, 2, 70, "Subsubsection",
      CellTags->{"c:10", "i:14", "b:6.2"}],
    Cell[30790, 821, 391, 9, 70, "Text",
      CellTags->"b:6.2"],
    Cell[31184, 832, 174, 2, 70, "Subsubsubsection",
      CellTags->"b:6.2"],
    Cell[31361, 836, 210, 5, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[31574, 843, 224, 4, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[31801, 849, 178, 2, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[31982, 853, 336, 6, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[32321, 861, 177, 2, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[32501, 865, 511, 14, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[33015, 881, 175, 2, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[33193, 885, 218, 4, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[33414, 891, 209, 5, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[33626, 898, 525, 10, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[34154, 910, 208, 5, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[34365, 917, 201, 2, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[34569, 921, 172, 2, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[34744, 925, 198, 2, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[34979, 932, 173, 2, 70, "Subsubsection",
      CellTags->{"c:11", "i:15", "b:6.2"}],
    Cell[35155, 936, 360, 10, 70, "Text",
      CellTags->"b:6.2"],
    Cell[35518, 948, 77, 1, 70, "Subsubsubsection",
      CellTags->"b:6.2"],
    Cell[35598, 951, 81, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[35682, 954, 326, 10, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[36011, 966, 91, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[36105, 969, 233, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[36341, 974, 76, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[36420, 977, 135, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[36558, 982, 82, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[36643, 985, 377, 9, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[37023, 996, 81, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[37107, 999, 132, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[37242, 1004, 106, 4, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[37351, 1010, 315, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[37669, 1017, 83, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[37755, 1020, 319, 6, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[38077, 1028, 76, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[38156, 1031, 120, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[38279, 1036, 202, 2, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[38484, 1040, 240, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[38727, 1047, 80, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[38810, 1050, 455, 12, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[39268, 1064, 86, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[39357, 1067, 108, 1, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[39468, 1070, 86, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[39557, 1073, 163, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[39723, 1080, 88, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[39814, 1083, 532, 12, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[40349, 1097, 124, 4, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[40476, 1103, 193, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[40672, 1110, 124, 4, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[40799, 1116, 172, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[40974, 1123, 120, 4, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[41097, 1129, 240, 7, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[41340, 1138, 80, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[41423, 1141, 608, 9, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[42034, 1152, 111, 4, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[42148, 1158, 106, 1, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[42257, 1161, 89, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[42349, 1164, 331, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[42683, 1171, 119, 4, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[42805, 1177, 309, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[43117, 1182, 119, 4, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[43239, 1188, 305, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[43547, 1193, 126, 4, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[43676, 1199, 171, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[43850, 1206, 84, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[43937, 1209, 309, 7, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[44249, 1218, 116, 4, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[44368, 1224, 258, 8, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[44629, 1234, 79, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[44711, 1237, 123, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[44837, 1242, 85, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[44925, 1245, 223, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[45151, 1250, 86, 1, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[45240, 1253, 428, 10, 70, "ItemizedTextNote",
      CellTags->"b:6.2"],
    Cell[45671, 1265, 180, 5, 70, "IndentedText",
      CellTags->"b:6.2"],
    Cell[45854, 1272, 244, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.2"]},
  "c:10"->{
    Cell[30622, 817, 165, 2, 70, "Subsubsection",
      CellTags->{"c:10", "i:14", "b:6.2"}]},
  "i:14"->{
    Cell[30622, 817, 165, 2, 70, "Subsubsection",
      CellTags->{"c:10", "i:14", "b:6.2"}]},
  "c:11"->{
    Cell[34979, 932, 173, 2, 70, "Subsubsection",
      CellTags->{"c:11", "i:15", "b:6.2"}]},
  "i:15"->{
    Cell[34979, 932, 173, 2, 70, "Subsubsection",
      CellTags->{"c:11", "i:15", "b:6.2"}]},
  "c:12"->{
    Cell[46147, 1283, 236, 6, 35, "Section",
      CellTags->{"c:12", "i:18", "b:6.3"}]},
  "i:18"->{
    Cell[46147, 1283, 236, 6, 35, "Section",
      CellTags->{"c:12", "i:18", "b:6.3"}]},
  "b:6.3"->{
    Cell[46147, 1283, 236, 6, 35, "Section",
      CellTags->{"c:12", "i:18", "b:6.3"}],
    Cell[46386, 1291, 494, 10, 70, "Text",
      CellTags->{"i:20", "b:6.3"}],
    Cell[46883, 1303, 549, 10, 70, "BulletedList",
      CellTags->"b:6.3"],
    Cell[47435, 1315, 624, 10, 70, "BulletedList",
      CellTags->"b:6.3"],
    Cell[48062, 1327, 310, 8, 70, "Text",
      CellTags->"b:6.3"],
    Cell[48375, 1337, 569, 15, 70, "Text",
      CellTags->"b:6.3"],
    Cell[48969, 1356, 167, 2, 70, "Subsubsection",
      CellTags->{"c:13", "i:21", "b:6.3"}],
    Cell[49139, 1360, 480, 10, 70, "Text",
      CellTags->"b:6.3"],
    Cell[49622, 1372, 196, 2, 70, "IndentedText",
      CellTags->"b:6.3"],
    Cell[49821, 1376, 201, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.3"],
    Cell[50025, 1381, 200, 2, 70, "IndentedText",
      CellTags->"b:6.3"],
    Cell[50228, 1385, 128, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.3"],
    Cell[50359, 1390, 95, 1, 70, "Text",
      CellTags->"b:6.3"],
    Cell[50491, 1396, 73, 1, 70, "Subsubsection",
      CellTags->{"c:14", "i:19", "b:6.3"}],
    Cell[50567, 1399, 464, 9, 70, "Text",
      CellTags->"b:6.3"],
    Cell[51034, 1410, 101, 1, 70, "IndentedText",
      CellTags->"b:6.3"],
    Cell[51138, 1413, 454, 10, 70, "ItemizedTextNote",
      CellTags->"b:6.3"],
    Cell[51595, 1425, 105, 1, 70, "IndentedText",
      CellTags->"b:6.3"],
    Cell[51703, 1428, 137, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.3"],
    Cell[51843, 1433, 120, 1, 70, "IndentedText",
      CellTags->{"i:17", "b:6.3"}],
    Cell[51966, 1436, 191, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.3"],
    Cell[52160, 1441, 134, 5, 70, "IndentedText",
      CellTags->"b:6.3"],
    Cell[52297, 1448, 200, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.3"],
    Cell[52500, 1453, 94, 1, 70, "Text",
      CellTags->"b:6.3"],
    Cell[52631, 1459, 73, 1, 70, "Subsubsection",
      CellTags->{"c:15", "i:22", "b:6.3"}],
    Cell[52707, 1462, 911, 25, 70, "Text",
      CellTags->{"i:46", "b:6.3"}],
    Cell[53621, 1489, 104, 1, 70, "IndentedText",
      CellTags->"b:6.3"],
    Cell[53728, 1492, 108, 1, 70, "ItemizedTextNote",
      CellTags->"b:6.3"],
    Cell[53839, 1495, 126, 1, 70, "IndentedText",
      CellTags->"b:6.3"],
    Cell[53968, 1498, 119, 3, 70, "ItemizedTextNote",
      CellTags->"b:6.3"],
    Cell[54090, 1503, 170, 2, 70, "IndentedText",
      CellTags->"b:6.3"],
    Cell[54263, 1507, 205, 5, 70, "ItemizedTextNote",
      CellTags->"b:6.3"]},
  "i:20"->{
    Cell[46386, 1291, 494, 10, 70, "Text",
      CellTags->{"i:20", "b:6.3"}]},
  "c:13"->{
    Cell[48969, 1356, 167, 2, 70, "Subsubsection",
      CellTags->{"c:13", "i:21", "b:6.3"}]},
  "i:21"->{
    Cell[48969, 1356, 167, 2, 70, "Subsubsection",
      CellTags->{"c:13", "i:21", "b:6.3"}]},
  "c:14"->{
    Cell[50491, 1396, 73, 1, 70, "Subsubsection",
      CellTags->{"c:14", "i:19", "b:6.3"}]},
  "i:19"->{
    Cell[50491, 1396, 73, 1, 70, "Subsubsection",
      CellTags->{"c:14", "i:19", "b:6.3"}]},
  "i:17"->{
    Cell[51843, 1433, 120, 1, 70, "IndentedText",
      CellTags->{"i:17", "b:6.3"}]},
  "c:15"->{
    Cell[52631, 1459, 73, 1, 70, "Subsubsection",
      CellTags->{"c:15", "i:22", "b:6.3"}]},
  "i:22"->{
    Cell[52631, 1459, 73, 1, 70, "Subsubsection",
      CellTags->{"c:15", "i:22", "b:6.3"}]},
  "i:46"->{
    Cell[52707, 1462, 911, 25, 70, "Text",
      CellTags->{"i:46", "b:6.3"}]},
  "c:16"->{
    Cell[54517, 1518, 89, 1, 35, "Section",
      CellTags->{"c:16", "i:23", "b:6.4"}]},
  "i:23"->{
    Cell[54517, 1518, 89, 1, 35, "Section",
      CellTags->{"c:16", "i:23", "b:6.4"}]},
  "b:6.4"->{
    Cell[54517, 1518, 89, 1, 35, "Section",
      CellTags->{"c:16", "i:23", "b:6.4"}],
    Cell[54609, 1521, 702, 16, 70, "Text",
      CellTags->"b:6.4"],
    Cell[55314, 1539, 325, 11, 70, "Text",
      CellTags->"b:6.4"],
    Cell[55642, 1552, 195, 2, 70, "Subsubsubsection",
      CellTags->"b:6.4"],
    Cell[55840, 1556, 412, 9, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->"b:6.4"],
    Cell[56255, 1567, 125, 6, 70, "ItemizedList",
      CellTags->"b:6.4"],
    Cell[56383, 1575, 211, 7, 70, "ItemizedList",
      CellTags->"b:6.4"],
    Cell[56597, 1584, 273, 7, 70, "Text",
      CellTags->"b:6.4"],
    Cell[56873, 1593, 95, 1, 70, "Subsubsubsection",
      CellTags->"b:6.4"],
    Cell[56971, 1596, 278, 8, 70, "ItemizedList",
      CounterAssignments->{{"ItemizedList", 0}},
      CellTags->"b:6.4"],
    Cell[57252, 1606, 345, 7, 70, "ItemizedList",
      CellTags->"b:6.4"],
    Cell[57600, 1615, 422, 10, 70, "ItemizedList",
      CellTags->"b:6.4"],
    Cell[58025, 1627, 304, 11, 70, "ItemizedList",
      CellTags->"b:6.4"],
    Cell[58332, 1640, 245, 6, 70, "Text",
      CellTags->"b:6.4"]},
  "c:17"->{
    Cell[58614, 1651, 67, 1, 35, "Section",
      CellTags->{"c:17", "i:28", "b:6.5"}]},
  "i:28"->{
    Cell[58614, 1651, 67, 1, 35, "Section",
      CellTags->{"c:17", "i:28", "b:6.5"}]},
  "b:6.5"->{
    Cell[58614, 1651, 67, 1, 35, "Section",
      CellTags->{"c:17", "i:28", "b:6.5"}],
    Cell[58684, 1654, 254, 6, 70, "Text",
      CellTags->"b:6.5"],
    Cell[58963, 1664, 76, 1, 70, "Subsubsection",
      CellTags->{"c:18", "i:27", "b:6.5"}],
    Cell[59042, 1667, 511, 5, 70, "Text",
      CellTags->{"i:27", "b:6.5"}],
    Cell[59590, 1677, 178, 2, 70, "Subsubsection",
      CellTags->{"c:19", "i:26", "b:6.5"}],
    Cell[59771, 1681, 759, 16, 70, "Text",
      CellTags->{"i:35", "b:6.5"}],
    Cell[60533, 1699, 146, 1, 70, "Text",
      CellTags->"b:6.5"],
    Cell[60682, 1702, 165, 5, 70, "Text",
      CellTags->"b:6.5"],
    Cell[60850, 1709, 509, 11, 70, "Text",
      CellTags->"b:6.5"],
    Cell[61362, 1722, 825, 9, 70, "Text",
      CellTags->"b:6.5"],
    Cell[62224, 1736, 76, 1, 70, "Subsubsection",
      CellTags->{"c:20", "i:29", "b:6.5"}],
    Cell[62303, 1739, 580, 12, 70, "Text",
      CellTags->"b:6.5"],
    Cell[62920, 1756, 82, 1, 70, "Subsubsection",
      CellTags->{"c:21", "i:31", "b:6.5"}],
    Cell[63005, 1759, 654, 12, 70, "Text",
      CellTags->{"i:25", "b:6.5"}],
    Cell[63696, 1776, 179, 2, 70, "Subsubsection",
      CellTags->{"c:22", "i:32", "b:6.5"}],
    Cell[63878, 1780, 854, 13, 70, "Text",
      CellTags->{"i:24", "b:6.5"}],
    Cell[64769, 1798, 172, 2, 70, "Subsubsection",
      CellTags->{"c:23", "i:30", "b:6.5"}],
    Cell[64944, 1802, 781, 20, 70, "Text",
      CellTags->"b:6.5"]},
  "c:18"->{
    Cell[58963, 1664, 76, 1, 70, "Subsubsection",
      CellTags->{"c:18", "i:27", "b:6.5"}]},
  "i:27"->{
    Cell[58963, 1664, 76, 1, 70, "Subsubsection",
      CellTags->{"c:18", "i:27", "b:6.5"}],
    Cell[59042, 1667, 511, 5, 70, "Text",
      CellTags->{"i:27", "b:6.5"}]},
  "c:19"->{
    Cell[59590, 1677, 178, 2, 70, "Subsubsection",
      CellTags->{"c:19", "i:26", "b:6.5"}]},
  "i:26"->{
    Cell[59590, 1677, 178, 2, 70, "Subsubsection",
      CellTags->{"c:19", "i:26", "b:6.5"}]},
  "i:35"->{
    Cell[59771, 1681, 759, 16, 70, "Text",
      CellTags->{"i:35", "b:6.5"}]},
  "c:20"->{
    Cell[62224, 1736, 76, 1, 70, "Subsubsection",
      CellTags->{"c:20", "i:29", "b:6.5"}]},
  "i:29"->{
    Cell[62224, 1736, 76, 1, 70, "Subsubsection",
      CellTags->{"c:20", "i:29", "b:6.5"}]},
  "c:21"->{
    Cell[62920, 1756, 82, 1, 70, "Subsubsection",
      CellTags->{"c:21", "i:31", "b:6.5"}]},
  "i:31"->{
    Cell[62920, 1756, 82, 1, 70, "Subsubsection",
      CellTags->{"c:21", "i:31", "b:6.5"}]},
  "i:25"->{
    Cell[63005, 1759, 654, 12, 70, "Text",
      CellTags->{"i:25", "b:6.5"}]},
  "c:22"->{
    Cell[63696, 1776, 179, 2, 70, "Subsubsection",
      CellTags->{"c:22", "i:32", "b:6.5"}]},
  "i:32"->{
    Cell[63696, 1776, 179, 2, 70, "Subsubsection",
      CellTags->{"c:22", "i:32", "b:6.5"}]},
  "i:24"->{
    Cell[63878, 1780, 854, 13, 70, "Text",
      CellTags->{"i:24", "b:6.5"}]},
  "c:23"->{
    Cell[64769, 1798, 172, 2, 70, "Subsubsection",
      CellTags->{"c:23", "i:30", "b:6.5"}]},
  "i:30"->{
    Cell[64769, 1798, 172, 2, 70, "Subsubsection",
      CellTags->{"c:23", "i:30", "b:6.5"}]},
  "c:24"->{
    Cell[65774, 1828, 198, 2, 35, "Section",
      CellTags->{"c:24", "i:37", "b:6.6"}]},
  "i:37"->{
    Cell[65774, 1828, 198, 2, 35, "Section",
      CellTags->{"c:24", "i:37", "b:6.6"}]},
  "b:6.6"->{
    Cell[65774, 1828, 198, 2, 35, "Section",
      CellTags->{"c:24", "i:37", "b:6.6"}],
    Cell[65975, 1832, 543, 17, 70, "Text",
      CellTags->"b:6.6"],
    Cell[66543, 1853, 66, 1, 70, "Subsubsection",
      CellTags->{"c:25", "i:43", "b:6.6"}],
    Cell[66612, 1856, 419, 9, 70, "BulletedList",
      CellTags->"b:6.6"],
    Cell[67034, 1867, 555, 13, 70, "BulletedList",
      CellTags->{"i:41", "b:6.6"}],
    Cell[67626, 1885, 76, 1, 70, "Subsubsection",
      CellTags->{"c:26", "i:36", "b:6.6"}],
    Cell[67705, 1888, 119, 3, 70, "Text",
      CellTags->"b:6.6"],
    Cell[67861, 1896, 170, 2, 70, "Subsubsection",
      CellTags->{"c:27", "i:38", "b:6.6"}],
    Cell[68034, 1900, 1044, 27, 70, "Text",
      CellTags->"b:6.6"],
    Cell[69081, 1929, 554, 9, 70, "Text",
      CellTags->"b:6.6"],
    Cell[69672, 1943, 69, 1, 70, "Subsubsection",
      CellTags->{"c:28", "i:39", "b:6.6"}],
    Cell[69744, 1946, 417, 13, 70, "Text",
      CellTags->"b:6.6"],
    Cell[70198, 1964, 182, 2, 70, "Subsubsection",
      CellTags->{"c:29", "i:44", "b:6.6"}],
    Cell[70383, 1968, 493, 10, 70, "Text",
      CellTags->"b:6.6"],
    Cell[70913, 1983, 70, 1, 70, "Subsubsection",
      CellTags->{"c:30", "i:33", "b:6.6"}],
    Cell[70986, 1986, 950, 15, 70, "Text",
      CellTags->"b:6.6"],
    Cell[71973, 2006, 70, 1, 70, "Subsubsection",
      CellTags->{"c:31", "i:34", "b:6.6"}],
    Cell[72046, 2009, 155, 3, 70, "BulletedList",
      CellTags->"b:6.6"],
    Cell[72204, 2014, 374, 5, 70, "BulletedList",
      CellTags->"b:6.6"],
    Cell[72581, 2021, 425, 10, 70, "BulletedList",
      CellTags->"b:6.6"],
    Cell[73043, 2036, 76, 1, 70, "Subsubsection",
      CellTags->{"c:32", "b:6.6", "i:47"}],
    Cell[73122, 2039, 507, 12, 70, "BulletedList",
      CellTags->"b:6.6"],
    Cell[73632, 2053, 532, 9, 70, "BulletedList",
      CellTags->"b:6.6"],
    Cell[74201, 2067, 170, 2, 70, "Subsubsection",
      CellTags->{"c:33", "b:6.6"}],
    Cell[74374, 2071, 1010, 20, 70, "Text",
      CellTags->"b:6.6"]},
  "c:25"->{
    Cell[66543, 1853, 66, 1, 70, "Subsubsection",
      CellTags->{"c:25", "i:43", "b:6.6"}]},
  "i:43"->{
    Cell[66543, 1853, 66, 1, 70, "Subsubsection",
      CellTags->{"c:25", "i:43", "b:6.6"}]},
  "i:41"->{
    Cell[67034, 1867, 555, 13, 70, "BulletedList",
      CellTags->{"i:41", "b:6.6"}]},
  "c:26"->{
    Cell[67626, 1885, 76, 1, 70, "Subsubsection",
      CellTags->{"c:26", "i:36", "b:6.6"}]},
  "i:36"->{
    Cell[67626, 1885, 76, 1, 70, "Subsubsection",
      CellTags->{"c:26", "i:36", "b:6.6"}]},
  "c:27"->{
    Cell[67861, 1896, 170, 2, 70, "Subsubsection",
      CellTags->{"c:27", "i:38", "b:6.6"}]},
  "i:38"->{
    Cell[67861, 1896, 170, 2, 70, "Subsubsection",
      CellTags->{"c:27", "i:38", "b:6.6"}]},
  "c:28"->{
    Cell[69672, 1943, 69, 1, 70, "Subsubsection",
      CellTags->{"c:28", "i:39", "b:6.6"}]},
  "i:39"->{
    Cell[69672, 1943, 69, 1, 70, "Subsubsection",
      CellTags->{"c:28", "i:39", "b:6.6"}]},
  "c:29"->{
    Cell[70198, 1964, 182, 2, 70, "Subsubsection",
      CellTags->{"c:29", "i:44", "b:6.6"}]},
  "i:44"->{
    Cell[70198, 1964, 182, 2, 70, "Subsubsection",
      CellTags->{"c:29", "i:44", "b:6.6"}]},
  "c:30"->{
    Cell[70913, 1983, 70, 1, 70, "Subsubsection",
      CellTags->{"c:30", "i:33", "b:6.6"}]},
  "i:33"->{
    Cell[70913, 1983, 70, 1, 70, "Subsubsection",
      CellTags->{"c:30", "i:33", "b:6.6"}]},
  "c:31"->{
    Cell[71973, 2006, 70, 1, 70, "Subsubsection",
      CellTags->{"c:31", "i:34", "b:6.6"}]},
  "i:34"->{
    Cell[71973, 2006, 70, 1, 70, "Subsubsection",
      CellTags->{"c:31", "i:34", "b:6.6"}]},
  "c:32"->{
    Cell[73043, 2036, 76, 1, 70, "Subsubsection",
      CellTags->{"c:32", "b:6.6", "i:47"}]},
  "i:47"->{
    Cell[73043, 2036, 76, 1, 70, "Subsubsection",
      CellTags->{"c:32", "b:6.6", "i:47"}]},
  "c:33"->{
    Cell[74201, 2067, 170, 2, 70, "Subsubsection",
      CellTags->{"c:33", "b:6.6"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 85908, 2308},
  {"b:6.0.4", 86002, 2311},
  {"i:1", 86237, 2318},
  {"c:2", 86326, 2321},
  {"i:2", 86428, 2324},
  {"b:6.0.0", 86534, 2327},
  {"i:45", 86786, 2334},
  {"c:3", 86878, 2337},
  {"i:3", 86980, 2340},
  {"b:6.0.1", 87086, 2343},
  {"c:4", 87257, 2348},
  {"i:6", 87359, 2351},
  {"b:6.0.2", 87465, 2354},
  {"i:5", 89565, 2409},
  {"i:40", 89655, 2412},
  {"c:5", 89754, 2415},
  {"i:7", 89857, 2418},
  {"b:6.0.3", 89964, 2421},
  {"b:3.1", 92311, 2483},
  {"c:6", 92472, 2488},
  {"i:10", 92573, 2491},
  {"b:6.1.2", 92677, 2494},
  {"c:7", 92985, 2503},
  {"i:9", 93088, 2506},
  {"b:6.1.0", 93195, 2509},
  {"i:11", 93810, 2525},
  {"c:8", 93902, 2528},
  {"i:8", 94005, 2531},
  {"b:6.1.1", 94112, 2534},
  {"i:12", 94876, 2554},
  {"c:9", 94968, 2557},
  {"b:6.2", 95061, 2560},
  {"c:10", 101058, 2715},
  {"i:14", 101165, 2718},
  {"c:11", 101272, 2721},
  {"i:15", 101379, 2724},
  {"c:12", 101486, 2727},
  {"i:18", 101588, 2730},
  {"b:6.3", 101691, 2733},
  {"i:20", 104211, 2798},
  {"c:13", 104303, 2801},
  {"i:21", 104411, 2804},
  {"c:14", 104519, 2807},
  {"i:19", 104626, 2810},
  {"i:17", 104733, 2813},
  {"c:15", 104832, 2816},
  {"i:22", 104939, 2819},
  {"i:46", 105046, 2822},
  {"c:16", 105138, 2825},
  {"i:23", 105239, 2828},
  {"b:6.4", 105341, 2831},
  {"c:17", 106507, 2862},
  {"i:28", 106608, 2865},
  {"b:6.5", 106710, 2868},
  {"c:18", 108172, 2905},
  {"i:27", 108279, 2908},
  {"c:19", 108464, 2913},
  {"i:26", 108572, 2916},
  {"i:35", 108680, 2919},
  {"c:20", 108772, 2922},
  {"i:29", 108879, 2925},
  {"c:21", 108986, 2928},
  {"i:31", 109093, 2931},
  {"i:25", 109200, 2934},
  {"c:22", 109292, 2937},
  {"i:32", 109400, 2940},
  {"i:24", 109508, 2943},
  {"c:23", 109600, 2946},
  {"i:30", 109708, 2949},
  {"c:24", 109816, 2952},
  {"i:37", 109918, 2955},
  {"b:6.6", 110021, 2958},
  {"c:25", 112061, 3009},
  {"i:43", 112168, 3012},
  {"i:41", 112275, 3015},
  {"c:26", 112375, 3018},
  {"i:36", 112482, 3021},
  {"c:27", 112589, 3024},
  {"i:38", 112697, 3027},
  {"c:28", 112805, 3030},
  {"i:39", 112912, 3033},
  {"c:29", 113019, 3036},
  {"i:44", 113127, 3039},
  {"c:30", 113235, 3042},
  {"i:33", 113342, 3045},
  {"c:31", 113449, 3048},
  {"i:34", 113556, 3051},
  {"c:32", 113663, 3054},
  {"i:47", 113770, 3057},
  {"c:33", 113877, 3060}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 344, 5, 118, "Chapter"],
Cell[2123, 60, 451, 5, 72, "Text"],

Cell[CellGroupData[{
Cell[2599, 69, 85, 1, 61, "Section",
  CellTags->{"c:1", "b:6.0.4"}],
Cell[2687, 72, 655, 18, 70, "Text",
  CellTags->"b:6.0.4"],
Cell[3345, 92, 792, 15, 70, "Text",
  CellTags->{"i:1", "b:6.0.4"}],

Cell[CellGroupData[{
Cell[4162, 111, 153, 5, 70, "Subsection",
  CellTags->{"c:2", "i:2", "b:6.0.0"}],
Cell[4318, 118, 620, 12, 70, "Text",
  CellTags->"b:6.0.0"],
Cell[4941, 132, 1171, 28, 70, "Text",
  CellTags->{"i:45", "b:6.0.0"}]
}, Closed]],

Cell[CellGroupData[{
Cell[6149, 165, 150, 5, 70, "Subsection",
  CellTags->{"c:3", "i:3", "b:6.0.1"}],
Cell[6302, 172, 863, 22, 70, "Text",
  CellTags->"b:6.0.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[7202, 199, 132, 3, 70, "Subsection",
  CellTags->{"c:4", "i:6", "b:6.0.2"}],
Cell[7337, 204, 434, 8, 70, "Text",
  CellTags->"b:6.0.2"],
Cell[7774, 214, 163, 5, 70, "Text",
  CellTags->{"i:5", "b:6.0.2"}],
Cell[7940, 221, 78, 1, 70, "IndentedText",
  CellTags->"b:6.0.2"],
Cell[8021, 224, 251, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[8275, 229, 118, 4, 70, "IndentedText",
  CellTags->"b:6.0.2"],
Cell[8396, 235, 495, 13, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[8894, 250, 113, 4, 70, "IndentedText",
  CellTags->"b:6.0.2"],
Cell[9010, 256, 260, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[9273, 263, 78, 1, 70, "IndentedText",
  CellTags->"b:6.0.2"],
Cell[9354, 266, 100, 1, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[9457, 269, 176, 5, 70, "IndentedText",
  CellTags->"b:6.0.2"],
Cell[9636, 276, 330, 9, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[9969, 287, 117, 4, 70, "IndentedText",
  CellTags->"b:6.0.2"],
Cell[10089, 293, 368, 9, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[10460, 304, 127, 4, 70, "IndentedText",
  CellTags->{"i:40", "b:6.0.2"}],
Cell[10590, 310, 357, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[10950, 315, 80, 1, 70, "IndentedText",
  CellTags->"b:6.0.2"],
Cell[11033, 318, 660, 13, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[11696, 333, 115, 4, 70, "IndentedText",
  CellTags->"b:6.0.2"],
Cell[11814, 339, 377, 7, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[12194, 348, 81, 1, 70, "IndentedText",
  CellTags->"b:6.0.2"],
Cell[12278, 351, 138, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.0.2"],
Cell[12419, 356, 122, 3, 70, "Text",
  CellTags->"b:6.0.2"],
Cell[12544, 361, 115, 1, 70, "Text",
  CellTags->"b:6.0.2"],
Cell[12662, 364, 402, 6, 70, "Text",
  CellTags->"b:6.0.2"],
Cell[13067, 372, 721, 9, 70, "Text",
  CellTags->"b:6.0.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[13825, 386, 153, 4, 70, "Subsection",
  CellTags->{"c:5", "i:7", "b:6.0.3"}],
Cell[13981, 392, 621, 12, 70, "Text",
  CellTags->"b:6.0.3"],
Cell[14605, 406, 202, 8, 70, "Text",
  CellTags->"b:6.0.3"],
Cell[14810, 416, 220, 7, 70, "Subsubsubsection",
  CellTags->"b:6.0.3"],
Cell[15033, 425, 406, 9, 70, "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.0.3"],
Cell[15442, 436, 207, 4, 70, "ListNote",
  CellTags->"b:6.0.3"],
Cell[15652, 442, 266, 7, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[15921, 451, 143, 5, 70, "ListNote",
  CellTags->"b:6.0.3"],
Cell[16067, 458, 65, 1, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[16135, 461, 84, 1, 70, "ListNote",
  CellTags->"b:6.0.3"],
Cell[16222, 464, 564, 1, 70, "ListNoteBox",
  CellTags->"b:6.0.3"],
Cell[16789, 467, 373, 6, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[17165, 475, 151, 1, 70, "ListNoteBox",
  CellTags->"b:6.0.3"],
Cell[17319, 478, 173, 1, 70, "ListNoteBox",
  CellTags->"b:6.0.3"],
Cell[17495, 481, 169, 3, 70, "ItemizedList",
  CellTags->"b:3.1"],
Cell[17667, 486, 206, 1, 70, "ListNoteBox",
  CellTags->"b:3.1"],
Cell[17876, 489, 463, 12, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[18342, 503, 169, 1, 70, "ListNoteBox",
  CellTags->"b:6.0.3"],
Cell[18514, 506, 378, 7, 70, "ListNote",
  CellTags->"b:6.0.3"],
Cell[18895, 515, 235, 3, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[19133, 520, 164, 1, 70, "ListNoteBox",
  CellTags->"b:6.0.3"],
Cell[19300, 523, 615, 11, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[19918, 536, 189, 1, 70, "ListNoteBox",
  CellTags->"b:6.0.3"],
Cell[20110, 539, 289, 7, 70, "ListNote",
  CellTags->"b:6.0.3"],
Cell[20402, 548, 414, 11, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[20819, 561, 571, 1, 70, "ListNoteBox",
  CellTags->"b:6.0.3"],
Cell[21393, 564, 542, 8, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[21938, 574, 552, 5, 70, "ListNoteBox",
  CellTags->"b:6.0.3"],
Cell[22493, 581, 224, 3, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[22720, 586, 200, 1, 70, "ListNoteBox",
  CellTags->"b:6.0.3"],
Cell[22923, 589, 232, 6, 70, "ItemizedList",
  CellTags->"b:6.0.3"],
Cell[23158, 597, 240, 1, 70, "ListNoteBox",
  CellTags->"b:6.0.3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23447, 604, 87, 1, 35, "Section",
  CellTags->{"c:6", "i:10", "b:6.1.2"}],
Cell[23537, 607, 350, 6, 70, "Text",
  CellTags->"b:6.1.2"],
Cell[23890, 615, 313, 8, 70, "Text",
  CellTags->"b:6.1.2"],

Cell[CellGroupData[{
Cell[24228, 627, 142, 5, 70, "Subsection",
  CellTags->{"c:7", "i:9", "b:6.1.0"}],
Cell[24373, 634, 283, 7, 70, "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.1.0"],
Cell[24659, 643, 81, 1, 70, "ListNoteBox",
  CellTags->"b:6.1.0"],
Cell[24743, 646, 349, 8, 70, "ItemizedList",
  CellTags->"b:6.1.0"],
Cell[25095, 656, 135, 1, 70, "ListNoteBox",
  CellTags->"b:6.1.0"],
Cell[25233, 659, 222, 8, 70, "ItemizedList",
  CellTags->"b:6.1.0"],
Cell[25458, 669, 594, 14, 70, "Text",
  CellTags->{"i:11", "b:6.1.0"}]
}, Closed]],

Cell[CellGroupData[{
Cell[26089, 688, 145, 5, 70, "Subsection",
  CellTags->{"c:8", "i:8", "b:6.1.1"}],
Cell[26237, 695, 377, 10, 70, "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.1.1"],
Cell[26617, 707, 150, 3, 70, "ListNote",
  CellTags->"b:6.1.1"],
Cell[26770, 712, 237, 7, 70, "ItemizedList",
  CellTags->"b:6.1.1"],
Cell[27010, 721, 463, 13, 70, "ListNote",
  CellTags->"b:6.1.1"],
Cell[27476, 736, 293, 3, 70, "ListNote",
  CellTags->"b:6.1.1"],
Cell[27772, 741, 803, 18, 70, "ItemizedList",
  CellTags->"b:6.1.1"],
Cell[28578, 761, 290, 11, 70, "ItemizedList",
  CellTags->"b:6.1.1"],
Cell[28871, 774, 860, 16, 70, "Text",
  CellTags->{"i:12", "b:6.1.1"}],
Cell[29734, 792, 643, 13, 70, "Text",
  CellTags->"b:6.1.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[30426, 811, 171, 2, 35, "Section",
  CellTags->{"c:9", "b:6.2"}],

Cell[CellGroupData[{
Cell[30622, 817, 165, 2, 70, "Subsubsection",
  CellTags->{"c:10", "i:14", "b:6.2"}],
Cell[30790, 821, 391, 9, 70, "Text",
  CellTags->"b:6.2"],
Cell[31184, 832, 174, 2, 70, "Subsubsubsection",
  CellTags->"b:6.2"],
Cell[31361, 836, 210, 5, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[31574, 843, 224, 4, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[31801, 849, 178, 2, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[31982, 853, 336, 6, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[32321, 861, 177, 2, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[32501, 865, 511, 14, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[33015, 881, 175, 2, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[33193, 885, 218, 4, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[33414, 891, 209, 5, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[33626, 898, 525, 10, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[34154, 910, 208, 5, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[34365, 917, 201, 2, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[34569, 921, 172, 2, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[34744, 925, 198, 2, 70, "ItemizedTextNote",
  CellTags->"b:6.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[34979, 932, 173, 2, 70, "Subsubsection",
  CellTags->{"c:11", "i:15", "b:6.2"}],
Cell[35155, 936, 360, 10, 70, "Text",
  CellTags->"b:6.2"],
Cell[35518, 948, 77, 1, 70, "Subsubsubsection",
  CellTags->"b:6.2"],
Cell[35598, 951, 81, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[35682, 954, 326, 10, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[36011, 966, 91, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[36105, 969, 233, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[36341, 974, 76, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[36420, 977, 135, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[36558, 982, 82, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[36643, 985, 377, 9, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[37023, 996, 81, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[37107, 999, 132, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[37242, 1004, 106, 4, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[37351, 1010, 315, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[37669, 1017, 83, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[37755, 1020, 319, 6, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[38077, 1028, 76, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[38156, 1031, 120, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[38279, 1036, 202, 2, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[38484, 1040, 240, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[38727, 1047, 80, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[38810, 1050, 455, 12, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[39268, 1064, 86, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[39357, 1067, 108, 1, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[39468, 1070, 86, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[39557, 1073, 163, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[39723, 1080, 88, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[39814, 1083, 532, 12, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[40349, 1097, 124, 4, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[40476, 1103, 193, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[40672, 1110, 124, 4, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[40799, 1116, 172, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[40974, 1123, 120, 4, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[41097, 1129, 240, 7, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[41340, 1138, 80, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[41423, 1141, 608, 9, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[42034, 1152, 111, 4, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[42148, 1158, 106, 1, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[42257, 1161, 89, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[42349, 1164, 331, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[42683, 1171, 119, 4, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[42805, 1177, 309, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[43117, 1182, 119, 4, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[43239, 1188, 305, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[43547, 1193, 126, 4, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[43676, 1199, 171, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[43850, 1206, 84, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[43937, 1209, 309, 7, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[44249, 1218, 116, 4, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[44368, 1224, 258, 8, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[44629, 1234, 79, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[44711, 1237, 123, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[44837, 1242, 85, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[44925, 1245, 223, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[45151, 1250, 86, 1, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[45240, 1253, 428, 10, 70, "ItemizedTextNote",
  CellTags->"b:6.2"],
Cell[45671, 1265, 180, 5, 70, "IndentedText",
  CellTags->"b:6.2"],
Cell[45854, 1272, 244, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[46147, 1283, 236, 6, 35, "Section",
  CellTags->{"c:12", "i:18", "b:6.3"}],
Cell[46386, 1291, 494, 10, 70, "Text",
  CellTags->{"i:20", "b:6.3"}],
Cell[46883, 1303, 549, 10, 70, "BulletedList",
  CellTags->"b:6.3"],
Cell[47435, 1315, 624, 10, 70, "BulletedList",
  CellTags->"b:6.3"],
Cell[48062, 1327, 310, 8, 70, "Text",
  CellTags->"b:6.3"],
Cell[48375, 1337, 569, 15, 70, "Text",
  CellTags->"b:6.3"],

Cell[CellGroupData[{
Cell[48969, 1356, 167, 2, 70, "Subsubsection",
  CellTags->{"c:13", "i:21", "b:6.3"}],
Cell[49139, 1360, 480, 10, 70, "Text",
  CellTags->"b:6.3"],
Cell[49622, 1372, 196, 2, 70, "IndentedText",
  CellTags->"b:6.3"],
Cell[49821, 1376, 201, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.3"],
Cell[50025, 1381, 200, 2, 70, "IndentedText",
  CellTags->"b:6.3"],
Cell[50228, 1385, 128, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.3"],
Cell[50359, 1390, 95, 1, 70, "Text",
  CellTags->"b:6.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[50491, 1396, 73, 1, 70, "Subsubsection",
  CellTags->{"c:14", "i:19", "b:6.3"}],
Cell[50567, 1399, 464, 9, 70, "Text",
  CellTags->"b:6.3"],
Cell[51034, 1410, 101, 1, 70, "IndentedText",
  CellTags->"b:6.3"],
Cell[51138, 1413, 454, 10, 70, "ItemizedTextNote",
  CellTags->"b:6.3"],
Cell[51595, 1425, 105, 1, 70, "IndentedText",
  CellTags->"b:6.3"],
Cell[51703, 1428, 137, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.3"],
Cell[51843, 1433, 120, 1, 70, "IndentedText",
  CellTags->{"i:17", "b:6.3"}],
Cell[51966, 1436, 191, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.3"],
Cell[52160, 1441, 134, 5, 70, "IndentedText",
  CellTags->"b:6.3"],
Cell[52297, 1448, 200, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.3"],
Cell[52500, 1453, 94, 1, 70, "Text",
  CellTags->"b:6.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[52631, 1459, 73, 1, 70, "Subsubsection",
  CellTags->{"c:15", "i:22", "b:6.3"}],
Cell[52707, 1462, 911, 25, 70, "Text",
  CellTags->{"i:46", "b:6.3"}],
Cell[53621, 1489, 104, 1, 70, "IndentedText",
  CellTags->"b:6.3"],
Cell[53728, 1492, 108, 1, 70, "ItemizedTextNote",
  CellTags->"b:6.3"],
Cell[53839, 1495, 126, 1, 70, "IndentedText",
  CellTags->"b:6.3"],
Cell[53968, 1498, 119, 3, 70, "ItemizedTextNote",
  CellTags->"b:6.3"],
Cell[54090, 1503, 170, 2, 70, "IndentedText",
  CellTags->"b:6.3"],
Cell[54263, 1507, 205, 5, 70, "ItemizedTextNote",
  CellTags->"b:6.3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[54517, 1518, 89, 1, 35, "Section",
  CellTags->{"c:16", "i:23", "b:6.4"}],
Cell[54609, 1521, 702, 16, 70, "Text",
  CellTags->"b:6.4"],
Cell[55314, 1539, 325, 11, 70, "Text",
  CellTags->"b:6.4"],
Cell[55642, 1552, 195, 2, 70, "Subsubsubsection",
  CellTags->"b:6.4"],
Cell[55840, 1556, 412, 9, 70, "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.4"],
Cell[56255, 1567, 125, 6, 70, "ItemizedList",
  CellTags->"b:6.4"],
Cell[56383, 1575, 211, 7, 70, "ItemizedList",
  CellTags->"b:6.4"],
Cell[56597, 1584, 273, 7, 70, "Text",
  CellTags->"b:6.4"],
Cell[56873, 1593, 95, 1, 70, "Subsubsubsection",
  CellTags->"b:6.4"],
Cell[56971, 1596, 278, 8, 70, "ItemizedList",
  CounterAssignments->{{"ItemizedList", 0}},
  CellTags->"b:6.4"],
Cell[57252, 1606, 345, 7, 70, "ItemizedList",
  CellTags->"b:6.4"],
Cell[57600, 1615, 422, 10, 70, "ItemizedList",
  CellTags->"b:6.4"],
Cell[58025, 1627, 304, 11, 70, "ItemizedList",
  CellTags->"b:6.4"],
Cell[58332, 1640, 245, 6, 70, "Text",
  CellTags->"b:6.4"]
}, Closed]],

Cell[CellGroupData[{
Cell[58614, 1651, 67, 1, 35, "Section",
  CellTags->{"c:17", "i:28", "b:6.5"}],
Cell[58684, 1654, 254, 6, 70, "Text",
  CellTags->"b:6.5"],

Cell[CellGroupData[{
Cell[58963, 1664, 76, 1, 70, "Subsubsection",
  CellTags->{"c:18", "i:27", "b:6.5"}],
Cell[59042, 1667, 511, 5, 70, "Text",
  CellTags->{"i:27", "b:6.5"}]
}, Closed]],

Cell[CellGroupData[{
Cell[59590, 1677, 178, 2, 70, "Subsubsection",
  CellTags->{"c:19", "i:26", "b:6.5"}],
Cell[59771, 1681, 759, 16, 70, "Text",
  CellTags->{"i:35", "b:6.5"}],
Cell[60533, 1699, 146, 1, 70, "Text",
  CellTags->"b:6.5"],
Cell[60682, 1702, 165, 5, 70, "Text",
  CellTags->"b:6.5"],
Cell[60850, 1709, 509, 11, 70, "Text",
  CellTags->"b:6.5"],
Cell[61362, 1722, 825, 9, 70, "Text",
  CellTags->"b:6.5"]
}, Closed]],

Cell[CellGroupData[{
Cell[62224, 1736, 76, 1, 70, "Subsubsection",
  CellTags->{"c:20", "i:29", "b:6.5"}],
Cell[62303, 1739, 580, 12, 70, "Text",
  CellTags->"b:6.5"]
}, Closed]],

Cell[CellGroupData[{
Cell[62920, 1756, 82, 1, 70, "Subsubsection",
  CellTags->{"c:21", "i:31", "b:6.5"}],
Cell[63005, 1759, 654, 12, 70, "Text",
  CellTags->{"i:25", "b:6.5"}]
}, Closed]],

Cell[CellGroupData[{
Cell[63696, 1776, 179, 2, 70, "Subsubsection",
  CellTags->{"c:22", "i:32", "b:6.5"}],
Cell[63878, 1780, 854, 13, 70, "Text",
  CellTags->{"i:24", "b:6.5"}]
}, Closed]],

Cell[CellGroupData[{
Cell[64769, 1798, 172, 2, 70, "Subsubsection",
  CellTags->{"c:23", "i:30", "b:6.5"}],
Cell[64944, 1802, 781, 20, 70, "Text",
  CellTags->"b:6.5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[65774, 1828, 198, 2, 35, "Section",
  CellTags->{"c:24", "i:37", "b:6.6"}],
Cell[65975, 1832, 543, 17, 70, "Text",
  CellTags->"b:6.6"],

Cell[CellGroupData[{
Cell[66543, 1853, 66, 1, 70, "Subsubsection",
  CellTags->{"c:25", "i:43", "b:6.6"}],
Cell[66612, 1856, 419, 9, 70, "BulletedList",
  CellTags->"b:6.6"],
Cell[67034, 1867, 555, 13, 70, "BulletedList",
  CellTags->{"i:41", "b:6.6"}]
}, Closed]],

Cell[CellGroupData[{
Cell[67626, 1885, 76, 1, 70, "Subsubsection",
  CellTags->{"c:26", "i:36", "b:6.6"}],
Cell[67705, 1888, 119, 3, 70, "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[67861, 1896, 170, 2, 70, "Subsubsection",
  CellTags->{"c:27", "i:38", "b:6.6"}],
Cell[68034, 1900, 1044, 27, 70, "Text",
  CellTags->"b:6.6"],
Cell[69081, 1929, 554, 9, 70, "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[69672, 1943, 69, 1, 70, "Subsubsection",
  CellTags->{"c:28", "i:39", "b:6.6"}],
Cell[69744, 1946, 417, 13, 70, "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[70198, 1964, 182, 2, 70, "Subsubsection",
  CellTags->{"c:29", "i:44", "b:6.6"}],
Cell[70383, 1968, 493, 10, 70, "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[70913, 1983, 70, 1, 70, "Subsubsection",
  CellTags->{"c:30", "i:33", "b:6.6"}],
Cell[70986, 1986, 950, 15, 70, "Text",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[71973, 2006, 70, 1, 70, "Subsubsection",
  CellTags->{"c:31", "i:34", "b:6.6"}],
Cell[72046, 2009, 155, 3, 70, "BulletedList",
  CellTags->"b:6.6"],
Cell[72204, 2014, 374, 5, 70, "BulletedList",
  CellTags->"b:6.6"],
Cell[72581, 2021, 425, 10, 70, "BulletedList",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[73043, 2036, 76, 1, 70, "Subsubsection",
  CellTags->{"c:32", "b:6.6", "i:47"}],
Cell[73122, 2039, 507, 12, 70, "BulletedList",
  CellTags->"b:6.6"],
Cell[73632, 2053, 532, 9, 70, "BulletedList",
  CellTags->"b:6.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[74201, 2067, 170, 2, 70, "Subsubsection",
  CellTags->{"c:33", "b:6.6"}],
Cell[74374, 2071, 1010, 20, 70, "Text",
  CellTags->"b:6.6"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

