(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7890,        238]*)
(*NotebookOutlinePosition[     11411,        339]*)
(*  CellTagsIndexPosition[     11225,        328]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Appendix", "Chapter",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 2.0}, {
    Inherited, 28.0}}, CellFrameMargins -> {{0.0, .5*^2}, {8.0, 0.0}}, 
    ParagraphIndent -> -.3*^2, FontSize -> 27.0, Background -> 
    GrayLevel[ .9999847409781033]}}],

Cell[CellGroupData[{

Cell["Mounting a CD on Unix and Linux", "Section",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    Inherited, 26.0}}}},
  CellTags->{"c:1", "i:1", "b:8.0"}],

Cell[TextData[{
  "When installing ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on a Unix or Linux system, you may need to mount the CD. On some systems, \
such as Solaris and some Linux platforms, there is a daemon running in the \
background that will automatically mount the CD. For systems that do not have \
such a daemon, you must mount the CD manually. You may need ",
  StyleBox["root", "MR"],
  " privileges in order to give the ",
  StyleBox["mount", "MR"],
  " command. "
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    5.0, 5.0}}}},
  CellTags->"b:8.0"],

Cell[TextData[{
  "Following are typical ",
  StyleBox["mount", "MR"],
  " commands for various systems. The name of the device representing the CD\
\[Hyphen]ROM is different on different systems. To determine the device name, \
consult the documentation for your platform. In the following commands, the \
CD mount point (represented by ",
  StyleBox["/cdrom", "TI"],
  ") could be different for your platform. Common CD mount points are ",
  StyleBox["/cdrom", "MR"],
  " and ",
  StyleBox["/mnt/cdrom", "MR"],
  "."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    5.0, 5.0}}}},
  CellTags->{"i:3", "b:8.0"}],

Cell[BoxData[GridBox[{
        {"AIX", 
          RowBox[{"mount", "-", "r", "-", 
            RowBox[{"v", " ", 
              RowBox[{
                RowBox[{\(cdrfs\ /dev\), "/", 
                  StyleBox["device",
                    "TI"]}], 
                StyleBox["   ",
                  "TI"], "/", 
                StyleBox["cdrom",
                  "TI"]}]}]}]},
        {\(HP\ Tru64\), 
          RowBox[{"mount", "-", "r", "-", 
            RowBox[{"t", " ", 
              RowBox[{
                RowBox[{\(cdfs\ /dev\), "/", 
                  StyleBox["device",
                    "TI"]}], 
                StyleBox["   ",
                  "TI"], "/", 
                StyleBox["cdrom",
                  "TI"]}]}]}]},
        {"\[ThickSpace]", "or"},
        {"\[ThickSpace]", 
          RowBox[{"mount", "-", "orrip", "-", 
            RowBox[{"t", " ", 
              RowBox[{
                RowBox[{\(cdfs\ /dev\), "/", 
                  StyleBox["device",
                    "TI"]}], 
                StyleBox["   ",
                  "TI"], "/", 
                StyleBox["cdrom",
                  "TI"]}]}]}]},
        {\(HP - UX\), 
          RowBox[{"pfs_mount", "-", 
            RowBox[{"t", " ", 
              RowBox[{
                RowBox[{\(rrip\ /dev\), "/", 
                  StyleBox["device",
                    "TI"]}], 
                StyleBox["   ",
                  "TI"], "/", 
                StyleBox["cdrom",
                  "TI"]}]}]}]},
        {"IRIX", 
          RowBox[{"mount", "-", "r", "-", 
            RowBox[{"t", " ", 
              RowBox[{
                RowBox[{\(iso9660\ /dev\), "/", 
                  StyleBox["devices",
                    "TI"]}], 
                StyleBox["  ",
                  "TI"], "/", 
                StyleBox["cdrom",
                  "TI"]}]}]}]},
        {"Linux", 
          RowBox[{"mount", "-", "r", "-", 
            RowBox[{"t", " ", 
              RowBox[{
                RowBox[{\(iso9660\ /dev\), "/", 
                  StyleBox["device",
                    "TI"]}], 
                StyleBox["   ",
                  "TI"], "/", 
                StyleBox["cdrom",
                  "TI"]}]}]}]},
        {"\[ThickSpace]", "or"},
        {"\[ThickSpace]", 
          RowBox[{"mount", "-", 
            RowBox[{
              RowBox[{\(r\ /dev\), "/", 
                StyleBox["device",
                  "TI"]}], 
              StyleBox["   ",
                "TI"], "/", 
              StyleBox["cdrom",
                "TI"]}]}]},
        {"Solaris", 
          RowBox[{"mount", "-", "r", "-", 
            RowBox[{"F", " ", 
              RowBox[{
                RowBox[{\(hsfs\ /dev\), "/", 
                  StyleBox["device",
                    "TI"]}], 
                StyleBox["   ",
                  "TI"], "/", 
                StyleBox["cdrom",
                  "TI"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "2ColumnBox",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    Inherited, 6.0}}, GridBoxOptions -> {ColumnSpacings -> 2.0}}},
  GridBoxOptions->{ColumnSpacings->2},
  CellTags->"b:8.0"],

Cell[TextData[{
  "Typical ",
  StyleBox["mount", "MR"],
  " commands for mounting the CD on various Unix platforms."
}], "Caption",
  CellTags->"b:8.0"],

Cell[TextData[{
  "If the filenames on the CD appear in the wrong case, it means the CD is \
mounted incorrectly. Note that on HP-UX you must use the command ",
  StyleBox["pfs_mount", "MR"],
  " instead of ",
  StyleBox["mount", "MR"],
  "."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    5.0, 5.0}}}},
  CellTags->{"i:4", "b:8.0"}],

Cell[TextData[{
  "After you have finished using the CD, you must unmount it. Typically, the \
unmount command is ",
  StyleBox["umount ", "MR"],
  "/",
  StyleBox["cdrom", "TI"],
  ". Before unmounting the CD make sure that no programs are running from the \
CD, no files are open, and no users have a directory on the CD as their \
current working directory."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    5.0, 5.0}}}},
  CellTags->{"i:2", "b:8.0"}],

Cell[" ", "Text"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1152}, {0, 788}},
ScreenStyleEnvironment->"Brackets",
PrintingStyleEnvironment->"EnhancedPrintout",
WindowSize->{550, 590},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->Automatic,
Visible->True,
PrintingCopies->1,
PrintingStartingPageNumber->109,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
          CounterBox[ "Page"]], "PageNumber"], Inherited, Cell[ 
      "Mathematica Products System Administration Guide", "PageHeader"]}, {
    Cell[ "Appendix", "PageHeader"], Inherited, Cell[ 
        TextData[ 
          CounterBox[ "Page"]], "PageNumber"]}},
PageFooters->{{Inherited, None, Inherited}, {Inherited, None, Inherited}},
PageFooterLines->{False, False},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"GraphicsPrintingFormat"->"DownloadPostScript"},
TaggingRules:>{"OptionsEnvironment" -> "Online", "NextIndexingNumber" -> 5, \
"IndexEntries" -> {{"i:2", 
  StyleBox[ "umount", "MR"]}, {"i:3", 
  StyleBox[ "mount", "MR"]}, {"i:4", 
  StyleBox[ 
  "pfs_mount", 
    "MR"]}, {"i:1", "CD-ROM on Unix and Linux", "mounting"}, {"i:1", "Unix \
and Linux", "mounting CD-ROM"}, {"i:2", "Unix and Linux", "unmounting \
CD-ROM"}, {"i:2", "Unix and Linux", 
  StyleBox[ "umount", "MR"]}, {"i:3", "Unix and Linux", 
  StyleBox[ 
  "mount", "MR"]}, {"i:1", "mounting CD-ROM on Unix and Linux", "", ""}, \
{"i:2", "CD-ROM on Unix and Linux", "unmounting", ""}}, "PaginationCache" -> \
{{2004, 9, 2, 12, 18, 33.8231658`9.28178915365876}, {109, 109, 109, 109, 109, \
109, 109, 109, 110}, Automatic}},
DefaultNewCellStyle->"Text",
AutoItalicWords->{
  "Mathematica", "MathLM", "MathSource", "MathReader", "MathScript"},
PrivateFontOptions->{"OperatorSubstitution"->False},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[2073, 61, 190, 3, 65, "Section",
      CellTags->{"c:1", "i:1", "b:8.0"}]},
  "i:1"->{
    Cell[2073, 61, 190, 3, 65, "Section",
      CellTags->{"c:1", "i:1", "b:8.0"}]},
  "b:8.0"->{
    Cell[2073, 61, 190, 3, 65, "Section",
      CellTags->{"c:1", "i:1", "b:8.0"}],
    Cell[2266, 66, 683, 18, 61, "Text",
      CellTags->"b:8.0"],
    Cell[2952, 86, 656, 16, 61, "Text",
      CellTags->{"i:3", "b:8.0"}],
    Cell[3611, 104, 3190, 95, 142, "2ColumnBox",
      CellTags->"b:8.0"],
    Cell[6804, 201, 153, 5, 16, "Caption",
      CellTags->"b:8.0"],
    Cell[6960, 208, 380, 10, 36, "Text",
      CellTags->{"i:4", "b:8.0"}],
    Cell[7343, 220, 499, 12, 48, "Text",
      CellTags->{"i:2", "b:8.0"}]},
  "i:3"->{
    Cell[2952, 86, 656, 16, 61, "Text",
      CellTags->{"i:3", "b:8.0"}]},
  "i:4"->{
    Cell[6960, 208, 380, 10, 36, "Text",
      CellTags->{"i:4", "b:8.0"}]},
  "i:2"->{
    Cell[7343, 220, 499, 12, 48, "Text",
      CellTags->{"i:2", "b:8.0"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 10221, 294},
  {"i:1", 10317, 297},
  {"b:8.0", 10415, 300},
  {"i:3", 10948, 315},
  {"i:4", 11035, 318},
  {"i:2", 11123, 321}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 272, 4, 92, "Chapter"],

Cell[CellGroupData[{
Cell[2073, 61, 190, 3, 65, "Section",
  CellTags->{"c:1", "i:1", "b:8.0"}],
Cell[2266, 66, 683, 18, 61, "Text",
  CellTags->"b:8.0"],
Cell[2952, 86, 656, 16, 61, "Text",
  CellTags->{"i:3", "b:8.0"}],
Cell[3611, 104, 3190, 95, 142, "2ColumnBox",
  CellTags->"b:8.0"],
Cell[6804, 201, 153, 5, 16, "Caption",
  CellTags->"b:8.0"],
Cell[6960, 208, 380, 10, 36, "Text",
  CellTags->{"i:4", "b:8.0"}],
Cell[7343, 220, 499, 12, 48, "Text",
  CellTags->{"i:2", "b:8.0"}],
Cell[7845, 234, 17, 0, 24, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

