(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20640,        669]*)
(*NotebookOutlinePosition[     30707,        950]*)
(*  CellTagsIndexPosition[     30042,        919]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Introduction", "Chapter",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 2.0}, {
    Inherited, Inherited}}, CellFrameMargins -> {{0.0, .5*^2}, {8.0, 0.0}}, 
    ParagraphIndent -> -.3*^2, FontSize -> 27.0, Background -> 
    GrayLevel[ .9999847409781033]}}],

Cell[CellGroupData[{

Cell["About This Guide", "Section",
  CellTags->{"c:1", "b:0.1"}],

Cell[TextData[{
  "This guide covers the installation, configuration, and maintenance of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in a multi-user and multi-machine environment, such as a research lab or \
university. While some organizations will exclusively have either network \
licenses or single-user licenses, many use a combination of both license \
types."
}], "Text",
  CellTags->"b:0.1"],

Cell["\<\
To see which kind of license you have, look at the \
\[OpenCurlyDoubleQuote]License Class\[CloseCurlyDoubleQuote] on your license \
certificate or contact your Site Administrator.\
\>", "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  "A ",
  StyleBox["network", "TB"],
  " license permits a specified number of copies of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to run concurrently on a network, making ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " available to multiple users and machines. Network license management \
operates on the client-server model. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " license manager, ",
  Cell[BoxData[
      \(TraditionalForm\`MathLM\^\[Trademark]\)]],
  ", is installed on the license server and handles the details of license \
activity. Copies of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are then installed as clients of ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->{"i:6", "b:0.1"}],

Cell[TextData[{
  "A ",
  StyleBox["single-user", "TB"],
  " license is used for standalone installations of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". In this document and the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installers, the terms \[OpenCurlyDoubleQuote]single-machine\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]single-user\
\[CloseCurlyDoubleQuote] are used interchangeably. See your license \
certificate for details."
}], "BulletedList",
  CellTags->{"i:11", "b:0.1"}],

Cell[TextData[{
  "Chapters 1 through 4 of this guide contain information about installing \
and configuring ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " and installing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a ",
  StyleBox["MathLM ",
    FontSlant->"Italic"],
  "client. If you have a ",
  StyleBox["network", "TB"],
  " license, begin with Chapter 1, which contains system requirements and \
installation instructions for ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  ". Chapter 2 describes how to configure ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " and monitor license activity. Chapter 3 contains instructions for \
installing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " client. Chapter 4 discusses troubleshooting communication problems \
between ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " and its clients. For information about customizing and configuring the \
client ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installations, see Chapters 5 through 7."
}], "Text",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, 2.25}, {
    Inherited, Inherited}}}},
  CellTags->"b:0.1"],

Cell[TextData[{
  "Chapters 5 through 7 contain information about installing, configuring, \
and maintaining one or many copies of ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " Information in these chapters is also relevant to ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " environments. If you have a ",
  StyleBox["single-user", "TB"],
  " license, begin with the appropriate chapter for your operating system. \
Chapter 5 covers ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system administration on Windows; Chapter 6 covers ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system administration on Unix and Linux; Chapter 7 covers ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system administration on Mac OS X. Each of these platform-specific \
chapters includes instructions for installing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with a single-user license, alternate installation methods, testing",
  " ",
  "instructions, configuration information, and troubleshooting tips."
}], "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  "For an introduction to using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", see ",
  StyleBox["Getting Started with Mathematica.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  "Both ",
  StyleBox["Getting Started with Mathematica",
    FontSlant->"Italic"],
  " and this manual are available online at ",
  ButtonBox["documents.wolfram.com",
    ButtonData:>{
      URL[ "http://documents.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"b:0.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "About ",
  StyleBox["MathLM",
    FontSlant->"Italic"]
}], "Section",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    Inherited, 28.0}}}},
  CellTags->{"c:2", "b:0.2", "i:5"}],

Cell[TextData[{
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " administers licenses for organizations running multiple instances of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with a network license. Network licenses provide a convenient and \
cost-effective way of making ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " available to multiple client machines in a networked environment. Instead \
of a separate license for each machine, a network license allows a specified \
number of copies of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to run concurrently on the network. ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " automates the task of making sure you conform to the license agreement."
}], "Text",
  CellTags->"b:0.2"],

Cell[TextData[{
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " is installed on a single machine, known as the license server. Once ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " is running, it acts as a gatekeeper for new ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "sessions. ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " sets up the appropriate number of process slots for each class of \
computer covered by the network license. ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " monitors the number of copies of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in use and issues licenses to clients until all available licenses are \
in",
  " ",
  "use."
}], "Text",
  CellTags->{"b:0.2", "i:7"}],

Cell["\<\
The number of concurrent processes that may run over the entire network is \
printed on your license certificate. You can increase the number of processes \
allowed with a license upgrade from Wolfram Research.\
\>", "Text",
  CellTags->{"b:0.2", "i:8"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " consists of two components, the kernel and the front end. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel performs computations. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end is the graphical notebook interface. ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " keeps track of kernel and front end processes separately. The number ",
  StyleBox["n", "TI"],
  " of processes printed on your license certificate generally gives you ",
  StyleBox["n", "TI"],
  " front end process slots and ",
  StyleBox["n", "TI"],
  " kernel process slots."
}], "Text",
  CellTags->{"i:24", "b:0.2"}],

Cell[TextData[{
  "A client ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " process must request a license from ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " before it starts taking user input or performing calculations. In order \
for clients to run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " must be running on the license server at all times. If the client machine \
making the request is not of a type covered by the license, or if all of \
the",
  " ",
  "process slots are already in use, the client ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " process cannot be started."
}], "Text",
  CellTags->"b:0.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Registration and Passwords", "Section",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    Inherited, 6.0}}}},
  CellTags->{"c:3", "b:0.3"}],

Cell[CellGroupData[{

Cell["Registration", "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {}},
  CellTags->{"i:9", "b:0.3"}],

Cell[TextData[{
  "To install and use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  ", you must register with Wolfram Research and receive a password."
}], "Text",
  CellTags->{"b:0.3", "i:10"}],

Cell["\<\
Before registering, you must first begin the installation process according \
to the instructions in the following sections. Midway through the \
installation process, a MathID number will be displayed on your screen. This \
MathID number is a machine-specific identification number that is \
automatically determined when running the installer on a machine.\
\>", "Text",
  CellTags->{"i:11", "b:0.3"}],

Cell[TextData[{
  "In addition to your MathID number, you will need to provide the license ID \
number printed on your license certificate. To register ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  ", you will also need to provide the hostname of the machine that will run \
",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"i:12", "b:0.3"}],

Cell["\<\
Once you have your MathID number, you can register and get a password in one \
of these ways:\
\>", "Text",
  CellTags->"b:0.3"],

Cell[TextData[{
  "On the web: Complete the registration form on the web at ",
  ButtonBox["register.wolfram.com",
    ButtonData:>{
      URL[ "http://register.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ". (In Europe: ",
  ButtonBox["register.wolfram.co.uk",
    ButtonData:>{
      URL[ "http://register.wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink"],
  ".) This will generate a password for you automatically, any time of day."
}], "BulletedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    Inherited, 3.0}}}},
  CellTags->"b:0.3"],

Cell["\<\
By phone: Call Customer Service at +1\[Hyphen]800\[Hyphen]WOLFRAM or +1\
\[Hyphen]217\[Hyphen]398\[Hyphen]5151, Monday\[Dash]Friday, 8am\[Dash]5pm \
U.S. Central Time. (In Europe: +44\[Hyphen](0)1993\[Hyphen]883400, Monday\
\[Dash]Friday, 9am\[Dash]5pm GMT.)\
\>", "BulletedList",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    Inherited, 3.0}}}},
  CellTags->"b:0.3"],

Cell["\<\
Be sure to write down the password and keep it for future reference. The \
MathID number for your machine can change under certain circumstances, for \
example, if you reformat your hard disk. If the MathID number changes, you \
will need to contact Customer Service to get a new password.\
\>", "Text",
  CellTags->"b:0.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["The mathpass File", "Subsubsection",
  CellTags->{"i:13", "b:0.3"}],

Cell[TextData[{
  "To run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  ", you must have the appropriate password. Passwords are stored within a \
file called ",
  StyleBox["mathpass", "MR"],
  ". The location of the ",
  StyleBox["mathpass", "MR"],
  " file for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " varies by operating system. See Sections 5.4, 6.4, and 7.4, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Configuration Files, for ",
  StyleBox["mathpass", "MR"],
  " file locations on ",
  ButtonBox["Windows",
    ButtonData:>{"Configuration Files on Windows"},
    ButtonStyle->"GettingStartedLink"],
  ", ",
  ButtonBox["Unix/\[InvisibleSpace]Linux",
    ButtonData:>{"Configuration Files on Unix and Linux"},
    ButtonStyle->"GettingStartedLink"],
  ", and ",
  ButtonBox["Mac OS X",
    ButtonData:>{"Configuration Files on Mac OS X"},
    ButtonStyle->"GettingStartedLink"],
  ", respectively. The ",
  StyleBox["mathpass", "MR"],
  " file for ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " is located in the top-level ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " installation directory. The ",
  StyleBox["mathpass", "MR"],
  " file is created automatically by the installer, but you may find it \
necessary to edit the file by hand at times."
}], "Text",
  CellTags->{"i:14", "b:0.3"}],

Cell[TextData[{
  "The ",
  StyleBox["mathpass", "MR"],
  " file may contain one or many password entries, depending on your license \
type. Each line of the ",
  StyleBox["mathpass", "MR"],
  " file contains information for a separate password. The ",
  StyleBox["mathpass", "MR"],
  " file is parsed from top to bottom and the first valid password found is \
used.",
  " ",
  "You can comment out any line in the ",
  StyleBox["mathpass", "MR"],
  " file by placing a ",
  StyleBox["%", "MR"],
  " character at the start of the line."
}], "Text",
  CellTags->{"i:15", "b:0.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "Passwords"
}], "Subsubsection",
  CellTags->{"i:19", "b:0.3"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " passwords have two forms. Network passwords are used by copies of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that get a license from the license server. Single-machine passwords are \
used by standalone copies of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The ",
  StyleBox["mathpass", "MR"],
  " file can contain a single password or a mixture of both types. If there \
is",
  " ",
  "more than one password in the ",
  StyleBox["mathpass", "MR"],
  " file, the first valid entry is used."
}], "Text",
  CellTags->{"i:20", "b:0.3"}],

Cell[TextData[{
  "Network passwords have the form !",
  StyleBox["hostname", "TI"],
  ", where ",
  StyleBox["hostname", "TI"],
  " is the hostname or IP address of the ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " license server. Network passwords must begin with a ",
  StyleBox["!", "MR"],
  " character. A network password is stored in the ",
  StyleBox["mathpass", "MR"],
  " file in the following format."
}], "Text",
  CellTags->{"i:21", "b:0.3"}],

Cell[TextData[StyleBox["!hostname", "MR"]], "Text",
  CellTags->"b:0.3"],

Cell[TextData[{
  "Single-machine passwords typically have the form ",
  StyleBox["dddd", "TI"],
  "\[Dash]",
  StyleBox["ddd", "TI"],
  "\[Dash]",
  StyleBox["ddd", "TI"],
  ", where ",
  StyleBox["d", "TI"],
  " stands for a digit 0\[Dash]9. The password may have other fields in it \
depending on your license type. The password is stored in the ",
  StyleBox["mathpass", "MR"],
  " file in the following format."
}], "Text",
  CellTags->{"i:22", "b:0.3"}],

Cell[TextData[StyleBox["hostname\t7000-10419-18404\tL1234-5678\t \
1234-567-890", "MR"]], "Text",
  CellTags->"b:0.3"],

Cell[TextData[{
  "The hostname here is the name of the machine on which the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " processes will run. This is given first, followed by the MathID number, \
the license ID number, and the password. The parts of the entry may be \
separated by spaces or tabs."
}], "Text",
  CellTags->"b:0.3"],

Cell[TextData[{
  "The ",
  StyleBox["mathpass", "MR"],
  " file may have multiple single-machine passwords listed. It may be shared \
across the network, allowing you to maintain a single ",
  StyleBox["mathpass", "MR"],
  " file for multiple machines."
}], "Text",
  CellTags->{"i:25", "b:0.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " Passwords "
}], "Subsubsection",
  TaggingRules:>{"PrintOptions" -> {CellMargins -> {{Inherited, Inherited}, {
    Inherited, 6.0}}}},
  CellTags->{"i:16", "b:0.3"}],

Cell[TextData[{
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " passwords typically have the form ",
  StyleBox["dddd", "TI"],
  "\[Dash]",
  StyleBox["ddd", "TI"],
  "\[Dash]",
  StyleBox["ddd", "TI"],
  ":",
  StyleBox["n", "TI"],
  ":::C",
  StyleBox["t", "TI"],
  ". Here, ",
  StyleBox["d", "TI"],
  " stands for a digit 0\[Dash]9, ",
  StyleBox["n", "TI"],
  " stands for the number of processes for the license, and ",
  StyleBox["t", "TI"],
  " stands for the license class, which may be A or B. In some passwords, the \
digit ",
  StyleBox["n", "TI"],
  " may be replaced with a pair of digits ",
  StyleBox["n", "TI"],
  ", ",
  StyleBox["m", "TI"],
  ", which specify the number of kernel processes and front end processes, \
respectively. The password may have other fields in it, depending on your \
license."
}], "Text",
  CellTags->{"i:17", "b:0.3"}],

Cell[TextData[{
  "The capital letters at the end of the password refer to the license class, \
which determines what client platforms ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "can run on. Windows, Macintosh OS X, and some Linux platforms are class A. \
Server-class platforms are class B. The ",
  StyleBox["mathpass", "MR"],
  " file must contain separate password entries for each license class. Class \
B passwords are valid for both class A and class B clients."
}], "Text",
  CellTags->{"i:18", "b:0.3"}],

Cell[TextData[{
  "The password is stored in the ",
  StyleBox["mathpass", "MR"],
  " file in the following format."
}], "Text",
  CellTags->"b:0.3"],

Cell[TextData[StyleBox["!hostname\t7000-10419-18404\tL1234-5678\t \
1234-567-890:8:::CB", "MR"]], "Text",
  CellTags->"b:0.3"],

Cell[TextData[{
  "The name of the license server running ",
  StyleBox["MathLM",
    FontSlant->"Italic"],
  " is given first, followed by its MathID number. The ",
  StyleBox["!", "MR"],
  " character at the start of the line distinguishes a network password from \
a single\[Hyphen]machine password. The license ID number is followed by the \
password. The parts of the entry may be separated by spaces or tabs."
}], "Text",
  CellTags->"b:0.3"],

Cell[" ", "Text",
  TaggingRules:>{"PrintOptions" -> {PageBreakAbove -> True}}]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1152}, {0, 788}},
ScreenStyleEnvironment->"Brackets",
PrintingStyleEnvironment->"EnhancedPrintout",
WindowSize->{894, 639},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
WindowTitle->Automatic,
Visible->True,
PrintingCopies->1,
PrintingStartingPageNumber->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
          CounterBox[ "Page"]], "PageNumber"], Inherited, Cell[ 
      "Mathematica Products System Administration Guide", "PageHeader"]}, {
    Cell[ "Introduction", "PageHeader"], Inherited, Cell[ 
        TextData[ 
          CounterBox[ "Page"]], "PageNumber"]}},
PageFooters->{{Inherited, None, Inherited}, {Inherited, None, Inherited}},
PageFooterLines->{False, False},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"GraphicsPrintingFormat"->"DownloadPostScript"},
TaggingRules:>{"OptionsEnvironment" -> "Online", "NextIndexingNumber" -> 12, \
"IndexEntries" -> {{"i:11", "MathID number"}, {"i:12", "License ID number"}, \
{"i:13", "Password file"}, {"i:18", "License class"}, {"i:24", "Kernel"}, \
{"i:6", "Network license"}, {"i:6", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " license manager"}}, {"i:9", "Registration"}, {"i:1", "CD-ROM \
 on Unix and Linux", "mounting"}, {"i:1", "Unix and Linux", "mounting  \
CD-ROM"}, {"i:10", "Passwords", "receiving from Wolfram Research"}, {"i:13", \
"mathpass file", "introduction"}, {"i:14", "mathpass file", {"location for ", \

  StyleBox[ 
  "MathLM", FontSlant -> 
    "Italic"]}}, {"i:15", "mathpass file", "comments"}, {"i:16", "Passwords", \

  StyleBox[ "MathLM", FontSlant -> "Italic"]}, {"i:16", 
  StyleBox[ 
  "MathLM", FontSlant -> 
    "Italic"], "passwords"}, {"i:17", "mathpass file", {"format for ", 
  StyleBox[ 
  "MathLM", FontSlant -> 
    "Italic"], " password"}}, {"i:17", "Passwords", {"format for ", 
  StyleBox[ 
  "MathLM", FontSlant -> 
    "Italic"], " password"}}, {"i:18", "Class", "license"}, {"i:19", \
"Passwords", 
  StyleBox[ "Mathematica", FontSlant -> "Italic"]}, {"i:19", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], "passwords"}, {"i:20", "Passwords", "network"}, {"i:20", \
"Passwords", "single-machine"}, {"i:21", "mathpass file", "format for network \
 password"}, {"i:21", "Passwords", "format for network password"}, {"i:22", \
"mathpass file", "format for single-machine password"}, {"i:22", "Passwords", \
"format for single-machine password"}, {"i:25", "mathpass file", "sharing"}, \
{"i:25", "Passwords", "for multiple machines"}, {"i:5", 
  StyleBox[ 
  "MathLM", FontSlant -> 
    "Italic"], "overview"}, {"i:7", "License server", {"and ", 
  StyleBox[ 
  "MathLM", FontSlant -> 
    "Italic"]}}, {"i:7", "Process", "slots"}, {"i:1", "mounting CD-ROM on \
Unix and Linux", "", ""}, {"i:11", "Single-user license", "", ""}, {"i:21", \
"Network passwords", "format", ""}, {"i:22", "Single-machine passwords", \
"format", ""}, {"i:24", "Front end", "", ""}, {"i:8", "License", "and number \
of concurrent processes", ""}, {"i:8", "Process", "number allowed with \
network license", ""}}, "PaginationCache" -> {{2004, 8, 23, 16, 31, \
14.1255926`8.90258162746682}, {1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, \
5, 5, 6}, Automatic}},
DefaultNewCellStyle->"Text",
AutoItalicWords->{
  "Mathematica", "MathLM", "MathSource", "MathReader", "MathScript"},
PrivateFontOptions->{"OperatorSubstitution"->False},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[2082, 61, 65, 1, 65, "Section",
      CellTags->{"c:1", "b:0.1"}]},
  "b:0.1"->{
    Cell[2082, 61, 65, 1, 65, "Section",
      CellTags->{"c:1", "b:0.1"}],
    Cell[2150, 64, 414, 9, 42, "Text",
      CellTags->"b:0.1"],
    Cell[2567, 75, 224, 5, 25, "Text",
      CellTags->"b:0.1"],
    Cell[2794, 82, 816, 25, 65, "BulletedList",
      CellTags->{"i:6", "b:0.1"}],
    Cell[3613, 109, 525, 14, 46, "BulletedList",
      CellTags->{"i:11", "b:0.1"}],
    Cell[4141, 125, 1246, 39, 76, "Text",
      CellTags->"b:0.1"],
    Cell[5390, 166, 1093, 28, 93, "Text",
      CellTags->"b:0.1"],
    Cell[6486, 196, 220, 8, 25, "Text",
      CellTags->"b:0.1"],
    Cell[6709, 206, 322, 11, 25, "Text",
      CellTags->"b:0.1"]},
  "i:6"->{
    Cell[2794, 82, 816, 25, 65, "BulletedList",
      CellTags->{"i:6", "b:0.1"}]},
  "i:11"->{
    Cell[3613, 109, 525, 14, 46, "BulletedList",
      CellTags->{"i:11", "b:0.1"}],
    Cell[11139, 358, 413, 7, 48, "Text",
      CellTags->{"i:11", "b:0.3"}]},
  "c:2"->{
    Cell[7068, 222, 228, 7, 39, "Section",
      CellTags->{"c:2", "b:0.2", "i:5"}]},
  "b:0.2"->{
    Cell[7068, 222, 228, 7, 39, "Section",
      CellTags->{"c:2", "b:0.2", "i:5"}],
    Cell[7299, 231, 780, 20, 76, "Text",
      CellTags->"b:0.2"],
    Cell[8082, 253, 746, 24, 59, "Text",
      CellTags->{"b:0.2", "i:7"}],
    Cell[8831, 279, 264, 5, 36, "Text",
      CellTags->{"b:0.2", "i:8"}],
    Cell[9098, 286, 708, 20, 61, "Text",
      CellTags->{"i:24", "b:0.2"}],
    Cell[9809, 308, 715, 23, 61, "Text",
      CellTags->"b:0.2"]},
  "i:5"->{
    Cell[7068, 222, 228, 7, 39, "Section",
      CellTags->{"c:2", "b:0.2", "i:5"}]},
  "i:7"->{
    Cell[8082, 253, 746, 24, 59, "Text",
      CellTags->{"b:0.2", "i:7"}]},
  "i:8"->{
    Cell[8831, 279, 264, 5, 36, "Text",
      CellTags->{"b:0.2", "i:8"}]},
  "i:24"->{
    Cell[9098, 286, 708, 20, 61, "Text",
      CellTags->{"i:24", "b:0.2"}]},
  "c:3"->{
    Cell[10561, 336, 177, 3, 39, "Section",
      CellTags->{"c:3", "b:0.3"}]},
  "b:0.3"->{
    Cell[10561, 336, 177, 3, 39, "Section",
      CellTags->{"c:3", "b:0.3"}],
    Cell[10763, 343, 107, 2, 23, "Subsubsection",
      CellTags->{"i:9", "b:0.3"}],
    Cell[10873, 347, 263, 9, 24, "Text",
      CellTags->{"b:0.3", "i:10"}],
    Cell[11139, 358, 413, 7, 48, "Text",
      CellTags->{"i:11", "b:0.3"}],
    Cell[11555, 367, 379, 11, 36, "Text",
      CellTags->{"i:12", "b:0.3"}],
    Cell[11937, 380, 138, 4, 24, "Text",
      CellTags->"b:0.3"],
    Cell[12078, 386, 592, 15, 30, "BulletedList",
      CellTags->"b:0.3"],
    Cell[12673, 403, 413, 8, 30, "BulletedList",
      CellTags->"b:0.3"],
    Cell[13089, 413, 334, 6, 48, "Text",
      CellTags->"b:0.3"],
    Cell[13460, 424, 73, 1, 23, "Subsubsection",
      CellTags->{"i:13", "b:0.3"}],
    Cell[13536, 427, 1414, 45, 73, "Text",
      CellTags->{"i:14", "b:0.3"}],
    Cell[14953, 474, 579, 17, 61, "Text",
      CellTags->{"i:15", "b:0.3"}],
    Cell[15569, 496, 134, 5, 23, "Subsubsection",
      CellTags->{"i:19", "b:0.3"}],
    Cell[15706, 503, 638, 19, 61, "Text",
      CellTags->{"i:20", "b:0.3"}],
    Cell[16347, 524, 463, 14, 48, "Text",
      CellTags->{"i:21", "b:0.3"}],
    Cell[16813, 540, 72, 1, 24, "Text",
      CellTags->"b:0.3"],
    Cell[16888, 543, 459, 14, 48, "Text",
      CellTags->{"i:22", "b:0.3"}],
    Cell[17350, 559, 118, 2, 24, "Text",
      CellTags->"b:0.3"],
    Cell[17471, 563, 345, 8, 48, "Text",
      CellTags->"b:0.3"],
    Cell[17819, 573, 297, 8, 36, "Text",
      CellTags->{"i:25", "b:0.3"}],
    Cell[18153, 586, 232, 7, 23, "Subsubsection",
      CellTags->{"i:16", "b:0.3"}],
    Cell[18388, 595, 868, 30, 61, "Text",
      CellTags->{"i:17", "b:0.3"}],
    Cell[19259, 627, 527, 11, 61, "Text",
      CellTags->{"i:18", "b:0.3"}],
    Cell[19789, 640, 149, 5, 24, "Text",
      CellTags->"b:0.3"],
    Cell[19941, 647, 126, 2, 24, "Text",
      CellTags->"b:0.3"],
    Cell[20070, 651, 448, 10, 48, "Text",
      CellTags->"b:0.3"]},
  "i:9"->{
    Cell[10763, 343, 107, 2, 23, "Subsubsection",
      CellTags->{"i:9", "b:0.3"}]},
  "i:10"->{
    Cell[10873, 347, 263, 9, 24, "Text",
      CellTags->{"b:0.3", "i:10"}]},
  "i:12"->{
    Cell[11555, 367, 379, 11, 36, "Text",
      CellTags->{"i:12", "b:0.3"}]},
  "i:13"->{
    Cell[13460, 424, 73, 1, 23, "Subsubsection",
      CellTags->{"i:13", "b:0.3"}]},
  "i:14"->{
    Cell[13536, 427, 1414, 45, 73, "Text",
      CellTags->{"i:14", "b:0.3"}]},
  "i:15"->{
    Cell[14953, 474, 579, 17, 61, "Text",
      CellTags->{"i:15", "b:0.3"}]},
  "i:19"->{
    Cell[15569, 496, 134, 5, 23, "Subsubsection",
      CellTags->{"i:19", "b:0.3"}]},
  "i:20"->{
    Cell[15706, 503, 638, 19, 61, "Text",
      CellTags->{"i:20", "b:0.3"}]},
  "i:21"->{
    Cell[16347, 524, 463, 14, 48, "Text",
      CellTags->{"i:21", "b:0.3"}]},
  "i:22"->{
    Cell[16888, 543, 459, 14, 48, "Text",
      CellTags->{"i:22", "b:0.3"}]},
  "i:25"->{
    Cell[17819, 573, 297, 8, 36, "Text",
      CellTags->{"i:25", "b:0.3"}]},
  "i:16"->{
    Cell[18153, 586, 232, 7, 23, "Subsubsection",
      CellTags->{"i:16", "b:0.3"}]},
  "i:17"->{
    Cell[18388, 595, 868, 30, 61, "Text",
      CellTags->{"i:17", "b:0.3"}]},
  "i:18"->{
    Cell[19259, 627, 527, 11, 61, "Text",
      CellTags->{"i:18", "b:0.3"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 24722, 759},
  {"b:0.1", 24812, 762},
  {"i:6", 25467, 781},
  {"i:11", 25563, 784},
  {"c:2", 25737, 789},
  {"b:0.2", 25836, 792},
  {"i:5", 26295, 805},
  {"i:7", 26392, 808},
  {"i:8", 26480, 811},
  {"i:24", 26568, 814},
  {"c:3", 26657, 817},
  {"b:0.3", 26750, 820},
  {"i:9", 28726, 873},
  {"i:10", 28824, 876},
  {"i:12", 28914, 879},
  {"i:13", 29005, 882},
  {"i:14", 29103, 885},
  {"i:15", 29195, 888},
  {"i:19", 29286, 891},
  {"i:20", 29385, 894},
  {"i:21", 29476, 897},
  {"i:22", 29567, 900},
  {"i:25", 29658, 903},
  {"i:16", 29748, 906},
  {"i:17", 29847, 909},
  {"i:18", 29938, 912}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 281, 4, 92, "Chapter"],

Cell[CellGroupData[{
Cell[2082, 61, 65, 1, 65, "Section",
  CellTags->{"c:1", "b:0.1"}],
Cell[2150, 64, 414, 9, 42, "Text",
  CellTags->"b:0.1"],
Cell[2567, 75, 224, 5, 25, "Text",
  CellTags->"b:0.1"],
Cell[2794, 82, 816, 25, 65, "BulletedList",
  CellTags->{"i:6", "b:0.1"}],
Cell[3613, 109, 525, 14, 46, "BulletedList",
  CellTags->{"i:11", "b:0.1"}],
Cell[4141, 125, 1246, 39, 76, "Text",
  CellTags->"b:0.1"],
Cell[5390, 166, 1093, 28, 93, "Text",
  CellTags->"b:0.1"],
Cell[6486, 196, 220, 8, 25, "Text",
  CellTags->"b:0.1"],
Cell[6709, 206, 322, 11, 25, "Text",
  CellTags->"b:0.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[7068, 222, 228, 7, 39, "Section",
  CellTags->{"c:2", "b:0.2", "i:5"}],
Cell[7299, 231, 780, 20, 76, "Text",
  CellTags->"b:0.2"],
Cell[8082, 253, 746, 24, 59, "Text",
  CellTags->{"b:0.2", "i:7"}],
Cell[8831, 279, 264, 5, 36, "Text",
  CellTags->{"b:0.2", "i:8"}],
Cell[9098, 286, 708, 20, 61, "Text",
  CellTags->{"i:24", "b:0.2"}],
Cell[9809, 308, 715, 23, 61, "Text",
  CellTags->"b:0.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[10561, 336, 177, 3, 39, "Section",
  CellTags->{"c:3", "b:0.3"}],

Cell[CellGroupData[{
Cell[10763, 343, 107, 2, 23, "Subsubsection",
  CellTags->{"i:9", "b:0.3"}],
Cell[10873, 347, 263, 9, 24, "Text",
  CellTags->{"b:0.3", "i:10"}],
Cell[11139, 358, 413, 7, 48, "Text",
  CellTags->{"i:11", "b:0.3"}],
Cell[11555, 367, 379, 11, 36, "Text",
  CellTags->{"i:12", "b:0.3"}],
Cell[11937, 380, 138, 4, 24, "Text",
  CellTags->"b:0.3"],
Cell[12078, 386, 592, 15, 30, "BulletedList",
  CellTags->"b:0.3"],
Cell[12673, 403, 413, 8, 30, "BulletedList",
  CellTags->"b:0.3"],
Cell[13089, 413, 334, 6, 48, "Text",
  CellTags->"b:0.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[13460, 424, 73, 1, 23, "Subsubsection",
  CellTags->{"i:13", "b:0.3"}],
Cell[13536, 427, 1414, 45, 73, "Text",
  CellTags->{"i:14", "b:0.3"}],
Cell[14953, 474, 579, 17, 61, "Text",
  CellTags->{"i:15", "b:0.3"}]
}, Closed]],

Cell[CellGroupData[{
Cell[15569, 496, 134, 5, 23, "Subsubsection",
  CellTags->{"i:19", "b:0.3"}],
Cell[15706, 503, 638, 19, 61, "Text",
  CellTags->{"i:20", "b:0.3"}],
Cell[16347, 524, 463, 14, 48, "Text",
  CellTags->{"i:21", "b:0.3"}],
Cell[16813, 540, 72, 1, 24, "Text",
  CellTags->"b:0.3"],
Cell[16888, 543, 459, 14, 48, "Text",
  CellTags->{"i:22", "b:0.3"}],
Cell[17350, 559, 118, 2, 24, "Text",
  CellTags->"b:0.3"],
Cell[17471, 563, 345, 8, 48, "Text",
  CellTags->"b:0.3"],
Cell[17819, 573, 297, 8, 36, "Text",
  CellTags->{"i:25", "b:0.3"}]
}, Closed]],

Cell[CellGroupData[{
Cell[18153, 586, 232, 7, 23, "Subsubsection",
  CellTags->{"i:16", "b:0.3"}],
Cell[18388, 595, 868, 30, 61, "Text",
  CellTags->{"i:17", "b:0.3"}],
Cell[19259, 627, 527, 11, 61, "Text",
  CellTags->{"i:18", "b:0.3"}],
Cell[19789, 640, 149, 5, 24, "Text",
  CellTags->"b:0.3"],
Cell[19941, 647, 126, 2, 24, "Text",
  CellTags->"b:0.3"],
Cell[20070, 651, 448, 10, 48, "Text",
  CellTags->"b:0.3"],
Cell[20521, 663, 79, 1, 24, "Text"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

