BrowserCategory["Front End", None, 
  {BrowserCategory["Menu Commands", None, 
      {Item["(Listing)", "MenuIntroduction.nb", 
          CopyTag -> "MenuIntroduction", IndexTag->"Menu Listing"], 
        BrowserCategory["File Menu", None, 
          {Item["New", "FileMenu.nb", CopyTag -> "New"], 
            BrowserCategory["Open...", None, 
              {Item["Open...", "FileMenu.nb", CopyTag -> "Open"], 
                Item["Opening Version 2 notebooks", "FileMenu.nb", 
                  IndexTag -> 
                    {" Converting pre-3.0 Notebooks", 
                      "convertingFrom22NotebookDialogID"}, 
                  CopyTag -> "convertingFrom22NotebookDialogID"]}], 
            Item["Close", "FileMenu.nb", CopyTag -> "Close"], 
            Item["Save", "FileMenu.nb", CopyTag -> "Save"], 
            Item["Save As...", "FileMenu.nb", CopyTag -> "SaveRename"], 
            BrowserCategory["Save As Special...", None, 
              {Item["Save As Special...", "FileMenu.nb", 
                  CopyTag -> "SaveRenameSpecial"], 
                Item["Version 2 Notebook", "FileMenu.nb", 
                  IndexTag -> 
                    {"Save As Special: Version 2 Notebook", 
                      "convertingTo22NotebookDialogID"}, 
                  CopyTag -> "SaveRenameSpecialV20Notebook"], 
                Item["Text", "FileMenu.nb", 
                  IndexTag -> "Save As Special: Text", 
                  CopyTag -> "SaveRenameSpecialText"], 
                Item["Cell Expression", "FileMenu.nb", 
                  IndexTag -> "Save As Special: Cell Expression", 
                  CopyTag -> "SaveRenameSpecialCellExpression"], 
                Item["Notebook Expression", "FileMenu.nb", 
                  IndexTag -> "Save As Special: Notebook Expression", 
                  CopyTag -> "SaveRenameSpecialNotebookExpression"], 
                Item["Package Format", "FileMenu.nb", 
                  IndexTag -> "Save As Special: Package Format", 
                  CopyTag -> "SaveRenameSpecialPackage"], Item[Delimiter], 
                Item["TeX", "FileMenu.nb", 
                  IndexTag -> "Save As Special: TeX", CopyTag -> "TeXSave"], 
                Item["HTML", "FileMenu.nb", 
                  IndexTag -> "Save As Special: HTML", 
                  CopyTag -> "HTMLSave"], 
                Item["XML (XHTML+MathML)", "FileMenu.nb", 
                  IndexTag -> "Save As Special: XHTML+MathML", 
                  CopyTag -> "XHTML+MathMLSave"],
                Item["XML (NotebookML)", "FileMenu.nb", 
                  IndexTag -> "Save As Special: NotebookML", 
                  CopyTag -> "NotebookMLSave"], 
                Item["XML (NotebookML+MathML)", "FileMenu.nb", 
                  IndexTag -> "Save As Special: NotebookML+MathML", 
                  CopyTag -> "NotebookML+MathMLSave"]}],
            Item["Revert", "FileMenu.nb", CopyTag -> "Revert"],  
            Item["Open Special...", "FileMenu.nb", 
              IndexTag -> {"Open Special...", "myOpenOptionsID"}, 
              CopyTag -> "OpenSpecial"], 
            Item["Import...", "FileMenu.nb", CopyTag -> "Import"], 
            Item[Delimiter], 
            Item["Send To...  (Windows)", "FileMenu.nb", 
              CopyTag -> "SendTo"], 
            Item["Send Selection...  (Windows)", "FileMenu.nb", 
              CopyTag -> "SendSelection"], Item[Delimiter], 
            Item["Palettes", "FileMenu.nb", 
              CopyTag -> "MenuListPalettesMenu"], 
            Item["Generate Palette from Selection", "FileMenu.nb", 
              CopyTag -> "GeneratePalette"], 
            Item["Generate Notebook from Palette", "FileMenu.nb", 
              CopyTag -> "GenerateNotebook"], Item[Delimiter], 
            BrowserCategory["Printing Settings", None, 
              {Item["Page Setup...", "FileMenu.nb", 
                  IndexTag -> "Printing Settings: Page Setup", 
                  CopyTag -> "SystemPrintOptionsDialog"], 
                Item["Printing Options...", "FileMenu.nb", 
                  IndexTag -> 
                    {"Printing Settings: Printing Options", 
                      "printingOptionsID"}, CopyTag -> "PrintOptionsDialog"],
                Item["Headers and Footers...", "FileMenu.nb", 
                  IndexTag -> 
                    {"Printing Settings: Headers and Footers", 
                      "headersAndFootersDialogID"}, 
                  CopyTag -> "HeadersFootersDialog"]}], 
            Item["Print...", "FileMenu.nb", CopyTag -> "PrintDialog"], 
            Item["Print Selection...", "FileMenu.nb", 
              CopyTag -> "PrintSelectionDialog"], 
            Item["Exit (Quit for Macintosh)", "FileMenu.nb",IndexTag->"Exit",
              CopyTag -> "FrontEndQuit"]}],(**)BrowserCategory["Edit Menu", 
          None, {Item["Undo", "EditMenu.nb", CopyTag -> "Undo"], 
            Item[Delimiter], Item["Cut", "EditMenu.nb", CopyTag -> "Cut"], 
            Item["Copy", "EditMenu.nb", CopyTag -> "Copy"], 
            Item["Paste", "EditMenu.nb", CopyTag -> "Paste"], 
            Item["Clear", "EditMenu.nb", CopyTag -> "Clear"], 
            Item["Copy As", "EditMenu.nb", CopyTag -> "CopySpecial"], 
            Item["Paste As", "EditMenu.nb", CopyTag -> "PasteAs"], 
            Item["External Clipboard  (X)", "EditMenu.nb", 
                     CopyTag -> "ExternalClipboard"], 
            Item["Save Selection As", "EditMenu.nb", 
              CopyTag -> "SelectionSaveSpecial"], 
            Item["Select All", "EditMenu.nb", CopyTag -> "SelectAll"], 
            Item[Delimiter], 
            Item["Insert Object  (Windows)", "EditMenu.nb", 
              CopyTag -> "InsertObject"], Item[Delimiter], 
            Item["Motion", "EditMenu.nb", CopyTag -> "Motion"], 
            BrowserCategory["Expression Input", None, 
              {Item["Expression Input Commands", "EditMenu.nb", 
                  CopyTag -> "ExpressionInput", 
                  IndexTag :> "Expression Input Commands"], 
                Item["Insert Raw Expression...", "EditMenu.nb", 
                  IndexTag -> 
                    {"Insert Raw Expression...", 
                      "insertRawExpressionDialogID"}, 
                  CopyTag -> "InsertRaw"], 
                Item["Add Frame", "EditMenu.nb", CopyTag -> "AddFrame"], 
                Item["Add Interpretation...", "EditMenu.nb", 
                  CopyTag -> "AddInterpretation"], Item[Delimiter], 
                Item["Spanning Characters", "EditMenu.nb"]}], 
            Item["Make 2D", "EditMenu.nb", CopyTag -> "Make2D"], 
            Item["Check Balance", "EditMenu.nb", CopyTag -> "CheckBalance"], 
            Item[Delimiter], 
            Item["Check Spelling...", "EditMenu.nb", 
              CopyTag -> "CheckSpelling", 
              IndexTag -> {"Check Spelling", "spellCheckerDialogID"}], 
            Item[Delimiter], 
            Item["Preferences...", "EditMenu.nb", 
              CopyTag -> "OptionsDialog"]}],(**)BrowserCategory["Cell Menu", 
          None, {BrowserCategory["Convert To ", None, 
              {Item["InputForm", "CellMenu.nb", 
                  IndexTag -> "Convert To: InputForm", 
                  CopyTag -> "ConvertToInputForm"], 
	    Item["OutputForm", "CellMenu.nb", 
                  IndexTag -> "Convert To: OutputForm ", 
                  CopyTag -> "ConvertToOutputForm"], 
                Item["StandardForm", "CellMenu.nb", 
                  IndexTag -> "Convert To: StandardForm", 
                  CopyTag -> "ConvertToStandardForm"], 
                Item["TraditionalForm", "CellMenu.nb", 
                  IndexTag -> "Convert To: TraditionalForm", 
                  CopyTag -> "ConvertToTraditionalForm"], Item[Delimiter], 
                Item["PostScript", "CellMenu.nb", 
                  IndexTag -> "Convert To: PostScript", 
                  CopyTag -> "PostScript"], 
                Item["Bitmap", "CellMenu.nb", 
                  IndexTag -> "Convert To: Bitmap", CopyTag -> "Bitmap"], 
                Item["Metafile (Windows only)", "CellMenu.nb", 
                  IndexTag -> "Convert To: Metafile", CopyTag -> "Metafile"],
                Item["PICT (Mac only)", "CellMenu.nb", 
                  IndexTag -> "Convert To: PICT", CopyTag -> "PICT"], 
                Item["BitmapPICT (Mac Only)", "CellMenu.nb", 
                  IndexTag -> "Convert To: BitmapPICT", 
                  CopyTag -> "PICTBitmap"], 
                Item["Embedded PS PICT (Mac only)", "CellMenu.nb", 
                  IndexTag -> "Convert To: Embedded PS PICT", 
                  CopyTag -> "PICTEmbeddedPS"], 
                Item["QuickTime (Mac only)", "CellMenu.nb", 
                  IndexTag -> "Convert To: QuickTime", 
                  CopyTag -> "QuickTime"]}], 
            BrowserCategory["Display As", None, 
              {Item["Text", "CellMenu.nb", IndexTag -> "Display As: Text", 
                  CopyTag -> "DisplayAsTextForm"], 
                Item["InputForm", "CellMenu.nb", 
                  IndexTag -> "Display As: InputForm", 
                  CopyTag -> "DisplayAsInputForm"], 
                Item["StandardForm", "CellMenu.nb", 
                  IndexTag -> "Display As: StandardForm", 
                  CopyTag -> "DisplayAsStandardForm"], 
                Item["TraditionalForm", "CellMenu.nb", 
                  IndexTag -> "Display As: TraditionalForm", 
                  CopyTag -> "DisplayAsTraditionalForm"]}], 
            BrowserCategory["Default Input FormatType", None, 
              {Item["InputForm", "CellMenu.nb", 
                  IndexTag -> "Default Input Format Type: InputForm", 
                  CopyTag -> "MenuListCommonDefaultFormatTypesInputInput"], 
                Item["StandardForm", "CellMenu.nb", 
                  IndexTag -> "Default Input Format Type: StandardForm", 
                  CopyTag -> 
                    "MenuListCommonDefaultFormatTypesInputStandard"], 
                Item["TraditionalForm", "CellMenu.nb", 
                  IndexTag -> "Default Input Format Type: TraditionalForm", 
                  CopyTag -> 
                    "MenuListCommonDefaultFormatTypesInputTraditional"]}], 
            BrowserCategory["Default Output FormatType", None, 
              {Item["OutputForm", "CellMenu.nb", 
                  IndexTag -> "Default Output Format Type: OutputForm", 
                  CopyTag -> "MenuListCommonDefaultFormatTypesOutputOutput"],
                Item["InputForm", "CellMenu.nb", 
                  IndexTag -> "Default Output Format Type: InputForm", 
                  CopyTag -> "MenuListCommonDefaultFormatTypesOutputInput"], 
                Item["StandardForm", "CellMenu.nb", 
                  IndexTag -> "Default Output Format Type: StandardForm", 
                  CopyTag -> 
                    "MenuListCommonDefaultFormatTypesOutputStandard"], 
                Item["TraditionalForm", "CellMenu.nb", 
                  IndexTag -> "Default Output Format Type: TraditionalForm", 
                  CopyTag -> 
                    "MenuListCommonDefaultFormatTypesOutputTraditional"]}], 
            BrowserCategory["Default Inline FormatType", None, 
              {Item["StandardForm", "CellMenu.nb", 
                  IndexTag -> "Default Inline Format Type: StandardForm", 
                  CopyTag -> 
                    "MenuListCommonDefaultFormatTypesTextInlineStandard"], 
                Item["TraditionalForm", "CellMenu.nb", 
                  IndexTag -> "Default Inline Format Type: TraditionalForm", 
                  CopyTag -> 
                    "MenuListCommonDefaultFormatTypesTextInlineTraditional"],
                Item[Delimiter]}], 
            BrowserCategory["Cell Properties", None, 
              {Item["Cell Open", "CellMenu.nb", 
                  IndexTag -> "Cell Properties: Cell Open", 
                  CopyTag -> "CellOpen"], 
                Item["Cell Editable", "CellMenu.nb", 
                  IndexTag -> "Cell Properties: Cell Editable", 
                  CopyTag -> "Editable"], 
                Item["Cell Edit Duplicate", "CellMenu.nb", 
                  IndexTag -> "Cell Properties: Cell Edit Duplicate", 
                  CopyTag -> "CellEditDuplicate"], 
                Item["Cell Evaluatable", "CellMenu.nb", 
                  IndexTag -> "Cell Properties: Cell Evaluatable", 
                  CopyTag -> "Evaluatable"], 
                Item["Cell Active", "CellMenu.nb", 
                  IndexTag -> "Cell Properties: Cell Active", 
                  CopyTag -> "Active"], 
                Item["Initialization Cell", "CellMenu.nb", 
                  IndexTag -> 
                    {"Cell Properties: Initialization Cell", 
                      "askIfInitNoteID"}, CopyTag -> "InitializationCell"]}],
            BrowserCategory["Cell Grouping", None, 
              {Item["Group Cells", "CellMenu.nb", 
                  IndexTag -> "Cell Grouping: Group Cells", 
                  CopyTag -> "CellGroup"], 
                Item["Ungroup Cells", "CellMenu.nb", 
                  IndexTag -> "Cell Grouping: Ungroup Cells", 
                  CopyTag -> "CellUnGroup"], 
                Item["Manual Grouping", "CellMenu.nb", 
                  IndexTag -> "Cell Grouping: Manual Grouping", 
                  CopyTag -> "CellGroupingManual"], 
                Item["Automatic Grouping", "CellMenu.nb", 
                  IndexTag -> "Cell Grouping: Automatic Grouping", 
                  CopyTag -> "CellGroupingAutomatic"], 
            Item["Open All Subgroups", "CellMenu.nb", 
                  IndexTag -> "Cell Grouping: Open All Subgroups", 
              CopyTag -> "SelectionOpenAllGroups"], 
            Item["Close All Subgroups", "CellMenu.nb", 
                  IndexTag -> "Cell Grouping: Close All Subgroups",
              CopyTag -> "SelectionCloseAllGroups"], 
            Item["Open/Close Group", "CellMenu.nb", 
                  IndexTag -> "Cell Grouping: Open/Close Group",
              CopyTag -> "OpenCloseGroup"]}], 
            Item["Divide Cell", "CellMenu.nb", CopyTag -> "CellSplit"], 
            Item["Merge Cells", "CellMenu.nb", CopyTag -> "CellMerge"], 
            Item[Delimiter], 
            Item["Animate Selected Graphics", "CellMenu.nb", 
              CopyTag -> "SelectionAnimate"], 
            Item["Play Sound", "CellMenu.nb", CopyTag -> "SoundPlay"], 
            Item["Rerender Graphics", "CellMenu.nb", 
              CopyTag -> "GraphicsRender"], 
            Item["Rerender and Save Graphics", "CellMenu.nb", 
              CopyTag -> "GenerateImageCaches"], Item[Delimiter], 
            Item["Make Standard Size", "CellMenu.nb", 
              CopyTag -> "GraphicsOriginalSize"], 
            Item["Align Selected Graphics...", "CellMenu.nb", 
              IndexTag -> 
                {"Align Selected Graphics...", "alignGraphicsSettingsID"}, 
              CopyTag -> "GraphicsAlign"], Item[Delimiter], 
            Item["Cell Size Statistics...", "CellMenu.nb", 
              IndexTag -> 
                {"Cell Size Statistics...", "notebookStatisticsDialogID"}, 
              CopyTag -> "NotebookStatisticsDialog"]}],(**)BrowserCategory[
          "Format Menu", None, 
          {Item["Style", "FormatMenu.nb",
                  CopyTag -> "MenuListStyles"],
            Item["Screen Style Environment", "FormatMenu.nb", 
              CopyTag -> "MenuListScreenStyleEnvironments"], 
            Item["Printing Style Environment", "FormatMenu.nb", 
              CopyTag -> "MenuListPrintingStyleEnvironments"], 
            Item[Delimiter], 
            Item["Show Expression", "FormatMenu.nb", 
              CopyTag -> "ToggleShowExpression"], 
            Item["Option Inspector...", "FormatMenu.nb", 
              IndexTag -> {"Option Inspector...", "styleInspectorDialogID"}, 
              CopyTag -> "OptionsDialog"], 
            Item["Remove Options...", "FormatMenu.nb", 
              CopyTag -> "ClearCellOptions"], Item[Delimiter], 
            Item["Style Sheet", "FormatMenu.nb", CopyTag -> "MenuStyleSheet",
              IndexTag -> 
                {"Style Sheet", "Menu Style Sheet", 
                  "menuSharedStyleSheetID"}, CopyTag -> "MenuStyleSheet"], 
            Item["Edit Style Sheet...", "FormatMenu.nb", 
              IndexTag -> {"Edit Style \
Sheet...","editingSharedStyleSheetID"}, 
              CopyTag -> "EditStyleDefinitions"], Item[Delimiter], 
            Item["Font", "FormatMenu.nb", CopyTag -> "MenuListFonts"], 
            Item["Face", "FormatMenu.nb", CopyTag -> "PlainFont"], 
            Item["Size", "FormatMenu.nb", CopyTag -> "FontSize"], 
            Item["Text Color", "FormatMenu.nb", CopyTag -> "FontColor"], 
            Item["Background Color", "FormatMenu.nb", 
              CopyTag -> "BackGround"], 
            Item["Choose Font...  (Windows)", "FormatMenu.nb", 
              IndexTag -> "Choose Font...", CopyTag -> "Choose Font"], 
            Item[Delimiter], 
            Item["Text Alignment ", "FormatMenu.nb", 
              CopyTag -> "TextAlignment"], 
            Item["Text Justification ", "FormatMenu.nb", 
              CopyTag -> "TextJustification"], 
            BrowserCategory["Word Wrapping", None, 
              {Item["Don't Word Wrap", "FormatMenu.nb", 
                  IndexTag -> "Word Wrapping: Don't Word Wrap", 
                  CopyTag -> "PageWidthDon't"], 
                Item["Wrap at Paper Width", "FormatMenu.nb", 
                  IndexTag -> "Word Wrapping: Wrap at Paper Width", 
                  CopyTag -> "PageWidthPaper"], 
                Item["Wrap at Window Width", "FormatMenu.nb", 
                  IndexTag -> "Word Wrapping: Wrap at Window Width", 
                  CopyTag -> "PageWidthWindow"], 
                Item["Fixed Word Wrap Width", "FormatMenu.nb", 
                  IndexTag -> "Word Wrapping: Fixed Word Wrap Width", 
                  CopyTag -> "PageWidthFixed"]}], 
            Item["Cell Dingbat", "FormatMenu.nb", CopyTag -> "CellDingbat"], 
	Item["Horizontal Lines", "FormatMenu.nb", CopyTag -> "HorizontalLines"], 
            Item[Delimiter], 
            Item["Show Ruler", "FormatMenu.nb", CopyTag -> "RulerBar"], 
            Item["Show ToolBar", "FormatMenu.nb", CopyTag -> "EditBar"], 
            Item["Show Page Breaks", "FormatMenu.nb", 
              CopyTag -> "ShowPageBreaks"], 
            Item["Magnification", "FormatMenu.nb", IndexTag -> \
"MagnificationMenu",
              CopyTag -> "Magnification"]}],

(**)BrowserCategory["Input Menu", 
          None, {Item["Get Graphics Coordinates...", "InputMenu.nb", 
              CopyTag -> "GraphicsCoordinatesDialog"], 
            Item["3D ViewPoint Selector...", "InputMenu.nb", 
              IndexTag -> 
                {"3D ViewPoint Selector...", "viewPointSelectorID"}, 
              CopyTag -> "ViewPointSelectorDialog"], 
            Item["Color Selector...", "InputMenu.nb", 
              CopyTag -> "ColorSelectorDialog"], 
            Item["Record Sound...", "InputMenu.nb", 
              CopyTag -> "RecordSoundDialog"], 
            Item["Get File Path...", "InputMenu.nb", 
              CopyTag -> "FileNameDialog"], Item[Delimiter], 
            Item["Create Table/Matrix/Palette...", "InputMenu.nb", 
              IndexTag -> 
                {"Create Table/Matrix/Palette...", "createGridBoxDialogID"}, 
              CopyTag -> "CreateGridBoxDialog"], 
            Item["Create Button", "InputMenu.nb", 
              CopyTag -> "CreateCustomButtonBox"], 
            Item["Edit Button...", "InputMenu.nb", 
              IndexTag -> {"Edit Button...", "editButtonBoxScriptDialogID"}, 
              CopyTag -> "EditButtonBoxDialog"], Item[Delimiter], 
            Item["Create Hyperlink...", "InputMenu.nb", 
              IndexTag -> {"Create Hyperlink...", "copyLinkDialogID"}, 
              CopyTag -> "CreateHyperlinkDialog"], 
            Item["Create Automatic Numbering Object...", "InputMenu.nb", 
              IndexTag -> 
                {"Create Automatic Numbering Object...", 
                  "createCounterBoxDialogID"}, 
              CopyTag -> "CreateCounterBoxDialog"], 
            Item["Create Value Display Object...", "InputMenu.nb", 
              IndexTag -> 
                {"Create Value Display Object...", 
                  "createOptionValueBoxDialogID"}, 
              CopyTag -> "CreateOptionValueBoxDialog"], 
            Item["Convert Automatic Objects to Literal", "InputMenu.nb",
	  CopyTag->"ConvertAutomaticObjects"], Item[Delimiter],
            Item["Copy Input from Above", "InputMenu.nb", 
              CopyTag -> "DuplicatePreviousInput"], 
            Item["Copy Output from Above", "InputMenu.nb", 
              CopyTag -> "DuplicatePreviousOutput"], 
            Item["Start New Cell Below", "InputMenu.nb", 
              CopyTag -> "SimilarCellBelow"], Item[Delimiter], 
            Item["Complete Selection", "InputMenu.nb", 
              CopyTag -> "CompleteSelection"], 
            Item["Make Template", "InputMenu.nb", 
              CopyTag -> "TemplateSelection"]}],

(**)BrowserCategory[
          "Kernel Menu", None, 
          {BrowserCategory["Evaluation", None, 
              {Item["Evaluate Cells", "KernelMenu.nb", 
                  IndexTag -> "Evaluation: Evaluate Cells", 
                  CopyTag -> "EvaluateCells"], 
                Item["Evaluate in Place", "KernelMenu.nb", 
                  IndexTag -> "Evaluation: Evaluate in Place", 
                  CopyTag -> "Evaluate"], 
                Item["Evaluate Next Input", "KernelMenu.nb", 
                  IndexTag -> "Evaluation: Evaluate Next Input", 
                  CopyTag -> "EvaluateNextCell"], 
                Item["Evaluate in Subsession", "KernelMenu.nb", 
                  IndexTag -> "Evaluation: Evaluate in Subsession", 
                  CopyTag -> "SubsessionEvaluateCells"], 
                Item["Evaluate Notebook", "KernelMenu.nb", 
                  IndexTag -> "Evaluation: Evaluate Notebook", 
                  CopyTag -> "EvaluateNotebook"], 
                Item["Evaluate Initialization", "KernelMenu.nb", 
                  IndexTag -> "Evaluation: Evaluate Initialization", 
                  CopyTag -> "EvaluateInitialization"], 
                Item["Enter Subsession", "KernelMenu.nb", 
                  IndexTag -> "Evaluation: Enter Subsession", 
                  CopyTag -> "EnterSubsession"], 
                Item["Exit Subsession", "KernelMenu.nb", 
                  IndexTag -> "Evaluation: Exit Subsession", 
                  CopyTag -> "ExitSubsession"], 
                Item["Remove From Ev. Queue", "KernelMenu.nb", 
                  IndexTag -> "Evaluation: Remove From Evaluation Queue", 
                  CopyTag -> "RemoveFromEvaluationQueue"]}], 
            Item["Interrupt Evaluation...", "KernelMenu.nb", 
              IndexTag -> 
                {"Interrupt Evaluation...", "kernelInterruptDialogID"}, 
              CopyTag -> "EvaluatorInterrupt"], 
            Item["Abort Evaluation", "KernelMenu.nb", 
              CopyTag -> "EvaluatorAbort"], Item[Delimiter], 
            Item["Start Kernel", "KernelMenu.nb", 
              CopyTag -> "MenuListStartEvaluators"], 
            Item["Quit Kernel", "KernelMenu.nb", 
              CopyTag -> "MenuListQuitEvaluators"], 
            Item["Default Kernel", "KernelMenu.nb", 
              CopyTag -> "MenuListGlobalEvaluators"], 
            Item["Notebook's Kernel", "KernelMenu.nb", 
              CopyTag -> "MenuListNotebookEvaluators"],
            Item["Kernel Configuration Options...", "KernelMenu.nb", 
              IndexTag -> 
                {"Kernel Configuration Options...", "Kernel Configuration", 
                  "kernelSettingsDialogID"}, 
              CopyTag -> "ModifyEvaluatorNames"], Item[Delimiter], 
            Item["Show In/Out Names", "KernelMenu.nb", 
              CopyTag -> "ShowCellLabel"], 
            Item["Delete All Output", "KernelMenu.nb", 
              CopyTag -> "DeleteGeneratedCells"]}],

(**)BrowserCategory[
          "Find Menu", None, 
          {Item["Find...", "FindMenu.nb", 
              IndexTag -> {"Find...", "shortFormSearchID"}, 
              CopyTag -> "FindDialog"], 
            Item["Enter Selection", "FindMenu.nb", 
              CopyTag -> "SetSelectionFind"], 
            Item["Find Next", "FindMenu.nb", CopyTag -> "NotebookFindNext"], 
            Item["Find Previous", "FindMenu.nb", 
              CopyTag -> "NotebookFindPrevious"], 
            Item["Find in Cell Tags", "FindMenu.nb", 
              CopyTag -> "SelectionCellTagsFind"], 
            Item["Replace", "FindMenu.nb", CopyTag -> "Replace"], 
            Item["Replace and Find Again", "FindMenu.nb", 
              CopyTag -> "ReplaceFind"], 
            Item["Replace All", "FindMenu.nb", CopyTag -> "ReplaceAll"], 
            Item[Delimiter], 
            Item["Open Selected", "FindMenu.nb", 
              CopyTag -> "OpenSelectionParents"], 
            Item["Scroll to Selection", "FindMenu.nb", 
              CopyTag -> "SelectionScroll"], 
            Item["Go Back", "FindMenu.nb", CopyTag -> "HyperlinkGoBack"], 
            Item[Delimiter], 
            Item["Add/Remove Cell Tags...", "FindMenu.nb", 
              IndexTag -> {"Add/Remove Cell Tags...", "editKeysID"}, 
              CopyTag -> "CellTagsEditDialog"], 
            Item["Cell Tags", "FindMenu.nb", CopyTag -> "MenuListTags"], 
            Item["Show Cell Tags", "FindMenu.nb", CopyTag -> "ShowCellTags"],
            Item["Cell Tags from In/Out Names", "FindMenu.nb", 
              CopyTag -> "CellLabelsToTags"], 
            Item["Make Index...", "FindMenu.nb", 
              IndexTag -> {"Make Index...", "makeIndexDialogID"}, 
              CopyTag -> "CreateIndexDialog"]}],(**)BrowserCategory[
          "Window Menu", None, 
          {Item["Stack Windows", "WindowMenu.nb", CopyTag -> "StackWindows"],
            Item["Tile Windows Wide", "WindowMenu.nb", 
              CopyTag -> "TileWindowsWide"], 
            Item["Tile Windows Tall", "WindowMenu.nb", 
              CopyTag -> "TileWindowsTall"]}],
(**)BrowserCategory[
          "Help Menu", None, 
          {Item["Help Browser...", "HelpMenu.nb", CopyTag -> "HelpDialog"], 
            Item["Find Selected Function...", "HelpMenu.nb", 
              CopyTag -> "FindSelectedFunction"], 
            Item["Master Index...", "HelpMenu.nb", CopyTag -> "MasterIndex"],
            Item[Delimiter], 
            Item["Tutorial...", "HelpMenu.nb", CopyTag -> "Tutorial"], 
            Item["Information Center on the Web...", "HelpMenu.nb", 
            CopyTag -> "InfoCenter"], 
            Item["Wolfram Research on the Web...", "HelpMenu.nb", 
            CopyTag -> "WolframSite"],  
            Item["Online Registration...", "HelpMenu.nb", 
            		CopyTag -> "Registration"], 
            Item[Delimiter], 
            Item["Why the Beep?...", "HelpMenu.nb", 
              CopyTag -> "ExplainBeepDialog"],
            Item["Startup Palette...", "HelpMenu.nb", 
            		CopyTag ->"StartupPalette"], 
            Item["About Mathematica...", "HelpMenu.nb", 
              CopyTag -> "AboutMathematica"], 
            Item["X Environment Information... (X only)", "HelpMenu.nb", 
              CopyTag -> "XEnvironmentInformation"], 
              Item[Delimiter], 
            Item["Rebuild Help Index", "HelpMenu.nb", 
              CopyTag -> "RebuildHelpIndex"]}],
           Item[Delimiter],

(*** ** ** ** ** ** ** ** ** ** 
            ** ** MISC*****************************************)
        BrowserCategory["Miscellaneous", None, 
          {Item["Edit List Dialog Box", "KernelMenu.nb", 
              IndexTag -> {"Edit List Dialog Box", "propertiesDialogID"}, 
              CopyTag -> "propertiesDialogID"],
         Item["Kernel Input Dialog Box", "KernelMenu.nb", 
              IndexTag -> {"Kernel Input Dialog Box", "kernelInputDialogID"},
              CopyTag -> "kernelInputDialogID"],
         Item["Password Dialog Box", "KernelMenu.nb", 
              IndexTag -> {"Password Dialog Box", \
"hostilePasswordDialogID","passwordDialogID"},
              CopyTag -> {"hostilePasswordDialogID", "passwordDialogID"}]
	}]}],

(*** ** ***Windows Keyboard Shortcuts***********************************)
      BrowserCategory["Keyboard Shortcuts", None, 
      {BrowserCategory["Microsoft Windows", None, 
          {Item["Nonmenu Commands", "WindowsKeyboardCommands.nb", 
              CopyTag -> "nonmenu"], Item[Delimiter], 
            Item["All Menus", "WindowsKeyboardCommands.nb", 
              IndexTag -> {"Windows Keyboard Shortcuts"}, CopyTag -> "all"], 
            Item[Delimiter], 
            Item["File Menu", "WindowsKeyboardCommands.nb", 
              CopyTag -> "file"], 
            BrowserCategory["Edit Menu", None, 
              {Item["Main Menu", "WindowsKeyboardCommands.nb", 
	      IndexTag->"Edit Menu: Main",
                  CopyTag -> "edit"], 
                Item["Motion Submenu", "WindowsKeyboardCommands.nb", 
	      IndexTag->"Edit Menu: Motion Submenu",
                  CopyTag -> "editmotion"], 
                Item["Expression Input Submenu",
                  "WindowsKeyboardCommands.nb", 
	      IndexTag->"Edit Menu: Expression Submenu",
                  CopyTag -> "editexpression"]}], 
            BrowserCategory["Cell Menu", None, 
              {Item["Main Menu", "WindowsKeyboardCommands.nb", 
	      IndexTag->"Cell Menu: Main",
                  CopyTag -> "cell"], 
                Item["Convert To Submenu", "WindowsKeyboardCommands.nb", 
	      IndexTag->"Cell Menu: Convert To Submenu",
                  CopyTag -> "cellconvert"], 
                Item["Cell Grouping Submenu", "WindowsKeyboardCommands.nb", 
	      IndexTag->"Cell Menu: Cell Grouping Submenu",
                  CopyTag -> "cellgrouping"]}], 
            BrowserCategory["Format Menu", None, 
              {Item["Main Menu", "WindowsKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Main",
                  CopyTag -> "format"], 
                Item["Style Submenu", "WindowsKeyboardCommands.nb",  
	      IndexTag->"Format Menu: Style Submenu",
                  CopyTag -> "formatstyle"], 
                Item["Face Submenu", "WindowsKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Face Submenu",
                  CopyTag -> "formatface"], 
                Item["Size Submenu", "WindowsKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Size Submenu",
                  CopyTag -> "formatsize"]}], 
            Item["Input Menu", "WindowsKeyboardCommands.nb", 
              CopyTag -> "input"], 
            BrowserCategory["Kernel Menu", None, 
              {Item["Main Menu", "WindowsKeyboardCommands.nb", 
	      IndexTag->"Kernel Menu: Main",
                  CopyTag -> "kernel"], 
                Item["Evaluation Submenu", "WindowsKeyboardCommands.nb",  
	      IndexTag->"Kernel Menu: Evaluation Submenu",
                  CopyTag -> "kernelevaluation"]}], 
            Item["Find Menu", "WindowsKeyboardCommands.nb", 
              CopyTag -> "find"], 
            Item["Help Menu", "WindowsKeyboardCommands.nb", 
              CopyTag -> "help"]}],

(*** ** ** ** ** ** ** ***
            Macintosh Keyboard Shortcuts**********************************)
          BrowserCategory["Macintosh", None, 
          {Item["Nonmenu Commands", "MacKeyboardCommands.nb", 
              CopyTag -> "nonmenu"], Item[Delimiter], 
            Item["All Menus", "MacKeyboardCommands.nb", 
              IndexTag -> {"Macintosh Keyboard Shortcuts"}, 
              CopyTag -> "all"], Item[Delimiter], 
            Item["File Menu", "MacKeyboardCommands.nb", CopyTag -> "file"], 
            BrowserCategory["Edit Menu", None, 
              {Item["Main Menu", "MacKeyboardCommands.nb", 
	      IndexTag->"Edit Menu: Main",
                  CopyTag -> "edit"], 
                Item["Motion Submenu", "MacKeyboardCommands.nb", 
	      IndexTag->"Edit Menu: Motion Submenu",
                  CopyTag -> "editmotion"], 
                Item["Expression Input Submenu", "MacKeyboardCommands.nb",
	      IndexTag->"Edit Menu: Expression Submenu", 
                  CopyTag -> "editexpression"]}], 
            BrowserCategory["Cell Menu", None, 
              {Item["Main Menu", "MacKeyboardCommands.nb", 
	      IndexTag->"Cell Menu: Main",
                  CopyTag -> "cell"], 
                Item["Convert To Submenu", "MacKeyboardCommands.nb", 
	      IndexTag->"Cell Menu: Convert To Submenu",
                  CopyTag -> "cellconvert"], 
                Item["Cell Grouping Submenu", "MacKeyboardCommands.nb", 
	      IndexTag->"Cell Menu: Cell Grouping Submenu",
                  CopyTag -> "cellgrouping"]}], 
            BrowserCategory["Format Menu", None, 
              {Item["Main Menu", "MacKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Main",
                  CopyTag -> "format"], 
                Item["Style Submenu", "MacKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Style Submenu",
                  CopyTag -> "formatstyle"], 
                Item["Face Submenu", "MacKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Face Submenu",
                  CopyTag -> "formatface"], 
                Item["Size Submenu", "MacKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Size Submenu",
                  CopyTag -> "formatsize"]}], 
            Item["Input Menu", "MacKeyboardCommands.nb", CopyTag -> "input"],
            BrowserCategory["Kernel Menu", None, 
              {Item["Main Menu", "MacKeyboardCommands.nb", 
	      IndexTag->"Kernel Menu: Main",
                  CopyTag -> "kernel"], 
                Item["Evaluation Submenu", "MacKeyboardCommands.nb", 
	      IndexTag->"Kernel Menu: Evaluation Submenu",
                  CopyTag -> "kernelevaluation"]}], 
            Item["Find Menu", "MacKeyboardCommands.nb", CopyTag -> "find"], 
            Item["Help Menu", "MacKeyboardCommands.nb", CopyTag -> "help"]}],

(***  ** ** ** ** ** ** ** ** ** ** ** 
              X Window System KeyboardShortcuts*****************************)
          BrowserCategory["X", None, 
          {Item["Nonmenu Commands", "XKeyboardCommands.nb", 
              CopyTag -> "nonmenu"], Item[Delimiter], 
            Item["All Menus", "XKeyboardCommands.nb", 
              IndexTag -> {"X Keyboard Shortcuts"}, CopyTag -> "all"], 
            Item[Delimiter], 
            Item["File Menu", "XKeyboardCommands.nb", CopyTag -> "file"], 
            BrowserCategory["Edit Menu", None, 
              {Item["Main Menu", "XKeyboardCommands.nb", 
	      IndexTag->"Edit Menu: Main",CopyTag -> "edit"], 
                Item["Motion Submenu", "XKeyboardCommands.nb", 
                IndexTag->"Edit Menu: MotionSubmenu",
                CopyTag -> "editmotion"], 
                Item["Expression Input Submenu", "XKeyboardCommands.nb", 
	      IndexTag->"Edit Menu: Expression Submenu",
                  CopyTag -> "editexpression"]}], 
            BrowserCategory["Cell Menu", None, 
              {Item["Main Menu", "XKeyboardCommands.nb", 
	      IndexTag->"Cell Menu: Main",CopyTag -> "cell"], 
                Item["Convert To Submenu", "XKeyboardCommands.nb", 
	      IndexTag->"Cell Menu: Convert To Submenu",
                  CopyTag -> "cellconvert"], 
                Item["Cell Grouping Submenu", "XKeyboardCommands.nb", 
	      IndexTag->"Cell Menu: Cell Grouping Submenu",
                  CopyTag -> "cellgrouping"]}], 
            BrowserCategory["Format Menu", None, 
              {Item["Main Menu", "XKeyboardCommands.nb", 	    
	  IndexTag->"Format Menu: Main",
                  CopyTag -> "format"], 
                Item["Style Submenu", "XKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Style Submenu",
                  CopyTag -> "formatstyle"], 
                Item["Face Submenu", "XKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Face Submenu",
                  CopyTag -> "formatface"], 
                Item["Size Submenu", "XKeyboardCommands.nb", 
	      IndexTag->"Format Menu: Size Submenu",
                  CopyTag -> "formatsize"]}], 
            Item["Input Menu", "XKeyboardCommands.nb", CopyTag -> "input"], 
            BrowserCategory["Kernel Menu", None, 
              {Item["Main Menu", "XKeyboardCommands.nb", 
	      IndexTag->"Kernel Menu: Main",
                  CopyTag -> "kernel"], 
                Item["Evaluation Submenu", "XKeyboardCommands.nb", 
	      IndexTag->"Kernel Menu: Evaluation Submenu",
                  CopyTag -> "kernelevaluation"]}], 
            Item["Find Menu", "XKeyboardCommands.nb", CopyTag -> "find"], 
            Item["Help Menu", "XKeyboardCommands.nb", CopyTag -> "help"]}]}],
    BrowserCategory["2D Expression Input", None, 
      {BrowserCategory["Entering 2D Expressions", None, 
          {Item["Overview", "NotationExamples.nb", CopyTag -> "overview"], 
            Item["Fractions", "NotationExamples.nb", CopyTag -> "fractions"],
            Item["Powers", "NotationExamples.nb", CopyTag -> "powers"], 
            Item["Square Roots", "NotationExamples.nb", 
              CopyTag -> "squareroots"], 
            Item["Radicals", "NotationExamples.nb", CopyTag -> "radicals"], 
            Item["Vectors", "NotationExamples.nb", CopyTag -> "vectors"], 
            Item["Matrices", "NotationExamples.nb", CopyTag -> "matrices"], 
            Item["Subscripts", "NotationExamples.nb", 
              CopyTag -> "subscripts"], 
            Item["Superscripts", "NotationExamples.nb", 
              CopyTag -> "superscripts"], 
            Item["Underscripts", "NotationExamples.nb", 
              CopyTag -> "underscripts"], 
            Item["Overscripts", "NotationExamples.nb", 
              CopyTag -> "overscripts"]}], 
        BrowserCategory["Editing 2D Expressions", None, 
          {Item["Moving through Expressions", "EditingCommands.nb", 
              CopyTag -> "moving"], 
            Item["Selecting and Deleting in Expressions", 
              "EditingCommands.nb", 
              CopyTag -> 
                "selecting"]}]}],


(*Style Sheets*)
Item[Delimiter], 
    BrowserCategory["Style Sheets", None, 
      {BrowserCategory["Introduction", None, 
          {Item["What Is a Style Sheet?", "StyleSheets.nb", 
              CopyTag -> "StyleSheetIntroduction"], 
            Item["Selecting a Style Sheet", "StyleSheets.nb", 
              CopyTag -> "ChangingStyleSheet"], 
            Item["Shared and Private Style Sheets", "StyleSheets.nb", 
              CopyTag -> "SharedPrivateStyleSheets"], 
            Item["Style Sheet File Locations", "StyleSheets.nb", 
              CopyTag -> "StyleSheetLocations"], 
            Item["How Style Sheets Work", "StyleSheets.nb", 
              CopyTag -> "StyleSheetMethod"]}], 
        BrowserCategory["Editing a Style Sheet", None, 
          {Item["Introduction", "StyleSheets.nb", 
              CopyTag -> "EditingIntroduction"], 
            Item["Editing Shared or Private Style Sheets", "StyleSheets.nb", 
              CopyTag -> "EditingSharedPrivate"], 
            Item["Changing Cell Options", "StyleSheets.nb", 
              CopyTag -> "ChangingCellOptions"], 
            Item["Changing Style Environment Options", "StyleSheets.nb", 
              CopyTag -> "ChangingEnvironmentOptions"], 
            Item["Other Editing Tips", "StyleSheets.nb", 
              CopyTag -> "OtherEditingTips"], 
            Item["How Options Are Set", "StyleSheets.nb", 
              CopyTag -> "OptionStoring"]}], 
        BrowserCategory["Default Style Sheets", None, 
          {Item["What Is the Default Style Sheet?", "StyleSheets.nb", 
              CopyTag -> "DefaultStyleSheetIntroduction"], 
            Item["Location of the Default Style Sheet", "StyleSheets.nb", 
              CopyTag -> "DefaultStyleSheetLocation"], 
            Item["Selecting the Default Style Sheet", "StyleSheets.nb", 
              CopyTag -> "ChangingDefaultStyleSheet"], 
            Item["Setting the Default Style Sheet Option", "StyleSheets.nb", 
              CopyTag -> "StoringDefaultStyleSheet"]}], 
        BrowserCategory["Style Environments", None, 
          {Item["What Are Style Environments?", "StyleSheets.nb", 
              CopyTag -> "EnvironmentIntroduction"], 
            Item["Setting On-Screen or Printing Environments", 
              "StyleSheets.nb", CopyTag -> "SettingEnvironments"], 
            Item["How Settings for a Style Are Determined", "StyleSheets.nb",
              CopyTag -> "StyleDefinitionEnvironments"]}], 
        BrowserCategory["Creating Your Own Style Sheet", None, 
          {Item["How to Create Your Own Style Sheet", "StyleSheets.nb", 
              CopyTag -> "CreatingStyleSheet"], 
            Item["Creating New Cell Styles", "StyleSheets.nb", 
              CopyTag -> 
                "NewCellStyles"]}],
	Item[Delimiter],
	Item["Working with Slide Shows", "StyleSheets.nb", 
	CopyTag -> "SlideShowEnvironment"]}],

(****************************************************************************)\
\


(*Option Inspector*)

BrowserCategory["Front End Options", None, 
      {BrowserCategory["Introduction", None, 
          {Item["The Option Inspector", "OptionInspector.nb", 
              CopyTag -> "A1.1"], 
            Item["Inheritance of Options", "OptionInspector.nb", 
              CopyTag -> "A1.2"], 
            Item["Searching for an Option", "OptionInspector.nb", 
              CopyTag -> "A1.3"], 
            Item["Setting Options: An Example", "OptionInspector.nb", 
              CopyTag -> "A1.4"]}], Item[Delimiter], 
        BrowserCategory["Global Options", None, 
          {BrowserCategory["File Locations", None, 
              {Item["NotebookDirectory", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.1"], 
                Item["NotebookPath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.2"], 
                Item["PalettePath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.3"], 
                Item["AutoOpenPalettes", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.4"],  
                Item["AutoOpenNotebooks", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.4b"], 
                Item["StyleSheetPath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.5"], 
                Item["DefaultNotebook", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.6"], 
                Item["DefaultStyleDefinitions", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.7"], 
                Item["PreferencesPath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.8"], 
                Item["ConfigurationPath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.9"], 
                Item["SystemHelpPath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.10"], 
                Item["AddOnHelpPath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.11"], 
                Item["AutoloadPath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.12"], 
                Item["SpellingDictionariesPath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.13"], 
                Item["CharacterEncodingsPath", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.14"], 
                Item["PrivatePaths->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.1.15"]}], 
            BrowserCategory["Data Import/Export Options", None, 
              { Item["ExternalDataCharacterEncoding", "OptionInspector.nb", 
                  CopyTag -> "1.1.3.2"], 
	Item["ImportAutoReplacements", "OptionInspector.nb", 
                  CopyTag -> "1.1.2.0a"], 
	Item["ExportAutoReplacements", "OptionInspector.nb", 
                  CopyTag -> "1.1.2.0b"], 
                Item["OpenSpecialOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.2.1"], 
                Item["ToPostScriptOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.2.2"], 
                Item["ImportTypesetOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.2.2.x"], 
                Item["ExportMultipleCellsOptions->{...}", 
                  "OptionInspector.nb", CopyTag -> "1.1.2.3"], 
                Item["ExportPostScriptOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.2.4"], 
                Item["ExportNativeGraphicsOptions->{...}", 
                  "OptionInspector.nb", CopyTag -> "1.1.2.5"], 
                Item["ExportTypesetOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.2.6"], 
                Item["ExportQuickTimeOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.2.7"], 
                Item["SaveAsSpecialOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.2.8"]}], 
            BrowserCategory["International Options", None, 
              {Item["Language", "OptionInspector.nb", CopyTag -> "1.1.3.1"], 
                Item["ExternalDataCharacterEncoding", "OptionInspector.nb", 
                  CopyTag -> "1.1.3.2"]}], 
            BrowserCategory["System Configuration", None, 
              {Item["StartupSound", "OptionInspector.nb", 
                  CopyTag -> "1.1.4.1"], 
                Item["MultilaunchWarning", "OptionInspector.nb", 
                  CopyTag -> "1.1.4.4"], 
                Item["ScreenRectangle", "OptionInspector.nb", 
                  CopyTag -> "1.1.4.2"], 
                Item["FrontEndStackSize", "OptionInspector.nb", 
                  CopyTag -> "1.1.4.3"],
                Item["\"XPasteFrom\"", "OptionInspector.nb", 
                  CopyTag -> "1.1.4.5"]}], 
            BrowserCategory["Menu Settings", None, 
              {Item["EvaluatorNames", "OptionInspector.nb", 
                  CopyTag -> "1.1.5.1"], 
                Item["NotebooksMenu", "OptionInspector.nb", 
                  CopyTag -> "1.1.5.2"], 
                Item["FontSubstitutions", "OptionInspector.nb", 
                  CopyTag -> "1.1.5.3"], 
                Item["DefaultFontProperties", "OptionInspector.nb", 
                  CopyTag -> "1.1.5.4"], 
                Item["BoxFormFormatTypes", "OptionInspector.nb", 
                  CopyTag -> "1.1.5.5"]}], 
            BrowserCategory["Dialog Settings", None, 
              {Item["FindSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.1"], 
                Item["EditCellTagsSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.2"], 
                Item["ViewPointSelectorSettings->{...}", 
                  "OptionInspector.nb", CopyTag -> "1.1.6.3"], 
                Item["ColorSelectorSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.4"], 
                Item["GridCreationSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.5"],
                Item["NotebookStatisticsSettings->{...}", 
                  "OptionInspector.nb", CopyTag -> "1.1.6.7"], 
                Item["OptionInspectorSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.8"], 
                Item["EditButtonSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.9"], 
                Item["BackgroundTasksSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.10"], 
                Item["InterruptSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.11"], 
                Item["InputSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.12"], 
                Item["HelpBrowserSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.13"], 
                Item["ErrorsDialogSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.14"], 
                Item["StyleNameDialogSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.15"], 
                Item["FileNameDialogSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.16"], 
                Item["NotebookConvertSettings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.1.6.17"]}], 
            BrowserCategory["MessageOptions", None, 
              {Item["\"WarningAction\"", "OptionInspector.nb", 
                  CopyTag -> "1.1.7.1"], 
                Item["\"ErrorAction\"", "OptionInspector.nb", 
                  CopyTag -> "1.1.7.2"], 
                Item["\"ConsoleMessageAction\"", "OptionInspector.nb", 
                  CopyTag -> "1.1.7.3"], 
                Item["\"KernelMessageAction\"", "OptionInspector.nb", 
                  CopyTag -> "1.1.7.4"], 
                Item["\"ExplainBeepHelp\"", "OptionInspector.nb", 
                  CopyTag -> "1.1.7.6"], 
                Item["\"MathMLPasteWarning\"", "OptionInspector.nb", 
                  CopyTag -> "MathMLPasteWarning"],
                Item["\"InsufficientVersionWarning\"", "OptionInspector.nb", 
                  CopyTag -> "InsufficientVersionWarning"],
                Item["\"IgnoreTagBoxDeletionWarning\"", "OptionInspector.nb",
                  CopyTag -> "1.1.7.7"], 
                Item["\"TraditionalFormEvaluationWarning\"", 
                  "OptionInspector.nb", CopyTag -> "1.1.7.8"], 
                Item["\"AllowDisablingWarnings\"", "OptionInspector.nb", 
                  CopyTag -> "1.1.7.9"]}]}], 
        BrowserCategory["Notebook Options", None, 
          {BrowserCategory["File Options", None, 
              {Item["NotebookAutoSave", "OptionInspector.nb", 
                  CopyTag -> "1.2.1.1"], 
	Item["ClosingAutoSave", "OptionInspector.nb", 
                  CopyTag -> "1.2.1.1a"],
                Item["IncludeFileExtension", "OptionInspector.nb", 
                  CopyTag -> "1.2.1.2"], 
                Item["AutoGeneratedPackage", "OptionInspector.nb", 
                  CopyTag -> "1.2.1.3"], 
                Item["Editable", "OptionInspector.nb", 
                  CopyTag -> "1.2.1.4"],
                Item["Saveable", "OptionInspector.nb", 
                  CopyTag -> "Saveable"]}], 
            BrowserCategory["Display Options", None, 
              {Item["ScreenStyleEnvironment", "OptionInspector.nb", 
                  CopyTag -> "1.2.2.1"], 
                Item["PrintingStyleEnvironment", "OptionInspector.nb", 
                  CopyTag -> "1.2.2.2"], 
                Item["ShowPageBreaks", "OptionInspector.nb", 
                  CopyTag -> "1.2.2.3"], 
                Item["WindowToolbars", "OptionInspector.nb", 
                  CopyTag -> "1.2.2.4"], 
                Item["RulerUnits", "OptionInspector.nb", 
                  CopyTag -> "1.2.2.5"], 
                Item["Background", "OptionInspector.nb", 
                  CopyTag -> "NotebookBackground"], 
                Item["Magnification", "OptionInspector.nb", 
                  CopyTag -> "1.2.2.7"]}], 
            BrowserCategory["Evaluation Options", None, 
              {Item["Evaluator", "OptionInspector.nb", CopyTag -> "1.2.3.1"],
                Item["EvaluationCompletionAction", "OptionInspector.nb", 
                  CopyTag -> "1.2.3.2"], 
                Item["PrintAction", "OptionInspector.nb", 
                  CopyTag -> "1.2.3.3"], 
                Item["OutputAutoOverwrite", "OptionInspector.nb", 
                  CopyTag -> "1.2.3.4"], 
                Item["InitializationCellEvaluation", "OptionInspector.nb", 
                  CopyTag -> "1.2.3.5"], 
                Item["InitializationCellWarning", "OptionInspector.nb", 
                  CopyTag -> "1.2.3.6"]}], 
            BrowserCategory["Notebook Properties", None, 
              {Item["Editable", "OptionInspector.nb", CopyTag -> "1.2.4.1"], 
                Item["Selectable", "OptionInspector.nb", 
                  CopyTag -> "1.2.4.2"], 
                Item["Deletable", "OptionInspector.nb", 
                  CopyTag -> "1.2.4.3"], 
                Item["CellGrouping", "OptionInspector.nb", 
                  CopyTag -> "1.2.4.4"], 
                Item["PageWidth", "OptionInspector.nb", 
                  CopyTag -> "1.2.4.5"]}], 
            BrowserCategory["Window Properties", None, 
              {Item["WindowFrame", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.3"], 
                Item["WindowElements", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.4"], 
                Item["WindowFrameElements", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.5"], 
                Item["WindowClickSelect", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.6"], 
                Item["WindowFloating", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.7"], 
                Item["WindowMovable", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.8"], 
                Item["WindowTitle", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.9"], 
                Item["Visible", "OptionInspector.nb", CopyTag -> "1.2.5.10"],
                Item["WindowSize", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.1"], 
                Item["WindowMargins", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.2"], 
                Item["ScrollingOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.2.5.12"]}], 
            BrowserCategory["Printing Options", None, 
              {Item["PrintingStyleEnvironment", "OptionInspector.nb", 
                  CopyTag -> "1.2.2.2"], 
                Item["ScreenStyleEnvironment", "OptionInspector.nb", 
                  CopyTag -> "1.2.2.1"], 
                Item["PrintingCopies", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.1"], 
                Item["PrintingStartingPageNumber", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.2"], 
                Item["PrintingPageRange", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.3"], 
                Item["PageHeaders", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.6"], 
                Item["PageFooters", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.7"], 
                Item["PageHeaderLines", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.8"], 
                Item["PageFooterLines", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.9"], 
                Item["PrintingOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.13"]}], 
            BrowserCategory["PrivateNotebookOptions->{...}", None, 
              {Item["\"SafeFileSave\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.14.1"], 
                Item["\"SafeFileOpen\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.14.1b"],   
                Item["\"DoubleBuffer\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.14.2"], 
                Item["\"ColorPalette\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.14.3"], 
                Item["\"BackgroundPostScriptRendering\"","OptionInspector.nb",\
 
                  CopyTag -> "1.2.6.14.4"], 
                Item["\"RealTimeMarginAdjustment\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.14.5"], 
                Item["\"RealTimeWindowMove\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.14.6"], 
                Item["\"RealTimeWindowResize\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.14.7"], 
                Item["\"ShortBoxForm\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.14.8"]}], 
            BrowserCategory["IndexCreationOptions->{...}", None, 
              {Item["\"Format\"", "OptionInspector.nb", CopyTag \
->"1.2.6.15.1"], 
                Item["\"Ellipsis\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.15.2"], 
                Item["\"MultiPageContinuation\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.15.3"], 
                Item["\"PageSeparator\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.15.4"], 
                Item["\"SectionSeparator\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.15.5"], 
                Item["\"MainEntry\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.15.6"], 
                Item["\"MainPage\"", "OptionInspector.nb", 
                  CopyTag -> "1.2.6.15.7"]}]}], 
        BrowserCategory["Cell Options", None, 
          {BrowserCategory["Display Options", None, 
              {Item["CellFrame", "OptionInspector.nb", CopyTag -> "1.3.1.1"],
                Item["CellDingbat", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.2"], 
                Item["Background", "OptionInspector.nb", IndexTag->"Cell \
Options Background",
                  CopyTag -> "CellBackground"], 
                Item["Magnification", "OptionInspector.nb", 
                  CopyTag -> "1.2.2.7"], 
                Item["ShowCellBracket", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.3"], 
                Item["ShowSelection", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.4"], 
                Item["ShowGroupOpenCloseIcon", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.5"], 
                Item["ShowClosedCellArea", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.6"], 
                Item["ShowShortBoxForm", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.7"], 
                Item["CellDisplayCache", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.8"], 
                Item["CellMargins", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.9"], 
                Item["CellBracketOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.10"], 
                Item["CellElementSpacings->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.11"],
	Item["PrivateCellOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "1.3.1.12"]}], 
            BrowserCategory["General Properties", None, 
              {Item["Active", "OptionInspector.nb", CopyTag -> "1.3.2.1"], 
                Item["CellEditDuplicate", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.2"], 
                Item["Evaluatable", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.3"], 
                Item["Editable", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.14"], 
                Item["Deletable", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.16"], 
                Item["Copyable", "OptionInspector.nb", CopyTag -> "1.3.2.4"],
                Item["Selectable", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.15"], 
                Item["CellOpen", "OptionInspector.nb", CopyTag -> "1.3.2.5"],
                Item["CellGroupingRules", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.6"], 
                Item["ConversionRules", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.7"], 
                Item["TaggingRules", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.8"], 
                Item["CellHorizontalScrolling", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.10"], 
                Item["StyleMenuListing", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.11"], 
                Item["ButtonStyleMenuListing", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.12"], 
                Item["CounterStyleMenuListing", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.12a"], 
                Item["FormatTypeAutoConvert", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.13"]}], 
            BrowserCategory["Page Breaking", None, 
              {Item["PageBreakAbove", "OptionInspector.nb", 
                  CopyTag -> "1.3.3.1"], 
                Item["PageBreakWithin", "OptionInspector.nb", 
                  CopyTag -> "1.3.3.2"], 
                Item["PageBreakBelow", "OptionInspector.nb", 
                  CopyTag -> "1.3.3.3"], 
                Item["GroupPageBreakWithin", "OptionInspector.nb", 
                  CopyTag -> "1.3.3.4"]}], 
            BrowserCategory["Evaluation Options", None, 
              {Item["Evaluator", "OptionInspector.nb", CopyTag -> "1.3.4.5"],
                Item["Evaluatable", "OptionInspector.nb", 
                  CopyTag -> "1.3.2.3"], 
                Item["InitializationCell", "OptionInspector.nb", 
                  CopyTag -> "1.3.4.1"], 
                Item["CellEvaluationDuplicate", "OptionInspector.nb", 
                  CopyTag -> "1.3.4.2"], 
                Item["GeneratedCell", "OptionInspector.nb", 
                  CopyTag -> "1.3.4.3"], 
                Item["CellAutoOverwrite", "OptionInspector.nb", 
                  CopyTag -> "1.3.4.4"], 
                Item["PrivateEvaluationOptions->{...}", "OptionInspector.nb",
                  CopyTag -> "1.3.4.6"]}], 
            BrowserCategory["Cell Labels", None, 
              {Item["CellLabel", "OptionInspector.nb", CopyTag -> "1.3.5.1"],
                Item["ShowCellLabel", "OptionInspector.nb", 
                  CopyTag -> "1.3.5.2"], 
                Item["CellLabelPositioning", "OptionInspector.nb", 
                  CopyTag -> "1.3.5.3"], 
                Item["CellLabelAutoDelete", "OptionInspector.nb", 
                  CopyTag -> "1.3.5.4"], 
                Item["CellLabelMargins", "OptionInspector.nb", 
                  CopyTag -> "1.3.5.5"]}], 
            BrowserCategory["Cell Frame Options", None, 
              {Item["CellFrame", "OptionInspector.nb", CopyTag -> "1.3.6.1"],
                Item["CellFrameMargins", "OptionInspector.nb", 
                  CopyTag -> "1.3.6.2"], 
                Item["CellFrameColor", "OptionInspector.nb", 
                  CopyTag -> "1.3.6.3"], 
                Item["CellFrameLabelMargins", "OptionInspector.nb", 
                  CopyTag -> "1.3.6.4"], 
                Item["CellFrameLabels", "OptionInspector.nb", 
                  CopyTag -> "1.3.6.5"]}], 
            BrowserCategory["Cell Tags", None, 
              {Item["ShowCellTags", "OptionInspector.nb", 
                  CopyTag -> "1.3.7.1"]}], 
            BrowserCategory["Inline Cell Options", None, 
              {Item["CellBaseline", "OptionInspector.nb", 
                  CopyTag -> "1.3.8.2"], 
                Item["CellSize", "OptionInspector.nb", 
                  CopyTag -> "1.3.8.1"]}], 
            BrowserCategory["New Cell Defaults", None, 
              {Item["DefaultNewCellStyle", "OptionInspector.nb", 
                  CopyTag -> "1.3.9.1"], 
                Item["DefaultNewInlineCellStyle", "OptionInspector.nb", 
                  CopyTag -> "1.3.9.2"], 
                Item["DefaultDuplicateCellStyle", "OptionInspector.nb", 
                  CopyTag -> "1.3.9.3"], 
                Item["DefaultFormatType", "OptionInspector.nb", 
                  CopyTag -> "1.3.9.4"], 
                Item["DefaultInlineFormatType", "OptionInspector.nb", 
                  CopyTag -> "1.3.9.5"], 
                Item["CommonDefaultFormatTypes->{...}", "OptionInspector.nb",
                  CopyTag -> "1.3.9.6"]}]}], 

        BrowserCategory["Editing Options", None, 
          {Item["Editable", "OptionInspector.nb", CopyTag -> "2.2.17"], 
            Item["Deletable", "OptionInspector.nb", CopyTag -> "2.2.19"], 
            Item["Selectable", "OptionInspector.nb", CopyTag -> "2.2.18"], 
            Item["AutoIndent", "OptionInspector.nb", CopyTag -> "2.2.2"], 
            Item["InputAliases", "OptionInspector.nb", CopyTag -> "2.2.3"], 
            Item["InputAutoReplacements", "OptionInspector.nb", 
              CopyTag -> "2.2.4"], 
            Item["DelimiterFlashTime", "OptionInspector.nb", 
              CopyTag -> "2.2.5"], 
            Item["ShowCursorTracker", "OptionInspector.nb", 
              CopyTag -> "2.2.6"], 
            Item["ShowAutoStyles", "OptionInspector.nb", CopyTag -> "2.2.8"],
            Item["StructuredSelection", "OptionInspector.nb", 
              CopyTag -> "2.2.10"], 
            Item["StyleBoxAutoDelete", "OptionInspector.nb", 
              CopyTag -> "2.2.11"], 
            Item["DragAndDrop", "OptionInspector.nb", CopyTag -> "2.2.12"], 
            Item["ShowSpecialCharacters", "OptionInspector.nb", 
              CopyTag -> "2.2.13"], 
            Item["AllowInlineCells", "OptionInspector.nb", 
              CopyTag -> "2.2.14"], 
            Item["PasteBoxFormInlineCells", "OptionInspector.nb", 
              CopyTag -> "2.2.15"],
            BrowserCategory["Private Editing Options->{...}", None, 
              { \
Item["\"TwoByteSyntaxCharacterAutoReplacement\"","OptionInspector.nb", 
                  CopyTag -> "2.2.17a"], 
	Item["\"CursorTrackerParameters\"", "OptionInspector.nb", 
                  CopyTag -> "2.2.17b"],
	Item["AutoStyleOptions", "OptionInspector.nb", 
                  CopyTag -> "2.2.17c"]}]}], 

        BrowserCategory["Formatting Options", None, 
          {BrowserCategory["Font Options", None, 
              {Item["FontFamily", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.3"], 
                Item["FontSize", "OptionInspector.nb", CopyTag -> "2.3.2.2"],
                Item["FontWeight", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.4"], 
                Item["FontSlant", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.5"], 
                Item["FontTracking", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.6"], 
                Item["FontColor", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.7"], 
                Item["Background", "OptionInspector.nb", IndexTag -> "Font \
Options Background",
                  CopyTag -> "FontOptionsBackground"], 
                Item["CharacterEncoding", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.9"], 
                Item["Magnification", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.10"], 
                Item["FontVariations->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.11"], 
                Item["FontProperties->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.12"], 
                Item["PrivateFontOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.2.13"]}], 
            BrowserCategory["Text Layout Options", None, 
              {Item["PageWidth", "OptionInspector.nb", CopyTag -> "1.2.4.5"],
                Item["TextAlignment", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.2"], 
                Item["TextJustification", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.3"], 
                Item["Hyphenation", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.11"], 
                Item["TabFilling", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.4"], 
                Item["ParagraphIndent", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.7"], 
                Item["AutoIndent", "OptionInspector.nb", CopyTag -> "2.2.2"],
                Item["TabSpacings", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.8"], 
                Item["AutoItalicWords", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.9"], 
                Item["HyphenationOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.10"], 
                Item["LineSpacing", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.5"], 
                Item["ParagraphSpacing", "OptionInspector.nb", 
                  CopyTag -> "2.3.3.6"]}], 
            BrowserCategory["Text Content Options", None, 
              {Item["LanguageCategory", "OptionInspector.nb", 
                  CopyTag -> "2.3.4.2"], 
                Item["DefaultNaturalLanguage", "OptionInspector.nb", 
                  CopyTag -> "2.3.4.3"], 
                Item["SpellingOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.4.4"], 
                Item["SpellingDictionaries->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.4.5"]}], 

BrowserCategory["ExpressionFormatting", None, 
              {Item["FormatType", "OptionInspector.nb", 
                  CopyTag -> "2.3.5"]}], 
            BrowserCategory["...Display Options", None, 
              {Item["AutoSpacing", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.2x"], 
                Item["ShowContents", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.3x"], 
                Item["ScriptSizeMultipliers", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.4x"], 
                Item["ScriptMinSize", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.5x"], 
                Item["ScriptLevel", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.6x"], 
                Item["ShowSpecialCharacters", "OptionInspector.nb", 
                  CopyTag -> "2.2.13"], 
                Item["ShowStringCharacters", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.7x"], 
                Item["NumberMarks", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.8x"], 
                Item["PrintPrecision", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.9x"], 
                Item["NumberMultiplier", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.10x"], 
                Item["LimitsPositioning", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.11x"], 
                Item["LimitsPositioningTokens", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.12x"], 
                Item["ScriptBaselineShifts", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.13x"]}], 
            BrowserCategory["...Traditional Notation Options", None, 
              {Item["SingleLetterItalics", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.17x"], 
                Item["TraditionalFunctionNotation", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18x"], 
                Item["DelimiterMatching", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.19x"], 
                Item["ZeroWidthTimes", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.20x"]}], 
            BrowserCategory["...Specific Box Options", None, 
              {Item["AdjustmentBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.1"], 
                Item["ButtonBoxOptions->{...}", "OptionInspector.nb", \
IndexTag -> "Button Box Options",
                  CopyTag -> "2.3.5.18.2"], 
                Item["CounterBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.3"], 
                Item["ValueBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.3a"], 
                Item["OptionValueBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.3b"], 
                Item["ErrorBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.4"], 
	   Item["FormBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.4a"], 
                Item["FractionBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.5"], 
                Item["FrameBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.6"], 
                Item["GridBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.7"], 
                Item["InterpretationBoxOptions->{...}", "OptionInspector.nb",
                  CopyTag -> "2.3.5.18.8"], 
                Item["RadicalBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.10"], 
                Item["SqrtBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.11"], 
                Item["SubscriptBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.12"], 
                Item["SubsuperscriptBoxOptions->{...}", "OptionInspector.nb",
                  CopyTag -> "2.3.5.18.13"], 
                Item["SuperscriptBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.14"], 
                Item["TagBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.15"],
                Item["UnderscriptBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.16"],
                Item["OverscriptBoxOptions->{...}", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.18.17"],
                Item["UnderoverScriptBoxOptions->{...}","OptionInspector.nb", \

                  CopyTag -> "2.3.5.18.18"]}], 
            BrowserCategory["...Spanning Character Options", None, 
              {Item["SpanMinSize", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.19.1"], 
                Item["SpanMaxSize", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.19.2"], 
                Item["SpanSymmetric", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.19.3"], 
                Item["SpanLineThickness", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.19.4"], 
                Item["SpanCharacterRounding", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.19.5"], 
                Item["SpanAdjustments", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.19.6"]}], 
            BrowserCategory["...Linebreaking Options", None, 
              {Item["LineBreakWithin", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.20.1"], 
                Item["LineIndent", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.20.2"], 
                Item["IndentMaxFraction", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.20.3"], 
                Item["LineBreakAdjustments", "OptionInspector.nb", 
                  CopyTag -> "2.3.5.20.4"]}], 
            BrowserCategory["Table/Matrix/Palette Formatting", None, 
              {Item["Global Options", "OptionInspector.nb", 
                  CopyTag -> "2.3.6.2"], 
                Item["Row Options", "OptionInspector.nb", 
                  CopyTag -> "2.3.6.3"], 
                Item["Column Options", "OptionInspector.nb", 
                  CopyTag -> "2.3.6.4"], 
                Item["Line Drawing Options", "OptionInspector.nb", 
                  CopyTag -> "2.3.6.5"]}], 
            BrowserCategory["Automatic Numbering Options", None, 
              {Item["Counter Assignment and Incrementing", 
                  "OptionInspector.nb", CopyTag -> "2.3.7.2"], 
                Item["Counter Display Options", "OptionInspector.nb", 
                  CopyTag -> "2.3.7.3"]}]}], 
        BrowserCategory["Graphics Options", None, 
          {BrowserCategory["Image Bounding Box", None, 
              {Item["AspectRatioFixed", "OptionInspector.nb", 
                  CopyTag -> "2.4.2.2"], 
                Item["ImageSize", "OptionInspector.nb", 
                  CopyTag -> "2.4.2.3"], 
                Item["ImageMargins", "OptionInspector.nb", 
                  CopyTag -> "2.4.2.4"], 
                Item["ImageRegion", "OptionInspector.nb", 
                  CopyTag -> "2.4.2.5"]}], 
            BrowserCategory["Animation", None, 
              {Item["AnimationDisplayTime", "OptionInspector.nb", 
                  CopyTag -> "2.4.3.2"], 
                Item["AnimationCycleOffset", "OptionInspector.nb", 
                  CopyTag -> "2.4.3.3"], 
                Item["AnimationCycleRepetitions", "OptionInspector.nb", 
                  CopyTag -> "2.4.3.4"]}], 
            BrowserCategory["RenderingOptions", None, 
              {Item["\"DrawDummyGraphics\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.2"], 
	    Item["\"RenderIncrementally\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.2b"],
                Item["\"RenderFilledAreas\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.3"], 
                Item["\"RenderLines\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.4"], 
                Item["\"RenderThickness\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.5"],
                Item["\"RenderSystemColors\"", "OptionInspector.nb", 
                  CopyTag -> "RenderSystemColors"], 
                Item["\"ObjectDithering\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.6"], 
                Item["\"RasterDithering\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.7"], 
                Item["\"ImageHalftoneDensity\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.8"], 
                Item["\"ImageHalftoneAngle\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.9"], 
                Item["\"ImageCacheDepth\"", "OptionInspector.nb", 
                  CopyTag -> "2.4.4.12"]}]}], 
        BrowserCategory["Button Options", None, 
          {Item["ButtonStyle", "OptionInspector.nb", CopyTag -> "2.5.2"], 
            BrowserCategory["Action Options", None, 
              {Item["Active", "OptionInspector.nb", CopyTag -> "2.5.3.2"], 
                Item["ButtonFunction", "OptionInspector.nb", 
                  CopyTag -> "2.5.3.3"], 
                Item["ButtonSource", "OptionInspector.nb", 
                  CopyTag -> "2.5.3.4"], 
                Item["ButtonData", "OptionInspector.nb", 
                  CopyTag -> "2.5.3.6"], 
                Item["ButtonEvaluator", "OptionInspector.nb", 
                  CopyTag -> "2.5.3.5"]}], 
            BrowserCategory["Display Options", None, 
              {Item["ButtonFrame", "OptionInspector.nb", 
                  CopyTag -> "2.5.4.2"], 
                Item["Background", "OptionInspector.nb", IndexTag -> "Button \
Background",
                  CopyTag -> "ButtonBackground"], 
                Item["ButtonExpandable", "OptionInspector.nb", 
                  CopyTag -> "2.5.4.5"], 
                Item["ButtonMinHeight", "OptionInspector.nb", 
                  CopyTag -> "2.5.4.6"], 
                Item["ButtonNote", "OptionInspector.nb", 
                  CopyTag -> "2.5.4.7"], 
                Item["ButtonMargins", "OptionInspector.nb", 
                  CopyTag -> 
                    "2.5.4.4"]}]}]}],
                    
                    
BrowserCategory["Front End Tokens", None,
	{Item["Introduction", "FrontEndTokens.nb", CopyTag->"FrontEndTokenIntro", IndexTag -> "Front End Tokens: Introduction"],
	 Item[Delimiter],
	 	{BrowserCategory["File Menu", None,
	 	{Item["New", "FrontEndTokens.nb", CopyTag->"New"], 
	 	 Item["Open", "FrontEndTokens.nb", CopyTag->"Open"],
	 	 Item["Close", "FrontEndTokens.nb", CopyTag->"Close"],
	 	 Item["Save", "FrontEndTokens.nb", CopyTag->"Save"],
	 	 Item["SaveRename", "FrontEndTokens.nb", CopyTag->"SaveRename"],
	 	 Item["SaveRenameSpecial", "FrontEndTokens.nb", \
CopyTag->"SaveRenameSpecial"],
	 	 Item["Revert", "FrontEndTokens.nb", CopyTag->"Revert"],
	 	 Item["OpenSpecial", "FrontEndTokens.nb", CopyTag->"OpenSpecial"],
	 	 Item["Import", "FrontEndTokens.nb", CopyTag->"Import"],
	 	 Item["NotebookMail", "FrontEndTokens.nb", CopyTag->"NotebookMail"],
	 	 Item["NotebookMailSelection", "FrontEndTokens.nb", \
CopyTag->"NotebookMailSelection"],
	 	 Item["GeneratePalette", "FrontEndTokens.nb", CopyTag->"GeneratePalette"],
	 	 Item["GenerateNotebook", "FrontEndTokens.nb", \
CopyTag->"GenerateNotebook"],
	 	 Item["SystemPrintOptionsDialog", "FrontEndTokens.nb", \
CopyTag->"SystemPrintOptionsDialog"],
	 	 Item["PrintOptionsDialog", "FrontEndTokens.nb", \
CopyTag->"PrintOptionsDialog"],
	 	 Item["HeadersFootersDialog", "FrontEndTokens.nb", \
CopyTag->"HeadersFootersDialog"],
	 	 Item["PrintDialog", "FrontEndTokens.nb", CopyTag->"PrintDialog"],
	 	 Item["PrintSelectionDialog", "FrontEndTokens.nb", \
CopyTag->"PrintSelectionDialog"],
	 	 Item["FrontEndQuit", "FrontEndTokens.nb", CopyTag->"FrontEndQuit"]
	 	 }]},
	 	 
	 	 {BrowserCategory["Edit Menu", None,
	 	{Item["Undo", "FrontEndTokens.nb", CopyTag->"Undo"], 
	 	 Item["Cut", "FrontEndTokens.nb", CopyTag->"Cut"],
	 	 Item["Copy", "FrontEndTokens.nb", CopyTag->"Copy"],
	 	 Item["Paste", "FrontEndTokens.nb", CopyTag->"Paste"],
	 	 Item["Clear", "FrontEndTokens.nb", CopyTag->"Clear"],
	 	 Item["CopySpecial", "FrontEndTokens.nb", CopyTag->"CopySpecial"],
	 	 Item["PasteSpecial", "FrontEndTokens.nb", CopyTag->"PasteSpecial"],
	 	 Item["PasteApply", "FrontEndTokens.nb", CopyTag->"PasteApply"],
	 	 Item["PasteDiscard", "FrontEndTokens.nb", CopyTag->"PasteDiscard"],
	 	 Item["SelectionSaveSpecial", "FrontEndTokens.nb", \
CopyTag->"SelectionSaveSpecial"],
	 	 Item["SelectAll", "FrontEndTokens.nb", CopyTag->"SelectAll"],
	 	 Item["InsertObject", "FrontEndTokens.nb", CopyTag->"InsertObject"],
	 	 Item["MoveNext", "FrontEndTokens.nb", CopyTag->"MoveNext"],
	 	 Item["MovePrevious", "FrontEndTokens.nb", CopyTag->"MovePrevious"],
	 	 Item["DeleteNext", "FrontEndTokens.nb", CopyTag->"DeleteNext"],
	 	 Item["DeletePrevious", "FrontEndTokens.nb", CopyTag->"DeletePrevious"],
	 	 Item["MoveNextWord", "FrontEndTokens.nb", CopyTag->"MoveNextWord"],
	 	 Item["MovePreviousWord", "FrontEndTokens.nb", \
CopyTag->"MovePreviousWord"],
	 	 Item["DeleteNextWord", "FrontEndTokens.nb", CopyTag->"DeleteNextWord"],
	 	 Item["DeletePreviousWord", "FrontEndTokens.nb", \
CopyTag->"DeletePreviousWord"],
	 	 Item["MoveLineEnd", "FrontEndTokens.nb", CopyTag->"MoveLineEnd"],
	 	 Item["MoveLineBeginning", "FrontEndTokens.nb", \
CopyTag->"MoveLineBeginning"],
	 	 Item["MoveNextLine", "FrontEndTokens.nb", CopyTag->"MoveNextLine"],
	 	 Item["MovePreviousLine", "FrontEndTokens.nb", \
CopyTag->"MovePreviousLine"],
	 	 Item["Superscript", "FrontEndTokens.nb", CopyTag->"Superscript"],
	 	 Item["Subscript", "FrontEndTokens.nb", CopyTag->"Subscript"],
	 	 Item["Above", "FrontEndTokens.nb", CopyTag->"Above"],
	 	 Item["Below", "FrontEndTokens.nb", CopyTag->"Below"],
	 	 Item["Otherscript", "FrontEndTokens.nb", CopyTag->"Otherscript"],
	 	 Item["Fraction", "FrontEndTokens.nb", CopyTag->"Fraction"],
	 	 Item["Radical", "FrontEndTokens.nb", CopyTag->"Radical"],
	 	 Item["NewRow", "FrontEndTokens.nb", CopyTag->"NewRow"],
	 	 Item["NewColumn", "FrontEndTokens.nb", CopyTag->"NewColumn"],
	 	 Item["MoveExpressionEnd", "FrontEndTokens.nb", \
CopyTag->"MoveExpressionEnd"],
	 	 Item["ExpandSelection", "FrontEndTokens.nb", CopyTag->"ExpandSelection"],
	 	 Item["CreateInlineCell", "FrontEndTokens.nb", \
CopyTag->"CreateInlineCell"],
	 	 Item["MoveNextCell", "FrontEndTokens.nb", CopyTag->"MoveNextCell"],
	 	 Item["InsertRawExpression", "FrontEndTokens.nb", \
CopyTag->"InsertRawExpression"],
	 	 Item["AddInterpretation", "FrontEndTokens.nb", \
CopyTag->"AddInterpretation"],
	 	 Item["NudgeLeft", "FrontEndTokens.nb", CopyTag->"NudgeLeft"],
	 	 Item["NudgeRight", "FrontEndTokens.nb", CopyTag->"NudgeRight"],
	 	 Item["NudgeUp", "FrontEndTokens.nb", CopyTag->"NudgeUp"],
	 	 Item["NudgeDown", "FrontEndTokens.nb", CopyTag->"NudgeDown"],
	 	 Item["RemoveAdjustments", "FrontEndTokens.nb", \
CopyTag->"RemoveAdjustments"],
	 	 Item["Make2D", "FrontEndTokens.nb", CopyTag->"Make2D"],
	 	 Item["Balance", "FrontEndTokens.nb", CopyTag->"Balance"],
	 	 Item["FindNextMisspelling", "FrontEndTokens.nb", \
CopyTag->"FindNextMisspelling"],
	 	 Item["OptionsDialog", "FrontEndTokens.nb", CopyTag->"OptionsDialog"]
	 	 }]},
	 
	 	 {BrowserCategory["Cell Menu", None,
	 	{Item["SelectionConvert", "FrontEndTokens.nb", \
CopyTag->"SelectionConvert"], 
	 	 Item["SelectionDisplayAs", "FrontEndTokens.nb", \
CopyTag->"SelectionDisplayAs"],
	 	 Item["CellGroup", "FrontEndTokens.nb", CopyTag->"CellGroup"],
	 	 Item["CellUngroup", "FrontEndTokens.nb", CopyTag->"CellUngroup"],
	 	 Item["SelectionOpenAllGroups", "FrontEndTokens.nb", \
CopyTag->"SelectionOpenAllGroups"],
	 	 Item["SelectionCloseAllGroups", "FrontEndTokens.nb", \
CopyTag->"SelectionCloseAllGroups"],
	 	 Item["OpenCloseGroup", "FrontEndTokens.nb", CopyTag->"OpenCloseGroup"],
	 	 Item["CellSplit", "FrontEndTokens.nb", CopyTag->"CellSplit"],
	 	 Item["CellMerge", "FrontEndTokens.nb", CopyTag->"CellMerge"],
	 	 Item["SelectionAnimate", "FrontEndTokens.nb", \
CopyTag->"SelectionAnimate"],
	 	 Item["SoundPlay", "FrontEndTokens.nb", CopyTag->"SoundPlay"],
	 	 Item["GraphicsRender", "FrontEndTokens.nb", CopyTag->"GraphicsRender"],
	 	 Item["GenerateImageCaches", "FrontEndTokens.nb", \
CopyTag->"GenerateImageCaches"],
	 	 Item["GraphicsOriginalSize", "FrontEndTokens.nb", \
CopyTag->"GraphicsOriginalSize"],
	 	 Item["GraphicsAlign", "FrontEndTokens.nb", CopyTag->"GraphicsAlign"],
	 	 Item["NotebookStatisticsDialog", "FrontEndTokens.nb", \
CopyTag->"NotebookStatisticsDialog"]
	 	 }]},
	 	 
	 	  {BrowserCategory["Format Menu", None,
	 	{Item["StyleOther", "FrontEndTokens.nb", CopyTag->"StyleOther"], 
	 	 Item["ToggleShowExpression", "FrontEndTokens.nb", \
CopyTag->"ToggleShowExpression"],
	 	 Item["ClearCellOptions", "FrontEndTokens.nb", \
CopyTag->"ClearCellOptions"],
	 	 Item["StyleDefinitionsOther", "FrontEndTokens.nb", \
CopyTag->"StyleDefinitionsOther"],
	 	 Item["EditStyleDefinitions", "FrontEndTokens.nb", \
CopyTag->"EditStyleDefinitions"],
	 	 Item["PlainFont", "FrontEndTokens.nb", CopyTag->"PlainFont"],
	 	 Item["FontSizeDialog", "FrontEndTokens.nb", CopyTag->"FontSizeDialog"],
	 	 Item["FontColorDialog", "FrontEndTokens.nb", CopyTag->"FontColorDialog"],
	 	 Item["ToggleGrayBox", "FrontEndTokens.nb", CopyTag->"ToggleGrayBox"],
	 	 Item["BackgroundDialog", "FrontEndTokens.nb", \
CopyTag->"BackgroundDialog"],
	 	 Item["FontPanel", "FrontEndTokens.nb", CopyTag->"FontPanel"],
	 	 Item["FixCellHeight", "FrontEndTokens.nb", CopyTag->"FixCellHeight"],
	 	 Item["FixCellWidth", "FrontEndTokens.nb", CopyTag->"FixCellWidth"],
	 	 Item["ToggleOptionListElement", "FrontEndTokens.nb", \
CopyTag->"ToggleOptionListElement"],
	 	 Item["ShowPageBreaks", "FrontEndTokens.nb", CopyTag->"ShowPageBreaks"]
	 	 }]},
	 	 
	 	  {BrowserCategory["Input Menu", None,
	 	{Item["GraphicsCoordinatesDialog", "FrontEndTokens.nb", \
CopyTag->"GraphicsCoordinatesDialog"],
	 	 Item["ViewPointSelectorDialog", "FrontEndTokens.nb", \
CopyTag->"ViewPointSelectorDialog"],
	 	 Item["ColorSelectorDialog", "FrontEndTokens.nb", \
CopyTag->"ColorSelectorDialog"], 
	 	 Item["RecordSoundDialog", "FrontEndTokens.nb", \
CopyTag->"RecordSoundDialog"],
	 	 Item["FileNameDialog", "FrontEndTokens.nb", CopyTag->"FileNameDialog"],
	 	 Item["CreateGridBoxDialog", "FrontEndTokens.nb", \
CopyTag->"CreateGridBoxDialog"],
	 	 Item["CreateCustomButtonBox", "FrontEndTokens.nb", \
CopyTag->"CreateCustomButtonBox"],
	 	 Item["EditButtonBoxDialog", "FrontEndTokens.nb", \
CopyTag->"EditButtonBoxDialog"],
	 	 Item["CreateHyperlinkDialog", "FrontEndTokens.nb", \
CopyTag->"CreateHyperlinkDialog"],
	 	 Item["CreateCounterBoxDialog", "FrontEndTokens.nb", \
CopyTag->"CreateCounterBoxDialog"],
	 	 Item["CreateValueBoxDialog", "FrontEndTokens.nb", \
CopyTag->"CreateValueBoxDialog"],
	 	 Item["DuplicatePreviousInput", "FrontEndTokens.nb", \
CopyTag->"DuplicatePreviousInput"],
	 	 Item["DuplicatePreviousOutput", "FrontEndTokens.nb", \
CopyTag->"DuplicatePreviousOutput"],
	 	 Item["SimilarCellBelow", "FrontEndTokens.nb", \
CopyTag->"SimilarCellBelow"],
	 	 Item["CompleteSelection", "FrontEndTokens.nb", \
CopyTag->"CompleteSelection"],
	 	 Item["TemplateSelection", "FrontEndTokens.nb", \
CopyTag->"TemplateSelection"]
	 	 }]},
	 	
	 	  {BrowserCategory["Kernel Menu", None,
	 	{Item["Evaluate", "FrontEndTokens.nb", CopyTag->"Evaluate"],
	 	 Item["EvaluateCells", "FrontEndTokens.nb", CopyTag->"EvaluateCells"],
	 	 Item["EvaluateNextCell", "FrontEndTokens.nb", \
CopyTag->"EvaluateNextCell"], 
	 	 Item["SubsessionEvaluateCells", "FrontEndTokens.nb", \
CopyTag->"SubsessionEvaluateCells"],
	 	 Item["EvaluateNotebook", "FrontEndTokens.nb", \
CopyTag->"EvaluateNotebook"],
	 	 Item["EvaluateInitialization", "FrontEndTokens.nb", \
CopyTag->"EvaluateInitialization"],
	 	 Item["EnterSubsession", "FrontEndTokens.nb", CopyTag->"EnterSubsession"],
	 	 Item["ExitSubsession", "FrontEndTokens.nb", CopyTag->"ExitSubsession"],
	 	 Item["RemoveFromEvaluationQueue", "FrontEndTokens.nb", \
CopyTag->"RemoveFromEvaluationQueue"],
	 	 Item["EvaluatorInterrupt", "FrontEndTokens.nb", \
CopyTag->"EvaluatorInterrupt"],
	 	 Item["EvaluatorAbort", "FrontEndTokens.nb", CopyTag->"EvaluatorAbort"],
	 	 Item["EvaluatorStart", "FrontEndTokens.nb", CopyTag->"EvaluatorStart"],
	 	 Item["EvaluatorQuit", "FrontEndTokens.nb", CopyTag->"EvaluatorQuit"],
	 	 Item["ModifyEvaluatorNames", "FrontEndTokens.nb", \
CopyTag->"ModifyEvaluatorNames"],
	 	 Item["ShowCellLabel", "FrontEndTokens.nb", CopyTag->"ShowCellLabel"],
	 	 Item["DeleteGeneratedCells", "FrontEndTokens.nb", \
CopyTag->"DeleteGeneratedCells"]
	 	 }]},
	 	 
	 	  {BrowserCategory["Find Menu", None,
	 	{Item["FindDialog", "FrontEndTokens.nb", CopyTag->"FindDialog"],
	 	 Item["SelectionSetFind", "FrontEndTokens.nb", \
CopyTag->"SelectionSetFind"],
	 	 Item["CellTagsFind", "FrontEndTokens.nb", CopyTag->"CellTagsFind"], 
	 	 Item["Replace", "FrontEndTokens.nb", CopyTag->"Replace"],
	 	 Item["ReplaceFind", "FrontEndTokens.nb", CopyTag->"ReplaceFind"],
	 	 Item["ReplaceAll", "FrontEndTokens.nb", CopyTag->"ReplaceAll"],
	 	 Item["OpenSelectionParents", "FrontEndTokens.nb", \
CopyTag->"OpenSelectionParents"],
	 	 Item["SelectionScroll", "FrontEndTokens.nb", CopyTag->"SelectionScroll"],
	 	 Item["HyperlinkGoBack", "FrontEndTokens.nb", CopyTag->"HyperlinkGoBack"],
	 	 Item["CellTagsEditDialog", "FrontEndTokens.nb", \
CopyTag->"CellTagsEditDialog"],
	 	 Item["ShowCellTags", "FrontEndTokens.nb", CopyTag->"ShowCellTags"],
	 	 Item["CellLabelsToTags", "FrontEndTokens.nb", \
CopyTag->"CellLabelsToTags"],
	 	 Item["CreateIndexDialog", "FrontEndTokens.nb", \
CopyTag->"CreateIndexDialog"]
	 	 }]},
	 	 
	 	  {BrowserCategory["Window Menu", None,
	 	{Item["StackWindows", "FrontEndTokens.nb", CopyTag->"StackWindows"],
	 	 Item["TileWindowsWide", "FrontEndTokens.nb", CopyTag->"TileWindowsWide"],
	 	 Item["TileWindowsTall", "FrontEndTokens.nb", CopyTag->"TileWindowsTall"]
	 	}]},
	 	 
	 	  {BrowserCategory["Help Menu", None,
	 	{Item["HelpDialog", "FrontEndTokens.nb", CopyTag->"HelpDialog"],
	 	 Item["SelectionHelpDialog", "FrontEndTokens.nb", \
CopyTag->"SelectionHelpDialog"],
	 	 Item["ExplainBeepDialog", "FrontEndTokens.nb", \
CopyTag->"ExplainBeepDialog"], 
	 	 Item["AboutBoxDialog", "FrontEndTokens.nb", CopyTag->"AboutBoxDialog"],
	 	 Item["RebuildHelpIndex", "FrontEndTokens.nb", \
CopyTag->"RebuildHelpIndex"]}]},
	 	 
	 	 {BrowserCategory["Miscellaneous Tokens", None,
	 	{Item["AddFrame", "FrontEndTokens.nb", CopyTag->"AddFrame"],
	 	 Item["FixCellHeight", "FrontEndTokens.nb", CopyTag->"FixCellHeight"],
	 	 Item["MoveNextCell", "FrontEndTokens.nb", CopyTag->"MoveNextCell"],
	 	 Item["SelectTerminalWindow", "FrontEndTokens.nb", \
CopyTag->"SelectTerminalWindow"]
	 	}]}
	}],

    Item[Delimiter], 
(*    BrowserCategory["Contact Information", None, 
      {Item["Web", "ContactInfo.nb", CopyTag -> "web"], 
        Item["Information about Mathematica", "ContactInfo.nb", 
          CopyTag -> "info"], 
        Item["Services for Users", "ContactInfo.nb", CopyTag -> "services"], 
        Item["Comments and Feedback", "ContactInfo.nb", 
          CopyTag -> "comments"], 
        Item["Related Products and Material", "ContactInfo.nb", 
          CopyTag -> "products"], 
        Item["Company Addresses", "ContactInfo.nb", 
          CopyTag -> "addresses"]}], Item[Delimiter], 
 *)         
	BrowserCategory["MathReader", None,
	   {Item["What is MathReader", 
	         "UsingMathReader.nb", CopyTag->"WhatisMathReader"],         
	    BrowserCategory["Using MathReader", None,
	       { Item["The Notebook Format", 
	              "UsingMathReader.nb", CopyTag->"NotebookFormat"],
	         Item["Opening a Notebook", 
	              "UsingMathReader.nb", CopyTag->"OpeningNotebooks"],
	         Item["Cells and Cell Groups", 
	              "UsingMathReader.nb", CopyTag->"OpeningCellGroups"],
	         Item["Magnifying the Display", 
	              "UsingMathReader.nb", CopyTag->"DisplayCharacteristics"],
	         Item["Animating Graphics", 
	              "UsingMathReader.nb", CopyTag->"AnimatingGraphics"],
	         Item["Playing Sounds", 
	              "UsingMathReader.nb", CopyTag->"PlayingSounds"],
	         Item["Printing", 
	              "UsingMathReader.nb", CopyTag->"Printing"]}],
	         Item["Getting Help", 
	              "UsingMathReader.nb", CopyTag->"UsingHelp"],
	        Item[Delimiter],	        
	        Item["MathReader and the Web", "UsingMathReader.nb", 
		CopyTag->"ConfiguringBrowser"],
	    Item["Licensing Information", 
	         "UsingMathReader.nb", CopyTag->"LicensingInformation"]}]


}]


