(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    139689,       5055]*)
(*NotebookOutlinePosition[    249752,       7875]*)
(*  CellTagsIndexPosition[    223832,       7257]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Front End", "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[CellGroupData[{

Cell["Menu Commands", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["File Menu", "SubsubsectionIcon",
  FontWeight->"Plain"],

Cell[TextData[{
  ButtonBox["New",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"New (menu command)"],

Cell[TextData[{
  ButtonBox["Open...",
    ButtonStyle->"OtherInformationLink"],
  " (menu command)"
}], "Index",
  CellTags->"Open (menu command)"],

Cell[TextData[{
  ButtonBox["Close",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Close (menu command)"],

Cell[TextData[{
  ButtonBox["Save",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Save (menu command)"],

Cell[TextData[{
  ButtonBox["Save As...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Save As (menu command)"],

Cell[TextData[{
  ButtonBox["Save As Special...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Save As Special (menu command)"],

Cell[TextData[{
  ButtonBox["Version 2 Notebook",
    ButtonData:>"Save As Special: Version 2 Notebook",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Version 2 Notebook, Save As"],

Cell[TextData[{
  ButtonBox["Text",
    ButtonData:>"Save As Special: Text",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Text, Save As"],

Cell[TextData[{
  ButtonBox["Cell Expression",
    ButtonData:>"Save As Special: Cell Expression",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Cell Expression, Save As"],

Cell[TextData[{
  ButtonBox["Notebook Expression",
    ButtonData:>"Save As Special: Notebook Expression",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Notebook Expression, Save As"],

Cell[TextData[{
  ButtonBox["Package Format",
    ButtonData:>"Save As Special: Package Format",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Package Format, Save As"],

Cell[TextData[{
  ButtonBox["TeX",
    ButtonData:>"Save As Special: TeX",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"TeX, Save As"],

Cell[TextData[{
  ButtonBox["HTML",
    ButtonData:>"Save As Special: HTML",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"HTML, Save As"],

Cell[TextData[{
  ButtonBox["XML (XHTML+MathML)",
    ButtonData:>"Save As Special: XHTML+MathML",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"XML (XHTMLMathML), Save As"],

Cell[TextData[{
  ButtonBox["XML (NotebookML)",
    ButtonData:>"Save As Special: NotebookML",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"XML (NotebookML), Save As"],

Cell[TextData[{
  ButtonBox["XML (NotebookML+MathML)",
    ButtonData:>"Save As Special: NotebookML+MathML",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"XML (NotebookML+MathML), Save As"],

Cell[TextData[{
  ButtonBox["Open Special...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Open Special (menu command)"],

Cell[TextData[{
  ButtonBox["Import...",
    ButtonData:>"Import",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Import (menu command)"],

Cell[TextData[{
  ButtonBox["Send To...",
    ButtonStyle->"OtherInformationLink"],
  " (Windows only)"
}], "Index",
  CellTags->"Send To (menu command)"],

Cell[TextData[{
  ButtonBox["Send Selection...",
    ButtonStyle->"OtherInformationLink"],
  " (Windows only)"
}], "Index",
  CellTags->"Send Selection (menu command)"],

Cell[TextData[{
  ButtonBox["Palettes",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Palettes (menu command)"],

Cell[TextData[{
  ButtonBox["Notebooks",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Notebooks (menu command)"],

Cell[TextData[{
  ButtonBox["Generate Palette from Selection",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Generate Palette from Selection (menu command)"],

Cell[TextData[{
  ButtonBox["Generate Notebook from Palette",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Generate Notebook from Palette (menu command)"],

Cell[TextData[{
  StyleBox["Printing Setting", "MR"],
  StyleBox["s", "MR"],
  "  (menu command)"
}], "Index",
  CellTags->"menucommands"],

Cell[TextData[{
  ButtonBox["Page Setup...",
    ButtonData:>"Printing Settings: Page Setup",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Page Setup (menu command)"],

Cell[TextData[{
  ButtonBox["Printing Options...",
    ButtonData:>"Printing Settings: Printing Options",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Printing Options (menu command)"],

Cell[TextData[{
  ButtonBox["Headers and Footers...",
    ButtonData:>"Printing Settings: Headers and Footers",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Headers and Footers (menu command)"],

Cell[TextData[{
  ButtonBox["Print...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Print (menu command)"],

Cell[TextData[{
  ButtonBox["Print Selection",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Print Selection (menu command)"],

Cell[TextData[{
  ButtonBox["Exit",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Exit (menu command)"],

Cell[TextData[{
  ButtonBox["Quit",
    ButtonData:>"Exit",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Quit (menu command)"]
}, Closed]],

Cell[CellGroupData[{

Cell["Edit Menu", "SubsubsectionIcon",
  FontWeight->"Plain"],

Cell[TextData[{
  ButtonBox["Undo",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Undo (menu command)"],

Cell[TextData[{
  ButtonBox["Cut",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Cut (menu command)"],

Cell[TextData[{
  ButtonBox["Copy",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Copy (menu command)"],

Cell[TextData[{
  ButtonBox["Paste",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Paste (menu command)"],

Cell[TextData[{
  ButtonBox["Clear",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Clear (menu command)"],

Cell[TextData[{
  ButtonBox["Copy As",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Copy As (menu command)"],

Cell[TextData[{
  ButtonBox["Paste As",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Paste As (menu command)"],

Cell[TextData[{
  ButtonBox["External Clipboard",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"External Clipboard (menu command)"],

Cell[TextData[{
  ButtonBox["Save Selection As",
    ButtonStyle->"OtherInformationLink"],
  " (menu command)"
}], "Index",
  CellTags->"Save Selection As (menu command)"],

Cell[TextData[{
  ButtonBox["Select All",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Select All (menu command)"],

Cell[TextData[{
  ButtonBox["Insert Object",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Insert Object (menu command)"],

Cell[TextData[{
  ButtonBox["Motion",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Motion (menu command)"],

Cell[TextData[{
  ButtonBox["Expression Input",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Expression Input (menu command)"],

Cell[TextData[{
  ButtonBox["Insert Raw Expression...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Insert Raw Expression (menu command)"],

Cell[TextData[ButtonBox["Add Frame",
  ButtonStyle->"OtherInformationLink"]], "IndexSubentry",
  CellTags->"Add Frame (menu command)"],

Cell[TextData[ButtonBox["Add Interpretation...",
  ButtonStyle->"OtherInformationLink"]], "IndexSubentry",
  CellTags->"Add Interpretation (menu command)"],

Cell[TextData[{
  ButtonBox["Make 2D",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Make 2D (menu command)"],

Cell[TextData[{
  ButtonBox["Check Balance",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Check Balance (menu command)"],

Cell[TextData[{
  ButtonBox["Check Spelling...",
    ButtonData:>"spellCheckerDialogID",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Check Spelling (menu command)"],

Cell[TextData[{
  ButtonBox["Preferences...",
    ButtonData:>"Preferences...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Preferences (menu command)"]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Menu", "SubsubsectionIcon",
  FontWeight->"Plain"],

Cell[TextData[{
  ButtonBox["Convert To",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Convert To (menu command)"],

Cell[TextData[{
  ButtonBox["InputForm, Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"InputForm, Convert To"],

Cell[TextData[{
  ButtonBox["OutputForm,",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[" Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"OutputForm, Convert To"],

Cell[TextData[{
  ButtonBox["StandardForm,",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[" Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"StandardForm, Convert To"],

Cell[TextData[{
  ButtonBox["TraditionalForm",
    ButtonData:>"Convert To: TraditionalForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[",",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[" Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"TraditionalForm, Convert To"],

Cell[TextData[{
  ButtonBox["PostScript",
    ButtonData:>"Convert To: PostScript",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[",",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[" Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"PostScript, Convert To"],

Cell[TextData[{
  ButtonBox["Bitmap",
    ButtonData:>"Convert To: Bitmap",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[",",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[" Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Bitmap, Convert To"],

Cell[TextData[{
  ButtonBox["PICT",
    ButtonData:>"Convert To: PICT",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[",",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[" Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"PICT, ConvertTo"],

Cell[TextData[{
  ButtonBox["BitmapPICT",
    ButtonData:>"Convert To: BitmapPICT",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[",",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[" Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"BitmapPICT, Convert To"],

Cell[TextData[{
  ButtonBox["Embedded PS PICT, Convert To",
    ButtonData:>"Convert To: Embedded PS PICT",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Embedded PS PICT, ConvertTo"],

Cell[TextData[{
  ButtonBox["Metafile",
    ButtonData:>"Convert To: Metafile",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[",",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[" Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Metafile, Convert To"],

Cell[TextData[{
  ButtonBox["QuickTime",
    ButtonData:>"Convert To: QuickTime",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[",",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  ButtonBox[" Convert To",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"QuickTime, Convert To"],

Cell[TextData[{
  ButtonBox["Display As",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Display As (menu command)"],

Cell[TextData[{
  ButtonBox["Text,Display As",
    ButtonData:>"Display As: Text",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Text, Display As"],

Cell[TextData[{
  ButtonBox["InputForm, Display As",
    ButtonData:>"Display As: InputForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"InputForm, Display As"],

Cell[TextData[{
  ButtonBox["StandardForm, Display As",
    ButtonData:>"Display As: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"StandardForm, Display As"],

Cell[TextData[{
  ButtonBox["TraditionalForm, Display As",
    ButtonData:>"Display As: TraditionalForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Traditional Form, Display As"],

Cell[TextData[{
  ButtonBox["Default Input Format Type",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Default Input Format Type (menu command)"],

Cell[TextData[{
  ButtonBox["Default Output Format Type",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Default Output Format Type (menu command)"],

Cell[TextData[{
  ButtonBox["Default Inline Format Type",
    ButtonData:>"Default Inline Format Type: StandardForm",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Default Inline Format Type (menu command)"],

Cell[TextData[{
  ButtonBox["Cell Properties",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Cell Properties (menu command)"],

Cell[TextData[{
  ButtonBox["Cell Open",
    ButtonData:>"Cell Properties: Cell Open",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"menucommands"],

Cell[TextData[{
  ButtonBox["Cell Editable",
    ButtonData:>"Cell Properties: Cell Editable",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Cell Editable (menu command)"],

Cell[TextData[{
  ButtonBox["Cell Edit Duplicate",
    ButtonData:>"Cell Properties: Cell Edit Duplicate",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Cell Edit Duplicate (menu command)"],

Cell[TextData[{
  ButtonBox["Cell Evaluatable",
    ButtonData:>"Cell Properties: Cell Evaluatable",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Cell Evaluatable (menu commands)"],

Cell[TextData[{
  ButtonBox["Cell Active",
    ButtonData:>"Cell Properties: Cell Active",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Cell Active (menu command)"],

Cell[TextData[{
  ButtonBox["Initialization Cell",
    ButtonData:>"Cell Properties: Initialization Cell",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Initialization Cell (menu command)"],

Cell[TextData[{
  ButtonBox["Cell Grouping",
    ButtonData:>"Cell Grouping: Group Cells",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Cell Grouping (menu command)"],

Cell[TextData[{
  ButtonBox["Group Cells",
    ButtonData:>"Cell Grouping: Group Cells",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Group Cells (menu command)"],

Cell[TextData[{
  ButtonBox["Ungroup Cells",
    ButtonData:>"Cell Grouping: Ungroup Cells",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Ungroup Cells (menu command)"],

Cell[TextData[{
  ButtonBox["Manual Grouping",
    ButtonData:>"Cell Grouping: Manual Grouping",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Manual Grouping (menu command)"],

Cell[TextData[{
  ButtonBox["Automatic Grouping",
    ButtonData:>"Cell Grouping: Automatic Grouping",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Automatic Grouping (menu command)"],

Cell[TextData[{
  ButtonBox["Open All Subgroups",
    ButtonData:>"Cell Grouping: Open all Subgroups",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Open All Subgroups (menu command)"],

Cell[TextData[{
  ButtonBox["Close All Subgroups",
    ButtonData:>"Cell Grouping: Close all Subgroups",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Close All Subgroups (menu command)"],

Cell[TextData[{
  ButtonBox["Open/Close Group",
    ButtonData:>"Cell Grouping: Open/Close Group",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Open/Close Group (menu command)"],

Cell[TextData[{
  ButtonBox["Divide Cell",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Divide Cell (menu command)"],

Cell[TextData[{
  ButtonBox["Merge Cells",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Merge Cells (menu command)"],

Cell[TextData[{
  ButtonBox["Animate Selected Graphics",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Animate Selected Graphics (menu command)"],

Cell[TextData[{
  ButtonBox["Play Sound",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Play Sound (menu command)"],

Cell[TextData[{
  ButtonBox["Rerender Graphics",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Rerender Graphics (menu command)"],

Cell[TextData[{
  ButtonBox["Rerender and Save Graphics",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Rerender and Save Graphics (menu command)"],

Cell[TextData[{
  ButtonBox["Make Standard Size",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Make Standard Size (menu command)"],

Cell[TextData[{
  ButtonBox["Align Selected Graphics...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Align Selected Graphics (menu command)"],

Cell[TextData[{
  ButtonBox["Cell Size Statistics...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Cell Size Statistics (menu command)"]
}, Closed]],

Cell[CellGroupData[{

Cell["Format Menu", "SubsubsectionIcon",
  FontWeight->"Plain"],

Cell[TextData[ButtonBox["Style",
  ButtonStyle->"OtherInformationLink"]], "Index",
  CellTags->"Style (menu command)"],

Cell[TextData[{
  ButtonBox["Screen Style Environment",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Screen Style Environment (menu command)"],

Cell[TextData[{
  ButtonBox["Printing Style Environment",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Printing Style Environment (menu command)"],

Cell[TextData[{
  ButtonBox["Show Expression",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Show Expression (menu command)"],

Cell[TextData[{
  ButtonBox["Option Inspector...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Option Inspector (menu command)"],

Cell[TextData[{
  ButtonBox["Remove Options...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Remove Options (menu command)"],

Cell[TextData[{
  ButtonBox["Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Style Sheet (menu command)"],

Cell[TextData[{
  ButtonBox["Edit Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Edit Style Sheet (menu command)"],

Cell[TextData[{
  ButtonBox["Font",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Font (menu command)"],

Cell[TextData[{
  ButtonBox["Face",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Face (menu command)"],

Cell[TextData[{
  ButtonBox["Size",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Size (menu command)"],

Cell[TextData[{
  ButtonBox["Text Color",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Text Color (menu command)"],

Cell[TextData[{
  ButtonBox["Background Color",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Background Color (menu command)"],

Cell[TextData[{
  ButtonBox["Choose Font...",
    ButtonStyle->"OtherInformationLink"],
  " (Windows only)"
}], "Index",
  CellTags->"Choose Font (menu command)"],

Cell[TextData[{
  ButtonBox["Text Alignment",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Text Alignment (menu command)"],

Cell[TextData[{
  ButtonBox["Text Justification",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Text Justification (menu command)"],

Cell[TextData[{
  ButtonBox["Word Wrapping",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Word Wrapping (menu command)"],

Cell[TextData[{
  ButtonBox["Don't Word Wrap",
    ButtonData:>"Word Wrapping: Don't Word Wrap",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"menucommands"],

Cell[TextData[{
  ButtonBox["Wrap at Paper Width",
    ButtonData:>"Word Wrapping: Wrap at Paper Width",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"menucommands"],

Cell[TextData[{
  ButtonBox["Wrap at Window Width",
    ButtonData:>"Word Wrapping: Wrap at Window Width",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"menucommands"],

Cell[TextData[{
  ButtonBox["Fixed Word Wrap Width",
    ButtonData:>"Word Wrapping: Fixed Word Wrap Width",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"menucommands"],

Cell[TextData[{
  ButtonBox["Cell Dingbat",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Cell Dingbat (menu command)"],

Cell[TextData[ButtonBox["Horizontal Lines",
  ButtonStyle->"OtherInformationLink"]], "Index",
  CellTags->"Horizontal Lines (menu command)"],

Cell[TextData[{
  ButtonBox["Show Ruler",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Show Ruler (menu command)"],

Cell[TextData[{
  ButtonBox["Show ToolBar",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Show Toolbar (menu command)"],

Cell[TextData[{
  ButtonBox["Show Page Breaks",
    ButtonData:>"Show Page Breaks",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Show Page Breaks (menu command)"],

Cell[TextData[{
  ButtonBox["Magnification",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Magnification (menu command)"]
}, Closed]],

Cell[CellGroupData[{

Cell["Input Menu", "SubsubsectionIcon",
  FontWeight->"Plain"],

Cell[TextData[{
  ButtonBox["Get Graphics Coordinates...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Get Graphics Coordinates (menu command)"],

Cell[TextData[{
  ButtonBox["3D ViewPoint Selector...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"3D ViewPoint Selector (menu command)"],

Cell[TextData[{
  ButtonBox["Color Selector...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Color Selector (menu command)"],

Cell[TextData[{
  ButtonBox["Record Sound...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Record Sound (menu command)"],

Cell[TextData[{
  ButtonBox["Get File Path...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Get File Path (menu command)"],

Cell[TextData[{
  ButtonBox["Create Table/Matrix/Palette...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Create Table/Matrix/Palette (menu command)"],

Cell[TextData[{
  ButtonBox["Create Button",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Create Button (menu command)"],

Cell[TextData[{
  ButtonBox["Edit Button...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Edit Button (menu command)"],

Cell[TextData[{
  ButtonBox["Create Hyperlink...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Create Hyperlink (menu command)"],

Cell[TextData[{
  ButtonBox["Create Automatic Numbering Object...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Create Automatic Numbering Object (menu command)"],

Cell[TextData[{
  ButtonBox["Create Value Display Object...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Create Value Display Object (menu command)"],

Cell[TextData[ButtonBox["Convert Automatic Objects to Literal",
  ButtonStyle->"OtherInformationLink"]], "Index",
  CellTags->"Convert Automatic Objects to Literal (menu command)"],

Cell[TextData[{
  ButtonBox["Copy Input from Above",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Copy Input from Above (menu command)"],

Cell[TextData[{
  ButtonBox["Copy Output from Above",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Copy Output from Above (menu command)"],

Cell[TextData[{
  ButtonBox["Start New Cell Below",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Start New Cell Below (menu command)"],

Cell[TextData[{
  ButtonBox["Complete Selection",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Complete Selection (menu command)"],

Cell[TextData[{
  ButtonBox["Make Template",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Make Template (menu command)"]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel Menu", "SubsubsectionIcon",
  FontWeight->"Plain"],

Cell[TextData[{
  StyleBox["Evaluation", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Evaluation (menu command)"],

Cell[TextData[{
  ButtonBox["Evaluate Cells",
    ButtonData:>"Evaluation: Evaluate Cells",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Evaluate Cells (menu command)"],

Cell[TextData[{
  ButtonBox["Evaluate in Place",
    ButtonData:>"Evaluation: Evaluate In Place",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Evaluate in Place (menu command)"],

Cell[TextData[{
  ButtonBox["Evaluate Next Input",
    ButtonData:>"Evaluation: Evaluate Next Input",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Evaluate Next Input (menu command)"],

Cell[TextData[{
  ButtonBox["Evaluate In Subsession",
    ButtonData:>"Evaluation: Evaluate In Subsession",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Evaluate In Subsession (menu command)"],

Cell[TextData[{
  ButtonBox["Evaluate Notebook",
    ButtonData:>"Evaluation: Evaluate Notebook",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Evaluate Notebook (menu command)"],

Cell[TextData[{
  ButtonBox["Evaluate Initialization",
    ButtonData:>"Evaluation: Evaluate Initialization",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Evaluate Initialization (menu command)"],

Cell[TextData[{
  ButtonBox["Enter Subsession",
    ButtonData:>"Evaluation: Enter Subsession",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Enter Subsession (menu command)"],

Cell[TextData[{
  ButtonBox["Exit Subsession",
    ButtonData:>"Evaluation: Exit Subsession",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Exit Subsession (menu command)"],

Cell[TextData[{
  ButtonBox["Remove from Evaluation Queue",
    ButtonData:>"Evaluation: Remove from Evaluation Queue",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "IndexSubentry",
  CellTags->"Remove from Evaluation Queue (menu command)"],

Cell[TextData[{
  ButtonBox["Interrupt Evaluation...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Interrupt Evaluation (menu command)"],

Cell[TextData[{
  ButtonBox["Abort Evaluation",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Abort Evaluation (menu command)"],

Cell[TextData[{
  ButtonBox["Start Kernel",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Start Kernel (menu command)"],

Cell[TextData[{
  ButtonBox["Quit Kernel",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Quit Kernel (menu command)"],

Cell[TextData[{
  ButtonBox["Default Kernel",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Default Kernel (menu command)"],

Cell[TextData[{
  ButtonBox["Notebook's Kernel",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Notebook's Kernel (menu command)"],

Cell[TextData[{
  ButtonBox["Kernel Configuration Options...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Kernel Configuration Options (menu command)"],

Cell[TextData[{
  ButtonBox["Show In/Out Names",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Show In/Out Names (menu command)"],

Cell[TextData[{
  ButtonBox["Delete All Output",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Delete All Output (menu command)"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find Menu", "SubsubsectionIcon",
  FontWeight->"Plain"],

Cell[TextData[{
  ButtonBox["Find...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Find (menu command)"],

Cell[TextData[{
  ButtonBox["Enter Selection",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Enter Selection (menu command)"],

Cell[TextData[{
  ButtonBox["Find Next",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Find Next (menu command)"],

Cell[TextData[{
  ButtonBox["Find Previous",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Find Previous (menu command)"],

Cell[TextData[{
  ButtonBox["Find in Cell Tags",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Find in Cell Tags (menu command)"],

Cell[TextData[{
  ButtonBox["Replace",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Replace and Find Again (menu command)"],

Cell[TextData[{
  ButtonBox["Replace and Find Again",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Replace and Find Again (menu command)"],

Cell[TextData[{
  ButtonBox["Replace All",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Replace All (menu command)"],

Cell[TextData[{
  ButtonBox["Open Selected",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Open Selected (menu command)"],

Cell[TextData[{
  ButtonBox["Scroll to Selection",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Scroll to Selection (menu command)"],

Cell[TextData[{
  ButtonBox["Go Back",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Go Back (menu command)"],

Cell[TextData[{
  ButtonBox["Add/Remove Cell Tags...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Add/Remove Cell Tags (menu command)"],

Cell[TextData[{
  ButtonBox["Cell Tags",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Cell Tags (menu command)"],

Cell[TextData[{
  ButtonBox["Show Cell Tags",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Show Cell Tags (menu command)"],

Cell[TextData[{
  ButtonBox["Cell Tags from In/Out Names",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Cell Tags from In/Out Names (menu command)"],

Cell[TextData[{
  ButtonBox["Make Index...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Make Index... (menu command)"]
}, Closed]],

Cell[CellGroupData[{

Cell["Window Menu", "SubsubsectionIcon",
  FontWeight->"Plain"],

Cell[TextData[{
  ButtonBox["Stack Windows",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Stack Windows (menu command)"],

Cell[TextData[{
  ButtonBox["Tile Windows Wide",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Tile Windows Wide (menu command)"],

Cell[TextData[{
  ButtonBox["Tile Windows Tall",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Tile Windows Tall (menu command)"]
}, Closed]],

Cell[CellGroupData[{

Cell["Help Menu", "SubsubsectionIcon",
  FontWeight->"Plain"],

Cell[TextData[{
  ButtonBox["Help Browser...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Help Browser (menu command)"],

Cell[TextData[{
  ButtonBox["Find Selected Function...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Find Selected Function (menu command)"],

Cell[TextData[{
  ButtonBox["Master Index...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Master Index (menu command)"],

Cell[TextData[{
  ButtonBox["Tutorial...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"InformationCenter (menu command)"],

Cell[TextData[{
  ButtonBox["Information Center on the Web...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Information Center on the Web (menu command)"],

Cell[TextData[{
  ButtonBox["Wolfram Research on the Web...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Wolfram Research on the Web (menu command)"],

Cell[TextData[{
  ButtonBox["Online Registration...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Registration (menu command)"],

Cell[TextData[{
  ButtonBox["Why the Beep?...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Why the Beep (menu command)"],

Cell[TextData[{
  ButtonBox["Startup Palette...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Startup Palette (menu command)"],

Cell[TextData[{
  ButtonBox["About Mathematica...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"About Mathematica (menu command)"],

Cell[TextData[{
  ButtonBox["X Environment Information...",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"X Environment Information (menu command)"],

Cell[TextData[{
  ButtonBox["Rebuild Help Index",
    ButtonStyle->"OtherInformationLink"],
  "  (menu command)"
}], "Index",
  CellTags->"Rebuild Help Index (menu command)"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Keyboard Shortcuts ", "SubsectionIcon"],

Cell[TextData[{
  "    ",
  ButtonBox["on Microsoft Windows",
    ButtonData:>"Windows Keyboard Shortcuts",
    ButtonStyle->"OtherInformationLink"],
  "\n    ",
  ButtonBox["on Macintosh",
    ButtonData:>"Macintosh Keyboard Shortcuts",
    ButtonStyle->"OtherInformationLink"],
  "\n    ",
  ButtonBox["on X",
    ButtonData:>"X Keyboard Shortcuts",
    ButtonStyle->"OtherInformationLink"],
  "\n"
}], "Index",
  CellTags->"Keyboard shortcuts"]
}, Closed]],

Cell[CellGroupData[{

Cell["Style Sheets", "SubsectionIcon"],

Cell[TextData[{
  "Style sheets, changing cell options within, ",
  ButtonBox["Changing Cell Options",
    ButtonStyle->"OtherInformationLink"],
  "\n\tcreating new cell styles, ",
  ButtonBox["Creating New Cell Styles",
    ButtonStyle->"OtherInformationLink"],
  "\n\tcreating your own, ",
  ButtonBox["How to Create Your Own Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  "\n\tdefault, ",
  ButtonBox["What Is the Default Style Sheet?",
    ButtonStyle->"OtherInformationLink"],
  "\n\tediting shared or private, ",
  ButtonBox["Editing Shared or Private Style Sheets",
    ButtonStyle->"OtherInformationLink"],
  "\n\tfile locations, ",
  ButtonBox["Style Sheet File Locations",
    ButtonStyle->"OtherInformationLink"],
  "\n\thow options are set, ",
  ButtonBox["How Options Are Set",
    ButtonStyle->"OtherInformationLink"],
  "\n\thow the default style sheet is set, ",
  ButtonBox["Setting the Default Style Sheet Option",
    ButtonStyle->"OtherInformationLink"],
  "\n\thow they work, ",
  ButtonBox["How Style Sheets Work",
    ButtonStyle->"OtherInformationLink"],
  "\n\tintroduction, ",
  ButtonBox["What Is a Style Sheet?",
    ButtonStyle->"OtherInformationLink"],
  "\n\t\t to editing, ",
  ButtonBox["Introduction",
    ButtonStyle->"OtherInformationLink"],
  "\n\tlocation of the default, ",
  ButtonBox["Location of the Default Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  "\n\tother editing tips, ",
  ButtonBox["Other Editing Tips",
    ButtonStyle->"OtherInformationLink"],
  "\n\tprivate, ",
  ButtonBox["Shared and Private Style Sheets",
    ButtonStyle->"OtherInformationLink"],
  "\n\tselecting the active, ",
  ButtonBox["Selecting a Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  "\n\tselecting the default, ",
  ButtonBox["Selecting the Default Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  "\n\tshared, ",
  ButtonBox["Shared and Private Style Sheets",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Style sheets"],

Cell["Environments", "IndexSection"],

Cell[TextData[{
  "Environments, changing environment options, ",
  ButtonBox["Changing Style Environment Options",
    ButtonStyle->"OtherInformationLink"],
  "\n\tintroduction, ",
  ButtonBox["What Are Style Environments?",
    ButtonStyle->"OtherInformationLink"],
  "\n\tsetting on-screen or printing, ",
  ButtonBox["Setting On-Screen or Printing Environments",
    ButtonStyle->"OtherInformationLink"],
  "\n\tstyle definitions for, ",
  ButtonBox["How Settings for a Style Are Determined",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->{"Style sheets", "Environments"}],

Cell["Slide Show and Tutorial", "IndexSection"],

Cell[TextData[{
  "Slide Show environment, ",
  ButtonBox["Working with Slide Shows",
    ButtonStyle->"OtherInformationLink"],
  "\n\texample of, ",
  ButtonBox["10 Minute Tutorial on ",
    ButtonFunction:>FrontEnd`NotebookOpen[ 
        FrontEnd`FileName[ {$InstallationDirectory, "Documentation", 
          "English", "GettingStarted"}, "SlideShow.nb"]],
    Active->True,
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonFunction:>FrontEnd`NotebookOpen[ 
        FrontEnd`FileName[ {$InstallationDirectory, "Documentation", 
          "English", "GettingStarted"}, "SlideShow.nb"]],
    Active->True,
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"]
}], "Index",
  CellTags->{
  "Style sheets", "Environments", "Tutorial", "Slide Show", 
    "10 Minute Tutorial on Mathematica"}],

Cell[TextData[{
  "Tutorial, ",
  ButtonBox["10 Minute Tutorial on ",
    ButtonFunction:>FrontEnd`NotebookOpen[ 
        FrontEnd`FileName[ {$InstallationDirectory, "Documentation", 
          "English", "GettingStarted"}, "SlideShow.nb"]],
    Active->True,
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonFunction:>FrontEnd`NotebookOpen[ 
        FrontEnd`FileName[ {$InstallationDirectory, "Documentation", 
          "English", "GettingStarted"}, "SlideShow.nb"]],
    Active->True,
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  " "
}], "Index",
  CellTags->{
  "Style sheets", "Environments", "Tutorial", "Slide Show", 
    "10 Minute Tutorial on Mathematica"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Front End Options", "SubsectionIcon"],

Cell[TextData[ButtonBox["NotebookDirectory",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"NotebookDirectory"],

Cell[TextData[ButtonBox["NotebookPath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"NotebookPath"],

Cell[TextData[ButtonBox["PalettePath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PalettePath"],

Cell[TextData[ButtonBox["AutoOpenPalettes",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AutoOpenPalettes"],

Cell[TextData[ButtonBox["AutoOpenNotebooks",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AutoOpenNotebooks"],

Cell[TextData[ButtonBox["StyleSheetPath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"StyleSheetPath"],

Cell[TextData[ButtonBox["DefaultNotebook",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DefaultNotebook"],

Cell[TextData[ButtonBox["DefaultStyleDefinitions",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DefaultStyleDefinitions"],

Cell[TextData[ButtonBox["PreferencesPath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PreferencesPath"],

Cell[TextData[ButtonBox["ConfigurationPath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ConfigurationPath"],

Cell[TextData[ButtonBox["SystemHelpPath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SystemHelpPath"],

Cell[TextData[ButtonBox["AddOnHelpPath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AddOnHelpPath"],

Cell[TextData[ButtonBox["AutoloadPath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AutoloadPath"],

Cell[TextData[ButtonBox["SpellingDictionariesPath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SpellingDictionariesPath"],

Cell[TextData[ButtonBox["CharacterEncodingsPath",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CharacterEncodingsPath"],

Cell[TextData[ButtonBox["ImportAutoReplacements",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ImportAutoReplacements"],

Cell[TextData[ButtonBox["ExportAutoReplacements",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ExportAutoReplacements"],

Cell[TextData[ButtonBox["Language",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Language"],

Cell[TextData[ButtonBox["ExternalDataCharacterEncoding",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ExternalDataCharacterEncoding"],

Cell[TextData[ButtonBox["StartupSound",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"StartupSound"],

Cell[TextData[ButtonBox["MultilaunchWarning",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"MultilaunchWarning"],

Cell[TextData[ButtonBox["ScreenRectangle",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ScreenRectangle"],

Cell[TextData[ButtonBox["FrontEndStackSize",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FrontEndStackSize"],

Cell[TextData[ButtonBox["XPasteFrom",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"XPasteFrom"],

Cell[TextData[ButtonBox["EvaluatorNames",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"EvaluatorNames"],

Cell[TextData[ButtonBox["NotebooksMenu",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"NotebooksMenu"],

Cell[TextData[ButtonBox["FontSubstitutions",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FontSubstitutions"],

Cell[TextData[ButtonBox["DefaultFontProperties",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DefaultFontProperties"],

Cell[TextData[ButtonBox["BoxFormFormatTypes",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"BoxFormFormatTypes"],

Cell[TextData[ButtonBox["WarningAction",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WarningAction"],

Cell[TextData[ButtonBox["ErrorAction",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ErrorAction"],

Cell[TextData[ButtonBox["ConsoleMessageAction",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ConsoleMessageAction"],

Cell[TextData[ButtonBox["KernelMessageAction",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"KernelMessageAction"],

Cell[TextData[ButtonBox["ExplainBeepHelp",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ExplainBeepHelp"],

Cell[TextData[ButtonBox["MathMLPasteWarning",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"MathMLPasteWarning"],

Cell[TextData[ButtonBox["InsufficientVersionWarning",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"InsufficientVersionWarning"],

Cell[TextData[ButtonBox["IgnoreTagBoxDeletionWarning",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"IgnoreTagBoxDeletionWarning"],

Cell[TextData[ButtonBox["TraditionalFormEvaluationWarning",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"TraditionalFormEvaluationWarning"],

Cell[TextData[ButtonBox["AllowDisablingWarnings",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AllowDisablingWarnings"],

Cell[TextData[ButtonBox["NotebookAutoSave",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"NotebookAutoSave"],

Cell[TextData[ButtonBox["ClosingAutoSave",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ClosingAutoSave"],

Cell[TextData[ButtonBox["IncludeFileExtension",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"IncludeFileExtension"],

Cell[TextData[ButtonBox["AutoGeneratedPackage",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AutoGeneratedPackage"],

Cell[TextData[ButtonBox["Editable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Editable"],

Cell[TextData[ButtonBox["Saveable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Saveable"],

Cell[TextData[ButtonBox["ScreenStyleEnvironment",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ScreenStyleEnvironment"],

Cell[TextData[ButtonBox["PrintingStyleEnvironment",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrintingStyleEnvironment"],

Cell[TextData[ButtonBox["ShowPageBreaks",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowPageBreaks"],

Cell[TextData[ButtonBox["WindowToolbars",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowToolbars"],

Cell[TextData[ButtonBox["RulerUnits",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RulerUnits"],

Cell[TextData[{
  ButtonBox["Background",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Notebook)"
}], "Index",
  CellTags->"NotebookBackground"],

Cell[TextData[ButtonBox["Magnification",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Magnification"],

Cell[TextData[ButtonBox["Evaluator",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Evaluator"],

Cell[TextData[ButtonBox["EvaluationCompletionAction",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"EvaluationCompletionAction"],

Cell[TextData[ButtonBox["PrintAction",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrintAction"],

Cell[TextData[ButtonBox["OutputAutoOverwrite",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"OutputAutoOverwrite"],

Cell[TextData[ButtonBox["InitializationCellEvaluation",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"InitializationCellEvaluation"],

Cell[TextData[ButtonBox["InitializationCellWarning",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"InitializationCellWarning"],

Cell[TextData[ButtonBox["Selectable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Selectable"],

Cell[TextData[ButtonBox["Deletable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Deletable"],

Cell[TextData[ButtonBox["CellGrouping",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellGrouping"],

Cell[TextData[ButtonBox["PageWidth",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PageWidth"],

Cell[TextData[ButtonBox["WindowSize",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowSize"],

Cell[TextData[ButtonBox["WindowMargins",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["WindowFrame",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowFrame"],

Cell[TextData[ButtonBox["WindowElements",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowElements"],

Cell[TextData[ButtonBox["WindowFrameElements",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowFrameElements"],

Cell[TextData[ButtonBox["WindowClickSelect",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowClickSelect"],

Cell[TextData[ButtonBox["WindowFloating",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowFloating"],

Cell[TextData[ButtonBox["WindowMovable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowMovable"],

Cell[TextData[ButtonBox["WindowTitle",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"WindowTitle"],

Cell[TextData[ButtonBox["Visible",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Visible"],

Cell[TextData[ButtonBox["PrintingCopies",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrintingCopies"],

Cell[TextData[ButtonBox["PrintingStartingPageNumber",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrintingStartingPageNumber"],

Cell[TextData[ButtonBox["PrintingPageRange",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrintingPageRange"],

Cell[TextData[ButtonBox["PageHeaders",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PageHeaders"],

Cell[TextData[ButtonBox["PageFooters",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PageFooters"],

Cell[TextData[ButtonBox["PageHeaderLines",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PageHeaderLines"],

Cell[TextData[ButtonBox["PageFooterLines",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PageFooterLines"],

Cell[TextData[ButtonBox["SafeFileSave",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SafeFileSave"],

Cell[TextData[ButtonBox["SafeFileOpen",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SafeFileOpen"],

Cell[TextData[ButtonBox["DoubleBuffer",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DoubleBuffer"],

Cell[TextData[ButtonBox["ColorPalette",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ColorPalette"],

Cell[TextData[ButtonBox["BackgroundPostScriptRendering",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"BackgroundPostScriptRendering"],

Cell[TextData[ButtonBox["RealTimeMarginAdjustment",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RealTimeMarginAdjustment"],

Cell[TextData[ButtonBox["RealTimeWindowMove",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RealTimeWindowMove"],

Cell[TextData[ButtonBox["RealTimeWindowResize",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RealTimeWindowResize"],

Cell[TextData[ButtonBox["ShortBoxForm",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShortBoxForm"],

Cell[TextData[ButtonBox["Format",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Format"],

Cell[TextData[ButtonBox["Ellipsis",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Ellipsis"],

Cell[TextData[ButtonBox["MultiPageContinuation",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"MultiPageContinuation"],

Cell[TextData[ButtonBox["PageSeparator",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PageSeparator"],

Cell[TextData[ButtonBox["SectionSeparator",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SectionSeparator"],

Cell[TextData[ButtonBox["MainEntry",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"MainEntry"],

Cell[TextData[ButtonBox["MainPage",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"MainPage"],

Cell[TextData[ButtonBox["CellFrame",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellFrame"],

Cell[TextData[ButtonBox["CellDingbat",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellDingbat"],

Cell[TextData[{
  ButtonBox["Background",
    ButtonData:>"Cell Options Background",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Cell Options)"
}], "Index",
  CellTags->"CellBackground"],

Cell[TextData[ButtonBox["ShowCellBracket",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowCellBracket"],

Cell[TextData[ButtonBox["ShowSelection",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowSelection"],

Cell[TextData[ButtonBox["ShowGroupOpenCloseIcon",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowGroupOpenCloseIcon"],

Cell[TextData[ButtonBox["ShowClosedCellArea",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowClosedCellArea"],

Cell[TextData[ButtonBox["ShowShortBoxForm",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowShortBoxForm"],

Cell[TextData[ButtonBox["CellDisplayCache",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellDisplayCache"],

Cell[TextData[ButtonBox["CellMargins",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellMargins"],

Cell[TextData[ButtonBox["Active",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Active"],

Cell[TextData[ButtonBox["CellEditDuplicate",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellEditDuplicate"],

Cell[TextData[ButtonBox["Evaluatable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Evaluatable"],

Cell[TextData[ButtonBox["Selectable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Selectable"],

Cell[TextData[ButtonBox["Deletable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Deletable"],

Cell[TextData[ButtonBox["Copyable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Copyable"],

Cell[TextData[ButtonBox["CellOpen",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellOpen"],

Cell[TextData[ButtonBox["CellGroupingRules",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellGroupingRules"],

Cell[TextData[ButtonBox["ConversionRules",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ConversionRules"],

Cell[TextData[ButtonBox["TaggingRules",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"TaggingRules"],

Cell[TextData[ButtonBox["CellHorizontalScrolling",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellHorizontalScrolling"],

Cell[TextData[ButtonBox["StyleMenuListing",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"StyleMenuListing"],

Cell[TextData[ButtonBox["ButtonStyleMenuListing",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonStyleMenuListing"],

Cell[TextData[ButtonBox["CounterStyleMenuListing",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CounterStyleMenuListing"],

Cell[TextData[ButtonBox["FormatTypeAutoConvert",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FormatTypeAutoConvert"],

Cell[TextData[ButtonBox["PageBreakAbove",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PageBreakAbove"],

Cell[TextData[ButtonBox["PageBreakWithin",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PageBreakWithin"],

Cell[TextData[ButtonBox["PageBreakBelow",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PageBreakBelow"],

Cell[TextData[ButtonBox["GroupPageBreakWithin",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"GroupPageBreakWithin"],

Cell[TextData[ButtonBox["InitializationCell",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"InitializationCell"],

Cell[TextData[ButtonBox["CellEvaluationDuplicate",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellEvaluationDuplicate"],

Cell[TextData[ButtonBox["GeneratedCell",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"GeneratedCell"],

Cell[TextData[ButtonBox["CellAutoOverwrite",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellAutoOverwrite"],

Cell[TextData[ButtonBox["Evaluator",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Evaluator"],

Cell[TextData[ButtonBox["CellLabel",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellLabel"],

Cell[TextData[ButtonBox["ShowCellLabel",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowCellLabel"],

Cell[TextData[ButtonBox["CellLabelPositioning",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellLabelPositioning"],

Cell[TextData[ButtonBox["CellLabelAutoDelete",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellLabelAutoDelete"],

Cell[TextData[ButtonBox["CellLabelMargins",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellLabelMargins"],

Cell[TextData[ButtonBox["CellFrame",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellFrame"],

Cell[TextData[ButtonBox["CellFrameMargins",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellFrameMargins"],

Cell[TextData[ButtonBox["CellFrameColor",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellFrameColor"],

Cell[TextData[ButtonBox["CellFrameLabelMargins",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellFrameLabelMargins"],

Cell[TextData[ButtonBox["CellFrameLabels",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellFrameLabels"],

Cell[TextData[ButtonBox["ShowCellTags",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowCellTags"],

Cell[TextData[ButtonBox["CellSize",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellSize"],

Cell[TextData[ButtonBox["CellBaseline",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellBaseline"],

Cell[TextData[ButtonBox["DefaultNewCellStyle",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DefaultNewCellStyle"],

Cell[TextData[ButtonBox["DefaultNewInlineCellStyle",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DefaultNewInlineCellStyle"],

Cell[TextData[ButtonBox["DefaultDuplicateCellStyle",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DefaultDuplicateCellStyle"],

Cell[TextData[ButtonBox["DefaultFormatType",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DefaultFormatType"],

Cell[TextData[ButtonBox["DefaultInlineFormatType",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DefaultInlineFormatType"],

Cell[TextData[ButtonBox["FormatType",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FormatType"],

Cell[TextData[ButtonBox["Selectable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Selectable"],

Cell[TextData[ButtonBox["Deletable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Deletable"],

Cell[TextData[ButtonBox["AutoIndent",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AutoIndent"],

Cell[TextData[ButtonBox["InputAliases",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"InputAliases"],

Cell[TextData[ButtonBox["InputAutoReplacements",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"InputAutoReplacements"],

Cell[TextData[ButtonBox["DelimiterFlashTime",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DelimiterFlashTime"],

Cell[TextData[ButtonBox["ShowCursorTracker",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowCursorTracker"],

Cell[TextData[ButtonBox["ShowAutoStyles",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowAutoStyles"],

Cell[TextData[ButtonBox["StructuredSelection",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"StructuredSelection"],

Cell[TextData[ButtonBox["StyleBoxAutoDelete",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"StyleBoxAutoDelete"],

Cell[TextData[ButtonBox["DragAndDrop",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DragAndDrop"],

Cell[TextData[ButtonBox["ShowSpecialCharacters",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowSpecialCharacters"],

Cell[TextData[ButtonBox["AllowInlineCells",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AllowInlineCells"],

Cell[TextData[ButtonBox["PasteBoxFormInlineCells",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PasteBoxFormInlineCells"],

Cell[TextData[ButtonBox["TwoByteSyntaxCharacterAutoReplacement",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"TwoByteSyntaxCharacterAutoReplacement"],

Cell[TextData[ButtonBox["CursorTrackerParameters",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CursorTrackerParameters"],

Cell[TextData[ButtonBox["AutoStyleOptions",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AutoStyleOptions"],

Cell[TextData[ButtonBox["FontSize",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FontSize"],

Cell[TextData[ButtonBox["FontFamily",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FontFamily"],

Cell[TextData[ButtonBox["FontWeight",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FontWeight"],

Cell[TextData[ButtonBox["FontSlant",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FontSlant"],

Cell[TextData[ButtonBox["FontTracking",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FontTracking"],

Cell[TextData[ButtonBox["FontColor",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FontColor"],

Cell[TextData[{
  ButtonBox["Background",
    ButtonData:>"Font Options Background",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Font Options)"
}], "Index",
  CellTags->"FontOptionsBackground"],

Cell[TextData[ButtonBox["CharacterEncoding",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CharacterEncoding"],

Cell[TextData[ButtonBox["Magnification",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Magnification"],

Cell[TextData[ButtonBox["TextAlignment",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"TextAlignment"],

Cell[TextData[ButtonBox["TextJustification",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"TextJustification"],

Cell[TextData[ButtonBox["Hyphenation",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Hyphenation"],

Cell[TextData[ButtonBox["TabFilling",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"TabFilling"],

Cell[TextData[ButtonBox["LineSpacing",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"LineSpacing"],

Cell[TextData[ButtonBox["ParagraphSpacing",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ParagraphSpacing"],

Cell[TextData[ButtonBox["ParagraphIndent",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ParagraphIndent"],

Cell[TextData[ButtonBox["TabSpacings",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"TabSpacings"],

Cell[TextData[ButtonBox["AutoItalicWords",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AutoItalicWords"],

Cell[TextData[ButtonBox["LanguageCategory",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"LanguageCategory"],

Cell[TextData[ButtonBox["DefaultNaturalLanguage",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DefaultNaturalLanguage"],

Cell[TextData[ButtonBox["AutoSpacing",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AutoSpacing"],

Cell[TextData[ButtonBox["ShowContents",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowContents"],

Cell[TextData[ButtonBox["ScriptSizeMultipliers",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ScriptSizeMultipliers"],

Cell[TextData[ButtonBox["ScriptMinSize",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ScriptMinSize"],

Cell[TextData[ButtonBox["ScriptLevel",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ScriptLevel"],

Cell[TextData[ButtonBox["ShowStringCharacters",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ShowStringCharacters"],

Cell[TextData[ButtonBox["NumberMarks",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"NumberMarks"],

Cell[TextData[ButtonBox["PrintPrecision",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrintPrecision"],

Cell[TextData[ButtonBox["NumberMultiplier",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"NumberMultiplier"],

Cell[TextData[ButtonBox["LimitsPositioning",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"LimitsPositioning"],

Cell[TextData[ButtonBox["LimitsPositioningTokens",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"LimitsPositioningTokens"],

Cell[TextData[ButtonBox["ScriptBaselineShifts",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ScriptBaselineShifts"],

Cell[TextData[ButtonBox["SingleLetterItalics",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SingleLetterItalics"],

Cell[TextData[ButtonBox["TraditionalFunctionNotation",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"TraditionalFunctionNotation"],

Cell[TextData[ButtonBox["DelimiterMatching",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DelimiterMatching"],

Cell[TextData[ButtonBox["ZeroWidthTimes",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ZeroWidthTimes"],

Cell[TextData[ButtonBox["SpanMinSize",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SpanMinSize"],

Cell[TextData[ButtonBox["SpanMaxSize",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SpanMaxSize"],

Cell[TextData[ButtonBox["SpanSymmetric",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SpanSymmetric"],

Cell[TextData[ButtonBox["SpanLineThickness",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SpanLineThickness"],

Cell[TextData[ButtonBox["SpanCharacterRounding",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SpanCharacterRounding"],

Cell[TextData[ButtonBox["SpanAdjustments",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SpanAdjustments"],

Cell[TextData[ButtonBox["LineBreakWithin",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"LineBreakWithin"],

Cell[TextData[ButtonBox["LineIndent",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"LineIndent"],

Cell[TextData[ButtonBox["IndentMaxFraction",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"IndentMaxFraction"],

Cell[TextData[ButtonBox["LinebreakAdjustments",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"LinebreakAdjustments"],

Cell[TextData[ButtonBox["AspectRatioFixed",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AspectRatioFixed"],

Cell[TextData[ButtonBox["ImageSize",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ImageSize"],

Cell[TextData[ButtonBox["ImageMargins",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ImageMargins"],

Cell[TextData[ButtonBox["ImageRegion",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ImageRegion"],

Cell[TextData[ButtonBox["AnimationDisplayTime",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AnimationDisplayTime"],

Cell[TextData[ButtonBox["AnimationCycleOffset",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AnimationCycleOffset"],

Cell[TextData[ButtonBox["AnimationCycleRepetitions",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AnimationCycleRepetitions"],

Cell[TextData[ButtonBox["DrawDummyGraphics",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"DrawDummyGraphics"],

Cell[TextData[ButtonBox["RenderIncrementally",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RenderIncrementally"],

Cell[TextData[ButtonBox["RenderFilledAreas",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RenderFilledAreas"],

Cell[TextData[ButtonBox["RenderLines",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RenderLines"],

Cell[TextData[ButtonBox["RenderThickness",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RenderThickness"],

Cell[TextData[ButtonBox["RenderSystemColors",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RenderSystemColors"],

Cell[TextData[ButtonBox["ObjectDithering",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ObjectDithering"],

Cell[TextData[ButtonBox["RasterDithering",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RasterDithering"],

Cell[TextData[ButtonBox["ImageHalftoneDensity",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ImageHalftoneDensity"],

Cell[TextData[ButtonBox["ImageHalftoneAngle",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ImageHalftoneAngle"],

Cell[TextData[ButtonBox["ImageCacheDepth",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ImageCacheDepth"],

Cell[TextData[ButtonBox["Active",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"Active"],

Cell[TextData[ButtonBox["ButtonFunction",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonFunction"],

Cell[TextData[ButtonBox["ButtonSource",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonSource"],

Cell[TextData[ButtonBox["ButtonEvaluator",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonEvaluator"],

Cell[TextData[ButtonBox["ButtonData",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonData"],

Cell[TextData[ButtonBox["ButtonStyle",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonStyle"],

Cell[TextData[ButtonBox["ButtonFrame",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonFrame"],

Cell[TextData[{
  ButtonBox["Background",
    ButtonData:>"Button Box Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Button Options)"
}], "Index",
  CellTags->"ButtonBackground"],

Cell[TextData[ButtonBox["ButtonMargins",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonMargins"],

Cell[TextData[ButtonBox["ButtonExpandable",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonExpandable"],

Cell[TextData[ButtonBox["ButtonMinHeight",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonMinHeight"],

Cell[TextData[ButtonBox["ButtonNote",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonNote"],

Cell[TextData[ButtonBox["PrivatePaths->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrivatePaths->{...}"],

Cell[TextData[{
  ButtonBox["\"TextResources\"",
    ButtonData:>"PrivatePaths",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivatePaths)"
}], "Index",
  CellTags->"TextResources"],

Cell[TextData[{
  ButtonBox["\"SystemResources\"",
    ButtonData:>"PrivatePaths",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivatePaths)"
}], "Index",
  CellTags->"TextResources"],

Cell[TextData[{
  ButtonBox["\"AFM\"",
    ButtonData:>"PrivatePaths",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivatePaths)"
}], "Index",
  CellTags->"AFM"],

Cell[TextData[{
  ButtonBox["\"Fonts\"",
    ButtonData:>"PrivatePaths",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivatePaths)"
}], "Index",
  CellTags->"Fonts"],

Cell[TextData[ButtonBox["OpenSpecialOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"OpenSpecialOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"ReadingType\"",
    ButtonData:>"OpenSpecialOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OpenSpecialOptions)"
}], "Index",
  CellTags->"ReadingType"],

Cell[TextData[{
  ButtonBox["\"CharacterEncoding\"",
    ButtonData:>"OpenSpecialOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OpenSpecialOptions)"
}], "Index",
  CellTags->"CharacterEncoding"],

Cell[TextData[{
  ButtonBox["\"ListAllFileTypes\"",
    ButtonData:>"OpenSpecialOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OpenSpecialOptions)"
}], "Index",
  CellTags->"ListAllFileTypes"],

Cell[TextData[ButtonBox["ToPostScriptOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ToPostScriptOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"RemoveColorFromBitmaps\"",
    ButtonData:>"ToPostScriptOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ToPostScriptOptions)"
}], "Index",
  CellTags->"RemoveColorFromBitmaps"],

Cell[TextData[{
  ButtonBox["\"IgnoreEmbeddedPostScript\"",
    ButtonData:>"ToPostScriptOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ToPostScriptOptions)"
}], "Index",
  CellTags->"IgnoreEmbeddedPostScript"],

Cell[TextData[{
  ButtonBox["\"BitsPerPixel\"",
    ButtonData:>"ToPostScriptOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ToPostScriptOptions)"
}], "Index",
  CellTags->"BitsPerPixel"],

Cell[TextData[ButtonBox["ImportTypesetOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ImportTypesetOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"FormatType\"",
    ButtonData:>"ImportTypesetOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ImportTypesetOptions)"
}], "Index",
  CellTags->"BitsPerPixel"],

Cell[TextData[ButtonBox["ExportMultipleCellsOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ExportMultipleCellsOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"FormatType\"",
    ButtonData:>"ExportMultipleCellsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportMultipleCellsOptions)"
}], "Index",
  CellTags->"FormatType"],

Cell[TextData[{
  ButtonBox["\"PageWidth\"",
    ButtonData:>"ExportMultipleCellsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportMultipleCellsOptions)"
}], "Index",
  CellTags->"PageWidth"],

Cell[TextData[{
  ButtonBox["\"IncludeCellLabels\"",
    ButtonData:>"ExportMultipleCellsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportMultipleCellsOptions)"
}], "Index",
  CellTags->"IncludeCellLabels"],

Cell[TextData[{
  ButtonBox["\"IncludeCellTags\"",
    ButtonData:>"ExportMultipleCellsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportMultipleCellsOptions)"
}], "Index",
  CellTags->"IncludeCellTags"],

Cell[TextData[{
  ButtonBox["\"CellBreaks\"",
    ButtonData:>"ExportMultipleCellsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportMultipleCellsOptions)"
}], "Index",
  CellTags->"CellBreaks"],

Cell[TextData[{
  ButtonBox["\"CMYKColorGeneration\"",
    ButtonData:>"ExportMultipleCellsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportMultipleCellsOptions)"
}], "Index",
  CellTags->"CMYKColorGeneration"],

Cell[TextData[ButtonBox["ExportPostScriptOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ExportPostScriptOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"FormatType\"",
    ButtonData:>"ExportPostScriptOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportPostScriptOptions)"
}], "Index",
  CellTags->"FormatType"],

Cell[TextData[{
  ButtonBox["\"PageWidth",
    ButtonData:>"ExportPostScriptOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  "\" (ExportPostScriptOptions)"
}], "Index",
  CellTags->"PageWidth"],

Cell[TextData[{
  ButtonBox["\"IncludeCellLabels\"",
    ButtonData:>"ExportPostScriptOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportPostScriptOptions)"
}], "Index",
  CellTags->"IncludeCellLabels"],

Cell[TextData[{
  ButtonBox["\"IncludeCellTags\"",
    ButtonData:>"ExportPostScriptOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportPostScriptOptions)"
}], "Index",
  CellTags->"IncludeCellTags"],

Cell[TextData[{
  ButtonBox["\"CellBreaks\"",
    ButtonData:>"ExportPostScriptOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportPostScriptOptions)"
}], "Index",
  CellTags->"CellBreaks"],

Cell[TextData[{
  ButtonBox["\"CMYKColorGeneration\"",
    ButtonData:>"ExportPostScriptOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportPostScriptOptions)"
}], "Index",
  CellTags->"CMYKColorGeneration"],

Cell[TextData[ButtonBox["ExportNativeGraphicsOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ExportNativeGraphicsOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"FormatType\"",
    ButtonData:>"ExportNativeGraphicsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportNativeGraphicsOptions)"
}], "Index",
  CellTags->"FormatType"],

Cell[TextData[{
  ButtonBox["\"PageWidth\"",
    ButtonData:>"ExportNativeGraphicsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportNativeGraphicsOptions)"
}], "Index",
  CellTags->"PageWidth"],

Cell[TextData[{
  ButtonBox["\"IncludeCellLabels\"",
    ButtonData:>"ExportNativeGraphicsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportNativeGraphicsOptions)"
}], "Index",
  CellTags->"IncludeCellLabels"],

Cell[TextData[{
  ButtonBox["\"IncludeCellTags\"",
    ButtonData:>"ExportNativeGraphicsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportNativeGraphicsOptions)"
}], "Index",
  CellTags->"IncludeCellTags"],

Cell[TextData[{
  ButtonBox["\"CellBreaks\"",
    ButtonData:>"ExportNativeGraphicsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportNativeGraphicsOptions)"
}], "Index",
  CellTags->"CellBreaks"],

Cell[TextData[{
  ButtonBox["\"CMYKColorGeneration\"",
    ButtonData:>"ExportNativeGraphicsOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportNativeGraphicsOptions)"
}], "Index",
  CellTags->"CMYKColorGeneration"],

Cell[TextData[ButtonBox["ExportTypesetOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ExportTypesetOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"FormatType\"",
    ButtonData:>"ExportTypesetOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportTypesetOptions)"
}], "Index",
  CellTags->"FormatType"],

Cell[TextData[{
  ButtonBox["\"PageWidth\"",
    ButtonData:>"ExportTypesetOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportTypesetOptions)"
}], "Index",
  CellTags->"PageWidth"],

Cell[TextData[{
  ButtonBox["\"IncludeCellLabels\"",
    ButtonData:>"ExportTypesetOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportTypesetOptions)"
}], "Index",
  CellTags->"IncludeCellLabels"],

Cell[TextData[{
  ButtonBox["\"IncludeCellTags\"",
    ButtonData:>"ExportTypesetOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportTypesetOptions)"
}], "Index",
  CellTags->"IncludeCellTags"],

Cell[TextData[{
  ButtonBox["\"CellBreaks\"",
    ButtonData:>"ExportTypesetOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportTypesetOptions)"
}], "Index",
  CellTags->"CellBreaks"],

Cell[TextData[{
  ButtonBox["\"CMYKColorGeneration\"",
    ButtonData:>"ExportTypesetOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportTypesetOptions)"
}], "Index",
  CellTags->"CMYKColorGeneration"],

Cell[TextData[ButtonBox["ExportQuickTimeOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ExportQuickTimeOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"FormatType\"",
    ButtonData:>"ExportQuickTimeOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportQuickTimeOptions)"
}], "Index",
  CellTags->"FormatType"],

Cell[TextData[{
  ButtonBox["\"PageWidth\"",
    ButtonData:>"ExportQuickTimeOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportQuickTimeOptions)"
}], "Index",
  CellTags->"PageWidth"],

Cell[TextData[{
  ButtonBox["\"IncludeCellLabels\"",
    ButtonData:>"ExportQuickTimeOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportQuickTimeOptions)"
}], "Index",
  CellTags->"IncludeCellLabels"],

Cell[TextData[{
  ButtonBox["\"IncludeCellTags\"",
    ButtonData:>"ExportQuickTimeOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportQuickTimeOptions)"
}], "Index",
  CellTags->"IncludeCellTags"],

Cell[TextData[{
  ButtonBox["\"CellBreaks\"",
    ButtonData:>"ExportQuickTimeOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportQuickTimeOptions)"
}], "Index",
  CellTags->"CellBreaks"],

Cell[TextData[{
  ButtonBox["\"CMYKColorGeneration\"",
    ButtonData:>"ExportQuickTimeOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ExportQuickTimeOptions)"
}], "Index",
  CellTags->"CMYKColorGeneration"],

Cell[TextData[ButtonBox["SaveAsSpecialOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SaveAsSpecialOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"FormatType\"",
    ButtonData:>"SaveAsSpecialOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SaveAsSpecialOptions)"
}], "Index",
  CellTags->"FormatType"],

Cell[TextData[{
  ButtonBox["\"PageWidth\"",
    ButtonData:>"SaveAsSpecialOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SaveAsSpecialOptions)"
}], "Index",
  CellTags->"PageWidth"],

Cell[TextData[{
  ButtonBox["\"IncludeCellLabels\"",
    ButtonData:>"SaveAsSpecialOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SaveAsSpecialOptions)"
}], "Index",
  CellTags->"IncludeCellLabels"],

Cell[TextData[{
  ButtonBox["\"IncludeCellTags\"",
    ButtonData:>"SaveAsSpecialOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SaveAsSpecialOptions)"
}], "Index",
  CellTags->"IncludeCellTags"],

Cell[TextData[{
  ButtonBox["\"CellBreaks\"",
    ButtonData:>"SaveAsSpecialOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SaveAsSpecialOptions)"
}], "Index",
  CellTags->"CellBreaks"],

Cell[TextData[{
  ButtonBox["\"CMYKColorGeneration\"",
    ButtonData:>"SaveAsSpecialOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SaveAsSpecialOptions)"
}], "Index",
  CellTags->"CMYKColorGeneration"],

Cell[TextData[ButtonBox["FindSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FindSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"FindString\"",
    ButtonData:>"FindSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FindSettings)"
}], "Index",
  CellTags->"FindString"],

Cell[TextData[{
  ButtonBox["\"ReplaceString\"",
    ButtonData:>"FindSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FindSettings)"
}], "Index",
  CellTags->"ReplaceString"],

Cell[TextData[{
  ButtonBox["\"IgnoreCase\"",
    ButtonData:>"FindSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FindSettings)"
}], "Index",
  CellTags->"IgnoreCase"],

Cell[TextData[{
  ButtonBox["\"Wraparound\"",
    ButtonData:>"FindSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FindSettings)"
}], "Index",
  CellTags->"Wraparound"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"FindSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FindSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["EditCellTagsSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"EditCellTagsSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"CellTags\"",
    ButtonData:>"EditCellTagsSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (EditCellTagsSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"EditCellTagsSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (EditCellTagsSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["ViewPointSelectorSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ViewPointSelectorSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"CoordinateSystem\"",
    ButtonData:>"ViewPointSelectorSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ViewPointSelectorSettings)"
}], "Index",
  CellTags->"CoordinateSystem"],

Cell[TextData[{
  ButtonBox["\"TemplateText\"",
    ButtonData:>"ViewPointSelectorSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ViewPointSelectorSettings)"
}], "Index",
  CellTags->"TemplateText"],

Cell[TextData[{
  ButtonBox["\"ViewPoint\"",
    ButtonData:>"ViewPointSelectorSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ViewPointSelectorSettings)"
}], "Index",
  CellTags->"ViewPoint"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"ViewPointSelectorSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ViewPointSelectorSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["ColorSelectorSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ColorSelectorSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"Color\"",
    ButtonData:>"ColorSelectorSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ColorSelectorSettings)"
}], "Index",
  CellTags->"Color"],

Cell[TextData[ButtonBox["GridCreationSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"GridCreationSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"Rows\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"Rows"],

Cell[TextData[{
  ButtonBox["\"Columns\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"Columns"],

Cell[TextData[{
  ButtonBox["\"DrawRowLines\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"DrawRowLines"],

Cell[TextData[{
  ButtonBox["\"DrawColumnLines\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"DrawColumnLines"],

Cell[TextData[{
  ButtonBox["\"DrawFrame\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"DrawFrame"],

Cell[TextData[{
  ButtonBox["\"Type\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"Type"],

Cell[TextData[{
  ButtonBox["\"Fill\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"Fill"],

Cell[TextData[{
  ButtonBox["\"DiagonalFill\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"DiagonalFill"],

Cell[TextData[{
  ButtonBox["\"FillText\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"FillText"],

Cell[TextData[{
  ButtonBox["\"DiagonalFillText\"",
    ButtonData:>"GridCreationSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridCreationSettings)"
}], "Index",
  CellTags->"DiagonalFillText"],

Cell[TextData[ButtonBox["NotebookStatisticsSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"NotebookStatisticsSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"Domain\"",
    ButtonData:>"NotebookStatisticsSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (NotebookStatisticsSettings)"
}], "Index",
  CellTags->"Domain"],

Cell[TextData[{
  ButtonBox["\"IncludeSharedData\"",
    ButtonData:>"NotebookStatisticsSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (NotebookStatisticsSettings)"
}], "Index",
  CellTags->"IncludeSharedData"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"NotebookStatisticsSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (NotebookStatisticsSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["OptionInspectorSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"OptionInspectorSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"Scope\"",
    ButtonData:>"OptionInspectorSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OptionInspectorSettings)"
}], "Index",
  CellTags->"Scope"],

Cell[TextData[{
  ButtonBox["\"ViewAs\"",
    ButtonData:>"OptionInspectorSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OptionInspectorSettings)"
}], "Index",
  CellTags->"ViewAs"],

Cell[TextData[{
  ButtonBox["\"WindowSize\"",
    ButtonData:>"OptionInspectorSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OptionInspectorSettings)"
}], "Index",
  CellTags->"WindowSize"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"OptionInspectorSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OptionInspectorSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["EditButtonSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"EditButtonSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"EditButtonSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (EditButtonSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["BackgroundTasksSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"BackgroundTasksSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"BackgroundTasksSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (BackgroundTasksSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["InterruptSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"InterruptSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"InterruptSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (InterruptSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["InputSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"InputSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"InputSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (InputSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["HelpBrowserSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"HelpBrowserSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"ShowCategories\"",
    ButtonData:>"HelpBrowserSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (HelpBrowserSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[{
  ButtonBox["\"WindowSize\"",
    ButtonData:>"HelpBrowserSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (HelpBrowserSettings)"
}], "Index",
  CellTags->"WindowSize"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"HelpBrowserSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (HelpBrowserSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["ErrorsDialogSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ErrorsDialogSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"WindowMargins\"",
    ButtonData:>"ErrorsDialogSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ErrorsDialogSettings)"
}], "Index",
  CellTags->"WindowMargins"],

Cell[TextData[ButtonBox["StyleNameDialogSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"StyleNameDialogSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"Style\"",
    ButtonData:>"StyleNameDialogSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (StyleNameDialogSettings)"
}], "Index",
  CellTags->"Style"],

Cell[TextData[ButtonBox["FileNameDialogSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FileNameDialogSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"StringFormat\"",
    ButtonData:>"FilenameDialogSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FileNameDialogSettings)"
}], "Index",
  CellTags->"StringFormat"],

Cell[TextData[ButtonBox["NotebookConvertSettings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"NotebookConvertSettings->{...}"],

Cell[TextData[{
  ButtonBox["\"InputToStandardForm\"",
    ButtonData:>"NotebookConvertSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (NotebookConvertSettings)"
}], "Index",
  CellTags->"InputToStandardForm"],

Cell[TextData[{
  ButtonBox["\"OutputToStandardForm\"",
    ButtonData:>"NotebookConvertSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (NotebookConvertSettings)"
}], "Index",
  CellTags->"OutputToStandardForm"],

Cell[TextData[{
  ButtonBox["\"PreserveStyleSheet\"",
    ButtonData:>"NotebookConvertSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (NotebookConvertSettings)"
}], "Index",
  CellTags->"PreserveStyleSheet"],

Cell[TextData[{
  ButtonBox["\"GenerateBitmapCaches\"",
    ButtonData:>"NotebookConvertSettings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (NotebookConvertSettings)"
}], "Index",
  CellTags->"GenerateBitmapCaches"],

Cell[TextData[ButtonBox["ScrollingOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ScrollingOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"PagewiseScrolling\"",
    ButtonData:>"ScrollingOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ScrollingOptions)"
}], "Index",
  CellTags->"PagewiseScrolling"],

Cell[TextData[{
  ButtonBox["\"PagewiseDisplay\"",
    ButtonData:>"ScrollingOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ScrollingOptions)"
}], "Index",
  CellTags->"PagewiseDisplay"],

Cell[TextData[{
  ButtonBox["\"RealTimeScrolling\"",
    ButtonData:>"ScrollingOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ScrollingOptions)"
}], "Index",
  CellTags->"RealTimeScrolling"],

Cell[TextData[{
  ButtonBox["\"JumpScrolling\"",
    ButtonData:>"ScrollingOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ScrollingOptions)"
}], "Index",
  CellTags->"JumpScrolling"],

Cell[TextData[{
  ButtonBox["\"VerticalScrollRange\"",
    ButtonData:>"ScrollingOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ScrollingOptions)"
}], "Index",
  CellTags->"VerticalScrollRange"],

Cell[TextData[{
  ButtonBox["\"HorizontalScrollRange\"",
    ButtonData:>"ScrollingOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ScrollingOptions)"
}], "Index",
  CellTags->"HorizontalScrollRange"],

Cell[TextData[{
  ButtonBox["\"SpeedParameters\"",
    ButtonData:>"ScrollingOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ScrollingOptions)"
}], "Index",
  CellTags->"SpeedParameters"],

Cell[TextData[ButtonBox["PrintingOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrintingOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"PaperOrientation\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"PaperOrientation"],

Cell[TextData[{
  ButtonBox["\"PrintCellBrackets\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"PrintCellBrackets"],

Cell[TextData[{
  ButtonBox["\"PrintSelectionHighlighting\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"PrintSelectionHighlighting"],

Cell[TextData[{
  ButtonBox["\"PrintRegistrationMarks\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"PrintRegistrationMarks"],

Cell[TextData[{
  ButtonBox["\"PrintMultipleHorizontalPages\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"PrintMultipleHorizontalPages"],

Cell[TextData[{
  ButtonBox["\"FirstPageHeader\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"FirstPageHeader"],

Cell[TextData[{
  ButtonBox["\"FirstPageFooter\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"FirstPageFooter"],

Cell[TextData[{
  ButtonBox["\"RestPagesHeader\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["\"RestPagesFooter\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["\"FacingPages\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"FacingPages"],

Cell[TextData[{
  ButtonBox["\"FirstPageFace\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"FirstPageFace"],

Cell[TextData[{
  ButtonBox["\"GraphicsPrintingFormat\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"GraphicsPrintingFormat"],

Cell[TextData[{
  ButtonBox["\"Magnification\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"Magnification"],

Cell[TextData[{
  ButtonBox["\"CellBackgroundHalftoneDensity\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneDensity"],

Cell[TextData[{
  ButtonBox["\"CellBackgroundHalftoneAngle\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["\"IncludeSpecialFonts\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["\"IncludePostScriptResourceDirectives\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["\"PostScriptOutputFile\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["\"UsePostScriptOutputFile\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["\"UnixShellPrintingCommand\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["\"UseUnixShellPrintingCommand\"",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["PrintingMargins",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["PaperSize",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["PageSize",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"CellBackgroundHalftoneAngle"],

Cell[TextData[{
  ButtonBox["PageHeaderMargins",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"PageHeaderMargins"],

Cell[TextData[{
  ButtonBox["PageFooterMargins",
    ButtonData:>"PrintingOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrintingOptions)"
}], "Index",
  CellTags->"PageFooterMargins"],

Cell[TextData[ButtonBox["IndexCreationOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"IndexCreationOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"Format\"",
    ButtonData:>"IndexCreationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (IndexCreationOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[{
  ButtonBox["\"Ellipses\"",
    ButtonData:>"IndexCreationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (IndexCreationOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[{
  ButtonBox["\"MultiPageContinuation\"",
    ButtonData:>"IndexCreationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (IndexCreationOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[{
  ButtonBox["\"PageSeparator\"",
    ButtonData:>"IndexCreationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (IndexCreationOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[{
  ButtonBox["\"SectionSeparator\"",
    ButtonData:>"IndexCreationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (IndexCreationOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[{
  ButtonBox["\"MainEntry\"",
    ButtonData:>"IndexCreationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (IndexCreationOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[{
  ButtonBox["\"MainPage\"",
    ButtonData:>"IndexCreationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (IndexCreationOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[ButtonBox["CellBracketOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellBracketOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"Thickness\"",
    ButtonData:>"CellBracketOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CellBracketOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[{
  ButtonBox["\"Color\"",
    ButtonData:>"CellBracketOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CellBracketOptions)"
}], "Index",
  CellTags->"Color"],

Cell[TextData[{
  ButtonBox["\"Margins\"",
    ButtonData:>"CellBracketOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CellBracketOptions)"
}], "Index",
  CellTags->"Margins"],

Cell[TextData[{
  ButtonBox["\"Widths\"",
    ButtonData:>"CellBracketOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CellBracketOptions)"
}], "Index",
  CellTags->"Widths"],

Cell[TextData[ButtonBox["CellElementSpacings->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CellElementSpacings->{...}"],

Cell[TextData[{
  ButtonBox["\"CellMinHeight\"",
    ButtonData:>"CellElementSpacings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CellElementSpacings)"
}], "Index",
  CellTags->"CellMinHeight"],

Cell[TextData[{
  ButtonBox["\"ClosedCellHeight\"",
    ButtonData:>"CellElementSpacings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CellElementSpacings)"
}], "Index",
  CellTags->"ClosedCellHeight"],

Cell[TextData[{
  ButtonBox["\"ClosedGroupTopMargin\"",
    ButtonData:>"CellElementSpacings",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CellElementSpacings)"
}], "Index",
  CellTags->"ClosedGroupTopMargin"],

Cell[TextData[ButtonBox["PrivateCellOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrivateCellOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"CellDisplayCache\"",
    ButtonData:>"CellBracketOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivateCellOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[{
  ButtonBox["\"DefaultCellGroupOpen\"",
    ButtonData:>"CellBracketOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivateCellOptions)"
}], "Index",
  CellTags->"Thickness"],

Cell[TextData[ButtonBox["PrivateEvaluationOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrivateEvaluationOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"OutputFormPageWidth\"",
    ButtonData:>"PrivateEvaluationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivateEvaluationOptions)"
}], "Index",
  CellTags->"OutputFormPageWidth\" "],

Cell[TextData[{
  ButtonBox["\"StoreInputForm\" ",
    ButtonData:>"PrivateEvaluationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivateEvaluationOptions)"
}], "Index",
  CellTags->"StoreInputForm\" "],

Cell[TextData[ButtonBox["CommonDefaultFormatTypes->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CommonDefaultFormatTypes->{...}"],

Cell[TextData[{
  ButtonBox["\"Text\"",
    ButtonData:>"CommonDefaultFormatTypes",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CommonDefaultFormatTypes)"
}], "Index",
  CellTags->"Text"],

Cell[TextData[{
  ButtonBox["\"Input\"",
    ButtonData:>"CommonDefaultFormatTypes",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CommonDefaultFormatTypes)"
}], "Index",
  CellTags->"Input"],

Cell[TextData[{
  ButtonBox["\"Output\"",
    ButtonData:>"CommonDefaultFormatTypes",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CommonDefaultFormatTypes)"
}], "Index",
  CellTags->"Output"],

Cell[TextData[{
  ButtonBox["\"TextInline\"",
    ButtonData:>"CommonDefaultFormatTypes",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CommonDefaultFormatTypes)"
}], "Index",
  CellTags->"TextInline"],

Cell[TextData[{
  ButtonBox["\"OutputInline\"",
    ButtonData:>"CommonDefaultFormatTypes",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CommonDefaultFormatTypes)"
}], "Index",
  CellTags->"OutputInline"],

Cell[TextData[{
  ButtonBox["\"InputInline\"",
    ButtonData:>"CommonDefaultFormatTypes",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CommonDefaultFormatTypes)"
}], "Index",
  CellTags->"InputInline"],

Cell[TextData[ButtonBox["FontVariations->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FontVariations->{...}"],

Cell[TextData[{
  ButtonBox["\"Underline\"",
    ButtonData:>"FontVariations",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FontVariations)"
}], "Index",
  CellTags->"Underline"],

Cell[TextData[{
  ButtonBox["\"Outline\"",
    ButtonData:>"FontVariations",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FontVariations)"
}], "Index",
  CellTags->"Outline"],

Cell[TextData[{
  ButtonBox["\"Shadow\"",
    ButtonData:>"FontVariations",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FontVariations)"
}], "Index",
  CellTags->"Shadow"],

Cell[TextData[{
  ButtonBox["\"StrikeThrough\"",
    ButtonData:>"FontVariations",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FontVariations)"
}], "Index",
  CellTags->"StrikeThrough"],

Cell[TextData[{
  ButtonBox["\"Masked\"",
    ButtonData:>"FontVariations",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FontVariations)"
}], "Index",
  CellTags->"Masked"],

Cell[TextData[{
  ButtonBox["\"CompatibilityType\"",
    ButtonData:>"FontVariations",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FontVariations)"
}], "Index",
  CellTags->"CompatibilityType"],

Cell[TextData[{
  ButtonBox["\"RotationAngle\"",
    ButtonData:>"FontVariations",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FontVariations)"
}], "Index",
  CellTags->"Masked"],

Cell[TextData[ButtonBox["FontProperties->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FontProperties->{...}"],

Cell[TextData[{
  ButtonBox["\"FontSerifed\"",
    ButtonData:>"FontProperties",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FontProperties)"
}], "Index",
  CellTags->"FontSerifed"],

Cell[TextData[{
  ButtonBox["\"FontMonospaced\"",
    ButtonData:>"FontProperties",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FontProperties)"
}], "Index",
  CellTags->"FontMonospaced"],

Cell[TextData[ButtonBox["PrivateFontOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"PrivateFontOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"FontPostScriptName\"",
    ButtonData:>"PrivateFontOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivateFontOptions)"
}], "Index",
  CellTags->"FontPostScriptName"],

Cell[TextData[{
  ButtonBox["\"FontType\"",
    ButtonData:>"PrivateFontOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivateFontOptions)"
}], "Index",
  CellTags->"FontType"],

Cell[TextData[{
  ButtonBox["\"OperatorSubstitution\"",
    ButtonData:>"PrivateFontOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivateFontOptions)"
}], "Index",
  CellTags->"OperatorSubstitution"],

Cell[TextData[{
  ButtonBox["\"WindowsUseTrueTypeName\"",
    ButtonData:>"PrivateFontOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (PrivateFontOptions)"
}], "Index",
  CellTags->"OperatorSubstitution"],

Cell[TextData[ButtonBox["HyphenationOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"HyphenationOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"HyphenationFreeZone\"",
    ButtonData:>"HyphenationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (HyphenationOptions)"
}], "Index",
  CellTags->"HyphenationFreeZone"],

Cell[TextData[{
  ButtonBox["\"HyphenationCharacter\"",
    ButtonData:>"HyphenationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (HyphenationOptions)"
}], "Index",
  CellTags->"HyphenationCharacter"],

Cell[TextData[{
  ButtonBox["\"HyphenationMinLengths\"",
    ButtonData:>"HyphenationOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (HyphenationOptions)"
}], "Index",
  CellTags->"HyphenationMinLengths"],

Cell[TextData[ButtonBox["SpellingOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SpellingOptions->{...}"],

Cell[TextData[{
  ButtonBox["\"AlwaysStop\"",
    ButtonData:>"SpellingOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SpellingOptions)"
}], "Index",
  CellTags->"AlwaysStop"],

Cell[TextData[{
  ButtonBox["\"AlwaysSkip\"",
    ButtonData:>"SpellingOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SpellingOptions)"
}], "Index",
  CellTags->"AlwaysSkip"],

Cell[TextData[{
  ButtonBox["\"WordSplitting\"",
    ButtonData:>"SpellingOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SpellingOptions)"
}], "Index",
  CellTags->"WordSplitting"],

Cell[TextData[ButtonBox["SpellingDictionaries->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SpellingDictionaries->{...}"],

Cell[TextData[{
  ButtonBox["\"CorrectWords\"",
    ButtonData:>"SpellingDictionaries->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SpellingDictionaries)"
}], "Index",
  CellTags->"CorrectWords"],

Cell[TextData[{
  ButtonBox["\"IncorrectWords\"",
    ButtonData:>"SpellingDictionaries->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SpellingDictionaries)"
}], "Index",
  CellTags->"IncorrectWords"],

Cell[TextData[{
  ButtonBox["\"Suggestions\"",
    ButtonData:>"SpellingDictionaries->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SpellingDictionaries)"
}], "Index",
  CellTags->"Suggestions"],

Cell[TextData[ButtonBox["AdjustmentBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"AdjustmentBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["BoxMargins",
    ButtonData:>"AdjustmentBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (AdjustmentBoxOptions)"
}], "Index",
  CellTags->"AdjustmentBoxOptions"],

Cell[TextData[{
  ButtonBox["BoxBaselineShift",
    ButtonData:>"AdjustmentBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (AdjustmentBoxOptions)"
}], "Index",
  CellTags->"BoxBaselineShift"],

Cell[TextData[ButtonBox["ButtonBoxOptions->{...}",
  ButtonData:>{"Button Box Options", None},
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ButtonBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["ButtonStyle",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonBoxOptions)"
}], "Index",
  CellTags->"ButtonStyle"],

Cell[TextData[{
  ButtonBox["ButtonFunction",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonBoxOptions)"
}], "Index",
  CellTags->"ButtonFunction"],

Cell[TextData[{
  ButtonBox["ButtonEvaluator",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonBoxOptions)"
}], "Index",
  CellTags->"ButtonEvaluator"],

Cell[TextData[{
  ButtonBox["ButtonSource",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonBoxOptions)"
}], "Index",
  CellTags->"ButtonSource"],

Cell[TextData[{
  ButtonBox["ButtonData",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonB",
  "oxO",
  "ptions)"
}], "Index",
  CellTags->"ButtonData"],

Cell[TextData[{
  ButtonBox["ButtonNote",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonB",
  "oxO",
  "ptions)"
}], "Index",
  CellTags->"ButtonNote"],

Cell[TextData[{
  ButtonBox["ButtonFrame",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonB",
  "oxO",
  "ptions)"
}], "Index",
  CellTags->"ButtonFrame"],

Cell[TextData[{
  ButtonBox["Background",
    ButtonData:>"Button Background",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Button Options)"
}], "Index",
  CellTags->"ButtonBackground"],

Cell[TextData[{
  ButtonBox["ButtonMargins",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonB",
  "oxO",
  "ptions)"
}], "Index",
  CellTags->"ButtonMargins"],

Cell[TextData[{
  ButtonBox["ButtonMinHeight",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonB",
  "oxO",
  "ptions)"
}], "Index",
  CellTags->"ButtonMinHeight"],

Cell[TextData[{
  ButtonBox["ButtonExpandable",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonB",
  "oxO",
  "ptions)"
}], "Index",
  CellTags->"ButtonExpandable"],

Cell[TextData[{
  ButtonBox["Active",
    ButtonData:>"ButtonBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ButtonBoxOptions)"
}], "Index",
  CellTags->"Active"],

Cell[TextData[ButtonBox["CounterBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"CounterBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["counter name",
    ButtonData:>"CounterBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CounterBoxOptions)"
}], "Index",
  CellTags->"CounterData"],

Cell[TextData[{
  ButtonBox["reference file",
    ButtonData:>"CounterBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CounterBoxOptions)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[{
  ButtonBox["reference tag",
    ButtonData:>"CounterBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CounterBoxOptions)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[{
  ButtonBox["CounterStyle",
    ButtonData:>"CounterBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CounterBoxOptions)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[{
  ButtonBox["CounterFunction",
    ButtonData:>"CounterBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (CounterBoxOptions)"
}], "Index",
  CellTags->"CounterFunction"],

Cell[TextData[ButtonBox["ValueBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ValueBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["option name",
    ButtonData:>"ValueBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ValueBoxOptions)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[{
  ButtonBox["reference file",
    ButtonData:>"ValueBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ValueBoxOptions)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[{
  ButtonBox["reference tag",
    ButtonData:>"ValueBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ValueBoxOptions)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[ButtonBox["OptionValueBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"OptionValueBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["option name",
    ButtonData:>"OptionValueBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OptionValueBoxOptions)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[{
  ButtonBox["reference file",
    ButtonData:>"OptionValueBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OptionValueBoxOptions)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[{
  ButtonBox["reference tag",
    ButtonData:>"OptionValueBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OptionValueBoxOptions)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[ButtonBox["ErrorBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"ErrorBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["AutoDelete",
    ButtonData:>"ErrorBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ErrorBoxOptions)"
}], "Index",
  CellTags->"AutoDelete"],

Cell[TextData[{
  ButtonBox["SaveAutoDelete",
    ButtonData:>"ErrorBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (ErrorBoxOptions)"
}], "Index",
  CellTags->"SaveAutoDelete"],

Cell[TextData[ButtonBox["FormBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FormBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["FormatType",
    ButtonData:>"FormBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FormBoxOptions)"
}], "Index",
  CellTags->"AutoDelete"],

Cell[TextData[ButtonBox["FractionBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FractionBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["FractionLine",
    ButtonData:>"FractionBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FractionBoxOptions)"
}], "Index",
  CellTags->"FractionLine"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"FractionBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FractionBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[ButtonBox["FrameBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"FrameBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["BoxFrame",
    ButtonData:>"FrameBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FrameBoxOptions)"
}], "Index",
  CellTags->"BoxFrame"],

Cell[TextData[{
  ButtonBox["BoxMargins",
    ButtonData:>"FrameBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (FrameBoxOptions)"
}], "Index",
  CellTags->"BoxMargins"],

Cell[TextData[ButtonBox["GridBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"GridBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["GridFrame",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"GridFrame"],

Cell[TextData[{
  ButtonBox["GridFrameMargins",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"GridFrameMargins"],

Cell[TextData[{
  ButtonBox["RowLines",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"RowLines"],

Cell[TextData[{
  ButtonBox["ColumnLines",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"ColumnLines"],

Cell[TextData[{
  ButtonBox["GridBaseline",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"GridBaseline"],

Cell[TextData[{
  ButtonBox["AutoDelete",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"AutoDelete"],

Cell[TextData[{
  ButtonBox["AllowScriptLevelChange",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"AutoDelete"],

Cell[TextData[{
  ButtonBox["RowSpacings",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"RowSpacings"],

Cell[TextData[{
  ButtonBox["ColumnSpacings",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"ColumnSpacings"],

Cell[TextData[{
  ButtonBox["ColumnWidths",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"ColumnWidths"],

Cell[TextData[{
  ButtonBox["RowAlignments",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"RowAlignments"],

Cell[TextData[{
  ButtonBox["ColumnAlignments",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"ColumnAlignments"],

Cell[TextData[{
  ButtonBox["RowsMinHeight",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"RowsMinHeight"],

Cell[TextData[{
  ButtonBox["RowsEqual",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"RowsEqual"],

Cell[TextData[{
  ButtonBox["ColumnsEqual",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"ColumnsEqual"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"GridBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[{
  ButtonBox["GridDefaultElement",
    ButtonData:>"CounterBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (GridBoxOptions)"
}], "Index",
  CellTags->"GridDefaultElement"],

Cell[TextData[ButtonBox["InterpretationBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"InterpretationBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["interpretation",
    ButtonData:>"InterpretationBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (InterpretationBoxOptions)"
}], "Index",
  CellTags->"TagStyle"],

Cell[TextData[{
  ButtonBox["TagStyle",
    ButtonData:>"InterpretationBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (InterpretationBoxOptions)"
}], "Index",
  CellTags->"TagStyle"],

Cell[TextData[{
  ButtonBox["Selectable",
    ButtonData:>"InterpretationBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (InterpretationBoxOptions)"
}], "Index",
  CellTags->"Selectable"],

Cell[TextData[{
  ButtonBox["AutoDelete",
    ButtonData:>"InterpretationBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (InterpretationBoxOptions)"
}], "Index",
  CellTags->"AutoDelete"],

Cell[TextData[{
  ButtonBox["DeletionWarning",
    ButtonData:>"InterpretationBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (InterpretationBoxOptions)"
}], "Index",
  CellTags->"DeletionWarning"],

Cell[TextData[{
  ButtonBox["SyntaxForm",
    ButtonData:>"InterpretationBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (InterpretationBoxOptions)"
}], "Index",
  CellTags->"SyntaxForm"],

Cell[TextData[ButtonBox["RadicalBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"RadicalBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["ExponentPosition",
    ButtonData:>"RadicalBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (RadicalBoxOptions)"
}], "Index",
  CellTags->"ExponentPosition"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"RadicalBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (RadicalBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[ButtonBox["SqrtBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SqrtBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"SqrtBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SqrtBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[ButtonBox["SubscriptBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SubscriptBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"SqrtBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SubscriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[ButtonBox["SubsuperscriptBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SubsuperscriptBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"SqrtBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SqrtBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[ButtonBox["SuperscriptBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"SuperscriptBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"SqrtBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (SuperscriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[ButtonBox["TagBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"TagBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["interpretation",
    ButtonData:>"TagBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (TagBoxOptions)"
}], "Index",
  CellTags->"TagStyle"],

Cell[TextData[{
  ButtonBox["TagStyle",
    ButtonData:>"TagBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (TagBoxOptions)"
}], "Index",
  CellTags->"TagStyle"],

Cell[TextData[{
  ButtonBox["Selectable",
    ButtonData:>"TagBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (TagBoxOptions)"
}], "Index",
  CellTags->"Selectable"],

Cell[TextData[{
  ButtonBox["AutoDelete",
    ButtonData:>"TagBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (TagBoxOptions)"
}], "Index",
  CellTags->"AutoDelete"],

Cell[TextData[{
  ButtonBox["StripWrapperBoxes",
    ButtonData:>"TagBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (TagBoxOptions)"
}], "Index",
  CellTags->"StripWrapperBoxes"],

Cell[TextData[{
  ButtonBox["DeletionWarning",
    ButtonData:>"TagBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (TagBoxOptions)"
}], "Index",
  CellTags->"DeletionWarning"],

Cell[TextData[{
  ButtonBox["SyntaxForm",
    ButtonData:>"TagBoxOptions->",
    ButtonStyle->"OtherInformationLinkMR"],
  " (TagBoxOptions)"
}], "Index",
  CellTags->"SyntaxForm"],

Cell[TextData[ButtonBox["UnderScriptBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"UnderScriptBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["LimitsPositioning",
    ButtonData:>"UnderscriptBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (UnderscriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[{
  ButtonBox["DiacriticalPositioning",
    ButtonData:>"UnderscriptBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (UnderscriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"UnderscriptBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (UnderscriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[ButtonBox["OverscriptBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"OverScriptBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["LimitsPositioning",
    ButtonData:>"OverscriptBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OverscriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[{
  ButtonBox["DiacriticalPositioning",
    ButtonData:>"OverscriptBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OverscriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"OverscriptBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (OverscriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[ButtonBox["UnderoverscriptBoxOptions->{...}",
  ButtonStyle->"OtherInformationLinkMR"]], "Index",
  CellTags->"UnderoverscriptBoxOptions->{...}"],

Cell[TextData[{
  ButtonBox["LimitsPositioning",
    ButtonData:>"UnderScriptBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (UnderScriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[{
  ButtonBox["DiacriticalPositioning",
    ButtonData:>"UnderScriptBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (UnderScriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[{
  ButtonBox["MultilineFunction",
    ButtonData:>"UnderScriptBoxOptions",
    ButtonStyle->"OtherInformationLinkMR"],
  " (UnderScriptBoxOptions)"
}], "Index",
  CellTags->"MultilineFunction"],

Cell[TextData[{
  ButtonBox["GridDefaultElement ",
    ButtonData:>"Global Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"GridDefaultElement"],

Cell[TextData[{
  ButtonBox["GridBaseline",
    ButtonData:>"Global Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"GridBaseline"],

Cell[TextData[{
  ButtonBox["AutoDelete",
    ButtonData:>"Global Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"AutoDelete"],

Cell[TextData[{
  ButtonBox["RowAlignments",
    ButtonData:>"Row Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"RowAlignments"],

Cell[TextData[{
  ButtonBox["RowSpacings",
    ButtonData:>"Row Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"RowSpacings"],

Cell[TextData[{
  ButtonBox["RowsEqual",
    ButtonData:>"Row Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"RowsEqual"],

Cell[TextData[{
  ButtonBox["RowsMinHeight",
    ButtonData:>"Row Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"RowsMinHeight"],

Cell[TextData[{
  ButtonBox["ColumnAlignments",
    ButtonData:>"Column Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"ColumnAlignments"],

Cell[TextData[{
  ButtonBox["ColumnSpacings",
    ButtonData:>"Column Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"ColumnSpacings"],

Cell[TextData[{
  ButtonBox["ColumnsEqual",
    ButtonData:>"Column Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"ColumnsEqual"],

Cell[TextData[{
  ButtonBox["ColumnWidths",
    ButtonData:>"Column Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"ColumnWidths"],

Cell[TextData[{
  ButtonBox["RowLines",
    ButtonData:>"Line Drawing Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"RowLines"],

Cell[TextData[{
  ButtonBox["ColumnLines",
    ButtonData:>"Line Drawing Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"ColumnLines"],

Cell[TextData[{
  ButtonBox["GridFrame",
    ButtonData:>"Line Drawing Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"GridFrame"],

Cell[TextData[{
  ButtonBox["GridFrameMargins",
    ButtonData:>"Line Drawing Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Table/Matrix/Palette Formatting)"
}], "Index",
  CellTags->"GridFrameMargins"],

Cell[TextData[{
  ButtonBox["CounterIncrements",
    ButtonData:>"Counter Assignment and Incrementing",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Automatic Numbering Options)"
}], "Index",
  CellTags->"CounterIncrements"],

Cell[TextData[{
  ButtonBox["CounterAssignments",
    ButtonData:>"Counter Assignment and Incrementing",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Automatic Numbering Options)"
}], "Index",
  CellTags->"CounterAssignments"],

Cell[TextData[{
  ButtonBox["InlineCounterIncrements",
    ButtonData:>"Counter Assignment and Incrementing",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Automatic Numbering Options)"
}], "Index",
  CellTags->"InlineCounterIncrements"],

Cell[TextData[{
  ButtonBox["InlineCounterAssignments",
    ButtonData:>"Counter Assignment and Incrementing",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Automatic Numbering Options)"
}], "Index",
  CellTags->"InlineCounterAssignments "],

Cell[TextData[{
  ButtonBox["CounterStyle",
    ButtonData:>"Counter Display Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Automatic Numbering Options)"
}], "Index",
  CellTags->"CounterStyle"],

Cell[TextData[{
  ButtonBox["CounterFunction",
    ButtonData:>"Counter Display Options",
    ButtonStyle->"OtherInformationLinkMR"],
  " (Automatic Numbering Options)"
}], "Index",
  CellTags->"CounterFunction"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1152}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->{},
WindowSize->{528, 554},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
Visible->True,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MasterIndexHeading"->{
    Cell[1754, 51, 67, 1, 41, "IndexSection",
      CellTags->"MasterIndexHeading"]},
  "New (menu command)"->{
    Cell[1974, 63, 144, 5, 70, "Index",
      CellTags->"New (menu command)"]},
  "Open (menu command)"->{
    Cell[2121, 70, 148, 5, 70, "Index",
      CellTags->"Open (menu command)"]},
  "Close (menu command)"->{
    Cell[2272, 77, 148, 5, 70, "Index",
      CellTags->"Close (menu command)"]},
  "Save (menu command)"->{
    Cell[2423, 84, 146, 5, 70, "Index",
      CellTags->"Save (menu command)"]},
  "Save As (menu command)"->{
    Cell[2572, 91, 155, 5, 70, "Index",
      CellTags->"Save As (menu command)"]},
  "Save As Special (menu command)"->{
    Cell[2730, 98, 171, 5, 70, "Index",
      CellTags->"Save As Special (menu command)"]},
  "Version 2 Notebook, Save As"->{
    Cell[2904, 105, 231, 6, 70, "IndexSubentry",
      CellTags->"Version 2 Notebook, Save As"]},
  "Text, Save As"->{
    Cell[3138, 113, 189, 6, 70, "IndexSubentry",
      CellTags->"Text, Save As"]},
  "Cell Expression, Save As"->{
    Cell[3330, 121, 222, 6, 70, "IndexSubentry",
      CellTags->"Cell Expression, Save As"]},
  "Notebook Expression, Save As"->{
    Cell[3555, 129, 234, 6, 70, "IndexSubentry",
      CellTags->"Notebook Expression, Save As"]},
  "Package Format, Save As"->{
    Cell[3792, 137, 219, 6, 70, "IndexSubentry",
      CellTags->"Package Format, Save As"]},
  "TeX, Save As"->{
    Cell[4014, 145, 186, 6, 70, "IndexSubentry",
      CellTags->"TeX, Save As"]},
  "HTML, Save As"->{
    Cell[4203, 153, 189, 6, 70, "IndexSubentry",
      CellTags->"HTML, Save As"]},
  "XML (XHTMLMathML), Save As"->{
    Cell[4395, 161, 224, 6, 70, "IndexSubentry",
      CellTags->"XML (XHTMLMathML), Save As"]},
  "XML (NotebookML), Save As"->{
    Cell[4622, 169, 219, 6, 70, "IndexSubentry",
      CellTags->"XML (NotebookML), Save As"]},
  "XML (NotebookML+MathML), Save As"->{
    Cell[4844, 177, 240, 6, 70, "IndexSubentry",
      CellTags->"XML (NotebookML+MathML), Save As"]},
  "Open Special (menu command)"->{
    Cell[5087, 185, 165, 5, 70, "Index",
      CellTags->"Open Special (menu command)"]},
  "Import (menu command)"->{
    Cell[5255, 192, 179, 6, 70, "Index",
      CellTags->"Import (menu command)"]},
  "Send To (menu command)"->{
    Cell[5437, 200, 154, 5, 70, "Index",
      CellTags->"Send To (menu command)"]},
  "Send Selection (menu command)"->{
    Cell[5594, 207, 168, 5, 70, "Index",
      CellTags->"Send Selection (menu command)"]},
  "Palettes (menu command)"->{
    Cell[5765, 214, 154, 5, 70, "Index",
      CellTags->"Palettes (menu command)"]},
  "Notebooks (menu command)"->{
    Cell[5922, 221, 156, 5, 70, "Index",
      CellTags->"Notebooks (menu command)"]},
  "Generate Palette from Selection (menu command)"->{
    Cell[6081, 228, 200, 5, 70, "Index",
      CellTags->"Generate Palette from Selection (menu command)"]},
  "Generate Notebook from Palette (menu command)"->{
    Cell[6284, 235, 198, 5, 70, "Index",
      CellTags->"Generate Notebook from Palette (menu command)"]},
  "menucommands"->{
    Cell[6485, 242, 138, 5, 70, "Index",
      CellTags->"menucommands"],
    Cell[17496, 661, 198, 6, 70, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[25207, 958, 208, 6, 70, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[25418, 966, 216, 6, 70, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[25637, 974, 218, 6, 70, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[25858, 982, 220, 6, 70, "IndexSubentry",
      CellTags->"menucommands"]},
  "Page Setup (menu command)"->{
    Cell[6626, 249, 218, 6, 70, "IndexSubentry",
      CellTags->"Page Setup (menu command)"]},
  "Printing Options (menu command)"->{
    Cell[6847, 257, 236, 6, 70, "IndexSubentry",
      CellTags->"Printing Options (menu command)"]},
  "Headers and Footers (menu command)"->{
    Cell[7086, 265, 245, 6, 70, "IndexSubentry",
      CellTags->"Headers and Footers (menu command)"]},
  "Print (menu command)"->{
    Cell[7334, 273, 151, 5, 70, "Index",
      CellTags->"Print (menu command)"]},
  "Print Selection (menu command)"->{
    Cell[7488, 280, 168, 5, 70, "Index",
      CellTags->"Print Selection (menu command)"]},
  "Exit (menu command)"->{
    Cell[7659, 287, 146, 5, 70, "Index",
      CellTags->"Exit (menu command)"]},
  "Quit (menu command)"->{
    Cell[7808, 294, 170, 6, 70, "Index",
      CellTags->"Quit (menu command)"]},
  "Undo (menu command)"->{
    Cell[8079, 308, 146, 5, 70, "Index",
      CellTags->"Undo (menu command)"]},
  "Cut (menu command)"->{
    Cell[8228, 315, 144, 5, 70, "Index",
      CellTags->"Cut (menu command)"]},
  "Copy (menu command)"->{
    Cell[8375, 322, 146, 5, 70, "Index",
      CellTags->"Copy (menu command)"]},
  "Paste (menu command)"->{
    Cell[8524, 329, 148, 5, 70, "Index",
      CellTags->"Paste (menu command)"]},
  "Clear (menu command)"->{
    Cell[8675, 336, 148, 5, 70, "Index",
      CellTags->"Clear (menu command)"]},
  "Copy As (menu command)"->{
    Cell[8826, 343, 152, 5, 70, "Index",
      CellTags->"Copy As (menu command)"]},
  "Paste As (menu command)"->{
    Cell[8981, 350, 154, 5, 70, "Index",
      CellTags->"Paste As (menu command)"]},
  "External Clipboard (menu command)"->{
    Cell[9138, 357, 174, 5, 70, "Index",
      CellTags->"External Clipboard (menu command)"]},
  "Save Selection As (menu command)"->{
    Cell[9315, 364, 171, 5, 70, "Index",
      CellTags->"Save Selection As (menu command)"]},
  "Select All (menu command)"->{
    Cell[9489, 371, 158, 5, 70, "Index",
      CellTags->"Select All (menu command)"]},
  "Insert Object (menu command)"->{
    Cell[9650, 378, 164, 5, 70, "Index",
      CellTags->"Insert Object (menu command)"]},
  "Motion (menu command)"->{
    Cell[9817, 385, 150, 5, 70, "Index",
      CellTags->"Motion (menu command)"]},
  "Expression Input (menu command)"->{
    Cell[9970, 392, 170, 5, 70, "Index",
      CellTags->"Expression Input (menu command)"]},
  "Insert Raw Expression (menu command)"->{
    Cell[10143, 399, 191, 5, 70, "IndexSubentry",
      CellTags->"Insert Raw Expression (menu command)"]},
  "Add Frame (menu command)"->{
    Cell[10337, 406, 134, 2, 70, "IndexSubentry",
      CellTags->"Add Frame (menu command)"]},
  "Add Interpretation (menu command)"->{
    Cell[10474, 410, 155, 2, 70, "IndexSubentry",
      CellTags->"Add Interpretation (menu command)"]},
  "Make 2D (menu command)"->{
    Cell[10632, 414, 152, 5, 70, "Index",
      CellTags->"Make 2D (menu command)"]},
  "Check Balance (menu command)"->{
    Cell[10787, 421, 164, 5, 70, "Index",
      CellTags->"Check Balance (menu command)"]},
  "Check Spelling (menu command)"->{
    Cell[10954, 428, 209, 6, 70, "Index",
      CellTags->"Check Spelling (menu command)"]},
  "Preferences (menu command)"->{
    Cell[11166, 436, 197, 6, 70, "Index",
      CellTags->"Preferences (menu command)"]},
  "Convert To (menu command)"->{
    Cell[11464, 450, 158, 5, 70, "Index",
      CellTags->"Convert To (menu command)"]},
  "InputForm, Convert To"->{
    Cell[11625, 457, 214, 6, 70, "IndexSubentry",
      CellTags->"InputForm, Convert To"]},
  "OutputForm, Convert To"->{
    Cell[11842, 465, 318, 9, 70, "IndexSubentry",
      CellTags->"OutputForm, Convert To"]},
  "StandardForm, Convert To"->{
    Cell[12163, 476, 322, 9, 70, "IndexSubentry",
      CellTags->"StandardForm, Convert To"]},
  "TraditionalForm, Convert To"->{
    Cell[12488, 487, 433, 12, 70, "IndexSubentry",
      CellTags->"TraditionalForm, Convert To"]},
  "PostScript, Convert To"->{
    Cell[12924, 501, 418, 12, 70, "IndexSubentry",
      CellTags->"PostScript, Convert To"]},
  "Bitmap, Convert To"->{
    Cell[13345, 515, 406, 12, 70, "IndexSubentry",
      CellTags->"Bitmap, Convert To"]},
  "PICT, ConvertTo"->{
    Cell[13754, 529, 399, 12, 70, "IndexSubentry",
      CellTags->"PICT, ConvertTo"]},
  "BitmapPICT, Convert To"->{
    Cell[14156, 543, 418, 12, 70, "IndexSubentry",
      CellTags->"BitmapPICT, Convert To"]},
  "Embedded PS PICT, ConvertTo"->{
    Cell[14577, 557, 234, 6, 70, "IndexSubentry",
      CellTags->"Embedded PS PICT, ConvertTo"]},
  "Metafile, Convert To"->{
    Cell[14814, 565, 412, 12, 70, "IndexSubentry",
      CellTags->"Metafile, Convert To"]},
  "QuickTime, Convert To"->{
    Cell[15229, 579, 415, 12, 70, "IndexSubentry",
      CellTags->"QuickTime, Convert To"]},
  "Display As (menu command)"->{
    Cell[15647, 593, 158, 5, 70, "Index",
      CellTags->"Display As (menu command)"]},
  "Text, Display As"->{
    Cell[15808, 600, 198, 6, 70, "IndexSubentry",
      CellTags->"Text, Display As"]},
  "InputForm, Display As"->{
    Cell[16009, 608, 214, 6, 70, "IndexSubentry",
      CellTags->"InputForm, Display As"]},
  "StandardForm, Display As"->{
    Cell[16226, 616, 223, 6, 70, "IndexSubentry",
      CellTags->"StandardForm, Display As"]},
  "Traditional Form, Display As"->{
    Cell[16452, 624, 233, 6, 70, "IndexSubentry",
      CellTags->"Traditional Form, Display As"]},
  "Default Input Format Type (menu command)"->{
    Cell[16688, 632, 188, 5, 70, "Index",
      CellTags->"Default Input Format Type (menu command)"]},
  "Default Output Format Type (menu command)"->{
    Cell[16879, 639, 190, 5, 70, "Index",
      CellTags->"Default Output Format Type (menu command)"]},
  "Default Inline Format Type (menu command)"->{
    Cell[17072, 646, 250, 6, 70, "Index",
      CellTags->"Default Inline Format Type (menu command)"]},
  "Cell Properties (menu command)"->{
    Cell[17325, 654, 168, 5, 70, "Index",
      CellTags->"Cell Properties (menu command)"]},
  "Cell Editable (menu command)"->{
    Cell[17697, 669, 222, 6, 70, "IndexSubentry",
      CellTags->"Cell Editable (menu command)"]},
  "Cell Edit Duplicate (menu command)"->{
    Cell[17922, 677, 240, 6, 70, "IndexSubentry",
      CellTags->"Cell Edit Duplicate (menu command)"]},
  "Cell Evaluatable (menu commands)"->{
    Cell[18165, 685, 232, 6, 70, "IndexSubentry",
      CellTags->"Cell Evaluatable (menu commands)"]},
  "Cell Active (menu command)"->{
    Cell[18400, 693, 216, 6, 70, "IndexSubentry",
      CellTags->"Cell Active (menu command)"]},
  "Initialization Cell (menu command)"->{
    Cell[18619, 701, 240, 6, 70, "IndexSubentry",
      CellTags->"Initialization Cell (menu command)"]},
  "Cell Grouping (menu command)"->{
    Cell[18862, 709, 210, 6, 70, "Index",
      CellTags->"Cell Grouping (menu command)"]},
  "Group Cells (menu command)"->{
    Cell[19075, 717, 214, 6, 70, "IndexSubentry",
      CellTags->"Group Cells (menu command)"]},
  "Ungroup Cells (menu command)"->{
    Cell[19292, 725, 220, 6, 70, "IndexSubentry",
      CellTags->"Ungroup Cells (menu command)"]},
  "Manual Grouping (menu command)"->{
    Cell[19515, 733, 226, 6, 70, "IndexSubentry",
      CellTags->"Manual Grouping (menu command)"]},
  "Automatic Grouping (menu command)"->{
    Cell[19744, 741, 235, 6, 70, "IndexSubentry",
      CellTags->"Automatic Grouping (menu command)"]},
  "Open All Subgroups (menu command)"->{
    Cell[19982, 749, 235, 6, 70, "IndexSubentry",
      CellTags->"Open All Subgroups (menu command)"]},
  "Close All Subgroups (menu command)"->{
    Cell[20220, 757, 238, 6, 70, "IndexSubentry",
      CellTags->"Close All Subgroups (menu command)"]},
  "Open/Close Group (menu command)"->{
    Cell[20461, 765, 229, 6, 70, "IndexSubentry",
      CellTags->"Open/Close Group (menu command)"]},
  "Divide Cell (menu command)"->{
    Cell[20693, 773, 160, 5, 70, "Index",
      CellTags->"Divide Cell (menu command)"]},
  "Merge Cells (menu command)"->{
    Cell[20856, 780, 160, 5, 70, "Index",
      CellTags->"Merge Cells (menu command)"]},
  "Animate Selected Graphics (menu command)"->{
    Cell[21019, 787, 188, 5, 70, "Index",
      CellTags->"Animate Selected Graphics (menu command)"]},
  "Play Sound (menu command)"->{
    Cell[21210, 794, 158, 5, 70, "Index",
      CellTags->"Play Sound (menu command)"]},
  "Rerender Graphics (menu command)"->{
    Cell[21371, 801, 172, 5, 70, "Index",
      CellTags->"Rerender Graphics (menu command)"]},
  "Rerender and Save Graphics (menu command)"->{
    Cell[21546, 808, 190, 5, 70, "Index",
      CellTags->"Rerender and Save Graphics (menu command)"]},
  "Make Standard Size (menu command)"->{
    Cell[21739, 815, 174, 5, 70, "Index",
      CellTags->"Make Standard Size (menu command)"]},
  "Align Selected Graphics (menu command)"->{
    Cell[21916, 822, 187, 5, 70, "Index",
      CellTags->"Align Selected Graphics (menu command)"]},
  "Cell Size Statistics (menu command)"->{
    Cell[22106, 829, 181, 5, 70, "Index",
      CellTags->"Cell Size Statistics (menu command)"]},
  "Style (menu command)"->{
    Cell[22390, 842, 118, 2, 70, "Index",
      CellTags->"Style (menu command)"]},
  "Screen Style Environment (menu command)"->{
    Cell[22511, 846, 186, 5, 70, "Index",
      CellTags->"Screen Style Environment (menu command)"]},
  "Printing Style Environment (menu command)"->{
    Cell[22700, 853, 190, 5, 70, "Index",
      CellTags->"Printing Style Environment (menu command)"]},
  "Show Expression (menu command)"->{
    Cell[22893, 860, 168, 5, 70, "Index",
      CellTags->"Show Expression (menu command)"]},
  "Option Inspector (menu command)"->{
    Cell[23064, 867, 173, 5, 70, "Index",
      CellTags->"Option Inspector (menu command)"]},
  "Remove Options (menu command)"->{
    Cell[23240, 874, 169, 5, 70, "Index",
      CellTags->"Remove Options (menu command)"]},
  "Style Sheet (menu command)"->{
    Cell[23412, 881, 160, 5, 70, "Index",
      CellTags->"Style Sheet (menu command)"]},
  "Edit Style Sheet (menu command)"->{
    Cell[23575, 888, 170, 5, 70, "Index",
      CellTags->"Edit Style Sheet (menu command)"]},
  "Font (menu command)"->{
    Cell[23748, 895, 146, 5, 70, "Index",
      CellTags->"Font (menu command)"]},
  "Face (menu command)"->{
    Cell[23897, 902, 146, 5, 70, "Index",
      CellTags->"Face (menu command)"]},
  "Size (menu command)"->{
    Cell[24046, 909, 146, 5, 70, "Index",
      CellTags->"Size (menu command)"]},
  "Text Color (menu command)"->{
    Cell[24195, 916, 158, 5, 70, "Index",
      CellTags->"Text Color (menu command)"]},
  "Background Color (menu command)"->{
    Cell[24356, 923, 170, 5, 70, "Index",
      CellTags->"Background Color (menu command)"]},
  "Choose Font (menu command)"->{
    Cell[24529, 930, 162, 5, 70, "Index",
      CellTags->"Choose Font (menu command)"]},
  "Text Alignment (menu command)"->{
    Cell[24694, 937, 166, 5, 70, "Index",
      CellTags->"Text Alignment (menu command)"]},
  "Text Justification (menu command)"->{
    Cell[24863, 944, 174, 5, 70, "Index",
      CellTags->"Text Justification (menu command)"]},
  "Word Wrapping (menu command)"->{
    Cell[25040, 951, 164, 5, 70, "Index",
      CellTags->"Word Wrapping (menu command)"]},
  "Cell Dingbat (menu command)"->{
    Cell[26081, 990, 162, 5, 70, "Index",
      CellTags->"Cell Dingbat (menu command)"]},
  "Horizontal Lines (menu command)"->{
    Cell[26246, 997, 140, 2, 70, "Index",
      CellTags->"Horizontal Lines (menu command)"]},
  "Show Ruler (menu command)"->{
    Cell[26389, 1001, 158, 5, 70, "Index",
      CellTags->"Show Ruler (menu command)"]},
  "Show Toolbar (menu command)"->{
    Cell[26550, 1008, 162, 5, 70, "Index",
      CellTags->"Show Toolbar (menu command)"]},
  "Show Page Breaks (menu command)"->{
    Cell[26715, 1015, 206, 6, 70, "Index",
      CellTags->"Show Page Breaks (menu command)"]},
  "Magnification (menu command)"->{
    Cell[26924, 1023, 164, 5, 70, "Index",
      CellTags->"Magnification (menu command)"]},
  "Get Graphics Coordinates (menu command)"->{
    Cell[27190, 1036, 189, 5, 70, "Index",
      CellTags->"Get Graphics Coordinates (menu command)"]},
  "3D ViewPoint Selector (menu command)"->{
    Cell[27382, 1043, 183, 5, 70, "Index",
      CellTags->"3D ViewPoint Selector (menu command)"]},
  "Color Selector (menu command)"->{
    Cell[27568, 1050, 169, 5, 70, "Index",
      CellTags->"Color Selector (menu command)"]},
  "Record Sound (menu command)"->{
    Cell[27740, 1057, 165, 5, 70, "Index",
      CellTags->"Record Sound (menu command)"]},
  "Get File Path (menu command)"->{
    Cell[27908, 1064, 167, 5, 70, "Index",
      CellTags->"Get File Path (menu command)"]},
  "Create Table/Matrix/Palette (menu command)"->{
    Cell[28078, 1071, 195, 5, 70, "Index",
      CellTags->"Create Table/Matrix/Palette (menu command)"]},
  "Create Button (menu command)"->{
    Cell[28276, 1078, 164, 5, 70, "Index",
      CellTags->"Create Button (menu command)"]},
  "Edit Button (menu command)"->{
    Cell[28443, 1085, 163, 5, 70, "Index",
      CellTags->"Edit Button (menu command)"]},
  "Create Hyperlink (menu command)"->{
    Cell[28609, 1092, 173, 5, 70, "Index",
      CellTags->"Create Hyperlink (menu command)"]},
  "Create Automatic Numbering Object (menu command)"->{
    Cell[28785, 1099, 207, 5, 70, "Index",
      CellTags->"Create Automatic Numbering Object (menu command)"]},
  "Create Value Display Object (menu command)"->{
    Cell[28995, 1106, 195, 5, 70, "Index",
      CellTags->"Create Value Display Object (menu command)"]},
  "Convert Automatic Objects to Literal (menu command)"->{
    Cell[29193, 1113, 180, 2, 70, "Index",
      CellTags->"Convert Automatic Objects to Literal (menu command)"]},
  "Copy Input from Above (menu command)"->{
    Cell[29376, 1117, 180, 5, 70, "Index",
      CellTags->"Copy Input from Above (menu command)"]},
  "Copy Output from Above (menu command)"->{
    Cell[29559, 1124, 182, 5, 70, "Index",
      CellTags->"Copy Output from Above (menu command)"]},
  "Start New Cell Below (menu command)"->{
    Cell[29744, 1131, 178, 5, 70, "Index",
      CellTags->"Start New Cell Below (menu command)"]},
  "Complete Selection (menu command)"->{
    Cell[29925, 1138, 174, 5, 70, "Index",
      CellTags->"Complete Selection (menu command)"]},
  "Make Template (menu command)"->{
    Cell[30102, 1145, 164, 5, 70, "Index",
      CellTags->"Make Template (menu command)"]},
  "Evaluation (menu command)"->{
    Cell[30369, 1158, 121, 4, 70, "Index",
      CellTags->"Evaluation (menu command)"]},
  "Evaluate Cells (menu command)"->{
    Cell[30493, 1164, 220, 6, 70, "IndexSubentry",
      CellTags->"Evaluate Cells (menu command)"]},
  "Evaluate in Place (menu command)"->{
    Cell[30716, 1172, 229, 6, 70, "IndexSubentry",
      CellTags->"Evaluate in Place (menu command)"]},
  "Evaluate Next Input (menu command)"->{
    Cell[30948, 1180, 235, 6, 70, "IndexSubentry",
      CellTags->"Evaluate Next Input (menu command)"]},
  "Evaluate In Subsession (menu command)"->{
    Cell[31186, 1188, 244, 6, 70, "IndexSubentry",
      CellTags->"Evaluate In Subsession (menu command)"]},
  "Evaluate Notebook (menu command)"->{
    Cell[31433, 1196, 229, 6, 70, "IndexSubentry",
      CellTags->"Evaluate Notebook (menu command)"]},
  "Evaluate Initialization (menu command)"->{
    Cell[31665, 1204, 247, 6, 70, "IndexSubentry",
      CellTags->"Evaluate Initialization (menu command)"]},
  "Enter Subsession (menu command)"->{
    Cell[31915, 1212, 226, 6, 70, "IndexSubentry",
      CellTags->"Enter Subsession (menu command)"]},
  "Exit Subsession (menu command)"->{
    Cell[32144, 1220, 223, 6, 70, "IndexSubentry",
      CellTags->"Exit Subsession (menu command)"]},
  "Remove from Evaluation Queue (menu command)"->{
    Cell[32370, 1228, 262, 6, 70, "IndexSubentry",
      CellTags->"Remove from Evaluation Queue (menu command)"]},
  "Interrupt Evaluation (menu command)"->{
    Cell[32635, 1236, 181, 5, 70, "Index",
      CellTags->"Interrupt Evaluation (menu command)"]},
  "Abort Evaluation (menu command)"->{
    Cell[32819, 1243, 170, 5, 70, "Index",
      CellTags->"Abort Evaluation (menu command)"]},
  "Start Kernel (menu command)"->{
    Cell[32992, 1250, 162, 5, 70, "Index",
      CellTags->"Start Kernel (menu command)"]},
  "Quit Kernel (menu command)"->{
    Cell[33157, 1257, 160, 5, 70, "Index",
      CellTags->"Quit Kernel (menu command)"]},
  "Default Kernel (menu command)"->{
    Cell[33320, 1264, 166, 5, 70, "Index",
      CellTags->"Default Kernel (menu command)"]},
  "Notebook's Kernel (menu command)"->{
    Cell[33489, 1271, 172, 5, 70, "Index",
      CellTags->"Notebook's Kernel (menu command)"]},
  "Kernel Configuration Options (menu command)"->{
    Cell[33664, 1278, 197, 5, 70, "Index",
      CellTags->"Kernel Configuration Options (menu command)"]},
  "Show In/Out Names (menu command)"->{
    Cell[33864, 1285, 172, 5, 70, "Index",
      CellTags->"Show In/Out Names (menu command)"]},
  "Delete All Output (menu command)"->{
    Cell[34039, 1292, 172, 5, 70, "Index",
      CellTags->"Delete All Output (menu command)"]},
  "Find (menu command)"->{
    Cell[34312, 1305, 149, 5, 70, "Index",
      CellTags->"Find (menu command)"]},
  "Enter Selection (menu command)"->{
    Cell[34464, 1312, 168, 5, 70, "Index",
      CellTags->"Enter Selection (menu command)"]},
  "Find Next (menu command)"->{
    Cell[34635, 1319, 156, 5, 70, "Index",
      CellTags->"Find Next (menu command)"]},
  "Find Previous (menu command)"->{
    Cell[34794, 1326, 164, 5, 70, "Index",
      CellTags->"Find Previous (menu command)"]},
  "Find in Cell Tags (menu command)"->{
    Cell[34961, 1333, 172, 5, 70, "Index",
      CellTags->"Find in Cell Tags (menu command)"]},
  "Replace and Find Again (menu command)"->{
    Cell[35136, 1340, 167, 5, 70, "Index",
      CellTags->"Replace and Find Again (menu command)"],
    Cell[35306, 1347, 182, 5, 70, "Index",
      CellTags->"Replace and Find Again (menu command)"]},
  "Replace All (menu command)"->{
    Cell[35491, 1354, 160, 5, 70, "Index",
      CellTags->"Replace All (menu command)"]},
  "Open Selected (menu command)"->{
    Cell[35654, 1361, 164, 5, 70, "Index",
      CellTags->"Open Selected (menu command)"]},
  "Scroll to Selection (menu command)"->{
    Cell[35821, 1368, 176, 5, 70, "Index",
      CellTags->"Scroll to Selection (menu command)"]},
  "Go Back (menu command)"->{
    Cell[36000, 1375, 152, 5, 70, "Index",
      CellTags->"Go Back (menu command)"]},
  "Add/Remove Cell Tags (menu command)"->{
    Cell[36155, 1382, 181, 5, 70, "Index",
      CellTags->"Add/Remove Cell Tags (menu command)"]},
  "Cell Tags (menu command)"->{
    Cell[36339, 1389, 156, 5, 70, "Index",
      CellTags->"Cell Tags (menu command)"]},
  "Show Cell Tags (menu command)"->{
    Cell[36498, 1396, 166, 5, 70, "Index",
      CellTags->"Show Cell Tags (menu command)"]},
  "Cell Tags from In/Out Names (menu command)"->{
    Cell[36667, 1403, 192, 5, 70, "Index",
      CellTags->"Cell Tags from In/Out Names (menu command)"]},
  "Make Index... (menu command)"->{
    Cell[36862, 1410, 164, 5, 70, "Index",
      CellTags->"Make Index... (menu command)"]},
  "Stack Windows (menu command)"->{
    Cell[37129, 1423, 164, 5, 70, "Index",
      CellTags->"Stack Windows (menu command)"]},
  "Tile Windows Wide (menu command)"->{
    Cell[37296, 1430, 172, 5, 70, "Index",
      CellTags->"Tile Windows Wide (menu command)"]},
  "Tile Windows Tall (menu command)"->{
    Cell[37471, 1437, 172, 5, 70, "Index",
      CellTags->"Tile Windows Tall (menu command)"]},
  "Help Browser (menu command)"->{
    Cell[37744, 1450, 165, 5, 70, "Index",
      CellTags->"Help Browser (menu command)"]},
  "Find Selected Function (menu command)"->{
    Cell[37912, 1457, 185, 5, 70, "Index",
      CellTags->"Find Selected Function (menu command)"]},
  "Master Index (menu command)"->{
    Cell[38100, 1464, 165, 5, 70, "Index",
      CellTags->"Master Index (menu command)"]},
  "InformationCenter (menu command)"->{
    Cell[38268, 1471, 166, 5, 70, "Index",
      CellTags->"InformationCenter (menu command)"]},
  "Information Center on the Web (menu command)"->{
    Cell[38437, 1478, 199, 5, 70, "Index",
      CellTags->"Information Center on the Web (menu command)"]},
  "Wolfram Research on the Web (menu command)"->{
    Cell[38639, 1485, 195, 5, 70, "Index",
      CellTags->"Wolfram Research on the Web (menu command)"]},
  "Registration (menu command)"->{
    Cell[38837, 1492, 172, 5, 70, "Index",
      CellTags->"Registration (menu command)"]},
  "Why the Beep (menu command)"->{
    Cell[39012, 1499, 166, 5, 70, "Index",
      CellTags->"Why the Beep (menu command)"]},
  "Startup Palette (menu command)"->{
    Cell[39181, 1506, 171, 5, 70, "Index",
      CellTags->"Startup Palette (menu command)"]},
  "About Mathematica (menu command)"->{
    Cell[39355, 1513, 175, 5, 70, "Index",
      CellTags->"About Mathematica (menu command)"]},
  "X Environment Information (menu command)"->{
    Cell[39533, 1520, 191, 5, 70, "Index",
      CellTags->"X Environment Information (menu command)"]},
  "Rebuild Help Index (menu command)"->{
    Cell[39727, 1527, 174, 5, 70, "Index",
      CellTags->"Rebuild Help Index (menu command)"]},
  "Keyboard shortcuts"->{
    Cell[39998, 1540, 447, 15, 70, "Index",
      CellTags->"Keyboard shortcuts"]},
  "Style sheets"->{
    Cell[40523, 1562, 2014, 53, 70, "Index",
      CellTags->"Style sheets"],
    Cell[42579, 1619, 596, 14, 70, "Index",
      CellTags->{"Style sheets", "Environments"}],
    Cell[43228, 1637, 820, 21, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}],
    Cell[44051, 1660, 709, 19, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}]},
  "Environments"->{
    Cell[42579, 1619, 596, 14, 70, "Index",
      CellTags->{"Style sheets", "Environments"}],
    Cell[43228, 1637, 820, 21, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}],
    Cell[44051, 1660, 709, 19, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}]},
  "Tutorial"->{
    Cell[43228, 1637, 820, 21, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}],
    Cell[44051, 1660, 709, 19, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}]},
  "Slide Show"->{
    Cell[43228, 1637, 820, 21, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}],
    Cell[44051, 1660, 709, 19, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}]},
  "10 Minute Tutorial on Mathematica"->{
    Cell[43228, 1637, 820, 21, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}],
    Cell[44051, 1660, 709, 19, 70, "Index",
      CellTags->{
      "Style sheets", "Environments", "Tutorial", "Slide Show", 
        "10 Minute Tutorial on Mathematica"}]},
  "NotebookDirectory"->{
    Cell[44843, 1686, 129, 2, 15, "Index",
      CellTags->"NotebookDirectory"]},
  "NotebookPath"->{
    Cell[44975, 1690, 119, 2, 15, "Index",
      CellTags->"NotebookPath"]},
  "PalettePath"->{
    Cell[45097, 1694, 117, 2, 15, "Index",
      CellTags->"PalettePath"]},
  "AutoOpenPalettes"->{
    Cell[45217, 1698, 127, 2, 15, "Index",
      CellTags->"AutoOpenPalettes"]},
  "AutoOpenNotebooks"->{
    Cell[45347, 1702, 129, 2, 15, "Index",
      CellTags->"AutoOpenNotebooks"]},
  "StyleSheetPath"->{
    Cell[45479, 1706, 123, 2, 15, "Index",
      CellTags->"StyleSheetPath"]},
  "DefaultNotebook"->{
    Cell[45605, 1710, 125, 2, 15, "Index",
      CellTags->"DefaultNotebook"]},
  "DefaultStyleDefinitions"->{
    Cell[45733, 1714, 141, 2, 15, "Index",
      CellTags->"DefaultStyleDefinitions"]},
  "PreferencesPath"->{
    Cell[45877, 1718, 125, 2, 15, "Index",
      CellTags->"PreferencesPath"]},
  "ConfigurationPath"->{
    Cell[46005, 1722, 129, 2, 15, "Index",
      CellTags->"ConfigurationPath"]},
  "SystemHelpPath"->{
    Cell[46137, 1726, 123, 2, 15, "Index",
      CellTags->"SystemHelpPath"]},
  "AddOnHelpPath"->{
    Cell[46263, 1730, 121, 2, 15, "Index",
      CellTags->"AddOnHelpPath"]},
  "AutoloadPath"->{
    Cell[46387, 1734, 119, 2, 15, "Index",
      CellTags->"AutoloadPath"]},
  "SpellingDictionariesPath"->{
    Cell[46509, 1738, 143, 2, 15, "Index",
      CellTags->"SpellingDictionariesPath"]},
  "CharacterEncodingsPath"->{
    Cell[46655, 1742, 139, 2, 15, "Index",
      CellTags->"CharacterEncodingsPath"]},
  "ImportAutoReplacements"->{
    Cell[46797, 1746, 139, 2, 15, "Index",
      CellTags->"ImportAutoReplacements"]},
  "ExportAutoReplacements"->{
    Cell[46939, 1750, 139, 2, 15, "Index",
      CellTags->"ExportAutoReplacements"]},
  "Language"->{
    Cell[47081, 1754, 111, 2, 15, "Index",
      CellTags->"Language"]},
  "ExternalDataCharacterEncoding"->{
    Cell[47195, 1758, 153, 2, 15, "Index",
      CellTags->"ExternalDataCharacterEncoding"]},
  "StartupSound"->{
    Cell[47351, 1762, 119, 2, 15, "Index",
      CellTags->"StartupSound"]},
  "MultilaunchWarning"->{
    Cell[47473, 1766, 131, 2, 15, "Index",
      CellTags->"MultilaunchWarning"]},
  "ScreenRectangle"->{
    Cell[47607, 1770, 125, 2, 15, "Index",
      CellTags->"ScreenRectangle"]},
  "FrontEndStackSize"->{
    Cell[47735, 1774, 129, 2, 15, "Index",
      CellTags->"FrontEndStackSize"]},
  "XPasteFrom"->{
    Cell[47867, 1778, 115, 2, 15, "Index",
      CellTags->"XPasteFrom"]},
  "EvaluatorNames"->{
    Cell[47985, 1782, 123, 2, 15, "Index",
      CellTags->"EvaluatorNames"]},
  "NotebooksMenu"->{
    Cell[48111, 1786, 121, 2, 15, "Index",
      CellTags->"NotebooksMenu"]},
  "FontSubstitutions"->{
    Cell[48235, 1790, 129, 2, 15, "Index",
      CellTags->"FontSubstitutions"]},
  "DefaultFontProperties"->{
    Cell[48367, 1794, 137, 2, 15, "Index",
      CellTags->"DefaultFontProperties"]},
  "BoxFormFormatTypes"->{
    Cell[48507, 1798, 131, 2, 15, "Index",
      CellTags->"BoxFormFormatTypes"]},
  "WarningAction"->{
    Cell[48641, 1802, 121, 2, 15, "Index",
      CellTags->"WarningAction"]},
  "ErrorAction"->{
    Cell[48765, 1806, 117, 2, 15, "Index",
      CellTags->"ErrorAction"]},
  "ConsoleMessageAction"->{
    Cell[48885, 1810, 135, 2, 15, "Index",
      CellTags->"ConsoleMessageAction"]},
  "KernelMessageAction"->{
    Cell[49023, 1814, 133, 2, 15, "Index",
      CellTags->"KernelMessageAction"]},
  "ExplainBeepHelp"->{
    Cell[49159, 1818, 125, 2, 15, "Index",
      CellTags->"ExplainBeepHelp"]},
  "MathMLPasteWarning"->{
    Cell[49287, 1822, 131, 2, 15, "Index",
      CellTags->"MathMLPasteWarning"]},
  "InsufficientVersionWarning"->{
    Cell[49421, 1826, 147, 2, 15, "Index",
      CellTags->"InsufficientVersionWarning"]},
  "IgnoreTagBoxDeletionWarning"->{
    Cell[49571, 1830, 149, 2, 15, "Index",
      CellTags->"IgnoreTagBoxDeletionWarning"]},
  "TraditionalFormEvaluationWarning"->{
    Cell[49723, 1834, 159, 2, 15, "Index",
      CellTags->"TraditionalFormEvaluationWarning"]},
  "AllowDisablingWarnings"->{
    Cell[49885, 1838, 139, 2, 15, "Index",
      CellTags->"AllowDisablingWarnings"]},
  "NotebookAutoSave"->{
    Cell[50027, 1842, 127, 2, 15, "Index",
      CellTags->"NotebookAutoSave"]},
  "ClosingAutoSave"->{
    Cell[50157, 1846, 125, 2, 15, "Index",
      CellTags->"ClosingAutoSave"]},
  "IncludeFileExtension"->{
    Cell[50285, 1850, 135, 2, 15, "Index",
      CellTags->"IncludeFileExtension"]},
  "AutoGeneratedPackage"->{
    Cell[50423, 1854, 135, 2, 15, "Index",
      CellTags->"AutoGeneratedPackage"]},
  "Editable"->{
    Cell[50561, 1858, 111, 2, 15, "Index",
      CellTags->"Editable"]},
  "Saveable"->{
    Cell[50675, 1862, 111, 2, 15, "Index",
      CellTags->"Saveable"]},
  "ScreenStyleEnvironment"->{
    Cell[50789, 1866, 139, 2, 15, "Index",
      CellTags->"ScreenStyleEnvironment"]},
  "PrintingStyleEnvironment"->{
    Cell[50931, 1870, 143, 2, 15, "Index",
      CellTags->"PrintingStyleEnvironment"]},
  "ShowPageBreaks"->{
    Cell[51077, 1874, 123, 2, 15, "Index",
      CellTags->"ShowPageBreaks"]},
  "WindowToolbars"->{
    Cell[51203, 1878, 123, 2, 15, "Index",
      CellTags->"WindowToolbars"]},
  "RulerUnits"->{
    Cell[51329, 1882, 115, 2, 15, "Index",
      CellTags->"RulerUnits"]},
  "NotebookBackground"->{
    Cell[51447, 1886, 148, 5, 16, "Index",
      CellTags->"NotebookBackground"]},
  "Magnification"->{
    Cell[51598, 1893, 121, 2, 15, "Index",
      CellTags->"Magnification"],
    Cell[67365, 2389, 121, 2, 15, "Index",
      CellTags->"Magnification"],
    Cell[102921, 3649, 199, 6, 16, "Index",
      CellTags->"Magnification"]},
  "Evaluator"->{
    Cell[51722, 1897, 113, 2, 15, "Index",
      CellTags->"Evaluator"],
    Cell[61488, 2205, 113, 2, 15, "Index",
      CellTags->"Evaluator"]},
  "EvaluationCompletionAction"->{
    Cell[51838, 1901, 147, 2, 15, "Index",
      CellTags->"EvaluationCompletionAction"]},
  "PrintAction"->{
    Cell[51988, 1905, 117, 2, 15, "Index",
      CellTags->"PrintAction"]},
  "OutputAutoOverwrite"->{
    Cell[52108, 1909, 133, 2, 15, "Index",
      CellTags->"OutputAutoOverwrite"]},
  "InitializationCellEvaluation"->{
    Cell[52244, 1913, 151, 2, 15, "Index",
      CellTags->"InitializationCellEvaluation"]},
  "InitializationCellWarning"->{
    Cell[52398, 1917, 145, 2, 15, "Index",
      CellTags->"InitializationCellWarning"]},
  "Selectable"->{
    Cell[52546, 1921, 115, 2, 15, "Index",
      CellTags->"Selectable"],
    Cell[58892, 2125, 115, 2, 15, "Index",
      CellTags->"Selectable"],
    Cell[64072, 2285, 115, 2, 15, "Index",
      CellTags->"Selectable"],
    Cell[128605, 4642, 202, 6, 70, "Index",
      CellTags->"Selectable"],
    Cell[131903, 4762, 180, 6, 70, "Index",
      CellTags->"Selectable"]},
  "Deletable"->{
    Cell[52664, 1925, 113, 2, 15, "Index",
      CellTags->"Deletable"],
    Cell[59010, 2129, 113, 2, 15, "Index",
      CellTags->"Deletable"],
    Cell[64190, 2289, 113, 2, 15, "Index",
      CellTags->"Deletable"]},
  "CellGrouping"->{
    Cell[52780, 1929, 119, 2, 15, "Index",
      CellTags->"CellGrouping"]},
  "PageWidth"->{
    Cell[52902, 1933, 113, 2, 15, "Index",
      CellTags->"PageWidth"],
    Cell[79292, 2781, 206, 6, 16, "Index",
      CellTags->"PageWidth"],
    Cell[80750, 2833, 200, 6, 16, "Index",
      CellTags->"PageWidth"],
    Cell[82194, 2885, 208, 6, 16, "Index",
      CellTags->"PageWidth"],
    Cell[83650, 2937, 194, 6, 16, "Index",
      CellTags->"PageWidth"],
    Cell[85044, 2989, 198, 6, 16, "Index",
      CellTags->"PageWidth"],
    Cell[86450, 3041, 194, 6, 16, "Index",
      CellTags->"PageWidth"]},
  "WindowSize"->{
    Cell[53018, 1937, 115, 2, 15, "Index",
      CellTags->"WindowSize"],
    Cell[93951, 3325, 202, 6, 16, "Index",
      CellTags->"WindowSize"],
    Cell[96113, 3401, 194, 6, 16, "Index",
      CellTags->"WindowSize"]},
  "WindowMargins"->{
    Cell[53136, 1941, 121, 2, 15, "Index",
      CellTags->"WindowMargins"],
    Cell[88359, 3117, 186, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[88700, 3129, 197, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[88900, 3137, 202, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[89908, 3173, 212, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[93184, 3297, 214, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[94156, 3333, 208, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[94515, 3345, 198, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[94874, 3357, 208, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[95231, 3369, 196, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[95568, 3381, 188, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[95909, 3393, 201, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[96310, 3409, 200, 6, 16, "Index",
      CellTags->"WindowMargins"],
    Cell[96665, 3421, 202, 6, 16, "Index",
      CellTags->"WindowMargins"]},
  "WindowFrame"->{
    Cell[53260, 1945, 117, 2, 15, "Index",
      CellTags->"WindowFrame"]},
  "WindowElements"->{
    Cell[53380, 1949, 123, 2, 15, "Index",
      CellTags->"WindowElements"]},
  "WindowFrameElements"->{
    Cell[53506, 1953, 133, 2, 15, "Index",
      CellTags->"WindowFrameElements"]},
  "WindowClickSelect"->{
    Cell[53642, 1957, 129, 2, 15, "Index",
      CellTags->"WindowClickSelect"]},
  "WindowFloating"->{
    Cell[53774, 1961, 123, 2, 15, "Index",
      CellTags->"WindowFloating"]},
  "WindowMovable"->{
    Cell[53900, 1965, 121, 2, 15, "Index",
      CellTags->"WindowMovable"]},
  "WindowTitle"->{
    Cell[54024, 1969, 117, 2, 15, "Index",
      CellTags->"WindowTitle"]},
  "Visible"->{
    Cell[54144, 1973, 109, 2, 15, "Index",
      CellTags->"Visible"]},
  "PrintingCopies"->{
    Cell[54256, 1977, 123, 2, 15, "Index",
      CellTags->"PrintingCopies"]},
  "PrintingStartingPageNumber"->{
    Cell[54382, 1981, 147, 2, 15, "Index",
      CellTags->"PrintingStartingPageNumber"]},
  "PrintingPageRange"->{
    Cell[54532, 1985, 129, 2, 15, "Index",
      CellTags->"PrintingPageRange"]},
  "PageHeaders"->{
    Cell[54664, 1989, 117, 2, 15, "Index",
      CellTags->"PageHeaders"]},
  "PageFooters"->{
    Cell[54784, 1993, 117, 2, 15, "Index",
      CellTags->"PageFooters"]},
  "PageHeaderLines"->{
    Cell[54904, 1997, 125, 2, 15, "Index",
      CellTags->"PageHeaderLines"]},
  "PageFooterLines"->{
    Cell[55032, 2001, 125, 2, 15, "Index",
      CellTags->"PageFooterLines"]},
  "SafeFileSave"->{
    Cell[55160, 2005, 119, 2, 15, "Index",
      CellTags->"SafeFileSave"]},
  "SafeFileOpen"->{
    Cell[55282, 2009, 119, 2, 15, "Index",
      CellTags->"SafeFileOpen"]},
  "DoubleBuffer"->{
    Cell[55404, 2013, 119, 2, 15, "Index",
      CellTags->"DoubleBuffer"]},
  "ColorPalette"->{
    Cell[55526, 2017, 119, 2, 15, "Index",
      CellTags->"ColorPalette"]},
  "BackgroundPostScriptRendering"->{
    Cell[55648, 2021, 153, 2, 15, "Index",
      CellTags->"BackgroundPostScriptRendering"]},
  "RealTimeMarginAdjustment"->{
    Cell[55804, 2025, 143, 2, 15, "Index",
      CellTags->"RealTimeMarginAdjustment"]},
  "RealTimeWindowMove"->{
    Cell[55950, 2029, 131, 2, 15, "Index",
      CellTags->"RealTimeWindowMove"]},
  "RealTimeWindowResize"->{
    Cell[56084, 2033, 135, 2, 15, "Index",
      CellTags->"RealTimeWindowResize"]},
  "ShortBoxForm"->{
    Cell[56222, 2037, 119, 2, 15, "Index",
      CellTags->"ShortBoxForm"]},
  "Format"->{
    Cell[56344, 2041, 107, 2, 15, "Index",
      CellTags->"Format"]},
  "Ellipsis"->{
    Cell[56454, 2045, 111, 2, 15, "Index",
      CellTags->"Ellipsis"]},
  "MultiPageContinuation"->{
    Cell[56568, 2049, 137, 2, 15, "Index",
      CellTags->"MultiPageContinuation"]},
  "PageSeparator"->{
    Cell[56708, 2053, 121, 2, 15, "Index",
      CellTags->"PageSeparator"]},
  "SectionSeparator"->{
    Cell[56832, 2057, 127, 2, 15, "Index",
      CellTags->"SectionSeparator"]},
  "MainEntry"->{
    Cell[56962, 2061, 113, 2, 15, "Index",
      CellTags->"MainEntry"]},
  "MainPage"->{
    Cell[57078, 2065, 111, 2, 15, "Index",
      CellTags->"MainPage"]},
  "CellFrame"->{
    Cell[57192, 2069, 113, 2, 15, "Index",
      CellTags->"CellFrame"],
    Cell[62248, 2229, 113, 2, 15, "Index",
      CellTags->"CellFrame"]},
  "CellDingbat"->{
    Cell[57308, 2073, 117, 2, 15, "Index",
      CellTags->"CellDingbat"]},
  "CellBackground"->{
    Cell[57428, 2077, 191, 6, 16, "Index",
      CellTags->"CellBackground"]},
  "ShowCellBracket"->{
    Cell[57622, 2085, 125, 2, 15, "Index",
      CellTags->"ShowCellBracket"]},
  "ShowSelection"->{
    Cell[57750, 2089, 121, 2, 15, "Index",
      CellTags->"ShowSelection"]},
  "ShowGroupOpenCloseIcon"->{
    Cell[57874, 2093, 139, 2, 15, "Index",
      CellTags->"ShowGroupOpenCloseIcon"]},
  "ShowClosedCellArea"->{
    Cell[58016, 2097, 131, 2, 15, "Index",
      CellTags->"ShowClosedCellArea"]},
  "ShowShortBoxForm"->{
    Cell[58150, 2101, 127, 2, 15, "Index",
      CellTags->"ShowShortBoxForm"]},
  "CellDisplayCache"->{
    Cell[58280, 2105, 127, 2, 15, "Index",
      CellTags->"CellDisplayCache"]},
  "CellMargins"->{
    Cell[58410, 2109, 117, 2, 15, "Index",
      CellTags->"CellMargins"]},
  "Active"->{
    Cell[58530, 2113, 107, 2, 15, "Index",
      CellTags->"Active"],
    Cell[74611, 2613, 107, 2, 15, "Index",
      CellTags->"Active"],
    Cell[119958, 4302, 178, 6, 16, "Index",
      CellTags->"Active"]},
  "CellEditDuplicate"->{
    Cell[58640, 2117, 129, 2, 15, "Index",
      CellTags->"CellEditDuplicate"]},
  "Evaluatable"->{
    Cell[58772, 2121, 117, 2, 15, "Index",
      CellTags->"Evaluatable"]},
  "Copyable"->{
    Cell[59126, 2133, 111, 2, 15, "Index",
      CellTags->"Copyable"]},
  "CellOpen"->{
    Cell[59240, 2137, 111, 2, 15, "Index",
      CellTags->"CellOpen"]},
  "CellGroupingRules"->{
    Cell[59354, 2141, 129, 2, 15, "Index",
      CellTags->"CellGroupingRules"]},
  "ConversionRules"->{
    Cell[59486, 2145, 125, 2, 15, "Index",
      CellTags->"ConversionRules"]},
  "TaggingRules"->{
    Cell[59614, 2149, 119, 2, 15, "Index",
      CellTags->"TaggingRules"]},
  "CellHorizontalScrolling"->{
    Cell[59736, 2153, 141, 2, 15, "Index",
      CellTags->"CellHorizontalScrolling"]},
  "StyleMenuListing"->{
    Cell[59880, 2157, 127, 2, 15, "Index",
      CellTags->"StyleMenuListing"]},
  "ButtonStyleMenuListing"->{
    Cell[60010, 2161, 139, 2, 15, "Index",
      CellTags->"ButtonStyleMenuListing"]},
  "CounterStyleMenuListing"->{
    Cell[60152, 2165, 141, 2, 15, "Index",
      CellTags->"CounterStyleMenuListing"]},
  "FormatTypeAutoConvert"->{
    Cell[60296, 2169, 137, 2, 15, "Index",
      CellTags->"FormatTypeAutoConvert"]},
  "PageBreakAbove"->{
    Cell[60436, 2173, 123, 2, 15, "Index",
      CellTags->"PageBreakAbove"]},
  "PageBreakWithin"->{
    Cell[60562, 2177, 125, 2, 15, "Index",
      CellTags->"PageBreakWithin"]},
  "PageBreakBelow"->{
    Cell[60690, 2181, 123, 2, 15, "Index",
      CellTags->"PageBreakBelow"]},
  "GroupPageBreakWithin"->{
    Cell[60816, 2185, 135, 2, 15, "Index",
      CellTags->"GroupPageBreakWithin"]},
  "InitializationCell"->{
    Cell[60954, 2189, 131, 2, 15, "Index",
      CellTags->"InitializationCell"]},
  "CellEvaluationDuplicate"->{
    Cell[61088, 2193, 141, 2, 15, "Index",
      CellTags->"CellEvaluationDuplicate"]},
  "GeneratedCell"->{
    Cell[61232, 2197, 121, 2, 15, "Index",
      CellTags->"GeneratedCell"]},
  "CellAutoOverwrite"->{
    Cell[61356, 2201, 129, 2, 15, "Index",
      CellTags->"CellAutoOverwrite"]},
  "CellLabel"->{
    Cell[61604, 2209, 113, 2, 15, "Index",
      CellTags->"CellLabel"]},
  "ShowCellLabel"->{
    Cell[61720, 2213, 121, 2, 15, "Index",
      CellTags->"ShowCellLabel"]},
  "CellLabelPositioning"->{
    Cell[61844, 2217, 135, 2, 15, "Index",
      CellTags->"CellLabelPositioning"]},
  "CellLabelAutoDelete"->{
    Cell[61982, 2221, 133, 2, 15, "Index",
      CellTags->"CellLabelAutoDelete"]},
  "CellLabelMargins"->{
    Cell[62118, 2225, 127, 2, 15, "Index",
      CellTags->"CellLabelMargins"]},
  "CellFrameMargins"->{
    Cell[62364, 2233, 127, 2, 15, "Index",
      CellTags->"CellFrameMargins"]},
  "CellFrameColor"->{
    Cell[62494, 2237, 123, 2, 15, "Index",
      CellTags->"CellFrameColor"]},
  "CellFrameLabelMargins"->{
    Cell[62620, 2241, 137, 2, 15, "Index",
      CellTags->"CellFrameLabelMargins"]},
  "CellFrameLabels"->{
    Cell[62760, 2245, 125, 2, 15, "Index",
      CellTags->"CellFrameLabels"]},
  "ShowCellTags"->{
    Cell[62888, 2249, 119, 2, 15, "Index",
      CellTags->"ShowCellTags"]},
  "CellSize"->{
    Cell[63010, 2253, 111, 2, 15, "Index",
      CellTags->"CellSize"]},
  "CellBaseline"->{
    Cell[63124, 2257, 119, 2, 15, "Index",
      CellTags->"CellBaseline"]},
  "DefaultNewCellStyle"->{
    Cell[63246, 2261, 133, 2, 15, "Index",
      CellTags->"DefaultNewCellStyle"]},
  "DefaultNewInlineCellStyle"->{
    Cell[63382, 2265, 145, 2, 15, "Index",
      CellTags->"DefaultNewInlineCellStyle"]},
  "DefaultDuplicateCellStyle"->{
    Cell[63530, 2269, 145, 2, 15, "Index",
      CellTags->"DefaultDuplicateCellStyle"]},
  "DefaultFormatType"->{
    Cell[63678, 2273, 129, 2, 15, "Index",
      CellTags->"DefaultFormatType"]},
  "DefaultInlineFormatType"->{
    Cell[63810, 2277, 141, 2, 15, "Index",
      CellTags->"DefaultInlineFormatType"]},
  "FormatType"->{
    Cell[63954, 2281, 115, 2, 15, "Index",
      CellTags->"FormatType"],
    Cell[79081, 2773, 208, 6, 16, "Index",
      CellTags->"FormatType"],
    Cell[80545, 2825, 202, 6, 16, "Index",
      CellTags->"FormatType"],
    Cell[81981, 2877, 210, 6, 16, "Index",
      CellTags->"FormatType"],
    Cell[83451, 2929, 196, 6, 16, "Index",
      CellTags->"FormatType"],
    Cell[84841, 2981, 200, 6, 16, "Index",
      CellTags->"FormatType"],
    Cell[86251, 3033, 196, 6, 16, "Index",
      CellTags->"FormatType"]},
  "AutoIndent"->{
    Cell[64306, 2293, 115, 2, 15, "Index",
      CellTags->"AutoIndent"]},
  "InputAliases"->{
    Cell[64424, 2297, 119, 2, 15, "Index",
      CellTags->"InputAliases"]},
  "InputAutoReplacements"->{
    Cell[64546, 2301, 137, 2, 15, "Index",
      CellTags->"InputAutoReplacements"]},
  "DelimiterFlashTime"->{
    Cell[64686, 2305, 131, 2, 15, "Index",
      CellTags->"DelimiterFlashTime"]},
  "ShowCursorTracker"->{
    Cell[64820, 2309, 129, 2, 15, "Index",
      CellTags->"ShowCursorTracker"]},
  "ShowAutoStyles"->{
    Cell[64952, 2313, 123, 2, 15, "Index",
      CellTags->"ShowAutoStyles"]},
  "StructuredSelection"->{
    Cell[65078, 2317, 133, 2, 15, "Index",
      CellTags->"StructuredSelection"]},
  "StyleBoxAutoDelete"->{
    Cell[65214, 2321, 131, 2, 15, "Index",
      CellTags->"StyleBoxAutoDelete"]},
  "DragAndDrop"->{
    Cell[65348, 2325, 117, 2, 15, "Index",
      CellTags->"DragAndDrop"]},
  "ShowSpecialCharacters"->{
    Cell[65468, 2329, 137, 2, 15, "Index",
      CellTags->"ShowSpecialCharacters"]},
  "AllowInlineCells"->{
    Cell[65608, 2333, 127, 2, 15, "Index",
      CellTags->"AllowInlineCells"]},
  "PasteBoxFormInlineCells"->{
    Cell[65738, 2337, 141, 2, 15, "Index",
      CellTags->"PasteBoxFormInlineCells"]},
  "TwoByteSyntaxCharacterAutoReplacement"->{
    Cell[65882, 2341, 169, 2, 15, "Index",
      CellTags->"TwoByteSyntaxCharacterAutoReplacement"]},
  "CursorTrackerParameters"->{
    Cell[66054, 2345, 141, 2, 15, "Index",
      CellTags->"CursorTrackerParameters"]},
  "AutoStyleOptions"->{
    Cell[66198, 2349, 127, 2, 15, "Index",
      CellTags->"AutoStyleOptions"]},
  "FontSize"->{
    Cell[66328, 2353, 111, 2, 15, "Index",
      CellTags->"FontSize"]},
  "FontFamily"->{
    Cell[66442, 2357, 115, 2, 15, "Index",
      CellTags->"FontFamily"]},
  "FontWeight"->{
    Cell[66560, 2361, 115, 2, 15, "Index",
      CellTags->"FontWeight"]},
  "FontSlant"->{
    Cell[66678, 2365, 113, 2, 15, "Index",
      CellTags->"FontSlant"]},
  "FontTracking"->{
    Cell[66794, 2369, 119, 2, 15, "Index",
      CellTags->"FontTracking"]},
  "FontColor"->{
    Cell[66916, 2373, 113, 2, 15, "Index",
      CellTags->"FontColor"]},
  "FontOptionsBackground"->{
    Cell[67032, 2377, 198, 6, 16, "Index",
      CellTags->"FontOptionsBackground"]},
  "CharacterEncoding"->{
    Cell[67233, 2385, 129, 2, 15, "Index",
      CellTags->"CharacterEncoding"],
    Cell[77351, 2713, 206, 6, 16, "Index",
      CellTags->"CharacterEncoding"]},
  "TextAlignment"->{
    Cell[67489, 2393, 121, 2, 15, "Index",
      CellTags->"TextAlignment"]},
  "TextJustification"->{
    Cell[67613, 2397, 129, 2, 15, "Index",
      CellTags->"TextJustification"]},
  "Hyphenation"->{
    Cell[67745, 2401, 117, 2, 15, "Index",
      CellTags->"Hyphenation"]},
  "TabFilling"->{
    Cell[67865, 2405, 115, 2, 15, "Index",
      CellTags->"TabFilling"]},
  "LineSpacing"->{
    Cell[67983, 2409, 117, 2, 15, "Index",
      CellTags->"LineSpacing"]},
  "ParagraphSpacing"->{
    Cell[68103, 2413, 127, 2, 15, "Index",
      CellTags->"ParagraphSpacing"]},
  "ParagraphIndent"->{
    Cell[68233, 2417, 125, 2, 15, "Index",
      CellTags->"ParagraphIndent"]},
  "TabSpacings"->{
    Cell[68361, 2421, 117, 2, 15, "Index",
      CellTags->"TabSpacings"]},
  "AutoItalicWords"->{
    Cell[68481, 2425, 125, 2, 15, "Index",
      CellTags->"AutoItalicWords"]},
  "LanguageCategory"->{
    Cell[68609, 2429, 127, 2, 15, "Index",
      CellTags->"LanguageCategory"]},
  "DefaultNaturalLanguage"->{
    Cell[68739, 2433, 139, 2, 15, "Index",
      CellTags->"DefaultNaturalLanguage"]},
  "AutoSpacing"->{
    Cell[68881, 2437, 117, 2, 15, "Index",
      CellTags->"AutoSpacing"]},
  "ShowContents"->{
    Cell[69001, 2441, 119, 2, 15, "Index",
      CellTags->"ShowContents"]},
  "ScriptSizeMultipliers"->{
    Cell[69123, 2445, 137, 2, 15, "Index",
      CellTags->"ScriptSizeMultipliers"]},
  "ScriptMinSize"->{
    Cell[69263, 2449, 121, 2, 15, "Index",
      CellTags->"ScriptMinSize"]},
  "ScriptLevel"->{
    Cell[69387, 2453, 117, 2, 15, "Index",
      CellTags->"ScriptLevel"]},
  "ShowStringCharacters"->{
    Cell[69507, 2457, 135, 2, 15, "Index",
      CellTags->"ShowStringCharacters"]},
  "NumberMarks"->{
    Cell[69645, 2461, 117, 2, 15, "Index",
      CellTags->"NumberMarks"]},
  "PrintPrecision"->{
    Cell[69765, 2465, 123, 2, 15, "Index",
      CellTags->"PrintPrecision"]},
  "NumberMultiplier"->{
    Cell[69891, 2469, 127, 2, 15, "Index",
      CellTags->"NumberMultiplier"]},
  "LimitsPositioning"->{
    Cell[70021, 2473, 129, 2, 15, "Index",
      CellTags->"LimitsPositioning"]},
  "LimitsPositioningTokens"->{
    Cell[70153, 2477, 141, 2, 15, "Index",
      CellTags->"LimitsPositioningTokens"]},
  "ScriptBaselineShifts"->{
    Cell[70297, 2481, 135, 2, 15, "Index",
      CellTags->"ScriptBaselineShifts"]},
  "SingleLetterItalics"->{
    Cell[70435, 2485, 133, 2, 15, "Index",
      CellTags->"SingleLetterItalics"]},
  "TraditionalFunctionNotation"->{
    Cell[70571, 2489, 149, 2, 15, "Index",
      CellTags->"TraditionalFunctionNotation"]},
  "DelimiterMatching"->{
    Cell[70723, 2493, 129, 2, 15, "Index",
      CellTags->"DelimiterMatching"]},
  "ZeroWidthTimes"->{
    Cell[70855, 2497, 123, 2, 15, "Index",
      CellTags->"ZeroWidthTimes"]},
  "SpanMinSize"->{
    Cell[70981, 2501, 117, 2, 15, "Index",
      CellTags->"SpanMinSize"]},
  "SpanMaxSize"->{
    Cell[71101, 2505, 117, 2, 15, "Index",
      CellTags->"SpanMaxSize"]},
  "SpanSymmetric"->{
    Cell[71221, 2509, 121, 2, 15, "Index",
      CellTags->"SpanSymmetric"]},
  "SpanLineThickness"->{
    Cell[71345, 2513, 129, 2, 15, "Index",
      CellTags->"SpanLineThickness"]},
  "SpanCharacterRounding"->{
    Cell[71477, 2517, 137, 2, 15, "Index",
      CellTags->"SpanCharacterRounding"]},
  "SpanAdjustments"->{
    Cell[71617, 2521, 125, 2, 15, "Index",
      CellTags->"SpanAdjustments"]},
  "LineBreakWithin"->{
    Cell[71745, 2525, 125, 2, 15, "Index",
      CellTags->"LineBreakWithin"]},
  "LineIndent"->{
    Cell[71873, 2529, 115, 2, 15, "Index",
      CellTags->"LineIndent"]},
  "IndentMaxFraction"->{
    Cell[71991, 2533, 129, 2, 15, "Index",
      CellTags->"IndentMaxFraction"]},
  "LinebreakAdjustments"->{
    Cell[72123, 2537, 135, 2, 15, "Index",
      CellTags->"LinebreakAdjustments"]},
  "AspectRatioFixed"->{
    Cell[72261, 2541, 127, 2, 15, "Index",
      CellTags->"AspectRatioFixed"]},
  "ImageSize"->{
    Cell[72391, 2545, 113, 2, 15, "Index",
      CellTags->"ImageSize"]},
  "ImageMargins"->{
    Cell[72507, 2549, 119, 2, 15, "Index",
      CellTags->"ImageMargins"]},
  "ImageRegion"->{
    Cell[72629, 2553, 117, 2, 15, "Index",
      CellTags->"ImageRegion"]},
  "AnimationDisplayTime"->{
    Cell[72749, 2557, 135, 2, 15, "Index",
      CellTags->"AnimationDisplayTime"]},
  "AnimationCycleOffset"->{
    Cell[72887, 2561, 135, 2, 15, "Index",
      CellTags->"AnimationCycleOffset"]},
  "AnimationCycleRepetitions"->{
    Cell[73025, 2565, 145, 2, 15, "Index",
      CellTags->"AnimationCycleRepetitions"]},
  "DrawDummyGraphics"->{
    Cell[73173, 2569, 129, 2, 15, "Index",
      CellTags->"DrawDummyGraphics"]},
  "RenderIncrementally"->{
    Cell[73305, 2573, 133, 2, 15, "Index",
      CellTags->"RenderIncrementally"]},
  "RenderFilledAreas"->{
    Cell[73441, 2577, 129, 2, 15, "Index",
      CellTags->"RenderFilledAreas"]},
  "RenderLines"->{
    Cell[73573, 2581, 117, 2, 15, "Index",
      CellTags->"RenderLines"]},
  "RenderThickness"->{
    Cell[73693, 2585, 125, 2, 15, "Index",
      CellTags->"RenderThickness"]},
  "RenderSystemColors"->{
    Cell[73821, 2589, 131, 2, 15, "Index",
      CellTags->"RenderSystemColors"]},
  "ObjectDithering"->{
    Cell[73955, 2593, 125, 2, 15, "Index",
      CellTags->"ObjectDithering"]},
  "RasterDithering"->{
    Cell[74083, 2597, 125, 2, 15, "Index",
      CellTags->"RasterDithering"]},
  "ImageHalftoneDensity"->{
    Cell[74211, 2601, 135, 2, 15, "Index",
      CellTags->"ImageHalftoneDensity"]},
  "ImageHalftoneAngle"->{
    Cell[74349, 2605, 131, 2, 15, "Index",
      CellTags->"ImageHalftoneAngle"]},
  "ImageCacheDepth"->{
    Cell[74483, 2609, 125, 2, 15, "Index",
      CellTags->"ImageCacheDepth"]},
  "ButtonFunction"->{
    Cell[74721, 2617, 123, 2, 15, "Index",
      CellTags->"ButtonFunction"],
    Cell[117941, 4210, 194, 6, 16, "Index",
      CellTags->"ButtonFunction"]},
  "ButtonSource"->{
    Cell[74847, 2621, 119, 2, 15, "Index",
      CellTags->"ButtonSource"],
    Cell[118337, 4226, 190, 6, 16, "Index",
      CellTags->"ButtonSource"]},
  "ButtonEvaluator"->{
    Cell[74969, 2625, 125, 2, 15, "Index",
      CellTags->"ButtonEvaluator"],
    Cell[118138, 4218, 196, 6, 16, "Index",
      CellTags->"ButtonEvaluator"]},
  "ButtonData"->{
    Cell[75097, 2629, 115, 2, 15, "Index",
      CellTags->"ButtonData"],
    Cell[118530, 4234, 198, 8, 16, "Index",
      CellTags->"ButtonData"]},
  "ButtonStyle"->{
    Cell[75215, 2633, 117, 2, 15, "Index",
      CellTags->"ButtonStyle"],
    Cell[117750, 4202, 188, 6, 16, "Index",
      CellTags->"ButtonStyle"]},
  "ButtonFrame"->{
    Cell[75335, 2637, 117, 2, 15, "Index",
      CellTags->"ButtonFrame"],
    Cell[118932, 4254, 200, 8, 16, "Index",
      CellTags->"ButtonFrame"]},
  "ButtonBackground"->{
    Cell[75455, 2641, 190, 6, 16, "Index",
      CellTags->"ButtonBackground"],
    Cell[119135, 4264, 189, 6, 16, "Index",
      CellTags->"ButtonBackground"]},
  "ButtonMargins"->{
    Cell[75648, 2649, 121, 2, 15, "Index",
      CellTags->"ButtonMargins"],
    Cell[119327, 4272, 204, 8, 16, "Index",
      CellTags->"ButtonMargins"]},
  "ButtonExpandable"->{
    Cell[75772, 2653, 127, 2, 15, "Index",
      CellTags->"ButtonExpandable"],
    Cell[119745, 4292, 210, 8, 16, "Index",
      CellTags->"ButtonExpandable"]},
  "ButtonMinHeight"->{
    Cell[75902, 2657, 125, 2, 15, "Index",
      CellTags->"ButtonMinHeight"],
    Cell[119534, 4282, 208, 8, 16, "Index",
      CellTags->"ButtonMinHeight"]},
  "ButtonNote"->{
    Cell[76030, 2661, 115, 2, 15, "Index",
      CellTags->"ButtonNote"],
    Cell[118731, 4244, 198, 8, 16, "Index",
      CellTags->"ButtonNote"]},
  "PrivatePaths->{...}"->{
    Cell[76148, 2665, 133, 2, 15, "Index",
      CellTags->"PrivatePaths->{...}"]},
  "TextResources"->{
    Cell[76284, 2669, 186, 6, 16, "Index",
      CellTags->"TextResources"],
    Cell[76473, 2677, 188, 6, 16, "Index",
      CellTags->"TextResources"]},
  "AFM"->{
    Cell[76664, 2685, 166, 6, 16, "Index",
      CellTags->"AFM"]},
  "Fonts"->{
    Cell[76833, 2693, 170, 6, 16, "Index",
      CellTags->"Fonts"]},
  "OpenSpecialOptions->{...}"->{
    Cell[77006, 2701, 145, 2, 15, "Index",
      CellTags->"OpenSpecialOptions->{...}"]},
  "ReadingType"->{
    Cell[77154, 2705, 194, 6, 16, "Index",
      CellTags->"ReadingType"]},
  "ListAllFileTypes"->{
    Cell[77560, 2721, 204, 6, 16, "Index",
      CellTags->"ListAllFileTypes"]},
  "ToPostScriptOptions->{...}"->{
    Cell[77767, 2729, 147, 2, 15, "Index",
      CellTags->"ToPostScriptOptions->{...}"]},
  "RemoveColorFromBitmaps"->{
    Cell[77917, 2733, 218, 6, 16, "Index",
      CellTags->"RemoveColorFromBitmaps"]},
  "IgnoreEmbeddedPostScript"->{
    Cell[78138, 2741, 222, 6, 16, "Index",
      CellTags->"IgnoreEmbeddedPostScript"]},
  "BitsPerPixel"->{
    Cell[78363, 2749, 198, 6, 16, "Index",
      CellTags->"BitsPerPixel"],
    Cell[78716, 2761, 198, 6, 16, "Index",
      CellTags->"BitsPerPixel"]},
  "ImportTypesetOptions->{...}"->{
    Cell[78564, 2757, 149, 2, 15, "Index",
      CellTags->"ImportTypesetOptions->{...}"]},
  "ExportMultipleCellsOptions->{...}"->{
    Cell[78917, 2769, 161, 2, 15, "Index",
      CellTags->"ExportMultipleCellsOptions->{...}"]},
  "IncludeCellLabels"->{
    Cell[79501, 2789, 222, 6, 16, "Index",
      CellTags->"IncludeCellLabels"],
    Cell[80953, 2841, 216, 6, 16, "Index",
      CellTags->"IncludeCellLabels"],
    Cell[82405, 2893, 224, 6, 16, "Index",
      CellTags->"IncludeCellLabels"],
    Cell[83847, 2945, 210, 6, 16, "Index",
      CellTags->"IncludeCellLabels"],
    Cell[85245, 2997, 214, 6, 16, "Index",
      CellTags->"IncludeCellLabels"],
    Cell[86647, 3049, 210, 6, 16, "Index",
      CellTags->"IncludeCellLabels"]},
  "IncludeCellTags"->{
    Cell[79726, 2797, 218, 6, 16, "Index",
      CellTags->"IncludeCellTags"],
    Cell[81172, 2849, 212, 6, 16, "Index",
      CellTags->"IncludeCellTags"],
    Cell[82632, 2901, 220, 6, 16, "Index",
      CellTags->"IncludeCellTags"],
    Cell[84060, 2953, 206, 6, 16, "Index",
      CellTags->"IncludeCellTags"],
    Cell[85462, 3005, 210, 6, 16, "Index",
      CellTags->"IncludeCellTags"],
    Cell[86860, 3057, 206, 6, 16, "Index",
      CellTags->"IncludeCellTags"]},
  "CellBreaks"->{
    Cell[79947, 2805, 208, 6, 16, "Index",
      CellTags->"CellBreaks"],
    Cell[81387, 2857, 202, 6, 16, "Index",
      CellTags->"CellBreaks"],
    Cell[82855, 2909, 210, 6, 16, "Index",
      CellTags->"CellBreaks"],
    Cell[84269, 2961, 196, 6, 16, "Index",
      CellTags->"CellBreaks"],
    Cell[85675, 3013, 200, 6, 16, "Index",
      CellTags->"CellBreaks"],
    Cell[87069, 3065, 196, 6, 16, "Index",
      CellTags->"CellBreaks"]},
  "CMYKColorGeneration"->{
    Cell[80158, 2813, 226, 6, 16, "Index",
      CellTags->"CMYKColorGeneration"],
    Cell[81592, 2865, 220, 6, 16, "Index",
      CellTags->"CMYKColorGeneration"],
    Cell[83068, 2917, 228, 6, 16, "Index",
      CellTags->"CMYKColorGeneration"],
    Cell[84468, 2969, 214, 6, 16, "Index",
      CellTags->"CMYKColorGeneration"],
    Cell[85878, 3021, 218, 6, 16, "Index",
      CellTags->"CMYKColorGeneration"],
    Cell[87268, 3073, 214, 6, 16, "Index",
      CellTags->"CMYKColorGeneration"]},
  "ExportPostScriptOptions->{...}"->{
    Cell[80387, 2821, 155, 2, 15, "Index",
      CellTags->"ExportPostScriptOptions->{...}"]},
  "ExportNativeGraphicsOptions->{...}"->{
    Cell[81815, 2873, 163, 2, 15, "Index",
      CellTags->"ExportNativeGraphicsOptions->{...}"]},
  "ExportTypesetOptions->{...}"->{
    Cell[83299, 2925, 149, 2, 15, "Index",
      CellTags->"ExportTypesetOptions->{...}"]},
  "ExportQuickTimeOptions->{...}"->{
    Cell[84685, 2977, 153, 2, 15, "Index",
      CellTags->"ExportQuickTimeOptions->{...}"]},
  "SaveAsSpecialOptions->{...}"->{
    Cell[86099, 3029, 149, 2, 15, "Index",
      CellTags->"SaveAsSpecialOptions->{...}"]},
  "FindSettings->{...}"->{
    Cell[87485, 3081, 133, 2, 15, "Index",
      CellTags->"FindSettings->{...}"]},
  "FindString"->{
    Cell[87621, 3085, 180, 6, 16, "Index",
      CellTags->"FindString"]},
  "ReplaceString"->{
    Cell[87804, 3093, 186, 6, 16, "Index",
      CellTags->"ReplaceString"]},
  "IgnoreCase"->{
    Cell[87993, 3101, 180, 6, 16, "Index",
      CellTags->"IgnoreCase"]},
  "Wraparound"->{
    Cell[88176, 3109, 180, 6, 16, "Index",
      CellTags->"Wraparound"]},
  "EditCellTagsSettings->{...}"->{
    Cell[88548, 3125, 149, 2, 15, "Index",
      CellTags->"EditCellTagsSettings->{...}"]},
  "ViewPointSelectorSettings->{...}"->{
    Cell[89105, 3145, 159, 2, 15, "Index",
      CellTags->"ViewPointSelectorSettings->{...}"]},
  "CoordinateSystem"->{
    Cell[89267, 3149, 218, 6, 16, "Index",
      CellTags->"CoordinateSystem"]},
  "TemplateText"->{
    Cell[89488, 3157, 210, 6, 16, "Index",
      CellTags->"TemplateText"]},
  "ViewPoint"->{
    Cell[89701, 3165, 204, 6, 16, "Index",
      CellTags->"ViewPoint"]},
  "ColorSelectorSettings->{...}"->{
    Cell[90123, 3181, 151, 2, 15, "Index",
      CellTags->"ColorSelectorSettings->{...}"]},
  "Color"->{
    Cell[90277, 3185, 188, 6, 16, "Index",
      CellTags->"Color"],
    Cell[107884, 3833, 182, 6, 16, "Index",
      CellTags->"Color"]},
  "GridCreationSettings->{...}"->{
    Cell[90468, 3193, 149, 2, 15, "Index",
      CellTags->"GridCreationSettings->{...}"]},
  "Rows"->{
    Cell[90620, 3197, 184, 6, 16, "Index",
      CellTags->"Rows"]},
  "Columns"->{
    Cell[90807, 3205, 190, 6, 16, "Index",
      CellTags->"Columns"]},
  "DrawRowLines"->{
    Cell[91000, 3213, 200, 6, 16, "Index",
      CellTags->"DrawRowLines"]},
  "DrawColumnLines"->{
    Cell[91203, 3221, 206, 6, 16, "Index",
      CellTags->"DrawColumnLines"]},
  "DrawFrame"->{
    Cell[91412, 3229, 194, 6, 16, "Index",
      CellTags->"DrawFrame"]},
  "Type"->{
    Cell[91609, 3237, 184, 6, 16, "Index",
      CellTags->"Type"]},
  "Fill"->{
    Cell[91796, 3245, 184, 6, 16, "Index",
      CellTags->"Fill"]},
  "DiagonalFill"->{
    Cell[91983, 3253, 200, 6, 16, "Index",
      CellTags->"DiagonalFill"]},
  "FillText"->{
    Cell[92186, 3261, 192, 6, 16, "Index",
      CellTags->"FillText"]},
  "DiagonalFillText"->{
    Cell[92381, 3269, 208, 6, 16, "Index",
      CellTags->"DiagonalFillText"]},
  "NotebookStatisticsSettings->{...}"->{
    Cell[92592, 3277, 161, 2, 15, "Index",
      CellTags->"NotebookStatisticsSettings->{...}"]},
  "Domain"->{
    Cell[92756, 3281, 200, 6, 16, "Index",
      CellTags->"Domain"]},
  "IncludeSharedData"->{
    Cell[92959, 3289, 222, 6, 16, "Index",
      CellTags->"IncludeSharedData"]},
  "OptionInspectorSettings->{...}"->{
    Cell[93401, 3305, 155, 2, 15, "Index",
      CellTags->"OptionInspectorSettings->{...}"]},
  "Scope"->{
    Cell[93559, 3309, 192, 6, 16, "Index",
      CellTags->"Scope"]},
  "ViewAs"->{
    Cell[93754, 3317, 194, 6, 16, "Index",
      CellTags->"ViewAs"]},
  "EditButtonSettings->{...}"->{
    Cell[94367, 3341, 145, 2, 15, "Index",
      CellTags->"EditButtonSettings->{...}"]},
  "BackgroundTasksSettings->{...}"->{
    Cell[94716, 3353, 155, 2, 15, "Index",
      CellTags->"BackgroundTasksSettings->{...}"]},
  "InterruptSettings->{...}"->{
    Cell[95085, 3365, 143, 2, 15, "Index",
      CellTags->"InterruptSettings->{...}"]},
  "InputSettings->{...}"->{
    Cell[95430, 3377, 135, 2, 15, "Index",
      CellTags->"InputSettings->{...}"]},
  "HelpBrowserSettings->{...}"->{
    Cell[95759, 3389, 147, 2, 15, "Index",
      CellTags->"HelpBrowserSettings->{...}"]},
  "ErrorsDialogSettings->{...}"->{
    Cell[96513, 3417, 149, 2, 15, "Index",
      CellTags->"ErrorsDialogSettings->{...}"]},
  "StyleNameDialogSettings->{...}"->{
    Cell[96870, 3429, 155, 2, 15, "Index",
      CellTags->"StyleNameDialogSettings->{...}"]},
  "Style"->{
    Cell[97028, 3433, 192, 6, 16, "Index",
      CellTags->"Style"]},
  "FileNameDialogSettings->{...}"->{
    Cell[97223, 3441, 153, 2, 15, "Index",
      CellTags->"FileNameDialogSettings->{...}"]},
  "StringFormat"->{
    Cell[97379, 3445, 204, 6, 16, "Index",
      CellTags->"StringFormat"]},
  "NotebookConvertSettings->{...}"->{
    Cell[97586, 3453, 155, 2, 15, "Index",
      CellTags->"NotebookConvertSettings->{...}"]},
  "InputToStandardForm"->{
    Cell[97744, 3457, 220, 6, 16, "Index",
      CellTags->"InputToStandardForm"]},
  "OutputToStandardForm"->{
    Cell[97967, 3465, 222, 6, 16, "Index",
      CellTags->"OutputToStandardForm"]},
  "PreserveStyleSheet"->{
    Cell[98192, 3473, 218, 6, 16, "Index",
      CellTags->"PreserveStyleSheet"]},
  "GenerateBitmapCaches"->{
    Cell[98413, 3481, 222, 6, 16, "Index",
      CellTags->"GenerateBitmapCaches"]},
  "ScrollingOptions->{...}"->{
    Cell[98638, 3489, 141, 2, 15, "Index",
      CellTags->"ScrollingOptions->{...}"]},
  "PagewiseScrolling"->{
    Cell[98782, 3493, 202, 6, 16, "Index",
      CellTags->"PagewiseScrolling"]},
  "PagewiseDisplay"->{
    Cell[98987, 3501, 198, 6, 16, "Index",
      CellTags->"PagewiseDisplay"]},
  "RealTimeScrolling"->{
    Cell[99188, 3509, 202, 6, 16, "Index",
      CellTags->"RealTimeScrolling"]},
  "JumpScrolling"->{
    Cell[99393, 3517, 194, 6, 16, "Index",
      CellTags->"JumpScrolling"]},
  "VerticalScrollRange"->{
    Cell[99590, 3525, 206, 6, 16, "Index",
      CellTags->"VerticalScrollRange"]},
  "HorizontalScrollRange"->{
    Cell[99799, 3533, 210, 6, 16, "Index",
      CellTags->"HorizontalScrollRange"]},
  "SpeedParameters"->{
    Cell[100012, 3541, 198, 6, 16, "Index",
      CellTags->"SpeedParameters"]},
  "PrintingOptions->{...}"->{
    Cell[100213, 3549, 139, 2, 15, "Index",
      CellTags->"PrintingOptions->{...}"]},
  "PaperOrientation"->{
    Cell[100355, 3553, 205, 6, 16, "Index",
      CellTags->"PaperOrientation"]},
  "PrintCellBrackets"->{
    Cell[100563, 3561, 207, 6, 16, "Index",
      CellTags->"PrintCellBrackets"]},
  "PrintSelectionHighlighting"->{
    Cell[100773, 3569, 225, 6, 16, "Index",
      CellTags->"PrintSelectionHighlighting"]},
  "PrintRegistrationMarks"->{
    Cell[101001, 3577, 217, 6, 16, "Index",
      CellTags->"PrintRegistrationMarks"]},
  "PrintMultipleHorizontalPages"->{
    Cell[101221, 3585, 229, 6, 16, "Index",
      CellTags->"PrintMultipleHorizontalPages"]},
  "FirstPageHeader"->{
    Cell[101453, 3593, 203, 6, 16, "Index",
      CellTags->"FirstPageHeader"]},
  "FirstPageFooter"->{
    Cell[101659, 3601, 203, 6, 16, "Index",
      CellTags->"FirstPageFooter"]},
  "CellBackgroundHalftoneAngle"->{
    Cell[101865, 3609, 215, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[102083, 3617, 215, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[103357, 3665, 227, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[103587, 3673, 219, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[103809, 3681, 235, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[104047, 3689, 220, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[104270, 3697, 223, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[104496, 3705, 224, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[104723, 3713, 227, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[104953, 3721, 211, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[105167, 3729, 205, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"],
    Cell[105375, 3737, 204, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneAngle"]},
  "FacingPages"->{
    Cell[102301, 3625, 195, 6, 16, "Index",
      CellTags->"FacingPages"]},
  "FirstPageFace"->{
    Cell[102499, 3633, 199, 6, 16, "Index",
      CellTags->"FirstPageFace"]},
  "GraphicsPrintingFormat"->{
    Cell[102701, 3641, 217, 6, 16, "Index",
      CellTags->"GraphicsPrintingFormat"]},
  "CellBackgroundHalftoneDensity"->{
    Cell[103123, 3657, 231, 6, 16, "Index",
      CellTags->"CellBackgroundHalftoneDensity"]},
  "PageHeaderMargins"->{
    Cell[105582, 3745, 203, 6, 16, "Index",
      CellTags->"PageHeaderMargins"]},
  "PageFooterMargins"->{
    Cell[105788, 3753, 203, 6, 16, "Index",
      CellTags->"PageFooterMargins"]},
  "IndexCreationOptions->{...}"->{
    Cell[105994, 3761, 149, 2, 15, "Index",
      CellTags->"IndexCreationOptions->{...}"]},
  "Thickness"->{
    Cell[106146, 3765, 191, 6, 16, "Index",
      CellTags->"Thickness"],
    Cell[106340, 3773, 193, 6, 16, "Index",
      CellTags->"Thickness"],
    Cell[106536, 3781, 206, 6, 16, "Index",
      CellTags->"Thickness"],
    Cell[106745, 3789, 198, 6, 16, "Index",
      CellTags->"Thickness"],
    Cell[106946, 3797, 201, 6, 16, "Index",
      CellTags->"Thickness"],
    Cell[107150, 3805, 194, 6, 16, "Index",
      CellTags->"Thickness"],
    Cell[107347, 3813, 193, 6, 16, "Index",
      CellTags->"Thickness"],
    Cell[107691, 3825, 190, 6, 16, "Index",
      CellTags->"Thickness"],
    Cell[109372, 3889, 197, 6, 16, "Index",
      CellTags->"Thickness"],
    Cell[109572, 3897, 201, 6, 16, "Index",
      CellTags->"Thickness"]},
  "CellBracketOptions->{...}"->{
    Cell[107543, 3821, 145, 2, 15, "Index",
      CellTags->"CellBracketOptions->{...}"]},
  "Margins"->{
    Cell[108069, 3841, 186, 6, 16, "Index",
      CellTags->"Margins"]},
  "Widths"->{
    Cell[108258, 3849, 184, 6, 16, "Index",
      CellTags->"Widths"]},
  "CellElementSpacings->{...}"->{
    Cell[108445, 3857, 147, 2, 15, "Index",
      CellTags->"CellElementSpacings->{...}"]},
  "CellMinHeight"->{
    Cell[108595, 3861, 200, 6, 16, "Index",
      CellTags->"CellMinHeight"]},
  "ClosedCellHeight"->{
    Cell[108798, 3869, 206, 6, 16, "Index",
      CellTags->"ClosedCellHeight"]},
  "ClosedGroupTopMargin"->{
    Cell[109007, 3877, 214, 6, 16, "Index",
      CellTags->"ClosedGroupTopMargin"]},
  "PrivateCellOptions->{...}"->{
    Cell[109224, 3885, 145, 2, 15, "Index",
      CellTags->"PrivateCellOptions->{...}"]},
  "PrivateEvaluationOptions->{...}"->{
    Cell[109776, 3905, 157, 2, 15, "Index",
      CellTags->"PrivateEvaluationOptions->{...}"]},
  "OutputFormPageWidth\" "->{
    Cell[109936, 3909, 225, 6, 16, "Index",
      CellTags->"OutputFormPageWidth\" "]},
  "StoreInputForm\" "->{
    Cell[110164, 3917, 216, 6, 16, "Index",
      CellTags->"StoreInputForm\" "]},
  "CommonDefaultFormatTypes->{...}"->{
    Cell[110383, 3925, 157, 2, 15, "Index",
      CellTags->"CommonDefaultFormatTypes->{...}"]},
  "Text"->{
    Cell[110543, 3929, 192, 6, 16, "Index",
      CellTags->"Text"]},
  "Input"->{
    Cell[110738, 3937, 194, 6, 16, "Index",
      CellTags->"Input"]},
  "Output"->{
    Cell[110935, 3945, 196, 6, 16, "Index",
      CellTags->"Output"]},
  "TextInline"->{
    Cell[111134, 3953, 204, 6, 16, "Index",
      CellTags->"TextInline"]},
  "OutputInline"->{
    Cell[111341, 3961, 208, 6, 16, "Index",
      CellTags->"OutputInline"]},
  "InputInline"->{
    Cell[111552, 3969, 206, 6, 16, "Index",
      CellTags->"InputInline"]},
  "FontVariations->{...}"->{
    Cell[111761, 3977, 137, 2, 15, "Index",
      CellTags->"FontVariations->{...}"]},
  "Underline"->{
    Cell[111901, 3981, 182, 6, 16, "Index",
      CellTags->"Underline"]},
  "Outline"->{
    Cell[112086, 3989, 178, 6, 16, "Index",
      CellTags->"Outline"]},
  "Shadow"->{
    Cell[112267, 3997, 176, 6, 16, "Index",
      CellTags->"Shadow"]},
  "StrikeThrough"->{
    Cell[112446, 4005, 190, 6, 16, "Index",
      CellTags->"StrikeThrough"]},
  "Masked"->{
    Cell[112639, 4013, 176, 6, 16, "Index",
      CellTags->"Masked"],
    Cell[113019, 4029, 183, 6, 16, "Index",
      CellTags->"Masked"]},
  "CompatibilityType"->{
    Cell[112818, 4021, 198, 6, 16, "Index",
      CellTags->"CompatibilityType"]},
  "FontProperties->{...}"->{
    Cell[113205, 4037, 137, 2, 15, "Index",
      CellTags->"FontProperties->{...}"]},
  "FontSerifed"->{
    Cell[113345, 4041, 186, 6, 16, "Index",
      CellTags->"FontSerifed"]},
  "FontMonospaced"->{
    Cell[113534, 4049, 192, 6, 16, "Index",
      CellTags->"FontMonospaced"]},
  "PrivateFontOptions->{...}"->{
    Cell[113729, 4057, 145, 2, 15, "Index",
      CellTags->"PrivateFontOptions->{...}"]},
  "FontPostScriptName"->{
    Cell[113877, 4061, 208, 6, 16, "Index",
      CellTags->"FontPostScriptName"]},
  "FontType"->{
    Cell[114088, 4069, 188, 6, 16, "Index",
      CellTags->"FontType"]},
  "OperatorSubstitution"->{
    Cell[114279, 4077, 212, 6, 16, "Index",
      CellTags->"OperatorSubstitution"],
    Cell[114494, 4085, 214, 6, 16, "Index",
      CellTags->"OperatorSubstitution"]},
  "HyphenationOptions->{...}"->{
    Cell[114711, 4093, 145, 2, 15, "Index",
      CellTags->"HyphenationOptions->{...}"]},
  "HyphenationFreeZone"->{
    Cell[114859, 4097, 210, 6, 16, "Index",
      CellTags->"HyphenationFreeZone"]},
  "HyphenationCharacter"->{
    Cell[115072, 4105, 212, 6, 16, "Index",
      CellTags->"HyphenationCharacter"]},
  "HyphenationMinLengths"->{
    Cell[115287, 4113, 214, 6, 16, "Index",
      CellTags->"HyphenationMinLengths"]},
  "SpellingOptions->{...}"->{
    Cell[115504, 4121, 139, 2, 15, "Index",
      CellTags->"SpellingOptions->{...}"]},
  "AlwaysStop"->{
    Cell[115646, 4125, 188, 6, 16, "Index",
      CellTags->"AlwaysStop"]},
  "AlwaysSkip"->{
    Cell[115837, 4133, 188, 6, 16, "Index",
      CellTags->"AlwaysSkip"]},
  "WordSplitting"->{
    Cell[116028, 4141, 194, 6, 16, "Index",
      CellTags->"WordSplitting"]},
  "SpellingDictionaries->{...}"->{
    Cell[116225, 4149, 149, 2, 15, "Index",
      CellTags->"SpellingDictionaries->{...}"]},
  "CorrectWords"->{
    Cell[116377, 4153, 202, 6, 16, "Index",
      CellTags->"CorrectWords"]},
  "IncorrectWords"->{
    Cell[116582, 4161, 206, 6, 16, "Index",
      CellTags->"IncorrectWords"]},
  "Suggestions"->{
    Cell[116791, 4169, 200, 6, 16, "Index",
      CellTags->"Suggestions"]},
  "AdjustmentBoxOptions->{...}"->{
    Cell[116994, 4177, 149, 2, 15, "Index",
      CellTags->"AdjustmentBoxOptions->{...}"]},
  "AdjustmentBoxOptions"->{
    Cell[117146, 4181, 204, 6, 16, "Index",
      CellTags->"AdjustmentBoxOptions"]},
  "BoxBaselineShift"->{
    Cell[117353, 4189, 206, 6, 16, "Index",
      CellTags->"BoxBaselineShift"]},
  "ButtonBoxOptions->{...}"->{
    Cell[117562, 4197, 185, 3, 15, "Index",
      CellTags->"ButtonBoxOptions->{...}"]},
  "CounterBoxOptions->{...}"->{
    Cell[120139, 4310, 143, 2, 15, "Index",
      CellTags->"CounterBoxOptions->{...}"]},
  "CounterData"->{
    Cell[120285, 4314, 191, 6, 16, "Index",
      CellTags->"CounterData"]},
  "CounterStyle"->{
    Cell[120479, 4322, 194, 6, 16, "Index",
      CellTags->"CounterStyle"],
    Cell[120676, 4330, 193, 6, 16, "Index",
      CellTags->"CounterStyle"],
    Cell[120872, 4338, 192, 6, 16, "Index",
      CellTags->"CounterStyle"],
    Cell[121410, 4358, 187, 6, 16, "Index",
      CellTags->"CounterStyle"],
    Cell[121600, 4366, 190, 6, 16, "Index",
      CellTags->"CounterStyle"],
    Cell[121793, 4374, 189, 6, 16, "Index",
      CellTags->"CounterStyle"],
    Cell[122139, 4386, 197, 6, 16, "Index",
      CellTags->"CounterStyle"],
    Cell[122339, 4394, 200, 6, 16, "Index",
      CellTags->"CounterStyle"],
    Cell[122542, 4402, 199, 6, 16, "Index",
      CellTags->"CounterStyle"],
    Cell[139252, 5038, 206, 6, 70, "Index",
      CellTags->"CounterStyle"]},
  "CounterFunction"->{
    Cell[121067, 4346, 198, 6, 16, "Index",
      CellTags->"CounterFunction"],
    Cell[139461, 5046, 212, 6, 70, "Index",
      CellTags->"CounterFunction"]},
  "ValueBoxOptions->{...}"->{
    Cell[121268, 4354, 139, 2, 15, "Index",
      CellTags->"ValueBoxOptions->{...}"]},
  "OptionValueBoxOptions->{...}"->{
    Cell[121985, 4382, 151, 2, 15, "Index",
      CellTags->"OptionValueBoxOptions->{...}"]},
  "ErrorBoxOptions->{...}"->{
    Cell[122744, 4410, 139, 2, 15, "Index",
      CellTags->"ErrorBoxOptions->{...}"]},
  "AutoDelete"->{
    Cell[122886, 4414, 184, 6, 16, "Index",
      CellTags->"AutoDelete"],
    Cell[123408, 4434, 180, 6, 16, "Index",
      CellTags->"AutoDelete"],
    Cell[125732, 4526, 182, 6, 16, "Index",
      CellTags->"AutoDelete"],
    Cell[125917, 4534, 194, 6, 16, "Index",
      CellTags->"AutoDelete"],
    Cell[128810, 4650, 202, 6, 70, "Index",
      CellTags->"AutoDelete"],
    Cell[132086, 4770, 180, 6, 70, "Index",
      CellTags->"AutoDelete"],
    Cell[135639, 4902, 197, 6, 70, "Index",
      CellTags->"AutoDelete"]},
  "SaveAutoDelete"->{
    Cell[123073, 4422, 192, 6, 16, "Index",
      CellTags->"SaveAutoDelete"]},
  "FormBoxOptions->{...}"->{
    Cell[123268, 4430, 137, 2, 15, "Index",
      CellTags->"FormBoxOptions->{...}"]},
  "FractionBoxOptions->{...}"->{
    Cell[123591, 4442, 145, 2, 15, "Index",
      CellTags->"FractionBoxOptions->{...}"]},
  "FractionLine"->{
    Cell[123739, 4446, 194, 6, 16, "Index",
      CellTags->"FractionLine"]},
  "MultilineFunction"->{
    Cell[123936, 4454, 204, 6, 16, "Index",
      CellTags->"MultilineFunction"],
    Cell[127634, 4606, 196, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[129784, 4686, 202, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[130129, 4698, 196, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[130478, 4710, 201, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[130842, 4722, 196, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[131195, 4734, 203, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[132996, 4806, 208, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[133207, 4814, 213, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[133423, 4822, 208, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[133786, 4834, 206, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[133995, 4842, 211, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[134209, 4850, 206, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[134580, 4862, 208, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[134791, 4870, 213, 6, 70, "Index",
      CellTags->"MultilineFunction"],
    Cell[135007, 4878, 208, 6, 70, "Index",
      CellTags->"MultilineFunction"]},
  "FrameBoxOptions->{...}"->{
    Cell[124143, 4462, 139, 2, 15, "Index",
      CellTags->"FrameBoxOptions->{...}"]},
  "BoxFrame"->{
    Cell[124285, 4466, 180, 6, 16, "Index",
      CellTags->"BoxFrame"]},
  "BoxMargins"->{
    Cell[124468, 4474, 184, 6, 16, "Index",
      CellTags->"BoxMargins"]},
  "GridBoxOptions->{...}"->{
    Cell[124655, 4482, 137, 2, 15, "Index",
      CellTags->"GridBoxOptions->{...}"]},
  "GridFrame"->{
    Cell[124795, 4486, 180, 6, 16, "Index",
      CellTags->"GridFrame"],
    Cell[137877, 4990, 201, 6, 70, "Index",
      CellTags->"GridFrame"]},
  "GridFrameMargins"->{
    Cell[124978, 4494, 194, 6, 16, "Index",
      CellTags->"GridFrameMargins"],
    Cell[138081, 4998, 215, 6, 70, "Index",
      CellTags->"GridFrameMargins"]},
  "RowLines"->{
    Cell[125175, 4502, 178, 6, 16, "Index",
      CellTags->"RowLines"],
    Cell[137467, 4974, 199, 6, 70, "Index",
      CellTags->"RowLines"]},
  "ColumnLines"->{
    Cell[125356, 4510, 184, 6, 16, "Index",
      CellTags->"ColumnLines"],
    Cell[137669, 4982, 205, 6, 70, "Index",
      CellTags->"ColumnLines"]},
  "GridBaseline"->{
    Cell[125543, 4518, 186, 6, 16, "Index",
      CellTags->"GridBaseline"],
    Cell[135435, 4894, 201, 6, 70, "Index",
      CellTags->"GridBaseline"]},
  "RowSpacings"->{
    Cell[126114, 4542, 184, 6, 16, "Index",
      CellTags->"RowSpacings"],
    Cell[136042, 4918, 196, 6, 70, "Index",
      CellTags->"RowSpacings"]},
  "ColumnSpacings"->{
    Cell[126301, 4550, 190, 6, 16, "Index",
      CellTags->"ColumnSpacings"],
    Cell[136851, 4950, 205, 6, 70, "Index",
      CellTags->"ColumnSpacings"]},
  "ColumnWidths"->{
    Cell[126494, 4558, 186, 6, 16, "Index",
      CellTags->"ColumnWidths"],
    Cell[137263, 4966, 201, 6, 70, "Index",
      CellTags->"ColumnWidths"]},
  "RowAlignments"->{
    Cell[126683, 4566, 188, 6, 16, "Index",
      CellTags->"RowAlignments"],
    Cell[135839, 4910, 200, 6, 70, "Index",
      CellTags->"RowAlignments"]},
  "ColumnAlignments"->{
    Cell[126874, 4574, 194, 6, 16, "Index",
      CellTags->"ColumnAlignments"],
    Cell[136639, 4942, 209, 6, 70, "Index",
      CellTags->"ColumnAlignments"]},
  "RowsMinHeight"->{
    Cell[127071, 4582, 188, 6, 16, "Index",
      CellTags->"RowsMinHeight"],
    Cell[136436, 4934, 200, 6, 70, "Index",
      CellTags->"RowsMinHeight"]},
  "RowsEqual"->{
    Cell[127262, 4590, 180, 6, 16, "Index",
      CellTags->"RowsEqual"],
    Cell[136241, 4926, 192, 6, 70, "Index",
      CellTags->"RowsEqual"]},
  "ColumnsEqual"->{
    Cell[127445, 4598, 186, 6, 70, "Index",
      CellTags->"ColumnsEqual"],
    Cell[137059, 4958, 201, 6, 70, "Index",
      CellTags->"ColumnsEqual"]},
  "GridDefaultElement"->{
    Cell[127833, 4614, 201, 6, 70, "Index",
      CellTags->"GridDefaultElement"],
    Cell[135218, 4886, 214, 6, 70, "Index",
      CellTags->"GridDefaultElement"]},
  "InterpretationBoxOptions->{...}"->{
    Cell[128037, 4622, 157, 2, 70, "Index",
      CellTags->"InterpretationBoxOptions->{...}"]},
  "TagStyle"->{
    Cell[128197, 4626, 204, 6, 70, "Index",
      CellTags->"TagStyle"],
    Cell[128404, 4634, 198, 6, 70, "Index",
      CellTags->"TagStyle"],
    Cell[131539, 4746, 182, 6, 70, "Index",
      CellTags->"TagStyle"],
    Cell[131724, 4754, 176, 6, 70, "Index",
      CellTags->"TagStyle"]},
  "DeletionWarning"->{
    Cell[129015, 4658, 212, 6, 70, "Index",
      CellTags->"DeletionWarning"],
    Cell[132466, 4786, 190, 6, 70, "Index",
      CellTags->"DeletionWarning"]},
  "SyntaxForm"->{
    Cell[129230, 4666, 202, 6, 70, "Index",
      CellTags->"SyntaxForm"],
    Cell[132659, 4794, 180, 6, 70, "Index",
      CellTags->"SyntaxForm"]},
  "RadicalBoxOptions->{...}"->{
    Cell[129435, 4674, 143, 2, 70, "Index",
      CellTags->"RadicalBoxOptions->{...}"]},
  "ExponentPosition"->{
    Cell[129581, 4678, 200, 6, 70, "Index",
      CellTags->"ExponentPosition"]},
  "SqrtBoxOptions->{...}"->{
    Cell[129989, 4694, 137, 2, 70, "Index",
      CellTags->"SqrtBoxOptions->{...}"]},
  "SubscriptBoxOptions->{...}"->{
    Cell[130328, 4706, 147, 2, 70, "Index",
      CellTags->"SubscriptBoxOptions->{...}"]},
  "SubsuperscriptBoxOptions->{...}"->{
    Cell[130682, 4718, 157, 2, 70, "Index",
      CellTags->"SubsuperscriptBoxOptions->{...}"]},
  "SuperscriptBoxOptions->{...}"->{
    Cell[131041, 4730, 151, 2, 70, "Index",
      CellTags->"SuperscriptBoxOptions->{...}"]},
  "TagBoxOptions->{...}"->{
    Cell[131401, 4742, 135, 2, 70, "Index",
      CellTags->"TagBoxOptions->{...}"]},
  "StripWrapperBoxes"->{
    Cell[132269, 4778, 194, 6, 70, "Index",
      CellTags->"StripWrapperBoxes"]},
  "UnderScriptBoxOptions->{...}"->{
    Cell[132842, 4802, 151, 2, 70, "Index",
      CellTags->"UnderScriptBoxOptions->{...}"]},
  "OverScriptBoxOptions->{...}"->{
    Cell[133634, 4830, 149, 2, 70, "Index",
      CellTags->"OverScriptBoxOptions->{...}"]},
  "UnderoverscriptBoxOptions->{...}"->{
    Cell[134418, 4858, 159, 2, 70, "Index",
      CellTags->"UnderoverscriptBoxOptions->{...}"]},
  "CounterIncrements"->{
    Cell[138299, 5006, 228, 6, 70, "Index",
      CellTags->"CounterIncrements"]},
  "CounterAssignments"->{
    Cell[138530, 5014, 230, 6, 70, "Index",
      CellTags->"CounterAssignments"]},
  "InlineCounterIncrements"->{
    Cell[138763, 5022, 240, 6, 70, "Index",
      CellTags->"InlineCounterIncrements"]},
  "InlineCounterAssignments "->{
    Cell[139006, 5030, 243, 6, 70, "Index",
      CellTags->"InlineCounterAssignments "]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MasterIndexHeading", 140392, 5074},
  {"New (menu command)", 140504, 5077},
  {"Open (menu command)", 140611, 5080},
  {"Close (menu command)", 140720, 5083},
  {"Save (menu command)", 140829, 5086},
  {"Save As (menu command)", 140940, 5089},
  {"Save As Special (menu command)", 141062, 5092},
  {"Version 2 Notebook, Save As", 141189, 5095},
  {"Text, Save As", 141308, 5098},
  {"Cell Expression, Save As", 141424, 5101},
  {"Notebook Expression, Save As", 141555, 5104},
  {"Package Format, Save As", 141685, 5107},
  {"TeX, Save As", 141799, 5110},
  {"HTML, Save As", 141903, 5113},
  {"XML (XHTMLMathML), Save As", 142021, 5116},
  {"XML (NotebookML), Save As", 142151, 5119},
  {"XML (NotebookML+MathML), Save As", 142287, 5122},
  {"Open Special (menu command)", 142425, 5125},
  {"Import (menu command)", 142544, 5128},
  {"Send To (menu command)", 142658, 5131},
  {"Send Selection (menu command)", 142780, 5134},
  {"Palettes (menu command)", 142903, 5137},
  {"Notebooks (menu command)", 143021, 5140},
  {"Generate Palette from Selection (menu command)", 143162, 5143},
  {"Generate Notebook from Palette (menu command)", 143324, 5146},
  {"menucommands", 143452, 5149},
  {"Page Setup (menu command)", 143975, 5162},
  {"Printing Options (menu command)", 144110, 5165},
  {"Headers and Footers (menu command)", 144254, 5168},
  {"Print (menu command)", 144387, 5171},
  {"Print Selection (menu command)", 144508, 5174},
  {"Exit (menu command)", 144628, 5177},
  {"Quit (menu command)", 144737, 5180},
  {"Undo (menu command)", 144846, 5183},
  {"Cut (menu command)", 144954, 5186},
  {"Copy (menu command)", 145062, 5189},
  {"Paste (menu command)", 145172, 5192},
  {"Clear (menu command)", 145283, 5195},
  {"Copy As (menu command)", 145396, 5198},
  {"Paste As (menu command)", 145512, 5201},
  {"External Clipboard (menu command)", 145639, 5204},
  {"Save Selection As (menu command)", 145775, 5207},
  {"Select All (menu command)", 145903, 5210},
  {"Insert Object (menu command)", 146027, 5213},
  {"Motion (menu command)", 146147, 5216},
  {"Expression Input (menu command)", 146270, 5219},
  {"Insert Raw Expression (menu command)", 146408, 5222},
  {"Add Frame (menu command)", 146548, 5225},
  {"Add Interpretation (menu command)", 146685, 5228},
  {"Make 2D (menu command)", 146820, 5231},
  {"Check Balance (menu command)", 146942, 5234},
  {"Check Spelling (menu command)", 147071, 5237},
  {"Preferences (menu command)", 147198, 5240},
  {"Convert To (menu command)", 147321, 5243},
  {"InputForm, Convert To", 147439, 5246},
  {"OutputForm, Convert To", 147562, 5249},
  {"StandardForm, Convert To", 147688, 5252},
  {"TraditionalForm, Convert To", 147819, 5255},
  {"PostScript, Convert To", 147949, 5258},
  {"Bitmap, Convert To", 148070, 5261},
  {"PICT, ConvertTo", 148184, 5264},
  {"BitmapPICT, Convert To", 148302, 5267},
  {"Embedded PS PICT, ConvertTo", 148432, 5270},
  {"Metafile, Convert To", 148559, 5273},
  {"QuickTime, Convert To", 148681, 5276},
  {"Display As (menu command)", 148808, 5279},
  {"Text, Display As", 148921, 5282},
  {"InputForm, Display As", 149038, 5285},
  {"StandardForm, Display As", 149163, 5288},
  {"Traditional Form, Display As", 149295, 5291},
  {"Default Input Format Type (menu command)", 149443, 5294},
  {"Default Output Format Type (menu command)", 149596, 5297},
  {"Default Inline Format Type (menu command)", 149750, 5300},
  {"Cell Properties (menu command)", 149893, 5303},
  {"Cell Editable (menu command)", 150023, 5306},
  {"Cell Edit Duplicate (menu command)", 150165, 5309},
  {"Cell Evaluatable (menu commands)", 150311, 5312},
  {"Cell Active (menu command)", 150449, 5315},
  {"Initialization Cell (menu command)", 150589, 5318},
  {"Cell Grouping (menu command)", 150731, 5321},
  {"Group Cells (menu command)", 150857, 5324},
  {"Ungroup Cells (menu command)", 150991, 5327},
  {"Manual Grouping (menu command)", 151129, 5330},
  {"Automatic Grouping (menu command)", 151272, 5333},
  {"Open All Subgroups (menu command)", 151418, 5336},
  {"Close All Subgroups (menu command)", 151565, 5339},
  {"Open/Close Group (menu command)", 151710, 5342},
  {"Divide Cell (menu command)", 151847, 5345},
  {"Merge Cells (menu command)", 151971, 5348},
  {"Animate Selected Graphics (menu command)", 152109, 5351},
  {"Play Sound (menu command)", 152246, 5354},
  {"Rerender Graphics (menu command)", 152375, 5357},
  {"Rerender and Save Graphics (menu command)", 152520, 5360},
  {"Make Standard Size (menu command)", 152666, 5363},
  {"Align Selected Graphics (menu command)", 152809, 5366},
  {"Cell Size Statistics (menu command)", 152954, 5369},
  {"Style (menu command)", 153081, 5372},
  {"Screen Style Environment (menu command)", 153212, 5375},
  {"Printing Style Environment (menu command)", 153364, 5378},
  {"Show Expression (menu command)", 153507, 5381},
  {"Option Inspector (menu command)", 153640, 5384},
  {"Remove Options (menu command)", 153772, 5387},
  {"Style Sheet (menu command)", 153899, 5390},
  {"Edit Style Sheet (menu command)", 154028, 5393},
  {"Font (menu command)", 154150, 5396},
  {"Face (menu command)", 154260, 5399},
  {"Size (menu command)", 154370, 5402},
  {"Text Color (menu command)", 154486, 5405},
  {"Background Color (menu command)", 154614, 5408},
  {"Choose Font (menu command)", 154743, 5411},
  {"Text Alignment (menu command)", 154870, 5414},
  {"Text Justification (menu command)", 155004, 5417},
  {"Word Wrapping (menu command)", 155137, 5420},
  {"Cell Dingbat (menu command)", 155264, 5423},
  {"Horizontal Lines (menu command)", 155394, 5426},
  {"Show Ruler (menu command)", 155522, 5429},
  {"Show Toolbar (menu command)", 155647, 5432},
  {"Show Page Breaks (menu command)", 155778, 5435},
  {"Magnification (menu command)", 155910, 5438},
  {"Get Graphics Coordinates (menu command)", 156050, 5441},
  {"3D ViewPoint Selector (menu command)", 156198, 5444},
  {"Color Selector (menu command)", 156336, 5447},
  {"Record Sound (menu command)", 156465, 5450},
  {"Get File Path (menu command)", 156593, 5453},
  {"Create Table/Matrix/Palette (menu command)", 156736, 5456},
  {"Create Button (menu command)", 156879, 5459},
  {"Edit Button (menu command)", 157006, 5462},
  {"Create Hyperlink (menu command)", 157136, 5465},
  {"Create Automatic Numbering Object (menu command)", 157288, 5468},
  {"Create Value Display Object (menu command)", 157451, 5471},
  {"Convert Automatic Objects to Literal (menu command)", 157617, 5474},
  {"Copy Input from Above (menu command)", 157777, 5477},
  {"Copy Output from Above (menu command)", 157923, 5480},
  {"Start New Cell Below (menu command)", 158068, 5483},
  {"Complete Selection (menu command)", 158209, 5486},
  {"Make Template (menu command)", 158343, 5489},
  {"Evaluation (menu command)", 158469, 5492},
  {"Evaluate Cells (menu command)", 158596, 5495},
  {"Evaluate in Place (menu command)", 158738, 5498},
  {"Evaluate Next Input (menu command)", 158885, 5501},
  {"Evaluate In Subsession (menu command)", 159037, 5504},
  {"Evaluate Notebook (menu command)", 159187, 5507},
  {"Evaluate Initialization (menu command)", 159338, 5510},
  {"Enter Subsession (menu command)", 159488, 5513},
  {"Exit Subsession (menu command)", 159630, 5516},
  {"Remove from Evaluation Queue (menu command)", 159784, 5519},
  {"Interrupt Evaluation (menu command)", 159943, 5522},
  {"Abort Evaluation (menu command)", 160082, 5525},
  {"Start Kernel (menu command)", 160213, 5528},
  {"Quit Kernel (menu command)", 160339, 5531},
  {"Default Kernel (menu command)", 160467, 5534},
  {"Notebook's Kernel (menu command)", 160601, 5537},
  {"Kernel Configuration Options (menu command)", 160749, 5540},
  {"Show In/Out Names (menu command)", 160897, 5543},
  {"Delete All Output (menu command)", 161034, 5546},
  {"Find (menu command)", 161158, 5549},
  {"Enter Selection (menu command)", 161280, 5552},
  {"Find Next (menu command)", 161407, 5555},
  {"Find Previous (menu command)", 161532, 5558},
  {"Find in Cell Tags (menu command)", 161665, 5561},
  {"Replace and Find Again (menu command)", 161807, 5564},
  {"Replace All (menu command)", 162044, 5569},
  {"Open Selected (menu command)", 162171, 5572},
  {"Scroll to Selection (menu command)", 162306, 5575},
  {"Go Back (menu command)", 162435, 5578},
  {"Add/Remove Cell Tags (menu command)", 162565, 5581},
  {"Cell Tags (menu command)", 162697, 5584},
  {"Show Cell Tags (menu command)", 162823, 5587},
  {"Cell Tags from In/Out Names (menu command)", 162967, 5590},
  {"Make Index... (menu command)", 163110, 5593},
  {"Stack Windows (menu command)", 163239, 5596},
  {"Tile Windows Wide (menu command)", 163372, 5599},
  {"Tile Windows Tall (menu command)", 163509, 5602},
  {"Help Browser (menu command)", 163641, 5605},
  {"Find Selected Function (menu command)", 163778, 5608},
  {"Master Index (menu command)", 163915, 5611},
  {"InformationCenter (menu command)", 164047, 5614},
  {"Information Center on the Web (menu command)", 164196, 5617},
  {"Wolfram Research on the Web (menu command)", 164355, 5620},
  {"Registration (menu command)", 164497, 5623},
  {"Why the Beep (menu command)", 164624, 5626},
  {"Startup Palette (menu command)", 164754, 5629},
  {"About Mathematica (menu command)", 164889, 5632},
  {"X Environment Information (menu command)", 165034, 5635},
  {"Rebuild Help Index (menu command)", 165180, 5638},
  {"Keyboard shortcuts", 165304, 5641},
  {"Style sheets", 165408, 5644},
  {"Environments", 165950, 5657},
  {"Tutorial", 166410, 5668},
  {"Slide Show", 166777, 5677},
  {"10 Minute Tutorial on Mathematica", 167167, 5686},
  {"NotebookDirectory", 167541, 5695},
  {"NotebookPath", 167643, 5698},
  {"PalettePath", 167739, 5701},
  {"AutoOpenPalettes", 167839, 5704},
  {"AutoOpenNotebooks", 167945, 5707},
  {"StyleSheetPath", 168049, 5710},
  {"DefaultNotebook", 168151, 5713},
  {"DefaultStyleDefinitions", 168262, 5716},
  {"PreferencesPath", 168373, 5719},
  {"ConfigurationPath", 168478, 5722},
  {"SystemHelpPath", 168582, 5725},
  {"AddOnHelpPath", 168682, 5728},
  {"AutoloadPath", 168780, 5731},
  {"SpellingDictionariesPath", 168889, 5734},
  {"CharacterEncodingsPath", 169008, 5737},
  {"ImportAutoReplacements", 169125, 5740},
  {"ExportAutoReplacements", 169242, 5743},
  {"Language", 169345, 5746},
  {"ExternalDataCharacterEncoding", 169455, 5749},
  {"StartupSound", 169569, 5752},
  {"MultilaunchWarning", 169672, 5755},
  {"ScreenRectangle", 169778, 5758},
  {"FrontEndStackSize", 169883, 5761},
  {"XPasteFrom", 169983, 5764},
  {"EvaluatorNames", 170080, 5767},
  {"NotebooksMenu", 170180, 5770},
  {"FontSubstitutions", 170283, 5773},
  {"DefaultFontProperties", 170394, 5776},
  {"BoxFormFormatTypes", 170506, 5779},
  {"WarningAction", 170610, 5782},
  {"ErrorAction", 170707, 5785},
  {"ConsoleMessageAction", 170811, 5788},
  {"KernelMessageAction", 170923, 5791},
  {"ExplainBeepHelp", 171030, 5794},
  {"MathMLPasteWarning", 171136, 5797},
  {"InsufficientVersionWarning", 171253, 5800},
  {"IgnoreTagBoxDeletionWarning", 171379, 5803},
  {"TraditionalFormEvaluationWarning", 171511, 5806},
  {"AllowDisablingWarnings", 171638, 5809},
  {"NotebookAutoSave", 171749, 5812},
  {"ClosingAutoSave", 171853, 5815},
  {"IncludeFileExtension", 171961, 5818},
  {"AutoGeneratedPackage", 172074, 5821},
  {"Editable", 172175, 5824},
  {"Saveable", 172264, 5827},
  {"ScreenStyleEnvironment", 172367, 5830},
  {"PrintingStyleEnvironment", 172486, 5833},
  {"ShowPageBreaks", 172597, 5836},
  {"WindowToolbars", 172698, 5839},
  {"RulerUnits", 172795, 5842},
  {"NotebookBackground", 172896, 5845},
  {"Magnification", 173000, 5848},
  {"Evaluator", 173250, 5855},
  {"EvaluationCompletionAction", 173431, 5860},
  {"PrintAction", 173541, 5863},
  {"OutputAutoOverwrite", 173644, 5866},
  {"InitializationCellEvaluation", 173764, 5869},
  {"InitializationCellWarning", 173890, 5872},
  {"Selectable", 173998, 5875},
  {"Deletable", 174388, 5886},
  {"CellGrouping", 174628, 5893},
  {"PageWidth", 174722, 5896},
  {"WindowSize", 175252, 5911},
  {"WindowMargins", 175496, 5918},
  {"WindowFrame", 176594, 5947},
  {"WindowElements", 176692, 5950},
  {"WindowFrameElements", 176798, 5953},
  {"WindowClickSelect", 176907, 5956},
  {"WindowFloating", 177011, 5959},
  {"WindowMovable", 177111, 5962},
  {"WindowTitle", 177208, 5965},
  {"Visible", 177299, 5968},
  {"PrintingCopies", 177393, 5971},
  {"PrintingStartingPageNumber", 177506, 5974},
  {"PrintingPageRange", 177622, 5977},
  {"PageHeaders", 177723, 5980},
  {"PageFooters", 177818, 5983},
  {"PageHeaderLines", 177917, 5986},
  {"PageFooterLines", 178020, 5989},
  {"SafeFileSave", 178120, 5992},
  {"SafeFileOpen", 178217, 5995},
  {"DoubleBuffer", 178314, 5998},
  {"ColorPalette", 178411, 6001},
  {"BackgroundPostScriptRendering", 178525, 6004},
  {"RealTimeMarginAdjustment", 178651, 6007},
  {"RealTimeWindowMove", 178766, 6010},
  {"RealTimeWindowResize", 178877, 6013},
  {"ShortBoxForm", 178982, 6016},
  {"Format", 179073, 6019},
  {"Ellipsis", 179160, 6022},
  {"MultiPageContinuation", 179262, 6025},
  {"PageSeparator", 179369, 6028},
  {"SectionSeparator", 179471, 6031},
  {"MainEntry", 179569, 6034},
  {"MainPage", 179659, 6037},
  {"CellFrame", 179749, 6040},
  {"CellDingbat", 179915, 6045},
  {"CellBackground", 180013, 6048},
  {"ShowCellBracket", 180115, 6051},
  {"ShowSelection", 180216, 6054},
  {"ShowGroupOpenCloseIcon", 180324, 6057},
  {"ShowClosedCellArea", 180437, 6060},
  {"ShowShortBoxForm", 180544, 6063},
  {"CellDisplayCache", 180649, 6066},
  {"CellMargins", 180749, 6069},
  {"Active", 180839, 6072},
  {"CellEditDuplicate", 181076, 6079},
  {"Evaluatable", 181177, 6082},
  {"Copyable", 181269, 6085},
  {"CellOpen", 181358, 6088},
  {"CellGroupingRules", 181456, 6091},
  {"ConversionRules", 181561, 6094},
  {"TaggingRules", 181661, 6097},
  {"CellHorizontalScrolling", 181769, 6100},
  {"StyleMenuListing", 181881, 6103},
  {"ButtonStyleMenuListing", 181992, 6106},
  {"CounterStyleMenuListing", 182110, 6109},
  {"FormatTypeAutoConvert", 182227, 6112},
  {"PageBreakAbove", 182335, 6115},
  {"PageBreakWithin", 182437, 6118},
  {"PageBreakBelow", 182539, 6121},
  {"GroupPageBreakWithin", 182646, 6124},
  {"InitializationCell", 182757, 6127},
  {"CellEvaluationDuplicate", 182871, 6130},
  {"GeneratedCell", 182980, 6133},
  {"CellAutoOverwrite", 183083, 6136},
  {"CellLabel", 183182, 6139},
  {"ShowCellLabel", 183277, 6142},
  {"CellLabelPositioning", 183383, 6145},
  {"CellLabelAutoDelete", 183495, 6148},
  {"CellLabelMargins", 183603, 6151},
  {"CellFrameMargins", 183708, 6154},
  {"CellFrameColor", 183811, 6157},
  {"CellFrameLabelMargins", 183919, 6160},
  {"CellFrameLabels", 184028, 6163},
  {"ShowCellTags", 184128, 6166},
  {"CellSize", 184221, 6169},
  {"CellBaseline", 184314, 6172},
  {"DefaultNewCellStyle", 184418, 6175},
  {"DefaultNewInlineCellStyle", 184535, 6178},
  {"DefaultDuplicateCellStyle", 184658, 6181},
  {"DefaultFormatType", 184773, 6184},
  {"DefaultInlineFormatType", 184886, 6187},
  {"FormatType", 184992, 6190},
  {"AutoIndent", 185529, 6205},
  {"InputAliases", 185624, 6208},
  {"InputAutoReplacements", 185730, 6211},
  {"DelimiterFlashTime", 185842, 6214},
  {"ShowCursorTracker", 185950, 6217},
  {"ShowAutoStyles", 186054, 6220},
  {"StructuredSelection", 186160, 6223},
  {"StyleBoxAutoDelete", 186270, 6226},
  {"DragAndDrop", 186372, 6229},
  {"ShowSpecialCharacters", 186477, 6232},
  {"AllowInlineCells", 186587, 6235},
  {"PasteBoxFormInlineCells", 186699, 6238},
  {"TwoByteSyntaxCharacterAutoReplacement", 186832, 6241},
  {"CursorTrackerParameters", 186965, 6244},
  {"AutoStyleOptions", 187077, 6247},
  {"FontSize", 187174, 6250},
  {"FontFamily", 187265, 6253},
  {"FontWeight", 187358, 6256},
  {"FontSlant", 187450, 6259},
  {"FontTracking", 187544, 6262},
  {"FontColor", 187638, 6265},
  {"FontOptionsBackground", 187741, 6268},
  {"CharacterEncoding", 187852, 6271},
  {"TextAlignment", 188036, 6276},
  {"TextJustification", 188139, 6279},
  {"Hyphenation", 188240, 6282},
  {"TabFilling", 188334, 6285},
  {"LineSpacing", 188428, 6288},
  {"ParagraphSpacing", 188528, 6291},
  {"ParagraphIndent", 188632, 6294},
  {"TabSpacings", 188731, 6297},
  {"AutoItalicWords", 188830, 6300},
  {"LanguageCategory", 188934, 6303},
  {"DefaultNaturalLanguage", 189045, 6306},
  {"AutoSpacing", 189151, 6309},
  {"ShowContents", 189247, 6312},
  {"ScriptSizeMultipliers", 189353, 6315},
  {"ScriptMinSize", 189460, 6318},
  {"ScriptLevel", 189557, 6321},
  {"ShowStringCharacters", 189661, 6324},
  {"NumberMarks", 189765, 6327},
  {"PrintPrecision", 189863, 6330},
  {"NumberMultiplier", 189966, 6333},
  {"LimitsPositioning", 190072, 6336},
  {"LimitsPositioningTokens", 190185, 6339},
  {"ScriptBaselineShifts", 190301, 6342},
  {"SingleLetterItalics", 190413, 6345},
  {"TraditionalFunctionNotation", 190532, 6348},
  {"DelimiterMatching", 190649, 6351},
  {"ZeroWidthTimes", 190753, 6354},
  {"SpanMinSize", 190851, 6357},
  {"SpanMaxSize", 190946, 6360},
  {"SpanSymmetric", 191043, 6363},
  {"SpanLineThickness", 191146, 6366},
  {"SpanCharacterRounding", 191257, 6369},
  {"SpanAdjustments", 191366, 6372},
  {"LineBreakWithin", 191469, 6375},
  {"LineIndent", 191567, 6378},
  {"IndentMaxFraction", 191667, 6381},
  {"LinebreakAdjustments", 191777, 6384},
  {"AspectRatioFixed", 191886, 6387},
  {"ImageSize", 191984, 6390},
  {"ImageMargins", 192078, 6393},
  {"ImageRegion", 192174, 6396},
  {"AnimationDisplayTime", 192278, 6399},
  {"AnimationCycleOffset", 192391, 6402},
  {"AnimationCycleRepetitions", 192509, 6405},
  {"DrawDummyGraphics", 192624, 6408},
  {"RenderIncrementally", 192733, 6411},
  {"RenderFilledAreas", 192842, 6414},
  {"RenderLines", 192943, 6417},
  {"RenderThickness", 193042, 6420},
  {"RenderSystemColors", 193148, 6423},
  {"ObjectDithering", 193254, 6426},
  {"RasterDithering", 193357, 6429},
  {"ImageHalftoneDensity", 193465, 6432},
  {"ImageHalftoneAngle", 193576, 6435},
  {"ImageCacheDepth", 193682, 6438},
  {"ButtonFunction", 193784, 6441},
  {"ButtonSource", 193962, 6446},
  {"ButtonEvaluator", 194139, 6451},
  {"ButtonData", 194317, 6456},
  {"ButtonStyle", 194486, 6461},
  {"ButtonFrame", 194657, 6466},
  {"ButtonBackground", 194833, 6471},
  {"ButtonMargins", 195016, 6476},
  {"ButtonExpandable", 195196, 6481},
  {"ButtonMinHeight", 195381, 6486},
  {"ButtonNote", 195559, 6491},
  {"PrivatePaths->{...}", 195736, 6496},
  {"TextResources", 195841, 6499},
  {"AFM", 196007, 6504},
  {"Fonts", 196088, 6507},
  {"OpenSpecialOptions->{...}", 196191, 6510},
  {"ReadingType", 196300, 6513},
  {"ListAllFileTypes", 196400, 6516},
  {"ToPostScriptOptions->{...}", 196515, 6519},
  {"RemoveColorFromBitmaps", 196636, 6522},
  {"IgnoreEmbeddedPostScript", 196755, 6525},
  {"BitsPerPixel", 196864, 6528},
  {"ImportTypesetOptions->{...}", 197052, 6533},
  {"ExportMultipleCellsOptions->{...}", 197185, 6536},
  {"IncludeCellLabels", 197308, 6539},
  {"IncludeCellTags", 197818, 6552},
  {"CellBreaks", 198311, 6565},
  {"CMYKColorGeneration", 198783, 6578},
  {"ExportPostScriptOptions->{...}", 199320, 6591},
  {"ExportNativeGraphicsOptions->{...}", 199457, 6594},
  {"ExportTypesetOptions->{...}", 199591, 6597},
  {"ExportQuickTimeOptions->{...}", 199720, 6600},
  {"SaveAsSpecialOptions->{...}", 199849, 6603},
  {"FindSettings->{...}", 199968, 6606},
  {"FindString", 200070, 6609},
  {"ReplaceString", 200166, 6612},
  {"IgnoreCase", 200262, 6615},
  {"Wraparound", 200355, 6618},
  {"EditCellTagsSettings->{...}", 200465, 6621},
  {"ViewPointSelectorSettings->{...}", 200597, 6624},
  {"CoordinateSystem", 200718, 6627},
  {"TemplateText", 200819, 6630},
  {"ViewPoint", 200913, 6633},
  {"ColorSelectorSettings->{...}", 201023, 6636},
  {"Color", 201129, 6639},
  {"GridCreationSettings->{...}", 201304, 6644},
  {"Rows", 201408, 6647},
  {"Columns", 201492, 6650},
  {"DrawRowLines", 201584, 6653},
  {"DrawColumnLines", 201684, 6656},
  {"DrawFrame", 201781, 6659},
  {"Type", 201867, 6662},
  {"Fill", 201948, 6665},
  {"DiagonalFill", 202037, 6668},
  {"FillText", 202130, 6671},
  {"DiagonalFillText", 202227, 6674},
  {"NotebookStatisticsSettings->{...}", 202349, 6677},
  {"Domain", 202461, 6680},
  {"IncludeSharedData", 202557, 6683},
  {"OptionInspectorSettings->{...}", 202677, 6686},
  {"Scope", 202785, 6689},
  {"ViewAs", 202869, 6692},
  {"EditButtonSettings->{...}", 202973, 6695},
  {"BackgroundTasksSettings->{...}", 203101, 6698},
  {"InterruptSettings->{...}", 203228, 6701},
  {"InputSettings->{...}", 203345, 6704},
  {"HelpBrowserSettings->{...}", 203464, 6707},
  {"ErrorsDialogSettings->{...}", 203590, 6710},
  {"StyleNameDialogSettings->{...}", 203720, 6713},
  {"Style", 203828, 6716},
  {"FileNameDialogSettings->{...}", 203935, 6719},
  {"StringFormat", 204049, 6722},
  {"NotebookConvertSettings->{...}", 204164, 6725},
  {"InputToStandardForm", 204286, 6728},
  {"OutputToStandardForm", 204398, 6731},
  {"PreserveStyleSheet", 204509, 6734},
  {"GenerateBitmapCaches", 204620, 6737},
  {"ScrollingOptions->{...}", 204736, 6740},
  {"PagewiseScrolling", 204849, 6743},
  {"PagewiseDisplay", 204954, 6746},
  {"RealTimeScrolling", 205059, 6749},
  {"JumpScrolling", 205162, 6752},
  {"VerticalScrollRange", 205267, 6755},
  {"HorizontalScrollRange", 205380, 6758},
  {"SpeedParameters", 205489, 6761},
  {"PrintingOptions->{...}", 205600, 6764},
  {"PaperOrientation", 205712, 6767},
  {"PrintCellBrackets", 205819, 6770},
  {"PrintSelectionHighlighting", 205936, 6773},
  {"PrintRegistrationMarks", 206058, 6776},
  {"PrintMultipleHorizontalPages", 206182, 6779},
  {"FirstPageHeader", 206299, 6782},
  {"FirstPageFooter", 206403, 6785},
  {"CellBackgroundHalftoneAngle", 206519, 6788},
  {"FacingPages", 207643, 6813},
  {"FirstPageFace", 207741, 6816},
  {"GraphicsPrintingFormat", 207850, 6819},
  {"CellBackgroundHalftoneDensity", 207975, 6822},
  {"PageHeaderMargins", 208095, 6825},
  {"PageFooterMargins", 208203, 6828},
  {"IndexCreationOptions->{...}", 208321, 6831},
  {"Thickness", 208431, 6834},
  {"CellBracketOptions->{...}", 209205, 6855},
  {"Margins", 209311, 6858},
  {"Widths", 209398, 6861},
  {"CellElementSpacings->{...}", 209504, 6864},
  {"CellMinHeight", 209617, 6867},
  {"ClosedCellHeight", 209720, 6870},
  {"ClosedGroupTopMargin", 209830, 6873},
  {"PrivateCellOptions->{...}", 209949, 6876},
  {"PrivateEvaluationOptions->{...}", 210079, 6879},
  {"OutputFormPageWidth\" ", 210206, 6882},
  {"StoreInputForm\" ", 210319, 6885},
  {"CommonDefaultFormatTypes->{...}", 210441, 6888},
  {"Text", 210550, 6891},
  {"Input", 210633, 6894},
  {"Output", 210718, 6897},
  {"TextInline", 210808, 6900},
  {"OutputInline", 210904, 6903},
  {"InputInline", 211001, 6906},
  {"FontVariations->{...}", 211107, 6909},
  {"Underline", 211211, 6912},
  {"Outline", 211301, 6915},
  {"Shadow", 211388, 6918},
  {"StrikeThrough", 211481, 6921},
  {"Masked", 211574, 6924},
  {"CompatibilityType", 211742, 6929},
  {"FontProperties->{...}", 211854, 6932},
  {"FontSerifed", 211960, 6935},
  {"FontMonospaced", 212059, 6938},
  {"PrivateFontOptions->{...}", 212172, 6941},
  {"FontPostScriptName", 212289, 6944},
  {"FontType", 212389, 6947},
  {"OperatorSubstitution", 212491, 6950},
  {"HyphenationOptions->{...}", 212695, 6955},
  {"HyphenationFreeZone", 212813, 6958},
  {"HyphenationCharacter", 212926, 6961},
  {"HyphenationMinLengths", 213041, 6964},
  {"SpellingOptions->{...}", 213158, 6967},
  {"AlwaysStop", 213264, 6970},
  {"AlwaysSkip", 213358, 6973},
  {"WordSplitting", 213455, 6976},
  {"SpellingDictionaries->{...}", 213569, 6979},
  {"CorrectWords", 213682, 6982},
  {"IncorrectWords", 213782, 6985},
  {"Suggestions", 213881, 6988},
  {"AdjustmentBoxOptions->{...}", 213993, 6991},
  {"AdjustmentBoxOptions", 214114, 6994},
  {"BoxBaselineShift", 214224, 6997},
  {"ButtonBoxOptions->{...}", 214337, 7000},
  {"CounterBoxOptions->{...}", 214458, 7003},
  {"CounterData", 214567, 7006},
  {"CounterStyle", 214664, 7009},
  {"CounterFunction", 215458, 7030},
  {"ValueBoxOptions->{...}", 215649, 7035},
  {"OptionValueBoxOptions->{...}", 215773, 7038},
  {"ErrorBoxOptions->{...}", 215897, 7041},
  {"AutoDelete", 216003, 7044},
  {"SaveAutoDelete", 216551, 7059},
  {"FormBoxOptions->{...}", 216660, 7062},
  {"FractionBoxOptions->{...}", 216780, 7065},
  {"FractionLine", 216891, 7068},
  {"MultilineFunction", 216994, 7071},
  {"FrameBoxOptions->{...}", 218337, 7104},
  {"BoxFrame", 218441, 7107},
  {"BoxMargins", 218533, 7110},
  {"GridBoxOptions->{...}", 218638, 7113},
  {"GridFrame", 218742, 7116},
  {"GridFrameMargins", 218915, 7121},
  {"RowLines", 219094, 7126},
  {"ColumnLines", 219260, 7131},
  {"GridBaseline", 219433, 7136},
  {"RowSpacings", 219607, 7141},
  {"ColumnSpacings", 219782, 7146},
  {"ColumnWidths", 219961, 7151},
  {"RowAlignments", 220137, 7156},
  {"ColumnAlignments", 220318, 7161},
  {"RowsMinHeight", 220502, 7166},
  {"RowsEqual", 220676, 7171},
  {"ColumnsEqual", 220845, 7176},
  {"GridDefaultElement", 221026, 7181},
  {"InterpretationBoxOptions->{...}", 221232, 7186},
  {"TagStyle", 221345, 7189},
  {"DeletionWarning", 221661, 7198},
  {"SyntaxForm", 221840, 7203},
  {"RadicalBoxOptions->{...}", 222023, 7208},
  {"ExponentPosition", 222137, 7211},
  {"SqrtBoxOptions->{...}", 222248, 7214},
  {"SubscriptBoxOptions->{...}", 222369, 7217},
  {"SubsuperscriptBoxOptions->{...}", 222500, 7220},
  {"SuperscriptBoxOptions->{...}", 222633, 7223},
  {"TagBoxOptions->{...}", 222755, 7226},
  {"StripWrapperBoxes", 222866, 7229},
  {"UnderScriptBoxOptions->{...}", 222985, 7232},
  {"OverScriptBoxOptions->{...}", 223114, 7235},
  {"UnderoverscriptBoxOptions->{...}", 223247, 7238},
  {"CounterIncrements", 223370, 7241},
  {"CounterAssignments", 223479, 7244},
  {"InlineCounterIncrements", 223594, 7247},
  {"InlineCounterAssignments ", 223716, 7250}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 67, 1, 41, "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[CellGroupData[{
Cell[1846, 56, 39, 0, 36, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[1910, 60, 61, 1, 70, "SubsubsectionIcon"],
Cell[1974, 63, 144, 5, 70, "Index",
  CellTags->"New (menu command)"],
Cell[2121, 70, 148, 5, 70, "Index",
  CellTags->"Open (menu command)"],
Cell[2272, 77, 148, 5, 70, "Index",
  CellTags->"Close (menu command)"],
Cell[2423, 84, 146, 5, 70, "Index",
  CellTags->"Save (menu command)"],
Cell[2572, 91, 155, 5, 70, "Index",
  CellTags->"Save As (menu command)"],
Cell[2730, 98, 171, 5, 70, "Index",
  CellTags->"Save As Special (menu command)"],
Cell[2904, 105, 231, 6, 70, "IndexSubentry",
  CellTags->"Version 2 Notebook, Save As"],
Cell[3138, 113, 189, 6, 70, "IndexSubentry",
  CellTags->"Text, Save As"],
Cell[3330, 121, 222, 6, 70, "IndexSubentry",
  CellTags->"Cell Expression, Save As"],
Cell[3555, 129, 234, 6, 70, "IndexSubentry",
  CellTags->"Notebook Expression, Save As"],
Cell[3792, 137, 219, 6, 70, "IndexSubentry",
  CellTags->"Package Format, Save As"],
Cell[4014, 145, 186, 6, 70, "IndexSubentry",
  CellTags->"TeX, Save As"],
Cell[4203, 153, 189, 6, 70, "IndexSubentry",
  CellTags->"HTML, Save As"],
Cell[4395, 161, 224, 6, 70, "IndexSubentry",
  CellTags->"XML (XHTMLMathML), Save As"],
Cell[4622, 169, 219, 6, 70, "IndexSubentry",
  CellTags->"XML (NotebookML), Save As"],
Cell[4844, 177, 240, 6, 70, "IndexSubentry",
  CellTags->"XML (NotebookML+MathML), Save As"],
Cell[5087, 185, 165, 5, 70, "Index",
  CellTags->"Open Special (menu command)"],
Cell[5255, 192, 179, 6, 70, "Index",
  CellTags->"Import (menu command)"],
Cell[5437, 200, 154, 5, 70, "Index",
  CellTags->"Send To (menu command)"],
Cell[5594, 207, 168, 5, 70, "Index",
  CellTags->"Send Selection (menu command)"],
Cell[5765, 214, 154, 5, 70, "Index",
  CellTags->"Palettes (menu command)"],
Cell[5922, 221, 156, 5, 70, "Index",
  CellTags->"Notebooks (menu command)"],
Cell[6081, 228, 200, 5, 70, "Index",
  CellTags->"Generate Palette from Selection (menu command)"],
Cell[6284, 235, 198, 5, 70, "Index",
  CellTags->"Generate Notebook from Palette (menu command)"],
Cell[6485, 242, 138, 5, 70, "Index",
  CellTags->"menucommands"],
Cell[6626, 249, 218, 6, 70, "IndexSubentry",
  CellTags->"Page Setup (menu command)"],
Cell[6847, 257, 236, 6, 70, "IndexSubentry",
  CellTags->"Printing Options (menu command)"],
Cell[7086, 265, 245, 6, 70, "IndexSubentry",
  CellTags->"Headers and Footers (menu command)"],
Cell[7334, 273, 151, 5, 70, "Index",
  CellTags->"Print (menu command)"],
Cell[7488, 280, 168, 5, 70, "Index",
  CellTags->"Print Selection (menu command)"],
Cell[7659, 287, 146, 5, 70, "Index",
  CellTags->"Exit (menu command)"],
Cell[7808, 294, 170, 6, 70, "Index",
  CellTags->"Quit (menu command)"]
}, Closed]],

Cell[CellGroupData[{
Cell[8015, 305, 61, 1, 70, "SubsubsectionIcon"],
Cell[8079, 308, 146, 5, 70, "Index",
  CellTags->"Undo (menu command)"],
Cell[8228, 315, 144, 5, 70, "Index",
  CellTags->"Cut (menu command)"],
Cell[8375, 322, 146, 5, 70, "Index",
  CellTags->"Copy (menu command)"],
Cell[8524, 329, 148, 5, 70, "Index",
  CellTags->"Paste (menu command)"],
Cell[8675, 336, 148, 5, 70, "Index",
  CellTags->"Clear (menu command)"],
Cell[8826, 343, 152, 5, 70, "Index",
  CellTags->"Copy As (menu command)"],
Cell[8981, 350, 154, 5, 70, "Index",
  CellTags->"Paste As (menu command)"],
Cell[9138, 357, 174, 5, 70, "Index",
  CellTags->"External Clipboard (menu command)"],
Cell[9315, 364, 171, 5, 70, "Index",
  CellTags->"Save Selection As (menu command)"],
Cell[9489, 371, 158, 5, 70, "Index",
  CellTags->"Select All (menu command)"],
Cell[9650, 378, 164, 5, 70, "Index",
  CellTags->"Insert Object (menu command)"],
Cell[9817, 385, 150, 5, 70, "Index",
  CellTags->"Motion (menu command)"],
Cell[9970, 392, 170, 5, 70, "Index",
  CellTags->"Expression Input (menu command)"],
Cell[10143, 399, 191, 5, 70, "IndexSubentry",
  CellTags->"Insert Raw Expression (menu command)"],
Cell[10337, 406, 134, 2, 70, "IndexSubentry",
  CellTags->"Add Frame (menu command)"],
Cell[10474, 410, 155, 2, 70, "IndexSubentry",
  CellTags->"Add Interpretation (menu command)"],
Cell[10632, 414, 152, 5, 70, "Index",
  CellTags->"Make 2D (menu command)"],
Cell[10787, 421, 164, 5, 70, "Index",
  CellTags->"Check Balance (menu command)"],
Cell[10954, 428, 209, 6, 70, "Index",
  CellTags->"Check Spelling (menu command)"],
Cell[11166, 436, 197, 6, 70, "Index",
  CellTags->"Preferences (menu command)"]
}, Closed]],

Cell[CellGroupData[{
Cell[11400, 447, 61, 1, 70, "SubsubsectionIcon"],
Cell[11464, 450, 158, 5, 70, "Index",
  CellTags->"Convert To (menu command)"],
Cell[11625, 457, 214, 6, 70, "IndexSubentry",
  CellTags->"InputForm, Convert To"],
Cell[11842, 465, 318, 9, 70, "IndexSubentry",
  CellTags->"OutputForm, Convert To"],
Cell[12163, 476, 322, 9, 70, "IndexSubentry",
  CellTags->"StandardForm, Convert To"],
Cell[12488, 487, 433, 12, 70, "IndexSubentry",
  CellTags->"TraditionalForm, Convert To"],
Cell[12924, 501, 418, 12, 70, "IndexSubentry",
  CellTags->"PostScript, Convert To"],
Cell[13345, 515, 406, 12, 70, "IndexSubentry",
  CellTags->"Bitmap, Convert To"],
Cell[13754, 529, 399, 12, 70, "IndexSubentry",
  CellTags->"PICT, ConvertTo"],
Cell[14156, 543, 418, 12, 70, "IndexSubentry",
  CellTags->"BitmapPICT, Convert To"],
Cell[14577, 557, 234, 6, 70, "IndexSubentry",
  CellTags->"Embedded PS PICT, ConvertTo"],
Cell[14814, 565, 412, 12, 70, "IndexSubentry",
  CellTags->"Metafile, Convert To"],
Cell[15229, 579, 415, 12, 70, "IndexSubentry",
  CellTags->"QuickTime, Convert To"],
Cell[15647, 593, 158, 5, 70, "Index",
  CellTags->"Display As (menu command)"],
Cell[15808, 600, 198, 6, 70, "IndexSubentry",
  CellTags->"Text, Display As"],
Cell[16009, 608, 214, 6, 70, "IndexSubentry",
  CellTags->"InputForm, Display As"],
Cell[16226, 616, 223, 6, 70, "IndexSubentry",
  CellTags->"StandardForm, Display As"],
Cell[16452, 624, 233, 6, 70, "IndexSubentry",
  CellTags->"Traditional Form, Display As"],
Cell[16688, 632, 188, 5, 70, "Index",
  CellTags->"Default Input Format Type (menu command)"],
Cell[16879, 639, 190, 5, 70, "Index",
  CellTags->"Default Output Format Type (menu command)"],
Cell[17072, 646, 250, 6, 70, "Index",
  CellTags->"Default Inline Format Type (menu command)"],
Cell[17325, 654, 168, 5, 70, "Index",
  CellTags->"Cell Properties (menu command)"],
Cell[17496, 661, 198, 6, 70, "IndexSubentry",
  CellTags->"menucommands"],
Cell[17697, 669, 222, 6, 70, "IndexSubentry",
  CellTags->"Cell Editable (menu command)"],
Cell[17922, 677, 240, 6, 70, "IndexSubentry",
  CellTags->"Cell Edit Duplicate (menu command)"],
Cell[18165, 685, 232, 6, 70, "IndexSubentry",
  CellTags->"Cell Evaluatable (menu commands)"],
Cell[18400, 693, 216, 6, 70, "IndexSubentry",
  CellTags->"Cell Active (menu command)"],
Cell[18619, 701, 240, 6, 70, "IndexSubentry",
  CellTags->"Initialization Cell (menu command)"],
Cell[18862, 709, 210, 6, 70, "Index",
  CellTags->"Cell Grouping (menu command)"],
Cell[19075, 717, 214, 6, 70, "IndexSubentry",
  CellTags->"Group Cells (menu command)"],
Cell[19292, 725, 220, 6, 70, "IndexSubentry",
  CellTags->"Ungroup Cells (menu command)"],
Cell[19515, 733, 226, 6, 70, "IndexSubentry",
  CellTags->"Manual Grouping (menu command)"],
Cell[19744, 741, 235, 6, 70, "IndexSubentry",
  CellTags->"Automatic Grouping (menu command)"],
Cell[19982, 749, 235, 6, 70, "IndexSubentry",
  CellTags->"Open All Subgroups (menu command)"],
Cell[20220, 757, 238, 6, 70, "IndexSubentry",
  CellTags->"Close All Subgroups (menu command)"],
Cell[20461, 765, 229, 6, 70, "IndexSubentry",
  CellTags->"Open/Close Group (menu command)"],
Cell[20693, 773, 160, 5, 70, "Index",
  CellTags->"Divide Cell (menu command)"],
Cell[20856, 780, 160, 5, 70, "Index",
  CellTags->"Merge Cells (menu command)"],
Cell[21019, 787, 188, 5, 70, "Index",
  CellTags->"Animate Selected Graphics (menu command)"],
Cell[21210, 794, 158, 5, 70, "Index",
  CellTags->"Play Sound (menu command)"],
Cell[21371, 801, 172, 5, 70, "Index",
  CellTags->"Rerender Graphics (menu command)"],
Cell[21546, 808, 190, 5, 70, "Index",
  CellTags->"Rerender and Save Graphics (menu command)"],
Cell[21739, 815, 174, 5, 70, "Index",
  CellTags->"Make Standard Size (menu command)"],
Cell[21916, 822, 187, 5, 70, "Index",
  CellTags->"Align Selected Graphics (menu command)"],
Cell[22106, 829, 181, 5, 70, "Index",
  CellTags->"Cell Size Statistics (menu command)"]
}, Closed]],

Cell[CellGroupData[{
Cell[22324, 839, 63, 1, 70, "SubsubsectionIcon"],
Cell[22390, 842, 118, 2, 70, "Index",
  CellTags->"Style (menu command)"],
Cell[22511, 846, 186, 5, 70, "Index",
  CellTags->"Screen Style Environment (menu command)"],
Cell[22700, 853, 190, 5, 70, "Index",
  CellTags->"Printing Style Environment (menu command)"],
Cell[22893, 860, 168, 5, 70, "Index",
  CellTags->"Show Expression (menu command)"],
Cell[23064, 867, 173, 5, 70, "Index",
  CellTags->"Option Inspector (menu command)"],
Cell[23240, 874, 169, 5, 70, "Index",
  CellTags->"Remove Options (menu command)"],
Cell[23412, 881, 160, 5, 70, "Index",
  CellTags->"Style Sheet (menu command)"],
Cell[23575, 888, 170, 5, 70, "Index",
  CellTags->"Edit Style Sheet (menu command)"],
Cell[23748, 895, 146, 5, 70, "Index",
  CellTags->"Font (menu command)"],
Cell[23897, 902, 146, 5, 70, "Index",
  CellTags->"Face (menu command)"],
Cell[24046, 909, 146, 5, 70, "Index",
  CellTags->"Size (menu command)"],
Cell[24195, 916, 158, 5, 70, "Index",
  CellTags->"Text Color (menu command)"],
Cell[24356, 923, 170, 5, 70, "Index",
  CellTags->"Background Color (menu command)"],
Cell[24529, 930, 162, 5, 70, "Index",
  CellTags->"Choose Font (menu command)"],
Cell[24694, 937, 166, 5, 70, "Index",
  CellTags->"Text Alignment (menu command)"],
Cell[24863, 944, 174, 5, 70, "Index",
  CellTags->"Text Justification (menu command)"],
Cell[25040, 951, 164, 5, 70, "Index",
  CellTags->"Word Wrapping (menu command)"],
Cell[25207, 958, 208, 6, 70, "IndexSubentry",
  CellTags->"menucommands"],
Cell[25418, 966, 216, 6, 70, "IndexSubentry",
  CellTags->"menucommands"],
Cell[25637, 974, 218, 6, 70, "IndexSubentry",
  CellTags->"menucommands"],
Cell[25858, 982, 220, 6, 70, "IndexSubentry",
  CellTags->"menucommands"],
Cell[26081, 990, 162, 5, 70, "Index",
  CellTags->"Cell Dingbat (menu command)"],
Cell[26246, 997, 140, 2, 70, "Index",
  CellTags->"Horizontal Lines (menu command)"],
Cell[26389, 1001, 158, 5, 70, "Index",
  CellTags->"Show Ruler (menu command)"],
Cell[26550, 1008, 162, 5, 70, "Index",
  CellTags->"Show Toolbar (menu command)"],
Cell[26715, 1015, 206, 6, 70, "Index",
  CellTags->"Show Page Breaks (menu command)"],
Cell[26924, 1023, 164, 5, 70, "Index",
  CellTags->"Magnification (menu command)"]
}, Closed]],

Cell[CellGroupData[{
Cell[27125, 1033, 62, 1, 70, "SubsubsectionIcon"],
Cell[27190, 1036, 189, 5, 70, "Index",
  CellTags->"Get Graphics Coordinates (menu command)"],
Cell[27382, 1043, 183, 5, 70, "Index",
  CellTags->"3D ViewPoint Selector (menu command)"],
Cell[27568, 1050, 169, 5, 70, "Index",
  CellTags->"Color Selector (menu command)"],
Cell[27740, 1057, 165, 5, 70, "Index",
  CellTags->"Record Sound (menu command)"],
Cell[27908, 1064, 167, 5, 70, "Index",
  CellTags->"Get File Path (menu command)"],
Cell[28078, 1071, 195, 5, 70, "Index",
  CellTags->"Create Table/Matrix/Palette (menu command)"],
Cell[28276, 1078, 164, 5, 70, "Index",
  CellTags->"Create Button (menu command)"],
Cell[28443, 1085, 163, 5, 70, "Index",
  CellTags->"Edit Button (menu command)"],
Cell[28609, 1092, 173, 5, 70, "Index",
  CellTags->"Create Hyperlink (menu command)"],
Cell[28785, 1099, 207, 5, 70, "Index",
  CellTags->"Create Automatic Numbering Object (menu command)"],
Cell[28995, 1106, 195, 5, 70, "Index",
  CellTags->"Create Value Display Object (menu command)"],
Cell[29193, 1113, 180, 2, 70, "Index",
  CellTags->"Convert Automatic Objects to Literal (menu command)"],
Cell[29376, 1117, 180, 5, 70, "Index",
  CellTags->"Copy Input from Above (menu command)"],
Cell[29559, 1124, 182, 5, 70, "Index",
  CellTags->"Copy Output from Above (menu command)"],
Cell[29744, 1131, 178, 5, 70, "Index",
  CellTags->"Start New Cell Below (menu command)"],
Cell[29925, 1138, 174, 5, 70, "Index",
  CellTags->"Complete Selection (menu command)"],
Cell[30102, 1145, 164, 5, 70, "Index",
  CellTags->"Make Template (menu command)"]
}, Closed]],

Cell[CellGroupData[{
Cell[30303, 1155, 63, 1, 70, "SubsubsectionIcon"],
Cell[30369, 1158, 121, 4, 70, "Index",
  CellTags->"Evaluation (menu command)"],
Cell[30493, 1164, 220, 6, 70, "IndexSubentry",
  CellTags->"Evaluate Cells (menu command)"],
Cell[30716, 1172, 229, 6, 70, "IndexSubentry",
  CellTags->"Evaluate in Place (menu command)"],
Cell[30948, 1180, 235, 6, 70, "IndexSubentry",
  CellTags->"Evaluate Next Input (menu command)"],
Cell[31186, 1188, 244, 6, 70, "IndexSubentry",
  CellTags->"Evaluate In Subsession (menu command)"],
Cell[31433, 1196, 229, 6, 70, "IndexSubentry",
  CellTags->"Evaluate Notebook (menu command)"],
Cell[31665, 1204, 247, 6, 70, "IndexSubentry",
  CellTags->"Evaluate Initialization (menu command)"],
Cell[31915, 1212, 226, 6, 70, "IndexSubentry",
  CellTags->"Enter Subsession (menu command)"],
Cell[32144, 1220, 223, 6, 70, "IndexSubentry",
  CellTags->"Exit Subsession (menu command)"],
Cell[32370, 1228, 262, 6, 70, "IndexSubentry",
  CellTags->"Remove from Evaluation Queue (menu command)"],
Cell[32635, 1236, 181, 5, 70, "Index",
  CellTags->"Interrupt Evaluation (menu command)"],
Cell[32819, 1243, 170, 5, 70, "Index",
  CellTags->"Abort Evaluation (menu command)"],
Cell[32992, 1250, 162, 5, 70, "Index",
  CellTags->"Start Kernel (menu command)"],
Cell[33157, 1257, 160, 5, 70, "Index",
  CellTags->"Quit Kernel (menu command)"],
Cell[33320, 1264, 166, 5, 70, "Index",
  CellTags->"Default Kernel (menu command)"],
Cell[33489, 1271, 172, 5, 70, "Index",
  CellTags->"Notebook's Kernel (menu command)"],
Cell[33664, 1278, 197, 5, 70, "Index",
  CellTags->"Kernel Configuration Options (menu command)"],
Cell[33864, 1285, 172, 5, 70, "Index",
  CellTags->"Show In/Out Names (menu command)"],
Cell[34039, 1292, 172, 5, 70, "Index",
  CellTags->"Delete All Output (menu command)"]
}, Closed]],

Cell[CellGroupData[{
Cell[34248, 1302, 61, 1, 70, "SubsubsectionIcon"],
Cell[34312, 1305, 149, 5, 70, "Index",
  CellTags->"Find (menu command)"],
Cell[34464, 1312, 168, 5, 70, "Index",
  CellTags->"Enter Selection (menu command)"],
Cell[34635, 1319, 156, 5, 70, "Index",
  CellTags->"Find Next (menu command)"],
Cell[34794, 1326, 164, 5, 70, "Index",
  CellTags->"Find Previous (menu command)"],
Cell[34961, 1333, 172, 5, 70, "Index",
  CellTags->"Find in Cell Tags (menu command)"],
Cell[35136, 1340, 167, 5, 70, "Index",
  CellTags->"Replace and Find Again (menu command)"],
Cell[35306, 1347, 182, 5, 70, "Index",
  CellTags->"Replace and Find Again (menu command)"],
Cell[35491, 1354, 160, 5, 70, "Index",
  CellTags->"Replace All (menu command)"],
Cell[35654, 1361, 164, 5, 70, "Index",
  CellTags->"Open Selected (menu command)"],
Cell[35821, 1368, 176, 5, 70, "Index",
  CellTags->"Scroll to Selection (menu command)"],
Cell[36000, 1375, 152, 5, 70, "Index",
  CellTags->"Go Back (menu command)"],
Cell[36155, 1382, 181, 5, 70, "Index",
  CellTags->"Add/Remove Cell Tags (menu command)"],
Cell[36339, 1389, 156, 5, 70, "Index",
  CellTags->"Cell Tags (menu command)"],
Cell[36498, 1396, 166, 5, 70, "Index",
  CellTags->"Show Cell Tags (menu command)"],
Cell[36667, 1403, 192, 5, 70, "Index",
  CellTags->"Cell Tags from In/Out Names (menu command)"],
Cell[36862, 1410, 164, 5, 70, "Index",
  CellTags->"Make Index... (menu command)"]
}, Closed]],

Cell[CellGroupData[{
Cell[37063, 1420, 63, 1, 70, "SubsubsectionIcon"],
Cell[37129, 1423, 164, 5, 70, "Index",
  CellTags->"Stack Windows (menu command)"],
Cell[37296, 1430, 172, 5, 70, "Index",
  CellTags->"Tile Windows Wide (menu command)"],
Cell[37471, 1437, 172, 5, 70, "Index",
  CellTags->"Tile Windows Tall (menu command)"]
}, Closed]],

Cell[CellGroupData[{
Cell[37680, 1447, 61, 1, 70, "SubsubsectionIcon"],
Cell[37744, 1450, 165, 5, 70, "Index",
  CellTags->"Help Browser (menu command)"],
Cell[37912, 1457, 185, 5, 70, "Index",
  CellTags->"Find Selected Function (menu command)"],
Cell[38100, 1464, 165, 5, 70, "Index",
  CellTags->"Master Index (menu command)"],
Cell[38268, 1471, 166, 5, 70, "Index",
  CellTags->"InformationCenter (menu command)"],
Cell[38437, 1478, 199, 5, 70, "Index",
  CellTags->"Information Center on the Web (menu command)"],
Cell[38639, 1485, 195, 5, 70, "Index",
  CellTags->"Wolfram Research on the Web (menu command)"],
Cell[38837, 1492, 172, 5, 70, "Index",
  CellTags->"Registration (menu command)"],
Cell[39012, 1499, 166, 5, 70, "Index",
  CellTags->"Why the Beep (menu command)"],
Cell[39181, 1506, 171, 5, 70, "Index",
  CellTags->"Startup Palette (menu command)"],
Cell[39355, 1513, 175, 5, 70, "Index",
  CellTags->"About Mathematica (menu command)"],
Cell[39533, 1520, 191, 5, 70, "Index",
  CellTags->"X Environment Information (menu command)"],
Cell[39727, 1527, 174, 5, 70, "Index",
  CellTags->"Rebuild Help Index (menu command)"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[39950, 1538, 45, 0, 26, "SubsectionIcon"],
Cell[39998, 1540, 447, 15, 70, "Index",
  CellTags->"Keyboard shortcuts"]
}, Closed]],

Cell[CellGroupData[{
Cell[40482, 1560, 38, 0, 26, "SubsectionIcon"],
Cell[40523, 1562, 2014, 53, 70, "Index",
  CellTags->"Style sheets"],
Cell[42540, 1617, 36, 0, 70, "IndexSection"],
Cell[42579, 1619, 596, 14, 70, "Index",
  CellTags->{"Style sheets", "Environments"}],
Cell[43178, 1635, 47, 0, 70, "IndexSection"],
Cell[43228, 1637, 820, 21, 70, "Index",
  CellTags->{
  "Style sheets", "Environments", "Tutorial", "Slide Show", 
    "10 Minute Tutorial on Mathematica"}],
Cell[44051, 1660, 709, 19, 70, "Index",
  CellTags->{
  "Style sheets", "Environments", "Tutorial", "Slide Show", 
    "10 Minute Tutorial on Mathematica"}]
}, Closed]],

Cell[CellGroupData[{
Cell[44797, 1684, 43, 0, 26, "SubsectionIcon"],
Cell[44843, 1686, 129, 2, 15, "Index",
  CellTags->"NotebookDirectory"],
Cell[44975, 1690, 119, 2, 15, "Index",
  CellTags->"NotebookPath"],
Cell[45097, 1694, 117, 2, 15, "Index",
  CellTags->"PalettePath"],
Cell[45217, 1698, 127, 2, 15, "Index",
  CellTags->"AutoOpenPalettes"],
Cell[45347, 1702, 129, 2, 15, "Index",
  CellTags->"AutoOpenNotebooks"],
Cell[45479, 1706, 123, 2, 15, "Index",
  CellTags->"StyleSheetPath"],
Cell[45605, 1710, 125, 2, 15, "Index",
  CellTags->"DefaultNotebook"],
Cell[45733, 1714, 141, 2, 15, "Index",
  CellTags->"DefaultStyleDefinitions"],
Cell[45877, 1718, 125, 2, 15, "Index",
  CellTags->"PreferencesPath"],
Cell[46005, 1722, 129, 2, 15, "Index",
  CellTags->"ConfigurationPath"],
Cell[46137, 1726, 123, 2, 15, "Index",
  CellTags->"SystemHelpPath"],
Cell[46263, 1730, 121, 2, 15, "Index",
  CellTags->"AddOnHelpPath"],
Cell[46387, 1734, 119, 2, 15, "Index",
  CellTags->"AutoloadPath"],
Cell[46509, 1738, 143, 2, 15, "Index",
  CellTags->"SpellingDictionariesPath"],
Cell[46655, 1742, 139, 2, 15, "Index",
  CellTags->"CharacterEncodingsPath"],
Cell[46797, 1746, 139, 2, 15, "Index",
  CellTags->"ImportAutoReplacements"],
Cell[46939, 1750, 139, 2, 15, "Index",
  CellTags->"ExportAutoReplacements"],
Cell[47081, 1754, 111, 2, 15, "Index",
  CellTags->"Language"],
Cell[47195, 1758, 153, 2, 15, "Index",
  CellTags->"ExternalDataCharacterEncoding"],
Cell[47351, 1762, 119, 2, 15, "Index",
  CellTags->"StartupSound"],
Cell[47473, 1766, 131, 2, 15, "Index",
  CellTags->"MultilaunchWarning"],
Cell[47607, 1770, 125, 2, 15, "Index",
  CellTags->"ScreenRectangle"],
Cell[47735, 1774, 129, 2, 15, "Index",
  CellTags->"FrontEndStackSize"],
Cell[47867, 1778, 115, 2, 15, "Index",
  CellTags->"XPasteFrom"],
Cell[47985, 1782, 123, 2, 15, "Index",
  CellTags->"EvaluatorNames"],
Cell[48111, 1786, 121, 2, 15, "Index",
  CellTags->"NotebooksMenu"],
Cell[48235, 1790, 129, 2, 15, "Index",
  CellTags->"FontSubstitutions"],
Cell[48367, 1794, 137, 2, 15, "Index",
  CellTags->"DefaultFontProperties"],
Cell[48507, 1798, 131, 2, 15, "Index",
  CellTags->"BoxFormFormatTypes"],
Cell[48641, 1802, 121, 2, 15, "Index",
  CellTags->"WarningAction"],
Cell[48765, 1806, 117, 2, 15, "Index",
  CellTags->"ErrorAction"],
Cell[48885, 1810, 135, 2, 15, "Index",
  CellTags->"ConsoleMessageAction"],
Cell[49023, 1814, 133, 2, 15, "Index",
  CellTags->"KernelMessageAction"],
Cell[49159, 1818, 125, 2, 15, "Index",
  CellTags->"ExplainBeepHelp"],
Cell[49287, 1822, 131, 2, 15, "Index",
  CellTags->"MathMLPasteWarning"],
Cell[49421, 1826, 147, 2, 15, "Index",
  CellTags->"InsufficientVersionWarning"],
Cell[49571, 1830, 149, 2, 15, "Index",
  CellTags->"IgnoreTagBoxDeletionWarning"],
Cell[49723, 1834, 159, 2, 15, "Index",
  CellTags->"TraditionalFormEvaluationWarning"],
Cell[49885, 1838, 139, 2, 15, "Index",
  CellTags->"AllowDisablingWarnings"],
Cell[50027, 1842, 127, 2, 15, "Index",
  CellTags->"NotebookAutoSave"],
Cell[50157, 1846, 125, 2, 15, "Index",
  CellTags->"ClosingAutoSave"],
Cell[50285, 1850, 135, 2, 15, "Index",
  CellTags->"IncludeFileExtension"],
Cell[50423, 1854, 135, 2, 15, "Index",
  CellTags->"AutoGeneratedPackage"],
Cell[50561, 1858, 111, 2, 15, "Index",
  CellTags->"Editable"],
Cell[50675, 1862, 111, 2, 15, "Index",
  CellTags->"Saveable"],
Cell[50789, 1866, 139, 2, 15, "Index",
  CellTags->"ScreenStyleEnvironment"],
Cell[50931, 1870, 143, 2, 15, "Index",
  CellTags->"PrintingStyleEnvironment"],
Cell[51077, 1874, 123, 2, 15, "Index",
  CellTags->"ShowPageBreaks"],
Cell[51203, 1878, 123, 2, 15, "Index",
  CellTags->"WindowToolbars"],
Cell[51329, 1882, 115, 2, 15, "Index",
  CellTags->"RulerUnits"],
Cell[51447, 1886, 148, 5, 16, "Index",
  CellTags->"NotebookBackground"],
Cell[51598, 1893, 121, 2, 15, "Index",
  CellTags->"Magnification"],
Cell[51722, 1897, 113, 2, 15, "Index",
  CellTags->"Evaluator"],
Cell[51838, 1901, 147, 2, 15, "Index",
  CellTags->"EvaluationCompletionAction"],
Cell[51988, 1905, 117, 2, 15, "Index",
  CellTags->"PrintAction"],
Cell[52108, 1909, 133, 2, 15, "Index",
  CellTags->"OutputAutoOverwrite"],
Cell[52244, 1913, 151, 2, 15, "Index",
  CellTags->"InitializationCellEvaluation"],
Cell[52398, 1917, 145, 2, 15, "Index",
  CellTags->"InitializationCellWarning"],
Cell[52546, 1921, 115, 2, 15, "Index",
  CellTags->"Selectable"],
Cell[52664, 1925, 113, 2, 15, "Index",
  CellTags->"Deletable"],
Cell[52780, 1929, 119, 2, 15, "Index",
  CellTags->"CellGrouping"],
Cell[52902, 1933, 113, 2, 15, "Index",
  CellTags->"PageWidth"],
Cell[53018, 1937, 115, 2, 15, "Index",
  CellTags->"WindowSize"],
Cell[53136, 1941, 121, 2, 15, "Index",
  CellTags->"WindowMargins"],
Cell[53260, 1945, 117, 2, 15, "Index",
  CellTags->"WindowFrame"],
Cell[53380, 1949, 123, 2, 15, "Index",
  CellTags->"WindowElements"],
Cell[53506, 1953, 133, 2, 15, "Index",
  CellTags->"WindowFrameElements"],
Cell[53642, 1957, 129, 2, 15, "Index",
  CellTags->"WindowClickSelect"],
Cell[53774, 1961, 123, 2, 15, "Index",
  CellTags->"WindowFloating"],
Cell[53900, 1965, 121, 2, 15, "Index",
  CellTags->"WindowMovable"],
Cell[54024, 1969, 117, 2, 15, "Index",
  CellTags->"WindowTitle"],
Cell[54144, 1973, 109, 2, 15, "Index",
  CellTags->"Visible"],
Cell[54256, 1977, 123, 2, 15, "Index",
  CellTags->"PrintingCopies"],
Cell[54382, 1981, 147, 2, 15, "Index",
  CellTags->"PrintingStartingPageNumber"],
Cell[54532, 1985, 129, 2, 15, "Index",
  CellTags->"PrintingPageRange"],
Cell[54664, 1989, 117, 2, 15, "Index",
  CellTags->"PageHeaders"],
Cell[54784, 1993, 117, 2, 15, "Index",
  CellTags->"PageFooters"],
Cell[54904, 1997, 125, 2, 15, "Index",
  CellTags->"PageHeaderLines"],
Cell[55032, 2001, 125, 2, 15, "Index",
  CellTags->"PageFooterLines"],
Cell[55160, 2005, 119, 2, 15, "Index",
  CellTags->"SafeFileSave"],
Cell[55282, 2009, 119, 2, 15, "Index",
  CellTags->"SafeFileOpen"],
Cell[55404, 2013, 119, 2, 15, "Index",
  CellTags->"DoubleBuffer"],
Cell[55526, 2017, 119, 2, 15, "Index",
  CellTags->"ColorPalette"],
Cell[55648, 2021, 153, 2, 15, "Index",
  CellTags->"BackgroundPostScriptRendering"],
Cell[55804, 2025, 143, 2, 15, "Index",
  CellTags->"RealTimeMarginAdjustment"],
Cell[55950, 2029, 131, 2, 15, "Index",
  CellTags->"RealTimeWindowMove"],
Cell[56084, 2033, 135, 2, 15, "Index",
  CellTags->"RealTimeWindowResize"],
Cell[56222, 2037, 119, 2, 15, "Index",
  CellTags->"ShortBoxForm"],
Cell[56344, 2041, 107, 2, 15, "Index",
  CellTags->"Format"],
Cell[56454, 2045, 111, 2, 15, "Index",
  CellTags->"Ellipsis"],
Cell[56568, 2049, 137, 2, 15, "Index",
  CellTags->"MultiPageContinuation"],
Cell[56708, 2053, 121, 2, 15, "Index",
  CellTags->"PageSeparator"],
Cell[56832, 2057, 127, 2, 15, "Index",
  CellTags->"SectionSeparator"],
Cell[56962, 2061, 113, 2, 15, "Index",
  CellTags->"MainEntry"],
Cell[57078, 2065, 111, 2, 15, "Index",
  CellTags->"MainPage"],
Cell[57192, 2069, 113, 2, 15, "Index",
  CellTags->"CellFrame"],
Cell[57308, 2073, 117, 2, 15, "Index",
  CellTags->"CellDingbat"],
Cell[57428, 2077, 191, 6, 16, "Index",
  CellTags->"CellBackground"],
Cell[57622, 2085, 125, 2, 15, "Index",
  CellTags->"ShowCellBracket"],
Cell[57750, 2089, 121, 2, 15, "Index",
  CellTags->"ShowSelection"],
Cell[57874, 2093, 139, 2, 15, "Index",
  CellTags->"ShowGroupOpenCloseIcon"],
Cell[58016, 2097, 131, 2, 15, "Index",
  CellTags->"ShowClosedCellArea"],
Cell[58150, 2101, 127, 2, 15, "Index",
  CellTags->"ShowShortBoxForm"],
Cell[58280, 2105, 127, 2, 15, "Index",
  CellTags->"CellDisplayCache"],
Cell[58410, 2109, 117, 2, 15, "Index",
  CellTags->"CellMargins"],
Cell[58530, 2113, 107, 2, 15, "Index",
  CellTags->"Active"],
Cell[58640, 2117, 129, 2, 15, "Index",
  CellTags->"CellEditDuplicate"],
Cell[58772, 2121, 117, 2, 15, "Index",
  CellTags->"Evaluatable"],
Cell[58892, 2125, 115, 2, 15, "Index",
  CellTags->"Selectable"],
Cell[59010, 2129, 113, 2, 15, "Index",
  CellTags->"Deletable"],
Cell[59126, 2133, 111, 2, 15, "Index",
  CellTags->"Copyable"],
Cell[59240, 2137, 111, 2, 15, "Index",
  CellTags->"CellOpen"],
Cell[59354, 2141, 129, 2, 15, "Index",
  CellTags->"CellGroupingRules"],
Cell[59486, 2145, 125, 2, 15, "Index",
  CellTags->"ConversionRules"],
Cell[59614, 2149, 119, 2, 15, "Index",
  CellTags->"TaggingRules"],
Cell[59736, 2153, 141, 2, 15, "Index",
  CellTags->"CellHorizontalScrolling"],
Cell[59880, 2157, 127, 2, 15, "Index",
  CellTags->"StyleMenuListing"],
Cell[60010, 2161, 139, 2, 15, "Index",
  CellTags->"ButtonStyleMenuListing"],
Cell[60152, 2165, 141, 2, 15, "Index",
  CellTags->"CounterStyleMenuListing"],
Cell[60296, 2169, 137, 2, 15, "Index",
  CellTags->"FormatTypeAutoConvert"],
Cell[60436, 2173, 123, 2, 15, "Index",
  CellTags->"PageBreakAbove"],
Cell[60562, 2177, 125, 2, 15, "Index",
  CellTags->"PageBreakWithin"],
Cell[60690, 2181, 123, 2, 15, "Index",
  CellTags->"PageBreakBelow"],
Cell[60816, 2185, 135, 2, 15, "Index",
  CellTags->"GroupPageBreakWithin"],
Cell[60954, 2189, 131, 2, 15, "Index",
  CellTags->"InitializationCell"],
Cell[61088, 2193, 141, 2, 15, "Index",
  CellTags->"CellEvaluationDuplicate"],
Cell[61232, 2197, 121, 2, 15, "Index",
  CellTags->"GeneratedCell"],
Cell[61356, 2201, 129, 2, 15, "Index",
  CellTags->"CellAutoOverwrite"],
Cell[61488, 2205, 113, 2, 15, "Index",
  CellTags->"Evaluator"],
Cell[61604, 2209, 113, 2, 15, "Index",
  CellTags->"CellLabel"],
Cell[61720, 2213, 121, 2, 15, "Index",
  CellTags->"ShowCellLabel"],
Cell[61844, 2217, 135, 2, 15, "Index",
  CellTags->"CellLabelPositioning"],
Cell[61982, 2221, 133, 2, 15, "Index",
  CellTags->"CellLabelAutoDelete"],
Cell[62118, 2225, 127, 2, 15, "Index",
  CellTags->"CellLabelMargins"],
Cell[62248, 2229, 113, 2, 15, "Index",
  CellTags->"CellFrame"],
Cell[62364, 2233, 127, 2, 15, "Index",
  CellTags->"CellFrameMargins"],
Cell[62494, 2237, 123, 2, 15, "Index",
  CellTags->"CellFrameColor"],
Cell[62620, 2241, 137, 2, 15, "Index",
  CellTags->"CellFrameLabelMargins"],
Cell[62760, 2245, 125, 2, 15, "Index",
  CellTags->"CellFrameLabels"],
Cell[62888, 2249, 119, 2, 15, "Index",
  CellTags->"ShowCellTags"],
Cell[63010, 2253, 111, 2, 15, "Index",
  CellTags->"CellSize"],
Cell[63124, 2257, 119, 2, 15, "Index",
  CellTags->"CellBaseline"],
Cell[63246, 2261, 133, 2, 15, "Index",
  CellTags->"DefaultNewCellStyle"],
Cell[63382, 2265, 145, 2, 15, "Index",
  CellTags->"DefaultNewInlineCellStyle"],
Cell[63530, 2269, 145, 2, 15, "Index",
  CellTags->"DefaultDuplicateCellStyle"],
Cell[63678, 2273, 129, 2, 15, "Index",
  CellTags->"DefaultFormatType"],
Cell[63810, 2277, 141, 2, 15, "Index",
  CellTags->"DefaultInlineFormatType"],
Cell[63954, 2281, 115, 2, 15, "Index",
  CellTags->"FormatType"],
Cell[64072, 2285, 115, 2, 15, "Index",
  CellTags->"Selectable"],
Cell[64190, 2289, 113, 2, 15, "Index",
  CellTags->"Deletable"],
Cell[64306, 2293, 115, 2, 15, "Index",
  CellTags->"AutoIndent"],
Cell[64424, 2297, 119, 2, 15, "Index",
  CellTags->"InputAliases"],
Cell[64546, 2301, 137, 2, 15, "Index",
  CellTags->"InputAutoReplacements"],
Cell[64686, 2305, 131, 2, 15, "Index",
  CellTags->"DelimiterFlashTime"],
Cell[64820, 2309, 129, 2, 15, "Index",
  CellTags->"ShowCursorTracker"],
Cell[64952, 2313, 123, 2, 15, "Index",
  CellTags->"ShowAutoStyles"],
Cell[65078, 2317, 133, 2, 15, "Index",
  CellTags->"StructuredSelection"],
Cell[65214, 2321, 131, 2, 15, "Index",
  CellTags->"StyleBoxAutoDelete"],
Cell[65348, 2325, 117, 2, 15, "Index",
  CellTags->"DragAndDrop"],
Cell[65468, 2329, 137, 2, 15, "Index",
  CellTags->"ShowSpecialCharacters"],
Cell[65608, 2333, 127, 2, 15, "Index",
  CellTags->"AllowInlineCells"],
Cell[65738, 2337, 141, 2, 15, "Index",
  CellTags->"PasteBoxFormInlineCells"],
Cell[65882, 2341, 169, 2, 15, "Index",
  CellTags->"TwoByteSyntaxCharacterAutoReplacement"],
Cell[66054, 2345, 141, 2, 15, "Index",
  CellTags->"CursorTrackerParameters"],
Cell[66198, 2349, 127, 2, 15, "Index",
  CellTags->"AutoStyleOptions"],
Cell[66328, 2353, 111, 2, 15, "Index",
  CellTags->"FontSize"],
Cell[66442, 2357, 115, 2, 15, "Index",
  CellTags->"FontFamily"],
Cell[66560, 2361, 115, 2, 15, "Index",
  CellTags->"FontWeight"],
Cell[66678, 2365, 113, 2, 15, "Index",
  CellTags->"FontSlant"],
Cell[66794, 2369, 119, 2, 15, "Index",
  CellTags->"FontTracking"],
Cell[66916, 2373, 113, 2, 15, "Index",
  CellTags->"FontColor"],
Cell[67032, 2377, 198, 6, 16, "Index",
  CellTags->"FontOptionsBackground"],
Cell[67233, 2385, 129, 2, 15, "Index",
  CellTags->"CharacterEncoding"],
Cell[67365, 2389, 121, 2, 15, "Index",
  CellTags->"Magnification"],
Cell[67489, 2393, 121, 2, 15, "Index",
  CellTags->"TextAlignment"],
Cell[67613, 2397, 129, 2, 15, "Index",
  CellTags->"TextJustification"],
Cell[67745, 2401, 117, 2, 15, "Index",
  CellTags->"Hyphenation"],
Cell[67865, 2405, 115, 2, 15, "Index",
  CellTags->"TabFilling"],
Cell[67983, 2409, 117, 2, 15, "Index",
  CellTags->"LineSpacing"],
Cell[68103, 2413, 127, 2, 15, "Index",
  CellTags->"ParagraphSpacing"],
Cell[68233, 2417, 125, 2, 15, "Index",
  CellTags->"ParagraphIndent"],
Cell[68361, 2421, 117, 2, 15, "Index",
  CellTags->"TabSpacings"],
Cell[68481, 2425, 125, 2, 15, "Index",
  CellTags->"AutoItalicWords"],
Cell[68609, 2429, 127, 2, 15, "Index",
  CellTags->"LanguageCategory"],
Cell[68739, 2433, 139, 2, 15, "Index",
  CellTags->"DefaultNaturalLanguage"],
Cell[68881, 2437, 117, 2, 15, "Index",
  CellTags->"AutoSpacing"],
Cell[69001, 2441, 119, 2, 15, "Index",
  CellTags->"ShowContents"],
Cell[69123, 2445, 137, 2, 15, "Index",
  CellTags->"ScriptSizeMultipliers"],
Cell[69263, 2449, 121, 2, 15, "Index",
  CellTags->"ScriptMinSize"],
Cell[69387, 2453, 117, 2, 15, "Index",
  CellTags->"ScriptLevel"],
Cell[69507, 2457, 135, 2, 15, "Index",
  CellTags->"ShowStringCharacters"],
Cell[69645, 2461, 117, 2, 15, "Index",
  CellTags->"NumberMarks"],
Cell[69765, 2465, 123, 2, 15, "Index",
  CellTags->"PrintPrecision"],
Cell[69891, 2469, 127, 2, 15, "Index",
  CellTags->"NumberMultiplier"],
Cell[70021, 2473, 129, 2, 15, "Index",
  CellTags->"LimitsPositioning"],
Cell[70153, 2477, 141, 2, 15, "Index",
  CellTags->"LimitsPositioningTokens"],
Cell[70297, 2481, 135, 2, 15, "Index",
  CellTags->"ScriptBaselineShifts"],
Cell[70435, 2485, 133, 2, 15, "Index",
  CellTags->"SingleLetterItalics"],
Cell[70571, 2489, 149, 2, 15, "Index",
  CellTags->"TraditionalFunctionNotation"],
Cell[70723, 2493, 129, 2, 15, "Index",
  CellTags->"DelimiterMatching"],
Cell[70855, 2497, 123, 2, 15, "Index",
  CellTags->"ZeroWidthTimes"],
Cell[70981, 2501, 117, 2, 15, "Index",
  CellTags->"SpanMinSize"],
Cell[71101, 2505, 117, 2, 15, "Index",
  CellTags->"SpanMaxSize"],
Cell[71221, 2509, 121, 2, 15, "Index",
  CellTags->"SpanSymmetric"],
Cell[71345, 2513, 129, 2, 15, "Index",
  CellTags->"SpanLineThickness"],
Cell[71477, 2517, 137, 2, 15, "Index",
  CellTags->"SpanCharacterRounding"],
Cell[71617, 2521, 125, 2, 15, "Index",
  CellTags->"SpanAdjustments"],
Cell[71745, 2525, 125, 2, 15, "Index",
  CellTags->"LineBreakWithin"],
Cell[71873, 2529, 115, 2, 15, "Index",
  CellTags->"LineIndent"],
Cell[71991, 2533, 129, 2, 15, "Index",
  CellTags->"IndentMaxFraction"],
Cell[72123, 2537, 135, 2, 15, "Index",
  CellTags->"LinebreakAdjustments"],
Cell[72261, 2541, 127, 2, 15, "Index",
  CellTags->"AspectRatioFixed"],
Cell[72391, 2545, 113, 2, 15, "Index",
  CellTags->"ImageSize"],
Cell[72507, 2549, 119, 2, 15, "Index",
  CellTags->"ImageMargins"],
Cell[72629, 2553, 117, 2, 15, "Index",
  CellTags->"ImageRegion"],
Cell[72749, 2557, 135, 2, 15, "Index",
  CellTags->"AnimationDisplayTime"],
Cell[72887, 2561, 135, 2, 15, "Index",
  CellTags->"AnimationCycleOffset"],
Cell[73025, 2565, 145, 2, 15, "Index",
  CellTags->"AnimationCycleRepetitions"],
Cell[73173, 2569, 129, 2, 15, "Index",
  CellTags->"DrawDummyGraphics"],
Cell[73305, 2573, 133, 2, 15, "Index",
  CellTags->"RenderIncrementally"],
Cell[73441, 2577, 129, 2, 15, "Index",
  CellTags->"RenderFilledAreas"],
Cell[73573, 2581, 117, 2, 15, "Index",
  CellTags->"RenderLines"],
Cell[73693, 2585, 125, 2, 15, "Index",
  CellTags->"RenderThickness"],
Cell[73821, 2589, 131, 2, 15, "Index",
  CellTags->"RenderSystemColors"],
Cell[73955, 2593, 125, 2, 15, "Index",
  CellTags->"ObjectDithering"],
Cell[74083, 2597, 125, 2, 15, "Index",
  CellTags->"RasterDithering"],
Cell[74211, 2601, 135, 2, 15, "Index",
  CellTags->"ImageHalftoneDensity"],
Cell[74349, 2605, 131, 2, 15, "Index",
  CellTags->"ImageHalftoneAngle"],
Cell[74483, 2609, 125, 2, 15, "Index",
  CellTags->"ImageCacheDepth"],
Cell[74611, 2613, 107, 2, 15, "Index",
  CellTags->"Active"],
Cell[74721, 2617, 123, 2, 15, "Index",
  CellTags->"ButtonFunction"],
Cell[74847, 2621, 119, 2, 15, "Index",
  CellTags->"ButtonSource"],
Cell[74969, 2625, 125, 2, 15, "Index",
  CellTags->"ButtonEvaluator"],
Cell[75097, 2629, 115, 2, 15, "Index",
  CellTags->"ButtonData"],
Cell[75215, 2633, 117, 2, 15, "Index",
  CellTags->"ButtonStyle"],
Cell[75335, 2637, 117, 2, 15, "Index",
  CellTags->"ButtonFrame"],
Cell[75455, 2641, 190, 6, 16, "Index",
  CellTags->"ButtonBackground"],
Cell[75648, 2649, 121, 2, 15, "Index",
  CellTags->"ButtonMargins"],
Cell[75772, 2653, 127, 2, 15, "Index",
  CellTags->"ButtonExpandable"],
Cell[75902, 2657, 125, 2, 15, "Index",
  CellTags->"ButtonMinHeight"],
Cell[76030, 2661, 115, 2, 15, "Index",
  CellTags->"ButtonNote"],
Cell[76148, 2665, 133, 2, 15, "Index",
  CellTags->"PrivatePaths->{...}"],
Cell[76284, 2669, 186, 6, 16, "Index",
  CellTags->"TextResources"],
Cell[76473, 2677, 188, 6, 16, "Index",
  CellTags->"TextResources"],
Cell[76664, 2685, 166, 6, 16, "Index",
  CellTags->"AFM"],
Cell[76833, 2693, 170, 6, 16, "Index",
  CellTags->"Fonts"],
Cell[77006, 2701, 145, 2, 15, "Index",
  CellTags->"OpenSpecialOptions->{...}"],
Cell[77154, 2705, 194, 6, 16, "Index",
  CellTags->"ReadingType"],
Cell[77351, 2713, 206, 6, 16, "Index",
  CellTags->"CharacterEncoding"],
Cell[77560, 2721, 204, 6, 16, "Index",
  CellTags->"ListAllFileTypes"],
Cell[77767, 2729, 147, 2, 15, "Index",
  CellTags->"ToPostScriptOptions->{...}"],
Cell[77917, 2733, 218, 6, 16, "Index",
  CellTags->"RemoveColorFromBitmaps"],
Cell[78138, 2741, 222, 6, 16, "Index",
  CellTags->"IgnoreEmbeddedPostScript"],
Cell[78363, 2749, 198, 6, 16, "Index",
  CellTags->"BitsPerPixel"],
Cell[78564, 2757, 149, 2, 15, "Index",
  CellTags->"ImportTypesetOptions->{...}"],
Cell[78716, 2761, 198, 6, 16, "Index",
  CellTags->"BitsPerPixel"],
Cell[78917, 2769, 161, 2, 15, "Index",
  CellTags->"ExportMultipleCellsOptions->{...}"],
Cell[79081, 2773, 208, 6, 16, "Index",
  CellTags->"FormatType"],
Cell[79292, 2781, 206, 6, 16, "Index",
  CellTags->"PageWidth"],
Cell[79501, 2789, 222, 6, 16, "Index",
  CellTags->"IncludeCellLabels"],
Cell[79726, 2797, 218, 6, 16, "Index",
  CellTags->"IncludeCellTags"],
Cell[79947, 2805, 208, 6, 16, "Index",
  CellTags->"CellBreaks"],
Cell[80158, 2813, 226, 6, 16, "Index",
  CellTags->"CMYKColorGeneration"],
Cell[80387, 2821, 155, 2, 15, "Index",
  CellTags->"ExportPostScriptOptions->{...}"],
Cell[80545, 2825, 202, 6, 16, "Index",
  CellTags->"FormatType"],
Cell[80750, 2833, 200, 6, 16, "Index",
  CellTags->"PageWidth"],
Cell[80953, 2841, 216, 6, 16, "Index",
  CellTags->"IncludeCellLabels"],
Cell[81172, 2849, 212, 6, 16, "Index",
  CellTags->"IncludeCellTags"],
Cell[81387, 2857, 202, 6, 16, "Index",
  CellTags->"CellBreaks"],
Cell[81592, 2865, 220, 6, 16, "Index",
  CellTags->"CMYKColorGeneration"],
Cell[81815, 2873, 163, 2, 15, "Index",
  CellTags->"ExportNativeGraphicsOptions->{...}"],
Cell[81981, 2877, 210, 6, 16, "Index",
  CellTags->"FormatType"],
Cell[82194, 2885, 208, 6, 16, "Index",
  CellTags->"PageWidth"],
Cell[82405, 2893, 224, 6, 16, "Index",
  CellTags->"IncludeCellLabels"],
Cell[82632, 2901, 220, 6, 16, "Index",
  CellTags->"IncludeCellTags"],
Cell[82855, 2909, 210, 6, 16, "Index",
  CellTags->"CellBreaks"],
Cell[83068, 2917, 228, 6, 16, "Index",
  CellTags->"CMYKColorGeneration"],
Cell[83299, 2925, 149, 2, 15, "Index",
  CellTags->"ExportTypesetOptions->{...}"],
Cell[83451, 2929, 196, 6, 16, "Index",
  CellTags->"FormatType"],
Cell[83650, 2937, 194, 6, 16, "Index",
  CellTags->"PageWidth"],
Cell[83847, 2945, 210, 6, 16, "Index",
  CellTags->"IncludeCellLabels"],
Cell[84060, 2953, 206, 6, 16, "Index",
  CellTags->"IncludeCellTags"],
Cell[84269, 2961, 196, 6, 16, "Index",
  CellTags->"CellBreaks"],
Cell[84468, 2969, 214, 6, 16, "Index",
  CellTags->"CMYKColorGeneration"],
Cell[84685, 2977, 153, 2, 15, "Index",
  CellTags->"ExportQuickTimeOptions->{...}"],
Cell[84841, 2981, 200, 6, 16, "Index",
  CellTags->"FormatType"],
Cell[85044, 2989, 198, 6, 16, "Index",
  CellTags->"PageWidth"],
Cell[85245, 2997, 214, 6, 16, "Index",
  CellTags->"IncludeCellLabels"],
Cell[85462, 3005, 210, 6, 16, "Index",
  CellTags->"IncludeCellTags"],
Cell[85675, 3013, 200, 6, 16, "Index",
  CellTags->"CellBreaks"],
Cell[85878, 3021, 218, 6, 16, "Index",
  CellTags->"CMYKColorGeneration"],
Cell[86099, 3029, 149, 2, 15, "Index",
  CellTags->"SaveAsSpecialOptions->{...}"],
Cell[86251, 3033, 196, 6, 16, "Index",
  CellTags->"FormatType"],
Cell[86450, 3041, 194, 6, 16, "Index",
  CellTags->"PageWidth"],
Cell[86647, 3049, 210, 6, 16, "Index",
  CellTags->"IncludeCellLabels"],
Cell[86860, 3057, 206, 6, 16, "Index",
  CellTags->"IncludeCellTags"],
Cell[87069, 3065, 196, 6, 16, "Index",
  CellTags->"CellBreaks"],
Cell[87268, 3073, 214, 6, 16, "Index",
  CellTags->"CMYKColorGeneration"],
Cell[87485, 3081, 133, 2, 15, "Index",
  CellTags->"FindSettings->{...}"],
Cell[87621, 3085, 180, 6, 16, "Index",
  CellTags->"FindString"],
Cell[87804, 3093, 186, 6, 16, "Index",
  CellTags->"ReplaceString"],
Cell[87993, 3101, 180, 6, 16, "Index",
  CellTags->"IgnoreCase"],
Cell[88176, 3109, 180, 6, 16, "Index",
  CellTags->"Wraparound"],
Cell[88359, 3117, 186, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[88548, 3125, 149, 2, 15, "Index",
  CellTags->"EditCellTagsSettings->{...}"],
Cell[88700, 3129, 197, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[88900, 3137, 202, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[89105, 3145, 159, 2, 15, "Index",
  CellTags->"ViewPointSelectorSettings->{...}"],
Cell[89267, 3149, 218, 6, 16, "Index",
  CellTags->"CoordinateSystem"],
Cell[89488, 3157, 210, 6, 16, "Index",
  CellTags->"TemplateText"],
Cell[89701, 3165, 204, 6, 16, "Index",
  CellTags->"ViewPoint"],
Cell[89908, 3173, 212, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[90123, 3181, 151, 2, 15, "Index",
  CellTags->"ColorSelectorSettings->{...}"],
Cell[90277, 3185, 188, 6, 16, "Index",
  CellTags->"Color"],
Cell[90468, 3193, 149, 2, 15, "Index",
  CellTags->"GridCreationSettings->{...}"],
Cell[90620, 3197, 184, 6, 16, "Index",
  CellTags->"Rows"],
Cell[90807, 3205, 190, 6, 16, "Index",
  CellTags->"Columns"],
Cell[91000, 3213, 200, 6, 16, "Index",
  CellTags->"DrawRowLines"],
Cell[91203, 3221, 206, 6, 16, "Index",
  CellTags->"DrawColumnLines"],
Cell[91412, 3229, 194, 6, 16, "Index",
  CellTags->"DrawFrame"],
Cell[91609, 3237, 184, 6, 16, "Index",
  CellTags->"Type"],
Cell[91796, 3245, 184, 6, 16, "Index",
  CellTags->"Fill"],
Cell[91983, 3253, 200, 6, 16, "Index",
  CellTags->"DiagonalFill"],
Cell[92186, 3261, 192, 6, 16, "Index",
  CellTags->"FillText"],
Cell[92381, 3269, 208, 6, 16, "Index",
  CellTags->"DiagonalFillText"],
Cell[92592, 3277, 161, 2, 15, "Index",
  CellTags->"NotebookStatisticsSettings->{...}"],
Cell[92756, 3281, 200, 6, 16, "Index",
  CellTags->"Domain"],
Cell[92959, 3289, 222, 6, 16, "Index",
  CellTags->"IncludeSharedData"],
Cell[93184, 3297, 214, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[93401, 3305, 155, 2, 15, "Index",
  CellTags->"OptionInspectorSettings->{...}"],
Cell[93559, 3309, 192, 6, 16, "Index",
  CellTags->"Scope"],
Cell[93754, 3317, 194, 6, 16, "Index",
  CellTags->"ViewAs"],
Cell[93951, 3325, 202, 6, 16, "Index",
  CellTags->"WindowSize"],
Cell[94156, 3333, 208, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[94367, 3341, 145, 2, 15, "Index",
  CellTags->"EditButtonSettings->{...}"],
Cell[94515, 3345, 198, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[94716, 3353, 155, 2, 15, "Index",
  CellTags->"BackgroundTasksSettings->{...}"],
Cell[94874, 3357, 208, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[95085, 3365, 143, 2, 15, "Index",
  CellTags->"InterruptSettings->{...}"],
Cell[95231, 3369, 196, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[95430, 3377, 135, 2, 15, "Index",
  CellTags->"InputSettings->{...}"],
Cell[95568, 3381, 188, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[95759, 3389, 147, 2, 15, "Index",
  CellTags->"HelpBrowserSettings->{...}"],
Cell[95909, 3393, 201, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[96113, 3401, 194, 6, 16, "Index",
  CellTags->"WindowSize"],
Cell[96310, 3409, 200, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[96513, 3417, 149, 2, 15, "Index",
  CellTags->"ErrorsDialogSettings->{...}"],
Cell[96665, 3421, 202, 6, 16, "Index",
  CellTags->"WindowMargins"],
Cell[96870, 3429, 155, 2, 15, "Index",
  CellTags->"StyleNameDialogSettings->{...}"],
Cell[97028, 3433, 192, 6, 16, "Index",
  CellTags->"Style"],
Cell[97223, 3441, 153, 2, 15, "Index",
  CellTags->"FileNameDialogSettings->{...}"],
Cell[97379, 3445, 204, 6, 16, "Index",
  CellTags->"StringFormat"],
Cell[97586, 3453, 155, 2, 15, "Index",
  CellTags->"NotebookConvertSettings->{...}"],
Cell[97744, 3457, 220, 6, 16, "Index",
  CellTags->"InputToStandardForm"],
Cell[97967, 3465, 222, 6, 16, "Index",
  CellTags->"OutputToStandardForm"],
Cell[98192, 3473, 218, 6, 16, "Index",
  CellTags->"PreserveStyleSheet"],
Cell[98413, 3481, 222, 6, 16, "Index",
  CellTags->"GenerateBitmapCaches"],
Cell[98638, 3489, 141, 2, 15, "Index",
  CellTags->"ScrollingOptions->{...}"],
Cell[98782, 3493, 202, 6, 16, "Index",
  CellTags->"PagewiseScrolling"],
Cell[98987, 3501, 198, 6, 16, "Index",
  CellTags->"PagewiseDisplay"],
Cell[99188, 3509, 202, 6, 16, "Index",
  CellTags->"RealTimeScrolling"],
Cell[99393, 3517, 194, 6, 16, "Index",
  CellTags->"JumpScrolling"],
Cell[99590, 3525, 206, 6, 16, "Index",
  CellTags->"VerticalScrollRange"],
Cell[99799, 3533, 210, 6, 16, "Index",
  CellTags->"HorizontalScrollRange"],
Cell[100012, 3541, 198, 6, 16, "Index",
  CellTags->"SpeedParameters"],
Cell[100213, 3549, 139, 2, 15, "Index",
  CellTags->"PrintingOptions->{...}"],
Cell[100355, 3553, 205, 6, 16, "Index",
  CellTags->"PaperOrientation"],
Cell[100563, 3561, 207, 6, 16, "Index",
  CellTags->"PrintCellBrackets"],
Cell[100773, 3569, 225, 6, 16, "Index",
  CellTags->"PrintSelectionHighlighting"],
Cell[101001, 3577, 217, 6, 16, "Index",
  CellTags->"PrintRegistrationMarks"],
Cell[101221, 3585, 229, 6, 16, "Index",
  CellTags->"PrintMultipleHorizontalPages"],
Cell[101453, 3593, 203, 6, 16, "Index",
  CellTags->"FirstPageHeader"],
Cell[101659, 3601, 203, 6, 16, "Index",
  CellTags->"FirstPageFooter"],
Cell[101865, 3609, 215, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[102083, 3617, 215, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[102301, 3625, 195, 6, 16, "Index",
  CellTags->"FacingPages"],
Cell[102499, 3633, 199, 6, 16, "Index",
  CellTags->"FirstPageFace"],
Cell[102701, 3641, 217, 6, 16, "Index",
  CellTags->"GraphicsPrintingFormat"],
Cell[102921, 3649, 199, 6, 16, "Index",
  CellTags->"Magnification"],
Cell[103123, 3657, 231, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneDensity"],
Cell[103357, 3665, 227, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[103587, 3673, 219, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[103809, 3681, 235, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[104047, 3689, 220, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[104270, 3697, 223, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[104496, 3705, 224, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[104723, 3713, 227, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[104953, 3721, 211, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[105167, 3729, 205, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[105375, 3737, 204, 6, 16, "Index",
  CellTags->"CellBackgroundHalftoneAngle"],
Cell[105582, 3745, 203, 6, 16, "Index",
  CellTags->"PageHeaderMargins"],
Cell[105788, 3753, 203, 6, 16, "Index",
  CellTags->"PageFooterMargins"],
Cell[105994, 3761, 149, 2, 15, "Index",
  CellTags->"IndexCreationOptions->{...}"],
Cell[106146, 3765, 191, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[106340, 3773, 193, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[106536, 3781, 206, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[106745, 3789, 198, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[106946, 3797, 201, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[107150, 3805, 194, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[107347, 3813, 193, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[107543, 3821, 145, 2, 15, "Index",
  CellTags->"CellBracketOptions->{...}"],
Cell[107691, 3825, 190, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[107884, 3833, 182, 6, 16, "Index",
  CellTags->"Color"],
Cell[108069, 3841, 186, 6, 16, "Index",
  CellTags->"Margins"],
Cell[108258, 3849, 184, 6, 16, "Index",
  CellTags->"Widths"],
Cell[108445, 3857, 147, 2, 15, "Index",
  CellTags->"CellElementSpacings->{...}"],
Cell[108595, 3861, 200, 6, 16, "Index",
  CellTags->"CellMinHeight"],
Cell[108798, 3869, 206, 6, 16, "Index",
  CellTags->"ClosedCellHeight"],
Cell[109007, 3877, 214, 6, 16, "Index",
  CellTags->"ClosedGroupTopMargin"],
Cell[109224, 3885, 145, 2, 15, "Index",
  CellTags->"PrivateCellOptions->{...}"],
Cell[109372, 3889, 197, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[109572, 3897, 201, 6, 16, "Index",
  CellTags->"Thickness"],
Cell[109776, 3905, 157, 2, 15, "Index",
  CellTags->"PrivateEvaluationOptions->{...}"],
Cell[109936, 3909, 225, 6, 16, "Index",
  CellTags->"OutputFormPageWidth\" "],
Cell[110164, 3917, 216, 6, 16, "Index",
  CellTags->"StoreInputForm\" "],
Cell[110383, 3925, 157, 2, 15, "Index",
  CellTags->"CommonDefaultFormatTypes->{...}"],
Cell[110543, 3929, 192, 6, 16, "Index",
  CellTags->"Text"],
Cell[110738, 3937, 194, 6, 16, "Index",
  CellTags->"Input"],
Cell[110935, 3945, 196, 6, 16, "Index",
  CellTags->"Output"],
Cell[111134, 3953, 204, 6, 16, "Index",
  CellTags->"TextInline"],
Cell[111341, 3961, 208, 6, 16, "Index",
  CellTags->"OutputInline"],
Cell[111552, 3969, 206, 6, 16, "Index",
  CellTags->"InputInline"],
Cell[111761, 3977, 137, 2, 15, "Index",
  CellTags->"FontVariations->{...}"],
Cell[111901, 3981, 182, 6, 16, "Index",
  CellTags->"Underline"],
Cell[112086, 3989, 178, 6, 16, "Index",
  CellTags->"Outline"],
Cell[112267, 3997, 176, 6, 16, "Index",
  CellTags->"Shadow"],
Cell[112446, 4005, 190, 6, 16, "Index",
  CellTags->"StrikeThrough"],
Cell[112639, 4013, 176, 6, 16, "Index",
  CellTags->"Masked"],
Cell[112818, 4021, 198, 6, 16, "Index",
  CellTags->"CompatibilityType"],
Cell[113019, 4029, 183, 6, 16, "Index",
  CellTags->"Masked"],
Cell[113205, 4037, 137, 2, 15, "Index",
  CellTags->"FontProperties->{...}"],
Cell[113345, 4041, 186, 6, 16, "Index",
  CellTags->"FontSerifed"],
Cell[113534, 4049, 192, 6, 16, "Index",
  CellTags->"FontMonospaced"],
Cell[113729, 4057, 145, 2, 15, "Index",
  CellTags->"PrivateFontOptions->{...}"],
Cell[113877, 4061, 208, 6, 16, "Index",
  CellTags->"FontPostScriptName"],
Cell[114088, 4069, 188, 6, 16, "Index",
  CellTags->"FontType"],
Cell[114279, 4077, 212, 6, 16, "Index",
  CellTags->"OperatorSubstitution"],
Cell[114494, 4085, 214, 6, 16, "Index",
  CellTags->"OperatorSubstitution"],
Cell[114711, 4093, 145, 2, 15, "Index",
  CellTags->"HyphenationOptions->{...}"],
Cell[114859, 4097, 210, 6, 16, "Index",
  CellTags->"HyphenationFreeZone"],
Cell[115072, 4105, 212, 6, 16, "Index",
  CellTags->"HyphenationCharacter"],
Cell[115287, 4113, 214, 6, 16, "Index",
  CellTags->"HyphenationMinLengths"],
Cell[115504, 4121, 139, 2, 15, "Index",
  CellTags->"SpellingOptions->{...}"],
Cell[115646, 4125, 188, 6, 16, "Index",
  CellTags->"AlwaysStop"],
Cell[115837, 4133, 188, 6, 16, "Index",
  CellTags->"AlwaysSkip"],
Cell[116028, 4141, 194, 6, 16, "Index",
  CellTags->"WordSplitting"],
Cell[116225, 4149, 149, 2, 15, "Index",
  CellTags->"SpellingDictionaries->{...}"],
Cell[116377, 4153, 202, 6, 16, "Index",
  CellTags->"CorrectWords"],
Cell[116582, 4161, 206, 6, 16, "Index",
  CellTags->"IncorrectWords"],
Cell[116791, 4169, 200, 6, 16, "Index",
  CellTags->"Suggestions"],
Cell[116994, 4177, 149, 2, 15, "Index",
  CellTags->"AdjustmentBoxOptions->{...}"],
Cell[117146, 4181, 204, 6, 16, "Index",
  CellTags->"AdjustmentBoxOptions"],
Cell[117353, 4189, 206, 6, 16, "Index",
  CellTags->"BoxBaselineShift"],
Cell[117562, 4197, 185, 3, 15, "Index",
  CellTags->"ButtonBoxOptions->{...}"],
Cell[117750, 4202, 188, 6, 16, "Index",
  CellTags->"ButtonStyle"],
Cell[117941, 4210, 194, 6, 16, "Index",
  CellTags->"ButtonFunction"],
Cell[118138, 4218, 196, 6, 16, "Index",
  CellTags->"ButtonEvaluator"],
Cell[118337, 4226, 190, 6, 16, "Index",
  CellTags->"ButtonSource"],
Cell[118530, 4234, 198, 8, 16, "Index",
  CellTags->"ButtonData"],
Cell[118731, 4244, 198, 8, 16, "Index",
  CellTags->"ButtonNote"],
Cell[118932, 4254, 200, 8, 16, "Index",
  CellTags->"ButtonFrame"],
Cell[119135, 4264, 189, 6, 16, "Index",
  CellTags->"ButtonBackground"],
Cell[119327, 4272, 204, 8, 16, "Index",
  CellTags->"ButtonMargins"],
Cell[119534, 4282, 208, 8, 16, "Index",
  CellTags->"ButtonMinHeight"],
Cell[119745, 4292, 210, 8, 16, "Index",
  CellTags->"ButtonExpandable"],
Cell[119958, 4302, 178, 6, 16, "Index",
  CellTags->"Active"],
Cell[120139, 4310, 143, 2, 15, "Index",
  CellTags->"CounterBoxOptions->{...}"],
Cell[120285, 4314, 191, 6, 16, "Index",
  CellTags->"CounterData"],
Cell[120479, 4322, 194, 6, 16, "Index",
  CellTags->"CounterStyle"],
Cell[120676, 4330, 193, 6, 16, "Index",
  CellTags->"CounterStyle"],
Cell[120872, 4338, 192, 6, 16, "Index",
  CellTags->"CounterStyle"],
Cell[121067, 4346, 198, 6, 16, "Index",
  CellTags->"CounterFunction"],
Cell[121268, 4354, 139, 2, 15, "Index",
  CellTags->"ValueBoxOptions->{...}"],
Cell[121410, 4358, 187, 6, 16, "Index",
  CellTags->"CounterStyle"],
Cell[121600, 4366, 190, 6, 16, "Index",
  CellTags->"CounterStyle"],
Cell[121793, 4374, 189, 6, 16, "Index",
  CellTags->"CounterStyle"],
Cell[121985, 4382, 151, 2, 15, "Index",
  CellTags->"OptionValueBoxOptions->{...}"],
Cell[122139, 4386, 197, 6, 16, "Index",
  CellTags->"CounterStyle"],
Cell[122339, 4394, 200, 6, 16, "Index",
  CellTags->"CounterStyle"],
Cell[122542, 4402, 199, 6, 16, "Index",
  CellTags->"CounterStyle"],
Cell[122744, 4410, 139, 2, 15, "Index",
  CellTags->"ErrorBoxOptions->{...}"],
Cell[122886, 4414, 184, 6, 16, "Index",
  CellTags->"AutoDelete"],
Cell[123073, 4422, 192, 6, 16, "Index",
  CellTags->"SaveAutoDelete"],
Cell[123268, 4430, 137, 2, 15, "Index",
  CellTags->"FormBoxOptions->{...}"],
Cell[123408, 4434, 180, 6, 16, "Index",
  CellTags->"AutoDelete"],
Cell[123591, 4442, 145, 2, 15, "Index",
  CellTags->"FractionBoxOptions->{...}"],
Cell[123739, 4446, 194, 6, 16, "Index",
  CellTags->"FractionLine"],
Cell[123936, 4454, 204, 6, 16, "Index",
  CellTags->"MultilineFunction"],
Cell[124143, 4462, 139, 2, 15, "Index",
  CellTags->"FrameBoxOptions->{...}"],
Cell[124285, 4466, 180, 6, 16, "Index",
  CellTags->"BoxFrame"],
Cell[124468, 4474, 184, 6, 16, "Index",
  CellTags->"BoxMargins"],
Cell[124655, 4482, 137, 2, 15, "Index",
  CellTags->"GridBoxOptions->{...}"],
Cell[124795, 4486, 180, 6, 16, "Index",
  CellTags->"GridFrame"],
Cell[124978, 4494, 194, 6, 16, "Index",
  CellTags->"GridFrameMargins"],
Cell[125175, 4502, 178, 6, 16, "Index",
  CellTags->"RowLines"],
Cell[125356, 4510, 184, 6, 16, "Index",
  CellTags->"ColumnLines"],
Cell[125543, 4518, 186, 6, 16, "Index",
  CellTags->"GridBaseline"],
Cell[125732, 4526, 182, 6, 16, "Index",
  CellTags->"AutoDelete"],
Cell[125917, 4534, 194, 6, 16, "Index",
  CellTags->"AutoDelete"],
Cell[126114, 4542, 184, 6, 16, "Index",
  CellTags->"RowSpacings"],
Cell[126301, 4550, 190, 6, 16, "Index",
  CellTags->"ColumnSpacings"],
Cell[126494, 4558, 186, 6, 16, "Index",
  CellTags->"ColumnWidths"],
Cell[126683, 4566, 188, 6, 16, "Index",
  CellTags->"RowAlignments"],
Cell[126874, 4574, 194, 6, 16, "Index",
  CellTags->"ColumnAlignments"],
Cell[127071, 4582, 188, 6, 16, "Index",
  CellTags->"RowsMinHeight"],
Cell[127262, 4590, 180, 6, 16, "Index",
  CellTags->"RowsEqual"],
Cell[127445, 4598, 186, 6, 70, "Index",
  CellTags->"ColumnsEqual"],
Cell[127634, 4606, 196, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[127833, 4614, 201, 6, 70, "Index",
  CellTags->"GridDefaultElement"],
Cell[128037, 4622, 157, 2, 70, "Index",
  CellTags->"InterpretationBoxOptions->{...}"],
Cell[128197, 4626, 204, 6, 70, "Index",
  CellTags->"TagStyle"],
Cell[128404, 4634, 198, 6, 70, "Index",
  CellTags->"TagStyle"],
Cell[128605, 4642, 202, 6, 70, "Index",
  CellTags->"Selectable"],
Cell[128810, 4650, 202, 6, 70, "Index",
  CellTags->"AutoDelete"],
Cell[129015, 4658, 212, 6, 70, "Index",
  CellTags->"DeletionWarning"],
Cell[129230, 4666, 202, 6, 70, "Index",
  CellTags->"SyntaxForm"],
Cell[129435, 4674, 143, 2, 70, "Index",
  CellTags->"RadicalBoxOptions->{...}"],
Cell[129581, 4678, 200, 6, 70, "Index",
  CellTags->"ExponentPosition"],
Cell[129784, 4686, 202, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[129989, 4694, 137, 2, 70, "Index",
  CellTags->"SqrtBoxOptions->{...}"],
Cell[130129, 4698, 196, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[130328, 4706, 147, 2, 70, "Index",
  CellTags->"SubscriptBoxOptions->{...}"],
Cell[130478, 4710, 201, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[130682, 4718, 157, 2, 70, "Index",
  CellTags->"SubsuperscriptBoxOptions->{...}"],
Cell[130842, 4722, 196, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[131041, 4730, 151, 2, 70, "Index",
  CellTags->"SuperscriptBoxOptions->{...}"],
Cell[131195, 4734, 203, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[131401, 4742, 135, 2, 70, "Index",
  CellTags->"TagBoxOptions->{...}"],
Cell[131539, 4746, 182, 6, 70, "Index",
  CellTags->"TagStyle"],
Cell[131724, 4754, 176, 6, 70, "Index",
  CellTags->"TagStyle"],
Cell[131903, 4762, 180, 6, 70, "Index",
  CellTags->"Selectable"],
Cell[132086, 4770, 180, 6, 70, "Index",
  CellTags->"AutoDelete"],
Cell[132269, 4778, 194, 6, 70, "Index",
  CellTags->"StripWrapperBoxes"],
Cell[132466, 4786, 190, 6, 70, "Index",
  CellTags->"DeletionWarning"],
Cell[132659, 4794, 180, 6, 70, "Index",
  CellTags->"SyntaxForm"],
Cell[132842, 4802, 151, 2, 70, "Index",
  CellTags->"UnderScriptBoxOptions->{...}"],
Cell[132996, 4806, 208, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[133207, 4814, 213, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[133423, 4822, 208, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[133634, 4830, 149, 2, 70, "Index",
  CellTags->"OverScriptBoxOptions->{...}"],
Cell[133786, 4834, 206, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[133995, 4842, 211, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[134209, 4850, 206, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[134418, 4858, 159, 2, 70, "Index",
  CellTags->"UnderoverscriptBoxOptions->{...}"],
Cell[134580, 4862, 208, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[134791, 4870, 213, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[135007, 4878, 208, 6, 70, "Index",
  CellTags->"MultilineFunction"],
Cell[135218, 4886, 214, 6, 70, "Index",
  CellTags->"GridDefaultElement"],
Cell[135435, 4894, 201, 6, 70, "Index",
  CellTags->"GridBaseline"],
Cell[135639, 4902, 197, 6, 70, "Index",
  CellTags->"AutoDelete"],
Cell[135839, 4910, 200, 6, 70, "Index",
  CellTags->"RowAlignments"],
Cell[136042, 4918, 196, 6, 70, "Index",
  CellTags->"RowSpacings"],
Cell[136241, 4926, 192, 6, 70, "Index",
  CellTags->"RowsEqual"],
Cell[136436, 4934, 200, 6, 70, "Index",
  CellTags->"RowsMinHeight"],
Cell[136639, 4942, 209, 6, 70, "Index",
  CellTags->"ColumnAlignments"],
Cell[136851, 4950, 205, 6, 70, "Index",
  CellTags->"ColumnSpacings"],
Cell[137059, 4958, 201, 6, 70, "Index",
  CellTags->"ColumnsEqual"],
Cell[137263, 4966, 201, 6, 70, "Index",
  CellTags->"ColumnWidths"],
Cell[137467, 4974, 199, 6, 70, "Index",
  CellTags->"RowLines"],
Cell[137669, 4982, 205, 6, 70, "Index",
  CellTags->"ColumnLines"],
Cell[137877, 4990, 201, 6, 70, "Index",
  CellTags->"GridFrame"],
Cell[138081, 4998, 215, 6, 70, "Index",
  CellTags->"GridFrameMargins"],
Cell[138299, 5006, 228, 6, 70, "Index",
  CellTags->"CounterIncrements"],
Cell[138530, 5014, 230, 6, 70, "Index",
  CellTags->"CounterAssignments"],
Cell[138763, 5022, 240, 6, 70, "Index",
  CellTags->"InlineCounterIncrements"],
Cell[139006, 5030, 243, 6, 70, "Index",
  CellTags->"InlineCounterAssignments "],
Cell[139252, 5038, 206, 6, 70, "Index",
  CellTags->"CounterStyle"],
Cell[139461, 5046, 212, 6, 70, "Index",
  CellTags->"CounterFunction"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

