(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     53513,       1756]*)
(*NotebookOutlinePosition[     78928,       2331]*)
(*  CellTagsIndexPosition[     76719,       2274]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Convert To ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["InputForm", "Command",
  CellTags->"ConvertToInputForm"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To InputForm", "SR"],
  " converts the selection to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["InputForm", "MR"],
  ". "
}], "Usage",
  CellTags->"ConvertToInputForm"],

Cell[TextData[{
  "\[FilledSmallSquare] The expression is regenerated in the specified format \
type by the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "kernel. Syntactically incorrect expressions will generate an error.\n\
\[FilledSmallSquare] This command requires a kernel to convert ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  " or ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  " cells.\n\[FilledSmallSquare] The conversion process will remove any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " comments in the cell.\n\[FilledSmallSquare] This command can convert \
PostScript, PICT, and Bitmap graphics into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics primitives.\n\[FilledSmallSquare] This command can convert \
sounds into a list of numbers (samples) in the form of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list."
}], "Notes",
  CellTags->"ConvertToInputForm"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"ConvertToInputForm"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]\[KeyBar]\[ControlKey]\[LeftModified]", 
    "C1"],
  StyleBox["i", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["i", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[KeyBar]\[ControlKey]\[LeftModified]", 
    "C1"],
  StyleBox["i", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ConvertToInputForm"],

Cell["OutputForm", "Command",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To OutputForm", "SR"],
  " converts the selection to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["OutputForm", "MR"],
  "."
}], "Usage",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] The expression is regenerated in the specified format \
type by the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "kernel. Syntactically incorrect expressions will generate an error.\n\
\[FilledSmallSquare] This command requires a kernel.\n\[FilledSmallSquare] \
The conversion process will remove any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " comments in the cell.\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],

Cell["StandardForm", "Command",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to StandardForm", "SR"],
  " converts the selection to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  "."
}], "Usage",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] When this command is applied to a text selection, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " creates an inline cell."
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] The expression is regenerated in the specified format \
type by the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "kernel. Syntactically incorrect expressions will generate an error.\n\
\[FilledSmallSquare] This command requires a kernel.\n\[FilledSmallSquare] \
The conversion process will remove any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " comments in the cell.\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["n", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["n", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[KeyBar]\[ControlKey]\[LeftModified]", 
    "C1"],
  StyleBox["n", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ConvertToStandardForm"],

Cell["TraditionalForm", "Command",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to TraditionalForm", "SR"],
  " converts the selection to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "Usage",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] When this command is applied to a text selection, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " creates an inline cell."
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] The expression is regenerated in the specified format \
type by the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "kernel. Syntactically incorrect expressions will generate an error.\n\
\[FilledSmallSquare] This command requires a kernel.\n\[FilledSmallSquare] \
The conversion process will remove any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " comments in the cell.\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["t", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["t", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  StyleBox[" \[ShiftKey]\[KeyBar]\[KeyBar]\[ControlKey]\[LeftModified]", 
    "C1"],
  StyleBox["t", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ConvertToTraditionalForm"],

Cell["PostScript", "Command",
  CellTags->{"SelectionConvert", "PostScript"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To PostScript", "SR"],
  " converts the selected cell(s) to PostScript format."
}], "Usage",
  CellTags->"PostScript"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells. (Macintosh only.)"], "Notes",
  CellTags->"PostScript"],

Cell["Bitmap", "Command",
  CellTags->{"SelectionConvert", "Bitmap"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to Bitmap", "SR"],
  " converts the selected cell(s) to a platform-independent bitmap format."
}], "Usage",
  CellTags->"Bitmap"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells. (Macintosh only.)"], "Notes",
  CellTags->"Bitmap"],

Cell["Metafile", "Command",
  CellTags->{"SelectionConvert", "Metafile"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To Metafile", "SR"],
  " converts the selected cell(s) to Metafile format. (Windows only.)"
}], "Usage",
  CellTags->"Metafile"],

Cell["PICT", "Command",
  CellTags->{"SelectionConvert", "PICT"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to PICT ", "SR"],
  "converts the selected cell(s) to Macintosh QuickDraw/PICT format.",
  " ",
  "(Macintosh only.)"
}], "Usage",
  CellTags->"PICT"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells."], "Notes",
  CellTags->"PICT"],

Cell["BitmapPICT", "Command",
  CellTags->{"SelectionConvert", "PICTBitmap"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to BitmapPICT", "SR"],
  " converts the selected cell(s) to Macintosh QuickDraw/PICT format \
containing a bitmap of the cell. (Macintosh only.)"
}], "Usage",
  CellTags->"PICTBitmap"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells."], "Notes",
  CellTags->"PICTBitmap"],

Cell["Embedded PS PICT", "Command",
  CellTags->{"SelectionConvert", "PICTEmbeddedPS"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To Embedded PS PICT ", "SR"],
  "converts the selected cell(s) to Macintosh QuickDraw/PICT format \
containing an embedded PostScript version of the cell. (Macintosh only.)"
}], "Usage",
  CellTags->"PICTEmbeddedPS"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells."], "Notes",
  CellTags->"PICTEmbeddedPS"],

Cell["QuickTime", "Command",
  CellTags->{"SelectionConvert", "QuickTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To QuickTime", "SR"],
  " converts the selected sequence of graphics cells into a Macintosh \
QuickTime animation. (Macintosh only.)"
}], "Usage",
  CellTags->"QuickTime"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Display As ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["Text", "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Display As Text", "SR"],
  " displays the selection as plain text without interpreting it."
}], "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],

Cell["\<\
\[FilledSmallSquare] Reinterprets the selection as plain text form \
without changing it.
\[FilledSmallSquare] If the cell contains structured typeset expressions \
(fractions, superscripts, and so on), they are converted to linear syntax \
notation, not to InputForm as is done by the commands in the Convert To \
submenu.\
\>", "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],

Cell["InputForm", "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Display As InputForm", "SR"],
  " displays the selection in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["InputForm", "MR"],
  " without interpreting it."
}], "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the cell contains structured typeset expressions \
(fractions, superscripts, and so on), they are converted to linear syntax \
notation, not to InputForm as is done by the commands in the Convert To \
submenu.\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],

Cell["StandardForm", "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Display As StandardForm", "SR"],
  " displays the selection in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the cell contains expressions such as fractions or \
powers, they are not converted to structured typeset form, as would be done \
by items in the Convert To submenu.\n\[FilledSmallSquare] See Reference \
Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],

Cell["TraditionalForm", "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Display As TraditionalForm", "SR"],
  " displays the selection in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the cell contains expressions such as fractions or \
powers, they are not converted to structured typeset form, as would be done \
by items in the Convert To submenu.\n\[FilledSmallSquare] See Reference \
Guide: ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Default Input FormatType ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["InputForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Input FormatType InputForm", "SR"],
  " sets the default for newly created Input cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["InputForm", "MR"],
  ". "
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is used when you create a new cell by \
typing, when the selection is a cell insertion point.\n\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Input\"\[Rule]InputForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],

Cell["StandardForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Input FormatType StandardForm ", "SR"],
  "sets the default for newly created Input cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is used when you create a new cell by \
typing, when the selection is a cell insertion point.\n\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Input\"\[Rule]StandardForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],

Cell["TraditionalForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Input FormatType TraditionalForm", "SR"],
  " sets the default for newly created Input cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is used when you create a new cell by \
typing, when the selection is a cell insertion point.\n\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Input\"\[Rule]TraditionalForm} ", "MR"],
  "on",
  StyleBox[" $FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Default Output FormatType ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["OutputForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Output FormatType OutputForm", "SR"],
  " sets the default for newly created Output cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["OutputForm", "MR"],
  ". "
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Output\"\[Rule]OutputForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],

Cell["InputForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Output FormatType InputForm", "SR"],
  " sets the default for newly created Output cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["InputForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Output\"\[Rule]InputForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],

Cell["StandardForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Output FormatType StandardForm", "SR"],
  " sets the default for newly created Output cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Output\"\[Rule]StandardForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],

Cell["TraditionalForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Output FormatType TraditionalForm", "SR"],
  " sets the default for Output cells to",
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Output\"\[Rule]TraditionalForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Default Inline FormatType ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["StandardForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Inline FormatType StandardForm", "SR"],
  " sets the default for newly created inline text cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"TextInline\"\[Rule]StandardForm}", 
    "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],

Cell["TraditionalForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Inline FormatType TraditionalForm", "SR"],
  " sets the default for newly created inline text cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"TextInline\"\[Rule]TraditionalForm}", 
    "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Cell Properties ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["Cell Open", "Command",
  CellTags->"CellOpen"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Open", "SR"],
  " toggles a cell between open and closed. "
}], "Usage",
  CellTags->"CellOpen"],

Cell[TextData[{
  "\[FilledSmallSquare] When closed, a cell's contents are hidden.\n\
\[FilledSmallSquare] This command toggles the option ",
  StyleBox["CellOpen", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected cell objects."
}], "Notes",
  CellTags->"CellOpen"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Open/Close Group",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"CellOpen"],

Cell["Cell Editable", "Command",
  CellTags->"Editable"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Editable", "SR"],
  " toggles whether a cell can be edited."
}], "Usage",
  CellTags->"Editable"],

Cell[TextData[{
  "\[FilledSmallSquare] When a cell is uneditable, the letter \"X\" appears \
in the cell bracket.\n\[FilledSmallSquare] This command toggles the option ",
  StyleBox["Editable", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected cell objects."
}], "Notes",
  CellTags->"Editable"],

Cell["Cell Edit Duplicate", "Command",
  CellTags->"CellEditDuplicate"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Edit Duplicate", "SR"],
  " causes a new cell to be created whenever the selected cell is edited. "
}], "Usage",
  CellTags->"CellEditDuplicate"],

Cell[TextData[{
  "\[FilledSmallSquare] Typically a property of output cells.\n\
\[FilledSmallSquare] This command toggles the option ",
  StyleBox["CellEditDuplicate", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected cell objects."
}], "Notes",
  CellTags->"CellEditDuplicate"],

Cell["Cell Evaluatable", "Command",
  CellTags->"Evaluatable"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Evaluatable", "SR"],
  " toggles a cell between evaluatable and unevaluatable. Only evaluatable \
cells can be sent to the kernel. "
}], "Usage",
  CellTags->"Evaluatable"],

Cell[TextData[{
  "\[FilledSmallSquare] When a cell is unevaluatable, a horizontal dash (-) \
appears in the cell bracket.\n\[FilledSmallSquare] This command toggles the \
option ",
  StyleBox["Evaluatable", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected cell objects."
}], "Notes",
  CellTags->"Evaluatable"],

Cell["Cell Active", "Command",
  CellTags->"Active"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Active", "SR"],
  " toggles a cell between active and inactive state."
}], "Usage",
  CellTags->"Active"],

Cell["\<\
\[FilledSmallSquare] Palette buttons within active cells carry out \
their script when clicked, while buttons inside inactive cells can be edited.\
\
\>", "Notes",
  CellTags->"Active"],

Cell[TextData[{
  "\[FilledSmallSquare] When a cell is active, the letter \
\[OpenCurlyDoubleQuote]A\[CloseCurlyDoubleQuote] appears in the cell bracket.\
\n\[FilledSmallSquare] This command toggles the option ",
  StyleBox["Active",
    FontFamily->"Courier"],
  " between ",
  StyleBox["True",
    FontFamily->"Courier"],
  " and ",
  StyleBox["False",
    FontFamily->"Courier"],
  " on the selected cell objects."
}], "Notes",
  CellTags->"Active"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.3.6",
    ButtonData:>{"1.3.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"Active"],

Cell["Initialization Cell", "Command",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Initialization Cell", "SR"],
  " makes a cell auto-evaluate whenever the notebook is opened."
}], "Usage",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] When a cell is an initialization cell, a vertical \
tick mark (|) appears in the cell bracket.\n\[FilledSmallSquare]",
  " ",
  "The ",
  StyleBox["Initialization Cell", "SR"],
  " command toggles the option ",
  StyleBox["InitializationCell", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected Cell objects."
}], "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The option ",
  StyleBox["InitializationCellLoading", "MR"],
  ", set at the notebook level, determines when the initialization cells in a \
notebook are evaluated.\n   ",
  StyleBox["InitializationCellLoading \[Rule] True", "MR"],
  " evaluates initialization cells when the notebook is opened.\n   ",
  StyleBox["InitializationCellLoading \[Rule] False", "MR"],
  " tells ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " not to evaluate initialization cells.\n   ",
  StyleBox["InitializationCellLoading \[Rule] Automatic", "MR"],
  " loads the initialization cells only when you first do an evaluation \
within the notebook."
}], "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The option ",
  StyleBox["InitializationCellWarning", "MR"],
  " determines whether you get a dialog box confirming that you want to \
evaluate the initialization cells, at the time determined by ",
  StyleBox["InitializationCellLoading", "MR"],
  ". A dialog box will appear if ",
  StyleBox["InitializationCellWarning", "MR"],
  " is set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  " at either the notebook or global level. This provides a level of \
security, because an individual notebook cannot cause initialization cells to \
be loaded silently, unless ",
  StyleBox["InitializationCellWarning", "MR"],
  " is set to ",
  StyleBox["False",
    FontFamily->"Courier"],
  " at the global level."
}], "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can evaluate the initialization cells manually at \
any time by choosing ",
  StyleBox["Evaluate Initialization", "SR"],
  " from the Evaluation submenu of the Kernel menu."
}], "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Cell Grouping ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["Group Cells", "Command",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Group Cells ", "SR"],
  "makes a group out of the selected sequence of cells. "
}], "Usage",
  CellTags->"CellGroup"],

Cell["\<\
\[FilledSmallSquare] This command is only available when cell \
grouping is set to Manual.
\[FilledSmallSquare] The grouping of cells is indicated by nested brackets on \
the right of the notebook.\
\>", "Notes",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] When you use ",
  StyleBox["Group Cells", "SR"],
  " on a selection in which the beginning cells are already grouped, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " incorporates the remaining ungrouped cells into the existing group."
}], "Notes",
  CellTags->"CellGroup"],

Cell[TextData[
"\[FilledSmallSquare] A cell cannot be the first cell in more than one group \
at the same time."], "Notes",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.3.5",
    ButtonData:>{"1.3.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["g", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["g", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["g", "C1MR"],
  StyleBox["\[RightModified]", "C1"],
  " ",
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellGroup"],

Cell["Ungroup Cells", "Command",
  CellTags->"CellUnGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Ungroup Cells", "SR"],
  " ungroups the selected sequence of cells."
}], "Usage",
  CellTags->"CellUnGroup"],

Cell["\<\
\[FilledSmallSquare] This command is only available when cell \
grouping is set to Manual.
\[FilledSmallSquare] When there are subgroups within the selection, they are \
left as is.\
\>", "Notes",
  CellTags->"CellUnGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] If the selection is a range of cells at the bottom of \
a grouping, but not the whole group, ",
  StyleBox["Ungroup Cells", "SR"],
  " removes those cells from the group, but does not destroy the whole \
group."
}], "Notes",
  CellTags->"CellUnGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["u", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["u", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["u", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellUngroup"],

Cell["Manual Grouping", "Command",
  CellTags->"CellGroupingManual"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Manual Grouping", "SR"],
  " lets you group cells by hand."
}], "Usage",
  CellTags->"CellGroupingManual"],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  "This command sets the option ",
  StyleBox["CellGrouping \[Rule] Manual", "MR"],
  " on the selected notebook.\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["CellGrouping",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"CellGroupingManual"],

Cell["Automatic Grouping", "Command",
  CellTags->"CellGroupingAutomatic"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Automatic Grouping", "SR"],
  " automatically creates hierarchical cell groups on the basis of cell \
style."
}], "Usage",
  CellTags->"CellGroupingAutomatic"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Automatic Grouping",
    FontFamily->"Helvetica"],
  " varies in its treatment of different kinds of cells. Input cells, for \
example, form groups automatically only when followed by Output cells. \
Graphics cells form groups automatically only when followed by other Graphics \
cells. \n\[FilledSmallSquare] The grouping behavior of cells is controlled by \
the ",
  StyleBox["CellGroupingRules", "MR"],
  " option.\n\[FilledSmallSquare] Any groups you have created manually will \
be ignored when ",
  StyleBox["Automatic Grouping",
    FontFamily->"Helvetica"],
  " is selected.\n\[FilledSmallSquare] This command sets the option ",
  StyleBox["CellGrouping \[Rule] Automatic", "MR"],
  " on the selected notebook."
}], "Notes",
  CellTags->"CellGroupingAutomatic"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["CellGrouping",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"CellGroupingAutomatic"],

Cell["Open All Subgroups", "Command",
  CellTags->"SelectionOpenAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open All Subgroups", "SR"],
  " opens all groups in the current selection."
}], "Usage",
  CellTags->"SelectionOpenAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["{", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["{", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh);", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["{", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SelectionOpenAllGroups"],

Cell["Close All Subgroups", "Command",
  CellTags->"SelectionCloseAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Close All Subgroups", "SR"],
  " closes all groups in the current selection."
}], "Usage",
  CellTags->"SelectionCloseAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["}", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["}", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh);", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["}", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SelectionCloseAllGroups"],

Cell["Open/Close Group", "Command",
  CellTags->"OpenCloseGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open/Close Group", "SR"],
  " toggles a cell group between open and closed. Closing a group collapses \
all cells in the group so that only the head cell is visible."
}], "Usage",
  CellTags->"OpenCloseGroup"],

Cell["\<\
\[FilledSmallSquare] You can also open or close a group of cells by \
double-clicking the bracket that spans a group of cells.\
\>", "Notes",
  CellTags->"OpenCloseGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["'", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["'", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["'", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"OpenCloseGroup"],

Cell["Divide Cell", "Command",
  CellTags->"CellSplit"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Divide Cell", "SR"],
  " splits a cell at the current insertion point. "
}], "Usage",
  CellTags->"CellSplit"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "This command splits the selected cell into two or three cells, depending \
on the current text selection. "
}], "Notes",
  CellTags->"CellSplit"],

Cell["\<\
\[FilledSmallSquare] An insertion point divides the cell in two. A \
text selection divides the cell into three cells: everything before the \
beginning of the selection, the selection itself, and everything after the \
end of the selection.\
\>", "Notes",
  CellTags->"CellSplit"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["d", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["d", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["d", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellSplit"],

Cell["Merge Cells", "Command",
  CellTags->"CellMerge"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Merge Cells", "SR"],
  " combines the selected sequence of cells into one cell. "
}], "Usage",
  CellTags->"CellMerge"],

Cell["\<\
\[FilledSmallSquare] If the selection contains a mixture of text \
and typeset or graphics cells, the result is a text cell with inline typeset \
and/or graphics cells.\
\>", "Notes",
  CellTags->"CellMerge"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["m", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["m", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["m", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellMerge"],

Cell["Animate Selected Graphics", "Command",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Animate Selected Graphics", "SR"],
  " animates graphics in the current selection, typically a cell group."
}], "Usage",
  CellTags->"SelectionAnimate"],

Cell["\<\
\[FilledSmallSquare] The animation is displayed in the position of \
the first graphics cell; you may need to scroll to make the first graphics \
cell visible.\
\>", "Notes",
  CellTags->"SelectionAnimate"],

Cell[TextData[
"\[FilledSmallSquare] Double-clicking a graphic in a group of cells also \
starts the animation."], "Notes",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  StyleBox[" ",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SelectionAnimate"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Animation Controls and Settings",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] To stop the animation, click anywhere in the notebook \
or press any key. When the animation starts, a palette of speed and direction \
control buttons appears in the notebook window.\n\[FilledSmallSquare] These \
buttons set the options ",
  StyleBox["AnimationDisplayTime", "MR"],
  " and ",
  StyleBox["AnimationCycleOffset", "MR"],
  " on the selected cell objects."
}], "Notes",
  CellTags->"SelectionAnimate"],

Cell["\<\
\[FilledSmallSquare] You can also use the following keyboard \
commands:\
\>", "Notes",
  CellTags->"SelectionAnimate"],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["\(Run\\ animation\\ forward\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "\[Rule]"},
            {
              StyleBox["\(Run\\ animation\\ backward\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "\( \[LeftArrow] \\ \)"},
            {
              StyleBox["\(Move\\ one\\ frame\\ forward, \\ stop\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "\[DownArrow]"},
            {
              RowBox[{
                StyleBox["\(Move\\ one\\ frame\\ backward\)",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Roman",
                  FontSlant->"Plain",
                  FontTracking->"Plain",
                  PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                StyleBox[",",
                  FontFamily->"Helvetica",
                  FontSize->9], 
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontSize->9], 
                StyleBox["stop",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Roman"]}], "\[UpArrow]"},
            {
              StyleBox["\(Run\\ animation\\ cyclically\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "c"},
            {
              StyleBox["\(Speed\\ up\\ animation\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], ">"},
            {
              StyleBox["\(Slow\\ down\\ animation\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "<"},
            {
              StyleBox["\(Set\\ animation\\ speed\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              RowBox[{
                RowBox[{
                  StyleBox["1",
                    FontFamily->"Helvetica",
                    FontSize->9], 
                  StyleBox["\((slow)\)",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    PrivateFontOptions->{"FontPostScriptName"->Automatic}]}], 
                
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Roman",
                  FontSlant->"Plain",
                  FontTracking->"Plain",
                  PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                StyleBox["-",
                  FontFamily->"Helvetica",
                  FontSize->9], 
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontSize->9], 
                RowBox[{
                  StyleBox["9",
                    FontFamily->"Helvetica",
                    FontSize->9], 
                  StyleBox[" ",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                  StyleBox["\((fast)\)",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    PrivateFontOptions->{
                    "FontPostScriptName"->Automatic}]}]}]},
            {
              StyleBox["\(Stop\\ animation\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              StyleBox["\(any\\ key\\ press\\ or\\ mouse\\ click\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  ShowCellBracket->False,
  AutoSpacing->False,
  CellTags->"SelectionAnimate"],

Cell["Play Sound", "Command",
  CellTags->"SoundPlay"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Play Sound", "SR"],
  " plays sounds in the selected cells."
}], "Usage",
  CellTags->"SoundPlay"],

Cell[TextData[
"\[FilledSmallSquare] You can also play a sound by double-clicking the \
speaker-shaped icon at the top of the cell's bracket. "], "Notes",
  CellTags->"SoundPlay"],

Cell[TextData[
"\[FilledSmallSquare] If the sound is not part of an animation, \
double-clicking the sound graphic itself plays the sound repeatedly in a \
loop. To interrupt the loop, click outside the sound cell."], "Notes",
  CellTags->"SoundPlay"],

Cell["Rerender Graphics", "Command",
  CellTags->"GraphicsRender"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Rerender Graphics", "SR"],
  " rerenders the selected graphics. This command renders all the selected \
cells that contain PostScript graphics."
}], "Usage",
  CellTags->"GraphicsRender"],

Cell[TextData[
"\[FilledSmallSquare] You might need to use this command if the graphics \
cells were previously rendered with different screen settings."], "Notes",
  CellTags->"GraphicsRender"],

Cell["Rerender and Save Graphics", "Command",
  CellTags->"GenerateImageCaches"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Rerender and Save Graphics", "SR"],
  " generates and saves image caches for all graphics cells."
}], "Usage",
  CellTags->"GenerateImageCaches"],

Cell["Make Standard Size", "Command",
  CellTags->"GraphicsOriginalSize"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Make Standard Size", "SR"],
  " restores graphics to the default size."
}], "Usage",
  CellTags->"GraphicsOriginalSize"],

Cell[TextData[{
  "\[FilledSmallSquare] For PICT, QuickTime, and Bitmap graphics, the graphic \
itself defines its normal size (Macintosh only). For PostScript graphics, the \
standard size is determined by the aspect ratio defined within the graphic, \
or by the BoundingBox PostScript comment, if present.\n\[FilledSmallSquare] \
This command sets the option ",
  StyleBox["ImageSize", "MR"],
  " on the selected cell objects."
}], "Notes",
  CellTags->"GraphicsOriginalSize"],

Cell["Align Selected Graphics...", "Command",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Align Selected Graphics", "SR"],
  " makes selected graphics cells line up with the first graphic in the \
selection."
}], "Usage",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell["\<\
\[FilledSmallSquare] In the dialog box, specify which edges of the \
graphics (left, right, top, or bottom) you want aligned. Specified edges are \
aligned with those of the first selected graphics cell.\
\>", "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell["\<\
\[FilledSmallSquare] When left and right are specified, all \
graphics are set to the same width. When top and bottom are specified, all \
graphics are made the same height. When all four edges are specified, all \
graphics are made the same size.\
\>", "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell[TextData[{
  "\[FilledSmallSquare] This command is useful for aligning animated \
graphics.\n\[FilledSmallSquare] This command sets the options ",
  StyleBox["ImageSize", "MR"],
  " and ",
  StyleBox["ImageMargins", "MR"],
  " on the selected cell objects."
}], "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell["Cell Size Statistics...", "Command",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Size Statistics", "SR"],
  " gives statistics for cells within the current notebook."
}], "Usage",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell[CellGroupData[{

Cell["Total Bytes", "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell["Includes overhead for cell data structures.", "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Content Bytes", "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell["\<\
Gives the size of text data only. This corresponds to a character \
count of the text.\
\>", "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reflect Sharing", "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell[TextData[{
  "Specifies whether information that is shared by more than one cell should \
be counted. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " stores only one copy of a given token (variable name, and so on), even if \
it is used many times. Therefore, it is not possible to assign the memory \
used by shared objects to any particular cell. If \"Reflect Sharing\" is off, \
all memory will be counted as if it were not shared, which will over-count \
the actual memory being used. If \"Reflect Sharing\" is on, each cell will be \
assigned the memory used by the token divided by the number of times the \
token is shared."
}], "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{0, 1110}, {0, 746}},
WindowToolbars->{},
WindowSize->{528, 551},
WindowMargins->{{Automatic, 39}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ConvertToInputForm"->{
    Cell[1873, 59, 62, 1, 32, "Command",
      CellTags->"ConvertToInputForm"],
    Cell[1938, 62, 261, 10, 31, "Usage",
      CellTags->"ConvertToInputForm"],
    Cell[2202, 74, 970, 25, 144, "Notes",
      CellTags->"ConvertToInputForm"],
    Cell[3175, 101, 175, 6, 24, "Notes",
      CellTags->"ConvertToInputForm"],
    Cell[3353, 109, 682, 20, 24, "Notes",
      CellTags->"ConvertToInputForm"]},
  "SelectionConvert"->{
    Cell[4038, 131, 86, 1, 32, "Command",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[4127, 134, 285, 10, 31, "Usage",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[4415, 146, 616, 15, 106, "Notes",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[5034, 163, 90, 1, 32, "Command",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5127, 166, 291, 10, 31, "Usage",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5421, 178, 245, 6, 24, "Notes",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5669, 186, 620, 15, 106, "Notes",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[7014, 226, 96, 1, 32, "Command",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7113, 229, 301, 10, 31, "Usage",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7417, 241, 248, 6, 24, "Notes",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7668, 249, 626, 15, 106, "Notes",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[9016, 288, 77, 1, 32, "Command",
      CellTags->{"SelectionConvert", "PostScript"}],
    Cell[9445, 303, 69, 1, 32, "Command",
      CellTags->{"SelectionConvert", "Bitmap"}],
    Cell[9873, 318, 73, 1, 32, "Command",
      CellTags->{"SelectionConvert", "Metafile"}],
    Cell[10143, 328, 65, 1, 32, "Command",
      CellTags->{"SelectionConvert", "PICT"}],
    Cell[10568, 345, 77, 1, 32, "Command",
      CellTags->{"SelectionConvert", "PICTBitmap"}],
    Cell[11045, 361, 87, 1, 32, "Command",
      CellTags->{"SelectionConvert", "PICTEmbeddedPS"}],
    Cell[11568, 377, 75, 1, 32, "Command",
      CellTags->{"SelectionConvert", "QuickTime"}]},
  "ConvertToOutputForm"->{
    Cell[4038, 131, 86, 1, 32, "Command",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[4127, 134, 285, 10, 31, "Usage",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[4415, 146, 616, 15, 106, "Notes",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}]},
  "ConvertToStandardForm"->{
    Cell[5034, 163, 90, 1, 32, "Command",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5127, 166, 291, 10, 31, "Usage",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5421, 178, 245, 6, 24, "Notes",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5669, 186, 620, 15, 106, "Notes",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[6292, 203, 719, 21, 24, "Notes",
      CellTags->"ConvertToStandardForm"]},
  "ConvertToTraditionalForm"->{
    Cell[7014, 226, 96, 1, 32, "Command",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7113, 229, 301, 10, 31, "Usage",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7417, 241, 248, 6, 24, "Notes",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7668, 249, 626, 15, 106, "Notes",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[8297, 266, 716, 20, 24, "Notes",
      CellTags->"ConvertToTraditionalForm"]},
  "PostScript"->{
    Cell[9016, 288, 77, 1, 32, "Command",
      CellTags->{"SelectionConvert", "PostScript"}],
    Cell[9096, 291, 181, 5, 31, "Usage",
      CellTags->"PostScript"],
    Cell[9280, 298, 162, 3, 24, "Notes",
      CellTags->"PostScript"]},
  "Bitmap"->{
    Cell[9445, 303, 69, 1, 32, "Command",
      CellTags->{"SelectionConvert", "Bitmap"}],
    Cell[9517, 306, 192, 5, 31, "Usage",
      CellTags->"Bitmap"],
    Cell[9712, 313, 158, 3, 24, "Notes",
      CellTags->"Bitmap"]},
  "Metafile"->{
    Cell[9873, 318, 73, 1, 32, "Command",
      CellTags->{"SelectionConvert", "Metafile"}],
    Cell[9949, 321, 191, 5, 31, "Usage",
      CellTags->"Metafile"]},
  "PICT"->{
    Cell[10143, 328, 65, 1, 32, "Command",
      CellTags->{"SelectionConvert", "PICT"}],
    Cell[10211, 331, 213, 7, 47, "Usage",
      CellTags->"PICT"],
    Cell[10427, 340, 138, 3, 24, "Notes",
      CellTags->"PICT"]},
  "PICTBitmap"->{
    Cell[10568, 345, 77, 1, 32, "Command",
      CellTags->{"SelectionConvert", "PICTBitmap"}],
    Cell[10648, 348, 247, 6, 47, "Usage",
      CellTags->"PICTBitmap"],
    Cell[10898, 356, 144, 3, 24, "Notes",
      CellTags->"PICTBitmap"]},
  "PICTEmbeddedPS"->{
    Cell[11045, 361, 87, 1, 32, "Command",
      CellTags->{"SelectionConvert", "PICTEmbeddedPS"}],
    Cell[11135, 364, 279, 6, 47, "Usage",
      CellTags->"PICTEmbeddedPS"],
    Cell[11417, 372, 148, 3, 24, "Notes",
      CellTags->"PICTEmbeddedPS"]},
  "QuickTime"->{
    Cell[11568, 377, 75, 1, 32, "Command",
      CellTags->{"SelectionConvert", "QuickTime"}],
    Cell[11646, 380, 234, 6, 47, "Usage",
      CellTags->"QuickTime"]},
  "SelectionDisplayAs"->{
    Cell[12014, 397, 80, 1, 32, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[12097, 400, 216, 5, 31, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[12316, 407, 405, 8, 62, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[12724, 417, 86, 1, 32, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[12813, 420, 308, 10, 31, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[13124, 432, 434, 9, 62, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[13561, 443, 92, 1, 32, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[13656, 446, 294, 10, 31, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[13953, 458, 399, 9, 62, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[14355, 469, 98, 1, 32, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
    Cell[14456, 472, 303, 10, 31, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
    Cell[14762, 484, 405, 9, 62, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}]},
  "DisplayAsTextForm"->{
    Cell[12014, 397, 80, 1, 32, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[12097, 400, 216, 5, 31, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[12316, 407, 405, 8, 62, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}]},
  "DisplayAsInputForm"->{
    Cell[12724, 417, 86, 1, 32, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[12813, 420, 308, 10, 31, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[13124, 432, 434, 9, 62, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}]},
  "DisplayAsStandardForm"->{
    Cell[13561, 443, 92, 1, 32, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[13656, 446, 294, 10, 31, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[13953, 458, 399, 9, 62, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}]},
  "DisplayAsTraditionalForm"->{
    Cell[14355, 469, 98, 1, 32, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
    Cell[14456, 472, 303, 10, 31, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
    Cell[14762, 484, 405, 9, 62, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}]},
  "MenuListCommonDefaultFormatTypesInputInput"->{
    Cell[15315, 504, 86, 1, 32, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
    Cell[15404, 507, 323, 10, 47, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
    Cell[15730, 519, 523, 14, 84, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesInputInput"]},
  "MenuListCommonDefaultFormatTypesInputStandard"->{
    Cell[16256, 535, 92, 1, 32, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
    Cell[16351, 538, 331, 10, 47, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
    Cell[16685, 550, 532, 14, 84, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesInputStandard"]},
  "MenuListCommonDefaultFormatTypesInputTraditional"->{
    Cell[17220, 566, 98, 1, 32, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],
    Cell[17321, 569, 341, 10, 47, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],
    Cell[17665, 581, 541, 14, 84, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"]},
  "MenuListCommonDefaultFormatTypesOutputOutput"->{
    Cell[18355, 606, 89, 1, 32, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
    Cell[18447, 609, 329, 10, 47, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
    Cell[18779, 621, 399, 13, 62, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"]},
  "MenuListCommonDefaultFormatTypesOutputInput"->{
    Cell[19181, 636, 87, 1, 32, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
    Cell[19271, 639, 325, 10, 47, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
    Cell[19599, 651, 396, 13, 62, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesOutputInput"]},
  "MenuListCommonDefaultFormatTypesOutputStandard"->{
    Cell[19998, 666, 93, 1, 32, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
    Cell[20094, 669, 334, 10, 47, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
    Cell[20431, 681, 405, 13, 62, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"]},
  "MenuListCommonDefaultFormatTypesOutputTraditional"->{
    Cell[20839, 696, 99, 1, 32, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],
    Cell[20941, 699, 335, 11, 47, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],
    Cell[21279, 712, 414, 13, 62, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"]},
  "MenuListCommonDefaultFormatTypesTextInlineStandard"->{
    Cell[21842, 736, 97, 1, 32, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
    Cell[21942, 739, 343, 10, 47, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
    Cell[22288, 751, 418, 14, 62, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"]},
  "MenuListCommonDefaultFormatTypesTextInlineTraditional"->{
    Cell[22709, 767, 103, 1, 32, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],
    Cell[22815, 770, 352, 10, 47, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],
    Cell[23170, 782, 427, 14, 62, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"]},
  "CellOpen"->{
    Cell[23736, 807, 52, 1, 32, "Command",
      CellTags->"CellOpen"],
    Cell[23791, 810, 156, 5, 31, "Usage",
      CellTags->"CellOpen"],
    Cell[23950, 817, 322, 10, 46, "Notes",
      CellTags->"CellOpen"],
    Cell[24275, 829, 164, 6, 24, "Notes",
      CellTags->"CellOpen"]},
  "Editable"->{
    Cell[24442, 837, 56, 1, 32, "Command",
      CellTags->"Editable"],
    Cell[24501, 840, 157, 5, 31, "Usage",
      CellTags->"Editable"],
    Cell[24661, 847, 352, 10, 46, "Notes",
      CellTags->"Editable"]},
  "CellEditDuplicate"->{
    Cell[25016, 859, 71, 1, 32, "Command",
      CellTags->"CellEditDuplicate"],
    Cell[25090, 862, 205, 5, 31, "Usage",
      CellTags->"CellEditDuplicate"],
    Cell[25298, 869, 335, 10, 62, "Notes",
      CellTags->"CellEditDuplicate"]},
  "Evaluatable"->{
    Cell[25636, 881, 62, 1, 32, "Command",
      CellTags->"Evaluatable"],
    Cell[25701, 884, 232, 6, 47, "Usage",
      CellTags->"Evaluatable"],
    Cell[25936, 892, 368, 11, 62, "Notes",
      CellTags->"Evaluatable"]},
  "Active"->{
    Cell[26307, 905, 52, 1, 32, "Command",
      CellTags->"Active"],
    Cell[26362, 908, 165, 5, 31, "Usage",
      CellTags->"Active"],
    Cell[26530, 915, 195, 5, 40, "Notes",
      CellTags->"Active"],
    Cell[26728, 922, 452, 14, 46, "Notes",
      CellTags->"Active"],
    Cell[27183, 938, 246, 10, 24, "Notes",
      CellTags->"Active"]},
  "InitializationCell"->{
    Cell[27432, 950, 93, 1, 32, "Command",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[27528, 953, 216, 5, 31, "Usage",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[27747, 960, 472, 14, 62, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[28222, 976, 746, 16, 138, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[28971, 994, 819, 20, 104, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[29793, 1016, 285, 6, 40, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}]},
  "askIfInitNoteID"->{
    Cell[27432, 950, 93, 1, 32, "Command",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[27528, 953, 216, 5, 31, "Usage",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[27747, 960, 472, 14, 62, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[28222, 976, 746, 16, 138, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[28971, 994, 819, 20, 104, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[29793, 1016, 285, 6, 40, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}]},
  "CellGroup"->{
    Cell[30215, 1033, 55, 1, 32, "Command",
      CellTags->"CellGroup"],
    Cell[30273, 1036, 172, 5, 31, "Usage",
      CellTags->"CellGroup"],
    Cell[30448, 1043, 247, 6, 46, "Notes",
      CellTags->"CellGroup"],
    Cell[30698, 1051, 353, 9, 40, "Notes",
      CellTags->"CellGroup"],
    Cell[31054, 1062, 148, 3, 24, "Notes",
      CellTags->"CellGroup"],
    Cell[31205, 1067, 249, 10, 24, "Notes",
      CellTags->"CellGroup"],
    Cell[31457, 1079, 692, 20, 24, "Notes",
      CellTags->"CellGroup"]},
  "CellUnGroup"->{
    Cell[32152, 1101, 59, 1, 32, "Command",
      CellTags->"CellUnGroup"],
    Cell[32214, 1104, 163, 5, 31, "Usage",
      CellTags->"CellUnGroup"],
    Cell[32380, 1111, 233, 6, 46, "Notes",
      CellTags->"CellUnGroup"],
    Cell[32616, 1119, 291, 7, 40, "Notes",
      CellTags->"CellUnGroup"]},
  "CellUngroup"->{
    Cell[32910, 1128, 688, 19, 24, "Notes",
      CellTags->"CellUngroup"]},
  "CellGroupingManual"->{
    Cell[33601, 1149, 68, 1, 32, "Command",
      CellTags->"CellGroupingManual"],
    Cell[33672, 1152, 161, 5, 31, "Usage",
      CellTags->"CellGroupingManual"],
    Cell[33836, 1159, 323, 10, 46, "Notes",
      CellTags->"CellGroupingManual"]},
  "CellGroupingAutomatic"->{
    Cell[34162, 1171, 74, 1, 32, "Command",
      CellTags->"CellGroupingAutomatic"],
    Cell[34239, 1174, 214, 6, 31, "Usage",
      CellTags->"CellGroupingAutomatic"],
    Cell[34456, 1182, 824, 18, 122, "Notes",
      CellTags->"CellGroupingAutomatic"],
    Cell[35283, 1202, 181, 6, 24, "Notes",
      CellTags->"CellGroupingAutomatic"]},
  "SelectionOpenAllGroups"->{
    Cell[35467, 1210, 75, 1, 32, "Command",
      CellTags->"SelectionOpenAllGroups"],
    Cell[35545, 1213, 181, 5, 31, "Usage",
      CellTags->"SelectionOpenAllGroups"],
    Cell[35729, 1220, 617, 18, 24, "Notes",
      CellTags->"SelectionOpenAllGroups"]},
  "SelectionCloseAllGroups"->{
    Cell[36349, 1240, 77, 1, 32, "Command",
      CellTags->"SelectionCloseAllGroups"],
    Cell[36429, 1243, 184, 5, 31, "Usage",
      CellTags->"SelectionCloseAllGroups"],
    Cell[36616, 1250, 618, 18, 24, "Notes",
      CellTags->"SelectionCloseAllGroups"]},
  "OpenCloseGroup"->{
    Cell[37237, 1270, 65, 1, 32, "Command",
      CellTags->"OpenCloseGroup"],
    Cell[37305, 1273, 264, 6, 47, "Usage",
      CellTags->"OpenCloseGroup"],
    Cell[37572, 1281, 181, 4, 24, "Notes",
      CellTags->"OpenCloseGroup"],
    Cell[37756, 1287, 590, 18, 24, "Notes",
      CellTags->"OpenCloseGroup"]},
  "CellSplit"->{
    Cell[38349, 1307, 55, 1, 32, "Command",
      CellTags->"CellSplit"],
    Cell[38407, 1310, 165, 5, 31, "Usage",
      CellTags->"CellSplit"],
    Cell[38575, 1317, 191, 5, 24, "Notes",
      CellTags->"CellSplit"],
    Cell[38769, 1324, 291, 6, 40, "Notes",
      CellTags->"CellSplit"],
    Cell[39063, 1332, 717, 21, 24, "Notes",
      CellTags->"CellSplit"]},
  "CellMerge"->{
    Cell[39783, 1355, 55, 1, 32, "Command",
      CellTags->"CellMerge"],
    Cell[39841, 1358, 174, 5, 31, "Usage",
      CellTags->"CellMerge"],
    Cell[40018, 1365, 218, 5, 40, "Notes",
      CellTags->"CellMerge"],
    Cell[40239, 1372, 717, 21, 24, "Notes",
      CellTags->"CellMerge"]},
  "SelectionAnimate"->{
    Cell[40959, 1395, 76, 1, 32, "Command",
      CellTags->"SelectionAnimate"],
    Cell[41038, 1398, 207, 5, 31, "Usage",
      CellTags->"SelectionAnimate"],
    Cell[41248, 1405, 216, 5, 40, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[41467, 1412, 155, 3, 24, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[41625, 1417, 636, 19, 24, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[42286, 1440, 130, 2, 34, "Subsubsection",
      CellTags->"SelectionAnimate"],
    Cell[42419, 1444, 455, 10, 78, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[42877, 1456, 129, 4, 24, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[43009, 1462, 5125, 134, 179, "Text",
      CellTags->"SelectionAnimate"]},
  "SoundPlay"->{
    Cell[48137, 1598, 54, 1, 32, "Command",
      CellTags->"SoundPlay"],
    Cell[48194, 1601, 153, 5, 31, "Usage",
      CellTags->"SoundPlay"],
    Cell[48350, 1608, 179, 3, 24, "Notes",
      CellTags->"SoundPlay"],
    Cell[48532, 1613, 251, 4, 40, "Notes",
      CellTags->"SoundPlay"]},
  "GraphicsRender"->{
    Cell[48786, 1619, 66, 1, 32, "Command",
      CellTags->"GraphicsRender"],
    Cell[48855, 1622, 242, 6, 47, "Usage",
      CellTags->"GraphicsRender"],
    Cell[49100, 1630, 194, 3, 40, "Notes",
      CellTags->"GraphicsRender"]},
  "GenerateImageCaches"->{
    Cell[49297, 1635, 80, 1, 32, "Command",
      CellTags->"GenerateImageCaches"],
    Cell[49380, 1638, 200, 5, 31, "Usage",
      CellTags->"GenerateImageCaches"]},
  "GraphicsOriginalSize"->{
    Cell[49583, 1645, 73, 1, 32, "Command",
      CellTags->"GraphicsOriginalSize"],
    Cell[49659, 1648, 175, 5, 31, "Usage",
      CellTags->"GraphicsOriginalSize"],
    Cell[49837, 1655, 478, 9, 78, "Notes",
      CellTags->"GraphicsOriginalSize"]},
  "GraphicsAlign"->{
    Cell[50318, 1666, 103, 1, 32, "Command",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50424, 1669, 244, 6, 31, "Usage",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50671, 1677, 286, 5, 40, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50960, 1684, 330, 6, 56, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[51293, 1692, 333, 8, 46, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}]},
  "alignGraphicsSettingsID"->{
    Cell[50318, 1666, 103, 1, 32, "Command",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50424, 1669, 244, 6, 31, "Usage",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50671, 1677, 286, 5, 40, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50960, 1684, 330, 6, 56, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[51293, 1692, 333, 8, 46, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}]},
  "NotebookStatisticsDialog"->{
    Cell[51629, 1702, 114, 1, 32, "Command",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51746, 1705, 230, 5, 31, "Usage",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52001, 1714, 105, 1, 25, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52109, 1717, 139, 1, 24, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52285, 1723, 107, 1, 25, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52395, 1726, 190, 4, 24, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52622, 1735, 109, 1, 25, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52734, 1738, 739, 13, 92, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]},
  "notebookStatisticsDialogID"->{
    Cell[51629, 1702, 114, 1, 32, "Command",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51746, 1705, 230, 5, 31, "Usage",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52001, 1714, 105, 1, 25, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52109, 1717, 139, 1, 24, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52285, 1723, 107, 1, 25, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52395, 1726, 190, 4, 24, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52622, 1735, 109, 1, 25, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[52734, 1738, 739, 13, 92, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ConvertToInputForm", 54238, 1776},
  {"SelectionConvert", 54665, 1787},
  {"ConvertToOutputForm", 56526, 1824},
  {"ConvertToStandardForm", 56869, 1831},
  {"ConvertToTraditionalForm", 57410, 1842},
  {"PostScript", 57952, 1853},
  {"Bitmap", 58206, 1860},
  {"Metafile", 58450, 1867},
  {"PICT", 58626, 1872},
  {"PICTBitmap", 58869, 1879},
  {"PICTEmbeddedPS", 59134, 1886},
  {"QuickTime", 59406, 1893},
  {"SelectionDisplayAs", 59600, 1898},
  {"DisplayAsTextForm", 60917, 1923},
  {"DisplayAsInputForm", 61257, 1930},
  {"DisplayAsStandardForm", 61604, 1937},
  {"DisplayAsTraditionalForm", 61963, 1944},
  {"MenuListCommonDefaultFormatTypesInputInput", 62349, 1951},
  {"MenuListCommonDefaultFormatTypesInputStandard", 62721, 1958},
  {"MenuListCommonDefaultFormatTypesInputTraditional", 63105, 1965},
  {"MenuListCommonDefaultFormatTypesOutputOutput", 63494, 1972},
  {"MenuListCommonDefaultFormatTypesOutputInput", 63870, 1979},
  {"MenuListCommonDefaultFormatTypesOutputStandard", 64246, 1986},
  {"MenuListCommonDefaultFormatTypesOutputTraditional", 64634, 1993},
  {"MenuListCommonDefaultFormatTypesTextInlineStandard", 65032, 2000},
  {"MenuListCommonDefaultFormatTypesTextInlineTraditional", 65436, 2007},
  {"CellOpen", 65805, 2014},
  {"Editable", 66108, 2023},
  {"CellEditDuplicate", 66349, 2030},
  {"Evaluatable", 66611, 2037},
  {"Active", 66850, 2044},
  {"InitializationCell", 67225, 2055},
  {"askIfInitNoteID", 67868, 2068},
  {"CellGroup", 68505, 2081},
  {"CellUnGroup", 69039, 2096},
  {"CellUngroup", 69360, 2105},
  {"CellGroupingManual", 69463, 2108},
  {"CellGroupingAutomatic", 69741, 2115},
  {"SelectionOpenAllGroups", 70115, 2124},
  {"SelectionCloseAllGroups", 70407, 2131},
  {"OpenCloseGroup", 70693, 2138},
  {"CellSplit", 71025, 2147},
  {"CellMerge", 71410, 2158},
  {"SelectionAnimate", 71729, 2167},
  {"SoundPlay", 72481, 2186},
  {"GraphicsRender", 72797, 2195},
  {"GenerateImageCaches", 73060, 2202},
  {"GraphicsOriginalSize", 73256, 2207},
  {"GraphicsAlign", 73531, 2214},
  {"alignGraphicsSettingsID", 74095, 2225},
  {"NotebookStatisticsDialog", 74660, 2236},
  {"notebookStatisticsDialogID", 75694, 2253}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 94, 4, 52, "Section"],
Cell[1873, 59, 62, 1, 32, "Command",
  CellTags->"ConvertToInputForm"],
Cell[1938, 62, 261, 10, 31, "Usage",
  CellTags->"ConvertToInputForm"],
Cell[2202, 74, 970, 25, 144, "Notes",
  CellTags->"ConvertToInputForm"],
Cell[3175, 101, 175, 6, 24, "Notes",
  CellTags->"ConvertToInputForm"],
Cell[3353, 109, 682, 20, 24, "Notes",
  CellTags->"ConvertToInputForm"],
Cell[4038, 131, 86, 1, 32, "Command",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
Cell[4127, 134, 285, 10, 31, "Usage",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
Cell[4415, 146, 616, 15, 106, "Notes",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
Cell[5034, 163, 90, 1, 32, "Command",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
Cell[5127, 166, 291, 10, 31, "Usage",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
Cell[5421, 178, 245, 6, 24, "Notes",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
Cell[5669, 186, 620, 15, 106, "Notes",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
Cell[6292, 203, 719, 21, 24, "Notes",
  CellTags->"ConvertToStandardForm"],
Cell[7014, 226, 96, 1, 32, "Command",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
Cell[7113, 229, 301, 10, 31, "Usage",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
Cell[7417, 241, 248, 6, 24, "Notes",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
Cell[7668, 249, 626, 15, 106, "Notes",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
Cell[8297, 266, 716, 20, 24, "Notes",
  CellTags->"ConvertToTraditionalForm"],
Cell[9016, 288, 77, 1, 32, "Command",
  CellTags->{"SelectionConvert", "PostScript"}],
Cell[9096, 291, 181, 5, 31, "Usage",
  CellTags->"PostScript"],
Cell[9280, 298, 162, 3, 24, "Notes",
  CellTags->"PostScript"],
Cell[9445, 303, 69, 1, 32, "Command",
  CellTags->{"SelectionConvert", "Bitmap"}],
Cell[9517, 306, 192, 5, 31, "Usage",
  CellTags->"Bitmap"],
Cell[9712, 313, 158, 3, 24, "Notes",
  CellTags->"Bitmap"],
Cell[9873, 318, 73, 1, 32, "Command",
  CellTags->{"SelectionConvert", "Metafile"}],
Cell[9949, 321, 191, 5, 31, "Usage",
  CellTags->"Metafile"],
Cell[10143, 328, 65, 1, 32, "Command",
  CellTags->{"SelectionConvert", "PICT"}],
Cell[10211, 331, 213, 7, 47, "Usage",
  CellTags->"PICT"],
Cell[10427, 340, 138, 3, 24, "Notes",
  CellTags->"PICT"],
Cell[10568, 345, 77, 1, 32, "Command",
  CellTags->{"SelectionConvert", "PICTBitmap"}],
Cell[10648, 348, 247, 6, 47, "Usage",
  CellTags->"PICTBitmap"],
Cell[10898, 356, 144, 3, 24, "Notes",
  CellTags->"PICTBitmap"],
Cell[11045, 361, 87, 1, 32, "Command",
  CellTags->{"SelectionConvert", "PICTEmbeddedPS"}],
Cell[11135, 364, 279, 6, 47, "Usage",
  CellTags->"PICTEmbeddedPS"],
Cell[11417, 372, 148, 3, 24, "Notes",
  CellTags->"PICTEmbeddedPS"],
Cell[11568, 377, 75, 1, 32, "Command",
  CellTags->{"SelectionConvert", "QuickTime"}],
Cell[11646, 380, 234, 6, 47, "Usage",
  CellTags->"QuickTime"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11917, 391, 94, 4, 52, "Section"],
Cell[12014, 397, 80, 1, 32, "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
Cell[12097, 400, 216, 5, 31, "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
Cell[12316, 407, 405, 8, 62, "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
Cell[12724, 417, 86, 1, 32, "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
Cell[12813, 420, 308, 10, 31, "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
Cell[13124, 432, 434, 9, 62, "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
Cell[13561, 443, 92, 1, 32, "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
Cell[13656, 446, 294, 10, 31, "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
Cell[13953, 458, 399, 9, 62, "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
Cell[14355, 469, 98, 1, 32, "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
Cell[14456, 472, 303, 10, 31, "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
Cell[14762, 484, 405, 9, 62, "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15204, 498, 108, 4, 52, "Section"],
Cell[15315, 504, 86, 1, 32, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
Cell[15404, 507, 323, 10, 47, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
Cell[15730, 519, 523, 14, 84, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
Cell[16256, 535, 92, 1, 32, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
Cell[16351, 538, 331, 10, 47, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
Cell[16685, 550, 532, 14, 84, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
Cell[17220, 566, 98, 1, 32, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],
Cell[17321, 569, 341, 10, 47, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],
Cell[17665, 581, 541, 14, 84, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18243, 600, 109, 4, 52, "Section"],
Cell[18355, 606, 89, 1, 32, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
Cell[18447, 609, 329, 10, 47, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
Cell[18779, 621, 399, 13, 62, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
Cell[19181, 636, 87, 1, 32, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
Cell[19271, 639, 325, 10, 47, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
Cell[19599, 651, 396, 13, 62, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
Cell[19998, 666, 93, 1, 32, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
Cell[20094, 669, 334, 10, 47, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
Cell[20431, 681, 405, 13, 62, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
Cell[20839, 696, 99, 1, 32, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],
Cell[20941, 699, 335, 11, 47, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],
Cell[21279, 712, 414, 13, 62, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21730, 730, 109, 4, 52, "Section"],
Cell[21842, 736, 97, 1, 32, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
Cell[21942, 739, 343, 10, 47, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
Cell[22288, 751, 418, 14, 62, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
Cell[22709, 767, 103, 1, 32, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],
Cell[22815, 770, 352, 10, 47, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],
Cell[23170, 782, 427, 14, 62, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23634, 801, 99, 4, 52, "Section"],
Cell[23736, 807, 52, 1, 32, "Command",
  CellTags->"CellOpen"],
Cell[23791, 810, 156, 5, 31, "Usage",
  CellTags->"CellOpen"],
Cell[23950, 817, 322, 10, 46, "Notes",
  CellTags->"CellOpen"],
Cell[24275, 829, 164, 6, 24, "Notes",
  CellTags->"CellOpen"],
Cell[24442, 837, 56, 1, 32, "Command",
  CellTags->"Editable"],
Cell[24501, 840, 157, 5, 31, "Usage",
  CellTags->"Editable"],
Cell[24661, 847, 352, 10, 46, "Notes",
  CellTags->"Editable"],
Cell[25016, 859, 71, 1, 32, "Command",
  CellTags->"CellEditDuplicate"],
Cell[25090, 862, 205, 5, 31, "Usage",
  CellTags->"CellEditDuplicate"],
Cell[25298, 869, 335, 10, 62, "Notes",
  CellTags->"CellEditDuplicate"],
Cell[25636, 881, 62, 1, 32, "Command",
  CellTags->"Evaluatable"],
Cell[25701, 884, 232, 6, 47, "Usage",
  CellTags->"Evaluatable"],
Cell[25936, 892, 368, 11, 62, "Notes",
  CellTags->"Evaluatable"],
Cell[26307, 905, 52, 1, 32, "Command",
  CellTags->"Active"],
Cell[26362, 908, 165, 5, 31, "Usage",
  CellTags->"Active"],
Cell[26530, 915, 195, 5, 40, "Notes",
  CellTags->"Active"],
Cell[26728, 922, 452, 14, 46, "Notes",
  CellTags->"Active"],
Cell[27183, 938, 246, 10, 24, "Notes",
  CellTags->"Active"],
Cell[27432, 950, 93, 1, 32, "Command",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[27528, 953, 216, 5, 31, "Usage",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[27747, 960, 472, 14, 62, "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[28222, 976, 746, 16, 138, "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[28971, 994, 819, 20, 104, "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[29793, 1016, 285, 6, 40, "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[30115, 1027, 97, 4, 52, "Section"],
Cell[30215, 1033, 55, 1, 32, "Command",
  CellTags->"CellGroup"],
Cell[30273, 1036, 172, 5, 31, "Usage",
  CellTags->"CellGroup"],
Cell[30448, 1043, 247, 6, 46, "Notes",
  CellTags->"CellGroup"],
Cell[30698, 1051, 353, 9, 40, "Notes",
  CellTags->"CellGroup"],
Cell[31054, 1062, 148, 3, 24, "Notes",
  CellTags->"CellGroup"],
Cell[31205, 1067, 249, 10, 24, "Notes",
  CellTags->"CellGroup"],
Cell[31457, 1079, 692, 20, 24, "Notes",
  CellTags->"CellGroup"],
Cell[32152, 1101, 59, 1, 32, "Command",
  CellTags->"CellUnGroup"],
Cell[32214, 1104, 163, 5, 31, "Usage",
  CellTags->"CellUnGroup"],
Cell[32380, 1111, 233, 6, 46, "Notes",
  CellTags->"CellUnGroup"],
Cell[32616, 1119, 291, 7, 40, "Notes",
  CellTags->"CellUnGroup"],
Cell[32910, 1128, 688, 19, 24, "Notes",
  CellTags->"CellUngroup"],
Cell[33601, 1149, 68, 1, 32, "Command",
  CellTags->"CellGroupingManual"],
Cell[33672, 1152, 161, 5, 31, "Usage",
  CellTags->"CellGroupingManual"],
Cell[33836, 1159, 323, 10, 46, "Notes",
  CellTags->"CellGroupingManual"],
Cell[34162, 1171, 74, 1, 32, "Command",
  CellTags->"CellGroupingAutomatic"],
Cell[34239, 1174, 214, 6, 31, "Usage",
  CellTags->"CellGroupingAutomatic"],
Cell[34456, 1182, 824, 18, 122, "Notes",
  CellTags->"CellGroupingAutomatic"],
Cell[35283, 1202, 181, 6, 24, "Notes",
  CellTags->"CellGroupingAutomatic"],
Cell[35467, 1210, 75, 1, 32, "Command",
  CellTags->"SelectionOpenAllGroups"],
Cell[35545, 1213, 181, 5, 31, "Usage",
  CellTags->"SelectionOpenAllGroups"],
Cell[35729, 1220, 617, 18, 24, "Notes",
  CellTags->"SelectionOpenAllGroups"],
Cell[36349, 1240, 77, 1, 32, "Command",
  CellTags->"SelectionCloseAllGroups"],
Cell[36429, 1243, 184, 5, 31, "Usage",
  CellTags->"SelectionCloseAllGroups"],
Cell[36616, 1250, 618, 18, 24, "Notes",
  CellTags->"SelectionCloseAllGroups"],
Cell[37237, 1270, 65, 1, 32, "Command",
  CellTags->"OpenCloseGroup"],
Cell[37305, 1273, 264, 6, 47, "Usage",
  CellTags->"OpenCloseGroup"],
Cell[37572, 1281, 181, 4, 24, "Notes",
  CellTags->"OpenCloseGroup"],
Cell[37756, 1287, 590, 18, 24, "Notes",
  CellTags->"OpenCloseGroup"],
Cell[38349, 1307, 55, 1, 32, "Command",
  CellTags->"CellSplit"],
Cell[38407, 1310, 165, 5, 31, "Usage",
  CellTags->"CellSplit"],
Cell[38575, 1317, 191, 5, 24, "Notes",
  CellTags->"CellSplit"],
Cell[38769, 1324, 291, 6, 40, "Notes",
  CellTags->"CellSplit"],
Cell[39063, 1332, 717, 21, 24, "Notes",
  CellTags->"CellSplit"],
Cell[39783, 1355, 55, 1, 32, "Command",
  CellTags->"CellMerge"],
Cell[39841, 1358, 174, 5, 31, "Usage",
  CellTags->"CellMerge"],
Cell[40018, 1365, 218, 5, 40, "Notes",
  CellTags->"CellMerge"],
Cell[40239, 1372, 717, 21, 24, "Notes",
  CellTags->"CellMerge"],
Cell[40959, 1395, 76, 1, 32, "Command",
  CellTags->"SelectionAnimate"],
Cell[41038, 1398, 207, 5, 31, "Usage",
  CellTags->"SelectionAnimate"],
Cell[41248, 1405, 216, 5, 40, "Notes",
  CellTags->"SelectionAnimate"],
Cell[41467, 1412, 155, 3, 24, "Notes",
  CellTags->"SelectionAnimate"],
Cell[41625, 1417, 636, 19, 24, "Notes",
  CellTags->"SelectionAnimate"],

Cell[CellGroupData[{
Cell[42286, 1440, 130, 2, 34, "Subsubsection",
  CellTags->"SelectionAnimate"],
Cell[42419, 1444, 455, 10, 78, "Notes",
  CellTags->"SelectionAnimate"],
Cell[42877, 1456, 129, 4, 24, "Notes",
  CellTags->"SelectionAnimate"],
Cell[43009, 1462, 5125, 134, 179, "Text",
  CellTags->"SelectionAnimate"],
Cell[48137, 1598, 54, 1, 32, "Command",
  CellTags->"SoundPlay"],
Cell[48194, 1601, 153, 5, 31, "Usage",
  CellTags->"SoundPlay"],
Cell[48350, 1608, 179, 3, 24, "Notes",
  CellTags->"SoundPlay"],
Cell[48532, 1613, 251, 4, 40, "Notes",
  CellTags->"SoundPlay"],
Cell[48786, 1619, 66, 1, 32, "Command",
  CellTags->"GraphicsRender"],
Cell[48855, 1622, 242, 6, 47, "Usage",
  CellTags->"GraphicsRender"],
Cell[49100, 1630, 194, 3, 40, "Notes",
  CellTags->"GraphicsRender"],
Cell[49297, 1635, 80, 1, 32, "Command",
  CellTags->"GenerateImageCaches"],
Cell[49380, 1638, 200, 5, 31, "Usage",
  CellTags->"GenerateImageCaches"],
Cell[49583, 1645, 73, 1, 32, "Command",
  CellTags->"GraphicsOriginalSize"],
Cell[49659, 1648, 175, 5, 31, "Usage",
  CellTags->"GraphicsOriginalSize"],
Cell[49837, 1655, 478, 9, 78, "Notes",
  CellTags->"GraphicsOriginalSize"],
Cell[50318, 1666, 103, 1, 32, "Command",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[50424, 1669, 244, 6, 31, "Usage",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[50671, 1677, 286, 5, 40, "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[50960, 1684, 330, 6, 56, "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[51293, 1692, 333, 8, 46, "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[51629, 1702, 114, 1, 32, "Command",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
Cell[51746, 1705, 230, 5, 31, "Usage",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell[CellGroupData[{
Cell[52001, 1714, 105, 1, 25, "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
Cell[52109, 1717, 139, 1, 24, "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[52285, 1723, 107, 1, 25, "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
Cell[52395, 1726, 190, 4, 24, "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[52622, 1735, 109, 1, 25, "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
Cell[52734, 1738, 739, 13, 92, "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

