(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     83628,       2592]*)
(*NotebookOutlinePosition[     98614,       2986]*)
(*  CellTagsIndexPosition[     97781,       2956]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Undo", "Command",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Undo", "SR"],
  " reverses the previous action."
}], "Usage",
  CellTags->"Undo"],

Cell["\<\
\[FilledSmallSquare] You can only undo your most recent command. In \
general, you can undo the basic commands in the Edit menu as well as any \
typing you have done since your last action. \
\>", "Notes",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] The only way to undo several actions at once is to go \
back to an earlier version of your file: close the file; when asked if you \
want to save the changes, click ",
  StyleBox["Don't Save ",
    FontFamily->"Helvetica"],
  "; then reopen it. The notebook then reverts to the last version saved. "
}], "Notes",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["z", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["z", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh",
  StyleBox[");", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["z", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Undo"]
}, Closed]],

Cell[CellGroupData[{

Cell["Cut", "Command",
  CellTags->"Cut"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cut", "SR"],
  " deletes the current selection and puts it in the Clipboard. "
}], "Usage",
  CellTags->"Cut"],

Cell["\<\
\[FilledSmallSquare] To cut selected material from the notebook and \
place it on the Clipboard:\
\>", "Text",
  CellTags->"Cut"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  " Highlight the area to be cut. \n",
  StyleBox["2.",
    FontWeight->"Bold"],
  " ",
  "Choose ",
  StyleBox["Cut", "SR"],
  " from the Edit menu."
}], "ItemizedText",
  CellTags->"Cut"],

Cell[TextData[{
  "You can then insert the deleted material elsewhere using the ",
  StyleBox["Paste", "SR"],
  " command."
}], "NotesList",
  CellTags->"Cut"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["x", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["x", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh)",
  StyleBox[";", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["x", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Cut"]
}, Closed]],

Cell[CellGroupData[{

Cell["Copy", "Command",
  CellTags->"Copy"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Copy", "SR"],
  " copies the current selection to the Clipboard without deleting it from",
  " ",
  "your notebook."
}], "Usage",
  CellTags->"Copy"],

Cell[TextData[{
  "\[FilledSmallSquare] To copy selected material from the notebook and \
place",
  " ",
  "it in the Clipboard:"
}], "Notes",
  CellTags->"Copy"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  " Highlight the area to be copied. \n",
  StyleBox["2.",
    FontWeight->"Bold"],
  " ",
  "Choose ",
  StyleBox["Copy", "SR"],
  " from the Edit menu."
}], "ItemizedText",
  CellTags->"Copy"],

Cell[TextData[{
  "The copied text or cells can then be inserted in another notebook or",
  " ",
  "elsewhere in the same notebook with the ",
  StyleBox["Paste", "SR"],
  " command."
}], "NotesList",
  CellTags->"Copy"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["c", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["c", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh)",
  StyleBox[";", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["c", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Copy"]
}, Closed]],

Cell[CellGroupData[{

Cell["Paste", "Command",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Paste", "SR"],
  " inserts the current contents of the Clipboard."
}], "Usage",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] To insert the Clipboard contents inside an existing",
  " ",
  "cell: "
}], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  " Position the text insertion point (blinking vertical bar) by clicking the \
desired area. \n",
  StyleBox["2.",
    FontWeight->"Bold"],
  " Choose ",
  StyleBox["Paste", "SR"],
  " from the Edit menu."
}], "ItemizedText",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] To insert the Clipboard contents between two cells, \
or",
  " ",
  "at the bottom or top of the notebook: "
}], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  " Position the cell insertion point (horizontal bar) in the desired area \
between two cells. \n",
  StyleBox["2.",
    FontWeight->"Bold"],
  " Choose ",
  StyleBox["Paste", "SR"],
  " from the Edit menu."
}], "ItemizedText",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " ",
  "pastes a copy of the Clipboard contents at the insertion point."
}], "NotesList",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] To replace a selected area with the Clipboard",
  " ",
  "contents:"
}], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  " Select a range of characters or cells by highlighting them.\n",
  StyleBox["2.",
    FontWeight->"Bold"],
  " ",
  "Choose ",
  StyleBox["Paste", "SR"],
  "."
}], "ItemizedText",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " deletes the selected characters or cells and inserts the new material in",
  
  " ",
  "their place."
}], "NotesList",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] Information contained in the Clipboard remains there \
until a new selection is copied or cut. This lets you paste the same contents \
repeatedly. Large clipboards take up memory, however. To empty the Clipboard",
  
  " ",
  "automatically after pasting, use the ",
  StyleBox["Paste and Discard", "SR"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "command."
}], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] When pasting a notebook or cell expression from a \
text application such as email, a dialog box gives you the choice of pasting \
the expression literally into the current notebook or interpreting it as a \
cell",
  " ",
  "or notebook."
}], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["v", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["v", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh)",
  StyleBox[";", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["v", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Paste"]
}, Closed]],

Cell[CellGroupData[{

Cell["Clear", "Command",
  CellTags->"Clear"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Clear", "SR"],
  " deletes the current selection without putting it in the Clipboard."
}], "Usage",
  CellTags->"Clear"],

Cell[TextData[{
  "\[FilledSmallSquare] Unlike",
  StyleBox[" ", "MR",
    FontFamily->"Times"],
  StyleBox["Cut", "MR"],
  StyleBox[" ", "MR",
    FontFamily->"Times"],
  "and",
  StyleBox[" ", "MR",
    FontFamily->"Times"],
  StyleBox["Copy", "MR"],
  ", this command does not place the selection in the Clipboard."
}], "Notes",
  CellTags->"Clear"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[DeleteKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["X", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh)",
  StyleBox[";", "Notes"],
  " ",
  StyleBox["\[DeleteKey]", "C1"],
  StyleBox[" (X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Clear"]
}, Closed]],

Cell[CellGroupData[{

Cell["Copy As", "Command",
  CellTags->"CopySpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Copy As", "SR"],
  " copies a selection and converts it to the specified format."
}], "Usage",
  CellTags->"CopySpecial"],

Cell["\<\
\[FilledSmallSquare] Selections can be copied in the following \
formats:
   Plain Text, Formatted Text, Text (add whitespace), Cell Expression, \
Notebook Expression, Complete Notebook, and MathML. Plain Text removes any \
information about styles, while Formatted Text preserves style information. 
   On Windows also: Bitmap (BMP), Windows Metafile (WMF), and Wave (WAV).
   On Macintosh also: PICT, Bitmap PICT, PICT with Embedded PostScript, and \
QuickTime.\
\>", "Notes",
  CellTags->"CopySpecial"]
}, Closed]],

Cell[CellGroupData[{

Cell["Paste As", "Command",
  CellTags->"PasteAs"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Paste As", "SR"],
  " copies the contents of the Clipboard, in a specified format, at the \
current insertion point."
}], "Usage",
  CellTags->"PasteAs"],

Cell["\<\
\[FilledSmallSquare] Selections can be inserted into the notebook \
in the following formats: Plain Text, Formatted Text, Text (strip \
whitespace), and Inline Cell. Plain Text removes any information about \
styles, while Formatted Text preserves style information. \
\>", "Notes",
  CellTags->"PasteAs"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Paste As \[RightTriangle]", "SR"],
  StyleBox[" Paste and Apply ",
    FontFamily->"Helvetica"],
  "command has the following property: if the text being pasted contains any \
selection placeholders (\[SelectionPlaceholder]), they will be replaced by \
the current selection, after the Paste is done. This is similar to what \
happens when you click a button containing placeholders."
}], "Notes",
  CellTags->"PasteAs"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Paste As \[RightTriangle]", "SR"],
  StyleBox[" ",
    FontFamily->"Helvetica"],
  StyleBox["Paste and Discard", "SR"],
  " command is like ordinary pasting except that the clipboard is emptied \
after the Paste is done. This is useful for conserving memory, if the \
clipboard is extremely large. If you want to retain the contents of the \
clipboard (e.g., for pasting again), choose ",
  StyleBox["Paste and Apply",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"PasteAs"]
}, Closed]],

Cell[CellGroupData[{

Cell["External Clipboard", "Command",
  CellTags->"ExternalClipboard"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["External Clipboard", "SR"],
  " controls how the ",
  StyleBox["Edit \[RightTriangle] Paste",
    FontFamily->"Helvetica"],
  " menu command works in an X front end. (X only.)"
}], "Usage",
  CellTags->"ExternalClipboard"],

Cell[TextData[{
  "\[FilledSmallSquare] This menu item provides a way to customize how the \
paste command works, since pasting is implemented differently in different X \
applications. If you set ",
  StyleBox["External Clipboard \[RightTriangle] Clipboard",
    FontFamily->"Helvetica"],
  ", whatever was copied to the clipboard last (",
  StyleBox["i.e.",
    FontSlant->"Italic"],
  ", cut or copied from another application) will be pasted.\n\
\[FilledSmallSquare] If you set ",
  StyleBox["External Clipboard \[RightTriangle] Selection",
    FontFamily->"Helvetica"],
  ", the current selection is pasted. If you have trouble pasting from your \
favorite application, you might want to try setting ",
  StyleBox["External Clipboard",
    FontFamily->"Helvetica"],
  " to ",
  StyleBox["Selection",
    FontFamily->"Helvetica"],
  " instead of ",
  StyleBox["Clipboard",
    FontFamily->"Helvetica"],
  ".\n\[FilledSmallSquare] The setting for this menu command can also be \
changed using the global option ",
  StyleBox["\"XPasteFrom\"",
    FontFamily->"Courier"],
  " in the Option Inspector. \n\[FilledSmallSquare] See: ",
  StyleBox[ButtonBox["\"XPasteFrom\"",
    ButtonStyle->"OtherInformationLinkMR"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->"ExternalClipboard"]
}, Closed]],

Cell[CellGroupData[{

Cell["Save Selection As", "Command",
  CellTags->"SelectionSaveSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Save Selection As", "SR"],
  " ",
  "saves",
  " the selection in a file with the specified file format."
}], "Usage",
  CellTags->"SelectionSaveSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] Selections can be saved in the following formats:\n   \
Plain Text, Text (add whitespace), Cell Expression, Notebook Expression, \
Complete Notebook, Package Format, and EPS.\n   On Windows also: Windows \
Metafile (WMF), Enhanced Metafile (EMF), Rich Text Format (RTF), Bitmap \
(BMP), and Wave (WAV).\n   On Macintosh also: PICT, Bitmap PICT, PICT with \
Embedded PostScript, QuickTime, and Bitmap (MGF). MGF is ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s system-independent raster graphics format. "
}], "Notes",
  CellTags->"SelectionSaveSpecial"]
}, Closed]],

Cell[CellGroupData[{

Cell["Select All", "Command",
  CellTags->"SelectAll"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Select All", "SR"],
  " selects all cells in the current notebook."
}], "Usage",
  CellTags->"SelectAll"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["a", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["a", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh)",
  StyleBox[";", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["a", "C1MR"],
  StyleBox["\[RightModified]", "C1"],
  " ",
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SelectAll"]
}, Closed]],

Cell[CellGroupData[{

Cell["Insert Object", "Command",
  CellTags->"InsertObject"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Insert Object", "SR"],
  " inserts an embedded object, such as a document file, in the current \
notebook. (Windows only.)"
}], "Usage",
  CellTags->"InsertObject"]
}, Closed]],

Cell[TextData[StyleBox["Create New",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["Inserts a new object that you create.", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Object Type",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Click the type of information you want to insert. Some common \
object types include documents, bitmaps, and spreadsheets.\
\>", \
"IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Create from File",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["Inserts an existing object.", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["File",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Type the name of the file you want to insert as an embedded object, \
or click the Browse button to locate additional files.\
\>", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Browse",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Opens the Browse dialog box, where you can locate the file that you \
want to insert. \
\>", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Link",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Creates a link to the selected file, rather than embedding it.\
\>",
   "IndentedText",
  CellTags->"InsertObject"],

Cell["Display As Icon", "DialogItem",
  CellTags->"InsertObject"],

Cell["Displays the embedded object as an icon.", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Change Icon",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Changes the icon that represents an embedded object. This button \
appears only if you click the Display As Icon check box.\
\>", "IndentedText",\

  CellTags->"InsertObject"],

Cell["Result", "DialogItem",
  CellTags->"InsertObject"],

Cell["Describes the result of the selected options.", "IndentedText",
  CellTags->"InsertObject"],

Cell[CellGroupData[{

Cell["Motion", "Command",
  CellTags->"Motion"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Motion", "SR"],
  " submenu provides menu commands for commonly used cursor movements. This \
menu is intended primarily as a reference until you learn the keyboard",
  " ",
  "commands."
}], "Usage",
  CellTags->{"Motion", "all"}],

Cell["", "Notes",
  CellTags->"Motion"]
}, Closed]],

Cell[TextData[{
  "Windows Motion ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"Motion", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[ShortRightArrow]",
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[ShortLeftArrow]",
                FontSize->12]},
            {
              StyleBox[\(Delete\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[\(\(\[DeleteKey]\)\(\ \)\),
                FontSize->12]},
            {
              StyleBox[\(Delete\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["Backspace",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              
              StyleBox[\(\[ControlKey]\[LeftModified] \[ShortRightArrow] \
\[RightModified]\),
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] \[ShortLeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Delete\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    "2ColumnSmallBox"], "\[SkeletonIndicator]", 
                  StyleBox["\[DeleteKey]",
                    "2ColumnSmallBox"]}]]},
            {
              StyleBox[\(Delete\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    FontFamily->"Helvetica",
                    FontSize->12,
                    FontWeight->"Plain"], "\[SkeletonIndicator]", 
                  StyleBox["B",
                    "2ColumnSmallBox"], "ackspace"}]]},
            {
              StyleBox[\(Move\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["End",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["Home",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[DownArrow]",
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[UpArrow]",
                FontSize->12]}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, True, False, False, False, True, 
              False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"Motion", "all"}],

Cell[TextData[{
  "Macintosh Motion ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"Motion", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]f\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]b\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]d\[RightModified]",
                      FontSize->12]}]], 
                StyleBox[" ",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]h\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontSize->12], " "}]]}],
                FontSize->12]},
            {
              StyleBox[\(Move\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["Shift",
                        FontFamily->"Helvetica",
                        FontSize->10,
                        FontWeight->"Plain"], 
                      StyleBox["\[KeyBar]\[CommandKey]\[SkeletonIndicator]",
                        FontSize->12], 
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]W\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[OptionKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[CommandKey]\[SkeletonIndicator]",
                        FontSize->12], 
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]w\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[OptionKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["Shift",
                      FontFamily->"Helvetica",
                      FontSize->10,
                      FontWeight->"Plain"], 
                    StyleBox["\[SkeletonIndicator]",
                      FontSize->12], 
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]W\[RightModified]",
                      FontSize->12]}]], 
                StyleBox[" ",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    FontFamily->"Helvetica",
                    FontSize->12,
                    FontWeight->"Plain"], 
                  StyleBox["\[LeftModified]w\[RightModified]",
                    FontSize->12]}]]},
            {
              StyleBox[\(Move\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]e\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[CommandKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]a\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[CommandKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]n\[RightModified]",
                      FontSize->12]}]], 
                StyleBox["  ",
                  FontSize->12], 
                RowBox[{
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[DownArrow]",
                    FontSize->12]}]}]},
            {
              StyleBox[\(Move\ Previous\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]p\[RightModified]",
                      FontSize->12]}]], 
                StyleBox["  ",
                  FontSize->12], 
                RowBox[{
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[UpArrow]",
                    FontSize->12]}]}]}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, True, False, False, False, True, False}
              ,
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"Motion", "all"}],

Cell[TextData[{
  "X Motion",
  StyleBox[" submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"Motion", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]f\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]b\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]d\[RightModified]",
                        FontSize->12]}]], " "}],
                FontSize->12]},
            {
              StyleBox[\(Delete\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]h\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontSize->12], " "}]]}],
                FontSize->12]},
            {
              StyleBox[\(Move\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]",
                      FontSize->12]}]], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]",
                      FontSize->12]}]], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Next\ \ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    "2ColumnSmallBox"], "\[SkeletonIndicator]", 
                  StyleBox["\[DeleteKey]",
                    "2ColumnSmallBox"]}]]},
            {
              StyleBox[\(Delete\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    FontFamily->"Helvetica",
                    FontSize->12,
                    FontWeight->"Plain"], "\[SkeletonIndicator]", 
                  StyleBox["B",
                    "2ColumnSmallBox"], "ackspace"}]]},
            {
              StyleBox[\(Move\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "End"},
            {
              StyleBox[\(Move\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "Home"},
            {
              StyleBox[\(Move\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[DownArrow]",
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[UpArrow]",
                FontSize->12]}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, True, False, False, False, True, 
              False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"Motion", "all"}],

Cell["", "Notes",
  AspectRatioFixed->False,
  CellTags->{"editmotion", "all"}],

Cell[CellGroupData[{

Cell["\<\
Expression Input
\
\>", "Command",
  CellTags->"ExpressionInput"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Expression Input", "SR"],
  " submenu provides menu commands for the most common expression typesetting \
actions. This menu is intended primarily as a reference until you learn the",
  " ",
  "keyboard commands."
}], "Usage",
  CellTags->"ExpressionInput"],

Cell["", "Notes",
  CellTags->"ExpressionInput"],

Cell[TextData[{
  "Windows Expression Input ",
  StyleBox["Submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editexpression", "all", "ExpressionInput"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Superscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["^",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], "\[RightModified]"}], "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                "\[ControlKey]\[LeftModified]6\[RightModified]"}]},
            {
              StyleBox["Subscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] - \[RightModified]\)},
            {
              StyleBox["Above",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox["Below",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", "+", 
                  RowBox[{"\[RightModified]", "  ", 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], "   ", "\[ControlKey]\[LeftModified]"}]}]
                  , "=", "\[RightModified]"}]},
            {
              StyleBox[\(Opposite\ Position\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "%", "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                "\[ControlKey]\[LeftModified]5\[RightModified]"}]},
            {
              StyleBox["Fraction",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]/\[RightModified]\)},
            {
              StyleBox["Radical",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                \(\[ControlKey]\[LeftModified]@\[RightModified]\), "  ", 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], "  ", 
                  "\[ControlKey]\[LeftModified]2\[RightModified]"}], " "}]},
            {
              StyleBox[\(Add\ Row\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[SkeletonIndicator]\[ReturnKey]"},
            {
              StyleBox[\(Add\ Column\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], \(\[ControlKey]\[LeftModified]\ , 
              \[RightModified]\)},
            {
              StyleBox[\(End\ Subexpression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[SkeletonIndicator]\[SpaceKey]"},
            {
              StyleBox[\(Extend\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\(\[ControlKey]\[LeftModified]\  . \[RightModified]\)\(\ \)\)}
              ,
            {
              StyleBox[\(Start\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ControlKey]\[LeftModified]", 
                RowBox[{"(", " ", 
                  RowBox[{"\[RightModified]", "  ", 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], "  ", 
                    StyleBox[
                      RowBox[{"\[ControlKey]\[LeftModified]", 
                        StyleBox["9",
                          FontFamily->"Helvetica",
                          FontWeight->"Plain"], "\[RightModified]"}]]}]}]}]},
            {
              StyleBox[\(End\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              \(\(\[ControlKey]\[LeftModified]\)\(\ \)\()\)\), 
                "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["0",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              
              StyleBox[
                \(\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\(Insert\ Raw\ Expression
                  \)\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "*", "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["8",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Nudge\ Left\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[AltKey]\[LeftModified] \[ShortLeftArrow] \[RightModified]\)}
              ,
            {
              StyleBox[\(Nudge\ Right\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[AltKey]\[LeftModified] \[ShortRightArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Nudge\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[AltKey]\[LeftModified]\[DownArrow]\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[AltKey]\[LeftModified]\[UpArrow]\[RightModified]\)}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, False, True, False, True, False, True, 
              False, True, False, False, True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"editexpression", "all", "ExpressionInput"}],

Cell[TextData[{
  "Macintosh Expression Input",
  StyleBox[" ", "MR",
    FontWeight->"Plain"],
  StyleBox["Submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editexpression", "all", "ExpressionInput"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Superscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["^",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], "\[RightModified]"}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]6\[RightModified]"}]},
            {
              StyleBox["Subscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] - \[RightModified]\)},
            {
              StyleBox["Above",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox["Below",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", "+", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], "\[ControlKey]\[LeftModified]"}]}], "=", 
                "\[RightModified]"}]},
            {
              StyleBox[\(Opposite\ Position\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "%", "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]5\[RightModified]"}]},
            {
              StyleBox["Fraction",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]/\[RightModified]\)},
            {
              StyleBox["Radical",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontWeight->"Plain"], 
                RowBox[{\(\[ControlKey]\[LeftModified]@\[RightModified]\), 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  "\[ControlKey]\[LeftModified]2\[RightModified]"}], " "}]},
            {
              StyleBox[\(Add\ Row\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontWeight->"Plain"], 
                "\[ControlKey]\[LeftModified]\[ReturnKey]\[RightModified]"}]}
              ,
            {
              StyleBox[\(Add\ Column\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], \(\[ControlKey]\[LeftModified]\ , 
              \[RightModified]\)},
            {
              StyleBox[\(End\ Subexpression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]\[SpaceKey]\[RightModified]"},
            {
              StyleBox[\(Extend\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\(\[ControlKey]\[LeftModified]\  . \[RightModified]\)\(\ \)\)}
              ,
            {
              StyleBox[\(Start\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ControlKey]\[LeftModified]", 
                RowBox[{"(", " ", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox[
                      RowBox[{"\[ControlKey]\[LeftModified]", 
                        StyleBox["9",
                          FontFamily->"Helvetica",
                          FontWeight->"Plain"], "\[RightModified]"}]]}]}]}]},
            {
              StyleBox[\(End\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              \(\(\[ControlKey]\[LeftModified]\)\(\ \)\()\)\), 
                "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["0",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              RowBox[{"           ", 
                StyleBox[\(Insert\ Raw\ Expression\),
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain"]}], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "*", "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["8",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Nudge\ Left\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] \[ShortLeftArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Nudge\ Right\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] \[ShortRightArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Nudge\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]\[DownArrow]\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]\[UpArrow]\[RightModified]\)}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, False, True, False, True, False, True, 
              False, True, False, False, True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"editexpression", "all", "ExpressionInput"}],

Cell[TextData[{
  "X Expression Input",
  StyleBox[" Submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editexpression", "all", "ExpressionInput"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Superscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["^",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], "\[RightModified]"}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]6\[RightModified]"}]},
            {
              StyleBox["Subscript",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] - \[RightModified]\
\)},
            {
              StyleBox["Above",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox["Below",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", "+", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], "\[ControlKey]\[LeftModified]"}]}], "=", 
                "\[RightModified]"}]},
            {
              StyleBox[\(Opposite\ Position\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "%", "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]5\[RightModified]"}]},
            {
              StyleBox["Fraction",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[ControlKey]\[LeftModified]/\[RightModified]\)},
            {
              StyleBox["Radical",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontWeight->"Plain"], 
                RowBox[{\(\[ControlKey]\[LeftModified]@\[RightModified]\), 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  "\[ControlKey]\[LeftModified]2\[RightModified]"}], " "}]},
            {
              StyleBox[\(Add\ Row\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontWeight->"Plain"], 
                "\[ControlKey]\[LeftModified]\[ReturnKey]\[RightModified]"}]},\

            {
              StyleBox[\(Add\ Column\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified]\ , \
\[RightModified]\)},
            {
              StyleBox[\(End\ Subexpression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]\[SpaceKey]\[RightModified]"},
            {
              StyleBox[\(Extend\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\(\[ControlKey]\[LeftModified]\  . \
\[RightModified]\)\(\ \)\)},
            {
              StyleBox[\(Start\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ControlKey]\[LeftModified]", 
                RowBox[{"(", " ", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox[
                      RowBox[{"\[ControlKey]\[LeftModified]", 
                        StyleBox["9",
                          FontFamily->"Helvetica",
                          FontWeight->"Plain"], "\[RightModified]"}]]}]}]}]},
            {
              StyleBox[\(End\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              
              RowBox[{\(\(\[ControlKey]\[LeftModified]\)\(\ \)\()\)\), 
                "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["0",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              RowBox[{"           ", 
                StyleBox[\(Insert\ Raw\ Expression\),
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain"]}], 
              RowBox[{
                RowBox[{
                "\[ControlKey]\[LeftModified]", "*", "\[RightModified]", 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox[
                    RowBox[{"\[ControlKey]\[LeftModified]", 
                      StyleBox["8",
                        FontFamily->"Helvetica",
                        FontWeight->"Plain"], "\[RightModified]"}]]}], 
                "\t"}]},
            {
              StyleBox[\(Nudge\ Left\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] \[ShortLeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Right\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] \[ShortRightArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified]\[DownArrow]\
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified]\[UpArrow]\
\[RightModified]\)}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, False, True, False, True, False, True, 
              False, True, False, False, True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"editexpression", "all", "ExpressionInput"}],

Cell[TextData[{
  "\[FilledSmallSquare] See",
  " ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.10.2",
    ButtonData:>{"1.10.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"ExpressionInput"]
}, Closed]],

Cell[CellGroupData[{

Cell["Spanning Characters", "Command",
  CellTags->"Spanning Characters"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Spanning Characters", "SR"],
  " submenu provides menu commands for controlling the height of expandable",
  " ",
  "characters. "
}], "Usage",
  CellTags->"Spanning Characters"],

Cell[TextData[
"\[FilledSmallSquare] Examples are parentheses, which by default are taken to \
expand so as to span any expression they contain. "], "Notes",
  CellTags->"Spanning Characters"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.10.11",
    ButtonData:>{"2.10.11"},
    ButtonStyle->"MainBookLink"],
  " on ",
  StyleBox["SpanMinSize", "MR"],
  ", ",
  StyleBox["SpanMaxSize", "MR"],
  ", ",
  StyleBox["SpanSymmetric", "MR"],
  ", and ",
  StyleBox["SpanLineThickness", "MR"],
  "."
}], "Notes",
  CellTags->"Spanning Characters"]
}, Closed]],

Cell[CellGroupData[{

Cell["Insert Raw Expression...", "Command",
  CellTags->"InsertRaw"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Insert Raw Expression", "SR"],
  " gives you a dialog box for pasting a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " expression directly into your notebook."
}], "Usage",
  CellTags->"InsertRaw"],

Cell[TextData[{
  "\[FilledSmallSquare] This command is intended for advanced users, who are \
familiar with the expression syntax of elements in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The text entered in this dialog must be the correct underlying",
  " ",
  "expression representing the desired element."
}], "Notes",
  CellTags->"InsertRaw"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["*", "C1MR"],
  StyleBox["\[RightModified]", "C1"],
  " ",
  StyleBox["or ", "Notes"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["8", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["*", "C1MR"],
  StyleBox["\[RightModified]", "C1"],
  " ",
  StyleBox["or ", "Notes"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["8", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh)",
  StyleBox[";", "Notes"],
  " ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["*", "C1MR"],
  StyleBox["\[RightModified]", "C1"],
  " ",
  StyleBox["or ", "Notes"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["8", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"InsertRaw"],

Cell[TextData[{
  "\[FilledSmallSquare] See",
  " ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.1",
    ButtonData:>{"2.11.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"InsertRaw"]
}, Closed]],

Cell[CellGroupData[{

Cell["Add Frame", "Command",
  CellTags->"AddFrame"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Add Frame", "SR"],
  " wraps a frame box around the current selection."
}], "Usage",
  CellTags->"AddFrame"],

Cell["\<\
\[FilledSmallSquare] In text cells, the frame box is created as an \
inline cell.\
\>", "Notes",
  CellTags->"AddFrame"]
}, Closed]],

Cell[CellGroupData[{

Cell["Add Interpretation...", "Command",
  CellTags->"AddInterpretation"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Add ", "SR"],
  StyleBox["Interpretation",
    FontFamily->"Helvetica"],
  " wraps the current selection in an ",
  StyleBox["InterpretationBox",
    FontFamily->"Courier"],
  " or ",
  StyleBox["TagBox",
    FontFamily->"Courier"],
  "."
}], "Usage",
  CellTags->"AddInterpretation"],

Cell[TextData[{
  "\[FilledSmallSquare] The menu command brings up a dialog box, which allows \
you to choose the type of box and to set the options supported by it.\n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.10.10",
    ButtonData:>{"2.10.10"},
    ButtonStyle->"MainBookLink"],
  ". \n\[FilledSmallSquare] See: ",
  StyleBox[ButtonBox["InterpretationBox",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  ", ",
  StyleBox[ButtonBox["TagBox",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->"AddInterpretation"]
}, Closed]],

Cell[CellGroupData[{

Cell["Make 2D", "Command",
  CellTags->"Make2D"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Make 2D", "SR"],
  " converts linear syntax expressions that were entered directly from the",
  " ",
  "keyboard into two-dimensional form."
}], "Usage",
  CellTags->"Make2D"],

Cell[TextData[{
  "\[FilledSmallSquare] For example,",
  StyleBox[" \\!\\(c\\_2\\)", "MR"],
  " becomes ",
  Cell[BoxData[
      \(c\_2\)], "Input"],
  "."
}], "Notes",
  CellTags->"Make2D"]
}, Closed]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh)",
  StyleBox[";", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Make2D"],

Cell[CellGroupData[{

Cell["Check Balance", "Command",
  CellTags->"CheckBalance"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Check Balance", "SR"],
  " expands the selection to cover the nearest pair of matched bracketing",
  " ",
  "characters. This command selects nested (",
  StyleBox["e.g",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[".",
    FontWeight->"ExtraLight"],
  ", parenthesized) expressions outward from the insertion point."
}], "Usage",
  CellTags->"CheckBalance"],

Cell["\<\
\[FilledSmallSquare] To select a nested expression:\
\>", "Notes",
  CellTags->"CheckBalance"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  " Select anywhere within the expression by clicking.\n",
  StyleBox["2.",
    FontWeight->"Bold"],
  " Choose ",
  StyleBox["Check Balance", "SR"],
  ".\n",
  StyleBox["3.",
    FontWeight->"Bold"],
  " Repeat to expand the selection to the pair of enclosing",
  " ",
  "parentheses, brackets, or braces."
}], "ItemizedText",
  CellTags->"CheckBalance"],

Cell[TextData[{
  "\[FilledSmallSquare] Each time you choose ",
  StyleBox["Check Balance", "SR"],
  ", ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " expands the selection in both directions until it finds pairs of matching \
parentheses, brackets, or braces. Repeating the command expands the selection \
one level at a time."
}], "Notes",
  CellTags->"CheckBalance"],

Cell[TextData[{
  "\[FilledSmallSquare] You can use the ",
  StyleBox["Check Balance", "SR"],
  " command to check the structure of mathematical expressions. If you have \
unbalanced parentheses, for example, or parentheses incorrectly balanced with \
brackets or braces, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " beeps. (Choose ",
  StyleBox["Why the Beep?", "SR"],
  " to identify the mistake.) If you position the insertion point (blinking \
vertical bar) inside a bracketed expression and choose ",
  StyleBox["Check Balance", "SR"],
  ", ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " should select the whole expression. If not, you have a missing bracket",
  " ",
  "somewhere."
}], "Notes",
  CellTags->"CheckBalance"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " cannot balance a selection that spans more than one cell."
}], "Notes",
  CellTags->"CheckBalance"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["b", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["b", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh)",
  StyleBox[";", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["b", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CheckBalance"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check Spelling...", "Command",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Check Spelling",
    FontFamily->"Helvetica"],
  " searches for the next misspelled word and brings up the spell check \
dialog box."
}], "Usage",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],

Cell["\<\
\[FilledSmallSquare] When a misspelled word is found, it is \
displayed in the dialog box along with a list of suggested alternatives. \
Click a suggested word to copy it to the \"Replace with:\" field. \
Double-click a suggested word to paste it into the notebook and continue the \
search.\
\>", "Notes",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}]
}, Closed]],

Cell["\<\
\[FilledSmallSquare] There are several possible reasons for \
stopping at a word. The reason for stopping is given in a string at the top \
of the dialog box. Click \"Skip These\" if you do not wish to stop for the \
same reason again.\
\>", "Notes",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],

Cell["\<\
\[FilledSmallSquare] To continue the search without replacing the \
selected word, click \"Skip\". Click \"Add Word\" to add the selected word to \
the dictionary. All future occurrences of that word will then be \
ignored.\
\>", "Notes",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can modify the conditions used for stopping at or \
skipping words by changing the settings for the options \"Always Stop\", \
\"Always Skip\", and \"Word Splitting\". To do this, click the Options button \
to open the Option Inspector at the scope specified by the \"Store words and \
options:\" pop-up menu. \n\[FilledSmallSquare] See: ",
  ButtonBox["Spelling options",
    ButtonData:>"SpellingOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
  ".    "
}], "Notes",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[AltKey]\[LeftModified]", "C1"],
  StyleBox[";", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox[";", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(", "Notes"],
  "Macintosh)",
  StyleBox[";", "Notes"],
  "  ",
  StyleBox["\[AltKey]\[LeftModified]", "C1"],
  StyleBox[";", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],

Cell[CellGroupData[{

Cell["Preferences...", "Command",
  CellTags->"OptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Preferences", "SR"],
  " opens the Option Inspector, showing settings for global preferences. \
(Windows and X only.)"
}], "Usage",
  CellTags->"OptionsDialog"]
}, Closed]],

Cell[TextData[{
  "\[FilledSmallSquare] On Mac OS X, the Preferences menu is located under \
the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Application menu. "
}], "Notes",
  CellTags->"OptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Front End Options",
    ButtonData:>"The Option Inspector",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"OptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["O", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["O", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["O", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"OptionsDialog"]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1152}, {0, 848}},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{563, 551},
WindowMargins->{{2, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Undo"->{
    Cell[1776, 53, 43, 1, 41, "Command",
      CellTags->"Undo"],
    Cell[1822, 56, 136, 5, 32, "Usage",
      CellTags->"Undo"],
    Cell[1961, 63, 235, 5, 40, "Notes",
      CellTags->"Undo"],
    Cell[2199, 70, 372, 8, 56, "Notes",
      CellTags->"Undo"],
    Cell[2574, 80, 609, 20, 24, "Notes",
      CellTags->"Undo"]},
  "Cut"->{
    Cell[3220, 105, 41, 1, 45, "Command",
      CellTags->"Cut"],
    Cell[3264, 108, 165, 5, 32, "Usage",
      CellTags->"Cut"],
    Cell[3432, 115, 139, 4, 24, "Text",
      CellTags->"Cut"],
    Cell[3574, 121, 247, 11, 44, "ItemizedText",
      CellTags->"Cut"],
    Cell[3824, 134, 159, 5, 26, "NotesList",
      CellTags->"Cut"],
    Cell[3986, 141, 608, 20, 24, "Notes",
      CellTags->"Cut"]},
  "Copy"->{
    Cell[4631, 166, 43, 1, 45, "Command",
      CellTags->"Copy"],
    Cell[4677, 169, 204, 7, 32, "Usage",
      CellTags->"Copy"],
    Cell[4884, 178, 162, 6, 24, "Notes",
      CellTags->"Copy"],
    Cell[5049, 186, 252, 11, 44, "ItemizedText",
      CellTags->"Copy"],
    Cell[5304, 199, 220, 7, 42, "NotesList",
      CellTags->"Copy"],
    Cell[5527, 208, 609, 20, 24, "Notes",
      CellTags->"Copy"]},
  "Paste"->{
    Cell[6173, 233, 45, 1, 45, "Command",
      CellTags->"Paste"],
    Cell[6221, 236, 155, 5, 32, "Usage",
      CellTags->"Paste"],
    Cell[6379, 243, 145, 5, 24, "Notes",
      CellTags->"Paste"],
    Cell[6527, 250, 305, 11, 44, "ItemizedText",
      CellTags->"Paste"],
    Cell[6835, 263, 182, 6, 24, "Notes",
      CellTags->"Paste"],
    Cell[7020, 271, 307, 11, 44, "ItemizedText",
      CellTags->"Paste"],
    Cell[7330, 284, 210, 7, 26, "NotesList",
      CellTags->"Paste"],
    Cell[7543, 293, 142, 5, 24, "Notes",
      CellTags->"Paste"],
    Cell[7688, 300, 261, 11, 44, "ItemizedText",
      CellTags->"Paste"],
    Cell[7952, 313, 241, 9, 26, "NotesList",
      CellTags->"Paste"],
    Cell[8196, 324, 433, 12, 56, "Notes",
      CellTags->"Paste"],
    Cell[8632, 338, 312, 8, 56, "Notes",
      CellTags->"Paste"],
    Cell[8947, 348, 610, 20, 24, "Notes",
      CellTags->"Paste"]},
  "Clear"->{
    Cell[9594, 373, 45, 1, 45, "Command",
      CellTags->"Clear"],
    Cell[9642, 376, 175, 5, 32, "Usage",
      CellTags->"Clear"],
    Cell[9820, 383, 352, 13, 24, "Notes",
      CellTags->"Clear"],
    Cell[10175, 398, 496, 17, 24, "Notes",
      CellTags->"Clear"]},
  "CopySpecial"->{
    Cell[10708, 420, 53, 1, 45, "Command",
      CellTags->"CopySpecial"],
    Cell[10764, 423, 176, 5, 32, "Usage",
      CellTags->"CopySpecial"],
    Cell[10943, 430, 515, 10, 122, "Notes",
      CellTags->"CopySpecial"]},
  "PasteAs"->{
    Cell[11495, 445, 50, 1, 45, "Command",
      CellTags->"PasteAs"],
    Cell[11548, 448, 208, 6, 32, "Usage",
      CellTags->"PasteAs"],
    Cell[11759, 456, 315, 6, 56, "Notes",
      CellTags->"PasteAs"],
    Cell[12077, 464, 479, 10, 56, "Notes",
      CellTags->"PasteAs"],
    Cell[12559, 476, 549, 14, 72, "Notes",
      CellTags->"PasteAs"]},
  "ExternalClipboard"->{
    Cell[13145, 495, 70, 1, 45, "Command",
      CellTags->"ExternalClipboard"],
    Cell[13218, 498, 277, 8, 32, "Usage",
      CellTags->"ExternalClipboard"],
    Cell[13498, 508, 1297, 33, 170, "Notes",
      CellTags->"ExternalClipboard"]},
  "SelectionSaveSpecial"->{
    Cell[14832, 546, 72, 1, 45, "Command",
      CellTags->"SelectionSaveSpecial"],
    Cell[14907, 549, 209, 7, 32, "Usage",
      CellTags->"SelectionSaveSpecial"],
    Cell[15119, 558, 608, 11, 138, "Notes",
      CellTags->"SelectionSaveSpecial"]},
  "SelectAll"->{
    Cell[15764, 574, 54, 1, 45, "Command",
      CellTags->"SelectAll"],
    Cell[15821, 577, 160, 5, 32, "Usage",
      CellTags->"SelectAll"],
    Cell[15984, 584, 620, 21, 24, "Notes",
      CellTags->"SelectAll"]},
  "InsertObject"->{
    Cell[16641, 610, 60, 1, 45, "Command",
      CellTags->"InsertObject"],
    Cell[16704, 613, 219, 6, 32, "Usage",
      CellTags->"InsertObject"],
    Cell[16938, 622, 102, 2, 17, "DialogItem",
      CellTags->"InsertObject"],
    Cell[17043, 626, 89, 1, 24, "IndentedText",
      CellTags->"InsertObject"],
    Cell[17135, 629, 103, 2, 25, "DialogItem",
      CellTags->"InsertObject"],
    Cell[17241, 633, 184, 5, 42, "IndentedText",
      CellTags->"InsertObject"],
    Cell[17428, 640, 108, 2, 25, "DialogItem",
      CellTags->"InsertObject"],
    Cell[17539, 644, 79, 1, 24, "IndentedText",
      CellTags->"InsertObject"],
    Cell[17621, 647, 96, 2, 25, "DialogItem",
      CellTags->"InsertObject"],
    Cell[17720, 651, 184, 4, 42, "IndentedText",
      CellTags->"InsertObject"],
    Cell[17907, 657, 98, 2, 25, "DialogItem",
      CellTags->"InsertObject"],
    Cell[18008, 661, 146, 4, 24, "IndentedText",
      CellTags->"InsertObject"],
    Cell[18157, 667, 96, 2, 25, "DialogItem",
      CellTags->"InsertObject"],
    Cell[18256, 671, 125, 4, 24, "IndentedText",
      CellTags->"InsertObject"],
    Cell[18384, 677, 65, 1, 25, "DialogItem",
      CellTags->"InsertObject"],
    Cell[18452, 680, 92, 1, 24, "IndentedText",
      CellTags->"InsertObject"],
    Cell[18547, 683, 103, 2, 25, "DialogItem",
      CellTags->"InsertObject"],
    Cell[18653, 687, 185, 5, 42, "IndentedText",
      CellTags->"InsertObject"],
    Cell[18841, 694, 56, 1, 25, "DialogItem",
      CellTags->"InsertObject"],
    Cell[18900, 697, 97, 1, 24, "IndentedText",
      CellTags->"InsertObject"]},
  "Motion"->{
    Cell[19022, 702, 47, 1, 41, "Command",
      CellTags->"Motion"],
    Cell[19072, 705, 290, 8, 48, "Usage",
      CellTags->{"Motion", "all"}],
    Cell[19365, 715, 39, 1, 24, "Notes",
      CellTags->"Motion"],
    Cell[19419, 719, 172, 6, 34, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[19594, 727, 4413, 124, 233, "Text",
      CellTags->{"Motion", "all"}],
    Cell[24010, 853, 174, 6, 34, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[24187, 861, 11906, 314, 253, "Text",
      CellTags->{"Motion", "all"}],
    Cell[36096, 1177, 166, 6, 34, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[36265, 1185, 7205, 195, 241, "Text",
      CellTags->{"Motion", "all"}]},
  "all"->{
    Cell[19072, 705, 290, 8, 48, "Usage",
      CellTags->{"Motion", "all"}],
    Cell[19419, 719, 172, 6, 34, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[19594, 727, 4413, 124, 233, "Text",
      CellTags->{"Motion", "all"}],
    Cell[24010, 853, 174, 6, 34, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[24187, 861, 11906, 314, 253, "Text",
      CellTags->{"Motion", "all"}],
    Cell[36096, 1177, 166, 6, 34, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[36265, 1185, 7205, 195, 241, "Text",
      CellTags->{"Motion", "all"}],
    Cell[43473, 1382, 79, 2, 24, "Notes",
      CellTags->{"editmotion", "all"}],
    Cell[44025, 1407, 209, 6, 34, "Subsubsection",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[44237, 1415, 7693, 195, 361, "Text",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[51933, 1612, 258, 8, 34, "Subsubsection",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[52194, 1622, 8810, 228, 365, "Text",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[61007, 1852, 203, 6, 34, "Subsubsection",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[61213, 1860, 8992, 243, 365, "Text",
      CellTags->{"editexpression", "all", "ExpressionInput"}]},
  "editmotion"->{
    Cell[43473, 1382, 79, 2, 24, "Notes",
      CellTags->{"editmotion", "all"}]},
  "ExpressionInput"->{
    Cell[43577, 1388, 75, 4, 64, "Command",
      CellTags->"ExpressionInput"],
    Cell[43655, 1394, 316, 8, 48, "Usage",
      CellTags->"ExpressionInput"],
    Cell[43974, 1404, 48, 1, 24, "Notes",
      CellTags->"ExpressionInput"],
    Cell[44025, 1407, 209, 6, 34, "Subsubsection",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[44237, 1415, 7693, 195, 361, "Text",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[51933, 1612, 258, 8, 34, "Subsubsection",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[52194, 1622, 8810, 228, 365, "Text",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[61007, 1852, 203, 6, 34, "Subsubsection",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[61213, 1860, 8992, 243, 365, "Text",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[70208, 2105, 263, 11, 24, "Notes",
      CellTags->"ExpressionInput"]},
  "editexpression"->{
    Cell[44025, 1407, 209, 6, 34, "Subsubsection",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[44237, 1415, 7693, 195, 361, "Text",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[51933, 1612, 258, 8, 34, "Subsubsection",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[52194, 1622, 8810, 228, 365, "Text",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[61007, 1852, 203, 6, 34, "Subsubsection",
      CellTags->{"editexpression", "all", "ExpressionInput"}],
    Cell[61213, 1860, 8992, 243, 365, "Text",
      CellTags->{"editexpression", "all", "ExpressionInput"}]},
  "Spanning Characters"->{
    Cell[70508, 2121, 73, 1, 45, "Command",
      CellTags->"Spanning Characters"],
    Cell[70584, 2124, 237, 7, 48, "Usage",
      CellTags->"Spanning Characters"],
    Cell[70824, 2133, 192, 3, 40, "Notes",
      CellTags->"Spanning Characters"],
    Cell[71019, 2138, 441, 18, 40, "Notes",
      CellTags->"Spanning Characters"]},
  "InsertRaw"->{
    Cell[71497, 2161, 68, 1, 45, "Command",
      CellTags->"InsertRaw"],
    Cell[71568, 2164, 323, 11, 48, "Usage",
      CellTags->"InsertRaw"],
    Cell[71894, 2177, 364, 9, 56, "Notes",
      CellTags->"InsertRaw"],
    Cell[72261, 2188, 1058, 35, 24, "Notes",
      CellTags->"InsertRaw"],
    Cell[73322, 2225, 257, 11, 24, "Notes",
      CellTags->"InsertRaw"]},
  "AddFrame"->{
    Cell[73616, 2241, 52, 1, 45, "Command",
      CellTags->"AddFrame"],
    Cell[73671, 2244, 163, 5, 32, "Usage",
      CellTags->"AddFrame"],
    Cell[73837, 2251, 130, 4, 24, "Notes",
      CellTags->"AddFrame"]},
  "AddInterpretation"->{
    Cell[74004, 2260, 73, 1, 45, "Command",
      CellTags->"AddInterpretation"],
    Cell[74080, 2263, 339, 13, 32, "Usage",
      CellTags->"AddInterpretation"],
    Cell[74422, 2278, 653, 20, 84, "Notes",
      CellTags->"AddInterpretation"]},
  "Make2D"->{
    Cell[75112, 2303, 48, 1, 45, "Command",
      CellTags->"Make2D"],
    Cell[75163, 2306, 230, 7, 48, "Usage",
      CellTags->"Make2D"],
    Cell[75396, 2315, 190, 8, 24, "Notes",
      CellTags->"Make2D"],
    Cell[75601, 2326, 743, 23, 20, "Notes",
      CellTags->"Make2D"]},
  "CheckBalance"->{
    Cell[76369, 2353, 60, 1, 41, "Command",
      CellTags->"CheckBalance"],
    Cell[76432, 2356, 436, 13, 48, "Usage",
      CellTags->"CheckBalance"],
    Cell[76871, 2371, 104, 3, 24, "Notes",
      CellTags->"CheckBalance"],
    Cell[76978, 2376, 413, 15, 62, "ItemizedText",
      CellTags->"CheckBalance"],
    Cell[77394, 2393, 411, 11, 56, "Notes",
      CellTags->"CheckBalance"],
    Cell[77808, 2406, 814, 22, 88, "Notes",
      CellTags->"CheckBalance"],
    Cell[78625, 2430, 228, 7, 24, "Notes",
      CellTags->"CheckBalance"],
    Cell[78856, 2439, 749, 23, 24, "Notes",
      CellTags->"CheckBalance"]},
  "CheckSpelling"->{
    Cell[79642, 2467, 91, 1, 45, "Command",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[79736, 2470, 256, 7, 32, "Usage",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[79995, 2479, 371, 7, 56, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[80381, 2489, 315, 6, 52, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[80699, 2497, 303, 6, 40, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[81005, 2505, 578, 11, 94, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[81586, 2518, 637, 20, 24, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}]},
  "spellCheckerDialogID"->{
    Cell[79642, 2467, 91, 1, 45, "Command",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[79736, 2470, 256, 7, 32, "Usage",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[79995, 2479, 371, 7, 56, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[80381, 2489, 315, 6, 52, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[80699, 2497, 303, 6, 40, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[81005, 2505, 578, 11, 94, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
    Cell[81586, 2518, 637, 20, 24, "Notes",
      CellTags->{"CheckSpelling", "spellCheckerDialogID"}]},
  "OptionsDialog"->{
    Cell[82248, 2542, 62, 1, 41, "Command",
      CellTags->"OptionsDialog"],
    Cell[82313, 2545, 215, 6, 32, "Usage",
      CellTags->"OptionsDialog"],
    Cell[82543, 2554, 217, 7, 20, "Notes",
      CellTags->"OptionsDialog"],
    Cell[82763, 2563, 210, 7, 24, "Notes",
      CellTags->"OptionsDialog"],
    Cell[82976, 2572, 648, 18, 24, "Notes",
      CellTags->"OptionsDialog"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Undo", 84376, 2613},
  {"Cut", 84715, 2624},
  {"Copy", 85131, 2637},
  {"Paste", 85555, 2650},
  {"Clear", 86475, 2677},
  {"CopySpecial", 86767, 2686},
  {"PasteAs", 87008, 2693},
  {"ExternalClipboard", 87387, 2704},
  {"SelectionSaveSpecial", 87660, 2711},
  {"SelectAll", 87930, 2718},
  {"InsertObject", 88169, 2725},
  {"Motion", 89784, 2766},
  {"all", 90516, 2785},
  {"editmotion", 91868, 2814},
  {"ExpressionInput", 91974, 2817},
  {"editexpression", 92983, 2838},
  {"Spanning Characters", 93680, 2851},
  {"InsertRaw", 94032, 2860},
  {"AddFrame", 94419, 2871},
  {"AddInterpretation", 94662, 2878},
  {"Make2D", 94923, 2885},
  {"CheckBalance", 95226, 2894},
  {"CheckSpelling", 95869, 2911},
  {"spellCheckerDialogID", 96622, 2926},
  {"OptionsDialog", 97368, 2941}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 43, 1, 41, "Command",
  CellTags->"Undo"],
Cell[1822, 56, 136, 5, 32, "Usage",
  CellTags->"Undo"],
Cell[1961, 63, 235, 5, 40, "Notes",
  CellTags->"Undo"],
Cell[2199, 70, 372, 8, 56, "Notes",
  CellTags->"Undo"],
Cell[2574, 80, 609, 20, 24, "Notes",
  CellTags->"Undo"]
}, Closed]],

Cell[CellGroupData[{
Cell[3220, 105, 41, 1, 45, "Command",
  CellTags->"Cut"],
Cell[3264, 108, 165, 5, 32, "Usage",
  CellTags->"Cut"],
Cell[3432, 115, 139, 4, 24, "Text",
  CellTags->"Cut"],
Cell[3574, 121, 247, 11, 44, "ItemizedText",
  CellTags->"Cut"],
Cell[3824, 134, 159, 5, 26, "NotesList",
  CellTags->"Cut"],
Cell[3986, 141, 608, 20, 24, "Notes",
  CellTags->"Cut"]
}, Closed]],

Cell[CellGroupData[{
Cell[4631, 166, 43, 1, 45, "Command",
  CellTags->"Copy"],
Cell[4677, 169, 204, 7, 32, "Usage",
  CellTags->"Copy"],
Cell[4884, 178, 162, 6, 24, "Notes",
  CellTags->"Copy"],
Cell[5049, 186, 252, 11, 44, "ItemizedText",
  CellTags->"Copy"],
Cell[5304, 199, 220, 7, 42, "NotesList",
  CellTags->"Copy"],
Cell[5527, 208, 609, 20, 24, "Notes",
  CellTags->"Copy"]
}, Closed]],

Cell[CellGroupData[{
Cell[6173, 233, 45, 1, 45, "Command",
  CellTags->"Paste"],
Cell[6221, 236, 155, 5, 32, "Usage",
  CellTags->"Paste"],
Cell[6379, 243, 145, 5, 24, "Notes",
  CellTags->"Paste"],
Cell[6527, 250, 305, 11, 44, "ItemizedText",
  CellTags->"Paste"],
Cell[6835, 263, 182, 6, 24, "Notes",
  CellTags->"Paste"],
Cell[7020, 271, 307, 11, 44, "ItemizedText",
  CellTags->"Paste"],
Cell[7330, 284, 210, 7, 26, "NotesList",
  CellTags->"Paste"],
Cell[7543, 293, 142, 5, 24, "Notes",
  CellTags->"Paste"],
Cell[7688, 300, 261, 11, 44, "ItemizedText",
  CellTags->"Paste"],
Cell[7952, 313, 241, 9, 26, "NotesList",
  CellTags->"Paste"],
Cell[8196, 324, 433, 12, 56, "Notes",
  CellTags->"Paste"],
Cell[8632, 338, 312, 8, 56, "Notes",
  CellTags->"Paste"],
Cell[8947, 348, 610, 20, 24, "Notes",
  CellTags->"Paste"]
}, Closed]],

Cell[CellGroupData[{
Cell[9594, 373, 45, 1, 45, "Command",
  CellTags->"Clear"],
Cell[9642, 376, 175, 5, 32, "Usage",
  CellTags->"Clear"],
Cell[9820, 383, 352, 13, 24, "Notes",
  CellTags->"Clear"],
Cell[10175, 398, 496, 17, 24, "Notes",
  CellTags->"Clear"]
}, Closed]],

Cell[CellGroupData[{
Cell[10708, 420, 53, 1, 45, "Command",
  CellTags->"CopySpecial"],
Cell[10764, 423, 176, 5, 32, "Usage",
  CellTags->"CopySpecial"],
Cell[10943, 430, 515, 10, 122, "Notes",
  CellTags->"CopySpecial"]
}, Closed]],

Cell[CellGroupData[{
Cell[11495, 445, 50, 1, 45, "Command",
  CellTags->"PasteAs"],
Cell[11548, 448, 208, 6, 32, "Usage",
  CellTags->"PasteAs"],
Cell[11759, 456, 315, 6, 56, "Notes",
  CellTags->"PasteAs"],
Cell[12077, 464, 479, 10, 56, "Notes",
  CellTags->"PasteAs"],
Cell[12559, 476, 549, 14, 72, "Notes",
  CellTags->"PasteAs"]
}, Closed]],

Cell[CellGroupData[{
Cell[13145, 495, 70, 1, 45, "Command",
  CellTags->"ExternalClipboard"],
Cell[13218, 498, 277, 8, 32, "Usage",
  CellTags->"ExternalClipboard"],
Cell[13498, 508, 1297, 33, 170, "Notes",
  CellTags->"ExternalClipboard"]
}, Closed]],

Cell[CellGroupData[{
Cell[14832, 546, 72, 1, 45, "Command",
  CellTags->"SelectionSaveSpecial"],
Cell[14907, 549, 209, 7, 32, "Usage",
  CellTags->"SelectionSaveSpecial"],
Cell[15119, 558, 608, 11, 138, "Notes",
  CellTags->"SelectionSaveSpecial"]
}, Closed]],

Cell[CellGroupData[{
Cell[15764, 574, 54, 1, 45, "Command",
  CellTags->"SelectAll"],
Cell[15821, 577, 160, 5, 32, "Usage",
  CellTags->"SelectAll"],
Cell[15984, 584, 620, 21, 24, "Notes",
  CellTags->"SelectAll"]
}, Closed]],

Cell[CellGroupData[{
Cell[16641, 610, 60, 1, 45, "Command",
  CellTags->"InsertObject"],
Cell[16704, 613, 219, 6, 32, "Usage",
  CellTags->"InsertObject"]
}, Closed]],
Cell[16938, 622, 102, 2, 17, "DialogItem",
  CellTags->"InsertObject"],
Cell[17043, 626, 89, 1, 24, "IndentedText",
  CellTags->"InsertObject"],
Cell[17135, 629, 103, 2, 25, "DialogItem",
  CellTags->"InsertObject"],
Cell[17241, 633, 184, 5, 42, "IndentedText",
  CellTags->"InsertObject"],
Cell[17428, 640, 108, 2, 25, "DialogItem",
  CellTags->"InsertObject"],
Cell[17539, 644, 79, 1, 24, "IndentedText",
  CellTags->"InsertObject"],
Cell[17621, 647, 96, 2, 25, "DialogItem",
  CellTags->"InsertObject"],
Cell[17720, 651, 184, 4, 42, "IndentedText",
  CellTags->"InsertObject"],
Cell[17907, 657, 98, 2, 25, "DialogItem",
  CellTags->"InsertObject"],
Cell[18008, 661, 146, 4, 24, "IndentedText",
  CellTags->"InsertObject"],
Cell[18157, 667, 96, 2, 25, "DialogItem",
  CellTags->"InsertObject"],
Cell[18256, 671, 125, 4, 24, "IndentedText",
  CellTags->"InsertObject"],
Cell[18384, 677, 65, 1, 25, "DialogItem",
  CellTags->"InsertObject"],
Cell[18452, 680, 92, 1, 24, "IndentedText",
  CellTags->"InsertObject"],
Cell[18547, 683, 103, 2, 25, "DialogItem",
  CellTags->"InsertObject"],
Cell[18653, 687, 185, 5, 42, "IndentedText",
  CellTags->"InsertObject"],
Cell[18841, 694, 56, 1, 25, "DialogItem",
  CellTags->"InsertObject"],
Cell[18900, 697, 97, 1, 24, "IndentedText",
  CellTags->"InsertObject"],

Cell[CellGroupData[{
Cell[19022, 702, 47, 1, 41, "Command",
  CellTags->"Motion"],
Cell[19072, 705, 290, 8, 48, "Usage",
  CellTags->{"Motion", "all"}],
Cell[19365, 715, 39, 1, 24, "Notes",
  CellTags->"Motion"]
}, Closed]],
Cell[19419, 719, 172, 6, 34, "Subsubsection",
  CellTags->{"Motion", "all"}],
Cell[19594, 727, 4413, 124, 233, "Text",
  CellTags->{"Motion", "all"}],
Cell[24010, 853, 174, 6, 34, "Subsubsection",
  CellTags->{"Motion", "all"}],
Cell[24187, 861, 11906, 314, 253, "Text",
  CellTags->{"Motion", "all"}],
Cell[36096, 1177, 166, 6, 34, "Subsubsection",
  CellTags->{"Motion", "all"}],
Cell[36265, 1185, 7205, 195, 241, "Text",
  CellTags->{"Motion", "all"}],
Cell[43473, 1382, 79, 2, 24, "Notes",
  CellTags->{"editmotion", "all"}],

Cell[CellGroupData[{
Cell[43577, 1388, 75, 4, 64, "Command",
  CellTags->"ExpressionInput"],
Cell[43655, 1394, 316, 8, 48, "Usage",
  CellTags->"ExpressionInput"],
Cell[43974, 1404, 48, 1, 24, "Notes",
  CellTags->"ExpressionInput"],
Cell[44025, 1407, 209, 6, 34, "Subsubsection",
  CellTags->{"editexpression", "all", "ExpressionInput"}],
Cell[44237, 1415, 7693, 195, 361, "Text",
  CellTags->{"editexpression", "all", "ExpressionInput"}],
Cell[51933, 1612, 258, 8, 34, "Subsubsection",
  CellTags->{"editexpression", "all", "ExpressionInput"}],
Cell[52194, 1622, 8810, 228, 365, "Text",
  CellTags->{"editexpression", "all", "ExpressionInput"}],
Cell[61007, 1852, 203, 6, 34, "Subsubsection",
  CellTags->{"editexpression", "all", "ExpressionInput"}],
Cell[61213, 1860, 8992, 243, 365, "Text",
  CellTags->{"editexpression", "all", "ExpressionInput"}],
Cell[70208, 2105, 263, 11, 24, "Notes",
  CellTags->"ExpressionInput"]
}, Closed]],

Cell[CellGroupData[{
Cell[70508, 2121, 73, 1, 45, "Command",
  CellTags->"Spanning Characters"],
Cell[70584, 2124, 237, 7, 48, "Usage",
  CellTags->"Spanning Characters"],
Cell[70824, 2133, 192, 3, 40, "Notes",
  CellTags->"Spanning Characters"],
Cell[71019, 2138, 441, 18, 40, "Notes",
  CellTags->"Spanning Characters"]
}, Closed]],

Cell[CellGroupData[{
Cell[71497, 2161, 68, 1, 45, "Command",
  CellTags->"InsertRaw"],
Cell[71568, 2164, 323, 11, 48, "Usage",
  CellTags->"InsertRaw"],
Cell[71894, 2177, 364, 9, 56, "Notes",
  CellTags->"InsertRaw"],
Cell[72261, 2188, 1058, 35, 24, "Notes",
  CellTags->"InsertRaw"],
Cell[73322, 2225, 257, 11, 24, "Notes",
  CellTags->"InsertRaw"]
}, Closed]],

Cell[CellGroupData[{
Cell[73616, 2241, 52, 1, 45, "Command",
  CellTags->"AddFrame"],
Cell[73671, 2244, 163, 5, 32, "Usage",
  CellTags->"AddFrame"],
Cell[73837, 2251, 130, 4, 24, "Notes",
  CellTags->"AddFrame"]
}, Closed]],

Cell[CellGroupData[{
Cell[74004, 2260, 73, 1, 45, "Command",
  CellTags->"AddInterpretation"],
Cell[74080, 2263, 339, 13, 32, "Usage",
  CellTags->"AddInterpretation"],
Cell[74422, 2278, 653, 20, 84, "Notes",
  CellTags->"AddInterpretation"]
}, Closed]],

Cell[CellGroupData[{
Cell[75112, 2303, 48, 1, 45, "Command",
  CellTags->"Make2D"],
Cell[75163, 2306, 230, 7, 48, "Usage",
  CellTags->"Make2D"],
Cell[75396, 2315, 190, 8, 24, "Notes",
  CellTags->"Make2D"]
}, Closed]],
Cell[75601, 2326, 743, 23, 20, "Notes",
  CellTags->"Make2D"],

Cell[CellGroupData[{
Cell[76369, 2353, 60, 1, 41, "Command",
  CellTags->"CheckBalance"],
Cell[76432, 2356, 436, 13, 48, "Usage",
  CellTags->"CheckBalance"],
Cell[76871, 2371, 104, 3, 24, "Notes",
  CellTags->"CheckBalance"],
Cell[76978, 2376, 413, 15, 62, "ItemizedText",
  CellTags->"CheckBalance"],
Cell[77394, 2393, 411, 11, 56, "Notes",
  CellTags->"CheckBalance"],
Cell[77808, 2406, 814, 22, 88, "Notes",
  CellTags->"CheckBalance"],
Cell[78625, 2430, 228, 7, 24, "Notes",
  CellTags->"CheckBalance"],
Cell[78856, 2439, 749, 23, 24, "Notes",
  CellTags->"CheckBalance"]
}, Closed]],

Cell[CellGroupData[{
Cell[79642, 2467, 91, 1, 45, "Command",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
Cell[79736, 2470, 256, 7, 32, "Usage",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
Cell[79995, 2479, 371, 7, 56, "Notes",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}]
}, Closed]],
Cell[80381, 2489, 315, 6, 52, "Notes",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
Cell[80699, 2497, 303, 6, 40, "Notes",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
Cell[81005, 2505, 578, 11, 94, "Notes",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],
Cell[81586, 2518, 637, 20, 24, "Notes",
  CellTags->{"CheckSpelling", "spellCheckerDialogID"}],

Cell[CellGroupData[{
Cell[82248, 2542, 62, 1, 41, "Command",
  CellTags->"OptionsDialog"],
Cell[82313, 2545, 215, 6, 32, "Usage",
  CellTags->"OptionsDialog"]
}, Closed]],
Cell[82543, 2554, 217, 7, 20, "Notes",
  CellTags->"OptionsDialog"],
Cell[82763, 2563, 210, 7, 24, "Notes",
  CellTags->"OptionsDialog"],
Cell[82976, 2572, 648, 18, 24, "Notes",
  CellTags->"OptionsDialog"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

