(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     22855,        852]*)
(*NotebookOutlinePosition[     30620,       1077]*)
(*  CellTagsIndexPosition[     30519,       1070]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Basic Editing Techniques", "Title"],

Cell[CellGroupData[{

Cell["Moving through Expressions", "Section",
  CellTags->"moving"],

Cell[CellGroupData[{

Cell["Moving the cursor by typing", "SubsectionIcon",
  CellTags->"moving"],

Cell["\<\
You can use the keyboard to move the cursor forward or backward one \
character or one word at a time. You can also delete the character or word to \
the right or the left of the cursor, and you can move the cursor to the \
beginning or end of a line. 
See the Motion submenu of the Edit menu for the keystrokes specific to your \
computer system. \
\>", "Text",
  CellTags->"moving"]
}, Closed]],

Cell[CellGroupData[{

Cell["Getting out of an expression", "SubsectionIcon",
  CellTags->"moving"],

Cell["\<\
Move to the end of the next-higher subexpression by pressing \
\[ControlKey] and \[SpaceKey] at the same time. \
\>", "Text",
  CellTags->"moving"],

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " repeatedly"
}], "Subsubsection",
  CellTags->"moving"],

Cell[BoxData[
    FractionBox["1", 
      RowBox[{"1", "+", 
        FractionBox["1", 
          RowBox[{"2", "+", 
            FractionBox["1", 
              RowBox[{"3", 
                StyleBox["\[VerticalSeparator]",
                  FontWeight->"Plain"]}]]}]]}]]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    \(1\/\(1 + 1\/\(\(2 + 1\/3\)\(\[VerticalSeparator]\)\)\)\)], "Input",
  CellTags->"moving"],

Cell[BoxData[
    FractionBox["1", 
      RowBox[{\(1 + 1\/\(2 + 1\/3\)\), 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}]]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{\(1\/\(1 + 1\/\(2 + 1\/3\)\)\), 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"moving"]
}, Closed]],

Cell[CellGroupData[{

Cell["Selecting the next placeholder", "SubsectionIcon",
  CellTags->"moving"],

Cell["\<\
Select the next placeholder by pressing the \[TabKey] key. \
\>", \
"Text",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"], 
      RowBox[{
        RowBox[{"(", GridBox[{
              {"a", "\[Placeholder]", "\[Placeholder]"},
              {"\[Placeholder]", "b", "\[Placeholder]"},
              {"\[Placeholder]", "\[Placeholder]", "c"}
              }], ")"}], 
        StyleBox["\[Rule]",
          ShowContents->False]}]}]], "Input",
  CellTags->"moving"],

Cell[TextData[{
  "Press ",
  StyleBox["\[TabKey]",
    FontSize->16],
  " repeatedly"
}], "Subsubsection",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]"},
          {"\[Placeholder]", "b", "\[Placeholder]"},
          {"\[Placeholder]", "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]},
          {"\[Placeholder]", "b", "\[Placeholder]"},
          {"\[Placeholder]", "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", "\[Placeholder]"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "b", "\[Placeholder]"},
          {"\[Placeholder]", "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", "\[Placeholder]"},
          {"\[Placeholder]", "b", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]},
          {"\[Placeholder]", "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", "\[Placeholder]"},
          {"\[Placeholder]", "b", "\[Placeholder]"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", "\[Placeholder]"},
          {"\[Placeholder]", "b", "\[Placeholder]"},
          {"\[Placeholder]", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell["\<\
Select the previous placeholder by pressing \[ShiftKey] and \
\[TabKey] at the same time. \
\>", "Text",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(", GridBox[{
            {"a", "\[Placeholder]", "\[Placeholder]"},
            {"\[Placeholder]", "b", "\[Placeholder]"},
            {"\[Placeholder]", "\[Placeholder]", "c"}
            }], ")"}], "\[VerticalSeparator]"}]], "Input",
  CellTags->"moving"],

Cell[TextData[{
  "Press ",
  StyleBox["\[ShiftKey]\[KeyBar]\[TabKey]",
    FontSize->16],
  " repeatedly"
}], "Subsubsection",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", "\[Placeholder]"},
          {"\[Placeholder]", "b", "\[Placeholder]"},
          {"\[Placeholder]", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", "\[Placeholder]"},
          {"\[Placeholder]", "b", "\[Placeholder]"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", "\[Placeholder]"},
          {"\[Placeholder]", "b", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]},
          {"\[Placeholder]", "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", "\[Placeholder]"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "b", "\[Placeholder]"},
          {"\[Placeholder]", "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "\[Placeholder]", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]},
          {"\[Placeholder]", "b", "\[Placeholder]"},
          {"\[Placeholder]", "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]"},
          {"\[Placeholder]", "b", "\[Placeholder]"},
          {"\[Placeholder]", "\[Placeholder]", "c"}
          }], ")"}]], "Input",
  CellTags->"moving"]
}, Closed]],

Cell[CellGroupData[{

Cell["Switching positions", "SubsectionIcon",
  CellTags->"moving"],

Cell["\<\
Move back and forth between complementary positions by pressing \
\[ControlKey]\[LeftModified]5\[RightModified] or \
\[ControlKey]\[LeftModified]%\[RightModified]. \
\>", "Text",
  CellTags->"moving"],

Cell["First we alternate between a radicand and an index. ", "Text",
  CellTags->"moving"],

Cell[BoxData[
    RadicalBox[
      RowBox[{"x", 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}], "n"]], "Input",
  CellTags->"moving"],

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontSize->16],
  "%",
  StyleBox["\[RightModified]",
    FontSize->16],
  "\[AutoOperand]"
}], "Subsubsection",
  CellTags->"moving"],

Cell[BoxData[
    RadicalBox["x", 
      RowBox[{"n", 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}]]], "Input",
  CellTags->"moving"],

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontSize->16],
  "%",
  StyleBox["\[RightModified]",
    FontSize->16],
  "\[AutoOperand]"
}], "Subsubsection",
  CellTags->"moving"],

Cell[BoxData[
    RadicalBox[
      RowBox[{"x", 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}], "n"]], "Input",
  CellTags->"moving"],

Cell["Next we alternate between a superscript and a subscript. ", "Text",
  CellTags->"moving"],

Cell[BoxData[
    SubsuperscriptBox["x", "j", 
      RowBox[{"i", 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}]]], "Input",
  CellTags->"moving"],

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontSize->16],
  "%",
  StyleBox["\[RightModified]",
    FontSize->16],
  "\[AutoOperand]"
}], "Subsubsection",
  CellTags->"moving"],

Cell[BoxData[
    SubsuperscriptBox["x", 
      RowBox[{"j", 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}], "i"]], "Input",
  CellTags->"moving"],

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontSize->16],
  "%",
  StyleBox["\[RightModified]",
    FontSize->16],
  "\[AutoOperand]"
}], "Subsubsection",
  CellTags->"moving"],

Cell[BoxData[
    SubsuperscriptBox["x", "j", 
      RowBox[{"i", 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}]]], "Input",
  CellTags->"moving"],

Cell["\<\
Finally, we alternate between an overscript and an underscript. \
\
\>", "Text",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{
      UnderoverscriptBox["\[Sum]", \(n = 1\), 
        RowBox[{"\[Infinity]", 
          StyleBox["\[VerticalSeparator]",
            FontWeight->"Plain"]}]], \(1\/n\^2\)}]], "Input",
  CellTags->"moving"],

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontSize->16],
  "%",
  StyleBox["\[RightModified]",
    FontSize->16],
  "\[AutoOperand]"
}], "Subsubsection",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{
      UnderoverscriptBox["\[Sum]", 
        RowBox[{"n", "=", 
          RowBox[{"1", 
            StyleBox["\[VerticalSeparator]",
              FontWeight->"Plain"]}]}], 
        "\[Infinity]"], \(1\/n\^2\)}]], "Input",
  CellTags->"moving"],

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "%",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[AutoOperand]"
}], "Subsubsection",
  CellTags->"moving"],

Cell[BoxData[
    RowBox[{
      UnderoverscriptBox["\[Sum]", \(n = 1\), 
        RowBox[{"\[Infinity]", 
          StyleBox["\[VerticalSeparator]",
            FontWeight->"Plain"]}]], \(1\/n\^2\)}]], "Input",
  CellTags->"moving"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Selecting and Deleting in Expressions", "Section",
  CellTags->"selecting"],

Cell[CellGroupData[{

Cell["Selecting the next-higher subexpression", "SubsectionIcon",
  CellTags->"selecting"],

Cell[TextData[{
  "Select the next-higher subexpression by pressing \[ControlKey]\
\[LeftModified]",
  StyleBox[".",
    FontFamily->"Courier"],
  "\[RightModified]. "
}], "Text",
  CellTags->"selecting"],

Cell[TextData[{
  "Press",
  StyleBox[" \[ControlKey]\[LeftModified]",
    FontSize->16],
  ".",
  StyleBox["\[RightModified]",
    FontSize->16],
  " repeatedly"
}], "Subsubsection",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(\[Integral]\_0\%\[Phi]\), 
      RowBox[{
        FractionBox["1", 
          SqrtBox[
            RowBox[{"1", "-", 
              RowBox[{"m", " ", 
                SuperscriptBox[
                  RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]", 
                      StyleBox["\[VerticalSeparator]",
                        FontWeight->"Plain"]}], "]"}], 
                  "2"]}]}]]], \(\[DifferentialD]\[Theta]\)}]}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(\[Integral]\_0\%\[Phi]\), 
      FractionBox["1", 
        SqrtBox[
          RowBox[{"1", "-", 
            RowBox[{"m", 
              SuperscriptBox[
                RowBox[{"Sin", "[", 
                  StyleBox["\[Theta]",
                    DrawHighlighted->1], "]"}], "2"]}]}]]], 
      "\[DifferentialD]", "\[Theta]"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(\[Integral]\_0\%\[Phi]\), 
      FractionBox["1", 
        SqrtBox[
          RowBox[{"1", "-", 
            RowBox[{"m", 
              SuperscriptBox[
                StyleBox[\(Sin[\[Theta]]\),
                  DrawHighlighted->1], "2"]}]}]]], "\[DifferentialD]", 
      "\[Theta]"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(\[Integral]\_0\%\[Phi]\), 
      RowBox[{
        FractionBox["1", 
          SqrtBox[
            RowBox[{"1", "-", 
              RowBox[{"m", 
                StyleBox[\(Sin[\[Theta]]\^2\),
                  
                  DrawHighlighted->
                    1]}]}]]], \(\[DifferentialD]\[Theta]\)}]}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(\[Integral]\_0\%\[Phi]\), 
      FractionBox["1", 
        SqrtBox[
          RowBox[{"1", "-", 
            StyleBox[\(m\ Sin[\[Theta]]\^2\),
              DrawHighlighted->1]}]]], "\[DifferentialD]", 
      "\[Theta]"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(\[Integral]\_0\%\[Phi]\), 
      FractionBox["1", 
        SqrtBox[
          StyleBox[\(1 - m\ Sin[\[Theta]]\^2\),
            DrawHighlighted->1]]], "\[DifferentialD]", "\[Theta]"}]], "Input",\

  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(\[Integral]\_0\%\[Phi]\), 
      FractionBox["1", 
        StyleBox[\(\@\(1 - m\ Sin[\[Theta]]\^2\)\),
          DrawHighlighted->1]], "\[DifferentialD]", "\[Theta]"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(\[Integral]\_0\%\[Phi]\), 
      StyleBox[\(1\/\@\(1 - m\ Sin[\[Theta]]\^2\)\),
        DrawHighlighted->1], "\[DifferentialD]", "\[Theta]"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(\[Integral]\_0\%\[Phi]\), 
      StyleBox[\(\(1\/\@\(1 - m\ Sin[\[Theta]]\^2\)\) \
\[DifferentialD]\[Theta]\),
        DrawHighlighted->1]}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    StyleBox[\(\[Integral]\_0\%\[Phi]\( 
              1\/\@\(1 - m\ Sin[\[Theta]]\^2\)\) \[DifferentialD]\[Theta]\),
      DrawHighlighted->1]], "Input",
  CellTags->"selecting"]
}, Closed]],

Cell[CellGroupData[{

Cell["Deleting to destructure an expression", "SubsectionIcon",
  CellTags->"selecting"],

Cell["\<\
Get rid of the contents of an expression and destructure it by \
pressing \[DeleteKey] (or Backspace).\
\>", "Text",
  CellTags->"selecting"],

Cell["Backspace repeatedly", "Subsubsection",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{\(1\/\@\(1 + x\^2\)\), 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    FractionBox["1", 
      RowBox[{\(\@\(1 + x\^2\)\), 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}]]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    FractionBox["1", 
      SqrtBox[
        RowBox[{\(1 + x\^2\), 
          StyleBox["\[VerticalSeparator]",
            FontWeight->"Plain"]}]]]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    FractionBox["1", 
      SqrtBox[
        RowBox[{"1", "+", 
          SuperscriptBox["x", 
            RowBox[{"2", 
              StyleBox["\[VerticalSeparator]",
                FontWeight->"Plain"]}]]}]]]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    FractionBox["1", 
      SqrtBox[
        RowBox[{"1", "+", 
          SuperscriptBox["x", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]]}]]]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    FractionBox["1", 
      SqrtBox[
        RowBox[{\(1 + x\), 
          StyleBox["\[VerticalSeparator]",
            FontWeight->"Plain"]}]]]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    FractionBox["1", 
      SqrtBox[
        RowBox[{\(\(1\)\(+\)\), 
          StyleBox["\[VerticalSeparator]",
            FontWeight->"Plain"]}]]]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    FractionBox["1", 
      SqrtBox[
        RowBox[{"1", 
          StyleBox["\[VerticalSeparator]",
            FontWeight->"Plain"]}]]]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    FractionBox["1", 
      SqrtBox[
        StyleBox["\[Placeholder]",
          DrawHighlighted->1]]]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    FractionBox["1", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"1", 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    StyleBox["\[VerticalSeparator]",
      FontWeight->"Plain"]], "Input",
  CellTags->"selecting"],

Cell["Another example:", "Text",
  CellTags->"selecting"],

Cell["Backspace repeatedly", "Subsubsection",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", "c"},
          {"d", "e", 
            RowBox[{"f", 
              StyleBox["\[VerticalSeparator]",
                FontWeight->"Plain"]}]},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", "c"},
          {"d", "e", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", "c"},
          {"d", 
            RowBox[{"e", 
              StyleBox["\[VerticalSeparator]",
                FontWeight->"Plain"]}], "\[Placeholder]"},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", "c"},
          {"d", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]"},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", "c"},
          {
            RowBox[{"d", 
              StyleBox["\[VerticalSeparator]",
                FontWeight->"Plain"]}], "\[Placeholder]", "\[Placeholder]"},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", "c"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]", "\[Placeholder]"},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", 
            RowBox[{"c", 
              StyleBox["\[VerticalSeparator]",
                FontWeight->"Plain"]}]},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", 
            RowBox[{"b", 
              StyleBox["\[VerticalSeparator]",
                FontWeight->"Plain"]}], "\[Placeholder]"},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]"},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {
            RowBox[{"a", 
              StyleBox["\[VerticalSeparator]",
                FontWeight->"Plain"]}], "\[Placeholder]", "\[Placeholder]"},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]", "\[Placeholder]"},
          {"g", "h", "i"}
          }], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{"(", 
      RowBox[{
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"], GridBox[{
            {"g", "h", "i"}
            }]}], ")"}]], "Input",
  CellTags->"selecting"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"], GridBox[{
            {"g", "h", "i"}
            }]}], ")"}]], "Input",
  CellTags->"selecting"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Macintosh",
ScreenRectangle->{{0, 800}, {0, 580}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{612, 540},
WindowMargins->{{15, Automatic}, {Automatic, 4}},
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "moving"->{
    Cell[1805, 55, 67, 1, 58, "Section",
      CellTags->"moving"],
    Cell[1897, 60, 75, 1, 42, "SubsectionIcon",
      CellTags->"moving"],
    Cell[1975, 63, 394, 8, 72, "Text",
      CellTags->"moving"],
    Cell[2406, 76, 76, 1, 42, "SubsectionIcon",
      CellTags->"moving"],
    Cell[2485, 79, 157, 4, 22, "Text",
      CellTags->"moving"],
    Cell[2645, 85, 316, 11, 36, "Subsubsection",
      CellTags->"moving"],
    Cell[2964, 98, 303, 9, 60, "Input",
      CellTags->"moving"],
    Cell[3270, 109, 109, 2, 58, "Input",
      CellTags->"moving"],
    Cell[3382, 113, 183, 5, 65, "Input",
      CellTags->"moving"],
    Cell[3568, 120, 161, 4, 71, "Input",
      CellTags->"moving"],
    Cell[3766, 129, 78, 1, 42, "SubsectionIcon",
      CellTags->"moving"],
    Cell[3847, 132, 107, 4, 22, "Text",
      CellTags->"moving"],
    Cell[3957, 138, 434, 12, 56, "Input",
      CellTags->"moving"],
    Cell[4394, 152, 129, 6, 36, "Subsubsection",
      CellTags->"moving"],
    Cell[4526, 160, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[4837, 170, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[5148, 180, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[5459, 190, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[5770, 200, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[6081, 210, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[6392, 220, 136, 4, 22, "Text",
      CellTags->"moving"],
    Cell[6531, 226, 300, 7, 56, "Input",
      CellTags->"moving"],
    Cell[6834, 235, 149, 6, 36, "Subsubsection",
      CellTags->"moving"],
    Cell[6986, 243, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[7297, 253, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[7608, 263, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[7919, 273, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[8230, 283, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[8541, 293, 308, 8, 56, "Input",
      CellTags->"moving"],
    Cell[8886, 306, 67, 1, 42, "SubsectionIcon",
      CellTags->"moving"],
    Cell[8956, 309, 210, 5, 22, "Text",
      CellTags->"moving"],
    Cell[9169, 316, 90, 1, 22, "Text",
      CellTags->"moving"],
    Cell[9262, 319, 162, 5, 30, "Input",
      CellTags->"moving"],
    Cell[9427, 326, 208, 9, 36, "Subsubsection",
      CellTags->"moving"],
    Cell[9638, 337, 162, 5, 34, "Input",
      CellTags->"moving"],
    Cell[9803, 344, 208, 9, 36, "Subsubsection",
      CellTags->"moving"],
    Cell[10014, 355, 162, 5, 30, "Input",
      CellTags->"moving"],
    Cell[10179, 362, 95, 1, 22, "Text",
      CellTags->"moving"],
    Cell[10277, 365, 174, 5, 31, "Input",
      CellTags->"moving"],
    Cell[10454, 372, 208, 9, 36, "Subsubsection",
      CellTags->"moving"],
    Cell[10665, 383, 174, 5, 30, "Input",
      CellTags->"moving"],
    Cell[10842, 390, 208, 9, 36, "Subsubsection",
      CellTags->"moving"],
    Cell[11053, 401, 174, 5, 31, "Input",
      CellTags->"moving"],
    Cell[11230, 408, 112, 4, 22, "Text",
      CellTags->"moving"],
    Cell[11345, 414, 232, 6, 51, "Input",
      CellTags->"moving"],
    Cell[11580, 422, 208, 9, 36, "Subsubsection",
      CellTags->"moving"],
    Cell[11791, 433, 270, 8, 50, "Input",
      CellTags->"moving"],
    Cell[12064, 443, 534, 19, 36, "Subsubsection",
      CellTags->"moving"],
    Cell[12601, 464, 232, 6, 51, "Input",
      CellTags->"moving"]},
  "selecting"->{
    Cell[12882, 476, 81, 1, 44, "Section",
      CellTags->"selecting"],
    Cell[12988, 481, 90, 1, 42, "SubsectionIcon",
      CellTags->"selecting"],
    Cell[13081, 484, 204, 7, 22, "Text",
      CellTags->"selecting"],
    Cell[13288, 493, 208, 9, 36, "Subsubsection",
      CellTags->"selecting"],
    Cell[13499, 504, 500, 13, 47, "Input",
      CellTags->"selecting"],
    Cell[14002, 519, 392, 11, 47, "Input",
      CellTags->"selecting"],
    Cell[14397, 532, 351, 10, 47, "Input",
      CellTags->"selecting"],
    Cell[14751, 544, 374, 11, 47, "Input",
      CellTags->"selecting"],
    Cell[15128, 557, 285, 8, 47, "Input",
      CellTags->"selecting"],
    Cell[15416, 567, 249, 7, 47, "Input",
      CellTags->"selecting"],
    Cell[15668, 576, 231, 5, 47, "Input",
      CellTags->"selecting"],
    Cell[15902, 583, 205, 4, 47, "Input",
      CellTags->"selecting"],
    Cell[16110, 589, 204, 5, 47, "Input",
      CellTags->"selecting"],
    Cell[16317, 596, 193, 4, 47, "Input",
      CellTags->"selecting"],
    Cell[16547, 605, 88, 1, 42, "SubsectionIcon",
      CellTags->"selecting"],
    Cell[16638, 608, 151, 4, 22, "Text",
      CellTags->"selecting"],
    Cell[16792, 614, 70, 1, 34, "Subsubsection",
      CellTags->"selecting"],
    Cell[16865, 617, 155, 4, 48, "Input",
      CellTags->"selecting"],
    Cell[17023, 623, 181, 5, 52, "Input",
      CellTags->"selecting"],
    Cell[17207, 630, 197, 6, 47, "Input",
      CellTags->"selecting"],
    Cell[17407, 638, 261, 8, 46, "Input",
      CellTags->"selecting"],
    Cell[17671, 648, 222, 7, 46, "Input",
      CellTags->"selecting"],
    Cell[17896, 657, 194, 6, 47, "Input",
      CellTags->"selecting"],
    Cell[18093, 665, 199, 6, 47, "Input",
      CellTags->"selecting"],
    Cell[18295, 673, 188, 6, 47, "Input",
      CellTags->"selecting"],
    Cell[18486, 681, 153, 5, 46, "Input",
      CellTags->"selecting"],
    Cell[18642, 688, 133, 4, 41, "Input",
      CellTags->"selecting"],
    Cell[18778, 694, 137, 4, 26, "Input",
      CellTags->"selecting"],
    Cell[18918, 700, 113, 3, 25, "Input",
      CellTags->"selecting"],
    Cell[19034, 705, 57, 1, 22, "Text",
      CellTags->"selecting"],
    Cell[19094, 708, 70, 1, 34, "Subsubsection",
      CellTags->"selecting"],
    Cell[19167, 711, 285, 9, 56, "Input",
      CellTags->"selecting"],
    Cell[19455, 722, 246, 8, 56, "Input",
      CellTags->"selecting"],
    Cell[19704, 732, 298, 9, 56, "Input",
      CellTags->"selecting"],
    Cell[20005, 743, 259, 8, 56, "Input",
      CellTags->"selecting"],
    Cell[20267, 753, 311, 9, 56, "Input",
      CellTags->"selecting"],
    Cell[20581, 764, 272, 8, 56, "Input",
      CellTags->"selecting"],
    Cell[20856, 774, 258, 8, 40, "Input",
      CellTags->"selecting"],
    Cell[21117, 784, 219, 7, 40, "Input",
      CellTags->"selecting"],
    Cell[21339, 793, 271, 8, 40, "Input",
      CellTags->"selecting"],
    Cell[21613, 803, 232, 7, 40, "Input",
      CellTags->"selecting"],
    Cell[21848, 812, 284, 8, 40, "Input",
      CellTags->"selecting"],
    Cell[22135, 822, 245, 7, 40, "Input",
      CellTags->"selecting"],
    Cell[22383, 831, 217, 7, 26, "Input",
      CellTags->"selecting"],
    Cell[22603, 840, 212, 7, 26, "Input",
      CellTags->"selecting"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"moving", 23760, 876},
  {"selecting", 27214, 975}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 41, 0, 108, "Title"],

Cell[CellGroupData[{
Cell[1805, 55, 67, 1, 58, "Section",
  CellTags->"moving"],

Cell[CellGroupData[{
Cell[1897, 60, 75, 1, 42, "SubsectionIcon",
  CellTags->"moving"],
Cell[1975, 63, 394, 8, 72, "Text",
  CellTags->"moving"]
}, Closed]],

Cell[CellGroupData[{
Cell[2406, 76, 76, 1, 42, "SubsectionIcon",
  CellTags->"moving"],
Cell[2485, 79, 157, 4, 22, "Text",
  CellTags->"moving"],
Cell[2645, 85, 316, 11, 36, "Subsubsection",
  CellTags->"moving"],
Cell[2964, 98, 303, 9, 60, "Input",
  CellTags->"moving"],
Cell[3270, 109, 109, 2, 58, "Input",
  CellTags->"moving"],
Cell[3382, 113, 183, 5, 65, "Input",
  CellTags->"moving"],
Cell[3568, 120, 161, 4, 71, "Input",
  CellTags->"moving"]
}, Closed]],

Cell[CellGroupData[{
Cell[3766, 129, 78, 1, 42, "SubsectionIcon",
  CellTags->"moving"],
Cell[3847, 132, 107, 4, 22, "Text",
  CellTags->"moving"],
Cell[3957, 138, 434, 12, 56, "Input",
  CellTags->"moving"],
Cell[4394, 152, 129, 6, 36, "Subsubsection",
  CellTags->"moving"],
Cell[4526, 160, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[4837, 170, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[5148, 180, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[5459, 190, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[5770, 200, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[6081, 210, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[6392, 220, 136, 4, 22, "Text",
  CellTags->"moving"],
Cell[6531, 226, 300, 7, 56, "Input",
  CellTags->"moving"],
Cell[6834, 235, 149, 6, 36, "Subsubsection",
  CellTags->"moving"],
Cell[6986, 243, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[7297, 253, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[7608, 263, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[7919, 273, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[8230, 283, 308, 8, 56, "Input",
  CellTags->"moving"],
Cell[8541, 293, 308, 8, 56, "Input",
  CellTags->"moving"]
}, Closed]],

Cell[CellGroupData[{
Cell[8886, 306, 67, 1, 42, "SubsectionIcon",
  CellTags->"moving"],
Cell[8956, 309, 210, 5, 22, "Text",
  CellTags->"moving"],
Cell[9169, 316, 90, 1, 22, "Text",
  CellTags->"moving"],
Cell[9262, 319, 162, 5, 30, "Input",
  CellTags->"moving"],
Cell[9427, 326, 208, 9, 36, "Subsubsection",
  CellTags->"moving"],
Cell[9638, 337, 162, 5, 34, "Input",
  CellTags->"moving"],
Cell[9803, 344, 208, 9, 36, "Subsubsection",
  CellTags->"moving"],
Cell[10014, 355, 162, 5, 30, "Input",
  CellTags->"moving"],
Cell[10179, 362, 95, 1, 22, "Text",
  CellTags->"moving"],
Cell[10277, 365, 174, 5, 31, "Input",
  CellTags->"moving"],
Cell[10454, 372, 208, 9, 36, "Subsubsection",
  CellTags->"moving"],
Cell[10665, 383, 174, 5, 30, "Input",
  CellTags->"moving"],
Cell[10842, 390, 208, 9, 36, "Subsubsection",
  CellTags->"moving"],
Cell[11053, 401, 174, 5, 31, "Input",
  CellTags->"moving"],
Cell[11230, 408, 112, 4, 22, "Text",
  CellTags->"moving"],
Cell[11345, 414, 232, 6, 51, "Input",
  CellTags->"moving"],
Cell[11580, 422, 208, 9, 36, "Subsubsection",
  CellTags->"moving"],
Cell[11791, 433, 270, 8, 50, "Input",
  CellTags->"moving"],
Cell[12064, 443, 534, 19, 36, "Subsubsection",
  CellTags->"moving"],
Cell[12601, 464, 232, 6, 51, "Input",
  CellTags->"moving"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12882, 476, 81, 1, 44, "Section",
  CellTags->"selecting"],

Cell[CellGroupData[{
Cell[12988, 481, 90, 1, 42, "SubsectionIcon",
  CellTags->"selecting"],
Cell[13081, 484, 204, 7, 22, "Text",
  CellTags->"selecting"],
Cell[13288, 493, 208, 9, 36, "Subsubsection",
  CellTags->"selecting"],
Cell[13499, 504, 500, 13, 47, "Input",
  CellTags->"selecting"],
Cell[14002, 519, 392, 11, 47, "Input",
  CellTags->"selecting"],
Cell[14397, 532, 351, 10, 47, "Input",
  CellTags->"selecting"],
Cell[14751, 544, 374, 11, 47, "Input",
  CellTags->"selecting"],
Cell[15128, 557, 285, 8, 47, "Input",
  CellTags->"selecting"],
Cell[15416, 567, 249, 7, 47, "Input",
  CellTags->"selecting"],
Cell[15668, 576, 231, 5, 47, "Input",
  CellTags->"selecting"],
Cell[15902, 583, 205, 4, 47, "Input",
  CellTags->"selecting"],
Cell[16110, 589, 204, 5, 47, "Input",
  CellTags->"selecting"],
Cell[16317, 596, 193, 4, 47, "Input",
  CellTags->"selecting"]
}, Closed]],

Cell[CellGroupData[{
Cell[16547, 605, 88, 1, 42, "SubsectionIcon",
  CellTags->"selecting"],
Cell[16638, 608, 151, 4, 22, "Text",
  CellTags->"selecting"],
Cell[16792, 614, 70, 1, 34, "Subsubsection",
  CellTags->"selecting"],
Cell[16865, 617, 155, 4, 48, "Input",
  CellTags->"selecting"],
Cell[17023, 623, 181, 5, 52, "Input",
  CellTags->"selecting"],
Cell[17207, 630, 197, 6, 47, "Input",
  CellTags->"selecting"],
Cell[17407, 638, 261, 8, 46, "Input",
  CellTags->"selecting"],
Cell[17671, 648, 222, 7, 46, "Input",
  CellTags->"selecting"],
Cell[17896, 657, 194, 6, 47, "Input",
  CellTags->"selecting"],
Cell[18093, 665, 199, 6, 47, "Input",
  CellTags->"selecting"],
Cell[18295, 673, 188, 6, 47, "Input",
  CellTags->"selecting"],
Cell[18486, 681, 153, 5, 46, "Input",
  CellTags->"selecting"],
Cell[18642, 688, 133, 4, 41, "Input",
  CellTags->"selecting"],
Cell[18778, 694, 137, 4, 26, "Input",
  CellTags->"selecting"],
Cell[18918, 700, 113, 3, 25, "Input",
  CellTags->"selecting"],
Cell[19034, 705, 57, 1, 22, "Text",
  CellTags->"selecting"],
Cell[19094, 708, 70, 1, 34, "Subsubsection",
  CellTags->"selecting"],
Cell[19167, 711, 285, 9, 56, "Input",
  CellTags->"selecting"],
Cell[19455, 722, 246, 8, 56, "Input",
  CellTags->"selecting"],
Cell[19704, 732, 298, 9, 56, "Input",
  CellTags->"selecting"],
Cell[20005, 743, 259, 8, 56, "Input",
  CellTags->"selecting"],
Cell[20267, 753, 311, 9, 56, "Input",
  CellTags->"selecting"],
Cell[20581, 764, 272, 8, 56, "Input",
  CellTags->"selecting"],
Cell[20856, 774, 258, 8, 40, "Input",
  CellTags->"selecting"],
Cell[21117, 784, 219, 7, 40, "Input",
  CellTags->"selecting"],
Cell[21339, 793, 271, 8, 40, "Input",
  CellTags->"selecting"],
Cell[21613, 803, 232, 7, 40, "Input",
  CellTags->"selecting"],
Cell[21848, 812, 284, 8, 40, "Input",
  CellTags->"selecting"],
Cell[22135, 822, 245, 7, 40, "Input",
  CellTags->"selecting"],
Cell[22383, 831, 217, 7, 26, "Input",
  CellTags->"selecting"],
Cell[22603, 840, 212, 7, 26, "Input",
  CellTags->"selecting"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

