(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40441,       1479]*)
(*NotebookOutlinePosition[     58014,       1944]*)
(*  CellTagsIndexPosition[     56715,       1905]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["New", "Command",
  CellTags->"New"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["New", "SR"],
  " creates a new notebook."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"New"],

Cell["\<\
\[FilledSmallSquare] The notebook is initially empty. \
\>", "Notes",
  AspectRatioFixed->False,
  CellTags->"New"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["n", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["n", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["n", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"New"]
}, Closed]],

Cell[CellGroupData[{

Cell["Open...", "Command",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open", "SR"],
  " brings up a dialog box to open an existing file."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell["\[FilledSmallSquare] To open a file:", "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "1.  Choose ",
  StyleBox["Open", "SR"],
  " from the File menu. \n2.  In the file dialog box that appears, select the \
file you want to open. \n3.  Click ",
  StyleBox["Open",
    FontFamily->"Helvetica"],
  " or double-click the name of the file."
}], "ItemizedText",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] By default, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " shows only the files that it knows exactly how to open."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Open Special...",
    ButtonData:>"Open Special...",
    ButtonStyle->"OtherInformationLink"],
  " for how to open other file types."
}], "Notes",
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["o", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["o", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["o", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " understands the following file types:"
}], "Subsubsection",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[StyleBox["\[FilledSmallSquare] Notebook",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "You can open notebooks created using any version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". When opening a notebook created using Version 2 or earlier, a dialog box \
appears allowing you to convert the notebook to Version 4 format."
}], "NotesList",
  AspectRatioFixed->False,
  CellTags->{"Open", "convertingFrom22NotebookDialogID"}],

Cell[TextData[{
  "    ",
  StyleBox["Important",
    FontWeight->"Bold"],
  ": Check that you have write permission in the directory where you are \
converting the notebooks. Otherwise ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will not be able to convert the files."
}], "Notes",
  CellTags->{"convertingFrom22NotebookDialogID", "Open"}],

Cell[TextData[StyleBox["\[FilledSmallSquare] Text",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell["\<\
Files in plain text from any word processor are opened with all the \
text in a single cell. When all the text appears on one line, you may want to \
switch the cell's style to \"Text\" style, which is normally a word-wrapping \
style.\
\>", "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "See: ",
  ButtonBox["Open Special...",
    ButtonData:>"Open Special...",
    ButtonStyle->"OtherInformationLink"],
  " for how to open a text file putting lines or paragraphs in separate \
cells. "
}], "NotesList"],

Cell[TextData[StyleBox["\[FilledSmallSquare] EPSF",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "Encapsulated PostScript files open as notebooks containing a single \
graphics cell. For a file originally produced by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the resulting cell is identical to the one that produced the file. For a \
file produced by another program, the PostScript may require some manual \
editing before it can be rendered or printed."
}], "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[StyleBox["\[FilledSmallSquare] Scrapbook (Macintosh)",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell["\<\
Files from the Scrapbook open as notebooks containing all the PICT, \
TEXT, and SND (sound) objects in the scrap file. Note that you cannot save \
the resulting file in Scrapbook form.\
\>", "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[StyleBox["\[FilledSmallSquare] PICT (Macintosh)",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell["\<\
Files from most graphics programs saved in PICT format open as a \
single cell containing the picture in the file.\
\>", "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[StyleBox["\[FilledSmallSquare] QuickTime (Macintosh)",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell["QuickTime movies are opened as a QuickTime cell.", "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Close",
  FontWeight->"Bold"]], "Command",
  CellTags->"Close"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Close", "SR"],
  " closes the currently selected notebook."
}], "Usage",
  CellTags->"Close"],

Cell[TextData[{
  "\[FilledSmallSquare] When you close notebook windows, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "asks if you want to save any changes made since your previous save."
}], "Notes",
  CellTags->"Close"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["F4", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["w", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["w", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Close"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Save",
  FontWeight->"Bold"]], "Command",
  CellTags->"Save"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Save", "SR"],
  " saves the currently selected notebook. "
}], "Usage",
  CellTags->"Save"],

Cell[TextData[{
  "\[FilledSmallSquare] Use ",
  StyleBox["Save", "SR"],
  " to record changes made to a notebook already stored on disk. If the \
current notebook is still untitled (not yet saved on disk), ",
  StyleBox["Save", "SR"],
  " behaves exactly like ",
  StyleBox["Save As", "SR"],
  " and asks you to name it. "
}], "Notes",
  CellTags->"Save"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["s", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["s", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["s", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Save"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Save As...",
  FontWeight->"Bold"]], "Command",
  CellTags->"SaveRename"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Save As", "SR"],
  " saves the notebook in a file with a new name."
}], "Usage",
  CellTags->"SaveRename"],

Cell[TextData[{
  "\[FilledSmallSquare] To save a notebook in a different file format, use ",
  StyleBox["Save As Special", "SR"],
  ". "
}], "Notes",
  CellTags->"SaveRename"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["s", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]s\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]s\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SaveRename"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Save As Special...",
  FontWeight->"Bold"]], "Command",
  CellTags->"SaveRenameSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Save As Special", "SR"],
  " saves the notebook in the specified format."
}], "Usage",
  CellTags->"SaveRenameSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 4 notebook files contain ",
  StyleBox["Notebook", "MR"],
  " expressions written in textual form. ",
  StyleBox["Save As Special", "SR"],
  " converts the notebook to other forms. "
}], "Notes",
  CellTags->"SaveRenameSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["SaveAsSpecialOptions",
    ButtonData:>"SaveAsSpecialOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"SaveRenameSpecial"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Version 2 Notebook",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->{
  "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Version 2 Notebook", "SR"],
  " converts the notebook to a form that can be opened by older versions of \
the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->{
  "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Text",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialText"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Text", "SR"],
  " saves the contents of a notebook in plain text. "
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialText"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Cell Expression",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialCellExpression"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] Cell Expression", "SR"],
  " ",
  "saves",
  " one or more cell objects, but does not write out the notebook options, \
style sheet references, etc."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialCellExpression"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Notebook Expression",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialNotebookExpression"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] Notebook Expression", "SR"],
  " ",
  "saves",
  " the full notebook expression without the extra cache information usually \
contained in a notebook file."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialNotebookExpression"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Package Format",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialPackage"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] Package Format", "SR"],
  " saves the text of the file in the form of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package, commenting out all cells except initialization cells. "
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialPackage"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["InitializationCell",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"SaveRenameSpecialPackage"]
}, Closed]],

Cell[CellGroupData[{

Cell["TeX", "Command",
  AspectRatioFixed->False,
  CellTags->"TeXSave"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] TeX", "SR"],
  " saves the notebook as a TeX file."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"TeXSave"],

Cell["\<\
\[FilledSmallSquare] This command requires a local kernel.\
\>", \
"Notes",
  AspectRatioFixed->False,
  CellTags->"TeXSave"]
}, Closed]],

Cell[CellGroupData[{

Cell["HTML", "Command",
  AspectRatioFixed->False,
  CellTags->"HTMLSave"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] HTML", "SR"],
  " saves the notebook as an HTML file."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"HTMLSave"],

Cell["\<\
\[FilledSmallSquare] This command requires a local kernel.\
\>", \
"Notes",
  AspectRatioFixed->False,
  CellTags->"HTMLSave"]
}, Closed]],

Cell[CellGroupData[{

Cell["XML (XHTML+MathML)", "Command",
  AspectRatioFixed->False,
  CellTags->"XHTML+MathMLSave"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] XML (XHTML+MathML)", "SR"],
  " saves the notebook as an XHTML file, with all typeset equations in the \
notebook converted to MathML."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"XHTML+MathMLSave"],

Cell["\<\
\[FilledSmallSquare] This command requires a local kernel.\
\>", \
"Notes",
  AspectRatioFixed->False,
  CellTags->"XHTML+MathMLSave"]
}, Closed]],

Cell[CellGroupData[{

Cell["XML (NotebookML)", "Command",
  AspectRatioFixed->False,
  CellTags->"NotebookMLSave"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] XML (NotebookML)", "SR"],
  " saves the notebook as a NotebookML file."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"NotebookMLSave"],

Cell["\<\
\[FilledSmallSquare] NotebookML is an XML format, developed by \
Wolfram Research, specifically for saving notebooks as XML files.\
\>", \
"Notes",
  AspectRatioFixed->False,
  CellTags->"NotebookMLSave"],

Cell["\<\
\[FilledSmallSquare] This command requires a local kernel.\
\>", \
"Notes",
  AspectRatioFixed->False,
  CellTags->"NotebookMLSave"]
}, Closed]],

Cell[CellGroupData[{

Cell["XML (NotebookML+MathML)", "Command",
  AspectRatioFixed->False,
  CellTags->"NotebookML+MathMLSave"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] XML (NotebookML+MathML)", "SR"],
  " saves the notebook as a NotebookML file, with all typeset equations in \
the notebook converted to MathML."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"NotebookML+MathMLSave"],

Cell["\<\
\[FilledSmallSquare] NotebookML is an XML format, developed by \
Wolfram Research, specifically for saving notebooks as XML files.\
\>", \
"Notes",
  AspectRatioFixed->False,
  CellTags->"NotebookML+MathMLSave"],

Cell["\<\
\[FilledSmallSquare] This command requires a local kernel.\
\>", \
"Notes",
  AspectRatioFixed->False,
  CellTags->"NotebookML+MathMLSave"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Revert",
  FontWeight->"Bold"]], "Command",
  CellTags->"Revert"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Revert", "SR"],
  " restores the currently selected notebook to its last saved version."
}], "Usage",
  CellTags->"Revert"],

Cell["\<\
\[FilledSmallSquare] This command appears grayed out unless the \
notebook has been edited since it was last saved. 
\[FilledSmallSquare] If you choose this command, a dialog box appears saying \
that all unsaved changes will be lost and giving you the option of cancelling \
the operation. \
\>", "Notes",
  CellTags->"Revert"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Open Special...",
  FontWeight->"Bold"]], "Command",
  CellTags->"OpenSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open Special", "SR"],
  " opens files other than ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks, or notebooks modified outside ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Usage",
  CellTags->"OpenSpecial"],

Cell["\<\
\[FilledSmallSquare] The dialog box lists the following choices for \
how the file will be interpreted.\
\>", "Text",
  CellTags->"OpenSpecial"],

Cell["File reading method", "Subsubsection",
  AspectRatioFixed->False,
  CellTags->"OpenSpecial"],

Cell[TextData[StyleBox["Ignore File Outline Cache",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"OpenSpecial"],

Cell["\<\
Opens a notebook without reading the cached outline of the \
notebook. This increases the time taken to open a notebook. It is typically \
used for opening notebooks whose outline cache has become corrupted.   \
\>", \
"IndentedText",
  CellTags->"OpenSpecial"],

Cell["All In One Cell", "DialogItem",
  CellTags->"OpenSpecial"],

Cell["Puts the entire file in one cell.", "IndentedText",
  CellTags->"OpenSpecial"],

Cell["New Cell At Every Line", "DialogItem",
  CellTags->"OpenSpecial"],

Cell["Puts every line of the file into a separate cell.", "IndentedText",
  CellTags->"OpenSpecial"],

Cell["New Cell At Every Blank Line", "DialogItem",
  CellTags->"OpenSpecial"],

Cell["Breaks the file into cells at every blank line.", "IndentedText",
  CellTags->"OpenSpecial"],

Cell["New Cell At Every Two Blank Lines", "DialogItem",
  CellTags->"OpenSpecial"],

Cell["Breaks the file into cells at every two blank lines.", "IndentedText",
  CellTags->"OpenSpecial"],

Cell[TextData[StyleBox["Extract Resources",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"OpenSpecial"],

Cell["\<\
Extracts only the Macintosh resources of the file (PICT, TEXT, \
sound, and so on), ignoring the rest. This can be used to get information out \
of certain types of files that ordinarily cannot be opened. Note that you can \
open the Scrapbook, PICT, and EPSF files directly without using this \
option.\
\>", "IndentedText",
  CellTags->"OpenSpecial"],

Cell["Character encoding", "Subsubsection",
  AspectRatioFixed->False,
  CellTags->"OpenSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] Uses the specified character encoding standard to \
determine how raw characters in the file are translated. The pop-up menu \
lists the character encoding files currently available to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["$SystemCharacterEncoding", "Input",
    FontWeight->"Bold"],
  " uses the standard character encoding for your computer system."
}], "Notes",
  CellTags->"OpenSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] See",
  " ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.8.7",
    ButtonData:>{"2.8.7"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.8.8",
    ButtonData:>{"2.8.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"OpenSpecial"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Open Selection",
  FontWeight->"Bold"]], "Command",
  CellTags->"OpenSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open Selection", "SR"],
  " opens a notebook whose name is given by the current selection."
}], "Usage",
  CellTags->"OpenSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] If no path name is given, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will look for the notebook in the current directory (",
  StyleBox["i.e.",
    FontWeight->"ExtraLight"],
  ", the directory containing the current notebook). "
}], "Notes",
  CellTags->"OpenSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] On a Macintosh, absolute path names begin with the \
name of the device (",
  StyleBox["e.g.",
    FontWeight->"ExtraLight"],
  ", a hard drive), and are separated by colons (",
  StyleBox["device",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"ExtraLight"],
  ": ",
  StyleBox["folder",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"ExtraLight"],
  ": ",
  StyleBox["folder",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " : ",
  StyleBox["notebook",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " )."
}], "Notes",
  CellTags->"OpenSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] If you use a relative path name, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will find notebooks contained in directories of the current directory."
}], "Notes",
  CellTags->"OpenSelection"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Import...",
  FontWeight->"Bold"]], "Command",
  CellTags->"Import"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Import", "SR"],
  " opens a notebook and inserts its contents into a cell in the current \
notebook. "
}], "Usage",
  CellTags->"Import"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Send To...",
  FontWeight->"Bold"]], "Command",
  CellTags->"SendTo"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Send To", "SR"],
  " launches your email application, enabling you to mail a notebook to a \
specified address. ",
  StyleBox["(Windows only.)",
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Plain"]
}], "Usage",
  CellTags->"SendTo"],

Cell["\<\
\[FilledSmallSquare] The contents of the notebook are automatically \
inserted into the email window without the need to cut and paste. 
\[FilledSmallSquare] This menu command relies on the Windows mail extension, \
MAPI. If this extension is not installed on your machine, the menu command \
will appear dimmed, indicating that it cannot be used.\
\>", "Notes",
  CellTags->"SendTo"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Send Selection...",
  FontWeight->"Bold"]], "Command",
  CellTags->"SendSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Send Selection", "SR"],
  " launches your email application, enabling you to mail a notebook \
selection to a specified address. (Windows only.)"
}], "Usage",
  CellTags->"SendSelection"],

Cell["\<\
\[FilledSmallSquare] The notebook selection is automatically \
inserted into the email window without the need to cut and paste. 
\[FilledSmallSquare] This menu command relies on the Windows mail extension, \
MAPI. If this extension is not installed on your machine, the menu command \
will appear dimmed, indicating that it cannot be used.\
\>", "Notes",
  CellTags->"SendSelection"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Palettes",
  FontWeight->"Bold"]], "Command",
  CellTags->"MenuListPalettesMenu"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Palettes", "SR"],
  " lists currently available palettes."
}], "Usage",
  CellTags->"MenuListPalettesMenu"],

Cell[TextData[{
  "\[FilledSmallSquare] Palette files are kept in \
SystemFiles/FrontEnd/Palettes. Palette files added to this subdirectory will \
be listed in the menu when you restart ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"MenuListPalettesMenu"],

Cell[TextData[{
  "\[FilledSmallSquare] See",
  " ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.3.6",
    ButtonData:>{"1.3.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"MenuListPalettesMenu"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Generate Palette from Selection",
  FontWeight->"Bold"]], "Command",
  CellTags->"GeneratePalette"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Generate Palette from Selection", "SR"],
  " converts the selected notebook into a palette."
}], "Usage",
  CellTags->"GeneratePalette"],

Cell[TextData[{
  "\[FilledSmallSquare] The palette is opened in a separate window. Choose ",
  StyleBox["Save", "SR"],
  " to save the palette and give it a file name."
}], "Notes",
  CellTags->"GeneratePalette"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Generate Notebook from Palette",
  FontWeight->"Bold"]], "Command",
  CellTags->"GenerateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Generate Notebook", "SR"],
  " ",
  StyleBox["from Palette", "SR"],
  " converts the selected palette into an ordinary notebook."
}], "Usage",
  CellTags->"GenerateNotebook"]
}, Closed]],

Cell["Printing Settings", "Command"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Page Setup...",
  FontWeight->"Bold"]], "Command",
  CellTags->"SystemPrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Page Setup", "SR"],
  " controls the size and shape of the pages to be printed. The options \
available vary with the particular printer being used."
}], "Usage",
  CellTags->"SystemPrintOptionsDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Printing Options...",
  FontWeight->"Bold"]], "Command",
  CellTags->"PrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Printing Options", "SR"],
  " sets options for printing a notebook. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " saves your new settings with the notebook, so it will be printed the same \
way in the future."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[StyleBox["Print cell brackets",
  FontWeight->"Bold"]], "DialogItem",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell["When checked, the cell grouping brackets are printed.", "IndentedText",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[StyleBox["Print registration marks",
  FontWeight->"Bold"]], "DialogItem",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[{
  "When checked, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prints trim marks to indicate the corners of each printed page. The trim \
marks are useful for visualizing how a notebook would look when printed on \
paper of a particular size. \n",
  StyleBox["Note:",
    FontWeight->"Bold"],
  " You can simulate a smaller page size by changing the value of the option \
",
  StyleBox["\"PageSize\"",
    FontFamily->"Courier"],
  "."
}], "IndentedText",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[StyleBox["Print multiple pages for wide cells",
  FontWeight->"Bold"]], "DialogItem",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[{
  "When checked, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prints as many pages as needed to show wide cells (for example, very wide \
graphics cells). "
}], "IndentedText",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[StyleBox["Margins",
  FontWeight->"Bold"]], "DialogItem",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell["\<\
Determines how much white space will be left on the page after \
printing. Text that is set to word wrap will wrap to the printing margin \
width, not the window width. \
\>", "IndentedText",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Headers and Footers...",
  FontWeight->"Bold"]], "Command",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Headers and Footers", "SR"],
  " sets options for printing a notebook. "
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"HeadersFootersDialog"],

Cell["\<\
\[FilledSmallSquare] When you open this dialog box and click OK, \
printouts of the current notebook will have headers and footers added \
according to the specified settings.\
\>", "Notes",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " saves your new settings with the notebook, so it will be printed the same \
way in the future."
}], "Notes",
  CellTags->"HeadersFootersDialog"],

Cell["Starting page number ", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["Sets the number for the first page of the notebook. ", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["No header on first page", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["When checked, the first page is printed without a header.", \
"IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["No footer on first page", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["When checked, the first page is printed without a footer.", \
"IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Left and right pages", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
When unchecked, all pages use the right page header and footer.
When checked, the settings for left and right pages are used alternately. \
This typically means that the arrangement of header and footer elements is \
inverted for facing pages. For example, page numbers are placed flush \
outside, left on left-hand pages, right on right-hand pages. 
This option is typically used when a document is printed double-sided.\
\>", \
"IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["First page on Left/Right", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Specifies whether the Left or Right header and footer are used on \
the first page.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Left page header
Right page header
Left page footer
Right page footer\
\>", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
These radio buttons determine which text fields are displayed in \
the dialog box.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Left aligned text box", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Information entered here is printed against the left page margin of \
the specified header or footer.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Centered", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Information entered here is printed in the center of the specified \
header or footer.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Right aligned text box", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Information entered here is printed against the right page margin \
of the specified header or footer.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Include Line", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
When checked, a rule is printed below the selected header or above \
the selected footer.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["The text displayed in these fields is typically a ", "Text"],
  StyleBox["Cell[]", "MR"],
  StyleBox[" expression.", "Text"],
  " ",
  StyleBox["You can use the ", "Text"],
  StyleBox["Show Expression", "SR"],
  StyleBox[" menu command to see the expression corresponding to a cell in a \
notebook.", "Text"],
  " ",
  StyleBox["Following are some useful ", "Text"],
  StyleBox["Cell[]", "MR"],
  StyleBox[" expressions to use as headers or footers:", "Text"],
  "\n   ",
  StyleBox["Cell[TextData[{CounterBox[ \"Page\"]}], \"PageNumber\"] ", "MR"],
  "defines a cell with the Automatic Numbering Object \"",
  StyleBox["Page", "MR"],
  "\" using the cell style \"",
  StyleBox["PageNumber", "MR"],
  "\". ",
  StyleBox["CounterBox[", "MR"],
  "\"",
  StyleBox["Page", "MR"],
  "\"] is replaced with the appropriate page number and is incremented for \
each printed page.\n   ",
  StyleBox["Cell[TextData[{OptionValueBox[\"FileName\"]}], \"Header\"]", 
    "MR"],
  "  inserts the Value Display Object ",
  StyleBox["\"FileName\"", "MR"],
  " using the cell style ",
  StyleBox["\"Header\"", "MR"],
  ". ",
  StyleBox["OptionValueBox[\"FileName\"]", "MR"],
  " is replaced with the notebook's filename, which is a string. This object \
can be replaced by an arbitrary string.\n   If no entry is desired in a \
particular text field of the header or footer, the text box should contain \
the value ",
  StyleBox["None",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["PageHeaders",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["PageFooters",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "IndentedText",
  CellTags->"HeadersFootersDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["Print...", "Command",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Print", "SR"],
  " prints the active notebook."
}], "Usage",
  CellTags->"PrintDialog"],

Cell["\<\
\[FilledSmallSquare] The options available vary with the particular \
printer being used.\
\>", "Notes",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] The page size and shape must first be specified using \
",
  StyleBox["Page Setup", "SR"],
  ". Various other options can be set using ",
  StyleBox["Printing Options", "SR"],
  StyleBox[".",
    FontWeight->"Bold"]
}], "Notes",
  CellTags->"PrintDialog"],

Cell["\<\
\[FilledSmallSquare] Contents of closed cells and closed groups are \
not printed.\
\>", "Notes",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Note that printed notebooks use the style settings \
for the ",
  ButtonBox["Printing Style Environment",
    ButtonData:>"Printing Style Environment",
    ButtonStyle->"OtherInformationLink"],
  " (Format menu), which can be significantly different from the styles \
chosen for on-screen display."
}], "Notes",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["p", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["p", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["p", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"PrintDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["Print Selection...", "Command",
  CellTags->"PrintSelectionDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Print Selection", "SR"],
  " prints the current selection within a notebook."
}], "Usage",
  CellTags->"PrintSelectionDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] You can print any cell selection. If you have \
selected part of a single cell, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prints the whole cell."
}], "Notes",
  CellTags->"PrintSelectionDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["p", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["p", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["p", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"PrintSelectionDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exit", "Command",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Exit", "SR"],
  " causes ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  StyleBox["to quit. ",
    FontWeight->"ExtraLight"]
}], "Usage",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "On Mac OS X systems, this command is called ",
  StyleBox["Quit", "SR"],
  " and is found under the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application menu. "
}], "Notes",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " asks if you want to save any unsaved notebooks before quitting, since \
changes would otherwise be lost."
}], "Notes",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:   ",
  StyleBox["\[AltKey]\[KeyBar][", "C1"],
  StyleBox["F4", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["q", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["q", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"FrontEndQuit"]
}, Closed]],

Cell[CellGroupData[{

Cell["Edit List", "Command",
  CellTags->"propertiesDialogID"],

Cell["\<\
\[FilledSmallSquare] This dialog box is displayed when you need to \
select an item from a list to be edited. \
\>", "Usage",
  CellTags->"propertiesDialogID"],

Cell["\<\
\[FilledSmallSquare] Click the item in the list box to select it.\
\
\>", "Notes",
  CellTags->"propertiesDialogID"],

Cell["Add", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Lets you add a new item to the list.", "IndentedText",
  CellTags->"propertiesDialogID"],

Cell["Remove", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Deletes an item from the list.", "IndentedText",
  CellTags->"propertiesDialogID"],

Cell["Edit ", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Lets you modify the selected item.", "IndentedText",
  CellTags->"propertiesDialogID"]
}, Closed]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1148}, {0, 848}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{684, 660},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrintingOptions->{"PrintingMargins"->{{Inherited, 88}, {Inherited, \
Inherited}}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "New"->{
    Cell[1776, 53, 41, 1, 41, "Command",
      CellTags->"New"],
    Cell[1820, 56, 155, 6, 32, "Usage",
      CellTags->"New"],
    Cell[1978, 64, 125, 4, 24, "Notes",
      CellTags->"New"],
    Cell[2106, 70, 579, 18, 24, "Notes",
      CellTags->"New"]},
  "Open"->{
    Cell[2722, 93, 73, 2, 45, "Command",
      CellTags->"Open"],
    Cell[2798, 97, 182, 6, 32, "Usage",
      CellTags->"Open"],
    Cell[2983, 105, 100, 2, 24, "Notes",
      CellTags->"Open"],
    Cell[3086, 109, 335, 10, 62, "ItemizedText",
      CellTags->"Open"],
    Cell[3424, 121, 227, 7, 24, "Notes",
      CellTags->"Open"],
    Cell[3654, 130, 227, 7, 24, "Notes",
      CellTags->"Open"],
    Cell[3884, 139, 580, 18, 24, "Notes",
      CellTags->"Open"],
    Cell[4489, 161, 178, 6, 34, "Subsubsection",
      CellTags->"Open"],
    Cell[4670, 169, 135, 3, 24, "Notes",
      CellTags->"Open"],
    Cell[4808, 174, 374, 8, 42, "NotesList",
      CellTags->{"Open", "convertingFrom22NotebookDialogID"}],
    Cell[5185, 184, 355, 10, 40, "Notes",
      CellTags->{"convertingFrom22NotebookDialogID", "Open"}],
    Cell[5543, 196, 131, 3, 24, "Notes",
      CellTags->"Open"],
    Cell[5677, 201, 311, 7, 42, "NotesList",
      CellTags->"Open"],
    Cell[6228, 219, 131, 3, 24, "Notes",
      CellTags->"Open"],
    Cell[6362, 224, 458, 10, 58, "NotesList",
      CellTags->"Open"],
    Cell[6823, 236, 148, 3, 24, "Notes",
      CellTags->"Open"],
    Cell[6974, 241, 260, 6, 42, "NotesList",
      CellTags->"Open"],
    Cell[7237, 249, 143, 3, 24, "Notes",
      CellTags->"Open"],
    Cell[7383, 254, 190, 5, 26, "NotesList",
      CellTags->"Open"],
    Cell[7576, 261, 148, 3, 24, "Notes",
      CellTags->"Open"],
    Cell[7727, 266, 116, 2, 26, "NotesList",
      CellTags->"Open"]},
  "convertingFrom22NotebookDialogID"->{
    Cell[4808, 174, 374, 8, 42, "NotesList",
      CellTags->{"Open", "convertingFrom22NotebookDialogID"}],
    Cell[5185, 184, 355, 10, 40, "Notes",
      CellTags->{"convertingFrom22NotebookDialogID", "Open"}]},
  "Close"->{
    Cell[7892, 274, 87, 2, 45, "Command",
      CellTags->"Close"],
    Cell[7982, 278, 148, 5, 31, "Usage",
      CellTags->"Close"],
    Cell[8133, 285, 275, 8, 24, "Notes",
      CellTags->"Close"],
    Cell[8411, 295, 582, 18, 24, "Notes",
      CellTags->"Close"]},
  "Save"->{
    Cell[9030, 318, 85, 2, 45, "Command",
      CellTags->"Save"],
    Cell[9118, 322, 146, 5, 31, "Usage",
      CellTags->"Save"],
    Cell[9267, 329, 356, 10, 40, "Notes",
      CellTags->"Save"],
    Cell[9626, 341, 580, 18, 24, "Notes",
      CellTags->"Save"]},
  "SaveRename"->{
    Cell[10243, 364, 97, 2, 45, "Command",
      CellTags->"SaveRename"],
    Cell[10343, 368, 161, 5, 31, "Usage",
      CellTags->"SaveRename"],
    Cell[10507, 375, 176, 5, 24, "Notes",
      CellTags->"SaveRename"],
    Cell[10686, 382, 626, 17, 24, "Notes",
      CellTags->"SaveRename"]},
  "SaveRenameSpecial"->{
    Cell[11349, 404, 112, 2, 45, "Command",
      CellTags->"SaveRenameSpecial"],
    Cell[11464, 408, 174, 5, 31, "Usage",
      CellTags->"SaveRenameSpecial"],
    Cell[11641, 415, 335, 10, 40, "Notes",
      CellTags->"SaveRenameSpecial"],
    Cell[11979, 427, 224, 7, 24, "Notes",
      CellTags->"SaveRenameSpecial"]},
  "SaveRenameSpecialV20Notebook"->{
    Cell[12228, 438, 189, 4, 32, "Command",
      CellTags->{
      "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}],
    Cell[12420, 444, 358, 11, 47, "Usage",
      CellTags->{
      "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}]},
  "convertingTo22NotebookDialogID"->{
    Cell[12228, 438, 189, 4, 32, "Command",
      CellTags->{
      "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}],
    Cell[12420, 444, 358, 11, 47, "Usage",
      CellTags->{
      "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}]},
  "SaveRenameSpecialText"->{
    Cell[12815, 460, 129, 3, 32, "Command",
      CellTags->"SaveRenameSpecialText"],
    Cell[12947, 465, 199, 6, 31, "Usage",
      CellTags->"SaveRenameSpecialText"]},
  "SaveRenameSpecialCellExpression"->{
    Cell[13183, 476, 150, 3, 32, "Command",
      CellTags->"SaveRenameSpecialCellExpression"],
    Cell[13336, 481, 285, 8, 47, "Usage",
      CellTags->"SaveRenameSpecialCellExpression"]},
  "SaveRenameSpecialNotebookExpression"->{
    Cell[13658, 494, 158, 3, 32, "Command",
      CellTags->"SaveRenameSpecialNotebookExpression"],
    Cell[13819, 499, 296, 8, 47, "Usage",
      CellTags->"SaveRenameSpecialNotebookExpression"]},
  "SaveRenameSpecialPackage"->{
    Cell[14152, 512, 142, 3, 32, "Command",
      CellTags->"SaveRenameSpecialPackage"],
    Cell[14297, 517, 324, 8, 47, "Usage",
      CellTags->"SaveRenameSpecialPackage"],
    Cell[14624, 527, 182, 6, 24, "Notes",
      CellTags->"SaveRenameSpecialPackage"]},
  "TeXSave"->{
    Cell[14843, 538, 72, 2, 32, "Command",
      CellTags->"TeXSave"],
    Cell[14918, 542, 163, 5, 31, "Usage",
      CellTags->"TeXSave"],
    Cell[15084, 549, 135, 5, 24, "Notes",
      CellTags->"TeXSave"]},
  "HTMLSave"->{
    Cell[15256, 559, 74, 2, 32, "Command",
      CellTags->"HTMLSave"],
    Cell[15333, 563, 167, 5, 31, "Usage",
      CellTags->"HTMLSave"],
    Cell[15503, 570, 136, 5, 24, "Notes",
      CellTags->"HTMLSave"]},
  "XHTML+MathMLSave"->{
    Cell[15676, 580, 96, 2, 32, "Command",
      CellTags->"XHTML+MathMLSave"],
    Cell[15775, 584, 256, 6, 47, "Usage",
      CellTags->"XHTML+MathMLSave"],
    Cell[16034, 592, 144, 5, 24, "Notes",
      CellTags->"XHTML+MathMLSave"]},
  "NotebookMLSave"->{
    Cell[16215, 602, 92, 2, 32, "Command",
      CellTags->"NotebookMLSave"],
    Cell[16310, 606, 190, 5, 31, "Usage",
      CellTags->"NotebookMLSave"],
    Cell[16503, 613, 214, 6, 24, "Notes",
      CellTags->"NotebookMLSave"],
    Cell[16720, 621, 142, 5, 24, "Notes",
      CellTags->"NotebookMLSave"]},
  "NotebookML+MathMLSave"->{
    Cell[16899, 631, 106, 2, 32, "Command",
      CellTags->"NotebookML+MathMLSave"],
    Cell[17008, 635, 270, 6, 47, "Usage",
      CellTags->"NotebookML+MathMLSave"],
    Cell[17281, 643, 221, 6, 24, "Notes",
      CellTags->"NotebookML+MathMLSave"],
    Cell[17505, 651, 149, 5, 24, "Notes",
      CellTags->"NotebookML+MathMLSave"]},
  "Revert"->{
    Cell[17703, 662, 89, 2, 45, "Command",
      CellTags->"Revert"],
    Cell[17795, 666, 178, 5, 32, "Usage",
      CellTags->"Revert"],
    Cell[17976, 673, 338, 7, 62, "Notes",
      CellTags->"Revert"]},
  "OpenSpecial"->{
    Cell[18351, 685, 103, 2, 45, "Command",
      CellTags->"OpenSpecial"],
    Cell[18457, 689, 304, 11, 32, "Usage",
      CellTags->"OpenSpecial"],
    Cell[18764, 702, 154, 4, 24, "Text",
      CellTags->"OpenSpecial"],
    Cell[18921, 708, 98, 2, 34, "Subsubsection",
      CellTags->"OpenSpecial"],
    Cell[19022, 712, 116, 2, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[19141, 716, 271, 6, 42, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[19415, 724, 64, 1, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[19482, 727, 84, 1, 24, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[19569, 730, 71, 1, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[19643, 733, 100, 1, 24, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[19746, 736, 77, 1, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[19826, 739, 98, 1, 24, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[19927, 742, 82, 1, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[20012, 745, 103, 1, 24, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[20118, 748, 108, 2, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[20229, 752, 362, 7, 60, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[20594, 761, 97, 2, 34, "Subsubsection",
      CellTags->"OpenSpecial"],
    Cell[20694, 765, 490, 11, 63, "Notes",
      CellTags->"OpenSpecial"],
    Cell[21187, 778, 355, 15, 24, "Notes",
      CellTags->"OpenSpecial"]},
  "OpenSelection"->{
    Cell[21579, 798, 104, 2, 45, "Command",
      CellTags->"OpenSelection"],
    Cell[21686, 802, 188, 5, 32, "Usage",
      CellTags->"OpenSelection"],
    Cell[21877, 809, 327, 9, 40, "Notes",
      CellTags->"OpenSelection"],
    Cell[22207, 820, 696, 27, 40, "Notes",
      CellTags->"OpenSelection"],
    Cell[22906, 849, 245, 6, 24, "Notes",
      CellTags->"OpenSelection"]},
  "Import"->{
    Cell[23188, 860, 92, 2, 45, "Command",
      CellTags->"Import"],
    Cell[23283, 864, 192, 6, 32, "Usage",
      CellTags->"Import"]},
  "SendTo"->{
    Cell[23512, 875, 93, 2, 45, "Command",
      CellTags->"SendTo"],
    Cell[23608, 879, 302, 10, 32, "Usage",
      CellTags->"SendTo"],
    Cell[23913, 891, 394, 7, 62, "Notes",
      CellTags->"SendTo"]},
  "SendSelection"->{
    Cell[24344, 903, 107, 2, 45, "Command",
      CellTags->"SendSelection"],
    Cell[24454, 907, 242, 6, 48, "Usage",
      CellTags->"SendSelection"],
    Cell[24699, 915, 394, 7, 62, "Notes",
      CellTags->"SendSelection"]},
  "MenuListPalettesMenu"->{
    Cell[25130, 927, 105, 2, 45, "Command",
      CellTags->"MenuListPalettesMenu"],
    Cell[25238, 931, 162, 5, 32, "Usage",
      CellTags->"MenuListPalettesMenu"],
    Cell[25403, 938, 295, 8, 40, "Notes",
      CellTags->"MenuListPalettesMenu"],
    Cell[25701, 948, 266, 11, 24, "Notes",
      CellTags->"MenuListPalettesMenu"]},
  "GeneratePalette"->{
    Cell[26004, 964, 123, 2, 45, "Command",
      CellTags->"GeneratePalette"],
    Cell[26130, 968, 191, 5, 32, "Usage",
      CellTags->"GeneratePalette"],
    Cell[26324, 975, 213, 5, 24, "Notes",
      CellTags->"GeneratePalette"]},
  "GenerateNotebook"->{
    Cell[26574, 985, 123, 2, 45, "Command",
      CellTags->"GenerateNotebook"],
    Cell[26700, 989, 229, 7, 32, "Usage",
      CellTags->"GenerateNotebook"]},
  "SystemPrintOptionsDialog"->{
    Cell[27005, 1003, 114, 2, 41, "Command",
      CellTags->"SystemPrintOptionsDialog"],
    Cell[27122, 1007, 257, 6, 48, "Usage",
      CellTags->"SystemPrintOptionsDialog"]},
  "PrintOptionsDialog"->{
    Cell[27416, 1018, 114, 2, 45, "Command",
      CellTags->"PrintOptionsDialog"],
    Cell[27533, 1022, 351, 10, 48, "Usage",
      CellTags->"PrintOptionsDialog"],
    Cell[27887, 1034, 144, 3, 25, "DialogItem",
      CellTags->"PrintOptionsDialog"],
    Cell[28034, 1039, 138, 2, 24, "IndentedText",
      CellTags->"PrintOptionsDialog"],
    Cell[28175, 1043, 149, 3, 25, "DialogItem",
      CellTags->"PrintOptionsDialog"],
    Cell[28327, 1048, 545, 16, 60, "IndentedText",
      CellTags->"PrintOptionsDialog"],
    Cell[28875, 1066, 160, 3, 25, "DialogItem",
      CellTags->"PrintOptionsDialog"],
    Cell[29038, 1071, 267, 8, 24, "IndentedText",
      CellTags->"PrintOptionsDialog"],
    Cell[29308, 1081, 132, 3, 25, "DialogItem",
      CellTags->"PrintOptionsDialog"],
    Cell[29443, 1086, 262, 6, 42, "IndentedText",
      CellTags->"PrintOptionsDialog"]},
  "HeadersFootersDialog"->{
    Cell[29742, 1097, 119, 2, 45, "Command",
      CellTags->"HeadersFootersDialog"],
    Cell[29864, 1101, 203, 6, 31, "Usage",
      CellTags->"HeadersFootersDialog"],
    Cell[30070, 1109, 236, 5, 40, "Notes",
      CellTags->"HeadersFootersDialog"],
    Cell[30309, 1116, 243, 7, 24, "Notes",
      CellTags->"HeadersFootersDialog"],
    Cell[30555, 1125, 79, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[30637, 1128, 112, 1, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[30752, 1131, 81, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[30836, 1134, 119, 2, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[30958, 1138, 81, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[31042, 1141, 119, 2, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[31164, 1145, 78, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[31245, 1148, 491, 9, 96, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[31739, 1159, 82, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[31824, 1162, 151, 4, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[31978, 1168, 135, 6, 64, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[32116, 1176, 150, 4, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[32269, 1182, 79, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[32351, 1185, 169, 4, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[32523, 1191, 66, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[32592, 1194, 154, 4, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[32749, 1200, 80, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[32832, 1203, 170, 4, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[33005, 1209, 70, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[33078, 1212, 157, 4, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[33238, 1218, 1556, 42, 186, "Notes",
      CellTags->"HeadersFootersDialog"],
    Cell[34797, 1262, 259, 9, 24, "IndentedText",
      CellTags->"HeadersFootersDialog"]},
  "PrintDialog"->{
    Cell[35093, 1276, 54, 1, 45, "Command",
      CellTags->"PrintDialog"],
    Cell[35150, 1279, 142, 5, 32, "Usage",
      CellTags->"PrintDialog"],
    Cell[35295, 1286, 141, 4, 24, "Notes",
      CellTags->"PrintDialog"],
    Cell[35439, 1292, 295, 9, 40, "Notes",
      CellTags->"PrintDialog"],
    Cell[35737, 1303, 134, 4, 24, "Notes",
      CellTags->"PrintDialog"],
    Cell[35874, 1309, 378, 9, 40, "Notes",
      CellTags->"PrintDialog"],
    Cell[36255, 1320, 587, 18, 24, "Notes",
      CellTags->"PrintDialog"]},
  "PrintSelectionDialog"->{
    Cell[36879, 1343, 73, 1, 45, "Command",
      CellTags->"PrintSelectionDialog"],
    Cell[36955, 1346, 181, 5, 32, "Usage",
      CellTags->"PrintSelectionDialog"],
    Cell[37139, 1353, 251, 7, 24, "Notes",
      CellTags->"PrintSelectionDialog"],
    Cell[37393, 1362, 737, 21, 24, "Notes",
      CellTags->"PrintSelectionDialog"]},
  "FrontEndQuit"->{
    Cell[38167, 1388, 51, 1, 45, "Command",
      CellTags->"FrontEndQuit"],
    Cell[38221, 1391, 230, 9, 32, "Usage",
      CellTags->"FrontEndQuit"],
    Cell[38454, 1402, 265, 9, 24, "Notes",
      CellTags->"FrontEndQuit"],
    Cell[38722, 1413, 245, 7, 24, "Notes",
      CellTags->"FrontEndQuit"],
    Cell[38970, 1422, 581, 18, 24, "Notes",
      CellTags->"FrontEndQuit"]},
  "propertiesDialogID"->{
    Cell[39588, 1445, 62, 1, 45, "Command",
      CellTags->"propertiesDialogID"],
    Cell[39653, 1448, 169, 4, 32, "Usage",
      CellTags->"propertiesDialogID"],
    Cell[39825, 1454, 126, 4, 24, "Notes",
      CellTags->"propertiesDialogID"],
    Cell[39954, 1460, 59, 1, 25, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[40016, 1463, 94, 1, 24, "IndentedText",
      CellTags->"propertiesDialogID"],
    Cell[40113, 1466, 62, 1, 25, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[40178, 1469, 88, 1, 24, "IndentedText",
      CellTags->"propertiesDialogID"],
    Cell[40269, 1472, 61, 1, 25, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[40333, 1475, 92, 1, 24, "IndentedText",
      CellTags->"propertiesDialogID"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"New", 41291, 1503},
  {"Open", 41562, 1512},
  {"convertingFrom22NotebookDialogID", 43107, 1555},
  {"Close", 43334, 1560},
  {"Save", 43617, 1569},
  {"SaveRename", 43903, 1578},
  {"SaveRenameSpecial", 44223, 1587},
  {"SaveRenameSpecialV20Notebook", 44583, 1596},
  {"convertingTo22NotebookDialogID", 44893, 1603},
  {"SaveRenameSpecialText", 45194, 1610},
  {"SaveRenameSpecialCellExpression", 45404, 1615},
  {"SaveRenameSpecialNotebookExpression", 45638, 1620},
  {"SaveRenameSpecialPackage", 45869, 1625},
  {"TeXSave", 46148, 1632},
  {"HTMLSave", 46376, 1639},
  {"XHTML+MathMLSave", 46615, 1646},
  {"NotebookMLSave", 46876, 1653},
  {"NotebookML+MathMLSave", 47215, 1662},
  {"Revert", 47568, 1671},
  {"OpenSpecial", 47796, 1678},
  {"OpenSelection", 49308, 1717},
  {"Import", 49706, 1728},
  {"SendTo", 49860, 1733},
  {"SendSelection", 50091, 1740},
  {"MenuListPalettesMenu", 50350, 1747},
  {"GeneratePalette", 50709, 1756},
  {"GenerateNotebook", 50970, 1763},
  {"SystemPrintOptionsDialog", 51163, 1768},
  {"PrintOptionsDialog", 51368, 1773},
  {"HeadersFootersDialog", 52269, 1794},
  {"PrintDialog", 54596, 1847},
  {"PrintSelectionDialog", 55152, 1862},
  {"FrontEndQuit", 55511, 1871},
  {"propertiesDialogID", 55920, 1882}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 41, 1, 41, "Command",
  CellTags->"New"],
Cell[1820, 56, 155, 6, 32, "Usage",
  CellTags->"New"],
Cell[1978, 64, 125, 4, 24, "Notes",
  CellTags->"New"],
Cell[2106, 70, 579, 18, 24, "Notes",
  CellTags->"New"]
}, Closed]],

Cell[CellGroupData[{
Cell[2722, 93, 73, 2, 45, "Command",
  CellTags->"Open"],
Cell[2798, 97, 182, 6, 32, "Usage",
  CellTags->"Open"],
Cell[2983, 105, 100, 2, 24, "Notes",
  CellTags->"Open"],
Cell[3086, 109, 335, 10, 62, "ItemizedText",
  CellTags->"Open"],
Cell[3424, 121, 227, 7, 24, "Notes",
  CellTags->"Open"],
Cell[3654, 130, 227, 7, 24, "Notes",
  CellTags->"Open"],
Cell[3884, 139, 580, 18, 24, "Notes",
  CellTags->"Open"],

Cell[CellGroupData[{
Cell[4489, 161, 178, 6, 34, "Subsubsection",
  CellTags->"Open"],
Cell[4670, 169, 135, 3, 24, "Notes",
  CellTags->"Open"],
Cell[4808, 174, 374, 8, 42, "NotesList",
  CellTags->{"Open", "convertingFrom22NotebookDialogID"}],
Cell[5185, 184, 355, 10, 40, "Notes",
  CellTags->{"convertingFrom22NotebookDialogID", "Open"}],
Cell[5543, 196, 131, 3, 24, "Notes",
  CellTags->"Open"],
Cell[5677, 201, 311, 7, 42, "NotesList",
  CellTags->"Open"],
Cell[5991, 210, 234, 7, 26, "NotesList"],
Cell[6228, 219, 131, 3, 24, "Notes",
  CellTags->"Open"],
Cell[6362, 224, 458, 10, 58, "NotesList",
  CellTags->"Open"],
Cell[6823, 236, 148, 3, 24, "Notes",
  CellTags->"Open"],
Cell[6974, 241, 260, 6, 42, "NotesList",
  CellTags->"Open"],
Cell[7237, 249, 143, 3, 24, "Notes",
  CellTags->"Open"],
Cell[7383, 254, 190, 5, 26, "NotesList",
  CellTags->"Open"],
Cell[7576, 261, 148, 3, 24, "Notes",
  CellTags->"Open"],
Cell[7727, 266, 116, 2, 26, "NotesList",
  CellTags->"Open"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7892, 274, 87, 2, 45, "Command",
  CellTags->"Close"],
Cell[7982, 278, 148, 5, 31, "Usage",
  CellTags->"Close"],
Cell[8133, 285, 275, 8, 24, "Notes",
  CellTags->"Close"],
Cell[8411, 295, 582, 18, 24, "Notes",
  CellTags->"Close"]
}, Closed]],

Cell[CellGroupData[{
Cell[9030, 318, 85, 2, 45, "Command",
  CellTags->"Save"],
Cell[9118, 322, 146, 5, 31, "Usage",
  CellTags->"Save"],
Cell[9267, 329, 356, 10, 40, "Notes",
  CellTags->"Save"],
Cell[9626, 341, 580, 18, 24, "Notes",
  CellTags->"Save"]
}, Closed]],

Cell[CellGroupData[{
Cell[10243, 364, 97, 2, 45, "Command",
  CellTags->"SaveRename"],
Cell[10343, 368, 161, 5, 31, "Usage",
  CellTags->"SaveRename"],
Cell[10507, 375, 176, 5, 24, "Notes",
  CellTags->"SaveRename"],
Cell[10686, 382, 626, 17, 24, "Notes",
  CellTags->"SaveRename"]
}, Closed]],

Cell[CellGroupData[{
Cell[11349, 404, 112, 2, 45, "Command",
  CellTags->"SaveRenameSpecial"],
Cell[11464, 408, 174, 5, 31, "Usage",
  CellTags->"SaveRenameSpecial"],
Cell[11641, 415, 335, 10, 40, "Notes",
  CellTags->"SaveRenameSpecial"],
Cell[11979, 427, 224, 7, 24, "Notes",
  CellTags->"SaveRenameSpecial"],

Cell[CellGroupData[{
Cell[12228, 438, 189, 4, 32, "Command",
  CellTags->{
  "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}],
Cell[12420, 444, 358, 11, 47, "Usage",
  CellTags->{
  "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}]
}, Closed]],

Cell[CellGroupData[{
Cell[12815, 460, 129, 3, 32, "Command",
  CellTags->"SaveRenameSpecialText"],
Cell[12947, 465, 199, 6, 31, "Usage",
  CellTags->"SaveRenameSpecialText"]
}, Closed]],

Cell[CellGroupData[{
Cell[13183, 476, 150, 3, 32, "Command",
  CellTags->"SaveRenameSpecialCellExpression"],
Cell[13336, 481, 285, 8, 47, "Usage",
  CellTags->"SaveRenameSpecialCellExpression"]
}, Closed]],

Cell[CellGroupData[{
Cell[13658, 494, 158, 3, 32, "Command",
  CellTags->"SaveRenameSpecialNotebookExpression"],
Cell[13819, 499, 296, 8, 47, "Usage",
  CellTags->"SaveRenameSpecialNotebookExpression"]
}, Closed]],

Cell[CellGroupData[{
Cell[14152, 512, 142, 3, 32, "Command",
  CellTags->"SaveRenameSpecialPackage"],
Cell[14297, 517, 324, 8, 47, "Usage",
  CellTags->"SaveRenameSpecialPackage"],
Cell[14624, 527, 182, 6, 24, "Notes",
  CellTags->"SaveRenameSpecialPackage"]
}, Closed]],

Cell[CellGroupData[{
Cell[14843, 538, 72, 2, 32, "Command",
  CellTags->"TeXSave"],
Cell[14918, 542, 163, 5, 31, "Usage",
  CellTags->"TeXSave"],
Cell[15084, 549, 135, 5, 24, "Notes",
  CellTags->"TeXSave"]
}, Closed]],

Cell[CellGroupData[{
Cell[15256, 559, 74, 2, 32, "Command",
  CellTags->"HTMLSave"],
Cell[15333, 563, 167, 5, 31, "Usage",
  CellTags->"HTMLSave"],
Cell[15503, 570, 136, 5, 24, "Notes",
  CellTags->"HTMLSave"]
}, Closed]],

Cell[CellGroupData[{
Cell[15676, 580, 96, 2, 32, "Command",
  CellTags->"XHTML+MathMLSave"],
Cell[15775, 584, 256, 6, 47, "Usage",
  CellTags->"XHTML+MathMLSave"],
Cell[16034, 592, 144, 5, 24, "Notes",
  CellTags->"XHTML+MathMLSave"]
}, Closed]],

Cell[CellGroupData[{
Cell[16215, 602, 92, 2, 32, "Command",
  CellTags->"NotebookMLSave"],
Cell[16310, 606, 190, 5, 31, "Usage",
  CellTags->"NotebookMLSave"],
Cell[16503, 613, 214, 6, 24, "Notes",
  CellTags->"NotebookMLSave"],
Cell[16720, 621, 142, 5, 24, "Notes",
  CellTags->"NotebookMLSave"]
}, Closed]],

Cell[CellGroupData[{
Cell[16899, 631, 106, 2, 32, "Command",
  CellTags->"NotebookML+MathMLSave"],
Cell[17008, 635, 270, 6, 47, "Usage",
  CellTags->"NotebookML+MathMLSave"],
Cell[17281, 643, 221, 6, 24, "Notes",
  CellTags->"NotebookML+MathMLSave"],
Cell[17505, 651, 149, 5, 24, "Notes",
  CellTags->"NotebookML+MathMLSave"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17703, 662, 89, 2, 45, "Command",
  CellTags->"Revert"],
Cell[17795, 666, 178, 5, 32, "Usage",
  CellTags->"Revert"],
Cell[17976, 673, 338, 7, 62, "Notes",
  CellTags->"Revert"]
}, Closed]],

Cell[CellGroupData[{
Cell[18351, 685, 103, 2, 45, "Command",
  CellTags->"OpenSpecial"],
Cell[18457, 689, 304, 11, 32, "Usage",
  CellTags->"OpenSpecial"],
Cell[18764, 702, 154, 4, 24, "Text",
  CellTags->"OpenSpecial"],
Cell[18921, 708, 98, 2, 34, "Subsubsection",
  CellTags->"OpenSpecial"],
Cell[19022, 712, 116, 2, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[19141, 716, 271, 6, 42, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[19415, 724, 64, 1, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[19482, 727, 84, 1, 24, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[19569, 730, 71, 1, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[19643, 733, 100, 1, 24, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[19746, 736, 77, 1, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[19826, 739, 98, 1, 24, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[19927, 742, 82, 1, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[20012, 745, 103, 1, 24, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[20118, 748, 108, 2, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[20229, 752, 362, 7, 60, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[20594, 761, 97, 2, 34, "Subsubsection",
  CellTags->"OpenSpecial"],
Cell[20694, 765, 490, 11, 63, "Notes",
  CellTags->"OpenSpecial"],
Cell[21187, 778, 355, 15, 24, "Notes",
  CellTags->"OpenSpecial"]
}, Closed]],

Cell[CellGroupData[{
Cell[21579, 798, 104, 2, 45, "Command",
  CellTags->"OpenSelection"],
Cell[21686, 802, 188, 5, 32, "Usage",
  CellTags->"OpenSelection"],
Cell[21877, 809, 327, 9, 40, "Notes",
  CellTags->"OpenSelection"],
Cell[22207, 820, 696, 27, 40, "Notes",
  CellTags->"OpenSelection"],
Cell[22906, 849, 245, 6, 24, "Notes",
  CellTags->"OpenSelection"]
}, Closed]],

Cell[CellGroupData[{
Cell[23188, 860, 92, 2, 45, "Command",
  CellTags->"Import"],
Cell[23283, 864, 192, 6, 32, "Usage",
  CellTags->"Import"]
}, Closed]],

Cell[CellGroupData[{
Cell[23512, 875, 93, 2, 45, "Command",
  CellTags->"SendTo"],
Cell[23608, 879, 302, 10, 32, "Usage",
  CellTags->"SendTo"],
Cell[23913, 891, 394, 7, 62, "Notes",
  CellTags->"SendTo"]
}, Closed]],

Cell[CellGroupData[{
Cell[24344, 903, 107, 2, 45, "Command",
  CellTags->"SendSelection"],
Cell[24454, 907, 242, 6, 48, "Usage",
  CellTags->"SendSelection"],
Cell[24699, 915, 394, 7, 62, "Notes",
  CellTags->"SendSelection"]
}, Closed]],

Cell[CellGroupData[{
Cell[25130, 927, 105, 2, 45, "Command",
  CellTags->"MenuListPalettesMenu"],
Cell[25238, 931, 162, 5, 32, "Usage",
  CellTags->"MenuListPalettesMenu"],
Cell[25403, 938, 295, 8, 40, "Notes",
  CellTags->"MenuListPalettesMenu"],
Cell[25701, 948, 266, 11, 24, "Notes",
  CellTags->"MenuListPalettesMenu"]
}, Closed]],

Cell[CellGroupData[{
Cell[26004, 964, 123, 2, 45, "Command",
  CellTags->"GeneratePalette"],
Cell[26130, 968, 191, 5, 32, "Usage",
  CellTags->"GeneratePalette"],
Cell[26324, 975, 213, 5, 24, "Notes",
  CellTags->"GeneratePalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[26574, 985, 123, 2, 45, "Command",
  CellTags->"GenerateNotebook"],
Cell[26700, 989, 229, 7, 32, "Usage",
  CellTags->"GenerateNotebook"]
}, Closed]],
Cell[26944, 999, 36, 0, 45, "Command"],

Cell[CellGroupData[{
Cell[27005, 1003, 114, 2, 41, "Command",
  CellTags->"SystemPrintOptionsDialog"],
Cell[27122, 1007, 257, 6, 48, "Usage",
  CellTags->"SystemPrintOptionsDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[27416, 1018, 114, 2, 45, "Command",
  CellTags->"PrintOptionsDialog"],
Cell[27533, 1022, 351, 10, 48, "Usage",
  CellTags->"PrintOptionsDialog"],
Cell[27887, 1034, 144, 3, 25, "DialogItem",
  CellTags->"PrintOptionsDialog"],
Cell[28034, 1039, 138, 2, 24, "IndentedText",
  CellTags->"PrintOptionsDialog"],
Cell[28175, 1043, 149, 3, 25, "DialogItem",
  CellTags->"PrintOptionsDialog"],
Cell[28327, 1048, 545, 16, 60, "IndentedText",
  CellTags->"PrintOptionsDialog"],
Cell[28875, 1066, 160, 3, 25, "DialogItem",
  CellTags->"PrintOptionsDialog"],
Cell[29038, 1071, 267, 8, 24, "IndentedText",
  CellTags->"PrintOptionsDialog"],
Cell[29308, 1081, 132, 3, 25, "DialogItem",
  CellTags->"PrintOptionsDialog"],
Cell[29443, 1086, 262, 6, 42, "IndentedText",
  CellTags->"PrintOptionsDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[29742, 1097, 119, 2, 45, "Command",
  CellTags->"HeadersFootersDialog"],
Cell[29864, 1101, 203, 6, 31, "Usage",
  CellTags->"HeadersFootersDialog"],
Cell[30070, 1109, 236, 5, 40, "Notes",
  CellTags->"HeadersFootersDialog"],
Cell[30309, 1116, 243, 7, 24, "Notes",
  CellTags->"HeadersFootersDialog"],
Cell[30555, 1125, 79, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[30637, 1128, 112, 1, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[30752, 1131, 81, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[30836, 1134, 119, 2, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[30958, 1138, 81, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[31042, 1141, 119, 2, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[31164, 1145, 78, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[31245, 1148, 491, 9, 96, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[31739, 1159, 82, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[31824, 1162, 151, 4, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[31978, 1168, 135, 6, 64, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[32116, 1176, 150, 4, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[32269, 1182, 79, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[32351, 1185, 169, 4, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[32523, 1191, 66, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[32592, 1194, 154, 4, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[32749, 1200, 80, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[32832, 1203, 170, 4, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[33005, 1209, 70, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[33078, 1212, 157, 4, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[33238, 1218, 1556, 42, 186, "Notes",
  CellTags->"HeadersFootersDialog"],
Cell[34797, 1262, 259, 9, 24, "IndentedText",
  CellTags->"HeadersFootersDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[35093, 1276, 54, 1, 45, "Command",
  CellTags->"PrintDialog"],
Cell[35150, 1279, 142, 5, 32, "Usage",
  CellTags->"PrintDialog"],
Cell[35295, 1286, 141, 4, 24, "Notes",
  CellTags->"PrintDialog"],
Cell[35439, 1292, 295, 9, 40, "Notes",
  CellTags->"PrintDialog"],
Cell[35737, 1303, 134, 4, 24, "Notes",
  CellTags->"PrintDialog"],
Cell[35874, 1309, 378, 9, 40, "Notes",
  CellTags->"PrintDialog"],
Cell[36255, 1320, 587, 18, 24, "Notes",
  CellTags->"PrintDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[36879, 1343, 73, 1, 45, "Command",
  CellTags->"PrintSelectionDialog"],
Cell[36955, 1346, 181, 5, 32, "Usage",
  CellTags->"PrintSelectionDialog"],
Cell[37139, 1353, 251, 7, 24, "Notes",
  CellTags->"PrintSelectionDialog"],
Cell[37393, 1362, 737, 21, 24, "Notes",
  CellTags->"PrintSelectionDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[38167, 1388, 51, 1, 45, "Command",
  CellTags->"FrontEndQuit"],
Cell[38221, 1391, 230, 9, 32, "Usage",
  CellTags->"FrontEndQuit"],
Cell[38454, 1402, 265, 9, 24, "Notes",
  CellTags->"FrontEndQuit"],
Cell[38722, 1413, 245, 7, 24, "Notes",
  CellTags->"FrontEndQuit"],
Cell[38970, 1422, 581, 18, 24, "Notes",
  CellTags->"FrontEndQuit"]
}, Closed]],

Cell[CellGroupData[{
Cell[39588, 1445, 62, 1, 45, "Command",
  CellTags->"propertiesDialogID"],
Cell[39653, 1448, 169, 4, 32, "Usage",
  CellTags->"propertiesDialogID"],
Cell[39825, 1454, 126, 4, 24, "Notes",
  CellTags->"propertiesDialogID"],
Cell[39954, 1460, 59, 1, 25, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[40016, 1463, 94, 1, 24, "IndentedText",
  CellTags->"propertiesDialogID"],
Cell[40113, 1466, 62, 1, 25, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[40178, 1469, 88, 1, 24, "IndentedText",
  CellTags->"propertiesDialogID"],
Cell[40269, 1472, 61, 1, 25, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[40333, 1475, 92, 1, 24, "IndentedText",
  CellTags->"propertiesDialogID"]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

