(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20390,        702]*)
(*NotebookOutlinePosition[     32907,       1002]*)
(*  CellTagsIndexPosition[     32132,        976]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Find...", "Command",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find", "SR"],
  " searches the current notebook for matches to the text contained in the \
\"Search for:\" field of the dialog box."
}], "Usage",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Once a match is found in the notebook, choosing ",
  StyleBox["Replace", "SR"],
  " in the Find menu replaces the selected match with the new text contained \
in the \"Replace with:\" field."
}], "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Find", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["\<\
Searches forward for the next occurrence after your current \
selection in the notebook.\
\>", "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Previous", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Searches backward from the current selection.", "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["All", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["\<\
Searches and selects all cells containing an occurrence of the \
search string. \
\>", "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Ignore case", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["When checked, conducts a case-insensitive search.", "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell["Wrap around", "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "When checked, starts at the current selection in the notebook and \
continues to the same point. Otherwise, ",
  StyleBox["Find", "SR"],
  " stops at the end of the file."
}], "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Once your search string has been entered, it can be \
used by all the commands in the Find menu including ",
  StyleBox["Find Next", "SR"],
  ", ",
  StyleBox["Replace", "SR"],
  ", ",
  StyleBox["Replace All", "SR"],
  ", and ",
  StyleBox["Replace and Find Again", "SR"],
  ". The ",
  StyleBox["Enter Selection", "SR"],
  " command in the Find menu is a convenient way to copy text from your \
notebook into the Find dialog box."
}], "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["The Find dialog box ",
    FontWeight->"ExtraLight"],
  "searches the contents of cells only. Use ",
  StyleBox["Find in Cell Tags", "SR"],
  " to search cell tags. "
}], "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["f", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["f", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["f", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"FindDialog"],

Cell[CellGroupData[{

Cell["Enter Selection", "Command",
  CellTags->"SetSelectionFind"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Enter Selection", "SR"],
  " places the currently selected text string into the \"Search for:\" field \
of the Find dialog box."
}], "Usage",
  CellTags->"SetSelectionFind"],

Cell[TextData[{
  "\[FilledSmallSquare] If you follow this command with the ",
  StyleBox["Find Next", "SR"],
  " command, for example, you can conduct a search without having to open the \
Find dialog box."
}], "Notes",
  CellTags->"SetSelectionFind"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["e", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["e", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["e", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SetSelectionFind"],

Cell[CellGroupData[{

Cell["Find Next", "Command",
  CellTags->"NotebookFindNext"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find Next", "SR"],
  " searches for the next occurrence of the text string entered in the Find \
dialog box."
}], "Usage",
  CellTags->"NotebookFindNext"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find Next", "SR"],
  " starts at the current selection. The \"Wrap around\" option in the Find \
dialog box determines whether to stop at the end of the file or not."
}], "Notes",
  CellTags->"NotebookFindNext"],

Cell[TextData[{
  "\[FilledSmallSquare] To specify the search string, use either the ",
  StyleBox["Find", "SR"],
  " or the ",
  StyleBox["Enter Selection", "SR"],
  " command."
}], "Notes",
  CellTags->"NotebookFindNext"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["F3", "C1MR"],
  StyleBox[" ", "C1MR",
    FontFamily->"Times"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["g", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["F3 ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"NtebookFindNext"],

Cell[CellGroupData[{

Cell["Find Previous", "Command",
  CellTags->"NotebookFindPrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find Previous", "SR"],
  " searches backwards in the notebook for the text string entered in the \
Find dialog box."
}], "Usage",
  CellTags->"NotebookFindPrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find Previous", "SR"],
  " starts at the current selection. The \"Wrap around\" option in the Find \
dialog box toggles whether to stop",
  " ",
  "at the end of the file."
}], "Notes",
  CellTags->"NotebookFindPrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] To specify the search string, use either the ",
  StyleBox["Find", "SR"],
  " or the ",
  StyleBox["Enter Selection", "SR"],
  " command."
}], "Notes",
  CellTags->"NotebookFindPrevious"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Find in Cell Tags", "Command",
  CellTags->"SelectionCellTagsFind"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find in Cell Tags", "SR"],
  " searches for a cell tag that matches the selected word."
}], "Usage",
  CellTags->"SelectionCellTagsFind"],

Cell["\<\
\[FilledSmallSquare] This command copies the selected word into the \
Find dialog box and then selects the next cell associated with that cell tag.\
\
\>", "Notes",
  CellTags->"SelectionCellTagsFind"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Replace", "Command",
  CellTags->"Replace"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Replace", "SR"],
  " changes the selected text to the replacement text specified in the Find \
dialog box."
}], "Usage",
  CellTags->"Replace"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["r", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["r", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["r", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Replace"],

Cell[CellGroupData[{

Cell["Replace and Find Again", "Command",
  CellTags->"ReplaceFind"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Replace and Find Again", "SR"],
  " performs a replacement followed by a find."
}], "Usage",
  CellTags->"ReplaceFind"],

Cell[TextData[{
  "\[FilledSmallSquare] This command replaces the selected text and then \
finds the next occurrence of the search text. This is an automatic \
combination of the ",
  StyleBox["Replace", "SR"],
  " and ",
  StyleBox["Find Again", "SR"],
  " commands."
}], "Notes",
  CellTags->"ReplaceFind"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["r", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["r", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["r", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ReplaceandFind"],

Cell[CellGroupData[{

Cell["Replace All", "Command",
  CellTags->"ReplaceAll"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Replace All", "SR"],
  " performs all applicable replacements in the notebook, starting with the \
current selection and continuing to the end of the file."
}], "Usage",
  CellTags->"ReplaceAll"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] When \"Wrap around\" is checked in the ",
  StyleBox["Find", "SR"],
  " dialog box, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " replaces all occurrences before, as well as after, the current \
selection."
}], "Notes",
  CellTags->"ReplaceAll"],

Cell[CellGroupData[{

Cell["Open Selected", "Command",
  CellTags->"OpenSelectionParents"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open Selected", "SR"],
  " opens the cell group(s) containing the selection."
}], "Usage",
  CellTags->"OpenSelectionParents"],

Cell[TextData[{
  "\[FilledSmallSquare] This command is typically used after ",
  StyleBox["Find All", "SR"],
  " in the Find dialog box. When you click ",
  StyleBox["Find All", "SR"],
  " in the Find dialog box, matches may be found in multiple cells throughout \
the notebook. If cell groups are closed, the selections will not be visible. \
You can still copy or replace the selected matches. Choose ",
  StyleBox["Open Selected", "SR"],
  " if you want to see the matched text."
}], "Notes",
  CellTags->"OpenSelectionParents"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scroll to Selection", "Command",
  CellTags->"SelectionScroll"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Scroll to Selection", "SR"],
  " scrolls through the notebook to make the current selection visible."
}], "Usage",
  CellTags->"SelectionScroll"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Go Back", "Command",
  CellTags->"HyperlinkGoBack"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Go Back", "SR"],
  " returns from a hyperlink jump to the place where you started."
}], "Usage",
  CellTags->"HyperlinkGoBack"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Add/Remove Cell Tags...", "Command",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Add/Remove Cell Tags", "SR"],
  " opens a dialog box that allows you to add or remove cell tags associated \
with the selected cell(s)."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[
"\[FilledSmallSquare] Cell tags are used to find single cells or classes of \
cells. For example, all title cells could be given the tag Title, and all \
cells related to a particular subject could be given a cell tag identifying \
that subject."], "Notes",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[{
  "\[FilledSmallSquare] To add a new cell tag to the selected cell or cells, \
type a word in the \"Cell tag:\" text box, then click ",
  StyleBox["Add",
    FontFamily->"Helvetica"],
  ". You can add or remove multiple cell tags at once. Separate multiple cell \
tags with commas."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"ExtraLight"],
  "attaches the specified cell tag to each of the selected cells. The cell \
tags are not visible unless ",
  StyleBox["Show Cell Tags", "SR"],
  " in the Find menu is checked."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}],

Cell[TextData[{
  "\[FilledSmallSquare] All cell tags defined in a particular notebook are \
visible in the Cell Tags submenu under the Find menu. To search for cells \
according to their cell tags, you can use either the Cell Tags submenu or the \
",
  StyleBox["Find in Cell Tags", "SR"],
  " command ."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"CellTagsEditDialog", "editKeysID"}]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["j", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["j", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["j", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellTagsEditDialog"],

Cell[CellGroupData[{

Cell["Cell Tags", "Command",
  CellTags->"MenuListTags"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Tags", "SR"],
  " finds and selects cells on the basis of their cell tags."
}], "Usage",
  CellTags->"MenuListTags"],

Cell["\<\
\[FilledSmallSquare] This submenu lists all cell tags defined in \
the current notebook. Choosing an item from the list selects all the cells \
with that cell tag and scrolls through the notebook so that the first such \
cell is visible.\
\>", "Notes",
  CellTags->"MenuListTags"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Add/Remove Cell Tags",
    ButtonData:>"Add/Remove Cell Tags",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"MenuListTags"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show Cell Tags", "Command",
  CellTags->"ShowCellTags"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show Cell Tags", "SR"],
  " toggles the display of cell tags in the current notebook."
}], "Usage",
  CellTags->"ShowCellTags"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cell Tags From In/Out Names", "Command",
  CellTags->"CellLabelsToTags"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Tags From In/Out Names", "SR"],
  " gives the selected cell a tag that is the same as its current input or \
output prompt."
}], "Usage",
  CellTags->"CellLabelsToTags"],

Cell[TextData[{
  "\[FilledSmallSquare] Ordinarily, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s ",
  StyleBox["In[]:=", "MO",
    FontSlant->"Plain"],
  " and ",
  StyleBox["Out[]=", "MO",
    FontSlant->"Plain"],
  " prompts (",
  StyleBox["CellLabels",
    FontFamily->"Courier"],
  ") disappear when you close a notebook. This is because the numbers \
associated with input and output cells are only relevant during a particular \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session."
}], "Notes",
  CellTags->"CellLabelsToTags"],

Cell[TextData[
"\[FilledSmallSquare] If you want to preserve the In/Out prompts in your \
notebook, perhaps for publication reasons, you can make them into cell tags \
and then show the cell tags. "], "Notes",
  CellTags->"CellLabelsToTags"]
}, Open  ]],

Cell["\<\
\[FilledSmallSquare] This command also allows you to locate \
particular In/Out lines by using the Cell Tags submenu.\
\>", "Notes",
  CellTags->"CellLabelsToTags"],

Cell[CellGroupData[{

Cell["Make Index...", "Command",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Make Index", "SR"],
  " creates an index from the cell tags in a notebook."
}], "Usage",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Make Index", "SR"],
  " command paginates your notebook and then figures out what page each cell \
is on. When a cell has a cell tag, an entry is created in the index with that \
keyword and its corresponding page number(s)."
}], "Notes",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell["\<\
\[FilledSmallSquare] The index is copied onto the Clipboard and \
then can be pasted into a notebook or other file.\
\>", "Notes",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell["Form of index references:", "Subsubsection",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[StyleBox["Text Format",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell["Generates a list of index entries followed by page numbers.", 
  "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[StyleBox["Hyperlinks",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell["Generates a hyperlink for each cell tag.", "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[StyleBox["Page References",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[{
  "Generates a list of index entries followed by counter boxes displaying \
their page numbers. This is",
  " ",
  "valid only when",
  StyleBox[" Show Page Breaks", "SR"],
  " is turned on."
}], "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[StyleBox["Section References",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],

Cell[TextData[{
  "Generates a list of index entries followed by counter boxes displaying \
their section numbers. This is valid only when ",
  StyleBox["Show Page Breaks", "SR"],
  " is turned on."
}], "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{0, 1110}, {0, 746}},
ScreenStyleEnvironment->"Working",
CellGrouping->Manual,
WindowSize->{594, 551},
WindowMargins->{{Automatic, 50}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "FindDialog"->{
    Cell[1776, 53, 75, 1, 32, "Command",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[1854, 56, 249, 6, 31, "Usage",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2106, 64, 293, 6, 40, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2402, 72, 75, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2480, 75, 169, 4, 24, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2652, 81, 79, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2734, 84, 118, 1, 24, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2855, 87, 74, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2932, 90, 161, 4, 24, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3096, 96, 82, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3181, 99, 122, 1, 24, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3306, 102, 82, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3391, 105, 259, 6, 42, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3653, 113, 534, 15, 56, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[4190, 130, 283, 8, 24, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[4488, 141, 585, 18, 24, "Notes",
      CellTags->"FindDialog"]},
  "shortFormSearchID"->{
    Cell[1776, 53, 75, 1, 32, "Command",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[1854, 56, 249, 6, 31, "Usage",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2106, 64, 293, 6, 40, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2402, 72, 75, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2480, 75, 169, 4, 24, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2652, 81, 79, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2734, 84, 118, 1, 24, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2855, 87, 74, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[2932, 90, 161, 4, 24, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3096, 96, 82, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3181, 99, 122, 1, 24, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3306, 102, 82, 1, 25, "DialogItem",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3391, 105, 259, 6, 42, "IndentedText",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[3653, 113, 534, 15, 56, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}],
    Cell[4190, 130, 283, 8, 24, "Notes",
      CellTags->{"FindDialog", "shortFormSearchID"}]},
  "SetSelectionFind"->{
    Cell[5098, 163, 66, 1, 32, "Command",
      CellTags->"SetSelectionFind"],
    Cell[5167, 166, 228, 6, 31, "Usage",
      CellTags->"SetSelectionFind"],
    Cell[5398, 174, 252, 6, 40, "Notes",
      CellTags->"SetSelectionFind"],
    Cell[5665, 183, 591, 18, 24, "Notes",
      CellTags->"SetSelectionFind"]},
  "NotebookFindNext"->{
    Cell[6281, 205, 60, 1, 32, "Command",
      CellTags->"NotebookFindNext"],
    Cell[6344, 208, 209, 6, 31, "Usage",
      CellTags->"NotebookFindNext"],
    Cell[6556, 216, 266, 6, 40, "Notes",
      CellTags->"NotebookFindNext"],
    Cell[6825, 224, 223, 7, 24, "Notes",
      CellTags->"NotebookFindNext"]},
  "NtebookFindNext"->{
    Cell[7063, 234, 463, 16, 24, "Notes",
      CellTags->"NtebookFindNext"]},
  "NotebookFindPrevious"->{
    Cell[7551, 254, 68, 1, 32, "Command",
      CellTags->"NotebookFindPrevious"],
    Cell[7622, 257, 220, 6, 31, "Usage",
      CellTags->"NotebookFindPrevious"],
    Cell[7845, 265, 276, 8, 40, "Notes",
      CellTags->"NotebookFindPrevious"],
    Cell[8124, 275, 227, 7, 24, "Notes",
      CellTags->"NotebookFindPrevious"]},
  "SelectionCellTagsFind"->{
    Cell[8388, 287, 73, 1, 32, "Command",
      CellTags->"SelectionCellTagsFind"],
    Cell[8464, 290, 192, 5, 31, "Usage",
      CellTags->"SelectionCellTagsFind"],
    Cell[8659, 297, 211, 5, 40, "Notes",
      CellTags->"SelectionCellTagsFind"]},
  "Replace"->{
    Cell[8907, 307, 49, 1, 32, "Command",
      CellTags->"Replace"],
    Cell[8959, 310, 198, 6, 31, "Usage",
      CellTags->"Replace"],
    Cell[9172, 319, 582, 18, 24, "Notes",
      CellTags->"Replace"]},
  "ReplaceFind"->{
    Cell[9779, 341, 68, 1, 32, "Command",
      CellTags->"ReplaceFind"],
    Cell[9850, 344, 174, 5, 31, "Usage",
      CellTags->"ReplaceFind"],
    Cell[10027, 351, 308, 9, 40, "Notes",
      CellTags->"ReplaceFind"]},
  "ReplaceandFind"->{
    Cell[10350, 363, 649, 18, 24, "Notes",
      CellTags->"ReplaceandFind"]},
  "ReplaceAll"->{
    Cell[11024, 385, 56, 1, 32, "Command",
      CellTags->"ReplaceAll"],
    Cell[11083, 388, 250, 6, 47, "Usage",
      CellTags->"ReplaceAll"],
    Cell[11348, 397, 298, 9, 40, "Notes",
      CellTags->"ReplaceAll"]},
  "OpenSelectionParents"->{
    Cell[11671, 410, 68, 1, 32, "Command",
      CellTags->"OpenSelectionParents"],
    Cell[11742, 413, 181, 5, 31, "Usage",
      CellTags->"OpenSelectionParents"],
    Cell[11926, 420, 532, 11, 72, "Notes",
      CellTags->"OpenSelectionParents"]},
  "SelectionScroll"->{
    Cell[12495, 436, 69, 1, 32, "Command",
      CellTags->"SelectionScroll"],
    Cell[12567, 439, 200, 5, 31, "Usage",
      CellTags->"SelectionScroll"]},
  "HyperlinkGoBack"->{
    Cell[12804, 449, 57, 1, 32, "Command",
      CellTags->"HyperlinkGoBack"],
    Cell[12864, 452, 182, 5, 31, "Usage",
      CellTags->"HyperlinkGoBack"]},
  "CellTagsEditDialog"->{
    Cell[13083, 462, 92, 1, 32, "Command",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13178, 465, 281, 7, 47, "Usage",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13462, 474, 349, 6, 40, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13814, 482, 388, 9, 40, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14205, 493, 409, 12, 40, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14617, 507, 395, 9, 40, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[15027, 519, 593, 18, 24, "Notes",
      CellTags->"CellTagsEditDialog"]},
  "editKeysID"->{
    Cell[13083, 462, 92, 1, 32, "Command",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13178, 465, 281, 7, 47, "Usage",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13462, 474, 349, 6, 40, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[13814, 482, 388, 9, 40, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14205, 493, 409, 12, 40, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}],
    Cell[14617, 507, 395, 9, 40, "Notes",
      CellTags->{"CellTagsEditDialog", "editKeysID"}]},
  "MenuListTags"->{
    Cell[15645, 541, 56, 1, 32, "Command",
      CellTags->"MenuListTags"],
    Cell[15704, 544, 176, 5, 31, "Usage",
      CellTags->"MenuListTags"],
    Cell[15883, 551, 290, 6, 40, "Notes",
      CellTags->"MenuListTags"],
    Cell[16176, 559, 212, 7, 24, "Notes",
      CellTags->"MenuListTags"]},
  "ShowCellTags"->{
    Cell[16425, 571, 61, 1, 32, "Command",
      CellTags->"ShowCellTags"],
    Cell[16489, 574, 182, 5, 31, "Usage",
      CellTags->"ShowCellTags"]},
  "CellLabelsToTags"->{
    Cell[16708, 584, 78, 1, 32, "Command",
      CellTags->"CellLabelsToTags"],
    Cell[16789, 587, 229, 6, 31, "Usage",
      CellTags->"CellLabelsToTags"],
    Cell[17021, 595, 564, 20, 56, "Notes",
      CellTags->"CellLabelsToTags"],
    Cell[17588, 617, 241, 4, 40, "Notes",
      CellTags->"CellLabelsToTags"],
    Cell[17844, 624, 174, 4, 24, "Notes",
      CellTags->"CellLabelsToTags"]},
  "CreateIndexDialog"->{
    Cell[18043, 632, 88, 1, 32, "Command",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18134, 635, 199, 5, 31, "Usage",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18336, 642, 353, 7, 40, "Notes",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18692, 651, 196, 4, 24, "Notes",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18891, 657, 106, 1, 34, "Subsubsection",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19000, 660, 131, 2, 25, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19134, 664, 142, 2, 24, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19279, 668, 130, 2, 25, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19412, 672, 120, 1, 24, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19535, 675, 135, 2, 25, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19673, 679, 283, 8, 42, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19959, 689, 138, 2, 25, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[20100, 693, 274, 6, 42, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}]},
  "makeIndexDialogID"->{
    Cell[18043, 632, 88, 1, 32, "Command",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18134, 635, 199, 5, 31, "Usage",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18336, 642, 353, 7, 40, "Notes",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18692, 651, 196, 4, 24, "Notes",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[18891, 657, 106, 1, 34, "Subsubsection",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19000, 660, 131, 2, 25, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19134, 664, 142, 2, 24, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19279, 668, 130, 2, 25, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19412, 672, 120, 1, 24, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19535, 675, 135, 2, 25, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19673, 679, 283, 8, 42, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[19959, 689, 138, 2, 25, "DialogItem",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
    Cell[20100, 693, 274, 6, 42, "IndentedText",
      CellTags->{"CreateIndexDialog", "makeIndexDialogID"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"FindDialog", 21144, 723},
  {"shortFormSearchID", 22714, 756},
  {"SetSelectionFind", 24210, 787},
  {"NotebookFindNext", 24549, 796},
  {"NtebookFindNext", 24886, 805},
  {"NotebookFindPrevious", 24993, 808},
  {"SelectionCellTagsFind", 25352, 817},
  {"Replace", 25618, 824},
  {"ReplaceFind", 25847, 831},
  {"ReplaceandFind", 26091, 838},
  {"ReplaceAll", 26188, 841},
  {"OpenSelectionParents", 26437, 848},
  {"SelectionScroll", 26712, 855},
  {"HyperlinkGoBack", 26893, 860},
  {"CellTagsEditDialog", 27077, 865},
  {"editKeysID", 27762, 880},
  {"MenuListTags", 28367, 893},
  {"ShowCellTags", 28689, 902},
  {"CellLabelsToTags", 28865, 907},
  {"CreateIndexDialog", 29288, 918},
  {"makeIndexDialogID", 30710, 945}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 75, 1, 32, "Command",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[1854, 56, 249, 6, 31, "Usage",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2106, 64, 293, 6, 40, "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2402, 72, 75, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2480, 75, 169, 4, 24, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2652, 81, 79, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2734, 84, 118, 1, 24, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2855, 87, 74, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[2932, 90, 161, 4, 24, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3096, 96, 82, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3181, 99, 122, 1, 24, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3306, 102, 82, 1, 25, "DialogItem",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3391, 105, 259, 6, 42, "IndentedText",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[3653, 113, 534, 15, 56, "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}],
Cell[4190, 130, 283, 8, 24, "Notes",
  CellTags->{"FindDialog", "shortFormSearchID"}]
}, Open  ]],
Cell[4488, 141, 585, 18, 24, "Notes",
  CellTags->"FindDialog"],

Cell[CellGroupData[{
Cell[5098, 163, 66, 1, 32, "Command",
  CellTags->"SetSelectionFind"],
Cell[5167, 166, 228, 6, 31, "Usage",
  CellTags->"SetSelectionFind"],
Cell[5398, 174, 252, 6, 40, "Notes",
  CellTags->"SetSelectionFind"]
}, Open  ]],
Cell[5665, 183, 591, 18, 24, "Notes",
  CellTags->"SetSelectionFind"],

Cell[CellGroupData[{
Cell[6281, 205, 60, 1, 32, "Command",
  CellTags->"NotebookFindNext"],
Cell[6344, 208, 209, 6, 31, "Usage",
  CellTags->"NotebookFindNext"],
Cell[6556, 216, 266, 6, 40, "Notes",
  CellTags->"NotebookFindNext"],
Cell[6825, 224, 223, 7, 24, "Notes",
  CellTags->"NotebookFindNext"]
}, Open  ]],
Cell[7063, 234, 463, 16, 24, "Notes",
  CellTags->"NtebookFindNext"],

Cell[CellGroupData[{
Cell[7551, 254, 68, 1, 32, "Command",
  CellTags->"NotebookFindPrevious"],
Cell[7622, 257, 220, 6, 31, "Usage",
  CellTags->"NotebookFindPrevious"],
Cell[7845, 265, 276, 8, 40, "Notes",
  CellTags->"NotebookFindPrevious"],
Cell[8124, 275, 227, 7, 24, "Notes",
  CellTags->"NotebookFindPrevious"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8388, 287, 73, 1, 32, "Command",
  CellTags->"SelectionCellTagsFind"],
Cell[8464, 290, 192, 5, 31, "Usage",
  CellTags->"SelectionCellTagsFind"],
Cell[8659, 297, 211, 5, 40, "Notes",
  CellTags->"SelectionCellTagsFind"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8907, 307, 49, 1, 32, "Command",
  CellTags->"Replace"],
Cell[8959, 310, 198, 6, 31, "Usage",
  CellTags->"Replace"]
}, Open  ]],
Cell[9172, 319, 582, 18, 24, "Notes",
  CellTags->"Replace"],

Cell[CellGroupData[{
Cell[9779, 341, 68, 1, 32, "Command",
  CellTags->"ReplaceFind"],
Cell[9850, 344, 174, 5, 31, "Usage",
  CellTags->"ReplaceFind"],
Cell[10027, 351, 308, 9, 40, "Notes",
  CellTags->"ReplaceFind"]
}, Open  ]],
Cell[10350, 363, 649, 18, 24, "Notes",
  CellTags->"ReplaceandFind"],

Cell[CellGroupData[{
Cell[11024, 385, 56, 1, 32, "Command",
  CellTags->"ReplaceAll"],
Cell[11083, 388, 250, 6, 47, "Usage",
  CellTags->"ReplaceAll"]
}, Open  ]],
Cell[11348, 397, 298, 9, 40, "Notes",
  CellTags->"ReplaceAll"],

Cell[CellGroupData[{
Cell[11671, 410, 68, 1, 32, "Command",
  CellTags->"OpenSelectionParents"],
Cell[11742, 413, 181, 5, 31, "Usage",
  CellTags->"OpenSelectionParents"],
Cell[11926, 420, 532, 11, 72, "Notes",
  CellTags->"OpenSelectionParents"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12495, 436, 69, 1, 32, "Command",
  CellTags->"SelectionScroll"],
Cell[12567, 439, 200, 5, 31, "Usage",
  CellTags->"SelectionScroll"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12804, 449, 57, 1, 32, "Command",
  CellTags->"HyperlinkGoBack"],
Cell[12864, 452, 182, 5, 31, "Usage",
  CellTags->"HyperlinkGoBack"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13083, 462, 92, 1, 32, "Command",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[13178, 465, 281, 7, 47, "Usage",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[13462, 474, 349, 6, 40, "Notes",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[13814, 482, 388, 9, 40, "Notes",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[14205, 493, 409, 12, 40, "Notes",
  CellTags->{"CellTagsEditDialog", "editKeysID"}],
Cell[14617, 507, 395, 9, 40, "Notes",
  CellTags->{"CellTagsEditDialog", "editKeysID"}]
}, Open  ]],
Cell[15027, 519, 593, 18, 24, "Notes",
  CellTags->"CellTagsEditDialog"],

Cell[CellGroupData[{
Cell[15645, 541, 56, 1, 32, "Command",
  CellTags->"MenuListTags"],
Cell[15704, 544, 176, 5, 31, "Usage",
  CellTags->"MenuListTags"],
Cell[15883, 551, 290, 6, 40, "Notes",
  CellTags->"MenuListTags"],
Cell[16176, 559, 212, 7, 24, "Notes",
  CellTags->"MenuListTags"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16425, 571, 61, 1, 32, "Command",
  CellTags->"ShowCellTags"],
Cell[16489, 574, 182, 5, 31, "Usage",
  CellTags->"ShowCellTags"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16708, 584, 78, 1, 32, "Command",
  CellTags->"CellLabelsToTags"],
Cell[16789, 587, 229, 6, 31, "Usage",
  CellTags->"CellLabelsToTags"],
Cell[17021, 595, 564, 20, 56, "Notes",
  CellTags->"CellLabelsToTags"],
Cell[17588, 617, 241, 4, 40, "Notes",
  CellTags->"CellLabelsToTags"]
}, Open  ]],
Cell[17844, 624, 174, 4, 24, "Notes",
  CellTags->"CellLabelsToTags"],

Cell[CellGroupData[{
Cell[18043, 632, 88, 1, 32, "Command",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[18134, 635, 199, 5, 31, "Usage",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[18336, 642, 353, 7, 40, "Notes",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[18692, 651, 196, 4, 24, "Notes",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[18891, 657, 106, 1, 34, "Subsubsection",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19000, 660, 131, 2, 25, "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19134, 664, 142, 2, 24, "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19279, 668, 130, 2, 25, "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19412, 672, 120, 1, 24, "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19535, 675, 135, 2, 25, "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19673, 679, 283, 8, 42, "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[19959, 689, 138, 2, 25, "DialogItem",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}],
Cell[20100, 693, 274, 6, 42, "IndentedText",
  CellTags->{"CreateIndexDialog", "makeIndexDialogID"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

