(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28941,        973]*)
(*NotebookOutlinePosition[     43122,       1321]*)
(*  CellTagsIndexPosition[     42066,       1288]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style", "Command",
  CellTags->"MenuListStyles"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Style", "SR"],
  " assigns the specified style to the selected cell or text."
}], "Usage",
  CellTags->"MenuListStyles"],

Cell["\<\
\[FilledSmallSquare] To assign a style to one or more cells, select \
the cells and then choose the desired style name from the Style submenu.\
\>",
   "Notes",
  CellTags->"MenuListStyles"],

Cell[TextData[{
  "\[FilledSmallSquare] The cell styles listed in the Style submenu are \
defined in the style sheet assigned to your current notebook.",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " assigns a default style sheet called DefaultStyles to new notebooks. \n\
\[FilledSmallSquare] Styles can also be assigned to individual words or \
characters."
}], "Notes",
  CellTags->"MenuListStyles"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Style Sheet",
    ButtonData:>"Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  " and ",
  ButtonBox["Edit Style Sheet",
    ButtonData:>"Edit Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"MenuListStyles"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Other...", "SR"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "dialog box lets you type in a style name to be assigned to the selected \
cell or text (not all styles defined in a style sheet need to be listed in \
the Styles menu). Note that you can also assign cell options by typing the \
option setting in this dialog box. "
}], "Notes",
  CellTags->"MenuListStyles"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Screen Style Environment", "Command",
  CellTags->"MenuListScreenStyleEnvironments"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Screen Style Environment", "SR"],
  " determines which style environment to use for onscreen display."
}], "Usage",
  CellTags->"MenuListScreenStyleEnvironments"],

Cell[TextData[{
  "\[FilledSmallSquare] Notebook style sheets typically contain separate \
style definitions for printed versus onscreen formatting. There can be \
several screen environments: for example, one for working and one for giving \
a presentation.\n\[FilledSmallSquare] This command sets the option ",
  StyleBox["ScreenStyleEnvironment", "MR"],
  " on the selected notebook."
}], "Notes",
  CellTags->"MenuListScreenStyleEnvironments"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Printing Style Environment", "Command",
  CellTags->"MenuListPrintingStyleEnvironments"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Printing Style Environment", "SR"],
  " determines which style environment to use for printing."
}], "Usage",
  CellTags->"MenuListPrintingStyleEnvironments"],

Cell[TextData[{
  "\[FilledSmallSquare] Notebook style sheets typically contain separate \
style definitions for printed versus onscreen formatting. \n\
\[FilledSmallSquare] This command sets the option ",
  StyleBox["PrintingStyleEnvironment", "MR"],
  " on the selected notebook."
}], "Notes",
  CellTags->"MenuListPrintingStyleEnvironments"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show Expression", "Command",
  CellTags->"ToggleShowExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show Expression", "SR"],
  " toggles between expression and displayed form of a cell."
}], "Usage",
  CellTags->"ToggleShowExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] In expression form, you are seeing the underlying ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression as it would be saved in a file.\n\[FilledSmallSquare] You can \
edit the cell in either expression or display form, and when you toggle the \
form, the changes will be reflected in the other form.\n\[FilledSmallSquare] \
When editing in expression form, you must be careful to enter only \
syntactically correct expressions. If there is an error in the expression \
when you toggle back to display form, it will be reported, and the offending \
part of the expression will be selected."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ToggleShowExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["e", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["e", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["e", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ToggleShowExpression"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Style Sheet", "Command",
  CellTags->"MenuStyleSheet"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Style Sheet", "SR"],
  " ",
  "assigns the specified style sheet to the current notebook. "
}], "Usage",
  CellTags->"MenuStyleSheet"],

Cell[TextData[
"\[FilledSmallSquare] A check appears beside the style sheet currently \
assigned to the notebook."], "Notes",
  AspectRatioFixed->False,
  CellTags->"MenuStyleSheet"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " standard style notebooks are kept in SystemFiles/FrontEnd/StyleSheets. \
Style notebooks created by users can be put in \
Configuration/FrontEnd/StyleSheets.",
  " ",
  "Any style notebooks in these directories will automatically be listed in \
the Style Sheets submenu."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"MenuStyleSheet"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Other ", "SR"],
  "command opens a dialog box to",
  " ",
  "find style sheets not listed in the Style Sheet submenu.\n\
\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["StyleDefinitions", "MR"],
  " on the selected notebook."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"MenuStyleSheet"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["StyleSheet",
    ButtonData:>"What Is a Style Sheet?",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"MenuStyleSheet"],

Cell[CellGroupData[{

Cell["Edit Style Sheet...", "Command",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Edit Style Sheet", "SR"],
  " lets you edit the style definitions for the current notebook."
}], "Usage",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell["\<\
\[FilledSmallSquare] Open the style sheet and modify the cell \
styles you want to change. Style changes will be reflected in all notebooks \
that use the style sheet.
\[FilledSmallSquare] If the notebook is using a shared style sheet, a dialog \
box will appear giving the following choices:\
\>", "Notes",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell[TextData[StyleBox["Import Private Copy",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell["\<\
Copies the settings from the shared style sheet to a private style \
sheet just for this notebook. Any changes made to the style sheet will only \
affect this notebook.\
\>", "IndentedText",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell[TextData[StyleBox["Edit Shared Style Sheet",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell["\<\
Opens the shared version of the style sheet. Any changes will \
affect all notebooks that refer to this style sheet.\
\>", "IndentedText",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option Inspector...", "Command",
  CellTags->{"OptionsDialog", "styleInspectorDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Option Inspector", "SR"],
  " lets you view and set all option values for cells, notebooks, and global \
preferences."
}], "Usage",
  CellTags->{"OptionsDialog", "styleInspectorDialogID"}]
}, Open  ]],

Cell["\<\
\[FilledSmallSquare] The first pop-up menu (labeled \
\[OpenCurlyDoubleQuote]Show Option Values For\[CloseCurlyDoubleQuote]) lists \
global, notebook, and selection. This menu chooses the scope in which your \
options will take effect. Some options are dimmed when they do not apply to \
the scope you have chosen.\
\>", "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Global", "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Sets options for the front end generally.", "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Notebook", "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Sets options for the whole notebook.", "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Selection", "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["\<\
Sets options for the selected cells or for characters in a \
cell.\
\>", "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["\<\
\[FilledSmallSquare] The second pop-up menu lists options by \
category, alphabetically, and by text.\
\>", "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["\<\
\[FilledSmallSquare] The Lookup box finds the option you type in.\
\
\>", "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  " ",
  "Enter an option name, or part of its name."
}], "ItemizedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[TextData[{
  StyleBox["2.",
    FontWeight->"Bold"],
  " ",
  "Click Lookup, or press Return."
}], "ItemizedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["\<\
The Option Inspector goes to the first matching option. Click \
Lookup or press Return again to go to the next match.\
\>", "NotesList",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["\<\
\[FilledSmallSquare] Each line in the list of options gives the \
option name, followed by its current value. Change the option's value by \
choosing from the pop-up menu at the right, or by selecting the value itself \
and typing over it. A symbol in front of the option name indicates that the \
current value of the option is different from its default value. \
\>", 
  "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Front End Options",
    ButtonData:>"The Option Inspector",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["o", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["o", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["o", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[CellGroupData[{

Cell["Remove Options...", "Command",
  CellTags->"ClearCellOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Remove Options", "SR"],
  " removes all explicit option settings for the selected cell."
}], "Usage",
  CellTags->"ClearCellOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Remove Options", "SR"],
  " can be used to uniformly impose the cell's style on the cell contents.\n\
\[FilledSmallSquare] This command brings up a dialog box that enables you to \
choose whether option settings should be removed only at the cell level or \
recursively, within sub-parts of it. "
}], "Notes",
  CellTags->"ClearCellOptions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Font", "Command",
  CellTags->"MenuListFonts"],

Cell["\<\
\[FilledSmallSquare] This submenu lists all fonts currently \
installed in your computer system.\
\>", "Usage",
  CellTags->"MenuListFonts"],

Cell[TextData[{
  "\[FilledSmallSquare] A check beside a font name means that the selected \
characters or cells use that font.\n\[FilledSmallSquare] The commands in this \
submenu set the option ",
  StyleBox["FontFamily", "MR"],
  " on the selected cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"MenuListFonts"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["FontFamily",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"MenuListFonts"],

Cell[CellGroupData[{

Cell["Face", "Command",
  CellTags->"PlainFont"],

Cell["\<\
\[FilledSmallSquare] This submenu lists available font face \
variations (bold, italic, underline, and so on).\
\>", "Usage",
  CellTags->"PlainFont"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The commands in this submenu set the options ",
  StyleBox["FontWeight", "MR"],
  ", ",
  StyleBox["FontSlant", "MR"],
  ", ",
  StyleBox["FontTracking", "MR"],
  ", and ",
  StyleBox["FontVariations", "MR"],
  " on the selected cell object(s) or on text within a cell.\n\
\[FilledSmallSquare] See: ",
  ButtonBox["FontWeight",
    ButtonStyle->"OtherInformationLinkMR"],
  ",  ",
  ButtonBox["FontSlant",
    ButtonStyle->"OtherInformationLinkMR"],
  ",  ",
  ButtonBox["FontTracking",
    ButtonStyle->"OtherInformationLinkMR"],
  ", and ",
  ButtonBox["FontVariations",
    ButtonData:>"FontVariations->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"PlainFont"],

Cell[CellGroupData[{

Cell["Size", "Command",
  CellTags->"FontSize"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Size", "SR"],
  " assigns the specified point size to the selected text."
}], "Usage",
  CellTags->"FontSize"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["FontSize", "MR"],
  " on the selected cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"FontSize"],

Cell[TextData[{
  "\[FilledSmallSquare] You can choose from the font sizes displayed in the \
list or click the ",
  StyleBox["Other...",
    FontFamily->"Helvetica"],
  " submenu and type a point size in the dialog box that appears. \n\
\[FilledSmallSquare] See: ",
  ButtonBox["FontSize",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"FontSize"],

Cell[CellGroupData[{

Cell["Text Color", "Command",
  CellTags->"FontColor"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Text Color", "SR"],
  " assigns the specified color to the selected text."
}], "Usage",
  CellTags->"FontColor"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["FontColor", "MR"],
  " on the selected cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"FontColor"],

Cell[TextData[{
  "\[FilledSmallSquare] You can choose from the colors displayed in the list \
or click the ",
  StyleBox["Other...",
    FontFamily->"Helvetica"],
  " submenu and specify a color using the color selection dialog box. \n\
\[FilledSmallSquare] See: ",
  ButtonBox["FontColor",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"FontColor"],

Cell[CellGroupData[{

Cell["Background Color", "Command",
  CellTags->"BackGround"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background Color", "SR"],
  " assigns the specified background color to the cell."
}], "Usage",
  CellTags->"BackGround"],

Cell[TextData[{
  "\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["Background", "MR"],
  " on the selected cell object(s) or on text within a cell.\n\
\[FilledSmallSquare] You can choose from the colors displayed in the list or \
click the ",
  StyleBox["Other...",
    FontFamily->"Helvetica"],
  " submenu and specify a color using the color selection dialog box. \n\
\[FilledSmallSquare] ",
  StyleBox["Cell Gray Bo",
    FontFamily->"Helvetica"],
  StyleBox["x",
    FontFamily->"Helvetica"],
  " puts a cell frame around the cell with a light gray background. This \
command setting is a combination of the ",
  StyleBox["CellFrame", "MR"],
  " and ",
  StyleBox["Background", "MR"],
  " options.\n\[FilledSmallSquare] See: ",
  ButtonBox["CellFrame",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["Background",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"BackGround"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Choose Font...", "Command",
  CellTags->"Choose Font"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Choose Font",
    FontFamily->"Helvetica"],
  " brings up a dialog box that allows you to specify the font style and size \
for the selected text (Windows only)."
}], "Usage",
  CellTags->"Choose Font"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Text Alignment", "Command",
  CellTags->"TextAlignment"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Text Alignment", "SR"],
  " assigns the specified text alignment to the selected cell."
}], "Usage",
  CellTags->"TextAlignment"],

Cell[TextData[{
  "\[FilledSmallSquare] Alignment can be at any point along the width of each \
line of text, specified by a percentage: 25% is roughly in between \
left-aligned and centered, while 75% is roughly in between centered and \
right-aligned. Other alignment points can be specified using the",
  StyleBox[" ", "MR",
    FontFamily->"Times"],
  StyleBox["Option Inspector", "MR",
    FontFamily->"Times"],
  ".\n\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["TextAlignment", "MR"],
  " on the selected cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"TextAlignment"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Text Justification", "Command",
  CellTags->"TextJustification"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Text Justification", "SR"],
  " controls justification (word spacing) of wordwrapped cells."
}], "Usage",
  CellTags->"TextJustification"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Natural Spacing",
    FontFamily->"Helvetica"],
  " introduces no additional spacing, resulting in ragged margins."
}], "Notes",
  CellTags->"TextJustification"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Full Justification",
    FontFamily->"Helvetica"],
  " introduces enough additional spacing to each line to make it fill the \
full width of the column, resulting in flush margins. This is a commonly used \
style, but results in hard-to-read text."
}], "Notes",
  CellTags->"TextJustification"],

Cell[TextData[{
  "\[FilledSmallSquare] The other justification settings apply varying \
degrees of justification, resulting in less ragged, but not fully flush \
margins.\n\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["TextJustification", "MR"],
  " on the selected cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"TextJustification"]
}, Open  ]],

Cell[TextData[{
  "Word Wrapping ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell[CellGroupData[{

Cell["Don't Word Wrap", "Command",
  CellTags->"PageWidthDon't"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Don't Word Wrap", "SR"],
  " turns word wrapping off."
}], "Usage",
  CellTags->"PageWidthDon't"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] This command sets the option ",
  StyleBox["PageWidth", "MR"],
  " \[Rule] ",
  StyleBox["Infinity", "MR"],
  " on the selected cell object(s)."
}], "Notes",
  CellTags->"PageWidthDon't"],

Cell[CellGroupData[{

Cell["Wrap at Paper Width", "Command",
  CellTags->"PageWidthPaper"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Wrap at Paper Width", "SR"],
  " wraps lines at the width of the paper currently specified by the printing \
(Page Setup) settings."
}], "Usage",
  CellTags->"PageWidthPaper"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is normally used in the Printout style \
environment to make text fit the printed page.\n\[FilledSmallSquare] This \
command sets the option ",
  StyleBox["PageWidth", "MR"],
  " \[Rule] ",
  StyleBox["PaperWidth", "MR"],
  " on the selected cell object(s).\n\[FilledSmallSquare] See: ",
  ButtonBox["PageWidth",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"PageWidthPaper"],

Cell[CellGroupData[{

Cell["Wrap at Window Width", "Command",
  CellTags->"PageWidthWindow"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Wrap at Window Width", "SR"],
  " wraps lines at the width of the window containing the text."
}], "Usage",
  CellTags->"PageWidthWindow"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is normally used in the Working style \
environment to make text fit the current window width.\n\[FilledSmallSquare] \
This command sets the option ",
  StyleBox["PageWidth", "MR"],
  " \[Rule] ",
  StyleBox["WindowWidth", "MR"],
  " on the selected cell object(s).\n\[FilledSmallSquare] See: ",
  ButtonBox["PageWidth",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"PageWidthWindow"],

Cell[CellGroupData[{

Cell["Fixed Word Wrap Width", "Command",
  CellTags->"PageWidthFixed"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Fixed Word Wrap Width", "SR"],
  " locks down the current wordwrapping width so it won't change when you \
resize the window or change paper width."
}], "Usage",
  CellTags->"PageWidthFixed"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The wrapping width can also be adjusted manually \
using the ruler toolbar.\n\[FilledSmallSquare] This command sets the option ",
  
  StyleBox["PageWidth", "MR"],
  " on the selected cell object(s).\n\[FilledSmallSquare] See: ",
  ButtonBox["PageWidth",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"PageWidthFixed"],

Cell[CellGroupData[{

Cell["Cell Dingbat", "Command",
  CellTags->"CellDingbat"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Dingbat", "SR"],
  " attaches the specified character as a left-hanging dingbat on the \
selected cell(s)."
}], "Usage",
  CellTags->"CellDingbat"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The dingbat can be specified for a style and will \
then be displayed by all cells in that style.\n\[FilledSmallSquare] This \
command sets the option ",
  StyleBox["CellDingbat", "MR"],
  " on the selected cell object(s).\n\[FilledSmallSquare] See: ",
  ButtonBox["CellDingbat",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"CellDingbat"],

Cell[CellGroupData[{

Cell["Horizontal Lines", "Command",
  CellTags->"HorizontalLines"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Horizontal Lines", "SR"],
  " inserts a line of the specified thickness above or below the selected \
cell. "
}], "Usage",
  CellTags->"HorizontalLines"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] This command sets the option ",
  StyleBox["CellFrame", "MR"],
  " on the selected cell object(s).\n\[FilledSmallSquare] See: ",
  ButtonBox["CellFrame",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"HorizontalLines"],

Cell[CellGroupData[{

Cell["Show Ruler", "Command",
  CellTags->"RulerBar"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show Ruler", "SR"],
  " toggles the display of the ruler along the top of the notebook."
}], "Usage",
  CellTags->"RulerBar"],

Cell[TextData[{
  "\[FilledSmallSquare] Use the ruler to set the text margins of selected \
cells and set the indentation of cell names and keywords.\n\
\[FilledSmallSquare] This command sets the option ",
  StyleBox["WindowToolbars", "MR"],
  " \[Rule] ",
  StyleBox["{\"RulerBar\"}", "MR"],
  " on the selected notebook.\n\[FilledSmallSquare] See: ",
  ButtonBox["WindowToolBars",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"RulerBar"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show ToolBar", "Command",
  CellTags->"EditBar"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show ToolBar", "SR"],
  " toggles the display of the toolbar along the top of the notebook."
}], "Usage",
  TextJustification->0,
  CellTags->"EditBar"],

Cell[TextData[{
  "\[FilledSmallSquare] The toolbar displays the cell style of the selected \
cell and allows you to choose other cell styles. You can also use the toolbar \
to change the text alignment within a cell to flush left, centered, flush \
right, or justified.\n\[FilledSmallSquare] This command sets the option ",
  StyleBox["WindowToolbars", "MR"],
  " \[Rule] ",
  StyleBox["{\"EditBar\"}", "MR"],
  " on the selected notebook.\n\[FilledSmallSquare] See: ",
  ButtonBox["WindowToolBars",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  TextJustification->0,
  CellTags->"EditBar"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show Page Breaks", "Command",
  CellTags->"ShowPageBreaks"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show Page Breaks", "SR"],
  " calculates and displays page breaks on screen."
}], "Usage",
  CellTags->"ShowPageBreaks"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Page breaks that fall between cells are shown with a \
dashed line across the entire width of the window. Page breaks that fall \
inside a cell are shown by a dashed line over the width of the cell bracket.\n\
\[FilledSmallSquare] This command toggles the option ",
  StyleBox["ShowPageBreaks", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected notebook.\n\[FilledSmallSquare] See: ",
  ButtonBox["ShowPageBreaks",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  TextJustification->0,
  CellTags->"ShowPageBreaks"],

Cell[CellGroupData[{

Cell["Magnification", "Command",
  CellTags->"Magnification"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Magnification", "SR"],
  " changes the magnification of the notebook's contents."
}], "Usage",
  CellTags->"Magnification"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The magnification setting does not affect the size of \
printed output.\n\[FilledSmallSquare] In many situations, using the \
Presentation style environment is a better way of making text larger overall.\
\n\[FilledSmallSquare] This command sets the option ",
  StyleBox["Magnification", "MR"],
  " on the selected notebook.\n\[FilledSmallSquare] See: ",
  ButtonBox["Magnification",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  TextJustification->0,
  CellTags->"Magnification"]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{0, 1110}, {0, 746}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{587, 551},
WindowMargins->{{Automatic, 18}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MenuListStyles"->{
    Cell[1776, 53, 54, 1, 32, "Command",
      CellTags->"MenuListStyles"],
    Cell[1833, 56, 175, 5, 31, "Usage",
      CellTags->"MenuListStyles"],
    Cell[2011, 63, 200, 5, 40, "Notes",
      CellTags->"MenuListStyles"],
    Cell[2214, 70, 413, 9, 62, "Notes",
      CellTags->"MenuListStyles"],
    Cell[2630, 81, 317, 11, 24, "Notes",
      CellTags->"MenuListStyles"],
    Cell[2950, 94, 428, 10, 56, "Notes",
      CellTags->"MenuListStyles"]},
  "MenuListScreenStyleEnvironments"->{
    Cell[3415, 109, 90, 1, 32, "Command",
      CellTags->"MenuListScreenStyleEnvironments"],
    Cell[3508, 112, 217, 5, 31, "Usage",
      CellTags->"MenuListScreenStyleEnvironments"],
    Cell[3728, 119, 447, 8, 62, "Notes",
      CellTags->"MenuListScreenStyleEnvironments"]},
  "MenuListPrintingStyleEnvironments"->{
    Cell[4212, 132, 94, 1, 32, "Command",
      CellTags->"MenuListPrintingStyleEnvironments"],
    Cell[4309, 135, 213, 5, 31, "Usage",
      CellTags->"MenuListPrintingStyleEnvironments"],
    Cell[4525, 142, 344, 7, 46, "Notes",
      CellTags->"MenuListPrintingStyleEnvironments"]},
  "ToggleShowExpression"->{
    Cell[4906, 154, 70, 1, 32, "Command",
      CellTags->"ToggleShowExpression"],
    Cell[4979, 157, 190, 5, 31, "Usage",
      CellTags->"ToggleShowExpression"],
    Cell[5172, 164, 722, 13, 116, "Notes",
      CellTags->"ToggleShowExpression"],
    Cell[5897, 179, 655, 18, 24, "Notes",
      CellTags->"ToggleShowExpression"]},
  "MenuStyleSheet"->{
    Cell[6589, 202, 60, 1, 32, "Command",
      CellTags->"MenuStyleSheet"],
    Cell[6652, 205, 189, 6, 31, "Usage",
      CellTags->"MenuStyleSheet"],
    Cell[6844, 213, 182, 4, 24, "Notes",
      CellTags->"MenuStyleSheet"],
    Cell[7029, 219, 440, 12, 56, "Notes",
      CellTags->"MenuStyleSheet"],
    Cell[7472, 233, 386, 11, 46, "Notes",
      CellTags->"MenuStyleSheet"],
    Cell[7873, 247, 233, 8, 24, "Notes",
      CellTags->"MenuStyleSheet"]},
  "EditStyleDefinitions"->{
    Cell[8131, 259, 105, 1, 32, "Command",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8239, 262, 227, 5, 31, "Usage",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8469, 269, 384, 7, 62, "Notes",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8856, 278, 150, 2, 25, "DialogItem",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[9009, 282, 267, 5, 42, "IndentedText",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[9279, 289, 154, 2, 25, "DialogItem",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[9436, 293, 215, 4, 24, "IndentedText",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}]},
  "editingSharedStyleSheetID"->{
    Cell[8131, 259, 105, 1, 32, "Command",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8239, 262, 227, 5, 31, "Usage",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8469, 269, 384, 7, 62, "Notes",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8856, 278, 150, 2, 25, "DialogItem",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[9009, 282, 267, 5, 42, "IndentedText",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[9279, 289, 154, 2, 25, "DialogItem",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[9436, 293, 215, 4, 24, "IndentedText",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}]},
  "OptionsDialog"->{
    Cell[9688, 302, 95, 1, 32, "Command",
      CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
    Cell[9786, 305, 247, 6, 31, "Usage",
      CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
    Cell[10048, 314, 396, 7, 56, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10447, 323, 85, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10535, 326, 122, 1, 24, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10660, 329, 87, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10750, 332, 117, 1, 24, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10870, 335, 88, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10961, 338, 155, 4, 24, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11119, 344, 183, 4, 24, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11305, 350, 149, 4, 24, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11457, 356, 188, 6, 26, "ItemizedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11648, 364, 176, 6, 26, "ItemizedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11827, 372, 203, 4, 26, "NotesList",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12033, 378, 448, 8, 56, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12484, 388, 238, 7, 24, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12725, 397, 676, 18, 24, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}]},
  "styleInspectorDialogID"->{
    Cell[9688, 302, 95, 1, 32, "Command",
      CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
    Cell[9786, 305, 247, 6, 31, "Usage",
      CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
    Cell[10048, 314, 396, 7, 56, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10447, 323, 85, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10535, 326, 122, 1, 24, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10660, 329, 87, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10750, 332, 117, 1, 24, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10870, 335, 88, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10961, 338, 155, 4, 24, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11119, 344, 183, 4, 24, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11305, 350, 149, 4, 24, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11457, 356, 188, 6, 26, "ItemizedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11648, 364, 176, 6, 26, "ItemizedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11827, 372, 203, 4, 26, "NotesList",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12033, 378, 448, 8, 56, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12484, 388, 238, 7, 24, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12725, 397, 676, 18, 24, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}]},
  "ClearCellOptions"->{
    Cell[13426, 419, 68, 1, 32, "Command",
      CellTags->"ClearCellOptions"],
    Cell[13497, 422, 188, 5, 31, "Usage",
      CellTags->"ClearCellOptions"],
    Cell[13688, 429, 396, 8, 62, "Notes",
      CellTags->"ClearCellOptions"]},
  "MenuListFonts"->{
    Cell[14121, 442, 52, 1, 32, "Command",
      CellTags->"MenuListFonts"],
    Cell[14176, 445, 150, 4, 31, "Usage",
      CellTags->"MenuListFonts"],
    Cell[14329, 451, 334, 7, 46, "Notes",
      CellTags->"MenuListFonts"],
    Cell[14678, 461, 165, 6, 24, "Notes",
      CellTags->"MenuListFonts"]},
  "PlainFont"->{
    Cell[14868, 471, 48, 1, 32, "Command",
      CellTags->"PlainFont"],
    Cell[14919, 474, 160, 4, 31, "Usage",
      CellTags->"PlainFont"],
    Cell[15094, 481, 741, 25, 62, "Notes",
      CellTags->"PlainFont"]},
  "FontSize"->{
    Cell[15860, 510, 47, 1, 32, "Command",
      CellTags->"FontSize"],
    Cell[15910, 513, 165, 5, 31, "Usage",
      CellTags->"FontSize"],
    Cell[16090, 521, 215, 5, 24, "Notes",
      CellTags->"FontSize"],
    Cell[16308, 528, 377, 11, 62, "Notes",
      CellTags->"FontSize"]},
  "FontColor"->{
    Cell[16710, 543, 54, 1, 32, "Command",
      CellTags->"FontColor"],
    Cell[16767, 546, 167, 5, 31, "Usage",
      CellTags->"FontColor"],
    Cell[16949, 554, 217, 5, 24, "Notes",
      CellTags->"FontColor"],
    Cell[17169, 561, 379, 11, 62, "Notes",
      CellTags->"FontColor"]},
  "BackGround"->{
    Cell[17573, 576, 61, 1, 32, "Command",
      CellTags->"BackGround"],
    Cell[17637, 579, 176, 5, 31, "Usage",
      CellTags->"BackGround"],
    Cell[17816, 586, 955, 27, 122, "Notes",
      CellTags->"BackGround"]},
  "Choose Font"->{
    Cell[18808, 618, 60, 1, 32, "Command",
      CellTags->"Choose Font"],
    Cell[18871, 621, 257, 7, 47, "Usage",
      CellTags->"Choose Font"]},
  "TextAlignment"->{
    Cell[19165, 633, 62, 1, 32, "Command",
      CellTags->"TextAlignment"],
    Cell[19230, 636, 184, 5, 31, "Usage",
      CellTags->"TextAlignment"],
    Cell[19417, 643, 629, 13, 94, "Notes",
      CellTags->"TextAlignment"]},
  "TextJustification"->{
    Cell[20083, 661, 70, 1, 32, "Command",
      CellTags->"TextJustification"],
    Cell[20156, 664, 193, 5, 31, "Usage",
      CellTags->"TextJustification"],
    Cell[20352, 671, 216, 6, 24, "Notes",
      CellTags->"TextJustification"],
    Cell[20571, 679, 349, 8, 40, "Notes",
      CellTags->"TextJustification"],
    Cell[20923, 689, 387, 7, 78, "Notes",
      CellTags->"TextJustification"]},
  "PageWidthDon't"->{
    Cell[21447, 707, 64, 1, 32, "Command",
      CellTags->"PageWidthDon't"],
    Cell[21514, 710, 152, 5, 31, "Usage",
      CellTags->"PageWidthDon't"],
    Cell[21681, 718, 227, 7, 24, "Notes",
      CellTags->"PageWidthDon't"]},
  "PageWidthPaper"->{
    Cell[21933, 729, 68, 1, 32, "Command",
      CellTags->"PageWidthPaper"],
    Cell[22004, 732, 230, 6, 47, "Usage",
      CellTags->"PageWidthPaper"],
    Cell[22249, 741, 458, 12, 68, "Notes",
      CellTags->"PageWidthPaper"]},
  "PageWidthWindow"->{
    Cell[22732, 757, 70, 1, 32, "Command",
      CellTags->"PageWidthWindow"],
    Cell[22805, 760, 193, 5, 31, "Usage",
      CellTags->"PageWidthWindow"],
    Cell[23013, 768, 467, 12, 68, "Notes",
      CellTags->"PageWidthWindow"]},
  "PageWidthFixed"->{
    Cell[23505, 784, 70, 1, 32, "Command",
      CellTags->"PageWidthFixed"],
    Cell[23578, 787, 246, 6, 47, "Usage",
      CellTags->"PageWidthFixed"],
    Cell[23839, 796, 387, 10, 68, "Notes",
      CellTags->"PageWidthFixed"]},
  "CellDingbat"->{
    Cell[24251, 810, 58, 1, 32, "Command",
      CellTags->"CellDingbat"],
    Cell[24312, 813, 207, 6, 31, "Usage",
      CellTags->"CellDingbat"],
    Cell[24534, 822, 409, 10, 68, "Notes",
      CellTags->"CellDingbat"]},
  "HorizontalLines"->{
    Cell[24968, 836, 66, 1, 32, "Command",
      CellTags->"HorizontalLines"],
    Cell[25037, 839, 208, 6, 31, "Usage",
      CellTags->"HorizontalLines"],
    Cell[25260, 848, 287, 8, 46, "Notes",
      CellTags->"HorizontalLines"]},
  "RulerBar"->{
    Cell[25572, 860, 53, 1, 32, "Command",
      CellTags->"RulerBar"],
    Cell[25628, 863, 180, 5, 31, "Usage",
      CellTags->"RulerBar"],
    Cell[25811, 870, 469, 12, 68, "Notes",
      CellTags->"RulerBar"]},
  "EditBar"->{
    Cell[26317, 887, 54, 1, 32, "Command",
      CellTags->"EditBar"],
    Cell[26374, 890, 207, 6, 31, "Usage",
      CellTags->"EditBar"],
    Cell[26584, 898, 610, 14, 84, "Notes",
      CellTags->"EditBar"]},
  "ShowPageBreaks"->{
    Cell[27231, 917, 65, 1, 32, "Command",
      CellTags->"ShowPageBreaks"],
    Cell[27299, 920, 175, 5, 31, "Usage",
      CellTags->"ShowPageBreaks"],
    Cell[27489, 928, 627, 16, 84, "Notes",
      CellTags->"ShowPageBreaks"]},
  "Magnification"->{
    Cell[28141, 948, 61, 1, 32, "Command",
      CellTags->"Magnification"],
    Cell[28205, 951, 178, 5, 31, "Usage",
      CellTags->"Magnification"],
    Cell[28398, 959, 539, 12, 90, "Notes",
      CellTags->"Magnification"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MenuListStyles", 29684, 994},
  {"MenuListScreenStyleEnvironments", 30177, 1007},
  {"MenuListPrintingStyleEnvironments", 30499, 1014},
  {"ToggleShowExpression", 30814, 1021},
  {"MenuStyleSheet", 31169, 1030},
  {"EditStyleDefinitions", 31657, 1043},
  {"editingSharedStyleSheetID", 32508, 1058},
  {"OptionsDialog", 33347, 1073},
  {"styleInspectorDialogID", 35197, 1108},
  {"ClearCellOptions", 37041, 1143},
  {"MenuListFonts", 37301, 1150},
  {"PlainFont", 37624, 1159},
  {"FontSize", 37859, 1166},
  {"FontColor", 38163, 1175},
  {"BackGround", 38472, 1184},
  {"Choose Font", 38714, 1191},
  {"TextAlignment", 38885, 1196},
  {"TextJustification", 39141, 1203},
  {"PageWidthDon't", 39565, 1214},
  {"PageWidthPaper", 39820, 1221},
  {"PageWidthWindow", 40077, 1228},
  {"PageWidthFixed", 40336, 1235},
  {"CellDingbat", 40589, 1242},
  {"HorizontalLines", 40837, 1249},
  {"RulerBar", 41089, 1256},
  {"EditBar", 41320, 1263},
  {"ShowPageBreaks", 41555, 1270},
  {"Magnification", 41810, 1277}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 54, 1, 32, "Command",
  CellTags->"MenuListStyles"],
Cell[1833, 56, 175, 5, 31, "Usage",
  CellTags->"MenuListStyles"],
Cell[2011, 63, 200, 5, 40, "Notes",
  CellTags->"MenuListStyles"],
Cell[2214, 70, 413, 9, 62, "Notes",
  CellTags->"MenuListStyles"],
Cell[2630, 81, 317, 11, 24, "Notes",
  CellTags->"MenuListStyles"],
Cell[2950, 94, 428, 10, 56, "Notes",
  CellTags->"MenuListStyles"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3415, 109, 90, 1, 32, "Command",
  CellTags->"MenuListScreenStyleEnvironments"],
Cell[3508, 112, 217, 5, 31, "Usage",
  CellTags->"MenuListScreenStyleEnvironments"],
Cell[3728, 119, 447, 8, 62, "Notes",
  CellTags->"MenuListScreenStyleEnvironments"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4212, 132, 94, 1, 32, "Command",
  CellTags->"MenuListPrintingStyleEnvironments"],
Cell[4309, 135, 213, 5, 31, "Usage",
  CellTags->"MenuListPrintingStyleEnvironments"],
Cell[4525, 142, 344, 7, 46, "Notes",
  CellTags->"MenuListPrintingStyleEnvironments"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4906, 154, 70, 1, 32, "Command",
  CellTags->"ToggleShowExpression"],
Cell[4979, 157, 190, 5, 31, "Usage",
  CellTags->"ToggleShowExpression"],
Cell[5172, 164, 722, 13, 116, "Notes",
  CellTags->"ToggleShowExpression"],
Cell[5897, 179, 655, 18, 24, "Notes",
  CellTags->"ToggleShowExpression"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6589, 202, 60, 1, 32, "Command",
  CellTags->"MenuStyleSheet"],
Cell[6652, 205, 189, 6, 31, "Usage",
  CellTags->"MenuStyleSheet"],
Cell[6844, 213, 182, 4, 24, "Notes",
  CellTags->"MenuStyleSheet"],
Cell[7029, 219, 440, 12, 56, "Notes",
  CellTags->"MenuStyleSheet"],
Cell[7472, 233, 386, 11, 46, "Notes",
  CellTags->"MenuStyleSheet"]
}, Open  ]],
Cell[7873, 247, 233, 8, 24, "Notes",
  CellTags->"MenuStyleSheet"],

Cell[CellGroupData[{
Cell[8131, 259, 105, 1, 32, "Command",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[8239, 262, 227, 5, 31, "Usage",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[8469, 269, 384, 7, 62, "Notes",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[8856, 278, 150, 2, 25, "DialogItem",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[9009, 282, 267, 5, 42, "IndentedText",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[9279, 289, 154, 2, 25, "DialogItem",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[9436, 293, 215, 4, 24, "IndentedText",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9688, 302, 95, 1, 32, "Command",
  CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
Cell[9786, 305, 247, 6, 31, "Usage",
  CellTags->{"OptionsDialog", "styleInspectorDialogID"}]
}, Open  ]],
Cell[10048, 314, 396, 7, 56, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[10447, 323, 85, 1, 25, "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[10535, 326, 122, 1, 24, "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[10660, 329, 87, 1, 25, "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[10750, 332, 117, 1, 24, "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[10870, 335, 88, 1, 25, "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[10961, 338, 155, 4, 24, "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11119, 344, 183, 4, 24, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11305, 350, 149, 4, 24, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11457, 356, 188, 6, 26, "ItemizedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11648, 364, 176, 6, 26, "ItemizedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11827, 372, 203, 4, 26, "NotesList",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[12033, 378, 448, 8, 56, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[12484, 388, 238, 7, 24, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[12725, 397, 676, 18, 24, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[CellGroupData[{
Cell[13426, 419, 68, 1, 32, "Command",
  CellTags->"ClearCellOptions"],
Cell[13497, 422, 188, 5, 31, "Usage",
  CellTags->"ClearCellOptions"],
Cell[13688, 429, 396, 8, 62, "Notes",
  CellTags->"ClearCellOptions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14121, 442, 52, 1, 32, "Command",
  CellTags->"MenuListFonts"],
Cell[14176, 445, 150, 4, 31, "Usage",
  CellTags->"MenuListFonts"],
Cell[14329, 451, 334, 7, 46, "Notes",
  CellTags->"MenuListFonts"]
}, Open  ]],
Cell[14678, 461, 165, 6, 24, "Notes",
  CellTags->"MenuListFonts"],

Cell[CellGroupData[{
Cell[14868, 471, 48, 1, 32, "Command",
  CellTags->"PlainFont"],
Cell[14919, 474, 160, 4, 31, "Usage",
  CellTags->"PlainFont"]
}, Open  ]],
Cell[15094, 481, 741, 25, 62, "Notes",
  CellTags->"PlainFont"],

Cell[CellGroupData[{
Cell[15860, 510, 47, 1, 32, "Command",
  CellTags->"FontSize"],
Cell[15910, 513, 165, 5, 31, "Usage",
  CellTags->"FontSize"]
}, Open  ]],
Cell[16090, 521, 215, 5, 24, "Notes",
  CellTags->"FontSize"],
Cell[16308, 528, 377, 11, 62, "Notes",
  CellTags->"FontSize"],

Cell[CellGroupData[{
Cell[16710, 543, 54, 1, 32, "Command",
  CellTags->"FontColor"],
Cell[16767, 546, 167, 5, 31, "Usage",
  CellTags->"FontColor"]
}, Open  ]],
Cell[16949, 554, 217, 5, 24, "Notes",
  CellTags->"FontColor"],
Cell[17169, 561, 379, 11, 62, "Notes",
  CellTags->"FontColor"],

Cell[CellGroupData[{
Cell[17573, 576, 61, 1, 32, "Command",
  CellTags->"BackGround"],
Cell[17637, 579, 176, 5, 31, "Usage",
  CellTags->"BackGround"],
Cell[17816, 586, 955, 27, 122, "Notes",
  CellTags->"BackGround"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18808, 618, 60, 1, 32, "Command",
  CellTags->"Choose Font"],
Cell[18871, 621, 257, 7, 47, "Usage",
  CellTags->"Choose Font"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19165, 633, 62, 1, 32, "Command",
  CellTags->"TextAlignment"],
Cell[19230, 636, 184, 5, 31, "Usage",
  CellTags->"TextAlignment"],
Cell[19417, 643, 629, 13, 94, "Notes",
  CellTags->"TextAlignment"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20083, 661, 70, 1, 32, "Command",
  CellTags->"TextJustification"],
Cell[20156, 664, 193, 5, 31, "Usage",
  CellTags->"TextJustification"],
Cell[20352, 671, 216, 6, 24, "Notes",
  CellTags->"TextJustification"],
Cell[20571, 679, 349, 8, 40, "Notes",
  CellTags->"TextJustification"],
Cell[20923, 689, 387, 7, 78, "Notes",
  CellTags->"TextJustification"]
}, Open  ]],
Cell[21325, 699, 97, 4, 52, "Section"],

Cell[CellGroupData[{
Cell[21447, 707, 64, 1, 32, "Command",
  CellTags->"PageWidthDon't"],
Cell[21514, 710, 152, 5, 31, "Usage",
  CellTags->"PageWidthDon't"]
}, Open  ]],
Cell[21681, 718, 227, 7, 24, "Notes",
  CellTags->"PageWidthDon't"],

Cell[CellGroupData[{
Cell[21933, 729, 68, 1, 32, "Command",
  CellTags->"PageWidthPaper"],
Cell[22004, 732, 230, 6, 47, "Usage",
  CellTags->"PageWidthPaper"]
}, Open  ]],
Cell[22249, 741, 458, 12, 68, "Notes",
  CellTags->"PageWidthPaper"],

Cell[CellGroupData[{
Cell[22732, 757, 70, 1, 32, "Command",
  CellTags->"PageWidthWindow"],
Cell[22805, 760, 193, 5, 31, "Usage",
  CellTags->"PageWidthWindow"]
}, Open  ]],
Cell[23013, 768, 467, 12, 68, "Notes",
  CellTags->"PageWidthWindow"],

Cell[CellGroupData[{
Cell[23505, 784, 70, 1, 32, "Command",
  CellTags->"PageWidthFixed"],
Cell[23578, 787, 246, 6, 47, "Usage",
  CellTags->"PageWidthFixed"]
}, Open  ]],
Cell[23839, 796, 387, 10, 68, "Notes",
  CellTags->"PageWidthFixed"],

Cell[CellGroupData[{
Cell[24251, 810, 58, 1, 32, "Command",
  CellTags->"CellDingbat"],
Cell[24312, 813, 207, 6, 31, "Usage",
  CellTags->"CellDingbat"]
}, Open  ]],
Cell[24534, 822, 409, 10, 68, "Notes",
  CellTags->"CellDingbat"],

Cell[CellGroupData[{
Cell[24968, 836, 66, 1, 32, "Command",
  CellTags->"HorizontalLines"],
Cell[25037, 839, 208, 6, 31, "Usage",
  CellTags->"HorizontalLines"]
}, Open  ]],
Cell[25260, 848, 287, 8, 46, "Notes",
  CellTags->"HorizontalLines"],

Cell[CellGroupData[{
Cell[25572, 860, 53, 1, 32, "Command",
  CellTags->"RulerBar"],
Cell[25628, 863, 180, 5, 31, "Usage",
  CellTags->"RulerBar"],
Cell[25811, 870, 469, 12, 68, "Notes",
  CellTags->"RulerBar"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26317, 887, 54, 1, 32, "Command",
  CellTags->"EditBar"],
Cell[26374, 890, 207, 6, 31, "Usage",
  CellTags->"EditBar"],
Cell[26584, 898, 610, 14, 84, "Notes",
  CellTags->"EditBar"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27231, 917, 65, 1, 32, "Command",
  CellTags->"ShowPageBreaks"],
Cell[27299, 920, 175, 5, 31, "Usage",
  CellTags->"ShowPageBreaks"]
}, Open  ]],
Cell[27489, 928, 627, 16, 84, "Notes",
  CellTags->"ShowPageBreaks"],

Cell[CellGroupData[{
Cell[28141, 948, 61, 1, 32, "Command",
  CellTags->"Magnification"],
Cell[28205, 951, 178, 5, 31, "Usage",
  CellTags->"Magnification"]
}, Open  ]],
Cell[28398, 959, 539, 12, 90, "Notes",
  CellTags->"Magnification"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

