(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    178023,       6523]*)
(*NotebookOutlinePosition[    243886,       8268]*)
(*  CellTagsIndexPosition[    238258,       8108]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Front End Tokens", "Section"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end supports a set of commands called front end tokens that allow \
you to perform actions such as opening or closing a notebook, that are \
typically carried out using menu items. Using front end tokens, you can ",
  StyleBox["control the behavior of the front end in an automated manner from \
the kernel. Front end tokens are, therefore, useful when writing programs to \
manipulate notebooks. ",
    FontFamily->"Times New Roman"]
}], "Text",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  "There is a front end token correpsonding to most common menu commands. For \
example, the ",
  StyleBox["\"New\"",
    FontFamily->"Courier"],
  " and ",
  StyleBox["\"Paste\"",
    FontFamily->"Courier"],
  " front end tokens correspond to the ",
  StyleBox["File \[RightTriangle] New",
    FontFamily->"Helvetica"],
  " and ",
  StyleBox["Edit \[RightTriangle] Paste",
    FontFamily->"Helvetica"],
  " menu commands, respectively. There are also a small number of front end \
tokens that do not correspond to a specific menu command. "
}], "Text",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  "You can call front end tokens by using a combination of the two commands \
",
  StyleBox["FrontEndToken", "MR"],
  " and ",
  StyleBox["FrontEndExecute", "MR"],
  StyleBox[". ", "MR",
    FontFamily->"Times New Roman"],
  StyleBox["FrontEndToken", "MR"],
  StyleBox[" identifies its argument as a front end token. ", "MR",
    FontFamily->"Times New Roman"],
  StyleBox["FrontEndExecute", "MR"],
  StyleBox[" is a kernel command that sends its argument to the front end for \
execution. For example, the following command tells the front end to create a \
new notebook. ", "MR",
    FontFamily->"Times New Roman"]
}], "Text",
  CellTags->"FrontEndTokenIntro"],

Cell[BoxData[
    \(FrontEndExecute[FrontEndToken["\<New\>"]]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  "Both ",
  StyleBox["FrontEndToken", "MR"],
  " and ",
  StyleBox["FrontEndExecute", "MR"],
  " accept a list as arguments, allowing you to execute multiple tokens in a \
single evaluation. In the following example, the ",
  StyleBox["Map", "MR"],
  " function is used to apply ",
  StyleBox["FrontEndToken",
    FontFamily->"Courier"],
  " to a list of two front end tokens. When you evaluate this command, the \
front end first creates a new notebook and then pastes the contents of the \
clipboard into that notebook.  "
}], "Text",
  CellTags->"FrontEndTokenIntro"],

Cell[BoxData[
    \(FrontEndExecute[
      Map[FrontEndToken, \ {"\<New\>", \ "\<Paste\>"}]]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"FrontEndTokenIntro"],

Cell[CellGroupData[{

Cell["Types of Front End Tokens ", "Subsubsection",
  CellTags->"FrontEndTokenIntro"],

Cell["\<\
Front end tokens are classified into two groups\[LongDash]simple \
tokens and compound tokens (also called tokens with parameters). Simple \
tokens perform a simple default action while compound tokens have variable \
parameters that can be used to modify some aspect of the token's \
behavior.\
\>", "Text",
  CellTags->"FrontEndTokenIntro"]
}, Closed]],

Cell[CellGroupData[{

Cell["Simple Tokens", "SubsubsectionIcon",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  "Simple tokens require ",
  StyleBox["FrontEndToken", "MR"],
  " to have one or two arguments. If ",
  StyleBox["FrontEndToken", "MR"],
  " has one argument, the token will operate on the current notebook. If ",
  StyleBox["FrontEndToken", "MR"],
  " has two arguments, the first argument must be a ",
  StyleBox["NotebookObject", "MR"],
  ", and the second the desired front end token."
}], "Text",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  "We already saw an example using \"",
  StyleBox["New", "MR"],
  "\" in the Introduction. Here, we use \"",
  StyleBox["Save", "MR"],
  "\" to save the current notebook using ",
  StyleBox["FrontEndTokenExecute", "MR"],
  "."
}], "Text",
  CellTags->"FrontEndTokenIntro"],

Cell[BoxData[
    \(FrontEndExecute[FrontEndToken["\<Save\>"]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  "To save to some other notebook, you can use the two-argument form of ",
  StyleBox["FrontEndTokenExecute", "MR"],
  ". In the two-argument form, the first argument is a  ",
  ButtonBox["NotebookObject",
    ButtonData:>{"NotebookObject"},
    ButtonStyle->"RefGuideLink"],
  " corresponding to the notebook containing the current evaluation, and the \
second argument is the front end token."
}], "Text",
  CellTags->"FrontEndTokenIntro"],

Cell[BoxData[
    \(FrontEndExecute[
      FrontEndToken[FrontEnd`EvaluationNotebook[], \ "\<Save\>"]]\)], "Input",\

  CellLabel->"In[3]:=",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  StyleBox["Note:",
    FontWeight->"Bold"],
  " You can also execute a simple front end token by using the command ",
  StyleBox["FrontEndTokenExecute[", "MR"],
  StyleBox["token",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  ". This is equivalent to ",
  StyleBox["FrontEndExecute[FrontEndToken[",
    FontFamily->"Courier"],
  StyleBox["token",
    FontSlant->"Italic"],
  StyleBox["]]",
    FontFamily->"Courier"],
  ". The shorter form is more convenient, but it does not allow you to \
execute compound tokens. "
}], "Text",
  CellTags->"FrontEndTokenIntro"]
}, Closed]],

Cell[CellGroupData[{

Cell["Compound Tokens", "SubsubsectionIcon",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  "Compound tokens carry variable parameters that control some aspect of \
their behavior. Tokens of this type must be called using the three-argument \
form of ",
  StyleBox["FrontEndToken", "MR"],
  StyleBox[" ", "MR",
    FontFamily->"Times New Roman"],
  StyleBox["a",
    FontFamily->"Times New Roman"],
  "nd then sent to the front end with ",
  StyleBox["FrontEndExecute", "MR"],
  ". In the three-argument form of ",
  StyleBox["FrontEndToken", "MR"],
  ", the first argument is the target notebook object, the second is the \
token, and the third is the value of the token parameter. For example, this \
command uses the token \"",
  StyleBox["SaveRenameSpecial", "MR"],
  "\" to save the selected notebook as plain text."
}], "Text",
  CellTags->"FrontEndTokenIntro"],

Cell[BoxData[
    \(FrontEndExecute[{FrontEndToken[
          FrontEnd`SelectedNotebook[], \ "\<SaveRenameSpecial\>", \ \
"\<Text\>"]}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"FrontEndTokenIntro"],

Cell[TextData[{
  "When using tokens that require parameters, you must always include the \
target notebook object as the first argument for ",
  StyleBox["FrontEndToken", "MR"],
  ". If you do not specify the target notebook, you will get an error \
message."
}], "Text",
  CellTags->"FrontEndTokenIntro"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["List of Front End Tokens", "Subsection"],

Cell["\<\
This is a list of front end tokens organized by their \
correspondence to menu commands. Front end tokens that do not directly \
correspond to menu commands are listed in alphabetical order in the \
Miscellaneous category.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["File", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"New\"", "ObjectName",
  CellTags->"New"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["New", "MR"],
  "\" is a front end token that creates a new notebook. "
}], "Usage",
  CellTags->"New"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] New",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"New"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"New"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Open\"", "ObjectName",
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Open", "MR"],
  "\" is a front end token that brings up the file browse dialog box for \
opening an existing file. "
}], "Usage",
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Open",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Open"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Close\"", "ObjectName",
  CellTags->"Close"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Close", "MR"],
  "\" is a front end token that closes the currently selected notebook."
}], "Usage",
  CellTags->"Close"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Close",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Close"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Close"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Save\"", "ObjectName",
  CellTags->"Save"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Save", "MR"],
  "\" is a front end token that saves the currently selected notebook."
}], "Usage",
  CellTags->"Save"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Save",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Save"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Save"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SaveRename\"", "ObjectName",
  CellTags->"SaveRename"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SaveRename", "MR"],
  "\" is a front end token that brings up the dialog box for saving a file."
}], "Usage",
  CellTags->"SaveRename"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Save As",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SaveRename"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SaveRename"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SaveRenameSpecial\"", "ObjectName",
  CellTags->"SaveRenameSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SaveRenameSpecial", "MR"],
  "\" is a front end token that saves the notebook in a specified \
non-notebook format."
}], "Usage",
  CellTags->"SaveRenameSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Save As Special",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SaveRenameSpecial"],

Cell["\<\
\[FilledSmallSquare] This token has a parameter that can take one \
of the following values:\
\>", "Notes",
  CellTags->"SaveRenameSpecial"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"V20Notebook\"\>",
                    "MR"], 
                  TraditionalForm]]], \(pre\ Version\ 3\ format\ notebook\ \
file\)},
          {Cell[BoxData[
                FormBox[
                  StyleBox["Text",
                    "MR"], TraditionalForm]]], 
            RowBox[{"plain", " ", "text", " ", "in", " ", 
              StyleBox["$SystemCharacterEncoding",
                "MR"]}]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["CellExpression",
                    "MR"], TraditionalForm]]], 
            RowBox[{"one", " ", "or", " ", "more", " ", 
              StyleBox[\(Cell[]\),
                "MR"], "expressions"}]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NotebookExpression\"\>",
                      "MR"], " "}], TraditionalForm]]], 
            RowBox[{
              StyleBox["a",
                FontSlant->"Plain"], " ", "notebook", " ", "expression"}]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Package\"\>",
                      "MR"], " "}], TraditionalForm]]], 
            RowBox[{
              StyleBox["a",
                FontSlant->"Plain"], " ", 
              StyleBox["Mathematica",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], "package"}]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Bitmap\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                  "converts", " ", "the", " ", "selected", " ", "cell", " ", 
                    "or", " ", "cells", " ", "to", " ", 
                    StyleBox["a",
                      FontSlant->"Plain"], " ", "platform", " ", 
                    "independent", " ", "bitmap", " ", "format"}], 
                  TraditionalForm]]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->"SaveRenameSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SaveRenameSpecial"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Revert\"", "ObjectName",
  CellTags->"Revert"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Revert", "MR"],
  "\" is a front end token that restores the notebook to the last saved \
version."
}], "Usage",
  CellTags->"Revert"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Revert",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Revert"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Revert"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"OpenSpecial\"", "ObjectName",
  CellTags->"OpenSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["OpenSpecial\"", "MR"],
  " is a front end token that opens the Open Special dialog box."
}], "Usage",
  CellTags->"OpenSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Open Special",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"OpenSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"OpenSpecial"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Import\"", "ObjectName",
  CellTags->"Import"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Import", "MR"],
  "\" is a front end token that opens the Open File dialog box. The contents \
of the selected file will be inserted at the current insertion point."
}], "Usage",
  CellTags->"Import"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Import",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Import"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Import"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NotebookMail\"", "ObjectName",
  CellTags->"NotebookMail"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["NotebookMail", "MR"],
  "\" is a front end token that launches your email application to send your \
notebook to a specified address. (Windows only.)"
}], "Usage",
  CellTags->"NotebookMail"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Send To",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"NotebookMail"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"NotebookMail"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NotebookMailSelection\"", "ObjectName",
  CellTags->"NotebookMailSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["NotebookMailSelection", "MR"],
  "\" is a front end token that launches your email application to send your \
notebook selection to a specified address. (Windows only.)"
}], "Usage",
  CellTags->"NotebookMailSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Send Selection",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"NotebookMailSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"NotebookMailSelection"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"GeneratePalette\"", "ObjectName",
  CellTags->"GeneratePalette"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["GeneratePalette", "MR"],
  "\" is a front end token that converts the notebook into a palette."
}], "Usage",
  CellTags->"GeneratePalette"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Generate Palette from Selection",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"GeneratePalette"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"GeneratePalette"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"GenerateNotebook\"", "ObjectName",
  CellTags->"GenerateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["GenerateNotebook", "MR"],
  "\" is a front end token that converts a palette into an ordinary \
notebook."
}], "Usage",
  CellTags->"GenerateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Generate Notebook from Palette",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"GenerateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"GenerateNotebook"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SystemPrintOptionsDialog\"", "ObjectName",
  CellTags->"SystemPrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SystemPrintOptionsDialog", "MR"],
  "\" is a front end token that opens the Page Setup dialog box."
}], "Usage",
  CellTags->"SystemPrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Printing Settings \[RightTriangle] Page \
Setup",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SystemPrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SystemPrintOptionsDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PrintOptionsDialog\"", "ObjectName",
  CellTags->"PrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PrintOptionsDialog", "MR"],
  "\" is a front end token that opens the Printing Options dialog box."
}], "Usage",
  CellTags->"PrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Printing Settings \[RightTriangle] Printing \
Options",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"PrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"PrintOptionsDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"HeadersFootersDialog\"", "ObjectName",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["HeadersFootersDialog", "MR"],
  "\" is a front end token that opens the Headers/Footers dialog box."
}], "Usage",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Printing Settings \[RightTriangle] Headers \
and Footers",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"HeadersFootersDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PrintDialog\"", "ObjectName",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PrintDialog", "MR"],
  "\" is a front end token that opens the ",
  StyleBox["Print", "TR"],
  " dialog box to print the selected notebook."
}], "Usage",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Print",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"PrintDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PrintSelectionDialog\"", "ObjectName",
  CellTags->"PrintSelectionDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PrintSelectionDialog", "MR"],
  "\" is a front end token that opens the ",
  StyleBox["Print", "TR"],
  " dialog box to print the selected part of a notebook."
}], "Usage",
  CellTags->"PrintSelectionDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Print Selection",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"PrintSelectionDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"PrintSelectionDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FrontEndQuit\"", "ObjectName",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FrontEndQuit", "MR"],
  "\" is a front end token that causes the front end to quit. It also prompts \
the user to save any open notebooks, if necessary."
}], "Usage",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["File \[RightTriangle] Quit",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"FrontEndQuit"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Edit", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"Undo\"", "ObjectName",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Undo", "MR"],
  "\" is a front end token that reverses the most recent command, if \
possible."
}], "Usage",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Undo",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] You can only undo your most recent command. In \
general, you can undo the basic commands in the ",
  StyleBox["Edit", "SR"],
  " menu as well as any typing you have done since your last action. "
}], "Notes",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Undo"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Cut\"", "ObjectName",
  CellTags->"Cut"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Cut", "MR"],
  "\" is a front end token that removes the selection from your notebook and \
copies it to the Clipboard."
}], "Usage",
  CellTags->"Cut"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Cut",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Cut"],

Cell[TextData[{
  "\[FilledSmallSquare] You can then insert the deleted material elsewhere \
using the front end token \"",
  StyleBox["Paste", "MR"],
  "\"."
}], "Notes",
  CellTags->"Cut"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Cut"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Copy\"", "ObjectName",
  CellTags->"Copy"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Copy", "MR"],
  "\" is a front end token that copies the selection to the Clipboard without \
deleting it from your notebook."
}], "Usage",
  CellTags->"Copy"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Copy",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Copy"],

Cell[TextData[{
  "\[FilledSmallSquare] You can then insert the copied material elsewhere \
using the front end token \"",
  StyleBox["Paste", "MR"],
  "\"."
}], "Notes",
  CellTags->"Copy"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Copy"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Paste\"", "ObjectName",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Paste", "MR"],
  "\" is a front end token that inserts the current contents of the Clipboard \
at the insertion point."
}], "Usage",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Paste",
    FontFamily->"Helvetica"],
  ".\n\[FilledSmallSquare] Information contained in the Clipboard remains \
there until a new selection is copied or cut. This lets you paste the same \
contents ",
  StyleBox["repeatedly. You can empty the Clipboard automatically by using \
the front end token \"",
    TextAlignment->Left,
    TextJustification->0],
  StyleBox["PasteDiscard", "MR",
    TextAlignment->Left,
    TextJustification->0],
  StyleBox["\".",
    TextAlignment->Left,
    TextJustification->0]
}], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Paste"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Clear\"", "ObjectName",
  CellTags->"Clear"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Clear", "MR"],
  "\" is a front end token that deletes the selection without copying it to \
the Clipboard."
}], "Usage",
  CellTags->"Clear"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Clear",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Clear"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Clear"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CopySpecial\"", "ObjectName",
  CellTags->"CopySpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CopySpecial", "MR"],
  "\" is a front end token that converts the selection to a specified format \
and copies it to the Clipboard."
}], "Usage",
  CellTags->"CopySpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Copy As",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CopySpecial"],

Cell["\<\
\[FilledSmallSquare] This token has a parameter that can take one \
of the following values:
\
\>", "Notes",
  CellTags->"CopySpecial"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"PlainText\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`text\ with\ style\ information\ \
removed\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"FormattedText\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`text\ with\ style\ information\ \
preserved\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"InputText\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`plain\ ASCII\ text\ with\ added\ \
whitespace\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"CellExpression\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"one", " ", "or", " ", "more", " ", 
                    StyleBox[\(Cell[]\),
                      "MR"], " ", "expressions"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NotebookExpression\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["a",
                      FontSlant->"Plain"], " ", 
                    StyleBox[\(Notebook[]\),
                      "MR"], " ", "expression"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"CompleteNotebook\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["a",
                      FontSlant->"Plain"], " ", "complete", " ", "notebook", 
                    " ", "file"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MGF\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`Bitmap\ format; \ Windows\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"EMF\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`Enhanced\ Metafile; Windows\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"WAV\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`Wave\ format; Windows\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PICT\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`PICT\ format\ with\ individual\ drawing\ \
commands; Macintosh\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PICTBitmap\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`PICT\ format\ with\ one\ bitmap\ drawing\ \
command; Macintosh\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PICTEmbeddedPS\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`PICT\ format\ with\ one\ bitmap\ and\ \
embedded\ PostScript; \ Macintosh\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"QuickTime\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"QuickTime animation; Macintosh only \
"\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->"CopySpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CopySpecial"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PasteSpecial\"", "ObjectName",
  CellTags->"PasteSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PasteSpecial", "MR"],
  "\" is a front end token that copies the contents of the Clipboard, in a \
specified format, at the insertion point."
}], "Usage",
  CellTags->"PasteSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Paste As",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"PasteSpecial"],

Cell["\<\
\[FilledSmallSquare] This token has a parameter that can take one \
of the following values:\
\>", "Notes",
  CellTags->"PasteSpecial"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"PlainText\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`text\ with\ style\ information\ \
removed\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"FormattedText\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`text\ with\ style\ information\ \
preserved\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"InputText\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`plain\ ASCII\ text\ with\ added\ \
whitespace\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"InlineCell\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`an\ inline\ cell\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->"PasteSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"PasteSpecial"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PasteApply\"", "ObjectName",
  CellTags->"PasteApply"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PasteApply", "MR"],
  "\" is a front end token that pastes the contents of the Clipboard over the \
selection and substitutes the selection into any ",
  StyleBox["\\[SelectionPlaceholder", "MR"],
  " characters in the Clipboard data."
}], "Usage",
  CellTags->"PasteApply"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Paste As \[RightTriangle] Paste and Apply",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"PasteApply"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"PasteApply"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PasteDiscard\"", "ObjectName",
  CellTags->"PasteDiscard"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PasteDiscard", "MR"],
  "\" is a front end token that pastes the contents of the Clipboard at the \
insertion point and clears the Clipboard after the paste operation is \
complete."
}], "Usage",
  CellTags->"PasteDiscard"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Paste As \[RightTriangle] Paste and \
Discard",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"PasteDiscard"],

Cell[TextData[{
  "\[FilledSmallSquare] This is useful for conserving memory, particularly if \
the clipboard is large. If you want to retain the contents of the clipboard, \
you can use the front end token \"",
  StyleBox["PasteApply", "MR"],
  "\"."
}], "Notes",
  CellTags->"PasteDiscard"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"PasteDiscard"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectionSaveSpecial\"", "ObjectName",
  CellTags->"SelectionSaveSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectionSaveSpecial", "MR"],
  "\" is a front end token that converts the selection to a specified format \
and copies it to the Clipboard."
}], "Usage",
  CellTags->"SelectionSaveSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Save Selection As",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectionSaveSpecial"],

Cell["\<\
\[FilledSmallSquare] This token has a parameter that can take one \
of the following values:\
\>", "Notes",
  CellTags->"SelectionSaveSpecial"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"Text\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`text\ with\ style\ information\ \
removed\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"InputText\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`plain\ ASCII\ text\ with\ added\ \
whitespace\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"CellExpression\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"one", " ", "or", " ", "more", " ", 
                    StyleBox[\(Cell[]\),
                      "MR"], " ", "expressions"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NotebookExpression\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["a",
                      FontSlant->"Plain"], " ", 
                    StyleBox[\(Notebook[]\),
                      "MR"], " ", "expression"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"CompleteNotebook\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["a",
                      FontSlant->"Plain"], " ", "complete", " ", "notebook", 
                    " ", "file"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Package\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["a",
                      FontSlant->"Plain"], " ", "Mathematica", " ", 
                    "package"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"EPS\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`an\ Encapsulated\ PostScript\ graphic\ \
image\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MGF\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`Bitmap\ format; \ Windows\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"EMF\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`Enhanced\ Metafile; \ Windows\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"WMF\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`Windows\ Metafile; \ Windows\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"RTF\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`Rich\ Text\ Format; \ Windows\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"WAV\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`Wave\ format; \ Windows\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PICT\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`PICT\ format\ with\ individual\ drawing\ \
commands; \ Macintosh\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PICTBitmap\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`PICT\ format\ with\ one\ bitmap\ drawing\ \
command; \ Macintosh\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PICTEmbeddedPS\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`PICT\ format\ with\ one\ bitmap\ and\ \
embedded\ PostScript; \ Macintosh\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"QuickTime\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"QuickTime animation; Macintosh only \
"\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->"SelectionSaveSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectionSaveSpecial"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectAll\"", "ObjectName",
  CellTags->"SelectAll"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectAll", "MR"],
  "\" is a front end token that selects all the cells in the current \
notebook."
}], "Usage",
  CellTags->"SelectAll"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Select All",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectAll"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectAll"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"InsertObject\"", "ObjectName",
  CellTags->"InsertObject"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["InsertObject", "MR"],
  "\" is a front end token that opens the Insert Object dialog box to insert \
an object, such as a document file, in a notebook."
}], "Usage",
  CellTags->"InsertObject"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Insert Object...",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"InsertObject"],

Cell["\<\
\[FilledSmallSquare] This token is available only on Windows.\
\>", \
"Notes",
  CellTags->"InsertObject"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"InsertObject"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MoveNext\"", "ObjectName",
  CellTags->"MoveNext"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["MoveNext", "MR"],
  "\" is a front end token that moves the insertion point right by one \
character."
}], "Usage",
  CellTags->"MoveNext"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Move Next",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"MoveNext"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MoveNext"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MovePrevious\"", "ObjectName",
  CellTags->"MovePrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["MovePrevious", "MR"],
  "\" is a front end token that moves the insertion point left by one \
character."
}], "Usage",
  CellTags->"MovePrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Move Previous",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"MovePrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MovePrevious"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DeleteNext\"", "ObjectName",
  CellTags->"DeleteNext"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["DeleteNext", "MR"],
  "\" is a front end token that deletes the character to the right of the \
insertion point."
}], "Usage",
  CellTags->"DeleteNext"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Delete Next",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"DeleteNext"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"DeleteNext"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DeletePrevious\"", "ObjectName",
  CellTags->"DeletePrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["DeletePrevious", "MR"],
  "\" is a front end token that deletes the character to the left of the \
insertion point."
}], "Usage",
  CellTags->"DeletePrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Delete Previous",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"DeletePrevious"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"DeletePrevious"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MoveNextWord\"", "ObjectName",
  CellTags->"MoveNextWord"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["MoveNextWord", "MR"],
  "\" is a front end token that moves the insertion point right by one word."
}], "Usage",
  CellTags->"MoveNextWord"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Move Next Word",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"MoveNextWord"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MoveNextWord"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MovePreviousWord\"", "ObjectName",
  CellTags->"MovePreviousWord"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["MovePreviousWord", "MR"],
  "\" is a front end token that moves the insertion point left by one word."
}], "Usage",
  CellTags->"MovePreviousWord"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Move Previous Word",
    
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"MovePreviousWord"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MovePreviousWord"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DeleteNextWord\"", "ObjectName",
  CellTags->"DeleteNextWord"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["DeleteNextWord", "MR"],
  "\" is a front end token that deletes the word to the right of the \
insertion point."
}], "Usage",
  CellTags->"DeleteNextWord"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Delete Next Word",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"DeleteNextWord"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"DeleteNextWord"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DeletePreviousWord\"", "ObjectName",
  CellTags->"DeletePreviousWord"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["DeletePreviousWord", "MR"],
  "\" is a front end token that deletes the word to the left of the insertion \
point."
}], "Usage",
  CellTags->"DeletePreviousWord"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Delete Previous \
Word",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"DeletePreviousWord"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"DeletePreviousWord"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MoveLineEnd\"", "ObjectName",
  CellTags->"MoveLineEnd"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["MoveLineEnd", "MR"],
  "\" is a front end token that moves the insertion point to the end of the \
current line."
}], "Usage",
  CellTags->"MoveLineEnd"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Move Line End",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"MoveLineEnd"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MoveLineEnd"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MoveLineBeginning\"", "ObjectName",
  CellTags->"MoveLineBeginning"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["MoveLineBeginning", "MR"],
  "\" is a front end token that moves the insertion point to the beginning of \
the current line."
}], "Usage",
  CellTags->"MoveLineBeginning"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Move Line \
Beginning",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"MoveLineBeginning"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MoveLineBeginning"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MoveNextLine\"", "ObjectName",
  CellTags->"MoveNextLine"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["MoveNextLine", "MR"],
  "\" is a front end token that moves the insertion point down by one line."
}], "Usage",
  CellTags->"MoveNextLine"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Move Next Line",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"MoveNextLine"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MoveNextLine"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MovePreviousLine\"", "ObjectName",
  CellTags->"MovePreviousLine"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["MovePreviousLine", "MR"],
  "\" is a front end token that moves the insertion point up by one line."
}], "Usage",
  CellTags->"MovePreviousLine"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Motion \[RightTriangle] Move Previous Line",
    
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"MovePreviousLine"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MovePreviousLine"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Superscript\"", "ObjectName",
  CellTags->"Superscript"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Superscript", "MR"],
  "\" is a front end token that creates a ",
  StyleBox["SuperscriptBox", "MR"],
  " and fills the base with the current selection. "
}], "Usage",
  CellTags->"Superscript"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] \
Superscript",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Superscript"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Superscript", "MR"],
  "\" will fill the base with the sub-expression to the left of the selection \
if it is an insertion point."
}], "Notes",
  CellTags->"Superscript"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Superscript"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Subscript\"", "ObjectName",
  CellTags->"Subscript"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Subscript", "MR"],
  "\" is a front end token that creates a ",
  StyleBox["SubscriptBox", "MR"],
  " and fills the base with the current selection. "
}], "Usage",
  CellTags->"Subscript"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] \
Subscript",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Subscript"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Subscript", "MR"],
  "\" will fill the base with the sub-expression to the left of the selection \
if it is an insertion point."
}], "Notes",
  CellTags->"Subscript"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Subscript"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Above\"", "ObjectName",
  CellTags->"Above"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Above", "MR"],
  "\" is a front end token that creates an ",
  StyleBox["OverscriptBox", "MR"],
  " and fills the base with the current selection. "
}], "Usage",
  CellTags->"Above"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Above",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Above"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Above", "MR"],
  "\" will fill the base with the sub-expression to the left of the selection \
if it is an insertion point."
}], "Notes",
  CellTags->"Above"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Above"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Below\"", "ObjectName",
  CellTags->"Below"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Below", "MR"],
  "\" is a front end token that creates an ",
  StyleBox["UnderscriptBox", "MR"],
  " and fills the base with the current selection. "
}], "Usage",
  CellTags->"Below"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Below",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Below"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Below", "MR"],
  "\" will fill the base with the sub-expression to the left of the selection \
if it is an insertion point."
}], "Notes",
  CellTags->"Below"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Below"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Otherscript\"", "ObjectName",
  CellTags->"Otherscript"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Otherscript\"", "MR"],
  " is a front end token that moves the selection to the \"other\" script \
position."
}], "Usage",
  CellTags->"Otherscript"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Opposite \
Position",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Otherscript"],

Cell[TextData[{
  "\[FilledSmallSquare] If the selection is in the superscript position, ",
  StyleBox["\"Otherscript\"", "MR"],
  " will move the selection to the subscript position.\n\[FilledSmallSquare] \
If the selection is in the subscript position, ",
  StyleBox["\"Otherscript\"", "MR"],
  " will move the selection to the superscript position.\n\
\[FilledSmallSquare] If the selection is in the overscript position, ",
  StyleBox["\"Otherscript\"", "MR"],
  " will move the selection to the underscript position.\n\
\[FilledSmallSquare] If the selection is in the underscript position, ",
  StyleBox["\"Otherscript\"", "MR"],
  " will move the selection to the overscript position."
}], "Notes",
  CellTags->"Otherscript"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Otherscript"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Fraction\"", "ObjectName",
  CellTags->"Fraction"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Fraction\"", "MR"],
  " is a front end token that creates a ",
  StyleBox["FractionBox", "MR"],
  " and fills the numerator with the current selection."
}], "Usage",
  CellTags->"Fraction"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Fraction",
    
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Fraction"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Fraction\"", "MR"],
  " fills the numerator with the sub-expression to the left of the selection \
if it is an insertion point."
}], "Notes",
  CellTags->"Fraction"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Fraction"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Radical\"", "ObjectName",
  CellTags->"Radical"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Radical\"", "MR"],
  " is a front end token that creates a ",
  StyleBox["SqrtBox", "MR"],
  " and fills the base with the current selection."
}], "Usage",
  CellTags->"Radical"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Radical",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Radical"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Radical\"", "MR"],
  " fills the base with a placeholder if it is an insertion point."
}], "Notes",
  CellTags->"Radical"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Radical"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NewRow\"", "ObjectName",
  CellTags->"NewRow"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"NewRow\"", "MR"],
  " is a front end token that adds a row to an existing ",
  StyleBox["GridBox", "MR"],
  "."
}], "Usage",
  CellTags->"NewRow"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Add Row",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"NewRow"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"NewRow\"", "MR"],
  " creates a ",
  StyleBox["GridBox", "MR"],
  " if none exists."
}], "Notes",
  CellTags->"NewRow"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"NewRow"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NewColumn\"", "ObjectName",
  CellTags->"NewColumn"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"NewColumn\"", "MR"],
  " is a front end token that adds a new column to an existing ",
  StyleBox["GridBox", "MR"],
  "."
}], "Usage",
  CellTags->"NewColumn"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Add \
Column",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"NewColumn"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"NewColumn\"", "MR"],
  " creates a ",
  StyleBox["GridBox", "MR"],
  " if none exists."
}], "Notes",
  CellTags->"NewColumn"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"NewColumn"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MoveExpressionEnd\"", "ObjectName",
  CellTags->"MoveExpressionEnd"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"MoveExpressionEnd\"", "MR"],
  " is a front end token that moves the insertion point to the end of the \
current sub-expression."
}], "Usage",
  CellTags->"MoveExpressionEnd"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] End \
Subexpression",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"MoveExpressionEnd"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MoveExpressionEnd"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ExpandSelection\"", "ObjectName",
  CellTags->"ExpandSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ExpandSelection\"", "MR"],
  " is a front end token that extends the selection to include the next \
highest level sub-expression."
}], "Usage",
  CellTags->"ExpandSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Extend \
Selection",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ExpandSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ExpandSelection\"", "MR"],
  " works for typeset cells only."
}], "Notes",
  CellTags->"ExpandSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ExpandSelection"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CreateInlineCell\"", "ObjectName",
  CellTags->"CreateInlineCell"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"CreateInlineCell\"", "MR"],
  " is a front end token that creates a new inline cell."
}], "Usage",
  CellTags->"CreateInlineCell"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Start \
Inline Cell",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CreateInlineCell"],

Cell["\<\
\[FilledSmallSquare] If the selection is in a text cell, a typeset \
cell is created. If the selection is in a typeset cell, a text cell is \
created.\
\>", "Notes",
  CellTags->"CreateInlineCell"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CreateInlineCell"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EndInlineCell\"", "ObjectName",
  CellTags->"EndInlineCell"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"EndInlineCell\"", "MR"],
  " is a front end token that ends an inline cell."
}], "Usage",
  CellTags->"EndInlineCell"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] End \
Inline Cell",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EndInlineCell"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EndInlineCell"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"InsertRawExpression\"", "ObjectName",
  CellTags->"InsertRawExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"InsertRawExpression\"", "MR"],
  " is a front end token that opens a dialog box where you can enter a box or \
cell expression."
}], "Usage",
  CellTags->"InsertRawExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Insert \
Raw Expression",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"InsertRawExpression"],

Cell["\<\
\[FilledSmallSquare] The expression will be inserted at the current \
insertion point.\
\>", "Notes",
  CellTags->"InsertRawExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"InsertRawExpression"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"AddInterpretation\"", "ObjectName",
  CellTags->"AddInterpretation"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"AddInterpretation\"", "MR"],
  " is a front end token that opens a dialog box where you can enter an \
expression that will be interpreted as either an  ",
  ButtonBox["InterpretationBox",
    ButtonStyle->"RefGuideLink"],
  " or as a  ",
  ButtonBox["TagBox",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Usage",
  CellTags->"AddInterpretation"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Add  \
Expression",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"AddInterpretation"],

Cell["\<\
\[FilledSmallSquare] The expression will be inserted at the current \
insertion point.\
\>", "Notes",
  CellTags->"AddInterpretation"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"AddInterpretation"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NudgeLeft\"", "ObjectName",
  CellTags->"NudgeLeft"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"NudgeLeft\"", "MR"],
  " is a front end token that adds an ",
  StyleBox["AdjustmentBox", "MR"],
  ", or modifies an existing one, to shift the selected expression one point \
to the left."
}], "Usage",
  CellTags->"NudgeLeft"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Nudge \
Left",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"NudgeLeft"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"NudgeLeft"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NudgeRight\"", "ObjectName",
  CellTags->"NudgeRight"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"NudgeRight\"", "MR"],
  " is a front end token that adds an ",
  StyleBox["AdjustmentBox", "MR"],
  ", or modifies an existing one, to shift the selected expression one point \
to the right."
}], "Usage",
  CellTags->"NudgeRight"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Nudge \
Right",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"NudgeRight"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"NudgeRight"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NudgeUp\"", "ObjectName",
  CellTags->"NudgeUp"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"NudgeUp\"", "MR"],
  " is a front end token that adds an ",
  StyleBox["AdjustmentBox", "MR"],
  ", or modifies an existing one, to shift the selected expression one point \
up."
}], "Usage",
  CellTags->"NudgeUp"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Nudge Up",
    
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"NudgeUp"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"NudgeUp"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NudgeDown\"", "ObjectName",
  CellTags->"NudgeDown"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"NudgeDown\"", "MR"],
  " is a front end token that adds an ",
  StyleBox["AdjustmentBox", "MR"],
  ", or modifies an existing one, to shift the selected expression one point \
down."
}], "Usage",
  CellTags->"NudgeDown"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Nudge \
Down",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"NudgeDown"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"NudgeDown"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RemoveAdjustments\"", "ObjectName",
  CellTags->"RemoveAdjustments"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RemoveAdjustments\"", "MR"],
  " is a front end token that removes all occurrences of ",
  StyleBox["AdjustmentBox", "MR"],
  " in the selected expression."
}], "Usage",
  CellTags->"RemoveAdjustments"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Expression Input \[RightTriangle] Remove \
Adjustments",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"RemoveAdjustments"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"RemoveAdjustments"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Make2D\"", "ObjectName",
  CellTags->"Make2D"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Make2D\"", "MR"],
  " is a front end token that converts any linear syntax in the selected \
expression into the corresponding two-dimensional typeset form."
}], "Usage",
  CellTags->"Make2D"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Make2D",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Make2D"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Make2D"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Balance\"", "ObjectName",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Balance", "MR"],
  "\" is a front end token that extends the current selection to include the \
next matching pair of parentheses, brackets, or curly brackets."
}], "Usage",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Check Balance",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] Each time you use ",
  StyleBox["\"Balance\"", "MR"],
  ", ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " expands the selection in both directions until it finds pairs of matching \
parentheses, brackets, or braces. Repeating the command expands the selection \
one level at a time."
}], "Notes",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Balance"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FindNextMisspelling\"", "ObjectName",
  CellTags->"FindNextMisspelling"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FindNextMisspelling", "MR"],
  "\" is a front end token that selects the next misspelled word and opens \
the spell check dialog box."
}], "Usage",
  CellTags->"FindNextMisspelling"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Edit \[RightTriangle] Check Spelling",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"FindNextMisspelling"],

Cell["\<\
\[FilledSmallSquare] When a misspelled word is found, it is \
displayed in the dialog box along with a list of suggested alternatives. \
Click a suggested word to copy it to the \"Replace with:\" field. \
Double-click a suggested word to paste it into the notebook and continue the \
search. \
\>", "Notes",
  CellTags->"FindNextMisspelling"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"FindNextMisspelling"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"SelectionConvert\"", "ObjectName",
  CellTags->"SelectionConvert"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectionConvert", "MR"],
  "\" is a front end token that converts the selected cells into a new \
format."
}], "Usage",
  CellTags->"SelectionConvert"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Convert To",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectionConvert"],

Cell["\<\
\[FilledSmallSquare] This token has a parameter that can take one \
of the following values:\
\>", "Notes",
  CellTags->"SelectionConvert"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"InputForm\"\>",
                    "MR"], TraditionalForm]]], 
            RowBox[{
              RowBox[{Cell[BoxData[
                    \(TraditionalForm\`converts\ the\ selection\ to\ \
Mathematica\)]], " ", "input", " ", "form"}], ";", " ", 
              RowBox[{"see", " ", 
                ButtonBox["InputForm",
                  ButtonStyle->"OtherInformationLink"], "for", " ", "more", 
                " ", "information"}]}]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"OutputForm\"\>",
                      "MR"], " "}], TraditionalForm]]], 
            RowBox[{
              RowBox[{Cell[BoxData[
                    \(TraditionalForm\`converts\ the\ selection\ to\ \
Mathematica\)]], " ", "output", " ", "form"}], ";", " ", 
              RowBox[{"see", " ", 
                ButtonBox["OutputForm",
                  ButtonStyle->"OtherInformationLink"], "for", " ", "more", 
                " ", "information"}]}]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"StandardForm\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`creates\ an\ inline\ cell\ in\ \
StandardForm\ format\ when\ applied\ to\ text\ selections\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"TraditionalForm\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`creates\ an\ inline\ cell\ in\ \
TraditionalForm\ format\ when\ applied\ to\ text\ selections\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PostScript\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`converts\ the\ selected\ cell\ or\ cells\ \
to\ PostScript\ format\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Bitmap\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    RowBox[{
                    "converts", " ", "the", " ", "selected", " ", "cell", " ",
                       "or", " ", "cells", " ", "to", " ", 
                      StyleBox["a",
                        FontSlant->"Plain"], " ", "platform"}], 
                    "-", \(independent\ bitmap\ format\)}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Metafile\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`converts\ the\ selected\ cell\ or\ cells\ \
to\ Windows\ Metafile\ format; \ Windows\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PICT\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`converts\ the\ selected\ cell\ or\ cells\ \
to\ Macintosh\ PICT\ format\ with\ individual\ drawing\ commands; \ 
                Macintosh\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PICTBitmap\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`converts\ the\ selected\ cell\ or\ cells\ \
to\ Macintosh\ PICT\ format\ with\ one\ bitmap\ drawing\ command; \ 
                Macintosh\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PICTEmbeddedPS\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`converts\ the\ selected\ cell\ or\ cells\ \
to\ Macintosh\ PICT\ format\ with\ embedded\ PostScript; \ 
                Macintosh\ only\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"QuickTime\"\>",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"converts the selected cell or cells to \
QuickTime format; Macintosh only "\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->"SelectionConvert"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectionConvert"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectionDisplayAs\"", "ObjectName",
  CellTags->"SelectionDisplayAs"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectionDisplayAs", "MR"],
  "\" is a front end token that redisplays selected cells in a new format \
type."
}], "Usage",
  CellTags->"SelectionDisplayAs"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Display As",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectionDisplayAs"],

Cell[TextData[{
  "\[FilledSmallSquare] This differs from the front end token ",
  StyleBox["SelectionConvert", "MR"],
  " in that the data is never sent to the kernel to be converted; it is \
reinterpreted locally in the new format."
}], "Notes",
  CellTags->"SelectionDisplayAs"],

Cell["\<\
\[FilledSmallSquare] This token has a parameter that can take one \
of the following values:\
\>", "Notes",
  CellTags->"SelectionDisplayAs"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"TextForm\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`displays\ the\ selection\ as\ plain\ text\ \
without\ interpretation\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"InputForm\"\>",
                      "MR"], " "}], TraditionalForm]]], 
            RowBox[{
            "displays", " ", "the", " ", "selection", " ", "as", " ", 
              "Mathematica", " ", 
              StyleBox["InputForm",
                "MR"], " ", "without", " ", "interpretation"}]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"StandardForm\"\>",
                      "MR"], " "}], TraditionalForm]]], 
            RowBox[{
            "displays", " ", "the", " ", "selection", " ", "as", " ", 
              "Mathematica", " ", 
              StyleBox["StandardForm",
                "MR"]}]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"TraditionalForm\"\>",
                      "MR"], " "}], TraditionalForm]]], 
            RowBox[{
            "displays", " ", "the", " ", "selection", " ", "as", " ", 
              "Mathematica", " ", 
              StyleBox["TraditionalForm",
                "MR"]}]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->"SelectionDisplayAs"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectionDisplayAs"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellGroup\"", "ObjectName",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellGroup", "MR"],
  "\" is a front end token that groups the currently selected cells."
}], "Usage",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Cell Grouping \[RightTriangle] Group Cells",
    
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] This token will work only if ",
  StyleBox["Cell Grouping \[Rule] Manual Grouping. ", "SR"],
  "See ",
  ButtonBox["Group Cells",
    ButtonData:>{"Group Cells"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CellGroup"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellUngroup\"", "ObjectName",
  CellTags->"CellUngroup"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellUngroup", "MR"],
  "\" is a front end token that ungroups the currently selected cells."
}], "Usage",
  CellTags->"CellUngroup"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Cell Grouping \[RightTriangle] Ungroup \
Cells",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CellUngroup"],

Cell[TextData[{
  "\[FilledSmallSquare] This token will work only if ",
  StyleBox["Cell Grouping \[Rule] Manual Grouping. ", "SR"],
  "See ",
  ButtonBox["Group Cells",
    ButtonData:>{"Group Cells"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"CellUngroup"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CellUngroup"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectionOpenAllGroups\"", "ObjectName",
  CellTags->"SelectionOpenAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectionOpenAllGroups", "MR"],
  "\" is a front end token that opens all groups and subgroups in the current \
selection."
}], "Usage",
  CellTags->"SelectionOpenAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Cell Grouping \[RightTriangle] Open All \
Subgroups",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectionOpenAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectionOpenAllGroups"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectionCloseAllGroups\"", "ObjectName",
  CellTags->"SelectionCloseAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectionCloseAllGroups", "MR"],
  "\" is a front end token that opens all groups and subgroups in the current \
selection."
}], "Usage",
  CellTags->"SelectionCloseAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Cell Grouping \[RightTriangle] Close All \
Subgroups",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectionCloseAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectionCloseAllGroups"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"OpenCloseGroup\"", "ObjectName",
  CellTags->"OpenCloseGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["OpenCloseGroup", "MR"],
  "\" is a front end token that opens selected groups if they are closed or \
closes selected groups if they are open."
}], "Usage",
  CellTags->"OpenCloseGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Cell Grouping \[RightTriangle] Open/Close \
Group",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"OpenCloseGroup"],

Cell["\<\
\[FilledSmallSquare] This token will affect only the outermost \
level of selected groups.\
\>", "Notes",
  CellTags->"OpenCloseGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"OpenCloseGroup"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellSplit\"", "ObjectName",
  CellTags->"CellSplit"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellSplit", "MR"],
  "\" is a front end token that splits a cell into two or three cells at the \
current selection."
}], "Usage",
  CellTags->"CellSplit"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Divide Cell",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CellSplit"],

Cell["\<\
\[FilledSmallSquare] An insertion point divides the cell in two. A \
text selection divides the cell into three cells: everything before the \
beginning of the selection, the selection itself, and everything after the \
end of the selection.\
\>", "Notes",
  CellTags->"CellSplit"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CellSplit"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellMerge\"", "ObjectName",
  CellTags->"CellMerge"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellMerge", "MR"],
  "\" is a front end token that merges the selected cells into one cell."
}], "Usage",
  CellTags->"CellMerge"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Merge Cells",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CellMerge"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CellMerge"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectionAnimate\"", "ObjectName",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectionAnimate", "MR"],
  "\" is a front end token that animates the graphics in the current \
selection."
}], "Usage",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Animate Selected Graphics",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] The current selection is typically a cell group. See \
",
  ButtonBox["Animate Selected Graphics",
    ButtonData:>{"Animate Selected Graphics"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectionAnimate"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SoundPlay\"", "ObjectName",
  CellTags->"SoundPlay"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SoundPlay", "MR"],
  "\" is a front end token that plays all the sounds in the current \
selection."
}], "Usage",
  CellTags->"SoundPlay"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Play Sound",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SoundPlay"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Playing Sounds",
    ButtonData:>{"Play Sound"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"SoundPlay"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SoundPlay"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"GraphicsRender\"", "ObjectName",
  CellTags->"GraphicsRender"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["GraphicsRender", "MR"],
  "\" is a front end token that re-renders all the selected graphics."
}], "Usage",
  CellTags->"GraphicsRender"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Rerender Graphics",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"GraphicsRender"],

Cell["\<\
\[FilledSmallSquare] You might need to use this token if the \
graphics cells were previously rendered with different screen settings.\
\>", \
"Notes",
  CellTags->"GraphicsRender"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"GraphicsRender"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"GenerateImageCaches\"", "ObjectName",
  CellTags->"GenerateImageCaches"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["GenerateImageCaches", "MR"],
  "\" is a front end token that generates and saves image caches for all \
graphics cells."
}], "Usage",
  CellTags->"GenerateImageCaches"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Rerender and Save Graphics",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"GenerateImageCaches"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"GenerateImageCaches"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"GraphicsOriginalSize\"", "ObjectName",
  CellTags->"GraphicsOriginalSize"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["GraphicsOriginalSize", "MR"],
  "\" is a front end token that restores all selected graphics to their \
default size."
}], "Usage",
  CellTags->"GraphicsOriginalSize"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Make Standard Size",
    FontFamily->"Helvetica"],
  "."
}], "Notes"],

Cell["\<\
\[FilledSmallSquare]  For PICT, QuickTime, and Bitmap graphics, the \
graphic itself defines its normal size (Macintosh only). For PostScript \
graphics, the standard size is determined by the aspect ratio defined within \
the graphic or by the BoundingBox PostScript comment, if present.\
\>", \
"Notes",
  CellTags->"GraphicsOriginalSize"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"GraphicsOriginalSize"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"GraphicsAlign\"", "ObjectName",
  CellTags->"GraphicsAlign"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["GraphicsAlign", "MR"],
  "\" is a front end token that opens the Align Selected Graphics dialog \
box."
}], "Usage",
  CellTags->"GraphicsAlign"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Align Selected Graphics",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"GraphicsAlign"],

Cell[TextData[{
  "\[FilledSmallSquare] This token opens a dialog box that allows you to set \
the options ",
  StyleBox["ImageSize", "MR"],
  " and ",
  StyleBox["ImageMargins", "MR"],
  " on the selected cell objects. See ",
  ButtonBox["Align Selected Graphics",
    ButtonData:>{"Align Selected Graphics"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"GraphicsAlign"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"GraphicsAlign"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NotebookStatisticsDialog\"", "ObjectName",
  CellTags->"NotebookStatisticsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare]  \"",
  StyleBox["NotebookStatisticsDialog", "MR"],
  "\" is a front end token that opens the Cell Size Statistics dialog box."
}], "Usage",
  CellTags->"NotebookStatisticsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Cell \[RightTriangle] Cell Size Statistics",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"NotebookStatisticsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token gives statistics for cells in the current \
notebook. See ",
  ButtonBox["Cell Size Statistics...",
    ButtonData:>{"Cell Size Statistics..."},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"NotebookStatisticsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"NotebookStatisticsDialog"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Format", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"StyleOther\"", "ObjectName",
  CellTags->"StyleOther"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["StyleOther", "MR"],
  "\" is a front end token that opens the CustomStyle dialog box."
}], "Usage",
  CellTags->"StyleOther"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Style",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"StyleOther"],

Cell["\<\
\[FilledSmallSquare] The dialog box lets you type in a style name \
to be assigned to the selected cell or text.  You can also assign cell \
options by typing the option setting in this dialog box. \
\>", "Notes",
  CellTags->"StyleOther"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"StyleOther"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ToggleShowExpression\"", "ObjectName",
  CellTags->"ToggleShowExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ToggleShowExpression", "MR"],
  "\" is a front end token that toggles between ",
  StyleBox["Cell[]", "MR"],
  " expression form and display form for selected cells."
}], "Usage",
  CellTags->"ToggleShowExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Show Expression",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ToggleShowExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ToggleShowExpression"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"OptionsDialog\"", "ObjectName",
  CellTags->"OptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"OptionsDialog", "MR"],
  "\" is a front end token that opens the Option Inspector and displays the \
current global preferences."
}], "Usage",
  CellTags->"OptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Option Inspector",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"OptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"OptionsDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ClearCellOptions\"", "ObjectName",
  CellTags->"ClearCellOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ClearCellOptions", "MR"],
  "\" removes all explicit option settings for the selected cell."
}], "Usage",
  CellTags->"ClearCellOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Remove Options",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ClearCellOptions"],

Cell["\<\
\[FilledSmallSquare] This command brings up a dialog box that \
enables you to choose whether option settings should be removed only at the \
cell level or recursively, within sub-parts of it. \
\>", "Notes",
  CellTags->"ClearCellOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ClearCellOptions"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"StyleDefinitionsOther\"", "ObjectName",
  CellTags->"StyleDefinitionsOther"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"StyleDefinitionsOther", "MR"],
  "\" is a front end token that opens the Open File dialog box to select a \
style sheet for the current notebook."
}], "Usage",
  CellTags->"StyleDefinitionsOther"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Style Sheet",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"StyleDefinitionsOther"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "The commands in this submenu set the option ",
  StyleBox["StyleDefinitions", "MR"],
  " on the selected notebook."
}], "Notes",
  CellTags->"StyleDefinitionsOther"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"StyleDefinitionsOther"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EditStyleDefinitions\"", "ObjectName",
  CellTags->"EditStyleDefinitions"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"EditStyleDefintions", "MR"],
  "\" is a front end token that lets you edit the style definitions for the \
current notebook."
}], "Usage",
  CellTags->"EditStyleDefinitions"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Edit Style Sheet",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EditStyleDefinitions"],

Cell["\<\
\[FilledSmallSquare] If the current notebook is using private style \
definitions, the style notebook is opened.
\[FilledSmallSquare] If the current notebook is using a shared style sheet, a \
dialog box will appear asking if you want to import a private copy of the \
style sheet or edit the shared style sheet.\
\>", "Notes",
  CellTags->"EditStyleDefinitions"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EditStyleDefinitions"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PlainFont\"", "ObjectName",
  CellTags->"PlainFont"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PlainFont", "MR"],
  "\" is a front end token that removes any ",
  StyleBox["FontWeight", "MR"],
  ", ",
  StyleBox["FontSlant", "MR"],
  ", ",
  StyleBox["FontTracking", "MR"],
  ", or ",
  StyleBox["FontVariations", "MR"],
  " option settings from the current selection."
}], "Usage",
  CellTags->"PlainFont"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Font \[RightTriangle] Plain",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"PlainFont"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"PlainFont"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FontSizeDialog\"", "ObjectName",
  CellTags->"FontSizeDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FontSizeDialog", "MR"],
  "\" is a front end token that opens a dialog box for choosing a font size \
for the currently selected text."
}], "Usage",
  CellTags->"FontSizeDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Font \[RightTriangle] Size",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"FontSizeDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"FontSizeDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FontColorDialog\"", "ObjectName",
  CellTags->"FontColorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FontColorDialog", "MR"],
  "\" is a front end token that opens a dialog box for choosing a color for \
the currently selected text."
}], "Usage",
  CellTags->"FontColorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Font \[RightTriangle] Text Color",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"FontColorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"FontColorDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ToggleGrayBox\"", "ObjectName",
  CellTags->"ToggleGrayBox"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ToggleGrayBox", "MR"],
  "\" is a front end token that sets or unsets the options ",
  StyleBox["CellFrame", "MR"],
  " and ",
  StyleBox["Background", "MR"],
  " to give the selected cells a gray box or to remove the gray box if the \
selected cells have one."
}], "Usage",
  CellTags->"ToggleGrayBox"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Background Color \[RightTriangle] Cell \
Gray Box",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ToggleGrayBox"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ToggleGrayBox"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"BackgroundDialog\"", "ObjectName",
  CellTags->"BackgroundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["BackgroundDialog", "MR"],
  "\" is a front end token that opens the Color dialog box for choosing a \
background color for the currently selected text or cell."
}], "Usage",
  CellTags->"BackgroundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Background Color \[RightTriangle] Other",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"BackgroundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"BackgroundDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FontPanel\"", "ObjectName",
  CellTags->"FontPanel"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FontPanel", "MR"],
  "\" is a front end token that opens a dialog box that allows you to set \
several font options for a selection."
}], "Usage",
  CellTags->"FontPanel"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Background Color \[RightTriangle] Choose \
Font",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"FontPanel"],

Cell["\<\
\[FilledSmallSquare] This token is available only on Windows.\
\>", \
"Notes",
  CellTags->"FontPanel"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"FontPanel"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FixCellWidth\"", "ObjectName",
  CellTags->"FixCellWidth"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FixCellWidth", "MR"],
  "\" is a front end token that assigns a ",
  StyleBox["CellSize", "MR"],
  " option to the currently selected cells to fix their width at their \
current width."
}], "Usage",
  CellTags->"FixCellWidth"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Word Wrapping \[RightTriangle] Fixed Word \
Wrap Width",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"FixCellWidth"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"FixCellWidth"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ToggleOptionListElement\"", "ObjectName",
  CellTags->"ToggleOptionListElement"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ToggleOptionListElement", "MR"],
  "\" is a front end token that toggles the display of the ruler along the \
top of the selected notebook."
}], "Usage",
  CellTags->"ToggleOptionListElement"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Show Ruler",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ToggleOptionListElement"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ToggleOptionListElement"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ShowPageBreaks\"", "ObjectName",
  CellTags->"ShowPageBreaks"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ShowPageBreaks", "MR"],
  "\" is a front end token that calculates and displays page breaks on the \
screen."
}], "Usage",
  CellTags->"ShowPageBreaks"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Format \[RightTriangle] Show Page Breaks",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ShowPageBreaks"],

Cell[TextData[{
  "\[FilledSmallSquare] This command toggles the option ",
  StyleBox["ShowPageBreaks", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected notebook."
}], "Notes",
  CellTags->"ShowPageBreaks"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ShowPageBreaks"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"GraphicsCoordinatesDialog\"", "ObjectName",
  CellTags->"GraphicsCoordinatesDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["GraphicsCoordinatesDialog", "MR"],
  "\" is a front end token that opens the Get Graphics Coordinates dialog box \
and explains how to get coordinates from graphics."
}], "Usage",
  CellTags->"GraphicsCoordinatesDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Get Graphics Coordinates",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"GraphicsCoordinatesDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"GraphicsCoordinatesDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ViewPointSelectorDialog\"", "ObjectName",
  CellTags->"ViewPointSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ViewPointSelectorDialog", "MR"],
  "\" is a front end token that opens the 3D ViewPoint Selector dialog box \
and lets you interactively select a viewpoint for three-dimensional \
graphics."
}], "Usage",
  CellTags->"ViewPointSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] 3D ViewPoint Selector",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ViewPointSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ViewPointSelectorDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ColorSelectorDialog\"", "ObjectName",
  CellTags->"ColorSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ColorSelectorDialog", "MR"],
  "\" is a front end token that lets you interactively select a color for ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " graphics. "
}], "Usage",
  CellTags->"ColorSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Color Selector",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ColorSelectorDialog"],

Cell["\<\
\[FilledSmallSquare] This token is available only on \
Macintosh.\
\>", "Notes",
  CellTags->"ColorSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ColorSelectorDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RecordSoundDialog\"", "ObjectName",
  CellTags->"RecordSoundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["RecordSoundDialog", "MR"],
  "\" is a front end token that lets you record a sound into ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " (microphone required)."
}], "Usage",
  CellTags->"RecordSoundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Record Sound",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"RecordSoundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"RecordSoundDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FileNameDialog\"", "ObjectName",
  CellTags->"FileNameDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FileNameDialog", "MR"],
  "\" is a front end token that opens a dialog box to retrieve the full \
pathname of a file."
}], "Usage",
  CellTags->"FileNameDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Get File Path",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"FileNameDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] When a file is selected, clicking ",
  StyleBox["Open",
    FontFamily->"Helvetica"],
  " pastes the full pathname of the file into the notebook at the current \
selection."
}], "Notes",
  CellTags->"FileNameDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"FileNameDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CreateGridBoxDialog\"", "ObjectName",
  CellTags->"CreateGridBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CreateGridBoxDialog", "MR"],
  "\" is a front end token that opens the Create Table/Matrix/Palette \
dialog."
}], "Usage",
  CellTags->"CreateGridBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Create Table/Matrix/Palette",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CreateGridBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CreateGridBoxDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CreateCustomButtonBox\"", "ObjectName",
  CellTags->"CreateCustomButtonBox"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CreateCustomButtonBox", "MR"],
  "\" is a front end token that wraps a ButtonBox around the current \
selection and then opens the Edit Button dialog box."
}], "Usage",
  CellTags->"CreateCustomButtonBox"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Create Button",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CreateCustomButtonBox"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CreateCustomButtonBox"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EditButtonBoxDialog\"", "ObjectName",
  CellTags->"EditButtonBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EditButtonBoxDialog", "MR"],
  "\" is a front end token that opens the Edit Button dialog box."
}], "Usage",
  CellTags->"EditButtonBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Edit Button",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EditButtonBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EditButtonBoxDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CreateHyperlinkDialog\"", "ObjectName",
  CellTags->"CreateHyperlinkDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CreateHyperlinkDialog", "MR"],
  "\" is a front end token that opens the Create Hyperlink dialog box."
}], "Usage",
  CellTags->"CreateHyperlinkDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Create Hyperlink",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CreateHyperlinkDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CreateHyperlinkDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CreateCounterBoxDialog\"", "ObjectName",
  CellTags->"CreateCounterBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CreateCounterBoxDialog", "MR"],
  "\" is a front end token that opens the Create Automatic Numbering Object \
dialog box."
}], "Usage",
  CellTags->"CreateCounterBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Create Automatic Numbering Object",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CreateCounterBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CreateCounterBoxDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CreateValueBoxDialog\"", "ObjectName",
  CellTags->"CreateValueBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CreateValueBoxDialog", "MR"],
  "\" is a front end token that opens the Create Value Display dialog box."
}], "Usage",
  CellTags->"CreateValueBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Create Automatic Numbering Object",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CreateValueBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CreateValueBoxDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DuplicatePreviousInput\"", "ObjectName",
  CellTags->"DuplicatePreviousInput"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["DuplicatePreviousInput", "MR"],
  "\" is a front end token that copies the contents of the nearest Input cell \
above the selection point at the insertion point."
}], "Usage",
  CellTags->"DuplicatePreviousInput"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Copy Input from Above",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"DuplicatePreviousInput"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"DuplicatePreviousInput"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DuplicatePreviousOutput\"", "ObjectName",
  CellTags->"DuplicatePreviousOutput"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["DuplicatePreviousOutput", "MR"],
  "\" is a front end token that copies the contents of the nearest Output \
cell above the selection point at the insertion point."
}], "Usage",
  CellTags->"DuplicatePreviousOutput"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Copy Output from Above",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"DuplicatePreviousOutput"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"DuplicatePreviousOutput"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SimilarCellBelow\"", "ObjectName",
  CellTags->"SimilarCellBelow"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SimilarCellBelow", "MR"],
  "\" is a front end token that creates a new cell below the selected cell \
with all the same styles and options as the selected cell."
}], "Usage",
  CellTags->"SimilarCellBelow"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Start New Cell Below",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SimilarCellBelow"],

Cell["\<\
\[FilledSmallSquare] Any selections are placed in the newly created \
cell.\
\>", "Notes",
  CellTags->"SimilarCellBelow"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SimilarCellBelow"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CompleteSelection\"", "ObjectName",
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CompleteSelection", "MR"],
  "\" is a front end token that completes a partially typed function name."
}], "Usage",
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Complete Selection",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This command reads your current selection (which \
should be a single word or an insertion point following a word) and looks up \
possible completions in the list of all currently defined functions and \
variables. See ",
  ButtonBox["Complete Selection",
    ButtonData:>{"Complete Selection"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CompleteSelection"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"TemplateSelection\"", "ObjectName",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["TemplateSelection", "MR"],
  "\" is a front end token that creates a template based on the currently \
selected function name. "
}], "Usage",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Input \[RightTriangle] Make Template",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This command reads your current selection (which \
should be a function name or insertion point after a function name) and adds \
a template for the arguments it can take. See ",
  ButtonBox["Make Template",
    ButtonData:>{"Make Template"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"TemplateSelection"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"EvaluateCells\"", "ObjectName",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EvaluateCells", "MR"],
  "\" is a front end token that sends the selected cells to the kernel for \
evaluation."
}], "Usage",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Evaluation \[RightTriangle] Evaluate \
Cells",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] Only cells with the option ",
  StyleBox["Evaluatable\[Rule]True", "MR"],
  " (normally cells in the Input style) will be evaluated. All other cells \
will be ignored. See ",
  ButtonBox["Evaluate Cells",
    ButtonData:>{"Evaluate Cells"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EvaluateCells"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Evaluate\"", "ObjectName",
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Evaluate", "MR"],
  "\" is a front end token that evaluates the selection in place."
}], "Usage",
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Evaluation \[RightTriangle] Evaluate In \
Place",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] Output is pasted over the selected input instead of \
in a separate output cell. See ",
  ButtonBox["Evaluate In Place",
    ButtonData:>{"Evaluation: Evaluate In Place"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Evaluate"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EvaluateNextCell\"", "ObjectName",
  CellTags->"EvaluateNextCell"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EvaluateNextCell", "MR"],
  "\" is a front end token that first selects and then evaluates the next \
input cell in the notebook."
}], "Usage",
  CellTags->"EvaluateNextCell"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Evaluation \[RightTriangle] Evaluate Next \
Input",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EvaluateNextCell"],

Cell["\<\
\[FilledSmallSquare] This front end token moves to and then \
evaluates the next input cell below the current selection. When the current \
selection is a single input cell, it is evaluated; otherwise, the next input \
cell after the current selection is selected. By repeatedly using this front \
end token, you can evaluate all the input cells in a notebook, one at a time. \

\[FilledSmallSquare] You need to use this front end token twice for each \
cell, once to select it and once to evaluate it. This allows you to see the \
next input before evaluating it, and is good for pre-programmed \
demonstrations.\
\>", "Notes",
  CellTags->"EvaluateNextCell"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EvaluateNextCell"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SubsessionEvaluateCells\"", "ObjectName",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SubsessionEvaluateCells", "MR"],
  "\" is a front end token that interrupts the current evaluation, evaluates \
the selected cells in a kernel subsession, and resumes the main evaluation."
}], "Usage",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Evaluation \[RightTriangle] Evaluate in \
Subsession",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] This can be useful for checking on the status of \
variables in a long calculation or for debugging. See ",
  ButtonBox["Dialog",
    ButtonStyle->"RefGuideLink"],
  " for more information."
}], "Notes",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SubsessionEvaluateCells"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EvaluateNotebook\"", "ObjectName",
  CellTags->"EvaluateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EvaluateNotebook", "MR"],
  "\" is a front end token that evaluates all the input cells in the current \
notebook."
}], "Usage",
  CellTags->"EvaluateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Evaluation \[RightTriangle] Evaluate \
Notebook",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EvaluateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EvaluateNotebook"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EvaluateInitialization\"", "ObjectName",
  CellTags->"EvaluateInitialization"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EvaluateInitialization", "MR"],
  "\" is a front end token that evaluates all the initialization cells in the \
current notebook."
}], "Usage",
  CellTags->"EvaluateInitialization"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Evaluation \[RightTriangle] Evaluate \
Notebook",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EvaluateInitialization"],

Cell[TextData[{
  "\[FilledSmallSquare] All cells with the options ",
  StyleBox["Evaluatable\[Rule]True", "SR"],
  " and ",
  StyleBox["InitializationCell\[Rule]True", "SR"],
  " will be evaluated. Normally, notebooks are set up so that these cells \
contain definitions needed to use other material in the notebook."
}], "Notes",
  CellTags->"EvaluateInitialization"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EvaluateInitialization"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EnterSubsession\"", "ObjectName",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EnterSubsession", "MR"],
  "\" is a front end token that starts an interactive session in the \
specified kernel during an evaluation."
}], "Usage",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Evaluation \[RightTriangle] Enter \
Subsession",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] This token requires a parameter, which can be the \
name of the kernel or ",
  StyleBox["Automatic", "MR"],
  " if you want the default kernel. See ",
  ButtonBox["Dialog",
    ButtonStyle->"RefGuideLink"],
  " or ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.14.2",
    ButtonData:>"2.14.2",
    ButtonStyle->"MainBookLink"],
  " for more information."
}], "Notes",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EnterSubsession"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ExitSubsession\"", "ObjectName",
  CellTags->"ExitSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ExitSubsession", "MR"],
  "\" is a front end token that ends an interactive session in the specified \
kernel."
}], "Usage",
  CellTags->"ExitSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Evaluation \[RightTriangle] Exit \
Subsession",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ExitSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] This token requires a parameter, which can be the \
name of the kernel (evaluator) or ",
  StyleBox["Automatic", "MR"],
  " if you want the default kernel."
}], "Notes",
  CellTags->"ExitSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ExitSubsession"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RemoveFromEvaluationQueue\"", "ObjectName",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["RemoveFromEvaluationQueue", "MR"],
  "\" is a front end token that cancels the pending evaluation of the \
selected cell."
}], "Usage",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Evaluation \[RightTriangle] Remove from  \
Evaluation Queue",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] To stop the evaluation of a cell that is currently \
being evaluated, use the front end token ",
  StyleBox["EvaluatorInterrupt", "MR"],
  " or ",
  StyleBox["EvaluatorAbort", "MR"],
  "."
}], "Notes",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"RemoveFromEvaluationQueue"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EvaluatorInterrupt\"", "ObjectName",
  CellTags->"EvaluatorInterrupt"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EvaluatorInterrupt", "MR"],
  "\" is a front end token that interrupts the current kernel operation in \
the specified kernel and opens the Kernel Interrupt dialog box"
}], "Usage",
  CellTags->"EvaluatorInterrupt"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Interrupt Evaluation",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EvaluatorInterrupt"],

Cell[TextData[{
  "\[FilledSmallSquare] This token requires a parameter, which can be the \
name of the kernel (evaluator) or ",
  StyleBox["Automatic", "MR"],
  " if you want the default kernel. See ",
  ButtonBox["Interrupt Evaluation...",
    ButtonData:>{"Interrupt Evaluation..."},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"EvaluatorInterrupt"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EvaluatorInterrupt"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EvaluatorAbort\"", "ObjectName",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EvaluatorAbort", "MR"],
  "\" is a front end token that aborts the current kernel operation in the \
specified kernel."
}], "Usage",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Abort Evaluation",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] This token requires a parameter, which can be the \
name of the kernel (evaluator) or ",
  StyleBox["Automatic", "MR"],
  " if you want the default kernel. "
}], "Notes",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EvaluatorAbort"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EvaluatorStart\"", "ObjectName",
  CellTags->"EvaluatorStart"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EvaluatorStart", "MR"],
  "\" is a front end token that starts the specified kernel."
}], "Usage",
  CellTags->"EvaluatorStart"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Start Kernel",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EvaluatorStart"],

Cell[TextData[{
  "\[FilledSmallSquare] This token requires a parameter, which can be the \
name of the kernel (evaluator) or ",
  StyleBox["Automatic", "MR"],
  " if you want the default kernel. See ",
  ButtonBox["Start Kernel",
    ButtonData:>{"Start Kernel"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"EvaluatorStart"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EvaluatorStart"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"EvaluatorQuit\"", "ObjectName",
  CellTags->"EvaluatorQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["EvaluatorQuit", "MR"],
  "\" is a front end token that terminates the specified kernel."
}], "Usage",
  CellTags->"EvaluatorQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Quit Kernel",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"EvaluatorQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] This token requires a parameter, which can be the \
name of the kernel (evaluator) or ",
  StyleBox["Automatic", "MR"],
  " if you want the default kernel. See ",
  ButtonBox["Quit Kernel",
    ButtonData:>{"Quit Kernel"},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"EvaluatorQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"EvaluatorQuit"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ModifyEvaluatorNames\"", "ObjectName",
  CellTags->"ModifyEvaluatorNames"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ModifyEvaluatorNames", "MR"],
  "\" is a front end token that opens a dialog box for adding, removing, and \
editing kernel names."
}], "Usage",
  CellTags->"ModifyEvaluatorNames"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Kernel Configuration Options",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ModifyEvaluatorNames"],

Cell[TextData[{
  "\[FilledSmallSquare] The kernel names that you define here are shown \
throughout the front end whenever you have a choice of kernels. See ",
  ButtonBox["Kernel Configuration Options...",
    ButtonData:>{"Kernel Configuration Options..."},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"ModifyEvaluatorNames"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ModifyEvaluatorNames"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ShowCellLabel\"", "ObjectName",
  CellTags->"ShowCellLabel"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ShowCellLabel", "MR"],
  "\" is a front end token that toggles the display of ",
  StyleBox["CellLabel", "MR"],
  "."
}], "Usage",
  CellTags->"ShowCellLabel"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Show In/Out Names",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ShowCellLabel"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ShowCellLabel"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DeleteGeneratedCells\"", "ObjectName",
  CellTags->"DeleteGeneratedCells"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["DeleteGeneratedCells", "MR"],
  "\" is a front end token that deletes all output cells in the current \
notebook."
}], "Usage",
  CellTags->"DeleteGeneratedCells"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command ",
  StyleBox["Kernel \[RightTriangle] Delete All Output",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"DeleteGeneratedCells"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"DeleteGeneratedCells"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Find", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"FindDialog\"", "ObjectName",
  CellTags->"FindDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FindDialog", "MR"],
  "\" is a front end token that opens the Find dialog box."
}], "Usage",
  CellTags->"FindDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Find",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"FindDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"FindDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectionSetFind\"", "ObjectName",
  CellTags->"SelectionSetFind"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectionSetFind", "MR"],
  "\" is a front end token that enters the current selection in the \"Search \
for:\" field of the Find dialog box"
}], "Usage",
  CellTags->"SelectionSetFind"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Enter Selection",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectionSetFind"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectionSetFind"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellTagsFind\"", "ObjectName",
  CellTags->"CellTagsFind"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellTagsFind", "MR"],
  "\" is a front end token that searches for a keyword in the ",
  StyleBox["CellTags", "MR"],
  " of all the cells in the selected notebook."
}], "Usage",
  CellTags->"CellTagsFind"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Find in Cell Tags",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CellTagsFind"],

Cell["\<\
\[FilledSmallSquare] This token requires a parameter that is the \
keyword.\
\>", "Notes",
  CellTags->"CellTagsFind"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command of the form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CellTagsFind"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Replace\"", "ObjectName",
  CellTags->"Replace"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Replace", "MR"],
  "\" is a front end token that changes the selected text to the replacement \
text."
}], "Usage",
  CellTags->"Replace"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Replace",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"Replace"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"Replace"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ReplaceFind\"", "ObjectName",
  CellTags->"ReplaceFind"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ReplaceFind", "MR"],
  "\" is a front end token that replaces the selected text with the \
replacement text and then finds the next occurrence of the search string. "
}], "Usage",
  CellTags->"ReplaceFind"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Replace and Find Again",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ReplaceFind"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ReplaceFind"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ReplaceAll\"", "ObjectName",
  CellTags->"ReplaceAll"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ReplaceAll", "MR"],
  "\" is a front end token that replaces all occurrences of the search string \
with the replacement text, starting with the current selection and continuing \
to the end of the file."
}], "Usage",
  CellTags->"ReplaceAll"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Replace All",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ReplaceAll"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ReplaceAll"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"OpenSelectionParents\"", "ObjectName",
  CellTags->"OpenSelectionParents"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["OpenSelectionParents", "MR"],
  "\" is a front end token that opens any groups that contain selected \
cells."
}], "Usage",
  CellTags->"OpenSelectionParents"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Open Selected",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"OpenSelectionParents"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"OpenSelectionParents"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectionScroll\"", "ObjectName",
  CellTags->"SelectionScroll"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectionScroll", "MR"],
  "\" is a front end token that scrolls to bring the top of the current \
selection to the top of the window if the selection is not currently \
visible."
}], "Usage",
  CellTags->"SelectionScroll"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Scroll to Selection",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectionScroll"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectionScroll"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"HyperlinkGoBack\"", "ObjectName",
  CellTags->"HyperlinkGoBack"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["HyperlinkGoBack", "MR"],
  "\" is a front end token that returns from a hyperlink jump to the place \
where you started."
}], "Usage",
  CellTags->"HyperlinkGoBack"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Go Back",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"HyperlinkGoBack"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"HyperlinkGoBack"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellTagsEditDialog\"", "ObjectName",
  CellTags->"CellTagsEditDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellTagsEditDialog", "MR"],
  "\" is a front end token that opens the Edit Cell Tags dialog box."
}], "Usage",
  CellTags->"CellTagsEditDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Add/Remove Cell Tags",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CellTagsEditDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Cell tags are used to find single cells or classes of \
cells. ",
  "See ",
  ButtonBox["Add/Remove Cell Tags...",
    ButtonData:>{"Add/Remove Cell Tags..."},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"CellTagsEditDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CellTagsEditDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ShowCellTags\"", "ObjectName",
  CellTags->"ShowCellTags"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ShowCellTags", "MR"],
  "\" is a front end token that toggles the display of cell tags in the \
selected notebook."
}], "Usage",
  CellTags->"ShowCellTags"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Show Cell Tags",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ShowCellTags"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ShowCellTags"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellLabelsToTags\"", "ObjectName",
  CellTags->"CellLabelsToTags"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellLabelsToTags", "MR"],
  "\" is a front end token that creates a ",
  StyleBox["CellTag", "MR"],
  " for each selected cell matching that cell's ",
  StyleBox["CellLabel", "MR"],
  "."
}], "Usage",
  CellTags->"CellLabelsToTags"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Cell Tags from In/Out Names",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CellLabelsToTags"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CellLabelsToTags"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CreateIndexDialog\"", "ObjectName",
  CellTags->"CreateIndexDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CreateIndexDialog", "MR"],
  "\" is a front end token that opens the Make Index dialog box."
}], "Usage",
  CellTags->"CreateIndexDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Find \[RightTriangle] Make Index",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"CreateIndexDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] When a cell has a cell tag, an entry is created in \
the index with that keyword and its corresponding page number(s). See ",
  ButtonBox["Make Index...",
    ButtonData:>{"Make Index..."},
    ButtonStyle->"OtherInformationLink"],
  " for more information."
}], "Notes",
  CellTags->"CreateIndexDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"CreateIndexDialog"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Windows", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"StackWindows\"", "ObjectName",
  CellTags->"StackWindows"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["StackWindows", "MR"],
  "\" is a front end token that arranges windows in a uniform overlapping \
stack on the screen."
}], "Usage",
  CellTags->"StackWindows"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Window \[RightTriangle] Stack Windows",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"StackWindows"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"StackWindows"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"TileWindowsWide\"", "ObjectName",
  CellTags->"TileWindowsWide"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["TileWindowsWide", "MR"],
  "\" is a front end token that arranges all windows to fit on the screen, \
preferring width over height."
}], "Usage",
  CellTags->"TileWindowsWide"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Window \[RightTriangle] Tile Windows Wide",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"TileWindowsWide"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"TileWindowsWide"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"TileWindowsTall\"", "ObjectName",
  CellTags->"TileWindowsTall"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["TileWindowsTall", "MR"],
  "\" is a front end token that arranges all windows to fit on the screen, \
preferring height over width."
}], "Usage",
  CellTags->"TileWindowsTall"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Window \[RightTriangle] Tile Windows Tall",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"TileWindowsTall"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"TileWindowsTall"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Help", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"HelpDialog\"", "ObjectName",
  CellTags->"HelpDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["HelpDialog", "MR"],
  "\" is a front end token that opens the Help Browser."
}], "Usage",
  CellTags->"HelpDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Help \[RightTriangle] Help Browser",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"HelpDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"HelpDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectionHelpDialog\"", "ObjectName",
  CellTags->"SelectionHelpDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectionHelpDialog", "MR"],
  "\" is a front end token that looks up the currently selected text in the \
Help Browser."
}], "Usage",
  CellTags->"SelectionHelpDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Help \[RightTriangle] Find Selected Function",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"SelectionHelpDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectionHelpDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ExplainBeepDialog\"", "ObjectName",
  CellTags->"ExplainBeepDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ExplainBeepDialog", "MR"],
  "\" is a front end token that brings up the Why the Beep? dialog box with \
an explanation of why the front end produced a beep."
}], "Usage",
  CellTags->"ExplainBeepDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Help \[RightTriangle] Why the Beep?",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"ExplainBeepDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"ExplainBeepDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"AboutBoxDialog\"", "ObjectName",
  CellTags->"AboutBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["AboutBoxDialog", "MR"],
  "\" is a front end token that brings up a notebook containing information \
about ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Usage",
  CellTags->"AboutBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Help \[RightTriangle] About ",
    FontFamily->"Helvetica"],
  StyleBox["Mathematica",
    FontFamily->"Helvetica",
    FontSlant->"Italic"],
  StyleBox["?",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"AboutBoxDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"AboutBoxDialog"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RebuildHelpIndex\"", "ObjectName",
  CellTags->"RebuildHelpIndex"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["RebuildHelpIndex", "MR"],
  "\" is a front end token that ",
  StyleBox["rebuilds the categories and index for the Help Browser", "Text"],
  "."
}], "Usage",
  CellTags->"RebuildHelpIndex"],

Cell[TextData[{
  "\[FilledSmallSquare] This token is equivalent to the menu command",
  StyleBox[" Help \[RightTriangle] Rebuild Help Index",
    FontFamily->"Helvetica"],
  "."
}], "Notes",
  CellTags->"RebuildHelpIndex"],

Cell["\<\
\[FilledSmallSquare] Use this command when you have installed an \
add-on package or modified documentation files.\
\>", "Notes",
  CellTags->"RebuildHelpIndex"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"RebuildHelpIndex"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Miscellaneous", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["\"AddFrame\"", "ObjectName",
  CellTags->"AddFrame"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["AddFrame", "MR"],
  "\" is a front end token that ",
  StyleBox["adds a frame around the current selection.", "Text"]
}], "Usage",
  CellTags->"AddFrame"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"AddFrame"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FixCellHeight\"", "ObjectName",
  CellTags->"FixCellHeight"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FixCellHeight", "MR"],
  "\" is a front end token that assigns a ",
  StyleBox["CellSize", "MR"],
  " option to the currently selected cells to fix their height at their \
current height."
}], "Usage",
  CellTags->"FixCellHeight"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"FixCellHeight"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MoveNextCell\"", "ObjectName",
  CellTags->"MoveNextCell"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"MoveNextCell\"", "MR"],
  " is a front end token that moves the insertion point down by one cell."
}], "Usage",
  CellTags->"MoveNextCell"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"MoveNextCell"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SelectTerminalWindow\"", "ObjectName",
  CellTags->"SelectTerminalWindow"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SelectTerminalWindow", "MR"],
  "\" is a front end token that opens a terminal window to the machine \
specified by a particular kernel name."
}], "Usage",
  CellTags->"SelectTerminalWindow"],

Cell["\<\
\[FilledSmallSquare] This token requires a parameter that is the \
kernel name. The name must specify a connection to a remote UNIX host.
\[FilledSmallSquare] This token always opens a new terminal window; it does \
not select one that already exists.\
\>", "Notes",
  CellTags->"SelectTerminalWindow"],

Cell[TextData[{
  "\[FilledSmallSquare] To execute a front end token, you typically evaluate \
a command ",
  "of the",
  " form ",
  StyleBox["FrontEndExecute[FrontEndToken[", "MR"],
  StyleBox["token", "TI"],
  StyleBox["]]", "MR"],
  "."
}], "Notes",
  CellTags->"SelectTerminalWindow"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1152}, {0, 848}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{767, 627},
WindowMargins->{{-2, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "FrontEndTokenIntro"->{
    Cell[1836, 57, 68, 1, 36, "Subsection",
      CellTags->"FrontEndTokenIntro"],
    Cell[1907, 60, 568, 12, 56, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[2478, 74, 603, 17, 56, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[3084, 93, 678, 17, 56, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[3765, 112, 133, 3, 26, "Input",
      CellTags->"FrontEndTokenIntro"],
    Cell[3901, 117, 587, 15, 56, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[4491, 134, 164, 4, 26, "Input",
      CellTags->"FrontEndTokenIntro"],
    Cell[4680, 142, 85, 1, 34, "Subsubsection",
      CellTags->"FrontEndTokenIntro"],
    Cell[4768, 145, 352, 7, 56, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[5157, 157, 76, 1, 24, "SubsubsectionIcon",
      CellTags->"FrontEndTokenIntro"],
    Cell[5236, 160, 451, 11, 56, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[5690, 173, 289, 9, 40, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[5982, 184, 133, 3, 26, "Input",
      CellTags->"FrontEndTokenIntro"],
    Cell[6118, 189, 457, 10, 56, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[6578, 201, 175, 5, 26, "Input",
      CellTags->"FrontEndTokenIntro"],
    Cell[6756, 208, 586, 18, 68, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[7379, 231, 78, 1, 37, "SubsubsectionIcon",
      CellTags->"FrontEndTokenIntro"],
    Cell[7460, 234, 793, 19, 97, "Text",
      CellTags->"FrontEndTokenIntro"],
    Cell[8256, 255, 206, 5, 56, "Input",
      CellTags->"FrontEndTokenIntro"],
    Cell[8465, 262, 306, 7, 52, "Text",
      CellTags->"FrontEndTokenIntro"]},
  "New"->{
    Cell[9207, 291, 48, 1, 55, "ObjectName",
      CellTags->"New"],
    Cell[9258, 294, 159, 5, 44, "Usage",
      CellTags->"New"],
    Cell[9420, 301, 195, 6, 37, "Notes",
      CellTags->"New"],
    Cell[9618, 309, 260, 8, 52, "Notes",
      CellTags->"New"]},
  "Open"->{
    Cell[9915, 322, 50, 1, 55, "ObjectName",
      CellTags->"Open"],
    Cell[9968, 325, 206, 6, 44, "Usage",
      CellTags->"Open"],
    Cell[10177, 333, 203, 7, 37, "Notes",
      CellTags->"Open"],
    Cell[10383, 342, 261, 8, 52, "Notes",
      CellTags->"Open"]},
  "Close"->{
    Cell[10681, 355, 52, 1, 55, "ObjectName",
      CellTags->"Close"],
    Cell[10736, 358, 178, 5, 44, "Usage",
      CellTags->"Close"],
    Cell[10917, 365, 199, 6, 37, "Notes",
      CellTags->"Close"],
    Cell[11119, 373, 262, 8, 52, "Notes",
      CellTags->"Close"]},
  "Save"->{
    Cell[11418, 386, 50, 1, 55, "ObjectName",
      CellTags->"Save"],
    Cell[11471, 389, 175, 5, 44, "Usage",
      CellTags->"Save"],
    Cell[11649, 396, 197, 6, 37, "Notes",
      CellTags->"Save"],
    Cell[11849, 404, 261, 8, 52, "Notes",
      CellTags->"Save"]},
  "SaveRename"->{
    Cell[12147, 417, 62, 1, 55, "ObjectName",
      CellTags->"SaveRename"],
    Cell[12212, 420, 192, 5, 44, "Usage",
      CellTags->"SaveRename"],
    Cell[12407, 427, 206, 6, 37, "Notes",
      CellTags->"SaveRename"],
    Cell[12616, 435, 267, 8, 52, "Notes",
      CellTags->"SaveRename"]},
  "SaveRenameSpecial"->{
    Cell[12920, 448, 76, 1, 55, "ObjectName",
      CellTags->"SaveRenameSpecial"],
    Cell[12999, 451, 219, 6, 44, "Usage",
      CellTags->"SaveRenameSpecial"],
    Cell[13221, 459, 221, 6, 37, "Notes",
      CellTags->"SaveRenameSpecial"],
    Cell[13445, 467, 150, 4, 36, "Notes",
      CellTags->"SaveRenameSpecial"],
    Cell[13598, 473, 2246, 57, 151, "2ColumnTable",
      CellTags->"SaveRenameSpecial"],
    Cell[15847, 532, 274, 8, 52, "Notes",
      CellTags->"SaveRenameSpecial"]},
  "Revert"->{
    Cell[16158, 545, 54, 1, 55, "ObjectName",
      CellTags->"Revert"],
    Cell[16215, 548, 191, 6, 44, "Usage",
      CellTags->"Revert"],
    Cell[16409, 556, 201, 6, 37, "Notes",
      CellTags->"Revert"],
    Cell[16613, 564, 263, 8, 52, "Notes",
      CellTags->"Revert"]},
  "OpenSpecial"->{
    Cell[16913, 577, 64, 1, 55, "ObjectName",
      CellTags->"OpenSpecial"],
    Cell[16980, 580, 185, 5, 44, "Usage",
      CellTags->"OpenSpecial"],
    Cell[17168, 587, 212, 6, 37, "Notes",
      CellTags->"OpenSpecial"],
    Cell[17383, 595, 268, 8, 52, "Notes",
      CellTags->"OpenSpecial"]},
  "Import"->{
    Cell[17688, 608, 54, 1, 55, "ObjectName",
      CellTags->"Import"],
    Cell[17745, 611, 257, 6, 60, "Usage",
      CellTags->"Import"],
    Cell[18005, 619, 201, 6, 37, "Notes",
      CellTags->"Import"],
    Cell[18209, 627, 263, 8, 52, "Notes",
      CellTags->"Import"]},
  "NotebookMail"->{
    Cell[18509, 640, 66, 1, 55, "ObjectName",
      CellTags->"NotebookMail"],
    Cell[18578, 643, 248, 6, 60, "Usage",
      CellTags->"NotebookMail"],
    Cell[18829, 651, 208, 6, 37, "Notes",
      CellTags->"NotebookMail"],
    Cell[19040, 659, 269, 8, 52, "Notes",
      CellTags->"NotebookMail"]},
  "NotebookMailSelection"->{
    Cell[19346, 672, 84, 1, 55, "ObjectName",
      CellTags->"NotebookMailSelection"],
    Cell[19433, 675, 276, 6, 60, "Usage",
      CellTags->"NotebookMailSelection"],
    Cell[19712, 683, 224, 6, 37, "Notes",
      CellTags->"NotebookMailSelection"],
    Cell[19939, 691, 278, 8, 52, "Notes",
      CellTags->"NotebookMailSelection"]},
  "GeneratePalette"->{
    Cell[20254, 704, 72, 1, 55, "ObjectName",
      CellTags->"GeneratePalette"],
    Cell[20329, 707, 196, 5, 44, "Usage",
      CellTags->"GeneratePalette"],
    Cell[20528, 714, 235, 6, 37, "Notes",
      CellTags->"GeneratePalette"],
    Cell[20766, 722, 272, 8, 52, "Notes",
      CellTags->"GeneratePalette"]},
  "GenerateNotebook"->{
    Cell[21075, 735, 74, 1, 55, "ObjectName",
      CellTags->"GenerateNotebook"],
    Cell[21152, 738, 208, 6, 44, "Usage",
      CellTags->"GenerateNotebook"],
    Cell[21363, 746, 235, 6, 37, "Notes",
      CellTags->"GenerateNotebook"],
    Cell[21601, 754, 273, 8, 52, "Notes",
      CellTags->"GenerateNotebook"]},
  "SystemPrintOptionsDialog"->{
    Cell[21911, 767, 90, 1, 55, "ObjectName",
      CellTags->"SystemPrintOptionsDialog"],
    Cell[22004, 770, 209, 5, 44, "Usage",
      CellTags->"SystemPrintOptionsDialog"],
    Cell[22216, 777, 260, 7, 37, "Notes",
      CellTags->"SystemPrintOptionsDialog"],
    Cell[22479, 786, 281, 8, 52, "Notes",
      CellTags->"SystemPrintOptionsDialog"]},
  "PrintOptionsDialog"->{
    Cell[22797, 799, 78, 1, 55, "ObjectName",
      CellTags->"PrintOptionsDialog"],
    Cell[22878, 802, 203, 5, 44, "Usage",
      CellTags->"PrintOptionsDialog"],
    Cell[23084, 809, 260, 7, 37, "Notes",
      CellTags->"PrintOptionsDialog"],
    Cell[23347, 818, 275, 8, 52, "Notes",
      CellTags->"PrintOptionsDialog"]},
  "HeadersFootersDialog"->{
    Cell[23659, 831, 82, 1, 55, "ObjectName",
      CellTags->"HeadersFootersDialog"],
    Cell[23744, 834, 206, 5, 44, "Usage",
      CellTags->"HeadersFootersDialog"],
    Cell[23953, 841, 265, 7, 37, "Notes",
      CellTags->"HeadersFootersDialog"],
    Cell[24221, 850, 277, 8, 52, "Notes",
      CellTags->"HeadersFootersDialog"]},
  "PrintDialog"->{
    Cell[24535, 863, 64, 1, 55, "ObjectName",
      CellTags->"PrintDialog"],
    Cell[24602, 866, 237, 7, 44, "Usage",
      CellTags->"PrintDialog"],
    Cell[24842, 875, 205, 6, 37, "Notes",
      CellTags->"PrintDialog"],
    Cell[25050, 883, 268, 8, 52, "Notes",
      CellTags->"PrintDialog"]},
  "PrintSelectionDialog"->{
    Cell[25355, 896, 82, 1, 55, "ObjectName",
      CellTags->"PrintSelectionDialog"],
    Cell[25440, 899, 265, 7, 60, "Usage",
      CellTags->"PrintSelectionDialog"],
    Cell[25708, 908, 224, 6, 37, "Notes",
      CellTags->"PrintSelectionDialog"],
    Cell[25935, 916, 277, 8, 52, "Notes",
      CellTags->"PrintSelectionDialog"]},
  "FrontEndQuit"->{
    Cell[26249, 929, 66, 1, 55, "ObjectName",
      CellTags->"FrontEndQuit"],
    Cell[26318, 932, 251, 6, 60, "Usage",
      CellTags->"FrontEndQuit"],
    Cell[26572, 940, 205, 6, 37, "Notes",
      CellTags->"FrontEndQuit"],
    Cell[26780, 948, 269, 8, 52, "Notes",
      CellTags->"FrontEndQuit"]},
  "Undo"->{
    Cell[27153, 966, 50, 1, 55, "ObjectName",
      CellTags->"Undo"],
    Cell[27206, 969, 185, 6, 44, "Usage",
      CellTags->"Undo"],
    Cell[27394, 977, 197, 6, 37, "Notes",
      CellTags->"Undo"],
    Cell[27594, 985, 269, 6, 52, "Notes",
      CellTags->"Undo"],
    Cell[27866, 993, 261, 8, 52, "Notes",
      CellTags->"Undo"]},
  "Cut"->{
    Cell[28164, 1006, 48, 1, 55, "ObjectName",
      CellTags->"Cut"],
    Cell[28215, 1009, 209, 6, 44, "Usage",
      CellTags->"Cut"],
    Cell[28427, 1017, 195, 6, 37, "Notes",
      CellTags->"Cut"],
    Cell[28625, 1025, 190, 6, 36, "Notes",
      CellTags->"Cut"],
    Cell[28818, 1033, 260, 8, 52, "Notes",
      CellTags->"Cut"]},
  "Copy"->{
    Cell[29115, 1046, 50, 1, 55, "ObjectName",
      CellTags->"Copy"],
    Cell[29168, 1049, 216, 6, 44, "Usage",
      CellTags->"Copy"],
    Cell[29387, 1057, 197, 6, 37, "Notes",
      CellTags->"Copy"],
    Cell[29587, 1065, 190, 6, 36, "Notes",
      CellTags->"Copy"],
    Cell[29780, 1073, 261, 8, 52, "Notes",
      CellTags->"Copy"]},
  "Paste"->{
    Cell[30078, 1086, 52, 1, 55, "ObjectName",
      CellTags->"Paste"],
    Cell[30133, 1089, 210, 6, 44, "Usage",
      CellTags->"Paste"],
    Cell[30346, 1097, 666, 18, 88, "Notes",
      CellTags->"Paste"],
    Cell[31015, 1117, 262, 8, 52, "Notes",
      CellTags->"Paste"]},
  "Clear"->{
    Cell[31314, 1130, 52, 1, 55, "ObjectName",
      CellTags->"Clear"],
    Cell[31369, 1133, 199, 6, 44, "Usage",
      CellTags->"Clear"],
    Cell[31571, 1141, 199, 6, 37, "Notes",
      CellTags->"Clear"],
    Cell[31773, 1149, 262, 8, 52, "Notes",
      CellTags->"Clear"]},
  "CopySpecial"->{
    Cell[32072, 1162, 64, 1, 55, "ObjectName",
      CellTags->"CopySpecial"],
    Cell[32139, 1165, 229, 6, 60, "Usage",
      CellTags->"CopySpecial"],
    Cell[32371, 1173, 207, 6, 37, "Notes",
      CellTags->"CopySpecial"],
    Cell[32581, 1181, 145, 5, 56, "Notes",
      CellTags->"CopySpecial"],
    Cell[32729, 1188, 4242, 100, 268, "2ColumnTable",
      CellTags->"CopySpecial"],
    Cell[36974, 1290, 280, 10, 52, "Notes",
      CellTags->"CopySpecial"]},
  "PasteSpecial"->{
    Cell[37291, 1305, 66, 1, 55, "ObjectName",
      CellTags->"PasteSpecial"],
    Cell[37360, 1308, 239, 6, 60, "Usage",
      CellTags->"PasteSpecial"],
    Cell[37602, 1316, 209, 6, 37, "Notes",
      CellTags->"PasteSpecial"],
    Cell[37814, 1324, 145, 4, 36, "Notes",
      CellTags->"PasteSpecial"],
    Cell[37962, 1330, 1213, 30, 95, "2ColumnTable",
      CellTags->"PasteSpecial"],
    Cell[39178, 1362, 269, 8, 52, "Notes",
      CellTags->"PasteSpecial"]},
  "PasteApply"->{
    Cell[39484, 1375, 62, 1, 55, "ObjectName",
      CellTags->"PasteApply"],
    Cell[39549, 1378, 331, 8, 60, "Usage",
      CellTags->"PasteApply"],
    Cell[39883, 1388, 240, 6, 37, "Notes",
      CellTags->"PasteApply"],
    Cell[40126, 1396, 267, 8, 52, "Notes",
      CellTags->"PasteApply"]},
  "PasteDiscard"->{
    Cell[40430, 1409, 66, 1, 55, "ObjectName",
      CellTags->"PasteDiscard"],
    Cell[40499, 1412, 280, 7, 60, "Usage",
      CellTags->"PasteDiscard"],
    Cell[40782, 1421, 246, 7, 37, "Notes",
      CellTags->"PasteDiscard"],
    Cell[41031, 1430, 292, 7, 52, "Notes",
      CellTags->"PasteDiscard"],
    Cell[41326, 1439, 269, 8, 52, "Notes",
      CellTags->"PasteDiscard"]},
  "SelectionSaveSpecial"->{
    Cell[41632, 1452, 82, 1, 55, "ObjectName",
      CellTags->"SelectionSaveSpecial"],
    Cell[41717, 1455, 247, 6, 60, "Usage",
      CellTags->"SelectionSaveSpecial"],
    Cell[41967, 1463, 226, 6, 37, "Notes",
      CellTags->"SelectionSaveSpecial"],
    Cell[42196, 1471, 153, 4, 36, "Notes",
      CellTags->"SelectionSaveSpecial"],
    Cell[42352, 1477, 5186, 122, 325, "2ColumnTable",
      CellTags->"SelectionSaveSpecial"],
    Cell[47541, 1601, 277, 8, 52, "Notes",
      CellTags->"SelectionSaveSpecial"]},
  "SelectAll"->{
    Cell[47855, 1614, 60, 1, 55, "ObjectName",
      CellTags->"SelectAll"],
    Cell[47918, 1617, 195, 6, 44, "Usage",
      CellTags->"SelectAll"],
    Cell[48116, 1625, 208, 6, 37, "Notes",
      CellTags->"SelectAll"],
    Cell[48327, 1633, 266, 8, 52, "Notes",
      CellTags->"SelectAll"]},
  "InsertObject"->{
    Cell[48630, 1646, 66, 1, 55, "ObjectName",
      CellTags->"InsertObject"],
    Cell[48699, 1649, 250, 6, 60, "Usage",
      CellTags->"InsertObject"],
    Cell[48952, 1657, 217, 6, 37, "Notes",
      CellTags->"InsertObject"],
    Cell[49172, 1665, 116, 4, 36, "Notes",
      CellTags->"InsertObject"],
    Cell[49291, 1671, 269, 8, 52, "Notes",
      CellTags->"InsertObject"]},
  "MoveNext"->{
    Cell[49597, 1684, 58, 1, 55, "ObjectName",
      CellTags->"MoveNext"],
    Cell[49658, 1687, 196, 6, 44, "Usage",
      CellTags->"MoveNext"],
    Cell[49857, 1695, 230, 6, 37, "Notes",
      CellTags->"MoveNext"],
    Cell[50090, 1703, 265, 8, 52, "Notes",
      CellTags->"MoveNext"]},
  "MovePrevious"->{
    Cell[50392, 1716, 66, 1, 55, "ObjectName",
      CellTags->"MovePrevious"],
    Cell[50461, 1719, 203, 6, 44, "Usage",
      CellTags->"MovePrevious"],
    Cell[50667, 1727, 238, 6, 37, "Notes",
      CellTags->"MovePrevious"],
    Cell[50908, 1735, 269, 8, 52, "Notes",
      CellTags->"MovePrevious"]},
  "DeleteNext"->{
    Cell[51214, 1748, 62, 1, 55, "ObjectName",
      CellTags->"DeleteNext"],
    Cell[51279, 1751, 209, 6, 44, "Usage",
      CellTags->"DeleteNext"],
    Cell[51491, 1759, 234, 6, 37, "Notes",
      CellTags->"DeleteNext"],
    Cell[51728, 1767, 267, 8, 52, "Notes",
      CellTags->"DeleteNext"]},
  "DeletePrevious"->{
    Cell[52032, 1780, 70, 1, 55, "ObjectName",
      CellTags->"DeletePrevious"],
    Cell[52105, 1783, 216, 6, 44, "Usage",
      CellTags->"DeletePrevious"],
    Cell[52324, 1791, 242, 6, 37, "Notes",
      CellTags->"DeletePrevious"],
    Cell[52569, 1799, 271, 8, 52, "Notes",
      CellTags->"DeletePrevious"]},
  "MoveNextWord"->{
    Cell[52877, 1812, 66, 1, 55, "ObjectName",
      CellTags->"MoveNextWord"],
    Cell[52946, 1815, 197, 5, 44, "Usage",
      CellTags->"MoveNextWord"],
    Cell[53146, 1822, 239, 6, 37, "Notes",
      CellTags->"MoveNextWord"],
    Cell[53388, 1830, 269, 8, 52, "Notes",
      CellTags->"MoveNextWord"]},
  "MovePreviousWord"->{
    Cell[53694, 1843, 74, 1, 55, "ObjectName",
      CellTags->"MovePreviousWord"],
    Cell[53771, 1846, 204, 5, 44, "Usage",
      CellTags->"MovePreviousWord"],
    Cell[53978, 1853, 252, 7, 37, "Notes",
      CellTags->"MovePreviousWord"],
    Cell[54233, 1862, 273, 8, 52, "Notes",
      CellTags->"MovePreviousWord"]},
  "DeleteNextWord"->{
    Cell[54543, 1875, 70, 1, 55, "ObjectName",
      CellTags->"DeleteNextWord"],
    Cell[54616, 1878, 212, 6, 44, "Usage",
      CellTags->"DeleteNextWord"],
    Cell[54831, 1886, 243, 6, 37, "Notes",
      CellTags->"DeleteNextWord"],
    Cell[55077, 1894, 271, 8, 52, "Notes",
      CellTags->"DeleteNextWord"]},
  "DeletePreviousWord"->{
    Cell[55385, 1907, 78, 1, 55, "ObjectName",
      CellTags->"DeletePreviousWord"],
    Cell[55466, 1910, 219, 6, 44, "Usage",
      CellTags->"DeletePreviousWord"],
    Cell[55688, 1918, 253, 7, 37, "Notes",
      CellTags->"DeletePreviousWord"],
    Cell[55944, 1927, 275, 8, 52, "Notes",
      CellTags->"DeletePreviousWord"]},
  "MoveLineEnd"->{
    Cell[56256, 1940, 64, 1, 55, "ObjectName",
      CellTags->"MoveLineEnd"],
    Cell[56323, 1943, 210, 6, 44, "Usage",
      CellTags->"MoveLineEnd"],
    Cell[56536, 1951, 237, 6, 37, "Notes",
      CellTags->"MoveLineEnd"],
    Cell[56776, 1959, 268, 8, 52, "Notes",
      CellTags->"MoveLineEnd"]},
  "MoveLineBeginning"->{
    Cell[57081, 1972, 76, 1, 55, "ObjectName",
      CellTags->"MoveLineBeginning"],
    Cell[57160, 1975, 228, 6, 60, "Usage",
      CellTags->"MoveLineBeginning"],
    Cell[57391, 1983, 251, 7, 37, "Notes",
      CellTags->"MoveLineBeginning"],
    Cell[57645, 1992, 274, 8, 52, "Notes",
      CellTags->"MoveLineBeginning"]},
  "MoveNextLine"->{
    Cell[57956, 2005, 66, 1, 55, "ObjectName",
      CellTags->"MoveNextLine"],
    Cell[58025, 2008, 196, 5, 44, "Usage",
      CellTags->"MoveNextLine"],
    Cell[58224, 2015, 239, 6, 37, "Notes",
      CellTags->"MoveNextLine"],
    Cell[58466, 2023, 269, 8, 52, "Notes",
      CellTags->"MoveNextLine"]},
  "MovePreviousLine"->{
    Cell[58772, 2036, 74, 1, 55, "ObjectName",
      CellTags->"MovePreviousLine"],
    Cell[58849, 2039, 202, 5, 44, "Usage",
      CellTags->"MovePreviousLine"],
    Cell[59054, 2046, 252, 7, 37, "Notes",
      CellTags->"MovePreviousLine"],
    Cell[59309, 2055, 273, 8, 52, "Notes",
      CellTags->"MovePreviousLine"]},
  "Superscript"->{
    Cell[59619, 2068, 64, 1, 55, "ObjectName",
      CellTags->"Superscript"],
    Cell[59686, 2071, 251, 7, 60, "Usage",
      CellTags->"Superscript"],
    Cell[59940, 2080, 247, 7, 37, "Notes",
      CellTags->"Superscript"],
    Cell[60190, 2089, 227, 6, 52, "Notes",
      CellTags->"Superscript"],
    Cell[60420, 2097, 268, 8, 52, "Notes",
      CellTags->"Superscript"]},
  "Subscript"->{
    Cell[60725, 2110, 60, 1, 55, "ObjectName",
      CellTags->"Subscript"],
    Cell[60788, 2113, 245, 7, 60, "Usage",
      CellTags->"Subscript"],
    Cell[61036, 2122, 243, 7, 37, "Notes",
      CellTags->"Subscript"],
    Cell[61282, 2131, 223, 6, 36, "Notes",
      CellTags->"Subscript"],
    Cell[61508, 2139, 266, 8, 52, "Notes",
      CellTags->"Subscript"]},
  "Above"->{
    Cell[61811, 2152, 52, 1, 55, "ObjectName",
      CellTags->"Above"],
    Cell[61866, 2155, 239, 7, 60, "Usage",
      CellTags->"Above"],
    Cell[62108, 2164, 233, 6, 37, "Notes",
      CellTags->"Above"],
    Cell[62344, 2172, 215, 6, 36, "Notes",
      CellTags->"Above"],
    Cell[62562, 2180, 262, 8, 52, "Notes",
      CellTags->"Above"]},
  "Below"->{
    Cell[62861, 2193, 52, 1, 55, "ObjectName",
      CellTags->"Below"],
    Cell[62916, 2196, 240, 7, 60, "Usage",
      CellTags->"Below"],
    Cell[63159, 2205, 233, 6, 37, "Notes",
      CellTags->"Below"],
    Cell[63395, 2213, 215, 6, 36, "Notes",
      CellTags->"Below"],
    Cell[63613, 2221, 262, 8, 52, "Notes",
      CellTags->"Below"]},
  "Otherscript"->{
    Cell[63912, 2234, 64, 1, 55, "ObjectName",
      CellTags->"Otherscript"],
    Cell[63979, 2237, 206, 6, 44, "Usage",
      CellTags->"Otherscript"],
    Cell[64188, 2245, 253, 7, 37, "Notes",
      CellTags->"Otherscript"],
    Cell[64444, 2254, 730, 14, 157, "Notes",
      CellTags->"Otherscript"],
    Cell[65177, 2270, 268, 8, 52, "Notes",
      CellTags->"Otherscript"]},
  "Fraction"->{
    Cell[65482, 2283, 58, 1, 55, "ObjectName",
      CellTags->"Fraction"],
    Cell[65543, 2286, 246, 7, 60, "Usage",
      CellTags->"Fraction"],
    Cell[65792, 2295, 244, 7, 37, "Notes",
      CellTags->"Fraction"],
    Cell[66039, 2304, 222, 6, 36, "Notes",
      CellTags->"Fraction"],
    Cell[66264, 2312, 265, 8, 52, "Notes",
      CellTags->"Fraction"]},
  "Radical"->{
    Cell[66566, 2325, 56, 1, 55, "ObjectName",
      CellTags->"Radical"],
    Cell[66625, 2328, 235, 7, 44, "Usage",
      CellTags->"Radical"],
    Cell[66863, 2337, 237, 6, 37, "Notes",
      CellTags->"Radical"],
    Cell[67103, 2345, 179, 5, 36, "Notes",
      CellTags->"Radical"],
    Cell[67285, 2352, 264, 8, 52, "Notes",
      CellTags->"Radical"]},
  "NewRow"->{
    Cell[67586, 2365, 54, 1, 55, "ObjectName",
      CellTags->"NewRow"],
    Cell[67643, 2368, 203, 7, 44, "Usage",
      CellTags->"NewRow"],
    Cell[67849, 2377, 236, 6, 37, "Notes",
      CellTags->"NewRow"],
    Cell[68088, 2385, 176, 7, 36, "Notes",
      CellTags->"NewRow"],
    Cell[68267, 2394, 263, 8, 52, "Notes",
      CellTags->"NewRow"]},
  "NewColumn"->{
    Cell[68567, 2407, 60, 1, 55, "ObjectName",
      CellTags->"NewColumn"],
    Cell[68630, 2410, 216, 7, 44, "Usage",
      CellTags->"NewColumn"],
    Cell[68849, 2419, 244, 7, 37, "Notes",
      CellTags->"NewColumn"],
    Cell[69096, 2428, 182, 7, 36, "Notes",
      CellTags->"NewColumn"],
    Cell[69281, 2437, 266, 8, 52, "Notes",
      CellTags->"NewColumn"]},
  "MoveExpressionEnd"->{
    Cell[69584, 2450, 76, 1, 55, "ObjectName",
      CellTags->"MoveExpressionEnd"],
    Cell[69663, 2453, 232, 6, 60, "Usage",
      CellTags->"MoveExpressionEnd"],
    Cell[69898, 2461, 259, 7, 37, "Notes",
      CellTags->"MoveExpressionEnd"],
    Cell[70160, 2470, 274, 8, 52, "Notes",
      CellTags->"MoveExpressionEnd"]},
  "ExpandSelection"->{
    Cell[70471, 2483, 72, 1, 55, "ObjectName",
      CellTags->"ExpandSelection"],
    Cell[70546, 2486, 232, 6, 60, "Usage",
      CellTags->"ExpandSelection"],
    Cell[70781, 2494, 256, 7, 37, "Notes",
      CellTags->"ExpandSelection"],
    Cell[71040, 2503, 162, 5, 36, "Notes",
      CellTags->"ExpandSelection"],
    Cell[71205, 2510, 272, 8, 52, "Notes",
      CellTags->"ExpandSelection"]},
  "CreateInlineCell"->{
    Cell[71514, 2523, 74, 1, 55, "ObjectName",
      CellTags->"CreateInlineCell"],
    Cell[71591, 2526, 187, 5, 44, "Usage",
      CellTags->"CreateInlineCell"],
    Cell[71781, 2533, 258, 7, 37, "Notes",
      CellTags->"CreateInlineCell"],
    Cell[72042, 2542, 207, 5, 52, "Notes",
      CellTags->"CreateInlineCell"],
    Cell[72252, 2549, 273, 8, 52, "Notes",
      CellTags->"CreateInlineCell"]},
  "EndInlineCell"->{
    Cell[72562, 2562, 68, 1, 55, "ObjectName",
      CellTags->"EndInlineCell"],
    Cell[72633, 2565, 175, 5, 44, "Usage",
      CellTags->"EndInlineCell"],
    Cell[72811, 2572, 253, 7, 37, "Notes",
      CellTags->"EndInlineCell"],
    Cell[73067, 2581, 270, 8, 52, "Notes",
      CellTags->"EndInlineCell"]},
  "InsertRawExpression"->{
    Cell[73374, 2594, 80, 1, 55, "ObjectName",
      CellTags->"InsertRawExpression"],
    Cell[73457, 2597, 233, 6, 60, "Usage",
      CellTags->"InsertRawExpression"],
    Cell[73693, 2605, 265, 7, 37, "Notes",
      CellTags->"InsertRawExpression"],
    Cell[73961, 2614, 146, 4, 36, "Notes",
      CellTags->"InsertRawExpression"],
    Cell[74110, 2620, 276, 8, 52, "Notes",
      CellTags->"InsertRawExpression"]},
  "AddInterpretation"->{
    Cell[74423, 2633, 76, 1, 55, "ObjectName",
      CellTags->"AddInterpretation"],
    Cell[74502, 2636, 403, 12, 60, "Usage",
      CellTags->"AddInterpretation"],
    Cell[74908, 2650, 257, 7, 37, "Notes",
      CellTags->"AddInterpretation"],
    Cell[75168, 2659, 144, 4, 36, "Notes",
      CellTags->"AddInterpretation"],
    Cell[75315, 2665, 274, 8, 52, "Notes",
      CellTags->"AddInterpretation"]},
  "NudgeLeft"->{
    Cell[75626, 2678, 60, 1, 55, "ObjectName",
      CellTags->"NudgeLeft"],
    Cell[75689, 2681, 284, 8, 60, "Usage",
      CellTags->"NudgeLeft"],
    Cell[75976, 2691, 244, 7, 37, "Notes",
      CellTags->"NudgeLeft"],
    Cell[76223, 2700, 266, 8, 52, "Notes",
      CellTags->"NudgeLeft"]},
  "NudgeRight"->{
    Cell[76526, 2713, 62, 1, 55, "ObjectName",
      CellTags->"NudgeRight"],
    Cell[76591, 2716, 287, 8, 60, "Usage",
      CellTags->"NudgeRight"],
    Cell[76881, 2726, 246, 7, 37, "Notes",
      CellTags->"NudgeRight"],
    Cell[77130, 2735, 267, 8, 52, "Notes",
      CellTags->"NudgeRight"]},
  "NudgeUp"->{
    Cell[77434, 2748, 56, 1, 55, "ObjectName",
      CellTags->"NudgeUp"],
    Cell[77493, 2751, 271, 8, 60, "Usage",
      CellTags->"NudgeUp"],
    Cell[77767, 2761, 243, 7, 37, "Notes",
      CellTags->"NudgeUp"],
    Cell[78013, 2770, 264, 8, 52, "Notes",
      CellTags->"NudgeUp"]},
  "NudgeDown"->{
    Cell[78314, 2783, 60, 1, 55, "ObjectName",
      CellTags->"NudgeDown"],
    Cell[78377, 2786, 277, 8, 60, "Usage",
      CellTags->"NudgeDown"],
    Cell[78657, 2796, 244, 7, 37, "Notes",
      CellTags->"NudgeDown"],
    Cell[78904, 2805, 266, 8, 52, "Notes",
      CellTags->"NudgeDown"]},
  "RemoveAdjustments"->{
    Cell[79207, 2818, 76, 1, 55, "ObjectName",
      CellTags->"RemoveAdjustments"],
    Cell[79286, 2821, 259, 7, 60, "Usage",
      CellTags->"RemoveAdjustments"],
    Cell[79548, 2830, 260, 7, 37, "Notes",
      CellTags->"RemoveAdjustments"],
    Cell[79811, 2839, 274, 8, 52, "Notes",
      CellTags->"RemoveAdjustments"]},
  "Make2D"->{
    Cell[80122, 2852, 54, 1, 55, "ObjectName",
      CellTags->"Make2D"],
    Cell[80179, 2855, 249, 6, 60, "Usage",
      CellTags->"Make2D"],
    Cell[80431, 2863, 201, 6, 37, "Notes",
      CellTags->"Make2D"],
    Cell[80635, 2871, 263, 8, 52, "Notes",
      CellTags->"Make2D"]},
  "Balance"->{
    Cell[80935, 2884, 56, 1, 55, "ObjectName",
      CellTags->"Balance"],
    Cell[80994, 2887, 253, 6, 60, "Usage",
      CellTags->"Balance"],
    Cell[81250, 2895, 209, 6, 37, "Notes",
      CellTags->"Balance"],
    Cell[81462, 2903, 401, 11, 52, "Notes",
      CellTags->"Balance"],
    Cell[81866, 2916, 264, 8, 52, "Notes",
      CellTags->"Balance"]},
  "FindNextMisspelling"->{
    Cell[82167, 2929, 80, 1, 55, "ObjectName",
      CellTags->"FindNextMisspelling"],
    Cell[82250, 2932, 239, 6, 60, "Usage",
      CellTags->"FindNextMisspelling"],
    Cell[82492, 2940, 222, 6, 37, "Notes",
      CellTags->"FindNextMisspelling"],
    Cell[82717, 2948, 352, 7, 67, "Notes",
      CellTags->"FindNextMisspelling"],
    Cell[83072, 2957, 276, 8, 52, "Notes",
      CellTags->"FindNextMisspelling"]},
  "SelectionConvert"->{
    Cell[83452, 2975, 74, 1, 55, "ObjectName",
      CellTags->"SelectionConvert"],
    Cell[83529, 2978, 209, 6, 44, "Usage",
      CellTags->"SelectionConvert"],
    Cell[83741, 2986, 215, 6, 37, "Notes",
      CellTags->"SelectionConvert"],
    Cell[83959, 2994, 149, 4, 36, "Notes",
      CellTags->"SelectionConvert"],
    Cell[84111, 3000, 4611, 102, 397, "2ColumnTable",
      CellTags->"SelectionConvert"],
    Cell[88725, 3104, 273, 8, 52, "Notes",
      CellTags->"SelectionConvert"]},
  "SelectionDisplayAs"->{
    Cell[89035, 3117, 78, 1, 55, "ObjectName",
      CellTags->"SelectionDisplayAs"],
    Cell[89116, 3120, 214, 6, 44, "Usage",
      CellTags->"SelectionDisplayAs"],
    Cell[89333, 3128, 217, 6, 37, "Notes",
      CellTags->"SelectionDisplayAs"],
    Cell[89553, 3136, 281, 6, 52, "Notes",
      CellTags->"SelectionDisplayAs"],
    Cell[89837, 3144, 151, 4, 36, "Notes",
      CellTags->"SelectionDisplayAs"],
    Cell[89991, 3150, 1595, 40, 112, "2ColumnTable",
      CellTags->"SelectionDisplayAs"],
    Cell[91589, 3192, 275, 8, 52, "Notes",
      CellTags->"SelectionDisplayAs"]},
  "CellGroup"->{
    Cell[91901, 3205, 60, 1, 55, "ObjectName",
      CellTags->"CellGroup"],
    Cell[91964, 3208, 183, 5, 44, "Usage",
      CellTags->"CellGroup"],
    Cell[92150, 3215, 245, 7, 37, "Notes",
      CellTags->"CellGroup"],
    Cell[92398, 3224, 309, 9, 37, "Notes",
      CellTags->"CellGroup"],
    Cell[92710, 3235, 266, 8, 52, "Notes",
      CellTags->"CellGroup"]},
  "CellUngroup"->{
    Cell[93013, 3248, 64, 1, 55, "ObjectName",
      CellTags->"CellUngroup"],
    Cell[93080, 3251, 189, 5, 44, "Usage",
      CellTags->"CellUngroup"],
    Cell[93272, 3258, 246, 7, 37, "Notes",
      CellTags->"CellUngroup"],
    Cell[93521, 3267, 311, 9, 37, "Notes",
      CellTags->"CellUngroup"],
    Cell[93835, 3278, 268, 8, 52, "Notes",
      CellTags->"CellUngroup"]},
  "SelectionOpenAllGroups"->{
    Cell[94140, 3291, 86, 1, 55, "ObjectName",
      CellTags->"SelectionOpenAllGroups"],
    Cell[94229, 3294, 231, 6, 60, "Usage",
      CellTags->"SelectionOpenAllGroups"],
    Cell[94463, 3302, 262, 7, 37, "Notes",
      CellTags->"SelectionOpenAllGroups"],
    Cell[94728, 3311, 279, 8, 52, "Notes",
      CellTags->"SelectionOpenAllGroups"]},
  "SelectionCloseAllGroups"->{
    Cell[95044, 3324, 88, 1, 55, "ObjectName",
      CellTags->"SelectionCloseAllGroups"],
    Cell[95135, 3327, 233, 6, 60, "Usage",
      CellTags->"SelectionCloseAllGroups"],
    Cell[95371, 3335, 264, 7, 37, "Notes",
      CellTags->"SelectionCloseAllGroups"],
    Cell[95638, 3344, 280, 8, 52, "Notes",
      CellTags->"SelectionCloseAllGroups"]},
  "OpenCloseGroup"->{
    Cell[95955, 3357, 70, 1, 55, "ObjectName",
      CellTags->"OpenCloseGroup"],
    Cell[96028, 3360, 243, 6, 60, "Usage",
      CellTags->"OpenCloseGroup"],
    Cell[96274, 3368, 252, 7, 37, "Notes",
      CellTags->"OpenCloseGroup"],
    Cell[96529, 3377, 145, 4, 36, "Notes",
      CellTags->"OpenCloseGroup"],
    Cell[96677, 3383, 271, 8, 52, "Notes",
      CellTags->"OpenCloseGroup"]},
  "CellSplit"->{
    Cell[96985, 3396, 60, 1, 55, "ObjectName",
      CellTags->"CellSplit"],
    Cell[97048, 3399, 212, 6, 44, "Usage",
      CellTags->"CellSplit"],
    Cell[97263, 3407, 209, 6, 37, "Notes",
      CellTags->"CellSplit"],
    Cell[97475, 3415, 291, 6, 52, "Notes",
      CellTags->"CellSplit"],
    Cell[97769, 3423, 266, 8, 52, "Notes",
      CellTags->"CellSplit"]},
  "CellMerge"->{
    Cell[98072, 3436, 60, 1, 55, "ObjectName",
      CellTags->"CellMerge"],
    Cell[98135, 3439, 187, 5, 44, "Usage",
      CellTags->"CellMerge"],
    Cell[98325, 3446, 209, 6, 37, "Notes",
      CellTags->"CellMerge"],
    Cell[98537, 3454, 266, 8, 52, "Notes",
      CellTags->"CellMerge"]},
  "SelectionAnimate"->{
    Cell[98840, 3467, 74, 1, 55, "ObjectName",
      CellTags->"SelectionAnimate"],
    Cell[98917, 3470, 210, 6, 44, "Usage",
      CellTags->"SelectionAnimate"],
    Cell[99130, 3478, 230, 6, 37, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[99363, 3486, 299, 8, 36, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[99665, 3496, 273, 8, 52, "Notes",
      CellTags->"SelectionAnimate"]},
  "SoundPlay"->{
    Cell[99975, 3509, 60, 1, 55, "ObjectName",
      CellTags->"SoundPlay"],
    Cell[100038, 3512, 195, 6, 44, "Usage",
      CellTags->"SoundPlay"],
    Cell[100236, 3520, 208, 6, 37, "Notes",
      CellTags->"SoundPlay"],
    Cell[100447, 3528, 215, 7, 36, "Notes",
      CellTags->"SoundPlay"],
    Cell[100665, 3537, 278, 10, 52, "Notes",
      CellTags->"SoundPlay"]},
  "GraphicsRender"->{
    Cell[100980, 3552, 70, 1, 55, "ObjectName",
      CellTags->"GraphicsRender"],
    Cell[101053, 3555, 194, 5, 44, "Usage",
      CellTags->"GraphicsRender"],
    Cell[101250, 3562, 220, 6, 37, "Notes",
      CellTags->"GraphicsRender"],
    Cell[101473, 3570, 191, 5, 52, "Notes",
      CellTags->"GraphicsRender"],
    Cell[101667, 3577, 283, 10, 52, "Notes",
      CellTags->"GraphicsRender"]},
  "GenerateImageCaches"->{
    Cell[101987, 3592, 80, 1, 55, "ObjectName",
      CellTags->"GenerateImageCaches"],
    Cell[102070, 3595, 225, 6, 60, "Usage",
      CellTags->"GenerateImageCaches"],
    Cell[102298, 3603, 234, 6, 37, "Notes",
      CellTags->"GenerateImageCaches"],
    Cell[102535, 3611, 288, 10, 52, "Notes",
      CellTags->"GenerateImageCaches"]},
  "GraphicsOriginalSize"->{
    Cell[102860, 3626, 82, 1, 55, "ObjectName",
      CellTags->"GraphicsOriginalSize"],
    Cell[102945, 3629, 224, 6, 44, "Usage",
      CellTags->"GraphicsOriginalSize"],
    Cell[103366, 3644, 351, 7, 67, "Notes",
      CellTags->"GraphicsOriginalSize"],
    Cell[103720, 3653, 289, 10, 52, "Notes",
      CellTags->"GraphicsOriginalSize"]},
  "GraphicsAlign"->{
    Cell[104046, 3668, 68, 1, 55, "ObjectName",
      CellTags->"GraphicsAlign"],
    Cell[104117, 3671, 202, 6, 44, "Usage",
      CellTags->"GraphicsAlign"],
    Cell[104322, 3679, 225, 6, 37, "Notes",
      CellTags->"GraphicsAlign"],
    Cell[104550, 3687, 421, 12, 52, "Notes",
      CellTags->"GraphicsAlign"],
    Cell[104974, 3701, 282, 10, 52, "Notes",
      CellTags->"GraphicsAlign"]},
  "NotebookStatisticsDialog"->{
    Cell[105293, 3716, 90, 1, 55, "ObjectName",
      CellTags->"NotebookStatisticsDialog"],
    Cell[105386, 3719, 220, 5, 44, "Usage",
      CellTags->"NotebookStatisticsDialog"],
    Cell[105609, 3726, 233, 6, 37, "Notes",
      CellTags->"NotebookStatisticsDialog"],
    Cell[105845, 3734, 317, 8, 36, "Notes",
      CellTags->"NotebookStatisticsDialog"],
    Cell[106165, 3744, 293, 10, 52, "Notes",
      CellTags->"NotebookStatisticsDialog"]},
  "StyleOther"->{
    Cell[106564, 3764, 62, 1, 55, "ObjectName",
      CellTags->"StyleOther"],
    Cell[106629, 3767, 182, 5, 44, "Usage",
      CellTags->"StyleOther"],
    Cell[106814, 3774, 206, 6, 37, "Notes",
      CellTags->"StyleOther"],
    Cell[107023, 3782, 249, 5, 52, "Notes",
      CellTags->"StyleOther"],
    Cell[107275, 3789, 279, 10, 52, "Notes",
      CellTags->"StyleOther"]},
  "ToggleShowExpression"->{
    Cell[107591, 3804, 82, 1, 55, "ObjectName",
      CellTags->"ToggleShowExpression"],
    Cell[107676, 3807, 272, 7, 60, "Usage",
      CellTags->"ToggleShowExpression"],
    Cell[107951, 3816, 226, 6, 37, "Notes",
      CellTags->"ToggleShowExpression"],
    Cell[108180, 3824, 289, 10, 52, "Notes",
      CellTags->"ToggleShowExpression"]},
  "OptionsDialog"->{
    Cell[108506, 3839, 68, 1, 55, "ObjectName",
      CellTags->"OptionsDialog"],
    Cell[108577, 3842, 228, 6, 60, "Usage",
      CellTags->"OptionsDialog"],
    Cell[108808, 3850, 220, 6, 37, "Notes",
      CellTags->"OptionsDialog"],
    Cell[109031, 3858, 282, 10, 52, "Notes",
      CellTags->"OptionsDialog"]},
  "ClearCellOptions"->{
    Cell[109350, 3873, 74, 1, 55, "ObjectName",
      CellTags->"ClearCellOptions"],
    Cell[109427, 3876, 194, 5, 44, "Usage",
      CellTags->"ClearCellOptions"],
    Cell[109624, 3883, 221, 6, 37, "Notes",
      CellTags->"ClearCellOptions"],
    Cell[109848, 3891, 250, 5, 52, "Notes",
      CellTags->"ClearCellOptions"],
    Cell[110101, 3898, 285, 10, 52, "Notes",
      CellTags->"ClearCellOptions"]},
  "StyleDefinitionsOther"->{
    Cell[110423, 3913, 84, 1, 55, "ObjectName",
      CellTags->"StyleDefinitionsOther"],
    Cell[110510, 3916, 253, 6, 60, "Usage",
      CellTags->"StyleDefinitionsOther"],
    Cell[110766, 3924, 223, 6, 37, "Notes",
      CellTags->"StyleDefinitionsOther"],
    Cell[110992, 3932, 211, 6, 36, "Notes",
      CellTags->"StyleDefinitionsOther"],
    Cell[111206, 3940, 290, 10, 52, "Notes",
      CellTags->"StyleDefinitionsOther"]},
  "EditStyleDefinitions"->{
    Cell[111533, 3955, 82, 1, 55, "ObjectName",
      CellTags->"EditStyleDefinitions"],
    Cell[111618, 3958, 231, 6, 60, "Usage",
      CellTags->"EditStyleDefinitions"],
    Cell[111852, 3966, 227, 6, 37, "Notes",
      CellTags->"EditStyleDefinitions"],
    Cell[112082, 3974, 373, 7, 72, "Notes",
      CellTags->"EditStyleDefinitions"],
    Cell[112458, 3983, 289, 10, 52, "Notes",
      CellTags->"EditStyleDefinitions"]},
  "PlainFont"->{
    Cell[112784, 3998, 60, 1, 55, "ObjectName",
      CellTags->"PlainFont"],
    Cell[112847, 4001, 369, 13, 60, "Usage",
      CellTags->"PlainFont"],
    Cell[113219, 4016, 227, 6, 37, "Notes",
      CellTags->"PlainFont"],
    Cell[113449, 4024, 278, 10, 52, "Notes",
      CellTags->"PlainFont"]},
  "FontSizeDialog"->{
    Cell[113764, 4039, 70, 1, 55, "ObjectName",
      CellTags->"FontSizeDialog"],
    Cell[113837, 4042, 235, 6, 60, "Usage",
      CellTags->"FontSizeDialog"],
    Cell[114075, 4050, 231, 6, 37, "Notes",
      CellTags->"FontSizeDialog"],
    Cell[114309, 4058, 283, 10, 52, "Notes",
      CellTags->"FontSizeDialog"]},
  "FontColorDialog"->{
    Cell[114629, 4073, 72, 1, 55, "ObjectName",
      CellTags->"FontColorDialog"],
    Cell[114704, 4076, 233, 6, 60, "Usage",
      CellTags->"FontColorDialog"],
    Cell[114940, 4084, 238, 6, 37, "Notes",
      CellTags->"FontColorDialog"],
    Cell[115181, 4092, 284, 10, 52, "Notes",
      CellTags->"FontColorDialog"]},
  "ToggleGrayBox"->{
    Cell[115502, 4107, 68, 1, 55, "ObjectName",
      CellTags->"ToggleGrayBox"],
    Cell[115573, 4110, 360, 10, 60, "Usage",
      CellTags->"ToggleGrayBox"],
    Cell[115936, 4122, 253, 7, 37, "Notes",
      CellTags->"ToggleGrayBox"],
    Cell[116192, 4131, 282, 10, 52, "Notes",
      CellTags->"ToggleGrayBox"]},
  "BackgroundDialog"->{
    Cell[116511, 4146, 74, 1, 55, "ObjectName",
      CellTags->"BackgroundDialog"],
    Cell[116588, 4149, 262, 6, 60, "Usage",
      CellTags->"BackgroundDialog"],
    Cell[116853, 4157, 246, 6, 37, "Notes",
      CellTags->"BackgroundDialog"],
    Cell[117102, 4165, 285, 10, 52, "Notes",
      CellTags->"BackgroundDialog"]},
  "FontPanel"->{
    Cell[117424, 4180, 60, 1, 55, "ObjectName",
      CellTags->"FontPanel"],
    Cell[117487, 4183, 228, 6, 60, "Usage",
      CellTags->"FontPanel"],
    Cell[117718, 4191, 247, 7, 37, "Notes",
      CellTags->"FontPanel"],
    Cell[117968, 4200, 113, 4, 36, "Notes",
      CellTags->"FontPanel"],
    Cell[118084, 4206, 278, 10, 52, "Notes",
      CellTags->"FontPanel"]},
  "FixCellWidth"->{
    Cell[118399, 4221, 66, 1, 55, "ObjectName",
      CellTags->"FixCellWidth"],
    Cell[118468, 4224, 283, 8, 60, "Usage",
      CellTags->"FixCellWidth"],
    Cell[118754, 4234, 257, 7, 37, "Notes",
      CellTags->"FixCellWidth"],
    Cell[119014, 4243, 281, 10, 52, "Notes",
      CellTags->"FixCellWidth"]},
  "ToggleOptionListElement"->{
    Cell[119332, 4258, 88, 1, 55, "ObjectName",
      CellTags->"ToggleOptionListElement"],
    Cell[119423, 4261, 249, 6, 60, "Usage",
      CellTags->"ToggleOptionListElement"],
    Cell[119675, 4269, 224, 6, 37, "Notes",
      CellTags->"ToggleOptionListElement"],
    Cell[119902, 4277, 292, 10, 52, "Notes",
      CellTags->"ToggleOptionListElement"]},
  "ShowPageBreaks"->{
    Cell[120231, 4292, 70, 1, 55, "ObjectName",
      CellTags->"ShowPageBreaks"],
    Cell[120304, 4295, 209, 6, 44, "Usage",
      CellTags->"ShowPageBreaks"],
    Cell[120516, 4303, 221, 6, 37, "Notes",
      CellTags->"ShowPageBreaks"],
    Cell[120740, 4311, 263, 9, 52, "Notes",
      CellTags->"ShowPageBreaks"],
    Cell[121006, 4322, 283, 10, 52, "Notes",
      CellTags->"ShowPageBreaks"]},
  "GraphicsCoordinatesDialog"->{
    Cell[121394, 4342, 92, 1, 55, "ObjectName",
      CellTags->"GraphicsCoordinatesDialog"],
    Cell[121489, 4345, 277, 6, 60, "Usage",
      CellTags->"GraphicsCoordinatesDialog"],
    Cell[121769, 4353, 239, 6, 37, "Notes",
      CellTags->"GraphicsCoordinatesDialog"],
    Cell[122011, 4361, 294, 10, 52, "Notes",
      CellTags->"GraphicsCoordinatesDialog"]},
  "ViewPointSelectorDialog"->{
    Cell[122342, 4376, 88, 1, 55, "ObjectName",
      CellTags->"ViewPointSelectorDialog"],
    Cell[122433, 4379, 299, 7, 60, "Usage",
      CellTags->"ViewPointSelectorDialog"],
    Cell[122735, 4388, 234, 6, 37, "Notes",
      CellTags->"ViewPointSelectorDialog"],
    Cell[122972, 4396, 292, 10, 52, "Notes",
      CellTags->"ViewPointSelectorDialog"]},
  "ColorSelectorDialog"->{
    Cell[123301, 4411, 80, 1, 55, "ObjectName",
      CellTags->"ColorSelectorDialog"],
    Cell[123384, 4414, 308, 9, 60, "Usage",
      CellTags->"ColorSelectorDialog"],
    Cell[123695, 4425, 223, 6, 37, "Notes",
      CellTags->"ColorSelectorDialog"],
    Cell[123921, 4433, 125, 4, 36, "Notes",
      CellTags->"ColorSelectorDialog"],
    Cell[124049, 4439, 288, 10, 52, "Notes",
      CellTags->"ColorSelectorDialog"]},
  "RecordSoundDialog"->{
    Cell[124374, 4454, 76, 1, 55, "ObjectName",
      CellTags->"RecordSoundDialog"],
    Cell[124453, 4457, 303, 9, 60, "Usage",
      CellTags->"RecordSoundDialog"],
    Cell[124759, 4468, 219, 6, 37, "Notes",
      CellTags->"RecordSoundDialog"],
    Cell[124981, 4476, 286, 10, 52, "Notes",
      CellTags->"RecordSoundDialog"]},
  "FileNameDialog"->{
    Cell[125304, 4491, 70, 1, 55, "ObjectName",
      CellTags->"FileNameDialog"],
    Cell[125377, 4494, 218, 6, 44, "Usage",
      CellTags->"FileNameDialog"],
    Cell[125598, 4502, 217, 6, 37, "Notes",
      CellTags->"FileNameDialog"],
    Cell[125818, 4510, 256, 7, 52, "Notes",
      CellTags->"FileNameDialog"],
    Cell[126077, 4519, 283, 10, 52, "Notes",
      CellTags->"FileNameDialog"]},
  "CreateGridBoxDialog"->{
    Cell[126397, 4534, 80, 1, 55, "ObjectName",
      CellTags->"CreateGridBoxDialog"],
    Cell[126480, 4537, 214, 6, 44, "Usage",
      CellTags->"CreateGridBoxDialog"],
    Cell[126697, 4545, 236, 6, 37, "Notes",
      CellTags->"CreateGridBoxDialog"],
    Cell[126936, 4553, 288, 10, 52, "Notes",
      CellTags->"CreateGridBoxDialog"]},
  "CreateCustomButtonBox"->{
    Cell[127261, 4568, 84, 1, 55, "ObjectName",
      CellTags->"CreateCustomButtonBox"],
    Cell[127348, 4571, 262, 6, 60, "Usage",
      CellTags->"CreateCustomButtonBox"],
    Cell[127613, 4579, 224, 6, 37, "Notes",
      CellTags->"CreateCustomButtonBox"],
    Cell[127840, 4587, 290, 10, 52, "Notes",
      CellTags->"CreateCustomButtonBox"]},
  "EditButtonBoxDialog"->{
    Cell[128167, 4602, 80, 1, 55, "ObjectName",
      CellTags->"EditButtonBoxDialog"],
    Cell[128250, 4605, 200, 5, 44, "Usage",
      CellTags->"EditButtonBoxDialog"],
    Cell[128453, 4612, 220, 6, 37, "Notes",
      CellTags->"EditButtonBoxDialog"],
    Cell[128676, 4620, 288, 10, 52, "Notes",
      CellTags->"EditButtonBoxDialog"]},
  "CreateHyperlinkDialog"->{
    Cell[129001, 4635, 84, 1, 55, "ObjectName",
      CellTags->"CreateHyperlinkDialog"],
    Cell[129088, 4638, 209, 5, 44, "Usage",
      CellTags->"CreateHyperlinkDialog"],
    Cell[129300, 4645, 227, 6, 37, "Notes",
      CellTags->"CreateHyperlinkDialog"],
    Cell[129530, 4653, 290, 10, 52, "Notes",
      CellTags->"CreateHyperlinkDialog"]},
  "CreateCounterBoxDialog"->{
    Cell[129857, 4668, 86, 1, 55, "ObjectName",
      CellTags->"CreateCounterBoxDialog"],
    Cell[129946, 4671, 230, 6, 60, "Usage",
      CellTags->"CreateCounterBoxDialog"],
    Cell[130179, 4679, 245, 6, 37, "Notes",
      CellTags->"CreateCounterBoxDialog"],
    Cell[130427, 4687, 291, 10, 52, "Notes",
      CellTags->"CreateCounterBoxDialog"]},
  "CreateValueBoxDialog"->{
    Cell[130755, 4702, 82, 1, 55, "ObjectName",
      CellTags->"CreateValueBoxDialog"],
    Cell[130840, 4705, 211, 5, 44, "Usage",
      CellTags->"CreateValueBoxDialog"],
    Cell[131054, 4712, 243, 6, 37, "Notes",
      CellTags->"CreateValueBoxDialog"],
    Cell[131300, 4720, 289, 10, 52, "Notes",
      CellTags->"CreateValueBoxDialog"]},
  "DuplicatePreviousInput"->{
    Cell[131626, 4735, 86, 1, 55, "ObjectName",
      CellTags->"DuplicatePreviousInput"],
    Cell[131715, 4738, 270, 6, 60, "Usage",
      CellTags->"DuplicatePreviousInput"],
    Cell[131988, 4746, 233, 6, 37, "Notes",
      CellTags->"DuplicatePreviousInput"],
    Cell[132224, 4754, 291, 10, 52, "Notes",
      CellTags->"DuplicatePreviousInput"]},
  "DuplicatePreviousOutput"->{
    Cell[132552, 4769, 88, 1, 55, "ObjectName",
      CellTags->"DuplicatePreviousOutput"],
    Cell[132643, 4772, 273, 6, 60, "Usage",
      CellTags->"DuplicatePreviousOutput"],
    Cell[132919, 4780, 235, 6, 37, "Notes",
      CellTags->"DuplicatePreviousOutput"],
    Cell[133157, 4788, 292, 10, 52, "Notes",
      CellTags->"DuplicatePreviousOutput"]},
  "SimilarCellBelow"->{
    Cell[133486, 4803, 74, 1, 55, "ObjectName",
      CellTags->"SimilarCellBelow"],
    Cell[133563, 4806, 264, 6, 60, "Usage",
      CellTags->"SimilarCellBelow"],
    Cell[133830, 4814, 226, 6, 37, "Notes",
      CellTags->"SimilarCellBelow"],
    Cell[134059, 4822, 132, 4, 36, "Notes",
      CellTags->"SimilarCellBelow"],
    Cell[134194, 4828, 285, 10, 52, "Notes",
      CellTags->"SimilarCellBelow"]},
  "CompleteSelection"->{
    Cell[134516, 4843, 76, 1, 55, "ObjectName",
      CellTags->"CompleteSelection"],
    Cell[134595, 4846, 205, 5, 44, "Usage",
      CellTags->"CompleteSelection"],
    Cell[134803, 4853, 225, 6, 37, "Notes",
      CellTags->"CompleteSelection"],
    Cell[135031, 4861, 450, 10, 67, "Notes",
      CellTags->"CompleteSelection"],
    Cell[135484, 4873, 286, 10, 52, "Notes",
      CellTags->"CompleteSelection"]},
  "TemplateSelection"->{
    Cell[135807, 4888, 76, 1, 55, "ObjectName",
      CellTags->"TemplateSelection"],
    Cell[135886, 4891, 231, 6, 60, "Usage",
      CellTags->"TemplateSelection"],
    Cell[136120, 4899, 220, 6, 37, "Notes",
      CellTags->"TemplateSelection"],
    Cell[136343, 4907, 397, 9, 52, "Notes",
      CellTags->"TemplateSelection"],
    Cell[136743, 4918, 286, 10, 52, "Notes",
      CellTags->"TemplateSelection"]},
  "EvaluateCells"->{
    Cell[137135, 4938, 68, 1, 38, "ObjectName",
      CellTags->"EvaluateCells"],
    Cell[137206, 4941, 211, 6, 44, "Usage",
      CellTags->"EvaluateCells"],
    Cell[137420, 4949, 248, 7, 37, "Notes",
      CellTags->"EvaluateCells"],
    Cell[137671, 4958, 391, 10, 52, "Notes",
      CellTags->"EvaluateCells"],
    Cell[138065, 4970, 282, 10, 52, "Notes",
      CellTags->"EvaluateCells"]},
  "Evaluate"->{
    Cell[138384, 4985, 58, 1, 42, "ObjectName",
      CellTags->"Evaluate"],
    Cell[138445, 4988, 178, 5, 44, "Usage",
      CellTags->"Evaluate"],
    Cell[138626, 4995, 246, 7, 37, "Notes",
      CellTags->"Evaluate"],
    Cell[138875, 5004, 317, 8, 52, "Notes",
      CellTags->"Evaluate"],
    Cell[139195, 5014, 277, 10, 52, "Notes",
      CellTags->"Evaluate"]},
  "EvaluateNextCell"->{
    Cell[139509, 5029, 74, 1, 42, "ObjectName",
      CellTags->"EvaluateNextCell"],
    Cell[139586, 5032, 232, 6, 60, "Usage",
      CellTags->"EvaluateNextCell"],
    Cell[139821, 5040, 256, 7, 37, "Notes",
      CellTags->"EvaluateNextCell"],
    Cell[140080, 5049, 670, 12, 117, "Notes",
      CellTags->"EvaluateNextCell"],
    Cell[140753, 5063, 285, 10, 52, "Notes",
      CellTags->"EvaluateNextCell"]},
  "SubsessionEvaluateCells"->{
    Cell[141075, 5078, 88, 1, 42, "ObjectName",
      CellTags->"SubsessionEvaluateCells"],
    Cell[141166, 5081, 297, 6, 60, "Usage",
      CellTags->"SubsessionEvaluateCells"],
    Cell[141466, 5089, 266, 7, 37, "Notes",
      CellTags->"SubsessionEvaluateCells"],
    Cell[141735, 5098, 282, 7, 52, "Notes",
      CellTags->"SubsessionEvaluateCells"],
    Cell[142020, 5107, 292, 10, 52, "Notes",
      CellTags->"SubsessionEvaluateCells"]},
  "EvaluateNotebook"->{
    Cell[142349, 5122, 74, 1, 42, "ObjectName",
      CellTags->"EvaluateNotebook"],
    Cell[142426, 5125, 217, 6, 44, "Usage",
      CellTags->"EvaluateNotebook"],
    Cell[142646, 5133, 254, 7, 37, "Notes",
      CellTags->"EvaluateNotebook"],
    Cell[142903, 5142, 285, 10, 52, "Notes",
      CellTags->"EvaluateNotebook"]},
  "EvaluateInitialization"->{
    Cell[143225, 5157, 86, 1, 42, "ObjectName",
      CellTags->"EvaluateInitialization"],
    Cell[143314, 5160, 238, 6, 60, "Usage",
      CellTags->"EvaluateInitialization"],
    Cell[143555, 5168, 260, 7, 37, "Notes",
      CellTags->"EvaluateInitialization"],
    Cell[143818, 5177, 369, 8, 52, "Notes",
      CellTags->"EvaluateInitialization"],
    Cell[144190, 5187, 291, 10, 52, "Notes",
      CellTags->"EvaluateInitialization"]},
  "EnterSubsession"->{
    Cell[144518, 5202, 72, 1, 42, "ObjectName",
      CellTags->"EnterSubsession"],
    Cell[144593, 5205, 236, 6, 60, "Usage",
      CellTags->"EnterSubsession"],
    Cell[144832, 5213, 252, 7, 37, "Notes",
      CellTags->"EnterSubsession"],
    Cell[145087, 5222, 486, 16, 52, "Notes",
      CellTags->"EnterSubsession"],
    Cell[145576, 5240, 284, 10, 52, "Notes",
      CellTags->"EnterSubsession"]},
  "ExitSubsession"->{
    Cell[145897, 5255, 70, 1, 42, "ObjectName",
      CellTags->"ExitSubsession"],
    Cell[145970, 5258, 211, 6, 44, "Usage",
      CellTags->"ExitSubsession"],
    Cell[146184, 5266, 250, 7, 37, "Notes",
      CellTags->"ExitSubsession"],
    Cell[146437, 5275, 239, 6, 52, "Notes",
      CellTags->"ExitSubsession"],
    Cell[146679, 5283, 283, 10, 52, "Notes",
      CellTags->"ExitSubsession"]},
  "RemoveFromEvaluationQueue"->{
    Cell[146999, 5298, 92, 1, 42, "ObjectName",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[147094, 5301, 233, 6, 60, "Usage",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[147330, 5309, 275, 7, 37, "Notes",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[147608, 5318, 282, 8, 52, "Notes",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[147893, 5328, 294, 10, 52, "Notes",
      CellTags->"RemoveFromEvaluationQueue"]},
  "EvaluatorInterrupt"->{
    Cell[148224, 5343, 78, 1, 42, "ObjectName",
      CellTags->"EvaluatorInterrupt"],
    Cell[148305, 5346, 272, 6, 60, "Usage",
      CellTags->"EvaluatorInterrupt"],
    Cell[148580, 5354, 229, 6, 37, "Notes",
      CellTags->"EvaluatorInterrupt"],
    Cell[148812, 5362, 402, 10, 52, "Notes",
      CellTags->"EvaluatorInterrupt"],
    Cell[149217, 5374, 287, 10, 52, "Notes",
      CellTags->"EvaluatorInterrupt"]},
  "EvaluatorAbort"->{
    Cell[149541, 5389, 70, 1, 42, "ObjectName",
      CellTags->"EvaluatorAbort"],
    Cell[149614, 5392, 219, 6, 44, "Usage",
      CellTags->"EvaluatorAbort"],
    Cell[149836, 5400, 221, 6, 37, "Notes",
      CellTags->"EvaluatorAbort"],
    Cell[150060, 5408, 240, 6, 52, "Notes",
      CellTags->"EvaluatorAbort"],
    Cell[150303, 5416, 283, 10, 52, "Notes",
      CellTags->"EvaluatorAbort"]},
  "EvaluatorStart"->{
    Cell[150623, 5431, 70, 1, 42, "ObjectName",
      CellTags->"EvaluatorStart"],
    Cell[150696, 5434, 185, 5, 44, "Usage",
      CellTags->"EvaluatorStart"],
    Cell[150884, 5441, 217, 6, 37, "Notes",
      CellTags->"EvaluatorStart"],
    Cell[151104, 5449, 376, 10, 52, "Notes",
      CellTags->"EvaluatorStart"],
    Cell[151483, 5461, 283, 10, 52, "Notes",
      CellTags->"EvaluatorStart"]},
  "EvaluatorQuit"->{
    Cell[151803, 5476, 68, 1, 42, "ObjectName",
      CellTags->"EvaluatorQuit"],
    Cell[151874, 5479, 187, 5, 44, "Usage",
      CellTags->"EvaluatorQuit"],
    Cell[152064, 5486, 215, 6, 37, "Notes",
      CellTags->"EvaluatorQuit"],
    Cell[152282, 5494, 373, 10, 52, "Notes",
      CellTags->"EvaluatorQuit"],
    Cell[152658, 5506, 282, 10, 52, "Notes",
      CellTags->"EvaluatorQuit"]},
  "ModifyEvaluatorNames"->{
    Cell[152977, 5521, 82, 1, 42, "ObjectName",
      CellTags->"ModifyEvaluatorNames"],
    Cell[153062, 5524, 237, 6, 60, "Usage",
      CellTags->"ModifyEvaluatorNames"],
    Cell[153302, 5532, 239, 6, 37, "Notes",
      CellTags->"ModifyEvaluatorNames"],
    Cell[153544, 5540, 378, 8, 52, "Notes",
      CellTags->"ModifyEvaluatorNames"],
    Cell[153925, 5550, 289, 10, 52, "Notes",
      CellTags->"ModifyEvaluatorNames"]},
  "ShowCellLabel"->{
    Cell[154251, 5565, 68, 1, 42, "ObjectName",
      CellTags->"ShowCellLabel"],
    Cell[154322, 5568, 216, 7, 44, "Usage",
      CellTags->"ShowCellLabel"],
    Cell[154541, 5577, 221, 6, 37, "Notes",
      CellTags->"ShowCellLabel"],
    Cell[154765, 5585, 282, 10, 52, "Notes",
      CellTags->"ShowCellLabel"]},
  "DeleteGeneratedCells"->{
    Cell[155084, 5600, 82, 1, 42, "ObjectName",
      CellTags->"DeleteGeneratedCells"],
    Cell[155169, 5603, 220, 6, 44, "Usage",
      CellTags->"DeleteGeneratedCells"],
    Cell[155392, 5611, 228, 6, 37, "Notes",
      CellTags->"DeleteGeneratedCells"],
    Cell[155623, 5619, 289, 10, 52, "Notes",
      CellTags->"DeleteGeneratedCells"]},
  "FindDialog"->{
    Cell[156016, 5639, 62, 1, 55, "ObjectName",
      CellTags->"FindDialog"],
    Cell[156081, 5642, 175, 5, 44, "Usage",
      CellTags->"FindDialog"],
    Cell[156259, 5649, 203, 6, 24, "Notes",
      CellTags->"FindDialog"],
    Cell[156465, 5657, 279, 10, 52, "Notes",
      CellTags->"FindDialog"]},
  "SelectionSetFind"->{
    Cell[156781, 5672, 74, 1, 38, "ObjectName",
      CellTags->"SelectionSetFind"],
    Cell[156858, 5675, 243, 6, 32, "Usage",
      CellTags->"SelectionSetFind"],
    Cell[157104, 5683, 220, 6, 24, "Notes",
      CellTags->"SelectionSetFind"],
    Cell[157327, 5691, 285, 10, 24, "Notes",
      CellTags->"SelectionSetFind"]},
  "CellTagsFind"->{
    Cell[157649, 5706, 66, 1, 38, "ObjectName",
      CellTags->"CellTagsFind"],
    Cell[157718, 5709, 262, 7, 32, "Usage",
      CellTags->"CellTagsFind"],
    Cell[157983, 5718, 218, 6, 24, "Notes",
      CellTags->"CellTagsFind"],
    Cell[158204, 5726, 128, 4, 24, "Notes",
      CellTags->"CellTagsFind"],
    Cell[158335, 5732, 269, 8, 24, "Notes",
      CellTags->"CellTagsFind"]},
  "Replace"->{
    Cell[158641, 5745, 56, 1, 38, "ObjectName",
      CellTags->"Replace"],
    Cell[158700, 5748, 195, 6, 32, "Usage",
      CellTags->"Replace"],
    Cell[158898, 5756, 203, 6, 24, "Notes",
      CellTags->"Replace"],
    Cell[159104, 5764, 276, 10, 24, "Notes",
      CellTags->"Replace"]},
  "ReplaceFind"->{
    Cell[159417, 5779, 64, 1, 38, "ObjectName",
      CellTags->"ReplaceFind"],
    Cell[159484, 5782, 263, 6, 48, "Usage",
      CellTags->"ReplaceFind"],
    Cell[159750, 5790, 222, 6, 24, "Notes",
      CellTags->"ReplaceFind"],
    Cell[159975, 5798, 280, 10, 24, "Notes",
      CellTags->"ReplaceFind"]},
  "ReplaceAll"->{
    Cell[160292, 5813, 62, 1, 38, "ObjectName",
      CellTags->"ReplaceAll"],
    Cell[160357, 5816, 300, 7, 48, "Usage",
      CellTags->"ReplaceAll"],
    Cell[160660, 5825, 210, 6, 24, "Notes",
      CellTags->"ReplaceAll"],
    Cell[160873, 5833, 279, 10, 24, "Notes",
      CellTags->"ReplaceAll"]},
  "OpenSelectionParents"->{
    Cell[161189, 5848, 82, 1, 38, "ObjectName",
      CellTags->"OpenSelectionParents"],
    Cell[161274, 5851, 216, 6, 32, "Usage",
      CellTags->"OpenSelectionParents"],
    Cell[161493, 5859, 222, 6, 24, "Notes",
      CellTags->"OpenSelectionParents"],
    Cell[161718, 5867, 289, 10, 24, "Notes",
      CellTags->"OpenSelectionParents"]},
  "SelectionScroll"->{
    Cell[162044, 5882, 72, 1, 38, "ObjectName",
      CellTags->"SelectionScroll"],
    Cell[162119, 5885, 280, 7, 48, "Usage",
      CellTags->"SelectionScroll"],
    Cell[162402, 5894, 223, 6, 24, "Notes",
      CellTags->"SelectionScroll"],
    Cell[162628, 5902, 284, 10, 24, "Notes",
      CellTags->"SelectionScroll"]},
  "HyperlinkGoBack"->{
    Cell[162949, 5917, 72, 1, 38, "ObjectName",
      CellTags->"HyperlinkGoBack"],
    Cell[163024, 5920, 222, 6, 32, "Usage",
      CellTags->"HyperlinkGoBack"],
    Cell[163249, 5928, 211, 6, 24, "Notes",
      CellTags->"HyperlinkGoBack"],
    Cell[163463, 5936, 284, 10, 24, "Notes",
      CellTags->"HyperlinkGoBack"]},
  "CellTagsEditDialog"->{
    Cell[163784, 5951, 78, 1, 38, "ObjectName",
      CellTags->"CellTagsEditDialog"],
    Cell[163865, 5954, 201, 5, 32, "Usage",
      CellTags->"CellTagsEditDialog"],
    Cell[164069, 5961, 227, 6, 24, "Notes",
      CellTags->"CellTagsEditDialog"],
    Cell[164299, 5969, 315, 9, 24, "Notes",
      CellTags->"CellTagsEditDialog"],
    Cell[164617, 5980, 287, 10, 24, "Notes",
      CellTags->"CellTagsEditDialog"]},
  "ShowCellTags"->{
    Cell[164941, 5995, 66, 1, 38, "ObjectName",
      CellTags->"ShowCellTags"],
    Cell[165010, 5998, 213, 6, 32, "Usage",
      CellTags->"ShowCellTags"],
    Cell[165226, 6006, 215, 6, 24, "Notes",
      CellTags->"ShowCellTags"],
    Cell[165444, 6014, 281, 10, 24, "Notes",
      CellTags->"ShowCellTags"]},
  "CellLabelsToTags"->{
    Cell[165762, 6029, 74, 1, 38, "ObjectName",
      CellTags->"CellLabelsToTags"],
    Cell[165839, 6032, 289, 9, 32, "Usage",
      CellTags->"CellLabelsToTags"],
    Cell[166131, 6043, 232, 6, 24, "Notes",
      CellTags->"CellLabelsToTags"],
    Cell[166366, 6051, 285, 10, 24, "Notes",
      CellTags->"CellLabelsToTags"]},
  "CreateIndexDialog"->{
    Cell[166688, 6066, 76, 1, 38, "ObjectName",
      CellTags->"CreateIndexDialog"],
    Cell[166767, 6069, 195, 5, 32, "Usage",
      CellTags->"CreateIndexDialog"],
    Cell[166965, 6076, 216, 6, 24, "Notes",
      CellTags->"CreateIndexDialog"],
    Cell[167184, 6084, 344, 8, 40, "Notes",
      CellTags->"CreateIndexDialog"],
    Cell[167531, 6094, 286, 10, 24, "Notes",
      CellTags->"CreateIndexDialog"]},
  "StackWindows"->{
    Cell[167924, 6114, 66, 1, 38, "ObjectName",
      CellTags->"StackWindows"],
    Cell[167993, 6117, 217, 6, 32, "Usage",
      CellTags->"StackWindows"],
    Cell[168213, 6125, 216, 6, 24, "Notes",
      CellTags->"StackWindows"],
    Cell[168432, 6133, 281, 10, 24, "Notes",
      CellTags->"StackWindows"]},
  "TileWindowsWide"->{
    Cell[168750, 6148, 72, 1, 38, "ObjectName",
      CellTags->"TileWindowsWide"],
    Cell[168825, 6151, 233, 6, 32, "Usage",
      CellTags->"TileWindowsWide"],
    Cell[169061, 6159, 223, 6, 24, "Notes",
      CellTags->"TileWindowsWide"],
    Cell[169287, 6167, 284, 10, 24, "Notes",
      CellTags->"TileWindowsWide"]},
  "TileWindowsTall"->{
    Cell[169608, 6182, 72, 1, 38, "ObjectName",
      CellTags->"TileWindowsTall"],
    Cell[169683, 6185, 233, 6, 32, "Usage",
      CellTags->"TileWindowsTall"],
    Cell[169919, 6193, 223, 6, 24, "Notes",
      CellTags->"TileWindowsTall"],
    Cell[170145, 6201, 284, 10, 24, "Notes",
      CellTags->"TileWindowsTall"]},
  "HelpDialog"->{
    Cell[170533, 6221, 62, 1, 38, "ObjectName",
      CellTags->"HelpDialog"],
    Cell[170598, 6224, 172, 5, 32, "Usage",
      CellTags->"HelpDialog"],
    Cell[170773, 6231, 211, 6, 24, "Notes",
      CellTags->"HelpDialog"],
    Cell[170987, 6239, 279, 10, 24, "Notes",
      CellTags->"HelpDialog"]},
  "SelectionHelpDialog"->{
    Cell[171303, 6254, 80, 1, 38, "ObjectName",
      CellTags->"SelectionHelpDialog"],
    Cell[171386, 6257, 226, 6, 32, "Usage",
      CellTags->"SelectionHelpDialog"],
    Cell[171615, 6265, 230, 6, 24, "Notes",
      CellTags->"SelectionHelpDialog"],
    Cell[171848, 6273, 288, 10, 24, "Notes",
      CellTags->"SelectionHelpDialog"]},
  "ExplainBeepDialog"->{
    Cell[172173, 6288, 76, 1, 38, "ObjectName",
      CellTags->"ExplainBeepDialog"],
    Cell[172252, 6291, 261, 6, 48, "Usage",
      CellTags->"ExplainBeepDialog"],
    Cell[172516, 6299, 219, 6, 24, "Notes",
      CellTags->"ExplainBeepDialog"],
    Cell[172738, 6307, 286, 10, 24, "Notes",
      CellTags->"ExplainBeepDialog"]},
  "AboutBoxDialog"->{
    Cell[173061, 6322, 70, 1, 38, "ObjectName",
      CellTags->"AboutBoxDialog"],
    Cell[173134, 6325, 268, 9, 32, "Usage",
      CellTags->"AboutBoxDialog"],
    Cell[173405, 6336, 336, 11, 24, "Notes",
      CellTags->"AboutBoxDialog"],
    Cell[173744, 6349, 283, 10, 24, "Notes",
      CellTags->"AboutBoxDialog"]},
  "RebuildHelpIndex"->{
    Cell[174064, 6364, 74, 1, 38, "ObjectName",
      CellTags->"RebuildHelpIndex"],
    Cell[174141, 6367, 246, 7, 32, "Usage",
      CellTags->"RebuildHelpIndex"],
    Cell[174390, 6376, 223, 6, 24, "Notes",
      CellTags->"RebuildHelpIndex"],
    Cell[174616, 6384, 171, 4, 24, "Notes",
      CellTags->"RebuildHelpIndex"],
    Cell[174790, 6390, 285, 10, 24, "Notes",
      CellTags->"RebuildHelpIndex"]},
  "AddFrame"->{
    Cell[175188, 6410, 58, 1, 38, "ObjectName",
      CellTags->"AddFrame"],
    Cell[175249, 6413, 211, 6, 32, "Usage",
      CellTags->"AddFrame"],
    Cell[175463, 6421, 277, 10, 24, "Notes",
      CellTags->"AddFrame"]},
  "FixCellHeight"->{
    Cell[175777, 6436, 68, 1, 42, "ObjectName",
      CellTags->"FixCellHeight"],
    Cell[175848, 6439, 287, 8, 48, "Usage",
      CellTags->"FixCellHeight"],
    Cell[176138, 6449, 282, 10, 24, "Notes",
      CellTags->"FixCellHeight"]},
  "MoveNextCell"->{
    Cell[176457, 6464, 66, 1, 42, "ObjectName",
      CellTags->"MoveNextCell"],
    Cell[176526, 6467, 196, 5, 32, "Usage",
      CellTags->"MoveNextCell"],
    Cell[176725, 6474, 281, 10, 24, "Notes",
      CellTags->"MoveNextCell"]},
  "SelectTerminalWindow"->{
    Cell[177043, 6489, 82, 1, 42, "ObjectName",
      CellTags->"SelectTerminalWindow"],
    Cell[177128, 6492, 248, 6, 32, "Usage",
      CellTags->"SelectTerminalWindow"],
    Cell[177379, 6500, 312, 6, 46, "Notes",
      CellTags->"SelectTerminalWindow"],
    Cell[177694, 6508, 289, 10, 24, "Notes",
      CellTags->"SelectTerminalWindow"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"FrontEndTokenIntro", 178772, 6543},
  {"New", 180410, 6584},
  {"Open", 180687, 6593},
  {"Close", 180971, 6602},
  {"Save", 181260, 6611},
  {"SaveRename", 181551, 6620},
  {"SaveRenameSpecial", 181873, 6629},
  {"Revert", 182382, 6642},
  {"OpenSpecial", 182682, 6651},
  {"Import", 182997, 6660},
  {"NotebookMail", 183298, 6669},
  {"NotebookMailSelection", 183632, 6678},
  {"GeneratePalette", 183996, 6687},
  {"GenerateNotebook", 184337, 6696},
  {"SystemPrintOptionsDialog", 184690, 6705},
  {"PrintOptionsDialog", 185069, 6714},
  {"HeadersFootersDialog", 185426, 6723},
  {"PrintDialog", 185782, 6732},
  {"PrintSelectionDialog", 186111, 6741},
  {"FrontEndQuit", 186468, 6750},
  {"Undo", 186785, 6759},
  {"Cut", 187136, 6770},
  {"Copy", 187488, 6781},
  {"Paste", 187846, 6792},
  {"Clear", 188141, 6801},
  {"CopySpecial", 188441, 6810},
  {"PasteSpecial", 188928, 6823},
  {"PasteApply", 189416, 6836},
  {"PasteDiscard", 189737, 6845},
  {"SelectionSaveSpecial", 190150, 6856},
  {"SelectAll", 190687, 6869},
  {"InsertObject", 191004, 6878},
  {"MoveNext", 191405, 6889},
  {"MovePrevious", 191718, 6898},
  {"DeleteNext", 192045, 6907},
  {"DeletePrevious", 192368, 6916},
  {"MoveNextWord", 192705, 6925},
  {"MovePreviousWord", 193038, 6934},
  {"DeleteNextWord", 193385, 6943},
  {"DeletePreviousWord", 193728, 6952},
  {"MoveLineEnd", 194080, 6961},
  {"MoveLineBeginning", 194410, 6970},
  {"MoveNextLine", 194759, 6979},
  {"MovePreviousLine", 195092, 6988},
  {"Superscript", 195436, 6997},
  {"Subscript", 195833, 7008},
  {"Above", 196216, 7019},
  {"Below", 196579, 7030},
  {"Otherscript", 196948, 7041},
  {"Fraction", 197346, 7052},
  {"Radical", 197726, 7063},
  {"NewRow", 198100, 7074},
  {"NewColumn", 198472, 7085},
  {"MoveExpressionEnd", 198867, 7096},
  {"ExpandSelection", 199219, 7105},
  {"CreateInlineCell", 199643, 7116},
  {"EndInlineCell", 200069, 7127},
  {"InsertRawExpression", 200409, 7136},
  {"AddInterpretation", 200854, 7147},
  {"NudgeLeft", 201282, 7158},
  {"NudgeRight", 201597, 7167},
  {"NudgeUp", 201913, 7176},
  {"NudgeDown", 202219, 7185},
  {"RemoveAdjustments", 202541, 7194},
  {"Make2D", 202884, 7203},
  {"Balance", 203184, 7212},
  {"FindNextMisspelling", 203572, 7223},
  {"SelectionConvert", 204016, 7234},
  {"SelectionDisplayAs", 204538, 7247},
  {"CellGroup", 205144, 7262},
  {"CellUngroup", 205533, 7273},
  {"SelectionOpenAllGroups", 205943, 7284},
  {"SelectionCloseAllGroups", 206323, 7293},
  {"OpenCloseGroup", 206698, 7302},
  {"CellSplit", 207110, 7313},
  {"CellMerge", 207497, 7324},
  {"SelectionAnimate", 207818, 7333},
  {"SoundPlay", 208240, 7344},
  {"GraphicsRender", 208637, 7355},
  {"GenerateImageCaches", 209065, 7366},
  {"GraphicsOriginalSize", 209435, 7375},
  {"GraphicsAlign", 209802, 7384},
  {"NotebookStatisticsDialog", 210231, 7395},
  {"StyleOther", 210700, 7406},
  {"ToggleShowExpression", 211109, 7417},
  {"OptionsDialog", 211476, 7426},
  {"ClearCellOptions", 211818, 7435},
  {"StyleDefinitionsOther", 212258, 7446},
  {"EditStyleDefinitions", 212722, 7457},
  {"PlainFont", 213170, 7468},
  {"FontSizeDialog", 213495, 7477},
  {"FontColorDialog", 213840, 7486},
  {"ToggleGrayBox", 214187, 7495},
  {"BackgroundDialog", 214530, 7504},
  {"FontPanel", 214877, 7513},
  {"FixCellWidth", 215273, 7524},
  {"ToggleOptionListElement", 215618, 7533},
  {"ShowPageBreaks", 215998, 7542},
  {"GraphicsCoordinatesDialog", 216432, 7553},
  {"ViewPointSelectorDialog", 216829, 7562},
  {"ColorSelectorDialog", 217214, 7571},
  {"RecordSoundDialog", 217665, 7582},
  {"FileNameDialog", 218021, 7591},
  {"CreateGridBoxDialog", 218449, 7602},
  {"CreateCustomButtonBox", 218820, 7611},
  {"EditButtonBoxDialog", 219197, 7620},
  {"CreateHyperlinkDialog", 219568, 7629},
  {"CreateCounterBoxDialog", 219948, 7638},
  {"CreateValueBoxDialog", 220330, 7647},
  {"DuplicatePreviousInput", 220706, 7656},
  {"DuplicatePreviousOutput", 221091, 7665},
  {"SimilarCellBelow", 221473, 7674},
  {"CompleteSelection", 221909, 7685},
  {"TemplateSelection", 222351, 7696},
  {"EvaluateCells", 222788, 7707},
  {"Evaluate", 223201, 7718},
  {"EvaluateNextCell", 223596, 7729},
  {"SubsessionEvaluateCells", 224040, 7740},
  {"EvaluateNotebook", 224510, 7751},
  {"EvaluateInitialization", 224870, 7760},
  {"EnterSubsession", 225334, 7771},
  {"ExitSubsession", 225763, 7782},
  {"RemoveFromEvaluationQueue", 226197, 7793},
  {"EvaluatorInterrupt", 226679, 7804},
  {"EvaluatorAbort", 227123, 7815},
  {"EvaluatorStart", 227546, 7826},
  {"EvaluatorQuit", 227969, 7837},
  {"ModifyEvaluatorNames", 228394, 7848},
  {"ShowCellLabel", 228846, 7859},
  {"DeleteGeneratedCells", 229192, 7868},
  {"FindDialog", 229556, 7877},
  {"SelectionSetFind", 229886, 7886},
  {"CellTagsFind", 230236, 7895},
  {"Replace", 230641, 7906},
  {"ReplaceFind", 230954, 7915},
  {"ReplaceAll", 231282, 7924},
  {"OpenSelectionParents", 231616, 7933},
  {"SelectionScroll", 231985, 7942},
  {"HyperlinkGoBack", 232334, 7951},
  {"CellTagsEditDialog", 232686, 7960},
  {"ShowCellTags", 233127, 7971},
  {"CellLabelsToTags", 233465, 7980},
  {"CreateIndexDialog", 233820, 7989},
  {"StackWindows", 234256, 8000},
  {"TileWindowsWide", 234593, 8009},
  {"TileWindowsTall", 234942, 8018},
  {"HelpDialog", 235286, 8027},
  {"SelectionHelpDialog", 235619, 8036},
  {"ExplainBeepDialog", 235986, 8045},
  {"AboutBoxDialog", 236342, 8054},
  {"RebuildHelpIndex", 236689, 8063},
  {"AddFrame", 237116, 8074},
  {"FixCellHeight", 237362, 8081},
  {"MoveNextCell", 237622, 8088},
  {"SelectTerminalWindow", 237887, 8095}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 35, 0, 61, "Section"],

Cell[CellGroupData[{
Cell[1836, 57, 68, 1, 36, "Subsection",
  CellTags->"FrontEndTokenIntro"],
Cell[1907, 60, 568, 12, 56, "Text",
  CellTags->"FrontEndTokenIntro"],
Cell[2478, 74, 603, 17, 56, "Text",
  CellTags->"FrontEndTokenIntro"],
Cell[3084, 93, 678, 17, 56, "Text",
  CellTags->"FrontEndTokenIntro"],
Cell[3765, 112, 133, 3, 26, "Input",
  CellTags->"FrontEndTokenIntro"],
Cell[3901, 117, 587, 15, 56, "Text",
  CellTags->"FrontEndTokenIntro"],
Cell[4491, 134, 164, 4, 26, "Input",
  CellTags->"FrontEndTokenIntro"],

Cell[CellGroupData[{
Cell[4680, 142, 85, 1, 34, "Subsubsection",
  CellTags->"FrontEndTokenIntro"],
Cell[4768, 145, 352, 7, 56, "Text",
  CellTags->"FrontEndTokenIntro"]
}, Closed]],

Cell[CellGroupData[{
Cell[5157, 157, 76, 1, 24, "SubsubsectionIcon",
  CellTags->"FrontEndTokenIntro"],
Cell[5236, 160, 451, 11, 56, "Text",
  CellTags->"FrontEndTokenIntro"],
Cell[5690, 173, 289, 9, 40, "Text",
  CellTags->"FrontEndTokenIntro"],
Cell[5982, 184, 133, 3, 26, "Input",
  CellTags->"FrontEndTokenIntro"],
Cell[6118, 189, 457, 10, 56, "Text",
  CellTags->"FrontEndTokenIntro"],
Cell[6578, 201, 175, 5, 26, "Input",
  CellTags->"FrontEndTokenIntro"],
Cell[6756, 208, 586, 18, 68, "Text",
  CellTags->"FrontEndTokenIntro"]
}, Closed]],

Cell[CellGroupData[{
Cell[7379, 231, 78, 1, 37, "SubsubsectionIcon",
  CellTags->"FrontEndTokenIntro"],
Cell[7460, 234, 793, 19, 97, "Text",
  CellTags->"FrontEndTokenIntro"],
Cell[8256, 255, 206, 5, 56, "Input",
  CellTags->"FrontEndTokenIntro"],
Cell[8465, 262, 306, 7, 52, "Text",
  CellTags->"FrontEndTokenIntro"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8820, 275, 46, 0, 36, "Subsection"],
Cell[8869, 277, 246, 5, 38, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[9152, 287, 30, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[9207, 291, 48, 1, 55, "ObjectName",
  CellTags->"New"],
Cell[9258, 294, 159, 5, 44, "Usage",
  CellTags->"New"],
Cell[9420, 301, 195, 6, 37, "Notes",
  CellTags->"New"],
Cell[9618, 309, 260, 8, 52, "Notes",
  CellTags->"New"]
}, Closed]],

Cell[CellGroupData[{
Cell[9915, 322, 50, 1, 55, "ObjectName",
  CellTags->"Open"],
Cell[9968, 325, 206, 6, 44, "Usage",
  CellTags->"Open"],
Cell[10177, 333, 203, 7, 37, "Notes",
  CellTags->"Open"],
Cell[10383, 342, 261, 8, 52, "Notes",
  CellTags->"Open"]
}, Closed]],

Cell[CellGroupData[{
Cell[10681, 355, 52, 1, 55, "ObjectName",
  CellTags->"Close"],
Cell[10736, 358, 178, 5, 44, "Usage",
  CellTags->"Close"],
Cell[10917, 365, 199, 6, 37, "Notes",
  CellTags->"Close"],
Cell[11119, 373, 262, 8, 52, "Notes",
  CellTags->"Close"]
}, Closed]],

Cell[CellGroupData[{
Cell[11418, 386, 50, 1, 55, "ObjectName",
  CellTags->"Save"],
Cell[11471, 389, 175, 5, 44, "Usage",
  CellTags->"Save"],
Cell[11649, 396, 197, 6, 37, "Notes",
  CellTags->"Save"],
Cell[11849, 404, 261, 8, 52, "Notes",
  CellTags->"Save"]
}, Closed]],

Cell[CellGroupData[{
Cell[12147, 417, 62, 1, 55, "ObjectName",
  CellTags->"SaveRename"],
Cell[12212, 420, 192, 5, 44, "Usage",
  CellTags->"SaveRename"],
Cell[12407, 427, 206, 6, 37, "Notes",
  CellTags->"SaveRename"],
Cell[12616, 435, 267, 8, 52, "Notes",
  CellTags->"SaveRename"]
}, Closed]],

Cell[CellGroupData[{
Cell[12920, 448, 76, 1, 55, "ObjectName",
  CellTags->"SaveRenameSpecial"],
Cell[12999, 451, 219, 6, 44, "Usage",
  CellTags->"SaveRenameSpecial"],
Cell[13221, 459, 221, 6, 37, "Notes",
  CellTags->"SaveRenameSpecial"],
Cell[13445, 467, 150, 4, 36, "Notes",
  CellTags->"SaveRenameSpecial"],
Cell[13598, 473, 2246, 57, 151, "2ColumnTable",
  CellTags->"SaveRenameSpecial"],
Cell[15847, 532, 274, 8, 52, "Notes",
  CellTags->"SaveRenameSpecial"]
}, Closed]],

Cell[CellGroupData[{
Cell[16158, 545, 54, 1, 55, "ObjectName",
  CellTags->"Revert"],
Cell[16215, 548, 191, 6, 44, "Usage",
  CellTags->"Revert"],
Cell[16409, 556, 201, 6, 37, "Notes",
  CellTags->"Revert"],
Cell[16613, 564, 263, 8, 52, "Notes",
  CellTags->"Revert"]
}, Closed]],

Cell[CellGroupData[{
Cell[16913, 577, 64, 1, 55, "ObjectName",
  CellTags->"OpenSpecial"],
Cell[16980, 580, 185, 5, 44, "Usage",
  CellTags->"OpenSpecial"],
Cell[17168, 587, 212, 6, 37, "Notes",
  CellTags->"OpenSpecial"],
Cell[17383, 595, 268, 8, 52, "Notes",
  CellTags->"OpenSpecial"]
}, Closed]],

Cell[CellGroupData[{
Cell[17688, 608, 54, 1, 55, "ObjectName",
  CellTags->"Import"],
Cell[17745, 611, 257, 6, 60, "Usage",
  CellTags->"Import"],
Cell[18005, 619, 201, 6, 37, "Notes",
  CellTags->"Import"],
Cell[18209, 627, 263, 8, 52, "Notes",
  CellTags->"Import"]
}, Closed]],

Cell[CellGroupData[{
Cell[18509, 640, 66, 1, 55, "ObjectName",
  CellTags->"NotebookMail"],
Cell[18578, 643, 248, 6, 60, "Usage",
  CellTags->"NotebookMail"],
Cell[18829, 651, 208, 6, 37, "Notes",
  CellTags->"NotebookMail"],
Cell[19040, 659, 269, 8, 52, "Notes",
  CellTags->"NotebookMail"]
}, Closed]],

Cell[CellGroupData[{
Cell[19346, 672, 84, 1, 55, "ObjectName",
  CellTags->"NotebookMailSelection"],
Cell[19433, 675, 276, 6, 60, "Usage",
  CellTags->"NotebookMailSelection"],
Cell[19712, 683, 224, 6, 37, "Notes",
  CellTags->"NotebookMailSelection"],
Cell[19939, 691, 278, 8, 52, "Notes",
  CellTags->"NotebookMailSelection"]
}, Closed]],

Cell[CellGroupData[{
Cell[20254, 704, 72, 1, 55, "ObjectName",
  CellTags->"GeneratePalette"],
Cell[20329, 707, 196, 5, 44, "Usage",
  CellTags->"GeneratePalette"],
Cell[20528, 714, 235, 6, 37, "Notes",
  CellTags->"GeneratePalette"],
Cell[20766, 722, 272, 8, 52, "Notes",
  CellTags->"GeneratePalette"]
}, Closed]],

Cell[CellGroupData[{
Cell[21075, 735, 74, 1, 55, "ObjectName",
  CellTags->"GenerateNotebook"],
Cell[21152, 738, 208, 6, 44, "Usage",
  CellTags->"GenerateNotebook"],
Cell[21363, 746, 235, 6, 37, "Notes",
  CellTags->"GenerateNotebook"],
Cell[21601, 754, 273, 8, 52, "Notes",
  CellTags->"GenerateNotebook"]
}, Closed]],

Cell[CellGroupData[{
Cell[21911, 767, 90, 1, 55, "ObjectName",
  CellTags->"SystemPrintOptionsDialog"],
Cell[22004, 770, 209, 5, 44, "Usage",
  CellTags->"SystemPrintOptionsDialog"],
Cell[22216, 777, 260, 7, 37, "Notes",
  CellTags->"SystemPrintOptionsDialog"],
Cell[22479, 786, 281, 8, 52, "Notes",
  CellTags->"SystemPrintOptionsDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[22797, 799, 78, 1, 55, "ObjectName",
  CellTags->"PrintOptionsDialog"],
Cell[22878, 802, 203, 5, 44, "Usage",
  CellTags->"PrintOptionsDialog"],
Cell[23084, 809, 260, 7, 37, "Notes",
  CellTags->"PrintOptionsDialog"],
Cell[23347, 818, 275, 8, 52, "Notes",
  CellTags->"PrintOptionsDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[23659, 831, 82, 1, 55, "ObjectName",
  CellTags->"HeadersFootersDialog"],
Cell[23744, 834, 206, 5, 44, "Usage",
  CellTags->"HeadersFootersDialog"],
Cell[23953, 841, 265, 7, 37, "Notes",
  CellTags->"HeadersFootersDialog"],
Cell[24221, 850, 277, 8, 52, "Notes",
  CellTags->"HeadersFootersDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[24535, 863, 64, 1, 55, "ObjectName",
  CellTags->"PrintDialog"],
Cell[24602, 866, 237, 7, 44, "Usage",
  CellTags->"PrintDialog"],
Cell[24842, 875, 205, 6, 37, "Notes",
  CellTags->"PrintDialog"],
Cell[25050, 883, 268, 8, 52, "Notes",
  CellTags->"PrintDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[25355, 896, 82, 1, 55, "ObjectName",
  CellTags->"PrintSelectionDialog"],
Cell[25440, 899, 265, 7, 60, "Usage",
  CellTags->"PrintSelectionDialog"],
Cell[25708, 908, 224, 6, 37, "Notes",
  CellTags->"PrintSelectionDialog"],
Cell[25935, 916, 277, 8, 52, "Notes",
  CellTags->"PrintSelectionDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[26249, 929, 66, 1, 55, "ObjectName",
  CellTags->"FrontEndQuit"],
Cell[26318, 932, 251, 6, 60, "Usage",
  CellTags->"FrontEndQuit"],
Cell[26572, 940, 205, 6, 37, "Notes",
  CellTags->"FrontEndQuit"],
Cell[26780, 948, 269, 8, 52, "Notes",
  CellTags->"FrontEndQuit"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27098, 962, 30, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[27153, 966, 50, 1, 55, "ObjectName",
  CellTags->"Undo"],
Cell[27206, 969, 185, 6, 44, "Usage",
  CellTags->"Undo"],
Cell[27394, 977, 197, 6, 37, "Notes",
  CellTags->"Undo"],
Cell[27594, 985, 269, 6, 52, "Notes",
  CellTags->"Undo"],
Cell[27866, 993, 261, 8, 52, "Notes",
  CellTags->"Undo"]
}, Closed]],

Cell[CellGroupData[{
Cell[28164, 1006, 48, 1, 55, "ObjectName",
  CellTags->"Cut"],
Cell[28215, 1009, 209, 6, 44, "Usage",
  CellTags->"Cut"],
Cell[28427, 1017, 195, 6, 37, "Notes",
  CellTags->"Cut"],
Cell[28625, 1025, 190, 6, 36, "Notes",
  CellTags->"Cut"],
Cell[28818, 1033, 260, 8, 52, "Notes",
  CellTags->"Cut"]
}, Closed]],

Cell[CellGroupData[{
Cell[29115, 1046, 50, 1, 55, "ObjectName",
  CellTags->"Copy"],
Cell[29168, 1049, 216, 6, 44, "Usage",
  CellTags->"Copy"],
Cell[29387, 1057, 197, 6, 37, "Notes",
  CellTags->"Copy"],
Cell[29587, 1065, 190, 6, 36, "Notes",
  CellTags->"Copy"],
Cell[29780, 1073, 261, 8, 52, "Notes",
  CellTags->"Copy"]
}, Closed]],

Cell[CellGroupData[{
Cell[30078, 1086, 52, 1, 55, "ObjectName",
  CellTags->"Paste"],
Cell[30133, 1089, 210, 6, 44, "Usage",
  CellTags->"Paste"],
Cell[30346, 1097, 666, 18, 88, "Notes",
  CellTags->"Paste"],
Cell[31015, 1117, 262, 8, 52, "Notes",
  CellTags->"Paste"]
}, Closed]],

Cell[CellGroupData[{
Cell[31314, 1130, 52, 1, 55, "ObjectName",
  CellTags->"Clear"],
Cell[31369, 1133, 199, 6, 44, "Usage",
  CellTags->"Clear"],
Cell[31571, 1141, 199, 6, 37, "Notes",
  CellTags->"Clear"],
Cell[31773, 1149, 262, 8, 52, "Notes",
  CellTags->"Clear"]
}, Closed]],

Cell[CellGroupData[{
Cell[32072, 1162, 64, 1, 55, "ObjectName",
  CellTags->"CopySpecial"],
Cell[32139, 1165, 229, 6, 60, "Usage",
  CellTags->"CopySpecial"],
Cell[32371, 1173, 207, 6, 37, "Notes",
  CellTags->"CopySpecial"],
Cell[32581, 1181, 145, 5, 56, "Notes",
  CellTags->"CopySpecial"],
Cell[32729, 1188, 4242, 100, 268, "2ColumnTable",
  CellTags->"CopySpecial"],
Cell[36974, 1290, 280, 10, 52, "Notes",
  CellTags->"CopySpecial"]
}, Closed]],

Cell[CellGroupData[{
Cell[37291, 1305, 66, 1, 55, "ObjectName",
  CellTags->"PasteSpecial"],
Cell[37360, 1308, 239, 6, 60, "Usage",
  CellTags->"PasteSpecial"],
Cell[37602, 1316, 209, 6, 37, "Notes",
  CellTags->"PasteSpecial"],
Cell[37814, 1324, 145, 4, 36, "Notes",
  CellTags->"PasteSpecial"],
Cell[37962, 1330, 1213, 30, 95, "2ColumnTable",
  CellTags->"PasteSpecial"],
Cell[39178, 1362, 269, 8, 52, "Notes",
  CellTags->"PasteSpecial"]
}, Closed]],

Cell[CellGroupData[{
Cell[39484, 1375, 62, 1, 55, "ObjectName",
  CellTags->"PasteApply"],
Cell[39549, 1378, 331, 8, 60, "Usage",
  CellTags->"PasteApply"],
Cell[39883, 1388, 240, 6, 37, "Notes",
  CellTags->"PasteApply"],
Cell[40126, 1396, 267, 8, 52, "Notes",
  CellTags->"PasteApply"]
}, Closed]],

Cell[CellGroupData[{
Cell[40430, 1409, 66, 1, 55, "ObjectName",
  CellTags->"PasteDiscard"],
Cell[40499, 1412, 280, 7, 60, "Usage",
  CellTags->"PasteDiscard"],
Cell[40782, 1421, 246, 7, 37, "Notes",
  CellTags->"PasteDiscard"],
Cell[41031, 1430, 292, 7, 52, "Notes",
  CellTags->"PasteDiscard"],
Cell[41326, 1439, 269, 8, 52, "Notes",
  CellTags->"PasteDiscard"]
}, Closed]],

Cell[CellGroupData[{
Cell[41632, 1452, 82, 1, 55, "ObjectName",
  CellTags->"SelectionSaveSpecial"],
Cell[41717, 1455, 247, 6, 60, "Usage",
  CellTags->"SelectionSaveSpecial"],
Cell[41967, 1463, 226, 6, 37, "Notes",
  CellTags->"SelectionSaveSpecial"],
Cell[42196, 1471, 153, 4, 36, "Notes",
  CellTags->"SelectionSaveSpecial"],
Cell[42352, 1477, 5186, 122, 325, "2ColumnTable",
  CellTags->"SelectionSaveSpecial"],
Cell[47541, 1601, 277, 8, 52, "Notes",
  CellTags->"SelectionSaveSpecial"]
}, Closed]],

Cell[CellGroupData[{
Cell[47855, 1614, 60, 1, 55, "ObjectName",
  CellTags->"SelectAll"],
Cell[47918, 1617, 195, 6, 44, "Usage",
  CellTags->"SelectAll"],
Cell[48116, 1625, 208, 6, 37, "Notes",
  CellTags->"SelectAll"],
Cell[48327, 1633, 266, 8, 52, "Notes",
  CellTags->"SelectAll"]
}, Closed]],

Cell[CellGroupData[{
Cell[48630, 1646, 66, 1, 55, "ObjectName",
  CellTags->"InsertObject"],
Cell[48699, 1649, 250, 6, 60, "Usage",
  CellTags->"InsertObject"],
Cell[48952, 1657, 217, 6, 37, "Notes",
  CellTags->"InsertObject"],
Cell[49172, 1665, 116, 4, 36, "Notes",
  CellTags->"InsertObject"],
Cell[49291, 1671, 269, 8, 52, "Notes",
  CellTags->"InsertObject"]
}, Closed]],

Cell[CellGroupData[{
Cell[49597, 1684, 58, 1, 55, "ObjectName",
  CellTags->"MoveNext"],
Cell[49658, 1687, 196, 6, 44, "Usage",
  CellTags->"MoveNext"],
Cell[49857, 1695, 230, 6, 37, "Notes",
  CellTags->"MoveNext"],
Cell[50090, 1703, 265, 8, 52, "Notes",
  CellTags->"MoveNext"]
}, Closed]],

Cell[CellGroupData[{
Cell[50392, 1716, 66, 1, 55, "ObjectName",
  CellTags->"MovePrevious"],
Cell[50461, 1719, 203, 6, 44, "Usage",
  CellTags->"MovePrevious"],
Cell[50667, 1727, 238, 6, 37, "Notes",
  CellTags->"MovePrevious"],
Cell[50908, 1735, 269, 8, 52, "Notes",
  CellTags->"MovePrevious"]
}, Closed]],

Cell[CellGroupData[{
Cell[51214, 1748, 62, 1, 55, "ObjectName",
  CellTags->"DeleteNext"],
Cell[51279, 1751, 209, 6, 44, "Usage",
  CellTags->"DeleteNext"],
Cell[51491, 1759, 234, 6, 37, "Notes",
  CellTags->"DeleteNext"],
Cell[51728, 1767, 267, 8, 52, "Notes",
  CellTags->"DeleteNext"]
}, Closed]],

Cell[CellGroupData[{
Cell[52032, 1780, 70, 1, 55, "ObjectName",
  CellTags->"DeletePrevious"],
Cell[52105, 1783, 216, 6, 44, "Usage",
  CellTags->"DeletePrevious"],
Cell[52324, 1791, 242, 6, 37, "Notes",
  CellTags->"DeletePrevious"],
Cell[52569, 1799, 271, 8, 52, "Notes",
  CellTags->"DeletePrevious"]
}, Closed]],

Cell[CellGroupData[{
Cell[52877, 1812, 66, 1, 55, "ObjectName",
  CellTags->"MoveNextWord"],
Cell[52946, 1815, 197, 5, 44, "Usage",
  CellTags->"MoveNextWord"],
Cell[53146, 1822, 239, 6, 37, "Notes",
  CellTags->"MoveNextWord"],
Cell[53388, 1830, 269, 8, 52, "Notes",
  CellTags->"MoveNextWord"]
}, Closed]],

Cell[CellGroupData[{
Cell[53694, 1843, 74, 1, 55, "ObjectName",
  CellTags->"MovePreviousWord"],
Cell[53771, 1846, 204, 5, 44, "Usage",
  CellTags->"MovePreviousWord"],
Cell[53978, 1853, 252, 7, 37, "Notes",
  CellTags->"MovePreviousWord"],
Cell[54233, 1862, 273, 8, 52, "Notes",
  CellTags->"MovePreviousWord"]
}, Closed]],

Cell[CellGroupData[{
Cell[54543, 1875, 70, 1, 55, "ObjectName",
  CellTags->"DeleteNextWord"],
Cell[54616, 1878, 212, 6, 44, "Usage",
  CellTags->"DeleteNextWord"],
Cell[54831, 1886, 243, 6, 37, "Notes",
  CellTags->"DeleteNextWord"],
Cell[55077, 1894, 271, 8, 52, "Notes",
  CellTags->"DeleteNextWord"]
}, Closed]],

Cell[CellGroupData[{
Cell[55385, 1907, 78, 1, 55, "ObjectName",
  CellTags->"DeletePreviousWord"],
Cell[55466, 1910, 219, 6, 44, "Usage",
  CellTags->"DeletePreviousWord"],
Cell[55688, 1918, 253, 7, 37, "Notes",
  CellTags->"DeletePreviousWord"],
Cell[55944, 1927, 275, 8, 52, "Notes",
  CellTags->"DeletePreviousWord"]
}, Closed]],

Cell[CellGroupData[{
Cell[56256, 1940, 64, 1, 55, "ObjectName",
  CellTags->"MoveLineEnd"],
Cell[56323, 1943, 210, 6, 44, "Usage",
  CellTags->"MoveLineEnd"],
Cell[56536, 1951, 237, 6, 37, "Notes",
  CellTags->"MoveLineEnd"],
Cell[56776, 1959, 268, 8, 52, "Notes",
  CellTags->"MoveLineEnd"]
}, Closed]],

Cell[CellGroupData[{
Cell[57081, 1972, 76, 1, 55, "ObjectName",
  CellTags->"MoveLineBeginning"],
Cell[57160, 1975, 228, 6, 60, "Usage",
  CellTags->"MoveLineBeginning"],
Cell[57391, 1983, 251, 7, 37, "Notes",
  CellTags->"MoveLineBeginning"],
Cell[57645, 1992, 274, 8, 52, "Notes",
  CellTags->"MoveLineBeginning"]
}, Closed]],

Cell[CellGroupData[{
Cell[57956, 2005, 66, 1, 55, "ObjectName",
  CellTags->"MoveNextLine"],
Cell[58025, 2008, 196, 5, 44, "Usage",
  CellTags->"MoveNextLine"],
Cell[58224, 2015, 239, 6, 37, "Notes",
  CellTags->"MoveNextLine"],
Cell[58466, 2023, 269, 8, 52, "Notes",
  CellTags->"MoveNextLine"]
}, Closed]],

Cell[CellGroupData[{
Cell[58772, 2036, 74, 1, 55, "ObjectName",
  CellTags->"MovePreviousLine"],
Cell[58849, 2039, 202, 5, 44, "Usage",
  CellTags->"MovePreviousLine"],
Cell[59054, 2046, 252, 7, 37, "Notes",
  CellTags->"MovePreviousLine"],
Cell[59309, 2055, 273, 8, 52, "Notes",
  CellTags->"MovePreviousLine"]
}, Closed]],

Cell[CellGroupData[{
Cell[59619, 2068, 64, 1, 55, "ObjectName",
  CellTags->"Superscript"],
Cell[59686, 2071, 251, 7, 60, "Usage",
  CellTags->"Superscript"],
Cell[59940, 2080, 247, 7, 37, "Notes",
  CellTags->"Superscript"],
Cell[60190, 2089, 227, 6, 52, "Notes",
  CellTags->"Superscript"],
Cell[60420, 2097, 268, 8, 52, "Notes",
  CellTags->"Superscript"]
}, Closed]],

Cell[CellGroupData[{
Cell[60725, 2110, 60, 1, 55, "ObjectName",
  CellTags->"Subscript"],
Cell[60788, 2113, 245, 7, 60, "Usage",
  CellTags->"Subscript"],
Cell[61036, 2122, 243, 7, 37, "Notes",
  CellTags->"Subscript"],
Cell[61282, 2131, 223, 6, 36, "Notes",
  CellTags->"Subscript"],
Cell[61508, 2139, 266, 8, 52, "Notes",
  CellTags->"Subscript"]
}, Closed]],

Cell[CellGroupData[{
Cell[61811, 2152, 52, 1, 55, "ObjectName",
  CellTags->"Above"],
Cell[61866, 2155, 239, 7, 60, "Usage",
  CellTags->"Above"],
Cell[62108, 2164, 233, 6, 37, "Notes",
  CellTags->"Above"],
Cell[62344, 2172, 215, 6, 36, "Notes",
  CellTags->"Above"],
Cell[62562, 2180, 262, 8, 52, "Notes",
  CellTags->"Above"]
}, Closed]],

Cell[CellGroupData[{
Cell[62861, 2193, 52, 1, 55, "ObjectName",
  CellTags->"Below"],
Cell[62916, 2196, 240, 7, 60, "Usage",
  CellTags->"Below"],
Cell[63159, 2205, 233, 6, 37, "Notes",
  CellTags->"Below"],
Cell[63395, 2213, 215, 6, 36, "Notes",
  CellTags->"Below"],
Cell[63613, 2221, 262, 8, 52, "Notes",
  CellTags->"Below"]
}, Closed]],

Cell[CellGroupData[{
Cell[63912, 2234, 64, 1, 55, "ObjectName",
  CellTags->"Otherscript"],
Cell[63979, 2237, 206, 6, 44, "Usage",
  CellTags->"Otherscript"],
Cell[64188, 2245, 253, 7, 37, "Notes",
  CellTags->"Otherscript"],
Cell[64444, 2254, 730, 14, 157, "Notes",
  CellTags->"Otherscript"],
Cell[65177, 2270, 268, 8, 52, "Notes",
  CellTags->"Otherscript"]
}, Closed]],

Cell[CellGroupData[{
Cell[65482, 2283, 58, 1, 55, "ObjectName",
  CellTags->"Fraction"],
Cell[65543, 2286, 246, 7, 60, "Usage",
  CellTags->"Fraction"],
Cell[65792, 2295, 244, 7, 37, "Notes",
  CellTags->"Fraction"],
Cell[66039, 2304, 222, 6, 36, "Notes",
  CellTags->"Fraction"],
Cell[66264, 2312, 265, 8, 52, "Notes",
  CellTags->"Fraction"]
}, Closed]],

Cell[CellGroupData[{
Cell[66566, 2325, 56, 1, 55, "ObjectName",
  CellTags->"Radical"],
Cell[66625, 2328, 235, 7, 44, "Usage",
  CellTags->"Radical"],
Cell[66863, 2337, 237, 6, 37, "Notes",
  CellTags->"Radical"],
Cell[67103, 2345, 179, 5, 36, "Notes",
  CellTags->"Radical"],
Cell[67285, 2352, 264, 8, 52, "Notes",
  CellTags->"Radical"]
}, Closed]],

Cell[CellGroupData[{
Cell[67586, 2365, 54, 1, 55, "ObjectName",
  CellTags->"NewRow"],
Cell[67643, 2368, 203, 7, 44, "Usage",
  CellTags->"NewRow"],
Cell[67849, 2377, 236, 6, 37, "Notes",
  CellTags->"NewRow"],
Cell[68088, 2385, 176, 7, 36, "Notes",
  CellTags->"NewRow"],
Cell[68267, 2394, 263, 8, 52, "Notes",
  CellTags->"NewRow"]
}, Closed]],

Cell[CellGroupData[{
Cell[68567, 2407, 60, 1, 55, "ObjectName",
  CellTags->"NewColumn"],
Cell[68630, 2410, 216, 7, 44, "Usage",
  CellTags->"NewColumn"],
Cell[68849, 2419, 244, 7, 37, "Notes",
  CellTags->"NewColumn"],
Cell[69096, 2428, 182, 7, 36, "Notes",
  CellTags->"NewColumn"],
Cell[69281, 2437, 266, 8, 52, "Notes",
  CellTags->"NewColumn"]
}, Closed]],

Cell[CellGroupData[{
Cell[69584, 2450, 76, 1, 55, "ObjectName",
  CellTags->"MoveExpressionEnd"],
Cell[69663, 2453, 232, 6, 60, "Usage",
  CellTags->"MoveExpressionEnd"],
Cell[69898, 2461, 259, 7, 37, "Notes",
  CellTags->"MoveExpressionEnd"],
Cell[70160, 2470, 274, 8, 52, "Notes",
  CellTags->"MoveExpressionEnd"]
}, Closed]],

Cell[CellGroupData[{
Cell[70471, 2483, 72, 1, 55, "ObjectName",
  CellTags->"ExpandSelection"],
Cell[70546, 2486, 232, 6, 60, "Usage",
  CellTags->"ExpandSelection"],
Cell[70781, 2494, 256, 7, 37, "Notes",
  CellTags->"ExpandSelection"],
Cell[71040, 2503, 162, 5, 36, "Notes",
  CellTags->"ExpandSelection"],
Cell[71205, 2510, 272, 8, 52, "Notes",
  CellTags->"ExpandSelection"]
}, Closed]],

Cell[CellGroupData[{
Cell[71514, 2523, 74, 1, 55, "ObjectName",
  CellTags->"CreateInlineCell"],
Cell[71591, 2526, 187, 5, 44, "Usage",
  CellTags->"CreateInlineCell"],
Cell[71781, 2533, 258, 7, 37, "Notes",
  CellTags->"CreateInlineCell"],
Cell[72042, 2542, 207, 5, 52, "Notes",
  CellTags->"CreateInlineCell"],
Cell[72252, 2549, 273, 8, 52, "Notes",
  CellTags->"CreateInlineCell"]
}, Closed]],

Cell[CellGroupData[{
Cell[72562, 2562, 68, 1, 55, "ObjectName",
  CellTags->"EndInlineCell"],
Cell[72633, 2565, 175, 5, 44, "Usage",
  CellTags->"EndInlineCell"],
Cell[72811, 2572, 253, 7, 37, "Notes",
  CellTags->"EndInlineCell"],
Cell[73067, 2581, 270, 8, 52, "Notes",
  CellTags->"EndInlineCell"]
}, Closed]],

Cell[CellGroupData[{
Cell[73374, 2594, 80, 1, 55, "ObjectName",
  CellTags->"InsertRawExpression"],
Cell[73457, 2597, 233, 6, 60, "Usage",
  CellTags->"InsertRawExpression"],
Cell[73693, 2605, 265, 7, 37, "Notes",
  CellTags->"InsertRawExpression"],
Cell[73961, 2614, 146, 4, 36, "Notes",
  CellTags->"InsertRawExpression"],
Cell[74110, 2620, 276, 8, 52, "Notes",
  CellTags->"InsertRawExpression"]
}, Closed]],

Cell[CellGroupData[{
Cell[74423, 2633, 76, 1, 55, "ObjectName",
  CellTags->"AddInterpretation"],
Cell[74502, 2636, 403, 12, 60, "Usage",
  CellTags->"AddInterpretation"],
Cell[74908, 2650, 257, 7, 37, "Notes",
  CellTags->"AddInterpretation"],
Cell[75168, 2659, 144, 4, 36, "Notes",
  CellTags->"AddInterpretation"],
Cell[75315, 2665, 274, 8, 52, "Notes",
  CellTags->"AddInterpretation"]
}, Closed]],

Cell[CellGroupData[{
Cell[75626, 2678, 60, 1, 55, "ObjectName",
  CellTags->"NudgeLeft"],
Cell[75689, 2681, 284, 8, 60, "Usage",
  CellTags->"NudgeLeft"],
Cell[75976, 2691, 244, 7, 37, "Notes",
  CellTags->"NudgeLeft"],
Cell[76223, 2700, 266, 8, 52, "Notes",
  CellTags->"NudgeLeft"]
}, Closed]],

Cell[CellGroupData[{
Cell[76526, 2713, 62, 1, 55, "ObjectName",
  CellTags->"NudgeRight"],
Cell[76591, 2716, 287, 8, 60, "Usage",
  CellTags->"NudgeRight"],
Cell[76881, 2726, 246, 7, 37, "Notes",
  CellTags->"NudgeRight"],
Cell[77130, 2735, 267, 8, 52, "Notes",
  CellTags->"NudgeRight"]
}, Closed]],

Cell[CellGroupData[{
Cell[77434, 2748, 56, 1, 55, "ObjectName",
  CellTags->"NudgeUp"],
Cell[77493, 2751, 271, 8, 60, "Usage",
  CellTags->"NudgeUp"],
Cell[77767, 2761, 243, 7, 37, "Notes",
  CellTags->"NudgeUp"],
Cell[78013, 2770, 264, 8, 52, "Notes",
  CellTags->"NudgeUp"]
}, Closed]],

Cell[CellGroupData[{
Cell[78314, 2783, 60, 1, 55, "ObjectName",
  CellTags->"NudgeDown"],
Cell[78377, 2786, 277, 8, 60, "Usage",
  CellTags->"NudgeDown"],
Cell[78657, 2796, 244, 7, 37, "Notes",
  CellTags->"NudgeDown"],
Cell[78904, 2805, 266, 8, 52, "Notes",
  CellTags->"NudgeDown"]
}, Closed]],

Cell[CellGroupData[{
Cell[79207, 2818, 76, 1, 55, "ObjectName",
  CellTags->"RemoveAdjustments"],
Cell[79286, 2821, 259, 7, 60, "Usage",
  CellTags->"RemoveAdjustments"],
Cell[79548, 2830, 260, 7, 37, "Notes",
  CellTags->"RemoveAdjustments"],
Cell[79811, 2839, 274, 8, 52, "Notes",
  CellTags->"RemoveAdjustments"]
}, Closed]],

Cell[CellGroupData[{
Cell[80122, 2852, 54, 1, 55, "ObjectName",
  CellTags->"Make2D"],
Cell[80179, 2855, 249, 6, 60, "Usage",
  CellTags->"Make2D"],
Cell[80431, 2863, 201, 6, 37, "Notes",
  CellTags->"Make2D"],
Cell[80635, 2871, 263, 8, 52, "Notes",
  CellTags->"Make2D"]
}, Closed]],

Cell[CellGroupData[{
Cell[80935, 2884, 56, 1, 55, "ObjectName",
  CellTags->"Balance"],
Cell[80994, 2887, 253, 6, 60, "Usage",
  CellTags->"Balance"],
Cell[81250, 2895, 209, 6, 37, "Notes",
  CellTags->"Balance"],
Cell[81462, 2903, 401, 11, 52, "Notes",
  CellTags->"Balance"],
Cell[81866, 2916, 264, 8, 52, "Notes",
  CellTags->"Balance"]
}, Closed]],

Cell[CellGroupData[{
Cell[82167, 2929, 80, 1, 55, "ObjectName",
  CellTags->"FindNextMisspelling"],
Cell[82250, 2932, 239, 6, 60, "Usage",
  CellTags->"FindNextMisspelling"],
Cell[82492, 2940, 222, 6, 37, "Notes",
  CellTags->"FindNextMisspelling"],
Cell[82717, 2948, 352, 7, 67, "Notes",
  CellTags->"FindNextMisspelling"],
Cell[83072, 2957, 276, 8, 52, "Notes",
  CellTags->"FindNextMisspelling"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[83397, 2971, 30, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[83452, 2975, 74, 1, 55, "ObjectName",
  CellTags->"SelectionConvert"],
Cell[83529, 2978, 209, 6, 44, "Usage",
  CellTags->"SelectionConvert"],
Cell[83741, 2986, 215, 6, 37, "Notes",
  CellTags->"SelectionConvert"],
Cell[83959, 2994, 149, 4, 36, "Notes",
  CellTags->"SelectionConvert"],
Cell[84111, 3000, 4611, 102, 397, "2ColumnTable",
  CellTags->"SelectionConvert"],
Cell[88725, 3104, 273, 8, 52, "Notes",
  CellTags->"SelectionConvert"]
}, Closed]],

Cell[CellGroupData[{
Cell[89035, 3117, 78, 1, 55, "ObjectName",
  CellTags->"SelectionDisplayAs"],
Cell[89116, 3120, 214, 6, 44, "Usage",
  CellTags->"SelectionDisplayAs"],
Cell[89333, 3128, 217, 6, 37, "Notes",
  CellTags->"SelectionDisplayAs"],
Cell[89553, 3136, 281, 6, 52, "Notes",
  CellTags->"SelectionDisplayAs"],
Cell[89837, 3144, 151, 4, 36, "Notes",
  CellTags->"SelectionDisplayAs"],
Cell[89991, 3150, 1595, 40, 112, "2ColumnTable",
  CellTags->"SelectionDisplayAs"],
Cell[91589, 3192, 275, 8, 52, "Notes",
  CellTags->"SelectionDisplayAs"]
}, Closed]],

Cell[CellGroupData[{
Cell[91901, 3205, 60, 1, 55, "ObjectName",
  CellTags->"CellGroup"],
Cell[91964, 3208, 183, 5, 44, "Usage",
  CellTags->"CellGroup"],
Cell[92150, 3215, 245, 7, 37, "Notes",
  CellTags->"CellGroup"],
Cell[92398, 3224, 309, 9, 37, "Notes",
  CellTags->"CellGroup"],
Cell[92710, 3235, 266, 8, 52, "Notes",
  CellTags->"CellGroup"]
}, Closed]],

Cell[CellGroupData[{
Cell[93013, 3248, 64, 1, 55, "ObjectName",
  CellTags->"CellUngroup"],
Cell[93080, 3251, 189, 5, 44, "Usage",
  CellTags->"CellUngroup"],
Cell[93272, 3258, 246, 7, 37, "Notes",
  CellTags->"CellUngroup"],
Cell[93521, 3267, 311, 9, 37, "Notes",
  CellTags->"CellUngroup"],
Cell[93835, 3278, 268, 8, 52, "Notes",
  CellTags->"CellUngroup"]
}, Closed]],

Cell[CellGroupData[{
Cell[94140, 3291, 86, 1, 55, "ObjectName",
  CellTags->"SelectionOpenAllGroups"],
Cell[94229, 3294, 231, 6, 60, "Usage",
  CellTags->"SelectionOpenAllGroups"],
Cell[94463, 3302, 262, 7, 37, "Notes",
  CellTags->"SelectionOpenAllGroups"],
Cell[94728, 3311, 279, 8, 52, "Notes",
  CellTags->"SelectionOpenAllGroups"]
}, Closed]],

Cell[CellGroupData[{
Cell[95044, 3324, 88, 1, 55, "ObjectName",
  CellTags->"SelectionCloseAllGroups"],
Cell[95135, 3327, 233, 6, 60, "Usage",
  CellTags->"SelectionCloseAllGroups"],
Cell[95371, 3335, 264, 7, 37, "Notes",
  CellTags->"SelectionCloseAllGroups"],
Cell[95638, 3344, 280, 8, 52, "Notes",
  CellTags->"SelectionCloseAllGroups"]
}, Closed]],

Cell[CellGroupData[{
Cell[95955, 3357, 70, 1, 55, "ObjectName",
  CellTags->"OpenCloseGroup"],
Cell[96028, 3360, 243, 6, 60, "Usage",
  CellTags->"OpenCloseGroup"],
Cell[96274, 3368, 252, 7, 37, "Notes",
  CellTags->"OpenCloseGroup"],
Cell[96529, 3377, 145, 4, 36, "Notes",
  CellTags->"OpenCloseGroup"],
Cell[96677, 3383, 271, 8, 52, "Notes",
  CellTags->"OpenCloseGroup"]
}, Closed]],

Cell[CellGroupData[{
Cell[96985, 3396, 60, 1, 55, "ObjectName",
  CellTags->"CellSplit"],
Cell[97048, 3399, 212, 6, 44, "Usage",
  CellTags->"CellSplit"],
Cell[97263, 3407, 209, 6, 37, "Notes",
  CellTags->"CellSplit"],
Cell[97475, 3415, 291, 6, 52, "Notes",
  CellTags->"CellSplit"],
Cell[97769, 3423, 266, 8, 52, "Notes",
  CellTags->"CellSplit"]
}, Closed]],

Cell[CellGroupData[{
Cell[98072, 3436, 60, 1, 55, "ObjectName",
  CellTags->"CellMerge"],
Cell[98135, 3439, 187, 5, 44, "Usage",
  CellTags->"CellMerge"],
Cell[98325, 3446, 209, 6, 37, "Notes",
  CellTags->"CellMerge"],
Cell[98537, 3454, 266, 8, 52, "Notes",
  CellTags->"CellMerge"]
}, Closed]],

Cell[CellGroupData[{
Cell[98840, 3467, 74, 1, 55, "ObjectName",
  CellTags->"SelectionAnimate"],
Cell[98917, 3470, 210, 6, 44, "Usage",
  CellTags->"SelectionAnimate"],
Cell[99130, 3478, 230, 6, 37, "Notes",
  CellTags->"SelectionAnimate"],
Cell[99363, 3486, 299, 8, 36, "Notes",
  CellTags->"SelectionAnimate"],
Cell[99665, 3496, 273, 8, 52, "Notes",
  CellTags->"SelectionAnimate"]
}, Closed]],

Cell[CellGroupData[{
Cell[99975, 3509, 60, 1, 55, "ObjectName",
  CellTags->"SoundPlay"],
Cell[100038, 3512, 195, 6, 44, "Usage",
  CellTags->"SoundPlay"],
Cell[100236, 3520, 208, 6, 37, "Notes",
  CellTags->"SoundPlay"],
Cell[100447, 3528, 215, 7, 36, "Notes",
  CellTags->"SoundPlay"],
Cell[100665, 3537, 278, 10, 52, "Notes",
  CellTags->"SoundPlay"]
}, Closed]],

Cell[CellGroupData[{
Cell[100980, 3552, 70, 1, 55, "ObjectName",
  CellTags->"GraphicsRender"],
Cell[101053, 3555, 194, 5, 44, "Usage",
  CellTags->"GraphicsRender"],
Cell[101250, 3562, 220, 6, 37, "Notes",
  CellTags->"GraphicsRender"],
Cell[101473, 3570, 191, 5, 52, "Notes",
  CellTags->"GraphicsRender"],
Cell[101667, 3577, 283, 10, 52, "Notes",
  CellTags->"GraphicsRender"]
}, Closed]],

Cell[CellGroupData[{
Cell[101987, 3592, 80, 1, 55, "ObjectName",
  CellTags->"GenerateImageCaches"],
Cell[102070, 3595, 225, 6, 60, "Usage",
  CellTags->"GenerateImageCaches"],
Cell[102298, 3603, 234, 6, 37, "Notes",
  CellTags->"GenerateImageCaches"],
Cell[102535, 3611, 288, 10, 52, "Notes",
  CellTags->"GenerateImageCaches"]
}, Closed]],

Cell[CellGroupData[{
Cell[102860, 3626, 82, 1, 55, "ObjectName",
  CellTags->"GraphicsOriginalSize"],
Cell[102945, 3629, 224, 6, 44, "Usage",
  CellTags->"GraphicsOriginalSize"],
Cell[103172, 3637, 191, 5, 24, "Notes"],
Cell[103366, 3644, 351, 7, 67, "Notes",
  CellTags->"GraphicsOriginalSize"],
Cell[103720, 3653, 289, 10, 52, "Notes",
  CellTags->"GraphicsOriginalSize"]
}, Closed]],

Cell[CellGroupData[{
Cell[104046, 3668, 68, 1, 55, "ObjectName",
  CellTags->"GraphicsAlign"],
Cell[104117, 3671, 202, 6, 44, "Usage",
  CellTags->"GraphicsAlign"],
Cell[104322, 3679, 225, 6, 37, "Notes",
  CellTags->"GraphicsAlign"],
Cell[104550, 3687, 421, 12, 52, "Notes",
  CellTags->"GraphicsAlign"],
Cell[104974, 3701, 282, 10, 52, "Notes",
  CellTags->"GraphicsAlign"]
}, Closed]],

Cell[CellGroupData[{
Cell[105293, 3716, 90, 1, 55, "ObjectName",
  CellTags->"NotebookStatisticsDialog"],
Cell[105386, 3719, 220, 5, 44, "Usage",
  CellTags->"NotebookStatisticsDialog"],
Cell[105609, 3726, 233, 6, 37, "Notes",
  CellTags->"NotebookStatisticsDialog"],
Cell[105845, 3734, 317, 8, 36, "Notes",
  CellTags->"NotebookStatisticsDialog"],
Cell[106165, 3744, 293, 10, 52, "Notes",
  CellTags->"NotebookStatisticsDialog"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[106507, 3760, 32, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[106564, 3764, 62, 1, 55, "ObjectName",
  CellTags->"StyleOther"],
Cell[106629, 3767, 182, 5, 44, "Usage",
  CellTags->"StyleOther"],
Cell[106814, 3774, 206, 6, 37, "Notes",
  CellTags->"StyleOther"],
Cell[107023, 3782, 249, 5, 52, "Notes",
  CellTags->"StyleOther"],
Cell[107275, 3789, 279, 10, 52, "Notes",
  CellTags->"StyleOther"]
}, Closed]],

Cell[CellGroupData[{
Cell[107591, 3804, 82, 1, 55, "ObjectName",
  CellTags->"ToggleShowExpression"],
Cell[107676, 3807, 272, 7, 60, "Usage",
  CellTags->"ToggleShowExpression"],
Cell[107951, 3816, 226, 6, 37, "Notes",
  CellTags->"ToggleShowExpression"],
Cell[108180, 3824, 289, 10, 52, "Notes",
  CellTags->"ToggleShowExpression"]
}, Closed]],

Cell[CellGroupData[{
Cell[108506, 3839, 68, 1, 55, "ObjectName",
  CellTags->"OptionsDialog"],
Cell[108577, 3842, 228, 6, 60, "Usage",
  CellTags->"OptionsDialog"],
Cell[108808, 3850, 220, 6, 37, "Notes",
  CellTags->"OptionsDialog"],
Cell[109031, 3858, 282, 10, 52, "Notes",
  CellTags->"OptionsDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[109350, 3873, 74, 1, 55, "ObjectName",
  CellTags->"ClearCellOptions"],
Cell[109427, 3876, 194, 5, 44, "Usage",
  CellTags->"ClearCellOptions"],
Cell[109624, 3883, 221, 6, 37, "Notes",
  CellTags->"ClearCellOptions"],
Cell[109848, 3891, 250, 5, 52, "Notes",
  CellTags->"ClearCellOptions"],
Cell[110101, 3898, 285, 10, 52, "Notes",
  CellTags->"ClearCellOptions"]
}, Closed]],

Cell[CellGroupData[{
Cell[110423, 3913, 84, 1, 55, "ObjectName",
  CellTags->"StyleDefinitionsOther"],
Cell[110510, 3916, 253, 6, 60, "Usage",
  CellTags->"StyleDefinitionsOther"],
Cell[110766, 3924, 223, 6, 37, "Notes",
  CellTags->"StyleDefinitionsOther"],
Cell[110992, 3932, 211, 6, 36, "Notes",
  CellTags->"StyleDefinitionsOther"],
Cell[111206, 3940, 290, 10, 52, "Notes",
  CellTags->"StyleDefinitionsOther"]
}, Closed]],

Cell[CellGroupData[{
Cell[111533, 3955, 82, 1, 55, "ObjectName",
  CellTags->"EditStyleDefinitions"],
Cell[111618, 3958, 231, 6, 60, "Usage",
  CellTags->"EditStyleDefinitions"],
Cell[111852, 3966, 227, 6, 37, "Notes",
  CellTags->"EditStyleDefinitions"],
Cell[112082, 3974, 373, 7, 72, "Notes",
  CellTags->"EditStyleDefinitions"],
Cell[112458, 3983, 289, 10, 52, "Notes",
  CellTags->"EditStyleDefinitions"]
}, Closed]],

Cell[CellGroupData[{
Cell[112784, 3998, 60, 1, 55, "ObjectName",
  CellTags->"PlainFont"],
Cell[112847, 4001, 369, 13, 60, "Usage",
  CellTags->"PlainFont"],
Cell[113219, 4016, 227, 6, 37, "Notes",
  CellTags->"PlainFont"],
Cell[113449, 4024, 278, 10, 52, "Notes",
  CellTags->"PlainFont"]
}, Closed]],

Cell[CellGroupData[{
Cell[113764, 4039, 70, 1, 55, "ObjectName",
  CellTags->"FontSizeDialog"],
Cell[113837, 4042, 235, 6, 60, "Usage",
  CellTags->"FontSizeDialog"],
Cell[114075, 4050, 231, 6, 37, "Notes",
  CellTags->"FontSizeDialog"],
Cell[114309, 4058, 283, 10, 52, "Notes",
  CellTags->"FontSizeDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[114629, 4073, 72, 1, 55, "ObjectName",
  CellTags->"FontColorDialog"],
Cell[114704, 4076, 233, 6, 60, "Usage",
  CellTags->"FontColorDialog"],
Cell[114940, 4084, 238, 6, 37, "Notes",
  CellTags->"FontColorDialog"],
Cell[115181, 4092, 284, 10, 52, "Notes",
  CellTags->"FontColorDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[115502, 4107, 68, 1, 55, "ObjectName",
  CellTags->"ToggleGrayBox"],
Cell[115573, 4110, 360, 10, 60, "Usage",
  CellTags->"ToggleGrayBox"],
Cell[115936, 4122, 253, 7, 37, "Notes",
  CellTags->"ToggleGrayBox"],
Cell[116192, 4131, 282, 10, 52, "Notes",
  CellTags->"ToggleGrayBox"]
}, Closed]],

Cell[CellGroupData[{
Cell[116511, 4146, 74, 1, 55, "ObjectName",
  CellTags->"BackgroundDialog"],
Cell[116588, 4149, 262, 6, 60, "Usage",
  CellTags->"BackgroundDialog"],
Cell[116853, 4157, 246, 6, 37, "Notes",
  CellTags->"BackgroundDialog"],
Cell[117102, 4165, 285, 10, 52, "Notes",
  CellTags->"BackgroundDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[117424, 4180, 60, 1, 55, "ObjectName",
  CellTags->"FontPanel"],
Cell[117487, 4183, 228, 6, 60, "Usage",
  CellTags->"FontPanel"],
Cell[117718, 4191, 247, 7, 37, "Notes",
  CellTags->"FontPanel"],
Cell[117968, 4200, 113, 4, 36, "Notes",
  CellTags->"FontPanel"],
Cell[118084, 4206, 278, 10, 52, "Notes",
  CellTags->"FontPanel"]
}, Closed]],

Cell[CellGroupData[{
Cell[118399, 4221, 66, 1, 55, "ObjectName",
  CellTags->"FixCellWidth"],
Cell[118468, 4224, 283, 8, 60, "Usage",
  CellTags->"FixCellWidth"],
Cell[118754, 4234, 257, 7, 37, "Notes",
  CellTags->"FixCellWidth"],
Cell[119014, 4243, 281, 10, 52, "Notes",
  CellTags->"FixCellWidth"]
}, Closed]],

Cell[CellGroupData[{
Cell[119332, 4258, 88, 1, 55, "ObjectName",
  CellTags->"ToggleOptionListElement"],
Cell[119423, 4261, 249, 6, 60, "Usage",
  CellTags->"ToggleOptionListElement"],
Cell[119675, 4269, 224, 6, 37, "Notes",
  CellTags->"ToggleOptionListElement"],
Cell[119902, 4277, 292, 10, 52, "Notes",
  CellTags->"ToggleOptionListElement"]
}, Closed]],

Cell[CellGroupData[{
Cell[120231, 4292, 70, 1, 55, "ObjectName",
  CellTags->"ShowPageBreaks"],
Cell[120304, 4295, 209, 6, 44, "Usage",
  CellTags->"ShowPageBreaks"],
Cell[120516, 4303, 221, 6, 37, "Notes",
  CellTags->"ShowPageBreaks"],
Cell[120740, 4311, 263, 9, 52, "Notes",
  CellTags->"ShowPageBreaks"],
Cell[121006, 4322, 283, 10, 52, "Notes",
  CellTags->"ShowPageBreaks"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[121338, 4338, 31, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[121394, 4342, 92, 1, 55, "ObjectName",
  CellTags->"GraphicsCoordinatesDialog"],
Cell[121489, 4345, 277, 6, 60, "Usage",
  CellTags->"GraphicsCoordinatesDialog"],
Cell[121769, 4353, 239, 6, 37, "Notes",
  CellTags->"GraphicsCoordinatesDialog"],
Cell[122011, 4361, 294, 10, 52, "Notes",
  CellTags->"GraphicsCoordinatesDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[122342, 4376, 88, 1, 55, "ObjectName",
  CellTags->"ViewPointSelectorDialog"],
Cell[122433, 4379, 299, 7, 60, "Usage",
  CellTags->"ViewPointSelectorDialog"],
Cell[122735, 4388, 234, 6, 37, "Notes",
  CellTags->"ViewPointSelectorDialog"],
Cell[122972, 4396, 292, 10, 52, "Notes",
  CellTags->"ViewPointSelectorDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[123301, 4411, 80, 1, 55, "ObjectName",
  CellTags->"ColorSelectorDialog"],
Cell[123384, 4414, 308, 9, 60, "Usage",
  CellTags->"ColorSelectorDialog"],
Cell[123695, 4425, 223, 6, 37, "Notes",
  CellTags->"ColorSelectorDialog"],
Cell[123921, 4433, 125, 4, 36, "Notes",
  CellTags->"ColorSelectorDialog"],
Cell[124049, 4439, 288, 10, 52, "Notes",
  CellTags->"ColorSelectorDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[124374, 4454, 76, 1, 55, "ObjectName",
  CellTags->"RecordSoundDialog"],
Cell[124453, 4457, 303, 9, 60, "Usage",
  CellTags->"RecordSoundDialog"],
Cell[124759, 4468, 219, 6, 37, "Notes",
  CellTags->"RecordSoundDialog"],
Cell[124981, 4476, 286, 10, 52, "Notes",
  CellTags->"RecordSoundDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[125304, 4491, 70, 1, 55, "ObjectName",
  CellTags->"FileNameDialog"],
Cell[125377, 4494, 218, 6, 44, "Usage",
  CellTags->"FileNameDialog"],
Cell[125598, 4502, 217, 6, 37, "Notes",
  CellTags->"FileNameDialog"],
Cell[125818, 4510, 256, 7, 52, "Notes",
  CellTags->"FileNameDialog"],
Cell[126077, 4519, 283, 10, 52, "Notes",
  CellTags->"FileNameDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[126397, 4534, 80, 1, 55, "ObjectName",
  CellTags->"CreateGridBoxDialog"],
Cell[126480, 4537, 214, 6, 44, "Usage",
  CellTags->"CreateGridBoxDialog"],
Cell[126697, 4545, 236, 6, 37, "Notes",
  CellTags->"CreateGridBoxDialog"],
Cell[126936, 4553, 288, 10, 52, "Notes",
  CellTags->"CreateGridBoxDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[127261, 4568, 84, 1, 55, "ObjectName",
  CellTags->"CreateCustomButtonBox"],
Cell[127348, 4571, 262, 6, 60, "Usage",
  CellTags->"CreateCustomButtonBox"],
Cell[127613, 4579, 224, 6, 37, "Notes",
  CellTags->"CreateCustomButtonBox"],
Cell[127840, 4587, 290, 10, 52, "Notes",
  CellTags->"CreateCustomButtonBox"]
}, Closed]],

Cell[CellGroupData[{
Cell[128167, 4602, 80, 1, 55, "ObjectName",
  CellTags->"EditButtonBoxDialog"],
Cell[128250, 4605, 200, 5, 44, "Usage",
  CellTags->"EditButtonBoxDialog"],
Cell[128453, 4612, 220, 6, 37, "Notes",
  CellTags->"EditButtonBoxDialog"],
Cell[128676, 4620, 288, 10, 52, "Notes",
  CellTags->"EditButtonBoxDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[129001, 4635, 84, 1, 55, "ObjectName",
  CellTags->"CreateHyperlinkDialog"],
Cell[129088, 4638, 209, 5, 44, "Usage",
  CellTags->"CreateHyperlinkDialog"],
Cell[129300, 4645, 227, 6, 37, "Notes",
  CellTags->"CreateHyperlinkDialog"],
Cell[129530, 4653, 290, 10, 52, "Notes",
  CellTags->"CreateHyperlinkDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[129857, 4668, 86, 1, 55, "ObjectName",
  CellTags->"CreateCounterBoxDialog"],
Cell[129946, 4671, 230, 6, 60, "Usage",
  CellTags->"CreateCounterBoxDialog"],
Cell[130179, 4679, 245, 6, 37, "Notes",
  CellTags->"CreateCounterBoxDialog"],
Cell[130427, 4687, 291, 10, 52, "Notes",
  CellTags->"CreateCounterBoxDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[130755, 4702, 82, 1, 55, "ObjectName",
  CellTags->"CreateValueBoxDialog"],
Cell[130840, 4705, 211, 5, 44, "Usage",
  CellTags->"CreateValueBoxDialog"],
Cell[131054, 4712, 243, 6, 37, "Notes",
  CellTags->"CreateValueBoxDialog"],
Cell[131300, 4720, 289, 10, 52, "Notes",
  CellTags->"CreateValueBoxDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[131626, 4735, 86, 1, 55, "ObjectName",
  CellTags->"DuplicatePreviousInput"],
Cell[131715, 4738, 270, 6, 60, "Usage",
  CellTags->"DuplicatePreviousInput"],
Cell[131988, 4746, 233, 6, 37, "Notes",
  CellTags->"DuplicatePreviousInput"],
Cell[132224, 4754, 291, 10, 52, "Notes",
  CellTags->"DuplicatePreviousInput"]
}, Closed]],

Cell[CellGroupData[{
Cell[132552, 4769, 88, 1, 55, "ObjectName",
  CellTags->"DuplicatePreviousOutput"],
Cell[132643, 4772, 273, 6, 60, "Usage",
  CellTags->"DuplicatePreviousOutput"],
Cell[132919, 4780, 235, 6, 37, "Notes",
  CellTags->"DuplicatePreviousOutput"],
Cell[133157, 4788, 292, 10, 52, "Notes",
  CellTags->"DuplicatePreviousOutput"]
}, Closed]],

Cell[CellGroupData[{
Cell[133486, 4803, 74, 1, 55, "ObjectName",
  CellTags->"SimilarCellBelow"],
Cell[133563, 4806, 264, 6, 60, "Usage",
  CellTags->"SimilarCellBelow"],
Cell[133830, 4814, 226, 6, 37, "Notes",
  CellTags->"SimilarCellBelow"],
Cell[134059, 4822, 132, 4, 36, "Notes",
  CellTags->"SimilarCellBelow"],
Cell[134194, 4828, 285, 10, 52, "Notes",
  CellTags->"SimilarCellBelow"]
}, Closed]],

Cell[CellGroupData[{
Cell[134516, 4843, 76, 1, 55, "ObjectName",
  CellTags->"CompleteSelection"],
Cell[134595, 4846, 205, 5, 44, "Usage",
  CellTags->"CompleteSelection"],
Cell[134803, 4853, 225, 6, 37, "Notes",
  CellTags->"CompleteSelection"],
Cell[135031, 4861, 450, 10, 67, "Notes",
  CellTags->"CompleteSelection"],
Cell[135484, 4873, 286, 10, 52, "Notes",
  CellTags->"CompleteSelection"]
}, Closed]],

Cell[CellGroupData[{
Cell[135807, 4888, 76, 1, 55, "ObjectName",
  CellTags->"TemplateSelection"],
Cell[135886, 4891, 231, 6, 60, "Usage",
  CellTags->"TemplateSelection"],
Cell[136120, 4899, 220, 6, 37, "Notes",
  CellTags->"TemplateSelection"],
Cell[136343, 4907, 397, 9, 52, "Notes",
  CellTags->"TemplateSelection"],
Cell[136743, 4918, 286, 10, 52, "Notes",
  CellTags->"TemplateSelection"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[137078, 4934, 32, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[137135, 4938, 68, 1, 38, "ObjectName",
  CellTags->"EvaluateCells"],
Cell[137206, 4941, 211, 6, 44, "Usage",
  CellTags->"EvaluateCells"],
Cell[137420, 4949, 248, 7, 37, "Notes",
  CellTags->"EvaluateCells"],
Cell[137671, 4958, 391, 10, 52, "Notes",
  CellTags->"EvaluateCells"],
Cell[138065, 4970, 282, 10, 52, "Notes",
  CellTags->"EvaluateCells"]
}, Closed]],

Cell[CellGroupData[{
Cell[138384, 4985, 58, 1, 42, "ObjectName",
  CellTags->"Evaluate"],
Cell[138445, 4988, 178, 5, 44, "Usage",
  CellTags->"Evaluate"],
Cell[138626, 4995, 246, 7, 37, "Notes",
  CellTags->"Evaluate"],
Cell[138875, 5004, 317, 8, 52, "Notes",
  CellTags->"Evaluate"],
Cell[139195, 5014, 277, 10, 52, "Notes",
  CellTags->"Evaluate"]
}, Closed]],

Cell[CellGroupData[{
Cell[139509, 5029, 74, 1, 42, "ObjectName",
  CellTags->"EvaluateNextCell"],
Cell[139586, 5032, 232, 6, 60, "Usage",
  CellTags->"EvaluateNextCell"],
Cell[139821, 5040, 256, 7, 37, "Notes",
  CellTags->"EvaluateNextCell"],
Cell[140080, 5049, 670, 12, 117, "Notes",
  CellTags->"EvaluateNextCell"],
Cell[140753, 5063, 285, 10, 52, "Notes",
  CellTags->"EvaluateNextCell"]
}, Closed]],

Cell[CellGroupData[{
Cell[141075, 5078, 88, 1, 42, "ObjectName",
  CellTags->"SubsessionEvaluateCells"],
Cell[141166, 5081, 297, 6, 60, "Usage",
  CellTags->"SubsessionEvaluateCells"],
Cell[141466, 5089, 266, 7, 37, "Notes",
  CellTags->"SubsessionEvaluateCells"],
Cell[141735, 5098, 282, 7, 52, "Notes",
  CellTags->"SubsessionEvaluateCells"],
Cell[142020, 5107, 292, 10, 52, "Notes",
  CellTags->"SubsessionEvaluateCells"]
}, Closed]],

Cell[CellGroupData[{
Cell[142349, 5122, 74, 1, 42, "ObjectName",
  CellTags->"EvaluateNotebook"],
Cell[142426, 5125, 217, 6, 44, "Usage",
  CellTags->"EvaluateNotebook"],
Cell[142646, 5133, 254, 7, 37, "Notes",
  CellTags->"EvaluateNotebook"],
Cell[142903, 5142, 285, 10, 52, "Notes",
  CellTags->"EvaluateNotebook"]
}, Closed]],

Cell[CellGroupData[{
Cell[143225, 5157, 86, 1, 42, "ObjectName",
  CellTags->"EvaluateInitialization"],
Cell[143314, 5160, 238, 6, 60, "Usage",
  CellTags->"EvaluateInitialization"],
Cell[143555, 5168, 260, 7, 37, "Notes",
  CellTags->"EvaluateInitialization"],
Cell[143818, 5177, 369, 8, 52, "Notes",
  CellTags->"EvaluateInitialization"],
Cell[144190, 5187, 291, 10, 52, "Notes",
  CellTags->"EvaluateInitialization"]
}, Closed]],

Cell[CellGroupData[{
Cell[144518, 5202, 72, 1, 42, "ObjectName",
  CellTags->"EnterSubsession"],
Cell[144593, 5205, 236, 6, 60, "Usage",
  CellTags->"EnterSubsession"],
Cell[144832, 5213, 252, 7, 37, "Notes",
  CellTags->"EnterSubsession"],
Cell[145087, 5222, 486, 16, 52, "Notes",
  CellTags->"EnterSubsession"],
Cell[145576, 5240, 284, 10, 52, "Notes",
  CellTags->"EnterSubsession"]
}, Closed]],

Cell[CellGroupData[{
Cell[145897, 5255, 70, 1, 42, "ObjectName",
  CellTags->"ExitSubsession"],
Cell[145970, 5258, 211, 6, 44, "Usage",
  CellTags->"ExitSubsession"],
Cell[146184, 5266, 250, 7, 37, "Notes",
  CellTags->"ExitSubsession"],
Cell[146437, 5275, 239, 6, 52, "Notes",
  CellTags->"ExitSubsession"],
Cell[146679, 5283, 283, 10, 52, "Notes",
  CellTags->"ExitSubsession"]
}, Closed]],

Cell[CellGroupData[{
Cell[146999, 5298, 92, 1, 42, "ObjectName",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[147094, 5301, 233, 6, 60, "Usage",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[147330, 5309, 275, 7, 37, "Notes",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[147608, 5318, 282, 8, 52, "Notes",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[147893, 5328, 294, 10, 52, "Notes",
  CellTags->"RemoveFromEvaluationQueue"]
}, Closed]],

Cell[CellGroupData[{
Cell[148224, 5343, 78, 1, 42, "ObjectName",
  CellTags->"EvaluatorInterrupt"],
Cell[148305, 5346, 272, 6, 60, "Usage",
  CellTags->"EvaluatorInterrupt"],
Cell[148580, 5354, 229, 6, 37, "Notes",
  CellTags->"EvaluatorInterrupt"],
Cell[148812, 5362, 402, 10, 52, "Notes",
  CellTags->"EvaluatorInterrupt"],
Cell[149217, 5374, 287, 10, 52, "Notes",
  CellTags->"EvaluatorInterrupt"]
}, Closed]],

Cell[CellGroupData[{
Cell[149541, 5389, 70, 1, 42, "ObjectName",
  CellTags->"EvaluatorAbort"],
Cell[149614, 5392, 219, 6, 44, "Usage",
  CellTags->"EvaluatorAbort"],
Cell[149836, 5400, 221, 6, 37, "Notes",
  CellTags->"EvaluatorAbort"],
Cell[150060, 5408, 240, 6, 52, "Notes",
  CellTags->"EvaluatorAbort"],
Cell[150303, 5416, 283, 10, 52, "Notes",
  CellTags->"EvaluatorAbort"]
}, Closed]],

Cell[CellGroupData[{
Cell[150623, 5431, 70, 1, 42, "ObjectName",
  CellTags->"EvaluatorStart"],
Cell[150696, 5434, 185, 5, 44, "Usage",
  CellTags->"EvaluatorStart"],
Cell[150884, 5441, 217, 6, 37, "Notes",
  CellTags->"EvaluatorStart"],
Cell[151104, 5449, 376, 10, 52, "Notes",
  CellTags->"EvaluatorStart"],
Cell[151483, 5461, 283, 10, 52, "Notes",
  CellTags->"EvaluatorStart"]
}, Closed]],

Cell[CellGroupData[{
Cell[151803, 5476, 68, 1, 42, "ObjectName",
  CellTags->"EvaluatorQuit"],
Cell[151874, 5479, 187, 5, 44, "Usage",
  CellTags->"EvaluatorQuit"],
Cell[152064, 5486, 215, 6, 37, "Notes",
  CellTags->"EvaluatorQuit"],
Cell[152282, 5494, 373, 10, 52, "Notes",
  CellTags->"EvaluatorQuit"],
Cell[152658, 5506, 282, 10, 52, "Notes",
  CellTags->"EvaluatorQuit"]
}, Closed]],

Cell[CellGroupData[{
Cell[152977, 5521, 82, 1, 42, "ObjectName",
  CellTags->"ModifyEvaluatorNames"],
Cell[153062, 5524, 237, 6, 60, "Usage",
  CellTags->"ModifyEvaluatorNames"],
Cell[153302, 5532, 239, 6, 37, "Notes",
  CellTags->"ModifyEvaluatorNames"],
Cell[153544, 5540, 378, 8, 52, "Notes",
  CellTags->"ModifyEvaluatorNames"],
Cell[153925, 5550, 289, 10, 52, "Notes",
  CellTags->"ModifyEvaluatorNames"]
}, Closed]],

Cell[CellGroupData[{
Cell[154251, 5565, 68, 1, 42, "ObjectName",
  CellTags->"ShowCellLabel"],
Cell[154322, 5568, 216, 7, 44, "Usage",
  CellTags->"ShowCellLabel"],
Cell[154541, 5577, 221, 6, 37, "Notes",
  CellTags->"ShowCellLabel"],
Cell[154765, 5585, 282, 10, 52, "Notes",
  CellTags->"ShowCellLabel"]
}, Closed]],

Cell[CellGroupData[{
Cell[155084, 5600, 82, 1, 42, "ObjectName",
  CellTags->"DeleteGeneratedCells"],
Cell[155169, 5603, 220, 6, 44, "Usage",
  CellTags->"DeleteGeneratedCells"],
Cell[155392, 5611, 228, 6, 37, "Notes",
  CellTags->"DeleteGeneratedCells"],
Cell[155623, 5619, 289, 10, 52, "Notes",
  CellTags->"DeleteGeneratedCells"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[155961, 5635, 30, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[156016, 5639, 62, 1, 55, "ObjectName",
  CellTags->"FindDialog"],
Cell[156081, 5642, 175, 5, 44, "Usage",
  CellTags->"FindDialog"],
Cell[156259, 5649, 203, 6, 24, "Notes",
  CellTags->"FindDialog"],
Cell[156465, 5657, 279, 10, 52, "Notes",
  CellTags->"FindDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[156781, 5672, 74, 1, 38, "ObjectName",
  CellTags->"SelectionSetFind"],
Cell[156858, 5675, 243, 6, 32, "Usage",
  CellTags->"SelectionSetFind"],
Cell[157104, 5683, 220, 6, 24, "Notes",
  CellTags->"SelectionSetFind"],
Cell[157327, 5691, 285, 10, 24, "Notes",
  CellTags->"SelectionSetFind"]
}, Closed]],

Cell[CellGroupData[{
Cell[157649, 5706, 66, 1, 38, "ObjectName",
  CellTags->"CellTagsFind"],
Cell[157718, 5709, 262, 7, 32, "Usage",
  CellTags->"CellTagsFind"],
Cell[157983, 5718, 218, 6, 24, "Notes",
  CellTags->"CellTagsFind"],
Cell[158204, 5726, 128, 4, 24, "Notes",
  CellTags->"CellTagsFind"],
Cell[158335, 5732, 269, 8, 24, "Notes",
  CellTags->"CellTagsFind"]
}, Closed]],

Cell[CellGroupData[{
Cell[158641, 5745, 56, 1, 38, "ObjectName",
  CellTags->"Replace"],
Cell[158700, 5748, 195, 6, 32, "Usage",
  CellTags->"Replace"],
Cell[158898, 5756, 203, 6, 24, "Notes",
  CellTags->"Replace"],
Cell[159104, 5764, 276, 10, 24, "Notes",
  CellTags->"Replace"]
}, Closed]],

Cell[CellGroupData[{
Cell[159417, 5779, 64, 1, 38, "ObjectName",
  CellTags->"ReplaceFind"],
Cell[159484, 5782, 263, 6, 48, "Usage",
  CellTags->"ReplaceFind"],
Cell[159750, 5790, 222, 6, 24, "Notes",
  CellTags->"ReplaceFind"],
Cell[159975, 5798, 280, 10, 24, "Notes",
  CellTags->"ReplaceFind"]
}, Closed]],

Cell[CellGroupData[{
Cell[160292, 5813, 62, 1, 38, "ObjectName",
  CellTags->"ReplaceAll"],
Cell[160357, 5816, 300, 7, 48, "Usage",
  CellTags->"ReplaceAll"],
Cell[160660, 5825, 210, 6, 24, "Notes",
  CellTags->"ReplaceAll"],
Cell[160873, 5833, 279, 10, 24, "Notes",
  CellTags->"ReplaceAll"]
}, Closed]],

Cell[CellGroupData[{
Cell[161189, 5848, 82, 1, 38, "ObjectName",
  CellTags->"OpenSelectionParents"],
Cell[161274, 5851, 216, 6, 32, "Usage",
  CellTags->"OpenSelectionParents"],
Cell[161493, 5859, 222, 6, 24, "Notes",
  CellTags->"OpenSelectionParents"],
Cell[161718, 5867, 289, 10, 24, "Notes",
  CellTags->"OpenSelectionParents"]
}, Closed]],

Cell[CellGroupData[{
Cell[162044, 5882, 72, 1, 38, "ObjectName",
  CellTags->"SelectionScroll"],
Cell[162119, 5885, 280, 7, 48, "Usage",
  CellTags->"SelectionScroll"],
Cell[162402, 5894, 223, 6, 24, "Notes",
  CellTags->"SelectionScroll"],
Cell[162628, 5902, 284, 10, 24, "Notes",
  CellTags->"SelectionScroll"]
}, Closed]],

Cell[CellGroupData[{
Cell[162949, 5917, 72, 1, 38, "ObjectName",
  CellTags->"HyperlinkGoBack"],
Cell[163024, 5920, 222, 6, 32, "Usage",
  CellTags->"HyperlinkGoBack"],
Cell[163249, 5928, 211, 6, 24, "Notes",
  CellTags->"HyperlinkGoBack"],
Cell[163463, 5936, 284, 10, 24, "Notes",
  CellTags->"HyperlinkGoBack"]
}, Closed]],

Cell[CellGroupData[{
Cell[163784, 5951, 78, 1, 38, "ObjectName",
  CellTags->"CellTagsEditDialog"],
Cell[163865, 5954, 201, 5, 32, "Usage",
  CellTags->"CellTagsEditDialog"],
Cell[164069, 5961, 227, 6, 24, "Notes",
  CellTags->"CellTagsEditDialog"],
Cell[164299, 5969, 315, 9, 24, "Notes",
  CellTags->"CellTagsEditDialog"],
Cell[164617, 5980, 287, 10, 24, "Notes",
  CellTags->"CellTagsEditDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[164941, 5995, 66, 1, 38, "ObjectName",
  CellTags->"ShowCellTags"],
Cell[165010, 5998, 213, 6, 32, "Usage",
  CellTags->"ShowCellTags"],
Cell[165226, 6006, 215, 6, 24, "Notes",
  CellTags->"ShowCellTags"],
Cell[165444, 6014, 281, 10, 24, "Notes",
  CellTags->"ShowCellTags"]
}, Closed]],

Cell[CellGroupData[{
Cell[165762, 6029, 74, 1, 38, "ObjectName",
  CellTags->"CellLabelsToTags"],
Cell[165839, 6032, 289, 9, 32, "Usage",
  CellTags->"CellLabelsToTags"],
Cell[166131, 6043, 232, 6, 24, "Notes",
  CellTags->"CellLabelsToTags"],
Cell[166366, 6051, 285, 10, 24, "Notes",
  CellTags->"CellLabelsToTags"]
}, Closed]],

Cell[CellGroupData[{
Cell[166688, 6066, 76, 1, 38, "ObjectName",
  CellTags->"CreateIndexDialog"],
Cell[166767, 6069, 195, 5, 32, "Usage",
  CellTags->"CreateIndexDialog"],
Cell[166965, 6076, 216, 6, 24, "Notes",
  CellTags->"CreateIndexDialog"],
Cell[167184, 6084, 344, 8, 40, "Notes",
  CellTags->"CreateIndexDialog"],
Cell[167531, 6094, 286, 10, 24, "Notes",
  CellTags->"CreateIndexDialog"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[167866, 6110, 33, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[167924, 6114, 66, 1, 38, "ObjectName",
  CellTags->"StackWindows"],
Cell[167993, 6117, 217, 6, 32, "Usage",
  CellTags->"StackWindows"],
Cell[168213, 6125, 216, 6, 24, "Notes",
  CellTags->"StackWindows"],
Cell[168432, 6133, 281, 10, 24, "Notes",
  CellTags->"StackWindows"]
}, Closed]],

Cell[CellGroupData[{
Cell[168750, 6148, 72, 1, 38, "ObjectName",
  CellTags->"TileWindowsWide"],
Cell[168825, 6151, 233, 6, 32, "Usage",
  CellTags->"TileWindowsWide"],
Cell[169061, 6159, 223, 6, 24, "Notes",
  CellTags->"TileWindowsWide"],
Cell[169287, 6167, 284, 10, 24, "Notes",
  CellTags->"TileWindowsWide"]
}, Closed]],

Cell[CellGroupData[{
Cell[169608, 6182, 72, 1, 38, "ObjectName",
  CellTags->"TileWindowsTall"],
Cell[169683, 6185, 233, 6, 32, "Usage",
  CellTags->"TileWindowsTall"],
Cell[169919, 6193, 223, 6, 24, "Notes",
  CellTags->"TileWindowsTall"],
Cell[170145, 6201, 284, 10, 24, "Notes",
  CellTags->"TileWindowsTall"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[170478, 6217, 30, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[170533, 6221, 62, 1, 38, "ObjectName",
  CellTags->"HelpDialog"],
Cell[170598, 6224, 172, 5, 32, "Usage",
  CellTags->"HelpDialog"],
Cell[170773, 6231, 211, 6, 24, "Notes",
  CellTags->"HelpDialog"],
Cell[170987, 6239, 279, 10, 24, "Notes",
  CellTags->"HelpDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[171303, 6254, 80, 1, 38, "ObjectName",
  CellTags->"SelectionHelpDialog"],
Cell[171386, 6257, 226, 6, 32, "Usage",
  CellTags->"SelectionHelpDialog"],
Cell[171615, 6265, 230, 6, 24, "Notes",
  CellTags->"SelectionHelpDialog"],
Cell[171848, 6273, 288, 10, 24, "Notes",
  CellTags->"SelectionHelpDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[172173, 6288, 76, 1, 38, "ObjectName",
  CellTags->"ExplainBeepDialog"],
Cell[172252, 6291, 261, 6, 48, "Usage",
  CellTags->"ExplainBeepDialog"],
Cell[172516, 6299, 219, 6, 24, "Notes",
  CellTags->"ExplainBeepDialog"],
Cell[172738, 6307, 286, 10, 24, "Notes",
  CellTags->"ExplainBeepDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[173061, 6322, 70, 1, 38, "ObjectName",
  CellTags->"AboutBoxDialog"],
Cell[173134, 6325, 268, 9, 32, "Usage",
  CellTags->"AboutBoxDialog"],
Cell[173405, 6336, 336, 11, 24, "Notes",
  CellTags->"AboutBoxDialog"],
Cell[173744, 6349, 283, 10, 24, "Notes",
  CellTags->"AboutBoxDialog"]
}, Closed]],

Cell[CellGroupData[{
Cell[174064, 6364, 74, 1, 38, "ObjectName",
  CellTags->"RebuildHelpIndex"],
Cell[174141, 6367, 246, 7, 32, "Usage",
  CellTags->"RebuildHelpIndex"],
Cell[174390, 6376, 223, 6, 24, "Notes",
  CellTags->"RebuildHelpIndex"],
Cell[174616, 6384, 171, 4, 24, "Notes",
  CellTags->"RebuildHelpIndex"],
Cell[174790, 6390, 285, 10, 24, "Notes",
  CellTags->"RebuildHelpIndex"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[175124, 6406, 39, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[175188, 6410, 58, 1, 38, "ObjectName",
  CellTags->"AddFrame"],
Cell[175249, 6413, 211, 6, 32, "Usage",
  CellTags->"AddFrame"],
Cell[175463, 6421, 277, 10, 24, "Notes",
  CellTags->"AddFrame"]
}, Closed]],

Cell[CellGroupData[{
Cell[175777, 6436, 68, 1, 42, "ObjectName",
  CellTags->"FixCellHeight"],
Cell[175848, 6439, 287, 8, 48, "Usage",
  CellTags->"FixCellHeight"],
Cell[176138, 6449, 282, 10, 24, "Notes",
  CellTags->"FixCellHeight"]
}, Closed]],

Cell[CellGroupData[{
Cell[176457, 6464, 66, 1, 42, "ObjectName",
  CellTags->"MoveNextCell"],
Cell[176526, 6467, 196, 5, 32, "Usage",
  CellTags->"MoveNextCell"],
Cell[176725, 6474, 281, 10, 24, "Notes",
  CellTags->"MoveNextCell"]
}, Closed]],

Cell[CellGroupData[{
Cell[177043, 6489, 82, 1, 42, "ObjectName",
  CellTags->"SelectTerminalWindow"],
Cell[177128, 6492, 248, 6, 32, "Usage",
  CellTags->"SelectTerminalWindow"],
Cell[177379, 6500, 312, 6, 46, "Notes",
  CellTags->"SelectTerminalWindow"],
Cell[177694, 6508, 289, 10, 24, "Notes",
  CellTags->"SelectTerminalWindow"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

