(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13216,        480]*)
(*NotebookOutlinePosition[     19285,        644]*)
(*  CellTagsIndexPosition[     18722,        624]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Help Browser...", "Command",
  CellTags->{"HelpDialog", "introHelpDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Help Browser", "SR"],
  " opens the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Help Browser."
}], "Usage",
  CellTags->{"HelpDialog", "introHelpDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The Help Browser lets you access a wide range of \
notebooks and other material to get help while you are using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{"HelpDialog", "introHelpDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.3.8",
    ButtonData:>{"1.3.8"},
    ButtonStyle->"MainBookLink"],
  " and ",
  ButtonBox["Section 1.3.9",
    ButtonData:>{"1.3.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"HelpDialog", "introHelpDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Find Selected Function...", "Command",
  CellTags->"FindSelectedFunction"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find Selected Function ",
    FontFamily->"Helvetica"],
  "opens the Help Browser with the Built-in Functions radio button selected."
}], "Usage",
  CellTags->"FindSelectedFunction"],

Cell[TextData[{
  "\[FilledSmallSquare] The Help Browser lets you access a wide range of \
notebooks and other material to get help while you are using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"FindSelectedFunction"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["F1 ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["f", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["F1 ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"FindSelectedFunction"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.3.8",
    ButtonData:>{"1.3.8"},
    ButtonStyle->"MainBookLink"],
  " and ",
  ButtonBox["Section 1.3.9",
    ButtonData:>{"1.3.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"FindSelectedFunction"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Master Index...", "Command",
  CellTags->"MasterIndex"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Master Index",
    FontFamily->"Helvetica"],
  " opens the Help Browser with the Master Index radio button selected."
}], "Usage",
  CellTags->"MasterIndex"],

Cell[TextData[{
  "\[FilledSmallSquare] The Help Browser lets you access a wide range of \
notebooks and other material to get help while you are using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.3.8",
    ButtonData:>{"1.3.8"},
    ButtonStyle->"MainBookLink"],
  " and ",
  ButtonBox["Section 1.3.9",
    ButtonData:>{"1.3.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"MasterIndex"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tutorial...", "Command",
  CellTags->"Tutorial"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Tutorial",
    FontFamily->"Helvetica"],
  " brings up the ten-minute tutorial on ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Usage",
  CellTags->"Tutorial"],

Cell[TextData[{
  "\[FilledSmallSquare] The ten-minute tutorial provides a brief introduction \
to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", in the form of a slide show."
}], "Notes",
  CellTags->"Tutorial"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Information Center on the Web...", "Command",
  CellTags->"InfoCenter"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Information Center on the Web",
    FontFamily->"Helvetica"],
  " opens a web browser and displays the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Information Center website."
}], "Usage",
  CellTags->"InfoCenter"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " information center ((",
  ButtonBox["http://library.wolfram.com",
    ButtonData:>{
      URL[ "http://library.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ")) is a repository of information on ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " It includes hundreds of tutorials, demos, and technical notes, a large \
collection of packages applying ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to various fields, and information on books and articles about ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". "
}], "Notes",
  CellTags->"InfoCenter"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wolfram Research on the Web...", "Command",
  CellTags->"WolframSite"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Wolfram Research on the Web",
    FontFamily->"Helvetica"],
  " opens a web browser and displays the main Wolfram Research website."
}], "Usage",
  CellTags->"WolframSite"],

Cell[TextData[{
  "\[FilledSmallSquare] The company website (",
  ButtonBox["www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  ") contains detailed information on ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and other Wolfram Research products and services. "
}], "Notes",
  CellTags->"WolframSite"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Online Registration...", "Command",
  CellTags->"Registration"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Online Registration", "SR"],
  " opens the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " registration website in a web browser."
}], "Usage",
  CellTags->"Registration"],

Cell[TextData[{
  "\[FilledSmallSquare] The registration website is at ",
  ButtonBox["register.wolfram.com",
    ButtonData:>{
      URL[ "http://register.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Notes",
  CellTags->"Registration"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Why the Beep?...", "Command",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Why the Beep", "SR"],
  " brings up an explanation of why the front end produced a beep."
}], "Usage",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " beeps whenever you try to do something it cannot do or does not \
understand. Choosing this command explains the reason for the last beep and \
tells you how long ago it occurred. The message only refers to the last time \
",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " beeped in the current session."
}], "Notes",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1"],
  StyleBox["\[ControlKey]",
    FontColor->RGBColor[0.4, 0, 1]],
  StyleBox["\[LeftModified]", "C1"],
  StyleBox["h", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["h", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["h", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Startup Palette...", "Command",
  CellTags->"StartupPalette"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Startup Palette",
    FontFamily->"Helvetica"],
  " opens the welcome palette, which appears by default each time you start \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". "
}], "Usage",
  CellTags->"StartupPalette"],

Cell["\<\
\[FilledSmallSquare] The welcome palette contains buttons that \
direct you to the Help Browser, the ten-minute tutorial, or the Wolfram \
Research website. \
\>", "Notes",
  CellTags->"StartupPalette"]
}, Open  ]],

Cell[CellGroupData[{

Cell["About Mathematica...", "Command",
  CellTags->"AboutMathematica"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["About Mathematica", "SR"],
  " brings up a notebook containing information about ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Usage",
  CellTags->"AboutMathematica"],

Cell[TextData[{
  "\[FilledSmallSquare] For Macintosh, this command is listed under the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Application menu. "
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"AboutMathematica"]
}, Open  ]],

Cell[CellGroupData[{

Cell["X Environment Information...", "Command",
  CellTags->"XEnvironmentInformation"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["X", "SR"],
  StyleBox[" Environment Information",
    FontFamily->"Helvetica"],
  StyleBox[" brings up a dialog box that displays the current attributes of \
the X front end environment. (X only.)", "Text"]
}], "Usage",
  CellTags->"XEnvironmentInformation"],

Cell["\<\
\[FilledSmallSquare] The dialog box lists display, window, and \
keyboard attributes, as well as directory paths. 
\[FilledSmallSquare] The physical keys associated with \[Mod1Key] and \
\[Mod2Key] can be changed using the Find keys and modifiers button. 
\[FilledSmallSquare] The pure keys radio button, when set, forces the X front \
end to ignore manufacturer keycodes that are modified by anything except the \
\[ShiftKey] key. Some X servers bind keysyms when holding down the \[Mod1Key] \
or \[Mod2Key] key with another key. In order for some front end key bindings \
to work correctly, this radio button may need to be set. For example, if the \
server has mapped \[ControlKey]\[LeftModified]6\[RightModified] to the one \
quarter keysym, then the front end will not be able to use this keystroke to \
typeset superscripts.  \
\>", "Notes",
  CellTags->"XEnvironmentInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rebuild Help Index", "Command",
  CellTags->"RebuildHelpIndex"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Rebuild Help Index", "SR"],
  StyleBox[" rebuilds the categories and index for the Help Browser", 
    "Text"],
  "."
}], "Usage",
  CellTags->"RebuildHelpIndex"],

Cell["\<\
\[FilledSmallSquare] Use this command when you have installed an \
add-on package or modified documentation files.\
\>", "Notes",
  CellTags->"RebuildHelpIndex"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Help...", "Command",
  CellTags->"Help_MR"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Help", "SR"],
  " opens the ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " Help Browser."
}], "Usage",
  CellTags->"Help_MR"],

Cell[TextData[{
  "\[FilledSmallSquare] The Help Browser provides access to information about \
using ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Help_MR"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1108}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{617, 674},
WindowMargins->{{39, Automatic}, {Automatic, 8}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrintingOptions->{"PrintCellBrackets"->True},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "HelpDialog"->{
    Cell[1776, 53, 83, 1, 41, "Command",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[1862, 56, 226, 8, 31, "Usage",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[2091, 66, 274, 7, 40, "Notes",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[2368, 75, 374, 14, 24, "Notes",
      CellTags->{"HelpDialog", "introHelpDialogID"}]},
  "introHelpDialogID"->{
    Cell[1776, 53, 83, 1, 41, "Command",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[1862, 56, 226, 8, 31, "Usage",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[2091, 66, 274, 7, 40, "Notes",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[2368, 75, 374, 14, 24, "Notes",
      CellTags->{"HelpDialog", "introHelpDialogID"}]},
  "FindSelectedFunction"->{
    Cell[2779, 94, 80, 1, 41, "Command",
      CellTags->"FindSelectedFunction"],
    Cell[2862, 97, 237, 6, 31, "Usage",
      CellTags->"FindSelectedFunction"],
    Cell[3102, 105, 261, 7, 40, "Notes",
      CellTags->"FindSelectedFunction"],
    Cell[3366, 114, 437, 14, 24, "Notes",
      CellTags->"FindSelectedFunction"],
    Cell[3806, 130, 361, 14, 24, "Notes",
      CellTags->"FindSelectedFunction"]},
  "MasterIndex"->{
    Cell[4204, 149, 61, 1, 41, "Command",
      CellTags->"MasterIndex"],
    Cell[4268, 152, 212, 6, 31, "Usage",
      CellTags->"MasterIndex"],
    Cell[4483, 160, 546, 18, 62, "Notes",
      CellTags->"MasterIndex"]},
  "Tutorial"->{
    Cell[5066, 183, 54, 1, 41, "Command",
      CellTags->"Tutorial"],
    Cell[5123, 186, 234, 9, 31, "Usage",
      CellTags->"Tutorial"],
    Cell[5360, 197, 225, 7, 24, "Notes",
      CellTags->"Tutorial"]},
  "InfoCenter"->{
    Cell[5622, 209, 77, 1, 41, "Command",
      CellTags->"InfoCenter"],
    Cell[5702, 212, 284, 9, 47, "Usage",
      CellTags->"InfoCenter"],
    Cell[5989, 223, 694, 21, 56, "Notes",
      CellTags->"InfoCenter"]},
  "WolframSite"->{
    Cell[6720, 249, 76, 1, 41, "Command",
      CellTags->"WolframSite"],
    Cell[6799, 252, 227, 6, 47, "Usage",
      CellTags->"WolframSite"],
    Cell[7029, 260, 377, 11, 40, "Notes",
      CellTags->"WolframSite"]},
  "Registration"->{
    Cell[7443, 276, 69, 1, 41, "Command",
      CellTags->"Registration"],
    Cell[7515, 279, 237, 8, 31, "Usage",
      CellTags->"Registration"],
    Cell[7755, 289, 255, 8, 24, "Notes",
      CellTags->"Registration"]},
  "ExplainBeepDialog"->{
    Cell[8047, 302, 99, 1, 41, "Command",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[8149, 305, 221, 5, 31, "Usage",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[8373, 312, 549, 14, 56, "Notes",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[8925, 328, 757, 21, 24, "Notes",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}]},
  "explainWhyTheBeepDialogID"->{
    Cell[8047, 302, 99, 1, 41, "Command",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[8149, 305, 221, 5, 31, "Usage",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[8373, 312, 549, 14, 56, "Notes",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[8925, 328, 757, 21, 24, "Notes",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}]},
  "StartupPalette"->{
    Cell[9719, 354, 67, 1, 41, "Command",
      CellTags->"StartupPalette"],
    Cell[9789, 357, 285, 10, 31, "Usage",
      CellTags->"StartupPalette"],
    Cell[10077, 369, 212, 5, 40, "Notes",
      CellTags->"StartupPalette"]},
  "AboutMathematica"->{
    Cell[10326, 379, 71, 1, 41, "Command",
      CellTags->"AboutMathematica"],
    Cell[10400, 382, 241, 8, 31, "Usage",
      CellTags->"AboutMathematica"],
    Cell[10644, 392, 238, 7, 24, "Notes",
      CellTags->"AboutMathematica"]},
  "XEnvironmentInformation"->{
    Cell[10919, 404, 86, 1, 41, "Command",
      CellTags->"XEnvironmentInformation"],
    Cell[11008, 407, 313, 8, 47, "Usage",
      CellTags->"XEnvironmentInformation"],
    Cell[11324, 417, 896, 14, 148, "Notes",
      CellTags->"XEnvironmentInformation"]},
  "RebuildHelpIndex"->{
    Cell[12257, 436, 69, 1, 41, "Command",
      CellTags->"RebuildHelpIndex"],
    Cell[12329, 439, 217, 7, 31, "Usage",
      CellTags->"RebuildHelpIndex"],
    Cell[12549, 448, 171, 4, 24, "Notes",
      CellTags->"RebuildHelpIndex"]},
  "Help_MR"->{
    Cell[12757, 457, 49, 1, 41, "Command",
      CellTags->"Help_MR"],
    Cell[12809, 460, 191, 8, 31, "Usage",
      CellTags->"Help_MR"],
    Cell[13003, 470, 197, 7, 24, "Notes",
      CellTags->"Help_MR"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"HelpDialog", 14037, 503},
  {"introHelpDialogID", 14441, 512},
  {"FindSelectedFunction", 14848, 521},
  {"MasterIndex", 15279, 532},
  {"Tutorial", 15517, 539},
  {"InfoCenter", 15747, 546},
  {"WolframSite", 15985, 553},
  {"Registration", 16227, 560},
  {"ExplainBeepDialog", 16476, 567},
  {"explainWhyTheBeepDialogID", 16953, 576},
  {"StartupPalette", 17419, 585},
  {"AboutMathematica", 17675, 592},
  {"XEnvironmentInformation", 17945, 599},
  {"RebuildHelpIndex", 18231, 606},
  {"Help_MR", 18485, 613}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 83, 1, 41, "Command",
  CellTags->{"HelpDialog", "introHelpDialogID"}],
Cell[1862, 56, 226, 8, 31, "Usage",
  CellTags->{"HelpDialog", "introHelpDialogID"}],
Cell[2091, 66, 274, 7, 40, "Notes",
  CellTags->{"HelpDialog", "introHelpDialogID"}],
Cell[2368, 75, 374, 14, 24, "Notes",
  CellTags->{"HelpDialog", "introHelpDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[2779, 94, 80, 1, 41, "Command",
  CellTags->"FindSelectedFunction"],
Cell[2862, 97, 237, 6, 31, "Usage",
  CellTags->"FindSelectedFunction"],
Cell[3102, 105, 261, 7, 40, "Notes",
  CellTags->"FindSelectedFunction"],
Cell[3366, 114, 437, 14, 24, "Notes",
  CellTags->"FindSelectedFunction"],
Cell[3806, 130, 361, 14, 24, "Notes",
  CellTags->"FindSelectedFunction"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4204, 149, 61, 1, 41, "Command",
  CellTags->"MasterIndex"],
Cell[4268, 152, 212, 6, 31, "Usage",
  CellTags->"MasterIndex"],
Cell[4483, 160, 546, 18, 62, "Notes",
  CellTags->"MasterIndex"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5066, 183, 54, 1, 41, "Command",
  CellTags->"Tutorial"],
Cell[5123, 186, 234, 9, 31, "Usage",
  CellTags->"Tutorial"],
Cell[5360, 197, 225, 7, 24, "Notes",
  CellTags->"Tutorial"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5622, 209, 77, 1, 41, "Command",
  CellTags->"InfoCenter"],
Cell[5702, 212, 284, 9, 47, "Usage",
  CellTags->"InfoCenter"],
Cell[5989, 223, 694, 21, 56, "Notes",
  CellTags->"InfoCenter"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6720, 249, 76, 1, 41, "Command",
  CellTags->"WolframSite"],
Cell[6799, 252, 227, 6, 47, "Usage",
  CellTags->"WolframSite"],
Cell[7029, 260, 377, 11, 40, "Notes",
  CellTags->"WolframSite"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7443, 276, 69, 1, 41, "Command",
  CellTags->"Registration"],
Cell[7515, 279, 237, 8, 31, "Usage",
  CellTags->"Registration"],
Cell[7755, 289, 255, 8, 24, "Notes",
  CellTags->"Registration"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8047, 302, 99, 1, 41, "Command",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
Cell[8149, 305, 221, 5, 31, "Usage",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
Cell[8373, 312, 549, 14, 56, "Notes",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
Cell[8925, 328, 757, 21, 24, "Notes",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9719, 354, 67, 1, 41, "Command",
  CellTags->"StartupPalette"],
Cell[9789, 357, 285, 10, 31, "Usage",
  CellTags->"StartupPalette"],
Cell[10077, 369, 212, 5, 40, "Notes",
  CellTags->"StartupPalette"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10326, 379, 71, 1, 41, "Command",
  CellTags->"AboutMathematica"],
Cell[10400, 382, 241, 8, 31, "Usage",
  CellTags->"AboutMathematica"],
Cell[10644, 392, 238, 7, 24, "Notes",
  CellTags->"AboutMathematica"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10919, 404, 86, 1, 41, "Command",
  CellTags->"XEnvironmentInformation"],
Cell[11008, 407, 313, 8, 47, "Usage",
  CellTags->"XEnvironmentInformation"],
Cell[11324, 417, 896, 14, 148, "Notes",
  CellTags->"XEnvironmentInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12257, 436, 69, 1, 41, "Command",
  CellTags->"RebuildHelpIndex"],
Cell[12329, 439, 217, 7, 31, "Usage",
  CellTags->"RebuildHelpIndex"],
Cell[12549, 448, 171, 4, 24, "Notes",
  CellTags->"RebuildHelpIndex"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12757, 457, 49, 1, 41, "Command",
  CellTags->"Help_MR"],
Cell[12809, 460, 191, 8, 31, "Usage",
  CellTags->"Help_MR"],
Cell[13003, 470, 197, 7, 24, "Notes",
  CellTags->"Help_MR"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

