(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     33042,       1067]*)
(*NotebookOutlinePosition[     49186,       1420]*)
(*  CellTagsIndexPosition[     48138,       1391]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Get Graphics Coordinates...", "Command",
  CellTags->"GraphicsCoordinatesDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Get Graphics Coordinates", "SR"],
  " finds coordinates in graphics."
}], "Usage",
  CellTags->"GraphicsCoordinatesDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] When you choose this command, a help message is \
displayed that explains how to find graphics coordinates. It is not actually \
necessary to use this dialog once you know how to use the feature.\n\
\[FilledSmallSquare] To get coordinates in a two-dimensional plot, select the \
plot, hold down the appropriate modifier key(s) (",
  StyleBox["\[ControlKey]", "C1"],
  " for Windows, ",
  StyleBox["\[CommandKey]", "C1"],
  " for Macintosh, and ",
  StyleBox["\[ControlKey]", "C1"],
  " for X) and move the mouse over the area of the plot. The coordinate \
values of the mouse position will be displayed in the window's status area. \
If you click one or more times while holding down the modifier key, the \
coordinates will be selected. You can then copy and paste the coordinate \
values into an input cell."
}], "Notes",
  CellTags->"GraphicsCoordinatesDialog"],

Cell["3D ViewPoint Selector...", "Command",
  FontFamily->"Helvetica",
  CellTags->"ViewPointSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["3D ViewPoint Selector", "SR"],
  " lets you interactively select a viewpoint for three-dimensional \
graphics."
}], "Usage",
  CellTags->"ViewPointSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["v", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["v", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["v", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"viewPointSelectorID"],

Cell[TextData[{
  "\[FilledSmallSquare] The currently selected viewpoint is shown by a \
schematic cube with the ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and",
  StyleBox[" z",
    FontSlant->"Italic"],
  " axes labeled. There are three ways of controlling the viewpoint:"
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],

Cell["\<\
-  Drag the cube to change the orientation of the viewpoint without \
changing its distance from the cube.
-  Move the three scroll bars surrounding the cube.
-  Change the viewpoint coordinates in the editable text fields in the lower \
right of the dialog box.\
\>", "ItemizedText",
  AspectRatioFixed->False,
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],

Cell[TextData[{
  "\[FilledSmallSquare] The text fields and scroll bars can be set to control \
either the spherical coordinates r, theta, and phi; or the Cartesian \
coordinates",
  StyleBox[" x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["z",
    FontSlant->"Italic"],
  " by using the corresponding radio buttons."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],

Cell[TextData[{
  "\[FilledSmallSquare] Once you have chosen a viewpoint, paste the input \
string describing it with the ",
  StyleBox["Paste",
    FontFamily->"Helvetica"],
  " button. The viewpoint input is pasted at the insertion point in the \
current notebook."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],

Cell["Color Selector...", "Command",
  CellTags->"ColorSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Color Selector", "SR"],
  " lets you interactively select a color for ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " graphics. (Windows and Macintosh only.)"
}], "Usage",
  CellTags->"ColorSelectorDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] When you have chosen a color, click OK to paste the \
selected color at the text insertion point, cell insertion point, or \
selection within a cell, in the form of a ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " ",
  StyleBox["RGBColor[", "MR",
    FontFamily->"Courier"],
  StyleBox["red",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier",
    FontWeight->"ExtraLight"],
  StyleBox["green",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier",
    FontWeight->"ExtraLight"],
  StyleBox["blue",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox["]", "MR",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Chicago",
    FontSize->9],
  "function. In this way you can specify the color of a graphical object \
without having to figure out the actual RGB values for the color yourself."
}], "Notes",
  CellTags->"ColorSelectorDialog"],

Cell["Record Sound...", "Command",
  CellTags->"RecordSoundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Record Sound", "SR"],
  " lets you record a sound into ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ". (Windows and Macintosh only.)"
}], "Usage",
  CellTags->"RecordSoundDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] With a sound recording peripheral and microphone \
connected to your computer and the proper drivers installed, you can record \
sounds directly into ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ". To record a sound, first place a cell insertion point (horizontal I-bar) \
in your notebook, then choose ",
  StyleBox["Record Sound", "SR"],
  ". A dialog box appears with buttons to control your recording. Once you \
have recorded a sound, click ",
  StyleBox["Save",
    FontFamily->"Helvetica"],
  " to paste the sound in your notebook. ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " can play recorded sounds just like sounds natively generated in ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] You can use the ",
  StyleBox["Convert to InputForm", "SR"],
  " command to convert recorded sounds into a list of numbers (samples) in \
the form of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list."
}], "Notes",
  CellTags->"RecordSoundDialog"],

Cell["Get File Path...", "Command",
  CellTags->"FileNameDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Get File Path", "SR"],
  " pastes the full pathname of a selected file into the text."
}], "Usage",
  CellTags->"FileNameDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] When a file is selected, clicking ",
  StyleBox["Open",
    FontFamily->"Helvetica"],
  " pastes the full pathname of the file into the notebook at the current \
selection."
}], "Notes",
  CellTags->"FileNameDialog"],

Cell["Create Table/Matrix/Palette...", "Command",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  StyleBox["Create Table/Matrix/Palette", "SR"],
  " sets up an empty ",
  StyleBox["GridBox", "Input",
    FontWeight->"Plain"],
  " object."
}], "Usage",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Table",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  "Makes a ",
  StyleBox["GridBox", "Input",
    FontWeight->"Plain"],
  " with no special options."
}], "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Matrix",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell["\<\
Rows and columns are the width of the widest element with \
parentheses around the matrix.\
\>", "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Palette",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  "Makes a ",
  StyleBox["GridBox", "Input",
    FontWeight->"Plain"],
  " filled with buttons, with various options set to give the appearance of a \
palette."
}], "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Fill with",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell["\<\
Sets the initial values for the elements with the specified \
value.\
\>", "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Fill diagonal",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell["\<\
Sets the initial values for diagonal elements with the specified \
value. Can be used in conjunction with \"Fill with\".\
\>", "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["GridBox",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["c", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["c", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["c", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialog"}],

Cell["Create Button", "Command",
  CellTags->"CreateCustomButtonBox"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Create Button", "SR"],
  " sets up a single button with the specified action or a custom action."
}], "Usage",
  CellTags->"CreateCustomButtonBox"],

Cell["\<\
\[FilledSmallSquare] The submenu lets you select standard button \
functions that are defined in the style sheet associated with the current \
notebook.\
\>", "Notes",
  CellTags->"CreateCustomButtonBox"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ":  ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"CreateCustomButtonBox"],

Cell["Edit Button...", "Command",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Edit Button", "SR"],
  " lets you edit the action for the selected button and specify ",
  StyleBox["ButtonBox", "MR"],
  " options."
}], "Usage",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],

Cell["\<\
\[FilledSmallSquare] The Button Style pop-up menu lets you select \
standard button functions that are defined in the style sheet associated with \
the current notebook.
\[FilledSmallSquare] The other items in the dialog box can be used to set \
individual options associated with the button.\
\>", "Notes",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["ButtonBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonData",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonEvaluator",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNote",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonSource",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ":  ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],

Cell["Create Hyperlink...", "Command",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Create Hyperlink", "SR"],
  " sets up a hyperlink to a specified cell, notebook, or URL."
}], "Usage",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "1. Select the words you want to make into a hyperlink.\n2. Choose",
  StyleBox[" Create Hyperlink", "SR"],
  ".\n3. Specify a destination for the link. The destination can be a \
notebook or cells in a notebook.\n4. Click OK."
}], "ItemizedText",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  " ",
  " The selected text is formatted as a hyperlink button (typically \
underlined). When you click the hyperlink, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will jump to the linked cell or notebook."
}], "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  " \[FilledSmallSquare] Cells are targeted by use of cell tags. If your \
destination cells do not already have cell tags, you must add them first by \
using the ",
  StyleBox["Add/Remove Cell Tags", "SR"],
  " command in the Find menu."
}], "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  " \[FilledSmallSquare] On some versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " you can also link to a URL. Enter the URL in the text field at the top of \
the dialog box. Such a link will automatically open your web browser and \
connect to the designated web address. URL prefixes include \"",
  StyleBox["http://", "MR"],
  "\", \"",
  StyleBox["mailto:", "MR"],
  "\", \"",
  StyleBox["news:", "MR"],
  "\", and \"",
  StyleBox["ftp:", "MR"],
  "\"."
}], "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] When you click the hyperlink button, it jumps to the \
referenced cell. If you want to jump to this cell from a different notebook, \
check \"Include file name in link destination\".\n\[FilledSmallSquare] A \
hyperlink is a ",
  StyleBox["ButtonBox", "MR"],
  " object with the options",
  StyleBox[" ", "MR",
    FontFamily->"Times"],
  StyleBox["ButtonStyle\[Rule]\"Hyperlink\"", "MR"],
  " and ",
  StyleBox["ButtonData\[Rule]\"", "MR"],
  StyleBox["destination", "MR",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["\"", "MR"],
  ".\n\[FilledSmallSquare] To edit the name of a hyperlink button, click \
beside the button and use the arrow keys to move the insertion point into the \
button's text."
}], "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["NotebookLocate",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.10.13",
    ButtonData:>{"1.10.13"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Add/Remove Cell Tags",
    ButtonData:>"Add/Remove Cell Tags",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],

Cell["Create Automatic Numbering Object...", "Command",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Create Automatic Numbering Object", "SR"],
  " sets up automatic numbering in the current notebook."
}], "Usage",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The counters available in a particular notebook are \
usually defined by the style sheet. The default style sheet defines counters \
named Section, Subsection, Subsubsection, Equation, Figure, and Table.\n\
\[FilledSmallSquare] Counter values can be displayed either as they exist at \
the location of the display, or as they exist at a remote location defined by \
a cell tag.\n\[FilledSmallSquare] A counter named Page is always available, \
but it is only valid when the option to show page breaks is turned on.\n\
\[FilledSmallSquare] Counter values are set and incremented by the options ",
  StyleBox["CounterAssignments", "MR"],
  " and ",
  StyleBox["CounterIncrements", "MR"],
  ".\n\[FilledSmallSquare] The counter display can be controlled using the \
options ",
  StyleBox["CounterStyle", "MR"],
  " and ",
  StyleBox["CounterFunction", "MR"],
  "."
}], "Notes",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["CounterStyle",
    ButtonData:>"CounterBoxOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["CounterFunction",
    ButtonData:>"CounterBoxOptions->{...}",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.10.14",
    ButtonData:>{"1.10.14"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],

Cell["Create Value Display Object...", "Command",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Create Value Display Object ", "SR"],
  StyleBox["sets up an object in your notebook to display the values of a \
specified option.", "Text"]
}], "Usage",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],

Cell["\<\
\[FilledSmallSquare] The value of the specified option is displayed \
as it would appear in the Option Inspector. The display is automatically \
updated if the option value changes.
\[FilledSmallSquare] Option values can be displayed either as they exist at \
the location of the display or as they exist at a remote location defined by \
a cell tag.
\[FilledSmallSquare] In addition to any option value, the following names can \
be used to display other values:\
\>", "Notes",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],

Cell[BoxData[{
    StyleBox["FileName",
      "MR"], "\n", 
    StyleBox["PathName",
      "MR"], "\n", 
    StyleBox["MemoryInUse",
      "MR"], "\n", 
    StyleBox["FreeMemory",
      "MR"], "\n", 
    StyleBox["ClipboardMemoryInUse",
      "MR"], "\n", 
    StyleBox["$UserName",
      "MR"], "\n", 
    StyleBox["$MachineName",
      "MR"], "\n", 
    StyleBox["$Version",
      "MR"], "\n", 
    StyleBox["$FullVersion",
      "MR"], "\n", 
    StyleBox["$VersionNumber",
      "MR"], "\n", 
    StyleBox["$System",
      "MR"], "\n", 
    StyleBox["$ReleaseNumber",
      "MR"], "\n", 
    StyleBox["$MinorReleaseNumber",
      "MR"], "\n", 
    StyleBox["$CreationDate",
      "MR"], "\n", 
    StyleBox["$MachineID",
      "MR"], "\n", 
    StyleBox["$MachineType",
      "MR"], "\n", 
    StyleBox["$OperatingSystem",
      "MR"], "\n", 
    StyleBox["$ProcessorType",
      "MR"], "\n", 
    StyleBox["$ProgramName",
      "MR"], "\n", 
    StyleBox["$SystemID",
      "MR"], "\n", 
    StyleBox["$InstallationDirectory",
      "MR"], "\n", 
    StyleBox["$LaunchDirectory",
      "MR"], "\n", 
    StyleBox["$HomeDirectory",
      "MR"], "\n", 
    StyleBox["$InitialDirectory",
      "MR"], "\n", 
    StyleBox["$EvaluationDirectory",
      "MR"], "\n", 
    StyleBox["Date",
      "MR"], "\n", 
    StyleBox["DateLong",
      "MR"], "\n", 
    StyleBox["Time",
      "MR"], "\n", 
    StyleBox["Year",
      "MR"], "\n", 
    StyleBox["Month",
      "MR"], "\n", 
    StyleBox["MonthName",
      "MR"], "\n", 
    StyleBox["Day",
      "MR"], "\n", 
    StyleBox["Hour",
      "MR"], "\n", 
    StyleBox["Minute",
      "MR"], "\n", 
    StyleBox["Second",
      "MR"], "\n", 
    StyleBox["$ExpirationDate",
      "MR"], "\n", 
    StyleBox["$LicenseExpirationDate",
      "MR"], "\n", 
    StyleBox[\(\($ExpirationString\)\(\t\)\),
      "MR"], "\n", 
    StyleBox["$RegistrationUserName",
      "MR"], "\n", 
    StyleBox["$RegistrationOrganization",
      "MR"], "\n", 
    StyleBox["$LicenseID",
      "MR"]}], "Input",
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],

Cell["Convert Automatic Objects to Literal", "Command",
  CellTags->"ConvertAutomaticObjects"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert Automatic Objects to Literal",
    FontFamily->"Helvetica"],
  " replaces ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  ", ",
  StyleBox["ValueBox",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["OptionValueBox",
    FontFamily->"Courier"],
  " objects with plain text consisting of their current display value."
}], "Usage",
  CellTags->"ConvertAutomaticObjects"],

Cell["\<\
\[FilledSmallSquare] The box objects listed above are normally \
dynamic in nature; they display a value that is automatically updated to \
reflect changes in a variable or option. When converted to literal form, \
however, the box object is replaced by text showing its current value. The \
value is not updated even if the relevant variable or option changes. \
\>", \
"Notes",
  CellTags->"ConvertAutomaticObjects"],

Cell["Copy Input from Above", "Command",
  CellTags->"DuplicatePreviousInput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Copy Input From Above", "SR"],
  " copies the contents of the nearest input cell above."
}], "Usage",
  CellTags->"DuplicatePreviousInput"],

Cell["\<\
\[FilledSmallSquare] This command copies the contents of the \
nearest active cell preceding your insertion point and then pastes it at the \
insertion point.\
\>", "Notes",
  CellTags->"DuplicatePreviousInput"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["l", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["l", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["l", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"DuplicatePreviousInput"],

Cell["Copy Output from Above", "Command",
  CellTags->"DuplicatePreviousOutput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Copy Output From Above", "SR"],
  " copies the contents of the nearest output cell above."
}], "Usage",
  CellTags->"DuplicatePreviousOutput"],

Cell["\<\
\[FilledSmallSquare] This command copies the contents of the \
nearest output cell above your insertion point and then pastes it at the \
insertion point.\
\>", "Notes",
  CellTags->"DuplicatePreviousOutput"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["l", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["l", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["l", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"DuplicatePreviousOutput"],

Cell["Start New Cell Below", "Command",
  CellTags->"SimilarCellBelow"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Start New Cell Below", "SR"],
  " creates a new cell with inherited properties below the current cell."
}], "Usage",
  CellTags->"SimilarCellBelow"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[AltKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[OptionKey]\[KeyBar]\[ReturnKey] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[AltKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SimilarCellBelow"],

Cell["Complete Selection", "Command",
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Complete Selection", "SR"],
  " completes a partially typed function name. "
}], "Usage",
  CellTags->"CompleteSelection"],

Cell["\<\
\[FilledSmallSquare] This command reads your current selection \
(which should be a single word or an insertion point following a word) and \
looks up possible completions in the list of all currently defined functions \
and variables.\
\>", "Notes",
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare]  This command also provides completions for keyboard \
aliases and full names of special characters, such as ",
  StyleBox["\[Backslash][Alpha]",
    FontFamily->"Courier"],
  " and ",
  "\[AliasIndicator]",
  StyleBox["a",
    FontFamily->"Courier"],
  "\[AliasIndicator]",
  "."
}], "Notes",
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This command works only when you are connected to a \
",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " kernel."
}], "Notes",
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] When there is only one possible completion, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " automatically inserts the additional characters to finish what you have \
typed. Otherwise, a pop-up menu lists the various possible completions. To \
insert one of them, click the completion you want, or type another letter to \
reduce the list of possible completions. "
}], "Notes",
  CellTags->"CompleteSelection"],

Cell["\<\
\[FilledSmallSquare] Press Backspace to cancel the pop-up \
menu.\
\>", "Notes",
  CellTags->"CompleteSelection"],

Cell["\<\
\[FilledSmallSquare] If the list is long, you can scroll through \
the menu by moving the mouse up or down or by using the arrow keys.\
\>", \
"Notes",
  CellTags->"CompleteSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["k", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["k", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["k", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CompleteSelection"],

Cell["Make Template", "Command",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Make Template", "SR"],
  " inserts a template based on the currently selected function name. "
}], "Usage",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] This command reads your current selection (which \
should be a function name or insertion point after a function name) and adds \
a template for the arguments it can take. For example, if your selection is \
",
  StyleBox["Plot", "MR",
    FontFamily->"Courier"],
  " you get ",
  StyleBox["Plot[f, {x, xmin, xmax}]", "MR",
    FontFamily->"Courier"],
  ", which shows the simplest form of the ",
  StyleBox["Plot", "MR",
    FontFamily->"Courier"],
  " function. "
}], "Notes",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] You can only get function templates when you are \
connected to a ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " kernel. To define a function template for a user-defined function, make \
the template the first statement in the \"usage\" message for the function. \
For example, to define the template ",
  StyleBox["f[a,b]", "MR",
    FontFamily->"Courier"],
  " for the function f, you could use the following command.\n",
  StyleBox[" \t",
    FontFamily->"Courier"],
  StyleBox["f::usage = \"f[a,b] is an example of a function\"", "MR",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] Note that the templates you get for built-in \
functions are usually only one of several possible argument forms. Use the \
kernel command ",
  StyleBox["?", "MR",
    FontFamily->"Courier"],
  " to get more information, or see ",
  StyleBox["The",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " ",
  StyleBox["Book",
    FontSlant->"Italic"],
  " for a complete description of a given command."
}], "Notes",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] When you choose ",
  StyleBox["Make Template", "SR"],
  " after typing a partial word, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " looks to the left of the insertion point to find a suitable function or \
variable name. When this name is not a currently defined function, ",
  StyleBox["Make Template", "SR"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "applies the ",
  StyleBox["Complete Selection", "SR"],
  " command before attempting to make a template."
}], "Notes",
  CellTags->"TemplateSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["k", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["k", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["k", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"TemplateSelection"]
}, Closed]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1107}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->{},
WindowSize->{537, 551},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowCellBracket->False,
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "GraphicsCoordinatesDialog"->{
    Cell[1754, 51, 87, 1, 41, "Command",
      CellTags->"GraphicsCoordinatesDialog"],
    Cell[1844, 54, 178, 5, 32, "Usage",
      CellTags->"GraphicsCoordinatesDialog"],
    Cell[2025, 61, 904, 17, 158, "Notes",
      CellTags->"GraphicsCoordinatesDialog"]},
  "ViewPointSelectorDialog"->{
    Cell[2932, 80, 109, 2, 41, "Command",
      CellTags->"ViewPointSelectorDialog"],
    Cell[3044, 84, 218, 6, 48, "Usage",
      CellTags->"ViewPointSelectorDialog"],
    Cell[3921, 112, 435, 14, 40, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[4359, 128, 385, 8, 98, "ItemizedText",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[4747, 138, 478, 15, 40, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[5228, 155, 371, 9, 40, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}]},
  "viewPointSelectorID"->{
    Cell[3265, 92, 653, 18, 24, "Notes",
      CellTags->"viewPointSelectorID"],
    Cell[3921, 112, 435, 14, 40, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[4359, 128, 385, 8, 98, "ItemizedText",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[4747, 138, 478, 15, 40, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
    Cell[5228, 155, 371, 9, 40, "Notes",
      CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}]},
  "ColorSelectorDialog"->{
    Cell[5602, 166, 71, 1, 41, "Command",
      CellTags->"ColorSelectorDialog"],
    Cell[5676, 169, 302, 9, 48, "Usage",
      CellTags->"ColorSelectorDialog"],
    Cell[5981, 180, 1041, 33, 72, "Notes",
      CellTags->"ColorSelectorDialog"]},
  "RecordSoundDialog"->{
    Cell[7025, 215, 67, 1, 41, "Command",
      CellTags->"RecordSoundDialog"],
    Cell[7095, 218, 276, 9, 32, "Usage",
      CellTags->"RecordSoundDialog"],
    Cell[7374, 229, 1149, 30, 70, "Notes",
      CellTags->"RecordSoundDialog"]},
  "FileNameDialog"->{
    Cell[8526, 261, 65, 1, 70, "Command",
      CellTags->"FileNameDialog"],
    Cell[8594, 264, 184, 5, 70, "Usage",
      CellTags->"FileNameDialog"],
    Cell[8781, 271, 256, 7, 70, "Notes",
      CellTags->"FileNameDialog"]},
  "CreateGridBoxDialog"->{
    Cell[9040, 280, 111, 1, 70, "Command",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9154, 283, 233, 7, 70, "Usage",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9412, 294, 131, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9546, 298, 198, 6, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9781, 309, 132, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9916, 313, 184, 4, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10137, 322, 133, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10273, 326, 258, 7, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10568, 338, 135, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10706, 342, 162, 4, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10905, 351, 139, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11047, 355, 214, 4, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11264, 361, 190, 6, 70, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11457, 369, 679, 18, 70, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialog"}],
    Cell[19376, 614, 377, 11, 70, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]},
  "createGridBoxDialogID"->{
    Cell[9040, 280, 111, 1, 70, "Command",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9154, 283, 233, 7, 70, "Usage",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9412, 294, 131, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9546, 298, 198, 6, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9781, 309, 132, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[9916, 313, 184, 4, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10137, 322, 133, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10273, 326, 258, 7, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10568, 338, 135, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10706, 342, 162, 4, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[10905, 351, 139, 2, 70, "DialogItem",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11047, 355, 214, 4, 70, "IndentedText",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[11264, 361, 190, 6, 70, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
    Cell[19376, 614, 377, 11, 70, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]},
  "createGridBoxDialog"->{
    Cell[11457, 369, 679, 18, 70, "Notes",
      CellTags->{"CreateGridBoxDialog", "createGridBoxDialog"}]},
  "CreateCustomButtonBox"->{
    Cell[12139, 389, 69, 1, 70, "Command",
      CellTags->"CreateCustomButtonBox"],
    Cell[12211, 392, 202, 5, 70, "Usage",
      CellTags->"CreateCustomButtonBox"],
    Cell[12416, 399, 214, 5, 70, "Notes",
      CellTags->"CreateCustomButtonBox"],
    Cell[12633, 406, 264, 10, 70, "Notes",
      CellTags->"CreateCustomButtonBox"]},
  "EditButtonBoxDialog"->{
    Cell[12900, 418, 101, 1, 70, "Command",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13004, 421, 269, 7, 70, "Usage",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13276, 430, 385, 7, 70, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13664, 439, 629, 24, 70, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[14296, 465, 295, 10, 70, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}]},
  "editButtonBoxScriptDialogID"->{
    Cell[12900, 418, 101, 1, 70, "Command",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13004, 421, 269, 7, 70, "Usage",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13276, 430, 385, 7, 70, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[13664, 439, 629, 24, 70, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
    Cell[14296, 465, 295, 10, 70, "Notes",
      CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}]},
  "CreateHyperlinkDialog"->{
    Cell[14594, 477, 97, 1, 70, "Command",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[14694, 480, 216, 5, 70, "Usage",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[14913, 487, 324, 6, 70, "ItemizedText",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15240, 495, 309, 8, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15552, 505, 326, 7, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15881, 514, 566, 16, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[16450, 532, 830, 20, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[17283, 554, 205, 6, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[17491, 562, 286, 10, 70, "Text",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[17780, 574, 243, 7, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}]},
  "copyLinkDialogID"->{
    Cell[14594, 477, 97, 1, 70, "Command",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[14694, 480, 216, 5, 70, "Usage",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[14913, 487, 324, 6, 70, "ItemizedText",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15240, 495, 309, 8, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15552, 505, 326, 7, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[15881, 514, 566, 16, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[16450, 532, 830, 20, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[17283, 554, 205, 6, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[17491, 562, 286, 10, 70, "Text",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
    Cell[17780, 574, 243, 7, 70, "Notes",
      CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}]},
  "CreateCounterBoxDialog"->{
    Cell[18026, 583, 123, 1, 70, "Command",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[18152, 586, 236, 5, 70, "Usage",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[18391, 593, 982, 19, 70, "Notes",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[19756, 627, 295, 10, 70, "Text",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}]},
  "createCounterBoxDialogID"->{
    Cell[18026, 583, 123, 1, 70, "Command",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[18152, 586, 236, 5, 70, "Usage",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[18391, 593, 982, 19, 70, "Notes",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
    Cell[19756, 627, 295, 10, 70, "Text",
      CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}]},
  "CreateOptionValueBoxDialog"->{
    Cell[20054, 639, 125, 1, 70, "Command",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[20182, 642, 285, 6, 70, "Usage",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[20470, 650, 564, 10, 70, "Notes",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[21037, 662, 2171, 84, 70, "Input",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}]},
  "createOptionValueBoxDialogID"->{
    Cell[20054, 639, 125, 1, 70, "Command",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[20182, 642, 285, 6, 70, "Usage",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[20470, 650, 564, 10, 70, "Notes",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
    Cell[21037, 662, 2171, 84, 70, "Input",
      CellTags->{
      "CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}]},
  "ConvertAutomaticObjects"->{
    Cell[23211, 748, 94, 1, 70, "Command",
      CellTags->"ConvertAutomaticObjects"],
    Cell[23308, 751, 444, 15, 70, "Usage",
      CellTags->"ConvertAutomaticObjects"],
    Cell[23755, 768, 428, 8, 70, "Notes",
      CellTags->"ConvertAutomaticObjects"]},
  "DuplicatePreviousInput"->{
    Cell[24186, 778, 78, 1, 70, "Command",
      CellTags->"DuplicatePreviousInput"],
    Cell[24267, 781, 194, 5, 70, "Usage",
      CellTags->"DuplicatePreviousInput"],
    Cell[24464, 788, 221, 5, 70, "Notes",
      CellTags->"DuplicatePreviousInput"],
    Cell[24688, 795, 597, 18, 70, "Notes",
      CellTags->"DuplicatePreviousInput"]},
  "DuplicatePreviousOutput"->{
    Cell[25288, 815, 80, 1, 70, "Command",
      CellTags->"DuplicatePreviousOutput"],
    Cell[25371, 818, 197, 5, 70, "Usage",
      CellTags->"DuplicatePreviousOutput"],
    Cell[25571, 825, 218, 5, 70, "Notes",
      CellTags->"DuplicatePreviousOutput"],
    Cell[25792, 832, 658, 18, 70, "Notes",
      CellTags->"DuplicatePreviousOutput"]},
  "SimilarCellBelow"->{
    Cell[26453, 852, 71, 1, 70, "Command",
      CellTags->"SimilarCellBelow"],
    Cell[26527, 855, 203, 5, 70, "Usage",
      CellTags->"SimilarCellBelow"],
    Cell[26733, 862, 409, 12, 70, "Notes",
      CellTags->"SimilarCellBelow"]},
  "CompleteSelection"->{
    Cell[27145, 876, 70, 1, 70, "Command",
      CellTags->"CompleteSelection"],
    Cell[27218, 879, 177, 5, 70, "Usage",
      CellTags->"CompleteSelection"],
    Cell[27398, 886, 293, 6, 70, "Notes",
      CellTags->"CompleteSelection"],
    Cell[27694, 894, 366, 12, 70, "Notes",
      CellTags->"CompleteSelection"],
    Cell[28063, 908, 237, 8, 70, "Notes",
      CellTags->"CompleteSelection"],
    Cell[28303, 918, 491, 10, 70, "Notes",
      CellTags->"CompleteSelection"],
    Cell[28797, 930, 123, 4, 70, "Notes",
      CellTags->"CompleteSelection"],
    Cell[28923, 936, 194, 5, 70, "Notes",
      CellTags->"CompleteSelection"],
    Cell[29120, 943, 585, 17, 70, "Notes",
      CellTags->"CompleteSelection"]},
  "TemplateSelection"->{
    Cell[29708, 962, 65, 1, 70, "Command",
      CellTags->"TemplateSelection"],
    Cell[29776, 965, 195, 5, 70, "Usage",
      CellTags->"TemplateSelection"],
    Cell[29974, 972, 551, 15, 70, "Notes",
      CellTags->"TemplateSelection"],
    Cell[30528, 989, 694, 17, 70, "Notes",
      CellTags->"TemplateSelection"],
    Cell[31225, 1008, 553, 18, 70, "Notes",
      CellTags->"TemplateSelection"],
    Cell[31781, 1028, 590, 16, 70, "Notes",
      CellTags->"TemplateSelection"],
    Cell[32374, 1046, 652, 18, 70, "Notes",
      CellTags->"TemplateSelection"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"GraphicsCoordinatesDialog", 33833, 1089},
  {"ViewPointSelectorDialog", 34126, 1096},
  {"viewPointSelectorID", 34773, 1109},
  {"ColorSelectorDialog", 35331, 1120},
  {"RecordSoundDialog", 35603, 1127},
  {"FileNameDialog", 35866, 1134},
  {"CreateGridBoxDialog", 36123, 1141},
  {"createGridBoxDialogID", 37844, 1172},
  {"createGridBoxDialog", 39455, 1201},
  {"CreateCustomButtonBox", 39593, 1204},
  {"EditButtonBoxDialog", 39959, 1213},
  {"editButtonBoxScriptDialogID", 40574, 1224},
  {"CreateHyperlinkDialog", 41183, 1235},
  {"copyLinkDialogID", 42278, 1256},
  {"CreateCounterBoxDialog", 43379, 1277},
  {"createCounterBoxDialogID", 43875, 1286},
  {"CreateOptionValueBoxDialog", 44373, 1295},
  {"createOptionValueBoxDialogID", 44935, 1308},
  {"ConvertAutomaticObjects", 45492, 1321},
  {"DuplicatePreviousInput", 45783, 1328},
  {"DuplicatePreviousOutput", 46157, 1337},
  {"SimilarCellBelow", 46528, 1346},
  {"CompleteSelection", 46793, 1353},
  {"TemplateSelection", 47543, 1372}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 87, 1, 41, "Command",
  CellTags->"GraphicsCoordinatesDialog"],
Cell[1844, 54, 178, 5, 32, "Usage",
  CellTags->"GraphicsCoordinatesDialog"],
Cell[2025, 61, 904, 17, 158, "Notes",
  CellTags->"GraphicsCoordinatesDialog"],
Cell[2932, 80, 109, 2, 41, "Command",
  CellTags->"ViewPointSelectorDialog"],
Cell[3044, 84, 218, 6, 48, "Usage",
  CellTags->"ViewPointSelectorDialog"],
Cell[3265, 92, 653, 18, 24, "Notes",
  CellTags->"viewPointSelectorID"],
Cell[3921, 112, 435, 14, 40, "Notes",
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
Cell[4359, 128, 385, 8, 98, "ItemizedText",
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
Cell[4747, 138, 478, 15, 40, "Notes",
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
Cell[5228, 155, 371, 9, 40, "Notes",
  CellTags->{"viewPointSelectorID", "ViewPointSelectorDialog"}],
Cell[5602, 166, 71, 1, 41, "Command",
  CellTags->"ColorSelectorDialog"],
Cell[5676, 169, 302, 9, 48, "Usage",
  CellTags->"ColorSelectorDialog"],
Cell[5981, 180, 1041, 33, 72, "Notes",
  CellTags->"ColorSelectorDialog"],
Cell[7025, 215, 67, 1, 41, "Command",
  CellTags->"RecordSoundDialog"],
Cell[7095, 218, 276, 9, 32, "Usage",
  CellTags->"RecordSoundDialog"],
Cell[7374, 229, 1149, 30, 70, "Notes",
  CellTags->"RecordSoundDialog"],
Cell[8526, 261, 65, 1, 70, "Command",
  CellTags->"FileNameDialog"],
Cell[8594, 264, 184, 5, 70, "Usage",
  CellTags->"FileNameDialog"],
Cell[8781, 271, 256, 7, 70, "Notes",
  CellTags->"FileNameDialog"],
Cell[9040, 280, 111, 1, 70, "Command",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[9154, 283, 233, 7, 70, "Usage",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],

Cell[CellGroupData[{
Cell[9412, 294, 131, 2, 70, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[9546, 298, 198, 6, 70, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]
}, Closed]],

Cell[CellGroupData[{
Cell[9781, 309, 132, 2, 70, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[9916, 313, 184, 4, 70, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]
}, Closed]],

Cell[CellGroupData[{
Cell[10137, 322, 133, 2, 70, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[10273, 326, 258, 7, 70, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]
}, Closed]],

Cell[CellGroupData[{
Cell[10568, 338, 135, 2, 70, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[10706, 342, 162, 4, 70, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}]
}, Closed]],

Cell[CellGroupData[{
Cell[10905, 351, 139, 2, 70, "DialogItem",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[11047, 355, 214, 4, 70, "IndentedText",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[11264, 361, 190, 6, 70, "Notes",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[11457, 369, 679, 18, 70, "Notes",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialog"}],
Cell[12139, 389, 69, 1, 70, "Command",
  CellTags->"CreateCustomButtonBox"],
Cell[12211, 392, 202, 5, 70, "Usage",
  CellTags->"CreateCustomButtonBox"],
Cell[12416, 399, 214, 5, 70, "Notes",
  CellTags->"CreateCustomButtonBox"],
Cell[12633, 406, 264, 10, 70, "Notes",
  CellTags->"CreateCustomButtonBox"],
Cell[12900, 418, 101, 1, 70, "Command",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
Cell[13004, 421, 269, 7, 70, "Usage",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
Cell[13276, 430, 385, 7, 70, "Notes",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
Cell[13664, 439, 629, 24, 70, "Notes",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
Cell[14296, 465, 295, 10, 70, "Notes",
  CellTags->{"EditButtonBoxDialog", "editButtonBoxScriptDialogID"}],
Cell[14594, 477, 97, 1, 70, "Command",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[14694, 480, 216, 5, 70, "Usage",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[14913, 487, 324, 6, 70, "ItemizedText",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[15240, 495, 309, 8, 70, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[15552, 505, 326, 7, 70, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[15881, 514, 566, 16, 70, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[16450, 532, 830, 20, 70, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[17283, 554, 205, 6, 70, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[17491, 562, 286, 10, 70, "Text",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[17780, 574, 243, 7, 70, "Notes",
  CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"}],
Cell[18026, 583, 123, 1, 70, "Command",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
Cell[18152, 586, 236, 5, 70, "Usage",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
Cell[18391, 593, 982, 19, 70, "Notes",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
Cell[19376, 614, 377, 11, 70, "Notes",
  CellTags->{"CreateGridBoxDialog", "createGridBoxDialogID"}],
Cell[19756, 627, 295, 10, 70, "Text",
  CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"}],
Cell[20054, 639, 125, 1, 70, "Command",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
Cell[20182, 642, 285, 6, 70, "Usage",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
Cell[20470, 650, 564, 10, 70, "Notes",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
Cell[21037, 662, 2171, 84, 70, "Input",
  CellTags->{"CreateOptionValueBoxDialog", "createOptionValueBoxDialogID"}],
Cell[23211, 748, 94, 1, 70, "Command",
  CellTags->"ConvertAutomaticObjects"],
Cell[23308, 751, 444, 15, 70, "Usage",
  CellTags->"ConvertAutomaticObjects"],
Cell[23755, 768, 428, 8, 70, "Notes",
  CellTags->"ConvertAutomaticObjects"],
Cell[24186, 778, 78, 1, 70, "Command",
  CellTags->"DuplicatePreviousInput"],
Cell[24267, 781, 194, 5, 70, "Usage",
  CellTags->"DuplicatePreviousInput"],
Cell[24464, 788, 221, 5, 70, "Notes",
  CellTags->"DuplicatePreviousInput"],
Cell[24688, 795, 597, 18, 70, "Notes",
  CellTags->"DuplicatePreviousInput"],
Cell[25288, 815, 80, 1, 70, "Command",
  CellTags->"DuplicatePreviousOutput"],
Cell[25371, 818, 197, 5, 70, "Usage",
  CellTags->"DuplicatePreviousOutput"],
Cell[25571, 825, 218, 5, 70, "Notes",
  CellTags->"DuplicatePreviousOutput"],
Cell[25792, 832, 658, 18, 70, "Notes",
  CellTags->"DuplicatePreviousOutput"],
Cell[26453, 852, 71, 1, 70, "Command",
  CellTags->"SimilarCellBelow"],
Cell[26527, 855, 203, 5, 70, "Usage",
  CellTags->"SimilarCellBelow"],
Cell[26733, 862, 409, 12, 70, "Notes",
  CellTags->"SimilarCellBelow"],
Cell[27145, 876, 70, 1, 70, "Command",
  CellTags->"CompleteSelection"],
Cell[27218, 879, 177, 5, 70, "Usage",
  CellTags->"CompleteSelection"],
Cell[27398, 886, 293, 6, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[27694, 894, 366, 12, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[28063, 908, 237, 8, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[28303, 918, 491, 10, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[28797, 930, 123, 4, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[28923, 936, 194, 5, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[29120, 943, 585, 17, 70, "Notes",
  CellTags->"CompleteSelection"],
Cell[29708, 962, 65, 1, 70, "Command",
  CellTags->"TemplateSelection"],
Cell[29776, 965, 195, 5, 70, "Usage",
  CellTags->"TemplateSelection"],
Cell[29974, 972, 551, 15, 70, "Notes",
  CellTags->"TemplateSelection"],
Cell[30528, 989, 694, 17, 70, "Notes",
  CellTags->"TemplateSelection"],
Cell[31225, 1008, 553, 18, 70, "Notes",
  CellTags->"TemplateSelection"],
Cell[31781, 1028, 590, 16, 70, "Notes",
  CellTags->"TemplateSelection"],
Cell[32374, 1046, 652, 18, 70, "Notes",
  CellTags->"TemplateSelection"]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

