(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     30038,       1026]*)
(*NotebookOutlinePosition[     46672,       1406]*)
(*  CellTagsIndexPosition[     45592,       1375]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Evaluation ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell[CellGroupData[{

Cell["Evaluate Cells", "Command",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate Cells", "SR"],
  " sends the currently selected cells to the kernel for evaluation."
}], "Usage",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] Only cells with the option ",
  StyleBox["Evaluatable\[Rule]True", "MR"],
  " (normally cells in the Input style) will be evaluated. All other cells \
will be ignored.\n\[FilledSmallSquare] If you currently do not have the \
appropriate kernel running, it will be started for you (see the Default  \
Kernel and Notebooks Kernel submenus).\n\[FilledSmallSquare] A cell may have \
a private kernel specified (see the Evaluator option), in which the cells you \
evaluate may be sent to different kernels. The output from multiple kernels \
will be placed after the corresponding input cells as soon as it is received. \
This means output from lower cells may be placed before output from higher \
cells."
}], "Notes",
  CellTags->"EvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:",
  StyleBox[" \[ShiftKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ReturnKey] ", "C1"],
  StyleBox["or ", "Notes"],
  StyleBox["\[EnterKey]", "C1MR"],
  StyleBox[" ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"EvaluateCells"],

Cell["\<\
\[FilledSmallSquare] Pressing \[EnterKey] by itself in Windows and X does not \
evaluate a selection--it produces a line break.\
\>", "Notes",
  CellTags->"EvaluateCells"]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluate in Place", "Command",
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate in Place", "SR"],
  " evaluates the current selection in place."
}], "Usage",
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] No new output cell is produced; instead the output is \
pasted over the selected input.\n\[FilledSmallSquare] Unlike ",
  StyleBox["Evaluate Cells", "SR"],
  ",",
  StyleBox[" Evaluate in Place", "SR"],
  " evaluates only the selected characters, not the whole cell.\n\
\[FilledSmallSquare] If the evaluation produces warning messages, ",
  StyleBox["print", "MR",
    FontFamily->"Times"],
  " output, or graphics output, all are placed in new cells below the cell \
being evaluated."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Evaluate"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[KeyBar]\[ReturnKey] ", "C1"],
  StyleBox["(Macintosh); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Evaluate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluate Next Input", "Command",
  CellTags->"EvaluateNextCell"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate Next Input", "SR"],
  " selects and then evaluates the next cell in the notebook."
}], "Usage",
  CellTags->"EvaluateNextCell"],

Cell["\<\
\[FilledSmallSquare] This command moves to and then evaluates the next input \
cell below the current selection. When the current selection is a single \
input cell, it is evaluated; otherwise, the next input cell after the current \
selection is selected. By repeatedly choosing this command, you can evaluate \
all the input cells in a notebook, one at a time.\
\>", "Notes",
  CellTags->"EvaluateNextCell"],

Cell["\<\
\[FilledSmallSquare] You need to choose this command twice for each cell, \
once to select it and once to evaluate it. This allows you to see the next \
input before evaluating it, and is good for pre-programmed demonstrations.\
\>", "Notes",
  CellTags->"EvaluateNextCell"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]Keypad\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[EnterKey]", "C1"],
  " ",
  StyleBox["(Macintosh);", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]Keypad\[KeyBar]\[EnterKey] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"EvaluateNextCell"]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluate in Subsession", "Command",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate in Subsession", "SR"],
  " evaluates the selected cells in a kernel dialog."
}], "Usage",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] When an evaluation is in progress, you can use this \
command to inspect the state of the kernel. When you select ",
  StyleBox["Evaluate in Subsession", "SR"],
  ", the current evaluation is suspended (indicated by a grayed cell  \
bracket), the cells selected are evaluated in a kernel subsession (",
  StyleBox["Dialog", "Input"],
  "), and then the original evaluation is resumed."
}], "Notes",
  CellTags->"SubsessionEvaluateCells"],

Cell["\<\
\[FilledSmallSquare] This can be useful for checking on the status of \
variables in a long calculation or for debugging.\
\>", "Notes",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["Dialog",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"SubsessionEvaluateCells"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["F7 ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[OptionKey]\[KeyBar]\[ReturnKey]", "C1"],
  " ",
  StyleBox["(Macintosh);", "Notes"],
  " ",
  StyleBox["F7 ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SubsessionEvaluateCell"]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluate Notebook", "Command",
  CellTags->"EvaluateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate Notebook", "SR"],
  " evaluates all the evaluatable cells in the notebook."
}], "Usage",
  CellTags->"EvaluateNotebook"],

Cell["\<\
\[FilledSmallSquare] This is useful for notebooks in which each cell depends \
on the ones above, and all need to be re-evaluated to get the final result.\
\>", "Notes",
  CellTags->"EvaluateNotebook"]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluate Initialization", "Command",
  CellTags->"EvaluateInitialization"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluate Initialization", "SR"],
  " evaluates all initialization cells in the notebook."
}], "Usage",
  CellTags->"EvaluateInitialization"],

Cell[TextData[{
  "\[FilledSmallSquare] All cells with the options ",
  StyleBox["Evaluatable\[Rule]True", "MR"],
  " and ",
  StyleBox["InitializationCell\[Rule]True", "MR"],
  " will be evaluated. Normally notebooks are set up so that these cells \
contain definitions needed to use other material in the notebook."
}], "Notes",
  CellTags->"EvaluateInitialization"]
}, Closed]],

Cell[CellGroupData[{

Cell["Enter Subsession", "Command",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Enter Subsession", "SR"],
  " enters an interactive subsession (Dialog) during an evaluation."
}], "Usage",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["Dialog",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"EnterSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.14.2",
    ButtonData:>"2.14.2",
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"EnterSubsession"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exit Subsession", "Command",
  CellTags->"ExitSubsession"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Exit Subsession", "SR"],
  " exits the interactive subsession."
}], "Usage",
  CellTags->"ExitSubsession"]
}, Closed]],

Cell[CellGroupData[{

Cell["Remove From Evaluation Queue", "Command",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Remove From Evaluation Queue", "SR"],
  " cancels the pending evaluation of the selected cell."
}], "Usage",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] When you select several cells and choose ",
  StyleBox["Evaluate Cells", "SR"],
  ", the selected cell brackets are outlined, indicating that they are being \
sent one by one to the kernel for evaluation."
}], "Notes",
  CellTags->"RemoveFromEvaluationQueue"],

Cell["\<\
\[FilledSmallSquare] By choosing this command before a cell's turn for \
evaluation, you can prevent that cell from being evaluated.\
\>", "Notes",
  CellTags->"RemoveFromEvaluationQueue"],

Cell[TextData[{
  "\[FilledSmallSquare] To stop the evaluation of a cell that is currently \
being evaluated, use",
  StyleBox[" ", "SR",
    FontWeight->"Bold"],
  StyleBox["Interrupt Evaluation", "SR"],
  " or ",
  StyleBox["Abort Evaluation", "SR"],
  "."
}], "Notes",
  CellTags->"RemoveFromEvaluationQueue"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Interrupt Evaluation...", "Command",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Interrupt Evaluation", "SR"],
  " ",
  "interrupts the current operation being performed by the kernel."
}], "Usage",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] This dialog box appears when you choose ",
  StyleBox["Interrupt Evaluation", "SR"],
  " from the Kernel menu during an evaluation. You can use this dialog box to \
 abort an evaluation or to examine its progress. If you click ",
  StyleBox["Continue Evaluation",
    FontFamily->"Helvetica"],
  ", your evaluation completes normally."
}], "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[AltKey]\[LeftModified] , ] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified] , ] ", "C1"],
  StyleBox["(Macintosh);", "Notes"],
  " ",
  StyleBox["\[AltKey]\[LeftModified] , \[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"EvaluatorInterrupt"],

Cell[TextData[StyleBox["Continue Evaluation",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell["\<\
Closes the dialog box and lets your calculation proceed normally.\
\>", "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell["Abort Command Being Evaluated", "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "Aborts the calculation. This button is equivalent to the ",
  StyleBox["Abort Evaluation", "SR"],
  " command in the Kernel menu. If you click ",
  StyleBox["Abort",
    FontFamily->"Helvetica"],
  ", your calculation is stopped. The result entered in the notebook is a  \
symbol, ",
  StyleBox["$Aborted", "MR",
    FontFamily->"Courier"],
  ", representing an interrupted calculation. "
}], "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[StyleBox["Enter Subsession",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "Initiates a ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " dialog within the interrupted calculation. This button is equivalent to \
the ",
  StyleBox["Enter Subsession", "SR"],
  " command in the Evaluation submenu."
}], "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "See Reference Guide: ",
  ButtonBox["Dialog",
    ButtonStyle->"RefGuideLink"],
  "."
}], "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.14.2",
    ButtonData:>"2.14.2",
    ButtonStyle->"MainBookLink"],
  "."
}], "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell["\<\
\[FilledSmallSquare] Some calculations may not be immediately interruptible, \
in which case you do not get the dialog box until the calculation is able to \
stop. Sometimes when using a remote kernel you may not be able to interrupt \
short calculations at all, because they are finished before the interrupt \
request can be transmitted over the network.\
\>", "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] When you have more than one kernel running at the \
same time (",
  StyleBox["e.g",
    FontWeight->"ExtraLight"],
  StyleBox[".",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ", a local kernel and a remote kernel), this command applies only to the  \
current kernel. You can have several interrupt dialog boxes visible at the  \
same time, each labeled with the name of the corresponding kernel."
}], "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " is communicating with another program via ",
  StyleBox["MathLink",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ", the ",
  StyleBox["MathLink",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " Control options allow you to interrupt, abort, or kill the linked  \
program."
}], "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["Abort", "MR"],
  " does not work (",
  StyleBox["i.e.",
    FontWeight->"ExtraLight"],
  ", if the calculation keeps running for more than a few seconds), you can  \
choose ",
  StyleBox["Quit Kernel", "SR"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "from the Kernel menu. If you do this, you will have to restart a kernel  \
before you can evaluate anything else."
}], "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Abort Evaluation", "Command",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Abort Evaluation", "SR"],
  " aborts the current evaluation."
}], "Usage",
  CellTags->"EvaluatorAbort"],

Cell["\<\
\[FilledSmallSquare] This command has the same function as clicking the Abort \
button in the Interrupt dialog box.\
\>", "Notes",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Interrupt Evaluation",
    ButtonData:>"Interrupt Evaluation",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"EvaluatorAbort"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[AltKey]\[LeftModified] . ] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified] . ] ", "C1"],
  StyleBox["(Macintosh);", "Notes"],
  " ",
  StyleBox["\[AltKey]\[LeftModified] . \[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"EvaluatorAbort"]
}, Closed]],

Cell[CellGroupData[{

Cell["Start Kernel", "Command",
  CellTags->"MenuListStartEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Start Kernel", "SR"],
  " starts the specified kernel."
}], "Usage",
  CellTags->"MenuListStartEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] Kernel connections are defined in the ",
  StyleBox["Kernel Configuration Options", "SR"],
  " dialog box. Once you have defined a kernel connection in this dialog box, \
the name you gave it appears in this menu."
}], "Notes",
  CellTags->"MenuListStartEvaluators"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quit Kernel", "Command",
  CellTags->"MenuListQuitEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Quit Kernel", "SR"],
  " terminates the specified kernel."
}], "Usage",
  CellTags->"MenuListQuitEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] Kernel connections are defined in the ",
  StyleBox["Kernel Configuration Options", "SR"],
  " dialog box. Once you have defined a kernel connection in this dialog box, \
the name you gave it appears in this menu."
}], "Notes",
  CellTags->"MenuListQuitEvaluators"],

Cell["\<\
\[FilledSmallSquare] Active kernels have a check mark beside their name.\
\>", "Notes",
  CellTags->"MenuListQuitEvaluators"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Quit Local Kernel dialog box",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False],

Cell["\<\
\[FilledSmallSquare] This dialog box is a warning that you are about to lose \
all the information contained in your local kernel.\
\>", "Usage"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Quit Remote Kernel dialog box",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False],

Cell[TextData[{
  "\[FilledSmallSquare] This dialog box is a warning that the ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " front end is about to transmit a Quit signal to the remote kernel."
}], "Usage"]
}, Closed]],

Cell[CellGroupData[{

Cell["Default Kernel", "Command",
  CellTags->"MenuListGlobalEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Kernel", "SR"],
  " specifies the kernel to be used by default for all calculations."
}], "Usage",
  CellTags->"MenuListGlobalEvaluators"]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook\[CloseCurlyQuote]s Kernel", "Command",
  CellTags->"MenuListNotebookEvaluators"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Notebook's Kernel", "SR"],
  " specifies the kernel to be used for the current notebook."
}], "Usage",
  CellTags->"MenuListNotebookEvaluators"]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel Configuration Options...", "Command",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Kernel Configuration Options", "SR"],
  " lets you set up connections to a kernel. "
}], "Usage",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[CellGroupData[{

Cell["Remote Kernel Connections: Microsoft Windows", "SubsectionIcon",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell["\<\
\[FilledSmallSquare] To establish a remote kernel connection, the kernel must \
be Version 5.0 or later. \
\>", "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell["\<\
\[FilledSmallSquare] To set up a connection from a Windows front end to a \
kernel on a remote machine:\
\>", "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  Choose ",
  StyleBox["Kernel \[RightTriangle] Kernel Configuration Options",
    FontFamily->"Helvetica"],
  ".\n",
  StyleBox["2.",
    FontWeight->"Bold"],
  "  Click ",
  StyleBox["Add",
    FontFamily->"Helvetica"],
  ". The Kernel Properties dialog box opens to let you define a new kernel \
connection.\n",
  StyleBox["3.",
    FontWeight->"Bold"],
  "  Type a name for the new connection in the \"Kernel Name\" text box.\n",
  StyleBox["4.  ",
    FontWeight->"Bold"],
  "Click ",
  StyleBox["Remote Machine",
    FontFamily->"Helvetica"],
  ". \n",
  StyleBox["5.  ",
    FontWeight->"Bold"],
  "Enter the name or IP address of the host machine in the \"Machine Name\" \
text box. Make sure your login in the \"Remote Login\" text box is correct.\n\
",
  StyleBox["6.",
    FontWeight->"Bold"],
  "  Click ",
  StyleBox["OK",
    FontFamily->"Helvetica"],
  " to save the kernel connection. The Kernel Properties dialog box  \
disappears and you are returned to the list of kernel connections. If you are \
done, click ",
  StyleBox["OK",
    FontFamily->"Helvetica"],
  " again."
}], "ItemizedText",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[TextData[{
  "To use the new kernel, go to the ",
  StyleBox["Kernel", "SR"],
  " menu and select the new kernel from either the ",
  StyleBox["Start Kernel", "SR"],
  ", ",
  StyleBox["Default Kernel", "SR"],
  ", or ",
  StyleBox["Notebook\[CloseCurlyQuote]s Kernel", "SR"],
  " submenu. "
}], "NotesList",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Remote Kernel Connections: Macintosh", "SubsectionIcon",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell["\<\
\[FilledSmallSquare] To establish a remote kernel connection, the kernel must \
be Version 5.0 or later. \
\>", "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell["\<\
\[FilledSmallSquare] To define a connection from a Macintosh front end to a \
kernel on a remote machine:\
\>", "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  Choose ",
  StyleBox["Kernel \[RightTriangle] Kernel Configuration Options",
    FontFamily->"Helvetica"],
  ". A dialog box appears.\n",
  StyleBox["2.",
    FontWeight->"Bold"],
  "  Click ",
  StyleBox["Add",
    FontFamily->"Helvetica"],
  ". The Kernel Configuration dialog box appears to let you define a new \
kernel connection.\n",
  StyleBox["3.",
    FontWeight->"Bold"],
  "  Type a name for the new connection in the \"Kernel Name\" text box.\n",
  StyleBox["4.",
    FontWeight->"Bold"],
  "  Click ",
  StyleBox["Remote Machine", "SR"],
  ". \n",
  StyleBox["5.",
    FontWeight->"Bold"],
  "  Enter the name or IP address of the host machine in the \"Remote \
Hostname\" text box.\n",
  StyleBox["6.  ",
    FontWeight->"Bold"],
  "Click ",
  StyleBox["OK",
    FontFamily->"Helvetica"],
  " to save the kernel connection. The Kernel Configuration dialog box \
disappears and you are returned to the list of kernel connections. If you are \
done, click ",
  StyleBox["OK",
    FontFamily->"Helvetica"],
  " again."
}], "ItemizedText",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "To use the new kernel, go to the ",
  StyleBox["Kernel", "SR"],
  " menu and select the new kernel from either the ",
  StyleBox["Start Kernel", "SR"],
  ", ",
  StyleBox["Default Kernel", "SR"],
  ", or ",
  StyleBox["Notebook\[CloseCurlyQuote]s Kernel", "SR"],
  " submenu. "
}], "NotesList",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Closed]],

Cell[CellGroupData[{

Cell["After Setting Up Remote Kernel Connections", "SubsectionIcon",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell["\<\
\[FilledSmallSquare] The kernel names that you have defined are shown \
throughout the front end whenever you have a choice of kernels.\
\>", "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],

Cell[TextData[{
  "\[FilledSmallSquare] When you choose ",
  StyleBox["Kernel \[RightTriangle] Kernel Configuration Options", "SR"],
  ", a dialog box lists the kernel connections already defined. \"Local\" is \
the default connection to MathKernel on your local machine."
}], "Notes",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell["\<\
\[FilledSmallSquare] When \"Append name to In/Out prompts\" is checked, the \
name of the kernel connection is appended to cell labels generated during \
that connection.\
\>", "Notes",
  AspectRatioFixed->True,
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Show In/Out Names", "Command",
  CellTags->"ShowCellLabel"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show In/Out Names", "SR"],
  " toggles the display of ",
  StyleBox["CellLabels", "MR"],
  "."
}], "Usage",
  CellTags->"ShowCellLabel"]
}, Closed]],

Cell[CellGroupData[{

Cell["Delete All Output", "Command",
  CellTags->"DeleteGeneratedCells"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Delete All Output", "SR"],
  " deletes all cells in the current notebook that have been produced as \
output by the kernel."
}], "Usage",
  CellTags->"DeleteGeneratedCells"]
}, Closed]],

Cell[CellGroupData[{

Cell["Edit List Dialog Box", "Command",
  CellTags->"propertiesDialogID"],

Cell["\<\
\[FilledSmallSquare] This dialog box is displayed when you need to edit a \
list of items to customize a property of the front end. \
\>", "Usage",
  CellTags->"propertiesDialogID"],

Cell["\<\
\[FilledSmallSquare] The Edit List dialog box is displayed, for example, when \
editing certain option settings in the Option Inspector.  \
\>", "Notes",
  CellTags->"propertiesDialogID"],

Cell["\<\
\[FilledSmallSquare] The dialog box displays a list of items and the \
following buttons. \
\>", "Notes",
  CellTags->"propertiesDialogID"],

Cell["Add", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Lets you add a new item to the list.", "IndentedText",
  CellTags->"propertiesDialogID"],

Cell["Remove", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Deletes an item from the list.", "IndentedText",
  CellTags->"propertiesDialogID"],

Cell["Edit ", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Lets you modify the selected item.", "IndentedText",
  CellTags->"propertiesDialogID"],

Cell["Cancel ", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Closes the dialog box without saving changes. ", "IndentedText",
  CellTags->"propertiesDialogID"],

Cell["OK                    ", "DialogItem",
  CellTags->"propertiesDialogID"],

Cell["Closes the dialog box after saving changes.", "IndentedText",
  CellTags->"propertiesDialogID"]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel Input Dialog Box", "Command",
  CellTags->"kernelInputDialogID"],

Cell[TextData[{
  "\[FilledSmallSquare] This dialog box is displayed when the kernel commands \
",
  StyleBox["Input[]",
    FontFamily->"Courier"],
  " or ",
  StyleBox["InputString[]",
    FontFamily->"Courier"],
  " are evaluated in a notebook."
}], "Usage",
  ShowCellBracket->False,
  CellTags->"kernelInputDialogID"],

Cell[TextData[{
  "\[FilledSmallSquare] Any text you type into the dialog box is sent to the \
kernel for evaluation, when you click ",
  StyleBox["OK",
    FontFamily->"Helvetica"],
  ". The result of the evaluation is returned as the value of the ",
  StyleBox["Input[]", "MR"],
  " or ",
  StyleBox["InputString[]", "MR"],
  "expression.\n\[FilledSmallSquare] This dialog box provides an alternative \
way to supply input to the kernel. This is useful, for example, in writing  \
programs that prompt the user for input. "
}], "Notes",
  ShowCellBracket->False,
  CellTags->"kernelInputDialogID"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["Input",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputString",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  ShowCellBracket->False,
  CellTags->"kernelInputDialogID"],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.20",
    ButtonData:>{"2.9.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text",
  ShowCellBracket->False,
  CellTags->"kernelInputDialogID"]
}, Closed]],

Cell[CellGroupData[{

Cell["Password Dialog Box", "Command",
  CellTags->{
  "Password Dialog Box", "hostilePasswordDialogID", "passwordDialogID"}],

Cell["\<\
\[FilledSmallSquare] This dialog box is displayed when you need to enter a \
password.\
\>", "Usage",
  ShowCellBracket->False,
  CellTags->{
  "Password Dialog Box", "hostilePasswordDialogID", "passwordDialogID"}]
}, Closed]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 658}},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{641, 551},
WindowMargins->{{Automatic, 186}, {Automatic, 32}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "EvaluateCells"->{
    Cell[1895, 61, 62, 1, 41, "Command",
      CellTags->"EvaluateCells"],
    Cell[1960, 64, 190, 5, 33, "Usage",
      CellTags->"EvaluateCells"],
    Cell[2153, 71, 783, 13, 139, "Notes",
      CellTags->"EvaluateCells"],
    Cell[2939, 86, 495, 15, 25, "Notes",
      CellTags->"EvaluateCells"],
    Cell[3437, 103, 181, 4, 25, "Notes",
      CellTags->"EvaluateCells"]},
  "Evaluate"->{
    Cell[3655, 112, 60, 1, 45, "Command",
      CellTags->"Evaluate"],
    Cell[3718, 115, 165, 5, 33, "Usage",
      CellTags->"Evaluate"],
    Cell[3886, 122, 589, 14, 88, "Notes",
      CellTags->"Evaluate"],
    Cell[4478, 138, 450, 12, 25, "Notes",
      CellTags->"Evaluate"]},
  "EvaluateNextCell"->{
    Cell[4965, 155, 70, 1, 45, "Command",
      CellTags->"EvaluateNextCell"],
    Cell[5038, 158, 191, 5, 33, "Usage",
      CellTags->"EvaluateNextCell"],
    Cell[5232, 165, 419, 7, 76, "Notes",
      CellTags->"EvaluateNextCell"],
    Cell[5654, 174, 284, 5, 42, "Notes",
      CellTags->"EvaluateNextCell"],
    Cell[5941, 181, 446, 13, 25, "Notes",
      CellTags->"EvaluateNextCell"]},
  "SubsessionEvaluateCells"->{
    Cell[6424, 199, 80, 1, 45, "Command",
      CellTags->"SubsessionEvaluateCells"],
    Cell[6507, 202, 192, 5, 33, "Usage",
      CellTags->"SubsessionEvaluateCells"],
    Cell[6702, 209, 477, 9, 62, "Notes",
      CellTags->"SubsessionEvaluateCells"],
    Cell[7182, 220, 185, 4, 25, "Notes",
      CellTags->"SubsessionEvaluateCells"],
    Cell[7370, 226, 177, 6, 25, "Notes",
      CellTags->"SubsessionEvaluateCells"]},
  "SubsessionEvaluateCell"->{
    Cell[7550, 234, 386, 13, 25, "Notes",
      CellTags->"SubsessionEvaluateCell"]},
  "EvaluateNotebook"->{
    Cell[7973, 252, 68, 1, 45, "Command",
      CellTags->"EvaluateNotebook"],
    Cell[8044, 255, 184, 5, 33, "Usage",
      CellTags->"EvaluateNotebook"],
    Cell[8231, 262, 211, 4, 42, "Notes",
      CellTags->"EvaluateNotebook"]},
  "EvaluateInitialization"->{
    Cell[8479, 271, 80, 1, 45, "Command",
      CellTags->"EvaluateInitialization"],
    Cell[8562, 274, 195, 5, 33, "Usage",
      CellTags->"EvaluateInitialization"],
    Cell[8760, 281, 368, 8, 59, "Notes",
      CellTags->"EvaluateInitialization"]},
  "EnterSubsession"->{
    Cell[9165, 294, 66, 1, 45, "Command",
      CellTags->"EnterSubsession"],
    Cell[9234, 297, 193, 5, 33, "Usage",
      CellTags->"EnterSubsession"],
    Cell[9430, 304, 169, 6, 25, "Notes",
      CellTags->"EnterSubsession"],
    Cell[9602, 312, 255, 10, 25, "Notes",
      CellTags->"EnterSubsession"]},
  "ExitSubsession"->{
    Cell[9894, 327, 64, 1, 45, "Command",
      CellTags->"ExitSubsession"],
    Cell[9961, 330, 161, 5, 33, "Usage",
      CellTags->"ExitSubsession"]},
  "RemoveFromEvaluationQueue"->{
    Cell[10159, 340, 88, 1, 45, "Command",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[10250, 343, 204, 5, 33, "Usage",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[10457, 350, 299, 6, 42, "Notes",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[10759, 358, 198, 4, 25, "Notes",
      CellTags->"RemoveFromEvaluationQueue"],
    Cell[10960, 364, 312, 10, 42, "Notes",
      CellTags->"RemoveFromEvaluationQueue"]},
  "EvaluatorInterrupt"->{
    Cell[11321, 380, 99, 1, 45, "Command",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[11423, 383, 229, 6, 33, "Usage",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[11655, 391, 445, 9, 59, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12103, 402, 422, 12, 25, "Notes",
      CellTags->"EvaluatorInterrupt"],
    Cell[12528, 416, 140, 2, 26, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12671, 420, 154, 3, 25, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12828, 425, 108, 1, 26, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12939, 428, 484, 12, 63, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13426, 442, 137, 2, 26, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13566, 446, 355, 10, 44, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13924, 458, 181, 6, 25, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14108, 466, 267, 10, 25, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14378, 478, 438, 7, 59, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14819, 487, 520, 12, 59, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[15342, 501, 499, 16, 42, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[15844, 519, 495, 14, 59, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}]},
  "kernelInterruptID"->{
    Cell[11321, 380, 99, 1, 45, "Command",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[11423, 383, 229, 6, 33, "Usage",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[11655, 391, 445, 9, 59, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12528, 416, 140, 2, 26, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12671, 420, 154, 3, 25, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12828, 425, 108, 1, 26, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[12939, 428, 484, 12, 63, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13426, 442, 137, 2, 26, "DialogItem",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13566, 446, 355, 10, 44, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[13924, 458, 181, 6, 25, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14108, 466, 267, 10, 25, "IndentedText",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14378, 478, 438, 7, 59, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[14819, 487, 520, 12, 59, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[15342, 501, 499, 16, 42, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
    Cell[15844, 519, 495, 14, 59, "Notes",
      CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}]},
  "EvaluatorAbort"->{
    Cell[16376, 538, 65, 1, 45, "Command",
      CellTags->"EvaluatorAbort"],
    Cell[16444, 541, 159, 5, 33, "Usage",
      CellTags->"EvaluatorAbort"],
    Cell[16606, 548, 170, 4, 25, "Notes",
      CellTags->"EvaluatorAbort"],
    Cell[16779, 554, 214, 7, 25, "Notes",
      CellTags->"EvaluatorAbort"],
    Cell[16996, 563, 418, 12, 25, "Notes",
      CellTags->"EvaluatorAbort"]},
  "MenuListStartEvaluators"->{
    Cell[17451, 580, 70, 1, 45, "Command",
      CellTags->"MenuListStartEvaluators"],
    Cell[17524, 583, 162, 5, 33, "Usage",
      CellTags->"MenuListStartEvaluators"],
    Cell[17689, 590, 306, 6, 42, "Notes",
      CellTags->"MenuListStartEvaluators"]},
  "MenuListQuitEvaluators"->{
    Cell[18032, 601, 68, 1, 45, "Command",
      CellTags->"MenuListQuitEvaluators"],
    Cell[18103, 604, 164, 5, 33, "Usage",
      CellTags->"MenuListQuitEvaluators"],
    Cell[18270, 611, 305, 6, 42, "Notes",
      CellTags->"MenuListQuitEvaluators"],
    Cell[18578, 619, 135, 3, 25, "Notes",
      CellTags->"MenuListQuitEvaluators"]},
  "MenuListGlobalEvaluators"->{
    Cell[19465, 654, 73, 1, 45, "Command",
      CellTags->"MenuListGlobalEvaluators"],
    Cell[19541, 657, 201, 5, 33, "Usage",
      CellTags->"MenuListGlobalEvaluators"]},
  "MenuListNotebookEvaluators"->{
    Cell[19779, 667, 95, 1, 45, "Command",
      CellTags->"MenuListNotebookEvaluators"],
    Cell[19877, 670, 199, 5, 33, "Usage",
      CellTags->"MenuListNotebookEvaluators"]},
  "ModifyEvaluatorNames"->{
    Cell[20113, 680, 114, 1, 45, "Command",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[20230, 683, 242, 6, 33, "Usage",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[20497, 693, 160, 2, 39, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[20660, 697, 194, 4, 25, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[20857, 703, 192, 4, 25, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21052, 709, 1235, 40, 160, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22290, 751, 377, 11, 44, "NotesList",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22704, 767, 152, 2, 29, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22859, 771, 194, 4, 25, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[23056, 777, 194, 4, 25, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[23253, 783, 1176, 38, 141, "ItemizedText",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[24432, 823, 377, 11, 44, "NotesList",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[24846, 839, 158, 2, 29, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[25007, 843, 224, 4, 42, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[25234, 849, 375, 7, 42, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[25612, 858, 285, 6, 42, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]},
  "kernelSettingsDialogID"->{
    Cell[20113, 680, 114, 1, 45, "Command",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[20230, 683, 242, 6, 33, "Usage",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[20497, 693, 160, 2, 39, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[20660, 697, 194, 4, 25, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[20857, 703, 192, 4, 25, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[21052, 709, 1235, 40, 160, "ItemizedText",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22290, 751, 377, 11, 44, "NotesList",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22704, 767, 152, 2, 29, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[22859, 771, 194, 4, 25, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[23056, 777, 194, 4, 25, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[23253, 783, 1176, 38, 141, "ItemizedText",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[24432, 823, 377, 11, 44, "NotesList",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[24846, 839, 158, 2, 29, "SubsectionIcon",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[25007, 843, 224, 4, 42, "Notes",
      CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
    Cell[25234, 849, 375, 7, 42, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
    Cell[25612, 858, 285, 6, 42, "Notes",
      CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]},
  "ShowCellLabel"->{
    Cell[25946, 870, 65, 1, 45, "Command",
      CellTags->"ShowCellLabel"],
    Cell[26014, 873, 191, 7, 33, "Usage",
      CellTags->"ShowCellLabel"]},
  "DeleteGeneratedCells"->{
    Cell[26242, 885, 72, 1, 45, "Command",
      CellTags->"DeleteGeneratedCells"],
    Cell[26317, 888, 228, 6, 33, "Usage",
      CellTags->"DeleteGeneratedCells"]},
  "propertiesDialogID"->{
    Cell[26582, 899, 73, 1, 45, "Command",
      CellTags->"propertiesDialogID"],
    Cell[26658, 902, 191, 4, 33, "Usage",
      CellTags->"propertiesDialogID"],
    Cell[26852, 908, 197, 4, 25, "Notes",
      CellTags->"propertiesDialogID"],
    Cell[27052, 914, 149, 4, 25, "Notes",
      CellTags->"propertiesDialogID"],
    Cell[27204, 920, 59, 1, 26, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[27266, 923, 94, 1, 25, "IndentedText",
      CellTags->"propertiesDialogID"],
    Cell[27363, 926, 62, 1, 26, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[27428, 929, 88, 1, 25, "IndentedText",
      CellTags->"propertiesDialogID"],
    Cell[27519, 932, 61, 1, 26, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[27583, 935, 92, 1, 25, "IndentedText",
      CellTags->"propertiesDialogID"],
    Cell[27678, 938, 63, 1, 26, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[27744, 941, 104, 1, 25, "IndentedText",
      CellTags->"propertiesDialogID"],
    Cell[27851, 944, 78, 1, 26, "DialogItem",
      CellTags->"propertiesDialogID"],
    Cell[27932, 947, 101, 1, 25, "IndentedText",
      CellTags->"propertiesDialogID"]},
  "kernelInputDialogID"->{
    Cell[28070, 953, 77, 1, 45, "Command",
      CellTags->"kernelInputDialogID"],
    Cell[28150, 956, 322, 11, 50, "Usage",
      CellTags->"kernelInputDialogID"],
    Cell[28475, 969, 599, 14, 82, "Notes",
      CellTags->"kernelInputDialogID"],
    Cell[29077, 985, 267, 10, 25, "Notes",
      CellTags->"kernelInputDialogID"],
    Cell[29347, 997, 286, 11, 25, "Text",
      CellTags->"kernelInputDialogID"]},
  "Password Dialog Box"->{
    Cell[29670, 1013, 125, 2, 45, "Command",
      CellTags->{
      "Password Dialog Box", "hostilePasswordDialogID", "passwordDialogID"}],
    Cell[29798, 1017, 224, 6, 33, "Usage",
      CellTags->{
      "Password Dialog Box", "hostilePasswordDialogID", 
        "passwordDialogID"}]},
  "hostilePasswordDialogID"->{
    Cell[29670, 1013, 125, 2, 45, "Command",
      CellTags->{
      "Password Dialog Box", "hostilePasswordDialogID", "passwordDialogID"}],
    Cell[29798, 1017, 224, 6, 33, "Usage",
      CellTags->{
      "Password Dialog Box", "hostilePasswordDialogID", 
        "passwordDialogID"}]},
  "passwordDialogID"->{
    Cell[29670, 1013, 125, 2, 45, "Command",
      CellTags->{
      "Password Dialog Box", "hostilePasswordDialogID", "passwordDialogID"}],
    Cell[29798, 1017, 224, 6, 33, "Usage",
      CellTags->{
      "Password Dialog Box", "hostilePasswordDialogID", "passwordDialogID"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"EvaluateCells", 30806, 1047},
  {"Evaluate", 31198, 1058},
  {"EvaluateNextCell", 31506, 1067},
  {"SubsessionEvaluateCells", 31930, 1078},
  {"SubsessionEvaluateCell", 32387, 1089},
  {"EvaluateNotebook", 32497, 1092},
  {"EvaluateInitialization", 32763, 1099},
  {"EnterSubsession", 33040, 1106},
  {"ExitSubsession", 33373, 1115},
  {"RemoveFromEvaluationQueue", 33560, 1120},
  {"EvaluatorInterrupt", 34029, 1131},
  {"kernelInterruptID", 35754, 1164},
  {"EvaluatorAbort", 37394, 1195},
  {"MenuListStartEvaluators", 37813, 1206},
  {"MenuListQuitEvaluators", 38103, 1213},
  {"MenuListGlobalEvaluators", 38477, 1222},
  {"MenuListNotebookEvaluators", 38687, 1227},
  {"ModifyEvaluatorNames", 38895, 1232},
  {"kernelSettingsDialogID", 40761, 1265},
  {"ShowCellLabel", 42618, 1298},
  {"DeleteGeneratedCells", 42800, 1303},
  {"propertiesDialogID", 42994, 1308},
  {"kernelInputDialogID", 44209, 1337},
  {"Password Dialog Box", 44651, 1348},
  {"hostilePasswordDialogID", 44972, 1356},
  {"passwordDialogID", 45286, 1364}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 94, 4, 65, "Section"],

Cell[CellGroupData[{
Cell[1895, 61, 62, 1, 41, "Command",
  CellTags->"EvaluateCells"],
Cell[1960, 64, 190, 5, 33, "Usage",
  CellTags->"EvaluateCells"],
Cell[2153, 71, 783, 13, 139, "Notes",
  CellTags->"EvaluateCells"],
Cell[2939, 86, 495, 15, 25, "Notes",
  CellTags->"EvaluateCells"],
Cell[3437, 103, 181, 4, 25, "Notes",
  CellTags->"EvaluateCells"]
}, Closed]],

Cell[CellGroupData[{
Cell[3655, 112, 60, 1, 45, "Command",
  CellTags->"Evaluate"],
Cell[3718, 115, 165, 5, 33, "Usage",
  CellTags->"Evaluate"],
Cell[3886, 122, 589, 14, 88, "Notes",
  CellTags->"Evaluate"],
Cell[4478, 138, 450, 12, 25, "Notes",
  CellTags->"Evaluate"]
}, Closed]],

Cell[CellGroupData[{
Cell[4965, 155, 70, 1, 45, "Command",
  CellTags->"EvaluateNextCell"],
Cell[5038, 158, 191, 5, 33, "Usage",
  CellTags->"EvaluateNextCell"],
Cell[5232, 165, 419, 7, 76, "Notes",
  CellTags->"EvaluateNextCell"],
Cell[5654, 174, 284, 5, 42, "Notes",
  CellTags->"EvaluateNextCell"],
Cell[5941, 181, 446, 13, 25, "Notes",
  CellTags->"EvaluateNextCell"]
}, Closed]],

Cell[CellGroupData[{
Cell[6424, 199, 80, 1, 45, "Command",
  CellTags->"SubsessionEvaluateCells"],
Cell[6507, 202, 192, 5, 33, "Usage",
  CellTags->"SubsessionEvaluateCells"],
Cell[6702, 209, 477, 9, 62, "Notes",
  CellTags->"SubsessionEvaluateCells"],
Cell[7182, 220, 185, 4, 25, "Notes",
  CellTags->"SubsessionEvaluateCells"],
Cell[7370, 226, 177, 6, 25, "Notes",
  CellTags->"SubsessionEvaluateCells"],
Cell[7550, 234, 386, 13, 25, "Notes",
  CellTags->"SubsessionEvaluateCell"]
}, Closed]],

Cell[CellGroupData[{
Cell[7973, 252, 68, 1, 45, "Command",
  CellTags->"EvaluateNotebook"],
Cell[8044, 255, 184, 5, 33, "Usage",
  CellTags->"EvaluateNotebook"],
Cell[8231, 262, 211, 4, 42, "Notes",
  CellTags->"EvaluateNotebook"]
}, Closed]],

Cell[CellGroupData[{
Cell[8479, 271, 80, 1, 45, "Command",
  CellTags->"EvaluateInitialization"],
Cell[8562, 274, 195, 5, 33, "Usage",
  CellTags->"EvaluateInitialization"],
Cell[8760, 281, 368, 8, 59, "Notes",
  CellTags->"EvaluateInitialization"]
}, Closed]],

Cell[CellGroupData[{
Cell[9165, 294, 66, 1, 45, "Command",
  CellTags->"EnterSubsession"],
Cell[9234, 297, 193, 5, 33, "Usage",
  CellTags->"EnterSubsession"],
Cell[9430, 304, 169, 6, 25, "Notes",
  CellTags->"EnterSubsession"],
Cell[9602, 312, 255, 10, 25, "Notes",
  CellTags->"EnterSubsession"]
}, Closed]],

Cell[CellGroupData[{
Cell[9894, 327, 64, 1, 45, "Command",
  CellTags->"ExitSubsession"],
Cell[9961, 330, 161, 5, 33, "Usage",
  CellTags->"ExitSubsession"]
}, Closed]],

Cell[CellGroupData[{
Cell[10159, 340, 88, 1, 45, "Command",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[10250, 343, 204, 5, 33, "Usage",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[10457, 350, 299, 6, 42, "Notes",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[10759, 358, 198, 4, 25, "Notes",
  CellTags->"RemoveFromEvaluationQueue"],
Cell[10960, 364, 312, 10, 42, "Notes",
  CellTags->"RemoveFromEvaluationQueue"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11321, 380, 99, 1, 45, "Command",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[11423, 383, 229, 6, 33, "Usage",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[11655, 391, 445, 9, 59, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[12103, 402, 422, 12, 25, "Notes",
  CellTags->"EvaluatorInterrupt"],
Cell[12528, 416, 140, 2, 26, "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[12671, 420, 154, 3, 25, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[12828, 425, 108, 1, 26, "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[12939, 428, 484, 12, 63, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[13426, 442, 137, 2, 26, "DialogItem",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[13566, 446, 355, 10, 44, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[13924, 458, 181, 6, 25, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[14108, 466, 267, 10, 25, "IndentedText",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[14378, 478, 438, 7, 59, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[14819, 487, 520, 12, 59, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[15342, 501, 499, 16, 42, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}],
Cell[15844, 519, 495, 14, 59, "Notes",
  CellTags->{"EvaluatorInterrupt", "kernelInterruptID"}]
}, Closed]],

Cell[CellGroupData[{
Cell[16376, 538, 65, 1, 45, "Command",
  CellTags->"EvaluatorAbort"],
Cell[16444, 541, 159, 5, 33, "Usage",
  CellTags->"EvaluatorAbort"],
Cell[16606, 548, 170, 4, 25, "Notes",
  CellTags->"EvaluatorAbort"],
Cell[16779, 554, 214, 7, 25, "Notes",
  CellTags->"EvaluatorAbort"],
Cell[16996, 563, 418, 12, 25, "Notes",
  CellTags->"EvaluatorAbort"]
}, Closed]],

Cell[CellGroupData[{
Cell[17451, 580, 70, 1, 45, "Command",
  CellTags->"MenuListStartEvaluators"],
Cell[17524, 583, 162, 5, 33, "Usage",
  CellTags->"MenuListStartEvaluators"],
Cell[17689, 590, 306, 6, 42, "Notes",
  CellTags->"MenuListStartEvaluators"]
}, Closed]],

Cell[CellGroupData[{
Cell[18032, 601, 68, 1, 45, "Command",
  CellTags->"MenuListQuitEvaluators"],
Cell[18103, 604, 164, 5, 33, "Usage",
  CellTags->"MenuListQuitEvaluators"],
Cell[18270, 611, 305, 6, 42, "Notes",
  CellTags->"MenuListQuitEvaluators"],
Cell[18578, 619, 135, 3, 25, "Notes",
  CellTags->"MenuListQuitEvaluators"]
}, Closed]],

Cell[CellGroupData[{
Cell[18750, 627, 116, 2, 45, "Command"],
Cell[18869, 631, 155, 3, 33, "Usage"]
}, Closed]],

Cell[CellGroupData[{
Cell[19061, 639, 117, 2, 45, "Command"],
Cell[19181, 643, 247, 6, 50, "Usage"]
}, Closed]],

Cell[CellGroupData[{
Cell[19465, 654, 73, 1, 45, "Command",
  CellTags->"MenuListGlobalEvaluators"],
Cell[19541, 657, 201, 5, 33, "Usage",
  CellTags->"MenuListGlobalEvaluators"]
}, Closed]],

Cell[CellGroupData[{
Cell[19779, 667, 95, 1, 45, "Command",
  CellTags->"MenuListNotebookEvaluators"],
Cell[19877, 670, 199, 5, 33, "Usage",
  CellTags->"MenuListNotebookEvaluators"]
}, Closed]],

Cell[CellGroupData[{
Cell[20113, 680, 114, 1, 45, "Command",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[20230, 683, 242, 6, 33, "Usage",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],

Cell[CellGroupData[{
Cell[20497, 693, 160, 2, 39, "SubsectionIcon",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[20660, 697, 194, 4, 25, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[20857, 703, 192, 4, 25, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[21052, 709, 1235, 40, 160, "ItemizedText",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[22290, 751, 377, 11, 44, "NotesList",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Closed]],

Cell[CellGroupData[{
Cell[22704, 767, 152, 2, 29, "SubsectionIcon",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[22859, 771, 194, 4, 25, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[23056, 777, 194, 4, 25, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[23253, 783, 1176, 38, 141, "ItemizedText",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[24432, 823, 377, 11, 44, "NotesList",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Closed]],

Cell[CellGroupData[{
Cell[24846, 839, 158, 2, 29, "SubsectionIcon",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[25007, 843, 224, 4, 42, "Notes",
  CellTags->{"kernelSettingsDialogID", "ModifyEvaluatorNames"}],
Cell[25234, 849, 375, 7, 42, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}],
Cell[25612, 858, 285, 6, 42, "Notes",
  CellTags->{"ModifyEvaluatorNames", "kernelSettingsDialogID"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[25946, 870, 65, 1, 45, "Command",
  CellTags->"ShowCellLabel"],
Cell[26014, 873, 191, 7, 33, "Usage",
  CellTags->"ShowCellLabel"]
}, Closed]],

Cell[CellGroupData[{
Cell[26242, 885, 72, 1, 45, "Command",
  CellTags->"DeleteGeneratedCells"],
Cell[26317, 888, 228, 6, 33, "Usage",
  CellTags->"DeleteGeneratedCells"]
}, Closed]],

Cell[CellGroupData[{
Cell[26582, 899, 73, 1, 45, "Command",
  CellTags->"propertiesDialogID"],
Cell[26658, 902, 191, 4, 33, "Usage",
  CellTags->"propertiesDialogID"],
Cell[26852, 908, 197, 4, 25, "Notes",
  CellTags->"propertiesDialogID"],
Cell[27052, 914, 149, 4, 25, "Notes",
  CellTags->"propertiesDialogID"],
Cell[27204, 920, 59, 1, 26, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[27266, 923, 94, 1, 25, "IndentedText",
  CellTags->"propertiesDialogID"],
Cell[27363, 926, 62, 1, 26, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[27428, 929, 88, 1, 25, "IndentedText",
  CellTags->"propertiesDialogID"],
Cell[27519, 932, 61, 1, 26, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[27583, 935, 92, 1, 25, "IndentedText",
  CellTags->"propertiesDialogID"],
Cell[27678, 938, 63, 1, 26, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[27744, 941, 104, 1, 25, "IndentedText",
  CellTags->"propertiesDialogID"],
Cell[27851, 944, 78, 1, 26, "DialogItem",
  CellTags->"propertiesDialogID"],
Cell[27932, 947, 101, 1, 25, "IndentedText",
  CellTags->"propertiesDialogID"]
}, Closed]],

Cell[CellGroupData[{
Cell[28070, 953, 77, 1, 45, "Command",
  CellTags->"kernelInputDialogID"],
Cell[28150, 956, 322, 11, 50, "Usage",
  CellTags->"kernelInputDialogID"],
Cell[28475, 969, 599, 14, 82, "Notes",
  CellTags->"kernelInputDialogID"],
Cell[29077, 985, 267, 10, 25, "Notes",
  CellTags->"kernelInputDialogID"],
Cell[29347, 997, 286, 11, 25, "Text",
  CellTags->"kernelInputDialogID"]
}, Closed]],

Cell[CellGroupData[{
Cell[29670, 1013, 125, 2, 45, "Command",
  CellTags->{
  "Password Dialog Box", "hostilePasswordDialogID", "passwordDialogID"}],
Cell[29798, 1017, 224, 6, 33, "Usage",
  CellTags->{
  "Password Dialog Box", "hostilePasswordDialogID", "passwordDialogID"}]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

