(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     63292,       1847]*)
(*NotebookOutlinePosition[     71829,       2077]*)
(*  CellTagsIndexPosition[     71264,       2054]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Macintosh Keyboard Shortcuts", "Title"],

Cell[CellGroupData[{

Cell["Mathematica Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"file", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              RowBox[{
                StyleBox["Hide",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain"], 
                StyleBox["Others",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain",
                  FontSlant->"Plain"]}], 
              StyleBox[
                RowBox[{
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]h\[RightModified]"}]]},
            {
              RowBox[{
                StyleBox["Hide",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["Mathematica",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontSlant->"Plain"]}], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]", 
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]h\[RightModified]"}]]},
            {
              RowBox[{
                StyleBox["Quit",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain"], 
                StyleBox["Mathematica",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain",
                  FontSlant->"Plain"]}], 
              StyleBox[
                RowBox[{
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]q\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"file", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["File Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"file", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["New",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]n\[RightModified]"}]]},
            {
              StyleBox["Open",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]o\[RightModified]"}]]},
            {
              StyleBox["Close",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]w\[RightModified]"}]]},
            {
              StyleBox["Save",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]s\[RightModified]"}]]},
            {
              StyleBox[\(Save\ As\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]", 
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]s\[RightModified]"}]]},
            {
              StyleBox["Print",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]p\[RightModified]"}]]},
            {
              StyleBox[
                RowBox[{
                  StyleBox["Print",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontFamily->"Helvetica",
                    FontSize->11,
                    FontWeight->"Plain"], 
                  StyleBox["Selection",
                    FontSize->10]}],
                FontFamily->"Helvetica",
                FontSize->10], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]", 
                  StyleBox["\[CommandKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], 
                  "\[LeftModified]p\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"file", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Edit Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"edit", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Undo",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]z\[RightModified]"},
            {
              StyleBox["Cut",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]x\[RightModified]"},
            {
              StyleBox["Copy",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]c\[RightModified]"},
            {
              StyleBox["Paste",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]v\[RightModified]"},
            {
              StyleBox["Clear",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]X\
\[RightModified]"},
            {
              StyleBox[\(Select\ All\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]a\[RightModified]"},
            {
              StyleBox[\(Make\ \(2  D\)\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]Y\
\[RightModified]"},
            {
              StyleBox[\(Check\ Balance\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]B\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"edit", "all"}],

Cell[CellGroupData[{

Cell["Motion Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editmotion", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]f\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]b\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]d\[RightModified]",
                      FontSize->12]}]], 
                StyleBox[" ",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]h\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontSize->12], " "}]]}],
                FontSize->12]},
            {
              StyleBox[\(Move\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              
              StyleBox[\(\[OptionKey]\[LeftModified] \[ShortRightArrow] \
\[RightModified]\),
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              
              StyleBox[\(\[OptionKey]\[LeftModified] \[ShortLeftArrow] \
\[RightModified]\),
                FontSize->12]},
            {
              StyleBox[\(Delete\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ShiftKey]\[KeyBar]",
                      FontSize->12], 
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]W\[RightModified]",
                      FontSize->12]}]], 
                StyleBox[" ",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    FontFamily->"Helvetica",
                    FontSize->12,
                    FontWeight->"Plain"], 
                  StyleBox["\[LeftModified]w\[RightModified]",
                    FontSize->12]}]]},
            {
              StyleBox[\(Move\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]e\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[CommandKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]a\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[CommandKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Next\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]n\[RightModified]",
                      FontSize->12]}]], 
                StyleBox["  ",
                  FontSize->12], 
                RowBox[{
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[DownArrow]",
                    FontSize->12]}]}]},
            {
              StyleBox[\(Move\ Previous\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]p\[RightModified]",
                      FontSize->12]}]], 
                StyleBox["  ",
                  FontSize->12], 
                RowBox[{
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[UpArrow]",
                    FontSize->12]}]}]}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, True, False, False, False, True, 
              False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"editmotion", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Scrolling Commands", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"nonmenu", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Scroll\ Page\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["PageUp",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"]},
            {
              StyleBox[\(Scroll\ Page\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["PageDown",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"]},
            {
              StyleBox[\(Scroll\ Notebook\ Start\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["Home",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"]},
            {
              StyleBox[\(Scroll\ Notebook\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["End",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->{{1, 1}, {2, 2}}],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"nonmenu", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Expression Input Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editexpression", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Superscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["^",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], "\[RightModified]"}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]6\[RightModified]"}]},
            {
              StyleBox["Subscript",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] - \[RightModified]\
\)},
            {
              StyleBox["Above",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox["Below",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", "+", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], "\[ControlKey]\[LeftModified]"}]}], "=", 
                "\[RightModified]"}]},
            {
              StyleBox[\(Opposite\ Position\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "%", "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]5\[RightModified]"}]},
            {
              StyleBox["Fraction",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[ControlKey]\[LeftModified]/\[RightModified]\)},
            {
              StyleBox["Radical",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{\(\[ControlKey]\[LeftModified]@\[RightModified]\), 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  "\[ControlKey]\[LeftModified]2\[RightModified]"}], " "}]},
            {
              StyleBox[\(Add\ Row\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]\[ReturnKey]\[RightModified]"},
            {
              StyleBox[\(Add\ Column\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified], \
\[RightModified]\)},
            {
              StyleBox[\(End\ Subexpression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]\[SpaceKey]\[RightModified]"},
            {
              StyleBox[\(Extend\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\(\[ControlKey]\[LeftModified] . \
\[RightModified]\)\(\ \)\)},
            {
              StyleBox[\(Start\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ControlKey]\[LeftModified]", 
                RowBox[{"(", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox[
                      RowBox[{"\[ControlKey]\[LeftModified]", 
                        StyleBox["9",
                          FontFamily->"Helvetica",
                          FontWeight->"Plain"], "\[RightModified]"}]]}]}]}]},
            {
              StyleBox[\(End\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              
              RowBox[{\(\(\[ControlKey]\[LeftModified]\)\()\)\), 
                "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["0",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Insert\ Raw\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "*", "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["8",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Nudge\ Left\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] \[ShortLeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Right\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] \[ShortRightArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified]\[DownArrow]\
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified]\[UpArrow]\
\[RightModified]\)}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, False, True, False, True, False, True, 
              False, True, False, False, True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"editexpression", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Expression Editing Commands", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"nonmenu", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Placeholder\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[TabKey]",
                FontFamily->"Helvetica",
                FontWeight->"Plain"]},
            {
              StyleBox[\(Move\ Previous\ Placeholder\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]", 
                  StyleBox["\[TabKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"]}]]},
            {
              StyleBox[\(Move\ Next\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[KeyBar]\[ControlKey]\
\[LeftModified]S\[RightModified]"},
            {
              StyleBox[\(Delete\ Next\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]S\
\[RightModified]"},
            {
              StyleBox[\(Delete\ Previous\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]s\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->{{1, 1}, {2, 2}}],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"nonmenu", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Commands for Selecting Text", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"nonmenu", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Select\ Next\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ShiftKey]\[KeyBar]\[LeftModified] \
\[ShortRightArrow] \[RightModified]\)},
            {
              StyleBox[\(Select\ Previous\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ShiftKey]\[KeyBar]\[LeftModified] \
\[ShortLeftArrow] \[RightModified]\)},
            {
              StyleBox[\(Select\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[OptionKey]\[KeyBar]\[ShiftKey]\[LeftModified] \
\[ShortRightArrow] \[RightModified]\)},
            {
              StyleBox[\(Select\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[OptionKey]\[KeyBar]\[ShiftKey]\[LeftModified] \
\[ShortLeftArrow] \[RightModified]\)},
            {
              StyleBox[\(Select\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[CommandKey]\[KeyBar]\[ShiftKey]\[LeftModified] \[ShortRightArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Select\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[CommandKey]\[KeyBar]\[ShiftKey]\[LeftModified] \[ShortLeftArrow] \
\[RightModified]\)}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->{{1, 1}, {2, 2}}],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"nonmenu", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"cell", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Divide\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]D\
\[RightModified]"},
            {
              StyleBox[\(Merge\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]M\
\[RightModified]"},
            {
              StyleBox[\(Animate\ Selected\ Graphics\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]y\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"cell", "all"}],

Cell[CellGroupData[{

Cell["Convert To Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"cellconvert", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["InputForm",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", 
                  StyleBox["I",
                    "2ColumnSmallBox"], "\[RightModified]"}]]},
            {
              StyleBox["StandardForm",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]N\
\[RightModified]"},
            {
              StyleBox["TraditionalForm",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", 
                  StyleBox["T",
                    "2ColumnSmallBox"], "\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"cellconvert", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Grouping Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"cellgrouping", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Group\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]G\
\[RightModified]"},
            {
              StyleBox[\(Ungroup\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]U\
\[RightModified]"},
            {
              StyleBox[\(Open\ All\ Subgroups\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified] {\[RightModified]\)},
            {
              StyleBox[\(Close\ All\ Subgroups\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\(\(\[ShiftKey]\[KeyBar]\[CommandKey]\
\[LeftModified]\)\(}\)\) \[RightModified]\)},
            {
              StyleBox[\(Open/Close\ Group\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[CommandKey]\[LeftModified]' \
\[RightModified]\)}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"cellgrouping", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Format Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"format", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Show\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]E\
\[RightModified]"},
            {
              StyleBox[\(Option\ Inspector\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", 
                  StyleBox["O",
                    "2ColumnSmallBox"], "\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"format", "all"}],

Cell[CellGroupData[{

Cell["Style Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"formatstyle", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Title",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]1\[RightModified]"},
            {
              StyleBox["Subtitle",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]2\[RightModified]"},
            {
              StyleBox["Subsubtitle",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]3\[RightModified]"},
            {
              StyleBox["Section",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]4\[RightModified]"},
            {
              StyleBox["Subsection",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]5\[RightModified]"},
            {
              StyleBox["Subsubsection",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]6\[RightModified]"},
            {
              StyleBox[\(\(Text\)\(\ \)\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox[\(Small\ Text\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]8\[RightModified]"},
            {
              StyleBox["Input",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]9\[RightModified]"},
            {
              StyleBox["Other",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]0\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"formatstyle", "all"}],

Cell["\<\
\[FilledSmallSquare] Note that these keyboard shortcuts may \
correspond to different cell styles than what is given here. The menu's list \
of styles is based on definitions in the current style sheet.\
\>", "Notes",
  CellTags->{"formatstyle", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Face Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"formatface", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Bold",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[CommandKey]\[LeftModified]", 
                  StyleBox["b",
                    "2ColumnSmallBox"], "\[RightModified]"}]]},
            {
              StyleBox["Italic",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[CommandKey]\[LeftModified]", 
                  StyleBox["i",
                    "2ColumnSmallBox"], "\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"formatface", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Size Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"formatsize", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Smaller",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[CommandKey]\[LeftModified] - \[RightModified]\
\)},
            {
              StyleBox["Larger",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[CommandKey]\[LeftModified] = \[RightModified]\
\)}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"formatsize", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"input", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(3  D\ ViewPoint\ Selector\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]V\
\[RightModified]"},
            {
              StyleBox[\(Create\ \(Table/Matrix\)/Palette\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]C\
\[RightModified]"},
            {
              StyleBox[\(Copy\ Input\ from\ Above\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]l\[RightModified]"},
            {
              StyleBox[\(Copy\ Output\ from\ Above\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]L\
\[RightModified]"},
            {
              StyleBox[\(Start\ New\ Cell\ Below\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[OptionKey]\[KeyBar]\[ReturnKey]"},
            {
              StyleBox[\(Complete\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]k\[RightModified]"},
            {
              StyleBox[\(Make\ Template\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]K\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"input", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"kernel", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Interrupt\ Evaluation\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[CommandKey]\[LeftModified], \
\[RightModified]\)},
            {
              StyleBox[\(Abort\ Evaluation\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[CommandKey]\[LeftModified] . \[RightModified]\
\)}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"kernel", "all"}],

Cell[CellGroupData[{

Cell["Evaluation Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"kernelevaluation", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Evaluate\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ShiftKey]\[KeyBar]\[ReturnKey]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], "\[EnterKey]"}]},
            {
              StyleBox[\(Evaluate\ in\ Place\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[CommandKey]\[KeyBar]\[ReturnKey]"},
            {
              StyleBox[\(Evaluate\ Next\ Input\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[ShiftKey]\[KeyBar]\[EnterKey]"},
            {
              StyleBox[\(Evaluate\ in\ Subsession\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[OptionKey]\[KeyBar]\[ReturnKey]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"kernelevaluation", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Find Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"find", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Find",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]f\[RightModified]"},
            {
              StyleBox[\(Enter\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]e\[RightModified]"},
            {
              StyleBox[\(Find\ Next\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]g\[RightModified]"},
            {
              StyleBox["Replace",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]r\[RightModified]"},
            {
              StyleBox[\(Replace\ and\ Find\ Again\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]R\
\[RightModified]"},
            {
              StyleBox[\(Add/Remove\ Cell\ Tags\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[CommandKey]\[LeftModified]j\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"find", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Help Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"help", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Find\ Selected\ Function\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]F\
\[RightModified]"},
            {
              StyleBox[\(Why\ the\ \(\(Beep\)\(?\)\)\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]H\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"all", "help"}]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1148}, {0, 848}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->{},
WindowSize->{536, 551},
WindowMargins->{{6, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "file"->{
    Cell[1846, 57, 104, 2, 36, "Subsection",
      CellTags->{"file", "all"}],
    Cell[1953, 61, 3064, 85, 89, "Text",
      CellTags->{"file", "all"}],
    Cell[5054, 151, 97, 2, 36, "Subsection",
      CellTags->{"file", "all"}],
    Cell[5154, 155, 4044, 112, 161, "Text",
      CellTags->{"file", "all"}]},
  "all"->{
    Cell[1846, 57, 104, 2, 36, "Subsection",
      CellTags->{"file", "all"}],
    Cell[1953, 61, 3064, 85, 89, "Text",
      CellTags->{"file", "all"}],
    Cell[5054, 151, 97, 2, 36, "Subsection",
      CellTags->{"file", "all"}],
    Cell[5154, 155, 4044, 112, 161, "Text",
      CellTags->{"file", "all"}],
    Cell[9235, 272, 97, 2, 36, "Subsection",
      CellTags->{"edit", "all"}],
    Cell[9335, 276, 2713, 76, 179, "Text",
      CellTags->{"edit", "all"}],
    Cell[12073, 356, 111, 2, 34, "Subsubsection",
      CellTags->{"editmotion", "all"}],
    Cell[12187, 360, 9841, 265, 253, "Text",
      CellTags->{"editmotion", "all"}],
    Cell[22065, 630, 112, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[22180, 634, 2135, 61, 111, "Text",
      CellTags->{"nonmenu", "all"}],
    Cell[24352, 700, 125, 2, 34, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[24480, 704, 8615, 233, 365, "Text",
      CellTags->{"editexpression", "all"}],
    Cell[33132, 942, 127, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[33262, 946, 2343, 63, 133, "Text",
      CellTags->{"nonmenu", "all"}],
    Cell[35642, 1014, 121, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[35766, 1018, 2643, 75, 155, "Text",
      CellTags->{"nonmenu", "all"}],
    Cell[38458, 1099, 97, 2, 36, "Subsection",
      CellTags->{"cell", "all"}],
    Cell[38558, 1103, 1607, 45, 89, "Text",
      CellTags->{"cell", "all"}],
    Cell[40190, 1152, 116, 2, 24, "Subsubsection",
      CellTags->{"cellconvert", "all"}],
    Cell[40309, 1156, 1837, 50, 89, "Text",
      CellTags->{"cellconvert", "all"}],
    Cell[42183, 1211, 120, 2, 20, "Subsubsection",
      CellTags->{"cellgrouping", "all"}],
    Cell[42306, 1215, 2212, 63, 125, "Text",
      CellTags->{"cellgrouping", "all"}],
    Cell[44567, 1284, 101, 2, 36, "Subsection",
      CellTags->{"format", "all"}],
    Cell[44671, 1288, 1485, 41, 71, "Text",
      CellTags->{"format", "all"}],
    Cell[46181, 1333, 111, 2, 20, "Subsubsection",
      CellTags->{"formatstyle", "all"}],
    Cell[46295, 1337, 3111, 85, 215, "Text",
      CellTags->{"formatstyle", "all"}],
    Cell[49409, 1424, 263, 5, 40, "Notes",
      CellTags->{"formatstyle", "all"}],
    Cell[49709, 1434, 109, 2, 20, "Subsubsection",
      CellTags->{"formatface", "all"}],
    Cell[49821, 1438, 1533, 43, 71, "Text",
      CellTags->{"formatface", "all"}],
    Cell[51391, 1486, 109, 2, 20, "Subsubsection",
      CellTags->{"formatsize", "all"}],
    Cell[51503, 1490, 1364, 41, 71, "Text",
      CellTags->{"formatsize", "all"}],
    Cell[52916, 1537, 99, 2, 36, "Subsection",
      CellTags->{"input", "all"}],
    Cell[53018, 1541, 2604, 70, 159, "Text",
      CellTags->{"input", "all"}],
    Cell[55659, 1616, 101, 2, 36, "Subsection",
      CellTags->{"kernel", "all"}],
    Cell[55763, 1620, 1388, 41, 71, "Text",
      CellTags->{"kernel", "all"}],
    Cell[57176, 1665, 121, 2, 24, "Subsubsection",
      CellTags->{"kernelevaluation", "all"}],
    Cell[57300, 1669, 2023, 54, 99, "Text",
      CellTags->{"kernelevaluation", "all"}],
    Cell[59372, 1729, 97, 2, 36, "Subsection",
      CellTags->{"find", "all"}],
    Cell[59472, 1733, 2265, 62, 143, "Text",
      CellTags->{"find", "all"}],
    Cell[61774, 1800, 97, 2, 36, "Subsection",
      CellTags->{"help", "all"}],
    Cell[61874, 1804, 1390, 39, 71, "Text",
      CellTags->{"all", "help"}]},
  "edit"->{
    Cell[9235, 272, 97, 2, 36, "Subsection",
      CellTags->{"edit", "all"}],
    Cell[9335, 276, 2713, 76, 179, "Text",
      CellTags->{"edit", "all"}]},
  "editmotion"->{
    Cell[12073, 356, 111, 2, 34, "Subsubsection",
      CellTags->{"editmotion", "all"}],
    Cell[12187, 360, 9841, 265, 253, "Text",
      CellTags->{"editmotion", "all"}]},
  "nonmenu"->{
    Cell[22065, 630, 112, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[22180, 634, 2135, 61, 111, "Text",
      CellTags->{"nonmenu", "all"}],
    Cell[33132, 942, 127, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[33262, 946, 2343, 63, 133, "Text",
      CellTags->{"nonmenu", "all"}],
    Cell[35642, 1014, 121, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[35766, 1018, 2643, 75, 155, "Text",
      CellTags->{"nonmenu", "all"}]},
  "editexpression"->{
    Cell[24352, 700, 125, 2, 34, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[24480, 704, 8615, 233, 365, "Text",
      CellTags->{"editexpression", "all"}]},
  "cell"->{
    Cell[38458, 1099, 97, 2, 36, "Subsection",
      CellTags->{"cell", "all"}],
    Cell[38558, 1103, 1607, 45, 89, "Text",
      CellTags->{"cell", "all"}]},
  "cellconvert"->{
    Cell[40190, 1152, 116, 2, 24, "Subsubsection",
      CellTags->{"cellconvert", "all"}],
    Cell[40309, 1156, 1837, 50, 89, "Text",
      CellTags->{"cellconvert", "all"}]},
  "cellgrouping"->{
    Cell[42183, 1211, 120, 2, 20, "Subsubsection",
      CellTags->{"cellgrouping", "all"}],
    Cell[42306, 1215, 2212, 63, 125, "Text",
      CellTags->{"cellgrouping", "all"}]},
  "format"->{
    Cell[44567, 1284, 101, 2, 36, "Subsection",
      CellTags->{"format", "all"}],
    Cell[44671, 1288, 1485, 41, 71, "Text",
      CellTags->{"format", "all"}]},
  "formatstyle"->{
    Cell[46181, 1333, 111, 2, 20, "Subsubsection",
      CellTags->{"formatstyle", "all"}],
    Cell[46295, 1337, 3111, 85, 215, "Text",
      CellTags->{"formatstyle", "all"}],
    Cell[49409, 1424, 263, 5, 40, "Notes",
      CellTags->{"formatstyle", "all"}]},
  "formatface"->{
    Cell[49709, 1434, 109, 2, 20, "Subsubsection",
      CellTags->{"formatface", "all"}],
    Cell[49821, 1438, 1533, 43, 71, "Text",
      CellTags->{"formatface", "all"}]},
  "formatsize"->{
    Cell[51391, 1486, 109, 2, 20, "Subsubsection",
      CellTags->{"formatsize", "all"}],
    Cell[51503, 1490, 1364, 41, 71, "Text",
      CellTags->{"formatsize", "all"}]},
  "input"->{
    Cell[52916, 1537, 99, 2, 36, "Subsection",
      CellTags->{"input", "all"}],
    Cell[53018, 1541, 2604, 70, 159, "Text",
      CellTags->{"input", "all"}]},
  "kernel"->{
    Cell[55659, 1616, 101, 2, 36, "Subsection",
      CellTags->{"kernel", "all"}],
    Cell[55763, 1620, 1388, 41, 71, "Text",
      CellTags->{"kernel", "all"}]},
  "kernelevaluation"->{
    Cell[57176, 1665, 121, 2, 24, "Subsubsection",
      CellTags->{"kernelevaluation", "all"}],
    Cell[57300, 1669, 2023, 54, 99, "Text",
      CellTags->{"kernelevaluation", "all"}]},
  "find"->{
    Cell[59372, 1729, 97, 2, 36, "Subsection",
      CellTags->{"find", "all"}],
    Cell[59472, 1733, 2265, 62, 143, "Text",
      CellTags->{"find", "all"}]},
  "help"->{
    Cell[61774, 1800, 97, 2, 36, "Subsection",
      CellTags->{"help", "all"}],
    Cell[61874, 1804, 1390, 39, 71, "Text",
      CellTags->{"all", "help"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"file", 64038, 1868},
  {"all", 64361, 1877},
  {"edit", 67829, 1960},
  {"editmotion", 68004, 1965},
  {"nonmenu", 68195, 1970},
  {"editexpression", 68724, 1983},
  {"cell", 68920, 1988},
  {"cellconvert", 69099, 1993},
  {"cellgrouping", 69297, 1998},
  {"format", 69492, 2003},
  {"formatstyle", 69676, 2008},
  {"formatface", 69957, 2015},
  {"formatsize", 70151, 2020},
  {"input", 70340, 2025},
  {"kernel", 70517, 2030},
  {"kernelevaluation", 70706, 2035},
  {"find", 70906, 2040},
  {"help", 71079, 2045}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 45, 0, 136, "Title"],

Cell[CellGroupData[{
Cell[1846, 57, 104, 2, 36, "Subsection",
  CellTags->{"file", "all"}],
Cell[1953, 61, 3064, 85, 89, "Text",
  CellTags->{"file", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[5054, 151, 97, 2, 36, "Subsection",
  CellTags->{"file", "all"}],
Cell[5154, 155, 4044, 112, 161, "Text",
  CellTags->{"file", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[9235, 272, 97, 2, 36, "Subsection",
  CellTags->{"edit", "all"}],
Cell[9335, 276, 2713, 76, 179, "Text",
  CellTags->{"edit", "all"}],

Cell[CellGroupData[{
Cell[12073, 356, 111, 2, 34, "Subsubsection",
  CellTags->{"editmotion", "all"}],
Cell[12187, 360, 9841, 265, 253, "Text",
  CellTags->{"editmotion", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[22065, 630, 112, 2, 34, "Subsubsection",
  CellTags->{"nonmenu", "all"}],
Cell[22180, 634, 2135, 61, 111, "Text",
  CellTags->{"nonmenu", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[24352, 700, 125, 2, 34, "Subsubsection",
  CellTags->{"editexpression", "all"}],
Cell[24480, 704, 8615, 233, 365, "Text",
  CellTags->{"editexpression", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[33132, 942, 127, 2, 34, "Subsubsection",
  CellTags->{"nonmenu", "all"}],
Cell[33262, 946, 2343, 63, 133, "Text",
  CellTags->{"nonmenu", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[35642, 1014, 121, 2, 34, "Subsubsection",
  CellTags->{"nonmenu", "all"}],
Cell[35766, 1018, 2643, 75, 155, "Text",
  CellTags->{"nonmenu", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[38458, 1099, 97, 2, 36, "Subsection",
  CellTags->{"cell", "all"}],
Cell[38558, 1103, 1607, 45, 89, "Text",
  CellTags->{"cell", "all"}],

Cell[CellGroupData[{
Cell[40190, 1152, 116, 2, 24, "Subsubsection",
  CellTags->{"cellconvert", "all"}],
Cell[40309, 1156, 1837, 50, 89, "Text",
  CellTags->{"cellconvert", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[42183, 1211, 120, 2, 20, "Subsubsection",
  CellTags->{"cellgrouping", "all"}],
Cell[42306, 1215, 2212, 63, 125, "Text",
  CellTags->{"cellgrouping", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[44567, 1284, 101, 2, 36, "Subsection",
  CellTags->{"format", "all"}],
Cell[44671, 1288, 1485, 41, 71, "Text",
  CellTags->{"format", "all"}],

Cell[CellGroupData[{
Cell[46181, 1333, 111, 2, 20, "Subsubsection",
  CellTags->{"formatstyle", "all"}],
Cell[46295, 1337, 3111, 85, 215, "Text",
  CellTags->{"formatstyle", "all"}],
Cell[49409, 1424, 263, 5, 40, "Notes",
  CellTags->{"formatstyle", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[49709, 1434, 109, 2, 20, "Subsubsection",
  CellTags->{"formatface", "all"}],
Cell[49821, 1438, 1533, 43, 71, "Text",
  CellTags->{"formatface", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[51391, 1486, 109, 2, 20, "Subsubsection",
  CellTags->{"formatsize", "all"}],
Cell[51503, 1490, 1364, 41, 71, "Text",
  CellTags->{"formatsize", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[52916, 1537, 99, 2, 36, "Subsection",
  CellTags->{"input", "all"}],
Cell[53018, 1541, 2604, 70, 159, "Text",
  CellTags->{"input", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[55659, 1616, 101, 2, 36, "Subsection",
  CellTags->{"kernel", "all"}],
Cell[55763, 1620, 1388, 41, 71, "Text",
  CellTags->{"kernel", "all"}],

Cell[CellGroupData[{
Cell[57176, 1665, 121, 2, 24, "Subsubsection",
  CellTags->{"kernelevaluation", "all"}],
Cell[57300, 1669, 2023, 54, 99, "Text",
  CellTags->{"kernelevaluation", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[59372, 1729, 97, 2, 36, "Subsection",
  CellTags->{"find", "all"}],
Cell[59472, 1733, 2265, 62, 143, "Text",
  CellTags->{"find", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[61774, 1800, 97, 2, 36, "Subsection",
  CellTags->{"help", "all"}],
Cell[61874, 1804, 1390, 39, 71, "Text",
  CellTags->{"all", "help"}]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

