(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    125796,       5379]*)
(*NotebookOutlinePosition[    169182,       6537]*)
(*  CellTagsIndexPosition[    168792,       6521]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Entering Two-Dimensional Expressions", "Chapter"],

Cell[CellGroupData[{

Cell["Overview", "Section",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\/y\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overview"],

Cell["Start with the expression that will be the numerator. ", "Text",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    RowBox[{"x", 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"overview"],

Cell["\<\
Create a built-up fraction by pressing the Control and Slash keys \
at the same time. The placeholder in the denominator is already selected. \
\
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontSize->16],
  "/",
  StyleBox["\[RightModified]",
    FontSize->16]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    FractionBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overview"],

Cell["Fill in the denominator. ", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type y", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    FractionBox["x", 
      RowBox[{"y", 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}]]], "Input",
  CellTags->"overview"],

Cell["\<\
Move the insertion point out of the fraction by pressing the \
Control key and the Space bar at the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    RowBox[{\(x\/y\), 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\^m\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overview"],

Cell["Start with the expression that will be the base. ", "Text",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Create a built-up power by pressing the Control key and the 6 key \
(or the Caret key) at the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "6",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    SuperscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overview"],

Cell["\<\
Type the exponent into the placeholder (which is already selected). \
\
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type m", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(x\^\(\(m\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Move the insertion point out of the exponent down to the baseline \
by pressing the Control and Space keys at the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(x\^m\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\@x\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overview"],

Cell["\<\
To get a square root sign, press the Control key and the 2 key (or \
the @ key) at the same time. \
\>", "Text",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "2",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or ",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    SqrtBox[
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overview"],

Cell["Type inside the placeholder (which is already selected).  ", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\@\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Press the Control key and the Space bar at the same time to get out \
of the square root. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(\@x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\@x\%n\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overview"],

Cell["\<\
To get a radical, press the Control key and the 2 key (or the @ \
key) at the same time. \
\>", "Text",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "2",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    SqrtBox[
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overview"],

Cell["\<\
Type the radicand inside the placeholder (which is already \
selected). \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\@\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Press the Control and 5 key (or the % key) at the same time. \
\>", \
"Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "5",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "%",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    RadicalBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overview"],

Cell["Type the index. ", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type n", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\@x\%\(\(n\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Get out of the radical and down to the baseline by pressing the \
Control key and the Space bar at the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["\[SpaceKey]",
    FontSize->16]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(\@x\%n\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {"a", "b"},
              {"c", "d"}
              }], ")"}], TraditionalForm]],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overview"],

Cell["\<\
Type a left parenthesis and a right parenthesis, then move the \
insertion point to be between them. \
\>", "Text",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type (), press ",
  Cell[BoxData[
      FrameBox["\[LeftArrow]"]],
    FontSize->16]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(( \[VerticalSeparator] )\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Type the first entry of the vector. Create a new column by pressing \
the Control key and the Comma key at the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type a, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ",",
  StyleBox["\[RightModified]",
    FontSize->16]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]}
          }], ")"}]], "Input",
  CellTags->"overview"],

Cell["\<\
Type the next entry into the placeholder (which is already \
selected). Create a new row by pressing the Control key and the Return key at \
the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type b, press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[ReturnIndicator]",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]"}
          }], ")"}]], "Input",
  CellTags->"overview"],

Cell["\<\
Type the next entry into the placeholder (which is already \
selected). Press the \[TabKey] key to select the next placeholder. \
\>", \
"Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type c, press",
  " ",
  StyleBox["\[TabKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b"},
          {"c", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]}
          }], ")"}]], "Input",
  CellTags->"overview"],

Cell["\<\
Type the last entry into the placeholder. Press the Control key and \
the Space bar at the same time to get out of the GridBox. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type d, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    RowBox[{"(", 
      RowBox[{GridBox[{
            {"a", "b"},
            {"c", "d"}
            }], "\[VerticalSeparator]"}], ")"}]], "Input",
  CellTags->"overview"],

Cell["Move the insertion point to get out of the matrix.", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  Cell[BoxData[
      FrameBox["\[RightArrow]"]],
    FontSize->16]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(", GridBox[{
            {"a", "b"},
            {"c", "d"}
            }], ")"}], "\[VerticalSeparator]"}]], "Input",
  CellTags->"overview"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overview"],

Cell["Type the symbol that will have the subscript. ", "Text",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Create a subscript by pressing the Control key and the - key (or \
the _ key) at the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "-",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[AutoOperand] or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "_",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    SubscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overview"],

Cell["\<\
Type the subscript into the placeholder (which is already \
selected). \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type i", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(x\_\(\(i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Move the insertion point out of the subscript position up to the \
baseline by pressing the Control and Space keys at the same time. \
\>", \
"Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(x\_i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`A\^T\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overview"],

Cell["Type the symbol that will have the superscript. ", "Text",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell["Type A", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(A\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Create a superscript by pressing the Control key and the 6 key (or \
the Caret key) at the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "6",
  StyleBox["\[RightModified]\[AutoOperand]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox[" ",
    FontSize->16],
  "or",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    SuperscriptBox["A", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overview"],

Cell["\<\
Type the superscript into the placeholder (which is already \
selected). \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type T", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(A\^\(\(T\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Move the insertion point out of the superscript position down to \
the baseline by pressing the Control and Space keys at the same time. \
\>", \
"Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(A\^T\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\+_\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overview"],

Cell["Type the expression that will have an underscript. ", "Text",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Create an underscript by pressing the Control key and the = key (or \
the + key) at the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "=",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[AutoOperand] or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "+",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    UnderscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overview"],

Cell["\<\
Type an underscore into the placeholder (which is already \
selected). \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type _", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(x\+\(\(_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Move the insertion point out of the underscript position up to the \
baseline by pressing the Control and Space keys at the same time. \
\>", \
"Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(x\+_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\&_\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overview"],

Cell["Type the expression that will have an overscript. ", "Text",
  CellTags->"overview"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Create an overscript by pressing the Control key and the 7 key (or \
the & key) at the same time. \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "7",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[AutoOperand] or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "&",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    OverscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overview"],

Cell["\<\
Type an underscore into the placeholder (which is already \
selected). \
\>", "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type _", "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(x\&\(\(_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"],

Cell["\<\
Move the insertion point out of the overscript position down to the \
baseline by pressing the Control and Space keys at the same time. \
\>", \
"Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overview"],

Cell[BoxData[
    \(\(\(x\&_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Fractions", "Section",
  CellTags->"fractions"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\/y\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"fractions"],

Cell["Start with the expression that will be the numerator. ", "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    RowBox[{"x", 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"fractions"],

Cell["\<\
Create a built-up fraction by pressing the Control and Slash keys \
at the same time. The placeholder in the denominator is already selected. \
\
\>", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "/",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    FractionBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"fractions"],

Cell["Fill in the denominator. ", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type y", "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    FractionBox["x", 
      RowBox[{"y", 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}]]], "Input",
  CellTags->"fractions"],

Cell["\<\
Move the insertion point out of the fraction by pressing the \
Control key and the Space bar at the same time. \
\>", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    RowBox[{\(x\/y\), 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\/y + z\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"fractions"],

Cell["Repeat the steps of the first example. ", "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "/",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type y, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    RowBox[{\(x\/y\), 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"fractions"],

Cell["\<\
Once the insertion point is out of the fraction you can continue \
typing. \
\>", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type +z", "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    RowBox[{\(x\/y + z\), 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\/\(y + z\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"fractions"],

Cell["Do the first few steps of the previous example. ", "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "/",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type y"
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    FractionBox["x", 
      RowBox[{"y", 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}]]], "Input",
  CellTags->"fractions"],

Cell["\<\
Continue typing in the denominator and then come out of the \
fraction. \
\>", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type +z, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    RowBox[{\(x\/\(y + z\)\), 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\(x + y\)\/z\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"fractions"],

Cell["\<\
Create a built-up fraction with Control-Slash. The numerator and \
denominator contain placeholders; the one in the numerator is selected. \
\
\>", "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "/",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    FractionBox[
      StyleBox["\[Placeholder]",
        DrawHighlighted->1], "\[Placeholder]"]], "Input",
  CellTags->"fractions"],

Cell["Type an expression in the numerator. ", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type x+y", "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    FractionBox[
      RowBox[{\(x + y\), 
        StyleBox["\[VerticalSeparator]",
          FontWeight->"Plain"]}], "\[Placeholder]"]], "Input",
  CellTags->"fractions"],

Cell["\<\
Select the placeholder in the denominator by the pressing the \
\[TabKey] key. (Alternatively, you can select the placeholder by clicking it \
or dragging.) \
\>", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[TabKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    FractionBox[\(x + y\), 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"fractions"],

Cell["\<\
Fill in the numerator and get out of the fraction with \
Control-Space. \
\>", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type z, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    \(\(\(\(x + y\)\/z\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Another way to type ",
  Cell[BoxData[
      \(TraditionalForm\`\(x + y\)\/z\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"fractions"],

Cell["Start with the expression that will be the numerator. ", "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{

Cell["Type x+y", "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    RowBox[{\(x + y\), 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"fractions"],

Cell["\<\
Select the expression. (You can select by dragging, by pressing \
Control-Dot repeatedly, or by clicking the expression repeatedly.) \
\>", \
"Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Select it", "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    StyleBox[\(x + y\),
      DrawHighlighted->1]], "Input",
  CellTags->"fractions"],

Cell["Create a built-up fraction by pressing Control-Slash. ", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[LeftModified]/\[RightModified]"
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    FractionBox[\(x + y\), 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"fractions"],

Cell["\<\
Fill in the numerator and get out of the fraction with \
Control-Space. \
\>", "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type z, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"fractions"],

Cell[BoxData[
    \(\(\(\(x + y\)\/z\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Powers", "Section",
  CellTags->"powers"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\^m\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"powers"],

Cell["Start with the expression that will be the base. ", "Text",
  CellTags->"powers"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    \(\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"powers"],

Cell["\<\
Create a built-up power by pressing the Control key and the 6 key \
(or the Caret key) at the same time. \
\>", "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "6",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    SuperscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"powers"],

Cell["\<\
Type the exponent into the placeholder (which is already selected). \
\
\>", "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type m", "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    \(x\^\(\(m\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"powers"],

Cell["\<\
Move the insertion point out of the exponent down to the baseline \
by
pressing the Control and Space keys at the same time. \
\>", "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    \(\(\(x\^m\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"powers"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\^m + y\^n\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"powers"],

Cell["Repeat the steps of the first example. ", "Text",
  CellTags->"powers"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type m, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    RowBox[{\(x\^m\), 
      StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]], "Input",
  CellTags->"powers"],

Cell["Add the second power in a similar way. ", "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type +y, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type n, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    \(\(\(x\^m + y\^n\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"powers"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\^\(m + n\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"powers"],

Cell["Repeat the first two steps of the first example. ", "Text",
  CellTags->"powers"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    SuperscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"powers"],

Cell["Fill in the exponent and come down out of the exponent. ", "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type m+n, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    \(\(\(x\^\(m + n\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"powers"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\^\(m\/n\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"powers"],

Cell["Repeat the first three steps of the first example. ", "Text",
  CellTags->"powers"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type m"
}], "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    \(x\^\(\(m\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"powers"],

Cell["Construct a built-up fraction in the exponent. ", "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "/",
  StyleBox["\[RightModified]",
    FontSize->16],
  ", type n"
}], "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    \(x\^\(m\/\(\(n\)\(\[VerticalSeparator]\)\)\)\)], "Input",
  CellTags->"powers"],

Cell["Press Control-Space twice to get down to the baseline. ", "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " twice"
}], "Subsubsection",
  CellTags->"powers"],

Cell[BoxData[
    \(\(\(x\^\(m\/n\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"powers"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Square Roots", "Section",
  CellTags->"squareroots"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\@x\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"squareroots"],

Cell["\<\
To get a square root sign, press the Control key and the 2 key (or \
the @ key) at the same time. \
\>", "Text",
  CellTags->"squareroots"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "2",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    SqrtBox[
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"squareroots"],

Cell["Type inside the placeholder (which is already selected).  ", "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    \(\@\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"squareroots"],

Cell["\<\
Press the Control key and the Space bar at the same time to get out \
of the square root. \
\>", "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    \(\(\(\@x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"squareroots"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\(\@x\) \@y\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"squareroots"],

Cell[TextData[{
  "Repeat the steps of the example for ",
  Cell[BoxData[
      \(TraditionalForm\`\@x\)],
    FormatType->StandardForm],
  ". "
}], "Text",
  CellTags->"squareroots"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type x, press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    \(\(\(\@x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"squareroots"],

Cell["Type the second square root in the same way as the first. ", "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type y, press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    \(\(\(\(\@x\) \@y\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"squareroots"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(x\ y\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"squareroots"],

Cell["Press Control-@ to get a square root sign. ", "Text",
  CellTags->"squareroots"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    SqrtBox[
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"squareroots"],

Cell["\<\
Type the expression in the placeholder (which is already selected). \
Get out of the square root sign by pressing Control-Space.\
\>", "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x y, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    \(\(\(\@\(x\ y\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"squareroots"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Another way to type ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(x\ y\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"squareroots"],

Cell["\<\
Start by typing the expression that will be inside the square root. \
\
\>", "Text",
  CellTags->"squareroots"],

Cell[CellGroupData[{

Cell["Type x y", "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    \(x\ y\)], "Input",
  CellTags->"squareroots"],

Cell["\<\
Select the expression. (You can select by dragging, by pressing \
Control-Dot repeatedly, or by clicking the expression repeatedly.) \
\>", \
"Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Select x y", "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    StyleBox[\(x\ y\),
      DrawHighlighted->1]], "Input",
  CellTags->"squareroots"],

Cell["\<\
Press Control-@ to put a square root around the selection. Get out \
of the square root by pressing Control-Space. \
\>", "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["\[LeftModified]",
    FontSize->16],
  "@",
  StyleBox["\[RightModified]",
    FontSize->16],
  ", press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"squareroots"],

Cell[BoxData[
    \(\(\(\@\(x\ y\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"squareroots"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Radicals", "Section",
  CellTags->"radicals"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\@x\%n\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"radicals"],

Cell["\<\
To get a radical, press the Control key and the 2 key (or the @ \
key) at the same time. \
\>", "Text",
  CellTags->"radicals"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "2",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    SqrtBox[
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"radicals"],

Cell["\<\
Type the radicand inside the placeholder (which is already \
selected). \
\>", "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    \(\@\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"radicals"],

Cell["\<\
Press the Control and 5 key (or the % key) at the same time. \
\>", \
"Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "5",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or  ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "%",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    RadicalBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"radicals"],

Cell["Type the index. ", "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type n", "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    \(\@x\%\(\(n\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"radicals"],

Cell["\<\
Get out of the radical and down to the baseline by pressing the \
Control key and the Space bar at the same time. \
\>", "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    \(\(\(\@x\%n\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"radicals"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\(\@x\%n\) \@y\%n\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"radicals"],

Cell[TextData[{
  "First, repeat the steps of the example for ",
  Cell[BoxData[
      \(TraditionalForm\`\@x\%n\)],
    FormatType->StandardForm],
  "."
}], "Text",
  CellTags->"radicals"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type x, press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "%",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type n, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    \(\(\(\@x\%n\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"radicals"],

Cell["Now type the second radical in the same way as the first. ", "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type y, press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "%",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type n, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    \(\(\(\(\@x\%n\) \@y\%n\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"radicals"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(x\ y\)\%n\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"radicals"],

Cell["Press Control-@ to get a radical sign. ", "Text",
  CellTags->"radicals"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    SqrtBox[
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"radicals"],

Cell["\<\
Type the expression in the placeholder (which is already selected). \
Press Control-% to create an index.  \
\>", "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x y, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "%",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    RadicalBox[\(x\ y\), 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"radicals"],

Cell["\<\
Type the index in the placeholder (which is already selected). Get \
out of the radical and down to the baseline by pressing Control-Space.\
\>", \
"Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type n, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    \(\(\(\@\(x\ y\)\%n\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"radicals"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Another way to type ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(x\ y\)\%n\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"radicals"],

Cell["\<\
Start by typing the expression that will be inside the square root. \
\
\>", "Text",
  CellTags->"radicals"],

Cell[CellGroupData[{

Cell["Type x y", "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    \(x\ y\)], "Input",
  CellTags->"radicals"],

Cell["\<\
Select the expression. (You can select by dragging, by pressing \
Control-Dot repeatedly, or by clicking the expression repeatedly.) \
\>", \
"Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Select x y", "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    StyleBox[\(x\ y\),
      DrawHighlighted->1]], "Input",
  CellTags->"radicals"],

Cell["\<\
Press Control-@ to put a radical around the selection. Get out of \
the radical by pressing Control-Space.  \
\>", "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "@",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"radicals"],

Cell[BoxData[
    \(\(\(\@\(x\ y\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"radicals"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Vectors", "Section",
  CellTags->"vectors"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  "the row vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {"a", "b", "c", "d"}
              }], ")"}], TraditionalForm]],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"vectors"],

Cell["\<\
Type a left parenthesis and a right parenthesis, then move the \
insertion point to be between them. \
\>", "Text",
  CellTags->"vectors"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type (), press ",
  Cell[BoxData[
      FrameBox["\[LeftArrow]"]],
    FontSize->16]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    \(\(( \[VerticalSeparator] )\)\)], "Input",
  CellTags->"vectors"],

Cell["\<\
Type the first entry of the vector. Create the next entry by \
pressing the Control key and the Comma key at the same time. \
\>", "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type a, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ",",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]}
          }], ")"}]], "Input",
  CellTags->"vectors"],

Cell["\<\
Type the next entry into the placeholder (which is already \
selected). Create another entry with Control-Comma and repeat. \
\>", "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type b, press",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ",",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]}
          }], ")"}]], "Input",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type c, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ",",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", "c", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]}
          }], ")"}]], "Input",
  GeneratedCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type d", "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", "c", \(\(d\)\(\[VerticalSeparator]\)\)}
          }], ")"}]], "Input",
  CellTags->"vectors"],

Cell["\<\
Press the Control key and the Space bar at the same time to get out \
of the GridBox. \
\>", "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", 
      RowBox[{GridBox[{
            {"a", "b", "c", "d"}
            }], "\[VerticalSeparator]"}], ")"}]], "Input",
  CellTags->"vectors"],

Cell["Move the insertion point to get out of the vector. ", "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  Cell[BoxData[
      FrameBox["\[RightArrow]"]],
    FontSize->16]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(", GridBox[{
            {"a", "b", "c", "d"}
            }], ")"}], "\[VerticalSeparator]"}]], "Input",
  CellTags->"vectors"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type the column vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {"a"},
              {"b"},
              {"c"},
              {"d"}
              }], ")"}], TraditionalForm]],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"vectors"],

Cell["\<\
Type a left parenthesis and a right parenthesis, then put the \
insertion point to be between them. \
\>", "Text",
  CellTags->"vectors"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type (), press ",
  Cell[BoxData[
      FrameBox["\[LeftArrow]"]],
    FontSize->16]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    \(\(( \[VerticalSeparator] )\)\)], "Input",
  CellTags->"vectors"],

Cell["\<\
Type the first entry of the vector. Create the next entry by \
pressing the Control key and the Return key at the same time. \
\>", "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type a, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[ReturnIndicator]",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]}
          }], ")"}]], "Input",
  CellTags->"vectors"],

Cell["\<\
Type the next entry into the placeholder (which is already \
selected). Create another entry with Control-Return and repeat. \
\>", "Text",\

  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type b, press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[ReturnIndicator]",
  StyleBox["\[RightModified]",
    FontSize->16]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a"},
          {"b"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]}
          }], ")"}]], "Input",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type c, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[ReturnIndicator]",
  StyleBox["\[RightModified]",
    FontSize->16]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a"},
          {"b"},
          {"c"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]}
          }], ")"}]], "Input",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type d", "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a"},
          {"b"},
          {"c"},
          {\(\(d\)\(\[VerticalSeparator]\)\)}
          }], ")"}]], "Input",
  CellTags->"vectors"],

Cell["\<\
Press the Control key and the Space bar at the same time to get out \
of the GridBox. \
\>", "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{"(", 
      RowBox[{GridBox[{
            {"a"},
            {"b"},
            {"c"},
            {"d"}
            }], "\[VerticalSeparator]"}], ")"}]], "Input",
  CellTags->"vectors"],

Cell["Move the insertion point to get out of the vector. ", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  Cell[BoxData[
      FrameBox["\[RightArrow]"]],
    FontSize->16]
}], "Subsubsection",
  CellTags->"vectors"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(", GridBox[{
            {"a"},
            {"b"},
            {"c"},
            {"d"}
            }], ")"}], "\[VerticalSeparator]"}]], "Input",
  CellTags->"vectors"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrices", "Section",
  CellTags->"matrices"],

Cell[CellGroupData[{

Cell["How to create a new matrix", "SubsectionIcon",
  CellTags->"matrices"],

Cell[TextData[{
  StyleBox["Choose ",
    FontWeight->"Plain"],
  StyleBox["Create Table/Matrix/Palette", "SR"],
  StyleBox[" from the ",
    FontWeight->"Plain"],
  "Input",
  StyleBox[" menu. ",
    FontWeight->"Plain"]
}], "Text",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(", GridBox[{
            {"1", "\[Placeholder]", "\[Placeholder]"},
            {"\[Placeholder]", "1", "\[Placeholder]"},
            {"\[Placeholder]", "\[Placeholder]", "1"}
            }], ")"}], "\[VerticalSeparator]"}]], "Input",
  CellTags->"matrices"]
}, Closed]],

Cell[CellGroupData[{

Cell["How to fill in placeholders", "SubsectionIcon",
  CellTags->"matrices"],

Cell["\<\
Suppose the entry in the top-left position is selected.

Type an entry and select the next placeholder with the \[TabKey] key; repeat. \
(You can select placeholders in the opposite direction with \[ShiftKey]\
\[SkeletonIndicator]\[TabKey].)\
\>", "Text",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]"},
          {"\[Placeholder]", "\[Placeholder]"}
          }], ")"}]], "Input",
  CellTags->"matrices"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type a, press ",
  StyleBox["\[TabKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]},
          {"\[Placeholder]", "\[Placeholder]"}
          }], ")"}]], "Input",
  CellTags->"matrices"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type b, press ",
  StyleBox["\[TabKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]"}
          }], ")"}]], "Input",
  CellTags->"matrices"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type c, press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[TabKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b"},
          {"c", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1]}
          }], ")"}]], "Input",
  CellTags->"matrices"],

Cell["\<\
Press the Control key and the Space bar at the same time to get out \
of the GridBox.\
\>", "Text",
  CellTags->"matrices"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type d, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{"(", 
      RowBox[{GridBox[{
            {"a", "b"},
            {"c", "d"}
            }], "\[VerticalSeparator]"}], ")"}]], "Input",
  CellTags->"matrices"],

Cell["Move the insertion point to get out of the matrix.", "Text",
  CellTags->"matrices"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  Cell[BoxData[
      FrameBox["\[RightArrow]"]],
    FontSize->16]
}], "Subsubsection",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(", GridBox[{
            {"a", "b"},
            {"c", "d"}
            }], ")"}], "\[VerticalSeparator]"}]], "Input",
  CellTags->"matrices"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["How to add a new column", "SubsectionIcon",
  CellTags->"matrices"],

Cell["\<\
Place the insertion point to the right of any entry; here the \
insertion point is to the right of the entry at the top-left. \
\>", "Text",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {\(\(a\)\(\[VerticalSeparator]\)\), "b"},
          {"c", "d"}
          }], ")"}]], "Input",
  CellTags->"matrices"],

Cell["\<\
Press the Control and Comma keys at the same time. A column of \
placeholders will appear, with the top one selected. \
\>", "Text",
  CellTags->"matrices"],

Cell[TextData[{
  StyleBox["Press",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Times",
    FontSize->16,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ",",
  StyleBox["\[RightModified]",
    FontFamily->"Times",
    FontSize->16,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Text",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", 
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "b"},
          {"c", "\[Placeholder]", "d"}
          }], ")"}]], "Input",
  CellTags->"matrices"]
}, Closed]],

Cell[CellGroupData[{

Cell["How to add a new row", "SubsectionIcon",
  CellTags->"matrices"],

Cell["\<\
Place the insertion point to the right of any entry; here the \
insertion point is to the right of the entry at the top-left. \
\>", "Text",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {\(\(a\)\(\[VerticalSeparator]\)\), "b"},
          {"c", "d"}
          }], ")"}]], "Input",
  CellTags->"matrices"],

Cell["\<\
Press the Control and Return keys at the same time. A row of \
placeholders will appear, with the first one selected. \
\>", "Text",
  CellTags->"matrices"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["\[ReturnIndicator]",
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"matrices"],

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b"},
          {
            StyleBox["\[Placeholder]",
              DrawHighlighted->1], "\[Placeholder]"},
          {"c", "d"}
          }], ")"}]], "Input",
  CellTags->"matrices"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Superscripts", "Section",
  CellTags->"superscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\^i\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"superscripts"],

Cell["Type the symbol that will have the superscript. ", "Text",
  CellTags->"superscripts"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    \(\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"superscripts"],

Cell["\<\
Create a superscript by pressing the Control key and the 6 key (or \
the Caret key) at the same time. \
\>", "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "6",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[AutoOperand] or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    SuperscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"superscripts"],

Cell["\<\
Type the superscript into the placeholder (which is already \
selected). \
\>", "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type i", "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    \(x\^\(\(i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"superscripts"],

Cell["\<\
Move the insertion point out of the superscript position down to \
the
baseline by pressing the Control and Space keys at the same time. \
\>", \
"Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    \(\(\(x\^i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"superscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\^\(i\ j\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"superscripts"],

Cell[TextData[{
  " See the example for ",
  Cell[BoxData[
      \(TraditionalForm\`x\^\(2\[InvisibleComma]3\)\)],
    FormatType->StandardForm],
  " to see how to avoid multiplying the two superscripts. "
}], "Text",
  CellTags->"superscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    SuperscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type i, press ",
  StyleBox["\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type j"
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    \(x\^\(\(i\ j\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    \(\(\(x\^\(i\ j\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"superscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\^\(2\[InvisibleComma]3\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"superscripts"],

Cell["Create a placeholder in the superscript position. ", "Text",
  CellTags->"superscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    SuperscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"superscripts"],

Cell[TextData[StyleBox["To avoid multiplying the two superscripts, separate \
them with an invisible comma\[VeryThinSpace]. To type the alias for an \
invisible comma, press the Escape key before and after typing a comma. ",
  FontWeight->"Plain"]], "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type 2, press ",
  StyleBox["\[EscapeKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type a comma, press ",
  StyleBox["\[EscapeKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type 3"
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    \(x\^\(2\[InvisibleComma]\(\(3\)\(\[VerticalSeparator]\)\)\)\)], "Input",
  CellTags->"superscripts"],

Cell["\<\
Get out of the superscript position up to the baseline with \
Control-Space. \
\>", "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    \(\(\(x\^\(2\[InvisibleComma]3\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"superscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n\_i\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"superscripts"],

Cell["\<\
The first three steps create and fill in the superscript and its \
subscript. \
\>", "Text",
  CellTags->"superscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "^",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    SuperscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type n, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "_",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    SuperscriptBox["x", 
      SubscriptBox["n", 
        StyleBox["\[Placeholder]",
          DrawHighlighted->1]]]], "Input",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type i", "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    \(x\^n\_\(\(i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"superscripts"],

Cell["It takes two Control-Spaces to get down to the baseline. ", "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " twice"
}], "Subsubsection",
  CellTags->"superscripts"],

Cell[BoxData[
    \(x\^\(\(n\_i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"superscripts"],

Cell[BoxData[
    \(\(\(x\^n\_i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"superscripts"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Subscripts", "Section",
  CellTags->"subscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"subscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Type the symbol that will have the subscript.",
    FontFamily->"Times",
    FontWeight->"Plain"],
  " "
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[TextData[StyleBox["Type x",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "Text",
  CellTags->"subscripts"],

Cell[BoxData[
    \(\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"subscripts"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Create a subscript by pressing the Control key",
    FontFamily->"Times",
    FontWeight->"Plain"],
  StyleBox[" ",
    FontFamily->"Times",
    FontWeight->"Plain"],
  StyleBox["and the - key (or the _ key) at the same time.",
    FontFamily->"Times",
    FontWeight->"Plain"],
  " "
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[TextData[{
  StyleBox["Press",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Times",
    FontSize->16,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "-",
  StyleBox["\[RightModified]",
    FontFamily->"Times",
    FontSize->16,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[AutoOperand] ",
  StyleBox["or",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Times",
    FontSize->16,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "_",
  StyleBox["\[RightModified]",
    FontFamily->"Times",
    FontSize->16,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Text",
  CellTags->"subscripts"],

Cell[BoxData[
    SubscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"subscripts"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Type the subscript into the placeholder (which is already \
selected).",
    FontFamily->"Times",
    FontWeight->"Plain"],
  " "
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[TextData[StyleBox["Type i",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "Text",
  CellTags->"subscripts"],

Cell[BoxData[
    \(x\_\(\(i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"subscripts"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Move the insertion point out of the subscript position up to the \
baseline by pressing the Control and Space keys at the same time.",
    FontFamily->"Times",
    FontWeight->"Plain"],
  " "
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[TextData[{
  StyleBox["Press",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  " ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Text",
  CellTags->"subscripts"],

Cell[BoxData[
    \(\(\(x\_i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"subscripts"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(i\ j\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"subscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["See the example for ",
    FontFamily->"Times",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            FontWeight->"Roman",
            FontSlant->"Italic"], \(2\[InvisibleComma]3\)], TraditionalForm]],
    
    FormatType->StandardForm,
    FontFamily->"Times",
    FontWeight->"Plain"],
  StyleBox[" to see how to avoid multiplying the two superscripts.",
    FontFamily->"Times",
    FontWeight->"Plain"],
  " "
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[TextData[{
  StyleBox["Type x, press",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Times",
    FontSize->16,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "_",
  StyleBox["\[RightModified]",
    FontFamily->"Times",
    FontSize->16,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Text",
  CellTags->"subscripts"],

Cell[BoxData[
    SubscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"subscripts"],

Cell[TextData[{
  StyleBox["Type i, press",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  " ",
  StyleBox["\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", ",
  StyleBox["type ",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  StyleBox["j",
    FontFamily->"Helvetica",
    FontWeight->"Bold"]
}], "Text",
  CellTags->"subscripts"],

Cell[BoxData[
    \(x\_\(\(i\ j\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"subscripts"],

Cell[TextData[{
  StyleBox["Press",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Text",
  CellTags->"subscripts"],

Cell[BoxData[
    \(\(\(x\_\(i\ j\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"subscripts"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(2\[InvisibleComma]3\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"subscripts"],

Cell["Create a placeholder in the superscript position. ", "Text",
  CellTags->"subscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "_",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[BoxData[
    SubscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"subscripts"],

Cell[TextData[StyleBox["To avoid multiplying the two subscripts, separate \
them with an invisible comma\[VeryThinSpace]. To type the alias for an \
invisible comma, press the Escape key before and after typing a comma. ",
  FontWeight->"Plain"]], "Text",
  CellTags->"subscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type 2, press ",
  StyleBox["\[EscapeKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type a comma, press ",
  StyleBox["\[EscapeKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type 3"
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[BoxData[
    \(x\_\(2\[InvisibleComma]\(\(3\)\(\[VerticalSeparator]\)\)\)\)], "Input",
  CellTags->"subscripts"],

Cell["\<\
Get out of the subscript position up to the baseline with \
Control-Space. \
\>", "Text",
  CellTags->"subscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[BoxData[
    \(\(\(x\_\(2\[InvisibleComma]3\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"subscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(n\_i\)\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"subscripts"],

Cell["\<\
The first three steps create and fill in the subscript and its \
subscript. \
\>", "Text",
  CellTags->"subscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type x, press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "_",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[BoxData[
    SubscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"subscripts"],

Cell[TextData[{
  StyleBox["Type n, press",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  " ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "_",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Text",
  CellTags->"subscripts"],

Cell[BoxData[
    SubscriptBox["x", 
      SubscriptBox["n", 
        StyleBox["\[Placeholder]",
          DrawHighlighted->1]]]], "Input",
  CellTags->"subscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type i", "Subsubsection",
  CellTags->"subscripts"],

Cell[BoxData[
    \(x\_\(n\_\(\(i\)\(\[VerticalSeparator]\)\)\)\)], "Input",
  CellTags->"subscripts"],

Cell["\<\
It takes pressing Control-Space twice to get up to the base line. \
\
\>", "Text",
  CellTags->"subscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " twice"
}], "Subsubsection",
  CellTags->"subscripts"],

Cell[BoxData[
    \(x\_\(\(n\_i\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"subscripts"],

Cell[BoxData[
    \(\(\(x\_\(n\_i\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"subscripts"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Overscripts", "Section",
  CellTags->"overscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\&_\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overscripts"],

Cell["Type the expression that will have an overscript. ", "Text",
  CellTags->"overscripts"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    \(\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overscripts"],

Cell["\<\
Create an overscript by pressing the Control key and the 7 key ( or \
the & key) at the same time. \
\>", "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "7",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[AutoOperand] or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "&",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    OverscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overscripts"],

Cell["\<\
Type an underscore into the placeholder (which is already \
selected). \
\>", "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type _", "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    \(x\&\(\(_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overscripts"],

Cell["\<\
Move the insertion point out of the overscript position down to the \
baseline by pressing the Control and Space keys at the same time. \
\>", \
"Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    \(\(\(x\&_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\(x + y\)\&_\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overscripts"],

Cell["\<\
Press the Control key and the 7 key (or the & key) at the same \
time. This creates a pair of placeholders, one on the baseline and another in \
the overscript position. \
\>", "Text",
  CellTags->"overscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "7",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "&",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    OverscriptBox["\[Placeholder]", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overscripts"],

Cell["\<\
Type an underscore into the placeholder in the overscript (which is \
already selected). \
\>", "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type _", "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    \(\[Placeholder]\&\(\(_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overscripts"],

Cell["\<\
Press the \[TabKey] key to select the placeholder that is on the \
baseline. \
\>", "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[TabKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    OverscriptBox[
      StyleBox["\[Placeholder]",
        DrawHighlighted->1], "_"]], "Input",
  CellTags->"overscripts"],

Cell["Type the expression under the overscript. ", "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type x+y", "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    \(\(\(x + y\)\(\[VerticalSeparator]\)\)\&_\)], "Input",
  CellTags->"overscripts"],

Cell["\<\
Press Control-Space to get out of the overscripted expression. \
\
\>", "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    \(\(\(\(x + y\)\&_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Another way to type ",
  Cell[BoxData[
      \(TraditionalForm\`\(x + y\)\&_\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"overscripts"],

Cell[CellGroupData[{

Cell["Type x+y", "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    \(x + y\)], "Input",
  CellTags->"overscripts"],

Cell["\<\
Select the expression. (You can select by dragging, by pressing \
Control-Dot repeatedly, or by clicking the expression repeatedly.) \
\>", \
"Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Select x+y", "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    StyleBox[\(x + y\),
      DrawHighlighted->1]], "Input",
  CellTags->"overscripts"],

Cell["\<\
Press the Control and & keys together to create a placeholder in \
the overscript position. \
\>", "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "&",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    OverscriptBox[\(x + y\), 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"overscripts"],

Cell["Type an underscore in the overscript position. ", "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type _", "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    \(\(x + y\)\&\(\(_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overscripts"],

Cell["Press the Control-Space to get down to the baseline. ", "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"overscripts"],

Cell[BoxData[
    \(\(\(\(x + y\)\&_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"overscripts"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Underscripts", "Section",
  CellTags->"underscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`x\+_\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"underscripts"],

Cell["Type the expression that will have an underscript. ", "Text",
  CellTags->"underscripts"],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"],

Cell["\<\
Create an underscript by pressing the Control key and the = key (or \
the + key) at the same time. \
\>", "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "=",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "\[AutoOperand] or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "+",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    UnderscriptBox["x", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"underscripts"],

Cell["\<\
Type an underscore into the placeholder (which is already \
selected). \
\>", "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type _", "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(x\+\(\(_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"],

Cell["\<\
Move the insertion point out of the underscript position up to the \
baseline by pressing the Control and Space keys at the same time. \
\>", \
"Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(\(\(x\+_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      \(TraditionalForm\`\(x + y\)\+_\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"underscripts"],

Cell["\<\
Press the Control key and the = key (or the + key) at the same \
time. This creates a pair of placeholders, one on the baseline and another in \
the underscript position. \
\>", "Text",
  CellTags->"underscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "=",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  " or ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "+",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    UnderscriptBox["\[Placeholder]", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"underscripts"],

Cell["\<\
Type an underscore into the placeholder in the underscript (which \
is already selected). \
\>", "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type _", "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(\[Placeholder]\+_\)], "Input",
  CellTags->"underscripts"],

Cell["\<\
Press the \[TabKey] key to select the placeholder that is on the \
baseline. \
\>", "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Press \[TabKey]", "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    UnderscriptBox[
      StyleBox["\[Placeholder]",
        DrawHighlighted->1], "_"]], "Input",
  CellTags->"underscripts"],

Cell["Type the expression over the underscript. ", "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type x+y", "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(\(x + y\)\+\(\(_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"],

Cell["\<\
Press Control-Space to get out of the underscripted expression. \
\
\>", "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(\(\(\(x + y\)\+_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Another way to type ",
  Cell[BoxData[
      \(TraditionalForm\`\(x + y\)\+_\)],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"underscripts"],

Cell[TextData[StyleBox["Type x+y",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "Text",
  CellTags->"underscripts"],

Cell[BoxData[
    \(x + y\)], "Input",
  CellTags->"underscripts"],

Cell["\<\
Select the expression. (You can select by dragging, by pressing \
Control-Dot repeatedly, or by clicking the expression repeatedly.) \
\>", \
"Text",
  CellTags->"underscripts"],

Cell[CellGroupData[{

Cell["Select x+y", "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    StyleBox[\(x + y\),
      DrawHighlighted->1]], "Input",
  CellTags->"underscripts"],

Cell["\<\
Press the Control and + keys together to create a placeholder in \
the underscript position. \
\>", "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "+",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    UnderscriptBox[\(x + y\), 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"underscripts"],

Cell["Type an underscore in the underscript position. ", "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type _", "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(\(x + y\)\+\(\(_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"],

Cell["Press Control-Space to get up to the baseline. ", "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(\(\(\(x + y\)\+_\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How to type ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(lim\+\(x -> a\)\),
            ScriptLevel->0], \(f[x]\)}], TraditionalForm]],
    FormatType->StandardForm]
}], "SubsectionIcon",
  CellTags->"underscripts"],

Cell[CellGroupData[{

Cell[TextData[{
  "Type lim, press",
  StyleBox[" ",
    FontSize->16],
  StyleBox["\[ControlKey]\[LeftModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  "+",
  StyleBox["\[RightModified]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    UnderscriptBox["lim", 
      StyleBox["\[Placeholder]",
        DrawHighlighted->1]]], "Input",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type x", "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(lim\+\(\(x\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Press ",
  StyleBox["\[EscapeKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  ", type - >, press ",
  StyleBox["\[EscapeKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(lim\+\(\(\(x\)\(->\)\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Type a, press ",
  StyleBox["\[ControlKey]\[KeyBar]\[SpaceKey]",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontTracking->"Plain",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(lim\+\(x -> a\) \[VerticalSeparator] \)], "Input",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type f[x]", "Subsubsection",
  CellTags->"underscripts"],

Cell[BoxData[
    \(\(\(lim\+\(x -> a\)f[x]\)\(\[VerticalSeparator]\)\)\)], "Input",
  CellTags->"underscripts"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{0, 1148}, {0, 746}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
WindowSize->{573, 551},
WindowMargins->{{Automatic, 83}, {Automatic, 0}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "overview"->{
    Cell[1807, 56, 51, 1, 52, "Section",
      CellTags->"overview"],
    Cell[1883, 61, 159, 6, 70, "SubsectionIcon",
      CellTags->"overview"],
    Cell[2045, 69, 94, 1, 70, "Text",
      CellTags->"overview"],
    Cell[2164, 74, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[2222, 77, 136, 4, 70, "Input",
      CellTags->"overview"],
    Cell[2361, 83, 192, 5, 70, "Text",
      CellTags->"overview"],
    Cell[2590, 93, 190, 8, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[2783, 103, 132, 4, 70, "Input",
      CellTags->"overview"],
    Cell[2918, 109, 65, 1, 70, "Text",
      CellTags->"overview"],
    Cell[3020, 115, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[3078, 118, 165, 5, 70, "Input",
      CellTags->"overview"],
    Cell[3246, 125, 159, 4, 70, "Text",
      CellTags->"overview"],
    Cell[3442, 134, 301, 10, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[3746, 146, 141, 4, 70, "Input",
      CellTags->"overview"],
    Cell[3936, 156, 159, 6, 70, "SubsectionIcon",
      CellTags->"overview"],
    Cell[4098, 164, 89, 1, 70, "Text",
      CellTags->"overview"],
    Cell[4212, 169, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[4270, 172, 90, 2, 70, "Input",
      CellTags->"overview"],
    Cell[4363, 176, 153, 4, 70, "Text",
      CellTags->"overview"],
    Cell[4553, 185, 971, 34, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[5527, 221, 135, 4, 70, "Input",
      CellTags->"overview"],
    Cell[5665, 227, 118, 4, 70, "Text",
      CellTags->"overview"],
    Cell[5820, 236, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[5878, 239, 93, 2, 70, "Input",
      CellTags->"overview"],
    Cell[5974, 243, 173, 4, 70, "Text",
      CellTags->"overview"],
    Cell[6184, 252, 301, 10, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[6488, 264, 93, 2, 70, "Input",
      CellTags->"overview"],
    Cell[6630, 272, 158, 6, 70, "SubsectionIcon",
      CellTags->"overview"],
    Cell[6791, 280, 146, 4, 70, "Text",
      CellTags->"overview"],
    Cell[6962, 288, 1006, 36, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[7971, 326, 123, 4, 70, "Input",
      CellTags->"overview"],
    Cell[8097, 332, 98, 1, 70, "Text",
      CellTags->"overview"],
    Cell[8232, 338, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[8290, 341, 92, 2, 70, "Input",
      CellTags->"overview"],
    Cell[8385, 345, 138, 4, 70, "Text",
      CellTags->"overview"],
    Cell[8560, 354, 335, 12, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[8898, 368, 92, 2, 70, "Input",
      CellTags->"overview"],
    Cell[9039, 376, 161, 6, 70, "SubsectionIcon",
      CellTags->"overview"],
    Cell[9203, 384, 137, 4, 70, "Text",
      CellTags->"overview"],
    Cell[9365, 392, 1039, 38, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[10407, 432, 123, 4, 70, "Input",
      CellTags->"overview"],
    Cell[10533, 438, 120, 4, 70, "Text",
      CellTags->"overview"],
    Cell[10690, 447, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[10748, 450, 92, 2, 70, "Input",
      CellTags->"overview"],
    Cell[10843, 454, 111, 4, 70, "Text",
      CellTags->"overview"],
    Cell[10991, 463, 1005, 36, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[11999, 501, 131, 4, 70, "Input",
      CellTags->"overview"],
    Cell[12133, 507, 56, 1, 70, "Text",
      CellTags->"overview"],
    Cell[12226, 513, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[12284, 516, 95, 2, 70, "Input",
      CellTags->"overview"],
    Cell[12382, 520, 162, 4, 70, "Text",
      CellTags->"overview"],
    Cell[12581, 529, 335, 12, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[12919, 543, 95, 2, 70, "Input",
      CellTags->"overview"],
    Cell[13063, 551, 266, 10, 70, "SubsectionIcon",
      CellTags->"overview"],
    Cell[13332, 563, 149, 4, 70, "Text",
      CellTags->"overview"],
    Cell[13506, 571, 148, 6, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[13657, 579, 85, 2, 70, "Input",
      CellTags->"overview"],
    Cell[13745, 583, 170, 4, 70, "Text",
      CellTags->"overview"],
    Cell[13952, 592, 361, 13, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[14316, 607, 186, 6, 70, "Input",
      CellTags->"overview"],
    Cell[14505, 615, 204, 5, 70, "Text",
      CellTags->"overview"],
    Cell[14746, 625, 575, 20, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[15324, 647, 221, 7, 70, "Input",
      CellTags->"overview"],
    Cell[15548, 656, 178, 5, 70, "Text",
      CellTags->"overview"],
    Cell[15763, 666, 291, 11, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[16057, 679, 208, 7, 70, "Input",
      CellTags->"overview"],
    Cell[16268, 688, 176, 4, 70, "Text",
      CellTags->"overview"],
    Cell[16481, 697, 309, 10, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[16793, 709, 185, 6, 70, "Input",
      CellTags->"overview"],
    Cell[16981, 717, 90, 1, 70, "Text",
      CellTags->"overview"],
    Cell[17108, 723, 140, 6, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[17251, 731, 185, 6, 70, "Input",
      CellTags->"overview"],
    Cell[17485, 743, 159, 6, 70, "SubsectionIcon",
      CellTags->"overview"],
    Cell[17647, 751, 86, 1, 70, "Text",
      CellTags->"overview"],
    Cell[17758, 756, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[17816, 759, 90, 2, 70, "Input",
      CellTags->"overview"],
    Cell[17909, 763, 144, 4, 70, "Text",
      CellTags->"overview"],
    Cell[18090, 772, 985, 34, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[19078, 808, 133, 4, 70, "Input",
      CellTags->"overview"],
    Cell[19214, 814, 119, 4, 70, "Text",
      CellTags->"overview"],
    Cell[19370, 823, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[19428, 826, 93, 2, 70, "Input",
      CellTags->"overview"],
    Cell[19524, 830, 183, 5, 70, "Text",
      CellTags->"overview"],
    Cell[19744, 840, 301, 10, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[20048, 852, 93, 2, 70, "Input",
      CellTags->"overview"],
    Cell[20190, 860, 159, 6, 70, "SubsectionIcon",
      CellTags->"overview"],
    Cell[20352, 868, 88, 1, 70, "Text",
      CellTags->"overview"],
    Cell[20465, 873, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[20523, 876, 90, 2, 70, "Input",
      CellTags->"overview"],
    Cell[20616, 880, 150, 4, 70, "Text",
      CellTags->"overview"],
    Cell[20803, 889, 1053, 38, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[21859, 929, 135, 4, 70, "Input",
      CellTags->"overview"],
    Cell[21997, 935, 121, 4, 70, "Text",
      CellTags->"overview"],
    Cell[22155, 944, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[22213, 947, 93, 2, 70, "Input",
      CellTags->"overview"],
    Cell[22309, 951, 187, 5, 70, "Text",
      CellTags->"overview"],
    Cell[22533, 961, 301, 10, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[22837, 973, 93, 2, 70, "Input",
      CellTags->"overview"],
    Cell[22979, 981, 159, 6, 70, "SubsectionIcon",
      CellTags->"overview"],
    Cell[23141, 989, 91, 1, 70, "Text",
      CellTags->"overview"],
    Cell[23257, 994, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[23315, 997, 90, 2, 70, "Input",
      CellTags->"overview"],
    Cell[23408, 1001, 147, 4, 70, "Text",
      CellTags->"overview"],
    Cell[23592, 1010, 985, 34, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[24580, 1046, 135, 4, 70, "Input",
      CellTags->"overview"],
    Cell[24718, 1052, 119, 4, 70, "Text",
      CellTags->"overview"],
    Cell[24874, 1061, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[24932, 1064, 93, 2, 70, "Input",
      CellTags->"overview"],
    Cell[25028, 1068, 185, 5, 70, "Text",
      CellTags->"overview"],
    Cell[25250, 1078, 301, 10, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[25554, 1090, 93, 2, 70, "Input",
      CellTags->"overview"],
    Cell[25696, 1098, 159, 6, 70, "SubsectionIcon",
      CellTags->"overview"],
    Cell[25858, 1106, 90, 1, 70, "Text",
      CellTags->"overview"],
    Cell[25973, 1111, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[26031, 1114, 90, 2, 70, "Input",
      CellTags->"overview"],
    Cell[26124, 1118, 146, 4, 70, "Text",
      CellTags->"overview"],
    Cell[26307, 1127, 985, 34, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[27295, 1163, 134, 4, 70, "Input",
      CellTags->"overview"],
    Cell[27432, 1169, 119, 4, 70, "Text",
      CellTags->"overview"],
    Cell[27588, 1178, 55, 1, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[27646, 1181, 93, 2, 70, "Input",
      CellTags->"overview"],
    Cell[27742, 1185, 186, 5, 70, "Text",
      CellTags->"overview"],
    Cell[27965, 1195, 301, 10, 70, "Subsubsection",
      CellTags->"overview"],
    Cell[28269, 1207, 93, 2, 70, "Input",
      CellTags->"overview"]},
  "fractions"->{
    Cell[28423, 1216, 53, 1, 38, "Section",
      CellTags->"fractions"],
    Cell[28501, 1221, 160, 6, 70, "SubsectionIcon",
      CellTags->"fractions"],
    Cell[28664, 1229, 95, 1, 70, "Text",
      CellTags->"fractions"],
    Cell[28784, 1234, 56, 1, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[28843, 1237, 137, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[28983, 1243, 193, 5, 70, "Text",
      CellTags->"fractions"],
    Cell[29213, 1253, 517, 18, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[29733, 1273, 133, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[29869, 1279, 66, 1, 70, "Text",
      CellTags->"fractions"],
    Cell[29972, 1285, 56, 1, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[30031, 1288, 166, 5, 70, "Input",
      CellTags->"fractions"],
    Cell[30200, 1295, 160, 4, 70, "Text",
      CellTags->"fractions"],
    Cell[30397, 1304, 302, 10, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[30702, 1316, 142, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[30893, 1326, 164, 6, 70, "SubsectionIcon",
      CellTags->"fractions"],
    Cell[31060, 1334, 80, 1, 70, "Text",
      CellTags->"fractions"],
    Cell[31165, 1339, 777, 26, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[31945, 1367, 142, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[32090, 1373, 124, 4, 70, "Text",
      CellTags->"fractions"],
    Cell[32251, 1382, 57, 1, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[32311, 1385, 146, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[32506, 1395, 168, 6, 70, "SubsectionIcon",
      CellTags->"fractions"],
    Cell[32677, 1403, 89, 1, 70, "Text",
      CellTags->"fractions"],
    Cell[32791, 1408, 539, 19, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[33333, 1429, 166, 5, 70, "Input",
      CellTags->"fractions"],
    Cell[33502, 1436, 121, 4, 70, "Text",
      CellTags->"fractions"],
    Cell[33660, 1445, 311, 10, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[33974, 1457, 150, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[34173, 1467, 168, 6, 70, "SubsectionIcon",
      CellTags->"fractions"],
    Cell[34344, 1475, 190, 5, 70, "Text",
      CellTags->"fractions"],
    Cell[34559, 1484, 517, 18, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[35079, 1504, 146, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[35228, 1510, 78, 1, 70, "Text",
      CellTags->"fractions"],
    Cell[35343, 1516, 58, 1, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[35404, 1519, 185, 5, 70, "Input",
      CellTags->"fractions"],
    Cell[35592, 1526, 206, 5, 70, "Text",
      CellTags->"fractions"],
    Cell[35835, 1536, 278, 10, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[36116, 1548, 139, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[36258, 1554, 121, 4, 70, "Text",
      CellTags->"fractions"],
    Cell[36416, 1563, 310, 10, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[36729, 1575, 102, 2, 70, "Input",
      CellTags->"fractions"],
    Cell[36880, 1583, 176, 6, 70, "SubsectionIcon",
      CellTags->"fractions"],
    Cell[37059, 1591, 95, 1, 70, "Text",
      CellTags->"fractions"],
    Cell[37179, 1596, 58, 1, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[37240, 1599, 143, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[37386, 1605, 184, 5, 70, "Text",
      CellTags->"fractions"],
    Cell[37607, 1615, 59, 1, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[37669, 1618, 99, 3, 70, "Input",
      CellTags->"fractions"],
    Cell[37771, 1623, 95, 1, 70, "Text",
      CellTags->"fractions"],
    Cell[37903, 1629, 320, 11, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[38226, 1642, 139, 4, 70, "Input",
      CellTags->"fractions"],
    Cell[38368, 1648, 121, 4, 70, "Text",
      CellTags->"fractions"],
    Cell[38526, 1657, 310, 10, 70, "Subsubsection",
      CellTags->"fractions"],
    Cell[38839, 1669, 102, 2, 70, "Input",
      CellTags->"fractions"]},
  "powers"->{
    Cell[39002, 1678, 47, 1, 38, "Section",
      CellTags->"powers"],
    Cell[39074, 1683, 157, 6, 70, "SubsectionIcon",
      CellTags->"powers"],
    Cell[39234, 1691, 87, 1, 70, "Text",
      CellTags->"powers"],
    Cell[39346, 1696, 53, 1, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[39402, 1699, 88, 2, 70, "Input",
      CellTags->"powers"],
    Cell[39493, 1703, 151, 4, 70, "Text",
      CellTags->"powers"],
    Cell[39681, 1712, 969, 34, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[40653, 1748, 133, 4, 70, "Input",
      CellTags->"powers"],
    Cell[40789, 1754, 116, 4, 70, "Text",
      CellTags->"powers"],
    Cell[40942, 1763, 53, 1, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[40998, 1766, 91, 2, 70, "Input",
      CellTags->"powers"],
    Cell[41092, 1770, 171, 5, 70, "Text",
      CellTags->"powers"],
    Cell[41300, 1780, 299, 10, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[41602, 1792, 91, 2, 70, "Input",
      CellTags->"powers"],
    Cell[41742, 1800, 164, 6, 70, "SubsectionIcon",
      CellTags->"powers"],
    Cell[41909, 1808, 77, 1, 70, "Text",
      CellTags->"powers"],
    Cell[42011, 1813, 774, 26, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[42788, 1841, 139, 4, 70, "Input",
      CellTags->"powers"],
    Cell[42930, 1847, 77, 1, 70, "Text",
      CellTags->"powers"],
    Cell[43044, 1853, 775, 26, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[43822, 1881, 98, 2, 70, "Input",
      CellTags->"powers"],
    Cell[43969, 1889, 165, 6, 70, "SubsectionIcon",
      CellTags->"powers"],
    Cell[44137, 1897, 87, 1, 70, "Text",
      CellTags->"powers"],
    Cell[44249, 1902, 522, 18, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[44774, 1922, 133, 4, 70, "Input",
      CellTags->"powers"],
    Cell[44910, 1928, 94, 1, 70, "Text",
      CellTags->"powers"],
    Cell[45041, 1934, 309, 10, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[45353, 1946, 99, 2, 70, "Input",
      CellTags->"powers"],
    Cell[45501, 1954, 164, 6, 70, "SubsectionIcon",
      CellTags->"powers"],
    Cell[45668, 1962, 89, 1, 70, "Text",
      CellTags->"powers"],
    Cell[45782, 1967, 536, 19, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[46321, 1988, 91, 2, 70, "Input",
      CellTags->"powers"],
    Cell[46415, 1992, 85, 1, 70, "Text",
      CellTags->"powers"],
    Cell[46537, 1998, 365, 14, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[46905, 2014, 98, 2, 70, "Input",
      CellTags->"powers"],
    Cell[47006, 2018, 93, 1, 70, "Text",
      CellTags->"powers"],
    Cell[47136, 2024, 311, 11, 70, "Subsubsection",
      CellTags->"powers"],
    Cell[47450, 2037, 98, 2, 70, "Input",
      CellTags->"powers"]},
  "squareroots"->{
    Cell[47609, 2046, 58, 1, 38, "Section",
      CellTags->"squareroots"],
    Cell[47692, 2051, 161, 6, 70, "SubsectionIcon",
      CellTags->"squareroots"],
    Cell[47856, 2059, 149, 4, 70, "Text",
      CellTags->"squareroots"],
    Cell[48030, 2067, 974, 34, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[49007, 2103, 126, 4, 70, "Input",
      CellTags->"squareroots"],
    Cell[49136, 2109, 101, 1, 70, "Text",
      CellTags->"squareroots"],
    Cell[49274, 2115, 58, 1, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[49335, 2118, 95, 2, 70, "Input",
      CellTags->"squareroots"],
    Cell[49433, 2122, 141, 4, 70, "Text",
      CellTags->"squareroots"],
    Cell[49611, 2131, 304, 10, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[49918, 2143, 95, 2, 70, "Input",
      CellTags->"squareroots"],
    Cell[50062, 2151, 169, 6, 70, "SubsectionIcon",
      CellTags->"squareroots"],
    Cell[50234, 2159, 183, 7, 70, "Text",
      CellTags->"squareroots"],
    Cell[50442, 2170, 805, 28, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[51250, 2200, 95, 2, 70, "Input",
      CellTags->"squareroots"],
    Cell[51348, 2204, 101, 1, 70, "Text",
      CellTags->"squareroots"],
    Cell[51486, 2210, 805, 28, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[52294, 2240, 103, 2, 70, "Input",
      CellTags->"squareroots"],
    Cell[52446, 2248, 168, 6, 70, "SubsectionIcon",
      CellTags->"squareroots"],
    Cell[52617, 2256, 86, 1, 70, "Text",
      CellTags->"squareroots"],
    Cell[52728, 2261, 553, 20, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[53284, 2283, 126, 4, 70, "Input",
      CellTags->"squareroots"],
    Cell[53413, 2289, 179, 4, 70, "Text",
      CellTags->"squareroots"],
    Cell[53629, 2298, 314, 10, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[53946, 2310, 102, 2, 70, "Input",
      CellTags->"squareroots"],
    Cell[54097, 2318, 176, 6, 70, "SubsectionIcon",
      CellTags->"squareroots"],
    Cell[54276, 2326, 121, 4, 70, "Text",
      CellTags->"squareroots"],
    Cell[54422, 2334, 60, 1, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[54485, 2337, 64, 2, 70, "Input",
      CellTags->"squareroots"],
    Cell[54552, 2341, 186, 5, 70, "Text",
      CellTags->"squareroots"],
    Cell[54775, 2351, 62, 1, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[54840, 2354, 100, 3, 70, "Input",
      CellTags->"squareroots"],
    Cell[54943, 2359, 166, 4, 70, "Text",
      CellTags->"squareroots"],
    Cell[55146, 2368, 634, 23, 70, "Subsubsection",
      CellTags->"squareroots"],
    Cell[55783, 2393, 102, 2, 70, "Input",
      CellTags->"squareroots"]},
  "radicals"->{
    Cell[55946, 2402, 51, 1, 38, "Section",
      CellTags->"radicals"],
    Cell[56022, 2407, 161, 6, 70, "SubsectionIcon",
      CellTags->"radicals"],
    Cell[56186, 2415, 137, 4, 70, "Text",
      CellTags->"radicals"],
    Cell[56348, 2423, 971, 34, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[57322, 2459, 123, 4, 70, "Input",
      CellTags->"radicals"],
    Cell[57448, 2465, 120, 4, 70, "Text",
      CellTags->"radicals"],
    Cell[57605, 2474, 55, 1, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[57663, 2477, 92, 2, 70, "Input",
      CellTags->"radicals"],
    Cell[57758, 2481, 111, 4, 70, "Text",
      CellTags->"radicals"],
    Cell[57906, 2490, 972, 34, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[58881, 2526, 131, 4, 70, "Input",
      CellTags->"radicals"],
    Cell[59015, 2532, 56, 1, 70, "Text",
      CellTags->"radicals"],
    Cell[59108, 2538, 55, 1, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[59166, 2541, 95, 2, 70, "Input",
      CellTags->"radicals"],
    Cell[59264, 2545, 162, 4, 70, "Text",
      CellTags->"radicals"],
    Cell[59463, 2554, 301, 10, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[59767, 2566, 95, 2, 70, "Input",
      CellTags->"radicals"],
    Cell[59911, 2574, 172, 6, 70, "SubsectionIcon",
      CellTags->"radicals"],
    Cell[60086, 2582, 189, 7, 70, "Text",
      CellTags->"radicals"],
    Cell[60300, 2593, 1269, 44, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[61572, 2639, 95, 2, 70, "Input",
      CellTags->"radicals"],
    Cell[61670, 2643, 98, 1, 70, "Text",
      CellTags->"radicals"],
    Cell[61805, 2649, 1269, 44, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[63077, 2695, 106, 2, 70, "Input",
      CellTags->"radicals"],
    Cell[63232, 2703, 168, 6, 70, "SubsectionIcon",
      CellTags->"radicals"],
    Cell[63403, 2711, 79, 1, 70, "Text",
      CellTags->"radicals"],
    Cell[63507, 2716, 516, 18, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[64026, 2736, 123, 4, 70, "Input",
      CellTags->"radicals"],
    Cell[64152, 2742, 155, 4, 70, "Text",
      CellTags->"radicals"],
    Cell[64344, 2751, 535, 18, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[64882, 2771, 136, 4, 70, "Input",
      CellTags->"radicals"],
    Cell[65021, 2777, 189, 5, 70, "Text",
      CellTags->"radicals"],
    Cell[65247, 2787, 309, 10, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[65559, 2799, 102, 2, 70, "Input",
      CellTags->"radicals"],
    Cell[65710, 2807, 176, 6, 70, "SubsectionIcon",
      CellTags->"radicals"],
    Cell[65889, 2815, 118, 4, 70, "Text",
      CellTags->"radicals"],
    Cell[66032, 2823, 57, 1, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[66092, 2826, 61, 2, 70, "Input",
      CellTags->"radicals"],
    Cell[66156, 2830, 183, 5, 70, "Text",
      CellTags->"radicals"],
    Cell[66376, 2840, 59, 1, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[66438, 2843, 97, 3, 70, "Input",
      CellTags->"radicals"],
    Cell[66538, 2848, 156, 4, 70, "Text",
      CellTags->"radicals"],
    Cell[66731, 2857, 760, 26, 70, "Subsubsection",
      CellTags->"radicals"],
    Cell[67494, 2885, 99, 2, 70, "Input",
      CellTags->"radicals"]},
  "vectors"->{
    Cell[67654, 2894, 49, 1, 38, "Section",
      CellTags->"vectors"],
    Cell[67728, 2899, 270, 10, 70, "SubsectionIcon",
      CellTags->"vectors"],
    Cell[68001, 2911, 148, 4, 70, "Text",
      CellTags->"vectors"],
    Cell[68174, 2919, 147, 6, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[68324, 2927, 84, 2, 70, "Input",
      CellTags->"vectors"],
    Cell[68411, 2931, 171, 4, 70, "Text",
      CellTags->"vectors"],
    Cell[68619, 2940, 523, 18, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[69145, 2960, 185, 6, 70, "Input",
      CellTags->"vectors"],
    Cell[69333, 2968, 171, 4, 70, "Text",
      CellTags->"vectors"],
    Cell[69541, 2977, 522, 18, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[70066, 2997, 190, 6, 70, "Input",
      CellTags->"vectors"],
    Cell[70293, 3008, 523, 18, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[71051, 3039, 54, 1, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[71108, 3042, 155, 4, 70, "Input",
      CellTags->"vectors"],
    Cell[71266, 3048, 133, 4, 70, "Text",
      CellTags->"vectors"],
    Cell[71436, 3057, 300, 10, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[71739, 3069, 170, 5, 70, "Input",
      CellTags->"vectors"],
    Cell[71912, 3076, 90, 1, 70, "Text",
      CellTags->"vectors"],
    Cell[72039, 3082, 139, 6, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[72181, 3090, 170, 5, 70, "Input",
      CellTags->"vectors"],
    Cell[72400, 3101, 315, 12, 70, "SubsectionIcon",
      CellTags->"vectors"],
    Cell[72718, 3115, 147, 4, 70, "Text",
      CellTags->"vectors"],
    Cell[72890, 3123, 147, 6, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[73040, 3131, 84, 2, 70, "Input",
      CellTags->"vectors"],
    Cell[73127, 3135, 172, 4, 70, "Text",
      CellTags->"vectors"],
    Cell[73336, 3144, 540, 18, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[73879, 3164, 197, 7, 70, "Input",
      CellTags->"vectors"],
    Cell[74079, 3173, 174, 5, 70, "Text",
      CellTags->"vectors"],
    Cell[74290, 3183, 411, 15, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[74704, 3200, 214, 8, 70, "Input",
      CellTags->"vectors"],
    Cell[74955, 3213, 377, 13, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[75335, 3228, 231, 9, 70, "Input",
      CellTags->"vectors"],
    Cell[75603, 3242, 54, 1, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[75660, 3245, 191, 7, 70, "Input",
      CellTags->"vectors"],
    Cell[75854, 3254, 133, 4, 70, "Text",
      CellTags->"vectors"],
    Cell[76024, 3263, 300, 10, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[76327, 3275, 212, 8, 70, "Input",
      CellTags->"vectors"],
    Cell[76646, 3290, 139, 6, 70, "Subsubsection",
      CellTags->"vectors"],
    Cell[76788, 3298, 212, 8, 70, "Input",
      CellTags->"vectors"]},
  "matrices"->{
    Cell[77061, 3313, 51, 1, 38, "Section",
      CellTags->"matrices"],
    Cell[77137, 3318, 76, 1, 70, "SubsectionIcon",
      CellTags->"matrices"],
    Cell[77216, 3321, 257, 10, 70, "Text",
      CellTags->"matrices"],
    Cell[77476, 3333, 302, 7, 70, "Input",
      CellTags->"matrices"],
    Cell[77815, 3345, 77, 1, 70, "SubsectionIcon",
      CellTags->"matrices"],
    Cell[77895, 3348, 289, 7, 70, "Text",
      CellTags->"matrices"],
    Cell[78187, 3357, 247, 7, 70, "Input",
      CellTags->"matrices"],
    Cell[78459, 3368, 285, 10, 70, "Subsubsection",
      CellTags->"matrices"],
    Cell[78747, 3380, 234, 7, 70, "Input",
      CellTags->"matrices"],
    Cell[79018, 3392, 285, 10, 70, "Subsubsection",
      CellTags->"matrices"],
    Cell[79306, 3404, 221, 7, 70, "Input",
      CellTags->"matrices"],
    Cell[79564, 3416, 319, 12, 70, "Subsubsection",
      CellTags->"matrices"],
    Cell[79886, 3430, 208, 7, 70, "Input",
      CellTags->"matrices"],
    Cell[80097, 3439, 133, 4, 70, "Text",
      CellTags->"matrices"],
    Cell[80267, 3448, 309, 10, 70, "Subsubsection",
      CellTags->"matrices"],
    Cell[80579, 3460, 185, 6, 70, "Input",
      CellTags->"matrices"],
    Cell[80767, 3468, 90, 1, 70, "Text",
      CellTags->"matrices"],
    Cell[80894, 3474, 140, 6, 70, "Subsubsection",
      CellTags->"matrices"],
    Cell[81037, 3482, 185, 6, 70, "Input",
      CellTags->"matrices"],
    Cell[81271, 3494, 73, 1, 70, "SubsectionIcon",
      CellTags->"matrices"],
    Cell[81347, 3497, 174, 4, 70, "Text",
      CellTags->"matrices"],
    Cell[81524, 3503, 168, 5, 70, "Input",
      CellTags->"matrices"],
    Cell[81695, 3510, 166, 4, 70, "Text",
      CellTags->"matrices"],
    Cell[81864, 3516, 570, 21, 70, "Text",
      CellTags->"matrices"],
    Cell[82437, 3539, 231, 7, 70, "Input",
      CellTags->"matrices"],
    Cell[82705, 3551, 70, 1, 70, "SubsectionIcon",
      CellTags->"matrices"],
    Cell[82778, 3554, 174, 4, 70, "Text",
      CellTags->"matrices"],
    Cell[82955, 3560, 168, 5, 70, "Input",
      CellTags->"matrices"],
    Cell[83126, 3567, 166, 4, 70, "Text",
      CellTags->"matrices"],
    Cell[83317, 3575, 724, 24, 70, "Subsubsection",
      CellTags->"matrices"],
    Cell[84044, 3601, 243, 8, 70, "Input",
      CellTags->"matrices"]},
  "superscripts"->{
    Cell[84348, 3616, 59, 1, 38, "Section",
      CellTags->"superscripts"],
    Cell[84432, 3621, 163, 6, 70, "SubsectionIcon",
      CellTags->"superscripts"],
    Cell[84598, 3629, 92, 1, 70, "Text",
      CellTags->"superscripts"],
    Cell[84715, 3634, 59, 1, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[84777, 3637, 94, 2, 70, "Input",
      CellTags->"superscripts"],
    Cell[84874, 3641, 154, 4, 70, "Text",
      CellTags->"superscripts"],
    Cell[85065, 3650, 989, 34, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[86057, 3686, 139, 4, 70, "Input",
      CellTags->"superscripts"],
    Cell[86199, 3692, 125, 4, 70, "Text",
      CellTags->"superscripts"],
    Cell[86361, 3701, 59, 1, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[86423, 3704, 97, 2, 70, "Input",
      CellTags->"superscripts"],
    Cell[86523, 3708, 191, 6, 70, "Text",
      CellTags->"superscripts"],
    Cell[86751, 3719, 305, 10, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[87059, 3731, 97, 2, 70, "Input",
      CellTags->"superscripts"],
    Cell[87205, 3739, 170, 6, 70, "SubsectionIcon",
      CellTags->"superscripts"],
    Cell[87378, 3747, 245, 7, 70, "Text",
      CellTags->"superscripts"],
    Cell[87648, 3758, 528, 18, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[88179, 3778, 139, 4, 70, "Input",
      CellTags->"superscripts"],
    Cell[88355, 3787, 305, 11, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[88663, 3800, 100, 2, 70, "Input",
      CellTags->"superscripts"],
    Cell[88800, 3807, 305, 10, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[89108, 3819, 104, 2, 70, "Input",
      CellTags->"superscripts"],
    Cell[89261, 3827, 185, 6, 70, "SubsectionIcon",
      CellTags->"superscripts"],
    Cell[89449, 3835, 94, 1, 70, "Text",
      CellTags->"superscripts"],
    Cell[89568, 3840, 528, 18, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[90099, 3860, 139, 4, 70, "Input",
      CellTags->"superscripts"],
    Cell[90241, 3866, 285, 4, 70, "Text",
      CellTags->"superscripts"],
    Cell[90563, 3875, 543, 19, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[91109, 3896, 119, 2, 70, "Input",
      CellTags->"superscripts"],
    Cell[91231, 3900, 129, 4, 70, "Text",
      CellTags->"superscripts"],
    Cell[91397, 3909, 305, 10, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[91705, 3921, 119, 2, 70, "Input",
      CellTags->"superscripts"],
    Cell[91873, 3929, 166, 6, 70, "SubsectionIcon",
      CellTags->"superscripts"],
    Cell[92042, 3937, 130, 4, 70, "Text",
      CellTags->"superscripts"],
    Cell[92197, 3945, 528, 18, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[92728, 3965, 139, 4, 70, "Input",
      CellTags->"superscripts"],
    Cell[92904, 3974, 528, 18, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[93435, 3994, 169, 5, 70, "Input",
      CellTags->"superscripts"],
    Cell[93641, 4004, 59, 1, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[93703, 4007, 100, 2, 70, "Input",
      CellTags->"superscripts"],
    Cell[93806, 4011, 101, 1, 70, "Text",
      CellTags->"superscripts"],
    Cell[93944, 4017, 317, 11, 70, "Subsubsection",
      CellTags->"superscripts"],
    Cell[94264, 4030, 100, 2, 70, "Input",
      CellTags->"superscripts"],
    Cell[94367, 4034, 100, 2, 70, "Input",
      CellTags->"superscripts"]},
  "subscripts"->{
    Cell[94528, 4043, 55, 1, 38, "Section",
      CellTags->"subscripts"],
    Cell[94608, 4048, 161, 6, 46, "SubsectionIcon",
      CellTags->"subscripts"],
    Cell[94794, 4058, 179, 6, 34, "Subsubsection",
      CellTags->"subscripts"],
    Cell[94976, 4066, 117, 3, 24, "Text",
      CellTags->"subscripts"],
    Cell[95096, 4071, 92, 2, 26, "Input",
      CellTags->"subscripts"],
    Cell[95225, 4078, 359, 12, 34, "Subsubsection",
      CellTags->"subscripts"],
    Cell[95587, 4092, 1110, 41, 27, "Text",
      CellTags->"subscripts"],
    Cell[96700, 4135, 135, 4, 26, "Input",
      CellTags->"subscripts"],
    Cell[96872, 4144, 204, 7, 34, "Subsubsection",
      CellTags->"subscripts"],
    Cell[97079, 4153, 117, 3, 24, "Text",
      CellTags->"subscripts"],
    Cell[97199, 4158, 95, 2, 27, "Input",
      CellTags->"subscripts"],
    Cell[97331, 4165, 266, 7, 50, "Subsubsection",
      CellTags->"subscripts"],
    Cell[97600, 4174, 363, 13, 30, "Text",
      CellTags->"subscripts"],
    Cell[97966, 4189, 95, 2, 26, "Input",
      CellTags->"subscripts"],
    Cell[98110, 4197, 168, 6, 38, "SubsectionIcon",
      CellTags->"subscripts"],
    Cell[98303, 4207, 556, 20, 34, "Subsubsection",
      CellTags->"subscripts"],
    Cell[98862, 4229, 580, 21, 27, "Text",
      CellTags->"subscripts"],
    Cell[99445, 4252, 135, 4, 26, "Input",
      CellTags->"subscripts"],
    Cell[99583, 4258, 501, 20, 30, "Text",
      CellTags->"subscripts"],
    Cell[100087, 4280, 98, 2, 27, "Input",
      CellTags->"subscripts"],
    Cell[100188, 4284, 391, 14, 30, "Text",
      CellTags->"subscripts"],
    Cell[100582, 4300, 102, 2, 26, "Input",
      CellTags->"subscripts"],
    Cell[100733, 4308, 183, 6, 36, "SubsectionIcon",
      CellTags->"subscripts"],
    Cell[100919, 4316, 92, 1, 24, "Text",
      CellTags->"subscripts"],
    Cell[101036, 4321, 526, 18, 40, "Subsubsection",
      CellTags->"subscripts"],
    Cell[101565, 4341, 135, 4, 26, "Input",
      CellTags->"subscripts"],
    Cell[101703, 4347, 281, 4, 40, "Text",
      CellTags->"subscripts"],
    Cell[102021, 4356, 541, 19, 40, "Subsubsection",
      CellTags->"subscripts"],
    Cell[102565, 4377, 117, 2, 27, "Input",
      CellTags->"subscripts"],
    Cell[102685, 4381, 125, 4, 24, "Text",
      CellTags->"subscripts"],
    Cell[102847, 4390, 303, 10, 40, "Subsubsection",
      CellTags->"subscripts"],
    Cell[103153, 4402, 117, 2, 26, "Input",
      CellTags->"subscripts"],
    Cell[103319, 4410, 168, 6, 41, "SubsectionIcon",
      CellTags->"subscripts"],
    Cell[103490, 4418, 126, 4, 24, "Text",
      CellTags->"subscripts"],
    Cell[103641, 4426, 526, 18, 40, "Subsubsection",
      CellTags->"subscripts"],
    Cell[104170, 4446, 135, 4, 26, "Input",
      CellTags->"subscripts"],
    Cell[104308, 4452, 586, 21, 30, "Text",
      CellTags->"subscripts"],
    Cell[104897, 4475, 165, 5, 27, "Input",
      CellTags->"subscripts"],
    Cell[105099, 4485, 57, 1, 34, "Subsubsection",
      CellTags->"subscripts"],
    Cell[105159, 4488, 102, 2, 30, "Input",
      CellTags->"subscripts"],
    Cell[105264, 4492, 118, 4, 24, "Text",
      CellTags->"subscripts"],
    Cell[105419, 4501, 315, 11, 40, "Subsubsection",
      CellTags->"subscripts"],
    Cell[105737, 4514, 98, 2, 28, "Input",
      CellTags->"subscripts"],
    Cell[105838, 4518, 102, 2, 28, "Input",
      CellTags->"subscripts"]},
  "overscripts"->{
    Cell[106001, 4527, 57, 1, 38, "Section",
      CellTags->"overscripts"],
    Cell[106083, 4532, 162, 6, 70, "SubsectionIcon",
      CellTags->"overscripts"],
    Cell[106248, 4540, 93, 1, 70, "Text",
      CellTags->"overscripts"],
    Cell[106366, 4545, 58, 1, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[106427, 4548, 93, 2, 70, "Input",
      CellTags->"overscripts"],
    Cell[106523, 4552, 150, 4, 70, "Text",
      CellTags->"overscripts"],
    Cell[106710, 4561, 988, 34, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[107701, 4597, 137, 4, 70, "Input",
      CellTags->"overscripts"],
    Cell[107841, 4603, 122, 4, 70, "Text",
      CellTags->"overscripts"],
    Cell[108000, 4612, 58, 1, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[108061, 4615, 96, 2, 70, "Input",
      CellTags->"overscripts"],
    Cell[108160, 4619, 189, 5, 70, "Text",
      CellTags->"overscripts"],
    Cell[108386, 4629, 304, 10, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[108693, 4641, 96, 2, 70, "Input",
      CellTags->"overscripts"],
    Cell[108838, 4649, 170, 6, 70, "SubsectionIcon",
      CellTags->"overscripts"],
    Cell[109011, 4657, 221, 5, 70, "Text",
      CellTags->"overscripts"],
    Cell[109257, 4666, 974, 34, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[110234, 4702, 150, 4, 70, "Input",
      CellTags->"overscripts"],
    Cell[110387, 4708, 140, 4, 70, "Text",
      CellTags->"overscripts"],
    Cell[110564, 4717, 58, 1, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[110625, 4720, 109, 2, 70, "Input",
      CellTags->"overscripts"],
    Cell[110737, 4724, 128, 4, 70, "Text",
      CellTags->"overscripts"],
    Cell[110902, 4733, 280, 10, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[111185, 4745, 137, 4, 70, "Input",
      CellTags->"overscripts"],
    Cell[111325, 4751, 85, 1, 70, "Text",
      CellTags->"overscripts"],
    Cell[111447, 4757, 60, 1, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[111510, 4760, 100, 2, 70, "Input",
      CellTags->"overscripts"],
    Cell[111613, 4764, 116, 4, 70, "Text",
      CellTags->"overscripts"],
    Cell[111766, 4773, 304, 10, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[112073, 4785, 104, 2, 70, "Input",
      CellTags->"overscripts"],
    Cell[112226, 4793, 178, 6, 70, "SubsectionIcon",
      CellTags->"overscripts"],
    Cell[112429, 4803, 60, 1, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[112492, 4806, 65, 2, 70, "Input",
      CellTags->"overscripts"],
    Cell[112560, 4810, 186, 5, 70, "Text",
      CellTags->"overscripts"],
    Cell[112783, 4820, 62, 1, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[112848, 4823, 101, 3, 70, "Input",
      CellTags->"overscripts"],
    Cell[112952, 4828, 143, 4, 70, "Text",
      CellTags->"overscripts"],
    Cell[113132, 4837, 519, 18, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[113654, 4857, 143, 4, 70, "Input",
      CellTags->"overscripts"],
    Cell[113800, 4863, 90, 1, 70, "Text",
      CellTags->"overscripts"],
    Cell[113927, 4869, 58, 1, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[113988, 4872, 104, 2, 70, "Input",
      CellTags->"overscripts"],
    Cell[114095, 4876, 96, 1, 70, "Text",
      CellTags->"overscripts"],
    Cell[114228, 4882, 304, 10, 70, "Subsubsection",
      CellTags->"overscripts"],
    Cell[114535, 4894, 104, 2, 70, "Input",
      CellTags->"overscripts"]},
  "underscripts"->{
    Cell[114700, 4903, 59, 1, 38, "Section",
      CellTags->"underscripts"],
    Cell[114784, 4908, 163, 6, 70, "SubsectionIcon",
      CellTags->"underscripts"],
    Cell[114950, 4916, 95, 1, 70, "Text",
      CellTags->"underscripts"],
    Cell[115070, 4921, 59, 1, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[115132, 4924, 94, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[115229, 4928, 151, 4, 70, "Text",
      CellTags->"underscripts"],
    Cell[115417, 4937, 989, 34, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[116409, 4973, 139, 4, 70, "Input",
      CellTags->"underscripts"],
    Cell[116551, 4979, 123, 4, 70, "Text",
      CellTags->"underscripts"],
    Cell[116711, 4988, 59, 1, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[116773, 4991, 97, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[116873, 4995, 189, 5, 70, "Text",
      CellTags->"underscripts"],
    Cell[117099, 5005, 305, 10, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[117407, 5017, 97, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[117553, 5025, 171, 6, 70, "SubsectionIcon",
      CellTags->"underscripts"],
    Cell[117727, 5033, 223, 5, 70, "Text",
      CellTags->"underscripts"],
    Cell[117975, 5042, 975, 34, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[118953, 5078, 152, 4, 70, "Input",
      CellTags->"underscripts"],
    Cell[119108, 5084, 142, 4, 70, "Text",
      CellTags->"underscripts"],
    Cell[119287, 5093, 59, 1, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[119349, 5096, 78, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[119430, 5100, 129, 4, 70, "Text",
      CellTags->"underscripts"],
    Cell[119596, 5109, 68, 1, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[119667, 5112, 139, 4, 70, "Input",
      CellTags->"underscripts"],
    Cell[119809, 5118, 86, 1, 70, "Text",
      CellTags->"underscripts"],
    Cell[119932, 5124, 61, 1, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[119996, 5127, 105, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[120104, 5131, 118, 4, 70, "Text",
      CellTags->"underscripts"],
    Cell[120259, 5140, 305, 10, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[120567, 5152, 105, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[120721, 5160, 179, 6, 70, "SubsectionIcon",
      CellTags->"underscripts"],
    Cell[120903, 5168, 121, 3, 70, "Text",
      CellTags->"underscripts"],
    Cell[121027, 5173, 66, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[121096, 5177, 187, 5, 70, "Text",
      CellTags->"underscripts"],
    Cell[121308, 5186, 63, 1, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[121374, 5189, 102, 3, 70, "Input",
      CellTags->"underscripts"],
    Cell[121479, 5194, 145, 4, 70, "Text",
      CellTags->"underscripts"],
    Cell[121661, 5203, 520, 18, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[122184, 5223, 145, 4, 70, "Input",
      CellTags->"underscripts"],
    Cell[122332, 5229, 92, 1, 70, "Text",
      CellTags->"underscripts"],
    Cell[122461, 5235, 59, 1, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[122523, 5238, 105, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[122631, 5242, 91, 1, 70, "Text",
      CellTags->"underscripts"],
    Cell[122759, 5248, 305, 10, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[123067, 5260, 105, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[123221, 5268, 261, 9, 70, "SubsectionIcon",
      CellTags->"underscripts"],
    Cell[123507, 5281, 564, 20, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[124074, 5303, 141, 4, 70, "Input",
      CellTags->"underscripts"],
    Cell[124252, 5312, 59, 1, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[124314, 5315, 99, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[124450, 5322, 517, 18, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[124970, 5342, 109, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[125116, 5349, 313, 10, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[125432, 5361, 98, 2, 70, "Input",
      CellTags->"underscripts"],
    Cell[125567, 5368, 62, 1, 70, "Subsubsection",
      CellTags->"underscripts"],
    Cell[125632, 5371, 112, 2, 70, "Input",
      CellTags->"underscripts"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"overview", 126492, 5398},
  {"fractions", 135616, 5647},
  {"powers", 139727, 5756},
  {"squareroots", 142512, 5833},
  {"radicals", 145260, 5904},
  {"vectors", 148569, 5993},
  {"matrices", 151482, 6072},
  {"superscripts", 153813, 6135},
  {"subscripts", 157318, 6224},
  {"overscripts", 160738, 6313},
  {"underscripts", 164298, 6404}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 55, 0, 81, "Chapter"],

Cell[CellGroupData[{
Cell[1807, 56, 51, 1, 52, "Section",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[1883, 61, 159, 6, 70, "SubsectionIcon",
  CellTags->"overview"],
Cell[2045, 69, 94, 1, 70, "Text",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[2164, 74, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[2222, 77, 136, 4, 70, "Input",
  CellTags->"overview"],
Cell[2361, 83, 192, 5, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2590, 93, 190, 8, 70, "Subsubsection",
  CellTags->"overview"],
Cell[2783, 103, 132, 4, 70, "Input",
  CellTags->"overview"],
Cell[2918, 109, 65, 1, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3020, 115, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[3078, 118, 165, 5, 70, "Input",
  CellTags->"overview"],
Cell[3246, 125, 159, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3442, 134, 301, 10, 70, "Subsubsection",
  CellTags->"overview"],
Cell[3746, 146, 141, 4, 70, "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[3936, 156, 159, 6, 70, "SubsectionIcon",
  CellTags->"overview"],
Cell[4098, 164, 89, 1, 70, "Text",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[4212, 169, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[4270, 172, 90, 2, 70, "Input",
  CellTags->"overview"],
Cell[4363, 176, 153, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4553, 185, 971, 34, 70, "Subsubsection",
  CellTags->"overview"],
Cell[5527, 221, 135, 4, 70, "Input",
  CellTags->"overview"],
Cell[5665, 227, 118, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5820, 236, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[5878, 239, 93, 2, 70, "Input",
  CellTags->"overview"],
Cell[5974, 243, 173, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6184, 252, 301, 10, 70, "Subsubsection",
  CellTags->"overview"],
Cell[6488, 264, 93, 2, 70, "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[6630, 272, 158, 6, 70, "SubsectionIcon",
  CellTags->"overview"],
Cell[6791, 280, 146, 4, 70, "Text",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[6962, 288, 1006, 36, 70, "Subsubsection",
  CellTags->"overview"],
Cell[7971, 326, 123, 4, 70, "Input",
  CellTags->"overview"],
Cell[8097, 332, 98, 1, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8232, 338, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[8290, 341, 92, 2, 70, "Input",
  CellTags->"overview"],
Cell[8385, 345, 138, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8560, 354, 335, 12, 70, "Subsubsection",
  CellTags->"overview"],
Cell[8898, 368, 92, 2, 70, "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[9039, 376, 161, 6, 70, "SubsectionIcon",
  CellTags->"overview"],
Cell[9203, 384, 137, 4, 70, "Text",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[9365, 392, 1039, 38, 70, "Subsubsection",
  CellTags->"overview"],
Cell[10407, 432, 123, 4, 70, "Input",
  CellTags->"overview"],
Cell[10533, 438, 120, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10690, 447, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[10748, 450, 92, 2, 70, "Input",
  CellTags->"overview"],
Cell[10843, 454, 111, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10991, 463, 1005, 36, 70, "Subsubsection",
  CellTags->"overview"],
Cell[11999, 501, 131, 4, 70, "Input",
  CellTags->"overview"],
Cell[12133, 507, 56, 1, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12226, 513, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[12284, 516, 95, 2, 70, "Input",
  CellTags->"overview"],
Cell[12382, 520, 162, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12581, 529, 335, 12, 70, "Subsubsection",
  CellTags->"overview"],
Cell[12919, 543, 95, 2, 70, "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[13063, 551, 266, 10, 70, "SubsectionIcon",
  CellTags->"overview"],
Cell[13332, 563, 149, 4, 70, "Text",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[13506, 571, 148, 6, 70, "Subsubsection",
  CellTags->"overview"],
Cell[13657, 579, 85, 2, 70, "Input",
  CellTags->"overview"],
Cell[13745, 583, 170, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13952, 592, 361, 13, 70, "Subsubsection",
  CellTags->"overview"],
Cell[14316, 607, 186, 6, 70, "Input",
  CellTags->"overview"],
Cell[14505, 615, 204, 5, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14746, 625, 575, 20, 70, "Subsubsection",
  CellTags->"overview"],
Cell[15324, 647, 221, 7, 70, "Input",
  CellTags->"overview"],
Cell[15548, 656, 178, 5, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15763, 666, 291, 11, 70, "Subsubsection",
  CellTags->"overview"],
Cell[16057, 679, 208, 7, 70, "Input",
  CellTags->"overview"],
Cell[16268, 688, 176, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16481, 697, 309, 10, 70, "Subsubsection",
  CellTags->"overview"],
Cell[16793, 709, 185, 6, 70, "Input",
  CellTags->"overview"],
Cell[16981, 717, 90, 1, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17108, 723, 140, 6, 70, "Subsubsection",
  CellTags->"overview"],
Cell[17251, 731, 185, 6, 70, "Input",
  CellTags->"overview"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17485, 743, 159, 6, 70, "SubsectionIcon",
  CellTags->"overview"],
Cell[17647, 751, 86, 1, 70, "Text",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[17758, 756, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[17816, 759, 90, 2, 70, "Input",
  CellTags->"overview"],
Cell[17909, 763, 144, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18090, 772, 985, 34, 70, "Subsubsection",
  CellTags->"overview"],
Cell[19078, 808, 133, 4, 70, "Input",
  CellTags->"overview"],
Cell[19214, 814, 119, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19370, 823, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[19428, 826, 93, 2, 70, "Input",
  CellTags->"overview"],
Cell[19524, 830, 183, 5, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19744, 840, 301, 10, 70, "Subsubsection",
  CellTags->"overview"],
Cell[20048, 852, 93, 2, 70, "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[20190, 860, 159, 6, 70, "SubsectionIcon",
  CellTags->"overview"],
Cell[20352, 868, 88, 1, 70, "Text",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[20465, 873, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[20523, 876, 90, 2, 70, "Input",
  CellTags->"overview"],
Cell[20616, 880, 150, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20803, 889, 1053, 38, 70, "Subsubsection",
  CellTags->"overview"],
Cell[21859, 929, 135, 4, 70, "Input",
  CellTags->"overview"],
Cell[21997, 935, 121, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22155, 944, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[22213, 947, 93, 2, 70, "Input",
  CellTags->"overview"],
Cell[22309, 951, 187, 5, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22533, 961, 301, 10, 70, "Subsubsection",
  CellTags->"overview"],
Cell[22837, 973, 93, 2, 70, "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[22979, 981, 159, 6, 70, "SubsectionIcon",
  CellTags->"overview"],
Cell[23141, 989, 91, 1, 70, "Text",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[23257, 994, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[23315, 997, 90, 2, 70, "Input",
  CellTags->"overview"],
Cell[23408, 1001, 147, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23592, 1010, 985, 34, 70, "Subsubsection",
  CellTags->"overview"],
Cell[24580, 1046, 135, 4, 70, "Input",
  CellTags->"overview"],
Cell[24718, 1052, 119, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24874, 1061, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[24932, 1064, 93, 2, 70, "Input",
  CellTags->"overview"],
Cell[25028, 1068, 185, 5, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25250, 1078, 301, 10, 70, "Subsubsection",
  CellTags->"overview"],
Cell[25554, 1090, 93, 2, 70, "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[25696, 1098, 159, 6, 70, "SubsectionIcon",
  CellTags->"overview"],
Cell[25858, 1106, 90, 1, 70, "Text",
  CellTags->"overview"],

Cell[CellGroupData[{
Cell[25973, 1111, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[26031, 1114, 90, 2, 70, "Input",
  CellTags->"overview"],
Cell[26124, 1118, 146, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26307, 1127, 985, 34, 70, "Subsubsection",
  CellTags->"overview"],
Cell[27295, 1163, 134, 4, 70, "Input",
  CellTags->"overview"],
Cell[27432, 1169, 119, 4, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27588, 1178, 55, 1, 70, "Subsubsection",
  CellTags->"overview"],
Cell[27646, 1181, 93, 2, 70, "Input",
  CellTags->"overview"],
Cell[27742, 1185, 186, 5, 70, "Text",
  CellTags->"overview"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27965, 1195, 301, 10, 70, "Subsubsection",
  CellTags->"overview"],
Cell[28269, 1207, 93, 2, 70, "Input",
  CellTags->"overview"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[28423, 1216, 53, 1, 38, "Section",
  CellTags->"fractions"],

Cell[CellGroupData[{
Cell[28501, 1221, 160, 6, 70, "SubsectionIcon",
  CellTags->"fractions"],
Cell[28664, 1229, 95, 1, 70, "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{
Cell[28784, 1234, 56, 1, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[28843, 1237, 137, 4, 70, "Input",
  CellTags->"fractions"],
Cell[28983, 1243, 193, 5, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29213, 1253, 517, 18, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[29733, 1273, 133, 4, 70, "Input",
  CellTags->"fractions"],
Cell[29869, 1279, 66, 1, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29972, 1285, 56, 1, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[30031, 1288, 166, 5, 70, "Input",
  CellTags->"fractions"],
Cell[30200, 1295, 160, 4, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30397, 1304, 302, 10, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[30702, 1316, 142, 4, 70, "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[30893, 1326, 164, 6, 70, "SubsectionIcon",
  CellTags->"fractions"],
Cell[31060, 1334, 80, 1, 70, "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{
Cell[31165, 1339, 777, 26, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[31945, 1367, 142, 4, 70, "Input",
  CellTags->"fractions"],
Cell[32090, 1373, 124, 4, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32251, 1382, 57, 1, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[32311, 1385, 146, 4, 70, "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[32506, 1395, 168, 6, 70, "SubsectionIcon",
  CellTags->"fractions"],
Cell[32677, 1403, 89, 1, 70, "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{
Cell[32791, 1408, 539, 19, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[33333, 1429, 166, 5, 70, "Input",
  CellTags->"fractions"],
Cell[33502, 1436, 121, 4, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33660, 1445, 311, 10, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[33974, 1457, 150, 4, 70, "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[34173, 1467, 168, 6, 70, "SubsectionIcon",
  CellTags->"fractions"],
Cell[34344, 1475, 190, 5, 70, "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{
Cell[34559, 1484, 517, 18, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[35079, 1504, 146, 4, 70, "Input",
  CellTags->"fractions"],
Cell[35228, 1510, 78, 1, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35343, 1516, 58, 1, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[35404, 1519, 185, 5, 70, "Input",
  CellTags->"fractions"],
Cell[35592, 1526, 206, 5, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35835, 1536, 278, 10, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[36116, 1548, 139, 4, 70, "Input",
  CellTags->"fractions"],
Cell[36258, 1554, 121, 4, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36416, 1563, 310, 10, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[36729, 1575, 102, 2, 70, "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[36880, 1583, 176, 6, 70, "SubsectionIcon",
  CellTags->"fractions"],
Cell[37059, 1591, 95, 1, 70, "Text",
  CellTags->"fractions"],

Cell[CellGroupData[{
Cell[37179, 1596, 58, 1, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[37240, 1599, 143, 4, 70, "Input",
  CellTags->"fractions"],
Cell[37386, 1605, 184, 5, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37607, 1615, 59, 1, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[37669, 1618, 99, 3, 70, "Input",
  CellTags->"fractions"],
Cell[37771, 1623, 95, 1, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37903, 1629, 320, 11, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[38226, 1642, 139, 4, 70, "Input",
  CellTags->"fractions"],
Cell[38368, 1648, 121, 4, 70, "Text",
  CellTags->"fractions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38526, 1657, 310, 10, 70, "Subsubsection",
  CellTags->"fractions"],
Cell[38839, 1669, 102, 2, 70, "Input",
  CellTags->"fractions"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[39002, 1678, 47, 1, 38, "Section",
  CellTags->"powers"],

Cell[CellGroupData[{
Cell[39074, 1683, 157, 6, 70, "SubsectionIcon",
  CellTags->"powers"],
Cell[39234, 1691, 87, 1, 70, "Text",
  CellTags->"powers"],

Cell[CellGroupData[{
Cell[39346, 1696, 53, 1, 70, "Subsubsection",
  CellTags->"powers"],
Cell[39402, 1699, 88, 2, 70, "Input",
  CellTags->"powers"],
Cell[39493, 1703, 151, 4, 70, "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39681, 1712, 969, 34, 70, "Subsubsection",
  CellTags->"powers"],
Cell[40653, 1748, 133, 4, 70, "Input",
  CellTags->"powers"],
Cell[40789, 1754, 116, 4, 70, "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40942, 1763, 53, 1, 70, "Subsubsection",
  CellTags->"powers"],
Cell[40998, 1766, 91, 2, 70, "Input",
  CellTags->"powers"],
Cell[41092, 1770, 171, 5, 70, "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41300, 1780, 299, 10, 70, "Subsubsection",
  CellTags->"powers"],
Cell[41602, 1792, 91, 2, 70, "Input",
  CellTags->"powers"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[41742, 1800, 164, 6, 70, "SubsectionIcon",
  CellTags->"powers"],
Cell[41909, 1808, 77, 1, 70, "Text",
  CellTags->"powers"],

Cell[CellGroupData[{
Cell[42011, 1813, 774, 26, 70, "Subsubsection",
  CellTags->"powers"],
Cell[42788, 1841, 139, 4, 70, "Input",
  CellTags->"powers"],
Cell[42930, 1847, 77, 1, 70, "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43044, 1853, 775, 26, 70, "Subsubsection",
  CellTags->"powers"],
Cell[43822, 1881, 98, 2, 70, "Input",
  CellTags->"powers"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[43969, 1889, 165, 6, 70, "SubsectionIcon",
  CellTags->"powers"],
Cell[44137, 1897, 87, 1, 70, "Text",
  CellTags->"powers"],

Cell[CellGroupData[{
Cell[44249, 1902, 522, 18, 70, "Subsubsection",
  CellTags->"powers"],
Cell[44774, 1922, 133, 4, 70, "Input",
  CellTags->"powers"],
Cell[44910, 1928, 94, 1, 70, "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45041, 1934, 309, 10, 70, "Subsubsection",
  CellTags->"powers"],
Cell[45353, 1946, 99, 2, 70, "Input",
  CellTags->"powers"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[45501, 1954, 164, 6, 70, "SubsectionIcon",
  CellTags->"powers"],
Cell[45668, 1962, 89, 1, 70, "Text",
  CellTags->"powers"],

Cell[CellGroupData[{
Cell[45782, 1967, 536, 19, 70, "Subsubsection",
  CellTags->"powers"],
Cell[46321, 1988, 91, 2, 70, "Input",
  CellTags->"powers"],
Cell[46415, 1992, 85, 1, 70, "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46537, 1998, 365, 14, 70, "Subsubsection",
  CellTags->"powers"],
Cell[46905, 2014, 98, 2, 70, "Input",
  CellTags->"powers"],
Cell[47006, 2018, 93, 1, 70, "Text",
  CellTags->"powers"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47136, 2024, 311, 11, 70, "Subsubsection",
  CellTags->"powers"],
Cell[47450, 2037, 98, 2, 70, "Input",
  CellTags->"powers"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[47609, 2046, 58, 1, 38, "Section",
  CellTags->"squareroots"],

Cell[CellGroupData[{
Cell[47692, 2051, 161, 6, 70, "SubsectionIcon",
  CellTags->"squareroots"],
Cell[47856, 2059, 149, 4, 70, "Text",
  CellTags->"squareroots"],

Cell[CellGroupData[{
Cell[48030, 2067, 974, 34, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[49007, 2103, 126, 4, 70, "Input",
  CellTags->"squareroots"],
Cell[49136, 2109, 101, 1, 70, "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49274, 2115, 58, 1, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[49335, 2118, 95, 2, 70, "Input",
  CellTags->"squareroots"],
Cell[49433, 2122, 141, 4, 70, "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49611, 2131, 304, 10, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[49918, 2143, 95, 2, 70, "Input",
  CellTags->"squareroots"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[50062, 2151, 169, 6, 70, "SubsectionIcon",
  CellTags->"squareroots"],
Cell[50234, 2159, 183, 7, 70, "Text",
  CellTags->"squareroots"],

Cell[CellGroupData[{
Cell[50442, 2170, 805, 28, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[51250, 2200, 95, 2, 70, "Input",
  CellTags->"squareroots"],
Cell[51348, 2204, 101, 1, 70, "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51486, 2210, 805, 28, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[52294, 2240, 103, 2, 70, "Input",
  CellTags->"squareroots"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[52446, 2248, 168, 6, 70, "SubsectionIcon",
  CellTags->"squareroots"],
Cell[52617, 2256, 86, 1, 70, "Text",
  CellTags->"squareroots"],

Cell[CellGroupData[{
Cell[52728, 2261, 553, 20, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[53284, 2283, 126, 4, 70, "Input",
  CellTags->"squareroots"],
Cell[53413, 2289, 179, 4, 70, "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53629, 2298, 314, 10, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[53946, 2310, 102, 2, 70, "Input",
  CellTags->"squareroots"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[54097, 2318, 176, 6, 70, "SubsectionIcon",
  CellTags->"squareroots"],
Cell[54276, 2326, 121, 4, 70, "Text",
  CellTags->"squareroots"],

Cell[CellGroupData[{
Cell[54422, 2334, 60, 1, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[54485, 2337, 64, 2, 70, "Input",
  CellTags->"squareroots"],
Cell[54552, 2341, 186, 5, 70, "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54775, 2351, 62, 1, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[54840, 2354, 100, 3, 70, "Input",
  CellTags->"squareroots"],
Cell[54943, 2359, 166, 4, 70, "Text",
  CellTags->"squareroots"]
}, Open  ]],

Cell[CellGroupData[{
Cell[55146, 2368, 634, 23, 70, "Subsubsection",
  CellTags->"squareroots"],
Cell[55783, 2393, 102, 2, 70, "Input",
  CellTags->"squareroots"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[55946, 2402, 51, 1, 38, "Section",
  CellTags->"radicals"],

Cell[CellGroupData[{
Cell[56022, 2407, 161, 6, 70, "SubsectionIcon",
  CellTags->"radicals"],
Cell[56186, 2415, 137, 4, 70, "Text",
  CellTags->"radicals"],

Cell[CellGroupData[{
Cell[56348, 2423, 971, 34, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[57322, 2459, 123, 4, 70, "Input",
  CellTags->"radicals"],
Cell[57448, 2465, 120, 4, 70, "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57605, 2474, 55, 1, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[57663, 2477, 92, 2, 70, "Input",
  CellTags->"radicals"],
Cell[57758, 2481, 111, 4, 70, "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57906, 2490, 972, 34, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[58881, 2526, 131, 4, 70, "Input",
  CellTags->"radicals"],
Cell[59015, 2532, 56, 1, 70, "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59108, 2538, 55, 1, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[59166, 2541, 95, 2, 70, "Input",
  CellTags->"radicals"],
Cell[59264, 2545, 162, 4, 70, "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59463, 2554, 301, 10, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[59767, 2566, 95, 2, 70, "Input",
  CellTags->"radicals"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[59911, 2574, 172, 6, 70, "SubsectionIcon",
  CellTags->"radicals"],
Cell[60086, 2582, 189, 7, 70, "Text",
  CellTags->"radicals"],

Cell[CellGroupData[{
Cell[60300, 2593, 1269, 44, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[61572, 2639, 95, 2, 70, "Input",
  CellTags->"radicals"],
Cell[61670, 2643, 98, 1, 70, "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[61805, 2649, 1269, 44, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[63077, 2695, 106, 2, 70, "Input",
  CellTags->"radicals"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[63232, 2703, 168, 6, 70, "SubsectionIcon",
  CellTags->"radicals"],
Cell[63403, 2711, 79, 1, 70, "Text",
  CellTags->"radicals"],

Cell[CellGroupData[{
Cell[63507, 2716, 516, 18, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[64026, 2736, 123, 4, 70, "Input",
  CellTags->"radicals"],
Cell[64152, 2742, 155, 4, 70, "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[64344, 2751, 535, 18, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[64882, 2771, 136, 4, 70, "Input",
  CellTags->"radicals"],
Cell[65021, 2777, 189, 5, 70, "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[65247, 2787, 309, 10, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[65559, 2799, 102, 2, 70, "Input",
  CellTags->"radicals"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[65710, 2807, 176, 6, 70, "SubsectionIcon",
  CellTags->"radicals"],
Cell[65889, 2815, 118, 4, 70, "Text",
  CellTags->"radicals"],

Cell[CellGroupData[{
Cell[66032, 2823, 57, 1, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[66092, 2826, 61, 2, 70, "Input",
  CellTags->"radicals"],
Cell[66156, 2830, 183, 5, 70, "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66376, 2840, 59, 1, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[66438, 2843, 97, 3, 70, "Input",
  CellTags->"radicals"],
Cell[66538, 2848, 156, 4, 70, "Text",
  CellTags->"radicals"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66731, 2857, 760, 26, 70, "Subsubsection",
  CellTags->"radicals"],
Cell[67494, 2885, 99, 2, 70, "Input",
  CellTags->"radicals"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[67654, 2894, 49, 1, 38, "Section",
  CellTags->"vectors"],

Cell[CellGroupData[{
Cell[67728, 2899, 270, 10, 70, "SubsectionIcon",
  CellTags->"vectors"],
Cell[68001, 2911, 148, 4, 70, "Text",
  CellTags->"vectors"],

Cell[CellGroupData[{
Cell[68174, 2919, 147, 6, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[68324, 2927, 84, 2, 70, "Input",
  CellTags->"vectors"],
Cell[68411, 2931, 171, 4, 70, "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[68619, 2940, 523, 18, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[69145, 2960, 185, 6, 70, "Input",
  CellTags->"vectors"],
Cell[69333, 2968, 171, 4, 70, "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69541, 2977, 522, 18, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[70066, 2997, 190, 6, 70, "Input",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[70293, 3008, 523, 18, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[70819, 3028, 195, 6, 70, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[71051, 3039, 54, 1, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[71108, 3042, 155, 4, 70, "Input",
  CellTags->"vectors"],
Cell[71266, 3048, 133, 4, 70, "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[71436, 3057, 300, 10, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[71739, 3069, 170, 5, 70, "Input",
  CellTags->"vectors"],
Cell[71912, 3076, 90, 1, 70, "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[72039, 3082, 139, 6, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[72181, 3090, 170, 5, 70, "Input",
  CellTags->"vectors"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[72400, 3101, 315, 12, 70, "SubsectionIcon",
  CellTags->"vectors"],
Cell[72718, 3115, 147, 4, 70, "Text",
  CellTags->"vectors"],

Cell[CellGroupData[{
Cell[72890, 3123, 147, 6, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[73040, 3131, 84, 2, 70, "Input",
  CellTags->"vectors"],
Cell[73127, 3135, 172, 4, 70, "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[73336, 3144, 540, 18, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[73879, 3164, 197, 7, 70, "Input",
  CellTags->"vectors"],
Cell[74079, 3173, 174, 5, 70, "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74290, 3183, 411, 15, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[74704, 3200, 214, 8, 70, "Input",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74955, 3213, 377, 13, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[75335, 3228, 231, 9, 70, "Input",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75603, 3242, 54, 1, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[75660, 3245, 191, 7, 70, "Input",
  CellTags->"vectors"],
Cell[75854, 3254, 133, 4, 70, "Text",
  CellTags->"vectors"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76024, 3263, 300, 10, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[76327, 3275, 212, 8, 70, "Input",
  CellTags->"vectors"],
Cell[76542, 3285, 67, 0, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76646, 3290, 139, 6, 70, "Subsubsection",
  CellTags->"vectors"],
Cell[76788, 3298, 212, 8, 70, "Input",
  CellTags->"vectors"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[77061, 3313, 51, 1, 38, "Section",
  CellTags->"matrices"],

Cell[CellGroupData[{
Cell[77137, 3318, 76, 1, 70, "SubsectionIcon",
  CellTags->"matrices"],
Cell[77216, 3321, 257, 10, 70, "Text",
  CellTags->"matrices"],
Cell[77476, 3333, 302, 7, 70, "Input",
  CellTags->"matrices"]
}, Closed]],

Cell[CellGroupData[{
Cell[77815, 3345, 77, 1, 70, "SubsectionIcon",
  CellTags->"matrices"],
Cell[77895, 3348, 289, 7, 70, "Text",
  CellTags->"matrices"],
Cell[78187, 3357, 247, 7, 70, "Input",
  CellTags->"matrices"],

Cell[CellGroupData[{
Cell[78459, 3368, 285, 10, 70, "Subsubsection",
  CellTags->"matrices"],
Cell[78747, 3380, 234, 7, 70, "Input",
  CellTags->"matrices"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79018, 3392, 285, 10, 70, "Subsubsection",
  CellTags->"matrices"],
Cell[79306, 3404, 221, 7, 70, "Input",
  CellTags->"matrices"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79564, 3416, 319, 12, 70, "Subsubsection",
  CellTags->"matrices"],
Cell[79886, 3430, 208, 7, 70, "Input",
  CellTags->"matrices"],
Cell[80097, 3439, 133, 4, 70, "Text",
  CellTags->"matrices"]
}, Open  ]],

Cell[CellGroupData[{
Cell[80267, 3448, 309, 10, 70, "Subsubsection",
  CellTags->"matrices"],
Cell[80579, 3460, 185, 6, 70, "Input",
  CellTags->"matrices"],
Cell[80767, 3468, 90, 1, 70, "Text",
  CellTags->"matrices"]
}, Open  ]],

Cell[CellGroupData[{
Cell[80894, 3474, 140, 6, 70, "Subsubsection",
  CellTags->"matrices"],
Cell[81037, 3482, 185, 6, 70, "Input",
  CellTags->"matrices"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[81271, 3494, 73, 1, 70, "SubsectionIcon",
  CellTags->"matrices"],
Cell[81347, 3497, 174, 4, 70, "Text",
  CellTags->"matrices"],
Cell[81524, 3503, 168, 5, 70, "Input",
  CellTags->"matrices"],
Cell[81695, 3510, 166, 4, 70, "Text",
  CellTags->"matrices"],
Cell[81864, 3516, 570, 21, 70, "Text",
  CellTags->"matrices"],
Cell[82437, 3539, 231, 7, 70, "Input",
  CellTags->"matrices"]
}, Closed]],

Cell[CellGroupData[{
Cell[82705, 3551, 70, 1, 70, "SubsectionIcon",
  CellTags->"matrices"],
Cell[82778, 3554, 174, 4, 70, "Text",
  CellTags->"matrices"],
Cell[82955, 3560, 168, 5, 70, "Input",
  CellTags->"matrices"],
Cell[83126, 3567, 166, 4, 70, "Text",
  CellTags->"matrices"],

Cell[CellGroupData[{
Cell[83317, 3575, 724, 24, 70, "Subsubsection",
  CellTags->"matrices"],
Cell[84044, 3601, 243, 8, 70, "Input",
  CellTags->"matrices"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[84348, 3616, 59, 1, 38, "Section",
  CellTags->"superscripts"],

Cell[CellGroupData[{
Cell[84432, 3621, 163, 6, 70, "SubsectionIcon",
  CellTags->"superscripts"],
Cell[84598, 3629, 92, 1, 70, "Text",
  CellTags->"superscripts"],

Cell[CellGroupData[{
Cell[84715, 3634, 59, 1, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[84777, 3637, 94, 2, 70, "Input",
  CellTags->"superscripts"],
Cell[84874, 3641, 154, 4, 70, "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85065, 3650, 989, 34, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[86057, 3686, 139, 4, 70, "Input",
  CellTags->"superscripts"],
Cell[86199, 3692, 125, 4, 70, "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[86361, 3701, 59, 1, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[86423, 3704, 97, 2, 70, "Input",
  CellTags->"superscripts"],
Cell[86523, 3708, 191, 6, 70, "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[86751, 3719, 305, 10, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[87059, 3731, 97, 2, 70, "Input",
  CellTags->"superscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[87205, 3739, 170, 6, 70, "SubsectionIcon",
  CellTags->"superscripts"],
Cell[87378, 3747, 245, 7, 70, "Text",
  CellTags->"superscripts"],

Cell[CellGroupData[{
Cell[87648, 3758, 528, 18, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[88179, 3778, 139, 4, 70, "Input",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88355, 3787, 305, 11, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[88663, 3800, 100, 2, 70, "Input",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88800, 3807, 305, 10, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[89108, 3819, 104, 2, 70, "Input",
  CellTags->"superscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[89261, 3827, 185, 6, 70, "SubsectionIcon",
  CellTags->"superscripts"],
Cell[89449, 3835, 94, 1, 70, "Text",
  CellTags->"superscripts"],

Cell[CellGroupData[{
Cell[89568, 3840, 528, 18, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[90099, 3860, 139, 4, 70, "Input",
  CellTags->"superscripts"],
Cell[90241, 3866, 285, 4, 70, "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[90563, 3875, 543, 19, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[91109, 3896, 119, 2, 70, "Input",
  CellTags->"superscripts"],
Cell[91231, 3900, 129, 4, 70, "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[91397, 3909, 305, 10, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[91705, 3921, 119, 2, 70, "Input",
  CellTags->"superscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[91873, 3929, 166, 6, 70, "SubsectionIcon",
  CellTags->"superscripts"],
Cell[92042, 3937, 130, 4, 70, "Text",
  CellTags->"superscripts"],

Cell[CellGroupData[{
Cell[92197, 3945, 528, 18, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[92728, 3965, 139, 4, 70, "Input",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[92904, 3974, 528, 18, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[93435, 3994, 169, 5, 70, "Input",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[93641, 4004, 59, 1, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[93703, 4007, 100, 2, 70, "Input",
  CellTags->"superscripts"],
Cell[93806, 4011, 101, 1, 70, "Text",
  CellTags->"superscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[93944, 4017, 317, 11, 70, "Subsubsection",
  CellTags->"superscripts"],
Cell[94264, 4030, 100, 2, 70, "Input",
  CellTags->"superscripts"],
Cell[94367, 4034, 100, 2, 70, "Input",
  CellTags->"superscripts"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[94528, 4043, 55, 1, 38, "Section",
  CellTags->"subscripts"],

Cell[CellGroupData[{
Cell[94608, 4048, 161, 6, 46, "SubsectionIcon",
  CellTags->"subscripts"],

Cell[CellGroupData[{
Cell[94794, 4058, 179, 6, 34, "Subsubsection",
  CellTags->"subscripts"],
Cell[94976, 4066, 117, 3, 24, "Text",
  CellTags->"subscripts"],
Cell[95096, 4071, 92, 2, 26, "Input",
  CellTags->"subscripts"]
}, Closed]],

Cell[CellGroupData[{
Cell[95225, 4078, 359, 12, 34, "Subsubsection",
  CellTags->"subscripts"],
Cell[95587, 4092, 1110, 41, 27, "Text",
  CellTags->"subscripts"],
Cell[96700, 4135, 135, 4, 26, "Input",
  CellTags->"subscripts"]
}, Closed]],

Cell[CellGroupData[{
Cell[96872, 4144, 204, 7, 34, "Subsubsection",
  CellTags->"subscripts"],
Cell[97079, 4153, 117, 3, 24, "Text",
  CellTags->"subscripts"],
Cell[97199, 4158, 95, 2, 27, "Input",
  CellTags->"subscripts"]
}, Closed]],

Cell[CellGroupData[{
Cell[97331, 4165, 266, 7, 50, "Subsubsection",
  CellTags->"subscripts"],
Cell[97600, 4174, 363, 13, 30, "Text",
  CellTags->"subscripts"],
Cell[97966, 4189, 95, 2, 26, "Input",
  CellTags->"subscripts"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[98110, 4197, 168, 6, 38, "SubsectionIcon",
  CellTags->"subscripts"],

Cell[CellGroupData[{
Cell[98303, 4207, 556, 20, 34, "Subsubsection",
  CellTags->"subscripts"],
Cell[98862, 4229, 580, 21, 27, "Text",
  CellTags->"subscripts"],
Cell[99445, 4252, 135, 4, 26, "Input",
  CellTags->"subscripts"],
Cell[99583, 4258, 501, 20, 30, "Text",
  CellTags->"subscripts"],
Cell[100087, 4280, 98, 2, 27, "Input",
  CellTags->"subscripts"],
Cell[100188, 4284, 391, 14, 30, "Text",
  CellTags->"subscripts"],
Cell[100582, 4300, 102, 2, 26, "Input",
  CellTags->"subscripts"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[100733, 4308, 183, 6, 36, "SubsectionIcon",
  CellTags->"subscripts"],
Cell[100919, 4316, 92, 1, 24, "Text",
  CellTags->"subscripts"],

Cell[CellGroupData[{
Cell[101036, 4321, 526, 18, 40, "Subsubsection",
  CellTags->"subscripts"],
Cell[101565, 4341, 135, 4, 26, "Input",
  CellTags->"subscripts"],
Cell[101703, 4347, 281, 4, 40, "Text",
  CellTags->"subscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102021, 4356, 541, 19, 40, "Subsubsection",
  CellTags->"subscripts"],
Cell[102565, 4377, 117, 2, 27, "Input",
  CellTags->"subscripts"],
Cell[102685, 4381, 125, 4, 24, "Text",
  CellTags->"subscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102847, 4390, 303, 10, 40, "Subsubsection",
  CellTags->"subscripts"],
Cell[103153, 4402, 117, 2, 26, "Input",
  CellTags->"subscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[103319, 4410, 168, 6, 41, "SubsectionIcon",
  CellTags->"subscripts"],
Cell[103490, 4418, 126, 4, 24, "Text",
  CellTags->"subscripts"],

Cell[CellGroupData[{
Cell[103641, 4426, 526, 18, 40, "Subsubsection",
  CellTags->"subscripts"],
Cell[104170, 4446, 135, 4, 26, "Input",
  CellTags->"subscripts"],
Cell[104308, 4452, 586, 21, 30, "Text",
  CellTags->"subscripts"],
Cell[104897, 4475, 165, 5, 27, "Input",
  CellTags->"subscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[105099, 4485, 57, 1, 34, "Subsubsection",
  CellTags->"subscripts"],
Cell[105159, 4488, 102, 2, 30, "Input",
  CellTags->"subscripts"],
Cell[105264, 4492, 118, 4, 24, "Text",
  CellTags->"subscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[105419, 4501, 315, 11, 40, "Subsubsection",
  CellTags->"subscripts"],
Cell[105737, 4514, 98, 2, 28, "Input",
  CellTags->"subscripts"],
Cell[105838, 4518, 102, 2, 28, "Input",
  CellTags->"subscripts"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[106001, 4527, 57, 1, 38, "Section",
  CellTags->"overscripts"],

Cell[CellGroupData[{
Cell[106083, 4532, 162, 6, 70, "SubsectionIcon",
  CellTags->"overscripts"],
Cell[106248, 4540, 93, 1, 70, "Text",
  CellTags->"overscripts"],

Cell[CellGroupData[{
Cell[106366, 4545, 58, 1, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[106427, 4548, 93, 2, 70, "Input",
  CellTags->"overscripts"],
Cell[106523, 4552, 150, 4, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[106710, 4561, 988, 34, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[107701, 4597, 137, 4, 70, "Input",
  CellTags->"overscripts"],
Cell[107841, 4603, 122, 4, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[108000, 4612, 58, 1, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[108061, 4615, 96, 2, 70, "Input",
  CellTags->"overscripts"],
Cell[108160, 4619, 189, 5, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[108386, 4629, 304, 10, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[108693, 4641, 96, 2, 70, "Input",
  CellTags->"overscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[108838, 4649, 170, 6, 70, "SubsectionIcon",
  CellTags->"overscripts"],
Cell[109011, 4657, 221, 5, 70, "Text",
  CellTags->"overscripts"],

Cell[CellGroupData[{
Cell[109257, 4666, 974, 34, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[110234, 4702, 150, 4, 70, "Input",
  CellTags->"overscripts"],
Cell[110387, 4708, 140, 4, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[110564, 4717, 58, 1, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[110625, 4720, 109, 2, 70, "Input",
  CellTags->"overscripts"],
Cell[110737, 4724, 128, 4, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[110902, 4733, 280, 10, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[111185, 4745, 137, 4, 70, "Input",
  CellTags->"overscripts"],
Cell[111325, 4751, 85, 1, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[111447, 4757, 60, 1, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[111510, 4760, 100, 2, 70, "Input",
  CellTags->"overscripts"],
Cell[111613, 4764, 116, 4, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[111766, 4773, 304, 10, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[112073, 4785, 104, 2, 70, "Input",
  CellTags->"overscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[112226, 4793, 178, 6, 70, "SubsectionIcon",
  CellTags->"overscripts"],

Cell[CellGroupData[{
Cell[112429, 4803, 60, 1, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[112492, 4806, 65, 2, 70, "Input",
  CellTags->"overscripts"],
Cell[112560, 4810, 186, 5, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[112783, 4820, 62, 1, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[112848, 4823, 101, 3, 70, "Input",
  CellTags->"overscripts"],
Cell[112952, 4828, 143, 4, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[113132, 4837, 519, 18, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[113654, 4857, 143, 4, 70, "Input",
  CellTags->"overscripts"],
Cell[113800, 4863, 90, 1, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[113927, 4869, 58, 1, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[113988, 4872, 104, 2, 70, "Input",
  CellTags->"overscripts"],
Cell[114095, 4876, 96, 1, 70, "Text",
  CellTags->"overscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[114228, 4882, 304, 10, 70, "Subsubsection",
  CellTags->"overscripts"],
Cell[114535, 4894, 104, 2, 70, "Input",
  CellTags->"overscripts"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[114700, 4903, 59, 1, 38, "Section",
  CellTags->"underscripts"],

Cell[CellGroupData[{
Cell[114784, 4908, 163, 6, 70, "SubsectionIcon",
  CellTags->"underscripts"],
Cell[114950, 4916, 95, 1, 70, "Text",
  CellTags->"underscripts"],

Cell[CellGroupData[{
Cell[115070, 4921, 59, 1, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[115132, 4924, 94, 2, 70, "Input",
  CellTags->"underscripts"],
Cell[115229, 4928, 151, 4, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[115417, 4937, 989, 34, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[116409, 4973, 139, 4, 70, "Input",
  CellTags->"underscripts"],
Cell[116551, 4979, 123, 4, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[116711, 4988, 59, 1, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[116773, 4991, 97, 2, 70, "Input",
  CellTags->"underscripts"],
Cell[116873, 4995, 189, 5, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[117099, 5005, 305, 10, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[117407, 5017, 97, 2, 70, "Input",
  CellTags->"underscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[117553, 5025, 171, 6, 70, "SubsectionIcon",
  CellTags->"underscripts"],
Cell[117727, 5033, 223, 5, 70, "Text",
  CellTags->"underscripts"],

Cell[CellGroupData[{
Cell[117975, 5042, 975, 34, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[118953, 5078, 152, 4, 70, "Input",
  CellTags->"underscripts"],
Cell[119108, 5084, 142, 4, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[119287, 5093, 59, 1, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[119349, 5096, 78, 2, 70, "Input",
  CellTags->"underscripts"],
Cell[119430, 5100, 129, 4, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[119596, 5109, 68, 1, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[119667, 5112, 139, 4, 70, "Input",
  CellTags->"underscripts"],
Cell[119809, 5118, 86, 1, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[119932, 5124, 61, 1, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[119996, 5127, 105, 2, 70, "Input",
  CellTags->"underscripts"],
Cell[120104, 5131, 118, 4, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[120259, 5140, 305, 10, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[120567, 5152, 105, 2, 70, "Input",
  CellTags->"underscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[120721, 5160, 179, 6, 70, "SubsectionIcon",
  CellTags->"underscripts"],
Cell[120903, 5168, 121, 3, 70, "Text",
  CellTags->"underscripts"],
Cell[121027, 5173, 66, 2, 70, "Input",
  CellTags->"underscripts"],
Cell[121096, 5177, 187, 5, 70, "Text",
  CellTags->"underscripts"],

Cell[CellGroupData[{
Cell[121308, 5186, 63, 1, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[121374, 5189, 102, 3, 70, "Input",
  CellTags->"underscripts"],
Cell[121479, 5194, 145, 4, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[121661, 5203, 520, 18, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[122184, 5223, 145, 4, 70, "Input",
  CellTags->"underscripts"],
Cell[122332, 5229, 92, 1, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[122461, 5235, 59, 1, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[122523, 5238, 105, 2, 70, "Input",
  CellTags->"underscripts"],
Cell[122631, 5242, 91, 1, 70, "Text",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[122759, 5248, 305, 10, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[123067, 5260, 105, 2, 70, "Input",
  CellTags->"underscripts"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[123221, 5268, 261, 9, 70, "SubsectionIcon",
  CellTags->"underscripts"],

Cell[CellGroupData[{
Cell[123507, 5281, 564, 20, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[124074, 5303, 141, 4, 70, "Input",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[124252, 5312, 59, 1, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[124314, 5315, 99, 2, 70, "Input",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[124450, 5322, 517, 18, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[124970, 5342, 109, 2, 70, "Input",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[125116, 5349, 313, 10, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[125432, 5361, 98, 2, 70, "Input",
  CellTags->"underscripts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[125567, 5368, 62, 1, 70, "Subsubsection",
  CellTags->"underscripts"],
Cell[125632, 5371, 112, 2, 70, "Input",
  CellTags->"underscripts"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

