(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    807479,      27147]*)
(*NotebookOutlinePosition[   1232339,      37643]*)
(*  CellTagsIndexPosition[   1174307,      35901]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Options Guide", "Title"],

Cell[CellGroupData[{

Cell["Introduction", "Section"],

Cell[CellGroupData[{

Cell["The Option Inspector", "Subsection",
  CellTags->{"OptionsIntroduction", "A1.1"}],

Cell[TextData[{
  "Many aspects of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end",
  StyleBox[",",
    FontSlant->"Italic"],
  " such as the styles of cells, the appearance of notebooks, or the \
parameters used in typesetting, are controlled by options. For example, text \
attributes such as size, font, and color each correspond to a separate \
option. You can set options by directly editing the expression for a cell or \
notebook. But in most cases it is simpler to use the Option Inspector."
}], "Text",
  CellTags->{"OptionsIntroduction", "A1.1"}],

Cell["\<\
The Option Inspector is a special tool for viewing and modifying \
option settings. It provides a comprehensive listing of all front end \
options, grouped according to their function. You can specify not only the \
setting for an option, but also the level at which it will take effect, i.e. \
globally, for an entire notebook, or for a selection.\
\>", "Text",
  CellTags->{"OptionsIntroduction", "A1.1"}],

Cell[TextData[{
  "To use the Option Inspector, click ",
  StyleBox["Format \[RightTriangle] Option Inspector...",
    FontFamily->"Helvetica"],
  ". This brings up a dialog box with two pop-up menus on top. The pop-up \
menu on the right allows you to choose if you want the options listed by \
category, alphabetically, or as text. The pop-up menu on the left specifies \
the level at which options will take effect."
}], "Text",
  CellTags->{"OptionsIntroduction", "A1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Inheritance of Options", "Subsection",
  CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],

Cell["\<\
The Option Inspector allows you to set the value of an option on \
three different levels. In decreasing order of precedence, the levels are as \
follows.\
\>", "Text",
  CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]  Global -",
    FontWeight->"Bold"],
  " to set preferences for the entire application"
}], "Text",
  CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare]  ",
  StyleBox["Notebook -",
    FontWeight->"Bold"],
  " to set preferences for an entire notebook"
}], "Text",
  CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare]  ",
  StyleBox["Selection -",
    FontWeight->"Bold"],
  " to set preferences locally,",
  StyleBox[" e.g.",
    FontSlant->"Italic"],
  " for a group of cells, a single cell, or text within a cell "
}], "Text",
  CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],

Cell[TextData[{
  "The levels lower in the hierarchy inherit their options from the level \
immediately above them. For example, if a notebook has the option ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", by default all cells in the notebook will be editable. "
}], "Text",
  CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],

Cell[TextData[{
  "You can, however, override the inherited value of an option by explicitly \
changing its value. For example, if you do not want a particular cell in your \
notebook to be editable, you can select the cell and set ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " to ",
  StyleBox["False",
    FontFamily->"Courier"],
  ". This inheritance property of options provides you with a great deal of \
control over the behavior of the front end, since you can set any option to \
have different values at each level, as required."
}], "Text",
  CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],

Cell[TextData[{
  StyleBox["Note:",
    FontWeight->"Bold"],
  " At each level, only the options which can be set at that level are listed \
in the Option Inspector. All other options appear dimmed, indicating that \
they cannot be changed unless you go to a higher or lower level."
}], "Text",
  CellTags->{"Introduction", "OptionsInheritance", "A1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Searching for an Option", "Subsection",
  CellTags->{"Introduction", "OptionsSearching", "A1.3"}],

Cell[TextData[{
  "To search for a specific option, type its name or part of its name in the \
Lookup text field, and click ",
  StyleBox["Lookup",
    FontFamily->"Helvetica"],
  " or press the R",
  StyleBox["ETURN",
    FontSize->9],
  " key, \[ReturnKey]. The Option Inspector goes to the first matching \
option. Click ",
  StyleBox["Lookup",
    FontFamily->"Helvetica"],
  " or press \[ReturnKey] again to go to the next matching item on the list. \
"
}], "Text",
  CellTags->{"Introduction", "OptionsSearching", "A1.3"}],

Cell["\<\
Each line in the list of options gives the option name followed by \
its current value. You can change the option's value by choosing from the \
pop-up menu at the right, or by selecting the value itself, typing over it, \
and pressing \[ReturnKey]. \
\>", "Text",
  CellTags->{"Introduction", "OptionsSearching", "A1.3"}],

Cell[TextData[{
  "When you start ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for the first time, the values of all the options are set at their \
default values. Each time you modify one of the options, a bullet symbol \
appears next to it, indicating that its value has been changed. Clicking the \
bullet resets the option to its default value. "
}], "Text",
  CellTags->{"Introduction", "OptionsSearching", "A1.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Setting Options: An Example", "Subsection",
  CellTags->{"Introduction", "OptionsSetting", "A1.4"}],

Cell[TextData[{
  "Suppose you want to draw a frame around a cell. The option that controls \
this property of a cell is called ",
  StyleBox["CellFrame",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->"A1.4"],

Cell[TextData[StyleBox["To draw a frame around a cell:",
  FontWeight->"Bold"]], "Text",
  CellTags->{"Introduction", "OptionsSetting", "A1.4"}],

Cell[TextData[{
  StyleBox["  1. ",
    FontWeight->"Bold"],
  " Select the cell by clicking on it."
}], "ItemizedText",
  CellTags->{"Introduction", "OptionsSetting", "A1.4"}],

Cell[TextData[{
  StyleBox["  2.  ",
    FontWeight->"Bold"],
  "Click ",
  StyleBox["Format \[RightTriangle] Option Inspector...",
    FontFamily->"Helvetica"],
  " to open the Option Inspector window."
}], "ItemizedText",
  CellTags->{"Introduction", "OptionsSetting", "A1.4"}],

Cell[TextData[{
  StyleBox["  3. ",
    FontWeight->"Bold"],
  " Click ",
  StyleBox["Selection",
    FontFamily->"Helvetica"],
  " from the first pop-up menu."
}], "ItemizedText",
  CellTags->{"Introduction", "OptionsSetting", "A1.4"}],

Cell[TextData[{
  StyleBox["  4. ",
    FontWeight->"Bold"],
  " Click ",
  StyleBox["Cell Options \[RightTriangle] Display Options.",
    FontFamily->"Helvetica"],
  " This gives a list of all options that control how a cell is displayed in \
the notebook."
}], "ItemizedText",
  CellTags->{"Introduction", "OptionsSetting", "A1.4"}],

Cell[TextData[{
  StyleBox["  5. ",
    FontWeight->"Bold"],
  " Click the box next to the option ",
  StyleBox["CellFrame",
    FontFamily->"Courier"],
  " and use the pop-up menu displayed to change the setting to \
\[OpenCurlyDoubleQuote]True.\[CloseCurlyDoubleQuote] A bullet appears next to \
the option, indicating its value has been changed. The cell that you had \
selected now has a frame drawn around it."
}], "ItemizedText",
  CellTags->{"Introduction", "OptionsSetting", "A1.4"}],

Cell[TextData[{
  "Alternatively, you can type \[OpenCurlyDoubleQuote]cellframe\
\[CloseCurlyDoubleQuote] in the textbox and click ",
  StyleBox["Lookup. ",
    FontFamily->"Helvetica"],
  "This leads you directly to the ",
  StyleBox["CellFrame",
    FontFamily->"Courier"],
  " option without having to search by category. The ",
  StyleBox["Lookup",
    FontFamily->"Helvetica"],
  " feature provides a useful way to locate an option if you are unsure of \
the category it belongs in."
}], "Text",
  CellTags->{"Introduction", "OptionsSetting", "A1.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Global Options", "Section"],

Cell[CellGroupData[{

Cell["File Locations", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["NotebookDirectory", "ObjectName",
  CellTags->{"1.1.1.1.1", "1.1.1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebookDirectory",
    FontFamily->"Courier"],
  " is a global option that determines the current working directory."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.1.2", "1.1.1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebookDirectory",
    FontFamily->"Courier"],
  " determines the default location from which notebooks are opened or to \
which notebooks are saved. \n\[FilledSmallSquare] The default setting of this \
option is system-dependent. \n\[FilledSmallSquare] The setting for ",
  StyleBox["NotebookDirectory",
    FontFamily->"Courier"],
  " changes during a session if you use a File menu command that changes the \
default directory, such as ",
  StyleBox["Open",
    FontFamily->"Helvetica"],
  ", ",
  StyleBox["Save",
    FontFamily->"Helvetica"],
  ", or ",
  StyleBox["Save As...",
    FontFamily->"Helvetica"],
  ".\n\[FilledSmallSquare] To change the setting for this option, click the \
square symbol at the right of the option and select a directory from the \
dialog box that appears. You can also type in a directory name by using the \
",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function and pressing \[ReturnKey]."
}], "Notes",
  CellTags->{"1.1.1.1.3", "1.1.1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["NotebookPath ", "ObjectName",
  CellTags->{"1.1.1.2.1", "1.1.1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebookPath",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is a global option that determines which directories are searched when a \
specified notebook is needed."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.2.2", "1.1.1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The front end searches the directories specified by \
",
  StyleBox["NotebookPath",
    FontFamily->"Courier"],
  " if it needs to locate a notebook whose pathname has not been specified \
explicitly. Three such cases are: when you click a hyperlink pointing to an \
external notebook; when you try to open a notebook listed under the ",
  StyleBox["File \[RightTriangle] Notebooks",
    FontFamily->"Helvetica"],
  " submenu; and when you specify a style sheet that is not found on ",
  StyleBox["StyleSheetPath.",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] The directories to be searched are specified using \
the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function or in terms of global variables such as ",
  StyleBox["$InstallationDirectory",
    FontFamily->"Courier"],
  " or ",
  StyleBox["$HomeDirectory",
    FontFamily->"Courier"],
  ". Typical directories included in ",
  StyleBox["NotebookPath",
    FontFamily->"Courier"],
  " are ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  StyleBox["[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$PreferencesDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"FrontEnd\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Palettes\"}",
    FontFamily->"Courier"],
  StyleBox["]",
    FontFamily->"Courier"],
  " and ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  StyleBox["[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$InstallationDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"SystemFiles\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"FrontEnd\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Palettes\"}",
    FontFamily->"Courier"],
  StyleBox["]",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"],
  StyleBox["\n\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location."
}], "Notes",
  CellTags->{"1.1.1.2.3", "1.1.1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PalettePath ", "ObjectName",
  CellTags->{"1.1.1.3.1", "1.1.1.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PalettePath",
    FontFamily->"Courier"],
  " is a global option that determines which directories ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " searches for palettes on startup.  "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.3.2", "1.1.1.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] The directories to be searched are specified using \
the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. Typical directories included in ",
  StyleBox["PalettePath",
    FontFamily->"Courier"],
  " are ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  StyleBox["[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$PreferencesDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"FrontEnd\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Palettes\"}",
    FontFamily->"Courier"],
  StyleBox["]",
    FontFamily->"Courier"],
  StyleBox[" and",
    FontFamily->"Times"],
  " ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  StyleBox["[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$InstallationDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"SystemFiles\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"FrontEnd\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Palettes\"}",
    FontFamily->"Courier"],
  StyleBox["]",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] The ",
  StyleBox["File \[RightTriangle] Palettes",
    FontFamily->"Helvetica"],
  " submenu lists all the notebooks found in the directories specified by ",
  StyleBox["PalettePath",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location."
}], "Notes",
  CellTags->{"1.1.1.3.3", "1.1.1.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoOpenPalettes", "ObjectName",
  CellTags->{"1.1.1.4.1", "1.1.1.4"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  StyleBox[" AutoOpenPalettes",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines which palettes are automatically opened when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is started.  "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.4.2", "1.1.1.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The value of ",
  StyleBox["AutoOpenPalettes",
    FontFamily->"Courier"],
  " automatically changes to reflect the palettes that are left open each \
time you quit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". \n\[FilledSmallSquare] The default setting is ",
  StyleBox["AutoOpenPalettes",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["{\"BasicInput.nb\"}",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location."
}], "Notes",
  CellTags->{"1.1.1.4.3", "1.1.1.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoOpenNotebooks", "ObjectName",
  CellTags->"1.1.1.4b"],

Cell[TextData[{
  "\[FilledSmallSquare]",
  StyleBox[" AutoOpenNotebooks",
    FontFamily->"Courier"],
  " is a global option that specifies which notebooks should be automatically \
opened when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is started.  "
}], "Usage",
  CellDingbat->None,
  CellTags->"1.1.1.4b"],

Cell[TextData[{
  "\[FilledSmallSquare]  ",
  StyleBox["AutoOpenNotebooks",
    FontFamily->"Courier"],
  " is set to a list of notebook names. For a notebook in the list to be \
opened on startup, it must reside in one of the directories specified by the \
global option ",
  StyleBox["PrivatePaths",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"TextResources\"",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] The default setting, ",
  StyleBox["AutoOpenNotebooks",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["{\"MathematicaNavigator.nb\"}",
    FontFamily->"Courier"],
  ", identifies the startup palette that  appears on the screen when you \
first start ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a notebook. \n\[FilledSmallSquare] See also: \
",
  StyleBox[ButtonBox["PrivatePaths",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->"1.1.1.4b"]
}, Closed]],

Cell[CellGroupData[{

Cell["StyleSheetPath ", "ObjectName",
  CellTags->{"1.1.1.5.1", "1.1.1.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["StyleSheetPath",
    FontFamily->"Courier"],
  " is a global option that determines which directories ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " searches to find style sheets.   "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.5.2", "1.1.1.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] The directories to be searched are specified using \
the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. Typical directories included in ",
  StyleBox["StyleSheetPath",
    FontFamily->"Courier"],
  " are ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  StyleBox["[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$PreferencesDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"FrontEnd\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"StyleSheets\"}",
    FontFamily->"Courier"],
  StyleBox["]",
    FontFamily->"Courier"],
  " ",
  StyleBox["and ",
    FontFamily->"Times"],
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  StyleBox["[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$InstallationDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"SystemFiles\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"FrontEnd\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"StyleSheets\"}",
    FontFamily->"Courier"],
  StyleBox["]",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] The ",
  StyleBox["Format \[RightTriangle] Style Sheet",
    FontFamily->"Helvetica"],
  " submenu lists all style sheets found in the directories specified by ",
  StyleBox["StyleSheetPath",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location."
}], "Notes",
  CellTags->{"1.1.1.5.3", "1.1.1.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DefaultNotebook ", "ObjectName",
  CellTags->{"1.1.1.6.1", "1.1.1.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DefaultNotebook",
    FontFamily->"Courier"],
  " is a global option that determines which notebook is used as a template \
for all new notebooks. "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.6.2", "1.1.1.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default notebook determines the properties of new \
notebooks, such as the appearance of the scroll bars and frame and if the \
toolbar and ruler are visible.  \n\[FilledSmallSquare] The default setting is \
",
  StyleBox["\"DefaultTemplate.nb\"",
    FontFamily->"Courier"],
  ".  \n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then select a notebook from the \
dialog box that appears."
}], "Notes",
  CellTags->{"1.1.1.6.3", "1.1.1.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DefaultStyleDefinitions ", "ObjectName",
  CellTags->{"1.1.1.7.1", "1.1.1.7"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  StyleBox[" DefaultStyleDefinitions",
    FontFamily->"Courier"],
  " is a global option that determines the default style sheet for all new \
notebooks. "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.7.2", "1.1.1.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] The notebook must be located in a directory that is \
listed in ",
  StyleBox["StyleSheetPath",
    FontFamily->"Courier"],
  ".  \n\[FilledSmallSquare] The default setting is ",
  StyleBox["\"Default.nb\"",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then select a notebook from the \
dialog box that appears."
}], "Notes",
  CellTags->{"1.1.1.7.3", "1.1.1.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PreferencesPath ", "ObjectName",
  CellTags->{"1.1.1.8.1", "1.1.1.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PreferencesPath",
    FontFamily->"Courier"],
  " is a global option that determines which directories are searched for \
preferences when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is started up. "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.8.2", "1.1.1.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] All files with the name \"init.m\" are read. If a \
setting is listed in more than one file, the last setting read is used. The \
init.m file in the last directory specified is the one modified by the front \
end to save user preferences.\n\[FilledSmallSquare] ",
  StyleBox["PreferencesPath",
    FontFamily->"Courier"],
  " defines preferences for individual users, while ",
  StyleBox["ConfigurationPath",
    FontFamily->"Courier"],
  " defines system-wide preferences for multiple machines running ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on a network. This is possible because the init.m files in ",
  StyleBox["PreferencesPath",
    FontFamily->"Courier"],
  " are read after those in ",
  StyleBox["ConfigurationPath.",
    FontFamily->"Courier"],
  "Hence any settings defined by individual users override the default \
settings for the system.\n\[FilledSmallSquare] The directories are specified \
using the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. Typical directories included on ",
  StyleBox["PreferencesPath",
    FontFamily->"Courier"],
  " are ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$PreferencesDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"FrontEnd\"}]",
    FontFamily->"Courier"],
  " and ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$InstallationDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"SystemFiles\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"FrontEnd\"}]",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location.\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " See also: ",
  StyleBox[ButtonBox["ConfigurationPath",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.1.8.3", "1.1.1.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ConfigurationPath ", "ObjectName",
  CellTags->{"1.1.1.9.1", "1.1.1.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ConfigurationPath",
    FontFamily->"Courier"],
  " is a global option that determines which directories are searched for \
configuration information.  "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.9.2", "1.1.1.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] Files with configuration information are called \
\"init.m\". If a setting is listed in more than one file, the last setting \
read is used.  \n\[FilledSmallSquare] The directories are specified using the \
",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. A typical directory included on ",
  StyleBox["ConfigurationPath",
    FontFamily->"Courier"],
  " is ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$InstallationDirectory, \"Configuration\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"FrontEnd\"}]",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["ConfigurationPath",
    FontFamily->"Courier"],
  " defines system-wide preferences for multiple machines running ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on a network, while ",
  StyleBox["PreferencesPath",
    FontFamily->"Courier"],
  " defines preferences for individual users. This is possible because the \
init.m files in ",
  StyleBox["PreferencesPath",
    FontFamily->"Courier"],
  " are read after those in ",
  StyleBox["ConfigurationPath. ",
    FontFamily->"Courier"],
  "Hence, any settings defined by individual users override the default \
settings for the system.\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location.\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " See also: ",
  StyleBox[ButtonBox["PreferencesPath",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.1.9.3", "1.1.1.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SystemHelpPath ", "ObjectName",
  CellTags->{"1.1.1.10.1", "1.1.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SystemHelpPath",
    FontFamily->"Courier"],
  " is a global option that determines which directories are searched for the \
help notebooks used within the Help Browser."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.10.2", "1.1.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] The directories to be searched are specified using \
the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. Typical directories included on ",
  StyleBox["SystemHelpPath",
    FontFamily->"Courier"],
  " are ",
  StyleBox["$InstallationDirectory",
    FontFamily->"Courier"],
  " and ",
  StyleBox["$PreferencesDirectory",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] The help notebooks should be in a subdirectory \
called ",
  StyleBox["Documentation",
    FontFamily->"Courier"],
  StyleBox["/", "Program"],
  StyleBox["language",
    FontSlant->"Italic"],
  StyleBox[", ", "Program",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["where ", "Program",
    FontFamily->"Times"],
  StyleBox["language",
    FontSlant->"Italic"],
  StyleBox[" ", "Program",
    FontFamily->"Times"],
  "is determined by the value of the global variable ",
  StyleBox["$Language",
    FontFamily->"Courier"],
  StyleBox[".", "Program",
    FontFamily->"Times"],
  " It can be any language recognized by the system, such as English, French, \
or German.\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location."
}], "Notes",
  CellTags->{"1.1.1.10.3", "1.1.1.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AddOnHelpPath ", "ObjectName",
  CellTags->{"1.1.1.11.1", "1.1.1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AddOnHelpPath",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the list of directories searched for additional help \
files used within the Help Browser. "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.11.2", "1.1.1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] These help files are used for packages contained \
within the ",
  StyleBox["AddOns", "Program"],
  " directory, such as standard packages or application packs. \n\
\[FilledSmallSquare] The directories are specified using the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. Typical directories included on ",
  StyleBox["PreferencesPath",
    FontFamily->"Courier"],
  " are ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$PreferencesDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Addons\", \"Applications\"}]",
    FontFamily->"Courier"],
  " and ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$InstallationDirectory, \"AddOns\", \"Standard\"}]",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"],
  "\n\[FilledSmallSquare] The help notebooks should be in a subdirectory \
called ",
  StyleBox["Documentation",
    FontFamily->"Courier"],
  StyleBox["/", "Program"],
  StyleBox["language",
    FontSlant->"Italic"],
  StyleBox[", ", "Program",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["where ", "Program",
    FontFamily->"Times"],
  StyleBox["language",
    FontSlant->"Italic"],
  StyleBox[" ", "Program",
    FontFamily->"Times"],
  "is determined by the value of the global variable ",
  StyleBox["$Language",
    FontFamily->"Courier"],
  StyleBox[".", "Program",
    FontFamily->"Times"],
  " It can be any language recognized by the system, such as English, French, \
or German.\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location."
}], "Notes",
  CellTags->{"1.1.1.11.3", "1.1.1.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoloadPath ", "ObjectName",
  CellTags->{"1.1.1.12.1", "1.1.1.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoloadPath",
    FontFamily->"Courier"],
  " is a global option that determines from which directories packages are \
automatically loaded when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is started. "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.12.2", "1.1.1.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] For each directory on the list, the front end \
searches for a subdirectory called ",
  StyleBox["FrontEnd", "Output"],
  " and for a file called ",
  StyleBox["init.m", "Output"],
  " in that directory.  It will execute the contents of all such ",
  StyleBox["init.m", "Output"],
  " files it finds.\n\[FilledSmallSquare] The directories are specified using \
the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. Typical directories included on ",
  StyleBox["AutoloadPath",
    FontFamily->"Courier"],
  " are ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$PreferencesDirectory, \"Addons\", \"Autoload\"}]",
    FontFamily->"Courier"],
  " and ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$InstallationDirectory, \"AddOns\", \"Autoload\"}]",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location."
}], "Notes",
  CellTags->{"1.1.1.12.3", "1.1.1.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SpellingDictionariesPath ", "ObjectName",
  CellTags->{"1.1.1.13.1", "1.1.1.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SpellingDictionariesPath",
    FontFamily->"Courier"],
  " is a global option that determines which directories are searched for \
spelling dictionaries when the",
  StyleBox[" Edit \[RightTriangle] Check Spelling... ",
    FontFamily->"Helvetica"],
  "menu command is used."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.13.2", "1.1.1.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] The directories to be searched are specified using \
the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. A typical directory included on ",
  StyleBox["SpellingDictionariesPath",
    FontFamily->"Courier"],
  " is ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$PreferencesDirectory,",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Addons\", \"Autoload\", \"SystemFiles\", \"SpellingDictionaries\
\"}]",
    FontFamily->"Courier"],
  ".",
  StyleBox["\n\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location.\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " See also: ",
  StyleBox[ButtonBox["SpellingDictionaries",
    ButtonData:>"SpellingDictionaries->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.1.13.3", "1.1.1.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CharacterEncodingsPath ", "ObjectName",
  CellTags->{"1.1.1.14.1", "1.1.1.14"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] CharacterEncodingsPath",
    FontFamily->"Courier"],
  " is a global option that determines which directories are searched for \
character encoding files."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.14.2", "1.1.1.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] The directories to be searched are specified using \
the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. Typical directories included on ",
  StyleBox["AutoloadPath",
    FontFamily->"Courier"],
  " are ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$PreferencesDirectory, \"CharacterEncodings\"}]",
    FontFamily->"Courier"],
  " and ",
  StyleBox["FrontEnd`FileName[",
    FontFamily->"Courier"],
  "{",
  StyleBox["$InstallationDirectory, \"SystemFiles\", \
\"CharacterEncodings\"}]",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location.\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " See also: ",
  StyleBox[ButtonBox["CharacterEncoding",
    ButtonData:>"2.7.8",
    ButtonStyle->"MainBookLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.1.14.3", "1.1.1.14"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PrivatePaths\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->"1.1.1.15"],

Cell[TextData[{
  StyleBox["PrivatePaths",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that specify the location of various system \
resources, including fonts and text messages. If these options are changed \
carelessly, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " may be unable to locate basic components that it requires for operation. \
If this happens, you may need to delete or manually edit your preferences \
file to restore correct functioning to the system."
}], "Text",
  CellTags->"1.1.1.15"],

Cell[CellGroupData[{

Cell["\"TextResources\"", "SubObjectNameClosed",
  CellTags->{"1.1.1.15.1.1", "1.1.1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["TextResources",
    FontFamily->"Courier"],
  "\" is a global option that determines the directories to be searched for \
locating ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " text resources. "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.15.1.2", "1.1.1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] Text resources are ASCII files that contain the text \
of items such as dialog boxes, error messages, and menu commands.\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location. \n\[FilledSmallSquare] \
The directories are specified using the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. A typical directory that is included in the list is ",
  StyleBox["FrontEnd`FileName[{$InstallationDirectory, \"System Files\", \
\"FrontEnd\", \"SystemResources\"}].",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.1.1.15.1.3", "1.1.1.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SystemResources\"", "SubObjectNameClosed",
  CellTags->{"1.1.1.15.1.1", "1.1.1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["SystemResources",
    FontFamily->"Courier"],
  "\" is a global option that determines the directories to be searched for \
locating ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "system resources. "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.15.1.2", "1.1.1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] The directories are specified using the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. A typical directory that is included in the list is ",
  StyleBox["FrontEnd`FileName[{$InstallationDirectory, \"System Files\", \
\"FrontEnd\", \"TextResources\"}].",
    FontFamily->"Courier"],
  "\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location. "
}], "Notes",
  CellTags->{"1.1.1.15.1.3", "1.1.1.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"AFM\" ", "SubObjectNameClosed",
  CellTags->{"1.1.1.15.2.1", "1.1.1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["AFM",
    FontFamily->"Courier"],
  "\" is a global option that determines the directories to be searched for \
locating Adobe Font Metrics files (Unix only)."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.15.2.2", "1.1.1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] The Adobe Font Metrics files contain information \
about fonts. \n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location.\n\[FilledSmallSquare] \
The directories are specified using the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. A typical directory that is included in the list is ",
  StyleBox["FrontEnd`FileName[{$InstallationDirectory, \"System Files\", \
\"Fonts\", \"AFM\"}].",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.1.1.15.2.3", "1.1.1.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Fonts\"", "SubObjectNameClosed",
  CellTags->{"1.1.1.15.3.1", "1.1.1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Fonts\"",
    FontFamily->"Courier"],
  " is a global option that determines the directories to be searched for \
locating ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.1.15.3.2", "1.1.1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] The directories are specified using the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function. Typical directories that are included in the list are ",
  StyleBox["FrontEnd`FileName[{$InstallationDirectory, \"System Files\", \
\"Fonts\"}]",
    FontFamily->"Courier"],
  " and ",
  StyleBox["FrontEnd`FileName[{$PreferencesDirectory, \"Fonts\"}]",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " To change the setting for this option, click the square symbol at the \
right of the option to bring up a dialog box. Then click the appropriate \
button to add, remove, or edit a directory location."
}], "Notes",
  CellTags->{"1.1.1.15.3.3", "1.1.1.15"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Data Import/Export Options", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["ImportAutoReplacements", "ObjectName",
  CellTags->"1.1.2.0a"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ImportAutoReplacements",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should automatically apply a specified set of replacement rules when \
importing text. "
}], "Usage",
  CellTags->"1.1.2.0a"],

Cell[TextData[{
  "\[FilledSmallSquare] The replacement rules to be applied are specified as \
a list, each element of which has the form ",
  StyleBox["\"string1",
    FontSlant->"Italic"],
  "\"",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  "\"",
  StyleBox["string2",
    FontSlant->"Italic"],
  "\".\n\[FilledSmallSquare] This option allows you to control the appearance \
of selected expressions or operators in a notebook. Some replacement rules \
that are usually set by default are as follows.\n     ",
  StyleBox["\"->\" \[Rule] \"\[Backslash][Rule]\"\n  \":>\" \[Rule] \"\
\[Backslash][RuleDelayed]\"\n  \"<=\" \[Rule] \"\[Backslash][LessEqual]\"\n  \
\">=\" \[Rule] \"\[Backslash][GreaterEqual]\"\n  \"!=\" \[Rule]  \"\
\[Backslash][NotEqual]\"\n  \"==\" \[Rule]  \"\[Backslash][Equal]\"\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] See also: ",
  ButtonBox["InputAutoReplacements",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["ExportAutoReplacements",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"1.1.2.0a"]
}, Closed]],

Cell[CellGroupData[{

Cell["ExportAutoReplacements", "ObjectName",
  CellTags->"1.1.2.0b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ExportAutoReplacements",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should automatically apply a specified set of replacement rules when \
exporting text."
}], "Usage",
  CellTags->"1.1.2.0b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ExportAutoReplacements",
    FontFamily->"Courier"],
  " is specified as a list, each element of which is a replacement rule of \
the form \"",
  StyleBox["string1",
    FontSlant->"Italic"],
  "\"",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  "\"",
  StyleBox["string2",
    FontSlant->"Italic"],
  "\".\n\[FilledSmallSquare] This option allows you to control the appearance \
of selected expressions or operators in a notebook. Some replacement rules \
that are usually set by default are as follows.\n     ",
  StyleBox["\"->\" \[Rule] \"\[Backslash][Rule]\"\n  \":>\" \[Rule] \"\
\[Backslash][RuleDelayed]\"\n  \"<=\" \[Rule] \"\[Backslash][LessEqual]\"\n  \
\">=\" \[Rule] \"\[Backslash][GreaterEqual]\"\n  \"!=\" \[Rule]  \"\
\[Backslash][NotEqual]\"\n  \"==\" \[Rule]  \"\[Backslash][Equal]\"\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] See also: ",
  ButtonBox["InputAutoReplacements",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["ImportAutoReplacements",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"1.1.2.0b"]
}, Closed]],

Cell[CellGroupData[{

Cell["OpenSpecialOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.2.1.1", "1.1.2.1"}],

Cell[TextData[{
  StyleBox["OpenSpecialOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that specify the settings used in importing \
files via the ",
  StyleBox["File \[RightTriangle] Open Special...",
    FontFamily->"Helvetica"],
  " command. It consists of the following ",
  "suboptions",
  "."
}], "Text",
  CellTags->{"1.1.2.1.2", "1.1.2.1"}],

Cell[CellGroupData[{

Cell["\"ReadingType\" ", "SubObjectNameClosed",
  CellTags->{"1.1.2.1.1.1", "1.1.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ReadingType\"",
    FontFamily->"Courier"],
  " is a global option that determines how the contents of a notebook being \
imported are handled. "
}], "Usage",
  CellTags->{"1.1.2.1.1.2", "1.1.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["ReadingType\" \[Rule] IgnoreFileOutlineCache",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " disregards the file cache that contains information about the number, \
style, and position of all cells in a notebook. \n\[FilledSmallSquare] Other \
possible settings for \"",
  StyleBox["ReadingType\"",
    FontFamily->"Courier"],
  " are as follows.\n   ",
  StyleBox["AllInOneCell                ",
    FontFamily->"Courier"],
  "The contents of the file are placed in a single cell.                      \
                                                                     \n   ",
  StyleBox["NewCellAtEveryLine          ",
    FontFamily->"Courier"],
  "A new cell is created at every new line.\n   ",
  StyleBox["NewCellAtEveryBlankLine     ",
    FontFamily->"Courier"],
  "A new cell is created at every blank line.\n   ",
  StyleBox["NewCellAtEveryTwoBlankLines ",
    FontFamily->"Courier"],
  "A new cell is created at every two blank lines.\n   ",
  StyleBox["ExtractSystemResources      ",
    FontFamily->"Courier"],
  "This setting (for Macintosh only) causes resources \n                     \
\t\t\t\t         such as text, PICT, sound, and QuickTime files that\n        \
             \t\t\t\t         are included in the resource fork to be \
imported along\n                     \t\t\t\t         with the file.   "
}], "Notes",
  CellTags->{"1.1.2.1.1.3", "1.1.2.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CharacterEncoding\" ", "SubObjectNameClosed",
  CellTags->{"1.1.2.1.2.1", "1.1.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CharacterEncoding\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the encoding used when reading an imported file."
}], "Usage",
  CellTags->{"1.1.2.1.2.2", "1.1.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] The front end searches all directories specified by \
the option ",
  StyleBox["CharacterEncodingPath",
    FontFamily->"Courier"],
  " to locate a character encoding file. The default location for character \
encoding files is ",
  StyleBox["$InstallationDirectory/SystemFiles/CharacterEncodings. \n ",
    FontFamily->"Courier"],
  "See also: ",
  StyleBox[ButtonBox["CharacterEncodingsPath",
    ButtonData:>"CharacterEncodingsPath",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] With the default setting \"",
  StyleBox["CharacterEncoding\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["$SystemCharacterEncoding",
    FontFamily->"Courier"],
  ", the default character encoding file for the platform is used. \n\
\[FilledSmallSquare] Other possible settings for \"",
  StyleBox["CharacterEncoding\"",
    FontFamily->"Courier"],
  " include ",
  StyleBox["ASCII",
    FontFamily->"Courier"],
  ", ",
  StyleBox["AdobeStandard",
    FontFamily->"Courier"],
  ", ",
  StyleBox["MacintoshRoman",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Unicode",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Symbol",
    FontFamily->"Courier"],
  ", ",
  StyleBox["ZapfDingbats",
    FontFamily->"Courier"],
  ",",
  StyleBox[" ",
    FontWeight->"Bold"],
  "or any of the various ISO encoding systems. "
}], "Notes",
  CellTags->{"1.1.2.1.2.3", "1.1.2.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ListAllFileTypes\" ", "SubObjectNameClosed",
  CellTags->{"1.1.2.1.3.1", "1.1.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ListAllFileTypes\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " the Open dialog box, accessed from the",
  StyleBox[" File \[RightTriangle] Open Special... ",
    FontFamily->"Helvetica"],
  "command, displays all files in the selected directory or only those that \
are readable by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  "
}], "Usage",
  CellTags->{"1.1.2.1.3.2", "1.1.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"ListAllFileTypes\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["False",
    FontFamily->"Courier"],
  ",",
  StyleBox[" ",
    FontWeight->"Bold"],
  "only those files in the current directory that can be read by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are listed in the dialog box. \n\[FilledSmallSquare] With the setting ",
  StyleBox["\"ListAllFileTypes\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["True",
    FontFamily->"Courier"],
  ",",
  StyleBox[" ",
    FontWeight->"Bold"],
  "all files present in the current directory are listed."
}], "Notes",
  CellTags->{"1.1.2.1.3.3", "1.1.2.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ToPostScriptOptions\[LongRightArrow]{\[Ellipsis]} ", "GroupObjectName",
  Background->None,
  CellTags->"1.1.2.2"],

Cell[TextData[{
  StyleBox["ToPostScriptOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that specify the settings used when \
importing PostScript files. This option can be used to generate \
black-and-white postscript images for use with B/W printers. This is useful \
because some printers may not support the PostScript colorimage operator, and \
because the B/W version will occupy three times less disk space. The option \
consists of the following suboptions."
}], "Text",
  CellTags->{"1.1.2.2.2", "1.1.2.2"}],

Cell[CellGroupData[{

Cell["\"RemoveColorFromBitmaps\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.2.1.1", "1.1.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["RemoveColorFromBitmaps\"",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is a global option that determines ",
  "if",
  " bitmaps representing graphics should preserve color information when the \
file is saved. "
}], "Usage",
  CellTags->{"1.1.2.2.1.2", "1.1.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option can be used to generate B/W PostScript \
images for use with B/W printers. This is useful because some printers may \
not support the PostScript colorimage operator, and because the B/W version \
occupies three times less disk space.\n\[FilledSmallSquare] With the default \
setting \"",
  StyleBox["RemoveColorFromBitmaps\" \[Rule] False",
    FontFamily->"Courier"],
  ",",
  StyleBox[" ",
    FontWeight->"Bold"],
  "the colors of bitmapped graphics are preserved when converted to \
PostScript.\n\[FilledSmallSquare] With the setting \"",
  StyleBox["RemoveColorFromBitmaps\" \[Rule] True",
    FontFamily->"Courier"],
  ", all information about the color of bitmapped graphics is lost when \
converted to PostScript."
}], "Notes",
  CellTags->{"1.1.2.2.1.3", "1.1.2.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeSpecialFonts\" ", "SubObjectNameClosed",
  CellTags->"1.1.2.2.1.2b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"IncludeSpecialFonts\"",
    FontFamily->"Courier"],
  " is a global option that determines if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts should be included when a file is sent to be printed. "
}], "Usage",
  CellTags->"1.1.2.2.1.2b"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"IncludeSpecialFonts\" \[Rule] \"True\"",
    FontFamily->"Courier"],
  ", the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts are included with the print output. \n\[FilledSmallSquare] You can \
force the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts to be excluded from the print output by setting ",
  StyleBox["\"IncludeSpecialFonts\" \[Rule] \"False\"",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] This option is typically set from the Print dialog \
box."
}], "Notes",
  CellTags->"1.1.2.2.1.2b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "\"",
  StyleBox["IgnoreEmbeddedPostScript\"",
    FontFamily->"Courier"]
}], "SubObjectNameClosed",
  CellTags->{"1.1.2.2.2.1", "1.1.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IgnoreEmbeddedPostScript\"",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is a global option that determines if PostScript commands in a  graphics \
being imported should be interpreted by ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " "
}], "Usage",
  CellTags->{"1.1.2.2.2.2", "1.1.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["IgnoreEmbeddedPostScript\" \[Rule] True",
    FontFamily->"Courier"],
  ", PostScript commands embedded in a graphics file are ignored when the \
file is imported. \n\[FilledSmallSquare] With the setting \"",
  StyleBox["IgnoreEmbeddedPostScript\" \[Rule] False",
    FontFamily->"Courier"],
  ", PostScript commands embedded in a graphics file are preserved."
}], "Notes",
  CellTags->{"1.1.2.2.2.3", "1.1.2.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"BitsPerPixel\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.2.3.1", "1.1.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["BitsPerPixel\"",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is a global option that determines the number of bits used to represent a \
single pixel or color (for color images). "
}], "Usage",
  CellTags->{"1.1.2.2.3.2", "1.1.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option controls the resolution used in \
PostScript image/colorimage operators.\n\[FilledSmallSquare] The default \
setting is \"",
  StyleBox["BitsPerPixel\" \[Rule] 8",
    FontFamily->"Courier"],
  ". The value can be set lower or higher depending on the resolution \
desired. "
}], "Notes",
  CellTags->{"1.1.2.2.3.3", "1.1.2.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ImportTypesetOptions\[LongRightArrow]{\[Ellipsis]} ", "GroupObjectName",
  Background->None,
  CellTags->"1.1.2.2.x"],

Cell[CellGroupData[{

Cell["\"FormatType\"", "SubObjectNameClosed",
  CellTags->"1.1.2.2.x"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FormatType\"", "MR"],
  " ",
  "is a global option",
  " that determines the format in which a group of cells is saved when it is \
exported. "
}], "Usage",
  CellTags->"1.1.2.2.x"],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows. \n  ",
  StyleBox["\"Text\"                    \"PostScript\" \n \"InputText\"       \
        \"Bitmap\"\n \"Package\"                 \"PICT\"             ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CellExpression\"          \"PICTBitmap\"       ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"NotebookExpression\"      \"PICTEmbeddedPS\"   ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CompleteNotebook\"        \"QuickTime\"        ",
    FontFamily->"Courier"],
  "(Macintosh only)"
}], "Notes",
  CellTags->"1.1.2.2.x"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
ExportMultipleCellsOptions\[LongRightArrow]{\[Ellipsis]} \
\>", \
"GroupObjectName",
  Background->None,
  CellTags->"1.1.2.3"],

Cell[TextData[{
  StyleBox["ExportMultipleCellsOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that specify the settings used in exporting \
multiple cells. It consists of the following ",
  "suboptions",
  "."
}], "Text",
  CellTags->"1.1.2.3"],

Cell[CellGroupData[{

Cell["\"FormatType\"", "SubObjectNameClosed",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FormatType\"", "MR"],
  " ",
  "is a global option",
  " that determines the format in which a group of cells is saved when it is \
exported. "
}], "Usage",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows. \n  ",
  StyleBox["\"Text\"                    \"PostScript\" \n \"InputText\"       \
        \"Bitmap\"\n \"Package\"                 \"PICT\"             ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CellExpression\"          \"PICTBitmap\"       ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"NotebookExpression\"      \"PICTEmbeddedPS\"   ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CompleteNotebook\"        \"QuickTime\"        ",
    FontFamily->"Courier"],
  "(Macintosh only)"
}], "Notes",
  CellTags->"1.1.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageWidth\"", "SubObjectNameClosed",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageWidth\"", "MR"],
  " ",
  "is a global option",
  " that determines the width of a page."
}], "Usage",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["PageWidth\" \[Rule] WindowWidth",
    FontFamily->"Courier"],
  ", each line can extend up to the full width of the window, taking into \
account the settings for cell margins.\n\[FilledSmallSquare] Other possible \
settings for \"",
  StyleBox["PageWidth\"",
    FontFamily->"Courier"],
  " are as follows.\n    ",
  StyleBox["Infinity",
    FontFamily->"Courier"],
  "                     an infinite width (no ",
  "line breaks",
  ")\n     ",
  StyleBox["n",
    FontSlant->"Italic"],
  "                                     explicit width in characters\n     ",
  StyleBox["PaperWidth",
    FontFamily->"Courier"],
  "               the width of a printed page\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.12.3",
    ButtonData:>{"2.12.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TotalWidth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AutoIndent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->"1.1.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellLabels\"", "SubObjectNameClosed",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellLabels\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell labels, such as the In and Out prompts, should be included when a \
group of cells is exported. "
}], "Usage",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell labels are included when a group of cells is exported.\n\
\[FilledSmallSquare] To prevent cell labels from being exported, you can set \
\"",
  StyleBox["IncludeCellLabels\" \[Rule] False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellLabel",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->"1.1.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellTags\"", "SubObjectNameClosed",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellTags\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell tags should be included when a notebook is exported. "
}], "Usage",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellTags\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell tags are included when notebooks are exported. \n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellTags\" \[Rule] False",
    FontFamily->"Courier"],
  ", information about cell tags is lost when notebooks are exported.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellTags",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->"1.1.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellBreaks\"", "SubObjectNameClosed",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellBreaks\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the string inserted between successive cells when they \
are exported. "
}], "Usage",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["CellBreaks\" \[Rule] \"\\n\\n\"",
    FontFamily->"Courier"],
  ", a single blank line is inserted between any two cells."
}], "Notes",
  CellTags->"1.1.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CMYKColorGeneration\"", "SubObjectNameClosed",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CMYKColorGeneration\"",
    FontFamily->"Courier"],
  " is a global option that determines how the CMYK scheme, used to describe \
colors in a printout, is implemented. "
}], "Usage",
  CellTags->"1.1.2.3"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"CMYKColorGeneration\" \[Rule] \"DirectComplement\"",
    FontFamily->"Courier"],
  ", the CMYK representation of colors is calculated as the direct complement \
of the RGB representation. \n\[FilledSmallSquare] With the setting \"",
  StyleBox["CMYKColorGeneration\" \[Rule] \"StandardBlackGeneration\"",
    FontFamily->"Courier"],
  ", the largest common value of cyan, magenta, and yellow in the CMYK \
representation is replaced by an equivalent amount of black."
}], "Notes",
  CellTags->"1.1.2.3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ExportPostScriptOptions\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.2.4.1", "1.1.2.4"}],

Cell[TextData[{
  StyleBox["ExportPostScriptOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that specify the settings used in exporting \
files in PostScript format. It consists of the following ",
  "suboptions",
  "."
}], "Text",
  CellTags->{"1.1.2.4.2", "1.1.2.4"}],

Cell[CellGroupData[{

Cell["\"FormatType\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.4.1.1", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FormatType\"", "MR"],
  " ",
  "is a global option",
  " that determines the format in which a group of cells is saved when it is \
exported. "
}], "Usage",
  CellTags->{"1.1.2.4.1.2", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows. \n  ",
  StyleBox["\"Text\"                    \"PostScript\" \n \"InputText\"       \
        \"Bitmap\"\n \"Package\"                 \"PICT\"             ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CellExpression\"          \"PICTBitmap\"       ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"NotebookExpression\"      \"PICTEmbeddedPS\"   ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CompleteNotebook\"        \"QuickTime\"        ",
    FontFamily->"Courier"],
  "(Macintosh only)"
}], "Notes",
  CellTags->{"1.1.2.4.1.3", "1.1.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageWidth\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.4.2.1", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageWidth\"", "MR"],
  " ",
  "is a global option",
  " that determines the width of a page."
}], "Usage",
  CellTags->{"1.1.2.4.2.2", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["PageWidth\" \[Rule] WindowWidth",
    FontFamily->"Courier"],
  ", each line can extend up to the full width of the window, taking into \
account the settings for cell margins.\n\[FilledSmallSquare] Other possible \
settings for \"",
  StyleBox["PageWidth\"",
    FontFamily->"Courier"],
  " are as follows.\n    ",
  StyleBox["Infinity",
    FontFamily->"Courier"],
  "                     an infinite width (no ",
  "line breaks",
  ")\n     ",
  StyleBox["n",
    FontSlant->"Italic"],
  "                                     explicit width given in characters\n  \
   ",
  StyleBox["PaperWidth",
    FontFamily->"Courier"],
  "               the width of a printed page\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.12.3",
    ButtonData:>{"2.12.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TotalWidth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AutoIndent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.1.2.4.2.3", "1.1.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellLabels\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.4.3.1", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellLabels\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell labels, such as the In and Out prompts, should be included when a \
group of cells is exported. "
}], "Usage",
  CellTags->{"1.1.2.4.3.2", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell labels are included when a group of cells is exported.\n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] False",
    FontFamily->"Courier"],
  ", cell labels are not included.\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellLabel",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.4.3.3", "1.1.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellTags\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.4.4.1", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellTags\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell tags should be included when a notebook is exported. "
}], "Usage",
  CellTags->{"1.1.2.4.4.2", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellTags\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell tags are included when notebooks are exported. \n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellTags\" \[Rule] False",
    FontFamily->"Courier"],
  ", information about cell tags is lost when notebooks are exported.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellTags",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.4.4.3", "1.1.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellBreaks\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.4.5.1", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellBreaks\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the string inserted between successive cells when they \
are exported. "
}], "Usage",
  CellTags->{"1.1.2.4.5.2", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["CellBreaks\" \[Rule] \"\\n\\n\"",
    FontFamily->"Courier"],
  ", a single blank line is inserted between any two cells."
}], "Notes",
  CellTags->{"1.1.2.4.5.3", "1.1.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CMYKColorGeneration\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.4.6.1", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CMYKColorGeneration\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines how the CMYK scheme used to describe colors in a printout \
is implemented. "
}], "Usage",
  CellTags->{"1.1.2.4.6.2", "1.1.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"CMYKColorGeneration\" \[Rule] \"DirectComplement\"",
    FontFamily->"Courier"],
  ", the CMYK representation of colors is calculated as the direct complement \
of the RGB representation. \n\[FilledSmallSquare] With the setting \"",
  StyleBox["CMYKColorGeneration\" \[Rule] \"StandardBlackGeneration\"",
    FontFamily->"Courier"],
  ", the largest common value of cyan, magenta, and yellow in the CMYK \
representation is replaced by an equivalent amount of black."
}], "Notes",
  CellTags->{"1.1.2.4.6.3", "1.1.2.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
ExportNativeGraphicsOptions\[LongRightArrow]{\[Ellipsis]}\
\>", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.2.5.1", "1.1.2.5"}],

Cell[TextData[{
  StyleBox["ExportNativeGraphicsOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that specify the settings used in exporting \
",
  StyleBox["Mathematica-",
    FontSlant->"Italic"],
  "generated graphics. It consists of the following suboptions."
}], "Text",
  CellTags->{"1.1.2.5.2", "1.1.2.5"}],

Cell[CellGroupData[{

Cell["\"FormatType\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.5.1.1", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FormatType\"", "MR"],
  " ",
  "is a global option",
  " that determines the format in which a group of cells is saved when it is \
exported. "
}], "Usage",
  CellTags->{"1.1.2.5.1.2", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows. \n  ",
  StyleBox["\"Text\"                    \"PostScript\" \n \"InputText\"       \
        \"Bitmap\"\n \"Package\"                 \"PICT\"             ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CellExpression\"          \"PICTBitmap\"       ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"NotebookExpression\"      \"PICTEmbeddedPS\"   ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CompleteNotebook\"        \"QuickTime\"        ",
    FontFamily->"Courier"],
  "(Macintosh only)"
}], "Notes",
  CellTags->{"1.1.2.5.1.3", "1.1.2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageWidth\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.5.2.1", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageWidth\"", "MR"],
  " ",
  "is a global option",
  " that determines the width of a page."
}], "Usage",
  CellTags->{"1.1.2.5.2.2", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["PageWidth\" \[Rule] WindowWidth",
    FontFamily->"Courier"],
  ", each line can extend up to the full width of the window, taking into \
account the settings for cell margins.\n\[FilledSmallSquare] Other possible \
settings for \"",
  StyleBox["PageWidth\"",
    FontFamily->"Courier"],
  " are as follows.\n    ",
  StyleBox["Infinity",
    FontFamily->"Courier"],
  "                     an infinite width (no ",
  "line breaks",
  ")\n     ",
  StyleBox["n",
    FontSlant->"Italic"],
  "                                     explicit width given in characters\n  \
   ",
  StyleBox["PaperWidth",
    FontFamily->"Courier"],
  "               the width of a printed page\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.12.3",
    ButtonData:>{"2.12.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TotalWidth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AutoIndent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.1.2.5.2.3", "1.1.2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellLabels\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.5.3.1", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellLabels\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell labels, such as the In and Out prompts, should be included when a \
group of cells is exported. "
}], "Usage",
  CellTags->{"1.1.2.5.3.2", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell labels are included when a group of cells is exported.\n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] False",
    FontFamily->"Courier"],
  ", cell labels are not included.\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellLabel",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.5.3.3", "1.1.2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellTags\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.5.4.1", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellTags\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell tags should be included when a notebook is exported. "
}], "Usage",
  CellTags->{"1.1.2.5.4.2", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellTags\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell tags are included when notebooks are exported. \n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellTags\" \[Rule] False",
    FontFamily->"Courier"],
  ", information about cell tags is lost when notebooks are exported.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellTags",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.5.4.3", "1.1.2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellBreaks\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.5.5.1", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellBreaks\"",
    FontFamily->"Courier"],
  " is a global option that determines which string is inserted between \
successive cells when they are exported. "
}], "Usage",
  CellTags->{"1.1.2.5.5.2", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["CellBreaks\" \[Rule] \"\\n\\n\"",
    FontFamily->"Courier"],
  ", a single blank line is inserted between any two cells."
}], "Notes",
  CellTags->{"1.1.2.5.5.3", "1.1.2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CMYKColorGeneration\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.5.6.1", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CMYKColorGeneration\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines how the CMYK scheme, used to describe colors in a \
printout, is implemented. "
}], "Usage",
  CellTags->{"1.1.2.5.6.2", "1.1.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"CMYKColorGeneration\" \[Rule] \"DirectComplement\"",
    FontFamily->"Courier"],
  ", the CMYK representation of colors is calculated as the direct complement \
of the RGB representation. \n\[FilledSmallSquare] With the setting \"",
  StyleBox["CMYKColorGeneration\" \[Rule] \"StandardBlackGeneration\"",
    FontFamily->"Courier"],
  ", the largest common value of cyan, magenta, and yellow in the CMYK \
representation is replaced by an equivalent amount of black."
}], "Notes",
  CellTags->{"1.1.2.5.6.3", "1.1.2.5"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ExportTypesetOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.2.6.1", "1.1.2.6"}],

Cell[TextData[{
  StyleBox["ExportTypesetOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that specify the settings used in exporting \
typeset expressions created in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". It consists of the following ",
  "suboptions",
  "."
}], "Text",
  CellTags->{"1.1.2.6.2", "1.1.2.6"}],

Cell[CellGroupData[{

Cell["\"FormatType\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.6.1.1", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FormatType\"", "MR"],
  " ",
  "is a global option",
  " that determines the format in which a group of cells is saved when it is \
exported. "
}], "Usage",
  CellTags->{"1.1.2.6.1.2", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows. \n  ",
  StyleBox["\"Text\"                    \"PostScript\" \n \"InputText\"       \
        \"Bitmap\"\n \"Package\"                 \"PICT\"             ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CellExpression\"          \"PICTBitmap\"       ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"NotebookExpression\"      \"PICTEmbeddedPS\"   ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CompleteNotebook\"        \"QuickTime\"        ",
    FontFamily->"Courier"],
  "(Macintosh only)"
}], "Notes",
  CellTags->{"1.1.2.6.1.3", "1.1.2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageWidth\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.6.2.1", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageWidth\"", "MR"],
  " ",
  "is a global option",
  " that determines the width of a page."
}], "Usage",
  CellTags->{"1.1.2.6.2.2", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["PageWidth\" \[Rule] WindowWidth",
    FontFamily->"Courier"],
  ", each line can extend up to the full width of the window, taking into \
account the settings for cell margins.\n\[FilledSmallSquare] Other possible \
settings for \"",
  StyleBox["PageWidth\"",
    FontFamily->"Courier"],
  " are as follows.\n    ",
  StyleBox["Infinity",
    FontFamily->"Courier"],
  "                     an infinite width (no ",
  "line breaks",
  ")\n     ",
  StyleBox["n",
    FontSlant->"Italic"],
  "                                     explicit width given in characters\n  \
   ",
  StyleBox["PaperWidth",
    FontFamily->"Courier"],
  "               the width of a printed page\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.12.3",
    ButtonData:>{"2.12.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TotalWidth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AutoIndent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.1.2.6.2.3", "1.1.2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellLabels\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.6.3.1", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellLabels\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell labels, such as the In and Out prompts, should be included when a \
group of cells is exported. "
}], "Usage",
  CellTags->{"1.1.2.6.3.2", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell labels are included when a group of cells is exported.\n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] False",
    FontFamily->"Courier"],
  ", cell labels are not included.\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellLabel",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.6.3.3", "1.1.2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellTags\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.6.4.1", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellTags\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell tags should be included when a notebook is exported. "
}], "Usage",
  CellTags->{"1.1.2.6.4.2", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellTags\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell tags are included when notebooks are exported. \n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellTags\" \[Rule] False",
    FontFamily->"Courier"],
  ", information about cell tags is lost when notebooks are exported.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellTags",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.6.4.3", "1.1.2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellBreaks\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.6.5.1", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellBreaks\"",
    FontFamily->"Courier"],
  " is a global option that determines which string is inserted between \
successive cells when they are exported. "
}], "Usage",
  CellTags->{"1.1.2.6.5.2", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["CellBreaks\" \[Rule] \"\\n\\n\"",
    FontFamily->"Courier"],
  ", a single blank line is inserted between any two cells."
}], "Notes",
  CellTags->{"1.1.2.6.5.3", "1.1.2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CMYKColorGeneration\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.6.6.1", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CMYKColorGeneration\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines how the CMYK scheme, used to describe colors in a \
printout, is implemented. "
}], "Usage",
  CellTags->{"1.1.2.6.6.2", "1.1.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["CMYKColorGeneration\" \[Rule] \"DirectComplement\"",
    FontFamily->"Courier"],
  ", the CMYK representation of colors is calculated as the direct complement \
of the RGB representation. \n\[FilledSmallSquare] With the setting \"",
  StyleBox["CMYKColorGeneration\" \[Rule] \"StandardBlackGeneration\"",
    FontFamily->"Courier"],
  ", the largest common value of cyan, magenta, and yellow in the CMYK \
representation is replaced by an equivalent amount of black."
}], "Notes",
  CellTags->{"1.1.2.6.6.3", "1.1.2.6"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ExportQuickTimeOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.2.7.1", "1.1.2.7"}],

Cell[TextData[{
  StyleBox["ExportQuickTimeOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that specify the settings used in exporting \
files in QuickTime format (Macintosh only). It consists of the following ",
  "suboptions",
  "."
}], "Text",
  CellTags->{"1.1.2.7.2", "1.1.2.7"}],

Cell[CellGroupData[{

Cell["\"FormatType\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.7.1.1", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FormatType\"", "MR"],
  " ",
  "is a global option",
  " that determines the format in which a group of cells is saved when it is \
exported. "
}], "Usage",
  CellTags->{"1.1.2.7.1.2", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows. \n  ",
  StyleBox["\"Text\"                    \"PostScript\" \n \"InputText\"       \
        \"Bitmap\"\n \"Package\"                 \"PICT\"             ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CellExpression\"          \"PICTBitmap\"       ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"NotebookExpression\"      \"PICTEmbeddedPS\"   ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CompleteNotebook\"        \"QuickTime\"        ",
    FontFamily->"Courier"],
  "(Macintosh only)"
}], "Notes",
  CellTags->{"1.1.2.7.1.3", "1.1.2.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageWidth\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.7.2.1", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageWidth\"", "MR"],
  " ",
  "is a global option",
  " that determines the width of a page."
}], "Usage",
  CellTags->{"1.1.2.7.2.2", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["PageWidth\" \[Rule] WindowWidth",
    FontFamily->"Courier"],
  ", each line can extend up to the full width of the window, taking into \
account the settings for cell margins.\n\[FilledSmallSquare] Other possible \
settings for \"",
  StyleBox["PageWidth\"",
    FontFamily->"Courier"],
  " are as follows.\n    ",
  StyleBox["Infinity",
    FontFamily->"Courier"],
  "                     an infinite width (no ",
  "line breaks",
  ")\n     ",
  StyleBox["n",
    FontSlant->"Italic"],
  "                                     explicit width given in characters\n  \
   ",
  StyleBox["PaperWidth",
    FontFamily->"Courier"],
  "               the width of a printed page\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.12.3",
    ButtonData:>{"2.12.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TotalWidth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AutoIndent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.1.2.7.2.3", "1.1.2.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellLabels\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.7.3.1", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellLabels\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell labels, such as the In and Out prompts, should be included when a \
group of cells is exported. "
}], "Usage",
  CellTags->{"1.1.2.7.3.2", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell labels are included when a group of cells is exported.\n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] False",
    FontFamily->"Courier"],
  ", cell labels are not included.\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellLabel",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.7.3.3", "1.1.2.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellTags\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.7.4.1", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellTags\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell tags should be included when a notebook is exported. "
}], "Usage",
  CellTags->{"1.1.2.7.4.2", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellTags\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell tags are included when notebooks are exported. \n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellTags\" \[Rule] False",
    FontFamily->"Courier"],
  ", information about cell tags is lost when notebooks are exported.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellTags",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.7.4.3", "1.1.2.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellBreaks\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.7.5.1", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellBreaks\"",
    FontFamily->"Courier"],
  " is a global option that determines which string is inserted between \
successive cells when they are exported. "
}], "Usage",
  CellTags->{"1.1.2.7.5.2", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["CellBreaks\" \[Rule] \"\\n\\n\"",
    FontFamily->"Courier"],
  ", a single blank line is inserted between any two cells."
}], "Notes",
  CellTags->{"1.1.2.7.5.3", "1.1.2.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CMYKColorGeneration\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.7.6.1", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CMYKColorGeneration\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines how the CMYK scheme, used to describe colors in a \
printout, is implemented. "
}], "Usage",
  CellTags->{"1.1.2.7.6.2", "1.1.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"CMYKColorGeneration\" \[Rule] \"DirectComplement\"",
    FontFamily->"Courier"],
  ", the CMYK representation of colors is calculated as the direct complement \
of the RGB representation. \n\[FilledSmallSquare] With the setting ",
  StyleBox["\"CMYKColorGeneration\" \[Rule] \"StandardBlackGeneration\"",
    FontFamily->"Courier"],
  ", the largest common value of cyan, magenta, and yellow in the CMYK \
representation is replaced by an equivalent amount of black."
}], "Notes",
  CellTags->{"1.1.2.7.6.3", "1.1.2.7"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SaveAsSpecialOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.2.8.1", "1.1.2.8"}],

Cell[TextData[{
  StyleBox["SaveAsSpecialOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that specify the settings used in exporting \
files using the ",
  StyleBox["Edit \[RightTriangle] Save As Special\[Ellipsis]",
    FontFamily->"Helvetica"],
  " menu command. It consists of the following ",
  "suboptions",
  "."
}], "Text",
  CellTags->{"1.1.2.8.2", "1.1.2.8"}],

Cell[CellGroupData[{

Cell["\"FormatType\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.8.1.1", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FormatType\"", "MR"],
  " ",
  "is a global option",
  " that determines the format in which a group of cells is saved when it is \
exported. "
}], "Usage",
  CellTags->{"1.1.2.8.1.2", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows. \n  ",
  StyleBox["\"Text\"                    \"PostScript\" \n \"InputText\"       \
        \"Bitmap\"\n \"Package\"                 \"PICT\"             ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CellExpression\"          \"PICTBitmap\"       ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"NotebookExpression\"      \"PICTEmbeddedPS\"   ",
    FontFamily->"Courier"],
  "(Macintosh only)",
  StyleBox["\n \"CompleteNotebook\"        \"QuickTime\"        ",
    FontFamily->"Courier"],
  "(Macintosh only)"
}], "Notes",
  CellTags->{"1.1.2.8.1.3", "1.1.2.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageWidth\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.8.2.1", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageWidth\"", "MR"],
  " ",
  "is a global option",
  " that determines the width of a page."
}], "Usage",
  CellTags->{"1.1.2.8.2.2", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["PageWidth\" \[Rule] WindowWidth",
    FontFamily->"Courier"],
  ", each line can extend up to the full width of the window, taking into \
account the settings for cell margins.\n\[FilledSmallSquare] Other possible \
settings for \"",
  StyleBox["PageWidth\"",
    FontFamily->"Courier"],
  " are as follows.\n    ",
  StyleBox["Infinity",
    FontFamily->"Courier"],
  "                     an infinite width (no ",
  "line breaks",
  ")\n     ",
  StyleBox["n",
    FontSlant->"Italic"],
  "                                     explicit width given in characters\n  \
   ",
  StyleBox["PaperWidth",
    FontFamily->"Courier"],
  "               the width of a printed page\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.12.3",
    ButtonData:>{"2.12.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TotalWidth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AutoIndent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.1.2.8.2.3", "1.1.2.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellLabels\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.8.3.1", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellLabels\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell labels, such as the In and Out prompts, should be included when a \
group of cells is exported. "
}], "Usage",
  CellTags->{"1.1.2.8.3.2", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell labels are included when a group of cells is exported.\n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellLabels\" \[Rule] False",
    FontFamily->"Courier"],
  ", cell labels are not included.\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellLabel",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.8.3.3", "1.1.2.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeCellTags\" ", "SubObjectNameClosed",
  CellTags->{"1.1.2.8.4.1", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["IncludeCellTags\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " cell tags should be included when a notebook is exported. "
}], "Usage",
  CellTags->{"1.1.2.8.4.2", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting \"",
  StyleBox["IncludeCellTags\" \[Rule] True",
    FontFamily->"Courier"],
  ", cell tags are included when notebooks are exported. \n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["IncludeCellTags\" \[Rule] False",
    FontFamily->"Courier"],
  ", information about cell tags is lost when notebooks are exported.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellTags",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.2.8.4.3", "1.1.2.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CellBreaks\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.8.5.1", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CellBreaks\"",
    FontFamily->"Courier"],
  " is a global option that determines which string is inserted between \
successive cells when they are exported. "
}], "Usage",
  CellTags->{"1.1.2.8.5.2", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting \"",
  StyleBox["CellBreaks\" \[Rule] \"\\n\\n\"",
    FontFamily->"Courier"],
  ", a single blank line is inserted between any two cells."
}], "Notes",
  CellTags->{"1.1.2.8.5.3", "1.1.2.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CMYKColorGeneration\"", "SubObjectNameClosed",
  CellTags->{"1.1.2.8.6.1", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CMYKColorGeneration\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines how the CMYK scheme, used to describe colors in a \
printout, is implemented. "
}], "Usage",
  CellTags->{"1.1.2.8.6.2", "1.1.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"CMYKColorGeneration\" \[Rule] \"DirectComplement\"",
    FontFamily->"Courier"],
  ", the CMYK representation of colors is calculated as the direct complement \
of the RGB representation. \n\[FilledSmallSquare] With the setting ",
  StyleBox["\"CMYKColorGeneration\" \[Rule] \"StandardBlackGeneration\"",
    FontFamily->"Courier"],
  ", the largest common value of cyan, magenta, and yellow in the CMYK \
representation is replaced by an equivalent amount of black."
}], "Notes",
  CellTags->{"1.1.2.8.6.3", "1.1.2.8"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["International Options", "InspectorLevel1"],

Cell[CellGroupData[{

Cell[" Language ", "ObjectName",
  CellTags->{"1.1.3.1.1", "1.1.3.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Language",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the language in which menus, dialog boxes, error \
messages, and help files are displayed.   "
}], "Usage",
  CellTags->{"1.1.3.1.2", "1.1.3.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Language \[Rule]",
    FontFamily->"Courier"],
  "  ",
  StyleBox["\"English\"",
    FontFamily->"Courier"],
  ", unless a language kit is installed, in which case the default will be \
the appropriate language (e.g. ",
  StyleBox["\"Japanese\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"German\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"French\"",
    FontFamily->"Courier"],
  ").\n\[FilledSmallSquare] The setting affects many aspects of the system, \
including where configuration, text and system resource files, and \
documentation files are located.  Each location containing language-specific \
files will contain subdirectories named after the language they contain (e.g. \
a directory called \"Japanese\" will contain Japanese text resources and \
documentation).  It is possible to have files for several different languages \
installed at the same time, with the ",
  StyleBox["Language",
    FontFamily->"Courier"],
  " option selecting which language is active.\n\[FilledSmallSquare] When the \
value of this option is changed, the new setting does not take effect until \
the front end is restarted. It is not possible to switch languages during a \
session."
}], "Notes",
  CellTags->{"1.1.3.1.3", "1.1.3.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" ExternalDataCharacterEncoding ", "ObjectName",
  CellTags->{"1.1.3.2.1", "1.1.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ExternalDataCharacterEncoding",
    FontFamily->"Courier"],
  " is a global option that determines the character encoding used in reading \
and writing plain text data outside of ",
  StyleBox["Mathematica", "IT"],
  ". "
}], "Usage",
  CellTags->{"1.1.3.2.2", "1.1.3.2"}],

Cell[TextData[{
  StyleBox[" ", "IT"],
  "\[FilledSmallSquare] The setting for ",
  StyleBox["ExternalDataCharacterEncoding",
    FontFamily->"Courier"],
  StyleBox[" is not used when writing files that contain font specification \
(e.g. styled text clipboards, RTF files).  In such situations, the character \
encodings appropriate to the fonts are used.", "IT",
    FontSlant->"Plain"],
  StyleBox["\n", "IT"],
  "\[FilledSmallSquare] The default setting for this option is the global \
variable ",
  StyleBox["$SystemCharacterEncoding",
    FontFamily->"Courier"],
  StyleBox[", which specifies the ", "Program",
    FontFamily->"Times"],
  "character encoding used by the operating system.  "
}], "Notes",
  CellTags->{"1.1.3.2.3", "1.1.3.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["System Configuration", "InspectorLevel1"],

Cell[CellGroupData[{

Cell[" StartupSound ", "ObjectName",
  CellTags->{"1.1.4.1.1", "1.1.4.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["StartupSound",
    FontFamily->"Courier"],
  " is a global option that determines whether or not ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " plays a sound when it is launched."
}], "Usage",
  CellTags->{"1.1.4.1.2", "1.1.4.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["StartupSound \[Rule] True",
    FontFamily->"Courier"],
  ", a sound is played when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is launched.\n\[FilledSmallSquare] With the default setting ",
  StyleBox["StartupSound \[Rule] False",
    FontFamily->"Courier"],
  ", no sound is played."
}], "Notes",
  CellTags->{"1.1.4.1.3", "1.1.4.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" MultilaunchWarning ", "ObjectName",
  CellTags->{"1.1.4.4.1", "1.1.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilaunchWarning",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a warning is given when you try to modify user preferences while running \
two copies of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simultaneously. "
}], "Usage",
  CellTags->{"1.1.4.4.2", "1.1.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The purpose of this warning is to make the user aware \
that there is only one user preferences file per user. If more than one copy \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is running, changes made to this file may be overwritten by the different \
copies alternately, resulting in lost user preferences. The warning is given \
only when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tries to write to the preferences file, for example, when you change the \
setting for a global option in the Option Inspector. \n\[FilledSmallSquare] \
With the setting ",
  StyleBox["MultilaunchWarning \[Rule] True",
    FontFamily->"Courier"],
  ", a warning is given when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tries to write to the preferences file, if the same file is in use by \
another copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". "
}], "Notes",
  CellTags->{"1.1.4.4.3", "1.1.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilaunchWarning \[Rule] False",
    FontFamily->"Courier"],
  ", no warning is given when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tries to write to the preferences file, even if the file is being used by \
another copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". "
}], "Notes",
  CellTags->{"1.1.4.4.4", "1.1.4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" ScreenRectangle ", "ObjectName",
  CellTags->{"1.1.4.2.1", "1.1.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ScreenRectangle",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the position of the screen by giving the coordinates of \
two diagonally opposite corners."
}], "Usage",
  CellTags->{"1.1.4.2.2", "1.1.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The position is given by two pairs of numbers that \
specify the horizontal and vertical dimensions of the screen in pixels. It is \
specified as ",
  StyleBox["ScreenRectangle \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["number",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["number",
    FontSlant->"Italic"],
  "}",
  StyleBox[",",
    FontSlant->"Italic"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["number",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["number",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  ", where each range is expressed as a ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["min",
    FontSlant->"Italic"],
  ", ",
  StyleBox["max",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " pair; thus ",
  StyleBox["{{0,1024},{0,768}}",
    FontFamily->"Courier"],
  " is a 1024 \[Times] 768 display.\n\[FilledSmallSquare] The value of this \
option cannot be changed: it exists as a way to make this information \
available to programs, not as a way to reset your screen size."
}], "Notes",
  CellTags->{"1.1.4.2.3", "1.1.4.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" FrontEndStackSize ", "ObjectName",
  CellTags->{"1.1.4.3.1", "1.1.4.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FrontEndStackSize",
    FontFamily->"Courier"],
  " is a global option that determines the size of the stack used to store \
data in the front end (Macintosh only). "
}], "Usage",
  CellTags->{"1.1.4.3.2", "1.1.4.3"}],

Cell["\<\
\[FilledSmallSquare] It is specified as the number of bytes of \
memory reserved for the front end stack.\
\>", "Notes",
  CellTags->{"1.1.4.3.3", "1.1.4.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"XPasteFrom\" ", "ObjectName",
  CellTags->{"1.1.4.4.1", "1.1.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"XPasteFrom\"",
    FontFamily->"Courier"],
  " is a global option that determines what is pasted when using the ",
  StyleBox["Edit \[RightTriangle] Paste",
    FontFamily->"Helvetica"],
  " menu command in an X front end. "
}], "Usage",
  CellTags->{"1.1.4.4.2", "1.1.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option provides a way to customize how the paste \
command works, since pasting is implemented differently in different X \
applications. With the default setting ",
  StyleBox["\"XPasteFrom\" \[Rule] \"Clipboard\"",
    FontFamily->"Courier"],
  ", whatever was copied to the clipboard last (i.e. cut or copied from \
another application) will be pasted."
}], "Notes",
  CellTags->{"1.1.4.4.3", "1.1.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"XPasteFrom\" \[Rule] \"Selection\"",
    FontFamily->"Courier"],
  ", the current selection is pasted. If you have trouble pasting from your \
favorite application, you might want to try setting ",
  StyleBox["\"XPasteFrom\"",
    FontFamily->"Courier"],
  " to ",
  StyleBox["\"Selection\"",
    FontFamily->"Courier"],
  " instead of ",
  StyleBox["\"Clipboard\"",
    FontFamily->"Courier"],
  ", or vice-versa.\n\[FilledSmallSquare] The setting ",
  StyleBox["\"XPasteFrom\" \[Rule] \"SecondarySelection\"",
    FontFamily->"Courier"],
  ", enables you to paste items other than the current selection. For \
example, if you have something selected and then a dialog pops up and you \
select something in it, the selection in the main window can be a secondary \
selection so it is not lost."
}], "Notes",
  CellTags->"1.1.4.5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Menu Settings", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["EvaluatorNames ", "ObjectName",
  CellTags->{"1.1.5.1.1", "1.1.5.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["EvaluatorNames",
    FontFamily->"Courier"],
  " is a global option that specifies which kernels are currently configured \
to perform evaluations. "
}], "Usage",
  CellTags->{"1.1.5.1.2", "1.1.5.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Click the square symbol at the right of the option to \
bring up a dialog box containing a list of currently defined kernels. The \
same dialog box appears when you click ",
  StyleBox["Kernel \[RightTriangle] Kernel Configuration Options\[Ellipsis]",
    FontFamily->"Helvetica"],
  ". \n\[FilledSmallSquare] Click the appropriate button to add, edit, or \
remove a kernel from the list. In the first two cases, you will need to \
specify the configuration information for the kernel in a new dialog box. "
}], "Notes",
  CellTags->{"1.1.5.1.3", "1.1.5.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["NotebooksMenu ", "ObjectName",
  CellTags->{"1.1.5.2.1", "1.1.5.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebooksMenu",
    FontFamily->"Courier"],
  " is a global option that determines which notebooks are displayed under \
the ",
  StyleBox["File \[RightTriangle] Notebooks", "SRst",
    FontFamily->"Helvetica"],
  " ",
  StyleBox["submenu.", "SRst"]
}], "Usage",
  CellTags->{"1.1.5.2.2", "1.1.5.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["File \[RightTriangle] Notebooks", "SRst",
    FontFamily->"Helvetica"],
  " ",
  StyleBox["submenu enables quick access to recently opened notebooks", 
    "SRst"],
  ". Click the square symbol at the right of the option to bring up a dialog \
box containing a list of currently available notebooks. \n\
\[FilledSmallSquare] Click the appropriate button to add or remove a notebook \
from the list or to edit the information corresponding to a notebook. \n\
\[FilledSmallSquare] The name of each notebook is stored as a ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " object. In addition, several other options can be specified, such as \
opening the notebook automatically on startup or reusing the menu slot when \
other notebooks are opened more recently. These options are stored as ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["notebook name", "ITog",
    FontSlant->"Italic"],
  StyleBox["\" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["settings", "ITog",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.1.5.2.3", "1.1.5.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["FontSubstitutions", "ObjectName",
  CellTags->{"1.1.5.3.1", "1.1.5.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FontSubstitutions", "MR"],
  " is a global option that determines which font replacement rules are \
applied to any document containing fonts that are unavailable on the current \
machine."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.5.3.2", "1.1.5.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] A typical setting is ",
  StyleBox["FontSubstitutions \[Rule] {\"Arial\" \[Rule] \"Helvetica\"}",
    FontFamily->"Courier"],
  ".  \n\[FilledSmallSquare] ",
  StyleBox["FontSubstitutions",
    FontFamily->"Courier"],
  " is used only for ",
  StyleBox["FontFamily",
    FontFamily->"Courier"],
  " settings; not for ",
  StyleBox["FontWeight",
    FontFamily->"Courier"],
  ", ",
  StyleBox["FontSlant",
    FontFamily->"Courier"],
  ", and so on. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["FontFamily",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.1.5.3.3", "1.1.5.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DefaultFontProperties ", "ObjectName",
  CellTags->{"1.1.5.4.1", "1.1.5.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DefaultFontProperties",
    FontFamily->"Courier"],
  " is a global option that determines various properties of a font family, \
such as its character encoding and ",
  "if",
  " it is monospaced. "
}], "Usage",
  CellTags->{"1.1.5.4.2", "1.1.5.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] For each font in the list, a few characteristics are \
specified in the form of a list of rules, for example",
  StyleBox[",",
    FontSlant->"Italic"],
  " ",
  StyleBox["\"Times\" \[Rule] {\"FontEncoding\" \[Rule] Automatic, \
\"FontSerifed\" \[Rule] True, \"FontMonospaced\" \[Rule] False}",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] For any font not listed in this option, the \
properties are deduced from information provided by the system, but this \
information is not always reliable. ",
  StyleBox["DefaultFontProperties",
    FontFamily->"Courier"],
  " can be used to override the system information, if it is inaccurate."
}], "Notes",
  CellTags->{"1.1.5.4.3", "1.1.5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["BoxFormFormatTypes ", "ObjectName",
  CellTags->{"1.1.5.5.1", "1.1.5.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxFormFormatTypes",
    FontFamily->"Courier"],
  " is a global option that determines the list of typeset format types that \
are currently defined. "
}], "Usage",
  CellTags->{"1.1.5.5.2", "1.1.5.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] The setting for ",
  StyleBox["BoxFormFormatTypes",
    FontFamily->"Courier"],
  " determines what is listed under the Convert To and Display As submenus of \
the Cell menu.\n\[FilledSmallSquare] The default setting is ",
  StyleBox["BoxFormFormatTypes \[Rule] {StandardForm, TraditionalForm}",
    FontFamily->"Courier"],
  ". If the front end is connected to a kernel that supports additional \
typeset format types, the value of this option will automatically be reset to \
reflect the set available in the kernel."
}], "Notes",
  CellTags->{"1.1.5.5.3", "1.1.5.5"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Dialog Settings", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["FindSettings\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.1.1", "1.1.6.1"}],

Cell[TextData[{
  StyleBox["FindSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the Find dialog \
box. This dialog box is accessed by clicking the ",
  StyleBox["Find \[RightTriangle] Find...",
    FontFamily->"Helvetica"],
  " command. ",
  StyleBox["FindSettings",
    FontFamily->"Courier"],
  " consists of the following suboptions. "
}], "Text",
  CellTags->{"1.1.6.1.2", "1.1.6.1"}],

Cell[CellGroupData[{

Cell["\"FindString\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.1.1.1", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FindString\"",
    FontFamily->"Courier"],
  " is a global option that stores the value of the last string that was \
searched for using the Find dialog box."
}], "Usage",
  CellTags->{"1.1.6.1.1.2", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FindString\"",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is usually set by typing text into the \"Search for:\" field of the Find \
dialog box. Alternatively, you can click ",
  StyleBox["Find \[RightTriangle] Enter Selection",
    FontFamily->"Helvetica"],
  " to make selected text in the notebook the value of ",
  StyleBox["\"FindString\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] You can search for any occurrence of a special \
character by setting ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["FindString",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " to the full name of the character. For example, to search for the next \
occurrence of the Greek letter \[Alpha], you can set ",
  StyleBox["\"FindString\" \[Rule] \[Backslash][Alpha]",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] You can search for typeset expressions by \
specifying the box structure in linear syntax. For example, to search for the \
next occurrence of ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\  + \ y\^2\)],
    FormatType->StandardForm],
  ", you can set ",
  StyleBox["\"FindString\" \[Rule] \\!\\(x\\^2+y\\^2\\)",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] You must perform a search using one of the buttons \
in the Find dialog box for the value of ",
  StyleBox["\"FindString\"",
    FontFamily->"Courier"],
  " to be updated. "
}], "Notes",
  CellTags->{"1.1.6.1.1.3", "1.1.6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ReplaceString\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.1.2.1", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ReplaceString\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that stores the value of the string to be inserted in place of \
highlighted text in the current notebook. "
}], "Usage",
  CellTags->{"1.1.6.1.2.2", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ReplaceString\"",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is usually set by typing text into the \"Replace with:\" field of the Find \
dialog box.  \n\[FilledSmallSquare] You must perform a search using one of \
the buttons in the Find dialog box for the value of ",
  StyleBox["\"ReplaceString\"",
    FontFamily->"Courier"],
  " to be updated. \n\[FilledSmallSquare] You can also replace text with a \
special character by setting ",
  StyleBox["\"ReplaceString\"",
    FontFamily->"Courier"],
  " to the full name of the character. For example, to replace the selected \
text by the Greek letter \[Alpha], you can use the setting ",
  StyleBox["\"ReplaceString\" \[Rule] \[Backslash][Alpha]",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.1.2.3", "1.1.6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IgnoreCase\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.1.3.1", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["IgnoreCase", "MRs",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a search carried out using the Find command is case-sensitive. "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.1.3.2", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["IgnoreCase", "MRs",
    FontFamily->"Courier"],
  StyleBox["\" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MRs",
    FontFamily->"Courier"],
  ", searches are case-insensitive.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["IgnoreCase", "MRs",
    FontFamily->"Courier"],
  StyleBox["\" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MRs",
    FontFamily->"Courier"],
  ", searches are case-sensitive.  \n\[FilledSmallSquare] See also: ",
  ButtonBox["ToUpperCase",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ToLowerCase",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.1.3.3", "1.1.6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Wraparound\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.1.4.1", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Wraparound\"",
    FontFamily->"Courier"],
  " is a global option that determines if a search should be continued at the \
start of a notebook when the search reaches the end. "
}], "Usage",
  CellTags->{"1.1.6.1.4.2", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"Wraparound\" \[Rule] False",
    FontFamily->"Courier"],
  ",",
  StyleBox[" ",
    FontWeight->"Bold"],
  "a search terminates when it reaches the end of a notebook. \n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["\"Wraparound\" \[Rule] True",
    FontFamily->"Courier"],
  ", a search that reaches the end of a notebook is continued at the start of \
that notebook. "
}], "Notes",
  CellTags->{"1.1.6.1.4.3", "1.1.6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.1.5.1", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["WindowMargins", "MR"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the ",
  "Find",
  " dialog box."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.1.5.2", "1.1.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.1.5.3", "1.1.6.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["EditCellTagsSettings\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.2.1", "1.1.6.2"}],

Cell[TextData[{
  StyleBox["EditCellTagsSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the \"Edit Cell \
Tags\" dialog box. This dialog box appears when you click ",
  StyleBox["Find \[RightTriangle] Add/Remove Cell Tags...",
    FontFamily->"Helvetica"],
  ". ",
  StyleBox["EditCellTagsSettings",
    FontFamily->"Courier"],
  " consists of the following suboptions."
}], "Text",
  CellTags->{"1.1.6.2.2", "1.1.6.2"}],

Cell[CellGroupData[{

Cell["\"CellTags\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.2.1.1", "1.1.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["CellTags", "MR"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is a global option that determines which strings to place in the \"Cell \
tag:\" field of the \"Edit Cell Tags\" dialog box when it is opened. "
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.2.1.2", "1.1.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Cell tags identify specific cells for operations such \
as searching, indexing, or setting up hyperlinks. Each cell tag is a string.\n\
\[FilledSmallSquare] If you assign a string to this option, that string \
automatically appears in the \"Cell tag:\" field of the dialog box each time \
the box is opened. This saves you the labor of typing in the string \
repeatedly. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["\"CellTags\" \[Rule] {}",
    FontFamily->"Courier"],
  ", the \"Cell tag:\" field in the dialog box is empty when it is opened. "
}], "Notes",
  CellTags->{"1.1.6.2.1.3", "1.1.6.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.2.2.1", "1.1.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["WindowMargins", "MR"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the size of margins around the \"Edit Cell Tags\" dialog \
box."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.2.2.2", "1.1.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.2.2.3", "1.1.6.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ViewPointSelectorSettings\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.3.1", "1.1.6.3"}],

Cell[TextData[{
  StyleBox["ViewPointSelectorSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the \"3D \
Viewpoint Selector\" dialog box. This dialog box appears when you click ",
  StyleBox["Input \[RightTriangle] 3D ViewPoint Selector...",
    FontFamily->"Helvetica"],
  ". ",
  StyleBox["ViewPointSelectorSettings",
    FontFamily->"Courier"],
  " consists of the following suboptions."
}], "Text",
  CellTags->{"1.1.6.3.2", "1.1.6.3"}],

Cell[CellGroupData[{

Cell["\"CoordinateSystem\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.3.1.1", "1.1.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"CoordinateSystem\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " the viewpoint for a graphics object is specified in Cartesian or \
spherical coordinates in the \"3D ViewPoint Selector\" dialog box. "
}], "Usage",
  CellTags->{"1.1.6.3.1.2", "1.1.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"CoordinateSystem\" \[Rule] Cartesian",
    FontFamily->"Courier"],
  ", the three parameters that define the viewpoint are the Cartesian \
coordinates ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y,",
    FontSlant->"Italic"],
  " and ",
  StyleBox["z",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"CoordinateSystem\" \[Rule] Spherical",
    FontFamily->"Courier"],
  ", the three parameters that define the viewpoint are the spherical \
coordinates ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", \[Theta], and \[Phi]."
}], "Notes",
  CellTags->{"1.1.6.3.1.3", "1.1.6.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"TemplateText\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.3.2.1", "1.1.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"TemplateText\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the form for the coordinates of the viewpoint when it is \
pasted into a notebook using the \"3D ViewPoint Selector\" dialog box. "
}], "Usage",
  CellTags->{"1.1.6.3.2.2", "1.1.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"TemplateText\" \[Rule] \"ViewPoint \[Rule] {\\\\x, \\\\y, \
\\\\z}\"",
    FontFamily->"Courier"],
  ", the Cartesian coordinates of the viewpoint are pasted into the notebook. \
\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"TemplateText\" \[Rule] \"{\\\\r, \\\\t, \\\\p}\"",
    FontFamily->"Courier"],
  ", the spherical coordinates of the viewpoint are pasted into the \
notebook."
}], "Notes",
  CellTags->{"1.1.6.3.2.3", "1.1.6.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ViewPoint\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.3.3.1", "1.1.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["ViewPoint", "MR"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is a global option that determines the point in space from which the cube \
displayed in the \"3D ViewPoint Selector\" dialog box is viewed."
}], "Usage",
  CellTags->{"1.1.6.3.3.2", "1.1.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ViewPoint", "MRs",
    FontFamily->"Courier"],
  StyleBox[" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["x", "TI\.04",
    FontSlant->"Italic"],
  StyleBox[",", "MR\.04",
    FontFamily->"Courier"],
  " ",
  StyleBox["y", "TI\.04",
    FontSlant->"Italic"],
  StyleBox[",", "MR\.04",
    FontFamily->"Courier"],
  " ",
  StyleBox["z", "TI\.04",
    FontSlant->"Italic"],
  StyleBox["}", "TI\.04",
    FontFamily->"Courier"],
  " gives the position of the view point relative to the center of the three\
\[Hyphen]dimensional box. \n\[FilledSmallSquare] The view point is given in a \
special scaled coordinate system in which the longest side of the bounding \
box has length 1. In this coordinate system, the center of the bounding box \
is at ",
  StyleBox["{0,", "MR\.0c"],
  " ",
  StyleBox["0,", "MR\.0c"],
  " ",
  StyleBox["0}", "MR\.0c"],
  ". \n\[FilledSmallSquare] Common settings for ",
  StyleBox["ViewPoint", "MR\.0c",
    FontFamily->"Courier"],
  " are as follows. \n",
  Cell[BoxData[
      FormBox[GridBox[{
            {
              RowBox[{"{", 
                RowBox[{
                  StyleBox["1.3",
                    FontFamily->"Courier"], ",", " ", 
                  StyleBox[\(-2.4\),
                    FontFamily->"Courier"], ",", " ", 
                  StyleBox["2",
                    FontFamily->"Courier"]}], 
                "}"}], "\<\"default setting \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"{0,\\\\\\\"\\\", \
\\\"MR\\\"]\\) \\!\\(\\*StyleBox[\\\"\\\\\\\"-2,\\\\\\\"\\\", \\\"MR\\\"]\\) \
\\!\\(\\*StyleBox[\\\"\\\\\\\"0}\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", \
"\<\"directly in front \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"{0,\\\\\\\"\\\", \
\\\"MR\\\"]\\) \\!\\(\\*StyleBox[\\\"\\\\\\\"-2,\\\\\\\"\\\", \\\"MR\\\"]\\) \
\\!\\(\\*StyleBox[\\\"\\\\\\\"2}\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"in \
front and up \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"{0,\\\\\\\"\\\", \
\\\"MR\\\"]\\) \\!\\(\\*StyleBox[\\\"\\\\\\\"-2,\\\\\\\"\\\", \\\"MR\\\"]\\) \
\\!\\(\\*StyleBox[\\\"\\\\\\\"-2}\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"in \
front and down \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"{-2,\\\\\\\"\\\", \\\"MR\\\"]\
\\) \\!\\(\\*StyleBox[\\\"\\\\\\\"-2,\\\\\\\"\\\", \\\"MR\\\"]\\) \
\\!\\(\\*StyleBox[\\\"\\\\\\\"0}\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"left\
\[Hyphen]hand corner \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"{2,\\\\\\\"\\\", \
\\\"MR\\\"]\\) \\!\\(\\*StyleBox[\\\"\\\\\\\"-2,\\\\\\\"\\\", \\\"MR\\\"]\\) \
\\!\\(\\*StyleBox[\\\"\\\\\\\"0}\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", \
"\<\"right\[Hyphen]hand corner \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"{0,\\\\\\\"\\\", \
\\\"MR\\\"]\\) \\!\\(\\*StyleBox[\\\"\\\\\\\"0,\\\\\\\"\\\", \\\"MR\\\"]\\) \
\\!\\(\\*StyleBox[\\\"\\\\\\\"2}\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", \
"\<\"directly above \"\>"}
            },
          ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
    FormatType->StandardForm,
    CellTags->"ViewPoint"],
  "\n\[FilledSmallSquare] Setting ",
  StyleBox["ViewPoint", "MR"],
  " further away from the object reduces the distortion associated with \
perspective. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.10.10",
    ButtonData:>{"2.10.10", "10.13"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"1.1.6.3.3.3", "1.1.6.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.3.4.1", "1.1.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the \
\"3DViewpointSelector\" dialog box."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.3.4.2", "1.1.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.3.4.3", "1.1.6.3"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ColorSelectorSettings\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.4.1", "1.1.6.4"}],

Cell[TextData[{
  StyleBox["ColorSelectorSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the \"Color \
Selector\" dialog box. This dialog box appears when you click ",
  StyleBox["Input \[RightTriangle] Color Selector.... ",
    FontFamily->"Helvetica"],
  StyleBox["ColorSelectorSettings",
    FontFamily->"Courier"],
  " consists of the following suboption."
}], "Text",
  CellTags->{"1.1.6.4.2", "1.1.6.4"}],

Cell[CellGroupData[{

Cell["\"Color\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.4.1.1", "1.1.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Color\"",
    FontFamily->"Courier"],
  " is a global option that specifies the default color used by the Color \
Selector dialog box."
}], "Usage",
  CellTags->{"1.1.6.4.1.2", "1.1.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The \"Color Selector\" dialog box is accessed by \
clicking the ",
  StyleBox["Input \[RightTriangle] Color Selector\[Ellipsis]",
    FontFamily->"Helvetica"],
  " command. When you click ",
  StyleBox["OK",
    FontFamily->"Helvetica"],
  ", a string corresponding to the default color is pasted into the notebook \
at the position of the cursor.\n\[FilledSmallSquare] Possible settings are as \
follows.\n",
  StyleBox[" GrayLevel[",
    FontFamily->"Courier"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  "  ",
  StyleBox["      ",
    FontFamily->"Courier"],
  " where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is a number between 0 and 1 that determines the intensity,\n \t\t\t       \
   ",
  " i.e.",
  " light or dark.  ",
  StyleBox["\n RGBColor[",
    FontFamily->"Courier"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["z",
    FontSlant->"Italic"],
  StyleBox["]    ",
    FontFamily->"Courier"],
  "  where ",
  StyleBox["x",
    FontSlant->"Italic"],
  ",",
  StyleBox["y, ",
    FontSlant->"Italic"],
  "and",
  StyleBox[" z",
    FontSlant->"Italic"],
  " are numbers between 0 and 1 that determine the \n                         \
                      color in terms of its red, green, and blue components.\n\
 \[FilledSmallSquare] If the color is specified using ",
  StyleBox["Hue[",
    FontFamily->"Courier"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " or ",
  StyleBox["CMYKColor",
    FontFamily->"Courier"],
  ", it is automatically converted to ",
  StyleBox["RGBColor[",
    FontFamily->"Courier"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["z",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  "by the front end. "
}], "Notes",
  CellTags->{"1.1.6.4.1.3", "1.1.6.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["GridCreationSettings\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.5.1", "1.1.6.5"}],

Cell[TextData[{
  StyleBox["GridCreationSettings",
    FontFamily->"Courier"],
  " is a group of global options that stores the settings associated with the \
\"Create Table/Matrix/Palette\" dialog box. This dialog box appears when you \
click the ",
  StyleBox["Input \[RightTriangle] Create Table/Matrix/Palette...",
    FontFamily->"Helvetica"],
  ". ",
  StyleBox["GridCreationSettings",
    FontFamily->"Courier"],
  " consists of the following suboptions."
}], "Text",
  CellTags->{"1.1.6.5.2", "1.1.6.5"}],

Cell[CellGroupData[{

Cell["\"Rows\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.1.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Rows\"",
    FontFamily->"Courier"],
  " is a global option that determines the number of rows that a newly \
created table, matrix, or palette will have."
}], "Usage",
  CellTags->{"1.1.6.5.1.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is typically set using the \"Number of \
rows:\" text field in the \"Create Table/Matrix/Palette\" dialog box. \n\
\[FilledSmallSquare] ",
  StyleBox["\"Rows\"",
    FontFamily->"Courier"],
  " can be set to any integer value greater than or equal to zero. \n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["\"Rows\" \[Rule] 3",
    FontFamily->"Courier"],
  ", any newly created table, matrix, or palette has three rows. \n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.1.3", "1.1.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Columns\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.2.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Columns\"",
    FontFamily->"Courier"],
  " is a global option that determines the number of columns that a newly \
created table, matrix, or palette will have."
}], "Usage",
  CellTags->{"1.1.6.5.2.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is typically set using the \"Number of \
columns:\" text field in the \"Create Table/Matrix/Palette\" dialog box. \n\
\[FilledSmallSquare] ",
  StyleBox["\"Columns\"",
    FontFamily->"Courier"],
  " can be set to any integer value greater than or equal to zero. \n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["\"Columns\" \[Rule] 3",
    FontFamily->"Courier"],
  ", any newly created table, matrix, or palette has three columns. \n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.2.3", "1.1.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DrawRowLines\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.3.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"DrawRowLines\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " lines are drawn between adjacent rows of a table, matrix, or palette.  "
}], "Usage",
  CellTags->{"1.1.6.5.3.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is typically set using the \"Draw lines \
between rows\" check box in the \"Create Table/Matrix/Palette\" dialog box. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["\"DrawRowLines\" \[Rule] True",
    FontFamily->"Courier"],
  ", a line is drawn between any two adjacent rows of the grid box.\n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["\"DrawRowLines\" \[Rule] False",
    FontFamily->"Courier"],
  ", no lines are drawn between rows. \n\[FilledSmallSquare] ",
  StyleBox["\"DrawRowLines\"",
    FontFamily->"Courier"],
  " only controls the display of lines indirectly, by specifying if a newly \
created grid box includes separate options for drawing lines. It is the \
GridBox options that directly control whether or not lines are drawn.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.3.3", "1.1.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DrawColumnLines\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.4.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DrawColumnLines",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " lines are drawn between adjacent columns of a table, matrix, or palette.  \
"
}], "Usage",
  CellTags->{"1.1.6.5.4.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is typically set using the \"Draw columns \
between rows\" check box in the \"Create Table/Matrix/Palette\" dialog box. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["\"DrawColumnLines\" \[Rule] True",
    FontFamily->"Courier"],
  ", a line is drawn between any two adjacent columns of the grid box.\n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["\"DrawColumnLines\" \[Rule] False",
    FontFamily->"Courier"],
  ", no lines are drawn between columns. \n\[FilledSmallSquare] ",
  StyleBox["\"DrawColumnLines",
    FontFamily->"Courier"],
  "\" only controls the display of lines indirectly, by specifying if a newly \
created grid box includes separate options for drawing lines. It is the \
GridBox options that directly control whether or not lines are drawn.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.4.3", "1.1.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DrawFrame\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.5.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"DrawFrame\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a frame is drawn around a table, matrix, or palette."
}], "Usage",
  CellTags->{"1.1.6.5.5.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is typically set using the \"Draw frame\" \
check box in the \"Create Table/Matrix/Palette\" dialog box. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["\"DrawFrame\" \[Rule] True",
    FontFamily->"Courier"],
  ", the grid box is enclosed by a frame.\n\[FilledSmallSquare] With the \
default setting ",
  StyleBox["\"DrawFrame\" \[Rule] False",
    FontFamily->"Courier"],
  ", the grid box is drawn without a frame.  \n\[FilledSmallSquare] ",
  StyleBox["\"DrawFrame\"",
    FontFamily->"Courier"],
  " only controls the display of a frame indirectly, by specifying if a newly \
created grid box includes a separate option for drawing a frame. It is the \
GridBox option that directly controls whether or not a frame is drawn.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.5.3", "1.1.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Type\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.6.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["Type",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a grid box created via the dialog box is a table, matrix, or palette. "
}], "Usage",
  CellTags->{"1.1.6.5.6.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] The three possible settings for ",
  StyleBox["Type",
    FontFamily->"Courier"],
  " are ",
  StyleBox["Table",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Matrix",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["Palette",
    FontFamily->"Courier"],
  ". A table is a simple rectangular grid of elements; a matrix is a table \
that is enclosed in parentheses; and a palette is a rectangular array of \
buttons.\n\[FilledSmallSquare] The value of ",
  StyleBox["\"Type\"",
    FontFamily->"Courier"],
  " is typically set by clicking the appropriate radio button in the \"Create \
Table/Matrix/Palette\" dialog box.  \n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.6.3", "1.1.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Fill\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.7.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Fill\"",
    FontFamily->"Courier"],
  " is a global option that determines if a piece of text is automatically \
inserted into each element of a newly-created grid box."
}], "Usage",
  CellTags->{"1.1.6.5.7.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"Fill\" \[Rule] True",
    FontFamily->"Courier"],
  ", the chosen text is automatically entered into the grid box. \n\
\[FilledSmallSquare] The text to be entered must be specified using the \
related option ",
  StyleBox["\"FillText\"",
    FontFamily->"Courier"],
  ". It can be any string.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"Fill\" \[Rule] False",
    FontFamily->"Courier"],
  ", a blank placeholder (\[Placeholder]) is entered into each element of the \
grid box.  \n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.7.3", "1.1.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DiagonalFill\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.8.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"DiagonalFill\"",
    FontFamily->"Courier"],
  " is a global option that determines if a piece of text is automatically \
inserted into each diagonal element of a newly-created grid box."
}], "Usage",
  CellTags->{"1.1.6.5.8.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"DiagonalFill\" \[Rule] True",
    FontFamily->"Courier"],
  ", the chosen text is automatically entered into the grid box.\n\
\[FilledSmallSquare] The text to be entered is specified using the related \
option ",
  StyleBox["\"DiagonalFillText\"",
    FontFamily->"Courier"],
  ". It can be any string.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"Fill\" \[Rule] False",
    FontFamily->"Courier"],
  ", a blank placeholder (\[Placeholder]) is entered into each diagonal \
element of the grid box.  \n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.8.3", "1.1.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FillText\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.9.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FillText\"",
    FontFamily->"Courier"],
  " is a global option that specifies a string to be automatically inserted \
into each element of a newly-created grid box. "
}], "Usage",
  CellTags->{"1.1.6.5.9.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is typically set by entering a string in \
the \"Fill with:\" text field in the \"Create Table/Matrix/Palette\" dialog \
box. \n\[FilledSmallSquare] Its value can be any string. The default setting \
is ",
  StyleBox["\"FillText\" \[Rule] \"0\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.9.3", "1.1.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DiagonalFillText\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.5.10.1", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"DiagonalFillText\"",
    FontFamily->"Courier"],
  " is a global option that specifies a string to be automatically entered \
into each diagonal element of a newly-created grid box."
}], "Usage",
  CellTags->{"1.1.6.5.10.2", "1.1.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is typically set by entering a string in \
the \"Fill diagonal:\" text field of the \"Create Table/Matrix/Palette\" \
dialog box. \n\[FilledSmallSquare] The default setting is ",
  StyleBox["\"FillDiagonalText\" \[Rule] \"1\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["GridBoxOptions",
    ButtonData:>"GridBoxOptions->{...}",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.5.10.3", "1.1.6.5"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["HyperlinkCreationSettings\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.6.1", "1.1.6.6"}],

Cell[TextData[{
  StyleBox["HyperlinkCreationSettings",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a global option that stores settings associated with the \"",
  "Create Hyperlink\[Ellipsis]\"",
  " dialog box. This dialog box is accessed by clicking ",
  StyleBox["Input \[RightTriangle] Create Hyperlink...",
    FontFamily->"Helvetica"],
  ". ",
  StyleBox["HyperlinkCreationSettings",
    FontFamily->"Courier"],
  " consists of the following suboption."
}], "Text",
  CellTags->{"1.1.6.6.2", "1.1.6.6"}],

Cell[CellGroupData[{

Cell["\"IncludeFilename\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.6.1.1", "1.1.6.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"IncludeFilename\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a hyperlink should explicitly include the directory location of the \
destination notebook."
}], "Usage",
  CellTags->{"1.1.6.6.1.2", "1.1.6.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"IncludeFilename\" \[Rule] True",
    FontFamily->"Courier"],
  ", the location of the destination notebook is explicitly stored along with \
the hyperlink.\n",
  StyleBox["\[FilledSmallSquare]", "MR"],
  StyleBox[" ", "MR",
    FontFamily->"Times"],
  "The file location is specified using the ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " function.  \n\[FilledSmallSquare] With the default setting ",
  StyleBox["\"IncludeFilename\" \[Rule] False",
    FontFamily->"Courier"],
  ", the location of the destination notebook is not specified. In this case, \
the destination is assumed to be in the same notebook as the hyperlink \
itself. "
}], "Notes",
  CellTags->{"1.1.6.6.1.3", "1.1.6.6"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NotebookStatisticsSettings\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.7.1", "1.1.6.7"}],

Cell[TextData[{
  StyleBox["NotebookStatisticsSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the \"Cell Size \
Statistics\" dialog box. This dialog box appears when you click ",
  StyleBox["Cell \[RightTriangle] Cell Size Statistics...",
    FontFamily->"Helvetica"],
  ". ",
  StyleBox["NotebookStatisticsSettings",
    FontFamily->"Courier"],
  " consists of the following suboptions."
}], "Text",
  CellTags->{"1.1.6.7.2", "1.1.6.7"}],

Cell[CellGroupData[{

Cell["\"Domain\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.7.1.1", "1.1.6.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Domain\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the range of cells for which information is presented in \
the \"CellSizeStatistics\" dialog box."
}], "Usage",
  CellTags->{"1.1.6.7.1.2", "1.1.6.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"Domain\" \[Rule] \"Selection\"",
    FontFamily->"Courier"],
  ", the dialog box displays statistics for the selected cells only. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["\"Domain\" \[Rule] \"Notebook\"",
    FontFamily->"Courier"],
  ", the dialog box displays statistics for all cells in the notebook."
}], "Notes",
  CellTags->{"1.1.6.7.1.3", "1.1.6.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeSharedData\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.7.2.1", "1.1.6.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["IncludeSharedData",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " the displayed size of the notebook reflects data sharing, a method of \
optimizing memory usage."
}], "Usage",
  CellTags->{"1.1.6.7.2.2", "1.1.6.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["IncludeSharedData \[Rule] False",
    FontFamily->"Courier"],
  ", all data associated with the cells will be counted in full each time it \
occurs. This means the amount displayed may be larger than the actual amount \
of memory in use, because the same data may be used in more than one \
location.\n\[FilledSmallSquare] With the setting ",
  StyleBox["IncludeSharedData \[Rule] True",
    FontFamily->"Courier"],
  ", the memory counted for each object is the memory used by that object \
divided by the number of times that object is shared. For example, a token \
that occupies 50 bytes of memory, but is shared by 5 different cells, will be \
counted as using 10 bytes in each cell it occurs in.  \n\[FilledSmallSquare] \
In general, it is not possible to define a \"correct\" way of measuring \
memory use when data is being shared: which definition is more useful depends \
on the situation."
}], "Notes",
  CellTags->{"1.1.6.7.2.3", "1.1.6.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.7.3.1", "1.1.6.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the \"Cell \
Size Statistics\" dialog box."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.7.3.2", "1.1.6.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.7.3.3", "1.1.6.7"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["OptionInspectorSettings\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.8.1", "1.1.6.8"}],

Cell[TextData[{
  StyleBox["OptionInspectorSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the Option \
Inspector. The Option Inspector is accessed by clicking ",
  StyleBox["Format \[RightTriangle] Option Inspector...",
    FontFamily->"Helvetica"],
  ". ",
  StyleBox["OptionInspectorSettings",
    FontFamily->"Courier"],
  " consists of the following suboptions."
}], "Text",
  CellTags->{"1.1.6.8.2", "1.1.6.8"}],

Cell[CellGroupData[{

Cell["\"Scope\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.8.1.1", "1.1.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["Scope",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is a global option that determines the inheritance level for which \
options are displayed in the Option Inspector window."
}], "Usage",
  CellTags->{"1.1.6.8.1.2", "1.1.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"Scope\" \[Rule] \"Selection\"",
    FontFamily->"Courier"],
  ", only those options that can be set at the level of the selection are \
displayed in the window. All other options are dimmed. \n\[FilledSmallSquare] \
The other possible settings, in decreasing order of precedence, are ",
  StyleBox["\"Global\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Notebook\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"Selection\"",
    FontFamily->"Courier"],
  ".",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.8.",
    ButtonData:>{"2.11.8", "8.7"},
    ButtonStyle->"MainBookLink"],
  "\n\[FilledSmallSquare] See also: ",
  ButtonBox["Option Inspector",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->{"1.1.6.8.1.3", "1.1.6.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ViewAs\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.8.2.1", "1.1.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ViewAs\"",
    FontFamily->"Courier"],
  " is a global option that determines the format for displaying the options \
in the Option Inspector window."
}], "Usage",
  CellTags->{"1.1.6.8.2.2", "1.1.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ViewAs \[Rule] \"Browser\"",
    FontFamily->"Courier"],
  ", the options are grouped into categories according to their inheritance \
levels (",
  "e.g. ",
  "Global, Notebook, and Cell) and function. There is some overlap between \
the different categories, with some options being listed in more than one \
place.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"ViewAs\" \[Rule] \"Alphabetical\"",
    FontFamily->"Courier"],
  ", the options are listed in alphabetical order.\n\[FilledSmallSquare] With \
the setting ",
  StyleBox["\"ViewAs\" \[Rule] \"Text\"",
    FontFamily->"Courier"],
  ", those options whose settings differ from their default values are listed \
as plain text."
}], "Notes",
  CellTags->{"1.1.6.8.2.3", "1.1.6.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WindowSize\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.8.3.1", "1.1.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["WindowSize", "MR"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the size of the Option Inspector window. "
}], "Usage",
  CellTags->{"1.1.6.8.3.2", "1.1.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowSize\" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["w",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["h",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " gives the width and height of the window in printer's points. \n\
\[FilledSmallSquare] Setting either the width or height to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " causes the size of the window to be determined from the setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " and the size of your screen. \n\[FilledSmallSquare] The setting for ",
  StyleBox["\"WindowSize\"",
    FontFamily->"Courier"],
  " changes whenever you resize the Option Inspector window interactively. "
}], "Notes",
  CellTags->{"1.1.6.8.3.3", "1.1.6.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.8.4.1", "1.1.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the Option \
Inspector window."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.8.4.2", "1.1.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.8.4.3", "1.1.6.8"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["EditButtonSettings\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.9.1", "1.1.6.9"}],

Cell[TextData[{
  StyleBox["EditButtonSettings",
    FontFamily->"Courier"],
  " is a global option associated with the \"Edit Button\" dialog box. This \
dialog box is accessed by clicking ",
  StyleBox["Input \[RightTriangle] Create Button",
    FontFamily->"Helvetica"],
  ". ",
  StyleBox["EditButtonSettings",
    FontFamily->"Courier"],
  " consists of the following suboption."
}], "Text",
  CellTags->{"1.1.6.9.2", "1.1.6.9"}],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.9.1.1", "1.1.6.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the \"Edit \
Button\" dialog box."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.9.1.2", "1.1.6.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.9.1.3", "1.1.6.9"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["BackgroundTasksSettings\[LongRightArrow]{\[Ellipsis]} ", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.10.1", "1.1.6.10"}],

Cell[TextData[{
  StyleBox["BackgroundTasksSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the \"Background \
Tasks\" dialog box. It consists of the following suboption."
}], "Text",
  CellTags->{"1.1.6.10.2", "1.1.6.10"}],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.10.1.1", "1.1.6.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the \
\"Background Tasks\" dialog box."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.10.1.2", "1.1.6.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.10.1.3", "1.1.6.10"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["InterruptSettings\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.11.1", "1.1.6.11"}],

Cell[TextData[{
  StyleBox["InterruptSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the \"Interrupt \
Settings\" dialog box. It consists of the following suboption."
}], "Text",
  CellTags->{"1.1.6.11.2", "1.1.6.11"}],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.11.1.1", "1.1.6.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the \
\"Background Tasks\" dialog box."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.11.1.2", "1.1.6.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.11.1.3", "1.1.6.11"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["InputSettings\[LongRightArrow]{\[Ellipsis]} ", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.12.1", "1.1.6.12"}],

Cell[TextData[{
  StyleBox["InputSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the \"Input \
Settings\" dialog box. It consists of the following suboption."
}], "Text",
  CellTags->{"1.1.6.12.2", "1.1.6.12"}],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.12.1.1", "1.1.6.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the \"Input \
Settings\" dialog box."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.12.1.2", "1.1.6.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.12.1.3", "1.1.6.12"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["HelpBrowserSettings\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.13.1", "1.1.6.13"}],

Cell[TextData[{
  StyleBox["HelpBrowserSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the Help Browser. \
It consists of the following suboptions."
}], "Text",
  CellTags->{"1.1.6.13.2", "1.1.6.13"}],

Cell[CellGroupData[{

Cell["\"ShowCategories\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.13.1.1", "1.1.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ShowCategories\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " browser categories are displayed in the Help Browser window.  "
}], "Usage",
  CellTags->"1.1.6.13"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"ShowCategories\" \[Rule] True",
    FontFamily->"Courier"],
  ", the browser window contains a set of four columns that display the \
categories of help information available.\n\[FilledSmallSquare] With the \
setting ",
  StyleBox["\"ShowCategories\" \[Rule] False",
    FontFamily->"Courier"],
  ", the columns containing the browser categories are no longer visible, \
thus increasing the amount of text that can be displayed within the Help \
Browser."
}], "Notes",
  CellTags->"1.1.6.13"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WindowSize\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.13.1.1", "1.1.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["WindowSize", "MR"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the size of the window used to display the Help Browser \
window.  "
}], "Usage",
  CellTags->"1.1.6.13"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowSize\" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["w",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["h",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " gives the width and height of the window in printer's points. \n\
\[FilledSmallSquare] Setting either the width or height to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " causes the size of the window to be determined from the setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " and the size of your screen. \n\[FilledSmallSquare] The setting for ",
  StyleBox["\"WindowSize\"",
    FontFamily->"Courier"],
  " changes whenever you resize the Help Browser window interactively in the \
front end. "
}], "Notes",
  CellTags->"1.1.6.13"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.2.2.1", "1.1.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["WindowMargins", "MR"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the \"Help \
Browser\" window."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.2.2.2", "1.1.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.2.2.3", "1.1.6.13"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ErrorsDialogSettings\[LongRightArrow]{\[Ellipsis]} ", "GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.14.1", "1.1.6.14"}],

Cell[TextData[{
  StyleBox["ErrorsDialogSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the Errors dialog \
box. It consists of the following suboption."
}], "Text",
  CellTags->{"1.1.6.14.2", "1.1.6.14"}],

Cell[CellGroupData[{

Cell["\"WindowMargins\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.14.1.1", "1.1.6.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " is a global option that determines the size of margins around the Errors \
dialog box."
}], "Usage",
  CellDingbat->None,
  CellTags->{"1.1.6.14.1.2", "1.1.6.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WindowMargins\" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right",
    FontSlant->"Italic"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "determines the distances from each edge of your screen to each edge of the \
window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are set to ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \n\
\[FilledSmallSquare] The settings for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " change automatically whenever you move a window around interactively on \
the screen. \n\[FilledSmallSquare] The window edges closer to the edges of \
the screen are typically assigned explicit margin distances; the other edges \
are set to ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". This allows the same setting for ",
  StyleBox["\"WindowMargins\"",
    FontFamily->"Courier"],
  " to work on screens of different sizes. "
}], "Notes",
  CellDingbat->None,
  CellTags->{"1.1.6.14.1.3", "1.1.6.14"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["StyleNameDialogSettings\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.15.1", "1.1.6.15"}],

Cell[TextData[{
  StyleBox["StyleNameDialogSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the \"Style \
Name\" dialog box. It consists of the following suboption."
}], "Text",
  CellTags->{"1.1.6.15.2", "1.1.6.15"}],

Cell[CellGroupData[{

Cell["\"Style\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.15.1.1", "1.1.6.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["Style",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is a global option that determines the cell style displayed in the \
\"Style Name\" dialog box."
}], "Usage",
  CellTags->{"1.1.6.15.1.2", "1.1.6.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] The \"Style Name\" dialog box appears when you click \
",
  StyleBox["Format \[RightTriangle] Style \[RightTriangle] Other\[Ellipsis]. \
",
    FontFamily->"Helvetica"],
  "\n\[FilledSmallSquare] The default setting is ",
  StyleBox["\"Style\" \[Rule] \"Input\"",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.15.1.3", "1.1.6.15"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FileNameDialogSettings\[LongRightArrow]{\[Ellipsis]} ", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.16.1", "1.1.6.16"}],

Cell[TextData[{
  StyleBox["FileNameDialogSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the File dialog \
box. It consists of the following suboption."
}], "Text",
  CellTags->{"1.1.6.16.2", "1.1.6.16"}],

Cell[CellGroupData[{

Cell["\"StringFormat\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.16.1.1", "1.1.6.16"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["StringFormat",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is a global option that determines the format for pasting the pathname of \
a file into a notebook when the ",
  StyleBox["Input \[RightTriangle] Get File Path...",
    FontFamily->"Helvetica"],
  " menu command is used",
  StyleBox[".",
    FontFamily->"Helvetica"]
}], "Usage",
  CellTags->{"1.1.6.16.1.2", "1.1.6.16"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"StringFormat\" \[Rule] True",
    FontFamily->"Courier"],
  ", the pathname of the file is pasted into the notebook as a string. The \
pathname is expressed in a format appropriate for the operating system being \
used. \n \[FilledSmallSquare] With the setting ",
  StyleBox["\"StringFormat\" \[Rule] False",
    FontFamily->"Courier"],
  ", the pathname is pasted as a ",
  StyleBox["FrontEnd`FileName",
    FontFamily->"Courier"],
  " expression."
}], "Notes",
  CellTags->{"1.1.6.16.1.3", "1.1.6.16"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NotebookConvertSettings\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  Background->None,
  CellTags->{"1.1.6.17.1", "1.1.6.17"}],

Cell[TextData[{
  StyleBox["NotebookConvertSettings",
    FontFamily->"Courier"],
  " is a global option that stores settings associated with the \"Notebook \
Convert\" dialog box. This dialog box appears when you open a notebook \
created using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 2. ",
  StyleBox["NotebookConvertSettings",
    FontFamily->"Courier"],
  " consists of the following suboptions."
}], "Text",
  CellTags->{"1.1.6.17.2", "1.1.6.17"}],

Cell[CellGroupData[{

Cell["\"InputToStandardForm\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.17.1.1", "1.1.6.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"InputToStandardForm\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " input cells are converted to ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  " whenever a notebook is converted from Version 2. "
}], "Usage",
  CellTags->{"1.1.6.17.1.2", "1.1.6.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["InputToStandardForm \[Rule] True",
    FontFamily->"Courier"],
  ", input cells present in a Version 2 notebook are automatically converted \
to ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  " when the notebook is converted.\n\[FilledSmallSquare] With the setting ",
  StyleBox["InputToStandardForm \[Rule] False",
    FontFamily->"Courier"],
  ", input cells present in a Version 2 notebook are not converted to ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.17.1.3", "1.1.6.17"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"OutputToStandardForm\"", "SubObjectNameClosed",
  CellTags->{"1.1.6.17.2.1", "1.1.6.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"OutputToStandardForm\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " output cells are converted to ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  " whenever a notebook is converted from Version 2."
}], "Usage",
  CellTags->{"1.1.6.17.2.2", "1.1.6.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"OutputToStandardForm\" \[Rule] True",
    FontFamily->"Courier"],
  ", output cells present in a Version 2 notebook are automatically converted \
to ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  " when the notebook is converted.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"OutputToStandardForm\" \[Rule] False",
    FontFamily->"Courier"],
  ", output cells present in a Version 2 notebook are not converted to ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.6.17.2.3", "1.1.6.17"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PreserveStyleSheet\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.17.3.1", "1.1.6.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PreserveStyleSheet\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a private style sheet is generated, which replicates the styles used in \
the Version 2 notebook, and attached to the new notebook"
}], "Usage",
  CellTags->{"1.1.6.17.3.2", "1.1.6.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"PreserveStyleSheet\" \[Rule] True",
    FontFamily->"Courier"],
  ", a private style sheet is generated that replicates the styles used in \
the Version 2 notebook.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"PreserveStyleSheet\" \[Rule] False",
    FontFamily->"Courier"],
  ", a Version 2 notebook is automatically assigned the default style sheet \
when it is converted. All style information about the original notebook is \
therefore lost in the conversion.\n\[FilledSmallSquare] Because the default \
settings in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are fairly similar to those in Version 2, a notebook that did not define \
its own custom styles will look quite similar when converted with this option \
set to ",
  StyleBox["False",
    FontFamily->"Courier"],
  ". It is recommended that you elect not to preserve styles unless your \
notebook defines many custom styles; it is generally better to start with a \
fresh set of default styles."
}], "Notes",
  CellTags->{"1.1.6.17.3.3", "1.1.6.17"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"GenerateBitmapCaches\" ", "SubObjectNameClosed",
  CellTags->{"1.1.6.17.4.1", "1.1.6.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"GenerateBitmapCaches\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " graphics are rendered and bitmap versions are included in the new file \
when a notebook is converted from Version 2."
}], "Usage",
  CellTags->{"1.1.6.17.4.2", "1.1.6.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"GenerateBitmapCaches\" \[Rule] True",
    FontFamily->"Courier"],
  ", each graphic in the notebook will be fully rendered during the \
conversion process and a bitmap cache stored in the new file.  This can take \
a long time and consume a lot of memory for a large notebook containing many \
graphics cells.  However, it allows the resulting notebook to be opened more \
quickly.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"GenerateBitmapCaches\"",
    FontFamily->"Courier"],
  " \[Rule]",
  StyleBox[" False",
    FontFamily->"Courier"],
  ", no bitmap caches are generated, so any graphics present in the notebook \
will have to be rendered when they are first displayed while scrolling \
through the notebook."
}], "Notes",
  CellTags->{"1.1.6.17.4.3", "1.1.6.17"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["MessageOptions", "InspectorLevel1"],

Cell[TextData[{
  StyleBox["MessageOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  "is a global option",
  " that stores settings associated with the various Message dialog boxes."
}], "Text"],

Cell[CellGroupData[{

Cell["\"WarningAction\" ", "ObjectName",
  CellTags->{"1.1.7.1.1", "1.1.7.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WarningAction\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the type of action ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " takes to warn you when an evaluated kernel command is incorrect or \
ill-defined. "
}], "Usage",
  CellTags->{"1.1.7.1.2", "1.1.7.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] A warning occurs when you evaluate a command whose \
interpretation is ambiguous. In such cases, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tries to interpret the command as best as it can and proceeds with the \
evaluation, but it warns the user that the results obtained may be incorrect. \
\n\[FilledSmallSquare] ",
  StyleBox["\"WarningAction\"",
    FontFamily->"Courier"],
  " is specified as a list of the actions to be taken. The action(s) can be \
any of the following.\n   ",
  StyleBox["Beep            ",
    FontFamily->"Courier"],
  "A \"beep\" sound is played.\n   ",
  StyleBox["PrintToConsole  ",
    FontFamily->"Courier"],
  "A warning message is printed in a separate window called \"Messages\". \n  \
 ",
  StyleBox["PrintToNotebook ",
    FontFamily->"Courier"],
  "A warning message is printed in the notebook.\n   ",
  StyleBox["DialogBox       ",
    FontFamily->"Courier"],
  "A warning appears in a dialog box.\n   ",
  StyleBox["SeparateCells   ",
    FontFamily->"Courier"],
  "A warning is printed in a separate cell in the notebook."
}], "Notes",
  CellTags->{"1.1.7.1.3", "1.1.7.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ErrorAction\"", "ObjectName",
  CellTags->{"1.1.7.2.1", "1.1.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ErrorAction\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines the type of action ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " takes when an error occurs in evaluating a kernel command."
}], "Usage",
  CellTags->{"1.1.7.2.2", "1.1.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] An error occurs when you evaluate a command that is \
illegal, either because it is in the wrong syntax, it does not correspond to \
any known operation, or it leads to a numerical error. In such cases, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " cannot proceed with the evaluation until the input is suitably modified. \
"
}], "Notes",
  CellTags->{"1.1.7.2.3", "1.1.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ErrorAction\"",
    FontFamily->"Courier"],
  " is specified as a list of the actions to be taken. The action(s) can be \
any of the following.\n   ",
  StyleBox["Beep            ",
    FontFamily->"Courier"],
  "A \"beep\" sound is played.\n   ",
  StyleBox["PrintToConsole  ",
    FontFamily->"Courier"],
  "A warning message is printed in a separate window called \"Messages\". \n  \
 ",
  StyleBox["PrintToNotebook ",
    FontFamily->"Courier"],
  "A warning message is printed in the notebook.\n   ",
  StyleBox["DialogBox       ",
    FontFamily->"Courier"],
  "A warning appears in a dialog box.\n   ",
  StyleBox["SeparateCells   ",
    FontFamily->"Courier"],
  "A warning is printed in a separate cell in the notebook."
}], "Notes",
  CellTags->{"1.1.7.2.4", "1.1.7.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ConsoleMessageAction\" ", "ObjectName",
  CellTags->{"1.1.7.3.1", "1.1.7.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ConsoleMessageAction\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " alerts you when an error occurs that is normally directed towards the \
message window."
}], "Usage",
  CellTags->{"1.1.7.3.2", "1.1.7.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ConsoleMessageAction\"",
    FontFamily->"Courier"],
  " is specified as a list of the actions to be taken. The action(s) can be \
any of the following.\n   ",
  StyleBox["Beep            ",
    FontFamily->"Courier"],
  "A \"beep\" sound is played.\n   ",
  StyleBox["PrintToConsole  ",
    FontFamily->"Courier"],
  "A warning message is printed in a separate window called \"Messages\". \n  \
 ",
  StyleBox["PrintToNotebook ",
    FontFamily->"Courier"],
  "A warning message is printed in the notebook.\n   ",
  StyleBox["DialogBox       ",
    FontFamily->"Courier"],
  "A warning appears in a dialog box.\n   ",
  StyleBox["SeparateCells   ",
    FontFamily->"Courier"],
  "A warning is printed in a separate cell in the notebook."
}], "Notes",
  CellTags->{"1.1.7.3.3", "1.1.7.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"KernelMessageAction\" ", "ObjectName",
  CellTags->{"1.1.7.4.1", "1.1.7.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"KernelMessageAction\"",
    FontFamily->"Courier"],
  " ",
  "is a global option",
  " that determines how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " alerts you when a kernel error occurs."
}], "Usage",
  CellTags->{"1.1.7.4.2", "1.1.7.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"KernelMessageAction\"",
    FontFamily->"Courier"],
  " is specified as a list of the actions to be taken. The action(s) can be \
any of the following.\n   ",
  StyleBox["Beep            ",
    FontFamily->"Courier"],
  "A \"beep\" sound is played.\n   ",
  StyleBox["PrintToConsole  ",
    FontFamily->"Courier"],
  "A warning message is printed in a separate window called \"Messages\". \n  \
 ",
  StyleBox["PrintToNotebook ",
    FontFamily->"Courier"],
  "A warning message is printed in the notebook.\n   ",
  StyleBox["DialogBox       ",
    FontFamily->"Courier"],
  "A warning appears in a dialog box.\n   ",
  StyleBox["SeparateCells   ",
    FontFamily->"Courier"],
  "A warning is printed in a separate cell in the notebook."
}], "Notes",
  CellTags->{"1.1.7.4.3", "1.1.7.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"StartupHelp\" ", "ObjectName",
  CellTags->{"1.1.7.5.1", "1.1.7.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"StartupHelp\"",
    FontFamily->"Courier"],
  " is a global option that determines if a dialog box providing access to \
the Help Browser appears when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " starts. "
}], "Usage",
  CellTags->{"1.1.7.5.2", "1.1.7.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting",
  " ",
  StyleBox["StartupHelp \[Rule] True",
    FontFamily->"Courier"],
  ", the Help dialog box is automatically displayed when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is launched. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["StartupHelp \[Rule] False",
    FontFamily->"Courier"],
  ", the Help dialog box window does not appear when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is launched. "
}], "Notes",
  CellTags->{"1.1.7.5.3", "1.1.7.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ExplainBeepHelp\"", "ObjectName",
  CellTags->{"1.1.7.6.1", "1.1.7.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ExplainBeepHelp\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a dialog box appears whenever an error occurs that causes a beep."
}], "Usage",
  CellTags->{"1.1.7.6.2", "1.1.7.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"ExplainBeepHelp\" \[Rule] True",
    FontFamily->"Courier"],
  ", a dialog box appears whenever a beep occurs.\n\[FilledSmallSquare] With \
the setting ",
  StyleBox["\"ExplainBeepHelp\" \[Rule] False",
    FontFamily->"Courier"],
  ", a dialog box does not appear whenever a beep occurs. "
}], "Notes",
  CellTags->{"1.1.7.6.3", "1.1.7.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MathMLPasteWarning\" ", "ObjectName",
  CellTags->"MathMLPasteWarning"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"MathMLPasteWarning\"",
    FontFamily->"Courier"],
  " is a global option that determines whether a warning is given when a \
MathML expression is pasted into a notebook."
}], "Usage",
  CellTags->"MathMLPasteWarning"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"MathMLPasteWarning\" \[Rule] True",
    FontFamily->"Courier"],
  ", pasting a MathML expression brings up a dialog box asking if you want to \
interpret the MathML expression.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"MathMLPasteWarning\" \[Rule] False",
    FontFamily->"Courier"],
  ", no warnings are given and the pasted MathML expression is interpreted."
}], "Notes",
  CellTags->"MathMLPasteWarning"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"InsufficientVersionWarning\" ", "ObjectName",
  CellTags->"InsufficientVersionWarning"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"InsufficientVersionWarning\"",
    FontFamily->"Courier"],
  " is a global option that determines whether a warning is given when the \
user opens a notebook created with a newer version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Usage",
  CellTags->"InsufficientVersionWarning"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"InsufficientVersionWarning\" \[Rule] True",
    FontFamily->"Courier"],
  ", a warning is given if the user opens a notebook in an older version of \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " than the version used to create the notebook . \n\[FilledSmallSquare] \
With the setting ",
  StyleBox["\"InsufficientVersionWarning\" \[Rule] False",
    FontFamily->"Courier"],
  ", no warning is given."
}], "Notes",
  CellTags->"InsufficientVersionWarning"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IgnoreTagBoxDeletionWarning\"", "ObjectName",
  CellTags->{"1.1.7.7.1", "1.1.7.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"IgnoreTagBoxDeletionWarning\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a warning is given when the user edits a tag box. "
}], "Usage",
  CellTags->{"1.1.7.7.2", "1.1.7.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"IgnoreTagBoxDeletionWarning\"",
    FontFamily->"Courier"],
  " interacts with the local option ",
  StyleBox["\"TagBoxDeletionWarning\"",
    FontFamily->"Courier"],
  " to determine if a warning is given when a tag box is edited.\n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["\"IgnoreTagBoxDeletionWarning\" \[Rule] True",
    FontFamily->"Courier"],
  ", no warning is given when a tag box is edited, even if ",
  StyleBox["\"TagBoxDeletionWarning\"",
    FontFamily->"Courier"],
  " is set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  " at the local level.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"IgnoreTagBoxDeletionWarning\" \[Rule] False",
    FontFamily->"Courier"],
  ",",
  StyleBox[" ",
    FontFamily->"Courier"],
  "a warning is given provided ",
  StyleBox["\"TagBoxDeletionWarning\"",
    FontFamily->"Courier"],
  " is set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  ".",
  StyleBox[" ",
    FontFamily->"Courier"],
  "\n \[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["TagBox",
    ButtonStyle->"RefGuideLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.7.7.3", "1.1.7.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"TraditionalFormEvaluationWarning\"", "ObjectName",
  CellTags->{"1.1.7.8.1", "1.1.7.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"TraditionalFormEvaluationWarning\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a warning is issued when a ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  " expression is evaluated that could be interpreted incorrectly. "
}], "Usage",
  CellTags->{"1.1.7.8.2", "1.1.7.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"TraditionalFormEvaluationWarning\" \[Rule] True",
    FontFamily->"Courier"],
  ", a warning is given when a ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  " expression being evaluated has an ambiguous interpretation. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["\"TraditionalFormEvaluationWarning\" \[Rule] False",
    FontFamily->"Courier"],
  ", no warning is given when a ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  " expression being evaluated has an ambiguous interpretation. "
}], "Notes",
  CellTags->{"1.1.7.8.3", "1.1.7.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"AllowDisablingWarnings\" ", "ObjectName",
  CellTags->{"1.1.7.9.1", "1.1.7.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"AllowDisablingWarnings\"",
    FontFamily->"Courier"],
  " is a global option that determines ",
  "if",
  " a warning is given when the user edits a tag box or tries to evaluate an \
ambiguous ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  " expression."
}], "Usage",
  CellTags->{"1.1.7.9.2", "1.1.7.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"AllowDisablingWarnings\" \[Rule] True",
    FontFamily->"Courier"],
  ", a warning is given only if ",
  StyleBox["\"IgnoreTagBoxDeletionWarning\"",
    FontFamily->"Courier"],
  " and ",
  StyleBox["\"TraditionalFormEvaluationWarning\"",
    FontFamily->"Courier"],
  " are both set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] With the setting ",
  StyleBox["\"AllowDisablingWarnings\" \[Rule] False",
    FontFamily->"Courier"],
  ", no warning is given when a ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  " expression is evaluated or a tag box is deleted, even if the options ",
  StyleBox["\"TraditionalFormEvaluationWarning\"",
    FontFamily->"Courier"],
  " and ",
  StyleBox["\"IgnoreTagBoxDeletionWarning\"",
    FontFamily->"Courier"],
  " are both set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.1.7.9.3", "1.1.7.9"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell[CellGroupData[{

Cell["File Options", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["NotebookAutoSave", "ObjectName",
  CellTags->{"1.2.1.1.1", "1.2.1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebookAutoSave", "MR"],
  " is an option for notebooks that determines ",
  "if",
  " a notebook is automatically saved each time an evaluation is completed \
within it. "
}], "Usage",
  CellTags->{"1.2.1.1.2", "1.2.1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["NotebookAutoSave", "MR"],
  StyleBox[" \[Rule] False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.6"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["NotebookSave",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.1.1.3", "1.2.1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ClosingAutoSave", "ObjectName",
  CellTags->{"1.2.1.1.1", "1.2.1.1a"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ClosingAutoSave", "MR"],
  " is an option for notebooks that determines ",
  "if",
  " a notebook is automatically saved when it is closed. "
}], "Usage",
  CellTags->{"1.2.1.1.2", "1.2.1.1a"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ClosingAutoSave", "MR"],
  StyleBox[" \[Rule] False",
    FontFamily->"Courier"],
  ", closing a notebook brings up a dialog box asking if you want to save the \
notebook. \n\[FilledSmallSquare] With the setting ",
  StyleBox["ClosingAutoSave", "MR"],
  StyleBox[" \[Rule] True",
    FontFamily->"Courier"],
  ", the dialog box does not appear and the notebook is automatically saved."
}], "Notes",
  CellTags->{"1.2.1.1.3", "1.2.1.1a"}]
}, Closed]],

Cell[CellGroupData[{

Cell["IncludeFileExtension ", "ObjectName",
  CellTags->{"1.2.1.2.1", "1.2.1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["IncludeFileExtension",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " the suffix \".nb\" is automatically appended to a notebook's name when it \
is first saved."
}], "Usage",
  CellTags->{"1.2.1.2.2", "1.2.1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["IncludeFileExtension \[Rule] True",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.2.1.2.3", "1.2.1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoGeneratedPackage ", "ObjectName",
  CellTags->{"1.2.1.3.1", "1.2.1.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoGeneratedPackage",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a package is automatically created from a notebook containing \
initialization cells when the notebook is saved."
}], "Usage",
  CellTags->{"1.2.1.3.2", "1.2.1.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["AutoGeneratedPackage",
    FontFamily->"Courier"],
  " -> ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ", a package is automatically created when a notebook containing \
initialization cells is saved for the first time. The package is \
automatically updated each time the notebook is saved. The package file has \
the same name as the notebook except with the suffix \".m\" instead of \
\".nb\", and it is stored in the same directory as the notebook.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["AutoGeneratedPackage \[Rule] None",
    FontFamily->"Courier"],
  ", a package is not created when a notebook containing initialization cells \
is saved.\n\[FilledSmallSquare]  With the default setting ",
  StyleBox["AutoGeneratedPackage \[Rule] Manual",
    FontFamily->"Courier"],
  ", a dialog box appears when a notebook containing initialization cells is \
saved, asking you to specify if a package should be created. Depending on \
your response, the value of the option is reset to ",
  StyleBox["None",
    FontFamily->"Courier"],
  " or ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.2.1.3.3", "1.2.1.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Editable ", "ObjectName",
  CellTags->{"1.2.1.4.1", "1.2.1.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a notebook can be edited. "
}], "Usage",
  CellTags->{"1.2.1.4.2", "1.2.1.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["Editable \[Rule] False",
    FontFamily->"Courier"],
  ", the contents of a notebook are protected and cannot be edited in any \
way. ",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Editable \[Rule] True",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] This option can be set for characters and cells \
as well as for the entire notebook."
}], "Notes",
  CellTags->{"1.2.1.4.3", "1.2.1.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Saveable ", "ObjectName",
  CellTags->"Saveable"],

Cell[TextData[{
  "\[FilledSmallSquare]",
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["Saveable",
    FontFamily->"Courier"],
  " is an option for notebooks that determines whether a notebook can be \
saved. "
}], "Usage",
  CellTags->"Saveable"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["Saveable \[Rule] False",
    FontFamily->"Courier"],
  ", a notebook cannot be saved using ",
  StyleBox["File",
    FontFamily->"Arial"],
  StyleBox[" \[RightTriangle] Save ",
    FontFamily->"Helvetica"],
  StyleBox["or the equivalent keyboard shortcut. Additionally, you will not \
be prompted to save the notebook if you make edits and then close the \
notebook or quit ",
    FontFamily->"Times New Roman"],
  StyleBox["Mathematica",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[". You can save the notebook using ",
    FontFamily->"Times New Roman"],
  StyleBox["File",
    FontFamily->"Arial"],
  StyleBox[" \[RightTriangle] Save",
    FontFamily->"Helvetica"],
  StyleBox["As",
    FontFamily->"Arial"],
  StyleBox[".",
    FontFamily->"Times New Roman"],
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Saveable \[Rule] True",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->"Saveable"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Display Options", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["ScreenStyleEnvironment", "ObjectName",
  CellTags->{"1.2.2.1.1", "1.2.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ScreenStyleEnvironment", "MR"],
  " ",
  "is an option for notebooks",
  " that determines the style environment for displaying a notebook on \
screen. "
}], "Usage",
  CellTags->{"1.2.2.1.2", "1.2.2.1"}],

Cell["\<\
\[FilledSmallSquare] Style environments provided in typical style \
sheets include the following. \
\>", "Notes",
  CellTags->{"1.2.2.1.3", "1.2.2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Condensed\\\\\\\
\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"environment for maximum \
display density \"\>"},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Presentation\\\\\
\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"environment for \
presentations \"\>"},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Printout\\\\\\\\\
\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"environment for paper \
printouts \"\>"},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Working\\\\\\\\\
\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"environment for working \
onscreen \"\>"}
          },
        ColumnAlignments->{Left}], TextForm]], "Notes",
  FormatType->StandardForm,
  CellTags->{"1.2.2.1.4", "1.2.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.10.11",
    ButtonData:>{"1.10.11", "11.3"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] ",
  "See also: ",
  ButtonBox["PrintingStyleEnvironment",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["StyleDefinitions",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.2.1.5", "1.2.2.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PrintingStyleEnvironment", "ObjectName",
  CellTags->{"1.2.2.2.1", "1.2.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PrintingStyleEnvironment", "MR"],
  " ",
  "is an option for notebooks",
  " that determines the style environment for printing a notebook. "
}], "Usage",
  CellTags->{"1.2.2.2.2", "1.2.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  ButtonBox["ScreenStyleEnvironment",
    ButtonStyle->"RefGuideLink"],
  ". \n\[FilledSmallSquare] Style environments optimized for printed output \
usually have font sizes smaller than those for onscreen display. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.10.11",
    ButtonData:>{"1.10.11", "11.3"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["StyleDefinitions",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NotebookPrint",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.2.2.3", "1.2.2.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowPageBreaks ", "ObjectName",
  CellTags->{"1.2.2.3.1", "1.2.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowPageBreaks",
    FontFamily->"Courier"],
  " is an option for notebooks that determines if a notebook is displayed \
onscreen with all page breaks marked and text styled as it would appear in \
print."
}], "Usage",
  CellTags->{"1.2.2.3.2", "1.2.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ShowPageBreaks \[Rule] False",
    FontFamily->"Courier"],
  ", the notebook is displayed onscreen in a style optimized for screen \
display. This style does not provide any pagination information. It typically \
has larger font sizes and word wrapping is set to the window width.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["ShowPageBreaks \[Rule] True",
    FontFamily->"Courier"],
  ", the notebook is displayed in the format used for printing. In addition \
to visible page breaks, this style typically has smaller font sizes and word \
wrapping is set to the paper width."
}], "Notes",
  CellTags->{"1.2.2.3.3", "1.2.2.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["WindowToolbars", "ObjectName",
  CellTags->{"1.2.2.4.1", "1.2.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowToolbars",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines if either or both of the toolbars, the ruler toolbar and \
the editing toolbar, are displayed at the top of a notebook."
}], "Usage",
  CellTags->{"1.2.2.4.2", "1.2.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is specified as a list whose elements can \
be either or both of the toolbars. With the default setting ",
  StyleBox["WindowToolbars \[Rule] {}",
    FontFamily->"Courier"],
  ", no toolbar is displayed.\n\[FilledSmallSquare] With the setting ",
  StyleBox["WindowToolbars \[Rule] {\"RulerBar\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"EditBar\"}",
    FontFamily->"Courier"],
  ", both the toolbars are displayed."
}], "Notes",
  CellTags->{"1.2.2.4.3", "1.2.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["RulerUnits", "ObjectName",
  CellTags->{"1.2.2.5.1", "1.2.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RulerUnits",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the units in the ruler toolbar."
}], "Usage",
  CellTags->{"1.2.2.5.2", "1.2.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings for ",
  StyleBox["RulerUnits",
    FontFamily->"Courier"],
  " are as follows.\n  ",
  StyleBox["\"Inches\"                 ",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Picas\"\n \"DecimalInches\"          \"Centimeters\" \n \
\"Points\"                 \"Millimeters\"\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["RulerUnits \[Rule] \"Inches\"",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.2.2.5.3", "1.2.2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Background", "ObjectName",
  CellTags->"NotebookBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background",
    FontFamily->"Courier"],
  " is an option that determines the background color of the notebook."
}], "Usage",
  CellTags->"NotebookBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background",
    FontFamily->"Courier"],
  StyleBox[" is an option for notebooks, cells, and selections. ",
    FontFamily->"Times New Roman"]
}], "Notes",
  CellTags->"NotebookBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["Background \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the background color is defined by the system settings. If the notebook \
is a regular notebook, ",
  StyleBox["Background \[Rule] Automatic",
    FontFamily->"Courier"],
  " will use window-style backgrounds; if the notebook is a palette notebook, \
",
  StyleBox["Background \[Rule] Automatic",
    FontFamily->"Courier"],
  " will use palette-style backgrounds."
}], "Notes",
  CellTags->"NotebookBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] You can select a custom color with the color dialog \
box that appears by clicking the square symbol to the right of the option. \
The color is specified as an ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " [",
  StyleBox["red",
    FontSlant->"Italic"],
  ", ",
  StyleBox["green",
    FontSlant->"Italic"],
  ", ",
  StyleBox["blue",
    FontSlant->"Italic"],
  "]. Color specifications using ",
  StyleBox["Hue",
    FontFamily->"Courier"],
  " are allowed, but these are automatically converted to ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " by the front end. "
}], "Notes",
  CellTags->"NotebookBackground"]
}, Closed]],

Cell[CellGroupData[{

Cell["Magnification", "ObjectName",
  CellTags->{"1.2.2.7.1", "1.2.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Magnification",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the scaling factor by which the notebook's appearance is \
magnified in the screen display."
}], "Usage",
  CellTags->{"1.2.2.7.2", "1.2.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Magnification",
    FontFamily->"Courier"],
  " can be set to any number. With the default setting ",
  StyleBox["Magnification \[Rule] 1",
    FontFamily->"Courier"],
  ", the notebook is displayed in its normal size.\n\[FilledSmallSquare] The \
magnification can also be set by clicking on the bar at the bottom of the \
window and choosing a value from the pop-up menu that appears. "
}], "Notes",
  CellTags->{"1.2.2.7.3", "1.2.2.7"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluation Options", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["Evaluator ", "ObjectName",
  CellTags->{"1.2.3.1.1", "1.2.3.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluator",
    FontFamily->"Courier"],
  " is an option for notebooks that determines which kernel commands are sent \
to for evaluation."
}], "Usage",
  CellTags->{"1.2.3.1.2", "1.2.3.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default value of this option for a given notebook \
is the same as the default kernel for the entire front end. For example, for \
a copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " running on a single machine, the default setting is ",
  StyleBox["Evaluator",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["Local",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] This option can be set by choosing from the list \
of currently defined kernels displayed next to the ",
  StyleBox["Kernel \[RightTriangle] Notebook's Kernel",
    FontFamily->"Helvetica"],
  " menu command. \n\[FilledSmallSquare] This option can be set for \
individual cells as well as for a notebook."
}], "Notes",
  CellTags->{"1.2.3.1.3", "1.2.3.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["EvaluationCompletionAction ", "ObjectName",
  CellTags->{"1.2.3.2.1", "1.2.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["EvaluationCompletionAction",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the action taken when an evaluation is completed. "
}], "Usage",
  CellTags->{"1.2.3.2.2", "1.2.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is a list with each element of the list \
representing an action. The default setting is ",
  StyleBox["EvaluationCompletionAction \[Rule] {}",
    FontFamily->"Courier"],
  ",  which means no action is taken. \n\[FilledSmallSquare] Other possible \
settings are: ",
  StyleBox["\"Beep\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"ShowTiming\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"AddTimeStamp\"",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.3.2.3", "1.2.3.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PrintAction ", "ObjectName",
  CellTags->{"1.2.3.3.1", "1.2.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PrintAction",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the action taken when a ",
  StyleBox["Print[]",
    FontFamily->"Courier"],
  " command is evaluated by the kernel."
}], "Usage",
  CellTags->{"1.2.3.3.2", "1.2.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is a list with each element of the list \
representing an action. The default setting is ",
  StyleBox["PrintAction \[Rule] \"PrintToNotebook\"",
    FontFamily->"Courier"],
  ",  which means no action is taken. \n\[FilledSmallSquare] Other possible \
settings are follows. \n",
  StyleBox["\"Beep\"\t\t        ",
    FontFamily->"Courier"],
  "A beep sound is made.",
  StyleBox["\n\"PrintToConsole\"    ",
    FontFamily->"Courier"],
  "The selected material is printed in the message window. \n",
  StyleBox["\"PrintToNotebook\"   ",
    FontFamily->"Courier"],
  "The selected material is printed in the notebook. ",
  StyleBox["\n\"SeparateCells\"     ",
    FontFamily->"Courier"],
  "The selected material is printed in a separate cell.",
  StyleBox["\n\"DialogBox\"         ",
    FontFamily->"Courier"],
  "A dialog box appears, containing data.    ",
  StyleBox["\t\t\t   ",
    FontFamily->"Courier"],
  "                                             "
}], "Notes",
  CellTags->{"1.2.3.3.3", "1.2.3.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["OutputAutoOverwrite ", "ObjectName",
  CellTags->{"1.2.3.4.1", "1.2.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["OutputAutoOverwrite",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " the output of a command should replace any existing output from a \
previous evaluation."
}], "Usage",
  CellTags->{"1.2.3.4.2", "1.2.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["OutputAutoOverwrite \[Rule] True",
    FontFamily->"Courier"],
  ", the output from a command overwrites any previously existing output. \
Only those output cells that have ",
  StyleBox["CellAutoOverwrite",
    FontFamily->"Courier"],
  " set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  " can be over-written.\n\[FilledSmallSquare] With the setting ",
  StyleBox["OutputAutoOverwrite \[Rule] False",
    FontFamily->"Courier"],
  ", output from each evaluation of a command is printed in the notebook. The \
output is printed directly after any previously generated output.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellAutoOverwrite",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.3.4.3", "1.2.3.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["InitializationCellEvaluation", "ObjectName",
  CellTags->{"1.2.3.5.1", "1.2.3.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InitializationCellEvaluation",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " initialization cells in a notebook are automatically evaluated when the \
notebook is opened."
}], "Usage",
  CellTags->{"1.2.3.5.2", "1.2.3.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["InitializationCellEvaluation \[Rule] True",
    FontFamily->"Courier"],
  ", the initialization cells are evaluated without any action by the user.",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] With the setting ",
  StyleBox["InitializationCellEvaluation \[Rule] Manual",
    FontFamily->"Courier"],
  ", the initialization cells are not evaluated when the notebook is \
opened.",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["InitializationCellEvaluation \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a dialog box appears when the notebook is opened, asking the user to \
specify ",
  "if",
  " initialization cells should be evaluated.\n\[FilledSmallSquare] See also: \
",
  StyleBox[ButtonBox["InitializationCell",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ",  ",
  StyleBox[ButtonBox["InitializationCellWarning",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.3.5.3", "1.2.3.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["InitializationCellWarning ", "ObjectName",
  CellTags->{"1.2.3.6.1", "1.2.3.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InitializationCellWarning",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a warning should be given when a notebook containing initialization cells \
is opened."
}], "Usage",
  CellTags->{"1.2.3.6.2", "1.2.3.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["InitializationCellWarning \[Rule] True",
    FontFamily->"Courier"],
  ", a warning in the form of a dialog box is given, asking the user to \
choose if the initialization cells should be automatically evaluated.\n\
\[FilledSmallSquare] In order for the warning ",
  StyleBox["not",
    FontSlant->"Italic"],
  " to occur, this option must be set to ",
  StyleBox["False",
    FontFamily->"Courier"],
  " both in the notebook being opened and at the global level.  This is a \
security feature to prevent a notebook from silently evaluating cells without \
the user's knowledge (unless the user has specifically enabled this by \
setting the option ",
  StyleBox["False",
    FontFamily->"Courier"],
  " at the global level).\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["InitializationCell",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ",  ",
  StyleBox[ButtonBox["InitializationCellEvaluation",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.3.6.3", "1.2.3.6"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Properties", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["Editable ", "ObjectName",
  CellTags->{"1.2.4.1.1", "1.2.4.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a notebook can be edited. "
}], "Usage",
  CellTags->{"1.2.4.1.2", "1.2.4.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["Editable \[Rule] False",
    FontFamily->"Courier"],
  ", the contents of a notebook are protected and cannot be edited in any \
way. ",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Editable \[Rule] True",
    FontFamily->"Courier"],
  ". ",
  StyleBox["\n", "MR",
    FontFamily->"Times"],
  "\[FilledSmallSquare] ",
  StyleBox["This option can also be set at the cell and selection levels.", 
    "MR",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"1.2.4.1.3", "1.2.4.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Selectable", "ObjectName",
  CellTags->{"1.2.4.2.1", "1.2.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Selectable",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " the contents of a notebook can be selected using the mouse or keyboard \
commands. "
}], "Usage",
  CellTags->{"1.2.4.2.2", "1.2.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Selection means highlighting something in the \
notebook window using the mouse or keyboard commands, or placing an insertion \
point in text or between cells.\n\[FilledSmallSquare] ",
  StyleBox["Selectable", "MR"],
  StyleBox[" only", "MR",
    FontFamily->"Times"],
  " affects the selection of the contents of a window. The notebook can still \
be selected by clicking its title bar. The related option, ",
  StyleBox["WindowClickSelect", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " affects selection of the window as a whole.\n\[FilledSmallSquare] The \
default setting is ",
  StyleBox["Selectable \[Rule] True",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] With the setting ",
  StyleBox["Selectable \[Rule] False",
    FontFamily->"Courier"],
  ", text and cells within a notebook cannot be selected.  \n\
\[FilledSmallSquare] If ",
  StyleBox["Selectable", "MR"],
  StyleBox[" \[Rule] ", "MR",
    FontFamily->"Times"],
  StyleBox["False", "MR"],
  StyleBox[" for a button, the button will not work even if it has ", "MR",
    FontFamily->"Times"],
  StyleBox["Active", "MR"],
  StyleBox[" \[Rule] ", "MR",
    FontFamily->"Times"],
  StyleBox["True", "MR"],
  StyleBox[".", "MR",
    FontFamily->"Times"],
  "\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["WindowClickSelect",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.4.2.3", "1.2.4.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Deletable ", "ObjectName",
  CellTags->{"1.2.4.3.1", "1.2.4.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Deletable",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " any of the contents of a notebook can be deleted."
}], "Usage",
  CellTags->{"1.2.4.3.2", "1.2.4.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["With the setting ", "MR",
    FontFamily->"Times"],
  StyleBox["Deletable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  StyleBox[", the contents of a notebook cannot be deleted.\n", "MR",
    FontFamily->"Times"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Deletable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True.", "MR"],
  StyleBox["\n", "MR",
    FontFamily->"Times"],
  "\[FilledSmallSquare] ",
  StyleBox["This option can also be set at the cell and selection levels.", 
    "MR",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"1.2.4.3.3", "1.2.4.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellGrouping", "ObjectName",
  CellTags->{"1.2.4.4.1", "1.2.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellGrouping", "MR"],
  " ",
  "is an option for notebooks",
  " that determines how cells in a notebook should be assembled into groups. \
"
}], "Usage",
  CellTags->{"1.2.4.4.2", "1.2.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["CellGrouping", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  ", cells are automatically grouped in a hierarchical way based on their \
styles. The hierarchical ordering is specified in the style sheet using the \
option ",
  StyleBox["CellGroupingRules.",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] With ",
  StyleBox["CellGrouping", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Manual", "MR"],
  ", cells must be grouped manually, either by setting up explicit ",
  StyleBox["CellGroupData", "MR"],
  " expressions or by using the ",
  StyleBox["Cell \[RightTriangle] CellGrouping \[RightTriangle] Group Cells",
    FontFamily->"Helvetica"],
  " menu command in the front end. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.2",
    ButtonData:>{"2.11.2", "2.7"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.6"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellGroupData",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.4.4.3", "1.2.4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PageWidth", "ObjectName",
  CellTags->{"1.2.4.5.1", "1.2.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageWidth", "MR"],
  " is an option for notebooks that determines how wide a page is assumed to \
be when output is displayed."
}], "Usage",
  CellTags->{"1.2.4.5.2", "1.2.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["PageWidth \[Rule] WindowWidth",
    FontFamily->"Courier"],
  ", each line can extend up to the full width of the window, taking into \
account the settings for cell margins.\n\[FilledSmallSquare] Other possible \
settings for ",
  StyleBox["PageWidth",
    FontFamily->"Courier"],
  " are as follows.\n    ",
  StyleBox["Infinity",
    FontFamily->"Courier"],
  "                     an infinite width (no line breaks)\n     ",
  StyleBox["n",
    FontSlant->"Italic"],
  "                                     explicit width given in printer's \
points\n     ",
  StyleBox["PaperWidth",
    FontFamily->"Courier"],
  "               the width of the page as it would be printed\n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.12.3",
    ButtonData:>{"2.12.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TotalWidth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AutoIndent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.4.5.3", "1.2.4.5"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Window Properties", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["WindowSize", "ObjectName",
  CellTags->{"1.2.5.1.1", "1.2.5.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowSize", "MR"],
  " ",
  "is an option for notebooks",
  " that determines the size of the window in which the notebook is \
displayed. "
}], "Usage",
  CellTags->{"1.2.5.1.2", "1.2.5.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowSize", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula",
    FormatType->StandardForm],
  StyleBox["w", "TIE",
    FontSlant->"Italic"],
  StyleBox[",", "MRE"],
  " ",
  StyleBox["h", "TIE",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FormatType->StandardForm],
  " gives the width and height of the window in printer's points, where 72 \
points equal one inch. \n\[FilledSmallSquare] Setting either the width or \
height to ",
  StyleBox["Automatic", "MR\[ODoubleDot]",
    FontFamily->"Courier"],
  " causes the size of the window to be determined from the setting for ",
  StyleBox["WindowMargins", "MR\[ODoubleDot]",
    FontFamily->"Courier"],
  " and the size of your screen. \n\[FilledSmallSquare] The setting for ",
  StyleBox["WindowSize", "MR\[ODoubleDot]",
    FontFamily->"Courier"],
  " changes whenever you resize a window interactively in the front end. \n\
\[FilledSmallSquare] On most computer systems, the front end does not allow \
window sizes below a certain minimum value. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.2",
    ButtonData:>{"2.11.2", "2.7"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.13"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["WindowMargins",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.5.1.3", "1.2.5.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["WindowMargins", "ObjectName",
  CellTags->{"1.2.5.2.1", "1.2.5.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowMargins", "MR"],
  " is an option for notebooks that determines the size of margins around the \
notebook window."
}], "Usage",
  CellTags->{"1.2.5.2.2", "1.2.5.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowMargins", "MR"],
  StyleBox[" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FormatType->StandardForm],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["bottom", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["top", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FormatType->StandardForm],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FormatType->StandardForm],
  " determines the distances from each edge of your screen to each edge of \
the window. \n\[FilledSmallSquare] The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. \n\
\[FilledSmallSquare] Negative values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  ", ",
  StyleBox["right",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bottom",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["top",
    FontSlant->"Italic"],
  " represent edges that are off the screen. \n\[FilledSmallSquare] Typically \
only two distances are given explicitly; the others are ",
  StyleBox["Automatic", "MR"],
  ", indicating that they should be determined from the size of the window. \
The settings for ",
  StyleBox["WindowMargins", "MR"],
  " change automatically whenever you move a window around interactively \
using the front end. The window edges closer to the edges of the screen are \
typically assigned explicit margin distances; the other edges are set to ",
  StyleBox["Automatic", "MR"],
  ". This allows the same setting for ",
  StyleBox["WindowMargins", "MR"],
  " to work on screens of different sizes. \n\[FilledSmallSquare] With ",
  StyleBox["WindowSize", "MR"],
  " \[Rule] ",
  StyleBox["{Automatic,", "MR"],
  " ",
  StyleBox["Automatic}", "MR"],
  " all four margin distances must be given explicitly. \n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["WindowMargins", "MR"],
  " \[Rule] ",
  StyleBox["Automatic", "MR"],
  ", new windows are placed on your screen in such a way as to make visible \
as many window title bars as possible. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.13"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["WindowSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowMovable",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.5.2.3", "1.2.5.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["WindowFrame", "ObjectName",
  CellTags->{"1.2.5.3.1", "1.2.5.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowFrame", "MR"],
  " ",
  "is an option for notebooks",
  " that determines the type of frame to draw around the notebook window. "
}], "Usage",
  CellTags->{"1.2.5.3.2", "1.2.5.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows. \n",
  Cell[BoxData[
      FormBox[GridBox[{
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Frameless\\\\\
\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"an ordinary window with \
no frame and no title\:f39fbar\"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Generic\\\\\\\
\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"a window with a generic \
border (independent of any window system)\"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"ModalDialog\\\
\\\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"a modal dialog box \
window \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\
ModelessDialog\\\\\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"a \
modeless dialog box window \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\
MovableModalDialog\\\\\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"a \
movable modal dialog box window \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Normal\\\\\\\\\
\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"an ordinary window \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Palette\\\\\\\
\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"a palette window \"\>"},
            {
              
              RowBox[{"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\
ThinFrame\\\\\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
                "\[IndentingNewLine]"}], \("a window with a \
single\[Hyphen]pixel border and no title bar\[IndentingNewLine]"\)}
            },
          ColumnAlignments->{Left}], TextForm]], "Notes",
    FormatType->StandardForm,
    CellTags->{"1.2.5.3.4", "1.2.5.3"}]
}], "Notes",
  CellTags->{"1.2.5.3.3", "1.2.5.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] The details of how particular types of frames are \
rendered may differ from one computer system to another. \n\
\[FilledSmallSquare] Settings for ",
  StyleBox["WindowFrame", "MR"],
  " affect only the appearance of a window and not any of its other \
characteristics. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.13"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] ",
  "See also: ",
  ButtonBox["WindowTitle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowElements",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowToolbars",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.5.3.5", "1.2.5.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["WindowElements", "ObjectName",
  CellTags->{"1.2.5.4.1", "1.2.5.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowElements", "MR"],
  " ",
  "is an option for notebooks",
  " that determines the elements included in the notebook window. "
}], "Usage",
  CellTags->{"1.2.5.4.2", "1.2.5.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowElements", "MR"],
  " is typically set to a list containing elements such as ",
  StyleBox["\"HorizontalScrollBar\"", "MR"],
  ", ",
  StyleBox["\"MagnificationPopUp\"", "MR"],
  ", ",
  StyleBox["\"StatusArea\"", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " and, ",
  StyleBox["\"VerticalScrollBar\"", "MR"],
  ". \n\[FilledSmallSquare] Some elements may exist only under certain \
operating systems. One example is \"MenuBar\" (found only under X).\n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.13"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["WindowToolbars",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowTitle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowFrame",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.5.4.3", "1.2.5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["WindowFrameElements ", "ObjectName",
  CellTags->{"1.2.5.5.1", "1.2.5.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowFrameElements",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the elements included in the frame of the notebook \
window. "
}], "Usage",
  CellTags->{"1.2.5.5.2", "1.2.5.5"}],

Cell[TextData[{
  " \[FilledSmallSquare] ",
  StyleBox["WindowFrameElements", "MR"],
  " is specified as a list with elements such as ",
  StyleBox["\"CloseBox\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"ZoomBox\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"ResizeArea\"",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] Some details of the window frame are determined by \
the operating system. For example, the window frame may always contain a \
Close Box regardless of the setting for this option."
}], "Notes",
  CellTags->{"1.2.5.5.3", "1.2.5.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["WindowClickSelect", "ObjectName",
  CellTags->{"1.2.5.6.1", "1.2.5.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowClickSelect", "MR"],
  " is an option for notebooks that determines ",
  "if",
  " the window for the notebook should become selected if you click it. "
}], "Usage",
  CellTags->{"1.2.5.6.2", "1.2.5.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["WindowClickSelect", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  ", clicking anywhere in the window for a notebook makes that notebook the \
currently selected one. \n\[FilledSmallSquare]  With the setting ",
  StyleBox["WindowClickSelect", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  StyleBox[", a notebook does not become selected when you click in the \
content area of the window. ", "MR",
    FontFamily->"Times"],
  "This property is often used in palettes so that clicking a button in the \
palette does not change the currently selected notebook. Clicking on the \
title bar or window frame will still cause the window to become selected.\n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.13"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["WindowFloating",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SetSelectedNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.5.6.3", "1.2.5.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["WindowFloating", "ObjectName",
  CellTags->{"1.2.5.7.1", "1.2.5.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowFloating", "MR"],
  " is an option for notebooks that determines ",
  "if",
  " the window for the notebook should float on top of other windows when it \
is displayed. "
}], "Usage",
  CellTags->{"1.2.5.7.2", "1.2.5.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowFloating", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  " is often used for palettes. \n\[FilledSmallSquare] If there are several \
floating windows, the most recently selected one goes on top. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.2",
    ButtonData:>{"2.11.2", "2.7"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.13"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["WindowClickSelect",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Visible",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.5.7.3", "1.2.5.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["WindowMovable", "ObjectName",
  CellTags->{"1.2.5.8.1", "1.2.5.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowMovable", "MR"],
  " is an option for notebooks that determines if the window for the notebook \
can be moved around on the screen. "
}], "Usage",
  CellTags->{"1.2.5.8.2", "1.2.5.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowMovable", "MR"],
  " affects only interactive operations in the front end. \n\
\[FilledSmallSquare] Even with ",
  StyleBox["WindowMovable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  ", the ",
  StyleBox["WindowMargins", "MR"],
  " option can still be reset from the kernel or the Option Inspector. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.13"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["WindowMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Selectable",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.5.8.3", "1.2.5.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["WindowTitle", "ObjectName",
  CellTags->{"1.2.5.9.1", "1.2.5.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowTitle", "MR"],
  " ",
  "is an option for notebooks",
  " that determines the title of the window used to display the notebook. "
}], "Usage",
  CellTags->{"1.2.5.9.2", "1.2.5.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WindowTitle", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  " sets the title to the name of the notebook file.\n\[FilledSmallSquare] ",
  StyleBox["WindowTitle", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["None", "MR"],
  " displays no title. \n\[FilledSmallSquare] The title for the window does \
not have to be connected with the name of the notebook file.\n\
\[FilledSmallSquare] Not all settings for ",
  StyleBox["WindowFrame", "MR"],
  " leave room for a title to be displayed. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.13"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["WindowElements",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"1.2.5.9.3", "1.2.5.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Visible ", "ObjectName",
  CellTags->{"1.2.5.10.1", "1.2.5.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Visible",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a notebook is visible on the screen when it is open. "
}], "Usage",
  CellTags->{"1.2.5.10.2", "1.2.5.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["Visible \[Rule] False",
    FontFamily->"Courier"],
  ", the window representing the notebook becomes invisible."
}], "Notes",
  CellTags->{"1.2.5.10.3", "1.2.5.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ScrollingOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.2.5.12.1", "1.2.5.12"}],

Cell[CellGroupData[{

Cell["\"PagewiseScrolling\" ", "SubObjectNameClosed",
  CellTags->{"1.2.5.12.1.1", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PagewiseScrolling\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a notebook scrolls in steps of one page when the scroll bar is clicked."
}], "Usage",
  CellTags->{"1.2.5.12.1.2", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] A page is defined as the part of a notebook between \
two successive page breaks. \n\[FilledSmallSquare] With the setting ",
  StyleBox["\"PagewiseScrolling\" \[Rule] True",
    FontFamily->"Courier"],
  ", each click in the scroll bar causes the notebook to scroll up or down to \
the next page break. \n\[FilledSmallSquare] The default setting is ",
  StyleBox["\"PagewiseScrolling\" \[Rule] False",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.2.5.12.1.3", "1.2.5.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PagewiseDisplay\" ", "SubObjectNameClosed",
  CellTags->{"1.2.5.12.2.1", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PagewiseDisplay\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " the screen display is limited to a single page."
}], "Usage",
  CellTags->{"1.2.5.12.2.2", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] A page is defined as the part of a notebook between \
two successive page breaks. With the setting ",
  StyleBox["\"PagewiseDisplay\" \[Rule] True",
    FontFamily->"Courier"],
  ", only a single page is displayed on the screen at a time. If there is any \
additional space in the notebook window, it is left blank. If the scroll bar \
is clicked, the contents of the next page are displayed on the screen. \n\
\[FilledSmallSquare] The default setting is ",
  StyleBox["\"PagewiseDisplay\" \[Rule] False.",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.5.12.2.3", "1.2.5.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RealTimeScrolling\" ", "SubObjectNameClosed",
  CellTags->{"1.2.5.12.3.1", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RealTimeScrolling\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a notebook scrolls in real time when you slide the scroll tab along the \
scroll bar."
}], "Usage",
  CellTags->{"1.2.5.12.3.2", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"RealTimeScrolling\" \[Rule] True",
    FontFamily->"Courier"],
  ", the contents of the notebook scroll in real time as the scroll tab is \
dragged up or down. ",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"RealTimeScrolling\" \[Rule] False",
    FontFamily->"Courier"],
  ", the notebook does not scroll while the scroll tab is being dragged. When \
the scroll tab is released, the notebook jumps by an amount proportional to \
the distance that the scroll tab has moved."
}], "Notes",
  CellTags->{"1.2.5.12.3.3", "1.2.5.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"JumpScrolling\" ", "SubObjectNameClosed",
  CellTags->{"1.2.5.12.4.1", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"JumpScrolling\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " clicking at a point on the scroll bar causes the scroll tab to jump to \
that point."
}], "Usage",
  CellTags->{"1.2.5.12.4.2", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"JumpScrolling\" \[Rule] False",
    FontFamily->"Courier"],
  ", clicking at any point on the scroll bar causes the notebook to scroll up \
or down by a fixed amount.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"JumpScrolling\" \[Rule] True",
    FontFamily->"Courier"],
  ", each time the scroll bar is clicked, the scroll tab jumps to the \
position of the pointer and the notebook scrolls by the corresponding \
amount."
}], "Notes",
  CellTags->{"1.2.5.12.4.3", "1.2.5.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"VerticalScrollRange\" ", "SubObjectNameClosed",
  CellTags->"1.2.5.12"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"VerticalScrollRange\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the maximum distance that the \
notebook can be scrolled vertically. "
}], "Usage",
  CellTags->"1.2.5.12"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"VerticalScrollRange\" \[Rule] Automatic",
    FontFamily->"Courier"],
  StyleBox[", the vertical scroll range is proportional to the window \
height.",
    FontFamily->"Times New Roman"]
}], "Notes",
  CellTags->"1.2.5.12"],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["\"VerticalScrollRange\" \[Rule] Fit",
    FontFamily->"Courier"],
  StyleBox["  or ",
    FontFamily->"Times New Roman"],
  StyleBox["\"VerticalScrollRange\" \[Rule] FitAll",
    FontFamily->"Courier"],
  StyleBox[", the vertical scroll range is set to the exact height of the \
notebook.",
    FontFamily->"Times New Roman"]
}], "Notes",
  CellTags->"1.2.5.12"],

Cell[TextData[{
  "\[FilledSmallSquare]  You can also specify ",
  StyleBox["\"VerticalScrollRange\"",
    FontFamily->"Courier"],
  " in points, where 72 points equal one inch. "
}], "Notes",
  CellTags->"1.2.5.12"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"HorizontalScrollRange\" ", "SubObjectNameClosed",
  CellTags->{"1.2.5.12.5.1", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"HorizontalScrollRange\"",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the maximum distance that the notebook can be scrolled \
horizontally. "
}], "Usage",
  CellTags->{"1.2.5.12.5.2", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is specified in points (where 72 points \
equal one inch). The default setting is usually ",
  StyleBox["\"HorizontalScrollRange\" \[Rule] 3024.",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.5.12.5.3", "1.2.5.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SpeedParameters\"", "SubObjectNameClosed",
  CellTags->{"1.2.5.12.6.1", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"SpeedParameters\"",
    FontFamily->"Courier"],
  " is an option for notebooks that controls the speed at which scrolling \
takes place during click-and-drag selection operations."
}], "Usage",
  CellTags->{"1.2.5.12.6.2", "1.2.5.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] The value of this option is a list of four \
parameters. The first parameter sets the maximum scrolling speed in number of \
pages per second. The second parameter controls how the scrolling speed \
responds to the distance that the mouse pointer has been dragged outside the \
window. The third parameter controls how quickly the scrolling speed \
approaches the maximum speed. The fourth parameter sets the maximum time in \
seconds for which scrolling can be interrupted when waiting for cells to be \
rendered.\n\[FilledSmallSquare]  The default setting is ",
  StyleBox["\"SpeedParameters\" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["{2, 0.1, 1, 0.4}",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.5.12.6.3", "1.2.5.12"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Printing Options", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["PrintingCopies ", "ObjectName",
  CellTags->{"1.2.6.1.1", "1.2.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PrintingCopies",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the number of copies of a notebook printed when a print \
command is given."
}], "Usage",
  CellTags->{"1.2.6.1.2", "1.2.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["PrintingCopies \[Rule] 1.\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] For Macintosh and Windows, this option is typically \
set at the level of the operating system and cannot be specified from within \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{"1.2.6.1.3", "1.2.6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PrintingStartingPageNumber ", "ObjectName",
  CellTags->{"1.2.6.2.1", "1.2.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PrintingStartingPageNumber",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines what number to assign to the first page of a notebook \
when printed."
}], "Usage",
  CellTags->{"1.2.6.2.2", "1.2.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["PrintingStartingPageNumber \[Rule] 1.",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.6.2.3", "1.2.6.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PrintingPageRange ", "ObjectName",
  CellTags->{"1.2.6.3.1", "1.2.6.3", "PrintingPageRange"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PrintingPageRange",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the range of pages of a \
notebook to be printed."
}], "Usage",
  CellTags->{"1.2.6.3.2", "1.2.6.3", "PrintingPageRange"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PrintingPageRange",
    FontFamily->"Courier"],
  " is specified as a list, ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  ", where ",
  StyleBox["a",
    FontSlant->"Italic"],
  " and ",
  StyleBox["b",
    FontSlant->"Italic"],
  " are the numbers of the first and last pages to be printed. \n\
\[FilledSmallSquare] For Macintosh, this option is typically set at the level \
of the operating system and cannot be specified from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{"1.2.6.3.3", "1.2.6.3", "PrintingPageRange"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PageHeaders", "ObjectName",
  CellTags->{"1.2.6.6.1", "1.2.6.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageHeaders",
    FontFamily->"Courier"],
  " is an option for notebooks that determines which text will be inserted at \
the head of each page of a notebook when it is printed."
}], "Usage",
  CellTags->{"1.2.6.6.2", "1.2.6.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageHeaders",
    FontFamily->"Courier"],
  " is specified in the form of a compound list, ",
  StyleBox["{{",
    FontFamily->"Courier"],
  StyleBox["ll",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["lc",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["lr",
    FontSlant->"Italic"],
  StyleBox["},{",
    FontFamily->"Courier"],
  StyleBox["rl",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["rc",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["rr",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  " where ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["ll",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["lc",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["lr",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " specifies the left, center, and right headers for the left pages and ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["rl",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["rc",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["rr",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " specifies the left, center, and right headers for the right pages.\n\
\[FilledSmallSquare]  The default settings for the left hand page are as \
follows. \n    The left header is set to ",
  StyleBox["ll ",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] Cell[TextData[{CounterBox[\"Page\"]}]",
    FontFamily->"Courier"],
  ",",
  StyleBox["\"PageNumber\"]",
    FontFamily->"Courier"],
  ". This defines a counter that inserts the page number at the left edge of \
the page.\n    The center header is set to",
  StyleBox[" lc",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] None",
    FontFamily->"Courier"],
  ".",
  StyleBox["\t\n ",
    FontFamily->"Courier"],
  " The right header is set to ",
  StyleBox["lr",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] Cell[TextData[{ValueBox[\"FileName\"]}],\"Header\"]",
    FontFamily->"Courier"],
  ". This prints the file name on the right edge of the page.",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare]  The default settings for the right hand page are as \
follows.\n    The left header is set to ",
  StyleBox[" rl",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] Cell[TextData[{ValueBox[\"FileName\"]}],\"Header\"]",
    FontFamily->"Courier"],
  ". This adds the file name to the left edge of the page.)\n   The center \
header is set to",
  StyleBox[" rc",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] None",
    FontFamily->"Courier"],
  ".",
  StyleBox["\n ",
    FontFamily->"Courier"],
  " The right header is set to",
  StyleBox[" rr",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] Cell[TextData[{CounterBox[\"Page\"]}],\"PageNumber]",
    FontFamily->"Courier"],
  ". This defines a counter that inserts the page number at the right edge of \
the page.\n  \[FilledSmallSquare]  Headers can also be specified using the \
dialog box accessed from the ",
  StyleBox["File \[RightTriangle] Printing Settings \[RightTriangle] Headers \
and Footers...",
    FontFamily->"Helvetica"],
  " menu item."
}], "Notes",
  CellTags->{"1.2.6.6.3", "1.2.6.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PageFooters", "ObjectName",
  CellTags->{"1.2.6.7.1", "1.2.6.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageFooters",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the text to be inserted at the bottom of a page when it \
is printed."
}], "Usage",
  CellTags->{"1.2.6.7.2", "1.2.6.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is specified in the form of a compound \
list, ",
  StyleBox["PageFooters \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["ll",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["lc",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["lr",
    FontSlant->"Italic"],
  StyleBox["},{",
    FontFamily->"Courier"],
  StyleBox["rl",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["rc",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["rr",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  " where ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["ll",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["lc",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["lr",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " specifies the left, center, and right footers respectively for the left \
pages and ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["rl",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["rc",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["rr",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " specifies the left, center, and right footers respectively for the right \
pages.\n\[FilledSmallSquare]  Setting any of these items to a string causes a \
line of text to be added as a footer. The default setting for all six items \
is ",
  StyleBox["None",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] To add the page number at the bottom of each \
page, set any of the footer items to ",
  StyleBox["Cell[TextData[{CounterBox[\"Page\"]}],\"PageNumber\"]\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] To add the file name at the bottom of each page, set \
any of the footer items to ",
  StyleBox["Cell[TextData[{ValueBox[\"FileName\"]}],\"Footer\"]",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] Footers can also be specified using the dialog box \
accessed from the ",
  StyleBox["File \[RightTriangle] Printing Settings \[RightTriangle] Headers \
and Footers...",
    FontFamily->"Helvetica"],
  " menu item."
}], "Notes",
  CellTags->{"1.2.6.7.3", "1.2.6.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PageHeaderLines ", "ObjectName",
  CellTags->{"1.2.6.8.1", "1.2.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageHeaderLines",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a horizontal line is inserted at the top of each page when the notebook \
is printed."
}], "Usage",
  CellTags->{"1.2.6.8.2", "1.2.6.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageHeaderLines",
    FontFamily->"Courier"],
  " is specified as a list of two elements, one each for the left and right \
pages. With the default setting ",
  StyleBox["PageHeaderLines \[Rule] {True,True}",
    FontFamily->"Courier"],
  ", both left and right pages are printed with a horizontal line on top, \
below the page header."
}], "Notes",
  CellTags->{"1.2.6.8.3", "1.2.6.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PageFooterLines ", "ObjectName",
  CellTags->{"1.2.6.9.1", "1.2.6.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageFooterLines",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a horizontal line is inserted at the bottom of each page when the \
notebook is printed."
}], "Usage",
  CellTags->{"1.2.6.9.2", "1.2.6.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageFooterLines",
    FontFamily->"Courier"],
  " is specified as a list of two elements, one each for the left and right \
pages. With the default setting ",
  StyleBox["PageFooterLines \[Rule] {False,False}",
    FontFamily->"Courier"],
  ", both left and right pages are printed without a horizontal line at the \
bottom, above the page footer."
}], "Notes",
  CellTags->{"1.2.6.9.3", "1.2.6.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Printing Options\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"1.2.6.13.1", "1.2.6.13"}],

Cell[CellGroupData[{

Cell["\"PaperOrientation\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.1.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PaperOrientation\"",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the orientation of the paper assumed when preparing a \
notebook for printing."
}], "Usage",
  CellTags->{"1.2.6.13.1.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"PaperOrientation\" \[Rule] \"Portrait\"",
    FontFamily->"Courier"],
  ", the paper is assumed to be oriented vertically.\n\[FilledSmallSquare] \
With the setting ",
  StyleBox["\"PaperOrientation\" \[Rule] \"Landscape\"",
    FontFamily->"Courier"],
  ", the paper is assumed to be oriented horizontally.\n\[FilledSmallSquare] \
This option can also be set using the dialog box accessed from the ",
  StyleBox["File \[RightTriangle] Printing Settings \[RightTriangle] Page \
Setup...",
    FontFamily->"Helvetica"],
  " menu item."
}], "Notes",
  CellTags->{"1.2.6.13.1.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PrintCellBrackets\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.2.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PrintCellBrackets\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " cell brackets are included when a notebook is printed."
}], "Usage",
  CellTags->{"1.2.6.13.2.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"PrintCellBrackets\" \[Rule] False",
    FontFamily->"Courier"],
  ", cell brackets in a notebook are not printed even if they are visible on \
screen.\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["ShowCellBracket",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.6.13.2.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PrintSelectionHighlighting\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.3.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PrintSelectionHighlighting\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines if elements of a notebook that \
are selected are highlighted when printed."
}], "Usage",
  CellTags->{"1.2.6.13.3.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"PrintSelectionHighlighting\" \[Rule] False",
    FontFamily->"Courier"],
  ", selected elements of a notebook do not appear highlighted in print."
}], "Notes",
  CellTags->{"1.2.6.13.3.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PrintRegistrationMarks\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.4.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PrintRegistrationMarks\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " trim marks indicating the corners of a page are added when a notebook is \
printed. "
}], "Usage",
  CellTags->{"1.2.6.13.4.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " you can simulate how a notebook would look when printed on paper of a \
particular size, by adjusting the option ",
  StyleBox["\"PageSize\"",
    FontFamily->"Courier"],
  ". With the default setting ",
  StyleBox["\"PrintRegistrationMarks\" \[Rule] True",
    FontFamily->"Courier"],
  ", trim marks are printed at the corners of the simulated page, thus making \
the boundaries of the page easier to visualize.\n\[FilledSmallSquare] With \
the setting ",
  StyleBox["\"PrintRegistrationMarks\" \[Rule] False",
    FontFamily->"Courier"],
  ", no trim marks are printed. "
}], "Notes",
  CellTags->{"1.2.6.13.4.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PrintMultipleHorizontalPages\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.5.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PrintMultipleHorizontalPages\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " the contents of a notebook that extend beyond the width of the page are \
to be printed."
}], "Usage",
  CellTags->{"1.2.6.13.5.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"PrintMultipleHorizontalPages\" \[Rule] False",
    FontFamily->"Courier"],
  ", text that extends beyond the width of a page is not printed. The extra \
text is cut off when the paper width is reached.\n\[FilledSmallSquare] With \
the setting ",
  StyleBox["\"PrintMultipleHorizontalPages\" \[Rule] True",
    FontFamily->"Courier"],
  ", any text that extends beyond the width of a regular page is printed on a \
separate page. As many supplementary pages are printed as are necessary to \
contain the entire additional text. The extra pages have decimal page \
numbers, ",
  "e.g. ",
  "1.1, 1.2, 1.3... etc."
}], "Notes",
  CellTags->{"1.2.6.13.5.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FirstPageHeader\"", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.6.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FirstPageHeader\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a header is added to the first page of a notebook when headers are \
printed on all other pages."
}], "Usage",
  CellTags->{"1.2.6.13.6.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"FirstPageHeader\" \[Rule] False",
    FontFamily->"Courier"],
  ", the first page is printed without a header even if headers have been \
specified for all other pages.\n\[FilledSmallSquare] The default setting is \
",
  StyleBox["\"FirstPageHeader\" \[Rule] True",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] This option can also be specified using the \
dialog box accessed from the ",
  StyleBox["File \[RightTriangle] Printing Settings \[RightTriangle] Headers \
and Footers...",
    FontFamily->"Helvetica"],
  " menu item.\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["PageHeaders",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.6.13.6.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FirstPageFooter\"", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.7.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FirstPageFooter\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a footer is added to the first page of a notebook when footers are \
printed on all other pages."
}], "Usage",
  CellTags->{"1.2.6.13.7.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"FirstPageFooter\" \[Rule] False",
    FontFamily->"Courier"],
  ", the first page is printed without a footer even if footers are specified \
for all other pages of the notebook.\n\[FilledSmallSquare] The default \
setting is ",
  StyleBox["\"FirstPageFooter\" \[Rule] True",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] This option can also be specified using the \
dialog box accessed from the ",
  StyleBox["File \[RightTriangle] Printing Settings \[RightTriangle] Headers \
and Footers...",
    FontFamily->"Helvetica"],
  " menu item.\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["PageFooters",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.6.13.7.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RestPagesHeader\"", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.6.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RestPagesHeader\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a header is added to all pages of a notebook after the first page."
}], "Usage",
  CellTags->{"1.2.6.13.6.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"RestPagesHeader\" \[Rule] False",
    FontFamily->"Courier"],
  ", no headers are printed from the second page onwards. This option \
complements the option \"",
  StyleBox["FirstPageHeader\"",
    FontFamily->"Courier"],
  ", which determines if headers are printed on the first page.\n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["\"RestPagesHeader\" \[Rule] True",
    FontFamily->"Courier"],
  ", headers are printed from the second page onwards. The content of the \
headers is determined by the setting for the option, ",
  StyleBox["PageHeaders",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["PageHeaders",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.6.13.6.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RestPagesFooter\"", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.7.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RestPagesFooter\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a footer is added to all pages of a notebook after the first page.  "
}], "Usage",
  CellTags->{"1.2.6.13.7.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"RestPagesFooter\" \[Rule] False",
    FontFamily->"Courier"],
  ", no footers are printed from the second page onwards. This option \
complements the option \"",
  StyleBox["FirstPageHeader\"",
    FontFamily->"Courier"],
  ", which determines if headers are printed on the first page.",
  "\n",
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"RestPagesFooter\" \[Rule] True",
    FontFamily->"Courier"],
  ", footers are printed from the second page onwards. The content of the \
footers is determined by the setting for the option, ",
  StyleBox["PageFooters",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["PageFooters",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.6.13.7.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FacingPages\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.8.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FacingPages\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " headers and footers are to be specified separately for left and right \
facing pages."
}], "Usage",
  CellTags->{"1.2.6.13.8.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"FacingPages\" \[Rule] True",
    FontFamily->"Courier"],
  ",  headers and footers for left pages can be different from those for \
right pages. Both kinds of headers and footers must be specified separately \
in the ",
  StyleBox["File \[RightTriangle] PrintingSettings \[RightTriangle] Headers \
and Footers...",
    FontFamily->"Helvetica"],
  " dialog box.\n\[FilledSmallSquare] With the default setting ",
  StyleBox["\"FacingPages\" \[Rule] False",
    FontFamily->"Courier"],
  ", the headers and footers for left pages are the same as for right pages."
}], "Notes",
  CellTags->{"1.2.6.13.8.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FirstPageFace\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.9.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"FirstPageFace\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " the first page of a notebook should face left or right when printed."
}], "Usage",
  CellTags->{"1.2.6.13.9.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"FirstPageFace\" \[Rule] Right",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.6.13.9.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"GraphicsPrintingFormat\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"GraphicsPrintingFormat\"",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the format in which graphics are to be printed."
}], "Usage",
  CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"GraphicsPrintingFormat\" \[Rule] \"Automatic\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] Other possible settings are ",
  StyleBox["\"DownloadPostScript\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"RenderInFrontEnd\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"Bitmap\"",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.2.6.13.10.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeSpecialFonts\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"IncludeSpecialFonts\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts should be included when a file is sent to be printed. "
}], "Usage",
  CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"IncludeSpecialFonts\" \[Rule] \"True\"",
    FontFamily->"Courier"],
  ", the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts are included with the print output. \n\[FilledSmallSquare] You can \
force the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fonts to be excluded from the print output by setting ",
  StyleBox["\"IncludeSpecialFonts\" \[Rule] \"False\"",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] This option is typically set from the Print dialog \
box."
}], "Notes",
  CellTags->{"1.2.6.13.10.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludePostScriptResourceDirectives\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"IncludePostScriptResourceDirectives\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " PostScript resource comments are included when sending a file to be \
printed."
}], "Usage",
  CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"IncludePostScriptResourceDirectives\" \[Rule] \"True\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] This option is typically set from the Print \
dialog box."
}], "Notes",
  CellTags->{"1.2.6.13.10.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PostScriptOutputFile\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PostScriptOutputFile\"",
    FontFamily->"Courier"],
  " is an option for notebooks that specifies a file name under which to save \
the PostScript output is generated when a Print command is given."
}], "Usage",
  CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"PostScriptOutputFile\" \[Rule] \"Automatic\"",
    FontFamily->"Courier"],
  ", the file name is the same as that of the notebook being printed, with \
the suffix .nb replaced by .ps. \n\[FilledSmallSquare] This option is \
relevant only when the option ",
  StyleBox["\"UsePostScriptOutputFile\"",
    FontFamily->"Courier"],
  " is set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", that is when the PostScript output is saved as a file. Whether the \
output is sent to a printer or not, depends on the setting for \"",
  StyleBox["UseUnixShellPrintingCommand\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] This option is typically set from the Print \
dialog box."
}], "Notes",
  CellTags->{"1.2.6.13.10.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"UsePostScriptOutputFile\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"UsePostScriptOutputFile\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a notebook should be saved as a PostScript file, instead of being sent to \
the printer."
}], "Usage",
  CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"UsePostScriptOutputFile\" \[Rule] \"False\"",
    FontFamily->"Courier"],
  ", the output generated by a Print command is not saved as a PostScript \
file. Whether the output is sent to a printer or not, depends on the setting \
for \"",
  StyleBox["UseUnixShellPrintingCommand\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] With the setting ",
  StyleBox["\"UsePostScriptOutputFile\" \[Rule] \"True\"",
    FontFamily->"Courier"],
  ", the output generated by a Print command is saved as a PostScript file. \n\
\[FilledSmallSquare] This option is typically set from the Print dialog box."
}], "Notes",
  CellTags->{"1.2.6.13.10.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"UnixShellPrintingCommand\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"UnixShellPrintingCommand\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the command executed on the \
system, when printing a notebook to a printer.  "
}], "Usage",
  CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"UnixShellPrintingCommand\" \[Rule] \"Automatic\"",
    FontFamily->"Courier"],
  ". Any other Unix system command can be specified by typing a string into \
the text box next to the option.\n\[FilledSmallSquare] This option is \
relevant only when the option ",
  StyleBox["\"UseUnixShellPrintingCommand\"",
    FontFamily->"Courier"],
  " is set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] This option is typically set from the Print \
dialog box."
}], "Notes",
  CellTags->{"1.2.6.13.10.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"UseUnixShellPrintingCommand\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"UseUnixShellPrintingCommand\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " the system command for printing should be executed, when a notebook is \
printed."
}], "Usage",
  CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"UseUnixShellPrintingCommand\" \[Rule] \"False\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] This option is typically set from the Print \
dialog box."
}], "Notes",
  CellTags->{"1.2.6.13.10.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Magnification\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.11.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Magnification\"",
    FontFamily->"Courier"],
  " ",
  "is an option for notebooks",
  " that determines the scaling factor by which each page is magnified when a \
notebook is printed."
}], "Usage",
  CellTags->{"1.2.6.13.11.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Magnification\"",
    FontFamily->"Courier"],
  " is specified as a number. The default setting ",
  StyleBox["\"Magnification\" \[Rule] 1",
    FontFamily->"Courier"],
  " corresponds to the page being printed in its original size."
}], "Notes",
  CellTags->{"1.2.6.13.11.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["\"",
    FontFamily->"Courier"],
  "CellBackgroundHalftoneDensity",
  StyleBox["\"",
    FontFamily->"Courier"],
  " "
}], "SubObjectNameClosed",
  CellTags->{"1.2.6.4.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"CellBackgroundHalftoneDensity\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the spacing of grid lines used \
to represent graphics in PostScript printers."
}], "Usage",
  CellTags->{"1.2.6.4.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is specified as ",
  StyleBox["\"CellBackgroundHalftoneDensity\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["n",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is the number of grid lines per inch."
}], "Notes",
  CellTags->{"1.2.6.4.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["\"",
    FontFamily->"Courier"],
  "CellBackgroundHalftoneAngle",
  StyleBox["\"",
    FontFamily->"Courier"]
}], "SubObjectNameClosed",
  CellTags->{"1.2.6.5.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"CellBackgroundHalftoneAngle\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the angle of grid lines used \
to represent graphics in PostScript printers. "
}], "Usage",
  CellTags->{"1.2.6.5.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is specified as ",
  StyleBox["\"CellBackgroundHalftoneAngle\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["n",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is the magnitude of the grid angle",
  StyleBox[".",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.6.5.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PaperSize\"", "SubObjectNameClosed",
  CellTags->{"1.2.6.12.1", "1.2.6.12", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PaperSize",
    FontFamily->"Courier"],
  "\" is an option for notebooks that determines the paper size when \
preparing a notebook for printing."
}], "Usage",
  CellTags->{"1.2.6.12.2", "1.2.6.12", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PaperSize",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["w",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["h",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " determines the width and height of the page in printers points, where 72 \
points equal one inch. "
}], "Notes",
  CellTags->{"1.2.6.12.3", "1.2.6.12", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageSize\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.13.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageSize\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the page size for printing a \
notebook. "
}], "Usage",
  CellTags->{"1.2.6.13.13.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageSize\" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["w",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["h",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  "specifies the width and height of the page in printer's points, where 72 \
points equal one inch. \n\[FilledSmallSquare] The settings for ",
  StyleBox["\"PageSize\"",
    FontFamily->"Courier"],
  " override those for the similar option ",
  StyleBox["PaperSize",
    FontFamily->"Courier"],
  ". By using a value of ",
  StyleBox["\"PageSize\"",
    FontFamily->"Courier"],
  " smaller than ",
  StyleBox["PaperSize",
    FontFamily->"Courier"],
  ", for example, you can simulate how a notebook would look when printed on \
smaller pages."
}], "Notes",
  CellTags->{"1.2.6.13.13.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PrintingMargins\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.13.12.1", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PrintingMargins",
    FontFamily->"Courier"],
  "\" is an option for notebooks that determines the size of margins when \
printing a notebook. "
}], "Usage",
  CellTags->{"1.2.6.13.12.2", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PrintingMargins",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["l",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox["},",
    FontFamily->"Courier"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  " specifies the margins at the left, right, bottom, and top of the page in \
printer's points, where 72 points equal one inch. "
}], "Notes",
  CellTags->{"1.2.6.13.12.3", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageHeaderMargins\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.10.1", "1.2.6.10", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageHeaderMargins",
    FontFamily->"Courier"],
  "\" is an option for notebooks that determines the size of margins for \
headers on a page."
}], "Usage",
  CellTags->{"1.2.6.10.2", "1.2.6.10", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageHeaderMargins",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " determines the vertical margin above the header in printer's points of \
the left and right facing pages, respectively.  If the \"FacingPages\" option \
is set to False, then the right header margin value is used for all pages."
}], "Notes",
  CellTags->{"1.2.6.10", "1.2.6.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageFooterMargins\" ", "SubObjectNameClosed",
  CellTags->{"1.2.6.11.1", "1.2.6.11", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageFooterMargins",
    FontFamily->"Courier"],
  "\" is an option for notebooks that determines the size of margins for \
footers in a page."
}], "Usage",
  CellTags->{"1.2.6.11.2", "1.2.6.11", "1.2.6.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["PageFooterMargins",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " determines the vertical margin below the footer in printer's points of \
the left and right facing pages, respectively.  If the \"FacingPages\" option \
is set to False, then the right header margin value is used for all pages."
}], "Notes",
  CellTags->{"1.2.6.11.3", "1.2.6.11", "1.2.6.13"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["PrivateNotebookOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->"1.2.6.14"],

Cell[CellGroupData[{

Cell["\"SafeFileSave\"", "ObjectName",
  CellTags->"1.2.6.14.1"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"SafeFileSave\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should take any special precautions before saving a notebook.  "
}], "Usage",
  CellTags->"1.2.6.14.1"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"SafeFileSave\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["Prescan",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "estimates the number of bytes in the notebook and checks if adequate disk \
space is available before saving it. In case the disk space is not enough, \
you will get an error message.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"SafeFileSave\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["TempFile",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " creates and saves a separate copy of the file instead of overwriting the \
existing copy. This ensures that if you run out of disk space, the last saved \
version of the file is still available to you. Once the new copy is \
successfully saved, the previous copy is deleted. \n \[FilledSmallSquare] The \
",
  StyleBox["TempFile",
    FontFamily->"Courier"],
  " setting is relevant for multiple-user platforms like Unix and Windows NT. \
On such platforms, a file save operation may fail even with adequate disk \
space on the machine, because the user's disk quota is exceeded\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["\"SafeFileSave\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["None",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not take any special precautions before saving a notebook. Use this \
setting if you are sure you have adequate disk space for your files."
}], "Notes",
  CellTags->"1.2.6.14.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SafeFileOpen\"", "ObjectName",
  CellTags->"1.2.6.14.1b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"SafeFileOpen\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should take any special precautions before opening a notebook.   "
}], "Usage",
  CellTags->"1.2.6.14.1b"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"SafeFileOpen\" \[Rule] IgnoreCache",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ignores the file outline cache when opening a notebook. The file outline \
cache contains information about the structure of the notebook and reduces \
the time taken to open large notebooks. With the ",
  StyleBox["IgnoreCache",
    FontFamily->"Courier"],
  " setting, you can open a notebook even if its file outline cache has \
become corrupted. This setting has the same effect as the ",
  StyleBox["File \[RightTriangle] Open Special",
    FontFamily->"Helvetica"],
  " menu command with the File reading method set to \"Ignore File Outline \
Cache.\" "
}], "Notes",
  CellTags->"1.2.6.14.1b"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"SafeFileOpen\" \[Rule] Prescan",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " scans the expression for each cell in the notebook to confirm that it \
starts with the text ",
  StyleBox["Cell[",
    FontFamily->"Courier"],
  ". This is a quick way to check for one common sign of file corruption."
}], "Notes",
  CellTags->"1.2.6.14.1b"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"SafeFileOpen\" \[Rule] None",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not take any special precautions before opening a notebook. Use this \
setting if you want to minimize the time taken to open a notebook."
}], "Notes",
  CellTags->"1.2.6.14.1b"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DoubleBuffer\" ", "ObjectName",
  CellTags->{"1.2.5.11.1", "1.2.6.14.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"DoubleBuffer\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " double buffering, a method of reducing flicker while a notebook is being \
edited, is used for a notebook."
}], "Usage",
  CellTags->{"1.2.5.11.2", "1.2.6.14.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"DoubleBuffer\"",
    FontFamily->"Courier"],
  StyleBox[" \[Rule] True",
    FontFamily->"Courier"],
  ", two copies of the rendered notebook are stored in memory at all times. \
While the screen display of the notebook is being updated, the back-up copy \
is displayed on the screen, reducing the flicker caused by the editing \
changes."
}], "Notes",
  CellTags->{"1.2.5.11.3", "1.2.6.14.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ColorPalette\" ", "ObjectName",
  CellTags->{"1.2.6.14.1.1", "1.2.6.14.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ColorPalette\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the number of colors used in \
the screen display when using a screen with 8-bit or lower resolution. "
}], "Usage",
  CellTags->{"1.2.6.14.1.2", "1.2.6.14.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ColorPalette\"",
    FontFamily->"Courier"],
  " is specified as a number in either the ",
  StyleBox["RGB",
    FontFamily->"Courier"],
  " or ",
  StyleBox["GrayLevel",
    FontFamily->"Courier"],
  " scale.\n\[FilledSmallSquare] The default setting for Macintosh systems is \
",
  StyleBox["\"ColorPalette\" \[Rule] {RGBColor, 128}.",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.6.14.1.3", "1.2.6.14.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"BackgroundPostScriptRendering\" ", "ObjectName",
  CellTags->{"1.2.6.14.2.1", "1.2.6.14.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"BackgroundPostScriptRendering\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " graphics are rendered during idle time, even if they are not currently \
visible on screen. "
}], "Usage",
  CellTags->{"1.2.6.14.2.2", "1.2.6.14.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"BackgroundPostScriptRendering\"",
    FontFamily->"Courier"],
  " -> ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", graphics are rendered only when they first appear on the screen.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["\"BackgroundPostScriptRendering\"",
    FontFamily->"Courier"],
  " -> ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", all un-rendered graphics present in a notebook are rendered when the \
notebook is opened, regardless of ",
  "if",
  " the graphic is currently displayed on the screen.  Rendering occurs \
concurrently with other activities and generally does not interfere with \
normal use of the front end.  However, it consumes processor resources and \
may slow down kernel evaluations and other background operations."
}], "Notes",
  CellTags->{"1.2.6.14.2.3", "1.2.6.14.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RealTimeMarginAdjustment\" ", "ObjectName",
  CellTags->{"1.2.6.14.3.1", "1.2.6.14.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RealTimeMarginAdjustment\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines if the size of margins in a \
notebook is adjusted in real time when the margin settings are changed by \
dragging the tab on the ruler toolbar. "
}], "Usage",
  CellTags->{"1.2.6.14.3.2", "1.2.6.14.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"RealTimeMarginAdjustment\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule] True",
    FontFamily->"Courier"],
  ", cells are adjusted and re-drawn in real time as the margin is adjusted.  \
This allows you to see exactly where word wrapping will occur as the \
adjustment is made.  However, it may be unacceptably slow in some situations. \
\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"RealTimeMarginAdjustment\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", the margins are adjusted only after you finish dragging the tab on the \
ruler toolbar. "
}], "Notes",
  CellTags->{"1.2.6.14.3.3", "1.2.6.14.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RealTimeWindowMove\" ", "ObjectName",
  CellTags->{"1.2.6.14.3.1", "1.2.6.14.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RealTimeWindowMove\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " the screen display of a notebook is dynamically updated as it is dragged \
across the screen using the mouse."
}], "Usage",
  CellTags->{"1.2.6.14.3.2", "1.2.6.14.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"RealTimeWindowMove\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule] True",
    FontFamily->"Courier"],
  ", the screen display of a notebook is dynamically updated as its position \
changes. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["\"RealTimeWindowMove\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", the display of a notebook is updated only after you finish dragging it \
and release the mouse button."
}], "Notes",
  CellTags->{"1.2.6.14.3.3", "1.2.6.14.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"RealTimeWindowResize\" ", "ObjectName",
  CellTags->{"1.2.6.14.3.1", "1.2.6.14.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RealTimeWindowResize\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines if the screen display of a \
notebook is dynamically updated as you resize it using the mouse."
}], "Usage",
  CellTags->{"1.2.6.14.3.2", "1.2.6.14.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"RealTimeWindowResize\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule] True",
    FontFamily->"Courier"],
  ", the screen display of a notebook is dynamically updated as you resize \
it.\n\[FilledSmallSquare] With the default setting ",
  StyleBox["\"RealTimeWindowResize\"",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", the display of a notebook is updated only after you finish resizing it \
and release the mouse button."
}], "Notes",
  CellTags->{"1.2.6.14.3.3", "1.2.6.14.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ShortBoxForm\"", "ObjectName",
  CellTags->{"1.2.6.14.4.1", "1.2.6.14.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ShortBoxForm\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " box expressions, used to represent two-dimensional forms in a notebook, \
are translated into a more compact notation when the notebook is saved."
}], "Usage",
  CellTags->{"1.2.6.14.4.2", "1.2.6.14.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"ShortBoxForm\" \[Rule] True",
    FontFamily->"Courier"],
  ", box expressions are saved in a more compact notation called ",
  StyleBox["ShortBoxForm",
    FontFamily->"Courier"],
  ". This reduces the disk space needed to store the notebook. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["\"ShortBoxForm\" \[Rule] False",
    FontFamily->"Courier"],
  ", the notation for box expressions is not converted to short box form when \
the notebook is saved. The short box form, though more compact, is less \
intuitive, which makes it harder to read and interpret. Hence the \
conventional notation is preferred when viewing and editing expressions in a \
notebook from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". \n\[FilledSmallSquare] For example, an input cell containing the \
expression ",
  Cell[BoxData[
      \(a\^2 + b\^2\)]],
  "would be displayed as: ",
  StyleBox["Cell[BoxData[\\(a\\^2 + b\\^2\\)], \"Input\"]",
    FontFamily->"Courier"],
  " ",
  "with ",
  StyleBox["\"ShortBoxForm\" \[Rule] True",
    FontFamily->"Courier"],
  "; and ",
  "as ",
  StyleBox["Cell[BoxData[RowBox[{SuperscriptBox[\"a\", \
\"2\"],+\",SuperscriptBox[\"b\", \"2\"]}]], \"Input\"]",
    FontFamily->"Courier"],
  " ",
  "with ",
  StyleBox["\"ShortBoxForm\" \[Rule] False",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.2.6.14.4.3", "1.2.6.14.8"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["IndexCreationOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->"1.2.6.15"],

Cell[TextData[{
  "This is a group of options that determine properties of the index \
generated using the ",
  StyleBox["Find \[RightTriangle] Make Index..",
    FontFamily->"Helvetica"],
  ". command. "
}], "Text",
  CellTags->"1.2.6.15"],

Cell[CellGroupData[{

Cell["\"Format\"", "ObjectName",
  CellTags->{"1.2.6.14.6.1", "1.2.6.15", "1.2.6.15.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Format\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the style used for formatting \
index entries. "
}], "Usage",
  CellTags->{"1.2.6.14.6.2", "1.2.6.15", "1.2.6.15.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can choose from a number of predefined styles. \
The default setting is ",
  StyleBox["\"Format\" \[Rule] \"PageReferences\"",
    FontFamily->"Courier"],
  ". Other possible settings include: ",
  StyleBox["\"Text\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Hyperlinks\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"SectionReferences\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"BrowserIndex\"",
    FontFamily->"Courier"],
  " and ",
  StyleBox["\"MathematicaList\"",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"1.2.6.14.6.3", "1.2.6.15", "1.2.6.15.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Ellipsis\"", "ObjectName",
  CellTags->{"1.2.5.11.1", "1.2.6.15", "1.2.6.15.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Ellipsis\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the character used to connect \
an index entry to the corresponding page number."
}], "Usage",
  CellTags->{"1.2.5.11.2", "1.2.6.15", "1.2.6.15.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option can be set to any character or string. \
The default setting is ",
  StyleBox["\"Ellipsis\" \[Rule] \"...\"",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"1.2.5.11.3", "1.2.6.15", "1.2.6.15.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MultiPageContinuation\" ", "ObjectName",
  CellTags->{"1.2.6.14.1.1", "1.2.6.15", "1.2.6.15.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"MultiPageContinuation\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the character used to separate \
multiple, consecutive page numbers in an index entry. "
}], "Usage",
  CellTags->{"1.2.6.14.1.2", "1.2.6.15", "1.2.6.15.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"MultiPageContinuation\" \[Rule] \"-\".",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.6.14.1.3", "1.2.6.15", "1.2.6.15.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PageSeparator\" ", "ObjectName",
  CellTags->{"1.2.6.14.2.1", "1.2.6.15", "1.2.6.15.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"PageSeparator\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the character inserted between \
multiple, non-consecutive page numbers in an index entry.  "
}], "Usage",
  CellTags->{"1.2.6.14.2.2", "1.2.6.15", "1.2.6.15.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"PageSeparator\" \[Rule] \"",
    FontFamily->"Courier"],
  ",",
  StyleBox["\".",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.6.14.2.3", "1.2.6.15", "1.2.6.15.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"SectionSeparator\" ", "ObjectName",
  CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["SectionSeparator",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines the character inserted before \
a section number in an index entry. "
}], "Usage",
  CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"SectionSeparator\" \[Rule] \"",
    FontFamily->"Courier"],
  ".",
  StyleBox["\".",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MainEntry\" ", "ObjectName",
  CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"MainEntry\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines if the text of an index entry \
is displayed in a bold font."
}], "Usage",
  CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the cell tag for a cell is followed by the string \
",
  StyleBox["\";Main\"",
    FontFamily->"Courier"],
  ", then any index entry that refers to the cell is shown in a bold font."
}], "Notes",
  CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MainPage\" ", "ObjectName",
  CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"MainPage\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines if the page number in an index \
entry is displayed in a bold font."
}], "Usage",
  CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the cell tag for any cell is followed by the \
string ",
  StyleBox["\";Bold\"",
    FontFamily->"Courier"],
  ", then the page number for that index entry is shown in a bold font."
}], "Notes",
  CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.7"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Options", "Section",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["Display Options", "InspectorLevel1",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["CellFrame", "ObjectName",
  CellTags->{"1.3.1.1.1", "1.3.1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellFrame", "MR"],
  " is an option for cells that determines ",
  "if",
  " a frame should be drawn around a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.1.2", "1.3.1.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["CellFrame \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["k",
    FontSlant->"Italic"],
  ", each side of the frame has a thickness ",
  StyleBox["k",
    FontSlant->"Italic"],
  " times the default thickness of a line. \n\[FilledSmallSquare] With the \
setting ",
  StyleBox["CellFrame \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["l",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["r",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["}, {",
    FontFamily->"Courier"],
  StyleBox["b",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["t",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  ", the left, right, bottom, and top sides of the frame can each have a \
different thickness. \n\[FilledSmallSquare] With the setting ",
  StyleBox["CellFrame \[Rule] False",
    FontFamily->"Courier"],
  ", no frame is drawn around the cell. ",
  "\n\[FilledSmallSquare] The space left between the frame and the cell \
contents is determined by ",
  StyleBox["CellFrameMargins", "MR"],
  ". \n\[FilledSmallSquare] Dingbats go outside the frame. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.1",
    ButtonData:>{"2.11.1", "1.14"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["Background",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellDingbat",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FrameBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  StyleBox[ButtonBox["CellFrameColor",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ",  ",
  StyleBox[ButtonBox["CellFrameLabels",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ",  ",
  StyleBox[ButtonBox["CellFrameLabelMargins",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.1.3", "1.3.1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellDingbat", "ObjectName",
  CellTags->{"1.3.1.2.1", "1.3.1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["CellDingbat", "MR"],
  " ",
  "is an option for cells",
  " that determines what dingbat to use to emphasize a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.2.2", "1.3.1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["CellDingbat", "MR"],
  StyleBox[" \[Rule] None",
    FontFamily->"Courier"],
  StyleBox[", no dingbat is", "MR",
    FontFamily->"Times"],
  " displayed.\n\[FilledSmallSquare] Dingbats are placed to the left of the \
main contents of a cell, aligned with the first line of the contents. \n\
\[FilledSmallSquare] Dingbats are placed outside of any cell frame. \n\
\[FilledSmallSquare] The setting for ",
  StyleBox["CellDingbat", "MR"],
  " can be any character or string. A typical setting is \"\[Backslash]",
  StyleBox["[FilledSquare]", "MR"],
  "\". \n\[FilledSmallSquare] ",
  StyleBox["CellDingbat", "MR"],
  " is typically set in the style sheet rather than for individual cells. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellFrame",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Background",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.2.3", "1.3.1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Background", "ObjectName",
  CellTags->"CellBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background",
    FontFamily->"Courier"],
  " is an option that determines the background color of the cell."
}], "Usage",
  CellTags->"CellBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background",
    FontFamily->"Courier"],
  StyleBox[" is an option for notebooks, cells, and selections. ",
    FontFamily->"Times New Roman"]
}], "Notes",
  CellTags->"CellBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["Background \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the background color is defined by the system settings. "
}], "Notes",
  CellTags->"CellBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] You can select a custom color with the color dialog \
box that appears by clicking the square symbol to the right of the option. \
The color is specified as an ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " [",
  StyleBox["red",
    FontSlant->"Italic"],
  ", ",
  StyleBox["green",
    FontSlant->"Italic"],
  ", ",
  StyleBox["blue",
    FontSlant->"Italic"],
  "]. Color specifications using ",
  StyleBox["Hue",
    FontFamily->"Courier"],
  " are allowed, but these are automatically converted to ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " by the front end. "
}], "Notes",
  CellTags->"CellBackground"]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowCellBracket", "ObjectName",
  CellTags->{"1.3.1.3.1", "1.3.1.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowCellBracket", "MR"],
  " is an option for cells that determines if the bracket that indicates the \
extent of the cell is displayed."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.3.2", "1.3.1.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowCellBracket", "MR"],
  " is often set for styles of cells or whole notebooks instead of individual \
cells. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellFrame",
    ButtonStyle->"RefGuideLink"],
  ", ",
  StyleBox[ButtonBox["CellBracketOptions",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.3.3", "1.3.1.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowSelection ", "ObjectName",
  CellTags->{"1.3.1.4.1", "1.3.1.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowSelection",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " text in a notebook should appear highlighted when it is selected. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.4.2", "1.3.1.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] If you set ",
  StyleBox["ShowSelection \[Rule] False",
    FontFamily->"Courier"],
  ", editing text becomes difficult because the insertion point and selection \
are invisible.  This option is intended for use in notebooks that will not be \
edited manually.  However, this option does not ",
  "prevent",
  " editing; use ",
  StyleBox["Editable \[Rule] False",
    FontFamily->"Courier"],
  " for that purpose.\n\[FilledSmallSquare] The default setting is ",
  StyleBox["ShowSelection \[Rule] True",
    FontFamily->"Courier"],
  "."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.4.3", "1.3.1.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowGroupOpenCloseIcon ", "ObjectName",
  CellTags->{"1.3.1.5.1", "1.3.1.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowGroupOpenCloseIcon",
    FontFamily->"Courier"],
  " is an option for cells that determines if a triangular icon is displayed \
next to the leading cell in a cell group to indicate ",
  "if",
  " the cell group is open or closed. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.5.2", "1.3.1.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["ShowGroupOpenCloseIcon \[Rule] True",
    FontFamily->"Courier"],
  ", a triangle symbol is displayed to the left of the leading cell. Clicking \
the triangle opens or closes the cell group. The triangle points to the right \
when the cell group is closed and down when the cell group is open.\n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["ShowGroupOpenCloseIcon \[Rule] False",
    FontFamily->"Courier"],
  ", no symbol appears next to the leading cell in a cell group."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.5.3", "1.3.1.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowClosedCellArea ", "ObjectName",
  CellTags->{"1.3.1.6.1", "1.3.1.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowClosedCellArea",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a rectangular bar is displayed next to a closed cell group to indicate \
the number of cells in the group. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.6.2", "1.3.1.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["ShowClosedCellArea \[Rule] True",
    FontFamily->"Courier"],
  ",  a rectangular bar is displayed to the left of the brackets for the \
closed cell group. The length of the bar is proportional to the number of \
cells in the group, with each pixel representing one cell. \n\
\[FilledSmallSquare] For the area bar to be displayed, ",
  StyleBox["ShowClosedCellArea",
    FontFamily->"Courier"],
  " must be set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  " for the leading cell in a cell group.\n\[FilledSmallSquare] With the \
default setting ",
  StyleBox["ShowClosedCellArea \[Rule] False",
    FontFamily->"Courier"],
  ", no bar appears next to the bracket for the closed cell group."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.6.3", "1.3.1.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowShortBoxForm ", "ObjectName",
  CellTags->{"1.3.1.7.1", "1.3.1.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowShortBoxForm",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " box expressions, used to represent two-dimensional forms in a cell, are \
displayed in a more compact notation when the expression for that cell is \
viewed."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.7.2", "1.3.1.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["ShowShortBoxForm \[Rule] True",
    FontFamily->"Courier"],
  ", the expression for a cell containing two-dimensional objects is \
represented in a compact notation, called ",
  StyleBox["ShortBoxForm",
    FontFamily->"Courier"],
  ". To view the expression for a cell, select the cell and click ",
  StyleBox["Format \[RightTriangle] Show Expression",
    FontFamily->"Helvetica"],
  ".\n\[FilledSmallSquare] With the default setting ",
  StyleBox["ShowShortBoxForm \[Rule] False",
    FontFamily->"Courier"],
  ", cell expressions involving two-dimensional objects are not displayed in \
short box form. The short box form, though more compact, is less intuitive to \
read and interpret. Hence the conventional notation is preferred when viewing \
and editing cell expressions. \n\[FilledSmallSquare] For example, an input \
cell containing the expression ",
  Cell[BoxData[
      \(a\^2 + b\^2\)]],
  " would be displayed as: ",
  StyleBox["Cell[BoxData[\\(a\\^2 + b\\^2\\)], \"Input\"]",
    FontFamily->"Courier"],
  " with ",
  StyleBox["\"ShortBoxForm\" \[Rule] True",
    FontFamily->"Courier"],
  "; and as ",
  StyleBox["Cell[BoxData[RowBox[{SuperscriptBox[\"a\", \
\"2\"],+\",SuperscriptBox[\"b\", \"2\"]}]], \"Input\"]",
    FontFamily->"Courier"],
  " with ",
  StyleBox["\"ShortBoxForm\" \[Rule] False",
    FontFamily->"Courier"],
  "."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.7.3", "1.3.1.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellDisplayCache ", "ObjectName",
  CellTags->{"1.3.1.8.1", "1.3.1.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellDisplayCache",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the contents of a cell are to be stored in memory to allow faster \
updating of the cell display. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.8.2", "1.3.1.8"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " With the setting ",
  StyleBox["CellDisplayCache \[Rule] True",
    FontFamily->"Courier"],
  ",  the contents of a cell are stored in a special cache so that the cell \
can be quickly redrawn. This option is often used for cells having \
complicated typesetting which can take a long time to redraw.\n",
  "\[FilledSmallSquare]",
  " The default setting is ",
  StyleBox["CellDisplayCache \[Rule] False.",
    FontFamily->"Courier"]
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.8.3", "1.3.1.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellMargins", "ObjectName",
  CellTags->{"1.3.1.9.1", "1.3.1.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellMargins", "MR"],
  " is an option for cells that determines the absolute margins in printer's \
points around a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.9.2", "1.3.1.9"}],

Cell["\[FilledSmallSquare] Possible settings are:", "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.9.3", "1.3.1.9"}],

Cell[TextData[{
  " ",
  Cell[BoxData[
      FormBox[GridBox[{
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"dist\\\\\\\"\\\", \\\"TI\\\"]\
\\) \"\>", "\<\"the same margins on all sides \"\>"},
            {
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["{",
                        
                        "InlineFormula"], \
"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"left\\\\\\\"\\\", \
\\\"TI\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\",\\\\\\\"\\\", \\\"MR\\\"]\\) \\!\
\\(\\*StyleBox[\\\"\\\\\\\"right\\\\\\\"\\\", \\\"TI\\\"]\\)\"\>", 
                      StyleBox["}",
                        
                        "InlineFormula"]}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\
\",\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
                    RowBox[{
                      StyleBox["{",
                        
                        "InlineFormula"], \
"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"bottom\\\\\\\"\\\", \
\\\"TI\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\",\\\\\\\"\\\", \\\"MR\\\"]\\) \\!\
\\(\\*StyleBox[\\\"\\\\\\\"top\\\\\\\"\\\", \\\"TI\\\"]\\)\"\>", 
                      StyleBox["}",
                        "InlineFormula"]}]}], 
                  StyleBox["}",
                    
                    "InlineFormula"]}], "\<\" \"\>"}], "\<\"different margins \
on different sides \"\>"}
            },
          ColumnAlignments->{Left}], TraditionalForm]],
    FormatType->StandardForm]
}], "Notes",
  ShowClosedCellArea->False],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " The left margin gives the distance from the edge of the window to the \
left\[Hyphen]hand side of the cell. \n",
  "\[FilledSmallSquare]",
  " The right margin gives the distance from the inside of the cell bracket \
to the right\[Hyphen]hand side of the cell. \n",
  "\[FilledSmallSquare]",
  " The left and right margins can be set interactively in the front end \
using the ruler toolbar accessible from the ",
  StyleBox["Format \[RightTriangle] ",
    FontFamily->"Helvetica"],
  StyleBox["Show Ruler", "SR"],
  " command. \n",
  "\[FilledSmallSquare]",
  " The top and bottom margins determine the amount of space to leave above \
and below the cell. \n",
  "\[FilledSmallSquare]",
  " The margins are measured from the edge of any cell frame that is present. \
\n",
  "\[FilledSmallSquare]",
  " Cell dingbats are placed to the left of the cell, and they extend into \
the left cell margin. \n",
  "\[FilledSmallSquare]",
  " See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  ".\n",
  "\[FilledSmallSquare]",
  " See also: ",
  ButtonBox["CellFrameMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellBaseline",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ImageMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowMargins",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.9.5", "1.3.1.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellBracketOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  ShowClosedCellArea->False,
  Background->None,
  CellTags->{"1.3.1.10.1", "1.3.1.10"}],

Cell[CellGroupData[{

Cell["\"Thickness\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.1.10.1.1", "1.3.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"Thickness\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the thickness of the brackets for a cell."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.10.1.2", "1.3.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"Thickness\"",
    FontFamily->"Courier"],
  " is specified in terms of printer's points, where 72 points equal one \
inch. The default setting is ",
  StyleBox["\"Thickness\" \[Rule] 0.25",
    FontFamily->"Courier"],
  "."
}], "Notes",
  ShowClosedCellArea->False,
  FontWeight->"Plain",
  CellTags->{"1.3.1.10.1.3", "1.3.1.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Color\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.1.10.2.1", "1.3.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"Color\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the color of the brackets for a cell."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.10.2.2", "1.3.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " The color is specified using the color dialog box that appears when the \
square symbol to the right of the option is clicked. It can be specified \
using one of the following formats: ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  ", ",
  StyleBox["GrayLevel",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Hue",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times"],
  " and ",
  StyleBox["CMYKColor",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  FontWeight->"Plain",
  CellTags->{"1.3.1.10.2.3", "1.3.1.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Margins\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.1.10.3.1", "1.3.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"Margins\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the width of margins around the brackets for a cell."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.10.3.2", "1.3.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["Margins", "MR"],
  StyleBox["\" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["left", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right", "TI"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  " determines the size of the margins to the left and right of the cell \
bracket, respectively. The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  " and ",
  StyleBox["right",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. "
}], "Notes",
  ShowClosedCellArea->False,
  FontWeight->"Plain",
  CellTags->{"1.3.1.10.3.3", "1.3.1.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Widths\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.1.10.4.1", "1.3.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"Widths\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the width of the brackets for a cell."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.10.4.2", "1.3.1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"Widths\" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["left", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["right", "TI"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  " determines the width of the brackets for a cell. The values of ",
  StyleBox["left",
    FontSlant->"Italic"],
  " and ",
  StyleBox["right",
    FontSlant->"Italic"],
  " are given in points, where 72 points equal one inch. "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.10.4.3", "1.3.1.10"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["CellElementSpacings\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  ShowClosedCellArea->False,
  Background->None,
  CellTags->{"1.3.1.11.1", "1.3.1.11"}],

Cell[CellGroupData[{

Cell["\"CellMinHeight\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.1.11.1.1", "1.3.1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"CellMinHeight\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the minimum height a cell is allowed to have."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.1.2", "1.3.1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"CellMinHeight\"",
    FontFamily->"Courier"],
  " is specified as a number measured in printer's points, where 72 points \
equals one inch.\n",
  "\[FilledSmallSquare]",
  " The default setting is ",
  StyleBox["\"CellMinHeight\" \[Rule] 12",
    FontFamily->"Courier"],
  "."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.1.3", "1.3.1.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ClosedCellHeight\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.1.11.2.1", "1.3.1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"ClosedCellHeight\"",
    FontFamily->"Courier"],
  " is an option for cells that determines the height of a closed cell."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.2.2", "1.3.1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] A closed cell is one which has ",
  StyleBox["CellOpen",
    FontFamily->"Courier"],
  " \[Rule]",
  StyleBox[" False.\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] ",
  StyleBox["\"ClosedCellHeight\"",
    FontFamily->"Courier"],
  " is specified as a number measured in printer's points, where 72 points \
equals one inch.\n\[FilledSmallSquare] The default setting is ",
  StyleBox["\"ClosedCellHeight\" \[Rule] 19",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellOpen",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.2.3", "1.3.1.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ClosedGroupTopMargin\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.1.11.3.1", "1.3.1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare]",
  " ",
  StyleBox["\"ClosedGroupTopMargin\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the size of the margin at the top of a closed group of \
cells. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.3.2", "1.3.1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] The setting for this option overrides the setting of \
",
  StyleBox["CellMargins",
    FontFamily->"Courier"],
  " for the leading cell in a cell group, when the cell group is closed.\n\
\[FilledSmallSquare] ",
  StyleBox["\"ClosedGroupTopMargin\"",
    FontFamily->"Courier"],
  " is specified as a number measured in printer's points, where 72 points \
equals one inch.\n\[FilledSmallSquare] The default setting is ",
  StyleBox["\"ClosedGroupTopMargin\" \[Rule] 4",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CellMargins",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.3.3", "1.3.1.11"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["PrivateCellOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  ShowClosedCellArea->False,
  Background->None,
  CellTags->{"1.3.1.11.1", "1.3.1.12"}],

Cell[CellGroupData[{

Cell["\"CellDisplayCache\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.1.11.1.1", "1.3.1.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"CellDisplayCache\"",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a bitmap representation of a graphics cell should be stored in a cache. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.1.2", "1.3.1.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"CellDisplayCache\" \[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ",  a bitmap representation of a graphics cell is stored in a cache. This \
allows the cell to be rendered faster when you open the notebook or scroll \
through its contents. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["\"CellDisplayCache\" \[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["False",
    FontFamily->"Courier"],
  ",  a bitmap representation of a graphics cell is not stored in a cache. "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.1.3", "1.3.1.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"DefaultCellGroupOpen\"  ", "SubObjectNameClosed",
  PrivateCellOptions->{"CellDisplayCache"->False},
  CellTags->{"1.3.1.11.2.1", "1.3.1.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"DefaultCellGroupOpen\"",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a cell group should always appear closed when a notebook is opened within \
the Help Browser. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.2.2", "1.3.1.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is only relevant for the display of cells \
in the Help Browser. When any information is displayed in the Help Browser, \
all cell groups are automatically opened, even if they were closed when the \
notebook was saved. This is because all cells have the setting ",
  StyleBox["DefaultCellGroupOpen",
    FontFamily->"Courier"],
  " \[Rule]",
  StyleBox[" True",
    FontFamily->"Courier"],
  " by default.\n\[FilledSmallSquare] You can, however, override this \
behavior and force a cell group to stay closed, by setting ",
  StyleBox["DefaultCellGroupOpen",
    FontFamily->"Courier"],
  " \[Rule]",
  StyleBox[" False",
    FontFamily->"Courier"],
  " for the leading cell in the cell group. This feature allows you to \
control the display of cells in the Help Browser, for example, to ensure that \
all heading cells for a certain topic are visible in one screen."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.2.3", "1.3.1.12"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General Properties", "InspectorLevel1",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["Active ", "ObjectName",
  CellTags->{"1.3.2.1.1", "1.3.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Active\"",
    FontFamily->"Courier"],
  " is an option for cells that determines if buttons are active. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.1.2", "1.3.2.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["Active", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " a button will perform an action when it is clicked. \n\
\[FilledSmallSquare] An active cell is indicated by an ",
  StyleBox["A", "MR"],
  " in the cell bracket. \n\[FilledSmallSquare] With ",
  StyleBox["Active", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " the contents of a button can be edited. "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.1.3", "1.3.2.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellEditDuplicate", "ObjectName",
  CellTags->{"1.3.2.2.1", "1.3.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellEditDuplicate", "MR"],
  " is an option for cells that determines ",
  "if",
  " the front end should make a copy of a cell that is being edited before \
its contents are modified. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.2.2", "1.3.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellEditDuplicate", "MR"],
  " is by default set to ",
  StyleBox["True", "MR"],
  " for cells that are generated as ",
  StyleBox["Mathematica", "TI"],
  " output. \n\[FilledSmallSquare] New cells generated when ",
  StyleBox["CellEditDuplicate", "MR"],
  StyleBox[" is set to ", "MR",
    FontFamily->"Times"],
  StyleBox["True", "MR"],
  " have styles specified by the setting of ",
  StyleBox["DefaultDuplicateCellStyle", "MR"],
  " in the notebook. \n\[FilledSmallSquare] ",
  StyleBox["CellEditDuplicate", "MR"],
  " is typically set in the style sheet rather than for individual cells. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellEvaluationDuplicate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Editable",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.2.3", "1.3.2.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluatable ", "ObjectName",
  CellTags->{"1.3.2.3.1", "1.3.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluatable", "MR"],
  " is an option for cells that determines ",
  "if",
  " a cell can be evaluated by the ",
  StyleBox["Mathematica", "TI"],
  " kernel. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.3.2", "1.3.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["Evaluatable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  ", typing \[ShiftKey]\[KeyBar]\[ReturnKey] in the front end when the cell \
is selected will cause the contents of the cell to be sent to the ",
  StyleBox["Mathematica", "TI"],
  " kernel for evaluation. \n\[FilledSmallSquare] ",
  StyleBox["Evaluatable", "MR"],
  " is typically set in the style sheet rather than for individual cells. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.19"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["Evaluator",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["InitializationCell",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["CellEvaluationDuplicate",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.3.3", "1.3.2.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Editable ", "ObjectName",
  CellTags->"1.3.2.14"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a notebook can be edited. "
}], "Usage",
  CellTags->"1.3.2.14"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["Editable \[Rule] False",
    FontFamily->"Courier"],
  ", the contents of a notebook are protected and cannot be edited in any \
way. ",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Editable \[Rule] True",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->"1.3.2.14"]
}, Closed]],

Cell[CellGroupData[{

Cell["Selectable", "ObjectName",
  CellTags->"1.3.2.15"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Selectable",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the window for a notebook should become selected when you click on it."
}], "Usage",
  CellTags->"1.3.2.15"],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Selectable",
    FontFamily->"Courier"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] With the setting ",
  StyleBox["Selectable",
    FontFamily->"Courier"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", a notebook window does not become selected by clicking any point inside \
the notebook. \n\[FilledSmallSquare] ",
  StyleBox["Selectable", "MR"],
  StyleBox[" only", "MR",
    FontFamily->"Times"],
  " affects the selection of the contents of a window. The notebook can still \
be selected by clicking its title bar. The related option, ",
  StyleBox["WindowClickSelect", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " affects selection of the window as a whole.\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.13"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["WindowFloating",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["SetSelectedNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->"1.3.2.15"]
}, Closed]],

Cell[CellGroupData[{

Cell["Deletable ", "ObjectName",
  CellTags->"1.3.2.16"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Deletable",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " any of the contents of a notebook can be deleted."
}], "Usage",
  CellTags->"1.3.2.16"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["With the setting ", "MR",
    FontFamily->"Times"],
  StyleBox["Deletable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  StyleBox[", the contents of a notebook cannot be deleted.\n", "MR",
    FontFamily->"Times"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Deletable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True.", "MR"]
}], "Notes",
  CellTags->"1.3.2.16"]
}, Closed]],

Cell[CellGroupData[{

Cell["Copyable ", "ObjectName",
  CellTags->{"1.3.2.4.1", "1.3.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Copyable", "MR"],
  " is an option for cells that determines if a cell can be copied \
interactively using the front end. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.4.2", "1.3.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] Even with the setting ",
  StyleBox["Copyable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  ", the expression corresponding to a cell can still be read into the kernel \
using ",
  StyleBox["NotebookRead", "MR"],
  ". \n\[FilledSmallSquare] With ",
  StyleBox["Copyable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  " set at the notebook level, no cells in the notebook can be copied \
interactively in the front end. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["Selectable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ReadProtected",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.4.3", "1.3.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellOpen", "ObjectName",
  CellTags->{"1.3.2.5.1", "1.3.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellOpen", "MR"],
  " is an option for cells that determines ",
  "if",
  " the contents of a cell should be displayed. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.5.2", "1.3.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["CellOpen", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  ", a small cell bracket is still shown to indicate the presence of a cell. \
\n\[FilledSmallSquare] Cells that are not open can still be evaluated \
automatically if you set ",
  StyleBox["CellAutoEvaluateTrue", "MR"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["Visible",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellGroupData",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ConversionRules",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.5.3", "1.3.2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellGroupingRules  ", "ObjectName",
  CellTags->{"1.3.2.6.1", "1.3.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellGroupingRules",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the rules used for grouping a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.6.2", "1.3.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["CellGroupingRules \[Rule] \"NormalGrouping\"",
    FontFamily->"Courier"],
  ", cells are automatically grouped according to their cell style.\n\
\[FilledSmallSquare] Other possible settings are as follows.\n",
  StyleBox["\"TitleGrouping\" \n\"SectionGrouping\" \n\"InputGrouping\" \n\
\"OutputGrouping\"  \n\"GraphicsGrouping\"\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] ",
  StyleBox["CellGroupingRules",
    FontFamily->"Courier"],
  " can also be set to ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["type",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  ", where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is an integer that gives the precedence of the grouping relative to other \
cells of the same type and ",
  StyleBox["type",
    FontSlant->"Italic"],
  " is selected from the list given above."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.6.3", "1.3.2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ConversionRules  ", "ObjectName",
  CellTags->{"1.3.2.7.1", "1.3.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ConversionRules",
    FontFamily->"Courier"],
  " is an option for cells that specifies a list of strings to be associated \
with a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.7.2", "1.3.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ConversionRules",
    FontFamily->"Courier"],
  " provides a way of storing additional information with a cell, for \
example, to be used by other programs in processing a notebook. It can be set \
to a list of one or more strings. \n\[FilledSmallSquare] With the default \
setting ",
  StyleBox["ConversionRules \[Rule] None",
    FontFamily->"Courier"],
  ", no additional information is associated with the cell."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.7.3", "1.3.2.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["TaggingRules  ", "ObjectName",
  CellTags->{"1.3.2.8.1", "1.3.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TaggingRules",
    FontFamily->"Courier"],
  " is an option for cells that specifies a list of strings to be associated \
with a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.8.2", "1.3.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TaggingRules",
    FontFamily->"Courier"],
  " provides a way of storing additional information with a cell, for \
example, to be used by other programs in processing a notebook. It can be set \
to a list of one or more strings.\n\[FilledSmallSquare] With the default \
setting ",
  StyleBox["TaggingRules \[Rule] None",
    FontFamily->"Courier"],
  ", no additional information is associated with the cell."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.8.3", "1.3.2.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellHorizontalScrolling ", "ObjectName",
  CellTags->{"1.3.2.10.1", "1.3.2.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellHorizontalScrolling",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the contents of a cell can be scrolled from left to right using the \
horizontal scroll bar of the notebook."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.10.2", "1.3.2.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["CellHorizontalScrolling \[Rule] True",
    FontFamily->"Courier"],
  ", the contents of the cell move horizontally across the screen when the \
notebook is scrolled.\n\[FilledSmallSquare] With the setting ",
  StyleBox["CellHorizontalScrolling \[Rule] False",
    FontFamily->"Courier"],
  ", the contents of the cell remain fixed in place so that they are visible \
in the window at all times when the notebook is scrolled. "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.2.10.3", "1.3.2.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["StyleMenuListing", "ObjectName",
  CellTags->{"1.3.2.11.1", "1.3.2.11"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["StyleMenuListing",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a given cell style is listed in the ",
  StyleBox["Format \[RightTriangle] Style",
    FontFamily->"Helvetica"],
  " submenu. "
}], "Usage",
  CellTags->{"1.3.2.11.2", "1.3.2.11"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" This option is typically specified in the style definition cell \
of a style sheet. With the setting ",
    FontFamily->"Times"],
  StyleBox["StyleMenuListing \[Rule] Automatic",
    FontFamily->"Courier"],
  StyleBox[", the name of that cell style is displayed in the ",
    FontFamily->"Times"],
  StyleBox["Format \[RightTriangle] Style",
    FontFamily->"Helvetica"],
  StyleBox[" submenu.\n\[FilledSmallSquare] With the setting ",
    FontFamily->"Times"],
  StyleBox["StyleMenuListing \[Rule] None",
    FontFamily->"Courier"],
  StyleBox[", the name of the cell style does not appear in the Style \
submenu. \n\[FilledSmallSquare] With the setting ",
    FontFamily->"Times"],
  StyleBox["StyleMenuListing \[Rule] \"",
    FontFamily->"Courier"],
  StyleBox["name",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox[", you can specify any string to represent that cell style in the \
Style submenu. \n",
    FontFamily->"Times"],
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" This option is typically specified for style definition cells in \
a style sheet.",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"1.3.2.11.3", "1.3.2.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonStyleMenuListing", "ObjectName",
  CellTags->{"1.3.2.12.1", "1.3.2.12"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["ButtonStyleMenuListing",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a given button style is listed under the ",
  StyleBox["Input \[RightTriangle] Create Button",
    FontFamily->"Helvetica"],
  " submenu."
}], "Usage",
  CellTags->{"1.3.2.12.2", "1.3.2.12"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" This option is typically specified in the style definition cell \
for a button style in a style sheet.With the setting ",
    FontFamily->"Times"],
  StyleBox["ButtonStyleMenuListing \[Rule] Automatic",
    FontFamily->"Courier"],
  StyleBox[", the name of that button style is displayed in the ",
    FontFamily->"Times"],
  StyleBox["Input \[RightTriangle] Create Button",
    FontFamily->"Helvetica"],
  " ",
  StyleBox["submenu.\n\[FilledSmallSquare] With the setting ",
    FontFamily->"Times"],
  StyleBox["ButtonStyleMenuListing \[Rule] None",
    FontFamily->"Courier"],
  StyleBox[", the name of the button style is not listed in the Create Button \
submenu. \n\[FilledSmallSquare] With the setting ",
    FontFamily->"Times"],
  StyleBox["ButtonStyleMenuListing \[Rule] \"",
    FontFamily->"Courier"],
  StyleBox["name",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox[", you can specify any string to represent the button style in the \
Create Button submenu. \n",
    FontFamily->"Times"],
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" This option is typically specified for style definition cells in \
a style sheet.",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"1.3.2.12.3", "1.3.2.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CounterStyleMenuListing", "ObjectName",
  CellTags->"1.3.2.12a"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["CounterStyleMenuListing",
    FontFamily->"Courier"],
  " is an option for cells that determines what counter styles are listed in \
the \"Counter Type:\" pop-up menu of the Automatic Numbering dialog box."
}], "Usage",
  CellTags->"1.3.2.12a"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" The autonumbering dialog box appears when you click ",
    FontFamily->"Times"],
  StyleBox["Input \[RightTriangle] Create Automatic Numbering Object...",
    FontFamily->"Helvetica"],
  StyleBox[".\n\[FilledSmallSquare] With the setting ",
    FontFamily->"Times"],
  StyleBox["CounterStyleMenuListing \[Rule] None",
    FontFamily->"Courier"],
  StyleBox[", no counter styles are listed in the ",
    FontFamily->"Times"],
  "Counter Type: pop-up menu of the Automatic Numbering dialog box.",
  StyleBox["\n",
    FontFamily->"Times"],
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" With the setting ",
    FontFamily->"Times"],
  StyleBox["CounterStyleMenuListing \[Rule] Automatic",
    FontFamily->"Courier"],
  StyleBox[", a pre-defined list of styles is displayed in the pop-up menu. \n\
",
    FontFamily->"Times"],
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["CounterStyleMenuListing",
    FontFamily->"Courier"],
  StyleBox[" can also be set to a list of one or more cell styles. Any styles \
that are defined in the style sheet for the notebook can be used.",
    FontFamily->"Times"]
}], "Notes",
  CellTags->"1.3.2.12a"]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatTypeAutoConvert ", "ObjectName",
  CellTags->{"1.3.2.13.1", "1.3.2.13"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["FormatTypeAutoConvert",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the contents of a cell are automatically converted into a different \
format when the style of that cell is changed. "
}], "Usage",
  CellTags->{"1.3.2.13.2", "1.3.2.13"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" Each cell style has a certain format associated with it. For \
example, by default, input cells are displayed in ",
    FontFamily->"Times"],
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  StyleBox[" and Text cells are displayed in ",
    FontFamily->"Times"],
  StyleBox["TextForm",
    FontFamily->"Courier"],
  StyleBox[".When you change the style of a cell to a style with a different \
default format, the contents of the cell are automatically converted to the \
new format. This corresponds to the default setting ",
    FontFamily->"Times"],
  StyleBox["FormatTypeAutoConvert \[Rule] True",
    FontFamily->"Courier"],
  StyleBox[". \n\[FilledSmallSquare] With the setting ",
    FontFamily->"Times"],
  StyleBox["FormatTypeAutoConvert \[Rule] False",
    FontFamily->"Courier"],
  StyleBox[", the contents of a cell stay in the same format even if the cell \
style is changed.",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"1.3.2.13.3", "1.3.2.13"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Page Breaking", "InspectorLevel1",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["PageBreakAbove", "ObjectName",
  CellTags->{"1.3.3.1.1", "1.3.3.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageBreakAbove", "MR"],
  " is an option for cells that determines ",
  "if",
  " a page break should be inserted immediately above a cell when the \
notebook is printed. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.3.1.2", "1.3.3.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["PageBreakAbove", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " a page break is inserted above the cell if necessary. \n\
\[FilledSmallSquare] A setting of ",
  StyleBox["True", "MR"],
  " means that a page break should always be inserted, while a setting of ",
  StyleBox["False", "MR"],
  " means that it is never inserted. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["PageBreakBelow",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PageBreakWithin",
    ButtonStyle->"RefGuideLink"],
  ",  ",
  ButtonBox["ShowPageBreaks",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.3.1.3", "1.3.3.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PageBreakWithin", "ObjectName",
  CellTags->{"1.3.3.2.1", "1.3.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageBreakWithin", "MR"],
  " is an option for cells that determines ",
  "if",
  " a page break should be allowed within a cell when the notebook is \
printed. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.3.2.2", "1.3.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["PageBreakWithin", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " a page break is inserted within the cell if necessary.\n\
\[FilledSmallSquare] A setting of ",
  StyleBox["True", "MR"],
  " means that a page break is always inserted within the cell, while a \
setting of ",
  StyleBox["False", "MR"],
  " means that it is never inserted. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["PageBreakAbove",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PageBreakBelow",
    ButtonStyle->"RefGuideLink"],
  ",  ",
  ButtonBox["GroupPageBreakWithin",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ShowPageBreaks",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.3.2.3", "1.3.3.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PageBreakBelow", "ObjectName",
  CellTags->{"1.3.3.3.1", "1.3.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PageBreakBelow", "MR"],
  " is an option for cells that determines ",
  "if",
  " a page break should be inserted immediately below a cell if the notebook \
that contains the cell is printed. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.3.3.2", "1.3.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["PageBreakBelow", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " a page break is inserted below the cell if necessary.\n\
\[FilledSmallSquare] A setting of ",
  StyleBox["True", "MR"],
  " means that a page break is always inserted, while a setting of ",
  StyleBox["False", "MR"],
  " means that it is never inserted. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["PageBreakAbove",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PageBreakWithin",
    ButtonStyle->"RefGuideLink"],
  ",  ",
  ButtonBox["ShowPageBreaks",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.3.3.3", "1.3.3.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["GroupPageBreakWithin", "ObjectName",
  CellTags->{"1.3.3.4.1", "1.3.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GroupPageBreakWithin", "MR"],
  " is an option for cells that determines ",
  "if",
  " a page break should be allowed within a group of cells when the notebook \
is printed. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.3.4.2", "1.3.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["GroupPageBreakWithin", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " a page break is inserted within a cell group if necessary.\n\
\[FilledSmallSquare] A setting of ",
  StyleBox["True", "MR"],
  " means that a page break is always inserted, while a setting of ",
  StyleBox["False", "MR"],
  " means that it is never inserted. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["PageBreakWithin",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ShowPageBreaks",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.3.4.3", "1.3.3.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluation Options", "InspectorLevel1",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["InitializationCell ", "ObjectName",
  CellTags->{"1.3.4.1.1", "1.3.4.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InitializationCell", "MR"],
  " is an option for cells that determines ",
  "if",
  " a cell should automatically be evaluated when the notebook is opened."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.1.2", "1.3.4.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["InitializationCell", "MR"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  StyleBox["False",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] See also: ",
  ButtonBox["InitializationCellEvaluation",
    ButtonStyle->"OtherInformationLinkMR"],
  ",  ",
  ButtonBox["InitializationCellWarning",
    ButtonStyle->"OtherInformationLinkMR"],
  ",  ",
  ButtonBox["AutoGeneratedPackage",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.1.3", "1.3.4.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellEvaluationDuplicate", "ObjectName",
  CellTags->{"1.3.4.2.1", "1.3.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellEvaluationDuplicate", "MR"],
  " is an option for cells that determines ",
  "if",
  " the front end should make a copy of the cell before performing an \
in-place evaluation of the cell."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.2.2", "1.3.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] When a cell is evaluated in place, the result of the \
evaluation replaces the cell that was evaluated. By setting ",
  StyleBox["CellEvaluationDuplicate", "MR"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", you can create a copy of the evaluated cell.\n\[FilledSmallSquare] New \
cells generated when ",
  StyleBox["CellEvaluationDuplicate", "MR"],
  StyleBox[" is set to ", "MR",
    FontFamily->"Times"],
  StyleBox["True", "MR"],
  " have styles specified by the setting of ",
  StyleBox["DefaultDuplicateCellStyle", "MR"],
  " for the notebook. \n\[FilledSmallSquare] ",
  StyleBox["CellEvaluationDuplicate", "MR"],
  " is typically set for styles of cells rather than for individual cells. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 1.10.3",
    ButtonData:>{"1.10.3"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.19"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellEditDuplicate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Evaluatable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellAutoOverwrite",
    ButtonStyle->"RefGuideLink"],
  ",  ",
  ButtonBox["SelectionEvaluate",
    ButtonStyle->"RefGuideLink"],
  ".  "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.2.3", "1.3.4.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["GeneratedCell", "ObjectName",
  CellTags->{"1.3.4.3.1", "1.3.4.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GeneratedCell", "MR"],
  " is an option for cells that indicates if a cell was generated by the \
kernel. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.3.2", "1.3.4.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] Cells created interactively using only operations in \
the front end have ",
  StyleBox["GeneratedCell", "MR"],
  StyleBox[" \[Rule] ", "MR",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  ". \n\[FilledSmallSquare] The setting for ",
  StyleBox["GeneratedCell", "MR"],
  " determines which cells are considered as ",
  StyleBox["Mathematica", "TI"],
  " output. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.3",
    ButtonData:>{"2.11.3", "3.17"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.19"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellAutoOverwrite",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.3.3", "1.3.4.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellAutoOverwrite", "ObjectName",
  CellTags->{"1.3.4.4.1", "1.3.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellAutoOverwrite", "MR"],
  " is an option for cells that determines ",
  "if",
  " new output obtained by evaluating a cell should overwrite old output. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.4.2", "1.3.4.4"}],

Cell[TextData[{
  " \[FilledSmallSquare] For a cell to be overwritten, it must also have ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Evaluatable",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", and the notebook option ",
  StyleBox["OutputAutoOverwrite",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". The output is deleted only when new output is ready to be inserted in \
its place. \n\[FilledSmallSquare] Any sequence of cells with ",
  StyleBox["GeneratedCell", "MR"],
  StyleBox[" \[Rule] ", "MR",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  " that follow the given cell are assumed to correspond to output.\n\
\[FilledSmallSquare] ",
  StyleBox["CellAutoOverwrite", "MR"],
  " is typically set for cells in ",
  StyleBox["Input", "MR",
    FontFamily->"Times"],
  " style. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.19"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["GeneratedCell",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellEvaluationDuplicate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Deletable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  StyleBox[ButtonBox["OutputAutoOverwrite",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.4.3", "1.3.4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Evaluator", "ObjectName",
  CellTags->{"1.3.4.5.1", "1.3.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Evaluator", "MR"],
  " is an option for cells that names the kernel used to evaluate a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.5.2", "1.3.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is typically ",
  StyleBox["Evaluator", "MR"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Local\"", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["Evaluator", "MR"],
  " is typically set at the global level or at the notebook level rather than \
at the level of individual cells. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.2",
    ButtonData:>{"2.11.2", "2.7"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.19"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["InitializationCell",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.5.3", "1.3.4.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PrivateEvaluationOptions\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  ShowClosedCellArea->False,
  Background->None,
  CellTags->{"1.3.4.6.1", "1.3.4.6"}],

Cell[CellGroupData[{

Cell[" \"OutputFormPageWidth\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.4.6.1.1", "1.3.4.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"OutputFormPageWidth\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the width of a page assumed when displaying output \
represented in ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ". "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.6.1.2", "1.3.4.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] The value of this option controls the setting of the \
",
  StyleBox["PageWidth",
    FontFamily->"Courier"],
  " option of the kernel's ",
  StyleBox["$Output",
    FontFamily->"Courier"],
  " stream. The front end automatically communicates the value to the kernel \
if the value changes.\n\[FilledSmallSquare] The default setting is \"",
  StyleBox["OutputFormPageWidth\" \[Rule] \"WindowWidth\".",
    FontFamily->"Courier"],
  " \n\[FilledSmallSquare] Other possible settings are: ",
  StyleBox["\"Infinity\"",
    FontFamily->"Courier"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["\"PaperWidth\"",
    FontFamily->"Courier"],
  StyleBox[", and ",
    FontFamily->"Times"],
  StyleBox["number",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[".",
    FontFamily->"Times"],
  " The latter case specifies the width of the page in characters. This is \
meaningful because ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  " assumes a monospaced font. "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.6.1.3", "1.3.4.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"StoreInputForm\"   ", "SubObjectNameClosed",
  CellTags->{"1.3.4.6.2.1", "1.3.4.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"StoreInputForm\"",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the front end should store an ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " representation of any output produced using ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  "."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.6.2.2", "1.3.4.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] Unlike ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  " or ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  " output, ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  " output cannot be used in further calculations: it is an output-only \
format.  In order to allow cells in ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  " to be used in further calculations, the front end can automatically store \
an ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " copy of the output. This option controls under what circumstances it will \
do so.\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"StoreInputForm\" \[Rule] All",
    FontFamily->"Courier"],
  StyleBox[", ",
    FontFamily->"Times"],
  "the front end stores an ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " representation of any output produced by the kernel. If the cell is then \
supplied as input to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the kernel interprets the ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " version to perform the evaluation.\n\[FilledSmallSquare] With the setting \
",
  StyleBox["\"StoreInputForm\" \[Rule] None,",
    FontFamily->"Courier"],
  " the front end does not store an ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " representation of any output produced by the kernel.  \n\
\[FilledSmallSquare] The default setting is ",
  StyleBox["\"StoreInputForm\" \[Rule] Automatic.",
    FontFamily->"Courier"],
  " With this setting, the front end stores an ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " representation for all output except that consisting of graphics or ",
  StyleBox["Short[]",
    FontFamily->"Courier"],
  " output. In those cases the ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " representation can be far larger than the ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  " output (because it includes the complete data representing the output, \
rather than an abbreviated form). "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.4.6.2.3", "1.3.4.6"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Labels", "InspectorLevel1",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["CellLabel", "ObjectName",
  CellTags->{"1.3.5.1.1", "1.3.5.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellLabel", "MR"],
  " is an option for cells that specifies a label for a particular cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.1.2", "1.3.5.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["CellLabel", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["\"\"", "MR"],
  StyleBox[", ", "MR",
    FontFamily->"Times"],
  "no label is associated with a cell. \n\[FilledSmallSquare] Cell labels are \
displayed when ",
  StyleBox["ShowCellLabels", "MR"],
  StyleBox[" is set to ",
    FontFamily->"Times"],
  StyleBox["True", "MR"],
  ". The style of cell labels is defined in the style sheet.\n\
\[FilledSmallSquare] Cell labels are typically generated automatically when \
cells appear as input or output to the ",
  StyleBox["Mathematica", "TI"],
  " kernel. The default style of cell labels is determined by the ",
  StyleBox["CellLabel",
    FontFamily->"Courier"],
  " setting defined in the style sheet.\n\[FilledSmallSquare] Cell labels are \
automatically deleted when a cell is modified if ",
  StyleBox["CellLabelAutoDelete", "MR"],
  StyleBox[" ", "MR",
    FontFamily->"Times"],
  StyleBox["is set to ",
    FontFamily->"Times"],
  StyleBox["True", "MR"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.3",
    ButtonData:>{"2.11.3", "3.26"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.15"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellTags",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.1.3", "1.3.5.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowCellLabel", "ObjectName",
  CellTags->{"1.3.5.2.1", "1.3.5.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowCellLabel", "MR"],
  " is an option for cells that determines if the label for a cell is \
displayed."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.2.2", "1.3.5.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowCellLabel", "MR"],
  " is more often set for styles of cells than for individual cells. Possible \
settings are ",
  StyleBox["True",
    FontFamily->"Courier"],
  " or ",
  StyleBox["False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.15"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellLabel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ShowCellTags",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.2.3", "1.3.5.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellLabelPositioning  ", "ObjectName",
  CellTags->{"1.3.5.3.1", "1.3.5.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellLabelPositioning",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines where the label for a cell is positioned. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.3.2", "1.3.5.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["CellLabelPositioning \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Left", "MR"],
  ", the label for a cell is placed to the left of the cell at the level of \
the first line.\n\[FilledSmallSquare] With the setting ",
  StyleBox["CellLabelPositioning \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Above", "MR"],
  ", the label for a cell is placed above the cell starting from the left \
edge of the page. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["CellLabelPositioning \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  ", the label for a cell is placed to the left of the cell if it is short \
enough to fit in the left margin. Otherwise, the label is placed above the \
cell."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.3.3", "1.3.5.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellLabelAutoDelete", "ObjectName",
  CellTags->{"1.3.5.4.1", "1.3.5.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellLabelAutoDelete", "MR"],
  " is an option for cells that determines ",
  "if",
  " the label for a cell is automatically deleted when the contents of the \
cell are modified or the notebook containing the cell is saved. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.4.2", "1.3.5.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are ",
  StyleBox["True",
    FontFamily->"Courier"],
  " or ",
  StyleBox["False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["CellLabelAutoDelete", "MR"],
  " is more often set for styles of cells than for individual cells. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.15"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellLabel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ShowCellLabel",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellTags",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellAutoOverwrite",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.4.3", "1.3.5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellLabelMargins  ", "ObjectName",
  CellTags->{"1.3.5.5.1", "1.3.5.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellLabelMargins", "MR"],
  " is an option for cells that determines the absolute margins in printer's \
points around a cell label. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.5.2", "1.3.5.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows:\n   ",
  StyleBox["dist",
    FontSlant->"Italic"],
  "\t\t\t\t\tthe same margins on all sides\n   ",
  StyleBox["{{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["right",
    FontSlant->"Italic"],
  "}",
  StyleBox[", {",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}  ",
    FontFamily->"Courier"],
  " different margins on different sides "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.5.5.3", "1.3.5.5"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Frame Options", "InspectorLevel1",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["CellFrame", "ObjectName",
  CellTags->{"1.3.6.1.1", "1.3.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellFrame", "MR"],
  " is an option for cells that determines ",
  "if",
  " a frame is drawn around a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.2", "1.3.6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["CellFrame \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["k",
    FontSlant->"Italic"],
  ", each side of the frame has a thickness ",
  StyleBox["k",
    FontSlant->"Italic"],
  " times the default thickness of a line. \n\[FilledSmallSquare] With the \
setting ",
  StyleBox["CellFrame \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["l",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["r",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["}, {",
    FontFamily->"Courier"],
  StyleBox["b",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["t",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  ", the left, right, bottom, and top sides of the frame can each have a \
different thickness. \n\[FilledSmallSquare] With the setting ",
  StyleBox["CellFrame \[Rule] False",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times New Roman"],
  " no frame is drawn around the cell. ",
  "\n\[FilledSmallSquare] The space left between the frame and the cell \
contents is determined by ",
  StyleBox["CellFrameMargins", "MR"],
  ". \n\[FilledSmallSquare] Dingbats go outside the frame. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.1",
    ButtonData:>{"2.11.1", "1.14"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["Background",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellDingbat",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FrameBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  StyleBox[ButtonBox["CellFrameColor",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ",  ",
  StyleBox[ButtonBox["CellFrameLabels",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ",  ",
  StyleBox[ButtonBox["CellFrameLabelMargins",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.3", "1.3.6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellFrameMargins", "ObjectName",
  CellTags->{"1.3.6.1.1", "1.3.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellFrameMargins", "MR"],
  " ",
  "is an option for cells",
  " that determines the absolute margins in printer's points to leave inside \
a frame that is drawn around a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.2", "1.3.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows:\n   ",
  StyleBox["dist",
    FontSlant->"Italic"],
  "\t\t\t\t\tthe same margins on all sides\n   ",
  StyleBox["{{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["right",
    FontSlant->"Italic"],
  "}",
  StyleBox[", {",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}  ",
    FontFamily->"Courier"],
  " different margins on different sides \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellMargins",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.3", "1.3.6.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellFrameColor", "ObjectName",
  CellTags->{"1.3.6.1.1", "1.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellFrameColor", "MR"],
  " ",
  "is an option for cells",
  " that determines the color of the frame around a cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.2", "1.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] The color is specified as an ",
  StyleBox["RGB",
    FontFamily->"Courier"],
  " or ",
  StyleBox["GrayLevel",
    FontFamily->"Courier"],
  " directive, using the \"Color Selector\" dialog box. Color specifications \
using ",
  StyleBox["Hue",
    FontFamily->"Courier"],
  " or ",
  StyleBox["CMYKColor",
    FontFamily->"Courier"],
  " are allowed, but these are automatically converted to ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " by the front end. The default setting is ",
  StyleBox["CellFrameColor", "MR"],
  StyleBox[" \[Rule] GrayLevel[0]",
    FontFamily->"Courier"],
  "."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.3", "1.3.6.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellFrameLabelMargins", "ObjectName",
  CellTags->{"1.3.6.1.1", "1.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellFrameLabelMargins", "MR"],
  " is an option for cells that determines the absolute margins in printer's \
points between a cell's frame and the labels around the frame."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.2", "1.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare]  Possible settings are as follows:\n   ",
  StyleBox["dist",
    FontSlant->"Italic"],
  "\t\t\t\t\tthe same margins on all sides\n   ",
  StyleBox["{{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["right",
    FontSlant->"Italic"],
  "}",
  StyleBox[", {",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["top",
    FontSlant->"Italic"],
  StyleBox["}}  ",
    FontFamily->"Courier"],
  " different margins on different sides \n\[FilledSmallSquare] See also: ",
  ButtonBox["CellMargins",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.3", "1.3.6.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellFrameLabels", "ObjectName",
  CellTags->{"1.3.6.1.1", "1.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellFrameLabels", "MR"],
  " ",
  "is an option for cells",
  " that determines the labels associated with the frame around a cell.  "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.2", "1.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellFrameLabels", "MR"],
  StyleBox[" \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["left",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["right",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["},{",
    FontFamily->"Courier"],
  StyleBox["bottom",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["top",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" specifies the labels to the left, right, bottom, and top of the \
cell frame, respectively. The label can be a string or a typeset expression.\n\
", "MR",
    FontFamily->"Times"],
  "\[FilledSmallSquare] ",
  StyleBox["Cell frame labels are usually specified as strings, but they can \
also be arbitrary cell expressions.", "MR",
    FontFamily->"Times"]
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.6.1.3", "1.3.6.5"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Tags", "InspectorLevel1",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["ShowCellTags", "ObjectName",
  CellTags->{"1.3.7.1.1", "1.3.7.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowCellTags", "MR"],
  " is an option for cells that determines if tags for a cell are displayed. \
"
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.7.1.2", "1.3.7.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] The tags for a cell are specified by the option ",
  StyleBox["CellTags", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ShowCellTags", "MR"],
  " is more often set for styles of cells than for individual cells. \n\
\[FilledSmallSquare] See also: ",
  ButtonBox["CellTags",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ShowCellLabel",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.7.1.3", "1.3.7.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Cell Options", "InspectorLevel1",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["CellSize  ", "ObjectName",
  CellTags->{"1.3.8.1.1", "1.3.8.1"}],

Cell[TextData[{
  StyleBox["CellSize",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the width and height of an inline cell."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.8.1.2", "1.3.8.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellSize \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["w", "TIE",
    FontSlant->"Italic"],
  StyleBox[",", "MRE"],
  " ",
  StyleBox["h", "TIE",
    FontSlant->"Italic"],
  StyleBox["}", "TIE",
    FontFamily->"Courier"],
  " gives the width and height of the inline cell in printer's points, where \
72 points equal one inch. "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.8.1.3", "1.3.8.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CellBaseline", "ObjectName",
  CellTags->{"1.3.8.2.1", "1.3.8.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellBaseline", "MR"],
  " is an option for cells that determines the vertical alignment of inline \
cells (typically typeset expressions or graphics embedded in text). "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.8.2.2", "1.3.8.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CellBaseline", "MR"],
  StyleBox[" \[Rule]", "MR",
    FontFamily->"Courier"],
  StyleBox[" ", "TI",
    FontFamily->"Courier"],
  StyleBox["number", "TI"],
  " specifies the baseline in points measured from the top of the cell. This \
position will be aligned with the baseline of the surrounding text.  \n\
\[FilledSmallSquare] Other possible settings are as follows."
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.8.2.3", "1.3.8.2"}],

Cell[BoxData[
    FormBox[
      RowBox[{"                                   ", GridBox[{
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Axis\\\\\\\"\\\", \\\"MR\\\"]\
\\) \"\>", "\<\"math\:f39faxis of the expression in the cell \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Baseline\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", "\<\"baseline of the expression in the cell (default) \
\"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Bottom\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", "\<\"bottom of the expression in the cell \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Center\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", "\<\"center of the expression in the cell \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Top\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", "\<\"top of the expression in the cell \"\>"}
            },
          ColumnAlignments->{Left}]}], TextForm]], "Text",
  FormatType->StandardForm,
  CellTags->{"1.3.8.2.4", "1.3.8.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CellMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["GridBaseline",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->"1.3.8.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["New Cell Defaults", "InspectorLevel1",
  ShowClosedCellArea->False],

Cell[CellGroupData[{

Cell["DefaultNewCellStyle", "ObjectName",
  CellTags->{"1.3.9.1.1", "1.3.9.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DefaultNewCellStyle", "MR"],
  " is an option for notebooks that determines the default style for new \
cells created interactively in a notebook. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.1.2", "1.3.9.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] A typical default setting for ",
  StyleBox["DefaultNewCellStyle", "MR"],
  " is ",
  StyleBox["\"Input\"", "MR"],
  StyleBox[". ",
    FontFamily->"Times"],
  "\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.9"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["DefaultDuplicateCellStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.1.3", "1.3.9.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DefaultNewInlineCellStyle", "ObjectName",
  CellTags->{"1.3.9.2.1", "1.3.9.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DefaultNewInlineCellStyle",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the default style for new inline cells created \
interactively in a notebook. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.2.2", "1.3.9.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] A typical default setting for ",
  StyleBox["DefaultNewInlineCellStyle",
    FontFamily->"Courier"],
  " is ",
  StyleBox["\"None\"", "MR"],
  StyleBox[", indicating that the inline cell will inherit all settings from \
the surrounding text.", "MR",
    FontFamily->"Times"],
  " ",
  "\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.9"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["DefaultNewCellStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.2.3", "1.3.9.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DefaultDuplicateCellStyle", "ObjectName",
  CellTags->{"1.3.9.3.1", "1.3.9.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DefaultDuplicateCellStyle", "MR"],
  " is an option for cells that determines the default style for cells \
created by automatic duplication of a cell in a notebook. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.3.2", "1.3.9.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] A typical default setting for ",
  StyleBox["DefaultDuplicateCellStyle", "MR"],
  " is ",
  StyleBox["\"Input\"", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["DefaultDuplicateCellStyle", "MR"],
  " determines the style for new cells created from cells with ",
  StyleBox["CellEditDuplicate", "MR"],
  StyleBox[" \[Rule] ", "MR",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  " or ",
  StyleBox["CellEvaluationDuplicate", "MR"],
  StyleBox[" \[Rule] ", "MR",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["DefaultDuplicateCellStyle", "MR"],
  " is typically set at the notebook level.\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.13",
    ButtonData:>{"2.11.13", "13.9"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["DefaultNewCellStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.3.3", "1.3.9.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DefaultFormatType  ", "ObjectName",
  CellTags->{"1.3.9.4.1", "1.3.9.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DefaultFormatType",
    FontFamily->"Courier"],
  " is an option for cells that determines the format used for displaying \
expressions in a newly created cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.4.2", "1.3.9.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DefaultFormatType",
    FontFamily->"Courier"],
  " is usually defined in the style definition cell for a particular cell \
style. Its value determines the format type used when a new cell of that \
style is created. \n\[FilledSmallSquare] Typical settings for ",
  StyleBox["DefaultFormatType",
    FontFamily->"Courier"],
  " are: ",
  StyleBox["DefaultTextFormatType",
    FontFamily->"Courier"],
  ", ",
  StyleBox["DefaultInputFormatType",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["DefaultOutputFormatType",
    FontFamily->"Courier"],
  ". Each of these variables is in turn associated with a format type like ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " or ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] The values of ",
  StyleBox["DefaultTextFormatType",
    FontFamily->"Courier"],
  ", ",
  StyleBox["DefaultInputFormatType",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["DefaultOutputFormatType",
    FontFamily->"Courier"],
  " are determined by the settings for the ",
  "suboptions",
  ", ",
  StyleBox["\"Text\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Input\"",
    FontFamily->"Courier"],
  " and ",
  StyleBox["\"Output\"",
    FontFamily->"Courier"],
  " respectively, of the option ",
  StyleBox["CommonDefaultFormatTypes",
    FontFamily->"Courier"],
  ". For example, suppose you set ",
  StyleBox["CommonDefaultFormatTypes \[Rule] {\"Input\" \[Rule] \
StandardForm}",
    FontFamily->"Courier"],
  ". This means that any cell style that has ",
  StyleBox["DefaultFormatType \[Rule] DefaultInputFormatType",
    FontFamily->"Courier"],
  ", will use ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book: ", "TI"],
  ButtonBox["Section 1.10.9",
    ButtonData:>{"1.10.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.9.1",
    ButtonData:>{"2.9.1", "1.10"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CommonDefaultFormatTypes",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.4.3", "1.3.9.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DefaultInlineFormatType  ", "ObjectName",
  CellTags->{"1.3.9.5.1", "1.3.9.5"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] DefaultInlineFormatType",
    FontFamily->"Courier"],
  " is an option for cells that determines the format used for displaying \
expressions in a newly created inline cell. "
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.5.2", "1.3.9.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DefaultInlineFormatType",
    FontFamily->"Courier"],
  " is usually defined in the style definition cell for a particular cell \
style. Its value determines the format type used when a new cell of that \
style is created. \n\[FilledSmallSquare] Typical settings for ",
  StyleBox["DefaultFormatType",
    FontFamily->"Courier"],
  " are: ",
  StyleBox["DefaultTextInlineFormatType",
    FontFamily->"Courier"],
  ", ",
  StyleBox["DefaultInputInlineFormatType",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["DefaultOutputInlineFormatType",
    FontFamily->"Courier"],
  ". Each of these variables is in turn associated with a format type like ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  ", or ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] The values of ",
  StyleBox["DefaultTextInlineFormatType",
    FontFamily->"Courier"],
  ", ",
  StyleBox["DefaultInputInlineFormatType",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["DefaultOutputInlineFormatType",
    FontFamily->"Courier"],
  " are determined by the settings for the suboptions, ",
  StyleBox["\"TextInline\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"InputInline\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"OutputInline\"",
    FontFamily->"Courier"],
  " respectively, of the option ",
  StyleBox["CommonDefaultFormatTypes",
    FontFamily->"Courier"],
  ". For example, suppose you set ",
  StyleBox["CommonDefaultFormatTypes \[Rule] {\"TextInline\" \[Rule] \
TraditionalForm}",
    FontFamily->"Courier"],
  ". This means that any cell style that has ",
  StyleBox["DefaultInlineFormatType \[Rule] DefaultTextInlineFormatType",
    FontFamily->"Courier"],
  ", will use ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book: ", "TI"],
  ButtonBox["Section 1.10.9",
    ButtonData:>{"1.10.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.9.1",
    ButtonData:>{"2.9.1", "1.10"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["CommonDefaultFormatTypes",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.5.3", "1.3.9.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CommonDefaultFormatTypes\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  ShowClosedCellArea->False,
  Background->None,
  CellTags->{"1.3.9.6.1", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["CommonDefaultFormatTypes",
    FontFamily->"Courier"],
  " is a group of cell options that determine the default format used for \
displaying expressions in newly created cells. It consists of six suboptions: \
",
  StyleBox["\"Text\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Input\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Output\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"TextInline\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"InputInline\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"OutputInline\"",
    FontFamily->"Courier"],
  ". Each suboption determines the default format associated with a specific \
type of cell. "
}], "Text",
  CellTags->"1.3.9.6"],

Cell[CellGroupData[{

Cell["\"Text\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.9.6.1.1", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Text\"",
    FontFamily->"Courier"],
  " is an option for cells that determines the default format used in newly \
created text cells."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.1.2", "1.3.9.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"Text\" \[Rule] TextForm.\n\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " Other possible settings are ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times"],
  " and ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.1.3", "1.3.9.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Input\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.9.6.2.1", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Input\"",
    FontFamily->"Courier"],
  " is an option for cells that determines the default format used in \
newly-created input cells."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.2.2", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " The setting for this option can also be changed using the menu command ",
  StyleBox["Cell \[RightTriangle] Default Input FormatType",
    FontFamily->"Helvetica"],
  ". Any changes made to the setting in the menu are automatically reflected \
in the Option Inspector and vice-versa.\n\[FilledSmallSquare] The default \
setting is ",
  StyleBox["\"InputInline\" \[Rule] StandardForm",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " Other possible settings include ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times"],
  " and ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.2.3", "1.3.9.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Output\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.9.6.3.1", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Output\"",
    FontFamily->"Courier"],
  " is an option for cells that determines the default format used in \
newly-created output cells."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.3.2", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " The setting for this option can also be changed using the menu command ",
  StyleBox["Cell \[RightTriangle] Default Output FormatType",
    FontFamily->"Helvetica"],
  ". Any changes made to the setting in the menu are automatically reflected \
in the Option Inspector and vice versa.\n\[FilledSmallSquare] The default \
setting is ",
  StyleBox["\"Output\" \[Rule] StandardForm",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " Other possible settings include ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times"],
  " and ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.3.3", "1.3.9.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"TextInline\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.9.6.4.1", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"TextInline\"",
    FontFamily->"Courier"],
  " is an option for cells that determines the default format used in \
newly-created inline text cells."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.4.2", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " The setting for this option can also be changed using the menu command ",
  StyleBox["Cell \[RightTriangle] Default Inline FormatType",
    FontFamily->"Helvetica"],
  ". Any changes made to the setting in the menu are automatically reflected \
in the Option Inspector and vice-versa.\n\[FilledSmallSquare] The default \
setting is ",
  StyleBox["\"TextInline\" \[Rule] TraditionalForm",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " Other possible settings include ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times"],
  " and ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.4.3", "1.3.9.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"InputInline\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.9.6.6.1", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"InputInline\"",
    FontFamily->"Courier"],
  " is an option for cells that determines the default format used in \
newly-created inline input cells."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.6.2", "1.3.9.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"InputInline\" \[Rule] StandardForm",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " Other possible settings include ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times"],
  " and ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.6.3", "1.3.9.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"OutputInline\"  ", "SubObjectNameClosed",
  CellTags->{"1.3.9.6.5.1", "1.3.9.6"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"OutputInline\"",
    FontFamily->"Courier"],
  " is an option for cells that determines the default format used in \
newly-created inline output cells."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.5.2", "1.3.9.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"OutputInline\" \[Rule] StandardForm",
    FontFamily->"Courier"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " Other possible settings include ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times"],
  " and ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.9.6.5.3", "1.3.9.6"}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Editing Options", "Section",
  PageWidth->WindowWidth],

Cell[CellGroupData[{

Cell["Editable ", "ObjectName",
  CellTags->"2.2.17"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " is an option for cells that determines if the contents of a cell can be \
edited. "
}], "Usage",
  CellTags->"2.2.17"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["Editable \[Rule] False",
    FontFamily->"Courier"],
  ", the contents of a cell are protected and cannot be edited in any way. ",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Editable \[Rule] True",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->"2.2.17"]
}, Closed]],

Cell[CellGroupData[{

Cell["Selectable", "ObjectName",
  CellTags->"2.2.18"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Selectable",
    FontFamily->"Courier"],
  " is an option for notebooks that determines if the window for a notebook \
should become selected when you click it."
}], "Usage",
  CellTags->"2.2.18"],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Selectable",
    FontFamily->"Courier"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] With the setting ",
  StyleBox["Selectable",
    FontFamily->"Courier"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", a notebook window does not become selected by your clicking any point \
inside the notebook. \n\[FilledSmallSquare] ",
  StyleBox["Selectable", "MR"],
  StyleBox[" only", "MR",
    FontFamily->"Times"],
  " affects the selection of the contents of a window. The notebook can still \
be selected by clicking its title bar. The related option ",
  StyleBox["WindowClickSelect",
    FontFamily->"Courier"],
  " affects selection of the window as a whole.\n\[FilledSmallSquare] See \
also: ",
  ButtonBox["WindowFloating",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowClickSelect",
    ButtonStyle->"RefGuideLink"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " ",
  ButtonBox["SetSelectedNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->"2.2.18"]
}, Closed]],

Cell[CellGroupData[{

Cell["Deletable ", "ObjectName",
  CellTags->"2.2.19"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Deletable",
    FontFamily->"Courier"],
  " is an option for cells that determines if any of the contents of a cell \
can be deleted."
}], "Usage",
  CellTags->"2.2.19"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["With the setting ", "MR",
    FontFamily->"Times"],
  StyleBox["Deletable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  StyleBox[", the contents of a cell cannot be deleted.\n", "MR",
    FontFamily->"Times"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Deletable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True.", "MR"]
}], "Notes",
  CellTags->"2.2.19"]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoIndent", "ObjectName",
  CellTags->{"2.2.2.2", "2.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoIndent", "MR"],
  " is an option for cells that determines ",
  "if",
  " a new line of text should be automatically indented so it is aligned with \
the previous line."
}], "Usage",
  CellTags->{"2.2.2.3", "2.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["AutoIndent \[Rule] True",
    FontFamily->"Courier"],
  ", the next line is automatically indented by an amount equal to the white \
space at the start of the previous line.\n\[FilledSmallSquare] With the \
setting ",
  StyleBox["AutoIndent \[Rule] False",
    FontFamily->"Courier"],
  ", you must indent each line manually.\n\[FilledSmallSquare] With the \
setting ",
  StyleBox["AutoIndent",
    FontFamily->"Courier"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ", each line is indented by an amount determined by the depth of the last \
expression in the previous line. If the depth changes, by adding or deleting \
brackets, the indentation of the next line is automatically adjusted.\n\
\[FilledSmallSquare] The options ",
  StyleBox["LineIndent", "MR"],
  " and ",
  StyleBox["LineIndentMaxFraction", "MR"],
  StyleBox[" determine the ", "MR",
    FontFamily->"Times"],
  "amount of indentation inserted.\n\[FilledSmallSquare] If \[ReturnKey] or \
\[Backslash]",
  StyleBox["[NewLine]", "MR"],
  " is used to create the next line, tabs for indentation will explicitly be \
inserted into the internal structure of the object representing the contents \
of the cell. \n\[FilledSmallSquare] If \[Backslash]",
  StyleBox["[IndentingNewLine]", "MR"],
  " is used, only this character will be inserted, and indentation will be \
redone each time the expression is output. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.11",
    ButtonData:>{"2.11.11", "11.2"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["LineIndent",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ParagraphIndent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.2.2.4", "2.2.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["InputAliases ", "ObjectName",
  CellTags->{"2.2.3.2", "2.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InputAliases",
    FontFamily->"Courier"],
  " is an option for cells that allows you to define customized keyboard \
aliases for frequently used expressions. "
}], "Usage",
  CellTags->{"2.2.3.3", "2.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] Using this option you can define aliases for any \
typeset expression, however complicated. For example, if you set ",
  StyleBox["InputAliases \[Rule] {\"a1\" \[Rule] SubscriptBox[\"a\", \"1\"]}",
    
    FontFamily->"Courier"],
  ", then typing \[EscapeKey]",
  " ",
  StyleBox["a1",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[EscapeKey]",
    FontFamily->"Courier"],
  " enters the character ",
  Cell[BoxData[
      StyleBox[\(a\_1\),
        FontWeight->"Plain"]]],
  " into the notebook.\n\[FilledSmallSquare] ",
  StyleBox["InputAliases",
    FontFamily->"Courier"],
  " is specified as a list with each element defining a single alias. The \
full form of each alias must be specified by its complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression.\n\[FilledSmallSquare] This option is typically specified in a \
style sheet.\n\[FilledSmallSquare] ",
  StyleBox["Note:",
    FontWeight->"Bold"],
  " to enter the character \[AliasDelimiter], press the \[EscapeKey] key. "
}], "Notes",
  CellTags->{"2.2.3.4", "2.2.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["InputAutoReplacements", "ObjectName",
  CellTags->{"2.2.4.2", "2.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InputAutoReplacements",
    FontFamily->"Courier"],
  " is an option for cells that determines if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should automatically apply a specified set of replacement rules to text \
being entered in a notebook."
}], "Usage",
  CellTags->{"2.2.4.3", "2.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The replacement rules to be applied are specified as \
a list, each element of which has the form, ",
  StyleBox["\"string1",
    FontSlant->"Italic"],
  "\"",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  "\"",
  StyleBox["string2",
    FontSlant->"Italic"],
  "\".\n\[FilledSmallSquare] This option allows you to control the appearance \
of selected expressions or operators in a notebook. Some replacement rules \
that are usually set by default are as follows.\n     ",
  StyleBox["\"\[Rule]\" \[Rule] \"\[Backslash][Rule]\"\n  \":>\" \[Rule] \"\
\[Backslash][DelayedRule]\"\n  \"<=\" \[Rule] \"\[Backslash][LessEqual]\"\n  \
\">=\" \[Rule] \"\[Backslash][GreaterEqual]\"\n  \"!=\" \[Rule]  \"\
\[Backslash][NotEqual]\"\n  \"==\" \[Rule]  \"\[Backslash][Equal]\"\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ImportAutoReplacements",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["ExportAutoReplacements",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->{"2.2.4.4", "2.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DelimiterFlashTime", "ObjectName",
  CellTags->{"2.2.5.2", "2.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DelimiterFlashTime", "MR"],
  " is an option for cells that determines the time in seconds an opening \
delimiter flashes when its matching closing delimiter is entered. "
}], "Usage",
  CellTags->{"2.2.5.3", "2.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["DelimiterFlashTime", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["0.3", "MR"],
  ", matching delimiters flash for 0.3 seconds. \n\[FilledSmallSquare] \
Delimiters include parentheses, brackets, and braces, as well as ",
  StyleBox["[[", "MR"],
  StyleBox[" or", "MR",
    FontFamily->"Times New Roman"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["]]", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times New Roman"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["(*", "MR"],
  StyleBox[" or", "MR",
    FontFamily->"Times New Roman"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["*)", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times New Roman"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  " and paired special characters such as \[LeftAngleBracket] or \
\[RightAngleBracket]. \n\[FilledSmallSquare] With the setting ",
  StyleBox["DelimiterFlashTime", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["0", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " delimiters do not flash. \n\[FilledSmallSquare] If you enter an unpaired \
closing delimiter, the standard ",
  StyleBox["Mathematica", "TI"],
  " front end will beep. \n\[FilledSmallSquare] You can use the front end \
menu command ",
  StyleBox["Edit \[RightTriangle] Balance", "SR"],
  " to select ranges with balanced delimiters in expressions. \n\
\[FilledSmallSquare] You can set ",
  StyleBox["DelimiterFlashTime", "MR"],
  " at the level of a single cell, a notebook, or the whole front end. \n\
\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.11",
    ButtonData:>{"2.11.11", "11.2"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["SyntaxQ",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.2.5.4", "2.2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowCursorTracker ", "ObjectName",
  CellTags->{"2.2.6.2", "2.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowCursorTracker",
    FontFamily->"Courier"],
  " is an option for cells that determines if an elliptical spot should \
appear momentarily to guide the eye when the cursor position jumps. "
}], "Usage",
  CellTags->{"2.2.6.3", "2.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ShowCursorTracker \[Rule] True",
    FontFamily->"Courier"],
  ". Line breaking is normally set up so that small changes to expressions in \
input cells rarely cause large-scale reformatting; the cursor tracker appears \
whenever reformatting is required that makes the cursor position jump. \n\
\[FilledSmallSquare] The cursor tracker is intended to be sufficiently \
eye-catching to make the low-level human visual system cause an immediate \
shift in gaze.  \n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["CursorTrackerParameters",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.2.6.4", "2.2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowAutoStyles", "ObjectName",
  CellTags->{"2.2.8.2", "2.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowAutoStyles",
    FontFamily->"Courier"],
  " is an option for cells that determines if a style should automatically be \
applied when input of a specified type is entered into a cell. "
}], "Usage",
  CellTags->{"2.2.8.3", "2.2.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] The types of input to which a style is applied and \
the details of the style are specified by the setting for ",
  StyleBox["AutoStyleOptions",
    FontFamily->"Courier"],
  ". For example, by default, unmatched delimiters such as brackets are \
automatically highlighted in purple as you type. \n\[FilledSmallSquare] The \
default setting is ",
  StyleBox["ShowAutoStyles \[Rule] True",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["AutoStyleOptions",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ", ",
  StyleBox[ButtonBox["DelimiterFlashTime",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ", and ",
  StyleBox[ButtonBox["ShowCursorTracker",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.2.8.4", "2.2.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["StructuredSelection", "ObjectName",
  CellTags->{"2.2.10.2", "2.2.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["StructuredSelection", "MR"],
  " is an option for cells that determines whether to allow only complete \
subexpressions be selected interactively in a typeset cell. "
}], "Usage",
  CellTags->{"2.2.10.3", "2.2.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["StructuredSelection", "MR"],
  " is more often set at a global level than at the level of individual \
cells. It applies only to typeset, ",
  "i.e.,",
  " ",
  StyleBox["BoxData",
    FontFamily->"Courier"],
  " cells.\n\[FilledSmallSquare] With the setting ",
  StyleBox["StructuredSelection", "MR"],
  " ",
  StyleBox["\[Rule] True",
    FontFamily->"Courier"],
  ", you can only select a complete subexpression in a typeset cell. If you \
try to extend the selection by pressing \[ShiftKey]\[LeftModified]",
  StyleBox["\[ShortRightArrow]",
    FontFamily->"Courier"],
  "\[RightModified], for instance, the selection changes in discrete jumps, \
moving directly to the next higher subexpression. \n\[FilledSmallSquare] With \
the default setting ",
  StyleBox["StructuredSelection", "MR"],
  StyleBox[" \[Rule] False",
    FontFamily->"Courier"],
  ", if you extend the selection by pressing \[ShiftKey]\[LeftModified]",
  StyleBox["\[ShortRightArrow]",
    FontFamily->"Courier"],
  "\[RightModified], the selection advances by a single character.\n\
\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.11",
    ButtonData:>{"2.11.11", "11.6"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["Selectable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["DragAndDrop",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.2.10.4", "2.2.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["StyleBoxAutoDelete ", "ObjectName",
  CellTags->{"2.2.11.2", "2.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["StyleBoxAutoDelete",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a ",
  StyleBox["StyleBox",
    FontFamily->"Courier"],
  " wrapped around an expression should be automatically removed when the \
expression is edited."
}], "Usage",
  CellTags->{"2.2.11.3", "2.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is useful for creating templates that \
require user input. For example, suppose you want to create a template for \
calculating integrals. You can highlight the part of the expression that the \
user needs to edit by displaying it in a different style, such as using a red \
color for the font: ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["\[Integral]",
            "Input",
            StyleBoxAutoDelete->True], 
          RowBox[{
            StyleBox[\(f(x)\),
              StyleBoxAutoDelete->True,
              FontColor->RGBColor[1, 0, 0]], 
            StyleBox[\(\[DifferentialD]x\),
              "Input",
              StyleBoxAutoDelete->True]}]}], TraditionalForm]],
    FormatType->StandardForm],
  ". If you set ",
  StyleBox["StyleBoxAutoDelete",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", the red color will disappear as soon as the user edits the expression. \n\
\[FilledSmallSquare] The default setting is ",
  StyleBox["StyleBoxAutoDelete",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.2.11.4", "2.2.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DragAndDrop", "ObjectName",
  CellTags->{"2.2.12.2", "2.2.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DragAndDrop", "MR"],
  " is an option for cells that determines whether to allow drag\[Hyphen]and\
\[Hyphen]drop editing on the contents of a cell. "
}], "Usage",
  CellTags->{"2.2.12.3", "2.2.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["DragAndDrop", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  ", dragging an already\[Hyphen]selected region cuts the region from its \
original location, and pastes it at the new location of the cursor. \n\
\[FilledSmallSquare] ",
  StyleBox["DragAndDrop", "MR"],
  " is typically set as a global option in the front end, rather than as an \
option for individual cells. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.11",
    ButtonData:>{"2.11.11", "11.6"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["StructuredSelection",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.2.12.4", "2.2.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowSpecialCharacters", "ObjectName",
  CellTags->{"2.2.13.2", "2.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowSpecialCharacters", "MR"],
  " is an option for cells that determines if  \[Backslash]",
  StyleBox["[", "MR"],
  StyleBox["Name", "TI"],
  StyleBox["]", "MR"],
  ", \[Backslash]",
  StyleBox[":", "MR"],
  StyleBox["nnnn", "TI"],
  ", and so on should be replaced with explicit special characters."
}], "Usage",
  CellTags->{"2.2.13.3", "2.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ShowSpecialCharacters", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  ", special characters specified by their alias or Unicode number are \
replaced by the corresponding font symbol. For example, if you type ",
  StyleBox["\[Backslash][Alpha]",
    FontFamily->"Courier"],
  ", it is automatically converted to \[Alpha].\n\[FilledSmallSquare] With ",
  StyleBox["ShowSpecialCharacters", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  ", special characters are always displayed by name when possible. For \
example, if you type ",
  StyleBox["\[Backslash][Alpha]",
    FontFamily->"Courier"],
  ", it is displayed as entered.\n\[FilledSmallSquare] ",
  StyleBox["ShowSpecialCharacters", "MR"],
  " is mainly used for documentation and testing purposes. It is also useful \
for coding, where close control over characters is required.\n\
\[FilledSmallSquare] See also: ",
  ButtonBox["ShowStringCharacters",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CharacterEncoding",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.2.13.4", "2.2.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AllowInlineCells ", "ObjectName",
  CellTags->{"2.2.14.2", "2.2.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AllowInlineCells",
    FontFamily->"Courier"],
  " is an option for cells that determines if inline cells are permitted \
within a cell."
}], "Usage",
  CellTags->{"2.2.14.4", "2.2.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["AllowInlineCells \[Rule] True",
    FontFamily->"Courier"],
  ",  you can create cells nested within cells. These inline cells are \
useful, for example, in displaying typeset expressions or graphics along with \
text in the same cell.  \n\[FilledSmallSquare] With the setting ",
  StyleBox["AllowInlineCells \[Rule] False",
    FontFamily->"Courier"],
  ", inline cells cannot be created inside a cell. This is the case, for \
example, in InputForm input cells.\n\[FilledSmallSquare] See also: ",
  ButtonBox["PasteBoxFormInlineCells",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  CellTags->{"2.2.14.4", "2.2.14"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PasteBoxFormInlineCells ", "ObjectName",
  CellTags->{"2.2.15.2", "2.2.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PasteBoxFormInlineCells",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " a new inline cell is created when pasting a typeset expression into a \
non-box type cell."
}], "Usage",
  CellTags->{"2.2.15.3", "2.2.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["PasteBoxFormInlineCells \[Rule] Automatic",
    FontFamily->"Courier"],
  ", an inline cell is created when you paste a typeset expression, such as a \
fraction, that has a two-dimensional structure. An inline cell is not created \
if you are pasting a typeset expression made up of a single token.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["PasteBoxFormInlineCells \[Rule] True",
    FontFamily->"Courier"],
  ", a new inline cell is always created when you paste a typeset expression. \
\n\[FilledSmallSquare] With the setting ",
  StyleBox["PasteBoxFormInlineCells \[Rule] False",
    FontFamily->"Courier"],
  ", an inline cell is not created when you paste a typeset expression into a \
cell. An inline cell is created, however, if you paste a typeset expression \
along with a range of text surrounding it. You can also create inline cells \
manually. \n\[FilledSmallSquare] See also: ",
  ButtonBox["AllowInlineCells",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  CellTags->{"2.2.15.4", "2.2.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PrivateEditingOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  ShowClosedCellArea->False,
  Background->None,
  CellTags->"1.3.1.11.1"],

Cell[CellGroupData[{

Cell["\"TwoByteSyntaxCharacterAutoReplacement\"  ", "ObjectName",
  PrivateCellOptions->{"CellDisplayCache"->False},
  CellTags->{"1.3.1.11.2.1", "2.2.17a"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"TwoByteSyntaxCharacterAutoReplacement\"",
    FontFamily->"Courier"],
  " is an option for cells that determines if specified types of Japanese \
input should be interpreted as regular ASCII characters instead of Japanese \
characters denoted by two-byte Kanji codes."
}], "Usage",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.2.2", "2.2.17a"}],

Cell[TextData[{
  "\[FilledSmallSquare] When entering Japanese text using Kanji mode, certain \
characters look similar to regular ASCII characters such as \"[\" or \"]\". \
With the setting ",
  StyleBox["\"TwoByteSyntaxCharacterAutoReplacement\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ",  such characters are interpreted as regular ASCII characters, instead of \
two-byte Kanji characters. This avoids the need to switch out of Kanji mode \
for typing common characters, thereby speeding up the typing of input. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["\"TwoByteSyntaxCharacterAutoReplacement\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", all characters are interpreted as two-byte Kanji characters, when typing \
in Kanji mode. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["\"TwoByteSyntaxCharacterAutoReplacement\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ",  input cells have ",
  StyleBox["\"TwoByteSyntaxCharacterAutoReplacement\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  " while all other types of cells have ",
  StyleBox["\"TwoByteSyntaxCharacterAutoReplacement\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["False.",
    FontFamily->"Courier"]
}], "Notes",
  ShowClosedCellArea->False,
  CellTags->{"1.3.1.11.2.3", "2.2.17a"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CursorTrackerParameters\"", "ObjectName",
  CellTags->{"2.2.7.2", "2.2.17b"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CursorTrackerParameters",
    FontFamily->"Courier"],
  "\" is an option for notebooks that determines details of the elliptical \
spot that appears when the cursor position jumps. "
}], "Usage",
  CellTags->{"2.2.7.3", "2.2.17b"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is specified as a list consisting of \
pairs of numbers. Each pair is of the form ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " where ",
  StyleBox["r",
    FontSlant->"Italic"],
  " is the number of pixels in all directions by which the size of the cursor \
increases and ",
  StyleBox["t",
    FontSlant->"Italic"],
  " is the time in seconds that the cursor stays at that size. The list can \
contain any even number of elements.\n\[FilledSmallSquare] The default \
setting is \"",
  StyleBox["CursorTrackerParameters\" \[Rule] {9,0.1,7,0.02,4,0.02,2,0.02}",
    FontFamily->"Courier"],
  ". This means that the cursor expands by 9 pixels in all directions for 0.1 \
seconds, then shrinks to 7 pixels for 0.2 seconds, 4 pixels for 0.02 seconds, \
and 2 pixels for 0.02 seconds before returning to its normal size. This \
sequence of changes gives the visual appearance of a flashing spot.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["ShowCursorTracker",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.2.7.4", "2.2.17b"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoStyleOptions", "GroupObjectName",
  CellTags->{"2.2.9.2", "2.2.17c"}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["\"UnmatchedBracketStyle\"",
  FontFamily->"Courier"]], "SubObjectNameClosed",
  CellTags->{"2.2.9.2", "2.2.17c"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"UnmatchedBracketStyle\"",
    FontFamily->"Courier"],
  " is an option for notebooks that determines ",
  "if",
  " unmatched brackets are displayed in a special color. "
}], "Usage",
  CellTags->{"2.2.9.3", "2.2.17c"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting, ",
  StyleBox["\"UnmatchedBracketStyle\" \[Rule] \"UnmatchedBracket\"",
    FontFamily->"Courier"],
  ", unpaired brackets are displayed in purple color. This enables them to be \
easily distinguished from the surrounding text, for purposes of editing code. \
However, for this special style to be used, the option ",
  StyleBox["ShowAutoStyles",
    FontFamily->"Courier"],
  " must be set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] With the setting ",
  StyleBox["\"UnmatchedBracketStyle\" \[Rule] None",
    FontFamily->"Courier"],
  ", unpaired brackets have the same color as the surrounding text.\n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["ShowAutoStyles",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.2.9.4", "2.2.17c"}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formatting Options", "Section",
  PageWidth->WindowWidth],

Cell[CellGroupData[{

Cell["Font Options", "InspectorLevel1",
  PageWidth->WindowWidth],

Cell[CellGroupData[{

Cell["FontSize", "ObjectName",
  CellTags->{"2.3.2.2.2", "2.3.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FontSize", "MR"],
  " is an option for characters that determines the size of the font in \
printer's points."
}], "Usage",
  CellTags->{"2.3.2.2.3", "2.3.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The size of a font is typically taken to be the \
distance from the top of the highest character to the bottom of the lowest \
character. \n\[FilledSmallSquare] A printer's point equals ",
  Cell[BoxData[
      \(TraditionalForm\`1\/72\)], "InlineFormula",
    FormatType->StandardForm],
  " of an inch. \n\[FilledSmallSquare] Fonts with the same nominal point size \
may not look the same size to the eye. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.9",
    ButtonData:>{"2.9.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["FontWeight",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FontTracking",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ScriptMinSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ScriptSizeMultipliers",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.2.2.4", "2.3.2.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["FontFamily", "ObjectName",
  CellTags->{"2.3.2.3.2", "2.3.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FontFamily", "MR"],
  " is an option for characters that determines the font family in which text \
is displayed. "
}], "Usage",
  CellTags->{"2.3.2.3.3", "2.3.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica", "TI"],
  " will combine settings for ",
  StyleBox["FontFamily", "MR"],
  ", ",
  StyleBox["FontWeight", "MR"],
  ", ",
  StyleBox["FontSlant", "MR"],
  ", ",
  StyleBox["FontTracking", "MR"],
  ", and sometimes ",
  StyleBox["FontSize", "MR"],
  " to construct a complete name for the font you want. It will then use this \
name, together with any settings you have specified for ",
  StyleBox["FontPostScriptName", "MR"],
  " and ",
  StyleBox["FontNativeName", "MR"],
  ", to try to locate an appropriate font on your particular computer system. \
\n\[FilledSmallSquare] When generating PostScript output on a printer or \
otherwise, settings you give for ",
  StyleBox["FontPostScriptName", "MR"],
  " are typically given precedence over other font specifications. \n\
\[FilledSmallSquare] ",
  StyleBox["Mathematica", "TI"],
  " will try making replacements for the font family name that you specify \
with the option ",
  StyleBox["FontSubstitutions", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["Mathematica", "TI"],
  " by default uses heuristics such as translating ",
  StyleBox["\"Helvetica\"", "MR"],
  " to ",
  StyleBox["\"Geneva\"", "MR"],
  " for appropriate computer systems. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.9",
    ButtonData:>{"2.9.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["StyleForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FontWeight",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FontSlant",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FontTracking",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FontColor",
    ButtonStyle->"RefGuideLink"],
  ", and ",
  ButtonBox["FontSubstitutions",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"2.3.2.3.4", "2.3.2.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["FontWeight", "ObjectName",
  CellTags->{"2.3.2.4.2", "2.3.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FontWeight", "MR"],
  " is an option for characters that determines how heavy the characters in a \
font should be. "
}], "Usage",
  CellTags->{"2.3.2.4.3", "2.3.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] Typical settings are ",
  StyleBox["\"Plain\"", "MR"],
  " and ",
  StyleBox["\"Bold\"", "MR"],
  ". \n\[FilledSmallSquare] For some fonts and on some computer systems, \
additional settings are supported, such as ",
  StyleBox["\"UltraLight\"", "MR"],
  ", ",
  StyleBox["\"Thin\"", "MR"],
  ", ",
  StyleBox["\"ExtraLight\"", "MR"],
  ", ",
  StyleBox["\"Light\"", "MR"],
  ", ",
  StyleBox["\"Book\"", "MR"],
  ", ",
  StyleBox["\"Plain\"", "MR"],
  ", ",
  StyleBox["\"Normal\"", "MR"],
  ", ",
  StyleBox["\"Regular\"", "MR"],
  ", ",
  StyleBox["\"Medium\"", "MR"],
  ", ",
  StyleBox["\"Roman\"", "MR"],
  ",  ",
  StyleBox["\"Demi\"", "MR"],
  ", ",
  StyleBox["\"DemiBold\"", "MR"],
  ", ",
  StyleBox["\"SemiBold\"", "MR"],
  ", ",
  StyleBox["\"ExtraBold\"", "MR"],
  ", ",
  StyleBox["\"Heavy\"", "MR"],
  ", ",
  StyleBox["\"HeavyFace\"", "MR"],
  ", ",
  StyleBox["\"Black\"", "MR"],
  ",  ",
  StyleBox["\"Ultra\"", "MR"],
  ", ",
  StyleBox["\"UltraBlack\"", "MR"],
  ", ",
  StyleBox["\"Fat\"", "MR"],
  ", ",
  StyleBox["\"ExtraBlack\"", "MR"],
  ", and ",
  StyleBox["\"Obese\".", "MR"],
  "\n\[FilledSmallSquare] See also: ",
  ButtonBox["FontFamily",
    ButtonStyle->"RefGuideLink"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.9",
    ButtonData:>{"2.9.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"2.3.2.4.4", "2.3.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["FontSlant", "ObjectName",
  CellTags->{"2.3.2.5.2", "2.3.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FontSlant", "MR"],
  " is an option for characters that determines how slanted the characters in \
a cell should be. "
}], "Usage",
  CellTags->{"2.3.2.5.3", "2.3.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] Typical settings are ",
  StyleBox["\"Plain\"", "MR"],
  ", ",
  StyleBox["\"Italic\"", "MR"],
  " and ",
  StyleBox["\"Oblique\"", "MR"],
  ". \n\[FilledSmallSquare] With the ",
  StyleBox["\"Oblique\"", "MR"],
  " setting, each character typically has the same basic form as with ",
  StyleBox["\"Plain\"", "MR"],
  ", but is slanted. With the ",
  StyleBox["\"Italic\"", "MR"],
  " setting, the basic form is different. Some fonts use ",
  StyleBox["\"Italic\"", "MR"],
  " and some use ",
  StyleBox["\"Oblique\"", "MR"],
  ", but it generally doesn't matter which one you use except when printing \
to a PostScript printer.\n\[FilledSmallSquare] See notes for ",
  ButtonBox["FontFamily",
    ButtonStyle->"RefGuideLink"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.9",
    ButtonData:>{"2.9.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["AutoItalicWords",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SingleLetterItalics",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.2.5.4", "2.3.2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["FontTracking", "ObjectName",
  CellTags->{"2.3.2.6.2", "2.3.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FontTracking", "MR"],
  " is an option for characters that determines how condensed or expanded a \
font should appear. "
}], "Usage",
  CellTags->{"2.3.2.6.3", "2.3.2.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] Typical settings are ",
  StyleBox["\"Condensed\"", "MR"],
  " and ",
  StyleBox["\"Expanded\"", "MR"],
  ". The default is ",
  StyleBox["\"Plain\"", "MR"],
  ". \n\[FilledSmallSquare] For some fonts and on some computer systems, \
additional settings are supported, such as ",
  StyleBox["\"Narrow\"", "MR"],
  ", ",
  StyleBox["\"Compressed\"", "MR"],
  ", ",
  StyleBox["\"Condensed\"", "MR"],
  ", ",
  StyleBox["\"SemiCondensed\"", "MR"],
  ", ",
  StyleBox["\"Extended\"", "MR"],
  ", and ",
  StyleBox["\"Wide\"", "MR"],
  ". \n\[FilledSmallSquare] See notes for ",
  ButtonBox["FontFamily",
    ButtonStyle->"RefGuideLink"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.17"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"2.3.2.6.4", "2.3.2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["FontColor", "ObjectName",
  CellTags->{"2.3.2.7.2", "2.3.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FontColor", "MR"],
  " is an option for characters that determines the color of text. "
}], "Usage",
  CellTags->{"2.3.2.7.3", "2.3.2.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] The setting for ",
  StyleBox["FontColor", "MR"],
  " must be a ",
  StyleBox["CMYKColor", "MR"],
  ", ",
  StyleBox["GrayLevel", "MR"],
  ", ",
  StyleBox["Hue", "MR"],
  ", or ",
  StyleBox["RGBColor", "MR"],
  " directive. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.9",
    ButtonData:>{"2.9.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["Background",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["DefaultColor",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FontWeight",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.2.7.4", "2.3.2.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Background", "ObjectName",
  CellTags->"FontOptionsBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background", "MR"],
  " is an option that determines the background color to use for cells. "
}], "Usage",
  CellTags->"FontOptionsBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background", "MR"],
  " is an option for notebooks, cells, and selections.\n\[FilledSmallSquare] \
With the default setting ",
  StyleBox["Background \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the background color is defined by the system settings. For graphics \
functions, this setting produces a white background on most output devices.\n\
",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  " You can select a custom color with the color dialog box that appears by \
clicking the square symbol to the right of the option. The color is specified \
as an ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " [",
  StyleBox["red",
    FontSlant->"Italic"],
  ", ",
  StyleBox["green",
    FontSlant->"Italic"],
  ", ",
  StyleBox["blue",
    FontSlant->"Italic"],
  "].It can also be specified using ",
  StyleBox["Hue",
    FontFamily->"Courier"],
  " or ",
  StyleBox["CMYKColor",
    FontFamily->"Courier"],
  ", but in these cases the color is automatically converted to ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " by the front end.\n\[FilledSmallSquare] In Text cells, ",
  StyleBox["Background", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["None", "MR"],
  " draws no background rectangle around the text. ",
  StyleBox["Background", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  " draws a background rectangle the same color as the default color for the \
cell. The default color is defined by your system settings.\n\
\[FilledSmallSquare] In a cell, the background color is used only for the \
region inside any cell frame.The space determined by ",
  StyleBox["CellFrameMargins",
    FontFamily->"Courier"],
  " is colored even if ",
  StyleBox["CellFrame",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.9",
    ButtonData:>{"2.9.9", "9.6"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.10.3",
    ButtonData:>{"2.10.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  ", and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["Prolog",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["DefaultColor",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PlotRegion",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FontColor",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->"FontOptionsBackground"]
}, Closed]],

Cell[CellGroupData[{

Cell["CharacterEncoding", "ObjectName",
  CellTags->{"2.3.2.9.2", "2.3.2.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CharacterEncoding", "MR"],
  " is an option for characters that determines what character encoding the \
current font is assumed to have."
}], "Usage",
  CellTags->{"2.3.2.9.3", "2.3.2.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default is ",
  StyleBox["CharacterEncoding \[Rule] Automatic", "MR"],
  ".  With this setting the front end uses information available from the \
operating system to determine the correct encoding to use.  If the font is \
listed in the ",
  StyleBox["DefaultFontProperties",
    FontFamily->"Courier"],
  " option, and a character encoding is specified there, that encoding will \
be used in preference to the one supplied by the system.\n\
\[FilledSmallSquare] The possible settings for ",
  StyleBox["CharacterEncoding", "MR"],
  " are the same as for ",
  StyleBox["$CharacterEncoding", "MR"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.8.8",
    ButtonData:>{"2.8.8", "8.13"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.12.3",
    ButtonData:>{"2.12.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["DefaultFontProperties",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ", ",
  ButtonBox["ToCharacterCode",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FromCharacterCode",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$SystemCharacterEncoding",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.2.9.4", "2.3.2.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Magnification", "ObjectName",
  CellTags->{"2.3.2.10.2", "2.3.2.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Magnification", "MR"],
  " ",
  "is an option for notebooks",
  " that determines at what magnification to display the cell. "
}], "Usage",
  CellTags->{"2.3.2.10.3", "2.3.2.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Magnification", "MR"],
  " is usually set for styles of cells or whole notebooks instead of \
individual cells. \n\[FilledSmallSquare] ",
  StyleBox["Magnification", "MR"],
  " affects spaces between cells as well as individual cells. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"2.3.2.10.4", "2.3.2.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["FontVariations\[LongRightArrow]{\[Ellipsis]} ", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.2.11.2", "2.3.2.11"}],

Cell[CellGroupData[{

Cell[" \"Underline\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.11.2.2", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Underline\"",
    FontFamily->"Courier"],
  " is an option for characters that determines ",
  "if",
  " text should be underlined."
}], "Usage",
  CellTags->{"2.3.2.11.2.3", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"Underline\" \[Rule] False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] This option can also be set using the ",
  StyleBox["Format \[RightTriangle] Face",
    FontFamily->"Helvetica"],
  " menu command. "
}], "Notes",
  CellTags->{"2.3.2.11.2.4", "2.3.2.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"Outline\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.11.3.2", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Outline\"",
    FontFamily->"Courier"],
  " is an option for characters that determines ",
  "if",
  " text is displayed with an outline around each character."
}], "Usage",
  CellTags->{"2.3.2.11.3.3", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"Outline\" \[Rule] False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] This option can also be set using the ",
  StyleBox["Format \[RightTriangle] Face",
    FontFamily->"Helvetica"],
  " menu command. It does not work on all systems or with all fonts. "
}], "Notes",
  CellTags->{"2.3.2.11.3.4", "2.3.2.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"Shadow\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.11.4.2", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["Shadow",
    FontFamily->"Courier"],
  "\" is an option for characters that determines ",
  "if",
  " text is displayed with a dark shadow behind each character."
}], "Usage",
  CellTags->{"2.3.2.11.4.3", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"Shadow\" \[Rule] False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] This option can also be set using the ",
  StyleBox["Format \[RightTriangle] Face",
    FontFamily->"Helvetica"],
  " menu command. It does not work on all systems or with all fonts. "
}], "Notes",
  CellTags->{"2.3.2.11.4.4", "2.3.2.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"StrikeThrough\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.11.5.2", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["StrikeThrough",
    FontFamily->"Courier"],
  "\" is an option for characters that determines ",
  "if",
  StyleBox[" text is displayed ",
    FontVariations->{"StrikeThrough"->False}],
  "with a horizontal line drawn through each character."
}], "Usage",
  CellTags->{"2.3.2.11.5.3", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"StrikeThrough\" \[Rule] False",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.2.11.5.4", "2.3.2.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"Masked\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.11.6.2", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Masked\"",
    FontFamily->"Courier"],
  " is an option for characters that determines ",
  "if",
  StyleBox[" text is hidden by replacing each character with an asterisk. ",
    FontVariations->{"StrikeThrough"->False}]
}], "Usage",
  CellTags->{"2.3.2.11.6.3", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option is useful, for example, in an interface \
requiring a user password, so that passwords typed by a user are not \
displayed on the screen. \n\[FilledSmallSquare] The default setting is ",
  StyleBox["\"Masked\" \[Rule] False",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.2.11.6.4", "2.3.2.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"CompatibilityType\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.11.7.2", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CompatibilityType",
    FontFamily->"Courier"],
  "\" is an option for characters that determines ",
  "if",
  " text is displayed in the subscript or superscript position, instead of at \
the normal height."
}], "Usage",
  CellTags->{"2.3.2.11.7.3", "2.3.2.11"}],

Cell[TextData[{
  " \[FilledSmallSquare] This option is included to maintain consistency with \
Version 2.2, which did not support two-dimensional editing. The use of this \
option is discouraged in new notebooks. In Version 3 and later you can place \
text in the subscript or superscript position directly using keyboard editing \
commands. \n\[FilledSmallSquare] With the setting ",
  StyleBox["\"CompatibilityType\" \[Rule] Superscript",
    FontFamily->"Courier"],
  ", the specified text is raised to the superscript position.     \n \
\[FilledSmallSquare] With the setting ",
  StyleBox["\"CompatibilityType\" \[Rule] Subscript",
    FontFamily->"Courier"],
  ", the specified text is lowered to the subscript position.     \n \
\[FilledSmallSquare] With the default setting ",
  StyleBox["\"CompatibilityType\" \[Rule] Normal",
    FontFamily->"Courier"],
  ", text is positioned at its normal height above the baseline of the cell.  \
"
}], "Notes",
  CellTags->{"2.3.2.11.7.4", "2.3.2.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"RotationAngle\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.11.7.2", "2.3.2.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["RotationAngle",
    FontFamily->"Courier"],
  "\" is an option for characters that determines the angle at which a \
character is oriented with respect to the baseline of the surrounding text. \
(Windows only.)"
}], "Usage",
  CellTags->{"2.3.2.11.7.3", "2.3.2.11"}],

Cell[TextData[{
  " \[FilledSmallSquare] With the default setting, ",
  StyleBox["\"RotationAngle\" \[Rule] 0",
    FontFamily->"Courier"],
  ", the baseline of a character coincides with the baseline of the \
surrounding text."
}], "Notes",
  CellTags->{"2.3.2.11.7.4", "2.3.2.11"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FontProperties\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.2.12.2", "2.3.2.12"}],

Cell[CellGroupData[{

Cell[" \"FontSerifed\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.12.2.2", "2.3.2.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FontSerifed",
    FontFamily->"Courier"],
  "\" is an option for characters that determines ",
  "if",
  " special characters are displayed with or without serifs."
}], "Usage",
  CellTags->{"2.3.2.12.2.3", "2.3.2.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains fonts for entering special characters such as mathematical \
symbols and Greek letters. Typically each of these special fonts is available \
in more than one form (",
  "e.g.",
  " with or without serifs). ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " normally chooses the specific form automatically depending on the \
characteristics of the surrounding text. You can, however, use the ",
  StyleBox["\"FontSerifed\"",
    FontFamily->"Courier"],
  " option to override the automatic settings if you want. \n\
\[FilledSmallSquare] With the setting \"",
  StyleBox["FontSerifed",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] True",
    FontFamily->"Courier"],
  ", special characters are drawn as serifed regardless of the standard \
settings for the font family being used.\n\[FilledSmallSquare] With the \
setting \"",
  StyleBox["FontSerifed",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] False",
    FontFamily->"Courier"],
  ", special characters are drawn sans serif, regardless of the standard \
settings for the font family being used.\n\[FilledSmallSquare] With the \
default setting \"",
  StyleBox["FontSerife",
    FontFamily->"Courier",
    FontProperties->{"FontSerifed"->False}],
  StyleBox["d",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] Automatic",
    FontFamily->"Courier"],
  ", special characters are drawn with or without serifs depending on the \
default settings for the font family being used."
}], "Notes",
  CellTags->{"2.3.2.12.2.4", "2.3.2.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"FontMonospaced\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.12.3.2", "2.3.2.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FontMonospaced",
    FontFamily->"Courier"],
  "\" is an option for characters that determines ",
  "if",
  " special characters are drawn with uniform or variable width."
}], "Usage",
  CellTags->{"2.3.2.12.3.3", "2.3.2.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains fonts for entering special characters such as mathematical \
symbols and Greek letters. Typically each of these fonts is available in more \
than one form (",
  "e.g.",
  " with the characters having uniform or variable widths). ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " normally chooses the specific form automatically depending on the \
characteristics of the surrounding text. You can, however, use the ",
  StyleBox["\"FontMonospaced\"",
    FontFamily->"Courier"],
  " option to override the automatic settings if you want. \n\
\[FilledSmallSquare] With the setting \"",
  StyleBox["FontMonospaced",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] True",
    FontFamily->"Courier"],
  ", all special characters have the same width.\n\[FilledSmallSquare] With \
the setting \"",
  StyleBox["FontMonospaced",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] False",
    FontFamily->"Courier"],
  ", different characters have different widths depending on their shape.\n\
\[FilledSmallSquare] With the default setting \"",
  StyleBox["FontMonospaced",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] Automatic",
    FontFamily->"Courier"],
  ", special characters have equal or unequal widths depending on the default \
settings for the font family being used."
}], "Notes",
  CellTags->{"2.3.2.12.3.4", "2.3.2.12"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["PrivateFontOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.2.13.2", "2.3.2.13"}],

Cell[CellGroupData[{

Cell["\"FontPostScriptName\"", "SubObjectNameClosed",
  CellTags->{"2.3.2.13.2.2", "2.3.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FontPostScriptName",
    FontFamily->"Courier"],
  "\" is an option for characters that identifies the name of the closest \
equivalent PostScript font for a given ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " font."
}], "Usage",
  CellTags->{"2.3.2.13.2.3", "2.3.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] In ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " each characteristic of a font is specified by a separate option such as \
",
  StyleBox["FontFamily",
    FontFamily->"Courier"],
  ", ",
  StyleBox["FontWeight",
    FontFamily->"Courier"],
  ", or ",
  StyleBox["FontSlant",
    FontFamily->"Courier"],
  ". At the time of printing, this information is used to select the closest \
equivalent PostScript font (",
  "e.g.",
  " ",
  StyleBox["\"Times-BoldItalic\"",
    FontFamily->"Courier"],
  "). Occasionally, the selected font may be different from the one you \
intended owing to the lack of a uniform naming convention for PostScript \
fonts. In such cases you can explicitly specify the name of the font to be \
used.\n\[FilledSmallSquare] With the default setting ",
  StyleBox["\"FontPostScriptName\" \[Rule] Automatic",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " automatically chooses an appropriate PostScript font. "
}], "Notes",
  CellTags->{"2.3.2.13.2.4", "2.3.2.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"FontType\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.13.3.2", "2.3.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["FontType",
    FontFamily->"Courier"],
  "\" is an option for characters that determines ",
  "if",
  " a given font is bitmapped or not."
}], "Usage",
  CellTags->{"2.3.2.13.3.3", "2.3.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["\"FontType\" \[Rule] \"Bitmap\"",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.2.13.3.4", "2.3.2.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"OperatorSubstitution\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.13.5.2", "2.3.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["OperatorSubstitution",
    FontFamily->"Courier"],
  "\" is an option for characters that determines ",
  "if",
  " a selected set of characters should be automatically replaced by \
equivalent ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " characters when entered.  "
}], "Usage",
  CellTags->{"2.3.2.13.5.3", "2.3.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting, \"",
  StyleBox["OperatorSubstitution",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] True",
    FontFamily->"Courier"],
  ", special characters such as  {, (, or [ are replaced by the equivalent \
characters in a special ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " font. This allows, for example, spanning characters to change size when \
the expression containing them grows larger.  \n\[FilledSmallSquare] With the \
setting \"",
  StyleBox["OperatorSubstitution",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] False",
    FontFamily->"Courier"],
  ", the above characters are not replaced by equivalent ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " characters. In this case, spanning characters cannot change size \
automatically. "
}], "Notes",
  CellTags->{"2.3.2.13.5.4", "2.3.2.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WindowsUseTrueTypeNames\" ", "SubObjectNameClosed",
  CellTags->{"2.3.2.13.5.2", "2.3.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["WindowsUseTrueTypeNames",
    FontFamily->"Courier"],
  "\" is a notebook option that determines if a predefined set of font \
replacement rules are applied in a notebook. (Windows only)"
}], "Usage",
  CellTags->{"2.3.2.13.5.3", "2.3.2.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting, \"",
  StyleBox["WindowsUseTrueTypeNames",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] True",
    FontFamily->"Courier"],
  ", the fonts Courier, Helvetica, and Times are automatically replaced by \
the fonts Courier New, Arial, and Times Roman, respectively.  \n\
\[FilledSmallSquare] With the setting \"",
  StyleBox["WindowsUseTrueTypeNames",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] False",
    FontFamily->"Courier"],
  ", the above font substitutions are not made. \n\[FilledSmallSquare] This \
option is similar to the global option ",
  StyleBox["FontSubstitutions",
    FontFamily->"Courier"],
  ". The difference is that in the latter case, the font substitution takes \
place only if the original font is not available on the system. With \"",
  StyleBox["WindowsUseTrueTypeNames",
    FontFamily->"Courier"],
  "\" ",
  StyleBox["\[Rule] True",
    FontFamily->"Courier"],
  ", on the other hand, the font substitution takes place unconditionally, \
whether or not the original font is available.\n\[FilledSmallSquare] See \
also: ",
  ButtonBox["FontSubstitutions",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->{"2.3.2.13.5.4", "2.3.2.13"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Text Layout Options", "InspectorLevel1",
  PageWidth->WindowWidth],

Cell[CellGroupData[{

Cell["TextAlignment", "ObjectName",
  CellTags->{"2.3.3.2.2", "2.3.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TextAlignment", "MR"],
  " is an option for cells that determines how successive lines of text \
should be aligned. "
}], "Usage",
  CellTags->{"2.3.3.2.3", "2.3.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are: \n",
  StyleBox["  Left or -1        ",
    FontFamily->"Courier"],
  "aligned on the left\n",
  StyleBox["  Right or +1      ",
    FontFamily->"Courier"],
  "  ",
  "aligned on the right\n  ",
  StyleBox[" Center or 0      ",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Courier"],
  "centered\n     ",
  StyleBox["number",
    FontSlant->"Italic"],
  "                             aligned at any position between -1 and 1\n\
\[FilledSmallSquare] ",
  StyleBox["TextAlignment", "MR"],
  " can be used both for ordinary text and for ",
  StyleBox["Mathematica", "TI"],
  " expressions. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book:",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Section 2.11.1",
    ButtonData:>{"2.11.1", "1.14"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ColumnAlignments",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PageWidth",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.3.2.4", "2.3.3.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["TextJustification", "ObjectName",
  CellTags->{"2.3.3.3.2", "2.3.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TextJustification", "MR"],
  " is an option for cells that determines how lines of text are stretched in \
order to make them the same length. "
}], "Usage",
  CellTags->{"2.3.3.3.3", "2.3.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TextJustification", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["0", "MR"],
  " does no stretching and leads to ragged text boundaries. \n\
\[FilledSmallSquare] ",
  StyleBox["TextJustification", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["1", "MR"],
  " does full justification and forces all complete lines to be the same \
length. \n\[FilledSmallSquare] No stretching is done on lines that end with \
explicit \[ReturnKey] characters. \n\[FilledSmallSquare] With settings for ",
  StyleBox["TextJustification", "MR"],
  " between 0 and 1, partial justification is done. \n\[FilledSmallSquare] \
With ",
  StyleBox["TextJustification", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["s", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will insert extra space within a line equal to ",
  StyleBox["s",
    FontSlant->"Italic"],
  " times the amount by which the line is shorter than ",
  StyleBox["PageWidth", "MR"],
  ".\n\[FilledSmallSquare] If ",
  StyleBox["TextJustification", "MR"],
  " is not ",
  StyleBox["0", "MR"],
  ", the ",
  StyleBox["Mathematica", "TI"],
  " front end will dynamically adjust the lengths of lines as you enter text. \
\n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TextAlignment",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PageWidth",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AutoSpacing",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonExpandable",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.3.3.4", "2.3.3.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyphenation", "ObjectName",
  CellTags->{"2.3.3.3.2", "2.3.3.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Hyphenation", "MR"],
  " is an option for cells that determines ",
  "if",
  " text should be hyphenated.  "
}], "Usage",
  CellTags->{"2.3.3.3.3", "2.3.3.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["Hyphenation", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Times New Roman"],
  StyleBox["True",
    FontFamily->"Courier"],
  ", a word too long to fit at the end of a line is hyphenated.  The default \
setting is ",
  StyleBox["Hyphenation", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Times New Roman"],
  StyleBox["False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] The minimum number of characters that can be split \
off the start or end of a word is specified by the option ",
  StyleBox["\"HyphenationMinLengths\"",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] In order for a line to end with a hyphenated word, \
the line must end before a band on the right edge of the page whose width is \
specified by the option ",
  StyleBox["\"HyphenationFreeZone\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["HyphenationOptions",
    ButtonData:>"HyphenationOptions",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  " ."
}], "Notes",
  CellTags->{"2.3.3.3.4", "2.3.3.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell["TabFilling", "ObjectName",
  CellTags->{"2.3.3.4.2", "2.3.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare]  ",
  StyleBox["TabFilling",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines how a \[TabKey] space is represented on the screen."
}], "Usage",
  CellTags->{"2.3.3.4.3", "2.3.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TabFilling",
    FontFamily->"Courier"],
  " can be set to any character. With the default setting ",
  StyleBox["TabFilling \[Rule] None",
    FontFamily->"Courier"],
  ", \[TabKey] spaces appear as white space.\n\[FilledSmallSquare] If ",
  StyleBox["TabFilling",
    FontFamily->"Courier"],
  " is set to a string, such as ",
  StyleBox["\".\"",
    FontFamily->"Courier"],
  ", the character(s) in the string will be repeated as necessary to fill the \
available space. \n\[FilledSmallSquare] Other common settings are ",
  StyleBox["Underline",
    FontFamily->"Courier"],
  " and ",
  StyleBox["GrayUnderline",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.3.4.4", "2.3.3.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["LineSpacing", "ObjectName",
  CellTags->{"2.3.3.5.2", "2.3.3.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LineSpacing", "MR"],
  " ",
  "is an option for cells",
  " that determines the spacing between successive lines of text. "
}], "Usage",
  CellTags->{"2.3.3.5.3", "2.3.3.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LineSpacing", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  "{",
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["0}", "MR"],
  " leaves space so that the total height of each line is ",
  StyleBox["c", "TI"],
  " times the height of its contents. \n\[FilledSmallSquare] ",
  StyleBox["LineSpacing", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  "{",
  StyleBox["0,", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["}", "MR"],
  " makes the total height of each line exactly ",
  StyleBox["n", "TI"],
  " printer's points. \n\[FilledSmallSquare] ",
  StyleBox["LineSpacing", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  "{",
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["}", "MR"],
  " makes the total height ",
  StyleBox["c", "TI"],
  " times the height of the contents plus ",
  StyleBox["n", "TI"],
  " printer's points. \n\[FilledSmallSquare] A typical default setting is ",
  StyleBox["LineSpacing", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["{1,", "MR"],
  " ",
  StyleBox["1}", "MR"],
  ", which leaves space for the contents of the line and adds 1 printer's \
point (",
  Cell[BoxData[
      \(TraditionalForm\`1\/72\)], "InlineFormula",
    FormatType->StandardForm],
  " of an inch) of extra space. \n\[FilledSmallSquare] ",
  StyleBox["LineSpacing", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["{2,", "MR"],
  " ",
  StyleBox["0}", "MR"],
  " makes text double spaced. \n\[FilledSmallSquare] ",
  StyleBox["LineSpacing", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula",
    FormatType->StandardForm],
  StyleBox["1,", "MR"],
  " ",
  StyleBox["-", "MR"],
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FormatType->StandardForm],
  " tightens text by ",
  StyleBox["n", "TI"],
  " printer's points. \n\[FilledSmallSquare] ",
  StyleBox["LineSpacing", "MR"],
  " applies both to ordinary text and ",
  StyleBox["Mathematica", "TI"],
  " expressions. \n\[FilledSmallSquare] In ordinary text, ",
  StyleBox["LineSpacing", "MR"],
  " determines the spacing between lines produced by automatic line breaks. \
For lines produced by explicit \[ReturnKey] characters, ",
  StyleBox["ParagraphSpacing", "MR"],
  " is added. \n\[FilledSmallSquare] In ",
  StyleBox["Mathematica", "TI"],
  " expressions, ",
  StyleBox["LineSpacing", "MR"],
  " is used if lines are produced by automatic ",
  "line breaks",
  " or by explicit \[ReturnKey] characters. \n\[FilledSmallSquare] Extra \
space specified by ",
  StyleBox["LineSpacing", "MR"],
  " is inserted equally above and below a line, except that no extra space is \
inserted before the first line or after the last line of an expression or \
cell. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.12"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["FontSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ParagraphSpacing",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.3.5.4", "2.3.3.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ParagraphSpacing", "ObjectName",
  CellTags->{"2.3.3.6.2", "2.3.3.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ParagraphSpacing", "MR"],
  " is an option for cells that determines how much extra space to leave \
between successive paragraphs of text. "
}], "Usage",
  CellTags->{"2.3.3.6.3", "2.3.3.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ParagraphSpacing", "MR"],
  StyleBox[" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["0", "MR"],
  "} leaves an extra space of ",
  StyleBox["c", "TI"],
  " times the height of the font in the paragraph. \n\[FilledSmallSquare] ",
  StyleBox["ParagraphSpacing", "MR"],
  StyleBox[" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["0,", "MR"],
  " ",
  StyleBox["n", "TI"],
  "} leaves an extra space of exactly ",
  StyleBox["n", "TI"],
  " printer's points, where 72 points equal one inch. \n\[FilledSmallSquare] \
",
  StyleBox["ParagraphSpacing", "MR"],
  StyleBox[" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  " leaves an extra space of ",
  StyleBox["c", "TI"],
  " times the height of the font plus ",
  StyleBox["n", "TI"],
  " printer's points. \n\[FilledSmallSquare] Paragraph breaks occur whenever \
an explicit \[ReturnKey] character appears in a block of text. \n\
\[FilledSmallSquare] ",
  StyleBox["ParagraphSpacing", "MR"],
  " is added to ",
  StyleBox["LineSpacing", "MR"],
  " to determine spacing between paragraphs. \n\[FilledSmallSquare] A typical \
default setting is ",
  StyleBox["ParagraphSpacing", "MR"],
  "\[Rule]",
  StyleBox["{0,", "MR"],
  " ",
  StyleBox["0}", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ParagraphSpacing", "MR"],
  " applies only to ordinary text, not ",
  StyleBox["Mathematica", "TI"],
  " expressions. \n\[FilledSmallSquare] Extra space specified by ",
  StyleBox["ParagraphSpacing", "MR"],
  " is inserted before the first line of each paragraph. No extra space is \
inserted if the paragraph is at the beginning of a cell or a string. \n\
\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.12"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["LineSpacing",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ParagraphIndent",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.3.6.4", "2.3.3.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ParagraphIndent", "ObjectName",
  CellTags->{"2.3.3.7.2", "2.3.3.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ParagraphIndent", "MR"],
  " ",
  "is an option for cells",
  " that determines how far to indent the first line of each paragraph of \
text. "
}], "Usage",
  CellTags->{"2.3.3.7.3", "2.3.3.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ParagraphIndent", "MR"],
  " is specified in printer's points, where 72 points equal one inch.\n\
\[FilledSmallSquare] A new paragraph starts at the beginning of a cell and \
after every explicit \[ReturnKey] character in your text. \n\
\[FilledSmallSquare] Negative settings for ",
  StyleBox["ParagraphIndent", "MR"],
  " make the first line of each paragraph stick out to the left. \n\
\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.10",
    ButtonData:>{"2.11.10", "10.2"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["AutoIndent",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LineIndent",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ParagraphSpacing",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.3.7.4", "2.3.3.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["TabSpacings ", "ObjectName",
  CellTags->{"2.3.3.8.2", "2.3.3.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TabSpacings",
    FontFamily->"Courier"],
  " is an option for cells that determines the number of spaces, in ems, that \
the cursor advances when the \[TabKey] key is pressed."
}], "Usage",
  CellTags->{"2.3.3.8.3", "2.3.3.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option only applies to text cells. The default \
setting is ",
  StyleBox["TabSpacings \[Rule] 4",
    FontFamily->"Courier"],
  ".\t"
}], "Notes",
  CellTags->{"2.3.3.8.4", "2.3.3.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoItalicWords ", "ObjectName",
  CellTags->{"2.3.3.9.2", "2.3.3.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoItalicWords",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines a set of words that are automatically italicized when \
typed into a notebook. "
}], "Usage",
  CellTags->{"2.3.3.9.3", "2.3.3.9"}],

Cell[TextData[{
  " \[FilledSmallSquare] The default setting is ",
  StyleBox["AutoItalicWords \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["\"Mathematica\"",
    FontFamily->"Courier"],
  ", \"",
  StyleBox["MathLink\"",
    FontFamily->"Courier"],
  ", \"",
  StyleBox["MathSource\"",
    FontFamily->"Courier"],
  ", \"",
  StyleBox["MathReader",
    FontFamily->"Courier"],
  StyleBox["\"}",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.3.9.4", "2.3.3.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["HyphenationOptions\[LongRightArrow]{\[Ellipsis]} ", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.3.10.2", "2.3.3.10"}],

Cell[CellGroupData[{

Cell["\"HyphenationFreeZone\"", "SubObjectNameClosed",
  CellTags->{"2.3.3.10.2.2", "2.3.3.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"HyphenationFreeZone\"",
    FontFamily->"Courier"],
  " is an option for cells that specifies a zone in which no end-line \
hyphenation occurs."
}], "Usage",
  CellTags->{"2.3.3.10.2.3", "2.3.3.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is \"",
  StyleBox["HyphenationFreeZone",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["36",
    FontFamily->"Courier"],
  ".",
  " This means that if the last complete word in a line ends within half an \
inch from the right edge of the page, the next word advances to the following \
line instead of being hyphenated."
}], "Notes",
  CellTags->{"2.3.3.10.2.4", "2.3.3.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"HyphenationCharacter\"", "SubObjectNameClosed",
  CellTags->{"2.3.3.10.3.2", "2.3.3.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"HyphenationCharacter\"",
    FontFamily->"Courier"],
  " is an option for cells that determines the character used to represent a \
hyphen."
}], "Usage",
  CellTags->{"2.3.3.10.3.3", "2.3.3.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["HyphenationCharacter\"",
    FontFamily->"Courier"],
  " can be set to any character, including special characters and symbols.  \
The default setting is \"",
  StyleBox["HyphenationCharacter",
    FontFamily->"Courier"],
  "\"",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  "\"",
  StyleBox["\[Backslash][Hyphen]",
    FontFamily->"Courier"],
  "\".\n\[FilledSmallSquare] Another common choice used for line breaks in \
equations is ",
  StyleBox["\"HyphenationCharacter\" \[Rule] \"\[Backslash][Continuation]\"",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.3.10.3.4", "2.3.3.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"HyphenationMinLengths\"", "SubObjectNameClosed",
  CellTags->{"2.3.3.10.4.2", "2.3.3.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"HyphenationMinLengths\"",
    FontFamily->"Courier"],
  " is an option for cells that determines the minimum number of characters \
that can be split off the start and end of a word when it is hyphenated. "
}], "Usage",
  CellTags->{"2.3.3.10.4.3", "2.3.3.10"}],

Cell[TextData[{
  "\[FilledSmallSquare]  \"",
  StyleBox["HyphenationMinLengths",
    FontFamily->"Courier"],
  "\" ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  "{",
  StyleBox["m",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " means that a minimum of ",
  StyleBox["m ",
    FontSlant->"Italic"],
  "and",
  StyleBox[" n",
    FontSlant->"Italic"],
  " characters can be split off the start and end of a word respectively. The \
default setting is \"",
  StyleBox["HyphenationMinLengths",
    FontFamily->"Courier"],
  "\" ",
  StyleBox[" \[Rule] {3",
    FontFamily->"Courier"],
  ", ",
  StyleBox["3}",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.3.10.4.4", "2.3.3.10"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Text Content Options", "InspectorLevel1",
  PageWidth->WindowWidth],

Cell[CellGroupData[{

Cell["LanguageCategory ", "ObjectName",
  CellTags->{"2.3.4.2.2", "2.3.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LanguageCategory",
    FontFamily->"Courier"],
  " is an option for cells that determines the category of language used to \
interpret a word when its spelling is checked."
}], "Usage",
  CellTags->{"2.3.4.2.3", "2.3.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["LanguageCategory \[Rule] \"NaturalLanguage\"",
    FontFamily->"Courier"],
  ", the word is interpreted in a human natural language such as English, \
French, or German. The specific language used is determined by the setting \
for the option ",
  StyleBox["DefaultNaturalLanguage",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] With the setting ",
  StyleBox["LanguageCategory \[Rule] \"Formula\"",
    FontFamily->"Courier"],
  ", the word is interpreted as belonging to a mathematical formula.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["LanguageCategory \[Rule] \"Mathematica\"",
    FontFamily->"Courier"],
  ", the word is interpreted as part of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " command. \n\[FilledSmallSquare] With the setting ",
  StyleBox["LanguageCategory \[Rule] \"None\"",
    FontFamily->"Courier"],
  ", the word is ignored in a spelling check. \n\[FilledSmallSquare] The \
value of ",
  StyleBox["LanguageCategory",
    FontFamily->"Courier"],
  " is usually set for specific cell styles in the style sheet. Typical \
settings are: ",
  StyleBox["\"NaturalLanguage\"",
    FontFamily->"Courier"],
  " for Text cells; ",
  StyleBox["\"Mathematica\"",
    FontFamily->"Courier"],
  " for Input cells; and ",
  StyleBox["\"None\"",
    FontFamily->"Courier"],
  " for Output and Graphics cells.\n\[FilledSmallSquare] See also:  ",
  StyleBox[ButtonBox["DefaultNaturalLanguage",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.4.2.4", "2.3.4.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DefaultNaturalLanguage ", "ObjectName",
  CellTags->{"2.3.4.3.2", "2.3.4.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DefaultNaturalLanguage",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the language used when checking the spelling of a word in \
a human natural language cell."
}], "Usage",
  CellTags->{"2.3.4.3.3", "2.3.4.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] Human natural language cells are ones which have ",
  StyleBox["LanguageCategory \[Rule] \"NaturalLanguage\"",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] With the default setting ",
  StyleBox["DefaultNaturalLanguage \[Rule] \"Language\"",
    FontFamily->"Courier"],
  ", the language is taken to be the current setting of the option ",
  StyleBox["$Language",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] The language can also be specified explicitly as a \
string, for example, by setting ",
  StyleBox["DefaultNaturalLanguage",
    FontFamily->"Courier"],
  " to ",
  StyleBox["\"English\"",
    FontFamily->"Courier"],
  ", \"",
  StyleBox["French",
    FontFamily->"Courier"],
  "\", or ",
  StyleBox["\"German\"",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] This option is typically set at the global level \
but it can also be set at the level of an individual notebook or cell. \n\
\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["LanguageCategory",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.4.3.4", "2.3.4.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SpellingOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.4.4.2", "2.3.4.4"}],

Cell[TextData[{
  StyleBox["SpellingOptions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a group of global options that control the criteria used in performing \
a spelling check."
}], "Text",
  CellTags->"2.3.4.4"],

Cell[CellGroupData[{

Cell["\"AlwaysStop\"", "SubObjectNameClosed",
  CellTags->{"2.3.4.4.2.2", "2.3.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"AlwaysStop\"",
    FontFamily->"Courier"],
  " is an option for cells that specifies criteria for stopping a spelling \
check."
}], "Usage",
  CellTags->{"2.3.4.4.2.3", "2.3.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"AlwaysStop\"",
    FontFamily->"Courier"],
  " is specified as a list of conditions to be tested. If a word being tested \
satisfies any of the conditions, the spelling check stops at that word.\n\
\[FilledSmallSquare] This option allows you to generalize a spelling check to \
search for errors other than ordinary spelling errors. The default setting is \
",
  StyleBox["\"AlwaysStop\" \[Rule] {\"UncapitalizedStartOfSentence\", \
\"RepeatedWords\"}. \n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] Possible settings are as follows.",
  StyleBox["\n \"WordsInAllCaps\"               \"WordsWithNumbers\" \n \
\"SingleCharacterWords\"\t\t    \"Numbers\"\n \"CaseDifferences\"             \
 \"EncliticForms\" \n \"RepeatedWords\"                \"HyphenatedWords\" \n \
\"RomanNumerals\"                \"WordsWithUnderscores\" \n \
\"AlternateSpellings\"           \"WordsWithInternalCapitals\"\n \
\"UncapitalizedStartOfSentence\"  ",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"2.3.4.4.2.4", "2.3.4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"AlwaysSkip\"", "SubObjectNameClosed",
  CellTags->{"2.3.4.4.3.2", "2.3.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"AlwaysSkip\"",
    FontFamily->"Courier"],
  " is an option for cells that specifies criteria for skipping words during \
a spelling check. "
}], "Usage",
  CellTags->{"2.3.4.4.3.3", "2.3.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["AlwaysSkip",
    FontFamily->"Courier"],
  "\" is specified as a list of conditions to be tested. If a word being \
tested satisfies any of the conditions, the spell checker skips that word. \n\
\[FilledSmallSquare] The settings for",
  StyleBox["\"AlwaysStop\"",
    FontFamily->"Courier"],
  " override those for ",
  StyleBox["\"AlwaysSkip\"",
    FontFamily->"Courier"],
  " if the same condition is specified for both options. \n\
\[FilledSmallSquare] This option allows you to customize a spelling check to \
ignore certain types of words. ",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] Possible settings are as follows.",
  StyleBox["\n \"WordsInAllCaps\"               \"WordsWithNumbers\" \n \
\"SingleCharacterWords\"\t\t    \"Numbers\"\n \"CaseDifferences\"             \
 \"EncliticForms\" \n \"RepeatedWords\"                \"HyphenatedWords\" \n \
\"RomanNumerals\"                \"WordsWithUnderscores\" \n \
\"AlternateSpellings\"           \"WordsWithInternalCapitals\"\n \
\"UncapitalizedStartOfSentence\"  \n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] The default setting is  ",
  StyleBox["\"AlwaysSkip\" \[Rule] {\"SingleCharacterWords\"",
    FontFamily->"Courier"],
  ",  ",
  StyleBox["\"Numbers\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"WordsWithNumbers\"",
    FontFamily->"Courier"],
  ",  ",
  StyleBox["\"WordsInAllCaps\"}. ",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"2.3.4.4.3.4", "2.3.4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"WordSplitting\"", "SubObjectNameClosed",
  CellTags->{"2.3.4.4.4.2", "2.3.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"WordSplitting\"",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " compound words of a given type should be split up before being tested by \
the spelling checker. "
}], "Usage",
  CellTags->{"2.3.4.4.4.3", "2.3.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] When the spelling checker encounters a compound word \
of a type specified in ",
  StyleBox["\"WordSplitting\"",
    FontFamily->"Courier"],
  ", it splits the word and tests each of its component words separately. The \
default setting is ",
  StyleBox["\"WordSplitting\"",
    FontFamily->"Courier"],
  StyleBox[" \[Rule] ",
    FontFamily->"Times New Roman"],
  StyleBox["{\"Hyphen\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Underscore\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"InternalCapitals\"}.\n\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " With the setting ",
  StyleBox["\"WordSplitting\" \[Rule] \"All\"",
    FontFamily->"Courier"],
  ", the spell checker will attempt to split up compound words even if they \
are not internally capitalized or hyphenated or have no underscore.  For \
example, \"shortstop\" could be tested as \"short\" and \"stop\". "
}], "Notes",
  CellTags->{"2.3.4.4.4.4", "2.3.4.4"}]
}, Closed]],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Check Spelling...",
    ButtonData:>"Check Spelling",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Text",
  CellTags->"2.3.4.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["SpellingDictionaries\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.4.5.2", "2.3.4.5"}],

Cell[CellGroupData[{

Cell["\"CorrectWords\" ", "SubObjectNameClosed",
  CellTags->{"2.3.4.5.2.2", "2.3.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"CorrectWords\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that specifies a list of words to add to the main dictionary. "
}], "Usage",
  CellTags->{"2.3.4.5.2.3", "2.3.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["CorrectWords",
    FontFamily->"Courier"],
  "\" ",
  StyleBox[" \[Rule] {\"",
    FontFamily->"Courier"],
  StyleBox["word1",
    FontSlant->"Italic"],
  StyleBox["\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["word2",
    FontSlant->"Italic"],
  StyleBox["\"",
    FontFamily->"Courier"],
  ",  .",
  StyleBox["....}",
    FontFamily->"Courier"],
  " means that if any of the words in the list is found during a spelling \
check, it is skipped even if it does not exist in the main dictionary. \n\
\[FilledSmallSquare] The default setting is \"",
  StyleBox["CorrectWords",
    FontFamily->"Courier"],
  "\" ",
  StyleBox[" \[Rule] {}.",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] This option is typically set at the global level, \
but it can also be set at the level of an individual notebook or cell. "
}], "Notes",
  CellTags->{"2.3.4.5.2.4", "2.3.4.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncorrectWords\"", "SubObjectNameClosed",
  CellTags->{"2.3.4.5.3.2", "2.3.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"IncorrectWords\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that specifies a list of words to subtract from the main dictionary. "
}], "Usage",
  CellTags->{"2.3.4.5.3.3", "2.3.4.5"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"IncorrectWords\" \[Rule] {\"",
    FontFamily->"Courier"],
  StyleBox["word",
    FontSlant->"Italic"],
  "1",
  StyleBox["\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"",
    FontFamily->"Courier"],
  StyleBox["word",
    FontSlant->"Italic"],
  "2",
  StyleBox["\"",
    FontFamily->"Courier"],
  ",  .",
  StyleBox["....}",
    FontFamily->"Courier"],
  " means that if any of the words in the list is found, the spelling check \
stops, even if the word exists in the main dictionary.\n\[FilledSmallSquare] \
The default setting is \"",
  StyleBox["InCorrectWords",
    FontFamily->"Courier"],
  "\" ",
  StyleBox[" \[Rule] {}.",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] This option is typically set at the global level, \
but it can also be set at the level of an individual notebook or cell. "
}], "Notes",
  CellTags->{"2.3.4.5.3.4", "2.3.4.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Suggestions\"", "SubObjectNameClosed",
  CellTags->{"2.3.4.5.4.2", "2.3.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare]  ",
  StyleBox["\"Suggestions\"",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that specifies a list of words to subtract from the main dictionary along \
with a suggested alternative for each word. "
}], "Usage",
  CellTags->{"2.3.4.5.4.3", "2.3.4.5"}],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"Suggestions\" \[Rule] {{\"",
    FontFamily->"Courier"],
  StyleBox["word",
    FontSlant->"Italic"],
  "1",
  StyleBox["\" \[Rule] \"",
    FontFamily->"Courier"],
  StyleBox["newword",
    FontSlant->"Italic"],
  "1",
  StyleBox["\"",
    FontSlant->"Italic"],
  "}",
  StyleBox[",",
    FontSlant->"Italic"],
  StyleBox[" .....}",
    FontFamily->"Courier"],
  " means that if any of the words in the list is found, the spelling check \
stops and the corresponding new word is offered as an alternative in the \
spell check dialog box. \n\[FilledSmallSquare] The default setting is \"",
  StyleBox["Suggestions",
    FontFamily->"Courier"],
  "\" ",
  StyleBox[" \[Rule] {}.",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] This option is typically set at the global level, \
but it can also be set at the level of an individual notebook or cell. "
}], "Notes",
  CellTags->{"2.3.4.5.4.4", "2.3.4.5"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Expression Formatting", "InspectorLevel1",
  PageWidth->WindowWidth,
  Background->None],

Cell[CellGroupData[{

Cell["FormatType", "ObjectName",
  CellTags->"2.3.5"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FormatType",
    FontFamily->"Courier"],
  " is an option for cells that determines the format used for displaying \
expressions in a cell. "
}], "Usage",
  CellTags->"2.3.5"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " The default format for newly created cells of a given style is determined \
by the option ",
  StyleBox["DefaultFormatType",
    FontFamily->"Courier"],
  ", which is typically specified in the style sheet. ",
  StyleBox["FormatType",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times"],
  " on the other hand, can be used to explicitly change the format for an \
existing cell.",
  StyleBox["\n\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " Possible settings are: ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ", ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Times"],
  " and ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book: ", "TI"],
  ButtonBox["Section 1.10.9",
    ButtonData:>{"1.10.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.9.1",
    ButtonData:>{"2.9.1", "1.10"},
    ButtonStyle->"MainBookLink"],
  ".\n",
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " See also: ",
  ButtonBox["DefaultFormatType",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->"2.3.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Display Options", "SubsubsectionIcon",
  PageWidth->WindowWidth,
  Background->None],

Cell[CellGroupData[{

Cell["AutoSpacing", "ObjectName",
  CellTags->"2.3.5.2x"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoSpacing", "MR"],
  " is an option for cells that determines ",
  "if",
  " spaces between successive characters should be adjusted automatically. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.2.3", "2.3.5.2x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoSpacing", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  " leaves equal spaces between all characters. \n\[FilledSmallSquare] ",
  StyleBox["AutoSpacing", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  " inserts additional space around lower\[Hyphen]precedence operators. \n\
\[FilledSmallSquare] ",
  StyleBox["AutoSpacing", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  " is automatically used inside ordinary strings and comments. \n\
\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.32"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.2.4", "2.3.5.2x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowContents ", "ObjectName",
  CellTags->{"2.3.5.2.3.2", "2.3.5.3x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowContents",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an object represented by a ",
  StyleBox["StyleBox",
    FontFamily->"Courier"],
  " should be displayed on the screen or replaced by blank space.  "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.3.3", "2.3.5.3x"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["ShowContents \[Rule] False",
    FontFamily->"Courier"],
  ", any ",
  StyleBox["StyleBox",
    FontFamily->"Courier"],
  " object is not displayed on the screen. It is replaced by an amount of \
blank space equal to the width of the expression. This feature is useful for \
adding blank space of an exact length, such as for aligning text appearing on \
successive lines of a cell.\n\[FilledSmallSquare] With the default setting ",
  StyleBox["ShowContents \[Rule] True",
    FontFamily->"Courier"],
  ",  a ",
  StyleBox["StyleBox",
    FontFamily->"Courier"],
  " object is displayed on the screen like any other input.  "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.3.4", "2.3.5.3x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ScriptSizeMultipliers", "ObjectName",
  CellTags->{"2.3.5.2.4.2", "2.3.5.4x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ScriptSizeMultipliers", "MR"],
  " is an option for cells that determines how much smaller to render each \
successive level of subscripts, etc. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.4.3", "2.3.5.4x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ScriptSizeMultipliers",
    FontFamily->"Courier"],
  " is used in conjunction with ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " to determine the font size of characters that appear in constructs such \
as subscripts, superscripts, underscripts, overscripts, and built\[Hyphen]up \
fractions. \n\[FilledSmallSquare] The default setting for ",
  StyleBox["ScriptSizeMultipliers", "MR"],
  " is ",
  StyleBox["0.71", "MR"],
  ", yielding approximately a factor of two reduction in character area at \
each level. \n\[FilledSmallSquare] ",
  StyleBox["ScriptSizeMultipliers", "MR"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " {",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"s\\\\\\\"\\\", \\\"TI\
\\\"]\\)\"\>", "1"], TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"s\\\\\\\"\\\", \\\"TI\
\\\"]\\)\"\>", "2"], TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  StyleBox[",", "MR"],
  " \[Ellipsis] ",
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"s\\\\\\\"\\\", \\\"TI\
\\\"]\\)\"\>", "n"], TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FormatType->StandardForm],
  " uses multiplier ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"s\\\\\\\"\\\", \\\"TI\
\\\"]\\)\"\>", "i"], TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  " for level ",
  StyleBox["i", "TI"],
  " and multiplier ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"s\\\\\\\"\\\", \\\"TI\
\\\"]\\)\"\>", "n"], TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  " for levels ",
  StyleBox["n", "TI"],
  " and beyond. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.55"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ScriptMinSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ScriptBaselineShifts",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.4.4", "2.3.5.4x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ScriptMinSize", "ObjectName",
  CellTags->{"2.3.5.2.5.2", "2.3.5.5x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ScriptMinSize", "MR"],
  " is an option for cells that determines the minimum font size to use in \
rendering subscripts, etc. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.5.3", "2.3.5.5x"}],

Cell[TextData[{
  "\[FilledSmallSquare] Settings for ",
  StyleBox["ScriptMinSize", "MR"],
  " are in units of printer's points, where 72 points equal one inch. \n\
\[FilledSmallSquare] ",
  StyleBox["ScriptMinSize", "MR"],
  " is used for characters that appear in constructs such as subscripts, \
superscripts, underscripts, overscripts, and built\[Hyphen]up fractions. \n\
\[FilledSmallSquare] ",
  StyleBox["ScriptMinSize", "MR"],
  " is typically set larger in styles used for screen display than in those \
used for printing. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.55"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ScriptSizeMultipliers",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FontSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ScriptBaselineShifts",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.5.4", "2.3.5.5x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ScriptLevel  ", "ObjectName",
  CellTags->{"2.3.5.2.6.2", "2.3.5.6x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " is an option for characters that determines the font size of modifiers \
such as subscripts and superscripts in a nested expression. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.6.3", "2.3.5.6x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " has a starting value of 0 for math editor cells and 1 for inline cells. \
Its value increases by 1 for each level at which a subscript or superscript \
is added, starting with a value of 1 for base level characters. \n\
\[FilledSmallSquare] ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " has a starting value of 0 for math editor cells and 1 for inline cells. A \
few special characters, including \[Sum], \[Product], and \[Integral] are \
displayed in a larger font size when ",
  StyleBox["ScriptLevel \[Rule] 0",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " is used in conjunction with ",
  StyleBox["ScriptSizeMultipliers.",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["ScriptMinSize",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ", ",
  StyleBox[ButtonBox["ScriptSizeMultipliers",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Courier"]
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.6.4", "2.3.5.6x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ShowStringCharacters", "ObjectName",
  CellTags->{"2.3.5.2.7.2", "2.3.5.7x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowStringCharacters", "MR"],
  " is an option for cells that determines ",
  "if",
  " to display the quotation marks around a string.  "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.7.3", "2.3.5.7x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ShowStringCharacters", "MR"],
  " also affects the display of backslashes in strings. If either the quotes \
are unbalanced or the string contains illegal escaped characters (",
  "e.g.",
  ", \\x is not legal), a warning message will be issued and the string \
displayed as if ",
  StyleBox["ShowStringCharacters \[Rule] False", "MR"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["ShowStringCharacters", "MR"],
  " is typically set to ",
  StyleBox["False", "MR"],
  " for output cells and ",
  StyleBox["True", "MR"],
  " for input cells. \n\[FilledSmallSquare] ",
  StyleBox["ShowStringCharacters", "MR"],
  " is usually set at the level of styles or notebooks rather than at the \
level of individual cells. \n\[FilledSmallSquare] See also: ",
  ButtonBox["ShowSpecialCharacters",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.7.4", "2.3.5.7x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["NumberMarks", "ObjectName",
  CellTags->{"2.3.5.2.8.2", "2.3.5.8x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NumberMarks", "MR"],
  " is an option for cells that determines ",
  "if",
  " ",
  StyleBox["`", "MR"],
  " marks should be included in the printed forms of approximate numbers. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.8.3", "2.3.5.8x"}],

Cell[TextData[{
  "\[FilledSmallSquare] Number marks are used to indicate the type of numbers \
and their precision or accuracy.\n\[FilledSmallSquare] With the setting ",
  StyleBox["NumberMarks", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  ", a number with ",
  StyleBox["`", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times New Roman"],
  " ",
  StyleBox["``", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times New Roman"],
  " or *",
  StyleBox["^", "MR"],
  " is shown with those characters. This is the default for input styles.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["NumberMarks", "MR"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  StyleBox["False", "MR"],
  ", a number is rounded to the precision or accuracy given and scientific \
notation is used, if appropriate.  \n\[FilledSmallSquare] The ",
  StyleBox["*^", "MR"],
  " form for scientific notation is always used in ",
  StyleBox["InputForm", "MR"],
  " and is independent of ",
  StyleBox["NumberMarks", "MR"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.12.3",
    ButtonData:>{"2.12.3", "3.24"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 3.1.4",
    ButtonData:>{"3.1.4", "4.24"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["NumberForm",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PrintPrecision",
    ButtonStyle->"OtherInformationLinkMR"],
  ".  "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.8.4", "2.3.5.8x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PrintPrecision ", "ObjectName",
  CellTags->{"2.3.5.2.9.2", "2.3.5.9x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PrintPrecision",
    FontFamily->"Courier"],
  " is an option for cells that determines the maximum number of digits used \
for displaying a machine precision number. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.9.3", "2.3.5.9x"}],

Cell[TextData[{
  "\[FilledSmallSquare] Machine precision numbers are typically generated by \
numeric evaluations in the kernel and are indicated by a ` at the end. The \
setting for ",
  StyleBox["PrintPrecision",
    FontFamily->"Courier"],
  " is only used when ",
  StyleBox["NumberMarks \[Rule] False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] With the default setting ",
  StyleBox["PrintPrecision \[Rule] 6",
    FontFamily->"Courier"],
  ", only the six most significant digits of a number are displayed in a \
notebook, even though the value of the number may be stored in memory to much \
higher precision. "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.9.4", "2.3.5.9x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["NumberMultiplier", "ObjectName",
  CellTags->{"2.3.5.2.10.2", "2.3.5.10x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NumberMultiplier", "MR"],
  " ",
  "is an option for cells",
  " which gives the string to use as a multiplication sign in scientific \
notation. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.10.3", "2.3.5.10x"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default is ",
  StyleBox["NumberMultiplier", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["\"\[Backslash][Times]\"", "MR"],
  ". \n\[FilledSmallSquare] In ",
  StyleBox["OutputForm", "MR"],
  ", \[Backslash]",
  StyleBox["[Times]", "MR"],
  " is rendered as ",
  StyleBox["x", "MR"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.7",
    ButtonData:>{"2.9.7", "7.11"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["NumberMarks",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.10.4", "2.3.5.10x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["LimitsPositioning", "ObjectName",
  CellTags->{"2.3.5.2.11.2", "2.3.5.11x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LimitsPositioning", "MR"],
  " is an option for cells that determines whether or not to change the \
positioning of underscripts and overscripts in the way conventional for \
limits. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.11.3", "2.3.5.11x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False]", "MR"],
  " is always displayed with explicit underscripts and overscripts, as ",
  Cell[BoxData[
      UnderoverscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True]", "MR"],
  " is displayed as ",
  Cell[BoxData[
      UnderoverscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " when large, and ",
  Cell[BoxData[
      SubsuperscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " when small. \n\[FilledSmallSquare] The ",
  Cell[BoxData[
      SubsuperscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " form is used when the box appears in a subscript or other script, or \
inline in a piece of text. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["LimitsPositioning->Automatic", "MR"],
  ", the display of ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " depends on ",
  StyleBox["x", "TI"],
  ". If ",
  StyleBox["x", "TI"],
  " is \[Backslash]",
  StyleBox["[Sum]", "MR"],
  ", \[Backslash]",
  StyleBox["[Product]", "MR"],
  " or another form conventionally displayed with limits, then ",
  StyleBox["LimitsPositioning->True", "MR"],
  " is effectively used. Otherwise, ",
  StyleBox["LimitsPositioning->False", "MR"],
  " is used. \n\[FilledSmallSquare] ",
  StyleBox["LimitsPositioningTokens", "MR"],
  " is a ",
  StyleBox["Cell", "MR"],
  " option which can be set to a list of forms for which ",
  StyleBox["LimitsPositioning", "MR"],
  "\[Rule]",
  StyleBox["True", "MR"],
  " should be used. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.63"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["LimitsPositioningTokens",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["ScriptSizeMultipliers",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.11.4", "2.3.5.11x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["LimitsPositioningTokens ", "ObjectName",
  CellTags->{"2.3.5.2.12.2", "2.3.5.12x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LimitsPositioningTokens",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines a set of characters for which the option ",
  StyleBox["LimitsPositioning",
    FontFamily->"Courier"],
  " is set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  " by default."
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.12.3", "2.3.5.12x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LimitsPositioningTokens",
    FontFamily->"Courier"],
  " is specified as a list of characters. Typical members of the list include \
characters such as \[Sum], \[Product], \[Intersection], \[Union], and \
\[CirclePlus].\n\[FilledSmallSquare] See also: ",
  ButtonBox["LimitsPositioning",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.12.4", "2.3.5.12x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ScriptBaselineShifts", "ObjectName",
  CellTags->{"2.3.5.2.13.2", "2.3.5.13x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ScriptBaselineShifts", "MR"],
  " is an option for cells that determines the minimum distance in ",
  StyleBox["x",
    FontSlant->"Italic"],
  "\[Hyphen]heights to shift subscripts and superscripts. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.13.3", "2.3.5.13x"}],

Cell[TextData[{
  "\[FilledSmallSquare] The setting ",
  StyleBox["ScriptBaselineShifts", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  "{",
  StyleBox["m", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FormatType->StandardForm],
  " shifts subscripts by ",
  StyleBox["m",
    FontSlant->"Italic"],
  " and superscripts by ",
  StyleBox["n",
    FontSlant->"Italic"],
  " ",
  StyleBox["x",
    FontSlant->"Italic"],
  "\[Hyphen]heights. \n\[FilledSmallSquare] A typical setting is ",
  StyleBox["ScriptBaselineShifts", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["{0.6,", "MR"],
  " ",
  StyleBox["0.9}", "MR"],
  ". \n\[FilledSmallSquare] The default setting ",
  StyleBox["ScriptBaselineShifts", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["Automatic,", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FormatType->StandardForm,
    FontFamily->"Courier"],
  " shifts subscripts and superscripts by a distance which depends on their \
height. \n\[FilledSmallSquare] See T",
  StyleBox["he ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.55"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["AdjustmentBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["RowMinHeight",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ScriptMinSize",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.2.13.4", "2.3.5.13x"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Traditional Notation Options", "SubsubsectionIcon",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->"2.3.5.3.2"],

Cell[CellGroupData[{

Cell["SingleLetterItalics", "ObjectName",
  CellTags->{"2.3.5.3.2.2", "2.3.5.17x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SingleLetterItalics", "MR"],
  " is an option for cells that determines ",
  "if",
  " single\[Hyphen]letter names should be displayed in italics. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.3.2.3", "2.3.5.17x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SingleLetterItalics", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  " is typically set for cells that contain ",
  StyleBox["TraditionalForm", "MR"],
  " expressions. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica ", "TI"],
  StyleBox["Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.11",
    ButtonData:>{"2.11.11", "11.2"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["AutoItalicWords",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["StyleBox",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.3.2.4", "2.3.5.17x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["TraditionalFunctionNotation ", "ObjectName",
  CellTags->{"2.3.5.3.3.2", "2.3.5.18x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TraditionalFunctionNotation",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " input of the form ",
  StyleBox["f(x)",
    FontFamily->"Courier"],
  " is interpreted as a function or a product by the kernel."
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.3.3.3", "2.3.5.18x"}],

Cell[TextData[{
  "\[FilledSmallSquare] In TraditionalForm cells, ",
  StyleBox["TraditionalFunctionNotation",
    FontFamily->"Courier"],
  StyleBox[" \[Rule] True",
    FontFamily->"Courier"],
  " by default. This means input of the form ",
  StyleBox["f(x)",
    FontFamily->"Courier"],
  " is interpreted as a function ",
  StyleBox["f",
    FontFamily->"Courier"],
  " of the variable ",
  StyleBox["x",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] In StandardForm cells, ",
  StyleBox["TraditionalFunctionNotation",
    FontFamily->"Courier"],
  StyleBox[" \[Rule] False",
    FontFamily->"Courier"],
  " by default. This means input of the form ",
  StyleBox["f(x)",
    FontFamily->"Courier"],
  " is interpreted as a product of the variables ",
  StyleBox["f",
    FontFamily->"Courier"],
  " and ",
  StyleBox["x",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.3.3.4", "2.3.5.18x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DelimiterMatching", "ObjectName",
  CellTags->{"2.3.5.3.4.2", "2.3.5.19x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DelimiterMatching",
    FontFamily->"Courier"],
  " is an option for cells that determines if an opening delimiter will match \
only its respective closing delimiter or any closing delimiter.  "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.3.4.3", "2.3.5.19x"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["DelimiterMatching \[Rule] All",
    FontFamily->"Courier"],
  ", all delimiters such as {, [ or ( must be matched with an opposite \
delimiter of the same type. For example, the expression (",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  "] would be considered illegal but (",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ") and [",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  "] are both allowed. Unmatched delimiters are typically displayed in a \
different style; the style is specified by ",
  StyleBox["AutoStylesOptions",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] With the setting ",
  StyleBox["DelimiterMatching \[Rule] None",
    FontFamily->"Courier"],
  ", a delimiter can be matched with an opposite delimiter of any type. \
Hence, the expression (",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  "] would be considered legal.\n\[FilledSmallSquare] See also: ",
  StyleBox[ButtonBox["DelimiterFlashTime",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox[ButtonBox["AutoStyleOptions",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Courier"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.3.4.4", "2.3.5.19x"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ZeroWidthTimes ", "ObjectName",
  CellTags->{"2.3.5.3.5.2", "2.3.5.20x"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ZeroWidthTimes",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " blank spaces representing multiplication are explicitly shown. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.3.5.3", "2.3.5.20x"}],

Cell[TextData[{
  "\[FilledSmallSquare] In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", a blank space between two symbols represents a multiplication sign. By \
setting ",
  StyleBox["ZeroWidthTimes \[Rule] True",
    FontFamily->"Courier"],
  ", you can make such a blank space invisible while still retaining its \
meaning as a multiplication symbol. This is useful for simulating \
conventional mathematical notation, such as ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["ab",
                FontSlant->"Italic"], " ", "+", " ", 
              StyleBox["ac",
                FontSlant->"Italic"], " ", "+", " ", 
              StyleBox["ad",
                FontSlant->"Italic"]}], 
            StyleBox[" ",
              FontSlant->"Italic"], 
            StyleBox["=",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], \(a(b\  + \ c\  + \ d)\)}]}], 
        TraditionalForm]],
    FormatType->StandardForm],
  ".",
  StyleBox["\n",
    FontSlant->"Italic"],
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ZeroWidthTimes ",
    FontFamily->"Courier"],
  "\[Rule]",
  StyleBox[" False",
    FontFamily->"Courier"],
  ", a blank space between two objects being multiplied is explicitly shown, \
as in ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(a\ b\),
              FontSlant->"Italic"], " ", "+", " ", 
            StyleBox[\(a\ c\),
              FontSlant->"Italic"], " ", "+", " ", 
            StyleBox[\(a\ d\),
              FontSlant->"Italic"]}], 
          StyleBox[" ",
            FontSlant->"Italic"], 
          StyleBox["=",
            FontSlant->"Italic"], 
          StyleBox[" ",
            FontSlant->"Italic"], \(a\ \((b\  + \ c\  + \ d)\)\)}], 
        TraditionalForm]],
    FormatType->StandardForm],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.3.5.4", "2.3.5.20x"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Specific Box Options", "SubsubsectionIcon",
  PageWidth->WindowWidth,
  Background->None],

Cell[CellGroupData[{

Cell["AdjustmentBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->{"2.3.5.4.2", "2.3.5.18.1"}],

Cell[CellGroupData[{

Cell["BoxMargins ", "SubObjectNameClosed",
  CellTags->{"2.3.5.4.2.2", "2.3.5.18.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxMargins",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the margins of adjustment boxes that are used for \
controlling the exact placement of a character in a line. "
}], "Usage",
  CellTags->{"2.3.5.4.2.3", "2.3.5.18.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can fine-tune the space surrounding any character \
by placing an ",
  StyleBox["AdjustmentBox",
    FontFamily->"Courier"],
  " around it. Type  \
\[ControlKey]\[LeftModified]\[LeftArrow]\[RightModified],  \[ControlKey]\
\[LeftModified]\[RightArrow]\[RightModified], \[ControlKey]\[LeftModified]\
\[DownArrow]\[RightModified],  \[ControlKey]\[LeftModified]\[UpArrow]\
\[RightModified] to add space around the left, right, bottom, and top of the \
character, respectively. \n\[FilledSmallSquare] ",
  StyleBox["BoxMargins \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}, {",
    FontFamily->"Courier"],
  StyleBox["b",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["t",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  " determines the amount of space added to the left, right, bottom, and top \
of the character respectively. Widths are specified in ems and heights in ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-heights. The variables ",
  StyleBox["l",
    FontSlant->"Italic"],
  ", ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["t",
    FontSlant->"Italic"],
  " can take any decimal value, negative or positive.\n\[FilledSmallSquare] \
The default setting is ",
  StyleBox["BoxMargins \[Rule] {{0, 0}, {0, 0}}",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.5.4.2.4", "2.3.5.18.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["BoxBaselineShift", "SubObjectNameClosed",
  CellTags->{"2.3.5.4.3.2", "2.3.5.18.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxBaselineShift",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the amount by which the baseline of a character is \
shifted vertically when the space around it is modified using an adjustment \
box."
}], "Usage",
  CellTags->{"2.3.5.4.3.3", "2.3.5.18.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["BoxBaselineShift \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["k",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times"],
  " the baseline of the adjustment box is shifted vertically by ",
  StyleBox["k",
    FontSlant->"Italic"],
  " ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-heights. The default setting is ",
  StyleBox["BoxBaselineShift \[Rule] 0",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.5.4.3.4", "2.3.5.18.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->{"2.3.5.5.2", "2.3.5.18.2"}],

Cell[CellGroupData[{

Cell["ButtonStyle ", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.2.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonStyle", "MR"],
  " is an option for cells that determines the default properties for the \
button such as the type of action it performs and the details of its \
appearance. "
}], "Usage",
  CellTags->{"2.3.5.5.2.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Typical button styles defined in the default style \
sheet are: \n",
  Cell[BoxData[GridBox[{
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Paste\\\\\\\\\\\
\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"paste the contents of the button (default) \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Evaluate\\\\\\\\\
\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"paste, then evaluate what has been pasted in place \
\"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"EvaluateCell\\\\\
\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"paste, then evaluate the whole cell \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"CopyEvaluate\\\\\
\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"copy the current selection into a new cell, then \
paste and evaluate in place \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\
CopyEvaluateCell\\\\\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"copy the current selection into a new cell, then \
paste and evaluate the whole cell \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Hyperlink\\\\\\\
\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"jump to a different location in the notebook \"\>",
              FontFamily->"Times"]}
          },
        ColumnAlignments->{Left}]], "Notes",
    CellTags->"ButtonStyle"],
  "\n\[FilledSmallSquare] The properties specified by a button style can \
affect both the appearance and action of a button. \n\[FilledSmallSquare] The \
properties can be overridden by explicit settings for ",
  StyleBox["ButtonBox", "MR"],
  " options. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.8"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonFrame",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.2.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonFunction ", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.3.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonFunction", "MR"],
  " is an option for cells that determines the function to execute when an \
active button is clicked. "
}], "Usage",
  CellTags->{"2.3.5.5.3.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting for ",
  StyleBox["ButtonFunction", "MR"],
  " causes the button to paste its contents in your current notebook \
selection. \n\[FilledSmallSquare] ",
  StyleBox["ButtonFunction", "MR"],
  " is used only when the option ",
  StyleBox["Active", "MR"],
  StyleBox[" is set to ", "MR",
    FontFamily->"Times"],
  StyleBox["True", "MR"],
  ", either for the button or for the cell the button is in. \n\
\[FilledSmallSquare] With ",
  StyleBox["ButtonFunction", "MR"],
  " ",
  StyleBox["\[RuleDelayed]", "MR"],
  "  ",
  StyleBox["f", "TI"],
  StyleBox[",", "TI",
    FontSlant->"Plain"],
  " the first argument supplied to ",
  StyleBox["f", "TI"],
  " is specified by the setting for ",
  StyleBox["ButtonSource", "MR"],
  " and the second argument is specified by the setting for ",
  StyleBox["ButtonData", "MR"],
  ". \n\[FilledSmallSquare] Standard ",
  StyleBox["Mathematica", "TI"],
  " precedence rules require parentheses, as in ",
  StyleBox["ButtonFunction \[RuleDelayed]", "MR"],
  "  ",
  StyleBox["(", "MR"],
  StyleBox["body", "TI"],
  " ",
  StyleBox["&)", "MR"],
  ". \n\[FilledSmallSquare] Settings for ",
  StyleBox["ButtonFunction", "MR"],
  " are often inherited from button styles via the ",
  StyleBox["ButtonStyle", "MR"],
  " option. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonEvaluator",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNote",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NotebookApply",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.3.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonEvaluator ", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.4.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonEvaluator", "MR"],
  " is an option for cells that determines where the expression constructed \
from ",
  StyleBox["ButtonFunction", "MR"],
  " is sent for evaluation. "
}], "Usage",
  CellTags->{"2.3.5.5.4.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonEvaluator ", "MR"],
  StyleBox["\[Rule] ",
    FontFamily->"Courier"],
  StyleBox["None", "MR"],
  ". \n\[FilledSmallSquare] Possible settings are as follows. \n",
  Cell[BoxData[GridBox[{
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"None\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"the front end \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Automatic\\\\\\\"\\\", \\\"MR\\\
\"]\\) \"\>", 
            
            StyleBox["\<\"the kernel used by default in the current notebook \
\"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\\\\\\\"\\\", \
\\\"MR\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\"name\\\\\\\"\\\", \
\\\"TI\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"a kernel referred to by a specific name \"\>",
              FontFamily->"Times"]}
          },
        ColumnAlignments->{Left}]], "Notes",
    CellTags->"ButtonEvaluator"],
  "\n\[FilledSmallSquare] With ",
  StyleBox["ButtonEvaluator ", "MR"],
  StyleBox["\[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times New Roman"],
  " the expression to be evaluated can contain any ",
  StyleBox["Mathematica", "TI"],
  " expressions. \n\[FilledSmallSquare] With ",
  StyleBox["ButtonEvaluator ", "MR"],
  StyleBox["\[Rule] ",
    FontFamily->"Courier"],
  StyleBox["None", "MR"],
  ", the expression can contain only the specific notebook commands supported \
by the front end. All these commands are in the context ",
  StyleBox["FrontEnd`", "MR"],
  ". Expressions intended for processing only by the front end should be \
wrapped with ",
  StyleBox["FrontEndExecute", "MR"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SelectionEvaluate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.4.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonSource", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.5.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonSource", "MR"],
  " is an option for cells that determines the first argument given to the ",
  StyleBox["ButtonFunction", "MR"],
  " when the button is active and is clicked. "
}], "Usage",
  CellTags->{"2.3.5.5.5.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default is ",
  StyleBox["ButtonSource ", "MR"],
  StyleBox["\[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  ". \n\[FilledSmallSquare] Possible settings are as follows. \n",
  Cell[BoxData[GridBox[{
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Automatic\\\\\\\"\\\", \\\"MR\\\
\"]\\) \"\>", 
            
            StyleBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonData\\\\\\\"\\\"\
, \\\"MR\\\"]\\) if it is set, otherwise \
\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonContents\\\\\\\"\\\", \\\"MR\\\"]\\) \
\"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonContents\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"the first argument of the \
\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonBox\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonData\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"the setting for the \
\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonData\\\\\\\"\\\", \\\"MR\\\"]\\) option \
\"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Cell\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"the whole cell in which the button appears \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"CellContents\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"the contents of the cell in which the button \
appears \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Notebook\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"the whole notebook in which the button appears \
\"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"n\\\\\\\"\\\", \\\"TI\\\"]\\) \
\"\>", 
            
            StyleBox["\<\"the expression \
\\!\\(\\*StyleBox[\\\"\\\\\\\"n\\\\\\\"\\\", \\\"TI\\\"]\\) levels up from \
the button in the notebook \"\>",
              FontFamily->"Times"]}
          },
        ColumnAlignments->{Left}]], "Notes",
    CellTags->"ButtonSource"],
  "\n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonData",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NotebookRead",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.5.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonData ", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.6.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonData", "MR"],
  " is an option for cells that determines the second argument given to ",
  StyleBox["ButtonFunction", "MR"],
  " when the button is active and is clicked. "
}], "Usage",
  CellTags->{"2.3.5.5.6.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default is ",
  StyleBox["ButtonData ", "MR"],
  "\[Rule]",
  StyleBox[" Null", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ButtonData", "MR"],
  " provides a convenient way to associate additional data with a button \
without affecting the display of the button. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonSource",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNote",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.6.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonNote", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.7.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonNote", "MR"],
  " is an option for cells that determines what is displayed in the status \
line of the current notebook window when the button is active and the cursor \
is placed on top of the button. "
}], "Usage",
  CellTags->{"2.3.5.5.7.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] By assigning a value to ",
  StyleBox["ButtonNote",
    FontFamily->"Courier"],
  ", you can provide a visual cue to indicate the function of the button. For \
example, in the Complete Characters palette, each button has the fullname of \
the character as the setting for ",
  StyleBox["ButtonNote.",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] With the default setting ",
  StyleBox["ButtonNote",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["None",
    FontFamily->"Courier"],
  ", no text is displayed in the status line.\n\[FilledSmallSquare] Any \
expression can be specified as the setting for ",
  StyleBox["ButtonNote", "MR"],
  ", though most windows will only allow a single character height to be \
displayed.\n\[FilledSmallSquare] ",
  StyleBox["ButtonNote", "MR"],
  " can be used to display keyboard equivalents for buttons in a palette. \n\
\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonData",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.7.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonFrame", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.8.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonFrame", "MR"],
  " ",
  "is an option for cells",
  " that determines the type of frame to display around a button. "
}], "Usage",
  CellTags->{"2.3.5.5.8.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonFrame", "MR"],
  "  \[Rule]",
  StyleBox[" Palette", "MR"],
  ".\n\[FilledSmallSquare] Typical settings supported include the following. \
\n",
  Cell[BoxData[GridBox[{
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Palette\\\\\\\\\
\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"a button in a palette \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"DialogBox\\\\\\\
\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"a button in a dialog box \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"None\\\\\\\\\\\\\
\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"a button with no frame \"\>",
              FontFamily->"Times"]}
          },
        ColumnAlignments->{Left}]], "Notes",
    CellTags->"ButtonFrame"],
  "\n\[FilledSmallSquare] Button frames generated by ",
  StyleBox["ButtonFrame", "MR"],
  " are set up to follow the conventions for particular computer systems. \n\
\[FilledSmallSquare] A button with a particular setting for ",
  StyleBox["ButtonFrame", "MR"],
  " may look slightly different on different computer systems. \n\
\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowFrame",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.8.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Background", "SubObjectNameClosed",
  CellTags->"2.3.5.18.2"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["Background",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the background color of a button."
}], "Usage",
  CellTags->"2.3.5.18.2"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background",
    FontFamily->"Courier"],
  StyleBox[" is an option for notebooks, cells and selections. ",
    FontFamily->"Times New Roman"]
}], "Notes",
  CellTags->"2.3.5.18.2"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["Background \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the button backgrounds are drawn using the system's default settings for \
buttons."
}], "Notes",
  CellTags->"2.3.5.18.2"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  " You can select a custom color with the color dialog box that appears by \
clicking the square symbol to the right of the option. The color is specified \
as an ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " [",
  StyleBox["red",
    FontSlant->"Italic"],
  ", ",
  StyleBox["green",
    FontSlant->"Italic"],
  ", ",
  StyleBox["blue",
    FontSlant->"Italic"],
  "].It can also be specified using ",
  StyleBox["Hue",
    FontFamily->"Courier"],
  " or ",
  StyleBox["CMYKColor",
    FontFamily->"Courier"],
  ", but in these cases the color is automatically converted to ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " by the front end.\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"2.3.5.18.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonMargins ", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.10.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonMargins", "MR"],
  " is an option for cells that determines how much space in printer's points \
is left around the contents of a button when it is displayed. "
}], "Usage",
  CellTags->{"2.3.5.5.10.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonMargins ", "MR"],
  "\[Rule]",
  StyleBox[" 3", "MR"],
  ". This corresponds to a margin of 3 points, that is ",
  Cell[BoxData[
      \(TraditionalForm\`3\/72\)],
    FormatType->StandardForm],
  " of an inch. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonExpandable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonMinHeight",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.10.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonMinHeight", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.11.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonMinHeight", "MR"],
  " ",
  "is an option for cells",
  " that determines the minimum total height in units of font size that \
should be allowed for the button. "
}], "Usage",
  CellTags->{"2.3.5.5.11.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting ",
  StyleBox["ButtonMinHeight ", "MR"],
  "\[Rule]",
  StyleBox[" 1", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times New Roman"],
  " forces a button to have a total height that at least accommodates all the \
characters in the current font. \n\[FilledSmallSquare] ",
  StyleBox["ButtonMinHeight ", "MR"],
  "\[Rule]",
  StyleBox[" 0", "MR"],
  " reduces the total height of a button as much as possible, allowing \
buttons containing different characters, such as ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["X", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times New Roman"],
  " to be different heights. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonExpandable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["RowMinHeight",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.11.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonExpandable ", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.12.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonExpandable", "MR"],
  " is an option for cells that determines ",
  "if",
  " the button should expand to fill any ",
  StyleBox["grid box", "MR",
    FontFamily->"Times"],
  " position in which it appears. "
}], "Usage",
  CellTags->{"2.3.5.5.12.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonExpandable ", "MR"],
  "\[Rule]",
  StyleBox[" True", "MR"],
  ". \n\[FilledSmallSquare] This setting is usually used for all buttons that \
appear in palettes. \n\[FilledSmallSquare] With ",
  StyleBox["ButtonExpandable ", "MR"],
  "\[Rule]",
  StyleBox[" False", "MR"],
  " the size of a button is determined only by its contents, independent of \
its environment. \n\[FilledSmallSquare] With ",
  StyleBox["ButtonExpandable ", "MR"],
  "\[Rule]",
  StyleBox[" False", "MR"],
  ", gutters will often be left between buttons in a grid box. \n\
\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonMinHeight",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.12.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Active ", "SubObjectNameClosed",
  CellTags->{"2.3.5.5.13.2", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Active", "MR"],
  " is an option for cells that determines ",
  "if",
  " a button should be active. "
}], "Usage",
  CellTags->{"2.3.5.5.13.3", "2.3.5.5", "2.3.5.18.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["Active ", "MR"],
  "\[Rule]",
  StyleBox[" False", "MR"],
  ", the contents of a button can be edited. \n\[FilledSmallSquare] With ",
  StyleBox["Active ", "MR"],
  "\[Rule]",
  StyleBox[" True", "MR"],
  ", a button will perform an action when it is clicked. \n\
\[FilledSmallSquare] Active cells are indicated by an ",
  StyleBox["A", "MR"],
  " in their cell bracket. \n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.10",
    ButtonData:>{"2.9.10", "10.33"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Evaluator",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.5.13.4", "2.3.5.5", "2.3.5.18.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["CounterBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->{"2.3.5.6.2", "2.3.5.18.3"}],

Cell[CellGroupData[{

Cell["counter name", "SubObjectNameClosed",
  CellTags->"2.3.5.18.3"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["counter name",
    FontSlant->"Italic"],
  " is an option for cells that specifies the type of counter whose value is \
displayed in a ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  ". "
}], "Usage",
  CellTags->"2.3.5.18.3"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["counter name",
    FontSlant->"Italic"],
  " is specified as the first argument to a ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  ". Possible values it can take are ",
  StyleBox["\"Section\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"SubSection\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Page\"",
    FontFamily->"Courier"],
  ", ",
  "and so forth.",
  " \n\[FilledSmallSquare] ",
  StyleBox["counter name",
    FontSlant->"Italic"],
  " appears grayed out in the Option Inspector, except when a ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  " object is selected. "
}], "Notes",
  CellTags->"2.3.5.18.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["reference file", "SubObjectNameClosed",
  CellTags->"2.3.5.18.3"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is an option for cells that specifies the file referenced by a ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  "."
}], "Usage",
  CellTags->"2.3.5.18.3"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is an optional argument to a ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  ". It is used when the counter references a notebook other than the one in \
which it occurs. The file can be specified either by its absolute path or its \
path relative to the current notebook.\n\[FilledSmallSquare] When ",
  StyleBox["reference file ",
    FontSlant->"Italic"],
  "is specified, the counter behaves as if it were located in the notebook \
specified by ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  ", in a cell with the tag ",
  StyleBox["reference tag",
    FontSlant->"Italic"],
  ". This provides a way to refer to numbered sections, numbered equations, \
and so forth at a location different from the one in which they occur.\n\
\[FilledSmallSquare] If ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is not specified, then the counter refers to the same notebook in which \
it occurs. \n\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when a ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  " object is selected.           "
}], "Notes",
  CellTags->"2.3.5.18.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["reference tag", "SubObjectNameClosed",
  CellTags->"2.3.5.18.3"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference tag",
    FontSlant->"Italic"],
  " is an option for cells that specifies the tag(s) associated with a cell \
referenced by a ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  "."
}], "Usage",
  CellTags->"2.3.5.18.3"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is an optional argument to a ",
  StyleBox["ValueBox",
    FontFamily->"Courier"],
  ". It is used when the counter references a notebook other than the one in \
which it occurs. The file can be specified either by its absolute path or its \
path relative to the current notebook.\n\[FilledSmallSquare] When this \
argument is specified, the counter behaves as if it were located in the \
notebook specified by ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  ", in a cell with the tag ",
  StyleBox["reference tag",
    FontSlant->"Italic"],
  ". This provides a way to refer to numbered sections, numbered equations, \
",
  "and so forth",
  " at a location different from the one in which they occur.\n\
\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when a ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  " object is selected.          "
}], "Notes",
  CellTags->"2.3.5.18.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["CounterStyle", "SubObjectNameClosed",
  CellTags->{"2.3.5.6.2.2", "2.3.5.6", "2.3.5.18.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterStyle",
    FontFamily->"Courier"],
  " is an option for cells that determines the cell style from which the \
default values of all options associated with a counter are inherited."
}], "Usage",
  CellTags->{"2.3.5.6.2.3", "2.3.5.6", "2.3.5.18.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterStyle",
    FontFamily->"Courier"],
  " can be set to any of the cell styles defined in the notebook's style \
sheet. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["CounterStyle \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the counter inherits the option values of the cell style for which it is \
defined."
}], "Notes",
  CellTags->{"2.3.5.6.2.4", "2.3.5.6", "2.3.5.18.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CounterFunction", "SubObjectNameClosed",
  CellTags->{"2.3.5.6.3.2", "2.3.5.6", "2.3.5.18.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterFunction",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the symbols used to display the value of a counter. "
}], "Usage",
  CellTags->{"2.3.5.6.3.3", "2.3.5.6", "2.3.5.18.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["CounterFunction \[Rule] Identity",
    FontFamily->"Courier"],
  ", the value of the counter is displayed as an ordinary decimal number. \n\
\[FilledSmallSquare] You can also set the counter display to use symbols such \
as Roman numerals or Greek letters. Other possible formats include: capital \
Roman numerals, capital Greek letters, lowercase letters, uppercase letters, \
days of the week, months, and circled numbers. To choose any of these \
formats, check the corresponding item in the pop-up menu to the right of the \
option.\n\[FilledSmallSquare] At the level of the cell expression, all these \
formats are implemented using the ",
  StyleBox["CharacterRange",
    FontFamily->"Courier"],
  " function. This allows you to specify any arbitrary set of symbols or \
strings to use in the counter display. For example,\nTo display:              \
   Use the setting:\nabc...                         ",
  StyleBox["CounterFunction \[Rule] (Part[CharacterRange[\"a\", \"z\"],#]&)",
    FontFamily->"Courier"],
  " \t           \nGreek letters             ",
  StyleBox["CounterFunction \[Rule] \
(Part[CharacterRange[\"\[Backslash][Alpha]\",\"\[Backslash][Omega]\"],#]&)",
    FontFamily->"Courier"],
  "\t            ",
  StyleBox["\n",
    FontFamily->"Courier"],
  "Days of the week      ",
  StyleBox["CounterFunction \[Rule] (Part[{\"Monday\", \"Tuesday\",",
    FontFamily->"Courier"],
  " ...",
  StyleBox["}],#]&)\n\t",
    FontFamily->"Courier"],
  "          "
}], "Notes",
  CellTags->{"2.3.5.6.3.4", "2.3.5.6", "2.3.5.18.3"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ValueBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->"2.3.5.18.3a"],

Cell[CellGroupData[{

Cell["option name", "SubObjectNameClosed",
  CellTags->"2.3.5.18.3a"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["option name",
    FontSlant->"Italic"],
  " is an option for cells that specifies the variable whose value is shown \
in a value display object.  "
}], "Usage",
  CellTags->"2.3.5.18.3a"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["option name",
    FontSlant->"Italic"],
  " is specified as the first argument to a ",
  StyleBox["ValueBox",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["option name",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when a value display \
object is selected. "
}], "Notes",
  CellTags->"2.3.5.18.3a"]
}, Closed]],

Cell[CellGroupData[{

Cell["reference file", "SubObjectNameClosed",
  CellTags->"2.3.5.18.3a"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is an option for cells that specifies the file referenced by a value \
display object."
}], "Usage",
  CellTags->"2.3.5.18.3a"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is an optional argument to a ",
  StyleBox["ValueBox",
    FontFamily->"Courier"],
  ". It is used when the ",
  StyleBox["ValueBox",
    FontFamily->"Courier"],
  " references a variable associated with a notebook other than the one in \
which the display object occurs. The file can be specified either by its \
absolute pathname or its path relative to the current notebook.\n\
\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when a value display \
object is selected. ",
  StyleBox["\t",
    FontFamily->"Courier"],
  "       "
}], "Notes",
  CellTags->"2.3.5.18.3a"]
}, Closed]],

Cell[CellGroupData[{

Cell["reference tag", "SubObjectNameClosed",
  CellTags->"2.3.5.18.3a"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference tag",
    FontSlant->"Italic"],
  " is an option for cells that specifies the tag(s) associated with a cell \
referenced by the value display object"
}], "Usage",
  CellTags->"2.3.5.18.3a"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is an optional argument to a ",
  StyleBox["ValueBox",
    FontFamily->"Courier"],
  ". It is used when the ",
  StyleBox["ValueBox",
    FontFamily->"Courier"],
  " references a variable associated with a notebook other than the one in \
which the display object occurs. The file can be specified either by its \
absolute pathname or its path relative to the current notebook.\n\
\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when a value display \
object is selected.         "
}], "Notes",
  CellTags->"2.3.5.18.3a"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["OptionValueBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->"2.3.5.18.3b"],

Cell[CellGroupData[{

Cell["option name", "SubObjectNameClosed",
  CellTags->"2.3.5.18.3b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["option name",
    FontSlant->"Italic"],
  " is an option for cells that specifies the option whose value is shown in \
a value display object.  "
}], "Usage",
  CellTags->"2.3.5.18.3b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["option name",
    FontSlant->"Italic"],
  " is specified as the first argument to an ",
  StyleBox["OptionValueBox",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["option name",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when a value display \
object is selected. "
}], "Notes",
  CellTags->"2.3.5.18.3b"]
}, Closed]],

Cell[CellGroupData[{

Cell["reference file", "SubObjectNameClosed",
  CellTags->"2.3.5.18.3b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is an option for cells that specifies the file referenced by a value \
display object."
}], "Usage",
  CellTags->"2.3.5.18.3b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is an optional argument to an ",
  StyleBox["OptionValueBox",
    FontFamily->"Courier"],
  ". It is used when the ",
  StyleBox["OptionValueBox",
    FontFamily->"Courier"],
  " references a variable associated with a notebook other than the one in \
which the display object occurs. The file can be specified either by its \
absolute pathname or its path relative to the current notebook.\n\
\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when a value display \
object is selected. ",
  StyleBox["\t",
    FontFamily->"Courier"],
  "        "
}], "Notes",
  CellTags->"2.3.5.18.3b"]
}, Closed]],

Cell[CellGroupData[{

Cell["reference tag", "SubObjectNameClosed",
  CellTags->"2.3.5.18.3b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference tag",
    FontSlant->"Italic"],
  " is an option for cells that specifies the tag(s) associated with a cell \
referenced by the value display object"
}], "Usage",
  CellTags->"2.3.5.18.3b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " is an optional argument to an ",
  StyleBox["OptionValueBox",
    FontFamily->"Courier"],
  ". It is used when the ",
  StyleBox["OptionValueBox",
    FontFamily->"Courier"],
  " references a variable associated with a notebook other than the one in \
which the display object occurs. The file can be specified either by its \
absolute pathname or its path relative to the current notebook.\n\
\[FilledSmallSquare] ",
  StyleBox["reference file",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when a value display \
object is selected. ",
  StyleBox["\t",
    FontFamily->"Courier"],
  "      "
}], "Notes",
  CellTags->"2.3.5.18.3b"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ErrorBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->{"2.3.5.7.2", "2.3.5.18.4"}],

Cell[CellGroupData[{

Cell["AutoDelete", "SubObjectNameClosed",
  CellTags->{"2.3.5.7.2.2", "2.3.5.7", "2.3.5.18.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoDelete",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an ",
  StyleBox["ErrorBox",
    FontFamily->"Courier"],
  " box wrapped around an expression in a notebook is automatically deleted \
when that expression is edited. "
}], "Usage",
  CellTags->{"2.3.5.7.2.3", "2.3.5.7", "2.3.5.18.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end wraps an ",
  StyleBox["ErrorBox",
    FontFamily->"Courier"],
  " box around any expression that it does not recognize while reading a \
file. The expression is then displayed with a thick red line drawn under it. \
With the default setting ",
  StyleBox["AutoDelete \[Rule] True",
    FontFamily->"Courier"],
  ", the ",
  StyleBox["ErrorBox",
    FontFamily->"Courier"],
  " is automatically deleted if the expression inside it is edited.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["AutoDelete \[Rule] False",
    FontFamily->"Courier"],
  ", the ",
  StyleBox["ErrorBox",
    FontFamily->"Courier"],
  " remains in place and must be deleted manually."
}], "Notes",
  CellTags->{"2.3.5.7.2.4", "2.3.5.7", "2.3.5.18.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SaveAutoDelete", "SubObjectNameClosed",
  CellTags->{"2.3.5.7.3.2", "2.3.5.7", "2.3.5.18.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SaveAutoDelete",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an ",
  StyleBox["ErrorBox",
    FontFamily->"Courier"],
  " box wrapped around an expression in a notebook is automatically deleted \
when the notebook is saved. "
}], "Usage",
  CellTags->{"2.3.5.7.3.3", "2.3.5.7", "2.3.5.18.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end wraps an ",
  StyleBox["ErrorBox",
    FontFamily->"Courier"],
  " box around any expression that it does not recognize while reading in a \
file. The expression is then displayed with a thick red line drawn under it. \
With the setting ",
  StyleBox["SaveAutoDelete \[Rule] True",
    FontFamily->"Courier"],
  StyleBox[", ",
    FontFamily->"Times"],
  "any ",
  StyleBox["ErrorBox",
    FontFamily->"Courier"],
  " box is automatically deleted if the notebook is saved.\n\
\[FilledSmallSquare] The default setting is ",
  StyleBox["SaveAutoDelete \[Rule] False.",
    FontFamily->"Courier"],
  " "
}], "Notes",
  CellTags->{"2.3.5.7.3.4", "2.3.5.7", "2.3.5.18.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->"2.3.5.18.4a"],

Cell[CellGroupData[{

Cell["FormatType", "SubObjectNameClosed",
  CellTags->"2.3.5.18.4a"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FormatType",
    FontFamily->"Courier"],
  " is an option for cells that determines the typeset format type in which \
an expression is displayed."
}], "Usage",
  CellTags->"2.3.5.18.4a"],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are ",
  StyleBox["StandardForm",
    FontFamily->"Courier"],
  " and ",
  StyleBox["TraditionalForm",
    FontFamily->"Courier"],
  ". Additional typeset format types can be defined if needed."
}], "Notes",
  CellTags->"2.3.5.18.4a"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FractionBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->{"2.3.5.8.2", "2.3.5.18.5"}],

Cell[CellGroupData[{

Cell["FractionLine ", "SubObjectNameClosed",
  CellTags->{"2.3.5.8.2.2", "2.3.5.8", "2.3.5.18.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FractionLine",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the thickness of the line separating the numerator and \
denominator of a fraction. "
}], "Usage",
  CellTags->{"2.3.5.8.2.3", "2.3.5.8", "2.3.5.18.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["FractionLine \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the fraction line has a thickness equal to the default thickness of a \
line in that font. This is the thickness, for example, of lines in the hyphen \
(-) and underscore (_) characters.\n\[FilledSmallSquare] With the setting ",
  StyleBox["FractionLine \[Rule] None",
    FontFamily->"Courier"],
  ", the fraction line has zero thickness; ",
  "i.e.",
  " it is invisible.\n\[FilledSmallSquare] With the setting ",
  StyleBox["FractionLine \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["k",
    FontFamily->"Times",
    FontSlant->"Italic"],
  ", the fraction line has a thickness ",
  StyleBox["k ",
    FontSlant->"Italic"],
  "times the default value. "
}], "Notes",
  CellTags->{"2.3.5.8.2.4", "2.3.5.8", "2.3.5.18.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["MultilineFunction ", "SubObjectNameClosed",
  CellTags->{"2.3.5.8.3.2", "2.3.5.8", "2.3.5.18.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the numerator or denominator of a fraction is split across multiple lines \
if it is too long to fit on a single line. "
}], "Usage",
  CellTags->{"2.3.5.8.3.3", "2.3.5.8", "2.3.5.18.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the numerator or denominator may be reformatted to extend across \
multiple lines. This may involve converting the two-dimensional fraction into \
a fraction that uses a \"/\". The point at which the line break is applied is \
indicated by a \[Continuation] symbol.\n\[FilledSmallSquare] With the setting \
",
  StyleBox["MultilineFunction \[Rule] LineWrapParts",
    FontFamily->"Courier"],
  ", the numerator or denominator is linewrapped to fit in the available \
space, while retaining the two-dimensional form of the fraction. The point at \
which the line break is applied is indicated by a \[Continuation] symbol.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", the numerator or denominator is not split across multiple lines. "
}], "Notes",
  CellTags->{"2.3.5.8.3.4", "2.3.5.8", "2.3.5.18.5"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FrameBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->{"2.3.5.9.2", "2.3.5.18.6"}],

Cell[CellGroupData[{

Cell["BoxFrame", "SubObjectNameClosed",
  CellTags->{"2.3.5.9.2.2", "2.3.5.9", "2.3.5.18.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxFrame",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " lines are drawn around a frame box."
}], "Usage",
  CellTags->{"2.3.5.9.2.3", "2.3.5.9", "2.3.5.18.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxFrame",
    FontFamily->"Courier"],
  " can be set to the following. \n",
  StyleBox["True",
    FontFamily->"Courier"],
  StyleBox["                     a frame is drawn around all four sides of \
the grid box",
    FontFamily->"Times"],
  StyleBox["\nFalse   ",
    FontFamily->"Courier"],
  "            no frame is drawn around the grid box\n ",
  StyleBox["n        ",
    FontSlant->"Italic"],
  "                   \[AlignmentMarker] a",
  StyleBox[" frame with ",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" times the default thickness is drawn\n {{",
    FontFamily->"Times"],
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Times"],
  StyleBox[",{",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" t",
    FontSlant->"Italic"],
  StyleBox["}} ",
    FontFamily->"Courier"],
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["b",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", and ",
    FontFamily->"Times"],
  StyleBox["t",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" specify the thickness of the lines drawn around the left, right, \
 \n                               bottom, and top sides of the box, \
respectively.\n",
    FontFamily->"Times"],
  "\[FilledSmallSquare] The color of the frame is determined by the color of \
the font. "
}], "Notes",
  PageWidth->WindowWidth,
  CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
  CellTags->{"2.3.5.9.2.4", "2.3.5.9", "2.3.5.18.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["BoxMargins ", "SubObjectNameClosed",
  CellTags->{"2.3.5.9.3.2", "2.3.5.9", "2.3.5.18.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxMargins",
    FontFamily->"Courier"],
  " is an option for cells that determines the spacing between the contents \
of a grid box and the surrounding frame. "
}], "Usage",
  CellTags->{"2.3.5.9.3.3", "2.3.5.9", "2.3.5.18.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxMargins \[Rule] ",
    FontFamily->"Courier"],
  StyleBox[" {{",
    FontFamily->"Times"],
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Times"],
  StyleBox[",{",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" t",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" determines the size of the left, right, bottom, and top margins \
respectively, in em units. The default setting is ",
    FontFamily->"Times"],
  StyleBox["BoxMargins \[Rule] {{",
    FontFamily->"Courier"],
  "0.4, 0.4",
  StyleBox["}",
    FontFamily->"Courier"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["{",
    FontFamily->"Courier"],
  "0.5, 0.5",
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.5.9.3.4", "2.3.5.9", "2.3.5.18.6"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["GridBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->{"2.3.5.10.2", "2.3.5.18.7"}],

Cell[CellGroupData[{

Cell["GridFrame ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.2.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridFrame",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " lines are drawn around a grid box."
}], "Usage",
  CellTags->{"2.3.5.10.2.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridFrame",
    FontFamily->"Courier"],
  " can be set to the following.\n",
  StyleBox["True",
    FontFamily->"Courier"],
  StyleBox["                    a frame is drawn around all four sides of the \
grid box",
    FontFamily->"Times"],
  StyleBox["\nFalse   ",
    FontFamily->"Courier"],
  "           no frame is drawn around the grid box \n",
  StyleBox["n        ",
    FontSlant->"Italic"],
  "                   \[AlignmentMarker] a",
  StyleBox[" frame with ",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" times the default thickness is drawn\n{{",
    FontFamily->"Times"],
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Times"],
  StyleBox[",{",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" t",
    FontSlant->"Italic"],
  StyleBox["}} ",
    FontFamily->"Courier"],
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["b",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", and ",
    FontFamily->"Times"],
  StyleBox["t",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" specify the thickness of lines drawn around the\n                \
              left, right, bottom, and top sides of the box respectively. ",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.5.10.2.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["GridFrameMargins ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.3.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridFrameMargins",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the spacing between text in a grid box and the frame \
surrounding it. "
}], "Usage",
  CellTags->{"2.3.5.10.3.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridFrameMargins \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["{{",
    FontFamily->"Times"],
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Times"],
  StyleBox[",{",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" t",
    FontSlant->"Italic"],
  StyleBox["}}}",
    FontFamily->"Courier"],
  StyleBox[" determines the size of the left, right, bottom, and top margins \
respectively, in em units. The default setting is ",
    FontFamily->"Times"],
  StyleBox["GridFrameMargins \[Rule] {{0.4, 0.4}, {0.5, 0.5}}",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.5.10.3.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["RowLines ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.4.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowLines",
    FontFamily->"Courier"],
  " is an option for cells that determines if lines are drawn between \
adjacent rows in a grid box and what their thicknesses should be."
}], "Usage",
  CellTags->{"2.3.5.10.4.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowLines",
    FontFamily->"Courier"],
  " can be set to the following. \n",
  StyleBox["True",
    FontFamily->"Courier"],
  StyleBox["               a line is drawn between all adjacent rows",
    FontFamily->"Times"],
  StyleBox["\nFalse   ",
    FontFamily->"Courier"],
  "      no lines are drawn between rows\n ",
  StyleBox["n        ",
    FontSlant->"Italic"],
  "              a",
  StyleBox[" line with thickness ",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" times the default thickness is drawn \n \t\t between all \
adjacent rows\n{",
    FontFamily->"Times"],
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)],
    FormatType->StandardForm],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)],
    FormatType->StandardForm],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ....",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " th",
  StyleBox["e thickness of the ",
    FontFamily->"Times"],
  StyleBox["i",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["th line is determined by ",
    FontFamily->"Times"],
  Cell[BoxData[
      \(TraditionalForm\`n\_i\)],
    FormatType->StandardForm],
  ", which can take values ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", ",
  StyleBox["False",
    FontFamily->"Courier"],
  ",",
  StyleBox[" ",
    FontFamily->"Courier"],
  "or a number. If the number of rows is greater than the number of elements \
in the list, the last element determines the thickness of the remaining \
lines. "
}], "Notes",
  CellTags->{"2.3.5.10.4.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ColumnLines ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.5.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnLines",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines if lines should be drawn between adjacent columns in a \
grid box."
}], "Usage",
  CellTags->{"2.3.5.10.5.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnLines",
    FontFamily->"Courier"],
  " can be set to the following. \n",
  StyleBox["True",
    FontFamily->"Courier"],
  StyleBox["               a line is drawn between all adjacent columns",
    FontFamily->"Times"],
  StyleBox["\nFalse   ",
    FontFamily->"Courier"],
  "      no lines are drawn between columns\n ",
  StyleBox["n        ",
    FontSlant->"Italic"],
  "              a",
  StyleBox[" line with thickness ",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" times the default thickness is\n \t\t drawn between all adjacent \
columns\n{",
    FontFamily->"Times"],
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)],
    FormatType->StandardForm],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)],
    FormatType->StandardForm],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ....",
    FontSlant->"Italic"],
  StyleBox["} ",
    FontFamily->"Courier"],
  "th",
  StyleBox["e thickness of the ",
    FontFamily->"Times"],
  StyleBox["i",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["th line is determined by ",
    FontFamily->"Times"],
  Cell[BoxData[
      \(TraditionalForm\`n\_i\)],
    FormatType->StandardForm],
  ", which can take values ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", or a number. If the number of rows is greater than the number of \
elements in the list, the last element determines the thickness of the \
remaining lines. "
}], "Notes",
  CellTags->{"2.3.5.10.5.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["GridBaseline", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.6.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridBaseline",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the vertical positioning of a grid box with respect to \
the baseline of the text surrounding it."
}], "Usage",
  CellTags->{"2.3.5.10.6.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["GridBaseline \[Rule] Top",
    FontFamily->"Courier"],
  ", the top of a grid box is aligned with the baseline of the surrounding \
text. For example, ",
  StyleBox["\"",
    FontFamily->"Courier"],
  Cell[BoxData[
      RowBox[{"This", ",", " ", GridBox[{
            {"1", "0"},
            {"0", "1"}
            },
          GridBaseline->Top,
          GridFrame->True,
          RowLines->True,
          ColumnLines->True], ",", 
        " ", \(is\ a\ 2\ \[Times]\ 2\ \(\(table\)\(.\)\)\)}]],
    FontFamily->"Times"],
  "\"",
  StyleBox["  ",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] With the setting ",
  StyleBox["GridBaseline \[Rule] Bottom",
    FontFamily->"Courier"],
  StyleBox[", the bottom of the grid box is aligned with the baseline of the \
surrounding text. For example, ",
    FontFamily->"Times"],
  StyleBox["\t\n \"",
    FontFamily->"Courier"],
  Cell[BoxData[
      RowBox[{"This", ",", " ", GridBox[{
            {"1", "0"},
            {"0", "1"}
            },
          GridBaseline->Bottom,
          GridFrame->True,
          RowLines->True,
          ColumnLines->True], ",", 
        "  ", \(is\ a\ \ 2\ \[Times]\ 2\ \(\(table\)\(.\)\)\)}]],
    FontFamily->"Times"],
  "\"",
  StyleBox["   \n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] With the setting ",
  StyleBox["GridBaseline \[Rule] Center",
    FontFamily->"Courier"],
  StyleBox[", the center of the grid box is aligned with the baseline of the \
surrounding text. For example, \"",
    FontFamily->"Times"],
  Cell[BoxData[
      RowBox[{"This", ",", GridBox[{
            {"1", "0"},
            {"0", "1"}
            },
          GridBaseline->Center,
          GridFrame->True,
          RowLines->True,
          ColumnLines->True], ",", 
        "  ", \(is\ a\ 2\ \[Times]\ 2\ \(\(table\)\(.\)\)\)}]],
    FontFamily->"Times"],
  "\"",
  StyleBox[" \n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare]  Another possible setting is ",
  StyleBox["GridBaseline \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["name",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", {",
    FontFamily->"Courier"],
  StyleBox["i",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["j",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[", where ",
    FontFamily->"Times New Roman"],
  StyleBox["name",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[" refers to the {",
    FontFamily->"Times New Roman"],
  StyleBox["i",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times New Roman"],
  StyleBox["j",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["}th element instead of the entire grid box. ",
    FontFamily->"Times New Roman"],
  StyleBox["For example, ",
    FontFamily->"Times"],
  StyleBox["GridBaseline \[Rule] {Top, {2, 1}}",
    FontFamily->"Courier"],
  StyleBox[", means that the top of the element in the second row and first \
column of the grid box is aligned with the baseline of the surrounding text, \
as shown here. \"",
    FontFamily->"Times"],
  Cell[BoxData[
      RowBox[{"This", ",", GridBox[{
            {"1", "0"},
            {"0", "1"}
            },
          GridBaseline->{Top, {2, 1}},
          GridFrame->True,
          RowLines->True,
          ColumnLines->True], ",", 
        "  ", \(is\ a\ 2\ \[Times]\ 2\ \(\(table\)\(.\)\)\)}]],
    FontFamily->"Times"],
  "\"",
  StyleBox[" \n\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " The default setting is ",
  StyleBox["GridBaseline ",
    FontFamily->"Courier"],
  "\[Rule]",
  StyleBox[" Axis. ",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"2.3.5.10.6.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoDelete", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.7.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoDelete",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a grid box remains in place when all but one of its elements is deleted."
}], "Usage",
  CellTags->{"2.3.5.10.7.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoDelete",
    FontFamily->"Courier"],
  " controls what happens if you create a grid box and then remove all of its \
elements except for one. With the default setting ",
  StyleBox["AutoDelete \[Rule] True",
    FontFamily->"Courier"],
  ", the grid box surrounding the remaining element disappears. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["AutoDelete \[Rule] False",
    FontFamily->"Courier"],
  ", the single element continues to be enclosed in a grid box. "
}], "Notes",
  CellTags->{"2.3.5.10.7.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AllowScriptLevelChange", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.7.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AllowScriptLevelChange",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " entries in a grid box can have a ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " of ",
  StyleBox["0",
    FontFamily->"Courier"],
  "."
}], "Usage",
  CellTags->{"2.3.5.10.7.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[CellGroupData[{

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["AllowScriptLevelChange \[Rule] True",
    FontFamily->"Courier"],
  ", all entries in a grid box have a minimum ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " of ",
  StyleBox["1",
    FontFamily->"Courier"],
  ". The main effect this has is to make operators affected by ",
  StyleBox["LimitsPositioning",
    FontFamily->"Courier"],
  ", such as \[Sum], \[Product], and \[Integral], appear small, as shown \
below."
}], "Notes",
  CellTags->{"2.3.5.10.7.4", "2.3.5.10", "2.3.5.18.7"}],

Cell[BoxData[GridBox[{
        {\(\[Sum]\+\(j = 1\)\%100\), \(\[Product]\+\(i = 1\)\%n\)},
        {\(\[Integral]\_a\%b\), \(lim\+\(n \[Rule] \ \[Infinity]\)\)}
        },
      GridFrame->True,
      RowLines->True,
      ColumnLines->True,
      AllowScriptLevelChange->True]], "Input",
  ShowCellBracket->False,
  CellTags->"2.3.5.18.7"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["AllowScriptLevelChange \[Rule] False",
    FontFamily->"Courier"],
  ", elements of a grid box can have a ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " of ",
  StyleBox["0",
    FontFamily->"Courier"],
  ". This allows operators such as \[Sum], \[Product], and \[Integral], to \
appear larger, making for an improved visual effect, as shown below."
}], "Notes",
  CellTags->"2.3.5.18.7"],

Cell[BoxData[GridBox[{
        {\(\[Sum]\+\(j = 1\)\%100\), \(\[Product]\+\(i = 1\)\%n\)},
        {\(\[Integral]\_a\%b\), \(lim\+\(n \[Rule] \ \[Infinity]\)\)}
        },
      GridFrame->True,
      RowLines->True,
      ColumnLines->True,
      AllowScriptLevelChange->False]], "Input",
  ShowCellBracket->False,
  CellTags->"2.3.5.18.7"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ScriptLevel",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["LimitsPositioning",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"2.3.5.18.7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["RowSpacings ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.8.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowSpacings",
    FontFamily->"Courier"],
  " is an option for cells that determines the vertical spacing between \
successive rows of a grid box."
}], "Usage",
  CellTags->{"2.3.5.10.8.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] The spacing is specified in units of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-heights. The default setting is ",
  StyleBox["RowSpacings \[Rule] ",
    FontFamily->"Courier"],
  "1.\n\[FilledSmallSquare] You can also assign a different spacing for each \
row. ",
  StyleBox["RowSpacings \[Rule] ",
    FontFamily->"Courier"],
  "{",
  StyleBox["n1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n2",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n3",
    FontSlant->"Italic"],
  "......} means that the spacing after the first row is ",
  StyleBox["n1",
    FontSlant->"Italic"],
  ", after the second row ",
  StyleBox["n2",
    FontSlant->"Italic"],
  ", and so on. If the number of rows is greater than the number of elements \
in the list, the last element determines the spacing for all remaining rows. \
"
}], "Notes",
  CellTags->{"2.3.5.10.8.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ColumnSpacings ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.9.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnSpacings",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the horizontal spacing between successive columns of a \
grid box."
}], "Usage",
  CellTags->{"2.3.5.10.9.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] The spacing is specified in em units. The default \
setting is ",
  StyleBox["ColumnSpacings \[Rule] ",
    FontFamily->"Courier"],
  "0.8. \n\[FilledSmallSquare] You can also assign a different spacing for \
each column. The setting ",
  StyleBox["ColumnSpacings \[Rule] ",
    FontFamily->"Courier"],
  "{",
  StyleBox["n1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n2",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n3",
    FontSlant->"Italic"],
  "......} means that the spacing after the first column is ",
  StyleBox["n1",
    FontSlant->"Italic"],
  ", after the second column ",
  StyleBox["n2",
    FontSlant->"Italic"],
  ", and so on. If the number of columns is greater than the number of \
elements in the list, the last value in the list determines the spacing for \
all remaining columns. "
}], "Notes",
  CellTags->{"2.3.5.10.9.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ColumnWidths ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.10.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnWidths",
    FontFamily->"Courier"],
  " is an option for cells that determines the widths of columns in a grid \
box."
}], "Usage",
  CellTags->{"2.3.5.10.10.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["ColumnWidths \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["n, ",
    FontSlant->"Italic"],
  "all columns in the grid box have a width of ",
  StyleBox["n",
    FontSlant->"Italic"],
  " ems.\n\[FilledSmallSquare] With the setting ",
  StyleBox["ColumnWidths \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["n1, n2, ....",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  StyleBox[", the first column has width ",
    FontFamily->"Times"],
  StyleBox["n1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", the second has width ",
    FontFamily->"Times"],
  StyleBox["n2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", and so on. ",
    FontFamily->"Times"],
  "If the number of columns is greater than the number of elements in the \
list, the last element determines the width of all remaining columns. \n\
\[FilledSmallSquare] Values between 0 and 1 specify percentages of the \
current formatting width.  For example, ",
  StyleBox["ColumnWidths \[Rule] {.25, .5}",
    FontFamily->"Courier"],
  " makes the width of the first column, 25%,  and that of the second column, \
50% (of the current formatting width).\n\[FilledSmallSquare] With the default \
setting ",
  StyleBox["ColumnWidths \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the columns grow to be as large as needed to fit the widest entry in a \
column. \n\[FilledSmallSquare] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " is valid wherever a number is valid, ",
  "e.g.",
  StyleBox[",",
    FontSlant->"Italic"],
  " ",
  StyleBox["ColumnWidths->{.2, Automatic, 30}",
    FontFamily->"Courier"],
  ".\n   ",
  StyleBox["Note:",
    FontWeight->"Bold"],
  " For different columns to have different widths, the option ",
  StyleBox["ColumnsEqual",
    FontFamily->"Courier"],
  " must be set to ",
  StyleBox["False",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.10.10.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["RowAlignments ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.11.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowAlignments",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the vertical alignment of the rows in a grid box."
}], "Usage",
  CellTags->{"2.3.5.10.11.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["RowAlignments \[Rule] Baseline",
    FontFamily->"Courier"],
  ", all elements in the same row are vertically positioned so that their \
baselines coincide. \n\[FilledSmallSquare] Other possible settings are ",
  StyleBox["Top",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Bottom",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Center",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["Axis",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.10.11.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ColumnAlignments ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.12.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnAlignments",
    FontFamily->"Courier"],
  " is an option for cells that determines the horizontal alignment of the \
columns in a grid box."
}], "Usage",
  CellTags->{"2.3.5.10.12.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ColumnAlignments \[Rule] Center",
    FontFamily->"Courier"],
  ", all elements in the same row are horizontally positioned so that their \
vertical axes coincide. \n\[FilledSmallSquare] Other possible settings are ",
  StyleBox["Left",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Right",
    FontFamily->"Courier"],
  StyleBox[",",
    FontSlant->"Italic"],
  " and ",
  StyleBox["n, ",
    FontSlant->"Italic"],
  "where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is the amount of space in ems from the left edge of the column. "
}], "Notes",
  CellTags->{"2.3.5.10.12.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["RowMinHeight ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.13.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowMinHeight",
    FontFamily->"Courier"],
  " is an option for cells that determines the minimum height of a row in a \
grid box."
}], "Usage",
  CellTags->{"2.3.5.10.13.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowMinHeight",
    FontFamily->"Courier"],
  " is specified in units of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-heights. The default setting is ",
  StyleBox["RowMinHeight \[Rule] 1",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.5.10.13.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["RowsEqual ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.14.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowsEqual",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " all rows in a grid box have the same height. "
}], "Usage",
  CellTags->{"2.3.5.10.14.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["RowsEqual \[Rule] False",
    FontFamily->"Courier"],
  ", each row can have a different height depending on its contents. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["RowsEqual \[Rule] True",
    FontFamily->"Courier"],
  ", all rows are adjusted to have the same height as the row with the \
maximum height.  "
}], "Notes",
  CellTags->{"2.3.5.10.14.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ColumnsEqual ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.15.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnsEqual",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " all columns in a grid box have the same width. "
}], "Usage",
  CellTags->{"2.3.5.10.15.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ColumnsEqual \[Rule] False",
    FontFamily->"Courier"],
  ", each column can have a different width depending on its contents. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["ColumnsEqual \[Rule] True",
    FontFamily->"Courier"],
  ", all columns are adjusted to have the same width as the column with the \
maximum width.  "
}], "Notes",
  CellTags->{"2.3.5.10.15.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["MultilineFunction", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.16.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the contents of a grid box are wrapped to the next line when they do not \
fit within the width of the page or the column (in case of fixed column \
width). "
}], "Usage",
  CellTags->{"2.3.5.10.16.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", the contents of the grid box are not wrapped to the next line.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", ",
  StyleBox["the contents of a grid box that extend beyond the width of the \
page are automatically wrapped to the next line. This setting is not \
currently implemented.",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.5.10.16.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["GridDefaultElement  ", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.17.2", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridDefaultElement",
    FontFamily->"Courier"],
  " is an option for cells that determines which element is placed in every \
element of a grid box by default."
}], "Usage",
  CellTags->{"2.3.5.10.17.3", "2.3.5.10", "2.3.5.18.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] When a new table, matrix, or palette is created, the \
element specified by ",
  StyleBox["GridDefaultElement",
    FontFamily->"Courier"],
  " is automatically placed in each row and column. This element can be a \
character, a string, or even a typeset expression such as ",
  StyleBox["\\!\\(a\\/b\\)",
    FontFamily->"Courier"],
  StyleBox[" or ",
    FontFamily->"Times New Roman"],
  StyleBox["FractionBox[\"a\", \"b\"]",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] The default setting is ",
  StyleBox["GridDefaultElement \[Rule] Placeholder. ",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"2.3.5.10.17.4", "2.3.5.10", "2.3.5.18.7"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["InterpretationBoxOptions\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->{"2.3.5.11.2", "2.3.5.18.8"}],

Cell[TextData[{
  StyleBox["InterpretationBox",
    FontFamily->"Courier"],
  " objects provide a way to store hidden information in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " output. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides the following options for controlling the selection and editing \
of ",
  StyleBox["InterpretationBox",
    FontFamily->"Courier"],
  " objects."
}], "Text",
  CellTags->"2.3.5.18.8"],

Cell[CellGroupData[{

Cell["interpretation", "SubObjectNameClosed",
  CellTags->{"2.3.5.11.2.2", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["interpretation",
    FontSlant->"Italic"],
  " is an option for cells that determines how the contents of an \
interpretation box are to be interpreted. "
}], "Usage",
  CellTags->{"2.3.5.11.2.3", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " adds an interpretation box around any expression that is to be displayed \
in a form different from the form in which it is to be interpreted. ",
  StyleBox["InterpretationBox[", "MR"],
  StyleBox["boxes", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["interpretation",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " displays as ",
  StyleBox["boxes", "TI"],
  " but is interpreted on input as ",
  StyleBox["interpretation",
    FontSlant->"Italic"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["interpretation",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when an interpretation \
box is selected. "
}], "Notes",
  CellTags->{"2.3.5.11.2.4", "2.3.5.11", "2.3.5.18.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["TagStyle", "SubObjectNameClosed",
  CellTags->{"2.3.5.11.2.2", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TagStyle",
    FontFamily->"Courier"],
  " is an option for cells that determines the style used to display the \
contents of an interpretation box. "
}], "Usage",
  CellTags->{"2.3.5.11.2.3", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TagStyle",
    FontFamily->"Courier"],
  " can be set to any cell style defined in the style sheet of the notebook, \
for example ",
  StyleBox["\"Title\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Section\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Input\"",
    FontFamily->"Courier"],
  " or ",
  StyleBox["\"Text\"",
    FontFamily->"Courier"],
  ". The contents of the interpretation box are then displayed in that cell \
style. With the default setting ",
  StyleBox["TagStyle \[Rule] None",
    FontFamily->"Courier"],
  ", the expression inside the interpretation box",
  StyleBox[" inherits the style of the cell in which it occurs.",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.5.11.2.4", "2.3.5.11", "2.3.5.18.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Editable ", "SubObjectNameClosed",
  CellTags->{"2.3.5.11.3.2", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an expression inside an interpretation box can be interactively edited in \
the front end."
}], "Usage",
  CellTags->{"2.3.5.11.3.3", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] The expression inside an interpretation box can be \
edited if ",
  StyleBox["Editable \[Rule] True",
    FontFamily->"Courier"],
  ", but not if ",
  StyleBox["Editable \[Rule] False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] With the setting ",
  StyleBox["Editable \[Rule] Automatic",
    FontFamily->"Courier"],
  ", an interpretation box inherits the ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " setting of the cell in which it occurs, that is the box will be editable \
only if it occurs in an editable cell. "
}], "Notes",
  CellTags->{"2.3.5.11.3.4", "2.3.5.11", "2.3.5.18.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Selectable", "SubObjectNameClosed",
  CellTags->{"2.3.5.11.4.2", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Selectable",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an expression inside an interpretation box can be selected."
}], "Usage",
  CellTags->{"2.3.5.11.4.3", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Selectable \[Rule] Automatic",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.11.4.4", "2.3.5.11", "2.3.5.18.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoDelete ", "SubObjectNameClosed",
  CellTags->{"2.3.5.11.5.2", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoDelete",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an interpretation box",
  StyleBox[" is automatically deleted when the expression inside it is \
edited.",
    FontFamily->"Times"]
}], "Usage",
  CellTags->{"2.3.5.11.5.3", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["AutoDelete \[Rule] False",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.11.5.4", "2.3.5.11", "2.3.5.18.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DeletionWarning ", "SubObjectNameClosed",
  CellTags->{"2.3.5.11.6.2", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DeletionWarning",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a warning is given when an expression inside an interpretation box is \
edited."
}], "Usage",
  CellTags->{"2.3.5.11.6.3", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["DeletionWarning",
    FontFamily->"Courier"],
  "\[Rule]",
  StyleBox[" True",
    FontFamily->"Courier"],
  ", the first time you try to edit an expression inside an Interpretation \
Box a dialog box appears to warn you that the meaning of the expression being \
edited may be altered. \n\[FilledSmallSquare] The default setting is ",
  StyleBox["DeletionWarning \[Rule] False",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.11.6.4", "2.3.5.11", "2.3.5.18.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SyntaxForm", "SubObjectNameClosed",
  CellTags->{"2.3.5.11.7.2", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SyntaxForm",
    FontFamily->"Courier"],
  " is an option for cells that specifies the precedence level of the \
expression inside an interpretation box when considered as an operator."
}], "Usage",
  CellTags->{"2.3.5.11.7.3", "2.3.5.11", "2.3.5.18.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SyntaxForm",
    FontFamily->"Courier"],
  StyleBox[" is specified as a string containing an operator whose precedence \
level is the same as that of the expression inside the ",
    FontFamily->"Times"],
  "interpretation box",
  StyleBox[". For example, ",
    FontFamily->"Times"],
  StyleBox["SyntaxForm \[Rule] \"*\".",
    FontFamily->"Courier"],
  StyleBox[" You can also distinguish the infix and prefix form of an \
operator, for example, by setting ",
    FontFamily->"Times"],
  StyleBox["SyntaxForm",
    FontFamily->"Courier"],
  StyleBox[" to ",
    FontFamily->"Times"],
  StyleBox["\"a + b\"",
    FontFamily->"Courier"],
  StyleBox[" and ",
    FontFamily->"Times"],
  StyleBox["\"+ a\"",
    FontFamily->"Courier"],
  StyleBox[", respectively. \n\[FilledSmallSquare] With the default setting ",
    
    FontFamily->"Times"],
  StyleBox["SyntaxForm \[Rule] Automatic",
    FontFamily->"Courier"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["Mathematica",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" automatically ",
    FontFamily->"Times"],
  "assigns a precedence determined by the contents of the interpretation \
box",
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8"}]
}, Closed]],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["InterpretationBox",
    ButtonData:>{"InterpretationBox"},
    ButtonStyle->"RefGuideLink"],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"2.3.5.18.8"]
}, Closed]],

Cell[CellGroupData[{

Cell["PopupBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->{"2.3.5.12.2", "2.3.5.18.9"}],

Cell[CellGroupData[{

Cell["ButtonStyle ", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.2.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonStyle", "MR"],
  " is an option for cells that determines the default properties for a \
button. "
}], "Usage",
  CellTags->{"2.3.5.12.2.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] Typical styles defined in the standard notebook front \
end are as follows.\n",
  Cell[BoxData[GridBox[{
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Paste\\\\\\\\\\\
\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"paste the contents of the button (default) \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Evaluate\\\\\\\\\
\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"paste then evaluate in place what was pasted \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"EvaluateCell\\\\\
\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"paste then evaluate the whole cell \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"CopyEvaluate\\\\\
\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"copy the current selection into a new cell, then \
paste and evaluate in place \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\
CopyEvaluateCell\\\\\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"copy the current selection into a new cell, then \
paste and evaluate the whole cell \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Hyperlink\\\\\\\
\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"jump to a different location in the notebook \"\>",
              FontFamily->"Times"]}
          },
        ColumnAlignments->{Left}]], "Notes",
    CellTags->"ButtonStyle"],
  "\n\[FilledSmallSquare] The properties specified by a button style can \
affect both the appearance and action of a button. \n\[FilledSmallSquare] The \
properties can be overridden by explicit settings for ",
  StyleBox["ButtonBox", "MR"],
  " options. \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.8"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonFrame",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.2.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonFunction ", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.3.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonFunction", "MR"],
  " is an option for cells that determines the function to execute when the \
button is active and is clicked. "
}], "Usage",
  CellTags->{"2.3.5.12.3.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting for ",
  StyleBox["ButtonFunction", "MR"],
  " causes the button to paste its contents at your current notebook \
selection. \n\[FilledSmallSquare] ",
  StyleBox["ButtonFunction", "MR"],
  " is used only with the setting ",
  StyleBox["Active", "MR"],
  "\[Rule]",
  StyleBox["True", "MR"],
  ", either for the button or for the cell the button is in. \n\
\[FilledSmallSquare] With ",
  StyleBox["ButtonFunction", "MR"],
  "\[Rule]",
  StyleBox["f,", "TI"],
  " the first argument supplied to ",
  StyleBox["f", "TI"],
  " is specified by the setting for ",
  StyleBox["ButtonSource", "MR"],
  ", and the second argument by the setting for ",
  StyleBox["ButtonData", "MR"],
  ". \n\[FilledSmallSquare] Standard ",
  StyleBox["Mathematica", "TI"],
  " precedence rules require parentheses in ",
  StyleBox["ButtonFunction", "MR"],
  "\[Rule]",
  StyleBox["(", "MR"],
  StyleBox["body", "TI"],
  " ",
  StyleBox["&)", "MR"],
  ". \n\[FilledSmallSquare] Settings for ",
  StyleBox["ButtonFunction", "MR"],
  " are often inherited from button styles via the ",
  StyleBox["ButtonStyle", "MR"],
  " option. \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonEvaluator",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNote",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NotebookApply",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.3.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonEvaluator ", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.4.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonEvaluator", "MR"],
  " ",
  "is an option for cells",
  " that determines where the expression constructed from ",
  StyleBox["ButtonFunction", "MR"],
  " should be sent for evaluation. "
}], "Usage",
  CellTags->{"2.3.5.12.4.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonEvaluator", "MR"],
  "\[Rule]",
  StyleBox["None", "MR"],
  ". \n\[FilledSmallSquare] Possible settings are: \n",
  Cell[BoxData[GridBox[{
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"None\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"the front end \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Automatic\\\\\\\"\\\", \\\"MR\\\
\"]\\) \"\>", 
            
            StyleBox["\<\"the kernel used by default in the current notebook \
\"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\\\\\\\"\\\", \
\\\"MR\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\"name\\\\\\\"\\\", \
\\\"TI\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"a kernel referred to by a specific name \"\>",
              FontFamily->"Times"]}
          },
        ColumnAlignments->{Left}]], "Notes",
    CellTags->"ButtonEvaluator"],
  "\n\[FilledSmallSquare] With ",
  StyleBox["ButtonEvaluator", "MR"],
  "\[Rule]",
  StyleBox["Automatic", "MR"],
  ", the expression to be evaluated can contain any ",
  StyleBox["Mathematica", "TI"],
  " objects. \n\[FilledSmallSquare] With ",
  StyleBox["ButtonEvaluator", "MR"],
  "\[Rule]",
  StyleBox["None", "MR"],
  ", the expression can contain only the specific notebook commands supported \
by the front end. All these commands are in the context ",
  StyleBox["FrontEnd`", "MR"],
  ". Expressions intended for processing only by the front end must be \
wrapped with ",
  StyleBox["FrontEndExecute", "MR"],
  ". \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SelectionEvaluate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.4.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonSource", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.5.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonSource", "MR"],
  " is an option for cells that determines the first argument to give to the \
",
  StyleBox["ButtonFunction", "MR"],
  " for the button when it is active and is clicked on. "
}], "Usage",
  CellTags->{"2.3.5.12.5.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default is ",
  StyleBox["ButtonSource", "MR"],
  "\[Rule]",
  StyleBox["Automatic", "MR"],
  ". \n\[FilledSmallSquare] Possible settings are: \n",
  Cell[BoxData[GridBox[{
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Automatic\\\\\\\"\\\", \\\"MR\\\
\"]\\) \"\>", 
            
            StyleBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonData\\\\\\\"\\\"\
, \\\"MR\\\"]\\) if it is set, otherwise \
\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonContents\\\\\\\"\\\", \\\"MR\\\"]\\) \
\"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonContents\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"the first argument of the \
\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonBox\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonData\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"the setting for the \
\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonData\\\\\\\"\\\", \\\"MR\\\"]\\) option \
\"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Cell\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"the whole cell in which the button appears \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"CellContents\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"the contents of the cell in which the button \
appears \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Notebook\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", 
            
            StyleBox["\<\"the whole notebook in which the button appears \
\"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"n\\\\\\\"\\\", \\\"TI\\\"]\\) \
\"\>", 
            
            StyleBox["\<\"the expression \
\\!\\(\\*StyleBox[\\\"\\\\\\\"n\\\\\\\"\\\", \\\"TI\\\"]\\) levels up from \
the button in the notebook \"\>",
              FontFamily->"Times"]}
          },
        ColumnAlignments->{Left}]], "Notes",
    CellTags->"ButtonSource"],
  "\n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonData",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NotebookRead",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.5.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonData ", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.6.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonData", "MR"],
  " is an option for cells that determines the second argument to give to the \
",
  StyleBox["ButtonFunction", "MR"],
  " for a button when it is active and is clicked. "
}], "Usage",
  CellTags->{"2.3.5.12.6.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default is ",
  StyleBox["ButtonData", "MR"],
  "\[Rule]",
  StyleBox["Null", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ButtonData", "MR"],
  " provides a convenient way to associate additional data with a button that \
does not affect the display of the button. \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonSource",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNote",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.6.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonNote", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.7.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonNote", "MR"],
  " ",
  "is an option for cells",
  " that determines what should be displayed in the status line of the \
current notebook window when the button is active and the cursor is placed on \
top of it. "
}], "Usage",
  CellTags->{"2.3.5.12.7.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default is to display whatever setting is given \
for ",
  StyleBox["ButtonData", "MR"],
  ". \n\[FilledSmallSquare] Any expression can be specified as the setting \
for ",
  StyleBox["ButtonNote", "MR"],
  ", though most windows will only allow a single character height to be \
displayed. \n\[FilledSmallSquare] ",
  StyleBox["ButtonNote", "MR"],
  " can be used to display keyboard equivalents for buttons in a palette. \n\
\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonData",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.7.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonFrame", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.8.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonFrame", "MR"],
  " ",
  "is an option for cells",
  " that determines the type of frame to display around a button. "
}], "Usage",
  CellTags->{"2.3.5.12.8.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonFrame",
    FontFamily->"Courier"],
  StyleBox[" ", "MR"],
  "\[Rule]",
  StyleBox[" Palette", "MR"],
  "\n\[FilledSmallSquare] Typical settings supported include: \n",
  Cell[BoxData[GridBox[{
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Palette\\\\\\\\\
\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"include button in a palette \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"DialogBox\\\\\\\
\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"button in a dialog box \"\>",
              FontFamily->"Times"]},
          {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"None\\\\\\\\\\\\\
\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
            StyleBox["\<\"button with no frame \"\>",
              FontFamily->"Times"]}
          },
        ColumnAlignments->{Left}]], "Notes",
    CellTags->"ButtonFrame"],
  "\n\[FilledSmallSquare] Button frames generated by ",
  StyleBox["ButtonFrame", "MR"],
  " are set up to follow the conventions for particular computer systems. \n\
\[FilledSmallSquare] A button with a particular setting for ",
  StyleBox["ButtonFrame", "MR"],
  " may look slightly different on different computer systems. \n\
\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowFrame",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.8.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Background", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.9.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background", "MR"],
  " ",
  "is an option for cells",
  " which specifies the background color of a button. "
}], "Usage",
  CellTags->{"2.3.5.12.9.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background", "MR"],
  " is specified using a ",
  StyleBox["CMYKColor", "MR"],
  ", ",
  StyleBox["GrayLevel", "MR"],
  ", ",
  StyleBox["Hue", "MR"],
  ", or ",
  StyleBox["RGBColor", "MR"],
  " command.\n\[FilledSmallSquare] The default setting in graphics functions \
is ",
  StyleBox["Background", "MR"],
  "\[Rule]",
  StyleBox["GrayLevel[", "MR"],
  StyleBox["0.", "MR"],
  StyleBox["839246",
    FontFamily->"Courier"],
  StyleBox["]", "MR"],
  ", which produces a light gray background on most output devices. "
}], "Notes",
  CellTags->{"2.3.5.12.9.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonMargins ", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.10.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonMargins", "MR"],
  " is an option for cells that determines how much space in printer's points \
should be left around the contents of a button when the button is displayed. \
"
}], "Usage",
  CellTags->{"2.3.5.12.10.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonMargins", "MR"],
  "\[Rule]",
  StyleBox["3", "MR"],
  ". \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonExpandable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonMinHeight",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.10.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonMinHeight", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.11.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonMinHeight", "MR"],
  " ",
  "is an option for cells",
  " that determines the minimum total height in units of font size that \
should be allowed for the button. "
}], "Usage",
  CellTags->{"2.3.5.12.11.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting ",
  StyleBox["ButtonMinHeight", "MR"],
  "\[Rule]",
  StyleBox["1", "MR"],
  " forces a button to have a total height that at least accommodates all the \
characters in the current font. \n\[FilledSmallSquare] ",
  StyleBox["ButtonMinHeight", "MR"],
  "\[Rule]",
  StyleBox["0", "MR"],
  " reduces the total height of a button as much as possible, allowing \
buttons containing characters such as ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["X", "MR"],
  " to be different heights. \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonExpandable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["RowMinHeight",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.11.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonExpandable ", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.12.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonExpandable", "MR"],
  " is an option for cells that determines ",
  "if",
  " the button should expand to fill any ",
  StyleBox["GridBox", "MR"],
  " position in which it appears. "
}], "Usage",
  CellTags->{"2.3.5.12.12.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonExpandable", "MR"],
  "\[Rule]",
  StyleBox["True", "MR"],
  ". \n\[FilledSmallSquare] This setting is usually used for all buttons that \
appear in palettes. \n\[FilledSmallSquare] With ",
  StyleBox["ButtonExpandable", "MR"],
  "\[Rule]",
  StyleBox["False", "MR"],
  " the size of a button is determined only by its contents, independent of \
its environment. \n\[FilledSmallSquare] With ",
  StyleBox["ButtonExpandable", "MR"],
  "\[Rule]",
  StyleBox["False", "MR"],
  ", gutters will often be left between buttons in a ",
  StyleBox["GridBox", "MR"],
  ". \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonMinHeight",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.12.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Active ", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.13.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Active", "MR"],
  " is an option for cells that determines if any button in the cell is \
active. "
}], "Usage",
  CellTags->{"2.3.5.12.13.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["Active", "MR"],
  "\[Rule]",
  StyleBox["False", "MR"],
  ", the contents of a button can be edited. \n\[FilledSmallSquare] With ",
  StyleBox["Active", "MR"],
  "\[Rule]",
  StyleBox["True", "MR"],
  ", a button will perform an action when it is clicked. \n\
\[FilledSmallSquare] Active cells are indicated by an ",
  StyleBox["A", "MR"],
  " in the cell bracket. \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.9.10",
    ButtonData:>{"2.9.10", "10.33"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Evaluator",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.12.13.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["PopDirection ", "SubObjectNameClosed",
  CellTags->{"2.3.5.12.14.2", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["PopDirection",
    FontFamily->"Courier"],
  " is a front end that determines the direction in which a pop-up box \
element extends when it is clicked."
}], "Usage",
  CellTags->{"2.3.5.12.14.3", "2.3.5.12", "2.3.5.18.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["PopDirection \[Rule] Right",
    FontFamily->"Courier"],
  ". Other possible settings are ",
  StyleBox["Up",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Down",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Left",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Over",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.5.12.14.4", "2.3.5.12", "2.3.5.18.9"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["RadicalBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.5.13.2", "2.3.5.18.10"}],

Cell[CellGroupData[{

Cell["ExponentPosition ", "SubObjectNameClosed",
  CellTags->{"2.3.5.13.2.2", "2.3.5.13", "2.3.5.18.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ExponentPosition",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the placement of the index outside a radical sign. "
}], "Usage",
  CellTags->{"2.3.5.13.2.3", "2.3.5.13", "2.3.5.18.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ExponentPosition",
    FontFamily->"Courier"],
  " \[Rule]",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " shifts the exponent ",
  StyleBox["x",
    FontSlant->"Italic"],
  " units horizontally and ",
  StyleBox["y",
    FontSlant->"Italic"],
  " units vertically from a standard position. The numbers ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  " can take both negative and positive values and are measured in units of \
ems and ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-heights, respectively. "
}], "Notes",
  CellTags->{"2.3.5.13.2.4", "2.3.5.13", "2.3.5.18.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell["MultilineFunction ", "SubObjectNameClosed",
  CellTags->{"2.3.5.13.3.2", "2.3.5.13", "2.3.5.18.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a radical expression is split across multiple lines if it is too long to \
fit on a single line. "
}], "Usage",
  CellTags->{"2.3.5.13.3.3", "2.3.5.13", "2.3.5.18.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the numbers associated with a radical sign may be reformatted to extend \
across two or more lines. The \"^\" notation is used to specify the exponent. \
The point at which the ",
  "line break",
  " is applied is indicated by a \[Continuation] symbol.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", no reformatting is done."
}], "Notes",
  CellTags->{"2.3.5.13.3.4", "2.3.5.13", "2.3.5.18.10"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SqrtBoxOptions\[LongRightArrow]{\[Ellipsis]} ", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.5.14.2", "2.3.5.18.11"}],

Cell[CellGroupData[{

Cell["MultilineFunction ", "SubObjectNameClosed",
  CellTags->{"2.3.5.14.2.2", "2.3.5.14", "2.3.5.18.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the expression inside a square root sign is split across multiple lines \
if it is too long to fit on a single line. "
}], "Usage",
  CellTags->{"2.3.5.14.2.3", "2.3.5.14", "2.3.5.18.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the expression inside a square root sign can be reformatted to extend \
across more than one line. The \"^\" notation is used to specify the \
exponent.The point at which the ",
  "line break",
  " is applied is indicated by a \[Continuation] symbol.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", no reformatting is done."
}], "Notes",
  CellTags->{"2.3.5.14.2.4", "2.3.5.14", "2.3.5.18.11"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SubscriptBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.5.15.2", "2.3.5.18.12"}],

Cell[CellGroupData[{

Cell["MultilineFunction ", "SubObjectNameClosed",
  CellTags->{"2.3.5.15.2.2", "2.3.5.15", "2.3.5.18.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a subscript is split to the next line if it is too long to fit on one \
line.  "
}], "Usage",
  CellTags->{"2.3.5.15.2.3", "2.3.5.15", "2.3.5.18.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a subscript may be reformatted to extend across two or more lines. The \
point at which the ",
  "line break",
  " is applied is indicated by a \[Continuation] symbol.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", no reformatting is done."
}], "Notes",
  CellTags->{"2.3.5.15.2.4", "2.3.5.15", "2.3.5.18.12"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SubsuperscriptBoxOptions\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  Background->None,
  CellTags->{"2.3.5.16.2", "2.3.5.18.13"}],

Cell[CellGroupData[{

Cell["MultilineFunction ", "SubObjectNameClosed",
  CellTags->{"2.3.5.16.2.2", "2.3.5.16", "2.3.5.18.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a subscript and/or superscript is split to the next line if it is too \
long to fit on one line.  "
}], "Usage",
  CellTags->{"2.3.5.16.2.3", "2.3.5.16", "2.3.5.18.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a subscript and/or superscript may be reformatted to extend across two \
or more lines.  The point at which the ",
  "line break",
  " is applied is indicated by a \[Continuation] symbol.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", no reformatting is done. "
}], "Notes",
  CellTags->{"2.3.5.16.2.4", "2.3.5.16", "2.3.5.18.13"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SuperscriptBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->{"2.3.5.17.2", "2.3.5.18.14"}],

Cell[CellGroupData[{

Cell["MultilineFunction ", "SubObjectNameClosed",
  CellTags->{"2.3.5.17.2.2", "2.3.5.17", "2.3.5.18.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a superscript is split to the next line if it is too long to fit on one \
line.  "
}], "Usage",
  CellTags->{"2.3.5.17.2.3", "2.3.5.17", "2.3.5.18.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a superscript may be reformatted to extend across two or more lines. The \
\"^\" notation is used to specify the superscript. The point at which the ",
  "line break",
  " is applied is indicated by a \[Continuation] symbol.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", no reformatting is done."
}], "Notes",
  CellTags->{"2.3.5.17.2.4", "2.3.5.17", "2.3.5.18.14"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["TagBoxOptions\[LongRightArrow]{\[Ellipsis]} ", "GroupObjectName",
  Background->None,
  CellTags->"2.3.5.18.15"],

Cell[TextData[{
  StyleBox["TagBox",
    FontFamily->"Courier"],
  " objects are used to store information that will not be displayed, but can \
nevertheless be used by the rules that interpret boxes. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides the following options for controlling the selection and editing \
of ",
  StyleBox["TagBox",
    FontFamily->"Courier"],
  " objects."
}], "Text",
  CellTags->"2.3.5.18.15"],

Cell[CellGroupData[{

Cell["tag", "SubObjectNameClosed",
  CellTags->{"2.3.5.18.2.2", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["tag",
    FontSlant->"Italic"],
  " is an option for cells that determines how the contents of a tag box are \
to be interpreted. "
}], "Usage",
  CellTags->{"2.3.5.18.2.3", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] Tag boxes provide a way to store hidden information \
in ",
  StyleBox["Mathematica", "TI"],
  " output. ",
  StyleBox["TagBox[", "MR"],
  StyleBox["boxes", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["tag",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " displays as ",
  StyleBox["boxes", "TI"],
  " but is interpreted on input as ",
  StyleBox["tag",
    FontSlant->"Italic"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["tag",
    FontSlant->"Italic"],
  " appears grayed-out in the Option Inspector, except when a tag box is \
selected. "
}], "Notes",
  CellTags->{"2.3.5.18.2.4", "2.3.5.18.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["TagStyle", "SubObjectNameClosed",
  CellTags->{"2.3.5.18.2.2", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TagStyle",
    FontFamily->"Courier"],
  " is an option for cells that determines the style used to display the \
contents of a tag box."
}], "Usage",
  CellTags->{"2.3.5.18.2.3", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["TagStyle",
    FontFamily->"Courier"],
  " can be set to any cell style defined in the style sheet of the notebook, \
e.g. ",
  StyleBox["\"Title\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Section\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Input\"",
    FontFamily->"Courier"],
  ", or ",
  StyleBox["\"Text\"",
    FontFamily->"Courier"],
  ". The contents of the tag box are then displayed in that cell style. With \
the default setting ",
  StyleBox["TagStyle \[Rule] None",
    FontFamily->"Courier"],
  ", the expression inside the tag box",
  StyleBox[" inherits the style of the cell in which it occurs.",
    FontFamily->"Times"],
  "\n\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " adds a tag box around any expression that is displayed in a form \
different from the form in which it is interpreted. "
}], "Notes",
  CellTags->{"2.3.5.18.2.4", "2.3.5.18.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Editable ", "SubObjectNameClosed",
  CellTags->{"2.3.5.18.3.2", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an expression inside a tag box can be interactively edited in the front \
end."
}], "Usage",
  CellTags->{"2.3.5.18.3.3", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] The expression inside a tag box can be edited if ",
  StyleBox["Editable \[Rule] True",
    FontFamily->"Courier"],
  ", but not if ",
  StyleBox["Editable \[Rule] False",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] With the setting ",
  StyleBox["Editable \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a tag box inherits the ",
  StyleBox["Editable",
    FontFamily->"Courier"],
  " setting of the cell in which it occurs, that is a tag box  will be \
editable only if it occurs in an editable cell. "
}], "Notes",
  CellTags->{"2.3.5.18.3.4", "2.3.5.18.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Selectable", "SubObjectNameClosed",
  CellTags->{"2.3.5.18.4.2", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Selectable",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an expression inside a tag box can be selected."
}], "Usage",
  CellTags->{"2.3.5.18.4.3", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["Selectable \[Rule] Automatic",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.18.4.4", "2.3.5.18.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoDelete ", "SubObjectNameClosed",
  CellTags->{"2.3.5.18.5.2", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoDelete",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a tag box",
  StyleBox[" is automatically deleted when the expression inside it is \
edited.",
    FontFamily->"Times"]
}], "Usage",
  CellTags->{"2.3.5.18.5.3", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["AutoDelete \[Rule] False",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.18.5.4", "2.3.5.18.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["StripWrapperBoxes ", "SubObjectNameClosed",
  CellTags->{"2.3.5.18.6.2", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["StripWrapperBoxes",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a tag box wrapped around an expression is removed when the expression is \
sent to the kernel for evaluation. "
}], "Usage",
  CellTags->{"2.3.5.18.6.3", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option determines if non-semantic changes, such \
as style changes and white space are removed when sending an expression to \
the kernel. These changes are normally stripped so that patterns which \
interpret the meaning of a box expression are much simpler to write. \n\
\[FilledSmallSquare] The default setting is ",
  StyleBox["StripWrapperBoxes \[Rule] False",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] See also: ",
  ButtonBox["MakeExpression",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.18.6.4", "2.3.5.18.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["DeletionWarning ", "SubObjectNameClosed",
  CellTags->{"2.3.5.18.7.2", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DeletionWarning",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a warning is given when an expression inside a tag box is edited."
}], "Usage",
  CellTags->{"2.3.5.18.7.3", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["DeletionWarning \[Rule] True",
    FontFamily->"Courier"],
  ",  the first time you edit an expression inside a tag box, a dialog box \
appears to warn you that the meaning of the expression being edited may be \
altered.\n\[FilledSmallSquare] The default setting is ",
  StyleBox["DeletionWarning \[Rule] False",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.5.18.7.4", "2.3.5.18.15"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SyntaxForm", "SubObjectNameClosed",
  CellTags->{"2.3.5.18.8.2", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SyntaxForm",
    FontFamily->"Courier"],
  " is an option for cells that specifies the precedence level of the \
expression inside a tag box."
}], "Usage",
  CellTags->{"2.3.5.18.8.3", "2.3.5.18.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SyntaxForm",
    FontFamily->"Courier"],
  StyleBox[" is specified as a string containing an operator whose precedence \
level is the same as that of the expression inside the ",
    FontFamily->"Times"],
  "tag box",
  StyleBox[". For example, ",
    FontFamily->"Times"],
  StyleBox["SyntaxForm \[Rule] \"*\".",
    FontFamily->"Courier"],
  StyleBox[" You can also distinguish the infix and prefix form of an \
operator, for example, by setting ",
    FontFamily->"Times"],
  StyleBox["SyntaxForm",
    FontFamily->"Courier"],
  StyleBox[" to ",
    FontFamily->"Times"],
  StyleBox["\"a + b\"",
    FontFamily->"Courier"],
  StyleBox[" and ",
    FontFamily->"Times"],
  StyleBox["\"+ a\"",
    FontFamily->"Courier"],
  ",",
  StyleBox[" respectively. \n\[FilledSmallSquare] With the default setting ",
    FontFamily->"Times"],
  StyleBox["SyntaxForm \[Rule] Automatic",
    FontFamily->"Courier"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["Mathematica",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" automatically ",
    FontFamily->"Times"],
  "assigns a precedence determined by the contents of the tag box",
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.5.18.8.4", "2.3.5.18.15"}]
}, Closed]],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["TagBox",
    ButtonData:>{"TagBox"},
    ButtonStyle->"RefGuideLink"],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"2.3.5.18.15"]
}, Closed]],

Cell[CellGroupData[{

Cell["UnderScriptBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->"2.3.5.18.16"],

Cell[CellGroupData[{

Cell["LimitsPositioning", "SubObjectNameClosed",
  CellTags->"2.3.5.18.16"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LimitsPositioning", "MR"],
  " is an option for cells that determines whether or not to change the \
positioning of underscripts and overscripts in the way conventional for \
limits. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->"2.3.5.18.16"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False]", "MR"],
  " is always displayed with explicit underscripts and overscripts, as ",
  Cell[BoxData[
      UnderoverscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True]", "MR"],
  " is displayed as ",
  Cell[BoxData[
      UnderoverscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " when large, and ",
  Cell[BoxData[
      SubsuperscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " when small. \n\[FilledSmallSquare] The ",
  Cell[BoxData[
      SubsuperscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " form is used when the box appears in a subscript or other script, or \
inline in a piece of text. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  ", the display of ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " depends on ",
  StyleBox["x", "TI"],
  ". If ",
  StyleBox["x", "TI"],
  " is \[Backslash]",
  StyleBox["[Sum]", "MR"],
  ", \[Backslash]",
  StyleBox["[Product]", "MR"],
  " or another form conventionally displayed with limits, then ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  " is effectively used. Otherwise, ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  " is used. \n\[FilledSmallSquare] ",
  StyleBox["LimitsPositioningTokens", "MR"],
  " is a ",
  StyleBox["Cell", "MR"],
  " option that can be set to a list of forms for which ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  " should be used. \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.63"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["LimitsPositioningTokens",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["ScriptSizeMultipliers",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->"2.3.5.18.16"]
}, Closed]],

Cell[CellGroupData[{

Cell["DiacriticalPositioning ", "SubObjectNameClosed",
  CellTags->"2.3.5.18.16"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DiacriticalPositioning",
    FontFamily->"Courier"],
  " is an option for cells that determines how close diacritical characters \
are drawn to the base character."
}], "Usage",
  CellTags->"2.3.5.18.16"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["DiacriticalPositioning \[Rule] True",
    FontFamily->"Courier"],
  ", characters that occur in an underscript position are drawn relatively \
close to the base character .\n\[FilledSmallSquare] With the setting ",
  StyleBox["DiacriticalPositioning \[Rule] False",
    FontFamily->"Courier"],
  ", characters that occur in an underscript or overscript position are drawn \
at a greater separation from the base character.\n\[FilledSmallSquare] With \
the default setting ",
  StyleBox["DiacriticalPositioning \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a selected set of characters, which are normally used as diacritical \
marks, are by default drawn close to the base character when used in an \
underscript. All other characters are drawn at a greater separation from the \
base character."
}], "Notes",
  CellTags->"2.3.5.18.16"]
}, Closed]],

Cell[CellGroupData[{

Cell["MultilineFunction ", "SubObjectNameClosed",
  CellTags->"2.3.5.18.16"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines if an underscript is split to the \
next line if it is too long to fit on one line.  "
}], "Usage",
  CellTags->"2.3.5.18.16"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a underscript may be reformatted to extend across two or more lines. The \
point at which the ",
  "line break",
  " is applied is indicated by a \[Continuation] symbol.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", no reformatting is done."
}], "Notes",
  CellTags->"2.3.5.18.16"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["OverScriptBoxOptions\[LongRightArrow]{\[Ellipsis]}", "GroupObjectName",
  Background->None,
  CellTags->"2.3.5.18.17"],

Cell[CellGroupData[{

Cell["LimitsPositioning", "SubObjectNameClosed",
  CellTags->"2.3.5.18.17"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LimitsPositioning", "MR"],
  " is an option for cells that determines whether to change the positioning \
of underscripts and overscripts in the way conventional for limits. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->"2.3.5.18.17"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False]", "MR"],
  " is always displayed with explicit underscripts and overscripts, as ",
  Cell[BoxData[
      UnderoverscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True]", "MR"],
  " is displayed as ",
  Cell[BoxData[
      UnderoverscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " when large, and ",
  Cell[BoxData[
      SubsuperscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " when small. \n\[FilledSmallSquare] The ",
  Cell[BoxData[
      SubsuperscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " form is used when the box appears in a subscript or other script, or \
inline in a piece of text. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR"],
  ", the display of ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " depends on ",
  StyleBox["x", "TI"],
  ". If ",
  StyleBox["x", "TI"],
  " is \[Backslash]",
  StyleBox["[Sum]", "MR"],
  ", \[Backslash]",
  StyleBox["[Product]", "MR"],
  " or another form conventionally displayed with limits, then ",
  StyleBox["LimitsPositioning->True", "MR"],
  " is effectively used. Otherwise, ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  " is used. \n\[FilledSmallSquare] ",
  StyleBox["LimitsPositioningTokens", "MR"],
  " is a ",
  StyleBox["Cell", "MR"],
  " option that can be set to a list of forms for which ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  " should be used. \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.63"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["LimitsPositioningTokens",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["ScriptSizeMultipliers",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->"2.3.5.18.17"]
}, Closed]],

Cell[CellGroupData[{

Cell["DiacriticalPositioning ", "SubObjectNameClosed",
  CellTags->"2.3.5.18.17"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DiacriticalPositioning",
    FontFamily->"Courier"],
  " is an option for cells that determines how close diacritical characters \
are drawn to the base character. "
}], "Usage",
  CellTags->"2.3.5.18.17"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["DiacriticalPositioning \[Rule] True",
    FontFamily->"Courier"],
  ", characters that occur in an overscript position are drawn relatively \
close to the base character .\n\[FilledSmallSquare] With the setting ",
  StyleBox["DiacriticalPositioning \[Rule] False",
    FontFamily->"Courier"],
  ", characters that occur in an overscript position are drawn at a greater \
separation from the base character",
  ".",
  "\n\[FilledSmallSquare] With the default setting ",
  StyleBox["DiacriticalPositioning \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a selected set of characters, which are normally used as diacritical \
marks, are by default drawn close to the base character, when used in an \
overscript. All other characters are drawn at a greater separation from the \
base character."
}], "Notes",
  CellTags->"2.3.5.18.17"]
}, Closed]],

Cell[CellGroupData[{

Cell["MultilineFunction ", "SubObjectNameClosed",
  CellTags->"2.3.5.18.17"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an overscript is split to the next line if it is too long to fit on one \
line.  "
}], "Usage",
  CellTags->"2.3.5.18.17"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", an overscript may be reformatted to extend across two or more lines. The \
point at which the ",
  "line break",
  " is applied is indicated by a \[Continuation] symbol.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", no reformatting is done."
}], "Notes",
  CellTags->"2.3.5.18.17"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["UnderoverscriptBoxOptions\[LongRightArrow]{\[Ellipsis]}", \
"GroupObjectName",
  Background->None,
  CellTags->"2.3.5.18.18"],

Cell[CellGroupData[{

Cell["LimitsPositioning", "SubObjectNameClosed",
  CellTags->"2.3.5.18.18"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LimitsPositioning", "MR"],
  " is an option for cells that determines whether to change the positioning \
of underscripts and overscripts in the way conventional for limits. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->"2.3.5.18.18"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False]", "MR"],
  " is always displayed with explicit underscripts and overscripts, as ",
  Cell[BoxData[
      UnderoverscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["LimitsPositioning", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True]", "MR"],
  " is displayed as ",
  Cell[BoxData[
      UnderoverscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " when large, and ",
  Cell[BoxData[
      SubsuperscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " when small. \n\[FilledSmallSquare] The ",
  Cell[BoxData[
      SubsuperscriptBox[
        StyleBox["x",
          "it"], 
        StyleBox["y",
          "it"], 
        StyleBox["z",
          "it"]]], "InlineFormula"],
  " form is used when the box appears in a subscript or other script, or \
inline in a piece of text. \n\[FilledSmallSquare] With the default setting ",
  StyleBox["LimitsPositioning \[Rule] Automatic", "MR"],
  " the display of ",
  StyleBox["UnderoverscriptBox[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " depends on ",
  StyleBox["x", "TI"],
  ". If ",
  StyleBox["x", "TI"],
  " is \[Backslash]",
  StyleBox["[Sum]", "MR"],
  ", \[Backslash]",
  StyleBox["[Product]", "MR"],
  " or another form conventionally displayed with limits, then ",
  StyleBox["LimitsPositioning \[Rule] True", "MR"],
  " is effectively used. Otherwise, ",
  StyleBox["LimitsPositioning->False", "MR"],
  " is used. \n\[FilledSmallSquare] ",
  StyleBox["LimitsPositioningTokens", "MR"],
  " is a ",
  StyleBox["Cell", "MR"],
  " option which can be set to a list of forms for which ",
  StyleBox["LimitsPositioning \[Rule] True", "MR"],
  " should be used. \n\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book: ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.63"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["LimitsPositioningTokens",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["ScriptSizeMultipliers",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->"2.3.5.18.18"]
}, Closed]],

Cell[CellGroupData[{

Cell["DiacriticalPositioning ", "SubObjectNameClosed",
  CellTags->"2.3.5.18.18"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["DiacriticalPositioning",
    FontFamily->"Courier"],
  " is an option for cells that determines how close diacritical characters \
are drawn to the base character. "
}], "Usage",
  CellTags->"2.3.5.18.18"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["DiacriticalPositioning \[Rule] True",
    FontFamily->"Courier"],
  ", characters that occur in an underscript or overscript position are drawn \
relatively close to the base character .\n\[FilledSmallSquare] With the \
setting ",
  StyleBox["DiacriticalPositioning \[Rule] False",
    FontFamily->"Courier"],
  ", characters that occur in an underscript or overscript position are drawn \
at a greater separation from the base character.\n\[FilledSmallSquare] With \
the default setting ",
  StyleBox["DiacriticalPositioning \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a selected set of characters, which are normally used as diacritical \
marks, are by default drawn close to the base character, when used in an \
underscript or overscript. All other characters are drawn at a greater \
separation from the base character."
}], "Notes",
  CellTags->"2.3.5.18.18"]
}, Closed]],

Cell[CellGroupData[{

Cell["MultilineFunction ", "SubObjectNameClosed",
  CellTags->"2.3.5.18.18"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MultilineFunction",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an underscript and/or overscript is split to the next line if it is too \
long to fit on one line.  "
}], "Usage",
  CellTags->"2.3.5.18.18"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["MultilineFunction \[Rule] Automatic",
    FontFamily->"Courier"],
  ", an underscript and/or overscript may be reformatted to extend across two \
or more lines. The point at which the ",
  "line break",
  " is applied is indicated by a \[Continuation] symbol.\n\
\[FilledSmallSquare] With the setting ",
  StyleBox["MultilineFunction \[Rule] None",
    FontFamily->"Courier"],
  ", no reformatting is done."
}], "Notes",
  CellTags->"2.3.5.18.18"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Spanning Character Options", "SubsubsectionIcon",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->"2.3.5.19"],

Cell[CellGroupData[{

Cell["SpanMinSize", "ObjectName",
  CellTags->{"2.3.5.19.2.2", "2.3.5.19.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SpanMinSize",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the minimum size of spanning characters such as \
parentheses and brackets. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.2.3", "2.3.5.19.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["SpanMinSize \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the size of each spanning character is set to an appropriate default \
value.  \n\[FilledSmallSquare] With the setting ",
  StyleBox["SpanMinSize \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["k",
    FontSlant->"Italic"],
  ", the minimum size of each spanning character is ",
  StyleBox["k",
    FontSlant->"Italic"],
  " times its default size. "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.2.4", "2.3.5.19.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SpanMaxSize ", "ObjectName",
  CellTags->{"2.3.5.19.3.2", "2.3.5.19.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SpanMaxSize",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the maximum size of spanning characters such as \
parentheses and brackets."
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.3.3", "2.3.5.19.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["SpanMaxSize \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the maximum size of each spanning character is set to an appropriate \
default value.  \n\[FilledSmallSquare] With the setting ",
  StyleBox["SpanMaxSize \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["k",
    FontSlant->"Italic"],
  ", the maximum size of each spanning character is ",
  StyleBox["k",
    FontSlant->"Italic"],
  " times its default size. "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.3.4", "2.3.5.19.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SpanSymmetric ", "ObjectName",
  CellTags->{"2.3.5.19.4.2", "2.3.5.19.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SpanSymmetric",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " an expression enclosed between spanning characters is adjusted to appear \
more symmetric. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.4.3", "2.3.5.19.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] Certain types of expressions can appear asymmetric \
when enclosed by spanning characters. An example is fractions in which the \
numerator is much more complex than the denominator (or vice versa). With the \
default setting ",
  StyleBox["SpanSymmetric \[Rule] True",
    FontFamily->"Courier"],
  ", the size of the spanning characters above and below the axis of the \
fraction are adjusted to be equal, giving the expression a more symmetric \
appearance. \n   For example, ",
  Cell[BoxData[
      \(\((\@\(a\/b\)\/c)\)\)],
    SpanSymmetric->True,
    FontFamily->"Times"],
  ".\n\[FilledSmallSquare] With the setting ",
  StyleBox["SpanSymmetric \[Rule] False",
    FontFamily->"Courier"],
  ", the size of the spanning characters is not adjusted. \n   For example, \
",
  Cell[BoxData[
      StyleBox[\((\@\(a\/b\)\/c)\),
        FontFamily->"Times"]],
    SpanSymmetric->False],
  "."
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.4.4", "2.3.5.19.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SpanLineThickness", "ObjectName",
  CellTags->{"2.3.5.19.5.2", "2.3.5.19.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SpanLineThickness",
    FontFamily->"Courier"],
  " is an option for cells that determines the thickness of line-spanning \
characters such as ",
  StyleBox["\[Backslash][VerticalLine]",
    FontFamily->"Courier"],
  " and ",
  StyleBox["\[Backslash][HorizontalLine]",
    FontFamily->"Courier"],
  ". "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.5.3", "2.3.5.19.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["SpanLineThickness \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the thickness of line-spanning characters is set to an appropriate \
default value.  \n\[FilledSmallSquare] With the setting ",
  StyleBox["SpanLineThickness \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["k",
    FontSlant->"Italic"],
  ", the thickness of a line-spanning character is ",
  StyleBox["k",
    FontSlant->"Italic"],
  " times its default thickness. "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.5.4", "2.3.5.19.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SpanCharacterRounding ", "ObjectName",
  CellTags->{"2.3.5.19.6.2", "2.3.5.19.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SpanCharacterRounding",
    FontFamily->"Courier"],
  " is an option for cells that determines the method used for rounding a \
spanning character when its size is to be adjusted. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.6.3", "2.3.5.19.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] The size of any spanning character can only be varied \
in discrete steps determined by the size of the small elements it is built \
from. If you set the size of any spanning character to a value that would \
require a non-integer number of elements, then the actual size is determined \
by rounding off to the nearest integer number. ",
  StyleBox["SpanCharacterRounding",
    FontFamily->"Courier"],
  " determines the method used to perform this rounding. Possible settings \
are ",
  StyleBox["Floor",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Ceiling",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["Round",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] With the default setting ",
  StyleBox["SpanCharacterRounding \[Rule] Automatic",
    FontFamily->"Courier"],
  ", an appropriate rounding method is used for each spanning character. For \
example, radical signs are always rounded to the next highest value, that is \
",
  StyleBox["SpanCharacterRounding \[Rule] Ceiling",
    FontFamily->"Courier"],
  ", to ensure that they are always larger than the expression they wrap \
around. "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.6.4", "2.3.5.19.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SpanAdjustments", "ObjectName",
  CellTags->{"2.3.5.19.7.2", "2.3.5.19.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SpanAdjustments",
    FontFamily->"Courier"],
  " is an option for cells that determines the height and width of spanning \
characters. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.7.3", "2.3.5.19.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can fine-tune the appearance of an expression by \
adjusting the height and width of spanning characters. You can adjust the \
height and width of any character either by scaling its original value or by \
adding to it. ",
  StyleBox["SpanAdjustments \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["a",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Times"],
  StyleBox[" b",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["},{",
    FontFamily->"Courier"],
  StyleBox["c",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Times"],
  StyleBox[" d",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  " means that if the original height and width are ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", the final height is ",
  StyleBox["Max[",
    FontFamily->"Courier"],
  StyleBox["ax",
    FontSlant->"Italic"],
  ", ",
  StyleBox["x",
    FontSlant->"Italic"],
  " + ",
  StyleBox["c",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " and the final width is ",
  StyleBox["Max[",
    FontFamily->"Courier"],
  StyleBox["by",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  " + ",
  StyleBox["d",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] The default setting is ",
  StyleBox["SpanAdjustments \[Rule] Automatic",
    FontFamily->"Courier"],
  ", which assigns an appropriate value to each character depending on its \
context."
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.19.7.4", "2.3.5.19.6"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Linebreaking Options", "SubsubsectionIcon",
  PageWidth->WindowWidth,
  Background->None,
  CellTags->"2.3.5.20"],

Cell[CellGroupData[{

Cell["LineBreakWithin ", "ObjectName",
  CellTags->{"2.3.5.20.2.2", "2.3.5.20.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LineBreakWithin",
    FontFamily->"Courier"],
  " is an option for cells that determines if ",
  "line break",
  "s should occur automatically when the end of a line is reached."
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.20.2.3", "2.3.5.20.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["LineBreakWithin \[Rule] Automatic",
    FontFamily->"Courier"],
  ", text being entered is automatically wrapped to the next line when the \
end of the current line is reached.\n\[FilledSmallSquare] With the setting ",
  StyleBox["LineBreakWithin \[Rule] False",
    FontFamily->"Courier"],
  ", a line can become indefinitely long without the text being wrapped to \
the next line."
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.20.2.4", "2.3.5.20.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["LineIndent", "ObjectName",
  CellTags->{"2.3.5.20.3.2", "2.3.5.20.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LineIndent", "MR"],
  " ",
  "is an option for cells",
  " that determines how many ems of indentation to add at the beginnings of \
lines for each level of nesting in an expression. "
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.20.3.3", "2.3.5.20.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The typical default setting is ",
  StyleBox["LineIndent", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["1", "MR"],
  ". \n\[FilledSmallSquare] The setting for ",
  StyleBox["LineIndent", "MR"],
  " determines the amount of indentation that will be inserted after any \
explicit \[ReturnKey] is entered when ",
  StyleBox["AutoIndent", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  ". \n\[FilledSmallSquare] See also: ",
  ButtonBox["LineIndentMaxFraction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["PageWidth",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.20.3.4", "2.3.5.20.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["IndentMaxFraction", "ObjectName",
  CellTags->{"2.3.5.20.4.2", "2.3.5.20.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["IndentMaxFraction",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the maximum amount of indentation that can be \
automatically added to a line."
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.20.4.3", "2.3.5.20.3.", "2.3.5.20.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["IndentMaxFraction",
    FontFamily->"Courier"],
  " is specified as a fraction of the window width. If the automatic \
indentation added to a line would exceed ",
  StyleBox["IndentMaxFraction",
    FontFamily->"Courier"],
  ", then the line is not indented. The default setting is ",
  StyleBox["IndentMaxFraction \[Rule] ",
    FontFamily->"Courier"],
  "0.5."
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.20.4.4", "2.3.5.20.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["LinebreakAdjustments ", "ObjectName",
  CellTags->{"2.3.5.20.5.2", "2.3.5.20.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinebreakAdjustments",
    FontFamily->"Courier"],
  " is an option for cells that sets parameters used for calculating where \
automatic ",
  "line break",
  "s should be inserted."
}], "Usage",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.20.5.3", "2.3.5.20.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The automatic line breaking of expressions uses a \
complex algorithm that takes into account many factors that affect the length \
of lines. Each such factor is assigned a weight, which is then used as a \
parameter in a global optimization routine that determines the exact \
positions of the c. By adjusting the parameters, you can control the relative \
importance given to the different line breaking criteria. For most cases, the \
default settings provide a good optimal solution, and it is not necessary to \
adjust the parameters yourself.\n\[FilledSmallSquare] This option is \
specified as a list of five numbers ",
  StyleBox["LinebreakAdjustments",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["c",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  " ",
  StyleBox["d",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["e",
    FontSlant->"Italic"],
  "}. Here, ",
  StyleBox["a",
    FontSlant->"Italic"],
  " specifies the optimal line width to aim for, expressed as a percentage of \
the total line width; ",
  StyleBox["b",
    FontSlant->"Italic"],
  " is the penalty assigned for deviating from the line width specified by ",
  StyleBox["a",
    FontSlant->"Italic"],
  "; ",
  StyleBox["c",
    FontSlant->"Italic"],
  " is a penalty based on the depth of the box tree (the deeper in the box \
tree the line break would occur, the greater the penalty for line breaks); ",
  StyleBox["d",
    FontSlant->"Italic"],
  " is a penalty based on how bad the break was at the previous line; ",
  StyleBox["e",
    FontSlant->"Italic"],
  " is a penalty based on the total number of lines (the larger the number ",
  StyleBox["d",
    FontSlant->"Italic"],
  ", the smaller the number of lines used to format the expression).\n\
\[FilledSmallSquare] The default setting ",
  StyleBox["LinebreakAdjustments \[Rule] {0.85, 2, 12, 1, 1}",
    FontFamily->"Courier"],
  ", represents an empirical choice that works well for most ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input. An alternative setting, that gives good results for program code, \
is ",
  StyleBox["LinebreakAdjustments \[Rule] {0.5, 10, 100, 1, 0.5}",
    FontFamily->"Courier"],
  "."
}], "Notes",
  PageWidth->WindowWidth,
  CellTags->{"2.3.5.20.5.4", "2.3.5.20.4"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Table/Matrix/Palette Formatting", "SubsectionIcon",
  PageWidth->WindowWidth],

Cell[CellGroupData[{

Cell["Global Options", "InspectorLevel2",
  Background->None,
  CellTags->{"2.3.6.2.2", "2.3.6.2"}],

Cell[CellGroupData[{

Cell["GridDefaultElement  ", "SubObjectNameClosed",
  CellTags->{"2.3.6.2.2.2", "2.3.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridDefaultElement",
    FontFamily->"Courier"],
  " is an option for cells that determines what element is placed in every \
unit of a grid box by default."
}], "Usage",
  CellTags->{"2.3.6.2.2.3", "2.3.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] When a new table, matrix, or palette is created, the \
element specified by ",
  StyleBox["GridDefaultElement",
    FontFamily->"Courier"],
  " is automatically placed in each row and column. This element can be a \
character, a string, or even a typeset expression, such as ",
  StyleBox["\\!\\(a\\/b\\)",
    FontFamily->"Courier"],
  StyleBox[" or ",
    FontFamily->"Times New Roman"],
  StyleBox["FractionBox[\"a\", \"b\"]",
    FontFamily->"Courier"],
  ". ",
  StyleBox["\n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["GridDefaultElement \[Rule] Placeholder. ",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"2.3.6.2.2.4", "2.3.6.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["GridBaseline", "SubObjectNameClosed",
  CellTags->{"2.3.6.2.3.2", "2.3.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridBaseline",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the vertical positioning of a grid box with respect to \
the baseline of the text surrounding it."
}], "Usage",
  CellTags->{"2.3.6.2.3.3", "2.3.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["GridBaseline \[Rule] Top",
    FontFamily->"Courier"],
  ", the top of a grid box is aligned with the baseline of the surrounding \
text. For example,\n",
  StyleBox[" \"",
    FontFamily->"Courier"],
  Cell[BoxData[
      RowBox[{"This", ",", GridBox[{
            {"1", "0"},
            {"0", "1"}
            },
          GridBaseline->Top,
          GridFrame->True,
          RowLines->True,
          ColumnLines->True], ",", 
        " ", \(is\ a\ \ 2\ \[Times]\ 2\ \(\(table\)\(.\)\)\)}]],
    FontFamily->"Times"],
  "\"",
  StyleBox["  ",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] With the setting ",
  StyleBox["GridBaseline \[Rule] Bottom",
    FontFamily->"Courier"],
  StyleBox[", the bottom of the grid box is level with the baseline of the \
surrounding text. For example, ",
    FontFamily->"Times"],
  StyleBox["\t\n \"",
    FontFamily->"Courier"],
  Cell[BoxData[
      RowBox[{"This", ",", " ", GridBox[{
            {"1", "0"},
            {"0", "1"}
            },
          GridBaseline->Bottom,
          GridFrame->True,
          RowLines->True,
          ColumnLines->True], ",", 
        " ", \(is\ a\ 2\ \[Times]\ 2\ \(\(table\)\(.\)\)\)}]],
    FontFamily->"Times"],
  "\"",
  StyleBox["   \n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare] With the setting ",
  StyleBox["GridBaseline \[Rule] Center",
    FontFamily->"Courier"],
  StyleBox[", the center of the grid box is level with the baseline of the \
surrounding text. For example, \"",
    FontFamily->"Times"],
  Cell[BoxData[
      RowBox[{"This", ",", " ", GridBox[{
            {"1", "0"},
            {"0", "1"}
            },
          GridBaseline->Center,
          GridFrame->True,
          RowLines->True,
          ColumnLines->True], ",", 
        " ", \(is\ a\ 2\ \[Times]\ 2\ \(\(table\)\(.\)\)\)}]],
    FontFamily->"Times"],
  "\"",
  StyleBox[" \n",
    FontFamily->"Courier"],
  "\[FilledSmallSquare]  Another possible setting is ",
  StyleBox["GridBaseline \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["name",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", {",
    FontFamily->"Courier"],
  StyleBox["i",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["j",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[", where ",
    FontFamily->"Times New Roman"],
  StyleBox["name",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[" refers to the {",
    FontFamily->"Times New Roman"],
  StyleBox["i",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times New Roman"],
  StyleBox["j",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["}th element instead of the entire grid box. ",
    FontFamily->"Times New Roman"],
  StyleBox["For example, ",
    FontFamily->"Times"],
  StyleBox["GridBaseline \[Rule] {Top, {2, 1}}",
    FontFamily->"Courier"],
  StyleBox[" means that the top of the element in the second row and first \
column of the grid box is aligned with the baseline of the surrounding text, \
as shown here. \n\"",
    FontFamily->"Times"],
  Cell[BoxData[
      RowBox[{"This", ",", GridBox[{
            {"1", "0"},
            {"0", "1"}
            },
          GridBaseline->{Top, {2, 1}},
          GridFrame->True,
          RowLines->True,
          ColumnLines->True], ",", 
        "  ", \(is\ a\ 2\ \[Times]\ 2\ \(\(table\)\(.\)\)\)}]],
    FontFamily->"Times"],
  "\"",
  StyleBox[" \n\[FilledSmallSquare]",
    FontFamily->"Courier"],
  " The default setting is ",
  StyleBox["GridBaseline ",
    FontFamily->"Courier"],
  "\[Rule]",
  StyleBox[" Axis",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.6.2.3.4", "2.3.6.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AutoDelete", "SubObjectNameClosed",
  CellTags->{"2.3.6.2.4.2", "2.3.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoDelete",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a grid box is automatically deleted when all but one of its elements is \
removed."
}], "Usage",
  CellTags->{"2.3.6.2.4.3", "2.3.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AutoDelete",
    FontFamily->"Courier"],
  " controls what happens if you create a grid box and then remove all of its \
elements except one. With the setting ",
  StyleBox["AutoDelete \[Rule] True",
    FontFamily->"Courier"],
  ", the grid box surrounding the element disappears. \n\[FilledSmallSquare] \
With the setting ",
  StyleBox["AutoDelete \[Rule] False",
    FontFamily->"Courier"],
  ", the single element continues to be enclosed in a grid box. "
}], "Notes",
  CellTags->{"2.3.6.2.4.4", "2.3.6.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AllowScriptLevelChange", "SubObjectNameClosed",
  CellTags->{"2.3.5.10.7.2", "2.3.6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AllowScriptLevelChange",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " entries in a grid box can have a ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " of ",
  StyleBox["0",
    FontFamily->"Courier"],
  "."
}], "Usage",
  CellTags->{"2.3.5.10.7.3", "2.3.6.2"}],

Cell[CellGroupData[{

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["AllowScriptLevelChange \[Rule] True",
    FontFamily->"Courier"],
  ", all entries in a grid box have a minimum ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " of ",
  StyleBox["1",
    FontFamily->"Courier"],
  ". The main effect this has is to make operators affected by ",
  StyleBox["LimitsPositioning",
    FontFamily->"Courier"],
  ", such as \[Sum], \[Product], and \[Integral], appear small, as shown \
below."
}], "Notes",
  CellTags->{"2.3.5.10.7.4", "2.3.6.2"}],

Cell[BoxData[GridBox[{
        {\(\[Sum]\+\(j = 1\)\%100\), \(\[Product]\+\(i = 1\)\%n\)},
        {\(\[Integral]\_a\%b\), \(lim\+\(n \[Rule] \ \[Infinity]\)\)}
        },
      GridFrame->True,
      RowLines->True,
      ColumnLines->True,
      AllowScriptLevelChange->True]], "Input",
  ShowCellBracket->False,
  CellTags->"2.3.6.2"],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["AllowScriptLevelChange \[Rule] False",
    FontFamily->"Courier"],
  ", elements of a grid box can have a ",
  StyleBox["ScriptLevel",
    FontFamily->"Courier"],
  " of ",
  StyleBox["0",
    FontFamily->"Courier"],
  ". This allows operators such as \[Sum], \[Product], and \[Integral], to \
appear larger, making for an improved visual effect, as shown below."
}], "Notes",
  CellTags->"2.3.6.2"],

Cell[BoxData[GridBox[{
        {\(\[Sum]\+\(j = 1\)\%100\), \(\[Product]\+\(i = 1\)\%n\)},
        {\(\[Integral]\_a\%b\), \(lim\+\(n \[Rule] \ \[Infinity]\)\)}
        },
      GridFrame->True,
      RowLines->True,
      ColumnLines->True,
      AllowScriptLevelChange->False]], "Input",
  ShowCellBracket->False,
  CellTags->"2.3.6.2"],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["ScriptLevel",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["LimitsPositioning",
    ButtonStyle->"OtherInformationLinkMR"],
  "."
}], "Notes",
  CellTags->"2.3.6.2"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Row Options", "InspectorLevel2",
  Background->None,
  CellTags->{"2.3.6.3.2", "2.3.6.3"}],

Cell[CellGroupData[{

Cell["RowAlignments ", "SubObjectNameClosed",
  CellTags->{"2.3.6.3.2.2", "2.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowAlignments",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the vertical alignment of the rows in a grid box."
}], "Usage",
  CellTags->{"2.3.6.3.2.3", "2.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["RowAlignments \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Baseline",
    FontFamily->"Courier"],
  ", all elements in the same row are vertically positioned so that their \
baselines coincide. \n\[FilledSmallSquare] Other possible settings are ",
  StyleBox["Top",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Bottom",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Center",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["Axis",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.6.3.2.4", "2.3.6.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["RowSpacings ", "SubObjectNameClosed",
  CellTags->{"2.3.6.3.3.2", "2.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowSpacings",
    FontFamily->"Courier"],
  " is an option for cells that determines the vertical spacing between \
successive rows of a grid box."
}], "Usage",
  CellTags->{"2.3.6.3.3.3", "2.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] The spacing is specified in units of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-heights. The default setting is ",
  StyleBox["RowSpacings \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["1",
    FontFamily->"Courier"],
  ". This means that the spacing between all rows is equal to the height of a \
single ",
  StyleBox["x",
    FontSlant->"Italic"],
  " character. \n\[FilledSmallSquare] You can also assign a different spacing \
for each row. ",
  StyleBox["RowSpacings \[Rule] ",
    FontFamily->"Courier"],
  "{",
  StyleBox["n1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n2",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n3",
    FontSlant->"Italic"],
  "......} means that the spacing after the first row is ",
  StyleBox["n1",
    FontSlant->"Italic"],
  ", after the second row ",
  StyleBox["n2,",
    FontSlant->"Italic"],
  " and so forth. If the number of rows is greater than the number of \
elements in the list, the last element determines the spacing for all \
remaining rows. "
}], "Notes",
  CellTags->{"2.3.6.3.3.4", "2.3.6.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["RowsEqual ", "SubObjectNameClosed",
  CellTags->{"2.3.6.3.4.2", "2.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowsEqual",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " all rows in a grid box have the same height. "
}], "Usage",
  CellTags->{"2.3.6.3.4.3", "2.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["RowsEqual \[Rule] False",
    FontFamily->"Courier"],
  ", each row can have a different height depending on its contents. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["RowsEqual \[Rule] True",
    FontFamily->"Courier"],
  ", all rows are adjusted to have the same height as the row with the \
maximum height.  "
}], "Notes",
  CellTags->{"2.3.6.3.4.4", "2.3.6.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["RowsMinHeight ", "SubObjectNameClosed",
  CellTags->{"2.3.6.3.5.2", "2.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowsMinHeight",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the minimum height of a row in a grid box."
}], "Usage",
  CellTags->{"2.3.6.3.5.3", "2.3.6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowsMinHeight",
    FontFamily->"Courier"],
  " is specified in units of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-heights. The default setting is ",
  StyleBox["RowsMinHeight \[Rule] 1",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"2.3.6.3.5.4", "2.3.6.3"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Column Options", "InspectorLevel2",
  Background->None,
  CellTags->{"2.3.6.4.2", "2.3.6.4"}],

Cell[CellGroupData[{

Cell["ColumnAlignments ", "SubObjectNameClosed",
  CellTags->{"2.3.6.4.2.2", "2.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnAlignments",
    FontFamily->"Courier"],
  " is an option for cells that determines the horizontal alignment of the \
columns in a grid box."
}], "Usage",
  CellTags->{"2.3.6.4.2.3", "2.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ColumnAlignments \[Rule] Center",
    FontFamily->"Courier"],
  ", all elements in the same row are horizontally positioned so that their \
baselines coincide. \n\[FilledSmallSquare] Other possible settings are ",
  StyleBox["Left",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Right",
    FontFamily->"Courier"],
  StyleBox[",",
    FontSlant->"Italic"],
  " and ",
  StyleBox["n, ",
    FontSlant->"Italic"],
  "where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is the amount of space in ems from the left edge of the column. "
}], "Notes",
  CellTags->{"2.3.6.4.2.4", "2.3.6.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ColumnSpacings ", "SubObjectNameClosed",
  CellTags->{"2.3.6.4.3.2", "2.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnSpacings",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the horizontal spacing between successive columns of a \
grid box."
}], "Usage",
  CellTags->{"2.3.6.4.3.3", "2.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The spacing is specified in em units. The default \
setting is ",
  StyleBox["ColumnSpacings \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["1",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] You can also assign a different spacing for each \
column. ",
  StyleBox["ColumnSpacings \[Rule] ",
    FontFamily->"Courier"],
  "{",
  StyleBox["n1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n2",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n3",
    FontSlant->"Italic"],
  "......} means that the spacing after the first column is ",
  StyleBox["n1",
    FontSlant->"Italic"],
  ", after the second column ",
  StyleBox["n2,",
    FontSlant->"Italic"],
  " ",
  "and so forth",
  ". If the number of columns is greater than the number of elements in the \
list, the last element determines the spacing for all remaining columns. "
}], "Notes",
  CellTags->{"2.3.6.4.3.4", "2.3.6.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ColumnsEqual ", "SubObjectNameClosed",
  CellTags->{"2.3.6.4.4.2", "2.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnsEqual",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " all columns in a grid box have the same width. "
}], "Usage",
  CellTags->{"2.3.6.4.4.3", "2.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["ColumnsEqual \[Rule] False",
    FontFamily->"Courier"],
  ", each column can have a different width depending on its contents. \n\
\[FilledSmallSquare] With the setting ",
  StyleBox["ColumnsEqual \[Rule] True",
    FontFamily->"Courier"],
  ", all columns are adjusted to have the same width as the column with the \
maximum width.  "
}], "Notes",
  CellTags->{"2.3.6.4.4.4", "2.3.6.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ColumnWidths ", "SubObjectNameClosed",
  CellTags->{"2.3.6.4.5.2", "2.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnWidths",
    FontFamily->"Courier"],
  " is an option for cells that determines the widths of columns in a grid \
box."
}], "Usage",
  CellTags->{"2.3.6.4.5.3", "2.3.6.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["ColumnWidths \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["n, ",
    FontSlant->"Italic"],
  "all columns in the grid box have a width of ",
  StyleBox["n",
    FontSlant->"Italic"],
  " ems.\n\[FilledSmallSquare] With the setting ",
  StyleBox["ColumnWidths \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["n1, n2, ....",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  StyleBox[", the first column has width ",
    FontFamily->"Times"],
  StyleBox["n1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", the second has width ",
    FontFamily->"Times"],
  StyleBox["n2,",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" and so on. ",
    FontFamily->"Times"],
  "If the number of columns is greater than the number of elements in the \
list, the last value in the list determines the width of all remaining \
columns. \n\[FilledSmallSquare] With the setting ",
  StyleBox["ColumnWidths \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the columns grow to be as large as needed to fit the widest entry in a \
column; values between 0 and 1 specify percentages of the current formatting \
width.  For example, ",
  StyleBox["ColumnWidths \[Rule] {.25, .5} ",
    FontFamily->"Courier"],
  "makes the width of the first column 25% and that of the second column 50% \
(of the current formatting width). For different columns to have different \
widths, the option ",
  StyleBox["ColumnsEqual",
    FontFamily->"Courier"],
  " must be set to ",
  StyleBox["False",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " is valid wherever a number is valid, for example",
  StyleBox[" ",
    FontSlant->"Italic"],
  "in ",
  StyleBox["ColumnWidths->{.2, Automatic, 30}",
    FontFamily->"Courier"],
  ". "
}], "Notes",
  CellTags->{"2.3.6.4.5.4", "2.3.6.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Line Drawing Options", "InspectorLevel2",
  Background->None,
  CellTags->{"2.3.6.5.2", "2.3.6.5"}],

Cell[CellGroupData[{

Cell["RowLines ", "SubObjectNameClosed",
  CellTags->{"2.3.6.5.2.2", "2.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowLines",
    FontFamily->"Courier"],
  " is an option for cells that determines if lines are drawn between \
adjacent rows in a grid box and what their thicknesses should be."
}], "Usage",
  CellTags->{"2.3.6.5.2.3", "2.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RowLines",
    FontFamily->"Courier"],
  " can be set to \n",
  StyleBox["True",
    FontFamily->"Courier"],
  StyleBox["             a line is drawn between all adjacent rows",
    FontFamily->"Times"],
  StyleBox["\nFalse   ",
    FontFamily->"Courier"],
  "    no lines are drawn between rows\n ",
  StyleBox["n        ",
    FontSlant->"Italic"],
  "            a",
  StyleBox[" line with thickness ",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" times the default thickness is drawn between all adjacent rows\n\
{",
    FontFamily->"Times"],
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)],
    FormatType->StandardForm],
  StyleBox[", ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)],
    FormatType->StandardForm],
  StyleBox[", ....",
    FontSlant->"Italic"],
  StyleBox["} ",
    FontFamily->"Courier"],
  StyleBox["the first line has thickness ",
    FontFamily->"Times"],
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)],
    FormatType->StandardForm],
  ", the second line has thickness ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(n\_2\)\(,\)\)\)],
    FormatType->StandardForm],
  " and so on. If the number of\n                        rows is greater than \
the number of elements in the list, the last element in the list \n           \
             determines the thickness of all remaining lines. "
}], "Notes",
  CellTags->{"2.3.6.5.2.4", "2.3.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ColumnLines ", "SubObjectNameClosed",
  CellTags->{"2.3.6.5.3.2", "2.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnLines",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines if lines should be drawn between adjacent columns in a \
grid box."
}], "Usage",
  CellTags->{"2.3.6.5.3.3", "2.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ColumnLines",
    FontFamily->"Courier"],
  " can be set to \n",
  StyleBox["True",
    FontFamily->"Courier"],
  StyleBox["             a line is drawn between all adjacent columns",
    FontFamily->"Times"],
  StyleBox["\nFalse   ",
    FontFamily->"Courier"],
  "    no lines are drawn between columns\n ",
  StyleBox["n        ",
    FontSlant->"Italic"],
  "            a",
  StyleBox[" line with ",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" times the default thickness is drawn between all adjacent \
columns\n{",
    FontFamily->"Times"],
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)],
    FormatType->StandardForm],
  StyleBox[", ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)],
    FormatType->StandardForm],
  StyleBox[", ....",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  StyleBox["   the first line has thickness ",
    FontFamily->"Times"],
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)],
    FormatType->StandardForm],
  ", the second line has thickness ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(n\_2\)\(,\)\)\)],
    FormatType->StandardForm],
  " and so on. If the number of\n                        columns is greater \
than the number of elements in the list, the last element in the list \n      \
                  determines the thickness of all remaining lines. "
}], "Notes",
  CellTags->{"2.3.6.5.3.4", "2.3.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["GridFrame ", "SubObjectNameClosed",
  CellTags->{"2.3.6.5.4.2", "2.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridFrame",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " lines should be drawn around a grid box."
}], "Usage",
  CellTags->{"2.3.6.5.4.3", "2.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridFrame",
    FontFamily->"Courier"],
  " can be set to \n",
  StyleBox["True",
    FontFamily->"Courier"],
  StyleBox["                     a frame is drawn around all four sides of \
the grid box",
    FontFamily->"Times"],
  StyleBox["\nFalse   ",
    FontFamily->"Courier"],
  "           no frame is drawn around the grid box\n ",
  StyleBox["n        ",
    FontSlant->"Italic"],
  "                  \[AlignmentMarker] a",
  StyleBox[" frame with ",
    FontFamily->"Times"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox[" times the default thickness is drawn\n {{",
    FontFamily->"Times"],
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["},",
    FontFamily->"Times"],
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["b, t",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  "     ",
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["b",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", and ",
    FontFamily->"Times"],
  StyleBox["t",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" specify the thickness of the lines drawn around the left, right, \
bottom, and \n                              top sides of the box \
respectively. ",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.6.5.4.4", "2.3.6.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["GridFrameMargins ", "SubObjectNameClosed",
  CellTags->{"2.3.6.5.5.2", "2.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridFrameMargins",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the spacing between text in a grid box and the frame \
surrounding it. "
}], "Usage",
  CellTags->{"2.3.6.5.5.3", "2.3.6.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["GridFrameMargins \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["l, r",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["b, t",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[" determines the size of the left, right, bottom, and top margins \
respectively in em units. The default setting is ",
    FontFamily->"Times"],
  StyleBox["GridFrameMargins \[Rule] {{",
    FontFamily->"Courier"],
  "0.4, 0.4",
  StyleBox["}",
    FontFamily->"Courier"],
  StyleBox[", ",
    FontFamily->"Times"],
  StyleBox["{",
    FontFamily->"Courier"],
  "0.5, 0.5",
  StyleBox["}}",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.3.6.5.5.4", "2.3.6.5"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Automatic Numbering Options", "SubsectionIcon",
  PageWidth->WindowWidth],

Cell[CellGroupData[{

Cell["Counter Assignment and Incrementing", "InspectorLevel2",
  Background->None,
  CellTags->{"2.3.7.2.2", "2.3.7.2"}],

Cell[CellGroupData[{

Cell[" CounterIncrements ", "SubObjectNameClosed",
  CellTags->{"2.3.7.2.2.2", "2.3.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterIncrements",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the value of a specified counter is incremented by one."
}], "Usage",
  CellTags->{"2.3.7.2.2.3", "2.3.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterIncrements \[Rule] {\"Counter1\"}",
    FontFamily->"Courier"],
  " increases the value of ",
  StyleBox["Counter1",
    FontFamily->"Courier"],
  " by one. \n\[FilledSmallSquare] ",
  StyleBox["CounterIncrements",
    FontFamily->"Courier"],
  " is usually defined for particular cell styles in the style sheet, but it \
can also be defined for an individual cell. "
}], "Notes",
  CellTags->{"2.3.7.2.2.4", "2.3.7.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" CounterAssignments ", "SubObjectNameClosed",
  CellTags->{"2.3.7.2.3.2", "2.3.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterAssignments",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the value of a specified counter. "
}], "Usage",
  CellTags->{"2.3.7.2.3.3", "2.3.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterAssignments \[Rule] {{\"Counter1\",\"",
    FontFamily->"Courier"],
  StyleBox["m",
    FontSlant->"Italic"],
  StyleBox["\"}",
    FontFamily->"Courier"],
  " , {",
  StyleBox["\"Counter2\",\"",
    FontFamily->"Courier"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["\"}",
    FontFamily->"Courier"],
  "} assigns the values ",
  StyleBox["m",
    FontSlant->"Italic"],
  " and ",
  StyleBox["n",
    FontSlant->"Italic"],
  " to ",
  StyleBox["Counter1",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Counter2",
    FontFamily->"Courier"],
  ", respectively.\n\[FilledSmallSquare] ",
  StyleBox["CounterAssignments",
    FontFamily->"Courier"],
  " is usually defined for particular cell styles in the style sheet, but it \
can also be defined for an individual cell. "
}], "Notes",
  CellTags->{"2.3.7.2.3.4", "2.3.7.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" InlineCounterIncrements ", "SubObjectNameClosed",
  CellTags->{"2.3.7.2.4.2", "2.3.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InlineCounterIncrements",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " the value of a specified counter in an inline cell should be incremented \
by one."
}], "Usage",
  CellTags->{"2.3.7.2.4.3", "2.3.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InlineCounterIncrements \[Rule] {\"Counter1\"}",
    FontFamily->"Courier"],
  " increases the value of ",
  StyleBox["Counter1",
    FontFamily->"Courier"],
  " by one. \n\[FilledSmallSquare] ",
  StyleBox["InlineCounterIncrements",
    FontFamily->"Courier"],
  " is usually defined for particular cell styles in the style sheet, but it \
can also be defined for an individual cell. "
}], "Notes",
  CellTags->{"2.3.7.2.4.4", "2.3.7.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" InlineCounterAssignments ", "SubObjectNameClosed",
  CellTags->{"2.3.7.2.5.2", "2.3.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InlineCounterAssignments",
    FontFamily->"Courier"],
  " is an option for cells that determines the value of a specified counter \
for an inline cell. "
}], "Usage",
  CellTags->{"2.3.7.2.5.3", "2.3.7.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InlineCounterAssignments \[Rule] {{\"Counter1\",\"",
    FontFamily->"Courier"],
  StyleBox["m",
    FontSlant->"Italic"],
  StyleBox["\"}",
    FontFamily->"Courier"],
  " , {",
  StyleBox["\"Counter2\",\"",
    FontFamily->"Courier"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["\"}",
    FontFamily->"Courier"],
  "} assigns the values ",
  StyleBox["m",
    FontSlant->"Italic"],
  " and ",
  StyleBox["n",
    FontSlant->"Italic"],
  " to ",
  StyleBox["Counter1",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Counter2",
    FontFamily->"Courier"],
  ", respectively.\n\[FilledSmallSquare] ",
  StyleBox["InlineCounterAssignments",
    FontFamily->"Courier"],
  " is usually defined for particular cell styles in the style sheet, but it \
can also be defined for an individual cell. "
}], "Notes",
  CellTags->{"2.3.7.2.5.4", "2.3.7.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Counter Display Options", "InspectorLevel2",
  Background->None,
  CellTags->{"2.3.7.3.2", "2.3.7.3"}],

Cell[CellGroupData[{

Cell["CounterStyle", "SubObjectNameClosed",
  CellTags->{"2.3.7.3.2.2", "2.3.7.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterStyle",
    FontFamily->"Courier"],
  " is an option for cells that determines the cell style from which the \
default values of all options associated with a counter are inherited."
}], "Usage",
  CellTags->{"2.3.7.3.2.3", "2.3.7.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterStyle",
    FontFamily->"Courier"],
  " can be set to any of the cell styles defined in the notebook. \n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["CounterStyle \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the counter inherits the option values of the cell style for which the \
counter is defined."
}], "Notes",
  CellTags->{"2.3.7.3.2.4", "2.3.7.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CounterFunction", "SubObjectNameClosed",
  CellTags->{"2.3.7.3.3.2", "2.3.7.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["CounterFunction",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the symbols used to display the value of a counter. "
}], "Usage",
  CellTags->{"2.3.7.3.3.3", "2.3.7.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["CounterFunction \[Rule] Identity",
    FontFamily->"Courier"],
  ", the value of the counter is displayed as an ordinary decimal number. \n\
\[FilledSmallSquare] You can also set the counter display to use symbols such \
as Roman numerals or Greek letters. Other possible formats include: capital \
Roman numerals, capital Greek letters, lowercase letters, uppercase letters, \
days of the week, months, and circled numbers. To choose any of these \
formats, check the corresponding item in the pop-up menu to the right of the \
option.\n\[FilledSmallSquare] At the level of the cell expression, all these \
formats are implemented using the ",
  StyleBox["CharacterRange",
    FontFamily->"Courier"],
  " function. This allows you to specify any arbitrary set of symbols or \
strings to use in the counter display. For example,\nTo display:              \
   Use the setting:\nabc...                         ",
  StyleBox["CounterFunction \[Rule] (Part[CharacterRange[\"a\", \"z\"],#]&",
    FontFamily->"Courier"],
  " \t           \nGreek letters             ",
  StyleBox["CounterFunction \[Rule] \
(Part[CharacterRange[\"\[Backslash][Alpha]\",\"\[Backslash][Omega]\"],#]&",
    FontFamily->"Courier"],
  "\t            ",
  StyleBox["\n",
    FontFamily->"Courier"],
  "Days of the week      ",
  StyleBox["CounterFunction \[Rule] (Part[CharacterRange[{\"Monday\", \
\"Tuesday\", ...}],#]&\n\t",
    FontFamily->"Courier"],
  "          "
}], "Notes",
  CellTags->{"2.3.7.3.3.4", "2.3.7.3"}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics Options", "Section"],

Cell[CellGroupData[{

Cell["Image Bounding Box", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["AspectRatioFixed", "ObjectName",
  CellTags->{"2.4.2.2.2", "2.4.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AspectRatioFixed", "MR"],
  " is a front end option that determines ",
  "if",
  " graphics in the cell should be constrained to stay the same shape when \
they are interactively resized using the front end. "
}], "Usage",
  CellTags->{"2.4.2.2.3", "2.4.2.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["AspectRatioFixed", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  ", the shape of an image is determined by the setting for ",
  StyleBox["ImageSize", "MR"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.12",
    ButtonData:>{"2.11.12", "12.2"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ImageSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AspectRatio",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.4.2.2.4", "2.4.2.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ImageSize", "ObjectName",
  CellTags->{"2.4.2.3.2", "2.4.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ImageSize", "MR"],
  " ",
  "is an option for graphics cells",
  " that determines the absolute size of an image to render. "
}], "Usage",
  CellTags->{"2.4.2.3.3", "2.4.2.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ImageSize", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["x", "TI"],
  " specifies that the image should have a width of ",
  StyleBox["x", "TI"],
  " printer's points, where 72 points equal one inch. \n\[FilledSmallSquare] \
",
  StyleBox["ImageSize", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["}", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  " specifies that the image should be rendered within a region ",
  StyleBox["x", "TI"],
  " printer's points wide by ",
  StyleBox["y", "TI"],
  " printer's points high. \n\[FilledSmallSquare] The image will fill the \
region only if its aspect ratio is exactly ",
  StyleBox["y", "TI"],
  StyleBox["/", "MR"],
  StyleBox["x", "TI"],
  ". \n\[FilledSmallSquare] In ",
  StyleBox["Display", "MR"],
  " and other graphics functions, the default setting for ",
  StyleBox["ImageSize", "MR"],
  " is ",
  StyleBox["Automatic", "MR"],
  ". This specifies that when output is sent to the front end, the front end \
should determine the size of the image. When output is sent elsewhere, the \
effective default is ",
  StyleBox["288", "MR"],
  ", corresponding to 4 inches. \n\[FilledSmallSquare] In the front end, the \
typical default setting for ",
  StyleBox["ImageSize", "MR"],
  " is also ",
  StyleBox["288", "MR"],
  ", corresponding to 4 inches. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ":\[NonBreakingSpace]",
  ButtonBox["Section 2.11.12",
    ButtonData:>{"2.11.12", "12.2"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ImageResolution",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ImageMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["AspectRatioFixed",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.4.2.3.4", "2.4.2.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ImageMargins", "ObjectName",
  CellTags->{"2.4.2.4.2", "2.4.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ImageMargins", "MR"],
  " is an option for cells that determines the absolute margins in printer's \
points around graphics in a cell. "
}], "Usage",
  CellTags->{"2.4.2.4.3", "2.4.2.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] Possible settings are as follows.\n   ",
  Cell[BoxData[
      FormBox[GridBox[{
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"dist\\\\\\\"\\\", \\\"TI\\\"]\
\\) \"\>", "\<\"the same margins on all sides \"\>"},
            {
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    "InlineFormula",
                    FontFamily->"Courier"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["{",
                        "InlineFormula",
                        
                        FontFamily->
                          "Courier"], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"left\
\\\\\\\"\\\", \\\"TI\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\",\\\\\\\"\\\", \
\\\"MR\\\"]\\) \\!\\(\\*StyleBox[\\\"\\\\\\\"right\\\\\\\"\\\", \
\\\"TI\\\"]\\)\"\>", 
                      StyleBox["}",
                        "InlineFormula",
                        
                        FontFamily->
                          "Courier"]}], \
"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\",\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", 
                    RowBox[{
                      StyleBox["{",
                        
                        "InlineFormula"], \
"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"bottom\\\\\\\"\\\", \
\\\"TI\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\",\\\\\\\"\\\", \\\"MR\\\"]\\) \\!\
\\(\\*StyleBox[\\\"\\\\\\\"top\\\\\\\"\\\", \\\"TI\\\"]\\)\"\>", 
                      StyleBox["}",
                        "InlineFormula",
                        FontFamily->"Courier"]}]}], 
                  StyleBox["}",
                    "InlineFormula",
                    
                    FontFamily->
                      "Courier"]}], "\<\" \"\>"}], "\<\"different margins on \
different sides \"\>"}
            },
          ColumnAlignments->{Left}], TextForm]], "Notes",
    FormatType->StandardForm,
    CellTags->"ImageMargins"],
  "\n\[FilledSmallSquare] ",
  StyleBox["ImageMargins", "MR"],
  " represent space to be left inside whatever ",
  StyleBox["CellMargins", "MR"],
  " are specified for a particular cell. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.12",
    ButtonData:>{"2.11.12", "12.2"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] ",
  "See also: ",
  ButtonBox["ImageSize",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["CellMargins",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.4.2.4.4", "2.4.2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ImageRegion", "ObjectName",
  CellTags->{"2.4.2.5.2", "2.4.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ImageRegion",
    FontFamily->"Courier"],
  " is an option for cells that determines the size and position of the \
bounding box within which a graphic is rendered."
}], "Usage",
  CellTags->{"2.4.2.5.3", "2.4.2.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] By changing the value of ",
  StyleBox["ImageRegion",
    FontFamily->"Courier"],
  ", you can select a specific region of a graphic for viewing. This option \
is specified as ",
  StyleBox["ImageRegion \[Rule] {{",
    FontFamily->"Courier"],
  StyleBox["l",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" r",
    FontSlant->"Italic"],
  StyleBox["},{",
    FontFamily->"Courier"],
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" t",
    FontSlant->"Italic"],
  StyleBox["}}",
    FontFamily->"Courier"],
  ", ",
  StyleBox["where ",
    FontFamily->"Times"],
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["l",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["r",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  StyleBox[" and ",
    FontFamily->"Times"],
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["b",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  StyleBox["t",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["specify the coordinates of the bottom left and top right corners \
of the bounding box of the graphic.\n",
    FontFamily->"Times"],
  "\[FilledSmallSquare] ",
  StyleBox["The size of the graphic scales according to the size of the \
bounding box. Hence, you can use this option for zooming in or zooming out. \
If the bounding box you specify is larger than the image size, only the part \
of the graphic that fits within the viewing rectangle for the image is \
displayed.\n",
    FontFamily->"Times"],
  "\[FilledSmallSquare] The numbers ",
  StyleBox["l",
    FontSlant->"Italic"],
  ", ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["t",
    FontSlant->"Italic"],
  " can take any positive or negative value, subject to the constraint that \
the aspect ratio of the graphic, ",
  "which is equal to",
  " ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{
            StyleBox["b",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontSlant->"Italic"], "-", " ", 
            StyleBox["t",
              FontSlant->"Italic"]}], \(l\  - \ \ r\)], TraditionalForm]],
    FormatType->StandardForm],
  ", ",
  StyleBox["is always preserved. \n",
    FontFamily->"Times"],
  "\[FilledSmallSquare] With the ",
  StyleBox["default setting ",
    FontFamily->"Times"],
  StyleBox["ImageRegion \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["{{0, 1},{0, 1}}",
    FontFamily->"Courier"],
  ", the bounding box of the graphic coincides with the viewing rectangle for \
the image. The size and position of the viewing rectangle is determined by \
the settings for ",
  StyleBox["ImageSize",
    FontFamily->"Courier"],
  " and ",
  StyleBox["ImageMargins",
    FontFamily->"Courier"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ImageSize",
    ButtonStyle->"OtherInformationLinkMR"],
  ", ",
  ButtonBox["ImageMargins",
    ButtonStyle->"OtherInformationLinkMR"],
  ". "
}], "Notes",
  CellTags->{"2.4.2.5.4", "2.4.2.5"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Animation", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["AnimationDisplayTime", "ObjectName",
  CellTags->{"2.4.3.2.2", "2.4.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AnimationDisplayTime", "MR"],
  " is an option for cells that determines the minimum time in seconds for \
which a cell is displayed in the course of an animation. "
}], "Usage",
  CellTags->{"2.4.3.2.3", "2.4.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The setting ",
  StyleBox["AnimationDisplayTime", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["0", "MR"],
  " specifies that the animation should be run at the maximum speed possible \
on your computer. \n\[FilledSmallSquare] The default setting is ",
  StyleBox["AnimationDisplayTime", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["0.1", "MR"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.12",
    ButtonData:>{"2.11.12", "12.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"2.4.3.2.4", "2.4.3.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AnimationCycleOffset", "ObjectName",
  CellTags->{"2.4.3.3.2", "2.4.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AnimationCycleOffset",
    FontFamily->"Courier"],
  " ",
  "is an option for cells",
  " that determines the relative position of the next graphic to be used in \
an animation sequence."
}], "Usage",
  CellTags->{"2.4.3.3.3", "2.4.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["With the setting ",
    FontFamily->"Times"],
  StyleBox["AnimationCycleOffset \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", the ",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["th graphic from the current graphic is assumed to be next in the \
animation sequence. Here, ",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" can take both positive and negative integer values. The \
animation starts out in the forward direction, but it reverses direction if \
it encounters a cell with a negative offset value.",
    FontFamily->"Times"],
  "\n\[FilledSmallSquare] ",
  StyleBox["With the default setting ",
    FontFamily->"Times"],
  StyleBox["AnimationCycleOffset \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["0, the next cell is the one immediately below or above the \
current cell, depending on the direction the animation is currently moving \
in. ",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.4.3.3.4", "2.4.3.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["AnimationCycleRepetitions ", "ObjectName",
  CellTags->{"2.4.3.4.2", "2.4.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AnimationCycleRepetitions",
    FontFamily->"Courier"],
  " is an option for cells that determines the number of times a given \
animation cycle should be repeated. "
}], "Usage",
  CellTags->{"2.4.3.4.3", "2.4.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] This option applies to subloops within the main \
animation loop. ",
  StyleBox["With the setting ",
    FontFamily->"Times"],
  StyleBox["AnimationCycleRepetitions \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", the sub-animation is repeated ",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" times before moving to the next cell outside the subloop. Here, \
",
    FontFamily->"Times"],
  StyleBox["n",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" can be any positive integer.",
    FontFamily->"Times"],
  "\n\[FilledSmallSquare] ",
  StyleBox["With the setting ",
    FontFamily->"Times"],
  StyleBox["AnimationCycleRepetitions \[Rule] Infinity",
    FontFamily->"Courier"],
  StyleBox[", the sub-animation is repeated indefinitely until you explicitly \
stop it.",
    FontFamily->"Times"],
  " "
}], "Notes",
  CellTags->{"2.4.3.4.4", "2.4.3.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["RenderingOptions", "InspectorLevel1"],

Cell[CellGroupData[{

Cell[" \"DrawDummyGraphics\" ", "ObjectName",
  CellTags->{"2.4.4.2.2", "2.4.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"DrawDummyGraphics\"",
    FontFamily->"Courier"],
  " is an option for cells that determines if graphics are displayed on the \
screen."
}], "Usage",
  CellTags->{"2.4.4.2.3", "2.4.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"DrawDummyGraphics\" \[Rule] True",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " draws a placeholder instead of a graphic on the screen, but prints the \
correct graphic on paper. \n\[FilledSmallSquare] The default setting is ",
  StyleBox["\"DrawDummyGraphics\" \[Rule] False.",
    FontFamily->"Courier"]
}], "Notes",
  CellTags->{"2.4.4.2.4", "2.4.4.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"RenderIncrementally\" ", "ObjectName",
  CellTags->"2.4.4.2b"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RenderIncrementally\"",
    FontFamily->"Courier"],
  " is an option for cells that determines ",
  "if",
  " a graphic generated by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should be rendered incrementally, as the front end receives output from \
the kernel. "
}], "Usage",
  CellTags->"2.4.4.2b"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"RenderIncrementally\" \[Rule] True",
    FontFamily->"Courier"],
  ", the front renders each part of the graphic separately, building up the \
graphic in a series of steps.  \n\[FilledSmallSquare]  With the setting ",
  StyleBox["\"RenderIncrementally\" \[Rule] False",
    FontFamily->"Courier"],
  StyleBox[", the front end waits until the entire graphic is generated and \
then renders it in one step. This frees up memory in the front end so that \
you can continue working in a notebook while the graphic is being generated \
in the background.",
    FontFamily->"Times"]
}], "Notes",
  CellTags->"2.4.4.2b"]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"RenderFilledAreas\" ", "ObjectName",
  CellTags->{"2.4.4.3.2", "2.4.4.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RenderFilledAreas\"",
    FontFamily->"Courier"],
  " is an option for cells that determines whether or not to shade filled \
areas in graphics that contain multiple surfaces, such as three-dimensional \
polygons",
  StyleBox[".",
    FontFamily->"Times"]
}], "Usage",
  CellTags->{"2.4.4.3.3", "2.4.4.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"RenderFilledAreas\" \[Rule] False",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " draws only the lines surrounding a filled area. It may be necessary to \
rerender the graphic by resizing it or choosing ",
  StyleBox["Rerender Graphics ",
    FontFamily->"Helvetica"],
  "from the Cell menu before the change is reflected.\n\[FilledSmallSquare]  \
The default setting is ",
  StyleBox["\"RenderFilledAreas\" \[Rule] True",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.4.4.3.4", "2.4.4.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"RenderLines\" ", "ObjectName",
  CellTags->{"2.4.4.4.2", "2.4.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"RenderLines\"",
    FontFamily->"Courier"],
  " is an option for cells that determines if lines in a graphic should be \
rendered. "
}], "Usage",
  CellTags->{"2.4.4.4.3", "2.4.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"RenderLines\" \[Rule] False",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not draw the edges of a polygon in a graphic. It may be necessary to \
rerender the graphic, by resizing it or choosing ",
  StyleBox["Rerender Graphics",
    FontFamily->"Helvetica"],
  " from the Cell menu, before the change is reflected.\n\[FilledSmallSquare] \
 The default setting is ",
  StyleBox["\"RenderLines\" \[Rule] True",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.4.4.4.4", "2.4.4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"RenderThickness\" ", "ObjectName",
  CellTags->{"2.4.4.5.2", "2.4.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["RenderThickness",
    FontFamily->"Courier"],
  "\" ",
  "is an option for cells",
  " that determines if lines in a graphic can be drawn with varying \
thicknesses. "
}], "Usage",
  CellTags->{"2.4.4.5.3", "2.4.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"RenderThickness\" \[Rule] False",
    FontFamily->"Courier"],
  ", all lines in a graphic are drawn one pixel thick, regardless of their \
specified thickness. It may be necessary to rerender the graphic by resizing \
it or choosing ",
  StyleBox["Rerender Graphics",
    FontFamily->"Helvetica"],
  " from the Cell menu before the change is reflected.\n\[FilledSmallSquare]  \
The default setting is ",
  StyleBox["\"RenderThickness\" \[Rule] True",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.4.4.5.4", "2.4.4.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"RenderSystemColors\" ", "ObjectName",
  CellTags->"RenderSystemColors"],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["RenderSystemColors",
    FontFamily->"Courier"],
  "\" is an option for cells that determines if the default foreground and \
background colors for graphics in those cells follow the default system \
settings for foreground and background colors."
}], "Usage",
  CellTags->"RenderSystemColors"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"RenderSystemColors\" \[Rule] True",
    FontFamily->"Courier"],
  ", colors will follow the system theme."
}], "Notes",
  CellTags->"RenderSystemColors"],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["\"RenderSystemColors\" \[Rule] False",
    FontFamily->"Courier"],
  ", graphics will be black on a background the same color as the cell's \
background. "
}], "Notes",
  CellTags->"RenderSystemColors"]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"ObjectDithering\" ", "ObjectName",
  CellTags->{"2.4.4.6.2", "2.4.4.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ObjectDithering",
    FontFamily->"Courier"],
  "\" is an option for cells that determines ",
  "if",
  " lines and rectangles in a graphic show dithering. "
}], "Usage",
  CellTags->{"2.4.4.6.3", "2.4.4.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] Dithering refers to a method of representing colors \
on a screen by mixing several different colors. It produces a grainy \
appearance but can simulate a desired color much more accurately. With the \
default setting ",
  StyleBox["\"ObjectDithering\" \[Rule] True",
    FontFamily->"Courier"],
  StyleBox[", all lines and rectangles in a graphic are displayed with \
dithering. \n",
    FontFamily->"Times"],
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"ObjectDithering\" \[Rule] False",
    FontFamily->"Courier"],
  StyleBox[", lines and rectangles are drawn in a single color. This produces \
a more uniform appearance, but it is less accurate in reproducing color \
variations because the set of colors that can be drawn is limited to the \
colors available on the machine. ",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.4.4.6.4", "2.4.4.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"RasterDithering\" ", "ObjectName",
  CellTags->{"2.4.4.7.2", "2.4.4.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["RasterDithering",
    FontFamily->"Courier"],
  "\" is an option for cells that determines ",
  "if",
  " bitmapped images show dithering."
}], "Usage",
  CellTags->{"2.4.4.7.3", "2.4.4.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] Dithering refers to a method of representing colors \
on a screen by mixing several different colors. It produces a grainy \
appearance but can simulate a desired color much more accurately. With the \
setting ",
  StyleBox["\"RasterDithering\" \[Rule] True",
    FontFamily->"Courier"],
  StyleBox[", all bitmapped images are displayed with dithering. \n",
    FontFamily->"Times"],
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["\"RasterDithering\" \[Rule] False",
    FontFamily->"Courier"],
  StyleBox[", bitmapped images are drawn in a single color. This produces a \
more uniform appearance but is less accurate in reproducing color variations \
because the set of colors that can be drawn is limited to the colors \
available on the machine. ",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.4.4.7.4", "2.4.4.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"ImageHalftoneDensity\" ", "ObjectName",
  CellTags->{"2.4.4.8.2", "2.4.4.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ImageHalftoneDensity",
    FontFamily->"Courier"],
  "\" ",
  "is an option for cells",
  " that determines the spacing between lines in a halftone image."
}], "Usage",
  CellTags->{"2.4.4.8.3", "2.4.4.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ImageHalftoneDensity\"",
    FontFamily->"Courier"],
  " is specified as a number, in units of lines per inch.\n\
\[FilledSmallSquare] With the default setting ",
  StyleBox["\"ImageHalftoneDensity\" \[Rule] Automatic",
    FontFamily->"Courier"],
  StyleBox[", an appropriate value is chosen depending on the type of graphic \
being plotted.",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.4.4.8.4", "2.4.4.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"ImageHalftoneAngle\" ", "ObjectName",
  CellTags->{"2.4.4.9.2", "2.4.4.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ImageHalftoneAngle",
    FontFamily->"Courier"],
  "\" ",
  "is an option for cells",
  " that determines the angle between lines in a halftone image. "
}], "Usage",
  CellTags->{"2.4.4.9.3", "2.4.4.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ImageHalftoneAngle\"",
    FontFamily->"Courier"],
  " is specified as a number in degrees. \n\[FilledSmallSquare] With the \
default setting ",
  StyleBox["\"ImageHalftoneAngle\" \[Rule] Automatic",
    FontFamily->"Courier"],
  StyleBox[", an appropriate value is chosen depending on the type of graphic \
being plotted.",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.4.4.9.4", "2.4.4.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell[" \"ImageCacheDepth\" ", "ObjectName",
  CellTags->{"2.4.4.12.2", "2.4.4.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] \"",
  StyleBox["ImageCacheDepth",
    FontFamily->"Courier"],
  "\" ",
  "is an option for cells",
  " that determines the depth of the cache used for storing bitmapped \
images."
}], "Usage",
  CellTags->{"2.4.4.12.3", "2.4.4.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] The depth of the image cache, that is the number of \
bits per pixel, depends on the resolution of the monitor being used. When \
working on multiple monitors with different resolutions, the depth of the \
image cache must be  explicitly specified. With the default setting ",
  StyleBox["\"ImageCacheDepth\" \[Rule] DeepestScreen",
    FontFamily->"Courier"],
  StyleBox[", the cache depth is determined by the monitor with the highest \
resolution. \n",
    FontFamily->"Times"],
  "\[FilledSmallSquare] With the setting ",
  StyleBox["\"ImageCacheDepth\" \[Rule] WindowDepth",
    FontFamily->"Courier"],
  StyleBox[", the cache depth is determined by the last monitor on which the \
image was rendered.  \n",
    FontFamily->"Times"],
  "\[FilledSmallSquare] ",
  StyleBox["\"ImageCacheDepth\"",
    FontFamily->"Courier"],
  StyleBox[" can also be specified explicitly as the number of bits per \
pixel. ",
    FontFamily->"Times"]
}], "Notes",
  CellTags->{"2.4.4.12.4", "2.4.4.12"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Button Options", "Section",
  FontFamily->"Helvetica"],

Cell[CellGroupData[{

Cell["Action Options", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["Active ", "ObjectName",
  CellTags->{"2.5.3.2.2", "2.5.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Active", "MR"],
  " is an option for buttons that determines ",
  "if",
  " an action is performed when a button is clicked. "
}], "Usage",
  CellTags->{"2.5.3.2.3", "2.5.3.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] With ",
  StyleBox["Active", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " a button performs an action when it is clicked. \n\[FilledSmallSquare] \
With ",
  StyleBox["Active", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " the contents of a button can be edited. \n\[FilledSmallSquare] An active \
cell is indicated by an ",
  StyleBox["A", "MR"],
  " in the cell bracket. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.10",
    ButtonData:>{"2.9.10", "10.33"},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.2"},
    ButtonStyle->"MainBookLink"],
  ", and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.9",
    ButtonData:>{"2.11.9", "9.17"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Evaluator",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.3.2.4", "2.5.3.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonFunction ", "ObjectName",
  CellTags->{"2.5.3.3.2", "2.5.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonFunction", "MR"],
  " is an option for buttons that determines which function to execute when \
an active button is clicked. "
}], "Usage",
  CellTags->{"2.5.3.3.3", "2.5.3.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting for ",
  StyleBox["ButtonFunction", "MR"],
  " causes the button to paste its contents in the current notebook \
selection. \n\[FilledSmallSquare] ",
  StyleBox["ButtonFunction", "MR"],
  " is used only with the setting ",
  StyleBox["Active", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  " either for the button or for the cell the button is in.\n\
\[FilledSmallSquare] With ",
  StyleBox["ButtonFunction", "MR"],
  " ",
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  " ",
  StyleBox["f", "TI"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " the first argument supplied to ",
  StyleBox["f", "TI"],
  " is specified by the setting for ",
  StyleBox["ButtonSource", "MR"],
  " and the second argument by the setting for ",
  StyleBox["ButtonData", "MR"],
  ". \n\[FilledSmallSquare] Standard ",
  StyleBox["Mathematica", "TI"],
  " precedence rules require parentheses around a pure function, as in ",
  StyleBox["ButtonFunction", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["(", "MR"],
  StyleBox["body", "TI"],
  " ",
  StyleBox["&)", "MR"],
  ". \n\[FilledSmallSquare] Settings for ",
  StyleBox["ButtonFunction", "MR"],
  " are often inherited from button styles via the ",
  StyleBox["ButtonStyle", "MR"],
  " option. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonEvaluator",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNote",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NotebookApply",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.3.3.4", "2.5.3.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonSource ", "ObjectName",
  CellTags->{"2.5.3.4.2", "2.5.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonSource", "MR"],
  " is an option for buttons that determines the first argument to give to \
the ",
  StyleBox["ButtonFunction", "MR"],
  " for the button when it is active and is clicked. "
}], "Usage",
  CellTags->{"2.5.3.4.3", "2.5.3.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default is ",
  StyleBox["ButtonSource", "MRs",
    FontFamily->"Courier"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MRs",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] Possible settings are: \n",
  Cell[BoxData[
      FormBox[GridBox[{
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Automatic\\\\\\\"\\\", \\\"MR\
\\\"]\\) \"\>", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonData\\\\\\\"\\\", \\\
\"MR\\\"]\\) if it is set, otherwise \
\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonContents\\\\\\\"\\\", \\\"MR\\\"]\\) \
\"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonContents\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", "\<\"the first argument of the \\!\\(\\*StyleBox[\\\"\\\
\\\\\"ButtonBox\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonData\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", "\<\"the setting for the \
\\!\\(\\*StyleBox[\\\"\\\\\\\"ButtonData\\\\\\\"\\\", \\\"MR\\\"]\\) option \
\"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Cell\\\\\\\"\\\", \\\"MR\\\"]\
\\) \"\>", "\<\"the whole cell in which the button appears \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"CellContents\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", "\<\"the contents of the cell in which the button \
appears \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Notebook\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", "\<\"the whole notebook in which the button appears \
\"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"n\\\\\\\"\\\", \\\"TI\\\"]\\) \
\"\>", "\<\"the expression \\!\\(\\*StyleBox[\\\"\\\\\\\"n\\\\\\\"\\\", \
\\\"TI\\\"]\\) levels up from the button in the notebook \"\>"}
            },
          ColumnAlignments->{Left}], TextForm]], "Notes",
    FormatType->StandardForm,
    CellTags->"ButtonSource"],
  "\n\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI|",
    FontSlant->"Italic"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonData",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["NotebookRead",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.3.4.4", "2.5.3.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonEvaluator", "ObjectName",
  CellTags->{"2.5.3.5.2", "2.5.3.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonEvaluator", "MR"],
  " ",
  "is an option for buttons",
  " that determines where the expression constructed from ",
  StyleBox["ButtonFunction", "MR"],
  " should be sent for evaluation. "
}], "Usage",
  CellTags->{"2.5.3.5.3", "2.5.3.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonEvaluator", "MRs",
    FontFamily->"Courier"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["None", "MRs",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] Possible settings are as follows.\n",
  Cell[BoxData[
      FormBox[GridBox[{
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"None\\\\\\\"\\\", \\\"MR\\\"]\
\\) \"\>", "\<\"the front end \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Automatic\\\\\\\"\\\", \\\"MR\
\\\"]\\) \"\>", "\<\"the kernel used by default in the current notebook \
\"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\\\\\\\"\\\", \
\\\"MR\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\"name\\\\\\\"\\\", \
\\\"TI\\\"]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\\\\\\\"\\\", \
\\\"MR\\\"]\\) \"\>", "\<\"a kernel referred to by a specific name \"\>"}
            },
          ColumnAlignments->{Left}], TextForm]], "Notes",
    FormatType->StandardForm,
    CellTags->"ButtonEvaluator"],
  "\n\[FilledSmallSquare] With ",
  StyleBox["ButtonEvaluator", "MR:",
    FontFamily->"Courier"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Automatic", "MR:",
    FontFamily->"Courier"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " the expression to be evaluated can contain any ",
  StyleBox["Mathematica", "TI:",
    FontSlant->"Italic"],
  " objects. \n\[FilledSmallSquare] With ",
  StyleBox["ButtonEvaluator", "MR:",
    FontFamily->"Courier"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["None", "MR:",
    FontFamily->"Courier"],
  StyleBox[",", "MR",
    FontFamily->"Times"],
  " the expression can contain only notebook commands supported by the front \
end. All these commands are in the context ",
  StyleBox["FrontEnd`", "MR:",
    FontFamily->"Courier"],
  ". Expressions intended for processing only by the front end must be \
wrapped with ",
  StyleBox["FrontEndExecute", "MR:",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SelectionEvaluate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNotebook",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.3.5.4", "2.5.3.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonData ", "ObjectName",
  CellTags->{"2.5.3.6.2", "2.5.3.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonData", "MR"],
  " is an option for buttons that determines the second argument to give to \
the ",
  StyleBox["ButtonFunction", "MR"],
  " for the button when it is active and is clicked on. "
}], "Usage",
  CellTags->{"2.5.3.6.3", "2.5.3.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default is ",
  StyleBox["ButtonData", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["Null", "MR"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ButtonData", "MR"],
  " provides a convenient way to associate additional data with a button \
without affecting the display of the button. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonSource",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonNote",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.3.6.4", "2.5.3.6"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Display Options", "InspectorLevel1"],

Cell[CellGroupData[{

Cell["ButtonStyle", "ObjectName",
  CellTags->{"2.5.2.2", "2.5.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonStyle", "MR"],
  " is an option for buttons that determines properties of a button such as \
the type of action it performs and the details of its appearance."
}], "Usage",
  CellTags->{"2.5.2.3", "2.5.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Typical styles defined in the standard notebook front \
end are: \n",
  Cell[BoxData[
      FormBox[GridBox[{
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Paste\\\\\\\\\
\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"     \:f39fpaste the \
contents of the button (default) \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Evaluate\\\\\\\
\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"      paste and then \
evaluate in place what was pasted \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"EvaluateCell\\\
\\\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"     \:f39fpaste and \
then evaluate the whole cell \"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"CopyEvaluate\\\
\\\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", \(\(\ \ \ \ \ \ \ \ \ \
\)\("copy the current selection into a new cell; \[IndentingNewLine]then \
paste and evaluate in place "\)\)},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"\
CopyEvaluateCell\\\\\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", \("      \
copy the current selection into a new cell; \[IndentingNewLine]then paste and \
evaluate the entire cell "\)},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Hyperlink\\\\\
\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"      jump to a \
different location in the notebook \"\>"}
            },
          ColumnAlignments->{Left}], TextForm]], "Notes",
    FormatType->StandardForm,
    CellTags->"ButtonStyle"],
  "\n\[FilledSmallSquare] The properties can be superseded by explicit \
settings for ",
  StyleBox["ButtonBox", "MR\.85",
    FontFamily->"Courier"],
  " options. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.8"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonFrame",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.2.4", "2.5.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonFrame", "ObjectName",
  CellTags->{"2.5.4.2.2", "2.5.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonFrame", "MR"],
  " ",
  "is an option for buttons",
  " that determines the type of frame to display around a button. "
}], "Usage",
  CellTags->{"2.5.4.2.3", "2.5.4.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonFrame",
    FontFamily->"Courier"],
  "  ",
  StyleBox["\[Rule] Palette",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times New Roman"],
  "\n\[FilledSmallSquare] Typical settings supported include the following. \n\
",
  Cell[BoxData[
      FormBox[GridBox[{
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"Palette\\\\\\\
\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"a button in a palette \
\"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"DialogBox\\\\\
\\\\\\\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"a button in a dialog box \
\"\>"},
            {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"None\\\\\\\\\\\
\\\\\"\\\\\\\"\\\", \\\"MR\\\"]\\) \"\>", "\<\"a button with no frame \"\>"}
            },
          ColumnAlignments->{Left}], TextForm]], "Notes",
    FormatType->StandardForm,
    CellTags->"ButtonFrame"],
  "\n\[FilledSmallSquare] A button with a particular setting for ",
  StyleBox["ButtonFrame", "MR\[RightGuillemet]",
    FontFamily->"Courier"],
  " may look slightly different on different computer systems. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["WindowFrame",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.4.2.4", "2.5.4.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Background ", "ObjectName",
  CellTags->"ButtonBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background", "MR"],
  " ",
  "is an option for buttons",
  " that determines the background color of a button. "
}], "Usage",
  CellTags->"ButtonBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background",
    FontFamily->"Courier"],
  StyleBox[" is an option for notebooks, cells and selections. ",
    FontFamily->"Times New Roman"]
}], "Notes",
  CellTags->"ButtonBackground"],

Cell[TextData[{
  "\[FilledSmallSquare] With the default setting ",
  StyleBox["Background \[Rule] Automatic",
    FontFamily->"Courier"],
  ", the button backgrounds are drawn using the system's default settings for \
buttons."
}], "Notes",
  CellTags->"ButtonBackground"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times"],
  " You can select a custom color with the color dialog box that appears by \
clicking the square symbol to the right of the option. The color is specified \
as an ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " [",
  StyleBox["red",
    FontSlant->"Italic"],
  ", ",
  StyleBox["green",
    FontSlant->"Italic"],
  ", ",
  StyleBox["blue",
    FontSlant->"Italic"],
  "].It can also be specified using ",
  StyleBox["Hue",
    FontFamily->"Courier"],
  " or ",
  StyleBox["CMYKColor",
    FontFamily->"Courier"],
  ", but in these cases the color is automatically converted to ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " by the front end.\n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"ButtonBackground"]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonMargins", "ObjectName",
  CellTags->{"2.5.4.4.2", "2.5.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonMargins", "MR"],
  " ",
  "is an option for buttons",
  " that determines the space in printer's points between the contents of a \
button and the button frame. "
}], "Usage",
  CellTags->{"2.5.4.4.3", "2.5.4.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonMargins", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["3", "MR",
    FontFamily->"Courier"],
  ". \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonExpandable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonMinHeight",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.4.4.4", "2.5.4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonExpandable", "ObjectName",
  CellTags->{"2.5.4.5.2", "2.5.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonExpandable", "MR"],
  " is an option for buttons that determines ",
  "if",
  " the button should expand to fill any ",
  StyleBox["GridBox", "MR"],
  " position in which it appears. "
}], "Usage",
  CellTags->{"2.5.4.5.3", "2.5.4.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting is ",
  StyleBox["ButtonExpandable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["True", "MR"],
  ". \n\[FilledSmallSquare] This setting is typically used for all buttons \
that appear in palettes. \n\[FilledSmallSquare] With ",
  StyleBox["ButtonExpandable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  ", the size of a button is determined only by its contents, independent of \
its environment. \n\[FilledSmallSquare] With ",
  StyleBox["ButtonExpandable", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["False", "MR"],
  ", gutters will often be left between buttons in a grid box. \n\
\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonMinHeight",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["TextJustification",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.4.5.4", "2.5.4.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonMinHeight", "ObjectName",
  CellTags->{"2.5.4.6.2", "2.5.4.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonMinHeight", "MR"],
  " ",
  "is an option for buttons",
  " that determines the minimum total height in units of font size that \
should be allowed for the button. "
}], "Usage",
  CellTags->{"2.5.4.6.3", "2.5.4.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] The default setting ",
  StyleBox["ButtonMinHeight", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["1", "MR"],
  " forces a button to have a total height which at least accommodates all \
the characters in the current font. \n\[FilledSmallSquare] ",
  StyleBox["ButtonMinHeight", "MR"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["0", "MR"],
  " reduces the total height of a button as much as possible, allowing \
buttons containing characters such as \"",
  StyleBox["x\"", "MR"],
  " and \"",
  StyleBox["X\"", "MR"],
  " to be different heights. \n\[FilledSmallSquare] See ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.9.11",
    ButtonData:>{"2.9.11", "11.21"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonMargins",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonExpandable",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["RowMinHeight",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.4.6.4", "2.5.4.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ButtonNote", "ObjectName",
  CellTags->{"2.5.4.7.2", "2.5.4.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ButtonNote", "MR"],
  " ",
  "is an option for buttons",
  " that determines what should be displayed in the status line of the \
current notebook window when the button is active and the cursor is placed on \
top of the button. "
}], "Usage",
  CellTags->{"2.5.4.7.3", "2.5.4.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] By assigning a value to ",
  StyleBox["ButtonNote",
    FontFamily->"Courier"],
  ", you can provide a visual cue to indicate the function of the button. For \
example, in the Complete Characters palette, each button has the full name of \
the character as the setting for ",
  StyleBox["ButtonNote.",
    FontFamily->"Courier"],
  "\n\[FilledSmallSquare] With the default setting ",
  StyleBox["ButtonNote",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["None",
    FontFamily->"Courier"],
  ", no text is displayed in the status line.\n\[FilledSmallSquare] Any \
expression can be specified as the setting for ",
  StyleBox["ButtonNote", "MR"],
  ", though most windows will only allow a single character height to be \
displayed.\n\[FilledSmallSquare] ",
  StyleBox["ButtonNote", "MR"],
  " can be used to display keyboard equivalents for buttons in a palette. \n\
\[FilledSmallSquare] See ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["Section 2.11.6",
    ButtonData:>{"2.11.6", "6.14"},
    ButtonStyle->"MainBookLink"],
  ".\n\[FilledSmallSquare] See also: ",
  ButtonBox["ButtonData",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonFunction",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ButtonStyle",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"2.5.4.7.4", "2.5.4.7"}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1152}, {0, 848}},
ScreenStyleEnvironment->"Brackets",
PrintingStyleEnvironment->"Brackets",
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{634, 551},
WindowMargins->{{57, Automatic}, {Automatic, 59}},
PrintingCopies->1,
PrintingPageRange->{4, 5},
ShowCellBracket->True,
DefaultNewCellStyle->"Text",
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "OptionsIntroduction"->{
    Cell[1887, 61, 87, 1, 36, "Subsection",
      CellTags->{"OptionsIntroduction", "A1.1"}],
    Cell[1977, 64, 582, 13, 70, "Text",
      CellTags->{"OptionsIntroduction", "A1.1"}],
    Cell[2562, 79, 417, 7, 70, "Text",
      CellTags->{"OptionsIntroduction", "A1.1"}],
    Cell[2982, 88, 476, 9, 70, "Text",
      CellTags->{"OptionsIntroduction", "A1.1"}]},
  "A1.1"->{
    Cell[1887, 61, 87, 1, 36, "Subsection",
      CellTags->{"OptionsIntroduction", "A1.1"}],
    Cell[1977, 64, 582, 13, 70, "Text",
      CellTags->{"OptionsIntroduction", "A1.1"}],
    Cell[2562, 79, 417, 7, 70, "Text",
      CellTags->{"OptionsIntroduction", "A1.1"}],
    Cell[2982, 88, 476, 9, 70, "Text",
      CellTags->{"OptionsIntroduction", "A1.1"}]},
  "Introduction"->{
    Cell[3495, 102, 104, 1, 36, "Subsection",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[3602, 105, 238, 5, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[3843, 112, 208, 5, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4054, 119, 212, 6, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4269, 127, 311, 9, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4583, 138, 406, 10, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4992, 150, 622, 13, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[5617, 165, 354, 7, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[6008, 177, 103, 1, 36, "Subsection",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[6114, 180, 528, 15, 70, "Text",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[6645, 197, 332, 6, 70, "Text",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[6980, 205, 434, 9, 70, "Text",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[7451, 219, 105, 1, 36, "Subsection",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[7782, 231, 144, 2, 24, "Text",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[7929, 235, 176, 5, 26, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8108, 242, 279, 8, 26, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8390, 252, 236, 8, 26, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8629, 262, 334, 9, 44, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8966, 273, 491, 11, 62, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[9460, 286, 556, 14, 56, "Text",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}]},
  "OptionsInheritance"->{
    Cell[3495, 102, 104, 1, 36, "Subsection",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[3602, 105, 238, 5, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[3843, 112, 208, 5, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4054, 119, 212, 6, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4269, 127, 311, 9, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4583, 138, 406, 10, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4992, 150, 622, 13, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[5617, 165, 354, 7, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}]},
  "A1.2"->{
    Cell[3495, 102, 104, 1, 36, "Subsection",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[3602, 105, 238, 5, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[3843, 112, 208, 5, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4054, 119, 212, 6, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4269, 127, 311, 9, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4583, 138, 406, 10, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[4992, 150, 622, 13, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}],
    Cell[5617, 165, 354, 7, 70, "Text",
      CellTags->{"Introduction", "OptionsInheritance", "A1.2"}]},
  "OptionsSearching"->{
    Cell[6008, 177, 103, 1, 36, "Subsection",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[6114, 180, 528, 15, 70, "Text",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[6645, 197, 332, 6, 70, "Text",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[6980, 205, 434, 9, 70, "Text",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}]},
  "A1.3"->{
    Cell[6008, 177, 103, 1, 36, "Subsection",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[6114, 180, 528, 15, 70, "Text",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[6645, 197, 332, 6, 70, "Text",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}],
    Cell[6980, 205, 434, 9, 70, "Text",
      CellTags->{"Introduction", "OptionsSearching", "A1.3"}]},
  "OptionsSetting"->{
    Cell[7451, 219, 105, 1, 36, "Subsection",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[7782, 231, 144, 2, 24, "Text",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[7929, 235, 176, 5, 26, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8108, 242, 279, 8, 26, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8390, 252, 236, 8, 26, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8629, 262, 334, 9, 44, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8966, 273, 491, 11, 62, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[9460, 286, 556, 14, 56, "Text",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}]},
  "A1.4"->{
    Cell[7451, 219, 105, 1, 36, "Subsection",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[7559, 222, 220, 7, 40, "Text",
      CellTags->"A1.4"],
    Cell[7782, 231, 144, 2, 24, "Text",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[7929, 235, 176, 5, 26, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8108, 242, 279, 8, 26, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8390, 252, 236, 8, 26, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8629, 262, 334, 9, 44, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[8966, 273, 491, 11, 62, "ItemizedText",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}],
    Cell[9460, 286, 556, 14, 56, "Text",
      CellTags->{"Introduction", "OptionsSetting", "A1.4"}]},
  "1.1.1.1.1"->{
    Cell[10189, 314, 77, 1, 38, "ObjectName",
      CellTags->{"1.1.1.1.1", "1.1.1.1"}]},
  "1.1.1.1"->{
    Cell[10189, 314, 77, 1, 38, "ObjectName",
      CellTags->{"1.1.1.1.1", "1.1.1.1"}],
    Cell[10269, 317, 245, 7, 32, "Usage",
      CellTags->{"1.1.1.1.2", "1.1.1.1"}],
    Cell[10517, 326, 1055, 27, 154, "Notes",
      CellTags->{"1.1.1.1.3", "1.1.1.1"}]},
  "1.1.1.1.2"->{
    Cell[10269, 317, 245, 7, 32, "Usage",
      CellTags->{"1.1.1.1.2", "1.1.1.1"}]},
  "1.1.1.1.3"->{
    Cell[10517, 326, 1055, 27, 154, "Notes",
      CellTags->{"1.1.1.1.3", "1.1.1.1"}]},
  "1.1.1.2.1"->{
    Cell[11609, 358, 73, 1, 42, "ObjectName",
      CellTags->{"1.1.1.2.1", "1.1.1.2"}]},
  "1.1.1.2"->{
    Cell[11609, 358, 73, 1, 42, "ObjectName",
      CellTags->{"1.1.1.2.1", "1.1.1.2"}],
    Cell[11685, 361, 319, 10, 70, "Usage",
      CellTags->{"1.1.1.2.2", "1.1.1.2"}],
    Cell[12007, 373, 2156, 69, 70, "Notes",
      CellTags->{"1.1.1.2.3", "1.1.1.2"}]},
  "1.1.1.2.2"->{
    Cell[11685, 361, 319, 10, 70, "Usage",
      CellTags->{"1.1.1.2.2", "1.1.1.2"}]},
  "1.1.1.2.3"->{
    Cell[12007, 373, 2156, 69, 70, "Notes",
      CellTags->{"1.1.1.2.3", "1.1.1.2"}]},
  "1.1.1.3.1"->{
    Cell[14200, 447, 72, 1, 42, "ObjectName",
      CellTags->{"1.1.1.3.1", "1.1.1.3"}]},
  "1.1.1.3"->{
    Cell[14200, 447, 72, 1, 42, "ObjectName",
      CellTags->{"1.1.1.3.1", "1.1.1.3"}],
    Cell[14275, 450, 321, 10, 70, "Usage",
      CellTags->{"1.1.1.3.2", "1.1.1.3"}],
    Cell[14599, 462, 1652, 58, 70, "Notes",
      CellTags->{"1.1.1.3.3", "1.1.1.3"}]},
  "1.1.1.3.2"->{
    Cell[14275, 450, 321, 10, 70, "Usage",
      CellTags->{"1.1.1.3.2", "1.1.1.3"}]},
  "1.1.1.3.3"->{
    Cell[14599, 462, 1652, 58, 70, "Notes",
      CellTags->{"1.1.1.3.3", "1.1.1.3"}]},
  "1.1.1.4.1"->{
    Cell[16288, 525, 76, 1, 42, "ObjectName",
      CellTags->{"1.1.1.4.1", "1.1.1.4"}]},
  "1.1.1.4"->{
    Cell[16288, 525, 76, 1, 42, "ObjectName",
      CellTags->{"1.1.1.4.1", "1.1.1.4"}],
    Cell[16367, 528, 343, 12, 70, "Usage",
      CellTags->{"1.1.1.4.2", "1.1.1.4"}],
    Cell[16713, 542, 826, 24, 70, "Notes",
      CellTags->{"1.1.1.4.3", "1.1.1.4"}]},
  "1.1.1.4.2"->{
    Cell[16367, 528, 343, 12, 70, "Usage",
      CellTags->{"1.1.1.4.2", "1.1.1.4"}]},
  "1.1.1.4.3"->{
    Cell[16713, 542, 826, 24, 70, "Notes",
      CellTags->{"1.1.1.4.3", "1.1.1.4"}]},
  "1.1.1.4b"->{
    Cell[17576, 571, 63, 1, 42, "ObjectName",
      CellTags->"1.1.1.4b"],
    Cell[17642, 574, 326, 11, 48, "Usage",
      CellTags->"1.1.1.4b"],
    Cell[17971, 587, 1296, 40, 153, "Notes",
      CellTags->"1.1.1.4b"]},
  "1.1.1.5.1"->{
    Cell[19304, 632, 75, 1, 42, "ObjectName",
      CellTags->{"1.1.1.5.1", "1.1.1.5"}]},
  "1.1.1.5"->{
    Cell[19304, 632, 75, 1, 42, "ObjectName",
      CellTags->{"1.1.1.5.1", "1.1.1.5"}],
    Cell[19382, 635, 322, 10, 70, "Usage",
      CellTags->{"1.1.1.5.2", "1.1.1.5"}],
    Cell[19707, 647, 1669, 58, 70, "Notes",
      CellTags->{"1.1.1.5.3", "1.1.1.5"}]},
  "1.1.1.5.2"->{
    Cell[19382, 635, 322, 10, 70, "Usage",
      CellTags->{"1.1.1.5.2", "1.1.1.5"}]},
  "1.1.1.5.3"->{
    Cell[19707, 647, 1669, 58, 70, "Notes",
      CellTags->{"1.1.1.5.3", "1.1.1.5"}]},
  "1.1.1.6.1"->{
    Cell[21413, 710, 76, 1, 42, "ObjectName",
      CellTags->{"1.1.1.6.1", "1.1.1.6"}]},
  "1.1.1.6"->{
    Cell[21413, 710, 76, 1, 42, "ObjectName",
      CellTags->{"1.1.1.6.1", "1.1.1.6"}],
    Cell[21492, 713, 275, 8, 70, "Usage",
      CellTags->{"1.1.1.6.2", "1.1.1.6"}],
    Cell[21770, 723, 626, 14, 70, "Notes",
      CellTags->{"1.1.1.6.3", "1.1.1.6"}]},
  "1.1.1.6.2"->{
    Cell[21492, 713, 275, 8, 70, "Usage",
      CellTags->{"1.1.1.6.2", "1.1.1.6"}]},
  "1.1.1.6.3"->{
    Cell[21770, 723, 626, 14, 70, "Notes",
      CellTags->{"1.1.1.6.3", "1.1.1.6"}]},
  "1.1.1.7.1"->{
    Cell[22433, 742, 84, 1, 42, "ObjectName",
      CellTags->{"1.1.1.7.1", "1.1.1.7"}]},
  "1.1.1.7"->{
    Cell[22433, 742, 84, 1, 42, "ObjectName",
      CellTags->{"1.1.1.7.1", "1.1.1.7"}],
    Cell[22520, 745, 270, 8, 70, "Usage",
      CellTags->{"1.1.1.7.2", "1.1.1.7"}],
    Cell[22793, 755, 580, 15, 70, "Notes",
      CellTags->{"1.1.1.7.3", "1.1.1.7"}]},
  "1.1.1.7.2"->{
    Cell[22520, 745, 270, 8, 70, "Usage",
      CellTags->{"1.1.1.7.2", "1.1.1.7"}]},
  "1.1.1.7.3"->{
    Cell[22793, 755, 580, 15, 70, "Notes",
      CellTags->{"1.1.1.7.3", "1.1.1.7"}]},
  "1.1.1.8.1"->{
    Cell[23410, 775, 76, 1, 42, "ObjectName",
      CellTags->{"1.1.1.8.1", "1.1.1.8"}]},
  "1.1.1.8"->{
    Cell[23410, 775, 76, 1, 42, "ObjectName",
      CellTags->{"1.1.1.8.1", "1.1.1.8"}],
    Cell[23489, 778, 341, 11, 70, "Usage",
      CellTags->{"1.1.1.8.2", "1.1.1.8"}],
    Cell[23833, 791, 2157, 62, 70, "Notes",
      CellTags->{"1.1.1.8.3", "1.1.1.8"}]},
  "1.1.1.8.2"->{
    Cell[23489, 778, 341, 11, 70, "Usage",
      CellTags->{"1.1.1.8.2", "1.1.1.8"}]},
  "1.1.1.8.3"->{
    Cell[23833, 791, 2157, 62, 70, "Notes",
      CellTags->{"1.1.1.8.3", "1.1.1.8"}]},
  "1.1.1.9.1"->{
    Cell[26027, 858, 78, 1, 42, "ObjectName",
      CellTags->{"1.1.1.9.1", "1.1.1.9"}]},
  "1.1.1.9"->{
    Cell[26027, 858, 78, 1, 42, "ObjectName",
      CellTags->{"1.1.1.9.1", "1.1.1.9"}],
    Cell[26108, 861, 280, 8, 70, "Usage",
      CellTags->{"1.1.1.9.2", "1.1.1.9"}],
    Cell[26391, 871, 1809, 50, 70, "Notes",
      CellTags->{"1.1.1.9.3", "1.1.1.9"}]},
  "1.1.1.9.2"->{
    Cell[26108, 861, 280, 8, 70, "Usage",
      CellTags->{"1.1.1.9.2", "1.1.1.9"}]},
  "1.1.1.9.3"->{
    Cell[26391, 871, 1809, 50, 70, "Notes",
      CellTags->{"1.1.1.9.3", "1.1.1.9"}]},
  "1.1.1.10.1"->{
    Cell[28237, 926, 77, 1, 42, "ObjectName",
      CellTags->{"1.1.1.10.1", "1.1.1.10"}]},
  "1.1.1.10"->{
    Cell[28237, 926, 77, 1, 42, "ObjectName",
      CellTags->{"1.1.1.10.1", "1.1.1.10"}],
    Cell[28317, 929, 299, 8, 70, "Usage",
      CellTags->{"1.1.1.10.2", "1.1.1.10"}],
    Cell[28619, 939, 1451, 43, 70, "Notes",
      CellTags->{"1.1.1.10.3", "1.1.1.10"}]},
  "1.1.1.10.2"->{
    Cell[28317, 929, 299, 8, 70, "Usage",
      CellTags->{"1.1.1.10.2", "1.1.1.10"}]},
  "1.1.1.10.3"->{
    Cell[28619, 939, 1451, 43, 70, "Notes",
      CellTags->{"1.1.1.10.3", "1.1.1.10"}]},
  "1.1.1.11.1"->{
    Cell[30107, 987, 76, 1, 42, "ObjectName",
      CellTags->{"1.1.1.11.1", "1.1.1.11"}]},
  "1.1.1.11"->{
    Cell[30107, 987, 76, 1, 42, "ObjectName",
      CellTags->{"1.1.1.11.1", "1.1.1.11"}],
    Cell[30186, 990, 316, 10, 70, "Usage",
      CellTags->{"1.1.1.11.2", "1.1.1.11"}],
    Cell[30505, 1002, 1907, 57, 70, "Notes",
      CellTags->{"1.1.1.11.3", "1.1.1.11"}]},
  "1.1.1.11.2"->{
    Cell[30186, 990, 316, 10, 70, "Usage",
      CellTags->{"1.1.1.11.2", "1.1.1.11"}]},
  "1.1.1.11.3"->{
    Cell[30505, 1002, 1907, 57, 70, "Notes",
      CellTags->{"1.1.1.11.3", "1.1.1.11"}]},
  "1.1.1.12.1"->{
    Cell[32449, 1064, 75, 1, 42, "ObjectName",
      CellTags->{"1.1.1.12.1", "1.1.1.12"}]},
  "1.1.1.12"->{
    Cell[32449, 1064, 75, 1, 42, "ObjectName",
      CellTags->{"1.1.1.12.1", "1.1.1.12"}],
    Cell[32527, 1067, 347, 11, 70, "Usage",
      CellTags->{"1.1.1.12.2", "1.1.1.12"}],
    Cell[32877, 1080, 1244, 34, 70, "Notes",
      CellTags->{"1.1.1.12.3", "1.1.1.12"}]},
  "1.1.1.12.2"->{
    Cell[32527, 1067, 347, 11, 70, "Usage",
      CellTags->{"1.1.1.12.2", "1.1.1.12"}]},
  "1.1.1.12.3"->{
    Cell[32877, 1080, 1244, 34, 70, "Notes",
      CellTags->{"1.1.1.12.3", "1.1.1.12"}]},
  "1.1.1.13.1"->{
    Cell[34158, 1119, 87, 1, 42, "ObjectName",
      CellTags->{"1.1.1.13.1", "1.1.1.13"}]},
  "1.1.1.13"->{
    Cell[34158, 1119, 87, 1, 42, "ObjectName",
      CellTags->{"1.1.1.13.1", "1.1.1.13"}],
    Cell[34248, 1122, 404, 11, 70, "Usage",
      CellTags->{"1.1.1.13.2", "1.1.1.13"}],
    Cell[34655, 1135, 1120, 33, 70, "Notes",
      CellTags->{"1.1.1.13.3", "1.1.1.13"}]},
  "1.1.1.13.2"->{
    Cell[34248, 1122, 404, 11, 70, "Usage",
      CellTags->{"1.1.1.13.2", "1.1.1.13"}]},
  "1.1.1.13.3"->{
    Cell[34655, 1135, 1120, 33, 70, "Notes",
      CellTags->{"1.1.1.13.3", "1.1.1.13"}]},
  "1.1.1.14.1"->{
    Cell[35812, 1173, 85, 1, 42, "ObjectName",
      CellTags->{"1.1.1.14.1", "1.1.1.14"}]},
  "1.1.1.14"->{
    Cell[35812, 1173, 85, 1, 42, "ObjectName",
      CellTags->{"1.1.1.14.1", "1.1.1.14"}],
    Cell[35900, 1176, 278, 7, 70, "Usage",
      CellTags->{"1.1.1.14.2", "1.1.1.14"}],
    Cell[36181, 1185, 1169, 36, 70, "Notes",
      CellTags->{"1.1.1.14.3", "1.1.1.14"}]},
  "1.1.1.14.2"->{
    Cell[35900, 1176, 278, 7, 70, "Usage",
      CellTags->{"1.1.1.14.2", "1.1.1.14"}]},
  "1.1.1.14.3"->{
    Cell[36181, 1185, 1169, 36, 70, "Notes",
      CellTags->{"1.1.1.14.3", "1.1.1.14"}]},
  "1.1.1.15"->{
    Cell[37387, 1226, 113, 2, 24, "GroupObjectName",
      CellTags->"1.1.1.15"],
    Cell[37503, 1230, 560, 13, 70, "Text",
      CellTags->"1.1.1.15"],
    Cell[38088, 1247, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.1.15.1.1", "1.1.1.15"}],
    Cell[38181, 1250, 340, 11, 70, "Usage",
      CellTags->{"1.1.1.15.1.2", "1.1.1.15"}],
    Cell[38524, 1263, 824, 16, 70, "Notes",
      CellTags->{"1.1.1.15.1.3", "1.1.1.15"}],
    Cell[39385, 1284, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.1.15.1.1", "1.1.1.15"}],
    Cell[39480, 1287, 344, 11, 70, "Usage",
      CellTags->{"1.1.1.15.1.2", "1.1.1.15"}],
    Cell[39827, 1300, 683, 15, 70, "Notes",
      CellTags->{"1.1.1.15.1.3", "1.1.1.15"}],
    Cell[40547, 1320, 81, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.1.15.2.1", "1.1.1.15"}],
    Cell[40631, 1323, 292, 8, 70, "Usage",
      CellTags->{"1.1.1.15.2.2", "1.1.1.15"}],
    Cell[40926, 1333, 752, 16, 70, "Notes",
      CellTags->{"1.1.1.15.2.3", "1.1.1.15"}],
    Cell[41715, 1354, 82, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.1.15.3.1", "1.1.1.15"}],
    Cell[41800, 1357, 322, 11, 70, "Usage",
      CellTags->{"1.1.1.15.3.2", "1.1.1.15"}],
    Cell[42125, 1370, 769, 18, 70, "Notes",
      CellTags->{"1.1.1.15.3.3", "1.1.1.15"}]},
  "1.1.1.15.1.1"->{
    Cell[38088, 1247, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.1.15.1.1", "1.1.1.15"}],
    Cell[39385, 1284, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.1.15.1.1", "1.1.1.15"}]},
  "1.1.1.15.1.2"->{
    Cell[38181, 1250, 340, 11, 70, "Usage",
      CellTags->{"1.1.1.15.1.2", "1.1.1.15"}],
    Cell[39480, 1287, 344, 11, 70, "Usage",
      CellTags->{"1.1.1.15.1.2", "1.1.1.15"}]},
  "1.1.1.15.1.3"->{
    Cell[38524, 1263, 824, 16, 70, "Notes",
      CellTags->{"1.1.1.15.1.3", "1.1.1.15"}],
    Cell[39827, 1300, 683, 15, 70, "Notes",
      CellTags->{"1.1.1.15.1.3", "1.1.1.15"}]},
  "1.1.1.15.2.1"->{
    Cell[40547, 1320, 81, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.1.15.2.1", "1.1.1.15"}]},
  "1.1.1.15.2.2"->{
    Cell[40631, 1323, 292, 8, 70, "Usage",
      CellTags->{"1.1.1.15.2.2", "1.1.1.15"}]},
  "1.1.1.15.2.3"->{
    Cell[40926, 1333, 752, 16, 70, "Notes",
      CellTags->{"1.1.1.15.2.3", "1.1.1.15"}]},
  "1.1.1.15.3.1"->{
    Cell[41715, 1354, 82, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.1.15.3.1", "1.1.1.15"}]},
  "1.1.1.15.3.2"->{
    Cell[41800, 1357, 322, 11, 70, "Usage",
      CellTags->{"1.1.1.15.3.2", "1.1.1.15"}]},
  "1.1.1.15.3.3"->{
    Cell[42125, 1370, 769, 18, 70, "Notes",
      CellTags->{"1.1.1.15.3.3", "1.1.1.15"}]},
  "1.1.2.0a"->{
    Cell[43033, 1399, 68, 1, 38, "ObjectName",
      CellTags->"1.1.2.0a"],
    Cell[43104, 1402, 354, 12, 70, "Usage",
      CellTags->"1.1.2.0a"],
    Cell[43461, 1416, 1091, 27, 70, "Notes",
      CellTags->"1.1.2.0a"]},
  "1.1.2.0b"->{
    Cell[44589, 1448, 68, 1, 42, "ObjectName",
      CellTags->"1.1.2.0b"],
    Cell[44660, 1451, 353, 12, 70, "Usage",
      CellTags->"1.1.2.0b"],
    Cell[45016, 1465, 1147, 30, 70, "Notes",
      CellTags->"1.1.2.0b"]},
  "1.1.2.1.1"->{
    Cell[46200, 1500, 133, 2, 24, "GroupObjectName",
      CellTags->{"1.1.2.1.1", "1.1.2.1"}]},
  "1.1.2.1"->{
    Cell[46200, 1500, 133, 2, 24, "GroupObjectName",
      CellTags->{"1.1.2.1.1", "1.1.2.1"}],
    Cell[46336, 1504, 395, 12, 40, "Text",
      CellTags->{"1.1.2.1.2", "1.1.2.1"}],
    Cell[46756, 1520, 87, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.2.1.1.1", "1.1.2.1"}],
    Cell[46846, 1523, 255, 7, 70, "Usage",
      CellTags->{"1.1.2.1.1.2", "1.1.2.1"}],
    Cell[47104, 1532, 1512, 33, 70, "Notes",
      CellTags->{"1.1.2.1.1.3", "1.1.2.1"}],
    Cell[48653, 1570, 93, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.1.2.1", "1.1.2.1"}],
    Cell[48749, 1573, 260, 8, 70, "Usage",
      CellTags->{"1.1.2.1.2.2", "1.1.2.1"}],
    Cell[49012, 1583, 1546, 52, 70, "Notes",
      CellTags->{"1.1.2.1.2.3", "1.1.2.1"}],
    Cell[50595, 1640, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.1.3.1", "1.1.2.1"}],
    Cell[50690, 1643, 494, 15, 70, "Usage",
      CellTags->{"1.1.2.1.3.2", "1.1.2.1"}],
    Cell[51187, 1660, 821, 30, 70, "Notes",
      CellTags->{"1.1.2.1.3.3", "1.1.2.1"}]},
  "1.1.2.1.2"->{
    Cell[46336, 1504, 395, 12, 40, "Text",
      CellTags->{"1.1.2.1.2", "1.1.2.1"}]},
  "1.1.2.1.1.1"->{
    Cell[46756, 1520, 87, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.2.1.1.1", "1.1.2.1"}]},
  "1.1.2.1.1.2"->{
    Cell[46846, 1523, 255, 7, 70, "Usage",
      CellTags->{"1.1.2.1.1.2", "1.1.2.1"}]},
  "1.1.2.1.1.3"->{
    Cell[47104, 1532, 1512, 33, 70, "Notes",
      CellTags->{"1.1.2.1.1.3", "1.1.2.1"}]},
  "1.1.2.1.2.1"->{
    Cell[48653, 1570, 93, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.1.2.1", "1.1.2.1"}]},
  "1.1.2.1.2.2"->{
    Cell[48749, 1573, 260, 8, 70, "Usage",
      CellTags->{"1.1.2.1.2.2", "1.1.2.1"}]},
  "1.1.2.1.2.3"->{
    Cell[49012, 1583, 1546, 52, 70, "Notes",
      CellTags->{"1.1.2.1.2.3", "1.1.2.1"}]},
  "1.1.2.1.3.1"->{
    Cell[50595, 1640, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.1.3.1", "1.1.2.1"}]},
  "1.1.2.1.3.2"->{
    Cell[50690, 1643, 494, 15, 70, "Usage",
      CellTags->{"1.1.2.1.3.2", "1.1.2.1"}]},
  "1.1.2.1.3.3"->{
    Cell[51187, 1660, 821, 30, 70, "Notes",
      CellTags->{"1.1.2.1.3.3", "1.1.2.1"}]},
  "1.1.2.2"->{
    Cell[52057, 1696, 120, 2, 34, "GroupObjectName",
      CellTags->"1.1.2.2"],
    Cell[52180, 1700, 563, 11, 84, "Text",
      CellTags->{"1.1.2.2.2", "1.1.2.2"}],
    Cell[52768, 1715, 97, 1, 39, "SubObjectNameClosed",
      CellTags->{"1.1.2.2.1.1", "1.1.2.2"}],
    Cell[52868, 1718, 350, 11, 60, "Usage",
      CellTags->{"1.1.2.2.1.2", "1.1.2.2"}],
    Cell[53221, 1731, 827, 18, 144, "Notes",
      CellTags->{"1.1.2.2.1.3", "1.1.2.2"}],
    Cell[55153, 1790, 158, 5, 39, "SubObjectNameClosed",
      CellTags->{"1.1.2.2.2.1", "1.1.2.2"}],
    Cell[55314, 1797, 387, 12, 70, "Usage",
      CellTags->{"1.1.2.2.2.2", "1.1.2.2"}],
    Cell[55704, 1811, 495, 10, 70, "Notes",
      CellTags->{"1.1.2.2.2.3", "1.1.2.2"}],
    Cell[56236, 1826, 87, 1, 33, "SubObjectNameClosed",
      CellTags->{"1.1.2.2.3.1", "1.1.2.2"}],
    Cell[56326, 1829, 318, 9, 70, "Usage",
      CellTags->{"1.1.2.2.3.2", "1.1.2.2"}],
    Cell[56647, 1840, 379, 9, 70, "Notes",
      CellTags->{"1.1.2.2.3.3", "1.1.2.2"}]},
  "1.1.2.2.2"->{
    Cell[52180, 1700, 563, 11, 84, "Text",
      CellTags->{"1.1.2.2.2", "1.1.2.2"}]},
  "1.1.2.2.1.1"->{
    Cell[52768, 1715, 97, 1, 39, "SubObjectNameClosed",
      CellTags->{"1.1.2.2.1.1", "1.1.2.2"}]},
  "1.1.2.2.1.2"->{
    Cell[52868, 1718, 350, 11, 60, "Usage",
      CellTags->{"1.1.2.2.1.2", "1.1.2.2"}]},
  "1.1.2.2.1.3"->{
    Cell[53221, 1731, 827, 18, 144, "Notes",
      CellTags->{"1.1.2.2.1.3", "1.1.2.2"}]},
  "1.1.2.2.1.2b"->{
    Cell[54085, 1754, 83, 1, 39, "SubObjectNameClosed",
      CellTags->"1.1.2.2.1.2b"],
    Cell[54171, 1757, 312, 9, 60, "Usage",
      CellTags->"1.1.2.2.1.2b"],
    Cell[54486, 1768, 630, 17, 112, "Notes",
      CellTags->"1.1.2.2.1.2b"]},
  "1.1.2.2.2.1"->{
    Cell[55153, 1790, 158, 5, 39, "SubObjectNameClosed",
      CellTags->{"1.1.2.2.2.1", "1.1.2.2"}]},
  "1.1.2.2.2.2"->{
    Cell[55314, 1797, 387, 12, 70, "Usage",
      CellTags->{"1.1.2.2.2.2", "1.1.2.2"}]},
  "1.1.2.2.2.3"->{
    Cell[55704, 1811, 495, 10, 70, "Notes",
      CellTags->{"1.1.2.2.2.3", "1.1.2.2"}]},
  "1.1.2.2.3.1"->{
    Cell[56236, 1826, 87, 1, 33, "SubObjectNameClosed",
      CellTags->{"1.1.2.2.3.1", "1.1.2.2"}]},
  "1.1.2.2.3.2"->{
    Cell[56326, 1829, 318, 9, 70, "Usage",
      CellTags->{"1.1.2.2.3.2", "1.1.2.2"}]},
  "1.1.2.2.3.3"->{
    Cell[56647, 1840, 379, 9, 70, "Notes",
      CellTags->{"1.1.2.2.3.3", "1.1.2.2"}]},
  "1.1.2.2.x"->{
    Cell[57075, 1855, 123, 2, 24, "GroupObjectName",
      CellTags->"1.1.2.2.x"],
    Cell[57223, 1861, 70, 1, 70, "SubObjectNameClosed",
      CellTags->"1.1.2.2.x"],
    Cell[57296, 1864, 238, 8, 70, "Usage",
      CellTags->"1.1.2.2.x"],
    Cell[57537, 1874, 671, 16, 70, "Notes",
      CellTags->"1.1.2.2.x"]},
  "1.1.2.3"->{
    Cell[58257, 1896, 137, 5, 24, "GroupObjectName",
      CellTags->"1.1.2.3"],
    Cell[58397, 1903, 292, 9, 40, "Text",
      CellTags->"1.1.2.3"],
    Cell[58714, 1916, 68, 1, 27, "SubObjectNameClosed",
      CellTags->"1.1.2.3"],
    Cell[58785, 1919, 236, 8, 70, "Usage",
      CellTags->"1.1.2.3"],
    Cell[59024, 1929, 669, 16, 70, "Notes",
      CellTags->"1.1.2.3"],
    Cell[59730, 1950, 67, 1, 21, "SubObjectNameClosed",
      CellTags->"1.1.2.3"],
    Cell[59800, 1953, 186, 7, 70, "Usage",
      CellTags->"1.1.2.3"],
    Cell[59989, 1962, 1354, 42, 70, "Notes",
      CellTags->"1.1.2.3"],
    Cell[61380, 2009, 75, 1, 21, "SubObjectNameClosed",
      CellTags->"1.1.2.3"],
    Cell[61458, 2012, 299, 9, 48, "Usage",
      CellTags->"1.1.2.3"],
    Cell[61760, 2023, 550, 15, 84, "Notes",
      CellTags->"1.1.2.3"],
    Cell[62347, 2043, 73, 1, 27, "SubObjectNameClosed",
      CellTags->"1.1.2.3"],
    Cell[62423, 2046, 254, 8, 70, "Usage",
      CellTags->"1.1.2.3"],
    Cell[62680, 2056, 564, 15, 70, "Notes",
      CellTags->"1.1.2.3"],
    Cell[63281, 2076, 68, 1, 21, "SubObjectNameClosed",
      CellTags->"1.1.2.3"],
    Cell[63352, 2079, 259, 9, 70, "Usage",
      CellTags->"1.1.2.3"],
    Cell[63614, 2090, 240, 6, 70, "Notes",
      CellTags->"1.1.2.3"],
    Cell[63891, 2101, 77, 1, 21, "SubObjectNameClosed",
      CellTags->"1.1.2.3"],
    Cell[63971, 2104, 263, 7, 70, "Usage",
      CellTags->"1.1.2.3"],
    Cell[64237, 2113, 585, 11, 70, "Notes",
      CellTags->"1.1.2.3"]},
  "1.1.2.4.1"->{
    Cell[64871, 2130, 140, 3, 24, "GroupObjectName",
      CellTags->{"1.1.2.4.1", "1.1.2.4"}]},
  "1.1.2.4"->{
    Cell[64871, 2130, 140, 3, 24, "GroupObjectName",
      CellTags->{"1.1.2.4.1", "1.1.2.4"}],
    Cell[65014, 2135, 316, 9, 40, "Text",
      CellTags->{"1.1.2.4.2", "1.1.2.4"}],
    Cell[65355, 2148, 85, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.1.1", "1.1.2.4"}],
    Cell[65443, 2151, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.4.1.2", "1.1.2.4"}],
    Cell[65699, 2161, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.4.1.3", "1.1.2.4"}],
    Cell[66422, 2182, 84, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.2.1", "1.1.2.4"}],
    Cell[66509, 2185, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.4.2.2", "1.1.2.4"}],
    Cell[66715, 2194, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.4.2.3", "1.1.2.4"}],
    Cell[68131, 2242, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.3.1", "1.1.2.4"}],
    Cell[68226, 2245, 316, 9, 48, "Usage",
      CellTags->{"1.1.2.4.3.2", "1.1.2.4"}],
    Cell[68545, 2256, 556, 14, 84, "Notes",
      CellTags->{"1.1.2.4.3.3", "1.1.2.4"}],
    Cell[69138, 2275, 90, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.4.1", "1.1.2.4"}],
    Cell[69231, 2278, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.4.4.2", "1.1.2.4"}],
    Cell[69505, 2288, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.4.4.3", "1.1.2.4"}],
    Cell[70123, 2308, 85, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.5.1", "1.1.2.4"}],
    Cell[70211, 2311, 276, 9, 70, "Usage",
      CellTags->{"1.1.2.4.5.2", "1.1.2.4"}],
    Cell[70490, 2322, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.4.5.3", "1.1.2.4"}],
    Cell[70784, 2333, 94, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.6.1", "1.1.2.4"}],
    Cell[70881, 2336, 290, 9, 70, "Usage",
      CellTags->{"1.1.2.4.6.2", "1.1.2.4"}],
    Cell[71174, 2347, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.4.6.3", "1.1.2.4"}]},
  "1.1.2.4.2"->{
    Cell[65014, 2135, 316, 9, 40, "Text",
      CellTags->{"1.1.2.4.2", "1.1.2.4"}]},
  "1.1.2.4.1.1"->{
    Cell[65355, 2148, 85, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.1.1", "1.1.2.4"}]},
  "1.1.2.4.1.2"->{
    Cell[65443, 2151, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.4.1.2", "1.1.2.4"}]},
  "1.1.2.4.1.3"->{
    Cell[65699, 2161, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.4.1.3", "1.1.2.4"}]},
  "1.1.2.4.2.1"->{
    Cell[66422, 2182, 84, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.2.1", "1.1.2.4"}]},
  "1.1.2.4.2.2"->{
    Cell[66509, 2185, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.4.2.2", "1.1.2.4"}]},
  "1.1.2.4.2.3"->{
    Cell[66715, 2194, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.4.2.3", "1.1.2.4"}]},
  "1.1.2.4.3.1"->{
    Cell[68131, 2242, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.3.1", "1.1.2.4"}]},
  "1.1.2.4.3.2"->{
    Cell[68226, 2245, 316, 9, 48, "Usage",
      CellTags->{"1.1.2.4.3.2", "1.1.2.4"}]},
  "1.1.2.4.3.3"->{
    Cell[68545, 2256, 556, 14, 84, "Notes",
      CellTags->{"1.1.2.4.3.3", "1.1.2.4"}]},
  "1.1.2.4.4.1"->{
    Cell[69138, 2275, 90, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.4.1", "1.1.2.4"}]},
  "1.1.2.4.4.2"->{
    Cell[69231, 2278, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.4.4.2", "1.1.2.4"}]},
  "1.1.2.4.4.3"->{
    Cell[69505, 2288, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.4.4.3", "1.1.2.4"}]},
  "1.1.2.4.5.1"->{
    Cell[70123, 2308, 85, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.5.1", "1.1.2.4"}]},
  "1.1.2.4.5.2"->{
    Cell[70211, 2311, 276, 9, 70, "Usage",
      CellTags->{"1.1.2.4.5.2", "1.1.2.4"}]},
  "1.1.2.4.5.3"->{
    Cell[70490, 2322, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.4.5.3", "1.1.2.4"}]},
  "1.1.2.4.6.1"->{
    Cell[70784, 2333, 94, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.2.4.6.1", "1.1.2.4"}]},
  "1.1.2.4.6.2"->{
    Cell[70881, 2336, 290, 9, 70, "Usage",
      CellTags->{"1.1.2.4.6.2", "1.1.2.4"}]},
  "1.1.2.4.6.3"->{
    Cell[71174, 2347, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.4.6.3", "1.1.2.4"}]},
  "1.1.2.5.1"->{
    Cell[71825, 2364, 152, 5, 24, "GroupObjectName",
      CellTags->{"1.1.2.5.1", "1.1.2.5"}]},
  "1.1.2.5"->{
    Cell[71825, 2364, 152, 5, 24, "GroupObjectName",
      CellTags->{"1.1.2.5.1", "1.1.2.5"}],
    Cell[71980, 2371, 359, 10, 70, "Text",
      CellTags->{"1.1.2.5.2", "1.1.2.5"}],
    Cell[72364, 2385, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.1.1", "1.1.2.5"}],
    Cell[72452, 2388, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.5.1.2", "1.1.2.5"}],
    Cell[72708, 2398, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.5.1.3", "1.1.2.5"}],
    Cell[73431, 2419, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.2.1", "1.1.2.5"}],
    Cell[73518, 2422, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.5.2.2", "1.1.2.5"}],
    Cell[73724, 2431, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.5.2.3", "1.1.2.5"}],
    Cell[75140, 2479, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.3.1", "1.1.2.5"}],
    Cell[75235, 2482, 316, 9, 70, "Usage",
      CellTags->{"1.1.2.5.3.2", "1.1.2.5"}],
    Cell[75554, 2493, 556, 14, 70, "Notes",
      CellTags->{"1.1.2.5.3.3", "1.1.2.5"}],
    Cell[76147, 2512, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.4.1", "1.1.2.5"}],
    Cell[76240, 2515, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.5.4.2", "1.1.2.5"}],
    Cell[76514, 2525, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.5.4.3", "1.1.2.5"}],
    Cell[77132, 2545, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.5.1", "1.1.2.5"}],
    Cell[77220, 2548, 269, 7, 70, "Usage",
      CellTags->{"1.1.2.5.5.2", "1.1.2.5"}],
    Cell[77492, 2557, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.5.5.3", "1.1.2.5"}],
    Cell[77786, 2568, 94, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.6.1", "1.1.2.5"}],
    Cell[77883, 2571, 292, 9, 70, "Usage",
      CellTags->{"1.1.2.5.6.2", "1.1.2.5"}],
    Cell[78178, 2582, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.5.6.3", "1.1.2.5"}]},
  "1.1.2.5.2"->{
    Cell[71980, 2371, 359, 10, 70, "Text",
      CellTags->{"1.1.2.5.2", "1.1.2.5"}]},
  "1.1.2.5.1.1"->{
    Cell[72364, 2385, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.1.1", "1.1.2.5"}]},
  "1.1.2.5.1.2"->{
    Cell[72452, 2388, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.5.1.2", "1.1.2.5"}]},
  "1.1.2.5.1.3"->{
    Cell[72708, 2398, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.5.1.3", "1.1.2.5"}]},
  "1.1.2.5.2.1"->{
    Cell[73431, 2419, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.2.1", "1.1.2.5"}]},
  "1.1.2.5.2.2"->{
    Cell[73518, 2422, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.5.2.2", "1.1.2.5"}]},
  "1.1.2.5.2.3"->{
    Cell[73724, 2431, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.5.2.3", "1.1.2.5"}]},
  "1.1.2.5.3.1"->{
    Cell[75140, 2479, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.3.1", "1.1.2.5"}]},
  "1.1.2.5.3.2"->{
    Cell[75235, 2482, 316, 9, 70, "Usage",
      CellTags->{"1.1.2.5.3.2", "1.1.2.5"}]},
  "1.1.2.5.3.3"->{
    Cell[75554, 2493, 556, 14, 70, "Notes",
      CellTags->{"1.1.2.5.3.3", "1.1.2.5"}]},
  "1.1.2.5.4.1"->{
    Cell[76147, 2512, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.4.1", "1.1.2.5"}]},
  "1.1.2.5.4.2"->{
    Cell[76240, 2515, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.5.4.2", "1.1.2.5"}]},
  "1.1.2.5.4.3"->{
    Cell[76514, 2525, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.5.4.3", "1.1.2.5"}]},
  "1.1.2.5.5.1"->{
    Cell[77132, 2545, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.5.1", "1.1.2.5"}]},
  "1.1.2.5.5.2"->{
    Cell[77220, 2548, 269, 7, 70, "Usage",
      CellTags->{"1.1.2.5.5.2", "1.1.2.5"}]},
  "1.1.2.5.5.3"->{
    Cell[77492, 2557, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.5.5.3", "1.1.2.5"}]},
  "1.1.2.5.6.1"->{
    Cell[77786, 2568, 94, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.5.6.1", "1.1.2.5"}]},
  "1.1.2.5.6.2"->{
    Cell[77883, 2571, 292, 9, 70, "Usage",
      CellTags->{"1.1.2.5.6.2", "1.1.2.5"}]},
  "1.1.2.5.6.3"->{
    Cell[78178, 2582, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.5.6.3", "1.1.2.5"}]},
  "1.1.2.6.1"->{
    Cell[78829, 2599, 135, 2, 24, "GroupObjectName",
      CellTags->{"1.1.2.6.1", "1.1.2.6"}]},
  "1.1.2.6"->{
    Cell[78829, 2599, 135, 2, 24, "GroupObjectName",
      CellTags->{"1.1.2.6.1", "1.1.2.6"}],
    Cell[78967, 2603, 376, 12, 70, "Text",
      CellTags->{"1.1.2.6.2", "1.1.2.6"}],
    Cell[79368, 2619, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.1.1", "1.1.2.6"}],
    Cell[79456, 2622, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.6.1.2", "1.1.2.6"}],
    Cell[79712, 2632, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.6.1.3", "1.1.2.6"}],
    Cell[80435, 2653, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.2.1", "1.1.2.6"}],
    Cell[80522, 2656, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.6.2.2", "1.1.2.6"}],
    Cell[80728, 2665, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.6.2.3", "1.1.2.6"}],
    Cell[82144, 2713, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.3.1", "1.1.2.6"}],
    Cell[82239, 2716, 316, 9, 70, "Usage",
      CellTags->{"1.1.2.6.3.2", "1.1.2.6"}],
    Cell[82558, 2727, 556, 14, 70, "Notes",
      CellTags->{"1.1.2.6.3.3", "1.1.2.6"}],
    Cell[83151, 2746, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.4.1", "1.1.2.6"}],
    Cell[83244, 2749, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.6.4.2", "1.1.2.6"}],
    Cell[83518, 2759, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.6.4.3", "1.1.2.6"}],
    Cell[84136, 2779, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.5.1", "1.1.2.6"}],
    Cell[84224, 2782, 269, 7, 70, "Usage",
      CellTags->{"1.1.2.6.5.2", "1.1.2.6"}],
    Cell[84496, 2791, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.6.5.3", "1.1.2.6"}],
    Cell[84790, 2802, 94, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.6.1", "1.1.2.6"}],
    Cell[84887, 2805, 292, 9, 70, "Usage",
      CellTags->{"1.1.2.6.6.2", "1.1.2.6"}],
    Cell[85182, 2816, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.6.6.3", "1.1.2.6"}]},
  "1.1.2.6.2"->{
    Cell[78967, 2603, 376, 12, 70, "Text",
      CellTags->{"1.1.2.6.2", "1.1.2.6"}]},
  "1.1.2.6.1.1"->{
    Cell[79368, 2619, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.1.1", "1.1.2.6"}]},
  "1.1.2.6.1.2"->{
    Cell[79456, 2622, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.6.1.2", "1.1.2.6"}]},
  "1.1.2.6.1.3"->{
    Cell[79712, 2632, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.6.1.3", "1.1.2.6"}]},
  "1.1.2.6.2.1"->{
    Cell[80435, 2653, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.2.1", "1.1.2.6"}]},
  "1.1.2.6.2.2"->{
    Cell[80522, 2656, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.6.2.2", "1.1.2.6"}]},
  "1.1.2.6.2.3"->{
    Cell[80728, 2665, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.6.2.3", "1.1.2.6"}]},
  "1.1.2.6.3.1"->{
    Cell[82144, 2713, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.3.1", "1.1.2.6"}]},
  "1.1.2.6.3.2"->{
    Cell[82239, 2716, 316, 9, 70, "Usage",
      CellTags->{"1.1.2.6.3.2", "1.1.2.6"}]},
  "1.1.2.6.3.3"->{
    Cell[82558, 2727, 556, 14, 70, "Notes",
      CellTags->{"1.1.2.6.3.3", "1.1.2.6"}]},
  "1.1.2.6.4.1"->{
    Cell[83151, 2746, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.4.1", "1.1.2.6"}]},
  "1.1.2.6.4.2"->{
    Cell[83244, 2749, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.6.4.2", "1.1.2.6"}]},
  "1.1.2.6.4.3"->{
    Cell[83518, 2759, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.6.4.3", "1.1.2.6"}]},
  "1.1.2.6.5.1"->{
    Cell[84136, 2779, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.5.1", "1.1.2.6"}]},
  "1.1.2.6.5.2"->{
    Cell[84224, 2782, 269, 7, 70, "Usage",
      CellTags->{"1.1.2.6.5.2", "1.1.2.6"}]},
  "1.1.2.6.5.3"->{
    Cell[84496, 2791, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.6.5.3", "1.1.2.6"}]},
  "1.1.2.6.6.1"->{
    Cell[84790, 2802, 94, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.6.6.1", "1.1.2.6"}]},
  "1.1.2.6.6.2"->{
    Cell[84887, 2805, 292, 9, 70, "Usage",
      CellTags->{"1.1.2.6.6.2", "1.1.2.6"}]},
  "1.1.2.6.6.3"->{
    Cell[85182, 2816, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.6.6.3", "1.1.2.6"}]},
  "1.1.2.7.1"->{
    Cell[85833, 2833, 137, 2, 24, "GroupObjectName",
      CellTags->{"1.1.2.7.1", "1.1.2.7"}]},
  "1.1.2.7"->{
    Cell[85833, 2833, 137, 2, 24, "GroupObjectName",
      CellTags->{"1.1.2.7.1", "1.1.2.7"}],
    Cell[85973, 2837, 331, 9, 70, "Text",
      CellTags->{"1.1.2.7.2", "1.1.2.7"}],
    Cell[86329, 2850, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.1.1", "1.1.2.7"}],
    Cell[86417, 2853, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.7.1.2", "1.1.2.7"}],
    Cell[86673, 2863, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.7.1.3", "1.1.2.7"}],
    Cell[87396, 2884, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.2.1", "1.1.2.7"}],
    Cell[87483, 2887, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.7.2.2", "1.1.2.7"}],
    Cell[87689, 2896, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.7.2.3", "1.1.2.7"}],
    Cell[89105, 2944, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.3.1", "1.1.2.7"}],
    Cell[89200, 2947, 316, 9, 70, "Usage",
      CellTags->{"1.1.2.7.3.2", "1.1.2.7"}],
    Cell[89519, 2958, 556, 14, 70, "Notes",
      CellTags->{"1.1.2.7.3.3", "1.1.2.7"}],
    Cell[90112, 2977, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.4.1", "1.1.2.7"}],
    Cell[90205, 2980, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.7.4.2", "1.1.2.7"}],
    Cell[90479, 2990, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.7.4.3", "1.1.2.7"}],
    Cell[91097, 3010, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.5.1", "1.1.2.7"}],
    Cell[91185, 3013, 269, 7, 70, "Usage",
      CellTags->{"1.1.2.7.5.2", "1.1.2.7"}],
    Cell[91457, 3022, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.7.5.3", "1.1.2.7"}],
    Cell[91751, 3033, 94, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.6.1", "1.1.2.7"}],
    Cell[91848, 3036, 292, 9, 70, "Usage",
      CellTags->{"1.1.2.7.6.2", "1.1.2.7"}],
    Cell[92143, 3047, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.7.6.3", "1.1.2.7"}]},
  "1.1.2.7.2"->{
    Cell[85973, 2837, 331, 9, 70, "Text",
      CellTags->{"1.1.2.7.2", "1.1.2.7"}]},
  "1.1.2.7.1.1"->{
    Cell[86329, 2850, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.1.1", "1.1.2.7"}]},
  "1.1.2.7.1.2"->{
    Cell[86417, 2853, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.7.1.2", "1.1.2.7"}]},
  "1.1.2.7.1.3"->{
    Cell[86673, 2863, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.7.1.3", "1.1.2.7"}]},
  "1.1.2.7.2.1"->{
    Cell[87396, 2884, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.2.1", "1.1.2.7"}]},
  "1.1.2.7.2.2"->{
    Cell[87483, 2887, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.7.2.2", "1.1.2.7"}]},
  "1.1.2.7.2.3"->{
    Cell[87689, 2896, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.7.2.3", "1.1.2.7"}]},
  "1.1.2.7.3.1"->{
    Cell[89105, 2944, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.3.1", "1.1.2.7"}]},
  "1.1.2.7.3.2"->{
    Cell[89200, 2947, 316, 9, 70, "Usage",
      CellTags->{"1.1.2.7.3.2", "1.1.2.7"}]},
  "1.1.2.7.3.3"->{
    Cell[89519, 2958, 556, 14, 70, "Notes",
      CellTags->{"1.1.2.7.3.3", "1.1.2.7"}]},
  "1.1.2.7.4.1"->{
    Cell[90112, 2977, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.4.1", "1.1.2.7"}]},
  "1.1.2.7.4.2"->{
    Cell[90205, 2980, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.7.4.2", "1.1.2.7"}]},
  "1.1.2.7.4.3"->{
    Cell[90479, 2990, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.7.4.3", "1.1.2.7"}]},
  "1.1.2.7.5.1"->{
    Cell[91097, 3010, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.5.1", "1.1.2.7"}]},
  "1.1.2.7.5.2"->{
    Cell[91185, 3013, 269, 7, 70, "Usage",
      CellTags->{"1.1.2.7.5.2", "1.1.2.7"}]},
  "1.1.2.7.5.3"->{
    Cell[91457, 3022, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.7.5.3", "1.1.2.7"}]},
  "1.1.2.7.6.1"->{
    Cell[91751, 3033, 94, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.7.6.1", "1.1.2.7"}]},
  "1.1.2.7.6.2"->{
    Cell[91848, 3036, 292, 9, 70, "Usage",
      CellTags->{"1.1.2.7.6.2", "1.1.2.7"}]},
  "1.1.2.7.6.3"->{
    Cell[92143, 3047, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.7.6.3", "1.1.2.7"}]},
  "1.1.2.8.1"->{
    Cell[92794, 3064, 135, 2, 24, "GroupObjectName",
      CellTags->{"1.1.2.8.1", "1.1.2.8"}]},
  "1.1.2.8"->{
    Cell[92794, 3064, 135, 2, 24, "GroupObjectName",
      CellTags->{"1.1.2.8.1", "1.1.2.8"}],
    Cell[92932, 3068, 415, 12, 70, "Text",
      CellTags->{"1.1.2.8.2", "1.1.2.8"}],
    Cell[93372, 3084, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.1.1", "1.1.2.8"}],
    Cell[93460, 3087, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.8.1.2", "1.1.2.8"}],
    Cell[93716, 3097, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.8.1.3", "1.1.2.8"}],
    Cell[94439, 3118, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.2.1", "1.1.2.8"}],
    Cell[94526, 3121, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.8.2.2", "1.1.2.8"}],
    Cell[94732, 3130, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.8.2.3", "1.1.2.8"}],
    Cell[96148, 3178, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.3.1", "1.1.2.8"}],
    Cell[96243, 3181, 316, 9, 70, "Usage",
      CellTags->{"1.1.2.8.3.2", "1.1.2.8"}],
    Cell[96562, 3192, 556, 14, 70, "Notes",
      CellTags->{"1.1.2.8.3.3", "1.1.2.8"}],
    Cell[97155, 3211, 91, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.4.1", "1.1.2.8"}],
    Cell[97249, 3214, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.8.4.2", "1.1.2.8"}],
    Cell[97523, 3224, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.8.4.3", "1.1.2.8"}],
    Cell[98141, 3244, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.5.1", "1.1.2.8"}],
    Cell[98229, 3247, 269, 7, 70, "Usage",
      CellTags->{"1.1.2.8.5.2", "1.1.2.8"}],
    Cell[98501, 3256, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.8.5.3", "1.1.2.8"}],
    Cell[98795, 3267, 94, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.6.1", "1.1.2.8"}],
    Cell[98892, 3270, 292, 9, 70, "Usage",
      CellTags->{"1.1.2.8.6.2", "1.1.2.8"}],
    Cell[99187, 3281, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.8.6.3", "1.1.2.8"}]},
  "1.1.2.8.2"->{
    Cell[92932, 3068, 415, 12, 70, "Text",
      CellTags->{"1.1.2.8.2", "1.1.2.8"}]},
  "1.1.2.8.1.1"->{
    Cell[93372, 3084, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.1.1", "1.1.2.8"}]},
  "1.1.2.8.1.2"->{
    Cell[93460, 3087, 253, 8, 70, "Usage",
      CellTags->{"1.1.2.8.1.2", "1.1.2.8"}]},
  "1.1.2.8.1.3"->{
    Cell[93716, 3097, 686, 16, 70, "Notes",
      CellTags->{"1.1.2.8.1.3", "1.1.2.8"}]},
  "1.1.2.8.2.1"->{
    Cell[94439, 3118, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.2.1", "1.1.2.8"}]},
  "1.1.2.8.2.2"->{
    Cell[94526, 3121, 203, 7, 70, "Usage",
      CellTags->{"1.1.2.8.2.2", "1.1.2.8"}]},
  "1.1.2.8.2.3"->{
    Cell[94732, 3130, 1379, 43, 70, "Notes",
      CellTags->{"1.1.2.8.2.3", "1.1.2.8"}]},
  "1.1.2.8.3.1"->{
    Cell[96148, 3178, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.3.1", "1.1.2.8"}]},
  "1.1.2.8.3.2"->{
    Cell[96243, 3181, 316, 9, 70, "Usage",
      CellTags->{"1.1.2.8.3.2", "1.1.2.8"}]},
  "1.1.2.8.3.3"->{
    Cell[96562, 3192, 556, 14, 70, "Notes",
      CellTags->{"1.1.2.8.3.3", "1.1.2.8"}]},
  "1.1.2.8.4.1"->{
    Cell[97155, 3211, 91, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.4.1", "1.1.2.8"}]},
  "1.1.2.8.4.2"->{
    Cell[97249, 3214, 271, 8, 70, "Usage",
      CellTags->{"1.1.2.8.4.2", "1.1.2.8"}]},
  "1.1.2.8.4.3"->{
    Cell[97523, 3224, 581, 15, 70, "Notes",
      CellTags->{"1.1.2.8.4.3", "1.1.2.8"}]},
  "1.1.2.8.5.1"->{
    Cell[98141, 3244, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.5.1", "1.1.2.8"}]},
  "1.1.2.8.5.2"->{
    Cell[98229, 3247, 269, 7, 70, "Usage",
      CellTags->{"1.1.2.8.5.2", "1.1.2.8"}]},
  "1.1.2.8.5.3"->{
    Cell[98501, 3256, 257, 6, 70, "Notes",
      CellTags->{"1.1.2.8.5.3", "1.1.2.8"}]},
  "1.1.2.8.6.1"->{
    Cell[98795, 3267, 94, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.2.8.6.1", "1.1.2.8"}]},
  "1.1.2.8.6.2"->{
    Cell[98892, 3270, 292, 9, 70, "Usage",
      CellTags->{"1.1.2.8.6.2", "1.1.2.8"}]},
  "1.1.2.8.6.3"->{
    Cell[99187, 3281, 602, 11, 70, "Notes",
      CellTags->{"1.1.2.8.6.3", "1.1.2.8"}]},
  "1.1.3.1.1"->{
    Cell[99923, 3303, 70, 1, 70, "ObjectName",
      CellTags->{"1.1.3.1.1", "1.1.3.1"}]},
  "1.1.3.1"->{
    Cell[99923, 3303, 70, 1, 70, "ObjectName",
      CellTags->{"1.1.3.1.1", "1.1.3.1"}],
    Cell[99996, 3306, 290, 9, 70, "Usage",
      CellTags->{"1.1.3.1.2", "1.1.3.1"}],
    Cell[100289, 3317, 1323, 31, 70, "Notes",
      CellTags->{"1.1.3.1.3", "1.1.3.1"}]},
  "1.1.3.1.2"->{
    Cell[99996, 3306, 290, 9, 70, "Usage",
      CellTags->{"1.1.3.1.2", "1.1.3.1"}]},
  "1.1.3.1.3"->{
    Cell[100289, 3317, 1323, 31, 70, "Notes",
      CellTags->{"1.1.3.1.3", "1.1.3.1"}]},
  "1.1.3.2.1"->{
    Cell[101649, 3353, 91, 1, 70, "ObjectName",
      CellTags->{"1.1.3.2.1", "1.1.3.2"}]},
  "1.1.3.2"->{
    Cell[101649, 3353, 91, 1, 70, "ObjectName",
      CellTags->{"1.1.3.2.1", "1.1.3.2"}],
    Cell[101743, 3356, 327, 9, 70, "Usage",
      CellTags->{"1.1.3.2.2", "1.1.3.2"}],
    Cell[102073, 3367, 747, 18, 70, "Notes",
      CellTags->{"1.1.3.2.3", "1.1.3.2"}]},
  "1.1.3.2.2"->{
    Cell[101743, 3356, 327, 9, 70, "Usage",
      CellTags->{"1.1.3.2.2", "1.1.3.2"}]},
  "1.1.3.2.3"->{
    Cell[102073, 3367, 747, 18, 70, "Notes",
      CellTags->{"1.1.3.2.3", "1.1.3.2"}]},
  "1.1.4.1.1"->{
    Cell[102941, 3395, 74, 1, 50, "ObjectName",
      CellTags->{"1.1.4.1.1", "1.1.4.1"}]},
  "1.1.4.1"->{
    Cell[102941, 3395, 74, 1, 50, "ObjectName",
      CellTags->{"1.1.4.1.1", "1.1.4.1"}],
    Cell[103018, 3398, 297, 9, 60, "Usage",
      CellTags->{"1.1.4.1.2", "1.1.4.1"}],
    Cell[103318, 3409, 423, 12, 58, "Notes",
      CellTags->{"1.1.4.1.3", "1.1.4.1"}]},
  "1.1.4.1.2"->{
    Cell[103018, 3398, 297, 9, 60, "Usage",
      CellTags->{"1.1.4.1.2", "1.1.4.1"}]},
  "1.1.4.1.3"->{
    Cell[103318, 3409, 423, 12, 58, "Notes",
      CellTags->{"1.1.4.1.3", "1.1.4.1"}]},
  "1.1.4.4.1"->{
    Cell[103778, 3426, 80, 1, 50, "ObjectName",
      CellTags->{"1.1.4.4.1", "1.1.4.4"}],
    Cell[107949, 3573, 76, 1, 54, "ObjectName",
      CellTags->{"1.1.4.4.1", "1.1.4.5"}]},
  "1.1.4.4"->{
    Cell[103778, 3426, 80, 1, 50, "ObjectName",
      CellTags->{"1.1.4.4.1", "1.1.4.4"}],
    Cell[103861, 3429, 374, 12, 70, "Usage",
      CellTags->{"1.1.4.4.2", "1.1.4.4"}],
    Cell[104238, 3443, 996, 25, 70, "Notes",
      CellTags->{"1.1.4.4.3", "1.1.4.4"}],
    Cell[105237, 3470, 436, 13, 70, "Notes",
      CellTags->{"1.1.4.4.4", "1.1.4.4"}]},
  "1.1.4.4.2"->{
    Cell[103861, 3429, 374, 12, 70, "Usage",
      CellTags->{"1.1.4.4.2", "1.1.4.4"}],
    Cell[108028, 3576, 332, 9, 70, "Usage",
      CellTags->{"1.1.4.4.2", "1.1.4.5"}]},
  "1.1.4.4.3"->{
    Cell[104238, 3443, 996, 25, 70, "Notes",
      CellTags->{"1.1.4.4.3", "1.1.4.4"}],
    Cell[108363, 3587, 452, 9, 70, "Notes",
      CellTags->{"1.1.4.4.3", "1.1.4.5"}]},
  "1.1.4.4.4"->{
    Cell[105237, 3470, 436, 13, 70, "Notes",
      CellTags->{"1.1.4.4.4", "1.1.4.4"}]},
  "1.1.4.2.1"->{
    Cell[105710, 3488, 77, 1, 54, "ObjectName",
      CellTags->{"1.1.4.2.1", "1.1.4.2"}]},
  "1.1.4.2"->{
    Cell[105710, 3488, 77, 1, 54, "ObjectName",
      CellTags->{"1.1.4.2.1", "1.1.4.2"}],
    Cell[105790, 3491, 294, 9, 70, "Usage",
      CellTags->{"1.1.4.2.2", "1.1.4.2"}],
    Cell[106087, 3502, 1263, 45, 70, "Notes",
      CellTags->{"1.1.4.2.3", "1.1.4.2"}]},
  "1.1.4.2.2"->{
    Cell[105790, 3491, 294, 9, 70, "Usage",
      CellTags->{"1.1.4.2.2", "1.1.4.2"}]},
  "1.1.4.2.3"->{
    Cell[106087, 3502, 1263, 45, 70, "Notes",
      CellTags->{"1.1.4.2.3", "1.1.4.2"}]},
  "1.1.4.3.1"->{
    Cell[107387, 3552, 79, 1, 54, "ObjectName",
      CellTags->{"1.1.4.3.1", "1.1.4.3"}]},
  "1.1.4.3"->{
    Cell[107387, 3552, 79, 1, 54, "ObjectName",
      CellTags->{"1.1.4.3.1", "1.1.4.3"}],
    Cell[107469, 3555, 272, 7, 70, "Usage",
      CellTags->{"1.1.4.3.2", "1.1.4.3"}],
    Cell[107744, 3564, 168, 4, 70, "Notes",
      CellTags->{"1.1.4.3.3", "1.1.4.3"}]},
  "1.1.4.3.2"->{
    Cell[107469, 3555, 272, 7, 70, "Usage",
      CellTags->{"1.1.4.3.2", "1.1.4.3"}]},
  "1.1.4.3.3"->{
    Cell[107744, 3564, 168, 4, 70, "Notes",
      CellTags->{"1.1.4.3.3", "1.1.4.3"}]},
  "1.1.4.5"->{
    Cell[107949, 3573, 76, 1, 54, "ObjectName",
      CellTags->{"1.1.4.4.1", "1.1.4.5"}],
    Cell[108028, 3576, 332, 9, 70, "Usage",
      CellTags->{"1.1.4.4.2", "1.1.4.5"}],
    Cell[108363, 3587, 452, 9, 70, "Notes",
      CellTags->{"1.1.4.4.3", "1.1.4.5"}],
    Cell[108818, 3598, 905, 22, 70, "Notes",
      CellTags->"1.1.4.5"]},
  "1.1.5.1.1"->{
    Cell[109837, 3630, 75, 1, 38, "ObjectName",
      CellTags->{"1.1.5.1.1", "1.1.5.1"}]},
  "1.1.5.1"->{
    Cell[109837, 3630, 75, 1, 38, "ObjectName",
      CellTags->{"1.1.5.1.1", "1.1.5.1"}],
    Cell[109915, 3633, 255, 7, 70, "Usage",
      CellTags->{"1.1.5.1.2", "1.1.5.1"}],
    Cell[110173, 3642, 598, 10, 70, "Notes",
      CellTags->{"1.1.5.1.3", "1.1.5.1"}]},
  "1.1.5.1.2"->{
    Cell[109915, 3633, 255, 7, 70, "Usage",
      CellTags->{"1.1.5.1.2", "1.1.5.1"}]},
  "1.1.5.1.3"->{
    Cell[110173, 3642, 598, 10, 70, "Notes",
      CellTags->{"1.1.5.1.3", "1.1.5.1"}]},
  "1.1.5.2.1"->{
    Cell[110808, 3657, 74, 1, 42, "ObjectName",
      CellTags->{"1.1.5.2.1", "1.1.5.2"}]},
  "1.1.5.2"->{
    Cell[110808, 3657, 74, 1, 42, "ObjectName",
      CellTags->{"1.1.5.2.1", "1.1.5.2"}],
    Cell[110885, 3660, 355, 11, 48, "Usage",
      CellTags->{"1.1.5.2.2", "1.1.5.2"}],
    Cell[111243, 3673, 1188, 29, 132, "Notes",
      CellTags->{"1.1.5.2.3", "1.1.5.2"}]},
  "1.1.5.2.2"->{
    Cell[110885, 3660, 355, 11, 48, "Usage",
      CellTags->{"1.1.5.2.2", "1.1.5.2"}]},
  "1.1.5.2.3"->{
    Cell[111243, 3673, 1188, 29, 132, "Notes",
      CellTags->{"1.1.5.2.3", "1.1.5.2"}]},
  "1.1.5.3.1"->{
    Cell[112468, 3707, 77, 1, 38, "ObjectName",
      CellTags->{"1.1.5.3.1", "1.1.5.3"}]},
  "1.1.5.3"->{
    Cell[112468, 3707, 77, 1, 38, "ObjectName",
      CellTags->{"1.1.5.3.1", "1.1.5.3"}],
    Cell[112548, 3710, 316, 8, 70, "Usage",
      CellTags->{"1.1.5.3.2", "1.1.5.3"}],
    Cell[112867, 3720, 848, 28, 70, "Notes",
      CellTags->{"1.1.5.3.3", "1.1.5.3"}]},
  "1.1.5.3.2"->{
    Cell[112548, 3710, 316, 8, 70, "Usage",
      CellTags->{"1.1.5.3.2", "1.1.5.3"}]},
  "1.1.5.3.3"->{
    Cell[112867, 3720, 848, 28, 70, "Notes",
      CellTags->{"1.1.5.3.3", "1.1.5.3"}]},
  "1.1.5.4.1"->{
    Cell[113752, 3753, 82, 1, 42, "ObjectName",
      CellTags->{"1.1.5.4.1", "1.1.5.4"}]},
  "1.1.5.4"->{
    Cell[113752, 3753, 82, 1, 42, "ObjectName",
      CellTags->{"1.1.5.4.1", "1.1.5.4"}],
    Cell[113837, 3756, 305, 9, 70, "Usage",
      CellTags->{"1.1.5.4.2", "1.1.5.4"}],
    Cell[114145, 3767, 738, 16, 70, "Notes",
      CellTags->{"1.1.5.4.3", "1.1.5.4"}]},
  "1.1.5.4.2"->{
    Cell[113837, 3756, 305, 9, 70, "Usage",
      CellTags->{"1.1.5.4.2", "1.1.5.4"}]},
  "1.1.5.4.3"->{
    Cell[114145, 3767, 738, 16, 70, "Notes",
      CellTags->{"1.1.5.4.3", "1.1.5.4"}]},
  "1.1.5.5.1"->{
    Cell[114920, 3788, 79, 1, 42, "ObjectName",
      CellTags->{"1.1.5.5.1", "1.1.5.5"}]},
  "1.1.5.5"->{
    Cell[114920, 3788, 79, 1, 42, "ObjectName",
      CellTags->{"1.1.5.5.1", "1.1.5.5"}],
    Cell[115002, 3791, 258, 7, 70, "Usage",
      CellTags->{"1.1.5.5.2", "1.1.5.5"}],
    Cell[115263, 3800, 610, 12, 70, "Notes",
      CellTags->{"1.1.5.5.3", "1.1.5.5"}]},
  "1.1.5.5.2"->{
    Cell[115002, 3791, 258, 7, 70, "Usage",
      CellTags->{"1.1.5.5.2", "1.1.5.5"}]},
  "1.1.5.5.3"->{
    Cell[115263, 3800, 610, 12, 70, "Notes",
      CellTags->{"1.1.5.5.3", "1.1.5.5"}]},
  "1.1.6.1.1"->{
    Cell[115989, 3822, 127, 2, 34, "GroupObjectName",
      CellTags->{"1.1.6.1.1", "1.1.6.1"}]},
  "1.1.6.1"->{
    Cell[115989, 3822, 127, 2, 34, "GroupObjectName",
      CellTags->{"1.1.6.1.1", "1.1.6.1"}],
    Cell[116119, 3826, 439, 12, 40, "Text",
      CellTags->{"1.1.6.1.2", "1.1.6.1"}],
    Cell[116583, 3842, 85, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.1.1", "1.1.6.1"}],
    Cell[116671, 3845, 268, 7, 70, "Usage",
      CellTags->{"1.1.6.1.1.2", "1.1.6.1"}],
    Cell[116942, 3854, 1546, 40, 70, "Notes",
      CellTags->{"1.1.6.1.1.3", "1.1.6.1"}],
    Cell[118525, 3899, 88, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.2.1", "1.1.6.1"}],
    Cell[118616, 3902, 299, 9, 70, "Usage",
      CellTags->{"1.1.6.1.2.2", "1.1.6.1"}],
    Cell[118918, 3913, 871, 21, 70, "Notes",
      CellTags->{"1.1.6.1.2.3", "1.1.6.1"}],
    Cell[119826, 3939, 85, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.3.1", "1.1.6.1"}],
    Cell[119914, 3942, 385, 13, 48, "Usage",
      CellTags->{"1.1.6.1.3.2", "1.1.6.1"}],
    Cell[120302, 3957, 894, 30, 68, "Notes",
      CellTags->{"1.1.6.1.3.3", "1.1.6.1"}],
    Cell[121233, 3992, 85, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.4.1", "1.1.6.1"}],
    Cell[121321, 3995, 287, 7, 70, "Usage",
      CellTags->{"1.1.6.1.4.2", "1.1.6.1"}],
    Cell[121611, 4004, 513, 14, 70, "Notes",
      CellTags->{"1.1.6.1.4.3", "1.1.6.1"}],
    Cell[122161, 4023, 88, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.5.1", "1.1.6.1"}],
    Cell[122252, 4026, 341, 12, 70, "Usage",
      CellTags->{"1.1.6.1.5.2", "1.1.6.1"}],
    Cell[122596, 4040, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.1.5.3", "1.1.6.1"}]},
  "1.1.6.1.2"->{
    Cell[116119, 3826, 439, 12, 40, "Text",
      CellTags->{"1.1.6.1.2", "1.1.6.1"}]},
  "1.1.6.1.1.1"->{
    Cell[116583, 3842, 85, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.1.1", "1.1.6.1"}]},
  "1.1.6.1.1.2"->{
    Cell[116671, 3845, 268, 7, 70, "Usage",
      CellTags->{"1.1.6.1.1.2", "1.1.6.1"}]},
  "1.1.6.1.1.3"->{
    Cell[116942, 3854, 1546, 40, 70, "Notes",
      CellTags->{"1.1.6.1.1.3", "1.1.6.1"}]},
  "1.1.6.1.2.1"->{
    Cell[118525, 3899, 88, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.2.1", "1.1.6.1"}]},
  "1.1.6.1.2.2"->{
    Cell[118616, 3902, 299, 9, 70, "Usage",
      CellTags->{"1.1.6.1.2.2", "1.1.6.1"}]},
  "1.1.6.1.2.3"->{
    Cell[118918, 3913, 871, 21, 70, "Notes",
      CellTags->{"1.1.6.1.2.3", "1.1.6.1"}]},
  "1.1.6.1.3.1"->{
    Cell[119826, 3939, 85, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.3.1", "1.1.6.1"}]},
  "1.1.6.1.3.2"->{
    Cell[119914, 3942, 385, 13, 48, "Usage",
      CellTags->{"1.1.6.1.3.2", "1.1.6.1"}]},
  "1.1.6.1.3.3"->{
    Cell[120302, 3957, 894, 30, 68, "Notes",
      CellTags->{"1.1.6.1.3.3", "1.1.6.1"}]},
  "1.1.6.1.4.1"->{
    Cell[121233, 3992, 85, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.4.1", "1.1.6.1"}]},
  "1.1.6.1.4.2"->{
    Cell[121321, 3995, 287, 7, 70, "Usage",
      CellTags->{"1.1.6.1.4.2", "1.1.6.1"}]},
  "1.1.6.1.4.3"->{
    Cell[121611, 4004, 513, 14, 70, "Notes",
      CellTags->{"1.1.6.1.4.3", "1.1.6.1"}]},
  "1.1.6.1.5.1"->{
    Cell[122161, 4023, 88, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.1.5.1", "1.1.6.1"}]},
  "1.1.6.1.5.2"->{
    Cell[122252, 4026, 341, 12, 70, "Usage",
      CellTags->{"1.1.6.1.5.2", "1.1.6.1"}]},
  "1.1.6.1.5.3"->{
    Cell[122596, 4040, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.1.5.3", "1.1.6.1"}]},
  "1.1.6.2.1"->{
    Cell[124765, 4118, 135, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.2.1", "1.1.6.2"}]},
  "1.1.6.2"->{
    Cell[124765, 4118, 135, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.2.1", "1.1.6.2"}],
    Cell[124903, 4122, 471, 12, 70, "Text",
      CellTags->{"1.1.6.2.2", "1.1.6.2"}],
    Cell[125399, 4138, 83, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.2.1.1", "1.1.6.2"}],
    Cell[125485, 4141, 385, 11, 70, "Usage",
      CellTags->{"1.1.6.2.1.2", "1.1.6.2"}],
    Cell[125873, 4154, 657, 11, 70, "Notes",
      CellTags->{"1.1.6.2.1.3", "1.1.6.2"}],
    Cell[126567, 4170, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.2.2.1", "1.1.6.2"}],
    Cell[126658, 4173, 357, 13, 70, "Usage",
      CellTags->{"1.1.6.2.2.2", "1.1.6.2"}],
    Cell[127018, 4188, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.2.2.3", "1.1.6.2"}]},
  "1.1.6.2.2"->{
    Cell[124903, 4122, 471, 12, 70, "Text",
      CellTags->{"1.1.6.2.2", "1.1.6.2"}]},
  "1.1.6.2.1.1"->{
    Cell[125399, 4138, 83, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.2.1.1", "1.1.6.2"}]},
  "1.1.6.2.1.2"->{
    Cell[125485, 4141, 385, 11, 70, "Usage",
      CellTags->{"1.1.6.2.1.2", "1.1.6.2"}]},
  "1.1.6.2.1.3"->{
    Cell[125873, 4154, 657, 11, 70, "Notes",
      CellTags->{"1.1.6.2.1.3", "1.1.6.2"}]},
  "1.1.6.2.2.1"->{
    Cell[126567, 4170, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.2.2.1", "1.1.6.2"}],
    Cell[184392, 6077, 89, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.2.2.1", "1.1.6.13"}]},
  "1.1.6.2.2.2"->{
    Cell[126658, 4173, 357, 13, 70, "Usage",
      CellTags->{"1.1.6.2.2.2", "1.1.6.2"}],
    Cell[184484, 6080, 340, 11, 70, "Usage",
      CellTags->{"1.1.6.2.2.2", "1.1.6.13"}]},
  "1.1.6.2.2.3"->{
    Cell[127018, 4188, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.2.2.3", "1.1.6.2"}],
    Cell[184827, 6093, 2121, 72, 70, "Notes",
      CellTags->{"1.1.6.2.2.3", "1.1.6.13"}]},
  "1.1.6.3.1"->{
    Cell[129187, 4266, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.3.1", "1.1.6.3"}]},
  "1.1.6.3"->{
    Cell[129187, 4266, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.3.1", "1.1.6.3"}],
    Cell[129332, 4271, 490, 12, 70, "Text",
      CellTags->{"1.1.6.3.2", "1.1.6.3"}],
    Cell[129847, 4287, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.3.1.1", "1.1.6.3"}],
    Cell[129942, 4290, 348, 9, 70, "Usage",
      CellTags->{"1.1.6.3.1.2", "1.1.6.3"}],
    Cell[130293, 4301, 719, 23, 70, "Notes",
      CellTags->{"1.1.6.3.1.3", "1.1.6.3"}],
    Cell[131049, 4329, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.3.2.1", "1.1.6.3"}],
    Cell[131140, 4332, 337, 9, 70, "Usage",
      CellTags->{"1.1.6.3.2.2", "1.1.6.3"}],
    Cell[131480, 4343, 530, 12, 70, "Notes",
      CellTags->{"1.1.6.3.2.3", "1.1.6.3"}],
    Cell[132047, 4360, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.3.3.1", "1.1.6.3"}],
    Cell[132134, 4363, 362, 10, 70, "Usage",
      CellTags->{"1.1.6.3.3.2", "1.1.6.3"}],
    Cell[132499, 4375, 3517, 86, 70, "Notes",
      CellTags->{"1.1.6.3.3.3", "1.1.6.3"}],
    Cell[136053, 4466, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.3.4.1", "1.1.6.3"}],
    Cell[136144, 4469, 285, 8, 70, "Usage",
      CellTags->{"1.1.6.3.4.2", "1.1.6.3"}],
    Cell[136432, 4479, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.3.4.3", "1.1.6.3"}]},
  "1.1.6.3.2"->{
    Cell[129332, 4271, 490, 12, 70, "Text",
      CellTags->{"1.1.6.3.2", "1.1.6.3"}]},
  "1.1.6.3.1.1"->{
    Cell[129847, 4287, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.3.1.1", "1.1.6.3"}]},
  "1.1.6.3.1.2"->{
    Cell[129942, 4290, 348, 9, 70, "Usage",
      CellTags->{"1.1.6.3.1.2", "1.1.6.3"}]},
  "1.1.6.3.1.3"->{
    Cell[130293, 4301, 719, 23, 70, "Notes",
      CellTags->{"1.1.6.3.1.3", "1.1.6.3"}]},
  "1.1.6.3.2.1"->{
    Cell[131049, 4329, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.3.2.1", "1.1.6.3"}]},
  "1.1.6.3.2.2"->{
    Cell[131140, 4332, 337, 9, 70, "Usage",
      CellTags->{"1.1.6.3.2.2", "1.1.6.3"}]},
  "1.1.6.3.2.3"->{
    Cell[131480, 4343, 530, 12, 70, "Notes",
      CellTags->{"1.1.6.3.2.3", "1.1.6.3"}]},
  "1.1.6.3.3.1"->{
    Cell[132047, 4360, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.3.3.1", "1.1.6.3"}]},
  "1.1.6.3.3.2"->{
    Cell[132134, 4363, 362, 10, 70, "Usage",
      CellTags->{"1.1.6.3.3.2", "1.1.6.3"}]},
  "1.1.6.3.3.3"->{
    Cell[132499, 4375, 3517, 86, 70, "Notes",
      CellTags->{"1.1.6.3.3.3", "1.1.6.3"}]},
  "1.1.6.3.4.1"->{
    Cell[136053, 4466, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.3.4.1", "1.1.6.3"}]},
  "1.1.6.3.4.2"->{
    Cell[136144, 4469, 285, 8, 70, "Usage",
      CellTags->{"1.1.6.3.4.2", "1.1.6.3"}]},
  "1.1.6.3.4.3"->{
    Cell[136432, 4479, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.3.4.3", "1.1.6.3"}]},
  "1.1.6.4.1"->{
    Cell[138601, 4557, 136, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.4.1", "1.1.6.4"}]},
  "1.1.6.4"->{
    Cell[138601, 4557, 136, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.4.1", "1.1.6.4"}],
    Cell[138740, 4561, 461, 11, 70, "Text",
      CellTags->{"1.1.6.4.2", "1.1.6.4"}],
    Cell[139226, 4576, 81, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.4.1.1", "1.1.6.4"}],
    Cell[139310, 4579, 245, 7, 70, "Usage",
      CellTags->{"1.1.6.4.1.2", "1.1.6.4"}],
    Cell[139558, 4588, 2136, 79, 70, "Notes",
      CellTags->{"1.1.6.4.1.3", "1.1.6.4"}]},
  "1.1.6.4.2"->{
    Cell[138740, 4561, 461, 11, 70, "Text",
      CellTags->{"1.1.6.4.2", "1.1.6.4"}]},
  "1.1.6.4.1.1"->{
    Cell[139226, 4576, 81, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.4.1.1", "1.1.6.4"}]},
  "1.1.6.4.1.2"->{
    Cell[139310, 4579, 245, 7, 70, "Usage",
      CellTags->{"1.1.6.4.1.2", "1.1.6.4"}]},
  "1.1.6.4.1.3"->{
    Cell[139558, 4588, 2136, 79, 70, "Notes",
      CellTags->{"1.1.6.4.1.3", "1.1.6.4"}]},
  "1.1.6.5.1"->{
    Cell[141743, 4673, 135, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.5.1", "1.1.6.5"}]},
  "1.1.6.5"->{
    Cell[141743, 4673, 135, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.5.1", "1.1.6.5"}],
    Cell[141881, 4677, 512, 13, 56, "Text",
      CellTags->{"1.1.6.5.2", "1.1.6.5"}],
    Cell[142418, 4694, 80, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.1.1", "1.1.6.5"}],
    Cell[142501, 4697, 265, 7, 70, "Usage",
      CellTags->{"1.1.6.5.1.2", "1.1.6.5"}],
    Cell[142769, 4706, 734, 18, 70, "Notes",
      CellTags->{"1.1.6.5.1.3", "1.1.6.5"}],
    Cell[143540, 4729, 83, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.2.1", "1.1.6.5"}],
    Cell[143626, 4732, 271, 7, 70, "Usage",
      CellTags->{"1.1.6.5.2.2", "1.1.6.5"}],
    Cell[143900, 4741, 746, 18, 70, "Notes",
      CellTags->{"1.1.6.5.2.3", "1.1.6.5"}],
    Cell[144683, 4764, 87, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.3.1", "1.1.6.5"}],
    Cell[144773, 4767, 281, 8, 48, "Usage",
      CellTags->{"1.1.6.5.3.2", "1.1.6.5"}],
    Cell[145057, 4777, 1070, 23, 176, "Notes",
      CellTags->{"1.1.6.5.3.3", "1.1.6.5"}],
    Cell[146164, 4805, 91, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.4.1", "1.1.6.5"}],
    Cell[146258, 4808, 285, 9, 48, "Usage",
      CellTags->{"1.1.6.5.4.2", "1.1.6.5"}],
    Cell[146546, 4819, 1087, 23, 176, "Notes",
      CellTags->{"1.1.6.5.4.3", "1.1.6.5"}],
    Cell[147670, 4847, 85, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.5.1", "1.1.6.5"}],
    Cell[147758, 4850, 259, 8, 32, "Usage",
      CellTags->{"1.1.6.5.5.2", "1.1.6.5"}],
    Cell[148020, 4860, 1035, 23, 160, "Notes",
      CellTags->{"1.1.6.5.5.3", "1.1.6.5"}],
    Cell[149092, 4888, 80, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.6.1", "1.1.6.5"}],
    Cell[149175, 4891, 382, 13, 70, "Usage",
      CellTags->{"1.1.6.5.6.2", "1.1.6.5"}],
    Cell[149560, 4906, 910, 26, 70, "Notes",
      CellTags->{"1.1.6.5.6.3", "1.1.6.5"}],
    Cell[150507, 4937, 80, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.7.1", "1.1.6.5"}],
    Cell[150590, 4940, 280, 7, 70, "Usage",
      CellTags->{"1.1.6.5.7.2", "1.1.6.5"}],
    Cell[150873, 4949, 809, 20, 70, "Notes",
      CellTags->{"1.1.6.5.7.3", "1.1.6.5"}],
    Cell[151719, 4974, 88, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.8.1", "1.1.6.5"}],
    Cell[151810, 4977, 297, 7, 70, "Usage",
      CellTags->{"1.1.6.5.8.2", "1.1.6.5"}],
    Cell[152110, 4986, 828, 20, 70, "Notes",
      CellTags->{"1.1.6.5.8.3", "1.1.6.5"}],
    Cell[152975, 5011, 84, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.9.1", "1.1.6.5"}],
    Cell[153062, 5014, 277, 7, 70, "Usage",
      CellTags->{"1.1.6.5.9.2", "1.1.6.5"}],
    Cell[153342, 5023, 576, 14, 70, "Notes",
      CellTags->{"1.1.6.5.9.3", "1.1.6.5"}],
    Cell[153955, 5042, 93, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.10.1", "1.1.6.5"}],
    Cell[154051, 5045, 293, 7, 70, "Usage",
      CellTags->{"1.1.6.5.10.2", "1.1.6.5"}],
    Cell[154347, 5054, 558, 13, 70, "Notes",
      CellTags->{"1.1.6.5.10.3", "1.1.6.5"}]},
  "1.1.6.5.2"->{
    Cell[141881, 4677, 512, 13, 56, "Text",
      CellTags->{"1.1.6.5.2", "1.1.6.5"}]},
  "1.1.6.5.1.1"->{
    Cell[142418, 4694, 80, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.1.1", "1.1.6.5"}]},
  "1.1.6.5.1.2"->{
    Cell[142501, 4697, 265, 7, 70, "Usage",
      CellTags->{"1.1.6.5.1.2", "1.1.6.5"}]},
  "1.1.6.5.1.3"->{
    Cell[142769, 4706, 734, 18, 70, "Notes",
      CellTags->{"1.1.6.5.1.3", "1.1.6.5"}]},
  "1.1.6.5.2.1"->{
    Cell[143540, 4729, 83, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.2.1", "1.1.6.5"}]},
  "1.1.6.5.2.2"->{
    Cell[143626, 4732, 271, 7, 70, "Usage",
      CellTags->{"1.1.6.5.2.2", "1.1.6.5"}]},
  "1.1.6.5.2.3"->{
    Cell[143900, 4741, 746, 18, 70, "Notes",
      CellTags->{"1.1.6.5.2.3", "1.1.6.5"}]},
  "1.1.6.5.3.1"->{
    Cell[144683, 4764, 87, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.3.1", "1.1.6.5"}]},
  "1.1.6.5.3.2"->{
    Cell[144773, 4767, 281, 8, 48, "Usage",
      CellTags->{"1.1.6.5.3.2", "1.1.6.5"}]},
  "1.1.6.5.3.3"->{
    Cell[145057, 4777, 1070, 23, 176, "Notes",
      CellTags->{"1.1.6.5.3.3", "1.1.6.5"}]},
  "1.1.6.5.4.1"->{
    Cell[146164, 4805, 91, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.4.1", "1.1.6.5"}]},
  "1.1.6.5.4.2"->{
    Cell[146258, 4808, 285, 9, 48, "Usage",
      CellTags->{"1.1.6.5.4.2", "1.1.6.5"}]},
  "1.1.6.5.4.3"->{
    Cell[146546, 4819, 1087, 23, 176, "Notes",
      CellTags->{"1.1.6.5.4.3", "1.1.6.5"}]},
  "1.1.6.5.5.1"->{
    Cell[147670, 4847, 85, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.5.1", "1.1.6.5"}]},
  "1.1.6.5.5.2"->{
    Cell[147758, 4850, 259, 8, 32, "Usage",
      CellTags->{"1.1.6.5.5.2", "1.1.6.5"}]},
  "1.1.6.5.5.3"->{
    Cell[148020, 4860, 1035, 23, 160, "Notes",
      CellTags->{"1.1.6.5.5.3", "1.1.6.5"}]},
  "1.1.6.5.6.1"->{
    Cell[149092, 4888, 80, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.6.1", "1.1.6.5"}]},
  "1.1.6.5.6.2"->{
    Cell[149175, 4891, 382, 13, 70, "Usage",
      CellTags->{"1.1.6.5.6.2", "1.1.6.5"}]},
  "1.1.6.5.6.3"->{
    Cell[149560, 4906, 910, 26, 70, "Notes",
      CellTags->{"1.1.6.5.6.3", "1.1.6.5"}]},
  "1.1.6.5.7.1"->{
    Cell[150507, 4937, 80, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.7.1", "1.1.6.5"}]},
  "1.1.6.5.7.2"->{
    Cell[150590, 4940, 280, 7, 70, "Usage",
      CellTags->{"1.1.6.5.7.2", "1.1.6.5"}]},
  "1.1.6.5.7.3"->{
    Cell[150873, 4949, 809, 20, 70, "Notes",
      CellTags->{"1.1.6.5.7.3", "1.1.6.5"}]},
  "1.1.6.5.8.1"->{
    Cell[151719, 4974, 88, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.8.1", "1.1.6.5"}]},
  "1.1.6.5.8.2"->{
    Cell[151810, 4977, 297, 7, 70, "Usage",
      CellTags->{"1.1.6.5.8.2", "1.1.6.5"}]},
  "1.1.6.5.8.3"->{
    Cell[152110, 4986, 828, 20, 70, "Notes",
      CellTags->{"1.1.6.5.8.3", "1.1.6.5"}]},
  "1.1.6.5.9.1"->{
    Cell[152975, 5011, 84, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.9.1", "1.1.6.5"}]},
  "1.1.6.5.9.2"->{
    Cell[153062, 5014, 277, 7, 70, "Usage",
      CellTags->{"1.1.6.5.9.2", "1.1.6.5"}]},
  "1.1.6.5.9.3"->{
    Cell[153342, 5023, 576, 14, 70, "Notes",
      CellTags->{"1.1.6.5.9.3", "1.1.6.5"}]},
  "1.1.6.5.10.1"->{
    Cell[153955, 5042, 93, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.5.10.1", "1.1.6.5"}]},
  "1.1.6.5.10.2"->{
    Cell[154051, 5045, 293, 7, 70, "Usage",
      CellTags->{"1.1.6.5.10.2", "1.1.6.5"}]},
  "1.1.6.5.10.3"->{
    Cell[154347, 5054, 558, 13, 70, "Notes",
      CellTags->{"1.1.6.5.10.3", "1.1.6.5"}]},
  "1.1.6.6.1"->{
    Cell[154954, 5073, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.6.1", "1.1.6.6"}]},
  "1.1.6.6"->{
    Cell[154954, 5073, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.6.1", "1.1.6.6"}],
    Cell[155099, 5078, 525, 14, 70, "Text",
      CellTags->{"1.1.6.6.2", "1.1.6.6"}],
    Cell[155649, 5096, 91, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.6.1.1", "1.1.6.6"}],
    Cell[155743, 5099, 304, 9, 70, "Usage",
      CellTags->{"1.1.6.6.1.2", "1.1.6.6"}],
    Cell[156050, 5110, 788, 19, 70, "Notes",
      CellTags->{"1.1.6.6.1.3", "1.1.6.6"}]},
  "1.1.6.6.2"->{
    Cell[155099, 5078, 525, 14, 70, "Text",
      CellTags->{"1.1.6.6.2", "1.1.6.6"}]},
  "1.1.6.6.1.1"->{
    Cell[155649, 5096, 91, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.6.1.1", "1.1.6.6"}]},
  "1.1.6.6.1.2"->{
    Cell[155743, 5099, 304, 9, 70, "Usage",
      CellTags->{"1.1.6.6.1.2", "1.1.6.6"}]},
  "1.1.6.6.1.3"->{
    Cell[156050, 5110, 788, 19, 70, "Notes",
      CellTags->{"1.1.6.6.1.3", "1.1.6.6"}]},
  "1.1.6.7.1"->{
    Cell[156887, 5135, 143, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.7.1", "1.1.6.7"}]},
  "1.1.6.7"->{
    Cell[156887, 5135, 143, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.7.1", "1.1.6.7"}],
    Cell[157033, 5140, 489, 12, 56, "Text",
      CellTags->{"1.1.6.7.2", "1.1.6.7"}],
    Cell[157547, 5156, 82, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.7.1.1", "1.1.6.7"}],
    Cell[157632, 5159, 298, 9, 48, "Usage",
      CellTags->{"1.1.6.7.1.2", "1.1.6.7"}],
    Cell[157933, 5170, 455, 10, 78, "Notes",
      CellTags->{"1.1.6.7.1.3", "1.1.6.7"}],
    Cell[158425, 5185, 93, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.7.2.1", "1.1.6.7"}],
    Cell[158521, 5188, 307, 9, 70, "Usage",
      CellTags->{"1.1.6.7.2.2", "1.1.6.7"}],
    Cell[158831, 5199, 1025, 18, 70, "Notes",
      CellTags->{"1.1.6.7.2.3", "1.1.6.7"}],
    Cell[159893, 5222, 88, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.7.3.1", "1.1.6.7"}],
    Cell[159984, 5225, 286, 8, 70, "Usage",
      CellTags->{"1.1.6.7.3.2", "1.1.6.7"}],
    Cell[160273, 5235, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.7.3.3", "1.1.6.7"}]},
  "1.1.6.7.2"->{
    Cell[157033, 5140, 489, 12, 56, "Text",
      CellTags->{"1.1.6.7.2", "1.1.6.7"}]},
  "1.1.6.7.1.1"->{
    Cell[157547, 5156, 82, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.7.1.1", "1.1.6.7"}]},
  "1.1.6.7.1.2"->{
    Cell[157632, 5159, 298, 9, 48, "Usage",
      CellTags->{"1.1.6.7.1.2", "1.1.6.7"}]},
  "1.1.6.7.1.3"->{
    Cell[157933, 5170, 455, 10, 78, "Notes",
      CellTags->{"1.1.6.7.1.3", "1.1.6.7"}]},
  "1.1.6.7.2.1"->{
    Cell[158425, 5185, 93, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.1.6.7.2.1", "1.1.6.7"}]},
  "1.1.6.7.2.2"->{
    Cell[158521, 5188, 307, 9, 70, "Usage",
      CellTags->{"1.1.6.7.2.2", "1.1.6.7"}]},
  "1.1.6.7.2.3"->{
    Cell[158831, 5199, 1025, 18, 70, "Notes",
      CellTags->{"1.1.6.7.2.3", "1.1.6.7"}]},
  "1.1.6.7.3.1"->{
    Cell[159893, 5222, 88, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.1.6.7.3.1", "1.1.6.7"}]},
  "1.1.6.7.3.2"->{
    Cell[159984, 5225, 286, 8, 70, "Usage",
      CellTags->{"1.1.6.7.3.2", "1.1.6.7"}]},
  "1.1.6.7.3.3"->{
    Cell[160273, 5235, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.7.3.3", "1.1.6.7"}]},
  "1.1.6.8.1"->{
    Cell[162442, 5313, 140, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.8.1", "1.1.6.8"}]},
  "1.1.6.8"->{
    Cell[162442, 5313, 140, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.8.1", "1.1.6.8"}],
    Cell[162585, 5318, 468, 12, 70, "Text",
      CellTags->{"1.1.6.8.2", "1.1.6.8"}],
    Cell[163078, 5334, 81, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.8.1.1", "1.1.6.8"}],
    Cell[163162, 5337, 385, 12, 70, "Usage",
      CellTags->{"1.1.6.8.1.2", "1.1.6.8"}],
    Cell[163550, 5351, 976, 30, 70, "Notes",
      CellTags->{"1.1.6.8.1.3", "1.1.6.8"}],
    Cell[164563, 5386, 82, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.8.2.1", "1.1.6.8"}],
    Cell[164648, 5389, 260, 7, 70, "Usage",
      CellTags->{"1.1.6.8.2.2", "1.1.6.8"}],
    Cell[164911, 5398, 830, 19, 70, "Notes",
      CellTags->{"1.1.6.8.2.3", "1.1.6.8"}],
    Cell[165778, 5422, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.8.3.1", "1.1.6.8"}],
    Cell[165866, 5425, 311, 11, 70, "Usage",
      CellTags->{"1.1.6.8.3.2", "1.1.6.8"}],
    Cell[166180, 5438, 862, 24, 70, "Notes",
      CellTags->{"1.1.6.8.3.3", "1.1.6.8"}],
    Cell[167079, 5467, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.8.4.1", "1.1.6.8"}],
    Cell[167170, 5470, 274, 8, 70, "Usage",
      CellTags->{"1.1.6.8.4.2", "1.1.6.8"}],
    Cell[167447, 5480, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.8.4.3", "1.1.6.8"}]},
  "1.1.6.8.2"->{
    Cell[162585, 5318, 468, 12, 70, "Text",
      CellTags->{"1.1.6.8.2", "1.1.6.8"}]},
  "1.1.6.8.1.1"->{
    Cell[163078, 5334, 81, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.8.1.1", "1.1.6.8"}]},
  "1.1.6.8.1.2"->{
    Cell[163162, 5337, 385, 12, 70, "Usage",
      CellTags->{"1.1.6.8.1.2", "1.1.6.8"}]},
  "1.1.6.8.1.3"->{
    Cell[163550, 5351, 976, 30, 70, "Notes",
      CellTags->{"1.1.6.8.1.3", "1.1.6.8"}]},
  "1.1.6.8.2.1"->{
    Cell[164563, 5386, 82, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.8.2.1", "1.1.6.8"}]},
  "1.1.6.8.2.2"->{
    Cell[164648, 5389, 260, 7, 70, "Usage",
      CellTags->{"1.1.6.8.2.2", "1.1.6.8"}]},
  "1.1.6.8.2.3"->{
    Cell[164911, 5398, 830, 19, 70, "Notes",
      CellTags->{"1.1.6.8.2.3", "1.1.6.8"}]},
  "1.1.6.8.3.1"->{
    Cell[165778, 5422, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.8.3.1", "1.1.6.8"}]},
  "1.1.6.8.3.2"->{
    Cell[165866, 5425, 311, 11, 70, "Usage",
      CellTags->{"1.1.6.8.3.2", "1.1.6.8"}]},
  "1.1.6.8.3.3"->{
    Cell[166180, 5438, 862, 24, 70, "Notes",
      CellTags->{"1.1.6.8.3.3", "1.1.6.8"}]},
  "1.1.6.8.4.1"->{
    Cell[167079, 5467, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.8.4.1", "1.1.6.8"}]},
  "1.1.6.8.4.2"->{
    Cell[167170, 5470, 274, 8, 70, "Usage",
      CellTags->{"1.1.6.8.4.2", "1.1.6.8"}]},
  "1.1.6.8.4.3"->{
    Cell[167447, 5480, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.8.4.3", "1.1.6.8"}]},
  "1.1.6.9.1"->{
    Cell[169616, 5558, 133, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.9.1", "1.1.6.9"}]},
  "1.1.6.9"->{
    Cell[169616, 5558, 133, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.9.1", "1.1.6.9"}],
    Cell[169752, 5562, 434, 12, 70, "Text",
      CellTags->{"1.1.6.9.2", "1.1.6.9"}],
    Cell[170211, 5578, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.9.1.1", "1.1.6.9"}],
    Cell[170302, 5581, 277, 8, 70, "Usage",
      CellTags->{"1.1.6.9.1.2", "1.1.6.9"}],
    Cell[170582, 5591, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.9.1.3", "1.1.6.9"}]},
  "1.1.6.9.2"->{
    Cell[169752, 5562, 434, 12, 70, "Text",
      CellTags->{"1.1.6.9.2", "1.1.6.9"}]},
  "1.1.6.9.1.1"->{
    Cell[170211, 5578, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.9.1.1", "1.1.6.9"}]},
  "1.1.6.9.1.2"->{
    Cell[170302, 5581, 277, 8, 70, "Usage",
      CellTags->{"1.1.6.9.1.2", "1.1.6.9"}]},
  "1.1.6.9.1.3"->{
    Cell[170582, 5591, 2120, 72, 70, "Notes",
      CellTags->{"1.1.6.9.1.3", "1.1.6.9"}]},
  "1.1.6.10.1"->{
    Cell[172751, 5669, 143, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.10.1", "1.1.6.10"}]},
  "1.1.6.10"->{
    Cell[172751, 5669, 143, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.10.1", "1.1.6.10"}],
    Cell[172897, 5674, 273, 6, 70, "Text",
      CellTags->{"1.1.6.10.2", "1.1.6.10"}],
    Cell[173195, 5684, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.10.1.1", "1.1.6.10"}],
    Cell[173288, 5687, 284, 8, 70, "Usage",
      CellTags->{"1.1.6.10.1.2", "1.1.6.10"}],
    Cell[173575, 5697, 2122, 72, 70, "Notes",
      CellTags->{"1.1.6.10.1.3", "1.1.6.10"}]},
  "1.1.6.10.2"->{
    Cell[172897, 5674, 273, 6, 70, "Text",
      CellTags->{"1.1.6.10.2", "1.1.6.10"}]},
  "1.1.6.10.1.1"->{
    Cell[173195, 5684, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.10.1.1", "1.1.6.10"}]},
  "1.1.6.10.1.2"->{
    Cell[173288, 5687, 284, 8, 70, "Usage",
      CellTags->{"1.1.6.10.1.2", "1.1.6.10"}]},
  "1.1.6.10.1.3"->{
    Cell[173575, 5697, 2122, 72, 70, "Notes",
      CellTags->{"1.1.6.10.1.3", "1.1.6.10"}]},
  "1.1.6.11.1"->{
    Cell[175746, 5775, 134, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.11.1", "1.1.6.11"}]},
  "1.1.6.11"->{
    Cell[175746, 5775, 134, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.11.1", "1.1.6.11"}],
    Cell[175883, 5779, 269, 6, 70, "Text",
      CellTags->{"1.1.6.11.2", "1.1.6.11"}],
    Cell[176177, 5789, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.11.1.1", "1.1.6.11"}],
    Cell[176270, 5792, 284, 8, 70, "Usage",
      CellTags->{"1.1.6.11.1.2", "1.1.6.11"}],
    Cell[176557, 5802, 2122, 72, 70, "Notes",
      CellTags->{"1.1.6.11.1.3", "1.1.6.11"}]},
  "1.1.6.11.2"->{
    Cell[175883, 5779, 269, 6, 70, "Text",
      CellTags->{"1.1.6.11.2", "1.1.6.11"}]},
  "1.1.6.11.1.1"->{
    Cell[176177, 5789, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.11.1.1", "1.1.6.11"}]},
  "1.1.6.11.1.2"->{
    Cell[176270, 5792, 284, 8, 70, "Usage",
      CellTags->{"1.1.6.11.1.2", "1.1.6.11"}]},
  "1.1.6.11.1.3"->{
    Cell[176557, 5802, 2122, 72, 70, "Notes",
      CellTags->{"1.1.6.11.1.3", "1.1.6.11"}]},
  "1.1.6.12.1"->{
    Cell[178728, 5880, 131, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.12.1", "1.1.6.12"}]},
  "1.1.6.12"->{
    Cell[178728, 5880, 131, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.12.1", "1.1.6.12"}],
    Cell[178862, 5884, 261, 6, 70, "Text",
      CellTags->{"1.1.6.12.2", "1.1.6.12"}],
    Cell[179148, 5894, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.12.1.1", "1.1.6.12"}],
    Cell[179241, 5897, 282, 8, 70, "Usage",
      CellTags->{"1.1.6.12.1.2", "1.1.6.12"}],
    Cell[179526, 5907, 2122, 72, 70, "Notes",
      CellTags->{"1.1.6.12.1.3", "1.1.6.12"}]},
  "1.1.6.12.2"->{
    Cell[178862, 5884, 261, 6, 70, "Text",
      CellTags->{"1.1.6.12.2", "1.1.6.12"}]},
  "1.1.6.12.1.1"->{
    Cell[179148, 5894, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.12.1.1", "1.1.6.12"}]},
  "1.1.6.12.1.2"->{
    Cell[179241, 5897, 282, 8, 70, "Usage",
      CellTags->{"1.1.6.12.1.2", "1.1.6.12"}]},
  "1.1.6.12.1.3"->{
    Cell[179526, 5907, 2122, 72, 70, "Notes",
      CellTags->{"1.1.6.12.1.3", "1.1.6.12"}]},
  "1.1.6.13.1"->{
    Cell[181697, 5985, 136, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.13.1", "1.1.6.13"}]},
  "1.1.6.13"->{
    Cell[181697, 5985, 136, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.13.1", "1.1.6.13"}],
    Cell[181836, 5989, 251, 6, 70, "Text",
      CellTags->{"1.1.6.13.2", "1.1.6.13"}],
    Cell[182112, 5999, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.13.1.1", "1.1.6.13"}],
    Cell[182207, 6002, 258, 8, 70, "Usage",
      CellTags->"1.1.6.13"],
    Cell[182468, 6012, 574, 13, 70, "Notes",
      CellTags->"1.1.6.13"],
    Cell[183079, 6030, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.13.1.1", "1.1.6.13"}],
    Cell[183170, 6033, 321, 12, 70, "Usage",
      CellTags->"1.1.6.13"],
    Cell[183494, 6047, 861, 25, 70, "Notes",
      CellTags->"1.1.6.13"],
    Cell[184392, 6077, 89, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.2.2.1", "1.1.6.13"}],
    Cell[184484, 6080, 340, 11, 70, "Usage",
      CellTags->{"1.1.6.2.2.2", "1.1.6.13"}],
    Cell[184827, 6093, 2121, 72, 70, "Notes",
      CellTags->{"1.1.6.2.2.3", "1.1.6.13"}]},
  "1.1.6.13.2"->{
    Cell[181836, 5989, 251, 6, 70, "Text",
      CellTags->{"1.1.6.13.2", "1.1.6.13"}]},
  "1.1.6.13.1.1"->{
    Cell[182112, 5999, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.13.1.1", "1.1.6.13"}],
    Cell[183079, 6030, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.13.1.1", "1.1.6.13"}]},
  "1.1.6.14.1"->{
    Cell[186997, 6171, 138, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.14.1", "1.1.6.14"}]},
  "1.1.6.14"->{
    Cell[186997, 6171, 138, 2, 24, "GroupObjectName",
      CellTags->{"1.1.6.14.1", "1.1.6.14"}],
    Cell[187138, 6175, 256, 6, 70, "Text",
      CellTags->{"1.1.6.14.2", "1.1.6.14"}],
    Cell[187419, 6185, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.14.1.1", "1.1.6.14"}],
    Cell[187512, 6188, 270, 8, 70, "Usage",
      CellTags->{"1.1.6.14.1.2", "1.1.6.14"}],
    Cell[187785, 6198, 2122, 72, 70, "Notes",
      CellTags->{"1.1.6.14.1.3", "1.1.6.14"}]},
  "1.1.6.14.2"->{
    Cell[187138, 6175, 256, 6, 70, "Text",
      CellTags->{"1.1.6.14.2", "1.1.6.14"}]},
  "1.1.6.14.1.1"->{
    Cell[187419, 6185, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.14.1.1", "1.1.6.14"}]},
  "1.1.6.14.1.2"->{
    Cell[187512, 6188, 270, 8, 70, "Usage",
      CellTags->{"1.1.6.14.1.2", "1.1.6.14"}]},
  "1.1.6.14.1.3"->{
    Cell[187785, 6198, 2122, 72, 70, "Notes",
      CellTags->{"1.1.6.14.1.3", "1.1.6.14"}]},
  "1.1.6.15.1"->{
    Cell[189956, 6276, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.15.1", "1.1.6.15"}]},
  "1.1.6.15"->{
    Cell[189956, 6276, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.15.1", "1.1.6.15"}],
    Cell[190101, 6281, 267, 6, 70, "Text",
      CellTags->{"1.1.6.15.2", "1.1.6.15"}],
    Cell[190393, 6291, 83, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.15.1.1", "1.1.6.15"}],
    Cell[190479, 6294, 360, 12, 70, "Usage",
      CellTags->{"1.1.6.15.1.2", "1.1.6.15"}],
    Cell[190842, 6308, 392, 11, 70, "Notes",
      CellTags->{"1.1.6.15.1.3", "1.1.6.15"}]},
  "1.1.6.15.2"->{
    Cell[190101, 6281, 267, 6, 70, "Text",
      CellTags->{"1.1.6.15.2", "1.1.6.15"}]},
  "1.1.6.15.1.1"->{
    Cell[190393, 6291, 83, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.15.1.1", "1.1.6.15"}]},
  "1.1.6.15.1.2"->{
    Cell[190479, 6294, 360, 12, 70, "Usage",
      CellTags->{"1.1.6.15.1.2", "1.1.6.15"}]},
  "1.1.6.15.1.3"->{
    Cell[190842, 6308, 392, 11, 70, "Notes",
      CellTags->{"1.1.6.15.1.3", "1.1.6.15"}]},
  "1.1.6.16.1"->{
    Cell[191283, 6325, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.16.1", "1.1.6.16"}]},
  "1.1.6.16"->{
    Cell[191283, 6325, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.16.1", "1.1.6.16"}],
    Cell[191428, 6330, 256, 6, 70, "Text",
      CellTags->{"1.1.6.16.2", "1.1.6.16"}],
    Cell[191709, 6340, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.16.1.1", "1.1.6.16"}],
    Cell[191802, 6343, 537, 17, 70, "Usage",
      CellTags->{"1.1.6.16.1.2", "1.1.6.16"}],
    Cell[192342, 6362, 586, 14, 70, "Notes",
      CellTags->{"1.1.6.16.1.3", "1.1.6.16"}]},
  "1.1.6.16.2"->{
    Cell[191428, 6330, 256, 6, 70, "Text",
      CellTags->{"1.1.6.16.2", "1.1.6.16"}]},
  "1.1.6.16.1.1"->{
    Cell[191709, 6340, 90, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.16.1.1", "1.1.6.16"}]},
  "1.1.6.16.1.2"->{
    Cell[191802, 6343, 537, 17, 70, "Usage",
      CellTags->{"1.1.6.16.1.2", "1.1.6.16"}]},
  "1.1.6.16.1.3"->{
    Cell[192342, 6362, 586, 14, 70, "Notes",
      CellTags->{"1.1.6.16.1.3", "1.1.6.16"}]},
  "1.1.6.17.1"->{
    Cell[192977, 6382, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.17.1", "1.1.6.17"}]},
  "1.1.6.17"->{
    Cell[192977, 6382, 142, 3, 24, "GroupObjectName",
      CellTags->{"1.1.6.17.1", "1.1.6.17"}],
    Cell[193122, 6387, 479, 13, 70, "Text",
      CellTags->{"1.1.6.17.2", "1.1.6.17"}],
    Cell[193626, 6404, 97, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.17.1.1", "1.1.6.17"}],
    Cell[193726, 6407, 359, 11, 70, "Usage",
      CellTags->{"1.1.6.17.1.2", "1.1.6.17"}],
    Cell[194088, 6420, 617, 16, 70, "Notes",
      CellTags->{"1.1.6.17.1.3", "1.1.6.17"}],
    Cell[194742, 6441, 97, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.17.2.1", "1.1.6.17"}],
    Cell[194842, 6444, 360, 11, 70, "Usage",
      CellTags->{"1.1.6.17.2.2", "1.1.6.17"}],
    Cell[195205, 6457, 629, 16, 70, "Notes",
      CellTags->{"1.1.6.17.2.3", "1.1.6.17"}],
    Cell[195871, 6478, 96, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.17.3.1", "1.1.6.17"}],
    Cell[195970, 6481, 348, 9, 70, "Usage",
      CellTags->{"1.1.6.17.3.2", "1.1.6.17"}],
    Cell[196321, 6492, 1137, 23, 70, "Notes",
      CellTags->{"1.1.6.17.3.3", "1.1.6.17"}],
    Cell[197495, 6520, 98, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.17.4.1", "1.1.6.17"}],
    Cell[197596, 6523, 337, 9, 70, "Usage",
      CellTags->{"1.1.6.17.4.2", "1.1.6.17"}],
    Cell[197936, 6534, 857, 18, 70, "Notes",
      CellTags->{"1.1.6.17.4.3", "1.1.6.17"}]},
  "1.1.6.17.2"->{
    Cell[193122, 6387, 479, 13, 70, "Text",
      CellTags->{"1.1.6.17.2", "1.1.6.17"}]},
  "1.1.6.17.1.1"->{
    Cell[193626, 6404, 97, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.17.1.1", "1.1.6.17"}]},
  "1.1.6.17.1.2"->{
    Cell[193726, 6407, 359, 11, 70, "Usage",
      CellTags->{"1.1.6.17.1.2", "1.1.6.17"}]},
  "1.1.6.17.1.3"->{
    Cell[194088, 6420, 617, 16, 70, "Notes",
      CellTags->{"1.1.6.17.1.3", "1.1.6.17"}]},
  "1.1.6.17.2.1"->{
    Cell[194742, 6441, 97, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.17.2.1", "1.1.6.17"}]},
  "1.1.6.17.2.2"->{
    Cell[194842, 6444, 360, 11, 70, "Usage",
      CellTags->{"1.1.6.17.2.2", "1.1.6.17"}]},
  "1.1.6.17.2.3"->{
    Cell[195205, 6457, 629, 16, 70, "Notes",
      CellTags->{"1.1.6.17.2.3", "1.1.6.17"}]},
  "1.1.6.17.3.1"->{
    Cell[195871, 6478, 96, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.17.3.1", "1.1.6.17"}]},
  "1.1.6.17.3.2"->{
    Cell[195970, 6481, 348, 9, 70, "Usage",
      CellTags->{"1.1.6.17.3.2", "1.1.6.17"}]},
  "1.1.6.17.3.3"->{
    Cell[196321, 6492, 1137, 23, 70, "Notes",
      CellTags->{"1.1.6.17.3.3", "1.1.6.17"}]},
  "1.1.6.17.4.1"->{
    Cell[197495, 6520, 98, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.1.6.17.4.1", "1.1.6.17"}]},
  "1.1.6.17.4.2"->{
    Cell[197596, 6523, 337, 9, 70, "Usage",
      CellTags->{"1.1.6.17.4.2", "1.1.6.17"}]},
  "1.1.6.17.4.3"->{
    Cell[197936, 6534, 857, 18, 70, "Notes",
      CellTags->{"1.1.6.17.4.3", "1.1.6.17"}]},
  "1.1.7.1.1"->{
    Cell[199138, 6572, 78, 1, 70, "ObjectName",
      CellTags->{"1.1.7.1.1", "1.1.7.1"}]},
  "1.1.7.1"->{
    Cell[199138, 6572, 78, 1, 70, "ObjectName",
      CellTags->{"1.1.7.1.1", "1.1.7.1"}],
    Cell[199219, 6575, 366, 12, 70, "Usage",
      CellTags->{"1.1.7.1.2", "1.1.7.1"}],
    Cell[199588, 6589, 1171, 29, 70, "Notes",
      CellTags->{"1.1.7.1.3", "1.1.7.1"}]},
  "1.1.7.1.2"->{
    Cell[199219, 6575, 366, 12, 70, "Usage",
      CellTags->{"1.1.7.1.2", "1.1.7.1"}]},
  "1.1.7.1.3"->{
    Cell[199588, 6589, 1171, 29, 70, "Notes",
      CellTags->{"1.1.7.1.3", "1.1.7.1"}]},
  "1.1.7.2.1"->{
    Cell[200796, 6623, 75, 1, 70, "ObjectName",
      CellTags->{"1.1.7.2.1", "1.1.7.2"}]},
  "1.1.7.2"->{
    Cell[200796, 6623, 75, 1, 70, "ObjectName",
      CellTags->{"1.1.7.2.1", "1.1.7.2"}],
    Cell[200874, 6626, 340, 11, 70, "Usage",
      CellTags->{"1.1.7.2.2", "1.1.7.2"}],
    Cell[201217, 6639, 429, 9, 70, "Notes",
      CellTags->{"1.1.7.2.3", "1.1.7.2"}],
    Cell[201649, 6650, 837, 23, 70, "Notes",
      CellTags->{"1.1.7.2.4", "1.1.7.2"}]},
  "1.1.7.2.2"->{
    Cell[200874, 6626, 340, 11, 70, "Usage",
      CellTags->{"1.1.7.2.2", "1.1.7.2"}]},
  "1.1.7.2.3"->{
    Cell[201217, 6639, 429, 9, 70, "Notes",
      CellTags->{"1.1.7.2.3", "1.1.7.2"}]},
  "1.1.7.2.4"->{
    Cell[201649, 6650, 837, 23, 70, "Notes",
      CellTags->{"1.1.7.2.4", "1.1.7.2"}]},
  "1.1.7.3.1"->{
    Cell[202523, 6678, 85, 1, 70, "ObjectName",
      CellTags->{"1.1.7.3.1", "1.1.7.3"}]},
  "1.1.7.3"->{
    Cell[202523, 6678, 85, 1, 70, "ObjectName",
      CellTags->{"1.1.7.3.1", "1.1.7.3"}],
    Cell[202611, 6681, 363, 12, 70, "Usage",
      CellTags->{"1.1.7.3.2", "1.1.7.3"}],
    Cell[202977, 6695, 846, 23, 70, "Notes",
      CellTags->{"1.1.7.3.3", "1.1.7.3"}]},
  "1.1.7.3.2"->{
    Cell[202611, 6681, 363, 12, 70, "Usage",
      CellTags->{"1.1.7.3.2", "1.1.7.3"}]},
  "1.1.7.3.3"->{
    Cell[202977, 6695, 846, 23, 70, "Notes",
      CellTags->{"1.1.7.3.3", "1.1.7.3"}]},
  "1.1.7.4.1"->{
    Cell[203860, 6723, 84, 1, 70, "ObjectName",
      CellTags->{"1.1.7.4.1", "1.1.7.4"}]},
  "1.1.7.4"->{
    Cell[203860, 6723, 84, 1, 70, "ObjectName",
      CellTags->{"1.1.7.4.1", "1.1.7.4"}],
    Cell[203947, 6726, 313, 11, 70, "Usage",
      CellTags->{"1.1.7.4.2", "1.1.7.4"}],
    Cell[204263, 6739, 845, 23, 70, "Notes",
      CellTags->{"1.1.7.4.3", "1.1.7.4"}]},
  "1.1.7.4.2"->{
    Cell[203947, 6726, 313, 11, 70, "Usage",
      CellTags->{"1.1.7.4.2", "1.1.7.4"}]},
  "1.1.7.4.3"->{
    Cell[204263, 6739, 845, 23, 70, "Notes",
      CellTags->{"1.1.7.4.3", "1.1.7.4"}]},
  "1.1.7.5.1"->{
    Cell[205145, 6767, 76, 1, 70, "ObjectName",
      CellTags->{"1.1.7.5.1", "1.1.7.5"}]},
  "1.1.7.5"->{
    Cell[205145, 6767, 76, 1, 70, "ObjectName",
      CellTags->{"1.1.7.5.1", "1.1.7.5"}],
    Cell[205224, 6770, 327, 10, 70, "Usage",
      CellTags->{"1.1.7.5.2", "1.1.7.5"}],
    Cell[205554, 6782, 558, 16, 70, "Notes",
      CellTags->{"1.1.7.5.3", "1.1.7.5"}]},
  "1.1.7.5.2"->{
    Cell[205224, 6770, 327, 10, 70, "Usage",
      CellTags->{"1.1.7.5.2", "1.1.7.5"}]},
  "1.1.7.5.3"->{
    Cell[205554, 6782, 558, 16, 70, "Notes",
      CellTags->{"1.1.7.5.3", "1.1.7.5"}]},
  "1.1.7.6.1"->{
    Cell[206149, 6803, 79, 1, 70, "ObjectName",
      CellTags->{"1.1.7.6.1", "1.1.7.6"}]},
  "1.1.7.6"->{
    Cell[206149, 6803, 79, 1, 70, "ObjectName",
      CellTags->{"1.1.7.6.1", "1.1.7.6"}],
    Cell[206231, 6806, 276, 8, 70, "Usage",
      CellTags->{"1.1.7.6.2", "1.1.7.6"}],
    Cell[206510, 6816, 423, 10, 70, "Notes",
      CellTags->{"1.1.7.6.3", "1.1.7.6"}]},
  "1.1.7.6.2"->{
    Cell[206231, 6806, 276, 8, 70, "Usage",
      CellTags->{"1.1.7.6.2", "1.1.7.6"}]},
  "1.1.7.6.3"->{
    Cell[206510, 6816, 423, 10, 70, "Notes",
      CellTags->{"1.1.7.6.3", "1.1.7.6"}]},
  "MathMLPasteWarning"->{
    Cell[206970, 6831, 79, 1, 70, "ObjectName",
      CellTags->"MathMLPasteWarning"],
    Cell[207052, 6834, 275, 7, 70, "Usage",
      CellTags->"MathMLPasteWarning"],
    Cell[207330, 6843, 503, 10, 70, "Notes",
      CellTags->"MathMLPasteWarning"]},
  "InsufficientVersionWarning"->{
    Cell[207870, 6858, 95, 1, 70, "ObjectName",
      CellTags->"InsufficientVersionWarning"],
    Cell[207968, 6861, 362, 10, 70, "Usage",
      CellTags->"InsufficientVersionWarning"],
    Cell[208333, 6873, 551, 14, 70, "Notes",
      CellTags->"InsufficientVersionWarning"]},
  "1.1.7.7.1"->{
    Cell[208921, 6892, 91, 1, 70, "ObjectName",
      CellTags->{"1.1.7.7.1", "1.1.7.7"}]},
  "1.1.7.7"->{
    Cell[208921, 6892, 91, 1, 70, "ObjectName",
      CellTags->{"1.1.7.7.1", "1.1.7.7"}],
    Cell[209015, 6895, 273, 8, 70, "Usage",
      CellTags->{"1.1.7.7.2", "1.1.7.7"}],
    Cell[209291, 6905, 1233, 38, 70, "Notes",
      CellTags->{"1.1.7.7.3", "1.1.7.7"}]},
  "1.1.7.7.2"->{
    Cell[209015, 6895, 273, 8, 70, "Usage",
      CellTags->{"1.1.7.7.2", "1.1.7.7"}]},
  "1.1.7.7.3"->{
    Cell[209291, 6905, 1233, 38, 70, "Notes",
      CellTags->{"1.1.7.7.3", "1.1.7.7"}]},
  "1.1.7.8.1"->{
    Cell[210561, 6948, 96, 1, 70, "ObjectName",
      CellTags->{"1.1.7.8.1", "1.1.7.8"}]},
  "1.1.7.8"->{
    Cell[210561, 6948, 96, 1, 70, "ObjectName",
      CellTags->{"1.1.7.8.1", "1.1.7.8"}],
    Cell[210660, 6951, 383, 11, 70, "Usage",
      CellTags->{"1.1.7.8.2", "1.1.7.8"}],
    Cell[211046, 6964, 663, 16, 70, "Notes",
      CellTags->{"1.1.7.8.3", "1.1.7.8"}]},
  "1.1.7.8.2"->{
    Cell[210660, 6951, 383, 11, 70, "Usage",
      CellTags->{"1.1.7.8.2", "1.1.7.8"}]},
  "1.1.7.8.3"->{
    Cell[211046, 6964, 663, 16, 70, "Notes",
      CellTags->{"1.1.7.8.3", "1.1.7.8"}]},
  "1.1.7.9.1"->{
    Cell[211746, 6985, 87, 1, 70, "ObjectName",
      CellTags->{"1.1.7.9.1", "1.1.7.9"}]},
  "1.1.7.9"->{
    Cell[211746, 6985, 87, 1, 70, "ObjectName",
      CellTags->{"1.1.7.9.1", "1.1.7.9"}],
    Cell[211836, 6988, 379, 12, 70, "Usage",
      CellTags->{"1.1.7.9.2", "1.1.7.9"}],
    Cell[212218, 7002, 1009, 30, 70, "Notes",
      CellTags->{"1.1.7.9.3", "1.1.7.9"}]},
  "1.1.7.9.2"->{
    Cell[211836, 6988, 379, 12, 70, "Usage",
      CellTags->{"1.1.7.9.2", "1.1.7.9"}]},
  "1.1.7.9.3"->{
    Cell[212218, 7002, 1009, 30, 70, "Notes",
      CellTags->{"1.1.7.9.3", "1.1.7.9"}]},
  "1.2.1.1.1"->{
    Cell[213412, 7047, 76, 1, 70, "ObjectName",
      CellTags->{"1.2.1.1.1", "1.2.1.1"}],
    Cell[214335, 7082, 76, 1, 70, "ObjectName",
      CellTags->{"1.2.1.1.1", "1.2.1.1a"}]},
  "1.2.1.1"->{
    Cell[213412, 7047, 76, 1, 70, "ObjectName",
      CellTags->{"1.2.1.1.1", "1.2.1.1"}],
    Cell[213491, 7050, 279, 8, 70, "Usage",
      CellTags->{"1.2.1.1.2", "1.2.1.1"}],
    Cell[213773, 7060, 525, 17, 70, "Notes",
      CellTags->{"1.2.1.1.3", "1.2.1.1"}]},
  "1.2.1.1.2"->{
    Cell[213491, 7050, 279, 8, 70, "Usage",
      CellTags->{"1.2.1.1.2", "1.2.1.1"}],
    Cell[214414, 7085, 248, 7, 70, "Usage",
      CellTags->{"1.2.1.1.2", "1.2.1.1a"}]},
  "1.2.1.1.3"->{
    Cell[213773, 7060, 525, 17, 70, "Notes",
      CellTags->{"1.2.1.1.3", "1.2.1.1"}],
    Cell[214665, 7094, 517, 12, 70, "Notes",
      CellTags->{"1.2.1.1.3", "1.2.1.1a"}]},
  "1.2.1.1a"->{
    Cell[214335, 7082, 76, 1, 70, "ObjectName",
      CellTags->{"1.2.1.1.1", "1.2.1.1a"}],
    Cell[214414, 7085, 248, 7, 70, "Usage",
      CellTags->{"1.2.1.1.2", "1.2.1.1a"}],
    Cell[214665, 7094, 517, 12, 70, "Notes",
      CellTags->{"1.2.1.1.3", "1.2.1.1a"}]},
  "1.2.1.2.1"->{
    Cell[215219, 7111, 81, 1, 70, "ObjectName",
      CellTags->{"1.2.1.2.1", "1.2.1.2"}]},
  "1.2.1.2"->{
    Cell[215219, 7111, 81, 1, 70, "ObjectName",
      CellTags->{"1.2.1.2.1", "1.2.1.2"}],
    Cell[215303, 7114, 311, 9, 70, "Usage",
      CellTags->{"1.2.1.2.2", "1.2.1.2"}],
    Cell[215617, 7125, 198, 6, 70, "Notes",
      CellTags->{"1.2.1.2.3", "1.2.1.2"}]},
  "1.2.1.2.2"->{
    Cell[215303, 7114, 311, 9, 70, "Usage",
      CellTags->{"1.2.1.2.2", "1.2.1.2"}]},
  "1.2.1.2.3"->{
    Cell[215617, 7125, 198, 6, 70, "Notes",
      CellTags->{"1.2.1.2.3", "1.2.1.2"}]},
  "1.2.1.3.1"->{
    Cell[215852, 7136, 81, 1, 70, "ObjectName",
      CellTags->{"1.2.1.3.1", "1.2.1.3"}]},
  "1.2.1.3"->{
    Cell[215852, 7136, 81, 1, 70, "ObjectName",
      CellTags->{"1.2.1.3.1", "1.2.1.3"}],
    Cell[215936, 7139, 332, 9, 70, "Usage",
      CellTags->{"1.2.1.3.2", "1.2.1.3"}],
    Cell[216271, 7150, 1250, 29, 70, "Notes",
      CellTags->{"1.2.1.3.3", "1.2.1.3"}]},
  "1.2.1.3.2"->{
    Cell[215936, 7139, 332, 9, 70, "Usage",
      CellTags->{"1.2.1.3.2", "1.2.1.3"}]},
  "1.2.1.3.3"->{
    Cell[216271, 7150, 1250, 29, 70, "Notes",
      CellTags->{"1.2.1.3.3", "1.2.1.3"}]},
  "1.2.1.4.1"->{
    Cell[217558, 7184, 69, 1, 70, "ObjectName",
      CellTags->{"1.2.1.4.1", "1.2.1.4"}]},
  "1.2.1.4"->{
    Cell[217558, 7184, 69, 1, 70, "ObjectName",
      CellTags->{"1.2.1.4.1", "1.2.1.4"}],
    Cell[217630, 7187, 234, 8, 70, "Usage",
      CellTags->{"1.2.1.4.2", "1.2.1.4"}],
    Cell[217867, 7197, 533, 14, 70, "Notes",
      CellTags->{"1.2.1.4.3", "1.2.1.4"}]},
  "1.2.1.4.2"->{
    Cell[217630, 7187, 234, 8, 70, "Usage",
      CellTags->{"1.2.1.4.2", "1.2.1.4"}]},
  "1.2.1.4.3"->{
    Cell[217867, 7197, 533, 14, 70, "Notes",
      CellTags->{"1.2.1.4.3", "1.2.1.4"}]},
  "Saveable"->{
    Cell[218437, 7216, 55, 1, 70, "ObjectName",
      CellTags->"Saveable"],
    Cell[218495, 7219, 265, 9, 70, "Usage",
      CellTags->"Saveable"],
    Cell[218763, 7230, 1066, 33, 70, "Notes",
      CellTags->"Saveable"]},
  "1.2.2.1.1"->{
    Cell[219945, 7273, 82, 1, 70, "ObjectName",
      CellTags->{"1.2.2.1.1", "1.2.2.1"}]},
  "1.2.2.1"->{
    Cell[219945, 7273, 82, 1, 70, "ObjectName",
      CellTags->{"1.2.2.1.1", "1.2.2.1"}],
    Cell[220030, 7276, 259, 8, 70, "Usage",
      CellTags->{"1.2.2.1.2", "1.2.2.1"}],
    Cell[220292, 7286, 161, 4, 70, "Notes",
      CellTags->{"1.2.2.1.3", "1.2.2.1"}],
    Cell[220456, 7292, 864, 17, 70, "Notes",
      CellTags->{"1.2.2.1.4", "1.2.2.1"}],
    Cell[221323, 7311, 469, 17, 70, "Notes",
      CellTags->{"1.2.2.1.5", "1.2.2.1"}]},
  "1.2.2.1.2"->{
    Cell[220030, 7276, 259, 8, 70, "Usage",
      CellTags->{"1.2.2.1.2", "1.2.2.1"}]},
  "1.2.2.1.3"->{
    Cell[220292, 7286, 161, 4, 70, "Notes",
      CellTags->{"1.2.2.1.3", "1.2.2.1"}]},
  "1.2.2.1.4"->{
    Cell[220456, 7292, 864, 17, 70, "Notes",
      CellTags->{"1.2.2.1.4", "1.2.2.1"}]},
  "1.2.2.1.5"->{
    Cell[221323, 7311, 469, 17, 70, "Notes",
      CellTags->{"1.2.2.1.5", "1.2.2.1"}]},
  "1.2.2.2.1"->{
    Cell[221829, 7333, 84, 1, 70, "ObjectName",
      CellTags->{"1.2.2.2.1", "1.2.2.2"}]},
  "1.2.2.2"->{
    Cell[221829, 7333, 84, 1, 70, "ObjectName",
      CellTags->{"1.2.2.2.1", "1.2.2.2"}],
    Cell[221916, 7336, 247, 7, 70, "Usage",
      CellTags->{"1.2.2.2.2", "1.2.2.2"}],
    Cell[222166, 7345, 709, 21, 70, "Notes",
      CellTags->{"1.2.2.2.3", "1.2.2.2"}]},
  "1.2.2.2.2"->{
    Cell[221916, 7336, 247, 7, 70, "Usage",
      CellTags->{"1.2.2.2.2", "1.2.2.2"}]},
  "1.2.2.2.3"->{
    Cell[222166, 7345, 709, 21, 70, "Notes",
      CellTags->{"1.2.2.2.3", "1.2.2.2"}]},
  "1.2.2.3.1"->{
    Cell[222912, 7371, 75, 1, 70, "ObjectName",
      CellTags->{"1.2.2.3.1", "1.2.2.3"}]},
  "1.2.2.3"->{
    Cell[222912, 7371, 75, 1, 70, "ObjectName",
      CellTags->{"1.2.2.3.1", "1.2.2.3"}],
    Cell[222990, 7374, 311, 8, 70, "Usage",
      CellTags->{"1.2.2.3.2", "1.2.2.3"}],
    Cell[223304, 7384, 719, 14, 70, "Notes",
      CellTags->{"1.2.2.3.3", "1.2.2.3"}]},
  "1.2.2.3.2"->{
    Cell[222990, 7374, 311, 8, 70, "Usage",
      CellTags->{"1.2.2.3.2", "1.2.2.3"}]},
  "1.2.2.3.3"->{
    Cell[223304, 7384, 719, 14, 70, "Notes",
      CellTags->{"1.2.2.3.3", "1.2.2.3"}]},
  "1.2.2.4.1"->{
    Cell[224060, 7403, 74, 1, 70, "ObjectName",
      CellTags->{"1.2.2.4.1", "1.2.2.4"}]},
  "1.2.2.4"->{
    Cell[224060, 7403, 74, 1, 70, "ObjectName",
      CellTags->{"1.2.2.4.1", "1.2.2.4"}],
    Cell[224137, 7406, 330, 9, 70, "Usage",
      CellTags->{"1.2.2.4.2", "1.2.2.4"}],
    Cell[224470, 7417, 530, 13, 70, "Notes",
      CellTags->{"1.2.2.4.3", "1.2.2.4"}]},
  "1.2.2.4.2"->{
    Cell[224137, 7406, 330, 9, 70, "Usage",
      CellTags->{"1.2.2.4.2", "1.2.2.4"}]},
  "1.2.2.4.3"->{
    Cell[224470, 7417, 530, 13, 70, "Notes",
      CellTags->{"1.2.2.4.3", "1.2.2.4"}]},
  "1.2.2.5.1"->{
    Cell[225037, 7435, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.2.5.1", "1.2.2.5"}]},
  "1.2.2.5"->{
    Cell[225037, 7435, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.2.5.1", "1.2.2.5"}],
    Cell[225110, 7438, 238, 8, 70, "Usage",
      CellTags->{"1.2.2.5.2", "1.2.2.5"}],
    Cell[225351, 7448, 546, 16, 70, "Notes",
      CellTags->{"1.2.2.5.3", "1.2.2.5"}]},
  "1.2.2.5.2"->{
    Cell[225110, 7438, 238, 8, 70, "Usage",
      CellTags->{"1.2.2.5.2", "1.2.2.5"}]},
  "1.2.2.5.3"->{
    Cell[225351, 7448, 546, 16, 70, "Notes",
      CellTags->{"1.2.2.5.3", "1.2.2.5"}]},
  "NotebookBackground"->{
    Cell[225934, 7469, 66, 1, 70, "ObjectName",
      CellTags->"NotebookBackground"],
    Cell[226003, 7472, 214, 6, 70, "Usage",
      CellTags->"NotebookBackground"],
    Cell[226220, 7480, 244, 7, 70, "Notes",
      CellTags->"NotebookBackground"],
    Cell[226467, 7489, 556, 14, 70, "Notes",
      CellTags->"NotebookBackground"],
    Cell[227026, 7505, 677, 23, 70, "Notes",
      CellTags->"NotebookBackground"]},
  "1.2.2.7.1"->{
    Cell[227740, 7533, 73, 1, 70, "ObjectName",
      CellTags->{"1.2.2.7.1", "1.2.2.7"}]},
  "1.2.2.7"->{
    Cell[227740, 7533, 73, 1, 70, "ObjectName",
      CellTags->{"1.2.2.7.1", "1.2.2.7"}],
    Cell[227816, 7536, 301, 9, 70, "Usage",
      CellTags->{"1.2.2.7.2", "1.2.2.7"}],
    Cell[228120, 7547, 493, 11, 70, "Notes",
      CellTags->{"1.2.2.7.3", "1.2.2.7"}]},
  "1.2.2.7.2"->{
    Cell[227816, 7536, 301, 9, 70, "Usage",
      CellTags->{"1.2.2.7.2", "1.2.2.7"}]},
  "1.2.2.7.3"->{
    Cell[228120, 7547, 493, 11, 70, "Notes",
      CellTags->{"1.2.2.7.3", "1.2.2.7"}]},
  "1.2.3.1.1"->{
    Cell[228732, 7568, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.3.1.1", "1.2.3.1"}]},
  "1.2.3.1"->{
    Cell[228732, 7568, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.3.1.1", "1.2.3.1"}],
    Cell[228805, 7571, 245, 7, 70, "Usage",
      CellTags->{"1.2.3.1.2", "1.2.3.1"}],
    Cell[229053, 7580, 797, 19, 70, "Notes",
      CellTags->{"1.2.3.1.3", "1.2.3.1"}]},
  "1.2.3.1.2"->{
    Cell[228805, 7571, 245, 7, 70, "Usage",
      CellTags->{"1.2.3.1.2", "1.2.3.1"}]},
  "1.2.3.1.3"->{
    Cell[229053, 7580, 797, 19, 70, "Notes",
      CellTags->{"1.2.3.1.3", "1.2.3.1"}]},
  "1.2.3.2.1"->{
    Cell[229887, 7604, 87, 1, 70, "ObjectName",
      CellTags->{"1.2.3.2.1", "1.2.3.2"}]},
  "1.2.3.2"->{
    Cell[229887, 7604, 87, 1, 70, "ObjectName",
      CellTags->{"1.2.3.2.1", "1.2.3.2"}],
    Cell[229977, 7607, 273, 8, 70, "Usage",
      CellTags->{"1.2.3.2.2", "1.2.3.2"}],
    Cell[230253, 7617, 563, 17, 70, "Notes",
      CellTags->{"1.2.3.2.3", "1.2.3.2"}]},
  "1.2.3.2.2"->{
    Cell[229977, 7607, 273, 8, 70, "Usage",
      CellTags->{"1.2.3.2.2", "1.2.3.2"}]},
  "1.2.3.2.3"->{
    Cell[230253, 7617, 563, 17, 70, "Notes",
      CellTags->{"1.2.3.2.3", "1.2.3.2"}]},
  "1.2.3.3.1"->{
    Cell[230853, 7639, 72, 1, 70, "ObjectName",
      CellTags->{"1.2.3.3.1", "1.2.3.3"}]},
  "1.2.3.3"->{
    Cell[230853, 7639, 72, 1, 70, "ObjectName",
      CellTags->{"1.2.3.3.1", "1.2.3.3"}],
    Cell[230928, 7642, 312, 9, 70, "Usage",
      CellTags->{"1.2.3.3.2", "1.2.3.3"}],
    Cell[231243, 7653, 1065, 26, 70, "Notes",
      CellTags->{"1.2.3.3.3", "1.2.3.3"}]},
  "1.2.3.3.2"->{
    Cell[230928, 7642, 312, 9, 70, "Usage",
      CellTags->{"1.2.3.3.2", "1.2.3.3"}]},
  "1.2.3.3.3"->{
    Cell[231243, 7653, 1065, 26, 70, "Notes",
      CellTags->{"1.2.3.3.3", "1.2.3.3"}]},
  "1.2.3.4.1"->{
    Cell[232345, 7684, 80, 1, 70, "ObjectName",
      CellTags->{"1.2.3.4.1", "1.2.3.4"}]},
  "1.2.3.4"->{
    Cell[232345, 7684, 80, 1, 70, "ObjectName",
      CellTags->{"1.2.3.4.1", "1.2.3.4"}],
    Cell[232428, 7687, 307, 9, 70, "Usage",
      CellTags->{"1.2.3.4.2", "1.2.3.4"}],
    Cell[232738, 7698, 872, 22, 70, "Notes",
      CellTags->{"1.2.3.4.3", "1.2.3.4"}]},
  "1.2.3.4.2"->{
    Cell[232428, 7687, 307, 9, 70, "Usage",
      CellTags->{"1.2.3.4.2", "1.2.3.4"}]},
  "1.2.3.4.3"->{
    Cell[232738, 7698, 872, 22, 70, "Notes",
      CellTags->{"1.2.3.4.3", "1.2.3.4"}]},
  "1.2.3.5.1"->{
    Cell[233647, 7725, 88, 1, 70, "ObjectName",
      CellTags->{"1.2.3.5.1", "1.2.3.5"}]},
  "1.2.3.5"->{
    Cell[233647, 7725, 88, 1, 70, "ObjectName",
      CellTags->{"1.2.3.5.1", "1.2.3.5"}],
    Cell[233738, 7728, 321, 9, 70, "Usage",
      CellTags->{"1.2.3.5.2", "1.2.3.5"}],
    Cell[234062, 7739, 1141, 31, 70, "Notes",
      CellTags->{"1.2.3.5.3", "1.2.3.5"}]},
  "1.2.3.5.2"->{
    Cell[233738, 7728, 321, 9, 70, "Usage",
      CellTags->{"1.2.3.5.2", "1.2.3.5"}]},
  "1.2.3.5.3"->{
    Cell[234062, 7739, 1141, 31, 70, "Notes",
      CellTags->{"1.2.3.5.3", "1.2.3.5"}]},
  "1.2.3.6.1"->{
    Cell[235240, 7775, 86, 1, 70, "ObjectName",
      CellTags->{"1.2.3.6.1", "1.2.3.6"}]},
  "1.2.3.6"->{
    Cell[235240, 7775, 86, 1, 70, "ObjectName",
      CellTags->{"1.2.3.6.1", "1.2.3.6"}],
    Cell[235329, 7778, 311, 9, 70, "Usage",
      CellTags->{"1.2.3.6.2", "1.2.3.6"}],
    Cell[235643, 7789, 1143, 28, 70, "Notes",
      CellTags->{"1.2.3.6.3", "1.2.3.6"}]},
  "1.2.3.6.2"->{
    Cell[235329, 7778, 311, 9, 70, "Usage",
      CellTags->{"1.2.3.6.2", "1.2.3.6"}]},
  "1.2.3.6.3"->{
    Cell[235643, 7789, 1143, 28, 70, "Notes",
      CellTags->{"1.2.3.6.3", "1.2.3.6"}]},
  "1.2.4.1.1"->{
    Cell[236906, 7827, 69, 1, 70, "ObjectName",
      CellTags->{"1.2.4.1.1", "1.2.4.1"}]},
  "1.2.4.1"->{
    Cell[236906, 7827, 69, 1, 70, "ObjectName",
      CellTags->{"1.2.4.1.1", "1.2.4.1"}],
    Cell[236978, 7830, 234, 8, 70, "Usage",
      CellTags->{"1.2.4.1.2", "1.2.4.1"}],
    Cell[237215, 7840, 614, 19, 70, "Notes",
      CellTags->{"1.2.4.1.3", "1.2.4.1"}]},
  "1.2.4.1.2"->{
    Cell[236978, 7830, 234, 8, 70, "Usage",
      CellTags->{"1.2.4.1.2", "1.2.4.1"}]},
  "1.2.4.1.3"->{
    Cell[237215, 7840, 614, 19, 70, "Notes",
      CellTags->{"1.2.4.1.3", "1.2.4.1"}]},
  "1.2.4.2.1"->{
    Cell[237866, 7864, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.4.2.1", "1.2.4.2"}]},
  "1.2.4.2"->{
    Cell[237866, 7864, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.4.2.1", "1.2.4.2"}],
    Cell[237939, 7867, 293, 9, 70, "Usage",
      CellTags->{"1.2.4.2.2", "1.2.4.2"}],
    Cell[238235, 7878, 1526, 40, 70, "Notes",
      CellTags->{"1.2.4.2.3", "1.2.4.2"}]},
  "1.2.4.2.2"->{
    Cell[237939, 7867, 293, 9, 70, "Usage",
      CellTags->{"1.2.4.2.2", "1.2.4.2"}]},
  "1.2.4.2.3"->{
    Cell[238235, 7878, 1526, 40, 70, "Notes",
      CellTags->{"1.2.4.2.3", "1.2.4.2"}]},
  "1.2.4.3.1"->{
    Cell[239798, 7923, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.4.3.1", "1.2.4.3"}]},
  "1.2.4.3"->{
    Cell[239798, 7923, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.4.3.1", "1.2.4.3"}],
    Cell[239871, 7926, 258, 8, 70, "Usage",
      CellTags->{"1.2.4.3.2", "1.2.4.3"}],
    Cell[240132, 7936, 711, 22, 70, "Notes",
      CellTags->{"1.2.4.3.3", "1.2.4.3"}]},
  "1.2.4.3.2"->{
    Cell[239871, 7926, 258, 8, 70, "Usage",
      CellTags->{"1.2.4.3.2", "1.2.4.3"}]},
  "1.2.4.3.3"->{
    Cell[240132, 7936, 711, 22, 70, "Notes",
      CellTags->{"1.2.4.3.3", "1.2.4.3"}]},
  "1.2.4.4.1"->{
    Cell[240880, 7963, 72, 1, 70, "ObjectName",
      CellTags->{"1.2.4.4.1", "1.2.4.4"}]},
  "1.2.4.4"->{
    Cell[240880, 7963, 72, 1, 70, "ObjectName",
      CellTags->{"1.2.4.4.1", "1.2.4.4"}],
    Cell[240955, 7966, 247, 8, 70, "Usage",
      CellTags->{"1.2.4.4.2", "1.2.4.4"}],
    Cell[241205, 7976, 1330, 37, 70, "Notes",
      CellTags->{"1.2.4.4.3", "1.2.4.4"}]},
  "1.2.4.4.2"->{
    Cell[240955, 7966, 247, 8, 70, "Usage",
      CellTags->{"1.2.4.4.2", "1.2.4.4"}]},
  "1.2.4.4.3"->{
    Cell[241205, 7976, 1330, 37, 70, "Notes",
      CellTags->{"1.2.4.4.3", "1.2.4.4"}]},
  "1.2.4.5.1"->{
    Cell[242572, 8018, 69, 1, 70, "ObjectName",
      CellTags->{"1.2.4.5.1", "1.2.4.5"}]},
  "1.2.4.5"->{
    Cell[242572, 8018, 69, 1, 70, "ObjectName",
      CellTags->{"1.2.4.5.1", "1.2.4.5"}],
    Cell[242644, 8021, 233, 6, 70, "Usage",
      CellTags->{"1.2.4.5.2", "1.2.4.5"}],
    Cell[242880, 8029, 1382, 42, 70, "Notes",
      CellTags->{"1.2.4.5.3", "1.2.4.5"}]},
  "1.2.4.5.2"->{
    Cell[242644, 8021, 233, 6, 70, "Usage",
      CellTags->{"1.2.4.5.2", "1.2.4.5"}]},
  "1.2.4.5.3"->{
    Cell[242880, 8029, 1382, 42, 70, "Notes",
      CellTags->{"1.2.4.5.3", "1.2.4.5"}]},
  "1.2.5.1.1"->{
    Cell[244380, 8081, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.5.1.1", "1.2.5.1"}]},
  "1.2.5.1"->{
    Cell[244380, 8081, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.5.1.1", "1.2.5.1"}],
    Cell[244453, 8084, 247, 8, 70, "Usage",
      CellTags->{"1.2.5.1.2", "1.2.5.1"}],
    Cell[244703, 8094, 1669, 46, 70, "Notes",
      CellTags->{"1.2.5.1.3", "1.2.5.1"}]},
  "1.2.5.1.2"->{
    Cell[244453, 8084, 247, 8, 70, "Usage",
      CellTags->{"1.2.5.1.2", "1.2.5.1"}]},
  "1.2.5.1.3"->{
    Cell[244703, 8094, 1669, 46, 70, "Notes",
      CellTags->{"1.2.5.1.3", "1.2.5.1"}]},
  "1.2.5.2.1"->{
    Cell[246409, 8145, 73, 1, 70, "ObjectName",
      CellTags->{"1.2.5.2.1", "1.2.5.2"}]},
  "1.2.5.2"->{
    Cell[246409, 8145, 73, 1, 70, "ObjectName",
      CellTags->{"1.2.5.2.1", "1.2.5.2"}],
    Cell[246485, 8148, 226, 6, 70, "Usage",
      CellTags->{"1.2.5.2.2", "1.2.5.2"}],
    Cell[246714, 8156, 2879, 91, 70, "Notes",
      CellTags->{"1.2.5.2.3", "1.2.5.2"}]},
  "1.2.5.2.2"->{
    Cell[246485, 8148, 226, 6, 70, "Usage",
      CellTags->{"1.2.5.2.2", "1.2.5.2"}]},
  "1.2.5.2.3"->{
    Cell[246714, 8156, 2879, 91, 70, "Notes",
      CellTags->{"1.2.5.2.3", "1.2.5.2"}]},
  "1.2.5.3.1"->{
    Cell[249630, 8252, 71, 1, 70, "ObjectName",
      CellTags->{"1.2.5.3.1", "1.2.5.3"}]},
  "1.2.5.3"->{
    Cell[249630, 8252, 71, 1, 70, "ObjectName",
      CellTags->{"1.2.5.3.1", "1.2.5.3"}],
    Cell[249704, 8255, 241, 7, 70, "Usage",
      CellTags->{"1.2.5.3.2", "1.2.5.3"}],
    Cell[249948, 8264, 1851, 34, 70, "Notes",
      CellTags->{"1.2.5.3.3", "1.2.5.3"}],
    Cell[251802, 8300, 820, 25, 70, "Notes",
      CellTags->{"1.2.5.3.5", "1.2.5.3"}]},
  "1.2.5.3.2"->{
    Cell[249704, 8255, 241, 7, 70, "Usage",
      CellTags->{"1.2.5.3.2", "1.2.5.3"}]},
  "1.2.5.3.3"->{
    Cell[249948, 8264, 1851, 34, 70, "Notes",
      CellTags->{"1.2.5.3.3", "1.2.5.3"}]},
  "1.2.5.3.5"->{
    Cell[251802, 8300, 820, 25, 70, "Notes",
      CellTags->{"1.2.5.3.5", "1.2.5.3"}]},
  "1.2.5.4.1"->{
    Cell[252659, 8330, 74, 1, 70, "ObjectName",
      CellTags->{"1.2.5.4.1", "1.2.5.4"}]},
  "1.2.5.4"->{
    Cell[252659, 8330, 74, 1, 70, "ObjectName",
      CellTags->{"1.2.5.4.1", "1.2.5.4"}],
    Cell[252736, 8333, 236, 7, 70, "Usage",
      CellTags->{"1.2.5.4.2", "1.2.5.4"}],
    Cell[252975, 8342, 1028, 33, 70, "Notes",
      CellTags->{"1.2.5.4.3", "1.2.5.4"}]},
  "1.2.5.4.2"->{
    Cell[252736, 8333, 236, 7, 70, "Usage",
      CellTags->{"1.2.5.4.2", "1.2.5.4"}]},
  "1.2.5.4.3"->{
    Cell[252975, 8342, 1028, 33, 70, "Notes",
      CellTags->{"1.2.5.4.3", "1.2.5.4"}]},
  "1.2.5.5.1"->{
    Cell[254040, 8380, 80, 1, 70, "ObjectName",
      CellTags->{"1.2.5.5.1", "1.2.5.5"}]},
  "1.2.5.5"->{
    Cell[254040, 8380, 80, 1, 70, "ObjectName",
      CellTags->{"1.2.5.5.1", "1.2.5.5"}],
    Cell[254123, 8383, 277, 9, 70, "Usage",
      CellTags->{"1.2.5.5.2", "1.2.5.5"}],
    Cell[254403, 8394, 582, 16, 70, "Notes",
      CellTags->{"1.2.5.5.3", "1.2.5.5"}]},
  "1.2.5.5.2"->{
    Cell[254123, 8383, 277, 9, 70, "Usage",
      CellTags->{"1.2.5.5.2", "1.2.5.5"}]},
  "1.2.5.5.3"->{
    Cell[254403, 8394, 582, 16, 70, "Notes",
      CellTags->{"1.2.5.5.3", "1.2.5.5"}]},
  "1.2.5.6.1"->{
    Cell[255022, 8415, 77, 1, 70, "ObjectName",
      CellTags->{"1.2.5.6.1", "1.2.5.6"}]},
  "1.2.5.6"->{
    Cell[255022, 8415, 77, 1, 70, "ObjectName",
      CellTags->{"1.2.5.6.1", "1.2.5.6"}],
    Cell[255102, 8418, 264, 7, 70, "Usage",
      CellTags->{"1.2.5.6.2", "1.2.5.6"}],
    Cell[255369, 8427, 1254, 33, 70, "Notes",
      CellTags->{"1.2.5.6.3", "1.2.5.6"}]},
  "1.2.5.6.2"->{
    Cell[255102, 8418, 264, 7, 70, "Usage",
      CellTags->{"1.2.5.6.2", "1.2.5.6"}]},
  "1.2.5.6.3"->{
    Cell[255369, 8427, 1254, 33, 70, "Notes",
      CellTags->{"1.2.5.6.3", "1.2.5.6"}]},
  "1.2.5.7.1"->{
    Cell[256660, 8465, 74, 1, 70, "ObjectName",
      CellTags->{"1.2.5.7.1", "1.2.5.7"}]},
  "1.2.5.7"->{
    Cell[256660, 8465, 74, 1, 70, "ObjectName",
      CellTags->{"1.2.5.7.1", "1.2.5.7"}],
    Cell[256737, 8468, 282, 8, 70, "Usage",
      CellTags->{"1.2.5.7.2", "1.2.5.7"}],
    Cell[257022, 8478, 858, 27, 70, "Notes",
      CellTags->{"1.2.5.7.3", "1.2.5.7"}]},
  "1.2.5.7.2"->{
    Cell[256737, 8468, 282, 8, 70, "Usage",
      CellTags->{"1.2.5.7.2", "1.2.5.7"}]},
  "1.2.5.7.3"->{
    Cell[257022, 8478, 858, 27, 70, "Notes",
      CellTags->{"1.2.5.7.3", "1.2.5.7"}]},
  "1.2.5.8.1"->{
    Cell[257917, 8510, 73, 1, 70, "ObjectName",
      CellTags->{"1.2.5.8.1", "1.2.5.8"}]},
  "1.2.5.8"->{
    Cell[257917, 8510, 73, 1, 70, "ObjectName",
      CellTags->{"1.2.5.8.1", "1.2.5.8"}],
    Cell[257993, 8513, 245, 6, 70, "Usage",
      CellTags->{"1.2.5.8.2", "1.2.5.8"}],
    Cell[258241, 8521, 838, 27, 70, "Notes",
      CellTags->{"1.2.5.8.3", "1.2.5.8"}]},
  "1.2.5.8.2"->{
    Cell[257993, 8513, 245, 6, 70, "Usage",
      CellTags->{"1.2.5.8.2", "1.2.5.8"}]},
  "1.2.5.8.3"->{
    Cell[258241, 8521, 838, 27, 70, "Notes",
      CellTags->{"1.2.5.8.3", "1.2.5.8"}]},
  "1.2.5.9.1"->{
    Cell[259116, 8553, 71, 1, 70, "ObjectName",
      CellTags->{"1.2.5.9.1", "1.2.5.9"}]},
  "1.2.5.9"->{
    Cell[259116, 8553, 71, 1, 70, "ObjectName",
      CellTags->{"1.2.5.9.1", "1.2.5.9"}],
    Cell[259190, 8556, 241, 7, 70, "Usage",
      CellTags->{"1.2.5.9.2", "1.2.5.9"}],
    Cell[259434, 8565, 975, 27, 70, "Notes",
      CellTags->{"1.2.5.9.3", "1.2.5.9"}]},
  "1.2.5.9.2"->{
    Cell[259190, 8556, 241, 7, 70, "Usage",
      CellTags->{"1.2.5.9.2", "1.2.5.9"}]},
  "1.2.5.9.3"->{
    Cell[259434, 8565, 975, 27, 70, "Notes",
      CellTags->{"1.2.5.9.3", "1.2.5.9"}]},
  "1.2.5.10.1"->{
    Cell[260446, 8597, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.5.10.1", "1.2.5.10"}]},
  "1.2.5.10"->{
    Cell[260446, 8597, 70, 1, 70, "ObjectName",
      CellTags->{"1.2.5.10.1", "1.2.5.10"}],
    Cell[260519, 8600, 262, 8, 70, "Usage",
      CellTags->{"1.2.5.10.2", "1.2.5.10"}],
    Cell[260784, 8610, 238, 6, 70, "Notes",
      CellTags->{"1.2.5.10.3", "1.2.5.10"}]},
  "1.2.5.10.2"->{
    Cell[260519, 8600, 262, 8, 70, "Usage",
      CellTags->{"1.2.5.10.2", "1.2.5.10"}]},
  "1.2.5.10.3"->{
    Cell[260784, 8610, 238, 6, 70, "Notes",
      CellTags->{"1.2.5.10.3", "1.2.5.10"}]},
  "1.2.5.12.1"->{
    Cell[261059, 8621, 133, 2, 70, "GroupObjectName",
      CellTags->{"1.2.5.12.1", "1.2.5.12"}]},
  "1.2.5.12"->{
    Cell[261059, 8621, 133, 2, 70, "GroupObjectName",
      CellTags->{"1.2.5.12.1", "1.2.5.12"}],
    Cell[261217, 8627, 95, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.1.1", "1.2.5.12"}],
    Cell[261315, 8630, 296, 8, 70, "Usage",
      CellTags->{"1.2.5.12.1.2", "1.2.5.12"}],
    Cell[261614, 8640, 530, 11, 70, "Notes",
      CellTags->{"1.2.5.12.1.3", "1.2.5.12"}],
    Cell[262181, 8656, 93, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.2.1", "1.2.5.12"}],
    Cell[262277, 8659, 270, 8, 70, "Usage",
      CellTags->{"1.2.5.12.2.2", "1.2.5.12"}],
    Cell[262550, 8669, 628, 12, 70, "Notes",
      CellTags->{"1.2.5.12.2.3", "1.2.5.12"}],
    Cell[263215, 8686, 95, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.3.1", "1.2.5.12"}],
    Cell[263313, 8689, 310, 9, 70, "Usage",
      CellTags->{"1.2.5.12.3.2", "1.2.5.12"}],
    Cell[263626, 8700, 669, 15, 70, "Notes",
      CellTags->{"1.2.5.12.3.3", "1.2.5.12"}],
    Cell[264332, 8720, 91, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.4.1", "1.2.5.12"}],
    Cell[264426, 8723, 305, 9, 70, "Usage",
      CellTags->{"1.2.5.12.4.2", "1.2.5.12"}],
    Cell[264734, 8734, 571, 12, 70, "Notes",
      CellTags->{"1.2.5.12.4.3", "1.2.5.12"}],
    Cell[265342, 8751, 79, 1, 70, "SubObjectNameClosed",
      CellTags->"1.2.5.12"],
    Cell[265424, 8754, 263, 7, 70, "Usage",
      CellTags->"1.2.5.12"],
    Cell[265690, 8763, 305, 8, 70, "Notes",
      CellTags->"1.2.5.12"],
    Cell[265998, 8773, 420, 12, 70, "Notes",
      CellTags->"1.2.5.12"],
    Cell[266421, 8787, 216, 6, 70, "Notes",
      CellTags->"1.2.5.12"],
    Cell[266674, 8798, 99, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.5.1", "1.2.5.12"}],
    Cell[266776, 8801, 297, 9, 70, "Usage",
      CellTags->{"1.2.5.12.5.2", "1.2.5.12"}],
    Cell[267076, 8812, 280, 6, 70, "Notes",
      CellTags->{"1.2.5.12.5.3", "1.2.5.12"}],
    Cell[267393, 8823, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.6.1", "1.2.5.12"}],
    Cell[267488, 8826, 292, 7, 70, "Usage",
      CellTags->{"1.2.5.12.6.2", "1.2.5.12"}],
    Cell[267783, 8835, 831, 16, 70, "Notes",
      CellTags->{"1.2.5.12.6.3", "1.2.5.12"}]},
  "1.2.5.12.1.1"->{
    Cell[261217, 8627, 95, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.1.1", "1.2.5.12"}]},
  "1.2.5.12.1.2"->{
    Cell[261315, 8630, 296, 8, 70, "Usage",
      CellTags->{"1.2.5.12.1.2", "1.2.5.12"}]},
  "1.2.5.12.1.3"->{
    Cell[261614, 8640, 530, 11, 70, "Notes",
      CellTags->{"1.2.5.12.1.3", "1.2.5.12"}]},
  "1.2.5.12.2.1"->{
    Cell[262181, 8656, 93, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.2.1", "1.2.5.12"}]},
  "1.2.5.12.2.2"->{
    Cell[262277, 8659, 270, 8, 70, "Usage",
      CellTags->{"1.2.5.12.2.2", "1.2.5.12"}]},
  "1.2.5.12.2.3"->{
    Cell[262550, 8669, 628, 12, 70, "Notes",
      CellTags->{"1.2.5.12.2.3", "1.2.5.12"}]},
  "1.2.5.12.3.1"->{
    Cell[263215, 8686, 95, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.3.1", "1.2.5.12"}]},
  "1.2.5.12.3.2"->{
    Cell[263313, 8689, 310, 9, 70, "Usage",
      CellTags->{"1.2.5.12.3.2", "1.2.5.12"}]},
  "1.2.5.12.3.3"->{
    Cell[263626, 8700, 669, 15, 70, "Notes",
      CellTags->{"1.2.5.12.3.3", "1.2.5.12"}]},
  "1.2.5.12.4.1"->{
    Cell[264332, 8720, 91, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.4.1", "1.2.5.12"}]},
  "1.2.5.12.4.2"->{
    Cell[264426, 8723, 305, 9, 70, "Usage",
      CellTags->{"1.2.5.12.4.2", "1.2.5.12"}]},
  "1.2.5.12.4.3"->{
    Cell[264734, 8734, 571, 12, 70, "Notes",
      CellTags->{"1.2.5.12.4.3", "1.2.5.12"}]},
  "1.2.5.12.5.1"->{
    Cell[266674, 8798, 99, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.5.1", "1.2.5.12"}]},
  "1.2.5.12.5.2"->{
    Cell[266776, 8801, 297, 9, 70, "Usage",
      CellTags->{"1.2.5.12.5.2", "1.2.5.12"}]},
  "1.2.5.12.5.3"->{
    Cell[267076, 8812, 280, 6, 70, "Notes",
      CellTags->{"1.2.5.12.5.3", "1.2.5.12"}]},
  "1.2.5.12.6.1"->{
    Cell[267393, 8823, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.2.5.12.6.1", "1.2.5.12"}]},
  "1.2.5.12.6.2"->{
    Cell[267488, 8826, 292, 7, 70, "Usage",
      CellTags->{"1.2.5.12.6.2", "1.2.5.12"}]},
  "1.2.5.12.6.3"->{
    Cell[267783, 8835, 831, 16, 70, "Notes",
      CellTags->{"1.2.5.12.6.3", "1.2.5.12"}]},
  "1.2.6.1.1"->{
    Cell[268743, 8862, 75, 1, 38, "ObjectName",
      CellTags->{"1.2.6.1.1", "1.2.6.1"}]},
  "1.2.6.1"->{
    Cell[268743, 8862, 75, 1, 38, "ObjectName",
      CellTags->{"1.2.6.1.1", "1.2.6.1"}],
    Cell[268821, 8865, 286, 9, 70, "Usage",
      CellTags->{"1.2.6.1.2", "1.2.6.1"}],
    Cell[269110, 8876, 404, 11, 70, "Notes",
      CellTags->{"1.2.6.1.3", "1.2.6.1"}]},
  "1.2.6.1.2"->{
    Cell[268821, 8865, 286, 9, 70, "Usage",
      CellTags->{"1.2.6.1.2", "1.2.6.1"}]},
  "1.2.6.1.3"->{
    Cell[269110, 8876, 404, 11, 70, "Notes",
      CellTags->{"1.2.6.1.3", "1.2.6.1"}]},
  "1.2.6.2.1"->{
    Cell[269551, 8892, 87, 1, 42, "ObjectName",
      CellTags->{"1.2.6.2.1", "1.2.6.2"}]},
  "1.2.6.2"->{
    Cell[269551, 8892, 87, 1, 42, "ObjectName",
      CellTags->{"1.2.6.2.1", "1.2.6.2"}],
    Cell[269641, 8895, 292, 9, 70, "Usage",
      CellTags->{"1.2.6.2.2", "1.2.6.2"}],
    Cell[269936, 8906, 195, 5, 70, "Notes",
      CellTags->{"1.2.6.2.3", "1.2.6.2"}]},
  "1.2.6.2.2"->{
    Cell[269641, 8895, 292, 9, 70, "Usage",
      CellTags->{"1.2.6.2.2", "1.2.6.2"}]},
  "1.2.6.2.3"->{
    Cell[269936, 8906, 195, 5, 70, "Notes",
      CellTags->{"1.2.6.2.3", "1.2.6.2"}]},
  "1.2.6.3.1"->{
    Cell[270168, 8916, 99, 1, 42, "ObjectName",
      CellTags->{"1.2.6.3.1", "1.2.6.3", "PrintingPageRange"}]},
  "1.2.6.3"->{
    Cell[270168, 8916, 99, 1, 42, "ObjectName",
      CellTags->{"1.2.6.3.1", "1.2.6.3", "PrintingPageRange"}],
    Cell[270270, 8919, 272, 7, 70, "Usage",
      CellTags->{"1.2.6.3.2", "1.2.6.3", "PrintingPageRange"}],
    Cell[270545, 8928, 798, 28, 70, "Notes",
      CellTags->{"1.2.6.3.3", "1.2.6.3", "PrintingPageRange"}]},
  "PrintingPageRange"->{
    Cell[270168, 8916, 99, 1, 42, "ObjectName",
      CellTags->{"1.2.6.3.1", "1.2.6.3", "PrintingPageRange"}],
    Cell[270270, 8919, 272, 7, 70, "Usage",
      CellTags->{"1.2.6.3.2", "1.2.6.3", "PrintingPageRange"}],
    Cell[270545, 8928, 798, 28, 70, "Notes",
      CellTags->{"1.2.6.3.3", "1.2.6.3", "PrintingPageRange"}]},
  "1.2.6.3.2"->{
    Cell[270270, 8919, 272, 7, 70, "Usage",
      CellTags->{"1.2.6.3.2", "1.2.6.3", "PrintingPageRange"}]},
  "1.2.6.3.3"->{
    Cell[270545, 8928, 798, 28, 70, "Notes",
      CellTags->{"1.2.6.3.3", "1.2.6.3", "PrintingPageRange"}]},
  "1.2.6.6.1"->{
    Cell[271380, 8961, 71, 1, 42, "ObjectName",
      CellTags->{"1.2.6.6.1", "1.2.6.6"}]},
  "1.2.6.6"->{
    Cell[271380, 8961, 71, 1, 42, "ObjectName",
      CellTags->{"1.2.6.6.1", "1.2.6.6"}],
    Cell[271454, 8964, 284, 7, 70, "Usage",
      CellTags->{"1.2.6.6.2", "1.2.6.6"}],
    Cell[271741, 8973, 3512, 124, 70, "Notes",
      CellTags->{"1.2.6.6.3", "1.2.6.6"}]},
  "1.2.6.6.2"->{
    Cell[271454, 8964, 284, 7, 70, "Usage",
      CellTags->{"1.2.6.6.2", "1.2.6.6"}]},
  "1.2.6.6.3"->{
    Cell[271741, 8973, 3512, 124, 70, "Notes",
      CellTags->{"1.2.6.6.3", "1.2.6.6"}]},
  "1.2.6.7.1"->{
    Cell[275290, 9102, 71, 1, 42, "ObjectName",
      CellTags->{"1.2.6.7.1", "1.2.6.7"}]},
  "1.2.6.7"->{
    Cell[275290, 9102, 71, 1, 42, "ObjectName",
      CellTags->{"1.2.6.7.1", "1.2.6.7"}],
    Cell[275364, 9105, 277, 9, 70, "Usage",
      CellTags->{"1.2.6.7.2", "1.2.6.7"}],
    Cell[275644, 9116, 2461, 89, 70, "Notes",
      CellTags->{"1.2.6.7.3", "1.2.6.7"}]},
  "1.2.6.7.2"->{
    Cell[275364, 9105, 277, 9, 70, "Usage",
      CellTags->{"1.2.6.7.2", "1.2.6.7"}]},
  "1.2.6.7.3"->{
    Cell[275644, 9116, 2461, 89, 70, "Notes",
      CellTags->{"1.2.6.7.3", "1.2.6.7"}]},
  "1.2.6.8.1"->{
    Cell[278142, 9210, 76, 1, 42, "ObjectName",
      CellTags->{"1.2.6.8.1", "1.2.6.8"}]},
  "1.2.6.8"->{
    Cell[278142, 9210, 76, 1, 42, "ObjectName",
      CellTags->{"1.2.6.8.1", "1.2.6.8"}],
    Cell[278221, 9213, 300, 9, 70, "Usage",
      CellTags->{"1.2.6.8.2", "1.2.6.8"}],
    Cell[278524, 9224, 442, 11, 70, "Notes",
      CellTags->{"1.2.6.8.3", "1.2.6.8"}]},
  "1.2.6.8.2"->{
    Cell[278221, 9213, 300, 9, 70, "Usage",
      CellTags->{"1.2.6.8.2", "1.2.6.8"}]},
  "1.2.6.8.3"->{
    Cell[278524, 9224, 442, 11, 70, "Notes",
      CellTags->{"1.2.6.8.3", "1.2.6.8"}]},
  "1.2.6.9.1"->{
    Cell[279003, 9240, 76, 1, 42, "ObjectName",
      CellTags->{"1.2.6.9.1", "1.2.6.9"}]},
  "1.2.6.9"->{
    Cell[279003, 9240, 76, 1, 42, "ObjectName",
      CellTags->{"1.2.6.9.1", "1.2.6.9"}],
    Cell[279082, 9243, 303, 9, 70, "Usage",
      CellTags->{"1.2.6.9.2", "1.2.6.9"}],
    Cell[279388, 9254, 454, 11, 70, "Notes",
      CellTags->{"1.2.6.9.3", "1.2.6.9"}]},
  "1.2.6.9.2"->{
    Cell[279082, 9243, 303, 9, 70, "Usage",
      CellTags->{"1.2.6.9.2", "1.2.6.9"}]},
  "1.2.6.9.3"->{
    Cell[279388, 9254, 454, 11, 70, "Notes",
      CellTags->{"1.2.6.9.3", "1.2.6.9"}]},
  "1.2.6.13.1"->{
    Cell[279879, 9270, 133, 2, 24, "GroupObjectName",
      CellTags->{"1.2.6.13.1", "1.2.6.13"}]},
  "1.2.6.13"->{
    Cell[279879, 9270, 133, 2, 24, "GroupObjectName",
      CellTags->{"1.2.6.13.1", "1.2.6.13"}],
    Cell[280037, 9276, 94, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.1.1", "1.2.6.13"}],
    Cell[280134, 9279, 299, 9, 70, "Usage",
      CellTags->{"1.2.6.13.1.2", "1.2.6.13"}],
    Cell[280436, 9290, 670, 15, 70, "Notes",
      CellTags->{"1.2.6.13.1.3", "1.2.6.13"}],
    Cell[281143, 9310, 95, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.2.1", "1.2.6.13"}],
    Cell[281241, 9313, 279, 8, 70, "Usage",
      CellTags->{"1.2.6.13.2.2", "1.2.6.13"}],
    Cell[281523, 9323, 439, 11, 70, "Notes",
      CellTags->{"1.2.6.13.2.3", "1.2.6.13"}],
    Cell[281999, 9339, 104, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.3.1", "1.2.6.13"}],
    Cell[282106, 9342, 294, 7, 70, "Usage",
      CellTags->{"1.2.6.13.3.2", "1.2.6.13"}],
    Cell[282403, 9351, 283, 6, 70, "Notes",
      CellTags->{"1.2.6.13.3.3", "1.2.6.13"}],
    Cell[282723, 9362, 100, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.4.1", "1.2.6.13"}],
    Cell[282826, 9365, 314, 9, 48, "Usage",
      CellTags->{"1.2.6.13.4.2", "1.2.6.13"}],
    Cell[283143, 9376, 731, 18, 94, "Notes",
      CellTags->{"1.2.6.13.4.3", "1.2.6.13"}],
    Cell[283911, 9399, 106, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.5.1", "1.2.6.13"}],
    Cell[284020, 9402, 324, 9, 70, "Usage",
      CellTags->{"1.2.6.13.5.2", "1.2.6.13"}],
    Cell[284347, 9413, 748, 16, 70, "Notes",
      CellTags->{"1.2.6.13.5.3", "1.2.6.13"}],
    Cell[285132, 9434, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.6.1", "1.2.6.13"}],
    Cell[285227, 9437, 319, 9, 70, "Usage",
      CellTags->{"1.2.6.13.6.2", "1.2.6.13"}],
    Cell[285549, 9448, 817, 20, 70, "Notes",
      CellTags->{"1.2.6.13.6.3", "1.2.6.13"}],
    Cell[286403, 9473, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.7.1", "1.2.6.13"}],
    Cell[286498, 9476, 319, 9, 70, "Usage",
      CellTags->{"1.2.6.13.7.2", "1.2.6.13"}],
    Cell[286820, 9487, 827, 20, 70, "Notes",
      CellTags->{"1.2.6.13.7.3", "1.2.6.13"}],
    Cell[287684, 9512, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.6.1", "1.2.6.13"}],
    Cell[287779, 9515, 289, 8, 70, "Usage",
      CellTags->{"1.2.6.13.6.2", "1.2.6.13"}],
    Cell[288071, 9525, 880, 22, 70, "Notes",
      CellTags->{"1.2.6.13.6.3", "1.2.6.13"}],
    Cell[288988, 9552, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.7.1", "1.2.6.13"}],
    Cell[289083, 9555, 291, 8, 70, "Usage",
      CellTags->{"1.2.6.13.7.2", "1.2.6.13"}],
    Cell[289377, 9565, 890, 23, 70, "Notes",
      CellTags->{"1.2.6.13.7.3", "1.2.6.13"}],
    Cell[290304, 9593, 89, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.8.1", "1.2.6.13"}],
    Cell[290396, 9596, 304, 9, 70, "Usage",
      CellTags->{"1.2.6.13.8.2", "1.2.6.13"}],
    Cell[290703, 9607, 689, 15, 70, "Notes",
      CellTags->{"1.2.6.13.8.3", "1.2.6.13"}],
    Cell[291429, 9627, 91, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.9.1", "1.2.6.13"}],
    Cell[291523, 9630, 289, 8, 48, "Usage",
      CellTags->{"1.2.6.13.9.2", "1.2.6.13"}],
    Cell[291815, 9640, 201, 6, 24, "Notes",
      CellTags->{"1.2.6.13.9.3", "1.2.6.13"}],
    Cell[292053, 9651, 101, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[292157, 9654, 275, 8, 70, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[292435, 9664, 478, 15, 70, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[292950, 9684, 98, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[293051, 9687, 335, 9, 48, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[293389, 9698, 645, 17, 100, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[294071, 9720, 114, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[294188, 9723, 322, 9, 70, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[294513, 9734, 307, 7, 70, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[294857, 9746, 99, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[294959, 9749, 312, 7, 48, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[295274, 9758, 829, 19, 116, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[296140, 9782, 102, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[296245, 9785, 320, 9, 48, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[296568, 9796, 740, 15, 116, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[297345, 9816, 103, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[297451, 9819, 296, 7, 70, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[297750, 9828, 622, 15, 70, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[298409, 9848, 106, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[298518, 9851, 317, 9, 70, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[298838, 9862, 300, 7, 70, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[299175, 9874, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.11.1", "1.2.6.13"}],
    Cell[299270, 9877, 299, 9, 70, "Usage",
      CellTags->{"1.2.6.13.11.2", "1.2.6.13"}],
    Cell[299572, 9888, 346, 9, 70, "Notes",
      CellTags->{"1.2.6.13.11.3", "1.2.6.13"}],
    Cell[299955, 9902, 212, 8, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.4.1", "1.2.6.13"}],
    Cell[300170, 9912, 297, 7, 70, "Usage",
      CellTags->{"1.2.6.4.2", "1.2.6.13"}],
    Cell[300470, 9921, 403, 15, 70, "Notes",
      CellTags->{"1.2.6.4.3", "1.2.6.13"}],
    Cell[300910, 9941, 203, 7, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.5.1", "1.2.6.13"}],
    Cell[301116, 9950, 294, 7, 70, "Usage",
      CellTags->{"1.2.6.5.2", "1.2.6.13"}],
    Cell[301413, 9959, 442, 17, 70, "Notes",
      CellTags->{"1.2.6.5.3", "1.2.6.13"}],
    Cell[301892, 9981, 96, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.12.1", "1.2.6.12", "1.2.6.13"}],
    Cell[301991, 9984, 268, 7, 70, "Usage",
      CellTags->{"1.2.6.12.2", "1.2.6.12", "1.2.6.13"}],
    Cell[302262, 9993, 498, 18, 70, "Notes",
      CellTags->{"1.2.6.12.3", "1.2.6.12", "1.2.6.13"}],
    Cell[302797, 10016, 87, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.13.1", "1.2.6.13"}],
    Cell[302887, 10019, 243, 7, 70, "Usage",
      CellTags->{"1.2.6.13.13.2", "1.2.6.13"}],
    Cell[303133, 10028, 881, 28, 70, "Notes",
      CellTags->{"1.2.6.13.13.3", "1.2.6.13"}],
    Cell[304051, 10061, 94, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.12.1", "1.2.6.13"}],
    Cell[304148, 10064, 257, 7, 70, "Usage",
      CellTags->{"1.2.6.13.12.2", "1.2.6.13"}],
    Cell[304408, 10073, 762, 31, 70, "Notes",
      CellTags->{"1.2.6.13.12.3", "1.2.6.13"}],
    Cell[305207, 10109, 105, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.10.1", "1.2.6.10", "1.2.6.13"}],
    Cell[305315, 10112, 264, 7, 70, "Usage",
      CellTags->{"1.2.6.10.2", "1.2.6.10", "1.2.6.13"}],
    Cell[305582, 10121, 621, 19, 70, "Notes",
      CellTags->{"1.2.6.10", "1.2.6.13"}],
    Cell[306240, 10145, 105, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.11.1", "1.2.6.11", "1.2.6.13"}],
    Cell[306348, 10148, 264, 7, 70, "Usage",
      CellTags->{"1.2.6.11.2", "1.2.6.11", "1.2.6.13"}],
    Cell[306615, 10157, 635, 19, 70, "Notes",
      CellTags->{"1.2.6.11.3", "1.2.6.11", "1.2.6.13"}]},
  "1.2.6.13.1.1"->{
    Cell[280037, 9276, 94, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.1.1", "1.2.6.13"}]},
  "1.2.6.13.1.2"->{
    Cell[280134, 9279, 299, 9, 70, "Usage",
      CellTags->{"1.2.6.13.1.2", "1.2.6.13"}]},
  "1.2.6.13.1.3"->{
    Cell[280436, 9290, 670, 15, 70, "Notes",
      CellTags->{"1.2.6.13.1.3", "1.2.6.13"}]},
  "1.2.6.13.2.1"->{
    Cell[281143, 9310, 95, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.2.1", "1.2.6.13"}]},
  "1.2.6.13.2.2"->{
    Cell[281241, 9313, 279, 8, 70, "Usage",
      CellTags->{"1.2.6.13.2.2", "1.2.6.13"}]},
  "1.2.6.13.2.3"->{
    Cell[281523, 9323, 439, 11, 70, "Notes",
      CellTags->{"1.2.6.13.2.3", "1.2.6.13"}]},
  "1.2.6.13.3.1"->{
    Cell[281999, 9339, 104, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.3.1", "1.2.6.13"}]},
  "1.2.6.13.3.2"->{
    Cell[282106, 9342, 294, 7, 70, "Usage",
      CellTags->{"1.2.6.13.3.2", "1.2.6.13"}]},
  "1.2.6.13.3.3"->{
    Cell[282403, 9351, 283, 6, 70, "Notes",
      CellTags->{"1.2.6.13.3.3", "1.2.6.13"}]},
  "1.2.6.13.4.1"->{
    Cell[282723, 9362, 100, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.4.1", "1.2.6.13"}]},
  "1.2.6.13.4.2"->{
    Cell[282826, 9365, 314, 9, 48, "Usage",
      CellTags->{"1.2.6.13.4.2", "1.2.6.13"}]},
  "1.2.6.13.4.3"->{
    Cell[283143, 9376, 731, 18, 94, "Notes",
      CellTags->{"1.2.6.13.4.3", "1.2.6.13"}]},
  "1.2.6.13.5.1"->{
    Cell[283911, 9399, 106, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.5.1", "1.2.6.13"}]},
  "1.2.6.13.5.2"->{
    Cell[284020, 9402, 324, 9, 70, "Usage",
      CellTags->{"1.2.6.13.5.2", "1.2.6.13"}]},
  "1.2.6.13.5.3"->{
    Cell[284347, 9413, 748, 16, 70, "Notes",
      CellTags->{"1.2.6.13.5.3", "1.2.6.13"}]},
  "1.2.6.13.6.1"->{
    Cell[285132, 9434, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.6.1", "1.2.6.13"}],
    Cell[287684, 9512, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.6.1", "1.2.6.13"}]},
  "1.2.6.13.6.2"->{
    Cell[285227, 9437, 319, 9, 70, "Usage",
      CellTags->{"1.2.6.13.6.2", "1.2.6.13"}],
    Cell[287779, 9515, 289, 8, 70, "Usage",
      CellTags->{"1.2.6.13.6.2", "1.2.6.13"}]},
  "1.2.6.13.6.3"->{
    Cell[285549, 9448, 817, 20, 70, "Notes",
      CellTags->{"1.2.6.13.6.3", "1.2.6.13"}],
    Cell[288071, 9525, 880, 22, 70, "Notes",
      CellTags->{"1.2.6.13.6.3", "1.2.6.13"}]},
  "1.2.6.13.7.1"->{
    Cell[286403, 9473, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.7.1", "1.2.6.13"}],
    Cell[288988, 9552, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.7.1", "1.2.6.13"}]},
  "1.2.6.13.7.2"->{
    Cell[286498, 9476, 319, 9, 70, "Usage",
      CellTags->{"1.2.6.13.7.2", "1.2.6.13"}],
    Cell[289083, 9555, 291, 8, 70, "Usage",
      CellTags->{"1.2.6.13.7.2", "1.2.6.13"}]},
  "1.2.6.13.7.3"->{
    Cell[286820, 9487, 827, 20, 70, "Notes",
      CellTags->{"1.2.6.13.7.3", "1.2.6.13"}],
    Cell[289377, 9565, 890, 23, 70, "Notes",
      CellTags->{"1.2.6.13.7.3", "1.2.6.13"}]},
  "1.2.6.13.8.1"->{
    Cell[290304, 9593, 89, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.8.1", "1.2.6.13"}]},
  "1.2.6.13.8.2"->{
    Cell[290396, 9596, 304, 9, 70, "Usage",
      CellTags->{"1.2.6.13.8.2", "1.2.6.13"}]},
  "1.2.6.13.8.3"->{
    Cell[290703, 9607, 689, 15, 70, "Notes",
      CellTags->{"1.2.6.13.8.3", "1.2.6.13"}]},
  "1.2.6.13.9.1"->{
    Cell[291429, 9627, 91, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.9.1", "1.2.6.13"}]},
  "1.2.6.13.9.2"->{
    Cell[291523, 9630, 289, 8, 48, "Usage",
      CellTags->{"1.2.6.13.9.2", "1.2.6.13"}]},
  "1.2.6.13.9.3"->{
    Cell[291815, 9640, 201, 6, 24, "Notes",
      CellTags->{"1.2.6.13.9.3", "1.2.6.13"}]},
  "1.2.6.13.10.1"->{
    Cell[292053, 9651, 101, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[292950, 9684, 98, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[294071, 9720, 114, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[294857, 9746, 99, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[296140, 9782, 102, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[297345, 9816, 103, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}],
    Cell[298409, 9848, 106, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.10.1", "1.2.6.13"}]},
  "1.2.6.13.10.2"->{
    Cell[292157, 9654, 275, 8, 70, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[293051, 9687, 335, 9, 48, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[294188, 9723, 322, 9, 70, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[294959, 9749, 312, 7, 48, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[296245, 9785, 320, 9, 48, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[297451, 9819, 296, 7, 70, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}],
    Cell[298518, 9851, 317, 9, 70, "Usage",
      CellTags->{"1.2.6.13.10.2", "1.2.6.13"}]},
  "1.2.6.13.10.3"->{
    Cell[292435, 9664, 478, 15, 70, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[293389, 9698, 645, 17, 100, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[294513, 9734, 307, 7, 70, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[295274, 9758, 829, 19, 116, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[296568, 9796, 740, 15, 116, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[297750, 9828, 622, 15, 70, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}],
    Cell[298838, 9862, 300, 7, 70, "Notes",
      CellTags->{"1.2.6.13.10.3", "1.2.6.13"}]},
  "1.2.6.13.11.1"->{
    Cell[299175, 9874, 92, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.11.1", "1.2.6.13"}]},
  "1.2.6.13.11.2"->{
    Cell[299270, 9877, 299, 9, 70, "Usage",
      CellTags->{"1.2.6.13.11.2", "1.2.6.13"}]},
  "1.2.6.13.11.3"->{
    Cell[299572, 9888, 346, 9, 70, "Notes",
      CellTags->{"1.2.6.13.11.3", "1.2.6.13"}]},
  "1.2.6.4.1"->{
    Cell[299955, 9902, 212, 8, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.4.1", "1.2.6.13"}]},
  "1.2.6.4.2"->{
    Cell[300170, 9912, 297, 7, 70, "Usage",
      CellTags->{"1.2.6.4.2", "1.2.6.13"}]},
  "1.2.6.4.3"->{
    Cell[300470, 9921, 403, 15, 70, "Notes",
      CellTags->{"1.2.6.4.3", "1.2.6.13"}]},
  "1.2.6.5.1"->{
    Cell[300910, 9941, 203, 7, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.5.1", "1.2.6.13"}]},
  "1.2.6.5.2"->{
    Cell[301116, 9950, 294, 7, 70, "Usage",
      CellTags->{"1.2.6.5.2", "1.2.6.13"}]},
  "1.2.6.5.3"->{
    Cell[301413, 9959, 442, 17, 70, "Notes",
      CellTags->{"1.2.6.5.3", "1.2.6.13"}]},
  "1.2.6.12.1"->{
    Cell[301892, 9981, 96, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.12.1", "1.2.6.12", "1.2.6.13"}]},
  "1.2.6.12"->{
    Cell[301892, 9981, 96, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.12.1", "1.2.6.12", "1.2.6.13"}],
    Cell[301991, 9984, 268, 7, 70, "Usage",
      CellTags->{"1.2.6.12.2", "1.2.6.12", "1.2.6.13"}],
    Cell[302262, 9993, 498, 18, 70, "Notes",
      CellTags->{"1.2.6.12.3", "1.2.6.12", "1.2.6.13"}]},
  "1.2.6.12.2"->{
    Cell[301991, 9984, 268, 7, 70, "Usage",
      CellTags->{"1.2.6.12.2", "1.2.6.12", "1.2.6.13"}]},
  "1.2.6.12.3"->{
    Cell[302262, 9993, 498, 18, 70, "Notes",
      CellTags->{"1.2.6.12.3", "1.2.6.12", "1.2.6.13"}]},
  "1.2.6.13.13.1"->{
    Cell[302797, 10016, 87, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.13.1", "1.2.6.13"}]},
  "1.2.6.13.13.2"->{
    Cell[302887, 10019, 243, 7, 70, "Usage",
      CellTags->{"1.2.6.13.13.2", "1.2.6.13"}]},
  "1.2.6.13.13.3"->{
    Cell[303133, 10028, 881, 28, 70, "Notes",
      CellTags->{"1.2.6.13.13.3", "1.2.6.13"}]},
  "1.2.6.13.12.1"->{
    Cell[304051, 10061, 94, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.13.12.1", "1.2.6.13"}]},
  "1.2.6.13.12.2"->{
    Cell[304148, 10064, 257, 7, 70, "Usage",
      CellTags->{"1.2.6.13.12.2", "1.2.6.13"}]},
  "1.2.6.13.12.3"->{
    Cell[304408, 10073, 762, 31, 70, "Notes",
      CellTags->{"1.2.6.13.12.3", "1.2.6.13"}]},
  "1.2.6.10.1"->{
    Cell[305207, 10109, 105, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.10.1", "1.2.6.10", "1.2.6.13"}]},
  "1.2.6.10"->{
    Cell[305207, 10109, 105, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.10.1", "1.2.6.10", "1.2.6.13"}],
    Cell[305315, 10112, 264, 7, 70, "Usage",
      CellTags->{"1.2.6.10.2", "1.2.6.10", "1.2.6.13"}],
    Cell[305582, 10121, 621, 19, 70, "Notes",
      CellTags->{"1.2.6.10", "1.2.6.13"}]},
  "1.2.6.10.2"->{
    Cell[305315, 10112, 264, 7, 70, "Usage",
      CellTags->{"1.2.6.10.2", "1.2.6.10", "1.2.6.13"}]},
  "1.2.6.11.1"->{
    Cell[306240, 10145, 105, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.11.1", "1.2.6.11", "1.2.6.13"}]},
  "1.2.6.11"->{
    Cell[306240, 10145, 105, 1, 21, "SubObjectNameClosed",
      CellTags->{"1.2.6.11.1", "1.2.6.11", "1.2.6.13"}],
    Cell[306348, 10148, 264, 7, 70, "Usage",
      CellTags->{"1.2.6.11.2", "1.2.6.11", "1.2.6.13"}],
    Cell[306615, 10157, 635, 19, 70, "Notes",
      CellTags->{"1.2.6.11.3", "1.2.6.11", "1.2.6.13"}]},
  "1.2.6.11.2"->{
    Cell[306348, 10148, 264, 7, 70, "Usage",
      CellTags->{"1.2.6.11.2", "1.2.6.11", "1.2.6.13"}]},
  "1.2.6.11.3"->{
    Cell[306615, 10157, 635, 19, 70, "Notes",
      CellTags->{"1.2.6.11.3", "1.2.6.11", "1.2.6.13"}]},
  "1.2.6.14"->{
    Cell[307311, 10183, 123, 2, 24, "GroupObjectName",
      CellTags->"1.2.6.14"]},
  "1.2.6.14.1"->{
    Cell[307459, 10189, 64, 1, 38, "ObjectName",
      CellTags->"1.2.6.14.1"],
    Cell[307526, 10192, 326, 11, 70, "Usage",
      CellTags->"1.2.6.14.1"],
    Cell[307855, 10205, 1809, 52, 70, "Notes",
      CellTags->"1.2.6.14.1"]},
  "1.2.6.14.1b"->{
    Cell[309701, 10262, 65, 1, 42, "ObjectName",
      CellTags->"1.2.6.14.1b"],
    Cell[309769, 10265, 329, 11, 70, "Usage",
      CellTags->"1.2.6.14.1b"],
    Cell[310101, 10278, 802, 19, 70, "Notes",
      CellTags->"1.2.6.14.1b"],
    Cell[310906, 10299, 457, 13, 70, "Notes",
      CellTags->"1.2.6.14.1b"],
    Cell[311366, 10314, 379, 10, 70, "Notes",
      CellTags->"1.2.6.14.1b"]},
  "1.2.5.11.1"->{
    Cell[311782, 10329, 81, 1, 42, "ObjectName",
      CellTags->{"1.2.5.11.1", "1.2.6.14.2"}],
    Cell[321967, 10662, 88, 1, 70, "ObjectName",
      CellTags->{"1.2.5.11.1", "1.2.6.15", "1.2.6.15.2"}]},
  "1.2.6.14.2"->{
    Cell[311782, 10329, 81, 1, 42, "ObjectName",
      CellTags->{"1.2.5.11.1", "1.2.6.14.2"}],
    Cell[311866, 10332, 326, 9, 70, "Usage",
      CellTags->{"1.2.5.11.2", "1.2.6.14.2"}],
    Cell[312195, 10343, 476, 11, 70, "Notes",
      CellTags->{"1.2.5.11.3", "1.2.6.14.2"}]},
  "1.2.5.11.2"->{
    Cell[311866, 10332, 326, 9, 70, "Usage",
      CellTags->{"1.2.5.11.2", "1.2.6.14.2"}],
    Cell[322058, 10665, 293, 7, 70, "Usage",
      CellTags->{"1.2.5.11.2", "1.2.6.15", "1.2.6.15.2"}]},
  "1.2.5.11.3"->{
    Cell[312195, 10343, 476, 11, 70, "Notes",
      CellTags->{"1.2.5.11.3", "1.2.6.14.2"}],
    Cell[322354, 10674, 262, 7, 70, "Notes",
      CellTags->{"1.2.5.11.3", "1.2.6.15", "1.2.6.15.2"}]},
  "1.2.6.14.1.1"->{
    Cell[312708, 10359, 83, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.1.1", "1.2.6.14.3"}],
    Cell[322653, 10686, 104, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.1.1", "1.2.6.15", "1.2.6.15.3"}]},
  "1.2.6.14.3"->{
    Cell[312708, 10359, 83, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.1.1", "1.2.6.14.3"}],
    Cell[312794, 10362, 309, 7, 70, "Usage",
      CellTags->{"1.2.6.14.1.2", "1.2.6.14.3"}],
    Cell[313106, 10371, 478, 15, 70, "Notes",
      CellTags->{"1.2.6.14.1.3", "1.2.6.14.3"}]},
  "1.2.6.14.1.2"->{
    Cell[312794, 10362, 309, 7, 70, "Usage",
      CellTags->{"1.2.6.14.1.2", "1.2.6.14.3"}],
    Cell[322760, 10689, 315, 7, 70, "Usage",
      CellTags->{"1.2.6.14.1.2", "1.2.6.15", "1.2.6.15.3"}]},
  "1.2.6.14.1.3"->{
    Cell[313106, 10371, 478, 15, 70, "Notes",
      CellTags->{"1.2.6.14.1.3", "1.2.6.14.3"}],
    Cell[323078, 10698, 216, 5, 70, "Notes",
      CellTags->{"1.2.6.14.1.3", "1.2.6.15", "1.2.6.15.3"}]},
  "1.2.6.14.2.1"->{
    Cell[313621, 10391, 100, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.2.1", "1.2.6.14.4"}],
    Cell[323331, 10708, 96, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.2.1", "1.2.6.15", "1.2.6.15.4"}]},
  "1.2.6.14.4"->{
    Cell[313621, 10391, 100, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.2.1", "1.2.6.14.4"}],
    Cell[313724, 10394, 331, 9, 48, "Usage",
      CellTags->{"1.2.6.14.2.2", "1.2.6.14.4"}],
    Cell[314058, 10405, 919, 22, 126, "Notes",
      CellTags->{"1.2.6.14.2.3", "1.2.6.14.4"}]},
  "1.2.6.14.2.2"->{
    Cell[313724, 10394, 331, 9, 48, "Usage",
      CellTags->{"1.2.6.14.2.2", "1.2.6.14.4"}],
    Cell[323430, 10711, 312, 7, 70, "Usage",
      CellTags->{"1.2.6.14.2.2", "1.2.6.15", "1.2.6.15.4"}]},
  "1.2.6.14.2.3"->{
    Cell[314058, 10405, 919, 22, 126, "Notes",
      CellTags->{"1.2.6.14.2.3", "1.2.6.14.4"}],
    Cell[323745, 10720, 257, 8, 70, "Notes",
      CellTags->{"1.2.6.14.2.3", "1.2.6.15", "1.2.6.15.4"}]},
  "1.2.6.14.3.1"->{
    Cell[315014, 10432, 95, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.14.5"}],
    Cell[316325, 10472, 89, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.14.6"}],
    Cell[317462, 10511, 91, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.14.7"}],
    Cell[324039, 10733, 99, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.5"}],
    Cell[324818, 10762, 92, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.6"}],
    Cell[325523, 10786, 91, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.7"}]},
  "1.2.6.14.5"->{
    Cell[315014, 10432, 95, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.14.5"}],
    Cell[315112, 10435, 364, 8, 64, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.14.5"}],
    Cell[315479, 10445, 809, 22, 94, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.14.5"}]},
  "1.2.6.14.3.2"->{
    Cell[315112, 10435, 364, 8, 64, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.14.5"}],
    Cell[316417, 10475, 337, 9, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.14.6"}],
    Cell[317556, 10514, 309, 7, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.14.7"}],
    Cell[324141, 10736, 377, 11, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.5"}],
    Cell[324913, 10765, 276, 7, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.6"}],
    Cell[325617, 10789, 282, 7, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.7"}]},
  "1.2.6.14.3.3"->{
    Cell[315479, 10445, 809, 22, 94, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.14.5"}],
    Cell[316757, 10486, 668, 20, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.14.6"}],
    Cell[317868, 10523, 664, 20, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.14.7"}],
    Cell[324521, 10749, 260, 8, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.5"}],
    Cell[325192, 10774, 294, 7, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.6"}],
    Cell[325902, 10798, 293, 7, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.7"}]},
  "1.2.6.14.6"->{
    Cell[316325, 10472, 89, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.14.6"}],
    Cell[316417, 10475, 337, 9, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.14.6"}],
    Cell[316757, 10486, 668, 20, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.14.6"}]},
  "1.2.6.14.7"->{
    Cell[317462, 10511, 91, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.14.7"}],
    Cell[317556, 10514, 309, 7, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.14.7"}],
    Cell[317868, 10523, 664, 20, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.14.7"}]},
  "1.2.6.14.4.1"->{
    Cell[318569, 10548, 82, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.4.1", "1.2.6.14.8"}]},
  "1.2.6.14.8"->{
    Cell[318569, 10548, 82, 1, 42, "ObjectName",
      CellTags->{"1.2.6.14.4.1", "1.2.6.14.8"}],
    Cell[318654, 10551, 367, 9, 70, "Usage",
      CellTags->{"1.2.6.14.4.2", "1.2.6.14.8"}],
    Cell[319024, 10562, 1471, 40, 70, "Notes",
      CellTags->{"1.2.6.14.4.3", "1.2.6.14.8"}]},
  "1.2.6.14.4.2"->{
    Cell[318654, 10551, 367, 9, 70, "Usage",
      CellTags->{"1.2.6.14.4.2", "1.2.6.14.8"}]},
  "1.2.6.14.4.3"->{
    Cell[319024, 10562, 1471, 40, 70, "Notes",
      CellTags->{"1.2.6.14.4.3", "1.2.6.14.8"}]},
  "1.2.6.15"->{
    Cell[320544, 10608, 121, 2, 24, "GroupObjectName",
      CellTags->"1.2.6.15"],
    Cell[320668, 10612, 240, 7, 70, "Text",
      CellTags->"1.2.6.15"],
    Cell[320933, 10623, 88, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.6.1", "1.2.6.15", "1.2.6.15.1"}],
    Cell[321024, 10626, 260, 7, 70, "Usage",
      CellTags->{"1.2.6.14.6.2", "1.2.6.15", "1.2.6.15.1"}],
    Cell[321287, 10635, 643, 22, 70, "Notes",
      CellTags->{"1.2.6.14.6.3", "1.2.6.15", "1.2.6.15.1"}],
    Cell[321967, 10662, 88, 1, 70, "ObjectName",
      CellTags->{"1.2.5.11.1", "1.2.6.15", "1.2.6.15.2"}],
    Cell[322058, 10665, 293, 7, 70, "Usage",
      CellTags->{"1.2.5.11.2", "1.2.6.15", "1.2.6.15.2"}],
    Cell[322354, 10674, 262, 7, 70, "Notes",
      CellTags->{"1.2.5.11.3", "1.2.6.15", "1.2.6.15.2"}],
    Cell[322653, 10686, 104, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.1.1", "1.2.6.15", "1.2.6.15.3"}],
    Cell[322760, 10689, 315, 7, 70, "Usage",
      CellTags->{"1.2.6.14.1.2", "1.2.6.15", "1.2.6.15.3"}],
    Cell[323078, 10698, 216, 5, 70, "Notes",
      CellTags->{"1.2.6.14.1.3", "1.2.6.15", "1.2.6.15.3"}],
    Cell[323331, 10708, 96, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.2.1", "1.2.6.15", "1.2.6.15.4"}],
    Cell[323430, 10711, 312, 7, 70, "Usage",
      CellTags->{"1.2.6.14.2.2", "1.2.6.15", "1.2.6.15.4"}],
    Cell[323745, 10720, 257, 8, 70, "Notes",
      CellTags->{"1.2.6.14.2.3", "1.2.6.15", "1.2.6.15.4"}],
    Cell[324039, 10733, 99, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.5"}],
    Cell[324141, 10736, 377, 11, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.5"}],
    Cell[324521, 10749, 260, 8, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.5"}],
    Cell[324818, 10762, 92, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.6"}],
    Cell[324913, 10765, 276, 7, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.6"}],
    Cell[325192, 10774, 294, 7, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.6"}],
    Cell[325523, 10786, 91, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.7"}],
    Cell[325617, 10789, 282, 7, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.7"}],
    Cell[325902, 10798, 293, 7, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.7"}]},
  "1.2.6.14.6.1"->{
    Cell[320933, 10623, 88, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.6.1", "1.2.6.15", "1.2.6.15.1"}]},
  "1.2.6.15.1"->{
    Cell[320933, 10623, 88, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.6.1", "1.2.6.15", "1.2.6.15.1"}],
    Cell[321024, 10626, 260, 7, 70, "Usage",
      CellTags->{"1.2.6.14.6.2", "1.2.6.15", "1.2.6.15.1"}],
    Cell[321287, 10635, 643, 22, 70, "Notes",
      CellTags->{"1.2.6.14.6.3", "1.2.6.15", "1.2.6.15.1"}]},
  "1.2.6.14.6.2"->{
    Cell[321024, 10626, 260, 7, 70, "Usage",
      CellTags->{"1.2.6.14.6.2", "1.2.6.15", "1.2.6.15.1"}]},
  "1.2.6.14.6.3"->{
    Cell[321287, 10635, 643, 22, 70, "Notes",
      CellTags->{"1.2.6.14.6.3", "1.2.6.15", "1.2.6.15.1"}]},
  "1.2.6.15.2"->{
    Cell[321967, 10662, 88, 1, 70, "ObjectName",
      CellTags->{"1.2.5.11.1", "1.2.6.15", "1.2.6.15.2"}],
    Cell[322058, 10665, 293, 7, 70, "Usage",
      CellTags->{"1.2.5.11.2", "1.2.6.15", "1.2.6.15.2"}],
    Cell[322354, 10674, 262, 7, 70, "Notes",
      CellTags->{"1.2.5.11.3", "1.2.6.15", "1.2.6.15.2"}]},
  "1.2.6.15.3"->{
    Cell[322653, 10686, 104, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.1.1", "1.2.6.15", "1.2.6.15.3"}],
    Cell[322760, 10689, 315, 7, 70, "Usage",
      CellTags->{"1.2.6.14.1.2", "1.2.6.15", "1.2.6.15.3"}],
    Cell[323078, 10698, 216, 5, 70, "Notes",
      CellTags->{"1.2.6.14.1.3", "1.2.6.15", "1.2.6.15.3"}]},
  "1.2.6.15.4"->{
    Cell[323331, 10708, 96, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.2.1", "1.2.6.15", "1.2.6.15.4"}],
    Cell[323430, 10711, 312, 7, 70, "Usage",
      CellTags->{"1.2.6.14.2.2", "1.2.6.15", "1.2.6.15.4"}],
    Cell[323745, 10720, 257, 8, 70, "Notes",
      CellTags->{"1.2.6.14.2.3", "1.2.6.15", "1.2.6.15.4"}]},
  "1.2.6.15.5"->{
    Cell[324039, 10733, 99, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.5"}],
    Cell[324141, 10736, 377, 11, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.5"}],
    Cell[324521, 10749, 260, 8, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.5"}]},
  "1.2.6.15.6"->{
    Cell[324818, 10762, 92, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.6"}],
    Cell[324913, 10765, 276, 7, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.6"}],
    Cell[325192, 10774, 294, 7, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.6"}]},
  "1.2.6.15.7"->{
    Cell[325523, 10786, 91, 1, 70, "ObjectName",
      CellTags->{"1.2.6.14.3.1", "1.2.6.15", "1.2.6.15.7"}],
    Cell[325617, 10789, 282, 7, 70, "Usage",
      CellTags->{"1.2.6.14.3.2", "1.2.6.15", "1.2.6.15.7"}],
    Cell[325902, 10798, 293, 7, 70, "Notes",
      CellTags->{"1.2.6.14.3.3", "1.2.6.15", "1.2.6.15.7"}]},
  "1.3.1.1.1"->{
    Cell[326437, 10822, 69, 1, 38, "ObjectName",
      CellTags->{"1.3.1.1.1", "1.3.1.1"}]},
  "1.3.1.1"->{
    Cell[326437, 10822, 69, 1, 38, "ObjectName",
      CellTags->{"1.3.1.1.1", "1.3.1.1"}],
    Cell[326509, 10825, 252, 8, 70, "Usage",
      CellTags->{"1.3.1.1.2", "1.3.1.1"}],
    Cell[326764, 10835, 2352, 77, 70, "Notes",
      CellTags->{"1.3.1.1.3", "1.3.1.1"}]},
  "1.3.1.1.2"->{
    Cell[326509, 10825, 252, 8, 70, "Usage",
      CellTags->{"1.3.1.1.2", "1.3.1.1"}]},
  "1.3.1.1.3"->{
    Cell[326764, 10835, 2352, 77, 70, "Notes",
      CellTags->{"1.3.1.1.3", "1.3.1.1"}]},
  "1.3.1.2.1"->{
    Cell[329153, 10917, 71, 1, 42, "ObjectName",
      CellTags->{"1.3.1.2.1", "1.3.1.2"}]},
  "1.3.1.2"->{
    Cell[329153, 10917, 71, 1, 42, "ObjectName",
      CellTags->{"1.3.1.2.1", "1.3.1.2"}],
    Cell[329227, 10920, 259, 9, 70, "Usage",
      CellTags->{"1.3.1.2.2", "1.3.1.2"}],
    Cell[329489, 10931, 1219, 33, 70, "Notes",
      CellTags->{"1.3.1.2.3", "1.3.1.2"}]},
  "1.3.1.2.2"->{
    Cell[329227, 10920, 259, 9, 70, "Usage",
      CellTags->{"1.3.1.2.2", "1.3.1.2"}]},
  "1.3.1.2.3"->{
    Cell[329489, 10931, 1219, 33, 70, "Notes",
      CellTags->{"1.3.1.2.3", "1.3.1.2"}]},
  "CellBackground"->{
    Cell[330745, 10969, 62, 1, 42, "ObjectName",
      CellTags->"CellBackground"],
    Cell[330810, 10972, 206, 6, 70, "Usage",
      CellTags->"CellBackground"],
    Cell[331019, 10980, 240, 7, 70, "Notes",
      CellTags->"CellBackground"],
    Cell[331262, 10989, 244, 6, 70, "Notes",
      CellTags->"CellBackground"],
    Cell[331509, 10997, 673, 23, 70, "Notes",
      CellTags->"CellBackground"]},
  "1.3.1.3.1"->{
    Cell[332219, 11025, 75, 1, 42, "ObjectName",
      CellTags->{"1.3.1.3.1", "1.3.1.3"}]},
  "1.3.1.3"->{
    Cell[332219, 11025, 75, 1, 42, "ObjectName",
      CellTags->{"1.3.1.3.1", "1.3.1.3"}],
    Cell[332297, 11028, 272, 7, 70, "Usage",
      CellTags->{"1.3.1.3.2", "1.3.1.3"}],
    Cell[332572, 11037, 671, 21, 70, "Notes",
      CellTags->{"1.3.1.3.3", "1.3.1.3"}]},
  "1.3.1.3.2"->{
    Cell[332297, 11028, 272, 7, 70, "Usage",
      CellTags->{"1.3.1.3.2", "1.3.1.3"}]},
  "1.3.1.3.3"->{
    Cell[332572, 11037, 671, 21, 70, "Notes",
      CellTags->{"1.3.1.3.3", "1.3.1.3"}]},
  "1.3.1.4.1"->{
    Cell[333280, 11063, 74, 1, 42, "ObjectName",
      CellTags->{"1.3.1.4.1", "1.3.1.4"}]},
  "1.3.1.4"->{
    Cell[333280, 11063, 74, 1, 42, "ObjectName",
      CellTags->{"1.3.1.4.1", "1.3.1.4"}],
    Cell[333357, 11066, 304, 9, 70, "Usage",
      CellTags->{"1.3.1.4.2", "1.3.1.4"}],
    Cell[333664, 11077, 657, 17, 70, "Notes",
      CellTags->{"1.3.1.4.3", "1.3.1.4"}]},
  "1.3.1.4.2"->{
    Cell[333357, 11066, 304, 9, 70, "Usage",
      CellTags->{"1.3.1.4.2", "1.3.1.4"}]},
  "1.3.1.4.3"->{
    Cell[333664, 11077, 657, 17, 70, "Notes",
      CellTags->{"1.3.1.4.3", "1.3.1.4"}]},
  "1.3.1.5.1"->{
    Cell[334358, 11099, 83, 1, 42, "ObjectName",
      CellTags->{"1.3.1.5.1", "1.3.1.5"}]},
  "1.3.1.5"->{
    Cell[334358, 11099, 83, 1, 42, "ObjectName",
      CellTags->{"1.3.1.5.1", "1.3.1.5"}],
    Cell[334444, 11102, 370, 10, 70, "Usage",
      CellTags->{"1.3.1.5.2", "1.3.1.5"}],
    Cell[334817, 11114, 642, 13, 70, "Notes",
      CellTags->{"1.3.1.5.3", "1.3.1.5"}]},
  "1.3.1.5.2"->{
    Cell[334444, 11102, 370, 10, 70, "Usage",
      CellTags->{"1.3.1.5.2", "1.3.1.5"}]},
  "1.3.1.5.3"->{
    Cell[334817, 11114, 642, 13, 70, "Notes",
      CellTags->{"1.3.1.5.3", "1.3.1.5"}]},
  "1.3.1.6.1"->{
    Cell[335496, 11132, 79, 1, 42, "ObjectName",
      CellTags->{"1.3.1.6.1", "1.3.1.6"}]},
  "1.3.1.6"->{
    Cell[335496, 11132, 79, 1, 42, "ObjectName",
      CellTags->{"1.3.1.6.1", "1.3.1.6"}],
    Cell[335578, 11135, 350, 10, 70, "Usage",
      CellTags->{"1.3.1.6.2", "1.3.1.6"}],
    Cell[335931, 11147, 852, 20, 70, "Notes",
      CellTags->{"1.3.1.6.3", "1.3.1.6"}]},
  "1.3.1.6.2"->{
    Cell[335578, 11135, 350, 10, 70, "Usage",
      CellTags->{"1.3.1.6.2", "1.3.1.6"}]},
  "1.3.1.6.3"->{
    Cell[335931, 11147, 852, 20, 70, "Notes",
      CellTags->{"1.3.1.6.3", "1.3.1.6"}]},
  "1.3.1.7.1"->{
    Cell[336820, 11172, 77, 1, 42, "ObjectName",
      CellTags->{"1.3.1.7.1", "1.3.1.7"}]},
  "1.3.1.7"->{
    Cell[336820, 11172, 77, 1, 42, "ObjectName",
      CellTags->{"1.3.1.7.1", "1.3.1.7"}],
    Cell[336900, 11175, 398, 11, 70, "Usage",
      CellTags->{"1.3.1.7.2", "1.3.1.7"}],
    Cell[337301, 11188, 1504, 37, 70, "Notes",
      CellTags->{"1.3.1.7.3", "1.3.1.7"}]},
  "1.3.1.7.2"->{
    Cell[336900, 11175, 398, 11, 70, "Usage",
      CellTags->{"1.3.1.7.2", "1.3.1.7"}]},
  "1.3.1.7.3"->{
    Cell[337301, 11188, 1504, 37, 70, "Notes",
      CellTags->{"1.3.1.7.3", "1.3.1.7"}]},
  "1.3.1.8.1"->{
    Cell[338842, 11230, 77, 1, 42, "ObjectName",
      CellTags->{"1.3.1.8.1", "1.3.1.8"}]},
  "1.3.1.8"->{
    Cell[338842, 11230, 77, 1, 42, "ObjectName",
      CellTags->{"1.3.1.8.1", "1.3.1.8"}],
    Cell[338922, 11233, 339, 10, 60, "Usage",
      CellTags->{"1.3.1.8.2", "1.3.1.8"}],
    Cell[339264, 11245, 559, 14, 90, "Notes",
      CellTags->{"1.3.1.8.3", "1.3.1.8"}]},
  "1.3.1.8.2"->{
    Cell[338922, 11233, 339, 10, 60, "Usage",
      CellTags->{"1.3.1.8.2", "1.3.1.8"}]},
  "1.3.1.8.3"->{
    Cell[339264, 11245, 559, 14, 90, "Notes",
      CellTags->{"1.3.1.8.3", "1.3.1.8"}]},
  "1.3.1.9.1"->{
    Cell[339860, 11264, 71, 1, 42, "ObjectName",
      CellTags->{"1.3.1.9.1", "1.3.1.9"}]},
  "1.3.1.9"->{
    Cell[339860, 11264, 71, 1, 42, "ObjectName",
      CellTags->{"1.3.1.9.1", "1.3.1.9"}],
    Cell[339934, 11267, 258, 7, 70, "Usage",
      CellTags->{"1.3.1.9.2", "1.3.1.9"}],
    Cell[340195, 11276, 127, 2, 70, "Notes",
      CellTags->{"1.3.1.9.3", "1.3.1.9"}],
    Cell[341854, 11320, 1569, 48, 70, "Notes",
      CellTags->{"1.3.1.9.5", "1.3.1.9"}]},
  "1.3.1.9.2"->{
    Cell[339934, 11267, 258, 7, 70, "Usage",
      CellTags->{"1.3.1.9.2", "1.3.1.9"}]},
  "1.3.1.9.3"->{
    Cell[340195, 11276, 127, 2, 70, "Notes",
      CellTags->{"1.3.1.9.3", "1.3.1.9"}]},
  "1.3.1.9.5"->{
    Cell[341854, 11320, 1569, 48, 70, "Notes",
      CellTags->{"1.3.1.9.5", "1.3.1.9"}]},
  "1.3.1.10.1"->{
    Cell[343460, 11373, 164, 3, 24, "GroupObjectName",
      CellTags->{"1.3.1.10.1", "1.3.1.10"}]},
  "1.3.1.10"->{
    Cell[343460, 11373, 164, 3, 24, "GroupObjectName",
      CellTags->{"1.3.1.10.1", "1.3.1.10"}],
    Cell[343649, 11380, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.10.1.1", "1.3.1.10"}],
    Cell[343740, 11383, 286, 10, 70, "Usage",
      CellTags->{"1.3.1.10.1.2", "1.3.1.10"}],
    Cell[344029, 11395, 393, 13, 70, "Notes",
      CellTags->{"1.3.1.10.1.3", "1.3.1.10"}],
    Cell[344459, 11413, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.10.2.1", "1.3.1.10"}],
    Cell[344546, 11416, 278, 10, 70, "Usage",
      CellTags->{"1.3.1.10.2.2", "1.3.1.10"}],
    Cell[344827, 11428, 617, 22, 70, "Notes",
      CellTags->{"1.3.1.10.2.3", "1.3.1.10"}],
    Cell[345481, 11455, 86, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.10.3.1", "1.3.1.10"}],
    Cell[345570, 11458, 295, 10, 70, "Usage",
      CellTags->{"1.3.1.10.3.2", "1.3.1.10"}],
    Cell[345868, 11470, 717, 26, 70, "Notes",
      CellTags->{"1.3.1.10.3.3", "1.3.1.10"}],
    Cell[346622, 11501, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.10.4.1", "1.3.1.10"}],
    Cell[346710, 11504, 279, 10, 70, "Usage",
      CellTags->{"1.3.1.10.4.2", "1.3.1.10"}],
    Cell[346992, 11516, 583, 21, 70, "Notes",
      CellTags->{"1.3.1.10.4.3", "1.3.1.10"}]},
  "1.3.1.10.1.1"->{
    Cell[343649, 11380, 88, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.10.1.1", "1.3.1.10"}]},
  "1.3.1.10.1.2"->{
    Cell[343740, 11383, 286, 10, 70, "Usage",
      CellTags->{"1.3.1.10.1.2", "1.3.1.10"}]},
  "1.3.1.10.1.3"->{
    Cell[344029, 11395, 393, 13, 70, "Notes",
      CellTags->{"1.3.1.10.1.3", "1.3.1.10"}]},
  "1.3.1.10.2.1"->{
    Cell[344459, 11413, 84, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.10.2.1", "1.3.1.10"}]},
  "1.3.1.10.2.2"->{
    Cell[344546, 11416, 278, 10, 70, "Usage",
      CellTags->{"1.3.1.10.2.2", "1.3.1.10"}]},
  "1.3.1.10.2.3"->{
    Cell[344827, 11428, 617, 22, 70, "Notes",
      CellTags->{"1.3.1.10.2.3", "1.3.1.10"}]},
  "1.3.1.10.3.1"->{
    Cell[345481, 11455, 86, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.10.3.1", "1.3.1.10"}]},
  "1.3.1.10.3.2"->{
    Cell[345570, 11458, 295, 10, 70, "Usage",
      CellTags->{"1.3.1.10.3.2", "1.3.1.10"}]},
  "1.3.1.10.3.3"->{
    Cell[345868, 11470, 717, 26, 70, "Notes",
      CellTags->{"1.3.1.10.3.3", "1.3.1.10"}]},
  "1.3.1.10.4.1"->{
    Cell[346622, 11501, 85, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.10.4.1", "1.3.1.10"}]},
  "1.3.1.10.4.2"->{
    Cell[346710, 11504, 279, 10, 70, "Usage",
      CellTags->{"1.3.1.10.4.2", "1.3.1.10"}]},
  "1.3.1.10.4.3"->{
    Cell[346992, 11516, 583, 21, 70, "Notes",
      CellTags->{"1.3.1.10.4.3", "1.3.1.10"}]},
  "1.3.1.11.1"->{
    Cell[347624, 11543, 165, 3, 24, "GroupObjectName",
      CellTags->{"1.3.1.11.1", "1.3.1.11"}],
    Cell[351044, 11664, 164, 3, 24, "GroupObjectName",
      CellTags->{"1.3.1.11.1", "1.3.1.12"}],
    Cell[456347, 15267, 153, 3, 24, "GroupObjectName",
      CellTags->"1.3.1.11.1"]},
  "1.3.1.11"->{
    Cell[347624, 11543, 165, 3, 24, "GroupObjectName",
      CellTags->{"1.3.1.11.1", "1.3.1.11"}],
    Cell[347814, 11550, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.1.1", "1.3.1.11"}],
    Cell[347909, 11553, 294, 10, 70, "Usage",
      CellTags->{"1.3.1.11.1.2", "1.3.1.11"}],
    Cell[348206, 11565, 423, 14, 70, "Notes",
      CellTags->{"1.3.1.11.1.3", "1.3.1.11"}],
    Cell[348666, 11584, 95, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.2.1", "1.3.1.11"}],
    Cell[348764, 11587, 262, 7, 70, "Usage",
      CellTags->{"1.3.1.11.2.2", "1.3.1.11"}],
    Cell[349029, 11596, 730, 21, 70, "Notes",
      CellTags->{"1.3.1.11.2.3", "1.3.1.11"}],
    Cell[349796, 11622, 99, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.3.1", "1.3.1.11"}],
    Cell[349898, 11625, 320, 11, 70, "Usage",
      CellTags->{"1.3.1.11.3.2", "1.3.1.11"}],
    Cell[350221, 11638, 774, 20, 70, "Notes",
      CellTags->{"1.3.1.11.3.3", "1.3.1.11"}]},
  "1.3.1.11.1.1"->{
    Cell[347814, 11550, 92, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.1.1", "1.3.1.11"}],
    Cell[351233, 11671, 95, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.1.1", "1.3.1.12"}]},
  "1.3.1.11.1.2"->{
    Cell[347909, 11553, 294, 10, 70, "Usage",
      CellTags->{"1.3.1.11.1.2", "1.3.1.11"}],
    Cell[351331, 11674, 321, 9, 48, "Usage",
      CellTags->{"1.3.1.11.1.2", "1.3.1.12"}]},
  "1.3.1.11.1.3"->{
    Cell[348206, 11565, 423, 14, 70, "Notes",
      CellTags->{"1.3.1.11.1.3", "1.3.1.11"}],
    Cell[351655, 11685, 704, 18, 94, "Notes",
      CellTags->{"1.3.1.11.1.3", "1.3.1.12"}]},
  "1.3.1.11.2.1"->{
    Cell[348666, 11584, 95, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.2.1", "1.3.1.11"}],
    Cell[352396, 11708, 150, 2, 21, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.2.1", "1.3.1.12"}],
    Cell[456525, 15274, 157, 2, 70, "ObjectName",
      CellTags->{"1.3.1.11.2.1", "2.2.17a"}]},
  "1.3.1.11.2.2"->{
    Cell[348764, 11587, 262, 7, 70, "Usage",
      CellTags->{"1.3.1.11.2.2", "1.3.1.11"}],
    Cell[352549, 11712, 347, 10, 70, "Usage",
      CellTags->{"1.3.1.11.2.2", "1.3.1.12"}],
    Cell[456685, 15278, 408, 9, 70, "Usage",
      CellTags->{"1.3.1.11.2.2", "2.2.17a"}]},
  "1.3.1.11.2.3"->{
    Cell[349029, 11596, 730, 21, 70, "Notes",
      CellTags->{"1.3.1.11.2.3", "1.3.1.11"}],
    Cell[352899, 11724, 1005, 22, 70, "Notes",
      CellTags->{"1.3.1.11.2.3", "1.3.1.12"}],
    Cell[457096, 15289, 1502, 39, 70, "Notes",
      CellTags->{"1.3.1.11.2.3", "2.2.17a"}]},
  "1.3.1.11.3.1"->{
    Cell[349796, 11622, 99, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.3.1", "1.3.1.11"}]},
  "1.3.1.11.3.2"->{
    Cell[349898, 11625, 320, 11, 70, "Usage",
      CellTags->{"1.3.1.11.3.2", "1.3.1.11"}]},
  "1.3.1.11.3.3"->{
    Cell[350221, 11638, 774, 20, 70, "Notes",
      CellTags->{"1.3.1.11.3.3", "1.3.1.11"}]},
  "1.3.1.12"->{
    Cell[351044, 11664, 164, 3, 24, "GroupObjectName",
      CellTags->{"1.3.1.11.1", "1.3.1.12"}],
    Cell[351233, 11671, 95, 1, 27, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.1.1", "1.3.1.12"}],
    Cell[351331, 11674, 321, 9, 48, "Usage",
      CellTags->{"1.3.1.11.1.2", "1.3.1.12"}],
    Cell[351655, 11685, 704, 18, 94, "Notes",
      CellTags->{"1.3.1.11.1.3", "1.3.1.12"}],
    Cell[352396, 11708, 150, 2, 21, "SubObjectNameClosed",
      CellTags->{"1.3.1.11.2.1", "1.3.1.12"}],
    Cell[352549, 11712, 347, 10, 70, "Usage",
      CellTags->{"1.3.1.11.2.2", "1.3.1.12"}],
    Cell[352899, 11724, 1005, 22, 70, "Notes",
      CellTags->{"1.3.1.11.2.3", "1.3.1.12"}]},
  "1.3.2.1.1"->{
    Cell[354064, 11758, 67, 1, 70, "ObjectName",
      CellTags->{"1.3.2.1.1", "1.3.2.1"}]},
  "1.3.2.1"->{
    Cell[354064, 11758, 67, 1, 70, "ObjectName",
      CellTags->{"1.3.2.1.1", "1.3.2.1"}],
    Cell[354134, 11761, 243, 7, 70, "Usage",
      CellTags->{"1.3.2.1.2", "1.3.2.1"}],
    Cell[354380, 11770, 679, 21, 70, "Notes",
      CellTags->{"1.3.2.1.3", "1.3.2.1"}]},
  "1.3.2.1.2"->{
    Cell[354134, 11761, 243, 7, 70, "Usage",
      CellTags->{"1.3.2.1.2", "1.3.2.1"}]},
  "1.3.2.1.3"->{
    Cell[354380, 11770, 679, 21, 70, "Notes",
      CellTags->{"1.3.2.1.3", "1.3.2.1"}]},
  "1.3.2.2.1"->{
    Cell[355096, 11796, 77, 1, 70, "ObjectName",
      CellTags->{"1.3.2.2.1", "1.3.2.2"}]},
  "1.3.2.2"->{
    Cell[355096, 11796, 77, 1, 70, "ObjectName",
      CellTags->{"1.3.2.2.1", "1.3.2.2"}],
    Cell[355176, 11799, 321, 9, 70, "Usage",
      CellTags->{"1.3.2.2.2", "1.3.2.2"}],
    Cell[355500, 11810, 1114, 33, 70, "Notes",
      CellTags->{"1.3.2.2.3", "1.3.2.2"}]},
  "1.3.2.2.2"->{
    Cell[355176, 11799, 321, 9, 70, "Usage",
      CellTags->{"1.3.2.2.2", "1.3.2.2"}]},
  "1.3.2.2.3"->{
    Cell[355500, 11810, 1114, 33, 70, "Notes",
      CellTags->{"1.3.2.2.3", "1.3.2.2"}]},
  "1.3.2.3.1"->{
    Cell[356651, 11848, 72, 1, 70, "ObjectName",
      CellTags->{"1.3.2.3.1", "1.3.2.3"}]},
  "1.3.2.3"->{
    Cell[356651, 11848, 72, 1, 70, "ObjectName",
      CellTags->{"1.3.2.3.1", "1.3.2.3"}],
    Cell[356726, 11851, 294, 10, 70, "Usage",
      CellTags->{"1.3.2.3.2", "1.3.2.3"}],
    Cell[357023, 11863, 1072, 31, 70, "Notes",
      CellTags->{"1.3.2.3.3", "1.3.2.3"}]},
  "1.3.2.3.2"->{
    Cell[356726, 11851, 294, 10, 70, "Usage",
      CellTags->{"1.3.2.3.2", "1.3.2.3"}]},
  "1.3.2.3.3"->{
    Cell[357023, 11863, 1072, 31, 70, "Notes",
      CellTags->{"1.3.2.3.3", "1.3.2.3"}]},
  "1.3.2.14"->{
    Cell[358132, 11899, 55, 1, 70, "ObjectName",
      CellTags->"1.3.2.14"],
    Cell[358190, 11902, 216, 8, 70, "Usage",
      CellTags->"1.3.2.14"],
    Cell[358409, 11912, 411, 13, 70, "Notes",
      CellTags->"1.3.2.14"]},
  "1.3.2.15"->{
    Cell[358857, 11930, 56, 1, 70, "ObjectName",
      CellTags->"1.3.2.15"],
    Cell[358916, 11933, 262, 8, 70, "Usage",
      CellTags->"1.3.2.15"],
    Cell[359181, 11943, 1362, 44, 70, "Notes",
      CellTags->"1.3.2.15"]},
  "1.3.2.16"->{
    Cell[360580, 11992, 56, 1, 70, "ObjectName",
      CellTags->"1.3.2.16"],
    Cell[360639, 11995, 240, 8, 70, "Usage",
      CellTags->"1.3.2.16"],
    Cell[360882, 12005, 508, 16, 70, "Notes",
      CellTags->"1.3.2.16"]},
  "1.3.2.4.1"->{
    Cell[361427, 12026, 69, 1, 70, "ObjectName",
      CellTags->{"1.3.2.4.1", "1.3.2.4"}]},
  "1.3.2.4"->{
    Cell[361427, 12026, 69, 1, 70, "ObjectName",
      CellTags->{"1.3.2.4.1", "1.3.2.4"}],
    Cell[361499, 12029, 258, 7, 70, "Usage",
      CellTags->{"1.3.2.4.2", "1.3.2.4"}],
    Cell[361760, 12038, 1002, 31, 70, "Notes",
      CellTags->{"1.3.2.4.3", "1.3.2.4"}]},
  "1.3.2.4.2"->{
    Cell[361499, 12029, 258, 7, 70, "Usage",
      CellTags->{"1.3.2.4.2", "1.3.2.4"}]},
  "1.3.2.4.3"->{
    Cell[361760, 12038, 1002, 31, 70, "Notes",
      CellTags->{"1.3.2.4.3", "1.3.2.4"}]},
  "1.3.2.5.1"->{
    Cell[362799, 12074, 68, 1, 70, "ObjectName",
      CellTags->{"1.3.2.5.1", "1.3.2.5"}]},
  "1.3.2.5"->{
    Cell[362799, 12074, 68, 1, 70, "ObjectName",
      CellTags->{"1.3.2.5.1", "1.3.2.5"}],
    Cell[362870, 12077, 256, 8, 70, "Usage",
      CellTags->{"1.3.2.5.2", "1.3.2.5"}],
    Cell[363129, 12087, 920, 29, 70, "Notes",
      CellTags->{"1.3.2.5.3", "1.3.2.5"}]},
  "1.3.2.5.2"->{
    Cell[362870, 12077, 256, 8, 70, "Usage",
      CellTags->{"1.3.2.5.2", "1.3.2.5"}]},
  "1.3.2.5.3"->{
    Cell[363129, 12087, 920, 29, 70, "Notes",
      CellTags->{"1.3.2.5.3", "1.3.2.5"}]},
  "1.3.2.6.1"->{
    Cell[364086, 12121, 79, 1, 70, "ObjectName",
      CellTags->{"1.3.2.6.1", "1.3.2.6"}]},
  "1.3.2.6"->{
    Cell[364086, 12121, 79, 1, 70, "ObjectName",
      CellTags->{"1.3.2.6.1", "1.3.2.6"}],
    Cell[364168, 12124, 275, 9, 70, "Usage",
      CellTags->{"1.3.2.6.2", "1.3.2.6"}],
    Cell[364446, 12135, 1109, 33, 70, "Notes",
      CellTags->{"1.3.2.6.3", "1.3.2.6"}]},
  "1.3.2.6.2"->{
    Cell[364168, 12124, 275, 9, 70, "Usage",
      CellTags->{"1.3.2.6.2", "1.3.2.6"}]},
  "1.3.2.6.3"->{
    Cell[364446, 12135, 1109, 33, 70, "Notes",
      CellTags->{"1.3.2.6.3", "1.3.2.6"}]},
  "1.3.2.7.1"->{
    Cell[365592, 12173, 77, 1, 70, "ObjectName",
      CellTags->{"1.3.2.7.1", "1.3.2.7"}]},
  "1.3.2.7"->{
    Cell[365592, 12173, 77, 1, 70, "ObjectName",
      CellTags->{"1.3.2.7.1", "1.3.2.7"}],
    Cell[365672, 12176, 274, 8, 70, "Usage",
      CellTags->{"1.3.2.7.2", "1.3.2.7"}],
    Cell[365949, 12186, 551, 13, 70, "Notes",
      CellTags->{"1.3.2.7.3", "1.3.2.7"}]},
  "1.3.2.7.2"->{
    Cell[365672, 12176, 274, 8, 70, "Usage",
      CellTags->{"1.3.2.7.2", "1.3.2.7"}]},
  "1.3.2.7.3"->{
    Cell[365949, 12186, 551, 13, 70, "Notes",
      CellTags->{"1.3.2.7.3", "1.3.2.7"}]},
  "1.3.2.8.1"->{
    Cell[366537, 12204, 74, 1, 70, "ObjectName",
      CellTags->{"1.3.2.8.1", "1.3.2.8"}]},
  "1.3.2.8"->{
    Cell[366537, 12204, 74, 1, 70, "ObjectName",
      CellTags->{"1.3.2.8.1", "1.3.2.8"}],
    Cell[366614, 12207, 271, 8, 70, "Usage",
      CellTags->{"1.3.2.8.2", "1.3.2.8"}],
    Cell[366888, 12217, 544, 13, 70, "Notes",
      CellTags->{"1.3.2.8.3", "1.3.2.8"}]},
  "1.3.2.8.2"->{
    Cell[366614, 12207, 271, 8, 70, "Usage",
      CellTags->{"1.3.2.8.2", "1.3.2.8"}]},
  "1.3.2.8.3"->{
    Cell[366888, 12217, 544, 13, 70, "Notes",
      CellTags->{"1.3.2.8.3", "1.3.2.8"}]},
  "1.3.2.10.1"->{
    Cell[367469, 12235, 86, 1, 70, "ObjectName",
      CellTags->{"1.3.2.10.1", "1.3.2.10"}]},
  "1.3.2.10"->{
    Cell[367469, 12235, 86, 1, 70, "ObjectName",
      CellTags->{"1.3.2.10.1", "1.3.2.10"}],
    Cell[367558, 12238, 358, 10, 70, "Usage",
      CellTags->{"1.3.2.10.2", "1.3.2.10"}],
    Cell[367919, 12250, 580, 12, 70, "Notes",
      CellTags->{"1.3.2.10.3", "1.3.2.10"}]},
  "1.3.2.10.2"->{
    Cell[367558, 12238, 358, 10, 70, "Usage",
      CellTags->{"1.3.2.10.2", "1.3.2.10"}]},
  "1.3.2.10.3"->{
    Cell[367919, 12250, 580, 12, 70, "Notes",
      CellTags->{"1.3.2.10.3", "1.3.2.10"}]},
  "1.3.2.11.1"->{
    Cell[368536, 12267, 78, 1, 70, "ObjectName",
      CellTags->{"1.3.2.11.1", "1.3.2.11"}]},
  "1.3.2.11"->{
    Cell[368536, 12267, 78, 1, 70, "ObjectName",
      CellTags->{"1.3.2.11.1", "1.3.2.11"}],
    Cell[368617, 12270, 418, 14, 70, "Usage",
      CellTags->{"1.3.2.11.2", "1.3.2.11"}],
    Cell[369038, 12286, 1323, 35, 70, "Notes",
      CellTags->{"1.3.2.11.3", "1.3.2.11"}]},
  "1.3.2.11.2"->{
    Cell[368617, 12270, 418, 14, 70, "Usage",
      CellTags->{"1.3.2.11.2", "1.3.2.11"}]},
  "1.3.2.11.3"->{
    Cell[369038, 12286, 1323, 35, 70, "Notes",
      CellTags->{"1.3.2.11.3", "1.3.2.11"}]},
  "1.3.2.12.1"->{
    Cell[370398, 12326, 84, 1, 70, "ObjectName",
      CellTags->{"1.3.2.12.1", "1.3.2.12"}]},
  "1.3.2.12"->{
    Cell[370398, 12326, 84, 1, 70, "ObjectName",
      CellTags->{"1.3.2.12.1", "1.3.2.12"}],
    Cell[370485, 12329, 435, 14, 70, "Usage",
      CellTags->{"1.3.2.12.2", "1.3.2.12"}],
    Cell[370923, 12345, 1391, 36, 70, "Notes",
      CellTags->{"1.3.2.12.3", "1.3.2.12"}]},
  "1.3.2.12.2"->{
    Cell[370485, 12329, 435, 14, 70, "Usage",
      CellTags->{"1.3.2.12.2", "1.3.2.12"}]},
  "1.3.2.12.3"->{
    Cell[370923, 12345, 1391, 36, 70, "Notes",
      CellTags->{"1.3.2.12.3", "1.3.2.12"}]},
  "1.3.2.12a"->{
    Cell[372351, 12386, 70, 1, 70, "ObjectName",
      CellTags->"1.3.2.12a"],
    Cell[372424, 12389, 377, 10, 70, "Usage",
      CellTags->"1.3.2.12a"],
    Cell[372804, 12401, 1326, 35, 70, "Notes",
      CellTags->"1.3.2.12a"]},
  "1.3.2.13.1"->{
    Cell[374167, 12441, 84, 1, 70, "ObjectName",
      CellTags->{"1.3.2.13.1", "1.3.2.13"}]},
  "1.3.2.13"->{
    Cell[374167, 12441, 84, 1, 70, "ObjectName",
      CellTags->{"1.3.2.13.1", "1.3.2.13"}],
    Cell[374254, 12444, 414, 12, 70, "Usage",
      CellTags->{"1.3.2.13.2", "1.3.2.13"}],
    Cell[374671, 12458, 1067, 26, 70, "Notes",
      CellTags->{"1.3.2.13.3", "1.3.2.13"}]},
  "1.3.2.13.2"->{
    Cell[374254, 12444, 414, 12, 70, "Usage",
      CellTags->{"1.3.2.13.2", "1.3.2.13"}]},
  "1.3.2.13.3"->{
    Cell[374671, 12458, 1067, 26, 70, "Notes",
      CellTags->{"1.3.2.13.3", "1.3.2.13"}]},
  "1.3.3.1.1"->{
    Cell[375881, 12495, 74, 1, 70, "ObjectName",
      CellTags->{"1.3.3.1.1", "1.3.3.1"}]},
  "1.3.3.1"->{
    Cell[375881, 12495, 74, 1, 70, "ObjectName",
      CellTags->{"1.3.3.1.1", "1.3.3.1"}],
    Cell[375958, 12498, 307, 9, 70, "Usage",
      CellTags->{"1.3.3.1.2", "1.3.3.1"}],
    Cell[376268, 12509, 1028, 32, 70, "Notes",
      CellTags->{"1.3.3.1.3", "1.3.3.1"}]},
  "1.3.3.1.2"->{
    Cell[375958, 12498, 307, 9, 70, "Usage",
      CellTags->{"1.3.3.1.2", "1.3.3.1"}]},
  "1.3.3.1.3"->{
    Cell[376268, 12509, 1028, 32, 70, "Notes",
      CellTags->{"1.3.3.1.3", "1.3.3.1"}]},
  "1.3.3.2.1"->{
    Cell[377333, 12546, 75, 1, 70, "ObjectName",
      CellTags->{"1.3.3.2.1", "1.3.3.2"}]},
  "1.3.3.2"->{
    Cell[377333, 12546, 75, 1, 70, "ObjectName",
      CellTags->{"1.3.3.2.1", "1.3.3.2"}],
    Cell[377411, 12549, 296, 9, 70, "Usage",
      CellTags->{"1.3.3.2.2", "1.3.3.2"}],
    Cell[377710, 12560, 1117, 36, 70, "Notes",
      CellTags->{"1.3.3.2.3", "1.3.3.2"}]},
  "1.3.3.2.2"->{
    Cell[377411, 12549, 296, 9, 70, "Usage",
      CellTags->{"1.3.3.2.2", "1.3.3.2"}]},
  "1.3.3.2.3"->{
    Cell[377710, 12560, 1117, 36, 70, "Notes",
      CellTags->{"1.3.3.2.3", "1.3.3.2"}]},
  "1.3.3.3.1"->{
    Cell[378864, 12601, 74, 1, 70, "ObjectName",
      CellTags->{"1.3.3.3.1", "1.3.3.3"}]},
  "1.3.3.3"->{
    Cell[378864, 12601, 74, 1, 70, "ObjectName",
      CellTags->{"1.3.3.3.1", "1.3.3.3"}],
    Cell[378941, 12604, 328, 9, 70, "Usage",
      CellTags->{"1.3.3.3.2", "1.3.3.3"}],
    Cell[379272, 12615, 1020, 32, 70, "Notes",
      CellTags->{"1.3.3.3.3", "1.3.3.3"}]},
  "1.3.3.3.2"->{
    Cell[378941, 12604, 328, 9, 70, "Usage",
      CellTags->{"1.3.3.3.2", "1.3.3.3"}]},
  "1.3.3.3.3"->{
    Cell[379272, 12615, 1020, 32, 70, "Notes",
      CellTags->{"1.3.3.3.3", "1.3.3.3"}]},
  "1.3.3.4.1"->{
    Cell[380329, 12652, 80, 1, 70, "ObjectName",
      CellTags->{"1.3.3.4.1", "1.3.3.4"}]},
  "1.3.3.4"->{
    Cell[380329, 12652, 80, 1, 70, "ObjectName",
      CellTags->{"1.3.3.4.1", "1.3.3.4"}],
    Cell[380412, 12655, 311, 9, 70, "Usage",
      CellTags->{"1.3.3.4.2", "1.3.3.4"}],
    Cell[380726, 12666, 958, 29, 70, "Notes",
      CellTags->{"1.3.3.4.3", "1.3.3.4"}]},
  "1.3.3.4.2"->{
    Cell[380412, 12655, 311, 9, 70, "Usage",
      CellTags->{"1.3.3.4.2", "1.3.3.4"}]},
  "1.3.3.4.3"->{
    Cell[380726, 12666, 958, 29, 70, "Notes",
      CellTags->{"1.3.3.4.3", "1.3.3.4"}]},
  "1.3.4.1.1"->{
    Cell[381832, 12706, 79, 1, 70, "ObjectName",
      CellTags->{"1.3.4.1.1", "1.3.4.1"}]},
  "1.3.4.1"->{
    Cell[381832, 12706, 79, 1, 70, "ObjectName",
      CellTags->{"1.3.4.1.1", "1.3.4.1"}],
    Cell[381914, 12709, 291, 8, 70, "Usage",
      CellTags->{"1.3.4.1.2", "1.3.4.1"}],
    Cell[382208, 12719, 618, 21, 70, "Notes",
      CellTags->{"1.3.4.1.3", "1.3.4.1"}]},
  "1.3.4.1.2"->{
    Cell[381914, 12709, 291, 8, 70, "Usage",
      CellTags->{"1.3.4.1.2", "1.3.4.1"}]},
  "1.3.4.1.3"->{
    Cell[382208, 12719, 618, 21, 70, "Notes",
      CellTags->{"1.3.4.1.3", "1.3.4.1"}]},
  "1.3.4.2.1"->{
    Cell[382863, 12745, 83, 1, 70, "ObjectName",
      CellTags->{"1.3.4.2.1", "1.3.4.2"}]},
  "1.3.4.2"->{
    Cell[382863, 12745, 83, 1, 70, "ObjectName",
      CellTags->{"1.3.4.2.1", "1.3.4.2"}],
    Cell[382949, 12748, 327, 9, 70, "Usage",
      CellTags->{"1.3.4.2.2", "1.3.4.2"}],
    Cell[383279, 12759, 1473, 44, 70, "Notes",
      CellTags->{"1.3.4.2.3", "1.3.4.2"}]},
  "1.3.4.2.2"->{
    Cell[382949, 12748, 327, 9, 70, "Usage",
      CellTags->{"1.3.4.2.2", "1.3.4.2"}]},
  "1.3.4.2.3"->{
    Cell[383279, 12759, 1473, 44, 70, "Notes",
      CellTags->{"1.3.4.2.3", "1.3.4.2"}]},
  "1.3.4.3.1"->{
    Cell[384789, 12808, 73, 1, 70, "ObjectName",
      CellTags->{"1.3.4.3.1", "1.3.4.3"}]},
  "1.3.4.3"->{
    Cell[384789, 12808, 73, 1, 70, "ObjectName",
      CellTags->{"1.3.4.3.1", "1.3.4.3"}],
    Cell[384865, 12811, 242, 7, 70, "Usage",
      CellTags->{"1.3.4.3.2", "1.3.4.3"}],
    Cell[385110, 12820, 933, 28, 70, "Notes",
      CellTags->{"1.3.4.3.3", "1.3.4.3"}]},
  "1.3.4.3.2"->{
    Cell[384865, 12811, 242, 7, 70, "Usage",
      CellTags->{"1.3.4.3.2", "1.3.4.3"}]},
  "1.3.4.3.3"->{
    Cell[385110, 12820, 933, 28, 70, "Notes",
      CellTags->{"1.3.4.3.3", "1.3.4.3"}]},
  "1.3.4.4.1"->{
    Cell[386080, 12853, 77, 1, 70, "ObjectName",
      CellTags->{"1.3.4.4.1", "1.3.4.4"}]},
  "1.3.4.4"->{
    Cell[386080, 12853, 77, 1, 70, "ObjectName",
      CellTags->{"1.3.4.4.1", "1.3.4.4"}],
    Cell[386160, 12856, 291, 8, 70, "Usage",
      CellTags->{"1.3.4.4.2", "1.3.4.4"}],
    Cell[386454, 12866, 1638, 54, 70, "Notes",
      CellTags->{"1.3.4.4.3", "1.3.4.4"}]},
  "1.3.4.4.2"->{
    Cell[386160, 12856, 291, 8, 70, "Usage",
      CellTags->{"1.3.4.4.2", "1.3.4.4"}]},
  "1.3.4.4.3"->{
    Cell[386454, 12866, 1638, 54, 70, "Notes",
      CellTags->{"1.3.4.4.3", "1.3.4.4"}]},
  "1.3.4.5.1"->{
    Cell[388129, 12925, 69, 1, 70, "ObjectName",
      CellTags->{"1.3.4.5.1", "1.3.4.5"}]},
  "1.3.4.5"->{
    Cell[388129, 12925, 69, 1, 70, "ObjectName",
      CellTags->{"1.3.4.5.1", "1.3.4.5"}],
    Cell[388201, 12928, 229, 6, 70, "Usage",
      CellTags->{"1.3.4.5.2", "1.3.4.5"}],
    Cell[388433, 12936, 911, 28, 70, "Notes",
      CellTags->{"1.3.4.5.3", "1.3.4.5"}]},
  "1.3.4.5.2"->{
    Cell[388201, 12928, 229, 6, 70, "Usage",
      CellTags->{"1.3.4.5.2", "1.3.4.5"}]},
  "1.3.4.5.3"->{
    Cell[388433, 12936, 911, 28, 70, "Notes",
      CellTags->{"1.3.4.5.3", "1.3.4.5"}]},
  "1.3.4.6.1"->{
    Cell[389381, 12969, 170, 4, 70, "GroupObjectName",
      CellTags->{"1.3.4.6.1", "1.3.4.6"}]},
  "1.3.4.6"->{
    Cell[389381, 12969, 170, 4, 70, "GroupObjectName",
      CellTags->{"1.3.4.6.1", "1.3.4.6"}],
    Cell[389576, 12977, 97, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.4.6.1.1", "1.3.4.6"}],
    Cell[389676, 12980, 376, 13, 70, "Usage",
      CellTags->{"1.3.4.6.1.2", "1.3.4.6"}],
    Cell[390055, 12995, 1111, 33, 70, "Notes",
      CellTags->{"1.3.4.6.1.3", "1.3.4.6"}],
    Cell[391203, 13033, 93, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.4.6.2.1", "1.3.4.6"}],
    Cell[391299, 13036, 438, 15, 70, "Usage",
      CellTags->{"1.3.4.6.2.2", "1.3.4.6"}],
    Cell[391740, 13053, 2160, 61, 70, "Notes",
      CellTags->{"1.3.4.6.2.3", "1.3.4.6"}]},
  "1.3.4.6.1.1"->{
    Cell[389576, 12977, 97, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.4.6.1.1", "1.3.4.6"}]},
  "1.3.4.6.1.2"->{
    Cell[389676, 12980, 376, 13, 70, "Usage",
      CellTags->{"1.3.4.6.1.2", "1.3.4.6"}]},
  "1.3.4.6.1.3"->{
    Cell[390055, 12995, 1111, 33, 70, "Notes",
      CellTags->{"1.3.4.6.1.3", "1.3.4.6"}]},
  "1.3.4.6.2.1"->{
    Cell[391203, 13033, 93, 1, 70, "SubObjectNameClosed",
      CellTags->{"1.3.4.6.2.1", "1.3.4.6"}]},
  "1.3.4.6.2.2"->{
    Cell[391299, 13036, 438, 15, 70, "Usage",
      CellTags->{"1.3.4.6.2.2", "1.3.4.6"}]},
  "1.3.4.6.2.3"->{
    Cell[391740, 13053, 2160, 61, 70, "Notes",
      CellTags->{"1.3.4.6.2.3", "1.3.4.6"}]},
  "1.3.5.1.1"->{
    Cell[394053, 13126, 69, 1, 38, "ObjectName",
      CellTags->{"1.3.5.1.1", "1.3.5.1"}]},
  "1.3.5.1"->{
    Cell[394053, 13126, 69, 1, 38, "ObjectName",
      CellTags->{"1.3.5.1.1", "1.3.5.1"}],
    Cell[394125, 13129, 228, 6, 32, "Usage",
      CellTags->{"1.3.5.1.2", "1.3.5.1"}],
    Cell[394356, 13137, 1591, 46, 166, "Notes",
      CellTags->{"1.3.5.1.3", "1.3.5.1"}]},
  "1.3.5.1.2"->{
    Cell[394125, 13129, 228, 6, 32, "Usage",
      CellTags->{"1.3.5.1.2", "1.3.5.1"}]},
  "1.3.5.1.3"->{
    Cell[394356, 13137, 1591, 46, 166, "Notes",
      CellTags->{"1.3.5.1.3", "1.3.5.1"}]},
  "1.3.5.2.1"->{
    Cell[395984, 13188, 73, 1, 38, "ObjectName",
      CellTags->{"1.3.5.2.1", "1.3.5.2"}]},
  "1.3.5.2"->{
    Cell[395984, 13188, 73, 1, 38, "ObjectName",
      CellTags->{"1.3.5.2.1", "1.3.5.2"}],
    Cell[396060, 13191, 241, 7, 32, "Usage",
      CellTags->{"1.3.5.2.2", "1.3.5.2"}],
    Cell[396304, 13200, 737, 26, 84, "Notes",
      CellTags->{"1.3.5.2.3", "1.3.5.2"}]},
  "1.3.5.2.2"->{
    Cell[396060, 13191, 241, 7, 32, "Usage",
      CellTags->{"1.3.5.2.2", "1.3.5.2"}]},
  "1.3.5.2.3"->{
    Cell[396304, 13200, 737, 26, 84, "Notes",
      CellTags->{"1.3.5.2.3", "1.3.5.2"}]},
  "1.3.5.3.1"->{
    Cell[397078, 13231, 82, 1, 38, "ObjectName",
      CellTags->{"1.3.5.3.1", "1.3.5.3"}]},
  "1.3.5.3"->{
    Cell[397078, 13231, 82, 1, 38, "ObjectName",
      CellTags->{"1.3.5.3.1", "1.3.5.3"}],
    Cell[397163, 13234, 284, 9, 70, "Usage",
      CellTags->{"1.3.5.3.2", "1.3.5.3"}],
    Cell[397450, 13245, 881, 20, 70, "Notes",
      CellTags->{"1.3.5.3.3", "1.3.5.3"}]},
  "1.3.5.3.2"->{
    Cell[397163, 13234, 284, 9, 70, "Usage",
      CellTags->{"1.3.5.3.2", "1.3.5.3"}]},
  "1.3.5.3.3"->{
    Cell[397450, 13245, 881, 20, 70, "Notes",
      CellTags->{"1.3.5.3.3", "1.3.5.3"}]},
  "1.3.5.4.1"->{
    Cell[398368, 13270, 79, 1, 42, "ObjectName",
      CellTags->{"1.3.5.4.1", "1.3.5.4"}]},
  "1.3.5.4"->{
    Cell[398368, 13270, 79, 1, 42, "ObjectName",
      CellTags->{"1.3.5.4.1", "1.3.5.4"}],
    Cell[398450, 13273, 360, 9, 70, "Usage",
      CellTags->{"1.3.5.4.2", "1.3.5.4"}],
    Cell[398813, 13284, 908, 32, 70, "Notes",
      CellTags->{"1.3.5.4.3", "1.3.5.4"}]},
  "1.3.5.4.2"->{
    Cell[398450, 13273, 360, 9, 70, "Usage",
      CellTags->{"1.3.5.4.2", "1.3.5.4"}]},
  "1.3.5.4.3"->{
    Cell[398813, 13284, 908, 32, 70, "Notes",
      CellTags->{"1.3.5.4.3", "1.3.5.4"}]},
  "1.3.5.5.1"->{
    Cell[399758, 13321, 78, 1, 42, "ObjectName",
      CellTags->{"1.3.5.5.1", "1.3.5.5"}]},
  "1.3.5.5"->{
    Cell[399758, 13321, 78, 1, 42, "ObjectName",
      CellTags->{"1.3.5.5.1", "1.3.5.5"}],
    Cell[399839, 13324, 269, 7, 70, "Usage",
      CellTags->{"1.3.5.5.2", "1.3.5.5"}],
    Cell[400111, 13333, 713, 27, 70, "Notes",
      CellTags->{"1.3.5.5.3", "1.3.5.5"}]},
  "1.3.5.5.2"->{
    Cell[399839, 13324, 269, 7, 70, "Usage",
      CellTags->{"1.3.5.5.2", "1.3.5.5"}]},
  "1.3.5.5.3"->{
    Cell[400111, 13333, 713, 27, 70, "Notes",
      CellTags->{"1.3.5.5.3", "1.3.5.5"}]},
  "1.3.6.1.1"->{
    Cell[400972, 13371, 69, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.1"}],
    Cell[403732, 13468, 76, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.2"}],
    Cell[405181, 13524, 74, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.3"}],
    Cell[406272, 13566, 81, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.4"}],
    Cell[407520, 13613, 75, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.5"}]},
  "1.3.6.1"->{
    Cell[400972, 13371, 69, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.1"}],
    Cell[401044, 13374, 245, 8, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.1"}],
    Cell[401292, 13384, 2403, 79, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.1"}]},
  "1.3.6.1.2"->{
    Cell[401044, 13374, 245, 8, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.1"}],
    Cell[403811, 13471, 313, 9, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.2"}],
    Cell[405258, 13527, 253, 8, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.3"}],
    Cell[406356, 13569, 308, 7, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.4"}],
    Cell[407598, 13616, 269, 8, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.5"}]},
  "1.3.6.1.3"->{
    Cell[401292, 13384, 2403, 79, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.1"}],
    Cell[404127, 13482, 1017, 37, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.2"}],
    Cell[405514, 13537, 721, 24, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.3"}],
    Cell[406667, 13578, 816, 30, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.4"}],
    Cell[407870, 13626, 1043, 35, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.5"}]},
  "1.3.6.2"->{
    Cell[403732, 13468, 76, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.2"}],
    Cell[403811, 13471, 313, 9, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.2"}],
    Cell[404127, 13482, 1017, 37, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.2"}]},
  "1.3.6.3"->{
    Cell[405181, 13524, 74, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.3"}],
    Cell[405258, 13527, 253, 8, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.3"}],
    Cell[405514, 13537, 721, 24, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.3"}]},
  "1.3.6.4"->{
    Cell[406272, 13566, 81, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.4"}],
    Cell[406356, 13569, 308, 7, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.4"}],
    Cell[406667, 13578, 816, 30, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.4"}]},
  "1.3.6.5"->{
    Cell[407520, 13613, 75, 1, 70, "ObjectName",
      CellTags->{"1.3.6.1.1", "1.3.6.5"}],
    Cell[407598, 13616, 269, 8, 70, "Usage",
      CellTags->{"1.3.6.1.2", "1.3.6.5"}],
    Cell[407870, 13626, 1043, 35, 70, "Notes",
      CellTags->{"1.3.6.1.3", "1.3.6.5"}]},
  "1.3.7.1.1"->{
    Cell[409052, 13672, 72, 1, 70, "ObjectName",
      CellTags->{"1.3.7.1.1", "1.3.7.1"}]},
  "1.3.7.1"->{
    Cell[409052, 13672, 72, 1, 70, "ObjectName",
      CellTags->{"1.3.7.1.1", "1.3.7.1"}],
    Cell[409127, 13675, 237, 7, 70, "Usage",
      CellTags->{"1.3.7.1.2", "1.3.7.1"}],
    Cell[409367, 13684, 508, 15, 70, "Notes",
      CellTags->{"1.3.7.1.3", "1.3.7.1"}]},
  "1.3.7.1.2"->{
    Cell[409127, 13675, 237, 7, 70, "Usage",
      CellTags->{"1.3.7.1.2", "1.3.7.1"}]},
  "1.3.7.1.3"->{
    Cell[409367, 13684, 508, 15, 70, "Notes",
      CellTags->{"1.3.7.1.3", "1.3.7.1"}]},
  "1.3.8.1.1"->{
    Cell[410024, 13710, 70, 1, 70, "ObjectName",
      CellTags->{"1.3.8.1.1", "1.3.8.1"}]},
  "1.3.8.1"->{
    Cell[410024, 13710, 70, 1, 70, "ObjectName",
      CellTags->{"1.3.8.1.1", "1.3.8.1"}],
    Cell[410097, 13713, 242, 8, 70, "Usage",
      CellTags->{"1.3.8.1.2", "1.3.8.1"}],
    Cell[410342, 13723, 470, 16, 70, "Notes",
      CellTags->{"1.3.8.1.3", "1.3.8.1"}]},
  "1.3.8.1.2"->{
    Cell[410097, 13713, 242, 8, 70, "Usage",
      CellTags->{"1.3.8.1.2", "1.3.8.1"}]},
  "1.3.8.1.3"->{
    Cell[410342, 13723, 470, 16, 70, "Notes",
      CellTags->{"1.3.8.1.3", "1.3.8.1"}]},
  "1.3.8.2.1"->{
    Cell[410849, 13744, 72, 1, 70, "ObjectName",
      CellTags->{"1.3.8.2.1", "1.3.8.2"}]},
  "1.3.8.2"->{
    Cell[410849, 13744, 72, 1, 70, "ObjectName",
      CellTags->{"1.3.8.2.1", "1.3.8.2"}],
    Cell[410924, 13747, 304, 7, 70, "Usage",
      CellTags->{"1.3.8.2.2", "1.3.8.2"}],
    Cell[411231, 13756, 505, 13, 70, "Notes",
      CellTags->{"1.3.8.2.3", "1.3.8.2"}],
    Cell[411739, 13771, 954, 17, 70, "Text",
      CellTags->{"1.3.8.2.4", "1.3.8.2"}],
    Cell[412696, 13790, 457, 17, 70, "Notes",
      CellTags->"1.3.8.2"]},
  "1.3.8.2.2"->{
    Cell[410924, 13747, 304, 7, 70, "Usage",
      CellTags->{"1.3.8.2.2", "1.3.8.2"}]},
  "1.3.8.2.3"->{
    Cell[411231, 13756, 505, 13, 70, "Notes",
      CellTags->{"1.3.8.2.3", "1.3.8.2"}]},
  "1.3.8.2.4"->{
    Cell[411739, 13771, 954, 17, 70, "Text",
      CellTags->{"1.3.8.2.4", "1.3.8.2"}]},
  "1.3.9.1.1"->{
    Cell[413300, 13818, 79, 1, 70, "ObjectName",
      CellTags->{"1.3.9.1.1", "1.3.9.1"}]},
  "1.3.9.1"->{
    Cell[413300, 13818, 79, 1, 70, "ObjectName",
      CellTags->{"1.3.9.1.1", "1.3.9.1"}],
    Cell[413382, 13821, 283, 7, 70, "Usage",
      CellTags->{"1.3.9.1.2", "1.3.9.1"}],
    Cell[413668, 13830, 603, 20, 70, "Notes",
      CellTags->{"1.3.9.1.3", "1.3.9.1"}]},
  "1.3.9.1.2"->{
    Cell[413382, 13821, 283, 7, 70, "Usage",
      CellTags->{"1.3.9.1.2", "1.3.9.1"}]},
  "1.3.9.1.3"->{
    Cell[413668, 13830, 603, 20, 70, "Notes",
      CellTags->{"1.3.9.1.3", "1.3.9.1"}]},
  "1.3.9.2.1"->{
    Cell[414308, 13855, 85, 1, 70, "ObjectName",
      CellTags->{"1.3.9.2.1", "1.3.9.2"}]},
  "1.3.9.2"->{
    Cell[414308, 13855, 85, 1, 70, "ObjectName",
      CellTags->{"1.3.9.2.1", "1.3.9.2"}],
    Cell[414396, 13858, 325, 10, 70, "Usage",
      CellTags->{"1.3.9.2.2", "1.3.9.2"}],
    Cell[414724, 13870, 722, 23, 70, "Notes",
      CellTags->{"1.3.9.2.3", "1.3.9.2"}]},
  "1.3.9.2.2"->{
    Cell[414396, 13858, 325, 10, 70, "Usage",
      CellTags->{"1.3.9.2.2", "1.3.9.2"}]},
  "1.3.9.2.3"->{
    Cell[414724, 13870, 722, 23, 70, "Notes",
      CellTags->{"1.3.9.2.3", "1.3.9.2"}]},
  "1.3.9.3.1"->{
    Cell[415483, 13898, 85, 1, 70, "ObjectName",
      CellTags->{"1.3.9.3.1", "1.3.9.3"}]},
  "1.3.9.3"->{
    Cell[415483, 13898, 85, 1, 70, "ObjectName",
      CellTags->{"1.3.9.3.1", "1.3.9.3"}],
    Cell[415571, 13901, 302, 7, 70, "Usage",
      CellTags->{"1.3.9.3.2", "1.3.9.3"}],
    Cell[415876, 13910, 1084, 32, 70, "Notes",
      CellTags->{"1.3.9.3.3", "1.3.9.3"}]},
  "1.3.9.3.2"->{
    Cell[415571, 13901, 302, 7, 70, "Usage",
      CellTags->{"1.3.9.3.2", "1.3.9.3"}]},
  "1.3.9.3.3"->{
    Cell[415876, 13910, 1084, 32, 70, "Notes",
      CellTags->{"1.3.9.3.3", "1.3.9.3"}]},
  "1.3.9.4.1"->{
    Cell[416997, 13947, 79, 1, 70, "ObjectName",
      CellTags->{"1.3.9.4.1", "1.3.9.4"}]},
  "1.3.9.4"->{
    Cell[416997, 13947, 79, 1, 70, "ObjectName",
      CellTags->{"1.3.9.4.1", "1.3.9.4"}],
    Cell[4