(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     45558,       1345]*)
(*NotebookOutlinePosition[     56869,       1626]*)
(*  CellTagsIndexPosition[     55947,       1600]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Sheets", "Title"],

Cell[CellGroupData[{

Cell["Introduction", "Section"],

Cell[CellGroupData[{

Cell["What Is a Style Sheet?", "Subsection",
  CellTags->"StyleSheetIntroduction"],

Cell["\<\
A style sheet is a special kind of notebook that defines a set of cell styles \
used in another notebook. The style sheet contains style definition cells, \
where each style definition cell sets the group of options that are applied \
to any cells of that same type. By changing a cell's style instead of \
assigning specific options to a cell, you apply all the cell attributes \
desired in one step. You also give your notebooks a consistent design and \
make it easy to change that design globally. (You can always set local \
options in a cell to override the settings specified by the style.)\
\>", "Text",
  CellTags->"StyleSheetIntroduction"],

Cell["\<\
A cell style defines various settings for the options associated with a cell, \
such as font, color, justification, alignment, and so on. There are many \
different cell styles in a notebook, such as text, input, and output, for \
example. The cell style can be applied to a single cell or a group of cells. \
Cell styles are assigned names that indicate their use, such as \
\[OpenCurlyDoubleQuote]Section\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]Text\[CloseCurlyDoubleQuote].\
\>", "Text",
  CellTags->"StyleSheetIntroduction"],

Cell["\<\
The style sheet can also define some global options for the notebook, such as \
headers and footers or page size. \
\>", "Text",
  CellTags->"StyleSheetIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Selecting a Style Sheet", "Subsection",
  CellTags->"ChangingStyleSheet"],

Cell["\<\
By changing the style sheet used by a notebook, you redefine all the styles \
used in the notebook. To assign a particular style sheet to an existing \
notebook:\
\>", "Text",
  CellTags->"ChangingStyleSheet"],

Cell[TextData[{
  StyleBox["1.", "BF"],
  "  In the menu, choose ",
  StyleBox["Format \[RightTriangle] Style Sheet", "SR"],
  ".\n",
  StyleBox["2.  ", "BF"],
  "Choose from the available style sheets listed.\n     or \n     Choose ",
  StyleBox["Other", "SR"],
  " to select a style sheet that is not listed."
}], "ItemizedText",
  CellTags->"ChangingStyleSheet"],

Cell["\<\
The new styles are automatically applied to all the cells in the notebook.\
\>", "Text",
  CellTags->"ChangingStyleSheet"],

Cell["To open a new notebook with a style sheet already assigned:", "Text"],

Cell[TextData[{
  StyleBox["1.", "BF"],
  "  In the menu, choose ",
  StyleBox["File \[RightTriangle] Palettes \[RightTriangle] NotebookLauncher",
     "SR"],
  ". A palette appears.\n",
  StyleBox["2.  ", "BF"],
  "Click a style sheet name. A new notebook appears with the style sheet set \
to the name given on the palette."
}], "ItemizedText",
  CellTags->"ChangingStyleSheet"],

Cell[BoxData[
    FormBox[
      StyleBox[
        FrameBox[
          StyleBox[GridBox[{
                {
                  StyleBox["Report",
                    "StandardForm"], 
                  
                  StyleBox[\(styles\ for\ everyday\ work\ and\ for\ reports\),
                    
                    SingleLetterItalics->False]},
                {
                  StyleBox["Tutorial",
                    "StandardForm"], 
                  
                  StyleBox[\(\(styles\)\(\ \)\(for\)\(\ \
\)\(tutorial\[Dash]type\)\(\ \)\(material\)\(\ \)\),
                    SingleLetterItalics->False]},
                {
                  StyleBox["ArticleClassic",
                    "MR"], \(styles\ for\ writing\ articles\)}
                },
              ColumnAlignments->{Right, Left}],
            GridBoxOptions->{RowLines->False}]],
        "2ColumnBox"], TraditionalForm]], "Text",
  CellTags->"ChangingStyleSheet"],

Cell[TextData[{
  "Some typical style sheets included with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". "
}], "Caption",
  CellTags->"ChangingStyleSheet"]
}, Closed]],

Cell[CellGroupData[{

Cell["Shared and Private Style Sheets", "Subsection",
  CellTags->"SharedPrivateStyleSheets"],

Cell[TextData[{
  "The style sheets listed in the Style Sheet submenu are shared style \
sheets. A shared style sheet is a style sheet stored in a central location \
and used by many notebooks at the same time without storing the style \
definitions within the notebooks. If the style sheet is edited, ",
  StyleBox["all",
    FontSlant->"Italic"],
  " notebooks that refer to it are affected. Therefore, care must be taken \
when editing shared style sheets, especially the ones included with ",
  StyleBox["Mathematica", "IT"],
  ". "
}], "Text",
  CellTags->"SharedPrivateStyleSheets"],

Cell["\<\
You can also use private style sheets, which are stored in the notebook and \
not used by any other notebook. To do this, you must first import a style \
sheet:\
\>", "Text",
  CellTags->"SharedPrivateStyleSheets"],

Cell[TextData[{
  StyleBox["1.", "BF"],
  "  In the menu, choose ",
  StyleBox["Format \[RightTriangle] Edit Style Sheet", "SR"],
  ".\n",
  StyleBox["2.  ", "BF"],
  "Click ",
  StyleBox["Import Private Copy", "SR"],
  ". "
}], "ItemizedText",
  CellTags->"SharedPrivateStyleSheets"],

Cell["\<\
This stores a copy of the style sheet within the current notebook.\
\>", "Text",
  CellTags->"SharedPrivateStyleSheets"],

Cell[TextData[{
  "Any changes made to the imported style sheet are stored in the notebook; \
they do not affect the centrally stored style sheet. (See ",
  ButtonBox["Editing a Style Sheet",
    ButtonData:>"Editing Shared or Private Style Sheets",
    ButtonStyle->"OtherInformationLink"],
  ".)"
}], "Text",
  CellTags->"SharedPrivateStyleSheets"]
}, Closed]],

Cell[CellGroupData[{

Cell["Style Sheet File Locations", "Subsection",
  CellTags->"StyleSheetLocations"],

Cell[TextData[{
  "The style sheets listed in the Style Sheet submenu are in the main ",
  StyleBox["Mathematica", "IT"],
  " directory, in ",
  StyleBox["SystemFiles/FrontEnd/StyleSheets", "Program"],
  ". You can store style sheets that you have created in one of the following \
locations:"
}], "Text",
  CellTags->"StyleSheetLocations"],

Cell[TextData[{
  " \[FilledSmallSquare] The preferences directory. This is usually the best \
place to store style sheets on Unix systems. Storing notebooks here prevents \
them from being deleted when you uninstall ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "ItemizedText",
  CellTags->"StyleSheetLocations"],

Cell["\<\
 \[FilledSmallSquare] The configuration directory. This is usually the best \
place to store style sheets on Macintosh or Microsoft Windows systems.\
\>", "ItemizedText",
  CellTags->"StyleSheetLocations"],

Cell[BoxData[
    FormBox[
      StyleBox[
        FrameBox[
          StyleBox[GridBox[{
                {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"platform\\\\\\\"\\\", \
\\\"SO10\\\"]\\) \"\>", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"preferences \
directory\\\\\\\"\\\", \\\"SO10\\\"]\\) \"\>", \
"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"configuration directory\\\\\\\"\\\", \
\\\"SO10\\\"]\\) \"\>"},
                {
                  StyleBox[\(Microsoft\ Windows\),
                    GridBoxOptions->{
                    RowLines->{
                      True, False, False, False, True, False, False, False, 
                        True, False, False, False, False, True}}], 
                  RowBox[{
                    StyleBox[\(\(\\\)\(Program\)\),
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox[\(Files\\Common\),
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    RowBox[{
                      StyleBox["Files",
                        "MR"], 
                      StyleBox["\\",
                        "MR"], 
                      StyleBox["Mathematica",
                        "MR"], 
                      StyleBox["\\",
                        "MR"], 
                      StyleBox["version",
                        "IT"]}]}], 
                  RowBox[{
                    StyleBox[\(\(\\\)\(Program\)\),
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox[\(Files\\Wolfram\),
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    RowBox[{
                      StyleBox["Research",
                        "MR"], 
                      StyleBox["\\",
                        "MR"], 
                      StyleBox["Mathematica",
                        "MR"], 
                      StyleBox["\\",
                        "MR"], 
                      StyleBox["version",
                        "IT"], 
                      StyleBox["\\",
                        "MR"], 
                      StyleBox["Configuration",
                        "MR"]}]}]},
                {
                  StyleBox["Macintosh",
                    GridBoxOptions->{
                    RowLines->{
                      True, False, False, False, True, False, False, False, 
                        True, False, False, False, False, True}}], 
                  RowBox[{
                    StyleBox["System",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    RowBox[{
                      StyleBox["Folder",
                        "MR"], 
                      StyleBox[":",
                        "MR"], 
                      RowBox[{
                        StyleBox["Preferences",
                          "MR"], 
                        StyleBox[":",
                          "MR"], 
                        RowBox[{
                          StyleBox["Mathematica",
                            "MR"], 
                          StyleBox[":",
                            "MR"], 
                          StyleBox["version",
                            "IT"]}]}]}]}], 
                  StyleBox[\(Mathematica\ \(Files : Configuration\)\),
                    "MR"]},
                {
                  StyleBox["Unix",
                    GridBoxOptions->{
                    RowLines->{
                      True, False, False, False, True, False, False, False, 
                        True, False, False, False, False, True}}], 
                  RowBox[{
                    StyleBox["~",
                      "MR"], 
                    RowBox[{
                      StyleBox[
                        StyleBox[
                          RowBox[{"/", 
                            StyleBox[".",
                              GridBoxOptions->{
                              RowLines->{
                                True, False, False, False, True, False, False,
                                   False, True, False, False, False, False, 
                                  True}}]}]],
                        "MR"], 
                      RowBox[{
                        RowBox[{
                          StyleBox["Mathematica",
                            "MR"], 
                          StyleBox["/",
                            GridBoxOptions->{
                            RowLines->{
                              True, False, False, False, True, False, False, 
                                False, True, False, False, False, False, 
                                True}}], 
                          StyleBox["version",
                            "IT"]}], 
                        StyleBox["/",
                          GridBoxOptions->{
                          RowLines->{
                            True, False, False, False, True, False, False, 
                              False, True, False, False, False, False, 
                              True}}]}]}]}], 
                  
                  StyleBox[\(\(\(\(\(/\)\(usr\)\)/local\)/mathematica\)/
                      Configuration\),
                    "MR"]}
                },
              RowSpacings->2.5,
              ColumnAlignments->{Left}],
            GridBoxOptions->{
            RowLines->{
              True, False, False, False, True, False, False, False, True, 
                False, False, False, False, True}}]],
        "3ColumnBox"], TraditionalForm]], "Text",
  CellTags->"StyleSheetLocations"],

Cell["\<\
Typical values for the preferences and configuration directories.\
\>", "Caption",
  CellTags->"StyleSheetLocations"],

Cell[TextData[{
  "The style sheets should be stored in a subdirectory called ",
  StyleBox["FrontEnd/StyleSheets", "Program"],
  ". These style sheets are then available from the Style Sheet submenu."
}], "Text",
  CellTags->"StyleSheetLocations"],

Cell[TextData[{
  "The global option ",
  StyleBox["StyleSheetPath", "Program"],
  " gives the list of directories that are searched for style sheets upon \
startup."
}], "Text",
  CellTags->"StyleSheetLocations"],

Cell[TextData[{
  "If you uninstall ",
  StyleBox["Mathematica", "IT"],
  ", you should first make backup copies of your style sheets, especially if \
they are stored in the configuration directory."
}], "Text",
  CellTags->"StyleSheetLocations"]
}, Closed]],

Cell[CellGroupData[{

Cell["How Style Sheets Work", "Subsection",
  CellTags->"StyleSheetMethod"],

Cell[TextData[{
  "The choice of style sheet for a notebook is set with the notebook option \
",
  StyleBox["StyleDefinitions", "Program"],
  ". For a private style sheet, the option is ",
  StyleBox["StyleDefinitions -> Notebook[", "Program"],
  StyleBox["expr", "IT"],
  StyleBox["]", "Program"],
  ", where ",
  StyleBox["Notebook[", "Program"],
  StyleBox["expr", "IT"],
  StyleBox["]", "Program"],
  " is the style sheet itself."
}], "Text",
  CellTags->"StyleSheetMethod"],

Cell[TextData[{
  "For a shared style sheet, the option is ",
  StyleBox["StyleDefinitions ->\"", "Program"],
  StyleBox["filename", "IT"],
  StyleBox["\"", "Program"],
  ", where ",
  StyleBox["filename", "IT"],
  " is the name of the shared style sheet. If the style sheet is not on the \
style sheet path, the file name relative to the notebook is used. (If the \
style sheet and notebook are in the same directory, only the file name of the \
style sheet is used.) If the notebook or style sheet is moved to a different \
location on your disk, the front end may be unable to find the style sheet \
when the notebook is opened.  "
}], "Text",
  CellTags->"StyleSheetMethod"],

Cell[TextData[{
  "When choosing a shared style sheet, you should make sure the notebook is \
first saved to disk (",
  StyleBox["i.e.", "IT",
    FontSlant->"Plain"],
  StyleBox[",", "IT"],
  " not left as an untitled notebook). If the notebook is not saved first, \
the style sheet name is recorded as an absolute path name since the ultimate \
location of the notebook is not known."
}], "Text",
  CellTags->"StyleSheetMethod"],

Cell[TextData[{
  "The style sheet contains a set of style definition cells. (For a full \
description, see ",
  ButtonBox["How Settings for a Style Are Determined",
    ButtonStyle->"OtherInformationLink"],
  ".) The main style definition cell is the cell labeled \
\[OpenCurlyDoubleQuote]Prototype for style ",
  StyleBox["style", "IT"],
  "\[CloseCurlyDoubleQuote]. The underlying ",
  StyleBox["Mathematica", "IT"],
  " expression for the same cell is ",
  StyleBox["Cell[StyleData[\"", "Program"],
  StyleBox["style", "IT"],
  StyleBox["\"], ", "Program"],
  StyleBox["options", "IT"],
  StyleBox["]", "Program"],
  ". (To see the underlying cell expression, select the cell and choose ",
  StyleBox["Format \[RightTriangle] Show Expression", "SR"],
  ".) The options specify the attributes of the cell with the style name \
\[OpenCurlyDoubleQuote]",
  StyleBox["style", "IT"],
  "\[CloseCurlyDoubleQuote].  For any cell in the notebook of that same \
style, the specified options will be applied to the cell. If an option has \
been set in the style sheet and in the cell itself, the cell's options \
override the style sheet options."
}], "Text",
  CellTags->"StyleSheetMethod"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Editing a Style Sheet", "Section"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->"EditingIntroduction"],

Cell["\<\
Editing a style sheet affects the basic design of the notebook using that \
style sheet. You can edit the cells in the style sheet to change font, \
background color, justification, and many other options. There are several \
steps involved in editing a style sheet: choosing to edit a shared or private \
style sheet, changing the cell options, and changing the style environment \
options. \
\>", "Text",
  CellTags->"EditingIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Editing Shared or Private Style Sheets", "Subsection",
  CellTags->"EditingSharedPrivate"],

Cell["\<\
First, it is important to decide whether you want to edit the centrally \
stored style sheet or to import a private copy. If you want  to affect the \
display of many notebooks, you should edit the centrally stored style sheet. \
If you want to affect the display of only one notebook, you should import a \
private copy and edit it.\
\>", "Text",
  CellTags->"EditingSharedPrivate"],

Cell[TextData[{
  "You must consider carefully if you want to edit the shared style sheets \
included with ",
  StyleBox["Mathematica", "IT"],
  ". While you can always retrieve a copy of the style sheet from the CD \
should you make an error, it is better to make a copy of the style sheet and \
edit the copy. (See ",
  ButtonBox["How to Create Your Own Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  ".)"
}], "Text",
  CellTags->"EditingSharedPrivate"],

Cell[TextData[{
  "If you click ",
  StyleBox["Format \[RightTriangle] Edit Style Sheet ", "SR"],
  "and the notebook currently uses a shared style sheet, a dialog box \
appears. You have the following options."
}], "Text",
  CellTags->"EditingSharedPrivate"],

Cell[TextData[{
  " \[FilledSmallSquare] ",
  StyleBox["Import Private Copy", "SR"],
  ". By clicking ",
  StyleBox["Import Private Copy", "SR"],
  ", a copy of the style sheet currently in use will be used and stored \
privately with the notebook. Changes to this style sheet do not affect the \
centrally stored style sheet, and changes made to the style sheet are \
instantly reflected in the open notebook.\n \[FilledSmallSquare] ",
  StyleBox["Edit Shared Style Sheet", "SR"],
  ". By clicking ",
  StyleBox["Edit Shared Style Sheet", "SR"],
  ", the centrally stored style sheet will be opened. Any changes to the \
style sheet will be applied to all notebooks using that style sheet, but \
notebooks that use the style sheet and are open will not be updated \
automatically."
}], "ItemizedText",
  CellTags->"EditingSharedPrivate"],

Cell[TextData[{
  "You can open the style sheet directly using the ",
  StyleBox["File \[RightTriangle] Open", "SR"],
  " command; this will cause all changes in the style sheet to be applied to \
all notebooks using that sheet. "
}], "Text",
  CellTags->"EditingSharedPrivate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changing Cell Options", "Subsection",
  CellTags->"ChangingCellOptions"],

Cell[TextData[{
  "Next, after the style sheet is opened for editing, you can make changes to \
the cells just as you would make changes to a cell in a regular notebook. For \
the style sheets included with ",
  StyleBox["Mathematica", "IT"],
  ", the cells are grouped together based on functionality (",
  StyleBox["e.g.", "IT",
    FontSlant->"Plain"],
  ",",
  " headings, input, formulas, and headers). These cell groups must be opened \
to see the style definition cells. Each style definition cell is marked with \
the text \[OpenCurlyDoubleQuote]Prototype for style\[CloseCurlyDoubleQuote]. \
For example, the cell defining the Text style looks like this in the default \
style sheet."
}], "Text",
  CellTags->"ChangingCellOptions"],

Cell[TextData[{
  StyleBox["Prototype for style: \"Text\":",
    FontSize->10],
  "\nText"
}], "Text",
  CellFrame->{{0, 0}, {0, 0.25}},
  ShowCellBracket->True,
  CellMargins->{{12, Inherited}, {3, 3}},
  LineSpacing->{1, 0},
  ParagraphSpacing->{0, 1},
  CellTags->"ChangingCellOptions"],

Cell["\<\
After you select a cell, you can use menu commands or the Option Inspector to \
apply options to the cell. For example, to change the font for the cell:\
\>", "Text",
  CellTags->"ChangingCellOptions"],

Cell[TextData[{
  StyleBox["1.", "BF"],
  "  Click the cell bracket. The cell is highlighted. \n",
  StyleBox["2.  ", "BF"],
  "In the Format menu, choose the desired font from the Font submenu. "
}], "ItemizedText",
  CellTags->"ChangingCellOptions"],

Cell["The text in the cell is now written using the new font.", "Text",
  CellTags->"ChangingCellOptions"],

Cell[TextData[{
  "Other options not available from the menus can be set via the Option \
Inspector. Further documentation is available on ",
  ButtonBox["Front End Options",
    ButtonData:>"Searching for an Option",
    ButtonStyle->"OtherInformationLink"],
  " and the ",
  ButtonBox["Option Inspector",
    ButtonData:>"The Option Inspector",
    ButtonStyle->"OtherInformationLink"],
  ". "
}], "Text",
  CellTags->"ChangingCellOptions"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changing Style Environment Options", "Subsection",
  CellTags->"ChangingEnvironmentOptions"],

Cell[TextData[{
  "Finally, you need to decide if special options should be applied to the \
environments. (For a description of environments, see ",
  ButtonBox["What Are Style Environments?",
    ButtonStyle->"OtherInformationLink"],
  ") For the style sheets included with ",
  StyleBox["Mathematica", "IT"],
  ", each style definition cell is actually the first cell of a closed cell \
group. By double-clicking the closed cell group bracket, three other cells \
will appear. For example, this is what you see when you double-click the \
closed cell group bracket for the Text definition cell."
}], "Text",
  CellTags->"ChangingEnvironmentOptions"],

Cell[TextData[{
  StyleBox["Prototype for style: \"Text\":",
    FontSize->10],
  "\nText"
}], "Text",
  CellFrame->{{0, 0}, {0, 0.25}},
  ShowCellBracket->True,
  CellMargins->{{12, Inherited}, {3, 3}},
  LineSpacing->{1, 0},
  ParagraphSpacing->{0, 1},
  CellTags->"ChangingEnvironmentOptions"],

Cell[TextData[{
  StyleBox["Modification for style: \"Text\" in style environment \
\"Presentation\":",
    FontSize->10],
  "\nText"
}], "Text",
  PageWidth->WindowWidth,
  CellFrame->{{0, 0}, {0, 0.25}},
  ShowCellBracket->True,
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 0},
  ParagraphSpacing->{0, 1},
  ScriptMinSize->12,
  FontSize->16,
  CellTags->"ChangingEnvironmentOptions"],

Cell[TextData[{
  StyleBox["Modification for style: \"Text\" in style environment \"Condensed\
\":",
    FontSize->10],
  "\nText"
}], "Text",
  PageWidth->WindowWidth,
  CellFrame->{{0, 0}, {0, 0.25}},
  ShowCellBracket->True,
  CellMargins->{{8, 10}, {6, 6}},
  CellBracketOptions->{"Margins"->{1, 1},
  "Widths"->{0, 5}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 1},
  ScriptMinSize->8,
  FontSize->11,
  CellTags->"ChangingEnvironmentOptions"],

Cell[TextData[{
  StyleBox["Modification for style: \"Text\" in style environment \
\"Printout\":",
    FontSize->10],
  "\nText"
}], "Text",
  PageWidth->PaperWidth,
  CellFrame->{{0, 0}, {0, 0.25}},
  ShowCellBracket->True,
  CellMargins->{{2, 2}, {6, 6}},
  LineSpacing->{1, 0},
  ParagraphSpacing->{0, 1},
  ScriptMinSize->5,
  FontSize->10,
  CellTags->"ChangingEnvironmentOptions"],

Cell["\<\
You can make changes to the environment definition cells just as you would \
make changes to the style definition cells. \
\>", "Text",
  CellTags->"ChangingEnvironmentOptions"]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Editing Tips", "Subsection",
  CellTags->"OtherEditingTips"],

Cell["\<\
You may find it more convenient to use the following techniques to edit a \
cell in a style sheet.\
\>", "Text",
  CellTags->"OtherEditingTips"],

Cell[TextData[{
  " \[FilledSmallSquare] You can select a cell and edit the cell options \
through the Option Inspector. Be sure that the pop-up menu labeled ",
  StyleBox["Show option values for", "SR"],
  " is set to ",
  StyleBox["selection", "SR"],
  ".\n \[FilledSmallSquare] You can unformat the cell using ",
  StyleBox["Format \[RightTriangle] Show Expression", "SR"],
  " and edit the cell expression directly. "
}], "ItemizedText",
  CellTags->"OtherEditingTips"]
}, Closed]],

Cell[CellGroupData[{

Cell["How Options Are Set", "Subsection",
  CellTags->"OptionStoring"],

Cell[TextData[{
  "All options take the form ",
  StyleBox["OptionName", "IT"],
  " -> ",
  StyleBox["optionvalue", "IT"],
  ". All available options are listed in the Option Inspector. Sample options \
include ",
  StyleBox["CellFrame", "MR"],
  ", ",
  StyleBox["Background", "MR"],
  ", ",
  StyleBox["FontFamily", "MR"],
  ", ",
  StyleBox["FontSize", "MR"],
  ", ",
  StyleBox["FontSlant", "MR"],
  ", and so on. Any options you set using the menus or Option Inspector are \
reflected in the cell expression. Documentation is available for the options \
listed in the Option Inspector under",
  " ",
  ButtonBox["Front End Options",
    ButtonData:>"The Option Inspector",
    ButtonStyle->"OtherInformationLink"],
  " ",
  "in the Help Browser. "
}], "Text",
  CellTags->"OptionStoring"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Default Style Sheets", "Section"],

Cell[CellGroupData[{

Cell["What Is the Default Style Sheet?", "Subsection",
  CellTags->"DefaultStyleSheetIntroduction"],

Cell[TextData[{
  "The default style sheet is the style sheet used by all newly created \
notebooks. (New notebooks are called Untitled-",
  StyleBox["n", "IT"],
  ", where ",
  StyleBox["n", "IT"],
  " is a number.) The default style sheet is designed to be a general-purpose \
style sheet for doing interactive calculations and writing simple reports."
}], "Text",
  CellTags->"DefaultStyleSheetIntroduction"],

Cell["\<\
If you find that you are editing many cells to change the look of the \
notebook, you may want to create a different style sheet incorporating all \
your preferences and make it the default style sheet.\
\>", "Text",
  CellTags->"DefaultStyleSheetIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Location of the Default Style Sheet", "Subsection",
  CellTags->"DefaultStyleSheetLocation"],

Cell[TextData[{
  "The default style sheet shipped with ",
  StyleBox["Mathematica", "IT"],
  " is called ",
  StyleBox["Default.nb", "Program"],
  " and is stored in the main ",
  StyleBox["Mathematica", "IT"],
  " directory, in ",
  StyleBox["SystemFiles/FrontEnd/StyleSheets", "Program"],
  "."
}], "Text",
  CellTags->"DefaultStyleSheetLocation"]
}, Closed]],

Cell[CellGroupData[{

Cell["Selecting the Default Style Sheet", "Subsection",
  CellTags->"ChangingDefaultStyleSheet"],

Cell["To assign the style sheet used as the default style sheet:", "Text",
  CellTags->"ChangingDefaultStyleSheet"],

Cell[TextData[{
  StyleBox["1.", "BF"],
  "  Choose ",
  StyleBox["Preferences", "SR"],
  " in the menu.\n",
  StyleBox["2.  ", "BF"],
  "Verify that the pop-up menu labeled ",
  StyleBox["\[OpenCurlyDoubleQuote]Show option values for\
\[CloseCurlyDoubleQuote]", "SR",
    FontFamily->"Times"],
  StyleBox[" ", "SR"],
  "is set to ",
  StyleBox["global", "SR"],
  ". \n",
  StyleBox["3.", "BF"],
  "  Under ",
  StyleBox["Global Options \[RightTriangle] File Locations", "SR"],
  ", find the option ",
  StyleBox["DefaultStyleDefinitions", "Program"],
  ".",
  StyleBox["\n", "Program"],
  StyleBox["4.", "BF"],
  "  Click the button to the right of the option, and select the default \
style sheet."
}], "ItemizedText",
  CellTags->"ChangingDefaultStyleSheet"],

Cell["\<\
From now on, all untitled notebooks will use the selected style sheet by \
default.\
\>", "Text",
  CellTags->"ChangingDefaultStyleSheet"]
}, Closed]],

Cell[CellGroupData[{

Cell["Setting the Default Style Sheet Option", "Subsection",
  CellTags->"StoringDefaultStyleSheet"],

Cell[TextData[{
  "The assignment for the default style sheet is set as an option in the file \
",
  StyleBox["FrontEnd/init.m", "Program"],
  "  in your preferences directory. The option is ",
  StyleBox["DefaultStyleDefinitions :> \"", "Program"],
  StyleBox["filename", "IT"],
  StyleBox["\"", "Program"],
  ", where ",
  StyleBox["filename", "IT"],
  " is a shared style sheet or a style sheet that you have created. In some \
cases, the front end stores the file name using the ",
  StyleBox["FrontEnd`FileName", "Program"],
  " command. "
}], "Text",
  CellTags->"StoringDefaultStyleSheet"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Style Environments", "Section"],

Cell[CellGroupData[{

Cell["What Are Style Environments?", "Subsection",
  CellTags->"EnvironmentIntroduction"],

Cell["\<\
Style environments allow you to define variations in the appearance of a \
style. Such variations allow you to use one style sheet in several different \
ways without having to make several similar style sheets. You can have any \
number of environments in a style sheet. \
\>", "Text",
  CellTags->"EnvironmentIntroduction"],

Cell[TextData[{
  "For example, the default style sheet included with ",
  StyleBox["Mathematica", "IT"],
  " has the following four style environments."
}], "Text",
  CellTags->"EnvironmentIntroduction"],

Cell[TextData[{
  " \[FilledSmallSquare] ",
  StyleBox["Working: d", "RM"],
  "esigned for on-screen use\n \[FilledSmallSquare] ",
  StyleBox["Presentation: d", "RM"],
  "esigned for presentations, either from a computer or printed on \
transparencies"
}], "ItemizedText",
  CellTags->"EnvironmentIntroduction"],

Cell[TextData[{
  " \[FilledSmallSquare] ",
  StyleBox["Condensed: d", "RM"],
  "esigned for viewing on a small screen or printing on less paper\n \
\[FilledSmallSquare] ",
  StyleBox["Printout: d", "RM"],
  "esigned for optimal printing of the notebook"
}], "ItemizedText",
  CellTags->"EnvironmentIntroduction"],

Cell["\<\
Style environments for a particular style sheet are defined in the style \
sheet itself. \
\>", "Text",
  CellTags->"EnvironmentIntroduction"],

Cell[TextData[{
  "In the style sheets included with ",
  StyleBox["Mathematica", "IT"],
  ", the environment definition cells are grouped with the main style \
definition cell. The cell group is closed so that only the main style \
definition cell is seen. When you double-click the closed cell group bracket, \
three other cells appear that define the ",
  StyleBox["Presentation", "RM"],
  ", ",
  StyleBox["Condensed", "RM"],
  ", and ",
  StyleBox["Printout", "RM"],
  " versions of that cell style. "
}], "Text",
  CellTags->"EnvironmentIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Setting On-Screen or Printing Environments", "Subsection",
  CellTags->"SettingEnvironments"],

Cell[TextData[{
  "New notebooks that use the default style sheet shipped with ",
  StyleBox["Mathematica", "IT"],
  " are set up to use the Working environment onscreen and the Printout \
environment when printing. Because of this, the print version of a notebook \
will look slightly different than the onscreen version. If you want the print \
and screen versions to be identical, the screen and printing environments \
must be the same."
}], "Text",
  CellTags->"SettingEnvironments"],

Cell[TextData[{
  "You can set the style environment used for printing or for on-screen use. \
To set the screen environment, go to ",
  StyleBox["Format \[RightTriangle] Screen Environment", "SR"],
  " and choose from the available environments listed. To set the printing \
environment, go to ",
  StyleBox["Format \[RightTriangle] Printing Environment", "SR"],
  ". This allows you to display a notebook in one environment but \
automatically get printouts in another environment."
}], "Text",
  CellTags->"SettingEnvironments"]
}, Closed]],

Cell[CellGroupData[{

Cell["How Settings for a Style Are Determined", "Subsection",
  CellTags->"StyleDefinitionEnvironments"],

Cell[TextData[StyleBox["The settings used for a cell in a particular style \
are a combination of the following definitions within a style sheet (listed \
in order of decreasing precedence).",
  FontWeight->"Plain"]], "Text",
  FontWeight->"Bold",
  CellTags->"StyleDefinitionEnvironments"],

Cell[TextData[{
  " \[FilledSmallSquare] The format type definition cell: this cell sets \
options to any cells in the notebook that have a specified format, such as ",
  StyleBox["TraditionalForm", "MR"],
  " or ",
  StyleBox["StandardForm", "MR"],
  ". The format types typically used are listed in the ",
  StyleBox["Cell \[RightTriangle] Display As", "SR"],
  " submenu. (The list of all format types is available in the style sheet.) \
",
  StyleBox["StandardForm", "MR"],
  ", ",
  StyleBox["InputForm", "MR"],
  ", and ",
  StyleBox["OutputForm", "MR"],
  " expressions use a monospaced font to ensure that the expressions display \
properly. This font is set in each definition cell for the format type. ",
  StyleBox["TraditionalForm", "MR"],
  " cells automatically italicize single letters and use traditional function \
notation because these options are set in the ",
  StyleBox["TraditionalForm", "MR"],
  " style definition. These cells are labeled \
\[OpenCurlyDoubleQuote]Prototype for style ",
  StyleBox["formattype", "IT"],
  "\[CloseCurlyDoubleQuote]. The underlying cell expression is ",
  StyleBox["Cell[StyleData[\"", "Program"],
  StyleBox["formattype", "IT"],
  StyleBox["\"], ", "Program"],
  StyleBox["options", "IT"],
  StyleBox["]", "Program"],
  ". "
}], "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],

Cell[TextData[{
  " \[FilledSmallSquare] The style environment definition cell: this cell \
sets options that are applied only to the listed cell style and only in the \
listed environment. This cell is normally in a closed cell group with the \
style definition cell. It is labeled \[OpenCurlyDoubleQuote]Modification for \
style ",
  StyleBox["style", "IT"],
  " in style environment ",
  StyleBox["environment", "IT"],
  "\[CloseCurlyDoubleQuote]. The underlying cell expression is ",
  StyleBox["Cell[StyleData[\"", "Program"],
  StyleBox["style", "IT"],
  StyleBox["\", \"", "Program"],
  StyleBox["environment", "IT"],
  StyleBox["\"], ", "Program"],
  StyleBox["options", "IT"],
  StyleBox["]", "Program"],
  "."
}], "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],

Cell[TextData[{
  " \[FilledSmallSquare] The style definition cell: this is the main style \
definition cell, labeled \[OpenCurlyDoubleQuote]Prototype for style: ",
  StyleBox["style", "IT"],
  "\[CloseCurlyDoubleQuote]. The underlying cell expression is ",
  StyleBox["Cell[StyleData[\"", "Program"],
  StyleBox["style", "IT"],
  StyleBox["\"], ", "Program"],
  StyleBox["options", "IT"],
  StyleBox["]", "Program"],
  ". "
}], "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],

Cell[TextData[{
  " \[FilledSmallSquare] The environment definition cell: this cell sets \
options that are applied to all cell styles in the listed environment. This \
is an easy way to set options that should apply to all cells when using a \
particular environment, such as font size or page width. These cells are \
labeled \[OpenCurlyDoubleQuote]Modification for all styles in the style \
environment ",
  StyleBox["environment", "IT"],
  "\[CloseCurlyDoubleQuote]. The underlying cell expression is ",
  StyleBox["Cell[StyleData[All, \"", "Program"],
  StyleBox["environment", "IT"],
  StyleBox["\"], ", "Program"],
  StyleBox["options", "IT"],
  StyleBox["]", "Program"],
  ". "
}], "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],

Cell[TextData[{
  " \[FilledSmallSquare] The notebook definition cell: the options listed \
here are applied to all cells in the notebook. It is labeled \
\[OpenCurlyDoubleQuote]Prototype for style Notebook\[CloseCurlyDoubleQuote]. \
The underlying cell expression is  ",
  StyleBox["Cell[StyleData[\"Notebook\"], ", "Program"],
  StyleBox["options", "IT"],
  StyleBox["]", "Program"],
  ". "
}], "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],

Cell[TextData[{
  "If an option is applied in more than one place, the option that is set in \
the cell with higher precedence is used. For example, if the style sheet had \
",
  StyleBox["Cell[StyleData[\"Input\"], Background -> Hue[1]]", "Program"],
  " and ",
  StyleBox["Cell[StyleData[\"Notebook\", Background -> Hue[0.5]]", 
    "Program"],
  ", the setting that applies only to Input cells (",
  StyleBox["Hue[1])", "Program"],
  " is used in Input cells. All other cells will use the background color as \
set for the entire notebook (",
  StyleBox["Hue[0.5])", "Program"],
  ". Only those options that need to be reset should be applied to style \
environment definition cells. Most options should be set in the style \
definition cells."
}], "Text",
  CellTags->"StyleDefinitionEnvironments"],

Cell[TextData[{
  "If no cell definition is given for a particular style and a particular \
environment, then the other definitions of settings are used. For example, in \
the default style sheet most styles do not define a variation for the \
\[OpenCurlyDoubleQuote]Working\[CloseCurlyDoubleQuote] environment. \
Therefore, the main style definition cell and ",
  StyleBox["Cell[StyleData[All, \"Working\"], ", "Program"],
  StyleBox["options", "IT"],
  StyleBox["]", "Program"],
  " define all the options applied to the various cell styles within the \
Working environment."
}], "Text",
  CellTags->"StyleDefinitionEnvironments"],

Cell["\<\
Variations for all styles in a given environment are typically defined in a \
separate section near the top of the style sheet.\
\>", "Text",
  CellTags->"StyleDefinitionEnvironments"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Creating Your Own Style Sheet", "Section"],

Cell[CellGroupData[{

Cell["How to Create Your Own Style Sheet", "Subsection",
  CellTags->"CreatingStyleSheet"],

Cell[TextData[{
  "You can create your own style sheets instead of using the style sheets \
included with ",
  StyleBox["Mathematica", "IT"],
  ". To reduce the amount of work necessary in creating a style sheet, it is \
usually best to take a current style sheet that is similar to what you want, \
copy it, and then edit the copy. "
}], "Text",
  CellTags->"CreatingStyleSheet"],

Cell[TextData[{
  "For example, if you want a style sheet like ",
  StyleBox["Default.nb", "Program"],
  ", but you want to use a different font for the text cells:"
}], "Text",
  CellTags->"CreatingStyleSheet"],

Cell[TextData[{
  StyleBox["1.", "BF"],
  "  Make a copy of ",
  StyleBox["Default.nb", "Program"],
  " (located in the ",
  StyleBox["Mathematica", "IT"],
  " directory, in ",
  StyleBox["SystemFiles/FrontEnd/StyleSheets", "Program"],
  "), called ",
  StyleBox["MyDefault.nb", "Program"],
  ".\n",
  StyleBox["2.", "BF"],
  "  Open ",
  StyleBox["MyDefault.nb", "Program"],
  " and go to the cell that defines the style for Text. It is labeled \
\[OpenCurlyDoubleQuote]Prototype for style: Text\[CloseCurlyDoubleQuote]. \
Click the cell bracket for that cell.\n",
  StyleBox["3.", "BF"],
  "  From the Format menu, use the Font submenu and choose the font that will \
be the default font for Text cells.\n",
  StyleBox["4.", "BF"],
  "  Save the style sheet. "
}], "ItemizedText",
  CellTags->"CreatingStyleSheet"],

Cell[TextData[{
  "Now the style sheet ",
  StyleBox["MyDefault.nb", "Program"],
  " uses a different font for text cells. "
}], "Text",
  CellTags->"CreatingStyleSheet"],

Cell[TextData[{
  "If you want to create a style sheet and simultaneously see how changes to \
the style sheet will affect a particular notebook, you should first import a \
private style sheet into the notebook (see ",
  ButtonBox["Shared and Private Style Sheets",
    ButtonStyle->"OtherInformationLink"],
  ").  After you are finished editing the style sheet, make the style sheet \
the active window and then use ",
  StyleBox["File \[RightTriangle] Save As", "SR"],
  " to save the style sheet to a separate file. You can then reset the style \
sheet of the notebook to a shared style sheet. "
}], "Text",
  CellTags->"CreatingStyleSheet"],

Cell[TextData[{
  "You can set a personal style sheet to be the default style sheet. (See ",
  ButtonBox["Selecting the Default Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  ".)"
}], "Text",
  CellTags->"CreatingStyleSheet"]
}, Closed]],

Cell[CellGroupData[{

Cell["Creating New Cell Styles", "Subsection",
  CellTags->"NewCellStyles"],

Cell["\<\
You can create new cell styles by defining them in the style sheet. To define \
a new cell style:\
\>", "Text",
  CellTags->"NewCellStyles"],

Cell[TextData[{
  StyleBox["1.", "BF"],
  "  Select a style definition cell within the style sheet. It is best to \
choose a cell style that is similar to the desired style.\n",
  StyleBox["2.", "BF"],
  "  Copy and paste the cell in the style sheet. You now have two copies of \
the style definition cell.\n",
  StyleBox["3.", "BF"],
  "  Unformat one copy of the cell using ",
  StyleBox["Format \[RightTriangle] Show Expression", "SR"],
  ".\n",
  StyleBox["4.", "BF"],
  "  In the command ",
  StyleBox["StyleData[\"", "Program"],
  StyleBox["name", "IT"],
  StyleBox["\"]", "Program"],
  ", change ",
  StyleBox["name", "IT"],
  " so it is representative of the style. It should not be the same name as \
any other cell style in the sheet.\n",
  StyleBox["5.", "BF"],
  "  You can then either reformat the cell and set the options, or type in \
the options directly while the cell is unformatted. "
}], "ItemizedText",
  CellTags->"NewCellStyles"],

Cell["\<\
A new cell style is now present in the style sheet and can be used in any \
notebook that refers to this style sheet.\
\>", "Text",
  CellTags->"NewCellStyles"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Environment", "Section"],

Cell[CellGroupData[{

Cell["Working with Slide Shows", "Subsection",
  CellTags->"SlideShowEnvironment"],

Cell[TextData[{
  "You can create interactive slide shows using the ",
  StyleBox["CreateSlideShow", "SR"],
  " palette. In the Normal screen style environment, all the slides in the \
slide show are visible and can be edited. In the Slide Show environment, only \
one slide is visible at a time. "
}], "Text",
  CellTags->"SlideShowEnvironment"],

Cell[TextData[{
  "The slide show environment is available in the following ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " style sheets."
}], "Text",
  CellTags->"SlideShowEnvironment"],

Cell[BoxData[{
    \(\[Bullet]\ ArticleClassic\), "\[IndentingNewLine]", 
    \(\[Bullet]\ ArticleModern\), "\[IndentingNewLine]", 
    \(\[Bullet]\ Classic\), "\[IndentingNewLine]", 
    \(\[Bullet]\ Classroom\), "\[IndentingNewLine]", 
    \(\[Bullet]\ Demo\), "\[IndentingNewLine]", 
    \(\[Bullet]\ DemoText\), "\[IndentingNewLine]", 
    \(\[Bullet]\ HelpBrowser\), "\[IndentingNewLine]", 
    \(\[Bullet]\ NaturalColor\), "\[IndentingNewLine]", 
    \(\[Bullet]\ PastelColor\), "\[IndentingNewLine]", 
    \(\[Bullet]\ PrimaryColor\), "\[IndentingNewLine]", 
    \(\[Bullet]\ Report\), "\[IndentingNewLine]", 
    \(\[Bullet]\ Textbook\), "\[IndentingNewLine]", 
    \(\[Bullet]\ TutorialBook\)}], "ItemizedText",
  CellTags->"SlideShowEnvironment"],

Cell[TextData[{
  "For more information on slide shows, see ",
  ButtonBox["Creating Slide Shows",
    ButtonStyle->"GettingStartedLink"],
  "."
}], "Text",
  CellTags->"SlideShowEnvironment"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 662}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->{},
WindowSize->{520, 551},
WindowMargins->{{Automatic, 171}, {Automatic, -42}},
ShowCellTags->True,
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "StyleSheetIntroduction"->{
    Cell[1886, 61, 82, 1, 70, "Subsection",
      CellTags->"StyleSheetIntroduction"],
    Cell[1971, 64, 659, 10, 70, "Text",
      CellTags->"StyleSheetIntroduction"],
    Cell[2633, 76, 550, 9, 70, "Text",
      CellTags->"StyleSheetIntroduction"],
    Cell[3186, 87, 176, 4, 70, "Text",
      CellTags->"StyleSheetIntroduction"]},
  "ChangingStyleSheet"->{
    Cell[3399, 96, 79, 1, 70, "Subsection",
      CellTags->"ChangingStyleSheet"],
    Cell[3481, 99, 219, 5, 70, "Text",
      CellTags->"ChangingStyleSheet"],
    Cell[3703, 106, 365, 10, 70, "ItemizedText",
      CellTags->"ChangingStyleSheet"],
    Cell[4071, 118, 132, 3, 70, "Text",
      CellTags->"ChangingStyleSheet"],
    Cell[4284, 125, 380, 10, 70, "ItemizedText",
      CellTags->"ChangingStyleSheet"],
    Cell[4667, 137, 952, 26, 70, "Text",
      CellTags->"ChangingStyleSheet"],
    Cell[5622, 165, 169, 6, 70, "Caption",
      CellTags->"ChangingStyleSheet"]},
  "SharedPrivateStyleSheets"->{
    Cell[5828, 176, 93, 1, 70, "Subsection",
      CellTags->"SharedPrivateStyleSheets"],
    Cell[5924, 179, 588, 12, 70, "Text",
      CellTags->"SharedPrivateStyleSheets"],
    Cell[6515, 193, 224, 5, 70, "Text",
      CellTags->"SharedPrivateStyleSheets"],
    Cell[6742, 200, 284, 10, 70, "ItemizedText",
      CellTags->"SharedPrivateStyleSheets"],
    Cell[7029, 212, 130, 3, 70, "Text",
      CellTags->"SharedPrivateStyleSheets"],
    Cell[7162, 217, 350, 8, 70, "Text",
      CellTags->"SharedPrivateStyleSheets"]},
  "StyleSheetLocations"->{
    Cell[7549, 230, 83, 1, 70, "Subsection",
      CellTags->"StyleSheetLocations"],
    Cell[7635, 233, 340, 8, 70, "Text",
      CellTags->"StyleSheetLocations"],
    Cell[7978, 243, 332, 8, 70, "ItemizedText",
      CellTags->"StyleSheetLocations"],
    Cell[8313, 253, 215, 4, 70, "ItemizedText",
      CellTags->"StyleSheetLocations"],
    Cell[8531, 259, 5661, 140, 70, "Text",
      CellTags->"StyleSheetLocations"],
    Cell[14195, 401, 127, 3, 70, "Caption",
      CellTags->"StyleSheetLocations"],
    Cell[14325, 406, 248, 5, 70, "Text",
      CellTags->"StyleSheetLocations"],
    Cell[14576, 413, 213, 6, 70, "Text",
      CellTags->"StyleSheetLocations"],
    Cell[14792, 421, 246, 6, 70, "Text",
      CellTags->"StyleSheetLocations"]},
  "StyleSheetMethod"->{
    Cell[15075, 432, 75, 1, 70, "Subsection",
      CellTags->"StyleSheetMethod"],
    Cell[15153, 435, 478, 14, 70, "Text",
      CellTags->"StyleSheetMethod"],
    Cell[15634, 451, 678, 14, 70, "Text",
      CellTags->"StyleSheetMethod"],
    Cell[16315, 467, 430, 10, 70, "Text",
      CellTags->"StyleSheetMethod"],
    Cell[16748, 479, 1185, 26, 70, "Text",
      CellTags->"StyleSheetMethod"]},
  "EditingIntroduction"->{
    Cell[18047, 515, 69, 1, 70, "Subsection",
      CellTags->"EditingIntroduction"],
    Cell[18119, 518, 451, 8, 70, "Text",
      CellTags->"EditingIntroduction"]},
  "EditingSharedPrivate"->{
    Cell[18607, 531, 96, 1, 70, "Subsection",
      CellTags->"EditingSharedPrivate"],
    Cell[18706, 534, 393, 7, 70, "Text",
      CellTags->"EditingSharedPrivate"],
    Cell[19102, 543, 466, 11, 70, "Text",
      CellTags->"EditingSharedPrivate"],
    Cell[19571, 556, 259, 6, 70, "Text",
      CellTags->"EditingSharedPrivate"],
    Cell[19833, 564, 838, 17, 70, "ItemizedText",
      CellTags->"EditingSharedPrivate"],
    Cell[20674, 583, 278, 6, 70, "Text",
      CellTags->"EditingSharedPrivate"]},
  "ChangingCellOptions"->{
    Cell[20989, 594, 78, 1, 70, "Subsection",
      CellTags->"ChangingCellOptions"],
    Cell[21070, 597, 740, 15, 70, "Text",
      CellTags->"ChangingCellOptions"],
    Cell[21813, 614, 289, 10, 70, "Text",
      CellTags->"ChangingCellOptions"],
    Cell[22105, 626, 211, 4, 70, "Text",
      CellTags->"ChangingCellOptions"],
    Cell[22319, 632, 251, 6, 70, "ItemizedText",
      CellTags->"ChangingCellOptions"],
    Cell[22573, 640, 106, 1, 70, "Text",
      CellTags->"ChangingCellOptions"],
    Cell[22682, 643, 442, 12, 70, "Text",
      CellTags->"ChangingCellOptions"]},
  "ChangingEnvironmentOptions"->{
    Cell[23161, 660, 98, 1, 70, "Subsection",
      CellTags->"ChangingEnvironmentOptions"],
    Cell[23262, 663, 652, 12, 70, "Text",
      CellTags->"ChangingEnvironmentOptions"],
    Cell[23917, 677, 296, 10, 70, "Text",
      CellTags->"ChangingEnvironmentOptions"],
    Cell[24216, 689, 397, 14, 70, "Text",
      CellTags->"ChangingEnvironmentOptions"],
    Cell[24616, 705, 453, 16, 70, "Text",
      CellTags->"ChangingEnvironmentOptions"],
    Cell[25072, 723, 387, 14, 70, "Text",
      CellTags->"ChangingEnvironmentOptions"],
    Cell[25462, 739, 187, 4, 70, "Text",
      CellTags->"ChangingEnvironmentOptions"]},
  "OtherEditingTips"->{
    Cell[25686, 748, 72, 1, 70, "Subsection",
      CellTags->"OtherEditingTips"],
    Cell[25761, 751, 154, 4, 70, "Text",
      CellTags->"OtherEditingTips"],
    Cell[25918, 757, 473, 10, 70, "ItemizedText",
      CellTags->"OtherEditingTips"]},
  "OptionStoring"->{
    Cell[26428, 772, 70, 1, 70, "Subsection",
      CellTags->"OptionStoring"],
    Cell[26501, 775, 793, 26, 70, "Text",
      CellTags->"OptionStoring"]},
  "DefaultStyleSheetIntroduction"->{
    Cell[27407, 811, 99, 1, 70, "Subsection",
      CellTags->"DefaultStyleSheetIntroduction"],
    Cell[27509, 814, 411, 9, 70, "Text",
      CellTags->"DefaultStyleSheetIntroduction"],
    Cell[27923, 825, 271, 5, 70, "Text",
      CellTags->"DefaultStyleSheetIntroduction"]},
  "DefaultStyleSheetLocation"->{
    Cell[28231, 835, 98, 1, 70, "Subsection",
      CellTags->"DefaultStyleSheetLocation"],
    Cell[28332, 838, 350, 11, 70, "Text",
      CellTags->"DefaultStyleSheetLocation"]},
  "ChangingDefaultStyleSheet"->{
    Cell[28719, 854, 96, 1, 70, "Subsection",
      CellTags->"ChangingDefaultStyleSheet"],
    Cell[28818, 857, 115, 1, 70, "Text",
      CellTags->"ChangingDefaultStyleSheet"],
    Cell[28936, 860, 761, 25, 70, "ItemizedText",
      CellTags->"ChangingDefaultStyleSheet"],
    Cell[29700, 887, 148, 4, 70, "Text",
      CellTags->"ChangingDefaultStyleSheet"]},
  "StoringDefaultStyleSheet"->{
    Cell[29885, 896, 100, 1, 70, "Subsection",
      CellTags->"StoringDefaultStyleSheet"],
    Cell[29988, 899, 596, 15, 70, "Text",
      CellTags->"StoringDefaultStyleSheet"]},
  "EnvironmentIntroduction"->{
    Cell[30695, 924, 89, 1, 70, "Subsection",
      CellTags->"EnvironmentIntroduction"],
    Cell[30787, 927, 335, 6, 70, "Text",
      CellTags->"EnvironmentIntroduction"],
    Cell[31125, 935, 204, 5, 70, "Text",
      CellTags->"EnvironmentIntroduction"],
    Cell[31332, 942, 311, 8, 70, "ItemizedText",
      CellTags->"EnvironmentIntroduction"],
    Cell[31646, 952, 313, 8, 70, "ItemizedText",
      CellTags->"EnvironmentIntroduction"],
    Cell[31962, 962, 152, 4, 70, "Text",
      CellTags->"EnvironmentIntroduction"],
    Cell[32117, 968, 557, 14, 70, "Text",
      CellTags->"EnvironmentIntroduction"]},
  "SettingEnvironments"->{
    Cell[32711, 987, 99, 1, 70, "Subsection",
      CellTags->"SettingEnvironments"],
    Cell[32813, 990, 488, 9, 70, "Text",
      CellTags->"SettingEnvironments"],
    Cell[33304, 1001, 531, 10, 70, "Text",
      CellTags->"SettingEnvironments"]},
  "StyleDefinitionEnvironments"->{
    Cell[33872, 1016, 104, 1, 70, "Subsection",
      CellTags->"StyleDefinitionEnvironments"],
    Cell[33979, 1019, 290, 5, 70, "Text",
      CellTags->"StyleDefinitionEnvironments"],
    Cell[34272, 1026, 1344, 32, 70, "ItemizedText",
      CellTags->"StyleDefinitionEnvironments"],
    Cell[35619, 1060, 782, 19, 70, "ItemizedText",
      CellTags->"StyleDefinitionEnvironments"],
    Cell[36404, 1081, 487, 12, 70, "ItemizedText",
      CellTags->"StyleDefinitionEnvironments"],
    Cell[36894, 1095, 748, 16, 70, "ItemizedText",
      CellTags->"StyleDefinitionEnvironments"],
    Cell[37645, 1113, 455, 10, 70, "ItemizedText",
      CellTags->"StyleDefinitionEnvironments"],
    Cell[38103, 1125, 802, 17, 70, "Text",
      CellTags->"StyleDefinitionEnvironments"],
    Cell[38908, 1144, 632, 12, 70, "Text",
      CellTags->"StyleDefinitionEnvironments"],
    Cell[39543, 1158, 194, 4, 70, "Text",
      CellTags->"StyleDefinitionEnvironments"]},
  "CreatingStyleSheet"->{
    Cell[39859, 1172, 90, 1, 48, "Subsection",
      CellTags->"CreatingStyleSheet"],
    Cell[39952, 1175, 380, 8, 68, "Text",
      CellTags->"CreatingStyleSheet"],
    Cell[40335, 1185, 211, 5, 52, "Text",
      CellTags->"CreatingStyleSheet"],
    Cell[40549, 1192, 816, 23, 146, "ItemizedText",
      CellTags->"CreatingStyleSheet"],
    Cell[41368, 1217, 170, 5, 36, "Text",
      CellTags->"CreatingStyleSheet"],
    Cell[41541, 1224, 645, 12, 100, "Text",
      CellTags->"CreatingStyleSheet"],
    Cell[42189, 1238, 236, 6, 52, "Text",
      CellTags->"CreatingStyleSheet"]},
  "NewCellStyles"->{
    Cell[42462, 1249, 75, 1, 48, "Subsection",
      CellTags->"NewCellStyles"],
    Cell[42540, 1252, 150, 4, 36, "Text",
      CellTags->"NewCellStyles"],
    Cell[42693, 1258, 952, 24, 182, "ItemizedText",
      CellTags->"NewCellStyles"],
    Cell[43648, 1284, 170, 4, 52, "Text",
      CellTags->"NewCellStyles"]},
  "SlideShowEnvironment"->{
    Cell[43933, 1298, 82, 1, 53, "Subsection",
      CellTags->"SlideShowEnvironment"],
    Cell[44018, 1301, 346, 7, 73, "Text",
      CellTags->"SlideShowEnvironment"],
    Cell[44367, 1310, 197, 6, 39, "Text",
      CellTags->"SlideShowEnvironment"],
    Cell[44567, 1318, 756, 14, 267, "ItemizedText",
      CellTags->"SlideShowEnvironment"],
    Cell[45326, 1334, 192, 6, 39, "Text",
      CellTags->"SlideShowEnvironment"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"StyleSheetIntroduction", 46300, 1365},
  {"ChangingStyleSheet", 46661, 1374},
  {"SharedPrivateStyleSheets", 47272, 1389},
  {"StyleSheetLocations", 47825, 1402},
  {"StyleSheetMethod", 48601, 1421},
  {"EditingIntroduction", 49029, 1432},
  {"EditingSharedPrivate", 49225, 1437},
  {"ChangingCellOptions", 49760, 1450},
  {"ChangingEnvironmentOptions", 50378, 1465},
  {"OtherEditingTips", 51029, 1480},
  {"OptionStoring", 51299, 1487},
  {"DefaultStyleSheetIntroduction", 51493, 1492},
  {"DefaultStyleSheetLocation", 51805, 1499},
  {"ChangingDefaultStyleSheet", 52019, 1504},
  {"StoringDefaultStyleSheet", 52414, 1513},
  {"EnvironmentIntroduction", 52625, 1518},
  {"SettingEnvironments", 53270, 1533},
  {"StyleDefinitionEnvironments", 53556, 1540},
  {"CreatingStyleSheet", 54537, 1561},
  {"NewCellStyles", 55143, 1576},
  {"SlideShowEnvironment", 55491, 1585}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 29, 0, 105, "Title"],

Cell[CellGroupData[{
Cell[1830, 57, 31, 0, 56, "Section"],

Cell[CellGroupData[{
Cell[1886, 61, 82, 1, 70, "Subsection",
  CellTags->"StyleSheetIntroduction"],
Cell[1971, 64, 659, 10, 70, "Text",
  CellTags->"StyleSheetIntroduction"],
Cell[2633, 76, 550, 9, 70, "Text",
  CellTags->"StyleSheetIntroduction"],
Cell[3186, 87, 176, 4, 70, "Text",
  CellTags->"StyleSheetIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[3399, 96, 79, 1, 70, "Subsection",
  CellTags->"ChangingStyleSheet"],
Cell[3481, 99, 219, 5, 70, "Text",
  CellTags->"ChangingStyleSheet"],
Cell[3703, 106, 365, 10, 70, "ItemizedText",
  CellTags->"ChangingStyleSheet"],
Cell[4071, 118, 132, 3, 70, "Text",
  CellTags->"ChangingStyleSheet"],
Cell[4206, 123, 75, 0, 70, "Text"],
Cell[4284, 125, 380, 10, 70, "ItemizedText",
  CellTags->"ChangingStyleSheet"],
Cell[4667, 137, 952, 26, 70, "Text",
  CellTags->"ChangingStyleSheet"],
Cell[5622, 165, 169, 6, 70, "Caption",
  CellTags->"ChangingStyleSheet"]
}, Closed]],

Cell[CellGroupData[{
Cell[5828, 176, 93, 1, 70, "Subsection",
  CellTags->"SharedPrivateStyleSheets"],
Cell[5924, 179, 588, 12, 70, "Text",
  CellTags->"SharedPrivateStyleSheets"],
Cell[6515, 193, 224, 5, 70, "Text",
  CellTags->"SharedPrivateStyleSheets"],
Cell[6742, 200, 284, 10, 70, "ItemizedText",
  CellTags->"SharedPrivateStyleSheets"],
Cell[7029, 212, 130, 3, 70, "Text",
  CellTags->"SharedPrivateStyleSheets"],
Cell[7162, 217, 350, 8, 70, "Text",
  CellTags->"SharedPrivateStyleSheets"]
}, Closed]],

Cell[CellGroupData[{
Cell[7549, 230, 83, 1, 70, "Subsection",
  CellTags->"StyleSheetLocations"],
Cell[7635, 233, 340, 8, 70, "Text",
  CellTags->"StyleSheetLocations"],
Cell[7978, 243, 332, 8, 70, "ItemizedText",
  CellTags->"StyleSheetLocations"],
Cell[8313, 253, 215, 4, 70, "ItemizedText",
  CellTags->"StyleSheetLocations"],
Cell[8531, 259, 5661, 140, 70, "Text",
  CellTags->"StyleSheetLocations"],
Cell[14195, 401, 127, 3, 70, "Caption",
  CellTags->"StyleSheetLocations"],
Cell[14325, 406, 248, 5, 70, "Text",
  CellTags->"StyleSheetLocations"],
Cell[14576, 413, 213, 6, 70, "Text",
  CellTags->"StyleSheetLocations"],
Cell[14792, 421, 246, 6, 70, "Text",
  CellTags->"StyleSheetLocations"]
}, Closed]],

Cell[CellGroupData[{
Cell[15075, 432, 75, 1, 70, "Subsection",
  CellTags->"StyleSheetMethod"],
Cell[15153, 435, 478, 14, 70, "Text",
  CellTags->"StyleSheetMethod"],
Cell[15634, 451, 678, 14, 70, "Text",
  CellTags->"StyleSheetMethod"],
Cell[16315, 467, 430, 10, 70, "Text",
  CellTags->"StyleSheetMethod"],
Cell[16748, 479, 1185, 26, 70, "Text",
  CellTags->"StyleSheetMethod"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17982, 511, 40, 0, 42, "Section"],

Cell[CellGroupData[{
Cell[18047, 515, 69, 1, 70, "Subsection",
  CellTags->"EditingIntroduction"],
Cell[18119, 518, 451, 8, 70, "Text",
  CellTags->"EditingIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[18607, 531, 96, 1, 70, "Subsection",
  CellTags->"EditingSharedPrivate"],
Cell[18706, 534, 393, 7, 70, "Text",
  CellTags->"EditingSharedPrivate"],
Cell[19102, 543, 466, 11, 70, "Text",
  CellTags->"EditingSharedPrivate"],
Cell[19571, 556, 259, 6, 70, "Text",
  CellTags->"EditingSharedPrivate"],
Cell[19833, 564, 838, 17, 70, "ItemizedText",
  CellTags->"EditingSharedPrivate"],
Cell[20674, 583, 278, 6, 70, "Text",
  CellTags->"EditingSharedPrivate"]
}, Closed]],

Cell[CellGroupData[{
Cell[20989, 594, 78, 1, 70, "Subsection",
  CellTags->"ChangingCellOptions"],
Cell[21070, 597, 740, 15, 70, "Text",
  CellTags->"ChangingCellOptions"],
Cell[21813, 614, 289, 10, 70, "Text",
  CellTags->"ChangingCellOptions"],
Cell[22105, 626, 211, 4, 70, "Text",
  CellTags->"ChangingCellOptions"],
Cell[22319, 632, 251, 6, 70, "ItemizedText",
  CellTags->"ChangingCellOptions"],
Cell[22573, 640, 106, 1, 70, "Text",
  CellTags->"ChangingCellOptions"],
Cell[22682, 643, 442, 12, 70, "Text",
  CellTags->"ChangingCellOptions"]
}, Closed]],

Cell[CellGroupData[{
Cell[23161, 660, 98, 1, 70, "Subsection",
  CellTags->"ChangingEnvironmentOptions"],
Cell[23262, 663, 652, 12, 70, "Text",
  CellTags->"ChangingEnvironmentOptions"],
Cell[23917, 677, 296, 10, 70, "Text",
  CellTags->"ChangingEnvironmentOptions"],
Cell[24216, 689, 397, 14, 70, "Text",
  CellTags->"ChangingEnvironmentOptions"],
Cell[24616, 705, 453, 16, 70, "Text",
  CellTags->"ChangingEnvironmentOptions"],
Cell[25072, 723, 387, 14, 70, "Text",
  CellTags->"ChangingEnvironmentOptions"],
Cell[25462, 739, 187, 4, 70, "Text",
  CellTags->"ChangingEnvironmentOptions"]
}, Closed]],

Cell[CellGroupData[{
Cell[25686, 748, 72, 1, 70, "Subsection",
  CellTags->"OtherEditingTips"],
Cell[25761, 751, 154, 4, 70, "Text",
  CellTags->"OtherEditingTips"],
Cell[25918, 757, 473, 10, 70, "ItemizedText",
  CellTags->"OtherEditingTips"]
}, Closed]],

Cell[CellGroupData[{
Cell[26428, 772, 70, 1, 70, "Subsection",
  CellTags->"OptionStoring"],
Cell[26501, 775, 793, 26, 70, "Text",
  CellTags->"OptionStoring"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27343, 807, 39, 0, 42, "Section"],

Cell[CellGroupData[{
Cell[27407, 811, 99, 1, 70, "Subsection",
  CellTags->"DefaultStyleSheetIntroduction"],
Cell[27509, 814, 411, 9, 70, "Text",
  CellTags->"DefaultStyleSheetIntroduction"],
Cell[27923, 825, 271, 5, 70, "Text",
  CellTags->"DefaultStyleSheetIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[28231, 835, 98, 1, 70, "Subsection",
  CellTags->"DefaultStyleSheetLocation"],
Cell[28332, 838, 350, 11, 70, "Text",
  CellTags->"DefaultStyleSheetLocation"]
}, Closed]],

Cell[CellGroupData[{
Cell[28719, 854, 96, 1, 70, "Subsection",
  CellTags->"ChangingDefaultStyleSheet"],
Cell[28818, 857, 115, 1, 70, "Text",
  CellTags->"ChangingDefaultStyleSheet"],
Cell[28936, 860, 761, 25, 70, "ItemizedText",
  CellTags->"ChangingDefaultStyleSheet"],
Cell[29700, 887, 148, 4, 70, "Text",
  CellTags->"ChangingDefaultStyleSheet"]
}, Closed]],

Cell[CellGroupData[{
Cell[29885, 896, 100, 1, 70, "Subsection",
  CellTags->"StoringDefaultStyleSheet"],
Cell[29988, 899, 596, 15, 70, "Text",
  CellTags->"StoringDefaultStyleSheet"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[30633, 920, 37, 0, 42, "Section"],

Cell[CellGroupData[{
Cell[30695, 924, 89, 1, 70, "Subsection",
  CellTags->"EnvironmentIntroduction"],
Cell[30787, 927, 335, 6, 70, "Text",
  CellTags->"EnvironmentIntroduction"],
Cell[31125, 935, 204, 5, 70, "Text",
  CellTags->"EnvironmentIntroduction"],
Cell[31332, 942, 311, 8, 70, "ItemizedText",
  CellTags->"EnvironmentIntroduction"],
Cell[31646, 952, 313, 8, 70, "ItemizedText",
  CellTags->"EnvironmentIntroduction"],
Cell[31962, 962, 152, 4, 70, "Text",
  CellTags->"EnvironmentIntroduction"],
Cell[32117, 968, 557, 14, 70, "Text",
  CellTags->"EnvironmentIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[32711, 987, 99, 1, 70, "Subsection",
  CellTags->"SettingEnvironments"],
Cell[32813, 990, 488, 9, 70, "Text",
  CellTags->"SettingEnvironments"],
Cell[33304, 1001, 531, 10, 70, "Text",
  CellTags->"SettingEnvironments"]
}, Closed]],

Cell[CellGroupData[{
Cell[33872, 1016, 104, 1, 70, "Subsection",
  CellTags->"StyleDefinitionEnvironments"],
Cell[33979, 1019, 290, 5, 70, "Text",
  CellTags->"StyleDefinitionEnvironments"],
Cell[34272, 1026, 1344, 32, 70, "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],
Cell[35619, 1060, 782, 19, 70, "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],
Cell[36404, 1081, 487, 12, 70, "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],
Cell[36894, 1095, 748, 16, 70, "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],
Cell[37645, 1113, 455, 10, 70, "ItemizedText",
  CellTags->"StyleDefinitionEnvironments"],
Cell[38103, 1125, 802, 17, 70, "Text",
  CellTags->"StyleDefinitionEnvironments"],
Cell[38908, 1144, 632, 12, 70, "Text",
  CellTags->"StyleDefinitionEnvironments"],
Cell[39543, 1158, 194, 4, 70, "Text",
  CellTags->"StyleDefinitionEnvironments"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[39786, 1168, 48, 0, 42, "Section"],

Cell[CellGroupData[{
Cell[39859, 1172, 90, 1, 48, "Subsection",
  CellTags->"CreatingStyleSheet"],
Cell[39952, 1175, 380, 8, 68, "Text",
  CellTags->"CreatingStyleSheet"],
Cell[40335, 1185, 211, 5, 52, "Text",
  CellTags->"CreatingStyleSheet"],
Cell[40549, 1192, 816, 23, 146, "ItemizedText",
  CellTags->"CreatingStyleSheet"],
Cell[41368, 1217, 170, 5, 36, "Text",
  CellTags->"CreatingStyleSheet"],
Cell[41541, 1224, 645, 12, 100, "Text",
  CellTags->"CreatingStyleSheet"],
Cell[42189, 1238, 236, 6, 52, "Text",
  CellTags->"CreatingStyleSheet"]
}, Closed]],

Cell[CellGroupData[{
Cell[42462, 1249, 75, 1, 48, "Subsection",
  CellTags->"NewCellStyles"],
Cell[42540, 1252, 150, 4, 36, "Text",
  CellTags->"NewCellStyles"],
Cell[42693, 1258, 952, 24, 182, "ItemizedText",
  CellTags->"NewCellStyles"],
Cell[43648, 1284, 170, 4, 52, "Text",
  CellTags->"NewCellStyles"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[43867, 1294, 41, 0, 42, "Section"],

Cell[CellGroupData[{
Cell[43933, 1298, 82, 1, 53, "Subsection",
  CellTags->"SlideShowEnvironment"],
Cell[44018, 1301, 346, 7, 73, "Text",
  CellTags->"SlideShowEnvironment"],
Cell[44367, 1310, 197, 6, 39, "Text",
  CellTags->"SlideShowEnvironment"],
Cell[44567, 1318, 756, 14, 267, "ItemizedText",
  CellTags->"SlideShowEnvironment"],
Cell[45326, 1334, 192, 6, 39, "Text",
  CellTags->"SlideShowEnvironment"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

