(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    697822,      10591]*)
(*NotebookOutlinePosition[    766223,      13018]*)
(*  CellTagsIndexPosition[    765637,      12999]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "What Is ",
  Cell[BoxData[
      \(TraditionalForm\`MathReader\^\[Trademark]\)],
    FormatType->StandardForm],
  "?"
}], "Subsection",
  CellTags->"WhatisMathReader_SA"],

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic"],
  "  is a free application for viewing and printing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-compatible ",
  ButtonBox["notebook documents",
    ButtonData:>"The Notebook Format",
    ButtonStyle->"OtherInformationLink"],
  ". "
}], "EmphasisText",
  CellTags->"WhatisMathReader_SA"],

Cell[TextData[{
  "Using ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " you can"
}], "Text",
  CellTags->"WhatisMathReader_SA"],

Cell["\<\
    \[Bullet] view the contents of any notebook    \
\>", "Text",
  CellMargins->{{30, 40}, {4, 8}},
  LineSpacing->{0.7, 3},
  ParagraphSpacing->{0, 0},
  CellTags->"WhatisMathReader_SA"],

Cell["\<\
    \[Bullet] animate graphics and play sounds\
\>", "Text",
  CellMargins->{{30, 40}, {4, 8}},
  LineSpacing->{0.7, 3},
  ParagraphSpacing->{0, 0},
  CellTags->"WhatisMathReader_SA"],

Cell["\<\
    \[Bullet] copy and paste into other applications \
\>", "Text",
  CellMargins->{{30, 40}, {4, 8}},
  LineSpacing->{0.7, 3},
  ParagraphSpacing->{0, 0},
  CellTags->"WhatisMathReader_SA"],

Cell["    \[Bullet] print a notebook", "Text",
  CellMargins->{{30, 40}, {4, 8}},
  LineSpacing->{0.7, 3},
  ParagraphSpacing->{0, 0},
  CellTags->"WhatisMathReader_SA"],

Cell[TextData[{
  "To create or edit a notebook, you must have a complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end. "
}], "Text",
  CellTags->"WhatisMathReader_SA"],

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " is available for free download at ",
  ButtonBox["www.wolfram.com/mathreader",
    ButtonData:>{
      URL[ "http://www.wolfram.com/mathreader"], None},
    ButtonStyle->"Hyperlink"],
  ". Using ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  ", you can view notebooks sent to you by colleagues even if you are not a \
licensed ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " user."
}], "Text",
  CellTags->"WhatisMathReader_SA"],

Cell[TextData[{
  StyleBox["Note:",
    FontWeight->"Bold"],
  " The full ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system consists of a front end, which serves as the user interface, and a \
kernel, which does computations. For more information about ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " ",
  ButtonBox["click here",
    ButtonData:>"T.0",
    ButtonStyle->"MainBookLink"],
  ".    "
}], "Text",
  CellTags->"WhatisMathReader_SA"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "What Is ",
  Cell[BoxData[
      \(TraditionalForm\`MathReader\^\[Trademark]\)],
    FormatType->StandardForm],
  "?"
}], "Subsection",
  CellTags->"WhatisMathReader"],

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic"],
  "  is a free application for viewing and printing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-compatible ",
  ButtonBox["notebook documents",
    ButtonData:>"The Notebook Format",
    ButtonStyle->"OtherInformationLink"],
  ". "
}], "EmphasisText",
  CellTags->"WhatisMathReader"],

Cell[TextData[{
  "If you install ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " without entering a password, you can still run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " mode. In this mode you can:"
}], "Text",
  CellTags->"WhatisMathReader"],

Cell["\<\
    \[Bullet] view the contents of any notebook   \
\>", "Text",
  CellMargins->{{30, 40}, {4, 8}},
  LineSpacing->{0.7, 3},
  ParagraphSpacing->{0, 0},
  CellTags->"WhatisMathReader"],

Cell["\<\
    \[Bullet] animate graphics and play sounds\
\>", "Text",
  CellMargins->{{30, 40}, {4, 8}},
  LineSpacing->{0.7, 3},
  ParagraphSpacing->{0, 0},
  CellTags->"WhatisMathReader"],

Cell["\<\
    \[Bullet] copy and paste into other applications \
\>", "Text",
  CellMargins->{{30, 40}, {4, 8}},
  LineSpacing->{0.7, 3},
  ParagraphSpacing->{0, 0},
  CellTags->"WhatisMathReader"],

Cell["    \[Bullet] print a notebook", "Text",
  CellMargins->{{30, 40}, {4, 8}},
  LineSpacing->{0.7, 3},
  ParagraphSpacing->{0, 0},
  CellTags->"WhatisMathReader"],

Cell[TextData[{
  "To create or edit a notebook, you must register your copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and obtain a password. For information on how to register, ",
  ButtonBox["click here",
    ButtonData:>"Registration",
    ButtonStyle->"GettingStartedLink"],
  ". "
}], "Text",
  CellTags->"WhatisMathReader"],

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " is also available as a stand-alone application, for free download at ",
  ButtonBox["www.wolfram.com/mathreader",
    ButtonData:>{
      URL[ "http://www.wolfram.com/mathreader"], None},
    ButtonStyle->"Hyperlink"],
  ". This makes it possible for you to share notebooks with colleagues who \
are not ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users. "
}], "Text",
  CellTags->"WhatisMathReader"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Notebook Format", "Subsection",
  CellTags->"NotebookFormat"],

Cell["\<\
Notebooks are interactive documents which combine text, equations, \
graphics, and sounds in a single platform-independent file format. \
\>", \
"EmphasisText",
  CellTags->"NotebookFormat"],

Cell["\<\
Notebooks are ideally suited for the creation of \
professional-quality technical documents. They can be readily optimized for \
both print and electronic publication. \
\>", "Text",
  CellTags->"NotebookFormat"],

Cell[TextData[{
  "Notebooks can also include interactive elements like hyperlinks, buttons, \
and palettes. Hyperlinks will work in ",
  StyleBox["MathReader.",
    FontSlant->"Italic"],
  " However, buttons and palettes require a complete ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "front end."
}], "Text",
  CellTags->"NotebookFormat"],

Cell["\<\
Notebooks are saved as plain ASCII text files rather than in binary \
format. This makes them easily portable\[LongDash]they can be transmitted by \
email or by FTP in text mode and shared by users on different computer \
platforms. They can also be made available for downloading over the web. The \
notebook format is denoted by the extension .nb.\
\>", "Text",
  CellTags->"NotebookFormat"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005?0001BA000`40O003
h00O01iWnGliKg]_NfLiOcUWnFmkOcU_NfOiOcUWnGliIcU_NgoiIcUo>FOi
OcUWnGliKg]WnGliKg]o>FOiOcT2Kg/01GliKg]_NgliIoT00Wli00=WnGli
Kg/00Vmk00Io>FOiOcUW>FOiOcT2Kg/08gliIoUo>FLiOoU_NgliIoUo>FLi
OcUWlWliKg]o>FOiOcU_NfOiOcUW>GoiIcUo>FOiKg]W>GoiOcUW>GNmOc9W
nGliIcT00Wli01IWnFLiOcUWnGliKg]o>FOiOcUW>GoiIcUo>FOiOcU_Ngoi
IcUonFLiOcUWn@9o>@9_N`08OcUWnGliIoUW>GliIoUW>@9_N`05OcUWnGli
IcUWn@02OcT00fOiKg]o>@03Kg/2OcT01VOiOcUW>GliIoUo>@9_N`07OcUW
>GoiKg]o>FOiOcT00Vmk00io>FmkOcUWnFLiOoUW>GoiIcUo>FOiOcUW>Gli
0Vmk00IWnGliKg]o>FOiKg/2OcT026LiOoUW>GliIoUW>GoiOcT2Kg/01Gli
IoUo>FOiOcT00Vmk01Mo>FOiOcUWnGliKg]o>FmkIc9g_GliIoUo>FOiOcUW
>GliIoUo>FLiOcUWnGli009_N`0>OcU_NfmkOc9WnGliKg]o>FmkOcUWnFLi
IoUo>@9_N`05OcUWnGliIoUo>@02Kg/02WliIoUo>FmkIcUonFLiOcUWnGli
0Vmk00Yo<VOiOcUWnGliKg]W>GoiKg]o>@9_N`08OcUWnFLiOcUWnGliKg]o
>@9_N`0/OcUWnFLiOcUWnGliKg]o>FOiOcUWnGliIoUo>FmkOcUWnGliIoUo
>FLiIoUo>FOiOcUW>GoiIcUo>FOiOcUWnFLiOcUWnFmkOcU_NgliIoUW>Goi
IcUo>@=_N`07IoUo>FLiOoUW>GliIoT00Gli00007GliIcUonFLiOoUo>Fmk
OcU_NfOiOcUW>GliIoUo>GoiIcUo>FmkMkeo>FLiOoUW>GliKg]o>FOiOcT0
0Vmk00Uo>FOiKg]o>FOiOcUW>FOiOc800fmk01=o>FOiOcUWnGliKg]o>FOi
OcUWnGliIcUonFLiOoUW>GliIoUo>@02Kg/017liIoU_Ngli0Vmk011o>FOi
OcU_NgliIoUo>FLiOoUo>FLiOoUW<VmkOcUWn@9o>@0>IoUW>GoiKg]o>FLi
OoUW>GliIoUo>FmkOoUW>@A_N`05OcUW>GNmIcUo>@02Kg/016LiOoUW>Gli
0Vmk00]o>FmkKg]o>FOiOcU_NgliKg]WnGli009_N`03IcUo>Fmk009_N`06
OcUW>FOiOcUWnGli0Vmk00EWnGlbKg]WnGli009_N`04IcUo>FOiOcT2Kg/0
4gliIoUW>GoiIcUo>FmkOcUWnGliIcUonFLiOoUW>GliIcUo>FOi009o>@0J
IoUW>GoiIcUo>FOiOcU_NgliIcU_NgliIoUo<VmkOcUWnFmkOcUWnGliIcUo
>FOiOcUWn@9_N`0=OcUWnGliIcUo>FOiOcUWnGliKg]o>FOiOcT00Vmk00Ao
>FmkIoUo>@9_N`07OcUWnFmkOcUWnGliKg/00Wli00QWnGliIoUo>FLiOcUW
nGlb0Vmk00Qo>FmkIcUonFLiOoU_Nglb0Vmk00io>FOiOcU_NgliKg]W>Goi
IcUo>FOiKg]o>FOi0Wli00QWnGliIoUo>FOiKg]o>FOi0Wli03=WnGliIcUo
nFLiOcUWnGliKg]W>GoiIcU_NgliIoUW>GliIoUo>FmkOcUWnGliIcUonFLi
OcU_NgliKg]onFLiOcUWnGliIoUo>FmkOcUWnGliIoUo>FmkOcUW>GoiIcUo
>FOiOcT00Fmk00002FmkOcUW>GoiIcUWnGliKg]o<P02Kg/09WoiIcUo>FOi
IcUo>FOiOcUW<VOiOcUW>GoiIcUonFLiOcU_NgliIoUo>FLiOcUWnGliKg]o
nFLiKg]o>FmkOc9WnGliIcUo>FOiOcT2Kg/037liKg]_NgoiIcUo>FLiOoUW
>GliIoUo>@9_N`07Oc9_NfmkOcUWnFLiOcT00fmk00Ao>FOiOcUW>@=_N`07
OcU_NfmkOc9_NfOiOcT00Vmk02Eo<VOiOcUW>GoiIcUo>FOiOcUW>GoiKg]o
>FOiOcUW>GoiIcUonFLiOcUWnGliIcUonFLiKg]o>FOiOcU_NgNmOc9W>Goi
IcUo>@02Kg/07GliIoUo>FOiOcU_NgliIoUo>FLiKg]o>FOiOcU_NgliKg]o
>FLiOoU_NgliIoU_NgliIoUo>FmkIoT00Wli00IW>GoiIcUo>FOiOcT2Kg/0
2GlbKg]_NgoiKg]o>FOiOcUWn@02OcT2Kg/02WliIoUo>FLiOoUW>GoiIcUW
nGli0Vmk01Io>FLiOcUWnGliIoUo>FLiOcU_NglbKg]g_FmkOc9WnGliKg]o
>FmkOc9Wn@9_N`05Oc9WnGliKg]Wn@02OcT04FOiOcU_NfmkOcUW>FOiOcUW
>GoiIcU_NgliIoUo>FOiOcT00fmk019o>FOiOcUWnGliKg]o>FLiMke_Ngli
IoUo>FmkIcUonFLiOcT2Kg/00gliKg]o>@02Kg/05GliIoUW>GliKg]o>FOi
OcU_NfLiOcUWnFmkOcUWnGliIcUonFLiOcUWn@02OcT016LiOoUW>Fmk0Wli
00EWnGliKg]_Ngli009_N`0FOcUW>GoiIcUonFLiOcUW>GoiIcUo>FOiOcUW
nGliIcUo>FOiOcUW>GoiIcT2Kg/017liIoUo>FOi0Gli00000gliIoUo>@02
Kg/027liIoUo>FmkIcUonFLiOcT2Kg/00gliIoUo>@02Kg/01WliIoUo>FLi
OoUW<P=_N`08IoUo>FLiOcUWnGliMkeW<P9_N`03OcUWnGli00=_N`0HOcUW
nGliKg]WlWliKg]W<WoiIcUo>FOiOcUW>GoiIcUo>FOiKg]o>FmkIoUo>FOi
0Wli01=_NfOiOcUo>FOiIcUo>FOiOcU_NgliIoU_NgliIoU_NgliKg]o>@03
Kg/00gliIoUo>@02Kg/04GliIcUonFLiOcUWnGliIcUonFmkOcUW>GoiIcUo
>FOiOcT00Vmk01Eo>FOiOcUWnGliIc9_NgoiIcUWnGliIoUo>FOiOc9_Ngli
IoUo>FOiOc800Vmk00aolVmkOcUWnGliIoUo>FLiOoUW>GliIoT2OcT03Vmk
IcUonFLiOcU_NfOiOcU_NgliIoUo<VmkOcT2Kg/04fOiOcUW>GliIoUo>FLi
Kg]o>FLiIoUo>FOiOcUW>GoiIcUonFLi009o>@9_N`0:OcUWnGliIoUo>FLi
OcUWnGliIoT2Kg/00goiIc9o>@04Kg/01WliIoU_NgliKg]o>@A_N`9o>@0D
IoUo>FLiIoUo>FLiOoU_NgliIoUo>FLiOoUW>GliMkeW>GliIoUo>@9_N`0H
OcUWnGlbKg]o>FLiOoUW<WliIoUo>FmkIcUonFLiOoUW>GoiOcUWnGliIcUW
nGli0Vmk00Eo>FOiOc9_Ngli009_N`0:OoUW>FmkOcUWnGliIcUonFLiOcT2
Kg/057liIcUonFLiOoUo>FmkIoUW>GliIoUo>FOiKg]onFLiOoUW>GoiIc82
Kg/00goiIcUo>@02Kg/047liIcUo>FOiKg]o>FLiOoUW>GoiKg]o>FOiOcU_
Ngli0Fmk000016OiOcUWnGli0Vmk00=o>FOiOcT00Vmk00=o>FOiOcT00Vmk
00=o>FOiOcT00Vmk00=o>FOiOcT00Vmk01Mo>FmkOcUo>FOiOcUWnGliIoUo
>FmkOcUWnGliKg]WnGliKg]o>FOiOcU_Ngli009_N`0>OcU_NfmkOcUWnGli
IoUo>FLiOoU_NgliKg]Wn@9o>@04IoUo>FLiIoT2OcT02VOiOcU_NgliIoUo
>FOiOcUWnGli0Vmk00Io>FOiIcUo>FOiOcT5Kg/08gliIoU_NgliIcUonFLi
OcUWnGliIcUo>FOiOcUW>GoiIcUo>FOiOcUW>GoiIcUo>FmkIoUo>FmkOcU_
NgliIcUo>FOiOcT00Vmk00Ao>FLiIoUo>@9_N`0HOcUW>FmkKg]o>FLiOcUW
nFmkOcUWnFmkOcUWnGliIoUo>FLiOoUW>GliKg]WnGli0fmk00Ao>FOiOcUo
>@9_N`08OoUW>FmkKg]onFmkIcUon@9_N`0:OcUW>GoiIcUo>FLiOoUW>FOi
OcT2Kg/02GlbIoUo>FOiOcU_NgliKg]o<P02Kg/05GliKg]WnGliKg]o>FOi
IcUo>FmkIoUo>FOiOcU_NgliIoU_NfLiOcUWn@02OcT02fOiOcUW>GliIoUo
>FOiOcUW>GoiIcT00Wli00IWnGliKg]o<VOiOcT3Kg/00fOiOcU_N`02Kg/0
0gliIoUo>@02Kg/01gliIcUonFLiIoUo>FOi009o>@0>IoUo>FLiOoUW>Fmk
IoUo>FmkOcUW>GoiKg]o>@9_N`0EOcU_NgoiIcUonFLiOcUWnGliKg]W>GNm
Oc9_NgliIoUo>FLiOcUW>Gli009_N`04OcU_NfmkOcT2Kg/027liIoUo>FOi
Kg]o>FOiOcT2Kg/02WoiIcUo>FLiOoUW>GliIoUo>Fmk0Gli00001WliKg]_
NgliIoUo>@A_N`0=OcUWnGliKg]W>GoiIcUo>FOiKg]o>FOiOcT00Vmk02Qo
>FOiOcUWnFLiOcUWnGliIcUo>FOiOcU_NgliMkeW<WliIoUo>FOiOcU_Ngli
IoU_NgliIoU_NgliIoUo>FLiOcUWnGliKg]o>FLiIoUo>@9_N`03IcUo>FOi
009o>@0:IoU_NfLiOcUWnGliIcUo>FOiOcT2Kg/03GlbKg]_NgliIoUo>FOi
OcU_NgliKg]o>FOi009o>@0BIcUonFLiOcUWnGliIcUonFLiOcUWnGliKg]o
>FOiOcUW>Goi0Vmk00=o>FOiOcT00fmk00Eo>FOiOcUWnGli009_N`0@OcUW
nGliKg]o>FOiOcUW>GoiKg]o>FOiOcUWnFmkOcT2Kg/02GliKg]_NfLiOcUW
nGliIcUon@02Kg/00gliIcUWn@02OcT05VOiIcUo>FOiIcUonFLiOcU_Ngli
Kg]o>FOiOcUW>GliIcUonFLiOcUWnGli0Vmk00=o>FOiOcT00Vmk00Io>FOi
OcU_NgliIoT3Kg/09gliIoU_NgliKg]o>FOiOcU_NgliIoUo>FmkOcUWnGli
IoUo>FLiOoUW>FmkOcUWnGliKg]o>FOiOcUW>GliIoUo>FLiOoUW>FOiOcUW
>@02Kg/04WliIoU_NgliKg]o>FOiOcU_NgliIoUW>GliIoUo>FLiOoUW>@9o
>@07IcUo>FOiIcUo>FOiOcT00Vmk0Wli00MWnGliIcUonFLiOcUWn@02Kg/0
5gliIoUW>GliIcUonFLiMkeW>GliIoUo<VmkOcUWnGliIcUo>FOiOcU_NfOb
OcT00Vmk019o>FOiKg]o>FOiOcUWnGliIcUonFLiOcUWnGliIcUo>FOiOcT3
Kg/00gliIoUo>@01IoT00006Kg]o>FmkIcUo>FOi0Wli00]WnGliIoUo>FLi
OoUo>FLiOoUW>Gli009_N`03OcUWnGli009_N`0>OcUWnGliIoUo>GNmKg]o
>FmkOcUWnFmkIoUo>@9_N`07OcU_NfmkIc9onFLiOcT00Vmk00Io>FOiKg]o
>FOiOcT3Kg/00gliIoUo>@02Kg/01GlbIoUo>FOiOcT00Vmk00ao>FmkOoUW
>GliIoUo>FOiOcU_NglbIoT2Kg/047liIoUo>FLiOcUWnGliIoUo>FOiOcUW
>FOiOcU_Ngli0Vmk00Eo>FOiOcUWnGli009_N`0:OcUWnGliIoUo>FLiOcUW
nFLiOcT2Kg/06glbKg]WnGliKg]o>FOiOcUW>FOiOcUWnGlbKg]o>FOiOcUW
>GoiIcUo>FmkOcUWnFmkOcUWn@02OcT03VOiOcU_NgliIoUo>FLiOcUWnGli
Kg]o>FmkIoT2OcT05FOiOcU_NfmkOcUWnGliIoUo>FLiOcUWnGliIoUo>FLi
OoU_NglbIoUo>@02Kg/00glbIoUo>@02Kg/04gliIcUonFLbOcU_NgliIoU_
NgliIoUW>GliIoUo>FLiOoUW>Gli00=_N`04OcUW>GliIoT2OcT00fOiOcU_
N`02Kg/06VObOcU_NfOiOcU_NgliIoUo>FLiOoUW>GliOoUW>GoiIcUo>Fmk
IoUo>FLiOcUWnGliIoT2OcT09fmkOcUWnGliIcUonFLiIoUo>FmkOcUonFLi
OcUWnGliKg]WnGliKg]W>GoiIcUonFLiOcUW>GoiIcUo>GoiIcUo>FLiOoUW
>GliIoUo>@02Kg/026OiOcUWnGliIoUo>FOiOcT2Kg/05GliIoUo>FLiOcUW
nGliIcUo>FOiOcUW>GoiIcUo>FOiOcUW>GliIoUo>@02Kg/00fLiOcUWn@01
OcT00005OcUWnGliIoUo>@02Kg/07VOiOcUW>GliIoUo>FmkIcUonFLiOcU_
NfOiOcU_NgliKg]W>GoiIcUo>FmkOcUWnFLiOcUWnGliIoUW>@9o>@9_N`04
OcU_NfOiOcT2Kg/01GNmIcU_NgoiIcT00Wli0Vmk00Qo>FOiOcUo>FOiOcUW
nGli0Vmk00io>FmkOcUW>FOiOcUW>GoiIcUo>FOiOcUW>Gli16mk0Wli031W
nGliKg]o>FOiOcU_NfLiOoUW>GliIoUo>FOiOcU_NfOiOcUWnGliIcUo>FOi
Kg]o>FOiOcUW>GliKg]o>FOiOcU_NgliIoUo>FmkIoUo>FLiOoUW>GliIoUo
>FmkOcT4Kg/00gliIoUo>@02Kg/00gliIoU_N`02OcT05FOiOcUW>FOiOcUW
>GoiIcUo>FmkOcUWnGliIoUo>FOiKg]o>FmkIoUo>@02Kg/027liIoUo>FOi
OcUW<VOiOcT2Kg/00gliIoUo>@04Kg/00gliIoUo>@02Kg/01GNmIcUo>FOi
OcT00fmk00Ao>FOiOcUo>@9_N`08OcUWnGliIcUonFLiOcUWn@9_N`0=OcUW
nGliIoUo>FLiIoUo<VmkIoUo>FmkOcT00Vmk01=o>FLiOoUW>GliIoUo>Fmk
OcUWnFLiOoUW>GliKg]WnGliIcUon@03Kg/00gliKg]Wn@02Kg/0;WliIoUo
>FmkIoUo>FmkOcUWnFLiOoUW>GliIoU_NgliIcU_NgoiIcUo>FmkOcUW>Goi
Kg]o>FOiIcUonFLiOoUW>GliIoUo>FmkMke_NgliKg]o>FOiOcUW>Gli0Vmk
01Uo>FOiOcU_NgliIoUo>FOiOcUWnGliIcUonFLiOcUWnGliIoUo>FOiOcUW
nGliIcUon@02Kg/1OcT0000>Kg]o>FOiOcUWnGliIcUo>FmkOoUW>GliIoUo
>@9_N`0>OcUWnGliOcUWnFmkOcUWnGliKg]onFLiOoUW>@9o>@0:IoUo>FLi
OcUonFLiKg]o>FmkIoT2OcT0>VOiOcUW>GliIoUo>FLiOoUW>FOiOcU_NfLi
OcUWnFLiOcU_NgliIoUo>FmkIoUo>FOiOcUW>GoiIcU_NgliIoUo>FOiOcUW
nGliKg]o>FmkIoUo>FLiMkeW>GoiIcUo>FOiOcUW>GliIoUo>FLiOcUWnGli
0Vmk00=o<VmkIoT00Wli00mW>FOiOcUWnGliIoUo>FmkOcUWnGliIoUo>Fmk
OcT00Vmk00io>FLiOoUW>GliIoUo>FOiOcU_NgliIoU_Ngli0Vmk00Io>FOi
OcUW>FOiOcT2Kg/04GoiIcUo>FmkIcUonFmkIcUonFLiMkeo>FLiOcUWnFLi
OcT00Vmk00=o>FObOcT00Vmk00Io>FmkKg]o>FOiOcT2Kg/027liIoUo>Fmk
OcU_NfOiOcT2Kg/03WliIcUonFLiOcUWnGliKg]o>FOiOcUWnFmkOcT2Kg/0
3glbIoUo>FLiOoU_NgliIcUonFLiOcUWnGliIoUo>@02Kg/027liIcUWnGli
Kg]o>FOiOcT2Kg/01gliIoUo>FOiOcUWnGli009_N`0BOcUWnGliOcUW>Goi
IcUo>GoiIcUg_GlbKg]o>FOiKg]o>FOi0Wli01M_NgoiIcUo>FmkIcUonFLi
OcUWnGliIoUo>FLiOoUW>GliIoUo>FLiOoUW>Gli009_N`0:OcUW>GoiIcUo
>FOiOcUW<WoiIcT2Kg/067liIoUo>FOiOcU_NfOiOcUW>GoiIcUo>FmkOcUW
>GNmKg]o>FLiOoUW>GliKg]o>@=_N`06Oc9WnGliIcUo>FOi0Fmk00003Goi
IcUo>FLiOcU_NgoiIcUonFLiOcUWnGli009_N`0=OcUWnGliOcUWnFLiOcUW
nGliIoUo>FLiOcT00Vmk01Eo>FOiKg]_NgoiIcU_NfOiOcUWnFmkOcUW>FOi
OcU_NgliIoUo>FLiOoT00Vmk019o>FmkOcUWnGliKg]o>FOiOcUWnFLiOcUW
nGliKg]o>FOiOcT2Kg/05WliIoUo>FmkOcUW>GliIoUo>FOiKg]o>FLiOoUW
<WoiIcUo>FOiOcUW>Goi0fmk00=o>FOiOc800Vmk029o>FmkIoUo>FmkIcUo
nGliIcUo>FOiOcUW>GNmIcUo>FOiOcUW>GoiIcU_NgliIoUo>FLiOoUW>Gli
IoUo>FLiOcUWn@9o>@0DIcUWnGliIoUo>FOiOcU_NgliIoUo>FLiOcUWnGli
IoUo>FLiOoUW>@9o>@08IoUo>FOiOcU_NgliIoUo<PA_N`0LOcUWlVmkOcUW
nGliKg]WlWliIcUo>FOiOcUWnFmkOcU_NfLiOcUWnGliIcUonFLiOcUWnGli
IoT2Kg/01GliIcUo>FOiOcT00fmk00]onFLiOcUW>GoiIcUo>FOiOcU_Ngli
009_N`0AOcUWnGliOcUWnGliIoUo>FOiKg]o>FmkMkeW>GliIcUo>@02Kg/0
4gliIoUo>FmkIcUonFLiOcU_NfLiOoUW<VmkOcUWnFLiOcU_Ngli009_N`03
Ic9_Ngli009_N`0JOoUW>GoiIcUo>FmkOcUW>GoiIcUo>FOiOcUWnGliIcUo
>FmkIoUo>FLiOoUW>GliIoUo>@=_N`07OcUWnGliKg]o>FOiOcT00Vmk01Ao
>FLiOoUW>GliIoUo>FLiOoUW>GliIoUo>FmkOcUWnGliKg]WnGli0Vmk00Ao
>FOiOcUWn@9o>@0000M_NgoiIcUonFLiOcUW>@02Kg/09GliIoUo>FLiOoUW
>FOiOcUWnFLiOcUonFLiOcUW>GliIoUo>GNmIc9onFLiOcU_NgliIcUonFLi
OcUW>GliIoUo>FmkOcU_NfOi009o>@0>IoUo>FLiOcUWnFmkOcUWnGliIoUo
>FOiOcUW>@9o>@08IoUo>FLiMke_NglbIoUo>@9_N`0:OcUWnFmkKg]onFLi
OcUW>GliIoT2Kg/02gliKg]_NgliIoUo>FOiOcUW>GoiOcT00Vmk00Io>FOi
OcU_NfOiOcT2Kg/0=7liIoUW>GNmOcUWnGliIcUonFLiOoUW>GliKg]o>FLi
OoU_NfOiOcUWnGliIcUonFLiOcU_NfOiOcU_NfOiOcU_NgliIoUo>FLiOcUW
nGliIcUo>FOiOcU_NglbIoUo>FOiOcUW>Goi0VLi00]o>FmkOcUWnGliKg]o
>FOiOcU_Ngli009_N`06OcU_NfmkOcUWnGli0Vmk015onFLiOcUW>GliIoUo
>FLiOoU_NgliIoUo>FLiOoUW>Gli009_N`0NOc9_NfLiOoUW>GliIoUo>Fmk
OcUW>GoiIcUonFLiOoUW>GliIcUonFLiOcUWnFmkOcUWnFmkOcU_NfLi0Wli
00]_NfOiOcUW>GoiIcUonFLiOcUWnGli009_N`06Oc9WnFmkOcUWnGli0Vmk
00io>FmkKg]o>GoiIcUo>FOiOcUWnGliKg]WnGlb0Vmk00Eo>FLiOoUW>Goi
009_N`03OcUWnGli009_N`04OcUWnGliIoT2OcT086OiOcU_NgoiIcUo>FOi
OcU_NgliIoUo>FLiOoUW>GliKg]o<VOiIcUonFLiOcUWnGliIoUo>FLiOoUW
>GliIoT2Kg/01WliIoUo>GliIoUo>@9_N`04OcUWnGliIcT1IoT0000iOcUW
>GoiIcUo>FOiOcUWnGliIoUo>FLiOoUW>GliKg]o>FmkOcU_NfLiOoUW>Goi
Kg]W>GoiIc9_NgliKg]WnGliIcUonFLiOcUWnGliKg]o>FOiOcUWnFmkOcUW
>FOiOcUWnGliIoUo>FLiOoUW>Gli009_N`0@OcU_NgoiIcUWnGliKg]onFLb
OcU_NgliIoU_NgliIoT2OcT05WNmIcUo>FOiOcUWnGliKg]o>FOiKg]o>FOi
OcUW>GliKg]o>FmkIcUWnGli16mk0Wli00]_NgliIoUo>FmkOc9WnGliIcUo
nFLi009o>@05IoU_NgliIoUo>@02Kg/01gliIcUo>FOiOcU_Ngli009_N`0;
OcUWnFmkOcUW>GoiIcUo>FmkOcUWn@02OcT00fOiOcU_N`05Kg/00gliKg]o
>@02Kg/01goiIcUonFLiOcUWnGli00=_N`09OcUWnFLiOoUW>FmkOoUW>Gli
009_N`0?OoUW>GliIcUonFmkOcUW>GoiIcUonFLiOcUWnGli009_N`0KOcUW
nGliMkeW>GoiIcUonFLiOcUWnGliIcUonFLiOoUW>GliKg]o>FLiOoUW>Fmk
OoUW>Gli009_N`0COcU_NfLiOoU_NfOiKg]o>FOiOcUW>GoiIcUo>FOiOcU_
NfOiOcT00Vmk011o>FOiOc9g_FmkOcUWnFmkOcUWnFLiOcUWnGliKg]o>@9_
N`0?OcU_NfmkOcUWnGliKg]g_FLiOcUg_FLiOcUWnGlb009_N`0<OcUWnGli
Kg]W>GliIoUo>FLiOcUWnGli0Vmk00iWnGliIcUonFLiOcU_NfOiKg]o>Fmk
OcUWnGli0Vmk00Uo>FLiOoUW>GliIoUo>FmkOcT00Vmk00Yo>FOiIcUo>FOi
Oc9_NgliKg]Wn@5o>@0001AWnGliKg]o>FOiOcU_NgliIoUo>FLiOoUW>Goi
IcUo>FOiOcUWnGli0Vmk0Wli00=WnGliKg/00fmk029o>FLiOoUW>FmkOcUW
nGliIoUo>FOiOcUW>GliIoUo>FmkOcUW>GliIoUo>FOiOcUW>GoiIcUo>FOi
Kg]o>FLiOoUW>@9_N`0;OcU_NfOiOcUW>GliIoUo>FLiIoU_N`02OcT026Oi
OcU_NgliIoUo>FLiOcT2Kg/05GliIoUo>FOiOcUWnGliKg]o>FOiOcU_Ngli
IoU_NfLiOoUW>GliIoUo>@02Kg/037liKg]_NgliIoUW>GliKg]WnGliIoUo
>@9_N`08OoUW>GliIoUo>FOiOcUWn@9o>@0/IoU_NgliIcUonFLiIoUo>FLi
Kg]WnGliIoUo>FmkOoUW>GliKg]WnGliIoUo>FLiOcUWnGliIoUo>FLiIoUo
>FmkOcUWnGliKg]o>FOiOcUW>GoiIcUo>@9_N`0LOcUWnGliIcUonFLiOoUW
>GliIcUonFLiOcUWnGliKg]WnGliKg]W<WoiIcUo>FmkOoUW>GliIoT2Kg/0
1WliIcUonFLiOcUWn@9o>@0KIoUo>FLiOoUW>GliIoUo>FLiOoUW>GliIcUo
nFLiOcUWnGliIcUo>FOiOcU_NfLbOcUWnGli009_N`06OcU_NfLbOoUW>Gli
0Vmk00]o>FOiOcUW>FOiOcUWnGliIoU_Ngli009_N`09Oc9WnGliIcUonFLi
OcUWnGli009_N`03OcUWnGli009_N`06OcUWnGliIcUWnGli0Vmk00IW<WNm
OcUW>GliIoT2OcT05fOiOcUo>FmkIoUo>FLiOcUWnGliKg]WnGliKg]onFLi
OcUWnGliKg]W<WoiIcT00Wli00EWnGliKg]WnFmk009o>@5Wn@0000=o>FLi
OoT00Vmk00iW>GoiIcUo>FLiOoUW>GliKg]o>FOiOcU_Ngli0Vmk05Qo>FOi
Kg]W>GliIoUo>FmkOcUWnGliIcUonGliIoUo>FLiOcUWnGlbKg]o>FOiOc9_
NgliIoUo>FOiOcUW>GliIoUo>FLiOoUW>FmkOcUW>GoiIcUo>FmkOcUWnFmk
OcUW>GoiKg]o>FLiOoU_NgliIcUWnGliIcUonFLiOcUWnGliIoU_NgliIoUo
<VmkOcUWnGliIc9onFLiOcUWnGliIoUo>FLiOoUW>GliIoUo>@9_N`0GOcUW
nFmkOcUWnGliKg]o>FOiOcUW>GliKg]WnGliIcUo>FOiOcUW>GliIoUo>@02
Kg/016LiOcUWnGli0Vmk01Mo>FmkOcUWnGliIcUo>FOiOcUW>GliIoU_Ngli
IcUo>FOiOcUWnGliIcUo>FOi009o>@04IoUo>FOiOc83Kg/01GliIcUonFLi
OcT00Vmk00Qo>FOiOcUWnGliIcUWnGli0Vmk00UonFLiOcUWnGliIcUonFLi
OcT00Vmk02Mo>FmkIoUo<VmkOcUWnGliKg]o>FLiOoUW>GliIoUo>FOiKg]o
>FLiOoUW>GliIoUo>FLiOoUW>GliKg]onFLiOcUWnGliIoUo>FOiOcT00Vmk
00=o>FOiOcT00Vmk00Ao>FObKg]o>@9_N`0:OcUWnGlbMke_NgliIoUo>Fmk
OcT2Kg/017lbIoU_Ngli0Vmk00Io>FOiOcU_NfOiOcT2Kg/07gliIoUo>FLi
Kg]o>FObOcUWnGliKg]o>FOiOcU_NgliIoUo>FOiOcUW>FOiKg]o>FOiKg]o
>FOiOcUWnGli009_N`09OcUWnGliIcUo>FOiOcUWnGli009_N`03Mkeo>FOi
00=_N`9o>@5W>@5Wn@5o>@0002I_NgliIcUo>FOiOcUW>GoiIcUonFLiOoUW
>GliIoUW>GliIoUW>GliOoUW>GliIoUo>FOiOcUW>GoiIcUo>FOiOcUW>Fmk
OcUWnGli0fmk00=o>FOiOcT00Vmk00aWnGliKg]o>FOiOcU_NgliIoUo>FLi
OoT2Kg/03GliIcUonFLiOoUW>GliIoU_NgliIcUWnGli009_N`03Oc9WnGli
00=_N`09Ic9onFLiOcU_NgliKg]WnGli009_N`03IcUo>GNm009_N`0=OcUW
nGliIcUo>FOiOcUW>GoiIcUo>FOiOcT00Vmk00]o<VmkIoUo>FLiOoUW>Gli
IoUo>FOi009o>@07IoUo>FOiOcU_NfOiOcT00Vmk01Uo<VOiOcU_NgliIoUo
>GNmIcUonFLiOcUWnGliKg]o>FOiOcU_NgliOoUW>GoiIcUo>@02Kg/027li
IoUo>FmkIcUonFLiOcT3Kg/00gliIoUo>@02Kg/04gliIoUo>FOiOcU_Ngli
IcUonFmkOcU_NgliIcUo>FOiOcU_Ngli009_N`03OcUWnGli009_N`0BOcU_
NfmkKg]WnGliKg]o>FOiOcU_NgliIoUo>FLiOcUWnGli0Vmk01=o>FOiOcUW
>GoiIcUonFLiOcUW>GliIoUo>FmkOcU_NgliIoUo>@02Kg/00gliIoUo>@02
Kg/04GliKg]WnGliIoU_NgliKg]W<WliIoUo>FmkIoUo>FmkOcT00Vmk00Mo
<VOiKg]o>FOiOcUW>@02OcT02FOiOcUWnGliKg]W>GoiKg]o>@02Kg/037li
IoUo>FmkOcUWnGliKg]o>FOiOcUWn@9o>@9_N`08OcU_NfmkOcUW>GliIoUo
>@9_N`0COc9WnGliKg]o>FLiOcUWnGliKg]W<VmkOcU_NgliIoUW>GoiOcT0
0Vmk00002GoiIcUo>FOiOcUW>GoiIcUo>@02Kg/06WliKg]_NfmkOcUWnGli
OoU_NfLiOcUWnGliIcUo>FmkOoUW>GliIoUo>FmkIoUo>FOiOcT3Kg/00gli
IoUo>@03Kg/2OcT026OiKg]o>FmkMkeW>GliIoT2OcT026OiOcUWnGliIcUo
nFLiOcT2Kg/01WliIoUo>GliIoUo>@9_N`05OcUWnGliIoUo>@02Kg/01Wli
IoUo>FmkIoUo>@=_N`0DOoU_NfLbKg]o>FOiOcUW>GliIoUo>FLiOoUW>Gli
IoUo>FOiKg]o>@9_N`0>OcUW>GoiIcUo>FOiOcU_NgliIcUWnGliIcUo>@9_
N`03OcUWnGli009_N`0BOcU_NgliIoU_NgliIcUonFLiOcUWnGliKg]o>FOi
OcUW>Goi0VLi00=onFLiOcT00Vmk00Yo>FOiOcU_NfLiOoUW>GliIoU_N`9o
>@0?IoUo>FOiKg]o>FOiOcUWnGliKg]W>FmkOoUW>Gli009_N`0CIoUo>FOi
OcUWnGliIoU_NgliIoUo>FmkIoUo>FOiKg]o>FmkOcT00Vmk00AWnGliIoUo
>@9_N`0;OcUWnFmkOcUWnFmkOcU_NgliIoUo>@02Kg/02GliKg]WnGliIoUo
>FmkOcUWn@02Kg/017liKg]WnGli0fmk00IWnGliKg]WnGliIcT2OcT03FOi
Kg]o>FOiKg]o>FOiOcUW>GliIoU_Ngli009_N`0=OcU_NfmkOcUWnGliIoU_
NfLiOcU_NgliIoT00Wli00eWnFmkOcU_NgliIoUo>FOiOcUW>GoiIcUo>@02
Kg/03WliIoU_NgliIcUWnGliIoUo>FOiOcUWnFmkOcT2Kg/04WliIoU_Ngli
IoUo>FOiOcU_NgliIoUo>FOiOcU_NgliIoU_N`5o>@00011_NgliIoUo>FOi
OcUW>GoiIcUo>FOiIcUonGliIcUon@9W>@07OcUWnGliKg]o>FOiOcT00fmk
00Eo>FOiOcU_Nglb009_N`0POcUWnGliIcUonFLiOcUWnGliIcUonFLiKg]o
>FmkIoUo>FLiOoUW>GliIoUW>GliKg]o>FOiOcU_NgliIoUo>@9_N`06OcUW
nFmkOcUWlWli0Vmk00Eo>FLiOcUWnGli009_N`0:OcUWnGliOcUW>GoiIcUo
>FLiOoT3Kg/04gliIoUo>FOiOcUWnGliKg]o>FOiOcUW>GliKg]WnGliIoUo
>FOi009o>@0=IoUo>FmkOcUWnGliKg]WnGliIoUo>FmkOcT00Vmk00eo>FOi
IcUonFLiOcUW>GoiIcU_NgliIoUo>@02Kg/046OiOcU_NfmkOcUonFLiMkeo
>FOiOcUWnGliIcUWnGli0Vmk029o>FmkOcU_NfOiOcUW>GliKg]o>FOiOcU_
NgliKg]o>GoiIcU_NgliIoUo>FmkOcU_NgliKg]o>FmkOcU_NfOiOcU_N`9o
>@06Kg]o>FmkIoUo>Fmk0Wli00E_NgliIcUWnGli009_N`0=OcU_NfmkOcU_
NfOiOcU_NgliIoUo>FmkIcT00Wli00=_NgliKg/00Vmk0Wli00EWnFmkOcUo
>FOi009o>@04Kg]o>FmkOcT2Kg/017oiIcUg_Gli0Vmk00Io>FmkKg]o>Fmk
IoT2OcT03FmkIoUo>FOiOcU_NgliIoUo>FLiOcUWnGli009_N`08IoUo>Fmk
IcUo>FmkIoUo>@9_N`08IcUo>FmkKg]W>GoiIcUo>@9_N`03OcU_NfOi009o
>@09IcUo>FmkOcU_NgliKg]WnGli009_N`0AOcUW>GoiIcU_NgliIoU_Ngli
IcUWnGliIcUonFLiOcU_N`01IoT0000FOcUWnGliKg]o>FLiOoUW>GliIoUo
>FmkOcUW>GoiIcUo>GoiIcUo>FOiOcT2Kg/01gliIoUo>FLbOoUW>Gli009_
N`06IcUonFLiOcUWnGli0fmk00eo>FLiOoUW>GoiIcUo>FOiOcUW>GoiIcUo
>@02Kg/01GliIoUo>FOiOcT00Vmk00QWnGliKg]_NgliIoUW>Gli16mk00Eo
>FOiOcUWnGli009_N`03OcUWnGli009W>@05OoUW>GliIoUo>@02Kg/2OcT0
16OiOcU_Ngli0Vmk011o>FmkIoUo>FmkOcU_NfOiOcU_NgliIoUo>FLiIoUo
>@9_N`03IoUo>FOi009o>@0CKg]o>FmkKg]WnFLiOcUWnGliKg]o>FOiKg]o
nFLiKg]o>FOiOcT00Vmk015onGliMkeonGliOoU_NgNmOcUonFmkOoUo>GNm
OoUo>Goi009g_@9on@0mKg]onGliMkeonGNmOcUonFmkMkeo>GoiKg]onFmk
OoUo>GoiKg]onGliKg]onFmkOoU_NgoiKg]g_GliOoUo>GoiKg]onFmkOoUo
>GoiKg]onFmkOoU_NgoiOcUonGNmOcU_NgoiOom_NgoiOcUonFmkMkeo>Goi
Mkd00Woi00=_NgoiKg/00Woi00Qo>GoiKg]g_GliOoU_Ngoi0Vmk00eonFmk
OoU_NgoiMkeo>GNmOcU_NgoiOcm_N`02OoT0?FmkOoUo>GoiKg]g_GliOomo
>FmkOoUg_GliKg]onGNmOcUonFmkOoUo>GoiMkeonFmkOoUo?fmkOoUo>Goi
MkeonGNmOoUo>GNmOoUo>GoiKg]onGliMke_NgoiMkeonFmkOoU_NgoiOcUo
nGNmOcUW>GoiIcU_Nglb009_N`0:OcUWnGliOcUW>GoiIcUo>FmkIoT1OcT0
000JKg]o>FOiKg]o>GNmKg]o>FOiOcUW>GoiIcU_NgliIoUW>GliOoUW>Gli
IoUo>FLiIoUo>@=_N`0;OcUWnGliKg]o>FmkOoUW>GliIoUo>@02Kg/00fOi
OcU_N`02OcT0:6OiIcUo>FLiOoUW>GliIoU_NgliIoUo>FLiOcUWnGliIcUo
>FOiOcUWnGliKg]o>FOiOcU_NglbKg]WnGliIcUo>FOiOcU_NgoiIcU_Ngoi
0Vmk011o>FOiOcUWnGliKg]W>FOiOcUW>GoiIcUo>FmkIoUo>@9_N`06OcUW
nGliOcU_NfOi0Wli00A_NgoiIcUWn@9o>@07IcU_NgliIoUW>GoiKg/00Wli
011_NgoiIcUo>FOiOcUW>GliIcUo>FOiOcUWnGliIcUon@9BU006F]IBU5:D
F]IBU6Lb0e:D00QJeU:DF]IBU5[FDYAJeVIB0U:D00MJeU:DF]IBU6LbDYAJ
eP02DY@00fLbF]IBU002F]H045:DF]IBU5[FDYAJeU:DIc9JeU:DF]IBU5[F
DYAW<U[F0U:D00aJeU:DF]IBU5[FDYAJeU:DF]IBU5[FDY@3F]H025:DF]IW
<U[FDYAVDU[FDY@2F]H01VLbDYABU5[FIU9BU09JeP09DYAJeU:DF]IBU5[F
Ic9JeU:D009JeP05IU9W<U[FF]IVDP02F]H02e:DIc9JeU:DIc9JeU:DIc9J
eU:DIU800e[F00=BU6LbF]H00U:D00IW<U[FDYAW<U[FDY@2F]H03FLbDYAJ
eU:DF]IVDU:DF]IW<U:DIc9JeU:D009JeP03IU9BU5[F009JeP05Ic9BU5[F
F]IBU002F]H026LbDYAVFFLbDYAJeU:DF]H3DY@025[FOoU_NgliIoUo>Fmk
OcT2Kg/02GliIoU_NgliKg]o>FOiOcU_N`01IcT0000;OcUWnGliOcUWnFLb
OcUWnGliIcUon@02Kg/0:GliIoUo>GliIoUW>GoiIcUo>FLiOoUo>FOiOcU_
NgliIoUo>FOiOcUWnGNmIcUo>FOiOcUWnGliKg]o>FOiOcUW>FOiOcUonFLi
OoU_NgliIoT00Wli03eWnGliIcUo>FOiOcUWnGliIoUo>FLiOcUWnGliIoUo
<VmkOcU_NfOiOcUW>GoiKg]o>FOiOcUW>GliIoUo>FLiOcUWnGliIcUo>FOi
OcUWnGliIcUonFLiOcUWnGliKg]o>FLiOcUWnGliKg]WnFLiOcUW>FmkMkeW
>@02OcT076mkIoUo>FOiOcUW>GoiIcUo>FLiIoUo>FLiOoUW>GliIoUo>Fmk
OcUWnGliIoUo>FLiOoU_NdYB0c6<00<icS6<<H`00c6<00DicS6<<H`aS3W>
00<aS003>LhaS36<008aS003>LhaS36<00<aS003>LhaS36<00LaS003>Lha
S36<00@aS003>LhaS36<00<aS003>LhaS36<00/aS003:DXicU:D00=:DP9B
U003BU9BU4YB009:DP03DY@aS36<018aS003:DXicS6<03HaS0E:DP05DY@a
S36<@Q0icP02@Q004@aSBU9onFmkOcUWnGliIoU_NgliIoUW>GliIoUo>FOi
OcT00Vmk0Goi00001FmkOcUWnFmkOcT00Vmk011o>FOiOcUW>GliIoU_Ngli
IoU_NgliKg]W>GoiIcUon@9W>@0GOcUWnGliIoUo>FLiOcUWnGliIcUo>FOi
OcUW>GliIoUo>FLiOcUWnGliIcUWn@02OcT01FLiOcUWnGliIcT00fmk00eo
>FOiOcUW>GliIoUo>FOiOcUW>GliIoUo>@02Kg/0CVOiOcU_NfmkOcUW>Goi
IcUo>FOiOcU_NglbIoUo>FmkOcUWnGliKg]o>FOiOcU_NgNmKg]o>FOiOcUW
nGliIcUonFLiOcUWnGliKg]o>FOiOcU_NfLiOoUW>FmkOcUW>GoiIcUWnGli
Kg]o>FOiOcUW>FOiOcUW>GoiIcUo>FOiOcUWnGliKg]o>FLiOoU_NgliF]I:
DWNmKg]W>@9_N`04IcU_NfmkIcT2Kg/016LiOcU_Nfmk0VLi16mk00=W>Fmk
IcT00fmk00QW>FmkKg]W>FmkOcU_NfLi0Vmk00Ao>FmkKg]W>@9_N`03IcUo
>Fmk009_N`03IcU_NfLi00I_N`05IcU_NfmkKg]W>@02Kg/00goo5:D0000:
00000b48OomW>@07IcT015[FIcUW>E[F26Li00=JeVLiIcT00fLi00=JeVLi
IcT03fLi00=JeVLiIcT03VLi00=JeVLiIcT016Li00QJeVLiIcUW>E[FIcU_
NgNm1@0000@48GooF]HicP9:DP04DY@DYE:DOcT2Kg/02gliIoUo>FLiOoU_
NgliKg]o>FOiOcT00Vmk0Glb0Fmk000017liIoUW>Gli0Vmk00Io>FOiOcU_
NgliIoT2OcT03VLiKg]o>FmkOcUWnGliIoUo>FLiOoU_NgliIcT2Kg/047li
IoUo>FLiOcUWnGliKg]o>FOiOcUW>GoiKg]o>FOi0Wli01YW>FOiOcUWnFmk
OcUWnGliKg]o>FOiOcU_NgliIoUo>FmkOcUWnGliIoUo>FLiOoU_Ngli0Vmk
00Uo>FOiOcUW>GoiIcUo>FOiOcT00Vmk02=o>FOiKg]o>FLiOoUW>GliKg]o
nFLbOcUWnGliIoUW>GliIoUo>FOiKg]o>FLiOcUWnGliIoUo>FOiOcUWnGli
IcUonFmk009o>@05IoUo>FOiOcUWn@02OcT00fOiOcU_N`02Kg/00gliIoUo
>@02Kg/02fLiOoU_NgliKg]JeS6<@Q1BU4YBDY@00TYB00=BU6IBBU800dYB
00MBU4YBBU9:DU:DBU9VDP04BU800e:DBU9VDP04BU801E:DBU9:DTYBDY@0
1DYB00EBU4YBBU9:DU:D00E:DP04DYA:DTYBIU83BU800e:DBU9VDP02BU80
1E:D@Q1:DWooIcT00goo00T006mkMkeW>E[FOomBU0`0Mkd025[F00AW>E[F
F]IW>@MJeP08BcUVFFLbF]IW>D/bF]IW>@=JeP04IcUBU5[FIcT4F]H00e:D
F]IW>@0AF]H016LiBUUJeVLi1U[F00EW>E[FF]IJeVLi00=JeP07MkeW>Goo
Oom_N`00Kg/00U[F00PaS48@IcT<He:DMkeWnGli0Vmk00YW>GoiIcUo>FOi
OcU_NfLiIoUo>@=_N`0000mo>FmkOcUWnGliKg]WnGliIcUg_FmkOcUWnFLi
OoT00Vmk00ao>FOiOcU_NgliIcUonFLiMkeW>GoiOcT2Kg/037liIoUo>FOi
OcUW>GNmIoUo>FLiOoUW>@9_N`0HOcUWnFmkOcUW>GoiIcUo>FOiOcUWnGli
IoUo>FLiOoUW>GliIcUg_FmkOcU_Ngli0Vmk00EW<WoiIcUo>FOi009o>@08
IoUo>FLiOoUW>GliIoUo>@9_N`09OcUWnGliIoUW>GoiIcUo>GNm009_N`0G
OcUW>GliOcUWnGliKg]o<VOiKg]o>FOiOcUW>GliIoUo>FLiOcUWnGliKg]W
<P02Kg/02GliIcUo>FmkOcUWnFmkOcUWn@02OcT03fOiIcUo>FmkOoUW>Gli
IcUonFLiOoUBU3W>BU9JeP0kDY@04U[FDYA:DU:DF]Ig_@00125oo`00F]IW
>E:DBU9g_C6<36=g_@MJeP04IUU;<U[FIc8:F]H014/iF]IJeVII25[F00=B
U5[FF]H015[F00=BU5[FF]H01e[F00=BU5[FF]H01U[F00=W<VIIBc801U[F
00=VDT/iF]H015[F021BU6OiF]H005:DKg/007Nm@Q1JeVLi<HaBU1BUIU9o
nGliIoUo>FmkOcUW>GoiIcUo>FOiOcU_NgliIoUo>Fmk0Gli000016OiOcUW
nGli0Vmk02Mo>FLiOoUW>GliIoUo>FmkOcU_NgliIoUW>GliKg]W>GoiIcUo
>FLiOoUo>FLiIoUo>FOiOcUW>GliKg]onFLiOcUW>GoiIcUo>FOiOc800Vmk
01Qo>FOiOcU_NgliIoUo>FLiOcUWnGliIcUonFLiOoUW>GoiIcUo>FOiOcUW
>FOiOcT3Kg/2OcT01VOiKg]o>FmkIoUo>@9_N`0DOcUWnFmkOcU_NgNmIcUo
>FmkOcUWnGliIc9_NgliIoUo>FmkIoUo<PA_N`0;OcUWnGliIcUonFmkOcUW
nGliIoUo>@02Kg/03WliIoUo>FOiOcUWnGliIoU_NgliKg]o>FmkIoT2OcT0
1VOiOcUW>GliIoUo>@=_N`04F]HicTYBF]H7DY@00e[FDYABU003DY@00e[F
DYABU003DY@00e[FDYABU003DY@00e[FDYABU003DY@01E[FDYABU5:DF]H0
2E:D00EJeU:DDYABU5[F009BU003F]IBU5:D00ABU00<@Q1BU5:DDYAW>GNm
000407oo001JeU:D0TYB00AW>D8@36=g_@9JeP03DYAJeU[F009JeP06Ic9J
eU:DBcUBU4YI0U:D00AJeU:DF]IBU0=JeP04IUUW<T/iDY@3F]H00e:DF]IJ
eP0PF]H01E:DF]IW>E[FBcT00e[F00]BU5[FF]IBU6LiF]H004YBKg/006mk
009:DP9BU00DBU8DYE:DOcUWnGliIcUonFLiOoUW>GliIoUo>FLiOoUW>Gli
Kg]o>@5Wn@00015o>FOiOcUW>GoiKg]W>GoiIcUo>FOiOcUW>GoiIcUo>FOi
009o>@09IoUo>FmkKg]o>FOiOcUW>FOi009o>@0@Kg]o>FOiOcUWnGliIcUo
nFLiOcUW>GoiIcUo>FOiOcT2Kg/017liIoU_Ngli0Vmk00ionFLiOcUW>Goi
IcUo>FmkOcUW>GoiIcUo>FOi0Wli00YWnGliKg]o>FOiIcUo>FOiKg]o>@9_
N`0?OcUWnFLiOcU_NfOiOcUW>GoiIcUonFLiOcUWnGli009_N`08Oc9WnGli
Kg]WnGliKg]o>@9_N`04OcUWnGliIcT2Kg/01GliIcUo>FOiOcT00Vmk01ao
>FLiOcUWnGliIoUo>FLbKg]o>FOiOcUW>FmkIoUo>FOiOcUWnGliIoUo>Fmk
OoUJeSW>@Q1W>@9BU004F]IBU5:DF]H2DY@015[FDYABU5[F0U:D00AJeU:D
DYAJeP9BU004F]IBU5:DF]H2DY@015[FDYABU5[F0e:D00]JeU:DDYABU5[F
DYAJeU:DF]IBU5[F00=BU003F]IBU5:D00ABU00GF]IBU4YB<U9W>GooIcU2
45[FKg]JeVmkIcUg_@00IcU_NfIBDYAonC6<001oo`06IcT03U[FBUUW>Goo
OcU_NgoiMke_NgliIoUo>GooF]H2IcT01U[FBUUonGooF]I;>AEW>@03F]IW
>FLi00=W>@04F]IW>FLiBcT7IcT00e[FIcUW>@02IcT094/iOcUW>FLiF]Io
>DYIF]Iooe:D001oofmkMke_NgooKg/48FLbOcm_NfLiOoUW>GliKg]o>FOi
OcUWnGliIcUonFLiOoUW>@5o>@0001Y_NgliIoUo>FmkIc9onFLiOcUWnGli
IcUonFLiOoUW<VmkOcUWnFLiOoUW>GliIoUo>FOi0Wli00m_NfOiKg]_Nglb
IoUo>FLiOoUW>GliIoUo>FmkOcT00Vmk00=o>FObOcT00Vmk00Uo>FLiKg]o
nFLiOcU_NgoiIcT00Vmk025g_FLiOoUW>GoiIcUo>FOiKg]o>FmkOcUWnFLi
OoU_NgliIcUonFLiOcUWnGliKg]o>FOiOcUW>GoiKg]o>FLiOcT016mk00=o
>FOiOcT00Vmk011o>FmkOcUWnFLiOcUWnGliKg]o>FOiOcUWnGliIoUo>@9_
N`07OcUWnGliIoUo>FLiOcT00Vmk00Io>FOiOcU_NgliIoT2OcT2Kg/027li
Kg]o>FLiOoU_Ne[F>Lhj<H`01TYBOoTaS000:DY:C08aS007>Li244YB@Q0<
Hc6<@Q000SW>00=:DS6<5:D00SW>01<aS3W><H`aS3W>@Q1onFLb8@PbDU:D
BHa246F<<U9244YB<I9:C002<H`0348@OoTETQF<F]I9S36<>LhaS3W><H`i
cP8aS005>LhaS3W><H`icP02<H`02cW><H`icS6<>LhaS3W>BH`aS3W><H`0
0SW>00daS3W>BH`aS3W><H`icS6<BH`aS3W><Ha9S002<H`02dV<>LhaS4V<
>Li244Y<BU99S4YB124012U:00TQ25:D36=BU7oiIcUonFLiOcT00Vmk00IW
nGliKg]o>FObOcT2Kg/1IcT1OoT1Kg/0009_N`03OcUWnGli009_N`07OcUW
nGliIcUonFLiOcT00Vmk00=o>FOiOcT00Vmk00Mo>FOiOcUW>GliIoUW>@02
OcT4Kg/02WliKg]_NgliIoUo>FOiOcUWnGli16mk01Uo>FOiOcUonFLiKg]o
>FOiOcUW>GoiKg]o>FLiOoUW>GliKg]onFLiOcUWnFmkOcUWn@02OcT0AfLi
OcUWnGliIcUonFLiOcUWnGliKg]o>FLiOoUW>GliIoUo>FOiOcU_NgliIoUW
>GliIoUo>FOiIcUo>FOiOcUonFLiOcUWnGliKg]o>FOiOcU_NgliIoUo>Fmk
IoUo>FmkOcUWnGliIoUo>FmkIoUo>FLiOoUW>GliIoUW>GliOoUW>GliIoUo
>FmkOcT00TYB>goo0P2/00<ETWooOol05Woo00`aS0030IT0036I0UT00ALo
124aV@2b1004Ool0106B000006IB;Goo00E;?d_oOomg_AIO009oo`0<5cmo
ogoo000<H`@Q5:D00365<I9VDWoi0Vmk00Qo>FOiOcU_NgliIcUWnGli0Vmk
00Ao<VOiOcUW>@5o>@0000AW>GliIoUo>@9_N`05OcUWnGliIoUo>@02Kg/0
1GliIoUo>FOiOcT00Vmk00Eo>FOiOcUW>Goi009_N`0AOcUonFLiIoUo>Fmk
OcUWnFmkOcUWnGlbKg]o>FOiIcUo>@03Kg/087liIoUo>FLiKg]W>GliIoUo
>FLiOoUW>GliIoUo>FmkOcUWnGlbKg]g_FmkIcUo>FOiOcUW>FOiOcUWnGli
IoT2OcT04FOiKg]o>FLiOoUW>GoiIcUo>FOiOcU_NgliIoUo>FOiOcT00Vmk
00Eo>FmkOcUo>FOi009o>@0>IcUWnGliKg]W>GoiIcUo>FLiOcUWnGliKg]W
n@9o>@9_N`03OcUWnGli009_N`0BOcUW>GoiIcUWnGliKg]o>FOiIcUo>FOi
OcUWnFLiOoU:DT8@>7oo00@aTP01001BU1Moo`03DY@0002/0080[00:OUlE
TQFBBIT0YDYO0:`aTQFI0003Ool300000`9I005on@0/Ool01C?oBcUoogoo
0cl00Woo00@2GgooOom_N`=oo`06@Q0Q236<BU9WnGli0Vmk00Io>FOiOcUW
>GoiOcT2Kg/01GliIoUo>FmkOcT00FOi00001GoiIcUo>FOiOcT00Vmk00Yo
>FLiOcUWnGliKg]WnGliKg]o>@9_N`0COcUWnGliIcUonFLiOcU_NfOiOcU_
NgliIoUo>FmkOcU_NfOiOcT00Vmk01Mo>FmkOcUWnGliKg]o>FOiOcU_Ngoi
IcUonFLiOcUWnGliKg]o>FOiOcUWnGli00=_N`0LOcUW<WoiOcU_NgliIoUo
>FLiOoUW>FmkOcUWnFLiOcUWnGliIoUW>GliKg]o>FOiOcUWnGliIcT2Kg/0
0gliIoUo>@03Kg/01FOiOcU_NfmkIoT00Wli029WnGliKg]W>GoiKg]o>FOi
OcU_NgliIcU_NfOiOcUW>GoiIcU_NgliIoUo>FOiOcU_NgliIoUo>FmkOcUW
nFmkOcU_N`9o>@03Mke:DTYB03Aoo`05Kg]:DP6<00048@0GOol04U[F0:`0
036I0;8aTWlo0:DaVC6B0I8bG`2/<I99V@2/BI80009oo`8000050:DD[6Oo
0:D00`0/Ool2Bcl00gooMkdG?`02Ool071LoIomo>D/iBI8006Li>LhQ236<
IU9g_FmkOcUWnGliIcUWnGliIcU_NgliIoU_NgliIoUo>Fmk0Gli00001VLi
OoUW>GliIoUo>@9_N`03OcUWnGli009_N`0HOcU_NgliIcUWnGliIoUo>FLi
OoUW>GliKg]WlWliIcUo>FOiOcUWnGliIcUWnGlb0Vmk015o>FOiOcUWnGli
IoUo>FOiOcUW>GoiIcUo>FLiOoU_Ngli009_N`06IoUo>FLiOcUW>FOi0Wli
00UWnFmkOcUWnFmkIcUo>FOiOcT00Vmk015o<VmkMkeo>FmkOcUWnGliKg]o
>FOiKg]o>FmkIcUo>FOi009o>@0NIoUo>FmkIoUo>FmkOcUWnGliKg]o>Fmk
IoUo>FLiOcUWnGliIoUo>FmkIcUo>FOiOcUWnGliIcUonFLi0Wli01AWnGli
Kg]o>FLiOcUWnGliIcUonFLiOcUW>GoiIcUo>FOiKg]:DT8@<Woo00EJeQFB
0:D006Lo01Ioo`0OKg/icP6<000bG`6<BUTc?`00Icl0[1B/IUl00C<o0:D1
VDYO0I9:G`2/:DX000010600/P2/BcmWo`05<U80:goo00Dc?d/oOomWoaIO
009oo`0F0UmoogooF]HYBP00BU8icR48<Ha:DWoiOcUWnGliIcUonFmkOcUW
nGliIoT2OcT016mkOcUW>Goi0FLi00006WliIcUonFLiOcUWnGliKg]WnGli
IoUo>FOiIcUo>FOiOcU_NgliKg]WnGliKg]o>FOiOcT2Kg/01gliIoUo>FLi
OcUWnGli009_N`0IOcUW>GoiIcU_NgliIcUo>FOiOcUW>GoiIcUo>FOiOcUW
>GNmIoUo>FLiOcUWnGliIoT00Wli00=WnFLiOcT00Vmk01eo>FmkOoUW>Gli
IoUo>FOiKg]o>FLbIoUo>FmkOcUW>GoiIcUo>FOiOcUWnGliIoUo>FOiIcUo
>Fmk009o>@0`IoUo>FLiOcUWnGliKg]o<VmkIoUo>FOiOcUW>GliIoUo>FOi
Kg]o>FOiOcUW>GoiIcUonFLiIoUo>FmkIoU_NgliIoUo>FLiMke_NgliIoUo
>FLiOoUW>GliOoU244YB8Woo00=;>GooOol02goo00@Q202/001241Moo`0G
DY@D[0000:a9VAB/BclD[1Bb5cl0YFIOB:`1TTYO021;?dVB0H`G?`0P36<0
[0020000206<0:D0Y@000H`0YFLi00P[Ool01D/oBomoogNm5cl00Woo00D2
GgooOoU:DVmk009oo`0E5:D<HcW>BU9o>FOiOcUWnGliIcUo>FOiOcU_Ngli
IoUW>GliIoUo>FLi005on@0000aWnGliKg]g_GliIcUonFLiOc9_NgliIoT2
OcT02fOiOcUWnGliKg]W<WliIoUo>FOiOcT00Vmk00Mo>FOiOcUW>GliIoUo
>@02Kg/00gliIoUo>@02Kg/087liIoUo>FOiOcUW>GoiIcUo>FOiOcUW>Goi
IcUo>FmkOcUWnGliKg]o>FLiIoUo>FmkOcUWnGliIcUonFLiOcT2Kg/04Wli
IcUo>FOiKg]o>FOiOcUW>GoiIcUo>FmkOcUWnGliIcUo>@9_N`0;OcUWnGli
IcUWnGliIcUonFLiOcUWn@03Kg/047liKg]o>FmkOcUWnFLiOoUW>GliKg]o
>FLiOoUW>Gli0Vmk00=o>FmkKg/00Wli00YWnGliIcUonFLiOcUWnGliIoUo
>@=_N`03Mke:DTYB025oo`0300<00Goo00Uoo`06Iol01@00<I9_NgNm5Goo
02EWo`1P0:`0002/Iol<06Lo0Ha9TS9I0HanF@2U<IlbF@2/OolD[1FB0:`0
032U000FGaFB0:`0Y@2/06000`2/<:`D/P00Ool00003Ool00`00DYAoo`0T
Ool01C<oBcmg_Goo5Ul00Woo00`3?gooMke245[FDYAW>E:D<H`Q25:DOoT2
Kg/03WliKg]o>FOiOcUW>GoiIcU_NgliIoUo>FOiOcT1Kg/00008OcUWnGli
Ic9WnGliIcUon@=_N`08OcUW>FOiOcU_NgliIoUo>@9_N`0COcUW>GliIoUo
>FmkIoUo>FmkOcUWnGliIoUo>FmkIoUo>FOiOcT00Vmk02Eo>FOiOcUW>Goi
IcUo>FOiOcUWnGliIcUonFLiOcUWnGliIcUonFLiOoUW>FmkOcUWnGliIcUo
nFLiOcUWnGliKg]WnGliKg]o>@02Kg/02gliIoUo>FLiOoUW>GoiIcUo>FOi
OcT00Vmk02Ao<VOiOcUWnGliKg]WnFmkOcUWnFmkOcU_NgliIoUW>GliIoU_
NgliKg]o>FLiOoUW>GliIoUo>FmkOcUWnGliMke_NglbIoT2Kg/047liIcUo
nFLiOcUWnGliIcUo>FOiOcU_NgliMke244YB8Goo00<ES008Ool01goo00=;
>@0000005goo02aW>@01000`/P05<Um:G`2/Bcl004YO<IT0YFIO0:EW?`2U
IUTbG`0P00D0002/BUl0/T_o<ITD[09I<I80002U00XQ23<o0:a:F@2/Oom_
N`01OomWoaB/9Woo0T/o00=oogoi0cl00Woo00dFGgooOom246LiF]IBU7Nm
Icl<06LbMkeo>@02Kg/03GoiIcUo>FOiOcUW>GoiIcUonFLiKg]o>FOi005o
>@0000MWnGliKg]_NgliIoUo>@03Kg/06gliIcUonGliIcUo>FOiOcUWnFmk
OcUWnGliIoU_NgliKg]o>FOiOcUWnGliIcUo>FOiOcUW>@02OcT066OiOc9_
NfmkOcUW>GoiIcUo>FOiOcU_NgliIoUo>FLiOcUWnGlbIcUonFLiOoUW>@9o
>@0GIoUo>FmkIoUo>FLiOoUW>GliIoUo>FmkOoUW>FmkOoUW>GliIoUo>FLi
OoUW<P02Kg/00gliIoUo<P02Kg/027liKg]o>FOiOcUW>GliIoT2OcT00fmk
OcUWn@02OcT04FOiOcUo>FOiOcUW>GoiIcUo>FOiOcUWnGliIoUo>FmkIc80
0Vmk01=o>FLiOoUW>GoiKg]o>FOiOcU_NgliIoUo>FOiOcUWnGliBU92400Y
Ool00`2/0000[00GOol0;c6B000007iO0:aVGc9I0:Dc?`0PBUl2FAB/IUT0
[6Lo0;8FF@2/0201TP005cmmTP6BBom001Bb<Ul1TS6B<IT0H005B:`083?o
:DX`/P0@<c9oo`08Mkeoo`03<UT09Goo00Dcod/oOomWoaIO009oo`040Umg
_GooBU83F]H016LiIc80YFIB0Vmk00YWnGliIcUo>FOiOcUWnGliKg]o>@9_
N`03OcU_Ngli005Wn@0000=o>FOiOcT00Vmk00io>FOiOcU_NgliIoUo>FLi
IoUo>FOiOcUW>Gli0Vmk00Qo>FOiOcUW<VOiOcU_Ngli0Vmk00eWnGliKg]o
>FOiOcUWnFLiOcUWnGliIoUo>@02Kg/00gliIoUo>@03Kg/01GliIoUo>FOi
OcT00fmk00Qo>FLiOoUW>FOiOcUW>Gli0Vmk011onFLiOcUWnGliIcUo>FLi
OoUW>GliIoU_NgliIoUo>@9_N`0HOcUWnFmkOcUWnGliKg]WnGliKg]o>FOi
OcU_NgliIoUW>GliIoUo>FOiOcUW>FOi0Wli01UWnGliKg]o>FOiOcUW>Gli
IoUo>FLiOoU_NgliKg]WnGliIcUo>FLiOcUWnGliIcUon@02IcT2OcT00fOi
OcUWn@02BU8VOol0139B00001C9B5Goo031g_FLb5;800005Ool1QDYO<I81
TVIO001;o`2/IU9mTP6<<Ul0YAFB000Q21FB0:aooc2b0I9VG`0PBclaTQFB
Icl000aSBol020aS<:`003<o<;8FF@6B<Haooe[F00<XOol2Bcl00gooMkdG
?`02Ool011LoOomood8@0e[F00UW>E:D36=BU7oiOcU_NfOiOcT00Vmk00Yo
>FLiMkeWnFmkOcU_NfOiOcU_N`5o>@0000e_NgliIoU_NgliIoUo>FmkOcUW
nFLiOcUWn@02OcT2Kg/01WliIoU_NgoiIcUo>@9_N`05OcUWnGliIcUWn@02
OcT01fOiOcU_NfLiOoUW>Gli00=_N`08OcUWnFmkOcUWnGliKg]Wn@9o>@04
IoUo>FmkOcT2Kg/2OcT01fOiOcU_NfmkOcUWnGli009_N`0;OoUW>GliIoUo
>FLiOoUW>GoiIcUo>@02Kg/00gliIoUo>@02Kg/017liIoUo>Gli16mk015o
>FLiOoUW>GliIoUo>FLiKg]onFLiMkeW<VmkOcUWnGli009_N`03IcUonFLi
009_N`0MOcUWnFmkOcUW>GoiIcUo>FOiKg]o<VmkOcUWnGliIoUo>FLiOoUW
>GliOoUW>FOiOcU_NgNmBU92400TOol014YB001:FGNm5Goo00YVDQF50;84
002/Bol0[6IO5;99TP8ETP0S5clD/Wlo0I8`YDR/000ETR00<I99TQFIIcl0
[4YO0I80[7lo5:`EVDVB000FF@aS5ITaVA@01000Y@030:D1TP40IUl00`02
Ool00b48005oo`0VOol01C<oBcmoogNm5Ul00Woo00D2GfOoOoU:DVLi009J
eP9W>@0<00=W<WloIoUo>FLiOcUWnGliIcUonFLi0Wli00EWnFLiOcUWnGli
005_N`0000U_NgliIcUonFLiOcUWnGliIoT00Wli00EWnGliIoU_Ngli009_
N`06Oc9_NfmkOcUWnGli0Vmk00Eo>FOiOcU_NfOi009o>@0:IoUo>FmkKg]o
>FOiOcUg_FmkOc82Kg/04WliKg]_NgliIcUWnFmkOcUWnGliIoUo>FmkIoUo
>FmkIoUo>@9_N`03OcUWnGli009_N`03OcUWnGli009_N`06OcU_NfmkOcUW
nGli0Vmk00=o>FOiOcT00Vmk00Qo>FLiIoUo>FmkOcUWnGli0Vmk00Uo>FOi
OcUW>GoiIcUo>FOiOcT00fmk01=o>FOiOcUW>GoiIcUonGliIcUg_GliKg]W
nGliKg]onFLiOcUWn@02Kg/04GliIcUonFLiOcUWnFmkOcUWnGliKg]o>FOi
OcUonD8@BU808Goo00IWofLiOol<002UBUTCOol046Li5:`D006I00PES4_o
00Eo?`0PBcl1TTVBIcl0[4YO0P2U0200[0@0<cl007Nm5I8EVD/o001;?a@5
0I9W?`2U<UT<H`6B5IT48@9I00D0Y@6B0:DD00aS5;8EVC2/00DD[0000goo
00<007NmOol09Goo0T/o00=oofOo5cl00Woo00@FGgooOom240=JeP0EIcUJ
ePaSDYAonGliIoUo>FmkOcUWnGliIcUonFLiOcU_NgoiIcUo>FOi005o>@00
00=o>FOiOcT00fmk00Ao>FLiOcUWn@=_N`04IcUo>FOiOcT3Kg/027liIoUo
>FOiKg]o>FOiOcT2Kg/037liIcUg_FLiOcUWnGliIoUo>FmkIc9o>@9_N`0I
OcUWnFmkOcUW>GoiKg]o<VmkOcUWnGliIcU_NgliIoUo>FLiOcUWnGlbKg]o
>FOiOc800Vmk00=o>FOiOc800Vmk01iWnGliIoUo>FOiKg]o<VmkOcUW>FOi
OcU_NfOiOcU_NgliIoUo>FOiIcUo>FOiOcUW>GoiIcUo>FOiOcT3Kg/047li
IoUo>FmkOoUW>GliKg]W>GoiIc9g_FmkOcUWnGlb0fmk00Eo>FmkOcUWnGli
009_N`03OoUW>Gli009_N`08IcUonFLiOcU_NgNm@Q1:DQmoo`09000bDWli
0:aoo`03Ool1S1B/011oo`0e5H`0Y@00BI81TQFBIcl01Glo0:DG?dVB5UU;
?`000H`001FB020aVDYO0:a;?`6B<I8bF@2U<cl00fIO<UT1TQLo0001V@03
5002F@005I9:GaBPIol1VEP0800G?`2UOITES09O021JeP02Ool00fOo001o
o`0UOol01C<oBomg_Goo5Ul00Woo00@2GgooOom:DPAJeP0DIc848E[FOcUW
nGliKg]o>FOiIcUo>FOiOcUWnFLiOoUW>GliKg]o>@5Wn@0000A_NgliIoUo
>@=_N`0lOoUW>GliKg]o>FOiOcU_NglbIoUo>FmkOc9WnGliIcUo>FOiKg]o
>FLiOoU_NfLiOoUW>GliKg]o>FOiOcUWnGliKg]WnGliIcUonFLiOcUWnGli
IcUo>FmkIoUo>FmkIcUonFmkIcUo>FOiOcU_NgliKg]WnGli0Vmk00=o>FOi
OcT00Vmk00=o>FmkOc800Vmk00mo>FLiOoU_NfLiOoU_NgliIcUonGliIcUW
nGliKg/00Wli01aWnGliKg]_NgliIcUonFLiOcUWnGliKg]o>FOiOcUW>Gli
IcUonFLiOcUWnGliKg]W<WoiIcUo>@9_N`08OcU_NfOiOcUW>GliIoUo>@9_
N`0<OcUWnGliKg]o>FLiOoUW>GliOoU:DT8@8Goo00@bDPaSIol00@9oo`03
0:`ES7oo00]oo`0_DY@00`0500PbFD/o0:a:G`2UOcl1S39III81TQB/0200
[02UIcl0[7iO5UT0YD_o004bFDR/0I9W?`2UOclETP9I0:`0002U00D083<o
005o?dYI0;Uoo`6BBcm;>@0200001fIO0H`EVA@5<Ul02VLi00=oo`03004b
DWoo02Aoo`9;?`03Oomg_ALo009oo`055cmWogNmBU9W>@02F]H02FLiF]H<
He:DOoU_NfLiOcUWn@02OcT00fOiOcU_N`02OcT01FLiOoUW>GoiIcT00Gli
00003gliIoUo>FOiOcUWnGliIcUonFLiOcUWnGliIoUo>@02Kg/01gliIoU_
NgliKg]o>FOi009o>@0BIcUonFLiOcUWnGliIoUo>FOiKg]o>FLiOcUWnFmk
OcU_NfOi0Wli01AWlWliIoUo>FOiKg]o>FLiOcUWnGliIcUonFLiOcUWnGli
IoU_Ngli0Vmk00Qo>FOiOcUW>FmkOcUWnGli0Vmk02Qo>FOiOcU_NfLiOoUW
>GliIcUonFmkIcUonGliIcUo>FOiIcUo>FOiKg]o>FOiOcU_NgoiIcUo>Fmk
OcUWnGliIcUonFLiOoUW>GliIoUo>@9_N`03OcU_Nfmk009_N`0AOcUWnFmk
OcUWnGliKg]o>FOiIcUo>FOiOcU_NgliIoUo>@02Kg/016OiOcm244YB8goo
00=W>@00Ool00Woo00<0[1F<Ool01goo00Eo>@2/0001V@08009W?`0d0:E;
o`2/Ool0H7fB5;80006B000FF@2/Ool0[6II5I81TTYI00EW?`2/IUTG?`2/
Bcl0[02U0004002/000bGd/o0:Eoo`6<BIUoo`2UIclFF@0000P0009O000a
VAFB<I80[36O0004Ool00`@0Iomoo`0SOol01C<oBcmoofOo5Ul00Woo00@2
GgooOom:DP9JeP0DDYAW>FLi125VDWNmIcUonFmkOcU_NfOiOcUW>GliIoUW
>GoiIcUo>@9_N`5o>@0002Q_NgliIcUo>FOiOcUWnGliKg]o>FObOcUW>Gli
IoUo>FmkIcUo>FmkIoUo>FmkOcUWnFmkOcUW>GoiIcUo>FLiOcUWnGliIoU_
NgliKg]o>@9_N`04OcUW>FOiOcT2Kg/07WliKg]o>FOiKg]o>FOiOcUWnGli
IcUonFmkOcUW>GliKg]WnGliKg]WnGliIcUonFLiKg]o>FOiOcUWn@9o>@0E
IoUo>FmkKg]o>FOiOcUW>GliIoU_NfLiOoU_NgliIoUo>FLiOcUWnGli009_
N`09Ic9onFLiOcUWnGliIoU_Ngli009_N`0LOcUWnGliIoUo>FmkIoUo>Fmk
OcUWnGliIcUonFLiOcUWnFmkOcU_NgoiIcUo>FOiOcUWnGliIoT3OcT00fOi
BU92400SOol00bU:00=oo`03Ool00`2/0:Eoo`03Ool0<Gli>Lh0[0@0<UlE
TS9BOol01Goo0:`FG`aS5UT00`2U5I80[6Oo5I9;?`2UIUUTX06IIUl407Nm
0I9:FAIO:000[0000I8DY@00Bcl0YGoo0H`aTWlo00DcodVB0:EWo`2U0080
000;5:`Go`2U5;81S0030:a;?`2/<;80Y@04Ool00fOo005oo`03Ool00gNm
Oomoo`0MOol2Bcl00gooOoT3?`02Ool011IOIomood8@0e[F00YW>E:D36=B
U7oiOcUW>GoiIcUo>@9_N`03OoUW>Gli009_N`04OcUWnGliKg/1IoT0000>
OcUWnGliIoUo>FLiOcUW>GoiIcU_NgliIoUo>@9_N`0CIcUonFmkKg]o>FOi
OcUWnFLiOcU_NgoiIcUo>FOiOcUWnGliIcT00Wli00QWnGliKg]WnGliIcUo
nGli0Vmk01=o>FLiOoUW>FmkOcUWnGliKg]o>FLiOoUW>GliIoUo>FmkIoUo
<P02Kg/01gliIcUonFmkOcUWnGli009_N`04OcUW>FOiOcT2Kg/057liIoUo
>FOiOcUWnGliIcUonFLiOcU_NgliIoUo>FOiOc9_NfOiOcT2Kg/03GliIoUo
>FmkOcUW>GliIoUo>FOiOcUW>Gli009_N`0:OcUW>GoiIcUo>FOiOcUW>Gli
IoT2OcT03VOiOcUW>GliIoUo>FLiKg]o>FLiOoUW>FmkMkd2BU8LOol02D/i
F]IooaIBOolbDWoo36=VDP05Ool0A48@<I9g_Gli5:D1TP00BclG?c6IOol0
[4/o000bF@005H`1TP@0IUl1S6Oo125:G`03BUTETTVBIUT0[4_o00<c?c2U
0000Y@00<I80YFIOBol0[6Lo00E:FC9IB;8c?`08021;?aFB000`[1@55IT0
YC9O<IT1TP00IUl00AFB021:G`0:Mkd3Ool00dYB001W?`02Ool00`2/0:Eo
o`0NOol01D_o<cmoogoo5Ul00Woo00D3?gooOoU:DVLi009JeP0EIcUJePaS
Ic9o>FOiOcUW>FOiOcU_NgNmIcUonGliIoUo>FOiOcU_NfOi005o>@0000YW
nGliKg]o>FOiOcU_NgliIcUon@9_N`0KOcUWnGliKg]onFLiOcUWnGliIcUg
_FmkOcUWnGliKg]o>FOiOcU_NgliIoUo>FOiIcUo>FOi009o>@0:IoUo>FLi
IoUo>FmkIoUo>FLiOoT2Kg/02gliIoU_NfmkOcUW>GoiIcUo>FOiOcT00Vmk
00ao>FOiIcUonFLiOcUWnGliIoUo>FOiKg/2OcT04VOiOcU_NfmkOcUW>Gli
Kg]o>FOiOcUW>GoiIcUWnGliKg]o>@9_N`9o>@0CIoUo>FmkIoUo>FLiOoUW
>GoiIcUo>FmkOcUWnGliIoUo>FOiOcT00Vmk00ao>FOiOcU_NgoiIcUo>FOi
IcUo>FOiOcT2Kg/02fLiOoU_NfmkOcUW>GoiIc9onD8@BU8077oo00UBU02b
0:D01D/i00EooaF<<U801Woo01h0Y@005Ul024/oBolETWoo0002F@000:`a
TP2UBclD[6IO0:aWo`2bIUl1TWiO<cl2FDVI004c?`015UT20000802/0:En
G`2/IolFF@05Ocl0YFLo<cl00`9O000ETWoo:DXbDP@05:E:G`9I0IT<Hc05
36<FG`0P<ITaTS2b12420:`02gNmOomooc9I001;?`00IcUoo`035I807goo
0T/o00=oofOo5cl00Woo00@FGgooOom240=JeP07IcUJeP05F]Ig_GliIoT0
0Wli00]WnGliIcUo>FmkIcUo>FOiOcUW>Gli009_N`0000Uo>FmkKg]_Ngli
IoUo>FOiOcT00Vmk01=o>FOiOcUW>GoiIcUo>FOiOcUWnGliIcUo>FOiOcUW
>GliIoUo<P02Kg/03FOiOcUg_FLiOcUWnGliKg]WnGliKg]WnGli009_N`0<
OcUWnGliKg]o<WNmIcUo>FmkOcUWnGli0fmk00Mo>FmkKg]o>FOiOcU_N`02
OcT00fOiOcUW<P02Kg/2OcT03VOiIcUo>FOiKg]o>FOiOcUWnGliIoUo>FLi
OoT2Kg/02GliKg]o>FLiIoUo>FmkIoUo>@02Kg/04gliIcUonFLiKg]o>FOi
Kg]o>FOiOcUWnGliIcUo>FOiKg]o>FOi009o>@03IoUW>Gli009_N`04OcUW
nGliIoT2OcT01VOiOcUW>GliIoUo>@9_N`03Mke:DT8@01ioo`070:Eoo`2/
001oo`03IcT00Woo03MBU0@00I801FIOOol1S7oo000FF@005I800c6<<U82
FGlo0;9Wo`2/Iol0YGlo0H`0[02U0000[000<cl081FB020D1AFB8@Q;o`2U
Ocl2FAB/OclD[4/o0;80802/005;<Woo0:DaS06<0;80^@020:D03TVI0H`a
V@6B0:DD[6IO1001TS6I5UT0[0005H`2Ool01@0000<c?`005:D08Woo00Dc
?d/oOomg_AIO009oo`070UmWogooBU9W>E[FDY@00VLi01<086LbOcU_Ngli
IoUW>GliIoUo>FmkIcUonFLiKg]o>FOiOcUWn@01OcT0000LKg]o>FOiOcUW
>GliIoUo>FOiOcU_NfLiOcUWnGliIcUonFLiOcU_NgliIoUo>FmkOcU_NfOi
OcT2Kg/037liKg]o>GNmIc9onFmkOcU_NfLbOcUWn@9o>@0?IoUo>FmkKg]o
>FOiOcU_NfLbOoUW>GliIoUo>FOi009o>@0;IoU_NgliIoU_NgliIcUonFLi
Kg]o>@02Kg/00gliKg]Wn@02OcT04fOiIcUo>FmkIoUo>FLiOcUWnGliIoUo
>FmkOc9WnFmkOcUWnGli009_N`04OcUW>FOiOcT2Kg/2OcT04VOiOcUW>Gli
Kg]WnGliKg]o>FOiOcU_NgliIoUW>GliKg]Wn@9o>@0BIoUo>FmkIoUo>FLi
OcUWlVmkOcUWnGliIoUo>FOiOcU_Ngli0TYB8Woo00aJeP2/Oomoo`000I8c
?`2bOol0YC<o00020;803248<cl1TWoo0;9;o`0:Ool0/S<o100ETP80000G
5I800c<o0I9o?`2U0UT01C2/<Ul2DWlo0:ao?aB/5UU:F@005I8401B/5cl0
1@02Ool07`2/36<1V@00<:`ETS9B5Il0032/5:`aTP2/BUl0006I0I80H32/
<Ul0YABi5:1oo`010200[02U5;80YD/i025oo`05Bcm;ogNmOol3?`02Ool0
11LoOomg_DYB0e[F00EW>FIB5:EBU7oi009_N`0>OcUWnGliIcUonFLiOoUW
>GoiIcU_NgliKg]o>@5Wn@0000Uo>FOiOcUW>GoiIcUg_FLiOcT00Vmk01Mo
nFLiOcUWnGliIcUo>FmkIoU_NgliIoUo>FOiKg]o>FOiKg]o>FOiOcU_NfLb
009_N`0IOc9_NfmkOcUWnGliKg]WnGliIcUonFLbMkeo>FOiKg]o>FmkOcUW
nGlbKg]o>FLiIoT00Wli01]WnFmkOcUW>GoiIcU_NgliKg]WnGliIoU_Ngli
IcUWnGliKg]o>FOiOcU_NgliIoUo>FLiOcT00fmk0Wli01=WnFLiOoUW>Gli
IoUo>FmkOcUWnGliIoUW>GliIoUo>FmkIoUo<P03Kg/037liIcUonFLiOcU_
NgliIoUo>FLiIoUo>@9_N`03OcUW>Goi009_N`07OcU_NgliIoUo>FLiOcT0
0Vmk00=g_DYBBU808goo03<000030:EooaB/OolDX00<5:00[7oo0:aoo`2U
Ool024/o0:D0[0@0<I8000@05I8087lo0:Eoo`6BBUTD[02/36<D/T/o0I9o
?`00Icl0802/5:`0039O004c?fOo0I9ooaII00D00P0001l0YFIO0IT1S000
0UTD/S6B0I8406FI0I98/QFB0:`0YAFI50DbG`0PBIlFFABU0000Y@005ITF
GgNm001g_@0POol01D/o<cmoogNm5Ul00Woo00@2GgooOom:DP=JeP0EIcUJ
eP@QF]Ig_FmkOcU_NgliIoUo>FLiOoUW>GliIcUonFmkOcUWnFmk005o>@00
019_NgliIoUo>FLiOoUW>GliIoUo>FLiOcUWnFmkOcUWnGliKg/2OcT026Li
IoUo>GliIcUonFLiOcT2Kg/027liIoUo>FmkOcU_NfOiOcT2Kg/03WliKg]o
>FLiOcUWnGliKg]W<VmkOcU_NfOiOcT3Kg/01GliIoUo>FmkIoT00Wli00MW
>GliIoUo>FOiOcUWn@02OcT04VmkOcUWnGliKg]o>FOiOcUWnGliKg]o>FOi
OcUWnGliIoUo>@9_N`0CIoUo>FmkOcUW>GoiIcUo>FOiOcUWnGliIcUo>FOi
Kg]o<VOiOcT00Vmk00ao>FOiOcUWnGliIcUonFLiOoUW>GliIoT2OcT04VOi
OcU_NfmkOcUW>GoiKg]W>GoiIcUo>FOiOcUWnGliKg]on@9241moo`1<Mkda
TWooBcT007lb0:`0YC9I001;?`2UOol0[5:D00E:DQBU00DaQ@@0<UT0YAII
101oo`2/Ool1TT_o5:`ETP055H`0YAII<clD06II0001TQBU005:F@00OolE
QD_oIol00d_o5I84000P000bDVLo0;8ES1FB5Il2F@015:DEW`6B0ITD1AFB
BIT0YDVI00<1TP@0BUl25I802QFI0000Y@050:D<Hc6IBU9;>@0587oo0T/o
00=oogNm5cl00Woo00@FGfOoMke:DP=JeP07IcUJeP@QIU9onGliIoT00Vmk
00]o>FOiOcUW>GoiIcUo>FLiOoUW>Gli009_N`0002io>FOiOcUW>GoiKg]o
>FOiOcUWnGliIoU_NgliKg]o>FOiOcU_NfLiOoUo>FmkIcUonFLiOcU_NfOi
OcUWnGliIoUo>FmkIoUo>FLiOoU_NgliIoU_NgliIoUo>@9_N`0;OcUWnGli
IoUo>FOiOcU_NgliIoUo>@02Kg/05gliIcUWnGliIoUo>FmkOcUWlWliKg]W
>GoiIcUo>FOiOcUWnFmkOcUW>GliIo800Vmk01Eo>FLiKg]o>FOiOcU_Ngli
IoUo>FLiOoU_NgliIoUo>FOiOc9_NgliIoT00Wli0Vmk00io>FmkKg]_Ngli
IoUo>FLiOoUW>GliIcUonFLi0Wli01=WnFLiOcUWnGliIoUo>FmkIcUonFLi
OcUWnGliKg]o>FOiOcU_N`02BU8OOol0F@2/001ooc6<>LiW>@2/5Ul00D/i
101;?`00Bcl0YC6I00a;oaBbBolFFGoo5:aoo`6BBcl2FC9O8000[0000:D0
[0000IT001FB100FFBU:0:aoo`2UOolbFDYI5Ul004/b5H`DY@2/5I9BU1II
5:`Q206I5IT00dRUIITD/PaS5;81TS6I0:D081FO0I8`/QFI5I8<002U5;8E
VC9O000081B/0:`ETP05<IUoo`00BcT07goo00Dcod/oOomWoaIO009oo`04
0cmoogooBU83F]H046LiF]H<He:DKg]WnGliIcUo>FOiOcUW>GoiIcUo>FOi
0Wli00=WnGliIoT00Gli00008fOiOcU_NgliIcUo>FOiOcUW>GliKg]o>Fmk
IoUo>FmkOcUWnGliIoUW>GliIoUo>FLiOoU_NgliIcUonFLiKg]o>FOiOcT0
0Vmk00Yo>FLbOoUW>GliKg]WnGliIoUo>@9_N`0;OcU_NfmkOcUW>FOiOcUW
nGliIcUon@02Kg/01WliIcUonFLiKg]o>@=_N`0OOcUWnFLiOoUW>GliIcUo
>FmkIoUo>FmkOcUW>GoiIcUonFLiOcUW>FOiOcUW>GliIoUo>FLiMke_Ngli
IcT00Vmk00Qo>FOiOcUWnGliKg]o>FOi0Wli00eWnGliIcUo>FOiKg]o>FOi
OcUW>GoiIcUWn@02OcT01VOiOcU_NgliIoUo>@9_N`03OcUWnGli009_N`06
IcUo>GoiKg]244YB87oo01PETWooDY@ES7ooIcT007Nm0;9Wo`1P<clQ26Oo
0I8FFC9I<cT001F<124ES02U0H`300008c<o001o>@00Bol0/VOo00<bGd/o
0:aoo`2/OolD1@9O<H`001FIOoT0/T/o0:aWo`00<UT001II5:`Q202/<IT0
802/BIT00QB/00X001IO0I81TP0P<:`2F@6B<:`aV@80Y@0<36=UW`2U0:aT
1@0PBol40001Iomg_@@07goo0T/o00=oogNm5cl00Woo00@2GgooOom:DP=J
eP0EIcUJeP@QIc9g_GliIoUo>FmkOcUWnGliKg]o>FOiOcUWnFLiOcUWnGli
005Wn@000Wli01MWnFmkOcUWnGliKg]o>FOiOcUWnFmkOcUWnGliKg]W>Goi
IcUo>FOiOcUWnGli009_N`03IcUonFLi009o>@06IoUo>FmkKg]o>FOi0fmk
00Eo>FOiOcU_Ngli009_N`0@OcUWnFmkOcUW>GoiMkeW<WliIoUo>FmkIcUo
>FOiOcT2Kg/02GliIoUo>FmkOcUWnGliKg]o>@02Kg/01GoiIcUonFLiOcT0
0Vmk00IonFLiOoUW>GliIoT2OcT086OiOcUWnGliIcUonFLiOcUW>GoiKg]o
>FOiKg]o>FLiIoUo>FOiOcUW>FOiOcUW>GliIoU_NgliIoUo>FLiOoT2Kg/0
27liKg]WnGliIcUo>FOiOcT2Kg/037liIoUo>FmkIcUo>GoiKg]W>GoiBU92
429oo`0]00<aTWooOomon@03004ES1FI0:DD[0038@P0[000BUlFFAFI<IT1
TP015IT0YD/o0I9;?aF<BclEVC<i<UTaTVLo0I9o?`015cl4002b0IT004/o
Oolc?aII00<0000W<UUWo`2/Iol401Bb<Ul0002/<Il0Y@03BITES02U<:`E
V@2/5IT0Y@aSIUl0[1B/<ITETP@00UTD1@1P0;8004YO0I800DYBOom;>@00
009oo`0336<007oo01Uoo`05Bclc?gooMkdFG`02Ool01@9OOomonDYBIcT0
0U[F00UW>E[F36=JeWliIoUo>FOiOcT00fmk00=o>FOiOcT00Vmk00Ao>Fmk
Kg]o>@5_N`000Vmk00mo>FLiOoUW>FmkOcUWnGliIcUo>FOiOcUW>FOiOcT0
0Vmk00]o>FOiOcUW>GliIoUo>FmkOcUW>Goi009W>@03OcUWnGli009_N`0;
OcU_NgliIoU_NgliIcUonFLiOcUWn@02OcT01FmkIoUo>FLiOcT00Vmk019o
>FOiOcUonFLiOcUWnGliIcUonFLiIoUo>FmkOcUW>GoiIcT2OcT026LiOoUW
>GliIoUo>FLiOcT2Kg/04WliIoUo>FOiKg]o>FmkOcUW>GoiIcUo>FOiOcUW
>GoiIcUo>@9_N`0;OcUW>GoiKg]W<WNmOcUWnGliIoUo>@02Kg/01WliIoUo
>FLiOcUWn@9o>@0BKg]W>GoiIcUo>FOiOcUWnGliIcUonFLbOoUW>GliIoUo
>GNm0TYB8Goo00=Wo`05Ool00goo00=g_@2/00X00S9I04XFFAFB5UTaTT_o
5I9W?`2U0:`Q21FBBcmVFAF<<U99TQIO0:DEWb485:`0006<0002GaB/0:E;
o`@QOom;?aB/0I8000@00:D0/Woo36<ES0@00U80/P6<020aV@2/0ITETP6B
B;80/P9O1001S4VI5:EUW`0P0;81S4VI0:al^@2/0Ul0[0@006000@2U5Ul0
26Li0Woo00D007ooOol0002/01Yoo`9;?`03OomWoaLo009oo`045cmg_Goo
@Q04F]H026Lb125JeWNmOcUW>GliIoT2OcT00fOiKg]o>@02Kg/01GliIoUo
>FmkIoT00Gli00007FLiOoUW>GoiIcU_NgliIoUo>FmkOcUWnGliIcUonFmk
OcUWnGliIoUo>FLiOcUWnGliKg]o>FOiOcT00Vmk02AonFLiKg]o>FOiOcUW
>GoiIcU_NgliIcUonFLiOcUWnFmkOcUW>FOiOcU_NgliIoU_NgliIoUo>Fmk
IcUo>FOiOcUW>GoiIcT2OcT056OiOcUW>GoiIcUonFmkIoUo>FmkOcUWnGli
IoUo>FmkIoUo>FOiOcT2Kg/02gliIcUonFLiOoUW>GliIoUo>FObOcT00Vmk
00Eo>FOiOcUWnGli00=_N`05OcUWnGliKg]o<P02Kg/027liIoUo<VmkOcUW
nGliIoT2Kg/02GoiIcUo>FOiOcUW>GliIoUo>@02Kg/027liIoUo>FLiOoU_
NdYB@Q0MOol01dYIOom_NgooMkd00fLi00Eoo`1A5H`0000P0:`ETQB/0:D0
00010:D00AIB00<ES0005I800@2/000FDP005H`003<o:DY;?c<o5HEoo`0>
Kg/1TP00<cl1S0001001TP035:01VD/o0:a;?`005H`EVAB/0:`ETP00<I8`
300P5H``^@6<<0D`YC2i0I80/S6B000aV@2UBUlD[200Bol000`05I8D/P2P
<;802T/bBUlbDP00009oo`03Iomoogoo01Qoo`05<cm;ogNmOolFG`02Ool0
109OOomoodYB0e[F019W>FII0:EVDWoiIcUo>FOiOcUWnFmkOcUW>GliIoUo
>FOiOcT2Kg/1OcT1Kg/00007OcU_NgliIcUonFLiOoT00VLi00monFLiOcUW
nGliIcUo>FOiOcUW>GliIoUo>FOiOcT00Vmk01eWnGliIoUo>FLiOcUonFLi
Kg]o<VOiOcUW>GoiIcUonFLiOcUWnGliKg]o<VOiOcU_NfLiOoU_Ngli009_
N`0;OcUWnGliIoU_NgliIoUo>FLiOoUW>@02Kg/03gliIoUo>FmkIc9o>Fmk
IoUo>FOiOcUW>GliIoUo>@02Kg/01gliIcUonFLiOcUWnGli009_N`03OcUW
nGli00=_N`07Oc9_NfOiOcU_NgliIoT00Wli00AWnGliIcUg_@9_N`04OcU_
NfmkOcT3Kg/027liIcUo>FmkOc9_NfOiOcT2Kg/01GoiIcUo>FOiOcT016mk
00Eo>FLiOoU244YB01aoo`07<H`004/i001oofLb00001goo04aon@050:DE
VC6<0:D003<o5:a;oaFIKg/aVAIIBcmVGc<iBI9W?fOo5I9;?c9IBUl087oo
0000[4/i000c?c9I:DX0[1F<<U80YAF<OolYBPaS5H`01AII<;80036I5:DD
/P2/5:`aTP6I000FGaB/5IT1S1@05Ul<Hc6O<IT1S0@00I8G?`03<Ul0[300
0H`1Wc2b0:D0/P8ES003MkdETVLo01aoo`9;?`03Oomg_ALo009oo`055UmW
ogoo@Q1W>@02F]H05FLiIc848E[FMkeo>FOiOcUW>GliIoU_NgoiIcU_Ngli
IcUWnGliIoUo>@01IoT0000IIoUo>FLiOoUW>GoiIcUo>GoiIcUonFLiOcU_
NgliIoUo>FLiOoU_NgliKg]o>FmkIoT00Wli021W>GliKg]o>FOiIcUonGli
Kg]o>FOiOcU_NgliIcUonFLiOcUWnGliKg]W>GoiIcUonFLiOcUW>FOiOcUW
nGli0Vmk00Mo<VmkKg]o>FOiOcUWn@02OcT01fOiOc9_NfmkOcUWnGlb009_
N`05OcU_NgliIoUo>@02Kg/01gliIcUonFLiOcUWnGli009_N`03OcUWnGli
009_N`9o>@0DIoUg_GliIcUo>FOiOcUW>FOiOcUW>GoiIcU_NgliKg]WnGli
IcUWn@9o>@03IoUo>FOi00=_N`0BOcUWnFLiOoUW>GliKg]o>FOiKg]o>Fmk
OcUWnGliOom244YB77oo00LaTTYB<UT007ooIUT0Y@06Ool01Fmk<UT00`00
06000P2/01XETP2/5H``[0005UT0006<000bF@0P5I800DYI0000[0005Ul0
0`6IIol01FLoBcT01B480P0002X<Hc9B00D0YCW>@Q0ETQBb0H`0[02U0:`D
/QFI020D[1FB00<bGaB/0:D0[1IO0:`0YA@50UlES32b5I8EV@1P00X0Y@2/
0004002/0619W`2U0043Ool00aIB<Haoo`0KOol01C<oBcmoofOo5Ul00Woo
00@3?gooOom:DP9JeP0FDYAW>E[F125JeWliIoUo>FmkOcUWnGliIcUo>FOi
OcUW>GoiOcUWnGliIcT1OcT0000GOcUWnGliKg]o>FLiOcUWnFmkOcUW>Goi
IcUo>FOiOcU_NgliIcUonE[FOoUW>@02OcT05fOiIcUonFLiOcUWnGliKg]W
>GNmKg]W>GliIoUo>FOiOcUW>GoiIcUo>FOiOcT00Vmk00Ao>FmkOcUWn@9o
>@04Kg]o>FOiOcT3Kg/01glbIoUo>FLiOcUWnGli009_N`03OcU_Nfmk009_
N`06OcUWnFLiOcUWnGli0Vmk00Io>FOiKg]o>FOiOcT2Kg/04FLbOoUW>Gli
IoUo>FmkIoU_NgliIc9_NgoiIcUo>FOiOcT00Vmk0Wli021WnGliIoUo>FLi
OoU_NgliKg]WnGliKg]o>FmkOoUW>GliKg]o>FLiOoUW>GoiIcUo>FmkIoUo
>FOiOcUWnGli0TYB7goo00A_NgooIol020Aoo`060:`00@05BcUoofOo0P00
00<FFAB/0:`00P2U01E:G`2iOolD[1FB0:`D[39I0042FFLo5HaW?`6BOol0
039B5UT0039I<U800P0002/0[02U0:D01FI<00<01D_o0:D02P2U0:`aTP2/
020aVAB/5;80Y@030UlD[02UB:D`^C6I0:001@`0OUl021IO0:EW?`2U<I8b
F@00<IT0836IB;808003Ool00dVB5Haoo`0KOol01D/oBomoogNm5cl00Woo
00D2GgooMke:DVLi009JeP06IcUJeP@QF]IonGli0Vmk00eWnGliIoUo>FLi
OcUWnGliIcU_NgliIoUo>@01Kg/0000_IoU_NfmkOcUWnGliIoU_NgliIcUo
nFLiOoUW>GliIoUo>FOiOcU_NfOiOcU_NgliIoUW>GoiIcUo>FOiOcUW>Gli
IoUo<VmkOoU_NgliIoUo>FLiOoUW>GliIoUo>@02Kg/017liIoUo>FOi0Wli
00QWnFLiKg]o>FOiOc9_Ngli0Vmk00eo>FOiKg]o>FOiKg]o>FOiKg]o>Fmk
OcUWn@02OcT036OiOcU_NfmkOcUWnFmkOcUW>GliIoUo<P=_N`03OcUWnGli
00=_N`08Oc9_NfmkOoUW>GliIomo<P9_N`0IOcUWnFLiOcUWlWliIcUonFmk
OcUW>FOiOcU_NgliIcUonFLiOcUWnGliIcUonFLiOcT00Vmk00Yo>FOiOcUW
>GliKg]o>FmkBU92425oo`0800=;>Goo<U800`00<UUg_@Eoo`80000b5UT1
S06I5H`01@00<U80YFOo0:`c?`2/Ool01GNm000G>@0000=oo`0:<U9Wo`@0
5U8c?`000:DicP2/BTa;>C9BOol004YI0H`0/TRb0I80Y@0P0;81TP1P<Il0
H32b0Ha8/P80[00CBITD1ALo0200[065IIlD[1II<IlbFC6B0001TQFI36<a
V@2/00<00Woo00<bDQF<Ool06goo00Dc?d/oMkeooaIO009oo`040Umoogoo
BU83F]H016LiF]H<HfIB0Vmk00mWnGliOcU_NgliIoUo>FOiOcU_NfOiOc9_
NgliIoT00Gli00002GliIcUonFLiOcU_NgliIoUo>@02Kg/02GliIcUonFLi
Kg]W>GliIoUo>@02Kg/00gliIoUo>@02Kg/01gliIoUo>FOiOcUWnGli009_
N`04Ic9g_FmkOcT3Kg/01GliIoUo>FLiOoT00VLi00io>FOiOcUW>FOiOcUo
nFLiKg]o>FOiOcUWnGli0Vmk00Ao>FOiIcUo>@9_N`0:Oc9WnFmkOcUWnGli
IcUWnGliIoT2OcT016OiOcUW>Goi16mk0Wli00IWnGliKg]W>GoiOcT2Kg/0
1WliKg]_NgliIoUo<P9_N`05OcUWnGliIoUo>@02Kg/01GliIcUo>FOiOcT0
0Vmk01QW>GoiKg]W>GliIoUo>FOiOcUW>GoiIcUo>FmkIoUo>FOiOcUWnGli
Kg]onC9BBU8QOol010001240[1B/2Woo0200Y@005IT081FB<cTFF@2i0:`4
01F<00D<H`6<1000[3<o5:Eoo`2/<I8c>AB/000bDPaS000D[001BU80039B
0P0002HbFFOo000D[1FI0I801@005;80YC6O0:D<01Bi0H`004VO0:`0YABU
5IT1VC6I5I8D1@0P0:`0Y@9I1000Y@6I001UW`1P0H``/P080Woo00=W>@2/
Ool06goo0T/o00=oogoi0cl00Woo00@G?gNmOom240=JeP09IcUJePaSDYAo
nGliIcUWnGli009_N`05OcUW>GliIoUo>@02Kg/00gliIoUo>@01IoT00005
IcUonFLiOcUWn@02Kg/01WliIcU_NgliIoUo>@9_N`04OcUonFmkOcT2Kg/0
3gliIoUW>GliIcUonFLiOcU_NgliMkeW<WliIoUo>@02Kg/017liIoUW>Goi
0Vmk00Io>FLiOoUW>GliOoT2Kg/01gliIoUo>GliIcUWnGli00=_N`03OcUW
nGli009_N`05Oc9_NgliIoUo>@02Kg/08GliIoUW>GliIoUo>FmkOcUW>FOi
OcUWnGliIcUonFLiOcU_NgliIoUo>FmkIcUonGliKg]W>GoiIcU_NgliIoUo
>@02Kg/057liIoUo>FLiOcUWnFmkOcUWnGliIoUo>FOiOcUW>GoiIcUo>FOi
OcT2Kg/03gliIoUo>FmkOcUWnFmkOcUW>GliKg]o>FOiOcU_N`02BU8NOol0
1@01Kg]oodYI02003Goo04LicP000ITaV@000;80YC9I5I9W?`2/BolD[7oo
0:DbFAFB020bF@2U0:`aTP6<0:D0[008<c848@2/0:0Q206<BU848@2b5UT0
80010:D081B/0IT0[01P5IT0[1F<5;80Y@650IUmW`aS0:`48FBb0I9;?`2/
OolD[0000Ul084Ri0H`D[1FO1001TP05009oo`03IcT0[7oo01]oo`05<om;
?gooIolFG`02Ool01`9OOomonDYBIcUJeU:D009W>@0=125W<WNmIcUonGli
IoUW>GliIoUo>FOiOcT00Vmk00Ao>FOiKg]W>@5o>@0000Uo>FmkOcUWnGli
IcUonFLiOoT00Vmk015o>FOiOcUWnFLiOcUWlVmkOcUWnGliKg]onFLiOoUW
>Goi00=_N`0>OcU_NfmkOcU_NgliIoUo>FmkOcUW>GliIoUo>@9_N`0=OcUW
nFLiOcUWnGliKg]WnGliKg]o>FOiOcT00Vmk00AW>GliIoUo>@9_N`0?OcUW
nGliIoUo>FmkOcU_NgliIoUo>FLiOoUW>Gli009_N`08OcU_NgoiIcUo>FOi
OcUWn@9_N`0DOcUWnFLiOcUWnGliIcUonFLiKg]o>FOiOcU_NfOiOcU_Ngoi
IcUo>@9_N`0HOc9WnGliIcUo>FOiOcUW>GoiIcUo>FOiOcU_NfLiOcUWnGli
Kg]o>FOiKg]o>FOi0Vmk00Eo>FOiOcU:DT8@01ioo`0300=_Ngoo009oo`03
005BU7oo00]oo`0E>Lh0002U<UlES06<000ETP2/5I80YBU:00Dcoa@0BUl0
[248BclbDRU:008bF@03001;>@010080000POolETTYIBU9Woc9<0:`EVABU
00D0/P6<0:`00@2/0:D1V@005I81W`000:D`^AFB5IT0Y@6B000FF@050:`0
0080[0095:`0/S6O020ETS2b36<0^@6<009oo`03001JeWoo01Yoo`9;?`03
Oomg_ALo009oo`045UmWogooBU83F]H046LiIU80YFIBMkeo>FmkIcUo>Goi
IcUo>FmkOcUWnGli0Vmk00=o>FmkOoT00FLi00001VOiOcUWnGliIcUon@9_
N`06OcUWnGlbKg]o>FOi0Wli0Vmk00Qo>FmkOcUWnGliIcUonFLi0Wli01=W
nGliOcUWnFmkOcUWnGliIoUo>FLiOcUWnGliIoUo>FOiKg]o>@02Kg/03Wli
Kg]o>FObKg]o>FLiOoUW>GliIoUo>FLiOoT2Kg/0:WliIoUo>FOiOcUW>Fmk
OcUWnFmkOcUWnGliIcUonFmkOcUWnGliKg]o>FOiIcUo>FOiOcUWnGliIcUo
>FOiOcUg_FLiOcUWnGliIcUonGliIoUo>@9_N`08OcUW>GoiIcUo>FmkIoUo
>@=_N`05OcUWnGliIoUo>@03Kg/04WliIoUo>FOiOcU_NfLiOoUW>FmkOcUW
nGliIcUo>FOiOcUg_@9:DQioo`03Icmoogoo009oo`03Kg/00c9B00aoo`16
BH`0002U<:`D/P6B8@PD/T/i50Dco`055:E;?`00IolaTP005:`ETP2U0040
07oi001Wo`2/DY@00@@000D006Oo5H`0006I5IT0Y@2/0200Y@aS0;8EV@2/
0019WaFB0:DD[003<UTEWaFBOcl004Y<<I8002485;8ETP0P5H`D/P2U<UlD
[0030:`2Ool00`00BU9oo`0JOol01C<oBcmoogNm5Ul00Woo00@3?gooOom:
DP=JeP9W>@0C125VFGoiKg]W>GoiIcU_NgliIoUo>FOiOcU_NfOiOcUW>Goi
IcT00Gli00002WliIoUo>FmkOcUW>GliIoUW>Gli0Vmk00io>FLiKg]WnGli
Kg]WnGliIcUo>FOiOcUW>Goi0VLi00io>FOiIcUo>FmkIcUo>FOiOcUW>Goi
IcUo>FOi0Wli00]W>GoiIcUo>FmkIoUo>FLiOcUWnGli009_N`0:OcUWnGli
IoUo>FLiOcUWnFLiOcT2Kg/04GliIoUo<VmkOcU_NfOiOcUWnGliIcUo>FOi
OcUW>GoiIcT00Wli015WnGliKg]o>FOiOcUWnGliIcUo>FOiOcU_NgliIoUW
>Gli009_N`03OcUWnGli009_N`0ROcUWnGliOcUWnGliKg]o>FOiOcU_Ngli
IoUo>FmkOcUWnGliKg]o>FOiOcU_NgliIoUo>FmkOcUWnGliKg]o>FOiOcT2
BU8UOol00`2/001oo`0;Ool0348@0001TQII0002F@@00H`EV@@0Ool0[09;
?`0=000bFD_oDY@c>FLo000<H`2/>LhES00100000QF<01Y:C5:D001;?aF<
0040002U0040/P0P0;8`/P1P5IT0[02U0;99VC2/0:DD[06B00<080050Woo
00`0002b5I80224800DETP0:<:a8^@2U0002Ool00`00DYAoo`0JOol2Bcl0
0gooIolG?`02Ool0709OOomood8@IcUJeU:DIcUJeP@QIc9g_GliIoUo>Goi
IcU_NgliIoUo>FOiOcUW>GliIoU_Ngli0FOi000046mkMkeW>GliIoUo>FOi
OcU_NgliIoUo>FOiOcUWlWli0Vmk00Ao>FmkIoUo>@9_N`0:OcU_NfmkOoUW
>GliOoU_NfLiOoT2Kg/046LiOoUW>GoiIcUo>FmkIoUo>FmkIoUo>FOiOcUW
>Goi16mk03ao>FOiOcUW>GliIoUo>FOiOcU_NgliIoUo>FOiOcU_NgNmIcUW
nGliIcUo>FmkOcUWnFLiOcUWnGliIoUo>FOiKg]o>FOiIcUo>FLiOcUWnGli
IoUo>FOiOcUWnFLiOcU_NfOiOcUWnGliIoUW>GliIoUo>FmkIcT2Kg/07Wli
IoUW>GliKg]WnGliIoUo>FOiOcUWnGliIcUo>FOiOcUWnGliIoUo>FOiOcUW
nGliIoUo>FmkBU9242Ioo`03Kg/007oo00]oo`0e@Q00002U<IT0[1IO000a
S09B0:aW?`005:aoo`2U00001@0P001_NaIB>Lh0000:Ic8D[39B>Lio>@6<
OolD002/5I80[02U0200[1Bb0HD0YABi0:0`/QFB36<401B/0cl084/o0:D<
0003Ool044/i00<1TQBU00X2DP@05IT0H06B<IT401F<Ool005[F6goo00E;
oc<oOomg_AIO009oo`045UmoogNmBU83F]H04VLiF]H<He:DOcUWnGliKg]W
>GoiIc9_NgliIcUo>FmkOcUWn@9o>@5Wn@5o>@0000eo>FLiOoUW>GliIoUo
>FLiOoUW>GliIoUo>@03Kg/00gliIoUW>@02OcT08VOiKg]o>FOiOcU_Ngli
IoUW>GliKg]onFLiOcUonFLiKg]o>FLiOoUW>GliIcUonFLbOcUWnGliIcUo
nFLiOcU_Ngli0Vmk00eo>FOiOcU_NgliIcUo>FOiOcU_NgliIoUo>@02Kg/0
47lbKg]o>FOiOcUWnGliKg]o>GoiKg]o>FmkOcU_Ngli0Vmk00io>GoiKg]o
>FmkOcU_NgliKg]o>FmkOcUonFmk0Wli011_NgliKg]o>GoiKg]o>FmkOcUo
nFmkOcU_NgliOoUW>@9o>@0HKg]o>FmkOcU_NgliKg]onFmkOcU_NgliKg]o
>FmkOcU_NgliKg]o>FmkOoU244YB9goo00=_N`00BcT02goo02Y:F@000H`D
1AII5I8FF@005I8007oo5I8007Nm<cmood_oBU8ES003001Wo`2UBcTaS02U
5I8004YB5:a;o`0800D0000P0I80[1FI00P0[1BU5;820:`01c9O5:`00@6I
5I801@0000Eoo`80200=0H`081Bb0:DEVAB/0001TP2i<Taoo`00>Lh06goo
0T/o00=oogNm5cl00Woo00@3?gNmOom:DP=JeP0EIcUBU0aSIc9_NgliKg]o
<VmkMkeo>FOiKg]o>FOiOcUWnGliIoUW>Gli005Wn@0000Q_NgoiIcUonFLi
OcUWnGli0fmk00Yo>FmkKg]_NgliIoUo>FmkOcUWn@9o>@03IoUW>Gli009_
N`0@IcUonFLiOoUW>GliMkeW>FmkOcUWnGliKg]o>FOiOcT3Kg/067liIoUo
>FmkOcUWnGliKg]WnGliIoUo>FmkOcUWnGliIoUo>FOiKg]o>FLiIoUo<P9_
N`07OoUW>GliIoUo>GNmOol00WNm041onGNmOoUg_GoiMkeonGooOoUg_Goi
OomonGooOoUg_GoiMkeonGooMkeonGooMkeonGNmOoUoogNmOoUg_GoiOomg
_GoiMkeonGooMkeonGooMkeonGNmOoUg_GoiMkeonGNmOoUg_GoiMkeonGNm
OoUg_GoiMkeonGNmOoUoo`9:DRUoo`030:`Q27oo00Yoo`03>Lh0039O0080
Y@095;92406<<UT004YBIol00@2U00<01@0?00<bDS9BOc800B485:D00`2U
<T`D[000<I8aS1FB00<0000?0:D0202U5:``/P2U5;84009I<;83?`00Iol0
039B00Eoo`0?Kg/0000P<;80[36O124aW`2U020`_aIBMkd404YI01]oo`05
<cm;?gooIolFG`02Ool01`9OOomood8@IcUJeU:D009W>@08125BU7oiOcUW
nFmkMkeW<P9_N`05OcUWnGliIcUo>@02Kg/1OcT1Kg/1OcT00009OcUW>Fmk
Kg]onFLiOcUWnGli009_N`0RIoUo>FmkOcUWnGliIcUonFLiKg]WnGliKg]o
>FOiOcUW>GoiKg]o>FLiOoUW>GliIoUo>FmkOcUWnGliKg]o>FOiOcT3Kg/0
5GliIoUo>FmkOcUWnGliIcUonFLiOcUWnFLiOcU_NgliIoUo>FmkIoUo>@02
Kg/01GliIcUo>FOiOcT00Vmk00=9S1F5>Lh0236<00=9S36<<H`01C6<00<i
cS6<<H`04C6<00<icS6<<H`00c6<00<icS6<<H`01S6<00<icS6<<H`01C6<
00<icS6<<H`00c6<00=BU48@Ool0:Goo00<D[02UOol02Woo0P0000l0[1F<
0:Eg_@05DYAWo`03124c>C9OBU9;>C9I<c800S6<00X0Y@aS8@P1S5:DBcT0
[4/b>Lh<H`9oo`0A5:D000010H`0002U0:`D^@6<0:D1V@030:DD[39I000a
S007Ool03QF<1001W`1PB;T0H02U<Ul084Rb0ITEQ@00<U8KOol01D/oBomo
ogNm5cl00Woo00@FGgooOoU:DP=JeP0EIcUBU0aSDYAg_FmkOcU_NgliKg]o
nFLiOcU_NfOiOcUWnGlbKg]WnGli005Wn@0002U_NgliIoUo>FLiOcUWnGli
IcUonFLiOcUW>GoiIcUo>FOiOcUW>GoiIcUo>FmkOcUWnGliIcUonFLiOcUW
>GoiIcUo>FOiOcUW>GoiIcUo>FOi009_N`09OcUWnGliKg]o>FOiOcUW>GNm
009W>@0;OoUo>FmkOcUWnFLiOcU_NgoiIcUo>@02Kg/03GliKg]_NgliIoUo
>FOiOcUWnGliKg]W>D8@00U:DP03@Q1JeT8@00E:DP05@Q1:DTYBBU92400?
BU800d8@BU9:DP03BU800d8@BU9:DP06BU800d8@BU9:DP05BU800d8@BU9:
DP03BU800e:DBU9oo`0ZOol00dYB00=oo`0:Ool02P010004039O00DES00P
001oo`2/0P0500lbC4/i000D[0010:`024/bBU8027oi101JeP055H`00goo
011W?`000200[02b0:DEV@2U<;T1S00:5H`c?`2U5:`000Qoo`0?IcT00`2U
5IT0039O1000[39O020D[000F]H1TVmk01Yoo`05<cm;?gNmOolFG`02Ool0
10<oIomoodYB0e[F015W>E[F36=VDWoiOcUW>GoiIcUg_FLiOcUWnFmkOcU_
Ngli009_N`5o>@5Wn@5o>@0001i_NfOiOcUWnGliKg]o>FOiOcUW>GoiIcUo
nFLiOoUW>GliKg]onFLiOoUW>GliIoUo>FOiOcUW>GoiIcT2Kg/027liIoUo
>FOiOcUW>GoiIcT2OcT046OiKg]o>FOiOcUWnGliKg]onFLiOoUo>FLiKg]o
>FOi0Wli00iWnGliIcUonFLiOcUWnFmkOcU_NfOiOcU_Ngli0fmk00AonGNm
IcUJePQ_N`05@Q1oofmkKg]W>@09Kg/00fLiKg]_N`02Kg/01FLiKg]_Nfmk
IcT01Vmk00=W>FmkKg/00fmk00=W>FmkKg/00Vmk00=W>FmkKg/016mk00=W
>FmkKg/00fmk00=W>FmkKg/00TYB;7oo00=JeP00Kg/02Woo01X0002/5I8a
TP2bBcmWn@00MkeoofOo<I80202/:DXc>C9B36=o>@01Oc9BU06<<H`004/i
17oo00licP000201TP2/00D1Q@00BIlETQ@55:Dc?`00Mkd02Goo00hETP00
0:DD/P1PBIl<01FI5;80Y@00IcTETVmk6Woo0T/o00=oogNm0cl00Woo01@F
GgooOom246LiF]IBU6LiF]H<He:DMkeWnGliIcUonFLiOcUWnGli0Vmk00=W
nGliKg/00Vmk0Gli0Fmk0002OcT0:6OiOcU_NgNmIcUo>FOiOcU_NgNmIcUo
>FmkOcUWnGNmIcUo>FmkOcUWnGliIcUo>FOiOcUW>GoiKg]o>FOiOcUW>Gli
IoUo>FLiOoUW>FOi0Wli0Vmk01AW>GliIcUonFLiOcUW>FmkIoUo>FOiOcU_
NfOiOcUW>GoiIcUo>FOi0Wli00=WnFmkOc800fmk00=WnGlbKg/00WNm00=:
DWooOol00gNm00=oogNmMkd00Woo0gNm00YoogNmMkeg_GooMkeoogNmOomg
_@9oo`07MkeoogNmOomg_GooMkd00Woo00Eg_GooMkeoogNm009oo`9g_@04
Oomg_GooMkd2Ool01WNmOomg_GooMkeoo`9g_@9oo`04MkeoogNmMkd3Ool0
0dYB@Q1oo`0]Ool00`05BU9oo`09Ool02P030001TQII000ETWoo36<0039B
0T/i00Uo>C9B<H`bDS6<OoT0002/0:D00P0300<bDWooOol00goo00hicP00
0I8000050H`D/QFB0:D006Lo0I800aBU2Woo00i;>@000;8D[02U0:`EV@00
0:EmW`00F]HES6Li6Woo00E;oc<oOomg_ALo009oo`040UmoogooBU83F]H2
IcT04P@QDYAonGliIcUonFLiOcUWnGliIcUonFLiOcUWnGliKg]o>@9_N`00
03QWnGliOcUW>GoiIcUonFLiOcUWnGliIcUonFLiOcUWnGliIcUonFLiOcUW
nGliIoUo>FmkOcUWnGliIcUo>FOiOcUWnGliKg]o>FOiOcUW>GoiIcUWnFmk
Oc9WnGliIoUo>FLiOoU_NgoiIcUo>FOi0Vmk00]o>FLiOoUW>FmkOcUWnGli
IcU_Ngli009_N`03OcU_Nglb009_N`09OcU_NgNmIcU240@05:D48@0000<4
8@03000<H`@Q008<H`04124<H`@Q36<2124010@01244000P0P@000T48@01
124400@Q100080@000400P@Q00@4000P100400848@0510048@@Q00448@02
10001P@Q00448@@0124400848@0;00048@@012400@@Q00048@00F]I:DP0_
Ool00`01<Haoo`08Ool066Oo0000002UIcl0006<Oom;>@081240[39B101W
>@0836<00cW>BcT0YDYB021240Ioo`0=00<0806B060D332i0:0D/P9I300b
G`00Mkd02goo00d0002/0:DaW`aS00E:GaBb00000FOoMkd0[00JOol2Bcl0
0gooMkdFG`02Ool011LoIomg_DYB0e[F01EW>E:D36=BU7NmKg]o>FLiOoUW
>GliIoUo>FLiOoUW>GliIoUo>FOiOcT00FOi0000:7liIoUW>GoiIcUo>Fmk
OcUWnGliIoUo>FLiOcUWnGliIcUonFLiOcUWnFmkOcU_NgliIoU_NgliKg]o
>FOiOcUW>GliIcUonFLiOcUWnGli0Vmk0Wli011_NgliIoUo>FLiOoUW>Gli
IcUo>FOiOcUW>GliIoUo>@9_N`0;OcUWnGliIoUo>FOiOcUWnGliIoUo>@02
Kg/02WliIoUo>GNmIcU:DRU:>LioogNm0goo00=W>GNmOol01gNm0Woo0WNm
00MoogNmOomg_GooMkeoo`02Mkd00gooMkeoo`03Mkd00gooMkeoo`02Mkd0
17ooMkeg_Goo0WNm00MoogNmOomg_GooMkeoo`02Mkd02gooMkeoogNmOomg
_GooMkeoodYB@Q00<7oo00<ES008Iol027oo01AJeP000:`407oo5UT404/i
OomWoc9I00D0Y@0:<HEoo`0P<U8YBS6B0P2U00=W?gooOol017oo00`aS000
0;T00`6B0:DD/P2U5IT2FABP00<<Ool03Fmk0001V@aS<Il0Y@9B5;8087oo
>LhETTYI01Yoo`05<cm;?gooIolG?`02Ool01@9OOomood8@IcT00U[F01EW
>E[F36=VDWoiOcUWnGliIcUonFmkOcUWnGliIcUo>FOiOcUWnGliIcT00Gli
00008FmkOcUo>FLiOoUW>GoiIcUo>FmkOcUWnGliIoUo>FOiOcUW>GliIoUo
>FLbIoUo>FLiOcUWnFmkOcUWnGliKg]on@03Kg/027liIoUo>FmkOcUWnFLi
OoT2Kg/03gliKg]o>FLiOoUW>GoiIcUo>FOiOcUg_GlbIoUo>@02Kg/06gli
IcUo>FOiOcUW>GliKg]o>FOiOcU_NfOiOcUWnGNmF]IBU36<001244YB:DX0
02U:Kg/0000736<00`@Q5:DicP0^<H`00e:DBU9oo`0`Ool00c6<00Q_N`08
Ool05FLo0002G`@00:E:DP038@PFDVOoBcmW<P9B<U8aTQF<:DY:DS9B5:`E
S008Ool02`000200002U36<D[1Bb020FG`00BU803Goo00M:C0050:`0YC6O
00D00002Ool00fLo004bF@0JOol2Bcl00gooMkdFG`02Ool011LoMkeoodY<
0e[F00mW>E[F36=BU7NmKg]o>FOiOcUW>GNmKg]o>FOiOcT00Vmk00AW<WNm
Kg]o>@5Wn@0001Ao>FOiIcUonFLiOcUW>FmkOcUWnFmkOcUWnGliIcUo>FLi
OcUWnGli0Vmk00=o>FOiOcT00Vmk00]o>FOiOcUW>GoiIc9o>FmkOcUWnGli
009_N`0UIoUo>GNmIc9_NgliIcUonFLiOoUW>GoiIcUo>FmkOcU_NfLbKg]o
>FOiKg]o>FOiOcUWnGliIcUonFLiOoUW>FmkIcUonFLiOcT00WNm00=JeU:D
<H`00QBU00H001BU8@P407oo:DX5>Lh01C6<BU8aS0@Q<H`00RU:00<Q22U:
8@P00RU:00DQ22U::DXYBR4800DYBP038@PYBRU:008YBP048@PYBRU:8@P2
:DX01248:DXYBR480RU:00HQ22U::DXQ22U:8@P4:DX28@P00e:DBU9oo`0a
Ool00gNm00124008Ool04@2/000FFAFBBclc?e:D00<00C6<BcTaTQB/Oc8E
TT/b5H`00P0000<aTWooOol01Woo00/bF@030000Y@6O100EV@2/0:D00e[F
00ioo`06DY@4002/5I8007Nm0goo00<ES000Ool067oo00Ig_C?oBcmoogNm
5cl2Ool0109OIomoodYB0e[F00iW>E[F125BU7oiOcUWnGliIcUonFLiOcUW
nGli0Vmk00Eo>FmkKg]o>FOi005o>@0000Y_NgliKg]_NgoiIcUonFmkIcUo
>@9_N`09OcUWnGliIoUo>FOiOcUWnGli009_N`08OcUWnGliIoUo>FmkIcUg
_@9_N`0:IcUonFLiOcUWnGliIcUo>FOiOcT2Kg/00gliIoUo>@02Kg/01gli
IcUonFLiMkeW>Goi00=_N`0<Oc9_NfOiOcU_NgliIoUo>FLiOoUW>Goi0fmk
011o>FOiOcUg_FLiDY@YBP@QOomJeT8@8@P<Hgoo8@Q240<icP08@Q0icTYB
:DXDYD8@:DXicR`aS003DYA:DWoo03=oo`030:DETWoo00Moo`0C0040036B
000c>D/oMkdc>AB/0000802U1240000300PES00PIol02Goo0P0000P1V@2U
0:`1S7oo0:`004_o3goo00UBU00500<c>Goo00D0Y@00<I806goo0T/o00=o
ofOo5Ul00Woo01PFGgooOom246LiF]IBU6LiIc848E[FMke_NgliIoUo>FLi
OoUW>GliIoUo>FmkIoT2OcT1IoT1OcT1Kg/0000DOcU_NfOiOcUW>GoiIcUo
>FOiOcUWnGlbKg]o>FOiOcU_NgliKg]o>@9_N`09OcUWnGliIoUo>FLiOcUW
nGlb009_N`09OoUW>GliIoUo>FmkOcUWnGli009_N`0DOcUWnGliIcU_Ngli
IoUo>FLiOoUW>GoiIcUo>FmkOcUW>GoiIcUo>@9_N`0IOcUWnGliKg]o>Fmk
Oc9g_GliIoUo>GNmKg]W>DYB<H`<Hc6<F]Iood8@001ooc6<>Lh0148@00Li
cTYB>Lh<Hd8@>LhaS00<>Lh00c6<>LhicP03>Lh00c6<>LhicP0B>Lh01c6<
BT`aS3W><HaJeT8@03Eoo`035:D00Goo00Moo`0A00401D/o0040/S9BIolb
FD/o5I9oo`2U5UUo?aF5<H`0200:Ool02@2/0000YABU0IT0[1FB000`Y@0A
Ool01S9B004D[000IcUW?aeoo`05Bclc?gooMkdG?`02Ool010<oOomoodYB
0e[F00eW>E[F36=BU7liOoUW>GliIoUo>FLiOcUWn@02OcT01VOiOcU_NfOi
OcUWn@5o>@0001iWnGliOcUWnGliIcUonFLiOcUWnGliKg]WnGliKg]W>Goi
IcUo>FOiOcUWnFmkOcUW>GliIoUo>FOiOcT2Kg/01glbKg]o>FOiOcUW>FOi
009o>@07IcUonFLiOoU_NfLiOoT00Vmk00Uo>FOiOcU_NgliIcUonFLiOoT0
0fmk01ao>FOiOcU_NfLiOcUWnGliIoUo>FmkIc9_NgliIoUo>GNmIcUBU36<
000aS0aS125_Nc6<F]I_N`MW>@04Oom241BU<H`Y:DX01QB/<H`YBRU:DYA:
DSIoo`03BcT00FLi00Ioo`0AMkd00000<olYBP01<I8c>C9BBT`bFAB/BHDb
C02/5:DbDP0;Ool200001QFI101W?aIB000aTP]oo`07MkeJeT/i00P0Y@00
BUT08Woo0T/o00=oogNm5Ul00Woo00DFGfOoOom246Li009JeP0EIcUJeP@Q
Ic9g_FmkOcU_NgliIoUo>FmkOcUWnFLiOcU_NgliIcUo>Fmk005Wn@0000Yo
>FmkIoUo>FLiOoUW>GliIoUo>@9_N`0?OcU_NfmkOoUW>GliIoU_NgliKg]o
>FLiOcUWnGli009_N`03OcUWnGli00E_N`9o>@0:IoUW>GoiIcUo>FmkIcUo
nFLiOcT2Kg/06WliIoUo>FLiOoUW>GNmIcUo>FmkOcUWnGliIcU_NgoiIcUo
>FOiOcUW>FmkOcUWnGliKg/2Mkd02FLiBU8aS36<000DY@@Q00048@0:0000
3@@Q36<48@aS124<H`@Q36<48@aS124<H`@Q008<H`04124<H`aS124236<0
10@Q36<<H`@Q0PaS01848@aS124<H`@Q36<48@aS124<H`@Q36<48@aS1240
0ABU5:0212400`00F]I:DP0gOol00fLo001;>@07Ool01P03001oogoo0:D0
1@80[006OoT0[7oo5I8icP0137oo00LES0030:D1S0005H`00008Ool01fmk
IcTaTQF<0:`0202U02Ioo`05<om;?gooMkdG?`02Ool0109OOomoodYB15[F
01AW>@@QF]I_NgliIoUo>FOiOcUWnGliKg]W>GoiIcUo>FOiOcUWnGlb0Fmk
00003VmkOcU_NfmkOcUW>GoiIcUo>FmkOcUWnFLiOcT2Kg/067liIoUo>FLb
IoUo>FmkOcUWnGliIoUo>FmkIcUo>FOiOcU_NgoiIcUo>FOiKg]o>@9_N`0N
OoUW>GNmOcUW>GoiIcUo>FOiIcUo>FOiOcUW>GoiIcUonFLiOcUWnGliIcUo
nFLiOcUWnGliKg]W>Goi0Vmk00eo>FOiOcU_NgNmF]IBU1BUBU9_NdYBDYAJ
eP0dDY@015[FOomW>FLi0e:D0TYB>Goo00<01@2/Ool01Woo0P0000/aTVOo
IolDY@2b8@P0039I300DY@2/00aoo`07Mkd401Bb5IUWo`2/00<01Goo00<b
FCW>00D00P2/00<bDS6<Ool0:7oo0T/o00=oofOo5Ul00Woo00@G?fOoMke:
DP=JeP0=IcUBU0aSIU9onFmkOcUWnGliIcUo>FOiOcT00Vmk00Ao>FOiOcUg
_@9_N`5o>@0000Qo>FmkKg]olVLiOoUW>Gli0Vmk00QWnGliKg]onFLiOcUW
nGli0Vmk00Mo>FOiOcUWnGliKg]o>@02Kg/03WoiIcUo>FOiOcUW>GliIoUo
>FLiOcUWnGliIcT2OcT036OiOcUW>GoiIcUo>GoiIcUo>FmkOoUW>@9o>@09
IoU_NgliKg]onFLiOcUWnGli009_N`07OoUW<VmkOcUWnGliIcT00WNm00AW
>E:D:DX003Uoo`030:D0036B00=oo`03BU9247oo03Uoo`035H`00goo00Io
o`0<0000802/Bolc?goo005onC2U0040039B3Goo00E;>@0000P0X000009o
o`08IcTbDP010001S36BDYAg_Baoo`05Bclc?gooMkdG?`02Ool01@9OOomo
od8@IcT00U[F00MW>E[F36=BU7oiOcUW>@02Kg/037liIoUo>FLiOoUo>FOi
OcU_NfLbKg]o>@5Wn@0001=WnGliKg]_NgliKg]o>FOiOcU_NgliIcUonFLi
OcUWnGliIoUo>@02Kg/017liIoUo>FOi0Vmk01Mo>FLiOcUWnFmkOcUWnGli
IoUo>FOiOcUWnGliIoUo>FOiIcUo>FOiOcUW>Goi009W>@0COoUW>GliIcUo
nFLiKg]o>FOiIcUo>FmkOoUW>GliIo9o>FmkOcT00Vmk00Yo>FmkOoUVDWoi
Kg]W>DYB:DX003Ioo`03<I80000000Ioo`03@Q1:DWoo03Yoo`03Bcl007oo
00Ioo`0:0;8ES000OolYBS<i<U8FFDYB100@Ool0206B<I9ooaFB0000[1FB
MkdaOol2Bcl2Ool01`9OOomooaLoMkeoodYB00=JeP07IcUJeP@QF]Ig_FLi
OoT00Vmk00ao>FmkIoUo>FLiKg]o>FOiOcU_NgliIoT1OcT00004OcU_Nfmk
OcT2Kg/03fOiOcUWnGliIcUonFLiOcUWnGliIcUo>FmkIoUo>@02Kg/01fLi
OcUW>GliIoUo>FOi009o>@0AIoUo>FLiOcU_NgliIoUo>FLiOcU_NfLiOoUW
>GliIoUo>@02Kg/027oiIcUo>FOiOcU_NfOiOc82Kg/01GliIoUo<VmkOcT0
0fmk00io>FOiKg]o>FOiKg]o>FLiKg]g_FLiDY@YBP00<goo00Ag_@2/000a
S0Qoo`03BU9247oo03aoo`03001Wogoo00Aoo`03DY@00FOo00800005IU8G
?giB0:D0[00>Ool014YI5UT400080S9B=Goo00Dcod/oOomg_ALo009oo`04
0UmWogoiBU83F]H01fLiF]H<HfIBMkeonFLi009o>@0<IoU_NgliIcUonFLb
OoUW>GliKg]WnGli0Fmk00004VOiOcU_NfOiOc9_NgliIcUo>FOiOcUW>Goi
IcUo>FOiOcU_N`9o>@0FIoUo>FmkOoUW>GoiIcUo>FOiOcUWnFLiOcUWnGli
IoUo>FmkOcUWnGliIoT2OcT01VLiOoUW>GliIoUo<P9_N`06OcUWnGliIoUo
>GNm0Vmk00=o<VOiOcT00Vmk00=WnGliKg/00Vmk00Mo>FmkKg]o>FOiMkeV
DP02Mkd015[FDY@YBP00<7oo00E_NfLi00000FLi00Yoo`03@Q1:DWoo03eo
o`03004ETWoo00Aoo`095H`004/o<U8<036B0H`Q239I00Uoo`07BUUJeP6<
0:`0006<@Q00>Goo0T/o00=oogNm5Ul00Woo00@FGgooOom:DP9JeP0?DYAW
>E[F36=BU7liKg]o>FOiIcUo>FOiOcUWnGli009_N`03OcUWnGli009_N`5o
>@0001eo>FmkKg]o>FmkOcUWnGliIoUo>FOiOcUW>GoiIcUo>FOiOcUW>FOi
OcUW>GoiIcUo>FLiOoUW>Gli009_N`06OcUWnGliKg]o>FOi0Vmk00Yo>Fmk
OcUWnFLiOoUW>GoiKg]o>@9_N`0;OcUWnGliIcUo>FmkIc9_NgliIoUo>@03
Kg/04WliIoUo>FLiOoU_NfLiOoUW>GliOoUBU7oiKg]W>E:D:DX002ioo`8E
S003020D[4/i00aoo`03BU9247oo03ioo`030:D0[7oo00=oo`09IcTaTP@0
<omoo`@Q0:`007Nm00Eoo`08F]HYBP6B0:`0YABU<UU_Ncaoo`9;?`03MkeW
oaLo009oo`050cmoogoo@Q1W>@02F]H03FLiF]H48E[FOoUW>GoiIcUonFmk
OcUW>Gli009_N`03OcUWnGlb009_N`5o>@5Wn@0000=_NgliIoT00fmk01Qo
<VmkKg]o>FLiOoU_NfLiOoU_NgliIoUo>FmkIcUonFLiOcUWnGliIcUonFLi
OcT2Kg/017liIoUo>FLi0Wli00EWnFLiOoUW>Gli009_N`05OcUW>FmkIoUo
>@02Kg/01GliIoUo>FOiOcT00Vmk01Qo>FmkKg]o>FOiOcUW>GliIoUo>FLi
OcUonFLiOcUWnGliIcU_NgNmIcU:DRU:000OOol00aBU00Eoo`09Ool01VOo
00<0039B<I9g_@ioo`03@Q1:DWoo03moo`0=<U8007ooOom;>@08OolETP00
0HaooaII5U800Woo00Q_Nd/i0040Y@2b>LiBU6Li@7oo00Dc?d_oOomg_AIO
009oo`045UmWogooBU83F]H04FLiF]H<HfIBMkeonFLiOcUW>GoiIcUonFLi
OcU_NfOiOcT00Vmk0Gli0Fmk0Gli00003gliIoUo>GliKg]o>FmkIoUo>FLi
OoUW>GliIoUo>@02Kg/09gliKg]_NgoiIcUo>FOiOcU_NgoiIcUo>FOiOcU_
NfOiOcU_NgoiIcUWnGliKg]o>FmkOcUWnGliIcUonFmkOcU_NfOiOcU_Ngli
IoUo>@02Kg/06GliIoU_NgliIoUo>FOiOcUWnGliKg]o>FOiIcUo>FOiOcU_
Ne[FOoU_NfLiDY@YBP0001moo`0300<007oo00Moo`05IcT00005F]IBU00A
Ool00dYB@Q1oo`11Ool01001Kg]oo`2/0Woo00LaTP000ITbFGoo0:D00002
0:`2IcU4Ool01D/o<cmoogNm5cl00Woo00@2GgooOom:DP=JeP06IcUJeP@Q
DYAonFLb0Vmk00QonFLiOoUW>GliKg]WnGli0Vmk00=o>FOiOcT00FOi0000
4fmkOcUWnFLiOcUWnGliKg]W>GoiIcUonFLiOcU_NglbIoUW>Gli009_N`03
OcUWnGli009_N`05OcUWnFmkOcUWn@02OcT2Kg/01VLbOoU_NfLiOoUW>@9_
N`06OcUWnGliIcUonFLi0Wli01YWnFmkKg]o>FLiOoUo>FLiOcUWnGliKg]o
>FLiMkeo>FOiOcU_NgliIoU_NgliKg]onFIB0WNm00AJeU:D:DX002Moo`03
5H`0002/01Eoo`03@Q1:DWoo049oo`0300DETS9B00=oo`05Mkd0002U0:a_
N`19Ool2Bcl00gooMkdFG`02Ool010<oOomg_DYB0e[F00UW>E[F36=BU7Nm
Kg]o>FmkOcT00Vmk00=o>FOiOcT00Vmk00Eo<VmkIoUo>FLi005o>@0000IW
>GoiIcUo>FOiOcT2Kg/00goiIcUo>@02Kg/03GliIoU_NgliKg]onFLiOcUW
nGliIoU_Nglb009_N`0COcU_NfmkOcUW>FOiOcU_NgliIcUonFLiOcUWnGli
IoUo>FmkOcT00Vmk00=o>FOiIcT00Wli015WnGliKg]_NfOiOcU_NfOiOcUW
>GoiIc9_NgliIoUo>FOi009o>@0:IoU_NgliBc9g_FmkIcUBU2U:000TOol0
1DYI000001F<Mkd05Goo00<aTU:DBU80A7oo00I:DP000:`01@2U5I9=Ool2
Bcl00gooIolG?`02Ool0509OOomood8@IcUJeU:DIcUJePaSIU9onGliIoUo
>FLiIoUo>FOiOcT2Kg/01WliKg]WnGliIcUon@5_N`0000MonFLiOcUWnGli
Kg]o>@02Kg/00gliIoUo>@02Kg/05GliKg]WnGliIcUonFLiOcU_NgliIcUg
_FmkOcUWnGliIcUonFmkOc9Wn@02Kg/077liIcUonFLiOcUW>GliIoUo>FOi
OcUWnGliKg]o>FOiKg]o>FOiOcUW>GliIoUo>FLiOcUWnGli0Vmk00Yo>FLi
Kg]o>FOiKg]o>GoiKg]VDP9g_@04F]IBU2U:000ROol014YB000bDTYB5Goo
00IW>C2/00000E[FBU95Ool00c9IKg]oo`1?Ool01D_oBcmoogNm5cl00Woo
00@FGgooOoU:DP=JeP04IcUBU0aSF]H2Kg/02gliIoUo>GliIcUo>FOiOcU_
NfOiOcT00Vmk0Gli0FLi0Goi00000fLiOcUWn@02OcT0>fOiKg]_NgliIoUo
>FLiIoUo>FmkIoUo<VmkOcU_NgliIoUo>FLiOoUW>GliIoUo>FLiOoUW>Gli
Kg]o>FmkOcUWnGliIcUonFLiOoU_NgliIoUo>FLiOcUW>GoiKg]W>GoiIcUo
>FmkOcUWnGliIcUo>FOiOcT00Vmk015o>FOiOcUWnGliIcUo>FmkIcUonFII
OoU_NfLiDY@YBP0001moo`05Iomoogoo00000@0DOol02E[F5H`0[0010:EW
o`2UF]I2402GOol01@9IBcmoogNm5Ul00Woo00@3?fOoOom:DP=JeP0EIcUJ
ePaSBU9onGliKg]o>FOiIcUonFLiOcUWnGlbKg]o>FmkOcUWnGli005_N`00
00Eo>FOiOcUWnFLi009o>@04IoUo>GliIoT2OcT00fmkOcU_N`02Kg/06fOi
OcUWnGliIcUonFLiOcUWnGliIcUonFLiOoUW>FmkIoUo>FmkOcUWnGliIcUo
nFLiOoUW>@02Kg/04WoiKg]W>GliIoUo>FLiOoUW>GoiIcUo>FOiOcUWnGli
IoUo>@9_N`0@Oc9WnGliIoUo>FmkOcUWnFmkIc9_NgNmIcU:DRU:000MOol0
2@03<U8aTTYBOol00Goo00=_N`0?Ool037Nm8@P0Y@01BI800goo00=VFAFB
DYA:DYIoo`06<cl1WfmkOomg_ALo0Woo00@FGgooOom:DP=JeP0=IcUJeP@Q
Ic9g_FOiOcU_NgliIoUo>FOiOcT00fmk00EW>GoiIcUo>FOi005o>@0000AW
nGliKg]_N`9o>@0KIoUo>FLiIoUo>FmkIoUo>FOiKg]o>FmkOcUWnGliIcUo
nFLiOcUWnGliIcUonFLiKg]o>FOi009o>@08IcUonFLiOcUWnGliIcUo>@9_
N`08OcUWlWliIcUonFLiOcUWn@9o>@0AIoUW>GliIoUo>FOiOcUW>GliIoU_
NgliKg]o>FOiIcUon@02Kg/02GliOoUBU7NmKg]W>E:D:DX0000MOol01VLi
Ool00c9BOol0009oo`03001g_Goo00]oo`0<0001S0010:aW?`2/Icl0YGli
5I8FFFLi0TYBUWoo00=g_GooOol00Woo00LFGgooOol2GgooMke:DP03F]H0
5FLiF]H<HfIBMkeo>FLiOoUW>GliKg]o>FOiKg]o>FmkOoUW>GliIoUo>@01
Kg/00009OcU_NfmkOcUWnFLiOcUWnGli009_N`0HOc9_NfLiOcU_NfOiOcU_
NgliIcUonFmkOcUWnGliIcUonFLiOoUW>GliKg]WnGli0Vmk00Uo>FOiOcUW
nGliIcUo>FOiOcT00Vmk00Mo>FLiOoUW>GliIoUW>@02OcT036OiOcU_Ngli
IoUo>FmkOcU_NfOiOcU_N`9o>@0<IcUo>FOiKg]o>FLiOoUo?fLiBU8YBP00
8Woo00D007ooOomoo`0000Uoo`0ABU8000005UT00goo00=;o`2UIUlFFDRU
BUT001B/Ic92402JOol02GNm0cmoogoo5cmWogoo@Q1W>@02F]H01FLiF]H4
8E[FOoT00fmk00eo>FOiOcUW>GliKg]WnGliIcUo>FOiOcUW>@01OoT0009_
N`08OcUWnFLiOoU_NgliIoUo<P9_N`0FOcUWnGliIoUo>FOiOcUW>GoiKg]W
<VmkOcU_NgoiIcUo>FmkOcUWnFmkOcT2Kg/02GliIoUo>FmkOcUWnGliIoUo
>@02Kg/037liIoUo>FmkOcUWnGliKg]o>FOiKg]o>@9_N`0<OcUW>GoiIc9_
NgliIoUo>FLiIoUo>FOi0Wli00Q_NfLbKg]g_E[FDY@YBP008Goo00<ES0@0
Ool00goo00<0048@Ool00goo00YW>AF<00000fOo00Eoo`2bBcUBU08ETP08
0H`D[0005I80YD/oDYA249Ioo`06Iomg_GooMkeooaIO0Woo00@2GgooOom:
DP9JeP0FDYAW>FLb0:EVDVmkOcU_NgliIoUo>FLiOoUW>FOiOcUW>GoiKg]o
>FOiOcT1Kg/00009OcUWnGliKg]o>FLiMke_Ngli009_N`03OcUWnGli009_
N`0=OcUW>GoiKg]o>FOiOcU_NfOiOcUW>GoiIcT00Vmk00Mo>FOiIcUo>FOi
Kg]o>@03Kg/05GlbKg]_NfOiOcU_NfOiOcUWnGliIoUo>FOiOcU_NglbKg]W
nGliIoUo>@03Kg/04WoiIcU_NfmkOcUW>GoiIcUWnGliMkeBU7oiMkeW>E:D
:DX001Yoo`09Kg]247ooF]IoofLiOol00D/o00Eoo`0G0:DbDWNmIUTES000
005oo`6BOolES39I5I8<Hc2/004ETP0PIclES6Oo5:aVDP02BU:FOol01T/o
0UmWogooMkdG?`9oo`055UmoogNmBU9W>@02F]H05FLiF]H48E[FOoUW>Gli
IoUo>FmkIoUo>FmkOcUW>GoiIcUo>FOiOcUWn@01OcT0000CIcUo>FOiOcUW
>GoiIcUo>FOiKg]o>FOiIcUo>FOiOcUW>GoiIc800Vmk00Io>FmkIoUo>FLi
OoT2Kg/02gliOoUW>GliKg]onGliIcUo>FOiOcT00Vmk00=onFLiOcT00Vmk
0Wli00EW>GNmOcUW>Gli00=_N`0>IoUo>FLiOcUWnGliIcUonFLiOcU_Ngli
IoUo>@9_N`0:OcUWnGliIc9_NgNmF]IBU2U:000JOol02E[F5I84000PBUTD
YGoo0:EJeP04Ool06WoiIcT00`05<U801Goo5I9W?cW>0:D1TP00<U800c<o
0HEo?`2/IclETVIO5H`bFE:DBU8XOol00fLiMkeoo`09Ool2Kg/4Ool01E:D
36=g_GooF]H00Woo00=:DWooOol00goo00=g_GooOol00Woo00=BU7ooOol0
1Goo00=247ooOol017oo00E_NgooOomg_E:D00Aoo`05Mkeooc6<<Haoo`02
IcT6Ool00fmkDYAoo`05Ool2Mkd2Ool00e[FOomoo`0GOol2<cl00gNmOolF
G`02Ool010<oIomoodYB0e[F00QW>FII0:EVDWNmOcUWnGli0Vmk00]o>FLi
OoUW>GoiIcUo>FOiOcUW>Gli005_N`00015onFLiOcUWnGliIcUonFLiOcUW
>GoiKg]o>FLiOcUWnGli009_N`04OcUWnFLiOcT2Kg/087liIcUo>FOiIcU_
NgliIoUo>FmkIcUonFLiOcUWnGliIcU_NgoiIcUo>FOiKg]W>GoiIcUWnGli
IoUo>FmkOcT2Kg/03GoiIcUo>FOiOcU_NgliIoUo>FOiOcUWnGli009_N`09
OcUWnFIBMke_NfLiDY@Q20@001aoo`06<U9:FCW>005oo`000goo01`aS000
0IT00goo<UU;?fOo000FDP@0BUT005[F00=ooc6BBclaTT/o5UTES4YI0000
[000IcU240Yoo`055UmoogooBclG?`05Ool04BU:36=ooe[F001247oo0012
47oo<H`Q27oo8@Q245[F00000Woo019W>B48BU8Q23W>Ool48B48MkdQ26Li
36=ooaBUMkd48Goo0002Ool02000Mkeood8@5:Eoo`00>Lh3Ool0236<IcTQ
25[F:DYJeP00@Q03Ool01@@QIcUoo`00IcT00goo00@DYE[FKg/YBP9oo`03
001g_Goo009oo`045:Eooe:D0002Ool01P00MkeoogooKg/48@9oo`03001o
ogoo009oo`048@PicVLi@Q02Ool00d8@5:Eoo`0GOol2Bcl00gooOoT3?`02
Ool011IOOomoodYB0e[F00]W>FLb125W<WNmKg]o>FObOcUWnGli009_N`08
OcUW>GoiIcUo>FOiOcUWn@5o>@00011o>FOiKg]o>FOiOcUW>GoiIcUonFLi
OcUWnGliIoUo>@9_N`0POcUWnGliKg]o>FOiOcUWnGliIoUo>FmkOcUWnGli
IoUW<WoiIcUo>FOiOc9_NgliOoUW>GliIoUo>FLiOoUW>@9o>@09Kg]o>FOi
OcU_NfLbOoUW>Gli009_N`0DOcU_NfOiOc9g_FLiOcU_NgliIoUo>FmkMkeB
U7oiMkeW>E:D:DX0025oo`0?001ooc6B000FFFOo0:aoo`085H`004YO00=:
FAIB009;>@0?<UU;?c6BIUT1TQF<000aS0005IT007lo0I9VDTYB00Moo`09
5cmoofLo5cmWoaIOOolc?gNm009Wo`9oo`0<DY@007ooOol006mk001g_ABU
F]HDYFmk0Woo00LaS000IcT007ooIcTaS002Ool01P00OomBU000Ool0008D
Y@05OolicWooKg/00003Ool02000<HaoogNm:DYoogNmF]H3Ool00`00IcUo
o`0200000gooKg]W>@02Ool00e:D000Q2002Ool035:DOom_Nd8@000aS7oo
001W>GooIcU_N`9oo`09BU8007ooOol005[FOomBU7Nm009oo`06:DX003W>
OomJeVmk0Woo00HaS000001oo`00@Q02Ool00aBUOomoo`0FOol01C<oBcmo
ofOo5Ul00Woo0142GgooMke246LiF]IBU6LiF]H<He:DOoUo>FLiKg]g_Gli
009_N`09OcUWnGliKg]o>FOiOcUWnGli005_N`00015_NgliKg]_NgliIoUo
>FmkOcUW>GoiIcUo>FOiOcUWnGli009_N`04Oc9_NfmkOcT2Kg/02GliIoUo
>FLiOoUW>GliKg]o>@02Kg/00gliIoUo>@02Kg/046OiOcUo>FOiOcUW>Goi
IcUonFLiIoUo>FmkOcUWnGli0Vmk00Io>FOiOcU_NfOiOcT2Kg/046LbOoUW
>GliIoUo>FmkOcUonE:DKg]g_FLiBU8YBP008Goo01/0002/0HaooaBUOol0
0005001_Nc<i5UUWob48Icl0[4/o0000[0005I8004YI005W?aIBBUT00S9I
00<0YE:DBU801goo00/2Gc<o<clc?goo<cmWoc<oOolbG`6I009oo`0;Kg/0
0000Ool006mk8@PDYBU:F]H00002Ool03e[F5:DYBWNm001g_Fmk:DYoo`00
Kg]oo`@Q5:Eoo`02000015[FMkdicWoo0`0000Moo`aS:DX007ooKg/aS006
Ool00b48Kg]JeP0200000fmkOomoo`02Ool015:D000Q27Nm17oo00EW>@00
Oom_NaBU00Moo`058@Qoo`0012400005Ool00bU:000icP05Ool01DYB8@Pa
S7oo:DX00goo00<DYGooOol05Woo00E;?d_oOomg_ALo009oo`045cmg_Goo
BU83F]H046LiDY@<He:DMkeW>GoiKg]W<WNmIc9onFLiOcUWnGli0fmk0Gli
0FLi0Goi00002VLiOcUWnGliKg]o>FOiOcUW>Goi0fmk00]o>FmkOcUWlVmk
OcU_NfOiOcUWnGli009_N`07OcUW>GoiIcUo>FOiOcT00Vmk00=o>FOiOcT0
0fmk00Qo>FLiIoUo>FmkOoUW>Gli0Vmk00=o>FOiOc800fmk00Ag_GliIoUo
>@9_N`09Oc9_NfmkOcU_NgliIoU_Ngli009_N`09IoUo>FLbOcmonE[FDY@Y
BP0001eoo`0TIcTES7oo<UT406Oo8@P<Hc9I001ooaF<Ool024YB001W?`00
0H`0036B5I9;>@2/BcU;<S9OIcT1TVIO0:D<H`00<I9JeT8@1Woo00ag_C<o
5cmoo`9OOolc?d/o<cmg_FOoMkd2Ool02bU:000aS7oo001_NgooDYAood8@
00000Woo00PicRU:12400248Oom_NbU:0R4800IJeTYBF]IBU7ooMkd3Ool0
1`aS>LioogooIcUoogNm00=oo`03:DXQ27oo00Eoo`03<HaJeVmk009oo`03
IcUoogoo009oo`03Kg/002U:00Ioo`04001oofmk:DX7Ool011BUKg]oogoo
0WNm17oo00=24000DY@01Woo00@003W>IcTaS09oo`035:DYBWoo01Moo`9;
?`03Oomg_AIO009oo`040UmWogooBU83F]H02VLiF]H<HfIBMkeonFLiOcU_
Ngli0Vmk00Uo>FOiOcUWnGliKg]o>FLiOoT00Fmk00003FOiOcUW>FOiOcU_
NgliKg]WnGliKg]o>FOi00=_N`09OcUWnFmkOcUW>GoiIcUWnGli009_N`0@
OoUW>GoiIcUo>FOiOcU_NfOiOcUWnGliIcUonFLiOcT2Kg/01gliIcUonFLi
OcUWnGli009_N`0BOcU_NgliIcUWnGliKg]o>FOiKg]o>FmkIoUo>FmkOcUW
nFLi0Wli0Vmk00MJeWoiIcmW>E:D:DX0000MOol0948@001oo`@QIom241B/
<U8D[4/i00DbF@aSF]H0[39B0HaooaFIBolbFGlo0:aoo`2/<UT1S4VI0200
Y@005UT4036BDYA:DPIoo`05IomW?gooOolc?`02Bcl00fOo<cmoo`04Ool0
1GNmOomoofLiMkd027oo0WNm00=oofmkOol017oo00Eg_D8@Oomoofmk06Qo
o`055UU;?gooOolG?`02Ool01AIOOomonD8@IcT00U[F01EW>E[F125BU7oi
Kg]onFLiKg]WnGliKg]o>FmkIcUo>FOiOcUWnGliIcT00Gli000037liIoUo
>GliIoUo>FLiIoUo>FLiOcUWn@9o>@0[Kg]o>FmkKg]o>FLiOoUW>GliKg]o
>FOiOcUW>GliIcUonFLiOcUWnFmkOcUW>GliIcUonFmkOcUWnGliKg]W>Goi
IcUo>FOiOcUW>FmkOcUWnGliIoT00Wli00AWnGliIoUW>@9o>@0<IoUo>FLi
OoUW>GliKg]onFLiKg]onFLb0WNm00AW>E:D:DX001eoo`0HMke:FGoo0H`a
TWooDY@00E[F0:E_N`005I8icQB/<UT00d/o1000Y@00BUT081FB0P0000X4
03<i0:`aTQB/<I8FFAIOIU9:DYEoo`05Mkd2F@9OMke;?`020Ul2Ool010<o
OomoodYB0U[F01IBU6LiIcT48FLbOcU_NfLiOcU_NgliIcUonFmkIcUonFLi
OcUWnGliIcUon@5W>@00015_NgliIoU_NgliIoUo>FmkOcUWnFmkOcUWnFLi
OcUWnGli009_N`0JOoUW>GoiIcUo>FOiOcUWnGliKg]o>FLiOoUW>GliIoU_
NgliIoUo>FLiOcUWnGliIoUo>@9_N`0COcUWnGliKg]onFLiOcUW>FOiOcUW
nFLiOcU_NgliOoUW>FOiOcT00fmk00io>FOiOcUW>GoiIcU_Ne[FOcUg_FLi
BU8YBP0087oo024007ooOomoofmk00D0YC6BBcTES1FB<U80YC9B001ooaFB
BUl0Y@035H`bGdYI5UTbFD/o<U9Woc9IIcl0YE[F@Q00UGoo00Ig_D/oIomg
_FOoBcl3Ool011IOIomoodYB0e[F01EW>FIB0:EJeWoiKg]o>FOiOcUWnGli
IcUo>FOiOcUWnFmkOcU_NgoiIcT00Goi00008WliKg]_NgliIcUo>FOiOcUW
nGliIc9onFLiOcUWnGlbKg]WnGliIcUo>FLiOcUWnGliIcUo>FOiOcUWnGli
IcUonFLi0Wli02UWnGliKg]o>FOiKg]o>FLiOoUW>GlbIoUo>FOiOcUW>Gli
IoUo>FmkOcUW>GoiIcUo>FOiIcU_NgliIcUo>FOiOcUWnGliIcUonFLiOcUg
_FLb009g_@04IcUBU2U:000POol00`00Oomoo`03Ool06aB/0001TRU:5:`<
HaB/<I9;oaIB36<ES000Icl0YFOo060bF@03Ool0802/000ES000F]I:DP2N
Ool01@9OOomood8@IcT00U[F00iW>E[F36=VDWNmOcUWnGliIoUo>FLiOcUW
nGli0Vmk00Eo>FmkKg]W>Gli005_N`0000UWnGliKg]_NgoiIcUo>FOiOcT0
0fmk00Ao>FOiOcU_N`9o>@0LIoUo>FmkOcUWnGliIoUo>FLiOcUWnGliIoUo
>FmkOcUWnFmkOcUW>GoiIcUo>FOiKg]o>FLiOoT2Kg/08gliIcUWnGliIoUo
>FOiOcUWnGliKg]o>FOiOcUWnGliIoUo>FOiOcUW>GliIoUo>FLiOoUW>Goi
F]IonFmkIcU:DRU:00006goo00HES6LoIoU_Ngoo0046Ool06TYB0000YAII
BUTbDP010000202U5:`ETP0P0H`<002/5H`0002/@Q0ETRU:BUUVGd/b@Q2N
Ool010<oOomonDYB0e[F01EW>E[F125BU7oiKg]o>FLiMke_NgliIoUo>FOi
OcUg_FmkOc9WnGliIoT00Gli0002OcT01fObOcUW>GoiKg]o>FLi009_N`03
OcUWnGli00=_N`0:IoUo>FOiOcUWnGliIcUo>FOiOcT3Kg/02WliIoUo>FOi
IcUo>FmkOoUW>Gli0Vmk00=o>FOiOcT00Vmk00Mo>FLiOoU_NgoiIcUo>@02
Kg/06gliKg]o>FOiOcU_NgliIoUo>FmkOcU_NgliIoUo>FOiOcU_NgNmOcUJ
eVmkMkeW>E:D:DX0000JOol01aB/001oo`00OolDY@0100Moo`0GIol0000P
5I848@03<U8c>FII0I9_NdYIBI8FFGoo5:aooaB/OolQ24YO0:a;>@02BU:N
Ool011IOIomoodYB0U[F015BU6LiF]H0YFLbMkeo>FLiOoUW>GliIoUo>Fmk
OcU_NfLb009_N`03OcUWnGli005_N`0016mk00Io>FLiOoUW<WoiOcT2Kg/0
47liIoUo>FmkOcUW>GNmOcUWnGliIoUo>FmkOcUWnGli0Vmk00=o>FLiIoT0
0Wli00I_NfObKg]o>FOiOcT2Kg/04GlbIoUo>FmkIoUo>FLiOcUW>GoiIcUo
>FOiIcUo>FOiOcT00Vmk01Eo>FmkIcUonFLiOcUWnGliIcUo>FOiOcUW>Goi
IcUo>GNmF]IBU24800006Woo00Mg_C6BOol<Hgoo<U8aTP05Ool03TYB5I8a
TRU:00D001II<I8D[00P0:DYBP085I8200001AF<000aTP005I800P2U00@4
006BIU9:DYioo`055Umoogoo@Q1W>@02F]H03VLiIU8<He:DOoU_NgliKg]o
>FOiOcU_NfLiOoT2Kg/01GliIoU_NgliKg/00Gli00001VLiOoU_NgliIoUo
>@9_N`0;OcUWnFLiOoUW>GliIoUo>FLiOoUW<P02Kg/047liKg]WnGliKg]W
>GoiIcUo>FOiOcU_NgliIoU_Ngli0Vmk00Io>FOiOc9_NfOiOcT2Kg/027li
IcUonFLiOoUW>GliIoT2OcT06VOiOcU_NfLiOoU_NfLiOoUW>GliIoUo>Fmk
OcUWnGliIcUonGliIc9_NgNmIcUBU2U:000OOol02QBUIcUoogooIol01@2U
0:`aS6mk0Woo0P0001@ETQF<5I80[1BU5;8bDT/oBU8aTTYI0:ao?aF<Ool0
[6Oo101JeTYBWWoo00D3?gNmOom246Li009JeP0AIcU;>@aSIU9_NgliIoUo
>FOiOcUW>FmkOoUo>FLiOcUWn@02OcT1Kg/1OcT1IoT00007OcUW>GoiIcUo
>FOiOcT00Vmk0Wli00]W>GoiIcUo>FOiOcUg_FmkOcUWnFLi009o>@0;IoUo
>FmkKg]onFLiOcUWnGliIoUo>@02Kg/00glbIoUo>@02Kg/027liKg]_Ngli
IoUo>FmkOcT2Kg/057liIoUo>FmkIoUo>FLiOoUo>FLiOcUWnGliIoUo>FLi
Kg]o>FOiOcT4Kg/01e[FOoUg_E[FDY@YBP0001moo`07001oo`2U00<01FLi
BcT01Woo0P0000LETP2U5H`ETS9B004D[0020:D02S6B000FDP05:DX00`2U
<UUVDT8@UGoo00=onGooOol01Woo00@2GgooOom:DP=JeP0EIcUVF@2PF]Io
nFLiOcUWnGliIcUonFLiKg]W>GoiKg]o>FOiIcUo>FOi005o>@0000=WnGli
Kg/00Vmk021o>FOiKg]o>FOiIcUonFLiOcUWnGliKg]W<WliIoUo>FmkOcUW
nFmkOcUWnGliIcUo>FOiOcU_NgliIcUWnGli16mk00]o>FmkKg]o>FOiOcUW
>GoiIcUWnGli009_N`0<OcUWnGliIcUonFLbKg]o>FOiOcU_Ngli0Vmk00Uo
nFLiKg]o>FOiOcU_NgoiIc800Vmk00AW>E:D:DX001aoo`05<U9oogoo36<0
000<Ool04P030001TQ@5<UT004/o5H`ETVLo0:EW?`05IcT0[7oo0:aWo`9:
DYioo`0<5UmoogooBU9JeU:DF]IW>FLb125VDWNm0Vmk00Uo>FLiOoUW>Goi
IcUonFLiOcT00Vmk00=o>FOiOcT00Fmk000027liIoUo>FLiOoUW>GliIoT2
OcT2Kg/01GliIoUo>FLiOoT00Vmk02=o>FLiOoUW>GliIoU_NgliIoUo>FOi
OcU_NfOiOcU_NgliIoUo>FmkOcU_NfOiOcUWnGliIcUonFLiOcU_NgliIoUo
>FLi009_N`07OcUWnFmkOcU_NfOiOcT00Vmk019WnGliIoUo>GoiKg]W>Gli
Kg]o>FmkIcUonGloF]IBU2U:000LOol01P00Oomoogoo5Ha_N`aoo`0C>Lh0
01II101:F@0P0:`Q202U0:`01D/i0:aWn@00<U8005[FBU80:7oo00=JeSW>
Ool07Woo00=JeWNmOol0BWoo00Hc?`6OIoU;?`9O5cl2Ool01@<oMkeood8@
IcT00U[F01EW>E[F36=BU7oiOcU_NfOiOcU_NgliIcUonFLiOoUW>FmkOcUW
nGliIoT00Gli000046OiOcUW>GoiIcUo>FmkOcUW>FmkIoUo>FmkOcUWnGli
0Vmk00Io>FLiOoUW>GoiIcT2OcT016OiOcUW>Gli0Vmk01Uo>FLiOoUW>Gli
IoUo>FOiKg]o>FOiOcUW>GoiIcU_NgNmOcUWnGliIcUonFLiOoUW>@02OcT0
2VOiKg]o>FLiOoUW>GliKg]o>FLb0fmk00]o>FOiKg]onE[FKg]g_FLiDY@Y
BP0001aoo`030:Eoogoo009oo`03000027oo00]oo`0B<U84006B5I8`[06<
<:`ES4/o:DX1S0038@Q;o`05BomBU48@:7oo0SW>67oo00=_NgooOol017oo
00=BU248Ool0Bgoo00EWod/oOomooaIO009oo`040UmoogooBU84F]H03FLi
00=W<WliIoUW>GliIoUo>FLiOoUW>Gli009_N`05OcUWnGliKg]W>@01OcT0
000HOcUWnGliIcUonFLiOoUW>GoiOcU_NfLiOoUW>GliIoUo>FmkIoUo>Fmk
OcUW>Goi0VLi00Mo>FmkOoUW>GliIoUo>@02Kg/0<7liIoUo>FLiOcUWnGli
IcUo>FOiOcUWnGliIc9WnGliKg]onFLiOoUW>GoiIcU_NgliIoU_NgliIcUo
nFLiOcUWnGliKg]o>FOiOcUW>GliMkeW<VmkMkeW>DYB:DX0029oo`03<U80
0Fmk00]oo`0A<U840000Bcl01AF<5:`004/o001oo`00BUUJeP00F]I:DP0W
Ool00gNm>Lioo`06Ool00`@Q@Q1oo`0=Ool00e[F8@PDY@07Ool00c6<Oomo
o`0HOol00`00BU9oo`0_Ool01D/o<cmoofmk5cl00Woo00@FGgooOoU:DP=J
eP0EIcUJeP@QF]Ig_FmkOoUW>GliIoUo>FLiOoUW>GliIoUo>FmkOcUWnGli
005_N`0000A_NgliIoUo>@9_N`03OcUWnGli009W>@05OoUW>GliIoUo>@02
Kg/047liIoUo>FLiOoUW>FmkOoUW>GoiIcUo>FOiOcUWnGli0Vmk00]o<Vmk
OcUWnGliIcUo>FOiOcUW>Gli009_N`0:OcU_NgNmIcUo>FLiOcU_NfOiOcT2
Kg/05WliIcUonFmkOcUWnGliKg]g_FLiOcUWnGliKg]onE[FOcUg_FLiDY@Y
BP008goo00=JeP00Mkd02goo010bDP010:DETQB/5I80Y@00BUTES7oo000E
TVmkBU9242Qoo`03>Li_Ngoo00=oo`04DY@icPaSBU8?Ool00bU:Mkeoo`06
Ool00d8@DYAoo`0FOol014YB@Q048E:D<7oo00Dc?d/oOomooaIO009oo`0L
0cmWogoo@Q1W>E[FDYAW>E[F36=JeWoiOcUW>GliIoUo>FLiOoUW>GliIoUo
>FOiOcUWnFLiOoT1IcT00005OcUWnGliIoUo>@02Kg/00gliKg]on@02Kg/0
67liIoUo>FOiOcU_NfLiOcUWnGliIcUonFLiOcUWnFmkOcUWnGliIcUo>FOi
OcUWn@=_N`0AOcUWnGliIoUo>FmkOcUWnGliKg]WnGliIcUonFLiOoUW>@02
OcT026OiOcU_NfmkOoUW>GliIoT2Kg/03gliIcUonFLiOcUW>GoiKg]JeWoi
MkeJeU:D8@P4000UOol00`010:aoo`0:Ool01dYB0041S02U<U8EVC9B008D
[0060:Eoo`2U301W>DYB:7oo00<icWNmOol017oo00=:DRU:Ool03Woo00Ag
_Goo:DYg_@Ioo`03@Q1_Ngoo01Moo`03@Q0aS7oo031oo`9;?`03OomWoaLo
009oo`045UmoogooBU83F]H05FLiF]H48FIBMke_NgoiIcUo>FOiOcU_Ngli
IoUo>FmkOcUW>GliKg]o>@01OoT0009_N`0>OcU_NgliIoUo>FOiKg]o>FLi
OcUWnGliIcUo>@9_N`07OoUW>GliIoUo>FmkOcT00Vmk01Ao<VmkOcU_Ngli
IoUW>GoiIcUo>FmkOcUWnGliKg]o>FOiOcUWnGli0Vmk029o>FOiOcUW>Goi
IcUo>FmkIoUo>FmkIoUo>FLiOcUWnGliIcUo>FOiOcUW>GoiIcUonFmkOcUW
<VmkMkeW>E:D:DX002Ioo`035:`0YGoo00Yoo`06F]H001FB<I800AFB0P2U
00HES000BcU;?dYB@Q0:Ool01VOo0Umoogoo<clFG`Ioo`035:Eg_Goo00mo
o`03>Li_Ngoo00Eoo`03001g_Goo00ioo`035:DQ27oo00Ioo`03@Q1W>Goo
01Qoo`03001oogoo02moo`05<cm;ogNmOolFG`02Ool0109OOomoodYB0e[F
00QW>FII36=;<WliOoUW>Gli0fmk00=o>FOiOcT00Vmk00EW>GoiIcUonFLi
005_N`0001Yo>FOiIcUo>FOiOcUW>GliIoUW>GoiIcUo>FOiOcUWnGliIcUo
>FOiKg]o>FOiOcUWnGli0fmk00=WnGliIoT00Wli00iW>GoiIcUonFLiOcUW
nGliIcUo>FOiOcUWnGli0Vmk00Uo<VOiOcU_NgliIoUo>FLiKg/00Wli01IW
nGliKg]o>FOiOcU_NgliIoUo>FLiOoUW>GliMkeJeWoiKg]JeU:D:DX002Mo
o`03<I8007oo00Yoo`0=>Lh0002/<U800gNm<I8bFFOo000D[6LbBU801Goo
00d2Gc<oOol2GfOoIcmWoaIO0Umooc<oIom;?`03Ool00gNm001oo`02Ool0
1CW>@Q1oogooMkd00Woo00A_Ne:DKg]BU09oo`03Mke246mk021oo`03>LiW
>Goo04Yoo`9;?`03Oomg_@<o009oo`045cmWogNmBU83F]H02FLiF]H48E[F
Mke_NgliIoUo>@02Kg/02VOiOcU_NglbIoUo>FLiOoUW>Goi0FLi0000=6Oi
OcUo>FOiOcUW>GliIoUo>FmkOcUWnFmkOcUWnGliIcUonFLiMkeo>FmkOcUW
nFLiOcUWnGliKg]o>FmkOcU_NfLiOoUW>GliKg]W>GoiIcUo>FOiKg]g_FLi
OcU_NfOiOcU_Ngli0Vmk00YWnGliIcUonFmkOcUWnFmkIoUo>@9_N`0AIcUo
nFLiOcUWnGliKg]o>FOiKg]W<WooMkeW>E:D:DX0000XOol00gNm001oo`0:
Ool0300000<001F<0:`D[000021oo`2UF]I240Aoo`0>5Umood_o0Imoo`9O
BcmWogooIomooc<o0UlG?`9oo`04F]H006Li>Lh2Ool012U:5:Eoogoo0P00
0Woo00<aS0aSOol00goo00<icWNmOol00SW>1T8@00<icS6<Ool00Woo00H0
01BUOomooe[F<H`7@Q000dYB8@Q_N`02Ool01T8@IcUooe[F:DY2409oo`03
<H`icT8@01524003>Li2448@00U24006>Li243W>DY@YBU[F7goo00E;?c<o
Oomg_ALo009oo`050Umoogoo@Q1W>@03F]H02VLb36=VDWNmOcUWnGliIcUo
nFLi0Wli0Vmk00Io>FOiOcU_NgliIcT1OoT00003Kg]W>Goi009_N`07OcUW
nGliKg]onFLiOcT00Vmk00Uo>FLiOoUW>GoiIc9_NgliKg/00Wli00IWnGli
IcUonFLiIoT2OcT01FOiKg]o>FOiOcT00Vmk00Mo>FOiOcUo>FLiOoUW>@02
OcT08VOiKg]_NgliKg]o>FLiOoUW>GliIoUo>FLiOcUWnGliIcUonFLiOcUW
nGliIcUonFLiOcUonE[F<HaoofLiBU8YBP00:Woo00<0039BOol02Goo0P00
0S9I00L<HfLo<I8004YIDYA:DP04Ool036Oo5Ulc?fOoOomW?aLo5Umoo`9O
Bcl2G`Aoo`048@PDYGoo<H`3Ool01E:DOomood8@BU800Woo00<DYB48Mkd0
0goo00@icVmkOomJePUW>@=oo`06>LiJeWooOomg_E[F26Li00YJeWNmOomo
ocW>IcUoogNmDYA_N`9ooaAW>@03Kg]W>FLi009oo`AW>@04Kg]W>FLiKg/2
IcT00gooIcU_N`0OOol2Bcl00gooMkdFG`02Ool0109OOomoodYB0e[F00iW
>D/i125BU7oiOcU_NfLiOoUW>GoiIcUWnGli0Vmk00Eo<VOiKg]_Ngli005W
>@0000=W>GoiIcT00Wli00eWnGliKg]_NfLiOcU_NfOiOcUW>GoiIcUo>@02
Kg/02GliIoUo>FLiIoUo>FLiOoUW>@02OcT01VOiKg]o>GliIoUo<P9_N`0Q
OcUWnGlbKg]W>GoiKg]o>FLiIoUo>FmkOcUWnGliIcUonFLiOcUWnGliIcUo
>FOiOcUW>GoiIcUo>FOiOcUWnGli009_N`09OcUg_FLb>LioofLiDY@YBP00
02]oo`0300DaS7oo00Uoo`0:00401@00<cl004/iIcl005[FBU85Ool00d/o
Iomoo`03Ool00d_oIcmg_@02Iol6Ool01WNm<Haoogoo5:DicPEoo`04Kg]J
eVLiF]H3Ool00cW>Kg]oo`0OOol00d8@IcUoo`0LOol2>Lh:Ool00aBUKg]o
o`0OOol01C?oBcmoofOo5cl00Woo00@G?gNmOom:DP=JeP0:IcUVF@aSIc9g
_FLiKg]onFLiOcT2Kg/00gliIoUo>@02Kg/017liKg]o>FOi0Gli00002goi
IcUonFLiIoUo>FmkOc9WnGliKg/00Wli01IWnGliKg]o>FOiOcU_NfOiOcU_
NgoiIcUonFLiKg]onFLiKg]o>FOiIcUo>@9_N`0;OcUWnFmkOcU_NgliIoUW
>GliIoUo>@02Kg/08GlbIoUo>FOiOcU_NgoiIcUo>FOiOcUWnGliIcUonFLi
OcUWnGliIcUo>FOiOcU_NfOiOcUW>FmkOcmW>E:D:DX0000/Ool00`2/001o
o`09Ool02@000:`48D/o000ES6LoDYA2400GOol014YBF]Ioofmk3Goo00<i
cWNmOol00Woo00MJeTYBOom245[FIcTaS009Ool01248OolaS6mk2Goo00<i
cVmkOol077oo00<Q25[FOol02Goo00<YBVLiOol07goo0T/o00=oogNm5Ul0
0Woo01L2GgooOom246LiDYAJeVLiIc801FIBOoUWnGliIcUonFLiOcUWnGli
IcUWnGli009_N`03OcUWnGli005Wn@0000EW>GliKg]_Ngli00=_N`0:OcUW
nGliIoUW>GliIoUo>FOiOcT2Kg/02gliIcUonFLiOcUW>GoiIc9o>FOiOcT0
0Vmk00Eo>FOiKg]o>FOi009o>@9_N`07IoUo>GliIoUo>FOiOcT00Vmk01Eo
>FLiOcUWnGliIcUo>FOiOcUW>GliIoUo>FmkOcUWnGliKg]o>FOiOcT00Vmk
00Uo>FmkF]IW>GoiIcUBU2U:0000;Woo00<007ooOol01goo00Ug_@010:D0
0goo<U8ES5:DBU805goo00<icTYBOol03Woo00<icVmkOol00Woo00H<H`@Q
OomooaBU36<;Ool00`00DYAoo`09Ool00d8@F]Ioo`05Ool076mk36=oo`aS
IcT006mkOol007ooF]H48GooF]H005:D>Li:DS6<125W>@aSOom246LiOomg
_@000Woo00<<Hgoo12400Woo00=245[FOol077oo00QonGooOom;?c<oOomg
_ALo0Woo00@3?gooOom:DP=JeP0EIcUJeP@QIc9g_GliIcUonFLiOcUWnGli
IcUonFmkOcUWnGliIoUo>Fmk005o>@0000IonFLiOcUWnFmkOcT3Kg/037li
IoUo>FOiOcUW>GoiIcU_NgliIoUo>@9_N`03OcUWnGli00=_N`03OcUWnGli
009_N`0aOcUWnFmkOcUWnFLiOcU_NgliIoUo>FLiKg]o>FOiOcUWnGliIoUo
>FmkIoUo>FmkOcUWnGliKg]o>FOiOcUWnGliIcUg_FmkOcUWnGliIoUo>Goi
F]IW>GNmIcU:DRU:0000;goo00<004/iOol01goo00=g_@000H`00QB/00<0
85[F@Q005goo00ABU36<Kg]BU09JeP08DYAJeU[FF]IBU5[FDYAJeP9oo`03
MkdicWoo009oo`07001W>FmkKg]oob48:DX02Woo00YW>ABU@Q1oofmkOola
S7ooF]I_N`=oo`03@Q1W>Goo00Ioo`800006DYA_NcW>Ool007oo0gNm010a
S7oo8@QoodYBMkeJeT8@OolicWoo>LiW>GooF]H000=oo`06001oogooOom2
46Li87oo0T/o00=oogNm0Ul00Woo00DFGgooOom246Li009JeP0BIcUJePaS
F]IonFmkOcUW>GoiIcUo>FOiOcUW>GliIoUo>FLi0Vmk0Gli0FOi00000fLi
OcUWn@02OcT056OiOcUW>GoiIcUo>FmkOcUWnGliIcUo>FObKg]o>FOiKg]o
>FOiOcT3Kg/01gliIoUo>FLiKg]onFLi009o>@9_N`03OcUWnGli009_N`09
IcUonGliIoUo>FLiOcUWnGli009_N`9o>@05IoU_NgliIoUo>@02Kg/01FLi
OcU_NfOiOc800Vmk00ao>FOiOcUWnGloIc8icWooIcUBU2U:000`Ool00`08
0:Eoo`07Ool01cW>000FF@2UIcmBU4YB01Qoo`03F]HaS4YB00924003BU92
448@00924003BU8icT8@00=oo`08>LiJeWooOomBU7oo>Li:DP=oo`03IcUo
ogoo00Moo`0:@Q1oofLiOolDYGNm:DYooaBU@Q02Ool00gNm36=oo`08Ool0
1P@QOolicP00Oom:DP92400GOolDYGNmOol007oo:DX<HgNmDY@DYDYBOola
S7Nm<H`007oo<Haooc6<>LhaS002Ool00cW>F]Ioo`0OOol01ALoIcmoogNm
5cl00Woo00@2GfOoOom:DP=JeP0EIcUJeP@QDYA_NgliIoUo>FmkOoUW>Gli
Kg]o>FOiOcU_NgliIoUo>FOi005o>@0000]o>FOiOcUWnFLiOcUWnGliIcUo
nFLi009_N`05OcUWnGliKg]o>@02Kg/017liIcUWnGli0Vmk00ao>FOiOcU_
NgliIoUo>FLiOoUW>FOiOcT2Kg/02WliIoUo>FLiOoUW>GliKg]WnGli0fmk
00Eo>FOiIcU_Ngli009_N`07OcUWnGliKg]onFLiOcT00Vmk00io>FOiOcUo
>FLiOcUWnE[FBU9ooe[FDY@Q20@0<Goo00<ES008Ool01goo0P0000@aTR48
DYA:DRQoo`03@Q0DYGoo00=oo`06IcTQ25[FDYA245[F3Goo00H48GooOol0
06mk>Lh2Ool00d8@DYAoo`07Ool055[F5:EoogooIcU_Ngoo<Haooe[F36=J
eVmk@Q1oogNmIcUoo`aSIcT2Ool02T8@MkeoogNmIcTYBWooKg]oofLi0Woo
00=BU6LiOol07goo00D2FD/oOomg_ALo009oo`045cmoogooBT`3F]H05FLi
F]H<HfIBOoUW>GliIoUo>FLiOoUW>GliIoUo>FmkIc9onFLiOcU_N`01IoT0
000LIoUo>FmkKg]o>FmkOcUWnGliIcUonFLiOcUWnGliKg]o>FmkIoUo>FLi
OoU_NgliIoUo>FOiOcT2Kg/016OiOcUW>Goi0Vmk00Qo>FOiKg]o>FOiOcUW
nGli0Vmk00AWnGliIcUon@9_N`08OcUWnFmkOcUWnGliIoUo>@9_N`04IoUo
>FLiOoT2Kg/03gliIoUo>FLiIoUo>FOiOcUW>D8@OomW>E:D:DX0000bOol0
0e[F001W?`07Ool200000c9IDYA2400YOol00gNmOomoo`03Ool01FLiBU9B
U4YBDY@03Goo00AW>GooOomBU09g_AIoo`9g_@Ioo`06Kg]oogooOol48B48
0goo00=241BUDY@00SW>0Woo00<005[FOol07goo00Dc?d/oOomWoaIO009o
o`040Umg_GooBU83F]H05FLiF]H48E[FOcUWnGliKg]W>GoiIcUonFLiOcUW
nFmkOcU_NgliIoU_N`01OcT0000>OcU_NfmkOcUWnGliIoUo>FmkOoUW>Gli
IoUo>@9_N`0eIoUo>FmkIoUo>FLiOcUWnGliIcUo>FOiOcUW>GliIoUo>FLi
OcUWnGliIcUo>FOiOcUW>GliIoUo>FLiOcUWnGliIcUo>FOiOcUW>GliIoUo
>FLiOcUWnGliIcUo>FOiOcUW>GliIoUo>@02Kg/037liIcUonFLiOoUVDTYB
OomJeU:D:DX003=oo`03Kg/00e[F00Moo`800003IcU:DWoo06Uoo`03F]Io
ogoo009oo`04IcUJeVLiDY@2Ool00e[FOomoo`0MOol01fOo0IT2Gd/oOomg
_ALo009oo`045cmoogNmBU82F]H02e:DIcUJePaSDYAg_GliIoUo>FmkOcT0
0Vmk00UonFLiOcU_NfOiOcU_NgliIoT00Fmk0002Kg/03WliIoUW>GoiIcUo
>FmkIcUo>FOiOcUW>GliIoT2OcT0=fmkOcUW>GliIoUo>FLiOcUWnGliIcUo
>FOiOcUW>GliIoUo>FLiOcUWnGliIcUo>FOiOcUW>GliIoUo>FLiOcUWnGli
IcUo>FOiOcUW>GliIoUo>FLiOcUWnGliIcUo>FOiOcUWnFmkOcUWnGli009_
N`08MkeW>D8@OomW>E:D:DX003Eoo`03000aS7oo00Eoo`04Mkd01E[F@Q2F
Ool01WNmOomoogooOoTFG`9oo`040UmWogooBU83F]H01FLiF]H<HfIBOoT0
0Vmk00eo>FmkKg]WnGliIcUo>FmkIoUo>FLiOoUW>@02OcT0001COcUWnGli
Kg]o>FLiOoUW>GoiOcU_NgliIoUo>FOiOcUW>FOiOcUWnGliIoUo>FOiOcUW
nGliIoUo>FOiOcUWnGliIoUo>FOiOcUWnGliIoUo>FOiOcUWnGliIoUo>FOi
OcUWnGliIoUo>FOiOcUWnGliIoUo>FOiOcUWnGliIoUo>FOiOcUW>GliIcUW
nGliIoUo>FmkOcUW<T8@OomJeU:D:DX0000fOol00aF<00Qoo`06Ool00d8@
BU9oo`2IOol02FOo5cmoogoo5UmoogNmBU9W>@02F]H03fLiIc801FLbMkeo
>FmkIoUo>FLiOcUWnGliKg]o>@02Kg/017liKg]onFLi0Fmk0000DfmkOcUW
nGliIcUonFLiOcUW>FOiOcUWnGliKg]W>GliIoUo>FOiOcU_NgliKg]o>Fmk
OcU_NgliKg]o>FmkOcU_NgliKg]o>FmkOcU_NgliKg]o>FmkOcU_NgliKg]o
>FmkOcU_NgliKg]o>FmkOcU_NgliKg]o>FmkOcU_NgliKg]o>FmkOcU_Ngoi
OcU_NgliKg]o>GoiIcU:DWooIcUBU2U:0000=goo00<aS003Kg/01Goo00=2
44YBOol0VGoo00Qg_AIOOomoo`<oMkeoodYB0e[F01EW>E[F125JeWliKg]W
nGliIcUonFmkOcUWnGliIoU_NgliIoUo>FLiIoT00Gli00003gliIoUo>FOi
OcUW>GoiKg]o>FLiIoUo>FLiOoUo>@02Kg/0@WliKg]oogoiOomonGooOoUo
ogoiOomonGooOoUoogoiOomonGooOoUoogoiOomonGooOoUoogoiOomonGoo
OoUoogoiOomonGooOoUoogoiOomonGooOoUoogoiOomonGooOoUoogoiMkeo
nGooOoUoogNmOomW>CW>OomW>DYB:DX003Qoo`03Kg/003W>00Aoo`03@Q1:
DWoo09Eoo`06<cl3?gNmOomg_ALo0Woo00dFGgooOom246LiF]IBU6LiF]H<
He:DOoUo>@02Kg/02gliIcUonFLiOcU_NgliIcUWnGliIoT00Wli0FOi0000
56OiOcUW>GliIoUo>FmkOcUWnGliKg]o>FOiOcUWnFmkOcUWnGli8@Pc<H`0
0cW><H`YBP02<H`01c658@QoofLiDY@YBP0003Yoo`030:`icWoo009oo`92
425oo`03IcUoogoo01=oo`03IcUoogoo01=oo`=g_DIoo`03MkdFGd/o009o
o`070Umoogoo0cmWogooBU800e[F00EW>E[F36=BU7oi009_N`0:OcUWnGli
IcUonFLiOoUW>GoiKg/2OcT1IcT1IoT1OcT0009_N`0AOoUW>GliIoUo>FLi
OcUWnGliIoUo>FLiOcUWnGliKg]W<P0f00002QBU000000@QOomg_E[FDY@Y
BP00>goo00@D[00POomoo`9:DPYoo`04Iomg_GooIcl6Ool01TYBMkeBU7Nm
Oom_N`9oo`0=BU9oodYBIcUoob48001_NgooDYAoogNmDY@00Woo00A247oo
Mke2409oo`04001W>E:DF]H2Ool01`@Q001ooe:DKg]oodYB009oo`8Q2006
Kg]oofLiOol0048@0Woo00PaS6mkOom_N`008@Qooe:D0Woo00PicWooOol0
04YBKg]g_DYB1Goo00UBU7ooKg]oo`00@Q1oo`00BU800Woo00I:DWooKg]o
o`00BU8UOol01D_oBcmoogNm5cl00Woo00/FGgooOom246LiDYAJeVLiF]H4
8FLb009_N`06OcUWnGliIoUo>FLi0Vmk00Eo>FLiOoUW>FOi009o>@5Wn@00
00AWnGliIcUo>@9_N`0>OcUWnFmkOcUWnGliKg]o>FOiOcUW>GoiIcTicS9o
o`0=Mkd`YGooIc9g_GooKg]oofmkIcUBU2U:0000?7oo00E:DP03Oom:DT8@
00Moo`08Iomoogoo0Umood/oIol2G`Ioo`0<001oocW>5:D007oo001oo`00
:DYoob480RU:021JeP00OomW>@008@Q:DPaSBU9JeP00OomW>Goo>LioodYB
:DX<HaBU>Li243W>5:EooaBU36=JeWoo@Q1ood8@0P0001=oofmkBU9ooe:D
IcTDY@00F]H007oo001:DWoo001246LiKg]:DP02Ool01@00@Q1ooe:D0000
0Woo00=JeP0000000Woo00@Q27oo<H`aS09oo`03BU8000@Q009oo`03<Hao
ogoo02=oo`05<cm;?gooMkdFG`02Ool0109OOomg_DYB0e[F01E_NfIB0:EV
DWNmOcUWnGliIcUo>FOiOcUWnGliIcUonFLiKg]o>FmkIoT00Gli000027li
IoUo>FOiOcU_NfOiOcT2Kg/02WliIcUonFLiOcU_NfOiOcUJeS6<<Woo00eW
>@aSOol006mkOol005[FMkeW>DYB:DX0000mOol016Li001JeTYB1goo00/2
Gc<o5cmW?d/o<UUooc<oOolG?`6O00=oo`0H001oocW>000<Hgoo001ooc6<
000<HbU:>LhDYE[F001247oo:DX007Nm001_Ngoo0P0000licWoo5:EoocW>
5:Eoo`00DY@004YB001oo`00>Lh00Woo00PYBVmkOol00248OomJeSW>0Woo
00haS5[FBU8icP00IcT48C6<Ool006LiOom_Nc6<0Woo00D007ooOomW>@@Q
009oo`03Kg/002U:009oo`035:Eoogoo00=oo`06IcT00248Oom_NbU:9Goo
0T/o00=oofOo5cl00Woo00@G?fOoOom:DPEJeP0?36=BU7oiIcUo>FOiOcU_
NgliKg]o<VOiOcUW>Goi009_N`5o>@5_N`5_N`0000I_NgliIoUo>FmkIoT2
OcT036OiOcUW>GoiIcUo>FOiKg]o>GloIc8YBS9oo`0=Kg/<Hgoo001_Ngoo
124<HgooIcUBU2U:0000?goo00=244YBOol01Woo00/c?aIOIol2GgooBomW
?aLoOom;?c<o009oo`0KF]H007NmKg/007ooIcT007NmOolaS4YBOolaS5:D
8@QBU248OomJeU:DOol003W>Oom:DRU:009oo`0;125_N`00DYAg_E[FBU8a
S48@<Hag_@020002Ool05BU:DY@DYGoo5:Eoob48@Q1ooe:D001g_FLiDYA:
DRU:@Q0icVmk000Q2002Ool010aSDYAoo`001Woo00HYBU[F<HaW>CW><H`5
Ool01R48Kg/YBWNm8@Q242Aoo`06Mke;od/oMkeooaIO0Woo00D2GgooOom2
46Li009JeP0;IcUJePaSIU9_NgoiKg]o>FLiOoUW>@02Kg/00gliIoUo>@02
Kg/00gliIoUo>@01Kg/00006OcUWnGliKg]o>FLi0Vmk00ao>FOiKg]o>FOi
OcUW>GobIcUonE[F:DXbOol03FLi36=oo`00Kg]oo`00Oomg_E[FDY@YBP00
03moo`03@Q1:DWoo00Eoo`09Iom;?gooOolc?fLo<cm;oc<o00Eoo`03F]I2
45:D00Aoo`03DYAoogoo00aoo`03DYAoogoo00Moo`03<HaJeWoo00Eoo`03
IcUoogoo009oo`03Kg]oogoo009oo`07Kg]oogooOomJeSW>IcT01Woo00E:
DWooOomoogNm009oo`03@Q1oogoo00Qoo`03IcUoogoo00Qoo`03Kg]oogoo
02Aoo`050Um;?gooOoTG?`02Ool011IOOomonDYB0e[F00aW>E[F125JeWoi
IcUo>FOiOcUW>GoiOcT2Kg/01gliIoUo>FLiOoUW>FOi005o>@0000QWnGli
IcUo>FOiOcUWnGlb0Vmk00Eo>FLiOcUWnGli009_N`03MkeW<SW>039oo`04
MkdaS7oo>Lh2Ool01c6<Oom_NfLiDY@YBP0003moo`03BU9247oo09Aoo`07
IolFGaLoIcmg_D_o0Ul00Woo00@3?fOoOom:DP9JeP0FDYAW>FLb0:EVDWNm
OcUWnGliIoUo>FmkIo9_NgliIoUo>FLiOoUW>GliKg/1OcT0009_N`03OoUW
>Gli00=_N`0BOcUWnGliIoU_NgliIoUo>FmkOcUW>@aSBU99S39<<H`icTV<
0cW>00PaS48@>LhaS48@<Ha9S36<0cW>00/aS48@<Ha9S3W><Ha243W>BH`a
S39<00<icP09BH`icTV<>Li9S3W>BH`icTV<00<icP08<H`icTV<@Q0aS000
DYAW>@8icP07@Q1oofmkIcUBU2481000?goo00=244YBOol0U7oo00Mg_ALo
<cmooc<o5UmWo`02Ool01AIOOomood8@IcT00U[F01EW>E[F36=BU7oiKg]o
>GNmKg]o>FLiOcU_NfOiOcUW>GoiIcUonFLiOcT00FOi00001VOiOcUW>Gli
Kg]Wn@9o>@03IoUo>FOi009o>@08Kg]o>FmkKg]onE[F36=BU08aS00a>Li9
S36<>LhaS3W>BH`aS3W>BH`aS3W><H`icTV<<H`icTV<<H`icS6<>Li9S36<
>LhaS3W>BH`aS3W>BH`aS3W><H`icS6<>LhaS3W><H`icS6<>Li9S36<>Lha
S3W>IU800S6<00U9S48@Oc9oofmkIcUBU2U:0000?goo00=:DT8@Ool0WGoo
00@2GgooOom:DP=JeP0EIcUJeP@QIU9g_GliIoUW<WliIoUo>FmkIoUo>FLi
OoUW>GliKg]o>FOi005o>@0000mo>FOiOcUWnGliIcUWnGliIcU_NgliIoUW
>GliIoT00Wli00=_Ne[F>Lh0>7oo00L0[7ooMkeJeU:D:DX0000oOol00d8@
BU9oo`2MOol02aLoIomg_DYBIcUBU5[FIcUJePaSIc800Vmk00Io>FmkKg]o
>FOiOcT2Kg/01gliIcUonFLiOcUWnGli005Wn@0000YWnGliKg]o>FLiOoU_
NgliIoUo>@9_N`08OcUWnGliKg]WnGliIc8YBSEoo`0:<U80[000BcUoofmk
IcUBU2U:000oOol00d8@BU9oo`2MOol0109OOomoodYB0e[F00IW>E[F125B
U7oiOcT2Kg/00gliIoUo>@02Kg/01WliIoUo>FmkOcUWn@9_N`5o>@0001Ao
>FOiOcUWnGliIcUo>FOiOcUWnGliIcUonFLiKg]o>FLiOoUJeRU:<Woo00eW
>@2/000ES6LiOomg_GooKg]W>DYB:DX0000oOol00d8@BU9oo`2MOol06QIO
MkeoodY<F]IW>E[FIcUVF@@QF]Ig_FOiOcUWnGliIcUWnGliKg]WnGliIoUo
>FmkOc83Kg/0000<Kg]o>FOiOcUW>GliIoUo>FmkOcUW>Goi0Vmk00Io>FOi
OcUg_FLb:DX_Ool01VOo5H`00@2/<Ha_N`=oo`07Kg]oofmkIcUBU2U:0000
?goo00=:DT8@Ool0WGoo00@3?fOoOom:DPAJeP08Ic8<He:DOoUo>FLiOcUW
n@9o>@03IcUonFLi009o>@05IoU_NfmkOcUWn@01OcT000=_N`03OcUWnGli
00=_N`0;IoUo>FLiOcUWnFmkOcUWnGliF]HaS00POol00c6B005oo`0:Ool0
1D8@00001D/iBU801Woo00M_NgooMkeJeU:D:DX0000oOol00d8@BU9oo`2M
Ool071IOOomoodYBF]IBU5[FIcU;>@@QF]Io>FOiOcU_NgliIoU_NgliIcUo
nFmkIcUo>FmkOcUWnGli0Fmk000027liKg]o>FOiOcUWnGliIoT2OcT00fmk
OcUWn@02OcT01FmkOcUg_FLb:DX087oo00<0[000Ool027oo00@0[0000I9W
>@Uoo`07Mkd01GooIcUBU2U:00005Goo00E_NgooMkeoogNm00Eoo`0:Mkeo
ogooMkeoob48<HaoofmkMkd3Ool01WNmOomoogoo5:DaS0Eoo`800006Oomg
_@00IcUoofmk0TYBUWoo00Ag_GooOomWo`Aoo`050Umoogoo@Q1W>@02F]H0
1FmkIU80YFIBOoT00Vmk00io>FOiKg]o>FOiOcU_NfLbOoUW>GoiIcU_Ngli
0FOi000056OiOcUWnGliIcUo>FmkOcUWnFLiOcUWnGliIoUW>GliIoUo>E[F
<H`QOol00fOoOomoo`04Ool016mk00D003W>37oo00M_NaF<OomW>DYB:DX0
0008Ool01AIIIomoofOo5UT017oo00Ig_@00F]IoocW>1242F]H04000Kg]o
o`00OolicRU:BU848DYBDY@006LiOol005[F0U:D00/0048@5:EooaBU001g
_Goo001:DPaS009oo`09001oogoo:DXaS7oo001JeT8@09Ioo`06<cl2Ggoi
Bcl2Gd/o0Woo00@G?fOoMke:DP=JeP0>IcUJePaSDYAg_FmkOcUWnGliIc9_
NgliIoUo>@9_N`03OcUW>Gob009_N`5o>@0001Ao>FmkKg]o>FOiIcUo>FOi
IcUonFmkOcU_NfLiOcUWnGliMkeJeRU:9Goo00EW>AB/0:D0036B00ioo`07
Kg/ETWoiIcUBU2U:00001Goo00/c>D/oOol2Ggoo5UUW?c<oOom;>C<o009o
o`0;000<HgooOol007oo001:DQBU@Q0aS002Ool01bU:<H`007oo001:DWNm
009oo`09125:DVLi001oo`00Ool004YB009oo`0::DX007ooOolQ22U:<Hao
obU:<H`2Ool00d8@BU9oo`0:Ool00c<oOomoo`02Bcl5Ool015:DOomoogNm
0Woo00=W>FmkOol00goo00QW>FmkOomJeWNmOom:DWNm0Woo00ABU7ooKg]J
eP9oo`04BU9oogNmF]H2Ool01d8@Oomooe[FOomW>E[F00Aoo`0?Mke:DWoo
OomBU7NmOom_Ne[FOomBU7NmOomg_E[F00Eoo`04BU9oogooDY@2Ool00dYB
Oomoo`02Ool01GNmDYAoogooBU800Woo00ABU7ooOom2409oo`03F]Ig_Goo
009oo`05IcUJeWooOom:DP02Ool02e[FMkeoofmkF]Iooe:DMkeoogNmF]H0
17oo00AW>GNmOomBU0Yoo`05<cm;?gooIol2G`02Ool03`9OOomoodYBIcUW
<TYIIcUJePaSIU9g_GliIoUo>@02Kg/00gliIoUo>@02Kg/00gliIoUo>@02
Kg/1OcT1Kg/0000>Kg]o>FmkKg]o>FOiOcU_NgliIcUonFLiOoUo>@=_N`03
OcUW<S6<02=oo`05Kg/<HaFB36=;>@0@Ool01gNm<I9oofLiDY@Q200000Eo
o`04<cT2GaIIIcl2Ool044/oOomooc<o0IUoofmk36<icP00Ool007oo@Q00
07oo0P0001iW>Goo@Q124000Ool000@QKg]oo`00F]Iooc6<DYAg_C6<:DYW
>@00Kg]oobU:@Q1JeWoo001oo`00Ool2:DX2Ool00dYB@Q1oo`04Ool03ALo
Bcmoo`9OOolc?`9OOomW?fOo0UmoogNm009oo`09IcTaS4YBOol005:DOol0
0248009oo`0i001JeSW>36=ooe:D<Hag_E[FDYAoo`@Q<Ha_NfLi>Li_Ne:D
BU9JeVmk:DYW>E[FBU9BU6Li<HaJeWNm@Q1g_Goo>LiJeWoo@Q1oofmk>Li:
DWNm001:DVmkBU8icWNm>Li247NmOol0048@IcU:DVmk008Q200BMkeJeT8@
F]IooaBU125g_C6<Kg]BU48@DYAJeSW>IcUBU48@0U[F00@004YBOolDY@9o
o`0M>LioogNm@Q1:DWoo:DY:DWoo001BU6LiDY@icWNm>Li:DVmkOol0048@
DY@007ooF]I247ooKg/YBP06Ool2Bcl2Ool011LoOomoo`9O0Woo00e245[F
IUUW<VLiF]H48E[FOoUo>FLiIoUo>@02Kg/00gliIoUo>@02Kg/01GliIoUo
>FmkIoT00Gli000057liIoUo>GliIoUo>FOiOcUW>GoiIcU_NgliIcUWnGli
Kg]onE[F<:`SOol00c65001oo`0COol01S9BOomJeU:D:DX000Eoo`085Umo
ogoo0UU;?c<iBcl2F@Aoo`06Mkd<HbU:MkdicP0017oo00I:DU:DOolQ2000
8@P2<H`02Goo>LhYBWooIcTYBQBUOomJeP04Ool01QBU>LioogNmOomg_@Ao
o`03Kg/006mk009oo`03@Q1:DWoo00=oo`0><cmW?d_o5Um;?`9OOom;?goo
5cmooc<o0UlG?`Aoo`03:DYoogNm009oo`=JeP05<H`Q27NmOolaS002Ool0
81BUOomoo`00BU9ooe:DOolQ25[F@Q1ooe:D8@Qooe:DBU9oofmk:DYood8@
DYAoob48001ooc6<F]IoobU:0002Ool012U:OomBU7Nm0Woo02TYBWoo<Hag
_E:D>LhaS5[F<HaW>DYBIcU_Ngoo36=_Ne[F8@Q:DR48OomJeT8@OomJeTYB
MkdicU[FOomg_BU:Oom:DWNmOomJeT8@OolQ2000009oo`0C:DYBU6mk<Hag
_E:DOomJeU:D@Q1oocW>Kg]BU3W>:DYW>Goo:DX00Woo00D006LiOolaS7Nm
00Eoo`9;?`9oo`0L5Umoogoo0cmoogNmBU9W>D/iF]IW>E[F36=BU7liIoUo
>FmkOcU_NgoiIcUo>FOiKg]o>FOiOcT2Kg/1OcT1Kg/0000DKg]o>FOiIcUo
>FmkOcUWnGliIcUonFLiOoU_NgliIoUo>FmkIc8aS1ioo`0900<0YGoo00Eo
o`05Iol0YE[F015oo`07005;?gooIcUBU2U:00005Goo00=g_GooOol04goo
00=g_GooOol04Goo00=244YBOol00goo00hc?fOoBclG?goo5cl2GfOoOol2
Ggoo5cmoofLo0Woo0WNm00<Q27ooOol00Woo01MBU48@OomJeQBUOom_NbU:
Ool006mkOol<HfLi@Q1ooe:DF]HYBT8@OolQ236<009oo`0;>LiW>FLi125o
oe[F:DYooaBUOolQ2002Ool01e[F8@Qood8@MkeoobU:009oo`0=:DYg_Goo
:DYooc6<@Q1g_Fmk5:Eoo`00Mkd00Woo00@aS7Nm36=BU09oo`0A5:EJeWoo
>Li:DWooBU9BU6Li<HaBU7ooKg/Q27ooKg/aS002Ool01bU:DYA_NcW>Ool0
07oo009BU00:<Hag_Goo>LiJeU:D<Haooc6<BU82Kg/02`aSOomg_C6<IcU:
DWoo@Q1ooe:D<H`01Goo00D2GfOoOom_NaLo009oo`045Umoogoo@Q03F]H0
1FLiF]H48FLbMkd00Vmk00io>FOiOcUW>GoiIcUo>FOiOcUW>FOiOcU_NfLi
0Goi000056OiOcUW>GoiIcUonFLiOcUWnGliKg]g_FLiOcUW>GliKg]onE[F
:DXNOol01VmkOom_N`00Ool0009oo`03005W>Goo00aoo`0:<cT01@015UTQ
27ooIcUBU2U:000oOol00dYB@Q1oo`04Ool00aIO<cmoo`03Ool01AIOIomW
od/o<cl01Goo00<48E:DOol00goo014DYFLiOomoo`00OolicT8@Oom:DP@Q
OomBU0aSOolaS0aS009oo`0736=JeWoo125g_Fmk12400Woo01X48FLiOol<
HfmkOol007ooF]H0048@Ool006LiOol48E[FOol005:DOol<HdYBOolaS3W>
0Woo00L007ooOol48Goo>LhDY@02Ool02PaSF]IooaBUKg]W>@aSOomBU0@Q
0Woo01d<HgooIcT48GooKg/007oo@Q00036<Ool006LiOolDYC6<Ool<HdYB
Ool004YBOolaS48@OolicS6<009oo`08125oodYB>LioodYB125oo`848@03
DYAoogoo00=oo`050Um;>GooMkdG?`02Ool05`9OOomoodYBF]IW<U[FIcUB
U0aSDYAonFmkOcUWnGliIcUonFLiOcU_NgliIoT00Wli00=WnGliIoT00Gli
000057liIoUo>FmkOcUW>GoiIcUo>FOiOcUW>GoiIcUonFLiOcU_NfLb<H`Q
Ool016LoOol00Fmk0Woo00<00FLiOol027oo00e:F@0P00D006Lo<UT0[02P
OomW>DYB:DX0000oOol00d8@BU9oo`2EOol00d/o5cm;?`02Ool04@9OOomo
oaLoIomood8@IcUVFE:DIcUJePaSDYAg_GliIoT00Vmk00ao>FLiOoUW>Goi
IcUo>FOiKg]o>FOiOcT1Kg/0000DKg]o>FOiOcUW>GoiIcUo>FOiOcUW>Goi
IcUonFLiOcU_NgoiF]HYBR9oo`03BcT007Nm00=oo`0300PES7oo00=oo`0A
MkeW>C9B1001TP05F]IW?`6BOol0[4YIOomW>E:D:DX0000oOol00d8@BU9o
o`2DOol01fOo0UlFGfOoOomg_ALo009oo`070UmoogoiBU9JeT/iF]H00VLi
01848FIBOoUW>GliIcUo>FOiOcU_NgNmIcUo>GNmIcUo>FmkOcT2Kg/00003
OcUWnGli00=_N`0>OcUWnGliIcUonFLiOcU_NgliIoUo>GNmDY@aS1ioo`06
IcUoofOoOolaQABU1Goo01H01DYBOomood8@5I80048@0Im;?fmk0:a;o`00
IcT007loMkeW>DYB:DX003moo`03@Q1:DWoo09Ioo`05MkeoogooMkdFG`02
Ool0709OOomoodYBF]IW<U[FIcUJePaSIc9_NgoiKg]o>FOiOcUWnGliIc9o
nFmkIc9onFLiOcUWnGli0FOi000016OiOcUW>FOi0Wli00iWnGliIcUonFLi
OcUWnGliIoUo>FLiKg]W<RU:6goo00MW>@03<U8007oo0:Eoo`02<I86Ool0
5@2U100EV@05BcTbFC<iOol00D/o0040YAB/0;8bC1FBOomW>E:D:DX0000o
Ool00dYB@Q1oo`2IOol027Nm5cmoogoo5cmWogooBU83F]H02fLiIUT0YFIB
MkeW>GliIoUo>FLiOcT016mk00Io>FmkOcUWnGliKg/1OcT0000DOcUWnGli
OcUWnFmkOcUWnGliKg]o>FmkOcUWnGliIcUonGliF]HaS1eoo`0700<aTQFB
001oo`2U:DX00goo01Q:DP2/005:FC9O0UUoo`2b<cT0048@000ES02/<UUo
?`2/BclQ27ooIcU:DRU:000oOol00d8@BU9oo`2EOol01WNmOomg_GooMkdF
G`9oo`0L5UmoogNmBU9W>E:DF]IW>FLb125JeWoiOcUWnGliIoUo>FOiOcU_
NgliKg]WnGliIoUo>FLiOoT1IcT0009_N`04OcUWnFLiOcT2Kg/037liIoUo
>FOiIcUo>FmkIoUo>GNmIc8YBR5oo`06Icl0YGooOol48@050P2/01IWoaF<
Ool001IO100ES06I0I9ooaB/Bol0[7Nm0IU:F@2UOomW>E:D:DX003moo`03
@Q1:DWoo09Eoo`06<cl2GfOoOomg_ALo0Woo00D3?gNmOom:DU:D009JeP04
IcUJePaSDY@2Kg/02WliIcUo>FOiOcU_NgliIoU_Ngli0Vmk00=o>FOiOcT0
0Fmk00000gliKg]Wn@02OcT03fOiOcU_NfmkOcUWnGliOoUW>GliKg]W>Goi
F]HYBP0ROol07@0536<0YAII5I9ooc655:`DY@0PBclDYFOo5:aoo`2/Iol0
[1FB021VF@000:aBU7ooF]IBU2U:0000?goo00=:DT8@Ool02Goo00EWoglo
OomWogNm00Yoo`03F]I_Ngoo009oo`03BU9oogoo00Qoo`03IcUJeWoo06]o
o`9;?`03Oomg_@<o009oo`0L0UmoogooBU9W>E[FDYAW>E[F125W<WoiKg]W
nGliKg]o>FLiOoUW<WliIoU_NgliIcUWnGliIcT1OoT00009IoU_NgliIcUW
nGliIcUonFLb009_N`03OcUW>Fmk009_N`04OoU_NfLb<H`OOol04T/iOomo
o`@0F]H1TT8@5I800C9I00=Wo`2bKg/0YFLo500D[0848@0<5:`0YAB/00E;
?`aSBcmonFLiDY@YBP009Goo00=:DWNmOol05goo00=244YBOol01Woo00Ag
_GooOol2G`9oo`03IolFGgoo00Aoo`0<<H`YBWNm>Lioo`00Kg]W>GooIcUg
_@000goo00E_N`00OomW>@aS009oo`03001g_Goo06Yoo`05Bom;?gooIolF
G`02Ool011IOOomoodYB0e[F00EW>E[F36=VDVOo009o>@04Kg]o>FOiOcT4
Kg/01WliIoUo>FmkOcUWn@5o>@0000Mo>FOiOcU_NgliIoUo>@02Kg/02gli
IoUW>GoiOcU_NglbKg]o>E[F:DX07Woo024ETP0POomJeR48BcT0239B5:a;
?`@QBcT0[39B000ETP03BcT03VOo0I9ooaFBIolD[7oo0I8D[7ooIcU:DRU:
000097oo00=:DSW>Ool067oo00=244YBOol01Woo00/2GgNmBclG?goo<cmo
oaLoOolc?`9O009oo`0<>Lh48@00:DYoodYBOom240@QMkeooe:D0Woo00YW
>@@Q001oo`00124Q27oo:DYg_F]oo`05Bclc?gooMkdG?`02Ool010<oMkeo
od8@15[F00eW>@@QDYAo>FOiIcUo>FOiOcUWnGliKg]o>@02Kg/01GlbIoUo
>FOiOcT00Fmk00001VmkOcUWnGliIoUo>@9_N`06OcUWnGliKg]o>FOi0fmk
00=onE[F<H`07goo02000gooIcT<HgooBUTDYE[F0:E:F@6<<I9:FFOo5UTb
FFOo<cT00AFB36<D[36B0HD00`@0<UUoofLiDY@YBP0097oo00<icVLiOol0
1Goo00<0048@Ool03Woo00@aS1BUDYA240Moo`0;5cl2Gd/o<cmooaLoOolc
?goo<cl2G`03Ool02@00@Q0aS7oo<HaooaBU124aS005Ool02CW>001oo`00
@Q048Goo5:Eg_@1[Ool01C<oBcmoogoo5Ul00Woo00@2GgooOom:DP=JeP9W
>@0>36=BU7oiKg]o>FOiOcUW>GliIoUo>FmkIoUo>@9_N`03OcUW>Gli005W
n@000Vmk019o>FLiOcUWnFmkOcUWnGliIcUonFLiOcU_NgliIcUg_FLb:DXQ
Ool07S6B0:Eoogoo>Lh0[1F<<I80[02U004DY@0P0:D004VI0:DETP6B5H`0
0@2b000bFABUOomW>E:D8@P402Aoo`03@Q1JeWoo00=oo`04BU8DYB48IcT@
Ool00d8@DYA:DP06Ool02FOo<cmoogoo0UmooaIOIol2G`05Ool01`@05:Di
cPaSOol006Li00Qoo`08>Lh007oo:DX007NmKg/48Faoo`9;?`03OomWoaLo
009oo`045cmg_GooBU84F]H03FLi101W<WNmKg]onFLiIoUo>FLiOcUWnGlb
009_N`05OcUWnFLiOoU_N`01OcT0009o>@03IoUo>FOi009o>@0=IoUo>FLi
OoUW>GliIoUo>FmkOoU_NfIB<H`08Goo00<00fLiOol00Woo01U_N`000:a;
?c9BIcl1S4YO<UU;?c<oIolD[36B50DETVOoIclETS6BOomW>E:D:DX0000T
Ool00d8@F]Ioo`04Ool00gNm8@Qoo`0?Ool013W>Oom:DT8@Ugoo00D2FD/i
OomonAIO009oo`050Umoogoo@Q1W>@02F]H036LiF]H<He:DOoUo>FLiOcU_
NgliIoUo>@=_N`05OcUWnGliKg]o>@02Kg/00003IoU_Ngli009_N`0?IoUo
>FmkKg]o>FLiOoUW>GliIoUW>GliOoUJeRU:01aoo`03IomoogNm009oo`03
00PbDWoo00Aoo`0600<0002U020ETP@00P2/00l080010001S02U0:`4002/
000ES7ooIcU:DRU:00003Goo00=g_GooOol057oo00=245[FOol01Goo00<0
07ooOol03Woo00A:DS6<DYA:DYEoo`07Iol2GaLoIomW?aIO5cl00Woo00@F
GfOoMke:DP=JeP0EIcUVDP2UIU9g_FOiOcUWnGliKg]o>FOiOcU_NgliIoUo
>FLiOoUW>Gli005_N`000Wli00A_NfOiOcUo>@9_N`05OcUWnGliKg]o>@02
Kg/01GliIoUo?fLb:DX06goo00M_N`00Bc80[7NmOol00007Ool00goi00DD
[002<UT01P0P000FDS6I<clbF@9:F@090I9WoaFBBUUoofLiDY@YBP0000=o
o`04MkeoogooMkd2Ool01D/oOomoofOoIcl01Goo00=JeWNmOol03Woo00=2
45[FOol05goo0U:D00=247ooOol0Tgoo00Ig_D/oBcmood/o<cl3Ool010<o
OomoodYB0e[F0VLi01<48E:DOoUo>FmkOcUW>GoiIcUo>FOiOcUWnGliIcUo
nFLiOcUWn@01OcT0000DIoUo>FLiOcUWnFLiOcUW>FOiOcUWnGliIoUo>FOi
OcUW>GoiF]HYBQ]oo`04BUT0YFLo0002Ool00`00Oomoo`05Ool00d/o0000
00020:D04AB/5I8bF@0PDY@004YI0000[32/<UTES7ooF]IBU2U:00000goo
00e;od/oMkeW?gooMkdFFFOoBcU;?c<oOomg_@03Ool01P00<Haoogoo000D
Y@9oo`07<Haoogoo5:EBU4YB<H`00Woo00=245[FOol03Goo00=JeTYBOol0
27oo00=244YBOol0WGoo00@2GgooOom:DP=JeP07IcUBU0aSF]Ig_FLiOoT0
0Vmk00AW<WoiIcUo>@9_N`06IcUonFLiOcUWnGli0FOi000057liKg]WnGli
IcUonFLiOoUo>FmkOcUWnGliKg]o>FmkOoU_NfLb<H`NOol015[FOomoo`03
17oo00HbFABU000aTWoiBcl200004AII5:`001FB001:G`6BBclaS0010:`D
YGooIcUBU2U:00000Woo00=W?d/oKg/00S<o00T1VFOoIomW?c<oOom;?`9I
<cl00Woo0U[F00DicWNmOom_Nd8@009oo`06000DYGooOolYBTYB0goo00I2
45[FOomBU0aS:DX28@P01RU:8@PYBRU:36<icP9oo`80009oo`09F]H<HbU:
:DXQ22U:8@QBU4YB09Yoo`09MkeoogooOol2GgooOoU246Li00=JeP07IcT<
He:DOcUonFLiOcT00Vmk00]o>FOiKg]o>FmkOoUW>GliIoUo>Fmk005o>@00
00U_NgliOcUWnGliIcUonFLiIoT00Wli00UW>FmkMkeW<WliIcUonFII:DX0
87oo00T0[39BOomW>@2/0000[4/iMkd017oo018000015UTETP6<5I840003
<U80/Woo0:`007ooIcU:DRU:0002Ool05aLoIcmoo`9IOolc?aII<UmoofLo
Bcm;>D/oIomoofLi001ooc6<MkeoodYB>Lh01Goo00ABU1BU125JeP9oo`03
@Q1JeWoo01Qoo`03@Q1:DWoo01=oo`9g_H=oo`03BclG?goo009oo`045cmg
_GooBU82F]H055:DKg]BU0@QIc9g_FLiOoUW>GliOoUW>GliKg]WnGliKg]o
>FOiOcT2Kg/1IoT00006IcUonFLiOcUWnGli0Vmk00Io>FLiIoUo>FOiOc82
Kg/017oiIcmW<S6<87oo00D400055H`004YI00Qoo`0BIol000000I800aB/
Bcl1S1FI0000Y@01MkeonFLiDY@YBP000goo00=;>AIOOol00goo00DG>FLo
<cU;?c<o00Ioo`05Mke247oo125W>@0;Ool00d8@F]Ioo`0HOol00dYB@Q1o
o`0COol00`00@Q1oo`14Ool00c6<125_N`06Ool00gNmOomoo`07Ool00gNm
Oomoo`0=Ool00gNmOomoo`02Ool017NmOomoogNm4Woo00=Woc<o0Ul00Woo
00@2GgooOom:DP=JeP0DIcUJePaSIU9_NgoiIcUo>GoiIcU_NgliIoUo>FLi
OcUWnGliKg]Wn@9o>@0000]WnGliIoU_NgliKg]o>FOiOcU_Ngli00=_N`06
OcU_NgliOoUBU2U:7Goo00D0YDYIOolbDP0000eoo`0@5:D0006B<UT0036B
0:a;?aFBBUUoofmkIcUBU248100EOol01000@Q1ooe:D0TYB00=244YBBU80
0TYB0T8@0Woo00=245[FOol00goo00L005:DOolDYGoo>Lig_@08Ool0148@
MkeBU48@0Woo00=244YBOol04goo00T006mkKg]W>ABU<Haood8@Mkd00U:D
00L<Hgoo<HaJeVmk001oo`02>Lh2F]H033W>Kg]oofmk>Li_NfLi<H`icU:D
8@Qoo`8icP9oo`0<DYAoob48Oom244YBF]I_NgNmOolaS5[F0SW>00<YBU:D
Mkd00U:D00a_NbU:@Q1JeSW>OolYBWoo5:E245[FDY@2Ool02@00125BU2U:
Oom:DWNmOom24003Ool027Nm<HaJeQBUMkdYBWooF]H2Ool03VmkBU8icS6<
Mke:DVLi<HaW>DYB@Q1BU7NmF]H2Ool05FLi5:EoogooDYAooe[F<HaBU7Nm
>Li2436<:DYoob48OolaS4YBOomg_@05Ool021LoOomooaIOIomood8@IcT3
F]H02FLi125JeWoiKg]o>FmkIc9on@03Kg/00gliIoUo>@02Kg/00gliIcUW
n@01OcT0009o>@0:Kg]o>FOiOcUWnGliIcUonFLiIoT2OcT01VOiKg]_Nfmk
Ic8aS1eoo`0300=:DWoo009oo`03005JeWoo00]oo`0?:DX00@03<UlES02U
00<YBP2UOom_NfLiDY@YBP0001Eoo`05Mke245[FDYA:DP07DY@01D8@Oomo
od8@DY@00goo00MBU248Kg]oodYB36=24009Ool00fmk5:DYBP03Ool00d8@
BU9oo`0COol05000Mkd48E:D001_Ngoo001JeS6<@Q0Q24YB<H`icU:D001o
odYB36<2BU800`@QKg]oo`02Mkd04d8@8@PicS6<F]H007Nm001BU7oo36<D
YGoo@Q1oo`00Kg/000aS009oo`0E001:DSW>36=247oo>LhYBR48Kg/DY@@Q
:DXaS5[F001oo`00OolDYC6<009oo`06001oogoo001oo`000VLi00X<Hd8@
OomoodYB125oo`00Ool0008YBP0<Kg]oogooMkd007NmOol007Nm001JeSW>
0R4800<006LiF]H00Woo01@007oo36<<HgNmOol007Nm<H`icR48F]H007oo
001oo`00@Q1oogNm17oo00QW?aIOOomoo`<oMkeoodYB0e[F00U_NfIB0:EV
DWNmOcUWnFmkOcT00fmk00Uo>FOiOcUWnFmkOcUW>GoiOcT00FOi000026Oi
Kg]_NgliIcUWnGliIoT2OcT02VmkOcUWnFLiOcU_NgliOoUJeRU:7Goo00=_
NfOoOol00Woo00=g_@00<UT037oo00hYBP000H`D31FB5H``/QF<OomW?fLb
BU8YBP0097oo00a246LiOomoofLi5:Eooc6<OolicT8@<H`9Ool025:D:DY2
47oo<H`icU:DBU8DOol0A000Kg/007Nm8@Qg_E:D001W>BU:IcTicTYB5:Da
S5:D001oocW>1252436<001_NgooMkeW>ABU<H`icRU:BU8006Li001g_Goo
@Q0<HgooDYA:DP00Mkd<HcW>F]Ioo`00DY@icRU:DYA_N`@QBU8Q27Nm000Q
21BU:DYBU000Ool002U:36<2Ool05Vmk001:DT8@001JeP00Ool0048@001W
>GooBU8<Hgoo36=_N`00:DX<H`000Woo00h007ooDYAoo`00Ool005:D8@PY
BS6<000YBP000Woo014007oo000Q20aS001:DWoo001:DP@QOolDYGNm5:E:
DR4800Moo`05OoT3?gooOolFG`02Ool06DYBF]IJeU:DIcUJePaSDYAonFLi
OcU_NfOiOcU_NglbIoUo>FLiOcU_NfOiOcUW>Fmk005o>@0000Mo>FLiOcUW
nGliKg]o>@02Kg/02fLiOoUW>FLiOoU_NgliIoUo>FLi:DX097oo00<0Y@00
Ool02goo00daTP005UTETP2/0H`00GooOoUW>E:D:DX0000TOol00cW>BU9o
o`04Ool00aBUMkeoo`0?Ool010005:EJeT8@57oo00TicVLiOolYBPaSOolY
BWoo@Q000SW>00`007ooIcU_NfLiBU9g_CW>IcUoodYBKg/3Ool01U[FBU9o
ocW>IcUBU09oo`0O001W>GooOom:DU[FOolYBWoo<H`YBWooBU9_Ne:DF]Io
o`00F]Iood8@Ool<HdYB@Q1oofmkBU9oodYBF]H00Woo00<Q26LiOol00Woo
00<aS48@F]H00U[F00Ag_E:DIcUW>@9oo`08IcT<Hgoo001JeWooMkeBU0=o
o`0:F]HYBWoo>Lig_Goo>Liooe[FIcT2Ool00d8@Oomoo`02DY@00fLiOomB
U002Ool0336<DYAJeU[FIcUoo`00Mkd007oo:DYBU0Ioo`08IolFGgooOol3
?gooMke:DP=JeP05IcUJePaSIU9g_@02Kg/00fOiOcU_N`02Kg/01GliIoUo
>FmkIoT00Wli0FOi0Gli0Fmk000056mkOoUW>GliIoUo>FmkOcUWnGliIcUo
nGliIcUo>FOiOcUWnFIB<H`UOol00d/i001oo`0;Ool0339B000ETP2/5UT0
/WooKg]W>E:D:DX002Eoo`03<Haoogoo00Aoo`055:Eg_FLiF]I_N`0;Ool0
0gNm:DYg_@02BU8GOol00c6<:DYoo`05Ool00c6<5:Eoo`0DOol00`00Mkeo
o`06Ool00`@Q>Lioo`05Ool00`00Kg]oo`0OOol00cW>001oo`0QOol00bU:
001oo`0:Ool02GNm5cmoogoo5UmWogoo@Q1W>@02F]H02VLiF]H48E:DOoUo
>FmkOcUW>Goi0fmk00Ao<VmkOoUW>@9_N`5o>@5Wn@5o>@0001Ao>FLiOoU_
NgliIoUo>FLiOcUWnGliKg]WnGliIoU_NgliMkeJeS6<9goo00<006LoOol0
2Woo00/aTP000I8D01IBOomo>FLiDY@YBP0002aoo`05@Q0aS3W>8@QW>@0>
Ool00dYB@Q1oo`2IOol01FOo5Umoogoo0Ul00Woo01U:DU[FF]IBU6LiF]H<
HfLbOcUWnGliIcUonFLiOcUWnGliKg]o>FLiOoUW>GliIoUo>@01Kg/00005
IoUo>FLiOcUWn@02Kg/03GoiIcUo>FOiOcUW>GliKg]onFLiOcUW<RU:02Qo
o`0300DES7oo00Yoo`0::DX0039O0:EoofLoIcUBU248100oOol00d8@BU9o
o`2IOol02GNm5cmoogoo5cmg_Goo@Q1W>@02F]H036LiIc801E[FMkeo>FOi
OcUW>GoiIcUo>@9_N`07IcUonFLiOcUWnGliIoT00Gli000057liKg]o>FOi
OcUW>GoiIcUo>FOiOcUW>GliIoUo>FLiKg]onFII:DXYOol00`050:Eoo`0:
Ool200001`2/OomonE[FDY@YBP0003moo`03BU9247oo06aoo`03MkdYBWNm
00eoo`03BU8DYGoo01Yoo`09MkdG?gooOol2GfOoOoU:DVLi009JeP09IcUJ
eP@QIc9o>FOiOcUWnGli009_N`0:OcUWnFmkOoUW>GliIoUo>FLiOcT1IoT0
000DKg]onFLiOcUWnGliIcUo>FOiOcU_NgliIoUo>FLiOoUW>FmkIc8aS2Yo
o`03<U800goo00Uoo`09IcT00001Oom_NfLiDY@YBP0003moo`03@Q1:DWoo
00ioo`07Kg]BU6LiF]IoocW>BU800goo00`aS7ooOomBU7ooBU9g_GooDYAW
>Goo<H`2Ool02FmkDYAooc6<OolaS6LiDYAg_@02Ool0136<MkeW>FLi0Woo
00I247oo:DYooc6<IcT2Ool026mkF]I246LiDYAooe[FIcT2Ool00d8@IcUo
o`02Ool026Li@Q1_Ne:DKg]:DWoo>Lh4Ool01SW>OolYBVmkBU9W>@9oo`04
BU9g_GooMkd2Ool01dYBMke:DT8@OomW>DYB00Aoo`0;F]IoobU:Oom_NcW>
MkeBU7oo36<00002Ool02fmkF]I:DWooF]Iood8@Oom_NbU:Mkd03Woo00Eg
_@9OOomooaIO009oo`0>@Q1JeU[FF]IW>E[F125JeWNmOcUW>GliIoUo>@9_
N`09Oc9_NfmkOcUWnGliMkeo>Fmk005o>@0001Ao>FLiOoUW>GliKg]o>FOi
OcU_NgliIoUo>FLiOoUW>GliMkeW<RU::goo00=:F@00Ool02Woo00L003W>
OomW>DYB:DX0000NOol00gNmOomoo`0NOol00d8@BU9oo`0>Ool04CW>0000
0000OolaS5:DOolQ2000Kg/007Nm125BU248Ool00R4800i24000Kg/002U:
5:DicT8@125JeTYBOom240000Woo00/<H`00DY@YBQBU36=BU248:DXicU:D
009oo`08IcT007oo001oo`00>Li240Aoo`0<124007Nm125:DQBU@Q0Q25:D
124YBVLi0Woo00MW>@00F]HQ22U:IcT00002Ool02`aS@Q1oogoo001oobU:
<Haooe:D00000Woo01`006LiOomJeP00Ool006mk001_NaBU<HaBU1BU8@QB
U2U:@Q048Goo001W>B48DY@YBWooKg/000moo`05MkdG?gooOol3?`02Ool0
3dYBF]IJeU[FIcUVF@2UIU9onFLiOcUWnGliIoUo<P03Kg/01gliIoU_Ngli
IcUWnGli005_N`0000QWnGliIcUonFLiOcUWnGli0Vmk00YWnGliKg]onFLi
OcUWnGoiIUTaS2aoo`03Mkd00D/i00Uoo`07BUTES7ooIcUBU2U:00007Woo
00=g_@@QF]H037oo00=W>E[FOol017oo00=BU1BUOol01Goo00EW>FmkOom2
44YB00moo`08BU800000125oodYBOolaS0848@0GMkd007Nm5:E24248000Y
BVmkBU8006mk124Q236<>LiBU1BUBU9oofLi001g_@02Ool02T8@1252436<
36<DYFLi8@Q:DQBU0goo00UBU000Ool007oo000YBP@Q00000Woo01P<Hd8@
Oomoo`00Kg/DYE:D<Ha:DR48000Q20@QOomJeP00IcTQ22U:F]H007ooMkd2
00006ABU@Q0<Hgoo00048@00Ool007oo124DYGNmOomW>@00Ool006Li001g
_@aS<Ha:DQBU008Q2006BU924000Mkd006mk0RU:00@icP00Ool000moo`08
MkdFGgooOolFGfOoOom:DP=JeP09IcUW<P@QF]Ig_GliIoUo>FLi009_N`04
OcU_NglbIoT2OcT016OiOcU_NfOi0Gli00000gliKg]o>@02Kg/016OiOcUo
>FOi0Wli00EW>GoiIcUo>FOi009o>@03F]HYBWoo02eoo`03000aTWoo00Mo
o`07Kg]oofmkIcUBU2U:000027oo00Dc?fOoOomooc<i00Eoo`08F]HicU[F
BU9g_E:DOolaS09_N`03@Q1oogoo00800008DYA:DWooIcUJeTYBOolaS09o
o`07@Q1oo`00IcUoobU:DY@00Woo00@Q21BUOolaS09oo`07@Q1W>@00DYAo
odYB@Q003goo00/icP00000007ooIcTicRU:OomW>B48009_N`0R125ood8@
Kg/icP@QMkeoocW>@Q1ooc6<>Lioo`00MkdYBVmk36=247NmOolQ236<IcTY
BWooBU8YBWoo5:EJeRU:IcT2Ool02000Ool006Li>Liood8@DY@2Ool03P@Q
>LiBU3W>@Q1oo`00IcUBU2U:OomW>CW>IcT2Ool2>Lh017oo8@Q:DRU:0Woo
01eJeTYBOol48Goo@Q0icU[FKg]2436<Ool007oo5:Eg_Goo@Q0icWNm:DYJ
eVmk:DYg_C6<F]HaS248009_N`0;8@QW>C6<Kg/48GooBU9BU7Nm5:E_N`0>
Ool01GNm5cmoogoo0Ul00Woo01=246LiF]IBU6LiBcT<He:DOcUWnGliIcUo
nFmkOcUWnGliIoUo>@02Kg/016LiOoUW>Gli0Fmk00002fOiOcUWnGliKg]o
>FOiIcUo>FOiOcT00Vmk00Mo>FOiOcUWnFmkIc8aS00_Ool00aF<00Eoo`06
Ool01fmkOom_NfLiBU8YBP0000Eoo`0;Bcmg_Goo5UU;?c<oMkdFGgooMkeW
?`02Ool04T8@001_N`00Ool005[F001oo`00OolDYB48BU9_Nc6<001oo`84
8@09001W>ABUMkd0036<Mkd007oo009g_@0<000DY@00DY@icRU:>LiooaBU
<Ha_N`@Q0Woo00=244YBOol03Woo00Yg_E[FKg]W>GooDY@007oo001_N`=o
o`06Kg]oogooOol0036<1goo00=W>@00Ool01Woo00<003W>Ool01Goo00<0
04YBOol01Goo00<007ooOol0@7oo00=g_GooMkd04goo00LFGgooOolG?fOo
Mke:DP03F]H036LiIUT48FLbMkeo>FOiOcUW>GliIoUo>@=_N`06Oc9WnGli
IcUonFLi0Gli00003GliIcUo>FOiOcU_NfLiOoUW>GliIoU_Ngli009_N`05
OcU_NgoiIUTYBP0`Ool00cW>00=Wo`05Ool01fLiOom_NfLiDY@YBP0000Eo
o`0;<Ul2FAIOBcmooaIIOom;?goo5Ul1V@02Ool00gNm<Haoo`0200009SW>
DY@007oo000<HaBU<H`YBQBU8@P002U:Ool007oo5:D<HgNm36<005[F001o
ogNm001W>Goo000icPaS5:D006Li000aS5[F36<2Ool00d8@BU9oo`0COol2
Mkd00gooDYAoo`07Ool00fLiOomoo`06Ool00gNmKg]oo`06Ool00fLiOomo
o`04Ool00gNmKg]oo`06Ool00fLiOomoo`1EOol01D/o5cmoogoo0Ul00Woo
00U:DU[FF]IJeVLiIc848E[FOcT00fmk00=o>FOiOcT00fmk00Mo>FOiOcUW
>GoiKg]o>@01IoT00009Kg]onFLiOcUWlWliKg]o>FOi009_N`09Oc9WnGli
IoUW>GliKg]W<S6<035oo`03IcT0048@00Aoo`07Kg]oofmkIcUBU2480000
1Goo00XG>D/oOolbFFOoMkdbGc<iOomWo`=oo`08<H`0048@Oom_Ngoo8@P<
H`9oo`04Kg]oogooMkd2Ool2Mkd01GooMkeoo`0012400Woo00E_Ngoo001:
DWoo00800004:DYoogNmOol2Mkd02Goo000YBWoo001247oo@Q1:DP2IOol0
0d/o0ITG?`02Ool01ALoMkeood8@IcT00U[F00]W>E[F36=BU7oiKg]o>Fmk
IoUo>FOi009o>@08IoUo>FmkKg]o>FLiOcUWn@5o>@0000=onFLiOcT00Vmk
00mo>FmkIoUo<VmkOcU_NfLiOoUW>GliKg]onE[F:DX0<goo00<0[1F<Ool0
0Woo00MW>GooKg]W>E:D:DX00005Ool026LoOomg_C<oOolc?gNm<clQOol0
0gNmOomoo`0>Ool00dYB@Q1oo`2HOol00d/oMkeoo`02Ool0109OOomonDYB
0U[F00mBU6LiF]H00fLbMkeo>FOiKg]o>FmkOcUW>FOiOc800Vmk00Eo>FOi
OcUWnGli005_N`0000M_NgliIoUo>FmkIoUo>@02Kg/00gliIoUo>@02Kg/0
1WliIoUo>FmkIc8aS3Aoo`0;5:D01GooOom_NgooKg]W>DYB:DX0000oOol0
0d8@BU9oo`2MOol011IOIomoodYB0e[F00aW>E[F36=BU7NmOcUW>GoiIcUo
>FOiOcT2Kg/01gliKg]WnGliKg]o>FOi005o>@0000=o>FOiOcT00Vmk00Io
>FLiOcU_NfOiOcT2Kg/01gliIoUo>FmkOoUJeRU:03Eoo`0:<U800fmkMkeo
ofmkIcUBU2U:000oOol00d8@BU9oo`2HOol00gNmOomoo`02Ool01@<oOomo
od8@IcT00U[F00]W>E[F36=VDWoiIcUonFLiOcUWlWli009_N`08OcUWnFmk
OcUW>GliIoUW>@5o>@0000U_NgliIoUo>FmkIoUo>FOiOcT00Vmk00Uo>FOi
Kg]o>FLiOcU_NfLb<:`0=Woo00U:F@00DYAoogNmF]IBU2U:0000?goo00=2
44YBOol0WGoo00@2GgooOom:DP=JeP08IcUW<P05Ic9g_GliIcUon@=_N`0:
OcUWnFmkOcUWlWliIoUo>FmkOoT1IcT00008IoUo>FLiOoU_NgliIoUo>@9_
N`0:OcUWnFLiOcU_NgoiIcUonE[F<H`hOol01`01Oomo>FLiDY@YBP0003mo
o`03BU9247oo09eoo`045cmg_Goo@Q03F]H01fLiF]H48E[FOcUWnGli00=_
N`04OcUWnGliOcT3Kg/017liIoUo>FLi0Gli000017liIoUo>FLi0Vmk00io
>FmkOc9WnGliKg]onFLiOcUW>GoiIcUW<RU:>7oo00M_NgooKg]W>DYB:DX0
000oOol00d8@BU9oo`2MOol05P9OOomoodYBIcUJeU:DIcUJeP@QF]I_Ngli
IoUo>FmkOcUWnGliIoUW>Gli0fmk00=o>FOiOcT00FOi00001FLiKg]_Ngli
IoT00Wli00eWnFmkOcUWnGliIcUo>FOiOcU_NgoiIUTaS00hOol01fLiOom_
NfLiDY@YBP0003moo`03@Q1:DWoo09Qoo`03Kg/2G`9O009oo`040Umoogoo
BU83F]H05FLiF]H<HfIBOoU_NgliIoUo>FOiOcU_NfLiOcUWnGliKg]o>FOi
OcUWn@01OcT00008OoUW>GoiIcUo>FOiIcUo>@9_N`0:Oc9WnGliIcUo>FOi
OcU_NfLb:DXhOol01fmkOom_NfLiDY@YBP0003moo`03@Q1:DWoo03Aoo`03
001W>Goo06=oo`075Umoogoo5cmoogNm@Q001E[F00T<HfLbKg]o>FOiOcUW
>GliIoT00Wli00AWnGliIoUo>@=_N`5o>@5_N`0000Y_NgliIcUo>FOiOcU_
NgliIoUo>@=_N`07OoUW>FmkKg]onE[F<H`0>7oo00MW>GooMkeW>DYB:DX0
000oOol00dYB@Q1oo`0dOol00`00IcUoo`1SOol023<oMkeoo`9OMkeooe:D
IcT2F]H05FmkDY@<HdYIOoU_NgliIoUo>FOiOcUW>FOiOcU_NgliIcUWnGli
Kg]o>@01IoT0000DOcUWnGliIoUo>FLiOoUW>GliIoUo>FmkOcUW>GoiKg]o
>FmkIc8YBSQoo`07Kg]oofmkIcUBU2U:0000?goo00=244YBOol04goo00<<
HgooOol00goo00<<HgooOol00goo00=W>@0036<017oo00H0036<@Q1247oo
1242Ool02P00Kg]oo`@QIcUoo`00Ool<HaBU0Woo00=:DP00Ool00Woo00<0
03W>Ool017oo00LaS0aSOomoofmk001g_@02Ool00c6<001g_@03Ool01P00
>Lioogoo000DY@9oo`05BU848Goo001BU003Ool00e[F00124004Ool00`aS
001oo`02Ool01B48<Haooc6<:DX097oo00lG?gooOolG?fOoOomJeWooMke_
NgooMkd006LbOcT00Vmk00Eo>FmkOcUW>Goi009_N`07IcUonFmkOcUW>Goi
IcT00Gli00001VOiOcU_NgliIoUo>@=_N`0;OcUWnGliIcUonFLiOcUWnGli
IcTYBP0hOol01fLiOomo>FLiDY@YBP0000Uoo`05<cmoogooIom;>@04Ool0
15:D:DYooe:D0Woo029:DPaSMkeoocW>OomJeQBUOolQ236<OolDYFmkOola
S2U:Oom:DSW>Ool<HcW>OolaS48@Ool<HcW>OolicTYBOol<H`9oo`05IcUo
ogooBU92400DOol00`0036=oo`02Ool00c6<001oo`03Ool01B48000icPaS
00000Woo00L007ooF]H004YBOol00002Ool03P00IcUoo`00BU9oo`aS000a
S000:DYoobU:0002Ool01000:DX0000017oo00P48@00Oomoob48001_Ngoo
0P0001TaS000OomoocW>001g_Goo00048ABU001oodYB00048ABU001JeWoo
8@P003W>000YBP02Ool200002B48001oogoo000<Hgoo001:DP0TOol01QIO
Mkeoo`9OOomo>@D0000B>LhaS4YBKg]WnGliIcUonFLiOoUW>GliIcUonFLi
OcUWnGli0Vmk0Gli00002gliIoU_NfmkOcUWnGliKg]o>FOiOcT00Vmk00Mo
>FOiOcUW>GNmIU8aS00hOol01fLiOomW?fLiDY@Q20@000=oo`0;Bclc>Goo
Bcm_Ngoo0UUoogNmBclG?`03Ool017NmKg]244YB0goo021243W>Oom24000
Oom243W>Kg]oofLi:DYoo`aSOol<HgooBU9_NdYB:DYoofLi8@Qood8@<Hao
ofLi5:EoobU:0Woo00LDYGoo:DYBU7oo@Q1:DP0EOol50004Ool00gNm001o
o`02Ool02SW>001oo`00@Q1oo`@QBU9oo`000Woo00P006LiOol005[FOol0
06Li0Woo00L007ooDY@007oo:DX48@07Ool010aS001oogNm0P0000=ooe:D
00000Woo00QJeP00OolYBPaSOolicP0017oo00Q24000OomoocW>8@Qoo`00
0goo00@007Nm<H`0009oo`07:DX007oo36<aS4YB36<09Goo00@G?gooOol2
G`9oo`0IBcUW>E[FOolaS1BU<HaW<WNmOcUWnGliIcUg_FmkOcUWnGliKg]o
nFLiOcUWnGliKg/00FOi000056OiOcUW>GliIoUo>FLiOoUW>FmkOcUWnGli
IoUo>FOiOcUg_FLb:DXhOol01fmkOomonE[FDY@YBP00009oo`0>BcU;?goo
5Ulc?`9IIomW?goo5UmoofLo0UTbG`=oo`03:DYW>Goo009oo`06IcU_Nfmk
@Q1JeWoo0VLi00eooc6<>LioofLi001W>Goo@Q1_Nb48>Lioo`02<H`2Ool0
2B48OolaS48@Oom242U:Oom24002<H`00goo>Lioo`02BU8EOol01@00125o
o`aS00001goo00Ag_FLi000DY@9oo`06124Q2000F]Ioo`000Woo00P006mk
Ool004YBOol007Nm0Woo00D005:DIcT007oo0080000336<0000000Aoo`09
36<007oo001g_@00Ool<H`0000=oo`08001ooe[F001ooaBU00048@80009J
eP07001oogooBU8407oo00000goo00@007Nm00048@9oo`04F]H007oo>Lh2
000VOol07aLoMkeooaLoOomg_E:DIU9BU7Nm<H`Q236<BU9o>FOiOcUW>Goi
IcUo>FOiOcUWnGliIcUo>FOiOcUWnFmk005o>@0001Ao>FOiOcU_NgliIcUo
nFLiOoUW>GliKg]W>GliKg]o>FLiOoUJeRU:>7oo00MW>GooKg]W>E:D:DX0
0002Ool03S<oBcUWoaIIOom;?aII<cUoo`9IOclG>GNmIol2Ool00fmk8@QJ
eP03Ool03B48:DYooe:D001ooaBU<Haoo`00OomBU2U:009W>@078@QW>C6<
F]IW>Goo00000Woo015_NbU:Kg/007ooBU9BU48@IcTYBVLi@Q1oo`aSOom2
44YB01Eoo`05F]H48Goo8@Q24006Ool3000015:DOomoo`000Woo01X48CW>
Ool0048@F]H002U:Kg/006mkOol000@QMkdaS000OolicP00Oomg_@00OolQ
20@Q17oo01048BU:F]H<Hgoo001g_Goo001JeWNm000DYGoo<H`0009oo`0A
001ooe[F001ooe:D001:DWNm000aS7oo000aS7Nm5:D00002Ool02000IcU_
N`00BU9oo`@Q5:D28@PUOol06QIOOomoo`9OOomonC6BBU9245[F:DXQ236<
DYAg_GliIcUonFLiOcUWnGliIcUo>FOiOcT2Kg/2OcT1IoT1Kg/0000DKg]o
>FOiOcUW>GoiIcUo>FLiOoUW>FmkOoUW>GoiIcUonFmkIc8aS3Qoo`07Kg]o
ofmkIcUBU2U:00000goo00=;?c<oOol00goo00DFGgoo<cmWod/o00Aoo`03
BU8aS7oo00=oo`0H>LiBU7ooOolaS7oo>LiJeWoo<H`icWooIcTYBWooDY@Y
BWooMkdDYGoo>Li247oo0T8@00mooc6<@Q1ooe:D>LioodYB@Q1ooc6<:DYo
odYB@Q005Goo00Eg_@00Ool005[F00Eoo`04000aS7ooOol2F]H00goo8@P0
00020002Ool01`00>Lh002U:DY@0048@009oo`08000DY@00001W>Goo@Q00
009oo`0336<0000000Eoo`098@P00000Oom_N`00Kg]oofmk0080000336=o
oe:D008000038@Qooe:D00800007Kg]oodYB000Q200010000goo00<<H`00
00000goo00ABU000000YBP9oo`05100Q27oo0012400TOol01QLoOomooaLo
Iomoo`9_N`0@IcUood8@8@PaS6I<MkeW>GoiKg]o>FOiOcUW>GliIoT2OcT0
16OiOcUW>FOi0Wli0002Kg/01GliIoUo>FLiOoT00Vmk00Io>FOiOcUW>Fmk
OcT2Kg/00gliF]HYBP0hOol01fLiOom_NfLiDY@Q200003moo`03@Q1:DWoo
01Eoo`03>Lh0036<00Ioo`06:DX0836<36<006Li0Woo00=g_CW>Ool00Woo
00IW>GooMkeg_GooIcT3Ool00fLiOomg_@03Ool00c6<001oo`02Ool00fLi
Oomoo`04Ool01aBU001BU7ooDY@006mk00=oo`06IcUoogooOolYBP000goo
00Q_NgooOomooc6<001oofLi1Goo00=W>GooOol017oo00U_NgooOomoo`00
36=oofmkF]H097oo014FGgooOol2GgooOcTQ24YB@Q1JeR48:DXaS5:DOoUo
>FLi009_N`0<OcUWnGliIoUo>FOiIcUo>FOiOcUW>FOi0Gli000056OiOcUW
nGliKg]WnGliIcUonFLiOcU_NgliOoUW>FOiOcUg_FLb<H`hOol01fmkOom_
NfLiDY@YBP0003moo`03@Q1:DWoo01Eoo`03Kg/005[F00Moo`03F]H00000
01Qoo`03@Q0007oo00Uoo`0736<007ooOomW>@00Kg/027oo00=W>GooOol0
1Goo00=24000Ool04Goo00<48@00Ool09Woo00LG?gooOol2GgooMkd00003
12404`00>LhYBU:DOcUWnGliKg]o>FOiOc9_NgliKg]W>GoiKg]o>FOi009o
>@5Wn@0000Eo>FLiOcUWnGli009_N`0=OcUW>GoiIcU_NfOiOcU_NgliIcUo
nE[F:DX0>7oo00MW>GooMkeJeU:D:DX0000oOol00d8@BU9oo`2IOol027Nm
<cmg_Goo5cmoogNmKg/3Ool0448@8@PaS5:DKg]o>FOiOcUWnGliKg]WnGli
Kg]o>FLi0Vmk00=o>FOiKg/00Gli000016mkOcUWnGlb0Vmk00io>FOiOcUW
>GoiIcUo>FLiOoUW>GoiKg]VDS6<>7oo00M_Nb48OomW>E:D:DX0000oOol0
0dYB@Q1oo`2IOol02VLo0Umoogoo0Umg_GoiKg/DY@000T8@00PQ236<BU9o
nFmkOcUWnGli0Vmk00Mo>FLiOoUW>GliIoUo<P02Kg/1OcT1Kg/00003OcUW
nGli009_N`0?OcUWnGliIoUo>FLiOoUW>GliIcUonFLiOoUJeRU:03Qoo`07
Kg/007ooIcU:DRU:000027oo00EWogooMkeoofLo00Qoo`03Kg/icWoo00Ao
o`03IcUoogoo00Qoo`03>Lig_Goo01Eoo`03@Q1:DWoo09Qoo`0AIol2GaII
Oolc?`9OOomo>DYBF]HDYGNm<H`Q236<IU9on@04Kg/00gliIoUo>@02Kg/0
0gliIoUo>@02Kg/1Oc81IoT1OcT0000DIoU_NgliIoUo>FOiOcUW>GliIoUo
>FLiOoUW>GoiIcUo>GloIc8YBPMoo`05BcmoogooIcm;o`0JOol00e:DIcUo
o`0:Ool00dYBDYAoo`02Ool01gNm8@QoofLiDY@YBP0000Qoo`055UUW?goo
IolFF@04Ool03E[F<HaoofLi8@P007oo>LioocW>Oom:DP0000=oo`08Mkda
S7oo@Q0icWoo000DYAIoo`03@Q1:DWoo09aoo`06IomoogooOomBU6mk0Woo
00HYBPaS>Li:DWNmOc82Kg/027liIoUo>FOiKg]o>FOiOcT2Kg/00gliIoUo
>@01IoT0000DOcU_NfmkOcUW>GliIoUo>FmkOcUWnGliKg]o>FLiOoUW>Goi
F]HYBPAoo`0>Bcmooc<o5cmW?d/oIolFFGooIcmWogooKg/Q209oo`06IcTQ
248@Oom241BU0Woo02<DYC6<OolQ248@OolaS1BUOomJeP00OomBU1BU>Lio
oe[F8@Q_Ne[F<Ha245[F001247oo:DXaS2U:Oomg_E[FDY@YBP0000Eoo`0F
<UU;?fLo0UUooc<oMkdc?goo<cT2FGooIcUJeRU:125W>C6<Oom240005:D2
Ool034YBOomood8@<H`005[F8@P007Nm@Q0YBQIoo`03BU9245[F00ABU003
F]IBU6IB009BU006F]IBU6IBDYAJeVIB0e:D00EJeVIBDYAJeVIB00=BU005
F]IVDU:DDYAVDP03DY@00fIBF]IBU003DY@00fIBF]IBU002DY@01FIBBU9B
U4YBIU800U:D00A:DU:DBU9:DP9BU008BU9BU4YBIU9:DU:DBU9VDP9BU00:
IU9BU5[FIU9BU5[FIU9BU5[FIU83DY@014YBDYA:DU:D0TYB00ABU4YBIU9B
U09:DPEBU003BU9BU5:D009:DP9BU09:DP04DYA:DU:DIU82DY@00dYBDYA:
DP02DY@02DYBDYABU4YBIU9BU6IBDYAW<P04DY@01E[FIU9BU5[FIU800e:D
00=JeVIBDY@00U:D01AVDU:DF]IBU6IBF]IBU6IBF]IVDU[FDYAVDVLbF]IB
U3W>BU8icU:D0S6<00<YBVIBMkd00Vmk00Eo<VOiOcUW>Gli009_N`05OcUW
nGliIoUo>@02Kg/1OcT0009_N`0=OcUWnGliIoU_NgliIoU_NgliIoUo>FOi
OcT00Vmk00=g_FLb:DX017oo00<2GaLo0Ul00Woo00@G?gooBcmoo`82G`04
OomW>@00BU82Ool07@00MkdicR48@Q048Goo001g_GooBU8DYCW>:DX<HbU:
Ool007ooIcUoo`00F]Ioo`00Ool48E[F36<00SW>00]W>GooOol006mkOom_
NfLiDY@YBP0000Eoo`0;<cl2FC<oBcmooaIIOom;?goo<clFG`02Ool01aBU
36=oocW>:DYooc6<00800003IcUoogoo00=oo`08<H`006Li>LhQ26mk>LhQ
21Ioo`06F]HicS6<<H`icRU:8C6<0RU:00<aS2U::DX0136<00=:DU[FDY@0
1U:D0U[F25:D00IW>CW><H`aS3W><H`2:DX0136<:DXYBS6<0bU:00=JeU:D
F]H015:D00=JeU:DF]H00e:D00=JeU:DDY@00e:D00EJeU:DDYABU5[F00=B
U003F]IBU5[F00<aS003@Q1JeU:D00IBU006F]I:DRU:>LhaS1F<4S6<0RU:
00@aS2U::DXicP8aS003>LhaS36<00<aS00<>Li243W>@Q0icTYBIcT<He:D
OoU_Ngli0fmk00Qo>FmkIoUo>FOiOcUW>Gli0Vmk0Gli0Fmk00001WliIoU_
NgliKg]o>@9_N`0<OcUW>GoiIcU_NgliIoUo>FmkOcUJeS6<17oo00D2Ggoo
Bclc?gNm009;?`0;5cmoofOoMkeooe:D@Q0aS0@QOol00002Mkd01@@Q001g
_E[F00000goo01048FmkDYAoo`00Mkd007ooIcTQ25[FOolicP00Ool<H`80
000=Ool007ooOolDY@00:DYoogliIcU:DRU:00001Goo00PFGgooOol2FFOo
0Umg_@9I17oo00IJeP00OolQ22U:000:Ool026Li001W>BU:5:E_N`00>LhF
Ool025:DBU9W>E[FDYAg_D/iIU82DY@015[FDYABU5[F1E:D00EJeU:DDYAB
U5[F00=BU009F]IBU5:DDYAJeU:DF]IBU5[F009BU00:MkeoogooMkeoogNm
DYAJeVLiKg/2000030@Q36<48@@Q36<48@0036<48@@0124<H`848@0936<0
0000001JeVmkDYAW>Goo009_N`03IcU_Nfmk009_N`04OomW>@0010050000
1P@0000<H`0P000080D00004004<H`@Q004700001P@QKg]JeWNm:DX0008<
H`848@0936<00000000icWNmDYAJeWoo009BU003F]IBU5:D00EBU007F]IB
U5:DDYAJeTYBKg/00Woo0WNm00=oofLiDY@025[F01YBU5[FF]IJeU:DIcUJ
ePaSIc9_NgliIoUo>FmkIcUonFLiOcUWnGliIoUo>FOiOcU_NfOi0Gli0000
56OiOcUo>FLiOoUW>FOiOcUW>GoiIcUo>GNmIcUo>FOiOcUg_FLb:DX4Ool0
24/oOomooc<oIom;?fOo<cl4Ool00e:D00000002IcT00`00IcUoo`03Ool0
1e[F001oogoo00048Fmk0080009oo`08001ooe:D36<005[FOolaS0Eoo`03
000DYGoo009oo`07IcUoogNmF]IBU2U:000097oo00=:DU[FOol067oo00a:
DTY<F]IBU5[F<Hao>FLiF]IW>E[FOol2F]H2IcT055[FIcUW>E[FIcUJeVLi
F]IW>E[FIcUJeVLiF]IW>E[FIcUJeVLiF]H2IcT01b48:DXYBS658@QBU6mk
009:DP03F]IW>E:D009W>@0:MkeJeU:DIcUg_@@0BU9W>FmkF]H4IcT01GNm
100icU[FKg/00PaS00=_Ne[FIcT00VLi00MJeTYB@Q1g_E:DBU9JeP03IcT0
1e[FDYAJeP00Mke:DU[F00AW>@9JeP04101W>E:DF]H2IcT035[FKg]BU6Li
001:DVmk@Q1_Ne:DF]IVDP=JeP05DYA_NcW>101_N`02DY@00c6<Kg]W>@02
F]H2IcT035[FIcUW>FLiF]IW>E[FIcUJeVmk@Q0<H`8aS009:DXaS6mkDYA:
DU:DBU9BU4YB00EBU00:BU9BU5:DDYAJeQBUBU9g_FOiOc82Kg/037oiIcUo
>FOiOcUW>GliKg]o>FOiKg]o>@5_N`000Vmk019WnGliIcUonGliIcUonFLi
OoUW>GliIoUo>FLiKg]onE[F<:`WOol00gNmOomoo`0>Ool01fmkOom_NfLi
DY@YBP0003moo`07DYA9TU:DBU9oo`00F]H017oo00=BU7ooOol067oo00PD
Y@@Q5:DQ20aS001g_E:D0TYB00=g_FLi36<00P000R4800h007oo36=JeWoo
100000aS124005:DOol<HcW>0VLi0RU:00A_Nb48<H`aS08Q200?IcU:DVLi
IcUJeU:DF]IW>E[FDYAW>GNm001oofLi009:DP03Kg]JeU:D009_N`03001W
>Fmk00=JeP0HIcUBU6LiMkd405:DIcTbDWooBT`0036<8@PYBP00IcUoocW>
5:EW>E[FDY@007li3goo00YW<P008@P<HbU:000aS7oo@Q1JePABU003BU9B
U5:D00ABU006Bc9VF@aSIc9o?gli0Vmk00eo<VmkOoUW>GliIoUo>FOiOcUW
>GliIoUo>@01IcT0000DOcU_NgliIoUo>FmkIcUonFLiOcUW>GliIoUo>Fmk
OcUWnGliIc8aS3Qoo`07IcUoofmkIcUBU2U:0000?goo0TYB011JeTYBMkd0
07oiKg/icWNmIcT400aSOom:C000OcTicQEoo`0<IcUoogooKg/48FLiDYA:
DU:DOolDYC6<0P00010DYDYB001oo`aSF]HQ21BUBUU:C6Li8@P007oo5HDa
S09W>@0S8@PaS7Nm000<H`@Q36=W>E[F@Q1_Ne:DF]HicP00124002U:MkeB
U000Kg]BU6IB36<400aS005:DVmk001JeVmk<HD0000236<04`00@Q1g_@00
BU9W>DVBOoTaS0aSBU800248<:DicWNm<H`<HfLi009JeP0>001oogoo>Lio
o`@0BHaoo`00Ic9oofmk001g_@Aoo`08Mke_NgooOolYBS6<Mke240aBU00E
IUUJePaSDYAonFOiKg]o>FOiOcUW>GliIoUo>FmkOcUW>GoiKg]o>FLi005o
n@0000IWnGliIcUo>FOiOcT2Kg/037oiIcUonFLiOcUWnGliIoUo>GNmDY@Y
BSQoo`07Kg]oofmkIcU:DRU:0000?goo015BU48@F]I:DVmk001oodVB001o
oaBU36=oo`00BU8YBP0001Eoo`08BU9JeTYBKg]BU000MkeBU09:DP0EOolY
BSW>36<00@005:DQ27Nm5:EW>@@Q8@PicQBU8@PDYBU:Ic8D[4V<009W>@0S
8@PaS6mk36<aS2U:5:DYBVLiBU9_Ne:DIcTaS1BU:DXDYBU:Kg]JeP00MkeJ
eT8@5:DQ22U:5:1JeVLi001JeVmk<H`DY@02:DX08PaSIU9_N`0PDYAW>D8@
MkdYBSW>OomJeU:D>LiBU7oo<H`D1FmkF]IBU000OomW>@`0OolDYD8@001_
Na@5Ic8DYC2U17oo00UW>D8@Kg]247oo101246mkBU803E:D00EJePaSIU9g
_Gli00=_N`0<IcUonFmkOcUW>GoiIcUWnGliKg]WnGli0Fmk000037liKg]o
nFmkOc9_NfOiOcUW>GoiIcUo>@9_N`06IcUo>FmkKg]W<S6<>7oo00MW>Goo
MkeW>E:D:DX0000oOol04U:D@Q1JeTYBMkd007ooIcTYBP00@Q0002U:001B
U6mk001:C1=oo`08MkeW>E[F00048Fmk101_N`9BU00MBU9g_D8@001:DVLb
F]HaS000Ool0X5:DKg/0032U:DXQ22U:000aS2U:>LiJeVmk8@PaS7Nm36<Y
BP028@P0<FmkF]I246LiDYAJeU:D5:DYBQBU@Q1_Ne[F001g_DYBIcTYBR48
:DX<He[FIcT405:DKg/icPaS<H`YBPaSDYA_N`00DYAW>D8@MkdicP@0@Q1_
NaBU000Q25[F>LhDX6Li009JeP0=001oogoo>Lig_DYBBcT007oo001ooc65
Mkd017oo0Vmk00<48@00IcT00RU:00=g_DYBDY@02e:D0U[F00`<Hd/bOcU_
NfOiOcU_NgoiIcUo>FLiOoT2Kg/01GliIcU_NgliIoT00Gli00000fmkIcUo
>@02Kg/00gliKg]o>@02Kg/02WliIoUo>FOiOcUWnGliKg]JeS65>7oo00M_
NgooKg]W>DYB:DX0000AOol00fmk001:DP0EOol00gNmOomoo`09Ool017Nm
OomoogNm1Woo00UBU48@F]I:DWNm001ooaBPKg/00goo00IVDWooOomoo`00
BU8DOol025:D>LiBU5:D@Q048FmkDY@2BU8017oo@Q0006mk0Woo00m24000
OolD1D8@OolicTYB:DYVDRU:001ooaBP<I800VLi0RU:01M_N`@05:DDY@00
8@QW>DYBKg]BU6Li:DX<Hb485:DQ26mkF]H006mkIcTaS0aS008Q200C125J
eVmk001JeWNm<H`<Hb48:DX48E:DKg/005:DIcU247Nm<H`00P0001P081BU
OolaS0@0DY@DYFLiF]IBU000Ool001@0Ool`YE:D001ooaBU50DDYC2UDY@3
Ool02Fmk@Q1:DU:DF]H<HcW>Mke2400=DY@015[F36=JeWoi0Wli00IWnGli
IcUonFmkIcT2OcT00fOiOcUWn@02OcT1Kg/1IcT0000DOcUonE[FOoUo>FOi
OcUWnFmkOcUWnGliIoUo<VmkOcUWnGliIc8aS3Qoo`07IcUoofmkIcUBU2U:
00004Woo00<Q20@QOol00RU:019JeR48@Q1g_@aSIcTDYGoo:DY:DWoo125o
obU:DY@YBVLi36<2Ool027Nm001g_ABU:DYoob48BU82>Lh047NmOol48ABU
OolQ25:DBU848GooDYA245[FBU9_N`0087oo00M_Ne[FKg]oofLi101_N`02
DY@05TYBOom24000:DXicT8@5:D007oo36=:C7NmDY@DYB48124aS2U:Ool0
YDV<0VLi02<Q236<MkdQ236<:DXicWooDYA:DVLiDYAJeTYB100DY@01<Hag
_E[F001g_E:DIcTDY@@Q5:D005:DKg/405[FKg/aS0@0008DY@08001247Nm
001BU6Li@Q1W>@9JeP09Mkd402U:IcTQ20@QDY@DYFLi009JeP0<101oogNm
IcUooaBU@Q1oo`00OomW<U:D1Woo00QBU6mkKg]ooaBU<Hag_DYB3E:D011;
>@aSIU9g_FLiIoUo>FmkIoUo>FLiOoUW>FOiOcUWn@9o>@5Wn@5W>@5on@00
00AWnGliIoUW>@9o>@07IoUo>FmkIcUo>FmkOcT00fmk00Ao>GNmF]HYBSQo
o`07Kg]oogliIcU:DRU:00004Goo00M_NcW>Kg/DYC6<:DYW>@025:D03fLi
5:Eg_@aS>LiW>@00Ool007oo8@QW>@@QOol00002Ool075:D<H`48D8@BU9J
eQBU001oo`00OolYBP00OomW>D8@:DYJeP@QKg]JeT8@F]I:DWoo001BU7oo
6fmk015o>FmkMkeBU5[FDYA_NdYB001g_E:DBU9BU6LiBU8aS248008DY@0C
:DXicWoo001:DU:DF]I242U:>Lh`YBU:Ool003W>IcU_Nb48:DX01Goo0fLi
00=oodYB@Q000U[F00=BU6LbF]H00U:D00<007Nm>Lh00U[F00MBU5[FF]IJ
eTYB001W>@03DY@035[FDYAJeU:DF]H005:DKg]246LiBU9JeP9W>@075:D4
8C6<F]HaS0aSKg/00U[F00D006LiOomoofmk009oo`03Kg]oogNm009oo`=_
N`0<OcUg_FLiDYAJeU:DMkd48C6<Oom245[F0e:D00=JeU:DDY@01E:D00UJ
eVII36=BU7oiOcU_NfLiOcT00Vmk00Yo>FLiOoUW>FmkOcUW>FOiOcU_N`5W
<P0000io>FmkKg]o>FOiKg]o>FLiKg]onFLiOoUW>FOi0Wli00AWnGliIc8Y
BSQoo`07IcUoogNmF]IBU2U:00004Goo01Q_N`00001BU6LiBU9oo`00@Q0a
S248Ool<Hfmk36<007Nm000aS000:DX003W>0003Ool00bU:001g_@020000
55[F000icP00Oom_Ne:D001:DU:D001W>@@QOomBU48@DYA246mk5:DU0000
0`@QKg]:DP02BU82F]H2Ool3Mkd01VmkOol403W>Mke:DP9_N`09MkeoofLi
OolDYB48F]IW>C6<00T00004DYA_Ne:DF]H3IcT01e:DF]Ig_@00Kg]JeU:D
009W>@0:F]IW>FLiKg/005:DIcUJeVmkF]H2IcT02e[FMkd4048@F]HicVLi
F]IBU4YBF]H00Woo00Q_Ngoo>Lh006LiBU9W>@0P5P0000=246mk@Q002dYB
00iBU4YBIc80YFIBKg]WnGliIoUo>FOiOcUWnGli0Vmk00Io>FOiOcU_Ngli
Kg/1Mkd0009_N`0BOcU_NgliIoU_NgliIoUo>FOiOcU_NgliIoU_NgliIoUV
FC6<>7oo00M_NgooKg]W>E:D:DX0000BOol03E[FIcUoo`00125ooe[FOoli
cP00Ool007oo009_N`08Oomg_E:DIcU_NgNmKg]g_@=oo`05F]IoogooF]IW
>@02Ool00e[F001oo`02Ool02DYBOomW>FLiOol007ooDYA24002IcT00e[F
Kg]W>@0OIcT026mkIcU_NfLiKg]g_E:DIcT4F]H2DY@2F]H015:DF]IJeVmk
1E[F0U:D0U[F00A_NfLiF]IJeP9W>@04DYAJeU[FIcT4F]H00e:DIcUJeP06
F]H2IcT2F]H00fLiDYAJeP02F]H015:DIcU_NfLi25[F00=_Ne[FF]H015[F
00AW>E[FDYAJeP9BU003Kg]W>E[F009JeP05MkeW>E[FKg]JeP0<IcT026mk
IcU_NfmkIcUg_FLiDY@=F]H2IcT030@QIc9g_GliIcUo>FOiOcU_NglbIoUo
>@9_N`05OcUWnGliIoUo>@01IcT0009o>@0BIoUo>FmkKg]o>FOiOcUW>Gli
IcUonFLiKg]o<VmkMkeW<RU:97oo00=g_GooOol04Goo00MW>GooKg]W>E:D
:DX0000EOol00aBUF]Ioo`05Ool00cW>:DYoo`0COol00e[F:DYoo`06Ool0
0gNm5:Eoo`02BU802GNmIcUW>FmkMke_NgNmKg]g_@03Kg/02gNmKg]g_Fmk
Mke_NgNmKg]g_FmkMkd00Vmk00eg_FmkMke_NgNmKg]g_FmkMke_NgNmKg]g
_@02Kg/02WNmKg]W>FmkIcU_NfLiKg]W>Fmk0VLi00=_NfLiIcT00Vmk00=W
>FmkIcT00VLi00=_NfLiIcT00Vmk0VLi00=_NgNmMkd00WNm00=_NgNmMkd0
0WNm00Q_NfLiIcU_NfLiKg]W>Fmk0VLi01Ag_FLiKg]W>FmkIcU_NfLiKg]W
>FmkIcU_NfLiKg]W>FmkIcU_NfLi16mk00UW>FmkIcU_NfLiKg]W>FmkIcT0
0fmk00=W>FmkKg/00WNm00A_NgNmMke_N`9g_@07Kg]g_GNmKg]g_FmkMkd0
0Vmk00Ag_FmkKg]g_@U_N`03IcU_Nfmk00E_N`07IcT48FIIOoU_NgliIoT0
0Wli00EWnFmkOcUWnGli009_N`04OcUWlWliIcT1OoT00005IoUo>FLiIoUo
>@02Kg/01glbIoUo>FmkOcUW>Goi009_N`04OcUonE[F:DXSOol00gNm8@Qo
o`0BOol01fmkOom_NfLiDY@Q200003moo`03Kg/aS00009D0000300400000
00d00004@Q0aS4Y<OoT2Kg/017liIoU_Ngli0Vmk00Eo>FOiOcUWnGli009_
N`5o>@5W>@0000Io>FOiOcUo>FOiOcT2Kg/01GliIoUo>FOiOcT00Vmk00Eo
>FOiOcUBU36<02=oo`03<HaJeWoo019oo`07IcUoofmkIcUBU2U:0000?goo
00=W>CW>00000P0000<4000000001@0000<<H`001000100000<400@Q36<0
0`0000<48@000000100000H4000000008000124300000`010004001V0000
1b485:DYBRU:8@P0H0`000@DY@0N8@P400008@PaS0aS5:DaS0aS000icRU:
DYAg_FLiOoUW>GliIc9o>FOiOcUWnGliIcUo>FOiKg]o>FOi0Gli00003Vmk
OcUWnFmkOcUWnGliKg]o>FLiIoUo>FOiOcT2Kg/017liMkeW<RU:8goo00<a
S6LiOol01Goo00<YBPaSOol02Woo00M_NgooKg]W>DYB:DX0000=Ool01T8@
>LhaS6mkMkdQ209oo`0HIcUJeS6<OomW>CW>F]HicWooMkdaS5:DOolDYE[F
OolaS5:DMke:DWoo001_NcW>0Woo00a:DU[FMkdaS6LiOol48Goo>LioofLi
8@P2Ool0136<IcU_NcW>0P0000<DYCW>BU80100000P<HdYB5:DQ22U:5:DQ
21BU0PaS02LDYGoo5:D<H`@0:DX<H`00<H`0036<000icS6<0019S0aS8@P4
8@00Ic8YBP00>LhQ20@0DY@YBP@0000aS0008@P48@aS124407Nm8@P0E000
00D40000125ooe:D00848@0<Mke_Nc6<OomW>FmkIcUooc6<001oocW>0Woo
00YBU7oo000icS6<DYAonGliIcUon@A_N`04OcUW>FOiOcT4Kg/1OcT1IoT0
0009OcU_NfmkOcUW>GliIoUo>FOi009o>@09Kg]o>FOiKg]o>FLiOoUJeRU:
02=oo`03>LiW>Goo00Aoo`03>LhaS3W>00]oo`07IcUoofmkIcUBU2U:0000
3Goo0`0000Q:DWNm001oo`aS5:D0048@0RU:01<icP00<HaoobU:<H`48B48
>Li24000BU8007oo000DYFLi@Q000002Ool01aBUBU8<He:D000icS6<008i
cP0<00048E:DOomJeP00IcU_NcW>000YBVmk0P0003@icPaS000000@05:DY
BSW>101on@aS8@P48BU:>Lh001BUIcTQ236<BU8004VB5:EW>C6<001:DP00
125:DS6<>Lh004YB001oo`00BU8DYB48100aS7Nm<:D00248:DX081BU:DX0
008Q25H0000KKg]:DS6<>LiJeTV<5:a;<VIBBU8icVLi5H`007oo36<08000
:DY_N`00>LhaS4YBOcUWnGli009_N`0<OcU_NgliIoUo>FmkOcUWnGlbKg]o
>FOi0Gli00001fOiOcUWnGliIoUW>Gli009_N`0;IoUo>FmkKg]o<VmkIoUo
>FmkIc8`[008Ool00gNmOomoo`0HOol00c6<IcUoo`04Ool00fLi001JeP0;
Ool01fLiOomg_E[FDY@YBP0000eoo`0436<00000DY@2Ool06SW>36=g_@00
MkdDYC6<Kg/DYFmk125:DVLi36<005:D@Q0007oo001oo`00Kg]oo`00IcT2
Ool02c6<BU8007oo000Q25:D8@Qg_@@QBU800Woo00`icQBUOomW>CW>000Y
BPaSOolDY@aS>Lh20000:@@QBT`00000IcU:DP00Oom242U:001oobU:<HD0
06LiF]H006Lb@Q0<00@QF]HicPaSOol007oi>Lh007oo>Lh006Li>Lh006Li
<H`48DYB5:D00P0000IJeWli000<Hgoo:DYF00000`aSIcUW>@02IcT02Vmk
<H`Q25:DF]I_Ne:DKg/`Y@000Woo0P0001=ooe[F000icS6<IU9_NgliIoUo
>FmkIcUonFLiOcUWnGliKg]o>@03Kg/1OcT1IoT00008OcUW>GliIoUo>Fmk
OcUWn@9o>@03IoU_Ngli009_N`05OcU_NgoiDY@aS002Ool00fOoOomoo`02
Ool01S<o5cmoogoo5Ulc?`Eoo`03IcUoogoo00ioo`03>LiJeWoo00Eoo`03
IcUg_Goo00Yoo`07Kg]oogliIcUBU2U:00003Goo0`00011247oo000<Hgoo
BU9oob48Ool0036<Ool<Hgoo>Lh0009oo`0;36=:DWoo8@QW>Goo001g_CW>
Mkd<H`02Ool0136<:DYoo`aS0Woo01@007ooBU8Q23W>IcUoob48001oofmk
>Lh002U:0219S7Nm124000@Q0P0000=BU6Li5:D02@0000<aS0aS00000P00
00Ag_@00<H`DY@<000035:D0000000800003F]H0000000D00003>Lh<H`00
00D00003<H`Q200005D00004020407ooKg/2F]H05GNm@Q0YBWoo:DXicS6<
OolaS000Ool005:DF]H48Goo000icS6<BU9on@02Kg/02WoiIcUonFLiOcUW
nGliIcUonFLi0Vmk0Gli0FOi0Gli00006VmkOoUW>GliIcUonFLiOcUWnFLi
OcU_NfOiOcUWnFmkOcUg_FLb:DYoofOo5UmWofLo0Ul2Bcl01gNm0UmWofOo
BclG?fmk00=oo`06001JeWooMkd002U:0Woo00IBU7ooOomW>C6<1243Ool0
0c6<IcUoo`0=Ool00fmkIcUoo`02Ool01fmkOom_NfLiBU8YBP00015oo`05
Kg/005[FOol00008Ool00`@QDYAoo`06Ool00e:D001oo`05Ool00aBU>Lio
o`05Ool00`008@Qoo`04Ool01U[FKg/icP008@P<HfD000030200000001T0
00030200000000X0009BU092400:DY@icP@QF]IBU6IBBU9_Nb480002F]H0
66LiDYAW>DYB000aS3W>DYAg_FmkOcUW>GNmKg]o>FOiOcUWnGliIcUonGli
IoUo>@9_N`0000UonFLiOcUWnGliIcUonFLiKg/00Wli015WnGlbKg]_Ngli
IoUo>FLi:DYoo`9OOolc?`9IOol2Gd/o009oo`05Bcmg_C<o0UmWo`02Ool0
0e:D@Q124002Ool01VLiDYAoofmk000DY@9oo`03<HaJeWoo009oo`06>LiW
>GooIcT002481ABU00<Q2000BU800Woo00<<H`00Mkd00Woo00L007ooMkeW
>E:D:DX0000oOol016Li<H`000000P@QF0aS00<48@aS36<00`aS00<48@aS
36<00PaS00DDY@055:0D1@@Q01<<H`03124<H`aS008<H`08124<H`aS36<4
8@aS5:0D1@@<H`031240000000@000030200000000@0000336<0000000@0
000E36<icR48BU9onGliIcUonFLbOcUWnGliIcUo>FOiOcUW>FOiOcUW>Fmk
005o>@0000]_NgliIoUo>FOiOcUW>GoiIcUWnGli00=_N`0:Oc9_NgliIoUV
DS6<OomWoaLoBcl2Ool01fOo5Ulc?fLo<clG?c<o00=oo`04BU8007oo5:D2
Ool01ABUF]IoogooF]H00goo00<Q20aSOol00Woo00<aS6LiOol03Goo00=g
_FmkOol00Woo00Mg_GooKg]W>E:D:DX0000oOol00d8@DYAg_@1EKg/026Li
Mke_NgNmOomg_GooMkd2Ool5Mkd3Kg/01gNmKg]WnGNmIcmWnGli009_N`03
Mke_NgNm00=_N`0:Mke_NfmkKg]g_FOiMkeW>GNmKg/2Mkd00fLiMke_N`02
Kg/01WNmKg]_NfOiKg]g_@=_N`03Mke_Nfmk00A_N`08IoUo>FmkIoU_NgNm
Kg]g_@E_N`07IoUo>@2UIU9o>FOiOcT00fmk00=o>FOiOcT00Vmk00Io>Goi
IcUo>FOiOcT1IoT00007OcUWnGliKg]o>FOiOcT00Vmk00]o>FOiOcU_Ngli
IoUo>FmkMkeW<S6<009oo`03Bcmoogoo00=oo`03Iomoogoo00Ioo`07Mkeo
ocW>Mkeoo`aSMkd01Goo00=g_GooMkd00goo00<icU[FOol00goo00=JeVmk
Ool037oo00MW>GooOcUW>E:D:DX0000oOol00gNmOomg_@02Mkd00gooMkeg
_@04Mkd00gooMkeg_@02Mkd00gooMkeg_@04Mkd00gooMkeg_@0?Mkd01Goo
Mkeg_GNmOol0:GNm01=Wod/iOomBU0aSKg/icTYB>LhaS5[FKg]W>CW>DYA_
NgliKg]W<P02Kg/01FLiOc9_NfmkIcT00Vmk0fLi00U_NgliIc9_NfLiKg]W
>GliIcT00Vmk00=W>GliIc800Vmk00EW>GliIcU_NfLi009_N`05IcU_NfLi
OcUW>@02Kg/01fLiOcUWnGliIcU_NfLi00=_N`0DIc9_NfLiOcUWnGliIcUo
>FLiMkeVDU[FIoUo>FOiOcU_NgliIoUo<P9_N`07OcUWnFLiOcUWnGliIoT0
0Gli00000fmkOcU_N`02Kg/00gliIoUo>@02Kg/00gliIoUo>@02Kg/01FLb
Mkeo>E[F:DX057oo00D007ooOomoogNm00=oo`03Mkeoogoo00Aoo`03<HaW
>Goo00=oo`06001BU7ooMkd0048@2Goo00MW>GooIcmW>E:D8@P4002GOol0
2fLo<cmoodYB001oob48BU8DYB48IcT00Vmk00XaS5:DOoU_NgliIoUo>Fmk
OcUWn@9o>@0CIoUo>FmkOoU_NgoiIcUg_FmkOcUWnGliIoUo>FOiOcU_Ngli
IoT00Wli00MWnGliIoUo>FmkOoU_N`02OcT02VLiOoUW>GoiIcUo>FOiKg]o
>FOi0Wli00mWnGliKg]o>FmkOcUWnFLiOcUWnGliIoUo>FmkOoT00fmk00=o
>FOiOcT00fmk00Io>FOiOcUo>FOiOcT2Kg/1Oc81Kg/00004IoUo>FOiOcT2
Kg/00gliIoUo>@02Kg/02GliIo9_NgliKg]o>GNmF]HaS00DOol00dYB:DXa
S008<H`01R48DYAoogoo>LiW>@=oo`03IcTaS6Li009oo`03>LiJeWoo00Qo
o`07IcUoogoiF]IBU2U:0000UWoo03eg_FOoBcmooe:D001oobU:BU8Q22U:
F]Ig_Fmk:DYBU7NmIc9_NgliIoUo>FOiOcUW>FOiOcUWnGliIcUo>FLiOoUW
>GliIoUo>FOiOcUW>GliIoUo>FOiOcU_NfOiOcUW>GliIoUo>FLiOcUWnFLi
OoUW>GoiIcUon@02Kg/03glbKg]_NgliIoUo>FOiOcUW>GoiIcUo>GoiKg]o
>@02Kg/05GliIoUo>FOiOcU_NgliIcUWnGliKg]o>FOiOcU_NfLiOcUWnFLi
OcU_N`01Mkd0000:OcUW>GliIoUo>FOiOcUW>FOiOcT2Kg/027liKg]WnGli
IoUo>FLb:DXSOol0336<IcUoogoo@Q0007oo125oogNm000aS0Uoo`07IcUo
ofmkIcUBU2U:0000Tgoo00Ag_GooOomoo`9;?`06Oom:DP00OolYBTYB0R48
00IW>GNmKg/YBVIBMkd3Kg/01GliIcUg_FmkOcT00Vmk01=o<VOiOcUWnGli
IcUo>FOiOcU_NgliIoUo>FOiOcUW>GliIoUo>@02Kg/01gliIoUo>FmkOoUW
>Gli009_N`0;OcU_NgliIcUo>FOiKg]o>FOiKg]o>@02Kg/02GliIoUo>FOi
IcUo>FmkIoUo>@02Kg/057liIcUo>FOiOcUWnGliKg]W>GoiIcUo>FOiOcUW
nGliKg]o>FOiOcT1IcT0000>Kg]o>FOiOcU_NgliIoUo>FmkOcUWnGliKg]W
n@9o>@04IcUonE[F:DXSOol00c6<DYAoo`04Ool00cW>Kg]oo`0;Ool01fLi
Oom_NfLiDY@YBP0003=oo`03@Q1g_Goo05eoo`0?Iom;?gNmOomWod/iOomB
U000OolQ24YB8@PYBU[F009_N`0<<HaBU7oiOcU_NgliKg]onFLbOcUWnGli
0Vmk00ao>FOiOcU_NgliIoUo>FmkOcUWnFLiOcT2Kg/01gliIoUo>GliIoUo
>FOi009o>@0KIoUW>GliKg]WnGlbMke_NfOiOcUWnGliKg]g_GliIc9o>FOi
OcUWnGliIcU_NgliIoU_Ngli009_N`0EOcUWnGliIoUo>FmkIcUonFLiOoUW
>GliIoUo>FmkOcUWnGliIoUo>FOi005o>@0000e_NgoiIcUW>GoiIcUo>FOi
OcUW>GliIoUo>@02Kg/01FOiOcU_NfLb<:`08goo00=g_BU:Ool01Goo00@<
HfLiIcUBU0Uoo`07Kg]oofmkIcU:DRU:0000<goo00<004YBOol0GGoo01UW
?c<o<cUoofLo<cmoodYB001oobU:BU8Q22U:IcU_NgNm:DY;<WliIoUo>Fmk
IoUo>@02Kg/00gliIoUo>@04Kg/00gliIoUo>@02Kg/03fOiOcUonFLiOcU_
NgoiIcU_NfLiOcUWnGliIcUWn@02OcT01FOiOcUo>FmkIc800Wli00IWnGli
IoUo>FLbMkd2Kg/03GliKg]_NfmkOoUW>GliIcUonFLiOcUWnGli009_N`03
OcUWnGli009_N`0=OcU_NgoiIcUo>FOiOcUW>GliIoUo>FLiOcT00FOi0000
57liIcU_NgoiIcUo>FmkOcUWnGliIoUo>FLiOoUW>GliKg]g_FLb<H`TOol0
0fmkOomoo`04Ool3>Lh00bU:Kg]oo`07Ool01fLiOom_NfLiDY@YBP00019o
o`03DYAW>Goo009oo`03Mke:DWoo00Aoo`03MkdQ24YB00Aoo`095:Eoogoo
<HaoodYBKg]ood8@009oo`07BU9g_Goo001oocW>Mkd00Woo00=_Ne:DOol0
0Woo00<Q24YBOol017oo00=247ooOol00Woo00A247ooOomoo`9:DPAoo`06
5:EoogooOol<HfLi0Woo00AW>GooKg/YBPAoo`03@Q1JeWoo00=oo`06>LiW
>GooOom_NdYB0Woo00=JeRU:Ool087oo00XFFGooBcm;?gooDY@007oo8@QB
U08Q200:F]Ig_Gli5HaVDVmkOcUWnFmkOc82Kg/03gliIoUW>GliIoUo>Fmk
OcUWnFLiOcUWnGliKg]o>@02IcT02WoiKg]W<VmkOcUonFLiKg]o>FOi0Wli
00]WnFmkOcUWnFmkOcUWnFmkOcU_Ngli00A_N`09OcU_NfOiOcUonFLiOcUW
nGli009_N`0>IoUo>FmkIcUo>FOiOc9g_FmkOcUW>GoiIcUo>@9_N`03OcUW
nGli009_N`5o>@5Wn@5o>@0000Uo>FOiOcUW>GoiIcUonFLiOcT00Vmk00Ao
>FmkIcUon@9_N`03OcUJeRU:03Qoo`07Kg]oofmkIcUBU24810004Woo00<0
048@Ool00Woo00=_N`00Mkd00goo0P0000LQ2000001oogNm000DY@030000
2Woo001BU7oo001BU7oo001JeWoo10000Woo00H48@00Oom:DP00<H`20004
Ool02@00F]Ioogoo8@P004YBOolicP0200000`aSOomoo`020002Ool02000
36<<H`00OolYBP005:D20002Ool01000124000000Woo00L000@Q000007oo
IcT00002Ool00`00BU9oo`0POol03AIOOomWod/iOom:DP00OolYBTYB8@Pa
QFLi009_N`05<HaBU7oiKg]o>@02Kg/05WliKg]_NgliOoUW>GliIoUo>Fmk
OcUonFLiOcUWnGliIcUonFLiOcUWnGli0Vmk00QW>GoiKg]_NgliIoUW>Gli
0Vmk011o>FmkKg]o>FOiIcUo>FOiOcU_NglbKg]WnGliKg]W>@9o>@07IoUo
>FOiOcUW>GliIoT00Wli011WnGliKg]W<VmkOoU_NfLiOcUWnGliIcUWnGli
IoUo>@9_N`5o>@5Wn@0000IWnGliIcUonFLiOcT2Kg/037liIoUo>FOiKg]o
nGliIcUo>GNmIc8YBSQoo`07IcUoofmkIcUBU2U:00004Woo00E24000Oomg
_Goo008<H`=oo`8000=oo`0436<006mk0002Ool05`00Oomoo`00DYAoo`00
IcUoo`00DYAoo`00<Haood8@001oocW>001oo`00IcT00Woo00=BU7ooOol0
0Woo00@006mkOomoo`800003OomJeP00009oo`08001oogoo001_Ngoo000i
cP9oo`04BU9oobU:1242Ool01000OomW>@000Woo00@007ooF]H0009oo`05
001ooe[F001oo`02000QOol02gNm<cUoofLo<cmooe:D001oobU:BU800R48
02mJeWNmKg/YBU:DMkeo>FmkIoUo>FOiKg]o>FmkIcUWnGliIcUonFLbMkeW
>GliIoUo>FLiOoUW>GoiKg]o>FLiOoUW>GoiIcUo>FmkIoUo>FmkOcUWnGli
IcUWnGli009_N`03OcUWnGli00=_N`0AOoUW>GliIcUonFLiIoUo>FmkOcU_
NgliIoUo>FLiIoUo>@02Kg/047liIoUo>FLiOcUWnGliIoUo>FmkOcU_Ngli
IcUonFmk0Gli000057liIoUo>FLiOoU_NfLbOoUW>GliKg]o>FLiKg]WnGli
IoUo>E[F<H`hOol01fLiOom_NfLiBU8YBP00019oo`03Mkd0000000<00006
F]IoogooOomW>E:D0goo01=:DP00Ool48@00F]H006LiOol005:DOol006Li
Ool005[FOol00003Ool02`00OolicPaSOol002U:000DYE[FKg/00goo00T0
06mkOol007oo001ood8@5:D00Woo00h004YBOol006LiOol003W>000DYE:D
OolQ20@Q0Woo00@004YB:DX<H`9oo`04001:DRU:36<2Ool01P00<Ha_N`00
@Q0002=oo`0C5UmoofOiBcmoodYB001oob48DY@Q22U:F]Ig_Fmk:DYVDWoi
Kg/00Wli00E_NgliIoUo>FOi009o>@0<IoU_NgliKg]o<VOiKg]o>FLiOoUW
>Gli1Fmk00Ao>FmkOcUWn@9o>@05IcUonFLiOcUWn@02OcT01fOiKg]o>FOi
OcUWnGli00=_N`0AOcUWnGliIcUonFLiKg]o>FOiOcU_NgliIoUo>FmkIoUo
>@02Kg/02GliIoUo>FOiOcU_NglbIoUo>@02Kg/016OiOcUW>GNm0FLi0000
16mkOcUWnGli0Vmk00io>FmkIcUonFLiKg]o>FOiOcUW>GliMkeW<RU:>7oo
00M_Nb48OomW>E:D:DX0000COol01@00Mkeoogoo00001Woo00EW>BU:0000
05:D009oo`09DY@YBP00BU9oo`00F]Ioo`00009oo`0>001BU7oo001W>Goo
Mkd007oo>Lh48Goo001W>@9oo`03001_Ngoo009oo`09001oobU:001oo`00
Oom:DP00009oo`0>001_Ngoo001W>Goo001247oo@Q0007oo:DX<H`9oo`04
001g_DYB1242Ool01000Oom240aS0Woo00<006LiOol00P0000=_NgooOol0
8Goo00Xc>GooBcm;?gooDY@007oo:DY:DP8Q2005IcU_Nfmk<HaBU002Kg/0
2GliIoUW>FmkOcUWnGlbKg]Wn@02OcT4Kg/067liIcUonFLiOcUWnGliIoUo
>FmkOcUWnGliIoUo>FmkIcUonFLiOcUWnGliIoU_N`9o>@0<IoUo>FLiOcUW
>GoiIcUo>FOiOcUWnGli0Vmk019o>FOiOcUWnGliIoUo>FOiOcUW>GliIoUo
>FmkIc9onFLiOcT2Kg/027liIoU_NfmkOcUWnGliIcT1OoT0009_N`0BOcUW
nGliKg]WnGliKg]o>FOiOcUWnGliIoUo>FLiOoUJeRU:1goo00AWogooOomg
_BIoo`03F]Ioogoo00Aoo`07Kg]:DWooF]IBU2U:00004goo00<Q2000Ool0
0P001Goo00@Q20005:DicP=oo`0?001BU7oo001g_Goo000<HdYB000DYFLi
001W>Goo0080000<F]H00248OolYBP@QOolDY@00Ool000aS17oo02h007oo
001g_Goo001W>Goo000<Hc6<001oofLi000YBWoo>Lh007Nm000Q27oo>Lh0
05:DBU8007ooMkd005[F>Lh007ooKg/005[F<H`007ooF]H007oo00048B9o
o`0S5UmoofOo<cUoodYB001oob48BU8Q22U:F]Ig_Fmk:DYVDWoiIcUWnGli
OoUW>FmkOcU_NgliKg]W>FOiOcU_NgliIoUo>@02Kg/05gliIoUo>FLiOcUW
nGliIcUo>FOiOcU_NfLbOoUW>GliIoUo>FLiOcUWnFLiOcT00Vmk011onFLi
OoUW>GliIoUo>FLiOcUWnGliIoUo>FmkIc9_N`9o>@08Kg]o>FOiOcU_Ngli
IoUo>@9_N`03OcUWnGli009_N`07OcUWnGliIcUo>FOiOcT00FLi000016mk
OcUWnGlb0Vmk00io>FLiOoUW>GliIoUo>FLiOcUWnGliMkeW<RU:1Woo00IW
oaIOOomW?d/o5cl4Ool02WNmKg]_NfmkOomW>FmkMkeooe:D0Woo00EBU6Li
Ool<HaBU009oo`08DYA_NgooDYAoofmkOomJeP9oo`08MkeJeWoo001:DWoo
F]IBU0=oo`07001g_GNmIcUBU2U:00004goo00Ag_@00Ool000Eoo`03Mkd0
07oo009oo`07BU9g_GooOol<H`00IcT00Woo00LYBT8@001oodYB001BU002
Ool010aSIcT002U:0Woo00LYBP00Oomooe:D00124005Ool200001C6<Oomo
o`00IcT00Woo0P000Woo00<Q200000000Woo00=:DP00>Lh00Woo00DQ20aS
BU8006mk009oo`03Mkd000aS00=oo`03Mkd001BU009oo`06F]H007ooOol0
06Li8Goo00Xc>GooIcm;?gooDY@007oo:DYBU08Q2007IcU_Nfmk<Ha;<Wli
IoT00Wli00=W>FOiOcT00fmk02mW>GoiOcUWnGliIoUo>FOiKg]o>FOiOcUW
>GliIoUo>FOiOcUWnGliIcUonFmkOcUWnFmkOcU_NgliIoU_NgliIoU_Ngoi
IcUo>FLiOoU_NgliIoUo>FOiOcUW>Gli00=_N`08OcUWnFLiOoUW>GliIoUo
>@A_N`0=OcUWnGliIoUo>GNmIcUo>FOiOcU_NgliIoT00Gli00001GoiIcUo
>FmkOoT00Vmk00eo>FLiOoUW>GliIoUo>FmkOcUWnGliF]HaS004Ool02`9O
Ool2GfOo0UmWofLo5cmooaLo<cl00Woo020YBP00Ool005:D001g_D8@001o
od8@36=oobU:IcT007oo>Lh48Goo5:EJeP00OomJeP00@Q1oo`@QKg]oo`00
0Woo00`Q236<:DY_NaBU36<icWooIcU:DRU:000DOol00`@Q00000006Ool0
1P00<HaoofLi000YBQIoo`038@P007oo00Uoo`03000DYGoo009oo`03001B
U7oo00Ioo`03001JeWoo00Ioo`035:D48Goo00moo`03F]H007oo02Aoo`0M
5Umood_oBcUoodYB001oob48BU8Q22U:F]Ig_Fmk<HaVDWNmKg]WnGliKg]o
>FOiOcU_NgliIoUW>@02OcT01VOiOcUW>GliKg]o>@9_N`05OoUW>GliIoUo
>@02Kg/0>7liKg]W<WNmKg]o>FmkIoUo>FmkOcUW>GoiIcUo>FLiOoUW>Gli
IcUg_FmkOcUW>GliIoUo>FOiOcU_NgliIoUo>FmkIcUonFLiOcUWnGliKg]o
>FOiKg]o>FLiKg]W>GliOoUW>GliIoUo>FOiOcT1Kg/0000DIcUonFmkMkeW
<VmkOcUWnGliIcUonFmkOcUW>GoiKg]o>GNmIc8YBPAoo`82G`095cmoogoo
Bcmood/oOol2GaIO009oo`0:>LhDYGoo00124000Ool006mkOol2000055:D
001oo`00OolaS000Ool00248001oo`@QBU9ooe[F000<Hfmk0003Ool02aBU
DY@Q248@<HaoofmkIcUBU2U:000057oo00=g_@00DY@01goo00@<H`00001J
eQMoo`038@P48Goo00Uoo`03001247oo009oo`03001:DWoo00Ioo`03>Li_
Ngoo00Ioo`8<Ha1oo`03F]H007Nm02Aoo`0=<cUoofmkBcmooe:D001ooaBU
@Q0<HaBUIcT00Vmk00`YBU:DOoU_NgliIcUonFLiOcUWnGliIoT2OcT03VOi
Kg]o>FLiOoUW>GoiIcUWnGliIcUonFLiOcT2Kg/017liIoU_Nfmk0Wli01]W
nFmkOcUW>GoiIcUonFLiOcUW>GoiIcUonFLiOoUW>GliIoUo>FOiOcU_Ngli
IoUo>FOiOcT00Vmk00QonFLiOcUWnGliIcUonFLi0Wli00AWnGliKg]on@9W
>@05OoUW>GliIoUo>@02Kg/0000?OcUW>GliMke_NgliIoUo>FOiOcU_NfLb
OoU_NfLb009_N`03OcUJeS6<00Aoo`080UmoofOo5Um;?aLo<clG?`Eoo`09
:DX007oo5:D005:DOol000@Q009oo`0?001JeWoo5:D<HgooIcT003W>OolD
YE[FOolDY@00009oo`048@PicWoo0002Ool03000:DYoogoo5:D<HgooKg]W
>E:D8@P409=oo`09MkeooaIOOomWod/oOomBU000009oo`0;Mke_Nd8@IU9g
_Fmk:DYBU7liIoUo>@02Kg/06GliIoUo>FLiOcUWnFmkOcUWnGliIcUo>FOi
OcU_NgliIoUo>FLiOoUW>GliIoU_Nglb009_N`05IoUo>GliIoUo>@02Kg/0
47liIcUonFLiOoUW>GliKg]o>FLiOoUW>GliIoUo>FOi0Vmk01ao>FLiKg]_
NgliIcUo>FOiOcU_NfLiOoUW>GoiIcU_NgliIoUo>FLiOoUW>GliIoU_Ngli
IcUon@5_N`0000]_NgliIoUW<WliMkeW<VmkOcUWnGli009_N`07OcU_NfOi
OcUg_FLb:DX047oo00Ag_C6<36=JePAoo`03<Haoogoo00ioo`03@Q1oogoo
00Aoo`06<H`DYGooOol<Hb480Woo00Mg_GooKg]W>E:D:DX0002COol02fOo
0UTFFGoo5UlbFGooDY@403W>12400R48019:DU:DMke_NaF<IU9WnGliKg]W
nGliIoUo>FmkOcUWnFmkOc82Kg/00gliIoUo>@02Kg/027liIoUo>FLiOoUW
>GliIoT2OcT2Kg/08WoiOcUW>FmkOcUW>FOiOcUW>GoiIcUonFLiOcU_NgNm
IcUonFLiOcU_NgNmIcUo>FmkOcUW>GoiKg]o>FOiOcUWnGli0Vmk00aonFLi
OcU_NfLiOoUW>GliIoUo>FLiOoT2Kg/017liIcUonFLi0Gli00001WliIoUo
>FmkIoUo>@=_N`03Oc9WnGli009_N`9o>@04IoUo>E[F:DXhOol01fmkOom_
NfLiBU8YBP0009=oo`0EIclc?gooMkdc?fOoOom:DP00Mkd48BU:000YBU[F
Mkeo>C6<DYAonFmk009o>@0>IcUo>FOiOcUWnGliIcU_NgliKg]WnGliIo9o
>@9_N`0:OcUWnGliKg]onFLiOcUWnFLiOcT2Kg/09fLiOoUW>GoiKg]o>FOi
OcUW>GliKg]o>FOiOcUW<WoiIcUo>FOiOcUW>GoiIcUo>FOiOcUW>GoiIcUo
>FOiOcUWnGliKg]W<WoiKg]o>@02Kg/02GliIoUo>FOiOcUW>GliIoUo>@02
Kg/1OcT1IoT00009IoUo>FmkKg]o>FOiOcU_Ngli009_N`09OcUWnGliIcUW
nGliMkeW<S6<03Qoo`07IcUoogNmF]IBU2U:0000VWoo00IBU000DYAoocW>
1242DY@03VmkMkdYBU:DMkeo>FLiIoUo>FOiOcUW>GliIoT2OcT00fOiKg]o
<P04Kg/00gliIoUo>@02Kg/05FLiOcUWnFmkOcUWnGliIcUonFLiOoUW>Gli
Kg]o>FOiOcUWnGliIoUo>@03Kg/04gliIoUo>FLiOoUW>GliIoUo>FOiOcUW
>GoiIcUo>FLiOcUWnGli009_N`0=OcUWlVmkOcUWnGliIcUo>FOiOcUWnGli
IoT00Wli0FOi0Gli00002WliIoUo>FmkIcUo>FOiOcUWnGli0Vmk00=o>FOi
OcT00Vmk00=o>E[F:DX0>7oo00MW>GooKg]W>E:D:DX0002JOol06E:D000Y
BWoo8@P005[FDYAg_FLi<HaBU7oiKg]o>FLiOoU_NfLiOoUW>GliKg]WnGli
009_N`0<OcU_NgliKg]WnGliKg]o<VOiOcU_Nglb0Vmk00Qo>FOiOcU_Ngli
IcUonFLi0Vmk01eo>FLiOcUWnGliIoUo>FmkOcUWnGliKg]onFLiOcUWnGli
IcUo>FOiOcUW>GoiIcUonFLiOcUWnGli009_N`08OcU_NfmkOcUWnGliKg]o
>@9_N`05OcUW>FmkIoUo>@01Kg/0000>Kg]o>FmkKg]onFLiOcUWnGliIcUg
_GliIoUo>@9_N`04OcUg_FLb<H`hOol02VmkOom_NfLiDY@YBP00Oomg_Fmk
0WNm00A_NgNmMke_N`9g_@03Kg]g_Fmk009g_@03Kg]g_Fmk009g_@04Kg]g
_GNmKg/2Mkd03VmkMkeg_FmkMke_NgNmKg]g_FmkMke_NgNmKg/2Mkd00fmk
Mke_N`02Mkd01fmkMkeg_GNmKg]g_Fmk009g_@05Kg]g_GNmMke_N`03Mkd0
0fmkMke_N`02Mkd016mkMkeg_Fmk0WNm00E_NgNmMkeg_Fmk009g_@03Kg]g
_Fmk00=g_@05Kg]g_FmkMke_N`02Mkd01FmkMke_NgNmKg/00WNm00A_NgNm
Mke_N`9g_@04Kg]g_GNmKg/2Mkd016mkMkeg_Fmk0gNm00A_NgNmMke_N`=g
_@04Kg]g_GNmKg/2Mkd016mkMkeg_Fmk0gNm00A_NgNmMke_N`9g_@0<Kg]g
_GNmMke_NgooKg/002U:DYAW>@@Q0U[F00m_NgNm:DYVDVOoOcUWnGliKg]W
>GoiIcUo>FmkIoT00Wli00MWnGliIoUo>FmkIoUo<P03Kg/00gliIoUo>@02
Kg/03GoiIcUo>FOiOcUW>GoiIcUo>FOiOcUW>Goi00=_N`0EOcUW>GliIoUo
>FOiOcUW>GliIoUo>FmkOcUWnGliIcUonFLiOoUW>Gli00=_N`0AOcU_Nfmk
IoUo>FOiOcUW>GoiIcU_NgliIoUo>FOiOcUWn@01OcT0000:MkeWnGliIcUo
>FOiKg]o>FLiOoT2IcT027liIoUo>FmkIoUo>E[F:DXhOol01fLiOom_NfLi
DY@aS1BU05d000030040000003X00004IcTDYABU36<28@P02`@QBU9oofLi
<HaBU7liKg]o>FOiOcT00Vmk00=o>FOiOcT00Vmk00IW>GliKg]o>FOiOcT2
Kg/01gliKg]onFLiOcUWnGli009_N`0AOcUWnGliIoUo>FmkOcUWnGliIoUo
>FLiOoUW>GoiIcUon@02Kg/04FLiOcUWnGliKg]o>FmkIoU_NgliKg]onFLi
OcU_NgliIoT00Wli00]WnFmkOcU_NgliKg]o>FLiOoUW>Goi009_N`05Oc9W
nGliIcUo>@01IoT00004IcUo>FLiOoT2Kg/03WliIcUonFLiOcUonFLiOcUW
nFmkOcU_NfLb:DXhOol01FmkOom_NfLiBU800RU:00=:DT8@BU800d8@00M:
DT8@@Q1244YB@Q1:DP03@Q000dYB@Q1:DP03@Q001DYB@Q12448@BU800T8@
00]:DT8@BU9244YB@Q1:DT8@BU9244YB00=24003BU92448@00924007BU92
448@@Q1:DT8@BU800T8@00E:DT8@@Q1244YB00=24003BU9244YB00=24005
BU92448@@Q1:DP03@Q001dYB@Q12448@BU9244YB00=24005BU9244YB@Q1:
C002@Q000dYB@Q1:DP02@Q001DYB@Q12448@BU800d8@00E:DT8@@Q1244YB
00=24005BU92448@@Q1:DP03@Q001DYB@Q12448@BU800d8@00E:DT8@@Q12
44YB00=24007BU92448@@Q1:DT8@BU800T8@00I:DT8@@Q0icRU:>Lh2<H`0
32U:>LhYBR48Oom_Nc6<BU9onGliIoUo<P9_N`03OcUWnGli00=_N`0;OoUW
>GoiKg]W>GliIoUo>FLiOoUW<P02Kg/07WliIcU_NgliIoUo>FLiOcUWnGli
IoUo>FLiOcUWnGliIcUo>FmkMkeW>GliIcUonFmkOcUWnGliIoU_N`9o>@03
IoUo<Vmk009_N`0?OcUWnGliIoU_NfLiOcUWnGliIcUonFLiOoUW>Gli009_
N`06OcU_NfmkIcUonFmk0Gli00003GoiIcUonFLiOcUWnGliIoUo>FOiIcUo
>FOi009o>@05IoUo>GNmDY@aS00hOol03VLiOomg_FLi>LiBU3W>124Q21BU
8@PDYB485:D28@P25:D04B485:DQ21BU8@PDYB485:DQ21BU8@PDYB485:DQ
21BU8@P00QBU00hQ21BU8@PDYB485:DQ21BU8@PDYB485:DQ21BU0b480QBU
00LQ21BU8@PDYB485:DQ20025:D09B485:DQ21BU8@PDYB485:DQ21BU8@PD
YB485:DQ21BU8@PDYB485:DQ21BU8@PDYB485:DQ21BU8@PDYB485:DQ21BU
8@PD[248008DY@038@PDYB48008DY@0_8@PDYB485:DQ21BU8@PDYB485:DQ
21BU8@PDYB485:DQ21BU8@PDYB485:DQ21BU8@PDYB485:DQ21BU8@PDYB48
5:DQ21BU8@PDYB485:DQ21BU8@PDYB485:DQ20025:D2<H`25:D58@P031BU
125oofmk:DYBU6mkIoUo>FmkOcUWn@9o>@0CIoUo>FmkOcUW>FmkOcUWnGli
Kg]o>FOiKg]o>FmkOcUonE[FOoT00Vmk00=o>FOiOcT00Vmk01MW>GliIoUo
>FmkOcUWnGliIoUo>FLiOoUW>GliIcUonFLiOcUW>GliIoUW>Gli009_N`0J
OcU_NgliIoUo>FLiOcU_NgoiIcUo>FOiOcUW>FOiOcUonFLiOcU_NfOiOcU_
NgliIcUon@5W>@0001AW>GliKg]o>FOiOcU_NgliKg]W>GoiKg]o>FmkIoUo
>FLiMkeW<RU:>7oo00Q_Ne:DMkeW>D8@BTag_CW>;DYB00=244YBBU80;4YB
00=244YBBU80=DYB00EBU36<<:a_NcW>00I:DP0HDY@007ooKg/aS4YBOoUo
>FmkOcUWnGliIcUWnGliIcUo>FOiOcUWnGliIcUonFLb0Vmk00Qo>FOiOcUW
nFLiOoUW>Gli0Vmk01=o>FOiOcUW>GoiKg]o>FOiOcUWnGliKg]o>FLiOoUW
>GliIoUo>@03Kg/057liIoUo>GliIoU_NgliIoUo>FOiOcUW>GoiIcUonFLi
OoUW>GliIoT2OcT02VOiIcUo>FOiKg]o>FmkOcUWnGli0Vmk000017oiIcU_
Ngli0Vmk00iWnGliKg]o>FLiMkeWnGliIcUo>FOiOcUJeS6<>7oo00QW>D8@
OomW>C9<BI9W>C6<0d8@00=:DT8@>Lh00d8@00=:DT8@@Q008D8@00=:DT8@
@Q001d8@00=:DT8@@Q002D8@00DicT8@BU8icTYB00e24005BI8bDTY<@Q1:
DP02@Q000dY<@Q124005@Q000dVB@Q124003@Q000dYB@Q124006@Q000dYB
>Li:DP05@Q000dYB@Q124002@Q000dYB>Li2400:@Q000dYB@Q0icP04@Q00
1DYB<H`aQE[F>Lh01T8@00M:DP00Oom_NbU:Ic9g_@02Kg/05FOiOcU_Ngoi
IcUo>FOiOcUW>GoiIcUonFmkOcU_NgliIoUo>FLiKg]o>@02Kg/02GoiIcUo
>FOiKg]o>FOiOcUW>@02Kg/01gliIcUo>FOiOcU_NfOi009o>@09IoUo>FOi
OcU_NfLiOoUW>FOi009o>@08Kg]W>GliIoUW>GliKg]o>@9_N`07OcUW>Goi
IcUo>FOiKg/00Wli00UWnGliIoUW>GliIoUo>FOiOcT00Fmk000056mkOcUo
>FOiOcU_NgliIoUo>FLiOoUW>GliKg]o>FOiOcUg_FLb:DX2Ool00fLoOomo
o`02Ool01S<o0Umoogoo5UTbG`Aoo`05F]Ig_GooIcUoo`02Mkd016LiOomo
ofmk0Woo00IJeWooOomBU7ooIcT2Ool02gNmIcUoogooIcUoogNmF]IoogNm
F]H00Woo00eJeWooOomBU7ooIcUoogliKg]9TT8@F]HaS003@Q000c6<@Q12
4002>Lh00d8@<H`aS004@Q02<H`2@Q00136<@Q0icT8@0SW>00A243W>@Q1:
DP8aS004BU8icS6<@Q02>Lh01D8@>Li2448@>Lh00T8@00LicS6<@Q0icT8@
>Li24002>Lh00d8@>LhaS002@Q001C6<@Q1243W>@Q000SW>00U243W>@Q0i
cS6<BU8aS3W>@Q000SW>0T8@0SW>0T8@00DicS6<@Q0bC48@00@icP03<H`b
DSW>00=2408icP0;BU8bC3W>>Li243W>@Q0aS3W>@Q0icP02@Q001CW>@Q12
436<BU8013W>00Y243W><Ha243W><Ha:DS6<@Q0icP924006>Li243W>@Q0i
cT8@13W>00Y2436<@Q0icT8@BU8aS248IcTaS0=2400V>Li2448@BU8407oo
Kg/YBU:DKg]o<VmkOcUWnGliIcUo>FOiOcUWnGliKg]o>FmkIc9_NgliIoUo
>FLiOoU_NgliIoUo>FLiOcUWn@9o>@=_N`05OcUWnGliIcUon@02Kg/01VOi
OcUo>FLiIoUo>@9_N`04OcU_NgoiIcT2OcT07VOiKg]_NgoiIcUo>GoiIcUo
nFLiIoUo>FLiOoUW>GoiIcU_NgliKg]WnGliIcUo>FmkOoUW>GliKg]Wn@5o
>@0002Uo>FOiIcUo>FOiOcUW>GliIoUo>FmkOoUW>GliIoUo>FOiOcUJeRU:
OomW?`<oIcmWo`6O<cm;?gooMkd3?goo<cl2GgloOom_Nd8@5:Eg_FLi009o
o`0M5:D007ooOol007oo<H`007ooDY@icTYBOolDYGoo000icT8@Kg/DYFLi
MkdYBTYBF]HQ26LiMkdYBP02BU802SW>BU9W>FLiMkeW>CW>@Q1W>C6<0T8@
0SW>00Q:DT8@<H`icRU:@Q1:DS6<0d8@00DicVII<T`aS48@008aS08icP0:
DY@icT8@@Q0YBTYB@Q0YBS6<DY@3<H`3@Q004cW><Ha:DT8@<Ha:DRU:>Li2
43W>@Q0icT8@:DXicT8@>LhYBTYB00A2408aS007BU80YGooOolDYBU:@Q00
0SW>00HaS5:D>Li243W>@Q03<H`035:D<Ha9S48@<Ha243W>:DYVDSW><H`i
cP92408icP05BU99S36<>Li24002<H`00dYB<Ha24002@Q05>Lh02D8@>Lha
S48@>LhYBSW>BU8Q2002@Q000c6<@Q0aS002>Lh02DYB@Q1243W>@Q0icRU:
>LiBU002:DX02Woo:DXaS4YB>Li:DS6<:DYW>C6<148@00TicTYB@Q0087oo
Kg/aS5:DOoT00Vmk00Ao>FLiIoUo>@=_N`0SOc9_NfOiOcUWnGliKg]WnGli
Kg]o>FLiOoUW>GliIoUo>FOiOcUW>FOiOcU_NgliIoUo>FOiOcUW>GoiIcUo
>FOiKg]o>@02Kg/02GlbKg]WnGliIcUonFLiKg]o>@02Kg/03WliIoUW>Gli
IoUo>FmkOcUWnGliIcUo>FmkOoT2Kg/02GlbKg]_NgoiIcUo>FLiOoUW>@02
OcT1IoT0000SIcU_NgoiIcU_NgliIoU_NgliIoUo>FLiOcUWnGliIcUo>GNm
Ic8aS7oo0Umooc<o0UUoo`9O<cmo?fOo5UmWoc<o5cmWo`03Ool00c6<Kg]o
o`02Ool01dYBMkeoo`008@QoofLi009oo`0A>LioocW>Ool48E:DOomJeWoo
:DY_NfLiBU9g_D8@Oom_N`02DY@02GooIcU:DWooBU9JeWooKg]W>@02@Q00
26Li<Ha2448@<Haoo`aS:DX2Ool0A5:DOcUJeT8@>Li242U:Oom:C48@IcUo
ofLiOolYBWoo@Q0icT8@<Ha:DWNmOom:DVmkIU9BU6mkOom243W><Ha:DWoo
8@PDYGNmF]I_NgNm8@QoobU:Kg/icWooKg]onFIBBUUooc6<>Li2436<Mkeo
obU:OcUW>GNmF]I;>GliOolYBWooDY@2<H`03FLiDY@icWooF]I_NcW>OolQ
27ooBU9W>Fmk009:DP0@Oom243W><HaBU7oo001BU7ooMkdYBWooDYAoogNm
:DX2@Q00;248OolaS3W>Ool48FmkOom:DU[FKg]JeWooDYAg_Goo5:EW>DYB
OolYBSW>@Q0YBWoo36=W>GoiIcU246LiOcUg_FLiF]HYBT8@BU8aS248IcTa
S48@>Lh5@Q003P@0Oom_NbU:IU9g_FmkOcUWnGliKg]o>FOiOc82Kg/016Oi
OcUW>Gli0Vmk00Eo>FOiOcUWnGli00A_N`0]OoUW>GliIoUo>FmkOcUWnGli
IcUo>FOiOcUW>GliIoUo>FLiOoUW>GliIoU_NgliIcUonFLiOoUW>GliIoUo
>FmkIcUonFmkOcUW>GoiIcUo>FOiOcUWnGlb009_N`08OcU_NfLiOoUW>Gli
IoUo>@9_N`5o>@5Wn@5o>@0000IonFLiOcUWnGliIoT2OcT036OiOcUW>Goi
IcUo>FOiOcUWnGliF]HYBP9oo`055cmW?gooOomWo`02<cl017oo<UTc?c<o
17oo00=240aSMkd00goo00h0048@OomJeP00Ool0036<Ool005:DKg/icTYB
0VLi020aS5[F@Q0Q27oo001247ooKg/007oo000YBWoo@Q048Goo8@QoogNm
IcTicT8@F]HaS4YB>LhYBWooDYAJeWoo0WNm0Woo00iBU2U:BU8YBWoo>LiW
>Goo@Q1g_Goo>Lig_ABU0T8@00/aS7oo@Q0Q236<OomJeWooF]Iood8@008i
cP06<Haoofmk@Q1oob480Woo00lQ27ooBU9ooe[FKg]:DWooIcUonDYB:DY:
DSW><H`00Woo01M:DWooOom:DVmkOolaS7oo:DYooaBUBU8aS4YBOomJeSW>
Oomg_FLiOolYBWoo009g_@04OomJeWooOol3>Lh0148@Oom247Nm0Woo01<i
cWooMke:DWoo:DY:DRU:BU9oodYBDYAoob48IcUoogNmIcUoo`02BU803Goo
F]I_NgooIcUoofLiOolYBT8@8@Qooe[F009g_@0>Oom_NgNmKg]ooc6<OolY
BT8@BU8aS2U:IcTaS0=2400:>Li2448@BU8007ooKg/YBU:DOcT2Kg/0>7lb
IoUo>FOiOcU_NgliKg]o>FOiOcUWnGliKg]o>FLiKg]o>FOiOcU_NgliIcU_
NgliIoUo>FLiOoUW>GliIoUo>GNmOcUWnGliKg]o>FOiOcUW>GoiKg]o>Fmk
IoUo>FmkOcUW>GoiIcUo>FOiOcT2Kg/01glbIoUo>FLiOoUW>Gli00A_N`03
Oc9WnGli009_N`07OcUWnGliIoUo>FmkIcT00Vmk00003VLiOcUWnGliKg]o
>FLiIoUo>FLiOoUW>FOiOcT2Kg/017liKg]W<S6<0Woo00=;?gooOol00goo
00=WogooOol01Woo00=BU6LiOol00goo00UW>FmkOomooe:DOomW>GNmOol0
0U[F00Ioofmk@Q1ooe[FBU82Ool045[FOomW>E[FMkeW>E:DOom_Ne:DKg]o
oe:DOomW>Goo0Vmk00@icT8@IcTaS092400>:DYoobU:<Ha247oo>LiW>GNm
<Ha243W><Haoo`8YBP0DBU9oofmk>LiW>Goo@Q0icT8@:DYoocW>8@QBU4YB
Kg]246LiOom240<icP08OolicR48F]Ig_CW>IcUBU09JeP0BDYA_NbU:BU9o
ob48Oomg_C6<>Li242U:OomJeVLiDYA247oo0U:D00E245[FDYAooe:D00<i
cP07Oom_N`00IcUooc6<Mkd00U:D00ag_C6<BU9_NdYBOom243W><Ha:DWoo
36<2BU802fLiKg/icSW>Oomg_BU:@Q0Q27oo>Lh00Woo00@icWNm<HaBU09W
>@0P:DYJeWoo<Ha_Ne[FDYA:DU[F<Haooc6<@Q0YBWoo>LioodYBDYAJeU:D
MkeW<Vmk@Q0aS48@BU8aS32UF]HicP92400=>Li2448@@Q1:DP00Oom_Nc6<
BU9onFOiOcT016mk00Uo>FmkKg]o>FOiOcU_NgliIoT00Vmk01Eo>FObKg]o
>FOiOcUWnGliIoUo>FmkOcUWnGliIcUonFmkOcUW>FOiOcT00Vmk01=WnGli
IcUonFLiOcU_NfOiOcUW>GliIoUo>FLiOoUW>GliIoUo>@03Kg/02fOiOcU_
NfmkOcUWnGliKg]o>FOiOcT00Vmk00Qo>FOiOcUW>GliIoUo>FOi0Wli0000
57oiIcUo>FOiOc9WnGliIcUo>FOiOcU_NgliIoUo>GNmKg]o>E[F:DXhOol0
16mkOom_NfLi0T8@00eW>C6<@Q1242U:OomW>E[FIcUood8@5:DaS003@Q00
1RU:Oom_NfLi021BU09oo`038@Q243W>00924008<Ha247ooOomBU2U:8@Pa
S09oo`0<@Q0icSW>>LioogNmDY@Q236<>LhYBSW>136<0SW>00hYBSW>>Li2
43W>@Q0icS6<Oom241BU>LhaS2U:0S6<02dicS6<<Ha2436<@Q0aS6LiBU9J
eWoo36<YBSW>:DXicS6<:DY2436<8@PaS7oo@Q0aS3W>BU9ooe:DIcUooaBU
<H`icQBUDYAoobU:>Li:DWoo36=g_Fmk36<00Woo00PicR48<Ha240aSOom:
DR480S6<00@icS6<>LhYBP92400C:DYoob48Mke_NaBU36=_Ngoo0:DaS3W>
@Q0icTYB<H`Q26Li<H`0148@01`icT8@@Q0407ooKg/YBVLbKg]o>FOiOcU_
NgliKg]WnGliKg]WnGliIoUo>FLiOcU_NgliIoUo>@9_N`0JOcUW>GliIoUo
>FOiOcUWnGliIcUonFLiOcUWnGliIcU_NgliIcUo>FOiOcUW>GoiIcUo>@9_
N`0<OcUWnGliIoUo>FLiOoUW>GliIoUo>Fmk0Wli00MWnGliKg]WnGliIoUo
>@03Kg/02gliIoUW>GliIoUo>FmkOcUWnGliIoT00Fmk00000fLiOcU_N`02
Kg/03gliIoUo>FmkMkeW>GliIoUo>FmkIc9_NgoiF]HaS00hOol026LiOom_
Ngli>Li245[F<H`3@Q002B48@Q12436<:DXicTYB@Q0icP03@Q001bU:>Li2
44YB>LhYBS6<008icP04@Q0icT8@@Q04<H`00d8@BU924002:DX3@Q000cW>
:DXicP0>@Q02>Lh4@Q000c6<>Li:DP08@Q00136<@Q12448@0SW>00<aQD8@
@Q002T8@00TYBSW>@Q1:DS6<:DY:DSW><H`00d8@00=:DSW><H`00T8@00<i
cS6<@Q000S6<00=2436<:DX0148@00=:DRU:>Lh02T8@00TYBT8@<H`icT8@
BU8icRU:BU801D8@00HaS2U:IcTaS48@>Lh4@Q003DYB001oofmk:DYBU7li
Kg]o>FOiOcUWnFmk009o>@0:IoUo>FLiOcU_NfOiOcU_NfOiOcT2Kg/067li
IoUo>FOiOcUW<VmkOcU_NfLiOoUW>FmkOcU_NgliIoUo>FOiOcUWnGliIoUo
>@9_N`0BOcUWnGliIoUo>FLiOcUWnGliKg]o>FOiOcU_NgliIcUWnGli0Vmk
00eo>FmkOcUW>GoiIcUo>FOiOcU_NgliIcUon@02Kg/00fLiOcUW>@01OoT0
0004OoU_NfmkOcT2Kg/02GliIoUo>FLiOoUW>GliIoUo>@02Kg/00gliIc8Y
BP0hOol016mkOom_NfLi0T8@00=W>CW>@Q000T8@00=:DSW>@Q001D8@00=:
DT8@@Q001T8@00=:DT8@BU800T8@00A:DT8@@Q1:DPI24003BU92448@0092
4003BU92448@00924007BU92448@@Q1:DT8@BU801D8@00=:DT8@BU801d8@
00=:DT8@@Q00148@00=:DT8@@Q000T8@00I9TTYB>Li:DT8@BU82@Q000dYB
@Q124002@Q000dYB@Q1:DP02@Q000dYB@Q0icP0>@Q000dYB@Q124002@Q00
1DYB@Q12448@BU802T8@00=:DT8@@Q00248@00U:DT8@@Q1BU36<<HEW>CW>
BU80148@0TYB00H407ooKg/aS5:DOoT2Kg/02WliIcUo>FOiKg]W>GliIoUo
>Fmk0Wli01mWnGliKg]_NgliKg]WnGliKg]o>FOiOcU_NfOiOcU_NgliIoUo
>FOiOcUWnGliKg]o<VmkOcU_NgliIoUo>@02Kg/03gliIo9o>FOiOcU_Ngli
IoU_NgliIcUWnGliIoUo>@02Kg/057liIoUo>FLiOoUo>FLiOoUW>GliIoUo
>FOiOcUW>GliIoUo>FOiOcT1IcT00005Kg]W>GliIoUo>@02Kg/03GliIoUo
>FLiOoUW>GliIoUo>FmkOoUVFBU:03Qoo`09IcUoofmkIcTaS48@F]HDYCW>
014aS005:DXaS36<<H`YBP0F<H`00bU:<H`aS004<H`00bU:<H`aS005<H`0
0bU:<H`aS005<H`00bU:<H`aS008<H`00c9<:DXaS002<H`00bU:<H`aS007
<H`00bU:<H`aS00B<H`00bU:<H`aS002<H`00bU:<H`aS003<H`00cW><H`a
S005<H`00bU:<H`aS00;<H`01CW>8@PDYE[F8@P01c6<02<007ooIcTYBU:D
MkeW>GliIoUo>FOiOcUW>GoiIcUo>FOiOcU_NfOiIcUo>FOiOcUWnFmkOcUW
>GliIoUo>FLiOoUW>Gli009_N`06OcUWnGliIc9_Ngli0Vmk00QonFLiOoUW
>GliIoU_Nglb0Vmk00=o>FmkKg/00fmk00Io>FOiOcUo>FOiOcT2Kg/05Gli
IoUo>FLiOoUJeVOiOcU_NgliIoUo>FLiOcUWnGliIoUo<VmkOcUWn@01OcT0
009o>@04IoUo>FOiOcT2Kg/037liIoUo>FLiOoUW>GliIoUo>FmkIc8aS0Mo
o`06<cmoogooBcm;ogNm1goo00=242U:Ool017oo00=BU7NmOol02Goo00<i
cTYBOol03Woo00A_NgooMkeoo`924003Oom:DU[F00AJeP03DYAJeU[F00=J
eP04DYAJeVLbIUT3F]H01FIIF]IJeU[FIUT00U[F00=BU5[FF]H015[F00=B
U5[FIc800U[F00IBU5[FF]IBU5[FIUT2F]H01FLbF]IJeU[FDY@00U[F00=V
FE[FF]H00U[F00ABU5[FF]IVF@EJeP03IUUW<VLi00EJeP03IUUJeU[F009J
eP03IUUJeU[F009JeP04IUUJeU[FDY@6F]H016IIF]IW<VII15[F00=VFFLb
F]H02U[F00=VFE[FF]H00U[F00AW<U[FF]IBU09JeP03IU9JeU[F00AJeP03
IUUJeU[F00UJeP08DYAJeVIIIcUBU2U:Oom:DPAJeP04IUUW>FLi36<2Ool0
6S6<IU9onGloIoUo>FLiOcUWnGliIcUonFLiOcUWnGlbKg]o>FOiOcUW>Gli
IoUo>FOiOcT4Kg/09GliIoUo>FOiOcUW>GNmKg]o>FOiOcU_NfLbMkeW>Goi
IcUo>FmkIoUo>FmkIoUo>FmkOcUWnGliIcUo>FOiKg]o>FLiOoUW>Gli009_
N`0>OoUW>GoiIcU_NgliIoUo>FmkOoU_NgliIoUo>@=_N`5o>@5Wn@0000aW
>FOiOcU_NfLiOoUW>GliIoUo>FOiOcT5Kg/00goiF]HYBP04Ool01C<oMkdc
?aLoOol00T/o018FGgooIcmWogooF]HYBS6<Mkd0036<OolQ27oo5:Eood8@
36<4Ool020aSBU9oobU:5:Eooc6<000?Ool01fLiOomW>C6<F]HYBT8@00I:
DP03DYA:DTYB02=:DP03DYA244YB00E:DP05@Q1:DTYBBU924002BU801T8@
BU9:DTYBF]I240A:DP04@Q1:DTYB@Q03BU80148@BU9:DT8@0dYB00=244YB
BU8014YB00A244YBBU9240A:DP05@Q1:DTYBBU92400NBU800e:D@Q1:DP06
BU800d8@BU9VDP07BU800d8@F]I:DP05BU804E:D@Q1W>E:D<Ha;>GliIo9o
>FLiOoU_NgliIoUo>FmkOcT00fmk01Uo>FOiOcUW>GliIoUo>FmkOcUWnFmk
OcU_NgliIoUo>FmkOcUW>GoiIcUo>FOiIcUo>@02Kg/01gliIoUo>FmkOcUW
nGli009_N`07OcU_NgliIoUo>FLiOoT00Vmk00Yo>FOiOcUW>GoiKg]W>Goi
IcUo>@9_N`0;OcUWnGliIoUo>FmkIc9_NgliKg]Wn@02OcT1IoT1OcT0000D
OoU_NfmkOc9_NfLiOoUW>GliKg]o<VOiOcU_NgliKg]o>FmkIc8aS0Aoo`09
0Ulc?`9OIomoo`<oOolc?goo0082G`0;OomW>@00001oobU:F]IoocW>000Y
BP02Ool01WNmOomoogooF]H0008aS005DY@007ooIcT0000?Ool027NmOom_
Ne:D>LiJeRU:>Lh3<H`01dV<<Ha244YB:DXicS6<00@icP8aS08icP06<H`i
cS6<<H`icS6<0SW>00DaS3W>>LhicS6<008icP03<H`icS6<008icP06<H`i
cSW><H`icS6<0cW>00@aS3W>@Q0aS0924005>LhaS4YB>Li24003>Lh00d8@
>Li:DP02<H`02T8@:DY:DS6<>Li2436<@Q0aS4YB0S6<00I243W>@Q0icTYB
>Lh2<H`01dYB>LhYBTYB>LhaS48@008icP03@Q0icT8@008icP03@Q1:DS6<
008aS005>LhaS3W>>LhaS002>Lh01S6<>LhicS6<>LhaS08icP0:<H`icSW>
<H`icS6<>LhaS3W><H`2>Lh00c6<>LhicP03>Lh2<H`3>Lh01RU:DY@aS36<
>LhaS08icP04:DXicT8@:DX2@Q02>Lh01d8@:DY:DWoo8@QVDWNm009_N`09
OcUW>FmkMkeo<VOiOcUWnGli00=_N`0@OcUWnGliIoUo>FLiOoUW>GliKg]W
nGliIoUo>FOiOcT2Kg/01gliIoUo>FmkOcUWnGli009_N`04OcUWnGliIoT2
Kg/07GlbIoUW>GliIoUo>FLiOoUW>GliIoUo>FLiOoUW>GliIoUo>FLiOoUW
>GliIoUo>FmkIcUo>FOiOcT00fmk00Ao>FLiIoUo>@9_N`0001A_NglbKg]_
NgliIoUo>FmkOcUWnFmkOcU_NgliIoUo>FLiOoUBU36<17oo00P2GgooBcm;
?goo0IUWoaLo1Goo0P0000Eoo`aSDYAooaBU008000Ioo`800007MkdDYGNm
001ooe[F00003goo00I_NgooMke_NcW>Kg/3Mkd2Ool2Mkd01T8@Oom_NfOo
OcUWo`A_N`0<Mke_NfmkMkeWnGliIom_NgNmIoUo>FOo0Vmk00Mo>FOoKg]_
NgNmKg]g_@02Kg/01gNmKg]_NgNmIoUo>FOo00=_N`9oo`9g_@04F]Ioogoo
Kg/6Ool02P00OomoogooMkeoofmkMkeoofLi0goo00QW>GooOomg_GooKg]o
ofmk0goo00AW>GooOom_N`Aoo`03Kg]JeWNm009g_@9oo`06IcUoofmkMke_
NgNm0fmk00]g_FmkKg]g_FmkMke_NgNmKg]o>FOo009_N`0;Mke_NgNmKg]g
_FmkMke_NfOiOcUWo`05Kg/01gNmKg]_NgNmF]IBU7oo009_N`07Oom_NgNm
Mke:DWNmOol00T8@00QBU48@DYAg_D8@OolYBU:D0Vmk02Yo>FOiOcUonFLb
Kg]o>FOiOcUW>GoiKg]o>FOiOcUW>GliKg]onFLbKg]o>FOiOcUW>GliKg]o
>FOiKg]o>FOiOcUWnGliIoUo>FmkIcUonFLiOcT2Kg/2OcT2Kg/05GliIoUo
>FOiOcU_NgliIoUo>FLiOoUW>GoiIcUo>FOiOcUW>GliIoUo>@02Kg/017oi
IcU_Ngli0Vmk00Io>FOiOcU_NgliIoT1OcT000=_N`0AOcUWnGliIcUonFLi
OcUWnFmkOcUWnGliIoUo>GNmIc8YBP04Ool026OoOomooaLoOomWofLo<cl4
Ool00e:D124Q2002:DX00`00Oomoo`09Ool02000IcUJeQBU001oobU:36<?
Ool01fmkOom_Ne[F>LiW>E:D00=:DP06@Q1;>E:D@Q1W>FIB0U:D00IVDU:D
DYAJeU:DIU83DY@00e[FDYAVDP02DY@00e[FDYAVDP03DY@00fIBDYABU003
DY@00e[FDYAVDP03DY@02U[FDYAVDU:DBU9oo`aS001oo`000R4800P<H`@0
36<0036<5:DYBQBU0P00019W>D8@001W>@00MkdYBSW>Ool003W>001g_BU:
5:D400aSF]H200006goo>Lh004YBOol000@0Mkd000@0>LhQ25:D001BU0@0
0200048@Kg]:DU[FIU9BU5[FDYAVDP02DY@00d/bDYABU004DY@00fIBDYAB
U005DY@01U[FIU9BU5[FDYAVDP9BU005F]IBU5:DIU9BU002F]H01d8@DYAJ
eU:DF]I245[F009BU003@Q1JeVmk00=JeP08IcTaS5:DBU9ooc65DYAon@9_
N`04OcUWnFmkOcT3Kg/027liKg]W<WoiIcUo>FOiOcT4Kg/02WliIoUo>FOi
OcUWnGliIcUo>FOi0Wli00mW>GliIoUo>FmkIo9o>FLiOoUW>GliIoU_NfOi
OcT00Vmk01=o>FLiOcUWnGliIcUg_FLiOcU_NgliIcUonFLiOcUWnGliIoUo
>@02Kg/01GliIcUonFmkIoT00Wli00IWnGliIoUo>FLiOcT1IoT00009OcU_
NgliIoUo>FLiOoUW>Gli009_N`09OcUWnGliIcUo>FOiOcUW>BU:03Qoo`0@
Kg]oogNmIcTicVLiKg]BU36<@Q1:DS2UIcU246mkDY@5F]H015:DF]IJeU:D
0U[F00=BU5[FF]H00U[F00=BU5[FF]H02E[F00=BU5[FF]H00e[F00QBU5[F
F]IJeU:DOolQ20000Woo01@aS000@Q0YBP008@PicQBU@Q0001BUOol00248
5:D005:D124006Li0P0000XDYGoo000005[F001W>@00Oom240800005Ool0
0000Ool<H`0200003CW>Oom_Ne[F36=oo`00101oo`00MkeW>E:D009JeP03
DYAJeU[F00=JeP04IUUW<U[FDY@:F]H015:DF]IJeU:D15[F00=BU5[FF]H0
0U[F00MBU6LiBU9BU6mkBU9oo`02<H`01gNmF]I245[FKg]JeU:D009W>@0=
>LiJeTYBOolES6IBKg]onGliIcU_NgliIoT00Vmk00=o>FOiOcT00Vmk01Mo
>FOiKg]o>FOiOcU_NgliIoUo>FLiOcUWnGliIcUo>FOiOcUW>FOiOcUWnGli
009_N`0;OcU_NgoiIcUo>FOiOcUW>GliIoUo>@02Kg/03gliIoUo>FOiOcUW
>GoiIcUonFLiOoUW>GliIoUo>@02Kg/01gliIoUo>FLiOoUW>Fmk009o>@07
IoUW>GliKg]o>FOiKg/00Gli00000fOiOcU_N`02Kg/00goiIcUon@02Kg/0
2WliKg]_NfLiOoU_NgliIoUVDS6<>7oo019_NgooKg]W>CW>IcUBU7ooKg]g
_GooKg]BU48@Kg]BU5[FDY@;F]H00e:DF]IJeP02F]H015:DF]IJeU:D0e[F
00=BU5[FF]H00U[F00=BU5[FF]H00e[F00]BU5[FF]IBU7oo001g_@00:DYo
oaBU008000055:D00000000icP0200004S6<DY@48DYB000Q24YB001_N`00
<H`004YB5:DaS000100<H`800005MkdQ2000:DYW>@0200001Vmk00048D8@
Oom_N`8000058@PDY@008@Qoo`02F]H01E:DF]IJeU[FDY@00e[F00=BU5[F
F]H00U[F00ABU5[FF]IBU09JeP05DYAJeU:DF]IBU003F]H00e:DF]IJeP02
F]H00e:DF]IJeP02F]H01dYBDYA_NdYBIcUooe:D009JeP0V@Q1JeVmkDYAJ
eU:DF]HicU[F@Q1oobU:DYAonFLiOcUonFLiOcU_NgNmOc9WnGliIoUo>Fmk
OcUW>GliIoUo>FLiOoUW>GliIoUo>@9_N`03OcUWnGli009_N`0eOcUW>Goi
IcU_NgliIoU_NgliKg]o>FOiOcUWnGliIcUo>FOiOcU_NfOiOcU_NgliIoUo
>FLiOoUW>GliKg]o>FOiOcUW>GoiIc9_NgliIoU_NgliIoUo>FLiIoUo>Goi
IcUo>FOiOcU_N`01IoT0000DOcUW>GoiIcUonFLiOcUW>FmkOcUWnGliIcUo
nGliIcU_NgloIc8YBSQoo`06Kg]oogoiF]HicVLi0U:D00=JeU:DDY@00U[F
00=246LiDY@00e[F00aBU5[FF]IBU5[FDYAJeU:DF]IBU5[FDY@2F]H00e:D
F]IBU002F]H00e:DF]IBU002F]H0<E:DF]IBU5[FDYAJeU:DF]IBU5[FDYAJ
eU:DOol006mk000Q2000OomBU7ooKg]BU7NmDYAoofLi@Q1oob48001oodYB
Ool48C6<Ool007ooBU9oo`00@Q1oogNm@Q0007oo009g_@08@Q1g_GooBU9o
oe:D001oo`9BU007IcUJeWNmDY@005[FOol00e:D00YJeU:DF]IBU5[FDYAJ
eU:DF]IBU09JeP04DYAJeU[FDY@2F]H00e:DF]IJeP05F]H00e:DF]IBU002
F]H01U:DF]IBU5[FDYAW>@9:DP04IcUBU5:DDY@3F]H0648@F]I_Ne[FDYAW
>E[F>LiJeTYBOolYBU:DMkeo>FOiIcUonFmkOcUW<VmkMkeW<P9_N`0;OcUW
nGliIoUo>FLiOoUW>GliIoUo>@02Kg/027liIoUo>FOiOcU_NfOiOcT2Kg/0
4WliIoUo>GliIcU_NfOiOcUW>GliIoUo>FmkMkeW>GoiOcUW>@9_N`03OcUW
nGli009_N`06OcUWnFmkOcUWnGli0Vmk00io>FOiOcUo>FmkOcUWnGliKg]o
>FLiIoU_Ngli0Vmk0Gli000056mkOoUW>GliIcUonFLiOoUW>GoiIcU_Ngoi
IcU_NgoiIcUonE[F<:`hOol01VmkOom_NfLi>Li_N`IJeP03IcTicVmk02YJ
eP07Mke_Ngoo@Q1ooe[FKg/00U[F00Ag_E[FKg]BU09_N`06DYA_NgNmF]I_
Ne:D0Vmk01IJeWNmF]I_Ne:DMkeW>E[FKg]W>GNmIcUBU5[FKg]JeU:DKg]J
eVLiMkeW>@9JeP04DYA_NfLiIcT2Mkd00e:DF]IJeP0KF]H00fLiF]IJeP08
F]H00dYBDYA_N`04F]H01FLiF]I246LiF]H016mk00Ug_DYBBU9oobU:IU9_
NfOiOcT00Vmk01Yo<VOiOcU_NgliKg]o>FmkIoUo>FmkOcUWnGliKg]o>FOi
OcU_NgliIoU_NgliIcUo>FOi0Wli00EWnGliIcUonFLi009_N`0GOoU_Ngli
Kg]onFLiOcUWnGliIcUonFLiOcUonFLiOoUW>GliIoUo>FOiIcUo>@02Kg/0
0gliIoUo>@02Kg/02GlbIoUW>GliIoUo>FOiOcU_N`02OcT016OiKg]o>FOi
0Gli000057liIcUo>FmkOoUW>GoiIcUo>FLiOcUWnGliIoUo>FLiOcUg_FLb
<H`hOol01FmkOomg_FLi<H`01fLi0U[F00E_NfLiF]IW>E[F009W>@03F]IW
>FLi00MW>@03F]IW>FLi009W>@03F]IW>FLi00=W>@03F]IW>FLi00eW>@05
F]IW>GNmF]IW>@02F]H016LiF]IW>E[F0VLi0U[F0fLi00=JeVLiIcT016Li
00=JeVLiIcT00VLi00AJeVLiIcUJePEW>@05F]IW>FLiIcUJeP04IcT015[F
IcUW>E[F3fLi00AJeVLiIcUJePEW>@03F]IW>E[F00=W>@04F]IW>FLiF]H6
IcT01fmkDYAJeVmkF]IW>E[F009W>@03F]IBU6mk00=JeP03DYAJeVLi009B
U005OolYBU:DOoUo>@02Kg/04WliKg]_NfmkOcUWnGliIoU_NgliIcUo>FOi
IcUo>FmkIoUo>@9_N`0IIoUo>GliIcUonFmkIcUo>FOiOcUW>GoiIcUo>FOi
OcU_NgliIcUg_FLiOcU_NgliIoT00Wli011_NfOiIcUonFLiOcUWnGliIcUo
>FmkOcUWnGliIoUo>@9_N`0@OcU_NfmkOcUWnGliIcUo>GoiIcUonFLiKg]o
>FmkOcT1IoT0000DIoUo>FOiOcUW>GliIcUonFmkOcUWnGliIcUo>FOiOcUW
nGliF]HYBQ1oo`03000<Hgoo02Eoo`06MkdaS7ooF]IBU3W>1d8@0U:D00<i
cTYB@Q00348@00=:DT8@@Q000T8@00=:DT8@@Q006D8@00A:DT8@@Q1:DPA2
4003BU92448@00i24003BU92448@00Y24003BU92448@00924003BU92448@
01124003BU92448@00I24003BU92448@00=24003BI8bDTY<00Q24004BU92
448@BU85@Q02DY@3@Q003TYB@Q12448@BU9g_C6<DYAo>FOiOcU_NfOiOcT3
Kg/03gliIoUo>FOiOcUWnGliKg]onFLiOcU_NgliIc9on@02IcT01GoiIcUo
>FOiOcT00Vmk02IW>GoiIcUonFLiOcUWnGliIcUonFLiOoUW>GoiIcUo>FOi
IcUo>FmkOcUW>GoiIcUo>FmkOoUW>GliIoUo>FLiOcUWnGliKg]WnGli0Vmk
00ao>FOiOcU_NfLbOoUW>GoiIcU_NgoiIcT1OcT0000DOcU_NgliIoUo>Fmk
OoUW>GliIoUo>FLiOcUWnGliIoUo>FmkIc8aS11oo`0>F]H006mkMkdYBWoo
<H`YBWNmF]HicR48>Lioo`8DY@04Ool48D8@Ool3>Lh01D8@8@Qg_Goo<H`0
0cW>00HYBR48BU9BU36<BU82Ool01GNm36=:DWoo@Q001E:D00M:DU:DDYAB
U2U:IcU:DP08DY@02DYBDYABU5:DBU9BU4YBDYA:DP02DY@014YBDYABU4YB
1E:D00=:DU:DDY@00U:D00A:DU:DDYA:DP=BU005BU9BU5:DDYA:DP02DY@0
14YBDYABU4YB15:D00E:DU:DDYABU4YB00=BU003BU9BU5:D009BU007BU9B
U5:DDYA:DU:DBU8015:D00E:DU:DDYABU4YB00=BU008BU9BU5:DBU9BU4YB
DYA:DPIBU003BU9BU5:D009BU004BU9BU5:DBU84DY@01dYBDYABU5:DBU9B
U4/b009BU003BU9;<U:D00UBU005BU9BU5:DBU9;<P02DY@015[FBU8aS5[F
1e:D011:DVmk8@Q247oiKg]o>FOiOcUWnGliIcUonFLiOcUW<P9_N`0MOcUW
nGliIcUo>FOiOcUWnFmkOcUW>GoiIcUonFLiOcUWnGliIcUonFLiOcU_Ngli
IoUo>FLiOoUW>@02OcT00fOiOcUW>@02Kg/077liIoUo>FLiOoUW>GliKg]o
nFLiOcUWnGliKg]WnGliKg]o>FOiOcU_NfLiOoUW>GliIoU_Ngli0Vmk00AW
>GoiIcUo>@9_N`0000AWnGliIcUo>@9_N`08OcUWnFmkOcUWnGliIoUo>@9_
N`04OcUg_E:D:DX@Ool06DYB>Lh<Hfmk001ooaBU125_N`00BU8005[F<H`i
cT8@8@Q242U:Ool007oo001oo`00009oo`8Q20085:E246LiBU8000@QF]H<
H`9oo`04000aS7ooMkd2Kg/3Mkd2Ool3Mkd00e:DOom_N`02Ool00gNmKg]g
_@02Mkd2Ool00gNmKg]g_@06Mkd00fmkMkeg_@02Mkd00gooMkeg_@03Mkd0
0fmkMke_N`02Mkd2Ool5Mkd00fmkMke_N`02Mkd016mkMkeg_Fmk0WNm00U_
NgNmMkeg_FmkMke_NgNmKg/00gNm00=_NgNmMkd00WNm00=oogNmMkd00gNm
00e_NgNmMke_NgNmKg]g_FmkMke_NgliMkeoo`03Mkd2Ool8Mkd01GooMke_
NgNmIol00gNm00Ao?fOoMkeoo`=g_@05Iomo?gNmMkeo?`03Mkd01GloMkeW
?goiOcl00WNm00UW?gNmMkeg_FOoMkeoogNmOcl00gNm00=ooe:DMkd00WNm
00=o?fOiMkd00gNm00eood8@F]I_NgNmKg]o>FLiOcUWnGliIcUon@02Kg/0
0gliIoUo>@02Kg/01GoiIcUo>FOiOcT00Vmk00ionFmkOcUW>GoiIcUo>FOi
OcU_NgoiIcUo>FOi0Wli01MWnFmkOcUWnFLiOcU_NgoiIcUo>FOiOcUWnGli
IcUonFmkIc9_NgliIoUo>Fmk009o>@0DIoUo>FOiOcUW>GoiOcUW>GoiIcUo
>FmkIoUo>FmkOcUW>GoiIcUo>@5Wn@0000Io>FLiOoUW>FOiOcT2Kg/01Gli
IoUo>FLiOcT00Vmk00Eo>FOiOcUW<S6<011oo`0I000aS000Mkd007oo5:D0
07Nm001oo`aSIcU_NaBU001W>D8@001oo`@Q36<000aS00000Woo00ABU000
8@QW>@800004BU8006Li5:D2Ool06B48001247Nm:DX007oo125_N`005:Eo
o`00Kg/Q24YBIcUoo`008@QW>C6<Ool007oo00848@03BU924000008aS00:
000icWooOomBU1BU<H`YBP00Ool236<0148@001BU0000goo00P007oo@Q00
04YB001JeP000Woo00DicP00IcUW>@00008icP07124002U:36<Q23W>0000
0Woo01AW>@00:DXQ22U:124aS000Ool<Hc6<:DYJeTYBOol007oo000Q27Nm
1Goo00Lc?gooOolG?glb5:Eoo`03Mkd08Goo8@Q:DWooMkeonFmkMkeonGoo
OoUo?goiMkeonGNmOoUo>GNmOoUg_GliMkeonGNmOoU_NgoiMkeonGNmOoUg
_@02OoT02VmkOoUonGoiOcmonGNmOcUg_Goi0WNm00MonFmkOoUg_GoiMkeo
n@03Mkd01goiMkeonFmkOcUWnGlb009_N`05OcUWnGliIoUo>@02Kg/027li
IoUo>FmkIc9onFLiOcT2Kg/08VLiOoU_NfLbOcUW>GoiIcUo>FOiOc9_NgNm
Ic9o>FOiOcUW>FOiOcUW<WoiIcUonFLiOoUW>GliIoUo>FLiOcUWnGli0Vmk
00=o>FOiOcT00fmk01Io>FOiKg]W<VmkMkeo>FLiIoUo>FmkOcU_NfOiOcUW
>GoiIcUonFLiOcUWn@5o>@0000Mo>FOiOcU_NgliIoUo>@02Kg/01gliKg]o
nFLiOcUWnGli009_N`03F]HYBWoo00moo`0>Mke247NmOol007ooDYA_Ngoo
001oo`00125oo`9BU008OomBU5:DF]Iood8@OomBU0Aoo`05BU9oogNm@Q1B
U002Ool00`00<Haoo`02Ool013W>DYAooe:D0Woo00l007ooDYA247ooIcU_
Ngoo124aS7ooBU9ooc6<00000goo00UW>D8@OomBU4YBF]Iooe:DBU800goo
00=W>DYBKg/00Woo00IBU6mkBU9ooe:DIcT3Ool01000Ool001BU0Woo00=:
DWooOol00Woo00e:DVLiOomBU7ooMkdicWooDYAg_Goo@Q1_N`02Ool02gNm
BU9247ooDYAJeWooDYAW>E[FMkd00VLi00L007oo001W>Fmk@Q1g_@04Ool0
26Oo<cmoogoo5cmo<QBUOol2Kg/08VLiOolQ248@OoUo>FLiOoUW>GliIcUo
>FOiIcUonFLiOcU_NfOiOcU_NgliIoUo>FmkOoUW>GNmKg]o>FLiOoUW>Gli
0Vmk01aonFLiKg]o>FOiOcU_NgoiIcUo>FOiOcUW>GoiIcUo>FmkOcUWnGli
Kg]o>FmkOcUW>GoiIcUo>@9_N`07Oc9WnGliIcUo>FOiOcT00Vmk00=o>FOi
OcT00Vmk00Mo>FOiOcU_NgliIcUon@04Kg/00gliIoUo>@02Kg/01WliKg]_
NgliIoUo>@A_N`9o>@9_N`09OcUWnGliIoUo>FmkOcUWnGli009_N`07OcUW
nGliKg]o>FOiOcT00Vmk00Uo>FLbOoUo>FmkIcUonFLiOcT00Vmk00Mo>FLi
OoU_NgliIoUo>@01Kg/0000?Kg]g_FLiOcUWnGliIcUonFLbKg]onFLbOcUW
nGli009_N`03OoUW<RU:01=oo`03Kg/007oo00=oo`05Mkeoogoo001JeP0E
Ool00cW>5:Eoo`07Ool00fmk001oo`06Ool00`aS>Lioo`05Ool00b48Oomo
o`0>Ool00b48Mkeoo`0:Ool00`00Oomoo`0QOol00fLi001g_@0:Ool01c<o
OomooaOoIUTDYGoo00=_N`17OolQ248@OoU_NgoiKg]o>FOiOcUWnGliKg]o
>FOiOcUW>GliIoUo>FOiOcUWnGliIcUonFLiOcUWnGliIcUonFLiKg]onFLi
OcUg_FLiOcUWnGliIcUo>FOiOc9_NgliKg]o>FOiOcUWnGliIoUo>FLiOoUJ
eWoiKg]o>FOiKg]o>FOiOcU_NgliIoUo>@02Kg/00goiIcUo>@02Kg/01gli
IoUo>FmkOcUWnGli009_N`05OcU_NgliIoUo>@02Kg/01WliIoU_NgliIoUo
>@9_N`0SOcU_NgliKg]W>FOiOcUWnGliIcUo>FmkOcUWnGliIcU_NgliIoUo
>FLiOoU_NfLiOcUWnGliIoU_NgliIoUW>GoiIcUon@02Kg/027liIoUo>GNm
Ic9g_GliIoT1OcT00007OcUW>GoiIcUo>FOiOcT00Vmk00]o>FmkKg]_Ngli
Mke_NglbKg]JeS6<09aoo`0AIolbGgooOolG?glb36=oofmkOcUW>Goo8@Q2
47NmOcUW>@02Kg/02gliIoUo>FLiOoUW>GliIoUo>FmkOcT00Vmk02Yo>FLi
IoUo>FLiOcUWnGliIoUo>FLiOoUW>FmkOcUWnGliIoU_NgliIoUo>FOiOcU_
NfLiOoUW>FmkOcUWnGliIcUo>FOiOcUW>GoiIcUo>FOiOcT4Kg/00gliIoUo
>@02Kg/01gliIcUonFLiOcU_Ngoi009W>@08OoUW>GliIoUo>FmkIo9o>@=_
N`0VOcUWnGliIcUonFLiOcUWnGliKg]WnGliIoUo>GoiIcU_NgliIoUo>FOi
OcUWnGliIcUonFmkIcUo>FOiOcUW>FOiOcU_NgliKg]o>@9_N`0?OcU_Nfmk
OcUW>GliIoUo>FLiIoUo>FmkIc9_Ngli005Wn@0000IWnGliKg]o>FOiOcT2
Kg/037liIoU_NfmkOcUWnFLbOcUWnGloIc8`[6moo`03@Q0Q27oo00ioo`03
Kg/Q27oo01Yoo`08<cmoogoo5cmW<QBUOomW>@9_N`0GOolQ248@OoU_Ngli
IoUo<VmkOcUW>GoiIcUo>FOiOcUW>GoiIcUWnGliIoUo>@02Kg/01gliIoUo
>FmkOc9WnGli009_N`04OcUWnGliIcT2OcT00fOiIcUo>@03Kg/037oiF]Io
nGliKg]o>FLiOcUWnGliIoUo>@9_N`0IMkeW>GliIoUo>FmkOcUWnFLiOcUW
nGliIcUonFLiOcUWnFmkIcUo>GoiIcUo>FOiOcT00Vmk00Uo>FLiOoUW>Goi
IcUo>FOiOcT00fmk01Mo>FOiKg]o>FOiOcU_NfLiKg]o>FOiOcU_NgliIoUW
>GliIoUo>FLiOoU_Ngli009_N`06OcUWnGliIcUonFLi0Vmk00Qo>FOiOcU_
NgliIoUo>FOi0Wli0Vmk00=o>FOiOcT00Fmk00001gliIoUo>FOiOcUW>Goi
009_N`05Oc9_NgliIoUo>@02Kg/017liIoUW<S6<2goo00UW>D8@DYAJeWoo
<Ha:DWoo@Q000Woo00X48GooOolYBWoo>Li247ooF]HDY@9oo`09001oogoo
8@Q:DWoo>Li:DT8@008icP=oo`0=@Q0aS7oo8@Q247ooMkd007ooDYAJeQBU
Mkd00Woo00Qg_CW>DY@aS4YBOom:DT8@0Woo00QW>@aSOomoobU:BU9244YB
0d8@00=oodYB>Lh00goo00M_N`@QOomBU2U:@Q1:DP02Ool01FLi8@Qoogoo
IcT00Woo00@YBVmkF]HicP9oo`03001oogoo009oo`07IcT48GooOol007oo
F]H00SW>00E:DSW>Kg/0036<009oo`0:@Q0DYGooKg]JeWNm<HaoocW>DY@=
Ool04VOo<cmoogoo5cmnDR48Oom_NfOiIcUoob48@Q1g_GliIoUo>@9_N`04
IoUo>FmkOcT3Kg/01gliIcUonGliIcUo>FOi009o>@03IoUo>FLi009_N`03
OcUWnGli009_N`09OcUWnGliIoU_NgliOoUW>Gli009_N`0<OcUWnFLiOcUW
nFmkOcUWnGliKg]o>FOi0Wli00MW>GoiIcUo>FOiOcUWn@02OcT016OiOcU_
NfOi0Wli00]WnGliKg]o>FOiKg]o>FOiOcUWnGli009_N`09OoUW>GliIcUo
nFLiOcUWnGli009_N`0BOcUW>GoiIcUo>FmkOc9WnGliKg]o>FmkIoUo>Fmk
OcUWnGli0Vmk01QW<WoiIcUo>GoiIcUo>FOiOcUW>GoiIcUonFLiOcUWnGli
IoUo>FLiOcUWnFmkOcT2Kg/1OcT1IoT1OcT00008Kg]o>FOiOcUW>GoiIcUo
>@=_N`09IoUo>FmkKg]o>FLiOoUVFBU:00]oo`0;:DX00000001ooaBU<Ha_
N`00Ool<H`02<H`02gNm000DY@aSOomg_@00>LhQ23W><H`00cW>00PDYE[F
@Q0006mkOol000@Q0Woo00`003W>DY@Q236<DY@DYE:D8@QW>@008@P3Ool0
2000@Q048FLi000Q21BUIcT3Ool03@aS124005:D001JePaS:DY:DP00:DX<
HfLi009oo`0<Mkd0048@DY@DYE:D001JeWoo@Q048D8@0Woo00L007oo5:E2
46mkF]H00002Ool07P@Q001oogooMkd005[FKg/<HcW>8@Qg_@00IcT48BU:
F]HQ26Li36=_N`aS001g_@00<H`<HfLiOol000ioo`0AMkdc?gooOolG?fLb
5:EoofLiOcUW>Goo8@Q247oiIoUo>@03Kg/05gliIoUo>FOiOcU_NgliIoUo
>FmkIcUo>FOiOcU_NfObOcUW>GoiKg]o>FOiOcT00Vmk00Eo>FOiIcUonFLi
009o>@05IcUWnGliKg]o<P02Kg/05WliIoUo>GliIoUo>FLiOoUW>GliIoUW
>GoiIcUo>FOiOcU_NgliIcUWnGli0Vmk02mo>FLiIoUo>FLiOoUW>FmkOcU_
NgliIcU_NgliIoUo>FLiOcUW>GoiIcUonFLiOcU_NfOiOcUW>GoiIcUo>Fmk
IoU_NgliIoUo>FLiIoUo>FLiOcUWnGliKg]WnGli009_N`0<OcUWnFLiOcUW
nGliIoUo>FLiOoUo>FLi0Vmk00UW>GliKg]o>FOiKg]o>FOiOcT00Vmk0Gli
0FOi00002WliIoU_NfmkOcUW>GoiIc9o>Fmk0Wli00QWnFmkOcUWnFmkOoUJ
eS6<2goo018icP00000007ooDY@YBPaS001oo`00Ool005:DOolicPaS8@P2
BU803Woo000007oo5:D007ooF]H006mk001ooaBU:DX3Ool030@QOol007oo
@Q000248Ool007oo001g_@=oo`0S36=oo`@QOol48@aS:DX48E:DOom_N`00
Oom_Nb48001oob48@Q1W>@@Q36<YBP@Q@Q1ooc6<001oo`aS<Hag_@00Mkeo
o`028@P03000Kg]24248@Q0005[F001oo`00Oom_N`8<H`04DYAooe:D0002
Ool05P00Ool007Nm001oo`aSDYA24000Ool005[F@Q0Q27Nm001oo`@Q:DYW
>@003Woo00Qg_C<oOomooaLoOc8<Hgoo0fmk00Ioob48BTao?gliIoT2OcT0
46OiOcUW>GoiIcUWnGliIoUo>FOiOcUWnFmkOcUWnGli0Vmk00Io>FLiOoUW
>GliIoT2OcT01fOiOcUo>FLiOoUW>FOi009o>@09IoU_NfmkOcU_NgoiIcUW
nGli009_N`05OcUW>GoiIcUo>@02Kg/01gliIoU_NfmkOc9WnGli009_N`0J
Oc9WnGliKg]o>FOiOcUW>GoiKg]W>GoiIcUonFLiOcU_NfOiOcU_NgoiIcUo
>FLiOoUW>@9o>@05IoUo>FLiOoUW>@02OcT2Kg/00gliIoUo>@02Kg/017oi
IcUo>Fmk0Wli00AWnGliKg]Wn@9o>@0EIoUo>FLiOcUWnGliKg]W>GoiKg]o
>FOiKg]o>FOiOcUW>GoiIcUWnGli009_N`5o>@0000IWnGliIcUo>FOiOcT3
Kg/00goiIcUWn@02OcT01VOiOcUo>FmkIc8YBP]oo`0C<H`00000001oofLi
001oo`00Oom_N`00Ool<H`00Ool0048@Ool00P000Woo00<006LiOol00P00
00Mooc6<000YBWNm000<H`02Ool02P@Q>Lioo`00>LioobU:001oodYB0P00
00]g_GooOol005[F>Lh0048@Ool48C6<00=oo`0=000YBTYB5:EBU6mk000a
S000:DYoo`00:DX00goo00HYBP00OolaS00036<3Ool0436<125oo`00@Q00
036<>Li:DVmk000YBR485:DQ20000Woo00TaS000Oomoo`00Mke_N`0036<0
0QBU00Aoo`0036=g_@8YBP045:EJeP00Ool2:DX017oo124003W>3Goo00Lc
?gooOolGofIB5:Eoo`02Kg/03FLiOolQ24VBOoUWnGliIcUWnGliIcUonFLi
009o>@05IoUo>FLiOcUWn@02OcT01fmkOcU_NfmkOcUWnGli00=_N`07OcUW
>FOiOc9_NfOiOcT00Vmk00eo>FmkKg]W>GoiOcUWnGNmIc9_NgliKg]o>@02
Kg/01goiIcU_NgliIoUo>FOi009o>@9_N`03OcUWnGli009_N`0/OcUWnGli
IoUo>FLiOoU_NfLiOoUW>GoiIcUo>FOiKg]o>FOiOcUW>GliIoUo>FLiOoU_
NfOiOcUWnGliIcUonGliIoU_NgliIoUo>FLiOoUo>FLiOoUW>@9_N`0BIoUo
<VmkKg]o>FmkIoUo>FmkOcUWnGliKg]W>GoiIcUo>FOi0Wli00YWnGliIcUo
nFLiOcU_NgliIoUo>@5_N`0001Ao>FOiOcUWnGliIoUo>FmkOcUW>GoiIcUW
nGliKg]WnGliMkeJeS6537oo00Ug_GooOomooaBU>Lioo`00Mkd00goo00=:
DS6<Ool00Woo00<YBP00Ool01goo00=g_@00F]H01Woo00<003W>Ool01Woo
00<DYC6<Ool00goo00<aS7oo0000AWoo00<48GooOol04Woo00Lc?gooOolG
?glb5:Eoo`03Kg/08Goo8@Q:C7NmOcU_NgoiIcU_NgliIcUonFLiIoUo>Fmk
OoUW>GliIoUW>GliIoUo>FmkIoUo>FOiOcU_NgliIoUo>@02Kg/017liIcUW
nGli0Vmk00Io>FOiOcUW>FmkOcT4Kg/04gliIoUo>FLiOcUWnGliIoUo>FLi
OcUWnFmkOcUWnFmkOcUWnGli009_N`07OcUW>GliIoUo>FmkOc800Vmk00Eo
>FLiOcUWnGli009_N`0AOcUWnGliKg]o>FOiOcUW>GliIcUg_GliIoUo>FLi
IoUo>@02Kg/03WlbIoUo>FLiMkeo>FLiOoUo>FLiMke_NgliIoT2OcT00fLi
IoUo>@03Kg/04WliOoUW>GliIoUo>FLiIoUo>FmkOcUW>GoiIcUo>FOiOcUW
>@5on@0000]_NgliKg]o>FLiOcU_NgNmIcUonFLi009o>@07IcU_NgliIoUo
>FLb<H`047oo00EJeWooIcU_NgNm02aoo`03Mkeoogoo05Qoo`080Il2Ggoo
OolG?fLi36=oo`9_N`07IcUoob48@Q1g_FmkOc800Vmk00=o>FOiOcT00Vmk
00ao>FLiOoUW>GliKg]W>GliIoUo>FOiKg/2OcT2Kg/00gliIoUo>@02Kg/0
:WliIoUo>FmkOcUWnGliIoUo>FLiOoUW>GliIoUo>FmkOcUWnGliIcUonFmk
OcUWnGliKg]o>FOiIcUo>FmkOcU_NgliIcUo>FOiOcUWnGliIoUo>@A_N`05
OcUWnGliIoUo>@02Kg/03gliIoUo>FLiOoUW>GliIoUo>FmkOoUW<WNmOcUW
n@02OcT00fLiIoUo>@02Kg/03GliIoUo>FLiOoU_NfLiOoUW<WliIoUo>FOi
009_N`0GOcUWnGliKg]o>FOiIcUo>FOiOcU_NfOiOcUW>GoiIcUonFLiOcUW
nGliIoUo>@01Kg/0000>Kg]WnGliIoUo>FOiOcUW>GoiIcUonFmkIcUon@9_
N`04OcUWnFII:DZKOol00gNm<cmg_@02Ool011LoOU8Q27oo0fmk00Aoob48
BTaon@=_N`0/OcUWnGliIoUo>FOiKg]o>FLiOoUW>GoiOcUWnGliIcUo>FOi
Kg]W>GliKg]WnGliIcUonFLiKg]o>FOiOcUWnGliIoUo>FLiOoUW>GoiIcUo
>FOiOcUWn@9_N`03OcUW>FOi009o>@0:IcUWnGliKg]onFLiOoUW>GliIoT2
Kg/04WliIcUo>FOiOcUWnGliKg]o>FOiKg]o>FOiOcUWnGliIoUo>@A_N`0I
OcUWnGliIoU_NgliKg]W<VmkOcUWnGliKg]o>FOiOcU_NfOiOcUWnGliIcUo
>FOiOcT00Vmk00Uo>FLiOcUW>GoiIcUo>FOiKg/00Wli00AWnFmkOcU_N`9o
>@0;IoUo>FLiMke_NgliIoUo>FLiOcUWn@01OcT0000?Kg]o>FOiOcUW>Gli
IoUo>FLiOcU_NfLiOoUW>Gli009_N`03OcUW<S2/0:1oo`0B5cmW<QBUOomo
>FmkIcUoob48@Q1g_GliKg]o>FOiOcUW>Gli0Vmk02Uo>FmkOoUW>GliIcUW
nGlbKg]o>FOiOcUW>GoiIcUonFLiOcUWnGliIcUonFLiOcUWnGliIcUo>FLi
OoUW>GliIcUonFLiOcUWnGliIcUo>FOi009o>@0GIoU_NfmkOcUWnGliIcUo
>FLiIoUo>FLiOoUo>FOiOcUWnGliIcUo>FOiOcUWn@02OcT03FmkMkeW>Gli
Kg]o>FLiIoUo>FmkOcUWnGli009_N`06Oc9_NfmkKg]onFLi0Vmk00=o>FOi
OcT00Vmk00=o>FmkIcT00Wli011WnGliKg]_NgliIcUonFLiOoUo>FLiOoUW
>GliKg]Wn@9o>@0?IoUo>FLiIoUo>FOiOcUW>GliIoUo>FmkOcUWnGli005_
N`0000]onFLiOcU_NgoiIcUo>FOiOcUWnGli009_N`03OcUWnGli009_N`03
Ic8aS7oo09moo`045cmo<QBUOol3Kg/037oo8@Q:C7ooIcUo>FOiOcUWnGli
IoUo>@9_N`05OcUW>GoiKg]o>@04Kg/0:GliIoUo>FLiOoUW>GliIoUo>FLi
OoUW>GoiIcUo>FOiOcU_NgliKg]o>FOiOcUW>GoiIcUo>FOiOcUWnGliIoU_
NgliIoUo>FmkOcUWnGliIoT00Wli00UWnGliIcU_NgliKg]o>FOiOcT00Vmk
00YW<WliIoU_NgliIcUonFLiOcUWn@9o>@06IoUo>FOiOcU_Nglb0Vmk01Uo
>FOiOcUW>GoiKg]onFLiOcUWnGliIoUo>FOiOcUWnFmkOcUWnGliKg]WnGli
IcUon@02IcT02goiIcUonFLiOcUW>FmkIoUo>FOiOcT00Vmk00Io>FOiOcUW
>GliIoT2Kg/1OcT1IoT1OcT0000:IcUo>FLiOoUW>GoiIcUo>FOiOcT2Kg/0
0gliIoUo>@02Kg/00goiF]HYBP2POol02aLoIU8DYGooIcUg_FLiOolQ24VB
OoT00Vmk069o>FOiOcU_NgliKg]WnGliIcUonFLiOcUWnFmkOcU_NgliIoUo
>FOiOcUW>GliIoUo>FOiOcU_NgliKg]o>FOiOcUWnGliIoUo>FOiOcUWnGli
Kg]o>FOiOcUW>GliKg]W>GliKg]o>FOiOcUWnGliKg]o>FmkIoUo>FmkIoUo
>FLiOoUW>FmkOcUWnGliKg]g_FLiOcUWnGliIcUonFLiOcU_NfOiOcUW>Fmk
OcUWnFmkIcUonFLiOcUW>GoiIcUo>FLb0Vmk00mo>FOiOcU_NfLiOoUW>Gli
Kg]o>FOiKg]o>FmkOcT00Vmk01QonFLiOcU_NgliIoUo>FOiOcUW>GliIoUo
<VmkMkeo>FOiOcUWnGliIcUo>FOiOcT1Kg/0000@OoUW>GoiIcUo>FmkOcUW
nGliIcUonFLiOoUW>FmkOcT2Kg/00fLb<Haoo`2OOol04QLoOc8DYGooKg]W
>GliOolQ248@OoUo>FOiOcUW>FmkOoUW>@9o>@0DIoUW>GliOoUW>GliKg]W
nGliIoUo>FLiOcUWnGliKg]o>FmkOcUWn@9_N`0:OcU_NfmkOcU_NfLiOcUW
nFmkOcT4Kg/047liIoUo>FOiOcUonFLiOcUW>GliIoUo>FmkOoUW>Gli0Vmk
0Wli01IWnGliKg]onFLiKg]o>FOiOcUW>GoiIcUo>FOiOcU_NgoiIcUo>Fmk
IcUon@9_N`09OcU_NgliKg]onFmkOcUW>Goi009_N`0OOcUWnGliIcUo>FOi
OcUW>GoiIcUonFLiOcUWnFLiOcUWnGliIc9g_GliIoUo>FmkOcUWnGliIoUo
>FmkOcT00Vmk00YW<VmkOcUWnGliIoUo>FLiOcUWn@5o>@0000=W>GliKg/0
0Vmk00Io>FOiOcUW>GoiIcT2OcT01fOiOcUWnGliOoUJeRU:0:1oo`045omV
DQBUOol2Kg/03VLiOolQ24Y<MkeWnGliIcUo>FOiIcUo>FmkIoT2OcT04VOi
IcUo>FmkIoUo>FLiOcUW>GliIoUo>FmkMkeW>GoiIcU_N`9o>@06IoU_Ngli
Kg]W>Goi0Vmk02Qo>FLiIoUo>FmkOcUWnGliKg]o>FOiIcUo>FOiOcUWnGli
Ic9g_FLiKg]onFLiOcUWnFmkOcUWnGliIcU_NgliIoUo>FOiOcU_NgliIoUo
>@9_N`0@IcUo>FOiOcUWnGliIcUo>FLiOoUW>GNmIcUo>FOiOcT2Kg/02gli
IoUo>FLiOcUWnGliIcUonFLiOcT00Vmk00Eo>FmkOcUWnGli009_N`0HOcUW
nGliIcUonFLiOcUWnGliKg]o>FOiKg]o>FmkOoUW>GliKg]o>FOiOcUWnGli
0Fmk00001WoiIcUo>FmkOcUWn@9_N`03OcUW>Goi009W>@07OcUg_GlbIoUo
>E[F<H`0Vgoo00=Wo`9O<cl00Woo00lG?glb5:EoofmkMke_Ngoo8@Q:DWli
MkeW>GoiKg/00Wli00UWnGliKg]W>GoiKg]o>FOiOcT00Vmk00eonFLiOoUW
>GliIoUo>FLiOoUW>GoiIcUWn@02OcT04FmkIoUo>GoiIcUo>FOiOcU_Ngli
IoUo>FOiOcUW>GoiIcT00Wli00=WnGliKg/00fmk00ao<VOiOcUW>GoiIcUo
>FLiIoUo>FLiOoT2Kg/06gliIcUo>FOiOcU_NgliIoUo>FOiOcU_NgliIoUo
>FOiOcUWnGliIcUonFLbOoUW>GliIoUo>@02Kg/05GliIoUo>FOiOcUWnGli
Kg]onFLiOcU_NfObOcUWnGliIoUo>FmkIoUo<P02Kg/056LiOoUW>GliIcUo
nFLiOcU_NfOiOcUW>GoiIcUonFLiOcU_NgliIoT1OcT00006IcUonFmkOcUW
nFLi0Wli00aWnGliKg]_NgoiKg]W<VmkOcUg_FLb:DXaOol00`00IcUoo`1X
Ool01fLo<cmg_Goo5cmW<QBU00Eoo`0N<H`icWoiIcUonFmkOcUW>FOiOcU_
NfLiOoUW>GliIoUo>FmkIcUonFLiOcUW>GoiKg]o>FOiOcUW>Gli0Vmk019o
>FmkIcUWnGliKg]W>GliIoUo>FmkOcUWnGliIcUo>FOiOcT2Kg/0:WliIoUW
>GliIoUo>FOiOcU_NgliIcUonFLiOcUWnGliKg]o>FOiOcUW>GliIoUo>FOi
OcUWnGliKg]o>FOiOcUW>GoiIcUo>FOiOcU_NgliIoUo>@9_N`0=OcU_Nfmk
Kg]o>FOiOcUWnGliIcUo>FOiOcT00Vmk00UW>GliIoU_NgliIoUo>FLiOcT0
0Vmk00Yo>FmkKg]_NgoiIcUo>FmkOoUW>@9_N`06IoUo>FLiOoU_Ngli0fmk
00=o>FOiOcT00Fmk000017liIcUg_FOi0Wli00iWnFmkOcUWnGliIcUo>FOi
OcU_NfOiOcUJeRU:<Goo00<006mkOol0JGoo00Hc?gooOolG?gli00025:D2
36<012U:001BU7oi0Vmk00Io<VOiOcU_NfOiOcT2Kg/01GoiIcUo>FOiOcT0
0Vmk02Qo>FOiOcUW>GNmKg]o>FOiOcUWnGliIoUo>FLiOoUW>GliIoUo>Fmk
OcUW>GoiIcUo>FOiOcU_NglbIoUo>FmkIoUo>GoiIcUo>FmkOc9Wn@9_N`0=
OcUW>GoiIcUo>FOiOcUWnGliIoUo>FmkOcT00Vmk00aW<WliIoUW>GliKg]o
>FmkIcUonFLiOcT3Kg/01GlbIoUo>FmkIoT00Wli00mWnFLiOcU_NgliIoUo
>FLiOcU_NglbIoUo>FOiOcT00Vmk00Uo>FmkOoUW>GliIoUo>FmkOcT00Vmk
00Io>FOiOcUW>GoiKg/2OcT02fOiOcU_NglbIoUo>FmkOcUWnGliIcT00Goi
00003VmkOoUW>GliKg]WnFLiOcU_NgliIoUo>FOiOcT2Kg/017liKg]W<S6<
47oo00=W>B48Ool00Woo00=_Nc6<Ool017oo00ABU36<5:EW>@=oo`0936=J
eU[F<Haoob48Kg]oobU:009oo`078@Q_Ngoo001ood8@<H`00Woo00MJeS6<
OomoogNm:DXQ2005Ool00fmk<Haoo`02Ool01C6<BU9oogooMkd00S6<0goo
00MBU0aSOomooe:D36=:DP02Ool01E:D@Q1_N`aSMkd00goo00<icPaSKg/0
0goo00=g_C6<<H`00goo00DQ27ooOolQ23W>02Qoo`09Mkdc?gooOolG?glb
:DYoofmk009g_@05Ool004YBMkeo>@02Kg/0;7liIoUo>FLiOcUWnGliIcUo
>FOiOcU_NfOiOcUWnGliIcUonFLiOcUWnGliIoUo>FLiOcUWnGliKg]o>FOi
OcUW>GoiIcUonFLiIoUo>FLiOoUW>FmkOcT2Kg/02gliMkeW<VmkOcUWnFmk
OcU_NgliIoT00Wli00MWnFLiOcUWnGlbKg]o>@03Kg/02fOiOcU_NgNmIcUo
>FOiOcUWnGliIoT00Wli00=_NfOiOcT00Vmk00eo>FmkKg]o>FLiIoUo>Fmk
OcUWnFmkOcUWn@02OcT046OiKg]o>FmkOc9W>FmkMkeW>GoiIcUo>FOiOcUJ
eWoi0Vmk00]o>FOiOcUW>GoiKg]o>FLiIoUo>FLi009_N`07MkeW>GliIoUo
>FLiIoT00Gli000027liIcUonFLiOcU_NgliIoT2Kg/02WliIcUo>FOiOcU_
NfOiOcUJeRU:47oo00=W>@00IcT00Woo0P0017oo00LicP00124Q2000IcUo
o`0200003BU:000<Hgoo001:DWoo001oofLi001BU7oo0080000:8@P003W>
OolDY@00OomJeP0036<20004Ool01DYB001oogooDY@00P0000Aooe[F0004
8@80000<Oomg_@00001oodYB000aS00036=ood8@0P0000@<H`00Oomoo`80
0007:DX0036<OomBU00012400P0000MoofLi001ooe[F001BU00XOol027Nm
<cmoogoo5cmo>@aSKg/2>Lh01dYBKg/006IBOoU_Ngli009_N`0;OcUWnGli
Kg]o>FOiOcUW>GliKg]o<P02Kg/08WliIoUo>FLiOcUWnGliIcUo>FOiOcU_
NglbIoUo>FOiOcU_NfLiOcUWnGliKg]o>FOiOcUW>GoiIcUWnGliKg]W>Gli
0fmk00Qo>FOiKg]o>FOiOcU_NfOi0Wli01EWnGliKg]WnGliMkeo<VmkOcUW
nGliIcUonFmkOcUW>GliIoUo>FLiIoT00Wli02aWnGliKg]WnGliIoUo>Fmk
OcUW>GoiIcUo>FOiKg]o>FmkIoUo>FmkIoUo>FmkOoUW>GlbIoU_NgliIoUo
>FmkIoUo>FLbOoUW>GliIoUo>FLiOcUWnGli0Vmk00QonFmkOcUW>GoiIcUo
>FOi0Wli0FOi00003VLiOoUW>GliIoUo>FOiOcUW>GliIoUo>FOiOcT2Kg/0
17liMkeW<S6<4Goo00HYBP@Q36<DY@00IcT4Ool02000F]IoogooMkd007oo
0002Ool01`00:DYoo`00F]Ioo`00009oo`0>001JeWoo001W>GooIcT007oo
BU8007oo001_N`9oo`03Mkeoogoo009oo`04F]H007ooOol2000012U:Ool0
02480Woo00@0036<Ool0009oo`08001_NgooOomJeWoo@Q00009oo`04001:
DVLi0002Ool01D8@001oo`008@P00Woo00L002U:Ool007oo000<H`0YOol0
26Oo<cmoogoo5cmW<QBUKg/3BU8047Nm001:C7NmIcUonFLiOcUWnGliIcUo
nFLiOcUWnGli0Vmk00]g_FmkOcUWnGliKg]o>FOiOcUW>Goi009_N`03Oc9_
Nfmk009_N`0<OcU_NfLiOoU_NgliIcUonFmkOcUWnGli0Vmk00Uo>FmkKg]o
nFLiOoUW>GoiIcT00Wli16mk00Ao>FmkIoUo>@9_N`0AOcU_NfLbKg]o>FOi
OcU_NgliIcUonFLiOoUW>FmkOcUWn@02OcT016OiIcUo>FOi0Wli0Vmk00=o
>FOiOcT00fmk0Wli00=WnFmkOcT00Vmk00Yo>FLiOoUW>GliKg]g_GliKg]o
>@9_N`0:OcU_NfmkKg]o>FOiOcUW>GliIoT2OcT036OiOcUW>GliIcUonFLi
OcUWnGliKg]Wn@5o>@0000]g_FmkOcUWnGliIoUo>FOiOcUWnGli00=_N`06
OcUWnFLiOcUW>BU:4Goo00=:DP00DY@00P001Goo00Ag_GooOolDY@800003
Oom_N`0000800006>Lioo`00F]Ioo`000Woo00@005:DOol000=oo`07001o
od8@001oo`0012400P0000<DYDYBOol00Woo00YJeP00OolaS0aS>Lh48Goo
001_N`9oo`04>Lh<Hgoo0002Ool0200036<000005:EoocW>5:D2Ool20000
0fmk8@Qoo`02Ool01000Ool006Li0Woo00<icPaSOol00`00:goo018c?gNm
OolG?gli36=_Nd8@>LiBU6mk001BU7oiIcUo>FOiOcT2Kg/08WliIcUonFLi
OcUWnGliMkeW<WliIoUo>FOiOcU_NgliKg]onFLiOcU_NfOiOcU_NgliIoUo
>FLiOoUW>GoiIcUo>FLi0Vmk00Qo>FOiOcUg_FmkOc9WnGli0Vmk00]o>FLi
OoUW>FOiOcU_NgliIoU_Ngli009_N`0EOcUWnGliIoUo>FmkIcUo>FOiOcUW
nGliIcUonFLiOoUW>FmkOcUWnFLi009o>@0cIoUo>FLiIoUo>FmkIoUo>FOi
Oc9W>GoiIcU_NgliIoU_NgliIo9_NgliKg]o>FOiOcUW<VOiOcUWnGliIoU_
NgliKg]o>FOiOcUWnGliIoUo>FLiIoUo>FOiOcUWnFLiOcUWnGli009_N`5o
>@5_N`5_N`0000YW>GliIoUo>FLiOcUWnGliKg]o<P=_N`07OcUWnGliKg]o
nE[F:DX04Goo00Eg_@00Oom2400000Eoo`08DY@00000000icWooIcT0009o
o`0700048Goo001JeWoo00000Woo00h005:DOol000aSOom:DP00Oom:DP00
Ool004YB0Woo00<005:DOol00Woo00YJeP@QOol007oo8@P007oo000aS09o
o`04000Q27oo0002Ool02000IcUoogNm001oodYB0002Ool01000BU9g_@00
0Woo00DDY@00Ool002U:009oo`06000YBWoo000YBP00:Woo00Ug_C<oOomo
o`<oOc8Q27ooIcT00Vmk00Uoo`00BU9_NgoiIcUo>FOiOcT00Vmk00MonFLi
IoUo>FLiOoUW<P02Kg/057liKg]o>FLiOoUJeWoiIcUo>FOiKg]o>FOiOcUW
nGliIcUonFLiOcT2Kg/026OiOcUWnGlbKg]W>GoiIc82Kg/01WliIcUWnGli
IoUo>@9_N`0=OcUWnGliIoUo>FLiOcUWnGliIoUo>FLiOcT00Vmk01UonFmk
OcUWnGliIoUo>FLiOcU_NfOiOcUWnGliKg]o>FOiKg]o>FOiOcUW>GoiIcUo
>@02Kg/01goiIcUo>FOiOcUW>Gli009_N`05OcU_NfmkIoUo>@02Kg/00gli
IoUo>@02Kg/017liIcUonFLi0Vmk019o>FLiOcU_NfOiOcUW>GliKg]o>Goi
IcUo>FOiKg]o>FmkIoT1OcT0000DOoUW>GliIoUo>FLiOcUWnGliKg]o>FOi
OcUWnGliIcUo>FmkIc8`[19oo`03001oo`0000Ioo`03001247oo00Aoo`06
12400000001:DWoo1`0000=g_Goo00000`0000IBU7oo>Lh007oo@Q030000
0`aSOomoo`02Ool01FLi124YBR48Ool00P0000=ooe:D00000P0000<48Goo
00000P0000=oogNm00000P0000=BU7ooBU8010000Woo100000<YBWooDY@0
100000AoogNm001oo`8002Uoo`08Mkdc?gooOolG?gli001JeP=BU00@F]H0
06IBMkeo>FOiKg]o<VOiOcUWnGliKg]o>FOiOcT2Kg/037liIoUW>GoiIcU_
NgliIoU_NgliKg]o>@9_N`0KOcUWnGliIoUo>FLiOoUW>GliKg]o>FOiOcU_
NgliIoUo>FmkOcUWnGliKg]o>FLiOcUWnGli009_N`0GOcUW>GliIoUo>FOi
OcUW>GliIoUo>FOiOcU_NfLbMkeWnGliIcUo>FOiOcU_N`02OcT03fOiOcU_
NgoiIcUo>FmkIoUo>FmkOcUW>GoiIcUo>@02Kg/02GliIoUo>FOiOcUWnGli
Kg]Wn@02OcT00fmkIoUo>@02Kg/03GliIcUonFLiOoUW>GliOoUW>GNmKg]o
>FOi009o>@0;IoUo>FOiOcUW>GliOoUW>GliIoUW>@02OcT1IoT0000DIcUo
>FmkOcUWnGliIoUo>FLiKg]g_GliIcUo>FOiOcU_NgoiF]HaS19oo`03:DX4
8@0000Ioo`04001BU7ooOol20002Ool023W>001oogooMkdaS5[F1242Ool0
2000Mkeoogoo125oob48:DX2Ool00c6<001oo`02Ool00`00BU9oo`04Ool0
1Fmk000006mkOol00P000goo00D48B48OomooaBU008000=oo`04001oogoo
Ool2<H`00goo001oo`03Ool00cW>001oo`04Ool02P@Q8@QoogooMkd007Nm
Ool005[F:Goo00Dc?gooOolc?goi00H00003101:DWoi009_N`09OcU_NgNm
IcUo>FLiOcUWnGli009_N`07OcUWnGliKg]o>FOiOcT00Vmk00Io>FOiOcUW
>FOiOcT2Kg/02VLiOcUW>GoiIcUo>FOiOcUWnGli0Vmk00eWnGliKg]o>FOi
OcU_NgliIoUo>FOiOcUWn@02OcT06VOiOcUWnGNmIcUo>FmkOoUW>FmkOoUW
>GliKg]g_FLiOcUW>GliIoUo>FOiOcUW>FOiOcT2Kg/056LiOcU_NfmkOcUW
nGliIoUo>FmkOcUWnFmkOcUWnGliIcUo>FObOcT2Kg/2OcT06VOiKg]o>FLi
IoUo>FLiOoUW>GliIcUonFmkIcUonFLiOcUWnGliIcUWnGliIoUo>FLiOoT2
IcT01WoiIcUo>FmkOcUWn@5o>@0000Ao>FOiKg]o>@9_N`0>Oc9_NgoiKg]W
<VmkOoUW>GliIoUo>FmkIc8YBQ=oo`03000YBWoo00Eoo`05Mkd00000000D
Y@0GOol00aBU001oo`09Ool00e[F00124002Ool20008Ool00`@QOomoo`06
Ool00aBU125oo`0@Ool00fmk001_N`0[Ool02P9O5UUoogoo0cmnDSW>OomJ
eT8@0Woo00l<HdYBOoU_NgliIoUo>FLiOoU_NgliIoUo>FOiOcT00Vmk00Mo
>FOiOcUW>GliIoUo>@02Kg/00glbIoUo>@02Kg/0=GliIoUo>FOiOcU_Ngli
IoUo>FLiOcU_NgliKg]o>FOiKg]W>GliIoUo>FLiOcUWnGliKg]o>FOiIcUo
>FmkOcUW>GoiIcUo>FLiOoUW>FmkOcUWnGliIc9onFmkOcUWnGliKg]o>FOi
OcT00Vmk00io<VOiOcUWnGliIoUo>FLiKg]o>FOiOcUW>Gli0Vmk00=o>FOi
OcT00fmk01Qo>FOiKg]W>GliIoUo>FmkOcUWnGliKg]onFLiOcUW>FOiOcU_
NgliIoUo>FmkOcT2Kg/01GliIcUonE[FOoT00Vmk00Ao>FOiOcUWn@9_N`00
00EWnGliOcUWnGli009_N`0=MkeW<VmkKg]onFLiOcU_NgliIoUo>E[F<H`0
4goo00=:DWooOol01goo00<aS6LiOol05goo00=_NdYBOol02Woo00I247oo
OomoofLiF]HAOol00fLiDYAoo`0AOol00d8@Oomoo`0YOol07FOo0UmWofOo
<UlcofIB8@Qoo`aS<H`YBWoo001:DWNmOcUWnGliIcUonFLiOcUWnGliIcUo
>FOiOc800Vmk00Mo>FOiOcUWnGliIoUo>@02Kg/0:GliIoUo>FmkIoUo<Vmk
OcUWnGliIoUo>FLiOcUWnGliIoUo>FmkOcU_NgoiIcU_NgliIoU_NgliKg]o
>FOiIcUo>FOiOcUW>GoiIcUo>FOiOcT00Vmk00=o>FOiOcT00Vmk00Yo>Fmk
Kg]o>FmkMkeW>GliIoUo>@9_N`09OcUWnGliIoUo>FLiOcUWnGli009_N`06
OoUW>FOiOcUWnGli0fmk011o>FOiOcUW>GoiIcUo>FOiOcUWnGliKg]g_FLi
OcUWn@9o>@0EIoUo>FOiOcU_NgliIoU_NgliIoUo>FmkIoUo>FmkOcUWnGli
IoUo>FLi005o>@0000Yo>FOiIcUo>FOiOcU_NgliKg]o>@9_N`08OcUWnGli
IoUo>FmkIc8YBYmoo`0<Iomooe[F<HD0048@Ool006IB:DY247oi0fmk00Mo
>FLiOoUW>GliIoUo>@03Kg/02WliIoUW>GliKg]o>FmkOcUWnGli0Vmk00Ao
<VOiOcUo>@9_N`0=OcUW>GNmKg]o>FOiOcUW>FOiOcUWnFLiKg/00Wli01AW
nGliIoUo>FmkIoUo>FmkOcUonFLiOcUWnGliIcUonFLiOcUWnGli0Vmk00mo
>FOiOcU_NfOiOcUWlVmkOcUW>GoiIcUo>FOiOcT00Vmk02ao>FLiOcUWnGli
Mkeo<VOiOcUW>GliKg]o>FOiOcUW>GoiIcUonFLiOcUWnGliIcUonFLiOcU_
NgliIcUonFLiOcUWnGliIoU_NgliIcUo>FOiOcUWnGli0Vmk00=o>FOiOcT0
0fmk00Io>FmkKg]o<VOiOcT1IoT00008IoU_NgliKg]o>FOiOcUWn@=_N`09
OcUWnGliIoUo>FLiOoUVFC6<0:5oo`04DY@aS7oo8@P2<H`03Woo36=:C7Nm
OcU_NgliIoUo>FmkOcUWnFmkOcT2Kg/03GliIoUo>FmkOcUWnGliIoUW>Fmk
OcUWnGli009_N`0FOcUWnFLiOoUW>GoiIc9o>FOiOcUWnGliKg]o>FLiOoUo
>FLiIoUo>FOiOcT2Kg/00gliIcUon@02IcT02goiIcUo>FOiOcUW>GoiIcUo
>FOiOcT00Vmk00AW>GoiIcUo>@9_N`0@OcU_NgoiIcUonFmkIcUonFLiOcUW
nGliIoUo>FmkIc83Kg/03goiIcUonFLiOcUWnGliKg]o>FLiOcU_NgliIoUo
>@02Kg/027liIoUW>GoiIcUo>FOiOcT2Kg/02WlbKg]o>FOiOcU_NfLiOcUW
nGli0Vmk00Io>FOiOcUo>FOiOcT2Kg/1OcT1IoT1OcT0000?OcU_NfOiOcUW
>GliIoUo>FmkOcUWnGliIcU_Ngli009_N`03OoUW<SW>0:5oo`05BU99S7oo
OolaS002Ool03P@QBU9onFmkOcUWnGliIoUo>FLiOcU_NfOiOcT2Kg/03Gli
IoUo>FLiOcUWnGliOoUW>FmkOc9WnGli009_N`03OcU_Ngli00A_N`0<OcU_
NglbIomo<VOiOcUW>GoiOcUW>Gli0Vmk00Io<VOiOcUg_FLbOoT2Kg/0=Gli
IoUo>FOiOcU_NgliIoUo>FOiOcUWnGliIcUonFLiOcUg_FmkIc9o>GNmIc9g
_GliIcUonFLiOcUg_FmkIcUonFmkOcU_NfLbOcUWnFmkOoUW>GliIoUo>FOi
OcUWnGliKg]o<VOiOcT00Vmk00Qo>FmkKg]o>FOiOcUW>GNm0Vmk019W>Goi
IcUo>FOiOcUW>GliIo9o>FmkIcUo>FOiIcUo>FOiOcT2Kg/1OcT1Kg/0009_
N`0AOcUWnGliIoUo>FLiOcUWnGliIcUonFLiOcUWnGliMkeW>@2S00006PaS
<H`aQDYB8@PaS000BU9g_GliIoUo>FLiOcUWnGliIoU_NgliIoU_NgliIoUo
>FLiOoT2Kg/017liIcUWnGli0Vmk00]o>FOiOcUW>GoiIcUWnGliKg]o>FOi
009_N`0;Oc9_NfmkOcUWnGliIcUonFLiIoUo>@02Kg/02WNmIc9_NgliKg]o
>FOiOc9_Ngli0Vmk00QWnGliIcUo>FOiOc9_Ngli0Vmk011onFLbKg]o>GNm
Ic9_NgliIoUo>FmkOcUWnFLbOcUWn@9o>@04IoU_NgliIoT2OcT02FLiOcU_
NgliIoUo>FLiOcUWn@02Kg/00gliIoUo>@02Kg/046OiOcUWnGliIcUonFLi
Oc9_NgoiIcUo>FOiOcUW>Goi0Vmk00Uo>FmkOoUW>FmkOoUW>GliIoT00Wli
0FOi0GNm000067liIoU_NgliIcUo>FOiOcUWnGliIcUonFLiOoUW>GliIoUo
>E[F8@QoofLiOcU_N`9g_@03Kg]JeVmk009W>@07Kg]o>FLiKg]W>FmkOcT0
0fmk00=W>FmkKg/00VLi00=_NfLiKg/00Vmk00AW>FmkKg]_N`9W>@9_N`05
IcU_NfLiKg]W>@02Kg/01E[FDYAJeU[FOol00U[F00Ag_GooF]Ig_@9W>@06
Kg]W>D8@OomJeVOo0U[F00MoofLiIcUJeU:DKg]JeP02Mkd015:DF]Ig_E[F
0WNm011BU7NmOomW>E:DOomg_E:DKg]ooe[FMkeJeWNmF]Ig_@9W>@09Kg]J
eVmkOomW>E:DF]IBU6Li009_N`04IcU_NfLiIcT2Kg/02fLiOcUW>FmkIcU_
NfLiKg]W>FmkIcT016mk00=W>FmkOcT00fmk00MW>FmkIcU_NfLiOcUW>@03
Kg/01VLiKg]o>FLiKg]W>@9_N`0?IcU_NfmkIcU_NgNmIcUBU48@>Li:DVLi
36=:DWoi009_N`0ROcUWnFmkOcU_NgliIoUo>FLiOcUWnGliIcUonFLiOcUW
nGliKg]o>FOiOcUW>GNmKg]o>FOiOcU_NgliIoUo>FmkOcT2Kg/03VOiOcUW
>GNmKg]o>FOiOcU_NgliIoUo>FmkOcT2Kg/03VOiOcUW>GNmKg]o>FOiOcU_
NgliIoUo>FmkOcT2Kg/026OiOcUW>GNmKg]o>FOiOcT3Kg/01GlbIoUo>FOi
OcT00Vmk00Ao>FOiIcUo>@9_N`0<OcUWnFmkOcUWnGliIoUo>FLiOoUW>Gli
0fmk00ao<VOiOcU_NgliKg]o>FLiOoUW>GoiIcT2Kg/057liIoUo>FLiOoUW
>GliKg]WnGliIcUonFLiOcUWnFmkOcUWnFmkOcT1IcT00005IoUo>GliIcUo
n@03Kg/047liIcUonFLiOcUW>GoiIcUo>GNmIc8icWooMke_Ne[F0TYB00EB
U7ooKg]_NgNm00=_N`0@Mke_NfmkKg]g_GliKg]g_FmkOcUg_FmkMke_NgNm
OcT2Kg/00gNmOcU_N`02Mkd02GliKg]g_FmkOcUWogliMkeW>@04Ool00aBU
Oomoo`02<H`05GooBU9g_FmkF]Ioo`00:DYoofIBMkeoobU:IcUoogNmOomW
>Goo>Li24002Ool01c6<Oom:DS6<Oom:DR48009oo`0ABHa247ooOol<Hgoo
DYAoocW>OolicWNmOomW>GooKg/Q2004Ool00goiIcUg_@02Kg/03GNmKg]g
_FmkOoUW>GNmKg]g_FmkMkeo>GNm009_N`03Mkeo>Fmk009_N`03Mke_Nfmk
00=_N`03Mkeo>GNm009_N`03Mkeo>Fmk009_N`08MkeW?goiKg]g_FmkOcUo
n@9_N`05OomW>FLiF]I24002Ool026LiOolQ24YBOoUW>GliIoT2OcT0C6Li
OoUW>GliKg]o>FOiOcUW>GoiIcUo>FOiOcUW>GoiIcUo>FmkOoUW<WliIoUo
>FLiOoUW>GliIoUo>FLiOoUW>GliKg]onFLbOcUWnGliIcUonFLiOcUWnGli
IcUonFLiOcU_NgoiIc9o>FOiOcUW>GoiIcUo>FOiOcUW>GoiIcUo>FmkOoUW
<WliIoUo>FLiOoU_Ngli0fmk00Yo>FmkKg]o>FOiOcU_NgliIoUo>@9_N`0<
OcUWnGliIcU_NgliIoUo>FmkOcUWnGli0Vmk00Uo>FOiOcUW>GoiIcUonFLi
OcT00Vmk0Wli00eWnGliIcUonFLiOcUWnFmkOcUW>GoiIcUo>@02Kg/01Gli
Kg]W>GliIcT00Goi00003GliIoU_NgliIcUonFLiOcUWnGliKg]onFLi009_
N`07OcUWnGliF]HQ26LiDY@00S6<0SW>00T007NmBU9244Y<BU9244YBBT`0
0TYB00E244YB@Q1:DT8@009:DP03BTa:DT8@009:DP05@Q1:DTYB@Q1:DP02
@Q0014YB@Q1:DT8@0TYB00E:C4YBBU8aS6Li009oo`0>Ic8icR48>Li:DP00
Ool005:D>Lh<HgNm0012408YBP0XIc8401BUOolDYFLi>Lh407oo000DYFLi
8@P007oo001W>Goo001:DP@QIcTDY@00Ool0036<:DY24000101oo`00@Q0Y
BP00DY@001BU0003Ool00dYBBHa:DP02BU8024Y<BU9244YB@Q1BU4Y<BU82
@Q02BU8014Y<BU9:DT8@0TYB00=244YBBT`00dYB0T8@0TYB00A:C4YBBU92
409:DP07@Q1:DTY<BU9244YB@Q000TYB011244YB>LiW>B48<H`icRU:8@Qg
_DV<Kg/<HdY<Oomo>@9_N`0CIoUo>FmkIc9onFLiOcUWnGliIoUo>FLiOoUW
>GliIoUo>FLiOoT00Vmk00io>FmkKg]_NfOiOcUW>GoiIcUo>FOiOcUW>Goi
0Vmk00io>FmkKg]_NfOiOcUW>GoiIcUo>FOiOcUW>Goi0Vmk00io>FmkKg]_
NfOiOcUW>GoiIcUo>FOiOcUW>Goi0Vmk00io>FmkKg]_NfOiOcUW>FOiOcU_
NgliKg]WnGli0Vmk00Mo>FOiOcU_NgliIoUo>@02Kg/037liKg]onFLiIoUo
>FLiOoUW>GliIoUo>@9_N`04Oc9WnGliIcT2Kg/01GliIoUo>FmkIoT00Wli
01=WnGliIcUonFLiOcUWnFmkOcU_NgliIoUo>FOiOcUWnGliKg]o>@01IcT0
009_N`0FOcUWnGliKg]o>FOiOcUWnGliIcUonFmkOcUWnGliMkeJeS6<MkeW
>D8@DY@2IcT00b48OomBU007F]H025:DF]IW<U[FDYAJeVLbDY@4F]H01U:D
F]IW<U:DF]IBU09JeP03Ic9JeU[F009JeP06Ic9VFE[FIc9:DVmk0goo02d0
04YB@Q0<H`00Ool085[FBU8<HgNm001ooaBU:DY_N`00<H`007oo5:D002U:
DY@YBTYBDY@<HdYBOol000@QKg/48Goo125:DU:D5:Eg_@00OolDYE:D0000
0goo00PYBVIB36=240aSOol006Li0Woo00EW>DYBF]IJeU:D00=JeP08Ic9V
FE:DF]IBU6LbF]IBU0=JeP03DYAJeU:D009JeP08Ic9VFE:DF]IBU6LbF]IB
U0=JeP03DYAJeU:D009JeP08Ic9VFE:DF]IBU6LbF]IBU09JeP0?DYAg_DV<
@Q0<Hd8@>Liood8@OolDYDYBOcU_NfOi009o>@1:IcUonFmkOcUWnFmkOcU_
NglbKg]o>FmkOcUWnFmkOcUWnGliIcUo>FOiKg]o>FmkOc9_NgliKg]o>FOi
Kg]o>FOiOcUW>GliIoU_NgliKg]o<VmkOcU_NgliIoU_NgliIoUo>FLiOcUW
nFmkOcU_NglbKg]o>FmkOcUWnFmkOcUWnGliIcUo>FOiKg]o>FmkOc9_N`9o
>@05IoUo>FOiKg]o<P02Kg/04WliIoUo>FLiOoUW>GliIoUW>GliIoUg_FLi
OcU_NgliIoUo>@9_N`03OcUWnGli009_N`07OcUWnGliIoUo>FOiOcT00Vmk
00Qo>FOiKg]o>FmkOoUW>Gli0Vmk00ao>FOiOcUWnGliKg]o>FLiOcUWnGli
IoT1OcT0000NOcU_NfmkOcUWnGliIoUo>FLiOcUWnGliIcUo>FOiOcU_Ngli
Ic8YBVLiDY@aS6IBDYA;>@aSOcUBU48@0dYB00=244YBBU800TYB00=244YB
BU8014YB00=244YBBU801DYB00A244YBBU92409:DP03@Q1:DT8@00=:DP04
>Li_NgooOol200001gooIcT00000Ool000@000800005Ool00000F]HYBP02
@Q001`00>LiJeP00Ool48Goo00800004Ool40000Ool200001Goo00000248
Ool00P0000Yoo`@Q001JeRU:BH`006LiOom:DP800009Ool00000>LioogNm
Oom:DT8@00E:DP03@Q1:DTYB00M:DP03@Q1:DTYB00=:DP03@Q1:DTYB00M:
DP03@Q1:DTYB00=:DP03@Q1:DTYB00I:DP0K@Q1:DT8@IcTDYGooBU8DYC6<
MkdicVmk36=:DWoiOcU_NfOiIcUo>FLiMke_NgliKg]WnGli009_N`0>IoUo
>FmkOcUW>FOiOcUWnGliKg]o>FmkIoUo>@9_N`0>IoUo>FmkOcUW>FOiOcUW
nGliKg]o>FmkIoUo>@9_N`0>IoUo>FmkOcUW>FOiOcUWnGliKg]o>FmkIoUo
>@9_N`0>IoUo>FmkOcUW>FOiOcUWnGliKg]o>FmkIoUo>@9_N`03IoUo>Fmk
009o>@0LIoU_NfmkOc9WnGliIcU_NgliIoUo>FmkOcUWnGliIcUonFLiOcUW
nGliKg]WlWliIcUo>FOiOcT2Kg/07WliIcUo>FOiOcUWnGliKg]W<WliKg]W
nGliKg]o>FOiOcU_NgliIcUWnGliIcUonFLiOoUW>GliIoUo>@5Wn@0000UW
nFmkOcUWnGliIcUo>FOiOcT00fmk00Qo>FOiOcUW>GoiKg]JeSW>0Woo00IJ
eSW>IcUW>D8@Ool5Kg/00gNmKg]_N`02Kg/00gNmKg]_N`04Kg/00gNmOcU_
N`05Kg/00gNmKg]_N`05Kg/01GNmKg]_NfmkIcT00goo00=o>@aSDY@037oo
00=244YBOol00Woo00A:DVmkOolDY@Aoo`03<H`icWoo00=oo`038@Qoogoo
00Moo`03>LiW>Goo00Ioo`035:Eg_Goo00=oo`04OcmW>FmkMkd2Kg/02FLi
Iomo>FOiKg]g_FLiKg]g_@04Kg/037NmKg]_NfLiIomo>FOiKg]g_FLiKg]g
_@A_N`0<Mke_NfmkIcUWogliIoU_NgNmIcU_NgNm0Vmk00AonFLiOolicP9J
eP0EIU9JeWooIcUoob48@Q1g_FOiOcUW>GoiKg]onFLiOcU_NfOiOcUWnFmk
009o>@05IoUo>FLiOoUo>@03Kg/01WliKg]WnGliIoU_N`9o>@05IoUo>FLi
OoUo>@03Kg/01WliKg]WnGliIoU_N`9o>@05IoUo>FLiOoUo>@03Kg/01Wli
Kg]WnGliIoU_N`9o>@05IoUo>FLiOoUo>@03Kg/01WliKg]WnGliIoU_N`9o
>@07IoUo>FLiIoUo>FmkOcT00Vmk00mo>FOiOcUWnGliIoUo>FOiOcUW>Goi
IcUo>FOiOcT00Vmk00=o>FLiOoT00Vmk01Io>FOiOcUWnGliIoUo>FLiOcUW
nFmkOcUWnFmkOcUW>GliIoUo>FOiOcUWn@9o>@06IcUonFLiOoUW>Gli0Vmk
0Gli0Fmk00002WliIoU_NgliIoUo>FLiOcUWnGli0fmk00ao>FOiOcUW>Goi
F]H48FLiBU9;>DV<<H`2>Lh2BU801U:DIU9BU4YBIU9:DP=BU005BU9VDU:D
DYA:DP02DY@03DYBBUU:DU:DBU9BU4YBDYA:DU:DBU9BU6IB009BU005BU9B
U4YBIU9BU002BU801SW>@Q1:FGliDY@icP=24004<I9:C36BBT`2@Q0034VB
<TaJeU:D>Li243W>F]IBU36<Kg/icP924004<I9W>FLi>Lh2@Q003SW>Kg]2
43W>@Q19TT8@>Li243W>@Q1JeU:D>Lh2@Q001cW>@Q0icT8@Kg]:DSW>00=2
4008BU9BU4YBIU9BU6IBDYAVDP9BU09:DP04IUUBU4YBIU82DY@01TYBIU9B
U6IBDYAVDP9BU09:DP04IUUBU4YBIU82DY@01TYBIU9BU6IBDYAVDP9BU09:
DP06IUUBU4YBIU9BU4YI0TYB01=BU2U:@Q1244Y<@Q1:DVmk001:C7NmOcUW
nGliIcUo>FmkOcUWn@02OcT03VLiOcU_NfOiOcU_NfLiOoUW>FmkOcU_Ngli
IoT2OcT03VLiOcU_NfOiOcU_NfLiOoUW>FmkOcU_NgliIoT2OcT03VLiOcU_
NfOiOcU_NfLiOoUW>FmkOcU_NgliIoT2OcT03VLiOcU_NfOiOcU_NfLiOoUW
>FmkOcU_NgliIoT2OcT07VLiOcU_NfOiOcU_NfLiOoUW>FmkOcUWnGliKg]W
nGliKg]o>FLiOcUWnGliKg]o>FLiOoUW>GliIoUo>@9_N`06OcUW>GoiIcU_
Ngli0fmk00Eo>FOiOcU_Ngli009_N`08OcUWnGliIoUW>GliKg]o>@9_N`04
IoUo>FOiOcT2Kg/01GliIoUo>FmkIoT00Gli0002Kg/04WliIcUo>FOiOcU_
NgliIoUo>FmkOcUWlWliKg]o>FOiOcTicP9:DP07BHa;<TYBIU9BU4Y<BU80
1D8@00A:DT8@BI9:C0E2400=BU99S4YBBTa:DTY<BI9:C4YBBI9:C48@IU80
1D8@00=:C4YB@Q000T8@00@icT8@@Q1:C0A24009BHa244Y<@Q1:C48@BI9:
C3W>0092400GBTa244VBBTa9TSW>@Q1:C48@>Li244Y<@Q19S3W>BU9:C48@
BHa244VBBT`icP02@Q001DY<@Q19TTY<>Lh00T8@00E:C48@BI9:C4VB0092
4005BTa244V<@Q1:C008@Q0014VB@Q1:DTY<148@00=:C48@@Q001D8@00A9
TT8@BU9:C0A24003BTa2448@00E24004BI9244YBBT`4@Q001DY<@Q1244YB
IU800TYB05eBU4VBBTa243W>IcUo>FOiOcU_NgliIoUo>FOiOcUW>FOiOcU_
NfOiOcUW>GliIoUo>FmkOcUWnGliIoUo>FLiIoUo>FmkIoUo>FLiOcUWnGli
Kg]o>FOiOcUWnGliIcUWnGliKg]WnGliIcUo>FOiOcU_NgliIoUo>FOiOcUW
>FOiOcU_NfOiOcUW>GliIoUo>FmkOcUWnGliIoUo>FLiIoUo>FmkIoUo>FLi
OcUWnGliKg]o>FOiOcT00Vmk01Uo>FLiOcUWnGliIoUo>FLiOoUW<WoiIcUo
>FOiOcUWnFmkOcUWnGliIcUonFLiOcUWn@02OcT016OiOcUWnGli0Vmk00Qo
nFLiOcUWnGliKg]onFLi0fmk00=o>FOiOcT00Vmk00Eo>FOiOcUWnFmk009o
>@0000ao>FOiOcUWnFmkOcUWnGliIoUo>FLiOoT3Kg/03WliIoUo>FmkOoUo
>GoiMkeo>GoiIoUo>GNmOcT2OoT01FmkOoUonGliOoT00WNm00]onFmkOoUo
nFmkOoUg_GoiKg]onGNm009on@05Kg]onGNmOoU_N`02OoT01fmkOoUg_Goi
Kg]onGNm009on@05Mkeo>GNmOoU_N`02OoT01gNmOoUg_GoiMkeonGNm009o
n@05Mkeo>GNmOoUg_@02OoT01gNmOoUg_GoiMkeonGNm009on@05Mkeo>GNm
OoUg_@02OoT01gNmOoUg_GoiMkeonGNm009on@05Mkeo>GNmOoUg_@02OoT0
1fmkOoUg_GoiMkeonGNm009on@05Kg]onGNmOoU_N`02OoT01fmkOoUg_Goi
Kg]onGNm009on@05Kg]onGNmOoU_N`02OoT01fmkOoUg_GoiKg]onGNm009o
n@05Kg]onGNmOoU_N`02OoT01fmkOoUg_GoiKg]onGNm009on@0DKg]onGNm
OoUo>GNmOoUg_GoiMkeonFLiOcUg_FLbOoUW>FmkOcUWn@9o>@0>IoUo>Fmk
IoUo>FOiOcUg_FLbOoUW>FmkOcUWn@9o>@0>IoUo>FmkIoUo>FOiOcUg_FLb
OoUW>FmkOcUWn@9o>@0>IoUo>FmkIoUo>FOiOcUg_FLbOoUW>FmkOcUWn@9o
>@0>IoUo>FmkIoUo>FOiOcUg_FLbOoUW>FmkOcUWn@9o>@0BIoUo>FmkIoUo
>FOiOcUg_FLbOoUW>FmkOcU_NfOiOcUWnGli0Vmk00=o>FmkKg/00Vmk01Eo
>FmkOcUW>GliKg]WnGliIoUo>FLiOoUW>GliIoU_NgliIcUo>FOiOcT00Vmk
01Eo>FOiOcUW>GliIcUonGliIoUo>FLiOcUg_FLbOoUW>GliKg]o>FOiKg/0
0FLi00001FOiOcU_NfmkOc800fmk02Uo>FLiOoUW<WliKg]o>FOiIcUo>FOi
OcUWnGliIcUonFmkOcUWnGliIoUo>FLiIoUo>FLiIoUo>FOiOcUW>GoiIcU_
NgliKg]o>FLiOcUg_FLb009_N`0>OcUWnGliIcUonFLiKg]o>FmkOcUW>Gli
MkeW<P9_N`0>OcUWnGliIcUonFLiKg]o>FmkOcUW>GliMkeW<P9_N`0>OcUW
nGliIcUonFLiKg]o>FmkOcUW>GliMkeW<P9_N`0>OcUWnGliIcUonFLiKg]o
>FmkOcUW>GliMkeW<P9_N`0>OcUWnGliIcUonFLiKg]o>FmkOcUW>GliMkeW
<P9_N`0>OcUWnGliIcUonFLiKg]o>FmkOcUW>GliMkeW<P9_N`0>OcUWnGli
IcUonFLiKg]o>FmkOcUW>GliMkeW<P9_N`0>OcUWnGliIcUonFLiKg]o>Fmk
OcUW>GliMkeW<P9_N`0>OcUWnGliIcUonFLiKg]o>FmkOcUW>GliMkeW<P9_
N`0>OcUWnGliIcUonFLiKg]o>FmkOcUW>GliMkeW<P9_N`0>OcUWnGliIcUo
nFLiKg]o>FmkOcUW>GliMkeW<P9_N`0>OcUWnGliIcUonFLiKg]o>FmkOcUW
>GliMkeW<P9_N`0>OcUWnGliIcUonFLiKg]o>FmkOcUW>GliMkeW<P9_N`0>
OcUWnGliIcUonFLiKg]o>FmkOcUW>GliMkeW<P9_N`0kOcUWnGliIoUo>Fmk
OcUW>FmkOcUWnFmkOcU_NgliIoUo>FOiOcUWnFmkOcU_NgliIcUonFLiOcUW
nFLiOcU_NgliIoUo>FLbMkeo>FOiOcUW>GoiIcUonFmkIoUo>FLiOoU_NfLb
Kg]o>FmkIoUo>FOiOcUW>@01OoT0000:OcUWnGliIcUg_FmkOcUWnFLiOoT2
Kg/00fLiOcUWn@02OcT00fmkOc9Wn@02Kg/037liIcUonFLiOcU_NfLiOoU_
NgliKg]o>@9_N`0>Oc9WnGliIcUonFLiIoUo>FOiOcUWnGliKg]o>@9_N`0>
Oc9WnGliIcUonFLiIoUo>FOiOcUWnGliKg]o>@9_N`0>Oc9WnGliIcUonFLi
IoUo>FOiOcUWnGliKg]o>@9_N`0>Oc9WnGliIcUonFLiIoUo>FOiOcUWnGli
Kg]o>@9_N`0>Oc9WnGliIcUonFLiIoUo>FOiOcUWnGliKg]o>@9_N`0>Oc9W
nGliIcUonFLiIoUo>FOiOcUWnGliKg]o>@9_N`0>Oc9WnGliIcUonFLiIoUo
>FOiOcUWnGliKg]o>@9_N`0>Oc9WnGliIcUonFLiIoUo>FOiOcUWnGliKg]o
>@9_N`0>Oc9WnGliIcUonFLiIoUo>FOiOcUWnGliKg]o>@9_N`0>Oc9WnGli
IcUonFLiIoUo>FOiOcUWnGliKg]o>@9_N`0>Oc9WnGliIcUonFLiIoUo>FOi
OcUWnGliKg]o>@9_N`0>Oc9WnGliIcUonFLiIoUo>FOiOcUWnGliKg]o>@9_
N`0>Oc9WnGliIcUonFLiIoUo>FOiOcUWnGliKg]o>@9_N`0>Oc9WnGliIcUo
nFLiIoUo>FOiOcUWnGliKg]o>@9_N`0>Oc9WnGliIcUonFLiIoUo>FOiOcUW
nGliKg]o>@9_N`07Oc9WnGliIcUonFLiOoT00Vmk019o<VmkIoUo>FLiOcUW
nGliKg]o<VOiKg]o>FOiOcU_NgliIoT2OcT016OiOcUWnGli0Vmk015W<WNm
OcUWnGliIcUonFLiOcUW>GliIoUo>FOiOcU_NfOi009o>@04IcUo>FLiOoT1
IcT0000:Kg]o>FLiOoUW>GliIoUo>FmkOcT2Kg/01GliIoUo>GliIoT00Vmk
00Eo>FLiOcUWnGli00A_N`08OoUW>GliKg]o>FOiKg]o>@9_N`0>OcUWnGli
Kg]o>FOiOcUW>GliKg]o>FOiKg]o>@9_N`0>OcUWnGliKg]o>FOiOcUW>Gli
Kg]o>FOiKg]o>@9_N`0>OcUWnGliKg]o>FOiOcUW>GliKg]o>FOiKg]o>@9_
N`0>OcUWnGliKg]o>FOiOcUW>GliKg]o>FOiKg]o>@9_N`0>OcUWnGliKg]o
>FOiOcUW>GliKg]o>FOiKg]o>@9_N`0>OcUWnGliKg]o>FOiOcUW>GliKg]o
>FOiKg]o>@9_N`0>OcUWnGliKg]o>FOiOcUW>GliKg]o>FOiKg]o>@9_N`0>
OcUWnGliKg]o>FOiOcUW>GliKg]o>FOiKg]o>@9_N`0>OcUWnGliKg]o>FOi
OcUW>GliKg]o>FOiKg]o>@9_N`0>OcUWnGliKg]o>FOiOcUW>GliKg]o>FOi
Kg]o>@9_N`0>OcUWnGliKg]o>FOiOcUW>GliKg]o>FOiKg]o>@9_N`0>OcUW
nGliKg]o>FOiOcUW>GliKg]o>FOiKg]o>@9_N`0>OcUWnGliKg]o>FOiOcUW
>GliKg]o>FOiKg]o>@9_N`0>OcUWnGliKg]o>FOiOcUW>GliKg]o>FOiKg]o
>@9_N`0>OcUWnGliKg]o>FOiOcUW>GliKg]o>FOiKg]o>@9_N`03OcUWnGli
009_N`04Oc9_NfmkKg/2OcT00fOiKg]o>@04Kg/09WliIoUo>FLiOoU_Ngli
Kg]WnGliIcUo>FOiKg]o>GNmIc9_NgliIoUo>FLiOcU_NgliIoUo>FLiOcU_
NgNmOcUW>FOiOcUW>GoiIcT1OcT0000AIoUo>GoiIcUo>FOiOcUW>GoiIcUo
>FmkIoUo>FmkIoUo>@03Kg/01WoiIcUo>FOiKg]o>@=_N`08OcUWnFmkIoUo
>FmkIoUo>@=_N`0=IoUo>FLiMke_NgliIoU_NfOiOcU_NfOiOcT00fmk00eW
nGliIcUg_FmkOcUWnFmkIoUo>FmkIoUo>@03Kg/03FOiOcUW>GNmKg]o>FOi
Kg]WnGliKg]WnGli00=_N`0=IoUo>FLiMke_NgliIoU_NfOiOcU_NfOiOcT0
0fmk00eWnGliIcUg_FmkOcUWnFmkIoUo>FmkIoUo>@03Kg/03FOiOcUW>GNm
Kg]o>FOiKg]WnGliKg]WnGli00=_N`0=IoUo>FLiMke_NgliIoU_NfOiOcU_
NfOiOcT00fmk00eWnGliIcUg_FmkOcUWnFmkIoUo>FmkIoUo>@03Kg/03FOi
OcUW>GNmKg]o>FOiKg]WnGliKg]WnGli00=_N`0=IoUo>FLiMke_NgliIoU_
NfOiOcU_NfOiOcT00fmk00eWnGliIcUg_FmkOcUWnFmkIoUo>FmkIoUo>@03
Kg/03FOiOcUW>GNmKg]o>FOiKg]WnGliKg]WnGli00=_N`0=IoUo>FLiMke_
NgliIoU_NfOiOcU_NfOiOcT00fmk00eWnGliIcUg_FmkOcUWnFmkIoUo>Fmk
IoUo>@03Kg/03FOiOcUW>GNmKg]o>FOiKg]WnGliKg]WnGli00=_N`0EIoUo
>FLiMke_NgliIoU_NfOiOcU_NfOiOcU_NgliIoU_NgliIoUo>FLi009_N`09
OcU_NfOiOcU_NgliKg]WnGli00=_N`0@OcUWnGliIoUo>FOiOcUWnGliIoUo
>FLbMkeo>FLiOoT2Kg/1OcT1IoT0000=OcUWnFLiOcUWnGliIcUonFLiKg]o
>FOiOcT00Vmk00Qo>FLiOcUWnGliIcUonFmk0Wli00EW>GoiIcUo>FOi009o
>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOi
OcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOiOcUW>GoiKg/0
0Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>Goi
IcUo>FOi009o>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o
>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOi
OcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOiOcUW>GoiKg/0
0Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>Goi
IcUo>FOi009o>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o
>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOi
OcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOiOcUW>GoiKg/0
0Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>Goi
IcUo>FOi009o>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o
>@07Kg]o>FOiOcUW>GoiKg/00Wli00EW>GoiIcUo>FOi009o>@07Kg]o>FOi
OcUW>GoiKg/00Wli00EW>FmkKg]o>FOi009o>@06IoUo>FOiOcU_NfOi0Wli
0Vmk00Eo>FOiOcUWnGli00=_N`03OcUWnGli009_N`07OcUWnGliKg]WlWli
IoT00Gli00001GliKg]o>FOiOcT00Vmk0?mo>FOiOcUWnGliIcUonFmkIcUo
nFLiOcUWnGliIcU_NfOiOcUonFLiOcUWnGliIoUW>GliIcUo>FOiOcUW>Fmk
IoUo>GoiIcUo>FOiOcUWnFLiOcUW>GliIoUo>FLiKg]WnGliOoUW>GliIoUo
>FOiIcUo>FLiOcUWnGliIcU_NfOiOcUonFLiOcUWnGliIoUW>GliIcUo>FOi
OcUW>FmkIoUo>GoiIcUo>FOiOcUWnFLiOcUW>GliIoUo>FLiKg]WnGliOoUW
>GliIoUo>FOiIcUo>FLiOcUWnGliIcU_NfOiOcUonFLiOcUWnGliIoUW>Gli
IcUo>FOiOcUW>FmkIoUo>GoiIcUo>FOiOcUWnFLiOcUW>GliIoUo>FLiKg]W
nGliOoUW>GliIoUo>FOiIcUo>FLiOcUWnGliIcU_NfOiOcUonFLiOcUWnGli
IoUW>GliIcUo>FOiOcUW>FmkIoUo>GoiIcUo>FOiOcUWnFLiOcUW>GliIoUo
>FLiKg]WnGliOoUW>GliIoUo>FOiIcUo>FLiOcUWnGliIcU_NfOiOcUonFLi
OcUWnGliIoUW>GliIcUo>FOiOcUW>FmkIoUo>GoiIcUo>FOiOcUWnFLiOcUW
>GliIoUo>FLiKg]WnGliOoUW>GliIoUo>FOiIcUo>FLiOcUWnGliIcT003Q_
NfOiOcUonFLiOcUWnGliIoUW>GliIcUo>FOiOcUW>FmkIoUo>GoiIcUo>FOi
OcUWnFLiOcUW>GliIoUo>FLiKg]WnGliOoUW>GliIoUo>FOiIcUo>FLiOcUW
nGliIcU_NfOiOcUonFLiOcUW>Gli0Vmk00Ao>FOiIcUo>@A_N`03OcUWnGli
009_N`5o>@5_N`0000AWnGliIoUo>@9_N`3oOcUWnGliIcUo>FOiOcU_NfLi
OoUW>GoiKg]o>FmkOcUWnGliKg]W>GliIoUo>FmkIcUonFLiOoU_NgliKg]o
>FOiOcU_NfLiOcUWnGliKg]W>GoiIcUonFmkOcU_NgliIoUo>FmkIcUo>FOi
OcU_NfLiOoUW>GoiKg]o>FmkOcUWnGliKg]W>GliIoUo>FmkIcUonFLiOoU_
NgliKg]o>FOiOcU_NfLiOcUWnGliKg]W>GoiIcUonFmkOcU_NgliIoUo>Fmk
IcUo>FOiOcU_NfLiOoUW>GoiKg]o>FmkOcUWnGliKg]W>GliIoUo>FmkIcUo
nFLiOoU_NgliKg]o>FOiOcU_NfLiOcUWnGliKg]W>GoiIcUonFmkOcU_Ngli
IoUo>FmkIcUo>FOiOcU_NfLiOoUW>GoiKg]o>FmkOcUWnGliKg]W>GliIoUo
>FmkIcUonFLiOoU_NgliKg]o>FOiOcU_NfLiOcUWnGliKg]W>GoiIcUonFmk
OcU_NgliIoUo>FmkIcUo>FOiOcU_NfLiOoUW>GoiKg]o>FmkOcUWnGliKg]W
>GliIoUo>FmkIcUonFLiOoU_NgliKg]o>FOiOcU_NfLiOcUWnGliKg]W>Goi
IcUonFmkOcU_NgliIoUo>FmkIcUo>FOiOcU_NfLiOoUW>GoiKg]o>Fmk0015
OcUWnGliKg]W>GliIoUo>FmkIcUonFLiOoU_NgliKg]o>FOiOcU_NfLiOcUW
nGliKg]W>GoiIcUonFmkOcU_NgliIoUo>FmkIcUo>FOiOcU_NfLiOoUW>Goi
Kg]o>FmkOcUWnGliKg]W>GliIoUo>FmkIoUo>FOiOcU_NgliIoUo>FmkOoUW
>Gli00=_N`5o>@5Wn@0000Io>FOiOcU_NgliIoT2OcT01FOiOcU_NgliIoT0
0Wli00M_NgliIcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT00Wli00M_Ngli
IcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT00Wli00M_NgliIcUonFLiOcUW
n@02OcT01FOiOcU_NgliIoT00Wli00M_NgliIcUonFLiOcUWn@02OcT01FOi
OcU_NgliIoT00Wli00M_NgliIcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT0
0Wli00M_NgliIcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT00Wli00M_Ngli
IcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT00Wli00M_NgliIcUonFLiOcUW
n@02OcT01FOiOcU_NgliIoT00Wli00M_NgliIcUonFLiOcUWn@02OcT01FOi
OcU_NgliIoT00Wli00M_NgliIcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT0
0Wli00M_NgliIcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT00Wli00M_Ngli
IcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT00Wli00M_NgliIcUonFLiOcUW
n@02OcT01FOiOcU_NgliIoT00Wli00M_NgliIcUonFLiOcUWn@02OcT01FOi
OcU_NgliIoT00Wli00M_NgliIcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT0
0Wli00M_NgliIcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT00Wli00M_Ngli
IcUonFLiOcUWn@02OcT01FOiOcU_NgliIoT00Wli00M_NgliIcUonFLiOcUW
n@02OcT01FOiOcU_NgliIoT00Wli00M_NgliIcUonFLiOcUWn@02OcT01FOi
OcU_NgliIoT00Wli00m_NgliIcUonFLiOcUWnGliIcUonFLiOcU_NgliIoT0
0Gli0000ofmkOcUW>GNmIcUo>FOiKg]W>GoiIcUg_FLiOcUWnFmkIcUonFLi
MkeW>GliIoU_NfLiOoUW>GNmIcUo>FOiKg]W>GoiIcUg_FLiOcUWnFmkIcUo
nFLiMkeW>GliIoU_NfLiOoUW>GNmIcUo>FOiKg]W>GoiIcUg_FLiOcUWnFmk
IcUonFLiMkeW>GliIoU_NfLiOoUW>GNmIcUo>FOiKg]W>GoiIcUg_FLiOcUW
nFmkIcUonFLiMkeW>GliIoU_NfLiOoUW>GNmIcUo>FOiKg]W>GoiIcUg_FLi
OcUWnFmkIcUonFLiMkeW>GliIoU_NfLiOoUW>GNmIcUo>FOiKg]W>GoiIcUg
_FLiOcUWnFmkIcUonFLiMkeW>GliIoU_NfLiOoUW>GNmIcUo>FOiKg]W>Goi
IcUg_FLiOcUWnFmkIcUonFLiMkeW>GliIoU_NfLiOoUW>GNmIcUo>FOiKg]W
>GoiIcUg_FLiOcUWnFmkIcUonFLiMkeW>GliIoU_NfLiOoUW>GNmIcUo>FOi
Kg]W>GoiIcUg_FLiOcUWnFmkIcUonFLiMkeW>GliIoU_NfLiOoUW>GNmIcUo
>FOiKg]W>GoiIcUg_FLiOcUWnFmkIcUonFLiMkeW>GliIoU_NfLiOoUW>GNm
IcUo>FOiKg]W>GoiIcUg_FLiOcUWn@00BFmkIcUonFLiMkeW>GliIoU_NfLi
OoUW>GNmIcUo>FOiKg]W>GoiIcUg_FLiOcUWnFmkIcUonFLiMkeW>GliIoU_
NfLiOoUW>GNmIcUo>FOiKg]W>GoiIcUg_FLiOcUWnFmkIcUonFLiMkeW>Gli
IoU_NfLiOoUW>GNmIcUo>FOiKg]W>GoiIcUg_FLiOcUWnGli00=_N`03OoUW
>Fmk005o>@000?mg_FLiOoUW>GoiIcUo>FOiOcUW>GoiIcUonFLiOcUWnGli
IcUonFLiOoUW>GliIoUo>FLiOoUW>GoiIcUo>FOiOcUW>GoiIcUonFLiOcUW
nGliIcUonFLiOoUW>GliIoUo>FLiOoUW>GoiIcUo>FOiOcUW>GoiIcUonFLi
OcUWnGliIcUonFLiOoUW>GliIoUo>FLiOoUW>GoiIcUo>FOiOcUW>GoiIcUo
nFLiOcUWnGliIcUonFLiOoUW>GliIoUo>FLiOoUW>GoiIcUo>FOiOcUW>Goi
IcUonFLiOcUWnGliIcUonFLiOoUW>GliIoUo>FLiOoUW>GoiIcUo>FOiOcUW
>GoiIcUonFLiOcUWnGliIcUonFLiOoUW>GliIoUo>FLiOoUW>GoiIcUo>FOi
OcUW>GoiIcUonFLiOcUWnGliIcUonFLiOoUW>GliIoUo>FLiOoUW>GoiIcUo
>FOiOcUW>GoiIcUonFLiOcUWnGliIcUonFLiOoUW>GliIoUo>FLiOoUW>Goi
IcUo>FOiOcUW>GoiIcUonFLiOcUWnGliIcUonFLiOoUW>GliIoUo>FLiOoUW
>GoiIcUo>FOiOcUW>GoiIcUonFLiOcUWnGliIcUonFLiOoUW>GliIoUo>FLi
OoUW>GoiIcUo>FOiOcUW>GoiIcUonFLiOcT004mWnGliIcUonFLiOoUW>Gli
IoUo>FLiOoUW>GoiIcUo>FOiOcUW>GoiIcUonFLiOcUWnGliIcUonFLiOoUW
>GliIoUo>FLiOoUW>GoiIcUo>FOiOcUW>GoiIcUonFLiOcUWnGliIcUonFLi
OoUW>GliIoUo>FLiOoUW>GoiIcUo>FOiOcUW>GoiIcUonFLiOcUWnGliIcUo
nFLiOoUW>@01Kg/0003oIcUonFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLi
OcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]o
nFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>Gli
Kg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW
>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>Fmk
OoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo
>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_Ngoi
IcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_
NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLi
OcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]o
nFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>Gli
Kg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLi001?OcU_NgoiIcUo>Fmk
OoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo
>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_Ngoi
IcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_
NgoiIcUo>FmkOoT00FLi0000ogliKg]onFLiOcU_NgoiIcUo>FmkOoUW>Gli
Kg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW
>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>Fmk
OoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo
>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_Ngoi
IcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_
NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLi
OcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]o
nFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>Gli
Kg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW
>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>Fmk
OoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]on@00CfLiOcU_Ngoi
IcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_
NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]onFLi
OcU_NgoiIcUo>FmkOoUW>GliKg]onFLiOcU_NgoiIcUo>FmkOoUW>GliKg]o
nFLiOcU_NgoiIcUo>Fmk005on@00\
\>"], "Graphics",
  FormatType->StandardForm,
  ImageSize->{335, 329},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"NotebookFormat"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks look and work the same on  Windows, Unix, and Macintosh \
computers."
}], "Caption",
  CellTags->"NotebookFormat"]
}, Closed]],

Cell[CellGroupData[{

Cell["Opening a Notebook", "Subsection",
  CellTags->"OpeningNotebooks"],

Cell[TextData[{
  "To open a notebook in ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  ", choose ",
  StyleBox[ButtonBox["Open",
    ButtonData:>"Open...",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  " in the File menu."
}], "EmphasisText",
  CellTags->"OpeningNotebooks"],

Cell[TextData[{
  "You can also open recent notebooks by using the ",
  StyleBox["File \[RightTriangle] Notebooks",
    FontFamily->"Helvetica"],
  " menu. The names of previously opened notebooks are listed under this \
menu. Click any notebook in the list to open it."
}], "Text",
  CellTags->"OpeningNotebooks"]
}, Closed]],

Cell[CellGroupData[{

Cell["Cells and Cell Groups", "Subsection",
  CellTags->"OpeningCellGroups"],

Cell[TextData[{
  "Every ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook consists of a sequence of cells, normally indicated by brackets \
at the right. You can arrange cells in groups to organize your document into \
sections and subsections."
}], "EmphasisText",
  CellTags->"OpeningCellGroups"],

Cell["\<\
A group of cells can be closed so that only the head cell is \
visible. To open a cell group, double-click the bracket of the head cell. \
Double-click again to close the group.\
\>", "Text",
  CellTags->"OpeningCellGroups"],

Cell["\<\
Here is a notebook with closed cell groups. The arrow at the bottom \
of a cell bracket indicates a closed group.\
\>", "Text",
  CellTags->"OpeningCellGroups"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000PR000`400?l00000o`00003o0P3ooooo
00000?l000002@0000010?ooo`0000<0oooo0>GUi@3UiND0o`0c<c?o03<c<`P0<c<c0@3oool00003
0?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GUi@40iNGU0`2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooohP3oool50000o`H0oooo00<0003o0?ooo`3oool01@000?l80?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onH0oooo00<0003o0?ooo`3oool00`3oool20000o`H0oooo00<0003o0?ooo`3oool01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooV0?oo
o`030000o`3oool0oooo0080oooo0`000?l60?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool01000
0?l0oooo0?ooo`3oool40000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool300000080oooo2@000000
103oool000000000000000020?ooo`<00000103oool7000000040?ooo`000000000000000080oooo
0`0000000`3oool0000000000002000000D0oooo100000030?ooo`80000000L0oooo000000000000
00000?ooo`000000oooo00<000000P3oool4000000<0oooo0`0000030?ooo`<000000`3oool70000
0080oooo0`0000020?ooo`@0000000@0oooo0000000000000000o`3ooomN0?ooo`030000o`3oool0
oooo00D0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001P3oool00`000000oooo0?ooo`03
0?ooo`8000000P3oool200000080oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2
000000<0oooo0P0000020?ooo`8000000P3oool200000080oooo00@000000?ooo`00000000001P3o
ool00`000000oooo0?ooo`02000000040?ooo`00000000000?ooo`<000000P3oool200000080oooo
0P000000103oool000000?ooo`3oool2000000030?ooo`00000000000080oooo00@000000?ooo`00
000000000P3oool010000000oooo0000000000030?ooo`8000000P3oool2000000030?ooo`000000
00000080oooo0P0000020?ooo`800000o`3ooomO0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001`3oool010000000oooo0?ooo`3o
ool2000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000020?ooo`80000000<0oooo0000000000001@3oool2000000P0oooo0`00
00000`3oool00000000000020?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`D00000103o
ool2000000D0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00
000000000080oooo0P00003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo1P0000070?ooo`H000000`3oool200000080oooo0P00
00000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P00
00000`3oool0000000000004000000030?ooo`000000000000L0oooo0`0000020?ooo`8000000P3o
ool200000080oooo0P0000030?ooo`80000000D0oooo00000000000000000?ooo`08000000D0oooo
0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo
0P00003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`X0oooo1P0000070?ooo`030000003oool0oooo00800000103oool200000080oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000080oooo
0P0000000`3oool00000000000020?ooo`80000000<0oooo0000000000001P3oool3000000<0oooo
0P0000020?ooo`8000000P3oool2000000<0oooo1@0000020?ooo`8000000P3oool400000080oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`00000000000080oooo0P00003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo1P0000080?ooo`040000003oool00000000000@0
oooo0`0000000`3oool00000000000020?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0`0000000`3oool00000000000020?ooo`040000003oool0oooo00000080oooo1@0000030?oo
o`8000000P3oool010000000oooo0000000000020?ooo`8000000P3oool3000000040?ooo`000000
00000?ooo`8000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo0080000000@0
oooo000000000000oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000080oooo
0`0000000`3oool000000000003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo1P0000080?ooo`@000000`3oool3000000030?oo
o`000000000000@0oooo0`0000020?ooo`@000000P3oool2000000030?ooo`000000000000@0oooo
0P0000020?ooo`<0000000<0oooo000000000000103oool7000000040?ooo`000000000000000080
oooo0P0000000`3oool00000000000030?ooo`@000000P3oool2000000@0oooo0`0000000`3oool0
000000000002000000040?ooo`0000000000000000<0oooo0`0000020?ooo`<0000000<0oooo0000
00000000o`3ooomP0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<H0?ooo`<00000503oool2000000<0oooo0P00000R0?ooo`8000005`3oool20000
0?l0ooooL`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c6@3oool2000001D0oooo00@000000?ooo`3oool0oooo0P00000R0?ooo`800000603oool0
10000000oooo0?ooo`3oool200000?l0ooooKP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool00`000000oooo0?ooo`0G0?ooo`<000008@3o
ool3000001`0oooo0P00003o0?ooofh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooS0?ooo`@0003o1P3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooR0?ooo`D0003o0P3oool50000o`H0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooooR0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<h80oooo1@00003o0?oooel0oooo00<0003o0?ooo`3oool00`3oool20000o`H0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cPP3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0ooooG03o
ool00`000?l0oooo0?ooo`020?ooo`<0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>30?ooo`D00000o`3o
oomN0?ooo`040000o`3oool0oooo0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`030000
003oool0000000<00000103oool2000000070?ooo`00000000000000003oool000000?ooo`030000
0080oooo100000030?ooo`<000000`3oool3000000<0oooo1`0000020?ooo`<000000P3oool40000
00040?ooo`0000000000000000<0oooo10000000103oool000000000000000020?ooo`<0000000<0
oooo0000000000001@0000020?ooo`80000000<0oooo0000000000002@0000000`3oool000000000
000600000?l0ooooG`3oool00`000?l0oooo0?ooo`050000o`H0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2P3o
ool6000000D0oooo0P0000030?ooo`8000000P3oool2000000040?ooo`000000000000000080oooo
0P0000020?ooo`80000000@0oooo0000003oool0oooo0P0000000`3oool00000000000020?ooo`04
0000003oool0000000000080oooo00@000000?ooo`00000000000`3oool200000080oooo0P000000
0`3oool00000000000020?ooo`8000000P3oool2000000D0oooo0P0000020?ooo`8000000P3oool2
00000080oooo0`0000020?ooo`8000000P3oool2000000040?ooo`000000000000000080oooo0P00
00020?ooo`8000000P3oool200000080oooo00<000000?ooo`3oool0o`3ooomP0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001@3o
ool00`000000oooo0?ooo`020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000`3o
ool200000080oooo1@0000040?ooo`8000001@3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000P3oool2000000D0oooo0P0000020?ooo`80000000<0
oooo000000000000103oool200000080oooo0P0000000`3oool00000000000030?ooo`8000000P3o
ool200000080oooo0P0000020?ooo`8000000P3oool400000?l0ooooG`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2P3oool6000000T0oooo0`00
00020?ooo`8000000P3oool200000080oooo0P0000030?ooo`80000000D0oooo0000000000000000
0?ooo`08000000D0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`00000000000080oooo0P0000050?ooo`8000000P3oool2000000030?ooo`000000000000@00000
0P3oool4000000030?ooo`000000000000<0oooo0P0000020?ooo`8000000P3oool200000080oooo
0P0000000`3oool00000000000020?ooo`800000o`3ooomN0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001`3oool4000000<0oooo
0P0000020?ooo`8000000P3oool2000000<0oooo1@0000020?ooo`8000000P3oool400000080oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`00000000000080oooo0P0000050?ooo`8000000P3oool2000000030?ooo`00000000000080oooo
100000020?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P0000020?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo0P00003o0?oooeh0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo1P0000060?ooo`@00000
103oool200000080oooo0P0000020?ooo`<0000000@0oooo000000000000oooo0P0000020?ooo`03
0000003oool000000080oooo00<000000?ooo`3oool00P000000103oool000000000003oool20000
00<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool3000000030?ooo`0000000000
00D0oooo0`0000000`3oool00000000000020?ooo`050000003oool0oooo0000003oool00P000002
0?ooo`8000000P3oool2000000040?ooo`000000000000000080oooo0P0000020?ooo`<0000000@0
oooo000000000000oooo0P0000020?ooo`800000o`3ooomN0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001@3oool3000000D0oooo
0`000000103oool000000000000000020?ooo`80000000<0oooo0000000000000`3oool400000080
oooo0P0000040?ooo`<0000000<0oooo0000000000000P000000103oool000000000000000030?oo
o`<000000P3oool3000000030?ooo`000000000000H0oooo0P0000000`3oool00000000000040?oo
o`8000000`3oool4000000@0oooo0P000000103oool000000000003oool3000000050?ooo`000000
00000000003oool00P0000030?ooo`H00000o`3ooomM0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`800000103oool00`000000oooo0?oo
o`080?ooo`8000005`3oool2000001T0oooo0P00000G0?ooo`800000o`3oooma0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`8000000`3o
ool2000000X0oooo0P00000H0?ooo`040000003oool0oooo0?ooo`800000503oool2000001L0oooo
0P0000020?ooo`800000o`3ooom]0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<F0?ooo`@0000000<0oooo0000003oool0203oool3000001`0oooo
0P00000C0?ooo`<000005P3oool300000080oooo0P00003o0?ooofd0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooS0?ooo`@0003o
1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooR0?ooo`D0003o
0P3oool50000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooj@3oool50000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo]0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cOP3oool400000?l0ooooJ`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<gd0oooo0P0000020?ooo`800000o`3ooomZ0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cPP3oool200000?l0ooooJ@3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo2@0000080?ooo`D000001@3oool3000000D0oooo
0`0000040?ooo`8000000P3oool2000000@0oooo0`0000030?ooo`8000000`3oool2000000H0oooo
0P0000030?ooo`8000000`3oool3000000@0oooo1`0000020?ooo`D0000000<0oooo000000000000
0P3oool2000000<0oooo0P0000030?ooo`D00000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c2P3oool9000000L0oooo0P0000030?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000<0oooo
0P0000000`3oool00000000000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`<000000P3oool2000000050?oo
o`00000000000000003oool00P0000020?ooo`8000000`3oool200000080oooo0P000000103oool0
000000000000003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?oo
o`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
0?l0ooooJ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo2@0000060?oo
o`8000001@3oool2000000030?ooo`000000000000H0oooo0P0000060?ooo`8000000`3oool20000
0080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?oo
o`80000000<0oooo0000000000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`800000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2P3oool90000
00d0oooo0P0000000`3oool0000000000005000000030?ooo`000000000000H0oooo0P0000030?oo
o`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool20000
00<0oooo0P0000000`3oool000000000000500000080oooo1P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`800000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2P3oool90000
00`0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000H0oooo0P0000030?oo
o`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`8000001@3oool3000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P00003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?oo
o`T00000203oool5000000<0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
0080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooJ@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo2@0000070?ooo`800000203oool20000
00030?ooo`000000000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool20000
00<0oooo0P0000000`3oool00000000000020?ooo`<000000P3oool2000000H0oooo0`0000020?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool20000
00050?ooo`00000000000000003oool00P0000020?ooo`<000000P3oool200000080oooo0P000000
103oool0000000000000003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<:0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000001@3oool4000000030?ooo`00
00000000008000000P3oool2000000@0oooo0`0000030?ooo`H000001`3oool6000000@0oooo0`00
00040?ooo`D00000103oool5000000030?ooo`00000000000080oooo1P0000040?ooo`D00000o`3o
oomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool2000000D0oooo0P00
000A0?ooo`800000703oool2000001/0oooo0P00003o0?ooogd0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<J0?ooo`8000000`3oool200000180oooo0P00000L0?ooo`8000006`3o
ool200000?l0ooooNP3oool40000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6`3oool5000001P0oooo0P00
000G0?ooo`8000006`3oool2000000030?ooo`00000000000?l0ooooNP3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj@3oool50000o`80oooo1@000?l80?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`00003m000000040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40
iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00?l0ooooo`3o
ool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{522, 130},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"OpeningCellGroups"],

Cell["Here is the same notebook with cell groups open.", "Text",
  CellTags->"OpeningCellGroups"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000l2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool000000000003o00000?l00000200000010?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
oP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0ooooi03oool50000o`80oooo1@000?l20?ooo`D0003o1`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
j03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<`l0oooo0`0000030?ooo`8000000P3oool2000000030?ooo`00000000000080oooo00<000000?oo
o`3oool01@3oool00`000000oooo000000030?ooo`<0000000<0oooo0000003oool00`0000000`3o
ool0000000000006000000030?ooo`000000000000@0oooo00<000000?ooo`0000000P000000103o
ool000000000003oool2000000D0oooo0`0000030?ooo`8000000`3oool2000000<0oooo0`000002
0?ooo`<0000000@0oooo000000000000oooo0P0000000`3oool00000000000030?ooo`<00000103o
ool2000000030?ooo`000000oooo00<000000P3oool3000000<0oooo0P0000030?ooo`8000000`3o
ool00`000000oooo00000002000000040?ooo`000000000000000080oooo0`0000001@3oool00000
0000003oool000000?l0oooo>@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<a00oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0
oooo0000003oool000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000@0oooo
00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`060000003oool0oooo0000003oool00000
0P3oool00`000000oooo000000020?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo000000020?ooo`800000103oool010000000oooo0?ooo`0000020?oo
o`060000003oool0oooo0000003oool000000`3oool00`000000oooo000000020?ooo`030000003o
ool000000080oooo00<000000?ooo`0000000P3oool00`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?ooocX0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?ooo`05
0000003oool0oooo0?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000L0oooo00D00000
0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0000000T0oooo0P0000000`3oool000000?ooo`030?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0
oooo0000003oool000000`3oool00`000000oooo0?ooo`040?ooo`8000000P3oool01P000000oooo
0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool0oooo0P0000000`3oool000000?ooo`03
0?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?ooocX0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?ooo`040000003oool0oooo
0?ooo`@000000`3oool01@000000oooo0?ooo`3oool0000000L0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0000000<00000103oool2000000<0oooo100000000`3oool000000?ooo`03
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo000000<0
oooo00<000000?ooo`3oool00P3oool2000000@0oooo00H000000?ooo`3oool000000?ooo`000003
0?ooo`040000003oool00000000000<0oooo100000000`3oool000000?ooo`030?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool0o`3ooolj0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c403oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool00000
0?ooo`0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000000`3oool01P000000
oooo0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool000000080oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`000000oooo
00000080oooo00<000000?ooo`0000000P3oool00`000000oooo000000030?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`0000000P3oool2000000@0oooo00@000000?ooo`3oool00000
0P3oool01@000000oooo0?ooo`000000oooo008000000P3oool00`000000oooo000000020?ooo`03
0000003oool000000080oooo00<000000?ooo`0000000P3oool00`000000oooo000000030?ooo`03
0000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?oo
ocX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@
0?ooo`030000003oool0oooo0080oooo0P0000020?ooo`80000000<0oooo0000000000000`000004
0?ooo`80000000@0oooo000000000000oooo200000020?ooo`<000000P3oool2000000030?ooo`00
0000oooo00800000103oool300000080oooo0`0000030?ooo`8000001P3oool300000080oooo0P00
00030?ooo`8000000`3oool300000080oooo00@000000?ooo`00000000000`3oool2000000030?oo
o`000000oooo00@0oooo0`000000103oool000000000003oool2000000030?ooo`000000oooo0080
00000`3oool300000080oooo0P0000030?ooo`80000000D0oooo00000000000000000?ooo`020000
0080oooo0`0000020?ooo`040000003oool0000000000?l0oooo?@3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a00oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0?0?ooo`050000003oool0oooo0?ooo`000000403oool01@000000oooo
0?ooo`3oool0000002/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo0?l0ooooBP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<`d0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo0?l0ooooG`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<`d0oooo1`00000K0?ooo`030000003oool0oooo0080oooo0P00
00050?ooo`030000003oool0oooo00/0oooo0P00000Z0?ooo`8000003P3oool2000001P0oooo00<0
00000?ooo`3oool0o`3ooom60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooU0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooon@0oooo1@000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03oool5
0000o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c5`3oool30000
0080oooo2@000000103oool000000000000000020?ooo`<00000103oool7000000040?ooo`000000
000000000080oooo0`0000000`3oool0000000000002000000D0oooo100000030?ooo`80000000L0
oooo00000000000000000?ooo`000000oooo00<000000P3oool4000000<0oooo0`0000030?ooo`<0
00000`3oool700000080oooo0`0000020?ooo`@0000000@0oooo0000000000000000o`3ooomN0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool6
000000H0oooo00<000000?ooo`3oool00`3oool200000080oooo0P0000020?ooo`8000000P3oool2
000000030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool200000080oooo0P000002
0?ooo`040000003oool00000000000H0oooo00<000000?ooo`3oool00P000000103oool000000000
003oool300000080oooo0P0000020?ooo`80000000@0oooo0000003oool0oooo0P0000000`3oool0
0000000000020?ooo`040000003oool0000000000080oooo00@000000?ooo`00000000000`3oool2
00000080oooo0P0000000`3oool00000000000020?ooo`8000000P3oool200000?l0ooooG`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo1P00
00070?ooo`040000003oool0oooo0?ooo`8000000`3oool200000080oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P0000000`3oool00000
000000050?ooo`800000203oool3000000030?ooo`00000000000080oooo0P0000020?ooo`800000
0`3oool200000080oooo1@0000040?ooo`8000001@3oool2000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000P3oool200000?l0ooooG`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo1P0000070?ooo`H0
00000`3oool200000080oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool200000080oooo0P0000000`3oool0000000000004000000030?ooo`000000000000L0
oooo0`0000020?ooo`8000000P3oool200000080oooo0P0000030?ooo`80000000D0oooo00000000
000000000?ooo`08000000D0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`00000000000080oooo0P00003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`H000001`3oool00`000000oooo0?ooo`02
000000@0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000
000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000030?ooo`000000
000000H0oooo0`0000030?ooo`8000000P3oool200000080oooo0P0000030?ooo`D000000P3oool2
00000080oooo100000020?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000
000000<0oooo0P0000000`3oool00000000000020?ooo`800000o`3ooomO0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool6000000P0oooo00@0
00000?ooo`0000000000103oool3000000030?ooo`00000000000080oooo0P0000000`3oool00000
000000020?ooo`8000000`3oool3000000030?ooo`00000000000080oooo00@000000?ooo`3oool0
00000P3oool5000000<0oooo0P0000020?ooo`040000003oool0000000000080oooo0P0000020?oo
o`<0000000@0oooo000000000000oooo0P0000020?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00P000000103oool000000000003oool2000000<0oooo0P0000020?ooo`80000000<0
oooo0000000000000P3oool3000000030?ooo`00000000000?l0ooooG`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo1P0000080?ooo`@00000
0`3oool3000000030?ooo`000000000000@0oooo0`0000020?ooo`@000000P3oool2000000030?oo
o`000000000000@0oooo0P0000020?ooo`<0000000<0oooo000000000000103oool7000000040?oo
o`000000000000000080oooo0P0000000`3oool00000000000030?ooo`@000000P3oool2000000@0
oooo0`0000000`3oool0000000000002000000040?ooo`0000000000000000<0oooo0`0000020?oo
o`<0000000<0oooo000000000000o`3ooomP0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c6P3oool3000001@0oooo0P0000030?ooo`8000008P3oool2
000001L0oooo0P00003o0?ooog<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<K0?ooo`8000005@3oool010000000oooo0?ooo`3oool200000280oooo
0P00000H0?ooo`040000003oool0oooo0?ooo`800000o`3ooom^0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c6`3oool00`000000oooo0?ooo`0G0?oo
o`<000008@3oool3000001`0oooo0P00003o0?ooofh0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonD0oooo10000?l60?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03oool50000o`80oooo1@000?l60?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon@0oooo1@000?l20?ooo`D0003o1P3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool300000080oooo00<000000?ooo`3oool00`00
0000103oool000000000000000020?ooo`<000000P3oool2000000H0oooo00<000000?ooo`3oool0
0P0000020?ooo`80000000<0oooo0000000000000P3oool010000000oooo0?ooo`00003o0?oooj/0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000020?ooo`06
0000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`3o0?ooojd0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`060000003o
ool0oooo0000003oool000000P3oool00`000000oooo000000030?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000060?ooo`050000003oool0
oooo0?ooo`000000o`3ooon_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c3P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?oo
o`0000000`3oool010000000oooo0?ooo`0000020?ooo`@00000103oool00`000000oooo0?ooo`04
000000<0oooo00D000000?ooo`3oool0oooo0000003o0?ooojl0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`030000003oool0000000<0oooo
00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo0080000000D0oooo0000003o
ool0oooo000000040?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?oo
o`0000020?ooo`030000003oool0oooo0?l0oooo[@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<`h0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000020?ooo`<000000P3oool01@000000oooo000000000000oooo00800000103oool30000
0080oooo0P0000020?ooo`80000000<0oooo0000000000000`00003o0?ooojh0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`8000001@3oool2
000001<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3o0?ooojd0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`8000001@3o
ool200000?l0ooood@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<`d0oooo0P0000070?ooo`800000o`3oooo@0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooU0?ooo`@0003o1P3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon@0oooo1@000?l60?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooT0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?ooo`<000000`3oool200000080oooo0P000000
0`3oool00000000000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000000`3oool3
000000030?ooo`000000oooo00<0000000<0oooo0000000000001P0000000`3oool0000000000004
0?ooo`80000000<0oooo0000003oool00P3oool3000000@0oooo0P0000000`3oool000000?ooo`03
00000080oooo0`0000030?ooo`8000000`3oool2000000<0oooo00<000000?ooo`0000000P000000
103oool000000000000000020?ooo`<0000000D0oooo000000000000oooo0000003o0?ooofH0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<0
00000?ooo`3oool01P3oool00`000000oooo000000040?ooo`030000003oool0000000<0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000020?ooo`060000003oool0
oooo0000003oool000000`3oool00`000000oooo000000020?ooo`030000003oool000000080oooo
00<000000?ooo`0000000P3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?ooofL0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?ooo`050000003oool0oooo
0?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000L0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000001P3oool2
00000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool0oooo0?ooo`80
000000<0oooo0000003oool00`3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?oo
o`000000oooo000000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0o`3o
oomW0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
403oool010000000oooo0?ooo`3oool4000000<0oooo00D000000?ooo`3oool0oooo000000070?oo
o`050000003oool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`<00000
103oool2000000@0oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool00000
000000<0oooo100000000`3oool000000?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo
000000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0o`3ooomW0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c403oool01@00
0000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`0000000`3oool01P000000oooo0?ooo`000000oooo0000
00<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000020?ooo`05
0000003oool0oooo0000003oool00P0000020?ooo`030000003oool000000080oooo00<000000?oo
o`0000000P3oool00`000000oooo000000020?ooo`030000003oool0000000<0oooo00<000000?oo
o`0000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0?l0ooooI`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a00oooo00<0
00000?ooo`3oool00P3oool200000080oooo0P0000000`3oool0000000000003000000@0oooo0P00
0000103oool000000000003oool800000080oooo0`0000020?ooo`80000000<0oooo0000003oool0
0P0000060?ooo`8000001P3oool3000000040?ooo`00000000000?ooo`80000000<0oooo0000003o
ool00P0000030?ooo`<000000P3oool2000000<0oooo0P0000001@3oool00000000000000000oooo
008000000P3oool300000080oooo00@000000?ooo`0000000000o`3ooomZ0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c403oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00l0oooo00D000000?ooo`3oool0oooo0000000S0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0o`3ooomg0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`3o0?oo
oh`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=
0?ooo`L000006`3oool00`000000oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`0J
0?ooo`800000603oool00`000000oooo0?ooo`3o0?ooog<0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonD0oooo10000?l60?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03oool50000o`H0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3ooooT0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>4
0?ooo`D00000o`3ooomO0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<cQ03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0ooooG03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<hD0oooo
1@00003o0?oooeh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<G0?ooo`030000003oool0000000<00000103oool2000000070?ooo`00000000000000
003oool000000?ooo`0300000080oooo100000030?ooo`<000000`3oool3000000<0oooo1`000002
0?ooo`<000000P3oool4000000040?ooo`0000000000000000<0oooo10000000103oool000000000
000000020?ooo`<0000000<0oooo0000000000001@0000020?ooo`80000000<0oooo000000000000
2@0000000`3oool000000000000600000?l0ooooG`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo1P0000050?ooo`8000000`3oool200000080
oooo0P000000103oool000000000000000020?ooo`8000000P3oool2000000040?ooo`000000oooo
0?ooo`80000000<0oooo0000000000000P3oool010000000oooo0000000000020?ooo`040000003o
ool00000000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool200000080oooo
0P0000050?ooo`8000000P3oool200000080oooo0P0000020?ooo`<000000P3oool200000080oooo
0P000000103oool000000000000000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`03
0000003oool0oooo0?l0ooooH03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<``0oooo1P0000050?ooo`030000003oool0oooo0080oooo0P0000020?oo
o`8000000P3oool200000080oooo0P0000030?ooo`8000000P3oool5000000@0oooo0P0000050?oo
o`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?oo
o`8000001@3oool200000080oooo0P0000000`3oool00000000000040?ooo`8000000P3oool20000
00030?ooo`000000000000<0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?oo
o`@00000o`3ooomO0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c303oool6000000T0oooo0`0000020?ooo`8000000P3oool200000080oooo0P000003
0?ooo`80000000D0oooo00000000000000000?ooo`08000000D0oooo0P0000030?ooo`80000000<0
oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000050?ooo`8000000P3o
ool2000000030?ooo`000000000000@000000P3oool4000000030?ooo`000000000000<0oooo0P00
00020?ooo`8000000P3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000o`3o
oomN0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
303oool6000000L0oooo100000030?ooo`8000000P3oool200000080oooo0P0000030?ooo`D00000
0P3oool200000080oooo100000020?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000001@3oool200000080oooo
0P0000000`3oool00000000000020?ooo`@000000P3oool2000000030?ooo`000000000000<0oooo
0P0000020?ooo`8000000P3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000
o`3ooomN0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c303oool6000000H0oooo100000040?ooo`8000000P3oool200000080oooo0`000000103oool0
00000000003oool200000080oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`020000
00040?ooo`00000000000?ooo`8000000`3oool200000080oooo0P0000000`3oool0000000000002
0?ooo`<0000000<0oooo0000000000001@3oool3000000030?ooo`00000000000080oooo00D00000
0?ooo`3oool000000?ooo`0200000080oooo0P0000020?ooo`80000000@0oooo0000000000000000
0P3oool200000080oooo0`000000103oool000000000003oool200000080oooo0P00003o0?oooeh0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?oo
o`H000001@3oool3000000D0oooo0`000000103oool000000000000000020?ooo`80000000<0oooo
0000000000000`3oool400000080oooo0P0000040?ooo`<0000000<0oooo0000000000000P000000
103oool000000000000000030?ooo`<000000P3oool3000000030?ooo`000000000000H0oooo0P00
00000`3oool00000000000040?ooo`8000000`3oool4000000@0oooo0P000000103oool000000000
003oool3000000050?ooo`00000000000000003oool00P0000030?ooo`H00000o`3ooomM0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c5`3oool20000
00@0oooo00<000000?ooo`3oool0203oool2000001L0oooo0P00000I0?ooo`8000005`3oool20000
0?l0ooooL@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<aL0oooo0P0000030?ooo`8000002P3oool2000001P0oooo00@000000?ooo`3oool0oooo0P00
000D0?ooo`8000005`3oool200000080oooo0P00003o0?ooofd0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<H0?ooo`@0000000<0oooo0000003oool0
203oool3000001`0oooo0P00000C0?ooo`<000005P3oool300000080oooo0P00003o0?ooofd0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
onD0oooo10000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03o
ool50000o`80oooo1@000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool50000o`H0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>00?ooo`@00000o`3ooom[0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<gl0oooo0P0000020?ooo`800000o`3ooomZ0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<h@0oooo0P00003o0?ooofT0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000P0oooo1@0000050?ooo`<000001@3oool3
000000@0oooo0P0000020?ooo`800000103oool3000000<0oooo0P0000030?ooo`8000001P3oool2
000000<0oooo0P0000030?ooo`<00000103oool700000080oooo1@0000000`3oool0000000000002
0?ooo`8000000`3oool2000000<0oooo1@00003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c303oool9000000L0oooo0P0000030?ooo`8000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000<0oooo0P00
00000`3oool00000000000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000000P3o
ool2000000030?ooo`00000000000080oooo0P0000020?ooo`<000000P3oool2000000050?ooo`00
000000000000003oool00P0000020?ooo`8000000`3oool200000080oooo0P000000103oool00000
00000000003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool90000
00H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`8000000P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?oo
ofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000H0oooo0P000005
0?ooo`80000000<0oooo0000000000001P3oool2000000H0oooo0P0000030?ooo`8000000P3oool2
000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P000000
0`3oool00000000000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P000000
0`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o
0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000d0oooo0P00
00000`3oool0000000000005000000030?ooo`000000000000H0oooo0P0000030?ooo`8000000P3o
ool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P00
00000`3oool000000000000500000080oooo1P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3o
oomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@00000<0?ooo`800000
0P3oool2000000<0oooo0P0000000`3oool00000000000060?ooo`8000000`3oool200000080oooo
0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000D0oooo0`0000000`3oool00000000000030?ooo`800000
00<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000
o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@0000080?ooo`D0
00000`3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool200000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000000`3oool00000000000030?ooo`800000o`3ooomY0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<``0oooo2@0000070?ooo`800000203oool2000000030?ooo`0000000000
00<0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000000`3o
ool00000000000020?ooo`<000000P3oool2000000H0oooo0`0000020?ooo`8000000P3oool20000
00030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool2000000050?ooo`0000000000
0000003oool00P0000020?ooo`<000000P3oool200000080oooo0P000000103oool0000000000000
003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000H0oooo
0P0000050?ooo`8000000`3oool3000000D0oooo100000000`3oool000000000000200000080oooo
0P0000040?ooo`<000000`3oool6000000L0oooo1P0000040?ooo`<00000103oool5000000@0oooo
1@0000000`3oool00000000000020?ooo`H00000103oool500000?l0ooooJ@3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<K0?ooo`8000001@3oool200000140oooo0P00000L0?ooo`80
00006`3oool200000?l0ooooO@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<L0?oo
o`8000000`3oool200000180oooo0P00000L0?ooo`8000006`3oool200000?l0ooooNP3oool40000
o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ad0oooo1@00000H0?ooo`8000005`3oool2000001/0oooo0P000000
0`3oool000000000003o0?ooogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooo[0?ooo`D0003o0P3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o00000?h0000000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c
<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VI
V@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`00o`3UiNGo0>GUi@X0iNGU0@0c<c<10?ooo`00
o`3UiNGo0>GUi@/0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{522, 240},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"OpeningCellGroups"]
}, Closed]],

Cell[CellGroupData[{

Cell["Animating Graphics", "Subsection",
  CellTags->"AnimatingGraphics"],

Cell[TextData[{
  "To animate a group of graphics cells, double-click any one of the \
graphics, or select the entire group and choose ",
  StyleBox[ButtonBox["Animate Selected Graphics",
    ButtonData:>"Animate Selected Graphics",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  StyleBox[" ", "SR"],
  "in the Cell menu. "
}], "EmphasisText",
  CellTags->"AnimatingGraphics"],

Cell["Click again anywhere to stop the animation.", "Text",
  CellTags->"AnimatingGraphics"],

Cell[CellGroupData[{

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@
>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@
6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0V00C@
2`06d2H01M0:00K@A@0000l00alJo`_@7OlC00_@<00;d3002m0`00_@<@0:d4/0000?00<O00?oP800
?8000on0o`3o05H0000@0014ol20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?o0P?oo05H0000@0005oh20P?l0>X001On0P83o0?l0EP000100
04Co`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20ool0EP00010000?oP8000h000on0P00dP003oh2000>000?o0000o`1D00004000A?o0
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0
P<20`83oo`1F000040000on0P005P003oh20032000?oP8001H000ol0003o05@0000@0014ol20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P?oo05H0000@0003oh2000N000?oP800;8000on0P007P003o`000?l0E000010004Co`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20ool0
EP00010000?oP8002H000on0P00XP003oh2000V000?o0000o`1D00004000A?o0P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83oo`1F0000
40000on0P00;P003oh2002B000?oP8002h000ol0003o05@0000@0014ol20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P?oo05H0000@0003
oh2000f000?oP80088000on0P00=P003o`000?l0E0000100037o`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<2000;o0170P<20`830P<20`830P<20o`3o05H0000@0003
oh2000n000?oP8006h000on0P00@P003o`000?l0E000010004Co`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20ool0EP00010000?oP800
4H000on0P00GP003oh2001:000?o0000o`1D00004000A?o0P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`83oo`1F000040000on0P00CP003
oh2001>000?oP80058000ol0003o05@0000@0014ol20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P?oo05H0000@0003oh2001F000?oP800
3h000on0P00FP003o`000?l0E000010004Co`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20ool0EP00010000?oP8005h000on0P00;P003
oh2001R000?o0000o`1D00004000A?o0P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`83oo`1F000040000on0P00IP003oh2000N000?oP800
6X000ol0003o05@0000@0014ol20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P?oo05H0000@0003oh2001^000?oP8000h000on0P00LP003
o`000?l0E000010004Co`830P<20`830P<20`830P<20`830P<20`830P<20oh30P?n0`830P<20`830
P<20`830P<20`830P<20`830P<20ool0EP00010000?oP8007H000on0o`0PP003o`000?l0E0000080
oon5ob<0000@0003oh2001f01?lOP003o`000?l0E000010001oo`830P<20`830P<20`830P<20`830
P<20`830P<2000Co0270ol20`830P<20`830P<20`830P<20`830P<20`830P?l0o`1F000040000on0
P00KP003oh2000B000?oP8006h000ol0003o05@0000@0014ol20`830P<20`830P<20`830P<20`830
P<20`83oP<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P?oo05H0000@0003oh2001V0
00?oP80028000on0P00IP003o`000?l0E000010004Co`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20ool0EP00010000?oP8005h000on0
P00<P003oh2001N000?o0000o`1D00004000A?o0P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`83oo`1F000040000on0P00EP003oh200120
00?oP8005H000ol0003o05@0000@0014ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P?oo05H0000@0003oh2001>000?oP80058000on0
P00CP003o`000?l0E000010004Co`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20ool0EP00010000?oP8004H000on0P00HP003oh200160
00?o0000o`1D00004000A?o0P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`83oo`1F000040000on0P00?P003oh2001b000?oP8003h000ol0
003o05@0000@0014ol20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P?oo05H0000@0003oh2000f000?oP80088000on0P00=P003o`000?l0
E000010004Co`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20ool0EP00010000?oP8002h000on0P00TP003oh2000^000?o0000o`1D0000
4000A?o0P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`83oo`1F000040000on0P009P003oh2002R000?oP8002H000ol0003o05@0000@0014
ol20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830
P<20`830P?oo05H0000@0003oh2000N000?oP800;8000on0P007P003o`000?l0E000010004Co`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20ool0EP00010000?oP8001H000on0P00`P003oh2000F000?o0000o`1D00004000A?o0P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`83o
o`1F000040000on0P003P003oh2003B000?oP8000h000ol0003o05@0000@0014ol20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P?oo05H0
000@0005oh20P?l0>X001On0P83o0?l0EP00010004Co`83oP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20ool0EP00010000?oP?l0?X000on0
o`3o05H0000@00;o0420`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`8300_oo05H0000@04Coo`1F0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000
o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000o`2Z0000
o`2Z0000o`2Z0000\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 3}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@2P03o`D00]0V0003
d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@00001@05o`:000?o00001@000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000k0000
8002d1l00]0300Go00K0P<20`802o`P00]0P00;@5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l0
0]0n00008P03d1X00]000`3oo`02o`Z000CoP83o2@03d1X00m0K00?@6P03d1/00m0J00?@7002d1X0
0m0L00;@6P03d400000U00;@5@03d0?o01:0`830P<20`830P<20`?o0P?l<00;@5P02d2400]0F00;@
8@03d1D00]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d003oh20012000GoP820o`0>00G@
2`06d2D01M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@01goP<20`830P<20
`830P<20`830P<20`?o0P<20o`0C00_@<00;d3002m0`00_@<@0:d4/0000?00<O7@05oaZ000?oP800
0X000ol0003o05@0000[00Co02K0P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830ool0
E@0002H01OlQP003oh2000F000?o0000o`1C00008@05o`0_P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`?l0o`1E00007@04obZ000?oP8001X000ol0003o05<0000H00Go
03W0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P?l0
o`1D00003`037`030?oo00?o<X000on0P008P003o`000?l0DP0000l00al0A?o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`83oo`1D0000
3`037`03P?oo03>000?oP8002X000ol0003o0580000A0015oh30P?n0`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83o0?l0E000018000CoP820
0_l_P003oh2000b000?o0000o`1A00004P001_o0P<20`0;o03f0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<3o0?l0D`00018000?oP8001H000on0
P00YP003oh2000f000?o0000o`1A00004P002Oo0P<20`830P002o`0j`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830ool0D`00018000?oP8002802obJ0
00?oP8003h000ol0003o0500000C0015oh30P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`83o0?l0DP0001<000?oP8002X02ob6000?oP800
4H000ol0003o0500000C000?oh30P<20`830P<20`83000;o03B0`830P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`83oo`1B00004`000on0P00>P003oh2001^000?oP800
4X000ol0003o0500000D000Aol20`830P<20`830P<20`8000_l0</20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<20`830P<3oo`1A000050000on0P00@P0;o68000on0P00DP003
o`000?l0C`0001@004Go`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`?l0o`1A000050000on0P00CP0;o4h000on0P00FP003o`000?l0
C`0001@001So`830P<20`830P<20`830P<20`830P<02o`0/P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P?oo0500000E0003oh2001J000?oP8003H000on0P00HP003o`000?l0
CP0001D001[oP<20`830P<20`830P<20`830P<20`830P0;o02W0P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20o`3o0500000E0003oh2001V00_l:P003oh2001V000?o0000o`1>0000
5@00AOn0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<20o`3o0500000F0003oh2001^00_l5P003oh2001b000?o0000o`1=00005P008?o0
P<20`830P<20`830P<20`830P<20`830P<20`8300_l08h30P?n0`830P<20`830P<20`830P<20`830
P<20`830P<3o0?l0C`0001H000?oP8007h000on0o`0OP003o`000?l0C@000080oon5ob<0000F0003
oh2001j00ol00h3oP00NP003o`000?l0C00001L0023oP<20`830P<20`830P<20`830P<20`830P<20
`830P0?o02:0`?ooP<20`830P<20`830P<20`830P<20`830P<20`83oo`1>00005`000on0P00MP003
oh2000B000?oP8006X000ol0003o04`0000G000Xoh30P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P0;o01_0P<20`830P<20`830P<20`830P<20`830P?l0o`1>00005`000on0P00LP003
oh2000R00_lHP003o`000?l0C00001P004Go`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?l0o`1=000060000on0P00JP003oh2000b0
0_lFP003o`000?l0B`0001P004Go`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`?l0o`1=000060000on0P00HP003oh2001600_lCP003
o`000?l0B`0001P004Ko`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`83oo`1<00006@000on0P00FP003oh2001F00_lAP003o`000?l0
BP0001T003?oP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<00
0_l04830P<20`830P<20`830P?oo04`0000I0003oh2001F000?oP8006X000on0P00<P003o`000?l0
BP0001T003KoP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`802o`0=`830P<20`830P<20o`3o04`0000J0003oh2001:000?oP8007h000on0P00:P003o`000?l0
B@0001X003So`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`0;o00^0`830P<20`830o`3o04/0000J0003oh20016000?oP8008h000on0P007P003o`000?l0
B@0001X003_o`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P002o`08`830P<20`?oo04/0000J0003oh20012000?oP8009h000on0P005P003o`000?l0
B00001/003goP<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83000;o00J0`830P?oo04X0000K0003oh2000f000?oP800;802o`>000?o0000o`180000
6`00AOn0`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830ol20o`3o04X0000K0003oh2000b000?oP800<803ool0BP0001`004?o`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;o
o`19000070000on0P00:P003oh2003:00ooo04T0000L000mol20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P005ool0C00001`000?oP80028000on0
P00ZP0Goo`1A00007000=?o0P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<04ool0EP0001d000?oP8001X000on0P00RP0Goo`1J00007@00:On0`830P<20oh30P<20
`830P<20`830P<20`830P<20`830P<20`83000Goo`1O00007@000on0P005P003oh2001Z01?oo06@0
000M000Poh30P<20`?o0P<20`830P<20`830P<20`830P<20`805ool0J00001h000?oP8000X000on0
P00CP0Coo`1]00007P005_o0P<20oh30P<20`830P<20`830P<05ool0L@0001h000GoP820o`0<P0Go
o`1f00007P003Oo0P?n0`830P<20`8001?oo07/0000N0004oh20o`B01Ooo07l0000O00Ooo`240000
7`02ool0R@000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000001\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0005
d0000?l00]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00000_l0183o0=0b0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
0ol2P005oh3o0=00;`02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000
;P000m00000e00006P000m00000[000;d?oo`830P<3o`?l00P000m00000[0003d00000X000?@0000
:`000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]000on0P005P004oh20o`800]0Y00;@3P03d2P00]0>00?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]003_o0P<20`830P?n0`83o1002d2H000?@00004@000m00000T0003d0000140
00?@000090000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@000080000oo@
o`0:P003oh2000:000?o00000`000m00000R0003d00001<000?@00008P000m00000C0003d0000280
00?@00004`000m00000R0003d00001<000?@00008P000m00000k00008002d1h001God=30P<20`830
P<20`?o0P<20`?l01P02d2000]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@
6@000oo@d00=P003oh2000>000?o00001P03d1X00m0K00?@6P03d1/00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d00G`830P<20`830P<20`830ol20`830P?l02P02d1H00]0Q00;@5P02d240
0m0E00;@8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0AP003oh2000F000?o00002P05d0/0
1]0U00G@2`06d2H01=0;00K@9P04d0/01]0V00G@2P06d4D0000?00<O6P0;d0;o01k0P<20`830P<20
`830P<20`830P?n0`830P<20`?l@00_@<00;d3002m0`00_@<@0:d4/0000?00<O8`02oaF000?oP800
1h000ol0003o0540000b00?o02?0P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20o`3o0580
000`00;o6X000on0P008P003o`000?l0D00002h00_l0:H30P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<3o0?l0D@0002`00_lMP003oh2000Z000?o0000o`1?0000:@03o`0^P<20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20ool0D00000l00alE00;o8H000on0
P00<P003o`000?l0CP0000l00alC00;o03?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P?l0o`1@00003`037a400_lTP003oh2000j000?o0000o`1=00008003o`0h
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`?oo04l0
000N00;o:8000on0P00@P003o`000?l0C00001`00_l0?X30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`83oo`1>00006P02obb000?oP8004H000ol0
003o04/0000G00?o04>0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<3o0?l0C@0001800al2oc2000?oP8004h000ol0003o04X0000B00<O
04WoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`83o0?l0C00001800al0183oool]P003oh2001F000?o0000o`1900005@001?n0
`803o`13P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830o`3o04/0000E0003oh2000B00olVP003oh2001N000?o0000o`1800005P002Oo0
P<20`830P002o`0o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20
`830P<20`830P<20`83o0?l0BP0001H000?oP8002803ob6000?oP8005h000ol0003o04P0000G000=
oh30P<20`830P<20`003o`0j`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830ool0B@0001L000?oP8003H03oaZ000?oP8006H000ol0003o04L0000G000C
oh30P<20`830P<20`830P<20`002o`0fP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`83oo`18000060000on0P00AP0?o58000on0P00KP003o`000?l0AP0001P0
01Oo`830P<20`830P<20`830P<20`830P003o`0aP<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`830o`3o04L0000I0003oh2001J00ol=P003oh2001f000?o0000o`150000
6@007?n0`830P<20`830P<20`830P<20`830P<20`802o`0]`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`83o0?l0AP0001X000?oP8006X03o`N000?oP8007h000ol0003o04@0
000J000Pol20`830P<20`830P<20`830P<20`830P<20`830P<03o`0X`830P?n0`830P<20`830P<20
`830P<20`830P<20`830P<20`830ool0A@0001/000?oP8007h03o`03P?n0026000?o0000o`130000
0P3oohGo8`0001`000?oP8008806ob2000?o0000o`12000070008oo0P<20`830P<20`830P<20`830
P<20`830P<20`830P<2000?o00>0`8000ol07X30P<20`830P<20`830P<20`830P<20`830P<20ool0
A00001`000?oP80088000on0P006P0?o6h000ol0003o0440000M000^oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P0;o01[0P<20`830P<20`830P<20`830P<20`830ool0
@`0001d000?oP8007X000on0P00<P0?o5h000ol0003o0400000N000bol20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<03o`0E`830P<20`830P<20`830P<20`83o0?l0
@P0001h000?oP80078000on0P00CP0?o4X000ol0003o03l0000O000goh30P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`002o`0AP<20`830P<20`830P<20`?l0
o`1100007`000on0P00KP003oh2001R00ol>P003o`000?l0?P00020003_o`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P003o`0<P<20`830P<20`83o
o`10000080000on0P00IP003oh2001n00ol8P003o`000?l0?P000240043oP<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<200_l02<20`830P<3o
o`0o00008@000on0P00GP003oh2002F00ol4P003o`000?l0?@00028004Co`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0?o00?0P?l0
o`0n00008P000on0P00EP003oh2002b00ooo03h0000R0019ol20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002ool0?@0002<0
00?oP8004h000on0P00]P0;oo`0o00008`00@on0`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000ooo0440000T0003oh2001:000?oP800
:802ool0A00002@003ko`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`0;oo`1600009@000on0P00@P003oh2002F00_oo04P0000U000hoh30P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803ool0BP0002H0
00?oP8003X000on0P00QP0;oo`1=00009P00<oo0P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`830P002ool0C`0002L000?oP80038000on0P00NP0;oo`1A00009`00;On0
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`003ool0D`0002L000?oP800
38000on0P00IP0;oo`1F0000:000:?o0P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<02ool0F00002P000?oP8002X000on0P00EP0?oo`1J0000:@008_n0`830P<20`830ol20`830P<20
`830P<20`830P<20`802ool0G@0002T000?oP80028000on0P00BP0;oo`1O0000:P007Oo0P<20`830
P<3o`830P<20`830P<20`830P<2000;oo`1Q0000:P000on0P006P003oh2000j00ooo06<0000[000G
oh30P<20`83oP<20`830P<20`830P<000_oo06H0000[0003oh2000B000?oP8002h02ool0J00002`0
01;o`830P<3o`830P<20`830P<02ool0JP0002`000?oP8000h000on0P006P0?oo`1/0000;0003Oo0
P<20oh30P<20`8000_oo06l0000]0005oh20P?l01H02ool0L@0002d000SoP<3o`830P0;oo`1c0000
;P001?n0oh03ool0M@0002h000Co`?ooo`1h0000;`000ol0003o07P0003o0:X0003o0:X0003o0:X0
003o0:X0003o0:X0003o0:X00000\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=20om0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0c0004
om20P0;o0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d00002l000[od830P?n0o`3@<P000m0000050003d000030000?@00001@000m00
000`0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0>0
00OoP820o`3@02l00]090003d00002d00]090003d00002d00]090003d00002d00]090003d00002h0
00?@0000=@0001X000?@0000:P003?o@`830P<3o`830o`8000?@0000:`000m00000:0003d00002/0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@1X000on0P002P003o`0000;@:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@
>@0001d00]0U00;@00n0`830P<20`?o0P<20`?l00`02d2H000?@00004@000m00000T0003d0000140
00?@000090000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m20
P008P003oh2000B000?o00000P000m00000R0003d00001<000?@00008P000m00000C0003d0000280
00?@00004`000m00000R0003d00001<000?@00008P000m00000k00008002d1l00]004l20`830P<20
`83oP<20`830P?l01@02d2000]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@
6P02d0b000?oP8001X000ol0000400?@6P03d1/00m0J00?@6`03d1X00m0L00;@6P03d1`00]0J00?@
@00002D00]0E00?@01WoP<20`830P<20`830P?n0`830P<20`83o00P00]0F00;@8@02d1H00]0Q00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@00<0ool03X000on0P007P003o`0000P0
1M0;00K@9@05d0/01]0V00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m05000Mol20`830
P<20`830P<20`83oP<20`830P<20`?l03P0;d3002m0`00_@<00;d3402]1;00003`037bP00_lAP003
oh2000V000?o0000o`1>0000>@008_n0`830P<20`830P<20`830P<3o`830P<20`830P<20`?oo04l0
000h0003oh20016000?oP8002h000ol0003o04d0000f00;o02B0`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P?oo04h0000e0003oh2001B000?oP8003H000ol0003o04/0000c00;o02W0P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20o`3o04`0000?00<O80000on0P00GP003
oh2000j000?o0000o`1:00003`037ah00_l0;H30P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830o`3o04/0000?00<O7@000on0P00IP003oh20016000?o0000o`180000;P00<oo0
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830o`3o04T0000/00;o
7H000on0P00BP003o`000?l0A`0002/003OoP<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`83o0?l0B00002T00_lOP003oh2001F000?o0000o`150000:000??o0
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20ool0
AP0001800alA00;o8X000on0P00FP003o`000?l0A00001800al@0010oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830ool0A@0001800al?0003
oh2002>000?oP80068000ol0003o0480000R00;o04:0`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P?oo04@0000Q0003oh2002F000?oP800
6X000ol0003o0440000O00;o04O0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P<20`830P<20o`3o0480000N0003oh2002R000?oP80078000ol0
003o03l0000M001<oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`830ool0@@0001/00_l/P003oh2001f000?o0000o`0n0000
5`037`1Aol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<3o0?l0?`0001L00al3ob^000?oP80088000ol0003o03`0
000G00<O00>0`8001ol0B830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20ool0?P0001X000?oP8001h06oaj000?oP8008H000ol0
003o03/0000K000?oh30P<20`830P<20`83000Oo03g0P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0?00001`000?oP8004X07oa2000?oP800
8h000ol0003o03T0000L000Lol20`830P<20`830P<20`830P<20`830P<20`0Ko0360`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0?l0>`0001d000?oP8007X07o`:0
00?oP8009H000ol0003o03P000020?ooQOlS00007P000on0P00UP0?o0X06oan000?o0000o`0g0000
7`009on0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003o`08`830P<20`806o`0K
`830P<20`830P<20`830P<20`830P<20`83o0?l0>000020000?oP80098000on0P00=P0Ko5H000ol0
003o03D0000Q000loh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<201Ol04X30P<20`830P<20`830P<20ool0=P00024000?oP8008X000on0P00IP0Ko
2h000ol0003o03@0000R0016ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`0Ko00N0`830P<3o0?l0=@0002<000?oP80088000on0
P00UP0Ko00>0o`00o`0c00008`00DOn0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003ool0<`0002@000?oP800
7h000on0P00[P003o`000?l0<`0002D004goP<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`002ool0=P0002H000?oP800
78000on0P00YP003o`000?l0=P0002H004Wo`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;oo`0i00009`000on0P00KP003
oh2002J000?o0000o`0i0000:000A_o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P?oo03`0000X0003oh2001V000?oP8009802ool0
?@0002T004;oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`?oo03l0000Z0003oh2001N000?oP8008H02ool0@00002/003goP<20`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0@P0002/0
00?oP8005X000on0P00NP0;oo`130000;000>Oo0P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830o`3o04D0000]0003oh2001>000?oP8007802ool0AP0002d0
03GoP<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20o`3o04P0
000^0003oh2001:000?oP8006X000ol0003o04L0000_000_oh30P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<000_oo04X0000`0003oh20012000?oP8005h000ol0003o04X0
000`000[ol20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P002ool0C@000340
00?oP8003X000on0P00EP003o`000?l0C@00038002Ko`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`0;oo`1@0000<P000on0P00=P003oh2001:000?o0000o`1@0000<`008_n0`830P<20
`830P<20`?o0P<20`830P<20`830P<20`802ool0D`0003@000?oP8002h000on0P00?P003o`000?l0
D`0003D001ooP<20`830P<20`830ol20`830P<20`830P<20`83o0?l0EP0003D000?oP8002H000on0
P00=P0;oo`1G0000=P006oo0P<20`830P<20oh30P<20`830P<20`830o`3o05T0000g0003oh2000N0
00?oP8002X02ool0FP0003L001OoP<20`830P<20oh30P<20`830P<20o`3o05`0000h0003oh2000J0
00?oP8001h02ool0G@0003T001;oP<20`830ol20`830P<20`?oo05l0000j0003oh2000>000?oP800
1H02ool0H00003X000ko`830P<3o`830P<20ool0HP0003/000?oP8000X000on0P003P003o`000?l0
H@0003`000So`830ol20`0;oo`1T0000?0001On0P83o00:000?o0000o`1T0000?@001?n0oh02ool0
I`0003h00ooo06T0000o0003o`000?l0J0000?l0ZP000?l0ZP000?l0ZP000001\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d003o`0003H00]0i00;@>@02d3T00]0i00;@<P0001D0
00?@0000=@001M20om3o03H000C@003@=`001=000=0g0004d000d3L000C@003@=`000m00000b0000
5P02d3@000G@P83oP002d3@000?@00000P02d3@000?@00000P02d3@000?@00000P02d3@000?@0000
0P02d3@000?@0000<`0001P000?@0000<0002M20`83oP<20d00b0003d00000D000?@0000<0000m00
00050003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00
000]00;@18000on0P002P003d00002d00]090003d00002d00]090003d00002d00]090003d00002d0
0]090003d00002h000?@0000=@0001X000?@0000:`003]3oP<20`83oP<20`83@;@000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@00?oP80018000on0P004P0;@:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h0
0m0Y00;@>@0001d00]0U00;@0180oh30P<20`83oP<20`830P?l2d2H000?@00004@000m00000T0003
d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@0000
8@001=000?l8P003oh2000J000?o0=0090000m00000C0003d000028000?@00004`000m00000R0003
d00001<000?@00008P000m00000C0003d000028000?@0000>`0002000]0O00;@0P005_n0`830P<20
`83oP<20`830P<20o`02d2000]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@
6P02d0<000?oP80028000on0P008P003o`0000?@6P03d1/00m0J00?@6`03d1X00m0L00;@6P03d1`0
0]0J00?@@00002D00]0E00?@10006On0`830P<20`830P?n0`830P<20`830P?l01002d1H00]0Q00;@
5P02d2400m0E00;@8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M060003oh2000Z000?oP800
2X000ol0000300G@2`06d2D01M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@
2P007On0`830P<20`830P<20oh30P<20`830P<20`83o00T02m0`00_@<00;d3002m0a00[@B`0000l0
0al^0003oh2000b000?oP80038000ol0003o04T0000n00;o0220`830P<20`830P<20`83oP<20`830
P<20`830P<20ool0BP0003d000?oP8003h000on0P00>P003o`000?l0A`0003`002Ko`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20ool0B00003/000?oP8004H000on0P00@P003o`000?l0
A@0003X002[o`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P?oo04H0000?00<O
9`000on0P00CP003oh2001:000?o0000o`1300003`037bH002ko`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`83oo`1400003`037bD000?oP8005H000on0P00DP0;oo`120000
=P00<oo0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830o`3o0440
000e0003oh2001N000?oP8005h000ol0003o03h0000d000gol20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830o`3o03l0000c0003oh2001V000?oP8006H000ol0
003o03`0000b000kol20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`?l0o`0m00004P037a`000?oP8006h000on0P00KP003o`000?l0>P0001800alK000o
ol20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830
P<3o0?l0>`0001800alI00;o7h000on0P00MP003o`000?l0>00002d004CoP<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830ool0>@0002`0
00?oP80088000on0P00OP003o`000?l0=P0002/004SoP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`?oo03L0000Z0003oh2002:0
00?oP8008H000ol0003o03@0000Y001<oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ool0=@0002P000?oP80098000on0
P00SP003o`000?l0<P0001L00al=001@oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?oo03<0000G00<O30000on0
P00VP003oh2002F000?o0000o`0`00005`037`/005CoP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?oo0340
000T0003oh2002R000?oP8009h000ol0003o02h0000S001Hoh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830ool0;`00028000?oP800:X000on0P00YP003o`000?l0;000024005coP<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830ool0;@00020000?oP800;8000on0P00[P003o`000?l0:P0000807?l37ooo
I_lS00007P037`03oh2002Z00ol[P003o`000?l0:`0001h00al0;@3o`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`003o`0[`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20o`3o02h0000S0003oh2002V000?oP800:8000ol0003o02d0000T001Fol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?oo0300000U0003oh2002N000?oP8009X000ol0003o02l0000V001B
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20ool0<P0002L000?oP8009H000on0P00TP003o`000?l0<@0002P0
04ko`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?oo03@0000Y0003oh2002>000?oP8008X000ol0003o03<0000Z001:
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P?oo03H0000[0003oh20026000?oP80088000ol0003o03D0000/0016ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20ool0>00002d000?oP8007h000on0P00NP003o`000?l0=`0002h004;o`830P<20`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P?oo03X0000_0003
oh2001f000?oP80078000ol0003o03T0000`000nol20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P?oo03`0000a0003oh2001^000?oP8006X000ol0
003o03/0000b000jol20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20ool0?P0003<000?oP8006H000on0P00HP003o`000?l0?@0003@003Ko`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P?oo0400000e0003oh2001N0
00?oP8005X000ol0003o03l0000f000bol20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P?oo0480000g00;o5X000on0P00DP003o`000?l0@@0003T002goP<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0o`140000>P000on0P00BP003oh2001:0
00?o0000o`130000>`00:On0`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`83o0?l0
AP0003`000?oP80048000on0P00@P003o`000?l0A@0003d002GoP<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`83o0?l0B00003h000?oP8003X000on0P00>P003o`000?l0A`0003l0027oP<20
`830P<20`830P<20oh30P<20`830P<20`830P?l0o`1:0000@0000on0P00<P003oh2000b000?o0000
o`190000@@007On0`830P<20`830P<20oh30P<20`830P<20`83o0?l0C000048000?oP8002X000on0
P00:P003o`000?l0B`0004<001WoP<20`830P<20`83oP<20`830P<20`83o0?l0CP0004@000?oP800
28000on0P008P003o`000?l0C@0004D001GoP<20`830P<20oh30P<20`830P?l0o`1@0000AP000on0
P006P003oh2000J000?o0000o`1?0000A`004On0`830P<20oh30P<20`83o0?l0DP0004P000?oP800
18000on0P004P003o`000?l0D@0004T000goP<20`83oP<20`83o0?l0E00004X000?oP8000X000on0
P002P003o`000?l0D`0004/000WoP<20oh30P?l0o`1F0000C0001?n0P?l2P003o`000?l0E@0004d0
00GoP?n0o`3o05P0001>00?oo`1I0000C`000ol0003o05P0003o0:X0003o0:X0003o0:X00000\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=3o`=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d?oo00:00]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000W@ol3o`830P=00<P000m0000050003d000030000?@00001@000m00
000`0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d005
oh20P?l018000m3o000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00
000^0003d00003D0000J0003d00002/000o@003oP<20oh30P<20d?l0;0000m00000:0003d00002/0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@0P000on0P002P003oh2000B00]0Y00;@3P03d2P00]0>00?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]03000?oh30P<20oh30P<20`83000;@9P000m00000A0003d00002@000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003
d000008000?oP80018000on0P008P003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d0D001?o`830
P<20`?o0P<20`830P<2000;@8002d1L00]0P00;@5`02d2000]0G00?@7`02d1L00m0O00;@?P000280
0m0J00;@1P000on0P006P003oh2000Z00m0J00?@6`03d1X00m0K00?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m07000Hol20`830P<20`?o0P<20`830P<20`8300_l2d1H00]0Q00;@5P02d240
0m0E00;@8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0:0003oh2000N000?oP8003H000ol0
d004d0/01]0U00G@2`06d2H01=0;00K@9P04d0/01]0V00G@2P06d4D0000?00<O6P0;d0h001coP<20
`830P<20`?o0P<20`830P<20`830P<200_l400_@<00;d3002m0`00_@<@0:d4/0000?00<O<P000on0
P009P003oh20012000?o0000o`140000@`008_n0`830P<20`830P<20oh30P<20`830P<20`830P<20
`?oo04D000130003oh2000^000?oP8004H02ool0@`00048002Ko`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20ool0@P00044000?oP8003H000on0P00DP0;oo`100000@000:oo0P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?l0o`0o00003`037bh000?oP8003X000on0
P00GP0;oo`0m00003`037bd002ooP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20o`3o03`0000?00<O;0000on0P00AP003oh2001V00_oo03X0000m000doh30P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830ool0>@0003d000?oP8004X000on0
P00LP003o`000?l0=P0003`003Ko`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<02ool0=P0003/000?oP8005H000on0P00NP003o`000?l0<`0003X003_o`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P002ool0
<`0001800alU0003oh2001J000?oP8008H000ol0003o0300000B00<O9000?on0`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`002ool0<0000180
0alS0003oh2001R000?oP80098000ol0003o02d0000h0013ol20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002ool0;@0003L000?oP800
6X000on0P00VP003o`000?l0:P0003H004Wo`830P<20`830P<20`830P<20`830P<20`830P<3o`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0?l0:`0003D000?oP80078000on0
P00XP0;oo`0Y0000=@00COn0`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0:00003@000?oP8007H000on0P00[P0;o
o`0V00005`037aT005;oP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3oo`0U00005`037aP000?oP80088000on0
P00ZP0Coo`0T00005`037aP004Wo`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<2000Oo00B0`83oo`0T0000<@000on0P00QP003
oh2001b01ol9P003o`000?l08`00030003go`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<2000Oo0120`830P<20`830P<20`83oo`0V0000;`000on0
P00SP003oh2000n01_lEP003o`000?l09@0002l0037oP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`83000Oo01c0P<20`830P<20`830P<20`830P<20`830P<3oo`0W0000
;P000on0P00UP003oh2000Oo8H000ol0003o02H0000201co0aooofKo8`0001h00al<0003oh2001f0
1_l2P0?o9h000ol0003o02P0000N00<O2`006oo0P<20`830P<20`830P<20`830P<20`830P006o`08
`830P<20`803o`0XP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20ool0:P0002/0
00?oP8004h06o`n000?oP8009H000ol0003o02T0000Z000Bol20`830P<20`830P<20`8301Ol0?L20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?l0
o`0/0000:P000on0P009P0Ko6h000on0P00SP003o`000?l0:P0002T000OoP<20`83000Ko04N0`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830o`3o02d0000V00<O00>0ool01?lWP003oh20026000?o0000o`0/00009P037`1Boh30P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20
`830P<20`830P<20`830ool0;`0002H00al00on0P00[P003oh20022000?o0000o`0]0000:P02o`1>
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`83oo`0`0000;0000on0P00YP003oh2001f000?o0000o`0_0000;@02o`19
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830P<20o`3o0380000_0003oh2002J000?oP80078000ol0003o0300000`0017ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`?l0o`0c0000<@02obJ000?oP8006H000ol0003o0380000c0012oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<3oo`0e0000=002ob>0
00?oP80068000ol0003o03<0000f000nol20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P?oo03H0000g00;o88000on0P00FP003o`000?l0=@0003T0
03WoP<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P?l0
o`0h0000>P02oaj000?oP80058000ol0003o03H0000l000eol20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`?l0o`0i0000?@000on0P00JP003oh2001:000?o0000
o`0h0000?P02o`0`P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83o
o`0j0000@0000on0P00GP003oh20016000?o0000o`0i0000@@02o`0[`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20o`3o03`000130003oh2001F000?oP8003X000ol0003o03/0
001400;o02N0`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`?l0o`0m0000AP000on0
P00BP003oh2000f000?o0000o`0l0000A`02o`0R`830P<20`830P<20`830P<20oh30P<20`830P<20
`830ool0?`0004T000?oP8003h000on0P00;P003o`000?l0?P0004X0023o`830P<20`830P<20`830
P?n0`830P<20`830P<20ool0@00004/00_l?P003oh2000V000?o0000o`0o0000C@006on0`830P<20
`830P<20`?o0P<20`830P<20o`3o0480001>00;o38000on0P007P003o`000?l0@@00050001Oo`830
P<20`830P<3o`830P<20`830o`3o04<0001A00;o2H000on0P006P003o`000?l0@P0005<001;oP<20
`830P<20oh30P<20`?oo04D0001D00;o1h000on0P004P003o`000?l0@`0005H000ko`830P<20oh30
P<20ool0AP0005L000?oP8000h000on0P002P003o`000?l0A@0005P00_l02830P?n0`83oo`180000
FP001?n0P?l3P003o`000?l0AP0005/00_l01<3o`?oo04T0001M00?oo`1:0000GP000ol0003o04T0
003o0:X0003o0:X0003o0:X00000\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d?oo00800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000C@0?n00_l20003d000030000?@00001@000m00000`0003d00000D0
00?@0000<0000m0000050003d000030000?@00001@000m00000`0003d00003@0000I0003d00002d0
0]00103oP?l2P0?o00?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T0
00?@0000;P000m00000e00006P000m00000[000>d0000?o0ol20`830om0]0003d00000X000?@0000
:`000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]030004oh20o`N00]0Y00;@3P03d2P00]0>00?@:002d0h00m0X00;@3P03d2T00]0i0000
7@02d2D00]05000=oh30P?n0`830P<20`002d2H000?@00004@000m00000T0003d000014000?@0000
90000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m0000040003
oh2000:000?oP80028000m3oo`0R0003d00001<000?@00008P000m00000C0003d000028000?@0000
4`000m00000R0003d00001<000?@00008P000m00000k00008002d1l00]07000Aol20`83oP<20`830
P<20`8000]02oah00]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@6P02d0P0
00?oP80018000on0P00:P0?@00?o00005`03d1/00m0J00?@6`03d1X00m0L00;@6P03d1`00]0J00?@
@00002D00]0E00?@2P005on0`830P<3o`830P<20`830P<20`83000;@00?o00004`02d2400]0F00;@
8@03d1D00]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d0`000?oP8001X000on0P00>P0G@
2`06d2D01M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@4@007oo0P<20`830
P?n0`830P<20`830P<20`830P<20`?l02m0`00_@<00;d3002m0a00[@B`0000l00alf0003oh2000J0
00?oP8005802ool0@00004L002?oP<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`003ool0
?@0004L000?oP80028000on0P00HP0;oo`0k0000AP00:Oo0P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`830P<2000;oo`0i0000AP000on0P00:P003oh2001^00_oo03L00015000^oh30P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P0?oo`0d00003`037c<000?oP800
38000on0P00OP0;oo`0b00003`037c8003Co`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`8300_oo0300000?00<O<P000on0P00=P003oh2002>00_oo02h00013000i
oh30P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000?o
o`0[0000@`000on0P00?P003oh2002N00_oo02T00012000ool20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;oo`0W0000@P000on0P00AP003
oh2002Z00_oo02D000110014oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`803ool08P0001800al/0003oh2001:000?oP800;h02ool0
800001800al[0019ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P002ool07`0001800al[0003oh2001B000?oP800;803o`03
P?l00?l07P0003l004CoP<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P0?o00B0`83oo`0P0000?`000on0P00FP003oh2002F00ol6P003
o`000?l07P0003l003koP<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0?o00V0`830P<20`?l0o`0Q0000?P000on0P00HP003oh2001n00_l;P003
o`000?l07`0003h003[o`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`8300ol03L20`830P<20`830P?l0o`0R0000?@000on0P00IP003oh2001V00ol?P003
o`000?l0800001L00alS000eoh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<000ol04/20`830P<20`830P<20`830ool08`0001L00alR0003oh2001^000?oP800
4X03oaB000?o0000o`0Q00005`037b80033o`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<03o`0G`830P<20`830P<20`830P<20`830P?l0o`0T0000>`000on0P00MP003
oh2000b00_lIP003o`000?l08P0003/002coP<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P0?o01b0`830P<20`830P<20`830P<20`830P<20`83oo`0T0000>P000on0P00OP003
oh2000F00olMP003o`000?l08`0003X002Oo`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`8000ol08H30P<20`830P<20`830P<20`830P<20`830P<20`830o`3o02D0000i0003oh200220
00?oP?l00_lRP003o`000?l0900000807?l37oooI_lS00007P037aL000?oP8007X06ob>000?o0000
o`0U00007P037aL001ko`830P<20`830P<20`830P<20`830P<20`830P<03o`03`83000?o02C0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?oo02L0000g0003oh2001V00ol8P003oh200220
00?o0000o`0V0000=`006_n0`830P<20`830P<20`830P<20`830P<200_l0;l20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0:00003H000?oP8005H03o`j000?oP800
7X000ol0003o02L0000f000Eol20`830P<20`830P<20`830P<2000?o03>0`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`?l0o`0Y00009P037`d000?oP8003h03oaF0
00?oP80078000ol0003o02P0000V00<O30004On0`830P<20`830P<20`83000;o03R0`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20ool0:P0002H00al<0003
oh2000^00olJP003oh2001^000?o0000o`0Y0000=0003?o0P<20`830P<20`0?o03c0P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`?oo02/0000d0003
oh2000J00olQP003oh2001V000?o0000o`0Z0000<`002?n0`830P<200_l0@L20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`83o0?l0;00003<0
00?oP8000X03obN000?oP8005h000ol0003o02/0000b0003ol2000?o04F0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`?l0o`0]0000
<P03obj000?oP8005X000ol0003o02/0000`00<O04W0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`83o0?l0;P0003000al2obn0
00?oP80058000ol0003o02`0000`00<O0P03o`13P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830o`3o02l0000h00;o:X000on0P00CP003
o`000?l0;@0003X00_l0?X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`83oo`0`0000?002obN000?oP8004H000ol0003o02h0000n00?o03S0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830ool0<@000440
0_lSP003oh2000n000?o0000o`0_0000@`02o`0c`830P<20`830P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`83o0?l0<P0004D00_lPP003oh2000f000?o0000o`0`0000A`03o`0]
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<3o0?l0<`0004X00_lKP003
oh2000b000?o0000o`0a0000C002o`0XP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20ool0=00004h00olGP003oh2000Z000?o0000o`0b0000D@02o`0R`830P<20`830P<20`830P<20
`830P?n0`830P<20`830ool0=@0005<00_lDP003oh2000R000?o0000o`0c0000E@02o`0M`830P<20
`830P<20`830P<20oh30P<20`830P?l0o`0f0000E`03oa2000?oP8001X000ol0003o03@0001J00;o
01R0`830P<20`830P<20`?o0P<20`830P?oo03H0001L00;o3H000on0P004P003o`000?l0=@0005h0
0_l04h30P<20`830P<20oh30P<20`?l0o`0g0000H003o`R000?oP8000h000ol0003o03H0001S00;o
00g0P<20`830ol20`83o0?l0>00006D00_l5P005oh20P?l0o`0i0000I`02o`08`830P?n0`?oo03T0
001Y00?o00B0oh3oo`0j0000K002o`03P?l00?l0>@0006h000?o0000o`0i0000o`2Z0000o`2Z0000
o`2Z0000o`2Z0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@1@03o`X00]0V0003
d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@00001@000on0P005o`L000?@00008P000m00000C0003d0000280
00?@00004`000m00000R0003d00001<000?@00008P000m00000C0003d000028000?@0000>`000200
0]0O00;@2002o`06`830P<201Ol300;@8002d1L00]0P00;@5`02d2000]0G00?@7`02d1L00m0O00;@
?P0002800m0J00;@2@001?n0P?l:P0Go0m0J00?@6`03d1X00m0K00?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0;000Col20oh30P<20`830P<20`830P003o`;@5P02d2400]0F00;@8@03d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d0h000GoP820o`0BP003om3@00?@2`06d2D0
1M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@4`007Oo0P<20oh30P<20`830
P<20`830P<20`830P<3o00_@<00;d3002m0`00_@<@0:d4/0000?00<O>0000on0P002P003oh2001V0
1?oo03/00019000Voh30P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`805ool0=P0004T0
00?oP8001H000on0P00PP0Goo`0a0000B@00<?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0Goo`0/0000B@000on0P006P003oh2002V01?oo02P00018000jol20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0Goo`0S0000
3`037cH000?oP8002H000on0P00`P0Goo`0N00003`037cH004Co`830P<20`830P<3o`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;oo`0L00003`037cH0
00?oP8002X000on0P00bP0;o00>0o`00o`0K0000B000A_o0P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P?oo01`000170003oh2000b0
00?oP800;X02o`>000?o0000o`0K0000A`00?_n0`830P<20`830P<20`83oP<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<200_l01/20`830ool07@0004L000?oP8003X000on0
P00YP003oh2000F000?o0000o`0K0000A`00>on0`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`83000;o00V0`830P<20`?l0o`0M00004P037c4000?oP800
48000on0P00TP0;o2H000ol0003o01`0000B00<O<@00A_o0P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P?oo01h0000B00<O<@000on0
P00AP003oh2002200_l<P003o`000?l0700004H003Go`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P002o`0?`830P<20`830P<20`83o0?l07P0004H000?oP800
4h000on0P00KP003oh2000f000?o0000o`0M0000A@00<on0`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`002o`0AP<20`830P<20`830P<20`?l0o`0O0000A@000on0
P00EP003oh2001J00_lBP003o`000?l07@0004D004KoP<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<3oo`0O0000A@000on0P00GP003
oh2001600_lEP003o`000?l07@0001L00alZ000]ol20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<2000;o01O0P<20`830P<20`830P<20`830P<20o`3o0200000G00<O:P000on0
P00IP003oh2000f000?oP8005X000ol0003o01h0000G00<O:P00:_o0P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`0;o01Z0`830P<20`830P<20`830P<20`830P<20ool0800004@0
00?oP8006X000on0P008P0;o6h000ol0003o01h000140015ol20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3o0?l08@0004<000?oP800
7H000on0P003P0;o7H000ol0003o01l00013000Toh30P<20`830P<20`830P<20`830P<20`830P<20
`83oP<200_l08<20`830P<20`830P<20`830P<20`830P<20`830P<3oo`0Q0000@`000on0P00NP003
oh3o026000?o0000o`0O00000P0Lo`<OoomVob<0000N00<O8@000on0P00NP0Co88000ol0003o0200
000N00<O8@007oo0P<20`830P<20`830P<20`830P<20`830P<20`8000_l09L3oooo0P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0o`0R0000@P000on0P00JP0;o1X000on0P00MP003o`000?l0
8000048004Go`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`?l0o`0S0000@P000on0P00GP0;o2X000on0P00KP003o`000?l08@000440
04KoP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20oh30P<20`830P<20`830P<20
`830P<20`830P<3oo`0S00009P037aP000?oP8005H02o`j000?oP8006X000ol0003o0240000V00<O
60005_n0`830P<20`830P<20`830P<20`802o`0]`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`83o0?l0900002H00alH0003oh2001:000?oP8004H000on0P00HP003o`000?l0
8P00040001Co`830P<20`830P<20`830P<20`0;o0320`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P?oo02@000100003oh20012000?oP8005X000on0P00FP003o`000?l0
8P000400017o`830P<20`830P<20`830P002o`0c`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`83o0?l09000040000?oP8003802oab000?oP80058000ol0003o02<0
00100015ol20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<3o0?l09@0003l000?oP8002X02ob2000?oP8004h000ol0003o02<0000`00<O
3000A_n0`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`?oo02D0000`00<O30000on0P007P0;o9H000on0P00@P003o`000?l090000300
0al<0008oh30P<20`802o`0k`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P?l0o`0V0000?P000on0P005P003oh2002R000?oP8003h000ol0003o02@0
000n0006ol20`8300_l0?X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`83oo`0V0000?P000on0P002P003oh2002b000?oP8003H000ol0003o02D0
000n0003ol2000;o0430P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<3oo`0W0000?P03oc:000?oP80038000ol0003o02D0000l00<O04C0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830ool09`0003`00al00on0P00cP003oh2000V000?o0000o`0V0000?0037`030?oo00?o03g0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`83o0?l0
:00004D01Ol/P003oh2000R000?o0000o`0V0000BP04o`0dP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20ool0:00004h01OlTP003oh2000J000?o0000o`0W0000
D`05o`0YP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`?l0o`0Y0000F004oaf0
00?oP80018000ol0003o02L0001L00Go0230P<20`830P<20`830P<20`830P<20`83oP<20`830ool0
:@0006401?lEP003oh2000>000?o0000o`0W0000I@05o`0FP<20`830P<20`830P<20`?o0P<20ool0
:P0006X01Ol<P005oh20P?l0o`0Z0000K`04o`0=`830P<20`830ol20o`3o02X0001c00Go18001?n0
P?oo02X0001h00Ooo`0[0000O@02ool0:`000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@
>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@
6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0V00C@
2`06d2H01M0:00K@A@0000l00alJ00_@500Lo`_@7OlC00_@<00;d3002m0a00[@B`0000l00ali0003
oh3o03j000?oP?l0o`0K0000B`00A?n0`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`83oP<3oo`0K0000B`001On0P83o03Z000GoP820o`3o01/0
001;0014oh30P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`?oo01/0001;0003oh2000>000?oP800=8000on0P003P003o`000?l06@0004/0
04CoP<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830ool06`0000l00ali0003oh2000F000?oP800<8000on0P005P003o`000?l06@0000l0
0ali0014oh30P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?n0`830P<20`?oo01/0000?00<O>@000on0P007P003oh2002b000?oP8001h000ol0003o01T0
001;0014oh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`?oo01/0001;0003oh2000V000?oP800:8000on0P009P003o`000?l06@0004/0
04CoP<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830ool06`0004/000?oP8002h000on0P00TP003oh2000^000?o0000o`0I0000B`00A?n0
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<3oo`0K00004P037cH000?oP8003H000on0P00PP003oh2000f000?o0000o`0I00004P037cH0
037oP<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`83000;o0160`830
P<20`830P<20`830o`3o01/0000B00<O=P000on0P00?P003oh2001^000?oP80048000ol0003o01T0
001;0014oh30P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`?oo01/0001;0003oh20016000?oP8005h000on0P00BP003o`000?l06@0004/0
04CoP<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830ool06`0004/000?oP8004h000on0P00CP003oh2001B000?o0000o`0I0000B`00A?n0
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<3oo`0K0000B`000on0P00EP003oh2000n000?oP8005X000ol0003o01T0000G00<O<@00A?n0
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<3oo`0K00005`037c4000?oP8005h000on0P00;P003oh2001R000?o0000o`0I00005`037c40
04CoP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830ool06`0004/000?oP8006H000on0P007P003oh2001Z000?o0000o`0I0000B`00A?n0
`830P<20`830P<20`830P<20`830P<20`830ol20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<3oo`0K0000B`000on0P00KP003oh2000>000?oP80078000ol0003o01T0001;0014oh30P<20
`830P<20`830P<20`830P<20`830P<20`?o0P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`?oo01/0001;0003oh2001f000?oP?l088000ol0003o01T0000201co0aooofKo8`0001h00alZ0003
oh2001f01?lOP003o`000?l06@0001h00alZ000Ooh30P<20`830P<20`830P<20`830P<20`830P<20
`004o`0QP?n0`830P<20`830P<20`830P<20`830P<20`830P<3o0?l06`0004/000?oP8006h000on0
P004P003oh2001^000?o0000o`0I0000B`00A?n0`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3oo`0K0000B`000on0P00IP003oh2000R0
00?oP8006H000ol0003o01T0001;0014oh30P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`?oo01/0000V00<O8P000on0P00GP003oh2000b0
00?oP8005h000ol0003o01T0000V00<O8P00A?n0`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<3oo`0K00009P037b8000?oP8005H000on0
P00@P003oh2001F000?o0000o`0I0000B`00A?n0`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<3oo`0K0000B`000on0P00CP003oh2001B0
00?oP8004h000ol0003o01T0001;0014oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`?oo01/0001;0003oh20016000?oP80068000on0
P00AP003o`000?l06@0004/004CoP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830ool06`0004/000?oP8003h000on0P00LP003oh2000n0
00?o0000o`0I0000<0037aP004CoP<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830ool06`0003000alH0003oh2000f000?oP80088000on0
P00=P003o`000?l06@0003000alH0014oh30P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`?oo01/0001;0003oh2000^000?oP80098000on0
P00;P003o`000?l06@0004/004CoP<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830ool06`0004/000?oP8002H000on0P00XP003oh2000V0
00?o0000o`0I0000B`00A?n0`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<3oo`0K0000B`000on0P007P003oh2002b000?oP8001h000ol0
003o01T0000l00<O3000A?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<3oo`0K0000?0037``000?oP8001H000on0P00`P003oh2000F0
00?o0000o`0I0000?0037``004CoP<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830ool06`0004/000?oP8000h000on0P00dP003oh2000>0
00?o0000o`0I0000B`00A?n0`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<3oo`0K0000B`001On0P83o03Z000GoP820o`3o01/0001;0014
oh30ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?n0`?oo01/0001;0003oh3o03j000?oP?l0o`0K0000BP037`10`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0;oo`0K0000BP037d;o
o`0K0000BP037ol0G@000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
2003o`H000?@000090000m00000A0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@000050000m00000R0003d00000@01Ol2P003o`0000D000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000k0000
8002d1l00]0H00;@8002d0801Ol01X30P<20`0;o2002d2000]0G00;@8002d1L00m0O00;@5`03d1l0
0]0n00008P03d1X00]0L00?@6P03d0Co2X001?n0P?l900?@6P03d1/00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d2400]0F00;@0ol04/20`830P<20`830P<20oh30o``00]0F00;@8@03d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@4X001On0P83o00h01M0;00K@
9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d00Mol20`830P<20`830P<20`830
P<20`83oP<20`?l04`0;d3002m0`00_@<@0:d4/0000?00<OF005oaZ000?oP8000h000ol0003o01P0
001V00Co02J0`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20ool06P0006401OlQP003
oh2000F000?o0000o`0H0000G005o`0_`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P?l0o`0J0000F004obZ000?oP8001h000ol0003o01L0001C00Go03V0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`?l0o`0I00003`037c`0
1OlbP003oh2000R000?o0000o`0G00003`037cX00_l0@h30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`?l0o`0I00003`037cX000CoP?oo
<h000on0P00:P003o`000?l05`0004`004Ko`830ol20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`83oo`0H0000C@001?n0P802obn000?oP800
38000ol0003o01H0001=0006oh30P<200_l0?L20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P?l0o`0H0000C@000on0P005P003oh2002V000?oP800
3H000ol0003o01H0001=0009oh30P<20`83000;o03^0`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830o`3o01L0000B00<O>0000on0P008P0;o9X000on0
P00?P003o`000?l05@0001800ali0015ol20`830P<20`830ol20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<3o0?l05`0001800ali0003oh2000Z00_lQP003
oh20016000?o0000o`0E0000CP003oo0P<20`830P<20`830P002o`0e`830P<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P?l0o`0F0000CP000on0P00>P003oh2001^0
00?oP8004h000ol0003o01@0001?000Aoh30P<20`830P<20`830P<000_l0<X30P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`83oo`0F0000C`000on0P00@P0;o68000on0
P00DP003o`000?l0500004l004KoP<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<3oo`0E0000C`000on0P00CP0;o4h000on0P00GP003
o`000?l04`0001L00ale000Hoh30P<20`830P<20`830P<20`830P<200_l0;<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<3oo`0E00005`037cH000?oP8005X000on0P00=P003
oh2001R000?o0000o`0C00005`037cH001[o`830P<20`830P<20`830P<20`830P<20`0;o02Z0`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P?oo01@0001@0003oh2001V00_l:P003
oh2001Z000?o0000o`0B0000D000A_o0P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P?oo01@0001A0003oh2001^00_l5P003oh2001b0
00?o0000o`0B0000D@008?n0`830P<20`830P<20`830P<20`830P<20`830P<200_l08l20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`83o0?l05000054000?oP8007h000on0o`0PP003o`000?l0
4@0000807?l37oooI_lS00007P037c0000?oP8007X03o`03P?n001j000?o0000o`0A00007P037c40
023o`830P<20`830P<20`830P<20`830P<20`830P<20`0?o02;0P?oo`830P<20`830P<20`830P<20
`830P<20`830P<3oo`0C0000DP000on0P00MP003oh2000B00_lLP003o`000?l04000058004Ko`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`83oo`0B0000DP000on0P00LP003oh2000R00_lIP003o`000?l0400005<004GoP<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P?l0
o`0B00009P037bX000?oP8006X000on0P00<P0;o5h000ol0003o00l0000V00<O:P00;_n0`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`802o`0F`830P<20`830P<20`830P<20
`830ool04@0002H00alZ0003oh2001R000?oP8004X000on0P00BP003o`000?l03`0005<0037oP<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83000;o01>0`830P<20`830
P<20`830P<3o0?l04@0005@000?oP8005X000on0P00FP003oh20012000?o0000o`0>0000E000<oo0
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P002o`0A`830P<20
`830P<20`830P?l0o`0@0000E0000on0P00EP003oh2001Z00_l>P003o`000?l03P0005@004Ko`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`83oo`0@0000E@000on0P00BP003oh2001n00_l<P003o`000?l03@0003000alR0016oh30P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830ool03`0003000alR0003oh20016000?oP8008h02o`V000?o0000o`0=0000<0037b8003coP<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`802o`08
`830P<20`?oo00l0001E0003oh20012000?oP800:8000on0P004P003o`000?l03@0005H003ko`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;o
00J0`830P?oo00h0001F0003oh2000f000?oP800;H000on0P002P003o`000?l0300005H0047o`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P002o`03`83o0?l03P0005H000?oP80038000on0P00aP0?oo`0>0000?0037aP004CoP<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0;o
o`0=0000?0037aP000?oP8002X000on0P00cP0?oo`0=0000?0037aP003koP<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0Goo`0@0000E`000on0
P008P003oh2002^01Ooo01D0001G000doh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0Goo`0J0000F0000on0P006P003oh2002>01?oo01l0001H000Zol20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`8301Ooo02<0001H0003oh2000F000?oP800
6X05ool0:00004X00al;000Qol20`830P?n0`830P<20`830P<20`830P<20`830P<2000Coo`0]0000
BP037``000?oP8000X000on0P00CP0Goo`0a0000BP037``001KoP<20`?o0P<20`830P<20`830P<20
1Ooo03H0001I0005oh20P?l03805ool0>`0005T000goP<3o`830P<20`83000Coo`100000F@001?n0
P?l4P0Goo`140000F@037`Goo`190000F@037ol0CP0005T00aoo04h0003o0:X0003o0:X0003o0:X0
003o0:X0003o0:X0003o0:X0003o0:X0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0005d0000?l00]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000;o00C0o`3@<P000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@0ol2P005oh3o0=00;`02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000
;P000m00000e00006P000m00000[0003d00000X000?@0000:`002m3ooh30P<20oh3o008000?@0000
:`000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]0>00;@:@02d003oh2000F000CoP83o0P03d2P00]0>00?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]0B00;@9P003m3oP<20`830P<3o`830o`050003d00002@000?@00004@000m00
000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008002o`03d82000R000?oP8000X000ol000030003d000028000?@00004`000m00000R0003
d00001<000?@00008P000m00000C0003d000028000?@0000>`0002000]0O00;@6002d1h00_l2d00A
`830P<20`830P?n0`830P?l01P02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X0
0]0L00?@6@001?o@d=0<P003oh2000>000?o00001P03d1X00m0K00?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5@006_o@d830P<20`830P<20`830P?n0`830P<3o2P02d1H00]0Q00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0@P003oh2000F000?o0000
2P05d0/01]0V00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@0_l07X30P<20`830
P<20`830P<20`830ol20`830P<20oa002m0`00_@<00;d3402]1;00003`037eh00_lEP003oh2000N0
00?o0000o`0F0000K@03o`0SP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`?l0o`0G0000
J`02oaZ000?oP80028000ol0003o01D0001Y00;o02W0P<20`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20o`3o01H0001W00;o7H000on0P00:P003o`000?l0500006@00ol0;/20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`?oo01D0000?00<OD002ob6000?oP800
38000ol0003o01<0000?00<OCP02o`0cP<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<3o0?l05@0000l00am<00;o98000on0P00>P003o`000?l04P0005/00ol0>830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`83oo`0D0000
F@02obR000?oP80048000ol0003o0140001G00;o03k0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830ool04`0005D00_l/P003oh20016000?o0000
o`0@0000DP03o`13`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20o`3o0180000B00<O>`02oc2000?oP8004h000ol0003o00l0000B00<O
>P02o`18`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<3oo`0A00004P037cX000?oP?l00_l]P003oh2001F000?o0000o`0>0000
D0001?o0P<03o`13`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<20o`3o0100001@0003oh2000B00olVP003oh2001N000?o0000o`0=0000
D@002On0`830P<20`002o`0oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<3o0?l03`00054000?oP8002803ob6000?oP8005h000ol0003o00d0
001B000=ol20`830P<20`830P003o`0jP<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20ool03P00058000?oP8003H03oaZ000?oP8006H000ol0003o00`0
000G00<O>0004oo0P<20`830P<20`830P<20`8000_l0=/20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830ool03@0001L00ali0003oh2001600olDP003oh2001^0
00?o0000o`0;00005`037cT001OoP<20`830P<20`830P<20`830P<20`003o`0a`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20o`3o00`0001D0003oh2001J00ol=P003
oh2001f000?o0000o`0:0000E0007?o0P<20`830P<20`830P<20`830P<20`830P<02o`0]P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<3o0?l02`0005D000?oP8006X03o`N0
00?oP8007h000ol0003o00T0001E000Poh30P<20`830P<20`830P<20`830P<20`830P<20`803o`0X
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20ool02P0005H000?oP8007h03o`03
P?n0026000?o0000o`0800000P0Lo`<OoomVob<0000N00<O=P000on0P00PP0Ko88000ol0003o00L0
000N00<O=P008on0`830P<20`830P<20`830P<20`830P<20`830P<20`83000?o00?0P<000ol07/20
`830P<20`830P<20`830P<20`830P<20`830ool02@0005L000?oP80088000on0P006P0?o6h000ol0
003o00H0001H000^ol20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`0;o
01Z0`830P<20`830P<20`830P<20`830P<20ool0200005P000?oP8007X000on0P00<P0?o5h000ol0
003o00D0001I000boh30P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`803o`0EP<20`830P<20`830P<20`830P<3o0?l01`0002H00al`0003oh2001b000?oP8004h03oa:0
00?o0000o`0400009P037c4003Oo`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830P<2000;o0170P<20`830P<20`830P<20o`3o00H0000V00<O<@000on0P00KP003
oh2001R00ol>P003o`000?l00`0005/003_oP<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<20`830P<20`003o`0<`830P<20`830P<3oo`050000F`000on0P00IP003
oh2001n00ol8P003o`000?l00`0005`0043o`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`8300_l02830P<20`83oo`040000G0000on0P00GP003
oh2002F00ol4P003o`000?l00P0005d004CoP<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P0?o00>0`?l0o`030000G@000on0P00EP003
oh2002b00ooo00<0000`00<O:P00BOn0`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000_oo0080000`00<O:`000on0P00CP003
oh2002f00_oo00@0000`00<O:`00@oo0P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`8000ooo00H0001O0003oh2001:000?oP800:802ool0
2@0005l003koP<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P0;oo`0;0000H0000on0P00@P003oh2002F00_oo00d0001P000hol20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<03ool03`00064000?oP800
3X000on0P00QP0;oo`0B0000?0037b8003?oP<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<20`830P<000_oo01@0000l00<O8`000on0P00<P003oh2001j00_oo01H0000l00<O
8`00;Oo0P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P003ool060000680
00?oP80038000on0P00IP0;oo`0K0000H`00:?n0`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`802ool07@0006<000?oP8002X000on0P00EP0?oo`0O0000I0008_o0P<20`830P<20oh30
P<20`830P<20`830P<20`830P<02ool08P0006@000?oP80028000on0P00BP0;oo`0T0000BP037aP0
01goP<20`830P<20oh30P<20`830P<20`830P<20`002ool09P0004X00alH0003oh2000J000?oP800
3X03ool0:00004X00alI000Gol20`830P<3o`830P<20`830P<20`8000_oo02/0001V0003oh2000B0
00?oP8002h02ool0;@0006L001;oP<20`83oP<20`830P<20`802ool0;`0006L000?oP8000h000on0
P006P0?oo`0a0000F@037`/000goP<20`?o0P<20`83000;oo`0d0000F@037``000GoP820o`05P0;o
o`0f0000F@037``000So`83oP<20`0;oo`0h0000J@001?n0oh03ool0>P0006T00al00ol0003o03/0
001Y00<Oo`0n0000J@037ol0?P000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d<3od3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0c0004om20P0;o0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000_000:om30P<3o`?l0d38000?@00001@000m00
000`0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0T0
00?@0000;@02d0>000OoP820o`3@02l00]090003d00002d00]090003d00002d00]090003d00002h0
00?@0000=@0001X000?@0000:`000m00000:0003d00002X000cod830P<20oh30P?l20003d00002/0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@3P02d2T00]06P003oh2000:000?o00000m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2D0017od<20`830P<20oh30P<20o`040003d00002@000?@00004@000m00
000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008@000oo@P008P003oh2000B000?o00000P000m00000R0003d00001<000?@00008P000m00
000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0O000Eom3@`830
P<20`830ol20`830P<3o00D00]0P00;@5`02d2000]0G00?@7`02d1L00m0O00;@?P0002800m0J00;@
7003d1X00m0;P003oh2000J000?o00001003d1X00m0K00?@6P03d1`00]0J00?@7002d1X00m100000
9@02d1D00m0Q00;@5P02d00Iol20`830P<20`830P<3o`830P<20`830o`0800;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d0;o3X000on0P007P003o`0000P0
1M0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d0D001goP<20`830P<20
`830P<20`?o0P<20`830P<20o`0>00_@<00;d3002m0a00[@B`0000l00amS00;o4H000on0P009P003
o`000?l04`0007@002;o`830P<20`830P<20`830P<20oh30P<20`830P<20`83oo`0D0000L`000on0
P00AP003oh2000^000?o0000o`0B0000L@02o`0T`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<3oo`0C0000L0000on0P00DP003oh2000f000?o0000o`0@0000KP02o`0YP<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`?l0o`0A00003`037e/000?oP8005h000on0P00>P003
o`000?l03`0000l00amI00;o02g0P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P?l0o`0@00003`037eP000?oP8006H000on0P00AP003o`000?l03@0006T003?oP<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P?l0o`0>0000I`02oaf000?oP800
4X000ol0003o00`0001V000gol20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830o`3o00d0001T00;o7h000on0P00EP003o`000?l02P0006<003coP<20`830P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?oo00/0000B00<O
C002ob:000?oP8005X000ol0003o00T0000B00<OB`00@?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P?oo00X0000B00<OBP000on0P00SP003
oh2001R000?o0000o`070000G@02o`12`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830P<20`830P<3oo`090000G0000on0P00UP003oh2001Z000?o0000
o`060000FP02o`17P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`?l0o`070000F@000on0P00XP003oh2001b000?o0000o`040000
F000C?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P?oo00H0001F00;o;8000on0P00MP003o`000?l00`0001L00alk001A
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`83o0?l0100001L00alj00Co:h000on0P00PP003o`000?l00@0001L0
0alj0004ol20`0Oo04S0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`?oo00<0001E0003oh2000N01_lNP003oh20026000?o0000
o`0005H000oo`830P<20`830P<20`8001ol0?H30P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?l0o`010000E`000on0P00BP0Oo48000on0P00SP003
o`000?d0001G000Loh30P<20`830P<20`830P<20`830P<20`830P0Ko0370P<20`830P<3o`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?l0001H0003oh2001j01ol2P003oh2002F0
00?o0000o00000807?l37oooI_lS00007P037cP000?oP8009H03o`:01_lOP003o`000?/0000N00<O
>@009oo0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P003o`08P<20`830P<06o`0K
P<20`830P<20`830P<20`830P<20`830P<3o0?`0001K0003oh2002B000?oP8003H06oaF000?o0000
n@0005`003co`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<05o`0B`830P<20`830P<20`830P<3onP0005`000?oP8008X000on0P00IP0Ko2h000ol0
003h0000G@00A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P<20`830P<20`830P<20`806o`07`830P<20o`3i00009P037cD000?oP80088000on0P00UP0Ko
00>0o`00m`0002H00ale001Aol20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000?om`0002H00alf0003oh2001n0
00?oP800:h000ol0003g0000H000COo0P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;onP00064000?oP80078000on0
P00YP003o`000?X0001Q0019oh30P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`002ood0001R0003oh2001^000?oP8009X000ol0
003m0000H`00A_n0`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`?oo0040001S0003oh2001V000?oP8009802ool00P0003000ala0012
ol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`83oo`040000<0037c8000?oP8005h000on0P00QP0;oo`050000<0037c<003go`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0?l01`0006H0
00?oP8005X000on0P00NP0;oo`080000I`00>On0`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20o`3o00X0001X0003oh2001>000?oP8007802ool02`0006P0
03Go`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830o`3o00d0
001Y0003oh2001:000?oP8006X000ol0003o00`0000l00<O:`00;oo0P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<2000;oo`0?0000?0037b`000?oP80048000on0P00GP003
o`000?l03`0003`00al/000[oh30P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`002ool04P0006`000?oP8003X000on0P00EP003o`000?l04P0006d002KoP<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P0;oo`0E0000K@000on0P00=P003oh2001:000?o0000o`0E0000
KP008_o0P<20`830P<20`830P?n0`830P<20`830P<20`830P<02ool0600006l000?oP8002h000on0
P00?P003o`000?l0600004X00alS000Ool20`830P<20`830P?n0`830P<20`830P<20`830o`3o01/0
001:00<O8`000on0P009P003oh2000f00_oo01`0001:00<O90006on0`830P<20`830ol20`830P<20
`830P<20o`3o01h0001b0003oh2000N000?oP8002X02ool07`00078001Oo`830P<20`830ol20`830
P<20`830o`3o0240001c0003oh2000J000?oP8001h02ool08P0005T00alH000Bol20`830P?n0`830
P<20`83oo`0T0000F@037aT000?oP8000h000on0P005P0;oo`0U0000F@037aT000koP<20`83oP<20
`830ool09`0007H000?oP8000X000on0P003P003o`000?l09P0006T00al;0008oh30P?n0`802ool0
:@0006T00al;0005oh20P?l00X000ol0003o02T0001Y00<O30001?o0ol02ool0;00007T00aoo02h0
001i00<Oo`0^0000N@037ol0;P000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]000ol0000f00;@>@02d3T00]0i00;@<P0001D0
00?@0000=@001=000=0g0005d<3od?l0=P001=000=0g0004d000d3L000C@003@=`000m00000b0000
5P02d3@000?@00000P02d3@000G@P83oP002d3@000?@00000P02d3@000?@00000P02d3@000?@0000
0P02d3@000?@0000<`0001P000?@0000<0000m0000050003d000030000W@`830ol20`=00<P000m00
00050003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00
000]00;@2@000m00000]00;@18000on0P002P003d00002d00]090003d00002d00]090003d00002d0
0]090003d00002h000?@0000=@0001X000?@0000:`000m00000:0003d00002/000k@ol20`830ol20
`830d2d000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]000on0P004P003oh2000B00m0X00;@3P03d2P00]0>00?@:002d0h0
0m0Y00;@>@0001d00]0U00;@4P02d2H001G@0?o0P<20`830ol20`830P<3o0=009P000m00000A0003
d00002@000?@00004@000m00000T0003d000014000?@00009002d3/0000O0003d000024000?@0000
50000m00000R0003d03o00R000?oP8001X000ol0d00T0003d00001<000?@00008P000m00000C0003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@01L0ol20`830P<20
`?o0P<20`830P<3o0002d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@
6P03d08000?oP80028000on0P008P003o`0000?@6P03d1/00m0J00?@7002d1X00m0L00;@6P03d400
000U00;@5@03d2400]0F00;@10006Oo0P<20`830P<20`?o0P<20`830P<20`?l01002d1H00]0Q00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]050003oh2000Z000?oP800
2X000ol0000300G@2`06d2H01=0;00K@9P04d0/01]0V00G@2P06d4D0000?00<O6P0;d3002m0:000M
ol20`830P<20`830P<3o`830P<20`830P<20`?l02@0;d3002m0`00_@<@0:d4/0000?00<OJ@000on0
P00<P003oh2000b000?o0000o`0>0000N@02o`0P`830P<20`830P<20`830ol20`830P<20`830P<20
`?oo00l0001h0003oh2000n000?oP8003X000ol0003o00`0001g000Voh30P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`?oo00d0001f0003oh20016000?oP80048000ol0003o00X0001e000Z
oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3oo`0;00003`037f8000?oP800
4h000on0P00BP003o`000?l0200000l00amQ000^oh30P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830ool02@0000l00amP0003oh2001F000?oP8005802ool01`00074003?oP<20
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P?l0o`060000L0000on0
P00GP003oh2001N000?o0000o`030000K`00=on0`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P?l0o`040000KP000on0P00IP003oh2001V000?o0000o`010000
K@00>on0`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`83o0?l00P0001800amG0003oh2001^000?oP8006h000ol0003n00004P037eH003ooP<20`830P<20
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P?l0o`000180
0amD00;o7h000on0P00MP003o`000?`0001X0014ol20`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P?om0000I`000on0P00PP003oh2001n0
00?o0000nP0006H004So`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?ok0000I@000on0P00RP003oh20026000?o0000n00006@0
04co`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83on@0006<000?oP80098000on0P00SP003o`000?H0000G00<OB000D?o0
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83om`0001L00am70003oh2002J000?oP8009H000ol0003d00005`037dH0
05Co`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?oe0000G`000on0P00XP003oh2002N000?o0000lP0005h0
05So`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`83ol`0005d000?oP800:X000on0P00YP003o`000?00
001L001Lol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?oa0000F`000on0P00/P003oh2002^0
00?o0000kP0000807?l37oooI_lS00007P037c/000?oP800:X03ob^000?o0000k`0001h00all000/
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803o`0[P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830o`3b0000GP000on0P00YP003oh2002R000?o0000
l@0005l005KoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830oo@0001P0003oh2002N000?oP8009X000ol0
003c0000H@00D_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?of00009P037cT000?oP8009H000on0P00TP003
o`000?D0000V00<O>P00C_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830ooP0000V00<O>`000on0P00SP003oh2002:0
00?o0000m`0006D004[oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830ooX0001V0003oh20026000?oP80088000ol0003i0000
I`00A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`?ol0000J0000on0P00OP003oh2001j000?o0000n`0006T004;oP<20`830P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`?on0000
JP000on0P00MP003oh2001b000?o0000o@0003000alh000noh30P<20`830P<20`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`?oo0040000`00<O>@000on0P00KP003
oh2001Z000?o0000o`0003000alj000joh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830P<20`830ool00`0006h000?oP8006H000on0P00HP003o`000?l00P0006l0
03KoP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`?oo00D0
001`0003oh2001N000?oP8005X000ol0003o00@0001a000boh30P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`?oo00L0001b00;o5X000on0P00DP003o`000?l01P0003`0
0ale000]ol20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o0?l02@0003`0
0alf0003oh2001:000?oP8004X000ol0003o00P0000l00<O=`00:Oo0P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<3o0?l02`0007L000?oP80048000on0P00@P003o`000?l02P0007P0
02Go`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<3o0?l03@0007T000?oP8003X000on0
P00>P003o`000?l0300007X0027o`830P<20`830P<20`830ol20`830P<20`830P<20`?l0o`0?0000
N`000on0P00<P003oh2000b000?o0000o`0>0000BP037bl001go`830P<20`830P<20`?o0P<20`830
P<20`830o`3o0140001:00<O<0000on0P00:P003oh2000Z000?o0000o`0@0000BP037c4001Wo`830
P<20`830P<3o`830P<20`830P<3o0?l04`0007l000?oP80028000on0P008P003o`000?l04P000800
01Go`830P<20`830ol20`830P<20`?l0o`0E0000P@000on0P006P003oh2000J000?o0000o`0D0000
F@037bH0017o`830P<20`?o0P<20`830o`3o01L0001I00<O9`000on0P004P003oh2000B000?o0000
o`0F0000F@037bP000go`830P<3o`830P<3o0?l06@0008D000?oP8000X000on0P002P003o`000?l0
600006T00alJ0009ol20`?o0P<3o0?l06`0006T00alK0004oh20o`:000?o0000o`0J0000J@037a`0
00Go`?o0o`3o01d0001i00<O3@037ol07P0007T00al=00<Oo`0N0000N@037`d00aoo01h0003o0:X0
003o0:X00000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d?n0d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d?oo00:00]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0009d?n0oh30P<3@038000?@00001@000m00
000`0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0T0
00?@0000;@02d005oh20P?l018000m3o000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00
000^0003d00003D0000J0003d00002/000?@00002P000m00000[000?d000ol20`?o0P<20`=3o02`0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@3P02d2T00]020003oh2000:000?oP8001803d2P00]0>00?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]0B00;@9P005M00003o`830P<3o`830P<20`83od00V0003d000014000?@0000
90000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000G@0000o`06P003oh2000R000?@00008P000m00000C0003d000028000?@00004`000m00
000R0003d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d0@001?oP<20`830P?n0
`830P<20`83000;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@6P02d1`00m0J00?@
1@000on0P006P003oh2000Z00m0J00?@6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@
8@02d1H00]07000Hoh30P<20`830P?n0`830P<20`830P<200_l2d1H00]0Q00?@5@02d2400m0E00;@
8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]090003oh2000N000?oP8003H000ol0d004d0/0
1]0V00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@3P007?o0P<20`830P<20oh30
P<20`830P<20`830P<02o`@02m0`00_@<00;d3402]1;00003`037fd000?oP8002H000on0P00@P003
o`000?l02@0007h002;o`830P<20`830P<20`?o0P<20`830P<20`830P<20`83oo`0:0000OP000on0
P00;P003oh2001600_oo00P0001m000Voh30P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`?oo00L0001l0003oh2000f000?oP8005802ool01@0007/002_oP<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`83o0?l0100000l00amY0003oh2000j000?oP8005h02ool00P0000l0
0amX000_ol20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`?l0o`010000
3`037fL000?oP8004H000on0P00IP0;ooP0007P003Co`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`83oo@0007P000?oP8004X000on0P00LP003o`000?X0001g000f
oh30P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<200_oj0000
MP000on0P00EP003oh2001j000?o0000m`0007D003_oP<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`002ooL0000B00<OH0000on0P00FP003oh200260
00?o0000m00001800amO000ool20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<2000;om00001800amN0003oh2001R000?oP80098000ol0003a0000
L`00@on0`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<000_oa0000LP000on0P00JP003oh2002J000?o0000kP00074004WoP<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83o0>l0001`0003oh2001b000?oP800:802ond0001`001=ol20`830P<20`830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0k00006l0
00?oP8007H000on0P00[P0;ojP0001L00amD001Bol20`830P<20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20onT0000G00<O
D`000on0P00PP003oh2002Z01?oX00005`037e<004WoP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000Oo00C0P<3oj00006`0
00?oP8008H000on0P00LP0Oo2H000ol0003W0000J`00?On0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<001ol04<20`830P<20`830P<20`?oZ0000
JP000on0P00SP003oh2000n01_lEP003o`000>T0001Z000aol20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P007o`0LP<20`830P<20`830P<20`830P<20`830P<20on/0
001Y0003oh2002F000?oP8001olQP003o`000>X0000201co0aooofKo8`0001h00am70003oh2001f0
1_l2P0?o9h000ol0003/00007P037dH001_oP<20`830P<20`830P<20`830P<20`830P<001_l02830
P<20`8300ol0:<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o^0000IP000on0
P00CP0Ko3h000on0P00UP003o`000>d0001U000Boh30P<20`830P<20`830P<201Ol0?H30P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0l00006D0
00?oP8002H06oa^000?oP8008h000ol0003^0000I0001oo0P<20`8001_l0Al20`830P<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o0?40
000V00<O>P000on0o`05obN000?oP8008H000ol0003`00009P037cT00ol0DL20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20o`3c00009P037c/000?oP800:h000on0P00PP003o`000?40001U00;o04k0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`?od0000I`000on0P00YP003oh2001f000?o0000l`0006P00_l0BH30P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`?l0
mP0006X000?oP8009X000on0P00LP003o`000?@0001[0017oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P?l0m`0006`00_lVP003
oh2001V000?o0000mP0003000alk0012ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`83on@0003000all00;o8h000on0P00HP003o`000?L0
000`00<O?P00?_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<3onP0007800_lPP003oh2001J000?o0000n@0007@003Wo`830P<20`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`?l0o00007D00_lNP003oh2001B0
00?o0000nP0007L003GoP<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`830P<20o`3m0000N0000on0P00JP003oh2001:000?o0000o00003`00alj00;o0330P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?on0000?0037c`000?oP8005h000on0
P00AP003o`000?d0000l00<O?@02o`0[P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830o`3o0040001n0003oh2001F000?oP8003X000ol0003o0000O`02o`0W`830P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`83o0?l00P00084000?oP8004X000on0P00=P003o`000?l0
0@0008800_l08X30P<20`830P<20`830P<20`?o0P<20`830P<20`830P?oo00@000240003oh2000n0
00?oP8002h000ol0003o00<0001:00<O>0008?n0`830P<20`830P<20`830ol20`830P<20`830P<3o
o`050000BP037cT00_l?P003oh2000V000?o0000o`040000BP037c/001_o`830P<20`830P<20`83o
P<20`830P<20`?l0o`070000R@02o`b000?oP8001h000ol0003o00H0002;000Goh30P<20`830P<20
oh30P<20`830P?l0o`080000S002o`V000?oP8001X000ol0003o00L0001I00<O<P004_o0P<20`830
P<3o`830P<20ool02P0005T00alc00;o1h000on0P004P003o`000?l0200005T00ale000>oh30P<20
`?o0P<20`?oo00/0002B0003oh2000>000?oP8000X000ol0003o00X0001Y00<O9`02o`08`830ol20
`?oo00d0001Y00<O:@001?n0P?l3P003o`000?l02`0006T00alZ00;o00B0oh3oo`0>0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000



\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d?oo00800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0004d03o`0;o0P000m00000`0003d00000D0
00?@0000<0000m0000050003d000030000?@00001@000m00000`0003d00003@0000I0003d00002d0
0]090003d00002d00]00103oP?l2P0?o00?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T0
00?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`003]00003oP?n0`830P?o@
;@000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]0>00;@:@02d0<000CoP83o1h03d2P00]0>00?@:002d0h00m0X00;@3P03d2T00]0i0000
7@02d2D00]0B00;@9P000m000003000?ol20`?o0P<20`830P?o@02H000?@00004@000m00000T0003
d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@000?@0000
8P000m0000030003oh2000:000?oP80028000m3oo`0R0003d00001<000?@00008P000m00000C0003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@1P004On0`830ol20
`830P<20`83000;@0_lN00;@5`02d2000]0G00?@7`02d1L00m0O00;@?P0002800m0J00;@7003d1X0
0m070003oh2000B000?oP8002X03d003o`0001L00m0K00?@6P03d1`00]0J00?@7002d1X00m100000
9@02d1D00m0Q00;@5P02d0X001Oo`830P<20oh30P<20`830P<20`830P002d003o`0001<00]0Q00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0;0003oh2000J000?oP800
3X05d0/01]0V00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@4@007on0`830P<20
`?o0P<20`830P<20`830P<20`830P?l02m0`00_@<00;d3402]1;00003`037g4000?oP8001X000on0
P00DP0;oo`050000PP008oo0P<20`830P<20oh30P<20`830P<20`830P<20`830P<2000?oo`020000
PP000on0P008P003oh2001R00_oo0000P@00:On0`830P<20`830P?n0`830P<20`830P<20`830P<20
`830P<20`83000;oo@00084000?oP8002X000on0P00KP0;on`00080002ko`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`830P<20`8300ooh00003`037fh000?oP80038000on0P00OP0;o
mP0000l00am]000doh30P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P0;om00000l00am]0003oh2000f000?oP8008h02oo80001n000iol20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000?ok`0007h000?oP8003h000on0
P00WP0;ok@0007d003ooP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<000_o[0000O@000on0P00AP003oh2002Z00_oY0000O000A?o0P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
0ooV00004P037fL000?oP8004X000on0P00_P0;oi00001800amV0019oh30P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`002on<0
000B00<OIP000on0P00DP003oh2002b00ol00h3o003R0000NP00A?o0P<20`830P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300ol01<20`?oT0000
NP000on0P00FP003oh2002F00ol6P003o`000>80001j000nol20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<03o`09`830P<20`83o0>D0001i0003
oh2001R000?oP8007h02o`^000?o0000h`0007T003[oP<20`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830P<200ol03H30P<20`830P<20`?l0iP0007P000?oP800
6H000on0P00IP0?o3h000ol0003T00005`037eh003Go`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P003o`0BP<20`830P<20`830P<20`83oi`0001L00amM0003
oh2001^000?oP8004X03oaB000?o0000i@0001L00amM000`oh30P<20`830P<20`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<200ol05h30P<20`830P<20`830P<20`830P<3o0>P0001f0003
oh2001f000?oP8003802oaV000?o0000iP0007H002co`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`0?o01c0P<20`830P<20`830P<20`830P<20`830P<3oj00007D000?oP800
7h000on0P005P0?o7H000ol0003W0000M@009on0`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<20`003o`0Q`830P<20`830P<20`830P<20`830P<20`830P<20`83o0>T0001d0003oh200220
00?oP?l00_lRP003o`000>P0000201co0aooofKo8`0001h00amB0003oh2001j01_lSP003o`000>T0
000N00<ODP007_n0`830P<20`830P<20`830P<20`830P<20`830P0?o00>0`8000ol09830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20on/0001b0003oh2001V00ol8P003oh20022000?o0000
jP00078001[o`830P<20`830P<20`830P<20`830P<20`0;o02n0`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<20`830o`3/0000L@000on0P00EP0?o3X000on0P00NP003o`000>/0
001a000Eoh30P<20`830P<20`830P<20`83000?o03?0P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0k@0002H00am80003oh2000n00olEP003oh2001b000?o0000
k00002H00am7000Aol20`830P<20`830P<20`8000_l0><20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`830P<3okP0002H00am70003oh2000^00olJP003oh2001^0
00?o0000k@0006l000coP<20`830P<20`803o`0lP<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`83ok`0006l000?oP8001X03ob6000?oP8006H000ol0
003^0000KP002?o0P<20`8300_l0@H30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<3o0?00001^0003oh2000:00olWP003oh2001N000?o0000
k`0006d000?oP<000ol0AL20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20o`3a0000K@03obj000?oP8005X000ol0003_0000<0037cT0
0_l0BH30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`?l0lP0003000alk00;o;h000on0P00DP003o`000?00000`00<O?@03o`13
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`830P<20o`3c0000L`02obZ000?oP8004h000ol0003a0000M@02o`0n`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`?od0000M`02obN000?oP800
4H000ol0003b0000N@03o`0hP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P?oe0000O002ob>000?oP8003h000ol0003c0000?0037cl00_l0<h30P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830o`3f0000?0037d400_lPP003
oh2000f000?o0000m00003`00am300?o02g0P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P?l0m`0008D00_lKP003oh2000b000?o0000m@0008L00_l0:<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`?oh0000R@03oaN000?oP8002X000ol0003f0000S002o`0R
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20ooT0002>00;o58000on0P008P003o`000?L0
001:00<O@`02o`0MP<20`830P<20`830P<20`830ol20`830P<20`?l0nP0004X00am500?o48000on0
P006P003o`000?P0001:00<OB002o`0H`830P<20`830P<20`83oP<20`830P<3onP0009L00_l=P003
oh2000B000?o0000n@0009T00_l04l20`830P<20`830ol20`830P?l0n`0009/00ol8P003oh2000>0
00?o0000nP0005T00am200;o00f0`830P<20oh30P<3o0?`0001I00<OA002o`F000GoP820o`3m0000
F@037dH00_l02830P<3o`83oo@000:@00ol0183oP?on0000J@037c/000Co7alOoP0006T00all00<O
oP0006T00all00<OoP0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`0007T00al=00<O
30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
0`03o`/000?@000090000m00000A0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@000050000m00000R0003d00000@000?oP8001Ol70003d0000280
00?@00004`000m00000R0003d00001<000?@00008P000m00000C0003d000028000?@0000>`000200
0]0O00;@6002d2000]0700;o00J0`830P<05o`<00]0P00;@5`02d2000]0G00?@7`02d1L00m0O00;@
?P0002800m0J00;@7003d1X00m080004oh20o`Z01Ol3d1X00m0K00?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d0/001?oP<3o`830P<20`830P<20`83000?o0]0F00;@8@03d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@3@001On0P83o01:000?od=00
0m0;00K@9P04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d1<001goP<20`?o0P<20
`830P<20`830P<20`830P<20o`0;d3002m0`00_@<@0:d4/0000?00<OL`000on0P002P003oh2001V0
1?oo0000Q0009_o0P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`8301Ooj0000Q0000on0
P005P003oh2002201Ooe0000Q000<?o0P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`0Gol00008@000?oP8001X000on0P00YP0Cok00008<003[oP<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<201OoW00003`037g4000?oP800
2H000on0P00`P0GohP0000l00ama0014oh30P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`802on00000?00<OL@000on0P00:P003oh2003:0
0_l00h3o003O0000P`00A_n0`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830ol20`?oP0000PP000on0P00<P003oh2002j00_l3P003o`000=l0
0022000nol20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<02o`06P<20`83oh@00088000?oP8003X000on0P00YP003oh2000F000?o0000g`000880
03_o`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P002o`09`830P<20`83o0>40000B00<OK0000on0P00@P003oh2002B00_l9P003o`000>00000B00<O
K000A_n0`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`?oR00004P037f`000?oP8004H000on0P00PP0;o38000ol0003P0000P@00=On0
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`83000;o00n0`830
P<20`830P<20`?l0hP00084000?oP8004h000on0P00KP003oh2000f000?o0000h@00080003?o`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`8000_l04L20`830P<20
`830P<20`83o0><000200003oh2001F000?oP8005X02oa:000?o0000h@00080004Ko`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83o
h`00080000?oP8005h000on0P00AP0;o5H000ol0003Q00005`037fD002goP<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<000_l05h30P<20`830P<20`830P<20`830P<3o0>@0
000G00<OI@000on0P00IP003oh2000f000?oP8005X000ol0003R00005`037fD002[oP<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`802o`0J`830P<20`830P<20`830P<20`830P<20
`?oT0000O`000on0P00JP003oh2000R00_lKP003o`000>80001o0015oh30P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830ol20`830P<20`830P<20`830P<20`830P<20`83o0>D0001n0003
oh2001f000?oP8000h02oaf000?o0000h`0007h002Co`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<02o`0PP<20`830P<20`830P<20`830P<20`830P<20`830P?oU0000OP000on0P00NP003
oh3o026000?o0000h`0000807?l37oooI_lS00007P037e`000?oP8007X04ob2000?o0000i00001h0
0amL000Ooh30P<20`830P<20`830P<20`830P<20`830P<20`002o`0UP?oooh30P<20`830P<20`830
P<20`830P<20`830P<20`830o`3V0000O@000on0P00JP0;o1X000on0P00MP003o`000>@0001m0015
oh30P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`83o0>L0001m0003oh2001N00_l:P003oh2001^000?o0000i@0007`004Ko`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`83o
i`0002H00amC0003oh2001F00_l>P003oh2001Z000?o0000i@0002H00amC000Fol20`830P<20`830
P<20`830P<20`0;o02f0`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`?l0
j00002H00amC0003oh2001:000?oP8004H000on0P00HP003o`000>H0001k000Doh30P<20`830P<20
`830P<20`802o`0``830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<3o
j00007/000?oP80048000on0P00FP003oh2001J000?o0000iP0007/0017oP<20`830P<20`830P<20
`002o`0cP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<3o0>P0
001k0003oh2000b00_lLP003oh2001B000?o0000i`0007/004GoP<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0j@0007X000?oP800
2X02ob2000?oP8004h000ol0003W0000<0037dL004Ko`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83oj@0003000am70003oh2000N0
0_lUP003oh20012000?o0000j00003000am70008ol20`830P<02o`0kP<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`?l0jP0007T000?oP8001H000on0
P00XP003oh2000n000?o0000j00007T000KoP<20`802o`0n`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`?oZ0000N@000on0P002P003oh2002b0
00?oP8003H000ol0003Y0000N@000on0`002o`10P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830ol20`830P<20`830P<20on/0001i00?o<X000on0P00<P003o`000>T0
000l00<O>@02o`14P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`83oP<20`830P<20`830P?o[0000?0037cT00oleP003oh2000V000?o0000jP0003`00all00Go
03f0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<3o0>`0002000Go;8000on0P008P003o`000>X0002500Co03C0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<3ok00008T01OlTP003oh2000J000?o0000j`0008h0
1Ol0:L20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`83o0>d0002C00Co7H000on0
P004P003o`000>/0001:00<OBP05o`0PP<20`830P<20`830P<20`830P<20`830ol20`830P?o]0000
BP037dl01?lEP003oh2000>000?o0000j`0004X00amC00Go01K0P<20`830P<20`830P<20oh30P<3o
kP000:D01Ol<P005oh20P?l0kP000:X01?l03H30P<20`830P?n0`?l0kP000:h01Ol4P004oh20onh0
001I00<OE`05o`<OkP0005T00amL00<OkP0005T00amL00<OkP000?l0ZP0006T00all00<OoP0006T0
0all00<OoP0006T00all00<OoP0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`0007T0
0al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@
>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@
6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0V00C@
2`06d2H01M0:00K@A@0000l00alJ00_@<00;d1@07?l;d1go4`0;d3002m0a00[@B`0000l00amd0003
oh3o03j000?oP?l0g`0008H004Co`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20oml000260005oh20P?l0>X001On0P83o0=l000260014
ol20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P?oO0000QP000on0P003P003oh2003B000?oP8000h000ol0003M0000QP00A?o0P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`83o
g`0000l00amd0003oh2000F000?oP800<8000on0P005P003o`000=d0000?00<OM000A?o0P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83o
g`0000l00amd0003oh2000N000?oP800;8000on0P007P003o`000=d000260014ol20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P?oO0000
QP000on0P009P003oh2002R000?oP8002H000ol0003M0000QP00A?o0P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83og`0008H000?oP800
2h000on0P00TP003oh2000^000?o0000g@0008H004Co`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20oml0000B00<OL@000on0P00=P003
oh20022000?oP8003H000ol0003M00004P037g40037o`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<2000;o0170P<20`830P<20`830P<20o`3O00004P037g4000?oP800
3h000on0P00KP003oh20012000?o0000g@0008H004Co`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20oml000260003oh20016000?oP800
5h000on0P00BP003o`000=d000260014ol20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P?oO0000QP000on0P00CP003oh2001>000?oP800
58000ol0003M0000QP00A?o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`83og`0008H000?oP8005H000on0P00?P003oh2001J000?o0000
g@0001L00am/0014ol20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P?oO00005`037f`000?oP8005h000on0P00;P003oh2001R000?o0000
g@0001L00am/0014ol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P?oO0000QP000on0P00IP003oh2000N000?oP8006X000ol0003M0000
QP00A?o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`83og`0008H000?oP8006h000on0P003P003oh2001b000?o0000g@0008H004Co`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P?n0`830P<20`830P<20`830P<20`830P<20`830
P<20oml000260003oh2001f000?oP?l088000ol0003M00000P0Lo`<OoomVob<0000N00<OI@000on0
P00MP0Co7h000ol0003M00007P037fD001oo`830P<20`830P<20`830P<20`830P<20`830P<2000Co
0270ol20`830P<20`830P<20`830P<20`830P<20`830P?l0g`0008H000?oP8006h000on0P004P003
oh2001^000?o0000g@0008H004Co`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0
P<20`830P<20`830P<20`830P<20`830P<20oml000260003oh2001V000?oP80028000on0P00IP003
o`000=d000260014ol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P?oO00009P037ed000?oP8005h000on0P00<P003oh2001N000?o0000
g@0002H00amM0014ol20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P?oO00009P037ed000?oP8005H000on0P00@P003oh2001F000?o0000
g@0008H004Co`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20oml000260003oh2001>000?oP80058000on0P00CP003o`000=d000260014
ol20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P?oO0000QP000on0P00AP003oh2001R000?oP8004H000ol0003M0000QP00A?o0P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`83o
g`0008H000?oP8003h000on0P00LP003oh2000n000?o0000g@0003000amC0014ol20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P?oO0000
<0037e<000?oP8003H000on0P00PP003oh2000f000?o0000g@0003000amC0014ol20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P?oO0000
QP000on0P00;P003oh2002B000?oP8002h000ol0003M0000QP00A?o0P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83og`0008H000?oP800
2H000on0P00XP003oh2000V000?o0000g@0008H004Co`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20oml000260003oh2000N000?oP800
;8000on0P007P003o`000=d0000l00<OA`00A?o0P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83og`0003`00am70003oh2000F000?oP800
<8000on0P005P003o`000=d0000l00<OA`00A?o0P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`83og`0008H000?oP8000h000on0P00dP003
oh2000>000?o0000g@0008H004Co`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20oml000260005oh20P?l0>X001On0P83o0=l000260014
ol20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`?o0P?oO0000QP000on0o`0nP003oh3o0=l0001:00<O>@02o`10P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0<OgP0004X00ali04;o
0aoN0000BP037g/00aoN0000o`2Z0000o`2Z0000o`2Z0000F@037e`00ao^0000F@037e`00ao^0000
F@037e`00ao^0000o`2Z0000J@037c`00aon0000J@037c`00aon0000J@037c`00aon0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000



\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d00000P00ol60003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m00000400Go
0X000ol000050003d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000k0000
8002d1l00]0H00;@8002d1L00]0P00;@0P05o`06`830P<200_l800;@8002d1L00m0O00;@5`03d1l0
0]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@1?l:P004oh20o`T00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d2400]0F00;@8@02d1H00]03o`0BP<20`830P<20`830P<3o`83o3003d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0BP005oh20P?l0
3`04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d3002m007On0`830P<20`830P<20
`830P<20`830ol20`83o01<02m0`00_@<@0:d4/0000?00<OT`05oaZ000?oP8000h000ol0003L0000
X@04o`0V`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`?oN0000W005ob6000?oP800
1H000ol0003L0000U`05o`0_P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830
P<20`?l0gP0009<01?lZP003oh2000N000?o0000f`0008h01Ol0>L20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20o`3M00003`037gL01OlbP003oh2000R0
00?o0000f`0000l00ame00;o04?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`83o0=d0000?00<OM@001?n0oolcP003oh2000Z000?o0000
f`0008L004KoP<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<3og00008P000CoP8200_l_P003oh2000b000?o0000fP0008P000Ko`830
P<02o`0mP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830o`3L0000R0000on0P005P003oh2002V000?oP8003H000ol0003J0000R0002Oo0P<20`830
P002o`0k`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P?l0f`0001800amc0003oh2000R00_lVP003oh2000n000?o0000f@0001800amd0015oh30P<20
`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`83o0=/0000B00<OM0000on0P00:P0;o8H000on0P00AP003o`000=T00029000?oh30P<20`830P<20
`83000;o03F0`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
o`3J0000R@000on0P00>P003oh2001^000?oP8004h000ol0003H0000RP004Oo0P<20`830P<20`830
P<2000;o03;0P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830omX0
002:0003oh2001200_lHP003oh2001B000?o0000f00008X004Ko`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`83of@0008X000?oP800
4h02oa>000?oP8005h000ol0003G00005`037g0001So`830P<20`830P<20`830P<20`830P<02o`0/
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P?oI00005`037g4000?oP800
5X000on0P00=P003oh2001R000?o0000e`0001L00ama000Joh30P<20`830P<20`830P<20`830P<20
`802o`0Z`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3of00008/000?oP800
6H02o`Z000?oP8006X000ol0003F0000R`00A_n0`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`?oH0000S0000on0P00KP0;o1H000on0
P00LP003o`000=H0002<000Pol20`830P<20`830P<20`830P<20`830P<20`830P<02o`0SP<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`?l0f00008`000?oP8007h000on0o`0PP003o`000=D0
000201co0aooofKo8`0001h00am[0003oh2001j00ol00h3oP00NP003o`000=D0000N00<OK0008?n0
`830P<20`830P<20`830P<20`830P<20`830P<200ol08X30oon0`830P<20`830P<20`830P<20`830
P<20`830P?oG0000S@000on0P00MP003oh2000B00_lLP003o`000=@0002=0016oh30P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830omH0
002=0003oh2001b000?oP8002802oaV000?o0000e00008h004Go`830P<20`830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`?l0eP0002H00amU0003
oh2001Z000?oP8003802oaN000?o0000d`0002H00amU000^ol20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`0;o01J0`830P<20`830P<20`830P<20`83oe@0002H00amU0003
oh2001R000?oP8004X000on0P00BP003o`000=<0002>000aol20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P002o`0C`830P<20`830P<20`830P<20o`3E0000S`000on0
P00FP003oh2001J000?oP80048000ol0003B0000S`00<on0`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`002o`0AP<20`830P<20`830P<20`?l0e00008l000?oP800
5H000on0P00JP0;o3X000ol0003B0000S`00A_n0`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`?oD0000T0000on0P00BP003oh2001n0
0_l<P003o`000=40000`00<OG@00A_o0P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P?oC0000<0037ed000?oP8004H000on0P00SP0;o
2H000ol0003A0000<0037ed003co`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<02o`08P<20`830P?oC0000T0000on0P00@P003oh2002R000?oP800
18000ol0003A0000T@00?_n0`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<200_l01/20`830om80002A0003oh2000f000?oP800;H000on0P002P003
o`000=00002A0011oh30P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<000_l00h30o`3B0000T@000on0P00<P003oh2003600ooB0000?0037e<0
04?o`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<2000<Od@0003`00amC0003oh2000Z000?oP800<h037m40000l00<OD`00?_o0P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8301Ol37m40
002B0003oh2000R000?oP800:h05omT0002B000dol20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`0GogP0009<000?oP8001X000on0P00SP0Coh`0009<002[oP<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`805onL0002C0003oh2000F000?oP800
6X05on`0001:00<OAP008On0`830P<3o`830P<20`830P<20`830P<20`830P<20`004oa000aoN0000
BP037dL000?oP8000X000on0P00CP0Go50037mh0001:00<OA`005_o0P<20oh30P<20`830P<20`830
P<05oaT00aoN0000U0001On0P83o00b01Ooo0000U0003Oo0P?n0`830P<20`8001?oo00D0002D0004
oh20o`B01Ooo00T0001I00<O>@07oa`00ao^0000F@037cT00_lQ00<OkP0005T00amL00<OkP000?l0
ZP0006T00all00<OoP0006T00all00<OoP0006T00all00<OoP0007T00al=00<O30037ol03`0007T0
0al=00<O30037ol03`0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0005d0000?l00]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m000002o`04
P?l0d38000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@0ol2P005oh3o0=00;`02d0T000?@0000;@02d0T000?@0000
;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/000_@ooo0
P<20`?o0o`020003d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]0>00;@:@02d0h00m0X00;@00?oP8001H001?n0P?l200?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@000o@ol20`830P<20oh30P?l01@000m00
000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008P000m00000C0003d00002000_l00m20P008P003oh2000:000?o00000`000m00000R0003
d00001<000?@00008P000m00000C0003d000028000?@0000>`0002000]0O00;@6002d2000]0G00;@
7P02o`;@0160`830P<20`830ol20`830o`0600;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X0
0]0L00?@6P03d1/00m0I0004om3@d0b000?oP8000h000ol0000600?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d2400]0E000Jom3@`830P<20`830P<20`830ol20`830P?l:00?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d12000?oP800
1H000ol0000;00C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@<00;d0;o01k0P<20
`830P<20`830P<20`830P?n0`830P<20`?l@00_@<00;d3402]1;00003`037iT00_lEP003oh2000N0
00?o0000fP000:P00ol08l20`830P<20`830P<20`830P<20`830ol20`830P<20`83o0=/0002V00;o
6X000on0P008P003o`000=T0002T00;o02V0`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830o`3J0000XP02oaf000?oP8002X000ol0003H0000W`03o`0^P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20omT0000?00<OR`02ob6000?oP80038000ol0003G0000
3`037hT00_l0<l20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
o`3I00003`037hL00_lTP003oh2000j000?o0000eP0009H00ol0><20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<3of00009@00_lXP003oh20012000?o0000
e@0009800_l0?X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`83oe`0009000_l/P003oh20016000?o0000e00008d00ol0@h30P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?l0eP000180
0amf00;o<8000on0P00CP003o`000=<0000B00<OM@02o`18P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`83oe@0001800ame0003
oh3o00;o;H000on0P00EP003o`000=80002;0004oh30P0?o04>0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<3o0=@0002;0003oh2000B0
0olVP003oh2001N000?o0000d@0008`000Wo`830P<20`8000_l0?l20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20o`3C0000S0000on0P008P0?o
8H000on0P00GP003o`000=40002=000=oh30P<20`830P<20`003o`0j`830P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830om80002=0003oh2000f00olJP003
oh2001V000?o0000d00001L00amc000Coh30P<20`830P<20`830P<20`002o`0fP<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83od@0001L00amd0003oh200160
0olDP003oh2001^000?o0000c`0001L00amd000Gol20`830P<20`830P<20`830P<20`8000ol0<H30
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`?l0d00008l000?oP800
5X03o`f000?oP8007H000ol0003>0000S`007?n0`830P<20`830P<20`830P<20`830P<20`802o`0]
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`83o0<l0002@0003oh2001Z0
0ol7P003oh2001n000?o0000c@000900023o`830P<20`830P<20`830P<20`830P<20`830P<20`0?o
02S0P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<3ocP00094000?oP8007h03o`03
P?n0026000?o0000c00000807?l37oooI_lS00007P037g4000?oP8008806ob2000?o0000b`0001h0
0ama000Sol20`830P<20`830P<20`830P<20`830P<20`830P<20`8000ol00h30P003o`0NP<20`830
P<20`830P<20`830P<20`830P<20`83oc@00098000?oP80088000on0P006P0?o6h000ol0003:0000
T`00;_n0`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`802o`0J`830P<20
`830P<20`830P<20`830P<20`?o<0000T`000on0P00NP003oh2000b00olGP003o`000<T0002D000b
ol20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<03o`0E`830P<20
`830P<20`830P<20`83o0</0000V00<OJ`000on0P00LP003oh2001>00olBP003o`000<P0000V00<O
K000=on0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<00
0_l04H30P<20`830P<20`830P<3o0<X0000V00<OK0000on0P00KP003oh2001R00ol>P003o`000<L0
002F000kol20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`8000ol03830P<20`830P<20olT0002F0003oh2001V000?oP8007h03o`R000?o0000a`0009L0
043oP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<200_l02<20`830P<3ob00009L000?oP8005h000on0P00UP0?o18000ol000360000V000A?o0
P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`8300ol00l20o`370000V0000on0P00EP003oh2002b00oo70000<0037fD004Wo`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<2000<Oa@0003000amV0003oh2001>000?oP800;H02o`<Oa@0003000amV0013oh30P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003o`80
0ao50000VP000on0P00BP003oh2002R00_o=0000VP00?_o0P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300_o?0000V`000on0P00@P003oh2002F0
0_oA0000V`00>?n0`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<200ooC0000W0000on0P00>P003oh2002600_oF0000?0037ed003?o`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`8000_l400<Od@0003`00amN0003oh2000b0
00?oP8007X02o`H00aoA0000?0037eh002goP<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830P<000ol800<Od@0009d000?oP80038000on0P00IP0;og`0009h002So`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`8300_oQ0000WP000on0P00:P003oh2001F00ooS0000
W`008_n0`830P<20`830ol20`830P<20`830P<20`830P<20`802onH0002O0003oh2000R000?oP800
4X02onP0001:00<OD`007Oo0P<20`830P<3o`830P<20`830P<20`830P<2000;o2@037mh0001:00<O
D`000on0P006P003oh2000j00ol;00<OgP0004X00amD000Goh30P<20`83oP<20`830P<20`830P<00
0_l>00<OgP000:4000?oP80018000on0P00;P0;ol@000:8001;o`830P<3o`830P<20`830P<02oo<0
002R0003oh2000>000?oP8001X03ooD0001I00<OAP003Oo0P<20oh30P<20`8000_l700<OkP0005T0
0am70005oh20P?l01H02o`T00ao^0000F@037dL000SoP<3o`830P0;o2`037nh0002T0004oh3oP0?o
oP0006T00alh0004ol3oo`<OoP0006T00ali0003o`0000<OoP0006T00all00<OoP0007T00al=00<O
30037ol03`0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001



\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@P?o@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0c0004om20P0;o0]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000;`002_o@P<20oh3o
0=0b0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0T0
00?@0000;@02d0T000?@0000;@02d0>000OoP820o`3@02l00]090003d00002d00]090003d00002h0
00?@0000=@0001X000?@0000:`000m00000:0003d00002/000?@00002P000m00000Z000<om30P<20
`?o0P<3o0P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@3P02d2T00]0>00?@:002d0J000?oP8000X000ol00003d2P00]0>00?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000S000Aom20`830P<20`?o0P<20`?l010000m00
000T0003d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008P000m00000C0003d000024000?od80028000on0P004P003o`00008000?@00008P000m00
000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d1l0
01God=20`830P<20`83oP<20`830P?l01@02d2000]0G00?@7`02d1L00m0O00;@?P0002800m0J00;@
7003d1X00m0K00?@6P03d0^000?oP8001X000ol0000400?@6P03d1`00]0J00?@7002d1X00m100000
9@02d1D00m0Q00;@5P02d2400]0F00;@01WoP<20`830P<20`830P?n0`830P<20`83o00P00m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@0_l>P003oh2000N0
00?o00002@04d0/01]0V00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d3002m05000Mol20`830
P<20`830P<20`83oP<20`830P<20`?l03P0;d3002m0a00[@B`0000l00anN00;o4H000on0P009P003
o`000=L0002_000Roh30P<20`830P<20`830P<20`?o0P<20`830P<20`830omP0002^0003oh200160
00?oP8002h000ol0003F0000[002o`0TP<20`830P<20`830P<20`830P<3o`830P<20`830P<20`83o
e`000:/000?oP80058000on0P00=P003o`000=@0002Y00;o02W0P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20o`3E00003`037iH000?oP8005h000on0P00>P003o`000=<0000?00<O
U002o`0]P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<3o0=@0000?00<O
T`000on0P00IP003oh20016000?o0000d@000:@003?o`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`?l0dP000:800_lMP003oh2001:000?o0000d0000:4003OoP<20
`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`83o0=40002O00;o
7h000on0P00EP003o`000<h0002N000lol20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`83oc`0001800an700;o8X000on0P00FP003o`000<d0000B00<O
QP00@?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`?o>00004P037hD000?oP8008h000on0P00HP003o`000</0002H00;o04:0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P?o=0000
U`000on0P00UP003oh2001Z000?o0000bP0009D00_l0Al20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83o0</0002D0003oh2002R0
00?oP80078000ol000380000T`00C?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`?o:0000T@02obb000?oP8007H000ol0
003700005`037gH0057o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`?l0b00001L00ame00Co:h000on0P00PP003
o`000<D0000G00<OM@001?n0`807o`18P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`83oa`00090000?oP8001h06oaj000?oP800
8H000ol000340000T@003on0`830P<20`830P<20`007o`0m`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`350000TP000on0P00BP0Oo48000on0
P00SP003o`000<80002B000Lol20`830P<20`830P<20`830P<20`830P<20`0Ko0360`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0<@0002C0003oh2001j01ol2P003
oh2002F000?o0000`@0000807?l37oooI_lS00007P037g<000?oP8009H03o`:01_lOP003o`000<00
000N00<OM0009on0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003o`08`830P<20
`806o`0K`830P<20`830P<20`830P<20`830P<20`83o0<40002F0003oh2002B000?oP8003H06oaF0
00?o0000_P0009L003coP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`805o`0BP<20`830P<20`830P<20`83o_`0009L000?oP8008X000on0P00IP0Ko
2h000ol0002m0000V000A_o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<06o`07P<20`830o`2n00009P037g0000?oP80088000on0
P00UP0Ko00B07alO^`0002H00am`001Boh30P<20`830P<20`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830o`<O^`0002H00ama0003
oh2001n000?oP800:h001?lO7ank0000V`00COn0`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000;o_`0009`000?oP800
78000on0P00YP003o`000;l0002L0019ol20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002ol80002M0003oh2001^000?oP800
9X000ol000320000WP00A_o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?o50000WP000on0P00IP003oh2002B00_o60000<0037f`0
04;oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`?l37lD0000`00<OK@000on0P00GP003oh2002600_l0100O7ao50000<0037fh003goP<20
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`83o00<0
0ao50000X@000on0P00FP003oh2001j00_o<0000XP00>Oo0P<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`830P<20`830o`3>0000X`000on0P00CP003oh2001b00_o?0000
X`00=On0`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83o0=40
002T0003oh2001:000?oP8006X000ol0003@0000?0037fH0033oP<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`?l37m40000l00<OI`000on0P00@P003oh2001N000?o01l0
0QoA0000?0037fL002_o`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<2000;o
0P037m40002W0003oh2000j000?oP8005H000ol0003F0000Z0009_o0P<20`830P<20`830P<3o`830
P<20`830P<20`830P<20`8300_oI0000Z0000on0P00=P003oh2001:000?o0000f@000:T002;oP<20
`830P<20`830P<3o`830P<20`830P<20`830P<200_oL0000ZP000on0P00;P003oh2000n000?o0000
g00004X00amN000Moh30P<20`830P<20`?o0P<20`830P<20`830P<000aoN0000BP037eh000?oP800
2H000on0P00=P004oalO7mh0001:00<OG`007?o0P<20`830P<20oh30P<20`830P<20`830o`037mh0
002]0003oh2000N000?oP8002X02on<0002]000Goh30P<20`830P?n0`830P<20`830P?l0i@000:h0
00?oP8001X000on0P007P0;oiP0005T00amC0009oh30P<20`?o000<O00K0P<20`?oX0000F@037e@0
00?oP8000h000on07`027`>00_oY0000F@037e@000So`830P<3o`0<O00?0P?l0j`000;4000?oP800
0X000on0P003P003o`000>X0001Y00<O?0037`L000So`830ol20`0;ok@0006T00all00<O1`001On0
P83o00:000?o0000k@0006T00all00<O20001?n0oh02oo00001i00<O3@037``00alI00?olP0007T0
0al=00<O30037aX000?o0000l@0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@00?o0000=P02d3T00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000G@P?o@o`0f0004d000d3L000C@003@=`000m00000b0000
5P02d3@000?@00000P02d3@000?@00000P02d3@000G@P83oP002d3@000?@00000P02d3@000?@0000
0P02d3@000?@0000<`0001P000?@0000<0000m0000050003d000030000?@00001@000m00000`0009
d830P?n0`83@038000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00
000]00;@2@000m00000]00;@2@000m00000]00;@18000on0P002P003d00002d00]090003d00002d0
0]090003d00002h000?@0000=@0001X000?@0000:`000m00000:0003d00002/000?@00002P000m00
000[000>d?n0`830P?n0`830P=0]0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d003oh2000B000?oP8001803d2P00]0>00?@:002d0h0
0m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00000T000Ed03oP<20`830P?n0`830P<20
o`3@02H000?@00004@000m00000T0003d000014000?@00009002d3/0000O0003d000024000?@0000
50000m00000R0003d00001<000?@00008P000m00o`08P003oh2000J000?o0=0090000m00000C0003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d2000]005`3o
P<20`830P<20oh30P<20`830P?l000;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@
6P03d1/00m0J00?@0P000on0P008P003oh2000R000?o00000m0J00?@7002d1X00m0L00;@6P03d400
000U00;@5@03d2400]0F00;@8@02d1H00]04000Ioh30P<20`830P<20oh30P<20`830P<20o`0400?@
5@02d2400m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d0D000?oP800
2X000on0P00:P003o`0000@01=0;00K@9P04d0/01]0V00G@2P06d4D0000?00<O6P0;d3002m0`00_@
2P007On0`830P<20`830P<20oh30P<20`830P<20`83o00T02m0`00_@<@0:d4/0000?00<OY0000on0
P00<P003oh2000b000?o0000dP000;@00_l08830P<20`830P<20`830P?n0`830P<20`830P<20`83o
d`000;<000?oP8003h000on0P00>P003o`000=00002b000Vol20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P?oA0000/@000on0P00AP003oh20012000?o0000cP000;0002[o`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P?o?00003`037id000?oP8004h000on0P00BP003
o`000<`0000?00<OW000;_o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P?o=00003`037i/000?oP8005H000on0P00DP0;ob`000:`003?o`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`?l0bP000:/000?oP8005h000on0P00GP003o`000<L0
002Z000gol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830
o`380000Z@000on0P00IP003oh2001V000?o0000a@000:P003_o`830P<20`830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830o`3600004P037i8000?oP8006h000on0
P00KP003o`000<<0000B00<OT@00?oo0P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830o`3400004P037hl00_lOP003oh2001f000?o0000`@000:<0
04CoP<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830ol80002R0003oh20022000?oP8007h000ol0002o0000X@00B?n0`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol00
002P0003oh2002:000?oP8008H000ol0002m0000W`00C?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?nn0000WP000on0
P00TP003oh2002>000?o0000^`0001L00an3001@oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?nl00005`037h80
00?oP8009X000on0P00UP003o`000;T0000G00<OP@00E?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830okX0
002J0003oh2002R000?oP8009h000ol0002g0000V@00F?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`?nh0000V0000on0P00ZP003oh2002V000?o0000]@0009L005coP<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830okH0002F0003oh2002b000?oP800:h000ol0002c00000P0Lo`<Od_l37i3o8`0001h0
0amf0003oh2002Z00ol[P004oalO7k<0000N00<OM`00;?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`8300ol0;<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?l00anc0000V@000on0P00YP003oh2002R000?o0000]P0009X005Ko`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20okT0002K0003oh2002N000?oP8009X000ol0002h0000W000D_o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P?nk00009P037g@000?oP8009H000on0P00SP0<O^`0002H00ame001=ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`8000ank00009P037gH000?oP8008h000on0P00RP004oalO7k/0002P001:ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?no0000X@000on0P00QP003oh20022000?o0000_P000:8004Ko`830P<20`830P<20`830P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`83o`@000:<000?oP800
7h000on0P00NP003o`000<00002T0012ol20`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`83o``000:D000?oP8007H000on0P00LP003o`000<80
000`00<OL`00>oo0P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<2000<Oa@0003000amd0003oh2001^000?oP8006H037lD0000`00<OM@00>Oo0P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P0037lD0002Y0003
oh2001V000?oP80068000ol000360000ZP00=_o0P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20olT0002[0003oh2001N000?oP8005X000ol000380000[000<_o0
P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`83ob`000:d00_lFP003
oh2001B000?o0000bP0003`00am`000Voh30P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`8037`04P<20old0000l00<OL@000on0P00BP003oh2000f00al2P003o`000<`0000l00<OLP009?n0
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P0<O00>0o`00cP000;8000?oP80048000on0
P00@P003o`000<h0002c000Uoh30P<20`830P<20`830P<20oh30P<20`830P<20`830P<20o`3A0000
]0000on0P00>P003oh2000j000?o0000d0000;D0027oP<20`830P<20`830P<20oh30P<20`830P<20
`830P?l0d`000;H000?oP80038000on0P00<P003o`000=80001:00<OJP004On0`830P<20`830P<20
oh3000<O00W0P<20`830P?l0e@0004X00am[0003oh2000Z000?oP8000al7P003o`000=@0001:00<O
K0003on0`830P<20`830P?n0`0037`07`830P<20o`3G0000^P000on0P008P003oh2000R000?o0000
eP000;/001GoP<20`830P<20oh30P<20`830P?l0f@000;`000?oP8001X000on0P006P003o`000=P0
001I00<OG0037`80017oP<20`830P?n0`830P<20o`3K0000F@037e`00al30003oh2000B000?oP800
18000ol0003J0000F@037e`00al4000=oh30P<20oh30P<20o`3M0000`0000on0P002P003oh2000:0
00?o0000g00006T00all00<O5P002On0`83oP<20o`3O0000J@037c`00alG0004oh20o`:000?o0000
gP0006T00all00<O60001On0oh3o0>40001i00<O3@037``00alY00?ohP0007T00al=00<O30037bX0
00?o0000h@0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@ol3@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d?oo00:00]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0002M3o`?o0P<20
d00b0003d00000D000?@0000<0000m0000050003d000030000?@0000=00001T000?@0000;@02d0T0
00?@0000;@02d0T000?@0000;@02d005oh20P?l018000m3o000]00;@2@000m00000]00;@2@000m00
000^0003d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`003m00
0?n0`83oP<20`83@o`0/0003d00000X000?@0000:`000m00000:0003d00002`000?@0000=P0001/0
0]0Y00;@3P02d2T00]0>00?@:002d08000?oP8000X000on0P004P0?@:002d0h00m0X00;@3P03d2T0
0]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@001G@0000oh30P<20oh30P<20`830om00
9P000m00000A0003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0005d0000?l01X000on0P008P003d000028000?@00004`000m00
000R0003d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@10004oo0
P<20`830ol20`830P<20`8000]0P00;@5`03d1l00]0G00?@7`02d3h0000R00?@6P02d1`00m0J00?@
6`03d1X00m050003oh2000J000?oP8002X03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@
8@02d1H00]0Q00;@5P02d0L001So`830P<20`830ol20`830P<20`830P<02o`?@5@02d2400m0E00;@
8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d0T000?oP8001h000on0P00=P003
o`0000C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@<00;d0h001coP<20`830P<20
`?o0P<20`830P<20`830P<200_l400_@<00;d3402]1;00003`037jP000?oP8002H000on0P00@P003
o`000<d0002i000Roh30P<20`830P<20`83oP<20`830P<20`830P<20`830olh0002i0003oh2000^0
00?oP8004H02ol`0002h000Vol20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?o;0000
]`000on0P00=P003oh2001B00_o90000]P00:oo0P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`?l0b00000l00anT0003oh2000j000?oP8005h02olH0000?00<OX`00;on0`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`83o0<D0000?00<OXP000on0P00AP003
oh2001V00_o30000/`00=?n0`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`?o20000/`000on0P00BP003oh2001b000?o0000_`000;8003Ko`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<02okl0002a0003oh2001F000?oP800
7X000ol0002l0000/000>oo0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`830P<2000;o_00001800anK0003oh2001J000?oP8008H000ol0002i00004P037iX0
03ooP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<000_ni00004P037iT000?oP80068000on0P00TP003o`000;H0002^0013ol20`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002okH0
002]0003oh2001Z000?oP8009X000ol0002c0000[000BOo0P<20`830P<20`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0]0000:/000?oP800
78000on0P00XP0;o/P000:/004goP<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`2a0000ZP000on0P00MP003oh2002^0
0_n_00005`037hl0057oP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000an/00005`037hh000?oP80088000on0
P00ZP0;o0an/00005`037hh004Wo`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<2000Oo00>0`1l00Qn/0000Y`000on0P00QP003
oh2001b01ol9P003o`000:`0002V000mol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P007o`0@P<20`830P<20`830P<20ojl0002U0003oh2002>0
00?oP8003h06oaF000?o0000[P000:D0037oP<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`83000Oo01c0P<20`830P<20`830P<20`830P<20`830P<3o/0000:@000?oP800
9H000on0P007ob6000?o0000[`0000807?l37m;o0an@ob<0000N00<OPP000on0P00MP0Ko0X03obF0
0anc00007P037h4001_o`830P<20`830P<20`830P<20`830P<20`8001_l02<20`830P<200ol09H30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000anc0000X@000on0P00CP0Ko3h000on0
P00UP003o`000;80002P000Bol20`830P<20`830P<20`8301Ol0?L20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?l0]@000:0000?oP8002H06oa^0
00?oP8008h000ol0002c0000W`001on0`830P<001_l0Ah30P<20`830P<20`830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o0;H0000V00<OM@000on0
o`05obN000?oP8006h037`>000?o0000]@0002H00amd00?o04^0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`8000al00h30
o`2h00009P037gH000?oP800:h000on0P00KP0<O0X000ol0002f0000X002o`1>P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830
P<20`83o^@000:8000?oP800:H000on0P00MP003o`000;P0002S00;o04W0P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`83o0;/0
002U0003oh2002J000?oP80078000ol0002i0000YP00Aoo0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<3o0;`0002W00;o9X000on0
P00IP003o`000;/0000`00<OMP00>?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830P<20`830P<200al01h30P<20`?l0_P0003000amg00;o8h000on0P00?P0<O1X000ol0
002l0000<0037gT003Go`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P0037`06P<20`83o_`000:d00_lPP003oh2001J000?o0000_P000:l003WoP<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P?l0`@000;000_lNP003
oh2001B000?o0000_`000;8003Go`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830o`320000/`000on0P00JP003oh2001:000?o0000`@0003`00ame00;o01n0`830
P<20`830P<20`830P<20`830P<20`?o0P<2000<O00j0`830P<20`830P<20ol<0000l00<OM`000on0
P00GP003oh2000:00al<P003o`000<80000l00<ON002o`0L`830P<20`830P<20`830P<20`830P<3o
`830P0<O00b0`830P<20`830P?o50000^@000on0P00EP003oh2000j000?o0000a0000;X00_l09h30
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830o`360000_0000on0P00BP003oh2000f0
00?o0000a@000;d00_l08/20`830P<20`830P<20`830P?n0`830P<20`830P<20`?o80000_`000on0
P00?P003oh2000^000?o0000a`0004X00amc0008ol20`830P<037`0E`830P<20oh30P<20`830P<20
`83o0<T0001:00<OM002o`F00al7P003oh2000V000?o0000b00004X00amf0005oh30P<000al04l20
`830P<3o`830P<20`830P?l0b`000<@00_l<P003oh2000N000?o0000bP000<H001Oo`830P<20`830
P<3o`830P<20`830o`3<0000a`02o`V000?oP8001X000ol0003;0000F@037e`00al>000Boh30P<20
`830P?n0`830P<3ocP0005T00amL00<O3`02o`N000?oP80018000ol0003<0000F@037e`00alA000>
ol20`830P?n0`830P?o?0000c@000on0P003P003oh2000:000?o0000cP0006T00all00<O8`02o`08
P<20oh30P?oA0000J@037c`00alU0004oh20o`>000?o0000c`0006T00all00<O9P02o`04`?o0om80
001i00<O3@037``00alh00?od`0007T00al=00<O30037cT000?o0000dP0007T00al=00<O30037ol0
3`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d?oo00800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0001=00oh02o`80
00?@0000<0000m0000050003d000030000?@00001@000m00000`0003d00003@0000I0003d00002d0
0]090003d00002d00]090003d00002d00]00103oP?l2P0?o00?@0000;@02d0T000?@0000;@02d0T0
00?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/0
00k@0000ol3o`830P<3od2d000?@00002P000m00000[0003d00000X000?@0000;0000m00000f0000
6`02d2T00]0>00;@:@02d0h00m0X00;@0`001?n0P?l7P0?@:002d0h00m0X00;@3P03d2T00]0i0000
7@02d2D00]0B00;@9P000m00000A0003d00002@000?@00000`003on0`83oP<20`830P<3od00V0003
d000014000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@000?@0000
8P000m00000C0003d000028000?@00000`000on0P002P003oh2000R000?@ool08P000m00000C0003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d2000]06000A
ol20`830ol20`830P<20`8000]02oah00]0G00?@7`02d1L00m0O00;@?P0002800m0J00;@7003d1X0
0m0K00?@6P03d0L000?oP80018000on0P00:P0?@00?o00005`03d1`00]0J00?@7002d1X00m100000
9@02d1D00m0Q00;@5P02d2400]0F00;@2P005on0`830P<3o`830P<20`830P<20`83000?@5@02d240
0m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d0/000?oP8001X000on0
P00?P0C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@<00;d14001oo`830P<20`83o
P<20`830P<20`830P<20`830P<3o00_@<00;d3402]1;00003`037j`000?oP8001h000on0P00CP0;o
b@000;d002?oP<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`003olH0002m0003oh2000R0
00?oP8006802ol@0002l000Yol20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`800
0_o20000_0000on0P00:P003oh2001^00_o00000^`00;_n0`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20`803okd0000?00<OZ@000on0P00<P003oh2001n00_nk00003`037jP0
03Co`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`8300_ni0000
3`037jP000?oP8003X000on0P00RP0;o]`000;T003WoP<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<000ond0000^@000on0P00@P003oh2002J00_nb0000
^000?oo0P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P002ok00002h0003oh20016000?oP800:X02ojh0002g0014oh30P<20`830P<20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803oj/0000B00<O
XP000on0P00CP003oh2002j000Co7alOY`0001800anQ0019ol20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0037jL0000B00<O
X@000on0P00EP003oh2002^00ol37jL0002e0014oh30P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803o`04P<20ojT0002e0003oh2001N0
00?oP8009803o`J000?o0000Y`000;D003ooP<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<000_l02H30P<20`830o`2Z0000]0000on0P00HP003
oh2001n00ol:P003o`000:P0002d000jol20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`0?o00g0P<20`830P<20`83o0:/0002c0003oh2001Z000?oP800
6803o`n000?o0000Z@0001L00anI000foh30P<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<200_l03l20`830P<20`830P<20`0037j`0000G00<OV0000on0P00LP003
oh2001:00olAP0<O[00001L00anH000aol20`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P003o`0DP<20`830P<20`830P<20`830P<037j`0002a0003oh2001j000?oP800
2h03oaR000?o0000Z`000;4002goP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<000_l07830P<20`830P<20`830P<20`830P<20`830P?n]0000/0000on0P00PP003oh2000F0
0olLP003o`000:`0002`000Xol20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`0?o
0230P<20`830P<20`830P<20`830P<20`830P<20`830ojh0002_0003oh20026000?oP?l00_lQP003
o`000:d0000201co0aoBo`<OT?lS00007P037hd000?oP8007h05oaj00al2P003o`000:h0000N00<O
S@007oo0P<20`830P<20`830P<20`830P<20`830P<20`8000ol00h30o`03o`0MP<20`830P<20`830
P<20`830P<20`830P<20`8000al00h30o`2`0000[@000on0P00JP0?o28000on0P00OP003o`000:l0
002]000Joh30P<20`830P<20`830P<20`830P<20`803o`0^P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`830P<20ok40002/0003oh2001J00_l?P003oh2001f000?o0000/0000:`0
01Ko`830P<20`830P<20`830P<20`8300ol0</20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<3o/P0002H00an30003oh2001200olDP003oh2001:00al7P003o`000;40
000V00<OPP004On0`830P<20`830P<20`83000?o02c0P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P0<O00R0`830P<20ok<0000V00<OPP000on0P00;P0?o6h000on0P00AP0<O
1X000ol0002b0000ZP003?o0P<20`830P<20`0?o03c0P<20`830P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`?nd0000ZP000on0P007P0;o8X000on0P00HP003
o`000;<0002Y0008oh30P<20`803o`10P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20okD0002Y0003oh2000:00olXP003oh2001J000?o0000
]0000:P000?o`8000ol0AH30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830o`2f0000Z003obj000?oP8005X000ol0002d0000<0037g@0
0_l0><20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
0al03X30P<20`830P<20`83o]`0003000amf00;o;h000on0P004P0<O3H000ol0002e0000<0037gP0
0ol0<h30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P0037`0=
P<20`830P<20`830o`2h0000[P02ob^000?oP8004X000ol0002f0000/002o`0nP<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P?ni0000/P02obR0
00?oP80048000ol0002g0000]003o`0h`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`?nj0000]`02ob>000?oP8003h000ol0002h0000?0037gX00_l06/20
`830P<20`830P<20`830P<20`830P<200al05X30P<20oh30P<20`830P<20`830P?nk0000?0037g`0
0_lHP0<O1H000on0P00=P003o`000;T0000l00<OOP03o`0EP<20`830P<20`830P<20`830P<2000<O
01F0`830P?n0`830P<20`830P<20`?l0_0000<000_lLP003oh2000^000?o0000^P000<800_l0:830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P?nm0000a003oaR000?oP8002H000ol0
002k0000a`02o`0R`830P<20`830P<20`830P<20`830P?n0`830P<20`830okh0003900;o58000on0
P008P003o`000;`0001:00<ON`037`;o01g0P<20`830P<20`830P<20`830ol20`830P<20o`2o0000
BP037g/00al200?o48000on0P006P003o`000;d0001:00<ON`037`D00_l06830P<20`830P<20`830
ol20`830P<20okl0003B00;o3H000on0P004P003o`000;h0003D00;o01>0`830P<20`830P?n0`830
P<3o0<00003F00?o2H000on0P002P003o`000;l0001I00<OG0037ah00_l03L20`830P<3o`830P?l0
`@0005T00amL00<O8002o`F000GoP820o`320000F@037e`00alR00;o00S0P<20oh30ol80003O00?o
00B0oh3o``0006T00all00<O=`02o`03P?l00<80001Y00<O?0037cT000?o0000`P0006T00all00<O
oP0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`000?l0
ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d00000<00ol;0003d00002@000?@00004@000m00000T0003d000014000?@0000
9002d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m0000040003
oh2000Go1`000m00000R0003d00001<000?@00008P000m00000C0003d000028000?@0000>`000200
0]0O00;@6002d2000]0G00;@8002d0L00_l01/20`830P0Go0`02d2000]0G00?@7`02d1L00m0O00;@
?P0002800m0J00;@7003d1X00m0K00?@6P03d0P000CoP83o2X05o`?@6P03d1`00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d2400]0F00;@2`004oo0P?n0`830P<20`830P<20`8000ol3d1D0
0]0Q00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0=0005oh20P?l0
4X02o`C@2`06d2H01=0;00K@9P05d0X01]1500003`037aX02m0`00_@<00;d1<001go`830P?n0`830
P<20`830P<20`830P<20`830o`0;d3002m0a00[@B`0000l00an^0003oh2000:000?oP8006H04ol@0
002o000Voh30P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`805okl0002o0003oh2000F0
00?oP8008805okX0002o000`oh30P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<201One0000_`000on0P006P003oh2002V01?na0000_P00>_o0P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<05oj`0000?00<O[0000on0P009P003
oh2003201Ol37j@0000?00<O[000A?o0P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`8300anT00003`037j`000?oP8002X000on0P00bP0;o
0anT0000_P00A_o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20oh30P?nU0000_@000on0P00<P003oh2002j00_l3P003o`000:@0002m000n
oh30P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`802o`06`830P<3oYP000;d000?oP8003X000on0P00YP003oh2000F000?o0000Y0000;d003_oP<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`002o`09
P<20`830P<3o0:H0000B00<OY`000on0P00@P003oh2002B00_l7P0<OY`0001800anW0013ol20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P0037jL0000B00<OY`000on0P00AP003oh2002200_l:P0<OY`000;`003Go`830P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P002o`0?`830P<20`830P<20`83o0:L0
002l0003oh2001>000?oP8006h000on0P00=P003o`000:H0002k000coh30P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`83000;o0160`830P<20`830P<20`830o`2X0000
^`000on0P00EP003oh2001J00_lBP003o`000:H0002k0016oh30P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830ojP0002k0003oh2001N0
00?oP8004H02oaF000?o0000YP0001L00anP000]ol20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<2000;o0170P<20`830P<20`830P<20`0037`03`83o0:T0000G00<OX0000on0
P00IP003oh2000f000?oP8004H037`:000?o0000Y`0001L00anP000Zol20`830P<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`8300_l05830P<20`830P<20`830P<20`8300al00l20o`2Y0000
^P000on0P00JP003oh2000R00_lKP003o`000:L0002j0015ol20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3o0:X0002i0003oh2001f0
00?oP8000h02oaf000?o0000Z0000;T002CoP<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`802o`0P`830P<20`830P<20`830P<20`830P<20`830P<20`?nZ0000^@000on0P00NP003oh3o0260
00?o0000Z00000807?l37m;o0an@ob<0000N00<OU`000on0P00NP0Co5X037`N000?o0000Z@0001h0
0anG000Ool20`830P<20`830P<20`830P<20`830P<20`830P002o`0J`?oool20`830P<20`830P<20
`830P<20`8037`08P<20`830P?n[0000^0000on0P00JP0;o1X000on0P00MP003o`000:T0002h0015
ol20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<3o0:`0002h0003oh2001N00_l:P003oh2001^000?o0000ZP000;L004KoP<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<3o
[00002H00an>0003oh2001F00_l>P003oh2000V00al>P003o`000:X0000V00<OSP005_n0`830P<20
`830P<20`830P<20`802o`0L`830P<20`830P<20`830P<3o`830P<20`830P0<O00j0`830P<20`830
P<20ojd0000V00<OSP000on0P00BP003oh20016000?oP80028037`f000?o0000Z`000;H001Co`830
P<20`830P<20`830P<20`0;o0320`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P?n]0000]P000on0P00@P003oh2001J000?oP8005X000ol0002[0000]P004Oo0P<20`830
P<20`830P<2000;o03?0P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P?l0[@000;H000?oP8003802oab000?oP80058000ol0002/0000]P00AOo0P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830o`2^0000
]@000on0P00:P0;o88000on0P00CP003o`000:`0000`00<OPP00;?n0`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<200al05h3oP<20`830P<20`830P<20`830P<3o0:h0000`00<O
PP000on0P007P0;o88037`:000?oP80048000ol0002]0000<0037h8000SoP<20`830P0;o02;0P<20
`830P<20`830P<20`830P<20`830P<20`830P<200al05X30ol20`830P<20`830P<20`830P?n_0000
]0000on0P005P003oh2002R000?oP8003h000ol0002]0000]0001_o0P<20`0;o03j0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20ojl0002d0003
oh2000:000?oP800;8000on0P00=P003o`000:h0002d0003ol2000;o0430P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<3o/0000;@00olbP003
oh2000b000?o0000[P0003`00amd00;o0230P<20`830P<20`830P<20`830P<20`830P<20`830P0<O
0260`830P<20`830P<20`830P<3o`830P<20`830P<20`?l0/00003`00amd00?o7h037a>000?oP800
2H000ol0002_0000?0037gL01Ol06/20`830P<20`830P<20`830P<20`830P<200al08830P<20`830
P<20`830P<20`83oP<20`830P<20`83o/@000;/01Ol/P003oh2000R000?o0000[`000<001?l0=830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P?na0000a005obB0
00?oP8001X000ol0002`0000b@05o`0YP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830
P<20`?l0/P000<h01?lMP003oh2000B000?o0000/00004X00amk00<O1`05o`0P`830P<20`830P<20
`830P<20`830P<20oh30P<20`?nb0000BP037g/00al<00Co5H000on0P003P003o`000;00001:00<O
N`037a001Ol05X30P<20`830P<20`830P<3o`830P?nc0000h005o`b000GoP820o`2c0000i@04o`0=
`830P<20`830ol20o`2c0000j@05o`B000CoP83o/`0005T00amL00<O<`07ok@0001I00<OG0037cP0
0_nd0000F@037e`00ao^0000o`2Z0000J@037c`00aon0000J@037c`00aon0000J@037c`00aon0000
N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000
o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0>00?@:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@0000
4@000m00000T0003d000014000?@000090000m00000A0003d00002@000?@00004@000m00000T00;@
>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d1L00m0O00;@5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@
6`03d1X00m0L00;@6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@
8@03d1D00]0Q00?@5@02d4<0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0E00<O
3P04d0/01]0V00G@2P06d4D0000?00<O6P0;d3002m0`00_@500Lo`_@6ol37a802m0a00[@B`0000l0
0an_0003oh3o03j000Co7alOX`000<4004CoP<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20oh30oj@000310005oh20P?l0>X001On0P83o0:@0
00310014oh30P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`?nT0000`@000on0P003P003oh2003B000?oP8000h000ol0002R0000`@00A?n0
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<3oY00000l00an_0003oh2000F000?oP800<8000on0P003P0<OY00000l00an_0011oh30P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<00
0anT00003`037jl000?oP8001h000on0P00/P003oh2000F00anT0000`@00A?n0`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<3oY0000<40
00?oP8002H000on0P00XP003oh2000V000?o0000XP000<4004CoP<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830oj@000310003oh2000^0
00?oP80098000on0P00;P003o`000:8000310014oh30P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`?nT00004P037j`000?oP8003H000on0
P00PP003oh2000R00al2P003o`000:80000B00<O[000<On0`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<000_l02h30P<20`830P<2000<O00>0`?l0Y00001800an/0003
oh2000n000?oP8006h000on0P00;P0<O0X000ol0002R0000`@00A?n0`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3oY0000<4000?oP800
4H000on0P00GP003oh2001:000?o0000XP000<4004CoP<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830oj@000310003oh2001>000?oP800
4h000on0P00DP003o`000:8000310014oh30P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`?nT0000`@000on0P00EP003oh2000n000?oP800
5X000ol0002R00005`037jL003WoP<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`?o0P<20`830P<20`830P<000al02<20`830P<3oY00001L00anW0003oh2001N000?oP8002h000on0
P00>P0<O1h000ol0002R00005`037jL003WoP<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<3o`830P<20`830P<20`830P<000al02<20`830P<3oY0000<4000?oP8006H000on0P007P003
oh2001Z000?o0000XP000<4004CoP<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830oj@000310003oh2001^000?oP8000h000on0P00LP003
o`000:8000310014oh30P<20`830P<20`830P<20`830P<20`830P<20`?o0P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`?nT0000`@000on0P00MP003oh3o022000?o0000XP0000807?l37m;o
0an@ob<0000N00<OX0000on0P00MP0Co3X037`j000?o0000XP0001h00anP000Ooh30P<20`830P<20
`830P<20`830P<20`830P<20`004o`0?P?n0`830P<20`830P<2000<O00n0`830P<20`830P<20`?l0
Y0000<4000?oP8006h000on0P004P003oh2001^000?o0000XP000<4004CoP<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830oj@000310003
oh2001V000?oP80028000on0P00IP003o`000:8000310014oh30P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`?nT00009P037iP000?oP800
5h000on0P00<P004oalO7aJ000?o0000XP0002H00anH000Zoh30P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<200al05h30P<20`830P<20`830P<20`830P<3o0:@0000V00<OV0000on0
P00EP003oh2000n00alFP003o`000:8000310014oh30P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?nT0000`@000on0P00CP003oh2001B0
00?oP8004h000ol0002R0000`@00A?n0`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<3oY0000<4000?oP8004H000on0P00HP003oh200160
00?o0000XP000<4004CoP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830oj@000310003oh2000n000?oP80078000on0P00?P003o`000:80
000`00<OSP008?n0`830P<20`830P<20`830ol20`830P<20`830P<200al08H30P<20`830P<20`830
P?n0`830P<20`830P<20`830o`2T0000<0037hh000?oP8003H000on0P00=P0<O48000on0P00=P003
o`000:80000`00<OSP008?n0`830P<20`830P<20`?o0P<20`830P<20`830P<200al08H30P<20`830
P<20`830P<20oh30P<20`830P<20`830o`2T0000`@000on0P00;P003oh2002B000?oP8002h000ol0
002R0000`@00A?n0`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P?n0`830P<20`830P<3oY0000<4000?oP8002H000on0P00XP003oh2000V000?o0000XP000<40
04CoP<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830oj@000310003oh2000N000?oP800;8000on0P007P003o`000:80000l00<OPP005?n0
`830P<20`?o0P<20`830P<200al0;H30P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830o`2T0000?0037h8000?oP8001H000on0P009P0<O98000on0P005P003o`000:80000l00<O
PP005?n0`830P<3o`830P<20`830P<200al0;H30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`83oP<20`830o`2T0000`@000on0P003P003oh2003B000?oP8000h000ol0002R0000`@00A?n0
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<3oY0000<4000GoP820o`0jP005oh20P?l0Y0000<4004CoP<3o`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30oj@000310003oh3o03j0
00?oP?l0Y00004X00amd00;o00G0P<20`0037`0h`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`802oj@0001:00<OM007o`<O>_nT0000BP037g/00aoN0000
o`2Z0000o`2Z0000o`2Z0000F@037e`00ao^0000F@037e`00ao^0000F@037e`00ao^0000o`2Z0000
J@037c`00aon0000J@037c`00aon0000J@037c`00aon0000N@037`d00al<00<Oo`0?0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00000d00006@000m00000]00;@
2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000^0003
d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000;0000m00000f00006`02d2T00]0>00;@
:@02d0h00m0X00;@3P03d2P00]0900<O0P03d2P00]0>00?@:@02d3T0000M00;@9@02d1800]0V0003
d000014000?@000090000m00000A0003d00002@000?@000020001?lO7al50003d00002@000?@0000
4@000m00000T00;@>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003
d00001<000?@00008P000m00000400Go00B07alO1P000m00000R0003d00001<000?@00008P000m00
000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0200Go00J0`830P<02o`P00m0O00;@
5`03d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@6`03d1X00m04o`Z000CoP83o2P02d1X0
0m0L00;@6P03d400000U00;@5@03d2400]0F00;@8@02d1H00]0Q00?@5@02d0?o01;0P<20`830P<20
`830P?n0`?l<00?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@
2`06d1:000?oP8000al>00C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@01_o`830
P<20`830P<20`830P<20`830P?n0`8000alB00_@<@0:d4/0000?00<OcP05oaZ000CoP8200anS0000
g004o`0VP<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P?nS0000e`05ob6000?oP800
1H000ol0002Q0000dP05o`0_`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P?l0X`000<h01?lZP003oh2000N000?o0000X0000<T01Ol0>H30P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830o`2R00003`037k801OlbP003oh2000B0
0al00h3o002Q00003`037k000_l0?X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`?o0P<20`8300al00l3o002Q00003`037k0000CoP?oo<h000on0P006P0<O
00>0o`00X@000<8004Ko`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`83oX@000<<000CoP8200_l_P003oh2000b000?o0000W`000<<0
00KoP<20`802o`0m`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20o`2Q0000``000on0P005P003oh2002V000?oP8003H000ol0002O0000``002On0
`830P<20`002o`0kP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`?l0X00001800an^0003oh2000R00_lVP003oh2000J00al6P003o`0009h0000B00<O
[`00>oo0P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<2000<O00N0`830P<3o0:00000B00<O[`000on0P00:P0;o8H000on0P008P0<O1X000ol0002N0000
a0003oo0P<20`830P<20`830P002o`0e`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P?l0W`000<@000?oP8003X000on0P00KP003oh2001>000?o0000W@000<D0
017oP<20`830P<20`830P<20`002o`0bP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830
P<20`830P<20`830P?nO0000a@000on0P00@P0;o68000on0P00DP003o`0009d000350016oh30P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20
`830oih000350003oh2001>00_lCP003oh2001N000?o0000W00001L00an[000Hoh30P<20`830P<20
`830P<20`830P<200_l06l20`830P<20`830P<20`830ol20`830P<20`0037`0>`830P<20`830P<20
`?nN00005`037j`000?oP8005X000on0P00=P003oh2000R00al=P003o`0009`0000G00<O[0006_o0
P<20`830P<20`830P<20`830P<20`8300_l06830P<20`830P<20`?o0P<20`830P<20`0<O00o0P<20
`830P<20`830P?l0W@000<H000?oP8006H02o`Z000?oP8006X000ol0002K0000aP00A_o0P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830
P?nM0000a`000on0P00KP0;o1H000on0P00LP003o`0009/00037000Poh30P<20`830P<20`830P<20
`830P<20`830P<20`802o`0S`830ol20`830P<20`830P<20`830P<20`830P<20`830P?l0W@000<L0
00?oP8007h000on0o`0PP003o`0009X0000201co0aoBo`<OT?lS00007P037jH000?oP8007h04o`J0
0alFP003o`0009X0000N00<OY`008Oo0P<20`830P<20`830P<20`830P<20`830P<20`830P003o`07
P?oo`830P0037`0GP<20`830P<20`830P<20`830P<20`?l0W0000<P000?oP8007H000on0P004P0;o
78000ol0002I0000b000A_o0P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P?nK0000b0000on0P00LP003oh2000R00_lIP003o`0009T0
00390015oh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`83o09/0000V00<OX0000on0P00JP003oh2000:00al7P0;o5h000ol0002H0000
9P037j0002;oP<20`830P<20`830P<20`830P<20`830P<20oh30P<200al02H30P<20`830P002o`0F
`830P<20`830P<20`830P<20`830oiX0000V00<OX0000on0P00HP003oh2000B00al;P003oh2001:0
00?o0000V0000<T0037oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`83000;o01>0`830P<20`830P<20`830P<3o09X0003:0003oh2001J000?oP8005X000on0P00@P003
o`0009L0003:000col20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830
P<2000;o0170P<20`830P<20`830P<20o`2I0000bP000on0P00EP003oh2001Z00_l>P003o`0009L0
003:0016ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20oiT0003;0003oh2001:000?oP8007h02o`b000?o0000UP0003000anH000F
oh30P<20`830P<20`830P<20`830o`<O02f0`830P<20`830P<20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`?l0V00003000anH0003oh20016000?oP1l00QlQP0;o2H000ol0002F0000<0037iP0
01KoP<20`830P<20`830P<20`830ol200al08h30P<20`830P<20`830P<20`830P<20`830P<20`830
P<2000;o00S0P<20`830oiP0003;0003oh20012000?oP800:8000on0P004P003o`0009H0003<000n
ol20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<02o`06P<20`83oU`000<`000?oP8003H000on0P00]P003oh2000:000?o0000U@000<`0047o`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P002o`03`83o09L0003<0003oh2000b000?oP800<H03oiL0000l00<OSP002?n0`830P<200al0>H30
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002oiH0
000l00<OSP000on0P005P0<O0X000on0P00cP0?oUP0003`00an>0008oh30P<20`8037`0cP?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000GoV@000<d000?oP800
28000on0P00[P0GoWP000<d003CoP<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<201OnS0000cP000on0P006P003oh2002>01?nX0000cP00:_o0P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`0Go[0000<h000?oP8001H000on0P00JP0Go/@0004X0
0amk00<O0`008Oo0P<20`83oP<20`830P<20`830P<20`830P<20`830P004okH0001:00<ON`037`@0
00?oP8000X000on0P00CP0Go^P0004X00amk00<O10005_n0`830ol20`830P<20`830P<20`805okl0
003?0005oh20P?l03805ol@0003?000=oh30ol20`830P<20`004olT0003?0004oh20o`B01Oo=0000
F@037e`00alE00OodP0005T00amL00<O5@02omL0001I00<OG0037nh0003o0:X0001Y00<O?0037oh0
001Y00<O?0037oh0001Y00<O?0037oh0001i00<O3@037``00aoo00l0001i00<O3@037``00aoo00l0
001i00<O3@037``00aoo00l0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l0ZP0001@000?@0000=`02d3T00]0i00;@>@02d3T00]0i00;@<P0001D000?@0000
=@001=000=0g0004d000d3L000C@003@=`001=000=0g0004d000d3L000?@0000<P0001H00]0d0003
d00000800]0d0003d00000800]0d0003d00000800]0d0005d00001l00]0d0003d00000800]0d0003
d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m0000050003
d000030000?@00000_l37`03d000030000?@00001@000m00000`0003d00003@0000I0003d00002d0
0]090003d00002d00]090003d00002d00]090003d00002d00]03o`:00al00`3@000^00;@2@000m00
000^0003d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00
000:0003d00002/000_@oon0`830P?n0o`020003d00002/000?@00002P000m00000/0003d00003H0
000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d003oh2000F000Co7alO0P03d2P00]0>00?@
:@02d3T0000M00;@9@02d1800]0V0003d000014000?@000090000m00000A0003d00002@000c@oh30
P<20`830ol037`D000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@0
00?@00008P000m00000C0003d000028000?@00004`000m00000P00;o00?@P80028000on07`027`03
o`0000<000?@00008P000m00000C0003d000028000?@0000>`0002000]0O00;@6002d2000]0G00;@
8002d1L00]0N00;o0]004L20`830P<20`83oP<20`83o00H00m0O00;@5`03d1l00]0n00008P03d1X0
0]0L00?@6P03d1/00m0J00?@6`03d1T000Cod=3@38000on0P003P003o`0000L00]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d2400]0F00;@8@03d1@001[od=20`830P<20`830P<20`83oP<20
`830o`X00m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@
48000on0P002P0<O00?o00002`04d0/01]0V00G@2P06d4D0000?00<O6P0;d3002m0`00_@<00;d0;o
01V0`830P<20`830P<20`830P<20`?o0P<2000<O00>0o`003`0;d3402]1;00003`037m@00_lEP003
oh2000>00al00h3o002P0000h`03o`0SP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`?l0
X0000>400_lJP003oh2000R000?o0000WP000=l00_l0:L20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`83o09l0003M00;o7H000on0P00:P003o`0009d0003J00?o02k0P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<3oWP0000l00ao600;o8H000on0P004P0<O
1H000ol0002L00003`037l@00_l0:X30P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`0<O00K0P<20`?nN00003`037l800_lTP003oh2000F00al6P003o`0009/0003A00?o03R0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20oid0003?00;o
:8000on0P00@P003o`0009X0003=00;o03k0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830oi`0003;00;o;8000on0P00AP003o`0009T0003800?o
04?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`83o09/0000B00<O/@02oc2000?oP80018037`b000?o0000V00001800an`00;o03S0P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P0<O00f0`830
P<20`830P<3o09X0000B00<O/0000on0o`02obf000?oP8001H037`f000?o0000U`000<H000Co`830
0ol0@l20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P<20`830P?l0V@000<H000?oP8001803obJ000?oP8005h000ol0002F0000a`002On0`830P<20
`002o`0oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<3o09P000370003oh2000R00olQP003oh2001N000?o0000UP000<P000go`830P<20`830
P<2000?o03Z0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`83oU`000<P000?oP8003H03oaZ000?oP8006H000ol0002E00005`037jh001?o`830P<20`830
P<20`830P<2000;o01g0P<20`830P<20`830P<20`830P<20`?o0P<20`0037`0F`830P<20`830P<20
`830P<20`830oiH0000G00<O[`000on0P00AP0?o58000on0P003P0<O5H000ol0002D00005`037jl0
01OoP<20`830P<20`830P<20`830P<20`003o`0G`830P<20`830P<20`830P<3o`830P<000al05l20
`830P<20`830P<20`830P<20`83o09D0003:0003oh2001J00ol=P003oh2001f000?o0000T`000<X0
01co`830P<20`830P<20`830P<20`830P<20`8300_l0;H30P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`830o`2D0000b`000on0P00JP0?o1h000on0P00OP003o`000980003;000P
oh30P<20`830P<20`830P<20`830P<20`830P<20`803o`0XP<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20oi<0003<0003oh2001n00ol00h3oP00QP003o`000940000201co0aoBo`<O
T?lS00007P037j`000?oP8008803o`<O88000ol0002@00007P037j`002?oP<20`830P<20`830P<20
`830P<20`830P<20`830P<20`003o`<O0ol07/20`830P<20`830P<20`830P<20`830P<20`830oi80
003=0003oh20022000?oP8001X03oa^000?o0000S`000<h002ko`830P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`8300_l06X30P<20`830P<20`830P<20`830P<20`83oT@000<h0
00?oP8007X000on0P00<P0?o5h000ol0002>0000c`00<_n0`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<200ol05H30P<20`830P<20`830P<20`830o`2@00009P037jH0
00?oP8006H037`03oh2001>00olBP003o`0008d0000V00<OY`006oo0P<20`830P<20`830P<20`830
P<20`830P0037`0Iol20`830P<20`830P<20`830P<20`830P002o`0A`830P<20`830P<20`830P?l0
S`0002H00anW0003oh2001R00al00on0P00HP0?o3X000ol0002<0000d@00>on0`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83000?o00c0P<20`830P<20
`?n>0000d@000on0P00IP003oh2001n00ol8P003o`0008`0003B0010ol20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;o00R0`830P<20ohd0
003B0003oh2001N000?oP8009H03o`B000?o0000R`000=<004CoP<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0?o00>0`?l0S0000=<0
00?oP8005H000on0P00/P0?oS00003000anP000>oh30P<20`830P<20`8037`0hP<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<02oh/0000`00<OX@000on0
P00:P0<O1X000on0P00]P0;oS@0003000anQ000=ol20`830P<20`830P0037`0cP<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000?oS`000=D000?oP8004X000on0
P00XP0;oTP000=D003koP<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0;oU0000=H000?oP80048000on0P00UP0;oUP000=H003So`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0?oV0000=L000?oP800
3X000on0P00QP0;oV`0003`00anF00<O03:0`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`0;oW@0003`00anF00<O00?oP80038000on0P00NP0;oW`0003`00anF00<O
02go`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`8000onQ0000f0000on0
P00<P003oh2001V00_nT0000f@00:?n0`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`802ojH0003I0003oh2000Z000?oP8005H03ojP0003J000Rol20`830P<20`83oP<20`830P<20`830
P<20`830P<20`0;oZ`000=X000?oP80028000on0P00BP0;o[@0004X00amk00<O40007On0`830P<20
`83oP<20`830P<20`830P<20`83000;o[`0004X00amk00<O40000on0P006P003oh2000j00ona0000
BP037g/00alA000Gol20`830P<3o`830P<20`830P<20`8000_nd0000g0000on0P004P003oh2000^0
0_nf0000g@004_n0`830P?n0`830P<20`830P0;o^0000=d000?oP8000h000on0P006P0?o^P0005T0
0amL00<O8P003On0`830ol20`830P<000_nm0000F@037e`00alS0005oh20P?l01H02okl0001I00<O
G0037b<000So`83oP<20`0;o`@000=l000CoP?n00oo30000J@037c`00ald0004oh3oolH0001Y00<O
?0037cD000?o0000aP0006T00all00<OoP0007T00al=00<O30037ol03`0007T00al=00<O30037ol0
3`0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l00anW000050000m00000g00;@>@02d3T00]0i00;@00<O0000=P02d3T00]0b0000
5@000m00000e0004d000d3L000C@003@=`001=000=0g0004d1lOd3L000C@003@=`000m00000b0000
5P02d3@000?@00000P02d3@000?@00000P02d3@000?@00000P02d3<000Kod820oal2d3@000?@0000
0P02d3@000?@0000<`0001P000?@0000<0000m0000050003d000030000?@00001@000m00000`0003
d00000D000?@0000;`001_o@`830o`<O00?@0000<0000m0000050003d000030000?@0000=00001T0
00?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0>000?oP1l00Ql00`3@
000^00;@2@000m00000^0003d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X0
00?@0000:`000m00000:0003d00002X000cod830P<20oh30P?l20003d00002/000?@00002P000m00
000/0003d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d0J000?oP8000al200?@
:002d0h00m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@0000
8`003Oo@`830P<20`83oP<000al00ol000020003d00002@000?@00004@000m00000T00;@>`0001l0
00?@00008@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@00008@000oo@
P008P003oh2000<O00>0o`000`000m00000R0003d00001<000?@00008P000m00000k00008002d1l0
0]0H00;@8002d1L00]0P00;@5`02d1l001God=30P<20`830P<3o`830P<20`?l01@03d1l00]0G00?@
7`02d3h0000R00?@6P02d1`00m0J00?@6`03d1X00m0K00?@6P03d0^000?oP8001X000ol0000500;@
6P03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@01Wo`830P<20`830
P<20`?o0P<20`830P<3o00P00m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@
2`06d2H01=0;00K@0_l>P003oh2000:00al2P003o`0000T01=0;00K@9P05d0X01]1500003`037aX0
2m0`00_@<00;d3002m05000Foh30P<20`830P<20`830P<3o`830P0<O00B0`83o3P0;d3402]1;0000
3`037mT00_lAP003oh2000:00al4P003o`0009`0003Z000Rol20`830P<20`830P<20`830P?n0`830
P<20`830P<20oid0003Y0003oh20016000?oP8002h000ol0002K0000i`02o`0T`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<3oW0000>H000?oP80058000on0P00=P003o`0009T0003T00;o
02V0`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830o`2J00003`037m4000?oP800
5h000on0P002P0<O2H000ol0002H00003`037ll00_l07l20`830P<20`830P<20`830P<20`830P<3o
`830P<000al02l20`830P<20`83o09T0000?00<OcP000on0P00IP003oh2000>00al;P003o`0009H0
003O000coh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83o09L0
003M00;o7H000on0P00BP003o`0009D0003L000gol20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830o`2F0000fP02oan000?oP8005H000ol0002C0000f@00??n0
`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830oi@0
000B00<O`P02ob:000CoP8200alBP003o`000980000B00<O`@00:Oo0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83oP<2000<O01B0`830P<20`830P<20`830P<20oi<0000B00<O`0000on0
P00SP004oh20P0<O58000ol0002@0000d`02o`12`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<3oTP000=8000?oP8009H000on0P00JP003
o`0008l0003@00;o04N0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`830o`2@0000c`000on0P00XP003oh2001b000?o0000S@000<h0
04co`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`830P<20`83oS`000<`00_l/P003oh2001f000?o0000S00001L00ana000_oh30P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000al07l20`830P<20`830P<20
`830P<20`830P<20`830P?l0S@0001L00an`00Co:h001?lO7alOP003o`0008X0000G00<O/0001?o0
P<07o`0U`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`037`0P`830P<20`830P<20
`830P<20`830P<20`830P<20`?n<0000b`000on0P007P0Ko7X000on0P00QP003o`0008T0003<000?
ol20`830P<20`830P<2000Oo03f0`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o08X0003=0003oh2001:01ol@P003oh2002>000?o0000Q`000<d0
01coP<20`830P<20`830P<20`830P<20`830P<201_l0<L20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0R@000<h000?oP8007X07o`:000?oP8009H000ol000260000
0P0Lo`<Od_l37i3o8`0001h00an^0003oh2002600al0183oool2P0Ko7h000ol0002500007P037jl0
02?o`830P<20`830P<20`830P<20`830P<20`830P<20`830P0037`0<P?oooh30P<20`8301_l06h30
P<20`830P<20`830P<20`830P<20`830o`260000d@000on0P00TP003oh2000f01_lEP003o`0008<0
003B000lol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`8301Ol04/20`830P<20`830P<20`830oh@0003B0003oh2002:000?oP8006H06o`^000?o0000
PP000=<004KoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`830P<20`830P<20`830P<201_l01l20`830P?l0P`0002H00an[0003oh2001B00al9P003oh2002F0
1_l00h3o002100009P037j/001Oo`830P<20`830P<20`830P<20`830P0037`0gP<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P003oh40000V00<O[0000on0
P00CP0<O2H000on0P00[P003o`000840003F001=ol20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000_n40000e`000on0
P00LP003oh2002V000?o0000Q0000=L004WoP<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000;oQ`000=P000?oP8006h000on0
P00VP003o`0008L0003I0016oh30P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830ohX0003I0003oh2001V000?oP8009802oh/0000`00<O
Y`001oo0P<20`8000al0>830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`83oS@0003000anX0003oh2000>00alAP003oh2002600_n>0000<0037jT000Go`830
P0037`0eP<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0
T0000=`000?oP8005X000on0P00NP0;oT@000=d003WoP<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`830P?l0T`000=h000?oP8004h000on0P00LP0;oU0000=h0
03Go`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830o`2F0000
g`000on0P00BP003oh2001Z000?o0000U@0003`00anF00<O2000;oo0P<20`830P<20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<2000;oV00003`00anF00<O2@000on0P00@P003oh2001N0
00?o0000V00003`00anF00<O2@00:on0`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<000_nK0000hP000on0P00>P003oh2001F000?o0000V`000><002KoP<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P0;oWP000><000?oP8003H000on0P00BP003o`0009h0003T000R
ol20`830P<20`830P<20oh30P<20`830P<20`830P<20`0;oX@000>D000?oP8002h000on0P00?P003
o`000:40001:00<ON`037a/001oo`830P<20`830P<20oh30P<20`830P<20`830P<3o0:@0001:00<O
N`037a/000?oP8002H000on0P00=P0;oY@0004X00amk00<O70006on0`830P<20`830ol20`830P<20
`830P<20o`2W0000j0000on0P007P003oh2000Z00_nX0000j0005oo0P<20`830P<3o`830P<20`830
P<3o0:X0003Y0003oh2000J000?oP8001h02oj/0001I00<OG0037bl001;o`830P<20oh30P<20`830
P?n]0000F@037e`00al`0003oh2000>000?oP8001H02ojh0001I00<OG0037c0000koP<20`83oP<20
`830ok00003/0003oh2000:000?oP8000h000ol0002_0000J@037c`00am20008oh30P?n0`802ok80
001Y00<O?0037d8000GoP820o`02P003o`000;80001Y00<O?0037d<000Co`?o00_ne0000N@037`d0
0al<00<OE003okL0001i00<O3@037``00amE0003o`000;H0001i00<O3@037``00aoo00l0003o0:X0
003o0:X00000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?l00anW000050000m00000g00;@>@02d3T00]0i00;@00<O0000=P02d3T00]0b0000
5@000m00000e0004d000d3L000C@003@=`001=000=0g0005d1lOd?l0=P001=000=0g0003d0000380
000F00;@=0000m00000200;@=0000m00000200;@=0000m00000200;@=0001M20P?lO00;@=0000m00
000200;@=0000m00000c000060000m00000`0003d00000D000?@0000<0000m0000050003d0000300
00?@00001@000m00000`0005d<20`?l00al00m00000`0003d00000D000?@0000<0000m00000d0000
6@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@18001_lO7an0d2l0
0]090003d00002h000?@0000=@0001X000?@0000:`000m00000:0003d00002/000?@00002P000m00
000[0003d00000X000?@0000:`003]3o`830P<3o`830P<3@;@000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@00?oP80018000on07`027`:00m0X00;@
3P03d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@000?@00004@000m00000T000<
d03o`830P<20`?o00al01/20`?l0d2H000?@00004@000m00000T00;@>`0001l000?@00008@000m00
000D0003d000028000?@00004`000m00000R0003d00001<000?@00008P000m00o`08P003oh0O008O
18000ol0d00T0003d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@
5`02d2000]005`3o`830P<20`830ol20`830P<20`?l000?@7`02d1L00m0O00;@?P0002800m0J00;@
7003d1X00m0K00?@6P03d1/00m0J00?@0P000on0P008P003oh2000R000Co00000]0J00?@7002d1X0
0m1000009@02d1D00m0Q00;@5P02d2400]0F00;@8@03d1D00]04000Iol20`830P<20`830ol20`830
P<20`830o`0400?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@
2`06d0D000?oP8002X000on0P0037`N000?o00001004d0/01]0V00G@2P06d4D0000?00<O6P0;d300
2m0`00_@<00;d0X0017o`830P<20`830P<20`?o0P0037`09P<20`830P<3o00T02m0a00[@B`0000l0
0aoO0003oh2000b000?oP8000al9P003o`0009L0003_00;o0230P<20`830P<20`830P<3o`830P<20
`830P<20`830oiP0003^0003oh2000n000?oP8003X000ol0002E0000k@009_n0`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<3oUP000>`000?oP8004H000on0P00@P003o`0009<0003[000Z
oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3oU00000l00aoH0003oh2001>0
00?oP1l00Ql@P003o`000940000?00<Oe`006On0`830P<20`830P<20`830P<20`830ol000al04/20
`830P<20`830P<20`830oi80000?00<OeP000on0P00EP003oh0O008O4X02oi00003W000coh30P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`83o08l0003V0003oh2001N0
00?oP8005h000ol0002<0000i@00=on0`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P?l0S@000>@000?oP8006H000on0P00IP003o`0008X0003S000koh30P<20
`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P?l0R`000180
0ao=0003oh2001Z00alLP003o`0008P0000B00<Oc0007_n0`830P<20`830P<20`830P<20`830P<20
`830P0<O01j0`830P<20`830P<20`830P<20`830P<20`830P?n900004P037lX00_lNP0<O7X000ol0
00260000gP00A?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20`83oQ`000=d000?oP80088000on0P00OP003o`0008@0003L0018ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830
P<20`83oQ@000=/000?oP8008X000on0P00QP003o`000880003J001<ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh<0
003I0003oh2002B000?oP8008h000ol0002000005`037kh002;o`830P<20`830P<20`830P<20`830
P<20`830P<20`8300al0:l20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?l0
P@0001L00anm0003oh2002200al3P003oh2002F000?o0000OP0001L00anl000Tol20`830P<20`830
P<20`830P<20`830P<20`830P<20`8300al0;L20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20o`1o0000e@000on0P00XP003oh2002N000?o0000O0000=@005So`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83oO@000=<000?oP800:X000on0P00YP003o`0007X0003B001Lol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?mk0000d@000on0P00/P003oh2002^000?o0000N0000080
7?l37m;o0an@ob<0000N00<O/@000on0P00NP0<O2H03ob^000?o0000N@0001h00anb000Poh30P<20
`830P<20`830P<20`830P<20`830P<20`8037`09P<20`830P<2000?o02^0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<3o07`0003D0003oh2002V000?oP800:8000ol0001k0000
e@00E_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<3oOP000=H000?oP8009h000on0P00VP003o`0007d0
003G001Boh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830oh00000V00<O[`000on0P00@P0<O4X000on0P00TP003
o`0007l0000V00<O/0004_n0`830P<20`830P<20`830P0<O03V0`830P<20`830P<20`830P<3o`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0PP0002H00ana0003oh2000j00alBP003
oh2002:000?o0000P@000=/004[oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`830oh@0003L0003oh20026000?oP80088000ol0
00230000g@00A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`?n60000gP000on0P00OP003oh2001j000?o0000Q@000=l004;oP<20
`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`?n80000h0000on0P00MP003oh2001b000?o0000Q`0003000an^00<O03^0`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830o`2:0000<0037jh00alLP003
oh2001Z000?o0000R@0003000an^00<O03V0`830P<20`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`?l0S0000>@000?oP8006H000on0P00HP003o`0008/0003U000f
oh30P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<3oSP000>H0
00?oP8005h000on0P00FP003o`0008d0003W000boh30P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`830P<20`830P<20`?n@0000j002oaJ000?oP80058000ol0002?0000?0037iH00alB000]
ol20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o0980000l00<OUP037a<0
00?oP8004X000on0P00BP003o`000940000l00<OUP037a@002Wo`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830o`2D0000k@000on0P00@P003oh20012000?o0000T`000>h002Go`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<3o09H0003_0003oh2000j000?oP8003X000ol0
002E0000l0008Oo0P<20`830P<20`830P<3o`830P<20`830P<20`830o`2H0000l@000on0P00<P003
oh2000b000?o0000U`0004X00amk00<O9`007Oo0P<20`830P<20`830ol20`830P<20`830P<3o09X0
001:00<ON`037bP000?oP8002X000on0P00:P003o`0009T0001:00<ON`037bT001Wo`830P<20`830
P<3o`830P<20`830P<3o09`0003e0003oh2000R000?oP80028000ol0002K0000mP005Oo0P<20`830
P<3o`830P<20`830o`2N0000m`000on0P006P003oh2000J000?o0000W@0005T00amL00<O?@004Oo0
P<20`830ol20`830P<3o0:00001I00<OG0037ch000?oP80018000on0P004P003o`0009l0001I00<O
G0037cl000go`830P<3o`830P<3o0:80003k0003oh2000:000?oP8000X000ol0002Q0000J@037c`0
0amA0009ol20`?o0P<3o0:@0001Y00<O?0037e8000CoP83o0X000ol0002S0000J@037c`00amC0005
ol3o`?l0YP0007T00al=00<O30037f@00onW0000N@037`d00al<00<OI@000ol0002V0000N@037`d0
0al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d?ooP1l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@oh3oP0037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001On0P83o00<O00>0d?l0
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[000?d000ol20`?o0P<20`=3o02`000?@00002P000m00000/0003
d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d08000?oP8000X000on07`027`:0
0m0X00;@3P03d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@000?@00004@000m00
000T000<d0000?o0P<20`?o00al01/20`83od2H000?@00004@000m00000T00;@>`0001l000?@0000
8@000m00000D0003d000028000?@00004`000m00000R0003d00001<000?@00008P001M00003o00J0
00?oP1l00Ql6P003d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d0@001?oP<20`830P?n0`830P<20`83000?@7`02d1L00m0O00;@?P000280
0m0J00;@7003d1X00m0K00?@6P03d1/00m0J00?@1@000on0P006P003oh2000Z000?od=006P03d1`0
0]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@1`006?n0`830P<20`83oP<20
`830P<20`830P0;o0m0E00;@8@03d1D00]1300003`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H0
1=0;00K@2@000on0P007P003oh0O008O2h000ol00004d0/01]0V00G@2P06d4D0000?00<O6P0;d300
2m0`00_@<00;d0h000go`830P<20`830P?n000<O00b0`830P<20`830P<02o`@02m0a00[@B`0000l0
0aoS0003oh2000V000?oP1l00Ql>P003o`000980003d000Rol20`830P<20`830P<3o`830P<20`830
P<20`830P<20oi<0003d0003oh2000^000?oP8004H02oi40003c000Voh30P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`?n@0000lP000on0P00=P003oh2001B00_n>0000l@00:on0`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830P?l0S@0000l00aoO0003oh2000j00alGP0;o
R`0000l00aoN000Bol20`830P<20`830P<20`8300al06/20`830P<20`830P<20`830P<20`830P<3o
RP0000l00aoM0003oh2001200alJP0;oR0000>h003Co`830P<20`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`83oQ`000>h000?oP8004X000on0P00LP003o`0008@0003]000f
oh30P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<200_n40000
k0000on0P00EP003oh2001j000?o0000P@000>/003_oP<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<20`830P<20`002oh40000B00<OeP000on0P00AP0<O0X000on0
P00QP003o`0007h0000B00<Oe@005Oo0P<20`830P<20`830P<20`830P0037`0WP<3o`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<2000;oOP0001800aoD0003oh2001>00al2P003oh2002B0
00?o0000N`000>T004?oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83000;oN`000>P000?oP8006X000on0P00VP003o`0007P0003W0019
oh30P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20o`1i0000iP000on0P00LP003oh2002R00_mg0000iP00COo0P<20`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o07H0003U0003oh2001f000?oP800:h02og@0000G00<ObP005_o0P<20`830P<20`830P<20`830
P<037`0i`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83o07<0000G00<Ob@000on0P00DP0<O2H000on0P00ZP0CoLP0001L00ao9000Goh30P<20`830P<20
`830P<20`830P<000al0;l20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83000Oo00C0P<3oLP000>8000?oP8008H000on0P00LP0Oo2H000ol0001a0000h@00?On0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<001ol04<20
`830P<20`830P<20`?md0000h0000on0P00SP003oh2000n01_lEP003o`0007<0003P000aol20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P007o`0LP<20`830P<20`830
P<20`830P<20`830P<20ogD0003O0003oh2002F000?oP8001olQP003o`0007@0000201co0aoBo`<O
T?lS00007P037kd000?oP8004X037`R01_l2P0?o9h000ol0001f00007P037k`001KoP<20`830P<20
`830P<20`830P<200al00h30o`05o`08P<20`830P<03o`0X`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830ogP0003L0003oh2001>01_l?P003oh2002F000?o0000M`000=/001;oP<20
`830P<20`830P<20`805o`0mP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830o`1j0000f`000on0P009P0Ko6h000on0P00SP003o`0007P0003J0007
ol20`830P006o`17`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0N`0002H00an`0003oh3o00Go2X037aZ000?oP8008H000ol0
001j00009P037jl00ol04<20`830P<20`830P<20`8037`0nP<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P?mm00009P037k4000?oP8003X037aZ0
00?oP80088000ol0001k0000f`02o`1>`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<3oOP000=d000?oP800:H000on0
P00MP003o`0007d0003N00;o04V0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<3o0800003P0003oh2002J000?oP80078000ol0
001n0000h@00Aon0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`83o0840003R00;o9X000on0P00IP003o`000800000`00<O[P037`12
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830
P<20`83oP`0003000an^00<O00<0ool08h000on0P00HP003o`000840000`00<O[P037`<003koP<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830oh@0
003X00;o88000on0P00FP003o`0008<0003Z000iol20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<3o08H0003[00;o7X000on0P00DP003o`0008@0003]000e
oh30P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0Q`000>h0
00?oP8006X000on0P00BP003o`0008H0000l00<OUP037aL00_l0<<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<20`830ohP0000l00<OUP037aT000?oP8005h000on0P00AP003
o`0008L0000l00<OUP037aX00_l0:h30P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`?l0RP000?@000?oP8005H000on0P00>P003o`0008T0003e00;o02O0P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P?l0R`000?L000?oP8004X000on0P00=P003o`0008X0003h00;o
02:0`830P<20`830P<20`830P<3o`830P<20`830P<20`83oS@000?X000?oP8003h000on0P00;P003
o`0008`0001:00<ON`037c00023oP<20`830P<20`830P<20`?o0P<20`830P<20`830ohh0001:00<O
N`037c400_l?P003oh2000V000?o0000S@0004X00amk00<O<`006oo0P<20`830P<20`830P?n0`830
P<20`830o`2@0000o`02o`b000?oP8001h000ol0002?0000o`02000Goh30P<20`830P<20oh30P<20
`830P?l0T@000?l00`02o`V000?oP8001X000ol0002@0000F@037e`00am9000Bol20`830P<20`?o0
P<20`83oT`0005T00amL00<OBP02o`N000?oP80018000ol0002A0000F@037e`00am<000>oh30P<20
`?o0P<20`?nD0000o`090003oh2000>000?oP8000X000ol0002C0000J@037c`00amN00;o00S0P<3o
`830oiH0001Y00<O?0037f0000CoP83o0h000ol0002D0000J@037c`00amQ00;o00B0oh3oU`0007T0
0al=00<O30037g<00onH0000N@037`d00al<00<OM0000ol0002G0000N@037`d00al<00<Oo`0?0000
o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alOo`037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7an000<O00?od000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[000>d0000?n0oh30P<20om0]0003d00000X000?@0000;0000m00
000f00006`02d2T00]0>00;@:@02d0h00m0X00;@3P03d2P00]030004oh20o`:00al2P0?@:002d0h0
0m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00
00030006ol20`?o00al01/20`83od2H000?@00004@000m00000T00;@>`0001l000?@00008@000m00
000D0003d000028000?@00004`000m00000R0003d00001<000?@00008P000m0000030003oh2000:0
00?oP1l00Ql6P003d?oo028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@
5`02d2000]0G00;@8002d0H0017oP<20`83oP<20`830P<20`003d003o`0001`00]0G00?@7`02d3h0
000R00?@6P02d1`00m0J00?@6`03d1X00m0K00?@6P03d0L000?oP80018000on0P00;P0;@00?o0000
5`03d1`00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@2P005oo0P<20`83o
P<20`830P<20`830P<2000?@5@02d2400m0E00;@@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/0
1]0V00C@2`06d0/000?oP8001X001?lO7al>P0C@2`06d2H01M0:00K@A@0000l00alJ00_@<00;d300
2m0`00_@4@002_n0`830P<20`?l37`0BP<20`830P<20`830P<20`83o2m0a00[@B`0000l00aoW0003
oh2000N00alCP0;oSP000?P002?o`830P<20`830P?n0`830P<20`830P<20`830P<20`830P003oh/0
003h0003oh2000R000?oP8006802ohT0003g000Yoh30P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<000_n70000m`000on0P00:P003oh2001^00_n50000mP00;_o0P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<03oh80000?00<Oi0000on0P009P0<O00?oP800
7h02oh00000?00<Oh`003On0`830P<20`830P<000al09?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P0;oOP0000l00aoS0003oh2000Z00al00h3oP00SP0;oO0000?@003Wo`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000omi0000m0000on0
P00@P003oh2002J00_mg0000l`00?on0`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`002ogD0003c0003oh20016000?oP800:X02og<0003b0014
ol20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<03og00000B00<Og@000on0P00:P0<O1X000on0P00^P0;oKP0001800aoL000>oh30P<20
`830P<20`8037`0hP<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<02ofd0000B00<Og0000on0P00;P0<O1h000on0P00[P0?o00>0o`00K0000?0004Co`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`0?o00C0P<3oKP000?0000?oP8005h000on0P00TP0?o1X000ol0001/0000l000?oo0P<20`830
P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002o`09
`830P<20`83o06l0003_0003oh2001R000?oP8007h03o`Z000?o0000K@000>l003[oP<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<200ol03H30P<20`830
P<20`?l0L0000>h000?oP8006X000on0P00HP0?o3h000ol0001^00005`037m@000co`830P<20`830
P<037`0W`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`83000;o01:0`830P<20`830
P<20`830P?ma00005`037m<000?oP8002X037`n000?oP8004X03oa>000?o0000K`0001L00aoC000=
oh30P<20`830P<20`0037`0Q`830P<20`830P<20`830ol20`830P<20`830P<20`83000?o01K0P<20
`830P<20`830P<20`830P<3oLP000>`000?oP8007X000on0P00;P0?o68000ol0001`0000k000;Oo0
P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P002o`0L`830P<20`830P<20
`830P<20`830P<20`830og80003[0003oh20022000?oP8001H03oab000?o0000L@000>/002SoP<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<200ol08830P<20`830P<20`830P<20`830
P<20`830P<20`83oL`000>X000?oP8008H000on0o`02ob6000?o0000LP0000807?l37m;o0an@ob<0
000N00<Ob0000on0P007P0<O5H05ob>000?o0000L`0001h00ao8000:oh30P<20`830P0<O01:0`830
P<20`830P<20`830P<03o`03`83o00?o02?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
o`1e0000j0000on0P00JP0?o28000on0P00OP003o`0007@0003X000Jol20`830P<20`830P<20`830
P<20`830P<03o`0^`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830ogH0
003W0003oh2001J00_l?P003oh2001f000?o0000M@000>L001KoP<20`830P<20`830P<20`830P<20
0ol0<X30P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`83oM`0002H0
0ann0004oh20P0<O3803oaB000?oP80078000ol0001f00009P037kd000Go`830P0037`09P<20`830
P<2000?o03N0`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830
P<3o07P0000V00<O_@000on0P002P0<O1X03oa^000?oP8006X000ol0001g0000i@003?n0`830P<20
`830P0?o03b0`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P<20`830P?mi0000i@000on0P007P0;o8X000on0P00HP003o`0007P0003T0008ol20`830P<03o`10
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830ogX0003T0003oh2000:00olXP003oh2001J000?o0000N@000><000?oP<000ol0AL20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
o`1k0000h`03obj000?oP8005X000ol0001i0000<0037jh00al0BH30P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?l0O0000300
0an^00<O0_l_P003oh2001B000?o0000NP0003000an^00<O0P03o`13`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20o`1m0000j@02ob^0
00?oP8004X000ol0001k0000j`02o`0n`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`?mn0000k@02obR000?oP80048000ol0001l0000k`03o`0h
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P?mo0000
lP02ob>000?oP8003h000ol0001m0000?0037iH00alL00;o03>0`830P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`?l0P00003`00anF00<O7P02ob2000?oP8003H000ol0
001n0000?0037iH00alP00?o02g0P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P?l0P@000?/00_lLP003oh2000^000?o0000O`000?d00_l0:<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`?n20000o`03oaR000?oP8002H000ol000200000o`0300;o02:0`830
P<20`830P<20`830P<20`830ol20`830P<20`83oP`000?l01@02oaB000?oP80028000ol000210000
BP037g/00alk00;o01f0`830P<20`830P<20`830P<20oh30P<20`830o`240000BP037g/00alm00?o
48000on0P006P003o`000880001:00<ON`037d000_l06<20`830P<20`830P<20oh30P<20`830oh@0
003o00h00_l=P003oh2000B000?o0000P`000?l04002o`0C`830P<20`830P<3o`830P<20o`250000
o`0B00?o2H000on0P002P003o`0008@0001I00<OG0037eT00_l03H30P<20`83oP<20`?l0QP0005T0
0amL00<OF`02o`F000GoP820o`270000F@037e`00amM00;o00R0`830ol20ohL0003o01/00ol0183o
P?n80000J@037c`00amb00;o00?0o`00Q`0006T00all00<OM0000ol000270000J@037c`00aon0000
N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000
o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
00Co00000al50003d00002@000?@00004@000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000300<O00B0oooo0al60003
d000028000?@00004`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d2000]0G00;@
8002d0L00_l01X30P<20`0Go0`03d1l00]0G00?@7`02d3h0000R00?@6P02d1`00m0J00?@6`03d1X0
0m0K00?@6P03d0P000CoP83o2X05o`030=3@01X00m0L00;@6P03d400000U00;@5@03d2400]0F00;@
8@02d1H00]0Q00?@5@02d0/001?oP<3o`830P<20`830P<20`83000?o0m0E00;@8@03d1D00]130000
3`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@3@001On0P83o00>00al<P0;o1=0;00K@
9P05d0X01]1500003`037aX02m0`00_@<00;d3002m0C0008oh30P<3o`8037`0BP<20`830P<20`830
P<20`83o2m0a00[@B`0000l00aoY0003oh2000:000?oP8000alFP0CoR@000?X002Ko`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P<20`0GoQ0000?X000?oP8001H000on0P00PP0GoO`000?X0
033o`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<05ogX0003j0003
oh2000J000?oP800:H04ogH0003i000joh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P0GoL@0000l00aoW0003oh2000J00al00on0P00`P0GoK00000l0
0aoW0009oh30P<20`83000<O03SoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P0;oJP0000l00aoW0003oh2000J00al00h3oP00cP0;o00>0o`00J@000?T0
04KoP<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`?o0P<3oJP000?P000?oP80038000on0P00^P0;o0h000ol0001Y0000n000?_o0P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300_l01X30
P<20of/0003h0003oh2000j000?oP800:H000on0P005P003o`0006T0003h000kol20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000_l02L20`830P<20
o`1[00004P037n8000?oP8001H037`R000?oP8009802o`V000?o0000JP0001800aoR0008oh30P<20
`8037`0kP<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`?l0K00001800aoR0003oh2000F00al9P003oh2002200_l<P003o`0006X0003g000eoh30P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<000_l03h30P<20`830
P<20`830o`1/0000m`000on0P00CP003oh2001^000?oP8003H000ol0001[0000mP00<oo0P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P002o`0A`830P<20`830P<20
`830P?l0K@000?H000?oP8005H000on0P00FP0;o4X000ol0001[0000mP00A_o0P<20`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P?m]0000
mP000on0P00GP003oh2001600_lEP003o`0006/0000G00<Of`001On0`83000<O02G0P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`83000;o01N0`830P<20`830P<20`830P<20`830o`1^0000
5`037m/000?oP8000X037aB000?oP8003H000on0P00FP003o`0006`0000G00<Of`001On0`83000<O
02;0P<20`830P<20`830P<20`830P<3o`830P<20`830P<200_l06/20`830P<20`830P<20`830P<20
`830P<3oKP000?D000?oP8006X000on0P008P0;o6h000ol0001/0000m@00AOn0`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20o`1_0000
m0000on0P00MP003oh2000>00_lMP003o`0006d0003d000Tol20`830P<20`830P<20`830P<20`830
P<20`830P<3o`8300_l08830P<20`830P<20`830P<20`830P<20`830P<20`83oK`000?@000?oP800
7X000on0o`0QP003o`0006d0000201co0aoBo`<OT?lS00007P037m800alNP0Co88000ol0001^0000
7P037m800al07830P<20`830P<20`830P<20`830P<20`830P<02o`0UP?oooh30P<20`830P<20`830
P<20`830P<20`830P<20`830o`1`0000l`000on0P00JP0;o1X000on0P00MP003o`0006h0003c0015
oh30P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`83o0740003c0003oh2001N00_l:P003oh2001^000?o0000K`000?8004Ko`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`83o
L@0002H00ao200<O10000on0P00EP0;o3X000on0P00JP003o`0006l0000V00<O`P037`@001Ko`830
P<20`830P<20`830P<20`8300_l0;H30P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P<20`830o`1b00009P037l800al40003oh2001:000?oP8004H000on0P00HP003o`000700003a000D
oh30P<20`830P<20`830P<20`802o`0``830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<3oLP000?4000?oP80048000on0P00FP003oh2001J000?o0000L0000?40017oP<20
`830P<20`830P<20`002o`0cP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<3o0780003a0003oh2000b00_lLP003oh2001B000?o0000L@000?4004GoP<20`830P<20
`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0
L`000?0000?oP8002X02ob2000?oP8004h000ol0001a0000<0037jh00al<0016ol20`830P<20`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20og<0
000`00<O[P037``000?oP8001h02obF000?oP80048000ol0001b0000<0037jh00al<0008ol20`830
P<02o`0kP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`?l0M0000>l000?oP8001H000on0P00XP003oh2000n000?o0000LP000>l000KoP<20`802o`0n
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
`?md0000k`000on0P002P003oh2002b000?oP8003H000ol0001c0000k`000on0`002o`10P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20ogD0
003_00?o<X000on0P00<P003o`0007<0000l00<OUP037aH00_l0A830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`83oM@0003`00anF00<O
5P03ocF000?oP8002H000ol0001d0000?0037iH00alI00Go03f0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<3o07H0003f00Go;8000on0P008P003
o`0007@0003k00Co03C0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<3oMP000?l01OlTP003oh2000J000?o0000M@000?l01@05o`0Y`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P?l0M`000?l02P04oaf000?oP80018000ol0001e0000BP037g/0
0am200Go0220`830P<20`830P<20`830P<20`830P<3o`830P<20ogL0001:00<ON`037dL01?lEP003
oh2000>000?o0000M@0004X00amk00<OB`05o`0F`830P<20`830P<20`830P?n0`830ogP0003o01`0
1Ol<P005oh20P?l0N0000?l08@04o`0=P<20`830P<20oh30o`1h0000o`0U00Go18001?n0P?mh0000
F@037e`00am^00OoN@0005T00amL00<OL`02ogT0001I00<OG0037nh0003o0:X0001Y00<O?0037oh0
001Y00<O?0037oh0001Y00<O?0037oh0001i00<O3@037``00aoo00l0001i00<O3@037``00aoo00l0
001i00<O3@037``00aoo00l0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00000<00al400<O1P000m00000R0003
d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@
7`02d1L00m0O00;@?P0002800m0J00;@7003d1X00m0K00?@6P03d1/00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d2400]0F00;@8@02d1H00]0Q00?@5@02d2400m0E00;@8@03d1D00]130000
3`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@3@037`D00al>00C@2`06d2H01M0:00K@
A@0000l00alJ00_@<00;d3002m0`00_@4`037`Go0alBo`_@7OlD00[@B`0000l00aoY00<O00?oP800
0X037cN000?oP?l0J@000?`004Co`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20ofT0003l0005oh20P?l0>X001On0P83o06T0003l0014
ol20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P?mY0000o0000on0P003P003oh2003B000?oP8000h000ol0001W0000o000A?o0P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`83o
J@0000l00aoZ0003oh2000>00albP003oh2000F000?o0000I`0000l00aoZ0006ol20`8300al0>on0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83o06T0
000?00<OjP000on0P003P0<O00>0oh00;H000on0P007P003o`0006L0003l0014ol20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P?mY0000
o0000on0P009P003oh2002R000?oP8002H000ol0001W0000o000A?o0P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83oJ@000?`000?oP800
2h000on0P00TP003oh2000^000?o0000I`000?`004Co`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20ofT0000B00<Oi`000on0P0037`Z0
00?oP80088000on0P00=P003o`0006L0000B00<Oi`000oo0P0037`0[P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20`830P<20`830P002o`0A`830P<20`830P<20`830P?l0J@0001800aoW0003
oh2000<O38000on0P00KP003oh20012000?o0000I`000?`004Co`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20ofT0003l0003oh200160
00?oP8005h000on0P00BP003o`0006L0003l0014ol20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?mY0000o0000on0P00CP003oh2001>0
00?oP80058000ol0001W0000o000A?o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`83oJ@000?`000?oP8005H000on0P00?P003oh2001J0
00?o0000I`0001L00aoP00<O04?0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P<20`83o06T0000G00<Oh0037aV000?oP8002h000on0P00HP003
o`0006L0000G00<Oh0037`13`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20o`1Y0000o0000on0P00IP003oh2000N000?oP8006X000ol0
001W0000o000A?o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`83oJ@000?`000?oP8006h000on0P003P003oh2001b000?o0000I`000?`0
04Co`830P<20`830P<20`830P<20`830P<20`830P<20oh30P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20ofT0003l0003oh2001f000?oP?l088000ol0001W00000P0Lo`<Od_l37i3o8`0001h0
0aoB00<O1P000on0P00MP0Co7h000ol0001W00007P037m800al6000Ool20`830P<20`830P<20`830
P<20`830P<20`830P004o`0Q`?o0P<20`830P<20`830P<20`830P<20`830P<20`83o06T0003l0003
oh2001^000?oP80018000on0P00KP003o`0006L0003l0014ol20`830P<20`830P<20`830P<20`830
P<20`83oP<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P?mY0000o0000on0P00IP003
oh2000R000?oP8006H000ol0001W0000o000A?o0P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`83oJ@0002H00ao200<O3P000on0P00GP003
oh2000b000?oP8005h000ol0001W00009P037l800al>0014ol20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P?mY00009P037l800al>0003
oh2001F000?oP80048000on0P00EP003o`0006L0003l0014ol20`830P<20`830P<20`830P<20`83o
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P?mY0000o0000on0P00CP003
oh2001B000?oP8004h000ol0001W0000o000A?o0P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83oJ@000?`000?oP8004H000on0P00HP003
oh20016000?o0000I`000?`004Co`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20ofT0003l0003oh2000n000?oP80078000on0P00?P003
o`0006L0000`00<O[P037aP004Co`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20ofT0000`00<O[P037aP000?oP8003H000on0P00PP003
oh2000f000?o0000I`0003000an^00<O6000A?o0P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`83oJ@000?`000?oP8002h000on0P00TP003
oh2000^000?o0000I`000?`004Co`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20ofT0003l0003oh2000V000?oP800:8000on0P009P003
o`0006L0003l0014ol20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P?mY0000o0000on0P007P003oh2002b000?oP8001h000ol0001W0000
?0037iH00alT0014ol20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`?o0P<20`830P?mY0000?0037iH00alT0003oh2000F000?oP800<8000on0P005P003
o`0006L0000l00<OUP037b@004Co`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<3o`830P<20ofT0003l0003oh2000>000?oP800=8000on0P003P003
o`0006L0003l0014ol20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P?mY0000o0001On0P83o03Z000GoP820o`1Y0000o000A?o0P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`83o
J@000?`000?oP?l0?X000on0o`1Y0000BP037g/00ala00;o0420`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300_mY0000BP037g/00ala04Co
J@0004X00amk00<OgP000?l0ZP000?l0ZP000?l0ZP0005T00amL00<OkP0005T00amL00<OkP0005T0
0amL00<OkP000?l0ZP0006T00all00<OoP0006T00all00<OoP0006T00all00<OoP0007T00al=00<O
30037ol03`0007T00al=00<O30037ol03`0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001



\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000800?o1P000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000300<O10037`H000?@0000
8P000m00000400Go0X000ol000050003d000028000?@0000>`0002000]0O00;@6002d2000]0G00;@
8002d1L00]0P00;@5`03d1l00]0200Go00K0P<20`802o`P00m0O00;@?P0002800m0J00;@7003d1X0
0m0K00?@6P03d1/00m0J00?@7002d1X00m04o`Z000CoP83o2P02d1X00m1000009@02d1D00m0Q00;@
5P02d2400]0F00;@8@03d1D00]0Q00?@5@02d0?o01:0`830P<20`830P<20`?o0P?l<00?@5@02d4<0
000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h01=0;00K@4X001On0
P83o00l01M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@01goP<20`830P<20
`830P<20`830P<20`?o0P<20o`0D00[@B`0000l00aoY00<O1@037aD01OlJP003oh2000>000?o0000
IP000?l06004o`0V`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`?mX0000o`0C00Go
8H000on0P005P003o`0006H0003o00h01Ol0;h30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<3o06P0003o00X01?lZP003oh2000N000?o0000I@000?l01@05o`0i`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`83o06L0000?00<O
jP037`?o0alaP003oh2000R000?o0000I@0000l00aoZ00<O00?0P<000al0?L20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P?l0I`0000l00aoZ00<O
0_l0180O7al_P003oh2000Z000?o0000I@000?d004KoP<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<3oIP000?h000CoP8200_l_P003
oh2000b000?o0000I0000?h000Ko`830P<02o`0mP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830o`1V0000oP000on0P005P003oh2002V000?oP800
3H000ol0001T0000oP002Oo0P<20`830P002o`0k`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P?l0I@0001800aoY0004oalO7`N00_lVP003oh2000n0
00?o0000H`0001800aoZ00<O04:0`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P?mU00004P037nX00al:P0;o8H000on0P00AP003o`0006<0
003o000?oh30P<20`830P<20`83000;o03F0`830P<20`830P<20`830P<20`830P<20`830P<20oh30
P<20`830P<20`830P<20`830o`1T0000o`000on0P00>P003oh2001^000?oP8004h000ol0001R0000
o`01000Aol20`830P<20`830P<20`8000_l0</20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<3oI0000?l00@000on0P00@P0;o68000on0P00DP003o`000680003o0040
04Ko`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`83oH`000?l00@000on0P00CP0;o4h000on0P00GP003o`000640000G00<Oh0037`<0
01So`830P<20`830P<20`830P<20`830P<02o`0/P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P?mS00005`037n000al40003oh2001J000?oP8003H000on0P00HP003o`000640
000G00<Oh0037`@001[oP<20`830P<20`830P<20`830P<20`830P0;o02[0P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`?mR0000o`020003oh2001V00_l:P003oh2001Z000?o0000
H0000?l00P00A_n0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20`?mR0000o`030003oh2001^00_l5P003oh2001b000?o0000H0000?l0
0`008?o0P<20`830P<20`830P<20`830P<20`830P<20`8300_l08h30P?n0`830P<20`830P<20`830
P<20`830P<20`830P<3o0680003o00<000?oP8007h000on0o`0PP003o`0005l0000201co0aoBo`<O
T?lS00007P037m800al<0003oh2001n01?lOP003o`0005l0000N00<OdP037`d0027oP<20`830P<20
`830P<20`830P<20`830P<20`830P<000ol08L3ooh30P<20`830P<20`830P<20`830P<20`830P<20
o`1Q0000o`040003oh2001f000?oP8001802oab000?o0000GP000?l01000A_n0`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830ol20`830P<20`830P<20`830P<20`830P<20`?mP0000
o`040003oh2001b000?oP8002802oaV000?o0000GP000?l01@00AOo0P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830o`1P00009P037l80
0alF0003oh2001Z000?oP8003802oaN000?o0000G@0002H00ao200<O5P00;_o0P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<02o`0FP<20`830P<20`830P<20`830P<20oel0
000V00<O`P037aH000?oP80068000on0P00BP003oh2001:000?o0000G@000?l01@00<Oo0P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`8000_l04l20`830P<20`830P<20
`830P?l0G`000?l01P000on0P00FP003oh2001J000?oP80048000ol0001L0000o`06000coh30P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`83000;o0160`830P<20`830
P<20`830o`1N0000o`060003oh2001F000?oP8006X02o`j000?o0000G0000?l01P00A_n0`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`?mN0000o`070003oh2001:000?oP8007h02o`b000?o0000F`0003000an^00<O8P00A_o0P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P?mM0000<0037jh00alR0003oh20016000?oP8008h02o`V000?o0000F`0003000an^00<O8P00??o0
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;o
00R0`830P<20oed0003o00L000?oP80048000on0P00XP003oh2000B000?o0000F`000?l02000?_n0
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
0_l01/20`830oe`0003o00P000?oP8003H000on0P00]P003oh2000:000?o0000FP000?l02000@On0
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83000;o00>0`?l0G0000?l020000on0P00<P003oh2003600omL0000?0037iH00al`0014ol20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<02oe/0000l00<OUP037c0000?oP8002X000on0P00cP0?oF`0003`00anF00<O<000?_o0P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8301OmN0000
o`090003oh2000R000?oP800:h05of<0003o00T003Co`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`8301OmX0000o`0:0003oh2000J000?oP8008h04ofd0003o00X0
02[oP<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`805og40003o00X000?oP800
1H000on0P00JP0GoMP0004X00amk00<O?P008On0`830P<3o`830P<20`830P<20`830P<20`830P<20
`004og/0001:00<ON`037cl000?oP8000X000on0P00CP0GoO`0004X00amk00<O?`005_o0P<20oh30
P<20`830P<20`830P<05oh@0003o00/000GoP820o`0<P0GoR@000?l02`003Oo0P?n0`830P<20`800
1?n>0000o`0;0004oh20o`B01OnB0000F@037e`00am@00OoU`0005T00amL00<OD002oi`0001I00<O
G0037nh0003o0:X0001Y00<O?0037oh0001Y00<O?0037oh0001Y00<O?0037oh0001i00<O3@037``0
0aoo00l0001i00<O3@037``00aoo00l0001i00<O3@037``00aoo00l0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0005d0000?l0
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00000_l0183o0=0b0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0?o0X001On0o`3@030000?@0000=@0001X000?@0000:`000m00000:0003d00002/000?@0000
2P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/000_@ooo0P<20`?o0o`020003
d00002`000?@0000=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@
:002d003oh2000F000CoP83o0P03d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@0
00?@00004@000m00000T0003d00000800al400<O1@000m00000T000?d?o0P<20`830P?n0`83o00D0
00?@00009002d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m00
000C0003d000028000?@00000`037`@00al60003d00002000_l00m20P008P003oh2000:000?o0000
0`000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d2000]0G00;@8002d1L00m0M00;o
0]004H30P<20`830P<3o`830P<3o00H00m0O00;@?P0002800m0J00;@7003d1X00m0K00?@6P03d1/0
0m0J00?@7002d1T000Cod=3@38000on0P003P003o`0000L00]0J00?@@00002D00]0E00?@8@02d1H0
0]0Q00;@5P02d2400m0E00;@8@03d1@001[od=30P<20`830P<20`830P<3o`830P<20o`X00m0E00;@
@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@2`06d0d00al500<O3P04d0/01]0@P003
oh2000F000?o00002`05d0X01]1500003`037aX02m0`00_@<00;d3002m0C00<O1@037a802m02o`0N
`830P<20`830P<20`830P<20`83oP<20`830P<3o4@0:d4/0000?00<Oj@037`D00alK00;o5H000on0
P007P003o`0006@0003o01l00ol08l20`830P<20`830P<20`830P<20`830ol20`830P<20`83o06D0
003o01d00_lJP003oh2000R000?o0000H`000?l06`02o`0YP<20`830P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`?l0I0000?l06@02oaf000?oP8002X000ol0001R0000o`0F00?o02j0`830
P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`83oH`0000l00aoZ00<O0`037`h0
0_lQP003oh2000b000?o0000H@0000l00aoZ00<O0`037``00_l0<l20`830P<20`830P<20`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20o`1S00003`037nX00al300<O2P02obB000?oP800
3X000ol0001P0000o`0=00?o03S0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830of80003o00/00_lXP003oh20012000?o0000G`000?l02@02o`0nP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P?mQ0000
o`0700;o;8000on0P00AP003o`0005h0003o00@00ol0@h30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?l0H00001800aoZ00<O00?oP800
;X000on0P00CP003o`0005d0000B00<OjP037`18P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`83oG`0001800aoZ00<O0ol]P003
oh2001F000?o0000G0000?l00P001?n0`803o`13P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830o`1N0000o`020003oh2000B00olVP003
oh2001N000?o0000F`000?l00`002Oo0P<20`830P002o`0o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`83o05d0003o00<000?oP8002803ob60
00?oP8005h000ol0001K0000o`04000=oh30P<20`830P<20`003o`0j`830P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830oe`0003o00@000?oP8003H03oaZ0
00?oP8006H000ol0001J00005`037n000al6000Coh30P<20`830P<20`830P<20`002o`0fP<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83oF`0001L00aoP00<O
1`000on0P00AP0?o58000on0P00KP003o`0005T0000G00<Oh0037`L001Oo`830P<20`830P<20`830
P<20`830P003o`0aP<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
o`1J0000o`060003oh2001J00ol=P003oh2001f000?o0000F0000?l01P007?n0`830P<20`830P<20
`830P<20`830P<20`802o`0]`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`83o05T0003o00L000?oP8006X03o`N000?oP8007h000ol0001G0000o`07000Pol20`830P<20`830
P<20`830P<20`830P<20`830P<03o`0X`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830oeP0003o00P000?oP8007h03o`03P?n0026000?o0000EP0000807?l37m;o0an@ob<0000N00<O
dP037a8000?oP8008806ob2000?o0000E@0001h00aoB00<O4P008oo0P<20`830P<20`830P<20`830
P<20`830P<20`830P<2000?o00>0`8000ol07X30P<20`830P<20`830P<20`830P<20`830P<20oeL0
003o00T000?oP80088000on0P006P0?o6h000ol0001D0000o`0:000^oh30P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P0;o01[0P<20`830P<20`830P<20`830P<20`830oeH0
003o00X000?oP8007X000on0P00<P0?o5h000ol0001C0000o`0;000bol20`830P<20`830P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<03o`0E`830P<20`830P<20`830P<20`83o05D0
000V00<O`P037a`000?oP80078000on0P00CP0?o4X000ol0001B00009P037l800alM000goh30P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`002o`0AP<20`830
P<20`830P<20`?l0E00002H00ao200<O7@000on0P00KP003oh2001R00ol>P003o`000540003o00d0
03_o`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830
P003o`0<P<20`830P<20`83oD`000?l03@000on0P00IP003oh2001n00ol8P003o`000540003o00h0
043oP<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<200_l02<20`830P<3oDP000?l03P000on0P00GP003oh2002F00ol4P003o`000500003o00l0
04Co`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`0?o00?0P?l0D@000?l03`000on0P00EP003oh2002b00omA0000<0037jh00alZ0019
ol20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P002oe00000`00<O[P037b/000?oP8004h000on0P00]P0;oDP0003000an^00<O
:`00@on0`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<000omD0000o`0A0003oh2001:000?oP800:802oeL0003o014003ko`830P<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;oF@000?l0
4P000on0P00@P003oh2002F00_mK0000o`0B000hoh30P<20`830P<20`830P<20oh30P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`803oed0003o01<000?oP8003X000on0P00QP0;oH00003`0
0anF00<O>P00<oo0P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830
P002of80000l00<OUP037c/000?oP80038000on0P00NP0;oI00003`00anF00<O>`00;On0`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`003ofH0003o01@000?oP80038000on0
P00IP0;oJ@000?l05@00:?o0P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<02of/0
003o01D000?oP8002X000on0P00EP0?oK@000?l05P008_n0`830P<20`830ol20`830P<20`830P<20
`830P<20`802og00003o01H000?oP80028000on0P00BP0;oLP0004X00amk00<OB`007Oo0P<20`830
P<3o`830P<20`830P<20`830P<2000;oM00004X00amk00<OB`000on0P006P003oh2000j00omf0000
BP037g/00am<000Goh30P<20`83oP<20`830P<20`830P<000_mi0000o`0H0003oh2000B000?oP800
2h02og/0003o01T001;o`830P<3o`830P<20`830P<02ogd0003o01T000?oP8000h000on0P006P0?o
O`0005T00amL00<OG@003Oo0P<20oh30P<20`8000_n20000F@037e`00amN0005oh20P?l01H02oh@0
001I00<OG0037eh000SoP<3o`830P0;oQP000?l06`001?n0oh03ohP0001Y00<O?0037fl000Co`?oo
R`0006T00all00<OL0000ol0002;0000J@037c`00aon0000N@037`d00al<00<Oo`0?0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d83od3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0c0004om20P0;o
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d00002l000[od830P?n0o`3@<P000m00000d00006@000m00
000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@00D07alO00037`030=0002h0
0]03P007oh20P?l0d00`0003d00003D0000J0003d00002/000?@00002P000m00000[0003d00000X0
00?@0000:`000m00000:0003d00002/000?@00002P000m00000Z000<om30P<20`?o0P<3o0P000m00
000/0003d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d0800al400<O0P03d2P0
0]06P003oh2000:000?o00000m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003
d000014000?@000090000m00000200<O10037`D000?@00008`004Oo@P<20`830P<3o`830P<3o00@0
00?@00009002d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m00
000C0003d000028000?@00000`037`@00al60003d000024000?od80028000on0P004P003o`000080
00?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@7P005Oo@
d830P<20`830P?n0`830P<20o`0500?@7`02d3h0000R00?@6P02d1`00m0J00?@6`03d1X00m0K00?@
6P03d1`00]0J00?@2h000on0P006P003o`0000D00]0J00?@@00002D00]0E00?@8@02d1H00]0Q00;@
5P02d2400m0E00;@8@03d1D00]006On0`830P<20`830P<20oh30P<20`830P?l02003d1D00]130000
3`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@3@037`D00al>00C@2`06d0;o3X000on0
P007P003o`0000T01M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@1@007Oo0
P<20`830P<20`830P<20oh30P<20`830P<3o00l02]1;00003`037nT00al500<O8002oa6000?oP800
2H000ol0001Q0000o`0V000Roh30P<20`830P<20`830P<20`?o0P<20`830P<20`830of80003o02D0
00?oP8004H000on0P00;P003o`000600003o02<00_l09830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20of40003o028000?oP80058000on0P00=P003o`0005h0003o02000_l0:L20`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`83o05l0000?00<OjP037`<00alI0003oh2001N0
00?oP8003X000ol0001M00003`037nX00al300<O5`02o`0]P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<3o05h0000?00<OjP037`<00alF0003oh2001V000?oP8004H000ol0
001K0000o`0K000col20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<3o05`0003o01T00_lMP003oh2001:000?o0000FP000?l06000=on0`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?l0F`000?l05P02oan000?oP8005H000ol0
001H0000o`0E000lol20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`83oF@0001800aoZ00<O4002ob:000?oP8005X000ol0001G00004P037nX00al?0010
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830oeP0000B00<OjP037`h000?oP8008h000on0P00HP003o`0005D0003o00l00_l0@X30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20oeL0
003o00h000?oP8009H000on0P00JP003o`0005@0003o00`00_l0Al20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`83o05D0003o00/0
00?oP800:8000on0P00LP003o`000580003o00X004coP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<3oE0000?l02002obb0
00?oP8007H000ol0001A00005`037n000al700<O0530P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830oe80000G00<O
h0037`L00al2ob^000?oP80088000ol0001?00005`037n000al700<O00?0P?l01_l0B830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830
P<20oe40003o00L000?oP8001h06oaj000?oP8008H000ol0001>0000o`08000?oh30P<20`830P<20
`83000Oo03g0P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83o04l0003o00T000?oP8004X07oa2000?oP8008h000ol0001<0000o`09000Lol20`830
P<20`830P<20`830P<20`830P<20`0Ko0360`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<3o04h0003o00X000?oP8007X07o`:000?oP8009H000ol0001;00000P0Lo`<O
d_l37i3o8`0001h00aoB00<O5@000on0P00TP0?o0X06oan000?o0000BP0001h00aoB00<O5@009on0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`003o`08`830P<20`806o`0K`830P<20
`830P<20`830P<20`830P<20`83o04/0003o00d000?oP80098000on0P00=P0Ko5H000ol000180000
o`0>000loh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<201Ol04X30P<20`830P<20`830P<20odT0003o00h000?oP8008X000on0P00IP0Ko2h000ol0
00170000o`0?0016ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`0Ko00N0`830P<3o04P0000V00<O`P037b4000?oP80088000on0
P00UP0Ko00>0o`00AP0002H00ao200<O8P00D?o0P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300om600009P037l80
0alR0003oh2001n000?oP800:h000ol000160000o`0B001=oh30P<20`830P<20`830P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<000_m90000
o`0C0003oh2001b000?oP800:H000ol000190000o`0D001:oh30P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?m<0000o`0D0003
oh2001^000?oP8009X02odd0003o01D004Ko`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oC`000?l05P000on0P00IP003oh2002>0
0_m@0000<0037jh00alb0011ol20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?l0DP0003000an^00<O<P000on0P00GP003oh2002600_mC0000
<0037jh00alc000moh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20o`1E0000o`0I0003oh2001F000?oP8007h000ol0001D0000o`0J000goh30P<20
`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`002oeL0003o01X0
00?oP80058000on0P00LP003o`0005L0003o01/003?o`830P<20`830P<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`8000_mJ0000o`0L0003oh2001:000?oP8006H000ol0001J0000
?0037iH00am3000aoh30P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20
o`1M0000?0037iH00am40003oh20012000?oP8005h02oeh0000l00<OUP037dD002coP<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830of00003o01l000?oP8003X000on0P00DP0;o
H@000?l07`00:?o0P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P?mS0000o`0P0003
oh2000f000?oP8004H02of@0003o024002?o`830P<20`830P<20`83oP<20`830P<20`830P<20`830
o`1V0000o`0R0003oh2000Z000?oP80048000ol0001U0000BP037g/00amF000Noh30P<20`830P<20
`?o0P<20`830P<20`830P<200_mX0000BP037g/00amG0003oh2000V000?oP8003H000ol0001X0000
BP037g/00amH000Ioh30P<20`830P<3o`830P<20`830P<20`002of/0003o02D000?oP8001h000on0
P00:P003o`0006/0003o02D001Go`830P<20`830ol20`830P<20`8000_m^0000o`0V0003oh2000F0
00?oP80028000ol0001^0000F@037e`00am[000Bol20`830P?n0`830P<20`83oL@0005T00amL00<O
J`000on0P004P003oh2000F00_mb0000F@037e`00am/000>oh30P<20oh30P<20`?md0000o`0Y0003
oh2000:000?oP8000X02ogD0001Y00<O?0037gh000WoP<20oh30P?l0M`0006T00all00<OOP001On0
P83o00:000?o0000MP0006T00all00<OO`001?o0ol02ogT0001i00<O3@037``00an@00?oN`0007T0
0al=00<O30037i4000?o0000NP0007T00al=00<O30037ol03`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]000ol0000f00;@
<P0001D000?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0005d83od?l0=P000m00
000b00005P02d3@000?@00000P02d3@000?@00000P02d3@000?@00000P02d3@000G@7al07`02d3@0
00G@P83oP002d3@000?@0000<`0001P000?@0000<0000m0000050003d000030000?@00001@000m00
000`0003d00000D000?@0000<0001M0O7al000<O00?@0000<0002M20`83oP<20d00b0003d00003@0
000I0003d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O
00<0d000;P02d0B000?oP8000X000m00000^0003d00003D0000J0003d00002/000?@00002P000m00
000[0003d00000X000?@0000:`000m00000:0003d00002/000?@00002P000m00000[000>d?n0`830
P?n0`830P=0^0003d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d0800al400<O
0P03d2P00]000on0P004P003oh2000B00m0Y00;@>@0001d00]0U00;@4P02d2H000?@00004@000m00
000T0003d000014000?@000090000m00000200<O10037`D000?@000090005M00oh30P<20`83oP<20
`830P?l0d00V00;@>`0001l000?@00008@000m00000D0003d000028000?@00004`000m00000R0003
d00001<000?@00008P000m00000300<O10037`H000?@00008P000m00o`08P003oh2000J000?o0=00
90000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@7`02d00G0?n0`830
P<20`83oP<20`830P<20o`000m0O00;@?P0002800m0J00;@7003d1X00m0K00?@6P03d1/00m0J00?@
7002d1X00m020003oh2000R000?oP80028001?l00002d1X00m1000009@02d1D00m0Q00;@5P02d240
0]0F00;@8@03d1D00]0Q00?@5@02d0@001WoP<20`830P<20`83oP<20`830P<20`83o00@00m0E00;@
@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@2`06d0d00al500<O3P04d0/01]050003
oh2000Z000?oP8002X000ol0000400G@2P06d4D0000?00<O6P0;d3002m0`00_@<00;d1<00al500<O
4P0;d0X001goP<20`830P<20`830P?n0`830P<20`830P<20o`0:00[@B`0000l00aoY00<O1@037bH0
00?oP80038000on0P00<P003o`0005`0003o02/00_l08830P<20`830P<20`830P?n0`830P<20`830
P<20`83oG@000?l0:P000on0P00?P003oh2000j000?o0000FP000?l0:@009_o0P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`83oF`000?l0:0000on0P00AP003oh20012000?o0000F0000?l0
9`00:_o0P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20oeT0000?00<OjP037`<0
0alP0003oh2001>000?oP8004X000ol0001F00003`037nX00al300<O7`00;_o0P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`830P<20`830P?mG00003`037nX00al300<O7P000on0P00EP003
oh2001B00_mE0000o`0S000col20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<3o05@0003o028000?oP8005h000on0P00GP003o`000540003o024003Oo`830P<20`830
P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<3o0580003o020000?oP800
6H000on0P00IP003o`0004l0003o01l003_o`830P<20`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830o`1@00004P037nX00alK0003oh2001^000?oP8006h000ol0
001=00004P037nX00alJ000ool20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<3o04h0000B00<OjP037aP00_lOP003oh2001f000?o0000B`000?l0
6P00A?n0`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20
`830P<20`830P<3oC0000?l06@000on0P00PP003oh2001n000?o0000B@000?l06000B?n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20
`830odX0003o01L000?oP8008X000on0P00QP003o`0004L0003o01H004coP<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o
B0000?l05@000on0P00TP003oh2002>000?o0000A@0001L00aoP00<O1`037``0053oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830odH0000G00<Oh0037`L00al;0003oh2002J000?oP8009H000ol0001300005`037n00
0al700<O2P00E?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830od@0003o014000?oP800:8000on0P00WP003
o`000440003o010005SoP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o@P000?l03`000on0P00ZP003
oh2002V000?o0000?`000?l03P00G?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o@0000?l0
3@000on0P00/P003oh2002^000?o0000?@0000807?l37m;o0alDo`<ONOlS00007P037m800alD00<O
00?oP800:X03ob^000?o0000?P0001h00aoB00<O50037`0]0?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83000?o02_0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`83o0440003o010000?oP800:H000on0P00XP003o`000400003o014005Ko`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20od<0003o018000?oP8009h000on0P00VP003o`000480003o01<005;o`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`83oA@0002H00ao200<O9@000on0P00UP003oh2002B000?o0000A00002H0
0ao200<O9P00C_o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20odL0000V00<O`P037bL000?oP8008h000on0P00RP003
o`0004H0003o01L004[o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20odT0003o01P000?oP8008H000on0P00PP003o`0004P0
003o01T004Ko`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830
P<20`830P<20`830P<20`83oB`000?l06P000on0P00OP003oh2001j000?o0000BP000?l06`00@_o0
P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830
P<20odd0003o01`000?oP8007H000on0P00LP003o`0004`0000`00<O[P037cP003ko`830P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20odl0000`00<O
[P037cT000?oP8006h000on0P00JP003o`0004h0000`00<O[P037cX003[o`830P<20`830P<20`830
P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`83oD@000?l080000on0P00IP003
oh2001R000?o0000D0000?l08@00=_o0P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20oe<0003o028000?oP8005h000on0P00FP003o`000580003o02<003;o`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20oeD0003o02@00_lFP003
oh2001B000?o0000E00003`00anF00<OC@00;On0`830P<20`830P<20`830P<20`83oP<20`830P<20
`830P<20`830P<20o`1G0000?0037iH00am>0003oh2001:000?oP8004X000ol0001F0000?0037iH0
0am?000Yoh30P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P?l0F@000?l0:@000on0
P00@P003oh20012000?o0000F0000?l0:P009On0`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P?l0F`000?l0:`000on0P00>P003oh2000j000?o0000FP000?l0;0008On0`830P<20`830P<20
`83oP<20`830P<20`830P<20o`1M0000o`0]0003oh2000b000?oP80038000ol0001L0000BP037g/0
0amR000Moh30P<20`830P<20`83oP<20`830P<20`830P?l0G`0004X00amk00<OH`000on0P00:P003
oh2000Z000?o0000GP0004X00amk00<OI0006On0`830P<20`830P?n0`830P<20`830P?l0H@000?l0
<@000on0P008P003oh2000R000?o0000H0000?l0<P005On0`830P<20`83oP<20`830P<20o`1S0000
o`0c0003oh2000J000?oP8001X000ol0001R0000F@037e`00amh000Aoh30P<20`83oP<20`830P?l0
I@0005T00amL00<ON@000on0P004P003oh2000B000?o0000I00005T00amL00<ONP003On0`830P?n0
`830P?l0I`000?l0=`000on0P002P003oh2000:000?o0000IP0006T00all00<OS0002On0`83oP<20
o`1Y0000J@037c`00an=0004oh20o`:000?o0000J00006T00all00<OSP001On0oh3o06/0001i00<O
3@037``00anO00?oK00007T00al=00<O30037j0000?o0000J`0007T00al=00<O30037ol03`000?l0
ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d?o0d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d?oo00:0
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000W@ol3o`830P=00<P000m00000d00006@000m00
000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@00D07alO00037`030=0002h0
0]001On0P83o00B000?@o`00;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00
000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`003m000?n0`83oP<20`83@
o`0]0003d00003H0000K00;@:@02d0h00]0Y00;@3P03d2P00]0>00?@:002d0800al400<O0P03d2P0
0]020003oh2000:000?oP8001803d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@0
00?@00004@000m00000T0003d00000800al400<O1@000m00000T000Ed0000?n0`830P?n0`830P<20
`?o@02H00]0k00007`000m00000Q0003d00001@000?@00008P000m00000C0003d000028000?@0000
4`000m00000R0003d00000<00al400<O1P000m00000R0003d000008000?oP8000h000on0P008P003
d000028000?@0000>`0002000]0O00;@6002d2000]0G00;@8002d1L00]0P00;@5`03d1l00]04000C
ol20`830P<3o`830P<20`830P003d1l00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@6`03d1X0
0m0L00;@6P03d0D000?oP8001X000on0P00:P003om3@01X00m1000009@02d1D00m0Q00;@5P02d240
0]0F00;@8@03d1D00]0Q00?@5@02d0L001So`830P<20`830ol20`830P<20`830P<02o`?@5@02d4<0
000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h01=0;00K@2@000on0
P007P003oh2000f000?o00001M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@
3P007?n0`830P<20`830ol20`830P<20`830P<20`802o`D02]1;00003`037nT00al500<O:P000on0
P009P003oh20012000?o0000E`000?l0<@008Oo0P<20`830P<20`83oP<20`830P<20`830P<20`830
o`1H0000o`0`0003oh2000^000?oP8004H02oeH0003o02l002Ko`830P<20`830P<20`83oP<20`830
P<20`830P<20`830P<20oeD0003o02h000?oP8003H000on0P00DP0;oD`000?l0;P00:_n0`830P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830oe80000?00<OjP037`<00alW0003oh2000j0
00?oP8005h02oe00000?00<OjP037`<00alV000_oh30P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P?l0C`0000l00aoZ00<O0`037bH000?oP80048000on0P00IP0;oC@000?l0
:`00<oo0P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830o`1<0000
o`0Z0003oh2001:000?oP80078000ol000190000o`0Y000fol20`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830P<20`830P<20`8300_m90000o`0Y0003oh2001B000?oP8007X000ol0
00160000o`0X000joh30P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
`830P<20`830P0;oAP0001800aoZ00<O90000on0P00FP003oh20026000?o0000@`0001800aoZ00<O
9000?_o0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`8300_m300004P037nX00alS0003oh2001N000?oP80098000ol000100000o`0U0013ol20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P002od00003o02@000?oP8006X000on0P00VP003o`0003d0003o02@004SoP<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?ln0000
o`0S0003oh2001^000?oP800:802oc`0003o028004goP<20`830P<20`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`0k0000o`0R0003
oh2001b000?oP800:h02ocT0000G00<Oh0037`L00alI001Aol20`830P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o03P0
000G00<Oh0037`L00alH0003oh2001n000?oP800:X04ocL0000G00<Oh0037`L00alG0019ol20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P007o`04P<20ocL0003o01l000?oP80088000on0P00LP0Oo2H000ol0000f0000o`0N000l
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20
1ol04830P<20`830P<20`830P?li0000o`0M0003oh2002:000?oP8003h06oaF000?o0000>0000?l0
7@00<?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`0Oo01c0P<20
`830P<20`830P<20`830P<20`830P<3o>P000?l070000on0P00TP003oh2000Oo8H000ol0000i0000
0P0Lo`<Od_l37aCo0amiob<0000N00<OdP037a@00al<0003oh2001f01_l2P0?o9h000ol0000k0000
7P037m800alD00<O30006on0`830P<20`830P<20`830P<20`830P<20`005o`08`830P<20`803o`0X
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20ocd0003o01T000?oP8004h06o`j0
00?oP8009H000ol0000l0000o`0H000Aoh30P<20`830P<20`830P<001_l0?830P<20`830P<20`830
P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20ocl0003o01P000?oP800
2806oa^000?oP8008h000ol0000m0000o`0G0007ol20`830P005o`17P<20`830P<20`830P<20`830
P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l0@00002H0
0ao200<O90037`03oh3o00Go9X000on0P00QP003o`0003l0000V00<O`P037b@00al2o`1@`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20
`830P<20`830P<20`?m200009P037l800alT00<O00<0oh00:h000on0P00PP003o`000400003o01P0
0_l0CL20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`83o04<0003o01X000?oP800:8000on0P00MP003o`000480003o01/0
04[o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<20odD0003o01`00_lWP003oh2001b000?o0000@`000?l07P00A_n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`?m60000o`0O00;o9H000on0P00IP003o`0004D0000`00<O[P037c`0047o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830o`180000<0037jh0
0alm00;o8X000on0P00HP003o`0004H0000`00<O[P037cl003goP<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`83o04T0003o02D000?oP8007X000on0
P00FP003o`0004P0003o02H00_l0=l20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P?l0B`000?l0:0000on0P00LP003oh2001B000?o0000B@000?l0:@02o`0c
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o04`0003o02/0
00?oP8006H000on0P00BP003o`0004/0000l00<OUP037e<0037oP<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`83o04d0000l00<OUP037e@00_lHP003oh20016000?o0000
C00003`00anF00<OEP00;?o0P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`83o
C`000?l0<002oaJ000?oP8003X000ol0001>0000o`0b000Xoh30P<20`830P<20`830P<20`830P?n0
`830P<20`830P<20`830oe00003o03<00_lCP003oh2000f000?o0000C`000?l0=@008oo0P<20`830
P<20`830P<20`83oP<20`830P<20`830P<3o0580003o03H000?oP8003h000on0P00;P003o`000540
001:00<ON`037f/00_l07X30P<20`830P<20`830P?n0`830P<20`830P<20oe<0001:00<ON`037fd0
00?oP8003H000on0P009P003o`000580001:00<ON`037fh00_l06L20`830P<20`830P<3o`830P<20
`830P?l0E@000?l0?0000on0P00:P003oh2000N000?o0000E0000?l0?@02o`0EP<20`830P<20`?o0
P<20`830P<3o05H0003o03l000?oP8001h000on0P006P003o`0005D0001I00<OG0037h@001;oP<20
`830P<20oh30P<20`?mH0000F@037e`00an500;o1h000on0P004P003o`0005H0001I00<OG0037hL0
00ko`830P<20oh30P<20oeT0003o04@00_l4P003oh2000:000?o0000F00006T00all00<OVP002On0
`83oP<20o`1K0000J@037c`00anK0004oh20o`>000?o0000F@0006T00all00<OW002o`04`?o0oe`0
001i00<O3@037``00an^00?oG@0007T00al=00<O30037jl000?o0000G00007T00al=00<O30037ol0
3`000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d?oo0080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000C@0?n00_l20003d000030000?@0000=00001T0
00?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d0T000?@0000;@02d00501lO7`000al00`3@
000^00;@00@0oh3o0X03o`03d00002h000?@0000=@0001X000?@0000:`000m00000:0003d00002/0
00?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/000k@0000ol3o`830
P<3od2h000?@0000=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@
:002d0<000CoP83o1h03d2T00]0i00007@02d2D00]0B00;@9P000m00000A0003d00002@000?@0000
4@000m00000T0003d00000800al400<O1@000m00000T0003d00000<000ooP<20oh30P<20`830om00
9P02d3/0000O0003d000024000?@000050000m00000R0003d00001<000?@00008P000m00000C0003
d000028000?@00000`037`@00al60003d000028000?@00000`000on0P002P003oh2000R000?@ool0
8P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@7`02d0H0017o`830
P<3o`830P<20`830P003d003o`0001`00]0n00008P03d1X00]0L00?@6P03d1/00m0J00?@6`03d1X0
0m0L00;@6P03d0L000?oP80018000on0P00;P0;@00?o00005`03d400000U00;@5@03d2400]0F00;@
8@02d1H00]0Q00?@5@02d2400m0E00;@2P005on0`830P<3o`830P<20`830P<20`83000?@5@02d4<0
000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h01=0;00K@2`000on0
P006P003oh2000n01M0:00K@A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@4@007_o0
P<20`830P?n0`830P<20`830P<20`830P<20`0;o2]1;00003`037nT00al500<O;P000on0P007P003
oh2001>00_mC0000o`0d000Soh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<000om@0000
o`0d0003oh2000R000?oP8006802odh0003o03<002Wo`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P002od`0003o03<000?oP8002X000on0P00KP0;oBP000?l0<P00;_n0`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`803odL0000?00<OjP037`<00al/0003
oh2000b000?oP8007h02odD0000?00<OjP037`<00al[000dol20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`0;o@`0000l00aoZ00<O0`037b/000?oP8003X000on0
P00RP0;o@@000?l0<000>On0`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`003och0003o030000?oP80048000on0P00VP0;o?0000?l0;`00?oo0P<20`830
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002ocX0
003o02l000?oP8004H000on0P00ZP0;o>0000?l0;P00A?n0`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<200ole00004P037nX00al[0003
oh2001>000?oP800;X02oc<0000B00<OjP037bX004Wo`830P<20`830P<20`830P<20`830P?n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<2000;o<P0001800aoZ00<O
:P000on0P00EP003oh2002^00ol00h3o000a0000o`0/0014oh30P<20`830P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`803o`04P<20oc<0003o02`0
00?oP8005h000on0P00TP0?o1X000ol0000a0000o`0/000ooh30P<20`830P<20`830P<20`830P<20
`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000;o00V0`830P<20`?l0=0000?l0
:`000on0P00HP003oh2001n00ol:P003o`000380003o02/003[o`830P<20`830P<20`830P<20`830
P<20`830ol20`830P<20`830P<20`830P<20`830P<20`8300ol03L20`830P<20`830P?l0=@000?l0
:P000on0P00JP003oh2001R00ol?P003o`0003<0000G00<Oh0037`L00alR000foh30P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<200_l04/20`830P<20`830P<20
`830ocH0000G00<Oh0037`L00alQ0003oh2001b000?oP8004X03oa>000?o0000=00001L00aoP00<O
1`037b40037o`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<2000?o
01J0`830P<20`830P<20`830P<20`83o=`000?l0:0000on0P00NP003oh2000^00olHP003o`0003D0
003o02P002goP<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<000_l07830
P<20`830P<20`830P<20`830P<20`830P?lg0000o`0W0003oh20022000?oP8001H03oab000?o0000
=P000?l09`00:?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<03o`0P`830P<20
`830P<20`830P<20`830P<20`830P<20`?lh0000o`0V0003oh20026000?oP?l00_lQP003o`0003L0
000201co0aoBo`<O5?l37gWo8`0001h00aoB00<O50037aL000?oP8007h05ob>000?o0000>00001h0
0aoB00<O50037aL001oo`830P<20`830P<20`830P<20`830P<20`830P<2000?o00>0`?l00ol08h30
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o03X0003o02@000?oP8006X03o`R000?oP800
7h000ol0000i0000o`0T000Joh30P<20`830P<20`830P<20`830P<20`803o`0^P<20`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`830P<20oc/0003o02<000?oP8005X02o`n000?oP800
7H000ol0000j0000o`0S000Fol20`830P<20`830P<20`830P<20`0?o03;0P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`830P<20`830oc`0000V00<O`P037b@00al=0003oh200120
0olDP003oh2001b000?o0000>`0002H00ao200<O90037``0017oP<20`830P<20`830P<20`003o`0g
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`830P<20o`0m0000
9P037l800alT00<O30000on0P00;P0?o6h000on0P00JP003o`0003`0003o024000co`830P<20`830
P<03o`0l`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<3o?P000?l08@000on0P007P0;o8X000on0P00HP003o`0003d0003o020000SoP<20`830P0?o
0420`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830
P<20`83o?`000?l080000on0P002P0?o:8000on0P00FP003o`0003h0003o01l000?o`8000ol0AH30
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830o`100000o`0O00?o;X000on0P00FP003o`0003h0000`00<O[P037cP00al0BL20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P?l0@@0003000an^00<O>0037`;o;h000on0P00DP003o`0003l0000`00<O[P037cP00al200?o
04>0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<3o0480003o02D00_l[P003oh2001:000?o0000@0000?l09`02o`0nP<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P?m30000o`0Y00;o
:8000on0P00@P003o`000440003o02/00ol0><20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<3oA0000?l0;P02ob>000?oP8003h000ol000120000?0037iH0
0amG00;o03?0P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P?l0
A@0003`00anF00<OF@02ob2000?oP8003H000ol000130000?0037iH00amK00?o02f0`830P<20`830
P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`?l0AP000?l0=`02oab000?oP8002h000ol0
00140000o`0i00;o02R0`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`83oA`000?l0
>`03oaR000?oP8002H000ol000150000o`0n00;o02;0P<20`830P<20`830P<20`830P<20oh30P<20
`830P<3oB0000?l0@002oaB000?oP80028000ol000160000BP037g/00amf00;o01g0P<20`830P<20
`830P<20`830ol20`830P<20o`190000BP037g/00amh00?o48000on0P006P003o`0004L0001:00<O
N`037g/00_l06830P<20`830P<20`830ol20`830P<20odT0003o04T00_l=P003oh2000B000?o0000
B0000?l0B`02o`0CP<20`830P<20`83oP<20`830o`1:0000o`1=00?o2H000on0P002P003o`0004T0
001I00<OG0037i@00_l03L20`830P<3o`830P?l0B`0005T00amL00<OUP02o`F000GoP820o`1<0000
F@037e`00anH00;o00S0P<20oh30od`0003o05H00ol0183oP?m=0000J@037c`00an]00;o00>0o`00
C00006T00all00<O[`000ol0001<0000J@037c`00aon0000N@037`d00al<00<Oo`0?0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000400?o2P000m00000T00;@>`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000300<O10037`H000?@0000
8P000m0000050003oh2000Go1P000m00000R0003d00003/0000P00;@7`02d1P00]0P00;@5`02d200
0]0G00;@8002d1L00m0O00;@2002o`06P<20`8301Ol200?@7`02d3h0000R00?@6P02d1`00m0J00?@
6`03d1X00m0K00?@6P03d1`00]0J00?@2@001?n0P?l:P0Co00<0d=006P03d400000U00;@5@03d240
0]0F00;@8@02d1H00]0Q00?@5@02d2400m0E00;@30004_n0`?o0P<20`830P<20`830P0?o0m0E00;@
@`0000l00alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@2`06d0d00al500<O3P04d0/01]0>0005
oh20P?l04X000oo@d003d0X01]1500003`037aX02m0`00_@<00;d3002m0C00<O1@037a802m0D000M
oh30P<3o`830P<20`830P<20`830P<20`830P?l02]1;00003`037nT00al500<O<0000on0P003P003
oh2001R01Om=0000o`0g000Vol20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<04odT0
003o03L000?oP8001H000on0P00OP0GoA0000?l0=`00;oo0P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<2000Go?`000?l0=P000on0P007P003oh2002R01?lk0000o`0f000i
oh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000Go
=P0000l00aoZ00<O0`037c0000?oP80028000on0P00`P0Go<@0000l00aoZ00<O0`037c0004?oP<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83000;o;`0000l00aoZ00<O0`037c0000?oP8002X000on0P00aP0;o00>0o`00;P000?l0=@00A_o0
P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20oh30P?l_0000o`0e0003oh2000b000?oP800;H02o`>000?o0000;P000?l0=@00?Oo0P<20`830
P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000_l01/20
`830oc00003o03D000?oP8003H000on0P00YP003oh2000F000?o0000;P000?l0=000>on0`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83000;o00V0`830
P<20`?l0<00001800aoZ00<O<@000on0P00?P003oh2002B00_l9P003o`0002l0000B00<OjP037c40
04GoP<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0
`830P<20`830P?l0<@0001800aoZ00<O<@000on0P00AP003oh2001n00_l<P003o`0002l0003o03<0
03Go`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P002o`0?
`830P<20`830P<20`83o0340003o03<000?oP8004h000on0P00KP003oh2000f000?o0000<0000?l0
<`00<_o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`830P<20`8300_l04H30
P<20`830P<20`830P<3o0380003o03<000?oP80058000on0P00FP0;o4X000ol0000`0000o`0b0016
oh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20
`830P<20`830oc80003o038000?oP8005h000on0P00AP0;o5H000ol0000`00005`037n000al700<O
:P00;?n0`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<200_l05l20`830P<20
`830P<20`830P<20`83o03<0000G00<Oh0037`L00alZ0003oh2001R000?oP8003H000on0P00FP003
o`000340000G00<Oh0037`L00alY000Zol20`830P<20`830P<20`830P<20`830P<20`83oP<20`830
P<20`8300_l06X30P<20`830P<20`830P<20`830P<20`83o<`000?l0<@000on0P00JP003oh2000R0
0_lKP003o`000340003o034004Go`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83o
P<20`830P<20`830P<20`830P<20`830P<20`?l0=0000?l0<@000on0P00LP003oh2000>00_lMP003
o`000380003o034002?o`830P<20`830P<20`830P<20`830P<20`830P<20oh30P002o`0P`830P<20
`830P<20`830P<20`830P<20`830P<20`?ld0000o`0`0003oh2001j000?oP?l08H000ol0000b0000
0P0Lo`<Od_l37aCo0amiob<0000N00<OdP037a@00alR0003oh2001f01?lPP003o`0003<0000N00<O
dP037a@00alR000Noh30P<20`830P<20`830P<20`830P<20`830P<200_l09L3oooo0P<20`830P<20
`830P<20`830P<20`830P<20`830P?l0=@000?l0;`000on0P00JP0;o1X000on0P00MP003o`0003<0
003o02l004Go`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`?l0=P000?l0;`000on0P00GP0;o2X000on0P00KP003o`0003@0003o02l0
04Go`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`83oP<20`830P<20`830P<20`830
P<20`830P<20`?l0=P0002H00ao200<O90037aP000?oP8005H02o`j000?oP8006X000ol0000d0000
9P037l800alT00<O60005_n0`830P<20`830P<20`830P<20`802o`0]`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`83o03L0000V00<O`P037b@00alH0003oh2001:000?oP800
4H000on0P00HP003o`0003D0003o02h001?oP<20`830P<20`830P<20`83000;o0320`830P<20`830
P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P?lg0000o`0]0003oh20012000?oP800
5X000on0P00FP003o`0003D0003o02d0017o`830P<20`830P<20`830P002o`0c`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`83o03L0003o02d000?oP8003802oab0
00?oP80058000ol0000f0000o`0]0015ol20`830P<20`830P<3o`830P<20`830P<20`830P<20`830
P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o03P0003o02`000?oP8002X02ob2000?oP800
4h000ol0000f0000<0037jh00alh00<O3000A_n0`830P<20`830P?n0`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`?lh0000<0037jh00alh00<O30000on0
P007P0;o9H000on0P00@P003o`0003L0000`00<O[P037cP00al<0008oh30P<20`802o`0k`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P?l0>@000?l0
;0000on0P004P003oh2002R000?oP8003h000ol0000g0000o`0[0006ol20`8300_l0?X30P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`83o>@000?l0
:`000on0P002P003oh2002b000?oP8003H000ol0000h0000o`0[0003ol2000;o0430P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<3o>P000?l0
:`03oc:000?oP80038000ol0000h0000?0037iH00am@00<O04C0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830ocX0000l00<OUP037e00
0al00on0P00cP003oh2000V000?o0000>@0003`00anF00<OD0037`030?oo00?o03g0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`83o03/0003o0380
1Ol/P003oh2000R000?o0000>@000?l0=`04o`0dP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`83oP<20`830P<20oc/0003o03/01OlTP003oh2000J000?o0000>P000?l0@005o`0Y
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`?l0?0000?l0A@04oaf000?oP800
18000ol0000j0000BP037g/00amm00Go0230P<20`830P<20`830P<20`830P<20`83oP<20`830oc`0
001:00<ON`037h801?lEP003oh2000>000?o0000>P0004X00amk00<OQP05o`0FP<20`830P<20`830
P<20`?o0P<20ocd0003o05L01Ol<P005oh20P?l0?@000?l0G004o`0=`830P<20`830ol20o`0m0000
o`1P00Go18001?n0P?lm0000F@037e`00anY00Oo?P0005T00amL00<O[P02och0001I00<OG0037nh0
003o0:X0001Y00<O?0037oh0001Y00<O?0037oh0001Y00<O?0037oh0001i00<O3@037``00aoo00l0
001i00<O3@037``00aoo00l0001i00<O3@037``00aoo00l0003o0:X0003o0:X00000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000A0003d00002@00]0k00007`000m00000Q0003d00001@000?@0000
8P000m00000C0003d000028000?@00004`000m00000R0003d00000<00al400<O1P000m00000R0003
d00001<000?@00008P000m00000k00008002d1l00]0H00;@8002d1L00]0P00;@5`02d2000]0G00?@
7`02d1L00m0O00;@?P0002800m0J00;@7003d1X00m0K00?@6P03d1/00m0J00?@7002d1X00m0L00;@
6P03d400000U00;@5@03d2400]0F00;@8@02d1H00]0Q00?@5@02d2400m0E00;@8@03d1D00]130000
3`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@3@037`D00al>00C@2`06d2H01M0:00K@
A@0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@500Mo`[@7Ol^00003`037nT00al500<O
<@000on0o`0nP003oh3o02h0003o03P004CoP<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20oh30obh0003o03P000GoP820o`0jP005oh20P?l0
;P000?l0>000A?n0`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<3o;P000?l0>0000on0P003P003oh2003B000?oP8000h000ol0000/0000
o`0h0014oh30P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`?l^00003`037nX00al300<O<P000on0P005P003oh20032000?oP8001H000ol0
000/00003`037nX00al300<O<P00A?n0`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83oP<20`830P<3o;P0000l00aoZ00<O0`037c8000?oP8001h000on0
P00/P003oh2000N000?o0000;0000?l0>000A?n0`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<3o;P000?l0>0000on0P009P003oh2002R0
00?oP8002H000ol0000/0000o`0h0014oh30P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`?l^0000o`0h0003oh2000^000?oP80098000on0
P00;P003o`0002`0003o03P004CoP<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20oh30P<20`830P<20`830obh0000B00<OjP037cD000?oP8003H000on0P00PP003
oh2000f000?o0000;00001800aoZ00<O=@00<On0`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<000_l04H30P<20`830P<20`830P<3o02h0000B00<OjP037cD000?oP800
3h000on0P00KP003oh20012000?o0000;0000?l0>000A?n0`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<3o;P000?l0>0000on0P00AP003
oh2001N000?oP8004X000ol0000/0000o`0h0014oh30P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`?l^0000o`0h0003oh2001>000?oP800
4h000on0P00DP003o`0002`0003o03P004CoP<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830obh0003o03P000?oP8005H000on0P00?P003
oh2001J000?o0000;00001L00aoP00<O1`037c0004CoP<20`830P<20`830P<20`830P<20`830ol20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830obh0000G00<Oh0037`L00al`0003
oh2001N000?oP8002h000on0P00HP003o`0002`0000G00<Oh0037`L00al`0014oh30P<20`830P<20
`830P<20`830P<20`830ol20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`?l^0000
o`0h0003oh2001V000?oP8001h000on0P00JP003o`0002`0003o03P004CoP<20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830obh0003o03P0
00?oP8006h000on0P003P003oh2001b000?o0000;0000?l0>000A?n0`830P<20`830P<20`830P<20
`830P<20`830P<3o`830ol20`830P<20`830P<20`830P<20`830P<20`830P<3o;P000?l0>0000on0
P00MP003oh3o022000?o0000;00000807?l37m;o0alDo`<ONOlS00007P037m800alD00<O:P000on0
P00MP0Co7h000ol0000/00007P037m800alD00<O:P007on0`830P<20`830P<20`830P<20`830P<20
`830P<001?l08H3oP<20`830P<20`830P<20`830P<20`830P<20`830o`0^0000o`0h0003oh2001^0
00?oP80018000on0P00KP003o`0002`0003o03P004CoP<20`830P<20`830P<20`830P<20`830P<20
`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830obh0003o03P000?oP8006H000on0
P008P003oh2001V000?o0000;0000?l0>000A?n0`830P<20`830P<20`830P<20`830P<20`?o0P<20
`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<3o;P0002H00ao200<O90037b8000?oP800
5h000on0P00<P003oh2001N000?o0000;00002H00ao200<O90037b8004CoP<20`830P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830obh0000V00<O
`P037b@00alR0003oh2001F000?oP80048000on0P00EP003o`0002`0003o03P004CoP<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830obh0
003o03P000?oP8004h000on0P00DP003oh2001>000?o0000;0000?l0>000A?n0`830P<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<3o;P000?l0
>0000on0P00AP003oh2001R000?oP8004H000ol0000/0000o`0h0014oh30P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`?l^0000o`0h0003
oh2000n000?oP80078000on0P00?P003o`0002`0000`00<O[P037cP00alH0014oh30P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`?l^0000
<0037jh00alh00<O60000on0P00=P003oh20022000?oP8003H000ol0000/0000<0037jh00alh00<O
6000A?n0`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20
`830P<20`830P<3o;P000?l0>0000on0P00;P003oh2002B000?oP8002h000ol0000/0000o`0h0014
oh30P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`?l^0000o`0h0003oh2000V000?oP800:8000on0P009P003o`0002`0003o03P004CoP<20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830obh0003o03P000?oP8001h000on0P00/P003oh2000N000?o0000;00003`00anF00<OD0037``0
04CoP<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830obh0000l00<OUP037e000al<0003oh2000F000?oP800<8000on0P005P003o`0002`0
000l00<OUP037e000al<0014oh30P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20oh30P<20`?l^0000o`0h0003oh2000>000?oP800=8000on0P003P003
o`0002`0003o03P004CoP<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P?n0`830obh0003o03P000GoP820o`0jP005oh20P?l0;P000?l0>000A?n0
`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
`83oP<3o;P000?l0>0000on0o`0nP003oh3o02h0001:00<ON`037f/00al0@<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`802obh0001:00<O
N`037f/00am2obh0001:00<ON`037f/00am`0000o`2Z0000o`2Z0000o`2Z0000F@037e`00ao^0000
F@037e`00ao^0000F@037e`00ao^0000o`2Z0000J@037c`00aon0000J@037c`00aon0000J@037c`0
0aon0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000
o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0003d00003<0000H0003d000030000?@00001@000m00000`0003d00000D000?@0000<0000m00
00050003d000030000G@7alO00037`03d000030000?@00001@000m00000`0003d00003@0000I0003
d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O00<0d000
;P02d0T000?@0000;P000m00000e00006P000m00000[0003d00000X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002`000?@0000
=P0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@
>@0001d00]0U00;@4P02d2H000?@00004@000m00000T0003d000014000?@000090000m00000200<O
10037`D000?@000090000m00000A0003d00002@00]0900?o;`0001l000?@00008@000m00000D0003
d000028000?@00004`000m00000R0003d00001<000?@00008P000m00000300<O10037`H000?@0000
8P000m00000C0003d000028000?@00001005o`:000?o0000;@0002000]0O00;@6002d2000]0G00;@
8002d1L00]0P00;@5`03d1l00]0G00?@7`02d0801Ol01X30P<20`0;o;`0002800m0J00;@7003d1X0
0m0K00?@6P03d1/00m0J00?@7002d1X00m0L00;@6P03d0Co2X001?n0P?l^00009@02d1D00m0Q00;@
5P02d2400]0F00;@8@03d1D00]0Q00?@5@02d2400m0E00;@0ol04/20`830P<20`830P<20oh30obh0
000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h01=0;00K@9P05d0X0
1]0BP005oh20P?l0;P0000l00alJ00_@<00;d3002m0`00_@4`037`D00alB00_@<@0:d00Mol20`830
P<20`830P<20`830P<20`83oP<20`?l0;P0000l00aoY00<O1@037e001OlJP003oh2000>000?o0000
:`000?l0D`04o`0VP<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P?l]0000o`1>00Go
8H000on0P005P003o`0002/0003o04T01Ol0;l20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`83o02d0003o04D01?lZP003oh2000N000?o0000:P000?l0@005o`0iP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<3o02`0000?00<O
jP037`<00ale00Go<X000on0P008P003o`0002X0000?00<OjP037`<00alc00;o04>0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<3o02`0
000?00<OjP037`<00alc0004oh3ooc>000?oP8002X000ol0000Z0000o`0i0016ol20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20ob/0
003o03X000CoP8200_l_P003oh2000b000?o0000:@000?l0>P001_n0`830P0;o03g0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`83o02/0003o03X0
00?oP8001H000on0P00YP003oh2000f000?o0000:@000?l0>P002On0`830P<20`002o`0kP<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`?l0:P000180
0aoZ00<O=`000on0P008P0;o9X000on0P00?P003o`0002P0000B00<OjP037cP004Go`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<20`?l0
:P0001800aoZ00<O>0000on0P00:P0;o8H000on0P00AP003o`0002P0003o03/000oo`830P<20`830
P<20`8000_l0=L20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`83o02T0003o03/000?oP8003X000on0P00KP003oh2001>000?o00009`000?l0?0004On0`830P<20
`830P<20`83000;o03:0`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20obT0003o03`000?oP8004802oaR000?oP80058000ol0000W0000o`0l0016oh30P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830obP0
003o03`000?oP8004h02oa>000?oP8005h000ol0000V00005`037n000al700<O=0006?n0`830P<20
`830P<20`830P<20`830P0;o02c0P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`830obP0000G00<Oh0037`L00ale0003oh2001J000?oP8003H000on0P00HP003o`0002H0000G00<O
h0037`L00ale000Jol20`830P<20`830P<20`830P<20`830P<02o`0ZP<20`830P<20`830ol20`830
P<20`830P<20`830P<20`830P<20`83o9`000?l0?@000on0P00IP0;o2X000on0P00JP003o`0002D0
003o03d004Ko`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`83oP<20`830P<20`830
P<20`830P<20`830P<20`83o9`000?l0?P000on0P00KP0;o1H000on0P00LP003o`0002D0003o03h0
023oP<20`830P<20`830P<20`830P<20`830P<20`830P0;o02?0P<3o`830P<20`830P<20`830P<20
`830P<20`830P<20o`0W0000o`0n0003oh2001n000?oP?l088000ol0000T00000P0Lo`<Od_l37aCo
0amiob<0000N00<OdP037a@00al`0003oh2001n01?lOP003o`0002@0000N00<OdP037a@00ala000Q
ol20`830P<20`830P<20`830P<20`830P<20`830P<2000?o0260ooo0P<20`830P<20`830P<20`830
P<20`830P<20`?l09P000?l0?`000on0P00MP003oh2000B00_lLP003o`0002<0003o03l004Ko`830
P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`83o9@000?l0?`000on0P00LP003oh2000R00_lIP003o`0002<0003o040004GoP<20`830P<20
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P?l0
9@0002H00ao200<O90037bX000?oP8006X000on0P00<P0;o5h000ol0000R00009P037l800alT00<O
:P00;_n0`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`802o`0F`830P<20
`830P<20`830P<20`830ob@0000V00<O`P037b@00alZ0003oh2001R000?oP8004X000on0P00BP003
o`000280003o0400037oP<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`83000;o01>0`830P<20`830P<20`830P<3o02@0003o044000?oP8005X000on0P00FP003oh200120
00?o00008@000?l0@@00<oo0P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P002o`0A`830P<20`830P<20`830P?l08`000?l0@@000on0P00EP003oh2001Z00_l>P003
o`000240003o044004Ko`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830
P<20`830P<20oh30P<20`830P<20`83o8`000?l0@P000on0P00BP003oh2001n00_l<P003o`000200
000`00<O[P037cP00alR0016oh30P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<20`830ol20`830P<20`830ob80000`00<O[P037cP00alR0003oh20016000?oP800
8h02o`V000?o0000800003000an^00<O>0037b8003coP<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`802o`08`830P<20`?lR0000o`120003oh200120
00?oP800:8000on0P004P003o`000200003o04<003ko`830P<20`830P<20`830P?n0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`0;o00J0`830P?lQ0000o`130003oh2000f0
00?oP800;H000on0P002P003o`0001l0003o04<0047o`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P002o`03`83o0240003o04<000?oP800
38000on0P00aP0?o8@0003`00anF00<OD0037aP004CoP<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0;o800003`00anF00<OD0037aP0
00?oP8002X000on0P00cP0?o800003`00anF00<OD0037aP003koP<20`830P<20`83oP<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P0Go8`000?l0A0000on0P008P003
oh2002^01OlX0000o`14000doh30P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P0Go;@000?l0A@000on0P006P003oh2002>01?lb0000o`15000Zol20`830P<3o`830
P<20`830P<20`830P<20`830P<20`830P<20`8301Olf0000o`150003oh2000F000?oP8006X05oc/0
001:00<ON`037f/00al;000Qol20`830P?n0`830P<20`830P<20`830P<20`830P<2000Co@00004X0
0amk00<OJ`037``000?oP8000X000on0P00CP0GoA00004X00amk00<OJ`037``001KoP<20`?o0P<20
`830P<20`830P<201Om90000o`160005oh20P?l03805odh0003o04H000goP<3o`830P<20`83000Co
D`000?l0AP001?n0P?l4P0GoE`0005T00amL00<ORP037`GoG00005T00amL00<ORP037f40001I00<O
G0037hX00amQ0000o`2Z0000J@037c`00aon0000J@037c`00aon0000J@037c`00aon0000N@037`d0
0al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000



\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@0000<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0d0004d00000;o<00001P000?@0000<0000m0000050003d000030000?@00001@000m00000`0003
d00000D000?@0000<0001M0O7al000<O00?@0000<0000m0000050003d000030000?@00000_l00l3o
000_00006@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00000]00;@00D07alO
00037`030=0002h00]090003d00002h000C@oooo0X000on0o`0_00006P000m00000[0003d00000X0
00?@0000:`000m00000:0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00
000:0003d00002`000[@oh30P<20oh3o;`0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@
0P037`@00al200?@:002d0h00m0Y00;@1h001?n0P?l^00007@02d2D00]0B00;@9P000m00000A0003
d00002@000?@00004@000m00000T0003d00000800al400<O1@000m00000T0003d000014000?@0000
9002d00=P<20`830P<3o`830o`0^00007`000m00000Q0003d00001@000?@00008P000m00000C0003
d000028000?@00004`000m00000R0003d00000<00al400<O1P000m00000R0003d00001<000?@0000
8002o`03d82000R000?oP8000X000ol0000[00008002d1l00]0H00;@8002d1L00]0P00;@5`02d200
0]0G00?@7`02d1L00m0M00;o0]004L20`830P<20`83oP<20`83o02d0000R00?@6P02d1`00m0J00?@
6`03d1X00m0K00?@6P03d1`00]0J00?@7002d1T000Cod=3@38000on0P003P003o`0002/0000U00;@
5@03d2400]0F00;@8@02d1H00]0Q00?@5@02d2400m0E00;@8@03d1@001[od=20`830P<20`830P<20
`83oP<20`830ob`0000?00<O5@05d0/01M0V00G@2`06d2D01M0;00K@9P04d0/01]0=00<O1@037`h0
1=0;00K@9P05d0X01]0@P003oh2000F000?o0000:P0000l00alJ00_@<00;d3002m0`00_@4`037`D0
0alB00_@<@0:d0;o01j0`830P<20`830P<20`830P<20`?o0P<20`830P?l[00003`037nT00al500<O
EP02oaF000?oP8001h000ol0000Y0000o`1J00?o02>0`830P<20`830P<20`830P<20`830P?n0`830
P<20`830o`0Z0000o`1H00;o6X000on0P008P003o`0002P0003o05H00_l0:L20`830P<20`830P<20
`830P<20`830P<20`?o0P<20`830P<20`83o02T0003o05@00_lMP003oh2000Z000?o00009`000?l0
D@03o`0^`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830obP0000?00<O
jP037`<00am900;o8H000on0P00<P003o`0002H0000?00<OjP037`<00am700;o03>0`830P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`?l0:00000l00aoZ00<O0`037dD0
0_lTP003oh2000j000?o00009@000?l0B003o`0hP<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<20`830P?lW0000o`1600;o:8000on0P00@P003o`0002@0003o04@0
0_l0?/20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20
`830P<3o9P000?l0@P02obb000?oP8004H000ol0000S0000o`0o00?o04?0P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`83o02D0000B00<O
jP037cX00_l`P003oh2001>000?o00008P0001800aoZ00<O>@02o`18`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<3o90000180
0aoZ00<O>@000on0o`02obf000?oP8005H000ol0000Q0000o`0m0004ol20`0?o04?0P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`83o02<0
003o03d000?oP8001803obJ000?oP8005h000ol0000P0000o`0n0009oh30P<20`83000;o03n0`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`?l0
8P000?l0?P000on0P008P0?o8H000on0P00GP003o`000200003o03l000go`830P<20`830P<2000?o
03Z0`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`83o
8@000?l0?`000on0P00=P0?o6X000on0P00IP003o`0001l0000G00<Oh0037`L00alg000Col20`830
P<20`830P<20`830P002o`0f`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<20`830P<3o800001L00aoP00<O1`037cP000?oP8004H03oaB000?oP8006h000ol0000N0000
5`037n000al700<O>0005on0`830P<20`830P<20`830P<20`83000?o0370P<20`830P<20`830P<20
`?o0P<20`830P<20`830P<20`830P<20`830P<20`83o01l0003o044000?oP8005X03o`f000?oP800
7H000ol0000M0000o`11000Lol20`830P<20`830P<20`830P<20`830P<20`0;o02f0`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`?l07P000?l0@P000on0P00JP0?o1h000on0
P00OP003o`0001`0003o0480023oP<20`830P<20`830P<20`830P<20`830P<20`830P0?o02R0`830
ol20`830P<20`830P<20`830P<20`830P<20`830P<20`83o7@000?l0@`000on0P00OP0?o00>0oh00
8H000ol0000K00000P0Lo`<Od_l37aCo0amio`06P<20`83o7@0001h00aoB00<O50037cH000?oP800
8806ob2000?o00006P0001h00aoB00<O50037cH002?oP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`003o`03`83000?o01k0P<20`830P<20`830P<20`830P<20`830P<20`?lL0000o`140003
oh20022000?oP8001X03oa^000?o00006@000?l0A@00;_o0P<20`830P<20`830P<20`830P<20`830
P<20`830P<3o`830P<20`830P<02o`0JP<20`830P<20`830P<20`830P<20`830P?lK0000o`150003
oh2001j000?oP8003803oaN000?o000060000?l0AP00<_n0`830P<20`830P<20`830P<20`830P<20
`830P<20oh30P<20`830P<20`830P<200ol05H30P<20`830P<20`830P<20`830o`0J00009P037l80
0alT00<O<0000on0P00LP003oh2001>00olBP003o`0001L0000V00<O`P037b@00ala000gol20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P002o`0A`830P<20
`830P<20`830P?l06@0002H00ao200<O90037c4000?oP8006h000on0P00HP0?o3X000ol0000F0000
o`18000koh30P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20
`830P<000ol03<20`830P<20`830oaP0003o04P000?oP8006H000on0P00OP0?o28000ol0000F0000
o`190010ol20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<20`0;o00R0`830P<20oaL0003o04T000?oP8005h000on0P00UP0?o18000ol0000E0000
o`1:0014oh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`803o`03P<3o01H0003o04X000?oP8005H000on0P00/P0?o5P0003000an^00<O
>0037bX004WoP<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<20`83000;o5@0003000an^00<O>0037b/000?oP8004h000on0P00]P0;o
5`0003000an^00<O>0037b/004?o`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<2000?o6@000?l0C0000on0P00BP003oh2002R00_lL0000
o`1<000noh30P<20`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`802oah0003o04d000?oP80048000on0P00UP0;o80000?l0C@00>?o0P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8300olR0000o`1>0003oh2000j0
00?oP8008H02obD0000l00<OUP037e000alR000coh30P<20`830P<20`830P<3o`830P<20`830P<20
`830P<20`830P<20`830P<20`83000;o9`0003`00anF00<OD0037b<000?oP80038000on0P00NP0;o
:@0003`00anF00<OD0037b<002go`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830
P<20`8000ol[0000o`1?0003oh2000b000?oP8006H02obh0003o050002SoP<20`830P<20`830ol20
`830P<20`830P<20`830P<20`830P<200_l`0000o`1@0003oh2000Z000?oP8005H03oc80003o0540
02;o`830P<20`830P?n0`830P<20`830P<20`830P<20`8300_le0000o`1A0003oh2000R000?oP800
4X02ocL0001:00<ON`037f/00alH000Moh30P<20`830P?n0`830P<20`830P<20`830P<000_li0000
BP037g/00am[00<O60000on0P006P003oh2000j00olk0000BP037g/00am[00<O6@005oo0P<20`830
ol20`830P<20`830P<2000;o?P000?l0D`000on0P004P003oh2000^00_m00000o`1D000Boh30P<20
oh30P<20`830P<200_m20000o`1D0003oh2000>000?oP8001X03od@0001I00<OG0037hX00al;000=
oh30P<3o`830P<20`002odL0001I00<OG0037hX00al<0005oh20P?l01H02odT0001I00<OG0037hX0
0al<0008ol20oh30P<02od/0003o05H000CoP?n00om=0000J@037c`00anZ00<O00?o0000CP0006T0
0all00<OZP037e40001Y00<O?0037jX00amA0000N@037`d00al<00<Oo`0?0000N@037`d00al<00<O
o`0?0000N@037`d00al<00<Oo`0?0000o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@<P0001D0
00?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000?@`?l0<P0001H0
0]0d0003d00000800]0d0003d00000800]0d0003d00000800]0d0005d1lO01l00]0d0003d0000080
0]0c0004om20P0;o<@0001P000?@0000<0000m0000050003d000030000?@00001@000m00000`0003
d00000D000?@0000<0001M0O7al000<O00?@0000<0000m0000050003d00002l000Sod<20`?o0oc00
000I0003d00002d00]090003d00002d00]090003d00002d00]090003d00002d00]001@0O7al000<O
00<0d000;P02d0T000?@0000;@000oo@P002P005oh20P?l0;`0001X000?@0000:`000m00000:0003
d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/000?@0000
2P000m00000Z00;o00[@`830P?n0`83o;`0001/00]0Y00;@3P02d2T00]0>00?@:002d0h00m0X00;@
0P037`@00al200?@:002d0h00m0X0003om3@00F000?oP8000X000ol0000/00007@02d2D00]0B00;@
9P000m00000A0003d00002@000?@00004@000m00000T0003d00000800al400<O1@000m00000T0003
d000014000?@00008`004Oo@d830P<20`83oP<20`83o02d0000O0003d000024000?@000050000m00
000R0003d00001<000?@00008P000m00000C0003d000028000?@00000`037`@00al60003d0000280
00?@00004`000m00000Q0003om2000R000?oP80018000ol0000Z00008002d1l00]0H00;@8002d1L0
0]0P00;@5`02d2000]0G00?@7`02d1L00m0N000Eom3@`830P<20`830ol20`830P<3o02`0000R00?@
6P02d1`00m0J00?@6`03d1X00m0K00?@6P03d1`00]0J00?@7002d1X00m0;P003oh2000J000?o0000
:@0002D00]0E00?@8@02d1H00]0Q00;@5P02d2400m0E00;@8@03d1D00]0Q00?@5@02d00Iol20`830
P<20`830P<3o`830P<20`830o`0Z00003`037aD01M0;00G@9P05d0/01]0U00G@2`06d2H01=0;00K@
3@037`D00al>00C@2`06d2H01M0:00K@0_l>P003oh2000N000?o0000:00000l00alJ00_@<00;d300
2m0`00_@4`037`D00alB00_@<@0:d0D001goP<20`830P<20`830P<20`?o0P<20`830P<20o`0Y0000
3`037nT00al500<OF`02oa6000?oP8002H000ol0000V0000o`1Q000Rol20`830P<20`830P<20`830
P?n0`830P<20`830P<20obL0003o060000?oP8004H000on0P00;P003o`0002D0003o05h00_l09<20
`830P<20`830P<20`830P<20oh30P<20`830P<20`830obH0003o05d000?oP80058000on0P00=P003
o`0002<0003o05/00_l0:H30P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830P<3o02@0
000?00<OjP037`<00amD0003oh2001N000?oP8003X000ol0000R00003`037nX00al300<ODP02o`0]
`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`83o02<0000?00<OjP037`<0
0amA0003oh2001V000?oP8004H000ol0000P0000o`1F000coh30P<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`83o0240003o05@00_lMP003oh2001:000?o00007`000?l0
D`00=oo0P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`?l0
80000?l0D@02oan000?oP8005H000ol0000M0000o`1@000loh30P<20`830P<20`830P<20`830P<20
`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<3o7P0001800aoZ00<OB`02ob:000?oP800
5X000ol0000L00004P037nX00am:0010ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P?n0`830P<20`830P<20`830P<20`830P<20oad0000B00<OjP037dT000?oP8008h000on0P00HP003
o`0001X0003o04X00_l0@/20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20oh30P<20
`830P<20`830P<20`830P<20`830oa`0003o04T000?oP8009H000on0P00JP003o`0001T0003o04L0
0_l0Ah30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830
P<20`830P<20`830P<3o01X0003o04H000?oP800:8000on0P00LP003o`0001L0003o04D004co`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830
P<20`830P<20`83o6@000?l0@`02obb000?oP8007H000ol0000F00005`037n000al700<O>P00DOn0
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20
`830P<20`830P<20`830P<20o`0G00005`037n000al700<O>@04ob^000?oP80088000ol0000D0000
5`037n000al700<O>@001?o0P<07o`18`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<3o5P000?l0@P000on0P007P0Ko7X000on0
P00QP003o`0001<0003o04<000oo`830P<20`830P<20`8001ol0?H30P<20`830P<20`830P<20`830
P<20oh30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l050000?l0A0000on0P00BP0Oo
48000on0P00SP003o`000140003o04@001coP<20`830P<20`830P<20`830P<20`830P<201_l0<L20
`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P?l04`000?l0A@000on0
P00NP0Oo0X000on0P00UP003o`000100000201co0aoBo`<O5?l37gWo01:0`830P<20`830P<20`830
P?lA00007P037m800alD00<O>@000on0P00TP0?o0X06oan000?o00003`0001h00aoB00<O50037cT0
02Oo`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`8000ol02830P<20`8301_l06h30
P<20`830P<20`830P<20`830P<20`830o`0@0000o`180003oh2002B000?oP8003H06oaF000?o0000
3@000?l0B@00??o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83oP<20`830P<20`830
P<20`830P<20`0Go01;0P<20`830P<20`830P<20`?l>0000o`190003oh2002:000?oP8006H06o`^0
00?o000030000?l0BP00A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P?n0`830P<20
`830P<20`830P<20`830P<20`830P<20`806o`07`830P<20o`0=00009P037l800alT00<O=@000on0
P00PP003oh2002F01_l00h3o000;00009P037l800alT00<O=P00D?n0`830P<20`830P<20`830P<20
`830P<20`830P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20
0ol;00009P037l800alT00<O=P000on0P00OP003oh2002^000?o00002`000?l0C@00COo0P<20`830
P<20`830P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`830P<2000;o3P000?l0CP000on0P00LP003oh2002V000?o00003P000?l0C`00B_o0P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`83o4@000?l0C`000on0P00KP003oh2002J00_lB0000o`1@0016oh30P<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830oa@0003o0540
00?oP8006H000on0P00SP0;o5@0003000an^00<O>0037c80047oP<20`830P<20`830P<20`830P<20
`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`0G0000<0037jh00alh00<O
<P000on0P00GP003oh2002600_lH0000<0037jh00alh00<O<`00?Oo0P<20`830P<20`830P<20`830
P<20`83oP<20`830P<20`830P<20`830P<20`830P<20`830P<20`?l06P000?l0E0000on0P00EP003
oh2001n000?o00006@000?l0E@00=oo0P<20`830P<20`830P<20`830P<20oh30P<20`830P<20`830
P<20`830P<20`830P<20`8000_lL0000o`1E0003oh2001B000?oP80078000ol0000L0000o`1F000c
oh30P<20`830P<20`830P<20`830P?n0`830P<20`830P<20`830P<20`830P<20`83000;o7`000?l0
E`000on0P00BP003oh2001V000?o00007`0003`00anF00<OD0037b/0037o`830P<20`830P<20`830
P<20`?o0P<20`830P<20`830P<20`830P<20`830P<3o0280000l00<OUP037e000al/0003oh200120
00?oP8005h02ob<0000l00<OUP037e000al]000/ol20`830P<20`830P<20`830ol20`830P<20`830
P<20`830P<20`830P?lU0000o`1J0003oh2000j000?oP8005802obH0003o05X002SoP<20`830P<20
`830P<20`?o0P<20`830P<20`830P<20`830P<3o:0000?l0F`000on0P00=P003oh2001600_lY0000
o`1L000Soh30P<20`830P<20`830ol20`830P<20`830P<20`830P?l0:`000?l0G@000on0P00:P003
oh20012000?o0000:P0004X00amk00<OJ`037b<001ko`830P<20`830P<20oh30P<20`830P<20`830
P<02obd0001:00<ON`037f/00alT0003oh2000V000?oP8003H000ol0000]0000BP037g/00am[00<O
9@006Oo0P<20`830P<20oh30P<20`830P<20`8000_l`0000o`1P0003oh2000N000?oP8002X000ol0
000`0000o`1P000Eoh30P<20`830P?n0`830P<20`83000;o<`000?l0H@000on0P005P003oh2000R0
00?o0000<`0005T00amL00<ORP037aT001;oP<20`830ol20`830P<20`?lf0000F@037e`00an:00<O
6@000on0P004P003oh2000F00_lg0000F@037e`00an:00<O6P003_o0P<20`?o0P<20`83o>@000?l0
I0000on0P002P003oh2000:00_lj0000J@037c`00anZ00<O30002Oo0P<3o`830o`0l0000J@037c`0
0anZ00<O30001On0P83o00:000?o0000>`0006T00all00<OZP037`d000CoP?n00_ln0000N@037`d0
0al<00<ObP037`03o`0003h0001i00<O3@037``00ao:00<O@@0007T00al=00<O30037lX00am10000
o`2Z0000o`2Z0000


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  CellTags->"AnimatingGraphics"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Y0000IPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0ZP000?l0ZP000?l0ZP000?l0ZP000?l0
ZP000?l0ZP000?h011nW000050000m00000g00;@>@02d3T00]0h00047m3@7cP00]0i00;@00?o0000
;`0001D000?@0000=@001=000=0g0004d000d3L000C@003@=`001=0O7m0g0004d000d3L000G@`?o0
o`0`00005P02d3@000?@00000P02d3@000?@00000P02d3@000?@00000P02d3@000G@7al07`02d3@0
00?@00000P02d3@000C@P83o0X000ol0000]000060000m00000`0003d00000D000?@0000<0000m00
00050003d000030000?@00001@000m00000`0005d1lO7`000al00m00000`0003d00000D000?@0000
<0002M30P<3o`830o`0^00006@000m00000]00;@2@000m00000]00;@2@000m00000]00;@2@000m00
000]00;@00D07alO00037`030=0002h00]090003d00002h000?@P8000X000on0P002P003o`0002/0
000J0003d00002/000?@00002P000m00000[0003d00000X000?@0000:`000m00000:0003d00002/0
00?@00002P000m00000[0003d00000X000?@0000;0003M30P<20`?o0P<20`?l0;00001/00]0Y00;@
3P02d2T00]0>00?@:002d0h00m0X00;@0P037`@00al200?@:002d0h00m0Y00;@1X000on0P004P003
o`0002T0000M00;@9@02d1800]0V0003d000014000?@000090000m00000A0003d00002@000?@0000
0P037`@00al50003d00002@000?@00004@000m00000T00;@017o`830P<20`?o0P<20`830o`0Z0000
7`000m00000Q0003d00001@000?@00008P000m00000C0003d000028000?@00004`000m00000R0003
d00000<00al400<O1P000m00000R0003d00001<000?@00008P000m00o`08P003oh2000J000?o0000
9`0002000]0O00;@6002d2000]0G00;@8002d1L00]0P00;@5`03d1l00]0G00?@7`02d00F0?o0P<20
`830P<3o`830P<20`830obP0000R00?@6P02d1`00m0J00?@6`03d1X00m0K00?@6P03d1`00]0J00?@
7002d1X00m020003oh2000R000?oP80028000ol0000U00009@02d1D00m0Q00;@5P02d2400]0F00;@
8@03d1D00]0Q00?@5@02d2400m0E00;@10006Oo0P<20`830P<20`?o0P<20`830P<20`?l09P0000l0
0alE00G@2`05d2H01M0;00K@9@05d0/01]0V00C@2`06d0d00al500<O3P04d0/01]0V00G@2P06d0D0
00?oP8002X000on0P00:P003o`0002<0000?00<O6P0;d3002m0`00_@<00;d1<00al500<O4P0;d340
2]0:000Mol20`830P<20`830P<3o`830P<20`830P<20`?l0900000l00aoY00<O1@037f4000?oP800
38000on0P00<P003o`000240003o06H00_l08<20`830P<20`830P<20`?o0P<20`830P<20`830P<3o
8P000?l0I@000on0P00?P003oh2000j000?o00007`000?l0I0009_n0`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<3o80000?l0H`000on0P00AP003oh20012000?o00007@000?l0HP00:_n0
`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830oah0000?00<OjP037`<00amK0003
oh2001>000?oP8004X000ol0000K00003`037nX00al300<OFP00;_n0`830P<20`830P<20`830P<20
`830ol20`830P<20`830P<20`830P<20`?lL00003`037nX00al300<OF@000on0P00EP003oh2001B0
0_lJ0000o`1N000coh30P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20
`83o01T0003o05d000?oP8005h000on0P00GP003o`0001H0003o05`003OoP<20`830P<20`830P<20
`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`83o01L0003o05/000?oP8006H000on0
P00IP003o`0001@0003o05X003_oP<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20
`830P<20`830P<20`830P<20o`0E00004P037nX00amF0003oh2001^000?oP8006h000ol0000B0000
4P037nX00amE000ooh30P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20
`830P<20`830P<20`83o01<0000B00<OjP037e<00_lOP003oh2001f000?o000040000?l0E@00A?o0
P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830
P<20`83o4@000?l0E0000on0P00PP003oh2001n000?o00003P000?l0D`00B?o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20o`l0
003o058000?oP8008X000on0P00QP003o`0000`0003o054004co`830P<20`830P<20`830P<20`830
P<20`830P<20`830P<20`?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o3@000?l0
D0000on0P00TP003oh2002>000?o00002P0001L00aoP00<O1`037dL0053o`830P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20o`/0000G00<Oh0037`L00am60003oh2002J000?oP8009H000ol0000800005`037n000al700<O
A@00E?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830P<20`830
P<20`830P<20`830P<20`830P<20`830P<20o`T0003o04`000?oP800:8000on0P00WP003o`0000H0
003o04/005So`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`?o0P<20`830
P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o1`000?l0BP000on0P00ZP003oh2002V0
00?o000010000?l0B@00G?o0P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<3o`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<20`83o1@000?l0B0000on0
P00/P003oh2002^000?o00000P0000807?l37m;o0alDo`<OVOl300007P037m800alD00<O>`000on0
P00ZP0?o:h000ol0000300007P037m800alD00<O?000;?n0`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`830P<200ol0:h30P<20`830P<20`830P<20`830P<20`830P<20`830P<20`830
P<20`?l01P000?l0B`000on0P00YP003oh2002R000?o00001@000?l0C000E_n0`830P<20`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<3o20000?l0C@000on0P00WP003oh2002J000?o00001`000?l0CP00D_n0`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830P<20`830P<20`?l:00009P037l800alT00<O>@000on0P00UP003oh2002B000?o00002@0002H0
0ao200<O90037cX004koP<20`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o`830P<20
`830P<20`830P<20`830P<20`830P<20`830P<20`?l<00009P037l800alT00<O>`000on0P00SP003
oh2002:000?o00002`000?l0DP00B_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o
`830P<20`830P<20`830P<20`830P<20`830P<20`830P<3o3P000?l0D`000on0P00QP003oh200220
00?o00003@000?l0E000A_n0`830P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20
`830P<20`830P<20`830P<20`830P<20`?l@0000o`1E0003oh2001n000?oP8007X000ol0000?0000
o`1F0012oh30P<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20
`830P<20`830P<3o4P000?l0E`000on0P00MP003oh2001b000?o00004@0003000an^00<O>0037cP0
03koP<20`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`830oa@0000`00<O[P037cP00ali0003oh2001^000?oP8006X000ol0000C0000<0037jh00alh00<O
>P00>_n0`830P<20`830P<20`830P<20`830P<20`830ol20`830P<20`830P<20`830P<20`830P<20
`?lF0000o`1K0003oh2001V000?oP80068000ol0000E0000o`1L000foh30P<20`830P<20`830P<20
`830P<20`830ol20`830P<20`830P<20`830P<20`830P<3o60000?l0G@000on0P00GP003oh2001J0
00?o00005`000?l0GP00<_n0`830P<20`830P<20`830P<20`830P<3o`830P<20`830P<20`830P<20
`830P<3o6P000?l0G`02oaJ000?oP80058000ol0000I0000?0037iH00am@00<O=@00;Oo0P<20`830
P<20`830P<20`830P<3o`830P<20`830P<20`830P<20`830o`0L0000?0037iH00am@00<O=P000on0
P00BP003oh2001:000?o00006`0003`00anF00<OD0037cL002Wo`830P<20`830P<20`830P<20`?o0
P<20`830P<20`830P<20`830o`0N0000o`1T0003oh20012000?oP80048000ol0000M0000o`1U000U
ol20`830P<20`830P<20`830ol20`830P<20`830P<20`830o`0P0000o`1V0003oh2000j000?oP800
3X000ol0000O0000o`1W000Qol20`830P<20`830P<20`?o0P<20`830P<20`830P<3o0280003o06P0
00?oP80038000on0P00<P003o`000240001:00<ON`037f/00al_000Mol20`830P<20`830P<3o`830
P<20`830P<20`?l0900004X00amk00<OJ`037c0000?oP8002X000on0P00:P003o`0002<0001:00<O
N`037f/00ala000Iol20`830P<20`830ol20`830P<20`830o`0V0000o`1/0003oh2000R000?oP800
28000ol0000U0000o`1]000Eol20`830P<20`?o0P<20`830P<3o02P0003o06h000?oP8001X000on0
P006P003o`0002L0001I00<OG0037hX00alV000Aol20`830P<3o`830P<20`?l0:P0005T00amL00<O
RP037bL000?oP80018000on0P004P003o`0002T0001I00<OG0037hX00alX000=ol20`830ol20`830
o`0/0000o`1b0003oh2000:000?oP8000X000ol0000[0000J@037c`00anZ00<O6P002Oo0P<3o`830
o`0^0000J@037c`00anZ00<O6`001?n0P?l2P003o`0002d0001Y00<O?0037jX00alL0005ol3o`?l0
<00007T00al=00<O30037lX00al=00<O<@0007T00al=00<O30037lX00al=00<O<@0007T00al=00<O
30037lX00al=00<O<@000?l0ZP000?l0ZP000001


\
\>"], "PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{425, 102.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.08,
  AnimationCycleOffset->-1,
  AnimationCycleRepetitions->Infinity,
  CellTags->"AnimatingGraphics"]
}, Closed]],

Cell["\<\
Square rolling on catenaries. Animation courtesy of Stan \
Wagon.\
\>", "Caption",
  CellTags->"AnimatingGraphics"]
}, Closed]],

Cell[CellGroupData[{

Cell["Playing Sounds", "Subsection",
  CellTags->"PlayingSounds"],

Cell[TextData[{
  "To play a sound, select the cell containing the sound graphic and then \
choose",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Play Sound",
    ButtonData:>"Play Sound",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  StyleBox[" ", "SR"],
  "from the Cell menu (Windows and Macintosh only)."
}], "EmphasisText",
  CellTags->"PlayingSounds"],

Cell["\<\
You can also play a sound by double-clicking the speaker-shaped \
icon at the top of the cell\[CloseCurlyQuote]s bracket. \
\>", "Text",
  CellTags->"PlayingSounds"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sampled sound
1 string
8192 16384 8
{ currentfile 1 index readhexstring pop }
 false 1 sampledsound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pop
% End of sampled sound
% End of Graphics
MathPictureEnd
\
\>"], "Sound",
  Evaluatable->False,
  FormatType->StandardForm,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False,
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-0.0270276, -0.0250052, \
0.00375109, 0.00606938}},
  CellTags->"PlayingSounds"]
}, Closed]],

Cell[CellGroupData[{

Cell["Magnifying the Display", "Subsection",
  CellTags->"DisplayCharacteristics"],

Cell[TextData[{
  "To magnify the notebook display, use the pop-up menu at the bottom of the \
window or the ",
  StyleBox[ButtonBox["Magnification",
    ButtonData:>"Magnification",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  StyleBox[" command ", "SR"],
  "in the Format menu. "
}], "EmphasisText",
  CellTags->"DisplayCharacteristics"],

Cell[TextData[{
  "You can also change the notebook's appearance on the screen by changing \
the style environment. Each style environment corresponds to a minor \
variation of the same basic style. (See",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Screen Style Environment",
    ButtonData:>"Screen Style Environment",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" i", "SR",
    FontFamily->"Times"],
  "n the Format menu.)"
}], "Text",
  CellTags->"DisplayCharacteristics"]
}, Closed]],

Cell[CellGroupData[{

Cell["Printing", "Subsection",
  CellTags->"Printing"],

Cell[TextData[{
  "To print a complete notebook, choose",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Print...",
    ButtonData:>"Print...",
    ButtonStyle->"OtherInformationLink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[" ", "SR",
    FontFamily->"Times",
    FontSize->14],
  "in the File menu. To print a part of a notebook, first select cells within \
the notebook and then choose",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Print Selection...",
    ButtonData:>"Print Selection",
    ButtonStyle->"OtherInformationLink"],
    FontSize->14,
    FontWeight->"Bold"],
  "."
}], "EmphasisText",
  CellTags->"Printing"],

Cell[TextData[{
  StyleBox["Note: ",
    FontWeight->"Bold"],
  "Notebooks are optimized separately for viewing onscreen or printing, so a \
notebook may look different in print than it did on screen.  (See",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Screen Style Environment",
    ButtonData:>"Screen Style Environment",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" ", "SR"],
  "and",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Printing Style Environment",
    ButtonData:>"Printing Style Environment",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica"],
  StyleBox[" i", "SR",
    FontFamily->"Times"],
  "n the Format menu.)"
}], "Text",
  CellTags->"Printing"]
}, Closed]],

Cell[CellGroupData[{

Cell["Getting Help", "Subsection",
  CellTags->"UsingHelp_SA"],

Cell[TextData[{
  "To view help information, choose the",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Help Browser...",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  StyleBox[" ", "SR"],
  "command in the Help menu."
}], "EmphasisText",
  CellTags->"UsingHelp_SA"],

Cell[TextData[{
  "An overview of ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  "'s main features is provided in the Help Browser under ",
  StyleBox["Getting Started",
    FontFamily->"Helvetica"],
  ". A description of all  menu commands and keyboard shortcuts is included \
under ",
  StyleBox["Other Information",
    FontFamily->"Helvetica"],
  ". "
}], "Text",
  CellTags->"UsingHelp_SA"]
}, Closed]],

Cell[CellGroupData[{

Cell["Getting Help", "Subsection",
  CellTags->"UsingHelp"],

Cell[TextData[{
  "To view help information, choose the",
  StyleBox[" ", "SR"],
  StyleBox[ButtonBox["Help Browser...",
    ButtonData:>"Help Browser...",
    ButtonStyle->"OtherInformationLink"],
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  StyleBox[" ", "SR"],
  "command in the Help menu."
}], "EmphasisText",
  CellTags->"UsingHelp"],

Cell[TextData[{
  "Because you are running ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " mode, you have access to the complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " help system. "
}], "Text",
  CellTags->"UsingHelp"],

Cell[TextData[{
  "An overview of the front end is available in the Help Browser under ",
  StyleBox["Getting Started/Demos",
    FontFamily->"Helvetica"],
  ". Detailed information about all aspects of the system is available under \
",
  StyleBox["The Mathematica Book",
    FontFamily->"Helvetica"],
  ". A complete listing of all the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions is presented in ",
  StyleBox["Built-in Functions",
    FontFamily->"Helvetica"],
  ". "
}], "Text",
  CellTags->"UsingHelp"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " and the Web"
}], "Subsection",
  CellTags->"ConfiguringBrowser"],

Cell[TextData[{
  "You can configure your web browser to automatically launch ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " when downloading a notebook from the web. "
}], "EmphasisText",
  CellTags->"ConfiguringBrowser"],

Cell[TextData[{
  "To do this, you must associate ",
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " with the mime type for notebooks. Each browser allows you to set this up \
in different ways. When you are ready to set up the association, use the \
following information. "
}], "Text"],

Cell[TextData[{
  StyleBox["Mime type:  ",
    FontWeight->"Bold"],
  "   ",
  StyleBox["application (or application/mathematica)",
    FontFamily->"Courier"],
  "\n",
  StyleBox["Subtype:",
    FontWeight->"Bold"],
  "         ",
  StyleBox["mathematica",
    FontFamily->"Courier"],
  "\n",
  StyleBox["Extension:",
    FontWeight->"Bold"],
  "      ",
  StyleBox["nb, m, ma",
    FontFamily->"Courier"],
  "\n",
  StyleBox["Application:",
    FontWeight->"Bold"],
  "  ",
  StyleBox["MathReader",
    FontFamily->"Courier"],
  "\n",
  StyleBox["FileType:",
    FontWeight->"Bold"],
  "        ",
  StyleBox["text",
    FontFamily->"Courier"],
  "\n",
  StyleBox["Action:           ",
    FontWeight->"Bold"],
  StyleBox["launch application",
    FontFamily->"Courier"]
}], "Text",
  CellMargins->{{36, Inherited}, {Inherited, Inherited}},
  ParagraphSpacing->{0, 0},
  CellTags->"ConfiguringBrowser"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Licensing\ Information\)], "Subsection",
  FormatType->StandardForm,
  CellTags->"LicensingInformation"],

Cell[TextData[{
  StyleBox["MathReader",
    FontSlant->"Italic"],
  " is licensed free of charge, subject to certain terms and conditions. "
}], "EmphasisText",
  CellTags->"LicensingInformation"],

Cell[TextData[{
  "For more information contact Wolfram Research by email at ",
  ButtonBox["info@wolfram.com",
    ButtonData:>{
      URL[ "mailto:info@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  " or visit us on the web at ",
  ButtonBox["www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"LicensingInformation"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " System"
}], "Subsection",
  CellTags->"MathematicaSystem"],

Cell[TextData[{
  "The complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system consists of a front end, which serves as the user interface, and a \
kernel, which does computations. "
}], "EmphasisText",
  CellTags->"MathematicaSystem"],

Cell[TextData[{
  "Operations such as opening and closing groups of cells, doing animations \
and playing sounds use only a small part of the ",
  StyleBox["Mathematica", "TI"],
  " front end and these operations are supported by ",
  StyleBox["MathReader", "TI",
    FontSlant->"Italic"],
  StyleBox[". ", "TI"],
  "To create and edit notebooks, you need the ",
  StyleBox["Mathematica", "TI"],
  " front end. To do computations within a ",
  StyleBox["Mathematica", "TI"],
  " notebook, you need both the front end and the kernel. "
}], "Text",
  CellTags->"MathematicaSystem"],

Cell[BoxData[GridBox[{
        {
          
          StyleBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"MathReader\\\\\\\"\\\", \
\\\"TI\\\"]\\) \"\>",
            FontFamily->"Times"], 
          
          StyleBox["\<\"reading \\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\
\\\"\\\", \\\"TI\\\"]\\) notebooks \"\>",
            FontFamily->"Times"]},
        {
          
          StyleBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\",\
 \\\"TI\\\"]\\) front end \"\>",
            FontFamily->"Times"], 
          
          StyleBox["\<\"creating and editing \
\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \\\"TI\\\"]\\) \
notebooks \"\>",
            FontFamily->"Times"]},
        {
          
          StyleBox["\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\",\
 \\\"TI\\\"]\\) kernel \"\>",
            FontFamily->"Times"], 
          StyleBox["\<\"doing computations in notebooks \"\>",
            FontFamily->"Times"]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->GrayLevel[0.849989],
  CellTags->"MathematicaSystem"],

Cell["\<\
Programs required for different kinds of operations with notebooks. \
\
\>", "Caption",
  CellTags->"MathematicaSystem"],

Cell[TextData[{
  "For more information about ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", contact Wolfram Research at ",
  ButtonBox["info@wolfram.com",
    ButtonData:>{
      URL[ "mailto:info@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  " or visit us on the web at ",
  ButtonBox["www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"MathematicaSystem"]
}, Closed]]
},
FrontEndVersion->"4.1 for Macintosh",
ScreenRectangle->{{0, 800}, {0, 580}},
ScreenStyleEnvironment->"AllBrackets",
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{550, 551},
WindowMargins->{{Automatic, 39}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]2000 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]2000 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PrintingOptions->{"PrintCellBrackets"->True,
"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions for On-line Help", "Subtitle"],
  
  Cell["\<\
These styles are carefully tuned for all aspects of the online \
help. It's recommended that they remain unchanged.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Subsubsection"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ShowCellBracket->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "AllBrackets"],
    PageWidth->WindowWidth,
    ShowCellBracket->True,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Subsubsection"],
  
  Cell["\<\
  The options defined for the style below will be used at the \
Notebook level.  \
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1999 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1997 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True},
    CellLabelAutoDelete->False,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Headings", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Chapter"],
    CellMargins->{{10, 4}, {4, 24}},
    FontFamily->"Helvetica",
    FontSize->24,
    FontWeight->"Bold"],
  
  Cell[StyleData["Chapter", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->22]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellMargins->{{10, 4}, {12, 18}},
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{24, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellFrameLabelMargins->6,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{16, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionColor"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.297993, 0, 0.454994]],
  
  Cell[StyleData["SubsubsectionColor", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{24, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->8},
    CellGroupingRules->{"SectionGrouping", 50},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubsectionIcon", "Printout"],
    CellDingbat->"\[FilledSquare]",
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{16, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{24, 4}, {0, 8}},
    CellElementSpacings->{"ClosedGroupTopMargin"->4},
    CellGroupingRules->{"SectionGrouping", 60},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubection", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubsubsectionIcon", "Printout"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Text", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["EmphasisText"],
    CellMargins->{{10, 10}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 8},
    FontFamily->"Helvetica",
    FontSize->12,
    FontColor->GrayLevel[0],
    Background->RGBColor[0.839857, 0.679698, 0.996109]],
  
  Cell[StyleData["EmphasisText", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{10, 10}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 8}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CompactText"],
    CellMargins->{{10, 4}, {0, 8}},
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["CompactText", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Compact12Text"],
    CellMargins->{{10, 4}, {0, 8}},
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None],
  
  Cell[StyleData["Compact12Text", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextSans"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["TextSans", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedText"],
    CellMargins->{{20, 4}, {0, 8}},
    ParagraphSpacing->{0, 8},
    ParagraphIndent->-15,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedText", "Printout"],
    CellMargins->{{12, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote"],
    CellMargins->{{35, 4}, {0, 4}},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndentedText"],
    CellMargins->{{20, 4}, {0, 6}},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["IndentedText", "Printout"],
    CellMargins->{{12, 0}, {0, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MathCaption"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{19, 62}, {0, 14}},
    PageBreakBelow->False,
    CellFrameLabelMargins->4,
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8},
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["MathCaption", "Printout"],
    CellMargins->{{9, 0}, {0, 14}},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{10, 4}, {0, 8}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"SmallText",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    TextJustification->1,
    FontSize->7]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Input/Output", "Subsubsection"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{46, 4}, {3, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Printout"],
    ShowCellBracket->False,
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 4}, {4, 2}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->StandardForm],
  
  Cell[StyleData["Output", "Printout"],
    ShowCellBracket->False,
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{47, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Printout"],
    ShowCellBracket->False,
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{47, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Printout"],
    ShowCellBracket->False,
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{47, 4}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultFormatTypeForOutput,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["Graphics", "Printout"],
    ShowCellBracket->False,
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->7,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Name"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Name", "Printout"],
    FontSize->7,
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlinks", "Subsubsection"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks. The others point to the various sections of the help \
browser. These styles will modify individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonFrame->"None",
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLinkMR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLinkMR", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Subsubsection"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[StyleData["JT"],
    StyleMenuListing->None,
    FontFamily->"JFontText"],
  
  Cell[StyleData["JS"],
    StyleMenuListing->None,
    FontFamily->"JFontSans"],
  
  Cell[StyleData["JSB"],
    StyleMenuListing->None,
    FontFamily->"JFontSansBold"],
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MO"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MB"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MBO"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["M4"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Math4",
    CharacterEncoding->"Math4"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1", "Printout"],
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1MR", "Printout"],
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Emphasis Boxes and Pictures", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Box"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["Box", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DoubleBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->2,
    RowAlignments->Top}],
  
  Cell[StyleData["DoubleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["1ColumnBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["1ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->{0.31, 0.62}}],
  
  Cell[StyleData["2ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->0.46}],
  
  Cell[StyleData["2ColumnEvenBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnSmallBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.35,
    ColumnAlignments->{Right, Left}}],
  
  Cell[StyleData["2ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->0.31}],
  
  Cell[StyleData["3ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnSmallBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.24,
    ColumnAlignments->{Right, Center, Left}}],
  
  Cell[StyleData["3ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->{0.13, 0.33, 0.13, 0.33}}],
  
  Cell[StyleData["4ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->0.194}],
  
  Cell[StyleData["5ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnBox"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],
  
  Cell[StyleData["6ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBox"],
    CellFrame->0.5,
    ShowCellBracket->False,
    CellMargins->{{37, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ItemizedNoteBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox"],
    CellFrame->0.5,
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.3, 0.7},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox3Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.2, 0.3, 0.5},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox3Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox4Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.15, 0.35, 0.15, 0.35},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox4Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox5Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->0.2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox5Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox6Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox6Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{11, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    ShowCellBracket->False,
    CellMargins->{{11, 4}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 0}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    ShowCellBracket->False,
    CellMargins->{{11, 4}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BottomBox", "Printout"],
    CellMargins->{{2, 4}, {0, 0}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{11, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopSpanBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    ShowCellBracket->False,
    CellMargins->{{11, 4}, {0, 0}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpanBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Picture"],
    ShowCellBracket->False,
    CellMargins->{{10, Inherited}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Picture", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedPicture"],
    ShowCellBracket->False,
    CellMargins->{{35, 4}, {0, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedPicture", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureGroup"],
    CellMargins->{{10, Inherited}, {0, 8}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureGroup", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Sound"],
    CellMargins->{{10, Inherited}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["Sound", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Caption"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 3}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["Caption", "Printout"],
    CellMargins->{{2, 0}, {0, 3}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Tables", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnTable"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.34, 0.64},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenTable"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->0.49,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnEvenTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnTable"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineOutput"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["InlineOutput", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    ShowCellBracket->False,
    CellMargins->{{42, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    ScriptLevel->0,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    UnderoverscriptBoxOptions->{LimitsPositioning->True},
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    CellMargins->{{34, Inherited}, {Inherited, 10}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayMath"],
    ShowCellBracket->False,
    CellMargins->{{42, 10}, {7, 7}},
    Evaluatable->False,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input"],
  
  Cell[StyleData["DisplayMath", "Printout"],
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedEquation"],
    ShowCellBracket->False,
    CellMargins->{{42, 10}, {7, 7}},
    CellFrameLabels->{{None, Cell[ 
            TextData[ {"(", 
              CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
    DefaultFormatType->DefaultInputFormatType,
    CounterIncrements->"NumberedEquation",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedEquation", "Printout"],
    CellMargins->{{34, 55}, {0, 10}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["EquationNumber"],
    LineSpacing->{1.83, 0}],
  
  Cell[StyleData["EquationNumber", "Printout"],
    LineSpacing->{1.7, 0}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    ShowCellBracket->False,
    CellMargins->{{16, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{8, Inherited}, {Inherited, 10}},
    FontSize->9.5]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Unique Help Browser Styles", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectName"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {1, 10}},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Command"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 14}},
    CounterIncrements->"Section",
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Command", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CharacterName"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 4}},
    CellFrameMargins->4,
    StyleMenuListing->None],
  
  Cell[StyleData["CharacterName", "Printout"],
    CellMargins->{{2, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Usage"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 4}},
    CellFrameMargins->5,
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None],
  
  Cell[StyleData["Usage", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notes"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NotesList"],
    ShowCellBracket->False,
    CellMargins->{{20, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Printout"],
    CellMargins->{{12, 0}, {2, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{11, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    StyleMenuListing->None,
    FontSize->13,
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["ExampleSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleText"],
    ShowCellBracket->True,
    CellMargins->{{20, 40}, {0, 18}},
    ParagraphSpacing->{0, 6},
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["ExampleText", "Printout"],
    CellMargins->{{2, 80}, {0, 8}},
    PageBreakBelow->False,
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSubsection"],
    ShowCellBracket->True,
    CellMargins->{{20, 4}, {0, 16}},
    CellGroupingRules->{"SectionGrouping", 80},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["ExampleSubsection", "Printout"],
    CellMargins->{{12, 0}, {0, 16}},
    PageBreakBelow->False,
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LineHead"],
    CellFrame->{{0, 0}, {0.5, 0}},
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {8, 18}},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["LineHead", "Printout"],
    CellMargins->{{2, 0}, {8, 18}},
    PageBreakBelow->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushInput"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {1, 4}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["FlushInput", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{2, 0}, {1, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushOutput"],
    ShowCellBracket->False,
    CellMargins->{{10, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->StandardForm,
    StyleMenuListing->None],
  
  Cell[StyleData["FlushOutput", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{2, Inherited}, {Inherited, Inherited}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DialogItem"],
    CellDingbat->"\[EmptyDiamond]",
    ShowCellBracket->False,
    CellMargins->{{20, 4}, {0, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["DialogItem", "Printout"],
    CellMargins->{{12, 0}, {0, 12}},
    PageBreakBelow->False,
    FontSize->8]
  }, Closed]],
  
  Cell[StyleData["GroupDivider"],
    ShowCellBracket->False,
    CellMargins->{{10, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->{"TitleGrouping", 0},
    StyleMenuListing->None],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Highlight"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 18}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Highlight", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    LineSpacing->{1, 3}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserNotes"],
    CellFrame->{{2, 0}, {0, 0.25}},
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 4}},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["UserNotes", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MoreInfo"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 4}},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.700008, 0.4, 0.100008]],
  
  Cell[StyleData["MoreInfo", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserTips"],
    CellFrame->{{2, 0}, {0, 0.25}},
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 4}},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.2, 0.500008, 0.700008]],
  
  Cell[StyleData["UserTips", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    LineSpacing->{1, 3},
    FontSize->8,
    Background->GrayLevel[0.700008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Theorem"],
    CellFrame->{{4, 0}, {0, 0}},
    ShowCellBracket->False,
    CellMargins->{{12, 62}, {0, 14}},
    CellFrameMargins->4,
    CellFrameColor->RGBColor[0, 0, 0.8],
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8}],
  
  Cell[StyleData["Theorem", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    CellFrameMargins->3,
    CellFrameColor->GrayLevel[0.8],
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Commentary"],
    CellFrame->{{2, 0}, {0, 0}},
    ShowCellBracket->False,
    CellMargins->{{36, 10}, {7, 7}},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CellFrameColor->RGBColor[0, 0.2, 1],
    LineSpacing->{1, 3},
    ParagraphSpacing->{0, 8},
    FontSlant->"Italic"],
  
  Cell[StyleData["Commentary", "Printout"],
    CellMargins->{{32, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Contents and Index", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsTitle"],
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {0, 18}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["ContentsTitle", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsSection"],
    CellDingbat->"\[FilledSquare]",
    ShowCellBracket->False,
    CellMargins->{{20, 4}, {3, 18}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ContentsSection", "Printout"],
    CellMargins->{{12, 0}, {3, 18}},
    PageBreakBelow->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSection"],
    CellDingbat->"\[FilledSquare]",
    ShowCellBracket->False,
    CellMargins->{{20, 4}, {5, 20}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["IndexSection", "Printout"],
    CellMargins->{{12, 0}, {5, 20}},
    PageBreakBelow->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Contents"],
    ShowCellBracket->False,
    CellMargins->{{21, 4}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["Contents", "Printout"],
    CellMargins->{{13, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Index"],
    ShowCellBracket->False,
    CellMargins->{{21, 4}, {0, 0}},
    ParagraphIndent->-48,
    StyleMenuListing->None],
  
  Cell[StyleData["Index", "Printout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSubentry"],
    ShowCellBracket->False,
    CellMargins->{{36, 4}, {0, 0}},
    ParagraphIndent->-48,
    StyleMenuListing->None],
  
  Cell[StyleData["IndexSubentry", "Printout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Horizontal Lines", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Line1"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {-16, 9}},
    StyleMenuListing->None,
    FontSize->2],
  
  Cell[StyleData["Line1", "Printout"],
    CellMargins->{{2, 0}, {-16, 9}}]
  }, Closed]],
  
  Cell["\<\

The item above is horizontal 0.5 pt line\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramTop"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {-18, 18}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramTop", "Printout"],
    CellMargins->{{2, 0}, {-18, 18}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramTop line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramBottom"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {-10, -2}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramBottom", "Printout"],
    CellMargins->{{2, 0}, {-10, -2}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramBottom line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SessionLabel"],
    CellFrame->{{0.5, 0}, {0, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{10, 4}, {-4, 18}},
    LineSpacing->{1, -3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SessionLabel", "Printout"],
    CellMargins->{{2, 0}, {-4, 18}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Page Headers and Footers", "Subsubsection"],
  
  Cell[StyleData["PageHeader"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Bold"],
  
  Cell[StyleData["PageFooter"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6]
  }, Closed]]
  }, Open  ]]
  }],
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "WhatisMathReader_SA"->{
    Cell[1739, 51, 189, 7, 38, "Subsection",
      CellTags->"WhatisMathReader_SA"],
    Cell[1931, 60, 368, 12, 56, "EmphasisText",
      CellTags->"WhatisMathReader_SA"],
    Cell[2302, 74, 138, 6, 24, "Text",
      CellTags->"WhatisMathReader_SA"],
    Cell[2443, 82, 198, 6, 26, "Text",
      CellTags->"WhatisMathReader_SA"],
    Cell[2644, 90, 193, 6, 26, "Text",
      CellTags->"WhatisMathReader_SA"],
    Cell[2840, 98, 200, 6, 26, "Text",
      CellTags->"WhatisMathReader_SA"],
    Cell[3043, 106, 169, 4, 26, "Text",
      CellTags->"WhatisMathReader_SA"],
    Cell[3215, 112, 192, 6, 24, "Text",
      CellTags->"WhatisMathReader_SA"],
    Cell[3410, 120, 519, 17, 56, "Text",
      CellTags->"WhatisMathReader_SA"],
    Cell[3932, 139, 471, 16, 40, "Text",
      CellTags->"WhatisMathReader_SA"]},
  "WhatisMathReader"->{
    Cell[4440, 160, 186, 7, 38, "Subsection",
      CellTags->"WhatisMathReader"],
    Cell[4629, 169, 365, 12, 56, "EmphasisText",
      CellTags->"WhatisMathReader"],
    Cell[4997, 183, 332, 12, 40, "Text",
      CellTags->"WhatisMathReader"],
    Cell[5332, 197, 194, 6, 26, "Text",
      CellTags->"WhatisMathReader"],
    Cell[5529, 205, 190, 6, 26, "Text",
      CellTags->"WhatisMathReader"],
    Cell[5722, 213, 197, 6, 26, "Text",
      CellTags->"WhatisMathReader"],
    Cell[5922, 221, 166, 4, 26, "Text",
      CellTags->"WhatisMathReader"],
    Cell[6091, 227, 349, 10, 40, "Text",
      CellTags->"WhatisMathReader"],
    Cell[6443, 239, 486, 14, 56, "Text",
      CellTags->"WhatisMathReader"]},
  "NotebookFormat"->{
    Cell[6966, 258, 71, 1, 36, "Subsection",
      CellTags->"NotebookFormat"],
    Cell[7040, 261, 200, 5, 70, "EmphasisText",
      CellTags->"NotebookFormat"],
    Cell[7243, 268, 222, 5, 70, "Text",
      CellTags->"NotebookFormat"],
    Cell[7468, 275, 353, 10, 70, "Text",
      CellTags->"NotebookFormat"],
    Cell[7824, 287, 403, 7, 70, "Text",
      CellTags->"NotebookFormat"],
    Cell[8230, 296, 204031, 3348, 70, 203881, 3343, "GraphicsData", 
    "Bitmap", "Graphics",
      CellTags->"NotebookFormat"],
    Cell[212264, 3646, 196, 6, 70, "Caption",
      CellTags->"NotebookFormat"]},
  "OpeningNotebooks"->{
    Cell[212497, 3657, 72, 1, 36, "Subsection",
      CellTags->"OpeningNotebooks"],
    Cell[212572, 3660, 336, 12, 70, "EmphasisText",
      CellTags->"OpeningNotebooks"],
    Cell[212911, 3674, 314, 7, 70, "Text",
      CellTags->"OpeningNotebooks"]},
  "OpeningCellGroups"->{
    Cell[213262, 3686, 76, 1, 36, "Subsection",
      CellTags->"OpeningCellGroups"],
    Cell[213341, 3689, 317, 8, 70, "EmphasisText",
      CellTags->"OpeningCellGroups"],
    Cell[213661, 3699, 234, 5, 70, "Text",
      CellTags->"OpeningCellGroups"],
    Cell[213898, 3706, 170, 4, 70, "Text",
      CellTags->"OpeningCellGroups"],
    Cell[214071, 3712, 25672, 322, 70, 25497, 316, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"OpeningCellGroups"],
    Cell[239746, 4036, 97, 1, 70, "Text",
      CellTags->"OpeningCellGroups"],
    Cell[239846, 4039, 50802, 632, 70, 50627, 626, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"OpeningCellGroups"]},
  "AnimatingGraphics"->{
    Cell[290685, 4676, 73, 1, 36, "Subsection",
      CellTags->"AnimatingGraphics"],
    Cell[290761, 4679, 427, 11, 70, "EmphasisText",
      CellTags->"AnimatingGraphics"],
    Cell[291191, 4692, 92, 1, 70, "Text",
      CellTags->"AnimatingGraphics"],
    Cell[291308, 4697, 7785, 104, 70, 7443, 93, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[299096, 4803, 7859, 105, 70, 7524, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[306958, 4910, 7871, 105, 70, 7536, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[314832, 5017, 7907, 105, 70, 7572, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[322742, 5124, 7919, 105, 70, 7584, 94, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[330664, 5231, 7952, 106, 70, 7617, 95, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[338619, 5339, 7959, 109, 70, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[346581, 5450, 7967, 109, 70, 7632, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[354551, 5561, 7910, 108, 70, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[362464, 5671, 7979, 109, 70, 7644, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[370446, 5782, 7999, 109, 70, 7664, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[378448, 5893, 7975, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[386426, 6004, 7939, 109, 70, 7604, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[394368, 6115, 7927, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[402298, 6226, 7878, 108, 70, 7543, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[410179, 6336, 7886, 108, 70, 7551, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[418068, 6446, 7846, 108, 70, 7511, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[425917, 6556, 7910, 108, 70, 7575, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[433830, 6666, 7927, 109, 70, 7592, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[441760, 6777, 7918, 108, 70, 7583, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[449681, 6887, 7902, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[457586, 6997, 7951, 109, 70, 7616, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[465540, 7108, 7943, 109, 70, 7608, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[473486, 7219, 7935, 109, 70, 7600, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[481424, 7330, 7902, 108, 70, 7567, 97, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[489329, 7440, 7971, 109, 70, 7636, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[497303, 7551, 7975, 109, 70, 7640, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[505281, 7662, 8020, 110, 70, 7685, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[513304, 7774, 7959, 109, 70, 7624, 98, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[521266, 7885, 8024, 110, 70, 7689, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[529293, 7997, 8016, 110, 70, 7681, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[537312, 8109, 8052, 110, 70, 7717, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[545367, 8221, 8008, 110, 70, 7673, 99, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[553378, 8333, 8165, 111, 70, 7830, 100, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[561546, 8446, 8226, 112, 70, 7891, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[569775, 8560, 8242, 112, 70, 7907, 101, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[578020, 8674, 8267, 113, 70, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[586290, 8789, 8275, 113, 70, 7940, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[594568, 8904, 8307, 113, 70, 7972, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[602878, 9019, 8319, 113, 70, 7984, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[611200, 9134, 8267, 113, 70, 7932, 102, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[619470, 9249, 8332, 114, 70, 7997, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[627805, 9365, 8380, 114, 70, 8045, 103, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[636188, 9481, 8429, 115, 70, 8094, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[644620, 9598, 8461, 115, 70, 8118, 104, "GraphicsData", 
    "Bitmap", "PictureGroup",
      Evaluatable->False,
      CellGroupingRules->"GraphicsGrouping",
      CellTags->"AnimatingGraphics"],
    Cell[653096, 9716, 125, 4, 70, "Caption",
      CellTags->"AnimatingGraphics"]},
  "PlayingSounds"->{
    Cell[653258, 9725, 65, 1, 36, "Subsection",
      CellTags->"PlayingSounds"],
    Cell[653326, 9728, 409, 12, 70, "EmphasisText",
      CellTags->"PlayingSounds"],
    Cell[653738, 9742, 175, 4, 70, "Text",
      CellTags->"PlayingSounds"],
    Cell[653916, 9748, 34102, 479, 70, 33781, 469, "GraphicsData", 
    "PostScript", "Sound",
      Evaluatable->False,
      ImageCacheValid->False,
      CellTags->"PlayingSounds"]},
  "DisplayCharacteristics"->{
    Cell[688055, 10232, 82, 1, 36, "Subsection",
      CellTags->"DisplayCharacteristics"],
    Cell[688140, 10235, 392, 11, 70, "EmphasisText",
      CellTags->"DisplayCharacteristics"],
    Cell[688535, 10248, 516, 13, 70, "Text",
      CellTags->"DisplayCharacteristics"]},
  "Printing"->{
    Cell[689088, 10266, 54, 1, 36, "Subsection",
      CellTags->"Printing"],
    Cell[689145, 10269, 639, 21, 70, "EmphasisText",
      CellTags->"Printing"],
    Cell[689787, 10292, 729, 21, 70, "Text",
      CellTags->"Printing"]},
  "UsingHelp_SA"->{
    Cell[690553, 10318, 62, 1, 36, "Subsection",
      CellTags->"UsingHelp_SA"],
    Cell[690618, 10321, 317, 10, 70, "EmphasisText",
      CellTags->"UsingHelp_SA"],
    Cell[690938, 10333, 404, 13, 70, "Text",
      CellTags->"UsingHelp_SA"]},
  "UsingHelp"->{
    Cell[691379, 10351, 59, 1, 36, "Subsection",
      CellTags->"UsingHelp"],
    Cell[691441, 10354, 349, 11, 70, "EmphasisText",
      CellTags->"UsingHelp"],
    Cell[691793, 10367, 311, 12, 70, "Text",
      CellTags->"UsingHelp"],
    Cell[692107, 10381, 532, 16, 70, "Text",
      CellTags->"UsingHelp"]},
  "ConfiguringBrowser"->{
    Cell[692676, 10402, 135, 5, 36, "Subsection",
      CellTags->"ConfiguringBrowser"],
    Cell[692814, 10409, 233, 6, 70, "EmphasisText",
      CellTags->"ConfiguringBrowser"],
    Cell[693347, 10426, 903, 38, 70, "Text",
      CellTags->"ConfiguringBrowser"]},
  "LicensingInformation"->{
    Cell[694287, 10469, 141, 3, 36, "Subsection",
      CellTags->"LicensingInformation"],
    Cell[694431, 10474, 197, 5, 40, "EmphasisText",
      CellTags->"LicensingInformation"],
    Cell[694631, 10481, 418, 13, 36, "Text",
      CellTags->"LicensingInformation"]},
  "MathematicaSystem"->{
    Cell[695086, 10499, 140, 6, 36, "Subsection",
      CellTags->"MathematicaSystem"],
    Cell[695229, 10507, 254, 7, 54, "EmphasisText",
      CellTags->"MathematicaSystem"],
    Cell[695486, 10516, 579, 14, 68, "Text",
      CellTags->"MathematicaSystem"],
    Cell[696068, 10532, 1108, 31, 69, "Text",
      CellTags->"MathematicaSystem"],
    Cell[697179, 10565, 130, 4, 15, "Caption",
      CellTags->"MathematicaSystem"],
    Cell[697312, 10571, 494, 17, 38, "Text",
      CellTags->"MathematicaSystem"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"WhatisMathReader_SA", 750111, 12610},
  {"WhatisMathReader", 750947, 12631},
  {"NotebookFormat", 751681, 12650},
  {"OpeningNotebooks", 752306, 12666},
  {"OpeningCellGroups", 752586, 12673},
  {"AnimatingGraphics", 753343, 12692},
  {"PlayingSounds", 762897, 12926},
  {"DisplayCharacteristics", 763358, 12938},
  {"Printing", 763651, 12945},
  {"UsingHelp_SA", 763906, 12952},
  {"UsingHelp", 764170, 12959},
  {"ConfiguringBrowser", 764509, 12968},
  {"LicensingInformation", 764802, 12975},
  {"MathematicaSystem", 765098, 12982}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 189, 7, 38, "Subsection",
  CellTags->"WhatisMathReader_SA"],
Cell[1931, 60, 368, 12, 56, "EmphasisText",
  CellTags->"WhatisMathReader_SA"],
Cell[2302, 74, 138, 6, 24, "Text",
  CellTags->"WhatisMathReader_SA"],
Cell[2443, 82, 198, 6, 26, "Text",
  CellTags->"WhatisMathReader_SA"],
Cell[2644, 90, 193, 6, 26, "Text",
  CellTags->"WhatisMathReader_SA"],
Cell[2840, 98, 200, 6, 26, "Text",
  CellTags->"WhatisMathReader_SA"],
Cell[3043, 106, 169, 4, 26, "Text",
  CellTags->"WhatisMathReader_SA"],
Cell[3215, 112, 192, 6, 24, "Text",
  CellTags->"WhatisMathReader_SA"],
Cell[3410, 120, 519, 17, 56, "Text",
  CellTags->"WhatisMathReader_SA"],
Cell[3932, 139, 471, 16, 40, "Text",
  CellTags->"WhatisMathReader_SA"]
}, Closed]],

Cell[CellGroupData[{
Cell[4440, 160, 186, 7, 38, "Subsection",
  CellTags->"WhatisMathReader"],
Cell[4629, 169, 365, 12, 56, "EmphasisText",
  CellTags->"WhatisMathReader"],
Cell[4997, 183, 332, 12, 40, "Text",
  CellTags->"WhatisMathReader"],
Cell[5332, 197, 194, 6, 26, "Text",
  CellTags->"WhatisMathReader"],
Cell[5529, 205, 190, 6, 26, "Text",
  CellTags->"WhatisMathReader"],
Cell[5722, 213, 197, 6, 26, "Text",
  CellTags->"WhatisMathReader"],
Cell[5922, 221, 166, 4, 26, "Text",
  CellTags->"WhatisMathReader"],
Cell[6091, 227, 349, 10, 40, "Text",
  CellTags->"WhatisMathReader"],
Cell[6443, 239, 486, 14, 56, "Text",
  CellTags->"WhatisMathReader"]
}, Closed]],

Cell[CellGroupData[{
Cell[6966, 258, 71, 1, 36, "Subsection",
  CellTags->"NotebookFormat"],
Cell[7040, 261, 200, 5, 70, "EmphasisText",
  CellTags->"NotebookFormat"],
Cell[7243, 268, 222, 5, 70, "Text",
  CellTags->"NotebookFormat"],
Cell[7468, 275, 353, 10, 70, "Text",
  CellTags->"NotebookFormat"],
Cell[7824, 287, 403, 7, 70, "Text",
  CellTags->"NotebookFormat"],
Cell[8230, 296, 204031, 3348, 70, 203881, 3343, "GraphicsData", "Bitmap", \
"Graphics",
  CellTags->"NotebookFormat"],
Cell[212264, 3646, 196, 6, 70, "Caption",
  CellTags->"NotebookFormat"]
}, Closed]],

Cell[CellGroupData[{
Cell[212497, 3657, 72, 1, 36, "Subsection",
  CellTags->"OpeningNotebooks"],
Cell[212572, 3660, 336, 12, 70, "EmphasisText",
  CellTags->"OpeningNotebooks"],
Cell[212911, 3674, 314, 7, 70, "Text",
  CellTags->"OpeningNotebooks"]
}, Closed]],

Cell[CellGroupData[{
Cell[213262, 3686, 76, 1, 36, "Subsection",
  CellTags->"OpeningCellGroups"],
Cell[213341, 3689, 317, 8, 70, "EmphasisText",
  CellTags->"OpeningCellGroups"],
Cell[213661, 3699, 234, 5, 70, "Text",
  CellTags->"OpeningCellGroups"],
Cell[213898, 3706, 170, 4, 70, "Text",
  CellTags->"OpeningCellGroups"],
Cell[214071, 3712, 25672, 322, 70, 25497, 316, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"OpeningCellGroups"],
Cell[239746, 4036, 97, 1, 70, "Text",
  CellTags->"OpeningCellGroups"],
Cell[239846, 4039, 50802, 632, 70, 50627, 626, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"OpeningCellGroups"]
}, Closed]],

Cell[CellGroupData[{
Cell[290685, 4676, 73, 1, 36, "Subsection",
  CellTags->"AnimatingGraphics"],
Cell[290761, 4679, 427, 11, 70, "EmphasisText",
  CellTags->"AnimatingGraphics"],
Cell[291191, 4692, 92, 1, 70, "Text",
  CellTags->"AnimatingGraphics"],

Cell[CellGroupData[{
Cell[291308, 4697, 7785, 104, 70, 7443, 93, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[299096, 4803, 7859, 105, 70, 7524, 94, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[306958, 4910, 7871, 105, 70, 7536, 94, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[314832, 5017, 7907, 105, 70, 7572, 94, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[322742, 5124, 7919, 105, 70, 7584, 94, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[330664, 5231, 7952, 106, 70, 7617, 95, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[338619, 5339, 7959, 109, 70, 7624, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[346581, 5450, 7967, 109, 70, 7632, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[354551, 5561, 7910, 108, 70, 7575, 97, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[362464, 5671, 7979, 109, 70, 7644, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[370446, 5782, 7999, 109, 70, 7664, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[378448, 5893, 7975, 109, 70, 7640, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[386426, 6004, 7939, 109, 70, 7604, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[394368, 6115, 7927, 109, 70, 7592, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[402298, 6226, 7878, 108, 70, 7543, 97, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[410179, 6336, 7886, 108, 70, 7551, 97, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[418068, 6446, 7846, 108, 70, 7511, 97, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[425917, 6556, 7910, 108, 70, 7575, 97, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[433830, 6666, 7927, 109, 70, 7592, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[441760, 6777, 7918, 108, 70, 7583, 97, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[449681, 6887, 7902, 108, 70, 7567, 97, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[457586, 6997, 7951, 109, 70, 7616, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[465540, 7108, 7943, 109, 70, 7608, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[473486, 7219, 7935, 109, 70, 7600, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[481424, 7330, 7902, 108, 70, 7567, 97, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[489329, 7440, 7971, 109, 70, 7636, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[497303, 7551, 7975, 109, 70, 7640, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[505281, 7662, 8020, 110, 70, 7685, 99, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[513304, 7774, 7959, 109, 70, 7624, 98, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[521266, 7885, 8024, 110, 70, 7689, 99, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[529293, 7997, 8016, 110, 70, 7681, 99, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[537312, 8109, 8052, 110, 70, 7717, 99, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[545367, 8221, 8008, 110, 70, 7673, 99, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[553378, 8333, 8165, 111, 70, 7830, 100, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[561546, 8446, 8226, 112, 70, 7891, 101, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[569775, 8560, 8242, 112, 70, 7907, 101, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[578020, 8674, 8267, 113, 70, 7932, 102, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[586290, 8789, 8275, 113, 70, 7940, 102, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[594568, 8904, 8307, 113, 70, 7972, 102, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[602878, 9019, 8319, 113, 70, 7984, 102, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[611200, 9134, 8267, 113, 70, 7932, 102, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[619470, 9249, 8332, 114, 70, 7997, 103, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[627805, 9365, 8380, 114, 70, 8045, 103, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[636188, 9481, 8429, 115, 70, 8094, 104, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"],
Cell[644620, 9598, 8461, 115, 70, 8118, 104, "GraphicsData", "Bitmap", \
"PictureGroup",
  Evaluatable->False,
  CellGroupingRules->"GraphicsGrouping",
  CellTags->"AnimatingGraphics"]
}, Closed]],
Cell[653096, 9716, 125, 4, 70, "Caption",
  CellTags->"AnimatingGraphics"]
}, Closed]],

Cell[CellGroupData[{
Cell[653258, 9725, 65, 1, 36, "Subsection",
  CellTags->"PlayingSounds"],
Cell[653326, 9728, 409, 12, 70, "EmphasisText",
  CellTags->"PlayingSounds"],
Cell[653738, 9742, 175, 4, 70, "Text",
  CellTags->"PlayingSounds"],
Cell[653916, 9748, 34102, 479, 70, 33781, 469, "GraphicsData", "PostScript", \
"Sound",
  Evaluatable->False,
  ImageCacheValid->False,
  CellTags->"PlayingSounds"]
}, Closed]],

Cell[CellGroupData[{
Cell[688055, 10232, 82, 1, 36, "Subsection",
  CellTags->"DisplayCharacteristics"],
Cell[688140, 10235, 392, 11, 70, "EmphasisText",
  CellTags->"DisplayCharacteristics"],
Cell[688535, 10248, 516, 13, 70, "Text",
  CellTags->"DisplayCharacteristics"]
}, Closed]],

Cell[CellGroupData[{
Cell[689088, 10266, 54, 1, 36, "Subsection",
  CellTags->"Printing"],
Cell[689145, 10269, 639, 21, 70, "EmphasisText",
  CellTags->"Printing"],
Cell[689787, 10292, 729, 21, 70, "Text",
  CellTags->"Printing"]
}, Closed]],

Cell[CellGroupData[{
Cell[690553, 10318, 62, 1, 36, "Subsection",
  CellTags->"UsingHelp_SA"],
Cell[690618, 10321, 317, 10, 70, "EmphasisText",
  CellTags->"UsingHelp_SA"],
Cell[690938, 10333, 404, 13, 70, "Text",
  CellTags->"UsingHelp_SA"]
}, Closed]],

Cell[CellGroupData[{
Cell[691379, 10351, 59, 1, 36, "Subsection",
  CellTags->"UsingHelp"],
Cell[691441, 10354, 349, 11, 70, "EmphasisText",
  CellTags->"UsingHelp"],
Cell[691793, 10367, 311, 12, 70, "Text",
  CellTags->"UsingHelp"],
Cell[692107, 10381, 532, 16, 70, "Text",
  CellTags->"UsingHelp"]
}, Closed]],

Cell[CellGroupData[{
Cell[692676, 10402, 135, 5, 36, "Subsection",
  CellTags->"ConfiguringBrowser"],
Cell[692814, 10409, 233, 6, 70, "EmphasisText",
  CellTags->"ConfiguringBrowser"],
Cell[693050, 10417, 294, 7, 70, "Text"],
Cell[693347, 10426, 903, 38, 70, "Text",
  CellTags->"ConfiguringBrowser"]
}, Closed]],

Cell[CellGroupData[{
Cell[694287, 10469, 141, 3, 36, "Subsection",
  CellTags->"LicensingInformation"],
Cell[694431, 10474, 197, 5, 40, "EmphasisText",
  CellTags->"LicensingInformation"],
Cell[694631, 10481, 418, 13, 36, "Text",
  CellTags->"LicensingInformation"]
}, Closed]],

Cell[CellGroupData[{
Cell[695086, 10499, 140, 6, 36, "Subsection",
  CellTags->"MathematicaSystem"],
Cell[695229, 10507, 254, 7, 54, "EmphasisText",
  CellTags->"MathematicaSystem"],
Cell[695486, 10516, 579, 14, 68, "Text",
  CellTags->"MathematicaSystem"],
Cell[696068, 10532, 1108, 31, 69, "Text",
  CellTags->"MathematicaSystem"],
Cell[697179, 10565, 130, 4, 15, "Caption",
  CellTags->"MathematicaSystem"],
Cell[697312, 10571, 494, 17, 38, "Text",
  CellTags->"MathematicaSystem"]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

