(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     56089,       1649]*)
(*NotebookOutlinePosition[     65490,       1895]*)
(*  CellTagsIndexPosition[     64894,       1871]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Windows Keyboard Shortcuts", "Title"],

Cell[CellGroupData[{

Cell["General Windows Shortcuts", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"all", "nonmenu", "nonmenu_MR"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Activate/Inactivate\ Menu\ Bar\ Mode\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[AltKey]"},
            {
              StyleBox[\(Access\ Start\ Button\ in\ Taskbar\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[ControlKey]\[KeyBar]\[EscapeKey]"},
            {
              StyleBox[\(Display\ Next\ Application\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[AltKey]\[KeyBar]\[TabKey]"},
            {
              StyleBox[\(Display\ Next\ Window\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[AltKey]\[KeyBar]\[EscapeKey]"},
            {
              StyleBox[\(Display\ Application\ Pop - up\ Menu\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[LeftModified]F10\[RightModified]"},
            {
              StyleBox[\(Display\ Window\ Pop - up\ Menu\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[AltKey]\[KeyBar]\[SpaceKey]"},
            {
              StyleBox[\(Display\ Next\ Notebook\),
                FontFamily->"Helvetica",
                FontSize->10], 
              "\[ControlKey]\[LeftModified]F6\[RightModified]"},
            {
              StyleBox[\(Capture\ Window\ Image\ to\ Clipboard\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Roman"], \(\[AltKey]\[LeftModified]Prt\ Sc\[RightModified]\
\)},
            {
              StyleBox[\(Capture\ Desktop\ Image\ to\ Clipboard\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], \(Prt\ Sc\)}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"all", "nonmenu", "nonmenu_MR"}]
}, Closed]],

Cell[CellGroupData[{

Cell["File Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"file", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["New",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              "\[ControlKey]\[LeftModified]n\[RightModified]"},
            {
              StyleBox["Open",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              "\[ControlKey]\[LeftModified]o\[RightModified]"},
            {
              StyleBox["Close",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              RowBox[{"\[ControlKey]\[LeftModified]w\[RightModified]", 
                StyleBox[",",
                  FontFamily->"Times"], 
                StyleBox[" ",
                  FontFamily->"Times"], 
                "\[ControlKey]\[LeftModified]F4\[RightModified]"}]},
            {
              StyleBox["Save",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              "\[ControlKey]\[LeftModified]s\[RightModified]"},
            {
              StyleBox[\(Save\ As\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]s\
\[RightModified]"},
            {
              StyleBox["Print",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]p\[RightModified]"},
            {
              StyleBox[
                RowBox[{
                  StyleBox["Print",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontFamily->"Helvetica",
                    FontSize->11,
                    FontWeight->"Plain"], 
                  StyleBox["Selection",
                    FontSize->10]}],
                FontFamily->"Helvetica",
                FontSize->10], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]p\
\[RightModified]"},
            {
              StyleBox["Exit",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]F4\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"file", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Edit Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"edit", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Undo",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]z\[RightModified]"},
            {
              StyleBox["Cut",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    "2ColumnSmallBox"], 
                  "\[LeftModified]x\[RightModified]"}]]},
            {
              StyleBox["Copy",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]c\[RightModified]"},
            {
              StyleBox["Paste",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]v\[RightModified]"},
            {
              StyleBox["Clear",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[DeleteKey]"},
            {
              StyleBox[\(Select\ All\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]a\[RightModified]"},
            {
              StyleBox[\(Make\ 2  D\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
                  StyleBox["y",
                    "2ColumnSmallBox"], "\[RightModified]"}]]},
            {
              StyleBox[\(Check\ Balance\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
                  StyleBox["b",
                    "2ColumnSmallBox"], "\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"edit", "all"}],

Cell[CellGroupData[{

Cell["Motion Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editmotion", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[ShortRightArrow]",
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[ShortLeftArrow]",
                FontSize->12]},
            {
              StyleBox[\(Delete\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[\(\(\[DeleteKey]\)\(\ \)\),
                FontSize->12]},
            {
              StyleBox[\(Delete\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["Backspace",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              
              StyleBox[\(\[ControlKey]\[LeftModified] \[ShortRightArrow] \
\[RightModified]\),
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] \[ShortLeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Delete\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    "2ColumnSmallBox"], "\[KeyBar]", 
                  StyleBox["\[DeleteKey]",
                    "2ColumnSmallBox"]}]]},
            {
              StyleBox[\(Delete\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    FontFamily->"Helvetica",
                    FontSize->12,
                    FontWeight->"Plain"], "\[LeftModified]", 
                  StyleBox["B",
                    "2ColumnSmallBox"], "ackspace\[RightModified]"}]]},
            {
              StyleBox[\(Move\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["End",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["Home",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Next\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[DownArrow]",
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[UpArrow]",
                FontSize->12]}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, True, False, False, False, True, 
              False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"editmotion", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Scrolling Commands", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"nonmenu", "all", "nonmenu_MR"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Scroll\ Page\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["PageUp",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"]},
            {
              StyleBox[\(Scroll\ Page\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["PageDown",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"]},
            {
              StyleBox[\(Scroll\ Notebook\ Start\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["H",
                    "2ColumnSmallBox"], "ome\[RightModified]"}]]},
            {
              StyleBox[\(Scroll\ Notebook\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["E",
                    "2ColumnSmallBox"], "nd\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->{{1, 1}, {2, 2}}],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"nonmenu", "all", "nonmenu_MR"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Expression Input Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editexpression", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Superscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["^",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], "\[RightModified]"}], "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                "\[ControlKey]\[LeftModified]6\[RightModified]"}]},
            {
              StyleBox["Subscript",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] - \[RightModified]\
\)},
            {
              StyleBox["Above",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox["Below",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", "+", 
                  RowBox[{"\[RightModified]", "  ", 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], "  ", "\[ControlKey]\[LeftModified]"}]}],
                 "=", "\[RightModified]"}]},
            {
              StyleBox[\(Opposite\ Position\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "%", "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                "\[ControlKey]\[LeftModified]5\[RightModified]"}]},
            {
              StyleBox["Fraction",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[ControlKey]\[LeftModified]/\[RightModified]\)},
            {
              StyleBox["Radical",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                
                RowBox[{\(\[ControlKey]\[LeftModified]@\[RightModified]\), "  ",
                   
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], "  ", 
                  "\[ControlKey]\[LeftModified]2\[RightModified]"}], " "}]},
            {
              StyleBox[\(Add\ Row\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[SkeletonIndicator]\[ReturnKey]"},
            {
              StyleBox[\(Add\ Column\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified], \
\[RightModified]\)},
            {
              StyleBox[\(End\ Subexpression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[SkeletonIndicator]\[SpaceKey]"},
            {
              StyleBox[\(Extend\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\(\[ControlKey]\[LeftModified] . \
\[RightModified]\)\(\ \)\)},
            {
              StyleBox[\(Start\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ControlKey]\[LeftModified]", 
                RowBox[{"(", 
                  RowBox[{"\[RightModified]", "  ", 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], "  ", 
                    StyleBox[
                      RowBox[{"\[ControlKey]\[LeftModified]", 
                        StyleBox["9",
                          FontWeight->"Plain"], "\[RightModified]"}]]}]}]}]},
            {
              StyleBox[\(End\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              
              RowBox[{\(\(\[ControlKey]\[LeftModified]\)\()\)\), 
                "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["0",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Insert\ Raw\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "*", "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["8",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Nudge\ Left\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] \[LeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Right\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] \[RightArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified]\[DownArrow]\
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified]\[UpArrow]\
\[RightModified]\)}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, False, True, False, True, False, True, 
              False, True, False, False, True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"editexpression", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Expression Editing Commands", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"nonmenu", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Placeholder\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[TabKey]",
                FontFamily->"Helvetica",
                FontWeight->"Plain"]},
            {
              StyleBox[\(Move\ Previous\ Placeholder\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]", 
                  StyleBox["\[TabKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"]}]]},
            {
              StyleBox[\(Move\ Next\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[ControlKey]\[KeyBar]\[TabKey]"},
            {
              StyleBox[\(Move\ Previous\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[KeyBar]", 
                    StyleBox["\[TabKey]",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"]}]], " "}]},
            {
              StyleBox[\(Delete\ Next\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[KeyBar]", 
                  StyleBox["\[DeleteKey]",
                    "2ColumnSmallBox"]}]]},
            {
              StyleBox[\(Delete\ Previous\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
                  StyleBox["B",
                    "2ColumnSmallBox"], "ackspace\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->{{1, 1}, {2, 2}}],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"nonmenu", "all"}],

Cell[BoxData[
    FormBox["", TextForm]], "Text",
  CellTags->"all"]
}, Closed]],

Cell[CellGroupData[{

Cell["Commands for Selecting Text", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"nonmenu", "all", "nonmenu_MR"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Select\ Next\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ShiftKey]\[LeftModified] \[RightArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Select\ Previous\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ShiftKey]\[LeftModified] \[LeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Select\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[ControlKey]\[KeyBar]\[ShiftKey]\[LeftModified] \[RightArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Select\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[ControlKey]\[KeyBar]\[ShiftKey]\[LeftModified] \[LeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Select\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[LeftModified]End\[RightModified]"},
            {
              StyleBox[\(Select\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[LeftModified]Home\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->{{1, 1}, {2, 2}}],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"nonmenu", "all", "nonmenu_MR"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"cell", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Divide\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]d\
\[RightModified]"},
            {
              StyleBox[\(Merge\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]m\
\[RightModified]"},
            {
              StyleBox[\(Animate\ Selected\ Graphics\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]y\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"cell", "all"}],

Cell[CellGroupData[{

Cell["Convert To Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"cellconvert", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["InputForm",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]i\
\[RightModified]"},
            {
              StyleBox["StandardForm",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]n\
\[RightModified]"},
            {
              StyleBox["TraditionalForm",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]t\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"cellconvert", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Grouping Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"cellgrouping", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Group\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]g\
\[RightModified]"},
            {
              StyleBox[\(Ungroup\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]u\
\[RightModified]"},
            {
              StyleBox[\(Open\ All\ Subgroups\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] \
{\[RightModified]\)},
            {
              StyleBox[\(Close\ All\ Subgroups\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\(\(\[ControlKey]\[LeftModified]\)\(}\)\) \
\[RightModified]\)},
            {
              StyleBox[\(Open/Close\ Group\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified]' \
\[RightModified]\)}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"cellgrouping", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Format Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"format", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Show\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]e\
\[RightModified]"},
            {
              StyleBox[\(Option\ Inspector\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]o\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"format", "all"}],

Cell[CellGroupData[{

Cell["Style Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"formatstyle", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Title",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]1\[RightModified]"},
            {
              StyleBox["Subtitle",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]2\[RightModified]"},
            {
              StyleBox["Subsubtitle",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]3\[RightModified]"},
            {
              StyleBox["Section",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]4\[RightModified]"},
            {
              StyleBox["Subsection",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]5\[RightModified]"},
            {
              StyleBox["Subsubsection",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]6\[RightModified]"},
            {
              StyleBox[\(\(Text\)\(\ \)\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[AltKey]",
                    "2ColumnSmallBox"], 
                  "\[LeftModified]7\[RightModified]"}]]},
            {
              StyleBox[\(Small\ Text\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]8\[RightModified]"},
            {
              StyleBox["Input",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]9\[RightModified]"},
            {
              StyleBox["Other",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]0\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"formatstyle", "all"}],

Cell["\<\
\[FilledSmallSquare] Note that these keyboard shortcuts may \
correspond to different cell styles than what is given here. The menu's list \
of styles is based on definitions in the current style sheet.\
\>", "Notes",
  CellTags->{"all", "formatstyle"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Face Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"formatface", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Bold",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]b\[RightModified]"},
            {
              StyleBox["Italic",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]i\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"formatface", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Size Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"formatsize", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Smaller",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] - \[RightModified]\)},
            {
              StyleBox["Larger",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[AltKey]\[LeftModified]", 
                StyleBox["=",
                  "2ColumnSmallBox"], "\[RightModified]"}]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"formatsize", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"input", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(3  D\ ViewPoint\ Selector\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]v\
\[RightModified]"},
            {
              StyleBox[\(Create\ \(Table/Matrix\)/Palette\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]c\
\[RightModified]"},
            {
              StyleBox[\(Copy\ Input\ from\ Above\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]l\[RightModified]"},
            {
              StyleBox[\(Copy\ Output\ from\ Above\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]l\
\[RightModified]"},
            {
              StyleBox[\(Start\ New\ Cell\ Below\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[AltKey]\[KeyBar]\[EnterKey]"},
            {
              StyleBox[\(Complete\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]k\[RightModified]"},
            {
              StyleBox[\(Make\ Template\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]k\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"input", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"kernel", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Interrupt\ Evaluation\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified], \[RightModified]\)},
            {
              StyleBox[\(Abort\ Evaluation\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] . \[RightModified]\)}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"kernel", "all"}],

Cell[CellGroupData[{

Cell["Evaluation Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"kernelevaluation", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Evaluate\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[ShiftKey]\[KeyBar]\[EnterKey]"},
            {
              StyleBox[\(Evaluate\ in\ Place\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[KeyBar]\[EnterKey]"},
            {
              StyleBox[\(Evaluate\ Next\ Input\),
                FontFamily->"Helvetica",
                FontSize->10], "\[ShiftKey]\[KeyBar]\[EnterKey]"},
            {
              RowBox[{" ", 
                StyleBox[\(Evaluate\ in\ Subsession\),
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain"]}], 
              StyleBox["F7",
                "2ColumnSmallBox"]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"kernelevaluation", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Find Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"find", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Find",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]f\[RightModified]"},
            {
              StyleBox[\(Enter\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]e\[RightModified]"},
            {
              StyleBox[\(Find\ Next\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["F3",
                "2ColumnSmallBox"]},
            {
              StyleBox["Replace",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]r\[RightModified]"},
            {
              StyleBox[\(Replace\ and\ Find\ Again\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]r\
\[RightModified]"},
            {
              StyleBox[\(Add/Remove\ Cell\ Tags\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]j\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"find", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Help Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"help", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Find\ in\ Help\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["F1",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Why\ the\ \(\(Beep\)\(?\)\)\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]h\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"help", "all"}]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1148}, {0, 848}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->{},
WindowSize->{534, 551},
WindowMargins->{{62, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "all"->{
    Cell[1844, 57, 130, 2, 36, "Subsection",
      CellTags->{"all", "nonmenu", "nonmenu_MR"}],
    Cell[1977, 61, 2882, 74, 241, "Text",
      CellTags->{"all", "nonmenu", "nonmenu_MR"}],
    Cell[4896, 140, 97, 2, 36, "Subsection",
      CellTags->{"file", "all"}],
    Cell[4996, 144, 3250, 90, 179, "Text",
      CellTags->{"file", "all"}],
    Cell[8283, 239, 97, 2, 36, "Subsection",
      CellTags->{"edit", "all"}],
    Cell[8383, 243, 2989, 82, 177, "Text",
      CellTags->{"edit", "all"}],
    Cell[11397, 329, 111, 2, 34, "Subsubsection",
      CellTags->{"editmotion", "all"}],
    Cell[11511, 333, 4445, 125, 235, "Text",
      CellTags->{"editmotion", "all"}],
    Cell[15993, 463, 126, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[16122, 467, 2227, 61, 115, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[18386, 533, 125, 2, 34, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[18514, 537, 7592, 204, 361, "Text",
      CellTags->{"editexpression", "all"}],
    Cell[26143, 746, 127, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[26273, 750, 2952, 77, 145, "Text",
      CellTags->{"nonmenu", "all"}],
    Cell[29228, 829, 68, 2, 24, "Text",
      CellTags->"all"],
    Cell[29333, 836, 135, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[29471, 840, 2495, 71, 155, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[32015, 917, 97, 2, 36, "Subsection",
      CellTags->{"cell", "all"}],
    Cell[32115, 921, 1607, 45, 89, "Text",
      CellTags->{"cell", "all"}],
    Cell[33747, 970, 116, 2, 24, "Subsubsection",
      CellTags->{"cellconvert", "all"}],
    Cell[33866, 974, 1615, 46, 89, "Text",
      CellTags->{"cellconvert", "all"}],
    Cell[35518, 1025, 120, 2, 24, "Subsubsection",
      CellTags->{"cellgrouping", "all"}],
    Cell[35641, 1029, 2172, 63, 125, "Text",
      CellTags->{"cellgrouping", "all"}],
    Cell[37862, 1098, 101, 2, 36, "Subsection",
      CellTags->{"format", "all"}],
    Cell[37966, 1102, 1374, 39, 83, "Text",
      CellTags->{"format", "all"}],
    Cell[39365, 1145, 111, 2, 36, "Subsubsection",
      CellTags->{"formatstyle", "all"}],
    Cell[39479, 1149, 3199, 89, 227, "Text",
      CellTags->{"formatstyle", "all"}],
    Cell[42681, 1240, 263, 5, 68, "Notes",
      CellTags->{"all", "formatstyle"}],
    Cell[42981, 1250, 109, 2, 32, "Subsubsection",
      CellTags->{"formatface", "all"}],
    Cell[43093, 1254, 1307, 37, 71, "Text",
      CellTags->{"formatface", "all"}],
    Cell[44437, 1296, 109, 2, 32, "Subsubsection",
      CellTags->{"formatsize", "all"}],
    Cell[44549, 1300, 1409, 40, 71, "Text",
      CellTags->{"formatsize", "all"}],
    Cell[46007, 1346, 99, 2, 36, "Subsection",
      CellTags->{"input", "all"}],
    Cell[46109, 1350, 2600, 70, 159, "Text",
      CellTags->{"input", "all"}],
    Cell[48746, 1425, 101, 2, 36, "Subsection",
      CellTags->{"kernel", "all"}],
    Cell[48850, 1429, 1376, 39, 71, "Text",
      CellTags->{"kernel", "all"}],
    Cell[50251, 1472, 121, 2, 24, "Subsubsection",
      CellTags->{"kernelevaluation", "all"}],
    Cell[50375, 1476, 1773, 48, 99, "Text",
      CellTags->{"kernelevaluation", "all"}],
    Cell[52197, 1530, 97, 2, 36, "Subsection",
      CellTags->{"find", "all"}],
    Cell[52297, 1534, 2267, 63, 141, "Text",
      CellTags->{"find", "all"}],
    Cell[54601, 1602, 97, 2, 36, "Subsection",
      CellTags->{"help", "all"}],
    Cell[54701, 1606, 1360, 39, 69, "Text",
      CellTags->{"help", "all"}]},
  "nonmenu"->{
    Cell[1844, 57, 130, 2, 36, "Subsection",
      CellTags->{"all", "nonmenu", "nonmenu_MR"}],
    Cell[1977, 61, 2882, 74, 241, "Text",
      CellTags->{"all", "nonmenu", "nonmenu_MR"}],
    Cell[15993, 463, 126, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[16122, 467, 2227, 61, 115, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[26143, 746, 127, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[26273, 750, 2952, 77, 145, "Text",
      CellTags->{"nonmenu", "all"}],
    Cell[29333, 836, 135, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[29471, 840, 2495, 71, 155, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}]},
  "nonmenu_MR"->{
    Cell[1844, 57, 130, 2, 36, "Subsection",
      CellTags->{"all", "nonmenu", "nonmenu_MR"}],
    Cell[1977, 61, 2882, 74, 241, "Text",
      CellTags->{"all", "nonmenu", "nonmenu_MR"}],
    Cell[15993, 463, 126, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[16122, 467, 2227, 61, 115, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[29333, 836, 135, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[29471, 840, 2495, 71, 155, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}]},
  "file"->{
    Cell[4896, 140, 97, 2, 36, "Subsection",
      CellTags->{"file", "all"}],
    Cell[4996, 144, 3250, 90, 179, "Text",
      CellTags->{"file", "all"}]},
  "edit"->{
    Cell[8283, 239, 97, 2, 36, "Subsection",
      CellTags->{"edit", "all"}],
    Cell[8383, 243, 2989, 82, 177, "Text",
      CellTags->{"edit", "all"}]},
  "editmotion"->{
    Cell[11397, 329, 111, 2, 34, "Subsubsection",
      CellTags->{"editmotion", "all"}],
    Cell[11511, 333, 4445, 125, 235, "Text",
      CellTags->{"editmotion", "all"}]},
  "editexpression"->{
    Cell[18386, 533, 125, 2, 34, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[18514, 537, 7592, 204, 361, "Text",
      CellTags->{"editexpression", "all"}]},
  "cell"->{
    Cell[32015, 917, 97, 2, 36, "Subsection",
      CellTags->{"cell", "all"}],
    Cell[32115, 921, 1607, 45, 89, "Text",
      CellTags->{"cell", "all"}]},
  "cellconvert"->{
    Cell[33747, 970, 116, 2, 24, "Subsubsection",
      CellTags->{"cellconvert", "all"}],
    Cell[33866, 974, 1615, 46, 89, "Text",
      CellTags->{"cellconvert", "all"}]},
  "cellgrouping"->{
    Cell[35518, 1025, 120, 2, 24, "Subsubsection",
      CellTags->{"cellgrouping", "all"}],
    Cell[35641, 1029, 2172, 63, 125, "Text",
      CellTags->{"cellgrouping", "all"}]},
  "format"->{
    Cell[37862, 1098, 101, 2, 36, "Subsection",
      CellTags->{"format", "all"}],
    Cell[37966, 1102, 1374, 39, 83, "Text",
      CellTags->{"format", "all"}]},
  "formatstyle"->{
    Cell[39365, 1145, 111, 2, 36, "Subsubsection",
      CellTags->{"formatstyle", "all"}],
    Cell[39479, 1149, 3199, 89, 227, "Text",
      CellTags->{"formatstyle", "all"}],
    Cell[42681, 1240, 263, 5, 68, "Notes",
      CellTags->{"all", "formatstyle"}]},
  "formatface"->{
    Cell[42981, 1250, 109, 2, 32, "Subsubsection",
      CellTags->{"formatface", "all"}],
    Cell[43093, 1254, 1307, 37, 71, "Text",
      CellTags->{"formatface", "all"}]},
  "formatsize"->{
    Cell[44437, 1296, 109, 2, 32, "Subsubsection",
      CellTags->{"formatsize", "all"}],
    Cell[44549, 1300, 1409, 40, 71, "Text",
      CellTags->{"formatsize", "all"}]},
  "input"->{
    Cell[46007, 1346, 99, 2, 36, "Subsection",
      CellTags->{"input", "all"}],
    Cell[46109, 1350, 2600, 70, 159, "Text",
      CellTags->{"input", "all"}]},
  "kernel"->{
    Cell[48746, 1425, 101, 2, 36, "Subsection",
      CellTags->{"kernel", "all"}],
    Cell[48850, 1429, 1376, 39, 71, "Text",
      CellTags->{"kernel", "all"}]},
  "kernelevaluation"->{
    Cell[50251, 1472, 121, 2, 24, "Subsubsection",
      CellTags->{"kernelevaluation", "all"}],
    Cell[50375, 1476, 1773, 48, 99, "Text",
      CellTags->{"kernelevaluation", "all"}]},
  "find"->{
    Cell[52197, 1530, 97, 2, 36, "Subsection",
      CellTags->{"find", "all"}],
    Cell[52297, 1534, 2267, 63, 141, "Text",
      CellTags->{"find", "all"}]},
  "help"->{
    Cell[54601, 1602, 97, 2, 36, "Subsection",
      CellTags->{"help", "all"}],
    Cell[54701, 1606, 1360, 39, 69, "Text",
      CellTags->{"help", "all"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"all", 56835, 1670},
  {"nonmenu", 60454, 1755},
  {"nonmenu_MR", 61222, 1772},
  {"file", 61816, 1785},
  {"edit", 61985, 1790},
  {"editmotion", 62160, 1795},
  {"editexpression", 62358, 1800},
  {"cell", 62554, 1805},
  {"cellconvert", 62731, 1810},
  {"cellgrouping", 62927, 1815},
  {"format", 63122, 1820},
  {"formatstyle", 63306, 1825},
  {"formatface", 63587, 1832},
  {"formatsize", 63781, 1837},
  {"input", 63970, 1842},
  {"kernel", 64147, 1847},
  {"kernelevaluation", 64336, 1852},
  {"find", 64536, 1857},
  {"help", 64709, 1862}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 43, 0, 136, "Title"],

Cell[CellGroupData[{
Cell[1844, 57, 130, 2, 36, "Subsection",
  CellTags->{"all", "nonmenu", "nonmenu_MR"}],
Cell[1977, 61, 2882, 74, 241, "Text",
  CellTags->{"all", "nonmenu", "nonmenu_MR"}]
}, Closed]],

Cell[CellGroupData[{
Cell[4896, 140, 97, 2, 36, "Subsection",
  CellTags->{"file", "all"}],
Cell[4996, 144, 3250, 90, 179, "Text",
  CellTags->{"file", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[8283, 239, 97, 2, 36, "Subsection",
  CellTags->{"edit", "all"}],
Cell[8383, 243, 2989, 82, 177, "Text",
  CellTags->{"edit", "all"}],

Cell[CellGroupData[{
Cell[11397, 329, 111, 2, 34, "Subsubsection",
  CellTags->{"editmotion", "all"}],
Cell[11511, 333, 4445, 125, 235, "Text",
  CellTags->{"editmotion", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[15993, 463, 126, 2, 34, "Subsubsection",
  CellTags->{"nonmenu", "all", "nonmenu_MR"}],
Cell[16122, 467, 2227, 61, 115, "Text",
  CellTags->{"nonmenu", "all", "nonmenu_MR"}]
}, Closed]],

Cell[CellGroupData[{
Cell[18386, 533, 125, 2, 34, "Subsubsection",
  CellTags->{"editexpression", "all"}],
Cell[18514, 537, 7592, 204, 361, "Text",
  CellTags->{"editexpression", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[26143, 746, 127, 2, 34, "Subsubsection",
  CellTags->{"nonmenu", "all"}],
Cell[26273, 750, 2952, 77, 145, "Text",
  CellTags->{"nonmenu", "all"}],
Cell[29228, 829, 68, 2, 24, "Text",
  CellTags->"all"]
}, Closed]],

Cell[CellGroupData[{
Cell[29333, 836, 135, 2, 34, "Subsubsection",
  CellTags->{"nonmenu", "all", "nonmenu_MR"}],
Cell[29471, 840, 2495, 71, 155, "Text",
  CellTags->{"nonmenu", "all", "nonmenu_MR"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[32015, 917, 97, 2, 36, "Subsection",
  CellTags->{"cell", "all"}],
Cell[32115, 921, 1607, 45, 89, "Text",
  CellTags->{"cell", "all"}],

Cell[CellGroupData[{
Cell[33747, 970, 116, 2, 24, "Subsubsection",
  CellTags->{"cellconvert", "all"}],
Cell[33866, 974, 1615, 46, 89, "Text",
  CellTags->{"cellconvert", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[35518, 1025, 120, 2, 24, "Subsubsection",
  CellTags->{"cellgrouping", "all"}],
Cell[35641, 1029, 2172, 63, 125, "Text",
  CellTags->{"cellgrouping", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[37862, 1098, 101, 2, 36, "Subsection",
  CellTags->{"format", "all"}],
Cell[37966, 1102, 1374, 39, 83, "Text",
  CellTags->{"format", "all"}],

Cell[CellGroupData[{
Cell[39365, 1145, 111, 2, 36, "Subsubsection",
  CellTags->{"formatstyle", "all"}],
Cell[39479, 1149, 3199, 89, 227, "Text",
  CellTags->{"formatstyle", "all"}],
Cell[42681, 1240, 263, 5, 68, "Notes",
  CellTags->{"all", "formatstyle"}]
}, Closed]],

Cell[CellGroupData[{
Cell[42981, 1250, 109, 2, 32, "Subsubsection",
  CellTags->{"formatface", "all"}],
Cell[43093, 1254, 1307, 37, 71, "Text",
  CellTags->{"formatface", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[44437, 1296, 109, 2, 32, "Subsubsection",
  CellTags->{"formatsize", "all"}],
Cell[44549, 1300, 1409, 40, 71, "Text",
  CellTags->{"formatsize", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[46007, 1346, 99, 2, 36, "Subsection",
  CellTags->{"input", "all"}],
Cell[46109, 1350, 2600, 70, 159, "Text",
  CellTags->{"input", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[48746, 1425, 101, 2, 36, "Subsection",
  CellTags->{"kernel", "all"}],
Cell[48850, 1429, 1376, 39, 71, "Text",
  CellTags->{"kernel", "all"}],

Cell[CellGroupData[{
Cell[50251, 1472, 121, 2, 24, "Subsubsection",
  CellTags->{"kernelevaluation", "all"}],
Cell[50375, 1476, 1773, 48, 99, "Text",
  CellTags->{"kernelevaluation", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[52197, 1530, 97, 2, 36, "Subsection",
  CellTags->{"find", "all"}],
Cell[52297, 1534, 2267, 63, 141, "Text",
  CellTags->{"find", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[54601, 1602, 97, 2, 36, "Subsection",
  CellTags->{"help", "all"}],
Cell[54701, 1606, 1360, 39, 69, "Text",
  CellTags->{"help", "all"}]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

