(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     53419,       1572]*)
(*NotebookOutlinePosition[     68480,       1924]*)
(*  CellTagsIndexPosition[     67832,       1898]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["X Keyboard Shortcuts", "Chapter"],

Cell[TextData[
"\[FilledSmallSquare] Note: Some key commands may be stolen by your window \
manager unless you comment out pre-emptive key definitions in its resource \
file."], "Notes",
  AspectRatioFixed->False,
  CellTags->{
  "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
    "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
    "formatstyle", "formatface", "formatsize", "input", "kernel", 
    "kernelevaluation", "find", "help"}],

Cell[CellGroupData[{

Cell["File Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"file", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["New",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              "\[ControlKey]\[LeftModified]n\[RightModified]"},
            {
              StyleBox["Open",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              "\[ControlKey]\[LeftModified]o\[RightModified]"},
            {
              StyleBox["Close",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              "\[ControlKey]\[LeftModified]w\[RightModified]"},
            {
              StyleBox["Save",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              "\[ControlKey]\[LeftModified]s\[RightModified]"},
            {
              StyleBox[\(Save\ As\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]s\
\[RightModified]"},
            {
              StyleBox["Print",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]p\[RightModified]"},
            {
              StyleBox[
                RowBox[{
                  StyleBox["Print",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontFamily->"Helvetica",
                    FontSize->11,
                    FontWeight->"Plain"], 
                  StyleBox["Selection",
                    FontSize->10]}],
                FontFamily->"Helvetica",
                FontSize->10], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]p\
\[RightModified]"},
            {
              StyleBox["Exit",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]q\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"file", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Edit Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"edit", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Undo",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]z\[RightModified]"},
            {
              StyleBox["Cut",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    "2ColumnSmallBox"], 
                  "\[LeftModified]x\[RightModified]"}]]},
            {
              StyleBox["Copy",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]c\[RightModified]"},
            {
              StyleBox["Paste",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]v\[RightModified]"},
            {
              StyleBox["Clear",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[DeleteKey]"},
            {
              StyleBox[\(Select\ All\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]a\[RightModified]"},
            {
              StyleBox[\(Make\ 2  D\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
                  StyleBox["y",
                    "2ColumnSmallBox"], "\[RightModified]"}]]},
            {
              StyleBox[\(Check\ Balance\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
                  StyleBox["b",
                    "2ColumnSmallBox"], "\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"edit", "all"}],

Cell[CellGroupData[{

Cell["Motion Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editmotion", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[ShortRightArrow]",
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[ShortLeftArrow]",
                FontSize->12]},
            {
              StyleBox[\(Delete\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[\(\(\[DeleteKey]\)\(\ \)\),
                FontSize->12]},
            {
              StyleBox[\(Delete\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["Backspace",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              
              StyleBox[\(\[ControlKey]\[LeftModified] \[ShortRightArrow] \
\[RightModified]\),
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] \[ShortLeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Delete\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    "2ColumnSmallBox"], "\[KeyBar]", 
                  StyleBox["\[DeleteKey]",
                    "2ColumnSmallBox"]}]]},
            {
              StyleBox[\(Delete\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    FontFamily->"Helvetica",
                    FontSize->12,
                    FontWeight->"Plain"], "\[LeftModified]", 
                  StyleBox["B",
                    "2ColumnSmallBox"], "ackspace\[RightModified]"}]]},
            {
              StyleBox[\(Move\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["End",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["Home",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Next\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[DownArrow]",
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[UpArrow]",
                FontSize->12]}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, True, False, False, False, True, 
              False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"editmotion", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Scrolling Commands", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"nonmenu", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Scroll\ Page\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["PageUp",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"]},
            {
              StyleBox[\(Scroll\ Page\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["PageDown",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"]},
            {
              StyleBox[\(Scroll\ Notebook\ Start\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["H",
                    "2ColumnSmallBox"], "ome\[RightModified]"}]]},
            {
              StyleBox[\(Scroll\ Notebook\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["E",
                    "2ColumnSmallBox"], "nd\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->{{1, 1}, {2, 2}}],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"nonmenu", "all", "nonmenu_MR"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Expression Input Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editexpression", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Superscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["^",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], "\[RightModified]"}], "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                "\[ControlKey]\[LeftModified]6\[RightModified]"}]},
            {
              StyleBox["Subscript",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] - \[RightModified]\
\)},
            {
              StyleBox["Above",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox["Below",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", "+", 
                  RowBox[{"\[RightModified]", "  ", 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], "  ", "\[ControlKey]\[LeftModified]"}]}],
                 "=", "\[RightModified]"}]},
            {
              StyleBox[\(Opposite\ Position\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "%", "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                "\[ControlKey]\[LeftModified]5\[RightModified]"}]},
            {
              StyleBox["Fraction",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[ControlKey]\[LeftModified]/\[RightModified]\)},
            {
              StyleBox["Radical",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                
                RowBox[{\(\[ControlKey]\[LeftModified]@\[RightModified]\), "  ",
                   
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], "  ", 
                  "\[ControlKey]\[LeftModified]2\[RightModified]"}], " "}]},
            {
              StyleBox[\(Add\ Row\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[SkeletonIndicator]\[ReturnKey]"},
            {
              StyleBox[\(Add\ Column\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified], \
\[RightModified]\)},
            {
              StyleBox[\(End\ Subexpression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[SkeletonIndicator]\[SpaceKey]"},
            {
              StyleBox[\(Extend\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\(\[ControlKey]\[LeftModified] . \
\[RightModified]\)\(\ \)\)},
            {
              StyleBox[\(Start\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ControlKey]\[LeftModified]", 
                RowBox[{"(", 
                  RowBox[{"\[RightModified]", "  ", 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], "  ", 
                    StyleBox[
                      RowBox[{"\[ControlKey]\[LeftModified]", 
                        StyleBox["9",
                          FontWeight->"Plain"], "\[RightModified]"}]]}]}]}]},
            {
              StyleBox[\(End\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              
              RowBox[{\(\(\[ControlKey]\[LeftModified]\)\()\)\), 
                "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["0",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Insert\ Raw\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "*", "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["8",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Nudge\ Left\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] \[LeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Right\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] \[RightArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified]\[DownArrow]\
\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified]\[UpArrow]\
\[RightModified]\)}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, False, True, False, True, False, True, 
              False, True, False, False, True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"editexpression", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Expression Editing Commands", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"nonmenu", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Placeholder\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[TabKey]",
                FontFamily->"Helvetica",
                FontWeight->"Plain"]},
            {
              StyleBox[\(Move\ Previous\ Placeholder\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]", 
                  StyleBox["\[TabKey]",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"]}]]},
            {
              StyleBox[\(Move\ Next\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[ControlKey]\[KeyBar]\[TabKey]"},
            {
              StyleBox[\(Move\ Previous\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[KeyBar]", 
                    StyleBox["\[TabKey]",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"]}]], " "}]},
            {
              StyleBox[\(Delete\ Next\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[KeyBar]", 
                  StyleBox["\[DeleteKey]",
                    "2ColumnSmallBox"]}]]},
            {
              StyleBox[\(Delete\ Previous\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
                  StyleBox["B",
                    "2ColumnSmallBox"], "ackspace\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->{{1, 1}, {2, 2}}],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"nonmenu", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Commands for Selecting Text", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"nonmenu", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Select\ Next\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ShiftKey]\[LeftModified] \[RightArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Select\ Previous\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ShiftKey]\[LeftModified] \[LeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Select\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[ControlKey]\[KeyBar]\[ShiftKey]\[LeftModified] \[RightArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Select\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \
\(\[ControlKey]\[KeyBar]\[ShiftKey]\[LeftModified] \[LeftArrow] \
\[RightModified]\)},
            {
              StyleBox[\(Select\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[LeftModified]End\[RightModified]"},
            {
              StyleBox[\(Select\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[LeftModified]Home\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->{{1, 1}, {2, 2}}],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"nonmenu", "all", "nonmenu_MR"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"cell", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Divide\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]d\
\[RightModified]"},
            {
              StyleBox[\(Merge\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]m\
\[RightModified]"},
            {
              StyleBox[\(Animate\ Selected\ Graphics\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]y\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"cell", "all"}],

Cell[CellGroupData[{

Cell["Convert To Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"cellconvert", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["InputForm",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]i\
\[RightModified]"},
            {
              StyleBox["StandardForm",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]n\
\[RightModified]"},
            {
              StyleBox["TraditionalForm",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]t\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"cellconvert", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Cell Grouping Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"cellgrouping", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Group\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]g\
\[RightModified]"},
            {
              StyleBox[\(Ungroup\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]u\
\[RightModified]"},
            {
              StyleBox[\(Open\ All\ Subgroups\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified] \
{\[RightModified]\)},
            {
              StyleBox[\(Close\ All\ Subgroups\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\(\(\[ControlKey]\[LeftModified]\)\(}\)\) \
\[RightModified]\)},
            {
              StyleBox[\(Open/Close\ Group\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[ControlKey]\[LeftModified]' \
\[RightModified]\)}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"cellgrouping", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Format Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"format", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Show\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
                  StyleBox["E",
                    "2ColumnSmallBox"], "\[RightModified]"}]]},
            {
              StyleBox[\(Option\ Inspector\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{"\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", 
                  StyleBox["O",
                    "2ColumnSmallBox"], "\[RightModified]"}]]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"format", "all"}],

Cell[CellGroupData[{

Cell["Style Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"formatstyle", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Title",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]1\[RightModified]"},
            {
              StyleBox["Subtitle",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]2\[RightModified]"},
            {
              StyleBox["Subsubtitle",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]3\[RightModified]"},
            {
              StyleBox["Section",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]4\[RightModified]"},
            {
              StyleBox["Subsection",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]5\[RightModified]"},
            {
              StyleBox["Subsubsection",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]6\[RightModified]"},
            {
              StyleBox[\(\(Text\)\(\ \)\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[AltKey]",
                    "2ColumnSmallBox"], 
                  "\[LeftModified]7\[RightModified]"}]]},
            {
              StyleBox[\(Small\ Text\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]8\[RightModified]"},
            {
              StyleBox["Input",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]9\[RightModified]"},
            {
              StyleBox["Other",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[AltKey]\[LeftModified]0\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"formatstyle", "all"}],

Cell["\<\
\[FilledSmallSquare] Note that these keyboard shortcuts may \
correspond to different cell styles than what is given here. The menu's list \
of styles is based on definitions in the current style sheet.\
\>", "Notes",
  CellTags->{"formatstyle", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Face Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"formatface", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Bold",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]b\[RightModified]"},
            {
              StyleBox["Italic",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]i\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"formatface", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Size Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"formatsize", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Smaller",
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] - \[RightModified]\)},
            {
              StyleBox["Larger",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[AltKey]\[LeftModified]", 
                StyleBox["=",
                  "2ColumnSmallBox"], "\[RightModified]"}]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"formatsize", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"input", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(3  D\ ViewPoint\ Selector\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]v\
\[RightModified]"},
            {
              StyleBox[\(Create\ \(Table/Matrix\)/Palette\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]c\
\[RightModified]"},
            {
              StyleBox[\(Copy\ Input\ from\ Above\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]l\[RightModified]"},
            {
              StyleBox[\(Copy\ Output\ from\ Above\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]l\
\[RightModified]"},
            {
              StyleBox[\(Start\ New\ Cell\ Below\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[AltKey]\[KeyBar]\[EnterKey]"},
            {
              StyleBox[\(Complete\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]k\[RightModified]"},
            {
              StyleBox[\(Make\ Template\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]k\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"input", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"kernel", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Interrupt\ Evaluation\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified], \[RightModified]\)},
            {
              StyleBox[\(Abort\ Evaluation\),
                FontFamily->"Helvetica",
                FontSize->10,
                
                FontWeight->
                  "Plain"], \(\[AltKey]\[LeftModified] . \[RightModified]\)}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"kernel", "all"}],

Cell[CellGroupData[{

Cell["Evaluation Submenu", "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"kernelevaluation", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Evaluate\ Cells\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], "\[ShiftKey]\[KeyBar]\[EnterKey]"},
            {
              StyleBox[\(Evaluate\ in\ Place\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[KeyBar]\[EnterKey]"},
            {
              StyleBox[\(Evaluate\ Next\ Input\),
                FontFamily->"Helvetica",
                FontSize->10], "\[ShiftKey]\[KeyBar]\[EnterKey]"},
            {
              RowBox[{" ", 
                StyleBox[\(Evaluate\ in\ Subsession\),
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Plain"]}], 
              StyleBox["F7",
                "2ColumnSmallBox"]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"kernelevaluation", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Find Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"find", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Find",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]f\[RightModified]"},
            {
              StyleBox[\(Enter\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]e\[RightModified]"},
            {
              StyleBox[\(Find\ Next\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["F3",
                "2ColumnSmallBox"]},
            {
              StyleBox["Replace",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]r\[RightModified]"},
            {
              StyleBox[\(Replace\ and\ Find\ Again\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]r\
\[RightModified]"},
            {
              StyleBox[\(Add/Remove\ Cell\ Tags\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]j\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"find", "all"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Help Menu", "Subsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"help", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Find\ in\ Help\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["F1",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Why\ the\ \(\(Beep\)\(?\)\)\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]h\
\[RightModified]"}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  AutoSpacing->False,
  CellTags->{"help", "all"}]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1148}, {0, 848}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->{},
WindowSize->{566, 676},
WindowMargins->{{38, Automatic}, {Automatic, 22}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "New"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}]},
  "all"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[2319, 68, 97, 2, 36, "Subsection",
      CellTags->{"file", "all"}],
    Cell[2419, 72, 3034, 85, 179, "Text",
      CellTags->{"file", "all"}],
    Cell[5490, 162, 97, 2, 36, "Subsection",
      CellTags->{"edit", "all"}],
    Cell[5590, 166, 2989, 82, 177, "Text",
      CellTags->{"edit", "all"}],
    Cell[8604, 252, 111, 2, 34, "Subsubsection",
      CellTags->{"editmotion", "all"}],
    Cell[8718, 256, 4445, 125, 235, "Text",
      CellTags->{"editmotion", "all"}],
    Cell[13200, 386, 112, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[13315, 390, 2227, 61, 115, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[15579, 456, 125, 2, 24, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[15707, 460, 7592, 204, 361, "Text",
      CellTags->{"editexpression", "all"}],
    Cell[23336, 669, 127, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[23466, 673, 2952, 77, 145, "Text",
      CellTags->{"nonmenu", "all"}],
    Cell[26455, 755, 121, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[26579, 759, 2495, 71, 155, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[29123, 836, 97, 2, 36, "Subsection",
      CellTags->{"cell", "all"}],
    Cell[29223, 840, 1607, 45, 89, "Text",
      CellTags->{"cell", "all"}],
    Cell[30855, 889, 116, 2, 24, "Subsubsection",
      CellTags->{"cellconvert", "all"}],
    Cell[30974, 893, 1615, 46, 89, "Text",
      CellTags->{"cellconvert", "all"}],
    Cell[32626, 944, 120, 2, 24, "Subsubsection",
      CellTags->{"cellgrouping", "all"}],
    Cell[32749, 948, 2172, 63, 125, "Text",
      CellTags->{"cellgrouping", "all"}],
    Cell[34970, 1017, 101, 2, 36, "Subsection",
      CellTags->{"format", "all"}],
    Cell[35074, 1021, 1596, 43, 83, "Text",
      CellTags->{"format", "all"}],
    Cell[36695, 1068, 111, 2, 36, "Subsubsection",
      CellTags->{"formatstyle", "all"}],
    Cell[36809, 1072, 3199, 89, 227, "Text",
      CellTags->{"formatstyle", "all"}],
    Cell[40011, 1163, 263, 5, 52, "Notes",
      CellTags->{"formatstyle", "all"}],
    Cell[40311, 1173, 109, 2, 36, "Subsubsection",
      CellTags->{"formatface", "all"}],
    Cell[40423, 1177, 1307, 37, 71, "Text",
      CellTags->{"formatface", "all"}],
    Cell[41767, 1219, 109, 2, 32, "Subsubsection",
      CellTags->{"formatsize", "all"}],
    Cell[41879, 1223, 1409, 40, 71, "Text",
      CellTags->{"formatsize", "all"}],
    Cell[43337, 1269, 99, 2, 36, "Subsection",
      CellTags->{"input", "all"}],
    Cell[43439, 1273, 2600, 70, 159, "Text",
      CellTags->{"input", "all"}],
    Cell[46076, 1348, 101, 2, 36, "Subsection",
      CellTags->{"kernel", "all"}],
    Cell[46180, 1352, 1376, 39, 71, "Text",
      CellTags->{"kernel", "all"}],
    Cell[47581, 1395, 121, 2, 24, "Subsubsection",
      CellTags->{"kernelevaluation", "all"}],
    Cell[47705, 1399, 1773, 48, 99, "Text",
      CellTags->{"kernelevaluation", "all"}],
    Cell[49527, 1453, 97, 2, 36, "Subsection",
      CellTags->{"find", "all"}],
    Cell[49627, 1457, 2267, 63, 141, "Text",
      CellTags->{"find", "all"}],
    Cell[51931, 1525, 97, 2, 36, "Subsection",
      CellTags->{"help", "all"}],
    Cell[52031, 1529, 1360, 39, 69, "Text",
      CellTags->{"help", "all"}]},
  "formula"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}]},
  "file"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[2319, 68, 97, 2, 36, "Subsection",
      CellTags->{"file", "all"}],
    Cell[2419, 72, 3034, 85, 179, "Text",
      CellTags->{"file", "all"}]},
  "edit"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[5490, 162, 97, 2, 36, "Subsection",
      CellTags->{"edit", "all"}],
    Cell[5590, 166, 2989, 82, 177, "Text",
      CellTags->{"edit", "all"}]},
  "editmotion"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[8604, 252, 111, 2, 34, "Subsubsection",
      CellTags->{"editmotion", "all"}],
    Cell[8718, 256, 4445, 125, 235, "Text",
      CellTags->{"editmotion", "all"}]},
  "nonmenu"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[13200, 386, 112, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[13315, 390, 2227, 61, 115, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[23336, 669, 127, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[23466, 673, 2952, 77, 145, "Text",
      CellTags->{"nonmenu", "all"}],
    Cell[26455, 755, 121, 2, 34, "Subsubsection",
      CellTags->{"nonmenu", "all"}],
    Cell[26579, 759, 2495, 71, 155, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}]},
  "editexpression"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[15579, 456, 125, 2, 24, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[15707, 460, 7592, 204, 361, "Text",
      CellTags->{"editexpression", "all"}]},
  "cell"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[29123, 836, 97, 2, 36, "Subsection",
      CellTags->{"cell", "all"}],
    Cell[29223, 840, 1607, 45, 89, "Text",
      CellTags->{"cell", "all"}]},
  "cellconvert"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[30855, 889, 116, 2, 24, "Subsubsection",
      CellTags->{"cellconvert", "all"}],
    Cell[30974, 893, 1615, 46, 89, "Text",
      CellTags->{"cellconvert", "all"}]},
  "cellgrouping"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[32626, 944, 120, 2, 24, "Subsubsection",
      CellTags->{"cellgrouping", "all"}],
    Cell[32749, 948, 2172, 63, 125, "Text",
      CellTags->{"cellgrouping", "all"}]},
  "format"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[34970, 1017, 101, 2, 36, "Subsection",
      CellTags->{"format", "all"}],
    Cell[35074, 1021, 1596, 43, 83, "Text",
      CellTags->{"format", "all"}]},
  "formatstyle"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[36695, 1068, 111, 2, 36, "Subsubsection",
      CellTags->{"formatstyle", "all"}],
    Cell[36809, 1072, 3199, 89, 227, "Text",
      CellTags->{"formatstyle", "all"}],
    Cell[40011, 1163, 263, 5, 52, "Notes",
      CellTags->{"formatstyle", "all"}]},
  "formatface"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[40311, 1173, 109, 2, 36, "Subsubsection",
      CellTags->{"formatface", "all"}],
    Cell[40423, 1177, 1307, 37, 71, "Text",
      CellTags->{"formatface", "all"}]},
  "formatsize"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[41767, 1219, 109, 2, 32, "Subsubsection",
      CellTags->{"formatsize", "all"}],
    Cell[41879, 1223, 1409, 40, 71, "Text",
      CellTags->{"formatsize", "all"}]},
  "input"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[43337, 1269, 99, 2, 36, "Subsection",
      CellTags->{"input", "all"}],
    Cell[43439, 1273, 2600, 70, 159, "Text",
      CellTags->{"input", "all"}]},
  "kernel"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[46076, 1348, 101, 2, 36, "Subsection",
      CellTags->{"kernel", "all"}],
    Cell[46180, 1352, 1376, 39, 71, "Text",
      CellTags->{"kernel", "all"}]},
  "kernelevaluation"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[47581, 1395, 121, 2, 24, "Subsubsection",
      CellTags->{"kernelevaluation", "all"}],
    Cell[47705, 1399, 1773, 48, 99, "Text",
      CellTags->{"kernelevaluation", "all"}]},
  "find"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[49527, 1453, 97, 2, 36, "Subsection",
      CellTags->{"find", "all"}],
    Cell[49627, 1457, 2267, 63, 141, "Text",
      CellTags->{"find", "all"}]},
  "help"->{
    Cell[1818, 55, 476, 9, 40, "Notes",
      CellTags->{
      "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
        "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
        "formatstyle", "formatface", "formatsize", "input", "kernel", 
        "kernelevaluation", "find", "help"}],
    Cell[51931, 1525, 97, 2, 36, "Subsection",
      CellTags->{"help", "all"}],
    Cell[52031, 1529, 1360, 39, 69, "Text",
      CellTags->{"help", "all"}]},
  "nonmenu_MR"->{
    Cell[13315, 390, 2227, 61, 115, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}],
    Cell[26579, 759, 2495, 71, 155, "Text",
      CellTags->{"nonmenu", "all", "nonmenu_MR"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"New", 54166, 1593},
  {"all", 54502, 1600},
  {"formula", 58158, 1685},
  {"file", 58495, 1692},
  {"edit", 58986, 1703},
  {"editmotion", 59485, 1714},
  {"nonmenu", 59998, 1725},
  {"editexpression", 60877, 1744},
  {"cell", 61397, 1755},
  {"cellconvert", 61898, 1766},
  {"cellgrouping", 62418, 1777},
  {"format", 62935, 1788},
  {"formatstyle", 63443, 1799},
  {"formatface", 64048, 1812},
  {"formatsize", 64566, 1823},
  {"input", 65079, 1834},
  {"kernel", 65580, 1845},
  {"kernelevaluation", 66093, 1856},
  {"find", 66617, 1867},
  {"help", 67114, 1878},
  {"nonmenu_MR", 67616, 1889}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 39, 0, 88, "Chapter"],
Cell[1818, 55, 476, 9, 40, "Notes",
  CellTags->{
  "New", "all", "formula", "file", "edit", "editmotion", "nonmenu", 
    "editexpression", "cell", "cellconvert", "cellgrouping", "format", 
    "formatstyle", "formatface", "formatsize", "input", "kernel", 
    "kernelevaluation", "find", "help"}],

Cell[CellGroupData[{
Cell[2319, 68, 97, 2, 36, "Subsection",
  CellTags->{"file", "all"}],
Cell[2419, 72, 3034, 85, 179, "Text",
  CellTags->{"file", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[5490, 162, 97, 2, 36, "Subsection",
  CellTags->{"edit", "all"}],
Cell[5590, 166, 2989, 82, 177, "Text",
  CellTags->{"edit", "all"}],

Cell[CellGroupData[{
Cell[8604, 252, 111, 2, 34, "Subsubsection",
  CellTags->{"editmotion", "all"}],
Cell[8718, 256, 4445, 125, 235, "Text",
  CellTags->{"editmotion", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[13200, 386, 112, 2, 34, "Subsubsection",
  CellTags->{"nonmenu", "all"}],
Cell[13315, 390, 2227, 61, 115, "Text",
  CellTags->{"nonmenu", "all", "nonmenu_MR"}]
}, Closed]],

Cell[CellGroupData[{
Cell[15579, 456, 125, 2, 24, "Subsubsection",
  CellTags->{"editexpression", "all"}],
Cell[15707, 460, 7592, 204, 361, "Text",
  CellTags->{"editexpression", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[23336, 669, 127, 2, 34, "Subsubsection",
  CellTags->{"nonmenu", "all"}],
Cell[23466, 673, 2952, 77, 145, "Text",
  CellTags->{"nonmenu", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[26455, 755, 121, 2, 34, "Subsubsection",
  CellTags->{"nonmenu", "all"}],
Cell[26579, 759, 2495, 71, 155, "Text",
  CellTags->{"nonmenu", "all", "nonmenu_MR"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[29123, 836, 97, 2, 36, "Subsection",
  CellTags->{"cell", "all"}],
Cell[29223, 840, 1607, 45, 89, "Text",
  CellTags->{"cell", "all"}],

Cell[CellGroupData[{
Cell[30855, 889, 116, 2, 24, "Subsubsection",
  CellTags->{"cellconvert", "all"}],
Cell[30974, 893, 1615, 46, 89, "Text",
  CellTags->{"cellconvert", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[32626, 944, 120, 2, 24, "Subsubsection",
  CellTags->{"cellgrouping", "all"}],
Cell[32749, 948, 2172, 63, 125, "Text",
  CellTags->{"cellgrouping", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[34970, 1017, 101, 2, 36, "Subsection",
  CellTags->{"format", "all"}],
Cell[35074, 1021, 1596, 43, 83, "Text",
  CellTags->{"format", "all"}],

Cell[CellGroupData[{
Cell[36695, 1068, 111, 2, 36, "Subsubsection",
  CellTags->{"formatstyle", "all"}],
Cell[36809, 1072, 3199, 89, 227, "Text",
  CellTags->{"formatstyle", "all"}],
Cell[40011, 1163, 263, 5, 52, "Notes",
  CellTags->{"formatstyle", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[40311, 1173, 109, 2, 36, "Subsubsection",
  CellTags->{"formatface", "all"}],
Cell[40423, 1177, 1307, 37, 71, "Text",
  CellTags->{"formatface", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[41767, 1219, 109, 2, 32, "Subsubsection",
  CellTags->{"formatsize", "all"}],
Cell[41879, 1223, 1409, 40, 71, "Text",
  CellTags->{"formatsize", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[43337, 1269, 99, 2, 36, "Subsection",
  CellTags->{"input", "all"}],
Cell[43439, 1273, 2600, 70, 159, "Text",
  CellTags->{"input", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[46076, 1348, 101, 2, 36, "Subsection",
  CellTags->{"kernel", "all"}],
Cell[46180, 1352, 1376, 39, 71, "Text",
  CellTags->{"kernel", "all"}],

Cell[CellGroupData[{
Cell[47581, 1395, 121, 2, 24, "Subsubsection",
  CellTags->{"kernelevaluation", "all"}],
Cell[47705, 1399, 1773, 48, 99, "Text",
  CellTags->{"kernelevaluation", "all"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[49527, 1453, 97, 2, 36, "Subsection",
  CellTags->{"find", "all"}],
Cell[49627, 1457, 2267, 63, 141, "Text",
  CellTags->{"find", "all"}]
}, Closed]],

Cell[CellGroupData[{
Cell[51931, 1525, 97, 2, 36, "Subsection",
  CellTags->{"help", "all"}],
Cell[52031, 1529, 1360, 39, 69, "Text",
  CellTags->{"help", "all"}]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

