(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    222554,       5471]*)
(*NotebookOutlinePosition[    223818,       5515]*)
(*  CellTagsIndexPosition[    223663,       5506]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Boundary Value Problems", "Chapter"],

Cell[CellGroupData[{

Cell["Methods", "Section",
  CellTags->"c:2"],

Cell[CellGroupData[{

Cell["Chasing", "Subsection",
  CellTags->{"c:3", "b:9.0", "ndsg:3.1.0"}],

Cell[TextData[{
  "The method of chasing came from a manuscript of Gel`fand and \
Lokutsiyevskii first published in English in [",
  ButtonBox["BZ65",
    ButtonData:>{"References.nb", "BZ65"},
    ButtonStyle->"Hyperlink"],
  "] and further described in [",
  ButtonBox["Na79",
    ButtonData:>{"References.nb", "Na79"},
    ButtonStyle->"Hyperlink"],
  "]. The idea is to establish a set of auxiliary problems that can be solved \
to find initial conditions at one of the boundaries. Once the initial \
conditions are determined, the usual methods for solving initial value \
problems can be applied. "
}], "Text"],

Cell["Consider the linear ODE", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SuperscriptBox["X", "\[Prime]",
            MultilineFunction->None], " ", \((t)\)}], "==", 
        " ", \(\(A(t)\)\ \(X(t)\)\  + \ \(A\_0\)(t)\)}], 
      TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`X(t)\  = \ (\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\)(t)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_2\)(t)\)]],
  ", \[CenterEllipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_n\)(t)\)]],
  "), ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(A(t)\)\(\ \)\)\)]],
  "is the coefficient matrix, and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(A\_0\)(t)\)\(\ \)\)\)]],
  "is the inhomogeneous coefficient vector, with ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(n\)\(\ \)\)\)]],
  "linear boundary conditions "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`B\_i\  . \ \(X(t\_i)\)\  \[Equal] b\_i0, \ 
    i\  = \ 1, \ 2, \ \[CenterEllipsis], \ n\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(B\_i\), " ", "=", " ", 
          RowBox[{"(", 
            RowBox[{
              SubscriptBox["b", 
                StyleBox[
                  RowBox[{
                    StyleBox["i",
                      FontSlant->"Italic"], "1"}]]], ",", 
              SubscriptBox["b", 
                StyleBox[
                  RowBox[{
                    StyleBox["i",
                      FontSlant->"Italic"], "2"}]]], ",", "\[CenterEllipsis]",
               ",", 
              FormBox[
                SubscriptBox["b", 
                  StyleBox["in",
                    FontSlant->"Italic"]],
                "TraditionalForm"]}], ")"}]}], TraditionalForm]]],
  "is a coefficient vector.",
  " ",
  "From this, construct the augmented homogenous system"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox[\(X\&_\), "\[Prime]",
              MultilineFunction->None], " ", \((t)\)}], "=", 
          " ", \(\(\(A\&_\)(t)\)\ \(\(X\&_\)(t)\)\)}], ",", 
        "         ", \(B\&_\_i\  . \ \(\(X\&_\)(t\_i)\)\  = \ 0\)}], 
      TraditionalForm]], "NumberedEquation"],

Cell["where", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\(X\&_\)(t)\), " ", "=", " ", 
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"1"},
                {\(\(x\_1\)(t)\)},
                {\(\(x\_2\)(t)\)},
                {"\[VerticalEllipsis]"},
                {\(\(x\_n\)(t)\)}
                }], "\[NoBreak]", ")"}]}], "  ", ",", "   ", 
        RowBox[{\(\(A\&_\)(t)\), " ", "=", " ", 
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(\(a\_01\)(t)\), \(\(a\_11\)(t)\), \(\(a\_12\)(t)\), 
                  "\[CenterEllipsis]", \(\(a\_\(1\ n\)\)(t)\)},
                {\(\(a\_02\)(t)\), \(\(a\_21\)(t)\), \(\(a\_22\)(t)\), 
                  "\[CenterEllipsis]", \(\(a\_\(2\ n\)\)(t)\)},
                {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
                  "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
                  "\[VerticalEllipsis]"},
                {\(\(a\_\(0\ n\)\)(t)\), \(\(a\_n1\)(t)\), \(\(a\_n2\)(t)\), 
                  "\[CenterEllipsis]", \(\(a\_nn\)(t)\)},
                {"0", "0", "0", "\[CenterEllipsis]", "0"}
                }], "\[NoBreak]", ")"}]}], ",", " ", 
        RowBox[{\(and\ \ B\&_\_i\), " ", "=", "  ", 
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {
                  SubscriptBox["b", 
                    StyleBox[
                      RowBox[{
                        StyleBox["i",
                          FontSlant->"Italic"], "0"}]]]},
                {
                  SubscriptBox["b", 
                    StyleBox[
                      RowBox[{
                        StyleBox["i",
                          FontSlant->"Italic"], "1"}]]]},
                {
                  SubscriptBox["b", 
                    StyleBox[
                      RowBox[{
                        StyleBox["i",
                          FontSlant->"Italic"], "2"}]]]},
                {"\[VerticalEllipsis]"},
                {
                  SubscriptBox["b", 
                    StyleBox["in",
                      FontSlant->"Italic"]]}
                }], "\[NoBreak]", ")"}]}]}], TraditionalForm]], "DisplayMath"],

Cell[TextData[{
  "The chasing method amounts to finding a vector function ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_i\)(t)\)]],
  "such that ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_i\)(t\_i)\)]],
  " = ",
  Cell[BoxData[
      \(TraditionalForm\`\(B\_i\)\&_\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[CapitalPhi]\_i\)(t)\)\ \(\(X\&_\)(t)\) = 
        0\)]],
  ". Once the function ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\[CapitalPhi]\_i\)(t)\)\(\ \)\)\)]],
  "is known, if there is a full set of boundary conditions, solving "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{
          RowBox[{
            RowBox[{"(", "\[NoBreak]", GridBox[{
                  {\(\(\[CapitalPhi]\_1\)(t\_0)\)},
                  {\(\(\[CapitalPhi]\_2\)(t\_0)\)},
                  {"\[VerticalEllipsis]"},
                  {\(\(\[CapitalPhi]\_n\)(t\_0)\)}
                  }], "\[NoBreak]", ")"}], " ", \(\(X\&_\)(t\_0)\)}], " ", 
          "=", " ", "0"}]}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "can be used to determine initial conditions ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(x\_1\)(t\_0), \ \(x\_2\)(
          t\_0), \ \[CenterEllipsis]\ , \ \(x\_n\)(t\_0))\)\)]],
  " that can be used with the usual initial value problem solvers. Note that \
the solution to system (3) is nontrivial because the first component of ",
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  "is always 1. "
}], "Text"],

Cell[TextData[{
  "Thus, solving the boundary value problem is reduced to solving the \
auxiliary problems for the ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_i\)(t)\)]],
  ".",
  " ",
  "Differentiating the equation for ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_i\ \((t)\)\)]],
  "gives"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\(\[CapitalPhi]\_i\)(t)\), " ", 
            RowBox[{
              SuperscriptBox[\(X\&_\), "\[Prime]",
                MultilineFunction->None], "(", "t", ")"}]}], "+", 
          RowBox[{\(\(X\&_\)(t)\), " ", 
            RowBox[{
              SuperscriptBox[\(\[CapitalPhi]\_i\), "\[Prime]",
                MultilineFunction->None], "(", "t", ")"}]}]}], " ", "=", " ", 
        "0"}], TraditionalForm]], "DisplayMath"],

Cell["Substituting the differential equation, ", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\(\(A\&_\)(t)\)\ \(\(X\&_\)(t)\)\ \(\(\[CapitalPhi]\_i\)(
              t)\)\), "+", 
          RowBox[{\(\(X\&_\)(t)\), " ", 
            RowBox[{
              SuperscriptBox[\(\[CapitalPhi]\_i\), "\[Prime]",
                MultilineFunction->None], "(", "t", ")"}]}]}], " ", "=", " ", 
        "0"}], TraditionalForm]], "DisplayMath"],

Cell["and transposing", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{
          RowBox[{\(\(X\&_\)(t)\), 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SuperscriptBox[\(\[CapitalPhi]\_i\), "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], " ", 
                "+", \(\(\(A\&_\^T\)(t)\)\ \(\(\[CapitalPhi]\_i\)(t)\)\)}], 
              ")"}]}], " ", "=", " ", "0"}]}], 
      TraditionalForm]], "DisplayMath"],

Cell[TextData[{
  "Since this should hold for all solutions ",
  Cell[BoxData[
      \(TraditionalForm\`X\&_\)]],
  ", we have the initial value problem for ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_i\)]],
  ","
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox[\(\[CapitalPhi]\_i\), "\[Prime]",
                MultilineFunction->None], "(", "t", ")"}], " ", 
            "+", \(\(\(A\&_\^T\)(t)\)\ \(\(\[CapitalPhi]\_i\)(t)\)\)}], "=", 
          " ", \(0\ with\ initial\ condition\ \ \(\(\[CapitalPhi]\_i\)(
                t\_i)\)\  = \ B\_i\)}]}], 
      TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "Given ",
  Cell[BoxData[
      \(TraditionalForm\`t\_0\)]],
  "where we want to have solutions to all of the boundary value problems, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " just uses ",
  StyleBox["NDSolve", "MR"],
  " to solve the auxiliary problems for ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_1\)]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_2\)]],
  ", ...  ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_m\)]],
  "by integrating them to ",
  Cell[BoxData[
      \(TraditionalForm\`t\_0\)]],
  ". The results are then combined into the matrix of Equation (3) that is \
solved for ",
  Cell[BoxData[
      \(TraditionalForm\`X(t\_0)\)]],
  " to obtain the initial value problem that ",
  StyleBox["NDSolve", "MR"],
  " integrates to give the returned solution. "
}], "Text"],

Cell[TextData[{
  "This variant of the method is further described in and used by the ",
  StyleBox["MathSource",
    FontSlant->"Italic"],
  " package [",
  ButtonBox["R98",
    ButtonData:>{"References.nb", "R98"},
    ButtonStyle->"Hyperlink"],
  "], which also allows you to solve linear eigenvalue problems."
}], "Text"],

Cell[TextData[{
  "There is an alternative, nonlinear way to set up the auxiliary problems \
that is closer to the original method proposed by Gel'fand and \
Lokutsiyevskii. Assume that the boundary conditions are linearly independent \
(if not, then the problem is insufficiently specified). Then in each ",
  Cell[BoxData[
      \(TraditionalForm\`B\_i\)]],
  ", there is at least one nonzero component. Without loss of generality, \
assume that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["b", 
            StyleBox["ij",
              FontSlant->"Italic"]], "\[NotEqual]", " ", "0."}], 
        TraditionalForm]]],
  " Now solve for ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[CapitalPhi]", 
          StyleBox["ij",
            FontSlant->"Italic"]], TraditionalForm]]],
  "in terms of the other components of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_ij\)]],
  " = ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(B\_i\)\&~\)\)]],
  ".",
  Cell[BoxData[
      FormBox[
        OverscriptBox[
          FormBox[\(\[CapitalPhi]\_i\),
            "TraditionalForm"], "~"], TraditionalForm]]],
  ", where ",
  Cell[BoxData[
      FormBox[
        OverscriptBox[
          FormBox[\(\[CapitalPhi]\_i\),
            "TraditionalForm"], "~"], TraditionalForm]]],
  " = (1, ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[CapitalPhi]", 
          StyleBox[
            RowBox[{
              StyleBox["i",
                FontSlant->"Italic"], "1"}]]], TraditionalForm]]],
  ",\[CenterEllipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[CapitalPhi]", 
          RowBox[{
            StyleBox["ij",
              FontSlant->"Italic"], "-", "1"}]], TraditionalForm]]],
  ",\[CenterEllipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[CapitalPhi]", 
          RowBox[{
            StyleBox["ij",
              FontSlant->"Italic"], "+", "1"}]], TraditionalForm]]],
  ",\[CenterEllipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[CapitalPhi]", 
          StyleBox["in",
            FontSlant->"Italic"]], TraditionalForm]]],
  ") and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(B\_i\)\&~\)\)]],
  " = ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                FormBox[
                  RowBox[{"(", 
                    SubscriptBox["b", 
                      RowBox[{
                        StyleBox[
                          RowBox[{
                            StyleBox["i",
                              FontSlant->"Italic"], "0"}]], ",", " "}]]}],
                  "TraditionalForm"], 
                FormBox[
                  SubscriptBox["b", 
                    StyleBox[
                      RowBox[{
                        StyleBox["i",
                          FontSlant->"Italic"], "1"}]]],
                  "TraditionalForm"]}], ",", "\[CenterEllipsis]", ",", 
              FormBox[
                SubscriptBox["b", 
                  RowBox[{
                    StyleBox["ij",
                      FontSlant->"Italic"], "-", "1"}]],
                "TraditionalForm"], ",", "\[CenterEllipsis]", ",", 
              FormBox[
                SubscriptBox["b", 
                  RowBox[{
                    StyleBox["ij",
                      FontSlant->"Italic"], "+", "1"}]],
                "TraditionalForm"], ",", "\[CenterEllipsis]", ",", 
              FormBox[
                SubscriptBox["b", 
                  StyleBox["in",
                    FontSlant->"Italic"]],
                "TraditionalForm"]}], ")"}], "/", 
          RowBox[{"-", 
            SubscriptBox["b", 
              StyleBox["ij",
                FontSlant->"Italic"]]}]}], TraditionalForm]]],
  ". Using (5) and replacing ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[CapitalPhi]", 
          StyleBox["ij",
            FontSlant->"Italic"]], TraditionalForm]]],
  ", and thinking of ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_n\)(t)\)]],
  "in terms of the other components of ",
  Cell[BoxData[
      \(TraditionalForm\`x(t)\)]],
  "we get the nonlinear equation"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SuperscriptBox[\(\(\[CapitalPhi]\_i\)\&~\), "\[Prime]",
            MultilineFunction->None], "(", "t", ")"}], 
        "=", \(\(-\(\(A\&~\)\^T\)[t]\)\ \(\(\(\[CapitalPhi]\_i\)\&~\)(
              t)\) + \((A\_j . \(\(\(\[CapitalPhi]\_i\)\&~\)(
                  t)\))\)\ \(\(\(\[CapitalPhi]\_i\)\&~\)(t)\)\)}], 
      TraditionalForm]], "DisplayMath"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\(A\&~\)\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " with the ",
  Cell[BoxData[
      \(TraditionalForm\`j\^th\)]],
  "column removed and ",
  Cell[BoxData[
      \(TraditionalForm\`A\_j\)]],
  "is the ",
  Cell[BoxData[
      \(TraditionalForm\`j\^\(\(th\)\(\ \)\)\)]],
  "column of A. The nonlinear method can be more numerically stable than the \
linear method, but it has the disadvantage that integration along the real \
line may lead to singularities. This problem can be eliminated by integrating \
on a contour in the complex plane. However, the integration in the complex \
plane typically has more numerical error than a simple integration along the \
real line, so in practice, the nonlinear method does not typically give \
results better than the linear method. For this reason, and because it is \
also generally faster, the default for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is to use the linear method."
}], "Text"],

Cell["\<\
This solves a two-point boundary value problem for a second-order equation.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nsol1\  = \ 
      NDSolve[{\(y''\)[t]\  + \ y[t]/4\  \[Equal] \ 8, \ 
          y[0]\  \[Equal] \ 0, \ y[10]\  \[Equal] \ 0}, 
        y, {t, 0, 10}]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell["This shows a plot of the solution.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[First[y[t]\  /. \ nsol1], \ {t, 0, 10}]\)], "Input",
  CellLabel->"In[2]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0147151 0.00818156 [
[.21429 .00222 -3 -9 ]
[.21429 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .09653 -12 -4.5 ]
[.01131 .09653 0 4.5 ]
[.01131 .17835 -12 -4.5 ]
[.01131 .17835 0 4.5 ]
[.01131 .26016 -12 -4.5 ]
[.01131 .26016 0 4.5 ]
[.01131 .34198 -12 -4.5 ]
[.01131 .34198 0 4.5 ]
[.01131 .42379 -12 -4.5 ]
[.01131 .42379 0 4.5 ]
[.01131 .50561 -12 -4.5 ]
[.01131 .50561 0 4.5 ]
[.01131 .58742 -12 -4.5 ]
[.01131 .58742 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(10)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09653 m
.03006 .09653 L
s
[(10)] .01131 .09653 1 0 Mshowa
.02381 .17835 m
.03006 .17835 L
s
[(20)] .01131 .17835 1 0 Mshowa
.02381 .26016 m
.03006 .26016 L
s
[(30)] .01131 .26016 1 0 Mshowa
.02381 .34198 m
.03006 .34198 L
s
[(40)] .01131 .34198 1 0 Mshowa
.02381 .42379 m
.03006 .42379 L
s
[(50)] .01131 .42379 1 0 Mshowa
.02381 .50561 m
.03006 .50561 L
s
[(60)] .01131 .50561 1 0 Mshowa
.02381 .58742 m
.03006 .58742 L
s
[(70)] .01131 .58742 1 0 Mshowa
.125 Mabswid
.02381 .03108 m
.02756 .03108 L
s
.02381 .04744 m
.02756 .04744 L
s
.02381 .0638 m
.02756 .0638 L
s
.02381 .08017 m
.02756 .08017 L
s
.02381 .11289 m
.02756 .11289 L
s
.02381 .12926 m
.02756 .12926 L
s
.02381 .14562 m
.02756 .14562 L
s
.02381 .16198 m
.02756 .16198 L
s
.02381 .19471 m
.02756 .19471 L
s
.02381 .21107 m
.02756 .21107 L
s
.02381 .22744 m
.02756 .22744 L
s
.02381 .2438 m
.02756 .2438 L
s
.02381 .27652 m
.02756 .27652 L
s
.02381 .29289 m
.02756 .29289 L
s
.02381 .30925 m
.02756 .30925 L
s
.02381 .32561 m
.02756 .32561 L
s
.02381 .35834 m
.02756 .35834 L
s
.02381 .3747 m
.02756 .3747 L
s
.02381 .39107 m
.02756 .39107 L
s
.02381 .40743 m
.02756 .40743 L
s
.02381 .44016 m
.02756 .44016 L
s
.02381 .45652 m
.02756 .45652 L
s
.02381 .47288 m
.02756 .47288 L
s
.02381 .48925 m
.02756 .48925 L
s
.02381 .52197 m
.02756 .52197 L
s
.02381 .53833 m
.02756 .53833 L
s
.02381 .5547 m
.02756 .5547 L
s
.02381 .57106 m
.02756 .57106 L
s
.02381 .60379 m
.02756 .60379 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .05948 L
.10458 .11837 L
.14415 .18076 L
.18221 .24468 L
.22272 .31404 L
.26171 .37925 L
.30316 .4438 L
.34309 .49856 L
.3815 .54209 L
.40095 .56012 L
.42237 .57655 L
.44268 .58864 L
.45178 .59291 L
.46172 .59674 L
.4671 .59846 L
.4721 .59982 L
.47727 .601 L
.48196 .60186 L
.48658 .60251 L
.4887 .60274 L
.49093 .60295 L
.49332 .60312 L
.49438 .60318 L
.49552 .60323 L
.49675 .60327 L
.49789 .6033 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .60328 L
.50401 .60325 L
.50508 .6032 L
.50754 .60306 L
.51014 .60286 L
.51268 .6026 L
.51504 .6023 L
.5204 .60145 L
.5293 .59946 L
.53882 .59656 L
.54906 .59254 L
.56016 .58715 L
.58032 .5747 L
.62123 .53933 L
.66064 .49383 L
.69852 .44132 L
.73886 .37832 L
.77769 .31335 L
.81897 .24267 L
Mistroke
.85873 .17605 L
.89697 .11605 L
.93767 .05934 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[2]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00A03oool400000340oooo0`00000_0?ooo`<00000<P3oool2000002h0oooo1@0000020?oo
o`8000001`3oool004@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0^0?ooo`04
0000003oool0oooo00000300oooo00@000000?ooo`3oool00000;`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0103oool004D0oooo00<000000?ooo`3oool0;`3oool5
000002l0oooo00@000000?ooo`3oool00000<03oool010000000oooo0?ooo`00000_0?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`00AP3oool00`000000oooo
0?ooo`0^0?ooo`040000003oool0oooo00000300oooo0`00000b0?ooo`800000<03oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool004@0oooo00@000000?ooo`3o
ool00000<03oool00`000000oooo0000000a0?ooo`030000003oool0oooo0300oooo00@000000?oo
o`3oool00000;`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103o
ool004D0oooo0P00000b0?ooo`800000<@3oool300000340oooo0P00000_0?ooo`800000103oool2
000000L0oooo003o0?ooob40oooo000B0?ooo`030000003oool0oooo0?l0oooo303oool00180oooo
00<000000?ooo`3oool0o`3oool<0?ooo`004P3oool00`000000oooo0?ooo`3o0?ooo``0oooo000B
0?ooo`030000003oool0oooo0?l0oooo303oool000/0ooooo`00000C000000<0oooo000B0?ooo`80
00002`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`090?ooo`8000002P3oool00180oooo00<000000?ooo`000000
<@3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0
<@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0000000X0oooo000B0?ooo`030000003o
ool000000?d0oooo00<000000?ooo`3oool02`3oool00180oooo0P0000000`3oool000000?ooo`3k
0?ooo`030000003oool0oooo00/0oooo000B0?ooo`050000003oool0oooo0?ooo`000000nP3oool0
0`000000oooo0?ooo`0<0?ooo`004P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0?H0oooo00<000000?ooo`3oool03@3oool00180oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`3d0?ooo`030000003oool0oooo00h0oooo000B0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0lP3oool00`000000oooo0?ooo`0?0?ooo`004P3oool2000000D0oooo00<0
00000?ooo`3oool0l@3oool00`000000oooo0?ooo`0@0?ooo`004P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0?00oooo00<000000?ooo`3oool0403oool00180oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`3^0?ooo`030000003oool0oooo0140oooo000B0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0k03oool00`000000oooo0?ooo`0B0?ooo`00
4P3oool2000000T0oooo00<000000?ooo`3oool0jP3oool00`000000oooo0?ooo`0C0?ooo`004P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0>X0oooo00<000000?ooo`3oool04`3o
ool00180oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`3X0?ooo`030000003oool0
oooo01@0oooo000B0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0iP3oool00`00
0000oooo0?ooo`0E0?ooo`004P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0>D0
oooo00<000000?ooo`3oool05@3oool00180oooo0P00000<0?ooo`030000003oool0oooo0>@0oooo
00<000000?ooo`3oool05P3oool00180oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`3R0?ooo`030000003oool0oooo01L0oooo00030?ooo`D000000P3oool2000000H0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`3P0?ooo`030000003oool0oooo01P0oooo00050?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0g`3oool00`000000oooo0?ooo`0H0?ooo`001@3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool2000000l0oooo00<00000
0?ooo`3oool0gP3oool00`000000oooo0?ooo`0I0?ooo`001@3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo0=`0oooo00<000000?ooo`3oool06P3oool000D0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`3K
0?ooo`030000003oool0oooo01X0oooo00040?ooo`800000103oool2000000H0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`3I0?ooo`030000003oool0oooo01/0oooo000B0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0f03oool00`000000oooo0?ooo`0L0?ooo`00
4P3oool2000001<0oooo00<000000?ooo`3oool0e`3oool00`000000oooo0?ooo`0L0?ooo`004P3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0=D0oooo00<000000?ooo`3oool07@3o
ool00180oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`3C0?ooo`030000003oool0
oooo01h0oooo000B0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0d`3oool00`00
0000oooo0?ooo`0N0?ooo`004P3oool2000001H0oooo00<000000?ooo`3oool0d@3oool00`000000
oooo0?ooo`0O0?ooo`004P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0=00oooo
00<000000?ooo`3oool0803oool00180oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`3?0?ooo`030000003oool0oooo0200oooo000B0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool0c@3oool00`000000oooo0?ooo`0Q0?ooo`004P3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo0<`0oooo00<000000?ooo`3oool08P3oool00180oooo0P00000I0?ooo`03
0000003oool0oooo0<X0oooo00<000000?ooo`3oool08`3oool00180oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo02<0oooo000B0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`0T0?ooo`004P3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0<L0oooo00<000000?ooo`3oool09@3oool0
0180oooo0P00000K0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool09@3oool00180
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`340?ooo`030000003oool0oooo02H0
oooo000B0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0``3oool00`000000oooo
0?ooo`0W0?ooo`000`3oool4000000<0oooo0P0000060?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool0`P3oool00`000000oooo0?ooo`0W0?ooo`000`3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`310?ooo`030000003oool0oooo02P0oooo00040?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool000001@3oool2000001h0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?oo
o`0Y0?ooo`001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0;h0oooo00<000000?ooo`3oool0:@3o
ool000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool0_@3oool00`000000oooo0?ooo`0Z0?ooo`00103o
ool2000000@0oooo0P0000060?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0_03o
ool00`000000oooo0?ooo`0Z0?ooo`004P3oool200000200oooo00<000000?ooo`3oool0^`3oool0
0`000000oooo0?ooo`0[0?ooo`004P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo
0;T0oooo00<000000?ooo`3oool0;03oool00180oooo00<000000?ooo`3oool08@3oool00`000000
oooo0?ooo`2h0?ooo`030000003oool0oooo02`0oooo000B0?ooo`030000003oool0oooo0240oooo
00<000000?ooo`3oool0]`3oool00`000000oooo0?ooo`0]0?ooo`004P3oool00`000000oooo0?oo
o`0R0?ooo`030000003oool0oooo0;D0oooo00<000000?ooo`3oool0;P3oool00180oooo0P00000S
0?ooo`030000003oool0oooo0;D0oooo00<000000?ooo`3oool0;P3oool00180oooo00<000000?oo
o`3oool08`3oool00`000000oooo0?ooo`2c0?ooo`030000003oool0oooo02l0oooo000B0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`0_0?ooo`00
4P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0
<03oool00180oooo0P00000V0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3o
ool00180oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`2^0?ooo`030000003oool0
oooo0340oooo000B0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0[@3oool00`00
0000oooo0?ooo`0b0?ooo`004P3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0:`0
oooo00<000000?ooo`3oool0<P3oool00180oooo0P00000X0?ooo`030000003oool0oooo0:/0oooo
00<000000?ooo`3oool0<`3oool00180oooo00<000000?ooo`3oool0:03oool00`000000oooo0?oo
o`2Y0?ooo`030000003oool0oooo03@0oooo000B0?ooo`030000003oool0oooo02T0oooo00<00000
0?ooo`3oool0Z03oool00`000000oooo0?ooo`0d0?ooo`00103oool2000000@0oooo0P0000060?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool0Y`3oool00`000000oooo0?ooo`0e0?oo
o`000`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool0:P3oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo03D0oooo00050?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`800000:`3oool0
0`000000oooo0?ooo`2U0?ooo`030000003oool0oooo03H0oooo00060?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0
oooo0:@0oooo00<000000?ooo`3oool0=P3oool000<0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0X`3o
ool00`000000oooo0?ooo`0g0?ooo`00103oool2000000@0oooo0P0000060?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`0h0?ooo`004P3oool20000
02h0oooo00<000000?ooo`3oool0X03oool00`000000oooo0?ooo`0h0?ooo`004P3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool0>@3oool00180oooo
00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`2N0?ooo`030000003oool0oooo03T0oooo
000B0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0W@3oool00`000000oooo0?oo
o`0j0?ooo`004P3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo09/0oooo00<00000
0?ooo`3oool0>`3oool00180oooo0P00000a0?ooo`030000003oool0oooo09X0oooo00<000000?oo
o`3oool0>`3oool00180oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`2I0?ooo`03
0000003oool0oooo03`0oooo000B0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0
V03oool00`000000oooo0?ooo`0l0?ooo`004P3oool00`000000oooo0?ooo`0a0?ooo`030000003o
ool0oooo09L0oooo00<000000?ooo`3oool0?@3oool00180oooo0P00000c0?ooo`030000003oool0
oooo09H0oooo00<000000?ooo`3oool0?@3oool00180oooo00<000000?ooo`3oool0<P3oool00`00
0000oooo0?ooo`2E0?ooo`030000003oool0oooo03h0oooo000B0?ooo`030000003oool0oooo03<0
oooo00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`0o0?ooo`004P3oool00`000000oooo
0?ooo`0d0?ooo`030000003oool0oooo0980oooo00<000000?ooo`3oool0?`3oool00180oooo00<0
00000?ooo`3oool0=03oool00`000000oooo0?ooo`2A0?ooo`030000003oool0oooo0400oooo000B
0?ooo`800000=P3oool00`000000oooo0?ooo`2@0?ooo`030000003oool0oooo0400oooo000B0?oo
o`030000003oool0oooo03D0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`110?oo
o`001@3oool300000080oooo0P0000060?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3o
ool0SP3oool00`000000oooo0?ooo`110?ooo`001P3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`2<0?ooo`03
0000003oool0oooo0480oooo00030?ooo`D0000000D0oooo0000003oool0oooo000000050?ooo`80
0000>03oool00`000000oooo0?ooo`2<0?ooo`030000003oool0oooo0480oooo00030?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`0h0?oo
o`030000003oool0oooo08X0oooo00<000000?ooo`3oool0@`3oool000@0oooo00<000000?ooo`00
00000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo03P0oooo00<000000?oo
o`3oool0R@3oool00`000000oooo0?ooo`140?ooo`001@3oool2000000<0oooo0P0000060?ooo`03
0000003oool0oooo03T0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`140?ooo`00
4P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo08L0oooo00<000000?ooo`3oool0
A@3oool00180oooo0P00000k0?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool0A@3o
ool00180oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`240?ooo`030000003oool0
oooo04H0oooo000B0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0Q03oool00`00
0000oooo0?ooo`160?ooo`004P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0880
oooo00<000000?ooo`3oool0A`3oool00180oooo0P00000m0?ooo`030000003oool0oooo0880oooo
00<000000?ooo`3oool0A`3oool00180oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?oo
o`200?ooo`030000003oool0oooo04P0oooo000B0?ooo`030000003oool0oooo03h0oooo00<00000
0?ooo`3oool0OP3oool00`000000oooo0?ooo`190?ooo`004P3oool00`000000oooo0?ooo`0n0?oo
o`030000003oool0oooo07h0oooo00<000000?ooo`3oool0B@3oool00180oooo00<000000?ooo`3o
ool0?`3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo04X0oooo000B0?ooo`800000
@@3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo04/0oooo000B0?ooo`030000003o
ool0oooo0400oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`1;0?ooo`004P3oool0
0`000000oooo0?ooo`110?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool0C03oool0
0180oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`1f0?ooo`030000003oool0oooo
04d0oooo000B0?ooo`800000@`3oool00`000000oooo0?ooo`1f0?ooo`030000003oool0oooo04d0
oooo000B0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0M03oool00`000000oooo
0?ooo`1>0?ooo`004P3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo07<0oooo00<0
00000?ooo`3oool0CP3oool000@0oooo0P0000040?ooo`8000001P3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0C`3oool000<0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo04D0oooo00<0
00000?ooo`3oool0L03oool00`000000oooo0?ooo`1@0?ooo`001P3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo00<0oooo0P0000170?ooo`030000003oool0oooo06l0oooo00<0
00000?ooo`3oool0D03oool000@0oooo0P0000030?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`3oool0AP3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo0540oooo0004
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?oo
o`170?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0DP3oool000@0oooo0`000003
0?ooo`8000001P3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo06/0oooo00<00000
0?ooo`3oool0DP3oool00180oooo0P0000190?ooo`030000003oool0oooo06X0oooo00<000000?oo
o`3oool0D`3oool00180oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`1X0?ooo`03
0000003oool0oooo05@0oooo000B0?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool0
I`3oool00`000000oooo0?ooo`1D0?ooo`004P3oool00`000000oooo0?ooo`1:0?ooo`030000003o
ool0oooo06H0oooo00<000000?ooo`3oool0E@3oool00180oooo0P00001<0?ooo`030000003oool0
oooo06@0oooo00<000000?ooo`3oool0EP3oool00180oooo00<000000?ooo`3oool0C03oool00`00
0000oooo0?ooo`1R0?ooo`030000003oool0oooo05L0oooo000B0?ooo`030000003oool0oooo04d0
oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`1G0?ooo`004P3oool00`000000oooo
0?ooo`1=0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0F03oool00180oooo00<0
00000?ooo`3oool0CP3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo05T0oooo000B
0?ooo`800000D03oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo05X0oooo000B0?oo
o`030000003oool0oooo0500oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`1J0?oo
o`004P3oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3o
ool0F`3oool00180oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1H0?ooo`030000
003oool0oooo05`0oooo000B0?ooo`800000D`3oool00`000000oooo0?ooo`1F0?ooo`030000003o
ool0oooo05d0oooo000B0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0E@3oool0
0`000000oooo0?ooo`1M0?ooo`004P3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo
05@0oooo00<000000?ooo`3oool0GP3oool000<0oooo0`0000040?ooo`8000001P3oool00`000000
oooo0?ooo`1D0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0G`3oool000<0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo
05D0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`1P0?ooo`000`3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo0P00001G0?ooo`030000003oool0
oooo04h0oooo00<000000?ooo`3oool0H@3oool000<0oooo0`0000030?ooo`040000003oool0oooo
000000D0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0
oooo0640oooo00040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000001@3oool0
0`000000oooo0?ooo`1G0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0HP3oool0
00@0oooo0`0000030?ooo`8000001P3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo
04X0oooo00<000000?ooo`3oool0H`3oool00180oooo0P00001J0?ooo`030000003oool0oooo04P0
oooo00<000000?ooo`3oool0I03oool00180oooo00<000000?ooo`3oool0FP3oool00`000000oooo
0?ooo`160?ooo`030000003oool0oooo06D0oooo000B0?ooo`030000003oool0oooo05/0oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`1V0?ooo`004P3oool00`000000oooo0?ooo`1K
0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0IP3oool00180oooo00<000000?oo
o`3oool0G03oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo06L0oooo000B0?ooo`80
0000GP3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo06P0oooo000B0?ooo`030000
003oool0oooo05h0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`1Y0?ooo`004P3o
ool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0JP3o
ool00180oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`0i0?ooo`800000K@3oool0
0180oooo0P00001R0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0K@3oool00180
oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo06h0
oooo000B0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`1_0?ooo`004P3oool00`000000oooo0?ooo`1T0?ooo`800000<P3oool00`000000oooo0?oo
o`1`0?ooo`004P3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo02d0oooo0P00001c
0?ooo`004P3oool2000006P0oooo0P00000/0?ooo`030000003oool0oooo07<0oooo000B0?ooo`03
0000003oool0oooo06T0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`1d0?ooo`00
1@3oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`000000oooo0?ooo`1Z0?ooo`800000
9P3oool2000007L0oooo00050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo06`0oooo0P00000R0?ooo`800000N@3oool000D0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo0P00001_0?ooo`800000
7`3oool00`000000oooo0?ooo`1i0?ooo`001P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`0J0?ooo`800000
O03oool000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`03
0000003oool0oooo0740oooo0P00000H0?ooo`800000OP3oool000<0oooo100000030?ooo`800000
1P3oool00`000000oooo0?ooo`1c0?ooo`<00000403oool500000800oooo000B0?ooo`030000003o
ool0oooo07H0oooo400000250?ooo`004P3oool200000?l0oooo3@3oool00180oooo00<000000?oo
o`3oool0o`3oool<0?ooo`004P3oool00`000000oooo0?ooo`3o0?ooo``0oooo000B0?ooo`030000
003oool0oooo0?l0oooo303oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.696796, -5.56136, \
0.0385028, 0.448195}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
  "The solver can solve multipoint boundary value problems of linear systems \
of equations. (Note that each boundary equation must be at one specific value \
of ",
  StyleBox["t",
    FontSlant->"Italic"],
  ".)"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(bconds\  = \ {\[IndentingNewLine]x[0]\  + \ \(x'\)[0]\  + \ 
            y[0]\  + \ \(y'\)[0]\  \[Equal] \ 
          1, \[IndentingNewLine]x[1]\  + \ 2\ \(x'\)[1]\  + \ 3\ y[1]\  + \ 
            4 \( y'\)[1]\  \[Equal] \ 
          5, \[IndentingNewLine]y[2]\  + \ 2\ \(y'\)[2]\  \[Equal] \ 
          4, \[IndentingNewLine]x[3]\  - \ \(x'\)[3]\  \[Equal] \ 
          7}; \), "\[IndentingNewLine]", 
    \(nsol2\  = \ 
      NDSolve[{\[IndentingNewLine]\(x''\)[t]\  + \ x[t]\  + \ 
              y[t]\  \[Equal] \ t, \(y''\)[t]\  + \ y[t]\  \[Equal] \ 
            Cos[t], \[IndentingNewLine]bconds}, \[IndentingNewLine]{x, 
          y}, \[IndentingNewLine]{t, 0, 4}]\)}], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 4.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 4.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "In general, you cannot expect the boundary value equations to be satisfied \
to the close tolerance of ",
  StyleBox["Equal", "MR"],
  "."
}], "Text"],

Cell["\<\
This checks to see if the boundary conditions are \"satisfied\".\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(bconds\  /. \ First[nsol2]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({False, False, False, True}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  "They are typically only be satisfied at most tolerances that come from the \
",
  StyleBox["AccuracyGoal", "MR"],
  " and ",
  StyleBox["PrecisionGoal", "MR"],
  " options of ",
  StyleBox["NDSolve", "MR"],
  ". Usually, the actual accuracy and precision is less because these are \
used for local, not global, error control."
}], "Text"],

Cell["\<\
This checks the residual error at each of the boundary conditions.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Subtract, \ bconds, \ 1]\  /. \ First[nsol2]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({4.107713191814355`*^-8, 3.9499747206406255`*^-7, 
      3.069835292635048`*^-7, \(-8.881784197001252`*^-16\)}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  "When you give ",
  StyleBox["NDSolve", "MR"],
  " a problem that has no solution, numerical error may make it appear to be \
a solvable problem. Typically, ",
  StyleBox["NDSolve", "MR"],
  " will issue a warning message."
}], "Text"],

Cell["This is a boundary value problem that has no solution.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 0, \ x[0]\  \[Equal] \ 1, \ 
        x[Pi]\  \[Equal] \ 0}, x, {t, 0, Pi}]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"bvluc"\), \(\(:\)\(\ \)\), "\<\"The equations derived \
from the boundary conditions are numerically ill-conditioned. The boundary \
conditions may not be sufficient to uniquely define a solution. The computed \
solution may match the boundary conditions poorly. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NDSolve::bvluc\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[7]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 3.141592653589793`}}, "<>"]\),
            
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell["\<\
In this case, it is not able to integrate over the entire interval because of \
nonexistence.\
\>", "Text"],

Cell["\<\
Another situation in which the equations can be ill-conditioned is when the \
boundary conditions do not give a unique solution.\
\>", "Text"],

Cell[TextData[{
  "Here is a boundary value problem that does not have a unique solution. Its \
general solution is shown as computed symbolically with ",
  StyleBox["DSolve", "MR"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dsol\  = \ 
      First[x\  /. \ 
          DSolve[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 
                t, \ \(x'\)[0]\  \[Equal] \ 1, \ x[Pi/2]\  \[Equal] \ Pi/2}, 
            x, t]]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \(Function[{t}, t + C[1]\ Cos[t]]\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " issues a warning message because the matrix to solve for the initial \
conditions is singular, but has a solution."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(onesol\  = \ 
      First[x\  /. \ 
          NDSolve[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 
                t, \ \(x'\)[0]\  \[Equal] \ 1, \ x[Pi/2]\  \[Equal] \ Pi/2}, 
            x, {t, \ 0, \ Pi/2}]]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"bvluc"\), \(\(:\)\(\ \)\), "\<\"The equations derived \
from the boundary conditions are numerically ill-conditioned. The boundary \
conditions may not be sufficient to uniquely define a solution. The computed \
solution may match the boundary conditions poorly. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NDSolve::bvluc\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[9]:="],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 1.5707963267948966`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["\<\
You can identify which solution it found by fitting it to the interpolating \
points. This makes a plot of the error relative to the actual best fit \
solution.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(ip\  = \ onesol@"\<Coordinates\>"[1]; \), "\[IndentingNewLine]", 
    \(points\  = \ Transpose[{ip, \ onesol[ip]}]; \), "\[IndentingNewLine]", 
    \(model\  = \ 
      dsol[t]\  /. \ C[1] \[Rule] \[Alpha]; \), "\[IndentingNewLine]", 
    \(fit\  = \ 
      FindFit[points, \ model, \[Alpha], \ t]; \), "\[IndentingNewLine]", 
    \(ListPlot[
      Transpose[{ip, \ 
          onesol[ip]\  - \ \((\((model\  /. \ fit)\)\  /. \ 
                t \[Rule] ip)\)}]]\)}], "Input",
  CellLabel->"In[10]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.606305 0.255861 8.30051e+006 [
[.17539 .24336 -12 -9 ]
[.17539 .24336 12 0 ]
[.32696 .24336 -9 -9 ]
[.32696 .24336 9 0 ]
[.47854 .24336 -12 -9 ]
[.47854 .24336 12 0 ]
[.63011 .24336 -3 -9 ]
[.63011 .24336 3 0 ]
[.78169 .24336 -12 -9 ]
[.78169 .24336 12 0 ]
[.93327 .24336 -9 -9 ]
[.93327 .24336 9 0 ]
[.01131 .00685 -39 -6.25 ]
[.01131 .00685 0 6.25 ]
[.01131 .08985 -39 -6.25 ]
[.01131 .08985 0 6.25 ]
[.01131 .17286 -39 -6.25 ]
[.01131 .17286 0 6.25 ]
[.01131 .33887 -33 -6.25 ]
[.01131 .33887 0 6.25 ]
[.01131 .42187 -33 -6.25 ]
[.01131 .42187 0 6.25 ]
[.01131 .50488 -33 -6.25 ]
[.01131 .50488 0 6.25 ]
[.01131 .58788 -33 -6.25 ]
[.01131 .58788 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .25586 m
.17539 .26211 L
s
[(0.25)] .17539 .24336 0 1 Mshowa
.32696 .25586 m
.32696 .26211 L
s
[(0.5)] .32696 .24336 0 1 Mshowa
.47854 .25586 m
.47854 .26211 L
s
[(0.75)] .47854 .24336 0 1 Mshowa
.63011 .25586 m
.63011 .26211 L
s
[(1)] .63011 .24336 0 1 Mshowa
.78169 .25586 m
.78169 .26211 L
s
[(1.25)] .78169 .24336 0 1 Mshowa
.93327 .25586 m
.93327 .26211 L
s
[(1.5)] .93327 .24336 0 1 Mshowa
.125 Mabswid
.05412 .25586 m
.05412 .25961 L
s
.08444 .25586 m
.08444 .25961 L
s
.11476 .25586 m
.11476 .25961 L
s
.14507 .25586 m
.14507 .25961 L
s
.2057 .25586 m
.2057 .25961 L
s
.23602 .25586 m
.23602 .25961 L
s
.26633 .25586 m
.26633 .25961 L
s
.29665 .25586 m
.29665 .25961 L
s
.35728 .25586 m
.35728 .25961 L
s
.38759 .25586 m
.38759 .25961 L
s
.41791 .25586 m
.41791 .25961 L
s
.44822 .25586 m
.44822 .25961 L
s
.50885 .25586 m
.50885 .25961 L
s
.53917 .25586 m
.53917 .25961 L
s
.56948 .25586 m
.56948 .25961 L
s
.5998 .25586 m
.5998 .25961 L
s
.66043 .25586 m
.66043 .25961 L
s
.69074 .25586 m
.69074 .25961 L
s
.72106 .25586 m
.72106 .25961 L
s
.75137 .25586 m
.75137 .25961 L
s
.81201 .25586 m
.81201 .25961 L
s
.84232 .25586 m
.84232 .25961 L
s
.87264 .25586 m
.87264 .25961 L
s
.90295 .25586 m
.90295 .25961 L
s
.96358 .25586 m
.96358 .25961 L
s
.9939 .25586 m
.9939 .25961 L
s
.25 Mabswid
0 .25586 m
1 .25586 L
s
.02381 .00685 m
.03006 .00685 L
s
gsave
.01131 .00685 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-3) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .08985 m
.03006 .08985 L
s
gsave
.01131 .08985 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .17286 m
.03006 .17286 L
s
gsave
.01131 .17286 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .33887 m
.03006 .33887 L
s
gsave
.01131 .33887 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .42187 m
.03006 .42187 L
s
gsave
.01131 .42187 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .50488 m
.03006 .50488 L
s
gsave
.01131 .50488 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(3) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .58788 m
.03006 .58788 L
s
gsave
.01131 .58788 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.125 Mabswid
.02381 .02345 m
.02756 .02345 L
s
.02381 .04005 m
.02756 .04005 L
s
.02381 .05665 m
.02756 .05665 L
s
.02381 .07325 m
.02756 .07325 L
s
.02381 .10645 m
.02756 .10645 L
s
.02381 .12305 m
.02756 .12305 L
s
.02381 .13965 m
.02756 .13965 L
s
.02381 .15626 m
.02756 .15626 L
s
.02381 .18946 m
.02756 .18946 L
s
.02381 .20606 m
.02756 .20606 L
s
.02381 .22266 m
.02756 .22266 L
s
.02381 .23926 m
.02756 .23926 L
s
.02381 .27246 m
.02756 .27246 L
s
.02381 .28906 m
.02756 .28906 L
s
.02381 .30566 m
.02756 .30566 L
s
.02381 .32227 m
.02756 .32227 L
s
.02381 .35547 m
.02756 .35547 L
s
.02381 .37207 m
.02756 .37207 L
s
.02381 .38867 m
.02756 .38867 L
s
.02381 .40527 m
.02756 .40527 L
s
.02381 .43847 m
.02756 .43847 L
s
.02381 .45507 m
.02756 .45507 L
s
.02381 .47167 m
.02756 .47167 L
s
.02381 .48828 m
.02756 .48828 L
s
.02381 .52148 m
.02756 .52148 L
s
.02381 .53808 m
.02756 .53808 L
s
.02381 .55468 m
.02756 .55468 L
s
.02381 .57128 m
.02756 .57128 L
s
.02381 .60448 m
.02756 .60448 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .60332 Mdot
.07277 .45178 Mdot
.12173 .33769 Mdot
.17791 .16118 Mdot
.24593 .11587 Mdot
.31394 .13783 Mdot
.38195 .18606 Mdot
.44996 .30154 Mdot
.50359 .26932 Mdot
.55723 .24245 Mdot
.61086 .22102 Mdot
.66449 .20324 Mdot
.71812 .16725 Mdot
.77175 .16223 Mdot
.82539 .17648 Mdot
.84778 .15213 Mdot
.87018 .12761 Mdot
.89258 .10308 Mdot
.91498 .08146 Mdot
.93738 .06677 Mdot
.95978 .02803 Mdot
.96202 .02557 Mdot
.96426 .02312 Mdot
.9665 .02067 Mdot
.96874 .01822 Mdot
.97098 .01578 Mdot
.9712 .01554 Mdot
.97143 .01529 Mdot
.97165 .01505 Mdot
.97187 .01479 Mdot
.9719 .01476 Mdot
.97192 .01474 Mdot
.97194 .01472 Mdot
.97195 .0148 Mdot
.97196 .01489 Mdot
.97197 .01497 Mdot
.97199 .01506 Mdot
.972 .01514 Mdot
.97338 .09539 Mdot
.97477 .17565 Mdot
.97616 .2559 Mdot
.97617 .25588 Mdot
.97619 .25586 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00203oool2000000<0oooo00H000000?ooo`3oool0oooo0000003oool500000080oooo0P00
003o0?ooo`D0oooo00070?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`000000103o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0o`3oool20?ooo`002@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0l`3oool000030?ooo`00
00000000008000001@3oool01`000000oooo0?ooo`3oool000000?ooo`000000103oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3c0?oo
o`001`3oool010000000oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3oool200000?@0oooo0008
0?ooo`8000002P3oool2000000@0oooo0P00000>0?ooo`030000003oool0oooo0>X0oooo00<00000
0?ooo`3oool01P3oool002@0oooo0`0000030?ooo`030000003oool0oooo0>T0oooo0P0000080?oo
o`00903oool00`000000oooo000000030?ooo`030000003oool0oooo0>P0oooo0P0000090?ooo`00
7`3oool3000000<0oooo00<000000?ooo`3oool00P3oool200000>P0oooo0P00000:0?ooo`00903o
ool00`000000oooo000000030?ooo`030000003oool0oooo0>L0oooo00<000000?ooo`3oool02@3o
ool002@0oooo0`0000030?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo
0?<0oooo000Z0?ooo`800000m03oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo00<0
00000?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo0P00003d0?oo
o`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?ooo`3Q0?ooo`030000
003oool0oooo00l0oooo000Z0?ooo`030000003oool0oooo0>40oooo00<000000?ooo`3oool03`3o
ool002X0oooo0P00003d0?ooo`001`3oool400000080oooo00H000000?ooo`3oool0oooo0000003o
ool500000080oooo0P00000>0?ooo`030000003oool0oooo0?<0oooo00070?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo01@0oooo0008
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3L0?ooo`030000003o
ool0oooo01@0oooo00000`3oool0000000000002000000@0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0;0?ooo`800000m03oool000L0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0jP3oool00`000000oooo0?ooo`060?ooo`00203oool2000000X0oooo
0P0000040?ooo`800000203oool3000000<0oooo00<000000?ooo`3oool0jP3oool00`000000oooo
0?ooo`060?ooo`00903oool00`000000oooo000000030?ooo`030000003oool0oooo0=H0oooo00<0
00000?ooo`3oool06P3oool001l0oooo0`0000030?ooo`030000003oool0oooo0080oooo0P00003G
0?ooo`030000003oool0oooo01X0oooo000T0?ooo`030000003oool0000000<0oooo00<000000?oo
o`3oool0l`3oool002@0oooo0`0000030?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3o
ool0_03oool002X0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`2l0?ooo`00:P3o
ool00`000000oooo0?ooo`3c0?ooo`00:P3oool200000=40oooo00<000000?ooo`3oool0803oool0
02X0oooo00<000000?ooo`3oool0d03oool00`000000oooo0?ooo`0P0?ooo`00:P3oool00`000000
oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo0:/0oooo
000Z0?ooo`800000AP3oool00`000000oooo0?ooo`2[0?ooo`00:P3oool00`000000oooo0?ooo`3c
0?ooo`00:P3oool00`000000oooo0?ooo`3;0?ooo`030000003oool0oooo02D0oooo000Z0?ooo`03
0000003oool0oooo0</0oooo00<000000?ooo`3oool09@3oool002X0oooo0P00003d0?ooo`001`3o
ool5000000030?ooo`000000oooo0080oooo00<000000?ooo`000000100000020?ooo`8000003P3o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0980oooo00<000000?ooo`3oool0>03o
ool000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000040?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02<0oooo00<0
00000?ooo`3oool0Q03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03P0oooo0009
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`2Z0?ooo`030000003o
ool0oooo04H0oooo00000`3oool0000000000002000000@0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0;0?ooo`800000k03oool00`000000oooo0?ooo`050?ooo`002@3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000d0
oooo00<000000?ooo`3oool0a@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00D0
oooo00080?ooo`8000002P3oool2000000@0oooo0P0000080?ooo`<000000`3oool00`000000oooo
0?ooo`350?ooo`030000003oool0oooo02/0oooo000T0?ooo`030000003oool0000000<0oooo00<0
00000?ooo`3oool0EP3oool00`000000oooo0?ooo`2J0?ooo`007`3oool3000000<0oooo00<00000
0?ooo`3oool00P3oool2000005L0oooo00<000000?ooo`3oool0VP3oool002@0oooo00<000000?oo
o`0000000`3oool00`000000oooo0?ooo`3c0?ooo`00903oool3000000<0oooo00<000000?ooo`3o
ool0l`3oool002X0oooo00<000000?ooo`3oool0W@3oool00`000000oooo0?ooo`1C0?ooo`00:P3o
ool2000009h0oooo00<000000?ooo`3oool0D`3oool002X0oooo00<000000?ooo`3oool0l`3oool0
02X0oooo00<000000?ooo`3oool06@3oool2000000@0oooo0P0000030?ooo`@000000`3oool20000
01D0oooo0P0000040?ooo`800000103oool2000001D0oooo0P0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`020?ooo`8000006P3oool5000001P0oooo1@0000020?ooo`8000000`3oool40000
00<0oooo0P00000D0?ooo`D000000P3oool2000000@0oooo0P00000;0?ooo`00:P3oool00`000000
oooo0?ooo`0H0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool00`3oool01000
0000oooo0?ooo`00000C0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
4`3oool010000000oooo0?ooo`00000:0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`030?ooo`040000003oool0oooo000001D0oooo00<000000?ooo`3oool01`3oool0
10000000oooo0?ooo`00000:0?ooo`00:P3oool00`000000oooo0?ooo`0H0?ooo`040000003oool0
oooo000000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0A0?ooo`040000003o
ool0oooo000000/0oooo00<000000?ooo`3oool04@3oool010000000oooo0?ooo`00000:0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`00
:P3oool2000001T0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`020?ooo`80
0000503oool010000000oooo0?ooo`0000090?ooo`800000503oool010000000oooo0?ooo`00000;
0?ooo`040000003oool0oooo0?ooo`8000005P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`8000005P3o
ool00`000000oooo0?ooo`080?ooo`8000002`3oool002X0oooo00<000000?ooo`3oool0603oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0
4`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo01<0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool05@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo000Z
0?ooo`030000003oool0oooo01T0oooo0P00000:0?ooo`800000103oool3000001@0oooo0P00000:
0?ooo`<00000503oool2000000T0oooo100000030?ooo`<000006P3oool2000001/0oooo0P00000:
0?ooo`800000103oool3000001@0oooo0P00000:0?ooo`<000002P3oool002X0oooo00<000000?oo
o`3oool0l`3oool002X0oooo0P0000230?ooo`030000003oool0oooo06h0oooo000Z0?ooo`030000
003oool0oooo0880oooo00<000000?ooo`3oool0KP3oool002X0oooo00<000000?ooo`3oool0l`3o
ool002X0oooo00<000000?ooo`3oool0j`3oool00`000000oooo0?ooo`050?ooo`00903ooool0000
0000:P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo0@0000010?ooo`40
oooo000Z0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo00l0oooo000Z0?ooo`030000003oool0oooo07@0oooo00<0
00000?ooo`3oool0O03oool002X0oooo0P00001e0?ooo`030000003oool0oooo07`0oooo000Z0?oo
o`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000
003oool0oooo0?<0oooo000Z0?ooo`800000m03oool002X0oooo00<000000?ooo`3oool0l`3oool0
02X0oooo00<000000?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0I`3oool00`000000
oooo0?ooo`290?ooo`00:P3oool2000006P0oooo00<000000?ooo`3oool0R@3oool002X0oooo00<0
00000?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo00<000000?oo
o`3oool0l`3oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo0P00003d0?ooo`001`3o
ool5000000030?ooo`000000oooo0080oooo00<000000?ooo`000000100000020?ooo`8000003P3o
ool00`000000oooo0?ooo`3c0?ooo`002@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0l`3oool000T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool0f`3oool000T0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0;0?ooo`8000005P3oool00`000000oooo0?ooo`3K0?ooo`002@3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000d0
oooo00<000000?ooo`3oool0l`3oool000P0oooo0P00000:0?ooo`800000103oool2000000P0oooo
0`0000030?ooo`030000003oool0oooo0?<0oooo000T0?ooo`030000003oool0000000<0oooo00<0
00000?ooo`3oool0l`3oool001l0oooo0`0000030?ooo`030000003oool0oooo0080oooo0P00003d
0?ooo`00903oool00`000000oooo000000030?ooo`030000003oool0oooo0?<0oooo000T0?ooo`<0
00000`3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3o
ool200000?@0oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo
0?<0oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`800000m03oool002X0oooo00<0
00000?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo00<000000?oo
o`3oool0l`3oool002X0oooo0P00003d0?ooo`001`3oool400000080oooo00H000000?ooo`3oool0
oooo0000003oool500000080oooo0P00000>0?ooo`030000003oool0oooo0?<0oooo00070?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3c0?ooo`00203oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0l`3oool000T0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0?<0oooo00070?ooo`040000003oool0oooo0000
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`0;0?ooo`800000m03oool000P0oooo0P00000:0?ooo`800000103oool2
000000h0oooo00<000000?ooo`3oool0l`3oool002@0oooo0`0000030?ooo`030000003oool0oooo
0?<0oooo000T0?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0l`3oool001l0oooo
0`0000030?ooo`030000003oool0oooo0080oooo0P00003d0?ooo`00903oool00`000000oooo0000
00030?ooo`030000003oool0oooo0?<0oooo000T0?ooo`<000000`3oool00`000000oooo0?ooo`3c
0?ooo`00:P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0>P0oooo000Z0?ooo`80
00002@3oool00`000000oooo0?ooo`3X0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3o
ool00`000000oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool20000
0?@0oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo0?<0oooo
000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`800000m03oool000P0oooo0P0000030?oo
o`060000003oool0oooo0?ooo`000000oooo1@0000020?ooo`8000003P3oool00`000000oooo0?oo
o`3c0?ooo`001`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0000000@0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
l`3oool000T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?<0oooo
000:0?ooo`070000003oool0oooo0?ooo`000000oooo000000040?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`0;0?ooo`800000m03oool000L0oooo00@000000?ooo`3o
ool000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0l`3oool000P0oooo0P00000:
0?ooo`800000103oool2000000P0oooo0`0000030?ooo`030000003oool0oooo0?<0oooo000T0?oo
o`030000003oool0000000<0oooo00<000000?ooo`3oool0l`3oool001l0oooo0`0000030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0l`3oool002@0oooo00<000000?ooo`000000
0`3oool200000?@0oooo000T0?ooo`<000000`3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool0
0`000000oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool200000?@0
oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z
0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`800000m03oool002X0oooo00<000000?ooo`3o
ool0l`3oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0l`3o
ool002X0oooo0P00003d0?ooo`002@3oool3000000030?ooo`000000oooo0080oooo00<000000?oo
o`000000100000020?ooo`8000003P3oool00`000000oooo0?ooo`3c0?ooo`002P3oool01`000000
oooo0?ooo`3oool000000?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`3c0?ooo`001`3oool5000000<0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`3c0?ooo`001`3oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0oooo
0P00003d0?ooo`00203oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`3c0?ooo`002@3oool2000000T0oooo0P0000040?ooo`800000203oool3000000<0oooo
00<000000?ooo`3oool0l`3oool002@0oooo00<000000?ooo`0000000`3oool00`000000oooo0?oo
o`3c0?ooo`007`3oool3000000<0oooo00@000000?ooo`3oool0oooo0`00003d0?ooo`00903oool0
0`000000oooo000000020?ooo`800000m@3oool002@0oooo0`0000030?ooo`030000003oool0oooo
0?<0oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo0?<0oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.277064, -3.71757, \
0.00657539, 4.80295}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell[TextData[{
  "Typically the default values ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses work fine, but you can control the chasing method by giving ",
  StyleBox["NDSolve", "MR"],
  " the option ",
  StyleBox["Method->{Chasing, ", "MR"],
  StyleBox["chasing options", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  ".  The possible ",
  StyleBox["chasing options", "MR",
    FontSlant->"Italic"],
  " are shown in the following table."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["Method",
              "MR"], 
            StyleBox["Automatic",
              "MR"], Cell["\<\
the numerical method to use for computing the initial value problems \
generated by the chasing algorithm\
\>", "Text"]},
          {
            StyleBox["ExtraPrecision",
              "MR"], 
            StyleBox["0",
              "MR"], Cell["\<\
number of digits of extra precision to use for solving the auxiliary initial \
value problems\
\>", "Text"]},
          {
            StyleBox["ChasingType",
              "MR"], Cell[BoxData[
                StyleBox["\"\<LinearChasing\>\"",
                  "MR"]], "Input"], Cell[TextData[{
              "the type of chasing to use, which can be  either  ",
              StyleBox["\"LinearChasing\"", "MR"],
              " or ",
              StyleBox["\"NonlinearChasing\"", "MR"]
            }], "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options for the ",
  StyleBox["Chasing", "MR"],
  " method of ",
  StyleBox["NDSolve", "MR"],
  ". "
}], "Caption"],

Cell[TextData[{
  "The method ",
  StyleBox["ChasingType->NonlinearChasing", "MR"],
  " itself has two options."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["ContourType",
              "MR"], 
            StyleBox["Ellipse",
              "MR"], Cell[TextData[{
              
              "the shape of contour to use when integration in the complex \
plane is required, which can either be \"",
              StyleBox["Ellipse", "MR"],
              "\" or \"",
              StyleBox["Rectangle", "MR"],
              "\""
            }], "Text"]},
          {
            StyleBox["ContourRatio",
              "MR"], 
            StyleBox[\(1/10\),
              "MR"], Cell["\<\
the ratio of the width to the length of the contour; typically a smaller \
number gives more accurate results, but yields more numerical difficulty in \
solving the equations\
\>", "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options for the ",
  StyleBox["NonlinearChasing", "MR"],
  " option of the ",
  StyleBox["Chasing", "MR"],
  " method."
}], "Caption"],

Cell[TextData[{
  "These options, especially ",
  StyleBox["ExtraPrecision", "MR"],
  " can be useful in cases where there is a strong sensitivity to computed \
initial conditions."
}], "Text"],

Cell[TextData[{
  "Here is a boundary value problem with a simple solution computed \
symbolically using ",
  StyleBox["DSolve", "MR"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(bvp\  = \ {\(x''\)[t]\  + \ 1000\ x[t]\  \[Equal] \ 0, \ 
        x[0]\  \[Equal] \ 0, \ 
        x[1]\  \[Equal] \ 1}; \), "\[IndentingNewLine]", 
    \(dsol\  = \ First[x\  /. \ DSolve[bvp, x, t]]\)}], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    \(Function[{t}, Csc[10\ \@10]\ Sin[10\ \@10\ t]]\)], "Output",
  CellLabel->"Out[16]="]
}, Open  ]],

Cell[TextData[{
  "This shows the error in the solution computed by ",
  StyleBox["NDSolve", "MR"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(sol\  = \ 
      First[x\  /. \ 
          NDSolve[{\(x''\)[t]\  + \ 1000\ x[t]\  \[Equal] \ 0, \ 
              x[0]\  \[Equal] \ 0, \ x[1]\  \[Equal] \ 1}, 
            x, {t, \ 0, \ 1}]]; \), "\[IndentingNewLine]", 
    \(Plot[sol[t]\  - \ dsol[t], {t, 0, 1}]\)}], "Input",
  CellLabel->"In[17]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309389 11232.2 [
[.21429 .29689 -9 -9 ]
[.21429 .29689 9 0 ]
[.40476 .29689 -9 -9 ]
[.40476 .29689 9 0 ]
[.59524 .29689 -9 -9 ]
[.59524 .29689 9 0 ]
[.78571 .29689 -9 -9 ]
[.78571 .29689 9 0 ]
[.97619 .29689 -3 -9 ]
[.97619 .29689 3 0 ]
[.01131 .08475 -48 -4.5 ]
[.01131 .08475 0 4.5 ]
[.01131 .19707 -48 -4.5 ]
[.01131 .19707 0 4.5 ]
[.01131 .42171 -42 -4.5 ]
[.01131 .42171 0 4.5 ]
[.01131 .53403 -42 -4.5 ]
[.01131 .53403 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30939 m
.21429 .31564 L
s
[(0.2)] .21429 .29689 0 1 Mshowa
.40476 .30939 m
.40476 .31564 L
s
[(0.4)] .40476 .29689 0 1 Mshowa
.59524 .30939 m
.59524 .31564 L
s
[(0.6)] .59524 .29689 0 1 Mshowa
.78571 .30939 m
.78571 .31564 L
s
[(0.8)] .78571 .29689 0 1 Mshowa
.97619 .30939 m
.97619 .31564 L
s
[(1)] .97619 .29689 0 1 Mshowa
.125 Mabswid
.07143 .30939 m
.07143 .31314 L
s
.11905 .30939 m
.11905 .31314 L
s
.16667 .30939 m
.16667 .31314 L
s
.2619 .30939 m
.2619 .31314 L
s
.30952 .30939 m
.30952 .31314 L
s
.35714 .30939 m
.35714 .31314 L
s
.45238 .30939 m
.45238 .31314 L
s
.5 .30939 m
.5 .31314 L
s
.54762 .30939 m
.54762 .31314 L
s
.64286 .30939 m
.64286 .31314 L
s
.69048 .30939 m
.69048 .31314 L
s
.7381 .30939 m
.7381 .31314 L
s
.83333 .30939 m
.83333 .31314 L
s
.88095 .30939 m
.88095 .31314 L
s
.92857 .30939 m
.92857 .31314 L
s
.25 Mabswid
0 .30939 m
1 .30939 L
s
.02381 .08475 m
.03006 .08475 L
s
[(-0.00002)] .01131 .08475 1 0 Mshowa
.02381 .19707 m
.03006 .19707 L
s
[(-0.00001)] .01131 .19707 1 0 Mshowa
.02381 .42171 m
.03006 .42171 L
s
[(0.00001)] .01131 .42171 1 0 Mshowa
.02381 .53403 m
.03006 .53403 L
s
[(0.00002)] .01131 .53403 1 0 Mshowa
.125 Mabswid
.02381 .10721 m
.02756 .10721 L
s
.02381 .12967 m
.02756 .12967 L
s
.02381 .15214 m
.02756 .15214 L
s
.02381 .1746 m
.02756 .1746 L
s
.02381 .21953 m
.02756 .21953 L
s
.02381 .242 m
.02756 .242 L
s
.02381 .26446 m
.02756 .26446 L
s
.02381 .28692 m
.02756 .28692 L
s
.02381 .33185 m
.02756 .33185 L
s
.02381 .35432 m
.02756 .35432 L
s
.02381 .37678 m
.02756 .37678 L
s
.02381 .39925 m
.02756 .39925 L
s
.02381 .44418 m
.02756 .44418 L
s
.02381 .46664 m
.02756 .46664 L
s
.02381 .4891 m
.02756 .4891 L
s
.02381 .51157 m
.02756 .51157 L
s
.02381 .06228 m
.02756 .06228 L
s
.02381 .03982 m
.02756 .03982 L
s
.02381 .01735 m
.02756 .01735 L
s
.02381 .5565 m
.02756 .5565 L
s
.02381 .57896 m
.02756 .57896 L
s
.02381 .60143 m
.02756 .60143 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .37686 m
.04262 .19689 L
.0522 .11761 L
.05746 .08176 L
.06244 .05423 L
.06506 .04254 L
.0679 .03211 L
.07047 .02476 L
.0717 .022 L
.07286 .01983 L
.07403 .01808 L
.0751 .01686 L
.07628 .01592 L
.07756 .01542 L
.07879 .01546 L
.07948 .01569 L
.08012 .01604 L
.0813 .01703 L
.08255 .01859 L
.08404 .02107 L
.08541 .02398 L
.0885 .03273 L
.09123 .04284 L
.09411 .05588 L
.10458 .12194 L
.11406 .20155 L
.12422 .29846 L
.14255 .46845 L
.15273 .54135 L
.15551 .55703 L
.15847 .57136 L
.16103 .58173 L
.16379 .5907 L
.16505 .59402 L
.16636 .59697 L
.16759 .5992 L
.16872 .60086 L
.16979 .60203 L
.17094 .60287 L
.1722 .60332 L
.17336 .60328 L
.17401 .60305 L
.17471 .60266 L
.17596 .60158 L
.17666 .60076 L
.17731 .59985 L
.17879 .59726 L
.18126 .59143 L
.18391 .58302 L
.18917 .56024 L
Mistroke
.19404 .53235 L
.20509 .4484 L
.22519 .25758 L
.23578 .16094 L
.24098 .11945 L
.24575 .08628 L
.25002 .0613 L
.2547 .03966 L
.25714 .03092 L
.25941 .02446 L
.2618 .01936 L
.26315 .01733 L
.26437 .01595 L
.26556 .01509 L
.26667 .01472 L
.26788 .01476 L
.26919 .01535 L
.2705 .01649 L
.27115 .01727 L
.27186 .01828 L
.27431 .02297 L
.27661 .02911 L
.27907 .03748 L
.28349 .05703 L
.2891 .08946 L
.29439 .12711 L
.30427 .21211 L
.32262 .38959 L
.33305 .48127 L
.33814 .51903 L
.34279 .54831 L
.34772 .57316 L
.35239 .59055 L
.35364 .59421 L
.35496 .59735 L
.35608 .59724 L
.35733 .59923 L
.35866 .60078 L
.35941 .6014 L
.3601 .60181 L
.36137 .6022 L
.362 .60221 L
.3627 .60206 L
.36338 .60175 L
.36412 .60124 L
.36482 .60061 L
.36546 .59989 L
.36797 .59592 L
.36927 .59304 L
.37071 .58923 L
Mistroke
.37361 .57962 L
.37885 .55595 L
.38376 .52698 L
.40402 .35725 L
.42255 .18112 L
.43175 .10768 L
.4368 .07495 L
.44155 .05013 L
.44426 .03881 L
.44719 .02908 L
.44849 .02558 L
.44985 .02245 L
.45113 .02009 L
.4523 .01837 L
.45349 .01707 L
.45476 .0162 L
.45594 .01585 L
.45706 .01591 L
.45836 .01653 L
.45956 .01758 L
.46088 .01926 L
.46228 .02166 L
.46466 .02712 L
.46717 .03481 L
.47166 .05314 L
.47649 .07951 L
.48176 .11514 L
.50005 .27603 L
.51099 .38232 L
.52132 .47378 L
.53059 .53975 L
.53581 .56768 L
.53814 .57763 L
.54063 .58641 L
.54188 .59071 L
.54307 .59406 L
.54414 .59662 L
.5453 .59626 L
.5464 .598 L
.54757 .59941 L
.54867 .60032 L
.54967 .60082 L
.55095 .60102 L
.55213 .60074 L
.55343 .5999 L
.55408 .59927 L
.55479 .59843 L
.556 .59667 L
.55729 .59432 L
.55961 .58867 L
Mistroke
.5622 .5804 L
.56501 .56914 L
.57013 .54296 L
.5797 .47659 L
.59913 .2989 L
.60945 .2013 L
.62055 .11072 L
.62598 .07549 L
.63115 .04902 L
.63579 .03177 L
.63706 .02815 L
.63842 .02488 L
.6396 .02251 L
.64086 .02046 L
.64214 .01883 L
.64332 .01782 L
.6446 .01726 L
.64532 .0172 L
.646 .01729 L
.64722 .01781 L
.64833 .01869 L
.64962 .02021 L
.65084 .02213 L
.65309 .02693 L
.65517 .03278 L
.65989 .05087 L
.66452 .07474 L
.66951 .10665 L
.67854 .17786 L
.69914 .37251 L
.70952 .46528 L
.71917 .53532 L
.72404 .56226 L
.72925 .58375 L
.73067 .58822 L
.73222 .59241 L
.73358 .59547 L
.73502 .59807 L
.73632 .59986 L
.73706 .60063 L
.73775 .60119 L
.73897 .60179 L
.74027 .60194 L
.74096 .60179 L
.7416 .6015 L
.74281 .6006 L
.74412 .59913 L
.74552 .59691 L
.74806 .59138 L
.75039 .5845 L
Mistroke
.75577 .56263 L
.76143 .53036 L
.77102 .45894 L
.78153 .36367 L
.79241 .25801 L
.80271 .1643 L
.81195 .09424 L
.81717 .06335 L
.822 .04131 L
.82423 .03364 L
.8254 .02948 L
.82663 .02576 L
.82772 .02309 L
.8289 .02061 L
.82998 .0202 L
.83098 .01896 L
.83228 .01783 L
.8335 .01726 L
.83459 .01716 L
.83578 .01747 L
.83707 .01836 L
.83772 .019 L
.83844 .01986 L
.83971 .02181 L
.84089 .02407 L
.84349 .03059 L
.84595 .03866 L
.85057 .0586 L
.85553 .08662 L
.86095 .124 L
.8803 .29639 L
.89058 .39508 L
.90168 .49023 L
.90682 .5268 L
.91223 .55838 L
.91684 .579 L
.91946 .5879 L
.9219 .59429 L
.92309 .59673 L
.92437 .59887 L
.92559 .6004 L
.92671 .60139 L
.92772 .60194 L
.92883 .60216 L
.93 .60195 L
.93108 .60137 L
.93235 .6002 L
.93356 .59862 L
.93464 .5968 L
.93582 .59439 L
Mistroke
.93846 .58743 L
.94091 .57911 L
.94548 .55885 L
.95044 .53002 L
.95941 .46367 L
.97619 .30939 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00<`3oool00`000000oooo0?ooo`3Z0?ooo`00<`3o
ool00`000000oooo0?ooo`3Z0?ooo`00<`3oool00`000000oooo0?ooo`3Z0?ooo`00<`3oool00`00
0000oooo0?ooo`3Z0?ooo`00<`3oool00`000000oooo0?ooo`090?ooo`800000;03oool2000002/0
oooo0`00000/0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool09P3oool003<0oooo
00<000000?ooo`3oool0203oool2000000030?ooo`000000oooo02T0oooo00<000000?ooo`000000
:`3oool00`000000oooo0000000[0?ooo`<00000:P3oool3000002P0oooo000c0?ooo`030000003o
ool0oooo00P0oooo00@000000?ooo`3oool00000:@3oool01@000000oooo0?ooo`3oool0000002X0
oooo00@000000?ooo`3oool00000:@3oool010000000oooo0?ooo`00000Z0?ooo`040000003oool0
oooo000002L0oooo000c0?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo0000
000Y0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool09P3oool01@000000oooo0?oo
o`3oool0000002T0oooo00D000000?ooo`3oool0oooo0000000X0?ooo`8000000P3oool00`000000
oooo0?ooo`0U0?ooo`00<`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02H0oooo
00D000000?ooo`3oool0oooo0000000X0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02@0oooo000c0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0903oool003<0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0T0?ooo`00<`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02@0oooo000c0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0903oool003<0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0280
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0S0?ooo`00<`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool08P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo02<0oooo000c0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02<0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool08`3oool003<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0R
0?ooo`00<`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0240oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0280oooo000c0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0Q0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0240oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool08P3oool000P0oooo0P0000040?ooo`800000
103oool2000000@0oooo0P0000040?ooo`800000103oool2000000<0oooo100000040?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0P0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo0240oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0R0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool08P3oool000L0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0240oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0Q0?ooo`001`3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool2
000000H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0240oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool08@3oool000030?ooo`0000000000008000000P3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0803oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0803oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0240oooo00070?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0P0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0P0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool08@3oool000P0
oooo0P00000:0?ooo`800000103oool2000000@0oooo0P0000040?ooo`800000103oool2000000D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0Q0?ooo`00<`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool07`3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool07`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo0240oooo000c0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool07`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01l0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0803oool003<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0N
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0P
0?ooo`00<`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01h0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0200oooo000c0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0N0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0N0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0803oool003<0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
7`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0P0?ooo`00<`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo01d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo0200oooo000c0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0803oool0
03<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
01h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0P0?ooo`00<`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo0200oooo000c0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool07`3oool003<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0O0?ooo`00<`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0oooo000c0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo01`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool07`3oool003<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0O0?ooo`00<`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo01l0oooo000c0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07`3o
ool003<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0O0?ooo`00<`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo01h0oooo000c0?ooo`050000003oool0oooo0?oo
o`0000003`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool07P3oool003<0oooo00D000000?ooo`3oool0oooo0000000@0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0N0?ooo`00203oool2000000@0
oooo0P0000040?ooo`800000103oool2000000@0oooo0P0000040?ooo`8000000`3oool5000000<0
oooo00D000000?ooo`3oool0oooo0000000@0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool06P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0N0?ooo`001`3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool01@000000
oooo0?ooo`3oool000000100oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0J0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo01h0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`8000000P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0N0?ooo`0000<0oooo0000000000000P0000020?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`050000
003oool0oooo0?ooo`000000403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool07P3oool000L0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo0000000@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0N0?ooo`00203oool2000000X0oooo0P0000040?ooo`800000103oool2000000@0oooo
0P0000040?ooo`8000001@3oool01@000000oooo0?ooo`3oool000000100oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01h0oooo000c0?ooo`050000
003oool0oooo0?ooo`000000403oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool07@3oool003<0oooo00D000000?ooo`3oool0oooo0000000A0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`00
<`3oool010000000oooo0?ooo`00000B0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0M0?ooo`00<`3oool010000000oooo0?ooo`00000B0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`00
<`3oool010000000oooo0?ooo`00000B0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0M0?ooo`00<`3oool010000000oooo0?ooo`00000B0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`00
<`3oool010000000oooo0?ooo`00000B0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0M0?ooo`00<`3oool010000000oooo0?ooo`00000B0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`00
<`3oool010000000oooo0?ooo`00000B0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0L0?ooo`00<`3oool010000000oooo0?ooo`00000C0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0L0?ooo`00
<`3oool010000000oooo0?ooo`00000C0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0L0?ooo`00<`3oool010000000oooo0?ooo`00000C0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0L0?ooo`00
<`3oool010000000oooo0?ooo`00000C0?ooo`030000003oool0oooo00d0oooo0P0000040?ooo`80
000000<0oooo0000003oool01000000>0?ooo`030000003oool0oooo00h0oooo0P0000040?ooo`80
000000<0oooo0000003oool00P3oool3000000h0oooo00<000000?ooo`3oool03@3oool2000000@0
oooo0P0000000`3oool000000?ooo`03000000l0oooo00<000000?ooo`3oool03P3oool2000000@0
oooo0`0000030?ooo`8000003`3oool00`000000oooo0?ooo`0C0?ooo`D00000103oool003<0oooo
00<000000?ooo`000000503oool00`000000oooo0?ooo`0<0?ooo`040000003oool0oooo000000H0
oooo00<000000?ooo`0000004P3oool00`000000oooo0?ooo`0<0?ooo`040000003oool0oooo0000
00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00`0oooo00@000000?ooo`3oool000001P3oool00`000000oooo000000020?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool03@3oool010000000oooo0?ooo`0000050?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo00@0oooo000c0?ooo`030000003oool0000001@0oooo00<000000?ooo`3oool0303o
ool010000000oooo0?ooo`0000060?ooo`040000003oool0oooo00000140oooo00<000000?ooo`3o
ool0303oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo00D000003P3oool00`00
0000oooo0?ooo`0<0?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00@000000?ooo`3oool000001@3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`040?ooo`00<`3oool00`000000oooo0000000D0?ooo`030000003o
ool0oooo00`0oooo00@000000?ooo`3oool000001P3oool01@000000oooo0?ooo`3oool000000100
oooo00<000000?ooo`3oool0303oool010000000oooo0?ooo`0000050?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`040000003oool0
oooo000000D0oooo00<000000?ooo`3oool00`00000@0?ooo`030000003oool0oooo00`0oooo00@0
00000?ooo`3oool000001@3oool010000000oooo0?ooo`3oool2000000l0oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`040?ooo`00<`3oool00`000000oooo0000000D0?ooo`030000
003oool0oooo00`0oooo00@000000?ooo`3oool000001@3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool010000000oooo0?ooo`000005
0?ooo`070000003oool0oooo0?ooo`000000oooo0000000?0?ooo`030000003oool0oooo00`0oooo
00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool000000140oooo00<000000?oo
o`3oool0303oool010000000oooo0?ooo`0000050?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00@0oooo000c
0?ooo`030000003oool0000001D0oooo00<000000?ooo`3oool0303oool2000000H0oooo00@00000
0?ooo`3oool0oooo0P00000@0?ooo`030000003oool0oooo00d0oooo0P0000060?ooo`030000003o
ool0oooo0080oooo0P00000?0?ooo`030000003oool0oooo00d0oooo0P0000060?ooo`040000003o
ool0oooo0?ooo`<000003`3oool00`000000oooo0?ooo`0=0?ooo`8000001P3oool010000000oooo
0?ooo`3oool200000100oooo00<000000?ooo`3oool04`3oool2000000H0oooo000c0?ooo`030000
003oool0000001D0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo01/0oooo000c0?ooo`030000003oool0000001D0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01/0oooo000c0?ooo`030000003oool0
000001D0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo01/0oooo000c0?ooo`030000003oool0000001D0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo01/0oooo000c0?ooo`030000003oool0000001D0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01/0
oooo000]0?oooo<00000000c0?ooo`8000002@3oool00`000000oooo0?ooo`090?ooo`8000002@3o
ool00`000000oooo0?ooo`090?ooo`8000002@3oool00`000000oooo0?ooo`090?ooo`8000002@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3o
ool2000000T0oooo00<000000?ooo`3oool02@3oool2000000T0oooo00<000000?ooo`3oool02@3o
ool2000000T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00@0oooo000c0?ooo`8000005P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01<0oooo0P00000F0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00@0oooo000c0?ooo`8000005`3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`040?ooo`00<`3oool2000001L0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0103oool003<0oooo
0P00000G0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo00D0oooo000c0?ooo`8000005`3oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`050?ooo`00<`3oool2000001L0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01@3oool003<0oooo0P00000G0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo00D0oooo000c0?ooo`8000005`3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`050?ooo`00
<`3oool2000001L0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool01@3oool003<0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`050?ooo`00<`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo00D0oooo000c0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01@3oool003<0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`060?ooo`00<`3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00H0oooo000c0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool01P3oool003<0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`06
0?ooo`00<`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00H0oooo000c0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool01P3oool003<0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`060?ooo`00<`3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo00H0oooo000c0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01P3oool0
03<0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`060?ooo`00<`3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo00L0oooo00080?ooo`800000103oool2000000@0oooo
0P0000040?ooo`800000103oool2000000@0oooo0P0000030?ooo`D000000`3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00L0oooo00070?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool01`3oool000L0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo0P00000I
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00L0oooo00070?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool01`3oool000L0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool06P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`070?ooo`00203oool2000000X0oooo0P0000040?ooo`800000
103oool2000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0J0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00L0oooo000c0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01`3o
ool003<0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo01X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`070?ooo`00<`3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo000c0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0203oool003<0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`080?ooo`00<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01/0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo000c
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0L
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0L
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0203oool003<0oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01`0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`080?ooo`00<`3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0L0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00P0oooo000c0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
7@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
203oool003<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo01d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`00<`3oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo000c0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02@3oool003<0oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`090?ooo`00<`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01h0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo
000c0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool003<0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01h0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01h0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`00<`3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0O0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00T0oooo000c0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool02P3oool003<0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo0200oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0O0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo0200oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`00<`3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00080?ooo`800000103oool2
000000@0oooo0P0000040?ooo`800000103oool2000000@0oooo0P0000030?ooo`@00000103oool0
0`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00070?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0P0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo0240oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0P0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool000L0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00@0
oooo0P00000M0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00070?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0Q0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo0240oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0P0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool000L0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo
00<000000?ooo`3oool0703oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0280oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0240oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0;0?ooo`00203oool2000000X0oooo0P00
00040?ooo`800000103oool2000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0Q0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00/0oooo000c0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool08@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0240oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool02`3oool003<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo0280oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0280oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?oo
o`00<`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool08`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool08`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo000c0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0S0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0S0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0303oool003<0oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0<0?ooo`00<`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0T0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00d0oooo000c0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3oool003<0
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`00<`3oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00d0oooo000c0?ooo`030000003oool0oooo01h0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`050000003oool0oooo0?ooo`000000
:03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
3@3oool003<0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo02H0oooo00D000000?ooo`3oool0oooo0000000Y0?ooo`050000003oool0oooo0?ooo`00
0000:03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02H0oooo00D000000?ooo`3o
ool0oooo0000000@0?ooo`00<`3oool00`000000oooo0?ooo`0O0?ooo`040000003oool0oooo0000
02T0oooo00D000000?ooo`3oool0oooo0000000Y0?ooo`80000000<0oooo0000003oool0:@3oool0
10000000oooo0?ooo`00000Z0?ooo`040000003oool0oooo00000100oooo000c0?ooo`030000003o
ool0oooo01l0oooo00@000000?ooo`3oool00000:P3oool00`000000oooo0000000Z0?ooo`800000
00<0oooo0000003oool0:@3oool2000000030?ooo`000000oooo02T0oooo1000000@0?ooo`00<`3o
ool00`000000oooo0?ooo`0P0?ooo`800000:`3oool3000002`0oooo00<000000?ooo`3oool0:P3o
ool2000002`0oooo0P00000A0?ooo`00<`3oool00`000000oooo0?ooo`3Z0?ooo`00<`3oool00`00
0000oooo0?ooo`3Z0?ooo`00<`3oool00`000000oooo0?ooo`3Z0?ooo`00<`3oool00`000000oooo
0?ooo`3Z0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.221625, -3.26163, \
0.00434366, 3.683}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell["\<\
Using extra precision to solve for the initial conditions reduces the error \
substantially.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(sol\  = \ 
      First[x\  /. \ 
          NDSolve[{\(x''\)[t]\  + \ 1000\ x[t]\  \[Equal] \ 0, \ 
              x[0]\  \[Equal] \ 0, \ x[1]\  \[Equal] \ 1}, 
            x, {t, \ 0, \ 1}, \ 
            Method \[Rule] {Chasing, \ 
                ExtraPrecision \[Rule] 10}]]; \), "\[IndentingNewLine]", 
    \(Plot[sol[t]\  - \ dsol[t], {t, 0, 1}]\)}], "Input",
  CellLabel->"In[19]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.28822 487073 [
[.21429 .27572 -9 -9 ]
[.21429 .27572 9 0 ]
[.40476 .27572 -9 -9 ]
[.40476 .27572 9 0 ]
[.59524 .27572 -9 -9 ]
[.59524 .27572 9 0 ]
[.78571 .27572 -9 -9 ]
[.78571 .27572 9 0 ]
[.97619 .27572 -3 -9 ]
[.97619 .27572 3 0 ]
[.01131 .09339 -39 -6.25 ]
[.01131 .09339 0 6.25 ]
[.01131 .19081 -39 -6.25 ]
[.01131 .19081 0 6.25 ]
[.01131 .38563 -33 -6.25 ]
[.01131 .38563 0 6.25 ]
[.01131 .48305 -33 -6.25 ]
[.01131 .48305 0 6.25 ]
[.01131 .58046 -33 -6.25 ]
[.01131 .58046 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .28822 m
.21429 .29447 L
s
[(0.2)] .21429 .27572 0 1 Mshowa
.40476 .28822 m
.40476 .29447 L
s
[(0.4)] .40476 .27572 0 1 Mshowa
.59524 .28822 m
.59524 .29447 L
s
[(0.6)] .59524 .27572 0 1 Mshowa
.78571 .28822 m
.78571 .29447 L
s
[(0.8)] .78571 .27572 0 1 Mshowa
.97619 .28822 m
.97619 .29447 L
s
[(1)] .97619 .27572 0 1 Mshowa
.125 Mabswid
.07143 .28822 m
.07143 .29197 L
s
.11905 .28822 m
.11905 .29197 L
s
.16667 .28822 m
.16667 .29197 L
s
.2619 .28822 m
.2619 .29197 L
s
.30952 .28822 m
.30952 .29197 L
s
.35714 .28822 m
.35714 .29197 L
s
.45238 .28822 m
.45238 .29197 L
s
.5 .28822 m
.5 .29197 L
s
.54762 .28822 m
.54762 .29197 L
s
.64286 .28822 m
.64286 .29197 L
s
.69048 .28822 m
.69048 .29197 L
s
.7381 .28822 m
.7381 .29197 L
s
.83333 .28822 m
.83333 .29197 L
s
.88095 .28822 m
.88095 .29197 L
s
.92857 .28822 m
.92857 .29197 L
s
.25 Mabswid
0 .28822 m
1 .28822 L
s
.02381 .09339 m
.03006 .09339 L
s
gsave
.01131 .09339 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .19081 m
.03006 .19081 L
s
gsave
.01131 .19081 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .38563 m
.03006 .38563 L
s
gsave
.01131 .38563 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .48305 m
.03006 .48305 L
s
gsave
.01131 .48305 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .58046 m
.03006 .58046 L
s
gsave
.01131 .58046 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(6) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.125 Mabswid
.02381 .02033 m
.02756 .02033 L
s
.02381 .04468 m
.02756 .04468 L
s
.02381 .06904 m
.02756 .06904 L
s
.02381 .11774 m
.02756 .11774 L
s
.02381 .1421 m
.02756 .1421 L
s
.02381 .16645 m
.02756 .16645 L
s
.02381 .21516 m
.02756 .21516 L
s
.02381 .23951 m
.02756 .23951 L
s
.02381 .26387 m
.02756 .26387 L
s
.02381 .31257 m
.02756 .31257 L
s
.02381 .33693 m
.02756 .33693 L
s
.02381 .36128 m
.02756 .36128 L
s
.02381 .40999 m
.02756 .40999 L
s
.02381 .43434 m
.02756 .43434 L
s
.02381 .4587 m
.02756 .4587 L
s
.02381 .5074 m
.02756 .5074 L
s
.02381 .53176 m
.02756 .53176 L
s
.02381 .55611 m
.02756 .55611 L
s
.02381 .60482 m
.02756 .60482 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .30169 L
.08255 .13352 L
.08806 .09559 L
.09396 .06351 L
.09952 .03949 L
.10193 .03112 L
.10458 .02383 L
.10704 .01894 L
.10839 .01705 L
.10965 .01574 L
.11083 .01502 L
.11191 .01472 L
.11315 .01483 L
.11433 .01537 L
.1156 .0161 L
.11632 .01674 L
.11696 .01757 L
.11823 .01925 L
.1194 .02066 L
.12006 .022 L
.12076 .02372 L
.12224 .02682 L
.12352 .03052 L
.12424 .03335 L
.12492 .0367 L
.1342 .09016 L
.13941 .13067 L
.14415 .18151 L
.15341 .23702 L
.15565 .25531 L
.15684 .26258 L
.15808 .27267 L
.15874 .2781 L
.15947 .27861 L
.16074 .2801 L
.16203 .32412 L
.16324 .3593 L
.16391 .36975 L
.16464 .38036 L
.16533 .3867 L
.16597 .39313 L
.16717 .36529 L
.16845 .37739 L
.17402 .41872 L
.17923 .4526 L
.184 .47777 L
.18851 .49786 L
.19343 .51598 L
.19613 .52377 L
Mistroke
.19745 .5267 L
.19863 .52911 L
.19987 .53096 L
.20103 .53232 L
.20225 .53349 L
.20357 .5341 L
.20472 .53417 L
.20579 .53389 L
.20696 .53312 L
.20822 .53194 L
.20942 .53105 L
.21073 .52988 L
.21197 .52752 L
.21312 .52614 L
.21426 .52537 L
.21534 .52279 L
.21647 .51919 L
.2177 .5156 L
.21869 .51217 L
.21972 .50751 L
.22085 .49882 L
.22188 .48928 L
.26005 .20731 L
.2649 .1702 L
.27016 .13242 L
.27512 .10552 L
.27969 .08458 L
.28504 .066 L
.28773 .05915 L
.28927 .05605 L
.29068 .05372 L
.29188 .05192 L
.29317 .05051 L
.29388 .05002 L
.29454 .04968 L
.29584 .04919 L
.29695 .04924 L
.29818 .04978 L
.29946 .05073 L
.30066 .05212 L
.30183 .05387 L
.30308 .05617 L
.30534 .06154 L
.31047 .07636 L
.31112 .07783 L
.31181 .07937 L
.31256 .08181 L
.31326 .08492 L
.31589 .09851 L
.31823 .11347 L
Mistroke
.32082 .13575 L
.33931 .27235 L
.35011 .35751 L
.35543 .39703 L
.36037 .43155 L
.3652 .45749 L
.36958 .47707 L
.37191 .48579 L
.37444 .49351 L
.37711 .49983 L
.37962 .50423 L
.38188 .50757 L
.38313 .50918 L
.38431 .51036 L
.38497 .51085 L
.3857 .51129 L
.38697 .51178 L
.38826 .51176 L
.38945 .51143 L
.39068 .51068 L
.39184 .50961 L
.39311 .50811 L
.39448 .50599 L
.39727 .50023 L
.39983 .49374 L
.40415 .48023 L
.40888 .45936 L
.41382 .429 L
.41841 .39738 L
.43716 .2656 L
.45748 .16495 L
.46288 .13594 L
.46859 .1134 L
.47095 .10658 L
.47347 .09979 L
.47492 .09705 L
.47625 .09471 L
.47884 .09128 L
.48124 .08762 L
.48255 .08661 L
.48379 .0837 L
.4845 .08287 L
.48526 .08319 L
.48595 .08347 L
.48659 .08293 L
.48785 .08137 L
.48849 .08162 L
.48918 .08277 L
.49047 .08864 L
.49164 .09697 L
Mistroke
.49228 .10003 L
.49299 .10201 L
.49426 .10744 L
.499 .12879 L
.51843 .2417 L
.52875 .30788 L
.53444 .33493 L
.53724 .34993 L
.53795 .35358 L
.53861 .35702 L
.53985 .3606 L
.54103 .36512 L
.5423 .38561 L
.54297 .39357 L
.54366 .39817 L
.54492 .40688 L
.54558 .29798 L
.54628 .30155 L
.54756 .30745 L
.55045 .3202 L
.56016 .3706 L
.56527 .39164 L
.57011 .40785 L
.57446 .41924 L
.57693 .42446 L
.57919 .42818 L
.5803 .42981 L
.58152 .43117 L
.58274 .43226 L
.58403 .43308 L
.58858 .43539 L
.58922 .43519 L
.58992 .43524 L
.59118 .43666 L
.59193 .43714 L
.59263 .43671 L
.59395 .43561 L
.59521 .43526 L
.59638 .4338 L
.59761 .42988 L
.59826 .42594 L
.59895 .4216 L
.59963 .41859 L
.60035 .41676 L
.60165 .41282 L
.60458 .40344 L
.60993 .38434 L
.61996 .34413 L
.63996 .25521 L
.65048 .21317 L
Mistroke
.65577 .19785 L
.66158 .18481 L
.6668 .17482 L
.66967 .17025 L
.67109 .16857 L
.67239 .1671 L
.67362 .1662 L
.67492 .16544 L
.67623 .16489 L
.67697 .16478 L
.67767 .16475 L
.67888 .16484 L
.67999 .16518 L
.6812 .16579 L
.68248 .16639 L
.68368 .16647 L
.68478 .16707 L
.68604 .16832 L
.68724 .16783 L
.68834 .16768 L
.68936 .16931 L
.69166 .17406 L
.69286 .17687 L
.69398 .18095 L
.69521 .18901 L
.69653 .19522 L
.69719 .19708 L
.69791 .19933 L
.69923 .20336 L
.70169 .21138 L
.72104 .28491 L
.73132 .32581 L
.74242 .37101 L
.74756 .38883 L
.75036 .3985 L
.75172 .40518 L
.75297 .411 L
.75411 .41336 L
.7552 .41677 L
.75636 .42122 L
.75758 .4236 L
.75885 .42265 L
.76001 .41729 L
.76126 .41438 L
.76198 .41451 L
.76264 .41417 L
.76382 .41332 L
.76509 .41281 L
.7663 .41131 L
.76742 .41059 L
Mistroke
.76854 .40891 L
.76954 .40767 L
.7718 .4038 L
.77649 .39406 L
.77916 .38823 L
.78046 .38561 L
.78165 .38105 L
.784 .3709 L
.78652 .35829 L
.79167 .33611 L
.8009 .30217 L
.80614 .28089 L
.80753 .27506 L
.8083 .27103 L
.80902 .2661 L
.81033 .26106 L
.81099 .26169 L
.81171 .26457 L
.81291 .26427 L
.81418 .26125 L
.81647 .25602 L
.81899 .24977 L
.82032 .24763 L
.82104 .2461 L
.82172 .24468 L
.82299 .24601 L
.82367 .25056 L
.8244 .24304 L
.82569 .21286 L
.82687 .19876 L
.82806 .18644 L
.82936 .23493 L
.83059 .23316 L
.83172 .23166 L
.83399 .22914 L
.8351 .2279 L
.83612 .22705 L
.83731 .22667 L
.83858 .2256 L
.83967 .22562 L
.84081 .22534 L
.84211 .22499 L
.84329 .22537 L
.84394 .22518 L
.84465 .22493 L
.84594 .22485 L
.84714 .2247 L
.84842 .22438 L
.84951 .22427 L
.85072 .2243 L
Mistroke
.85144 .22427 L
.85212 .22434 L
.85341 .22469 L
.85414 .22486 L
.85492 .22503 L
.85565 .2253 L
.85632 .22564 L
.85883 .22714 L
.86157 .22925 L
.86389 .23154 L
.86644 .23469 L
.87158 .24206 L
.8808 .26015 L
.88599 .27381 L
.89156 .29057 L
.90161 .32004 L
.90654 .33859 L
.90903 .34605 L
.91044 .34911 L
.91178 .35175 L
.91454 .35682 L
.91752 .36144 L
.92006 .36478 L
.92284 .36748 L
.92411 .36869 L
.92482 .36925 L
.92548 .36968 L
.92677 .36995 L
.92794 .37028 L
.9286 .37038 L
.92929 .37019 L
.93053 .36997 L
.93121 .36993 L
.93186 .36958 L
.93333 .36869 L
.93556 .36666 L
.93793 .36437 L
.93863 .36346 L
.9393 .36283 L
.94053 .36267 L
.9417 .36219 L
.94295 .36204 L
.94403 .36421 L
.94521 .36219 L
.94644 .35331 L
.94759 .34767 L
.95186 .33044 L
.95594 .31753 L
.95804 .31233 L
.96031 .30755 L
Mistroke
.96139 .30579 L
.96253 .30407 L
.96359 .30275 L
.96458 .30187 L
.96558 .30096 L
.9665 .30056 L
.96752 .3002 L
.96862 .29993 L
.97053 .29948 L
.97231 .29899 L
.97321 .29867 L
.97416 .29807 L
.97523 .29834 L
.97619 .28822 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[19]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00
:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?ooo`0B0?ooo`800000g`3o
ool002X0oooo00<000000?ooo`3oool04P3oool00`000000oooo0000003N0?ooo`00:P3oool20000
0180oooo00D000000?ooo`3oool0oooo0000003M0?ooo`00:P3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0f`3oool002X0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0=X0oooo000Z0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3J0?ooo`00:P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0fP3o
ool002X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0=X0oooo000Z0?ooo`800000403oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0=X0oooo000Z0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0W0?ooo`<00000/03oool002X0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo02H0oooo00<000000?ooo`000000/03oool002X0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02D0oooo00D0
00000?ooo`3oool0oooo0000002_0?ooo`00:P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0:d0oooo000Z0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0[@3oool0
02X0oooo0P00000?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0:`0oooo000Z0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0[03oool002X0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`2[0?ooo`002@3oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`0000001000
00020?ooo`8000003P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02P0oooo0P00
00210?ooo`002P3oool01`000000oooo0?ooo`3oool000000?ooo`000000103oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo02L0oooo0`0000210?ooo`001`3oool5000000<0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool08P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000P03oool00003
0?ooo`0000000000008000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool00000
00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0oooo0P00000>
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo02D0oooo00D000000?ooo`3oool0oooo000000200?ooo`00203oool0
0`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo02D0oooo00D000000?ooo`3oool0oooo000000200?ooo`002@3oool2000000T0oooo
0P0000040?ooo`8000002@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0903oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo07h0oooo
000U0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0O@3oool001l0oooo0`000004
0?ooo`050000003oool0oooo0?ooo`0000003P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo0200oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0S0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0O@3oool002H0oooo00D000000?ooo`3oool0oooo0000
000>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`1m0?ooo`00903oool3000000<0oooo0P00000=0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`1m0?ooo`00:P3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1l0?oo
o`00:P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool07P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`1l0?ooo`00:P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo0240oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1l0?ooo`00:P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`1l0?ooo`00:P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0240oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1l0?ooo`00:P3oool20000
00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
07/0oooo000Z0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo07/0oooo000Z0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo07/0oooo
000Z0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo07/0oooo000Z0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo07/0oooo000Z0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo07/0oooo000Z0?ooo`8000002`3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo01/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0N0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool09P3oool400000500oooo000Z0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo02H0oooo00@000000?ooo`3oool0oooo0P00001>0?ooo`00:P3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0C03oool000L0oooo1000
00020?ooo`060000003oool0oooo0?ooo`000000oooo1@0000020?ooo`8000003P3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0C03oool000L0oooo
00<000000?ooo`3oool0103oool00`000000oooo000000040?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`1;0?ooo`00203oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool0:P3oool000030?ooo`000000000000800000103oool00`000000oooo
0?ooo`020?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00/0oooo0P00000:0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool06P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool07P3oool00`000000oooo0?ooo`0Z0?ooo`001`3oool010000000oooo0?ooo`0000020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`0Z0?ooo`00203oool2000000X0oooo0P0000040?oo
o`8000002@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0240oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02X0oooo000U0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0:P3oool001l0oooo0`0000040?ooo`050000
003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool0:P3oool002H0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0Z0?ooo`00
903oool3000000<0oooo0P00000:0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
703oool2000002/0oooo000Z0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0L0?ooo`800000:`3oool002X0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool07P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01/0oooo0P00000[0?ooo`00:P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool06`3oool90000
02@0oooo000Z0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0J0?ooo`040000003oool00000000000H0oooo00<000000?ooo`3oool08@3oool002X0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`0000001`3oool200000280oooo000Z0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01`0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0803oool002X0oooo0P0000090?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01l0oooo000Z
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`05
0?ooo`800000103oool2000000<0oooo100000030?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool01`3oool2000000@0oooo0P0000050?ooo`@000004`3oool00`000000oooo0?ooo`09
0?ooo`800000103oool2000000<0oooo0`0000050?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool02@3oool2000000@0oooo0P0000040?ooo`8000000P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo01D0oooo1@0000040?ooo`00:P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`000008
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`06
0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`0000004`3oool00`000000oooo0?oo
o`080?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool00000203oool00`00
0000oooo0?ooo`03000000`0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`040?oo
o`00:P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool00`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000P0oooo1P00000C
0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01`3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000000l0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`040?ooo`00:P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000:0?ooo`050000003oool0oooo
0?ooo`000000503oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000P0oooo00<0
00000?ooo`3oool00P00000D0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool00000
203oool3000000@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`070?ooo`040000
003oool0oooo000000T0oooo0`00000?0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool0103oool002X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo00<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`000009
0?ooo`040000003oool00000000001D0oooo00<000000?ooo`3oool01`3oool010000000oooo0?oo
o`0000090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`0000000000403oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo00@0oooo000Z0?ooo`800000203oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo00@0oooo0P00000:0?ooo`8000000`3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00H0oooo0P00000;0?ooo`<000005@3oool00`000000
oooo0?ooo`080?ooo`8000002P3oool3000000<0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`070?ooo`8000002P3oool300000100oooo00<000000?ooo`3oool0503oool2000000H0
oooo000Z0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool06`3oool002X0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0K0?ooo`00:P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo01@0oooo0P00000F0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool05@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01T0oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool06`3oool002X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0K0?oo
o`00:P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01X0oooo000T0?oooo`00000
000Z0?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool000002`3oool00`000000oooo
0?ooo`070?ooo`8000002`3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000/0
oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool01P3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00D0oooo00D00000
0?ooo`3oool0oooo0000000;0?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo
0?ooo`090?ooo`030000003oool0000000T0oooo00<000000?ooo`3oool0203oool2000000H0oooo
000Z0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo00D0oooo000Z0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool05P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01D0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0>0?ooo`@000001`3oool002X0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool05@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0203oool002X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0203oool002X0oooo0P0000070?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`00:P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool05`3o
ool010000000oooo0?ooo`3oool200000180oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0:0?ooo`00:P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool05`3oool010000000oooo0?ooo`3oool200000140oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0:0?ooo`00:P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool05`3oool010000000oooo0?ooo`3oool200000140oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`00:P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0F0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool05`3oool010000000oooo0?oo
o`3oool200000140oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`00:P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0200000140oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0;0?ooo`00:P3oool2000000H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0H
0?ooo`060000003oool0oooo0000003oool000003`3oool00`000000oooo0?ooo`0J0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00/0oooo000Z0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0H0?ooo`060000003oool0oooo0000003oool000003`3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00`0oooo000Z0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0H0?ooo`060000003oool0oooo0000003o
ool000003`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00`0oooo000Z0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?ooo`06
0000003oool0oooo0000003oool000003`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00`0oooo000Z0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0J0?ooo`8000000P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0303oool002X0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo0P0000020?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`00:P3oool2000000D0oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`8000000`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo00<0oooo0P00000>0?ooo`00:P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo01T0oooo0P00000@0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`8000000`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0O0?ooo`040000003oool0oooo0?ooo`<000003`3oool002X0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0I0?ooo`800000403oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool06P3oool2000000<0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0803o
ool400000140oooo00070?ooo`@000000P3oool01P000000oooo0?ooo`3oool000000?ooo`D00000
0P3oool2000000h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`800000
403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
6P3oool2000000<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0=@3oool000L0oooo00<000000?ooo`3oool0103o
ool00`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3oool200000100oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01/0oooo
00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0e0?ooo`00203oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`800000403oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0703oool01@000000
oooo0?ooo`3oool0000000`0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo03D0oooo00090?ooo`030000003oool0oooo0080oooo00<000000?ooo`00
0000103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3oool20000
00D0oooo00<000000?ooo`3oool06@3oool200000100oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0f0?ooo`001`3oool010000000oooo0?ooo`0000020?ooo`050000003oool0oooo
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01X0oooo0P00000@0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0L0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0=P3oool000P0oooo0P00000:0?ooo`800000103oool2
000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01X0oooo0P00000?0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0=`3oool0
02D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
03L0oooo000O0?ooo`<00000103oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01`0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0>03oool002H0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
03P0oooo000T0?ooo`<000000`3oool2000000@0oooo00<000000?ooo`3oool0703oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0R0?ooo`040000003oool0oooo0?ooo`800000>P3oool002X0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0S0?ooo`040000003oool00000000003/0oooo000Z0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0903oool2000003d0oooo000Z0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0903oool2000003d0oooo000Z0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0k0?ooo`00:P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo06<0oooo000Z0?ooo`8000000`3oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo02P0oooo00@000000?ooo`3oool00000IP3oool0
02X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
02T0oooo0`00001V0?ooo`00:P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0TP3oool002X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo09<0oooo000Z0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool07`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`2C0?ooo`00:P3oool01@000000oooo0?ooo`3o
ool000000280oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0T`3oool002X0oooo00D000000?ooo`3oool0oooo0000
000R0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo09<0oooo000Z0?ooo`8000000P3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo09<0oooo000Z0?ooo`050000003oool0oooo0?ooo`0000008P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`2C0?ooo`002@3oool3000000030?ooo`000000oooo0080oooo00<000000?oo
o`000000100000020?ooo`8000003P3oool01@000000oooo0?ooo`3oool0000002<0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0T`3oool000X0oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0oooo00D000000?ooo`3oool0
oooo0000000S0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool08@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo09@0oooo00070?ooo`D000000`3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0;0?ooo`05
0000003oool0oooo0?ooo`0000008`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0280oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2D0?ooo`001`3oool010000000
oooo0?ooo`0000030?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo00/0oooo00D000000?ooo`3oool0oooo0000000S0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo09@0oooo00080?ooo`030000003oool000000080oooo00D000000?ooo`3oool0oooo0000
00030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0;0?ooo`800000
0P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo09@0oooo00090?ooo`8000002@3o
ool2000000@0oooo0P00000>0?ooo`040000003oool0oooo000002D0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
U@3oool002D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00000U0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo09D0oooo000U0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
9@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`2F0?ooo`007`3oool3000000@0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0UP3oool002H0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0U0?ooo`050000003oool0oooo0?ooo`000000V03oool002@0oooo
0`0000030?ooo`80000000<0oooo0000003oool09@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo02D0oooo0P0000000`3oool000000?ooo`2H0?ooo`00:P3oool010000000oooo0?oo
o`00000V0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool09P3oool3000009T0oooo
000Z0?ooo`040000003oool0oooo000002H0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`330?ooo`00:P3oool00`000000oooo0000000W0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0``3oool002X0oooo00<000000?ooo`000000:03oool010000000oooo0?ooo`3o
ool200000<D0oooo000Z0?ooo`030000003oool0000002P0oooo00D000000?ooo`3oool0oooo0000
00360?ooo`00:P3oool3000002T0oooo0`0000370?ooo`00:P3oool00`000000oooo0000000Z0?oo
o`030000003oool0oooo0<H0oooo000Z0?ooo`030000003oool000000?<0oooo000Z0?ooo`030000
003oool000000?<0oooo000Z0?ooo`030000003oool000000?<0oooo000Z0?ooo`030000003oool0
00000?<0oooo000Z0?ooo`800000m03oool002X0oooo0P00003d0?ooo`00:P3oool200000?@0oooo
00070?ooo`<000000`3oool01P000000oooo0?ooo`3oool000000?ooo`D000000P3oool2000000h0
oooo0P00003d0?ooo`001`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0000000@0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0oooo0P00003d0?oo
o`001`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo00/0oooo0P00003d0?ooo`001`3oool30000
00@0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool02`3oool200000?@0oooo00080?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0;0?ooo`800000m03oool000P0oooo0`0000090?ooo`800000103oool2000000T0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`3c0?ooo`009@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0?<0oooo000O0?ooo`<00000103oool01@000000oooo0?ooo`3oool00000
0?D0oooo000V0?ooo`050000003oool0oooo0?ooo`000000m@3oool002@0oooo0`0000030?ooo`80
0000m03oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0l`3o
ool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0l`3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.176385, -6.81423, \
0.00418603, 8.185}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell[TextData[{
  "Increasing the extra precision beyond this really will not help because a \
significant part of the error results from computing the solution once the \
initial conditions are found. To reduce this, you need to give more stringent \
",
  StyleBox["AccuracyGoal", "MR"],
  " and ",
  StyleBox["PrecisionGoal", "MR"],
  " options to ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text"],

Cell[TextData[{
  "This uses extra precision to compute the initial conditions along with \
more stringent settings for the ",
  StyleBox["AccuracyGoal", "MR"],
  " and ",
  StyleBox["PrecisionGoal", "MR"],
  " options."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(sol\  = \ 
      First[x\  /. \ 
          NDSolve[{\(x''\)[t]\  + \ 1000\ x[t]\  \[Equal] \ 0, \ 
              x[0]\  \[Equal] \ 0, \ x[1]\  \[Equal] \ 1}, 
            x, {t, \ 0, \ 1}, \ 
            Method \[Rule] {Chasing, \ ExtraPrecision \[Rule] 10}, \ 
            AccuracyGoal \[Rule] 10, \ 
            PrecisionGoal \[Rule] 10]]; \), "\[IndentingNewLine]", 
    \(Plot[sol[t]\  - \ dsol[t], {t, 0, 1}]\)}], "Input",
  CellLabel->"In[21]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.308837 5.06458e+007 [
[.21429 .29634 -9 -9 ]
[.21429 .29634 9 0 ]
[.40476 .29634 -9 -9 ]
[.40476 .29634 9 0 ]
[.59524 .29634 -9 -9 ]
[.59524 .29634 9 0 ]
[.78571 .29634 -9 -9 ]
[.78571 .29634 9 0 ]
[.97619 .29634 -3 -9 ]
[.97619 .29634 3 0 ]
[.01131 .00496 -39 -6.25 ]
[.01131 .00496 0 6.25 ]
[.01131 .10625 -39 -6.25 ]
[.01131 .10625 0 6.25 ]
[.01131 .20755 -39 -6.25 ]
[.01131 .20755 0 6.25 ]
[.01131 .41013 -33 -6.25 ]
[.01131 .41013 0 6.25 ]
[.01131 .51142 -33 -6.25 ]
[.01131 .51142 0 6.25 ]
[.01131 .61271 -33 -6.25 ]
[.01131 .61271 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30884 m
.21429 .31509 L
s
[(0.2)] .21429 .29634 0 1 Mshowa
.40476 .30884 m
.40476 .31509 L
s
[(0.4)] .40476 .29634 0 1 Mshowa
.59524 .30884 m
.59524 .31509 L
s
[(0.6)] .59524 .29634 0 1 Mshowa
.78571 .30884 m
.78571 .31509 L
s
[(0.8)] .78571 .29634 0 1 Mshowa
.97619 .30884 m
.97619 .31509 L
s
[(1)] .97619 .29634 0 1 Mshowa
.125 Mabswid
.07143 .30884 m
.07143 .31259 L
s
.11905 .30884 m
.11905 .31259 L
s
.16667 .30884 m
.16667 .31259 L
s
.2619 .30884 m
.2619 .31259 L
s
.30952 .30884 m
.30952 .31259 L
s
.35714 .30884 m
.35714 .31259 L
s
.45238 .30884 m
.45238 .31259 L
s
.5 .30884 m
.5 .31259 L
s
.54762 .30884 m
.54762 .31259 L
s
.64286 .30884 m
.64286 .31259 L
s
.69048 .30884 m
.69048 .31259 L
s
.7381 .30884 m
.7381 .31259 L
s
.83333 .30884 m
.83333 .31259 L
s
.88095 .30884 m
.88095 .31259 L
s
.92857 .30884 m
.92857 .31259 L
s
.25 Mabswid
0 .30884 m
1 .30884 L
s
.02381 .00496 m
.03006 .00496 L
s
gsave
.01131 .00496 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-6) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-9) show
grestore
.02381 .10625 m
.03006 .10625 L
s
gsave
.01131 .10625 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-9) show
grestore
.02381 .20755 m
.03006 .20755 L
s
gsave
.01131 .20755 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-9) show
grestore
.02381 .41013 m
.03006 .41013 L
s
gsave
.01131 .41013 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-9) show
grestore
.02381 .51142 m
.03006 .51142 L
s
gsave
.01131 .51142 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-9) show
grestore
.02381 .61271 m
.03006 .61271 L
s
gsave
.01131 .61271 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(6) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-9) show
grestore
.125 Mabswid
.02381 .03029 m
.02756 .03029 L
s
.02381 .05561 m
.02756 .05561 L
s
.02381 .08093 m
.02756 .08093 L
s
.02381 .13158 m
.02756 .13158 L
s
.02381 .1569 m
.02756 .1569 L
s
.02381 .18222 m
.02756 .18222 L
s
.02381 .23287 m
.02756 .23287 L
s
.02381 .25819 m
.02756 .25819 L
s
.02381 .28351 m
.02756 .28351 L
s
.02381 .33416 m
.02756 .33416 L
s
.02381 .35948 m
.02756 .35948 L
s
.02381 .38481 m
.02756 .38481 L
s
.02381 .43545 m
.02756 .43545 L
s
.02381 .46077 m
.02756 .46077 L
s
.02381 .4861 m
.02756 .4861 L
s
.02381 .53674 m
.02756 .53674 L
s
.02381 .56207 m
.02756 .56207 L
s
.02381 .58739 m
.02756 .58739 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .33815 L
.07216 .43578 L
.08255 .517 L
.08852 .55547 L
.09396 .58015 L
.09658 .5887 L
.09729 .59234 L
.09796 .5945 L
.09865 .59478 L
.09942 .59587 L
.10071 .59997 L
.10144 .59984 L
.1021 .60009 L
.10337 .60295 L
.10458 .60199 L
.10586 .60332 L
.10707 .60225 L
.10816 .60174 L
.10933 .60102 L
.11061 .5984 L
.11126 .59782 L
.11197 .59663 L
.11322 .59315 L
.11439 .59064 L
.11557 .5867 L
.11669 .58289 L
.11879 .57471 L
.1235 .54929 L
.14415 .40059 L
.16237 .23314 L
.17274 .15003 L
.17782 .11225 L
.18005 .09502 L
.18122 .08957 L
.18248 .07988 L
.18374 .08086 L
.18488 .07671 L
.18603 .07353 L
.18712 .07153 L
.192 .06148 L
.19692 .05415 L
.19762 .05261 L
.19827 .05192 L
.19895 .052 L
.1997 .05096 L
.20093 .04986 L
.20162 .04984 L
.20226 .04907 L
.20355 .04854 L
Mistroke
.20426 .04842 L
.20493 .04787 L
.20623 .04793 L
.20741 .04765 L
.2081 .04777 L
.20882 .04799 L
.21011 .04814 L
.21083 .04858 L
.21151 .04882 L
.21224 .04916 L
.21303 .04994 L
.21435 .05041 L
.2151 .05131 L
.21578 .05216 L
.21839 .05537 L
.21961 .05655 L
.22075 .05937 L
.22195 .06267 L
.22326 .06659 L
.22797 .0846 L
.23312 .10903 L
.24349 .16819 L
.262 .31752 L
.27296 .41281 L
.2833 .49085 L
.29257 .54058 L
.29511 .55471 L
.29578 .55447 L
.2965 .55822 L
.2978 .56553 L
.299 .56358 L
.3001 .56292 L
.30139 .5663 L
.30262 .56693 L
.30377 .56816 L
.30485 .56861 L
.30604 .56842 L
.30733 .56845 L
.3086 .56733 L
.30929 .5667 L
.30994 .56624 L
.31108 .56474 L
.31234 .56239 L
.31668 .55247 L
.31912 .5449 L
.32134 .53604 L
.33181 .48037 L
.34171 .41274 L
.36001 .26701 L
.36502 .2279 L
Mistroke
.36778 .20564 L
.36844 .20129 L
.36915 .19807 L
.37041 .18505 L
.37168 .17861 L
.37284 .174 L
.3755 .16239 L
.38015 .13508 L
.38506 .11187 L
.38764 .10161 L
.39037 .09244 L
.39276 .08583 L
.39403 .0829 L
.39539 .08017 L
.39664 .078 L
.39777 .07661 L
.39883 .07518 L
.4 .07436 L
.4013 .07378 L
.40197 .07334 L
.40269 .07305 L
.40397 .07279 L
.40518 .0728 L
.40586 .07299 L
.40661 .07289 L
.40739 .07335 L
.40811 .07388 L
.40878 .07394 L
.4095 .07456 L
.4108 .07577 L
.4134 .07875 L
.41575 .08257 L
.4185 .08836 L
.42103 .09499 L
.42571 .10994 L
.42834 .12137 L
.43074 .13434 L
.43981 .19335 L
.46046 .34466 L
.46968 .40522 L
.47949 .45307 L
.48515 .4769 L
.48781 .48613 L
.49026 .493 L
.49273 .49798 L
.4954 .50261 L
.49776 .50559 L
.49905 .50664 L
.50024 .50803 L
.50147 .50848 L
Mistroke
.50211 .50902 L
.5028 .50959 L
.50395 .50916 L
.50522 .50964 L
.50635 .50881 L
.50756 .50821 L
.5087 .50756 L
.50975 .50571 L
.51211 .5023 L
.51462 .49762 L
.51737 .49086 L
.51993 .48363 L
.52934 .4471 L
.53828 .40069 L
.54799 .34562 L
.55329 .31451 L
.55825 .28286 L
.56084 .27076 L
.56361 .2601 L
.5695 .23725 L
.5721 .22626 L
.57488 .2144 L
.57601 .2134 L
.57724 .20604 L
.57794 .20443 L
.57859 .20495 L
.57985 .2003 L
.58105 .19595 L
.58236 .19554 L
.58302 .19285 L
.58373 .19002 L
.585 .1888 L
.58573 .18802 L
.58651 .18547 L
.58725 .18329 L
.58794 .18265 L
.58923 .18179 L
.58989 .1802 L
.59061 .17848 L
.59129 .17779 L
.59193 .17777 L
.59315 .17657 L
.59445 .17416 L
.59519 .17427 L
.59587 .1747 L
.59712 .17271 L
.59826 .17171 L
.59957 .17303 L
.6008 .17041 L
.60191 .17146 L
Mistroke
.60313 .17245 L
.6044 .16957 L
.60558 .1731 L
.6067 .17248 L
.60771 .17004 L
.60888 .17457 L
.60998 .17375 L
.61118 .17152 L
.61245 .17666 L
.61354 .17632 L
.61474 .17744 L
.61721 .17913 L
.61991 .18156 L
.62246 .18479 L
.62483 .18873 L
.63002 .2005 L
.63928 .22846 L
.66015 .30342 L
.66927 .33611 L
.67891 .36992 L
.68395 .38407 L
.68949 .39506 L
.69923 .41408 L
.70456 .42273 L
.7061 .42476 L
.70755 .42665 L
.70886 .42786 L
.7096 .42834 L
.71028 .4286 L
.71143 .4291 L
.71266 .42934 L
.71337 .42929 L
.71402 .42904 L
.71529 .42904 L
.71652 .42845 L
.71788 .42764 L
.72061 .42549 L
.72325 .42278 L
.72565 .41947 L
.73105 .40944 L
.74077 .38483 L
.76154 .33648 L
.78071 .27341 L
.79936 .21958 L
.80877 .19849 L
.81009 .19576 L
.81135 .18838 L
.81204 .17806 L
.8128 .1701 L
.81348 .17872 L
Mistroke
.81412 .18191 L
.81539 .19227 L
.81655 .2026 L
.81913 .22885 L
.82401 .26804 L
.82529 .26953 L
.82601 .27041 L
.82667 .27182 L
.82795 .31485 L
.82916 .31469 L
.83025 .31727 L
.83127 .31622 L
.83238 .32057 L
.83356 .31778 L
.83474 .31497 L
.83585 .32211 L
.83707 .31646 L
.83838 .31821 L
.83969 .32103 L
.84091 .31372 L
.84161 .3174 L
.84225 .32075 L
.84298 .31987 L
.84368 .31438 L
.84435 .31265 L
.84507 .31673 L
.84635 .3168 L
.84706 .31154 L
.84773 .31118 L
.84846 .31523 L
.84925 .31601 L
.85052 .30852 L
.85125 .30988 L
.85192 .31275 L
.85314 .31199 L
.85445 .31289 L
.85574 .31209 L
.85695 .31288 L
.85803 .31255 L
.8592 .31244 L
.86043 .31271 L
.86159 .31227 L
.86223 .31286 L
.86292 .31275 L
.86414 .31214 L
.8653 .31262 L
.86653 .31205 L
.86758 .31257 L
.86874 .31194 L
.86943 .31194 L
Mistroke
.87009 .31212 L
.87134 .31178 L
.87413 .31078 L
.87655 .30958 L
.87919 .30796 L
.87987 .30715 L
.88062 .30707 L
.88132 .30795 L
.88196 .30876 L
.88318 .30904 L
.88448 .31001 L
.88588 .31077 L
.88666 .31132 L
.88739 .31148 L
.88807 .31223 L
.88882 .31278 L
.89012 .31369 L
.89133 .31461 L
.89263 .31506 L
.89373 .31487 L
.89495 .31139 L
.89627 .31034 L
.89701 .31036 L
.89769 .31006 L
.89895 .31745 L
.90027 .32464 L
.9015 .32612 L
.90284 .32752 L
.90401 .3287 L
.90526 .3297 L
.90638 .3304 L
.90762 .33105 L
.90874 .33151 L
.9098 .33193 L
.91043 .33189 L
.91113 .33183 L
.91234 .33171 L
.91302 .33162 L
.91375 .33159 L
.91506 .33287 L
.9157 .33255 L
.91639 .331 L
.91765 .33047 L
.91999 .32924 L
.92112 .32777 L
.92235 .32023 L
.92351 .3172 L
.92458 .32253 L
.92582 .31735 L
.92645 .31698 L
Mistroke
.92715 .32054 L
.92836 .32059 L
.92949 .31756 L
.93057 .323 L
.93172 .31942 L
.93269 .31863 L
.93376 .32401 L
.93491 .31989 L
.93614 .32174 L
.9373 .32417 L
.93835 .32048 L
.93948 .32393 L
.94052 .32243 L
.94166 .31964 L
.94287 .32321 L
.94392 .31891 L
.9449 .31883 L
.94597 .3255 L
.94713 .32499 L
.94837 .32785 L
.94906 .33252 L
.94971 .3334 L
.9509 .33235 L
.95216 .33239 L
.95341 .33241 L
.95458 .33216 L
.95562 .3321 L
.95676 .33189 L
.95798 .3315 L
.95911 .33211 L
.96036 .33297 L
.96105 .33481 L
.96169 .33481 L
.96297 .337 L
.96369 .33602 L
.96436 .33177 L
.96559 .3289 L
.96689 .32711 L
.97131 .31978 L
.97619 .30876 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`001`3oool3000000<0oooo00H0
00000?ooo`3oool0oooo0000003oool500000080oooo0P00003o0?ooo`D0oooo00070?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0o`3oool20?ooo`001`3oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0l`3oool000030?ooo`0000000000008000000P3oool30000
00@0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool02`3oool200000?@0oooo00080?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0?<0oooo00080?ooo`<000002@3oool2000000@0oooo0P000008
0?ooo`<000000`3oool00`000000oooo0?ooo`3c0?ooo`009P3oool01@000000oooo0?ooo`3oool0
00000?D0oooo000O0?ooo`<000000P3oool3000000<0oooo00<000000?ooo`3oool0l`3oool002@0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`3c0?ooo`00903oool3000000<0oooo
0P00003d0?ooo`00:P3oool200000?@0oooo000Z0?ooo`800000m03oool002X0oooo0P00003d0?oo
o`00:P3oool200000?@0oooo000Z0?ooo`800000:P3oool500000<D0oooo000Z0?ooo`800000:@3o
ool2000000<0oooo00<000000?ooo`3oool0``3oool002X0oooo0P00000X0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0`P3oool002X0oooo0P00000X0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0`P3oool002X0oooo0P00000X0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0`@3oool002X0oooo00<000000?ooo`0000009P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo0<40oooo000Z0?ooo`030000003oool0000002D0oooo0P00
00080?ooo`030000003oool0oooo02T0oooo0`00002E0?ooo`00:P3oool00`000000oooo0000000U
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09`3oool01@000000oooo0?ooo`3o
ool0000009@0oooo000Z0?ooo`<00000903oool2000000X0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0940oooo000Z0?ooo`030000003oool00000
02@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0T@3oool002X0oooo00<000000?ooo`000000903oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`2@0?ooo`002@3oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`000000
100000020?ooo`8000003P3oool00`000000oooo0000000T0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0900oooo
000:0?ooo`070000003oool0oooo0?ooo`000000oooo000000040?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0000002@0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0T03oool000L0oooo1@0000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`000000903oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`2@0?ooo`0000<0oooo0000000000000P0000020?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool02`3oool2000000030?ooo`000000oooo0240oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0S`3oool0
00P0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0oooo00@000000?ooo`3oool00000
8P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`2?0?ooo`002@3oool2000000T0oooo0P0000040?ooo`800000203o
ool3000000<0oooo00@000000?ooo`3oool000008P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`2?0?ooo`009P3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`2>0?ooo`007`3oool300000080oooo0`0000030?ooo`040000003oool0oooo00000280oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0SP3oool002@0oooo00<000000?ooo`0000000`3oool010000000oooo0?oo
o`00000R0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool08@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo08h0oooo000T0?ooo`<000000`3oool010000000oooo0?oo
o`00000R0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool08@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo08d0oooo000Z0?ooo`80000000<0oooo0000003oool0803o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`2=0?ooo`00:P3oool010000000oooo0?ooo`00000Q0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo08d0oooo000Z0?ooo`050000003oool0oooo0?ooo`000000803oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`2=0?ooo`00:P3oool01@000000oooo0?ooo`3oool000000200oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0S@3o
ool002X0oooo00D000000?ooo`3oool0oooo0000000P0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool07`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo08`0oooo000Z
0?ooo`050000003oool0oooo0?ooo`000000803oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`2<0?ooo`00:P3oool2
00000080oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo01l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`2<0?ooo`00:P3oool01@00
0000oooo0?ooo`3oool000000200oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0N
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0S03oool002X0oooo00D000000?oo
o`3oool0oooo0000000O0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool07P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo08`0oooo000Z0?ooo`050000003oool0oooo
0?ooo`0000007`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01d0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0V0?ooo`<00000<`3oool00`000000oooo0?ooo`0]
0?ooo`00:P3oool01@000000oooo0?ooo`3oool0000001l0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool09@3oool5
00000340oooo0P00000_0?ooo`00:P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`020?ooo`800000<03oool20000
02l0oooo000Z0?ooo`8000000`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0280
oooo0P0000060?ooo`030000003oool0oooo02d0oooo0P00000_0?ooo`00:P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool08P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo02`0oooo0P00000_0?ooo`00:P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool08@3oool2000000P0oooo00<0
00000?ooo`3oool0;03oool2000002l0oooo00070?ooo`@000000P3oool01P000000oooo0?ooo`3o
ool000000?ooo`D000000P3oool2000000h0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0[0?ooo`800000;`3oool000L0oooo00<000000?ooo`3oool0103oool00`000000oooo0000
00040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0P0?ooo`800000
2P3oool00`000000oooo0?ooo`0[0?ooo`800000;`3oool000P0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0:@3oool00`000000oooo
0000000_0?ooo`0000<0oooo0000000000000P0000040?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
7`3oool2000000`0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0000000_0?ooo`001`3o
ool010000000oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3oool2000000<0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool09`3oool010000000oooo0?ooo`00000_0?ooo`00203oool2000000X0oooo0P0000040?oo
o`8000003P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02L0oooo00@000000?oo
o`3oool00000;`3oool002@0oooo0`0000030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool06P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02`0oooo000V0?ooo`05
0000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0;03oool001l0oooo0`0000020?ooo`<000000`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0/0?ooo`00903oool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool0903oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02`0oooo
000T0?ooo`<000000`3oool2000000@0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0D0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0903oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo02`0oooo000Z0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01T0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool08P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02`0oooo000Z0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo02`0oooo000Z0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool08P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02`0oooo000Z0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo02`0oooo000Z0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02/0oooo000Z0?ooo`8000001@3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0:`3oool0
02X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0:`3oool002X0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`8000000`3oool4000000<0
oooo00<000000?ooo`3oool05`3oool010000000oooo0?ooo`3oool2000000@0oooo0P0000050?oo
o`<000000P3oool00`000000oooo0?ooo`0I0?ooo`040000003oool00000000000@0oooo0P000003
0?ooo`<000001P3oool00`000000oooo0?ooo`0I0?ooo`800000103oool2000000@0oooo0P000002
0?ooo`030000003oool0oooo0280oooo1@0000040?ooo`00:P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`000008
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool05`3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000K0?ooo`800000
0P3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3o
ool05`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool000000?ooo`02000002D0oooo00<000000?ooo`3oool0103oool002X0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00<0oooo00@000000?oo
o`3oool000002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01L0oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo0?ooo`060?ooo`D000000`3oool00`000000oooo0?oo
o`0H0?ooo`8000000P3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000H0oooo
00<000000?ooo`3oool05`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo
00@0oooo000Z0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`030?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0G0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool01P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo01P0oooo0P0000020?ooo`030000003o
ool0oooo00H0oooo0`0000070?ooo`030000003oool0oooo01L0oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`040?ooo`8000000`3oool00`000000oooo0?ooo`0S0?ooo`030000
003oool0oooo00@0oooo000Z0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo0?ooo`0G0?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool01`3oool00`000000oooo000000040?ooo`030000003oool0oooo01P0oooo0P0000020?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0G0?oo
o`060000003oool0oooo0000003oool000001P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool0103oool002X0oooo0P0000060?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0103oool2000000X0oooo0P0000040?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool00P3oool2000000/0oooo0P0000040?ooo`030000003o
ool0oooo01P0oooo00@000000?ooo`00000000002P3oool3000000L0oooo00<000000?ooo`3oool0
5`3oool200000080oooo00<000000?ooo`3oool01@3oool2000000<0oooo00<000000?ooo`3oool0
8P3oool2000000H0oooo000Z0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02X0oooo000Z0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo02X0oooo000Z0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo02X0oooo000Z0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02X0
oooo000Z0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo02X0oooo000T0?oooo`00000000Z0?ooo`030000003oool0
oooo00D0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo00D0oooo00@0
00000?ooo`3oool000002`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0203oool2000000/0oooo00<000000?ooo`3oool02@3oool2000000X0oooo
00<000000?ooo`3oool02@3oool2000000X0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3oool3000000030?oo
o`000000000000L0000000<0oooo0000000000000`0000070?ooo`030000003oool0oooo00P0oooo
0P0000060?ooo`00:P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`L000002P3oool2000000D0oooo1000
00090?ooo`8000001P3oool002X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0D
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo00d0oooo1000000=0?ooo`030000003oool0oooo00<0oooo1`000005
0?ooo`030000003oool0oooo00H0oooo000Z0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`0N0?ooo`800000103oool00`000000oooo000000040000
00@0oooo00<000000?ooo`3oool01`3oool002X0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo0200oooo0P0000020?ooo`8000001P3oool01@000000
oooo0?ooo`3oool0000000T0oooo000Z0?ooo`8000001`3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo0240oooo100000070?ooo`D000002@3oool002X0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0
203oool002X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo03/0oooo000Z0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0k0?ooo`00:P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0?03oool002X0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo03`0oooo000Z0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0m0?ooo`00:P3oool2000000P0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01h0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0m0?ooo`00:P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0?P3oool002X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03h0oooo000Z0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0o0?ooo`00
:P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
?`3oool002X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo01`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo0400oooo000Z0?ooo`800000203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo0400oooo000Z0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0L0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`100?ooo`00:P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0@@3oool000L0oooo100000020?ooo`060000003oool0oooo0?ooo`00
0000oooo1@0000020?ooo`8000003P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0@@3oool000L0oooo00<000000?ooo`3oool0103oool00`000000
oooo000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`110?oo
o`00203oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo0480oooo00090?ooo`030000003oool0oooo0080
oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool02`3oool2000000T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`120?oo
o`001`3oool010000000oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool07@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0@P3oool000P0oooo0P00000:
0?ooo`800000103oool2000000P0oooo0`0000030?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`130?ooo`009P3oool01@000000oooo0?ooo`3oool0
000000/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`130?ooo`007`3oool30000
0080oooo0`0000030?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo02P0oooo0P0000020?ooo`800000AP3oool002@0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0Y0?ooo`@00000A`3oool002@0oooo
0`0000030?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo07@0oooo000Z0?ooo`8000002P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0P0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0M03oool002X0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01l0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0M@3oool002X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0P0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0M@3oool002X0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0M@3oool002X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo0200oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0Q0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0M@3oool002X0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0M@3o
ool002X0oooo0P00000;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`1f0?ooo`00:P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
0280oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1f0?ooo`00:P3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool08@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`1f0?ooo`00:P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02<0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1f0?ooo`00:P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`1g0?ooo`00:P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool08`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`1g0?ooo`00:P3oool2000000/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo07L0oooo000Z0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo07P0oooo000Z0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo07P0oooo000Z0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0S0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo07P0oooo00090?ooo`<0000000<0oooo0000003oool00P3oool00`000000oooo00000004
00000080oooo0P00000>0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo07T0oooo000:0?ooo`070000003oool0oooo
0?ooo`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09`3oool200000080oooo
00<000000?ooo`3oool0N@3oool000L0oooo1@0000030?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0Y0?ooo`<00000O03oool000L0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`0;0?ooo`800000303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2X0?ooo`00203oool00`000000oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0:P0oooo00090?ooo`8000002@3oool2000000@0oooo0P0000080?ooo`<000000`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0:P0oooo000V0?ooo`050000003oool0oooo0?ooo`00
00003@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`2X0?ooo`007`3oool300000080oooo0`0000030?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0Z@3oool002@0oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:T0oooo000T0?ooo`<000000`3oool2
000000d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0Z@3oool002X0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`2Y0?ooo`00:P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:T0
oooo000Z0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0ZP3oool002X0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`2Z0?ooo`00:P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0:X0oooo000Z0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0Y0?ooo`050000003oool0oooo0?ooo`000000[@3oool0
02X0oooo0P00000>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0:@3oool20000
0080oooo00<000000?ooo`3oool0Z`3oool002X0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo02X0oooo0`00002^0?ooo`00:P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0g03oool002X0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0=`0oooo000Z
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3L
0?ooo`00:P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0g03oool002X0oooo0P00000@0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0g03oool002X0oooo00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3oool000000=l0
oooo000Z0?ooo`030000003oool0oooo00l0oooo0P0000020?ooo`030000003oool0oooo0=d0oooo
00070?ooo`<000000`3oool01P000000oooo0?ooo`3oool000000?ooo`D000000P3oool2000000h0
oooo00<000000?ooo`3oool0403oool010000000oooo00000000003O0?ooo`001`3oool010000000
oooo0?ooo`0000030?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04@3oool200000>00oooo00070?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3c0?ooo`001`3oool3
000000@0oooo00<000000?ooo`000000103oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool02`3oool200000?@0oooo00080?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0?<0oooo00080?ooo`<000002@3oool2000000@0oooo0P00
00080?ooo`<000000`3oool00`000000oooo0?ooo`3c0?ooo`009P3oool00`000000oooo0?ooo`3g
0?ooo`007`3oool300000080oooo0`00003i0?ooo`00903oool00`000000oooo0000003i0?ooo`00
903oool300000?T0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.176385, -6.96405, \
0.00418603, 7.87172}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[22]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
Saveable->False,
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Boundary Value Problems",
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:2"->{
    Cell[1843, 57, 45, 1, 61, "Section",
      CellTags->"c:2"]},
  "c:3"->{
    Cell[1913, 62, 73, 1, 36, "Subsection",
      CellTags->{"c:3", "b:9.0", "ndsg:3.1.0"}]},
  "b:9.0"->{
    Cell[1913, 62, 73, 1, 36, "Subsection",
      CellTags->{"c:3", "b:9.0", "ndsg:3.1.0"}]},
  "ndsg:3.1.0"->{
    Cell[1913, 62, 73, 1, 36, "Subsection",
      CellTags->{"c:3", "b:9.0", "ndsg:3.1.0"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:2", 223248, 5490},
  {"c:3", 223325, 5493},
  {"b:9.0", 223432, 5496},
  {"ndsg:3.1.0", 223544, 5499}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 42, 0, 88, "Chapter"],

Cell[CellGroupData[{
Cell[1843, 57, 45, 1, 61, "Section",
  CellTags->"c:2"],

Cell[CellGroupData[{
Cell[1913, 62, 73, 1, 36, "Subsection",
  CellTags->{"c:3", "b:9.0", "ndsg:3.1.0"}],
Cell[1989, 65, 616, 14, 68, "Text"],
Cell[2608, 81, 39, 0, 22, "Text"],
Cell[2650, 83, 264, 7, 29, "NumberedEquation"],
Cell[2917, 92, 636, 22, 36, "Text"],
Cell[3556, 116, 149, 2, 28, "NumberedEquation"],
Cell[3708, 120, 851, 26, 22, "Text"],
Cell[4562, 148, 364, 9, 31, "NumberedEquation"],
Cell[4929, 159, 21, 0, 22, "Text"],
Cell[4953, 161, 2147, 49, 97, "DisplayMath"],
Cell[7103, 212, 610, 18, 38, "Text"],
Cell[7716, 232, 473, 11, 79, "NumberedEquation"],
Cell[8192, 245, 434, 10, 36, "Text"],
Cell[8629, 257, 334, 11, 36, "Text"],
Cell[8966, 270, 503, 12, 31, "DisplayMath"],
Cell[9472, 284, 56, 0, 22, "Text"],
Cell[9531, 286, 398, 9, 31, "DisplayMath"],
Cell[9932, 297, 31, 0, 22, "Text"],
Cell[9966, 299, 474, 12, 33, "DisplayMath"],
Cell[10443, 313, 240, 8, 25, "Text"],
Cell[10686, 323, 469, 11, 32, "NumberedEquation"],
Cell[11158, 336, 869, 28, 93, "Text"],
Cell[12030, 366, 325, 9, 42, "Text"],
Cell[12358, 377, 4267, 131, 147, "Text"],
Cell[16628, 510, 421, 9, 35, "DisplayMath"],
Cell[17052, 521, 1045, 27, 145, "Text"],
Cell[18100, 550, 106, 2, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[18231, 556, 207, 5, 49, "Input"],
Cell[18441, 563, 249, 7, 27, "Output"]
}, Open  ]],
Cell[18705, 573, 57, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[18787, 577, 101, 2, 29, "Input"],
Cell[18891, 581, 22400, 537, 184, 4440, 310, "GraphicsData", "PostScript", \
"Graphics"],
Cell[41294, 1120, 154, 4, 27, "Output"]
}, Open  ]],
Cell[41463, 1127, 248, 7, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[41736, 1138, 730, 13, 209, "Input"],
Cell[42469, 1153, 437, 12, 46, "Output"]
}, Open  ]],
Cell[42921, 1168, 169, 5, 42, "Text"],
Cell[43093, 1175, 95, 2, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[43213, 1181, 83, 2, 29, "Input"],
Cell[43299, 1185, 85, 2, 27, "Output"]
}, Open  ]],
Cell[43399, 1190, 357, 10, 59, "Text"],
Cell[43759, 1202, 97, 2, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[43881, 1208, 107, 2, 29, "Input"],
Cell[43991, 1212, 168, 3, 46, "Output"]
}, Open  ]],
Cell[44174, 1218, 253, 7, 42, "Text"],
Cell[44430, 1227, 77, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[44532, 1231, 175, 3, 49, "Input"],
Cell[44710, 1236, 496, 8, 95, "Message"],
Cell[45209, 1246, 287, 9, 27, "Output"]
}, Open  ]],
Cell[45511, 1258, 117, 3, 25, "Text"],
Cell[45631, 1263, 152, 3, 42, "Text"],
Cell[45786, 1268, 207, 5, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[46018, 1277, 241, 6, 69, "Input"],
Cell[46262, 1285, 89, 2, 27, "Output"]
}, Open  ]],
Cell[46366, 1290, 183, 4, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[46574, 1298, 259, 6, 69, "Input"],
Cell[46836, 1306, 496, 8, 95, "Message"],
Cell[47335, 1316, 159, 4, 27, "Output"]
}, Open  ]],
Cell[47509, 1323, 191, 4, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[47725, 1331, 522, 11, 129, "Input"],
Cell[48250, 1344, 21873, 613, 184, 6646, 420, "GraphicsData", "PostScript", \
"Graphics"],
Cell[70126, 1959, 155, 4, 27, "Output"]
}, Open  ]],
Cell[70296, 1966, 481, 15, 61, "Text"],
Cell[70780, 1983, 1152, 31, 224, "DefinitionBox3Col"],
Cell[71935, 2016, 134, 6, 17, "Caption"],
Cell[72072, 2024, 124, 4, 25, "Text"],
Cell[72199, 2030, 1009, 27, 214, "DefinitionBox3Col"],
Cell[73211, 2059, 153, 6, 17, "Caption"],
Cell[73367, 2067, 193, 5, 42, "Text"],
Cell[73563, 2074, 160, 5, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[73748, 2083, 258, 5, 49, "Input"],
Cell[74009, 2090, 105, 2, 30, "Output"]
}, Open  ]],
Cell[74129, 2095, 124, 4, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[74278, 2103, 322, 7, 89, "Input"],
Cell[74603, 2112, 54808, 1071, 184, 7090, 477, "GraphicsData", "PostScript", \
"Graphics"],
Cell[129414, 3185, 155, 4, 27, "Output"]
}, Open  ]],
Cell[129584, 3192, 123, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[129732, 3199, 409, 9, 109, "Input"],
Cell[130144, 3210, 45584, 1088, 184, 10080, 644, "GraphicsData", \
"PostScript", "Graphics"],
Cell[175731, 4300, 155, 4, 25, "Output"]
}, Open  ]],
Cell[175901, 4307, 399, 11, 52, "Text"],
Cell[176303, 4320, 239, 7, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[176567, 4331, 473, 10, 90, "Input"],
Cell[177043, 4343, 45301, 1116, 184, 10808, 685, "GraphicsData", \
"PostScript", "Graphics"],
Cell[222347, 5461, 155, 4, 25, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

