(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2937898,      77462]*)
(*NotebookOutlinePosition[   3096926,      81666]*)
(*  CellTagsIndexPosition[   3091734,      81494]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["DSolve", "Title"],

Cell[CellGroupData[{

Cell["Overview", "Chapter",
  CellTags->{"c:1", "i:2"}],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->{"c:2", "b:0.0"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox[ButtonBox["DSolve",
    ButtonData:>"DSolve",
    ButtonStyle->"RefGuideLinkText"], "MR"],
  " finds ",
  StyleBox["symbolic solutions",
    FontSlant->"Italic"],
  " to differential equations. It can handle the following types of \
equations:"
}], "Text",
  CellTags->"b:0.0"],

Cell[TextData[{
  StyleBox["Ordinary Differential Equations ",
    FontSlant->"Italic"],
  StyleBox["(ODEs)",
    FontVariations->{"CompatibilityType"->0}],
  ", in which there is a single independent variable ",
  StyleBox["t",
    FontSlant->"Italic"],
  " and one or more dependent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)],
    FontSlant->"Italic"],
  StyleBox["(", "MR"],
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox[")", "MR"],
  ". ",
  StyleBox["DSolve", "MR"],
  " is equipped with a wide variety of techniques for solving single ODEs as \
well as systems of ODEs."
}], "BulletedList",
  CellTags->"b:0.0"],

Cell[TextData[{
  StyleBox["Partial Differential Equations",
    FontSlant->"Italic"],
  " (PDEs), in which there are two or more independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["t",
    FontSlant->"Italic"],
  " and one dependent variable ",
  StyleBox["u",
    FontSlant->"Italic"],
  StyleBox["(", "MR"],
  StyleBox["x, t",
    FontSlant->"Italic"],
  StyleBox[")", "MR"],
  ". Finding exact symbolic solutions of PDEs is a difficult problem, but ",
  StyleBox["DSolve", "MR",
    FontSize->10],
  " can solve most first-order PDEs and a limited number of the second-order \
PDEs found in standard reference books."
}], "BulletedList",
  CellTags->"b:0.0"],

Cell[TextData[{
  StyleBox["Differential-Algebraic Equations",
    FontSlant->"Italic"],
  " (DAEs), in which some members of the system are differential equations \
and the others are purely algebraic, having no derivatives in them. As with \
PDEs, it is difficult to find exact solutions to DAEs, but ",
  StyleBox["DSolve", "MR"],
  " can solve many examples of such systems that occur in applications."
}], "BulletedList",
  CellTags->"b:0.0"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["DSolve",
              "MR"], 
            StyleBox["[",
              "MR"], 
            RowBox[{
              StyleBox["eqn",
                "TI"], 
              StyleBox[",",
                "MR"], 
              StyleBox[" ",
                "TR"], 
              RowBox[{
                StyleBox["y",
                  "TI"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["x",
                  "TI"], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox[",",
                "MR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["x",
                "TI"]}], 
            StyleBox["]",
              "MR"]}], 
          RowBox[{
            StyleBox["solve",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["a",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["differential",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["equation",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["for",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            RowBox[{
              StyleBox["y",
                "TR",
                FontSlant->"Italic"], 
              StyleBox["[",
                "MR"], 
              StyleBox["x",
                "TR",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}]}]},
        {
          RowBox[{
            StyleBox["DSolve",
              "MR"], 
            StyleBox["[",
              "MR"], 
            RowBox[{
              RowBox[{
                StyleBox["{",
                  "MR",
                  FontSlant->"Italic"], 
                RowBox[{
                  SubscriptBox[
                    StyleBox["eqn",
                      "TI",
                      FontSlant->"Italic"], "1"], 
                  StyleBox[",",
                    "MR",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    "TR",
                    FontSlant->"Italic"], 
                  SubscriptBox[
                    StyleBox["eqn",
                      "TI",
                      FontSlant->"Italic"], "2"], 
                  StyleBox[",",
                    "TI",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    "TI",
                    FontSlant->"Italic"], 
                  StyleBox["\[Ellipsis]",
                    "TI",
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                "MR"], 
              StyleBox[" ",
                "MR",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["{",
                  "MR",
                  FontSlant->"Italic"], 
                RowBox[{
                  RowBox[{
                    SubscriptBox[
                      StyleBox["y",
                        "TI",
                        FontSlant->"Italic"], "1"], 
                    StyleBox["[",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox["x",
                      "TI",
                      FontSlant->"Italic"], 
                    StyleBox["]",
                      "MR",
                      FontSlant->"Italic"]}], 
                  StyleBox[",",
                    "MR",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    "TR",
                    FontSlant->"Italic"], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["y",
                        "TI",
                        FontSlant->"Italic"], "2"], 
                    StyleBox["[",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox["x",
                      "TI",
                      FontSlant->"Italic"], 
                    StyleBox["]",
                      "MR",
                      FontSlant->"Italic"]}], 
                  StyleBox[",",
                    "MR",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    "MR",
                    FontSlant->"Italic"], 
                  StyleBox["\[Ellipsis]",
                    "TI",
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                "MR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["x",
                "TI",
                FontSlant->"Italic"]}], 
            StyleBox["]",
              "MR"]}], 
          RowBox[{
            StyleBox["solve",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["a",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["system",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["of",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["differential",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["equations",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["for",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            RowBox[{
              SubscriptBox[
                StyleBox["y",
                  "TR",
                  FontSlant->"Italic"], 
                StyleBox["i",
                  "TR",
                  FontSlant->"Italic"]], 
              StyleBox["[",
                "MR"], 
              StyleBox["x",
                "TR",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}]}]}
        }]], "DefinitionBox",
  CellTags->"b:0.0"],

Cell["\<\
Finding symbolic solutions to ordinary differential equations. \
\
\>", "Caption",
  CellTags->"b:0.0"],

Cell[TextData[{
  StyleBox["DSolve", "MR"],
  StyleBox[" returns results as lists of rules. This makes it possible to \
return multiple solutions to an equation. For a system of equations, possibly \
multiple solution sets are grouped together. You can use the rules to \
substitute the solutions into other calculations.", "TR"]
}], "Text",
  CellTags->"b:0.0"],

Cell[TextData[{
  "This finds the ",
  StyleBox["general solution",
    FontSlant->"Italic"],
  " for the given ODE. A rule for the function that satisfies the equation is \
returned. "
}], "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(y'\)[x] \[Equal] y[x]}, \ y[x], \ x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \({{y[x] \[Rule] \[ExponentialE]\^x\ C[1]}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell[TextData[{
  "You can pick out a specific solution by using ",
  StyleBox["/.", "MR"],
  " (",
  StyleBox["ReplaceAll", "MR"],
  ")."
}], "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x] /. DSolve[{\(y'\)[x] \[Equal] y[x]}, \ y[x], \ x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \({\[ExponentialE]\^x\ C[1]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell[TextData[{
  "A general solution contains arbitrary parameters ",
  StyleBox["C[", "MR"],
  StyleBox["i",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " which can be varied to produce particular solutions for the equation. \
When an adequate number of ",
  StyleBox["initial conditions",
    FontSlant->"Italic"],
  " are specified, ",
  StyleBox["DSolve", "MR"],
  StyleBox[" returns particular solutions to the given equations.", "TR"]
}], "Text",
  CellTags->"b:0.0"],

Cell[TextData[{
  "Here, the initial condition ",
  StyleBox["y[0]", "MR"],
  StyleBox[" ", "TR"],
  StyleBox["==", "MR"],
  StyleBox[" ", "TR"],
  StyleBox["1", "MR"],
  " is specified, and ",
  StyleBox["DSolve", "MR"],
  StyleBox[" returns a particular solution for the problem.", "TR"]
}], "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[{\(y'\)[x] \[Equal] y[x], \ y[0] \[Equal] 1}, \ y[x], \ 
        x]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \({{y[x] \[Rule] \[ExponentialE]\^x}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell[TextData[{
  "This plots the solution. ",
  StyleBox["ReplaceAll", "MR"],
  " (",
  StyleBox["/.", "MR"],
  ") is used in the ",
  StyleBox["Plot", "MR"],
  StyleBox[" command", "TR"],
  " to substitute the solution for ",
  StyleBox["y[", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Plain"],
  StyleBox["]", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[y[x] /. sol, {x, \(-3\), 2}, \ 
      PlotStyle\  \[Rule] \ {Red}]; \)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:0.0"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.0147151 0.0796589 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.21429 .00222 -6 -9 ]
[.21429 .00222 6 0 ]
[.40476 .00222 -6 -9 ]
[.40476 .00222 6 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.58274 .09437 -6 -4.5 ]
[.58274 .09437 0 4.5 ]
[.58274 .17403 -6 -4.5 ]
[.58274 .17403 0 4.5 ]
[.58274 .25369 -6 -4.5 ]
[.58274 .25369 0 4.5 ]
[.58274 .33335 -6 -4.5 ]
[.58274 .33335 0 4.5 ]
[.58274 .41301 -6 -4.5 ]
[.58274 .41301 0 4.5 ]
[.58274 .49267 -6 -4.5 ]
[.58274 .49267 0 4.5 ]
[.58274 .57233 -6 -4.5 ]
[.58274 .57233 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-3)] .02381 .00222 0 1 Mshowa
.21429 .01472 m
.21429 .02097 L
s
[(-2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(-1)] .40476 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(1)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.0619 .01472 m
.0619 .01847 L
s
.1 .01472 m
.1 .01847 L
s
.1381 .01472 m
.1381 .01847 L
s
.17619 .01472 m
.17619 .01847 L
s
.25238 .01472 m
.25238 .01847 L
s
.29048 .01472 m
.29048 .01847 L
s
.32857 .01472 m
.32857 .01847 L
s
.36667 .01472 m
.36667 .01847 L
s
.44286 .01472 m
.44286 .01847 L
s
.48095 .01472 m
.48095 .01847 L
s
.51905 .01472 m
.51905 .01847 L
s
.55714 .01472 m
.55714 .01847 L
s
.63333 .01472 m
.63333 .01847 L
s
.67143 .01472 m
.67143 .01847 L
s
.70952 .01472 m
.70952 .01847 L
s
.74762 .01472 m
.74762 .01847 L
s
.82381 .01472 m
.82381 .01847 L
s
.8619 .01472 m
.8619 .01847 L
s
.9 .01472 m
.9 .01847 L
s
.9381 .01472 m
.9381 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.59524 .09437 m
.60149 .09437 L
s
[(1)] .58274 .09437 1 0 Mshowa
.59524 .17403 m
.60149 .17403 L
s
[(2)] .58274 .17403 1 0 Mshowa
.59524 .25369 m
.60149 .25369 L
s
[(3)] .58274 .25369 1 0 Mshowa
.59524 .33335 m
.60149 .33335 L
s
[(4)] .58274 .33335 1 0 Mshowa
.59524 .41301 m
.60149 .41301 L
s
[(5)] .58274 .41301 1 0 Mshowa
.59524 .49267 m
.60149 .49267 L
s
[(6)] .58274 .49267 1 0 Mshowa
.59524 .57233 m
.60149 .57233 L
s
[(7)] .58274 .57233 1 0 Mshowa
.125 Mabswid
.59524 .03065 m
.59899 .03065 L
s
.59524 .04658 m
.59899 .04658 L
s
.59524 .06251 m
.59899 .06251 L
s
.59524 .07844 m
.59899 .07844 L
s
.59524 .11031 m
.59899 .11031 L
s
.59524 .12624 m
.59899 .12624 L
s
.59524 .14217 m
.59899 .14217 L
s
.59524 .1581 m
.59899 .1581 L
s
.59524 .18996 m
.59899 .18996 L
s
.59524 .2059 m
.59899 .2059 L
s
.59524 .22183 m
.59899 .22183 L
s
.59524 .23776 m
.59899 .23776 L
s
.59524 .26962 m
.59899 .26962 L
s
.59524 .28556 m
.59899 .28556 L
s
.59524 .30149 m
.59899 .30149 L
s
.59524 .31742 m
.59899 .31742 L
s
.59524 .34928 m
.59899 .34928 L
s
.59524 .36521 m
.59899 .36521 L
s
.59524 .38115 m
.59899 .38115 L
s
.59524 .39708 m
.59899 .39708 L
s
.59524 .42894 m
.59899 .42894 L
s
.59524 .44487 m
.59899 .44487 L
s
.59524 .4608 m
.59899 .4608 L
s
.59524 .47674 m
.59899 .47674 L
s
.59524 .5086 m
.59899 .5086 L
s
.59524 .52453 m
.59899 .52453 L
s
.59524 .54046 m
.59899 .54046 L
s
.59524 .5564 m
.59899 .5564 L
s
.59524 .58826 m
.59899 .58826 L
s
.59524 .60419 m
.59899 .60419 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01868 m
.06244 .01957 L
.10458 .02078 L
.14415 .02218 L
.18221 .02382 L
.22272 .02598 L
.26171 .02854 L
.30316 .0319 L
.34309 .03591 L
.3815 .04065 L
.42237 .04686 L
.46172 .05423 L
.49955 .06292 L
.53984 .07427 L
.57861 .08772 L
.61984 .10535 L
.65954 .12636 L
.69774 .15115 L
.73838 .18361 L
.77751 .22212 L
.81909 .27273 L
.85916 .33313 L
.89771 .40456 L
.93871 .49819 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`003`3oool200000340oooo1000000`0?ooo`D00000H03oool5000002l0oooo1000000=0?oo
o`003P3oool010000000oooo0?ooo`00000`0?ooo`030000003oool0oooo03<0oooo00<000000?oo
o`3oool0HP3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00h0oooo000@0?ooo`03
0000003oool0oooo0300oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`1R0?ooo`03
0000003oool0oooo0300oooo00<000000?ooo`3oool03@3oool000P0oooo100000050?ooo`030000
003oool0oooo02P0oooo100000040?ooo`030000003oool0oooo02T0oooo100000040?ooo`030000
003oool0oooo0680oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0<0?ooo`003P3o
ool010000000oooo0?ooo`00000`0?ooo`040000003oool0oooo00000380oooo00<000000?ooo`3o
ool0HP3oool00`000000oooo0?ooo`0_0?ooo`040000003oool0oooo000000d0oooo000?0?ooo`80
0000<P3oool200000380oooo0P00001S0?ooo`800000<P3oool2000000h0oooo003o0?ooob40oooo
002Y0?ooo`030000003oool0oooo07@0oooo002Y0?ooo`030000003oool0oooo07@0oooo002Y0?oo
o`030000003oool0oooo07@0oooo002Y0?ooo`030000003oool0oooo07@0oooo00070?ooool00000
4P0000080?ooo`003@3ooolA0?l000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00`0oooo000=0?ooo`030000003oool0oooo00h0oooo803o0003
0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0303oool003h0oooo2`3o001P0?oo
o`030000003oool0oooo07@0oooo00190?ooo`/0o`00E@3oool2000007D0oooo001D0?ooo`/0o`00
BP3oool00`000000oooo0?ooo`1d0?ooo`00G`3oool;0?l003l0oooo00<000000?ooo`3oool0M03o
ool006X0oooo203o000g0?ooo`030000003oool0oooo07@0oooo001b0?ooo`H0o`00<@3oool00`00
0000oooo0?ooo`1d0?ooo`00N03oool50?l002`0oooo0P00001e0?ooo`00O@3oool60?l002H0oooo
00<000000?ooo`3oool0M03oool008<0oooo1@3o000Q0?ooo`030000003oool0oooo07@0oooo0028
0?ooo`D0o`00703oool00`000000oooo0?ooo`1d0?ooo`00S@3oool40?l001P0oooo0P00001e0?oo
o`00T@3oool40?l001@0oooo00<000000?ooo`3oool0M03oool009D0oooo103o000@0?ooo`030000
003oool0oooo07@0oooo002I0?ooo`<0o`003@3oool00`000000oooo0?ooo`1d0?ooo`00W03oool2
0?l000/0oooo0P00001e0?ooo`00WP3oool30?l000P0oooo00<000000?ooo`3oool0M03oool00:40
oooo0P3o00060?ooo`030000003oool0oooo07@0oooo002Q0?ooo`8000000`3o00030?ooo`030000
003oool0oooo07@0oooo002S0?ooo`030000003oool0oooo0080o`0000<0oooo0000003oool0M@3o
ool00:<0oooo00<000000?ooo`3oool00P3oool20?l000800000M03oool00:<0oooo00<000000?oo
o`3oool00`3oool010000000o`000?l0003o001c0?ooo`00X`3oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo0?ooo`80o`00L@3oool00:80oooo0P0000050?ooo`030000003oool0oooo
00<0oooo0`3o001^0?ooo`00Z@3oool2000000L0oooo0P3o001/0?ooo`00Z@3oool00`000000oooo
0?ooo`080?ooo`80o`00JP3oool00:T0oooo00<000000?ooo`3oool02P3oool20?l006P0oooo002Y
0?ooo`030000003oool0oooo00`0oooo0P3o001V0?ooo`00Z@3oool2000000l0oooo0P3o001T0?oo
o`00Z@3oool00`000000oooo0?ooo`0@0?ooo`80o`00HP3oool00:T0oooo00<000000?ooo`3oool0
4P3oool00`3o0000oooo0?ooo`1O0?ooo`00Z@3oool00`000000oooo0?ooo`0C0?ooo`030?l0003o
ool0oooo05h0oooo002Y0?ooo`030000003oool0oooo01@0oooo0P3o001N0?ooo`00Z@3oool20000
01L0oooo00<0o`000?ooo`3oool0F`3oool00:T0oooo00<000000?ooo`3oool05`3oool20?l005/0
oooo002Y0?ooo`030000003oool0oooo01T0oooo00<0o`000?ooo`3oool0F03oool00:T0oooo00<0
00000?ooo`3oool06P3oool00`3o0000oooo0?ooo`1G0?ooo`00Z@3oool2000001`0oooo0P3o001G
0?ooo`00Z@3oool00`000000oooo0?ooo`0M0?ooo`030?l0003oool0oooo05@0oooo002Q0?ooo`@0
0000103oool00`000000oooo0?ooo`0N0?ooo`030?l0003oool0oooo05<0oooo002Q0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool07`3oool00`3o0000oooo0?ooo`1B0?ooo`00XP3o
ool00`000000oooo0?ooo`040?ooo`<00000803oool00`3o0000oooo0?ooo`1A0?ooo`00X`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0240oooo0P3o001A0?ooo`00X@3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo02<0oooo00<0o`000?ooo`3oool0CP3oool0
0:80oooo0P0000050?ooo`030000003oool0oooo02@0oooo00<0o`000?ooo`3oool0C@3oool00:T0
oooo00<000000?ooo`3oool09@3oool00`3o0000oooo0?ooo`1<0?ooo`00Z@3oool2000002L0oooo
00<0o`000?ooo`3oool0B`3oool00:T0oooo00<000000?ooo`3oool09`3oool00`3o0000oooo0?oo
o`1:0?ooo`00Z@3oool00`000000oooo0?ooo`0X0?ooo`030?l0003oool0oooo04T0oooo002Y0?oo
o`030000003oool0oooo02T0oooo00<0o`000?ooo`3oool0B03oool00:T0oooo0P00000[0?ooo`03
0?l0003oool0oooo04L0oooo002Y0?ooo`030000003oool0oooo02/0oooo00<0o`000?ooo`3oool0
AP3oool00:T0oooo00<000000?ooo`3oool0;03oool00`3o0000oooo0?ooo`150?ooo`00Z@3oool0
0`000000oooo0?ooo`0]0?ooo`030?l0003oool0oooo04@0oooo002Y0?ooo`800000;`3oool00`3o
0000oooo0?ooo`130?ooo`00Z@3oool00`000000oooo0?ooo`0_0?ooo`030?l0003oool0oooo0480
oooo002Y0?ooo`030000003oool0oooo0300oooo00<0o`000?ooo`3oool0@@3oool00:T0oooo00<0
00000?ooo`3oool0<@3oool00`3o0000oooo0?ooo`100?ooo`00Z@3oool00`000000oooo0?ooo`0b
0?ooo`030?l0003oool0oooo03l0oooo002Y0?ooo`800000<`3oool00`3o0000oooo0?ooo`0o0?oo
o`00Z@3oool00`000000oooo0?ooo`0c0?ooo`030?l0003oool0oooo03h0oooo002R0?ooo`800000
1@3oool00`000000oooo0?ooo`0d0?ooo`030?l0003oool0oooo03d0oooo002Q0?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool0=@3oool00`3o0000oooo0?ooo`0l0?ooo`00X`3o
ool00`000000oooo0?ooo`030?ooo`<00000=P3oool00`3o0000oooo0?ooo`0k0?ooo`00Y03oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo03L0oooo00<0o`000?ooo`3oool0>P3oool0
0:40oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0g0?ooo`030?l0003oool0
oooo03X0oooo002R0?ooo`8000001@3oool00`000000oooo0?ooo`0h0?ooo`030?l0003oool0oooo
03T0oooo002Y0?ooo`800000>P3oool00`3o0000oooo0?ooo`0h0?ooo`00Z@3oool00`000000oooo
0?ooo`0j0?ooo`030?l0003oool0oooo03L0oooo002Y0?ooo`030000003oool0oooo03/0oooo00<0
o`000?ooo`3oool0=P3oool00:T0oooo00<000000?ooo`3oool0>`3oool00`3o0000oooo0?ooo`0f
0?ooo`00Z@3oool00`000000oooo0?ooo`0l0?ooo`030?l0003oool0oooo03D0oooo002Y0?ooo`80
0000?P3oool00`3o0000oooo0?ooo`0d0?ooo`00Z@3oool00`000000oooo0?ooo`0m0?ooo`030?l0
003oool0oooo03@0oooo002Y0?ooo`030000003oool0oooo03h0oooo00<0o`000?ooo`3oool0<`3o
ool00:T0oooo00<000000?ooo`3oool0?`3oool00`3o0000oooo0?ooo`0b0?ooo`00Z@3oool20000
0400oooo00<0o`000?ooo`3oool0<P3oool00:T0oooo00<000000?ooo`3oool0@03oool00`3o0000
oooo0?ooo`0a0?ooo`00Z@3oool00`000000oooo0?ooo`100?ooo`030?l0003oool0oooo0340oooo
002Y0?ooo`030000003oool0oooo0440oooo00<0o`000?ooo`3oool0<03oool00:T0oooo00<00000
0?ooo`3oool0@P3oool00`3o0000oooo0?ooo`0_0?ooo`00Z@3oool2000004<0oooo00<0o`000?oo
o`3oool0;`3oool00:T0oooo00<000000?ooo`3oool0@`3oool00`3o0000oooo0?ooo`0^0?ooo`00
X`3oool3000000<0oooo00<000000?ooo`3oool0A03oool00`3o0000oooo0?ooo`0]0?ooo`00Y03o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04@0oooo00<0o`000?ooo`3oool0;@3o
ool00:40oooo1@0000030?ooo`<00000A@3oool00`3o0000oooo0?ooo`0/0?ooo`00X@3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo04H0oooo00<0o`000?ooo`3oool0:`3oool0
0:80oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`160?ooo`030?l0003oool0oooo
02/0oooo002S0?ooo`800000103oool00`000000oooo0?ooo`170?ooo`030?l0003oool0oooo02X0
oooo002Y0?ooo`800000B03oool00`3o0000oooo0?ooo`0Z0?ooo`00Z@3oool00`000000oooo0?oo
o`180?ooo`030?l0003oool0oooo02T0oooo002Y0?ooo`030000003oool0oooo04P0oooo00<0o`00
0?ooo`3oool0:@3oool00:T0oooo00<000000?ooo`3oool0B@3oool00`3o0000oooo0?ooo`0X0?oo
o`00Z@3oool00`000000oooo0?ooo`190?ooo`030?l0003oool0oooo02P0oooo002Y0?ooo`800000
B`3oool00`3o0000oooo0?ooo`0W0?ooo`00Z@3oool00`000000oooo0?ooo`1:0?ooo`030?l0003o
ool0oooo02L0oooo002Y0?ooo`030000003oool0oooo04/0oooo00<0o`000?ooo`3oool09P3oool0
0:T0oooo00<000000?ooo`3oool0B`3oool00`3o0000oooo0?ooo`0V0?ooo`00Z@3oool2000004d0
oooo00<0o`000?ooo`3oool09@3oool00:T0oooo00<000000?ooo`3oool0C03oool00`3o0000oooo
0?ooo`0U0?ooo`00Z@3oool00`000000oooo0?ooo`1=0?ooo`030?l0003oool0oooo02@0oooo002Y
0?ooo`030000003oool0oooo04d0oooo00<0o`000?ooo`3oool0903oool00:T0oooo0P00001?0?oo
o`030?l0003oool0oooo02<0oooo002Y0?ooo`030000003oool0oooo04h0oooo00<0o`000?ooo`3o
ool08`3oool00:T0oooo00<000000?ooo`3oool0C`3oool00`3o0000oooo0?ooo`0R0?ooo`00XP3o
ool2000000D0oooo00<000000?ooo`3oool0C`3oool00`3o0000oooo0?ooo`0R0?ooo`00X@3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo0500oooo00<0o`000?ooo`3oool08@3o
ool00:@0oooo00<000000?ooo`3oool00P3oool300000500oooo00<0o`000?ooo`3oool08@3oool0
0:80oooo0P0000050?ooo`030000003oool0oooo0540oooo00<0o`000?ooo`3oool0803oool00:80
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1A0?ooo`030?l0003oool0oooo0200
oooo002R0?ooo`<00000103oool00`000000oooo0?ooo`1B0?ooo`030?l0003oool0oooo01l0oooo
002Y0?ooo`800000D`3oool00`3o0000oooo0?ooo`0O0?ooo`00Z@3oool00`000000oooo0?ooo`1C
0?ooo`030?l0003oool0oooo01h0oooo002Y0?ooo`030000003oool0oooo05<0oooo00<0o`000?oo
o`3oool07P3oool00:T0oooo00<000000?ooo`3oool0E03oool00`3o0000oooo0?ooo`0M0?ooo`00
Z@3oool2000005D0oooo00<0o`000?ooo`3oool07@3oool00:T0oooo00<000000?ooo`3oool0E@3o
ool00`3o0000oooo0?ooo`0L0?ooo`00Z@3oool00`000000oooo0?ooo`1E0?ooo`030?l0003oool0
oooo01`0oooo002Y0?ooo`030000003oool0oooo05D0oooo00<0o`000?ooo`3oool0703oool00:T0
oooo00<000000?ooo`3oool0EP3oool00`3o0000oooo0?ooo`0K0?ooo`00Z@3oool2000005L0oooo
00<0o`000?ooo`3oool06`3oool00:T0oooo00<000000?ooo`3oool0E`3oool00`3o0000oooo0?oo
o`0J0?ooo`00Z@3oool00`000000oooo0?ooo`1G0?ooo`030?l0003oool0oooo01X0oooo002Y0?oo
o`030000003oool0oooo05P0oooo00<0o`000?ooo`3oool06@3oool00:T0oooo0P00001I0?ooo`03
0?l0003oool0oooo01T0oooo002Y0?ooo`030000003oool0oooo05T0oooo00<0o`000?ooo`3oool0
603oool00:40oooo0`0000050?ooo`030000003oool0oooo05T0oooo00<0o`000?ooo`3oool0603o
ool00:40oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1J0?ooo`030?l0003o
ool0oooo01L0oooo002Q0?ooo`040000003oool0oooo000000@0oooo0`00001J0?ooo`030?l0003o
ool0oooo01L0oooo002Q0?ooo`<000001@3oool00`000000oooo0?ooo`1K0?ooo`030?l0003oool0
oooo01H0oooo002R0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0F`3oool00`3o
0000oooo0?ooo`0F0?ooo`00XP3oool3000000@0oooo00<000000?ooo`3oool0F`3oool00`3o0000
oooo0?ooo`0F0?ooo`00Z@3oool00`000000oooo0?ooo`1L0?ooo`030?l0003oool0oooo01D0oooo
002Y0?ooo`800000G@3oool00`3o0000oooo0?ooo`0E0?ooo`00Z@3oool00`000000oooo0?ooo`1L
0?ooo`030?l0003oool0oooo01D0oooo002Y0?ooo`030000003oool0oooo05d0oooo00<0o`000?oo
o`3oool0503oool00:T0oooo00<000000?ooo`3oool0G@3oool00`3o0000oooo0?ooo`0D0?ooo`00
Z@3oool2000005h0oooo00<0o`000?ooo`3oool0503oool00:T0oooo00<000000?ooo`3oool0GP3o
ool00`3o0000oooo0?ooo`0C0?ooo`00Z@3oool00`000000oooo0?ooo`1N0?ooo`030?l0003oool0
oooo01<0oooo002Y0?ooo`030000003oool0oooo05l0oooo00<0o`000?ooo`3oool04P3oool00:T0
oooo0P00001P0?ooo`030?l0003oool0oooo0180oooo002Y0?ooo`030000003oool0oooo05l0oooo
00<0o`000?ooo`3oool04P3oool00:T0oooo00<000000?ooo`3oool0H03oool00`3o0000oooo0?oo
o`0A0?ooo`00Z@3oool00`000000oooo0?ooo`1P0?ooo`030?l0003oool0oooo0140oooo002Y0?oo
o`030000003oool0oooo0600oooo00<0o`000?ooo`3oool04@3oool00:T0oooo0P00001R0?ooo`03
0?l0003oool0oooo0100oooo002Y0?ooo`030000003oool0oooo0640oooo00<0o`000?ooo`3oool0
403oool00:<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1Q0?ooo`030?l0003o
ool0oooo0100oooo002S0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0HP3oool0
0`3o0000oooo0?ooo`0?0?ooo`00X`3oool00`000000oooo0?ooo`030?ooo`<00000HP3oool00`3o
0000oooo0?ooo`0?0?ooo`00Y03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0680
oooo00<0o`000?ooo`3oool03`3oool00:40oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`1S0?ooo`030?l0003oool0oooo00h0oooo002Q0?ooo`@00000103oool00`000000oooo
0?ooo`1S0?ooo`030?l0003oool0oooo00h0oooo002Y0?ooo`800000I@3oool00`3o0000oooo0?oo
o`0=0?ooo`00Z@3oool00`000000oooo0?ooo`1T0?ooo`030?l0003oool0oooo00d0oooo002Y0?oo
o`030000003oool0oooo06@0oooo00<0o`000?ooo`3oool03@3oool00:T0oooo00<000000?ooo`3o
ool0I@3oool00`3o0000oooo0?ooo`0<0?ooo`00Z@3oool00`000000oooo0?ooo`1U0?ooo`030?l0
003oool0oooo00`0oooo002Y0?ooo`800000M@3oool00:T0oooo00<000000?ooo`3oool0M03oool0
0:T0oooo00<000000?ooo`3oool0M03oool00:T0oooo00<000000?ooo`3oool0M03oool00001\
\>"],
  ImageRangeCache->{{{81, 368}, {398.625, 221.688}} -> {-4.82195, 9.63374, \
0.0192514, 0.046033}},
  CellTags->"b:0.0"]
}, Open  ]],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["DSolve",
              "MR"], 
            StyleBox["[",
              "MR"], 
            RowBox[{
              StyleBox["eqn",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["y",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["x",
                "TI"]}], 
            StyleBox["]",
              "MR"]}], 
          StyleBox[
            RowBox[{
            "solve", " ", "a", " ", "differential", " ", "equation", " ", 
              "for", " ", 
              StyleBox["y",
                FontSlant->"Italic"], " ", "as", " ", "a", " ", "pure", " ", 
              "function"}],
            "TR"]},
        {
          RowBox[{
            StyleBox["DSolve",
              "MR"], 
            StyleBox["[",
              "MR"], 
            RowBox[{
              RowBox[{
                StyleBox["{",
                  "MR",
                  FontSlant->"Italic"], 
                RowBox[{
                  SubscriptBox[
                    StyleBox["eqn",
                      "TI",
                      FontSlant->"Italic"], "1"], 
                  StyleBox[",",
                    "MR",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    "MR",
                    FontSlant->"Italic"], 
                  SubscriptBox[
                    StyleBox["eqn",
                      "TI",
                      FontSlant->"Italic"], "2"], 
                  StyleBox[",",
                    "TI",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    "TI",
                    FontSlant->"Italic"], 
                  StyleBox["\[Ellipsis]",
                    "TI",
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                "MR"], 
              StyleBox[" ",
                "MR",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["{",
                  "MR",
                  FontSlant->"Italic"], 
                RowBox[{
                  SubscriptBox[
                    StyleBox["y",
                      "TI",
                      FontSlant->"Italic"], "1"], 
                  StyleBox[",",
                    "MR",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    "MR",
                    FontSlant->"Italic"], 
                  SubscriptBox[
                    StyleBox["y",
                      "TI",
                      FontSlant->"Italic"], "2"], 
                  StyleBox[",",
                    "MR",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    "MR",
                    FontSlant->"Italic"], 
                  StyleBox["\[Ellipsis]",
                    "TI",
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                "MR"], 
              StyleBox[" ",
                "MR"], 
              StyleBox["x",
                "TI",
                FontSlant->"Italic"]}], 
            StyleBox["]",
              "MR"]}], 
          RowBox[{
            StyleBox["solve",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["a",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["system",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["of",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["differential",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["equations",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["for",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["the",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["pure",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            StyleBox["functions",
              "TR"], 
            StyleBox[" ",
              "TR"], 
            SubscriptBox[
              StyleBox["y",
                "TR",
                FontSlant->"Italic"], 
              StyleBox["i",
                "TR",
                FontSlant->"Italic"]]}]}
        }]], "DefinitionBox",
  CellTags->"b:0.0"],

Cell["\<\
Finding symbolic solutions to ordinary differential equations as \
pure functions. \
\>", "Caption",
  CellTags->"b:0.0"],

Cell[TextData[{
  "When the second argument to ",
  StyleBox["DSolve", "MR"],
  StyleBox[" is specified as ", "TR"],
  StyleBox["y", "TR",
    FontSlant->"Italic"],
  StyleBox[" instead of ", "TR"],
  StyleBox["y", "TR",
    FontSlant->"Italic"],
  StyleBox["[", "MR"],
  StyleBox["x", "TR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  StyleBox[", the solution is returned as a pure function. This form is \
useful for verifying the solution of the ODE and for using the solution in \
further work. More details are given in a ", "TR"],
  ButtonBox["later section",
    ButtonData:>"setting_up_the_problem",
    ButtonStyle->"Hyperlink"],
  StyleBox[".", "TR"]
}], "Text",
  CellTags->"b:0.0"],

Cell["\<\
The solution to this differential equation is given as a pure \
function.\
\>", "MathCaption",
  FontWeight->"Plain",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqn\  = \ {\(y'\)[x] \[Equal] y[x]^2, \ y[0] \[Equal] 1}; \), "\n", 
    \(sol = \ DSolve[eqn, \ y, \ x]\)}], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \({{y \[Rule] Function[{x}, 1\/\(1 - x\)]}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqn /. sol\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \({{True, True}}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell[TextData[{
  StyleBox["This solves a system of ODEs. Each solution is labeled according \
to the name of the function (here, ", "MathCaption"],
  StyleBox["x", "MR"],
  StyleBox[" and ", "MathCaption"],
  StyleBox["y", "MR"],
  StyleBox["), making it easier to pick out individual functions.", 
    "MathCaption"]
}], "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqns = {\((t^2 + 1)\)*\(x'\)[t] \[Equal] \(-t\)*x[t] + y[t] - 
            Sign[t], \ \((t^2 + 1)\)*\(y'\)[t] \[Equal] \(-x[t]\) - t*y[t] + 
            t*UnitStep[t], \ x[0] \[Equal] \(-1\)/2, \ 
        y[0] \[Equal] 2}; \), "\[IndentingNewLine]", 
    \(sol = DSolve[eqns, \ {x, y}, t]\)}], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"x", "\[Rule]", 
            RowBox[{"Function", "[", 
              RowBox[{\({t}\), ",", 
                FractionBox[
                  RowBox[{\(-1\), "+", \(4\ t\), "+", 
                    RowBox[{"2", " ", 
                      RowBox[{"(", 
                        RowBox[{"\[Piecewise]", GridBox[{
                              {\(ArcTan[t]\), \(t \[LessEqual] 0\)},
                              {\(-t\), 
                                TagBox["True",
                                  "PiecewiseDefault",
                                  AutoDelete->False,
                                  DeletionWarning->True]}
                              },
                            ColumnSpacings->1.2,
                            ColumnAlignments->{Left}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", "t", " ", 
                      RowBox[{"(", 
                        RowBox[{"\[Piecewise]", GridBox[{
                              {\(1\/2\ Log[1 + t\^2]\), \(t \[LessEqual] 0\)}
                              },
                            ColumnSpacings->1.2,
                            ColumnAlignments->{Left}]}], 
                        ")"}]}]}], \(2\ \((1 + t\^2)\)\)]}], "]"}]}], ",", 
          RowBox[{"y", "\[Rule]", 
            RowBox[{"Function", "[", 
              RowBox[{\({t}\), ",", 
                FractionBox[
                  RowBox[{"4", "+", "t", "-", 
                    RowBox[{"2", " ", "t", " ", 
                      RowBox[{"(", 
                        RowBox[{"\[Piecewise]", GridBox[{
                              {\(ArcTan[t]\), \(t \[LessEqual] 0\)},
                              {\(-t\), 
                                TagBox["True",
                                  "PiecewiseDefault",
                                  AutoDelete->False,
                                  DeletionWarning->True]}
                              },
                            ColumnSpacings->1.2,
                            ColumnAlignments->{Left}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", 
                      RowBox[{"(", 
                        RowBox[{"\[Piecewise]", GridBox[{
                              {\(1\/2\ Log[1 + t\^2]\), \(t \[LessEqual] 0\)}
                              },
                            ColumnSpacings->1.2,
                            ColumnAlignments->{Left}]}], 
                        ")"}]}]}], \(2\ \((1 + t\^2)\)\)]}], "]"}]}]}], "}"}],
       "}"}]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell["\<\
This substitutes a random value for the independent variable and \
shows that the solutions are correct at that point.\
\>", "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(eqns /. sol\) /. {t \[Rule] \ Random[]}\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \({{True, True, True, True}}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell["This plots the solutions.", "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{x[t] /. sol, \ y[t] /. sol}, \ {t, \(-10\), 10}, \ 
      PlotStyle\  \[Rule] \ {{Red}, \ {Blue}}]; \)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:0.0"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0476191 0.291132 0.151626 [
[.02381 .27863 -9 -9 ]
[.02381 .27863 9 0 ]
[.2619 .27863 -6 -9 ]
[.2619 .27863 6 0 ]
[.7381 .27863 -3 -9 ]
[.7381 .27863 3 0 ]
[.97619 .27863 -6 -9 ]
[.97619 .27863 6 0 ]
[.4875 .13951 -12 -4.5 ]
[.4875 .13951 0 4.5 ]
[.4875 .44276 -6 -4.5 ]
[.4875 .44276 0 4.5 ]
[.4875 .59438 -6 -4.5 ]
[.4875 .59438 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .29113 m
.02381 .29738 L
s
[(-10)] .02381 .27863 0 1 Mshowa
.2619 .29113 m
.2619 .29738 L
s
[(-5)] .2619 .27863 0 1 Mshowa
.7381 .29113 m
.7381 .29738 L
s
[(5)] .7381 .27863 0 1 Mshowa
.97619 .29113 m
.97619 .29738 L
s
[(10)] .97619 .27863 0 1 Mshowa
.125 Mabswid
.07143 .29113 m
.07143 .29488 L
s
.11905 .29113 m
.11905 .29488 L
s
.16667 .29113 m
.16667 .29488 L
s
.21429 .29113 m
.21429 .29488 L
s
.30952 .29113 m
.30952 .29488 L
s
.35714 .29113 m
.35714 .29488 L
s
.40476 .29113 m
.40476 .29488 L
s
.45238 .29113 m
.45238 .29488 L
s
.54762 .29113 m
.54762 .29488 L
s
.59524 .29113 m
.59524 .29488 L
s
.64286 .29113 m
.64286 .29488 L
s
.69048 .29113 m
.69048 .29488 L
s
.78571 .29113 m
.78571 .29488 L
s
.83333 .29113 m
.83333 .29488 L
s
.88095 .29113 m
.88095 .29488 L
s
.92857 .29113 m
.92857 .29488 L
s
.25 Mabswid
0 .29113 m
1 .29113 L
s
.5 .13951 m
.50625 .13951 L
s
[(-1)] .4875 .13951 1 0 Mshowa
.5 .44276 m
.50625 .44276 L
s
[(1)] .4875 .44276 1 0 Mshowa
.5 .59438 m
.50625 .59438 L
s
[(2)] .4875 .59438 1 0 Mshowa
.125 Mabswid
.5 .16983 m
.50375 .16983 L
s
.5 .20016 m
.50375 .20016 L
s
.5 .23048 m
.50375 .23048 L
s
.5 .26081 m
.50375 .26081 L
s
.5 .32146 m
.50375 .32146 L
s
.5 .35178 m
.50375 .35178 L
s
.5 .38211 m
.50375 .38211 L
s
.5 .41243 m
.50375 .41243 L
s
.5 .47308 m
.50375 .47308 L
s
.5 .50341 m
.50375 .50341 L
s
.5 .53373 m
.50375 .53373 L
s
.5 .56406 m
.50375 .56406 L
s
.5 .10918 m
.50375 .10918 L
s
.5 .07885 m
.50375 .07885 L
s
.5 .04853 m
.50375 .04853 L
s
.5 .0182 m
.50375 .0182 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .22351 m
.06244 .21876 L
.10458 .21268 L
.14415 .20583 L
.18221 .19786 L
.22272 .18736 L
.26171 .17446 L
.30316 .15629 L
.32392 .14472 L
.34309 .13205 L
.3815 .09886 L
.42085 .05117 L
.43098 .03755 L
.44061 .02565 L
.44479 .0213 L
.44925 .01759 L
.45057 .01674 L
.45182 .01605 L
.45303 .0155 L
.45414 .01512 L
.4552 .01486 L
.45632 .01472 L
.45745 .01472 L
.45869 .01489 L
.45999 .01528 L
.46122 .01587 L
.46233 .0166 L
.46353 .0176 L
.46484 .01898 L
.46623 .02078 L
.46872 .02498 L
.47102 .03004 L
.47318 .03593 L
.47809 .05394 L
.48334 .08084 L
.48814 .11272 L
.49338 .15464 L
.49626 .18023 L
.49767 .19329 L
.49897 .20554 L
.50017 .21586 L
.50144 .21996 L
.50411 .22887 L
.50878 .24483 L
.5179 .27463 L
.52775 .30051 L
.53336 .31152 L
.5386 .31955 L
.54358 .32539 L
.549 .33009 L
Mistroke
.55149 .33176 L
.55413 .33325 L
.55888 .33529 L
.56129 .33606 L
.5639 .33671 L
.56635 .33718 L
.56861 .33751 L
.57066 .33772 L
.57182 .33781 L
.5729 .33788 L
.57404 .33793 L
.57508 .33796 L
.57628 .33798 L
.57742 .33799 L
.57857 .33797 L
.5798 .33795 L
.58096 .33791 L
.58202 .33786 L
.5845 .33771 L
.5871 .33751 L
.59201 .33701 L
.59737 .33634 L
.6158 .3335 L
.65642 .32695 L
.69551 .32175 L
.73706 .31747 L
.7771 .31427 L
.81562 .31181 L
.85659 .3097 L
.89604 .30802 L
.93398 .30667 L
.97437 .30544 L
.97619 .30539 L
Mfstroke
0 0 1 r
.02381 .26801 m
.06244 .26662 L
.10458 .26496 L
.14415 .26323 L
.18221 .26144 L
.22272 .25946 L
.26171 .25768 L
.27193 .25728 L
.28302 .25691 L
.2881 .25677 L
.29349 .25665 L
.29809 .25656 L
.3007 .25653 L
.30316 .2565 L
.3044 .25649 L
.30573 .25648 L
.30698 .25647 L
.30812 .25647 L
.30882 .25647 L
.30946 .25647 L
.31016 .25647 L
.31091 .25647 L
.31216 .25647 L
.31287 .25647 L
.31354 .25648 L
.31481 .25649 L
.31603 .2565 L
.3183 .25653 L
.32074 .25657 L
.3234 .25663 L
.32807 .25678 L
.33302 .25699 L
.33726 .25724 L
.34193 .25758 L
.34684 .25803 L
.35202 .25863 L
.36127 .26005 L
.36643 .2611 L
.37123 .26226 L
.37646 .26377 L
.38213 .26574 L
.39265 .27058 L
.40259 .277 L
.41226 .28564 L
.42118 .29645 L
.43087 .31242 L
.43994 .33266 L
.44989 .36259 L
.46058 .4058 L
.48033 .51266 L
Mistroke
.4857 .54223 L
.49075 .56644 L
.49355 .57749 L
.49658 .58702 L
.49792 .59035 L
.49933 .59324 L
.50186 .5971 L
.50432 .59996 L
.50569 .60118 L
.50695 .60206 L
.50812 .60266 L
.50939 .6031 L
.51059 .6033 L
.5117 .60332 L
.51298 .60313 L
.51419 .60277 L
.51551 .60217 L
.51693 .6013 L
.51983 .59888 L
.52249 .59601 L
.53181 .58262 L
.54162 .56629 L
.56162 .53613 L
.57978 .51596 L
.58989 .50735 L
.59943 .50058 L
.62039 .4892 L
.64044 .48145 L
.65891 .4761 L
.67771 .47187 L
.69836 .46823 L
.71948 .46528 L
.73876 .4631 L
.77763 .45972 L
.81744 .45722 L
.85574 .4554 L
.89649 .45389 L
.93573 .45274 L
.97344 .45183 L
.97619 .45177 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oT03oool0
0`000000oooo0?ooo`2=0?ooo`00T03oool00`000000oooo0?ooo`2=0?ooo`00T03oool00`000000
oooo0?ooo`2=0?ooo`00T03oool00`000000oooo0?ooo`2=0?ooo`00P`3oool30?l000X0oooo00<0
00000?ooo`3oool0S@3oool00880oooo00<0o`000?ooo`3oool00P3o00090?ooo`800000SP3oool0
0800oooo0P3o00040?ooo`030?l0003oool0oooo00L0oooo00<000000?ooo`3oool0S@3oool007l0
oooo00<0o`000?ooo`3oool01@3oool00`3o0000oooo0?ooo`060?ooo`030000003oool0oooo08d0
oooo001n0?ooo`030?l0003oool0oooo00H0oooo00<0o`000?ooo`3oool01P3oool00`000000oooo
0?ooo`2=0?ooo`00O@3oool00`3o0000oooo0?ooo`080?ooo`030?l0003oool0oooo00D0oooo00<0
00000?ooo`3oool0S@3oool007d0oooo00<0o`000?ooo`3oool0203oool00`3o0000oooo0?ooo`05
0?ooo`030000003oool0oooo08d0oooo001l0?ooo`030?l0003oool0oooo00T0oooo00<0o`000?oo
o`3oool01@3oool00`000000oooo0?ooo`2=0?ooo`00N`3oool00`3o0000oooo0?ooo`0;0?ooo`03
0?l0003oool0oooo00@0oooo00<000000?ooo`3oool0S@3oool007/0oooo00<0o`000?ooo`3oool0
2`3oool00`3o0000oooo0?ooo`040?ooo`030000003oool0oooo08d0oooo001j0?ooo`030?l0003o
ool0oooo00d0oooo00<0o`000?ooo`3oool00`3oool2000008h0oooo001j0?ooo`030?l0003oool0
oooo00d0oooo00<0o`000?ooo`3oool00`3oool00`000000oooo0?ooo`2=0?ooo`00N@3oool00`3o
0000oooo0?ooo`0>0?ooo`030?l0003oool0oooo00<0oooo00<000000?ooo`3oool0S@3oool007P0
oooo00<0o`000?ooo`3oool03`3oool00`3o0000oooo0?ooo`030?ooo`030000003oool0oooo08d0
oooo001g0?ooo`030?l0003oool0oooo0100oooo00<0o`000?ooo`3oool00`3oool00`000000oooo
0?ooo`2=0?ooo`00MP3oool00`3o0000oooo0?ooo`0A0?ooo`030?l0003oool0oooo00<0oooo00<0
00000?ooo`3oool0S@3oool007D0oooo00<0o`000?ooo`3oool04`3oool00`3o0000oooo0?ooo`02
0?ooo`030000003oool0oooo08d0oooo001d0?ooo`030?l0003oool0oooo01@0oooo00<0o`000?oo
o`3oool00P3oool00`000000oooo0?ooo`2=0?ooo`00M03oool00`3o0000oooo0?ooo`0D0?ooo`03
0?l0003oool0oooo0080oooo0P00002>0?ooo`00L`3oool00`3o0000oooo0?ooo`0E0?ooo`030?l0
003oool0oooo0080oooo00<000000?ooo`3oool0S@3oool00780oooo00<0o`000?ooo`3oool05P3o
ool00`3o0000oooo0?ooo`020?ooo`030000003oool0oooo08d0oooo001a0?ooo`030?l0003oool0
oooo01L0oooo00<0o`000?ooo`3oool00P3oool00`000000oooo0?ooo`2=0?ooo`00L03oool00`3o
0000oooo0?ooo`0I0?ooo`050?l0003oool0oooo0?ooo`000000S`3oool006l0oooo00<0o`000?oo
o`3oool06P3oool01@3o0000oooo0?ooo`3oool0000008l0oooo001^0?ooo`030?l0003oool0oooo
01/0oooo00D0o`000?ooo`3oool0oooo0000002?0?ooo`00K@3oool00`3o0000oooo0?ooo`0L0?oo
o`050?l0003oool0oooo0?ooo`000000S`3oool006`0oooo00<0o`000?ooo`3oool07P3oool0103o
0000oooo0?ooo`00002?0?ooo`00J`3oool00`3o0000oooo0?ooo`0O0?ooo`030?l0003oool0oooo
00800000SP3oool006X0oooo00<0o`000?ooo`3oool0803oool0103o0000oooo0?ooo`00002?0?oo
o`00J03oool20?l002<0oooo00@0o`000?ooo`3oool00000S`3oool006L0oooo00<0o`000?ooo`3o
ool08`3oool0103o0000oooo0?ooo`00002?0?ooo`00IP3oool00`3o0000oooo0?ooo`0T0?ooo`04
0?l0003oool0oooo000008l0oooo001U0?ooo`030?l0003oool0oooo02D0oooo00@0o`000?ooo`3o
ool00000S`3oool006@0oooo00<0o`000?ooo`3oool09P3oool0103o0000oooo0?ooo`00002?0?oo
o`00H`3oool00`3o0000oooo0?ooo`0R0?ooo`D0000000@0o`000?ooo`3oool00000S`3oool00640
oooo0P3o000W0?ooo`070000003oool0oooo0?ooo`3o0000oooo0000002?0?ooo`00G`3oool20?l0
02T0oooo00H000000?ooo`3oool0oooo0?l0003oool3000008d0oooo001N0?ooo`030?l0003oool0
oooo0240oooo100000040?ooo`070000003oool0oooo0?ooo`3o0000oooo0000002?0?ooo`00G03o
ool20?l002`0oooo00L000000?ooo`3oool0oooo0?l0003oool0000008l0oooo001K0?ooo`030?l0
003oool0oooo02/0oooo0P0000030?ooo`030?l0003oool0000008l0oooo001I0?ooo`80o`00<`3o
ool00`3o0000oooo0000002?0?ooo`00E`3oool20?l003D0oooo00<0o`000?ooo`000000S`3oool0
05D0oooo0P3o000g0?ooo`030?l0003oool0000008l0oooo001C0?ooo`80o`00>@3oool00`3o0000
oooo0000002?0?ooo`00D03oool30?l003`0oooo00<0o`00000000000000SP3oool004h0oooo0P3o
000o0?ooo`030?l000000000oooo08h0oooo001;0?ooo`<0o`00@@3oool00`3o000000000?ooo`2>
0?ooo`00A`3oool40?l004@0oooo00<0o`000000003oool0SP3oool004<0oooo103o00180?ooo`03
0?l000000000oooo08h0oooo00100?ooo`<0o`00C03oool00`3o000000000?ooo`2>0?ooo`00?03o
ool40?l004l0oooo00<0o`000000003oool0SP3oool003P0oooo103o001C0?ooo`030?l000000000
oooo08h0oooo000e0?ooo`<0o`00E`3oool00`3o000000000?ooo`2>0?ooo`00<@3oool40?l005X0
oooo00<0o`00000000000000SP3oool002d0oooo103o001O0?ooo`030?l0003oool0oooo08d0oooo
000Y0?ooo`@0o`00H`3oool00`3o0000oooo0?ooo`2=0?ooo`008`3oool60?l006L0oooo00<0o`00
0?ooo`3oool0S@3oool001/0oooo203o001]0?ooo`030?l0003oool0oooo08d0oooo000B0?ooo`T0
o`00M@3oool00`3o0000oooo0?ooo`2=0?ooo`00303oool60?l007h0oooo00<000000?l0003oool0
S@3oool000T0oooo0`3o00240?ooo`030000003o0000oooo08d0oooo002@0?ooo`030000003o0000
oooo08d0oooo002@0?ooo`030000003o0000oooo08d0oooo002@0?ooo`030000003oool0o`0008d0
oooo002@0?ooo`030000003oool0o`0008d0oooo002@0?ooo`040000003oool0oooo0?l008`0oooo
002@0?ooo`040000003oool0oooo0?l008`0oooo00070?ooo`D000000P3oool2000003h0oooo0P00
00100?ooo`040000003oool0oooo0?l003l0oooo0P00000n0?ooo`D000000P3oool2000000@0oooo
00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0j0?ooo`040000
003oool0oooo000003l0oooo00@000000?ooo`3oool0o`00?P3oool010000000oooo0?ooo`00000o
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`010?ooo`002@3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0=03ooolM0000ob`0oooo00D0
00000?ooo`3oool0oooo0?l000100?ooo`030000003oool0oooo03d0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo0040oooo00000`3oool0000000000002000000@0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01h0oooo5P000?l4000000<0
oooo0P00000D0?ooo`L0003o9@3oool200000080oooo00<0o`000?ooo`3oool0?03oool200000400
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0040oooo00090?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`080?oooaH0003o7@3oool00`00
0000oooo0?ooo`0J0?ooo`<0003o8P3oool01@000000oooo0?ooo`3oool0o`0003h0oooo00<00000
0?ooo`3oool0?`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00@3o
ool000P0oooo00<000000000o`000?l040000?lc0?ooo`<000007@3oool30000oal0oooo00D00000
0?ooo`3oool0oooo0?l0000n0?ooo`<00000?P3oool2000000@0oooo0P0000040?ooo`00L@3oool2
0000oad0oooo00<000000?ooo`3oool00P3oool00`3o0000oooo0?ooo`280?ooo`00L`3oool00`00
0?l0oooo0?ooo`0J0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool0R03oool007@0
oooo00<0003o0?ooo`3oool06@3oool00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo08P0
oooo001e0?ooo`80003o6@3oool00`000000oooo0?ooo`030?ooo`030?l0003oool0oooo08L0oooo
001g0?ooo`030000o`3oool0oooo01H0oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?oo
o`270?ooo`00N03oool00`000?l0oooo0?ooo`0E0?ooo`030000003oool0oooo00<0oooo00<0o`00
0?ooo`3oool0Q`3oool00080ooooM`0000000`000?l000000000000K000000030?l0000000000000
08H0000000090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`020?ooo`030000o`3oool0oooo00H0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`040?ooo`030?l0003oool0oooo00@0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01@3oool000T0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0[0?ooo`030000o`3oool0oooo01<0oooo
00<000000?ooo`3oool01@3oool00`3o0000oooo0?ooo`0i0?ooo`030000003oool0oooo0440oooo
00<000000?ooo`3oool01@3oool007/0oooo00<0003o0?ooo`3oool04P3oool00`000000oooo0?oo
o`050?ooo`030?l0003oool0oooo08D0oooo001k0?ooo`030000o`3oool0oooo0180oooo00<00000
0?ooo`3oool01P3oool00`3o0000oooo0?ooo`1[0?oooa80o`001`3oool007`0oooo00<0003o0?oo
o`3oool04@3oool00`000000oooo0?ooo`060?ooo`030?l0003oool0oooo05D0oooo5P3o000I0?oo
o`00O03oool00`000?l0oooo0?ooo`0A0?ooo`030000003oool0oooo00L0oooo00<0o`000?ooo`3o
ool0B03oool<0?l002l0oooo001l0?ooo`030000o`3oool0oooo0140oooo00<000000?ooo`3oool0
1`3oool00`3o0000oooo0?ooo`0e0?oooa<0o`00>`3oool007d0oooo00<0003o0?ooo`3oool0403o
ool00`000000oooo0?ooo`080?ooo`030?l0003oool0oooo02h0oooo1P3o001>0?ooo`00O@3oool0
0`000?l0oooo0?ooo`0@0?ooo`8000002P3oool00`3o0000oooo0?ooo`0T0?ooo`T0o`00E03oool0
07h0oooo00<0003o0?ooo`3oool03`3oool00`000000oooo0?ooo`0:0?ooo`030?l0003oool0oooo
01/0oooo203o001M0?ooo`00OP3oool00`000?l0oooo0?ooo`0?0?ooo`030000003oool0oooo00/0
oooo00<0o`000?ooo`3oool0503oool60?l006D0oooo001o0?ooo`030000o`3oool0oooo00h0oooo
00<000000?ooo`3oool0303oool20?l000h0oooo1P3o001[0?ooo`00O`3oool00`000?l0oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo3P3o001a0?ooo`00P03oool00`000?l0oooo0?ooo`0=
0?ooo`030000003oool0oooo08d0oooo00200?ooo`030000o`3oool0oooo00d0oooo00<000000?oo
o`3oool0S@3oool00800oooo00<0003o0?ooo`3oool03@3oool00`000000oooo0?ooo`2=0?ooo`00
P@3oool00`000?l0oooo0?ooo`0<0?ooo`800000SP3oool00840oooo00<0003o0?ooo`3oool0303o
ool00`000000oooo0?ooo`2=0?ooo`00PP3oool00`000?l0oooo0?ooo`0;0?ooo`030000003oool0
oooo08d0oooo00220?ooo`030000o`3oool0oooo00/0oooo00<000000?ooo`3oool0S@3oool00880
oooo00<0003o0?ooo`3oool02`3oool00`000000oooo0?ooo`2=0?ooo`00PP3oool00`000?l0oooo
0?ooo`0;0?ooo`030000003oool0oooo08d0oooo00230?ooo`030000o`3oool0oooo00X0oooo00<0
00000?ooo`3oool0S@3oool008<0oooo00<0003o0?ooo`3oool02P3oool00`000000oooo0?ooo`2=
0?ooo`00P`3oool00`000?l0oooo0?ooo`0:0?ooo`030000003oool0oooo08d0oooo00230?ooo`03
0000o`3oool0oooo00X0oooo0P00002>0?ooo`00Q03oool00`000?l0oooo0?ooo`090?ooo`030000
003oool0oooo08d0oooo00240?ooo`030000o`3oool0oooo00T0oooo00<000000?ooo`3oool0S@3o
ool008@0oooo00<0003o0?ooo`3oool02@3oool00`000000oooo0?ooo`2=0?ooo`00Q03oool00`00
0?l0oooo0?ooo`090?ooo`030000003oool0oooo08d0oooo00250?ooo`030000o`3oool0oooo00P0
oooo00<000000?ooo`3oool0S@3oool008D0oooo00<0003o0?ooo`3oool0203oool00`000000oooo
0?ooo`2=0?ooo`00Q@3oool00`000?l0oooo0?ooo`080?ooo`030000003oool0oooo08d0oooo0025
0?ooo`030000o`3oool0oooo00P0oooo0P00002>0?ooo`00Q@3oool00`000?l0oooo0?ooo`080?oo
o`030000003oool0oooo08d0oooo00260?ooo`030000o`3oool0oooo00L0oooo00<000000?ooo`3o
ool0S@3oool008H0oooo00<0003o0?ooo`3oool01`3oool00`000000oooo0?ooo`2=0?ooo`00QP3o
ool00`000?l0oooo0?ooo`070?ooo`030000003oool0oooo08d0oooo00260?ooo`030000o`3oool0
oooo00L0oooo00<000000?ooo`3oool0S@3oool008H0oooo00<0003o0?ooo`3oool01`3oool00`00
0000oooo0?ooo`2=0?ooo`00Q`3oool00`000?l0000000000003000000<0oooo00<000000?ooo`3o
ool0S@3oool008L0oooo00@0003o0?ooo`3oool000001@3oool00`000000oooo0?ooo`2=0?ooo`00
Q`3oool010000?l0oooo0?ooo`0000050?ooo`<00000S@3oool008L0oooo00@0003o0?ooo`3oool0
00001@3oool00`000000oooo0?ooo`2=0?ooo`00Q`3oool010000?l0oooo0?ooo`0000050?ooo`03
0000003oool0oooo08d0oooo00280?ooo`030000o`000000000000D0oooo00<000000?ooo`3oool0
J@3ooolM0000o`L0oooo00280?ooo`030000o`3oool0oooo00D0oooo00<000000?ooo`3oool0D`3o
oolF0000ob@0oooo00280?ooo`030000o`3oool0oooo00D0oooo00<000000?ooo`3oool0A`3oool<
0000ocX0oooo00280?ooo`030000o`3oool0oooo00D0oooo00<000000?ooo`3oool0?`3oool80000
odH0oooo00280?ooo`030000o`3oool0oooo00D0oooo00<000000?ooo`3oool0=03oool;0000odh0
oooo00290?ooo`030000o`3oool0oooo00@0oooo00<000000?ooo`3oool0;`3oool50000oeT0oooo
00290?ooo`030000o`3oool0oooo00@0oooo0P00000]0?ooo`<0003oGP3oool008T0oooo00<0003o
0?ooo`3oool0103oool00`000000oooo0?ooo`0X0?ooo`@0003oH@3oool008T0oooo00<0003o0?oo
o`3oool0103oool00`000000oooo0?ooo`0T0?ooo`@0003oI@3oool008T0oooo00<0003o0?ooo`3o
ool0103oool00`000000oooo0?ooo`0Q0?ooo`<0003oJ@3oool008X0oooo00<0003o0?ooo`3oool0
0`3oool00`000000oooo0?ooo`0O0?ooo`80003oK03oool008X0oooo00<0003o0?ooo`3oool00`3o
ool00`000000oooo0?ooo`0M0?ooo`80003oKP3oool008X0oooo00<0003o0?ooo`3oool00`3oool0
0`000000oooo0?ooo`0L0?ooo`030000o`3oool0oooo06h0oooo002:0?ooo`030000o`3oool0oooo
00<0oooo00<000000?ooo`3oool06P3oool20000og40oooo002:0?ooo`030000o`3oool0oooo00<0
oooo0P00000J0?ooo`030000o`3oool0oooo0740oooo002;0?ooo`030000o`3oool0oooo0080oooo
00<000000?ooo`3oool0603oool00`000?l0oooo0?ooo`1b0?ooo`00R`3oool00`000?l0oooo0?oo
o`020?ooo`030000003oool0oooo01L0oooo00<0003o0?ooo`3oool0L`3oool008/0oooo00<0003o
0?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`80003oMP3oool008/0oooo00<0003o0?oo
o`3oool00P3oool00`000000oooo0?ooo`0D0?ooo`030000o`3oool0oooo07H0oooo002;0?ooo`03
0000o`3oool0oooo0080oooo00<000000?ooo`3oool04`3oool00`000?l0oooo0?ooo`1g0?ooo`00
R`3oool00`000?l0oooo0?ooo`020?ooo`030000003oool0oooo0180oooo00<0003o0?ooo`3oool0
N03oool008/0oooo00<0003o0?ooo`3oool00P3oool00`000000oooo0?ooo`0A0?ooo`030000o`3o
ool0oooo07T0oooo002<0?ooo`050000o`3oool0oooo0?ooo`0000004`3oool00`000?l0oooo0?oo
o`1i0?ooo`00S03oool010000?l0oooo0?ooo`3oool200000140oooo00<0003o0?ooo`3oool0NP3o
ool008`0oooo00D0003o0?ooo`3oool0oooo0000000A0?ooo`030000o`3oool0oooo07/0oooo002<
0?ooo`050000o`3oool0oooo0?ooo`000000403oool00`000?l0oooo0?ooo`1l0?ooo`00S03oool0
1@000?l0oooo0?ooo`3oool0000000l0oooo00<0003o0?ooo`3oool0O@3oool008`0oooo00D0003o
0?ooo`3oool0oooo0000000?0?ooo`030000o`3oool0oooo07d0oooo002<0?ooo`050000o`3oool0
oooo0?ooo`0000003P3oool00`000?l0oooo0?ooo`1n0?ooo`00S@3oool010000?l0oooo0?ooo`00
000=0?ooo`030000o`3oool0oooo07l0oooo002=0?ooo`040000o`3oool0oooo000000`0oooo00<0
003o0?ooo`3oool0P03oool008d0oooo00@0003o0?ooo`3oool00000303oool00`000?l0oooo0?oo
o`200?ooo`00S@3oool00`000?l0oooo0?ooo`02000000X0oooo00<0003o0?ooo`3oool0P@3oool0
08d0oooo00@0003o0?ooo`3oool000002P3oool00`000?l0oooo0?ooo`220?ooo`00SP3oool00`00
0?l0oooo0000000:0?ooo`030000o`3oool0oooo0880oooo002>0?ooo`030000o`3oool0000000T0
oooo00<0003o0?ooo`3oool0P`3oool008h0oooo00<0003o0?ooo`0000002@3oool00`000?l0oooo
0?ooo`230?ooo`00S`3oool00`000?l000000?ooo`070?ooo`030000o`3oool0oooo08@0oooo0028
0?ooo`@000000`3oool00`000?l000000?ooo`060?ooo`030000o`3oool0oooo08D0oooo00280?oo
o`030000003oool0oooo00D0oooo00<0003o0?ooo`3oool01@3oool00`000?l0oooo0?ooo`250?oo
o`00R@3oool00`000000oooo0?ooo`040?ooo`030000o`000000000000@0oooo00<0003o0?ooo`3o
ool0QP3oool008X0oooo00<000000?ooo`3oool00`3oool00`000000003o0?ooo`040?ooo`030000
o`3oool0oooo08H0oooo00280?ooo`040000003oool0oooo000000@0oooo00<000000000o`000?l0
0P3oool20000ohT0oooo00290?ooo`8000001@3oool00`000000oooo0000o`030000ohX0oooo002@
0?ooo`030000003oool0oooo08d0oooo002@0?ooo`030000003oool0oooo08d0oooo002@0?ooo`03
0000003oool0oooo08d0oooo002@0?ooo`030000003oool0oooo08d0oooo0000\
\>"],
  ImageRangeCache->{{{81, 368}, {528.375, 351.438}} -> {-16.6368, 6.20804, \
0.0737416, 0.023159}},
  CellTags->"b:0.0"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DSolve",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["eqn",
                  "TI",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                RowBox[{
                  StyleBox["u",
                    "TI",
                    FontSlant->"Italic"], 
                  StyleBox["[",
                    "MR",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox["x",
                      "TI",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR",
                      FontSlant->"Italic"], " ", 
                    StyleBox["y",
                      "TI",
                      FontSlant->"Italic"]}], 
                  StyleBox["]",
                    "MR",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "TI"], 
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    StyleBox["x",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["y",
                      "TI"]}], 
                  StyleBox["}",
                    "MR"]}]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "solve a partial differential equation for ",
              StyleBox["u", "TI",
                FontSlant->"Italic"],
              StyleBox["[", "TI",
                FontSlant->"Plain"],
              StyleBox["x", "TI",
                FontSlant->"Italic"],
              StyleBox[",", "MR",
                FontSlant->"Italic"],
              " ",
              StyleBox["y", "TI",
                FontSlant->"Italic"],
              StyleBox["]", "MR",
                FontSlant->"Plain"]
            }], "Text"]}
          }], TextForm]], "DefinitionBox",
  CellTags->"b:0.0"],

Cell["\<\
Finding symbolic solutions to partial differential equations. \
\
\>", "Caption",
  CellTags->{"S3.9.7", "ndsg:0", "b:0.0"}],

Cell[TextData[{
  "While general solutions to ordinary differential equations involve \
arbitrary ",
  StyleBox["constants",
    FontSlant->"Italic"],
  ", general solutions to partial differential equations involve arbitrary ",
  StyleBox["functions",
    FontSlant->"Italic"],
  ". ",
  StyleBox["DSolve", "MR"],
  StyleBox[" labels these arbitrary functions as ", "TR"],
  StyleBox["C[", "MR"],
  StyleBox["i", "TI",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  StyleBox[".", "TR"]
}], "Text",
  CellTags->"b:0.0"],

Cell[TextData[{
  "Here is the general solution to a linear first-order PDE. In the solution, \
",
  StyleBox["C[1]", "MR"],
  StyleBox[" labels an arbitrary function of ", "TR"],
  Cell[BoxData[
      \(\(\(-x\) + y\)\/\(x\ y\)\)]],
  "."
}], "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqn = 
      x^2*D[u[x, y], x] + y^2*D[u[x, y], y] - \((x + y)\)*u[x, y]; \), "\n", 
    \(sol = DSolve[eqn \[Equal] 0, \ u, \ {x, y}]\)}], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \({{u \[Rule] 
          Function[{x, 
              y}, \(-x\)\ y\ \(C[
                  1]\)[\(\(-x\) + y\)\/\(x\ y\)]]}}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell[TextData[{
  "This obtains a particular solution to the PDE for a specific choice of ",
  StyleBox["C[1]", "MR"],
  StyleBox[".", "TR"]
}], "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fn = \(u[x, y] /. 
          sol[\([\)\(1\)\(]\)]\) /. {\(C[1]\)[t_] \[Rule] \ 
            Sin[t^2]\  + \((t/10)\)}\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \(\(-x\)\ y\ \((\(\(-x\) + y\)\/\(10\ x\ y\) + 
          Sin[\((\(-x\) + y)\)\^2\/\(x\^2\ y\^2\)])\)\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell["Here is a plot of the surface for this solution.", "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[fn, \ {x, \(-5\), 5}, \ {y, \(-5\), 5}\ ]; \)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"b:0.0"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
3.1984e-017 1.04977 -0.0679587 1.04977 [
[.08608 .22315 -12 -8.87306 ]
[.08608 .22315 0 .12694 ]
[.20731 .17545 -11.6738 -9 ]
[.20731 .17545 .32622 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.46808 .07289 -5.33651 -9 ]
[.46808 .07289 .66349 0 ]
[.60856 .01769 -5.08632 -9 ]
[.60856 .01769 .91368 0 ]
[.73498 .04732 0 -6.2105 ]
[.73498 .04732 12 2.7895 ]
[.79846 .14452 0 -6.11593 ]
[.79846 .14452 12 2.88407 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.90976 .31495 0 -5.95504 ]
[.90976 .31495 6 3.04496 ]
[.95881 .39008 0 -5.88604 ]
[.95881 .39008 6 3.11396 ]
[.01926 .29555 -24 -2.76804 ]
[.01926 .29555 0 6.23196 ]
[.01048 .35054 -6 -2.81462 ]
[.01048 .35054 0 6.18538 ]
[.0014 .4075 -18 -2.86305 ]
[.0014 .4075 0 6.13695 ]
[-0.00803 .46654 -6 -2.91344 ]
[-0.00803 .46654 0 6.08656 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.72272 .05198 m
.71658 .05431 L
s
[(-4)] .73498 .04732 -1 .38011 Mshowa
.78611 .14895 m
.77994 .15117 L
s
[(-2)] .79846 .14452 -1 .3591 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.89727 .31899 m
.89103 .32101 L
s
[(2)] .90976 .31495 -1 .32334 Mshowa
.94627 .39394 m
.94 .39587 L
s
[(4)] .95881 .39008 -1 .30801 Mshowa
.125 Mabswid
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.7708 .12553 m
.7671 .12688 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.9099 .3383 m
.90615 .3395 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.70593 .0263 m
.70226 .02771 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.0315 .29084 m
.03763 .28848 L
s
[(-2.5)] .01926 .29555 1 -0.38488 Mshowa
.02277 .34593 m
.02892 .34363 L
s
[(0)] .01048 .35054 1 -0.37453 Mshowa
.01373 .40301 m
.01989 .40077 L
s
[(2.5)] .0014 .4075 1 -0.36377 Mshowa
.00435 .46218 m
.01054 .46 L
s
[(5)] -0.00803 .46654 1 -0.35257 Mshowa
.125 Mabswid
.02978 .30171 m
.03346 .3003 L
s
.02805 .31265 m
.03173 .31125 L
s
.0263 .32366 m
.02998 .32227 L
s
.02454 .33476 m
.02823 .33337 L
s
.02099 .35719 m
.02468 .35581 L
s
.01919 .36852 m
.02288 .36715 L
s
.01738 .37993 m
.02108 .37857 L
s
.01556 .39143 m
.01926 .39008 L
s
.01188 .41467 m
.01558 .41333 L
s
.01002 .42642 m
.01372 .42509 L
s
.00814 .43825 m
.01185 .43693 L
s
.00625 .45017 m
.00996 .44886 L
s
.03321 .28005 m
.03688 .27863 L
s
.03491 .26934 m
.03858 .26791 L
s
.0366 .2587 m
.04026 .25726 L
s
.00243 .47428 m
.00615 .47297 L
s
.0005 .48646 m
.00422 .48517 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.636 .769 .943 r
.38687 .73323 .40023 .74356 .42245 .73843 .40921 .72768 Metetra
.631 .762 .941 r
.40921 .72768 .42245 .73843 .44485 .73361 .43174 .72241 Metetra
.623 .753 .94 r
.43174 .72241 .44485 .73361 .46745 .72921 .45447 .71751 Metetra
.613 .743 .938 r
.45447 .71751 .46745 .72921 .49026 .7254 .47739 .71313 Metetra
.599 .73 .936 r
.47739 .71313 .49026 .7254 .51328 .72241 .50053 .70948 Metetra
.58 .714 .935 r
.50053 .70948 .51328 .72241 .53655 .72058 .52391 .70684 Metetra
.553 .692 .932 r
.52391 .70684 .53655 .72058 .5601 .72038 .54754 .70559 Metetra
.526 .666 .925 r
.54754 .70559 .5601 .72038 .58396 .72205 .57147 .70583 Metetra
.57 .665 .902 r
.57147 .70583 .58396 .72205 .60811 .72271 .59567 .70437 Metetra
.847 .727 .732 r
.59567 .70437 .60811 .72271 .63145 .68645 .61916 .66639 Metetra
.881 .72 .678 r
.61916 .66639 .63145 .68645 .65342 .61884 .64176 .6087 Metetra
.861 .815 .802 r
.64176 .6087 .65342 .61884 .67658 .5929 .66508 .58094 Metetra
.669 .18 0 r
.66508 .58094 .67658 .5929 .70296 .63047 .69131 .6152 Metetra
.946 .737 .589 r
.69131 .6152 .70296 .63047 .72084 .509 .71024 .50394 Metetra
.532 0 0 r
.71024 .50394 .72084 .509 .74662 .52904 .73607 .5227 Metetra
0 .414 .789 r
.73607 .5227 .74662 .52904 .77239 .54067 .76187 .53269 Metetra
.293 .675 .974 r
.76187 .53269 .77239 .54067 .79806 .54496 .78762 .53578 Metetra
.468 .745 .989 r
.78762 .53578 .79806 .54496 .82377 .5452 .81342 .5351 Metetra
.546 .764 .978 r
.81342 .5351 .82377 .5452 .84958 .54304 .83935 .53219 Metetra
.587 .769 .966 r
.83935 .53219 .84958 .54304 .87555 .53934 .86544 .52786 Metetra
.611 .769 .956 r
.86544 .52786 .87555 .53934 .90168 .53458 .89171 .52254 Metetra
.626 .767 .947 r
.89171 .52254 .90168 .53458 .92801 .52906 .91816 .51652 Metetra
.636 .764 .94 r
.91816 .51652 .92801 .52906 .95453 .52297 .94483 .50995 Metetra
.644 .761 .934 r
.94483 .50995 .95453 .52297 .98127 .51643 .9717 .50296 Metetra
.642 .777 .945 r
.37328 .72309 .38687 .73323 .40921 .72768 .39576 .71709 Metetra
.638 .769 .942 r
.39576 .71709 .40921 .72768 .43174 .72241 .41842 .71132 Metetra
.632 .76 .94 r
.41842 .71132 .43174 .72241 .45447 .71751 .44127 .70588 Metetra
.623 .75 .938 r
.44127 .70588 .45447 .71751 .47739 .71313 .46432 .70089 Metetra
.611 .738 .935 r
.46432 .70089 .47739 .71313 .50053 .70948 .48759 .69652 Metetra
.595 .722 .933 r
.48759 .69652 .50053 .70948 .52391 .70684 .51107 .69303 Metetra
.575 .702 .929 r
.51107 .69303 .52391 .70684 .54754 .70559 .53481 .69067 Metetra
.558 .68 .921 r
.53481 .69067 .54754 .70559 .57147 .70583 .55882 .68937 Metetra
.608 .68 .893 r
.55882 .68937 .57147 .70583 .59567 .70437 .58307 .68567 Metetra
.851 .727 .726 r
.58307 .68567 .59567 .70437 .61916 .66639 .60673 .64584 Metetra
.862 .717 .701 r
.60673 .64584 .61916 .66639 .64176 .6087 .62989 .59817 Metetra
.866 .811 .793 r
.62989 .59817 .64176 .6087 .66508 .58094 .65338 .56879 Metetra
.598 .104 0 r
.65338 .56879 .66508 .58094 .69131 .6152 .67947 .5994 Metetra
.941 .739 .602 r
.67947 .5994 .69131 .6152 .71024 .50394 .69943 .49884 Metetra
.49 0 0 r
.69943 .49884 .71024 .50394 .73607 .5227 .7253 .51617 Metetra
0 .483 .841 r
.7253 .51617 .73607 .5227 .76187 .53269 .75115 .52444 Metetra
.347 .704 .984 r
.75115 .52444 .76187 .53269 .78762 .53578 .77697 .52627 Metetra
.498 .757 .988 r
.77697 .52627 .78762 .53578 .81342 .5351 .80287 .52463 Metetra
.566 .769 .974 r
.80287 .52463 .81342 .5351 .83935 .53219 .82892 .52093 Metetra
.601 .771 .961 r
.82892 .52093 .83935 .53219 .86544 .52786 .85512 .51592 Metetra
.622 .769 .95 r
.85512 .51592 .86544 .52786 .89171 .52254 .88152 .51 Metetra
.635 .765 .941 r
.88152 .51 .89171 .52254 .91816 .51652 .90811 .50342 Metetra
.644 .762 .934 r
.90811 .50342 .91816 .51652 .94483 .50995 .93491 .49634 Metetra
.65 .758 .928 r
.93491 .49634 .94483 .50995 .9717 .50296 .96192 .48886 Metetra
.649 .786 .947 r
.35944 .71326 .37328 .72309 .39576 .71709 .38206 .70675 Metetra
.646 .778 .944 r
.38206 .70675 .39576 .71709 .41842 .71132 .40487 .70044 Metetra
.64 .769 .941 r
.40487 .70044 .41842 .71132 .44127 .70588 .42786 .6944 Metetra
.634 .759 .938 r
.42786 .6944 .44127 .70588 .46432 .70089 .45105 .68873 Metetra
.624 .746 .935 r
.45105 .68873 .46432 .70089 .48759 .69652 .47444 .68359 Metetra
.612 .731 .931 r
.47444 .68359 .48759 .69652 .51107 .69303 .49805 .67916 Metetra
.597 .713 .925 r
.49805 .67916 .51107 .69303 .53481 .69067 .52189 .67561 Metetra
.589 .694 .915 r
.52189 .67561 .53481 .69067 .55882 .68937 .54599 .67266 Metetra
.643 .694 .882 r
.54599 .67266 .55882 .68937 .58307 .68567 .57031 .66655 Metetra
.854 .726 .72 r
.57031 .66655 .58307 .68567 .60673 .64584 .59414 .62469 Metetra
.835 .711 .727 r
.59414 .62469 .60673 .64584 .62989 .59817 .61781 .58711 Metetra
.868 .806 .786 r
.61781 .58711 .62989 .59817 .65338 .56879 .64149 .55643 Metetra
0 0 .502 r
.64149 .55643 .65338 .56879 .67947 .5994 .66743 .58296 Metetra
.934 .741 .618 r
.66743 .58296 .67947 .5994 .69943 .49884 .68839 .4937 Metetra
.438 0 0 r
.68839 .4937 .69943 .49884 .7253 .51617 .71431 .5094 Metetra
.061 .552 .89 r
.71431 .5094 .7253 .51617 .75115 .52444 .7402 .51586 Metetra
.401 .73 .991 r
.7402 .51586 .75115 .52444 .77697 .52627 .7661 .51637 Metetra
.529 .766 .984 r
.7661 .51637 .77697 .52627 .80287 .52463 .79211 .5137 Metetra
.586 .773 .968 r
.79211 .5137 .80287 .52463 .82892 .52093 .81826 .50916 Metetra
.616 .771 .955 r
.81826 .50916 .82892 .52093 .85512 .51592 .84459 .50341 Metetra
.634 .767 .943 r
.84459 .50341 .85512 .51592 .88152 .51 .87111 .49684 Metetra
.645 .763 .934 r
.87111 .49684 .88152 .51 .90811 .50342 .89783 .48966 Metetra
.652 .758 .927 r
.89783 .48966 .90811 .50342 .93491 .49634 .92476 .48201 Metetra
.658 .753 .92 r
.92476 .48201 .93491 .49634 .96192 .48886 .9519 .474 Metetra
.657 .799 .951 r
.34534 .70389 .35944 .71326 .38206 .70675 .36812 .6968 Metetra
.654 .79 .947 r
.36812 .6968 .38206 .70675 .40487 .70044 .39108 .68987 Metetra
.65 .78 .943 r
.39108 .68987 .40487 .70044 .42786 .6944 .41422 .68315 Metetra
.645 .769 .939 r
.41422 .68315 .42786 .6944 .45105 .68873 .43755 .67674 Metetra
.638 .756 .934 r
.43755 .67674 .45105 .68873 .47444 .68359 .46108 .67073 Metetra
.629 .741 .928 r
.46108 .67073 .47444 .68359 .49805 .67916 .48482 .66526 Metetra
.619 .724 .921 r
.48482 .66526 .49805 .67916 .52189 .67561 .50878 .6604 Metetra
.619 .706 .907 r
.50878 .6604 .52189 .67561 .54599 .67266 .53298 .65565 Metetra
.677 .704 .868 r
.53298 .65565 .54599 .67266 .57031 .66655 .55739 .64687 Metetra
.858 .724 .714 r
.55739 .64687 .57031 .66655 .59414 .62469 .58141 .6028 Metetra
.796 .698 .757 r
.58141 .6028 .59414 .62469 .61781 .58711 .6055 .57526 Metetra
.867 .799 .781 r
.6055 .57526 .61781 .58711 .64149 .55643 .6294 .54386 Metetra
0 .13 .633 r
.6294 .54386 .64149 .55643 .66743 .58296 .65521 .56576 Metetra
.924 .743 .638 r
.65521 .56576 .66743 .58296 .68839 .4937 .67712 .48854 Metetra
.372 0 0 r
.67712 .48854 .68839 .4937 .71431 .5094 .70308 .50235 Metetra
.162 .62 .933 r
.70308 .50235 .71431 .5094 .7402 .51586 .72902 .50689 Metetra
.454 .752 .993 r
.72902 .50689 .7402 .51586 .7661 .51637 .75501 .50598 Metetra
.56 .774 .978 r
.75501 .50598 .7661 .51637 .79211 .5137 .78112 .50221 Metetra
.607 .774 .961 r
.78112 .50221 .79211 .5137 .81826 .50916 .80738 .49675 Metetra
.631 .77 .946 r
.80738 .49675 .81826 .50916 .84459 .50341 .83383 .49021 Metetra
.646 .764 .935 r
.83383 .49021 .84459 .50341 .87111 .49684 .86047 .4829 Metetra
.655 .758 .925 r
.86047 .4829 .87111 .49684 .89783 .48966 .88731 .47505 Metetra
.661 .752 .917 r
.88731 .47505 .89783 .48966 .92476 .48201 .91436 .46677 Metetra
.665 .746 .911 r
.91436 .46677 .92476 .48201 .9519 .474 .94162 .45815 Metetra
.665 .816 .956 r
.33095 .69523 .34534 .70389 .36812 .6968 .3539 .68746 Metetra
.664 .806 .951 r
.3539 .68746 .36812 .6968 .39108 .68987 .37702 .6798 Metetra
.662 .794 .946 r
.37702 .6798 .39108 .68987 .41422 .68315 .40033 .6723 Metetra
.658 .782 .94 r
.40033 .6723 .41422 .68315 .43755 .67674 .42382 .66501 Metetra
.653 .768 .933 r
.42382 .66501 .43755 .67674 .46108 .67073 .4475 .65802 Metetra
.648 .752 .926 r
.4475 .65802 .46108 .67073 .48482 .66526 .47138 .65137 Metetra
.643 .735 .915 r
.47138 .65137 .48482 .66526 .50878 .6604 .49548 .64501 Metetra
.65 .718 .897 r
.49548 .64501 .50878 .6604 .53298 .65565 .51979 .63822 Metetra
.708 .712 .852 r
.51979 .63822 .53298 .65565 .55739 .64687 .5443 .62644 Metetra
.86 .721 .707 r
.5443 .62644 .55739 .64687 .58141 .6028 .56852 .57996 Metetra
.739 .674 .788 r
.56852 .57996 .58141 .6028 .6055 .57526 .59296 .56219 Metetra
.859 .787 .78 r
.59296 .56219 .6055 .57526 .6294 .54386 .61711 .53109 Metetra
0 .301 .778 r
.61711 .53109 .6294 .54386 .65521 .56576 .64279 .54763 Metetra
.909 .743 .664 r
.64279 .54763 .65521 .56576 .67712 .48854 .66561 .48333 Metetra
0 .294 .649 r
.66561 .48333 .67712 .48854 .70308 .50235 .69161 .49495 Metetra
.267 .683 .967 r
.69161 .49495 .70308 .50235 .72902 .50689 .71761 .4974 Metetra
.507 .77 .991 r
.71761 .4974 .72902 .50689 .75501 .50598 .74368 .49498 Metetra
.59 .779 .97 r
.74368 .49498 .75501 .50598 .78112 .50221 .76989 .49 Metetra
.628 .773 .95 r
.76989 .49 .78112 .50221 .80738 .49675 .79626 .48352 Metetra
.647 .766 .935 r
.79626 .48352 .80738 .49675 .83383 .49021 .82281 .47607 Metetra
.658 .758 .923 r
.82281 .47607 .83383 .49021 .86047 .4829 .84956 .46795 Metetra
.665 .75 .913 r
.84956 .46795 .86047 .4829 .88731 .47505 .87651 .45933 Metetra
.67 .742 .905 r
.87651 .45933 .88731 .47505 .91436 .46677 .90367 .45032 Metetra
.673 .736 .897 r
.90367 .45032 .91436 .46677 .94162 .45815 .93104 .44099 Metetra
.675 .839 .962 r
.31622 .68763 .33095 .69523 .3539 .68746 .33937 .67902 Metetra
.676 .827 .956 r
.33937 .67902 .3539 .68746 .37702 .6798 .36268 .67048 Metetra
.675 .813 .949 r
.36268 .67048 .37702 .6798 .40033 .6723 .38617 .66202 Metetra
.674 .798 .941 r
.38617 .66202 .40033 .6723 .42382 .66501 .40984 .65369 Metetra
.672 .782 .932 r
.40984 .65369 .42382 .66501 .4475 .65802 .43369 .64551 Metetra
.669 .765 .922 r
.43369 .64551 .4475 .65802 .47138 .65137 .45774 .63746 Metetra
.67 .745 .907 r
.45774 .63746 .47138 .65137 .49548 .64501 .48198 .62933 Metetra
.682 .727 .883 r
.48198 .62933 .49548 .64501 .51979 .63822 .50643 .62014 Metetra
.738 .716 .831 r
.50643 .62014 .51979 .63822 .5443 .62644 .53105 .60486 Metetra
.861 .716 .7 r
.53105 .60486 .5443 .62644 .56852 .57996 .55548 .55585 Metetra
.661 .635 .813 r
.55548 .55585 .56852 .57996 .59296 .56219 .58018 .5471 Metetra
.839 .768 .784 r
.58018 .5471 .59296 .56219 .61711 .53109 .6046 .5181 Metetra
.126 .491 .903 r
.6046 .5181 .61711 .53109 .64279 .54763 .63016 .52835 Metetra
.883 .739 .698 r
.63016 .52835 .64279 .54763 .66561 .48333 .65385 .47807 Metetra
0 .4 .736 r
.65385 .47807 .66561 .48333 .69161 .49495 .67989 .48705 Metetra
.373 .737 .99 r
.67989 .48705 .69161 .49495 .71761 .4974 .70595 .48723 Metetra
.559 .783 .983 r
.70595 .48723 .71761 .4974 .74368 .49498 .7321 .48312 Metetra
.621 .779 .957 r
.7321 .48312 .74368 .49498 .76989 .49 .75839 .47679 Metetra
.649 .768 .936 r
.75839 .47679 .76989 .49 .79626 .48352 .78486 .46915 Metetra
.663 .757 .92 r
.78486 .46915 .79626 .48352 .82281 .47607 .81151 .46066 Metetra
.671 .747 .908 r
.81151 .46066 .82281 .47607 .84956 .46795 .83836 .45157 Metetra
.676 .737 .897 r
.83836 .45157 .84956 .46795 .87651 .45933 .8654 .44204 Metetra
.678 .728 .888 r
.8654 .44204 .87651 .45933 .90367 .45032 .89264 .43216 Metetra
.68 .72 .88 r
.89264 .43216 .90367 .45032 .93104 .44099 .92009 .422 Metetra
.687 .87 .968 r
.30112 .68154 .31622 .68763 .33937 .67902 .32449 .67186 Metetra
.691 .854 .961 r
.32449 .67186 .33937 .67902 .36268 .67048 .34803 .66218 Metetra
.693 .836 .952 r
.34803 .66218 .36268 .67048 .38617 .66202 .37173 .6525 Metetra
.694 .818 .941 r
.37173 .6525 .38617 .66202 .40984 .65369 .3956 .64284 Metetra
.694 .797 .929 r
.3956 .64284 .40984 .65369 .43369 .64551 .41964 .63314 Metetra
.695 .776 .914 r
.41964 .63314 .43369 .64551 .45774 .63746 .44387 .62332 Metetra
.699 .753 .894 r
.44387 .62332 .45774 .63746 .48198 .62933 .46828 .61298 Metetra
.715 .73 .863 r
.46828 .61298 .48198 .62933 .50643 .62014 .49288 .60079 Metetra
.764 .714 .805 r
.49288 .60079 .50643 .62014 .53105 .60486 .51765 .58127 Metetra
.858 .706 .692 r
.51765 .58127 .53105 .60486 .55548 .55585 .54231 .53004 Metetra
.576 .584 .823 r
.54231 .53004 .55548 .55585 .58018 .5471 .56716 .52855 Metetra
.795 .732 .794 r
.56716 .52855 .58018 .5471 .6046 .5181 .59189 .50488 Metetra
.402 .653 .96 r
.59189 .50488 .6046 .5181 .63016 .52835 .61733 .50775 Metetra
.837 .727 .743 r
.61733 .50775 .63016 .52835 .65385 .47807 .64183 .47267 Metetra
0 .532 .837 r
.64183 .47267 .65385 .47807 .67989 .48705 .6679 .4784 Metetra
.479 .779 .997 r
.6679 .4784 .67989 .48705 .70595 .48723 .69401 .47603 Metetra
.609 .788 .967 r
.69401 .47603 .70595 .48723 .7321 .48312 .72023 .47 Metetra
.652 .773 .937 r
.72023 .47 .7321 .48312 .75839 .47679 .74661 .46209 Metetra
.67 .757 .915 r
.74661 .46209 .75839 .47679 .78486 .46915 .77316 .45307 Metetra
.679 .742 .899 r
.77316 .45307 .78486 .46915 .81151 .46066 .79988 .44331 Metetra
.683 .729 .885 r
.79988 .44331 .81151 .46066 .83836 .45157 .82679 .43304 Metetra
.685 .717 .874 r
.82679 .43304 .83836 .45157 .8654 .44204 .85389 .42239 Metetra
.686 .707 .863 r
.85389 .42239 .8654 .44204 .89264 .43216 .88119 .41142 Metetra
.686 .697 .854 r
.88119 .41142 .89264 .43216 .92009 .422 .90868 .40021 Metetra
.704 .904 .967 r
.28558 .67725 .30112 .68154 .32449 .67186 .30923 .66608 Metetra
.713 .882 .959 r
.30923 .66608 .32449 .67186 .34803 .66218 .33303 .65482 Metetra
.718 .858 .948 r
.33303 .65482 .34803 .66218 .37173 .6525 .35698 .64346 Metetra
.721 .832 .933 r
.35698 .64346 .37173 .6525 .3956 .64284 .3811 .63195 Metetra
.723 .805 .915 r
.3811 .63195 .3956 .64284 .41964 .63314 .40537 .62019 Metetra
.725 .776 .893 r
.40537 .62019 .41964 .63314 .44387 .62332 .42981 .60794 Metetra
.729 .747 .866 r
.42981 .60794 .44387 .62332 .46828 .61298 .45442 .5946 Metetra
.744 .718 .828 r
.45442 .5946 .46828 .61298 .49288 .60079 .4792 .57845 Metetra
.781 .696 .771 r
.4792 .57845 .49288 .60079 .51765 .58127 .50413 .55369 Metetra
.844 .687 .687 r
.50413 .55369 .51765 .58127 .54231 .53004 .529 .50225 Metetra
.526 .544 .817 r
.529 .50225 .54231 .53004 .56716 .52855 .55391 .5045 Metetra
.699 .657 .805 r
.55391 .5045 .56716 .52855 .59189 .50488 .57895 .49144 Metetra
.614 .748 .941 r
.57895 .49144 .59189 .50488 .61733 .50775 .60432 .48594 Metetra
.752 .698 .8 r
.60432 .48594 .61733 .50775 .64183 .47267 .62953 .46686 Metetra
.212 .684 .939 r
.62953 .46686 .64183 .47267 .6679 .4784 .65562 .46852 Metetra
.58 .802 .984 r
.65562 .46852 .6679 .4784 .69401 .47603 .68178 .46316 Metetra
.658 .78 .939 r
.68178 .46316 .69401 .47603 .72023 .47 .70806 .45482 Metetra
.682 .755 .907 r
.70806 .45482 .72023 .47 .74661 .46209 .73448 .44495 Metetra
.69 .734 .884 r
.73448 .44495 .74661 .46209 .77316 .45307 .76107 .43417 Metetra
.693 .716 .866 r
.76107 .43417 .77316 .45307 .79988 .44331 .78783 .42278 Metetra
.693 .7 .852 r
.78783 .42278 .79988 .44331 .82679 .43304 .81476 .41097 Metetra
.692 .686 .839 r
.81476 .41097 .82679 .43304 .85389 .42239 .84186 .39884 Metetra
.69 .673 .828 r
.84186 .39884 .85389 .42239 .88119 .41142 .86915 .38644 Metetra
.688 .661 .818 r
.86915 .38644 .88119 .41142 .90868 .40021 .89661 .37383 Metetra
.748 .888 .943 r
.26979 .67182 .28558 .67725 .30923 .66608 .29377 .65845 Metetra
.751 .855 .927 r
.29377 .65845 .30923 .66608 .33303 .65482 .31788 .64489 Metetra
.751 .82 .906 r
.31788 .64489 .33303 .65482 .35698 .64346 .34213 .63106 Metetra
.748 .786 .883 r
.34213 .63106 .35698 .64346 .3811 .63195 .36652 .61685 Metetra
.744 .752 .858 r
.36652 .61685 .3811 .63195 .40537 .62019 .39105 .60206 Metetra
.741 .719 .831 r
.39105 .60206 .40537 .62019 .42981 .60794 .41573 .58629 Metetra
.741 .689 .801 r
.41573 .58629 .42981 .60794 .45442 .5946 .44055 .56869 Metetra
.749 .663 .766 r
.44055 .56869 .45442 .5946 .4792 .57845 .46551 .54729 Metetra
.77 .646 .725 r
.46551 .54729 .4792 .57845 .50413 .55369 .49058 .51718 Metetra
.793 .638 .689 r
.49058 .51718 .50413 .55369 .529 .50225 .51559 .47484 Metetra
.528 .55 .821 r
.51559 .47484 .529 .50225 .55391 .5045 .5405 .47661 Metetra
.538 .553 .818 r
.5405 .47661 .55391 .5045 .57895 .49144 .56579 .47776 Metetra
.732 .783 .893 r
.56579 .47776 .57895 .49144 .60432 .48594 .59115 .46446 Metetra
.608 .646 .862 r
.59115 .46446 .60432 .48594 .62953 .46686 .61692 .45989 Metetra
.474 .812 .999 r
.61692 .45989 .62953 .46686 .65562 .46852 .64302 .45626 Metetra
.669 .795 .942 r
.64302 .45626 .65562 .46852 .68178 .46316 .66919 .44713 Metetra
.7 .751 .891 r
.66919 .44713 .68178 .46316 .70806 .45482 .69548 .43574 Metetra
.705 .718 .859 r
.69548 .43574 .70806 .45482 .73448 .44495 .7219 .4232 Metetra
.704 .692 .836 r
.7219 .4232 .73448 .44495 .76107 .43417 .74846 .40998 Metetra
.7 .67 .817 r
.74846 .40998 .76107 .43417 .78783 .42278 .77516 .39633 Metetra
.696 .652 .802 r
.77516 .39633 .78783 .42278 .81476 .41097 .80202 .38238 Metetra
.691 .636 .79 r
.80202 .38238 .81476 .41097 .84186 .39884 .82903 .36819 Metetra
.687 .623 .779 r
.82903 .36819 .84186 .39884 .86915 .38644 .85619 .35381 Metetra
.683 .61 .769 r
.85619 .35381 .86915 .38644 .89661 .37383 .88352 .33928 Metetra
.667 .55 .713 r
.2566 .62855 .26979 .67182 .29377 .65845 .28065 .61349 Metetra
.666 .545 .708 r
.28065 .61349 .29377 .65845 .31788 .64489 .30481 .59809 Metetra
.665 .54 .703 r
.30481 .59809 .31788 .64489 .34213 .63106 .3291 .58226 Metetra
.664 .535 .697 r
.3291 .58226 .34213 .63106 .36652 .61685 .35352 .56586 Metetra
.664 .531 .692 r
.35352 .56586 .36652 .61685 .39105 .60206 .37805 .54869 Metetra
.665 .527 .686 r
.37805 .54869 .39105 .60206 .41573 .58629 .40271 .53044 Metetra
.667 .524 .68 r
.40271 .53044 .41573 .58629 .44055 .56869 .42747 .51067 Metetra
.671 .523 .674 r
.42747 .51067 .44055 .56869 .46551 .54729 .45231 .48911 Metetra
.668 .52 .674 r
.45231 .48911 .46551 .54729 .49058 .51718 .47717 .46817 Metetra
.542 .46 .712 r
.47717 .46817 .49058 .51718 .51559 .47484 .50189 .47059 Metetra
.031 .58 .833 r
.50189 .47059 .51559 .47484 .5405 .47661 .52699 .47389 Metetra
.601 .924 .969 r
.52699 .47389 .5405 .47661 .56579 .47776 .55239 .46384 Metetra
.746 .786 .885 r
.55239 .46384 .56579 .47776 .59115 .46446 .57792 .44912 Metetra
.49 .674 .946 r
.57792 .44912 .59115 .46446 .61692 .45989 .60395 .44931 Metetra
.697 .832 .948 r
.60395 .44931 .61692 .45989 .64302 .45626 .63 .43831 Metetra
.729 .738 .858 r
.63 .43831 .64302 .45626 .66919 .44713 .6561 .42377 Metetra
.72 .683 .814 r
.6561 .42377 .66919 .44713 .69548 .43574 .68231 .40812 Metetra
.709 .648 .787 r
.68231 .40812 .69548 .43574 .7219 .4232 .70862 .3921 Metetra
.699 .624 .769 r
.70862 .3921 .7219 .4232 .74846 .40998 .73506 .37599 Metetra
.691 .606 .756 r
.73506 .37599 .74846 .40998 .77516 .39633 .76164 .35985 Metetra
.684 .591 .746 r
.76164 .35985 .77516 .39633 .80202 .38238 .78835 .34371 Metetra
.679 .58 .738 r
.78835 .34371 .80202 .38238 .82903 .36819 .8152 .32757 Metetra
.674 .571 .731 r
.8152 .32757 .82903 .36819 .85619 .35381 .84218 .31143 Metetra
.67 .563 .725 r
.84218 .31143 .85619 .35381 .88352 .33928 .86932 .29527 Metetra
.582 .438 .651 r
.24609 .553 .2566 .62855 .28065 .61349 .2691 .54816 Metetra
.588 .455 .667 r
.2691 .54816 .28065 .61349 .30481 .59809 .29236 .54304 Metetra
.596 .478 .689 r
.29236 .54304 .30481 .59809 .3291 .58226 .31589 .53752 Metetra
.608 .511 .719 r
.31589 .53752 .3291 .58226 .35352 .56586 .33969 .53134 Metetra
.627 .561 .761 r
.33969 .53134 .35352 .56586 .37805 .54869 .36377 .52407 Metetra
.661 .638 .816 r
.36377 .52407 .37805 .54869 .40271 .53044 .38816 .51491 Metetra
.718 .749 .876 r
.38816 .51491 .40271 .53044 .42747 .51067 .41286 .50243 Metetra
.796 .863 .898 r
.41286 .50243 .42747 .51067 .45231 .48911 .43785 .4846 Metetra
.838 .918 .888 r
.43785 .4846 .45231 .48911 .47717 .46817 .46299 .46312 Metetra
.025 .568 .841 r
.46299 .46312 .47717 .46817 .50189 .47059 .48786 .46707 Metetra
.708 .94 .96 r
.48786 .46707 .50189 .47059 .52699 .47389 .51322 .45368 Metetra
.595 .658 .881 r
.51322 .45368 .52699 .47389 .55239 .46384 .53876 .44967 Metetra
.641 .757 .933 r
.53876 .44967 .55239 .46384 .57792 .44912 .56458 .44231 Metetra
.752 .904 .945 r
.56458 .44231 .57792 .44912 .60395 .44931 .59049 .42733 Metetra
.626 .657 .86 r
.59049 .42733 .60395 .44931 .63 .43831 .6168 .42107 Metetra
.5 .657 .93 r
.6168 .42107 .63 .43831 .6561 .42377 .64363 .42129 Metetra
.08 .632 .82 r
.64363 .42129 .6561 .42377 .68231 .40812 .67089 .42212 Metetra
.382 0 0 r
.67089 .42212 .68231 .40812 .70862 .3921 .69852 .42199 Metetra
.465 .079 .222 r
.69852 .42199 .70862 .3921 .73506 .37599 .7265 .42075 Metetra
.489 .151 .32 r
.7265 .42075 .73506 .37599 .76164 .35985 .75481 .41856 Metetra
.5 .188 .369 r
.75481 .41856 .76164 .35985 .78835 .34371 .78347 .4156 Metetra
.507 .212 .399 r
.78347 .4156 .78835 .34371 .8152 .32757 .81246 .41204 Metetra
.512 .228 .419 r
.81246 .41204 .8152 .32757 .84218 .31143 .84179 .40801 Metetra
.516 .239 .433 r
.84179 .40801 .84218 .31143 .86932 .29527 .87148 .40358 Metetra
.624 .562 .765 r
.23222 .51974 .24609 .553 .2691 .54816 .25534 .51307 Metetra
.621 .553 .757 r
.25534 .51307 .2691 .54816 .29236 .54304 .27869 .50633 Metetra
.62 .546 .75 r
.27869 .50633 .29236 .54304 .31589 .53752 .30225 .49952 Metetra
.618 .541 .745 r
.30225 .49952 .31589 .53752 .33969 .53134 .32604 .49266 Metetra
.618 .538 .743 r
.32604 .49266 .33969 .53134 .36377 .52407 .35006 .48572 Metetra
.618 .541 .745 r
.35006 .48572 .36377 .52407 .38816 .51491 .37431 .47872 Metetra
.621 .552 .756 r
.37431 .47872 .38816 .51491 .41286 .50243 .3988 .47165 Metetra
.629 .585 .786 r
.3988 .47165 .41286 .50243 .43785 .4846 .42352 .46451 Metetra
.642 .678 .868 r
.42352 .46451 .43785 .4846 .46299 .46312 .44849 .45731 Metetra
.577 .872 .995 r
.44849 .45731 .46299 .46312 .48786 .46707 .4737 .45003 Metetra
.644 .718 .902 r
.4737 .45003 .48786 .46707 .51322 .45368 .49917 .44267 Metetra
.63 .806 .967 r
.49917 .44267 .51322 .45368 .53876 .44967 .52489 .43525 Metetra
.641 .757 .933 r
.52489 .43525 .53876 .44967 .56458 .44231 .55086 .42775 Metetra
.641 .757 .933 r
.55086 .42775 .56458 .44231 .59049 .42733 .5771 .42018 Metetra
.589 .864 .994 r
.5771 .42018 .59049 .42733 .6168 .42107 .6036 .41253 Metetra
.606 .849 .99 r
.6036 .41253 .6168 .42107 .64363 .42129 .63037 .4048 Metetra
.643 .736 .917 r
.63037 .4048 .64363 .42129 .67089 .42212 .65742 .39699 Metetra
.638 .642 .837 r
.65742 .39699 .67089 .42212 .69852 .42199 .68474 .3891 Metetra
.628 .584 .785 r
.68474 .3891 .69852 .42199 .7265 .42075 .71235 .38113 Metetra
.62 .548 .752 r
.71235 .38113 .7265 .42075 .75481 .41856 .74024 .37308 Metetra
.614 .524 .729 r
.74024 .37308 .75481 .41856 .78347 .4156 .76842 .36494 Metetra
.609 .507 .713 r
.76842 .36494 .78347 .4156 .81246 .41204 .7969 .35672 Metetra
.605 .494 .7 r
.7969 .35672 .81246 .41204 .84179 .40801 .82567 .34841 Metetra
.602 .484 .69 r
.82567 .34841 .84179 .40801 .87148 .40358 .85476 .34002 Metetra
.314 0 .146 r
.21226 .55134 .23222 .51974 .25534 .51307 .2361 .54117 Metetra
.275 0 .092 r
.2361 .54117 .25534 .51307 .27869 .50633 .26014 .53062 Metetra
.216 0 .014 r
.26014 .53062 .27869 .50633 .30225 .49952 .2844 .51957 Metetra
.123 0 0 r
.2844 .51957 .30225 .49952 .32604 .49266 .30886 .50791 Metetra
.30886 .50791 .32604 .49266 .35006 .48572 .33353 .49547 Metetra
.33353 .49547 .35006 .48572 .37431 .47872 .35841 .48205 Metetra
.61 .956 .867 r
.35841 .48205 .37431 .47872 .3988 .47165 .38348 .46747 Metetra
.761 .93 .942 r
.38348 .46747 .3988 .47165 .42352 .46451 .40872 .45187 Metetra
.753 .803 .893 r
.40872 .45187 .42352 .46451 .44849 .45731 .43407 .43679 Metetra
.659 .684 .863 r
.43407 .43679 .44849 .45731 .4737 .45003 .45941 .42809 Metetra
.524 .611 .882 r
.45941 .42809 .4737 .45003 .49917 .44267 .48488 .42813 Metetra
.641 .757 .933 r
.48488 .42813 .49917 .44267 .52489 .43525 .51076 .42057 Metetra
.693 .773 .913 r
.51076 .42057 .52489 .43525 .55086 .42775 .53689 .4096 Metetra
.533 .666 .922 r
.53689 .4096 .55086 .42775 .5771 .42018 .56334 .40816 Metetra
.793 .836 .884 r
.56334 .40816 .5771 .42018 .6036 .41253 .58981 .389 Metetra
.395 .531 .875 r
.58981 .389 .6036 .41253 .63037 .4048 .61711 .39593 Metetra
.223 .653 .955 r
.61711 .39593 .63037 .4048 .65742 .39699 .64481 .39922 Metetra
.64481 .39922 .65742 .39699 .68474 .3891 .67274 .39705 Metetra
.085 0 0 r
.67274 .39705 .68474 .3891 .71235 .38113 .70089 .39145 Metetra
.097 0 0 r
.70089 .39145 .71235 .38113 .74024 .37308 .72925 .38387 Metetra
.08 0 0 r
.72925 .38387 .74024 .37308 .76842 .36494 .75784 .37512 Metetra
.044 0 0 r
.75784 .37512 .76842 .36494 .7969 .35672 .78667 .36564 Metetra
.78667 .36564 .7969 .35672 .82567 .34841 .81576 .35568 Metetra
.81576 .35568 .82567 .34841 .85476 .34002 .84511 .3454 Metetra
.544 .371 .597 r
.20751 .41972 .21226 .55134 .2361 .54117 .2297 .42021 Metetra
.544 .376 .603 r
.2297 .42021 .2361 .54117 .26014 .53062 .2522 .42077 Metetra
.544 .382 .611 r
.2522 .42077 .26014 .53062 .2844 .51957 .27502 .4214 Metetra
.545 .39 .621 r
.27502 .4214 .2844 .51957 .30886 .50791 .29816 .42213 Metetra
.545 .4 .635 r
.29816 .42213 .30886 .50791 .33353 .49547 .32164 .42295 Metetra
.544 .415 .655 r
.32164 .42295 .33353 .49547 .35841 .48205 .34546 .42383 Metetra
.544 .44 .686 r
.34546 .42383 .35841 .48205 .38348 .46747 .36964 .4247 Metetra
.543 .483 .739 r
.36964 .4247 .38348 .46747 .40872 .45187 .3942 .42531 Metetra
.541 .576 .839 r
.3942 .42531 .40872 .45187 .43407 .43679 .41915 .42487 Metetra
.548 .765 .978 r
.41915 .42487 .43407 .43679 .45941 .42809 .44456 .42096 Metetra
.755 .897 .941 r
.44456 .42096 .45941 .42809 .48488 .42813 .47046 .40574 Metetra
.524 .611 .882 r
.47046 .40574 .48488 .42813 .51076 .42057 .49638 .40562 Metetra
.585 .737 .948 r
.49638 .40562 .51076 .42057 .53689 .4096 .52268 .40079 Metetra
.794 .883 .911 r
.52268 .40079 .53689 .4096 .56334 .40816 .5492 .38225 Metetra
.727 .674 .799 r
.5492 .38225 .56334 .40816 .58981 .389 .57583 .36451 Metetra
.408 .531 .87 r
.57583 .36451 .58981 .389 .61711 .39593 .60316 .37093 Metetra
.397 .522 .866 r
.60316 .37093 .61711 .39593 .64481 .39922 .63105 .37815 Metetra
.397 .568 .905 r
.63105 .37815 .64481 .39922 .67274 .39705 .65943 .38365 Metetra
.317 .638 .965 r
.65943 .38365 .67274 .39705 .70089 .39145 .68828 .38769 Metetra
.032 .587 .82 r
.68828 .38769 .70089 .39145 .72925 .38387 .71759 .39069 Metetra
.297 0 0 r
.71759 .39069 .72925 .38387 .75784 .37512 .74738 .39299 Metetra
.425 0 .023 r
.74738 .39299 .75784 .37512 .78667 .36564 .77765 .39477 Metetra
.471 .062 .182 r
.77765 .39477 .78667 .36564 .81576 .35568 .80841 .39619 Metetra
.491 .123 .268 r
.80841 .39619 .81576 .35568 .84511 .3454 .83967 .39733 Metetra
.336 0 0 r
.18878 .43291 .20751 .41972 .2297 .42021 .21135 .43203 Metetra
.312 0 0 r
.21135 .43203 .2297 .42021 .2522 .42077 .23424 .43108 Metetra
.28 0 0 r
.23424 .43108 .2522 .42077 .27502 .4214 .25744 .43001 Metetra
.237 0 0 r
.25744 .43001 .27502 .4214 .29816 .42213 .28098 .42879 Metetra
.173 0 0 r
.28098 .42879 .29816 .42213 .32164 .42295 .30484 .42733 Metetra
.078 0 0 r
.30484 .42733 .32164 .42295 .34546 .42383 .32906 .4255 Metetra
.32906 .4255 .34546 .42383 .36964 .4247 .35363 .42306 Metetra
.277 .773 .89 r
.35363 .42306 .36964 .4247 .3942 .42531 .37857 .41952 Metetra
.513 .852 .995 r
.37857 .41952 .3942 .42531 .41915 .42487 .4039 .41373 Metetra
.7 .827 .943 r
.4039 .41373 .41915 .42487 .44456 .42096 .42969 .40236 Metetra
.68 .722 .881 r
.42969 .40236 .44456 .42096 .47046 .40574 .45566 .39191 Metetra
.493 .718 .971 r
.45566 .39191 .47046 .40574 .49638 .40562 .48173 .3904 Metetra
.754 .787 .88 r
.48173 .3904 .49638 .40562 .52268 .40079 .50825 .37402 Metetra
.719 .666 .797 r
.50825 .37402 .52268 .40079 .5492 .38225 .53489 .3569 Metetra
0 .132 .68 r
.53489 .3569 .5492 .38225 .57583 .36451 .5622 .38571 Metetra
.617 .178 .184 r
.5622 .38571 .57583 .36451 .60316 .37093 .59017 .4021 Metetra
.535 .135 .23 r
.59017 .4021 .60316 .37093 .63105 .37815 .61861 .40957 Metetra
.497 .097 .213 r
.61861 .40957 .63105 .37815 .65943 .38365 .64748 .41315 Metetra
.473 .064 .184 r
.64748 .41315 .65943 .38365 .68828 .38769 .67679 .4149 Metetra
.454 .034 .152 r
.67679 .4149 .68828 .38769 .71759 .39069 .70655 .41569 Metetra
.437 .005 .119 r
.70655 .41569 .71759 .39069 .74738 .39299 .73677 .41594 Metetra
.421 0 .085 r
.73677 .41594 .74738 .39299 .77765 .39477 .76747 .41585 Metetra
.406 0 .05 r
.76747 .41585 .77765 .39477 .80841 .39619 .79865 .41554 Metetra
.391 0 .014 r
.79865 .41554 .80841 .39619 .83967 .39733 .83033 .41508 Metetra
.024 0 0 r
.17039 .43737 .18878 .43291 .21135 .43203 .19334 .43478 Metetra
.19334 .43478 .21135 .43203 .23424 .43108 .2166 .43203 Metetra
.146 .69 .771 r
.2166 .43203 .23424 .43108 .25744 .43001 .24016 .42907 Metetra
.243 .754 .865 r
.24016 .42907 .25744 .43001 .28098 .42879 .26404 .42585 Metetra
.341 .801 .939 r
.26404 .42585 .28098 .42879 .30484 .42733 .28825 .42225 Metetra
.435 .826 .985 r
.28825 .42225 .30484 .42733 .32906 .4255 .31279 .41808 Metetra
.52 .83 1 r
.31279 .41808 .32906 .4255 .35363 .42306 .33767 .41303 Metetra
.597 .817 .984 r
.33767 .41303 .35363 .42306 .37857 .41952 .36293 .40644 Metetra
.671 .792 .939 r
.36293 .40644 .37857 .41952 .4039 .41373 .38858 .39683 Metetra
.753 .762 .86 r
.38858 .39683 .4039 .41373 .42969 .40236 .41471 .37998 Metetra
.415 .563 .893 r
.41471 .37998 .42969 .40236 .45566 .39191 .4404 .38442 Metetra
.635 .877 .986 r
.4404 .38442 .45566 .39191 .48173 .3904 .46681 .37489 Metetra
.506 .703 .959 r
.46681 .37489 .48173 .3904 .50825 .37402 .49339 .37322 Metetra
.727 .978 .917 r
.49339 .37322 .50825 .37402 .53489 .3569 .52038 .35556 Metetra
.798 .308 .026 r
.52038 .35556 .53489 .3569 .5622 .38571 .54789 .39439 Metetra
.525 0 0 r
.54789 .39439 .5622 .38571 .59017 .4021 .57608 .40547 Metetra
.203 0 0 r
.57608 .40547 .59017 .4021 .61861 .40957 .60468 .40756 Metetra
.118 .665 .82 r
.60468 .40756 .61861 .40957 .64748 .41315 .63368 .40672 Metetra
.327 .765 .966 r
.63368 .40672 .64748 .41315 .67679 .4149 .6631 .40477 Metetra
.434 .771 .997 r
.6631 .40477 .67679 .4149 .70655 .41569 .69293 .40233 Metetra
.489 .748 .986 r
.69293 .40233 .70655 .41569 .73677 .41594 .7232 .39966 Metetra
.519 .72 .964 r
.7232 .39966 .73677 .41594 .76747 .41585 .75391 .39687 Metetra
.536 .692 .94 r
.75391 .39687 .76747 .41585 .79865 .41554 .78509 .39401 Metetra
.547 .668 .917 r
.78509 .39401 .79865 .41554 .83033 .41508 .81673 .39109 Metetra
.379 .816 .956 r
.15236 .43415 .17039 .43737 .19334 .43478 .17561 .43029 Metetra
.425 .826 .98 r
.17561 .43029 .19334 .43478 .2166 .43203 .19916 .42622 Metetra
.468 .83 .994 r
.19916 .42622 .2166 .43203 .24016 .42907 .22301 .42188 Metetra
.508 .827 1 r
.22301 .42188 .24016 .42907 .26404 .42585 .24717 .41719 Metetra
.545 .82 .997 r
.24717 .41719 .26404 .42585 .28825 .42225 .27165 .41201 Metetra
.581 .808 .986 r
.27165 .41201 .28825 .42225 .31279 .41808 .29646 .40611 Metetra
.618 .794 .966 r
.29646 .40611 .31279 .41808 .33767 .41303 .32161 .39909 Metetra
.66 .778 .936 r
.32161 .39909 .33767 .41303 .36293 .40644 .34714 .39014 Metetra
.711 .761 .892 r
.34714 .39014 .36293 .40644 .38858 .39683 .37309 .37742 Metetra
.776 .743 .822 r
.37309 .37742 .38858 .39683 .41471 .37998 .39956 .35624 Metetra
0 .227 .748 r
.39956 .35624 .41471 .37998 .4404 .38442 .42475 .37736 Metetra
.787 .909 .925 r
.42475 .37736 .4404 .38442 .46681 .37489 .4516 .35909 Metetra
.129 .493 .904 r
.4516 .35909 .46681 .37489 .49339 .37322 .47816 .36861 Metetra
.689 .936 .965 r
.47816 .36861 .49339 .37322 .52038 .35556 .50544 .35484 Metetra
.797 .309 .035 r
.50544 .35484 .52038 .35556 .54789 .39439 .53306 .39398 Metetra
.226 0 0 r
.53306 .39398 .54789 .39439 .57608 .40547 .56142 .39968 Metetra
.31 .763 .956 r
.56142 .39968 .57608 .40547 .60468 .40756 .59019 .39761 Metetra
.479 .796 .999 r
.59019 .39761 .60468 .40756 .63368 .40672 .61933 .39357 Metetra
.533 .773 .986 r
.61933 .39357 .63368 .40672 .6631 .40477 .64887 .389 Metetra
.555 .744 .965 r
.64887 .389 .6631 .40477 .69293 .40233 .6788 .38429 Metetra
.565 .719 .945 r
.6788 .38429 .69293 .40233 .7232 .39966 .70915 .37957 Metetra
.57 .697 .927 r
.70915 .37957 .7232 .39966 .75391 .39687 .73992 .37487 Metetra
.574 .678 .911 r
.73992 .37487 .75391 .39687 .78509 .39401 .77114 .37019 Metetra
.575 .661 .896 r
.77114 .37019 .78509 .39401 .81673 .39109 .8028 .36553 Metetra
.525 .826 1 r
.1344 .4266 .15236 .43415 .17561 .43029 .1579 .42176 Metetra
.545 .819 .997 r
.1579 .42176 .17561 .43029 .19916 .42622 .18169 .41667 Metetra
.564 .811 .991 r
.18169 .41667 .19916 .42622 .22301 .42188 .20578 .41126 Metetra
.584 .802 .983 r
.20578 .41126 .22301 .42188 .24717 .41719 .23019 .40542 Metetra
.604 .792 .971 r
.23019 .40542 .24717 .41719 .27165 .41201 .25491 .39898 Metetra
.627 .782 .956 r
.25491 .39898 .27165 .41201 .29646 .40611 .27997 .39168 Metetra
.654 .771 .935 r
.27997 .39168 .29646 .40611 .32161 .39909 .30537 .38303 Metetra
.688 .76 .906 r
.30537 .38303 .32161 .39909 .34714 .39014 .33117 .37207 Metetra
.735 .749 .864 r
.33117 .37207 .34714 .39014 .37309 .37742 .35741 .35662 Metetra
.793 .736 .8 r
.35741 .35662 .37309 .37742 .39956 .35624 .38422 .3319 Metetra
0 0 .41 r
.38422 .3319 .39956 .35624 .42475 .37736 .40876 .36915 Metetra
.855 .886 .859 r
.40876 .36915 .42475 .37736 .4516 .35909 .43612 .34299 Metetra
0 .326 .797 r
.43612 .34299 .4516 .35909 .47816 .36861 .46264 .3583 Metetra
.555 .817 .995 r
.46264 .3583 .47816 .36861 .50544 .35484 .49009 .35223 Metetra
.781 .279 0 r
.49009 .35223 .50544 .35484 .53306 .39398 .51779 .3895 Metetra
.113 .646 .864 r
.51779 .3895 .53306 .39398 .56142 .39968 .54636 .39077 Metetra
.496 .821 1 r
.54636 .39077 .56142 .39968 .59019 .39761 .57532 .38548 Metetra
.566 .805 .989 r
.57532 .38548 .59019 .39761 .61933 .39357 .60464 .37903 Metetra
.583 .777 .972 r
.60464 .37903 .61933 .39357 .64887 .389 .63433 .37248 Metetra
.588 .753 .956 r
.63433 .37248 .64887 .389 .6788 .38429 .6644 .36608 Metetra
.589 .732 .943 r
.6644 .36608 .6788 .38429 .70915 .37957 .69488 .35983 Metetra
.589 .715 .931 r
.69488 .35983 .70915 .37957 .73992 .37487 .72577 .3537 Metetra
.589 .7 .919 r
.72577 .3537 .73992 .37487 .77114 .37019 .75708 .34768 Metetra
.589 .686 .909 r
.75708 .34768 .77114 .37019 .8028 .36553 .78883 .34171 Metetra
.578 .805 .986 r
.11635 .41639 .1344 .4266 .1579 .42176 .14007 .41076 Metetra
.59 .798 .979 r
.14007 .41076 .1579 .42176 .18169 .41667 .16408 .40483 Metetra
.602 .79 .971 r
.16408 .40483 .18169 .41667 .20578 .41126 .1884 .39852 Metetra
.616 .783 .961 r
.1884 .39852 .20578 .41126 .23019 .40542 .21303 .39171 Metetra
.631 .775 .949 r
.21303 .39171 .23019 .40542 .25491 .39898 .23798 .38421 Metetra
.65 .767 .934 r
.23798 .38421 .25491 .39898 .27997 .39168 .26327 .37571 Metetra
.675 .759 .914 r
.26327 .37571 .27997 .39168 .30537 .38303 .28892 .36562 Metetra
.707 .752 .887 r
.28892 .36562 .30537 .38303 .33117 .37207 .31498 .35285 Metetra
.752 .744 .844 r
.31498 .35285 .33117 .37207 .35741 .35662 .34153 .3349 Metetra
.805 .733 .785 r
.34153 .3349 .35741 .35662 .38422 .3319 .36867 .3072 Metetra
.784 .366 0 r
.36867 .3072 .38422 .3319 .40876 .36915 .39243 .35961 Metetra
.885 .861 .812 r
.39243 .35961 .40876 .36915 .43612 .34299 .42033 .32659 Metetra
0 .251 .739 r
.42033 .32659 .43612 .34299 .46264 .3583 .44685 .34432 Metetra
.292 .633 .964 r
.44685 .34432 .46264 .3583 .49009 .35223 .47433 .34797 Metetra
.758 .242 0 r
.47433 .34797 .49009 .35223 .51779 .3895 .50212 .38299 Metetra
.337 .773 .967 r
.50212 .38299 .51779 .3895 .54636 .39077 .53092 .38052 Metetra
.58 .84 .994 r
.53092 .38052 .54636 .39077 .57532 .38548 .56011 .3726 Metetra
.61 .814 .979 r
.56011 .3726 .57532 .38548 .60464 .37903 .58963 .36416 Metetra
.611 .788 .966 r
.58963 .36416 .60464 .37903 .63433 .37248 .6195 .35602 Metetra
.608 .767 .956 r
.6195 .35602 .63433 .37248 .6644 .36608 .64975 .34823 Metetra
.605 .749 .946 r
.64975 .34823 .6644 .36608 .69488 .35983 .68038 .34075 Metetra
.602 .734 .937 r
.68038 .34075 .69488 .35983 .72577 .3537 .71143 .33348 Metetra
.6 .721 .929 r
.71143 .33348 .72577 .3537 .75708 .34768 .74289 .32637 Metetra
.599 .71 .922 r
.74289 .32637 .75708 .34768 .78883 .34171 .77478 .31937 Metetra
.603 .788 .969 r
.09814 .4044 .11635 .41639 .14007 .41076 .12206 .39808 Metetra
.612 .782 .963 r
.12206 .39808 .14007 .41076 .16408 .40483 .14628 .39143 Metetra
.622 .776 .955 r
.14628 .39143 .16408 .40483 .1884 .39852 .1708 .38434 Metetra
.634 .77 .945 r
.1708 .38434 .1884 .39852 .21303 .39171 .19564 .37668 Metetra
.648 .764 .934 r
.19564 .37668 .21303 .39171 .23798 .38421 .22081 .36824 Metetra
.666 .759 .919 r
.22081 .36824 .23798 .38421 .26327 .37571 .24633 .35864 Metetra
.69 .753 .9 r
.24633 .35864 .26327 .37571 .28892 .36562 .27223 .34724 Metetra
.722 .747 .872 r
.27223 .34724 .28892 .36562 .31498 .35285 .29855 .33278 Metetra
.767 .742 .83 r
.29855 .33278 .31498 .35285 .34153 .3349 .32542 .31249 Metetra
.814 .732 .774 r
.32542 .31249 .34153 .3349 .36867 .3072 .35292 .28223 Metetra
.872 .471 .013 r
.35292 .28223 .36867 .3072 .39243 .35961 .37577 .3489 Metetra
.9 .842 .778 r
.37577 .3489 .39243 .35961 .42033 .32659 .40424 .30987 Metetra
0 .234 .725 r
.40424 .30987 .42033 .32659 .44685 .34432 .43078 .32811 Metetra
0 .356 .816 r
.43078 .32811 .44685 .34432 .47433 .34797 .45816 .34246 Metetra
.731 .203 0 r
.45816 .34246 .47433 .34797 .50212 .38299 .48604 .37531 Metetra
.477 .833 .995 r
.48604 .37531 .50212 .38299 .53092 .38052 .51511 .36957 Metetra
.633 .852 .983 r
.51511 .36957 .53092 .38052 .56011 .3726 .54454 .35934 Metetra
.641 .824 .971 r
.54454 .35934 .56011 .3726 .58963 .36416 .57429 .34919 Metetra
.633 .8 .963 r
.57429 .34919 .58963 .36416 .6195 .35602 .60437 .33966 Metetra
.625 .78 .956 r
.60437 .33966 .6195 .35602 .64975 .34823 .63481 .33069 Metetra
.618 .764 .949 r
.63481 .33069 .64975 .34823 .68038 .34075 .66564 .32215 Metetra
.613 .75 .943 r
.66564 .32215 .68038 .34075 .71143 .33348 .69687 .31391 Metetra
.61 .739 .937 r
.69687 .31391 .71143 .33348 .74289 .32637 .7285 .30588 Metetra
.607 .728 .931 r
.7285 .30588 .74289 .32637 .77478 .31937 .76056 .29801 Metetra
.619 .777 .957 r
.0797 .39112 .09814 .4044 .12206 .39808 .10382 .38419 Metetra
.627 .772 .95 r
.10382 .38419 .12206 .39808 .14628 .39143 .12823 .37688 Metetra
.636 .767 .943 r
.12823 .37688 .14628 .39143 .1708 .38434 .15296 .36909 Metetra
.647 .763 .933 r
.15296 .36909 .1708 .38434 .19564 .37668 .17801 .36066 Metetra
.66 .758 .922 r
.17801 .36066 .19564 .37668 .22081 .36824 .20339 .35134 Metetra
.678 .754 .908 r
.20339 .35134 .22081 .36824 .24633 .35864 .22914 .34072 Metetra
.702 .75 .889 r
.22914 .34072 .24633 .35864 .27223 .34724 .25528 .32809 Metetra
.735 .745 .86 r
.25528 .32809 .27223 .34724 .29855 .33278 .28189 .31203 Metetra
.779 .741 .817 r
.28189 .31203 .29855 .33278 .32542 .31249 .30909 .28953 Metetra
.822 .731 .765 r
.30909 .28953 .32542 .31249 .35292 .28223 .33694 .25701 Metetra
.912 .527 .108 r
.33694 .25701 .35292 .28223 .37577 .3489 .35875 .33719 Metetra
.909 .827 .753 r
.35875 .33719 .37577 .3489 .40424 .30987 .38784 .29282 Metetra
0 .25 .738 r
.38784 .29282 .40424 .30987 .43078 .32811 .41442 .31046 Metetra
0 .054 .567 r
.41442 .31046 .43078 .32811 .45816 .34246 .44156 .33603 Metetra
.701 .164 0 r
.44156 .33603 .45816 .34246 .48604 .37531 .46955 .36685 Metetra
.57 .866 .996 r
.46955 .36685 .48604 .37531 .51511 .36957 .49891 .35815 Metetra
.672 .861 .972 r
.49891 .35815 .51511 .36957 .54454 .35934 .52861 .34583 Metetra
.665 .833 .964 r
.52861 .34583 .54454 .35934 .57429 .34919 .55861 .33412 Metetra
.651 .809 .959 r
.55861 .33412 .57429 .34919 .60437 .33966 .58892 .32334 Metetra
.639 .79 .955 r
.58892 .32334 .60437 .33966 .63481 .33069 .61958 .31331 Metetra
.63 .775 .951 r
.61958 .31331 .63481 .33069 .66564 .32215 .65062 .30382 Metetra
.623 .763 .946 r
.65062 .30382 .66564 .32215 .69687 .31391 .68205 .29471 Metetra
.618 .752 .942 r
.68205 .29471 .69687 .31391 .7285 .30588 .71388 .28588 Metetra
.614 .743 .937 r
.71388 .28588 .7285 .30588 .76056 .29801 .74614 .27722 Metetra
.629 .769 .947 r
.06101 .37683 .0797 .39112 .10382 .38419 .08531 .36934 Metetra
.637 .765 .941 r
.08531 .36934 .10382 .38419 .12823 .37688 .10992 .36144 Metetra
.646 .762 .933 r
.10992 .36144 .12823 .37688 .15296 .36909 .13485 .35299 Metetra
.657 .758 .924 r
.13485 .35299 .15296 .36909 .17801 .36066 .1601 .34383 Metetra
.67 .754 .913 r
.1601 .34383 .17801 .36066 .20339 .35134 .1857 .33369 Metetra
.689 .751 .899 r
.1857 .33369 .20339 .35134 .22914 .34072 .21168 .32212 Metetra
.713 .748 .879 r
.21168 .32212 .22914 .34072 .25528 .32809 .23807 .30831 Metetra
.746 .745 .85 r
.23807 .30831 .25528 .32809 .28189 .31203 .26497 .2907 Metetra
.79 .74 .807 r
.26497 .2907 .28189 .31203 .30909 .28953 .29252 .26606 Metetra
.828 .731 .757 r
.29252 .26606 .30909 .28953 .33694 .25701 .32075 .23152 Metetra
.932 .561 .17 r
.32075 .23152 .33694 .25701 .35875 .33719 .34137 .32465 Metetra
.916 .817 .734 r
.34137 .32465 .35875 .33719 .38784 .29282 .37111 .27544 Metetra
0 .285 .766 r
.37111 .27544 .38784 .29282 .41442 .31046 .39777 .29183 Metetra
.653 .174 0 r
.39777 .29183 .41442 .31046 .44156 .33603 .42453 .32887 Metetra
.671 .124 0 r
.42453 .32887 .44156 .33603 .46955 .36685 .45264 .35783 Metetra
.637 .885 .986 r
.45264 .35783 .46955 .36685 .49891 .35815 .48232 .34637 Metetra
.702 .868 .96 r
.48232 .34637 .49891 .35815 .52861 .34583 .51231 .33209 Metetra
.686 .84 .957 r
.51231 .33209 .52861 .34583 .55861 .33412 .54257 .31893 Metetra
.666 .817 .956 r
.54257 .31893 .55861 .33412 .58892 .32334 .57313 .30698 Metetra
.651 .799 .954 r
.57313 .30698 .58892 .32334 .61958 .31331 .60403 .29596 Metetra
.64 .785 .951 r
.60403 .29596 .61958 .31331 .65062 .30382 .63529 .2856 Metetra
.632 .773 .948 r
.63529 .2856 .65062 .30382 .68205 .29471 .66694 .27569 Metetra
.625 .763 .945 r
.66694 .27569 .68205 .29471 .71388 .28588 .699 .26611 Metetra
.621 .754 .941 r
.699 .26611 .71388 .28588 .74614 .27722 .73147 .25675 Metetra
.638 .764 .939 r
.04204 .36173 .06101 .37683 .08531 .36934 .06653 .35372 Metetra
.645 .761 .933 r
.06653 .35372 .08531 .36934 .10992 .36144 .09133 .34524 Metetra
.654 .758 .926 r
.09133 .34524 .10992 .36144 .13485 .35299 .11645 .33618 Metetra
.665 .755 .917 r
.11645 .33618 .13485 .35299 .1601 .34383 .14191 .32634 Metetra
.679 .752 .906 r
.14191 .32634 .1601 .34383 .1857 .33369 .16773 .31541 Metetra
.697 .749 .892 r
.16773 .31541 .1857 .33369 .21168 .32212 .19394 .30291 Metetra
.722 .747 .871 r
.19394 .30291 .21168 .32212 .23807 .30831 .22059 .28796 Metetra
.756 .744 .842 r
.22059 .28796 .23807 .30831 .26497 .2907 .24779 .26885 Metetra
.8 .74 .797 r
.24779 .26885 .26497 .2907 .29252 .26606 .27572 .24215 Metetra
.834 .731 .751 r
.27572 .24215 .29252 .26606 .32075 .23152 .30432 .20576 Metetra
.944 .583 .213 r
.30432 .20576 .32075 .23152 .34137 .32465 .32363 .31137 Metetra
.92 .809 .72 r
.32363 .31137 .34137 .32465 .37111 .27544 .35406 .25771 Metetra
0 .332 .802 r
.35406 .25771 .37111 .27544 .39777 .29183 .38082 .27245 Metetra
.777 .319 0 r
.38082 .27245 .39777 .29183 .42453 .32887 .40705 .3211 Metetra
.639 .085 0 r
.40705 .3211 .42453 .32887 .45264 .35783 .43528 .34835 Metetra
.688 .895 .972 r
.43528 .34835 .45264 .35783 .48232 .34637 .46531 .33426 Metetra
.727 .873 .949 r
.46531 .33426 .48232 .34637 .51231 .33209 .49562 .31811 Metetra
.704 .846 .951 r
.49562 .31811 .51231 .33209 .54257 .31893 .52616 .30356 Metetra
.68 .824 .952 r
.52616 .30356 .54257 .31893 .57313 .30698 .55699 .29051 Metetra
.662 .807 .952 r
.55699 .29051 .57313 .30698 .60403 .29596 .58814 .27855 Metetra
.649 .792 .951 r
.58814 .27855 .60403 .29596 .63529 .2856 .61964 .26736 Metetra
.639 .781 .949 r
.61964 .26736 .63529 .2856 .66694 .27569 .65153 .2567 Metetra
.632 .771 .947 r
.65153 .2567 .66694 .27569 .699 .26611 .68382 .24642 Metetra
.627 .763 .944 r
.68382 .24642 .699 .26611 .73147 .25675 .71653 .2364 Metetra
.644 .76 .933 r
.02277 .34593 .04204 .36173 .06653 .35372 .04744 .33742 Metetra
.652 .758 .927 r
.04744 .33742 .06653 .35372 .09133 .34524 .07243 .3284 Metetra
.661 .755 .92 r
.07243 .3284 .09133 .34524 .11645 .33618 .09775 .31875 Metetra
.672 .753 .911 r
.09775 .31875 .11645 .33618 .14191 .32634 .12341 .30824 Metetra
.686 .751 .9 r
.12341 .30824 .14191 .32634 .16773 .31541 .14945 .29656 Metetra
.706 .749 .885 r
.14945 .29656 .16773 .31541 .19394 .30291 .1759 .28316 Metetra
.731 .747 .864 r
.1759 .28316 .19394 .30291 .22059 .28796 .20283 .26709 Metetra
.765 .744 .834 r
.20283 .26709 .22059 .28796 .24779 .26885 .23035 .24651 Metetra
.808 .74 .789 r
.23035 .24651 .24779 .26885 .27572 .24215 .25866 .2178 Metetra
.838 .731 .746 r
.25866 .2178 .27572 .24215 .30432 .20576 .28767 .17971 Metetra
.951 .598 .245 r
.28767 .17971 .30432 .20576 .32363 .31137 .3055 .29745 Metetra
.924 .802 .707 r
.3055 .29745 .32363 .31137 .35406 .25771 .33665 .23963 Metetra
0 .385 .839 r
.33665 .23963 .35406 .25771 .38082 .27245 .36355 .25245 Metetra
.844 .409 0 r
.36355 .25245 .38082 .27245 .40705 .3211 .3891 .31282 Metetra
.606 .047 0 r
.3891 .31282 .40705 .3211 .43528 .34835 .41747 .33848 Metetra
.727 .902 .957 r
.41747 .33848 .43528 .34835 .46531 .33426 .44788 .32183 Metetra
.748 .877 .938 r
.44788 .32183 .46531 .33426 .49562 .31811 .47853 .30388 Metetra
.72 .851 .944 r
.47853 .30388 .49562 .31811 .52616 .30356 .50937 .28798 Metetra
.693 .83 .949 r
.50937 .28798 .52616 .30356 .55699 .29051 .54047 .27385 Metetra
.673 .813 .95 r
.54047 .27385 .55699 .29051 .58814 .27855 .57189 .26099 Metetra
.658 .799 .95 r
.57189 .26099 .58814 .27855 .61964 .26736 .60365 .249 Metetra
.647 .787 .949 r
.60365 .249 .61964 .26736 .65153 .2567 .63579 .23763 Metetra
.639 .778 .948 r
.63579 .23763 .65153 .2567 .68382 .24642 .66832 .22668 Metetra
.633 .77 .946 r
.66832 .22668 .68382 .24642 .71653 .2364 .70128 .21602 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jB000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00/`3oool3000006X0oooo002d0?ooo`030000003oool0oooo06T0oooo002a0?ooo`D00000
JP3oool00;40oooo00@000000?ooo`3oool00000J`3oool00;80oooo00<000000?ooo`0000005@3o
ool2000005@0oooo002c0?ooo`8000004`3oool2000000030?ooo`000000000005<0oooo00350?oo
o`<000000`3oool2000005<0oooo00310?ooo`@000001P3oool00`000000oooo0000001B0?ooo`00
`03oool3000000P0oooo00@000000?ooo`3oool00000D@3oool00;d0oooo0`00000;0?ooo`040000
003oool0oooo00000540oooo002k0?ooo`8000003P3oool01@000000oooo0?ooo`3oool000000500
oooo002h0?ooo`<00000403oool010000000oooo0?ooo`3oool2000004l0oooo002f0?ooo`<00000
4P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo0`00000m0?ooo`00/`3o
ool3000000<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0?03oool00;00oooo0`00000I0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool02@3oool5000003d0oooo002;0?ooo`@000007`3oool20000
01`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`@000000P3oool01000
0000oooo0?ooo`00000n0?ooo`00R`3oool00`000000oooo0?ooo`0M0?ooo`<0000000<0oooo0000
003oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`000000?P3oool008`0oooo00<000000?ooo`3oool06P3oool200000240oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0:0?ooo`800000?P3oool008d0oooo00<000000?ooo`3oool0
5P3oool3000002<0oooo00<000000?ooo`3oool00`3oool3000004/0oooo002;0?ooo`040000003o
ool0oooo000001D0oooo0P00000V0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
B03oool008`0oooo0P00000C0?ooo`<0000000<0oooo0000003oool09@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo04P0oooo002N0?ooo`<00000:`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo04L0oooo002K0?ooo`<00000;P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo04H0oooo002I0?ooo`@00000;`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo04H0oooo002G0?ooo`800000<`3oool00`000000oooo0?ooo`090?ooo`800000
AP3oool009@0oooo0`00000e0?ooo`030000003oool0oooo00T0oooo0P0000160?ooo`00TP3oool2
000003P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`140?ooo`00S`3oool30000
00030?ooo`000000oooo03L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`130?oo
o`00S03oool3000003d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`120?ooo`00
J03oool2000001l0oooo0`0000110?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
@P3oool006L0oooo00@000000?ooo`3oool00000703oool400000480oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`110?ooo`00I`3oool010000000oooo0?ooo`00000J0?ooo`800000
AP3oool00`000000oooo0?ooo`0<0?ooo`800000@P3oool006L0oooo00@000000?ooo`3oool00000
5`3oool3000004P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`100?ooo`00I`3o
ool010000000oooo0?ooo`00000E0?ooo`800000B`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo03l0oooo001X0?ooo`8000004`3oool3000000030?ooo`000000oooo04X0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0n0?ooo`00NP3oool300000500oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0n0?ooo`00M`3oool3000005<0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0m0?ooo`00M@3oool4000005@0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0l0?ooo`00L`3oool2000005P0oooo00<000000?ooo`3oool0
403oool2000000d0oooo1000000]0?ooo`00L03oool3000005X0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02h0oooo001^0?ooo`800000G@3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0;@3oool0
06/0oooo0`0000000`3oool000000?ooo`1L0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool00`3oool4000000@0oooo00<000000?ooo`3oool0;03oool006P0oooo0`00001R0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`00000]0?oo
o`00A@3oool4000001d0oooo0P00001U0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool02@3oool2000002h0oooo00150?ooo`030000003oool0oooo01/0oooo1000001V0?ooo`030000
003oool0oooo01<0oooo0`00000j0?ooo`00AP3oool00`000000oooo0?ooo`0H0?ooo`800000J`3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03L0oooo000o0?ooo`@00000103oool0
0`000000oooo0?ooo`0D0?ooo`<00000K@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo03L0oooo00150?ooo`040000003oool0oooo000001<0oooo0`00001_0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0=P3oool004H0oooo0P00000A0?ooo`<00000LP3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo03D0oooo001F0?ooo`<00000M@3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo03D0oooo001D0?ooo`800000N03oool00`000000oooo
0?ooo`0G0?ooo`800000=P3oool00540oooo0`0000000`3oool000000?ooo`1g0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0<`3oool004l0oooo0P00000>0?ooo`030000003oool0
oooo06`0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0c0?ooo`00C03oool30000
00l0oooo0`00001]0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0<P3oool004X0
oooo0P0000000`3oool000000000000?0?ooo`<00000K@3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0340oooo00170?ooo`<000004`3oool01@000000e[^n0000003cVCh0000006`0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0a0?ooo`009P3oool3000001/0oooo
0`00000E0?ooo`070000003F^kh0e[^n0=Jk_P000000liTn0000001[0?ooo`030000003oool0oooo
01/0oooo0P00000b0?ooo`009`3oool00`000000oooo0?ooo`0H0?ooo`80000000<0oooo0000003o
ool0503oool00`000000e[^n0=Jk_P020=Jk_P040000003cVCh0liTn000006X0oooo00<000000?oo
o`3oool07@3oool00`000000oooo0?ooo`0_0?ooo`00903oool5000001H0oooo0`00000I0?ooo`03
0000003F^kh0e[^n0080e[^n00@000000?>I?P3cVCh00000JP3oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo02l0oooo000N0?ooo`@000000P3oool010000000oooo0?ooo`00000E0?oo
o`8000006`3oool00`000000e[^n0=Jk_P030=Jk_P050000003cVCh0liTn0?>I?P000000J@3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo02h0oooo000U0?ooo`030000003oool00000
0180oooo1000000K0?ooo`030000003F^kh0e[^n00@0e[^n00@000000?>I?P3cVCh0liTn0P00001X
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0;@3oool002H0oooo0P00000@0?oo
o`8000007`3oool00`000000e[^n0=Jk_P040=Jk_P040000003cVCh0liTn0?>I?P800000J@3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo02d0oooo000e0?ooo`<00000803oool00`00
0000e[^n0=Jk_P060=Jk_P040000003cVCh0liTn0?>I?P800000IP3oool300000200oooo0P000008
0?ooo`800000903oool00380oooo0`00000R0?ooo`030000003>_LT0000000L0e[^n00@000000?>I
?P3cVCh0liTn0P00001R0?ooo`@000000P2RaO800`000000oooo0?ooo`0O0?ooo`030000003oool0
oooo00D0oooo00@000000?ooo`3oool000008`3oool00300oooo0P0000030?ooo`030000003oool0
oooo01h0oooo00@000000<jmb@3>_LT000001P3F^kh2000000<0liTn00<000000?6E=P000000G@3o
ool4000000H0X/Gb0P00000Q0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool00000
8`3oool002d0oooo0`00000U0?ooo`030000003>_LT0c[g90080c[g900<000000=Jk_P3F^kh00P3F
^kh00`000000eK_0000000030?>I?P030000003aUCH0000005X0oooo0`0000020:?7lP030000002R
aO80X/Gb00D0X/Gb0P00000R0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000
8`3oool002/0oooo0P00000W0?ooo`030000003>_LT0c[g900<0c[g900D000000=Jk_P3F^kh0e[^n
000000020=Fk`0050000003cVCh0liTn0?>I?P0000000P3aUCH00`000000oooo0?ooo`1D0?ooo`<0
00001@2Sao800`000000X/Gb0:;5lP050:;5lP030000002RaO8000000240oooo00<000000?ooo`3o
ool00`3oool010000000oooo0?ooo`00000S0?ooo`00:03oool300000080oooo00<000000?ooo`3o
ool08`3oool00`000000c[g90<jmb@050<jmb@040000003F^kh0e[^n00000080eK_000D000000?>I
?P3cVCh0liTn000000020?6E=P800000DP3oool3000000T0XlOb00<000000:;5lP2RaO80102RaO80
10000000X/Gb00000000000Q0?ooo`800000103oool2000002@0oooo000V0?ooo`800000:P3oool0
0`000000c[g90<jmb@060<jmb@030000003F^kh0000000@0eK_000H000000?>I?P3cVCh0liTn0000
003aUCH2000000<0oooo0P00001:0?ooo`<000000P2UbO800`000000XlOb0:?7lP080:?7lP030000
002RaO80X/Gb00<0X/Gb0P0000020:33l@030000003oool0oooo01d0oooo0`00000Z0?ooo`008`3o
ool3000002/0oooo00<000000<jmb@3>_LT0203>_LT00`000000eK_00=Fk`0030=Fk`0050000003c
VCh0liTn0?>I?P0000000P3aUCH2000000030?ooo`000000k<fd00<00000A@3oool3000000H0YLWb
00<000000:?7lP2Sao801`2Sao800`000000X/Gb0:;5lP04000000@0X<?a00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`0X0?ooo`00803oool300000080oooo00<000000?ooo`3oool0:03o
ool00`000000c[g90<jmb@080<jmb@030000003<_L`0000000@0eK_000D000000?>I?P3cVCh0liTn
000000020?6E=P040000003^Sb/0000000000080k<fd00@00000001ReP0000000000@@3oool20000
00T0YLWb00<000000:?7lP2Sao801P2Sao8600000080X<?a00D000000:33l@2P`o40X<?a0000000Q
0?ooo`030000003oool0oooo02L0oooo000N0?ooo`800000;P3oool2000000030<>ne@000000c[g9
00L0c[g900D000000<bmc03<_L`0c;g<000000030=Fk`0050000003cVCh0liTn0?>I?P0000000P3a
UCH00`000000kXl[000000030>c=]00400000000H]H006;F001ReP800000?@3oool2000000030:S<
l`000000YLWb00T0YLWb00@000000:?7lP2Sao80XlOb200000040:33l@030000002P`o40X<?a0080
X<?a00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0V0?ooo`00703oool2000002l0oooo
00<000000<>ne@33_]D00P33_]D00`000000c[g90<jmb@040<jmb@030000003<_L`0c;g<0080c;g<
00D000000=Fk`03E^l00eK_0000000030?>I?P060000003aUCH0lIDf0000003^Sb/00000103/cK@0
1000000006;F001ReP00H]H2000003X0oooo0P0000040:S<l`030000002UbO80YLWb00L0YLWb1000
0000102QaO8000000000000000040:75lP030000002P`o40X<?a0080X<?a00@000000:33l@2P`o40
X<?a0P00000P0?ooo`030000003oool0oooo02H0oooo000L0?ooo`800000;P3oool00`000000`kkE
0<>ne@030<>ne@030000003>_LT0c[g900<0c[g900<000000<bmc03<_L`0103<_L`010000000eK_0
0=Fk`00000030?>I?P050000003aUCH0lIDf0?6E=P0000001P3/cK@01@00000006;F001ReP00H]H0
000003P0oooo0P0000070:S<l`030000002UbO80YLWb00@0YLWb0P0000020:?7lP<000001`2QaO80
0`000000X<?a0:33l@030:33l@<000000P2N`O000`000000oooo0?ooo`0M0?ooo`8000009`3oool0
01`0oooo00<000000?ooo`000000:`3oool2000000L0`kkE00D000000<jmb@3>_LT0c[g900000008
0<bmc0040000003E^l000000000000<0liTn00<000000?6E=P0000001P3/cK@01@000000jlnh0000
0000000006;F00800000=03oool3000000X0Z<cc00<000000:G9lP2UbO800`0000020:?7lP<00000
2P2QaO800`000000X<?a0:33l@04000000<0W/7`00<000000?ooo`3oool07`3oool00`000000oooo
0?ooo`0T0?ooo`00703oool2000000030?ooo`000000oooo02P0oooo00<000000<>ne@33_]D02033
_]D00`000000c[g90000000:0<bmc0030000003C^l40000000<0liTn00<000000?6E=P0000001P3/
cK@00`000000jlnh0>_?^00500000300oooo0`0000020:c@l`030000002Xc?<0Z<cc00P0Z<cc0`00
00020:?7lP<000000`2Sao800`000000XLGb0:75lP070:75lP<000000`2N`O000`000000W/7`09k1
l00209k1l0030000003oool0oooo01h0oooo00<000000?ooo`3oool0903oool001/0oooo0P000003
0?ooo`030000003oool0oooo02@0oooo0P0000000`2k_md000000<>ne@090<>ne@030000003<_L`0
c;g<00P0c;g<00@000000<ZmcP00000000000`3cVCh2000000H0k<fd00<000000>_?^03[ckP00`3[
ckP3000002d0oooo0`0000060:c@l`030000002Xc?<0Z<cc00@0Z<cc0`0000020:K:l`<000001`2S
ao800`000000XLGb0:75lP030:75lP<000000P2O`o400`000000W/7`09k1l00209k1l0030000002N
`O00W/7`0080W/7`00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0S0?ooo`006`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0280oooo00D000000;^og@2k_md0^koM0000
00080<>ne@80000000<0`KkG0000003<_L`01`3<_L`00`000000b[g>0<ZmcP02000000<0liTn0P00
00060>c=]0030000003[ckP0jlnh00@0jlnh0`00000Z0?ooo`8000002P2/d?<00`000000Z<cc0:S<
l`0300000080Y/[c0`0000000`2Vb_<000000:?7lP070:?7lP030000002QaO80XLGb00<000001P2O
`o400`000000W/7`09k1l00209k1l0050000002N`O00W/7`09k1l00000008@3oool00`000000oooo
0?ooo`0R0?ooo`006`3oool2000000D0oooo00<000000?ooo`3oool0803oool00`000000^koM0;^o
g@030;^og@0300000033_]D0`kkE00@0`kkE00D000000<6ne`31_]L0`KkG000000070<bmc0030000
003:_Lh0b[g>0080b[g>00D000000?>I?P3cVCh0liTn000000060>c=]0030000003[ckP0jlnh00@0
jlnh00D000000>[A^`000000f6P00000000W0?ooo`80000000<0/MCb0000002/d?<02@2/d?<30000
0080Y/[c0`0000040:K:l`030000002Sao80XlOb00H0XlOb0`00000909o3l@030000002N`O00W/7`
00<0W/7`00<0000009k1l02N`O000P00000P0?ooo`8000008`3oool001/0oooo00<000000?ooo`3o
ool01@3oool2000001h0oooo0P0000070;^og@0400000033_]D0`kkE0<>ne@8000001@31_]L00`00
0000c;g<0<bmc0020<bmc08000001@3:_Lh010000000liTn0?>I?P0000070>c=]0030000003[ckP0
jlnh00@0jlnh00@000000>[A^`000000f6P00P00000T0?ooo`800000102ae?82000000H0[=3c0P00
00020:W>l`<00000202Vb_<010000000XlOb0:?7lP2Sao8400000080XLGb00<0000009o3l@2O`o40
202O`o4010000000W/7`09k1l02N`O0400000080WKk_00<000000?ooo`3oool07@3oool2000002<0
oooo000K0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06@3oool2000000T0^koM
00@000000<>ne@00000000002031_]L010000000c;g<0<bmc00000080<ZmcP030000003cVCh00000
00H0k<fd00<000000>_?^03[ckP0103[ckP01P000000j]6k0>[A^`3ZdK/000000=QX008000008@3o
ool2000000P0/MCb00<000000:c@l`2/d?<00`0000020:W>l`80000000<0ZLkc0000002Vb_<0202V
b_<4000000L0XLGb00<0000009o3l@2O`o401`2O`o4400000080WKk_00D0000009fnk`2M_^l0WKk_
0000000Q0?ooo`030000003oool0oooo0200oooo000K0?ooo`8000002@3oool00`000000oooo0?oo
o`0F0?ooo`8000000P2d_n800`000000^koM0;^og@070;^og@0300000031_]L0`KkG00P0`KkG00<0
00000<bmc00000002@3:_Lh2000000H0k<fd00<000000>_?^03[ckP01@3[ckP02@000000j]6k0>[A
^`3ZdK/000000=QX00000000aU400000000N0?ooo`8000002P2ae?8300000080ZLkc0`0000030:W>
l`030000002Vb_<0Y/[c00@0Y/[c0`0000020:?8l`030000002QaO80XLGb00H0XLGb00<0000009o3
l@2O`o40102O`o4300000080W/3a00<0000009fnk`2M_^l00P2M_^l01@000000WKk_09fnk`2M_^l0
00000200oooo00<000000?ooo`3oool0803oool001X0oooo0P00000;0?ooo`030000003oool0oooo
0180oooo0`0000050;BohP030000002k_md0^koM00@0^koM0P0000000`2h_mh000000<6ne`090<6n
e`030000003:_Lh0b[g>00P0b[g>0P0000060>c=]0030000003[ckP0jlnh00@0jlnh00<000000>[A
^`3ZdK/00`3ZdK/01@000000f6P000000036D@00000001/0oooo0P0000000`2hfO4000000;7DlP07
0;7DlP8000000P2^d_<3000000L0ZLkc00<000000:K:l`2Vb_<00`0000060:?8l`030000002QaO80
XLGb00H0XLGb00<0000009o3l@2O`o400`00000509k0l@030000002M_^l0WKk_0080WKk_00<00000
09fnk`2M_^l00P2M_^l00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo01l0oooo00070?oo
o`@000000`3oool2000000@0oooo0P0000040?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool03P3oool3000000P0];oR00<000000;^og@2k_md00P2k_md2000000@0^;oN00<000000<6n
e`31_]L01@31_]L2000000030;jnf@000000b[g>00L0b[g>0P0000060>c=]0030000003[ckP0jlnh
00D0jlnh00<000000>[A^`3ZdK/00`3ZdK/00`000000f6P0000000020<IA00030000003oool0oooo
01H0oooo0P0000040;SIl@030000002ae?80/MCb00<0/MCb0P0000001P2^d_<00000000000000000
[];c000000P0ZLkc0`0000090:?8l`030000002QaO80XLGb00H0XLGb0`00000909k0l@030000002M
_^l0WKk_0080WKk_00D0000009fnk`2M_^l0WKk_0000000M0?ooo`050000003oool0oooo0?ooo`00
0000803oool000L0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000030?ooo`80
00003@3oool00`000000oooo0?ooo`0;0?ooo`8000000P2_`>H00`000000];oR0;BohP070;BohP04
0000002k_md00000000000L0^;oN00<000000<6ne`31_]L00P31_]L2000000@0_[kI00<000000<Zm
cP3:_Lh00`3:_Lh200000080akgA00<000000>c=]03/cK@00`3/cK@00`000000jlnh0>_?^0040>_?
^0030000003ZdK/0j]6k00@0j]6k0P0000000`3HJ00000000<IA0002000001D0oooo0P0000070;SI
l@030000002ae?80/MCb00D00000102^d_<00`000000ZLkc0:W>l`040:W>l`8000000P2Vc?@00`00
0000XlSc0:?8l`080:?8l`040000002QaO80XLGb0:75lP@000000P2O`o800`000000W/3a09k0l@08
09k0l@030000002M_^l0WKk_0080WKk_00<0000009fnk`2M_^l00P00000J0?ooo`<000000P3oool2
000000L0oooo1000000E0?ooo`00203oool00`000000oooo0?ooo`0;0?ooo`050000003oool0oooo
0?ooo`0000003`3oool00`000000oooo0?ooo`080?ooo`8000001@2_`>H00`000000];oR0;BohP06
0;BohP8000002P2h_mh010000000`KkG0000000000070;jnf@050000003:_Lh0b[g>0<ZmcP000000
1@37_M4200000080k<fd00<000000>_?^03[ckP0103[ckP00`000000j]6k0>[A^`040>[A^`050000
003Xdl0000000=QX000000000P36D@000`000000oooo0?ooo`0A0?ooo`8000002P2hfO44000000P0
[];c00<000000:W>l`2Yc_<00`0000050:K<m0030000002Sb?<0XlSc00L0XlSc1000000709o3lP03
0000002N`?40W/3a00L0W/3a00@0000009fnk`2M_^l0WKk_1000000209^jkP030000003oool0oooo
01D0oooo0P00000208@mKP8000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
01H0oooo00000`3oool0000000000002000000@0oooo00<000000?ooo`3oool0203oool2000000@0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`050?ooo`800000202_`>H00`000000
];oR0;BohP030;BohP8000000P2b_n@00`000000^;oN0;RogP080;RogP030000002n_]T0_[kI00P0
_[kI00<000000<ZmcP0000002037_M400`000000k<fd000000060>_?^0030000003ZdK/0j]6k00@0
j]6k00H000000>SC`03Xdl0000000=QX000000020<IA00030000003oool0oooo00h0oooo0P000000
0`2oh?0000000;SIl@070;SIl@@000002P2^d_<3000000P0Y/cd00<000000:?8l`2Sb?<0102Sb?<3
00000080XLKc00<0000009o3lP2O`o801P2O`o800`000000W/3a09k0l@0609k0l@D000000P2K^^h0
0`000000Vk[^09^jkP0209^jkP030000003oool0oooo0180oooo0P00000408@mKP8000000`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo01D0oooo00070?ooo`040000003oool0oooo
000000T0oooo00<000000?ooo`3oool00`3oool200000100oooo00<000000?ooo`3oool00P3oool2
000000030:c0j@000000[l3V00P0[l3V00<000000;BohP2d_n800P0000050;:oi0030000002h_mh0
^;oN00D0^;oN0P0000000`2f_n4000000;jnf@090;jnf@0300000037_M40akgA00P0akgA00<00000
0>_?^03[ckP0103[ckP00`000000j]6k0>[A^`040>[A^`070000003Xdl00j=?00>SC`0000000f6P0
000000020<IA008000003@3oool2000000@0_n3`00<000000;SIl@2hfO400`2hfO42000000@0]=Sc
0P0000060:kBl`8000000P2ZdO@00`000000Y/cd0:K<m0070:K<m0030000002Sb?<0XlSc00<00000
1P2Qa_<00`000000Wl?b09o3lP0609o3lP040000002N`?40W/3a09k0l@@000000`2L_Nl00`000000
Vk[^09^jkP0209^jkP050000002K^^h0Vk[^09^jkP0000004`3oool00`000000Q3e^08@mKP0408@m
KP800000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01@0oooo00080?ooo`80
00002P3oool300000080oooo00<000000?ooo`3oool04@3oool010000000oooo0000000000040:c0
j@030000002_`>H0[l3V00H0[l3V0`0000080;:oi0030000002h_mh0^;oN0080^;oN0P0000040;Jo
h@030000002n_]T0_[kI00D0_[kI0P0000000`2l_]`000000<Nmd@080<Nmd@8000001@3[ckP00`00
0000j]6k0>[A^`030>[A^`030000003Xdl00j=?000<0j=?000<000000=QX000000000P36D@020000
00X0oooo0P0000070;oPl0030000002hfO40000000800000202df?<00`000000[];c0:kBl`030000
00D0Z]7d00<000000:K<m02Vc?@01P2Vc?@3000000T0XLKc00<0000009o3lP2O`o801P2O`o840000
00P0W;g_00<0000009^jkP2K^^h00P2K^^h01@000000Vk[^09^jkP2K^^h000000100oooo0`000006
08@mKP030000002[T;T0000000@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00
000E0?ooo`006@3oool00`000000oooo0?ooo`0@0?ooo`<000001`2/`>T00`000000[l3V0:o0iP03
0:o0iP8000000P2]`>L00`000000/[oT0;:oi0070;:oi0040000002h_mh00000000000H0][oQ00<0
00000;jnf@2n_]T0102n_]T01@000000_;kL0;bng02l_]`0000000L0akgA0P0000020<Bme0800000
0P3[ckP00`000000j]6k0>[A^`040>[A^`030000003Xdl00j=?000@0j=?00P0000030<IA00800000
1`3oool2000000P0_n3`1000000;0;CHl`8000002@2ZdO@010000000Y/cd0:K<m02Vc?@400000080
Xl[d00<000000:76l`2Qa_<0202Qa_<010000000Wl?b09o3lP2O`o8400000080W;oa00<0000009bm
k`2L_Nl01`2L_Nl00`000000Vk[^09^jkP0309^jkP030000002K^^h0Vk[^008000003@3oool20000
0080PcY[00<0000008@mKP24?Fh01024?Fh00`000000Zi2i000000040?ooo`800000103oool20000
01H0oooo000I0?ooo`8000003`3oool200000080ZL7[00<000000:c0j@2/`>T01P2/`>T00`000000
[l3V0:o0iP02000000D0[L3W00<000000;:oi02b_n@01P2b_n@2000000T0][oQ00<000000;jnf@2n
_]T00P2n_]T00`000000_;kL0;bng0030;bng00300000037_M40akgA00<0akgA00<000000<Bme034
_M@00`34_M@2000000030>_?^0000000j]6k00@0j]6k00<000000>SC`03Xdl001@3Xdl0400000080
aU400P0000050?ooo`030000002oh?00_n3`00D0_n3`1@0000000`2jgo8000000;CHl`080;CHl`80
000000<0[mOd0000002ZdO@0202ZdO@4000000L0Xl[d0P0000080:76l`@000001`2L_o400`000000
W;g_09bmk`0709bmk`040000002K^^h0Vk[^09^jkP@000000P2I]N`00`000000oooo0?ooo`080?oo
o`8000001023>V/00`000000Q3e^08@mKP0408@mKP030000002[T;T0000000<0oooo0`00000L0?oo
o`006@3oool00`000000oooo0?ooo`0<0?ooo`8000001@2Y`N/00`000000[<3Y0:c0j@060:c0j@80
0000202]`>L00`000000/[oT0;:oi0030;:oi08000000P2``>H00`000000][oQ0;Joh@070;Joh@04
0000002n_]T00000000000L0_;kL00D000000<Nmd@37_M40akgA000000070<Bme08000001P3ZdK/0
0`000000j=?00>SC`0040>SC`0030000003VelL0i]O700D0000000@0Yb`0000000000000oooo0P00
00000`2ji_@00000000000020;oPl0<0000000<0_n3`000000000000102jgo82000000D0]=Sc0P00
00040:oGm0030000002ZdO@0Z]7d00@0Z]7d0P0000020:K?m@030000002Sb_@0Xl[d00P0Xl[d00@0
00000:76l`2Qa_<0XLKc1000000209k3lP030000002L_o40W;oa00H0W;oa00<0000009bmk`2L_Nl0
1P2L_Nl500000080VKG/00D0000009Vek02I]N`0VKG/000000090?ooo`0300000023>V/0PcY[00@0
PcY[00<0000008@mKP24?Fh01024?Fh010000000Zi2i0:^@^@0000050?ooo`030000003oool0oooo
01T0oooo000I0?ooo`030000003oool0oooo00T0oooo0`0000080:W1j`030000002/`>T0[<3Y00<0
[<3Y0P0000000`2Z`NX000000:g0i`080:g0i`030000002b_n@0/[oT008000001@2``>H00`000000
][oQ0;Joh@060;Joh@8000002@2l_]`010000000akgA0000000000080<Bme0040000003@^lH00000
000000<0j]6k00<000000>SC`03Xdl00103Xdl000`000000i]O70>KGa`020>KGa`80000000<0XaD0
0000000000000`0000040;[Vm0<000000P2oh?02000000P0^]ob00<000000;CHl`2df?<00P000007
0:oGm0030000002ZdO@0Z]7d00<000001@2VcoD00`000000Xl[d0:?:m0070:?:m0@000001`2N`o80
0`000000W;oa09bol@0609bol@040000002L_Nl0W;g_09bmk`@000000P2I^>d00`000000VKG/09Ve
k00309Vek0050000002I]N`0VKG/09Vek00000001P3oool3000000H0PcY[00<0000008@mKP24?Fh0
1024?Fh010000000Zi2i0:^@^@0000050?ooo`030000003oool0oooo01T0oooo000I0?ooo`800000
1P3oool400000080Y/;]00<000000:W1j`2Y`N/01`2Y`N/00`000000[<3Y0:c0j@02000000@0Z/7Z
00<000000:g0i`2]`>L01P2]`>L3000000P0/<3V00<000000;Joh@2f_n400`2f_n4200000080/koS
00<000000;bng02l_]`01`2l_]`00`000000a;gD0<Bme0090<Bme0030000003>^lP0c[_800800000
00<0j]6k0000003Xdl00103Xdl000`000000i]O70>KGa`040>KGa`80000000<0XaD0000000000000
0`2ji_@3000000<0^^Kd0P00000:0;[OlP<000002@2_eo@3000000P0Y/oe00<000000:?:m02Sb_@0
102Sb_@300000080WlOd00<0000009k3lP2N`o801P2N`o800`000000W;oa09bol@0609bol@@00000
1`2I^>d00`000000VKG/09Vek00209Vek0030000002I]N`0VKG/0080VKG/00<000000?ooo`3oool0
0P3oool010000000PCIV084fIP00000608<jJ`0300000024?Fh0Q3e^00@0Q3e^00@000000:^@^@2[
T;T000001P3oool00`000000oooo0?ooo`0H0?ooo`006@3oool00`000000oooo0?ooo`020?ooo`<0
00001`2V`^d2000000L0ZL7[0`0000070:[1jP030000002]`>L0[L3W00<0[L3W0P0000020:_1j@03
0000002``>H0/<3V00L0/<3V00<000000;Joh@2f_n400P0000050;>oh`030000002l_]`0_;kL00@0
_;kL0P0000000`2h_ml000000<Bme0070<Bme080000000<0`;kH0000003>^lP00P3>^lP00`000000
j=?00>SC`0030>SC`0030000003VelL0i]O700D0i]O70`0000020;[Vm0<00000102ji_@200000003
0;3Un0000000000000L0^]ob0P0000020;?Nm@030000002_eo@0[mOd00D0[mOd0P0000020:[EmP03
0000002VcoD0Y/oe00L0Y/oe00<000000:?:m02Sb_@00`00000609o7m0030000002N`o80W/?b00H0
W/?b00@0000009bol@2L_o40W;oa1000000209Zkk`030000002I^>d0VKS]00H0VKS]00<0000009Ve
k02I]N`00`2I]N`01@000000VKG/09Vek02I]N`0000000<0oooo00D00000084fIP21=VH0PCIV0000
000608<jJ`0300000024?Fh0Q3e^00@0Q3e^00D000000:^@^@2[T;T0Zi2i000000060?ooo`030000
003oool0oooo01L0oooo000H0?ooo`030000003oool0000000<000000P2T`^h00`000000Y/;]0:K2
k@070:K2k@030000002Y`N/0ZL7[00@000000P2W`^d00`000000Z/7Z0:[1jP060:[1jP030000002]
`>L0[L3W008000001@2[`NT00`000000/<3V0;30iP060;30iP<000001`2c_n<00`000000_;kL0;bn
g0020;bng0800000102h_ml00`000000a;gD0<Bme0040<Bme00500000030_]P0`;kH0<2nf0000000
103>^lP00`000000j=?00>SC`0020>SC`0030000003VelL0i]O700@0i]O700<000000>;Lc`3Rg<l0
0`0000050;[Vm08000001@2`iOP200000080^]ob0`0000050;?Nm@8000000P2_eo@3000000D0Z]Gf
00<000000:K?m@2VcoD01P2VcoD3000000T0WlOd00<0000009k3lP2N`o801P2N`o84000000L0V[__
00<0000009Vhk@2I^>d01P2I^>d00`000000VKG/09Vek00309Vek0030000002I]N`0000000@00000
1021=VH00`000000PcY[08<jJ`0408<jJ`0300000024?Fh0Q3e^008000000P24?Fh00`000000Zi2i
0:^@^@02000000D0oooo0P00000I0?ooo`00603oool2000000L0Y<;^0P0000070:K2k@<000001`2W
`^d2000000H0Z/7Z0`0000080:_1j@030000002``>H0/<3V00<0/<3V0P0000020:g1j0030000002c
_n<0/koS00H0/koS00@000000;bng000000000001`2h_ml00`000000a;gD0<Bme0020<Bme0030000
0030_]P0`;kH00<0`;kH00<000000<jkb03>^lP00P3>^lP2000000030>SC`0000000i]O700D0i]O7
00<000000>;Lc`0000000P0000000`3Rg<l00000000000020;[Vm08000002@2`iOP2000000X0/mke
0P0000090:[EmP040000002VcoD0Y/oe0:K?m@@000000P2Rc?H00`000000WlOd09o7m00809o7m004
0000002N`o80W/?b09k3lP@000000P2J_o800`000000V[__09Zkk`0609Zkk`030000002I^>d0VKS]
00H0VKS]00@0000009Vek02I]N`0VKG/1000000309J_j00300000021=VH0PCIV00<0PCIV00<00000
08<jJ`23>V/00`23>V/40000000409Yk/0000000Q3e^08@mKP<0000000<0[Yc40000003oool01P3o
ool00`000000oooo0?ooo`0F0?ooo`00603oool2000000T0Y<;^00<000000:K2k@2V`^d010000002
0:G2kP030000002W`^d0Yl;]00L0Yl;]00<000000:[1jP2Z`NX00`0000020:S2k0030000002[`NT0
Zl7Y00L0Zl7Y00<000000;30iP2``>H00P0000050:g1j0030000002c_n<0/koS00D0/koS0P00000:
0;Rog`0400000034_M@00000000000L0`;kH00@000000<jkb03>^lP000000P3;_<`00`000000i]O7
0>KGa`040>KGa`<000001@3Rg<l3000000T0/>Gh0P0000000`2Sh_`000000;?Nm@070;?Nm@800000
00<0[=ch0000002ZeOH0202ZeOH4000000L0X/cf00<0000009o7m02Oao@01P2Oao@5000000L0V[ob
00<0000009Zkk`2J^nl01P2J^nl00`000000VKS]09Vhk@0309Vhk@H000000`2F[nP01@000000UZoX
09J_j02F[nP0000000D0PCIV00<0000008<jJ`000000100000001@1m7d@0000009Yk/02JNk000000
0080Q3e^00<000000:jLa02^W<@00P2^W<@00`000000oooo0?ooo`050?ooo`030000003oool0oooo
01D0oooo000A0?ooo`8000001@3oool00`000000oooo000000090:C2kP8000001`2U`^h00`000000
Yl;]0:O2k@060:O2k@<000001P2X`^`2000000L0Zl7Y0`0000070:g1j0030000002c_n<0/koS00<0
/koS0P0000020;30iP030000002h_ml0^;oO00P0^;oO00<000000<2nf030_]P01`30_]P00`000000
c[_8000000040<^lc080000000<0i]O70000000000000P0000060>;Lc`030000003Jh]/0f^;K0080
00001P2`iOP2000000@0Xn;l00<000000;?Nm@2cg_D00`2cg_D2000000@0[=ch00<000000:[EmP2Z
eOH0102ZeOH200000080Y=;h00<000000:;<mP2Rc?H01`2Rc?H010000000WlOd09o7m02Oao@40000
00<0VlCd00<0000009ZolP2J_o801P2J_o800`000000V[__09Zkk`0609Zkk`H00000102F/n/00`00
0000UZoX09J_j00309J_j0050000002F[nP0UZoX09J_j00000000P21=VH7000000<0OAm400D00000
09Yk/02JNk00VW^`0000000208@mKP050000002^W<@0[Yc40:jLa00000001`3oool00`000000oooo
0?ooo`0E0?ooo`00403oool010000000oooo0?ooo`0000040?ooo`80000000<0oooo000000000000
1@2T`^h2000000030:?3l0000000YL;^00L0YL;^00<000000:O2k@2W`^d00`2W`^d200000080YL?^
00<000000:S2k02X`^`01P2X`^`00`000000Zl7Y0:_1j@0400000080Z<;/00<000000:g1j02]`NP0
1P2]`NP00`000000/koS0;>oh`02000000D0/<3V00<000000;Rog`2h_ml01@2h_ml2000000030;C0
h`000000`;kH00P0`;kH00<000000<^lc03;_<`00`3;_<`4000000030>KGa`000000h]c?00D0h]c?
00<000000=[Rf`3Jh]/00`3Jh]/200000080/>Gh0P0000070:?Ro0030000002cg_D0/mke00800000
1`2/g?P00`000000Z]Gf0:[EmP03000000D0Y=;h00<000000:;<mP2Rc?H01P2Rc?H4000000P0VlCd
00<0000009ZolP2J_o801P2J_o8010000000V[__09Zkk`2J^nl400000080U[O^00<0000009Jcj`2F
/n/01@2F/n/00`000000UZoX09J_j00409J_j0030000002F[nP0UZoX00L000001P1m7d@01@000000
VW^`09Yk/02JNk0000000080Q3e^00<000000:jLa02^W<@00P2^W<@00`000000oooo0?ooo`050?oo
o`8000005@3oool00100oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?oo
o`030000002T`^h0Y<;^00800000102S`o000`000000YL;^0:G2kP060:G2kP030000002W`^d0Yl;]
008000001@2U`nh00`000000Z<;/0:S2k0050:S2k0<000001`2X`^`2000000H0[L7X0`0000080;30
iP030000002h_ml0^;oO0080^;oO0P0000040;C0h`0300000030_]P0`;kH00@0`;kH0P0000000`2l
_md000000<^lc003000000@0bkc<00<000000>;Lc`3Rg<l0103Rg<l00`000000f^;K0=[Rf`050=[R
f`<000002@2Sh_`3000000T0[=ch0`0000090:CBn0040000002Rc?H0X/cf0:;<mP@000000P2LbOL0
0`000000VlCd09_4m00709_4m0030000002J_o80V[ob00H0V[ob1000000609JgkP030000002F/n/0
U[?[00H0U[?[00<0000009J_j02F[nP0102F[nP00`000000UZoX09J_j0030000000307P?;P000000
OAm400H0OAm400D0000009Yk/02JNk00VW^`0000000208@mKP030000002^W<@0[Yc40080[Yc400<0
00000?ooo`3oool01@3oool2000001D0oooo000@0?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool0103oool2000000L0Xl?`00<000000:G2kP2U`^h01@2U`^h3000000L0YL?^00<0
00000:S2k02X`^`00`2X`^`200000080YL?^00<000000:S2k02X`^`01`2X`^`00`000000[L7X0:g1
j00300000080Z/;[00<000000;30iP2``>H01`2``>H010000000^;oO0000000000060;C0h`030000
0030_]P0`;kH0080`;kH0P0000020;bog@<000001P3;_<`00`000000a[kB000000040>;Lc`030000
003Jh]/0f^;K00@0f^;K0P0000001039j>`000000000000000040:?Ro0@000000P2AgOh00`000000
[=ch0:cLn0050:cLn08000000P2Rf_/00`000000Y=;h0:CBn0070:CBn0@000001`2LbOL00`000000
VlCd09_4m00709_4m0040000002J_o80V[ob09ZolP@000000P2F^o400`000000U[O^09JgkP0609Jg
kP030000002F/n/0U[?[00H0U[?[00<0000009J_j02F[nP00`2F[nP010000000UZoX09J_j0000003
07P?;P030000001m7d@0OAm400D0OAm400D0000009Yk/02JNk00VW^`0000000208@mKP030000002^
W<@0[Yc400<0[Yc400<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0C0?ooo`00403oool0
10000000oooo0?ooo`0000030?ooo`8000001P3oool00`000000Xl?`0:?3l0060:?3l0030000002U
`^h0YL;^00@000000P2S`o000`000000YL?^0:G3kP060:G3kP030000002X`^`0Z<;/008000001@2U
`nh00`000000Z<;/0:S2k0060:S2k0<000001P2Z`^/2000000L0/<3V0P0000090;C0h`0400000030
_]P0000000000080_;oM0P0000020;bog@030000003;_<`0bkc<0080bkc<0P0000030<JndP800000
00<0h]c?0000003Jh]/01@3Jh]/00`000000bNS/0<WXk0020<WXk0H000001`2AgOh200000080[=ch
0`0000050:;Jn`8000001@2Td_P200000080W=3j00<0000009c9m`2LbOL01`2LbOL00`000000VlCd
09_4m00309_4m0L000001`2F^o400`000000U[O^09JgkP0609JgkP030000002F/n/0U[?[00D0U[?[
00<0000009J_j02F[nP00`2F[nP50000000307P?;P000000OAm400L0OAm400<0000009Yk/02JNk00
0P2JNk000`000000Q3e^000000050:jLa0030000003oool0oooo00H0oooo00<000000?ooo`3oool0
4P3oool00140oooo0P0000040?ooo`030000003oool0oooo00H0oooo0P0000060:?3l0<000001`2S
`o02000000H0YL?^0`0000080:G3kP030000002X`^`0Z<;/00<0Z<;/0P0000020:G3k`030000002Z
`^/0Z/;[00H0Z/;[00<000000;30iP2``>H0100000020:c2j@030000002d`><0]<3S00H0]<3S0P00
0000102l_md000000000000000050;bog@040000003;_<`0bkc<000000L0a[kB00<000000=[Rf`3J
h]/0103Jh]/00`000000bNS/0<WXk0050<WXk0030000000QO^L08GkW008000001@2AgOh5000000X0
X][k00<000000:CBn02Td_P00P00000509c@nP030000002LbOL0W<Wg00H0W<Wg1P00000509K0m003
0000002F^o40U[_a00H0U[_a00<0000009JgkP2F]nh01P2F]nh00`000000U[?[09Jcj`0309Jcj`P0
00000P2CZND01@000000TjWU0000001h3bh0000000L0OAm400<0000009Yk/02JNk000`2JNk000`00
0000Q3e^000000060:jLa0030000003oool0oooo00H0oooo00<000000?ooo`3oool04@3oool001L0
oooo00<000000?ooo`3oool0203oool00`000000Xl?`0:?3l00300000080XLCb00<000000:?3l02S
`o001`2S`o000`000000YL?^0:G3kP0300000080X/Ca00<000000:G3kP2U`nh01`2U`nh00`000000
Z<;/0:S2k002000000D0YL?_00<000000:[2j`2Z`^/01@2Z`^/3000000L0[<;Y00<000000;C0h`2d
`><00`2d`><5000000P0_;oM00<000000<^lc00000002@36_]8200000080f^;K0P0000080<WXk0X0
0000101jeOh2000000T0X][k0`00000809c@nP040000002LbOL0W<Wg09c9m`@000000P2Ea_P00`00
0000U/3d09K0m00609K0m0030000002F^o40U[_a00L0U[_a00<0000009JgkP2F]nh00`2F]nh80000
00@0TZgY00<0000009>Yi@2CZND00`2CZND00`000000TjWU09>Yi@02000000L0OAm400<0000009Yk
/02JNk000`2JNk000`000000Q3e^000000050:jLa0800000203oool2000000P0oooo0`0000070?oo
o`005`3oool2000000X0oooo0P0000060:74lP8000001`2S`o03000000H0X/Ca0P0000070:G3kP<0
00001`2U`nl00`000000Z/;[0:[2j`030:[2j`8000000P2Va>l00`000000[<;Y0:c2j@060:c2j@03
0000002d`><0]<3S00@000000`2``^L00`000000_;oM0;bog@050;bog@8000002`36_]83000000P0
bNS/0P0000020:;Po00300000021/oD0PK?e0080PK?e0P00000707[EoP8000000`2Rf_/400000080
U=On00<0000009c@nP2Ld?X01P2Ld?X4000000L0ULKh00<0000009K0m02F`?@01P2F`?@00`000000
U[_a09Jkl@0509Jkl@L00000102A/^d00`000000TZgY09:]j@0509:]j@030000002CZND0TjWU00@0
TjWU00@0000009>Yi@00000000001`1m7d@00`000000VW^`09Yk/00309Yk/00300000024?Fh00000
00<0[Yc40P0000000`2`ZM4000000?ooo`070?ooo`8000002@3oool00`000000oooo0?ooo`060?oo
o`005`3oool00`000000oooo0?ooo`0:0?ooo`8000001`2Qa?800`000000Xl?`0:?3l00400000080
X<Gc00<000000:;4l@2Ra?401P2Ra?400`000000YL?^0:G3kP0400000080X/Ga00<000000:G3k`2U
`nl01P2U`nl00`000000Z/;[0:[2j`02000000D0Y/C_00<000000:c2j@2/`^T01@2/`^T4000000H0
/<;W00<000000;bog@2l_md00`2l_md200000080]/;T00<000000<JndP36_]801P36_]8200000003
0<33g00000000000008000000`39j>`3000000D0X^3l00<00000086cm@21/oD00P21/oD=000000L0
U=On0P00000209c@nP@000000P2@c_d00`000000ULKh09G6n00609G6n0030000002F`?@0U/3d00H0
U/3d00@0000009Jkl@2F^o40U[_a10000002092hl@030000002A/^d0TK;]00H0TK;]00<0000009:]
j@2B[NT01P2B[NT00`000000TjWU09>Yi@0409>Yi@030000002CZND0000000L0OAm400<0000009Yk
/02JNk00102JNk05000000@0/:WA00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?oo
o`D000001`3oool001H0oooo00<000000?ooo`3oool03@3oool2000000@0XLCb100000070:35l`80
00001P2Ra?43000000L0X/Ga00<000000:G3k`2U`nl01@2U`nl3000000L0Y/C_00<000000:c2j@2/
`^T00`2/`^T3000000030:O5k`000000/<;W00L0/<;W00<000000;bog@2l_md00P0000050;K2i003
00000036_]80a[kB00@0a[kB00D000000<33g030`m`0`<?L0000000306Z@i0<000002@2Rh?`01000
0000PK?e0000000000030<79h@8000001P1FaOL2000000H0U=On1@000007093>o@030000002Ea_P0
ULKh00H0ULKh00<0000009K0m02F`?@00`2F`?@6000000L0T;Sa00<00000096bk@2A/^d01P2A/^d0
0`000000TZgY09:]j@0609:]j@030000002CZND0TjWU00@0TjWU0P00000707dOA0030000002JNk00
VW^`00@0VW^`0P0000070;2Yd@030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool0
10000000oooo0?ooo`0000080?ooo`005P3oool00`000000oooo0000000?0?ooo`@000000`2Na_@2
000000P0X<Gc00<000000:;4l@2Ra?400`00000209o6m08000001`2RaO400`000000YL?_0:G3k`04
00000080XLKb00<000000:K4k`2Va>l01P2Va>l00`000000[<;Y00000002000000D0YlG_00<00000
0;32i`2``^L01P2``^L2000000P0]/;T00<000000<JndP36_]800P36_]800`000000`<?L0<33g003
0<33g0030000001ZT>@0JY3T00<0JY3T0P0000050:;Po0@000001`31bN4>000000@0O];o00<00000
093>o@2@c_d01P2@c_d00`000000ULKh09G6n00309G6n0P00000102>__L00`000000T;Sa092hl@06
092hl@030000002A/^d0TK;]00L0TK;]00<0000009:]j@2B[NT01@2B[NT00`000000TjWU09>Yi@03
09>Yi@@000001P1m7d@00`000000VW^`09Yk/00409Yk/0800000202`ZM400`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000203oool001H0oooo0P00000A0?oo
o`030000002Na_@0W/Kd00D0W/Kd0P0000040:35l`D000001`2Oa_@2000000@0X/Ga100000070:76
lP8000001P2Va>l3000000P0YlG_00<000000;32i`2``^L00`2``^L2000000030:S7k`000000]/;T
00P0]/;T00@000000<JndP00000000001`30`m`00`000000JY3T06Z@i00406Z@i0D00000101n]oP0
0`000000`LWQ0<79h@060<79h@D000000`0LYMd00`000000O];o07kBo`0607kBo`800000102@c_d8
000000@0R<Gl00<0000008jnm`2>__L01P2>__L00`000000T;Sa092hl@06092hl@030000002A/^d0
TK;]00H0TK;]00<0000009:]j@2B[NT00`2B[NT800000080S:_Z00<0000008b[jP0000001@1m7d@0
0`000000VW^`09Yk/00409Yk/0800000202`ZM400`000000oooo0?ooo`070?ooo`8000001@3oool2
000000P0oooo000F0?ooo`030000003oool0oooo0140oooo0P00000609k6m0D00000102Lb?H00`00
0000WlKd09o6m00609o6m0D000000`2Mb?H2000000P0XLKb00<000000:K4k`2Va>l00`0000020:38
m0800000202WaNl00`000000/<;W0;32i`02000000@0Z<O_00<000000;K2i02f`^@01P2f`^@20000
00T0`<?L00<0000006Z@i01ZT>@0100000020:jhh@030000001n]oP0O[Oh00@0O[Oh00<000000<79
h@31bN401P31bN401@000000^:[<000000000000bn;Y00H000001@1nd_l7000000@0N/_o00<00000
08S5o028aO`01P28aO`00`000000S[kg08jnm`0608jnm`030000002@^?40T;Sa00D0T;Sa00<00000
096bk@2A/^d00`2A/^d9000000@0RK7`00<0000008b[jP2<ZnX0102<ZnX8000000L0VW^`0P000008
0;2Yd@030000003oool0oooo00D0oooo0`00000?0?ooo`005P3oool00`000000oooo0000000C0?oo
o`030000002Na_@0W/Kd00<000000P2JbOP00`000000W<Sf09c8mP0509c8mP8000000P2Oa_@40000
0080V/[h00<0000009g8mP2Mb?H01@2Mb?H2000000@0XLKb1@0000070:38m0800000102WaNl50000
00L0Z<O_00<000000;K2i02f`^@00`2f`^@200000080Zl[`00<000000<33g030`m`01`30`m`20000
00L0[[SQ00<0000007jgn01n]oP0101n]oP00`000000`LWQ0<79h@030<79h@@000001`3;h^T70000
00@0Cl?d00<0000007[;o`1jbol01@1jbol00`000000R<Gl08S5o00608S5o0030000002>__L0S[kg
00<0S[kg4000000508BhmP0300000029/O00RK7`00D0RK7`00<0000008b[jP2<ZnX01@2<ZnX20000
00<0I00300<0000009Yk/02JNk001P2JNk02000000L0/:WA0P00000:0?ooo`030000003oool0oooo
00`0oooo000F0?ooo`8000005@3oool2000000H0V/Wh0P00000609c8mP<000001`2Jb_P2000000H0
WLSf1`00000209[:n0030000002Pb?@0X<Sd00H0X<Sd1@00000409k;m`030000002Xanl0Z<O_00H0
Z<O_00<000000;K2i02f`^@00P0000050:_:l00300000030`m`0`<?L00@0`<?L0P0000000`2cdo40
00000:jhh@070:jhh@`00000102E_?82000000L0bn;Y2000000204o3m0030000001jbol0N/_o00D0
N/_o00<0000008S5o028aO`00`28aO`8000000@0KlGo00<0000007foo01m_o`01@1m_o`00`000000
Q;Sf08BhmP0608BhmP0300000029/O00RK7`00H0RK7`00<0000008b[jP2<ZnX0102<ZnX2000000<0
I0030P00000409Yk/0@0000000<0/:cC0000002`ZM400`2`ZM42000000030:nbfP000000oooo00T0
oooo00<000000?ooo`3oool0303oool00080oooo100000030?ooo`800000103oool2000000@0oooo
00<000000?ooo`3oool05P3oool2000000L0V/Wh00<0000009c8mP2Lb?H00`00000209O<nP800000
202Jb_P00`000000WLSf09g8mP030000000409G=n`0000000000000000H0V/[h0P0000020:38m0@0
00000P2Dc_`00`000000W/_g09k;m`0509k;m`800000102Xanl5000000L0Zl[`00<000000<33g030
`m`00P30`m`2000000@0/m?a00<000000:jhh@2^^>400`2^^>42000000030<7Ul0000000QYcQ00D0
QYcQ00<0000009FllP2E_?801P2E_?89000000L0bmKR4000000405?3m`030000001_aOl0KlGo00H0
KlGo00<0000007foo01m_o`01@1m_o`00`000000Q;Sf08BhmP0608BhmP0300000029/O00RK7`00H0
RK7`00<0000008b[jP2<ZnX0102<ZnX20000000306@00`000000000000D000001@2`[=<00`000000
/:WA0;2Yd@02000000@0[k;J00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`00
0P3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`00
0000603oool2000000@0V/Wh1000000709O<nP800000102Jb_P50000000409G=n`00000000000000
00<0ULgk0P00000409[:n0@000001`2Dc_`00`000000W/_g09k;m`0509k;m`D00000102HdO/00`00
0000Zl[`0:_:l0060:_:l00400000030`m`00000000000H0/m?a00<000000:jhh@2^^>400P2^^>40
1@000000`NG`0<7Ul031iO00000000L0QYcQ00<0000009FllP2E_?800`2E_?8200000080/LGY00<0
000008RZk028Z^`01028Z^`00`000000bmKR0<_FhP060<_FhP<000001P2KfOd800000080Dl?g0P00
000706o5o`030000001m_o`0OKol00D0OKol00<0000008BhmP24^?H01@24^?H00`000000RK7`08Va
l00608Val0030000002<ZnX0S:_Z00D0S:_Z00<0000006@00`0000000P2a[mH00`000000/:cC0;2/
d`060;2/d`<000001P2_/]X00`000000oooo0?ooo`080?ooo`800000303oool000<0oooo00<00000
0?ooo`3oool02`3oool010000000oooo0?ooo`3oool2000001/0oooo1000000309?>o08000001`2G
c?X5000000<0T<om0`00000709G=n`D000000`2;dOl2000000L0U<kl00<0000009k;m`2NboL01000
000208GDo`030000002HdO/0V=7k00D0V=7k0P0000040:_:l0@000002@2cdo4010000000[[SQ0000
000000050<7Ul00300000026W>40QYcQ00D0QYcQ00<0000009FllP2E_?800P0000050;75j@030000
0028Z^`0R:[/00@0R:[/0P0000020<_FhP@000000P2FgOh00`000000VmWm09_Io@0509_Io@030000
002T_>X0Y;cZ00@0Y;cZ;P0000040;6_eP030000002`[=<0/:cC00<0/:cC0P0000020:ndg0030000
002_/]X0[k;J00D0[k;J00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`00103o
ool00`000000oooo0?ooo`080?ooo`800000103oool00`000000oooo0?ooo`0K0?ooo`030000002C
c_`0Tlkl00D0Tlkl0P00000209O<nP<000000P2;dOl200000004093?o@000000000000000080T<om
0P00000209G=n`@000000P22dol00`000000Rm7o08_Ao`0508_Ao`800000102Dc_`4000000L0QMCo
0P00000409SAn`L000001023f_h00`000000/m?a0;?Cl@060;?Cl@8000002031iO000`000000QYcQ
08JLh@0408JLh@<000001`2aaNT00`000000R:[/08RZk00508RZk0<000001`2FgOh2000000H0VmWm
00<000000:BljP2T_>X01@2T_>X00`000000XjCF0:>TeP050:>TeP040000002PULP0X9G80:2Eb0l0
0000102cZm400`000000/ZK=0;:Vc@02000000@0/K?J00@000000;6_eP2a[mH00000102a[mH00`00
0000/:cC0;2/d`03000000@0[kCL00<000000:nbfP2_/]X01@2_/]X00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00T0oooo00020?ooo`040000003oool0oooo000000T0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0L0?ooo`800000102Cc_`5000000H0Rm7o0`000004093?
o@@000001`22dol2000000@0Rm7o1`00000406oCo08000001@25e?l<000000H0Pm[n0P0000020;?C
l@@000000P2<`oX2000000H0`NG`00<0000008JLh@26W>40100000020:C1kP030000002aaNT0/LGY
00H0/LGY00<0000008RZk028Z^`0100000020:C1kP8000001@2FgOhM000000040;FUb@0000000000
000000H0];7F00<000000;>[d@2cZm401P2cZm43000000H0/K?J00D000000;6_eP2a[mH0/JoF0000
00030;6_eP<00000202_]=`00`000000[k;J0:nbfP040:nbfP8000002`3oool00`000000oooo0?oo
o`080?ooo`000`3oool2000000X0oooo0`0000030?ooo`8000007`3oool4000000@0Q]?o0P000002
08_Ao`X00000101ge?h2000000D0P]?o1P00000505O=l0h000001@2;L:l010000000Rg^m08]k_@2;
Nkd<000000P0S<?j2@0000070:C1kP030000002aaNT0/LGY00D0/LGY0`0000080:C1kPD00000102P
Z=`00`000000OjS^07nXkP0407nXkP80000000<0^[cK0000002h[]001`2h[]000`000000]JG90;FU
b@020;FUb@80000000<0];OK0000002d/MH01`2d/MH00`000000/j_A0;>[d@030;>[d@8000000P2a
]md00`000000/K?J0;6cfP050;6cfP040000002a[mH0/JoF0;6_eP<000000P2_]ml00`000000[kCL
0:ndg0060:ndg0030000002_/]X0[k;J00@000000P2^^>400`000000oooo0?ooo`080?ooo`030000
003oool0oooo00P0oooo000E0?ooo`030000003oool0oooo0200oooo0P00000508KCo`H000001@1/
doXI000000H0RfJR00<0000008]ZY`2;JZL00`2;JZL00`000000Rg2_08]`[`0408]`[`030000002;
Nkd0Rg^m00@0Rg^m00<0000008ZCeP2:TmH0102:TmH00`000000S<?j08c3nP0408c3nP80000000<0
Z:oL00000026W>401@26W>400`000000Y<7^0:C1kP060:C1kP030000002aaNT0/LGY00@000000P2T
`Nh00`000000Y<7^0:C1kP050:C1kP<000001`2PZ=`00`000000OjS^07nXkP0207nXkP8000000`2j
_=/00`000000^:k@0;R^d0060;R^d0030000002eYLT0]JG900800000102d]m/00`000000];7F0;Ba
eP050;BaeP030000002cZm40/j_A00<00000102a]md00`000000/K?J0;6cfP050;6cfP030000002a
[mH0/JoF00800000102_]ml00`000000[kCL0:ndg0060:ndg0<000001P2^^>400`000000oooo0?oo
o`080?ooo`8000002@3oool001@0oooo00<000000?ooo`3oool08`3oool5000000D0HM3d1`000005
08]NV0030000002;H9X0Rf2J00<0Rf2J00<0000008]QW02;HI`00`2;HI`00`000000Rf>N08]SWP03
08]SWP030000002;IZ80RfJR00@0RfJR00<0000008]ZY`2;JZL0102;JZL00`000000Rg2_08]`[`03
08]`[`030000002;Nkd0Rg^m00@0Rg^m00<0000008ZCeP2:TmH01@2:TmH200000080S<?j0P000004
0:R_g00300000026W>40QYcQ00@0QYcQ00<000000:C1kP2T`Nh01@2T`Nh3000000L0Y<7^00<00000
0:C1kP2T`Nh00P2T`Nh2000000<0`>Oa00<000000:2Xg02PZ=`01@2PZ=`010000000OjS^00000000
00060;Zlf`030000002h[]00^:k@00D0^:k@0`0000060;Bgf`030000002d/MH0];7F00D0];7F0`00
00080;6gg@030000002a/mX0/K?J00@0/K?J0`0000020:ngg`030000002_]ml0[kOO0080[kOO00<0
00000:ndg02_]=`00`2_]=`200000080[K[S00<000000:jhh@2^^>401@2^^>400`000000oooo0?oo
o`030?ooo`@0000000<0oooo0000003oool0203oool001@0oooo0`00000R0?ooo`<000000P3oool6
000000H0oooo00<0000008]NV02;GYP00`2;GYP00`000000Rf2J08]PVP0308]PVP030000002;HI`0
Rf6L00<0Rf6L00<0000008]SWP2;Hih0102;Hih00`000000RfJR08]VXP0408]VXP030000002;JZL0
RfZW00<0RfZW00<0000008]`[`2;L:l00`2;L:l00`000000Rg^m08]k_@0508]k_@030000002:TmH0
RY?F00H0RY?F0P0000060:R_g00300000026W>40QYcQ00D0QYcQ00<000000:C1kP2T`Nh010000002
0:7>m`030000002T`Nh0Y<7^00H0Y<7^00@000000:C1kP00000000001@30io400`000000X:SL0:2X
g0050:2Xg08000002@2j_=/00`000000^:k@0;R^d0020;R^d080000000<0/l3T0000002d]m/01`2d
]m/00`000000];7F0;BaeP020;BaeP8000000P2`^n800`000000/KOM0;6gg@060;6gg@030000002a
/mX0/K?J00@000000P2^^^801@000000[kOO0:ngg`2_]ml0000000<0[kOO00<000000:ndg02_]=`0
0`0000040:fjh`030000002^^>40[[SQ00D0[[SQ00<000000?ooo`3oool00`0000050?ooo`030000
003oool0oooo00L0oooo000D0?ooo`030000003oool0oooo01l0oooo0`00000A0?ooo`030000002;
GYP0RejH00<0RejH00<0000008]PVP2;H9X00`2;H9X00`000000Rf6L08]QW00408]QW0030000002;
Hih0Rf>N00<0Rf>N00<0000008]VXP2;IZ80102;IZ800`000000RfZW08]ZY`0308]ZY`030000002;
L:l0Rg2_00@0Rg2_00<0000008]k_@2;Nkd0102;Nkd00`000000RY?F08ZCeP0408ZCeP80000000<0
`<gT0000002X[m`01P2X[m`00`000000QYcQ08JLh@0408JLh@<000001`2Qc_L00`000000Y<7^0:C1
kP050:C1kP8000002030io400`000000X:SL0:2Xg0020:2Xg08000000P2be?800`000000^[cK0;Zl
f`060;Zlf`030000002h[]00^:k@00800000102c`>@00`000000];OK0;Bgf`050;Bgf`030000002d
/MH0];7F008000001@2`^n800`000000/KOM0;6gg@050;6gg@<000001P2^^^800`000000[kOO0:ng
g`020:ngg`030000002_]ml0[kOO00<00000202]^^<00`000000[[SQ0:jhh@040:jhh@<00000203o
ool00`000000oooo0?ooo`070?ooo`00503oool00`000000oooo0?ooo`0L0?ooo`<00000503oool0
0`000000RejH08]NV00308]NV0030000002;H9X0Rf2J00<0Rf2J00<0000008]QW02;HI`0102;HI`0
0`000000Rf>N08]SWP0308]SWP030000002;IZ80RfJR00@0RfJR00<0000008]ZY`2;JZL00`2;JZL0
0`000000Rg2_08]`[`0408]`[`030000002;Nkd0Rg^m00D0Rg^m00@0000008ZCeP2:TmH0RY?F0P00
00040<3=i0030000002X[m`0Z:oL00@0Z:oL00<0000008JLh@26W>40100000020:BgiP030000002Q
c_L0XLkg00H0XLkg00<000000:C1kP2T`Nh0100000020:C1kP8000001P30io400`000000X:SL0:2X
g002000000D0/]Cb00<000000;Zlf`2j_=/01@2j_=/3000000H0/l3T00<000000;Bgf`2d]m/01@2d
]m/3000000L0/;_R00<000000;6gg@2a]md00`2a]md200000080[KgV00<000000:jjhP2^^^801@2^
^^8010000000[kOO0:ngg`2_]ml300000080[KcU00<000000:fjh`2]^^<01P2]^^<00`000000[[SQ
0:jhh@0400000080[;cU00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`00503o
ool2000001/0oooo0P00000G0?ooo`030000002;GYP0RejH00<0RejH00<0000008]PVP2;H9X0102;
H9X00`000000Rf6L08]QW00308]QW0030000002;Hih0Rf>N00<0Rf>N00<0000008]VXP2;IZ80102;
IZ800`000000RfZW08]ZY`0308]ZY`030000002;L:l0Rg2_00@0Rg2_00<0000008]k_@2;Nkd01@2;
Nkd010000000RY?F0000000000060<3=i0030000002X[m`0Z:oL00@0Z:oL0`0000070:BgiP800000
102Qc_L5000000P0Y<7^2@0000070;;DlP030000002j_=/0^[cK00<0^[cK0P0000020:_;l@030000
002c`>@0/l3T00D0/l3T00<000000;Bgf`2d]m/00P2d]m/200000080[/7X00<000000;2khP2`^n80
1P2`^n800`000000/KOM0;6gg@02000000@0[KgV00<000000:jjhP2^^^801@2^^^800`000000[kOO
0:ngg`03000000<0[KcU00<000000:fjh`2]^^<01P2]^^<3000000H0[;cU00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`060?ooo`00503oool00`000000oooo0?ooo`0G0?ooo`<000006@3o
ool00`000000RejH08]NV00408]NV0030000002;H9X0Rf2J00<0Rf2J00<0000008]QW02;HI`00`2;
HI`00`000000Rf>N08]SWP0308]SWP030000002;IZ80RfJR00@0RfJR00<0000008]ZY`2;JZL00`2;
JZL00`000000Rg2_08]`[`0508]`[`030000002;Nkd0Rg^m00D0Rg^m00<000000<3=i030cN@01`30
cN@00`000000Z:oL0:R_g00300000080Tmon00<000000:BgiP2T]nH01`2T]nH4000000@0V:SQ00<0
00000:C1kP2T`Nh0102T`Nh2000000030;k9hP000000OJcb00D0OJcb00<000000;;DlP2be?801P2b
e?800`000000^[cK0;Zlf`02000000@0Zl_a00<000000;?0i02c`>@01@2c`>@00`000000];OK0;Bg
f`02000000D0[/7X00<000000;2khP2`^n801@2`^n83000000L0[KgV00<000000:jjhP2^^^80102^
^^83000000<0[KcU00D000000:fli@2]_>D0[KcU000000050:fjh`8000000P2[_NL00`000000[;cU
0:bli@050:bli@030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool001<0oooo00<0
00000?ooo`3oool05@3oool3000001`0oooo00<0000008]NV02;GYP0102;GYP00`000000Rf2J08]P
VP0308]PVP030000002;HI`0Rf6L00<0Rf6L00<0000008]SWP2;Hih00`2;Hih00`000000RfJR08]V
XP0408]VXP030000002;JZL0RfZW00@0RfZW00<0000008]`[`2;L:l0102;L:l00`000000Rg^m08]k
_@0308]k_@80000000<0`^ka00000030cN@01`30cN@3000000H0Tmon00<000000:BgiP2T]nH0102T
]nH2000000030;G`m@000000V:SQ00D0V:SQ00<000000:C1kP2T`Nh00P2T`Nh2000000@0_/WR00<0
000007f/lP1m[?80101m[?82000000@0/]Cb1@0000070:_;l@030000002c`>@0/l3T00@0/l3T0`00
00070:k1j0030000002`^n80/;_R00<0/;_R0P0000020:_1jP030000002]_NH0[KgV00D0[KgV00<0
00000:jjhP2^^^80100000020:^oj0050000002]_>D0[KcU0:fli@0000000`2]_>D00`000000[K[S
0:fjh`03000000@0ZkgW00<000000:bli@2/_>D01@2/_>D2000000L0oooo00<000000?ooo`3oool0
1P3oool001<0oooo00<000000?ooo`0000004P3oool3000001l0oooo00<0000008]NV02;GYP0102;
GYP00`000000Rf2J08]PVP0308]PVP030000002;HI`0Rf6L00<0Rf6L00<0000008]SWP2;Hih00`2;
Hih00`000000RfJR08]VXP0508]VXP030000002;JZL0RfZW00<0RfZW00<0000008]`[`2;L:l0102;
L:l010000000Rg^m08]k_@2;Nkd2000000@0`^ka0P0000020<3=i0@000000P2T[Mh2000000D0Tmon
00<000000:BgiP2T]nH00P2T]nH2000000<0]O3e00<0000009RXh@2HZ>401@2HZ>4010000000Y<7^
0000000000070;k9hP030000001m[?80OJcb0080OJcb1`00000407W?o`030000002[bo40Zl_a00D0
Zl_a00<000000;?0i02c`>@0100000020:S7l0030000002^`NP0[/7X00H0[/7X00<000000;2khP2`
^n800P0000040:_1jP030000002]_NH0[KgV00D0[KgV0`0000060:^oj0030000002]_>D0[KcU0080
[KcU00<000000:fli@2]_>D00`0000080:^mi`030000002/_>D0[;cU0080[;cU0P0000020:Znj@03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool001<0oooo0P00000@0?ooo`<00000
8P3oool00`000000RejH08]NV00408]NV0030000002;H9X0Rf2J00<0Rf2J00<0000008]QW02;HI`0
0`2;HI`00`000000Rf>N08]SWP0308]SWP030000002;IZ80RfJR00D0RfJR00<0000008]ZY`2;JZL0
0`2;JZL00`000000Rg2_08]`[`0508]`[`<000001`32k_43000000P0Y:gN1000000209?OoP040000
002T]nH00000000000H0]O3e00<0000009RXh@2HZ>401@2HZ>400`000000_/WR0;k9hP080;k9hP@0
0000102KYM`2000000H0NLoo00<000000:_;l@2[bo400P2[bo45000000H0Z<O`00<000000:k1j02^
`NP01P2^`NP3000000L0Zl7Z00<000000:fmiP2]_NH0100000020:W1j`030000002[_nP0ZkoX00D0
ZkoX00<000000:fli@2]_>D0100000020:Zoj@030000002[_NL0ZkgW00H0ZkgW00<000000:bli@2/
_>D00P0000040:Znj@030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool000`0oooo
0P0000050?ooo`030000003oool0oooo00`0oooo0`00000U0?ooo`030000002;GYP0RejH00@0RejH
00<0000008]PVP2;H9X00`2;H9X00`000000Rf6L08]QW00308]QW0030000002;Hih0Rf>N00@0Rf>N
00<0000008]VXP2;IZ80102;IZ800`000000RfZW08]ZY`0308]ZY`030000002;L:l0Rg2_00D0Rg2_
0P0000040<;^l@@000000P2QULT00`000000Y:gN0:B]gP050:B]gP030000003Fjn<0e^_S00L00000
202el?D00`000000V:SQ09RXh@0209RXh@80000000<0VNch0000002nbN801P2nbN83000000T0VjGL
2`00000409C=n`030000002Xao00Z<O`00D0Z<O`00@000000:k1j02^`NP0[/7X100000020:K5k`03
0000002[`NX0Zl7Z00D0Zl7Z0`0000060:W1j`030000002[_nP0ZkoX00D0ZkoX0`0000030:Zoj@04
0000002Z_nT0Z[oY000000P0ZkgW0`0000070:Znj@030000003oool0oooo00<0oooo00<000000?oo
o`3oool01P3oool000/0oooo00@000000?ooo`3oool00000103oool2000000X0oooo0`00000X0?oo
o`030000002;GYP0RejH00@0RejH00<0000008]PVP2;H9X00`2;H9X00`000000Rf6L08]QW00308]Q
W0030000002;Hih0Rf>N00@0Rf>N00<0000008]VXP2;IZ80102;IZ800`000000RfZW08]ZY`0308]Z
Y`030000002;L:l0Rg2_00<0Rg2_0P00000209cdg@@000001P2QULT00`000000Y:gN0:B]gP040:B]
gP030000003Fjn<0e^_S0080e^_S0P00000308Ye]PL000000P2el?D00`000000V:SQ09RXh@020000
00@0VNch00<000000;k9hP2nbN800P2nbN82000000<0^lST00<0000009^Ug02KYM`0102KYM`20000
0080`;;<0`00000303J_l0030000002DcO/0U<gk00D0U<gk00<000000:S7l02Xao000P2Xao060000
00L0Y/G_00<000000:_1jP2[`NX0100000020:K4k`030000002Y`N/0ZL7[00D0ZL7[00<000000:^o
j02[_nP0100000020:S2k0050000002Z_nT0Z[oY0:Zoj@0000000`2Z_nT010000000ZkgW0:^mi`2[
_NL4000000030:W0jP000000Z[kY00L0Z[kY00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`050?ooo`003P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo0P00000[
0?ooo`030000002;GYP0RejH00@0RejH00<0000008]PVP2;H9X00`2;H9X00`000000Rf6L08]QW004
08]QW0030000002;Hih0Rf>N00<0Rf>N00<0000008]VXP2;IZ80102;IZ800`000000RfZW08]ZY`04
08]ZY`030000002;L:l0Rg2_008000000P2Lm=d30000000309j=`@000000XIG900L0XIG900<00000
0:B]gP2T[Mh00P2T[Mh00`000000e^_S0=K[h`020=K[h`040000002[QJ`0ZhF/000000L0RWFf3000
000209W/n0040000002nbN800000000000D0^lST00<0000009^Ug02KYM`00`2KYM`00`000000`;;<
0<2bc0020<2bc0030000003F^[h0000000D00000102DcO/7000000@0VlWg00<000000:K5k`2VaNl0
1P2VaNl3000000H0Y/C_00<000000:W1j`2Y`N/01@2Y`N/3000000H0Z<;/00<000000:Zoj@2Z_nT0
0P2Z_nT00`000000Z[oY0:Zoj@04000000H0ZL3Z00<000000:Znj@2Z_^T01@2Z_^T2000000D0oooo
00<000000?ooo`3oool01@3oool000`0oooo0P0000040?ooo`030000003oool0oooo00D0oooo0`00
000]0?ooo`030000002;GYP0RejH00@0RejH00<0000008]PVP2;H9X00`2;H9X00`000000Rf6L08]Q
W00408]QW0030000002;Hih0Rf>N00<0Rf>N00<0000008]VXP2;IZ80102;IZ800`000000RfZW08]Z
Y`0408]ZY`L000001@2NSL400`000000XIG90:6Eb@060:6Eb@040000002T[Mh0Y:gN000000@0e^_S
00D000000:^5[02[QJ`0ZhF/0000000808Ye]P8000001@27S=8010000000RHgA08V=d@29SM440000
00P0^lST00D0000009^Ug02KYM`0VjGL000000050<2bc0040000003F^[h0e[Zn0=Jj_PP00000101j
aol00`000000VlWg09_9m`0509_9m`8000000P2VaNl400000080W/Od00<000000:K4k`2Va>l01@2V
a>l00`000000ZL7[0:W1j`0400000080YLC_00<000000:S2k02X`^`01@2X`^`00`000000Z[oY0:Zo
j@0400000080Yl;/00<000000:W0jP2Y`>X01@2Y`>X010000000Z[kY0:Znj@2Z_^T4000000030:S0
j`000000oooo00@0oooo00<000000?ooo`3oool01@3oool000`0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`<00000<03oool00`000000RejH08]NV00408]NV0030000002;
H9X0Rf2J00<0Rf2J00<0000008]QW02;HI`0102;HI`00`000000Rf>N08]SWP0308]SWP030000002;
IZ80RfJR00D0RfJR00<0000008]ZY`2;JZL00`2;JZL40000000309j:_P000000WXg100D0WXg100<0
00000:6Eb@2QULT01P2QULT00`000000Y:gN000000040=K[h`030000002[QJ`0ZhF/0080ZhF/00<0
000008Ye]P2:MKH01P2:MKH00`000000bj>`0000000508N<dP0300000029SM40RHgA00@0RHgA00<0
00000;_8i02kb>@01@2kb>@010000000VjGL0000000000050<2bc0030000003F^[h0e[Zn0080e[Zn
00<000000>:m/P3R_K801000000607[7o`800000102KbOL5000000H0W/Od00<000000:K4k`2Va>l0
1@2Va>l3000000H0YLC_00<000000:S2k02X`^`01@2X`^`3000000<0Yl;/00@000000:O2k02W`^`0
00001`2Y`>X4000000H0Z<3[00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`00
303oool3000000<0oooo1@00000d0?ooo`030000002;GYP0RejH00<0RejH00<0000008]PVP2;H9X0
0`2;H9X00`000000Rf6L08]QW00408]QW0030000002;Hih0Rf>N00<0Rf>N00<0000008]VXP2;IZ80
1@2;IZ8010000000RfZW08]ZY`2;JZL2000000H0WXZn00<0000009j=`@2NSL40102NSL400`000000
XIG90:6Eb@060:6Eb@8000000`3Fjn<00`000000ZhF/0:^5[0040:^5[0030000002:MKH0RWFf00@0
RWFf00@000000<^S/03;Xk0000001@27S=800`000000RHgA08V=d@0508V=d@800000102kb>@30000
00L0`;;<00<000000=Jj_P3F^[h00P3F^[h010000000h[fb0>:m/P3R_K8?000000@0SlSk00<00000
09k7m02Nao@01@2Nao@00`000000Y/C_0:K4k`0400000080X<Gc00<000000:G4k`2Ua>l01@2Ua>l0
0`000000Z<;/0:S2k00400000080YL?_00D000000:O2k02W`^`0Yl;/000000030:O2k0030000002Y
`>X0ZL3Z00@000000P2V`^d00`000000Z<3[0:S0j`050:S0j`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01@3oool00180oooo0P00000g0?ooo`030000002;GYP0RejH00<0RejH00<00000
08]PVP2;H9X00`2;H9X00`000000Rf6L08]QW00408]QW0030000002;Hih0Rf>N00<0Rf>N00<00000
08]VXP2;IZ801@2;IZ800`000000RfZW00000002000000L0WXZn00<0000009j=`@2NSL40102NSL40
0`000000XIG90:6Eb@040:6Eb@8000000P3;g>D3000000L0ZhF/00<0000008Ye]P2:MKH00`2:MKH0
0`000000bj>`0<^S/0020<^S/00300000027S=80QhcB00<0QhcB00<0000008V=d@29SM401P29SM44
000000<0WKo`00<000000<2bc030//`00`30//`00`000000e[Zn0=Jj_P020=Jj_P050000003R_K80
h[fb0>:m/P0000000`3X_ZT4000000D0Gkcm00<0000008o8n`2?b?/01@2?b?/00`000000W/Od09k7
m00209k7m0D000001P2PaO<00`000000YLC_0:G4k`050:G4k`<000001P2U`nl00`000000Yl;/0:O2
k0020:O2k0030000002W`^`0Yl;/00<000001P2V`^d00`000000Z<3[0:S0j`050:S0j`8000000`3o
ool00`000000oooo0?ooo`050?ooo`004`3oool00`000000oooo0?ooo`0e0?ooo`030000002;GYP0
RejH00<0RejH00<0000008]PVP2;H9X00`2;H9X00`000000Rf6L08]QW00408]QW0030000002;Hih0
Rf>N00<0Rf>N00<0000008]VXP2;IZ801@2;IZ82000000<0WXVn00<0000009j:_P2NR[h0102NR[h0
0`000000WXg109j=`@0509j=`@040000002QULT0XIG90:6Eb@8000001@3;g>D2000000L0ZhF/00<0
000008Ye]P2:MKH00`2:MKH00`000000bj>`0<^S/0020<^S/00300000027S=80QhcB00<0QhcB00<0
000008V=d@29SM401029SM42000000030;:XcP000000WKo`00@0WKo`00<000000<2bc030//`00P30
//`00`000000e[Zn0=Jj_P030=Jj_P050000003R_K80h[fb0>:m/P0000000`3X_ZT00`000000k;jS
0000000500000080Gkcm00<0000008o8n`2?b?/00P2?b?/7000000@0UlOh00<000000:35l`2PaO<0
1@2PaO<00`000000YLC_0:G4k`0400000080XLGb00<000000:G3k`2U`nl01@2U`nl00`000000Yl;/
0:O2k00400000080YL?_00<000000:K2k@2V`^d01@2V`^d00`000000Z<3[0:S0j`0400000080Y/;]
00D000000?ooo`3oool0oooo000000060?ooo`00503oool2000003D0oooo00<0000008]NV02;GYP0
0`2;GYP00`000000Rf2J08]PVP0308]PVP030000002;HI`0Rf6L00@0Rf6L00<0000008]SWP2;Hih0
102;Hih00`000000RfJR08]VXP0208]VXP8000001@2NRKh00`000000WXZn09j:_P0409j:_P030000
002NSL40WXg100D0WXg100@000000:6Eb@00000000001P3;g>D00`000000ZhF/000000070:^5[003
0000002:MKH0RWFf0080RWFf00<000000<^S/03;Xk00103;Xk000`000000QhcB08N<dP0308N<dP04
00000029SM40RHgA08V=d@8000000`2bZ<h00`000000WKo`09fol00409fol00500000030//`0`;;<
0<2bc0000000103F^[h00`000000h[fb0>:m/P020>:m/P040000003X_ZT0j;jY000000<0k;jS1000
00000`14[_L0000000000005000000@0PLGm00<0000009O7n02GaoP01@2GaoP00`000000X<Gc0:35
l`020:35l`D000001P2QaO800`000000YL?_0:G3k`050:G3k`<000000P2U`nl01@000000YL?_0:G3
k`2U`nl0000000L0Y/;]0`0000070:K2k@040000003oool0oooo000000H0oooo000F0?ooo`030000
003oool0oooo0380oooo00<0000008]NV02;GYP00`2;GYP00`000000Rf2J08]PVP0308]PVP030000
002;HI`0Rf6L00@0Rf6L00<0000008]SWP2;Hih0102;Hih00`000000RfJR08]VXP020000000309j:
_P000000WXVn00D0WXVn00<0000009j:_P2NR[h0102NR[h00`000000WXg109j=`@0509j=`@030000
003;g>D0bmcU00@0bmcU0P0000030:^5[0030000002[QJ`0ZhF/00D0ZhF/00D0000008Ye]P2:MKH0
RWFf000000060<^S/0@000000P27S=8010000000RHgA0000000000060;:XcP030000002M_o00WKo`
00@0WKo`00<000000<2bc00000001@3F^[h01@000000h[fb0>:m/P3R_K80000000<0j;jY00@00000
0>bnX`3/_Z<000000`3__Ih3000000<0A:kg00<000000875o@21aOd01@21aOd00`000000UlOh09O7
n00209O7n0L00000102Ka_H00`000000XLGb0:75lP050:75lP030000002U`nl0YL?_00@000000P2R
a?401@000000YL?_0:G3k`2U`nl0000000<0YL?_00<000000:K2k@2V`^d0100000020:C3k`030000
002V`^d0Y/;]00D0Y/;]0P0000000`3oool000000?ooo`050?ooo`005`3oool00`000000oooo0?oo
o`0a0?ooo`030000002;GYP0RejH00<0RejH00<0000008]PVP2;H9X0102;H9X00`000000Rf6L08]Q
W00408]QW0030000002;Hih0Rf>N00<0Rf>N0`00000309j:_P030000002NRKh0WXVn00@0WXVn00<0
000009j:_P2NR[h0102NR[h00`000000WXg109j=`@0309j=`@80000000<0]koP0000003;g>D00`3;
g>D00`000000ZhF/0:^5[0030:^5[0030000002[QJ`0ZhF/00D0ZhF/00@0000008Ye]P2:MKH00000
1`3;Xk0010000000QX_A08J;d@26Rm44000000T0/ZS>1000000209fol00300000030//`0000000@0
e[Zn00<000000>:m/P3R_K800P3R_K801@000000j;jY0>RnZ@3X_ZT000000080k;jS00H000000>nm
WP3__Ih0kkfN0000003`_IX6000000@0PLGm1`00000408o6nP030000002Ka_H0VlKf00D0VlKf00<0
00000:75lP2QaO800P2QaO85000000L0X/Ca00@000000:G3k`2U`nl0YL?_1P0000070:C3k`030000
002V`^d0Y/;]00@0000000@0Y<;_0000003oool000001P3oool001P0oooo00<000000?ooo`3oool0
<03oool00`000000RejH08]NV00308]NV0030000002;H9X0Rf2J00@0Rf2J00<0000008]QW02;HI`0
102;HI`00`000000Rf>N08]SWP0308]SWP030000002NR[h0WXZn00<0WXZn00<0000009j9_P2NRKh0
102NRKh00`000000WXZn09j:_P0409j:_P040000002NSL40WXg109j=`@800000102g_n0200000003
0<_Li@000000ZhF/00D0ZhF/00<000000:^5[02[QJ`01@2[QJ`00`000000RWFf000000070<^S/003
0000003H[jl0000000D0QX_A00<000000;:XcP2bZ<h01P2bZ<h00`000000bk_;0000000206JWm@@0
00001@3F^[h00`000000h[fb0>:m/P020>:m/P040000003X_ZT0j;jY000000<0k;jS00@000000>nm
WP3__Ih000000`3`_IX30000000302VNkP000000000000<00000101d`?h00`000000SlKj08o6nP05
08o6nP030000002Ka_H0VlKf0080VlKf1`00000409g5m0030000002Ra?40X/Ca00D0X/Ca1P000003
0:;3l0030000002T`nl0Y<?_00D0Y<?_0`0000060:C2k`8000001P3oool001T0oooo0P00000`0?oo
o`030000002;GYP0RejH00@0RejH00<0000008]PVP2;H9X00`2;H9X00`000000Rf6L08]QW00408]Q
W0040000002;Hih0Rf>N08]SWP8000001P2NR[h00`000000WXVn09j9_P0509j9_P030000002NR[h0
WXZn00@0WXZn0`0000080;Noh0030000002[QJ`0ZhF/00D0ZhF/00<000000:^5[02[QJ`01P2[QJ`2
000000L0bj>`00<000000=R_[`0000001P26Rm400`000000/ZS>0;:XcP040;:XcP040000003;^l/0
bk_;000000H0IZOe00D000000=Jj_P3F^[h0e[Zn000000040>:m/P050000003X_ZT0j;jY0>RnZ@00
00000`3/_Z<010000000kkfN0>nmWP0000030?2mVP030000003b_9H0000000D000001P1d`?h00`00
0000SlKj08o6nP0208o6nPL00000102FaOL00`000000WLGd09g5m00509g5m0030000002Ra?40X/Ca
00@0000000<0WlCc0000002R`o000P2R`o000`000000X/?`0:;3l0020:;3l0030000002T`nl0Y<?_
00@0000000<0X/?`0000002T`^l01P2T`^l2000000H0oooo000K0?ooo`030000003oool0oooo02d0
oooo00<0000008]NV02;GYP0102;GYP00`000000Rf2J08]PVP0308]PVP030000002;HI`0Rf6L00@0
Rf6L00@0000008]SWP00000000000P2NRkl00`000000WXZn09j:_P0409j:_P030000002NRKh0WXVn
00@0WXVn00<0000009j:_P2NR[h00`2NR[h2000000P0]koP0`0000070:^5[0030000002[QJ`0ZhF/
00H0ZhF/00<000000<^S/03;Xk001@3;Xk001@000000f:n_0=R_[`3H[jl0000000D0QX_A00<00000
0;:XcP2bZ<h00P2bZ<h2000000@0bk_;00<0000006JWm@1VYoD00`1VYoD01@000000e[Zn0=Jj_P3F
^[h0000000@0h[fb00D000000>RnZ@3X_ZT0j;jY000000020>bnX`050000003__Ih0kkfN0>nmWP00
00000P3`_IX010000000l[bF0?:lUP3b_9H30000000300n=h`000000000000X000001027a?/00`00
0000U/Gg09K5m`0509K5m`030000002MaO@0WLGd0080WLGd1@00000609o4l`050000002R`o00X/?`
0:;3l00000000`2R`o03000000H0X/?`00<000000:C2k`2T`^l0102T`^l2000000H0oooo000L0?oo
o`030000003oool0oooo02`0oooo00<0000008]NV02;GYP0102;GYP00`000000Rf2J08]PVP0308]P
VP030000002;HI`0Rf6L00<0Rf6L0`00000409j;_`030000002NR[h0WXZn00@0WXZn00<0000009j9
_P2NRKh01@2NRKh00`000000WXZn0000000200000080ZJ?@00<000000;Noh02g_n00102g_n001000
0000ZXJ^0:Z6[P0000080:^5[0030000002[QJ`0ZhF/00@0ZhF/0P0000070<^S/0050000003H[jl0
f:n_0=R_[`0000001P26Rm4010000000/ZS>0;:XcP0000070<^kb`800000101VYoD00`000000e[Zn
000000040>:m/P030000003X_ZT0j;jY0080j;jY00@000000>bnX`3/_Z<000000`3__Ih010000000
l;fJ0?2mVP0000030?:lUP030000003oool0000000D000001@1V^_d00`000000QlCk08O4n`0508O4
n`030000002FaOL0U/Gg0080U/Gg1`00000409W5mP030000002Oa?<0WlCc00@0WlCc00@000000:;3
l02R`o00X/?`100000020:34lP030000002R`o00X/?`00@0X/?`00<000000:C2k`2T`^l010000002
0?ooo`030000003oool0oooo00<0oooo000M0?ooo`030000003oool0oooo02/0oooo00<0000008]N
V02;GYP0102;GYP00`000000Rf2J08]PVP0308]PVP040000002;HI`0Rf6L08]QW080000000<0WXg1
0000002NRkl0102NRkl00`000000WXZn09j:_P0409j:_P030000002NRKh0WXVn00@0WXVn0`000006
0:VSd0030000002g_n00]koP0080]koP00<000000:Z6[P2ZQZh00P2ZQZh00`000000ZhF/0:^5[005
0:^5[0030000002[QJ`0ZhF/00<0ZhF/00@000000<FU^@35YKT000001@3;Xk000`000000f:n_0=R_
[`030=R_[`0300000026Rm40QX_A00<0QX_A00<000000;:XcP0000001`3;^l/00`000000e/C80000
0005000000030=Jj_P000000h[fb00<0h[fb00D000000>RnZ@3X_ZT0j;jY000000030>bnX`050000
003__Ih0kkfN0>nmWP0000000P3`_IX010000000l[bF0?:lUP0000040?ooo`80000000<007_G0000
000000000`00000206Jjo@0300000027a?/0QlCk0080QlCk1`0000040934n@030000002IaOH0VLGf
00@0VLGf00<0000009o4l`2Oa?<00P2Oa?<600000080X<Cb00D000000:34lP2Pa?80X<Cb00000004
0:;3l0D000001P3oool00`000000oooo0?ooo`030?ooo`007P3oool2000002/0oooo00<0000008]N
V02;GYP0102;GYP00`000000Rf2J08]PVP0308]PVP040000002;HI`00000000000<0WXg100<00000
09j;_`2NRkl0102NRkl00`000000WXZn09j:_P0409j:_P030000002NRKh0000000<000000P2PSl80
0`000000ZJ?@0:VSd0050:VSd0040000002g_n000000000000D0ZXJ^00<000000:^5[02[QJ`01@2[
QJ`00`000000ZhF/0:^5[0020:^5[00500000035YKT0aJFi0<FU^@0000001@3;Xk000`000000f:n_
0=R_[`030=R_[`0300000026Rm40QX_A0080QX_A0`0000070<^kb`040000003Fa<P0e/C80=K4b080
00000P0PONL2000000D0h[fb00D000000>RnZ@3X_ZT0j;jY000000030>bnX`050000003__Ih0kkfN
0>nmWP0000000P3`_IX010000000l[bF0?:lUP0000060?ooo`D0000000<0F;Ck0000000000001@00
000407o1o0030000002@a?T0T<Ci00@0T<Ci00<0000009W5mP2IaOH00P2IaOH7000000@0W<Cd00D0
00000:34lP2Pa?80X<Cb000000030:34lPD000002`3oool00`000000oooo0?ooo`030?ooo`00803o
ool00`000000oooo0?ooo`0X0?ooo`030000002;GYP0RejH00@0RejH00<0000008]PVP2;H9X00`2;
H9X2000000H0WXg100<0000009j;_`2NRkl00`2NRkl00`000000WXZn09j:_P0309j:_P<000001P2P
Sl800`000000ZJ?@0:VSd0060:VSd0030000002ZQZh0ZXJ^00D0ZXJ^00<000000:^5[02[QJ`01@2[
QJ`01@000000ZhF/0:^5[02[QJ`0000000D0aJFi00<000000<^S/03;Xk000P3;Xk000`000000f:n_
0=R_[`040=R_[`@000000`2CUM800`000000bk_;0<^kb`030<^kb`030000003Fa<P0e/C800@0e/C8
00D00000021mi`0PONL087gW000000030>:m/P030000003X_ZT0j;jY0080j;jY00@000000>bnX`3/
_Z<000000`3__Ih01@000000l;fJ0?2mVP3`_IX000000080l[bF00<000000?ooo`3oool01P3oool7
0000000305Rdn`000000000000D0Ol7l00<000000934n@2@a?T00P2@a?T7000000@0U/Cg00<00000
09c4m02La?@01@2La?@00`000000X<Cb0:34lP0400000100oooo00<000000?ooo`3oool00`3oool0
0240oooo00<000000?ooo`3oool09`3oool00`000000RejH08]NV00408]NV0040000002;H9X0Rf2J
08]PVP80000000<0Who30000002NSL401@2NSL400`000000WX^o09j;_`0409j;_`030000002NR[h0
00000080000000<0Vh:h0000002PSl801`2PSl800`000000ZJ?@0:VSd0040:VSd08000001`2ZQZh0
0`000000ZhF/0:^5[0050:^5[0050000002[QJ`0ZhF/0:^5[00000001@35YKT01@000000bj>`0<^S
/03;Xk00000000H0f:n_0P00000709>EdP030000003;^l/0bk_;0080bk_;00<000000=K4b03Fa<P0
0`3Fa<P010000000flW7000000000002021mi`040000003R_K80h[fb000000<0j;jY00D000000>bn
X`3/_Z<0k;jS000000030>nmWP050000003`_IX0l;fJ0?2mVP0000000P3b_9H00`000000oooo0?oo
o`080?ooo`0300000000JLT000000080Bjci3@00000408_3nP030000002Fa?L0U/Cg00D0U/Cg00<0
000009c4m02La?@00P2La?@500000080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`030?ooo`008P3oool00`000000oooo0?ooo`0V0?ooo`030000002;GYP0RejH00@0RejH00@00000
08]PVP0000000000102OSl<00`000000WXg109j=`@0409j=`@040000002NRkl0WX^o09j;_`@00000
1@2KP[P00`000000X8o20:2?`P050:2?`P030000002YXm00ZJ?@00<0ZJ?@00@000000:Z6[`2ZQZl0
00001P2ZQZh00`000000ZhF/0:^5[0060:^5[0030000002[QJ`0000000H0aJFi00D000000<^S/03;
Xk00bj>`000000060=R_[`030000003K];40000000H0TiGB00D000000<^kb`3;^l/0bk_;00000005
0=K4b0040000003KbLL0flW70=_9a`@000000P3R_K801@000000j;jY0>RnZ@3X_ZT0000000<0k;jS
00D000000>nmWP3__Ih0kkfN000000020?2mVP050000003b_9H0l[bF0?:lUP0000002`3oool20000
00H0Bjci00<0000007Nno@1g__d00`1g__d00`000000Rl?j08_3nP0508_3nP030000002Fa?L0U/Cg
0080U/Cg1`0000070?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool00`3oool002<0
oooo0P00000V0?ooo`030000002;GYP0RejH00<0RejH0`00000609n?``030000002NSL40WXg100<0
WXg11@00000209Qj/0030000002KP[P0Vh:h00@0Vh:h00<000000:2?`P2PSl801P2PSl800`000000
ZJ?@0:VSd002000000<0ZXJ_00<000000:Z6[P2ZQZh01@2ZQZh00`000000ZhF/0:^5[0050:^5[080
00002035YKT00`000000bj>`000000060=R_[`040000003K];40fkBa000000L0TiGB00<000000<^k
b`0000001@3Fa<P00`000000flW70=_9a`030=_9a`0300000000CLL0000000800000103X_ZT01@00
0000k;jS0>bnX`3/_Z<0000000<0kkfN00@000000?2mVP3`_IX000000`3b_9H00`000000oooo0?oo
o`0;0?ooo`@000000P1;[?T00`000000Mkkm07Nno@0407Nno@030000002;`oX0Rl?j0080Rl?j1`00
000?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool002D0oooo00<00000
0?ooo`3oool08`3oool00`000000RejH0000000300000080oooo00<0000009n?``2OSl<01@2OSl<0
0`000000WXg1000000020000000309IdZP000000V7Z`00D0V7Z`00<0000009^2^02KP[P0102KP[P0
0`000000X8o20:2?`P050:2?`P030000002YXm00000000D0ZXJ_00<000000:Z6[P2ZQZh01@2ZQZh0
0`000000ZhF/0:^5[0050:^5[00300000035YKT0aJFi00L0aJFi00<000000<^S/00000001P3H[jl0
1@000000fkBa0=^d/@3K];40000000H0TiGB0P0000050=K4b0030000003KbLL0flW700<0flW700<0
00000=g<a`0000000P00CLL01@000000j;jY0>RnZ@3X_ZT0000000<0k;jS00<000000>nmWP3__Ih0
0P3__Ih010000000l;fJ0?2mVP0000020?:lUP030000003oool0oooo0100oooo3P00000G0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool002H0oooo00<000000?ooo`3oool0
8P3oool2000000L0oooo00@0000009n?``2OSl<0Who31@00000409IdZP030000002HN[00V7Z`00@0
V7Z`00<0000009^2^02KP[P0102KP[P00`000000X8o20:2?`P060:2?`P030000002ZQZl0ZXJ_00@0
ZXJ_00<000000:Z6[P2ZQZh01@2ZQZh00`000000ZhF/0:^5[0040:^5[08000002P35YKT00`000000
f:n_0=R_[`040=R_[`030000003K];40fkBa0080fkBa00<0000009>EdP2CUM800P2CUM8200000080
ZJ;@00<000000=K4b03Fa<P00P3Fa<P00`000000flW70=_9a`030=_9a`040000003Mc<L000000000
008004g700@000000>RnZ@3X_ZT000000`3/_Z<01@000000kkfN0>nmWP3__Ih0000000<0l;fJ00@0
00000?:lUP3b_9H00000>03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo
000W0?ooo`030000003oool0oooo02X0oooo1000000309A`YP030000002FM:X0UWBZ00@0UWBZ00<0
000009Qj/02HN[000`2HN[000`000000Vh:h09^2^00509^2^0030000002PSl80X8o200<0X8o20`00
00070:Z6[`030000002ZQZh0ZXJ^00@0ZXJ^00<000000:^5[02[QJ`00`2[QJ`010000000_jW40;nY
a00000090<FU^@030000003H[jl0f:n_00@0f:n_00<000000=^d/@3K];400`3K];4010000000TiGB
0000000000040:VRd0050000003Fa<P0e/C80=K4b00000001@3KbLL010000000gLc70=g<a`3Mc<L4
00000080j;jY00D000000>bnX`3/_Z<0k;jS000000030>nmWP050000003`_IX0l;fJ0?2mVP000000
0P3b_9H00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
0P3oool002P0oooo0P00000Z0?ooo`030000002DL:H0U72V00@0U72V00<0000009IdZP2FM:X0102F
M:X00`000000V7Z`09Qj/00409Qj/0030000002KP[P0Vh:h00@0Vh:h00@000000:2?`P2PSl80X8o2
0P0000020:V7/@030000002ZQZl0ZXJ_00D0ZXJ_00<000000:Z6[P2ZQZh0102ZQZh010000000ZhF/
0:^5[02[QJ`2000000<0_jW400<000000<FU^@35YKT01P35YKT2000000D0f:n_00<000000=^d/@3K
];40103K];42000000L0ZJ;@00<000000=K4b00000001@3KbLL00`000000gLc70=g<a`030=g<a`06
000000008J8000000000003X_ZT000000`3/_Z<01@000000kkfN0>nmWP3__Ih0000000<0l;fJ00@0
00000?:lUP3b_9H00000>@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0080oooo
000Z0?ooo`030000003oool0oooo02L0oooo00<0000009A`YP2DL:H01@2DL:H00`000000UWBZ09Id
ZP0309IdZP030000002HN[00V7Z`00@0V7Z`00<0000009^2^02KP[P01@2KP[P3000000D0ZHNa00<0
00000:Z6[`2ZQZl0102ZQZl00`000000ZXJ^0:Z6[P050:Z6[P030000002[QJ`0000000H0_jW400<0
00000<FU^@35YKT01035YKT010000000ak;50<Nba@0000040=R_[`030000003K];40fkBa00@0fkBa
0P0000080:VRd0030000003KbLL0flW700@0flW700<000000=g<a`3Mc<L00P3Mc<L010000000g/k9
000000008J82000000<0k;jS00<000000>nmWP3__Ih00P3__Ih010000000l;fJ0?2mVP0000030?:l
UP030000003oool0oooo03P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`020?oo
o`00:`3oool00`000000oooo0?ooo`0V0?ooo`030000002DL:H0U72V00D0U72V00<0000009IdZP2F
M:X00`2FM:X00`000000V7Z`09Qj/00409Qj/0030000002KP[P0Vh:h00D0Vh:h00<000000:V7/@2Y
Qk401@2YQk400`000000ZXJ_0:Z6[`040:Z6[`030000002ZQZh0ZXJ^00D0ZXJ^0P0000070;nYa003
00000035YKT0aJFi00<0aJFi00D000000<Nba@37//D0ak;5000000030=R_[`030000003K];40fkBa
00@0fkBa00<000000=bg/`0000001`2YX]000`000000_Jc9000000040=_9a`030000003Mc<L0gLc7
0080gLc700L000000=k>b@3Nc/T0g/k9000000008J80000000<0k;jS00<000000>nmWP3__Ih00P3_
_Ih010000000l;fJ0?2mVP0000030?:lUP030000003oool0oooo03T0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`020?ooo`00;03oool00`000000oooo0?ooo`0V0?ooo`030000002D
L:H0U72V00@0U72V00<0000009IdZP2FM:X00`2FM:X00`000000V7Z`09Qj/00509Qj/0030000002K
P[P0Vh:h00<0Vh:h0P0000070:V7/@030000002ZQZl0ZXJ_00D0ZXJ_00<000000:Z6[P2ZQZh0102Z
QZh00`000000_jW40;nYa0070;nYa00500000035YKT0aJFi0<FU^@0000001@37//D010000000f:n_
0=R_[`0000060=^d/@040000003L]k<0g;Nc000000D0ZJ;@00D000000;f/b@2m[<T0_Jc900000002
0=_9a`030000003Mc<L0gLc700<0gLc700<000000=k>b@3Nc/T00P3Nc/T00`000000026R00000002
0>bnX`050000003__Ih0kkfN0>nmWP0000000`3`_IX01@000000l[bF0?:lUP3b_9H0000003/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`010?ooo`00;@3oool00`000000oooo0?oo
o`0U0?ooo`030000002DL:H0U72V00@0U72V00<0000009IdZP2FM:X0102FM:X00`000000V7Z`09Qj
/00409Qj/0030000002KP[P0Vh:h0080Vh:h00@000000:V8/P2YR;8000001P2YQk400`000000ZXJ_
0:Z6[`050:Z6[`030000002ZQZh0ZXJ^00<0ZXJ^00<000000;f`c@000000202oZL@010000000aJFi
0<FU^@0000060<Nba@030000003H[jl0000000H0fkBa00<000000=bg/`3L]k<00P3L]k<00`000000
ZJ;@0:VRd002000000D0_Jc900<000000=_9a`000000103Mc<L00`000000g/k90=k>b@030=k>b@<0
00000P3/_Z<01@000000kkfN0>nmWP3__Ih0000000<0l;fJ00@000000?:lUP3b_9H00000?@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0040oooo000^0?ooo`8000009@3oool00`00
0000U72V09A`YP0409A`YP030000002FM:X0UWBZ00@0UWBZ00<0000009Qj/02HN[00102HN[000`00
0000Vh:h09^2^002000000<0ZHRb00<000000:V7/@2YQk40102YQk400`000000ZXJ_0:Z6[`050:Z6
[`030000002ZQZh0ZXJ^0080ZXJ^00@000000;f`c@2m/<d000002@2oZL@2000000P0ak;50P000006
0=^d/@030000003L]k<0g;Nc0080g;Nc00<000000:VRd0000000202m[<T00`000000gLc70=g<a`02
0=g<a`030000003Nc/T0g/k900<0g/k900<000000=g?b`3Mcl/00`0000040>nmWP050000003`_IX0
l;fJ0?2mVP0000000P3b_9H00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool00@3oool00300oooo00<000000?ooo`3oool08P3oool00`000000U72V09A`YP04
09A`YP030000002FM:X0UWBZ00@0UWBZ00<0000009Qj/02HN[001@2HN[02000000D0ZHRb00<00000
0:V7/@2YQk401@2YQk400`000000ZXJ_0:Z6[`040:Z6[`030000002ZQZh0ZXJ^00800000102m/<d0
0`000000_jW40;nYa0060;nYa00300000037//D0ak;500L0ak;500<000000=^d/@3K];40103K];40
0`000000g;Nc0=bg/`040=bg/`030000002m[<T0_Jc900H0_Jc900<000000<^b`@0000000P3Mc<L0
0`000000g/k90=k>b@030=k>b@030000003Mcl/0gLo;0080gLo;0P0000040>nmWP050000003`_IX0
l;fJ0?2mVP0000000P3b_9H00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool00@3oool00340oooo00<000000?ooo`3oool08@3oool00`000000U72V09A`YP05
09A`YP030000002FM:X0UWBZ00<0UWBZ00<0000009Qj/02HN[001@2HN[000`000000ZHRb0:V8/P04
0:V8/P030000002YQk40ZHNa00D0ZHNa00<000000:Z6[`2ZQZl01@2ZQZl2000000H0_K3=00<00000
0;nYa02oZL@0102oZL@2000000030;jgd`000000ak;500H0ak;500<000000<>fcP0000001@3K];40
0`000000g;Nc0=bg/`030=bg/`8000001`2m[<T01`000000bk;10<^b`@3;//4000000=g<a`000000
103Nc/T00`000000gLo;0=g?b`030=g?b`800000103__Ih010000000l;fJ0?2mVP0000030?:lUP03
0000003oool0oooo03d0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`010?ooo`00
<P3oool00`000000oooo0?ooo`0P0?ooo`030000002DL:H0U72V00D0U72V00<0000009IdZP2FM:X0
0`2FM:X00`000000V7Z`09Qj/00309Qj/0<000001`2YR;800`000000ZHNa0:V7/@040:V7/@030000
002ZQZl0ZXJ_00D0ZXJ_00<000000;f`c@2m/<d01P2m/<d010000000_jW40;nYa02oZL@2000000<0
_[OC00<000000<Nba@37//D01037//D010000000`kK>0<>fcP0000040=^d/@030000003L]k<0g;Nc
00@0g;Nc00<000000=bh]00000001@2m[<T00`000000bk;10<^b`@030<^b`@030000003Nc/T0g/k9
00<0g/k900<000000=g?b`3Mcl/00P3Mcl/010000000g=3=0=c@c@0000030>nmWP040000003`_IX0
l;fJ000000<0l[bF00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo0040oooo000c0?ooo`800000803oool00`000000U72V09A`YP0509A`YP030000002FM:X0
UWBZ00@0UWBZ00<0000009Qj/02HN[000P0000020:Z:/`030000002YR;80ZHRb00D0ZHRb00<00000
0:V7/@2YQk40102YQk400`000000ZXJ_0:Z6[`030:Z6[`80000000<0_KSD0000002m/<d01P2m/<d0
10000000_jW40000000000060;jgd`0300000037//D0ak;50080ak;500<000000<>fcP33]/h00P33
]/h01@000000fkBa0=^d/@3K];40000000D0g;Nc00@000000=bh]03L^;@00000102m[<T00`000000
bk;10<^b`@030<^b`@030000003E][X0000000<0g/k900<000000=g?b`3Mcl/00P3Mcl/00`000000
g=3=0=c@c@020=c@c@030000003__Ih0000000<0l;fJ00D000000?:lUP3b_9H0l[bF000000110?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool00@3oool003D0oooo00<000000?ooo`3o
ool07P3oool00`000000U72V09A`YP0409A`YP030000002FM:X0UWBZ00@0UWBZ0`0000050:Z:/`03
0000002YR;80ZHRb00@0ZHRb00<000000:V7/@2YQk401@2YQk400`000000ZXJ_0:Z6[`02000000<0
_KSD00<000000;f`c@2m/<d01P2m/<d00`000000_[OC0;jgd`070;jgd`0400000037//D0ak;50000
00D0`kK>00@000000=^d/@3K];4000001P3L]k<01@000000g;Rd0=bh]03L^;@000000080_Jc900<0
00000<^b`@3;//40103;//401P000000eKJj0=Ff^P000000g/k9000000@0gLo;00<000000=c@c@3L
d<d0103Ld<d2000000<0l;fJ00D000000?:lUP3b_9H0l[bF000000110?ooo`030000003oool0oooo
00L0oooo0@0000010?ooo`40oooo000f0?ooo`030000003oool0oooo01d0oooo00<0000009A`YP2D
L:H0102DL:H00`000000UWBZ09IdZP0409IdZP030000002ZR[<0ZXZc00D0ZXZc00<000000:V8/P2Y
R;801@2YR;800`000000ZHNa0:V7/@040:V7/@<000001P2m^=@00`000000_K3=0;f`c@030;f`c@80
000000<0^[oM0000002n]m<01`2n]m<00`000000ak;5000000070<>fcP030000003K];40000000D0
g;Nc00<000000=bh]03L^;@00P3L^;@00`000000_Jc9000000060<^b`@030000003E][X0eKJj0080
eKJj00<000000=g?b`3Mcl/00`3Mcl/00`000000g=3=0=c@c@030=c@c@<000000`3`_IX010000000
l[bF0?:lUP0000130?ooo`030000003oool0oooo00H0oooo0@0000010?ooo`40oooo000g0?ooo`03
0000003oool0oooo01`0oooo00<0000009A`YP2DL:H0102DL:H00`000000UWBZ09IdZP0209IdZP<0
00001`2ZR[<00`000000ZHRb0:V8/P050:V8/P030000002YQk40ZHNa00@0ZHNa00<000000;fhe02m
^=@01`2m^=@01@000000_K3=0;f`c@2m/<d0000000@0^[oM00<000000;jgd`2n]m<01@2n]m<20000
00P0`kK>0P0000060=bg/`030000003L^;@0g;Rd00<0g;Rd00<000000<^b`@3;//401@3;//400`00
0000eKJj0=Ff^P020=Ff^P8000000`3Mcl/00`000000g=3=0=c@c@030=c@c@030000003oool0oooo
008000000P3`_IX010000000l[bF0?:lUP0000140?ooo`030000003oool0oooo00D0oooo0@000001
0?ooo`40oooo000h0?ooo`800000703oool00`000000U72V09A`YP0509A`YP040000002FM:X0UWBZ
000000<0ZX^e00<000000:Z:/`2ZR[<0102ZR[<00`000000ZHRb0:V8/P050:V8/P030000002YQk40
ZHNa0080ZHNa0P0000000`2n`=/000000;fhe0070;fhe0040000002m/<d00000000000D0^[oM00<0
00000;jgd`2n]m<00`2n]m<200000080]k[L00<000000<>fcP33]/h01P33]/h00`000000g;Nc0=bg
/`030=bg/`030000003L^;@0g;Rd00<0g;Rd00<000000=^i]P0000001@3;//400`000000eKJj0=Ff
^P020=Ff^P060000003L]k<0g;Nc0000003Mcl/000001@3Ld<d00`000000oooo0?ooo`020?ooo`03
0000003`_IX0000000<0l[bF00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`040?ooo`40
00000@3oool10?ooo`00>P3oool00`000000oooo0?ooo`0I0?ooo`030000002DL:H0U72V00D0U72V
0`0000040:Z;]@030000002ZR[<0ZXZc00D0ZXZc00<000000:V8/P2YR;80102YR;801@000000ZHNa
0:V7/@2YQk40000000@0_/3K00<000000;fhe02m^=@01@2m^=@2000000P0^[oM00<000000;jgd`2n
]m<00P0000040;Njg00300000033]/h0`kK>00@0`kK>0`0000050=bg/`030000003L^;@0g;Rd00<0
g;Rd00<000000=^i]P000000103;//400`000000eKJj0=Ff^P030=Ff^P050000003L]k<0g;Nc0=bg
/`0000001P3Ld<d00`000000oooo0?ooo`030?ooo`8000000`3b_9H00`000000oooo0?ooo`130?oo
o`030000003oool0oooo00@0oooo0@0000010?ooo`40oooo000k0?ooo`030000003oool0oooo01P0
oooo00<0000009A`YP2DL:H01@2DL:H00`000000ZX^e0:Z;]@040:Z;]@030000002ZR[<0ZXZc00D0
ZXZc00<000000:V8/P2YR;801@2YR;83000000D0_/3K00<000000;fhe02m^=@00`2m^=@200000080
^LKT00<000000;Zog@2j_md01@2j_md3000000L0]k[L00@000000<>fcP33]/h0`kK>0P0000030;bg
e0050000003L]k<0g;Nc0=bg/`0000001@3L^;@01@000000fkVf0=^i]P3K^KH0000000<0bk;100<0
00000=Ff^P3E][X00P3E][X00`000000g;Nc0=bg/`020=bg/`800000103Ld<d00`000000oooo0?oo
o`040?ooo`8000000`3b_9H00`000000oooo0?ooo`140?ooo`030000003oool0oooo00<0oooo0@00
00010?ooo`40oooo000l0?ooo`030000003oool0oooo01P0oooo00<0000009A`YP2DL:H00P2DL:H3
000000L0ZX^e00<000000:Z:/`2ZR[<0102ZR[<00`000000ZHRb0:V8/P050:V8/P030000002n`=/0
_/3K00H0_/3K00<000000;fhe02m^=@00P0000040;W6i0030000002j_md0^[oM00<0^[oM0P000002
0;;0i0030000002g^]`0]k[L00D0]k[L00@000000<>fcP00000000001@2l]m@01@000000g;Nc0=bg
/`3L]k<0000000D0g;Rd00<000000=^i]P3K^KH00P3K^KH00`000000bk;1000000050=Ff^P050000
003L]k<0g;Nc0=bg/`0000000P3Q^:d2000000030=c@c@000000oooo00L0oooo00D000000?:lUP3b
_9H0l[bF000000170?ooo`030000003oool0oooo0080oooo0@0000010?ooo`40oooo000m0?ooo`80
0000603oool00`000000U72V09A`YP0200000080ZXbf00<000000:Z;]@2ZRkD01@2ZRkD00`000000
ZXZc0:Z:/`040:Z:/`030000002YR;80ZHRb00<0ZHRb0P0000000`2obN8000000;k0f`070;k0f`80
00001`2ia^@00`000000^[oM0;Zog@02000000D0//3T00<000000;Njg02g^]`0102g^]`2000000P0
_;OD00<000000=bg/`0000001@3L^;@00`000000fkVf0=^i]P030=^i]P030000003;//40000000@0
eKJj00<000000=bg/`3L]k<00P3L]k<00`000000hKR]0>6h[@020>6h[@030000003oool0oooo00P0
oooo00<000000?:lUP000000B03oool00`000000oooo0?ooo`030?ooo`4000000@3oool003l0oooo
00<000000?ooo`3oool05@3oool3000000D0ZXbf00<000000:Z;]@2ZRkD0102ZRkD00`000000ZXZc
0:Z:/`050:Z:/`030000002YR;80ZHRb00800000102obN800`000000_/3K0;k0f`030;k0f`800000
00<0^LkZ0000002ia^@01P2ia^@3000000P0//3T00<000000;Njg02g^]`00`0000020:jjhP030000
002l]m@0_;OD00D0_;OD00<000000=bg/`0000001@3L^;@00`000000fkVf0=^i]P040=^i]P030000
003E][X0eKJj00<0eKJj00D000000=bg/`3L]k<0g;Nc000000050>6h[@030000003oool0oooo00P0
oooo00<000000?:lUP000000B@3oool00`000000oooo0?ooo`020?ooo`4000000@3oool00400oooo
00<000000?ooo`3oool0503oool00`000000ZXbf0:Z<]P050:Z<]P030000002ZRkD0ZX^e00@0ZX^e
00<000000:Z:/`2ZR[<01@2ZR[<3000000L0_lWR00<000000;k0f`2n`=/00P0000040;W>jP800000
0P2ia^@300000080/LKY00<000000;;0i02b`>@01P2b`>@3000000H0[[[R00<000000;bge02l]m@0
1@2l]m@00`000000g;Rd0=bh]0030=bh]0030000003K^KH0fkVf00@0fkVf0P0000040=Ff^P030000
003L]k<0g;Nc0080g;Nc00<000000>6h[@3Q^:d00P3Q^:d00`000000oooo0?ooo`0:0?ooo`800000
BP3oool01@000000oooo0?ooo`3oool000000040oooo00110?ooo`030000003oool0oooo01<0oooo
00<000000:Z<]P2ZS;H01@2ZS;H00`000000ZX^e0:Z;]@050:Z;]@030000002ZR[<0ZXZc00@0ZXZc
00<000000;o9hP2obN801`2obN83000000L0^LkZ0`0000060;76j@030000002b`>@0//3T00<0//3T
0P0000020:^nj0030000002^^^80[[[R00@0[[[R00<000000;bge02l]m@00`2l]m@2000000030;Ff
fP000000g;Rd00<0g;Rd00<000000=^i]P3K^KH0103K^KH00`000000f[Vh000000030=Ff^P030000
003L]k<0g;Nc0080g;Nc00<000000>6h[@3Q^:d00P3Q^:d00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo04T0oooo00@000000?ooo`3oool000000@3oool00480oooo0P00000D0?ooo`030000
002ZS;H0ZXbf00@0ZXbf00<000000:Z;]@2ZRkD01@2ZRkD00`000000ZXZc0:Z:/`020:Z:/`800000
00<0`=7W0000002obN801@2obN8200000080^=C^00<000000;W>jP2ic^X00`2ic^X200000080/Lc]
00<000000;76j@2aa^T01@2aa^T00`000000//3T0;;0i002000000@0ZkkX00<000000:jjhP2^^^80
1@2^^^800`000000_;OD0;bge002000000@0]KKJ00@000000=bh]03L^;@000001P3K^KH010000000
f[Vh0=Zi^00000020=Ff^P030000003L]k<0g;Nc0080g;Nc00<000000>6h[@3Q^:d00`3Q^:d00`00
0000oooo0?ooo`1G0?ooo`040000003oool0oooo00000040oooo00140?ooo`030000003oool0oooo
0140oooo00<000000:Z<]P2ZS;H01@2ZS;H00`000000ZX^e0:Z;]@040:Z;]@050000002ZR[<0ZXZc
0:Z:/`0000001030dNL200000080_lWR0P0000050;SDkP030000002ic^X0^LkZ008000001@2ac>d0
0`000000/LKY0;76j@040;76j@<000001`2[_^P00`000000[[[R0:jjhP040:jjhP<000001P2e]]X0
10000000g;Rd0=bh]00000050=^i]P030000003J^KP0f[Vh0080f[Vh00<000000=Ff^P000000103L
]k<00`000000hKR]0>6h[@020>6h[@030000003oool0oooo05T0oooo00<000000?ooo`0000000@3o
ool004D0oooo00<000000?ooo`3oool0403oool00`000000ZXbf0:Z<]P050:Z<]P030000002ZRkD0
ZX^e00D0ZX^e0`0000070<3Ai`800000202he>h2000000P0/Lc]00<000000;76j@2aa^T00`000002
0:_3k0030000002[_^P0ZkkX00D0ZkkX00<000000:jjhP2^^^80100000020:Jgi@030000002e]]X0
]KKJ00D0]KKJ0P0000060=^i]P030000003J^KP0f[Vh0080f[Vh0P0000040=bg/`030000003Q^:d0
hKR]00<0hKR]00<000000?ooo`3oool0FP3oool100000040oooo0@00000004H0oooo00<000000?oo
o`3oool0403oool00`000000ZXbf0:Z<]P040:Z<]P030000002ZRkD0ZX^e00@0ZX^e0P0000070<3A
i`80000000<0]m_b0000002he>h01@2he>h2000000030;7Al0000000/Lc]00L0/Lc]0`0000060:_3
k0800000102[_^P4000000H0Y[OU00<000000;FffP2e]]X01@2e]]X2000000D0fkVf00<000000=Zi
^03J^KP0103J^KP00`000000g;Nc0=bg/`020=bg/`030000003Q^:d0hKR]00<0hKR]00<000000?oo
o`3oool0F`3oool200000000A`3oool200000100oooo00<000000:Z<]P2ZS;H0102ZS;H00`000000
ZX^e0:Z;]@020:Z;]@8000000P30f^d2000000<0`=7W0P0000040;OKlP8000000P2he>h2000000@0
/M7`0P0000020;7<k@@000000P2/b>h00`000000Zl?/0:_3k0050:_3k0D000000`2T_>X00`000000
Y[OU0:Jgi@050:Jgi@030000002e]]X0]KKJ00@000000P2]]=h00`000000fkVf0=^i]P020=^i]P03
0000003J^KP0f[Vh00<0f[Vh00<000000=Vj^@0000000`3L]k<00`000000hKR]0>6h[@020>6h[@03
0000003oool0oooo05`0oooo0P00000004T0oooo00<000000?ooo`3oool03@3oool00`000000ZXbf
0:Z<]P050:Z<]P040000002ZRkD00000000000H0`=[]0`0000070;OKlP<000001`2adO03000000L0
[<S^00<000000:_3k02[`n`0100000020:G0k@030000002T_>X0Y;cZ00@0Y;cZ00<000000:Jgi@2V
]nD0102V]nD3000000H0[KCN00D000000=^i]P3K^KH0fkVf000000060=Zi^0030000003I^[T00000
0080g;Nc00<000000>6h[@3Q^:d00`3Q^:d00`000000oooo0?ooo`1L0?ooo`800000001:0?ooo`03
0000003oool0oooo00d0oooo00<000000:Z<]P2ZS;H0102ZS;H2000000H0`=[]0P0000020;KQm@80
00000`2gfo8300000080/MKc0P0000030;7Al0<000000P2/c?000`000000[<S^0:c8kP050:c8kP<0
00001P2U`>d00`000000Y;cZ0:BljP050:BljP030000002V]nD0Y[OU00<000000P2N]>P00`000000
[KCN0:fdgP050:fdgP030000003K^KH0000000H0f[Vh00L000000=Vj^@3I^[T0fKZi0000003L]k<0
000000D0hKR]00<000000?ooo`3oool0F03oool400000080oooo001;0?ooo`030000003oool0oooo
00`0oooo00<000000:Z<]P2ZS;H00P2ZS;H2000000030;oSl@000000000000<0`=[]0P0000060;KQ
m@<000001`2ae_<3000000H0[<c`0P0000020:c8kP<000000P2Wa>h00`000000YL3]0:G0k@050:G0
k@030000002T_>X0Y;cZ0080Y;cZ1@00000609jdj0030000002]]=h0[KCN00@0[KCN00<000000=^i
]P0000001P3J^KP010000000fKZi0=Vj^@3I^[T2000000D0hKR]00<000000?ooo`3oool0E@3oool4
000000H0oooo001<0?ooo`800000303oool01@000000ZXbf0:Z<]P2ZS;H0000000D0_n?a0`000006
0;KQm@8000000P2`f_H2000000<0/MKc0`0000020:c@lP030000002/c?00[<c`00D0[<c`0`000006
0:O4kP800000102U`>d6000000@0W[W[00<0000009jdj02N]>P0102N]>P00`000000[KCN0:fdgP04
0:fdgP8000001P3J^KP00`000000fKZi0=Vj^@030=Vj^@030000003Q^:d0hKR]00<0hKR]00<00000
0?ooo`3oool0D@3oool4000000X0oooo001>0?ooo`030000003oool0oooo00X0oooo0`0000050;oS
l@80000000<0]>Og0000000000000`2fhOD2000000H0/=[f0`0000060:c@lP8000000P2/c?030000
0080Z<S`00<000000:O4kP2Wa>h01@2Wa>h5000000<0XKg]00<0000009jij`2N^N/0102N^N/00`00
0000W[CX09jdj00509jdj0030000002]]=h0[KCN00<000000P2T/N400`000000f[Vh0=Zi^0020=Zi
^0030000003I^[T0fKZi00<0fKZi00<000000=Rj^`000000103Q^:d00`000000oooo0?ooo`1=0?oo
o`@000003P3oool004l0oooo00<000000?ooo`3oool02@3oool2000000@0_n?a0P0000050;CWm`<0
00001P2`f_H200000080[M?d00<000000:c@lP2/d?801@2/d?83000000H0Z<S`0P0000020:O4kP<0
00000P2S`Nl00`000000XKg]0:6mk@040:6mk@030000002N^N/0W[W[00@0W[W[00<0000009jdj02N
]>P00P2N]>P5000000H0Y;7Q00D000000=Zi^03J^KP0f[Vh000000050=Vj^@030000003H^[/00000
00<0hKR]00<000000?ooo`3oool0BP3oool400000180oooo001@0?ooo`030000003oool0oooo00X0
oooo100000040;CWm`<000000P2_g_L2000000<0/=[f0P0000050:gCm0030000002/d?80[=3b00@0
00000P2Ybo800`000000Z<S`0:S8l0050:S8l0<000001P2S`Nl00`000000XKg]0:6mk@040:6mk@03
0000002N^N/0W[W[0080W[W[1P00000409JajP030000002T/N40Y;7Q00@0Y;7Q00@000000=Zi^03J
^KP000001@3I^[T01@000000f;Zk0=Rj^`3H^[/000000080hKR]00<000000?ooo`3oool0AP3oool4
000001H0oooo001A0?ooo`8000003P3oool4000000L0[mkg0`0000070:gCm0<000001`2Ybo800`00
0000Z<S`0:S8l00400000080YLC`00<000000:?1k`2S`Nl01@2S`Nl00`000000XKg]0:6mk@020:6m
k@H000000`2H]^`00`000000U[7Z09JajP0409JajP030000002T/N40Y;7Q00D0Y;7Q00<000000=Zi
^00000001@3I^[T00`000000f;Zk0=Rj^`020=Rj^`030000003Q^:d0000004D0oooo0`00000J0?oo
o`00D`3oool00`000000oooo0?ooo`0>0?ooo`8000000`2_g_L300000080[=Kf0P0000030:gCm0<0
00000P2Yc_<00`000000ZL_b0:W;lP050:W;lP<000001`2Ua?000`000000Xl7_0:?1k`020:?1k`L0
00000`2L^nh00`000000V;K/09Rfk00409Rfk0030000002F/NX0U[7Z00@0U[7Z00<000000:Bah@2T
/N400P2T/N44000000D0fKZi00<000000=Rj^`3H^[/00`3H^[/200000480oooo1000000M0?ooo`00
E03oool00`000000oooo0?ooo`0?0?ooo`<000001`2/e_H3000000H0ZLkc0P0000020:W;lP<00000
0P2Vao400`000000YLC`0:G4l0050:G4l0D00000102O_^l00`000000W;_^09bkkP0409bkkP030000
002H]^`0V;K/00@0V;K/00<0000009JajP2F/NX00P2F/NX6000000@0VjkT00D000000=Vj^@3I^[T0
fKZi000000070=Rj^`030000003oool0oooo03`0oooo1000000Q0?ooo`00E@3oool00`000000oooo
0?ooo`0@0?ooo`8000000`2/e_H300000080Z]3d0P0000050:W>l`@000001P2Vao4200000080YLC`
0`0000020:;2l0030000002O_^l0Wkk_00D0Wkk_00<0000009bkkP2L^nh00P2L^nh=000000<0SZk[
00<0000009^^i02K[^@0102K[^@01@000000fKZi0=Vj^@3I^[T0000000H0f;Zk00<000000?ooo`3o
ool0>@3oool4000002D0oooo001F0?ooo`8000004P3oool3000000L0Z]3d1@0000030:O:lP800000
1@2Vao44000000H0X/;`00<0000009nnk`2O_^l0102O_^l5000000<0V;S^00<0000009>ck@2C/nd0
102C/nd00`000000SZk[08j^j`0408j^j`030000002K[^@0VjkT00@0VjkT00<000000=Vj^@000000
1P3H^[/00`000000oooo0?ooo`0f0?ooo`@00000:@3oool005P0oooo00<000000?ooo`3oool04@3o
ool2000000<0Z]3d0`0000020:S<l`030000002Wb_80Yl[b00D0Yl[b1@0000030:?4l0030000002R
`_00X/;`00D0X/;`00<0000009nnk`2O_^l00`00000209blk`030000002H^>h0V;S^00@0V;S^00<0
000009>ck@2C/nd00`2C/nd00`000000SZk[08j^j`0408j^j`030000002K[^@0VjkT00@0VjkT00<0
00000=Vj^@0000001P3H^[/00`000000oooo0?ooo`0b0?ooo`@00000;@3oool005T0oooo00<00000
0?ooo`3oool04P3oool3000000H0Z<cc0P0000020:O:lP<000000P2Uao400`000000XlC`0:?4l004
0:?4l0800000102R`_04000000H0W;c_00<0000009RhkP2H^>h0102H^>h00`000000Tk?]09>ck@03
09>ck@030000002>[^/0SZk[00@0SZk[00<0000009^^i02K[^@00P2K[^@3000000H0f;Zk00<00000
0?ooo`3oool0;`3oool400000340oooo001J0?ooo`030000003oool0oooo01<0oooo00<000000:S<
l`2Xc?<01@2Xc?<3000000H0YLOa0P0000040:?4l0H000000`2O_o000`000000W;c_09blk`0509bl
k`030000002H^>h0V;S^0080V;S^4`000003096ZiP030000003H^[/0f;Zk0080f;Zk00<000000?oo
o`3oool0;@3oool3000003D0oooo001K0?ooo`800000503oool200000080Z<cc0`0000020:K9lP03
0000002Uao40YLOa00D0YLOa1@0000030:72l0030000002O_o00Wko`00@0Wko`00<0000009blk`2L
_>l00P2L_>l7000000<0U;K_00<0000008fakP2=/Nh00`2=/Nh00`000000QZ[/08JZk00408JZk003
0000002AZ^H0TJ[V00<0TJ[V00D000000=Rj^`3H^[/0f;Zk0000000/0?ooo`@00000>03oool005d0
oooo00<000000?ooo`3oool04`3oool2000000H0Y/Wb00<000000:G7l@2Uao40100000020:?4l@03
0000002Q`_00XL;`00@0XL;`00<0000009nol02O_o000P2O_o06000000@0VK[_00<0000009Bfk`2D
]^l00`2D]^l00`000000SK7^08fakP0408fakP0300000026Z^`0QZ[/00<0QZ[/00<00000096ZiP2A
Z^H0102AZ^H010000000f;Zk0=Rj^`00000X0?ooo`@00000?03oool005h0oooo00<000000?ooo`3o
ool04`3oool2000000@0Y/Wb100000070:?4l@030000002Q`_00XL;`0080XL;`1P00000309bnl003
0000002I^^l0VK[_00D0VK[_00<0000009Bfk`2D]^l00`2D]^l00`000000SK7^08fakP0408fakP03
00000026Z^`0QZ[/00<0QZ[/00<00000096ZiP2AZ^H00`2AZ^H00`000000f;Zk0000000U0?ooo`@0
0000@03oool005l0oooo00<000000?ooo`3oool0503oool4000000<0Y<Ka00<000000:?4l@2Sa?40
1@2Sa?45000000<0Wl3`00<0000009bnl02L__00102L__02000000@0VK[_7000000R0?ooo`@00000
A03oool00600oooo0P00000E0?ooo`030000002Ta_40Y<Ka00@0Y<Ka0P0000020:?4l@<000000P2Q
`o000`000000Wl3`09o0l00409o0l0800000102L__06000003X0oooo100000180?ooo`00HP3oool0
0`000000oooo0?ooo`0C0?ooo`800000102Ta_44000000H0XL?`0P00000409o0l0H00000?03oool4
000004`0oooo001S0?ooo`030000003oool0oooo01@0oooo100000030:;4l@030000002Q`o00XL?`
00D0XL?`1@00000o0?ooo`<00000D03oool006@0oooo00<000000?ooo`3oool0503oool00`000000
X/Ca0:;4l@040:;4l@8000000P2Q`o0300000400oooo1000001C0?ooo`00I@3oool00`000000oooo
0?ooo`0D0?ooo`800000102Ra?44000003l0oooo1000001G0?ooo`00IP3oool2000001H0oooo1000
000o0?ooo`@00000F`3oool006P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0l
0?ooo`@00000G`3oool006T0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0h0?oo
o`@00000H`3oool006X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0d0?ooo`@0
0000I`3oool006/0oooo0P00000@0?ooo`030000003oool0oooo0380oooo0`00001[0?ooo`00K@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02h0oooo1000001^0?ooo`00KP3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02X0oooo1000001b0?ooo`00K`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo02H0oooo1000001f0?ooo`00L03oool2000000/0
oooo00<000000?ooo`3oool08P3oool4000007X0oooo001b0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool07P3oool4000007h0oooo001c0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool06P3oool400000880oooo001d0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool05`3oool3000008H0oooo001e0?ooo`8000001P3oool00`000000oooo0?ooo`0C0?oo
o`@00000R@3oool007L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`@0
0000S@3oool007P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`@00000
T@3oool007T0oooo00D000000?ooo`3oool0oooo000000090?ooo`@00000U@3oool007X0oooo0P00
00000`3oool000000?ooo`040?ooo`@00000V@3oool007`0oooo0P0000000`3oool0000000000002
000009d0oooo001m0?ooo`800000X@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{81, 368}, {520.75, 288.188}} -> {-0.354648, 1.05418, \
0.00355229, 0.00355229}},
  CellTags->"b:0.0"]
}, Open  ]],

Cell[TextData[{
  StyleBox["DSolve", "MR"],
  " can also solve differential-algebraic equations. The syntax is the same \
as for a system of ordinary differential equations."
}], "Text",
  CellTags->"b:0.0"],

Cell["This solves a DAE.", "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[{
    StyleBox[\(\(eqns\  = \ {\(f''\)[x]\  == \ g[x], \ 
          f[x]\  + \ g[x]\  == \ 3\ Sin[x], \ 
          f[Pi]\  == \ 1, \ \(f'\)[Pi]\  == \ 0}; \)\(\ \)\),
      FormatType->StandardForm], "\n", \(sol\  = \ 
      DSolve[eqns, \ {f, \ g}, \ x]\)}], "Input",
  CellLabel->"In[16]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \({{f \[Rule] 
          Function[{x}, 
            1\/2\ \((\(-2\)\ Cos[x] + 3\ \[Pi]\ Cos[x] - 3\ x\ Cos[x] + 
                  3\ Sin[x])\)], 
        g \[Rule] 
          Function[{x}, 
            1\/2\ \((2\ Cos[x] - 3\ \[Pi]\ Cos[x] + 3\ x\ Cos[x] + 
                  3\ Sin[x])\)]}}\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell["This verifies the solutions.", "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell["Simplify[eqns /. sol]", "Input",
  CellLabel->"In[18]:=",
  CellTags->"b:0.0"],

Cell[BoxData[
    \({{True, True, True, True}}\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"b:0.0"]
}, Open  ]],

Cell[TextData[{
  "A plot of the solutions shows that their sum satisfies the algebraic \
relation ",
  Cell[BoxData[
      \(f[x] + g[x] \[Equal] 3\ Sin[x]\)]],
  StyleBox[".", "InlineFormula"]
}], "MathCaption",
  CellTags->"b:0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{f[x] /. sol, \ g[x] /. sol, \ f[x] + g[x] /. sol}, \ {x, \(-5\), 
        5}, \ PlotStyle\  \[Rule] {{Red}, \ {Blue}, {Green}}]; \)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"b:0.0"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 0.300539 0.0339266 [
[.11905 .28804 -6 -9 ]
[.11905 .28804 6 0 ]
[.30952 .28804 -6 -9 ]
[.30952 .28804 6 0 ]
[.69048 .28804 -3 -9 ]
[.69048 .28804 3 0 ]
[.88095 .28804 -3 -9 ]
[.88095 .28804 3 0 ]
[.4875 .04609 -24 -4.5 ]
[.4875 .04609 0 4.5 ]
[.4875 .13091 -12 -4.5 ]
[.4875 .13091 0 4.5 ]
[.4875 .21572 -24 -4.5 ]
[.4875 .21572 0 4.5 ]
[.4875 .38536 -18 -4.5 ]
[.4875 .38536 0 4.5 ]
[.4875 .47017 -6 -4.5 ]
[.4875 .47017 0 4.5 ]
[.4875 .55499 -18 -4.5 ]
[.4875 .55499 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .30054 m
.11905 .30679 L
s
[(-4)] .11905 .28804 0 1 Mshowa
.30952 .30054 m
.30952 .30679 L
s
[(-2)] .30952 .28804 0 1 Mshowa
.69048 .30054 m
.69048 .30679 L
s
[(2)] .69048 .28804 0 1 Mshowa
.88095 .30054 m
.88095 .30679 L
s
[(4)] .88095 .28804 0 1 Mshowa
.125 Mabswid
.16667 .30054 m
.16667 .30429 L
s
.21429 .30054 m
.21429 .30429 L
s
.2619 .30054 m
.2619 .30429 L
s
.35714 .30054 m
.35714 .30429 L
s
.40476 .30054 m
.40476 .30429 L
s
.45238 .30054 m
.45238 .30429 L
s
.54762 .30054 m
.54762 .30429 L
s
.59524 .30054 m
.59524 .30429 L
s
.64286 .30054 m
.64286 .30429 L
s
.7381 .30054 m
.7381 .30429 L
s
.78571 .30054 m
.78571 .30429 L
s
.83333 .30054 m
.83333 .30429 L
s
.07143 .30054 m
.07143 .30429 L
s
.02381 .30054 m
.02381 .30429 L
s
.92857 .30054 m
.92857 .30429 L
s
.97619 .30054 m
.97619 .30429 L
s
.25 Mabswid
0 .30054 m
1 .30054 L
s
.5 .04609 m
.50625 .04609 L
s
[(-7.5)] .4875 .04609 1 0 Mshowa
.5 .13091 m
.50625 .13091 L
s
[(-5)] .4875 .13091 1 0 Mshowa
.5 .21572 m
.50625 .21572 L
s
[(-2.5)] .4875 .21572 1 0 Mshowa
.5 .38536 m
.50625 .38536 L
s
[(2.5)] .4875 .38536 1 0 Mshowa
.5 .47017 m
.50625 .47017 L
s
[(5)] .4875 .47017 1 0 Mshowa
.5 .55499 m
.50625 .55499 L
s
[(7.5)] .4875 .55499 1 0 Mshowa
.125 Mabswid
.5 .06305 m
.50375 .06305 L
s
.5 .08002 m
.50375 .08002 L
s
.5 .09698 m
.50375 .09698 L
s
.5 .11394 m
.50375 .11394 L
s
.5 .14787 m
.50375 .14787 L
s
.5 .16483 m
.50375 .16483 L
s
.5 .1818 m
.50375 .1818 L
s
.5 .19876 m
.50375 .19876 L
s
.5 .23269 m
.50375 .23269 L
s
.5 .24965 m
.50375 .24965 L
s
.5 .26661 m
.50375 .26661 L
s
.5 .28358 m
.50375 .28358 L
s
.5 .3175 m
.50375 .3175 L
s
.5 .33447 m
.50375 .33447 L
s
.5 .35143 m
.50375 .35143 L
s
.5 .36839 m
.50375 .36839 L
s
.5 .40232 m
.50375 .40232 L
s
.5 .41928 m
.50375 .41928 L
s
.5 .43625 m
.50375 .43625 L
s
.5 .45321 m
.50375 .45321 L
s
.5 .48714 m
.50375 .48714 L
s
.5 .5041 m
.50375 .5041 L
s
.5 .52106 m
.50375 .52106 L
s
.5 .53803 m
.50375 .53803 L
s
.5 .02913 m
.50375 .02913 L
s
.5 .01216 m
.50375 .01216 L
s
.5 .57195 m
.50375 .57195 L
s
.5 .58892 m
.50375 .58892 L
s
.5 .60588 m
.50375 .60588 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .45724 m
.06244 .3087 L
.10458 .16437 L
.12507 .10843 L
.14415 .06725 L
.1536 .05111 L
.16254 .03856 L
.16748 .03275 L
.17284 .02737 L
.17735 .02359 L
.18221 .02027 L
.18475 .01884 L
.18708 .01773 L
.18945 .01677 L
.19165 .01605 L
.1942 .01541 L
.19554 .01515 L
.19623 .01505 L
.19698 .01495 L
.19769 .01487 L
.19835 .01481 L
.19964 .01474 L
.20081 .01472 L
.20205 .01474 L
.20335 .01482 L
.20455 .01494 L
.20592 .01513 L
.20723 .01536 L
.20955 .01591 L
.21207 .01669 L
.21779 .01915 L
.22307 .02228 L
.2327 .02997 L
.24174 .03939 L
.26234 .06795 L
.30103 .14125 L
.34217 .23169 L
.38179 .3136 L
.4199 .37511 L
.43951 .39775 L
.45049 .40753 L
.46046 .4146 L
.47044 .41997 L
.47965 .42346 L
.48446 .42474 L
.48722 .42532 L
.48975 .42574 L
.49241 .42608 L
.49388 .42622 L
.49527 .42633 L
Mistroke
.49656 .42641 L
.49775 .42645 L
.49905 .42648 L
.49978 .42649 L
.50044 .42649 L
.50165 .42647 L
.50278 .42643 L
.50401 .42638 L
.50533 .42629 L
.50803 .42605 L
.51049 .42575 L
.51524 .42495 L
.51973 .42395 L
.52971 .42092 L
.54056 .41652 L
.5814 .39306 L
.62072 .36746 L
.64045 .35608 L
.65852 .34735 L
.6779 .34015 L
.68808 .33733 L
.69877 .33505 L
.70834 .33359 L
.7137 .333 L
.71855 .33259 L
.7231 .33231 L
.72566 .3322 L
.72801 .33212 L
.73008 .33207 L
.73125 .33204 L
.73235 .33203 L
.73351 .33202 L
.73456 .33201 L
.73578 .33201 L
.73693 .33201 L
.73807 .33202 L
.7393 .33203 L
.74045 .33205 L
.74151 .33206 L
.74398 .33212 L
.74657 .33219 L
.75146 .33238 L
.75682 .33263 L
.77523 .33367 L
.78051 .33394 L
.78549 .33417 L
.78996 .33432 L
.79249 .33439 L
.79371 .33441 L
.79482 .33443 L
Mistroke
.79602 .33445 L
.79732 .33446 L
.79852 .33447 L
.79966 .33447 L
.80098 .33446 L
.80221 .33445 L
.80291 .33444 L
.80355 .33443 L
.80499 .3344 L
.80638 .33436 L
.80765 .33432 L
.81054 .3342 L
.81308 .33405 L
.81576 .33387 L
.82072 .33341 L
.82525 .33286 L
.83012 .33212 L
.83541 .33112 L
.84483 .32882 L
.85375 .32597 L
.87354 .31706 L
.88353 .31113 L
.89455 .30346 L
.93478 .2658 L
.97348 .21878 L
.97619 .21529 L
Mfstroke
0 0 1 r
.02381 .24143 m
.06244 .39345 L
.08255 .46153 L
.10458 .52292 L
.11448 .54528 L
.12507 .56532 L
.13499 .58033 L
.14415 .59086 L
.14911 .59522 L
.15437 .59882 L
.15691 .60018 L
.15964 .60137 L
.16121 .60193 L
.16265 .60235 L
.16401 .60268 L
.16546 .60296 L
.16615 .60307 L
.1668 .60315 L
.16802 .60326 L
.16916 .60331 L
.17039 .60332 L
.17104 .6033 L
.17176 .60326 L
.1725 .6032 L
.1732 .60312 L
.17445 .60294 L
.17578 .60268 L
.17842 .60199 L
.18092 .6011 L
.1856 .59884 L
.19019 .59589 L
.19525 .5918 L
.20551 .58099 L
.22393 .55375 L
.24327 .51598 L
.26413 .46744 L
.30527 .36021 L
.34489 .2618 L
.36486 .22026 L
.383 .18934 L
.40261 .16434 L
.41339 .1546 L
.41823 .15115 L
.42356 .14805 L
.42859 .14576 L
.43328 .14419 L
.43588 .14356 L
.43825 .14312 L
.43955 .14293 L
.44025 .14285 L
Mistroke
.44098 .14278 L
.44169 .14272 L
.44233 .14268 L
.44358 .14263 L
.44474 .14261 L
.44596 .14263 L
.447 .14267 L
.44815 .14274 L
.44938 .14286 L
.4507 .14302 L
.45308 .14341 L
.45549 .14394 L
.45777 .14455 L
.46203 .14601 L
.46663 .14803 L
.47171 .15076 L
.48198 .15781 L
.50041 .17503 L
.54067 .22675 L
.57941 .28209 L
.59909 .30752 L
.6206 .33065 L
.63055 .33925 L
.64117 .34676 L
.64632 .34976 L
.65118 .35217 L
.65588 .35413 L
.66027 .35562 L
.66492 .35683 L
.66738 .35732 L
.67002 .35773 L
.67135 .35789 L
.67279 .35803 L
.67345 .35809 L
.67415 .35813 L
.67541 .3582 L
.67662 .35823 L
.67775 .35824 L
.67899 .35823 L
.67969 .35821 L
.68033 .35819 L
.6814 .35813 L
.68255 .35805 L
.68462 .35784 L
.68708 .3575 L
.68932 .35711 L
.69419 .35596 L
.69879 .35453 L
.7085 .35043 L
.71878 .34459 L
Mistroke
.73723 .33072 L
.77508 .29292 L
.81539 .24997 L
.83394 .23335 L
.84374 .22607 L
.85418 .21972 L
.85994 .21691 L
.86515 .21481 L
.87039 .21316 L
.87533 .21204 L
.87778 .21165 L
.87911 .21148 L
.88036 .21135 L
.88143 .21126 L
.88257 .21119 L
.88383 .21114 L
.88499 .21112 L
.88563 .21112 L
.88632 .21112 L
.88756 .21116 L
.88824 .21119 L
.88888 .21123 L
.89035 .21135 L
.89162 .21148 L
.89279 .21163 L
.89543 .21207 L
.89791 .2126 L
.90017 .21319 L
.90524 .21488 L
.91436 .21917 L
.92502 .22623 L
.93507 .23487 L
.9551 .25751 L
.97356 .28403 L
.97619 .28819 L
Mfstroke
0 1 0 r
.02381 .39814 m
.02846 .39943 L
.03279 .40042 L
.03754 .40127 L
.0402 .40164 L
.04262 .40191 L
.04385 .40202 L
.04516 .40211 L
.04629 .40218 L
.0475 .40224 L
.04881 .40229 L
.05003 .40231 L
.05077 .40232 L
.05148 .40232 L
.05212 .40231 L
.05281 .4023 L
.05408 .40227 L
.05523 .40223 L
.05656 .40216 L
.05781 .40207 L
.06003 .40188 L
.06244 .40161 L
.06753 .40083 L
.07312 .39964 L
.07895 .39803 L
.08439 .3962 L
.10458 .38675 L
.12493 .37331 L
.14349 .35816 L
.18333 .3191 L
.22166 .27842 L
.26245 .23917 L
.2827 .22341 L
.30171 .21177 L
.31056 .20754 L
.31988 .20394 L
.32476 .20243 L
.33009 .20106 L
.33495 .2001 L
.33946 .19943 L
.34209 .19915 L
.34451 .19895 L
.34578 .19888 L
.34717 .19882 L
.34787 .1988 L
.34862 .19878 L
.34934 .19877 L
.34999 .19876 L
.35125 .19876 L
.35242 .19878 L
Mistroke
.35371 .19882 L
.35443 .19885 L
.35508 .19888 L
.35757 .19905 L
.35992 .19927 L
.36458 .19988 L
.36885 .20066 L
.37851 .20316 L
.38827 .2067 L
.39737 .21089 L
.41805 .22337 L
.45701 .25614 L
.49842 .29885 L
.53832 .34039 L
.5767 .37393 L
.59651 .38691 L
.60651 .39208 L
.61753 .3966 L
.62247 .39822 L
.62765 .39963 L
.63214 .40061 L
.63692 .40142 L
.63963 .40176 L
.64209 .402 L
.64328 .40209 L
.64456 .40218 L
.64578 .40224 L
.64689 .40228 L
.6482 .40231 L
.64942 .40232 L
.65012 .40232 L
.65076 .40231 L
.65149 .4023 L
.65219 .40228 L
.65287 .40226 L
.65358 .40223 L
.65487 .40216 L
.65626 .40207 L
.65779 .40194 L
.66013 .4017 L
.6627 .40136 L
.66787 .40045 L
.67266 .39935 L
.67711 .3981 L
.68719 .39449 L
.69796 .38948 L
.71928 .37627 L
.73943 .36031 L
.77786 .32315 L
.81875 .2798 L
Mistroke
.85812 .24151 L
.87789 .22569 L
.89597 .21402 L
.90526 .20921 L
.9154 .20496 L
.92095 .20308 L
.92611 .20164 L
.93103 .20053 L
.93358 .20006 L
.93628 .19964 L
.93873 .19933 L
.94143 .19906 L
.94261 .19897 L
.94387 .1989 L
.94507 .19884 L
.94616 .1988 L
.94682 .19878 L
.94752 .19877 L
.94879 .19876 L
.94949 .19876 L
.95014 .19877 L
.95086 .19878 L
.95164 .1988 L
.95296 .19886 L
.95435 .19893 L
.95684 .19912 L
.95915 .19936 L
.96163 .19968 L
.96608 .20043 L
.97138 .20161 L
.97619 .20294 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oS`3oool0
0`000000oooo0?ooo`2>0?ooo`00S`3oool00`000000oooo0?ooo`2>0?ooo`00S`3oool00`000000
oooo0?ooo`2>0?ooo`00S`3oool2000008l0oooo000f0?ooo`P0o`00D@3oool00`000000oooo0?oo
o`2>0?ooo`00=03oool20?l000P0oooo00<0o`000?ooo`3oool0CP3oool00`000000oooo0?ooo`2>
0?ooo`00<`3oool00`3o0000oooo0?ooo`090?ooo`80o`00CP3oool00`000000oooo0?ooo`2>0?oo
o`00<@3oool20?l000h0oooo00<0o`000?ooo`3oool0B`3oool00`000000oooo0?ooo`2>0?ooo`00
<03oool00`3o0000oooo0?ooo`0?0?ooo`030?l0003oool0oooo04X0oooo0P00002?0?ooo`00<03o
ool00`3o0000oooo0?ooo`0@0?ooo`030?l0003oool0oooo04T0oooo00<000000?ooo`3oool0SP3o
ool002l0oooo00<0o`000?ooo`3oool04P3oool00`3o0000oooo0?ooo`180?ooo`030000003oool0
oooo08h0oooo000^0?ooo`030?l0003oool0oooo01@0oooo00<0o`000?ooo`3oool0=03oool00`00
0000oooo0?ooo`020?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool0SP3oool002d0
oooo00<0o`000?ooo`3oool05P3oool00`3o0000oooo0?ooo`0c0?ooo`030000003oool0oooo00L0
oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`2>0?ooo`00;@3oool00`3o0000
oooo0?ooo`0F0?ooo`030?l0003oool0oooo03<0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`030?ooo`<00000SP3oool002`0oooo00<0o`000?ooo`3oool0603oool00`3o0000oooo
0?ooo`0Z0?ooo`@000001@3oool00`000000oooo0?ooo`070?ooo`8000001P3oool00`000000oooo
0?ooo`2>0?ooo`00:`3oool00`3o0000oooo0?ooo`0J0?ooo`030?l0003oool0oooo02l0oooo00@0
00000?ooo`3oool000002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo08h0oooo
000[0?ooo`030?l0003oool0oooo01/0oooo00<0o`000?ooo`3oool0;P3oool4000000T0oooo0`00
00050?ooo`030000003oool0oooo08h0oooo000Z0?ooo`030?l0003oool0oooo01`0oooo00<0o`00
0?ooo`3oool0@`3oool00`000000oooo0?ooo`2>0?ooo`00:P3oool00`3o0000oooo0?ooo`0M0?oo
o`030?l0003oool0oooo0480oooo0P00002?0?ooo`00:@3oool00`3o0000oooo0?ooo`0O0?ooo`03
0?l0003oool0oooo0440oooo00<000000?ooo`3oool0SP3oool002T0oooo00<0o`000?ooo`3oool0
803oool00`3o0000oooo0?ooo`100?ooo`030000003oool0oooo08h0oooo000X0?ooo`030?l0003o
ool0oooo0240oooo00<0o`000?ooo`3oool0@03oool00`000000oooo0?ooo`2>0?ooo`00:03oool0
0`3o0000oooo0?ooo`0R0?ooo`030?l0003oool0oooo03l0oooo0P00002?0?ooo`009`3oool00`3o
0000oooo0?ooo`0S0?ooo`030?l0003oool0oooo03l0oooo00<000000?ooo`3oool0SP3oool002L0
oooo00<0o`000?ooo`3oool0903oool00`3o0000oooo0?ooo`0n0?ooo`030000003oool0oooo08h0
oooo000V0?ooo`030?l0003oool0oooo02D0oooo00<0o`000?ooo`3oool0?P3oool00`000000oooo
0?ooo`2>0?ooo`009P3oool00`3o0000oooo0?ooo`0V0?ooo`030?l0003oool0oooo03d0oooo00<0
00000?ooo`3oool0SP3oool002H0oooo00<0o`000?ooo`3oool09P3oool00`3o0000oooo0?ooo`0m
0?ooo`800000S`3oool002D0oooo00<0o`000?ooo`3oool0:03oool00`3o0000oooo0?ooo`0l0?oo
o`030000003oool0oooo08h0oooo000U0?ooo`030?l0003oool0oooo02P0oooo00<0o`000?ooo`3o
ool0?03oool00`000000oooo0?ooo`2>0?ooo`00903oool00`3o0000oooo0?ooo`0Z0?ooo`030?l0
003oool0oooo03/0oooo00<000000?ooo`3oool0SP3oool002@0oooo00<0o`000?ooo`3oool0:P3o
ool00`3o0000oooo0?ooo`0k0?ooo`030000003oool0oooo08h0oooo000T0?ooo`030?l0003oool0
oooo02/0oooo00<0o`000?ooo`3oool0>P3oool2000008l0oooo000S0?ooo`030?l0003oool0oooo
02`0oooo00<0o`000?ooo`3oool0>P3oool00`000000oooo0?ooo`2>0?ooo`008`3oool00`3o0000
oooo0?ooo`0]0?ooo`030?l0003oool0oooo03T0oooo00<000000?ooo`3oool0SP3oool00280oooo
00<0o`000?ooo`3oool0;P3oool00`3o0000oooo0?ooo`0a0?ooo`8000001P3oool00`000000oooo
0?ooo`2>0?ooo`008P3oool00`3o0000oooo0?ooo`0_0?ooo`030?l0003oool0oooo02l0oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`2>0?ooo`008P3oool00`3o0000oooo0?oo
o`0_0?ooo`030?l0003oool0oooo0380oooo00<000000?ooo`3oool00`3oool3000008h0oooo000Q
0?ooo`030?l0003oool0oooo0340oooo00<0o`000?ooo`3oool0:03oool4000000<0oooo0P000006
0?ooo`030000003oool0oooo08h0oooo000Q0?ooo`030?l0003oool0oooo0340oooo00<0o`000?oo
o`3oool0;`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo08h0oooo000Q0?ooo`03
0?l0003oool0oooo0380oooo00<0o`000?ooo`3oool09@3oool40000o`D0oooo0`0000050?ooo`03
0000003oool0oooo08h0oooo000P0?ooo`030?l0003oool0oooo03<0oooo00<0o`000?ooo`3oool0
8P3oool30000o`<0oooo10000?l:0?ooo`030000003oool0oooo08h0oooo000P0?ooo`030?l0003o
ool0oooo03@0oooo00<0o`000?ooo`3oool07`3oool20000o`X0oooo00<0003o0?ooo`3oool01`3o
ool2000008l0oooo000O0?ooo`030?l0003oool0oooo03D0oooo00<0o`000?ooo`3oool07P3oool0
0`000?l0oooo0?ooo`0;0?ooo`80003o1`3oool00`000000oooo0?ooo`2>0?ooo`007`3oool00`3o
0000oooo0?ooo`0f0?ooo`030?l0003oool0oooo01/0oooo0P000?l@0?ooo`80003o1@3oool00`00
0000oooo0?ooo`2>0?ooo`007`3oool00`3o0000oooo0?ooo`0f0?ooo`030?l0003oool0oooo01X0
oooo00<0003o0?ooo`3oool04P3oool00`000?l0oooo0?ooo`020?ooo`030000003oool0oooo08h0
oooo000N0?ooo`030?l0003oool0oooo03P0oooo00<0o`000?ooo`3oool0603oool00`000?l0oooo
0?ooo`0D0?ooo`050000o`3oool0oooo0?ooo`000000T03oool001h0oooo00<0o`000?ooo`3oool0
>03oool00`3o0000oooo0?ooo`0G0?ooo`030000o`3oool0oooo01H0oooo00<0003o0?ooo`3oool0
0P00002?0?ooo`007P3oool00`3o0000oooo0?ooo`0i0?ooo`030?l0003oool0oooo01D0oooo00<0
003o0?ooo`3oool0603oool00`000?l0oooo0000002@0?ooo`007@3oool00`3o0000oooo0?ooo`0j
0?ooo`030?l0003oool0oooo01D0oooo00<0003o0?ooo`3oool06@3oool00`000?l000000?ooo`2?
0?ooo`007@3oool00`3o0000oooo0?ooo`0k0?ooo`030?l0003oool0oooo01<0oooo00<0003o0?oo
o`3oool06`3oool00`000?l0oooo0?ooo`2>0?ooo`007@3oool00`3o0000oooo0?ooo`0k0?ooo`03
0?l0003oool0oooo0180oooo00<0003o0?ooo`3oool0703oool00`000000003o0?ooo`2>0?ooo`00
7@3oool00`3o0000oooo0?ooo`0l0?ooo`030?l0003oool0oooo0100oooo00<0003o0?ooo`3oool0
7@3oool2000000030000o`3oool0oooo08`0oooo000L0?ooo`030?l0003oool0oooo03d0oooo00<0
o`000?ooo`3oool0403oool00`000?l0oooo0?ooo`0M0?ooo`040000003oool0oooo0000ohd0oooo
000L0?ooo`030?l0003oool0oooo03d0oooo00<0o`000?ooo`3oool03`3oool00`000?l0oooo0?oo
o`0N0?ooo`040000003oool0oooo0000ohd0oooo000L0?ooo`030?l0003oool0oooo03h0oooo00<0
o`000?ooo`3oool03@3oool00`000?l0oooo0?ooo`0O0?ooo`050000003oool0oooo0?ooo`000?l0
S03oool001/0oooo00<0o`000?ooo`3oool0?`3oool00`3o0000oooo0?ooo`030?ooo`@00?l01P3o
ool00`000?l0oooo0?ooo`0O0?ooo`8000000`3oool00`000?l0oooo0?ooo`1g0?ooo`@00?l03P3o
ool001/0oooo00<0o`000?ooo`3oool0@03oool5003o00<0oooo1@00o`000`3oool0003o0?ooo`0Q
0?ooo`030000003oool0oooo00<0oooo00<0003o0?ooo`3oool0L@3oool6003o0080oooo1P00o`09
0?ooo`006`3oool00`3o0000oooo0?ooo`0m0?ooo`<00?l000<0o`000?ooo`3oool02P3oool3003o
0240oooo00<000000?ooo`3oool0103oool00`000?l0oooo0?ooo`1/0?ooo`@00?l03P3oool00`00
o`00oooo0?ooo`060?ooo`006P3oool00`3o0000oooo0?ooo`0k0?ooo`<00?l0103oool00`3o0000
oooo0?ooo`090?ooo`030000o`3oool0oooo00<00?l02@3oool4000000<0oooo0P0000040?ooo`80
00001P3oool00`000000oooo0?ooo`050?ooo`030000o`3oool0oooo06T0oooo0P00o`0K0?ooo`00
6P3oool00`3o0000oooo0?ooo`0i0?ooo`800?l01`3oool00`3o0000oooo0?ooo`080?ooo`030000
o`3oool0oooo00@0oooo0P00o`070?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`060?ooo`030000o`3oool0oooo05l0oooo1`000?l2003o01d0
oooo000J0?ooo`030?l0003oool0oooo03P0oooo00<00?l00?ooo`3oool0203oool00`3o0000oooo
0?ooo`060?ooo`030000o`3oool0oooo00L0oooo0P00o`060?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool00`3oool3000000H0oooo00<0003o0?ooo`3oool0G@3oool20000o`H0oooo
00<00?l00?ooo`000?l00P000?lB0?ooo`030?l0003oool0oooo00H0oooo000J0?ooo`030?l0003o
ool0oooo03H0oooo0P00o`0;0?ooo`030?l0003oool0oooo00H0oooo00<0003o0?ooo`3oool0203o
ool0100000000?l00000000000040?ooo`030000003oool0oooo00P0oooo0P0000060?ooo`030000
003oool0oooo00L0oooo00<0003o0?ooo`3oool0F03oool40000o`H0oooo0P00o`050?ooo`80003o
403oool00`3o0000oooo0?ooo`060?ooo`006@3oool00`3o0000oooo0?ooo`0f0?ooo`03003o003o
ool0oooo00`0oooo00<0o`000?ooo`3oool0103oool00`000?l0oooo0?ooo`0;0?ooo`800?l00P3o
ool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool00`000?l0oooo0?ooo`1E0?ooo`80003o203oool2003o00T0oooo0P000?l=0?ooo`030?l0
003oool0oooo00L0oooo000I0?ooo`030?l0003oool0oooo03D0oooo00<00?l00?ooo`3oool03@3o
ool00`3o0000oooo0?ooo`040?ooo`030000o`3oool0oooo00d0oooo00<00?l00?ooo`3oool00P00
000:0?ooo`<000001@3oool00`000000oooo0?ooo`090?ooo`030000o`3oool0oooo05<0oooo00<0
003o0?ooo`3oool01`3oool00`00o`00oooo0?ooo`0;0?ooo`030000o`3oool0oooo00T0oooo00<0
o`000?ooo`3oool0203oool001T0oooo00<0o`000?ooo`3oool0<`3oool2003o0140oooo00<0o`00
0?ooo`3oool00P3oool00`000?l0oooo0?ooo`0?0?ooo`03003o003oool0oooo01<0oooo00<00000
0?ooo`3oool02P3oool00`000?l0oooo0?ooo`1A0?ooo`030000o`3oool0oooo00L0oooo00<00?l0
0?ooo`3oool03@3oool00`000?l0oooo0?ooo`070?ooo`030?l0003oool0oooo00T0oooo000H0?oo
o`030?l0003oool0oooo03<0oooo00<00?l00?ooo`3oool04@3oool00`3o0000oooo0?ooo`020?oo
o`030000o`3oool0oooo0100oooo0P00o`0C0?ooo`8000002`3oool00`000?l0oooo0?ooo`1@0?oo
o`030000o`3oool0oooo00L0oooo00<00?l00?ooo`3oool03`3oool00`000?l0oooo0?ooo`060?oo
o`030?l0003oool0oooo00T0oooo000H0?ooo`030?l0003oool0oooo0340oooo0P00o`0D0?ooo`05
0?l0003oool0oooo0?ooo`000?l05@3oool00`00o`00oooo0?ooo`0@0?ooo`030000003oool0oooo
00/0oooo00<0003o0?ooo`3oool0CP3oool00`000?l0oooo0?ooo`070?ooo`03003o003oool0oooo
0140oooo00<0003o0?ooo`3oool0103oool00`3o0000oooo0?ooo`0:0?ooo`00603oool00`3o0000
oooo0?ooo`0`0?ooo`03003o003oool0oooo01D0oooo00@0o`000?ooo`3oool0003o5P3oool00`00
o`00oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo00<0003o0?ooo`3oool0C03oool00`00
0?l0oooo0?ooo`070?ooo`03003o003oool0oooo01<0oooo00<0003o0?ooo`3oool00P3oool00`3o
0000oooo0?ooo`0;0?ooo`001`3oool00`000?l0oooo0?ooo`0>0?ooo`030?l0003oool0oooo02l0
oooo00<00?l00?ooo`3oool05P3oool00`3o0000oooo0000o`0H0?ooo`03003o003oool0oooo00h0
oooo00<000000?ooo`3oool0303oool00`000?l0oooo0?ooo`1:0?ooo`80003o2@3oool00`00o`00
oooo0?ooo`0E0?ooo`040000o`3oool0oooo0?l000h0oooo00070?ooo`030000o`3oool0oooo00d0
oooo00<0o`000?ooo`3oool0;`3oool00`00o`00oooo0?ooo`0H0?ooo`030?l000000?l0oooo01P0
oooo00<00?l00?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000o`3oool0oooo04P0
oooo00<0003o0?ooo`3oool0203oool00`00o`00oooo0?ooo`0F0?ooo`030000o`3oool0o`0000l0
oooo00080?ooo`030000o`3oool0oooo00`0oooo00<0o`000?ooo`3oool0;P3oool00`00o`00oooo
0?ooo`0I0?ooo`030?l000000?l0oooo01T0oooo0P00o`0=0?ooo`8000003`3oool00`000?l0oooo
0?ooo`160?ooo`030000o`3oool0oooo00P0oooo00<00?l00?ooo`3oool0603oool00`000?l0oooo
0?ooo`0>0?ooo`00203oool00`000?l0oooo0?ooo`0<0?ooo`030?l0003oool0oooo02d0oooo00<0
0?l00?ooo`3oool06P3oool00`000?l0o`000?ooo`0K0?ooo`03003o003oool0oooo00X0oooo00<0
00000?ooo`3oool03P3oool00`000?l0oooo0?ooo`150?ooo`030000o`3oool0oooo00P0oooo00<0
0?l00?ooo`3oool0603oool00`3o0000oooo0000o`0?0?ooo`00203oool00`000?l0oooo0?ooo`0;
0?ooo`030?l0003oool0oooo02d0oooo00<00?l00?ooo`3oool06`3oool00`000?l0o`000?ooo`0L
0?ooo`03003o003oool0oooo00T0oooo00<000000?ooo`3oool03`3oool00`000?l0oooo0?ooo`13
0?ooo`030000o`3oool0oooo00P0oooo00<00?l00?ooo`3oool06@3oool0103o0000oooo0?ooo`00
0?l>0?ooo`00203oool00`000?l0oooo0?ooo`0;0?ooo`030?l0003oool0oooo00`0oooo0`00000L
0?ooo`800?l04`3oool4000000H0oooo00@0003o0?ooo`3oool0o`007@3oool00`00o`00oooo0?oo
o`080?ooo`030000003oool0oooo0100oooo00<0003o0?ooo`3oool07`3oool4000001h0oooo00<0
003o0?ooo`3oool0203oool00`00o`00oooo0?ooo`080?ooo`<000003P3oool00`3o0000oooo0?oo
o`020?ooo`030000o`3oool0oooo00/0oooo00090?ooo`030000o`3oool0oooo00X0oooo00<0o`00
0?ooo`3oool03@3oool00`000000oooo0?ooo`0J0?ooo`03003o003oool0oooo01<0oooo00<00000
0?ooo`3oool01`3oool010000?l0oooo0?ooo`3o000N0?ooo`03003o003oool0oooo00L0oooo00<0
00000?ooo`3oool04@3oool00`000?l0oooo0?ooo`0N0?ooo`030000003oool0oooo01h0oooo00<0
003o0?ooo`3oool01`3oool2003o00`0oooo00<000000?ooo`3oool0303oool00`3o0000oooo0?oo
o`030?ooo`030000o`3oool0oooo00/0oooo00090?ooo`030000o`3oool0oooo00X0oooo00<0o`00
0?ooo`3oool02P3oool5000001X0oooo00<00?l00?ooo`3oool05@3oool00`000000oooo0?ooo`06
0?ooo`050000o`3oool0oooo0?ooo`3o00007P3oool00`00o`00oooo0?ooo`060?ooo`8000004P3o
ool00`000?l0oooo0?ooo`0O0?ooo`030000003oool0oooo01`0oooo00<0003o0?ooo`3oool01`3o
ool00`00o`00oooo0?ooo`090?ooo`D00000303oool00`3o0000oooo0?ooo`050?ooo`030000o`3o
ool0oooo00X0oooo00090?ooo`030000o`3oool0oooo00T0oooo00<0o`000?ooo`3oool01@3oool4
00000080oooo00@000000?ooo`3oool000006P3oool00`00o`00oooo0?ooo`0?0?ooo`@00000103o
ool00`000000oooo0?ooo`040?ooo`030000o`3oool0oooo0080oooo00<0o`000?ooo`3oool07@3o
ool00`00o`00oooo0?ooo`050?ooo`030000003oool0oooo0180oooo00<0003o0?ooo`3oool07`3o
ool00`000000oooo0?ooo`0J0?ooo`030000o`3oool0oooo00L0oooo00<00?l00?ooo`3oool02P3o
ool010000000oooo0?ooo`00000<0?ooo`030?l0003oool0oooo00L0oooo00<0003o0?ooo`3oool0
2@3oool000T0oooo00<0003o0?ooo`3oool02@3oool00`3o0000oooo0?ooo`0<0?ooo`030000003o
ool0000001T0oooo00<00?l00?ooo`3oool05P3oool010000000oooo0?ooo`0000050?ooo`030000
o`3oool0oooo00<0oooo00<0o`000?ooo`3oool07@3oool00`00o`00oooo0?ooo`040?ooo`030000
003oool0oooo01<0oooo00<0003o0?ooo`3oool0703oool010000000oooo0?ooo`00000K0?ooo`03
0000o`3oool0oooo00H0oooo00<00?l00?ooo`3oool0303oool00`000000oooo0000000;0?ooo`03
0?l0003oool0oooo00T0oooo00<0003o0?ooo`3oool0203oool000X0oooo00<0003o0?ooo`3oool0
203oool00`3o0000oooo0?ooo`0=0?ooo`800000603oool00`00o`00oooo0?ooo`0H0?ooo`800000
1@3oool00`000?l0oooo0?ooo`040?ooo`030?l0003oool0oooo01h0oooo00<00?l00?ooo`3oool0
0`3oool00`000000oooo0?ooo`0C0?ooo`030000o`3oool0oooo01d0oooo0P00000K0?ooo`030000
o`3oool0oooo00H0oooo00<00?l00?ooo`3oool03P3oool2000000X0oooo00<0o`000?ooo`3oool0
2P3oool00`000?l0oooo0?ooo`080?ooo`002P3oool00`000?l0oooo0?ooo`070?ooo`030?l0003o
ool0oooo02L0oooo00<00?l00?ooo`3oool0803oool00`000?l0oooo0?ooo`050?ooo`030?l0003o
ool0oooo01h0oooo00<00?l00?ooo`3oool00P3oool00`000000oooo0?ooo`0D0?ooo`030000o`3o
ool0oooo03P0oooo00<0003o0?ooo`3oool01P3oool00`00o`00oooo0?ooo`0J0?ooo`030?l0003o
ool0oooo00`0oooo00<0003o0?ooo`3oool01`3oool000X0oooo00<0003o0?ooo`3oool01`3oool0
0`3o0000oooo0?ooo`0V0?ooo`03003o003oool0oooo0200oooo00<0003o0?ooo`3oool01P3oool0
0`3o0000oooo0?ooo`0O0?ooo`04003o003oool0oooo0?ooo`8000005P3oool00`000?l0oooo0?oo
o`0f0?ooo`030000o`3oool0oooo00H0oooo00<00?l00?ooo`3oool06@3oool20?l00100oooo00<0
003o0?ooo`3oool01P3oool000X0oooo00<0003o0?ooo`3oool01`3oool00`3o0000oooo0?ooo`0U
0?ooo`03003o003oool0oooo0240oooo00<0003o0?ooo`3oool01`3oool00`3o0000oooo0?ooo`0O
0?ooo`04003o003oool0oooo000001L0oooo00<0003o0?ooo`3oool0=@3oool00`000?l0oooo0?oo
o`060?ooo`03003o003oool0oooo01T0oooo00<0o`000?ooo`3oool0403oool00`000?l0oooo0?oo
o`060?ooo`002`3oool00`000?l0oooo0?ooo`050?ooo`030?l0003oool0oooo02D0oooo00<00?l0
0?ooo`3oool08P3oool00`000?l0oooo0?ooo`070?ooo`030?l0003oool0oooo0200oooo00<00?l0
0?ooo`000000603oool00`000?l0oooo0?ooo`0c0?ooo`030000o`3oool0oooo00H0oooo00<00?l0
0?ooo`3oool06@3oool00`3o0000oooo0?ooo`0J0?ooo`002`3oool00`000?l0oooo0?ooo`050?oo
o`030?l0003oool0oooo02@0oooo00<00?l00?ooo`3oool08P3oool00`000?l0oooo0?ooo`090?oo
o`030?l0003oool0oooo0200oooo00<00?l00000003oool05`3oool00`000?l0oooo0?ooo`0b0?oo
o`030000o`3oool0oooo00H0oooo00<00?l00?ooo`3oool06@3oool00`3o0000oooo0?ooo`0K0?oo
o`002`3oool00`000?l0oooo0?ooo`050?ooo`030?l0003oool0oooo02<0oooo00<00?l00?ooo`3o
ool08`3oool00`000?l0oooo0?ooo`090?ooo`030?l0003oool0oooo0240oooo00<00?l00?ooo`3o
ool05`3oool00`000?l0oooo0?ooo`0`0?ooo`030000o`3oool0oooo00H0oooo00<00?l00?ooo`3o
ool06@3oool00`3o0000oooo0?ooo`0L0?ooo`002`0000000`000?l0000000000005000000030?l0
00000000000002<0000000<00?l00000000000008P0000000`000?l000000000000;000000030?l0
0000000000000240000000<00?l00000000000005`0000000`000?l000000000000^000000030000
o`000000000000H0000000<00?l00000000000006@0000000`3o000000000000000L00000040oooo
00070?ooo`030000003oool0oooo0080oooo00<0003o0?ooo`3oool00`3oool00`3o0000oooo0000
000=0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01@3oool00`00o`00oooo0?oo
o`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`030?ooo`030000o`3oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?oo
o`050?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo003o
000;0?ooo`030000003oool0oooo00X0oooo00<0003o0?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`040000003oool0oooo003o00T0oooo00<000000?ooo`3oool02`3oool010000000oooo
0?ooo`3o000:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01P3oool000`0oooo
00<0003o0?ooo`3oool00`3oool00`3o0000oooo0?ooo`0R0?ooo`03003o003oool0oooo02<0oooo
00<0003o0?ooo`3oool03@3oool00`3o0000oooo0?ooo`0O0?ooo`040000003oool0oooo003o01P0
oooo00<0003o0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`070?ooo`03003o003oool0oooo01P0
oooo00<0o`000?ooo`3oool07`3oool000`0oooo00<0003o0?ooo`3oool00`3oool00`3o0000oooo
0?ooo`0Q0?ooo`03003o003oool0oooo02@0oooo00<0003o0?ooo`3oool03@3oool00`3o0000oooo
0?ooo`0O0?ooo`050000003oool0oooo0?ooo`00o`00603oool00`000?l0oooo0?ooo`0Y0?ooo`03
0000o`3oool0oooo00L0oooo00<00?l00?ooo`3oool05`3oool20?l00280oooo000<0?ooo`030000
o`3oool0oooo0080oooo00<0o`000?ooo`3oool08@3oool00`00o`00oooo0?ooo`0U0?ooo`030000
o`3oool0oooo00h0oooo00<0o`000?ooo`3oool07P3oool2000000<0oooo00<00?l00?ooo`3oool0
5P3oool00`000?l0oooo0?ooo`0W0?ooo`030000o`3oool0oooo00L0oooo00<00?l00?ooo`3oool0
5P3oool20?l002@0oooo000=0?ooo`050000o`3oool0oooo0?ooo`3o00008P3oool00`00o`00oooo
0?ooo`0U0?ooo`030000o`3oool0oooo00l0oooo00<0o`000?ooo`3oool07P3oool00`000000oooo
0?ooo`020?ooo`03003o003oool0oooo01L0oooo0P000?lV0?ooo`030000o`3oool0oooo00L0oooo
00<00?l00?ooo`3oool05@3oool20?l002H0oooo000=0?ooo`050000o`3oool0oooo0?ooo`3o0000
8@3oool00`00o`00oooo0?ooo`0V0?ooo`030000o`3oool0oooo0100oooo00<0o`000?ooo`3oool0
7@3oool00`000000oooo0?ooo`030?ooo`03003o003oool0oooo01P0oooo00<0003o0?ooo`3oool0
8P3oool00`000?l0oooo0?ooo`070?ooo`03003o003oool0oooo01@0oooo0P3o000X0?ooo`003@3o
ool01@000?l0oooo0?ooo`3oool0o`000200oooo00<00?l00?ooo`3oool09P3oool00`000?l0oooo
0?ooo`0A0?ooo`030?l0003oool0oooo01d0oooo00<000000?ooo`3oool0103oool00`00o`00oooo
0?ooo`0H0?ooo`030000o`3oool0oooo0200oooo00<0003o0?ooo`3oool01`3oool00`00o`00oooo
0?ooo`0C0?ooo`80o`00:P3oool000d0oooo00@0003o0?ooo`3oool0o`00803oool00`00o`00oooo
0?ooo`0W0?ooo`030000o`3oool0oooo0180oooo00<0o`000?ooo`3oool0703oool00`000000oooo
0?ooo`050?ooo`03003o003oool0oooo01P0oooo00<0003o0?ooo`3oool07P3oool00`000?l0oooo
0?ooo`070?ooo`03003o003oool0oooo00l0oooo1@3o000/0?ooo`003P3oool00`000?l0oooo0?l0
000O0?ooo`03003o003oool0oooo02L0oooo00<0003o0?ooo`3oool0503oool00`3o0000oooo0?oo
o`0K0?ooo`8000001`3oool00`00o`00oooo0?ooo`0H0?ooo`030000o`3oool0oooo0140oooo2`3o
00000`000?l0o`000?l000070?l00003003o003o0000o`000100o`00<@3oool000h0oooo00<0003o
0?ooo`3o00007P3oool00`00o`00oooo0?ooo`0X0?ooo`030000o`3oool0oooo01@0oooo00<0o`00
0?ooo`3oool06`3oool00`000000oooo0?ooo`070?ooo`03003o003oool0oooo01L0oooo00<0003o
0?ooo`3oool03P3oool30?l000T0oooo0P000?l90?ooo`03003o003oool0oooo0480oooo000>0?oo
o`030000o`3oool0o`0001d0oooo00<00?l00?ooo`3oool0:@3oool00`000?l0oooo0?ooo`0E0?oo
o`030?l0003oool0oooo01X0oooo00<000000?ooo`3oool0203oool00`00o`00oooo0?ooo`0G0?oo
o`030000o`3oool0oooo00X0oooo0`3o000;0?ooo`030000o`3oool0oooo00P0oooo00<00?l00?oo
o`3oool0@`3oool000h0oooo00<0003o0?l0003oool0703oool00`00o`00oooo0?ooo`0Y0?ooo`03
0000o`3oool0oooo01H0oooo00<0o`000?ooo`3oool06P3oool00`000000oooo0?ooo`090?ooo`03
003o003oool0oooo01L0oooo0P000?l70?ooo`<0o`003@3oool00`000?l0oooo0?ooo`080?ooo`03
003o003oool0oooo04@0oooo000?0?ooo`030000o`3oool0oooo01X0oooo00<00?l00?ooo`3oool0
:P3oool00`000?l0oooo0?ooo`0G0?ooo`030?l0003oool0oooo01T0oooo00<000000?ooo`3oool0
2P3oool00`00o`00oooo0?ooo`0H0?ooo`030000o`3oool0oooo0080oooo0P3o000>0?ooo`80003o
2P3oool00`00o`00oooo0?ooo`150?ooo`003`3oool00`000?l0oooo0?ooo`0I0?ooo`03003o003o
ool0oooo02X0oooo00<0003o0?ooo`3oool06@3oool00`3o0000oooo0?ooo`0H0?ooo`800000303o
ool00`00o`00oooo0?ooo`0H0?ooo`<0003o00<0o`000?ooo`3oool0303oool20000o`/0oooo00<0
0?l00?ooo`3oool0AP3oool000l0oooo00<0003o0?ooo`3oool0603oool00`00o`00oooo0?ooo`0[
0?ooo`030000o`3oool0oooo01T0oooo00<0o`000?ooo`3oool0603oool00`000000oooo0?ooo`0<
0?ooo`03003o003oool0oooo01L0oooo0P3o0000103oool0003o0000o`000?l90?ooo`<0003o303o
ool00`00o`00oooo0?ooo`170?ooo`003P3oool00`3o0000003o0?ooo`0H0?ooo`03003o003oool0
oooo02/0oooo00<0003o0?ooo`3oool06`3oool00`3o0000oooo0?ooo`0G0?ooo`030000003oool0
oooo00d0oooo0P00o`0F0?ooo`030?l0003oool0oooo00@0oooo2@000?l>0?ooo`03003o003oool0
oooo04P0oooo000>0?ooo`030?l0003oool0003o01L0oooo00<00?l00?ooo`3oool0;03oool00`00
0?l0oooo0?ooo`0L0?ooo`030?l0003oool0oooo01H0oooo00<000000?ooo`3oool03`3oool00`00
o`00oooo0?ooo`0A0?ooo`80o`007@3oool00`00o`00oooo0?ooo`190?ooo`003P3oool00`3o0000
oooo0000o`0E0?ooo`800?l0;`3oool00`000?l0oooo0?ooo`0L0?ooo`030?l0003oool0oooo01H0
oooo00<000000?ooo`3oool0403oool00`00o`00oooo0?ooo`0>0?ooo`80o`007@3oool2003o04`0
oooo000>0?ooo`030?l0003oool0003o01@0oooo00<00?l00?ooo`3oool0;P3oool00`000?l0oooo
0?ooo`0N0?ooo`030?l0003oool0oooo01D0oooo0P00000B0?ooo`03003o003oool0oooo00`0oooo
00<0o`000?ooo`3oool0703oool00`00o`00oooo0?ooo`1<0?ooo`003@3oool0103o0000oooo0?oo
o`000?lC0?ooo`03003o003oool0oooo02l0oooo00<0003o0?ooo`3oool07P3oool00`3o0000oooo
0?ooo`0E0?ooo`030000003oool0oooo0180oooo00<00?l00?ooo`3oool02@3oool20?l001d0oooo
0P00o`1?0?ooo`003@3oool01@3o0000oooo0?ooo`3oool0003o0100oooo0P00o`0a0?ooo`030000
o`3oool0oooo0200oooo00<0o`000?ooo`3oool0503oool00`000000oooo0?ooo`0C0?ooo`03003o
003oool0oooo00H0oooo0P3o000N0?ooo`03003o003oool0oooo04l0oooo000=0?ooo`050?l0003o
ool0oooo0?ooo`000?l03`3oool00`00o`00oooo0?ooo`0a0?ooo`030000o`3oool0oooo0240oooo
00<0o`000000000000000P0000030?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool0
503oool2003o00D0oooo00<0o`000?ooo`3oool0703oool2003o0580oooo000<0?ooo`030?l0003o
ool0oooo0080oooo00<0003o0?ooo`3oool02`3oool2003o03@0oooo00<0003o0?ooo`3oool08P3o
ool00`3o0000oooo0?ooo`090?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
5P3oool2003o00030?ooo`3o0000o`0001h0oooo00<00?l00?ooo`3oool0DP3oool000`0oooo00<0
o`000?ooo`3oool00P3oool00`000?l0oooo0?ooo`0:0?ooo`03003o003oool0oooo03<0oooo00<0
003o0?ooo`3oool0903oool00`3o0000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo0`00
000G0?ooo`030?l00000o`000?l001d0oooo0P00o`1E0?ooo`00303oool00`3o0000oooo0?ooo`03
0?ooo`030000o`3oool0oooo00L0oooo0P00o`0f0?ooo`030000o`3oool0oooo02D0oooo00<0o`00
0?ooo`3oool0203oool2000000H0oooo00<000000?ooo`3oool05@3oool20?l000<0oooo00<00?l0
0?ooo`3oool0603oool2003o05L0oooo000<0?ooo`030?l0003oool0oooo00<0oooo00<0003o0?oo
o`3oool01@3oool2003o03L0oooo00<0003o0?ooo`3oool0903oool010000000oooo0?ooo`3o0009
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0503oool00`3o0000oooo0?ooo`04
0?ooo`800?l05P3oool2003o05T0oooo000;0?ooo`030?l0003oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool2003o03T0oooo00<0003o0?ooo`3oool09@3oool2000000030?ooo`3o0000oooo
00L0oooo0`0000050?ooo`030000003oool0oooo0180oooo0P3o00090?ooo`<00?l04@3oool2003o
05/0oooo00070?ooo`D00?l01P3oool00`000?l00?l0003o0003003o03/0oooo00<0003o0?ooo`3o
ool0:@3oool00`3o0000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<0o`000?ooo`3o
ool0303oool5003o00L0oooo1@00o`1M0?ooo`002`3oool8003o00030000o`3oool0oooo03`0oooo
00<0003o0?ooo`3oool0:`3oool00`3o0000oooo0?ooo`0<0?ooo`800000403oool20?l001@0oooo
1`00o`1R0?ooo`002`3oool00`3o0000oooo0?ooo`050?ooo`030000o`3oool0oooo03`0oooo00<0
003o0?ooo`3oool0;03oool00`3o0000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo0P3o
001o0?ooo`002P3oool00`3o0000oooo0?ooo`060?ooo`030000o`3oool0oooo03/0oooo00<0003o
0?ooo`3oool0;P3oool20?l000/0oooo00<000000?ooo`3oool0303oool00`3o0000oooo0?ooo`1o
0?ooo`002P3oool00`3o0000oooo0?ooo`060?ooo`030000o`3oool0oooo03/0oooo00<0003o0?oo
o`3oool0<03oool00`3o0000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo0P3o00220?oo
o`002P3oool00`3o0000oooo0?ooo`070?ooo`030000o`3oool0oooo03X0oooo00<0003o0?ooo`3o
ool0<@3oool20?l000P0oooo00<000000?ooo`3oool0203oool20?l008@0oooo000:0?ooo`030?l0
003oool0oooo00L0oooo00<0003o0?ooo`3oool0>@3oool00`000?l0oooo0?ooo`0d0?ooo`030?l0
003oool0oooo00D0oooo0P0000060?ooo`<0o`00QP3oool000T0oooo00<0o`000?ooo`3oool0203o
ool00`000?l0oooo0?ooo`0i0?ooo`030000o`3oool0oooo03D0oooo1@3o00020?ooo`030000003o
ool0oooo00D0o`00R@3oool000T0oooo00<0o`000?ooo`3oool0203oool00`000?l0oooo0?ooo`0h
0?ooo`030000o`3oool0oooo03/0oooo1@3o002>0?ooo`002@3oool00`3o0000oooo0?ooo`090?oo
o`030000o`3oool0oooo03L0oooo00<0003o0?ooo`3oool0?@3oool00`000000oooo0?ooo`2>0?oo
o`002@3oool00`3o0000oooo0?ooo`090?ooo`030000o`3oool0oooo03L0oooo00<0003o0?ooo`3o
ool0?@3oool2000008l0oooo00080?ooo`030?l0003oool0oooo00X0oooo00<0003o0?ooo`3oool0
=P3oool00`000?l0oooo0?ooo`0n0?ooo`030000003oool0oooo08h0oooo00080?ooo`030?l0003o
ool0oooo00X0oooo00<0003o0?ooo`3oool0=P3oool00`000?l0oooo0?ooo`0n0?ooo`030000003o
ool0oooo08h0oooo00080?ooo`030?l0003oool0oooo00/0oooo00<0003o0?ooo`3oool0=03oool0
0`000?l0oooo0?ooo`0o0?ooo`030000003oool0oooo08h0oooo00080?ooo`030?l0003oool0oooo
00/0oooo00<0003o0?ooo`3oool0=03oool00`000?l0oooo0?ooo`0o0?ooo`030000003oool0oooo
08h0oooo00070?ooo`030?l0003oool0oooo00`0oooo00<0003o0?ooo`3oool0=03oool00`000?l0
oooo0?ooo`0o0?ooo`800000S`3oool000L0oooo00<0o`000?ooo`3oool0303oool00`000?l0oooo
0?ooo`0c0?ooo`030000o`3oool0oooo0400oooo00<000000?ooo`3oool0SP3oool001L0oooo00<0
003o0?ooo`3oool0<P3oool00`000?l0oooo0?ooo`100?ooo`030000003oool0oooo08h0oooo000G
0?ooo`030000o`3oool0oooo0340oooo00<0003o0?ooo`3oool0>@3oool2000000H0oooo00<00000
0?ooo`3oool0SP3oool001L0oooo00<0003o0?ooo`3oool0<@3oool00`000?l0oooo0?ooo`0h0?oo
o`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0SP3oool001P0oooo00<0003o0?oo
o`3oool0<03oool00`000?l0oooo0?ooo`0k0?ooo`030000003oool0oooo00<0oooo0`00002>0?oo
o`00603oool00`000?l0oooo0?ooo`0_0?ooo`030000o`3oool0oooo03X0oooo0P0000060?ooo`03
0000003oool0oooo08h0oooo000I0?ooo`030000o`3oool0oooo02h0oooo00<0003o0?ooo`3oool0
>P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo08h0oooo000I0?ooo`030000o`3o
ool0oooo02h0oooo00<0003o0?ooo`3oool0>P3oool3000000D0oooo00<000000?ooo`3oool0SP3o
ool001T0oooo00<0003o0?ooo`3oool0;@3oool00`000?l0oooo0?ooo`130?ooo`030000003oool0
oooo08h0oooo000J0?ooo`030000o`3oool0oooo02`0oooo00<0003o0?ooo`3oool0@`3oool20000
08l0oooo000J0?ooo`030000o`3oool0oooo02/0oooo00<0003o0?ooo`3oool0A03oool00`000000
oooo0?ooo`2>0?ooo`006`3oool00`000?l0oooo0?ooo`0Z0?ooo`030000o`3oool0oooo04@0oooo
00<000000?ooo`3oool0SP3oool001/0oooo00<0003o0?ooo`3oool0:P3oool00`000?l0oooo0?oo
o`140?ooo`030000003oool0oooo08h0oooo000L0?ooo`030000o`3oool0oooo02P0oooo00<0003o
0?ooo`3oool0A@3oool00`000000oooo0?ooo`2>0?ooo`00703oool00`000?l0oooo0?ooo`0X0?oo
o`030000o`3oool0oooo04D0oooo0P00002?0?ooo`00703oool00`000?l0oooo0?ooo`0X0?ooo`03
0000o`3oool0oooo04D0oooo00<000000?ooo`3oool0SP3oool001d0oooo00<0003o0?ooo`3oool0
9P3oool00`000?l0oooo0?ooo`160?ooo`030000003oool0oooo08h0oooo000M0?ooo`030000o`3o
ool0oooo02H0oooo00<0003o0?ooo`3oool0AP3oool00`000000oooo0?ooo`2>0?ooo`007P3oool0
0`000?l0oooo0?ooo`0T0?ooo`030000o`3oool0oooo04L0oooo00<000000?ooo`3oool0SP3oool0
01h0oooo00<0003o0?ooo`3oool0903oool00`000?l0oooo0?ooo`170?ooo`800000S`3oool001h0
oooo00<0003o0?ooo`3oool08`3oool00`000?l0oooo0?ooo`180?ooo`030000003oool0oooo08h0
oooo000O0?ooo`030000o`3oool0oooo0280oooo00<0003o0?ooo`3oool0B03oool00`000000oooo
0?ooo`2>0?ooo`007`3oool00`000?l0oooo0?ooo`0Q0?ooo`030000o`3oool0oooo04T0oooo00<0
00000?ooo`3oool0SP3oool00200oooo00<0003o0?ooo`3oool0803oool00`000?l0oooo0?ooo`19
0?ooo`030000003oool0oooo08h0oooo000P0?ooo`030000o`3oool0oooo01l0oooo00<0003o0?oo
o`3oool0BP3oool2000008l0oooo000Q0?ooo`030000o`3oool0oooo01h0oooo00<0003o0?ooo`3o
ool0BP3oool00`000000oooo0?ooo`2>0?ooo`008@3oool00`000?l0oooo0?ooo`0M0?ooo`030000
o`3oool0oooo03P0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P0000060?ooo`030000
003oool0oooo08h0oooo000R0?ooo`030000o`3oool0oooo01`0oooo00<0003o0?ooo`3oool0>03o
ool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
SP3oool00280oooo00<0003o0?ooo`3oool06`3oool00`000?l0oooo0?ooo`0i0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool00`3oool3000008h0oooo000S0?ooo`030000o`3oool0
oooo01T0oooo00<0003o0?ooo`3oool0>`3oool00`000000oooo0?ooo`070?ooo`8000001P3oool0
0`000000oooo0?ooo`2>0?ooo`008`3oool00`000?l0oooo0?ooo`0I0?ooo`030000o`3oool0oooo
03P0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo08h0oooo000T0?ooo`030000o`3oool0oooo01L0oooo00<0003o0?ooo`3oool0>@3oool40000
00T0oooo0`0000050?ooo`030000003oool0oooo08h0oooo000U0?ooo`030000o`3oool0oooo01D0
oooo00<0003o0?ooo`3oool0C`3oool00`000000oooo0?ooo`2>0?ooo`009@3oool00`000?l0oooo
0?ooo`0E0?ooo`030000o`3oool0oooo04l0oooo0P00002?0?ooo`009P3oool00`000?l0oooo0?oo
o`0C0?ooo`030000o`3oool0oooo0500oooo00<000000?ooo`3oool0SP3oool002H0oooo00<0003o
0?ooo`3oool04`3oool00`000?l0oooo0?ooo`1@0?ooo`030000003oool0oooo08h0oooo000W0?oo
o`030000o`3oool0oooo0140oooo00<0003o0?ooo`3oool0D@3oool00`000000oooo0?ooo`2>0?oo
o`00:03oool00`000?l0oooo0?ooo`0?0?ooo`030000o`3oool0oooo0580oooo00<000000?ooo`3o
ool0SP3oool002P0oooo00<0003o0?ooo`3oool03P3oool00`000?l0oooo0?ooo`1C0?ooo`800000
S`3oool002T0oooo00<0003o0?ooo`3oool0303oool00`000?l0oooo0?ooo`1D0?ooo`030000003o
ool0oooo08h0oooo000Z0?ooo`80003o2P3oool20000oeL0oooo00<000000?ooo`3oool0SP3oool0
02`0oooo0P000?l70?ooo`030000o`3oool0oooo05L0oooo00<000000?ooo`3oool0SP3oool002h0
oooo1`000?mJ0?ooo`030000003oool0oooo08h0oooo002?0?ooo`800000S`3oool008l0oooo00<0
00000?ooo`3oool0SP3oool008l0oooo00<000000?ooo`3oool0SP3oool008l0oooo00<000000?oo
o`3oool0SP3oool00001\
\>"],
  ImageRangeCache->{{{81, 368}, {374.812, 197.875}} -> {-8.23379, 11.5139, \
0.0366761, 0.102956}},
  CellTags->"b:0.0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Classification of Differential Equations", "Section",
  CellTags->{"classification", "c:3", "b:0.1"}],

Cell[TextData[{
  "While differential equations have a basic type of ordinary (ODEs), partial \
(PDEs), or differential-algebraic (DAEs), they can be further described by \
attributes such as order, linearity, and degree. The solution method used by \
",
  StyleBox["DSolve", "MR"],
  " and the nature of the solutions depend heavily on the class of equation \
being solved."
}], "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  "The ",
  StyleBox["order",
    FontSlant->"Italic"],
  " of a differential equation is the order of the highest derivative in the \
equation. "
}], "Text",
  CellTags->"b:0.1"],

Cell["\<\
This is a first-order ODE because its highest derivative is of \
order 1.\
\>", "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[
      x^2 \((1 - x^2)\)*\(y'\)[x] \[Equal] \((x - 3  x^3 - y[x])\) y[x], \ 
      y[x], \ x]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    \({{y[x] \[Rule] \(\(-x\) + x\^3\)\/\(C[1] - Log[x]\)}}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell["Here is the general solution to a fourth-order ODE.", "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y''''\)[x] - 16*y[x] \[Equal] \ x^2, \ y[x], x]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(-\(x\^2\/16\)\) + \[ExponentialE]\^\(2\ x\)\ C[
                1] + \[ExponentialE]\^\(\(-2\)\ x\)\ C[3] + C[2]\ Cos[2\ x] + 
            C[4]\ Sin[2\ x]}}\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell[TextData[{
  "A differential equation is linear if the equation is of the first degree \
in ",
  StyleBox["y",
    FontSlant->"Italic"],
  " and its derivatives, and if their coefficients are functions of the \
independent variable."
}], "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  "This is a ",
  StyleBox["nonlinear",
    FontSlant->"Italic"],
  " second-order ODE that represents the motion of a circular pendulum. It is \
nonlinear because ",
  StyleBox["Sin[", "MR"],
  StyleBox["y", "MR",
    FontSlant->"Plain"],
  StyleBox["[", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Plain"],
  StyleBox["]]", "MR"],
  " is not a linear function of ",
  StyleBox["y", "MR",
    FontSlant->"Plain"],
  StyleBox["[", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Plain"],
  StyleBox["]", "MR"],
  ". The ",
  StyleBox["Solve::ifun", "MR"],
  " warning message can be ignored here; it appears because ",
  StyleBox["Solve", "MR"],
  " uses ",
  StyleBox["JacobiAmplitude", "MR"],
  " (the inverse of ",
  StyleBox["EllipticF", "MR"],
  ") to find an expression for ",
  StyleBox["y[x]", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[\(y''\)[x] + 3*Sin[y[x]] \[Equal] 0, \ y, x]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    RowBox[{\(Solve::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse functions are \
being used by \\!\\(Solve\\), so some solutions may not be found; use Reduce \
for complete solution information. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:0.1"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            2\ JacobiAmplitude[\(-\(1\/2\)\)\ \@\(\((6 + C[1])\)\ \((x + \
C[2])\)\^2\), 12\/\(6 + C[1]\)]]}, {y \[Rule] 
          Function[{x}, 
            2\ JacobiAmplitude[1\/2\ \@\(\((6 + C[1])\)\ \((x + C[2])\)\^2\), 
                12\/\(6 + C[1]\)]]}}\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell["This plots the solutions.", "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{\(y[x] /. sol[\([\)\(1\)\(]\)]\) /. {C[1] \[Rule] \ \(-1\), \ 
            C[2] \[Rule] \ 3}, \ \(y[x] /. 
            sol[\([\)\(2\)\(]\)]\) /. {C[1] \[Rule] \ \(-1\), \ 
            C[2] \[Rule] \ 3}}, \ {x, \(-5\), 5}, \ 
      PlotStyle\  \[Rule] \ {{Orange}, \ {Blue, 
            Dashing[{0.05}]}}]; \)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"b:0.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 0.309017 0.209715 [
[.11905 .29652 -6 -9 ]
[.11905 .29652 6 0 ]
[.30952 .29652 -6 -9 ]
[.30952 .29652 6 0 ]
[.69048 .29652 -3 -9 ]
[.69048 .29652 3 0 ]
[.88095 .29652 -3 -9 ]
[.88095 .29652 3 0 ]
[.4875 .0993 -12 -4.5 ]
[.4875 .0993 0 4.5 ]
[.4875 .20416 -24 -4.5 ]
[.4875 .20416 0 4.5 ]
[.4875 .41387 -18 -4.5 ]
[.4875 .41387 0 4.5 ]
[.4875 .51873 -6 -4.5 ]
[.4875 .51873 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .30902 m
.11905 .31527 L
s
[(-4)] .11905 .29652 0 1 Mshowa
.30952 .30902 m
.30952 .31527 L
s
[(-2)] .30952 .29652 0 1 Mshowa
.69048 .30902 m
.69048 .31527 L
s
[(2)] .69048 .29652 0 1 Mshowa
.88095 .30902 m
.88095 .31527 L
s
[(4)] .88095 .29652 0 1 Mshowa
.125 Mabswid
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.07143 .30902 m
.07143 .31277 L
s
.02381 .30902 m
.02381 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.97619 .30902 m
.97619 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .0993 m
.50625 .0993 L
s
[(-1)] .4875 .0993 1 0 Mshowa
.5 .20416 m
.50625 .20416 L
s
[(-0.5)] .4875 .20416 1 0 Mshowa
.5 .41387 m
.50625 .41387 L
s
[(0.5)] .4875 .41387 1 0 Mshowa
.5 .51873 m
.50625 .51873 L
s
[(1)] .4875 .51873 1 0 Mshowa
.125 Mabswid
.5 .12027 m
.50375 .12027 L
s
.5 .14124 m
.50375 .14124 L
s
.5 .16222 m
.50375 .16222 L
s
.5 .18319 m
.50375 .18319 L
s
.5 .22513 m
.50375 .22513 L
s
.5 .2461 m
.50375 .2461 L
s
.5 .26707 m
.50375 .26707 L
s
.5 .28805 m
.50375 .28805 L
s
.5 .32999 m
.50375 .32999 L
s
.5 .35096 m
.50375 .35096 L
s
.5 .37193 m
.50375 .37193 L
s
.5 .3929 m
.50375 .3929 L
s
.5 .43485 m
.50375 .43485 L
s
.5 .45582 m
.50375 .45582 L
s
.5 .47679 m
.50375 .47679 L
s
.5 .49776 m
.50375 .49776 L
s
.5 .07833 m
.50375 .07833 L
s
.5 .05736 m
.50375 .05736 L
s
.5 .03639 m
.50375 .03639 L
s
.5 .01542 m
.50375 .01542 L
s
.5 .5397 m
.50375 .5397 L
s
.5 .56068 m
.50375 .56068 L
s
.5 .58165 m
.50375 .58165 L
s
.5 .60262 m
.50375 .60262 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .5 0 r
.5 Mabswid
.02381 .27811 m
.04262 .18961 L
.06244 .11048 L
.07216 .07936 L
.08255 .05251 L
.08852 .04024 L
.09396 .03114 L
.09942 .02399 L
.10208 .02124 L
.10458 .01909 L
.10699 .01743 L
.10919 .01625 L
.11045 .01573 L
.11164 .01533 L
.1129 .01502 L
.11361 .01489 L
.11428 .0148 L
.11492 .01475 L
.11562 .01472 L
.11688 .01475 L
.11812 .01488 L
.11925 .0151 L
.12048 .01543 L
.12183 .01591 L
.12455 .01727 L
.12696 .01889 L
.12916 .02072 L
.13409 .02601 L
.13866 .03238 L
.14299 .03972 L
.15265 .06053 L
.1629 .08918 L
.18132 .156 L
.19092 .19734 L
.20102 .24431 L
.20964 .28617 L
.212 .29778 L
.2133 .30417 L
.21453 .30783 L
.21567 .3022 L
.21691 .2961 L
.21907 .28547 L
.23842 .1939 L
.25928 .11025 L
.26955 .07758 L
.27915 .05289 L
.28917 .03354 L
.29449 .026 L
.29725 .02283 L
.3002 .02003 L
Mistroke
.30295 .01794 L
.30545 .01649 L
.30666 .01595 L
.30796 .01547 L
.3092 .01513 L
.31033 .0149 L
.31097 .01481 L
.31165 .01475 L
.31289 .01472 L
.31365 .01475 L
.31436 .01481 L
.315 .0149 L
.3157 .01503 L
.31713 .01539 L
.31865 .01594 L
.32137 .0173 L
.32375 .01891 L
.32631 .02107 L
.33093 .0261 L
.33643 .03397 L
.34147 .04296 L
.3513 .0653 L
.36043 .09157 L
.38115 .16876 L
.42025 .35407 L
.4402 .44604 L
.4507 .48837 L
.4618 .52686 L
.47173 .5551 L
.47699 .56753 L
.48264 .57885 L
.48783 .58739 L
.49256 .59359 L
.49484 .59604 L
.49732 .5983 L
.49967 .60006 L
.50183 .60134 L
.50416 .60237 L
.50538 .60276 L
.50667 .60306 L
.50779 .60323 L
.50884 .60331 L
.50999 .60331 L
.51121 .60321 L
.51191 .60311 L
.51255 .60299 L
.51401 .60261 L
.51529 .60215 L
.51664 .60154 L
.51899 .6002 L
Mistroke
.52158 .59828 L
.52681 .59302 L
.53243 .5853 L
.54258 .56598 L
.55269 .54007 L
.56373 .50462 L
.58382 .42351 L
.62449 .22818 L
.6433 .14582 L
.66364 .07598 L
.6748 .04825 L
.6797 .03865 L
.68507 .02996 L
.69014 .02352 L
.69488 .0191 L
.6975 .01731 L
.69988 .01608 L
.7012 .01557 L
.7019 .01535 L
.70264 .01515 L
.70328 .01501 L
.70399 .01488 L
.70524 .01475 L
.70646 .01472 L
.70759 .01478 L
.70884 .01495 L
.70953 .01509 L
.71016 .01525 L
.71144 .01565 L
.71283 .01621 L
.71534 .01757 L
.71769 .01922 L
.72016 .02137 L
.7246 .02627 L
.72974 .0336 L
.73454 .04205 L
.74546 .06694 L
.75588 .09772 L
.76577 .13279 L
.78431 .21139 L
.82257 .39602 L
.84395 .48729 L
.86329 .54998 L
.87301 .57276 L
.87811 .58225 L
.8835 .59037 L
.88822 .59589 L
.89072 .59819 L
.8934 .60019 L
.89586 .60159 L
Mistroke
.89811 .60251 L
.89919 .60283 L
.90036 .60309 L
.90147 .60324 L
.90249 .60331 L
.90374 .6033 L
.90492 .60319 L
.90599 .60301 L
.90715 .60272 L
.9084 .60231 L
.90974 .60175 L
.91216 .60044 L
.9146 .5987 L
.9169 .59669 L
.92121 .59196 L
.92637 .58465 L
.93111 .57635 L
.94183 .55214 L
.95821 .50126 L
.97619 .42871 L
Mfstroke
0 0 1 r
[ .05 ] 0 setdash
.02381 .33993 m
.04262 .42842 L
.06244 .50755 L
.07216 .53867 L
.08255 .56553 L
.08852 .57779 L
.09396 .58689 L
.09942 .59404 L
.10208 .5968 L
.10458 .59894 L
.10699 .60061 L
.10919 .60178 L
.11045 .6023 L
.11164 .6027 L
.1129 .60301 L
.11361 .60314 L
.11428 .60323 L
.11492 .60329 L
.11562 .60332 L
.11688 .60329 L
.11812 .60315 L
.11925 .60294 L
.12048 .6026 L
.12183 .60212 L
.12455 .60076 L
.12696 .59914 L
.12916 .59732 L
.13409 .59203 L
.13866 .58565 L
.14299 .57832 L
.15265 .55751 L
.1629 .52886 L
.18132 .46203 L
.19092 .4207 L
.20102 .37372 L
.20964 .33186 L
.212 .32025 L
.2133 .31386 L
.21453 .31021 L
.21567 .31584 L
.21691 .32193 L
.21907 .33256 L
.23842 .42413 L
.25928 .50778 L
.26955 .54046 L
.27915 .56515 L
.28917 .58449 L
.29449 .59203 L
.29725 .5952 L
.3002 .598 L
Mistroke
.30295 .60009 L
.30545 .60154 L
.30666 .60209 L
.30796 .60256 L
.3092 .60291 L
.31033 .60313 L
.31097 .60322 L
.31165 .60329 L
.31289 .60332 L
.31365 .60329 L
.31436 .60322 L
.315 .60313 L
.3157 .60301 L
.31713 .60264 L
.31865 .6021 L
.32137 .60073 L
.32375 .59913 L
.32631 .59697 L
.33093 .59193 L
.33643 .58406 L
.34147 .57508 L
.3513 .55273 L
.36043 .52646 L
.38115 .44927 L
.42025 .26396 L
.4402 .172 L
.4507 .12967 L
.4618 .09118 L
.47173 .06294 L
.47699 .0505 L
.48264 .03918 L
.48783 .03065 L
.49256 .02444 L
.49484 .02199 L
.49732 .01973 L
.49967 .01797 L
.50183 .01669 L
.50416 .01567 L
.50538 .01528 L
.50667 .01498 L
.50779 .01481 L
.50884 .01473 L
.50999 .01472 L
.51121 .01482 L
.51191 .01492 L
.51255 .01505 L
.51401 .01543 L
.51529 .01588 L
.51664 .01649 L
.51899 .01784 L
Mistroke
.52158 .01975 L
.52681 .02502 L
.53243 .03274 L
.54258 .05205 L
.55269 .07796 L
.56373 .11342 L
.58382 .19452 L
.62449 .38985 L
.6433 .47222 L
.66364 .54206 L
.6748 .56978 L
.6797 .57938 L
.68507 .58808 L
.69014 .59451 L
.69488 .59894 L
.6975 .60073 L
.69988 .60195 L
.7012 .60246 L
.7019 .60269 L
.70264 .60288 L
.70328 .60303 L
.70399 .60315 L
.70524 .60329 L
.70646 .60332 L
.70759 .60325 L
.70884 .60308 L
.70953 .60294 L
.71016 .60278 L
.71144 .60238 L
.71283 .60182 L
.71534 .60046 L
.71769 .59882 L
.72016 .59666 L
.7246 .59176 L
.72974 .58443 L
.73454 .57598 L
.74546 .55109 L
.75588 .52032 L
.76577 .48524 L
.78431 .40664 L
.82257 .22201 L
.84395 .13074 L
.86329 .06805 L
.87301 .04527 L
.87811 .03578 L
.8835 .02766 L
.88822 .02215 L
.89072 .01984 L
.8934 .01785 L
.89586 .01644 L
Mistroke
.89811 .01552 L
.89919 .0152 L
.90036 .01495 L
.90147 .01479 L
.90249 .01472 L
.90374 .01473 L
.90492 .01484 L
.90599 .01502 L
.90715 .01531 L
.9084 .01572 L
.90974 .01628 L
.91216 .0176 L
.9146 .01933 L
.9169 .02134 L
.92121 .02607 L
.92637 .03338 L
.93111 .04168 L
.94183 .06589 L
.95821 .11677 L
.97619 .18932 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oS`3oool0
0`000000oooo0?ooo`2>0?ooo`00S`3oool00`000000oooo0?ooo`2>0?ooo`00S`3oool00`000000
oooo0?ooo`2>0?ooo`00S`3oool00`000000oooo0?ooo`2>0?ooo`007`3oool50?mo03<0oooo1@3o
O`0c0?ooo`03000000000?l0003o00<0003o<`3oool50?mo03<0oooo1@000?lK0?ooo`007P3oool0
0`3oO`00oooo0?ooo`030?ooo`80ogl0<03oool20?mo00@0oooo0P3oO`0`0?ooo`80003o103oool2
0000oc40oooo0P3oO`040?ooo`030?mo003oool0oooo03D0oooo0P000?lI0?ooo`00703oool20?mo
00L0oooo00<0ogl00?ooo`3oool0;@3oool00`3oO`00oooo0?ooo`050?ooo`030?mo003oool0oooo
02l0oooo00<000000?ooo`3oool0103oool00`000?l0oooo0?ooo`0/0?ooo`80ogl01`3oool00`3o
O`00oooo0?ooo`0e0?ooo`030000o`3oool0oooo01L0oooo000K0?ooo`030?mo003oool0oooo00P0
oooo00<0ogl00?ooo`3oool0:`3oool00`3oO`00oooo0?ooo`070?ooo`80ogl0;`3oool00`000000
oooo0?ooo`050?ooo`030000o`3oool0oooo02X0oooo00<0ogl00?ooo`3oool0203oool00`3oO`00
oooo0?ooo`0e0?ooo`80003o5`3oool001/0oooo00<0ogl00?ooo`3oool02@3oool00`3oO`00oooo
0?ooo`0Y0?ooo`030?mo003oool0oooo00T0oooo00<0ogl00?ooo`3oool0;@3oool00`000000oooo
0?ooo`050?ooo`030000o`3oool0oooo02X0oooo00<0ogl00?ooo`3oool02@3oool00`3oO`00oooo
0?ooo`0e0?ooo`030000o`3oool0oooo01D0oooo000J0?ooo`030?mo003oool0oooo00/0oooo00<0
ogl00?ooo`3oool0:03oool00`3oO`00oooo0?ooo`0:0?ooo`030?mo003oool0oooo02`0oooo00<0
00000?ooo`3oool01P3oool00`000?l0oooo0?ooo`0X0?ooo`030?mo003oool0oooo00/0oooo00<0
ogl00?ooo`3oool0:03oool00`000?l0oooo0?ooo`0Q0?ooo`006P3oool00`3oO`00oooo0?ooo`0;
0?ooo`030?mo003oool0oooo02L0oooo00<0ogl00?ooo`3oool0303oool00`3oO`00oooo0?ooo`0[
0?ooo`800000203oool00`000?l0oooo0?ooo`0W0?ooo`030?mo003oool0oooo00/0oooo00<0ogl0
0?ooo`3oool09`3oool00`000?l0oooo0?ooo`0R0?ooo`006@3oool00`3oO`00oooo0?ooo`0=0?oo
o`030?mo003oool0oooo02H0oooo00<0ogl00?ooo`3oool0303oool00`3oO`00oooo0?ooo`0[0?oo
o`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool09P3oool00`3oO`00oooo0?ooo`0=0?oo
o`030?mo003oool0oooo02H0oooo00<0003o0?ooo`3oool08P3oool001P0oooo00<0ogl00?ooo`3o
ool03P3oool00`3oO`00oooo0?ooo`0U0?ooo`030?mo003oool0oooo00h0oooo00<0ogl00?ooo`3o
ool0:P3oool00`000000oooo0?ooo`080?ooo`030000o`3oool0oooo02@0oooo00<0ogl00?ooo`3o
ool03P3oool00`3oO`00oooo0?ooo`0U0?ooo`030000o`3oool0oooo02<0oooo000H0?ooo`030?mo
003oool0oooo00l0oooo00<0ogl00?ooo`3oool0903oool00`3oO`00oooo0?ooo`0>0?ooo`030?mo
003oool0oooo02X0oooo00<000000?ooo`3oool0;`3oool00`3oO`00oooo0?ooo`0>0?ooo`030?mo
003oool0oooo02D0oooo00<0003o0?ooo`3oool08`3oool001L0oooo00<0ogl00?ooo`3oool0403o
ool00`3oO`00oooo0?ooo`0S0?ooo`030?mo003oool0oooo0100oooo00<0ogl00?ooo`3oool0:@3o
ool00`000000oooo0?ooo`0_0?ooo`030?mo003oool0oooo00l0oooo00<0ogl00?ooo`3oool08`3o
ool00`000?l0oooo0?ooo`0T0?ooo`005`3oool00`3oO`00oooo0?ooo`0A0?ooo`030?mo003oool0
oooo0280oooo00<0ogl00?ooo`3oool0403oool00`3oO`00oooo0?ooo`0Y0?ooo`030000003oool0
oooo02h0oooo00<0ogl00?ooo`3oool0403oool00`3oO`00oooo0?ooo`0S0?ooo`030000o`3oool0
oooo02@0oooo000G0?ooo`030?mo003oool0oooo0140oooo00<0ogl00?ooo`3oool08P3oool00`3o
O`00oooo0?ooo`0@0?ooo`030?mo003oool0oooo02T0oooo0P00000_0?ooo`030?mo003oool0oooo
0140oooo00<0ogl00?ooo`3oool08@3oool00`000?l0oooo0?ooo`0U0?ooo`005P3oool00`3oO`00
oooo0?ooo`0C0?ooo`030?mo003oool0oooo0200oooo00<0ogl00?ooo`3oool04P3oool00`3oO`00
oooo0?ooo`0X0?ooo`030000003oool0oooo02d0oooo00<0ogl00?ooo`3oool04P3oool00`3oO`00
oooo0?ooo`0Q0?ooo`030000o`3oool0oooo02D0oooo000F0?ooo`030?mo003oool0oooo01<0oooo
00<0ogl00?ooo`3oool0803oool00`3oO`00oooo0?ooo`0B0?ooo`030?mo003oool0oooo0200oooo
00<0003o0?ooo`3oool01@3oool00`000000oooo0?ooo`0]0?ooo`030?mo003oool0oooo01<0oooo
00<0ogl00?ooo`3oool07`3oool00`000?l0oooo0?ooo`0V0?ooo`005P3oool00`3oO`00oooo0?oo
o`0C0?ooo`030?mo003oool0oooo01l0oooo00<0ogl00?ooo`3oool04`3oool00`3oO`00oooo0?oo
o`0P0?ooo`030000o`3oool0oooo00D0oooo00<000000?ooo`3oool0;@3oool00`3oO`00oooo0?oo
o`0C0?ooo`030?mo003oool0oooo01l0oooo00<0003o0?ooo`3oool09P3oool001H0oooo00<0ogl0
0?ooo`3oool0503oool00`3oO`00oooo0?ooo`0N0?ooo`030?mo003oool0oooo01@0oooo00<0ogl0
0?ooo`3oool07P3oool00`000?l0oooo0?ooo`060?ooo`030000003oool0oooo02`0oooo00<0ogl0
0?ooo`3oool0503oool00`3oO`00oooo0?ooo`0O0?ooo`030000o`3oool0oooo01@0oooo00<0003o
0?ooo`3oool03`3oool001D0oooo00<0ogl00?ooo`3oool05@3oool00`3oO`00oooo0?ooo`0M0?oo
o`030?mo003oool0oooo01D0oooo00<0ogl00?ooo`3oool07P3oool00`000?l0oooo0?ooo`060?oo
o`030000003oool0oooo02`0oooo00<0ogl00?ooo`3oool05@3oool00`3oO`00oooo0?ooo`0M0?oo
o`030000o`3oool0oooo01D0oooo00<0003o0?ooo`3oool03`3oool001D0oooo00<0ogl00?ooo`3o
ool05@3oool00`3oO`00oooo0?ooo`0M0?ooo`030?mo003oool0oooo01D0oooo00<0ogl00?ooo`3o
ool07@3oool00`000?l0oooo0?ooo`070?ooo`800000;@3oool00`3oO`00oooo0?ooo`0E0?ooo`03
0?mo003oool0oooo01d0oooo00<0003o0?ooo`3oool05P3oool00`000?l0oooo0?ooo`0>0?ooo`00
5@3oool00`3oO`00oooo0?ooo`0E0?ooo`030?mo003oool0oooo01d0oooo00<0ogl00?ooo`3oool0
5P3oool00`3oO`00oooo0?ooo`0L0?ooo`030000o`3oool0oooo00L0oooo00<000000?ooo`3oool0
:`3oool00`3oO`00oooo0?ooo`0F0?ooo`030?mo003oool0oooo03H0oooo00<0003o0?ooo`3oool0
3P3oool001@0oooo00<0ogl00?ooo`3oool05`3oool00`3oO`00oooo0?ooo`0K0?ooo`030?mo003o
ool0oooo01L0oooo00<0ogl00?ooo`3oool0703oool00`000?l0oooo0?ooo`070?ooo`030000003o
ool0oooo02/0oooo00<0ogl00?ooo`3oool05`3oool00`3oO`00oooo0?ooo`0e0?ooo`030000o`3o
ool0oooo00h0oooo000D0?ooo`030?mo003oool0oooo01L0oooo00<0ogl00?ooo`3oool06`3oool0
0`3oO`00oooo0?ooo`0H0?ooo`030?mo003oool0oooo01X0oooo00<0003o0?ooo`3oool0203oool0
0`000000oooo0?ooo`0=0?ooo`030000o`3oool0oooo01/0oooo00<0ogl00?ooo`3oool05`3oool0
0`3oO`00oooo0?ooo`0f0?ooo`030000o`3oool0oooo00d0oooo000D0?ooo`030?mo003oool0oooo
01L0oooo00<0ogl00?ooo`3oool06`3oool00`3oO`00oooo0?ooo`0H0?ooo`030?mo003oool0oooo
01X0oooo00<0003o0?ooo`000000100000040?ooo`030000003oool0oooo00d0oooo00<0003o0?oo
o`3oool06P3oool00`3oO`00oooo0?ooo`0H0?ooo`030?mo003oool0oooo03H0oooo00<0003o0?oo
o`3oool03@3oool001<0oooo00<0ogl00?ooo`3oool06@3oool00`3oO`00oooo0?ooo`0I0?ooo`03
0?mo003oool0oooo01T0oooo00<0ogl00?ooo`3oool06P3oool01@000?l0oooo0?ooo`3oool00000
00H0oooo00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`0I0?ooo`030?mo003oool0oooo
01T0oooo00<0ogl00?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0=0?ooo`004`3oool00`3oO`00
oooo0?ooo`0I0?ooo`030?mo003oool0oooo01T0oooo00<0ogl00?ooo`3oool06P3oool00`3oO`00
oooo0?ooo`0H0?ooo`030000o`3oool0oooo0080oooo00<000000?ooo`3oool0103oool3000000h0
oooo00<0003o0?ooo`3oool06@3oool00`3oO`00oooo0?ooo`0I0?ooo`030?mo003oool0oooo03D0
oooo00<0003o0?ooo`3oool03@3oool001<0oooo00<0ogl00?ooo`3oool06@3oool00`3oO`00oooo
0?ooo`0I0?ooo`030?mo003oool0oooo01X0oooo00<0ogl00?ooo`3oool05@3oool3000000030000
o`3oool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0>0?ooo`030000
o`3oool0oooo01T0oooo00<0ogl00?ooo`3oool06@3oool00`3oO`00oooo0?ooo`0f0?ooo`030000
o`3oool0oooo00`0oooo000B0?ooo`030?mo003oool0oooo01/0oooo00<0ogl00?ooo`3oool05`3o
ool00`3oO`00oooo0?ooo`0K0?ooo`030?mo003oool0oooo01L0oooo00<0003o0?ooo`3oool00`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00h0oooo00<0003o0?ooo`3oool0603o
ool00`3oO`00oooo0?ooo`0K0?ooo`030?mo003oool0oooo03D0oooo00<0003o0?ooo`3oool0303o
ool00180oooo00<0ogl00?ooo`3oool06`3oool00`3oO`00oooo0?ooo`0G0?ooo`030?mo003oool0
oooo01/0oooo00<0ogl00?ooo`3oool05`3oool00`000?l0oooo0?ooo`020?ooo`8000001P3oool0
0`000000oooo0?ooo`0?0?ooo`030000o`3oool0oooo01L0oooo00<0ogl00?ooo`3oool06`3oool0
0`3oO`00oooo0?ooo`0e0?ooo`030000o`3oool0oooo00`0oooo000B0?ooo`030?mo003oool0oooo
01/0oooo00<0ogl00?ooo`3oool05`3oool00`3oO`00oooo0?ooo`0L0?ooo`030?mo003oool0oooo
02<0oooo00<000000?ooo`3oool03`3oool00`000?l0oooo0?ooo`0G0?ooo`030?mo003oool0oooo
01/0oooo00<0ogl00?ooo`3oool0=P3oool00`000?l0oooo0?ooo`0;0?ooo`004@3oool00`3oO`00
oooo0?ooo`0M0?ooo`030?mo003oool0oooo01D0oooo00<0ogl00?ooo`3oool07@3oool00`3oO`00
oooo0?ooo`0S0?ooo`030000003oool0oooo00l0oooo00<0003o0?ooo`3oool05P3oool00`3oO`00
oooo0?ooo`0L0?ooo`030?mo003oool0oooo03H0oooo00<0003o0?ooo`3oool02`3oool00140oooo
00<0ogl00?ooo`3oool07@3oool00`3oO`00oooo0?ooo`0E0?ooo`030?mo003oool0oooo01d0oooo
00<0ogl00?ooo`3oool08`3oool200000140oooo00<0003o0?ooo`3oool05@3oool00`3oO`00oooo
0?ooo`0M0?ooo`030?mo003oool0oooo03D0oooo00<0003o0?ooo`3oool02`3oool00140oooo00<0
ogl00?ooo`3oool07@3oool00`3oO`00oooo0?ooo`0E0?ooo`030?mo003oool0oooo01d0oooo00<0
ogl00?ooo`3oool08`3oool00`000000oooo0?ooo`0@0?ooo`030000o`3oool0oooo01D0oooo00<0
ogl00?ooo`3oool07@3oool00`3oO`00oooo0?ooo`0E0?ooo`030000o`3oool0oooo02/0oooo000A
0?ooo`030?mo003oool0oooo01d0oooo00<0ogl00?ooo`3oool05@3oool00`3oO`00oooo0?ooo`0N
0?ooo`030?mo003oool0oooo0280oooo00<000000?ooo`3oool0403oool00`000?l0oooo0?ooo`0D
0?ooo`030?mo003oool0oooo01h0oooo00<0ogl00?ooo`3oool0503oool00`000?l0oooo0?ooo`0/
0?ooo`00403oool00`3oO`00oooo0?ooo`0O0?ooo`030?mo003oool0oooo01<0oooo00<0ogl00?oo
o`3oool07`3oool00`3oO`00oooo0?ooo`0R0?ooo`030000003oool0oooo0100oooo00<0003o0?oo
o`3oool0503oool00`3oO`00oooo0?ooo`0O0?ooo`030?mo003oool0oooo01<0oooo00<0003o0?oo
o`3oool0;03oool00100oooo00<0ogl00?ooo`3oool07`3oool00`3oO`00oooo0?ooo`0C0?ooo`03
0?mo003oool0oooo01l0oooo00<0ogl00?ooo`3oool08P3oool00`000000oooo0?ooo`0A0?ooo`03
0000o`3oool0oooo01<0oooo00<0ogl00?ooo`3oool07`3oool00`3oO`00oooo0?ooo`0C0?ooo`03
0000o`3oool0oooo02`0oooo000@0?ooo`030?mo003oool0oooo01l0oooo00<0ogl00?ooo`3oool0
4`3oool00`3oO`00oooo0?ooo`0P0?ooo`030?mo003oool0oooo0240oooo00<000000?ooo`3oool0
4@3oool00`000?l0oooo0?ooo`0C0?ooo`030?mo003oool0oooo01l0oooo00<0ogl00?ooo`3oool0
4`3oool00`000?l0oooo0?ooo`0/0?ooo`00403oool00`3oO`00oooo0?ooo`0P0?ooo`030?mo003o
ool0oooo0180oooo00<0ogl00?ooo`3oool0803oool00`3oO`00oooo0?ooo`0Q0?ooo`8000009`3o
ool00`3oO`00oooo0?ooo`0P0?ooo`030?mo003oool0oooo0180oooo00<0003o0?ooo`3oool0;@3o
ool000l0oooo00<0ogl00?ooo`3oool08@3oool00`3oO`00oooo0?ooo`0A0?ooo`030?mo003oool0
oooo0240oooo00<0ogl00?ooo`3oool08@3oool00`000000oooo0?ooo`0V0?ooo`030?mo003oool0
oooo0240oooo00<0ogl00?ooo`3oool04@3oool00`000?l0oooo0?ooo`0]0?ooo`003`3oool00`3o
O`00oooo0?ooo`0Q0?ooo`030?mo003oool0oooo0140oooo00<0ogl00?ooo`3oool08@3oool00`3o
O`00oooo0?ooo`0Q0?ooo`030000003oool0oooo02H0oooo00<0ogl00?ooo`3oool08@3oool00`3o
O`00oooo0?ooo`0A0?ooo`030000o`3oool0oooo02d0oooo000?0?ooo`030?mo003oool0oooo0280
oooo00<0ogl00?ooo`3oool0403oool00`3oO`00oooo0?ooo`0R0?ooo`030?mo003oool0oooo0200
oooo00<000000?ooo`3oool09P3oool00`3oO`00oooo0?ooo`0Q0?ooo`030?mo003oool0oooo0140
oooo00<0003o0?ooo`3oool0;@3oool000l0oooo00<0ogl00?ooo`3oool08P3oool00`3oO`00oooo
0?ooo`0@0?ooo`030?mo003oool0oooo0280oooo00<0ogl00?ooo`3oool0803oool00`000000oooo
0?ooo`0U0?ooo`030?mo003oool0oooo0280oooo00<0ogl00?ooo`3oool04@3oool00`000?l0oooo
0?ooo`0]0?ooo`003P3oool00`3oO`00oooo0?ooo`0S0?ooo`030?mo003oool0oooo00l0oooo00<0
ogl00?ooo`3oool08`3oool00`3oO`00oooo0?ooo`0@0?ooo`030000o`3oool0oooo00d0oooo00<0
00000?ooo`3oool09@3oool00`3oO`00oooo0?ooo`0S0?ooo`030?mo003oool0oooo0100oooo00<0
003o0?ooo`3oool0;@3oool000h0oooo00<0ogl00?ooo`3oool08`3oool00`3oO`00oooo0?ooo`0?
0?ooo`030?mo003oool0oooo02<0oooo00<0ogl00?ooo`3oool0403oool00`000?l0oooo0?ooo`0=
0?ooo`8000009P3oool00`3oO`00oooo0?ooo`0S0?ooo`030?mo003oool0oooo00l0oooo00<0003o
0?ooo`3oool0;P3oool000h0oooo00<0ogl00?ooo`3oool0903oool00`3oO`00oooo0?ooo`0>0?oo
o`030?mo003oool0oooo02@0oooo00<0ogl00?ooo`3oool03P3oool00`000?l0oooo0?ooo`0>0?oo
o`030000003oool0oooo02D0oooo00<0ogl00?ooo`3oool08`3oool00`3oO`00oooo0?ooo`0?0?oo
o`030000o`3oool0oooo02h0oooo000>0?ooo`030?mo003oool0oooo02@0oooo00<0ogl00?ooo`3o
ool03P3oool00`3oO`00oooo0?ooo`0T0?ooo`030?mo003oool0oooo00h0oooo00<0003o0?ooo`3o
ool03P3oool00`000000oooo0?ooo`0U0?ooo`030?mo003oool0oooo02<0oooo00<0ogl00?ooo`3o
ool03`3oool00`000?l0oooo0?ooo`0T0?ooo`030000o`3oool0oooo00L0oooo000=0?ooo`030?mo
003oool0oooo02D0oooo00<0ogl00?ooo`3oool03@3oool00`3oO`00oooo0?ooo`0U0?ooo`030?mo
003oool0oooo00h0oooo00<0003o0?ooo`3oool03P3oool00`000000oooo0?ooo`0T0?ooo`030?mo
003oool0oooo02@0oooo00<0ogl00?ooo`3oool03`3oool00`000?l0oooo0?ooo`0T0?ooo`030000
o`3oool0oooo00L0oooo000=0?ooo`030?mo003oool0oooo02D0oooo00<0ogl00?ooo`3oool03@3o
ool00`3oO`00oooo0?ooo`0U0?ooo`030?mo003oool0oooo00h0oooo00<0003o0?ooo`3oool03P3o
ool00`000000oooo0?ooo`0T0?ooo`030?mo003oool0oooo02D0oooo00<0ogl00?ooo`3oool0=@3o
ool00`000?l0oooo0?ooo`070?ooo`003@3oool00`3oO`00oooo0?ooo`0V0?ooo`030?mo003oool0
oooo00`0oooo00<0ogl00?ooo`3oool09P3oool00`3oO`00oooo0?ooo`0=0?ooo`030000o`3oool0
oooo00h0oooo00<000000?ooo`3oool0903oool00`3oO`00oooo0?ooo`0U0?ooo`030?mo003oool0
oooo03D0oooo00<0003o0?ooo`3oool01`3oool000d0oooo00<0ogl00?ooo`3oool09P3oool00`3o
O`00oooo0?ooo`0<0?ooo`030?mo003oool0oooo02H0oooo00<0ogl00?ooo`3oool0303oool00`00
0?l0oooo0?ooo`0?0?ooo`8000009@3oool00`3oO`00oooo0?ooo`0U0?ooo`030?mo003oool0oooo
03H0oooo00<0003o0?ooo`3oool01P3oool000`0oooo00<0ogl00?ooo`3oool09`3oool00`3oO`00
oooo0?ooo`0;0?ooo`030?mo003oool0oooo02L0oooo00<0ogl00?ooo`3oool0303oool00`000?l0
oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<0003o0?ooo`3oool0303oool00`3oO`00
oooo0?ooo`0V0?ooo`030?mo003oool0oooo03H0oooo00<0003o0?ooo`3oool01P3oool000`0oooo
00<0ogl00?ooo`3oool09`3oool00`3oO`00oooo0?ooo`0;0?ooo`030?mo003oool0oooo02L0oooo
00<0ogl00?ooo`3oool0303oool00`000?l0oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo
00<0003o0?ooo`3oool0303oool00`3oO`00oooo0?ooo`0W0?ooo`030?mo003oool0oooo03D0oooo
00<0003o0?ooo`3oool01P3oool000`0oooo00<0ogl00?ooo`3oool0:03oool00`3oO`00oooo0?oo
o`0:0?ooo`030?mo003oool0oooo02L0oooo00<0ogl00?ooo`3oool0303oool00`000?l0oooo0?oo
o`0?0?ooo`030000003oool0oooo01D0oooo00<0003o0?ooo`3oool02`3oool00`3oO`00oooo0?oo
o`0W0?ooo`030?mo003oool0oooo03h0oooo000<0?ooo`030?mo003oool0oooo02P0oooo00<0ogl0
0?ooo`3oool02P3oool00`3oO`00oooo0?ooo`0X0?ooo`030?mo003oool0oooo00T0oooo0P000000
10000?l0oooo0?ooo`3oool2000000@0oooo0P0000060?ooo`030000003oool0oooo01D0oooo00<0
003o0?ooo`3oool02`3oool00`3oO`00oooo0?ooo`0W0?ooo`030?mo003oool0oooo03h0oooo000;
0?ooo`030?mo003oool0oooo02T0oooo00<0ogl00?ooo`3oool02P3oool00`3oO`00oooo0?ooo`0X
0?ooo`030?mo003oool0oooo00P0oooo00@000000?ooo`000?l00000203oool010000000oooo0?oo
o`0000050?ooo`030000003oool0oooo01D0oooo00<0003o0?ooo`3oool02`3oool00`3oO`00oooo
0?ooo`0W0?ooo`030?mo003oool0oooo03h0oooo000;0?ooo`030?mo003oool0oooo02T0oooo00<0
ogl00?ooo`3oool02@3oool00`3oO`00oooo0?ooo`0Y0?ooo`030?mo003oool0oooo00P0oooo00@0
00000?ooo`000?l000002`3oool00`000000oooo0?ooo`030?ooo`<000005@3oool00`000?l0oooo
0?ooo`0:0?ooo`030?mo003oool0oooo02T0oooo00<0ogl00?ooo`3oool0?@3oool000/0oooo00<0
ogl00?ooo`3oool0:@3oool00`3oO`00oooo0?ooo`090?ooo`030?mo003oool0oooo02T0oooo00<0
ogl00?ooo`3oool00P3oool400000080oooo00@000000?ooo`000?l000002@3oool2000000H0oooo
00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`090?ooo`030?mo003oool0oooo02T0oooo
00<0ogl00?ooo`3oool0?@3oool000/0oooo00<0ogl00?ooo`3oool0:P3oool00`3oO`00oooo0?oo
o`080?ooo`030?mo003oool0oooo02T0oooo00<0ogl00?ooo`3oool0203oool010000000oooo0?oo
o`0000090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05P3oool00`000?l0oooo
0?ooo`090?ooo`030?mo003oool0oooo02T0oooo00<0ogl00?ooo`3oool0?@3oool000/0oooo00<0
ogl00?ooo`3oool0:P3oool00`3oO`00oooo0?ooo`080?ooo`030?mo003oool0oooo02X0oooo00<0
ogl00?ooo`3oool0203oool2000000X0oooo0`0000050?ooo`030000003oool0oooo01H0oooo00<0
003o0?ooo`3oool02@3oool00`3oO`00oooo0?ooo`0Y0?ooo`030?mo003oool0oooo03d0oooo000:
0?ooo`030?mo003oool0oooo02/0oooo00<0ogl00?ooo`3oool0203oool00`3oO`00oooo0?ooo`0Z
0?ooo`030?mo003oool0oooo01`0oooo00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`09
0?ooo`030?mo003oool0oooo02T0oooo00<0ogl00?ooo`3oool0?@3oool000X0oooo00<0ogl00?oo
o`3oool0:`3oool00`3oO`00oooo0?ooo`070?ooo`030?mo003oool0oooo02/0oooo00<0ogl00?oo
o`3oool0703oool00`000000oooo0?ooo`0F0?ooo`030000o`3oool0oooo00P0oooo00<0ogl00?oo
o`3oool0:`3oool00`3oO`00oooo0?ooo`070?ooo`030000o`3oool0oooo0380oooo000:0?ooo`03
0?mo003oool0oooo02/0oooo00<0ogl00?ooo`3oool01`3oool00`3oO`00oooo0?ooo`0[0?ooo`03
0?mo003oool0oooo01`0oooo0P00000G0?ooo`030000o`3oool0oooo00P0oooo00<0ogl00?ooo`3o
ool0:`3oool00`3oO`00oooo0?ooo`070?ooo`030000o`3oool0oooo0380oooo000:0?ooo`030?mo
003oool0oooo02/0oooo00<0ogl00?ooo`3oool01`3oool00`3oO`00oooo0?ooo`0/0?ooo`030?mo
003oool0oooo01/0oooo00<000000?ooo`3oool05`3oool00`000?l0oooo0?ooo`070?ooo`030?mo
003oool0oooo02/0oooo00<0ogl00?ooo`3oool01`3oool00`000?l0oooo0?ooo`0b0?ooo`002P3o
ool00`3oO`00oooo0?ooo`0[0?ooo`030?mo003oool0oooo00L0oooo00<0ogl00?ooo`3oool0;03o
ool00`3oO`00oooo0?ooo`0K0?ooo`030000003oool0oooo01L0oooo00<0003o0?ooo`3oool01`3o
ool00`3oO`00oooo0?ooo`0[0?ooo`030?mo003oool0oooo00H0oooo00<0003o0?ooo`3oool0<`3o
ool000T0oooo00<0ogl00?ooo`3oool0;@3oool00`3oO`00oooo0?ooo`060?ooo`030?mo003oool0
oooo02`0oooo00<0ogl00?ooo`3oool06`3oool00`000000oooo0?ooo`0G0?ooo`030000o`3oool0
oooo00L0oooo00<0ogl00?ooo`3oool0:`3oool00`3oO`00oooo0?ooo`060?ooo`030000o`3oool0
oooo03<0oooo00090?ooo`030?mo003oool0oooo02d0oooo00<0ogl00?ooo`3oool01@3oool00`3o
O`00oooo0?ooo`0]0?ooo`030?mo003oool0oooo01/0oooo00<000000?ooo`3oool0803oool00`3o
O`00oooo0?ooo`0]0?ooo`030?mo003oool0oooo00D0oooo00<0003o0?ooo`3oool0<`3oool000T0
oooo00<0ogl00?ooo`3oool0;@3oool00`3oO`00oooo0?ooo`050?ooo`030?mo003oool0oooo02d0
oooo00<0ogl00?ooo`3oool06`3oool00`000000oooo0?ooo`0P0?ooo`030?mo003oool0oooo02d0
oooo00<0ogl00?ooo`3oool01@3oool00`000?l0oooo0?ooo`0c0?ooo`002@3oool00`3oO`00oooo
0?ooo`0]0?ooo`030?mo003oool0oooo00D0oooo00<0ogl00?ooo`3oool0;P3oool00`3oO`00oooo
0?ooo`0J0?ooo`8000008@3oool00`3oO`00oooo0?ooo`0]0?ooo`030?mo003oool0oooo00@0oooo
00<0003o0?ooo`3oool0=03oool000T0oooo00<0ogl00?ooo`3oool0;@3oool00`3oO`00oooo0?oo
o`050?ooo`030?mo003oool0oooo02h0oooo00<0ogl00?ooo`3oool06P3oool00`000000oooo0?oo
o`0P0?ooo`030?mo003oool0oooo02d0oooo00<0ogl00?ooo`3oool0103oool00`000?l0oooo0?oo
o`0d0?ooo`00203oool00`3oO`00oooo0?ooo`0_0?ooo`030?mo003oool0oooo00@0oooo00<0ogl0
0?ooo`3oool0;P3oool00`3oO`00oooo0?ooo`0J0?ooo`030000003oool0oooo01l0oooo00<0ogl0
0?ooo`3oool0;P3oool00`3oO`00oooo0?ooo`040?ooo`030000o`3oool0oooo03@0oooo00080?oo
o`030?mo003oool0oooo02l0oooo00<0ogl00?ooo`3oool0103oool00`3oO`00oooo0?ooo`0^0?oo
o`030?mo003oool0oooo00@0oooo00<0003o0?ooo`3oool04`3oool00`000000oooo0?ooo`0O0?oo
o`030?mo003oool0oooo02l0oooo00<0ogl00?ooo`3oool00`3oool00`000?l0oooo0?ooo`0d0?oo
o`00203oool00`3oO`00oooo0?ooo`0_0?ooo`030?mo003oool0oooo00<0oooo00<0ogl00?ooo`3o
ool0;`3oool00`3oO`00oooo0?ooo`030?ooo`030000o`3oool0oooo01@0oooo00<000000?ooo`3o
ool07`3oool00`3oO`00oooo0?ooo`0_0?ooo`030?mo003oool0oooo00<0oooo00<0003o0?ooo`3o
ool0=03oool000P0oooo00<0ogl00?ooo`3oool0;`3oool00`3oO`00oooo0?ooo`030?ooo`030?mo
003oool0oooo0300oooo00<0ogl00?ooo`3oool00P3oool00`000?l0oooo0?ooo`0D0?ooo`030000
003oool0oooo01l0oooo00<0ogl00?ooo`3oool0;`3oool00`3oO`00oooo0?ooo`020?ooo`030000
o`3oool0oooo03D0oooo00080?ooo`030?mo003oool0oooo01X0oooo0`00000C0?ooo`030?mo003o
ool0oooo0080oooo00<0ogl00?ooo`3oool05P3oool4000001H0oooo00<0ogl00?ooo`3oool00P3o
ool00`000?l0oooo0?ooo`0D0?ooo`800000803oool00`3oO`00oooo0?ooo`0@0?ooo`@000006`3o
ool00`3oO`00oooo0?ooo`020?ooo`030000o`3oool0oooo0140oooo0`00000Q0?ooo`001`3oool0
0`3oO`00oooo0?ooo`0L0?ooo`030000003oool0oooo0180oooo00<0ogl00?ooo`3oool00P3oool0
0`3oO`00oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<0ogl00?ooo`3oool00P3oool0
0`000?l0oooo0?ooo`0D0?ooo`030000003oool0oooo01h0oooo00<0ogl00?ooo`3oool04@3oool0
0`000000oooo0?ooo`0M0?ooo`050?mo003oool0oooo0?ooo`000?l0503oool00`000000oooo0?oo
o`0P0?ooo`001`3oool00`3oO`00oooo0?ooo`0I0?ooo`D000004`3oool00`3oO`00oooo0?ooo`02
0?ooo`030?mo003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool01@3oO`00oooo0?ooo`3o
ool0003o01L0oooo00<000000?ooo`3oool07P3oool00`3oO`00oooo0?ooo`0B0?ooo`030000003o
ool0oooo01`0oooo00<0ogl00?ooo`3oool04`3oool500000240oooo00070?ooo`030?mo003oool0
oooo01<0oooo100000020?ooo`040000003oool0oooo000001@0oooo00D0ogl00?ooo`3oool0oooo
0?mo000C0?ooo`@00000103oool00`000000oooo0?ooo`0E0?ooo`050?mo003oool0oooo0?ooo`00
0?l05`3oool00`000000oooo0?ooo`0N0?ooo`030?mo003oool0oooo01<0oooo00<000000?ooo`3o
ool06`3oool00`3oO`00oooo0?ooo`0C0?ooo`040000003oool0oooo00000280oooo000T0?ooo`03
0000003oool0000001D0oooo00@0ogl00?ooo`3oool0ogl06@3oool010000000oooo0?ooo`00000G
0?ooo`040?mo003oool0oooo0000oaL0oooo00<000000?ooo`3oool07P3oool00`3oO`00oooo0?oo
o`0A0?ooo`040000003oool0oooo000001`0oooo00<0ogl00?ooo`3oool0503oool00`000000oooo
0000000R0?ooo`009@3oool2000001D0oooo00@0ogl00?ooo`3oool0ogl06P3oool2000001P0oooo
00@0ogl00?ooo`3oool0003o5`3oool00`000000oooo0?ooo`0J0?ooo`050000o`3oool0oooo0?oo
o`3oO`00503oool2000001d0oooo00<0ogl00?ooo`3oool05@3oool200000280oooo000l0?ooo`04
0?mo003oool0oooo0?mo03@0oooo00@0ogl00?ooo`3oool0003o5`3oool2000001/0oooo00@0003o
0?ooo`3oool0ogl0=@3oool00`3oO`00oooo0?ooo`0h0?ooo`00?03oool00`3oO`00oooo0?mo000e
0?ooo`040?mo003oool0oooo0000oaL0oooo00<000000?ooo`3oool06P3oool010000?l0oooo0?oo
o`3oO`0e0?ooo`030?mo003oool0oooo03P0oooo000m0?ooo`80ogl0=@3oool00`3oO`00oooo0000
o`0H0?ooo`030000003oool0oooo01/0oooo00<0003o0?ooo`3oO`00=@3oool00`3oO`00oooo0?oo
o`0h0?ooo`00?@3oool20?mo03H0oooo00<0ogl00000o`3oool05`3oool00`000000oooo0?ooo`0K
0?ooo`030000o`3oool0ogl003D0oooo00<0ogl00?ooo`3oool0>03oool003d0oooo0P3oO`0f0?oo
o`030?mo00000?l0oooo01L0oooo00<000000?ooo`3oool06`3oool00`000?l0ogl00?ooo`0e0?oo
o`030?mo003oool0oooo03P0oooo000m0?ooo`030?mo003oool0oooo03D0oooo00<0ogl00000o`3o
ool05`3oool00`000000oooo0?ooo`0K0?ooo`030000o`3oO`00oooo03H0oooo00<0ogl00?ooo`3o
ool0=`3oool003d0000000<0003o000000000000=@0000000`3oO`0000000000000e000000030000
o`3oO`00000003H0000000<0ogl0000000000000=P0000010?ooo`001`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0:0?ooo`030000o`3oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oO`002P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool01@000000oooo0?oo
o`3oool0003o00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`3oO`00oooo0?ooo`050?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00H0oooo000R0?ooo`030000003oool0oooo01P0oooo0P000?lI0?ooo`030000003o
ool0oooo01/0oooo00<0ogl00?ooo`3oool05P3oool00`000000oooo0?ooo`0L0?ooo`030000o`3o
ool0oooo01D0oooo00<000000?ooo`3oool07@3oool00`3oO`00oooo0?ooo`0C0?ooo`030000003o
ool0oooo0240oooo000m0?ooo`80003o=`3oool00`3oO`00oooo0?ooo`0F0?ooo`030000003oool0
oooo01/0oooo00<0ogl00000o`3oool0=@3oool00`000?l0ogl00?ooo`0h0?ooo`00?P3oool00`00
0?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo01H0oooo00<000000?ooo`3oool06`3oool00`3o
O`00003o0?ooo`0e0?ooo`030000o`3oool0ogl003P0oooo000n0?ooo`030000o`3oool0oooo03D0
oooo00<0ogl00?ooo`3oool05P3oool00`000000oooo0?ooo`0K0?ooo`030?mo003oool0003o03D0
oooo00<0003o0?ooo`3oO`00>03oool003l0oooo00<0003o0?ooo`3oool0=@3oool00`3oO`00oooo
0?ooo`0E0?ooo`800000703oool00`3oO`00oooo0000o`0e0?ooo`030000o`3oool0ogl003P0oooo
000o0?ooo`030000o`3oool0oooo03D0oooo00<0ogl00?ooo`3oool05@3oool00`000000oooo0?oo
o`0K0?ooo`030?mo003oool0003o03@0oooo00@0003o0?ooo`3oool0ogl0>03oool003l0oooo00<0
003o0?ooo`3oool0=@3oool00`3oO`00oooo0?ooo`0E0?ooo`030000003oool0oooo01X0oooo00<0
ogl00?ooo`3oool0=@3oool010000?l0oooo0?ooo`3oO`0h0?ooo`001`3oool00`000?l0oooo0?oo
o`0e0?ooo`030000o`3oool0oooo03D0oooo00<0ogl00?ooo`3oool05@3oool00`000000oooo0?oo
o`0J0?ooo`030?mo003oool0oooo03D0oooo00D0003o0?ooo`3oool0oooo0?mo000g0?ooo`001`3o
ool00`000?l0oooo0?ooo`0f0?ooo`030000o`3oool0oooo03@0oooo00<0ogl00?ooo`3oool05@3o
ool00`000000oooo0?ooo`0J0?ooo`030?mo003oool0oooo03D0oooo00D0003o0?ooo`3oool0oooo
0?mo000g0?ooo`001`3oool00`000?l0oooo0?ooo`0f0?ooo`030000o`3oool0oooo03D0oooo00<0
ogl00?ooo`3oool0503oool00`000000oooo0?ooo`0J0?ooo`030?mo003oool0oooo03D0oooo00D0
003o0?ooo`3oool0oooo0?mo000g0?ooo`001`3oool00`000?l0oooo0?ooo`0f0?ooo`030000o`3o
ool0oooo03D0oooo00<0ogl00?ooo`3oool0503oool2000001X0oooo00<0ogl00?ooo`3oool0=P3o
ool01@000?l0oooo0?ooo`3oool0ogl003L0oooo00080?ooo`030000o`3oool0oooo06P0oooo00<0
003o0?ooo`3oool00P3oool00`3oO`00oooo0?ooo`0D0?ooo`030000003oool0oooo01T0oooo00<0
ogl00?ooo`3oool0=P3oool00`000?l0oooo0?ooo`020?ooo`030?mo003oool0oooo03@0oooo0008
0?ooo`030000o`3oool0oooo06P0oooo00<0003o0?ooo`3oool00P3oool00`3oO`00oooo0?ooo`0D
0?ooo`030000003oool0oooo01T0oooo00<0ogl00?ooo`3oool0=@3oool00`000?l0oooo0?ooo`03
0?ooo`030?mo003oool0oooo03@0oooo00080?ooo`030000o`3oool0oooo06P0oooo00<0003o0?oo
o`3oool00P3oool00`3oO`00oooo0?ooo`0D0?ooo`030000003oool0oooo01T0oooo00<0ogl00?oo
o`3oool0=@3oool00`000?l0oooo0?ooo`030?ooo`030?mo003oool0oooo03@0oooo00080?ooo`03
0000o`3oool0oooo06L0oooo00<0003o0?ooo`3oool0103oool00`3oO`00oooo0?ooo`0C0?ooo`03
0000003oool0oooo01T0oooo00<0ogl00?ooo`3oool0=@3oool00`000?l0oooo0?ooo`030?ooo`03
0?mo003oool0oooo03@0oooo00080?ooo`030000o`3oool0oooo02l0oooo00<0003o0?ooo`3oool0
=@3oool00`000?l0oooo0?ooo`040?ooo`030?mo003oool0oooo01<0oooo00<000000?ooo`3oool0
603oool00`3oO`00oooo0?ooo`0f0?ooo`030000o`3oool0oooo00<0oooo00<0ogl00?ooo`3oool0
=03oool000P0oooo00<0003o0?ooo`3oool0;P3oool00`000?l0oooo0?ooo`0f0?ooo`030000o`3o
ool0oooo00@0oooo00<0ogl00?ooo`3oool04`3oool2000001T0oooo00<0ogl00?ooo`3oool0?@3o
ool00`3oO`00oooo0?ooo`0c0?ooo`002@3oool00`000?l0oooo0?ooo`0]0?ooo`030000o`3oool0
oooo03H0oooo00<0003o0?ooo`3oool0103oool00`3oO`00oooo0?ooo`0C0?ooo`030000003oool0
oooo01P0oooo00<0ogl00?ooo`3oool0?@3oool00`3oO`00oooo0?ooo`0c0?ooo`002@3oool00`00
0?l0oooo0?ooo`0]0?ooo`030000o`3oool0oooo03D0oooo00<0003o0?ooo`3oool01P3oool00`3o
O`00oooo0?ooo`0B0?ooo`030000003oool0oooo01P0oooo00<0ogl00?ooo`3oool0?@3oool00`3o
O`00oooo0?ooo`0c0?ooo`002@3oool00`000?l0oooo0?ooo`0]0?ooo`030000o`3oool0oooo03D0
oooo00<0003o0?ooo`3oool01P3oool00`3oO`00oooo0?ooo`0B0?ooo`030000003oool0oooo01P0
oooo00<0ogl00?ooo`3oool01@3oool00`000?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo03<0
oooo000h0?ooo`030000o`3oool0oooo03H0oooo00<0003o0?ooo`3oool01P3oool00`3oO`00oooo
0?ooo`0B0?ooo`030000003oool0oooo01L0oooo00<0ogl00?ooo`3oool01P3oool00`000?l0oooo
0?ooo`0e0?ooo`030?mo003oool0oooo03<0oooo000h0?ooo`030000o`3oool0oooo03H0oooo00<0
003o0?ooo`3oool01P3oool00`3oO`00oooo0?ooo`0B0?ooo`030000003oool0oooo01L0oooo00<0
ogl00?ooo`3oool01`3oool00`000?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo0380oooo000h
0?ooo`030000o`3oool0oooo03H0oooo00<0003o0?ooo`3oool01`3oool00`3oO`00oooo0?ooo`0A
0?ooo`800000603oool00`3oO`00oooo0?ooo`070?ooo`030000o`3oool0oooo03D0oooo00<0ogl0
0?ooo`3oool0<P3oool003P0oooo00<0003o0?ooo`3oool0=@3oool00`000?l0oooo0?ooo`080?oo
o`030?mo003oool0oooo0140oooo00<000000?ooo`3oool05`3oool00`3oO`00oooo0?ooo`070?oo
o`030000o`3oool0oooo03D0oooo00<0ogl00?ooo`3oool0<P3oool003P0oooo00<0003o0?ooo`3o
ool0203oool00`000?l0oooo0?ooo`0Z0?ooo`030000o`3oool0oooo00P0oooo00<0ogl00?ooo`3o
ool04@3oool00`000000oooo0?ooo`0F0?ooo`030?mo003oool0oooo00P0oooo00<0003o0?ooo`3o
ool0=@3oool00`3oO`00oooo0?ooo`0b0?ooo`00>03oool00`000?l0oooo0?ooo`080?ooo`030000
o`3oool0oooo02X0oooo00<0003o0?ooo`3oool0203oool00`3oO`00oooo0?ooo`0A0?ooo`030000
003oool0oooo01H0oooo00<0ogl00?ooo`3oool02@3oool00`000?l0oooo0?ooo`0d0?ooo`030?mo
003oool0oooo0380oooo000g0?ooo`030000o`3oool0oooo00T0oooo00<0003o0?ooo`3oool0=@3o
ool00`3oO`0000000?ooo`030?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool05P3o
ool00`3oO`00oooo0?ooo`090?ooo`030000o`3oool0oooo03D0oooo00<0ogl00?ooo`3oool0<@3o
ool003L0oooo00<0003o0?ooo`3oool02@3oool00`000?l0oooo0?ooo`0d0?ooo`040000003oool0
ogl0000000P0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`0F0?ooo`030?mo
003oool0oooo00T0oooo00<0003o0?ooo`3oool0=@3oool00`3oO`00oooo0?ooo`0a0?ooo`00=`3o
ool00`000?l0oooo0?ooo`0:0?ooo`030000o`3oool0oooo03<0oooo00@000000?ooo`3oO`000000
2`3oool00`000000oooo0?ooo`030?ooo`<000005P3oool00`3oO`00oooo0?ooo`090?ooo`030000
o`3oool0oooo03D0oooo00<0ogl00?ooo`3oool0<@3oool003L0oooo00<0003o0?ooo`3oool02P3o
ool00`000?l0oooo0?ooo`0c0?ooo`040000003oool0ogl0000000T0oooo0P0000060?ooo`030000
003oool0oooo01D0oooo00<0ogl00?ooo`3oool02P3oool00`000?l0oooo0?ooo`0Y0?ooo`030000
o`3oool0oooo00T0oooo00<0ogl00?ooo`3oool0<@3oool004@0oooo00<0003o0?ooo`3oool0<`3o
ool010000000oooo0?mo000000090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
5@3oool00`3oO`00oooo0?ooo`0:0?ooo`030000o`3oool0oooo02T0oooo00<0003o0?ooo`3oool0
2P3oool00`3oO`00oooo0?ooo`0`0?ooo`00A03oool00`000?l0oooo0?ooo`0d0?ooo`80000000<0
ogl00?ooo`3oool01`3oool3000000D0oooo00<000000?ooo`3oool05@3oool00`3oO`00oooo0?oo
o`0;0?ooo`030000o`3oool0oooo02L0oooo00<0003o0?ooo`3oool02`3oool00`3oO`00oooo0?oo
o`0`0?ooo`00A03oool00`000?l0oooo0?ooo`0f0?ooo`030?mo003oool0oooo00l0oooo00<00000
0?ooo`3oool05@3oool00`3oO`00oooo0?ooo`0;0?ooo`030000o`3oool0oooo02L0oooo00<0003o
0?ooo`3oool02`3oool00`3oO`00oooo0?ooo`0W0?ooo`030?mo003oool0oooo00H0oooo000<0?oo
o`030000o`3oool0oooo03H0oooo00<0003o0?ooo`3oool0=@3oool00`3oO`00oooo0?ooo`0?0?oo
o`030000003oool0oooo01@0oooo00<0ogl00?ooo`3oool0303oool00`000?l0oooo0?ooo`0W0?oo
o`030000o`3oool0oooo00/0oooo00<0ogl00?ooo`3oool09`3oool00`3oO`00oooo0?ooo`060?oo
o`00303oool00`000?l0oooo0?ooo`0f0?ooo`030000o`3oool0oooo03D0oooo00<0ogl00?ooo`3o
ool03`3oool2000001D0oooo00<0ogl00?ooo`3oool0=P3oool00`000?l0oooo0?ooo`0<0?ooo`03
0?mo003oool0oooo02H0oooo00<0ogl00?ooo`3oool01P3oool000d0oooo00<0003o0?ooo`3oool0
=@3oool00`000?l0oooo0?ooo`0f0?ooo`030?mo003oool0oooo00h0oooo00<000000?ooo`3oool0
503oool00`3oO`00oooo0?ooo`0e0?ooo`030000o`3oool0oooo00d0oooo00<0ogl00?ooo`3oool0
9@3oool00`3oO`00oooo0?ooo`070?ooo`003@3oool00`000?l0oooo0?ooo`0e0?ooo`030000o`3o
ool0oooo03H0oooo00<0ogl00?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?ooo`030?mo003o
ool0oooo03D0oooo00<0003o0?ooo`3oool03@3oool00`3oO`00oooo0?ooo`0U0?ooo`030?mo003o
ool0oooo00L0oooo000=0?ooo`030000o`3oool0oooo03H0oooo00<0003o0?ooo`3oool0=@3oool0
0`3oO`00oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo00<0ogl00?ooo`3oool0=P3oool0
0`000?l0oooo0?ooo`0=0?ooo`030?mo003oool0oooo02D0oooo00<0ogl00?ooo`3oool01`3oool0
00d0oooo00<0003o0?ooo`3oool0=P3oool00`000?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo
00h0oooo00<000000?ooo`3oool04`3oool00`3oO`00oooo0?ooo`0e0?ooo`030000o`3oool0oooo
00h0oooo00<0ogl00?ooo`3oool09@3oool00`3oO`00oooo0?ooo`070?ooo`003P3oool00`000?l0
oooo0?ooo`1L0?ooo`030000o`3oool0oooo00h0oooo00<0ogl00?ooo`3oool03P3oool00`000000
oooo0?ooo`0C0?ooo`030?mo003oool0oooo03D0oooo00<0003o0?ooo`3oool03`3oool00`3oO`00
oooo0?ooo`0S0?ooo`030?mo003oool0oooo00P0oooo000>0?ooo`030000o`3oool0oooo05`0oooo
00<0003o0?ooo`3oool03`3oool00`3oO`00oooo0?ooo`0=0?ooo`800000503oool00`3oO`00oooo
0?ooo`0e0?ooo`030000o`3oool0oooo00l0oooo00<0ogl00?ooo`3oool08`3oool00`3oO`00oooo
0?ooo`080?ooo`003P3oool00`000?l0oooo0?ooo`1K0?ooo`030000o`3oool0oooo0100oooo00<0
ogl00?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`030?mo003oool0oooo03H0oooo00<0
003o0?ooo`3oool03`3oool00`3oO`00oooo0?ooo`0S0?ooo`030?mo003oool0oooo00P0oooo000?
0?ooo`030000o`3oool0oooo05X0oooo00<0003o0?ooo`3oool0403oool00`3oO`00oooo0?ooo`0=
0?ooo`030000003oool0oooo0180oooo00<0ogl00?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0@
0?ooo`030?mo003oool0oooo02<0oooo00<0ogl00?ooo`3oool0203oool000l0oooo00<0003o0?oo
o`3oool08P3oool00`000?l0oooo0?ooo`0e0?ooo`030000o`3oool0oooo0100oooo00<0ogl00?oo
o`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`030?mo003oool0oooo03D0oooo00<0003o0?oo
o`3oool04@3oool00`3oO`00oooo0?ooo`0Q0?ooo`030?mo003oool0oooo00T0oooo000?0?ooo`03
0000o`3oool0oooo0280oooo00<0003o0?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0A0?ooo`03
0?mo003oool0oooo00`0oooo00<000000?ooo`3oool04P3oool00`3oO`00oooo0?ooo`190?ooo`03
0?mo003oool0oooo0240oooo00<0ogl00?ooo`3oool02@3oool000l0oooo00<0003o0?ooo`3oool0
8@3oool00`000?l0oooo0?ooo`0e0?ooo`030000o`3oool0oooo0180oooo00<0ogl00?ooo`3oool0
303oool00`000000oooo0?ooo`0A0?ooo`030?mo003oool0oooo04X0oooo00<0ogl00?ooo`3oool0
8@3oool00`3oO`00oooo0?ooo`090?ooo`00403oool00`000?l0oooo0?ooo`0P0?ooo`030000o`3o
ool0oooo03D0oooo00<0003o0?ooo`3oool04P3oool00`3oO`00oooo0?ooo`0<0?ooo`8000004P3o
ool00`3oO`00oooo0?ooo`1:0?ooo`030?mo003oool0oooo0240oooo00<0ogl00?ooo`3oool02@3o
ool00100oooo00<0003o0?ooo`3oool0803oool00`000?l0oooo0?ooo`0e0?ooo`030000o`3oool0
oooo0180oooo00<0ogl00?ooo`3oool0303oool00`000000oooo0?ooo`0A0?ooo`030?mo003oool0
oooo01<0oooo00<0003o0?ooo`3oool0=@3oool00`3oO`00oooo0?ooo`0O0?ooo`030?mo003oool0
oooo00X0oooo000b0?ooo`030000o`3oool0oooo03D0oooo00<0003o0?ooo`3oool0503oool00`3o
O`00oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo00<0ogl00?ooo`3oool04`3oool00`00
0?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo01l0oooo00<0ogl00?ooo`3oool02P3oool00380
oooo00<0003o0?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0D0?ooo`030?mo003oool0oooo00/0
oooo00<000000?ooo`3oool0403oool00`3oO`00oooo0?ooo`0E0?ooo`030000o`3oool0oooo03@0
oooo00<0ogl00?ooo`3oool07`3oool00`3oO`00oooo0?ooo`0:0?ooo`00<P3oool00`000?l0oooo
0?ooo`0e0?ooo`030000o`3oool0oooo01@0oooo00<0ogl00?ooo`3oool02`3oool00`000000oooo
0?ooo`0@0?ooo`030?mo003oool0oooo01D0oooo00<0003o0?ooo`3oool0=03oool00`3oO`00oooo
0?ooo`0O0?ooo`030?mo003oool0oooo00X0oooo000b0?ooo`030000o`3oool0oooo03D0oooo00<0
003o0?ooo`3oool05@3oool00`3oO`00oooo0?ooo`0:0?ooo`030000003oool0oooo0100oooo00<0
ogl00?ooo`3oool05@3oool00`000?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo01d0oooo00<0
ogl00?ooo`3oool02`3oool00340oooo00<0003o0?ooo`3oool05@3oool00`000?l0oooo0?ooo`0M
0?ooo`030000o`3oool0oooo01H0oooo00<0ogl00?ooo`3oool02P3oool200000140oooo00<0ogl0
0?ooo`3oool05P3oool00`000?l0oooo0?ooo`0d0?ooo`030?mo003oool0oooo01d0oooo00<0ogl0
0?ooo`3oool02`3oool00340oooo00<0003o0?ooo`3oool05@3oool00`000?l0oooo0?ooo`0M0?oo
o`030000o`3oool0oooo01H0oooo00<0ogl00?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?oo
o`030?mo003oool0oooo01L0oooo00<0003o0?ooo`3oool0=03oool00`3oO`00oooo0?ooo`0M0?oo
o`030?mo003oool0oooo00/0oooo000a0?ooo`030000o`3oool0oooo01H0oooo00<0003o0?ooo`3o
ool0=@3oool00`3oO`00oooo0?ooo`0:0?ooo`030000003oool0oooo00l0oooo00<0ogl00?ooo`3o
ool05`3oool00`000?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo01`0oooo00<0ogl00?ooo`3o
ool02`3oool00300oooo00<0003o0?ooo`3oool05`3oool00`000?l0oooo0?ooo`0f0?ooo`030?mo
003oool0oooo00T0oooo00<000000?ooo`3oool03`3oool00`3oO`00oooo0?ooo`0G0?ooo`030000
o`3oool0oooo03D0oooo00<0ogl00?ooo`3oool06`3oool00`3oO`00oooo0?ooo`0<0?ooo`00<03o
ool00`000?l0oooo0?ooo`0G0?ooo`030000o`3oool0oooo03H0oooo00<0ogl00?ooo`3oool01@00
00040?ooo`030000003oool0oooo00h0oooo00<0ogl00?ooo`3oool06@3oool00`000?l0oooo0?oo
o`0d0?ooo`030?mo003oool0oooo01/0oooo00<0ogl00?ooo`3oool0303oool004/0oooo00<0003o
0?ooo`3oool0=@3oool00`3oO`00oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool03P3oool00`3oO`00oooo0?ooo`0I0?ooo`030000o`3oool0oooo01X0oooo00<0003o
0?ooo`3oool0603oool00`3oO`00oooo0?ooo`0J0?ooo`030?mo003oool0oooo00`0oooo001;0?oo
o`030000o`3oool0oooo03D0oooo00<0ogl00?ooo`3oool00P3oool00`000000oooo0?ooo`040?oo
o`<000003P3oool00`3oO`00oooo0?ooo`0I0?ooo`030000o`3oool0oooo01T0oooo00<0003o0?oo
o`3oool06@3oool00`3oO`00oooo0?ooo`0I0?ooo`030?mo003oool0oooo00d0oooo001;0?ooo`03
0000o`3oool0oooo03H0oooo00D0ogl00?ooo`3oool0oooo000000060?ooo`030000003oool0oooo
00d0oooo00<0ogl00?ooo`3oool06`3oool00`000?l0oooo0?ooo`0H0?ooo`030000o`3oool0oooo
01T0oooo00<0ogl00?ooo`3oool06@3oool00`3oO`00oooo0?ooo`0=0?ooo`00C03oool00`000?l0
oooo0?ooo`0e0?ooo`050?mo003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`0=0?oo
o`030?mo003oool0oooo01/0oooo00<0003o0?ooo`3oool0603oool00`000?l0oooo0?ooo`0J0?oo
o`030?mo003oool0oooo01P0oooo00<0ogl00?ooo`3oool03@3oool001@0oooo00<0003o0?ooo`3o
ool0=@3oool00`000?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo008000001P3oool00`000000
oooo0?ooo`0=0?ooo`030?mo003oool0oooo03D0oooo00<0003o0?ooo`3oool06`3oool00`3oO`00
oooo0?ooo`0G0?ooo`030?mo003oool0oooo00h0oooo000D0?ooo`030000o`3oool0oooo03D0oooo
00<0003o0?ooo`3oool0=P3oool00`3oO`00oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo
00<0ogl00?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0K0?ooo`030?mo003oool0oooo01L0oooo
00<0ogl00?ooo`3oool03P3oool001D0oooo00<0003o0?ooo`3oool0=@3oool00`000?l0oooo0?oo
o`0e0?ooo`030?mo003oool0oooo00L0oooo00<000000?ooo`3oool0303oool00`3oO`00oooo0?oo
o`0e0?ooo`030000o`3oool0oooo01d0oooo00<0ogl00?ooo`3oool05P3oool00`3oO`00oooo0?oo
o`0>0?ooo`005@3oool00`000?l0oooo0?ooo`0e0?ooo`030000o`3oool0oooo03D0oooo00<0ogl0
0?ooo`3oool01`3oool2000000d0oooo00<0ogl00?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0M
0?ooo`030?mo003oool0oooo01D0oooo00<0ogl00?ooo`3oool03`3oool001D0oooo00<0003o0?oo
o`3oool0=@3oool00`000?l0oooo0?ooo`0f0?ooo`030?mo003oool0oooo00H0oooo00<000000?oo
o`3oool0303oool00`3oO`00oooo0?ooo`0e0?ooo`030000o`3oool0oooo01d0oooo00<0ogl00?oo
o`3oool05@3oool00`3oO`00oooo0?ooo`0?0?ooo`005P3oool00`000?l0oooo0?ooo`0d0?ooo`03
0000o`3oool0oooo03H0oooo00<0ogl00?ooo`3oool01P3oool00`000000oooo0?ooo`0;0?ooo`03
0?mo003oool0oooo03D0oooo00<0003o0?ooo`3oool07`3oool00`3oO`00oooo0?ooo`0D0?ooo`03
0?mo003oool0oooo00l0oooo000F0?ooo`030000o`3oool0oooo04`0oooo00<0003o0?ooo`3oool0
7`3oool00`3oO`00oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo00<0ogl00?ooo`3oool0
=@3oool00`000?l0oooo0?ooo`0O0?ooo`030?mo003oool0oooo01<0oooo00<0ogl00?ooo`3oool0
403oool001H0oooo00<0003o0?ooo`3oool0B`3oool00`000?l0oooo0?ooo`0P0?ooo`030?mo003o
ool0oooo00D0oooo00<000000?ooo`3oool02P3oool00`3oO`00oooo0?ooo`0f0?ooo`030000o`3o
ool0oooo01l0oooo00<0ogl00?ooo`3oool04`3oool00`3oO`00oooo0?ooo`0@0?ooo`005P3oool0
0`000?l0oooo0?ooo`1;0?ooo`030000o`3oool0oooo0200oooo00<0ogl00?ooo`3oool01@3oool0
0`000000oooo0?ooo`0:0?ooo`030?mo003oool0oooo03D0oooo00<0003o0?ooo`3oool08@3oool0
0`3oO`00oooo0?ooo`0B0?ooo`030?mo003oool0oooo0100oooo000G0?ooo`030000o`3oool0oooo
0140oooo00<0003o0?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0Q0?ooo`030?mo003oool0oooo
00D0oooo0P00000;0?ooo`030?mo003oool0oooo03D0oooo00<0003o0?ooo`3oool08@3oool00`3o
O`00oooo0?ooo`0A0?ooo`030?mo003oool0oooo0140oooo000G0?ooo`030000o`3oool0oooo0140
oooo00<0003o0?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0R0?ooo`030?mo003oool0oooo00@0
oooo00<000000?ooo`3oool02@3oool00`3oO`00oooo0?ooo`0f0?ooo`030000o`3oool0oooo0280
oooo00<0ogl00?ooo`3oool0403oool00`3oO`00oooo0?ooo`0A0?ooo`00603oool00`000?l0oooo
0?ooo`0?0?ooo`030000o`3oool0oooo03H0oooo00<0003o0?ooo`3oool08P3oool00`3oO`00oooo
0?ooo`040?ooo`030000003oool0oooo00T0oooo00<0ogl00?ooo`3oool0F`3oool00`3oO`00oooo
0?ooo`0?0?ooo`030?mo003oool0oooo0180oooo000H0?ooo`030000o`3oool0oooo00l0oooo00<0
003o0?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0T0?ooo`030?mo003oool0oooo00<0oooo00<0
00000?ooo`3oool0203oool00`3oO`00oooo0?ooo`1M0?ooo`030?mo003oool0oooo00h0oooo00<0
ogl00?ooo`3oool04P3oool001T0oooo00<0003o0?ooo`3oool03@3oool00`000?l0oooo0?ooo`0f
0?ooo`030000o`3oool0oooo02@0oooo00<0ogl00?ooo`3oool00`3oool00`000000oooo0?ooo`08
0?ooo`030?mo003oool0oooo02D0oooo00<0003o0?ooo`3oool0=@3oool00`3oO`00oooo0?ooo`0=
0?ooo`030?mo003oool0oooo01<0oooo000Y0?ooo`030000o`3oool0oooo03D0oooo00<0003o0?oo
o`3oool09P3oool00`3oO`00oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<0ogl00?oo
o`3oool09P3oool00`000?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo00d0oooo00<0ogl00?oo
o`3oool04`3oool002P0oooo00<0003o0?ooo`3oool0=P3oool00`000?l0oooo0?ooo`0W0?ooo`04
0?mo003oool0oooo0?ooo`800000203oool00`3oO`00oooo0?ooo`0W0?ooo`030000o`3oool0oooo
03D0oooo00<0ogl00?ooo`3oool02`3oool00`3oO`00oooo0?ooo`0D0?ooo`00:03oool00`000?l0
oooo0?ooo`0e0?ooo`030000o`3oool0oooo02P0oooo00D0ogl00?ooo`3oool0oooo000000080?oo
o`030?mo003oool0oooo02P0oooo00<0003o0?ooo`3oool0=P3oool00`3oO`00oooo0?ooo`0:0?oo
o`030?mo003oool0oooo01@0oooo000W0?ooo`030000o`3oool0oooo02X0oooo00<0003o0?ooo`3o
ool0203oool00`000?l0oooo0?ooo`0Z0?ooo`040?mo003oool0oooo000000L0oooo00<0ogl00?oo
o`3oool0:P3oool00`000?l0oooo0?ooo`0e0?ooo`030?mo003oool0oooo00T0oooo00<0ogl00?oo
o`3oool05@3oool002H0oooo00<0003o0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`070?ooo`80
003o;03oool0103oO`00oooo0?ooo`0000070?ooo`030?mo003oool0oooo02X0oooo00<0003o0?oo
o`3oool0=P3oool00`3oO`00oooo0?ooo`080?ooo`030?mo003oool0oooo01D0oooo000U0?ooo`03
0000o`3oool0oooo02d0oooo00<0003o0?ooo`3oool0=@3oool20?mo00030000003oool0oooo00@0
oooo00<0ogl00?ooo`3oool0;03oool00`000?l0oooo0?ooo`0f0?ooo`030?mo003oool0oooo00D0
oooo0P3oO`0H0?ooo`00903oool20000oc00oooo00<0003o0?ooo`3oool0=@3oool20?mo00@0oooo
0P3oO`0`0?ooo`80003o=`3oool20?mo00@0oooo0P3oO`0I0?ooo`008`3oool20000ofX0oooo00<0
00000?mo003oO`000`3oO`0c0?ooo`D0003o<`3oool50?mo01/0oooo002?0?ooo`030000003oool0
oooo08h0oooo002?0?ooo`030000003oool0oooo08h0oooo002?0?ooo`030000003oool0oooo08h0
oooo002?0?ooo`030000003oool0oooo08h0oooo0000\
\>"],
  ImageRangeCache->{{{81, 368}, {471.75, 294.812}} -> {-8.23379, 3.4368, \
0.0366761, 0.0166558}},
  CellTags->"b:0.1"]
}, Open  ]],

Cell[TextData[{
  "It should be noted that sometimes the solutions to fairly simple nonlinear \
equations are only available in implicit form. In these cases, ",
  StyleBox["DSolve", "MR"],
  StyleBox[" returns ", "TR"],
  "an unevaluated ",
  StyleBox["Solve", "MR"],
  " object. "
}], "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  "This nonlinear differential equation only has an implicit solution. The ",
  StyleBox["Solve::tdep", "MR"],
  " messages can be ignored; they appear because ",
  StyleBox["Solve", "MR"],
  " cannot find an explicit expression for ",
  StyleBox["y[x]", "MR"],
  " because non-algebraic functions (",
  StyleBox["ArcTan", "MR"],
  " and ",
  StyleBox["Log", "MR"],
  ") are involved."
}], "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\((y[x] + x - 1)\)*\(y'\)[x] - y[x] + 2  x + 3 \[Equal] 0, \ 
      y[x], \ x]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:0.1"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:0.1"],

Cell[BoxData[
    \(Solve[
      2\/3\ \((\@2\ ArcTan[\(\(-2\) + \(2\ \((2 + 3\ x)\)\)\/\(\(-1\) + x + \
y[x]\)\)\/\(2\ \@2\)] - 
              Log[\(\((\(-1\) + x + y[x])\)\^2\ \((3 + \(\((2 + 3\ x)\)\ \
\((\(-2\) + \(2 + 3\ x\)\/\(\(-1\) + x + y[x]\))\)\)\/\(\(-1\) + x + \
y[x]\))\)\)\/\((2 + 3\ x)\)\^2])\) \[Equal] C[1] + 4\/3\ Log[2 + 3\ x], 
      y[x]]\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell[TextData[{
  "When the coefficients of a linear ODE do not depend on ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", the ODE is said to have ",
  StyleBox["constant coefficients.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"b:0.1"],

Cell["This is an ODE with constant coefficients.", "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqn = \(y'''\)[x]\  + \ 3*\(y''\)[x] - 25*\(y'\)[x] + 
        21*y[x]; \), "\[IndentingNewLine]", 
    \(sol = DSolve[eqn \[Equal] 0, \ y[x], x]\)}], "Input",
  CellLabel->"In[25]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(\(-7\)\ x\)\ C[
                1] + \[ExponentialE]\^x\ C[2] + \[ExponentialE]\^\(3\ x\)\ C[
                3]}}\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell[TextData[{
  "The previous equation is also ",
  StyleBox["homogeneous",
    FontSlant->"Italic"],
  ": all terms contain ",
  StyleBox["y",
    FontSlant->"Italic"],
  " or derivatives of ",
  StyleBox["y",
    FontSlant->"Italic"],
  " and its right-hand side is zero. Adding a function of the independent \
variable makes the equation ",
  StyleBox["inhomogeneous",
    FontSlant->"Italic"],
  ". The general solution to an inhomogeneous equation with constant \
coefficients is obtained by adding a particular integral to the solution to \
the corresponding homogeneous equation. "
}], "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  "Here, ",
  Cell[BoxData[
      \(x\^2\)]],
  " is added to the right-hand side of the previous equation, making the new \
equation inhomogeneous. The general solution to this new equation is the sum \
of the previous solution and a particular integral."
}], "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = DSolve[eqn \[Equal] \ x^2, \ y[x], x]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(1124 + 1050\ x + 441\ x\^2\)\/9261 + \[ExponentialE]\
\^\(\(-7\)\ x\)\ C[1] + \[ExponentialE]\^x\ C[
                2] + \[ExponentialE]\^\(3\ x\)\ C[3]}}\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell[TextData[{
  "When the coefficients of an ODE depend on ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", the ODE is said to have ",
  StyleBox["variable coefficients",
    FontSlant->"Italic"],
  ". Since equations with variable coefficients that are ",
  StyleBox["rational functions",
    FontSlant->"Italic"],
  " ",
  StyleBox["of x",
    FontSlant->"Italic"],
  " have singularities that are easily classified, there are sophisticated \
algorithms available for solving them."
}], "Text",
  CellTags->"b:0.1"],

Cell[TextData[{
  "The coefficients of this equation are rational functions of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". "
}], "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[{\(y''\)[x] - \((\((1/x)\) - \((3/\((16  x^2)\))\))\)*
                y[x] \[Equal] 0, \ y[1] \[Equal] 1, \ \(y'\)[1] \[Equal] 4}, 
        y[x], x]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          1\/8\ \[ExponentialE]\^\(\(-2\) - 2\ \@x\)\ \((\(-11\)\ \
\[ExponentialE]\^4 + 
                19\ \[ExponentialE]\^\(4\ \@x\))\)\ x\^\(1/4\)}}\)], "Output",\

  CellLabel->"Out[28]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell[TextData[{
  "There is a close relationship between functions and differential \
equations. Starting with a function of almost any type, it is possible to \
construct a differential equation satisfied by that function. Conversely, any \
differential equation gives rise to one or more functions, in the form of \
solutions to that equation. In fact, many ",
  StyleBox["special functions ",
    FontSlant->"Italic"],
  StyleBox["from classical analysis have their origins in the solution of \
differential equations. ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathieu functions",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" are one such class of special functions. ",
    FontVariations->{"CompatibilityType"->0}],
  "Mathieu was interested in studying the vibrations of elliptical membranes. \
The eigenfunctions for the wave equation that describes this motion are given \
by products of Mathieu functions."
}], "Text",
  CellTags->"b:0.1"],

Cell["\<\
This linear second-order ODE with rational coefficients has a \
general solution given by Mathieu functions.\
\>", "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\((t - 1)\) \((t + 1)\)*\(y''\)[t] + 
          t*\(y'\)[t] + \((\(-2\) - 6*t^2)\)*y[t] \[Equal] 0, \ y[t], 
      t]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    \({{y[t] \[Rule] 
          C[1]\ MathieuC[5, \(-\(3\/2\)\), ArcCos[t]] + 
            C[2]\ MathieuS[5, \(-\(3\/2\)\), ArcCos[t]]}}\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell[TextData[{
  "The presence of ",
  StyleBox["ArcCos[t]", "MR"],
  " in the previous solution suggests that the equation can be given a \
simpler form using trigonometric functions. This is the form in which these \
equations were introduced by E. Mathieu in 1868. "
}], "MathCaption",
  CellTags->{"MathieuODE", "b:0.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(\(DSolve[\(y''\)[x]\  + \ \((3\ Cos[2  x]\  + \ 5)\) 
              y[x]\  == \ 0, \ y, \ x]\)\(\ \)\),
      FormatType->StandardForm]], "Input",
  CellLabel->"In[30]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            C[1]\ MathieuC[5, \(-\(3\/2\)\), x] + 
              C[2]\ MathieuS[5, \(-\(3\/2\)\), x]]}}\)], "Output",
  CellLabel->"Out[30]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell["\<\
This plots the surface for a particular product of solutions to \
this equation.\
\>", "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      MathieuC[5, \(-\(3\/2\)\), x]*\ 
        MathieuS[5, \(-\(3\/2\)\), y], \ {x, \(-3\), 3}, \ {y, \(-3\), 
        3}]; \)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"b:0.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.55041e-017 1.04977 -0.0679587 1.04977 [
[.12586 .2075 -12 -8.99448 ]
[.12586 .2075 0 .00552 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.56094 .0364 -5.16972 -9 ]
[.56094 .0364 .83028 0 ]
[.75679 .08071 0 -6.17777 ]
[.75679 .08071 12 2.82223 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9429 .3657 0 -5.9083 ]
[.9429 .3657 6 3.0917 ]
[.02402 .2657 -12 -2.74282 ]
[.02402 .2657 0 6.25718 ]
[.01563 .31826 -24 -2.78725 ]
[.01563 .31826 0 6.21275 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00203 .42894 -18 -2.88133 ]
[-0.00203 .42894 0 6.11867 ]
[-0.01133 .48727 -6 -2.93118 ]
[-0.01133 .48727 0 6.06882 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.7445 .0853 m
.73835 .08759 L
s
[(-2)] .75679 .08071 -1 .37284 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.93037 .36962 m
.92411 .37158 L
s
[(2)] .9429 .3657 -1 .31296 Mshowa
.125 Mabswid
.7708 .12553 m
.7671 .12688 L
s
.79613 .16428 m
.79242 .1656 L
s
.82054 .20161 m
.81682 .20291 L
s
.86679 .27235 m
.86305 .2736 L
s
.88871 .30589 m
.88497 .30711 L
s
.9099 .3383 m
.90615 .3395 L
s
.71716 .04348 m
.71349 .04489 L
s
.95018 .39992 m
.94642 .40107 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03624 .26093 m
.04235 .25854 L
s
[(-1)] .02402 .2657 1 -0.39049 Mshowa
.0279 .31359 m
.03403 .31125 L
s
[(-0.5)] .01563 .31826 1 -0.38061 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01032 .4245 m
.01649 .42228 L
s
[(0.5)] -0.00203 .42894 1 -0.3597 Mshowa
.00106 .48295 m
.00725 .48079 L
s
[(1)] -0.01133 .48727 1 -0.34863 Mshowa
.125 Mabswid
.0346 .27132 m
.03827 .26989 L
s
.03294 .28178 m
.03661 .28036 L
s
.03127 .29231 m
.03494 .2909 L
s
.02959 .30291 m
.03327 .30151 L
s
.02619 .32434 m
.02988 .32294 L
s
.02448 .33516 m
.02816 .33377 L
s
.02275 .34606 m
.02644 .34468 L
s
.02101 .35703 m
.0247 .35566 L
s
.0175 .37921 m
.02119 .37785 L
s
.01572 .39041 m
.01942 .38906 L
s
.01394 .40169 m
.01763 .40035 L
s
.01213 .41306 m
.01584 .41172 L
s
.00849 .43602 m
.0122 .4347 L
s
.00666 .44763 m
.01037 .44631 L
s
.0048 .45932 m
.00852 .45801 L
s
.00294 .47109 m
.00665 .46979 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.573 .462 .689 r
.38945 .66672 .40107 .71955 .42333 .70763 .41116 .668 Metetra
.502 .451 .733 r
.41116 .668 .42333 .70763 .44582 .69045 .43295 .67631 Metetra
.202 .503 .908 r
.43295 .67631 .44582 .69045 .46836 .6727 .4551 .6855 Metetra
.554 .109 .149 r
.4551 .6855 .46836 .6727 .49092 .65753 .47769 .69121 Metetra
.539 .208 .355 r
.47769 .69121 .49092 .65753 .51353 .64584 .50065 .69206 Metetra
.518 .218 .398 r
.50065 .69206 .51353 .64584 .53628 .63745 .52391 .6882 Metetra
.491 .202 .401 r
.52391 .6882 .53628 .63745 .55922 .6324 .54738 .67953 Metetra
.437 .146 .371 r
.54738 .67953 .55922 .6324 .58245 .63133 .57094 .66519 Metetra
.282 0 .245 r
.57094 .66519 .58245 .63133 .60604 .63465 .59447 .64475 Metetra
.608 .892 .588 r
.59447 .64475 .60604 .63465 .63007 .64088 .61792 .62044 Metetra
.775 .695 .775 r
.61792 .62044 .63007 .64088 .65442 .64568 .6414 .5982 Metetra
.654 .528 .698 r
.6414 .5982 .65442 .64568 .67884 .64361 .66524 .58504 Metetra
.585 .465 .682 r
.66524 .58504 .67884 .64361 .70305 .6321 .68981 .58424 Metetra
.523 .447 .712 r
.68981 .58424 .70305 .6321 .72699 .61361 .71519 .59267 Metetra
.363 .499 .862 r
.71519 .59267 .72699 .61361 .75089 .59357 .74116 .60332 Metetra
.531 .036 .025 r
.74116 .60332 .75089 .59357 .77501 .57636 .76735 .61021 Metetra
.535 .198 .343 r
.76735 .61021 .77501 .57636 .79957 .56355 .7935 .61098 Metetra
.514 .215 .397 r
.7935 .61098 .79957 .56355 .82462 .55478 .81951 .60597 Metetra
.49 .202 .403 r
.81951 .60597 .82462 .55478 .8502 .54942 .84533 .59602 Metetra
.447 .158 .379 r
.84533 .59602 .8502 .54942 .8764 .54749 .87085 .58114 Metetra
.335 .028 .287 r
.87085 .58114 .8764 .54749 .90333 .54924 .89593 .56111 Metetra
.89593 .56111 .90333 .54924 .93098 .55376 .92061 .53731 Metetra
.808 .768 .816 r
.92061 .53731 .93098 .55376 .959 .55779 .94538 .5143 Metetra
.671 .553 .712 r
.94538 .5143 .959 .55779 .98672 .55634 .97111 .49855 Metetra
.475 .422 .719 r
.37752 .6238 .38945 .66672 .41116 .668 .39875 .6349 Metetra
.064 .201 .697 r
.39875 .6349 .41116 .668 .43295 .67631 .41989 .66256 Metetra
.716 .229 0 r
.41989 .66256 .43295 .67631 .4551 .6855 .44158 .69276 Metetra
.743 .306 .215 r
.44158 .69276 .4551 .6855 .47769 .69121 .46408 .71516 Metetra
.62 .252 .323 r
.46408 .71516 .47769 .69121 .50065 .69206 .48727 .7262 Metetra
.526 .191 .342 r
.48727 .7262 .50065 .69206 .52391 .6882 .51094 .72604 Metetra
.419 .101 .316 r
.51094 .72604 .52391 .6882 .54738 .67953 .53488 .71438 Metetra
.197 0 .201 r
.53488 .71438 .54738 .67953 .57094 .66519 .55882 .68921 Metetra
.55882 .68921 .57094 .66519 .59447 .64475 .58247 .64973 Metetra
.971 .92 .689 r
.58247 .64973 .59447 .64475 .61792 .62044 .60569 .60165 Metetra
.859 .726 .715 r
.60569 .60165 .61792 .62044 .6414 .5982 .62869 .55895 Metetra
.708 .579 .709 r
.62869 .55895 .6414 .5982 .66524 .58504 .6522 .53755 Metetra
.529 .451 .711 r
.6522 .53755 .66524 .58504 .68981 .58424 .67699 .54465 Metetra
.256 .303 .719 r
.67699 .54465 .68981 .58424 .71519 .59267 .70335 .57337 Metetra
0 .013 .577 r
.70335 .57337 .71519 .59267 .74116 .60332 .73081 .60788 Metetra
.741 .25 .068 r
.73081 .60788 .74116 .60332 .76735 .61021 .75855 .63404 Metetra
.612 .226 .286 r
.75855 .63404 .76735 .61021 .7935 .61098 .78597 .64587 Metetra
.511 .174 .332 r
.78597 .64587 .7935 .61098 .81951 .60597 .81278 .64396 Metetra
.416 .103 .323 r
.81278 .64396 .81951 .60597 .84533 .59602 .83885 .63019 Metetra
.26 0 .254 r
.83885 .63019 .84533 .59602 .87085 .58114 .86391 .6047 Metetra
0 0 .007 r
.86391 .6047 .87085 .58114 .89593 .56111 .88764 .56718 Metetra
.906 .941 .581 r
.88764 .56718 .89593 .56111 .92061 .53731 .91016 .52123 Metetra
.904 .787 .722 r
.91016 .52123 .92061 .53731 .94538 .5143 .9326 .47765 Metetra
.739 .611 .716 r
.9326 .47765 .94538 .5143 .97111 .49855 .95696 .45125 Metetra
.228 .382 .81 r
.36476 .59964 .37752 .6238 .39875 .6349 .3858 .61451 Metetra
.66 .236 0 r
.3858 .61451 .39875 .6349 .41989 .66256 .40659 .64976 Metetra
.843 .386 0 r
.40659 .64976 .41989 .66256 .44158 .69276 .42803 .68835 Metetra
.804 .319 .042 r
.42803 .68835 .44158 .69276 .46408 .71516 .45044 .71751 Metetra
.655 .132 0 r
.45044 .71751 .46408 .71516 .48727 .7262 .47373 .73269 Metetra
.348 0 0 r
.47373 .73269 .48727 .7262 .51094 .72604 .49763 .734 Metetra
.49763 .734 .51094 .72604 .53488 .71438 .52185 .72104 Metetra
.864 .995 .761 r
.52185 .72104 .53488 .71438 .55882 .68921 .5461 .69133 Metetra
.962 .898 .713 r
.5461 .69133 .55882 .68921 .58247 .64973 .57002 .64402 Metetra
.944 .812 .684 r
.57002 .64402 .58247 .64973 .60569 .60165 .59337 .58633 Metetra
.893 .752 .698 r
.59337 .58633 .60569 .60165 .62869 .55895 .6164 .5355 Metetra
.776 .678 .756 r
.6164 .5355 .62869 .55895 .6522 .53755 .63991 .51083 Metetra
.421 .479 .814 r
.63991 .51083 .6522 .53755 .67699 .54465 .66484 .52093 Metetra
0 .029 .6 r
.66484 .52093 .67699 .54465 .70335 .57337 .69154 .55757 Metetra
.681 .231 0 r
.69154 .55757 .70335 .57337 .73081 .60788 .71955 .60158 Metetra
.736 .22 0 r
.71955 .60158 .73081 .60788 .75855 .63404 .74792 .63553 Metetra
.593 .028 0 r
.74792 .63553 .75855 .63404 .78597 .64587 .77589 .65187 Metetra
.249 0 0 r
.77589 .65187 .78597 .64587 .81278 .64396 .80312 .65117 Metetra
.80312 .65117 .81278 .64396 .83885 .63019 .82941 .63575 Metetra
.768 .967 .673 r
.82941 .63575 .83885 .63019 .86391 .6047 .85443 .60579 Metetra
.958 .947 .683 r
.85443 .60579 .86391 .6047 .88764 .56718 .87781 .56103 Metetra
.974 .865 .669 r
.87781 .56103 .88764 .56718 .91016 .52123 .89968 .5061 Metetra
.929 .795 .691 r
.89968 .5061 .91016 .52123 .9326 .47765 .92141 .45432 Metetra
.815 .713 .752 r
.92141 .45432 .9326 .47765 .95696 .45125 .94538 .4237 Metetra
.456 0 0 r
.35099 .59293 .36476 .59964 .3858 .61451 .37216 .60602 Metetra
.827 .351 .017 r
.37216 .60602 .3858 .61451 .40659 .64976 .39306 .63786 Metetra
.819 .346 0 r
.39306 .63786 .40659 .64976 .42803 .68835 .41455 .67268 Metetra
0 0 .461 r
.41455 .67268 .42803 .68835 .45044 .71751 .437 .69877 Metetra
.161 .422 .861 r
.437 .69877 .45044 .71751 .47373 .73269 .46033 .71201 Metetra
.543 .608 .868 r
.46033 .71201 .47373 .73269 .49763 .734 .48428 .71253 Metetra
.704 .669 .813 r
.48428 .71253 .49763 .734 .52185 .72104 .5086 .69998 Metetra
.798 .702 .759 r
.5086 .69998 .52185 .72104 .5461 .69133 .53302 .67207 Metetra
.858 .725 .715 r
.53302 .67207 .5461 .69133 .57002 .64402 .55721 .62799 Metetra
.892 .746 .693 r
.55721 .62799 .57002 .64402 .59337 .58633 .58093 .57428 Metetra
.904 .779 .713 r
.58093 .57428 .59337 .58633 .6164 .5355 .60435 .5268 Metetra
.847 .845 .842 r
.60435 .5268 .6164 .5355 .63991 .51083 .62814 .50337 Metetra
0 .469 .841 r
.62814 .50337 .63991 .51083 .66484 .52093 .65314 .51201 Metetra
.716 .206 0 r
.65314 .51201 .66484 .52093 .69154 .55757 .67972 .54506 Metetra
.708 .229 0 r
.67972 .54506 .69154 .55757 .71955 .60158 .7075 .5848 Metetra
0 .058 .604 r
.7075 .5848 .71955 .60158 .74792 .63553 .73567 .61521 Metetra
.249 .455 .865 r
.73567 .61521 .74792 .63553 .77589 .65187 .76354 .62941 Metetra
.574 .617 .857 r
.76354 .62941 .77589 .65187 .80312 .65117 .79081 .62801 Metetra
.715 .677 .812 r
.79081 .62801 .80312 .65117 .82941 .63575 .81729 .61312 Metetra
.802 .715 .768 r
.81729 .61312 .82941 .63575 .85443 .60579 .84266 .58492 Metetra
.867 .745 .726 r
.84266 .58492 .85443 .60579 .87781 .56103 .86658 .5431 Metetra
.911 .772 .696 r
.86658 .5431 .87781 .56103 .89968 .5061 .88916 .49186 Metetra
.928 .807 .706 r
.88916 .49186 .89968 .5061 .92141 .45432 .91159 .44343 Metetra
.881 .862 .816 r
.91159 .44343 .92141 .45432 .94538 .4237 .93607 .41444 Metetra
.536 .006 0 r
.33631 .59787 .35099 .59293 .37216 .60602 .35789 .60546 Metetra
.744 .246 .043 r
.35789 .60546 .37216 .60602 .39306 .63786 .37927 .6265 Metetra
.623 .097 0 r
.37927 .6265 .39306 .63786 .41455 .67268 .40114 .64948 Metetra
.146 .355 .812 r
.40114 .64948 .41455 .67268 .437 .69877 .42379 .66604 Metetra
.478 .479 .78 r
.42379 .66604 .437 .69877 .46033 .71201 .44716 .67335 Metetra
.587 .516 .742 r
.44716 .67335 .46033 .71201 .48428 .71253 .47107 .67161 Metetra
.65 .546 .723 r
.47107 .67161 .48428 .71253 .5086 .69998 .49535 .66058 Metetra
.71 .584 .713 r
.49535 .66058 .5086 .69998 .53302 .67207 .51979 .63862 Metetra
.773 .634 .708 r
.51979 .63862 .53302 .67207 .55721 .62799 .54418 .60504 Metetra
.836 .702 .716 r
.54418 .60504 .55721 .62799 .58093 .57428 .56832 .56435 Metetra
.893 .813 .762 r
.56832 .56435 .58093 .57428 .60435 .5268 .59227 .5279 Metetra
.776 .993 .879 r
.59227 .5279 .60435 .5268 .62814 .50337 .61649 .50878 Metetra
.4 0 0 r
.61649 .50878 .62814 .50337 .65314 .51201 .64157 .51294 Metetra
.695 .162 0 r
.64157 .51294 .65314 .51201 .67972 .54506 .6678 .53468 Metetra
.537 .017 0 r
.6678 .53468 .67972 .54506 .7075 .5848 .69493 .56099 Metetra
.176 .369 .816 r
.69493 .56099 .7075 .5848 .73567 .61521 .72243 .58039 Metetra
.49 .483 .777 r
.72243 .58039 .73567 .61521 .76354 .62941 .74982 .58814 Metetra
.597 .52 .739 r
.74982 .58814 .76354 .62941 .79081 .62801 .7769 .58478 Metetra
.655 .549 .722 r
.7769 .58478 .79081 .62801 .81729 .61312 .80351 .57185 Metetra
.707 .584 .715 r
.80351 .57185 .81729 .61312 .84266 .58492 .82944 .54945 Metetra
.768 .635 .714 r
.82944 .54945 .84266 .58492 .86658 .5431 .85443 .51725 Metetra
.836 .708 .722 r
.85443 .51725 .86658 .5431 .88916 .49186 .87852 .47812 Metetra
.9 .821 .761 r
.87852 .47812 .88916 .49186 .91159 .44343 .90256 .44079 Metetra
.833 .99 .864 r
.90256 .44079 .91159 .44343 .93607 .41444 .9281 .41738 Metetra
.393 0 0 r
.32088 .60929 .33631 .59787 .35789 .60546 .34307 .6092 Metetra
.464 0 0 r
.34307 .6092 .35789 .60546 .37927 .6265 .36525 .61532 Metetra
.153 .547 .926 r
.36525 .61532 .37927 .6265 .40114 .64948 .38776 .6222 Metetra
.507 .529 .814 r
.38776 .6222 .40114 .64948 .42379 .66604 .41076 .62597 Metetra
.575 .503 .737 r
.41076 .62597 .42379 .66604 .44716 .67335 .43422 .62543 Metetra
.603 .498 .707 r
.43422 .62543 .44716 .67335 .47107 .67161 .45806 .62072 Metetra
.626 .506 .697 r
.45806 .62072 .47107 .67161 .49535 .66058 .4822 .61174 Metetra
.654 .528 .698 r
.4822 .61174 .49535 .66058 .51979 .63862 .50655 .59774 Metetra
.694 .572 .713 r
.50655 .59774 .51979 .63862 .54418 .60504 .53101 .57833 Metetra
.753 .656 .754 r
.53101 .57833 .54418 .60504 .56832 .56435 .55548 .55547 Metetra
.827 .848 .864 r
.55548 .55547 .56832 .56435 .59227 .5279 .57997 .53441 Metetra
.57997 .53441 .59227 .5279 .61649 .50878 .60468 .52138 Metetra
.352 0 0 r
.60468 .52138 .61649 .50878 .64157 .51294 .62987 .51928 Metetra
.459 0 0 r
.62987 .51928 .64157 .51294 .6678 .53468 .6557 .52535 Metetra
.085 .533 .905 r
.6557 .52535 .6678 .53468 .69493 .56099 .68206 .53335 Metetra
.5 .532 .821 r
.68206 .53335 .69493 .56099 .72243 .58039 .70872 .53799 Metetra
.576 .503 .736 r
.70872 .53799 .72243 .58039 .74982 .58814 .73549 .5372 Metetra
.606 .499 .706 r
.73549 .5372 .74982 .58814 .7769 .58478 .76225 .5313 Metetra
.627 .507 .696 r
.76225 .5313 .7769 .58478 .80351 .57185 .78896 .52101 Metetra
.652 .527 .699 r
.78896 .52101 .80351 .57185 .82944 .54945 .8155 .50635 Metetra
.687 .568 .715 r
.8155 .50635 .82944 .54945 .85443 .51725 .84176 .48712 Metetra
.742 .648 .755 r
.84176 .48712 .85443 .51725 .87852 .47812 .86774 .46454 Metetra
.815 .823 .856 r
.86774 .46454 .87852 .47812 .90256 .44079 .89382 .44262 Metetra
.517 .909 .782 r
.89382 .44262 .90256 .44079 .9281 .41738 .92071 .42711 Metetra
.129 0 0 r
.30481 .62374 .32088 .60929 .34307 .6092 .32776 .61487 Metetra
.379 .832 .731 r
.32776 .61487 .34307 .6092 .36525 .61532 .35097 .60412 Metetra
.718 .789 .908 r
.35097 .60412 .36525 .61532 .38776 .6222 .37434 .59312 Metetra
.665 .6 .772 r
.37434 .59312 .38776 .6222 .41076 .62597 .39783 .58296 Metetra
.634 .528 .717 r
.39783 .58296 .41076 .62597 .43422 .62543 .42145 .57397 Metetra
.618 .499 .695 r
.42145 .57397 .43422 .62543 .45806 .62072 .44522 .56608 Metetra
.609 .487 .689 r
.44522 .56608 .45806 .62072 .4822 .61174 .46917 .55931 Metetra
.603 .488 .695 r
.46917 .55931 .4822 .61174 .50655 .59774 .49332 .55389 Metetra
.598 .507 .722 r
.49332 .55389 .50655 .59774 .53101 .57833 .51772 .54994 Metetra
.596 .575 .8 r
.51772 .54994 .53101 .57833 .55548 .55547 .54239 .54693 Metetra
.525 .796 .995 r
.54239 .54693 .55548 .55547 .57997 .53441 .56735 .54336 Metetra
.12 0 0 r
.56735 .54336 .57997 .53441 .60468 .52138 .59254 .53738 Metetra
.212 0 0 r
.59254 .53738 .60468 .52138 .62987 .51928 .6179 .52809 Metetra
.6179 .52809 .62987 .51928 .6557 .52535 .64338 .51635 Metetra
.722 .856 .945 r
.64338 .51635 .6557 .52535 .68206 .53335 .66901 .504 Metetra
.671 .612 .781 r
.66901 .504 .68206 .53335 .70872 .53799 .69486 .49256 Metetra
.634 .528 .717 r
.69486 .49256 .70872 .53799 .73549 .5372 .72098 .4826 Metetra
.617 .497 .694 r
.72098 .4826 .73549 .5372 .76225 .5313 .74741 .47399 Metetra
.609 .487 .689 r
.74741 .47399 .76225 .5313 .78896 .52101 .77418 .46653 Metetra
.604 .49 .697 r
.77418 .46653 .78896 .52101 .8155 .50635 .8013 .4602 Metetra
.602 .51 .722 r
.8013 .4602 .8155 .50635 .84176 .48712 .82884 .45509 Metetra
.603 .568 .787 r
.82884 .45509 .84176 .48712 .86774 .46454 .85678 .45088 Metetra
.581 .746 .955 r
.85678 .45088 .86774 .46454 .89382 .44262 .88504 .44641 Metetra
.88504 .44641 .89382 .44262 .92071 .42711 .91342 .44 Metetra
.28831 .63739 .30481 .62374 .32776 .61487 .31209 .61983 Metetra
.882 .983 .825 r
.31209 .61983 .32776 .61487 .35097 .60412 .33646 .59266 Metetra
.844 .784 .794 r
.33646 .59266 .35097 .60412 .37434 .59312 .36081 .56459 Metetra
.747 .64 .742 r
.36081 .56459 .37434 .59312 .39783 .58296 .38487 .54135 Metetra
.68 .559 .712 r
.38487 .54135 .39783 .58296 .42145 .57397 .40869 .52452 Metetra
.635 .513 .697 r
.40869 .52452 .42145 .57397 .44522 .56608 .43242 .51371 Metetra
.597 .483 .695 r
.43242 .51371 .44522 .56608 .46917 .55931 .45619 .50895 Metetra
.548 .457 .704 r
.45619 .50895 .46917 .55931 .49332 .55389 .4801 .51145 Metetra
.461 .427 .734 r
.4801 .51145 .49332 .55389 .51772 .54994 .50433 .52199 Metetra
.265 .391 .804 r
.50433 .52199 .51772 .54994 .54239 .54693 .52905 .53798 Metetra
0 .288 .706 r
.52905 .53798 .54239 .54693 .56735 .54336 .55432 .55153 Metetra
.342 0 0 r
.55432 .55153 .56735 .54336 .59254 .53738 .57995 .55253 Metetra
.57995 .55253 .59254 .53738 .6179 .52809 .60552 .5361 Metetra
.769 .972 .691 r
.60552 .5361 .6179 .52809 .64338 .51635 .6308 .50692 Metetra
.888 .85 .8 r
.6308 .50692 .64338 .51635 .66901 .504 .65588 .47509 Metetra
.766 .66 .745 r
.65588 .47509 .66901 .504 .69486 .49256 .68108 .44858 Metetra
.682 .56 .711 r
.68108 .44858 .69486 .49256 .72098 .4826 .70668 .43014 Metetra
.63 .509 .696 r
.70668 .43014 .72098 .4826 .74741 .47399 .73282 .41904 Metetra
.595 .482 .695 r
.73282 .41904 .74741 .47399 .77418 .46653 .75962 .41415 Metetra
.558 .465 .706 r
.75962 .41415 .77418 .46653 .8013 .4602 .78724 .41551 Metetra
.501 .453 .735 r
.78724 .41551 .8013 .4602 .82884 .45509 .81589 .42359 Metetra
.395 .451 .801 r
.81589 .42359 .82884 .45509 .85678 .45088 .84561 .43688 Metetra
.134 .483 .9 r
.84561 .43688 .85678 .45088 .88504 .44641 .8759 .44942 Metetra
.224 0 0 r
.8759 .44942 .88504 .44641 .91342 .44 .9057 .45201 Metetra
.832 .998 .836 r
.27186 .6434 .28831 .63739 .31209 .61983 .29635 .6195 Metetra
.926 .876 .768 r
.29635 .6195 .31209 .61983 .33646 .59266 .32172 .58052 Metetra
.875 .769 .742 r
.32172 .58052 .33646 .59266 .36081 .56459 .34693 .54039 Metetra
.801 .682 .733 r
.34693 .54039 .36081 .56459 .38487 .54135 .37153 .50805 Metetra
.728 .612 .728 r
.37153 .50805 .38487 .54135 .40869 .52452 .39559 .4858 Metetra
.663 .559 .727 r
.39559 .4858 .40869 .52452 .43242 .51371 .41935 .47295 Metetra
.592 .511 .732 r
.41935 .47295 .43242 .51371 .45619 .50895 .44301 .46953 Metetra
.478 .449 .747 r
.44301 .46953 .45619 .50895 .4801 .51145 .46674 .47742 Metetra
.232 .325 .754 r
.46674 .47742 .4801 .51145 .50433 .52199 .49078 .49798 Metetra
0 .08 .64 r
.49078 .49798 .50433 .52199 .52905 .53798 .51544 .52734 Metetra
.604 .074 0 r
.51544 .52734 .52905 .53798 .55432 .55153 .54087 .55316 Metetra
.346 0 0 r
.54087 .55316 .55432 .55153 .57995 .55253 .5668 .55922 Metetra
.645 .949 .731 r
.5668 .55922 .57995 .55253 .60552 .5361 .59263 .53754 Metetra
.951 .94 .739 r
.59263 .53754 .60552 .5361 .6308 .50692 .61793 .49579 Metetra
.918 .815 .729 r
.61793 .49579 .6308 .50692 .65588 .47509 .6428 .45015 Metetra
.828 .705 .729 r
.6428 .45015 .65588 .47509 .68108 .44858 .66769 .41315 Metetra
.733 .616 .728 r
.66769 .41315 .68108 .44858 .70668 .43014 .69302 .38886 Metetra
.655 .553 .728 r
.69302 .38886 .70668 .43014 .73282 .41904 .71903 .37602 Metetra
.587 .508 .733 r
.71903 .37602 .73282 .41904 .75962 .41415 .74589 .37284 Metetra
.504 .466 .747 r
.74589 .37284 .75962 .41415 .78724 .41551 .77385 .3794 Metetra
.365 .405 .77 r
.77385 .3794 .78724 .41551 .81589 .42359 .80325 .39657 Metetra
.118 .309 .781 r
.80325 .39657 .81589 .42359 .84561 .43688 .83417 .42213 Metetra
0 .223 .731 r
.83417 .42213 .84561 .43688 .8759 .44942 .8659 .44682 Metetra
.215 0 0 r
.8659 .44682 .8759 .44942 .9057 .45201 .89674 .4559 Metetra
.831 .796 .819 r
.25628 .63264 .27186 .6434 .29635 .6195 .28105 .60782 Metetra
.876 .772 .743 r
.28105 .60782 .29635 .6195 .32172 .58052 .3068 .56721 Metetra
.873 .76 .735 r
.3068 .56721 .32172 .58052 .34693 .54039 .33237 .52543 Metetra
.847 .753 .759 r
.33237 .52543 .34693 .54039 .37153 .50805 .35726 .49183 Metetra
.8 .743 .801 r
.35726 .49183 .37153 .50805 .39559 .4858 .38153 .46879 Metetra
.724 .724 .849 r
.38153 .46879 .39559 .4858 .41935 .47295 .40543 .45557 Metetra
.588 .675 .901 r
.40543 .45557 .41935 .47295 .44301 .46953 .42918 .45222 Metetra
.263 .516 .906 r
.42918 .45222 .44301 .46953 .46674 .47742 .45294 .46067 Metetra
0 .134 .66 r
.45294 .46067 .46674 .47742 .49078 .49798 .47696 .48239 Metetra
.607 .126 0 r
.47696 .48239 .49078 .49798 .51544 .52734 .50159 .51334 Metetra
.545 .046 0 r
.50159 .51334 .51544 .52734 .54087 .55316 .52704 .54063 Metetra
.217 .578 .942 r
.52704 .54063 .54087 .55316 .5668 .55922 .55309 .54722 Metetra
.819 .824 .853 r
.55309 .54722 .5668 .55922 .59263 .53754 .57915 .52475 Metetra
.903 .803 .739 r
.57915 .52475 .59263 .53754 .61793 .49579 .60472 .48124 Metetra
.906 .787 .719 r
.60472 .48124 .61793 .49579 .6428 .45015 .62985 .43372 Metetra
.876 .777 .749 r
.62985 .43372 .6428 .45015 .66769 .41315 .65495 .39528 Metetra
.812 .76 .804 r
.65495 .39528 .66769 .41315 .69302 .38886 .68045 .37013 Metetra
.713 .725 .859 r
.68045 .37013 .69302 .38886 .71903 .37602 .70661 .35693 Metetra
.577 .665 .898 r
.70661 .35693 .71903 .37602 .74589 .37284 .73361 .35384 Metetra
.369 .557 .906 r
.73361 .35384 .74589 .37284 .77385 .3794 .76172 .36092 Metetra
.066 .372 .838 r
.76172 .36092 .77385 .3794 .80325 .39657 .79129 .3791 Metetra
0 .196 .72 r
.79129 .3791 .80325 .39657 .83417 .42213 .82243 .40608 Metetra
0 .209 .725 r
.82243 .40608 .83417 .42213 .8659 .44682 .85441 .4322 Metetra
.22 .541 .927 r
.85441 .4322 .8659 .44682 .89674 .4559 .88552 .44198 Metetra
.711 .61 .742 r
.24221 .59998 .25628 .63264 .28105 .60782 .26658 .58133 Metetra
.779 .667 .739 r
.26658 .58133 .28105 .60782 .3068 .56721 .29172 .55242 Metetra
.835 .757 .777 r
.29172 .55242 .3068 .56721 .33237 .52543 .31682 .52257 Metetra
.868 .91 .858 r
.31682 .52257 .33237 .52543 .35726 .49183 .34154 .49791 Metetra
.659 .969 .811 r
.34154 .49791 .35726 .49183 .38153 .46879 .36589 .48007 Metetra
.36589 .48007 .38153 .46879 .40543 .45557 .39005 .46865 Metetra
.232 0 0 r
.39005 .46865 .40543 .45557 .42918 .45222 .41416 .4637 Metetra
.434 0 0 r
.41416 .4637 .42918 .45222 .45294 .46067 .43832 .46647 Metetra
.571 .04 0 r
.43832 .46647 .45294 .46067 .47696 .48239 .46271 .47783 Metetra
.562 0 0 r
.46271 .47783 .47696 .48239 .50159 .51334 .48755 .49502 Metetra
.063 .387 .848 r
.48755 .49502 .50159 .51334 .52704 .54063 .51302 .50963 Metetra
.535 .539 .805 r
.51302 .50963 .52704 .54063 .55309 .54722 .53902 .51083 Metetra
.693 .596 .743 r
.53902 .51083 .55309 .54722 .57915 .52475 .5652 .49339 Metetra
.777 .658 .73 r
.5652 .49339 .57915 .52475 .60472 .48124 .5912 .46233 Metetra
.846 .755 .763 r
.5912 .46233 .60472 .48124 .62985 .43372 .61701 .42846 Metetra
.886 .923 .842 r
.61701 .42846 .62985 .43372 .65495 .39528 .64286 .4003 Metetra
.6 .937 .745 r
.64286 .4003 .65495 .39528 .68045 .37013 .66903 .38075 Metetra
.66903 .38075 .68045 .37013 .70661 .35693 .69569 .36901 Metetra
.232 0 0 r
.69569 .36901 .70661 .35693 .73361 .35384 .72296 .3639 Metetra
.365 0 0 r
.72296 .3639 .73361 .35384 .76172 .36092 .75104 .36543 Metetra
.437 0 0 r
.75104 .36543 .76172 .36092 .79129 .3791 .78016 .37415 Metetra
.314 0 0 r
.78016 .37415 .79129 .3791 .82243 .40608 .81036 .38843 Metetra
.179 .469 .889 r
.81036 .38843 .82243 .40608 .85441 .4322 .8412 .40193 Metetra
.513 .543 .823 r
.8412 .40193 .85441 .4322 .88552 .44198 .87161 .40481 Metetra
.612 .503 .706 r
.22944 .55152 .24221 .59998 .26658 .58133 .25284 .54402 Metetra
.625 .547 .747 r
.25284 .54402 .26658 .58133 .29172 .55242 .27646 .53646 Metetra
.656 .723 .899 r
.27646 .53646 .29172 .55242 .31682 .52257 .30029 .52884 Metetra
.30029 .52884 .31682 .52257 .34154 .49791 .32433 .52114 Metetra
.301 0 .064 r
.32433 .52114 .34154 .49791 .36589 .48007 .3486 .51337 Metetra
.383 .014 .209 r
.3486 .51337 .36589 .48007 .39005 .46865 .37309 .50553 Metetra
.401 .045 .242 r
.37309 .50553 .39005 .46865 .41416 .4637 .3978 .49761 Metetra
.387 .02 .215 r
.3978 .49761 .41416 .4637 .43832 .46647 .42275 .48963 Metetra
.302 0 .067 r
.42275 .48963 .43832 .46647 .46271 .47783 .44792 .48157 Metetra
.265 .766 .73 r
.44792 .48157 .46271 .47783 .48755 .49502 .47334 .47343 Metetra
.651 .671 .855 r
.47334 .47343 .48755 .49502 .51302 .50963 .49899 .46522 Metetra
.619 .525 .726 r
.49899 .46522 .51302 .50963 .53902 .51083 .52489 .45693 Metetra
.61 .495 .698 r
.52489 .45693 .53902 .51083 .5652 .49339 .55103 .44856 Metetra
.619 .525 .726 r
.55103 .44856 .5652 .49339 .5912 .46233 .57742 .44011 Metetra
.651 .671 .855 r
.57742 .44011 .5912 .46233 .61701 .42846 .60407 .43158 Metetra
.265 .766 .73 r
.60407 .43158 .61701 .42846 .64286 .4003 .63097 .42297 Metetra
.302 0 .067 r
.63097 .42297 .64286 .4003 .66903 .38075 .65813 .41427 Metetra
.387 .02 .215 r
.65813 .41427 .66903 .38075 .69569 .36901 .68556 .40549 Metetra
.401 .045 .242 r
.68556 .40549 .69569 .36901 .72296 .3639 .71325 .39662 Metetra
.383 .014 .209 r
.71325 .39662 .72296 .3639 .75104 .36543 .74122 .38767 Metetra
.301 0 .064 r
.74122 .38767 .75104 .36543 .78016 .37415 .76946 .37863 Metetra
.76946 .37863 .78016 .37415 .81036 .38843 .79799 .36949 Metetra
.656 .723 .899 r
.79799 .36949 .81036 .38843 .8412 .40193 .8268 .36027 Metetra
.625 .547 .747 r
.8268 .36027 .8412 .40193 .87161 .40481 .8559 .35095 Metetra
.522 .446 .712 r
.21672 .50325 .22944 .55152 .25284 .54402 .23907 .50662 Metetra
.342 .379 .755 r
.23907 .50662 .25284 .54402 .27646 .53646 .26096 .52026 Metetra
0 .274 .763 r
.26096 .52026 .27646 .53646 .30029 .52884 .28327 .53528 Metetra
.557 .032 0 r
.28327 .53528 .30029 .52884 .32433 .52114 .30643 .54531 Metetra
.496 .083 .186 r
.30643 .54531 .32433 .52114 .3486 .51337 .33049 .54823 Metetra
.436 .066 .236 r
.33049 .54823 .3486 .51337 .37309 .50553 .35528 .54423 Metetra
.359 .005 .221 r
.35528 .54423 .37309 .50553 .3978 .49761 .38066 .53316 Metetra
.199 0 .121 r
.38066 .53316 .3978 .49761 .42275 .48963 .40653 .51374 Metetra
.40653 .51374 .42275 .48963 .44792 .48157 .43271 .48542 Metetra
.911 .975 .787 r
.43271 .48542 .44792 .48157 .47334 .47343 .45894 .45156 Metetra
.815 .722 .762 r
.45894 .45156 .47334 .47343 .49899 .46522 .48497 .42083 Metetra
.674 .557 .714 r
.48497 .42083 .49899 .46522 .52489 .45693 .51084 .40335 Metetra
.55 .458 .703 r
.51084 .40335 .52489 .45693 .55103 .44856 .53687 .40375 Metetra
.41 .397 .734 r
.53687 .40375 .55103 .44856 .57742 .44011 .56345 .41759 Metetra
.105 .365 .829 r
.56345 .41759 .57742 .44011 .60407 .43158 .59074 .43479 Metetra
.503 0 0 r
.59074 .43479 .60407 .43158 .63097 .42297 .61857 .4466 Metetra
.481 .054 .151 r
.61857 .4466 .63097 .42297 .65813 .41427 .64668 .44948 Metetra
.423 .053 .229 r
.64668 .44948 .65813 .41427 .68556 .40549 .6749 .44388 Metetra
.358 .007 .227 r
.6749 .44388 .68556 .40549 .71325 .39662 .70305 .43099 Metetra
.239 0 .158 r
.70305 .43099 .71325 .39662 .74122 .38767 .73097 .41087 Metetra
.73097 .41087 .74122 .38767 .76946 .37863 .75843 .38325 Metetra
.811 .982 .703 r
.75843 .38325 .76946 .37863 .79799 .36949 .78541 .35024 Metetra
.848 .784 .789 r
.78541 .35024 .79799 .36949 .8268 .36027 .81236 .31848 Metetra
.698 .588 .728 r
.81236 .31848 .8268 .36027 .8559 .35095 .84025 .29733 Metetra
.39 .435 .788 r
.20256 .47029 .21672 .50325 .23907 .50662 .22431 .47949 Metetra
0 .072 .635 r
.22431 .47949 .23907 .50662 .26096 .52026 .24514 .50473 Metetra
.682 .182 0 r
.24514 .50473 .26096 .52026 .28327 .53528 .26647 .53242 Metetra
.69 .151 0 r
.26647 .53242 .28327 .53528 .30643 .54531 .28905 .55253 Metetra
.531 .002 0 r
.28905 .55253 .30643 .54531 .33049 .54823 .31296 .56161 Metetra
.31 0 0 r
.31296 .56161 .33049 .54823 .35528 .54423 .33795 .55979 Metetra
.33795 .55979 .35528 .54423 .38066 .53316 .3638 .54681 Metetra
.609 .902 .616 r
.3638 .54681 .38066 .53316 .40653 .51374 .39036 .5207 Metetra
.93 .97 .745 r
.39036 .5207 .40653 .51374 .43271 .48542 .41733 .48071 Metetra
.939 .854 .731 r
.41733 .48071 .43271 .48542 .45894 .45156 .44427 .43237 Metetra
.868 .748 .729 r
.44427 .43237 .45894 .45156 .48497 .42083 .47074 .38925 Metetra
.737 .639 .751 r
.47074 .38925 .48497 .42083 .51084 .40335 .49672 .36675 Metetra
.486 .48 .776 r
.49672 .36675 .51084 .40335 .53687 .40375 .5227 .37181 Metetra
.052 .238 .735 r
.5227 .37181 .53687 .40375 .56345 .41759 .54932 .39777 Metetra
0 .005 .555 r
.54932 .39777 .56345 .41759 .59074 .43479 .57686 .42932 Metetra
.601 .037 0 r
.57686 .42932 .59074 .43479 .61857 .4466 .60517 .45275 Metetra
.477 0 0 r
.60517 .45275 .61857 .4466 .64668 .44948 .63384 .46229 Metetra
.252 0 0 r
.63384 .46229 .64668 .44948 .6749 .44388 .66257 .45849 Metetra
.66257 .45849 .6749 .44388 .70305 .43099 .6911 .44317 Metetra
.6911 .44317 .70305 .43099 .73097 .41087 .71914 .41648 Metetra
.858 .979 .681 r
.71914 .41648 .73097 .41087 .75843 .38325 .74635 .37812 Metetra
.958 .915 .726 r
.74635 .37812 .75843 .38325 .78541 .35024 .77269 .33162 Metetra
.901 .797 .735 r
.77269 .33162 .78541 .35024 .81236 .31848 .79883 .28741 Metetra
.771 .674 .756 r
.79883 .28741 .81236 .31848 .84025 .29733 .82623 .2598 Metetra
.002 .456 .866 r
.1862 .45786 .20256 .47029 .22431 .47949 .20805 .46632 Metetra
.665 .142 0 r
.20805 .46632 .22431 .47949 .24514 .50473 .22895 .49023 Metetra
.675 .164 0 r
.22895 .49023 .24514 .50473 .26647 .53242 .25033 .51646 Metetra
0 .121 .62 r
.25033 .51646 .26647 .53242 .28905 .55253 .27298 .53537 Metetra
.196 .51 .912 r
.27298 .53537 .28905 .55253 .31296 .56161 .29697 .54365 Metetra
.543 .678 .926 r
.29697 .54365 .31296 .56161 .33795 .55979 .32207 .54145 Metetra
.709 .732 .868 r
.32207 .54145 .33795 .55979 .3638 .54681 .34806 .52851 Metetra
.805 .752 .803 r
.34806 .52851 .3638 .54681 .39036 .5207 .3748 .50293 Metetra
.86 .759 .75 r
.3748 .50293 .39036 .5207 .41733 .48071 .40203 .46399 Metetra
.886 .765 .724 r
.40203 .46399 .41733 .48071 .44427 .43237 .42926 .41699 Metetra
.883 .78 .742 r
.42926 .41699 .44427 .43237 .47074 .38925 .45602 .37498 Metetra
.808 .801 .845 r
.45602 .37498 .47074 .38925 .49672 .36675 .48223 .35282 Metetra
.302 .617 .957 r
.48223 .35282 .49672 .36675 .5227 .37181 .50833 .35723 Metetra
0 .058 .561 r
.50833 .35723 .5227 .37181 .54932 .39777 .53497 .38176 Metetra
0 0 .491 r
.53497 .38176 .54932 .39777 .57686 .42932 .5625 .41165 Metetra
0 .211 .723 r
.5625 .41165 .57686 .42932 .60517 .45275 .59081 .43369 Metetra
.273 .532 .915 r
.59081 .43369 .60517 .45275 .63384 .46229 .61956 .44235 Metetra
.575 .684 .915 r
.61956 .44235 .63384 .46229 .66257 .45849 .64843 .43817 Metetra
.72 .741 .868 r
.64843 .43817 .66257 .45849 .6911 .44317 .67717 .42292 Metetra
.808 .769 .817 r
.67717 .42292 .6911 .44317 .71914 .41648 .70549 .39672 Metetra
.868 .784 .767 r
.70549 .39672 .71914 .41648 .74635 .37812 .73306 .35929 Metetra
.901 .795 .734 r
.73306 .35929 .74635 .37812 .77269 .33162 .75984 .31399 Metetra
.904 .809 .744 r
.75984 .31399 .77269 .33162 .79883 .28741 .78642 .27088 Metetra
.838 .822 .833 r
.78642 .27088 .79883 .28741 .82623 .2598 .81417 .24374 Metetra
.278 0 0 r
.16776 .46154 .1862 .45786 .20805 .46632 .19036 .46408 Metetra
.539 0 0 r
.19036 .46408 .20805 .46632 .22895 .49023 .21239 .47646 Metetra
0 .266 .726 r
.21239 .47646 .22895 .49023 .25033 .51646 .23481 .49016 Metetra
.326 .469 .85 r
.23481 .49016 .25033 .51646 .27298 .53537 .25816 .49904 Metetra
.513 .501 .78 r
.25816 .49904 .27298 .53537 .29697 .54365 .2825 .5011 Metetra
.586 .516 .742 r
.2825 .5011 .29697 .54365 .32207 .54145 .30765 .49651 Metetra
.635 .537 .726 r
.30765 .49651 .32207 .54145 .34806 .52851 .3335 .48513 Metetra
.686 .571 .72 r
.3335 .48513 .34806 .52851 .3748 .50293 .35995 .46574 Metetra
.745 .623 .724 r
.35995 .46574 .3748 .50293 .40203 .46399 .38684 .43779 Metetra
.807 .698 .745 r
.38684 .43779 .40203 .46399 .42926 .41699 .41386 .40452 Metetra
.86 .82 .808 r
.41386 .40452 .42926 .41699 .45602 .37498 .44066 .37424 Metetra
.739 .977 .92 r
.44066 .37424 .45602 .37498 .48223 .35282 .46714 .35666 Metetra
.126 0 0 r
.46714 .35666 .48223 .35282 .50833 .35723 .49355 .35623 Metetra
.46 0 0 r
.49355 .35623 .50833 .35723 .53497 .38176 .52036 .36869 Metetra
0 .305 .762 r
.52036 .36869 .53497 .38176 .5625 .41165 .54782 .38435 Metetra
.332 .471 .85 r
.54782 .38435 .5625 .41165 .59081 .43369 .57591 .39482 Metetra
.519 .502 .777 r
.57591 .39482 .59081 .43369 .61956 .44235 .60441 .39671 Metetra
.594 .518 .739 r
.60441 .39671 .61956 .44235 .64843 .43817 .63314 .39046 Metetra
.639 .539 .725 r
.63314 .39046 .64843 .43817 .67717 .42292 .66192 .37721 Metetra
.683 .571 .723 r
.66192 .37721 .67717 .42292 .70549 .39672 .69057 .35703 Metetra
.737 .622 .73 r
.69057 .35703 .70549 .39672 .73306 .35929 .71889 .32964 Metetra
.802 .699 .752 r
.71889 .32964 .73306 .35929 .75984 .31399 .74681 .29707 Metetra
.86 .821 .809 r
.74681 .29707 .75984 .31399 .78642 .27088 .77471 .26569 Metetra
.787 .973 .914 r
.77471 .26569 .78642 .27088 .81417 .24374 .80341 .24447 Metetra
.079 0 0 r
.14788 .47336 .16776 .46154 .19036 .46408 .17164 .46724 Metetra
.135 .679 .708 r
.17164 .46724 .19036 .46408 .21239 .47646 .19548 .46293 Metetra
.565 .748 .963 r
.19548 .46293 .21239 .47646 .23481 .49016 .21957 .45877 Metetra
.599 .576 .798 r
.21957 .45877 .23481 .49016 .25816 .49904 .24404 .4536 Metetra
.598 .511 .727 r
.24404 .4536 .25816 .49904 .2825 .5011 .2689 .44707 Metetra
.599 .488 .699 r
.2689 .44707 .2825 .5011 .30765 .49651 .29411 .43923 Metetra
.604 .485 .69 r
.29411 .43923 .30765 .49651 .3335 .48513 .31966 .43006 Metetra
.616 .497 .695 r
.31966 .43006 .3335 .48513 .35995 .46574 .34553 .41932 Metetra
.638 .534 .72 r
.34553 .41932 .35995 .46574 .38684 .43779 .37169 .4069 Metetra
.678 .623 .787 r
.37169 .4069 .38684 .43779 .41386 .40452 .39809 .39335 Metetra
.719 .84 .939 r
.39809 .39335 .41386 .40452 .44066 .37424 .42466 .38025 Metetra
.282 .767 .677 r
.42466 .38025 .44066 .37424 .46714 .35666 .45137 .3695 Metetra
.104 0 0 r
.45137 .3695 .46714 .35666 .49355 .35623 .47826 .36201 Metetra
.47826 .36201 .49355 .35623 .52036 .36869 .50543 .3569 Metetra
.536 .784 .989 r
.50543 .3569 .52036 .36869 .54782 .38435 .53295 .35228 Metetra
.599 .584 .808 r
.53295 .35228 .54782 .38435 .57591 .39482 .56082 .34655 Metetra
.598 .511 .727 r
.56082 .34655 .57591 .39482 .60441 .39671 .589 .33912 Metetra
.6 .487 .697 r
.589 .33912 .60441 .39671 .63314 .39046 .61747 .33009 Metetra
.605 .485 .69 r
.61747 .33009 .63314 .39046 .66192 .37721 .64619 .31968 Metetra
.615 .498 .697 r
.64619 .31968 .66192 .37721 .69057 .35703 .67513 .30789 Metetra
.635 .533 .721 r
.67513 .30789 .69057 .35703 .71889 .32964 .70426 .29465 Metetra
.669 .611 .781 r
.70426 .29465 .71889 .32964 .74681 .29707 .73356 .28031 Metetra
.713 .795 .915 r
.73356 .28031 .74681 .29707 .77471 .26569 .76311 .26607 Metetra
.444 .879 .839 r
.76311 .26607 .77471 .26569 .80341 .24447 .79305 .25367 Metetra
.12715 .48689 .14788 .47336 .17164 .46724 .15228 .47138 Metetra
.809 .991 .876 r
.15228 .47138 .17164 .46724 .19548 .46293 .17824 .44923 Metetra
.809 .79 .835 r
.17824 .44923 .19548 .46293 .21957 .45877 .20429 .42638 Metetra
.717 .627 .756 r
.20429 .42638 .21957 .45877 .24404 .4536 .23006 .40679 Metetra
.655 .54 .712 r
.23006 .40679 .24404 .4536 .2689 .44707 .25553 .39156 Metetra
.616 .495 .692 r
.25553 .39156 .2689 .44707 .29411 .43923 .28082 .38045 Metetra
.587 .469 .686 r
.28082 .38045 .29411 .43923 .31966 .43006 .30603 .3735 Metetra
.553 .453 .695 r
.30603 .3735 .31966 .43006 .34553 .41932 .3312 .37152 Metetra
.502 .447 .728 r
.3312 .37152 .34553 .41932 .37169 .4069 .35644 .37502 Metetra
.408 .476 .819 r
.35644 .37502 .37169 .4069 .39809 .39335 .38197 .38218 Metetra
.146 .584 .93 r
.38197 .38218 .39809 .39335 .42466 .38025 .40809 .38756 Metetra
.101 0 0 r
.40809 .38756 .42466 .38025 .45137 .3695 .43496 .38429 Metetra
.43496 .38429 .45137 .3695 .47826 .36201 .46243 .36908 Metetra
.686 .968 .757 r
.46243 .36908 .47826 .36201 .50543 .3569 .49017 .34511 Metetra
.842 .855 .854 r
.49017 .34511 .50543 .3569 .53295 .35228 .51794 .3192 Metetra
.732 .645 .762 r
.51794 .3192 .53295 .35228 .56082 .34655 .54573 .29688 Metetra
.656 .54 .711 r
.54573 .29688 .56082 .34655 .589 .33912 .57366 .28004 Metetra
.612 .491 .69 r
.57366 .28004 .589 .33912 .61747 .33009 .60188 .26822 Metetra
.585 .468 .687 r
.60188 .26822 .61747 .33009 .64619 .31968 .6305 .26065 Metetra
.56 .459 .697 r
.6305 .26065 .64619 .31968 .67513 .30789 .65964 .25733 Metetra
.526 .463 .728 r
.65964 .25733 .67513 .30789 .70426 .29465 .68947 .25857 Metetra
.473 .497 .803 r
.68947 .25857 .70426 .29465 .73356 .28031 .72005 .26329 Metetra
.353 .622 .953 r
.72005 .26329 .73356 .28031 .76311 .26607 .7512 .26739 Metetra
.7512 .26739 .76311 .26607 .79305 .25367 .7824 .2646 Metetra
.745 .988 .783 r
.10606 .49801 .12715 .48689 .15228 .47138 .13258 .4737 Metetra
.925 .913 .787 r
.13258 .4737 .15228 .47138 .17824 .44923 .1607 .4351 Metetra
.869 .774 .754 r
.1607 .4351 .17824 .44923 .20429 .42638 .18873 .39539 Metetra
.782 .661 .729 r
.18873 .39539 .20429 .42638 .23006 .40679 .21581 .36303 Metetra
.703 .577 .711 r
.21581 .36303 .23006 .40679 .25553 .39156 .24191 .34021 Metetra
.638 .518 .7 r
.24191 .34021 .25553 .39156 .28082 .38045 .26731 .32625 Metetra
.574 .471 .699 r
.26731 .32625 .28082 .38045 .30603 .3735 .29221 .3212 Metetra
.48 .416 .708 r
.29221 .3212 .30603 .3735 .3312 .37152 .3167 .32681 Metetra
.29 .325 .725 r
.3167 .32681 .3312 .37152 .35644 .37502 .34098 .34438 Metetra
0 .152 .692 r
.34098 .34438 .35644 .37502 .38197 .38218 .36553 .37023 Metetra
.53 0 0 r
.36553 .37023 .38197 .38218 .40809 .38756 .39106 .39269 Metetra
.304 0 0 r
.39106 .39269 .40809 .38756 .43496 .38429 .41801 .39643 Metetra
.493 .852 .605 r
.41801 .39643 .43496 .38429 .46243 .36908 .44612 .37396 Metetra
.928 .972 .744 r
.44612 .37396 .46243 .36908 .49017 .34511 .47458 .3325 Metetra
.914 .827 .746 r
.47458 .3325 .49017 .34511 .51794 .3192 .5028 .28735 Metetra
.807 .683 .727 r
.5028 .28735 .51794 .3192 .54573 .29688 .53068 .25035 Metetra
.706 .578 .709 r
.53068 .25035 .54573 .29688 .57366 .28004 .55848 .22532 Metetra
.631 .512 .699 r
.55848 .22532 .57366 .28004 .60188 .26822 .58652 .21108 Metetra
.57 .469 .7 r
.58652 .21108 .60188 .26822 .6305 .26065 .61503 .20592 Metetra
.502 .433 .712 r
.61503 .20592 .6305 .26065 .65964 .25733 .6443 .20993 Metetra
.39 .389 .738 r
.6443 .20993 .65964 .25733 .68947 .25857 .67464 .22391 Metetra
.189 .331 .778 r
.67464 .22391 .68947 .25857 .72005 .26329 .70624 .24574 Metetra
0 .291 .781 r
.70624 .24574 .72005 .26329 .7512 .26739 .73876 .26671 Metetra
.187 0 0 r
.73876 .26671 .7512 .26739 .7824 .2646 .77108 .27292 Metetra
.894 .961 .831 r
.08518 .50237 .10606 .49801 .13258 .4737 .1129 .47131 Metetra
.929 .839 .734 r
.1129 .47131 .13258 .4737 .1607 .4351 .14288 .4203 Metetra
.889 .76 .714 r
.14288 .4203 .1607 .4351 .18873 .39539 .1726 .36809 Metetra
.825 .691 .716 r
.1726 .36809 .18873 .39539 .21581 .36303 .20082 .3264 Metetra
.749 .625 .722 r
.20082 .3264 .21581 .36303 .24191 .34021 .2275 .29807 Metetra
.668 .563 .727 r
.2275 .29807 .24191 .34021 .26731 .32625 .25304 .28203 Metetra
.567 .497 .736 r
.25304 .28203 .26731 .32625 .29221 .3212 .27772 .27829 Metetra
.378 .388 .744 r
.27772 .27829 .29221 .3212 .3167 .32681 .30167 .28931 Metetra
0 .14 .671 r
.30167 .28931 .3167 .32681 .34098 .34438 .32513 .31705 Metetra
0 0 .376 r
.32513 .31705 .34098 .34438 .36553 .37023 .34879 .35669 Metetra
.74 .239 0 r
.34879 .35669 .36553 .37023 .39106 .39269 .37374 .39202 Metetra
.361 0 0 r
.37374 .39202 .39106 .39269 .41801 .39643 .40073 .40109 Metetra
.814 1 .816 r
.40073 .40109 .41801 .39643 .44612 .37396 .42943 .373 Metetra
.964 .896 .709 r
.42943 .373 .44612 .37396 .47458 .3325 .45867 .31828 Metetra
.932 .801 .693 r
.45867 .31828 .47458 .3325 .5028 .28735 .48746 .25884 Metetra
.856 .716 .707 r
.48746 .25884 .5028 .28735 .53068 .25035 .5156 .21113 Metetra
.757 .63 .72 r
.5156 .21113 .53068 .25035 .55848 .22532 .54343 .18018 Metetra
.658 .556 .728 r
.54343 .18018 .55848 .22532 .58652 .21108 .5714 .16415 Metetra
.56 .493 .737 r
.5714 .16415 .58652 .21108 .61503 .20592 .59987 .16067 Metetra
.431 .422 .749 r
.59987 .16067 .61503 .20592 .6443 .20993 .62921 .16986 Metetra
.207 .307 .747 r
.62921 .16986 .6443 .20993 .67464 .22391 .65986 .193 Metetra
0 .14 .684 r
.65986 .193 .67464 .22391 .70624 .24574 .69212 .2274 Metetra
0 .052 .586 r
.69212 .2274 .70624 .24574 .73876 .26671 .72558 .261 Metetra
0 .337 .677 r
.72558 .261 .73876 .26671 .77108 .27292 .75875 .27403 Metetra
.87 .825 .8 r
.06556 .49323 .08518 .50237 .1129 .47131 .09389 .45976 Metetra
.902 .777 .714 r
.09389 .45976 .1129 .47131 .14288 .4203 .12482 .40444 Metetra
.891 .753 .703 r
.12482 .40444 .14288 .4203 .1726 .36809 .15542 .34794 Metetra
.86 .735 .725 r
.15542 .34794 .1726 .36809 .20082 .3264 .18428 .30307 Metetra
.806 .713 .762 r
.18428 .30307 .20082 .3264 .2275 .29807 .21135 .27282 Metetra
.722 .678 .806 r
.21135 .27282 .2275 .29807 .25304 .28203 .23706 .25599 Metetra
.565 .608 .855 r
.23706 .25599 .25304 .28203 .27772 .27829 .26174 .25256 Metetra
.158 .386 .835 r
.26174 .25256 .27772 .27829 .30167 .28931 .28552 .26524 Metetra
0 0 .469 r
.28552 .26524 .30167 .28931 .32513 .31705 .30863 .29623 Metetra
.777 .327 0 r
.30863 .29623 .32513 .31705 .34879 .35669 .33186 .34036 Metetra
.76 .278 0 r
.33186 .34036 .34879 .35669 .37374 .39202 .3565 .37992 Metetra
0 .41 .812 r
.3565 .37992 .37374 .39202 .40073 .40109 .38353 .39069 Metetra
.866 .871 .84 r
.38353 .39069 .40073 .40109 .42943 .373 .41265 .36057 Metetra
.935 .813 .7 r
.41265 .36057 .42943 .373 .45867 .31828 .44248 .30123 Metetra
.928 .782 .679 r
.44248 .30123 .45867 .31828 .48746 .25884 .47181 .23688 Metetra
.892 .76 .709 r
.47181 .23688 .48746 .25884 .5156 .21113 .50032 .18551 Metetra
.821 .728 .762 r
.50032 .18551 .5156 .21113 .54343 .18018 .52839 .1525 Metetra
.71 .676 .815 r
.52839 .1525 .54343 .18018 .5714 .16415 .55649 .13576 Metetra
.553 .598 .852 r
.55649 .13576 .5714 .16415 .59987 .16067 .58504 .13268 Metetra
.3 .459 .851 r
.58504 .13268 .59987 .16067 .62921 .16986 .61445 .14343 Metetra
0 .22 .742 r
.61445 .14343 .62921 .16986 .65986 .193 .64521 .16944 Metetra
0 .004 .565 r
.64521 .16944 .65986 .193 .69212 .2274 .67767 .20787 Metetra
0 0 .537 r
.67767 .20787 .69212 .2274 .72558 .261 .71143 .24559 Metetra
0 .404 .845 r
.71143 .24559 .72558 .261 .75875 .27403 .74497 .26078 Metetra
.772 .667 .747 r
.04849 .46319 .06556 .49323 .09389 .45976 .07639 .43413 Metetra
.841 .705 .713 r
.07639 .43413 .09389 .45976 .12482 .40444 .10658 .38712 Metetra
.875 .752 .724 r
.10658 .38712 .12482 .40444 .15542 .34794 .13658 .33891 Metetra
.892 .824 .774 r
.13658 .33891 .15542 .34794 .18428 .30307 .16514 .30012 Metetra
.869 .921 .86 r
.16514 .30012 .18428 .30307 .21135 .27282 .19219 .27332 Metetra
.701 .97 .929 r
.19219 .27332 .21135 .27282 .23706 .25599 .2181 .25762 Metetra
.197 .727 .78 r
.2181 .25762 .23706 .25599 .26174 .25256 .24314 .25303 Metetra
.408 0 0 r
.24314 .25303 .26174 .25256 .28552 .26524 .26739 .26176 Metetra
.697 .157 0 r
.26739 .26176 .28552 .26524 .30863 .29623 .29106 .28552 Metetra
.77 .265 0 r
.29106 .28552 .30863 .29623 .33186 .34036 .31484 .31988 Metetra
.549 .08 0 r
.31484 .31988 .33186 .34036 .3565 .37992 .33988 .35024 Metetra
.372 .496 .855 r
.33988 .35024 .3565 .37992 .38353 .39069 .36707 .35699 Metetra
.753 .66 .759 r
.36707 .35699 .38353 .39069 .41265 .36057 .3962 .33045 Metetra
.854 .711 .704 r
.3962 .33045 .41265 .36057 .44248 .30123 .42609 .27997 Metetra
.9 .765 .704 r
.42609 .27997 .44248 .30123 .47181 .23688 .45565 .22512 Metetra
.92 .846 .754 r
.45565 .22512 .47181 .23688 .50032 .18551 .48454 .18073 Metetra
.878 .95 .853 r
.48454 .18073 .50032 .18551 .52839 .1525 .51303 .15141 Metetra
.643 .962 .916 r
.51303 .15141 .52839 .1525 .55649 .13576 .54154 .13554 Metetra
.201 .73 .808 r
.54154 .13554 .55649 .13576 .58504 .13268 .57042 .131 Metetra
.21 0 0 r
.57042 .131 .58504 .13268 .61445 .14343 .60002 .13788 Metetra
.46 0 0 r
.60002 .13788 .61445 .14343 .64521 .16944 .63073 .15728 Metetra
.502 0 0 r
.63073 .15728 .64521 .16944 .67767 .20787 .66286 .18672 Metetra
0 .159 .689 r
.66286 .18672 .67767 .20787 .71143 .24559 .69613 .21531 Metetra
.334 .479 .856 r
.69613 .21531 .71143 .24559 .74497 .26078 .72937 .22538 Metetra
.656 .532 .701 r
.03454 .41119 .04849 .46319 .07639 .43413 .06077 .39361 Metetra
.724 .604 .723 r
.06077 .39361 .07639 .43413 .10658 .38712 .08818 .36822 Metetra
.805 .752 .804 r
.08818 .36822 .10658 .38712 .13658 .33891 .11569 .34204 Metetra
.803 .988 .886 r
.11569 .34204 .13658 .33891 .16514 .30012 .14271 .31972 Metetra
.14271 .31972 .16514 .30012 .19219 .27332 .16919 .30254 Metetra
.151 0 0 r
.16919 .30254 .19219 .27332 .2181 .25762 .19528 .29019 Metetra
.294 0 .064 r
.19528 .29019 .2181 .25762 .24314 .25303 .22111 .28271 Metetra
.382 0 .091 r
.22111 .28271 .24314 .25303 .26739 .26176 .2467 .28106 Metetra
.45 0 .021 r
.2467 .28106 .26739 .26176 .29106 .28552 .27216 .28586 Metetra
.395 0 0 r
.27216 .28586 .29106 .28552 .31484 .31988 .29783 .29497 Metetra
.309 .509 .889 r
.29783 .29497 .31484 .31988 .33988 .35024 .32423 .30203 Metetra
.548 .487 .739 r
.32423 .30203 .33988 .35024 .36707 .35699 .35177 .29891 Metetra
.639 .513 .694 r
.35177 .29891 .36707 .35699 .3962 .33045 .38039 .28173 Metetra
.712 .582 .707 r
.38039 .28173 .3962 .33045 .42609 .27997 .40956 .25423 Metetra
.803 .729 .783 r
.40956 .25423 .42609 .27997 .45565 .22512 .43878 .22451 Metetra
.819 .99 .873 r
.43878 .22451 .45565 .22512 .48454 .18073 .46786 .19903 Metetra
.46786 .19903 .48454 .18073 .51303 .15141 .49691 .18 Metetra
.182 0 0 r
.49691 .18 .51303 .15141 .54154 .13554 .52611 .16685 Metetra
.295 0 .057 r
.52611 .16685 .54154 .13554 .57042 .131 .55563 .15866 Metetra
.349 0 .044 r
.55563 .15866 .57042 .131 .60002 .13788 .58563 .15545 Metetra
.371 0 0 r
.58563 .15545 .60002 .13788 .63073 .15728 .61628 .15759 Metetra
.222 0 0 r
.61628 .15759 .63073 .15728 .66286 .18672 .64771 .16383 Metetra
.347 .565 .919 r
.64771 .16383 .66286 .18672 .69613 .21531 .67983 .16936 Metetra
.539 .503 .765 r
.67983 .16936 .69613 .21531 .72937 .22538 .71217 .16682 Metetra
.54 .431 .678 r
.02233 .34875 .03454 .41119 .06077 .39361 .04619 .34571 Metetra
.48 .437 .732 r
.04619 .34571 .06077 .39361 .08818 .36822 .06956 .34836 Metetra
.345 .59 .936 r
.06956 .34836 .08818 .36822 .11569 .34204 .09327 .35165 Metetra
.252 0 0 r
.09327 .35165 .11569 .34204 .14271 .31972 .1178 .35204 Metetra
.35 0 .082 r
.1178 .35204 .14271 .31972 .16919 .30254 .14321 .34841 Metetra
.347 0 .165 r
.14321 .34841 .16919 .30254 .19528 .29019 .16942 .34088 Metetra
.314 0 .17 r
.16942 .34088 .19528 .29019 .22111 .28271 .19634 .32939 Metetra
.228 0 .107 r
.19634 .32939 .22111 .28271 .2467 .28106 .22394 .31323 Metetra
.22394 .31323 .2467 .28106 .27216 .28586 .25216 .29203 Metetra
.754 .995 .828 r
.25216 .29203 .27216 .28586 .29783 .29497 .28072 .26764 Metetra
.755 .698 .797 r
.28072 .26764 .29783 .29497 .32423 .30203 .30919 .24486 Metetra
.629 .508 .696 r
.30919 .24486 .32423 .30203 .35177 .29891 .33728 .22943 Metetra
.551 .432 .67 r
.33728 .22943 .35177 .29891 .38039 .28173 .36504 .22401 Metetra
.496 .424 .705 r
.36504 .22401 .38039 .28173 .40956 .25423 .39286 .22603 Metetra
.414 .541 .876 r
.39286 .22603 .40956 .25423 .43878 .22451 .42116 .22977 Metetra
.163 0 0 r
.42116 .22977 .43878 .22451 .46786 .19903 .45012 .23037 Metetra
.338 0 .061 r
.45012 .23037 .46786 .19903 .49691 .18 .47968 .22592 Metetra
.341 0 .164 r
.47968 .22592 .49691 .18 .52611 .16685 .50973 .21673 Metetra
.313 0 .174 r
.50973 .21673 .52611 .16685 .55563 .15866 .54012 .20345 Metetra
.244 0 .122 r
.54012 .20345 .55563 .15866 .58563 .15545 .57075 .18611 Metetra
.053 0 0 r
.57075 .18611 .58563 .15545 .61628 .15759 .60148 .16453 Metetra
.588 .921 .7 r
.60148 .16453 .61628 .15759 .64771 .16383 .63224 .13984 Metetra
.78 .766 .84 r
.63224 .13984 .64771 .16383 .67983 .16936 .6631 .11571 Metetra
.648 .538 .716 r
.6631 .11571 .67983 .16936 .71217 .16682 .69439 .0974 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X00018b000`400?l00000o`00003oo`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o@3oool2000006T0oooo003k
0?ooo`80000000<0oooo000000000000J03oool00<h0oooo1@00000U0?ooo`<000000`3oool20000
06P0oooo003>0?ooo`050000003oool0oooo0?ooo`0000008`3oool2000000H0oooo00<000000?oo
o`000000I`3oool00<l0oooo00<000000?ooo`3oool08@3oool3000000P0oooo00@000000?ooo`3o
ool00000IP3oool00=00oooo00<000000?ooo`3oool07P3oool2000000/0oooo00@000000?ooo`3o
ool00000IP3oool00=40oooo00<000000?ooo`3oool06P3oool3000000d0oooo00D000000?ooo`3o
ool0oooo0000001U0?ooo`00dP3oool00`000000oooo0?ooo`0G0?ooo`800000403oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0680oooo003>0?ooo`050000003oool0oooo0?ooo`00
00005P3oool300000180oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1R0?ooo`00
c`3oool3000001D0oooo0P0000000`3oool000000?ooo`0C0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0H@3oool00>@0oooo0`0000040?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`1P0?ooo`00h@3oool3000001/0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`1P0?ooo`00g`3oool2000001h0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`1O0?ooo`00g03oool300000200oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`1O0?ooo`00fP3oool2000002<0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`1N0?ooo`00e`3oool3000002D0oooo00<000000?ooo`3oool01@3o
ool2000005l0oooo003E0?ooo`800000:03oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo05d0oooo003B0?ooo`<000000P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0G03oool00=00oooo0P0000060?ooo`030000003oool0oooo02@0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1K0?ooo`00c@3oool3000002l0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1K0?ooo`00b`3oool200000380oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`1J0?ooo`00b03oool3000003@0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`1I0?ooo`00aP3oool2000003L0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`D00000A@3oool00<<0oooo0`00000i0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool00000
04D0oooo00310?ooo`<00000>`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool0AP3oool00;h0oooo0`0000030?ooo`030000003oool0oooo03T0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`H00000103oool00`000000oooo
0?ooo`150?ooo`00_03oool200000480oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo04@0oooo002i0?ooo`<00000A03oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0@`3oool00;L0oooo0P0000170?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0
000004D0oooo002d0?ooo`<00000B@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00/0oooo0`0000160?ooo`00/P3oool2000004`0oooo00<000000?ooo`3oool0303oool200000003
0?ooo`000000oooo05@0oooo00230?ooo`@00000:03oool3000004h0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`1C0?ooo`00PP3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0280oooo0`0000020?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`1B0?ooo`00PP3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0200oooo0P00001D0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0D@3oool0
0880oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0M0?ooo`<00000E03oool30000
01<0oooo00<000000?ooo`3oool0D@3oool00880oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0K0?ooo`800000E@3oool200000080YHVg0P00000C0?ooo`030000003oool0oooo0500
oooo00220?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0603oool3000005H0oooo
00<000000:F9]`2URKL00P2URKL2000001<0oooo00<000000?ooo`3oool0D03oool00880oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0F0?ooo`800000E`3oool2000000D0YHVg0P00
000D0?ooo`030000003oool0oooo04l0oooo00230?ooo`@000005P3oool3000005L0oooo0P000007
0:F9]`8000005@3oool00`000000oooo0?ooo`1>0?ooo`00V`3oool3000005P0oooo00<000000:F9
]`2URKL01`2URKL00`000000YHVg0000000D0?ooo`030000003oool0oooo04h0oooo002H0?ooo`<0
00000`3oool00`000000oooo0?ooo`1D0?ooo`8000002@2URKL00`000000YHVg0000000E0?ooo`03
0000003oool0oooo04d0oooo002F0?ooo`800000F`3oool200000080alCG00<000000:F9]`2URKL0
1P2URKL00`000000YHVg0000000F0?ooo`030000003oool0oooo04`0oooo002C0?ooo`<00000G03o
ool00`000000alCG0<O4e`020<O4e`030000002URKL0YHVg00L0YHVg0P00000F0?ooo`800000C@3o
ool00940oooo0P00001N0?ooo`0300000037a=L0alCG00<0alCG00<000000:F9]`2URKL01`2URKL0
0`000000YHVg0000000E0?ooo`800000C@3oool008h0oooo0`0000140?ooo`D000005P3oool00`00
0000alCG0<O4e`040<O4e`030000002URKL0YHVg00L0YHVg00<000000:F9]`0000005`3oool00`00
0000oooo0?ooo`1:0?ooo`00S03oool200000480oooo1@000000101;00h0000005T02`1I00/50000
0100oooo0P0000080<O4e`030000002URKL0YHVg00H0YHVg00<000000:F9]`0000005`3oool00`00
0000oooo0?ooo`1:0?ooo`00R@3oool300000440oooo0`00000604/03P030000001I00/0F@0;00<0
F@0;1@00000<0?ooo`0300000037a=L0alCG00P0alCG00<000000:F9]`2URKL01P2URKL00`000000
YHVg0000000H0?ooo`030000003oool0oooo04T0oooo00270?ooo`8000000`3oool00`000000oooo
0?ooo`0l0?ooo`800000201;00h00`000000F@0;05T02`0805T02`D000001`3oool00`000000alCG
0<O4e`090<O4e`030000002URKL0YHVg00H0YHVg00@000000:F9]`2URKL00000603oool00`000000
oooo0?ooo`180?ooo`00Q03oool300000480oooo0P0000000`0^0000000004/03P0704/03P030000
001I00/0F@0;00P0F@0;00<0000005h000000000100000030?ooo`80000000<0U^^c00000037a=L0
2@37a=L00`000000YHVg0:F9]`060:F9]`040000002URKL0YHVg000001P0oooo00<000000?ooo`3o
ool0B03oool00880oooo0P0000130?ooo`8000000P0^00000`000000B`0>04/03P0604/03P030000
001I00/0F@0;00P0F@0;00<0000005h0001N00000P1N00020000000407D000000000oooo000000<0
U^^c00<000000<O4e`37a=L02@37a=L00`000000YHVg0:F9]`050:F9]`040000002URKL0YHVg0000
01T0oooo00<000000?ooo`3oool0A`3oool007l0oooo0`0000130?ooo`800000100^00000`000000
B`0>04/03P0604/03P030000001I00/0F@0;00L0F@0;00<0000005h0001N00001@1N00000`000000
M@000000000509K[/`0300000037a=L0alCG00P0alCG00<000000:F9]`2URKL01@2URKL010000000
YHVg0:F9]`00000J0?ooo`030000003oool0oooo04H0oooo001m0?ooo`800000A@3oool00`000000
;P0002h0000302h000030000001;00h0B`0>00H0B`0>00<0000005T02`1I00/01`1I00/00`000000
GP0005h0000605h0008000001P2Fjk<00`000000alCG0<O4e`080<O4e`030000002URKL0YHVg00D0
YHVg00D000000:F9]`2URKL0YHVg0000000I0?ooo`030000003oool0oooo04H0oooo001j0?ooo`<0
0000AP3oool00`000000;P0002h0000402h000030000001;00h0B`0>00H0B`0>00<0000005T02`1I
00/0101I00/7000000@0GP0000<0000009K[/`2Fjk<01`2Fjk<00`000000alCG0<O4e`080<O4e`03
0000002URKL0YHVg00@0YHVg00D000000:F9]`2URKL0YHVg0000000J0?ooo`030000003oool0oooo
04D0oooo001h0?ooo`800000B03oool2000000D0;P0000<0000004/03P1;00h01P1;00h00`000000
F@0;05T02`0500000080?P0O00<0000000d0000=00000P0=0008000000L0U^^c00<000000<O4e`37
a=L01`37a=L00`000000YHVg0:F9]`040:F9]`050000002URKL0YHVg0:F9]`0000006`3oool00`00
0000oooo0?ooo`140?ooo`00M@3oool300000080oooo00<000000?ooo`3oool0A03oool2000000H0
;P0000<0000004/03P1;00h0101;00h5000000H0?P0O00<0000000d0000=0000100=0003000000@0
C7GI1P0000000`2Fjk<000000<O4e`080<O4e`030000002URKL0YHVg00@0YHVg00D000000:F9]`2U
RKL0YHVg0000000K0?ooo`030000003oool0oooo04@0oooo001b0?ooo`<00000B`3oool3000000D0
;P0000<0000004/03P1;00h01@0000020500;0030000000n01l0?P0O00H0?P0O00<0000000d0000=
00000`0=0005000000@0C7GI00D00000000h_@00>;d0000003P00005000000H0alCG00<000000:F9
]`2URKL0102URKL00`000000YHVg0:F9]`020:F9]`030000003oool0oooo01T0oooo00<000000?oo
o`3oool0@`3oool00700oooo0P00001=0?ooo`<000001P0^0003000000H0D00/00<0000003h07`0n
01l01P0n01l00`0000003@0000d0000300d000030000002?O[`0000000<0KVbo1@000003000h_@06
0000000h0000>00003P000000000F93[1@0000020<O4e`030000002URKL0YHVg00<0YHVg1P00000J
0?ooo`030000003oool0000004@0oooo001]0?ooo`<00000CP3oool3000000D0;P000`0000080500
;0030000000n01l0?P0O00H0?P0O00@0000000d0000=00003@000P00000208mn_0030000001^K;l0
KVbo00D0KVbo0P000003000h_@040000000h0000>000000000H0F93[2@00000408V0``030000003o
ool0oooo01X0oooo00<000000?ooo`3oool0@P3oool006/0oooo0P00001@0?ooo`@000000`0^0002
0000000305L0:@000000D00/00P0D00/00<0000003h07`0n01l01@0n01l01@0000003@0000d0000=
0000000000@0Sgjl00<0000006i/_`1^K;l01P1^K;l2000000<003Rm0P0000000`0h0000000005R@
j`0605R@j`0300000029P<<0RH3300<0RH3300<0000008V0``29P<<00`29P<<00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo0440oooo000k0?ooo`D00000:03oool300000540oooo10000002
02h0008000000`1G02T00`000000D00/0500;0060500;0030000000n01l0?P0O00H0?P0O00@00000
00d0000=000000001P2?O[`00`000000KVbo06i/_`0606i/_`<000000P00>;d3000000P0F93[00<0
000008V0``29P<<00`29P<<00`000000RH3308V0``0208V0``030000003oool0oooo01/0oooo00<0
00000?ooo`3oool0@03oool003/0oooo00D000000?ooo`3oool0oooo0000000V0?ooo`<00000DP3o
ool7000000D0E`0Y00<000000500;01@02`01P1@02`00`000000?P0O03h07`0503h07`040000000=
00003@00000000L0Sgjl00<0000006i/_`1^K;l01P1^K;l010000000=4jo03A>_`000002000h_@<0
00001`1HT>/00`000000RH3308V0``0308V0``0300000029P<<0RH330080RH3300<000000?ooo`3o
ool06`3oool00`000000oooo0?ooo`100?ooo`00?03oool00`000000oooo0?ooo`0T0?ooo`<00000
0P3oool00`000000oooo0?ooo`1?0?ooo`H000001`1G02T00`000000D00/0500;0050500;0030000
000n01l0?P0O00H0?P0O0`00000808mn_0030000001^K;l0KVbo00H0KVbo00H0000003A>_`0dC[l0
=4jo00000000>;d4000000L0F93[00<0000008V0``29P<<00P29P<<00`000000RH3308V0``0208V0
``030000003oool0oooo01`0oooo00<000000?ooo`3oool0?`3oool003<0oooo1P0000040?ooo`03
0000003oool0oooo0240oooo0P00001F0?ooo`H000001`1G02T00`000000D00/0500;0060500;003
0000000n01l0?P0O00D0?P0O0`00000:08mn_0030000001^K;l0KVbo00H0KVbo00H0000003A>_`0d
C[l0=4jo00000000>;d3000000L0F93[00<0000008V0``29P<<00P29P<<00`000000RH3308V0``03
08V0``030000003oool0oooo01/0oooo00<000000?ooo`3oool0?`3oool003h0oooo00<000000?oo
o`3oool07@3oool3000005L0oooo100000000`1F00l0000005L0:@0705L0:@030000001@02`0D00/
00H0D00/00<0000003h07`0n01l01@0n01l00`000000Z8jj0000000:08mn_0030000001^K;l0KVbo
00H0KVbo00<0000003A>_`0dC[l00P0dC[l5000000H0F93[00<0000008V0``29P<<00P29P<<00`00
0000RH3308V0``0308V0``030000003oool0oooo01`0oooo00<000000?ooo`3oool0?P3oool003l0
oooo00<000000?ooo`3oool06P3oool2000005T0oooo1000000205H03`030000001G02T0E`0Y00H0
E`0Y00<000000500;01@02`01@1@02`00`000000?P0O03h07`0403h07`8000000`2XS[X00`000000
Sgjl08mn_00708mn_0030000001^K;l0KVbo00H0KVbo00<0000003A>_`0dC[l0100dC[l010000000
006@00000000000605R@j`0500000029P<<0RH3308V0``0000001@29P<<00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo03d0oooo000k0?ooo`050000003oool0oooo0?ooo`0000006@3oool3
000005/0oooo0P00000405H03`030000001G02T0E`0Y00D0E`0Y00<000000500;01@02`01P1@02`0
0`000000?P0O03h07`0203h07`8000001@2XS[X00`000000Sgjl08mn_00808mn_0030000001^K;l0
KVbo00H0KVbo00<0000003A>_`0dC[l0100dC[l00`000000006@00000002000000@0F93[00D00000
08V0``29P<<0RH330000000608V0``030000003oool0oooo01`0oooo00<000000?ooo`3oool0?@3o
ool003`0oooo0`00000G0?ooo`<00000G@3oool2000000@0EP0?00<0000005L0:@1G02T01P1G02T0
0`000000D00/0500;0060500;0030000000n01l0?P0O008000001`2XS[X00`000000Sgjl08mn_008
08mn_0030000001^K;l0KVbo00H0KVbo00<0000003A>_`0dC[l0100dC[l2000000040001T0000000
02R`000000@0F93[00@0000008V0``29P<<000001P29P<<00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo03`0oooo001D0?ooo`@00000G@3oool00`000000EP0?05H03`0405H03`030000001G
02T0E`0Y00H0E`0Y00<000000500;01@02`01@1@02`010000000?P0O00000000000:0:R>^P030000
002?O[`0Sgjl00L0Sgjl00<0000006i/_`1^K;l01`1^K;l00`000000=4jo03A>_`0403A>_`@00000
00<002R`0000001HT>/00P1HT>/010000000RH3308V0``00000608V0``030000003oool0oooo01h0
oooo00<000000?ooo`3oool0>`3oool00580oooo0P00001P0?ooo`030000001F00l0EP0?00D0EP0?
00<0000005L0:@1G02T01@1G02T00`000000D00/0500;0060500;080000000<0`J6h0000002XS[X0
2@2XS[X00`000000Sgjl08mn_00808mn_0030000001^K;l0KVbo00H0KVbo00<0000003A>_`0dC[l0
100dC[l00`00000002>_0000000200000005000X/0000000F93[05R@j`0000000P29P<<00`000000
RH3308V0``0508V0``030000003oool0oooo01`0oooo0`00000l0?ooo`00C`3oool300000640oooo
0P00000605H03`030000001G02T0E`0Y00H0E`0Y00<000000500;01@02`0101@02`2000000@0`J6h
00<000000:R>^P2XS[X01`2XS[X00`000000Sgjl08mn_00608mn_0D000001P1^K;l00`000000=4jo
03A>_`0503A>_`04000000008jl000000000008002R`00H0000005R@j`1HT>/0000008V0``000007
08V0``030000003oool0oooo01h0oooo00<000000?ooo`3oool0>P3oool004d0oooo0P00001S0?oo
o`8000001`1F00l00`000000E`0Y05L0:@0605L0:@030000001@02`0D00/0080D00/0P0000060<6Q
^0030000002XS[X0Z8jj00P0Z8jj00<0000008mn_02?O[`01@000002095h/`0300000020K[H0P6jf
00D000000P1^K;l00`000000=4jo03A>_`0403A>_`03000000008jl002>_008000000P00:;030000
000308V0``000000RH3300H0RH3300<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0i0?oo
o`00BP3oool3000006@0oooo00<0000002T0000000001`1F00l00`000000E`0Y05L0:@0605L0:@03
0000001@02`0D00/008000002031XKP00`000000Z8jj0:R>^P080:R>^P<00000202AN;<00`000000
P6jf081^]P04081^]P@000001P0dC[l00`00000002>_000S[`02000000<002R`0`00000708V0``03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0>@3oool004P0oooo0P00001U0?ooo`800000
00<0:@000000001F00l01P1F00l00`000000E`0Y05L0:@0605L0:@040000001@02`00000000000/0
`J6h00<000000:R>^P2XS[X01@2XS[X3000000X0TGRc00<00000081^]P20K[H01P20K[H010000000
Hf>l00000000000403A>_`04000000008jl002>_000S[`8000000`00:;02000000P0RH3300<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`0h0?ooo`00A@3oool3000006H0oooo00@0000002T0
000Y00000000201F00l00`000000E`0Y05L0:@0505L0:@<0000000<0fkNd00000031XKP02P31XKP0
0`000000Z8jj0:R>^P030:R>^P8000000`2QPk800`000000TGRc095h/`07095h/`0300000020K[H0
P6jf00L0P6jf00<0000006=S_01SHk`00`00000203A>_`04000000008jl002>_000S[`8000000P00
:;05000000D0RH3300<000000?ooo`3oool0803oool00`000000oooo0?ooo`080?ooo`@00000:`3o
ool004<0oooo0P0000000`3oool000000000001U0?ooo`050000000Y0000:@0002T000000000201F
00l00`000000E`0Y05L0:@0205L0:@<0000000D0i<:e0000003K]k@0fkNd0000000;0<6Q^0040000
002XS[X0Z8jj0:R>^P8000001@2QPk800`000000TGRc095h/`07095h/`0300000020K[H0P6jf00L0
P6jf00<0000006=S_01SHk`00`1SHk`3000000@002>_00D00000000X/000:;0002R`0000000305Ej
f`8000000`29P<<00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0X0?ooo`00@03oool3000004d0oooo1`00000E0?ooo`05
0000000Y0000:@0002T000000000201F00l00`000000E`0Y00000003000000<0i<:e00<000000=^g
]03K]k@00P3K]k@00`000000`J6h0<6Q^0090<6Q^0<000001`2QPk800`000000TGRc095h/`08095h
/`0300000020K[H0P6jf00H0P6jf00<0000006=S_01SHk`01@1SHk`2000000@002>_00<00000000X
/000:;000P00000405Ejf`<0000000<0RH330000003oool08@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0:03oool003d0oooo0`00001<0?ooo`@0
00000P2=KZ/00`000000OVbd07i/]00207i/]0X00000203oool3000000@0:@0000<0000005H03`1F
00l00P1F00l6000000L0i<:e00<000000=^g]03K]k@00P3K]k@00`000000`J6h0<6Q^0090<6Q^003
0000002QPk80XH>b00L0XH>b00<00000095h/`2AN;<0202AN;<00`000000P6jf081^]P07081^]P03
0000001SHk`0Hf>l00D0Hf>l0P000004000S[`0400000000:;0002R`000000L0EG[K0P00000S0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0X0?oo
o`00>`3oool2000004`0oooo0`00000608e^Z`030000001nK;@0OVbd00P0OVbd00@0000006V:h01Y
R^00JH[P500000020>_H`@030000003T`[D0i<:e00L0i<:e00<000000=^g]03K]k@00`3K]k@00`00
0000`J6h0<6Q^0080<6Q^08000002P2QPk800`000000TGRc095h/`07095h/`0300000020K[H0P6jf
00L0P6jf00<0000006=S_01SHk`01P1SHk`3000000<002>_00<00000000X/0000000201EN]/00`00
0000oooo0?ooo`0Q0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0X0?ooo`00>03oool3000004`0oooo0`00000908e^Z`030000001nK;@0OVbd00L0
OVbd00<0000006V:h01YR^002@1YR^000`000000cK[80<fjb0040<fjb0030000003V`k@0i/>d0080
00000P3[f<400`000000i<:e0>C2]@070>C2]@030000003K]k@0fkNd00@0fkNd00<000000<6Q^031
XKP01P31XKP010000000]9>e0;BC]@0000090:63/P030000002AN;<0TGRc00L0TGRc00<00000081^
]P20K[H01`20K[H00`000000Hf>l06=S_00606=S_0040000000`E<L0<5C70000008002>_10000008
05Ejf`030000003oool0oooo0240oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo02P0oooo000e0?ooo`<00000C@3oool200000080XH:b00<0000008e^
Z`2=KZ/01`2=KZ/00`000000OVbd07i/]00807i/]0030000001YR^00JH[P00L0JH[P00<000000<fj
b03=^/P0103=^/P00`000000i/>d0>K3]0030>K3]08000002@3T`[D00`000000fkNd0=^g]0050=^g
]00300000031XKP0`J6h00D0`J6h00D000000;BC]@2dTkD0]9>e000000090:63/P030000002AN;<0
TGRc00P0TGRc00<00000081^]P20K[H01`20K[H00`000000Hf>l06=S_00606=S_0040000000`E<L0
<5C70000008002>_0`00000805Ejf`030000003oool0oooo0280oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02P0oooo000c0?ooo`@00000C03oool2
000000D0XH:b00<0000008e^Z`2=KZ/01P2=KZ/00`000000OVbd07i/]00807i/]0030000001YR^00
JH[P00H0JH[P00<000000<fjb03=^/P01@3=^/P00`000000i/>d0>K3]0040>K3]0030000003T`[D0
i<:e00H0i<:e00<000000=^g]03K]k@01P3K]k@00`000000`J6h0<6Q^0030<6Q^0800000102dTkD0
0`000000XH>b0:63/P070:63/P030000002AN;<0TGRc00P0TGRc00<00000081^]P20K[H01`20K[H0
0`000000Hf>l06=S_00606=S_0060000000`E<L0<5C7031Da`00000002>_0P0000000`00:;000000
05Ejf`0705Ejf`030000003oool0oooo0240oooo00<000000?ooo`3oool0103oool4000002/0oooo
000a0?ooo`800000CP3oool2000000L0XH:b00<0000008e^Z`2=KZ/01P2=KZ/00`000000OVbd07i/
]00907i/]0030000001YR^00JH[P00<0JH[P0P0000070<fjb0030000003V`k@0i/>d00D0i/>d0P00
00070>C2]@030000003K]k@0fkNd00L0fkNd00D000000<6Q^031XKP0`J6h000000060;BC]@030000
002QPk80XH>b00P0XH>b00<00000095h/`2AN;<01`2AN;<00`000000P6jf081^]P07081^]P030000
001SHk`0Hf>l00H0Hf>l00<00000031Da`0`E<L00P0`E<L5000000P0EG[K00<000000?ooo`3oool0
7`3oool2000000030?ooo`000000oooo03<0oooo000^0?ooo`<00000C`3oool00`000000XH:b0:62
/P070:62/P030000002=KZ/0SFj[00L0SFj[00<0000007i/]01nK;@0201nK;@00`000000JH[P06V:
h00206V:h0030000003=^/P0cK[800L0cK[800<000000>K3]03V`k@0103V`k@00`000000kLR]0000
00060>C2]@030000003K]k@0fkNd00P0fkNd00@000000<6Q^031XKP00000202dTkD00`000000XH>b
0:63/P070:63/P030000002AN;<0TGRc00L0TGRc00<00000081^]P20K[H02020K[H00`000000Hf>l
06=S_00606=S_0030000000`E<L0<5C700<0<5C700@00000000=UP00000000001`1EN]/00`000000
oooo0?ooo`0D0?ooo`@000002`3oool00`000000oooo0?ooo`0a0?ooo`00;03oool200000540oooo
0P0000090:62/P030000002=KZ/0SFj[00L0SFj[00<0000007i/]01nK;@02@1nK;@010000000JH[P
06V:h00000090<fjb0030000003V`k@0i/>d00D0i/>d00@000000>g8[@3]b:d00000103T`[D00`00
0000fkNd0=^g]00:0=^g]08000002@2dTkD00`000000XH>b0:63/P070:63/P030000002AN;<0TGRc
00P0TGRc00<00000081^]P20K[H01`20K[H00`000000Hf>l06=S_00606=S_0030000000`E<L0<5C7
0080<5C70`0000000`003IH000000000000705Ejf`030000003oool0oooo0140oooo0P0000020<Wi
j@030000003Fd]D0000000X0oooo00<000000?ooo`3oool0<@3oool002T0oooo0`00001A0?ooo`80
00000P31//`00`000000XH:b0:62/P070:62/P030000002=KZ/0SFj[00H0SFj[00<0000007i/]01n
K;@02@1nK;@00`000000JH[P0000000:0<fjb0030000003V`k@0i/>d00@0i/>d00<000000>g8[@3]
b:d00P3]b:d01@000000i<:e0>C2]@3T`[D0000000`0fkNd00<000000;BC]@2dTkD0202dTkD00`00
0000XH>b0:63/P070:63/P030000002AN;<0TGRc00P0TGRc00<00000081^]P20K[H01`20K[H00`00
0000Hf>l06=S_00706=S_0@000000P0`E<L6000000D0EG[K00<000000?ooo`3oool0403oool20000
0080bOWY00D000000=KBe@3Fd]D0e];E0000000:0?ooo`030000003oool0oooo0300oooo000W0?oo
o`800000?`3oool9000000/0oooo00<000000<6bc031//`00P31//`00`000000XH:b0:62/P070:62
/P030000002=KZ/0SFj[00H0SFj[00<0000007i/]01nK;@02P1nK;@00`000000cK[80<fjb0080<fj
b0030000003V`k@0i/>d00D0i/>d00<000000>g8[@3]b:d00`3]b:d00`000000i<:e0000000<0=^g
]08000002P2dTkD00`000000XH>b0:63/P080:63/P030000002AN;<0TGRc00L0TGRc00<00000081^
]P20K[H02020K[H00`000000Hf>l06=S_00406=S_0<000001@0`E<L00`000000<5C7000000020000
0003001Wf0000000000000@0EG[K00<000000?ooo`3oool03@3oool2000000<0bOWY00<000000=KB
e@3Fd]D00P3Fd]D00`000000oooo0?ooo`080?ooo`030000003oool0oooo0300oooo000U0?ooo`80
0000?@3oool40000000404/040000000H@0G06405`8000000`1X0002000000P0oooo00<000000<6b
c031//`00`31//`00`000000XH:b0:62/P070:62/P030000002=KZ/0SFj[00L0SFj[00<0000007i/
]01nK;@0201nK;@00`000000]YBd000000080<fjb0030000003V`k@0i/>d00D0i/>d00<000000>g8
[@3]b:d0103]b:d00`000000i<:e0000000;0=^g]0040000003>[[X0cZjj000000X0]9>e00<00000
0:63/P2QPk801`2QPk800`000000TGRc095h/`07095h/`0300000020K[H0P6jf00H0P6jf2@000003
06=S_0030000000`E<L0<5C700<0<5C700<00000031Da`0000000P000002001Wf08000000P1EN]/0
0`000000oooo0?ooo`0;0?ooo`<000000`39nNT00`000000e];E0=KBe@040=KBe@030000003oool0
oooo00P0oooo00<000000?ooo`3oool0;`3oool002D0oooo0P00000j0?ooo`<00000101;01000`00
0000H@0G06405`0306405`<000000P1X0002000000D0oooo00<000000<6bc031//`01031//`00`00
0000XH:b0:62/P070:62/P030000002=KZ/0SFj[00L0SFj[00<0000007i/]01nK;@01`1nK;@01000
0000]YBd0;JD]00000080<fjb0030000003V`k@0i/>d00D0i/>d00<000000>g8[@3]b:d01@3]b:d0
0`000000fkNd0=^g]00:0=^g]0040000003>[[X0cZjj000000X0]9>e00<000000:63/P2QPk801`2Q
Pk800`000000TGRc095h/`08095h/`0300000020K[H0P6jf00D000000P2?MK840000000308If^P00
0000000000P000000P0`E<L01@000000<5C700000000B/L0000000<006OH0P0000000`1EN]/00000
0?ooo`080?ooo`D000000`39nNT00`000000e];E0=KBe@060=KBe@030000003oool0oooo00P0oooo
00<000000?ooo`3oool0;P3oool002@0oooo0P0000000`3oool000000?ooo`0f0?ooo`8000001`1;
01000`000000H@0G06405`0606405`H0000000<0oooo0000000000002031//`00`000000XH:b0:62
/P060:62/P030000002=KZ/0SFj[00L0SFj[00<0000007i/]01nK;@01P1nK;@00`000000]YBd0;JD
]0020;JD]0030000003=^/P0cK[800@0cK[800<000000>K3]03V`k@01@3V`k@00`000000kLR]0>g8
[@060>g8[@030000003K]k@0fkNd00T0fkNd00D000000<j^^P3>[[X0cZjj0000000:0;BC]@030000
002QPk80XH>b00L0XH>b00<00000095h/`2AN;<01P2AN;<5000000H0SgFb0`00000808If^P030000
001iOld0NGo=0080NGo=2@000003001Wf08000001`3oool700000080bOWY00<000000=KBe@3Fd]D0
1P3Fd]D2000000X0oooo00<000000?ooo`3oool0;P3oool001X0oooo1@0000050?ooo`050000003o
ool0oooo0?ooo`000000=@3oool00`0000009P000000000604/040030000001Q01L0H@0G00L0H@0G
00@0000007<01@000000/RP00`00000:0<6bc0030000002QP[80XH:b00L0XH:b00<0000008e^Z`2=
KZ/01P2=KZ/00`000000OVbd07i/]00507i/]0030000002fU;@0]YBd00@0]YBd00<000000<fjb03=
^/P00`3=^/P00`000000i/>d0>K3]0050>K3]0030000003]b:d0kLR]00D0kLR]00<000000>k=/@00
00002@3K]k@00`000000cZjj0<j^^P030<j^^P030000002dTkD0]9>e00P0]9>e00<000000:63/P2Q
Pk801`2QPk800`000000TGRc095h/`0500000080UGN_00<0000008me/P2?MK800`2?MK8300000080
SgFb00<0000008If^P26M[X01`26M[X00`000000NGo=07Uoc@0407Uoc@050000001iOld0NGo=0000
001JWo<010000002001Wf0040000003oool0oooo0?ooo`T000000P39nNT00`000000e];E0=KBe@06
0=KBe@0400000035[<40aJc1000000X0oooo00<000000?ooo`3oool0;@3oool001`0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0300oooo0P000000
0`0V0000000004/0400504/040030000001Q01L0H@0G00L0H@0G00L0000007<01@1c00D0L`050000
002b:000000000/0`K;<00<000000:62/P2QP[801`2QP[800`000000SFj[08e^Z`0708e^Z`030000
001nK;@0OVbd00<0OVbd00<000000;JD]02fU;@01@2fU;@00`000000cK[80<fjb0020<fjb0030000
003V`k@0i/>d00D0i/>d00<000000>g8[@3]b:d01P3]b:d00`000000k/fa000000080=^g]0030000
003>[[X0cZjj00@0cZjj00<000000;BC]@2dTkD0202dTkD00`000000XH>b0:63/P060:63/P@00000
202EMjl00`000000SgFb00000002000000D0SgFb00<0000008If^P26M[X01`26M[X00`000000NGo=
07Uoc@0507Uoc@030000001iOld0000000<0FYoc100000000`00ImP0000000000004000000@0;`00
00@000000<Wij@39nNT00000203Fd]D01@000000aJc10<F/`@35[<40000000/0oooo00<000000?oo
o`3oool0;03oool001`0oooo00<000000?ooo`3oool01@3oool2000000@0oooo00<000000?ooo`3o
ool0;@3oool2000000809P0000<0000004/0401;0100101;01000`000000H@0G06405`0606405`80
00001@1c00D00`000000`OkC0000000:0<6bc0030000002QP[80XH:b00L0XH:b00<0000008e^Z`2=
KZ/01`2=KZ/00`000000OVbd07i/]00207i/]0030000002fU;@0]YBd00L0]YBd00D000000<fjb03=
^/P0cK[8000000070>K3]0030000003]b:d0kLR]00D0kLR]00D000000>k=/@3^cK40k/fa00000007
0=^g]0030000003>[[X0cZjj00@0cZjj00<000000;BC]@2dTkD0202dTkD00`000000XH>b0:63/P04
0:63/P80000000<0W7f`0000002EMjl0202EMjl3000000P0SgFb00<0000008If^P26M[X02026M[X0
0`000000NGo=07Uoc@0507Uoc@030000001iOld0000000H0FYoc1P00000302l00080000000<0g=;?
000000000000203Fd]D00`000000aJc10<F/`@030<F/`@030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0;03oool00140oooo1P0000050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0[0?ooo`050000000V00009P0002H0000000001P1;0100
0`000000H@0G06405`0606405`030000001c00D0L`0500@0L`0500@000000<7nd`31o]<000002`31
//`00`000000XH:b0:62/P060:62/P030000002=KZ/0SFj[00L0SFj[00D0000007i/]01nK;@0OVbd
0000000;0;JD]0030000003=^/P0000000L0i/>d00<000000>g8[@3]b:d01P3]b:d01@000000k/fa
0>k=/@3^cK40000000H0fkNd00<000000<j^^P3>[[X01@3>[[X00`000000]9>e0;BC]@080;BC]@03
0000002QPk80XH>b0080XH>b0P00000409am/0030000002EMjl0UGN_00<0UGN_0`0000000`2EMjl0
000008me/P0908me/P0300000026M[X0QWJj00L0QWJj00<0000007Uoc@1iOld01P1iOld00`000000
NGo=0000000405ZOl`8000000P2fbnX6000000<0g=;?00<000000>O?_P0000001P3Fd]D00`000000
aJc10<F/`@040<F/`@030000003oool0oooo00P0oooo0P00000]0?ooo`00703oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00D0oooo0P00000Z0?ooo`030000000V00009P0000809P00
00<0000004/0401;0100101;01000`000000H@0G06405`0506405`030000001c00D0L`0500@0L`05
00<000000<7nd`31o]<00P31o]<00`000000`K;<0<6bc0080<6bc0030000002QP[80XH:b00H0XH:b
00<0000008e^Z`2=KZ/01`2=KZ/010000000OVbd07i/]000000<0;JD]0030000003=^/P0000000L0
i/>d00<000000>g8[@3]b:d01@3]b:d00`000000k/fa0>k=/@030>k=/@030000003K]k@0fkNd0080
fkNd00<000000<j^^P3>[[X01`3>[[X00`000000]9>e0;BC]@080;BC]@040000002QPk8000000000
00H0W7f`00<0000009Eg[`2EMjl00`00000409Eg[`030000002?MK80SgFb00P0SgFb00<0000008If
^P26M[X01`26M[X00`000000NGo=07Uoc@0607Uoc@030000001iOld000000080FYoc0P0000070;K;
jP030000003Ld/l0g=;?00<0g=;?00<000000>O?_P0000001P3Fd]D00`000000aJc10<F/`@040<F/
`@030000003oool0oooo00X0oooo00<000000?ooo`3oool0:P3oool001`0oooo00<000000?ooo`3o
ool01@3oool2000000P0oooo00<000000?ooo`3oool09P3oool00`0000009P0002H0000202H00003
0000001;0100B`0@00@0B`0@00@0000006405`1Q01L0H@0G1P00000407<01@8000001P31o]<00`00
0000`K;<0<6bc0070<6bc0030000002QP[80XH:b00L0XH:b00<0000008e^Z`2=KZ/01`2=KZ/20000
00h0]YBd00<000000>K3]03V`k@01@3V`k@00`000000kLR]0>g8[@060>g8[@030000003^cK40k/fa
00<0k/fa00D000000=^g]03K]k@0fkNd0000000:0<j^^P030000002dTkD0]9>e00P0]9>e0P000008
09am/0<00000202EMjl00`000000SgFb08me/P0708me/P0300000026M[X0QWJj00P0QWJj00<00000
07Uoc@1iOld01P1iOld010000000NGo=0000000000080;K;jP030000003Ld/l0g=;?00<0g=;?00D0
00000>O?_P3Wckh0ilnn000000040=KBe@0300000035[<40aJc100H0aJc100<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0Z0?ooo`006P3oool3000000H0oooo0P00000:0?ooo`030000003o
ool0oooo02@0oooo0P00000302H000030000001;0100B`0@00<0B`0@1P00000303X06`L000002031
o]<00`000000`K;<0<6bc0070<6bc0030000002QP[80XH:b00L0XH:b00<0000008e^Z`2=KZ/01`2=
KZ/00`000000]YBd0;JD]00<0;JD]0030000003J][@0000000H0i/>d00<000000>g8[@3]b:d01@3]
b:d00`000000k/fa0>k=/@050>k=/@040000003K]k@0fkNd000000X0cZjj00<000000;BC]@2dTkD0
1P2dTkD3000000H0W7f`1000000:09Eg[`030000002?MK80SgFb00P0SgFb00<0000008If^P26M[X0
1`26M[X00`000000NGo=07Uoc@0607Uoc@80000000<0Zic70000002fbnX01P2fbnX00`000000g=;?
0=cBc`030=cBc`030000003Wckh0ilnn00<0ilnn00@000000=KBe@3Fd]D000002@35[<400`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo02T0oooo000L0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0R0?ooo`800000100V00000`000000B`0@
00000004000000P0>P0K1P0000020<7nd`<000001@31o]<00`000000`K;<0<6bc0070<6bc0030000
002QP[80XH:b00H0XH:b00<0000008e^Z`2=KZ/01@2=KZ/3000000h0]YBd00<000000=Zf]0000000
1@3V`k@00`000000kLR]0>g8[@060>g8[@030000003^cK40k/fa00D0k/fa00<000000=^g]0000000
303>[[X00`000000]9>e0;BC]@040;BC]@040000002WR[H0YhZf000000<0W7f`0`00000409am/003
0000002EMjl0UGN_00L0UGN_00<0000008me/P2?MK80202?MK800`000000QWJj08If^P0808If^P03
0000001iOld0NGo=00<0NGo=0P0000020:^La`030000002[W<L0000000D0]/_Z00<000000=cBc`3L
d/l0103Ld/l00`000000ilnn0>O?_P030>O?_P030000003Fd]D0000000X0aJc100<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0X0?ooo`008`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo01l0oooo0`00000402H000<00000101@02/00`000000>P0K03X06`0503X06`T00000
0`2AOk`3000000<0`OkC00<000000<6bc031//`01P31//`00`000000XH:b0:62/P060:62/P030000
002=KZ/0SFj[00<0SFj[0P0000030:>3/@030000002fU;@0]YBd00X0]YBd00D000000=Zf]03J][@0
f[Jd000000040>K3]0030000003]b:d0kLR]00D0kLR]00<000000>k=/@3^cK401`3^cK400`000000
cZjj0<j^^P0;0<j^^P030000002dTkD0]9>e0080]9>e0P0000040:N:]P<000001`2LOK000`000000
UGN_09Eg[`0709Eg[`030000002?MK80SgFb00P0SgFb00<0000008If^P26M[X02026M[X010000000
NGo=07Uoc@1iOld2000000@0Zic700<000000:^La`000000102fbnX00`000000g=;?0=cBc`040=cB
c`030000003Wckh0ilnn00D0ilnn00<000000<F/`@35[<402P35[<400`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo02P0oooo000S0?ooo`8000003@3oool00`000000oooo0?ooo`0M0?ooo`<0
00000`0V0002000000H0D00[00<0000003X06`0j01/01@0j01/7000000P0TGnl1@0000080<6bc003
0000002QP[80XH:b00L0XH:b00<0000008e^Z`2=KZ/00P0000050:>3/@030000002fU;@0]YBd00X0
]YBd00<000000=Zf]03J][@00P3J][@010000000i/>d0>K3]00000080>g8[@030000003^cK40k/fa
00H0k/fa0P00000=0<j^^P050000002dTkD0]9>e0;BC]@000000102WR[H3000000T0W7f`00<00000
09Eg[`2EMjl0202EMjl00`000000SgFb08me/P0808me/P0300000026M[X0QWJj00P0QWJj0`000007
0:^La`030000002[W<L0000000<0]/_Z00<000000=cBc`3Ld/l00`3Ld/l00`000000ilnn0>O?_P05
0>O?_P8000003035[<400`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02L0oooo000S0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool06`3oool3000000809P000P0000000`1H
02X000000500:`050500:`030000000j01/0>P0K00@0>P0K1P0000000`2[T;X00000095o_007095o
_0040000001PHkh0H6>n061S_P@000001@31//`00`000000XH:b0:62/P070:62/P<000001`2SPk40
0`000000]YBd0;JD]0090;JD]0030000003J][@0f[Jd00@0f[Jd00<000000>K3]0000000203]b:d0
0`000000k/fa0>k=/@060>k=/@030000003Ydkh0000000d0cZjj0`0000020:N:]P<000000P2WR[H0
0`000000W7f`09am/00809am/0030000002EMjl0UGN_00L0UGN_00<0000008me/P2?MK80202?MK80
0`000000QWJj08If^P0708If^P8000002P2[W<L01@000000Zic70000002fbnX0000000H0g=;?00<0
00000>O?_P3Wckh01@3Wckh00`000000i/bl0000000<0<F/`@030000003oool0oooo00/0oooo00<0
00000?ooo`3oool09P3oool002<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0I
0?ooo`H000000P1H02X00`000000D00[0500:`040500:`030000000j01/0>P0K00D0>P0K10000004
0:^@^P030000002AOk`0TGnl00D0TGnl00<00000061S_P1PHkh00`1PHkh00`000000Ch;S00000003
00000080`K;<00<000000:62/P2QP[800P2QP[85000000X0Xh>a00<000000;JD]02fU;@01`2fU;@0
0`000000f[Jd0=Zf]0050=Zf]0800000203]b:d00`000000k/fa0>k=/@060>k=/@040000003Ydkh0
jM>n000000d0cZjj00<000000:N:]P0000000P0000050:N:]P030000002LOK00W7f`00P0W7f`00<0
000009Eg[`2EMjl01`2EMjl00`000000SgFb08me/P0808me/P0300000026M[X0QWJj00D0QWJj0P00
00000`2RR;P000000:^La`090:^La`040000002[W<L0Zic7000000H0g=;?00<000000>O?_P3Wckh0
1@3Wckh010000000i/bl0>K<_000000<0<F/`@030000003oool0oooo00/0oooo00<000000?ooo`3o
ool09P3oool00280oooo0P00000A0?ooo`030000003oool0oooo01L0oooo1@00000405P0:P030000
001@02/0D00[00@0D00[00<0000003X06`0j01/0100j01/4000000D0Zi2j00<00000095o_02AOk`0
1P2AOk`00`000000H6>n061S_P02061S_P030000001?P^<0Ch;S00<0Ch;S1`00000408al_@030000
002SPk40Xh>a00P0Xh>a00<000000;JD]02fU;@01`2fU;@00`000000f[Jd0=Zf]0060=Zf]0030000
003]b:d0kLR]00H0kLR]00<000000>k=/@3^cK401P3^cK401@000000jM>n0>WC_P3Ydkh0000000X0
cZjj100000090:N:]P030000002LOK00W7f`00L0W7f`00<0000009Eg[`2EMjl01`2EMjl00`000000
SgFb08me/P0808me/P0300000026M[X0QWJj0080QWJj0`0000040::8^0030000002[W<L0Zic700P0
Zic70P0000000`3=//0000000=cBc`040=cBc`030000003Wckh0ilnn00D0ilnn00D000000>K<_03V
c;`0i/bl0000000:0<F/`@8000003P3oool00`000000oooo0?ooo`0U0?ooo`008P3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo01D0oooo1000000505P0:P030000001@02/0D00[00@0
D00[00<0000003X06`0j01/0100j01/4000000H0Zi2j00<00000095o_02AOk`01P2AOk`00`000000
H6>n061S_P03061S_P030000001?P^<0Ch;S00@0Ch;S00<0000008al_@2<O;d01P2<O;d00`000000
Xh>a0:>3/@090:>3/@030000002fU;@0]YBd00D0]YBd00<000000=Zf]03J][@01P3J][@00`000000
km2c000000060>g8[@030000003^cK40k/fa00H0k/fa00<000000>WC_P3Ydkh00P3Ydkh00`000000
cZjj0<j^^P060<j^^P<000000P2kYL<00`000000YhZf0:N:]P070:N:]P030000002LOK00W7f`00L0
W7f`00<0000009Eg[`2EMjl0202EMjl00`000000SgFb08me/P0808me/P0400000026M[X000000000
00L0XXRh00<000000:^La`2[W<L0202[W<L200000080cK;000D000000=cBc`3Ld/l0g=;?00000007
0>O?_P030000003Vc;`0i/bl0080i/bl00<000000<F/`@35[<401P35[<4200000080/YJj00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0T0?ooo`008P3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo01<0oooo1000000605P0:P030000001@02/0D00[00@0D00[00<0000003X0
6`0j01/00`0j01/3000000T0Zi2j00<00000095o_02AOk`01@2AOk`00`000000H6>n061S_P04061S
_P030000001?P^<0Ch;S00@0Ch;S00<0000008al_@2<O;d01P2<O;d00`000000Xh>a0:>3/@080:>3
/@030000002fU;@0]YBd00D0]YBd00<000000=Zf]03J][@01P3J][@010000000km2c0>o@/`000005
0>g8[@030000003^cK40k/fa00D0k/fa00<000000>WC_P3Ydkh0103Ydkh00`000000cZjj0<j^^P02
0<j^^P@00000102kYL<00`000000YhZf0:N:]P070:N:]P030000002LOK00W7f`00P0W7f`00<00000
09Eg[`2EMjl01`2EMjl00`000000SgFb08me/P0708me/P<000002P2RR;P00`000000Zic70:^La`07
0:^La`050000003=//0000000<fb`00000000P3Ld/l00`000000ilnn0>O?_P060>O?_P030000003V
c;`0i/bl00<0i/bl00<000000<F/`@35[<401035[<400`000000/YJj0;:F^P020;:F^P030000003o
ool0oooo00/0oooo0P00000V0?ooo`008P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo0100oooo100000000`1I01@0000005P0:P0405P0:P030000001@02/0D00[00@0D00[00<00000
03X06`0j01/0100j01/2000000X0Zi2j00<00000095o_02AOk`01P2AOk`00`000000H6>n061S_P04
061S_P030000001?P^<0Ch;S00<0Ch;S00<0000008al_@2<O;d01P2<O;d00`000000Xh>a0:>3/@08
0:>3/@030000002fU;@0]YBd00@0]YBd00<000000=Zf]03J][@01P3J][@00`000000km2c0>o@/`02
0>o@/`050000003]b:d0kLR]0>g8[@000000203^cK400`000000jM>n0>WC_P040>WC_P030000003>
[[X000000080000000<0cZjj0000000000001@2kYL<00`000000YhZf0:N:]P070:N:]P030000002L
OK00W7f`00P0W7f`00<0000009Eg[`2EMjl01`2EMjl00`000000SgFb08me/P0508me/P80000000<0
WGnb0000002RR;P02P2RR;P00`000000Zic70:^La`060:^La`040000003=//00cK;000000080cK;0
00<000000=cBc`0000001`3Wckh00`000000i/bl0>K<_0040>K<_00300000035[<40aJc100<0aJc1
00<000000;:F^P2bU[X00`2bU[X00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02<0oooo
000R0?ooo`<00000503oool00`000000oooo0?ooo`0>0?ooo`<000000P1I01@00`000000F00Z05P0
:P0405P0:P030000001@02/0D00[00@0D00[00<0000003X06`0j01/00`0j01/010000000_inh0;nO
^00000090:^@^P030000002AOk`0TGnl00H0TGnl00<00000061S_P1PHkh0101PHkh00`000000Ch;S
04n2h`0304n2h`030000002<O;d0S7bm00H0S7bm00<000000:>3/@2SPk402@2SPk400`000000]YBd
0;JD]0030;JD]0030000003J][@0f[Jd00H0f[Jd00<000000>o@/`3_d;<00`3_d;<010000000kLR]
0>g8[@0000070>k=/@030000003Ydkh0jM>n00@0jM>n0`0000030<j^^P030000002kYL<0^jG300H0
^jG300<000000:N:]P2WR[H01`2WR[H00`000000W7f`09am/00709am/0030000002EMjl0UGN_00L0
UGN_00<0000008me/P2?MK800P2?MK83000000@0WGnb00<000000::8^02RR;P0202RR;P00`000000
Zic70:^La`050:^La`030000003=//00cK;00080cK;000@000000<fb`03=//0000001`3Wckh00`00
0000i/bl0>K<_0060>K<_00300000035[<40aJc1008000001P2bU[X00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo0280oooo000R0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool0303oool2000000@0F@0D00<0000005P0:P1H02X00`1H02X00`000000D00[0500:`040500:`03
0000000j01/0>P0K0080>P0K0P0000030;nO^0030000002[T;X0Zi2j00P0Zi2j00<00000095o_02A
Ok`01@2AOk`00`000000H6>n061S_P04061S_P800000101?P^<00`000000S7bm08al_@0608al_@03
0000002SPk40Xh>a00T0Xh>a00<000000;JD]02fU;@00P2fU;@00`000000f[Jd0=Zf]0060=Zf]003
0000003_d;<0km2c00D0km2c0P0000080>k=/@040000003Ydkh0jM>n0>WC_P<000000P3Ydkh01000
0000cZjj0000000000090;^U``030000002WR[H0YhZf00L0YhZf00<0000009am/02LOK00202LOK00
0`000000UGN_09Eg[`0709Eg[`040000002?MK800000000000L0WGnb00<000000::8^02RR;P02@2R
R;P00`000000Zic70:^La`030:^La`030000003=//00cK;000@0cK;00P0000000`3Vbk/000000>O?
_P050>O?_P030000003Vc;`0i/bl00H0i/bl00<000000<F/`@0000002@2bU[X00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0280oooo00080?ooo`@000001@3oool2000000D0oooo10000005
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool02P3oool00`000000F@0D05T05003
05T050030000001H02X0F00Z00@0F00Z00<000000500:`1@02/0101@02/01@000000>P0K03X06`0j
01/0000000D0_inh00<000000:^@^P2[T;X0202[T;X00`000000TGnl095o_006095o_0030000001P
Hkh0H6>n00@0H6>n0P00000404n2h`030000002<O;d0S7bm00H0S7bm00<000000:>3/@2SPk40202S
Pk401@000000]YBd0;JD]02fU;@0000000T0f[Jd00<000000>o@/`3_d;<01P3_d;<00`000000k/fa
0>k=/@050>k=/@030000003Ydkh00000008000001P3Ydkh00`000000^jG30;^U``090;^U``030000
002WR[H0YhZf00L0YhZf00<0000009am/02LOK00202LOK000`000000UGN_09Eg[`0609Eg[`<00000
2@2MOk800`000000XXRh0::8^0090::8^0030000002[W<L0Zic70080Zic700<000000<fb`03=//00
1P3=//0010000000i/^k0>K;^`0000040>O?_P030000003Vc;`0i/bl00P0i/bl00<000000;:F^P2b
U[X0202bU[X00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0240oooo00070?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000@0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`8000006@3oool2000000T0oooo00<0000005T0501I01@0
0`1I01@00`000000F00Z05P0:P0405P0:P030000001@02/0D00[00@0D00[00<0000003X06`0j01/0
0P0000070;nO^0030000002[T;X0Zi2j00L0Zi2j00<00000095o_02AOk`01@2AOk`3000000D0H6>n
00<00000000SZ`0000000`1?P^<00`000000S7bm08al_@0608al_@030000002SPk40Xh>a00T0Xh>a
00@000000;JD]02fU;@00000203J][@00`000000km2c0>o@/`060>o@/`030000003fiKD0000000D0
k/fa0`0000080>WC_P8000002`2kYL<00`000000YhZf0:N:]P070:N:]P030000002LOK00W7f`00P0
W7f`00<0000009Eg[`2EMjl0102EMjl20000000309Yl/0000000WGnb00T0WGnb00<000000::8^02R
R;P02P2RR;P010000000Zic70:^La`0000080<fb`08000000P3Vbk/00`000000ilnn0>O?_P020>O?
_P030000003Vc;`0i/bl00L0i/bl0P00000:0;:F^P030000003oool0oooo00h0oooo00<000000?oo
o`3oool08@3oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`050?ooo`80
00001@1I01@00`000000F00Z05P0:P0405P0:P030000001@02/0D00[00@0D00[00<0000003X06`00
00002@2oWkP00`000000Zi2j0:^@^P080:^@^P030000002AOk`0TGnl00@0000000<0TWRb0000001j
J[D010000002061S_P8000000`1?P^<00`000000S7bm08al_@0608al_@030000002SPk40Xh>a00T0
Xh>a00<000000;JD]00000002@3J][@00`000000km2c0>o@/`060>o@/`040000003fiKD0m^Fe0000
0080k/fa0`0000090>WC_P040000003Gf]X0em[J000000/0^jG300<000000:N:]P2WR[H01`2WR[H0
0`000000W7f`09am/00709am/0030000002EMjl0UGN_0080UGN_0P00000409Yl/0030000002MOk80
WGnb00P0WGnb00<000000::8^02RR;P02@2RR;P010000000Zic70:^La`0000080<fb`0030000003V
bk/000000080i/^k00@000000>O?_P3Wckh000002@3Vc;`010000000fLS90=W8b@0000090;:F^P03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0803oool000D000000P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00<0oooo0P00000505T050030000001H02X0F00Z00@0F00Z
00<000000500:`1@02/0101@02/3000000/0_inh00<000000:^@^P2[T;X01P2[T;X4000000H0TWRb
00<0000007YZ]@1jJ[D00P1jJ[D300000003000SZ`000000Ch;S0080Ch;S00<0000008al_@2<O;d0
1@2<O;d00`000000Xh>a0:>3/@0:0:>3/@800000203J][@00`000000km2c0>o@/`060>o@/`040000
003fiKD0m^Fe0?KU]@<0000000<0k/fa0000003Ydkh0203Ydkh01@000000em[J0=OJfP3Gf]X00000
00/0^jG300<000000:N:]P2WR[H01`2WR[H00`000000W7f`09am/00809am/0040000002EMjl00000
000000H0VWb`00<0000009eo/P2MOk80202MOk800`000000XXRh0::8^00:0::8^0800000203=//00
1@000000i/^k0>K;^`3Vbk/000000080i/^k00<000000>O?_P0000002@3Vc;`010000000fLS90=W8
b@00000:0;:F^P030000003oool0oooo00l0oooo00<000000?ooo`3oool07`3oool000L0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`@000001@3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo00<000001P1I01@00`000000F00Z05P0:P0405P0:P030000001@
02/0D00[00<0D00[0`00000<0;nO^0030000002[T;X0Zi2j00@0Zi2j0P0000000`2SQ;<00000099h
/P07099h/P030000001jJ[D0NVZe00@0NVZe0P0000001@008j/0000004n2h`1?P^<0000000P0S7bm
00<000000:>3/@2SPk402@2SPk400`000000f[Jd0=Zf]0070=Zf]0030000003_d;<0km2c00H0km2c
100000020?KU]@030000003^cK40000000P0jM>n00<000000=OJfP3Gf]X00`3Gf]X00`000000^jG3
0;^U``080;^U``030000002WR[H0YhZf00L0YhZf00<0000009am/02LOK001`2LOK03000000P0VWb`
00<0000009eo/P2MOk80202MOk800`000000XXRh0::8^00:0::8^0030000003=//00cK;000L0cK;0
00<000000>K;^`3Vbk/00P3Vbk/010000000i/^k0>K;^`0000090>K<_0050000003Ib<T0fLS90=W8
b@0000002P2bU[X00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01l0oooo00070?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`050?ooo`<0
00007P3oool200000003040000000000F@0D00D0F@0D00<0000005P0:P1H02X0101H02X010000000
D00[0500:`1@02/3000000040=bl^@000000dk2g000000/0_inh00<000000:^@^P2[T;X00P2[T;X2
000000<0XhBc00<00000099h/P2BN;801P2BN;800`000000NVZe07YZ]@0507YZ]@@0000000<0Ch;S
0000002<O;d01`2<O;d00`000000Xh>a0:>3/@080:>3/@800000203J][@00`000000km2c0>o@/`05
0>o@/`<000001P3fiKD00`000000jM>n0>WC_P060>WC_P030000003Gf]X0em[J00@0em[J00<00000
0;^U``2kYL<02@2kYL<00`000000YhZf0:N:]P060:N:]P030000002LOK00W7f`00@0W7f`0`000000
0`2IO;80000009Yl/00809Yl/0030000002MOk80WGnb00T0WGnb00<000000::8^02RR;P0202RR;P2
000000P0cK;000<000000>K;^`3Vbk/00`3Vbk/01@000000i/^k0000003ej[T0000000L0i/bl00<0
00000=W8b@3Ib<T00`3Ib<T00`000000/YJj0;:F^P070;:F^P030000003oool0oooo0100oooo00<0
00000?ooo`3oool07P3oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool07P3oool010000000@00004000000
000505T050030000001H02X0F00Z00D0F00Z100000030=bl^@040000003C/;L0dk2g000000`0_inh
00@000000:^@^P00000000001P2SQ;<00`000000TWRb099h/P05099h/P030000001jJ[D0NVZe00D0
NVZe00@0000004YC^@1:DkT000000P1?P^<00`000000S7bm08al_@0508al_@030000002SPk40Xh>a
00L0Xh>a00@000000<2X`P30Z<8000001`3J][@00`000000km2c0>o@/`020>o@/`<0000000<0km2c
0000003fiKD01@3fiKD00`000000kORn000000060>WC_P030000003Gf]X0em[J00H0em[J00<00000
0;^U``2kYL<0202kYL<00`000000YhZf0:N:]P070:N:]P030000002LOK00000000<00000102IO;80
0`000000VWb`09Yl/00809Yl/0030000002MOk80WGnb00P0WGnb00<000000::8^02RR;P01`2RR;P0
10000000_9nj0;bO^P0000060<fb`0030000003Vbk/0i/^k00D0i/^k0P0000000`3ej[T000000>K<
_0050>K<_0030000003Ib<T0fLS900@0fLS900<000000;:F^P2bU[X0202bU[X00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo01d0oooo00080?ooo`@00000303oool5000000<0oooo00<00000
0?ooo`3oool07@3oool010000000@00004000000000605T050030000001H02X0F00Z00<0F00Z0`00
00050=bl^@030000003C/;L0dk2g0080dk2g00<000000;nO^02oWkP02@2oWkP2000000P0XhBc00<0
0000099h/P2BN;801P2BN;800`000000NVZe07YZ]@0407YZ]@070000001:DkT0BU>i04YC^@000000
Ch;S0000000708al_@030000002SPk40Xh>a00H0Xh>a00D000000<2X`P30Z<80`:S2000000060=Zf
]0030000003_d;<0km2c00<000000`3_d;<00`000000m^Fe0?KU]@040?KU]@040000003]n;h0kORn
0>gh_P8000000`3Ydkh00`000000em[J0=OJfP070=OJfP030000002kYL<0^jG300P0^jG300<00000
0:N:]P2WR[H01@2WR[H4000000T0VGbb00<0000009Yl/02JO;001`2JO;000`000000WGnb09eo/P08
09eo/P030000002RR;P0XXRh00H0XXRh00D000000;bO^P2lWkX0_9nj000000060<fb`0030000003V
bk/0i/^k00D0i/^k0P0000020?GZ^@030000003Vc;`0i/bl0080i/bl00<000000=W8b@3Ib<T01@3I
b<T00`000000/YJj0;:F^P080;:F^P030000003oool0oooo00l0oooo0P00000O0?ooo`00803oool0
0`000000oooo0?ooo`0K0?ooo`8000000P1000000`000000F@0D05T0500405T050040000001H02X0
F00Z05P0:P<00000203L_;T00`000000dk2g0=>`]`020=>`]`030000002oWkP0_inh00P0_inh0P00
00090:>4/`030000002BN;80TWRb00H0TWRb00<0000007YZ]@1jJ[D01@1jJ[D010000000BU>i04YC
^@1:DkT2000000P0S7bm00<000000:>3/@2SPk40102SPk400`000000`:S20<2X`P030<2X`P030000
003J][@0f[Jd00<0f[Jd0`0000060>o@/`030000003fiKD0m^Fe00@0m^Fe00<000000>gh_P3]n;h0
0`3]n;h00`000000jM>n0000000;0=OJfP030000002kYL<0^jG300P0^jG300<000000:N:]P2WR[H0
1000000209V2^P030000002IO;80VGbb00P0VGbb00<0000009Yl/02JO;001`2JO;000`000000WGnb
09eo/P0909eo/P030000002RR;P0XXRh00@0XXRh00<000000;bO^P2lWkX00`2lWkX00`000000cK;0
0<fb`0020<fb`0030000003Vbk/0i/^k00H0i/^k00D000000?GZ^@000000mNZi000000030>K<_003
0000003Ib<T0fLS900L0fLS900<000000;:F^P2bU[X01`2bU[X00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01`0oooo000P0?ooo`8000000`3oool700000100oooo0P000003040000030000
001I01@0F@0D00D0F@0D1@0000090=bl^@030000003C/;L0dk2g00<0dk2g00<000000;nO^02oWkP0
1`2oWkP010000000/i>f0;>C]P0000080:>4/`030000002BN;80TWRb00H0TWRb00<0000007YZ]@1j
J[D01@1jJ[D010000000BU>i04YC^@1:DkT2000000P0S7bm00<000000:>3/@2SPk400P2SPk420000
00H0`:S200<000000=Zf]03J][@00`0000080>o@/`030000003fiKD0m^Fe00@0m^Fe00<000000>gh
_P3]n;h01@3]n;h00`000000em[J0=OJfP0:0=OJfP030000002kYL<0^jG300H0^jG31@00000709V2
^P030000002IO;80VGbb00L0VGbb00<0000009Yl/02JO;00202JO;000`000000WGnb09eo/P0809eo
/P030000002RR;P0XXRh0080XXRh0P0000060;bO^P030000003=//00cK;00080cK;000<000000>K;
^`3Vbk/01@3Vbk/010000000mNZi0?GZ^@0000020?GZ^@040000003Vc;`0i/bl000000T0fLS900<0
00000;:F^P2bU[X01`2bU[X00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01/0oooo000P
0?ooo`D000000`2:KZd010000000NVnk07Y_^`1jKk/8000000D0oooo0`000005040000040000001I
01@0F@0D05T050D0000000<0gl2i0000000000002@3L_;T00`000000dk2g0=>`]`050=>`]`030000
002oWkP0_inh00D0_inh00D000000;>C]P2cTkH0/i>f000000090:>4/`030000002BN;80TWRb00H0
TWRb00<0000007YZ]@1jJ[D0101jJ[D00`000000BU>i04YC^@0204YC^@8000001`2<O;d01@000000
Xh>a0:>3/@2SPk40000000P0`:S20`0000020=Zf]0030000003_d;<0km2c00D0km2c00<000000?KU
]@3fiKD0103fiKD00`000000kORn0>gh_P050>gh_P030000002_ml40000000`0em[J00<000000;^U
``2kYL<01@00000209VEcP030000002IP[X0VH:j00L0VH:j00<0000009Ul/P2IO;801`2IO;800`00
0000VWb`09Yl/00809Yl/0030000002MOk80WGnb00P0WGnb00D000000::8^02RR;P0XXRh00000008
0;bO^P050000003=//00cK;00<fb`0000000203Vbk/02@000000mNZi0?GZ^@3ej[T000000?GZ^@00
0000i/bl0000000;0=W8b@030000002bU[X0/YJj00L0/YJj00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`070?ooo`D000003`3oool00200oooo00<0000008Y^[@2:KZd01P2:KZd00`000000
NVnk07Y_^`0507Y_^`030000001HUnl0F9O_014000001P3O`;T00`000000i<2c000000080=bl^@03
0000003C/;L0dk2g00D0dk2g00<000000;nO^02oWkP00`2oWkP2000000@0/i>f00<000000:>4/`2S
Q;<01`2SQ;<00`000000TWRb099h/P06099h/P030000001jJ[D0NVZe00D0NVZe00@0000004YC^@1:
DkT0BU>i1000000508al_@040000002SPk40Xh>a000000L0`:S20P0000001@30Z<8000000=Zf]03J
][@0000000P0km2c00<000000?KU]@3fiKD00`3fiKD00`000000kORn0>gh_P050>gh_P040000002_
ml40[oO10:og`@800000203Gf]X5000000P0VIG>00<0000009V2^P2IP[X01P2IP[X00`000000VGbb
09Ul/P0809Ul/P030000002JO;00VWb`00L0VWb`00<0000009eo/P2MOk80202MOk8010000000XXRh
0::8^000000:0;bO^P040000003=//00cK;0000000L0i/^k00<000000?GZ^@3ej[T00`3ej[T00`00
0000mNZi0000000<0=W8b@030000002bU[X0/YJj00H0/YJj0P00000D0?ooo`030000003oool0oooo
00H0oooo00D000000?ooo`3oool0oooo0000000?0?ooo`007`3oool2000000P0RVj]00<0000007Y_
^`1jKk/01P1jKk/00`000000F9O_05RGk`0605RGk`030000003>`<d0c/3=00D0c/3=00<000000=o0
^@3O`;T01@3O`;T010000000i<2c0>C0/`0000060=bl^@030000003C/;L0dk2g00L0dk2g00D00000
0;nO^02oWkP0_inh000000060;>C]P030000002SQ;<0XhBc00L0XhBc00<00000099h/P2BN;801P2B
N;800`000000NVZe07YZ]@0507YZ]@030000001:DkT0BU>i0080BU>i0P0000000`1OO]X000000000
000200000080S7bm0P0000050<2X`P<000001030Z<800`000000f[Jd000000070>o@/`030000003f
iKD0m^Fe00@0m^Fe00<000000>gh_P3]n;h0103]n;h00`000000[oO10:og`@040:og`@040000003G
f]X0em[J0=OJfP@000000P29b?d00`000000VIG>09VEcP0809VEcP030000002IP[X0VH:j00H0VH:j
00<0000009Ul/P2IO;80202IO;800`000000VWb`09Yl/00809Yl/0030000002MOk80WGnb00P0WGnb
0P00000;0;bO^P030000003=//00000000L0i/^k00<000000?GZ^@3ej[T0103ej[T2000000030<ok
/`000000fLS900X0fLS900<000000;:F^P2bU[X00`2bU[X30000000309n<_`000000oooo01@0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0@0?ooo`007`3oool3000000L0RVj]00<0
000007Y_^`1jKk/01`1jKk/00`000000F9O_05RGk`0405RGk`030000003>`<d0c/3=00D0c/3=00<0
00000=o0^@3O`;T01@3O`;T00`000000i<2c0>C0/`020>C0/`030000003L_;T0g;bi00<0g;bi00<0
00000=>`]`3C/;L01`3C/;L010000000_inh0;nO^00000080;>C]P030000002SQ;<0XhBc00H0XhBc
00<00000099h/P2BN;801`2BN;800`000000NVZe07YZ]@0407YZ]@030000001:DkT0BU>i00<0BU>i
00<0000005mnfP1OO]X00`1OO]X3000000<0`:S20`0000070<2X`P800000203_d;<00`000000m^Fe
0?KU]@030?KU]@030000003]n;h0kORn00<0kORn0P0000040:og`@L000001`29b?d00`000000VIG>
09VEcP0709VEcP030000002IP[X0VH:j00L0VH:j00<0000009Ul/P2IO;801`2IO;800`000000VWb`
09Yl/00809Yl/0030000002MOk80WGnb00P0WGnb00<000000;bO^P2lWkX02`2lWkX2000000L0i/^k
00<000000?GZ^@3ej[T0103ej[T2000000030<ok/`000000fLS900/0fLS900<000000;:F^P000000
0P00000509n<_`030000003oool0oooo0180oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0?0?ooo`007`3oool00`000000oooo0000000808Y^[@030000001jKk/0NVnk00H0NVnk00<0
000005RGk`1HUnl00`1HUnl00`000000c/3=0<k0c@060<k0c@030000003O`;T0gl2i00D0gl2i00<0
00000>C0/`3T`;<00P3T`;<00`000000g;bi0=bl^@020=bl^@030000003C/;L0dk2g00T0dk2g0P00
00090;>C]P030000002SQ;<0XhBc00H0XhBc00<00000099h/P2BN;801`2BN;800`000000NVZe07YZ
]@0507YZ]@030000001:DkT0BU>i0080BU>i0P00000605mnfP@000002`30Z<800`000000km2c0>o@
/`050>o@/`030000003fiKD0m^Fe00<0m^Fe00<000000>gh_P3]n;h00`3]n;h00`000000[oO10000
000400000080CIgd1000000808W8o@030000002IULh0VIG>00P0VIG>00<0000009V2^P2IP[X01P2I
P[X00`000000VGbb09Ul/P0709Ul/P030000002JO;00VWb`00P0VWb`00<0000009eo/P2MOk801`2M
Ok82000000d0_9nj00<000000>K;^`3Vbk/01@3Vbk/00`000000mNZi0?GZ^@050?GZ^@050000003?
nk<000000<ok/`0000002P3Ib<T3000000P0Whbo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00h0oooo000O0?ooo`030000003oool0000000P0RVj]00<0
000007Y_^`1jKk/01`1jKk/01@000000F9O_05RGk`1HUnl0000000P0c/3=00<000000=o0^@3O`;T0
1@3O`;T00`000000i<2c0>C0/`040>C0/`040000003L_;T0g;bi000000`0dk2g00<000000;>C]P2c
TkH0202cTkH00`000000XhBc0:>4/`070:>4/`030000002BN;80TWRb00H0TWRb00<0000007YZ]@1j
J[D01@1jJ[D00`000000BU>i04YC^@0304YC^@030000001OO]X0GgkJ0080GgkJ1000000<0<2X`P04
0000003Mg]L00000000000D0km2c00<000000?KU]@3fiKD00P3fiKD00`000000kORn0>gh_P030>gh
_P<000001@3>cMP010000000CIgd04fMm01=WO@4000000L0RLSm00<0000009VEcP2IULh01`2IULh0
0`000000VH:j09V2^P0609V2^P030000002IO;80VGbb00P0VGbb00<0000009Yl/02JO;001`2JO;00
0`000000WGnb09eo/P0509eo/P8000000P2^T[T00`000000_9nj0;bO^P090;bO^P030000003Nb<@0
000000H0i/^k00<000000?GZ^@3ej[T0103ej[T01`000000co^c0<ok/`3?nk<000000<ok/`000000
1P3Ib<T3000000030:NiiP000000Whbo00P0Whbo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00d0oooo000O0?ooo`<00000202:KZd00`000000NVnk07Y_
^`0807Y_^`030000001HUnl0000000P0c/3=00<000000=o0^@3O`;T01P3O`;T00`000000i<2c0>C0
/`050>C0/`030000003L_;T0000000/0dk2g0P00000;0;>C]P030000002SQ;<0XhBc00H0XhBc00<0
0000099h/P2BN;801P2BN;800`000000NVZe07YZ]@0507YZ]@030000001:DkT0BU>i00@0BU>i1000
000305mnfP0300000030Z<80`:S200T0`:S200<000000=gNe`3Mg]L00P3Mg]L01@000000km2c0>o@
/`3_d;<0000000D0m^Fe00<000000>gh_P3]n;h00P3]n;h2000000P0c/gH0`00000204fMm0<00000
1P29b?d00`000000VIG>09VEcP0709VEcP030000002IP[X0VH:j00H0VH:j00<0000009Ul/P2IO;80
202IO;800`000000VWb`09Yl/00809Yl/0030000002MOk80WGnb00<0WGnb00<000000:jB^@2^T[T0
0P2^T[T00`000000_9nj0;bO^P080;bO^P050000003Nb<@0g/S40=k8a0000000103Vbk/00`000000
mNZi0?GZ^@040?GZ^@030000003?nk<0co^c0080co^c00<000000<ok/`0000000P3Ib<T4000000D0
YkWV00<0000009n<_`2OS;l01`2OS;l00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo0000000?0?ooo`007`3oool00`000000oooo0000000808Y^[@03
0000001jKk/0NVnk00T0NVnk00<000000<k0c@3>`<d01`3>`<d00`000000gl2i0=o0^@050=o0^@03
0000003T`;<0i<2c00L0i<2c00<000000=>`]`3C/;L02@3C/;L010000000b:Vj0<RY^P00000:0;>C
]P030000002SQ;<0XhBc00H0XhBc00<00000099h/P2BN;801`2BN;800`000000NVZe07YZ]@0507YZ
]@040000001:DkT0BU>i04YC^@<000001`1OO]X00`000000`:S20<2X`P070<2X`P030000003Mg]L0
gMkG00@0gMkG0P0000000`3_d;<000000?KU]@030?KU]@030000003]n;h0kORn00<000002@3>cMP2
00000080O7[61P00000608W8o@030000002IULh0VIG>00H0VIG>00<0000009V2^P2IP[X01`2IP[X0
0`000000VGbb09Ul/P0709Ul/P030000002JO;00VWb`00P0VWb`00<0000009eo/P2MOk800P2MOk80
0`000000[Y:i0:jB^@040:jB^@030000002lWkX0_9nj00L0_9nj00D000000=k8a03Nb<@0g/S40000
00040>K;^`030000003ej[T0mNZi00<0mNZi00<000000<ok/`3?nk<0103?nk<4000000T0YkWV00<0
000009n<_`2OS;l01`2OS;l00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00<0oooo0`00
000@0?ooo`005@3oool4000000D0oooo00D000000?ooo`3oool0oooo0000000808Y^[@030000001j
Kk/0NVnk00L0NVnk00<000000;VJ^@0000001`3>`<d00`000000gl2i0=o0^@060=o0^@030000003T
`;<0i<2c00H0i<2c00<000000>?2]P0000002P3C/;L010000000b:Vj0<RY^P00000:0;>C]P030000
002SQ;<0XhBc00H0XhBc00<00000099h/P2BN;801P2BN;8=000000<0BU>i00<0000005mnfP1OO]X0
101OO]X00`000000`:S20<2X`P060<2X`P030000003Mg]L0gMkG00L0gMkG2`0000090<k=f0040000
002lXl00_:?0000000D0O7[61000000408W8o@030000002IULh0VIG>00L0VIG>00<0000009V2^P2I
P[X01P2IP[X00`000000VGbb09Ul/P0709Ul/P030000002JO;00VWb`00P0VWb`00<0000009eo/P2M
Ok800P0000070:jB^@030000002lWkX0_9nj00H0_9nj00<000000=k8a03Nb<@00`3Nb<@010000000
i/^k0>K;^`0000050?GZ^@030000003?nk<0co^c00<0co^c1P0000090:NiiP030000002OS;l0Whbo
00L0Whbo00<000000?ooo`3oool04P3oool2000000030?ooo`000000oooo01H0oooo000D0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
00P0RVj]00<0000007Y_^`1jKk/01P1jKk/01@000000^IZi0;VJ^@2iV[T0000000D0c/3=00<00000
0=o0^@3O`;T01P3O`;T00`000000i<2c0>C0/`070>C0/`030000003S`[H0000000T0dk2g00D00000
0<RY^P38ZKX0b:Vj0000000;0;>C]P030000002SQ;<0XhBc00H0XhBc00<00000099h/P2BN;800P2B
N;830000000309Ih[`000000SG>a00@0SG>a0`000003081b^P@000001`1OO]X00`000000`:S20<2X
`P040<2X`P030000003Mg]L0gMkG00L0gMkG00<000000=3od03@om000P3@om000`000000O]ZJ07kJ
VP03000000T0c/gH00D000000;bS`02lXl00_:?00000000707ajaP@000000`29b?d00`000000VIG>
09VEcP0609VEcP030000002IP[X0VH:j00H0VH:j00<0000009Ul/P2IO;80202IO;800`000000VWb`
09Yl/00809Yl/08000002@2^T[T00`000000_9nj0;bO^P050;bO^P030000003Nb<@0g/S400D0g/S4
00<000000>K;^`000000103ej[T00`000000co^c0<ok/`0:000000T0YkWV00<0000009n<_`2OS;l0
202OS;l00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01D0oooo000D0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool200000080oooo00<0000008Y^[@2:KZd01P2:
KZd00`000000NVnk07Y_^`0507Y_^`030000002iV[T0^IZi00<0^IZi00<000000<k0c@3>`<d00P3>
`<d00`000000gl2i0=o0^@060=o0^@030000003T`;<0i<2c00H0i<2c00D000000>?2]P3S`[H0hl:f
000000070=>`]`0300000038ZKX0b:Vj00<0b:Vj00<000000;>C]P2cTkH0202cTkH00`000000XhBc
0:>4/`060:>4/`030000002BN;80000000800000102FN:l00`000000SG>a08ec/@03000000<0SG>a
00<00000081b^P20L[X01020L[X2000000D0GgkJ00<000000<2X`P30Z<800`30Z<800`000000gMkG
0=gNe`070=gNe`030000003@om00d?o@0080d?o@00P0000007kJVP00000000000=cAcP000000h/Nm
000000L0c/gH00<000000;bS`02lXl000`2lXl000`000000O7[607ajaP0507ajaPD0000000<0RLSm
0000002IULh01`2IULh00`000000VH:j09V2^P0609V2^P030000002IO;80VGbb00P0VGbb00<00000
09Yl/02JO;001`2JO;02000000/0[Y:i00<000000;bO^P2lWkX00`2lWkX00`000000g/S40=k8a007
0=k8a0030000003ej[T0mNZi00<0mNZi10000003011OePL000002@2W^NH00`000000Whbo09n<_`07
09n<_`030000003oool0oooo01D0oooo00<000000?ooo`3oool0503oool001@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000002@2:KZd0
0`000000NVnk07Y_^`0207Y_^`8000001`2iV[T010000000c/3=0<k0c@0000080=o0^@030000003T
`;<0i<2c00L0i<2c00D000000>?2]P3S`[H0hl:f000000060=>`]`0300000038ZKX0b:Vj00@0b:Vj
00<000000;>C]P2cTkH0202cTkH00`000000XhBc0:>4/`050:>4/`<000001`2FN:l3000000H0SG>a
00<00000081b^P20L[X01@20L[X3000000@0GgkJ00D000000<2X`P30Z<80`:S2000000090=gNe`03
0000003@om00d?o@0080d?o@0`0000030=cAcP040000003Rakd0h/Nm000000D0c/gH00<000000;bS
`02lXl00102lXl000`000000O7[607ajaP0507ajaP050000000=?;`0000000000000C/<00`000008
09VEcP030000002IP[X0VH:j00H0VH:j00<0000009Ul/P2IO;801`2IO;800`000000VWb`09Yl/005
09Yl/080000000<0XhVi0000002^T[T02P2^T[T00`000000_9nj0;bO^P030;bO^P030000003Nb<@0
g/S400H0g/S400@000000=_j[P00000000000P3ej[T200000080PGNo0`000003011OePH00000202W
^NH00`000000Whbo09n<_`0709n<_`030000003oool0oooo01H0oooo00<000000?ooo`3oool04`3o
ool001@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000002@2:KZd01@000000NVnk07Y_^`1jKk/0000000X0^IZi00<000000<k0c@000000
203O`;T00`000000i<2c0>C0/`060>C0/`030000003S`[H0hl:f00<0hl:f00<000000=>`]`3C/;L0
0P3C/;L00`000000b:Vj0<RY^P050<RY^P030000002cTkH0/i>f00P0/i>f00<000000:>4/`2SQ;<0
0`2SQ;<20000000309en/@000000UWR_00D0UWR_0P0000000`2FN:l0000008ec/@0608ec/@030000
0020L[X0P7:j00H0P7:j00@00000001Xc`00000000000P1OO]X010000000`:S20<2X`P0000090=gN
e`040000003@om00d?o@0=3od0<00000103LdLh00`000000h/Nm0>;7_@020>;7_@050000003>cMP0
c/gH0<k=f00000001`2lXl000`000000O7[607ajaP0607ajaP040000000=?;`000000000008004k3
0P00000709VEcP030000002IP[X0VH:j00H0VH:j00<0000009Ul/P2IO;801`2IO;800`000000VWb`
09Yl/00209Yl/0<00000102SRKT00`000000[Y:i0:jB^@080:jB^@030000002lWkX0_9nj0080_9nj
00<000000=k8a03Nb<@01`3Nb<@010000000foZ^0=_j[P3KnZh2000000D0PGNo00@0000005eWa@00
000000000P0@GmH5000000P0YkWV00<0000009n<_`2OS;l0202OS;l00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo01<0oooo000D0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000000T0RVj]00@0000007Y_^`1jKk/00000302iV[T0
0`000000gl2i0=o0^@060=o0^@030000003T`;<0i<2c00H0i<2c00<000000>?2]P3S`[H0103S`[H0
1@000000dk2g0=>`]`3C/;L0000000T0b:Vj00<000000;>C]P2cTkH0202cTkH00`000000XhBc0000
0002000000@0WGja00<0000009Ih[`2FN:l00`00000309Ih[`030000002=Lk40SG>a00H0SG>a00<0
0000081b^P20L[X01@20L[X300000004001Xc`000000000005mnfP8000002@3Mg]L010000000d?o@
0=3od03@om03000000@0g=7>00<000000>;7_@3Rakd0103Rakd00`000000c/gH000000090;bS`003
0000001lN/H0O7[600D0O7[600D0000000dl_00=?;`03Cbl00000002001>``@00000102IULh00`00
0000VH:j09V2^P0609V2^P030000002IO;80VGbb00P0VGbb00@0000009Yl/000000000001`2SRKT0
0`000000[Y:i0:jB^@090:jB^@040000002lWkX0_9nj000000T0g/S400<000000=_j[P3KnZh00P3K
nZh00`000000PGNo085g_`04085g_`050000001MIlD0GFO505eWa@0000000P0@GmH2000000030500
00000000000000P0YkWV00<0000009n<_`2OS;l01`2OS;l00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo0180oooo000D0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo
0`0000030?ooo`030000002:KZd0RVj]00L0RVj]0P00000<0;VJ^@030000003G];H0000000L0gl2i
00<000000>C0/`3T`;<01P3T`;<00`000000hl:f0>?2]P050>?2]P040000003C/;L0dk2g000000T0
b:Vj00<000000;>C]P2cTkH0202cTkH2000000L0WGja0`00000609Ih[`030000002=Lk40SG>a00H0
SG>a00<00000081b^P20L[X01P20L[X00`000000J7WA00000002001Xc`8000002@3Mg]L010000000
d?o@0=3od03@om02000000H0g=7>00<000000>;7_@3Rakd01@3Rakd00`000000_:?00;bS`0080;bS
`0030000001lN/H0O7[600H0O7[600L0000000dl_00=?;`03Cbl00000000C/<0000000<0E7SI1000
00000`2IULh0000009V2^P0609V2^P030000002IO;80VGbb00H0VGbb100000090:>9^@030000002^
T[T0[Y:i00T0[Y:i00<000000;bO^P0000002@3Nb<@00`000000foZ^0=_j[P020=_j[P0300000021
Mkl0PGNo00D0PGNo00<0000005eWa@1MIlD00P1MIlD200000005011OeP00000000000000001@0000
0P0000060:NiiP030000002OS;l0Whbo00L0Whbo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0A0?ooo`005@3oool4000000@0oooo00<000000?ooo`3oool00`3oool00`000000RVj]08Y^
[@0708Y^[@030000002iV[T0^IZi00/0^IZi00@000000=Nd]P3G];H000001@3O`;T00`000000i<2c
0>C0/`060>C0/`030000003S`[H0hl:f00H0hl:f00<000000=>`]`0000002`38ZKX00`000000/i>f
0;>C]P050;>C]P<000001@2MO[44000000P0UWR_00<0000008ec/@2=Lk401P2=Lk400`000000P7:j
081b^P07081b^P040000001XNM4000000000008006S?0P0000060=gNe`040000003@om00d?o@0=3o
d0<000001@3LdLh00`000000h/Nm0>;7_@050>;7_@8000002`2lXl000`000000O7[607ajaP0507aj
aP030000000=?;`03Cbl00803Cbl00<00000001>``0000001P1DN=T6000000@0VH:j00<0000009Ul
/P2IO;801@00000209R4_@030000002SRKT0XhVi00T0XhVi00<000000:jB^@2^T[T02@2^T[T20000
00T0g/S400@000000=_j[P3KnZh0foZ^0P000008085g_`030000001MIlD0GFO500<0GFO50P000000
1@00<[P00000000000000000;GSS00800000102W^NH00`000000Whbo09n<_`0809n<_`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool04@3oool001d0oooo00<000000?ooo`3oool00`3oool0
0`000000RVj]08Y^[@0508Y^[@<00000302iV[T00`000000ekBf0=Nd]P020=Nd]P030000003O`;T0
gl2i0080gl2i00<000000>C0/`3T`;<01P3T`;<00`000000hl:f0>?2]P070>?2]P0300000038ZKX0
b:Vj00X0b:Vj00<000000;>C]P2cTkH00`2cTkH200000080YhZf00<0000009en/@2MO[400`000003
09en/@030000002FN:l0UWR_00L0UWR_00<0000008ec/@2=Lk401@2=Lk400`000000P7:j081b^P07
081b^P040000001XNM40J7WA06Qid@<0000000<006S?0000003Mg]L00`3Mg]L00`000000d?o@0=3o
d002000000030;SGl0000000g=7>00@0g=7>00<000000>;7_@3Rakd01P3Rakd00`000000g[nj0000
000:0;bS`0030000001lN/H0O7[600H0O7[600L0000000dl_00=?;`03Cbl00000000C/<0000000L0
E7SI00<0000008B0aP24P<H00P24P<H7000000P0V8Bm00<000000:>9^@2SRKT0202SRKT00`000000
[Y:i0:jB^@090:jB^@030000003Nb<@0g/S400L0g/S400L000000=_j[P3KnZh0foZ^0000002FP[/0
000000P0PGNo00<0000005eWa@1MIlD01@1MIlD00`00000003:h000b^00200000080;GSS0P000002
0:NiiP030000002OS;l0Whbo00P0Whbo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@
0?ooo`007@3oool2000000@0oooo00<0000008Y^[@2:KZd0102:KZd01@000000YhRc0:N8/`2WR;<0
000000X0^IZi00<000000=Nd]P3G];H0103G];H010000000gl2i0=o0^@0000080>C0/`030000003S
`[H0hl:f00L0hl:f00<000000=k6`@0000002`38ZKX010000000/i>f0;>C]P2cTkH2000000@0YhZf
0`00000709en/@030000002FN:l0UWR_00H0UWR_00<0000008ec/@2=Lk401P2=Lk400`000000P7:j
081b^P07081b^P030000001XNM40J7WA0080J7WA1@0000000`3Mg]L000000000000200000080^=O`
00<000000=cAcP3LdLh0103LdLh00`000000h/Nm0>;7_@050>;7_@040000003N_kX0g[nj000000/0
_:?000<0000007ajaP1lN/H01@1lN/H00`0000003Cbl00dl_00200dl_00300000000C/<0000000L0
E7SI00<0000008B0aP24P<H01@24P<H00`000000V8Bm09R4_@0809R4_@030000002SRKT0XhVi00P0
XhVi00<000000:jB^@2^T[T0202^T[T00`000000c/CA000000070=k8a0050000003KnZh0foZ^0=_j
[P0000000`2FP[/00`000000PGNo085g_`05085g_`030000001MIlD0GFO500D0GFO50P0000001000
<[P0000000000000000302ehh`80000000<0YkWV0000002OS;l0202OS;l00`000000oooo0?ooo`0G
0?ooo`8000004@3oool001d0oooo00<000000?ooo`3oool00`3oool00`000000RVj]08Y^[@0208Y^
[@800000102WR;<00`000000^IZi0;VJ^@080;VJ^@030000003G];H0ekBf00D0ekBf00<000000=o0
^@000000203T`;<00`000000hl:f0>?2]P070>?2]P030000003Na/40000000`0b:Vj0`0000030:N:
]P<0000000<0YhZf0000002MO[401`2MO[400`000000UWR_09Ih[`0609Ih[`030000002=Lk40SG>a
00H0SG>a00<00000081b^P20L[X01`20L[X00`000000J7WA06Qid@02000000@0[Io90`0000001@2]
WlT000000000002heo00000000H0g=7>00<000000>;7_@3Rakd01@3Rakd00`000000g[nj0=jo^P02
0=jo^P030000002lXl00_:?000P0_:?02P00000400dl_08000001`1DN=T00`000000Q83608B0aP06
08B0aP030000002HQ;d0V8Bm00L0V8Bm00<000000:>9^@2SRKT02@2SRKT00`000000[Y:i0:jB^@06
0:jB^@040000003>a=40c/CA000000H0g/S400D000000=_j[P3KnZh0foZ^0000000409J2^`030000
0021Mkl0PGNo00H0PGNo00<0000005eWa@1MIlD01@1MIlD200000003000b^0000000000000D0;GSS
1`00000509n<_`030000003oool0oooo01H0oooo0P00000A0?ooo`007@3oool00`000000oooo0?oo
o`040?ooo`040000002:KZd0RVj]000000H0YhRc00<000000;VJ^@2iV[T01`2iV[T00`000000ekBf
0=Nd]P070=Nd]P030000003T`;<0i<2c00H0i<2c00<000000>?2]P3S`[H01`3S`[H01@000000g/K1
0=k6`@3Na/40000000/0b:Vj00<000000:N:]P2WR[H00`0000040:N:]P030000002MO[40WGja00H0
WGja00<0000009Ih[`2FN:l01P2FN:l00`000000SG>a08ec/@0608ec/@0300000020L[X0P7:j00P0
P7:j0P00000<0:fOb@030000003LdLh0g=7>00D0g=7>00<000000>;7_@3Rakd01@3Rakd00`000000
g[nj0=jo^P020=jo^P030000002lXl00_:?000H0_:?00`00000808ae/`<000000`0=?;`2000000L0
E7SI00<0000008B0aP24P<H01@24P<H00`000000V8Bm09R4_@0809R4_@030000002SRKT0XhVi00P0
XhVi00<000000:jB^@2^T[T01@2^T[T00`000000c/CA0<k4d@020<k4d@030000003Nb<@0g/S400<0
g/S400@000000=_j[P3KnZh000001@2FP[/00`000000PGNo085g_`06085g_`030000001MIlD0GFO5
00D0GFO500@0000001i?a`00000003:h0P00000502ehh`0300000023Rm80Ph_B00<0Ph_B1P00000J
0?ooo`030000003oool0oooo00h0oooo000L0?ooo`030000003oool0oooo00D0oooo0`0000080:N8
/`030000002iV[T0^IZi00H0^IZi00<000000=Nd]P3G];H01P3G];H00`000000i/Jf000000060>C0
/`030000003S`[H0hl:f00L0hl:f00<000000=k6`@3Na/400P3Na/400`000000b:Vj0<RY^P080<RY
^P@000001`2WR[H00`000000WGja09en/@0609en/@030000002FN:l0UWR_00L0UWR_00<0000008ec
/@2=Lk401P2=Lk400`000000P7:j081b^P05081b^P<00000302]WlT00`000000c[:n000000050=cA
cP030000003Rakd0h/Nm00D0h/Nm00<000000=jo^P3N_kX00`3N_kX00`000000_:?00;bS`0050;bS
`0050000002/S[H0[8jf0:b>]P000000202<MK<010000000J6Fk00000000000200dl_0030000001D
N=T0E7SI00D0E7SI00<0000008B0aP24P<H01@24P<H00`000000V8Bm09R4_@0809R4_@030000002S
RKT0XhVi00P0XhVi00<000000:jB^@2^T[T0102^T[T00`000000c/CA0<k4d@040<k4d@050000003N
b<@0g/S40=k8a00000000P3KnZh00`000000UX:k09J2^`0409J2^`0300000021Mkl0PGNo00H0PGNo
00<0000005eWa@1MIlD01P1MIlD0100000007To700000000<[P2000000D0;GSS00<0000008>;dP23
Rm801`23Rm800`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00h0oooo000L0?ooo`030000
003oool0000000D0oooo00<000000:N8/`2WR;<0202WR;<00`000000^IZi0;VJ^@050;VJ^@030000
003G];H0ekBf00L0ekBf00@000000>K6]P3Va[H000001@3T`;<00`000000hl:f0>?2]P070>?2]P03
0000003Na/40g/K100<0g/K100<000000<RY^P38ZKX01@38ZKX3000000030;NP`@000000YhZf00L0
YhZf00<0000009en/@2MO[401`2MO[400`000000UWR_09Ih[`0609Ih[`030000002=Lk40SG>a00H0
SG>a00<00000081b^P20L[X00`20L[X2000000<0XhRh00<000000:fOb@2]WlT0202]WlT010000000
c[:n0<jb_P3>/[h200000080g=7>00<000000>;7_@3Rakd01@3Rakd00`000000g[nj0=jo^P050=jo
^P030000002lXl00_:?00080_:?00P0000040:b>]P030000002<MK<0S7Fc00H0S7Fc00@0000006QU
^`1XIK/0J6Fk0P0000000`0=?;`0000005Ahf@0505Ahf@0300000024P<H0Q83600H0Q83600<00000
09R4_@2HQ;d01`2HQ;d00`000000XhVi0:>9^@090:>9^@030000002^T[T0[Y:i0080[Y:i00<00000
0<k4d@3>a=401P3>a=400`000000g/S4000000020=_j[P030000002FP[/0UX:k00H0UX:k00<00000
085g_`21Mkl01P21Mkl00`000000GFO505eWa@0505eWa@030000000NClL07To700D000000`0]N><0
0`000000Ph_B08>;dP0808>;dP030000003oool0oooo01P0oooo00<000000?ooo`3oool03@3oool0
01`0oooo0P0000060?ooo`030000002WR;<0YhRc00P0YhRc00<000000;VJ^@2iV[T0102iV[T00`00
0000ekBf0=Nd]P070=Nd]P030000003Va[H0i/Jf0080i/Jf0P0000020>C0/`030000003S`[H0hl:f
00L0hl:f00<000000=k6`@3Na/401@3Na/400`000000b:Vj0<RY^P020<RY^P<000000`2gX<400`00
0000YhZf0:N:]P070:N:]P030000002MO[40WGja00H0WGja00<0000009Ih[`2FN:l01P2FN:l00`00
0000SG>a08ec/@0608ec/@0400000020L[X0P7:j081b^P8000001@2SR;P00`000000[Io90:fOb@08
0:fOb@030000003>/[h0c[:n00<0c[:n00<000000=cAcP0000001`3Rakd00`000000g[nj0=jo^P05
0=jo^P050000002lXl00_:?00;bS`00000001P2/S[H00`000000S7Fc08ae/`0608ae/`030000001X
IK/0J6Fk00<0J6Fk1000000505Ahf@0300000024P<H0Q83600D0Q83600<0000009R4_@2HQ;d01`2H
Q;d00`000000XhVi0:>9^@090:>9^@050000002^T[T0[Y:i0:jB^@0000002@3>a=400`000000g/S4
00000002000000L0UX:k3@00000705eWa@040000000NClL07To701i?a`80000000<003Fi0000000]
N><00P0]N><00`000000Ph_B08>;dP0708>;dP030000003oool0oooo0100oooo0P0000070?ooo`03
0000003oool0oooo00`0oooo000L0?ooo`030000003oool0oooo00D0oooo00<000000:N8/`2WR;<0
2@2WR;<00`000000^IZi0;VJ^@030;VJ^@030000003G];H0ekBf00L0ekBf00<000000>K6]P3Va[H0
103Va[H00`000000i<2c000000080>?2]P030000003Na/40g/K100H0g/K100<000000<RY^P000000
100000040;NP`@030000002WR[H0YhZf00L0YhZf00<0000009en/@2MO[401P2MO[400`000000UWR_
09Ih[`0609Ih[`030000002=Lk40SG>a00L0SG>a0`0000080:>8^0030000002]WlT0[Io900H0[Io9
00<000000<jb_P3>/[h01@3>/[h00`000000h/Nm0>;7_@050>;7_@030000003N_kX0g[nj00L0g[nj
0`0000070:b>]P030000002<MK<0S7Fc00H0S7Fc00<0000006QU^`1XIK/01@1XIK/3000000@0E7SI
00<0000008B0aP24P<H01@24P<H00`000000V8Bm09R4_@0809R4_@030000002SRKT0XhVi00P0XhVi
00@000000:jB^@2^T[T000002`3>a=4200000080Yhfj00<0000009J2^`2FP[/01000000209Qk/@03
0000002>Mk@0SWNd00H0SWNd00<00000081c_00000000P00000405eWa@030000000NClL07To70080
7To70P0000001@00=KT0000002ehh`0]N><0000000T0Ph_B00<000000?ooo`3oool03P3oool30000
00030>7Ld0000000oooo00D0oooo00<000000?ooo`3oool0303oool001`0oooo00<000000?ooo`3o
ool01P3oool00`000000YhRc0:N8/`080:N8/`030000002iV[T0^IZi0080^IZi00<000000=Nd]P3G
];H01`3G];H00`000000i/Jf0>K6]P060>K6]P030000003S`[H0hl:f00H0hl:f00<000000=k6`@3N
a/401P3Na/4300000080b:Vj00<000000;NP`@2gX<401@2gX<400`000000YhZf0:N:]P060:N:]P03
0000002MO[40WGja00H0WGja00<0000009Ih[`2FN:l01P2FN:l00`000000SG>a08ec/@0608ec/@80
00002P2SR;P00`000000[Io90:fOb@050:fOb@030000003>/[h0c[:n00D0c[:n00<000000>;3^@00
00001P3Rakd00`000000g[nj0=jo^P070=jo^P030000002/S[H0[8jf00P0[8jf00<0000008ae/`2<
MK<01P2<MK<00`000000J6Fk06QU^`0406QU^`80000000<003Ji0000001DN=T00P1DN=T00`000000
Q83608B0aP0608B0aP030000002HQ;d0V8Bm00L0V8Bm00<000000:>9^@2SRKT02@2SRKT2000000/0
c/CA0P0000020:N=^P@000001`2HNk400`000000SWNd08ig]00608ig]00400000020Lk`0P7>l081c
_0@0000000<0GFO50000000NClL00`0NClL01000000003Fi000e^@00000202ehh`0300000023Rm80
Ph_B00L0Ph_B00<000000?ooo`3oool0303oool00`000000eOgM000000030>7Ld0030000003oool0
oooo00@0oooo00<000000?ooo`3oool02`3oool001`0oooo0`0000060?ooo`030000002WR;<0YhRc
00T0YhRc00@000000;VJ^@2iV[T000002P3G];H00`000000i/Jf0>K6]P050>K6]P030000003]e[/0
000000L0hl:f00<000000=k6`@3Na/400`3Na/4300000080g/K100<000000<RY^P000000202gX<40
0`000000YhZf0:N:]P060:N:]P030000002MO[40WGja00L0WGja00<0000009Ih[`2FN:l01P2FN:l0
0`000000SG>a08ec/@0208ec/@<0000000<0WGna0000002SR;P02P2SR;P00`000000[Io90:fOb@03
0:fOb@030000003>/[h0c[:n00H0c[:n00@000000>;3^@3R`kT00000103Rakd00`000000g[nj0=jo
^P070=jo^P8000002P2/S[H00`000000S7Fc08ae/`0608ae/`030000001XIK/0J6Fk00D0J6Fk0P00
00000`00=[T000000000000205Ahf@0300000024P<H0Q83600D0Q83600<0000009R4_@2HQ;d01`2H
Q;d00`000000XhVi0:>9^@090:>9^@030000003>a=40c/CA00T0c/CA1@0000000`2QP[80000009Qk
/@0809Qk/@030000002>Mk@0SWNd00H0SWNd00<00000081c_020Lk`01@20Lk`3000000<07To70P00
0002000e^@030000000]N><0000000T0Ph_B00<000000?ooo`3oool02`3oool2000000030=Gmg@00
0000hMc@00<0hMc@00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?ooo`006`3oool0
0`000000oooo0?ooo`070?ooo`030000002WR;<0YhRc00T0YhRc00@000000;VJ^@2iV[T000002@3G
];H00`000000i/Jf0>K6]P060>K6]P040000003]e[/0kMJk000000D0hl:f00@000000=k6`@3Na/40
g/K10`0000060=k6`@030000002gX<40]j3100L0]j3100<000000:N:]P2WR[H01`2WR[H00`000000
WGja09en/@0609en/@030000002FN:l0UWR_00H0UWR_00<0000008ec/@0000000P00000509eo/@03
0000002SR;P0XhRh00P0XhRh00<000000:fOb@2]WlT00P2]WlT00`000000c[:n0<jb_P060<jb_P03
0000003R`kT0h/>i0080h/>i00@000000>;7_@3Rakd000002@3N_kX010000000d;S30=2h``000009
0:b>]P030000002<MK<0S7Fc00H0S7Fc00<0000006QU^`1XIK/01@1XIK/00`0000006UgD00000002
000f^@030000001DN=T0000000L0Q83600<0000009R4_@2HQ;d0202HQ;d00`000000XhVi0:>9^@06
0:>9^@80000000<0^;gN0000003>a=40203>a=43000000D0XH:b00<0000009Qk/@2HNk401P2HNk40
0`000000SWNd08ig]00608ig]00300000020Lk`0P7>l00H0P7>l00@0000006Ecc@00000000000P0N
ClL300000004000e^@0000000000000000P0Ph_B00<000000?ooo`3oool02P3oool2000000030=Gm
g@000000hMc@00<0hMc@0P0000060?ooo`030000003oool0oooo00X0oooo00020?ooo`@000001@3o
ool2000000D0oooo100000050?ooo`030000003oool0oooo00L0oooo00<000000:N8/`2WR;<02@2W
R;<00`000000^IZi0000000:0=Nd]P030000003Va[H0i/Jf00D0i/Jf00<000000>gF^`3]e[/00P3]
e[/200000080hl:f00<000000=k6`@0000000P0000080=k6`@8000002@2gX<400`000000YhZf0:N:
]P070:N:]P030000002MO[40WGja00H0WGja00<0000009Ih[`2FN:l01@2FN:l3000000P0WGna00<0
00000:>8^02SR;P02@2SR;P010000000[Io90:fOb@0000090<jb_P030000003R`kT0h/>i00<0h/>i
00<000000>;7_@0000002@3N_kX010000000d;S30=2h``0000090:b>]P030000002<MK<0S7Fc00H0
S7Fc00<0000006QU^`1XIK/01P1XIK/00`0000006UgD00000002000f^@<000001`24P<H00`000000
V8Bm09R4_@0709R4_@030000002SRKT0XhVi00@0XhVi0P0000030;RmgP030000003>a=40c/CA00H0
c/CA00<000000:62/P2QP[801P2QP[800`000000V7^a09Qk/@0609Qk/@030000002>Mk@0SWNd00L0
SWNd00<00000081c_020Lk`01P20Lk`00`000000IG?=06Ecc@060000008003Fi00<0000008>;dP23
Rm801`23Rm800`000000oooo0?ooo`080?ooo`@00000103Qg=0010000000d;K00=2f`00000050?oo
o`8000002`3oool000030?ooo`000000oooo00<0oooo00<000000?ooo`3oool00P3oool2000000@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0
oooo00<000000:N8/`2WR;<02@2WR;<2000000T0ekBf00<000000>K6]P3Va[H01P3Va[H00`000000
kMJk0>gF^`040>gF^`@000002P3Na/4010000000cl[E0<o:e@0000090;NP`@030000002WR[H0YhZf
00H0YhZf00<0000009en/@2MO[401P2MO[400`000000UWR_09Ih[`0309Ih[`80000000<0VWb`0000
002MOk40202MOk400`000000XhRh0:>8^0090:>8^0040000002]WlT0[Io9000000P0c[:n00<00000
0>;3^@3R`kT01@3R`kT00`000000g[nj0=jo^P070=jo^P050000003@^<<0d;S30=2h``0000002P2/
S[H00`000000S7Fc08ae/`0608ae/`030000001XIK/0J6Fk00D0J6Fk00@0000001YMe00JGM@00000
0`00=[T2000000H0Q83600<0000009R4_@2HQ;d01`2HQ;d00`000000XhVi0:>9^@020:>9^@800000
1P2h_Mh00`000000c/CA0<k4d@030<k4d@8000002@2QP[800`000000V7^a09Qk/@0709Qk/@030000
002>Mk@0SWNd00H0SWNd00<00000081c_020Lk`01P20Lk`00`000000IG?=06Ecc@0306Ecc@@00000
0P00=KT2000000L0Ph_B00<000000?ooo`3oool01P3oool5000000D0hMc@00@000000=2f`03@]/00
00000P3oool3000000030?ooo`000000oooo00X0oooo00000`3oool000000?ooo`030?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool2000000T0oooo00<000000:N8/`2WR;<0
2@2WR;<00`000000ekBf0=Nd]P070=Nd]P030000003Va[H0i/Jf00H0i/Jf00<000000>gF^`3]e[/0
0`3]e[/4000000/0g/K100D000000<o:e@3?b]D0cl[E000000090;NP`@030000002WR[H0YhZf00H0
YhZf00<0000009en/@2MO[401`2MO[400`000000UWR_00000002000000@0VWb`00<0000009eo/@2M
Ok401`2MOk400`000000XhRh0:>8^0090:>8^08000002@3>/[h00`000000h/>i0>;3^@040>;3^@03
0000003`f[/0000000L0g[nj00<000000=2h``3@^<<00`3@^<<00`000000[8jf0:b>]P070:b>]P03
0000002<MK<0S7Fc00H0S7Fc00<0000006QU^`1XIK/01P1XIK/00`0000006UgD01YMe00200000080
03Ji1000000308B0aP030000002HQ;d0V8Bm00P0V8Bm00@000000:>9^@0000000000202h_Mh00`00
0000c/CA0<k4d@020<k4d@040000002^SkH0[Xnf000000P0XH:b00<0000009Qk/@2HNk401`2HNk40
0`000000SWNd08ig]00608ig]00300000020Lk`0P7>l00H0P7>l00<0000006Ecc@1ULld0101ULld5
00000003000e^@0000000000008000001023Rm800`000000oooo0?ooo`040?ooo`H000001@3Qg=00
0`000000d;K00=2f`0020=2f`0800000103oool00`000000oooo0?ooo`090?ooo`0000<0oooo0000
003oool00`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0203oool00`000000YhRc0:N8/`080:N8/`0300000035Z[l0000000P0ekBf00<000000>K6
]P3Va[H01@3Va[H010000000kMJk0>gF^`3]e[/300000080kMJk00<000000>cYb@000000203Na/42
000000D0cl[E00<000000;NP`@2gX<401P2gX<400`000000YhZf0:N:]P060:N:]P030000002MO[40
WGja00H0WGja0`00000709Yl/0030000002MOk40WGna00L0WGna00<000000:>8^02SR;P02@2SR;P0
0`000000c[:n0<jb_P070<jb_P030000003R`kT0h/>i00D0h/>i00@000000?3J^`3`f[/000001@3N
_kX00`000000d;S30=2h``040=2h``030000002/S[H0[8jf00L0[8jf00<0000008ae/`2<MK<01P2<
MK<00`000000J6Fk06QU^`0606QU^`030000000JGM@06UgD00<0000000<003Ji00000015R>X00P15
R>X30000000308B0aP000000V8Bm00@0V8Bm1P00000;0;RmgP040000003>a=40c/CA000000<0[Xnf
00<000000:62/P2QP[801`2QP[800`000000V7^a09Qk/@0609Qk/@030000002>Mk@0SWNd00L0SWNd
00<00000081c_020Lk`01P20Lk`00`000000IG?=06Ecc@0406Ecc@030000001ULld0000000800000
00@003Fi0000000hR^d0>8[]100000000`23Rm8000000?ooo`020?ooo`P00000103Qg=000`000000
d;K00=2f`0030=2f`0030000003oool0oooo00<0oooo00<000000?ooo`3oool02@3oool000030?oo
o`000000oooo00<0oooo00<000000?ooo`3oool02@3oool4000000D0oooo00<000000?ooo`3oool0
203oool00`000000YhRc0:N8/`070:N8/`0400000035Z[l0aJZo000000L0ekBf00<000000>K6]P3V
a[H01P3Va[H4000000D0kMJk00@000000>cYb@3/jLT000001P3Na/400`000000cl[E0<o:e@050<o:
e@030000002gX<40]j3100L0]j3100<000000:N:]P2WR[H01P2WR[H00`000000WGja09en/@0209en
/@<0000000<0VGbb0000002JO;001`2JO;000`000000WGna09eo/@0709eo/@030000002SR;P0XhRh
00P0XhRh00<000000;jO^@0000001`3>/[h00`000000h/>i0>;3^@050>;3^@050000003`f[/0l=Zk
0?3J^`000000103N_kX00`000000d;S30=2h``050=2h``030000002/S[H0[8jf00P0[8jf00<00000
08ae/`2<MK<01@2<MK<00`000000J6Fk06QU^`0506QU^`@000000`2VZmX00`00000003Ji00000005
04F8jPL000001@2C[nX00`000000^;gN0;RmgP090;RmgP030000003>a=40000000@0[Xnf00<00000
0:62/P2QP[801`2QP[800`000000V7^a09Qk/@0709Qk/@030000002>Mk@0SWNd00H0SWNd00<00000
081c_020Lk`01P20Lk`00`000000IG?=06Ecc@0506Ecc@030000001ULld0000000<000001P0hR^d2
00000080oooo200000040>7Ld0030000003@]/00d;K000D0d;K000<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`080?ooo`0000<0oooo0000003oool00`3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool00`000000YhRc0:N8/`050:N8
/`0300000035Z[l0aJZo0080aJZo00<000000=Nd]P3G];H0103G];H00`000000i/Jf0>K6]P050>K6
]P8000001`3]e[/00`000000k>W90>cYb@020>cYb@8000000`3Na/400`000000cl[E0<o:e@070<o:
e@030000002gX<40]j3100H0]j3100<000000:N:]P2WR[H01P2WR[H00`000000WGja000000020000
00@0VGbb00<0000009Yl/02JO;001P2JO;000`000000WGna09eo/@0809eo/@030000002SR;P0XhRh
00H0XhRh00@000000;jO^@2nWkT000001`3>/[h00`000000h/>i0>;3^@050>;3^@030000003`f[/0
l=Zk0080l=Zk00D000000=jo^P3N_kX0g[nj000000080=2h``030000002/S[H0[8jf00L0[8jf00<0
000008ae/`2<MK<01P2<MK<00`000000J6Fk06QU^`04000000<0WXJi00<000000:J[fP2VZmX00P2V
ZmX00`00000003Ji0000000604F8jP030000002C[nX0TjoZ00L0TjoZ00<000000;RmgP2h_Mh02P2h
_Mh00`000000[Xnf0:j?]P030:j?]P030000002QP[80XH:b00L0XH:b00<0000009Qk/@2HNk401`2H
Nk400`000000SWNd08ig]00608ig]00300000020Lk`0P7>l00L0P7>l00<0000006Ecc@1ULld01@1U
Lld2000000808W_V0P00000703R:k@L0000000<0>@000000003Qg=000`3Qg=000`000000d;K00=2f
`0060=2f`0030000003oool0oooo00<0oooo00<000000?ooo`3oool0203oool000030?ooo`000000
oooo00<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`050?ooo`<000002P3oool0
0`000000YhRc0:N8/`040:N8/`0300000035Z[l0aJZo00@0aJZo00<000000=Nd]P3G];H00P3G];H0
0`000000i/Jf0>K6]P030>K6]P@000001`3]e[/00`000000k>W90>cYb@050>cYb@030000003Na/40
000000X0cl[E00<000000;NP`@2gX<401P2gX<400`000000YhZf0:N:]P050:N:]P<00000202IO;80
0`000000VWb`09Yl/00609Yl/0030000002MOk40WGna00L0WGna00<000000:>8^02SR;P01@2SR;P0
0`000000_Yni0;jO^@020;jO^@030000003>/[h0c[:n00<0c[:n00<000000>;3^@3R`kT01@3R`kT0
0`000000l=Zk0?3J^`040?3J^`030000003N_kX0000000T0d;S300<000000:b>]P2/S[H01`2/S[H0
0`000000S7Fc08ae/`0508ae/`@000001`2NQ[T00`000000YZ_J0:J[fP030:J[fP<000001@15R>X0
0`000000TjoZ09>_jP0809>_jP030000002h_Mh0^;gN00L0^;gN0P0000070:j?]P030000002QP[80
XH:b00H0XH:b00<0000009Qk/@2HNk401`2HNk400`000000SWNd08ig]00708ig]00300000020Lk`0
P7>l00H0P7>l00<0000006Ecc@1ULld01@1ULld00`000000IG?=00000003029kiP8000001P0hR^d0
0`000000>@0003T0000303T000030000003]c[@0000000<0hMc@00<000000=2f`03@]/001`3@]/00
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00020?ooo`@00000303oool50000
00<0oooo00<000000?ooo`3oool02P3oool00`000000YhRc0:N8/`020:N8/`8000002035Z[l01@00
0000ekBf0=Nd]P3G];H000000080i/Jf0`0000020>K6]P030000003]e[/0kMJk00H0kMJk00<00000
0>cYb@3/jLT01P3/jLT00`000000cl[E0<o:e@0:0<o:e@030000002gX<40]j3100H0]j3100<00000
0:N:]P2WR[H0100000000`2IP[X0000009Ul/P0809Ul/P030000002JO;00VWb`00H0VWb`00<00000
09eo/@2MOk401`2MOk400`000000XhRh0:>8^0040:>8^0030000002nWkT0_Yni00<0_Yni00<00000
0<jb_P3>/[h00`3>/[h00`000000h/>i0>;3^@050>;3^@030000003`f[/0l=Zk00D0l=Zk00<00000
0=2h``3@^<<0203@^<<00`000000[8jf0:b>]P070:b>]P030000002<MK<0S7Fc00<0S7Fc0P000000
0`2LO[80000009j6^@0909j6^@030000002VZmX0YZ_J00<0YZ_J0P00000604F8jP030000002C[nX0
TjoZ00P0TjoZ00<000000;RmgP2h_Mh0102h_Mh2000000T0[Xnf00<000000:62/P2QP[801`2QP[80
0`000000V7^a09Qk/@0709Qk/@030000002>Mk@0SWNd00H0SWNd00<00000081c_020Lk`01P20Lk`0
0`000000IG?=06Ecc@0606Ecc@X000000`0hR^d00`000000>@0003T0000303T000060000003]c[@0
kLjd0000003Qg=0000002P3@]/000`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo
000J0?ooo`030000003oool0oooo00X0oooo00D000000:N8/`2WR;<0YhRc0000000:0<FZ_`030000
003G];H0ekBf00@000001@3Va[H00`000000kMJk0>gF^`050>gF^`030000003/jLT0k>W900H0k>W9
00@000000<omh000000000002P3?b]D00`000000]j310;NP`@050;NP`@@000001P2IP[X00`000000
VGbb09Ul/P0609Ul/P030000002JO;00VWb`00H0VWb`00<0000009eo/@2MOk40202MOk400`000000
XhRh0:>8^0020:>8^0030000002nWkT0_Yni00D0_Yni00D000000<jb_P3>/[h0c[:n000000070>;3
^@030000003`f[/0l=Zk00D0l=Zk0P00000;0=2h``030000002/S[H0[8jf00L0[8jf00<0000008ae
/`0000000P00000409an/P030000002NQ[T0WXJi00P0WXJi00D000000:J[fP2VZmX0YZ_J00000002
0=S1``8000001@15R>X00`000000TjoZ09>_jP0809>_jP040000002h_Mh0^;gN0;RmgP8000000P34
Z;h00`000000[Xnf0:j?]P060:j?]P030000002QP[80XH:b00L0XH:b00<0000009Qk/@2HNk401`2H
Nk400`000000SWNd08ig]00608ig]00300000020Lk`0P7>l00L0P7>l00<0000006Ecc@1ULld01@00
0000102JTLT0000009ZAb@00000509Bnm0X00000103]c[@00`000000d;K00=2f`0080=2f`0800000
103oool00`000000oooo0?ooo`080?ooo`006P3oool00`000000oooo0?ooo`0;0?ooo`030000002W
R;<0000000`0aJZo0`0000070>K6]P030000003]e[/0kMJk00D0kMJk00<000000>cYb@3/jLT01@3/
jLT2000000@0cogP00<000000<o:e@3?b]D0203?b]D00`000000]j310;NP`@040000000309VCc000
0000VH:j00L0VH:j00<0000009Ul/P2IO;801P2IO;800`000000VWb`09Yl/00609Yl/0030000002M
Ok40WGna00P0WGna00D000000:>8^02SR;P0XhRh000000080;jO^@050000003>/[h0c[:n0<jb_P00
00001P3R`kT00`000000l=Zk0?3J^`050?3J^`040000003YnLT0jOW9000000X0d;S300<000000:b>
]P2/S[H01P2/S[H3000000L0W7jb00<0000009j6^@2NQ[T02@2NQ[T00`000000YZ_J000000050=S1
``<000000`15R>X00`000000TjoZ09>_jP0709>_jP030000002h_Mh00000008000000`34Z;h00`00
0000[Xnf0:j?]P060:j?]P030000002QP[80XH:b00L0XH:b00<0000009Qk/@2HNk401`2HNk400`00
0000SWNd08ig]00708ig]00300000020Lk`0P7>l0080P7>l1`00000609ZAb@030000002JTLT00000
00@0U;kd00<000000=3Bf`3@d]/00`3@d]/3000000030>KB`P000000kLjd00<0kLjd00<000000=2f
`03@]/001`3@]/0010000000_Ibg0;fL]`0000030?ooo`030000003oool0oooo00P0oooo000J0?oo
o`800000303oool2000000X0aJZo0`0000000`35Z[l000000>K6]P060>K6]P030000003]e[/0kMJk
00D0kMJk00<000000>cYb@3/jLT01@3/jLT00`000000cogP0<omh0050<omh08000001@3?b]D60000
00H0VI?<00<0000009V2^P2IP[X01@2IP[X00`000000VGbb09Ul/P0609Ul/P030000002JO;00VWb`
00L0VWb`00<0000009eo/@2MOk401`2MOk4010000000XhRh0:>8^000000:0;jO^@030000003>/[h0
000000L0h/>i00<000000?3J^`3`f[/01@3`f[/010000000jOW90>Wib@00000:0=2h``030000002/
S[H0[8jf00<0[8jf0`0000000`2NQ[T0000009an/P0709an/P030000002NQ[T0WXJi00T0WXJi00<0
00000:J[fP0000001P3H`L<00`000000ilVh00000003000000H0TjoZ1@0000000`3C];X000000<BX
_P030<BX_P030000002^SkH0[Xnf00L0[Xnf00<000000:62/P2QP[801`2QP[800`000000V7^a09Qk
/@0609Qk/@030000002>Mk@0SWNd00D0SWNd1`00000409Z2^0030000002JTLT0VY7900L0VY7900<0
000009ZAb@0000000P2D__@00`000000d=;K0=3Bf`030=3Bf`050000003Vd/80i];20>KB`P000000
103]c[@00`000000kL^`000000070=2f`0050000002mW;L0_Ibg0;fL]`0000000`3oool00`000000
oooo0?ooo`080?ooo`006@3oool00`000000oooo0?ooo`0<0?ooo`0300000035Z[l0aJZo00H0aJZo
0`0000030<FZ_`040000003Ndl`00000000000D0i/Jf00<000000>gF^`3]e[/01@3]e[/00`000000
k>W90>cYb@040>cYb@030000003?oN00cogP00L0cogP1P000003092omP030000002ITl`0VI?<00H0
VI?<00<0000009V2^P2IP[X01@2IP[X00`000000VGbb09Ul/P0709Ul/P030000002JO;00VWb`00H0
VWb`00<0000009eo/@2MOk40202MOk42000000/0_Yni00<000000<jb_P0000001P3R`kT00`000000
l=Zk0?3J^`050?3J^`030000003YnLT0jOW90080jOW900<000000=2h``3@^<<0203@^<<00`000000
[8jf00000002000000@0WXJi00<0000009an/P2LO[801`2LO[800`000000WXJi09j6^@0909j6^@03
0000003H`L<0f<7300@0f<7300<000000>O9^03WbKP00`3WbKP7000000D0dkBj00<000000<BX_P34
Z;h01034Z;h00`000000[Xnf0:j?]P060:j?]P030000002QP[80XH:b00L0XH:b00<0000009Qk/@2H
Nk401`2HNk400`000000SWNd08ig]00400000080VWfb00<0000009Z2^02JP[P01`2JP[P00`000000
VY7909ZAb@0709ZAb@80000000<0U;kd0000003@d]/0103@d]/00`000000i];20>KB`P020>KB`P03
0000003]c[@0kLjd0080kLjd00<000000>g;/00000001P3@]/000`000000_Ibg0;fL]`020;fL]`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01`3oool001T0oooo00<000000?ooo`3oool0
3@3oool00`000000aJZo0<FZ_`020<FZ_`<000001@35Z[l00`000000g]?<0=kCc0020=kCc0050000
003Va[H0i/Jf0>K6]P0000001`3]e[/00`000000k>W90>cYb@030>cYb@8000001P3?oN0400000080
8Zfe00<00000092omP2@_oH01@2@_oH00`000000VI?<09VCc00509VCc0030000002IP[X0VH:j00H0
VH:j00<0000009Ul/P2IO;801P2IO;800`000000VWb`09Yl/00609Yl/0030000002MOk40WGna00P0
WGna00<000000;jO^@2nWkT02`2nWkT00`000000h/>i0>;3^@050>;3^@030000003`f[/0l=Zk00@0
l=Zk00<000000>Wib@3YnLT00`3YnLT00`000000d;S30=2h``070=2h``<00000202NQ[T00`000000
W7jb09an/P0609an/P030000002NQ[T0WXJi00P0WXJi00<000000<JX^P0000001@3H`L<00`000000
ilVh0>O9^0040>O9^0030000003[d;X0jm2j0080jm2j00<000000=>d^P3C];X00P3C];X00`000000
a:Rn0<BX_P050<BX_P030000002^SkH0[Xnf00H0[Xnf00<000000:62/P2QP[801`2QP[800`000000
V7^a09Qk/@0609Qk/@@000001`2JOK800`000000VX:h09Z2^00609Z2^0030000002JTLT0VY7900P0
VY790P0000060=3Bf`050000003Vd/80i];20>KB`P000000103]c[@01@000000kL^`0>g;/03]bk00
000000D0d;K000<000000;fL]`2mW;L00`2mW;L01@000000oooo0?ooo`3oool0000000T0oooo000I
0?ooo`030000003oool0000000d0oooo00<000000<FZ_`0000000P0000070<FZ_`030000003Ndl`0
g]?<00@0g]?<0P0000000`3Va[H000000>gF^`050>gF^`030000003/jLT0k>W900<0k>W900<00000
0<omh03?oN001`0000030?ooo`80000000<08Zfe0000002@_oH01@2@_oH00`000000VI?<09VCc006
09VCc0030000002IP[X0VH:j00D0VH:j00<0000009Ul/P2IO;801P2IO;800`000000VWb`09Yl/006
09Yl/0030000002MOk40WGna00L0WGna0P00000<0;jO^@030000003L`[l0000000D0h/>i00<00000
0?3J^`3`f[/0103`f[/00`000000jOW90>Wib@050>Wib@030000003@^<<0d;S300<0d;S30`000000
0`2VZmX0000009j6^@0809j6^@030000002LO[80W7jb00H0W7jb00<0000009j6^@2NQ[T01`2NQ[T0
10000000aZRj0<JX^P0000040=S1``030000003WbKP0ilVh00D0ilVh00<000000>_@^P3[d;X00`3[
d;X010000000dkBj0=>d^P0000080<BX_P030000002^SkH0[Xnf00L0[Xnf00<000000:62/P2QP[80
1P2QP[800`000000V7^a09Qk/@0309Qk/@<0000000<0Vgb`0000002JOK80202JOK800`000000VX:h
09Z2^00709Z2^0030000002JTLT0VY7900L0VY7900<000000;fU`@000000103@d]/00`000000i];2
0>KB`P020>KB`P030000003]c[@0kLjd0080kLjd00D000000>g;/03]bk00kL^`000000040=2f`003
0000002mW;L0_Ibg00@0_Ibg00D000000?ooo`3oool0oooo000000090?ooo`006@3oool2000000d0
oooo0`0000090<FZ_`030000003Ndl`0g]?<00L0g]?<100000040>gF^`030000003/jLT0k>W900P0
00002P3oool3000000H0T;of00<0000009VCc02ITl`01@2ITl`00`000000VH:j09V2^P0509V2^P03
0000002IO;80VGbb00H0VGbb00<0000009Yl/02JO;001`2JO;000`000000WGna09eo/@0409eo/@80
00000P2_T[P00`000000_Yni0;jO^@090;jO^@040000003L`[l0g<:o000000@0h/>i00<000000?3J
^`3`f[/0103`f[/00`000000jOW90>Wib@050>Wib@030000003@^<<0d;S300<000001@2VZmX00`00
0000WXJi09j6^@0609j6^@030000002LO[80W7jb00L0W7jb00<0000009j6^@2NQ[T01@2NQ[T00`00
0000aZRj0<JX^P020<JX^P050000003H`L<0f<730=S1``0000001P3WbKP00`000000jm2j0>_@^P04
0>_@^P030000003C];X0000000X0a:Rn00<000000:j?]P2^SkH01P2^SkH00`000000XH:b0:62/P07
0:62/P030000002HNk400000008000001@2KO;000`000000VWfb09Ym/P0609Ym/P030000002JP[P0
VX:h00L0VX:h00<0000009ZAb@2JTLT01P2JTLT01@000000_JG10000002mYL4000000080d=;K00<0
00000>KB`P3Vd/800P3Vd/800`000000kLjd0>g>]0030>g>]0030000003]bk00kL^`0080kL^`00@0
00000=2f`03@]/0000001`2mW;L01@000000oooo0?ooo`3oool0000000T0oooo000I0?ooo`030000
003oool0oooo00X0oooo0P0000020?ooo`0300000035Z[l0aJZo00H0aJZo00<000000=kCc03Ndl`0
1`3Ndl`00`000000i?KD0>Cfe0020>Cfe0/000003`3oool3000000D0T;of00<0000009VCc02ITl`0
1@2ITl`00`000000VH:j09V2^P0509V2^P030000002IO;80VGbb00L0VGbb00<0000009Yl/02JO;00
1P2JO;000`000000WGna09eo/@0309eo/@030000002_T[P0[i:h0080[i:h00<000000;jO^@2nWkT0
202nWkT00`000000g<:o0=c2_`020=c2_`040000003R`kT0h/>i000000H0l=Zk00<000000>Wib@3Y
nLT01P3YnLT3000000P0YZ_J00<0000009j6^@2NQ[T01P2NQ[T00`000000W7jb09an/P0709an/P03
0000002NQ[T0WXJi00@0WXJi00<000000<JX^P36Z;X01036Z;X00`000000f<73000000070>O9^003
0000003[d;X0jm2j00D0jm2j00<000000<BX_P34Z;h02@34Z;h00`000000[Xnf0:j?]P060:j?]P03
0000002QP[80XH:b00H0XH:b0`00000809]l/0030000002JOK80VWfb00L0VWfb00<0000009Z2^02J
P[P01`2JP[P00`000000VY7909ZAb@0409ZAb@090000002mYL40_JG10;fU`@000000_JG10000003@
d]/0000000@0i];200<000000>g>]03]c[@00P3]c[@00`000000kL^`0>g;/0030>g;/0030000003@
]/00000000P0_Ibg00D000000?ooo`3oool0oooo000000090?ooo`006@3oool00`000000oooo0?oo
o`070?ooo`<000001@3oool00`000000aJZo0<FZ_`050<FZ_`030000003Ndl`0g]?<00H0g]?<00<0
00000>Cfe03Tm]@01@3Tm]@010000000__c80;klb02no<P2000001<0oooo00<0000006=_b@000000
1@2@_oH00`000000VI?<09VCc00509VCc0030000002IP[X0VH:j00D0VH:j00<0000009Ul/P2IO;80
1P2IO;800`000000VWb`09Yl/00609Yl/0030000002MOk40WGna0080WGna00<000000:nB^02_T[P0
102_T[P00`000000_Yni0;jO^@060;jO^@030000003L`[l0g<:o00@0g<:o00<000000>;3^@000000
1@3`f[/00`000000jOW90>Wib@030>Wib@@000000P13a;X00`000000YZ_J0:J[fP060:J[fP030000
002NQ[T0WXJi00L0WXJi00<0000009an/P2LO[801P2LO[800`000000WXJi09j6^@0309j6^@030000
0036Z;X0aZRj00D0aZRj00<000000=S1``0000001P3WbKP00`000000jm2j0>_@^P050>_@^P800000
2`34Z;h00`000000[Xnf0:j?]P060:j?]P030000002QP[80XH:b00<0XH:b0`0000000`2MOk400000
09]l/00809]l/0030000002JOK80VWfb00L0VWfb00<0000009Z2^02JP[P01`2JP[P00`000000VY79
09ZAb@0209ZAb@8000001@2mYL400`000000_JG1000000040>KB`P030000003]c[@0kLjd00<0kLjd
00<000000>g;/03]bk00103]bk000`000000_Ibg0;fL]`080;fL]`040000003oool0oooo000000T0
oooo000H0?ooo`040000003oool0oooo000000@0oooo0`0000090?ooo`0300000035Z[l0aJZo00<0
aJZo00<000000=kCc03Ndl`01P3Ndl`00`000000i?KD0>Cfe0050>Cfe0030000002no<P0__c80080
00005@3oool00`000000Hfo906=_b@02000000<0T;of00<0000009VCc02ITl`01@2ITl`00`000000
VH:j09V2^P0509V2^P030000002IO;80VGbb00H0VGbb00<0000009Yl/02JO;001P2JO;000`000000
WGna09eo/@02000000L0[i:h00<000000;jO^@2nWkT01P2nWkT00`000000g<:o0=c2_`050=c2_`80
0000103`f[/00`000000jOW90>Wib@04000000<0NW:o00@0000004?4^P13a;X000002@2VZmX00`00
0000WXJi09j6^@0609j6^@030000002LO[80W7jb00L0W7jb00<0000009j6^@2NQ[T00P2NQ[T00`00
0000aZRj0<JX^P060<JX^P030000003WbKP0ilVh00D0ilVh00<000000>_@^P3[d;X01@3[d;X00`00
0000hmW<0000000;0<BX_P030000002^SkH0[Xnf00H0[Xnf00<000000:62/P0000000P00000509eo
/@030000002KO;00Vgb`00H0Vgb`00<0000009Ym/P2JOK801`2JOK800`000000VX:h09Z2^00809Z2
^0040000002JTLT0VY79000000L0_JG10P0000000`3F]KP000000>KB`P020>KB`P030000003]c[@0
kLjd0080kLjd00<000000>g;/03]bk00103]bk02000000X0_Ibg00@000000?ooo`3oool000002@3o
ool001P0oooo0`0000020?ooo`<00000303oool00`000000aJZo0<FZ_`020<FZ_`030000003Ndl`0
g]?<00H0g]?<00<000000>Cfe03Tm]@01@3Tm]@010000000__c800000000000H0?ooo`040000001S
KlT0Hfo906=_b@8000000P2@_oH00`000000VI?<09VCc00409VCc0030000002IP[X0VH:j00D0VH:j
00<0000009Ul/P2IO;801P2IO;800`000000VWb`09Yl/00709Yl/08000002@2_T[P00`000000_Yni
0;jO^@050;jO^@030000003L`[l0g<:o00D0g<:o00<000000>kh_P3^n;h00P0000020?3J^`<00000
00<0Uh:k0000001jL[l01@1jL[l20000000304?4^P000000YZ_J00L0YZ_J00<0000009j6^@2NQ[T0
1P2NQ[T00`000000W7jb09an/P0709an/P050000002NQ[T0WXJi09j6^@0000002036Z;X00`000000
ilfm000000050>O9^0030000003[d;X0jm2j00D0jm2j00@000000>?Ic03SfL`000002`34Z;h00`00
0000[Xnf0:j?]P050:j?]P<00000202MOk400`000000Vgb`09]l/00709]l/0030000002JOK80VWfb
00H0VWfb00<0000009Z2^02JP[P0202JP[P00`000000VY79000000090;fU`@030000003F]KP00000
0080i];200<000000>g>]03]c[@00`3]c[@00`000000kL^`0>g;/0040>g;/0030000003WbKP00000
00T0_Ibg00D000000?ooo`3oool0oooo000000080?ooo`003P3oool5000000D0oooo00<000000?oo
o`0000000P00000@0?ooo`0400000035Z[l0aJZo000000P0g]?<00<000000>Cfe03Tm]@0103Tm]@2
000000030;klb0000000oooo01T0oooo00<0000006=_b@1SKlT00P1SKlT4000000L0VI?<00<00000
09V2^P2IP[X01@2IP[X00`000000VGbb09Ul/P0509Ul/P030000002JO;00VWb`00H0VWb`0P00000;
0:nB^0030000002nWkT0_Yni00<0_Yni00<000000=c2_`3L`[l01P3L`[l00`000000k_Rn0>kh_P02
0>kh_P<000000`2GP[/00`000000NW:o07Yb_`0407Yb_`050000000kDl40000004?4^P0000001`2V
ZmX00`000000WXJi09j6^@0609j6^@030000002LO[80W7jb00L0W7jb00@0000009j6^@2NQ[T00000
2@36Z;X010000000ilfm0>O=_@0000040>O9^0030000003[d;X0jm2j00@0jm2j00<000000>?Ic03S
fL`00P3SfL`00`000000a:Rn0<BX_P080<BX_P030000002^SkH0[Xnf00<0[Xnf0P0000000`2RQkL0
000009eo/@0809eo/@030000002KO;00Vgb`00L0Vgb`00<0000009Ym/P2JOK801`2JOK800`000000
VX:h09Z2^00809Z2^0030000002mYL40_JG100L0_JG100L000000=Je^0000000e[Fh0000003Vd/80
000000D0kLjd00<000000>g;/03]bk000`3]bk0010000000ilVh0>O9^000000:0;fL]`040000003o
ool0oooo000000P0oooo000@0?ooo`030000003oool0oooo00D0oooo0P00000C0?ooo`0300000035
Z[l0000000T0g]?<00<000000>Cfe03Tm]@00`3Tm]@010000000__c800000000000L0?ooo`030000
001SKlT0Hfo900<0Hfo91000000509VCc0030000002IP[X0VH:j00D0VH:j00<0000009Ul/P2IO;80
1P2IO;800`000000VWb`09Yl/00209Yl/0<0000000<0XXVi0000002_T[P02P2_T[P00`000000_Yni
0;jO^@020;jO^@030000003L`[l0g<:o00H0g<:o00<000000>kh_P3^n;h00`3^n;h00`000000Uh:k
09N2^`0309N2^`030000001jL[l0NW:o00D0NW:o00D0000003]C`@000000@lBj000000070:J[fP03
0000002NQ[T0WXJi00D0WXJi00<0000009an/P2LO[80202LO[82000000T0aZRj00<000000>O=_@3W
cKd00P3WcKd010000000ilVh0>O9^00000060>_@^P030000003SfL`0hmW<00<0hmW<00<000000<BX
_P34Z;h02@34Z;h00`000000[Xnf00000002000000@0XXNg00<0000009eo/@2MOk401P2MOk400`00
0000Vgb`09]l/00709]l/0030000002JOK80VWfb00L0VWfb00<0000009Z2^02JP[P01`2JP[P20000
00T0_JG100<000000=Je^03F]KP00`0000050>g>]0030000003]bk00kL^`00@0kL^`00@000000>O9
^03WbKP000002P2mW;L010000000oooo0?ooo`0000080?ooo`00403oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0180oooo0P0000080=kCc0030000003Tm]@0i?KD00<0i?KD0`00000N
0?ooo`030000001SKlT0Hfo900<0Hfo90P0000001000A;T0000000000000000309VCc0030000002I
P[X0VH:j00D0VH:j00<0000009Ul/P2IO;801P2IO;800`000000VWb`00000002000000D0XXVi00<0
00000:nB^02_T[P0202_T[P00`000000_Yni0;jO^@020;jO^@030000003L`[l0g<:o00D0g<:o00<0
00000>kh_P3^n;h00`3^n;h00`000000Uh:k09N2^`0509N2^`030000001jL[l0NW:o00@0NW:o00<0
000003]C`@0kDl400P0000070:J[fP030000002NQ[T0WXJi00H0WXJi00<0000009an/P2LO[801`2L
O[800`000000aZRj0<JX^P080<JX^P030000003WcKd0ilfm00<0ilfm00<000000>O9^00000001P3[
d;X00`000000hmW<0>?Ic0040>?Ic00300000034Z;h0a:Rn00L0a:Rn0`0000070::7]`030000002M
Ok40WGna00L0WGna00<0000009]l/02KO;001P2KO;000`000000VWfb09Ym/P0709Ym/P030000002J
P[P0VX:h00D0VX:h0P0000020:nA]`030000002mYL40_JG100D0_JG100L000000=Je^03F]KP0e[Fh
0000003F]KP0000000D0kLjd00<000000>g;/03]bk000`3]bk000`000000ilVh0>O9^0020>O9^003
0000002mW;L0_Ibg00L0_Ibg00@000000?ooo`3oool00000203oool00100oooo00<000000?ooo`3o
ool01`3oool2000001@0oooo0P0000050=kCc0030000003Tm]@0i?KD00<0i?KD0P00000Q0?ooo`03
0000001SKlT0Hfo900<0Hfo90`00000205=hf@<0000000<0VI?<0000002IP[X01@2IP[X00`000000
VGbb09Ul/P0509Ul/P<00000202RRKT00`000000[i:h0:nB^0090:nB^0040000002nWkT0_Yni0000
00P0g<:o00<000000>kh_P3^n;h00P3^n;h2000000L0Uh:k00<0000007Yb_`1jL[l01@1jL[l01@00
0000>e?103]C`@0kDl40000000H0YZ_J00<0000009j6^@2NQ[T01P2NQ[T00`000000W7jb09an/P05
09an/P<000002@36Z;X00`000000ilfm0>O=_@050>O=_@030000003[d;X0jm2j00@0jm2j00<00000
0>?Ic03SfL`01@3SfL`00`000000a:Rn0<BX_P050<BX_P80000000<0Zic70000002RQkL01`2RQkL0
0`000000WGna09eo/@0709eo/@030000002KO;00Vgb`00L0Vgb`00<0000009Ym/P2JOK801`2JOK80
0`000000VX:h09Z2^00309Z2^0030000002_TKL0[i6g0080[i6g00<000000;fU`@2mYL40102mYL40
0`000000e[Fh0=Je^0030=Je^0<00000103]c[@00`000000kL^`0>g;/0030>g;/0030000003WbKP0
ilVh0080ilVh00<000000;fL]`2mW;L0202mW;L00`000000oooo000000080?ooo`00403oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo01<0oooo0P0000020=kCc0030000003Tm]@0i?KD
00@000008`3oool00`000000Hfo906=_b@0306=_b@80000000<004Bi0000001CN=T00`1CN=T50000
00@0VH:j00<0000009Ul/P2IO;80100000000`2FQ;d000000::9^@080::9^@030000002_T[P0[i:h
00T0[i:h00<000000;jO^@000000203L`[l00`000000k_Rn0>kh_P020>kh_P030000002YSkX00000
00P0Uh:k00<0000007Yb_`1jL[l0101jL[l00`000000>e?103]C`@0203]C`@8000001@2VZmX00`00
0000WXJi09j6^@0509j6^@030000002LO[80W7jb00@0W7jb00D000000;6H_P2aV;h0/IRn00000008
0<JX^P030000003WcKd0ilfm00@0ilfm00<000000??`_@000000103[d;X00`000000hmW<0>?Ic007
0>?Ic00300000034Z;h0a:Rn0080a:Rn0P0000040:^La`030000002RQkL0XXNg00D0XXNg00<00000
09eo/@2MOk401`2MOk400`000000Vgb`09]l/00709]l/0030000002JOK80VWfb00L0VWfb00<00000
09Z2^02JP[P00P2JP[P00`000000[i6g0:nA]`040:nA]`030000002mYL40_JG100<0_JG100<00000
0=Je^03F]KP00`3F]KP2000000050>W5/P000000kLjd0>g>]00000001@3]bk000`000000ilVh0>O9
^0030>O9^0030000002mW;L0_Ibg00P0_Ibg00<000000?ooo`000000203oool00100oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0D0?ooo`D00000:03oool00`000000Hfo906=_b@03
06=_b@<000001@1CN=T010000000Ph3708>0a`23P<L7000000H0UXBm00<000000::9^@2RRKT01`2R
RKT00`000000[i:h0:nB^0090:nB^08000001`3L`[l00`000000k_Rn0>kh_P020>kh_P040000002Y
SkX0ZHnj000000P0Uh:k00<0000007Yb_`1jL[l01@1jL[l00`000000>e?103]C`@0203]C`@<00000
0`2VZmX00`000000WXJi09j6^@0509j6^@030000002LO[80W7jb0080W7jb0P0000040;6H_P030000
0036Z;X0aZRj00D0aZRj00<000000>O=_@3WcKd01@3WcKd010000000lo2m0??`_@0000020>_@^P03
0000003SfL`0hmW<00P0hmW<00<000000<BX_P34Z;h00P0000060:^La`030000002RQkL0XXNg00H0
XXNg00<0000009eo/@2MOk401P2MOk400`000000Vgb`09]l/00709]l/0030000002JOK80VWfb00L0
VWfb00<0000009Z2^02JP[P00P0000070:nA]`030000002mYL40_JG10080_JG100<000000=Je^03F
]KP0103F]KP2000000050>W5/P000000kLjd0>g>]00000001@3]bk000`000000ilVh0>O9^0040>O9
^0030000002mW;L0_Ibg00D0_Ibg0`0000020?ooo`030000003oool0oooo00D0oooo000>0?ooo`<0
00003@3oool00`000000oooo0?ooo`100?ooo`@000000P1SKlT01000000001:R00000000000505=h
f@0300000023P<L0Ph3700@0Ph3700<0000009J4_@2FQ;d01P2FQ;d00`000000XXVi0::9^@070::9
^@030000002_T[P0[i:h00T0[i:h00<000000=c2_`3L`[l01P3L`[l01@000000k_Rn0>kh_P3^n;h0
000000@0ZHnj00<0000009N2^`2GP[/01@2GP[/00`000000NW:o07Yb_`0507Yb_`030000000kDl40
>e?10080>e?100<00000011Sf@0@HmT00P0000000`2VZmX0000009j6^@0709j6^@040000002LO[80
W7jb000000L0/IRn00<000000<JX^P36Z;X01036Z;X00`000000ilfm0>O=_@040>O=_@030000003c
l;d0lo2m0080lo2m00<000000>_@^P0000002P3SfL`3000000P0Zic700<000000::7]`2RQkL01P2R
QkL00`000000WGna09eo/@0709eo/@030000002KO;00Vgb`00H0Vgb`00<0000009Ym/P2JOK80202J
OK82000000T0[i6g00D000000;fU`@2mYL40_JG1000000060=Je^0050000003YaK80jLFb0000003Y
aK800P0000050>g;/0030000003WbKP0ilVh00D0ilVh00<000000;fL]`2mW;L00`2mW;L2000000<0
Zhff00<000000?ooo`0000001`3oool00100oooo00<000000?ooo`3oool0303oool200000400oooo
00@0000008Eb]P25L[H0QG:f100000000`004Z80000005=hf@0405=hf@0300000023P<L0Ph3700D0
Ph3700<0000009J4_@2FQ;d01@2FQ;d00`000000XXVi0::9^@070::9^@030000002_T[P0[i:h00P0
[i:h00<000000<k0c@0000001P3L`[l01@000000k_Rn0>kh_P3^n;h0000000D0ZHnj00<0000009N2
^`2GP[/01P2GP[/00`000000NW:o07Yb_`0507Yb_`030000000kDl40>e?10080>e?100@00000011S
f@0@HmT046?I0`00000709j6^@<00000202aV;h00`000000aZRj0<JX^P030<JX^P030000003WcKd0
ilfm00@0ilfm00<000000??`_@3cl;d0103cl;d00`000000hmW<0>?Ic0070>?Ic080000000<0^=_a
0000002[W<L0202[W<L00`000000XXNg0::7]`060::7]`030000002MOk40WGna00L0WGna00<00000
09]l/02KO;001`2KO;000`000000VWfb09Ym/P0709Ym/P030000002_TKL0[i6g00T0[i6g00@00000
0;fU`@2mYL4000001P3F]KP01`000000jLFb0>W5/P3YaK8000000>W5/P0000001@3]bk000`000000
ilVh0>O9^0050>O9^0040000002mW;L0_Ibg0;fL]`8000001@2[SKH00`000000oooo000000070?oo
o`008@3oool00`000000oooo0?ooo`0m0?ooo`0300000025L[H0QG:f00@0QG:f1000000505=hf@03
00000023P<L0Ph3700@0Ph3700<0000009J4_@2FQ;d01P2FQ;d00`000000XXVi0::9^@070::9^@03
0000002_T[P0[i:h00H0[i:h00D000000<k0c@3>`<d0c/3=000000050=c2_`040000003^n;h0k_Rn
000000L0ZHnj00<0000009N2^`2GP[/00P2GP[/<000000@0>e?10P000004011Sf@T000002`2aV;h0
0`000000aZRj0<JX^P020<JX^P030000003WcKd0ilfm00@0ilfm00<000000??`_@3cl;d00`3cl;d0
0`000000a?R`000000060>?Ic0800000102hfo400`000000Zic70:^La`070:^La`030000002RQkL0
XXNg00D0XXNg00<0000009eo/@2MOk401`2MOk400`000000Vgb`09]l/00709]l/0030000002JOK80
VWfb00D0VWfb0`00000;0:nA]`030000002mYL40000000L0e[Fh00<000000>W5/P3YaK800P3YaK83
000000<0kL^`00<000000>O9^03WbKP01`3WbKP3000000L0Zhff00<000000?ooo`0000001`3oool0
0280oooo00<000000?ooo`3oool0?@3oool00`000000QG:f08Eb]P0408Eb]P030000001GHL400000
00D0DgSI00<0000008>0a`23P<L01023P<L00`000000UXBm09J4_@0609J4_@030000002RRKT0XXVi
00L0XXVi00<000000:nB^02_T[P01@2_T[P00`000000c/3=0<k0c@020<k0c@030000003L`[l0g<:o
0080g<:o00@000000>kh_P3^n;h00000202YSkX5000000<0V7^a00<0000008ad]02<M;@01@2<M;@3
000000<0>e?10P000003011Sf@0300000028RLh0R8W>00D0R8W>00<000000;6H_P2aV;h02@2aV;h0
1@000000aZRj0<JX^P36Z;X0000000H0ilfm00<000000??`_@3cl;d00`3cl;d010000000a?R`0<Ch
/034n;0200000080hmW<0P0000060;SKl@030000002[W<L0Zic700L0Zic700<000000::7]`2RQkL0
1P2RQkL00`000000WGna09eo/@0609eo/@030000002KO;00Vgb`00L0Vgb`00<0000009Ym/P2JOK80
0`2JOK82000000<0YXJb00<000000:nA]`2_TKL02@2_TKL2000000H0e[Fh00<000000>W5/P3YaK80
0`3YaK800`000000nMf[000000030>g;/0030000003WbKP0ilVh00L0ilVh00<000000:^=]P2[SKH0
1`2[SKH00`000000oooo000000070?ooo`008`3oool00`000000oooo0?ooo`0l0?ooo`0300000025
L[H0QG:f00@0QG:f00@0000005MQ`@1GHL400000101CN=T00`000000Ph3708>0a`0508>0a`030000
002FQ;d0UXBm00D0UXBm00<000000::9^@2RRKT0202RRKT00`000000[i:h0:nB^0020:nB^0800000
1P3>`<d01@000000g<:o0=c2_`000000k_Rn00<000001P2YSkX3000000L0V7^a00<0000008ad]02<
M;@01P2<M;@010000000MVfk00000000000203]C`@8000000`0@HmT00`000000R8W>08R9cP0508R9
cP030000002aV;h0/IRn00T0/IRn00@000000<JX^P36Z;X000001@3WcKd00`000000lo2m0??`_@04
0??`_@0300000034n;00a?R`00<0a?R`0P0000090;SKl@030000002[W<L0Zic700H0Zic700<00000
0::7]`2RQkL01P2RQkL00`000000WGna09eo/@0709eo/@030000002KO;00Vgb`00H0Vgb`00@00000
09Ym/P2JOK80VWfb0P0000050:J6/P030000002_TKL0[i6g00T0[i6g00<000000=Je^03F]KP01@3F
]KP00`000000jLFb0>W5/P030>W5/P80000000@0nMf[0000003]bk0000002@3WbKP2000000X0Zhff
0P0000070?ooo`00903oool00`000000oooo0?ooo`0k0?ooo`0300000025L[H0QG:f00D0QG:f00@0
000005MQ`@1GHL400000101CN=T00`000000Ph3708>0a`0408>0a`030000002FQ;d0UXBm00H0UXBm
00<000000::9^@2RRKT01`2RRKT01@000000[i:h0:nB^02_T[P0000000T0c/3=00<000000=c2_`00
00000P0000000`2jW;X000000:V?^P030:V?^P8000000P2RPk800`000000V7^a09Qk/@0609Qk/@03
0000002<M;@0S7Bd00D0S7Bd00@0000007I]^`1fKK/0MVfk0`0000001@005:<00000011Sf@0@HmT0
000000L0R8W>00<000000;6H_P2aV;h02@2aV;h00`000000aZRj000000060>O=_@030000003cl;d0
lo2m00<0lo2m00<000000<Ch/034n;000P34n;04000000T0^=_a00<000000:^La`2[W<L01P2[W<L0
0`000000XXNg0::7]`060::7]`030000002MOk40WGna00L0WGna00<0000009]l/02KO;001`2KO;03
000000L0YXJb00<000000:nA]`2_TKL0202_TKL2000000H0e[Fh00<000000>W5/P3YaK800`3YaK80
0`000000nMf[0?WMZ`02000000030>g;/0000000ilVh00L0ilVh00@000000<k4d03>a=0000002@2[
SKH2000000L0oooo000U0?ooo`800000>`3oool00`000000QG:f08Eb]P0508Eb]P040000001GHL40
Ef7105MQ`@8000000P1CN=T00`000000Ph3708>0a`0408>0a`030000002FQ;d0UXBm00H0UXBm00<0
00000::9^@2RRKT01`2RRKT010000000[i:h0:nB^000000;0<k0c@030000002KiYd0000000<0^Ybj
00@000000:V?^P00000000001@2RPk800`000000V7^a09Qk/@0509Qk/@030000002<M;@0S7Bd00D0
S7Bd00<0000007I]^`1fKK/00`1fKK/200000005000DX`00000046?I011Sf@0000001`28RLh00`00
0000/IRn0;6H_P090;6H_P8000001@3WcKd00`000000lo2m0??`_@030??`_@0400000034n;00a?R`
0<Ch/0P000001`2hfo400`000000Zic70:^La`070:^La`030000002RQkL0XXNg00H0XXNg00<00000
09eo/@2MOk401P2MOk400`000000Vgb`09]l/00609]l/08000002@2VQ[800`000000[i6g0:nA]`07
0:nA]`0400000034X[H0a::f000000D0e[Fh00<000000>W5/P3YaK800`3YaK8010000000nMf[0?WM
Z`3igJ/2000000P0ilVh00D000000<k4d03>a=00c/C@000000090:^=]P030000003oool0000000H0
oooo000W0?ooo`030000003oool0oooo03T0oooo00<0000008Eb]P25L[H01025L[H00`000000Ef71
05MQ`@0205MQ`@8000000P1CN=T00`000000Ph3708>0a`0408>0a`030000002FQ;d0UXBm00D0UXBm
00<000000::9^@2RRKT0202RRKT2000000/0c/3=0`0000040;ZL^P8000001`2RPk800`000000V7^a
09Qk/@0509Qk/@030000002<M;@0S7Bd00D0S7Bd00<0000007I]^`1fKK/0101fKK/400000003011S
f@000000R8W>00H0R8W>00<000000;6H_P2aV;h02@2aV;h00`000000ilfm0>O=_@040>O=_@030000
003cl;d0lo2m0080lo2m00<000000<Ch/034n;000P0000050<J]`@D000001P2hfo400`000000Zic7
0:^La`060:^La`030000002RQkL0XXNg00H0XXNg00<0000009eo/@2MOk401P2MOk400`000000Vgb`
09]l/00309]l/0<0000000<0X86b0000002VQ[802@2VQ[800`000000[i6g0:nA]`060:nA]`040000
0034X[H0a::f000000@0e[Fh00<000000>W5/P3YaK80103YaK8010000000nMf[0?WMZ`3igJ/30000
00H0ilVh00<000000<k4d03>a=000P3>a=000`000000Zhff0:^=]P070:^=]P030000003oool00000
00H0oooo000X0?ooo`030000003oool0oooo03P0oooo00<0000008Eb]P25L[H01@25L[H00`000000
Ef7105MQ`@0205MQ`@80000000<0DgSI00000023P<L01@23P<L00`000000UXBm09J4_@0609J4_@03
0000002RRKT0XXVi00H0XXVi0P00000;0<k0c@800000102jW;X3000000P0XX>b00<0000009Qk/@2H
Nk401@2HNk400`000000S7Bd08ad]00608ad]0030000001fKK/0MVfk00@0MVfk00D0000004=Tc@00
000046?I0000000708R9cP030000002aV;h0/IRn00P0/IRn00<000000=7BfP000000103WcKd00`00
0000lo2m0??`_@020??`_@0400000034n;000000000000P0aZg100<0000006]jd01[N]0010000003
0;SKl@030000002[W<L0Zic700H0Zic700<000000::7]`2RQkL01P2RQkL00`000000WGna09eo/@07
09eo/@030000002KO;000000008000001@2PPK800`000000YXJb0:J6/P070:J6/P030000002_TKL0
[i6g00D0[i6g00<000000<BR]P34X[H00P34X[H01@000000e[Fh0=Je^03F]KP0000000D0jLFb00<0
00000?WMZ`3igJ/00P3igJ/2000000030>O`U0000000ilVh00<0ilVh00<000000<k4d03>a=00103>
a=000`000000Zhff0:^=]P070:^=]P8000001P3oool002T0oooo00<000000?ooo`3oool0=`3oool0
0`000000QG:f08Eb]P0508Eb]P030000001GHL40Ef7100<0Ef711000000608>0a`030000002FQ;d0
UXBm00D0UXBm00<000000::9^@2RRKT0102RRKT200000080]K_N00<000000<k0c@3>`<d01`3>`<d2
000000@0^Ybj00@000000:j?]P2^SkH00000202RPk800`000000V7^a09Qk/@0609Qk/@030000002<
M;@0S7Bd00D0S7Bd00<0000007I]^`1fKK/0101fKK/01P000000@fC=04=Tc@00000046?I000000L0
R8W>00<000000;6H_P2aV;h01@2aV;h2000000<0dM;J00@000000>O=_@3WcKd000001@3cl;d30000
00T0aZg100@0000006]jd01[N]00Jg[@0P0000001P0ER>L00000000000000000^=_a000000L0Zic7
00<000000::7]`2RQkL01P2RQkL00`000000WGna09eo/@0509eo/@@00000202PPK800`000000YXJb
0:J6/P070:J6/P030000002_TKL0[i6g00@0[i6g00<000000<BR]P34X[H00`34X[H01@000000e[Fh
0=Je^03F]KP0000000D0jLFb00<000000?WMZ`3igJ/00P3igJ/010000000io2D0000000000030>O9
^0030000003>a=00c/C@00D0c/C@00<000000:^=]P2[SKH01`2[SKH2000000H0oooo000Z0?ooo`80
0000=`3oool00`000000QG:f08Eb]P0608Eb]P030000001GHL40Ef7100<0Ef7100@00000000NWP00
000000001@23P<L00`000000UXBm09J4_@0509J4_@030000002RRKT0XXVi0080XXVi0P0000050;Fk
gP030000003>`<d0c/3=00@0c/3=0`0000030;ZL^P800000102^SkH00`000000XX>b0::3/P060::3
/P030000002HNk40V7^a00D0V7^a00<0000008ad]02<M;@01@2<M;@00`000000MVfk07I]^`0507I]
^`0300000013I<d0@fC=008000001`28RLh00`000000/IRn0;6H_P040;6H_P030000003Ad]X0dM;J
00@0dM;J00<000000>O=_@000000103cl;d3000000/0aZg100<0000006]jd01[N]000P1[N]001000
00005HSW01F8i`0ER>L6000000@0Zic700<000000::7]`2RQkL01P2RQkL00`000000WGna09eo/@04
00000080Vgnd00<000000:21/P2PPK801`2PPK800`000000YXJb0:J6/P080:J6/P030000002_TKL0
[i6g0080[i6g00<000000<BR]P34X[H01@34X[H00`000000e[Fh000000050>W5/P030000003igJ/0
nMf[0080nMf[00@000000>O`U03Wl9@0io2D0P0000000`3WbKP000000<k4d0070<k4d0030000002[
SKH0Zhff00L0Zhff0P0000060?ooo`00;03oool00`000000oooo0?ooo`0e0?ooo`0300000025L[H0
QG:f00D0QG:f00<0000005MQ`@1GHL40101GHL400`00000001jN00000002000000<0Ph3700<00000
09J4_@2FQ;d01P2FQ;d010000000XXVi0000000000070;FkgP030000003>`<d0c/3=00<0c/3=0`00
0000103=[[/000000000000000060:j?]P030000002RPk80XX>b00H0XX>b00<0000009Qk/@2HNk40
1@2HNk400`000000S7Bd08ad]00508ad]0030000001fKK/0MVfk00D0MVfk00@0000004=Tc@13I<d0
@fC=0P00000708R9cP030000002aV;h0/IRn0080/IRn00<000000=7BfP3Ad]X01P3Ad]X600000080
ilNf00<000000<J]`@36[L402@36[L42000000@0Jg[@00<0000001F8i`0ER>L00P0ER>L010000000
OhSB07n8dP1oR=8@000000L0Vgnd00<000000:21/P2PPK801P2PPK800`000000YXJb0:J6/P080:J6
/P050000002_TKL0[i6g0:nA]`0000002034X[H00`000000e[Fh000000050>W5/P030000003igJ/0
nMf[0080nMf[00L000000>O`U03Wl9@0io2D0000003Wl9@0000000X0c/C@00<000000:^=]P2[SKH0
1P2[SKH2000000H0oooo000]0?ooo`030000003oool0oooo03@0oooo00<0000008Eb]P25L[H01P25
L[H00`000000Ef7105MQ`@0500000003000NWP000000<X;Y00<0000000<0Ph370000002FQ;d00`2F
Q;d5000000X0]K_N00@000000<k0c@3>`<d0c/3=0P0000030<f^^`030000002^SkH0[Xnf00H0[Xnf
00<000000::3/P2RPk801P2RPk800`000000V7^a09Qk/@0509Qk/@030000002<M;@0S7Bd00H0S7Bd
00<0000007I]^`1fKK/01@1fKK/010000000@fC=04=Tc@13I<d3000000D0R8W>00<000000;6H_P2a
V;h00P0000080=7BfP040000002Ul[/0YO:k0:Gb^`8000000P3WakH00`000000i<2b000000090<J]
`@80000000@0Qg>f00000000000000000P1[N]001@0000005HSW01F8i`0ER>L0000000L0OhSB00<0
000009>0_02CP;`01P2CP;`00`000000Vgnd09]o]00709]o]0030000002PPK80X86b00L0X86b00<0
00000:J6/P2VQ[801`2VQ[8010000000[i6g0:nA]`00000:0<BR]P030000003YaK80jLFb00@0jLFb
00D000000?WMZ`3igJ/0nMf[000000050>O`U08000002P3>a=000`000000Zhff0:^=]P070:^=]P03
0000003oool0oooo00@0oooo000^0?ooo`030000003oool0oooo03<0oooo00<0000008Eb]P25L[H0
1@25L[H4000000D0Whbo0P00000403:2j@H00000102;[Nd00`000000]K_N0;FkgP090;FkgP040000
003>`<d00000000000<0cJjk0P0000080:j?]P030000002RPk80XX>b00H0XX>b00<0000009Qk/@2H
Nk401P2HNk400`000000S7Bd08ad]00508ad]0030000001fKK/0MVfk00D0MVfk00<0000004=Tc@13
I<d00P13I<d00`000000=i?a0000000300000080R8W>0P0000090=7BfP030000002Ul[/0YO:k0080
0000103WakH00`000000i<2b000000080<J]`@040000002eU;D0]IBe000000<0Qg>f1000000301F8
i`030000001oR=80OhSB00D0OhSB00<0000009>0_02CP;`01P2CP;`00`000000Vgnd09]o]00609]o
]0030000002PPK80X86b00L0X86b00<000000:J6/P2VQ[801`2VQ[8010000000[i6g0:nA]`00000:
0<BR]P030000003YaK80jLFb00<0jLFb00<000000?WMZ`3igJ/00P3igJ/00`000000io2D0>O`U002
0>O`U0@000002@3>a=000`000000Zhff0:^=]P070:^=]P8000001@3oool002l0oooo0P00000c0?oo
o`0300000025L[H0QG:f00<0QG:f0P0000000`2LP;@0000009n<_`0809n<_`030000000bP^T0<X;Y
00<0<X;Y00<0000008^]k@2;[Nd01@2;[Nd00`000000]K_N0;FkgP0:0;FkgP030000003=[[/0cJjk
0080cJjk00@000000;nS_@2oXkd00000202^SkH00`000000XX>b0::3/P050::3/P030000002HNk40
V7^a00H0V7^a00<0000008ad]02<M;@01@2<M;@00`000000MVfk07I]^`0607I]^`0300000013I<d0
@fC=0080@fC=0P00000303NCl@<000002@3Ad]X00`000000YO:k00000002000000@0ilNf00D00000
0>C0/P3T`;80i<2b000000060<J]`@050000002eU;D0]IBe0;FD]@0000001P27LkH2000000805HSW
00<0000007n8dP1oR=801@1oR=800`000000Th2l09>0_00609>0_0030000002KOk@0Vgnd00H0Vgnd
00<000000:21/P2PPK801`2PPK800`000000YXJb0:J6/P080:J6/P8000002P34X[H00`000000gKji
000000040>W5/P050000003igJ/0nMf[0?WMZ`000000103Wl9@5000000X0c/C@00<000000:^=]P2[
SKH01P2[SKH2000000D0oooo000a0?ooo`030000003oool0oooo0340oooo00<0000008Eb]P000000
0P00000409b0]0030000002OS;l0Whbo00L0Whbo00<0000003:2j@0bP^T00`0bP^T00`000000Rjg]
08^]k@0508^]k@030000002e^mh0]K_N00L0]K_N0P0000040<f^^`050000002oXkd0_j>m0;nS_@00
0000202^SkH00`000000XX>b0::3/P060::3/P030000002HNk40V7^a00D0V7^a00<0000008ad]02<
M;@01@2<M;@00`000000MVfk07I]^`0507I]^`H000000P2HTl`00`000000=i?a03NCl@0303NCl@03
0000003Ad]X0dM;J00@0dM;J100000000`3Td<<000000>O7]P040>O7]P050000003T`;80i<2b0>C0
/P0000001036[L42000000@0]IBe00<0000008Mc]P27LkH01@27LkH30000000301F8i`000000OhSB
00D0OhSB00<0000009>0_02CP;`01P2CP;`00`000000Vgnd09]o]00709]o]0030000002PPK80X86b
00L0X86b00<000000:J6/P2VQ[801`2VQ[800`000000a::f0<BR]P090<BR]P030000003M_[T00000
00@0jLFb00D000000?WMZ`3igJ/0nMf[000000030>O`U0L000002@3>a=000`000000Zhff0:^=]P06
0:^=]P8000001@3oool00380oooo00<000000?ooo`3oool0<03oool2000000L0W82d00<0000009n<
_`2OS;l0202OS;l2000000<0<X;Y00<0000008^]k@2;[Nd01P2;[Nd00`000000]K_N0;FkgP040;Fk
gP8000001@3=[[/00`000000_j>m0;nS_@020;nS_@030000002^SkH0[Xnf00H0[Xnf00<000000::3
/P2RPk801P2RPk800`000000V7^a09Qk/@0509Qk/@030000002<M;@0S7Bd00H0S7Bd00<0000007I]
^`1fKK/0100000000`2IPKP0000009RCc00609RCc0<000000`0gTo42000000<0dM;J00<000000:Gb
^`0000000`3Td<<00`000000ilNf0>O7]P030>O7]P030000003T`;80i<2b0080i<2b00@000000<J]
`@36[L4000001`2eU;D00`000000Qg>f08Mc]P0508Mc]P@000001`1oR=800`000000Th2l09>0_005
09>0_0030000002KOk@0Vgnd00L0Vgnd00<000000:21/P2PPK801`2PPK800`000000YXJb0:J6/P06
0:J6/P8000002P34X[H01@000000gKji0=fn^@3M_[T000000080jLFb00D000000?WMZ`3igJ/0nMf[
000000030>O`U0030000003oool0000000D000002@3>a=000`000000Zhff0:^=]P070:^=]P030000
003oool0oooo00<0oooo000c0?ooo`030000003oool0oooo02l0oooo00<0000009b0]02LP;@01P2L
P;@00`000000Whbo09n<_`0809n<_`0400000037Z[d0000000000080<X;Y00<0000008^]k@2;[Nd0
1P2;[Nd010000000]K_N0;FkgP2e^mh2000000030=o4_@000000cJjk00<0cJjk00<000000;nS_@2o
Xkd00`2oXkd00`000000[Xnf0:j?]P060:j?]P030000002RPk80XX>b00H0XX>b00<0000009Qk/@2H
Nk401P2HNk400`000000S7Bd08ad]00208ad]0H000001P2IPKP00`000000V9?<09RCc00709RCc0@0
000000<0=i?a0000003Ad]X00`0000030>C@``030000003WakH0ilNf00<0ilNf00<000000>C0/P3T
`;800`3T`;800`000000aZg1000000080;FD]@0300000027LkH0Qg>f00D0Qg>f0P0000000`291000
00000000000607n8dP030000002CP;`0Th2l00H0Th2l00<0000009]o]02KOk@01P2KOk@00`000000
X86b0:21/P070:21/P030000002VQ[80YXJb00D0YXJb00@000000;BE]`2dUKL000002@34X[H00`00
0000gKji0=fn^@020=fn^@030000003YaK80000000<0nMf[00@000000>O`U03Wl9@000001P3oool7
000000D0c/C@00<000000:^=]P2[SKH00P2[SKH5000000D0oooo000d0?ooo`030000003oool0oooo
02h0oooo00<0000009b0]02LP;@01`2LP;@00`000000Whbo09n<_`0609n<_`0400000037Z[d0ajZm
0<NZ_@D000001`2;[Nd010000000]K_N0000000000040=o4_@040000003=[[/0cJjk000000L0_j>m
00<000000:j?]P2^SkH01P2^SkH00`000000XX>b0::3/P050::3/P030000002HNk40V7^a00D0V7^a
1P00000309Yl/@030000002IPKP0VH6h00H0VH6h00<0000009RCc02HTl`0202HTl`00`000000`:O1
00000004000000D0i=3300<000000>O7]P3WakH00`3WakH00`000000i<2b0>C0/P040>C0/P030000
002eU;D0]IBe00L0]IBe00<0000008Mc]P27LkH01@27LkH01@000000@Dfh000000291000000000H0
OhSB00<0000009>0_02CP;`01P2CP;`00`000000Vgnd09]o]00609]o]0030000002PPK80X86b00P0
X86b00<000000:J6/P2VQ[800`2VQ[801@000000]9Fg0;BE]`2dUKL0000000P0a::f00<000000=fn
^@3M_[T00`3M_[T2000000<0nMf[00@000000>O`U03Wl9@000002@3oool00`000000oooo0?ooo`02
0?ooo`X00000103oool00`000000oooo0?ooo`030?ooo`00=@3oool2000002l0oooo00<0000009b0
]02LP;@01P2LP;@00`000000Whbo09n<_`0509n<_`0300000037Z[d0ajZm00<0ajZm00<000000=G1
aP3E`LH02P0000060=o4_@030000003=[[/0000000P0_j>m00<000000:j?]P2^SkH01P2^SkH00`00
0000XX>b0::3/P060::3/P030000002HNk40V7^a0080V7^a0P0000000`2KO;00000009Yl/@0709Yl
/@030000002IPKP0VH6h00H0VH6h00<0000009RCc02HTl`01P2HTl`010000000`:O10<2W`@30Yl42
000000030=?Ig@000000i=3300<0i=3300<000000>O7]P3WakH00`3WakH00`000000i<2b0>C0/P05
0>C0/P030000002eU;D0]IBe00L0]IBe00<0000008Mc]P27LkH01P27LkH01@000000@Dfh00000029
1000000000H0OhSB00<0000009>0_02CP;`01@2CP;`00`000000Vgnd09]o]00709]o]0030000002P
PK80X86b00L0X86b00<000000:J6/P2VQ[800P2VQ[800`000000]9Fg0;BE]`030;BE]`0300000034
X[H0a::f00D0a::f00<000000=fn^@3M_[T0103M_[T01`000000nMf[0?WMZ`3igJ/000000>O`U000
00002`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00<0oooo000g0?ooo`030000
003oool0oooo02`0oooo00<0000009b0]02LP;@01P2LP;@00`000000Whbo09n<_`0409n<_`030000
0037Z[d0ajZm00D0ajZm00<000000=G1aP0000001P3O`[`00`000000glBm0=o4_@070=o4_@030000
002oXkd0_j>m00L0_j>m00<000000:j?]P2^SkH01P2^SkH00`000000XX>b0::3/P060::3/P030000
002HNk400000008000000`2KO;000`000000VWba09Yl/@0609Yl/@030000002IPKP0VH6h00H0VH6h
00<0000009RCc02HTl`01@2HTl`00`000000`:O10<2W`@040<2W`@030000003Td<<0i=3300<0i=33
00<000000>O7]P3WakH00`3WakH00`000000i<2b0>C0/P040>C0/P030000003K^KL0000000T0]IBe
00<0000008Mc]P27LkH01@27LkH00`000000@Dfh045=^004000000@0OhSB00<0000009>0_02CP;`0
1P2CP;`00`000000Vgnd09]o]00609]o]0030000002PPK80X86b00L0X86b00D000000:J6/P2VQ[80
YXJb000000060;BE]`0300000034X[H0a::f00@0a::f00<000000=fn^@3M_[T0103M_[T00`000000
mO:^00000004000000d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`00
>03oool00`000000oooo0?ooo`0[0?ooo`030000002LP;@0W82d00H0W82d00<0000009n<_`2OS;l0
0`2OS;l00`000000ajZm0<NZ_@070<NZ_@030000003O`[`0gl:l00D0gl:l00<000000=o4_@3Oa;d0
1P3Oa;d2000000X0_j>m00<000000:j?]P2^SkH01@2^SkH00`000000XX>b0::3/P050::3/P<00000
1`2KO;000`000000VWba09Yl/@0509Yl/@030000002IPKP0VH6h00L0VH6h00<0000009RCc02HTl`0
0`2HTl`00`000000`:O10<2W`@040<2W`@030000003F/kL0000000<0i=3300<000000>O7]P3WakH0
0`3WakH00`000000i<2b0>C0/P050>C0/P030000003K^KL0000000T0]IBe00<0000008Mc]P27LkH0
1@27LkH020000000@Dfh045=^0000000R@@00000000]G]000000101oR=800`000000Th2l09>0_005
09>0_0030000002KOk@0Vgnd00H0Vgnd00<000000:21/P2PPK801`2PPK8010000000YXJb0:J6/P00
00070;BE]`0300000034X[H0a::f00<0a::f00<000000=fn^@3M_[T01@3M_[T010000000mO:^0?Gb
[P3elZh2000000l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`00>@3o
ool00`000000oooo0?ooo`0Z0?ooo`030000002LP;@0W82d00L0W82d00<0000009n<_`2OS;l00P2O
S;l00`000000ajZm0<NZ_@060<NZ_@030000003PaKh0000000D0gl:l00<000000=o4_@3Oa;d01P3O
a;d010000000f<S;0=S8b`0000090;nS_@030000002^SkH0[Xnf00H0[Xnf00<000000::3/P2RPk80
100000000`2NOk40000009]l/00709]l/0030000002JO;40VWba00H0VWba00<0000009V1^02IPKP0
1P2IPKP00`000000V9?<09RCc00209RCc00300000030Yl40`:O100D0`:O100<000000=Jc]`3F/kL0
0P0000000`3Td<<000000>O7]P040>O7]P030000003T`;80i<2b00@0i<2b00D000000=^i]`3K^KL0
fkVg000000080;FD]@0300000027LkH0Qg>f00D0Qg>f00@00000045=^011CKP0@Dfh0P00000202eN
d08000000P1oR=800`000000Th2l09>0_00509>0_0030000002KOk@0Vgnd00L0Vgnd00<000000:21
/P2PPK801`2PPK82000000T0]9Fg00<000000<BR]P34X[H00P34X[H00`000000gKji0=fn^@040=fn
^@050000003elZh0mO:^0?Gb[P0000004@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo0080oooo000j0?ooo`800000:`3oool00`000000W82d09b0]00609b0]0050000002OS;l0Whbo
09n<_`0000002@37Z[d010000000h<Fn0>35_P0000040=o2_0030000003Oa;d0glBm00H0glBm00@0
00000=S8b`3Hb</000002@2oXkd00`000000[Xnf0:j?]P050:j?]P@000001@2NOk400`000000Vgb`
09]l/00609]l/0030000002JO;40VWba00H0VWba00<0000009V1^02IPKP01`2IPKP010000000V9?<
09RCc00000070<2W`@030000003F/kL0e[>g00<0e[>g00<000000>O7]P3WakH0103WakH00`000000
i<2b0>C0/P040>C0/P050000003K^KL0fkVg0=^i]`0000002@2eU;D00`000000Qg>f08Mc]P0508Mc
]P0400000011CKP0@Dfh045=^08000000`0]G]000`000000OhSB0000000809>0_0030000002KOk@0
Vgnd00H0Vgnd00<000000:21/P2PPK801P2PPK82000000X0]9Fg00D000000<BR]P34X[H0a::f0000
00070=fn^@050000003elZh0mO:^0?Gb[P0000004P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo0080oooo000l0?ooo`030000003oool0oooo02P0oooo00<0000009b0]02LP;@01P2L
P;@010000000Whbo09n<_`0000090<NZ_@030000003PaKh0h<Fn0080h<Fn00@000000=o2_03O`[`0
0000203Oa;d00`000000f<S;0=S8b`020=S8b`030000002oXkd0_j>m00H0_j>m00<000000:j?]P2^
SkH00`2^SkH2000000030::7]`000000WWna00L0WWna00<0000009]l/02KO;001@2KO;000`000000
VWba09Yl/@0609Yl/@030000002IPKP0VH6h00L0VH6h00<0000009RCc00000002030Yl400`000000
e[>g0=Jc]`030=Jc]`800000103WakH00`000000i<2b0>C0/P040>C0/P030000003K^KL0fkVg0080
fkVg00<000000;FD]@2eU;D01`2eU;D00`000000Qg>f08Mc]P0508Mc]P0300000011CKP0@Dfh0080
@Dfh00<0000002eNd00]G]000P0]G]03000000L0Th2l00<0000009]o]02KOk@01P2KOk@00`000000
X86b0:21/P040:21/P80000000<0Yhbh0000002dUKL02P2dUKL010000000a::f0<BR]P0000060=fn
^@050000003elZh0mO:^0?Gb[P000000503oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo0080oooo000m0?ooo`030000003oool0oooo02L0oooo00<0000009b0]02LP;@01`2LP;@20000
00T0ajZm00<000000>35_P3PaKh0103PaKh00`000000gl:l000000070=o4_@030000003Hb</0f<S;
00<0f<S;00<000000;nS_@2oXkd01`2oXkd00`000000[Xnf00000002000000<0XXNg00<0000009io
/@2NOk401P2NOk400`000000Vgb`09]l/00609]l/0030000002JO;40VWba00H0VWba00<0000009V1
^02IPKP01`2IPKP00`000000`:O10<2W`@060<2W`@030000003F/kL0e[>g00<0e[>g00<000000>Bn
/@3T_[400P0000020>O7]P030000003T`;80i<2b00@0i<2b00<000000=^i]`3K^KL00`3K^KL00`00
0000]IBe0;FD]@060;FD]@0300000027LkH0Qg>f00D0Qg>f00<00000045=^011CKP00P11CKP20000
00D0;Ek@0P00000609>0_0030000002KOk@0Vgnd00H0Vgnd00<000000:21/P2PPK800P2PPK820000
00@0Yhbh00<000000;BE]`2dUKL0202dUKL00`000000a::f000000070=fn^@050000003elZh0mO:^
0?Gb[P0000005@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo000n0?oo
o`030000003oool0oooo02H0oooo00<0000009b0]02LP;@01`2LP;@00`000000ajZm0<NZ_@080<NZ
_@030000003PaKh0h<Fn00D0h<Fn00<000000=o4_@3Oa;d01@3Oa;d00`000000f<S;0=S8b`040=S8
b`030000002oXkd0_j>m00L0_j>m0P0000070::7]`030000002NOk40WWna00D0WWna00<0000009]l
/02KO;001P2KO;000`000000VWba09Yl/@0609Yl/@030000002IPKP0VH6h00H0VH6h0P0000080<2W
`@030000003F/kL0e[>g00<0e[>g00<000000>Bn/@3T_[400P3T_[42000000H0i<2b00<000000=^i
]`3K^KL0103K^KL00`000000]IBe0;FD]@070;FD]@0300000027LkH0Qg>f00D0Qg>f00<00000045=
^011CKP00P11CKP00`000000;Ek@02eNd00302eNd0030000001mNlH00000008000000`2CP;`00`00
0000Vgnd09]o]00709]o]0040000002PPK800000000000H0Yhbh00<000000;BE]`2dUKL02@2dUKL2
000000H0gKji00D000000?Gb[P3elZh0mO:^0000000F0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00P3oool003l0oooo0P00000W0?ooo`030000002LP;@0W82d00D0W82d00<00000
0;JL_@0000002037Z[d00`000000h<Fn0>35_P050>35_P030000003]h<@0000000D0glBm00<00000
0=S8b`3Hb</01P3Hb</00`000000_j>m0;nS_@040;nS_@<00000202RQkL00`000000WWna09io/@05
09io/@030000002KO;00Vgb`00H0Vgb`00<0000009Yl/@2JO;401`2JO;400`000000VH6h09V1^003
09V1^08000000P2aT[H00`000000`:O10<2W`@040<2W`@030000003F/kL0e[>g00<0e[>g00<00000
0>Bn/@3T_[40103T_[400`000000i<2b0>C0/P040>C0/P030000003K^KL0fkVg00@0fkVg00<00000
0;FD]@2eU;D01`2eU;D:000000@0@Dfh00<0000002eNd00]G]000`0]G]0010000000OG_607ekaP1m
NlH30000000309>0_0000000Vgnd00<0Vgnd1P0000080:N<^0030000002dUKL0]9Fg00T0]9Fg00<0
00000=fn^@3M_[T01@3M_[T010000000mO:^0?Gb[P00000H0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool00@3oool00440oooo00<000000?ooo`3oool0903oool00`000000W82d09b0
]00309b0]08000000P2fW;d00`000000ajZm0<NZ_@050<NZ_@030000003PaKh0h<Fn00H0h<Fn00<0
00000>gPa03]h<@00P0000030=o4_@030000003Hb</0f<S;00H0f<S;00<000000;nS_@2oXkd00P2o
Xkd2000000<0ZYW500<000000::7]`2RQkL01@2RQkL00`000000WWna09io/@0609io/@030000002K
O;00Vgb`00D0Vgb`00<0000009Yl/@2JO;401`2JO;400`000000VH6h09V1^00209V1^0030000002a
T[H0/I:f0080/I:f00<000000<2W`@30Yl400`30Yl400`000000e[>g0=Jc]`040=Jc]`030000003T
_[40i;ja00@0i;ja0P0000040>C0/P030000003K^KL0fkVg00H0fkVg00<000000;FD]@2eU;D0102e
U;D3000000L0UGN^00@0000008Eb]P00000000000`11CKP00`000000;Ek@02eNd00202eNd0030000
001mNlH0OG_600@0OG_61P00000409R5_@030000002WS;P0Yhbh00P0Yhbh00<000000;BE]`2dUKL0
1`2dUKL00`000000cKO4000000050=fn^@050000003elZh0mO:^0?Gb[P0000006@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo0040oooo00120?ooo`030000003oool0oooo02<0oooo
00<0000009b0]02LP;@00P2LP;@00`000000]Ybm0;JL_@030;JL_@0300000037Z[d0ajZm00@0ajZm
00<000000>35_P3PaKh01@3PaKh00`000000kN340>gPa0030>gPa0030000003Oa;d0000000X0f<S;
00@000000;nS_@00000000001@2ZVLD00`000000XXNg0::7]`050::7]`030000002NOk40WWna00H0
WWna00<0000009]l/02KO;001@2KO;000`000000VWba09Yl/@0709Yl/@050000002IPKP0VH6h09V1
^00000001P2aT[H00`000000`:O10<2W`@020<2W`@030000003F/kL0e[>g00@0e[>g00<000000>Bn
/@3T_[400`3T_[400`000000lLn_000000040>C0/P030000003K^KL0fkVg00H0fkVg00<000000;FD
]@2eU;D00P2eU;D200000080YhNb00<0000009Eg[P2EMjh01@2EMjh010000000QG:f08Eb]P25L[H5
000000<0;Ek@00<0000007ekaP1mNlH01@1mNlH00`000000V8Fm09R5_@0709R5_@030000002WS;P0
Yhbh00L0Yhbh00<000000;BE]`2dUKL01P2dUKL010000000cKO40<fga00000050=fn^@040000003e
lZh0mO:^000001/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`010?ooo`00@`3o
ool00`000000oooo0?ooo`0R0?ooo`050000002LP;@0W82d09b0]00000001P2fW;d00`000000ajZm
0<NZ_@030<NZ_@030000003PaKh0h<Fn00D0h<Fn00<000000>gPa03]h<@01@3]h<@00`000000f<S;
0=S8b`080=S8b`<000001`2ZVLD00`000000XXNg0::7]`060::7]`030000002NOk40WWna00D0WWna
00<0000009]l/02KO;001P2KO;000`000000VWba09Yl/@0709Yl/@<000001`2aT[H01@000000`:O1
0<2W`@30Yl40000000H0e[>g00<000000>Bn/@3T_[40103T_[4010000000lLn_0?7?[`0000020>C0
/P030000003K^KL0fkVg00P0fkVg00@000000;FD]@00000000001@2WQk800`000000UGN^09Eg[P05
09Eg[P0300000025L[H0QG:f00<0QG:f0`00000302eNd0030000001mNlH0OG_600D0OG_600<00000
09R5_@2HQKd01P2HQKd00`000000Yhbh0:N<^0070:N<^0030000002dUKL0]9Fg00D0]9Fg00<00000
0<fga03=]l@00P3=]l@01@000000gKji0=fn^@3M_[T000000080mO:^00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0040oooo00140?ooo`030000003oool0
oooo0280oooo0`0000080;JL_@0300000037Z[d0ajZm0080ajZm00<000000>35_P3PaKh01@3PaKh0
0`000000kN340>gPa0040>gPa0040000003Qnm<00000000000H0f<S;0P0000020;O9j0030000002Z
VLD0ZYW500H0ZYW500<000000::7]`2RQkL01@2RQkL00`000000WWna09io/@0509io/@030000002K
O;00Vgb`00H0Vgb`00<0000009Yl/@2JO;401`2JO;400`000000/I:f0;6B]P080;6B]P0400000030
Yl40`:O1000000H0e[>g00<000000>Bn/@3T_[400`3T_[400`000000lLn_0?7?[`020?7?[`030000
003T`;80000000X0fkVg0P0000070:N7/P030000002EMjh0UGN^00D0UGN^00<0000008Eb]P25L[H0
1@25L[H200000080;Ek@00<0000007ekaP1mNlH01@1mNlH00`000000V8Fm09R5_@0609R5_@030000
002WS;P0Yhbh00L0Yhbh00<000000;BE]`2dUKL0102dUKL00`000000cKO40<fga0030<fga0050000
003M_[T0gKji0=fn^@0000000P3elZh00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool00@3oool004D0oooo0P00000R0?ooo`030000002fW;d0]Ybm00P0]Ybm
00D000000<NZ_@37Z[d0ajZm000000070>35_P030000003]h<@0kN3400@0kN3400<000000>7kd`3Q
nm<00P3Qnm<200000080f<S;0P0000040;O9j0030000002ZVLD0ZYW500H0ZYW500<000000::7]`2R
QkL01@2RQkL00`000000WWna09io/@0509io/@030000002KO;00Vgb`00H0Vgb`00<0000009Yl/@2J
O;401@2JO;43000000X0/I:f00<000000<2W`@0000001P3F/kL00`000000i;ja0>Bn/@040>Bn/@03
0000003acjl0lLn_0080lLn_0P00000:0=^i]`800000202WQk800`000000UGN^09Eg[P0509Eg[P03
00000025L[H0QG:f00D0QG:f0P00000202eNd0030000001mNlH0OG_600D0OG_600<0000009R5_@2H
QKd01`2HQKd00`000000Yhbh0:N<^0070:N<^0030000002dUKL0]9Fg0080]9Fg00<000000<fga03=
]l@01@3=]l@00`000000gKji000000020?Gb[P030000003oool0oooo01d0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`010?ooo`00A`3oool00`000000oooo0?ooo`0O0?ooo`030000
002fW;d0]Ybm00T0]Ybm00<000000<NZ_@0000001`3PaKh00`000000kN340>gPa0040>gPa0030000
003Qnm<0hO_C00D0hO_C0P0000070;O9j0030000002ZVLD0ZYW500D0ZYW500<000000::7]`2RQkL0
1@2RQkL00`000000WWna09io/@0609io/@030000002KO;00Vgb`00D0Vgb`00<0000009Yl/@2JO;40
0`2JO;42000000<0YhNb00<000000;6B]P2aT[H0202aT[H2000000H0e[>g00<000000>Bn/@3T_[40
103T_[400`000000lLn_0?7?[`030?7?[`030000003K^KL0fkVg00L0fkVg00<000000<JaaP000000
202WQk800`000000UGN^09Eg[P0509Eg[P0300000025L[H0QG:f00H0QG:f0P00000202eNd0030000
001mNlH0OG_600@0OG_600<0000009R5_@2HQKd01`2HQKd00`000000Yhbh0:N<^0070:N<^0050000
002dUKL0]9Fg0;BE]`000000203=]l@00`000000gKji000000020?Gb[P030000003oool0oooo01d0
oooo00<000000?ooo`3oool0203oool100000040oooo0@3oool004P0oooo00<000000?ooo`3oool0
7`3oool00`000000]Ybm0;JL_@080;JL_@0300000037Z[d0000000H0h<Fn00<000000>gPa03]h<@0
103]h<@00`000000hO_C0>7kd`040>7kd`80000000<0HMBk0000002gbNP01P2gbNP00`000000ZYW5
0:ZIa@060:ZIa@030000002RQkL0XXNg00@0XXNg00<0000009io/@2NOk401P2NOk400`000000Vgb`
09]l/00609]l/0030000002JO;40VWba008000001@2WQk800`000000/I:f0;6B]P080;6B]P030000
003F/kL0e[>g00D0e[>g00<000000>Bn/@3T_[400`3T_[400`000000lLn_0?7?[`030?7?[`030000
003hjk00000000L0fkVg00D000000<JaaP36/LH0a[76000000070:N7/P030000002EMjh0UGN^00H0
UGN^00<0000008Eb]P25L[H01@25L[H30000000302eNd0000000OG_600H0OG_600<0000009R5_@2H
QKd01P2HQKd00`000000Yhbh0:N<^0070:N<^0040000002dUKL0]9Fg000000X0cKO41000000Q0?oo
o`030000003oool0oooo00L0oooo0@0000010?ooo`40oooo00190?ooo`030000003oool0oooo01h0
oooo00<000000;JL_@2fW;d02@2fW;d00`000000h<Fn0>35_P050>35_P030000003]h<@0kN3400@0
kN3400<000000>7kd`3Qnm<00P3Qnm<3000000<0HMBk00<000000;O9j02gbNP01@2gbNP00`000000
ZYW50:ZIa@050:ZIa@030000002RQkL0XXNg00D0XXNg00<0000009io/@2NOk401@2NOk400`000000
Vgb`09]l/00609]l/0<000001`2WQk800`000000/I:f0;6B]P070;6B]P0300000035X[D0000000D0
e[>g00<000000>Bn/@3T_[40103T_[400`000000lLn_0?7?[`030?7?[`030000003hjk00000000H0
fkVg00<000000<JaaP36/LH00P36/LH00`000000YhNb0:N7/P060:N7/P030000002EMjh0UGN^00D0
UGN^00<0000008Eb]P25L[H01P25L[H4000000L0OG_600<0000009R5_@2HQKd01`2HQKd00`000000
Yhbh0:N<^0070:N<^08000002P3=]l@010000000a?N/0<Cg[000000S0?ooo`030000003oool0oooo
00H0oooo0@0000010?ooo`40oooo001:0?ooo`8000007`3oool00`000000]Ybm0;JL_@070;JL_@03
0000003Dbm40000000D0h<Fn00<000000>gPa03]h<@0103]h<@010000000hO_C0>7kd`3Qnm<20000
00<0oooo1@0000060;O9j0030000002ZVLD0ZYW500D0ZYW500<000000::7]`2RQkL01@2RQkL00`00
0000WWna09io/@0509io/@030000002KO;00Vgb`00D0Vgb`0P0000090:N7/P030000002aT[H0/I:f
00L0/I:f00<000000<FR]@0000001@3F/kL00`000000i;ja0>Bn/@030>Bn/@030000003acjl0lLn_
00<0lLn_00D000000?S[/03hjk00n>^`000000040=^i]`0300000036/LH0a[7600<0a[7600<00000
0:N7/P2WQk801P2WQk800`000000UGN^09Eg[P0509Eg[P0300000025L[H0QG:f00H0QG:f0P000000
0`003YX000000000000607ekaP030000002HQKd0V8Fm00L0V8Fm00<000000:N<^02WS;P01`2WS;P0
0`000000cKO40<fga0080<fga00400000034mj`0a?N/000002D0oooo00<000000?ooo`3oool01@3o
ool100000040oooo0@3oool004`0oooo00<000000?ooo`3oool0703oool00`000000]Ybm0;JL_@06
0;JL_@040000003Dbm40e<_A0=C;d@8000000P3PaKh00`000000kN340>gPa0040>gPa0030000003Q
nm<00000008000002@3oool3000000D0]lWX00<000000:ZIa@2ZVLD01@2ZVLD00`000000XXNg0::7
]`040::7]`030000002NOk40WWna00H0WWna00<0000009]l/02KO;000P2KO;02000000030:21/P00
0000YhNb00T0YhNb00<000000;6B]P2aT[H01@2aT[H01@000000aJ:e0<FR]@35X[D0000000@0e[>g
00<000000>Bn/@3T_[400`3T_[400`000000lLn_0?7?[`030?7?[`030000003hjk00n>^`0080n>^`
00@000000=^i]`3K^KL000001P36/LH00`000000YhNb0:N7/P060:N7/P030000002EMjh0UGN^00D0
UGN^00<0000008Eb]P25L[H01`25L[H200000003000>VP000000OG_600H0OG_600<0000009R5_@2H
QKd01`2HQKd00`000000Yhbh0:N<^0040:N<^0<000002@3=]l@010000000a?N/0<Cg[000000V0?oo
o`030000003oool0oooo00D0oooo0@0000010?ooo`40oooo001=0?ooo`030000003oool0oooo01`0
oooo00<000000;JL_@2fW;d0102fW;d00`000000e<_A0=C;d@040=C;d@030000003PaKh0000000D0
kN340`00000>0?ooo`D0000000<0]lWX0000002ZVLD01P2ZVLD00`000000XXNg0::7]`040::7]`03
0000002NOk40WWna00H0WWna00<0000009]l/00000000P0000040:21/P030000002WQk80YhNb00L0
YhNb00<000000;6B]P2aT[H0102aT[H00`000000aJ:e0<FR]@030<FR]@040000003F/kL0e[>g0000
00H0i;ja00<000000?7?[`3acjl00P3acjl00`000000n>^`0?S[/0030?S[/0030000003K^KL00000
00P0a[7600<000000:N7/P2WQk801@2WQk800`000000UGN^09Eg[P0609Eg[P0300000025L[H0QG:f
00D0QG:f00D000000?ooo`3oool00000000>VP02000000D0OG_600<0000009R5_@2HQKd01`2HQKd0
0`000000Yhbh0:N<^0030:N<^0050000002g[Ll0]jg?0;N]c`0000001`3=]l@010000000a?N/0<Cg
[000000X0?ooo`030000003oool0oooo00@0oooo0@0000010?ooo`40oooo001>0?ooo`030000003o
ool0oooo01/0oooo00<000000;JL_@2fW;d00`2fW;d00`000000e<_A0=C;d@060=C;d@P000004@3o
ool2000000809hc]100000050:ZIa@030000002RQkL0XXNg00D0XXNg00<0000009io/@2NOk40102N
Ok43000000L0X86b00<000000:N7/P2WQk801`2WQk800`000000/I:f0;6B]P030;6B]P0300000035
X[D0aJ:e00D0aJ:e00<000000=Jc]`0000001@3T_[400`000000lLn_0?7?[`030?7?[`030000003h
jk00n>^`00@0n>^`00<000000<JaaP36/LH01`36/LH00`000000YhNb0:N7/P050:N7/P030000002E
Mjh0UGN^00H0UGN^00<0000008Eb]P25L[H00`25L[H2000000@0oooo0P0000000`0oM=d000000000
000307ekaP030000002HQKd0V8Fm00L0V8Fm00@000000:N<^02WS;P0Yhbh0P0000040;N]c`030000
003=]l@0cKO400@0cKO400@000000<Cg[034mj`00000:P3oool00`000000oooo0?ooo`030?ooo`40
00000@3oool10?ooo`00C`3oool2000001`0oooo00D000000;JL_@2fW;d0]Ybm000000080=C;d@03
0000003DomH0e?oF00<0e?oF00<000000?ooo`3oool04`3oool01P0000009hc]02N<k@0WS>d00000
0867d0@000000P2ZVLD00`000000XXNg0::7]`040::7]`030000002NOk40WWna00@0000000<0VWnd
0000002PPK801`2PPK800`000000YhNb0:N7/P080:N7/P030000002aT[H0/I:f0080/I:f00<00000
0<FR]@35X[D01@35X[D2000000H0i;ja00<000000?7?[`3acjl00P3acjl00`000000n>^`0?S[/004
0?S[/0030000002Ki9H0000000P0a[7600<000000:N7/P2WQk801P2WQk800`000000UGN^09Eg[P05
09Eg[P0300000025L[H0QG:f0080QG:f00<000000?ooo`3oool01@3oool200000080?gCM0P000000
0`1mNlH0000009R5_@0909R5_@<000001`2g[Ll00`000000cKO40<fga0030<fga00300000034mj`0
000002`0oooo00<000000?ooo`3oool00`3oool100000040oooo001A0?ooo`030000003oool0oooo
01T0oooo00@000000;JL_@2fW;d00000203Dbm400`000000e?oF0=CoeP020=CoeP8000005P3oool2
000000<09hc]00<000000867d021Qm000P21Qm0<000000H0VWnd00<000000:21/P2PPK801P2PPK80
0`000000YhNb0:N7/P070:N7/P050000002aT[H0/I:f0;6B]P0000002@35X[D00`000000i;ja0>Bn
/@030>Bn/@030000003acjl0lLn_00<0lLn_00<000000?S[/03hjk000`3hjk0010000000VnBF09_T
UP0000080<JaaP030000002WQk80YhNb00H0YhNb00<0000009Eg[P2EMjh01@2EMjh01@000000QG:f
08Eb]P25L[H0000000T0oooo00<0000003mdg@0oM=d00P0oM=d3000000D0V8Fm1@0000090;N]c`03
0000003=]l@0cKO40080cKO400<000000<Cg[0000000;@3oool00`000000oooo0?ooo`030?ooo`40
00000@3oool00580oooo00<000000?ooo`3oool06@3oool2000000P0e<_A00<000000=CoeP3DomH0
0P3DomH00`000000oooo0?ooo`0G0?ooo`8000000P0WS>d00`000000PHO@0867d0040867d0030000
002CP;`0Th2l00@0Th2l00<0000009Yo]02JOk@01P2JOk@00`000000X86b0:21/P060:21/P030000
002WQk80YhNb00L0YhNb00@000000;6B]P2aT[H000002@35X[D00`000000fkVg000000040>Bn/@03
0000003acjl0lLn_0080lLn_00<000000?S[/03hjk000`3hjk000`000000VnBF09_TUP0209_TUP03
00000036/LH0a[7600H0a[7600<000000:N7/P2WQk801@2WQk800`000000UGN^09Eg[P0609Eg[P<0
00002P3oool2000000D0?gCM1P00000409:Mf`030000002g[Ll0]jg?00P0]jg?00H000000<fga03=
]l@000000<Cg[000000_0?ooo`030000003oool0oooo0080oooo0@0000010?ooo`00D`3oool00`00
0000oooo0?ooo`0H0?ooo`030000003Dbm40e<_A00H0e<_A00<000000=CoeP3DomH00P3DomH00`00
0000oooo0?ooo`0H0?ooo`030000001iK;P0000000809hc]00<000000867d021Qm001021Qm000`00
0000Th2l09>0_00409>0_0030000002JOk@0VWnd00D0VWnd00<000000:21/P2PPK801P2PPK800`00
0000YhNb0:N7/P070:N7/P030000002aT[H0000000X0aJ:e00<000000=^i]`000000103T_[400`00
0000lLn_0?7?[`020?7?[`030000003hjk00n>^`0080n>^`00<0000009_TUP2Ki9H00`2Ki9H00`00
0000a[760<JaaP060<JaaP030000002WQk80YhNb00D0YhNb00<0000009Eg[P2EMjh01P2EMjh00`00
0000oooo0?ooo`0;0?ooo`030000000oM=d0?gCM00@0?gCM00<0000009:Mf`2BWM/01`2BWM/00`00
0000]jg?0;N]c`070;N]c`030000003=]l@0000000800000<@3oool01@000000oooo0?ooo`3oool0
00000040oooo001D0?ooo`030000003oool0oooo01P0oooo00<000000=C;d@3Dbm40103Dbm401000
0000e?oF0=CoeP3DomH2000001/0oooo00H0000007U/^01iK;P0000002N<k@0000060867d0030000
002CP;`0Th2l00@0Th2l00<0000009Yo]02JOk@01@2JOk@00`000000X86b0:21/P060:21/P030000
002WQk80YhNb00P0YhNb0P0000090<FR]@050000003K^KL0fkVg0=^i]`0000000P3T_[400`000000
lLn_0?7?[`020?7?[`030000003hjk00n>^`0080n>^`0`00000509_TUP0300000036/LH0a[7600D0
a[7600<000000:N7/P2WQk801@2WQk800`000000UGN^09Eg[P0409Eg[P8000003`3oool00`000000
?gCM03mdg@0303mdg@030000002BWM/0TYgK00L0TYgK00<000000;N]c`2g[Ll0202g[Ll2000003@0
oooo00@000000?ooo`3oool000000@3oool005D0oooo0P00000I0?ooo`8000000`3Dbm400`000000
e?oF0=CoeP02000001d0oooo00H0000007U/^01iK;P0000002N<k@0000060867d0030000002CP;`0
Th2l00@0Th2l00<0000009Yo]02JOk@01P2JOk@00`000000X86b0:21/P060:21/P030000002WQk80
YhNb00L0YhNb00<000000<FR]@35X[D02035X[D00`000000fkVg0=^i]`020=^i]`030000003T_[40
000000@0lLn_00@000000?S[/03hjk00n>^`0P0000020?ooo`@0000000<0VnBF00000036/LH01P36
/LH00`000000YhNb0:N7/P060:N7/P040000002EMjh0UGN^09Eg[P8000004P3oool2000000@0?gCM
00<0000009:Mf`2BWM/01`2BWM/00`000000]jg?0;N]c`050;N]c`800000=P3oool010000000oooo
0?ooo`0000010?ooo`00E`3oool00`000000oooo0?ooo`0H0?ooo`030000003Dbm40000000<00000
803oool01P000000NFbh07U/^00000009hc]000000H0PHO@00<0000009>0_02CP;`0102CP;`00`00
0000VWnd09Yo]00509Yo]0030000002PPK80X86b00H0X86b00<000000:N7/P2WQk801P2WQk820000
00T0aJ:e00<000000=^i]`3K^KL00`3K^KL2000000@0lLn_00@000000?S[/03hjk00n>^`0P000007
0?ooo`H000001036/LH00`000000YhNb0:N7/P050:N7/P040000002EMjh00000000001H0oooo0P00
000303mdg@030000002BWM/0TYgK00H0TYgK00<000000;N]c`2g[Ll0102g[Ll00`000000oooo0?oo
o`0g0?ooo`030000003oool000000040oooo001H0?ooo`030000003oool0oooo01P0oooo0P00000S
0?ooo`040000001iK;P0NFbh07U/^08000001P21Qm000`000000Th2l09>0_00409>0_0030000002J
Ok@0VWnd00D0VWnd00<000000:21/P2PPK801P2PPK800`000000YhNb0:N7/P050:N7/P040000002e
UKH0]IFf000000L0aJ:e00<000000=^i]`3K^KL01@3K^KL00`000000lLn_0?7?[`020?7?[`040000
003hjk00n>^`000000l0oooo3P00000J0?ooo`8000000P0oM=d00`000000TYgK09:Mf`0609:Mf`04
0000002g[Ll0]jg?0;N]c`800000>`3oool100000040oooo0@00000005T0oooo00<000000?ooo`3o
ool0?03oool00`000000NFbh07U/^00207U/^08000001@21Qm000`000000Th2l09>0_00409>0_003
0000002JOk@0VWnd00H0VWnd00<000000:21/P2PPK801P2PPK800`000000YhNb0:N7/P030:N7/P05
0000002eUKH0]IFf0;FE]P0000001`35X[D00`000000fkVg0=^i]`040=^i]`070000003fiKH00000
0000003acjl000000?S[/002000003X0oooo0`00000809:Mf`040000002g[Ll00000000003h0oooo
0P00000005X0oooo0P00000m0?ooo`030000001iK;P0NFbh0080NFbh00<000000867d021Qm000`21
Qm000`000000Th2l09>0_00409>0_0030000002JOk@0VWnd00H0VWnd00<000000:21/P2PPK801P2P
PK8010000000YhNb0:N7/P2WQk82000000@0]IFf00<000000<FR]@35X[D01035X[D00`000000fkVg
0=^i]`050=^i]`040000003fiKH0m^Ff0?KU]P@00000?@3oool;00000400oooo0P00000005`0oooo
00<000000?ooo`3oool0>P3oool00`000000NFbh07U/^00307U/^08000001021Qm000`000000Th2l
09>0_00409>0_0030000002JOk@0VWnd00D0VWnd00<000000:21/P2PPK801P2PPK8010000000YhNb
0:N7/P0000070;FE]P0300000035X[D0aJ:e00<0aJ:e00<000000=^i]`3K^KL0103K^KL00`000000
m^Ff0?KU]P020?KU]P<00000R@3oool200000000G@3oool00`000000oooo0?ooo`0i0?ooo`030000
001iK;P0NFbh00<0NFbh00<0000002EJc`0000000`21Qm000`000000Th2l09>0_00409>0_0030000
002JOk@0VWnd00H0VWnd00<000000:21/P2PPK801P2PPK82000000P0]IFf00<000000<FR]@35X[D0
0P35X[D00`000000fkVg0=^i]`050=^i]`030000003fiKH0m^Ff0080m^Ff0P0000260?ooo`@00000
0P3oool005h0oooo00<000000?ooo`3oool0>03oool00`000000NFbh07U/^00407U/^0060000000U
F/l0000000000021Qm0000001P2CP;`00`000000VWnd09Yo]00609Yo]0030000002PPK80X86b00H0
X86b00<000000;FE]P2eUKH0202eUKH010000000aJ:e0<FR]@0000070=^i]`030000003fiKH0m^Ff
0080m^Ff00<000000?ooo`3oool0PP3oool4000000H0oooo001O0?ooo`800000>@3oool00`000000
NFbh07U/^00407U/^0030000000UF/l09E[?00<000001P2CP;`00`000000VWnd09Yo]00509Yo]003
0000002PPK80X86b00@0X86b0`00000:0;FE]P0400000035X[D0aJ:e000000L0fkVg00<000000?KU
]P3fiKH00P3fiKH00`000000oooo0?ooo`1n0?ooo`@000002P3oool00640oooo00<000000?ooo`3o
ool0=P3oool4000000@0NFbh00@0000002EJc`0UF/l09E[?0P00000509>0_0030000002JOk@0VWnd
00D0VWnd00<000000:21/P2PPK800P2PPK82000000<0YX^i00<000000;FE]P2eUKH01`2eUKH00`00
0000aJ:e000000070=^i]`030000003fiKH0m^Ff0080m^Ff00<000000?ooo`3oool0N`3oool40000
00h0oooo001R0?ooo`030000003oool0oooo03D0oooo00@00000099f/02BM[00TWJ`1@00000302EJ
c`040000001jN/L00000000000<0Th2l00<0000009Yo]02JOk@01P2JOk@010000000X86b00000000
00050:J;^@030000002eUKH0]IFf00P0]IFf0P0000070=^i]`050000003fiKH0m^Ff0?KU]P000000
N`3oool300000180oooo001S0?ooo`030000003oool0oooo03@0oooo00<00000099f/02BM[001@2B
M[02000000<09E[?00<0000007Yja`1jN/L00`0000000`2CP;`0000009Yo]00309Yo]0D000001`2V
RkT00`000000]IFf0;FE]P080;FE]P030000003K^KL0fkVg00D0fkVg00<000000?KU]P3fiKH00P3f
iKH00`000000oooo0?ooo`1e0?ooo`@000005@3oool006@0oooo00<000000?ooo`3oool0=03oool0
0`000000TWJ`099f/005099f/08000000P0UF/l00`000000NW[707Yja`0307Yja`H000000`2FQ;d0
0`000000YX^i0:J;^@070:J;^@030000002eUKH0]IFf00H0]IFf00<000000<bc`P0000001P3K^KL0
1@000000m^Ff0?KU]P3fiKH0000007@0oooo1000000I0?ooo`00I@3oool2000003@0oooo00<00000
099f/02BM[001@2BM[030000000302EJc`000000NW[700D0NW[700<0000009J4_@2FQ;d01P2FQ;d0
0`000000YX^i0:J;^@060:J;^@030000002eUKH0]IFf00D0]IFf00@000000<bc`P3</l8000001@3K
^KL01@000000m^Ff0?KU]P3fiKH000000740oooo1000000M0?ooo`00I`3oool00`000000oooo0?oo
o`0a0?ooo`030000002BM[00TWJ`00D0TWJ`00<00000081c^`0000000P0UF/l00`000000NW[707Yj
a`0407Yja`030000002FQ;d0UXBm00D0UXBm00<000000:J;^@2VRkT01P2VRkT00`000000]IFf0;FE
]P040;FE]P030000003</l80c;?20080c;?200<000000=^i]`3K^KL00P3K^KL01@000000m^Ff0?KU
]P3fiKH0000006d0oooo1000000Q0?ooo`00J03oool00`000000oooo0?ooo`0`0?ooo`030000002B
M[00TWJ`00H0TWJ`00D00000081c^`0000009E[?0000000607Yja`030000002FQ;d0UXBm00D0UXBm
00<000000:J;^@2VRkT01P2VRkT00`000000]IFf0;FE]P030;FE]P030000003</l80c;?200@0c;?2
00@000000=^i]`3K^KL000000`3fiKH00`000000oooo0?ooo`1X0?ooo`@000009@3oool006T0oooo
00<000000?ooo`3oool0<03oool00`000000TWJ`099f/005099f/00600000020Lk/000000000000U
F/l000001@1jN/L00`000000UXBm09J4_@0509J4_@030000002VRkT0YX^i00L0YX^i00<000000;FE
]P2eUKH00P2eUKH00`000000c;?20<bc`P050<bc`P030000003K^KL0000000<0m^Ff00<000000?oo
o`3oool0I@3oool3000002T0oooo001Z0?ooo`800000<03oool00`000000TWJ`099f/005099f/003
00000020Lk/0P7>k00<000001P1jN/L00`000000UXBm09J4_@0509J4_@030000002VRkT0YX^i00H0
YX^i00D000000;FE]P2eUKH0]IFf000000080<bc`P8000000P3fiKH2000006@0oooo1000000/0?oo
o`00K03oool00`000000oooo0?ooo`0]0?ooo`030000002BM[00TWJ`00D0TWJ`00@00000081c^`20
Lk/0P7>k0P00000607Yja`030000002FQ;d0UXBm00D0UXBm00<000000:J;^@2VRkT01P2VRkT01000
0000]IFf0;FE]P00000:0<bc`P@00000H@3oool400000300oooo001]0?ooo`030000003oool0oooo
02`0oooo00<00000099f/02BM[001P2BM[0010000000P7>k081c^`20Lk/2000000D0NW[700<00000
09J4_@2FQ;d01@2FQ;d00`000000YX^i0:J;^@070:J;^@8000002P3</l8010000000gOk20=gn`P00
001N0?ooo`@00000=03oool006h0oooo00<000000?ooo`3oool0:`3oool00`000000TWJ`099f/006
099f/00400000020Lk/0P7>k081c^`8000001P1jN/L00`000000UXBm09J4_@0509J4_@030000002V
RkT0YX^i00H0YX^i00<000000<bc`P3</l80203</l8010000000gOk20=gn`P00001K0?ooo`@00000
>03oool006l0oooo0P00000/0?ooo`030000002BM[00TWJ`00D0TWJ`00@00000081c^`20Lk/00000
0P3oool2000000@0NW[700<0000009J4_@2FQ;d01@2FQ;d00`000000YX^i0:J;^@040:J;^@800000
00<0]:_@0000003</l801`3</l8010000000gOk20=gn`P00001I0?ooo`<00000?03oool00740oooo
00<000000?ooo`3oool0:@3oool00`000000TWJ`099f/006099f/08000000`3oool400000080NW[7
00<0000009J4_@2FQ;d01@2FQ;d00`000000YX^i0:J;^@030:J;^@050000002dZm00]:_@0;B[d000
00001`3</l8010000000gOk20=gn`P00001F0?ooo`@00000?`3oool00780oooo00<000000?ooo`3o
ool0:03oool00`000000TWJ`099f/006099f/0030000003oool0oooo00<0oooo00<0000002U/g00Y
K=`00P0000000`1jN/L0000009J4_@0509J4_@040000002VRkT0YX^i0:J;^@8000001@2dZm000`00
0000c;?20<bc`P040<bc`P030000003Mo/80000005<0oooo100000130?ooo`00L`3oool00`000000
oooo0?ooo`0W0?ooo`030000002BM[00TWJ`00@0TWJ`0P0000070?ooo`040000000YK=`0:FcL02U/
g0D00000102FQ;d3000000P0]:_@00<000000<bc`P3</l800P3</l800`000000gOk20000001@0?oo
o`@00000A`3oool007@0oooo00<000000?ooo`3oool09`3oool010000000TWJ`099f/02BM[020000
00X0oooo00<0000002U/g00YK=`00P0YK=`00`000000Ri_N08^KgP05000000/0]:_@00H000000<bc
`P3</l8000000=gn`P00001=0?ooo`@00000B`3oool007D0oooo0P00000W0?ooo`040000002BM[00
0000000000d0oooo00D0000002U/g00YK=`0:FcL0000000708^KgP030000002dZm00]:_@00P0]:_@
00<000000<bc`P0000000P00001;0?ooo`<00000C`3oool007L0oooo00<000000?ooo`3oool0903o
ool200000100oooo0P00000202U/g0030000002;Vmh0Ri_N00@0Ri_N00<000000;B[d02dZm002@2d
Zm02000004T0oooo1000001B0?ooo`00N03oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo0140oooo00@0000002U/g00YK=`000001P2;Vmh00`000000]:_@0;B[d0060;B[d0800000A`3o
ool4000005H0oooo001i0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool04P3oool2
0000000302U/g0000000Ri_N00D0Ri_N00<000000;B[d02dZm00102dZm000`000000oooo0?ooo`13
0?ooo`@00000FP3oool007X0oooo0P00000R0?ooo`030000003oool0oooo01@0oooo0P00000708^K
gP040000002dZm00]:_@0;B[d0800000@P3oool4000005h0oooo001l0?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool05P3oool4000000<0Ri_N00@000000;B[d00000000000@@3oool3
00000680oooo001m0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool06P3oool50000
03l0oooo1000001U0?ooo`00OP3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo05X0
oooo1000001Y0?ooo`00O`3oool2000001d0oooo00<000000?ooo`3oool0EP3oool4000006d0oooo
00210?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0DP3oool400000740oooo0022
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0CP3oool4000007D0oooo00230?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0B`3oool3000007T0oooo00240?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0A`3oool4000007`0oooo00250?ooo`800000
5`3oool00`000000oooo0?ooo`130?ooo`@00000P03oool008L0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0o0?ooo`@00000Q03oool008P0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0k0?ooo`@00000R03oool008T0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0h0?ooo`<00000S03oool008X0oooo0P00000B0?ooo`030000003oool0oooo03@0
oooo1000002?0?ooo`00S03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0300oooo
1000002C0?ooo`00S@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02`0oooo1000
002G0?ooo`00SP3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02P0oooo1000002K
0?ooo`00S`3oool2000000`0oooo00<000000?ooo`3oool09P3oool3000009l0oooo002A0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool08P3oool400000:80oooo002B0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool07P3oool400000:H0oooo002C0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool06P3oool400000:X0oooo002D0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool05P3oool400000:h0oooo002E0?ooo`8000001P3oool00`00
0000oooo0?ooo`0B0?ooo`@00000/P3oool009L0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0?0?ooo`<00000]P3oool009P0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0;0?ooo`@00000^@3oool009T0oooo00D000000?ooo`3oool0oooo000000090?ooo`@00000
_@3oool009X0oooo0P0000000`3oool000000?ooo`040?ooo`@00000`@3oool009`0oooo0P000000
0`3oool000000000000200000<D0oooo002M0?ooo`800000b@3oool00?l0ooooJ@3oool00?l0oooo
J@3oool00?l0ooooJ@3oool00?l0ooooJ@3oool00?l0ooooJ@3oool00?l0ooooJ@3oool00?l0oooo
J@3oool00?l0ooooJ@3oool00?l0ooooJ@3oool00001\
\>"],
  ImageRangeCache->{{{81, 368}, {353.938, 121.375}} -> {-0.359487, 0.46924, \
0.00356544, 0.00356544}},
  CellTags->"b:0.1"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["degree",
    FontSlant->"Italic"],
  " of a differential equation is the highest power of the highest-order \
derivative in the equation. "
}], "Text",
  CellTags->"b:0.1"],

Cell["This is a first-order ODE of degree 2.", "MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[{\(y'\)[x]^2 \[Equal] 1 - x^2, \ y[0] \[Equal] 2}, \ y, \ 
        x]\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"b:0.1"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            1\/2\ \((4 - x\ \@\(1 - x\^2\) - ArcSin[x])\)]}, {y \[Rule] 
          Function[{x}, 
            1\/2\ \((4 + x\ \@\(1 - x\^2\) + ArcSin[x])\)]}}\)], "Output",
  CellLabel->"Out[32]=",
  CellTags->"b:0.1"]
}, Open  ]],

Cell["The higher degree leads to non-uniqueness of the solution.", \
"MathCaption",
  CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{y[x] /. sol[\([\)\(1\)\(]\)], 
        y[x] /. sol[\([\)\(2\)\(]\)]}, \ {x, 0, 1}, \ 
      PlotStyle\  \[Rule] \ {{Red}, \ {Green}}]; \)], "Input",
  CellLabel->"In[33]:=",
  CellTags->"b:0.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 -0.440417 0.374717 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .02798 -24 -4.5 ]
[.01131 .02798 0 4.5 ]
[.01131 .12166 -18 -4.5 ]
[.01131 .12166 0 4.5 ]
[.01131 .21534 -24 -4.5 ]
[.01131 .21534 0 4.5 ]
[.01131 .4027 -24 -4.5 ]
[.01131 .4027 0 4.5 ]
[.01131 .49638 -18 -4.5 ]
[.01131 .49638 0 4.5 ]
[.01131 .59005 -24 -4.5 ]
[.01131 .59005 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .02798 m
.03006 .02798 L
s
[(1.25)] .01131 .02798 1 0 Mshowa
.02381 .12166 m
.03006 .12166 L
s
[(1.5)] .01131 .12166 1 0 Mshowa
.02381 .21534 m
.03006 .21534 L
s
[(1.75)] .01131 .21534 1 0 Mshowa
.02381 .4027 m
.03006 .4027 L
s
[(2.25)] .01131 .4027 1 0 Mshowa
.02381 .49638 m
.03006 .49638 L
s
[(2.5)] .01131 .49638 1 0 Mshowa
.02381 .59005 m
.03006 .59005 L
s
[(2.75)] .01131 .59005 1 0 Mshowa
.125 Mabswid
.02381 .04672 m
.02756 .04672 L
s
.02381 .06545 m
.02756 .06545 L
s
.02381 .08419 m
.02756 .08419 L
s
.02381 .10292 m
.02756 .10292 L
s
.02381 .14039 m
.02756 .14039 L
s
.02381 .15913 m
.02756 .15913 L
s
.02381 .17787 m
.02756 .17787 L
s
.02381 .1966 m
.02756 .1966 L
s
.02381 .23407 m
.02756 .23407 L
s
.02381 .25281 m
.02756 .25281 L
s
.02381 .27155 m
.02756 .27155 L
s
.02381 .29028 m
.02756 .29028 L
s
.02381 .32775 m
.02756 .32775 L
s
.02381 .34649 m
.02756 .34649 L
s
.02381 .36522 m
.02756 .36522 L
s
.02381 .38396 m
.02756 .38396 L
s
.02381 .42143 m
.02756 .42143 L
s
.02381 .44017 m
.02756 .44017 L
s
.02381 .4589 m
.02756 .4589 L
s
.02381 .47764 m
.02756 .47764 L
s
.02381 .51511 m
.02756 .51511 L
s
.02381 .53385 m
.02756 .53385 L
s
.02381 .55258 m
.02756 .55258 L
s
.02381 .57132 m
.02756 .57132 L
s
.02381 .00924 m
.02756 .00924 L
s
.02381 .60879 m
.02756 .60879 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .30902 m
.06244 .29382 L
.10458 .27728 L
.14415 .26179 L
.18221 .24698 L
.22272 .23133 L
.26171 .2164 L
.30316 .2007 L
.34309 .18579 L
.3815 .17167 L
.42237 .15691 L
.46172 .143 L
.49955 .12994 L
.53984 .11641 L
.57861 .1038 L
.61984 .09087 L
.65954 .07896 L
.69774 .06805 L
.73838 .05711 L
.77751 .0473 L
.81909 .03779 L
.85916 .02965 L
.89771 .02297 L
.91726 .0201 L
.93871 .01746 L
.94807 .0165 L
.9581 .01564 L
.96296 .01529 L
.96756 .01502 L
.97169 .01483 L
.97283 .01479 L
.97403 .01475 L
.97506 .01473 L
.97619 .01472 L
s
0 1 0 r
.02381 .30902 m
.06244 .32421 L
.10458 .34076 L
.14415 .35624 L
.18221 .37105 L
.22272 .3867 L
.26171 .40164 L
.30316 .41733 L
.34309 .43224 L
.3815 .44637 L
.42237 .46112 L
.46172 .47503 L
.49955 .48809 L
.53984 .50162 L
.57861 .51424 L
.61984 .52716 L
.65954 .53908 L
.69774 .54998 L
.73838 .56093 L
.77751 .57073 L
.81909 .58025 L
.85916 .58838 L
.89771 .59507 L
.91726 .59793 L
.93871 .60058 L
.94807 .60153 L
.9581 .6024 L
.96296 .60274 L
.96756 .60301 L
.97169 .6032 L
.97283 .60324 L
.97403 .60328 L
.97506 .6033 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gR000`400?l00000o`00003oo`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`008P3oool00`000000oooo0?ooo`3o0?oood@0oooo
000R0?ooo`030000003oool0oooo0?l0ooooA03oool00280oooo00<000000?ooo`3oool0o`3ooom4
0?ooo`008P3oool200000?l0ooooA@3oool00280oooo00<000000?ooo`3oool0o`3ooom40?ooo`00
8P3oool00`000000oooo0?ooo`3o0?oooc00oooo303o00080?ooo`001@0000040?ooo`800000103o
ool5000000@0oooo100000060?ooo`030000003oool0oooo0?l0oooo:`3oool50?l001@0oooo0002
0?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3o
oolT0?ooo`L0o`006@3oool00080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooolN0?ooo`H0o`00803oool0
0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00<0oooo0`00003o0?oooaP0oooo1P3o000V0?ooo`000P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00<0oooo100000060?ooo`030000003oool0oooo0?l0oooo4P3oool60?l002`0
oooo00020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0?l0oooo3P3oool40?l00380oooo0003000000`0oooo00D0
00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
o`3oool90?ooo`D0o`00=P3oool00080oooo00<000000?ooo`3oool02`3oool3000000D0oooo1@00
00050?ooo`030000003oool0oooo0?l0oooo103oool50?l003/0oooo000R0?ooo`030000003oool0
oooo0?l0oooo103o00100?ooo`008P3oool00`000000oooo0?ooo`3j0?ooo`D0o`00A03oool00280
oooo0P00003f0?ooo`D0o`00B@3oool00280oooo00<000000?ooo`3oool0l@3oool40?l004h0oooo
000R0?ooo`030000003oool0oooo0>d0oooo103o001B0?ooo`008P3oool00`000000oooo0?ooo`3Y
0?ooo`@0o`00EP3oool00280oooo00<000000?ooo`3oool0iP3oool30?l005X0oooo000R0?ooo`03
0000003oool0oooo0>80oooo103o001M0?ooo`008P3oool200000>00oooo0`3o001Q0?ooo`008P3o
ool00`000000oooo0?ooo`3K0?ooo`@0o`00I03oool00280oooo00<000000?ooo`3oool0e`3oool4
0?l006P0oooo000R0?ooo`030000003oool0oooo0=<0oooo103o001/0?ooo`008P3oool00`000000
oooo0?ooo`3?0?ooo`@0o`00L03oool00280oooo00<000000?ooo`3oool0c03oool30?l007@0oooo
000R0?ooo`800000b@3oool40?l007L0oooo000R0?ooo`030000003oool0oooo0<D0oooo0`3o001k
0?ooo`008P3oool00`000000oooo0?ooo`320?ooo`<0o`00OP3oool00280oooo00<000000?ooo`3o
ool0_`3oool30?l00840oooo000R0?ooo`030000003oool0oooo0;d0oooo0P3o00240?ooo`008P3o
ool00`000000oooo0?ooo`2j0?ooo`<0o`00QP3oool00280oooo0P00002h0?ooo`<0o`00R@3oool0
0280oooo00<000000?ooo`3oool0]03oool30?l008`0oooo000R0?ooo`030000003oool0oooo0;40
oooo0`3o002?0?ooo`00203oool5000000@0oooo0P0000050?ooo`@000001P3oool00`000000oooo
0?ooo`2]0?ooo`@0o`00TP3oool000X0oooo00<000000?ooo`3oool0103oool2000000@0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0:X0oooo0`3o
002F0?ooo`002P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0Y`3oool30?l009T0oooo000:0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool00`3oool300000:@0oooo0`3o002L0?ooo`002P3oool00`000000oooo0?ooo`0;0?ooo`@0
00001P3oool00`000000oooo0?ooo`2P0?ooo`@0o`00W`3oool000X0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo09d0oooo0`3o002S0?ooo`00203o
ool3000000d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`2J0?ooo`<0o`00YP3o
ool000X0oooo00<000000?ooo`3oool02`3oool5000000D0oooo00<000000?ooo`3oool0V03oool2
0?l00:T0oooo000R0?ooo`030000003oool0oooo09D0oooo0`3o002[0?ooo`008P3oool00`000000
oooo0?ooo`2B0?ooo`<0o`00[P3oool00280oooo0P00002A0?ooo`80o`00/@3oool00280oooo00<0
00000?ooo`3oool0S@3oool30?l00;<0oooo000R0?ooo`030000003oool0oooo08X0oooo0`3o002f
0?ooo`008P3oool00`000000oooo0?ooo`260?ooo`@0o`00^@3oool00280oooo00<000000?ooo`3o
ool0P`3oool30?l00;d0oooo000R0?ooo`030000003oool0oooo0800oooo0`3o00300?ooo`008P3o
ool2000007l0oooo0P3o00330?ooo`008P3oool00`000000oooo0?ooo`1k0?ooo`<0o`00a@3oool0
0280oooo00<000000?ooo`3oool0N03oool30?l00<P0oooo000R0?ooo`030000003oool0oooo07H0
oooo0P3o003;0?ooo`008P3oool00`000000oooo0?ooo`1c0?ooo`<0o`00c@3oool00280oooo00<0
00000?ooo`3oool0L@3oool20?l00=00oooo000R0?ooo`800000K`3oool30?l00=80oooo000R0?oo
o`030000003oool0oooo06/0oooo0`3o003E0?ooo`008P3oool00`000000oooo0?ooo`1Y0?ooo`80
o`00f03oool00280oooo00<000000?ooo`3oool0IP3oool30?l00=X0oooo000R0?ooo`030000003o
ool0oooo06@0oooo0P3o003M0?ooo`008P3oool00`000000oooo0?ooo`1Q0?ooo`<0o`00g`3oool0
0280oooo0P00001O0?ooo`<0o`00hP3oool00280oooo00<000000?ooo`3oool0G03oool20?l00>D0
oooo000R0?ooo`030000003oool0oooo05T0oooo0`3o003W0?ooo`008P3oool00`000000oooo0?oo
o`1F0?ooo`<0o`00jP3oool000D00000103oool2000000L0oooo00<000000?ooo`3oool00`3oool4
000000H0oooo00<000000?ooo`3oool0E03oool20?l00>d0oooo00020?ooo`030000003oool0oooo
00@0oooo0P0000070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0540oooo0`3o003_0?ooo`000P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`1>0?ooo`<0o`00lP3oool00080oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00<0oooo0`00001;0?ooo`<0o`00m@3oool00080oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`@000001P3oool00`000000oooo0?oo
o`190?ooo`80o`00n03oool00080oooo00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3o
ool0000000T0oooo00<000000?ooo`3oool0AP3oool30?l00?X0oooo0003000000`0oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool0@`3o
ool30?l00?d0oooo00020?ooo`030000003oool0oooo00X0oooo1P0000030?ooo`D000001@3oool0
0`000000oooo0?ooo`110?ooo`80o`00o`3oool10?ooo`008P3oool00`000000oooo0?ooo`0n0?oo
o`<0o`00o`3oool30?ooo`008P3oool2000003`0oooo0`3o003o0?ooo`H0oooo000R0?ooo`030000
003oool0oooo03T0oooo0P3o003o0?ooo`T0oooo000R0?ooo`030000003oool0oooo03H0oooo0`3o
003o0?ooo`/0oooo000R0?ooo`030000003oool0oooo03<0oooo0`3o003o0?ooo`h0oooo000R0?oo
o`030000003oool0oooo0300oooo0`3o003o0?oooa40oooo000R0?ooo`030000003oool0oooo02h0
oooo0P3o003o0?oooa@0oooo000R0?ooo`800000;@3oool20?l00?l0oooo5P3oool00280oooo00<0
00000?ooo`3oool0:@3oool30?l00?l0oooo603oool00280oooo00<000000?ooo`3oool09`3oool2
0?l00?l0oooo6`3oool00280oooo00<000000?ooo`3oool0903oool30?l00?l0oooo7@3oool00280
oooo00<000000?ooo`3oool08P3oool20?l000h0oooo100000050?ooo`800000103oool5000002/0
oooo100000050?ooo`8000001`3oool3000002/0oooo100000050?ooo`8000001P3oool3000002/0
oooo100000050?ooo`8000001@3oool4000003@0oooo1@0000060?ooo`008P3oool00`000000oooo
0?ooo`0O0?ooo`<0o`003`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
0P0000040?ooo`050000003oool0oooo0?ooo`000000:P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo0P0000080?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`8000001@3oool01@000000oooo0?ooo`3oool00000
02T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`800000103oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool01P3oool00280
oooo0P00000M0?ooo`<0o`004P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0
oooo00D000000?ooo`3oool0oooo0000000Y0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03<0oooo00<000000?oo
o`3oool01P3oool00280oooo00<000000?ooo`3oool06P3oool20?l001D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`080?ooo`H00000:P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000Y0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
03<0oooo00<000000?ooo`3oool01P3oool00280oooo00<000000?ooo`3oool05`3oool30?l001L0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo0000
02/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`@00000:P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo1000000f0?ooo`030000003oool0oooo
00H0oooo000R0?ooo`030000003oool0oooo01D0oooo0P3o000J0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`00000[0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
03<0oooo00<000000?ooo`3oool01P3oool00280oooo00<000000?ooo`3oool04`3oool20?l001`0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?oo
o`000000:P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`000000:`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0:P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0a0?ooo`<00000203oool00280oooo00<000000?ooo`3o
ool0403oool30?l001l0oooo1000000<0?ooo`<00000;03oool4000000h0oooo0P00000/0?ooo`@0
00003P3oool3000002X0oooo1000000<0?ooo`@00000=P3oool00`000000oooo0?ooo`060?ooo`00
8P3oool00`000000oooo0?ooo`0>0?ooo`80o`00o`3ooold0?ooo`008P3oool2000000d0oooo0P3o
003o0?ooocH0oooo000R0?ooo`030000003oool0oooo00T0oooo0`3o003o0?ooocP0oooo000R0?oo
o`030000003oool0oooo00L0oooo0P3o003o0?oooc/0oooo000R0?ooo`030000003oool0oooo00@0
oooo0`3o003o0?ooocd0oooo000R0?ooo`040000003oool0oooo0?ooo`<0o`00o`3ooom00?ooo`00
8P3oool010000000oooo0?l0003o003o0?oood<0oooo000J0?ooo`P000000P00o`3o000004D00000
000R0?ooo`040000003oool00?l0003o00`0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`060?ooo`008P3oool010000000oooo0?ooo`3oool3003o03P0oooo00<000000?ooo`3oool0
?03oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0
?@3oool00`000000oooo0?ooo`060?ooo`008P3oool00`000000oooo0?ooo`040?ooo`<00?l0o`3o
oolm0?ooo`008P3oool00`000000oooo0?ooo`070?ooo`800?l0o`3ooolk0?ooo`008P3oool00`00
0000oooo0?ooo`090?ooo`<00?l0o`3ooolh0?ooo`008P3oool2000000d0oooo0`00o`3o0?ooocD0
oooo000R0?ooo`030000003oool0oooo00l0oooo0P00o`3o0?oooc<0oooo000R0?ooo`030000003o
ool0oooo0140oooo0`00o`3o0?oooc00oooo000R0?ooo`030000003oool0oooo01@0oooo0`00o`3o
0?ooobd0oooo000R0?ooo`030000003oool0oooo01L0oooo0`00o`3o0?ooobX0oooo000R0?ooo`03
0000003oool0oooo01X0oooo0P00o`3o0?ooobP0oooo000R0?ooo`8000007@3oool2003o0?l0oooo
9P3oool00280oooo00<000000?ooo`3oool07P3oool2003o0?l0oooo903oool00280oooo00<00000
0?ooo`3oool0803oool2003o0?l0oooo8P3oool00280oooo00<000000?ooo`3oool08P3oool2003o
0?l0oooo803oool00280oooo00<000000?ooo`3oool0903oool3003o0?l0oooo7@3oool00280oooo
00<000000?ooo`3oool09`3oool3003o0?l0oooo6P3oool00280oooo00<000000?ooo`3oool0:P3o
ool3003o0?l0oooo5`3oool00280oooo0P00000^0?ooo`<00?l0o`3ooolD0?ooo`008P3oool00`00
0000oooo0?ooo`0`0?ooo`<00?l0o`3ooolA0?ooo`008P3oool00`000000oooo0?ooo`0c0?ooo`80
0?l0o`3oool?0?ooo`008P3oool00`000000oooo0?ooo`0e0?ooo`800?l0o`3oool=0?ooo`008P3o
ool00`000000oooo0?ooo`0g0?ooo`<00?l0o`3oool:0?ooo`008P3oool00`000000oooo0?ooo`0j
0?ooo`800?l0o`3oool80?ooo`008P3oool2000003d0oooo0P00o`3o0?ooo`H0oooo000R0?ooo`03
0000003oool0oooo03h0oooo0`00o`3o0?ooo`<0oooo000R0?ooo`030000003oool0oooo0440oooo
0P00o`3o0?ooo`40oooo0004000000D0oooo0P0000040?ooo`D00000103oool4000000H0oooo00<0
00000?ooo`3oool0@`3oool3003o0?d0oooo00030?ooo`030000003oool0oooo00<0oooo0P000004
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0AP3oool3003o0?X0oooo00000`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`19
0?ooo`800?l0n03oool000030?ooo`000000oooo00h0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`030?ooo`<00000B`3oool3003o0?D0oooo00020?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool00`3oool4000000H0oooo00<000000?ooo`3oool0CP3oool3003o0?80
oooo00030?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0540oooo0P00o`3`0?ooo`000`3oool00`000000oooo0?oo
o`090?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo05<0oooo0`00o`3]0?ooo`000`00000=0?ooo`<000001@3oool5000000D0oooo00<0
00000?ooo`3oool0EP3oool3003o0>X0oooo000R0?ooo`030000003oool0oooo05T0oooo0`00o`3W
0?ooo`008P3oool2000005d0oooo0P00o`3U0?ooo`008P3oool00`000000oooo0?ooo`1N0?ooo`<0
0?l0hP3oool00280oooo00<000000?ooo`3oool0H@3oool3003o0=l0oooo000R0?ooo`030000003o
ool0oooo06@0oooo0P00o`3M0?ooo`008P3oool00`000000oooo0?ooo`1V0?ooo`<00?l0fP3oool0
0280oooo00<000000?ooo`3oool0J@3oool2003o0=P0oooo000R0?ooo`800000K03oool3003o0=D0
oooo000R0?ooo`030000003oool0oooo06h0oooo0`00o`3B0?ooo`008P3oool00`000000oooo0?oo
o`1a0?ooo`800?l0d03oool00280oooo00<000000?ooo`3oool0L`3oool3003o0<d0oooo000R0?oo
o`030000003oool0oooo07H0oooo0`00o`3:0?ooo`008P3oool00`000000oooo0?ooo`1i0?ooo`@0
0?l0aP3oool00280oooo00<000000?ooo`3oool0O@3oool3003o0<<0oooo000R0?ooo`800000P@3o
ool3003o0<00oooo000R0?ooo`030000003oool0oooo08<0oooo0P00o`2n0?ooo`008P3oool00`00
0000oooo0?ooo`250?ooo`<00?l0^`3oool00280oooo00<000000?ooo`3oool0R03oool3003o0;P0
oooo000R0?ooo`030000003oool0oooo08/0oooo0P00o`2f0?ooo`008P3oool00`000000oooo0?oo
o`2=0?ooo`<00?l0/`3oool00280oooo0P00002A0?ooo`<00?l0/03oool00280oooo00<000000?oo
o`3oool0T`3oool4003o0:`0oooo000R0?ooo`030000003oool0oooo09L0oooo0`00o`2Y0?ooo`00
1`3oool5000000D0oooo0P0000050?ooo`@000001P3oool00`000000oooo0?ooo`2J0?ooo`<00?l0
YP3oool000L0oooo00D000000?ooo`3oool0oooo000000050?ooo`800000103oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0W@3oool2003o0:@0oooo
00080?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`2O0?ooo`<00?l0X@3oool000T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`03
0?ooo`<00000XP3oool3003o09h0oooo000:0?ooo`030000003oool0oooo00/0oooo100000060?oo
o`030000003oool0oooo0:D0oooo0P00o`2L0?ooo`002`3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0Y`3oool3003o09T0oooo00070?ooo`050000
003oool0oooo0?ooo`000000303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0:X0
oooo0`00o`2F0?ooo`00203oool3000000d0oooo1@0000050?ooo`030000003oool0oooo0:d0oooo
1000o`2B0?ooo`008P3oool00`000000oooo0?ooo`2a0?ooo`<00?l0S`3oool00280oooo0P00002e
0?ooo`<00?l0S03oool00280oooo00<000000?ooo`3oool0]`3oool4003o08P0oooo000R0?ooo`03
0000003oool0oooo0;/0oooo0`00o`250?ooo`008P3oool00`000000oooo0?ooo`2n0?ooo`@00?l0
P@3oool00280oooo00<000000?ooo`3oool0`P3oool3003o07h0oooo000R0?ooo`030000003oool0
oooo0<D0oooo0`00o`1k0?ooo`008P3oool00`000000oooo0?ooo`380?ooo`@00?l0M`3oool00280
oooo0P00003=0?ooo`<00?l0M03oool00280oooo00<000000?ooo`3oool0c`3oool3003o0740oooo
000R0?ooo`030000003oool0oooo0=80oooo0`00o`1^0?ooo`008P3oool00`000000oooo0?ooo`3E
0?ooo`@00?l0JP3oool00280oooo00<000000?ooo`3oool0f@3oool3003o06L0oooo000R0?ooo`03
0000003oool0oooo0=`0oooo0`00o`1T0?ooo`008P3oool200000>00oooo0`00o`1Q0?ooo`008P3o
ool00`000000oooo0?ooo`3R0?ooo`@00?l0G@3oool00280oooo00<000000?ooo`3oool0iP3oool3
003o05X0oooo000R0?ooo`030000003oool0oooo0>T0oooo1000o`1F0?ooo`008P3oool00`000000
oooo0?ooo`3]0?ooo`@00?l0DP3oool00280oooo00<000000?ooo`3oool0l@3oool4003o04h0oooo
000R0?ooo`800000mP3oool5003o04T0oooo000R0?ooo`030000003oool0oooo0?X0oooo1000o`15
0?ooo`008P3oool00`000000oooo0?ooo`3n0?ooo`D00?l0@03oool000@000001@3oool2000000L0
oooo00<000000?ooo`3oool00`3oool4000000H0oooo00<000000?ooo`3oool0o`3oool40?ooo`D0
0?l0>`3oool000<0oooo00<000000?ooo`3oool00`3oool2000000L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
o`3oool90?ooo`@00?l0=`3oool000030000003oool0oooo00l0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo3@3oool5003o0380oooo0000
0`3oool000000?ooo`0@0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool3
00000?l0oooo4P3oool5003o02d0oooo00020?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool00P3oool4000000H0oooo00<000000?ooo`3oool0o`3ooolG0?ooo`H00?l09`3oool000<0
oooo00<000000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?oo
o`3oool0o`3ooolM0?ooo`L00?l0803oool000<0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`3o0?oo
ob@0oooo1`00o`0I0?ooo`000`00000<0?ooo`H000000`3oool5000000D0oooo00<000000?ooo`3o
ool0o`3oool[0?ooo`/00?l03P3oool00280oooo00<000000?ooo`3oool0o`3ooolf0?ooo`H00?l0
203oool00280oooo00<000000?ooo`3oool0o`3ooom40?ooo`008P3oool200000?l0ooooA@3oool0
0280oooo00<000000?ooo`3oool0o`3ooom40?ooo`008P3oool00`000000oooo0?ooo`3o0?oood@0
oooo000R0?ooo`030000003oool0oooo0?l0ooooA03oool00?l0ooooJ@3oool00?l0ooooJ@3oool0
0?l0ooooJ@3oool00?l0ooooJ@3oool00?l0ooooJ@3oool00?l0ooooJ@3oool00?l0ooooJ@3oool0
0001\
\>"],
  ImageRangeCache->{{{81, 368}, {288.688, 111.75}} -> {-0.427594, 2.23356, \
0.00394728, 0.0100324}},
  CellTags->"b:0.1"]
}, Open  ]],

Cell[TextData[{
  "The examples in this section have been focused on the classification of \
ODEs. The classification of PDEs is similar but more involved. PDEs can also \
be classified by linearity or nonlinearity, order, degree, and constant or \
variable coefficients. More important is the classification that identifies a \
PDE as hyperbolic, parabolic, or elliptic. These classifications are \
discussed in further detail in a ",
  ButtonBox["later section",
    ButtonData:>"second_order_pdes",
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  CellTags->"b:0.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Goals of This Document", "Section",
  CellTags->{"c:4", "b:0.2"}],

Cell[TextData[{
  "The design of ",
  StyleBox["DSolve", "MR"],
  " is modular: the algorithms for different classes of problems work \
independently of one other. Once a problem has been classified (as described \
in the ",
  ButtonBox["previous section",
    ButtonData:>"classification",
    ButtonStyle->"Hyperlink"],
  "), the available methods for that class are tried in a specific sequence \
until a solution is obtained. The code has a hierarchical structure whereby \
the solution of complex problems is reduced to the solution of relatively \
simpler problems, for which a greater variety of methods is available. For \
example, higher-order ODEs are typically solved by reducing their order to 1 \
or 2. "
}], "Text",
  CellTags->"b:0.2"],

Cell["\<\
The process described is done internally and does not require any \
intervention from the user. For this reason, this document has the following \
basic goals.\
\>", "Text",
  CellTags->"b:0.2"],

Cell[TextData[{
  "To provide enough information and tips so that users can pose problems to \
",
  StyleBox["DSolve", "MR"],
  " in the most appropriate form and apply the solutions in their work. This \
is accomplished through a substantial number of examples. A summary of this \
information is given in the section ",
  ButtonBox["Working with ",
    ButtonData:>"Working_with_DSolve",
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["DSolve",
    ButtonData:>"Working_with_DSolve",
    ButtonStyle->"Hyperlink"], "MR"],
  "."
}], "BulletedList",
  CellTags->"b:0.2"],

Cell[TextData[{
  "To give a catalog of the kinds of problems that can be handled by ",
  StyleBox["DSolve", "MR"],
  " as well as the nature of the solutions for each case. This is provided in \
the sections on ",
  ButtonBox["ODEs",
    ButtonData:>"ODEs",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["PDEs",
    ButtonData:>"PDEs",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["DAEs",
    ButtonData:>"DAEs",
    ButtonStyle->"Hyperlink"],
  ", and ",
  ButtonBox["boundary value problems",
    ButtonData:>"BVPs",
    ButtonStyle->"Hyperlink"],
  " (BVPs)."
}], "BulletedList",
  CellTags->"b:0.2"],

Cell[TextData[{
  "The author hopes that this document will be useful in acquiring a basic \
knowledge of ",
  StyleBox["DSolve", "MR"],
  " and also serve as a ready reference for information on more advanced \
topics."
}], "Text",
  CellTags->"b:0.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Acknowledgements", "Section",
  CellTags->{"c:59", "b:0.3"}],

Cell["\<\
I would like to thank Tom Wickham-Jones for suggesting this \
documentation project and for providing guidance on how to make it more \
useful.\
\>", "Text",
  CellTags->"b:0.3"],

Cell[TextData[{
  "Thanks to Unal Goktas and Roger Germundsson, who have been involved in the \
design and algorithm implementation aspects of ",
  StyleBox["DSolve", "MR"],
  " over a long period of time. Their suggestions and insights have always \
been fruitful for me."
}], "Text",
  CellTags->"b:0.3"],

Cell["\<\
Thanks to Andy Hunt for giving very useful advice that helped in \
organizing the material and finishing the project in a reasonable amount of \
time.\
\>", "Text",
  CellTags->"b:0.3"],

Cell["\<\
Lisa Degler edited the entire document and made a vast number of \
suggestions for stylistic and more substantial changes. I would like to thank \
her for her patience and hard work.\
\>", "Text",
  CellTags->"b:0.3"],

Cell["\<\

Devendra Kapadia.\
\>", "Text",
  CellTags->"b:0.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ordinary Differential Equations", "Chapter",
  CellTags->{"ODEs", "c:5", "i:1"}],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->{"c:6", "b:1.0"}],

Cell["\<\
There are four major areas in the study of ordinary differential \
equations that are of interest in pure and applied science. \
\>", "Text",
  CellTags->"b:1.0"],

Cell["\<\
Exact solutions, which are closed-form or implicit analytical \
expressions that satisfy the given problem.\
\>", "BulletedList",
  CellTags->"b:1.0"],

Cell["\<\
Numerical solutions, which are available for a wider class of \
problems, but are typically only valid over a limited range of the \
independent variables.\
\>", "BulletedList",
  CellTags->"b:1.0"],

Cell["\<\
Qualitative theory, which is concerned with the global properties \
of solutions and is particularly important in the modern approach to \
dynamical systems.\
\>", "BulletedList",
  CellTags->"b:1.0"],

Cell["\<\
Existence and uniqueness theorems, which guarantee that there are \
solutions with certain desirable properties provided a set of conditions is \
fulfilled by the differential equation.\
\>", "BulletedList",
  CellTags->"b:1.0"],

Cell[TextData[{
  "Of these four areas, the study of exact solutions has the longest history, \
dating back to the period just after the discovery of calculus by Sir Isaac \
Newton and Gottfried Wilhelm von Leibniz. The following table is given as an \
introduction to the types of equations that can be solved by ",
  StyleBox["DSolve", "MR"],
  "."
}], "Text",
  CellTags->"b:1.0"],

Cell[BoxData[
    FormBox[
      FrameBox[GridBox[{
            {
              StyleBox[\(Name\ of\ Equation\),
                FontWeight->"Bold"], 
              StyleBox[\(\(General\)\(\ \)\(Form\)\(\ \)\),
                FontWeight->"Bold"], 
              StyleBox[\(\(\ \)\(Date\ of\ Discovery\)\),
                FontWeight->"Bold"], 
              StyleBox["Mathematician",
                FontFamily->"Palatino",
                FontWeight->"Bold"]},
            {
              ButtonBox["Separable",
                ButtonData:>"separableODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              FormBox[
                RowBox[{
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "(", "x", ")"}], 
                  "\[LongEqual]", \(\(f(x)\)\ \(g(y)\)\)}],
                "TraditionalForm"], "1691", 
              RowBox[{
                StyleBox["G",
                  FontSlant->"Plain"], ".", " ", "Leibniz"}]},
            {
              ButtonBox["Homogeneous",
                ButtonData:>"homogeneousODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              FormBox[
                RowBox[{
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "(", "x", ")"}], 
                  "\[LongEqual]", \(f(x\/\(y(x)\))\)}],
                "TraditionalForm"], "1691", 
              RowBox[{
                StyleBox["G",
                  FontSlant->"Plain"], ".", " ", "Leibniz"}]},
            {
              ButtonBox[Cell["Linear first-order ODE"],
                ButtonData:>"LinearODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              FormBox[
                RowBox[{
                  RowBox[{\(\(P(x)\)\ \(y(x)\)\), "+", 
                    RowBox[{
                      SuperscriptBox["y", "\[Prime]",
                        MultilineFunction->None], "(", "x", ")"}]}], 
                  "\[LongEqual]", \(Q(x)\)}],
                "TraditionalForm"], "1694", 
              RowBox[{
                StyleBox["G",
                  FontSlant->"Plain"], ".", " ", "Leibniz"}]},
            {
              ButtonBox["Bernoulli",
                ButtonData:>"BernoulliODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              FormBox[
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["y", "\[Prime]",
                        MultilineFunction->None], "(", "x", ")"}], 
                    "+", \(\(P(x)\)\ \(y(x)\)\^n\)}], 
                  "\[LongEqual]", \(Q(x)\), "\[NoBreak]"}],
                "TraditionalForm"], "1695", \(James\ Bernoulli\)},
            {
              ButtonBox["Riccati",
                ButtonData:>"RiccatiODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              FormBox[
                RowBox[{
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], " ", \((x)\)}], 
                  "\[LongEqual]", 
                  " ", \(f(
                      x)\  + \ \(g(x)\) \(y(x)\)\  + \ \(h(
                        x)\)\ \(y(x)\)\^2\)}],
                "TraditionalForm"], "1724", \(Count\ Riccati\)},
            {
              ButtonBox["Exact",
                ButtonData:>"ExactODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              FormBox[
                RowBox[{
                  RowBox[{\(M\ dx + \ N\ dy\), "\[LongEqual]", 
                    RowBox[{"0", " ", "with", " ", 
                      FractionBox[\(\[PartialD]M\), \(\[PartialD]y\),
                        MultilineFunction->None]}]}], "=", 
                  FractionBox[\(\[PartialD]N\), \(\[PartialD]x\),
                    MultilineFunction->None]}],
                "TraditionalForm"], "1734", 
              RowBox[{
                StyleBox["L",
                  FontSlant->"Plain"], ".", " ", "Euler"}]},
            {
              ButtonBox["Clairaut",
                ButtonData:>"ClairautODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              FormBox[
                RowBox[{\(y(x)\), "\[LongEqual]", 
                  RowBox[{
                    RowBox[{"f", "(", 
                      RowBox[{
                        SuperscriptBox["y", "\[Prime]",
                          MultilineFunction->None], "(", "x", ")"}], ")"}], 
                    "+", 
                    RowBox[{"x", " ", 
                      RowBox[{
                        SuperscriptBox["y", "\[Prime]",
                          MultilineFunction->None], "(", "x", ")"}]}]}]}],
                "TraditionalForm"], "1734", Cell["A-C. Clairaut"]},
            {
              ButtonBox[\(Linear\ with\ constant\ coefficients\),
                ButtonData:>"ODEwConstCoefs",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        FormBox[\(\(y\^\((n)\)\)\((\)\(x\)\),
                          "TraditionalForm"], ")"}], "+", 
                      RowBox[{\(a\_\(n - 1\)\), 
                        FormBox[\(y\^\((n - 1)\)\),
                          "TraditionalForm"], \((x)\)}], "+"}], "..."}], 
                  "+", \(\(a\_0\) \(y(x)\)\)}], "\[LongEqual]", 
                RowBox[{\(P(x)\), " ", "with", " ", 
                  FormBox[\(a\_i\ constant\),
                    "TraditionalForm"]}]}], "1743", 
              RowBox[{
                StyleBox["L",
                  FontSlant->"Plain"], ".", " ", "Euler"}]},
            {
              ButtonBox["Hypergeometric",
                ButtonData:>"HypergeometricODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              FormBox[
                RowBox[{
                  RowBox[{
                    RowBox[{\(x(1 - x)\), " ", 
                      RowBox[{
                        SuperscriptBox["y", "\[Prime]\[Prime]",
                          MultilineFunction->None], "(", "x", ")"}]}], "+", 
                    RowBox[{\((c - \((a + b + 1)\)\ x)\), " ", 
                      RowBox[{
                        SuperscriptBox["y", "\[Prime]",
                          MultilineFunction->None], "(", "x", ")"}]}], 
                    "-", \(a\ b\ \(y(x)\)\)}], "\[LongEqual]", "0"}],
                "TraditionalForm"], "1769", 
              RowBox[{
                StyleBox["L",
                  FontSlant->"Plain"], ".", " ", "Euler"}]},
            {
              ButtonBox["Legendre",
                ButtonData:>"LegendreODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              RowBox[{
                
                FormBox[\(\(\((1 - x\^2)\) \((\(d\^2\) y/d  x\^2)\) - 
                      2 \( x(d  y/d  x)\) + \(n(n + 1)\) y\)\(=\)\),
                  "TraditionalForm"], " ", "0"}], "1785", 
              RowBox[{
                StyleBox["M",
                  FontSlant->"Plain"], ".", " ", "Legendre"}]},
            {
              ButtonBox["Bessel",
                ButtonData:>"BesselODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                
                ButtonFrame->"None"], \(\(z\^2\) y\^\[Prime]\[Prime] + 
                  z  y\^\[Prime] + \((z\^2 - n\^2)\) y = 0\), "1824", 
              RowBox[{
                StyleBox["F",
                  FontSlant->"Plain"], ".", " ", "Bessel"}]},
            {
              ButtonBox["Mathieu",
                ButtonData:>"MathieuODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              RowBox[{" ", 
                
                FormBox[\(y\^\[Prime]\[Prime] + \((a - 2  q \( cos(2  z)\))\) 
                        y = 0\),
                  "TraditionalForm"]}], "1868", 
              RowBox[{
                StyleBox["E",
                  FontSlant->"Plain"], 
                StyleBox[".",
                  FontSlant->"Italic"], " ", "Mathieu"}]},
            {
              ButtonBox["Abel",
                ButtonData:>"AbelODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              RowBox[{
                FormBox[
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["y", "\[Prime]",
                        MultilineFunction->None], " ", \((x)\)}], 
                    "\[LongEqual]", 
                    " ", \(f(
                        x)\  + \ \(g(x)\) \(y(x)\)\  + \ \(h(
                          x)\)\ \(y(x)\)\^2\)}],
                  "TraditionalForm"], "+", " ", \(\(k(x)\)\ \(y(x)\)\^3\)}], 
              "1834", 
              RowBox[{
                StyleBox["N",
                  FontSlant->"Plain"], 
                StyleBox[".",
                  FontSlant->"Plain"], 
                StyleBox[" ",
                  FontSlant->"Plain"], 
                StyleBox["H",
                  FontSlant->"Plain"], 
                StyleBox[".",
                  FontSlant->"Plain"], 
                StyleBox[" ",
                  FontSlant->"Plain"], "Abel"}]},
            {
              ButtonBox["Chini",
                ButtonData:>"ChiniODE",
                ButtonExpandable->False,
                ButtonStyle->"Hyperlink",
                ButtonFrame->"None"], 
              FormBox[
                RowBox[{
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "(", "x", ")"}], 
                  "\[LongEqual]", \(\(f(x)\)\ \(y(x)\)\^n + \(g(x)\)\ \(y(
                        x)\) + h(x)\)}],
                "TraditionalForm"], "1924", 
              RowBox[{
                StyleBox["M",
                  FontSlant->"Plain"], ".", " ", "Chini"}]}
            },
          ColumnWidths->{0.2, 0.43, 0.14, 0.2},
          RowLines->True,
          ColumnLines->True]], TraditionalForm]], "DisplayFormula",
  CellMargins->{{22, Inherited}, {Inherited, Inherited}},
  TextAlignment->Center,
  TextJustification->0,
  FrameBoxOptions->{BoxMargins->0.25},
  GridBoxOptions->{RowAlignments->Center,
  ColumnAlignments->{Center},
  GridFrameMargins->0.25,
  MultilineFunction->Automatic},
  CellTags->{"EquationTypes", "b:1.0"}],

Cell["\<\
Examples of ODEs belonging to each of these types are given later \
in this section.\
\>", "Text",
  CellTags->"b:1.0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Single ODEs", "Section",
  CellTags->"c:7"],

Cell[CellGroupData[{

Cell["First-Order ODEs", "Subsection",
  CellTags->"c:8"],

Cell[CellGroupData[{

Cell["Straight Integration", "Subsubsection",
  CellTags->{"c:9", "b:1.1.0.0"}],

Cell[TextData[{
  "This equation is solved by simply integrating the right-hand side with \
respect to ",
  StyleBox["x", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[\(y'\)[x]\  \[Equal] x^2*Sin[x] + Sqrt[1 + x^2], \ y, 
        x]\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"b:1.1.0.0"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            1\/2\ x\ \@\(1 + x\^2\) + ArcSinh[x]\/2 + 
              C[1] - \((\(-2\) + x\^2)\)\ Cos[x] + 
              2\ x\ Sin[x]]}}\)], "Output",
  CellLabel->"Out[34]=",
  CellTags->"b:1.1.0.0"]
}, Open  ]],

Cell[TextData[{
  "Here is a plot of the integral curves for different values of the \
arbitrary constant ",
  StyleBox["C[1]", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.0.0"],

Cell[BoxData[
    \(tab = 
      Table[\(y[x]\  /. 
            sol[\([\)\(1\)\(]\)]\)\  /. {C[1]\  -> \ k}, \ {k, \ \(-80\), \ 
          80, \ 40}]; \)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"b:1.1.0.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[tab], \ {x, \ 3, \ 18}, \ 
      PlotStyle\  -> \ {{Red}, \ {Blue}, \ {Green}, \ {Pink}}, \ 
      PlotRange\  \[Rule] \ All]; \)], "Input",
  CellLabel->"In[36]:=",
  CellTags->"b:1.1.0.0"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.0634921 0.165813 0.000970971 [
[.21429 .15331 -3 -9 ]
[.21429 .15331 3 0 ]
[.34127 .15331 -3 -9 ]
[.34127 .15331 3 0 ]
[.46825 .15331 -6 -9 ]
[.46825 .15331 6 0 ]
[.59524 .15331 -6 -9 ]
[.59524 .15331 6 0 ]
[.72222 .15331 -6 -9 ]
[.72222 .15331 6 0 ]
[.84921 .15331 -6 -9 ]
[.84921 .15331 6 0 ]
[.97619 .15331 -6 -9 ]
[.97619 .15331 6 0 ]
[.0748 .06872 -24 -4.5 ]
[.0748 .06872 0 4.5 ]
[.0748 .26291 -18 -4.5 ]
[.0748 .26291 0 4.5 ]
[.0748 .36001 -18 -4.5 ]
[.0748 .36001 0 4.5 ]
[.0748 .4571 -18 -4.5 ]
[.0748 .4571 0 4.5 ]
[.0748 .5542 -18 -4.5 ]
[.0748 .5542 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .16581 m
.21429 .17206 L
s
[(6)] .21429 .15331 0 1 Mshowa
.34127 .16581 m
.34127 .17206 L
s
[(8)] .34127 .15331 0 1 Mshowa
.46825 .16581 m
.46825 .17206 L
s
[(10)] .46825 .15331 0 1 Mshowa
.59524 .16581 m
.59524 .17206 L
s
[(12)] .59524 .15331 0 1 Mshowa
.72222 .16581 m
.72222 .17206 L
s
[(14)] .72222 .15331 0 1 Mshowa
.84921 .16581 m
.84921 .17206 L
s
[(16)] .84921 .15331 0 1 Mshowa
.97619 .16581 m
.97619 .17206 L
s
[(18)] .97619 .15331 0 1 Mshowa
.125 Mabswid
.11905 .16581 m
.11905 .16956 L
s
.15079 .16581 m
.15079 .16956 L
s
.18254 .16581 m
.18254 .16956 L
s
.24603 .16581 m
.24603 .16956 L
s
.27778 .16581 m
.27778 .16956 L
s
.30952 .16581 m
.30952 .16956 L
s
.37302 .16581 m
.37302 .16956 L
s
.40476 .16581 m
.40476 .16956 L
s
.43651 .16581 m
.43651 .16956 L
s
.5 .16581 m
.5 .16956 L
s
.53175 .16581 m
.53175 .16956 L
s
.56349 .16581 m
.56349 .16956 L
s
.62698 .16581 m
.62698 .16956 L
s
.65873 .16581 m
.65873 .16956 L
s
.69048 .16581 m
.69048 .16956 L
s
.75397 .16581 m
.75397 .16956 L
s
.78571 .16581 m
.78571 .16956 L
s
.81746 .16581 m
.81746 .16956 L
s
.88095 .16581 m
.88095 .16956 L
s
.9127 .16581 m
.9127 .16956 L
s
.94444 .16581 m
.94444 .16956 L
s
.05556 .16581 m
.05556 .16956 L
s
.02381 .16581 m
.02381 .16956 L
s
.25 Mabswid
0 .16581 m
1 .16581 L
s
.0873 .06872 m
.09355 .06872 L
s
[(-100)] .0748 .06872 1 0 Mshowa
.0873 .26291 m
.09355 .26291 L
s
[(100)] .0748 .26291 1 0 Mshowa
.0873 .36001 m
.09355 .36001 L
s
[(200)] .0748 .36001 1 0 Mshowa
.0873 .4571 m
.09355 .4571 L
s
[(300)] .0748 .4571 1 0 Mshowa
.0873 .5542 m
.09355 .5542 L
s
[(400)] .0748 .5542 1 0 Mshowa
.125 Mabswid
.0873 .08814 m
.09105 .08814 L
s
.0873 .10755 m
.09105 .10755 L
s
.0873 .12697 m
.09105 .12697 L
s
.0873 .14639 m
.09105 .14639 L
s
.0873 .18523 m
.09105 .18523 L
s
.0873 .20465 m
.09105 .20465 L
s
.0873 .22407 m
.09105 .22407 L
s
.0873 .24349 m
.09105 .24349 L
s
.0873 .28233 m
.09105 .28233 L
s
.0873 .30175 m
.09105 .30175 L
s
.0873 .32117 m
.09105 .32117 L
s
.0873 .34059 m
.09105 .34059 L
s
.0873 .37943 m
.09105 .37943 L
s
.0873 .39885 m
.09105 .39885 L
s
.0873 .41827 m
.09105 .41827 L
s
.0873 .43769 m
.09105 .43769 L
s
.0873 .47652 m
.09105 .47652 L
s
.0873 .49594 m
.09105 .49594 L
s
.0873 .51536 m
.09105 .51536 L
s
.0873 .53478 m
.09105 .53478 L
s
.0873 .0493 m
.09105 .0493 L
s
.0873 .02988 m
.09105 .02988 L
s
.0873 .01046 m
.09105 .01046 L
s
.0873 .57362 m
.09105 .57362 L
s
.0873 .59304 m
.09105 .59304 L
s
.0873 .61246 m
.09105 .61246 L
s
.25 Mabswid
.0873 0 m
.0873 .61803 L
s
1 0 0 r
.5 Mabswid
.02381 .10117 m
.02846 .10147 L
.03279 .10171 L
.03793 .10194 L
.04262 .10209 L
.04498 .10215 L
.04622 .10217 L
.04754 .10219 L
.04869 .10221 L
.04996 .10222 L
.05112 .10223 L
.0522 .10223 L
.05352 .10222 L
.05478 .10222 L
.0559 .10221 L
.05713 .10219 L
.05847 .10217 L
.05989 .10214 L
.06244 .10207 L
.06529 .10196 L
.06791 .10184 L
.07382 .10147 L
.07904 .10105 L
.08454 .10049 L
.0941 .09925 L
.10458 .0975 L
.12409 .09327 L
.145 .08765 L
.16482 .08196 L
.17526 .07909 L
.18637 .07636 L
.1962 .07435 L
.20143 .07349 L
.20706 .07274 L
.20957 .07248 L
.21221 .07225 L
.21447 .0721 L
.21576 .07203 L
.21694 .07198 L
.21813 .07193 L
.21926 .07191 L
.22045 .07189 L
.22174 .07188 L
.22287 .07189 L
.22407 .07191 L
.22509 .07193 L
.22621 .07197 L
.2275 .07203 L
.2287 .0721 L
.23142 .07231 L
Mistroke
.23382 .07255 L
.23637 .07287 L
.24125 .07366 L
.24566 .0746 L
.25642 .07777 L
.26655 .08196 L
.28667 .09376 L
.30515 .10845 L
.34469 .14867 L
.38272 .18853 L
.40227 .20453 L
.40789 .20815 L
.41322 .2111 L
.41796 .2133 L
.42319 .21524 L
.4256 .21595 L
.42819 .21659 L
.43063 .21706 L
.43287 .21739 L
.43411 .21752 L
.43527 .21761 L
.43653 .21768 L
.43724 .21771 L
.43788 .21772 L
.43918 .21772 L
.43991 .2177 L
.44059 .21767 L
.44183 .2176 L
.44314 .21748 L
.44429 .21734 L
.44533 .2172 L
.44768 .21677 L
.45193 .21569 L
.45688 .2139 L
.46158 .21168 L
.47121 .20555 L
.48146 .19677 L
.49987 .1756 L
.53759 .11685 L
.55854 .08145 L
.57776 .05203 L
.58751 .03944 L
.59658 .02966 L
.60605 .02183 L
.61106 .01878 L
.61366 .01752 L
.61642 .01643 L
.61895 .01566 L
.62039 .01533 L
.62174 .01508 L
Mistroke
.62297 .01491 L
.6241 .0148 L
.6254 .01474 L
.62664 .01474 L
.62734 .01476 L
.62798 .0148 L
.62871 .01486 L
.6294 .01494 L
.63062 .01512 L
.63195 .01538 L
.63342 .01574 L
.63496 .01622 L
.63774 .01731 L
.64271 .02002 L
.64734 .02343 L
.65788 .03439 L
.66834 .04965 L
.67825 .06797 L
.69681 .11153 L
.73516 .22838 L
.75456 .29209 L
.77596 .35703 L
.78572 .38271 L
.79623 .40651 L
.80608 .42448 L
.81525 .43691 L
.81988 .4415 L
.82226 .44339 L
.82483 .44507 L
.8263 .44587 L
.82765 .44648 L
.82892 .44697 L
.83032 .44739 L
.83157 .44767 L
.83274 .44785 L
.83398 .44795 L
.83467 .44796 L
.8353 .44795 L
.83661 .44785 L
.83734 .44775 L
.83799 .44764 L
.83928 .44733 L
.84049 .44695 L
.8432 .44578 L
.84613 .44401 L
.85149 .43941 L
.85641 .43365 L
.86618 .41792 L
.87529 .39827 L
.89597 .33759 L
Mistroke
.93495 .18185 L
.97619 .01472 L
Mfstroke
0 0 1 r
.02381 .14001 m
.02846 .14031 L
.03279 .14055 L
.03793 .14078 L
.04262 .14093 L
.04498 .14099 L
.04622 .14101 L
.04754 .14103 L
.04869 .14105 L
.04996 .14106 L
.05112 .14106 L
.0522 .14107 L
.05352 .14106 L
.05478 .14106 L
.0559 .14105 L
.05713 .14103 L
.05847 .14101 L
.05989 .14098 L
.06244 .1409 L
.06529 .1408 L
.06791 .14068 L
.07382 .14031 L
.07904 .13989 L
.08454 .13933 L
.0941 .13809 L
.10458 .13634 L
.12409 .1321 L
.145 .12649 L
.16482 .1208 L
.17526 .11793 L
.18637 .1152 L
.1962 .11319 L
.20143 .11233 L
.20706 .11158 L
.20957 .11132 L
.21221 .11109 L
.21447 .11094 L
.21576 .11087 L
.21694 .11082 L
.21813 .11077 L
.21926 .11074 L
.22045 .11073 L
.22174 .11072 L
.22287 .11073 L
.22407 .11074 L
.22509 .11077 L
.22621 .11081 L
.2275 .11087 L
.2287 .11094 L
.23142 .11114 L
Mistroke
.23382 .11139 L
.23637 .11171 L
.24125 .1125 L
.24566 .11344 L
.25642 .11661 L
.26655 .12079 L
.28667 .1326 L
.30515 .14729 L
.34469 .18751 L
.38272 .22737 L
.40227 .24337 L
.40789 .24699 L
.41322 .24994 L
.41796 .25214 L
.42319 .25408 L
.4256 .25479 L
.42819 .25543 L
.43063 .2559 L
.43287 .25622 L
.43411 .25636 L
.43527 .25645 L
.43653 .25652 L
.43724 .25655 L
.43788 .25656 L
.43918 .25656 L
.43991 .25654 L
.44059 .25651 L
.44183 .25644 L
.44314 .25632 L
.44429 .25618 L
.44533 .25604 L
.44768 .25561 L
.45193 .25453 L
.45688 .25274 L
.46158 .25052 L
.47121 .24439 L
.48146 .23561 L
.49987 .21443 L
.53759 .15569 L
.55854 .12029 L
.57776 .09087 L
.58751 .07828 L
.59658 .0685 L
.60605 .06067 L
.61106 .05762 L
.61366 .05636 L
.61642 .05527 L
.61895 .0545 L
.62039 .05417 L
.62174 .05392 L
Mistroke
.62297 .05375 L
.6241 .05364 L
.6254 .05358 L
.62664 .05358 L
.62734 .0536 L
.62798 .05364 L
.62871 .0537 L
.6294 .05377 L
.63062 .05396 L
.63195 .05422 L
.63342 .05458 L
.63496 .05506 L
.63774 .05615 L
.64271 .05885 L
.64734 .06227 L
.65788 .07323 L
.66834 .08849 L
.67825 .10681 L
.69681 .15037 L
.73516 .26722 L
.75456 .33093 L
.77596 .39587 L
.78572 .42155 L
.79623 .44535 L
.80608 .46332 L
.81525 .47575 L
.81988 .48034 L
.82226 .48223 L
.82483 .48391 L
.8263 .4847 L
.82765 .48532 L
.82892 .48581 L
.83032 .48623 L
.83157 .48651 L
.83274 .48669 L
.83398 .48679 L
.83467 .4868 L
.8353 .48679 L
.83661 .48669 L
.83734 .48659 L
.83799 .48648 L
.83928 .48617 L
.84049 .48579 L
.8432 .48462 L
.84613 .48285 L
.85149 .47825 L
.85641 .47249 L
.86618 .45675 L
.87529 .43711 L
.89597 .37643 L
Mistroke
.93495 .22069 L
.97619 .05355 L
Mfstroke
0 1 0 r
.02381 .17885 m
.02846 .17915 L
.03279 .17939 L
.03793 .17962 L
.04262 .17977 L
.04498 .17983 L
.04622 .17985 L
.04754 .17987 L
.04869 .17989 L
.04996 .1799 L
.05112 .1799 L
.0522 .1799 L
.05352 .1799 L
.05478 .1799 L
.0559 .17988 L
.05713 .17987 L
.05847 .17985 L
.05989 .17982 L
.06244 .17974 L
.06529 .17964 L
.06791 .17952 L
.07382 .17915 L
.07904 .17873 L
.08454 .17817 L
.0941 .17693 L
.10458 .17518 L
.12409 .17094 L
.145 .16533 L
.16482 .15964 L
.17526 .15677 L
.18637 .15404 L
.1962 .15203 L
.20143 .15117 L
.20706 .15042 L
.20957 .15016 L
.21221 .14993 L
.21447 .14978 L
.21576 .14971 L
.21694 .14965 L
.21813 .14961 L
.21926 .14958 L
.22045 .14956 L
.22174 .14956 L
.22287 .14956 L
.22407 .14958 L
.22509 .14961 L
.22621 .14965 L
.2275 .14971 L
.2287 .14978 L
.23142 .14998 L
Mistroke
.23382 .15023 L
.23637 .15054 L
.24125 .15134 L
.24566 .15227 L
.25642 .15545 L
.26655 .15963 L
.28667 .17143 L
.30515 .18613 L
.34469 .22635 L
.38272 .26621 L
.40227 .28221 L
.40789 .28583 L
.41322 .28878 L
.41796 .29098 L
.42319 .29292 L
.4256 .29363 L
.42819 .29427 L
.43063 .29474 L
.43287 .29506 L
.43411 .2952 L
.43527 .29529 L
.43653 .29536 L
.43724 .29539 L
.43788 .2954 L
.43918 .2954 L
.43991 .29538 L
.44059 .29535 L
.44183 .29527 L
.44314 .29516 L
.44429 .29502 L
.44533 .29487 L
.44768 .29445 L
.45193 .29337 L
.45688 .29158 L
.46158 .28936 L
.47121 .28323 L
.48146 .27445 L
.49987 .25327 L
.53759 .19453 L
.55854 .15913 L
.57776 .12971 L
.58751 .11712 L
.59658 .10734 L
.60605 .0995 L
.61106 .09646 L
.61366 .0952 L
.61642 .09411 L
.61895 .09334 L
.62039 .09301 L
.62174 .09276 L
Mistroke
.62297 .09259 L
.6241 .09248 L
.6254 .09242 L
.62664 .09241 L
.62734 .09244 L
.62798 .09248 L
.62871 .09254 L
.6294 .09261 L
.63062 .09279 L
.63195 .09305 L
.63342 .09342 L
.63496 .0939 L
.63774 .09499 L
.64271 .09769 L
.64734 .10111 L
.65788 .11207 L
.66834 .12733 L
.67825 .14565 L
.69681 .1892 L
.73516 .30606 L
.75456 .36976 L
.77596 .43471 L
.78572 .46039 L
.79623 .48418 L
.80608 .50216 L
.81525 .51459 L
.81988 .51918 L
.82226 .52106 L
.82483 .52275 L
.8263 .52354 L
.82765 .52416 L
.82892 .52465 L
.83032 .52507 L
.83157 .52535 L
.83274 .52553 L
.83398 .52563 L
.83467 .52564 L
.8353 .52563 L
.83661 .52553 L
.83734 .52543 L
.83799 .52531 L
.83928 .52501 L
.84049 .52463 L
.8432 .52346 L
.84613 .52168 L
.85149 .51709 L
.85641 .51133 L
.86618 .49559 L
.87529 .47595 L
.89597 .41527 L
Mistroke
.93495 .25952 L
.97619 .09239 L
Mfstroke
1 .5 .5 r
.02381 .21769 m
.02846 .21799 L
.03279 .21823 L
.03793 .21846 L
.04262 .21861 L
.04498 .21867 L
.04622 .21869 L
.04754 .21871 L
.04869 .21872 L
.04996 .21874 L
.05112 .21874 L
.0522 .21874 L
.05352 .21874 L
.05478 .21873 L
.0559 .21872 L
.05713 .21871 L
.05847 .21868 L
.05989 .21865 L
.06244 .21858 L
.06529 .21848 L
.06791 .21835 L
.07382 .21799 L
.07904 .21756 L
.08454 .21701 L
.0941 .21577 L
.10458 .21402 L
.12409 .20978 L
.145 .20417 L
.16482 .19847 L
.17526 .19561 L
.18637 .19288 L
.1962 .19087 L
.20143 .19 L
.20706 .18926 L
.20957 .189 L
.21221 .18877 L
.21447 .18862 L
.21576 .18855 L
.21694 .18849 L
.21813 .18845 L
.21926 .18842 L
.22045 .1884 L
.22174 .1884 L
.22287 .1884 L
.22407 .18842 L
.22509 .18845 L
.22621 .18849 L
.2275 .18855 L
.2287 .18862 L
.23142 .18882 L
Mistroke
.23382 .18906 L
.23637 .18938 L
.24125 .19018 L
.24566 .19111 L
.25642 .19429 L
.26655 .19847 L
.28667 .21027 L
.30515 .22497 L
.34469 .26519 L
.38272 .30505 L
.40227 .32105 L
.40789 .32467 L
.41322 .32762 L
.41796 .32982 L
.42319 .33176 L
.4256 .33247 L
.42819 .33311 L
.43063 .33358 L
.43287 .3339 L
.43411 .33404 L
.43527 .33413 L
.43653 .3342 L
.43724 .33422 L
.43788 .33424 L
.43918 .33423 L
.43991 .33422 L
.44059 .33419 L
.44183 .33411 L
.44314 .334 L
.44429 .33386 L
.44533 .33371 L
.44768 .33329 L
.45193 .3322 L
.45688 .33042 L
.46158 .3282 L
.47121 .32207 L
.48146 .31329 L
.49987 .29211 L
.53759 .23337 L
.55854 .19797 L
.57776 .16855 L
.58751 .15596 L
.59658 .14618 L
.60605 .13834 L
.61106 .1353 L
.61366 .13404 L
.61642 .13295 L
.61895 .13218 L
.62039 .13184 L
.62174 .1316 L
Mistroke
.62297 .13143 L
.6241 .13132 L
.6254 .13126 L
.62664 .13125 L
.62734 .13128 L
.62798 .13131 L
.62871 .13138 L
.6294 .13145 L
.63062 .13163 L
.63195 .13189 L
.63342 .13226 L
.63496 .13274 L
.63774 .13382 L
.64271 .13653 L
.64734 .13995 L
.65788 .15091 L
.66834 .16617 L
.67825 .18449 L
.69681 .22804 L
.73516 .3449 L
.75456 .4086 L
.77596 .47354 L
.78572 .49923 L
.79623 .52302 L
.80608 .541 L
.81525 .55343 L
.81988 .55801 L
.82226 .5599 L
.82483 .56159 L
.8263 .56238 L
.82765 .563 L
.82892 .56348 L
.83032 .56391 L
.83157 .56419 L
.83274 .56436 L
.83398 .56446 L
.83467 .56448 L
.8353 .56447 L
.83661 .56437 L
.83734 .56427 L
.83799 .56415 L
.83928 .56385 L
.84049 .56347 L
.8432 .5623 L
.84613 .56052 L
.85149 .55593 L
.85641 .55017 L
.86618 .53443 L
.87529 .51479 L
.89597 .45411 L
Mistroke
.93495 .29836 L
.97619 .13123 L
Mfstroke
1 0 0 r
.02381 .25653 m
.02846 .25683 L
.03279 .25706 L
.03793 .25729 L
.04262 .25745 L
.04498 .25751 L
.04622 .25753 L
.04754 .25755 L
.04869 .25756 L
.04996 .25757 L
.05112 .25758 L
.0522 .25758 L
.05352 .25758 L
.05478 .25757 L
.0559 .25756 L
.05713 .25755 L
.05847 .25752 L
.05989 .25749 L
.06244 .25742 L
.06529 .25732 L
.06791 .25719 L
.07382 .25683 L
.07904 .2564 L
.08454 .25584 L
.0941 .25461 L
.10458 .25286 L
.12409 .24862 L
.145 .24301 L
.16482 .23731 L
.17526 .23445 L
.18637 .23172 L
.1962 .22971 L
.20143 .22884 L
.20706 .2281 L
.20957 .22784 L
.21221 .22761 L
.21447 .22745 L
.21576 .22738 L
.21694 .22733 L
.21813 .22729 L
.21926 .22726 L
.22045 .22724 L
.22174 .22724 L
.22287 .22724 L
.22407 .22726 L
.22509 .22729 L
.22621 .22733 L
.2275 .22739 L
.2287 .22745 L
.23142 .22766 L
Mistroke
.23382 .2279 L
.23637 .22822 L
.24125 .22902 L
.24566 .22995 L
.25642 .23313 L
.26655 .23731 L
.28667 .24911 L
.30515 .26381 L
.34469 .30403 L
.38272 .34389 L
.40227 .35989 L
.40789 .36351 L
.41322 .36646 L
.41796 .36866 L
.42319 .3706 L
.4256 .37131 L
.42819 .37194 L
.43063 .37242 L
.43287 .37274 L
.43411 .37287 L
.43527 .37297 L
.43653 .37304 L
.43724 .37306 L
.43788 .37308 L
.43918 .37307 L
.43991 .37306 L
.44059 .37303 L
.44183 .37295 L
.44314 .37283 L
.44429 .3727 L
.44533 .37255 L
.44768 .37213 L
.45193 .37104 L
.45688 .36925 L
.46158 .36704 L
.47121 .36091 L
.48146 .35212 L
.49987 .33095 L
.53759 .27221 L
.55854 .23681 L
.57776 .20739 L
.58751 .1948 L
.59658 .18502 L
.60605 .17718 L
.61106 .17414 L
.61366 .17288 L
.61642 .17179 L
.61895 .17102 L
.62039 .17068 L
.62174 .17044 L
Mistroke
.62297 .17027 L
.6241 .17016 L
.6254 .1701 L
.62664 .17009 L
.62734 .17012 L
.62798 .17015 L
.62871 .17021 L
.6294 .17029 L
.63062 .17047 L
.63195 .17073 L
.63342 .1711 L
.63496 .17158 L
.63774 .17266 L
.64271 .17537 L
.64734 .17878 L
.65788 .18975 L
.66834 .20501 L
.67825 .22332 L
.69681 .26688 L
.73516 .38373 L
.75456 .44744 L
.77596 .51238 L
.78572 .53806 L
.79623 .56186 L
.80608 .57983 L
.81525 .59227 L
.81988 .59685 L
.82226 .59874 L
.82483 .60043 L
.8263 .60122 L
.82765 .60184 L
.82892 .60232 L
.83032 .60275 L
.83157 .60303 L
.83274 .6032 L
.83398 .6033 L
.83467 .60332 L
.8353 .60331 L
.83661 .60321 L
.83734 .60311 L
.83799 .60299 L
.83928 .60269 L
.84049 .60231 L
.8432 .60113 L
.84613 .59936 L
.85149 .59477 L
.85641 .58901 L
.86618 .57327 L
.87529 .55363 L
.89597 .49295 L
Mistroke
.93495 .3372 L
.97619 .17007 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003o6`3oool0
0`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0
oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool200000?l0oooo103oool001/0oooo00<0
00000?ooo`3oool0U@3oool40?l00640oooo00<0o`000?ooo`3oool01@3oool001/0oooo00<00000
0?ooo`3oool0T`3oool30?l00080oooo0`3o001O0?ooo`030?l0003oool0oooo00D0oooo000K0?oo
o`030000003oool0oooo0940oooo0P3o00080?ooo`030?l0003oool0oooo05/0oooo00<0o`000?oo
o`3oool01P3oool001/0oooo00<000000?ooo`3oool0T03oool00`3o0000oooo0?ooo`090?ooo`03
0?l0003oool0oooo05X0oooo00<0o`000?ooo`3oool01P3oool001/0oooo00<000000?ooo`3oool0
S`3oool00`3o0000oooo0?ooo`0;0?ooo`030?l0003oool0oooo05T0oooo00<0o`000?ooo`3oool0
1P3oool001/0oooo0P00002?0?ooo`030?l0003oool0oooo00d0oooo00<0o`000?ooo`3oool0F03o
ool00`3o0000oooo0?ooo`060?ooo`006`3oool00`000000oooo0?ooo`2<0?ooo`80o`004@3oool0
0`3o0000oooo0?ooo`1F0?ooo`030?l0003oool0oooo00L0oooo000K0?ooo`030000003oool0oooo
08/0oooo00<0o`000?ooo`3oool04P3oool00`3o0000oooo0?ooo`1E0?ooo`030?l0003oool0oooo
00L0oooo000K0?ooo`030000003oool0oooo08X0oooo00<0o`000?ooo`3oool04`3oool00`3o0000
oooo0?ooo`1E0?ooo`030?l0003oool0oooo00L0oooo000K0?ooo`030000003oool0oooo08T0oooo
00<0o`000?ooo`3oool05@3oool00`3o0000oooo0?ooo`1D0?ooo`030?l0003oool0oooo00L0oooo
000K0?ooo`800000RP3oool00`3o0000oooo0?ooo`0F0?ooo`030?l0003oool0oooo0580oooo00<0
o`000?ooo`3oool0203oool001/0oooo00<000000?ooo`3oool0R03oool00`3o0000oooo0?ooo`0:
0?ooo`<0003o2P3oool00`3o0000oooo0?ooo`1B0?ooo`040?l0003oool0oooo0000o`L0oooo000K
0?ooo`030000003oool0oooo08L0oooo00<0o`000?ooo`3oool02@3oool30000o`80oooo0`000?l8
0?ooo`030?l0003oool0oooo0540oooo00@0o`000?ooo`3oool0003o1`3oool001/0oooo00<00000
0?ooo`3oool0Q`3oool00`3o0000oooo0?ooo`070?ooo`80003o203oool00`000?l0oooo0?ooo`05
0?ooo`030?l0003oool0oooo0540oooo00<0o`000?ooo`000?l0203oool000L0oooo1@0000020?oo
o`800000103oool2000000D0oooo00<000000?ooo`3oool0QP3oool00`3o0000oooo0?ooo`070?oo
o`030000o`3oool0oooo00T0oooo00<0003o0?ooo`3oool01@3oool00`3o0000oooo0?ooo`1?0?oo
o`040?l0003oool0oooo0000o`P0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0Q@3o
ool00`3o0000oooo0?ooo`070?ooo`030000o`3oool0oooo00/0oooo00<0003o0?ooo`3oool0103o
ool00`3o0000oooo0?ooo`1?0?ooo`040?l0003oool0oooo0000o`P0oooo00090?ooo`050000003o
ool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080
oooo0`0000250?ooo`030?l0003oool0oooo00H0oooo00<0003o0?ooo`3oool03@3oool00`000?l0
oooo0?ooo`040?ooo`030?l0003oool0oooo04h0oooo00@0o`000?ooo`3oool0003o203oool00003
0?ooo`000000000000800000103oool01@000000oooo0?ooo`3oool000000080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01/0oooo4@3o001H
0?ooo`030?l0003oool0oooo00D0oooo0P000?lA0?ooo`030000o`3oool0oooo00<0oooo00<0o`00
0?ooo`3oool0CP3oool00`3o0000oooo0000o`090?ooo`002@3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo01P0oooo0`3o000A0?ooo`<0o`00E@3oool00`3o0000oooo0?ooo`040?ooo`030000o`3o
ool0oooo0180oooo00<0003o0?ooo`3oool00`3oool00`3o0000oooo0?ooo`1<0?ooo`040?l0003o
ool0oooo0000o`T0oooo00080?ooo`800000103oool2000000@0oooo0P0000050?ooo`030000003o
ool0oooo0180oooo1P3o000G0?ooo`80o`00DP3oool00`3o0000oooo0?ooo`040?ooo`030000o`3o
ool0oooo01<0oooo00<0003o0?ooo`3oool00`3oool00`3o0000oooo0?ooo`1<0?ooo`040?l0003o
ool0oooo0000o`T0oooo000K0?ooo`030000003oool0oooo00l0oooo0`3o000O0?ooo`80o`00C`3o
ool00`3o0000oooo0?ooo`040?ooo`030000o`3oool0oooo01D0oooo00<0003o0?ooo`3oool00`3o
ool00`3o0000oooo0?ooo`1;0?ooo`040?l0003oool0oooo0000o`T0oooo000K0?ooo`8000003@3o
ool30?l002@0oooo00<0o`000?ooo`3oool0C03oool00`3o0000oooo0?ooo`040?ooo`030000o`3o
ool0oooo01H0oooo00<0003o0?ooo`3oool00P3oool00`3o0000oooo0?ooo`1;0?ooo`030?l0003o
ool0003o00X0oooo000K0?ooo`030000003oool0oooo00X0oooo0P3o000X0?ooo`80o`00B`3oool0
0`3o0000oooo0?ooo`040?ooo`030000o`3oool0oooo00/0oooo0P00o`0:0?ooo`030000o`3oool0
oooo0080oooo00<0o`000?ooo`3oool0BP3oool0103o0000oooo0?ooo`000?l20?ooo`03003o003o
ool0oooo00D0oooo000K0?ooo`030000003oool0oooo00H0oooo103o000/0?ooo`030?l0003oool0
oooo04P0oooo00<0o`000?ooo`3oool00`3oool00`000?l0oooo0?ooo`090?ooo`<00?l000<0oooo
003o0000o`000P00o`080?ooo`030000o`3oool0oooo0080oooo00<0o`000?ooo`3oool0B@3oool0
103o0000oooo0?ooo`000?l20?ooo`03003o003oool0oooo00D0oooo000K0?ooo`030000003o0000
o`0000H0o`00<@3oool00`3o0000oooo0?ooo`160?ooo`030?l0003oool0oooo00@0oooo00<0003o
0?ooo`3oool01`3oool2003o00P0oooo00<00?l00?ooo`3oool01@3oool00`000?l0oooo0?ooo`02
0?ooo`030?l0003oool0oooo04T0oooo00H0o`000?ooo`3oool0003o0?ooo`00o`080?ooo`002@3o
oolC0?l003X0oooo0P3o00150?ooo`030?l0003oool0oooo00@0oooo00<0003o0?ooo`3oool01`3o
ool00`00o`00oooo0?ooo`090?ooo`03003o003oool0oooo00D0oooo00<0003o0?ooo`3oool00P3o
ool00`3o0000oooo0?ooo`180?ooo`030?l0003oool0003o0080oooo00<00?l00?ooo`3oool01P3o
ool001/0oooo00<000000?ooo`3oool0>P3oool00`3o0000oooo0?ooo`120?ooo`030?l0003oool0
oooo00<0oooo00<0003o0?ooo`3oool01`3oool00`00o`00oooo0?ooo`0;0?ooo`03003o003oool0
oooo00@0oooo00<0003o0?ooo`3oool00P3oool00`3o0000oooo0?ooo`170?ooo`040?l0003oool0
oooo0000o`80oooo00<00?l00?ooo`3oool01P3oool001/0oooo0P00000l0?ooo`030?l0003oool0
oooo0400oooo00<0o`000?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`03003o003oool0
oooo00d0oooo00<00?l00?ooo`3oool0103oool00`000?l0oooo0?ooo`020?ooo`030?l0003oool0
oooo04H0oooo00@0o`000?ooo`3oool0003o0P3oool00`00o`00oooo0?ooo`060?ooo`006`3oool0
0`000000oooo0?ooo`0K0?oooa40003o403oool00`3o0000oooo0?ooo`0o0?ooo`030?l0003oool0
oooo00<0oooo00<0003o0?ooo`3oool01@3oool2003o0140oooo00<00?l00?ooo`3oool00`3oool0
0`000?l0oooo0?ooo`020?ooo`030?l0003oool0oooo04H0oooo00H0o`000?ooo`3oool0003o0?oo
o`00o`090?ooo`006`3oool00`000000oooo0?ooo`0H0?ooo`<0003o4@3oool20000o`l0oooo00<0
o`000?ooo`3oool0?@3oool00`3o0000oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
0?l00?ooo`3oool04P3oool00`00o`00oooo0?ooo`030?ooo`050000o`3oool0oooo0?ooo`3o0000
B03oool00`3o0000oooo0000o`020?ooo`03003o003oool0oooo00L0oooo000K0?ooo`030000003o
ool0oooo01D0oooo0`000?lF0?ooo`80003o3P3oool00`3o0000oooo0?ooo`0k0?ooo`030?l0003o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00o`00oooo0?ooo`0C0?ooo`03003o003o
ool0oooo00<0oooo00<0003o0?ooo`3oool00P3oool00`3o0000oooo0?ooo`140?ooo`040?l0003o
ool0oooo0000o`80oooo00<00?l00?ooo`3oool01`3oool001/0oooo00<000000?ooo`3oool04@3o
ool40000oa/0oooo00<0003o0?ooo`3oool0303oool00`3o0000oooo0?ooo`0j0?ooo`030?l0003o
ool0oooo00<0oooo00<0003o0?ooo`3oool0103oool00`00o`00oooo0?ooo`0E0?ooo`03003o003o
ool0oooo00<0oooo00D0003o0?ooo`3oool0oooo0?l000160?ooo`040?l0003oool0oooo0000o`80
oooo00<00?l00?ooo`3oool01`3oool001/0oooo0P00000=0?ooo`D0003o3P3oool3000000l0oooo
0P000?l=0?ooo`040?l0003oool0oooo0?ooo`8000007P3oool500000080oooo0P00000>0?ooo`03
0?l0003oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool00`0000000?l00000000200000003
0?ooo`000000000000800000403oool00`00o`00oooo0?ooo`020?ooo`060000o`3oool0oooo0?oo
o`3o0000oooo1@0000030?ooo`<000006@3oool5000000040?ooo`0000000000000001P0oooo00H0
o`000?ooo`3oool0003o00000000o`0200000080oooo0P0000040?ooo`006`3oool00`000000oooo
0?ooo`0:0?ooo`80003o4`3oool010000000oooo0?ooo`00000@0?ooo`80003o303oool00`3o0000
oooo000000020?ooo`030000003oool0oooo01d0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00X0oooo00<0o`000?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`03003o003oool0000000<0oooo00<000000?ooo`3oool01@3oool00`3oOgl0oooo0?ooo`090?oo
o`03003o003oool0oooo0080oooo00<0003o0?ooo`3oool00P3oool0103o0000oooo0?ooo`000006
0?ooo`030000003oool0oooo01X0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo01D0oooo00<0o`000?ooo`000?l00P3oool01@00o`00oooo0?ooo`3oOgl000000080oooo
00<000000?ooo`3oool00@3oool001/0oooo00<000000?ooo`3oool01P3oool40000oaD0oooo00@0
00000?ooo`3oool000004P3oool20000o`/0oooo00D0o`000000003oool0oooo0000000O0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0:0?ooo`030?l0003oool0oooo
00@0oooo00<0003o0?ooo`3oool00`3oool01000o`00oooo0?ooo`0000040?ooo`040000003oool0
oooo0?ooo`P0ogmo203oool00`00o`00oooo0?ooo`020?ooo`050000o`3oool0oooo0?ooo`3o0000
0P3oool010000000oooo0?ooo`3oool5000001/0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo01@0oooo00@0o`000?ooo`3oool0003o0P3oool01@00o`00oooo0?ooo`3o
Ogl000000080oooo00<000000?ooo`3oool00@3oool001/0oooo00<000000000o`000?l01P000?lI
0?ooo`<000005@3oool00`000?l0oooo0?ooo`090?ooo`030?l00000000000000200oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00T0oooo00<0o`000?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`04003o003oool0oooo000000D0oooo00<000000?ooo`3oOgl0
203oool00`3oOgl0oooo0?ooo`050?ooo`03003o003oool0oooo0080oooo00D0003o0?ooo`3oool0
oooo0?l000020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0J0?oo
o`040000003oool0oooo0?ooo`<000005`3oool0103o0000oooo0?ooo`000?l20?ooo`03003o003o
ool0ogmo0080oooo0P0000040?ooo`002@3ooolC0000ob80oooo00<000000?ooo`3oool05@3oool2
0000o`T0oooo00@000000?l0003oool000007`3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0203oool00`3o0000oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo
00D00?l00?ooo`3oool0oooo000000030?ooo`040000003oool0oooo0?moO`X0oooo00<0ogmo0?oo
o`3oool01@3oool00`00o`00oooo0?ooo`020?ooo`070000o`3oool0oooo0?ooo`3o0000oooo0000
00040?ooo`030000003oool0000001`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0F0?ooo`0;0?l0003oool0oooo0000o`3oool00?l00000003oool0ogmo0?ooo`0000000P3oool0
0`000000oooo0?ooo`010?ooo`006`3oool00`000000oooo0?ooo`0P0?ooo`<000005`3oool00`00
0?l0oooo0?ooo`070?ooo`030000003o0000oooo01h0oooo0P0000040?ooo`8000002`3oool00`3o
0000oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@00?l00?ooo`3oool0oooo0P000004
0?ooo`80ogmo303oool00`3oOgl0oooo0?ooo`040?ooo`03003o003oool0oooo0080oooo00D0003o
0?ooo`3oool0oooo0?l00002000000D0oooo0P00000K0?ooo`800000103oool3000001H0oooo00<0
o`000?ooo`000?l00P3oool01000o`0000000?ooo`3oOgl20?ooo`800000103oool001/0oooo0P00
000l0?ooo`030000o`3oool0oooo00P0oooo00<0o`000?ooo`3oool0;P3oool00`3o0000oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<00?l00?ooo`3oool01P3oool00`3oOgl0oooo0?oo
o`0=0?ooo`030?moO`3oool0oooo00@0oooo00<00?l00?ooo`3oool00P3oool010000?l0oooo0?oo
o`3o00120?ooo`040?l0003oool0oooo0000o`80oooo00@00?l00?ooo`3oool0ogmo203oool001/0
oooo00<000000?ooo`3oool06`3ooolA003o0100oooo00<0003o0?ooo`3oool0203oool00`3o0000
oooo0?ooo`0]0?ooo`030?l0003oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool00`00o`00
oooo0?ooo`060?ooo`030?moO`3oool0oooo00l0oooo00<0ogmo0?ooo`3oool00`3oool00`00o`00
oooo0?ooo`020?ooo`050000o`3oool0oooo0?ooo`3o0000@@3oool0103o0000oooo0?ooo`000?l2
0?ooo`03003o003oool0ogmo00T0oooo000K0?ooo`030000003oool0oooo01P0oooo0`00o`0A0?oo
o`800?l03`3oool00`000?l0oooo0?ooo`080?ooo`030?l0003oool0oooo02/0oooo00<0o`000?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03003o003oool0oooo00D0oooo00<0ogmo0?oo
o`3oool04@3oool00`3oOgl0oooo0?ooo`030?ooo`05003o003oool0oooo0?ooo`000?l00`3oool0
0`3o0000oooo0?ooo`0o0?ooo`060?l0003oool0oooo0000o`3oool00?l00P3oool00`3oOgl0oooo
0?ooo`070?ooo`006`3oool00`000000oooo0?ooo`0E0?ooo`<00?l05P3oool2003o00h0oooo00<0
003o0?ooo`3oool0203oool00`3o0000oooo0?ooo`0Y0?ooo`030?l0003oool0oooo00@0oooo00<0
003o0?ooo`3oool0103oool00`00o`00oooo0?ooo`050?ooo`030?moO`3oool0oooo0180oooo00<0
ogmo0?ooo`3oool00`3oool00`00o`00oooo0?ooo`020?ooo`040000o`3oool0oooo0?l00440oooo
00<0o`000?ooo`000?l00P3oool01000o`00oooo0?ooo`3oOgl90?ooo`006`3oool00`000000oooo
0?ooo`0A0?ooo`@00?l06`3oool00`00o`00oooo0?ooo`0<0?ooo`030000o`3oool0oooo00P0oooo
00<0o`000?ooo`3oool0:03oool00`3o0000oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00<00?l00?ooo`3oool01@3oool00`3oOgl0oooo0?ooo`0D0?ooo`030?moO`3oool0oooo00<0oooo
00D00?l00?ooo`3oool0oooo0000o`030?ooo`030?l0003oool0oooo03d0oooo00@0o`000?ooo`3o
ool0003o0P3oool01000o`00oooo0?ooo`3oOgl90?ooo`000P3ooolX000000D00?l080000002003o
00d0000000<0003o000000000000200000000`3o000000000000000V000000030?l0000000000000
00@0000000<0003o000000000000100000000`00o`00000000000004000000030?moO`0000000000
01H0000000<0ogmo0000000000000P0000001@00o`000000000000000000003o00<0000000<0o`00
000000000000?@000000103o00000000000000000?l200000003003o00000000ogmo00X000000009
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`06
0?ooo`040000003oool0oooo0?ooo`800?l00`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`800?l01`3o
ool00`000000oooo0?ooo`020?ooo`050000o`3oool0oooo0?ooo`0000001@3oool0103o0000oooo
0?ooo`0000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`060?ooo`030000003o0000oooo00D0oooo00<0003o0000003oool0103oool01000o`00
oooo0?ooo`0000030?ooo`030?moO`3oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`060?ooo`040000003oool0oooo0?moO`@0oooo00<00?l00?ooo`0000000P3oool0
10000?l0oooo0?ooo`3o00020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00H0o`000?ooo`000000003o
0?ooo`00o`020?ooo`040?moO`3oool0oooo000000L0oooo000K0?ooo`030000003oool0oooo00H0
oooo1000o`0G0?ooo`030000003oool0oooo0140oooo0P00o`0;0?ooo`040000o`3oool0oooo0000
00H0oooo00<0o`000?ooo`3oool06P3oool00`000000oooo0?ooo`070?ooo`030?l0003oool0oooo
00@0oooo00<0003o0?ooo`3oool0103oool00`00o`00oooo0?ooo`030?ooo`030?moO`3oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool80?l000P0oooo00<0ogmo0?ooo`3oool00P3oool01@00
o`00oooo0?ooo`3oool0003o00<0oooo00<0o`000?ooo`0000008`3oool00`000000oooo0?ooo`0F
0?ooo`030?l0003oool0003o0080oooo00@00?l00?ooo`3oool0ogmo0P3oool00`3o0000oooo0?oo
o`050?ooo`006`3oool00`0000000?l0003o0006003o0340oooo00<00?l00?ooo`3oool02@3oool0
0`000?l0oooo0?ooo`070?ooo`030?l0003oool0oooo0280oooo00<0o`000?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`03003o003oool0oooo00@0oooo00<0ogmo0?ooo`3oool0203oool0
0`3o0000oooo0?ooo`060?ooo`030?l0003oool0oooo00D0oooo00<0ogmo0?ooo`3oool00P3oool0
1@00o`00oooo0?ooo`3oool0003o00<0oooo00<0o`000?ooo`3oool0>`3oool0103o0000oooo0?oo
o`000?l20?ooo`04003o003oool0oooo0?moO`80oooo00<0o`000?ooo`3oool01@3oool000T0oooo
4`00o`0j0?ooo`800?l02P3oool00`000?l0oooo0?ooo`070?ooo`030?l0003oool0oooo0200oooo
00<0o`000?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03003o003oool0oooo00@0oooo
00<0ogmo0?ooo`3oool0203oool00`3o0000oooo0?ooo`080?ooo`030?l0003oool0oooo00D0oooo
00<0ogmo0?ooo`3oool00P3oool01@00o`00oooo0?ooo`3oool0003o0080oooo00<0o`000?ooo`3o
ool0>`3oool0103o0000oooo0?ooo`000?l20?ooo`03003o003oool0ogmo0080oooo00<0o`000?oo
o`3oool01P3oool001/0oooo00<000000?ooo`3oool0>P3oool00`00o`00oooo0?ooo`080?ooo`03
0000o`3oool0oooo00L0oooo00<0o`000?ooo`3oool07P3oool00`3o0000oooo0?ooo`050?ooo`03
0000o`3oool0oooo00@0oooo00<00?l00?ooo`3oool00`3oool00`3oOgl0oooo0?ooo`070?ooo`80
o`00303oool00`3o0000oooo0?ooo`040?ooo`030?moO`3oool0oooo0080oooo00D00?l00?ooo`3o
ool0oooo0000o`030?ooo`030?l0003oool0oooo03X0oooo00H0o`000?ooo`3oool0003o0?ooo`00
o`020?ooo`040?moO`3oool0oooo0?l000P0oooo000K0?ooo`800000?03oool00`00o`00oooo0?oo
o`080?ooo`030000o`3oool0oooo00L0oooo00<0o`000?ooo`3oool0703oool00`3o0000oooo0?oo
o`050?ooo`030000o`3oool0oooo00@0oooo00<00?l00?ooo`3oool0103oool00`3oOgl0oooo0?oo
o`060?ooo`030?l0003oool0oooo00d0oooo00<0o`000?ooo`3oool0103oool00`3oOgl0oooo0?oo
o`020?ooo`04003o003oool0oooo0000o`<0oooo00<0o`000?ooo`3oool0>P3oool00`3o0000oooo
0000o`020?ooo`04003o003oool0oooo0?moO`80oooo00<0o`000?ooo`3oool01P3oool001/0oooo
00<000000?ooo`3oool06`3oool?0?moOa80oooo00<00?l00?ooo`3oool0203oool00`000?l0oooo
0?ooo`070?ooo`030?l0003oool0oooo01/0oooo00<0o`000?ooo`3oool01@3oool00`000?l0oooo
0?ooo`040?ooo`03003o003oool0oooo00<0oooo00<0ogmo0?ooo`3oool01P3oool00`3o0000oooo
0?ooo`0?0?ooo`030?l0003oool0oooo00<0oooo00<0ogmo0?ooo`3oool00P3oool01@00o`00oooo
0?ooo`3oool0003o0080oooo00<0o`000?ooo`3oool0>@3oool0103o0000oooo0?ooo`000?l20?oo
o`04003o003oool0oooo0?moO`80oooo00<0o`000?ooo`3oool01P3oool001/0oooo00<000000?oo
o`3oool0603oool30?moO`l0oooo103oOgl?0?ooo`03003o003oool0oooo00P0oooo00<0003o0?oo
o`3oool01`3oool20?l001X0oooo00<0o`000?ooo`3oool01@3oool00`000?l0oooo0?ooo`040?oo
o`03003o003oool0oooo00@0oooo00<0ogmo0?ooo`3oool01@3oool00`3o0000oooo0?ooo`0A0?oo
o`030?l0003oool0oooo00<0oooo00D0ogmo0?ooo`3oool0oooo003o00030?ooo`050000o`3oool0
oooo0?ooo`3o0000>P3oool0103o0000oooo0?ooo`000?l20?ooo`03003o003oool0ogmo0080oooo
00<0o`000?ooo`3oool01`3oool001/0oooo00<000000?ooo`3oool05@3oool30?moOaH0oooo0P3o
Ogl>0?ooo`03003o003oool0oooo00P0oooo00<0003o0?ooo`3oool0203oool00`3o0000oooo0?oo
o`0F0?ooo`030?l0003oool0oooo00D0oooo00<0003o0?ooo`3oool0103oool00`00o`00oooo0?oo
o`040?ooo`030?moO`3oool0oooo00D0oooo00<0o`000?ooo`3oool04P3oool00`3o0000oooo0?oo
o`030?ooo`030?moO`3oool0oooo0080oooo00@00?l00?ooo`3oool0003o0`3oool00`3o0000oooo
0?ooo`0h0?ooo`060?l0003oool0oooo0000o`3oool00?l00P3oool0103oOgl0oooo0?ooo`3o0009
0?ooo`006`3oool00`000000oooo0?ooo`0A0?ooo`@0ogmo6`3oool00`3oOgl0oooo0?ooo`0<0?oo
o`03003o003oool0oooo00P0oooo00<0003o0?ooo`3oool0203oool20?l001D0oooo00<0o`000?oo
o`3oool01P3oool00`000?l0oooo0?ooo`040?ooo`03003o003oool0oooo00<0oooo00<0ogmo0?oo
o`3oool01@3oool00`3o0000oooo0?ooo`0D0?ooo`030?l0003oool0oooo00<0oooo00D0ogmo0?oo
o`3oool0oooo003o00030?ooo`040000o`3oool0oooo0?l003X0oooo00<0o`000?ooo`000?l00P3o
ool01000o`00oooo0?ooo`3oOgl20?ooo`030?l0003oool0oooo00L0oooo000K0?ooo`8000003@3o
ool50?moOb00oooo0P3oOgl=0?ooo`03003o003oool0oooo00P0oooo00<0003o0?ooo`3oool02@3o
ool00`3o0000oooo0?ooo`0A0?ooo`030?l0003oool0oooo00H0oooo00<0003o0?ooo`3oool0103o
ool00`00o`00oooo0?ooo`040?ooo`030?moO`3oool0oooo00@0oooo00<0o`000?ooo`3oool05P3o
ool00`3o0000oooo0?ooo`020?ooo`050?moO`3oool0oooo0?ooo`00o`000`3oool01@000?l0oooo
0?ooo`3oool0o`0003P0oooo00@0o`000?ooo`3oool0003o0P3oool01000o`00oooo0?ooo`3oOgl2
0?ooo`030?l0003oool0oooo00L0oooo000K0?ooo`030000003oool0oooo00X0oooo0P3oOglW0?oo
o`80ogmo2`3oool00`00o`00oooo0?ooo`080?ooo`030000o`3oool0oooo00X0oooo00<0o`000?oo
o`3oool03P3oool20?l000P0oooo00<0003o0?ooo`3oool0103oool00`00o`00oooo0?ooo`040?oo
o`030?moO`3oool0oooo00@0oooo00<0o`000?ooo`3oool05`3oool00`3o0000oooo0?ooo`020?oo
o`030?moO`3oool0oooo0080oooo00@00?l00?ooo`3oool0003o0`3oool00`3o0000oooo0?ooo`0f
0?ooo`040?l0003oool0oooo0000o`80oooo00<00?l00?ooo`3oOgl00P3oool00`3o0000oooo0?oo
o`080?ooo`006`3oool00`000000oooo0?ooo`060?ooo`@0ogmo:`3oool20?moO`X0oooo00<00?l0
0?ooo`3oool0203oool00`000?l0oooo0?ooo`0:0?ooo`80o`00303oool20?l000X0oooo00<0003o
0?ooo`3oool0103oool00`00o`00oooo0?ooo`040?ooo`030?moO`3oool0oooo00<0oooo00<0o`00
0?ooo`3oool06@3oool00`3o0000oooo0?ooo`020?ooo`050?moO`3oool0oooo0?ooo`00o`000`3o
ool010000?l0oooo0?ooo`3o000h0?ooo`060?l0003oool0oooo0000o`3oool00?l00P3oool0103o
Ogl0oooo0?ooo`3o000:0?ooo`006`3oool010000000oooo0?ooo`3oool50?moOc40oooo00<0ogmo
0?ooo`3oool0203oool00`00o`00oooo0?ooo`080?ooo`030000o`3oool0oooo00/0oooo0`3o0008
0?ooo`030?l0003oool0oooo00T0oooo00<0003o0?ooo`3oool0103oool00`00o`00oooo0?ooo`04
0?ooo`030?moO`3oool0oooo00@0oooo00<0o`000?ooo`3oool06@3oool00`3o0000oooo0?ooo`02
0?ooo`050?moO`3oool0oooo0?ooo`00o`000`3oool01@000?l0oooo0?ooo`3oool0o`0003L0oooo
00<0o`000?ooo`000?l00P3oool01000o`00oooo0?ooo`3oOgl20?ooo`030?l0003oool0oooo00P0
oooo00090?oooaH0ogmo=`3oool20?moO`T0oooo00<00?l00?ooo`3oool0203oool00`000?l0oooo
0?ooo`0<0?ooo`T0o`002`3oool00`000?l0oooo0?ooo`040?ooo`03003o003oool0oooo00D0oooo
00<0ogmo0?ooo`3oool00`3oool00`3o0000oooo0?ooo`0K0?ooo`030?l0003oool0oooo0080oooo
00D0ogmo0?ooo`3oool0oooo003o00020?ooo`050000o`3oool0oooo0?ooo`3o0000=P3oool0103o
0000oooo0?ooo`000?l20?ooo`04003o003oool0oooo0?moO`80oooo00<0o`000?ooo`3oool0203o
ool001/0oooo00<000000?ooo`3oool0>P3oool00`3oOgl0oooo0?ooo`070?ooo`03003o003oool0
oooo00P0oooo00<0003o0?ooo`3oool07P3oool00`000?l0oooo0?ooo`050?ooo`03003o003oool0
oooo00@0oooo00<0ogmo0?ooo`3oool0103oool00`3o0000oooo0?ooo`0K0?ooo`030?l0003oool0
oooo0080oooo00D0ogmo0?ooo`3oool0oooo003o00030?ooo`040000o`3oool0oooo0?l003H0oooo
00@0o`000?ooo`3oool0003o0P3oool00`00o`00oooo0?moO`020?ooo`030?l0003oool0oooo00T0
oooo000K0?ooo`800000?03oool00`3oOgl0oooo0?ooo`070?ooo`03003o003oool0oooo00P0oooo
00<0003o0?ooo`3oool0703oool00`000?l0oooo0?ooo`050?ooo`03003o003oool0oooo00D0oooo
00<0ogmo0?ooo`3oool00`3oool00`3o0000oooo0?ooo`0M0?ooo`030?l0003oool0oooo0080oooo
00@0ogmo0?ooo`3oool00?l00`3oool01@000?l0oooo0?ooo`3oool0o`0003D0oooo00H0o`000?oo
o`3oool0003o0?ooo`00o`020?ooo`040?moO`3oool0oooo0?l000/0oooo000K0?ooo`030000003o
ool0oooo01/0oooo3`3o000B0?ooo`030?moO`3oool0oooo00L0oooo00<00?l00?ooo`3oool0203o
ool00`000?l0oooo0?ooo`0K0?ooo`030000o`3oool0oooo00D0oooo00<00?l00?ooo`3oool0103o
ool00`3oOgl0oooo0?ooo`040?ooo`030?l0003oool0oooo01d0oooo00<0o`000?ooo`3oool00P3o
ool01@3oOgl0oooo0?ooo`3oool00?l00080oooo00D0003o0?ooo`3oool0oooo0?l0000e0?ooo`03
0?l0003oool0003o0080oooo00@00?l00?ooo`3oool0ogmo0P3oool00`3o0000oooo0?ooo`090?oo
o`006`3oool00`000000oooo0?ooo`0H0?ooo`<0o`003`3oool40?l000l0oooo00<0ogmo0?ooo`3o
ool01`3oool00`00o`00oooo0?ooo`080?ooo`80003o6P3oool00`000?l0oooo0?ooo`050?ooo`03
003o003oool0oooo00D0oooo00<0ogmo0?ooo`3oool00`3oool00`3o0000oooo0?ooo`0O0?ooo`05
0?l0003oool0oooo0?ooo`3oOgl00`3oool01@00o`00oooo0?ooo`3oool0003o0080oooo00<0o`00
0?ooo`3oool0<P3oool0103o0000oooo0?ooo`000?l20?ooo`04003o003oool0oooo0?moO`80oooo
00<0o`000?ooo`3oool02@3oool001/0oooo00<000000?ooo`3oool05@3oool30?l001H0oooo0P3o
000>0?ooo`030?moO`3oool0oooo00L0oooo00<00?l00?ooo`3oool02@3oool00`000?l0oooo0?oo
o`0F0?ooo`030000o`3oool0oooo00D0oooo00<00?l00?ooo`3oool01@3oool00`3oOgl0oooo0?oo
o`040?ooo`030?l0003oool0oooo01l0oooo00<0o`000?ooo`3oool00P3oool0103oOgl0oooo0?oo
o`00o`030?ooo`050000o`3oool0oooo0?ooo`3o0000<`3oool0103o0000oooo0?ooo`000?l20?oo
o`03003o003oool0ogmo0080oooo00<0o`000?ooo`3oool02P3oool001/0oooo00<000000?ooo`3o
ool04@3oool40?l001/0oooo00<0o`000?ooo`3oool0303oool00`3oOgl0oooo0?ooo`070?ooo`03
003o003oool0oooo00T0oooo0P000?lE0?ooo`030000o`3oool0oooo00H0oooo00<00?l00?ooo`3o
ool0103oool00`3oOgl0oooo0?ooo`040?ooo`030?l0003oool0oooo0240oooo00D0o`000?ooo`3o
ool0oooo0?moO`030?ooo`04003o003oool0oooo0000o`<0oooo00<0o`000?ooo`3oool0<@3oool0
1P3o0000oooo0?ooo`000?l0oooo003o0080oooo00@0ogmo0?ooo`3oool0o`00303oool001/0oooo
0P00000=0?ooo`D0o`00803oool20?l000d0oooo00<0ogmo0?ooo`3oool01`3oool00`00o`00oooo
0?ooo`0:0?ooo`030000o`3oool0oooo0140oooo00<0003o0?ooo`3oool01P3oool00`00o`00oooo
0?ooo`050?ooo`030?moO`3oool0oooo00<0oooo00<0o`000?ooo`3oool08P3oool01@3o0000oooo
0?ooo`3oool0ogmo00<0oooo00D00?l00?ooo`3oool0oooo0000o`020?ooo`030?l0003oool0oooo
0340oooo00<0o`000?ooo`000?l00P3oool01000o`00oooo0?ooo`3oOgl20?ooo`030?l0003oool0
oooo00X0oooo000K0?ooo`030000003oool0oooo00X0oooo0P3o000W0?ooo`80o`002`3oool00`3o
Ogl0oooo0?ooo`080?ooo`03003o003oool0oooo00X0oooo00<0003o0?ooo`3oool03P3oool20000
o`P0oooo00<00?l00?ooo`3oool01@3oool00`3oOgl0oooo0?ooo`040?ooo`030?l0003oool0oooo
0280oooo00<0o`000?ooo`3oool00P3oool0103oOgl0oooo0?ooo`00o`030?ooo`050000o`3oool0
oooo0?ooo`3o0000<@3oool0103o0000oooo0?ooo`000?l20?ooo`04003o003oool0oooo0?moO`80
oooo00<0o`000?ooo`3oool02P3oool001/0oooo00<000000?ooo`3oool01P3oool40?l002/0oooo
0P3o000:0?ooo`030?moO`3oool0oooo00P0oooo00<00?l00?ooo`3oool02P3oool20000o``0oooo
0P000?l:0?ooo`03003o003oool0oooo00@0oooo00<0ogmo0?ooo`3oool0103oool00`3o0000oooo
0?ooo`0T0?ooo`050?l0003oool0oooo0?ooo`3oOgl00`3oool01000o`00oooo0?ooo`000?l30?oo
o`030?l0003oool0oooo02l0oooo00@0o`000?ooo`3oool0003o0P3oool00`00o`00oooo0?moO`02
0?ooo`030?l0003oool0oooo00/0oooo000K0?ooo`040000003oool0oooo0?ooo`D0o`00<@3oool0
0`3o0000oooo0?ooo`080?ooo`030?moO`3oool0oooo00P0oooo00<00?l00?ooo`3oool02`3oool3
0000o`P0oooo00<0003o0?ooo`3oool02@3oool00`00o`00oooo0?ooo`050?ooo`030?moO`3oool0
oooo00@0oooo00<0o`000?ooo`3oool0903oool01@3o0000oooo0?ooo`3oool0ogmo00<0oooo00D0
0?l00?ooo`3oool0oooo0000o`020?ooo`030?l0003oool0oooo02l0oooo00H0o`000?ooo`3oool0
003o0?ooo`00o`020?ooo`040?moO`3oool0oooo0?l000d0oooo00070?ooo`8000005P3o000g0?oo
o`80o`002@3oool00`3oOgl0oooo0?ooo`080?ooo`03003o003oool0oooo00`0oooo2@000?l;0?oo
o`03003o003oool0oooo00D0oooo00<0ogmo0?ooo`3oool0103oool00`3o0000oooo0?ooo`0V0?oo
o`050?l0003oool0oooo0?ooo`3oOgl00P3oool01@00o`00oooo0?ooo`3oool0003o00<0oooo00<0
o`000?ooo`3oool0;P3oool00`3o0000oooo0000o`020?ooo`04003o003oool0oooo0?moO`80oooo
00<0o`000?ooo`3oool02`3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0j0?ooo`03
0?l0003oool0oooo00L0oooo00<0ogmo0?ooo`3oool0203oool00`00o`00oooo0?ooo`0N0?ooo`03
003o003oool0oooo00D0oooo00<0ogmo0?ooo`3oool0103oool00`3o0000oooo0?ooo`0W0?ooo`05
0?l0003oool0oooo0?ooo`3oOgl00`3oool01000o`00oooo0?ooo`000?l30?ooo`030?l0003oool0
oooo02d0oooo00@0o`000?ooo`3oool0003o0P3oool01000o`00oooo0?ooo`3oOgl20?ooo`030?l0
003oool0oooo00/0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo0080oooo0`00000k0?ooo`030?l0003oool0oooo00L0
oooo00<0ogmo0?ooo`3oool0203oool00`00o`00oooo0?ooo`0L0?ooo`03003o003oool0oooo00D0
oooo00<0ogmo0?ooo`3oool01@3oool00`3o0000oooo0?ooo`0X0?ooo`040?l0003oool0oooo0?mo
O`<0oooo00D00?l00?ooo`3oool0oooo0000o`020?ooo`030?l0003oool0oooo02d0oooo00@0o`00
0?ooo`3oool0003o0P3oool00`00o`00oooo0?moO`020?ooo`030?l0003oool0oooo00`0oooo0009
0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0?03oool00`3o0000oooo0?ooo`070?ooo`030?mo
O`3oool0oooo00P0oooo00<00?l00?ooo`3oool06`3oool00`00o`00oooo0?ooo`050?ooo`030?mo
O`3oool0oooo00@0oooo00<0o`000?ooo`3oool0:@3oool01@3o0000oooo0?ooo`3oool0ogmo0080
oooo00D00?l00?ooo`3oool0oooo0000o`030?ooo`030?l0003oool0oooo02`0oooo00H0o`000?oo
o`3oool0003o0?ooo`00o`020?ooo`040?moO`3oool0oooo0?l000h0oooo00090?ooo`050000003o
ool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0?@3oool00`3o0000oooo0?ooo`070?ooo`030?moO`3oool0oooo00P0
oooo0P00o`0J0?ooo`03003o003oool0oooo00D0oooo00<0ogmo0?ooo`3oool01@3oool00`3o0000
oooo0?ooo`0Y0?ooo`050?l0003oool0oooo0?ooo`3oOgl00`3oool01000o`00oooo0?ooo`000?l3
0?ooo`030?l0003oool0oooo02`0oooo00<0o`000?ooo`000?l00P3oool01000o`00oooo0?ooo`3o
Ogl20?ooo`030?l0003oool0oooo00`0oooo00080?ooo`800000103oool2000000@0oooo0P000005
0?ooo`030000003oool0oooo03h0oooo00<0o`000?ooo`3oool01`3oool00`3oOgl0oooo0?ooo`09
0?ooo`03003o003oool0oooo01H0oooo00<00?l00?ooo`3oool01@3oool00`3oOgl0oooo0?ooo`05
0?ooo`030?l0003oool0oooo02/0oooo00@0o`000?ooo`3oool0ogmo0`3oool01@00o`00oooo0?oo
o`3oool0003o0080oooo00<0o`000?ooo`3oool0:`3oool0103o0000oooo0?ooo`000?l20?ooo`04
003o003oool0oooo0?moO`80oooo00<0o`000?ooo`3oool0303oool001/0oooo00<000000?ooo`3o
ool0?`3oool00`3o0000oooo0?ooo`070?ooo`030?moO`3oool0oooo00T0oooo0P00o`0E0?ooo`03
003o003oool0oooo00H0oooo00<0ogmo0?ooo`3oool0103oool00`3o0000oooo0?ooo`0/0?ooo`05
0?l0003oool0oooo0?ooo`3oOgl00P3oool01@00o`00oooo0?ooo`3oool0003o00<0oooo00<0o`00
0?ooo`3oool0:P3oool0103o0000oooo0?ooo`000?l20?ooo`03003o003oool0ogmo0080oooo00<0
o`000?ooo`3oool03@3oool001/0oooo0P0000110?ooo`030?l0003oool0oooo00L0oooo00<0ogmo
0?ooo`3oool02P3oool00`00o`00oooo0?ooo`0A0?ooo`03003o003oool0oooo00H0oooo00<0ogmo
0?ooo`3oool01@3oool00`3o0000oooo0?ooo`0/0?ooo`050?l0003oool0oooo0?ooo`3oOgl00`3o
ool01000o`00oooo0?ooo`000?l30?ooo`030?l0003oool0oooo02X0oooo00H0o`000?ooo`3oool0
003o0?ooo`00o`020?ooo`040?moO`3oool0oooo0?l000l0oooo000K0?ooo`030000003oool0oooo
0400oooo00<0o`000?ooo`3oool0203oool00`3oOgl0oooo0?ooo`0:0?ooo`03003o003oool0oooo
00h0oooo0P00o`080?ooo`030?moO`3oool0oooo00D0oooo00<0o`000?ooo`3oool0;P3oool0103o
0000oooo0?ooo`3oOgl30?ooo`05003o003oool0oooo0?ooo`000?l00P3oool00`3o0000oooo0?oo
o`0Z0?ooo`030?l0003oool0003o0080oooo00@00?l00?ooo`3oool0ogmo0P3oool00`3o0000oooo
0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`110?ooo`030?l0003oool0oooo00P0oooo00<0
ogmo0?ooo`3oool02P3oool2003o00`0oooo0P00o`0:0?ooo`030?moO`3oool0oooo00@0oooo00<0
o`000?ooo`3oool0;`3oool01@3o0000oooo0?ooo`3oool0ogmo0080oooo00D00?l00?ooo`3oool0
oooo0000o`030?ooo`030?l0003oool0oooo02P0oooo00@0o`000?ooo`3oool0003o0P3oool01000
o`00oooo0?ooo`3oOgl20?ooo`030?l0003oool0oooo00d0oooo000K0?ooo`030000003oool0oooo
0480oooo00<0o`000?ooo`3oool0203oool00`3oOgl0oooo0?ooo`0;0?ooo`<00?l0203oool00`00
o`00oooo0?ooo`090?ooo`030?moO`3oool0oooo00D0oooo00<0o`000?ooo`3oool0;`3oool01@3o
0000oooo0?ooo`3oool0ogmo00<0oooo00@00?l00?ooo`3oool0003o0`3oool00`3o0000oooo0?oo
o`0X0?ooo`040?l0003oool0oooo0000o`80oooo00<00?l00?ooo`3oOgl00P3oool00`3o0000oooo
0?ooo`0>0?ooo`006`3oool00`000000oooo0?ooo`130?ooo`030?l0003oool0oooo00P0oooo00<0
ogmo0?ooo`3oool0303oool9003o00/0oooo00<0ogmo0?ooo`3oool01@3oool00`3o0000oooo0?oo
o`0a0?ooo`040?l0003oool0oooo0?moO`<0oooo00D00?l00?ooo`3oool0oooo0000o`020?ooo`03
0?l0003oool0oooo02P0oooo00H0o`000?ooo`3oool0003o0?ooo`00o`020?ooo`040?moO`3oool0
oooo0?l00100oooo000K0?ooo`030000003oool0oooo04@0oooo00<0o`000?ooo`3oool0203oool0
0`3oOgl0oooo0?ooo`0N0?ooo`030?moO`3oool0oooo00D0oooo00<0o`000?ooo`3oool0<P3oool0
1@3o0000oooo0?ooo`3oool0ogmo0080oooo00D00?l00?ooo`3oool0oooo0000o`030?ooo`030?l0
003oool0oooo02L0oooo00<0o`000?ooo`000?l00P3oool01000o`00oooo0?ooo`3oOgl20?ooo`03
0?l0003oool0oooo00h0oooo000K0?ooo`800000AP3oool00`3o0000oooo0?ooo`080?ooo`030?mo
O`3oool0oooo01`0oooo00<0ogmo0?ooo`3oool01@3oool00`3o0000oooo0?ooo`0c0?ooo`050?l0
003oool0oooo0?ooo`3oOgl00`3oool01000o`00oooo0?ooo`000?l30?ooo`030?l0003oool0oooo
02H0oooo00@0o`000?ooo`3oool0003o0P3oool01000o`00oooo0?ooo`3oOgl20?ooo`030?l0003o
ool0oooo00h0oooo000K0?ooo`030000003oool0oooo04H0oooo00<0o`000?ooo`3oool0203oool0
0`3oOgl0oooo0?ooo`0K0?ooo`030?moO`3oool0oooo00D0oooo00<0o`000?ooo`3oool0=03oool0
103o0000oooo0?ooo`3oOgl30?ooo`05003o003oool0oooo0?ooo`000?l00P3oool00`3o0000oooo
0?ooo`0V0?ooo`040?l0003oool0oooo0000o`80oooo00<00?l00?ooo`3oOgl00P3oool00`3o0000
oooo0?ooo`0?0?ooo`006`3oool00`000000oooo0?ooo`170?ooo`030?l0003oool0oooo00P0oooo
0P3oOglJ0?ooo`030?moO`3oool0oooo00D0oooo00<0o`000?ooo`3oool0=@3oool01@3o0000oooo
0?ooo`3oool0ogmo0080oooo00D00?l00?ooo`3oool0oooo0000o`030?ooo`030?l0003oool0oooo
02D0oooo00H0o`000?ooo`3oool0003o0?ooo`00o`020?ooo`040?moO`3oool0oooo0?l00140oooo
000K0?ooo`030000003oool0oooo04P0oooo00<0o`000?ooo`3oool02@3oool00`3oOgl0oooo0?oo
o`0F0?ooo`030?moO`3oool0oooo00D0oooo00<0o`000?ooo`3oool0=P3oool01@3o0000oooo0?oo
o`3oool0ogmo00<0oooo00@00?l00?ooo`3oool0003o0`3oool00`3o0000oooo0?ooo`0U0?ooo`03
0?l0003oool0003o0080oooo00@00?l00?ooo`3oool0ogmo0P3oool00`3o0000oooo0?ooo`0?0?oo
o`006`3oool00`000000oooo0?ooo`190?ooo`030?l0003oool0oooo00T0oooo0P3oOglE0?ooo`03
0?moO`3oool0oooo00H0oooo00<0o`000?ooo`3oool0=`3oool0103o0000oooo0?ooo`3oOgl30?oo
o`05003o003oool0oooo0?ooo`000?l00P3oool00`3o0000oooo0?ooo`0T0?ooo`040?l0003oool0
oooo0000o`80oooo00@00?l00?ooo`3oool0ogmo0P3oool00`3o0000oooo0?ooo`0?0?ooo`006`3o
ool2000004/0oooo00<0o`000?ooo`3oool02P3oool00`3oOgl0oooo0?ooo`0A0?ooo`030?moO`3o
ool0oooo00H0oooo00<0o`000?ooo`3oool0>03oool01@3o0000oooo0?ooo`3oool0ogmo0080oooo
00D00?l00?ooo`3oool0oooo0000o`030?ooo`030?l0003oool0oooo02<0oooo00@0o`000?ooo`3o
ool0003o0P3oool00`00o`00oooo0?moO`020?ooo`030?l0003oool0oooo0100oooo000K0?ooo`03
0000003oool0oooo04/0oooo00<0o`000?ooo`3oool02P3oool00`3oOgl0oooo0?ooo`0>0?ooo`80
ogmo203oool00`3o0000oooo0?ooo`0i0?ooo`050?l0003oool0oooo0?ooo`3oOgl00`3oool01000
o`00oooo0?ooo`000?l30?ooo`030?l0003oool0oooo02<0oooo00H0o`000?ooo`3oool0003o0?oo
o`00o`020?ooo`040?moO`3oool0oooo0?l00180oooo000K0?ooo`030000003oool0oooo04`0oooo
00<0o`000?ooo`3oool02P3oool20?moO``0oooo0P3oOgl:0?ooo`030?l0003oool0oooo03X0oooo
00@0o`000?ooo`3oool0ogmo0`3oool01@00o`00oooo0?ooo`3oool0003o0080oooo00<0o`000?oo
o`3oool08`3oool00`3o0000oooo0000o`020?ooo`04003o003oool0oooo0?moO`80oooo00<0o`00
0?ooo`3oool0403oool001/0oooo00<000000?ooo`3oool0C@3oool00`3o0000oooo0?ooo`0;0?oo
o`<0ogmo203oool00`3oOgl0oooo0?ooo`090?ooo`030?l0003oool0oooo03/0oooo00D0o`000?oo
o`3oool0oooo0?moO`020?ooo`05003o003oool0oooo0?ooo`000?l00P3oool00`3o0000oooo0?oo
o`0R0?ooo`040?l0003oool0oooo0000o`80oooo00@00?l00?ooo`3oool0ogmo0P3oool00`3o0000
oooo0?ooo`0@0?ooo`006`3oool00`000000oooo0?ooo`1>0?ooo`030?l0003oool0oooo00`0oooo
2@3oOgl;0?ooo`030?l0003oool0oooo03`0oooo00D0o`000?ooo`3oool0oooo0?moO`030?ooo`04
003o003oool0oooo0000o`<0oooo00<0o`000?ooo`3oool08@3oool0103o0000oooo0?ooo`000?l2
0?ooo`03003o003oool0ogmo0080oooo00<0o`000?ooo`3oool04@3oool001/0oooo00<000000?oo
o`3oool0C`3oool00`3o0000oooo0?ooo`0N0?ooo`030?l0003oool0oooo03h0oooo00@0o`000?oo
o`3oool0ogmo0`3oool01@00o`00oooo0?ooo`3oool0003o0080oooo00<0o`000?ooo`3oool08@3o
ool01P3o0000oooo0?ooo`000?l0oooo003o0080oooo00@0ogmo0?ooo`3oool0o`004`3oool001/0
oooo0P00001A0?ooo`030?l0003oool0oooo01`0oooo00<0o`000?ooo`3oool0?`3oool01@3o0000
oooo0?ooo`3oool0ogmo0080oooo00D00?l00?ooo`3oool0oooo0000o`020?ooo`030?l0003oool0
oooo0240oooo00<0o`000?ooo`000?l00P3oool01000o`00oooo0?ooo`3oOgl20?ooo`030?l0003o
ool0oooo0140oooo000K0?ooo`030000003oool0oooo0540oooo00<0o`000?ooo`3oool06`3oool0
0`3o0000oooo0?ooo`0o0?ooo`050?l0003oool0oooo0?ooo`3oOgl00`3oool01000o`00oooo0?oo
o`000?l30?ooo`030?l0003oool0oooo01l0oooo00@0o`000?ooo`3oool0003o0P3oool01P00o`00
oooo0?ooo`3oOgl0oooo0?l001@0oooo000K0?ooo`030000003oool0oooo0580oooo0P3o000J0?oo
o`030?l0003oool0oooo0440oooo00@0o`000?ooo`3oool0ogmo0`3oool01@00o`00oooo0?ooo`3o
ool0003o0080oooo00<0o`000?ooo`3oool07`3oool0103o0000oooo0?ooo`000?l20?ooo`03003o
003oool0ogmo0080oooo00<0o`000?ooo`3oool04P3oool001/0oooo00<000000?ooo`3oool0E03o
ool00`3o0000oooo0?ooo`0F0?ooo`030?l0003oool0oooo0480oooo00D0o`000?ooo`3oool0oooo
0?moO`020?ooo`05003o003oool0oooo0?ooo`000?l00P3oool00`3o0000oooo0?ooo`0O0?ooo`06
0?l0003oool0oooo0000o`3oool00?l00P3oool0103oOgl0oooo0?ooo`3o000D0?ooo`001`3oool4
000000<0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`1E0?ooo`80o`005@3oool0
0`3o0000oooo0?ooo`130?ooo`050?l0003oool0oooo0?ooo`3oOgl00`3oool01000o`00oooo0?oo
o`000?l30?ooo`030?l0003oool0oooo01d0oooo00@0o`000?ooo`3oool0003o0P3oool01000o`00
oooo0?ooo`3oOgl20?ooo`030?l0003oool0oooo0180oooo00070?ooo`030000003oool0oooo00<0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo05L0oooo00<0o`000?ooo`3oool04@3oool00`3o0000oooo0?ooo`150?ooo`040?l0003oool0
oooo0?moO`<0oooo00D00?l00?ooo`3oool0oooo0000o`020?ooo`030?l0003oool0oooo01d0oooo
00@0o`000?ooo`3oool0003o0P3oool01P00o`00oooo0?ooo`3oOgl0oooo0?l001D0oooo00080?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00040?ooo`<00000E`3oool00`3o0000oooo0?ooo`0@0?ooo`030?l0003oool0oooo04H0oooo00D0
o`000?ooo`3oool0oooo0?moO`020?ooo`05003o003oool0oooo0?ooo`000?l00P3oool00`3o0000
oooo0?ooo`0M0?ooo`040?l0003oool0oooo0000o`80oooo00<00?l00?ooo`3oOgl00P3oool00`3o
0000oooo0?ooo`0C0?ooo`002@3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05P0oooo0`3o000=
0?ooo`80o`00B@3oool01@3o0000oooo0?ooo`3oool0ogmo00<0oooo00@00?l00?ooo`3oool0003o
0`3oool00`3o0000oooo0?ooo`0K0?ooo`070?l0003oool0oooo0?ooo`000?l0oooo003o00020?oo
o`040?moO`3oool0oooo0?l001D0oooo00070?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo05/0oooo
00<0o`000?ooo`3oool0203oool20?l004`0oooo00@0o`000?ooo`3oool0ogmo0`3oool01000o`00
oooo0?ooo`000?l30?ooo`030?l0003oool0oooo01/0oooo00@0o`000?ooo`3oool0003o0P3oool0
1000o`00oooo0?ooo`3oOgl20?ooo`030?l0003oool0oooo01<0oooo00080?ooo`800000103oool2
000000@0oooo0P0000050?ooo`030000003oool0oooo05`0oooo2P3o001>0?ooo`050?l0003oool0
oooo0?ooo`3oOgl00P3oool01@00o`00oooo0?ooo`3oool0003o00<0oooo00<0o`000?ooo`3oool0
6@3oool01@3o0000oooo0?ooo`3oool0003o0080oooo00H00?l00?ooo`3oool0ogmo0?ooo`3o000F
0?ooo`006`3oool00`000000oooo0?ooo`2d0?ooo`050?l0003oool0oooo0?ooo`3oOgl00`3oool0
1000o`00oooo0?ooo`000?l30?ooo`030?l0003oool0oooo01T0oooo00D0o`000?ooo`3oool0oooo
0000o`020?ooo`03003o003oool0ogmo0080oooo00<0o`000?ooo`3oool0503oool001/0oooo0P00
002f0?ooo`040?l0003oool0oooo0?moO`<0oooo00@00?l00?ooo`3oool0003o103oool00`3o0000
oooo0?ooo`0H0?ooo`070?l0003oool0oooo0?ooo`000?l0oooo003o00020?ooo`040?moO`3oool0
oooo0?l001H0oooo000K0?ooo`030000003oool0oooo0;D0oooo00D0o`000?ooo`3oool0oooo0?mo
O`020?ooo`05003o003oool0oooo0?ooo`000?l00`3oool00`3o0000oooo0?ooo`0G0?ooo`050?l0
003oool0oooo0?ooo`000?l00P3oool01000o`00oooo0?ooo`3oOgl20?ooo`030?l0003oool0oooo
01@0oooo000K0?ooo`030000003oool0oooo0;D0oooo00D0o`000?ooo`3oool0oooo0?moO`030?oo
o`04003o003oool0oooo0000o`<0oooo00<0o`000?ooo`3oool05`3oool01@3o0000oooo0?ooo`3o
ool0003o0080oooo00H00?l00?ooo`3oool0ogmo0?ooo`3o000G0?ooo`006`3oool00`000000oooo
0?ooo`2f0?ooo`040?l0003oool0oooo0?moO`<0oooo00@00?l00?ooo`3oool0003o103oool00`3o
0000oooo0?ooo`0F0?ooo`050?l0003oool0oooo0?ooo`000?l00P3oool00`00o`00oooo0?moO`02
0?ooo`030?l0003oool0oooo01D0oooo000K0?ooo`030000003oool0oooo0;H0oooo00D0o`000?oo
o`3oool0oooo0?moO`020?ooo`05003o003oool0oooo0?ooo`000?l00`3oool00`3o0000oooo0?oo
o`0E0?ooo`050?l0003oool0oooo0?ooo`000?l00P3oool01000o`00oooo0?ooo`3oOgl20?ooo`03
0?l0003oool0oooo01D0oooo000K0?ooo`030000003oool0oooo0;H0oooo00D0o`000?ooo`3oool0
oooo0?moO`030?ooo`04003o003oool0oooo0000o`@0oooo00<0o`000?ooo`3oool0503oool01@3o
0000oooo0?ooo`3oool0003o0080oooo00@00?l00?ooo`3oool0ogmo0P3oool00`3o0000oooo0?oo
o`0E0?ooo`006`3oool200000;P0oooo00@0o`000?ooo`3oool0ogmo0`3oool01000o`00oooo0?oo
o`000?l40?ooo`030?l0003oool0oooo01<0oooo00<0o`000?ooo`3oool00P3oool010000?l0oooo
0?ooo`00o`020?ooo`030?moO`3oool0o`0001P0oooo000K0?ooo`030000003oool0oooo0;L0oooo
00D0o`000?ooo`3oool0oooo0?moO`020?ooo`05003o003oool0oooo0?ooo`000?l0103oool00`3o
0000oooo0?ooo`0B0?ooo`050?l0003oool0oooo0?ooo`000?l00`3oool00`00o`00oooo0?moO`02
0?ooo`030?l0003oool0oooo01H0oooo000K0?ooo`030000003oool0oooo0;L0oooo00D0o`000?oo
o`3oool0oooo0?moO`020?ooo`05003o003oool0oooo0?ooo`000?l0103oool00`3o0000oooo0?oo
o`0A0?ooo`030?l0003oool0oooo0080oooo00@0003o0?ooo`3oool00?l00P3oool0103oOgl0oooo
0?ooo`3o000H0?ooo`006`3oool00`000000oooo0?ooo`2h0?ooo`040?l0003oool0oooo0?moO`<0
oooo00D00?l00?ooo`3oool0oooo0000o`030?ooo`030?l0003oool0oooo0140oooo00D0o`000?oo
o`3oool0oooo0000o`030?ooo`04003o003oool0oooo0?moO`80oooo00<0o`000?ooo`3oool05P3o
ool001/0oooo00<000000?ooo`3oool0^03oool01@3o0000oooo0?ooo`3oool0ogmo0080oooo00D0
0?l00?ooo`3oool0oooo0000o`040?ooo`030?l0003oool0oooo00l0oooo00<0o`000?ooo`3oool0
0P3oool01@000?l0oooo0?ooo`3oool00?l00080oooo00<0ogmo0?ooo`3o00006@3oool001/0oooo
0P00002i0?ooo`050?l0003oool0oooo0?ooo`3oOgl00P3oool00`00o`00oooo0?ooo`020?ooo`05
0000o`3oool0oooo0?ooo`3o00004@3oool00`3o0000oooo0?ooo`020?ooo`070000o`3oool0oooo
0?ooo`00o`00oooo0?moO`020?ooo`030?l0003oool0oooo01L0oooo000K0?ooo`030000003oool0
oooo0;T0oooo00@0o`000?ooo`3oool0ogmo0`3oool01@00o`00oooo0?ooo`3oool0003o00@0oooo
00<0o`000?ooo`3oool03@3oool00`3o0000oooo0?ooo`020?ooo`050000o`3oool0oooo0?ooo`00
o`000P3oool0103oOgl0oooo0?ooo`3o000I0?ooo`006`3oool00`000000oooo0?ooo`2i0?ooo`05
0?l0003oool0oooo0?ooo`3oOgl00P3oool01@00o`00oooo0?ooo`3oool0003o00@0oooo00<0o`00
0?ooo`3oool03@3oool00`3o0000oooo0?ooo`020?ooo`050000o`3oool0oooo0?ooo`00o`000P3o
ool0103oOgl0oooo0?ooo`3o000I0?ooo`006`3oool00`000000oooo0?ooo`2i0?ooo`050?l0003o
ool0oooo0?ooo`3oOgl00P3oool00`00o`00oooo0?ooo`020?ooo`030000o`3oool0oooo0080oooo
00<0o`000?ooo`3oool02`3oool00`3o0000oooo0?ooo`030?ooo`050000o`3oool0oooo0?ooo`00
o`000P3oool00`3oOgl0oooo0?l0000J0?ooo`006`3oool00`000000oooo0?ooo`2j0?ooo`040?l0
003oool0oooo0?moO`<0oooo00D00?l00?ooo`3oool0oooo0000o`050?ooo`030?l0003oool0oooo
00X0oooo00<0o`000?ooo`3oool00P3oool01@000?l0oooo0?ooo`3oool00?l00080oooo00@0ogmo
0?ooo`3oool0o`006P3oool001/0oooo00<000000?ooo`3oool0^P3oool01@3o0000oooo0?ooo`3o
ool0ogmo0080oooo00<00?l00?ooo`3oool00P3oool00`000?l0oooo0?ooo`030?ooo`030?l0003o
ool0oooo00P0oooo00<0o`000?ooo`3oool00`3oool01@000?l0oooo0?ooo`3oool00?l00080oooo
00@0ogmo0?ooo`3oool0o`006P3oool001/0oooo0P00002k0?ooo`050?l0003oool0oooo0?ooo`3o
Ogl00P3oool00`00o`00oooo0?ooo`020?ooo`030000o`3oool0oooo00<0oooo00<0o`000?ooo`3o
ool01`3oool00`3o0000oooo0?ooo`030?ooo`030000o`3oool0oooo0080oooo00@00?l00?ooo`3o
ool0ogmo0P3oool00`3o0000oooo0?ooo`0H0?ooo`006`3oool00`000000oooo0?ooo`2k0?ooo`04
0?l0003oool0oooo0?moO`<0oooo00<00?l00?ooo`3oool00P3oool00`000?l0oooo0?ooo`030?oo
o`80o`001P3oool00`3o0000oooo0?ooo`040?ooo`050000o`3oool0oooo0?ooo`00o`000`3oool0
0`3oOgl0oooo0?l0000K0?ooo`006`3oool00`000000oooo0?ooo`2k0?ooo`040?l0003oool0oooo
0?moO`<0oooo00<00?l00?ooo`3oool00P3oool00`000?l0oooo0?ooo`050?ooo`H0o`001P3oool0
0`000?l0oooo0?ooo`020?ooo`04003o003oool0oooo0?moO`80oooo00<0o`000?ooo`3oool06@3o
ool000P0oooo0P0000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0^`3oool0
1@3o0000oooo0?ooo`3oool0ogmo00<0oooo00D00?l00?ooo`3oool0oooo0000o`090?ooo`80o`00
203oool01@000?l0oooo0?ooo`3oool00?l000<0oooo00@0ogmo0?ooo`3oool0o`006`3oool000L0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool0_03oool0103o0000oooo0?ooo`3oOgl30?ooo`03003o
003oool0oooo0080oooo00<0003o0?ooo`3oool03`3oool00`000?l0oooo0?ooo`020?ooo`05003o
003oool0oooo0?ooo`3oOgl00P3oool00`3o0000oooo0?ooo`0I0?ooo`002@3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?oo
o`<00000_03oool0103o0000oooo0?ooo`3oOgl40?ooo`05003o003oool0oooo0?ooo`000?l04@3o
ool00`000?l0oooo0?ooo`020?ooo`07003o003oool0oooo0?ooo`3oOgl0oooo0?l0000L0?ooo`00
2P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`2l0?ooo`050?l0003oool0oooo0?ooo`3oOgl00`3oool0
0`00o`00oooo0?ooo`020?ooo`030000o`3oool0oooo00d0oooo00<0003o0?ooo`3oool00P3oool0
1@00o`00oooo0?ooo`3oool0ogmo0080oooo00<0o`000?ooo`3oool06P3oool000L0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool0_@3oool0103o0000oooo0?ooo`3oOgl30?ooo`03003o003oool0oooo
0080oooo00<0003o0?ooo`3oool03@3oool00`000?l0oooo0?ooo`020?ooo`05003o003oool0oooo
0?ooo`3oOgl00P3oool00`3o0000oooo0?ooo`0J0?ooo`00203oool2000000@0oooo0P0000040?oo
o`8000001@3oool00`000000oooo0?ooo`2m0?ooo`040?l0003oool0oooo0?moO`@0oooo00<00?l0
0?ooo`3oool00P3oool00`000?l0oooo0?ooo`0;0?ooo`030000o`3oool0oooo00<0oooo00D00?l0
0?ooo`3oool0oooo0?moO`020?ooo`030?l0003oool0oooo01X0oooo000K0?ooo`030000003oool0
oooo0;d0oooo00D0o`000?ooo`3oool0oooo0?moO`030?ooo`03003o003oool0oooo00<0oooo00<0
003o0?ooo`3oool02P3oool00`000?l0oooo0?ooo`020?ooo`05003o003oool0oooo0?ooo`3oOgl0
0P3oool00`3o0000oooo0?ooo`0K0?ooo`006`3oool00`000000oooo0?ooo`2n0?ooo`040?l0003o
ool0oooo0?moO`@0oooo00<00?l00?ooo`3oool00`3oool00`000?l0oooo0?ooo`080?ooo`030000
o`3oool0oooo00<0oooo00D00?l00?ooo`3oool0oooo0?moO`020?ooo`030?l0003oool0oooo01/0
oooo000K0?ooo`800000_`3oool0103o0000oooo0?ooo`3oOgl40?ooo`03003o003oool0oooo00<0
oooo00<0003o0?ooo`3oool01`3oool00`000?l0oooo0?ooo`030?ooo`03003o003oool0oooo0080
oooo00@0ogmo0?ooo`3oool0o`007@3oool001/0oooo00<000000?ooo`3oool0_P3oool01@3o0000
oooo0?ooo`3oool0ogmo00@0oooo00<00?l00?ooo`3oool00`3oool20000o`H0oooo00<0003o0?oo
o`3oool0103oool01@00o`00oooo0?ooo`3oool0ogmo00<0oooo00<0o`000?ooo`3oool06`3oool0
01/0oooo00<000000?ooo`3oool0_P3oool01@3o0000oooo0?ooo`3oool0ogmo00@0oooo00<00?l0
0?ooo`3oool01@3oool60000o`H0oooo00<00?l00?ooo`3oool00P3oool0103oOgl0oooo0?ooo`3o
000N0?ooo`006`3oool00`000000oooo0?ooo`2o0?ooo`050?l0003oool0oooo0?ooo`3oOgl00`3o
ool00`00o`00oooo0?ooo`070?ooo`80003o203oool00`00o`00oooo0?ooo`020?ooo`040?moO`3o
ool0oooo0?l001h0oooo000K0?ooo`030000003oool0oooo0;l0oooo00D0o`000?ooo`3oool0oooo
0?moO`040?ooo`03003o003oool0oooo00l0oooo00<00?l00?ooo`3oool00P3oool01@3oOgl0oooo
0?ooo`3oool0o`0001h0oooo000K0?ooo`800000`03oool00`3o0000oooo0?ooo`020?ooo`050?mo
O`3oool0oooo0?ooo`00o`004@3oool00`00o`00oooo0?ooo`020?ooo`050?moO`3oool0oooo0?oo
o`3o00007P3oool001/0oooo00<000000?ooo`3oool0`03oool01@3o0000oooo0?ooo`3oool0ogmo
00@0oooo00<00?l00?ooo`3oool03P3oool00`00o`00oooo0?ooo`020?ooo`040?moO`3oool0oooo
0?l001l0oooo000K0?ooo`030000003oool0oooo0<00oooo00D0o`000?ooo`3oool0oooo0?moO`04
0?ooo`03003o003oool0oooo00d0oooo00<00?l00?ooo`3oool00P3oool01@3oOgl0oooo0?ooo`3o
ool0o`0001l0oooo000K0?ooo`030000003oool0oooo0<00oooo00<0o`000?ooo`3oool00P3oool0
0`3oOgl0oooo0?ooo`020?ooo`03003o003oool0oooo00`0oooo00<00?l00?ooo`3oool00P3oool0
1@3oOgl0oooo0?ooo`3oool0o`0001l0oooo000K0?ooo`030000003oool0oooo0<40oooo00D0o`00
0?ooo`3oool0oooo0?moO`050?ooo`03003o003oool0oooo00X0oooo00<00?l00?ooo`3oool00`3o
ool0103oOgl0oooo0?ooo`3o000P0?ooo`006`3oool00`000000oooo0?ooo`310?ooo`030?l0003o
ool0oooo0080oooo00<0ogmo0?ooo`3oool00`3oool00`00o`00oooo0?ooo`090?ooo`03003o003o
ool0oooo0080oooo00D0ogmo0?ooo`3oool0oooo0?l0000P0?ooo`006`3oool200000<80oooo00<0
o`000?ooo`3oool00P3oool00`3oOgl0oooo0?ooo`030?ooo`03003o003oool0oooo00L0oooo0P00
o`050?ooo`050?moO`3oool0oooo0?ooo`3o0000803oool001/0oooo00<000000?ooo`3oool0`P3o
ool00`3o0000oooo0?ooo`020?ooo`030?moO`3oool0oooo00<0oooo0P00o`060?ooo`03003o003o
ool0oooo00@0oooo00D0ogmo0?ooo`3oool0oooo0?l0000Q0?ooo`006`3oool00`000000oooo0?oo
o`320?ooo`030?l0003oool0oooo0080oooo00<0ogmo0?ooo`3oool01@3oool2003o0080oooo0P00
o`070?ooo`050?moO`3oool0oooo0?ooo`3o00008@3oool001/0oooo00<000000?ooo`3oool0``3o
ool01@3o0000oooo0?ooo`3oool0ogmo00T0oooo0P00o`080?ooo`030?moO`3oool0oooo0080oooo
00<0o`000?ooo`3oool07`3oool001/0oooo00<000000?ooo`3oool0``3oool00`3o0000oooo0?oo
o`020?ooo`030?moO`3oool0oooo0100oooo00D0ogmo0?ooo`3oool0oooo0?l0000R0?ooo`006`3o
ool200000<D0oooo00D0o`000?ooo`3oool0oooo0?moO`0A0?ooo`030?moO`3oool0oooo0080oooo
00<0o`000?ooo`3oool0803oool001/0oooo00<000000?ooo`3oool0a03oool00`3o0000oooo0?oo
o`020?ooo`030?moO`3oool0oooo00h0oooo00<0ogmo0?ooo`3oool00P3oool00`3o0000oooo0?oo
o`0P0?ooo`006`3oool00`000000oooo0?ooo`340?ooo`030?l0003oool0oooo0080oooo00<0ogmo
0?ooo`3oool03@3oool00`3oOgl0oooo0?ooo`020?ooo`030?l0003oool0oooo0240oooo000K0?oo
o`030000003oool0oooo0<D0oooo00<0o`000?ooo`3oool00P3oool00`3oOgl0oooo0?ooo`0<0?oo
o`030?moO`3oool0oooo0080oooo00<0o`000?ooo`3oool08@3oool000T0oooo0`0000020?ooo`80
0000103oool2000000D0oooo00<000000?ooo`3oool0a@3oool00`3o0000oooo0?ooo`020?ooo`03
0?moO`3oool0oooo00/0oooo00<0ogmo0?ooo`3oool00`3oool00`3o0000oooo0?ooo`0Q0?ooo`00
2P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`360?ooo`030?l0003oool0oooo0080oooo00<0ogmo0?oo
o`3oool02P3oool00`3oOgl0oooo0?ooo`020?ooo`030?l0003oool0oooo0280oooo00070?ooo`D0
000000D0oooo0000003oool0oooo000000020?ooo`040000003oool0oooo000000@0oooo0`000036
0?ooo`030?l0003oool0oooo00<0oooo00<0ogmo0?ooo`3oool01`3oool20?moO`D0oooo00<0o`00
0?ooo`3oool08P3oool000L0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0a`3oool00`3o0000oooo
0?ooo`030?ooo`80ogmo1P3oool00`3oOgl0oooo0?ooo`040?ooo`030?l0003oool0oooo02<0oooo
00080?ooo`030000003oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000040?ooo`030000003oool0oooo0<L0oooo00<0o`000?ooo`3oool01@3oool20?moO`80
oooo0`3oOgl60?ooo`030?l0003oool0oooo02<0oooo00090?ooo`8000000`3oool2000000@0oooo
0P0000050?ooo`030000003oool0oooo0<L0oooo00<0o`000?ooo`3oool01`3oool20?moO`P0oooo
00<0o`000?ooo`3oool0903oool001/0oooo00<000000?ooo`3oool0b03oool00`3o0000oooo0?oo
o`0@0?ooo`030?l0003oool0oooo02@0oooo000K0?ooo`800000b@3oool00`3o0000oooo0?ooo`0?
0?ooo`030?l0003oool0oooo02D0oooo000K0?ooo`030000003oool0oooo0<T0oooo00<0o`000?oo
o`3oool03P3oool00`3o0000oooo0?ooo`0U0?ooo`006`3oool00`000000oooo0?ooo`390?ooo`03
0?l0003oool0oooo00d0oooo00<0o`000?ooo`3oool09P3oool001/0oooo00<000000?ooo`3oool0
bP3oool00`3o0000oooo0?ooo`0<0?ooo`030?l0003oool0oooo02H0oooo000K0?ooo`030000003o
ool0oooo0<X0oooo00<0o`000?ooo`3oool02`3oool00`3o0000oooo0?ooo`0W0?ooo`006`3oool0
0`000000oooo0?ooo`3;0?ooo`030?l0003oool0oooo00X0oooo00<0o`000?ooo`3oool09`3oool0
01/0oooo0P00003=0?ooo`030?l0003oool0oooo00L0oooo0P3o000Z0?ooo`006`3oool00`000000
oooo0?ooo`3=0?ooo`80o`001P3oool00`3o0000oooo0?ooo`0Z0?ooo`006`3oool00`000000oooo
0?ooo`3?0?ooo`80o`000P3oool30?l002`0oooo000K0?ooo`030000003oool0oooo0=00oooo103o
000^0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`800000o`3oool40?oo
o`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo
0`3oool00001\
\>"],
  ImageRangeCache->{{{81, 368}, {510.125, 333.188}} -> {-2.0147, 1034.12, \
0.055407, 3.62308}},
  CellTags->"b:1.1.0.0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Separable Equations", "Subsubsection",
  CellTags->{"separableODE", "c:10", "b:1.1.0.1"}],

Cell[TextData[StyleBox["The general solution to this equation is found by \
separation of variables.",
  FontColor->GrayLevel[0]]], "MathCaption",
  CellTags->"b:1.1.0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(\(x\^2\ y[x]^2\)\/\@\(3 - x\^2\)\)}], ",", "y", ",", 
        "x"}], "]"}]], "Input",
  CellLabel->"In[37]:=",
  CellTags->"b:1.1.0.1"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            2\/\(x\ \@\(3 - x\^2\) - 3\ ArcSin[x\/\@3] - 2\ C[1]\)]}}\)], \
"Output",
  CellLabel->"Out[37]=",
  CellTags->"b:1.1.0.1"]
}, Open  ]],

Cell[TextData[{
  "Even when variables can be separated, the final solution might be \
accompanied by a warning message from ",
  StyleBox["Solve", "MR"],
  ", or it might only be given as an ",
  StyleBox["InverseFunction", "MR"],
  " object."
}], "Text",
  CellTags->"b:1.1.0.1"],

Cell[TextData[{
  "Solving this ODE generates a warning message because ",
  StyleBox["Solve", "MR"],
  " obtains an expression for ",
  StyleBox["y[x]", "MR"],
  " using ",
  StyleBox["Log", "MR"],
  ", the inverse of ",
  StyleBox["Exp", "MR"],
  ". This warning message can be ignored."
}], "MathCaption",
  CellTags->"b:1.1.0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(\(x\^2\ Exp[y[x]]\)\/\@\(3 - x\^2\)\)}], ",", "y", 
        ",", "x"}], "]"}]], "Input",
  CellLabel->"In[38]:=",
  CellTags->"b:1.1.0.1"],

Cell[BoxData[
    RowBox[{\(Solve::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse functions are \
being used by \\!\\(Solve\\), so some solutions may not be found; use Reduce \
for complete solution information. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.1"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, \(-Log[
                1\/2\ x\ \@\(3 - x\^2\) - 3\/2\ ArcSin[x\/\@3] - 
                  C[1]]\)]}}\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->"b:1.1.0.1"]
}, Open  ]],

Cell[TextData[{
  "The solution to this equation is given as an ",
  StyleBox["InverseFunction", "MR"],
  StyleBox[" object, in order to get an explicit expression for ", "TR"],
  StyleBox["y[x]", "MR"],
  StyleBox[".", "TR"]
}], "MathCaption",
  CellTags->"b:1.1.0.1"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"sol", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], 
            "\[Equal]", \(\(\(x\^2\)\(\ \)\)\/\(\(\@\(9 - x\^2\)\) Log[y[x]]*
                  Sin[y[x]]\)\)}], ",", \(y[x]\), ",", "x"}], 
        "]"}]}]], "Input",
  CellLabel->"In[39]:=",
  CellTags->"b:1.1.0.1"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.1"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.1"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.1"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(InverseFunction[
              CosIntegral[#1] - 
                  Cos[#1]\ Log[#1] &]\)[\(-\[ImaginaryI]\)\ \((1\/2\ \@\(\(-3\
\) + x\)\ x\ \@\(3 + x\) + 9\ ArcSinh[\@\(\(-3\) + x\)\/\@6])\) + 
              C[1]]}}\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"b:1.1.0.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Homogeneous Equations", "Subsubsection",
  CellTags->{"homogeneousODE", "c:11", "b:1.1.0.2"}],

Cell[TextData[{
  "Here is a homogeneous equation in which the total degree of each term is \
2. ",
  "The two parts of the solution list give branches of the integral curves in \
the form ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  ". "
}], "MathCaption",
  CellTags->"b:1.1.0.2"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(eqn = \(y'\)[
          x] \[Equal] \(-\((x^2 - 3  y[x]^2)\)\)/\((x*
              y[x])\); \), "\[IndentingNewLine]", 
    \(sol = DSolve[eqn, y, x]\)}], "Input",
  CellLabel->"In[40]:=",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    \({{y \[Rule] Function[{x}, \@\(x\^2\/2 + x\^6\ C[1]\)]}, {y \[Rule] 
          Function[{x}, \(-\(\@\(x\^2 + 2\ x\^6\ C[1]\)\/\@2\)\)]}}\)], \
"Output",
  CellLabel->"Out[41]=",
  CellTags->"b:1.1.0.2"]
}, Open  ]],

Cell[TextData[{
  "This plots both branches together, showing the complete integral curves ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(y\^2\), "\[LongEqual]", 
          RowBox[{
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["C",
                    FontSlant->"Plain"], "[", "1", "]"}],
                "MR"], " ", \(x\^6\)}], "+", \(x\^2\/2\)}]}], 
        TraditionalForm]]],
  " for several values of ",
  StyleBox["C[1]", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    \(tab1 = 
      Table[\(y[x] /. sol[\([\)\(1\)\(]\)]\) /. C[1] \[Rule] \ k, \ {k, 0, 
          3, \ 0.5}]; \)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    \(tab2 = 
      Table[\(y[x] /. sol[\([\)\(2\)\(]\)]\) /. C[1] \[Rule] \ k, \ {k, 0, 
          3, \ 0.5}]; \)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"b:1.1.0.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[Join[tab1, tab2]], \ {x, 0, 1.7}, \ 
      PlotStyle\  \[Rule] \ {Blue}]; \)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"b:1.1.0.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.560224 0.309017 0.0518173 [
[.16387 .29652 -12 -9 ]
[.16387 .29652 12 0 ]
[.30392 .29652 -9 -9 ]
[.30392 .29652 9 0 ]
[.44398 .29652 -12 -9 ]
[.44398 .29652 12 0 ]
[.58403 .29652 -3 -9 ]
[.58403 .29652 3 0 ]
[.72409 .29652 -12 -9 ]
[.72409 .29652 12 0 ]
[.86415 .29652 -9 -9 ]
[.86415 .29652 9 0 ]
[.01131 .10175 -12 -4.5 ]
[.01131 .10175 0 4.5 ]
[.01131 .20538 -12 -4.5 ]
[.01131 .20538 0 4.5 ]
[.01131 .41265 -6 -4.5 ]
[.01131 .41265 0 4.5 ]
[.01131 .51629 -6 -4.5 ]
[.01131 .51629 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16387 .30902 m
.16387 .31527 L
s
[(0.25)] .16387 .29652 0 1 Mshowa
.30392 .30902 m
.30392 .31527 L
s
[(0.5)] .30392 .29652 0 1 Mshowa
.44398 .30902 m
.44398 .31527 L
s
[(0.75)] .44398 .29652 0 1 Mshowa
.58403 .30902 m
.58403 .31527 L
s
[(1)] .58403 .29652 0 1 Mshowa
.72409 .30902 m
.72409 .31527 L
s
[(1.25)] .72409 .29652 0 1 Mshowa
.86415 .30902 m
.86415 .31527 L
s
[(1.5)] .86415 .29652 0 1 Mshowa
.125 Mabswid
.05182 .30902 m
.05182 .31277 L
s
.07983 .30902 m
.07983 .31277 L
s
.10784 .30902 m
.10784 .31277 L
s
.13585 .30902 m
.13585 .31277 L
s
.19188 .30902 m
.19188 .31277 L
s
.21989 .30902 m
.21989 .31277 L
s
.2479 .30902 m
.2479 .31277 L
s
.27591 .30902 m
.27591 .31277 L
s
.33193 .30902 m
.33193 .31277 L
s
.35994 .30902 m
.35994 .31277 L
s
.38796 .30902 m
.38796 .31277 L
s
.41597 .30902 m
.41597 .31277 L
s
.47199 .30902 m
.47199 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.52801 .30902 m
.52801 .31277 L
s
.55602 .30902 m
.55602 .31277 L
s
.61204 .30902 m
.61204 .31277 L
s
.64006 .30902 m
.64006 .31277 L
s
.66807 .30902 m
.66807 .31277 L
s
.69608 .30902 m
.69608 .31277 L
s
.7521 .30902 m
.7521 .31277 L
s
.78011 .30902 m
.78011 .31277 L
s
.80812 .30902 m
.80812 .31277 L
s
.83613 .30902 m
.83613 .31277 L
s
.89216 .30902 m
.89216 .31277 L
s
.92017 .30902 m
.92017 .31277 L
s
.94818 .30902 m
.94818 .31277 L
s
.97619 .30902 m
.97619 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .10175 m
.03006 .10175 L
s
[(-4)] .01131 .10175 1 0 Mshowa
.02381 .20538 m
.03006 .20538 L
s
[(-2)] .01131 .20538 1 0 Mshowa
.02381 .41265 m
.03006 .41265 L
s
[(2)] .01131 .41265 1 0 Mshowa
.02381 .51629 m
.03006 .51629 L
s
[(4)] .01131 .51629 1 0 Mshowa
.125 Mabswid
.02381 .02402 m
.02756 .02402 L
s
.02381 .04993 m
.02756 .04993 L
s
.02381 .07584 m
.02756 .07584 L
s
.02381 .12766 m
.02756 .12766 L
s
.02381 .15357 m
.02756 .15357 L
s
.02381 .17947 m
.02756 .17947 L
s
.02381 .23129 m
.02756 .23129 L
s
.02381 .2572 m
.02756 .2572 L
s
.02381 .28311 m
.02756 .28311 L
s
.02381 .33493 m
.02756 .33493 L
s
.02381 .36083 m
.02756 .36083 L
s
.02381 .38674 m
.02756 .38674 L
s
.02381 .43856 m
.02756 .43856 L
s
.02381 .46447 m
.02756 .46447 L
s
.02381 .49038 m
.02756 .49038 L
s
.02381 .54219 m
.02756 .54219 L
s
.02381 .5681 m
.02756 .5681 L
s
.02381 .59401 m
.02756 .59401 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .30902 m
.06244 .31154 L
.10458 .3143 L
.14415 .31689 L
.18221 .31938 L
.22272 .32203 L
.26171 .32458 L
.30316 .32729 L
.34309 .3299 L
.3815 .33241 L
.42237 .33508 L
.46172 .33766 L
.49955 .34013 L
.53984 .34277 L
.57861 .3453 L
.61984 .348 L
.65954 .3506 L
.69774 .35309 L
.73838 .35575 L
.77751 .35831 L
.81909 .36103 L
.85916 .36365 L
.89771 .36617 L
.93871 .36885 L
.97619 .37131 L
s
.02381 .30902 m
.06244 .31154 L
.10458 .3143 L
.14415 .3169 L
.18221 .31941 L
.22272 .32213 L
.26171 .32483 L
.30316 .32784 L
.34309 .33097 L
.3815 .33428 L
.42237 .33823 L
.46172 .34258 L
.49955 .34738 L
.53984 .35328 L
.57861 .35984 L
.61984 .36789 L
.65954 .37681 L
.69774 .38655 L
.73838 .39827 L
.77751 .41095 L
.81909 .42603 L
.85916 .44221 L
.89771 .45938 L
.93871 .47946 L
.97619 .4995 L
s
.02381 .30902 m
.06244 .31154 L
.10458 .3143 L
.14415 .3169 L
.18221 .31944 L
.22272 .32223 L
.26171 .32507 L
.30316 .32838 L
.34309 .332 L
.3815 .33602 L
.42237 .34107 L
.46172 .34687 L
.49955 .35346 L
.53984 .36173 L
.57861 .37106 L
.61984 .38259 L
.65954 .3954 L
.69774 .40941 L
.73838 .42626 L
.77751 .44448 L
.81909 .46611 L
.85916 .48929 L
.89771 .51384 L
.93871 .54251 L
.97619 .5711 L
s
.02381 .30902 m
.06244 .31154 L
.10458 .3143 L
.14415 .31691 L
.18221 .31948 L
.22272 .32233 L
.26171 .32532 L
.30316 .32891 L
.34309 .33298 L
.3815 .33765 L
.42237 .34368 L
.46172 .35072 L
.49955 .3588 L
.53984 .36901 L
.57861 .38054 L
.61984 .39481 L
.65954 .41065 L
.69774 .42796 L
.73838 .44876 L
.77751 .47123 L
.81909 .49787 L
.85916 .52639 L
.89771 .5566 L
.93871 .59184 L
s
.93871 .59184 m
.96666 .61803 L
s
.02381 .30902 m
.06244 .31154 L
.10458 .3143 L
.14415 .31692 L
.18221 .31951 L
.22272 .32243 L
.26171 .32556 L
.30316 .32942 L
.34309 .33392 L
.3815 .3392 L
.42237 .34611 L
.46172 .35424 L
.49955 .36363 L
.53984 .37549 L
.57861 .38891 L
.61984 .40549 L
.65954 .42389 L
.69774 .44399 L
.73838 .46811 L
.77751 .49415 L
.81909 .52501 L
.85916 .55803 L
.89771 .59299 L
s
.89771 .59299 m
.9229 .61803 L
s
.02381 .30902 m
.06244 .31154 L
.10458 .31431 L
.14415 .31693 L
.18221 .31954 L
.22272 .32253 L
.26171 .32579 L
.30316 .32992 L
.34309 .33482 L
.3815 .34067 L
.42237 .34838 L
.46172 .35751 L
.49955 .36806 L
.53984 .3814 L
.57861 .39647 L
.61984 .4151 L
.65954 .43576 L
.69774 .4583 L
.73838 .48534 L
.77751 .51452 L
.81909 .5491 L
.85916 .58608 L
s
.85916 .58608 m
.89064 .61803 L
s
.02381 .30902 m
.06244 .31154 L
.10458 .31431 L
.14415 .31694 L
.18221 .31957 L
.22272 .32263 L
.26171 .32603 L
.30316 .33041 L
.34309 .3357 L
.3815 .34208 L
.42237 .35054 L
.46172 .36057 L
.49955 .37218 L
.53984 .38686 L
.57861 .40344 L
.61984 .42391 L
.65954 .4466 L
.69774 .47135 L
.73838 .50104 L
.77751 .53306 L
.81909 .57099 L
.85916 .61154 L
s
.85916 .61154 m
.865 .61803 L
s
.02381 .30902 m
.06244 .30649 L
.10458 .30373 L
.14415 .30115 L
.18221 .29866 L
.22272 .29601 L
.26171 .29346 L
.30316 .29075 L
.34309 .28814 L
.3815 .28562 L
.42237 .28295 L
.46172 .28038 L
.49955 .2779 L
.53984 .27527 L
.57861 .27273 L
.61984 .27004 L
.65954 .26744 L
.69774 .26494 L
.73838 .26228 L
.77751 .25972 L
.81909 .257 L
.85916 .25438 L
.89771 .25186 L
.93871 .24918 L
.97619 .24673 L
s
.02381 .30902 m
.06244 .30649 L
.10458 .30373 L
.14415 .30114 L
.18221 .29862 L
.22272 .2959 L
.26171 .29321 L
.30316 .29019 L
.34309 .28706 L
.3815 .28375 L
.42237 .2798 L
.46172 .27545 L
.49955 .27066 L
.53984 .26476 L
.57861 .25819 L
.61984 .25014 L
.65954 .24123 L
.69774 .23149 L
.73838 .21977 L
.77751 .20708 L
.81909 .192 L
.85916 .17582 L
.89771 .15865 L
.93871 .13858 L
.97619 .11853 L
s
.02381 .30902 m
.06244 .30649 L
.10458 .30373 L
.14415 .30113 L
.18221 .29859 L
.22272 .2958 L
.26171 .29296 L
.30316 .28965 L
.34309 .28604 L
.3815 .28201 L
.42237 .27696 L
.46172 .27117 L
.49955 .26457 L
.53984 .2563 L
.57861 .24697 L
.61984 .23544 L
.65954 .22263 L
.69774 .20862 L
.73838 .19177 L
.77751 .17355 L
.81909 .15192 L
.85916 .12875 L
.89771 .10419 L
.93871 .07553 L
.97619 .04693 L
s
.02381 .30902 m
.06244 .30649 L
.10458 .30373 L
.14415 .30112 L
.18221 .29856 L
.22272 .2957 L
.26171 .29272 L
.30316 .28912 L
.34309 .28506 L
.3815 .28038 L
.42237 .27435 L
.46172 .26732 L
.49955 .25923 L
.53984 .24903 L
.57861 .23749 L
.61984 .22323 L
.65954 .20738 L
.69774 .19007 L
.73838 .16927 L
.77751 .14681 L
.81909 .12016 L
.85916 .09164 L
.89771 .06144 L
.93871 .0262 L
s
.93871 .0262 m
.96666 0 L
s
.02381 .30902 m
.06244 .30649 L
.10458 .30373 L
.14415 .30111 L
.18221 .29853 L
.22272 .2956 L
.26171 .29248 L
.30316 .28861 L
.34309 .28412 L
.3815 .27883 L
.42237 .27193 L
.46172 .26379 L
.49955 .25441 L
.53984 .24254 L
.57861 .22913 L
.61984 .21254 L
.65954 .19414 L
.69774 .17405 L
.73838 .14993 L
.77751 .12389 L
.81909 .09302 L
.85916 .06 L
.89771 .02505 L
s
.89771 .02505 m
.9229 0 L
s
.02381 .30902 m
.06244 .30649 L
.10458 .30373 L
.14415 .3011 L
.18221 .29849 L
.22272 .2955 L
.26171 .29224 L
.30316 .28811 L
.34309 .28321 L
.3815 .27736 L
.42237 .26965 L
.46172 .26053 L
.49955 .24998 L
.53984 .23664 L
.57861 .22156 L
.61984 .20293 L
.65954 .18228 L
.69774 .15974 L
.73838 .13269 L
.77751 .10351 L
.81909 .06893 L
.85916 .03195 L
s
.85916 .03195 m
.89064 0 L
s
.02381 .30902 m
.06244 .30649 L
.10458 .30373 L
.14415 .3011 L
.18221 .29846 L
.22272 .2954 L
.26171 .29201 L
.30316 .28763 L
.34309 .28233 L
.3815 .27596 L
.42237 .2675 L
.46172 .25746 L
.49955 .24586 L
.53984 .23118 L
.57861 .2146 L
.61984 .19412 L
.65954 .17143 L
.69774 .14668 L
.73838 .117 L
.77751 .08498 L
.81909 .04705 L
.85916 .00649 L
s
.85916 .00649 m
.865 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`003`3oool00`000000oooo0?ooo`3W0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`090?ooo`030000o`3oool0oooo00P0
oooo000?0?ooo`030000003oool0oooo0>H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`060?ooo`030000o`3oool0oooo00T0oooo00<0003o0?ooo`3oool02@3oool000l0oooo00<0
00000?ooo`3oool0i@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00<0
003o0?ooo`3oool02@3oool00`000?l0oooo0?ooo`0:0?ooo`003`3oool00`000000oooo0?ooo`3T
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`09
0?ooo`030000o`3oool0oooo00/0oooo000?0?ooo`030000003oool0oooo0><0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00P0oooo0P000?l>0?oo
o`003`3oool00`000000oooo0?ooo`3R0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01P3oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00h0oooo000?0?ooo`030000
003oool0oooo0>40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`030000
o`3oool0oooo00P0oooo00<0003o0?ooo`3oool03`3oool000l0oooo0P00003Q0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`080?ooo`030000o`3o
ool0oooo0100oooo000?0?ooo`030000003oool0oooo0=l0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool04@3oool0
00l0oooo00<000000?ooo`3oool0gP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00H0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`0B0?ooo`003`3oool00`000000
oooo0?ooo`3M0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0
oooo0?ooo`080?ooo`030000o`3oool0oooo01<0oooo000?0?ooo`030000003oool0oooo0=`0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00P0oooo
00<0003o0?ooo`3oool0503oool000l0oooo00<000000?ooo`3oool0f`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo0P000?l90?ooo`80003o5`3oool000l0oooo00<00000
0?ooo`3oool0fP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00<0003o
0?ooo`3oool0203oool00`000?l0oooo0?ooo`0?0?ooo`030000o`3oool0oooo00D0oooo000?0?oo
o`800000fP3oool00`000?l0oooo0?ooo`030?ooo`80003o1`3oool00`000?l0oooo0?ooo`080?oo
o`030000o`3oool0oooo00h0oooo0P000?l80?ooo`003`3oool00`000000oooo0?ooo`3H0?ooo`03
0000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`080?ooo`03
0000o`3oool0oooo00h0oooo00<0003o0?ooo`3oool0203oool000l0oooo00<000000?ooo`3oool0
e`3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0
203oool00`000?l0oooo0?ooo`0>0?ooo`030000o`3oool0oooo00T0oooo000?0?ooo`030000003o
ool0oooo0=H0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`060?ooo`030000o`3o
ool0oooo00P0oooo00<0003o0?ooo`3oool03@3oool20000o``0oooo000?0?ooo`030000003oool0
oooo0=D0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0
oooo00P0oooo00<0003o0?ooo`3oool03@3oool00`000?l0oooo0?ooo`0<0?ooo`003`3oool00`00
0000oooo0?ooo`3D0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01@3oool20000
o`T0oooo0P000?l?0?ooo`030000o`3oool0oooo00d0oooo000?0?ooo`030000003oool0oooo0=<0
oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0oooo00P0
oooo00<0003o0?ooo`3oool03@3oool20000oa00oooo000?0?ooo`800000d`3oool00`000?l0oooo
0?ooo`030?ooo`030000o`3oool0oooo00D0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo
0?ooo`0=0?ooo`030000o`3oool0oooo0100oooo000?0?ooo`030000003oool0oooo0=40oooo00<0
003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0oooo00P0oooo00<0
003o0?ooo`3oool0303oool20000oa<0oooo000?0?ooo`030000003oool0oooo0=00oooo00<0003o
0?ooo`3oool00`3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0oooo00P0oooo00<0003o
0?ooo`3oool0303oool00`000?l0oooo0?ooo`0C0?ooo`003`3oool00`000000oooo0?ooo`3?0?oo
o`030000o`3oool0oooo0080oooo0P000?l60?ooo`80003o2@3oool20000o`h0oooo00<0003o0?oo
o`3oool0503oool000l0oooo00<000000?ooo`3oool0cP3oool00`000?l0oooo0?ooo`020?ooo`03
0000o`3oool0oooo00D0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`0<0?ooo`80
003o5`3oool000T0oooo0`0000030?ooo`030000003oool0oooo0<`0oooo0P000?l40?ooo`030000
o`3oool0oooo00D0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`0<0?ooo`030000
o`3oool0oooo01L0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0b`3o
ool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo00D0oooo00<0003o0?ooo`3oool01`3o
ool20000o`h0oooo00<0003o0?ooo`3oool0603oool000L0oooo1@0000030?ooo`<00000bP3oool0
0`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo00@0oooo0P000?l90?ooo`030000o`3oool0
oooo00`0oooo0P000?lK0?ooo`0000<0oooo0000000000000P0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool0b@3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`0<0?ooo`030000o`3oool0
oooo01/0oooo00080?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0b03oool00`00
0?l0oooo0?ooo`020?ooo`80003o1P3oool00`000?l0oooo0?ooo`070?ooo`80003o3@3oool20000
oah0oooo00090?ooo`800000103oool00`000000oooo0?ooo`360?ooo`80003o103oool00`000?l0
oooo0?ooo`050?ooo`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3oool0303oool00`000?l0
oooo0?ooo`0N0?ooo`003`3oool00`000000oooo0?ooo`350?ooo`030000o`3oool0oooo00<0oooo
00<0003o0?ooo`3oool01@3oool00`000?l0oooo0?ooo`070?ooo`030000o`3oool0oooo00/0oooo
0P000?lQ0?ooo`003`3oool00`000000oooo0?ooo`340?ooo`030000o`3oool0oooo0080oooo0P00
0?l60?ooo`80003o203oool20000o``0oooo0P000?lK0?ooo`030000o`3oool0oooo00D0oooo000?
0?ooo`030000003oool0oooo0<80oooo0P000?l40?ooo`030000o`3oool0oooo00D0oooo00<0003o
0?ooo`3oool01`3oool00`000?l0oooo0?ooo`0;0?ooo`030000o`3oool0oooo01T0oooo0P000?l8
0?ooo`003`3oool00`000000oooo0?ooo`310?ooo`030000o`3oool0oooo00<0oooo00<0003o0?oo
o`3oool01@3oool00`000?l0oooo0?ooo`060?ooo`80003o303oool20000oaX0oooo0P000?l:0?oo
o`003`3oool200000<00oooo0P000?l40?ooo`80003o1P3oool20000o`P0oooo00<0003o0?ooo`3o
ool02`3oool00`000?l0oooo0?ooo`0H0?ooo`80003o303oool000l0oooo00<000000?ooo`3oool0
_P3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo00D0oooo00<0003o0?ooo`3oool0
1P3oool20000o``0oooo0P000?lI0?ooo`80003o3P3oool000l0oooo00<000000?ooo`3oool0_03o
ool20000o`@0oooo0P000?l60?ooo`80003o1`3oool20000o``0oooo0P000?lI0?ooo`80003o403o
ool000l0oooo00<000000?ooo`3oool0^`3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0
oooo00@0oooo0P000?l80?ooo`030000o`3oool0oooo00X0oooo0P000?lI0?ooo`80003o4P3oool0
00l0oooo00<000000?ooo`3oool0^@3oool20000o`@0oooo0P000?l60?ooo`030000o`3oool0oooo
00H0oooo0P000?l;0?ooo`80003o6@3oool20000oa@0oooo000?0?ooo`030000003oool0oooo0;P0
oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`040?ooo`80003o203oool00`000?l0
oooo0?ooo`090?ooo`80003o6@3oool20000oaH0oooo000?0?ooo`030000003oool0oooo0;H0oooo
0P000?l40?ooo`80003o1P3oool00`000?l0oooo0?ooo`060?ooo`80003o2`3oool00`000?l0oooo
0?ooo`0G0?ooo`80003o603oool000l0oooo0P00002f0?ooo`030000o`3oool0oooo00<0oooo00<0
003o0?ooo`3oool0103oool20000o`L0oooo0P000?l;0?ooo`80003o603oool20000oaX0oooo000?
0?ooo`030000003oool0oooo0;@0oooo00<0003o0?ooo`3oool00P3oool20000o`D0oooo0P000?l7
0?ooo`80003o2`3oool20000oaL0oooo0`000?lL0?ooo`003`3oool00`000000oooo0?ooo`2b0?oo
o`80003o103oool00`000?l0oooo0?ooo`030?ooo`80003o1`3oool20000o`/0oooo0P000?lG0?oo
o`80003o7`3oool000l0oooo00<000000?ooo`3oool0/@3oool00`000?l0oooo0?ooo`020?ooo`80
003o103oool20000o`L0oooo0P000?l;0?ooo`80003o5`3oool20000ob40oooo000?0?ooo`030000
003oool0oooo0:l0oooo0P000?l30?ooo`80003o103oool20000o`P0oooo00<0003o0?ooo`3oool0
2@3oool20000oaL0oooo0P000?lS0?ooo`003`3oool00`000000oooo0?ooo`2^0?ooo`030000o`3o
ool0oooo0080oooo00<0003o0?ooo`3oool00P3oool20000o`P0oooo0P000?l:0?ooo`80003o5`3o
ool20000obD0oooo000?0?ooo`030000003oool0oooo0:`0oooo0P000?l30?ooo`80003o0`3oool2
0000o`P0oooo0P000?l:0?ooo`80003o5P3oool30000obL0oooo000?0?ooo`800000Z`3oool20000
o`<0oooo0P000?l30?ooo`80003o203oool20000o`X0oooo0P000?lE0?ooo`<0003o:P3oool000l0
oooo00<000000?ooo`3oool0Z03oool20000o`@0oooo00<0003o0?ooo`3oool00P3oool00`000?l0
oooo0?ooo`060?ooo`80003o2P3oool20000oaD0oooo0P000?l]0?ooo`003`3oool00`000000oooo
0?ooo`2V0?ooo`80003o103oool20000o`<0oooo0P000?l70?ooo`80003o2P3oool20000oa@0oooo
0`000?l_0?ooo`003`3oool00`000000oooo0?ooo`2T0?ooo`80003o103oool20000o`<0oooo0P00
0?l70?ooo`80003o2@3oool30000oa<0oooo0`000?lb0?ooo`003`3oool00`000000oooo0?ooo`2S
0?ooo`030000o`3oool0oooo0080oooo0P000?l30?ooo`80003o1`3oool20000o`T0oooo0P000?lD
0?ooo`80003o=@3oool000L0oooo100000040?ooo`030000003oool0oooo0:40oooo0P000?l30?oo
o`80003o0`3oool20000o`L0oooo0P000?l90?ooo`80003o503oool20000ocL0oooo00070?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0W`3oool20000o`<0oooo0P000?l30?ooo`80
003o1`3oool20000o`P0oooo0`000?lD0?ooo`80003o>@3oool000P0oooo00<000000?ooo`3oool0
103oool3000009d0oooo0P000?l30?ooo`80003o0`3oool20000o`L0oooo0P000?l80?ooo`80003o
5@3oool20000oc/0oooo00000`3oool0000000000002000000@0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`2K0?ooo`80003o0`3oool20000o`<0oooo0P000?l60?ooo`<0003o1`3o
ool30000oa@0oooo0`000?lm0?ooo`001`3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo09T0oooo0P000?l30?ooo`80003o0P3oool30000o`D0oooo0`000?l80?ooo`80003o4`3o
ool40000od00oooo00080?ooo`8000001@3oool00`000000oooo0?ooo`2F0?ooo`<0003o0P3oool3
0000o`80oooo0P000?l60?ooo`80003o203oool30000oa40oooo10000?m40?ooo`003`3oool00`00
0000oooo0?ooo`2D0?ooo`80003o0`3oool20000o`<0oooo0P000?l50?ooo`<0003o203oool20000
oa40oooo0`000?m80?ooo`003`3oool00`000000oooo0?ooo`2A0?ooo`<0003o0P3oool30000o`80
oooo0`000?l40?ooo`<0003o203oool30000o`l0oooo10000?m;0?ooo`003`3oool00`000000oooo
0?ooo`2?0?ooo`80003o0`3oool20000o`<0oooo0P000?l40?ooo`<0003o203oool30000o`h0oooo
10000?m?0?ooo`003`3oool2000008d0oooo0`000?l20?ooo`<0003o0P3oool30000o`<0oooo0`00
0?l90?ooo`80003o3@3oool40000oe<0oooo000?0?ooo`030000003oool0oooo08T0oooo0`000?l3
0?ooo`80003o0`3oool20000o`<0oooo0`000?l90?ooo`<0003o303oool30000oeL0oooo000?0?oo
o`030000003oool0oooo08H0oooo0`000?l30?ooo`<0003o0P3oool30000o`80oooo0`000?l90?oo
o`<0003o2`3oool40000oeX0oooo000?0?ooo`030000003oool0oooo08<0oooo0`000?l30?ooo`<0
003o0`3oool20000o`80oooo0`000?l80?ooo`@0003o2`3oool30000oeh0oooo000?0?ooo`030000
003oool0oooo0800oooo0`000?l30?ooo`<0003o0`3oool70000o`L0oooo10000?l;0?ooo`@0003o
H@3oool000l0oooo00<000000?ooo`3oool0OP3oool20000o`<0oooo0`000?l20?ooo`L0003o1P3o
ool50000o`/0oooo10000?m=0?oooa40003o1`3oool000l0oooo00<000000?ooo`3oool0N`3oool3
0000o`80oooo0`000?l00`3oool0003o0000o`060000o`@0oooo1@000?l<0?ooo`@0003oAP3oool;
0000oaP0oooo000?0?ooo`030000003oool0oooo07T0oooo0P000?l20?ooo`/0003o103oool40000
o`/0oooo1P000?lo0?ooo`/0003o8`3oool000l0oooo0P00001f0?ooo`l0003o103oool40000o`T0
oooo1P000?l_0?oooaH0003o;P3oool000l0oooo00<000000?ooo`3oool0K`3oool@0000o`D0oooo
10000?l80?ooo`D0003o:P3oool;0000od@0oooo000?0?ooo`030000003oool0oooo06/0oooo3`00
0?l50?ooo`D0003o103oool80000oaT0oooo5P000?m?0?ooo`003`3oool00`000000oooo0?ooo`0J
0?ooo`800000103oool2000000<0oooo100000030?ooo`8000005P3oool2000000@0oooo0P000004
0?ooo`8000005@3oool>0000o`030000003oool0oooo0080oooo3P000?l?0?ooo`D000000P3oool;
0000o``0oooo1@0000020?ooo`8000000`3oool4000000<0oooo0P00000E0?ooo`D000000P3oool2
000000@0oooo0P00000P0?ooo`003`3oool00`000000oooo0?ooo`0I0?ooo`040000003oool0oooo
000000P0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000D0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool00000403oool<0000o`<0oooo3@000?lD0?ooo`/0
003o6@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3o
ool000005P3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000001l0oooo000?0?oo
o`030000003oool0oooo01T0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0180oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?oo
o`090?oooa`0003o0P3oool00`000000003o0000o`0D0000o`H0oooo00<000000?ooo`3oool06`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01d0oooo000?0?ooo`030000003oool0
oooo01T0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`020?ooo`8000005@3o
ool010000000oooo0?ooo`0000090?ooo`8000001`3ooolT0000oa`0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080oooo0P00000G0?ooo`030000
003oool0oooo00P0oooo0P00000P0?ooo`003`3oool2000001X0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo01@0oooo00@000000?ooo`3o
ool000002@3oool00`000000003o0000o`0O0000o`050?ooo`000000oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`0L0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool01`3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0O0?ooo`003`3oool00`000000oooo0?ooo`0J0?ooo`8000002P3oool2
000000@0oooo0`00000E0?ooo`8000008@000?l00`3oool00000000000090?ooo`@000000`3oool3
000001/0oooo0P00000L0?ooo`8000002P3oool2000000@0oooo0`00000E0?ooo`8000002P3oool3
000001l0oooo000?0?ooo`030000003oool0oooo03X0oooo5`000?nm0?ooo`003`3oool00`000000
oooo0?ooo`0_0?oooaL0003ob03oool000l0oooo00<000000?ooo`3oool0903oool;0000oml0oooo
000?0?ooo`030000003oool0oooo01T0oooo2`000?oZ0?ooo`003`3oool00`000000oooo0?ooo`03
0?oooaH0003om@3oool000P0oooo1`0000060000ool000003000000000l0oooo00<000000?ooo`3o
ool00`3ooolF0000o`<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool000l0oooo00<000000?ooo`3oool0
3P3ooolF0000o`030000003oool0oooo02@0oooo00<000000?ooo`3oool0903oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0903oool00`000000oooo
0?ooo`0T0?ooo`003`3oool00`000000oooo0?ooo`0T0?ooo`/0003og`3oool000l0oooo00<00000
0?ooo`3oool0;`3ooolF0000olT0oooo000?0?ooo`030000003oool0oooo03X0oooo5`000?nm0?oo
o`003`3oool00`000000oooo0?ooo`150?oooaH0003o/`3oool000l0oooo0P00001B0?ooob40003o
W03oool000l0oooo00<000000?ooo`3oool0F@3ooolS0000oi80oooo000?0?ooo`030000003oool0
oooo05h0oooo4@000?l30?ooo`P0003o0P3ooolF0000og`0oooo000?0?ooo`030000003oool0oooo
0680oooo4`000?l50?ooo`D0003o4`3oool;0000og40oooo000?0?ooo`030000003oool0oooo06H0
oooo5P000?l30?ooo`P0003o5P3oool<0000ofD0oooo000?0?ooo`030000003oool0oooo06X0oooo
40000?l20?ooo`L0003o103oool90000oaT0oooo5@000?m@0?ooo`003`3oool00`000000oooo0?oo
o`1_0?oooa00003o103oool40000o`T0oooo1@000?lY0?ooo``0003oA03oool000l0oooo0P00001f
0?ooo`h0003o103oool40000o`X0oooo1@000?l`0?oooaH0003o;P3oool000l0oooo00<000000?oo
o`3oool0N@3oool>0000o`@0oooo1@000?l:0?ooo`H0003o@03oool;0000ob<0oooo000?0?ooo`03
0000003oool0oooo07/0oooo0`000?l00`3oool0003o0000o`050000o`030?ooo`000?l0003o0080
003o1@3oool50000o`/0oooo1@000?m60?ooo`/0003o603oool000l0oooo00<000000?ooo`3oool0
OP3oool20000o`<0oooo1P000?l20?ooo`@0003o1P3oool40000o``0oooo10000?m=0?oooa40003o
1`3oool000l0oooo00<000000?ooo`3oool0P03oool30000o`<0oooo1P000?l30?ooo`<0003o1`3o
ool40000o``0oooo10000?mQ0?ooo`003`3oool00`000000oooo0?ooo`230?ooo`<0003o0`3oool6
0000o`<0oooo10000?l70?ooo`@0003o303oool30000oeh0oooo000?0?ooo`030000003oool0oooo
08H0oooo0`000?l30?ooo`H0003o103oool30000o`P0oooo10000?l;0?ooo`<0003oF`3oool000l0
oooo00<000000?ooo`3oool0R@3oool30000o`<0oooo0P000?l00`3oool0003o0000o`020000o`<0
oooo0`000?l90?ooo`<0003o2`3oool40000oeL0oooo000?0?ooo`800000S@3oool30000o`80oooo
0`000?l20?ooo`<0003o0`3oool30000o`T0oooo0P000?l=0?ooo`<0003oE03oool000l0oooo00<0
00000?ooo`3oool0S`3oool20000o`<0oooo0P000?l30?ooo`80003o103oool30000o`P0oooo0`00
0?l=0?ooo`@0003oD03oool000l0oooo00<000000?ooo`3oool0T@3oool30000o`80oooo0P000?l3
0?ooo`80003o1@3oool30000o`P0oooo0`000?l>0?ooo`@0003oC03oool000l0oooo00<000000?oo
o`3oool0U03oool20000o`80oooo0P000?l30?ooo`<0003o1@3oool30000o`P0oooo0P000?l@0?oo
o`@0003oB03oool000l0oooo00<000000?ooo`3oool0UP3oool20000o`80oooo0P000?l40?ooo`80
003o1P3oool20000o`P0oooo0`000?lA0?ooo`@0003oA03oool000L0oooo100000040?ooo`030000
003oool0oooo09P0oooo0P000?l20?ooo`80003o103oool30000o`D0oooo0`000?l80?ooo`80003o
4`3oool40000od00oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0VP3o
ool20000o`80oooo0P000?l50?ooo`80003o1P3oool20000o`P0oooo0`000?lD0?ooo`<0003o?@3o
ool000P0oooo00<000000?ooo`3oool0103oool3000009`0oooo0P000?l20?ooo`80003o1@3oool2
0000o`H0oooo0P000?l90?ooo`80003o5@3oool20000oc/0oooo00090?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0WP3oool20000o`80oooo0`000?l40?ooo`80003o1P3oool20000
o`T0oooo0P000?lE0?ooo`80003o>@3oool000L0oooo00@000000?ooo`3oool00000103oool00`00
0000oooo0?ooo`2P0?ooo`80003o0`3oool20000o`@0oooo0P000?l60?ooo`80003o2@3oool30000
oa@0oooo0P000?lg0?ooo`00203oool2000000D0oooo00<000000?ooo`3oool0XP3oool20000o`<0
oooo0P000?l40?ooo`80003o1P3oool20000o`X0oooo0P000?lD0?ooo`80003o=@3oool000l0oooo
00<000000?ooo`3oool0Y03oool20000o`<0oooo0P000?l40?ooo`80003o1P3oool20000o`X0oooo
0`000?lC0?ooo`<0003o<P3oool000l0oooo00<000000?ooo`3oool0YP3oool20000o`<0oooo0P00
0?l40?ooo`80003o1P3oool20000o`/0oooo0P000?lD0?ooo`<0003o;`3oool000l0oooo00<00000
0?ooo`3oool0Z03oool20000o`<0oooo0P000?l40?ooo`030000o`3oool0oooo00D0oooo0P000?l;
0?ooo`80003o5@3oool20000obd0oooo000?0?ooo`800000Z`3oool20000o`<0oooo0P000?l30?oo
o`80003o1`3oool20000o`/0oooo0P000?lE0?ooo`<0003o:P3oool000l0oooo00<000000?ooo`3o
ool0[03oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool20000o`L0oooo0P000?l;0?ooo`80
003o5P3oool30000obL0oooo000?0?ooo`030000003oool0oooo0:h0oooo00D0003o0?ooo`3oool0
oooo0000o`050?ooo`030000o`3oool0oooo00H0oooo0P000?l;0?ooo`80003o5`3oool20000obD0
oooo000?0?ooo`030000003oool0oooo0:l0oooo0P000?l20?ooo`80003o103oool20000o`P0oooo
0P000?l;0?ooo`80003o5`3oool20000ob<0oooo000?0?ooo`030000003oool0oooo0;40oooo00D0
003o0?ooo`3oool0oooo0000o`050?ooo`80003o203oool20000o`/0oooo0P000?lG0?ooo`80003o
8@3oool000l0oooo00<000000?ooo`3oool0/P3oool010000?l0oooo0?ooo`3oool20000o`D0oooo
0P000?l80?ooo`80003o2`3oool20000oaL0oooo0P000?lO0?ooo`003`3oool00`000000oooo0?oo
o`2c0?ooo`80003o0`3oool00`000?l0oooo0?ooo`040?ooo`80003o203oool20000o`/0oooo0P00
0?lG0?ooo`<0003o703oool000l0oooo0P00002f0?ooo`040000o`3oool0oooo0?ooo`80003o1P3o
ool20000o`P0oooo0P000?l;0?ooo`80003o603oool20000oaX0oooo000?0?ooo`030000003oool0
oooo0;H0oooo0P000?l30?ooo`80003o1P3oool20000o`P0oooo0P000?l;0?ooo`030000o`3oool0
oooo01L0oooo0P000?lH0?ooo`003`3oool00`000000oooo0?ooo`2h0?ooo`030000o`3oool0oooo
0080oooo00<0003o0?ooo`3oool01@3oool20000o`P0oooo00<0003o0?ooo`3oool02@3oool20000
oaT0oooo0P000?lF0?ooo`003`3oool00`000000oooo0?ooo`2i0?ooo`80003o0`3oool20000o`L0
oooo00<0003o0?ooo`3oool01P3oool20000o`/0oooo0P000?lI0?ooo`80003o503oool000l0oooo
00<000000?ooo`3oool0^`3oool00`000?l0oooo0?ooo`020?ooo`80003o1P3oool00`000?l0oooo
0?ooo`070?ooo`030000o`3oool0oooo00X0oooo0P000?lI0?ooo`80003o4P3oool000l0oooo00<0
00000?ooo`3oool0_03oool20000o`@0oooo0P000?l50?ooo`80003o203oool00`000?l0oooo0?oo
o`0;0?ooo`80003o6@3oool20000oa00oooo000?0?ooo`030000003oool0oooo0;h0oooo00<0003o
0?ooo`3oool00`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo0P000?l=
0?ooo`80003o6@3oool20000o`h0oooo000?0?ooo`800000`03oool20000o`@0oooo0P000?l50?oo
o`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3oool0303oool00`000?l0oooo0?ooo`0H0?oo
o`80003o303oool000l0oooo00<000000?ooo`3oool0`@3oool00`000?l0oooo0?ooo`030?ooo`03
0000o`3oool0oooo00<0oooo0P000?l80?ooo`030000o`3oool0oooo00`0oooo0P000?lJ0?ooo`80
003o2P3oool000l0oooo00<000000?ooo`3oool0`P3oool20000o`@0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`80003o3P3oool00`000?l0oooo0?ooo`0I0?ooo`80003o
203oool000l0oooo00<000000?ooo`3oool0a03oool00`000?l0oooo0?ooo`020?ooo`80003o1@3o
ool20000o`P0oooo00<0003o0?ooo`3oool0303oool20000oa/0oooo00<0003o0?ooo`3oool01@3o
ool000l0oooo00<000000?ooo`3oool0a@3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool20000o`h0oooo0P000?lQ0?ooo`003`3oool00`00
0000oooo0?ooo`360?ooo`80003o103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00L0oooo00<0003o0?ooo`3oool03@3oool00`000?l0oooo0?ooo`0N0?ooo`002@3oool3000000<0
oooo00<000000?ooo`3oool0b03oool00`000?l0oooo0?ooo`020?ooo`80003o1@3oool20000o`P0
oooo0P000?l>0?ooo`80003o7P3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`390?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`070?ooo`80003o3P3oool00`000?l0oooo0?ooo`0K0?ooo`001`3oool5000000<0oooo0`00
003:0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`080?ooo`030000o`3oool0oooo00`0oooo0P000?lK0?ooo`001`3oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo0</0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?oo
o`040?ooo`80003o2@3oool20000o`h0oooo00<0003o0?ooo`3oool0603oool000P0oooo00<00000
0?ooo`000000103oool00`000000oooo0?ooo`3<0?ooo`80003o103oool00`000?l0oooo0?ooo`05
0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0303oool00`000?l0oooo0?ooo`0G
0?ooo`002@3oool2000000@0oooo00<000000?ooo`3oool0cP3oool00`000?l0oooo0?ooo`020?oo
o`030000o`3oool0oooo00D0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`0<0?oo
o`80003o5`3oool000l0oooo00<000000?ooo`3oool0c`3oool00`000?l0oooo0?ooo`020?ooo`80
003o1P3oool20000o`T0oooo0P000?l>0?ooo`030000o`3oool0oooo01@0oooo000?0?ooo`030000
003oool0oooo0=00oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`050?ooo`030000
o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0303oool00`000?l0oooo0?ooo`0C0?ooo`003`3o
ool00`000000oooo0?ooo`3A0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01@3o
ool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00`0oooo0P000?lC0?ooo`003`3oool2
00000=<0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0
oooo00P0oooo00<0003o0?ooo`3oool03@3oool00`000?l0oooo0?ooo`0@0?ooo`003`3oool00`00
0000oooo0?ooo`3C0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01@3oool00`00
0?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00d0oooo0P000?l@0?ooo`003`3oool00`000000
oooo0?ooo`3D0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01@3oool20000o`T0
oooo0P000?l?0?ooo`030000o`3oool0oooo00d0oooo000?0?ooo`030000003oool0oooo0=D0oooo
00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00P0oooo
00<0003o0?ooo`3oool03@3oool00`000?l0oooo0?ooo`0<0?ooo`003`3oool00`000000oooo0?oo
o`3F0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?oo
o`080?ooo`030000o`3oool0oooo00d0oooo0P000?l<0?ooo`003`3oool00`000000oooo0?ooo`3G
0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`08
0?ooo`030000o`3oool0oooo00h0oooo00<0003o0?ooo`3oool02@3oool000l0oooo00<000000?oo
o`3oool0f03oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo00H0oooo00<0003o0?oo
o`3oool0203oool00`000?l0oooo0?ooo`0>0?ooo`030000o`3oool0oooo00P0oooo000?0?ooo`80
0000fP3oool00`000?l0oooo0?ooo`030?ooo`80003o1`3oool00`000?l0oooo0?ooo`080?ooo`03
0000o`3oool0oooo00h0oooo0P000?l80?ooo`003`3oool00`000000oooo0?ooo`3J0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool00`000?l0oooo0?ooo`080?ooo`030000
o`3oool0oooo00l0oooo00<0003o0?ooo`3oool01@3oool000l0oooo00<000000?ooo`3oool0f`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo0P000?l90?ooo`80003o5`3o
ool000l0oooo00<000000?ooo`3oool0g03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00H0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`0D0?ooo`003`3oool00`00
0000oooo0?ooo`3M0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`00
0?l0oooo0?ooo`080?ooo`030000o`3oool0oooo01<0oooo000?0?ooo`030000003oool0oooo0=h0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00P0
oooo00<0003o0?ooo`3oool04P3oool000l0oooo00<000000?ooo`3oool0g`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo
0?ooo`0A0?ooo`003`3oool200000>40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`060?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0403oool000l0oooo00<00000
0?ooo`3oool0h@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00<0003o
0?ooo`3oool0203oool00`000?l0oooo0?ooo`0?0?ooo`003`3oool00`000000oooo0?ooo`3R0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`080?oo
o`030000o`3oool0oooo00h0oooo000?0?ooo`030000003oool0oooo0><0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3o
ool03@3oool000l0oooo00<000000?ooo`3oool0i03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0203oool20000o`d0oooo000?0?ooo`030000003o
ool0oooo0>D0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`030000o`3o
ool0oooo00T0oooo00<0003o0?ooo`3oool02P3oool000l0oooo00<000000?ooo`3oool0iP3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool02@3oool0
0`000?l0oooo0?ooo`090?ooo`003`3oool00`000000oooo0?ooo`3W0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`090?ooo`030000o`3oool0oooo
00P0oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{81, 368}, {260.188, 83.25}} -> {-0.619154, -0.362134, \
0.00641756, 0.0693836}},
  CellTags->"b:1.1.0.2"]
}, Open  ]],

Cell[TextData[{
  "If an initial condition is specified, ",
  StyleBox["DSolve", "MR"],
  " picks the branch that passes through the initial point.  The ",
  StyleBox["DSolve::bvnul", "MR"],
  " message indicates that one branch of the general solution (the lower \
branch in the previous graph) did not give a solution satisfying the given \
initial condition ",
  Cell[BoxData[
      \(y[1] \[Equal] 3\)]],
  ". "
}], "MathCaption",
  CellTags->"b:1.1.0.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{eqn, \ y[1] \[Equal] 3}, \ y[x], x]\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    RowBox[{\(DSolve::"bvnul"\), \(\(:\)\(\ \)\), "\<\"For some branches of \
the general solution, the given boundary conditions lead to an empty \
solution. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"DSolve::bvnul\\\"]\\)\"\>"}]], "Message",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    \({{y[x] \[Rule] \@\(x\^2 + 17\ x\^6\)\/\@2}}\)], "Output",
  CellLabel->"Out[45]=",
  CellTags->"b:1.1.0.2"]
}, Open  ]],

Cell[TextData[{
  "The following is a linear first-order ODE because both ",
  StyleBox["y[x]", "MR"],
  " and ",
  Cell[BoxData[
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]]],
  " occur in it with power 1 and ",
  Cell[BoxData[
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]]],
  " is the highest derivative. Note that the solution contains the imaginary \
error function ",
  ButtonBox["Erfi",
    ButtonStyle->"RefGuideLink"],
  StyleBox[".", "TR"],
  " "
}], "MathCaption",
  CellTags->{"LinearODE", "b:1.1.0.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y'\)[x]\  + \ x*y[x]\  \[Equal] \ Exp[3  x], \ y[x], 
      x]\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(-\(x\^2\/2\)\)\ C[
                1] + \[ExponentialE]\^\(\(-\(9\/2\)\) - x\^2\/2\)\ \
\@\(\[Pi]\/2\)\ Erfi[\(3 + x\)\/\@2]}}\)], "Output",
  CellLabel->"Out[46]=",
  CellTags->"b:1.1.0.2"]
}, Open  ]],

Cell[TextData[{
  "Here is the solution for a general linear first-order ODE. The ",
  StyleBox["K$", "MR"],
  " variables are used as dummy variables for integration. The ",
  StyleBox["Erfi", "MR"],
  " term in the previous example comes from the nested integral in the second \
term of the general solution as follows."
}], "MathCaption",
  CellTags->{"k$_variables", "b:1.1.0.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[\(y'\)[x]\  + \ P[x]*y[x]\  \[Equal] \ Q[x], \ y[x], 
        x]\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(\[Integral]\_1\%x\(-P[K$4291]\) \
\[DifferentialD]K$4291\)\ C[
                1] + \[ExponentialE]\^\(\[Integral]\_1\%x\(-P[K$4291]\) \
\[DifferentialD]K$4291\)\ \(\[Integral]\_1\%x\( \[ExponentialE]\^\(-\(\
\[Integral]\_1\%K$4310\(-P[K$4291]\) \[DifferentialD]K$4291\)\)\ Q[
                      K$4310]\) \[DifferentialD]K$4310\)}}\)], "Output",
  CellLabel->"Out[47]=",
  CellTags->"b:1.1.0.2"]
}, Open  ]],

Cell[TextData[{
  "A more traditional form of the solution can be obtained by replacing the \
",
  StyleBox["K$", "MR"],
  StyleBox[" variables", "TR"],
  " with variables such as ",
  StyleBox["r", "MR"],
  " and ",
  StyleBox["t", "MR"],
  ". You may need to change the actual numbers in ",
  StyleBox["K$", "MR"],
  StyleBox["xxx",
    FontSlant->"Italic"],
  " because these variables are given unique names during every evaluation."
}], "MathCaption",
  CellTags->"b:1.1.0.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol /. {K$65\  \[Rule] r, \ K$87\  \[Rule] \ t}\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(\[Integral]\_1\%x\(-P[K$4291]\) \
\[DifferentialD]K$4291\)\ C[
                1] + \[ExponentialE]\^\(\[Integral]\_1\%x\(-P[K$4291]\) \
\[DifferentialD]K$4291\)\ \(\[Integral]\_1\%x\( \[ExponentialE]\^\(-\(\
\[Integral]\_1\%K$4310\(-P[K$4291]\) \[DifferentialD]K$4291\)\)\ Q[
                      K$4310]\) \[DifferentialD]K$4310\)}}\)], "Output",
  CellLabel->"Out[48]=",
  CellTags->"b:1.1.0.2"]
}, Open  ]],

Cell[TextData[{
  "It may happen that a given ODE is not linear in ",
  StyleBox["y(x)",
    FontSlant->"Italic"],
  " but can be viewed as a linear ODE in ",
  StyleBox["x(y)",
    FontSlant->"Italic"],
  ". In this case, it is said to be an",
  StyleBox[" inverse linear ",
    FontSlant->"Italic"],
  "ODE."
}], "Text",
  CellTags->"b:1.1.0.2"],

Cell[TextData[{
  "This is a inverse linear ODE. It is constructed by interchanging ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " in an earlier example."
}], "MathCaption",
  CellTags->"b:1.1.0.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y'\)[x] \[Equal] \ 1/\((\(-x\)*y[x]\  + Exp[3*y[x]])\), \ 
      y[x], x]\)], "Input",
  CellLabel->"In[49]:=",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.2"],

Cell[BoxData[
    \(Solve[
      x \[Equal] \[ExponentialE]\^\(\(-\(1\/2\)\)\ y[x]\^2\)\ C[
              1] + \[ExponentialE]\^\(\(-\(9\/2\)\) - y[x]\^2\/2\)\ \@\(\[Pi]\
\/2\)\ Erfi[\(3 + y[x]\)\/\@2], y[x]]\)], "Output",
  CellLabel->"Out[49]=",
  CellTags->"b:1.1.0.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bernoulli Equations", "Subsubsection",
  CellTags->{"BernoulliODE", "c:12", "b:1.1.0.3"}],

Cell[TextData[{
  "Here is an example of a ",
  ButtonBox["Bernoulli equation",
    ButtonData:>"EquationTypes",
    ButtonStyle->"Hyperlink"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.0.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqn = \(y'\)[x] + 11  x*y[x] \[Equal] x^3*y[x]^3\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->"b:1.1.0.3"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(11\ x\ y[x]\), "+", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], 
      "\[Equal]", \(x\^3\ y[x]\^3\)}]], "Output",
  CellLabel->"Out[50]=",
  CellTags->"b:1.1.0.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[eqn, \ y, x]\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->"b:1.1.0.3"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, \(-\(11\/\@\(1 + 11\ x\^2 + 121\ \
\[ExponentialE]\^\(11\ x\^2\)\ C[1]\)\)\)]}, {y \[Rule] 
          Function[{x}, 
            11\/\@\(1 + 11\ x\^2 + 121\ \[ExponentialE]\^\(11\ x\^2\)\ \
C[1]\)]}}\)], "Output",
  CellLabel->"Out[51]=",
  CellTags->"b:1.1.0.3"]
}, Open  ]],

Cell["This verifies that the solution is correct.", "MathCaption",
  CellTags->"b:1.1.0.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqn /. sol // Simplify\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->"b:1.1.0.3"],

Cell[BoxData[
    \({True, True}\)], "Output",
  CellLabel->"Out[52]=",
  CellTags->"b:1.1.0.3"]
}, Open  ]],

Cell[TextData[{
  "In general, the solution to a Bernoulli equation will consist of ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  " branches, where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is the degree of ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  " in the equation. "
}], "Text",
  CellTags->"b:1.1.0.3"],

Cell[TextData[{
  "Here is an example of a Bernoulli equation with ",
  StyleBox["n",
    FontSlant->"Italic"],
  " = 5. The solution has four branches."
}], "MathCaption",
  CellTags->"b:1.1.0.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[3  x*\(y'\)[x]\  - 7  x*Log[x]*y[x]^5 - y[x] \[Equal] 0, \ y[x], 
      x]\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->"b:1.1.0.3"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(-\(\(7\^\(1/4\)\ x\^\(1/3\)\)\/\((12\ x\^\(7/3\) + 7\
\ C[1] - 28\ x\^\(7/3\)\ Log[x])\)\^\(1/4\)\)\)}, {y[
            x] \[Rule] \(-\(\(\[ImaginaryI]\ 7\^\(1/4\)\ x\^\(1/3\)\)\/\((12\ \
x\^\(7/3\) + 7\ C[1] - 28\ x\^\(7/3\)\ Log[x])\)\^\(1/4\)\)\)}, {y[
            x] \[Rule] \(\[ImaginaryI]\ 7\^\(1/4\)\ x\^\(1/3\)\)\/\((12\ \
x\^\(7/3\) + 7\ C[1] - 28\ x\^\(7/3\)\ Log[x])\)\^\(1/4\)}, {y[
            x] \[Rule] \(7\^\(1/4\)\ x\^\(1/3\)\)\/\((12\ x\^\(7/3\) + 7\ \
C[1] - 28\ x\^\(7/3\)\ Log[x])\)\^\(1/4\)}}\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->"b:1.1.0.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Riccati Equations", "Subsubsection",
  CellTags->{"RiccatiODE", "c:13", "b:1.1.0.4"}],

Cell[TextData[{
  "Solving ",
  ButtonBox["Riccati equations",
    ButtonData:>"EquationTypes",
    ButtonStyle->"Hyperlink"],
  " is considerably more difficult than any of the preceding types of ODEs. "
}], "Text",
  CellTags->"b:1.1.0.4"],

Cell["\<\
Here is a simple Riccati equation for which the solution is \
available in closed form.\
\>", "MathCaption",
  CellTags->"b:1.1.0.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y'\)[x]\  + \((2/x^2)\) - 3  y[x]^2 \[Equal] 0, \ y[x], \ x] // 
      Simplify\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->"b:1.1.0.4"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(-\(\(3\ x\^5 - 2\ C[1]\)\/\(3\ x\^6 + 
                  3\ x\ C[1]\)\)\)}}\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->"b:1.1.0.4"]
}, Open  ]],

Cell["\<\
Any Riccati equation can be transformed to a second-order linear \
ODE. If the latter can be solved explicitly, then a solution for the Riccati \
equation can be derived. \
\>", "Text",
  CellTags->"b:1.1.0.4"],

Cell["\<\
Here is an example of a Riccati equation and the corresponding \
second-order ODE, which is Legendre\[CloseCurlyQuote]s equation.\
\>", \
"MathCaption",
  CellTags->"b:1.1.0.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(u'\)[
            x] \[Equal] \((\((2  x)\)/\((1 - x^2)\))\)*
              u[x] - \((\((15/4)\)/\((1 - x^2)\))\) - u[x]^2, \ u[x], x] // 
      Simplify\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->"b:1.1.0.4"],

Cell[BoxData[
    \({{u[
            x] \[Rule] \((3\ \((\(-C[1]\)\ LegendreP[1\/2, x] + 
                    x\ C[1]\ LegendreP[3\/2, x] - LegendreQ[1\/2, x] + 
                    x\ LegendreQ[3\/2, x])\))\)/\((2\ \((\(-1\) + 
                    x\^2)\)\ \((C[1]\ LegendreP[3\/2, x] + 
                    LegendreQ[3\/2, x])\))\)}}\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->"b:1.1.0.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\((1 - x^2)\)*\(y''\)[x]\  - 
          2  x*\(y'\)[x]\  + \((15/4)\)*y[x] \[Equal] 0, \ y[x], 
      x]\)], "Input",
  CellLabel->"In[56]:=",
  CellTags->"b:1.1.0.4"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          C[1]\ LegendreP[3\/2, x] + C[2]\ LegendreQ[3\/2, x]}}\)], "Output",
  CellLabel->"Out[56]=",
  CellTags->"b:1.1.0.4"]
}, Open  ]],

Cell["\<\
Finally, consider the following Riccati equation. It integrable \
because the sum of the coefficients on the right-hand side is 0.\
\>", \
"MathCaption",
  CellTags->"b:1.1.0.4"],

Cell[BoxData[
    \(eqn = \(y'\)[x] \[Equal] \ 
        3  x + 5*y[x] - \((3  x + 5)\)*y[x]^2; \)], "Input",
  CellLabel->"In[57]:=",
  CellTags->"b:1.1.0.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[eqn, \ y, x]\)], "Input",
  CellLabel->"In[58]:=",
  CellTags->"b:1.1.0.4"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            1 + \[ExponentialE]\^\(\(-5\)\ x - 3\ x\^2\)\/\(C[1] + 1\/12\ \((\
\(-6\)\ \[ExponentialE]\^\(\(-x\)\ \((5 + 3\ x)\)\) + 5\ \
\[ExponentialE]\^\(25/12\)\ \@\(3\ \[Pi]\)\ Erf[\(5 + 6\ x\)\/\(2\ \
\@3\)])\)\)]}}\)], "Output",
  CellLabel->"Out[58]=",
  CellTags->"b:1.1.0.4"]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
  CellTags->"b:1.1.0.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqn /. sol // Simplify\)], "Input",
  CellLabel->"In[59]:=",
  CellTags->"b:1.1.0.4"],

Cell[BoxData[
    \({True}\)], "Output",
  CellLabel->"Out[59]=",
  CellTags->"b:1.1.0.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exact Equations", "Subsubsection",
  CellTags->{"ExactODE", "c:14", "b:1.1.0.5"}],

Cell[TextData[{
  "Here is an example of an ",
  ButtonBox["exact ODE",
    ButtonData:>"EquationTypes",
    ButtonStyle->"Hyperlink"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.0.5"],

Cell[BoxData[
    \(P[x_, y_] := \(-\((5  x^2 - 2  y^2 + 11)\)\)\)], "Input",
  CellLabel->"In[60]:=",
  CellTags->"b:1.1.0.5"],

Cell[BoxData[
    \(Q[x_, y_] := \((Sin[y] + 4  x*y + 3)\)\)], "Input",
  CellLabel->"In[61]:=",
  CellTags->"b:1.1.0.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[D[P[x, y], y]\  - D[Q[x, y], x]]\)], "Input",
  CellLabel->"In[62]:=",
  CellTags->"b:1.1.0.5"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[62]=",
  CellTags->"b:1.1.0.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqn = \(y'\)[x] == \(-P[x, y[x]]\)/Q[x, y[x]]\)], "Input",
  CellLabel->"In[63]:=",
  CellTags->"b:1.1.0.5"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], 
      "\[Equal]", \(\(11 + 5\ x\^2 - 2\ y[x]\^2\)\/\(3 + Sin[y[x]] + 
            4\ x\ y[x]\)\)}]], "Output",
  CellLabel->"Out[63]=",
  CellTags->"b:1.1.0.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[eqn, \ y[x], x]\)], "Input",
  CellLabel->"In[64]:=",
  CellTags->"b:1.1.0.5"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.5"],

Cell[BoxData[
    \(Solve[\(-11\)\ x - \(5\ x\^3\)\/3 - Cos[y[x]] + 3\ y[x] + 
          2\ x\ y[x]\^2 \[Equal] C[1], y[x]]\)], "Output",
  CellLabel->"Out[64]=",
  CellTags->"b:1.1.0.5"]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
  CellTags->"b:1.1.0.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[D[sol[\([\)\(1\)\(]\)], x], \ \(y'\)[x]] // Simplify\)], "Input",
  CellLabel->"In[65]:=",
  CellTags->"b:1.1.0.5"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Rule]", \(\(11 + 5\ x\^2 - 2\ y[x]\^2\)\/\(3 + Sin[y[x]] + 
                4\ x\ y[x]\)\)}], "}"}], "}"}]], "Output",
  CellLabel->"Out[65]=",
  CellTags->"b:1.1.0.5"]
}, Open  ]],

Cell["Here is a contour plot of the solution.", "MathCaption",
  CellTags->"b:1.1.0.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[
      Evaluate[sol[\([\)\(1, 1\)\(]\)] /. {y[x] \[Rule] \ y}], \ {x, \(-5\), 
        5}, \ {y, \(-5\), 5}, \ PlotPoints\  \[Rule] \ 30, \ 
      ColorFunction\  \[Rule] \ Hue]; \)], "Input",
  CellLabel->"In[66]:=",
  CellTags->"b:1.1.0.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0961538 0.5 0.0961538 [
[.11538 -0.0125 -6 -9 ]
[.11538 -0.0125 6 0 ]
[.30769 -0.0125 -6 -9 ]
[.30769 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.69231 -0.0125 -3 -9 ]
[.69231 -0.0125 3 0 ]
[.88462 -0.0125 -3 -9 ]
[.88462 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .11538 -12 -4.5 ]
[-0.0125 .11538 0 4.5 ]
[-0.0125 .30769 -12 -4.5 ]
[-0.0125 .30769 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .69231 -6 -4.5 ]
[-0.0125 .69231 0 4.5 ]
[-0.0125 .88462 -6 -4.5 ]
[-0.0125 .88462 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11538 0 m
.11538 .00625 L
s
[(-4)] .11538 -0.0125 0 1 Mshowa
.30769 0 m
.30769 .00625 L
s
[(-2)] .30769 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.69231 0 m
.69231 .00625 L
s
[(2)] .69231 -0.0125 0 1 Mshowa
.88462 0 m
.88462 .00625 L
s
[(4)] .88462 -0.0125 0 1 Mshowa
.125 Mabswid
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.25962 0 m
.25962 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.74038 0 m
.74038 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.06731 0 m
.06731 .00375 L
s
.01923 0 m
.01923 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.98077 0 m
.98077 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .11538 m
.00625 .11538 L
s
[(-4)] -0.0125 .11538 1 0 Mshowa
0 .30769 m
.00625 .30769 L
s
[(-2)] -0.0125 .30769 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .69231 m
.00625 .69231 L
s
[(2)] -0.0125 .69231 1 0 Mshowa
0 .88462 m
.00625 .88462 L
s
[(4)] -0.0125 .88462 1 0 Mshowa
.125 Mabswid
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .25962 m
.00375 .25962 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .74038 m
.00375 .74038 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .06731 m
.00375 .06731 L
s
0 .01923 m
.00375 .01923 L
s
0 .93269 m
.00375 .93269 L
s
0 .98077 m
.00375 .98077 L
s
.25 Mabswid
0 0 m
0 1 L
s
.11538 .99375 m
.11538 1 L
s
.30769 .99375 m
.30769 1 L
s
.5 .99375 m
.5 1 L
s
.69231 .99375 m
.69231 1 L
s
.88462 .99375 m
.88462 1 L
s
.125 Mabswid
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.25962 .99625 m
.25962 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.74038 .99625 m
.74038 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.06731 .99625 m
.06731 1 L
s
.01923 .99625 m
.01923 1 L
s
.93269 .99625 m
.93269 1 L
s
.98077 .99625 m
.98077 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .11538 m
1 .11538 L
s
.99375 .30769 m
1 .30769 L
s
.99375 .5 m
1 .5 L
s
.99375 .69231 m
1 .69231 L
s
.99375 .88462 m
1 .88462 L
s
.125 Mabswid
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .25962 m
1 .25962 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .74038 m
1 .74038 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .06731 m
1 .06731 L
s
.99625 .01923 m
1 .01923 L
s
.99625 .93269 m
1 .93269 L
s
.99625 .98077 m
1 .98077 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 .4 1 r
.01923 .04401 m
.02855 .05239 L
.05239 .07465 L
.064 .08554 L
.08554 .10567 L
.09921 .1187 L
.1187 .13725 L
.13362 .15186 L
.15186 .16975 L
.16685 .18501 L
.18501 .2037 L
.19839 .21817 L
.21817 .24007 L
.22767 .25133 L
.25133 .28065 L
.25415 .28448 L
.27717 .31764 L
.28448 .32925 L
.29653 .3508 L
.31238 .38395 L
.31764 .39671 L
.32477 .41711 L
.33412 .45027 L
.34077 .48342 L
.34488 .51658 L
.34646 .54973 L
.34531 .58289 L
.34093 .61605 L
.33258 .6492 L
.31948 .68236 L
.31764 .68627 L
.3004 .71552 L
.28448 .73805 L
.27571 .74867 L
.25133 .77625 L
.24586 .78183 L
.21817 .80939 L
.21216 .81499 L
.18501 .84016 L
.17601 .84814 L
.15186 .86973 L
.13852 .8813 L
.1187 .8987 L
.10038 .91446 L
.08554 .92739 L
.06199 .94761 L
.05239 .95596 L
.02384 .98077 L
.01923 .98077 L
F
0 g
.01923 .04401 m
.02855 .05239 L
.05239 .07465 L
.064 .08554 L
.08554 .10567 L
.09921 .1187 L
.1187 .13725 L
.13362 .15186 L
.15186 .16975 L
.16685 .18501 L
.18501 .2037 L
.19839 .21817 L
.21817 .24007 L
.22767 .25133 L
.25133 .28065 L
.25415 .28448 L
.27717 .31764 L
.28448 .32925 L
.29653 .3508 L
.31238 .38395 L
.31764 .39671 L
.32477 .41711 L
.33412 .45027 L
.34077 .48342 L
.34488 .51658 L
.34646 .54973 L
.34531 .58289 L
.34093 .61605 L
.33258 .6492 L
.31948 .68236 L
.31764 .68627 L
.3004 .71552 L
.28448 .73805 L
.27571 .74867 L
.25133 .77625 L
.24586 .78183 L
.21817 .80939 L
.21216 .81499 L
.18501 .84016 L
.17601 .84814 L
.15186 .86973 L
.13852 .8813 L
.1187 .8987 L
.10038 .91446 L
.08554 .92739 L
.06199 .94761 L
.05239 .95596 L
.02384 .98077 L
s
.2 0 1 r
.01923 .93276 m
.03604 .91446 L
.05239 .89582 L
.06481 .8813 L
.08554 .85629 L
.09197 .84814 L
.11697 .81499 L
.1187 .81258 L
.13935 .78183 L
.15186 .76143 L
.159 .74867 L
.17568 .71552 L
.18501 .69388 L
.18936 .68236 L
.20005 .6492 L
.20798 .61605 L
.21327 .58289 L
.21608 .54973 L
.21653 .51658 L
.2147 .48342 L
.21062 .45027 L
.20427 .41711 L
.19558 .38395 L
.18501 .35213 L
.18451 .3508 L
.17084 .31764 L
.15471 .28448 L
.15186 .27908 L
.13598 .25133 L
.1187 .22384 L
.1149 .21817 L
.0915 .18501 L
.08554 .17696 L
.06606 .15186 L
.05239 .13486 L
.03903 .1187 L
.01923 .09578 L
F
0 g
.01923 .93276 m
.03604 .91446 L
.05239 .89582 L
.06481 .8813 L
.08554 .85629 L
.09197 .84814 L
.11697 .81499 L
.1187 .81258 L
.13935 .78183 L
.15186 .76143 L
.159 .74867 L
.17568 .71552 L
.18501 .69388 L
.18936 .68236 L
.20005 .6492 L
.20798 .61605 L
.21327 .58289 L
.21608 .54973 L
.21653 .51658 L
.2147 .48342 L
.21062 .45027 L
.20427 .41711 L
.19558 .38395 L
.18501 .35213 L
.18451 .3508 L
.17084 .31764 L
.15471 .28448 L
.15186 .27908 L
.13598 .25133 L
.1187 .22384 L
.1149 .21817 L
.0915 .18501 L
.08554 .17696 L
.06606 .15186 L
.05239 .13486 L
.03903 .1187 L
.01923 .09578 L
s
.8 0 1 r
.01923 .87355 m
.03685 .84814 L
.05239 .82387 L
.05779 .81499 L
.07662 .78183 L
.08554 .76459 L
.09313 .74867 L
.10723 .71552 L
.1187 .68322 L
.11897 .68236 L
.12829 .6492 L
.13536 .61605 L
.14024 .58289 L
.14302 .54973 L
.14377 .51658 L
.14252 .48342 L
.13929 .45027 L
.13408 .41711 L
.12684 .38395 L
.1187 .35447 L
.11754 .3508 L
.10607 .31764 L
.09247 .28448 L
.08554 .26928 L
.0767 .25133 L
.05881 .21817 L
.05239 .20708 L
.03896 .18501 L
.01923 .15508 L
F
0 g
.01923 .87355 m
.03685 .84814 L
.05239 .82387 L
.05779 .81499 L
.07662 .78183 L
.08554 .76459 L
.09313 .74867 L
.10723 .71552 L
.1187 .68322 L
.11897 .68236 L
.12829 .6492 L
.13536 .61605 L
.14024 .58289 L
.14302 .54973 L
.14377 .51658 L
.14252 .48342 L
.13929 .45027 L
.13408 .41711 L
.12684 .38395 L
.1187 .35447 L
.11754 .3508 L
.10607 .31764 L
.09247 .28448 L
.08554 .26928 L
.0767 .25133 L
.05881 .21817 L
.05239 .20708 L
.03896 .18501 L
.01923 .15508 L
s
1 0 .6 r
.01923 .80201 m
.02929 .78183 L
.04402 .74867 L
.05239 .72735 L
.05664 .71552 L
.06719 .68236 L
.0757 .6492 L
.08221 .61605 L
.08554 .59406 L
.08676 .58289 L
.08942 .54973 L
.09025 .51658 L
.08928 .48342 L
.08651 .45027 L
.08554 .44142 L
.08193 .41711 L
.0755 .38395 L
.06721 .3508 L
.05702 .31764 L
.05239 .30426 L
.04493 .28448 L
.03089 .25133 L
.01923 .22691 L
F
0 g
.01923 .80201 m
.02929 .78183 L
.04402 .74867 L
.05239 .72735 L
.05664 .71552 L
.06719 .68236 L
.0757 .6492 L
.08221 .61605 L
.08554 .59406 L
.08676 .58289 L
.08942 .54973 L
.09025 .51658 L
.08928 .48342 L
.08651 .45027 L
.08554 .44142 L
.08193 .41711 L
.0755 .38395 L
.06721 .3508 L
.05702 .31764 L
.05239 .30426 L
.04493 .28448 L
.03089 .25133 L
.01923 .22691 L
s
1 0 0 r
.01923 .70352 m
.02527 .68236 L
.03319 .6492 L
.03925 .61605 L
.04354 .58289 L
.04609 .54973 L
.04695 .51658 L
.04614 .48342 L
.04366 .45027 L
.03951 .41711 L
.03366 .38395 L
.02607 .3508 L
.01923 .32603 L
F
0 g
.01923 .70352 m
.02527 .68236 L
.03319 .6492 L
.03925 .61605 L
.04354 .58289 L
.04609 .54973 L
.04695 .51658 L
.04614 .48342 L
.04366 .45027 L
.03951 .41711 L
.03366 .38395 L
.02607 .3508 L
.01923 .32603 L
s
0 1 .4 r
.47314 .01923 m
.46336 .05239 L
.45027 .08328 L
.44909 .08554 L
.42638 .1187 L
.41711 .12784 L
.38395 .14852 L
.37435 .15186 L
.3508 .15641 L
.31764 .156 L
.29341 .15186 L
.28448 .14966 L
.25133 .13884 L
.21817 .12458 L
.20561 .1187 L
.18501 .10759 L
.15186 .08845 L
.14699 .08554 L
.1187 .06755 L
.09579 .05239 L
.08554 .04525 L
.05239 .02178 L
.04895 .01923 L
F
0 g
.47314 .01923 m
.46336 .05239 L
.45027 .08328 L
.44909 .08554 L
.42638 .1187 L
.41711 .12784 L
.38395 .14852 L
.37435 .15186 L
.3508 .15641 L
.31764 .156 L
.29341 .15186 L
.28448 .14966 L
.25133 .13884 L
.21817 .12458 L
.20561 .1187 L
.18501 .10759 L
.15186 .08845 L
.14699 .08554 L
.1187 .06755 L
.09579 .05239 L
.08554 .04525 L
.05239 .02178 L
.04895 .01923 L
s
0 1 .4 r
.39375 .98077 m
.38395 .96625 L
.36788 .94761 L
.3508 .93383 L
.31764 .91828 L
.29882 .91446 L
.28448 .91341 L
.26184 .91446 L
.25133 .91591 L
.21817 .9238 L
.18501 .93574 L
.15775 .94761 L
.15186 .9508 L
.1187 .96832 L
.09694 .98077 L
F
0 g
.39375 .98077 m
.38395 .96625 L
.36788 .94761 L
.3508 .93383 L
.31764 .91828 L
.29882 .91446 L
.28448 .91341 L
.26184 .91446 L
.25133 .91591 L
.21817 .9238 L
.18501 .93574 L
.15775 .94761 L
.15186 .9508 L
.1187 .96832 L
.09694 .98077 L
s
.2 1 0 r
.32414 .01923 m
.31764 .02251 L
.28448 .03418 L
.25133 .03834 L
.21817 .03669 L
.18501 .03043 L
.15186 .0204 L
.14838 .01923 L
F
0 g
.32414 .01923 m
.31764 .02251 L
.28448 .03418 L
.25133 .03834 L
.21817 .03669 L
.18501 .03043 L
.15186 .0204 L
.14838 .01923 L
s
0 .4 1 r
.9529 .98077 m
.94761 .97674 L
.91446 .95251 L
.90771 .94761 L
.8813 .92929 L
.85935 .91446 L
.84814 .90732 L
.81499 .88693 L
.80578 .8813 L
.78183 .86854 L
.74867 .85267 L
.7405 .84814 L
.71552 .84004 L
.68236 .83158 L
.6492 .82864 L
.61605 .83345 L
.58562 .84814 L
.58289 .85051 L
.55602 .8813 L
.54973 .89268 L
.54032 .91446 L
.53032 .94761 L
.52337 .98077 L
F
0 g
.9529 .98077 m
.94761 .97674 L
.91446 .95251 L
.90771 .94761 L
.8813 .92929 L
.85935 .91446 L
.84814 .90732 L
.81499 .88693 L
.80578 .8813 L
.78183 .86854 L
.74867 .85267 L
.7405 .84814 L
.71552 .84004 L
.68236 .83158 L
.6492 .82864 L
.61605 .83345 L
.58562 .84814 L
.58289 .85051 L
.55602 .8813 L
.54973 .89268 L
.54032 .91446 L
.53032 .94761 L
.52337 .98077 L
s
0 .4 1 r
.90576 .01923 m
.8813 .03386 L
.84814 .05225 L
.84791 .05239 L
.81499 .06833 L
.78183 .08142 L
.76882 .08554 L
.74867 .09056 L
.71552 .09437 L
.68236 .09068 L
.66342 .08554 L
.6492 .07578 L
.62364 .05239 L
.61605 .04224 L
.60217 .01923 L
F
0 g
.90576 .01923 m
.8813 .03386 L
.84814 .05225 L
.84791 .05239 L
.81499 .06833 L
.78183 .08142 L
.76882 .08554 L
.74867 .09056 L
.71552 .09437 L
.68236 .09068 L
.66342 .08554 L
.6492 .07578 L
.62364 .05239 L
.61605 .04224 L
.60217 .01923 L
s
0 1 .4 r
.98077 .9541 m
.97373 .94761 L
.94761 .92244 L
.9394 .91446 L
.91446 .89019 L
.90552 .8813 L
.8813 .85716 L
.8725 .84814 L
.84814 .82305 L
.84059 .81499 L
.81499 .78739 L
.81006 .78183 L
.78183 .74938 L
.78125 .74867 L
.75473 .71552 L
.74867 .7076 L
.73082 .68236 L
.71552 .65893 L
.70978 .6492 L
.69203 .61605 L
.68236 .59494 L
.67765 .58289 L
.66675 .54973 L
.65923 .51658 L
.65512 .48342 L
.6545 .45027 L
.65754 .41711 L
.66453 .38395 L
.67579 .3508 L
.68236 .3355 L
.69173 .31764 L
.71238 .28448 L
.71552 .27988 L
.7377 .25133 L
.74867 .238 L
.76666 .21817 L
.78183 .20181 L
.79851 .18501 L
.81499 .16849 L
.83241 .15186 L
.84814 .13679 L
.86772 .1187 L
.8813 .10605 L
.90394 .08554 L
.91446 .07593 L
.94077 .05239 L
.94761 .04622 L
.97783 .01923 L
.98077 .01923 L
F
0 g
.98077 .9541 m
.97373 .94761 L
.94761 .92244 L
.9394 .91446 L
.91446 .89019 L
.90552 .8813 L
.8813 .85716 L
.8725 .84814 L
.84814 .82305 L
.84059 .81499 L
.81499 .78739 L
.81006 .78183 L
.78183 .74938 L
.78125 .74867 L
.75473 .71552 L
.74867 .7076 L
.73082 .68236 L
.71552 .65893 L
.70978 .6492 L
.69203 .61605 L
.68236 .59494 L
.67765 .58289 L
.66675 .54973 L
.65923 .51658 L
.65512 .48342 L
.6545 .45027 L
.65754 .41711 L
.66453 .38395 L
.67579 .3508 L
.68236 .3355 L
.69173 .31764 L
.71238 .28448 L
.71552 .27988 L
.7377 .25133 L
.74867 .238 L
.76666 .21817 L
.78183 .20181 L
.79851 .18501 L
.81499 .16849 L
.83241 .15186 L
.84814 .13679 L
.86772 .1187 L
.8813 .10605 L
.90394 .08554 L
.91446 .07593 L
.94077 .05239 L
.94761 .04622 L
.97783 .01923 L
s
.2 0 1 r
.85658 .98077 m
.84814 .97775 L
.81499 .9672 L
.78183 .96041 L
.74867 .95832 L
.71552 .9622 L
.68236 .97392 L
.66984 .98077 L
F
0 g
.85658 .98077 m
.84814 .97775 L
.81499 .9672 L
.78183 .96041 L
.74867 .95832 L
.71552 .9622 L
.68236 .97392 L
.66984 .98077 L
s
.2 1 0 r
.98077 .90092 m
.96431 .8813 L
.94761 .86043 L
.93804 .84814 L
.91446 .81676 L
.91318 .81499 L
.89015 .78183 L
.8813 .76839 L
.86904 .74867 L
.84994 .71552 L
.84814 .7122 L
.83314 .68236 L
.81857 .6492 L
.81499 .6402 L
.80648 .61605 L
.79686 .58289 L
.78978 .54973 L
.7853 .51658 L
.78347 .48342 L
.78434 .45027 L
.78792 .41711 L
.79424 .38395 L
.8033 .3508 L
.81499 .31776 L
.81504 .31764 L
.82959 .28448 L
.8467 .25133 L
.84814 .24871 L
.86644 .21817 L
.8813 .19537 L
.88848 .18501 L
.91274 .15186 L
.91446 .1496 L
.93904 .1187 L
.94761 .10829 L
.96685 .08554 L
.98077 .06992 L
F
0 g
.98077 .90092 m
.96431 .8813 L
.94761 .86043 L
.93804 .84814 L
.91446 .81676 L
.91318 .81499 L
.89015 .78183 L
.8813 .76839 L
.86904 .74867 L
.84994 .71552 L
.84814 .7122 L
.83314 .68236 L
.81857 .6492 L
.81499 .6402 L
.80648 .61605 L
.79686 .58289 L
.78978 .54973 L
.7853 .51658 L
.78347 .48342 L
.78434 .45027 L
.78792 .41711 L
.79424 .38395 L
.8033 .3508 L
.81499 .31776 L
.81504 .31764 L
.82959 .28448 L
.8467 .25133 L
.84814 .24871 L
.86644 .21817 L
.8813 .19537 L
.88848 .18501 L
.91274 .15186 L
.91446 .1496 L
.93904 .1187 L
.94761 .10829 L
.96685 .08554 L
.98077 .06992 L
s
.8 1 0 r
.98077 .84 m
.96464 .81499 L
.94761 .78648 L
.94496 .78183 L
.927 .74867 L
.91446 .72325 L
.9109 .71552 L
.89677 .68236 L
.88463 .6492 L
.8813 .63909 L
.8746 .61605 L
.86671 .58289 L
.86098 .54973 L
.85748 .51658 L
.85623 .48342 L
.85726 .45027 L
.86057 .41711 L
.86615 .38395 L
.87399 .3508 L
.8813 .3259 L
.88406 .31764 L
.8964 .28448 L
.91087 .25133 L
.91446 .24375 L
.9275 .21817 L
.94615 .18501 L
.94761 .18254 L
.96668 .15186 L
.98077 .13095 L
F
0 g
.98077 .84 m
.96464 .81499 L
.94761 .78648 L
.94496 .78183 L
.927 .74867 L
.91446 .72325 L
.9109 .71552 L
.89677 .68236 L
.88463 .6492 L
.8813 .63909 L
.8746 .61605 L
.86671 .58289 L
.86098 .54973 L
.85748 .51658 L
.85623 .48342 L
.85726 .45027 L
.86057 .41711 L
.86615 .38395 L
.87399 .3508 L
.8813 .3259 L
.88406 .31764 L
.8964 .28448 L
.91087 .25133 L
.91446 .24375 L
.9275 .21817 L
.94615 .18501 L
.94761 .18254 L
.96668 .15186 L
.98077 .13095 L
s
1 .6 0 r
.98077 .76682 m
.97212 .74867 L
.95778 .71552 L
.94761 .68903 L
.94524 .68236 L
.93451 .6492 L
.92564 .61605 L
.91869 .58289 L
.91446 .55621 L
.9137 .54973 L
.91072 .51658 L
.90975 .48342 L
.9108 .45027 L
.91387 .41711 L
.91446 .41213 L
.91897 .38395 L
.92609 .3508 L
.93519 .31764 L
.94622 .28448 L
.94761 .28065 L
.95915 .25133 L
.97401 .21817 L
.98077 .20445 L
F
0 g
.98077 .76682 m
.97212 .74867 L
.95778 .71552 L
.94761 .68903 L
.94524 .68236 L
.93451 .6492 L
.92564 .61605 L
.91869 .58289 L
.91446 .55621 L
.9137 .54973 L
.91072 .51658 L
.90975 .48342 L
.9108 .45027 L
.91387 .41711 L
.91446 .41213 L
.91897 .38395 L
.92609 .3508 L
.93519 .31764 L
.94622 .28448 L
.94761 .28065 L
.95915 .25133 L
.97401 .21817 L
.98077 .20445 L
s
1 0 0 r
.98077 .66804 m
.97539 .6492 L
.9673 .61605 L
.961 .58289 L
.95652 .54973 L
.95386 .51658 L
.95305 .48342 L
.95409 .45027 L
.95699 .41711 L
.96173 .38395 L
.9683 .3508 L
.97673 .31764 L
.98077 .30382 L
F
0 g
.98077 .66804 m
.97539 .6492 L
.9673 .61605 L
.961 .58289 L
.95652 .54973 L
.95386 .51658 L
.95305 .48342 L
.95409 .45027 L
.95699 .41711 L
.96173 .38395 L
.9683 .3508 L
.97673 .31764 L
.98077 .30382 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00<@3oool3000002l0oooo1000000_0?ooo`800000
<@3oool400000380oooo0`00000N0?ooo`00<P3oool00`000000oooo0?ooo`0^0?ooo`030000003o
ool0oooo02l0oooo00@000000?ooo`3oool00000<03oool00`000000oooo0?ooo`0d0?ooo`030000
003oool0oooo01d0oooo000_0?ooo`D00000<03oool00`000000oooo0?ooo`0^0?ooo`040000003o
ool0oooo00000340oooo00<000000?ooo`3oool0<03oool5000001h0oooo000Y0?ooo`@000000P3o
ool010000000oooo0?ooo`00000Z0?ooo`@00000103oool00`000000oooo0?ooo`0]0?ooo`040000
003oool0oooo00000380oooo00<000000?ooo`3oool0;`3oool010000000oooo0?ooo`00000O0?oo
o`00<03oool00`000000oooo0000000`0?ooo`040000003oool0oooo000002h0oooo00@000000?oo
o`3oool00000<03oool010000000oooo0?ooo`00000a0?ooo`030000003oool0000001l0oooo000a
0?ooo`800000<@3oool200000300oooo0P00000b0?ooo`800000<`3oool2000001l0oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo000?0?oo
ool000004@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`4000000@3oool000l0oooo
00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0380oooo
00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01`0oooo
0@0000010?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`d0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`3o0?ooo`d0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`3o0?oo
o`d0oooo0@0000010?ooo`003`3oool2000000/0oooo0P00000I0?ooo`<00000;@3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0D03oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo0P0000010?ooo`003`3oool00`000000oooo
0?ooo`020?ooo`X00?oo00<00000003oIP00ofH06@00ofH3000002L0<ol00`00000X003oIP030000
0000ool00?oo02400?oo00<00000001Vo`00I_l0C@00I_l2000001800?oo00<00000003oIP3oool0
103oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo2`00ool2000001`00?mV0`00
000Q03?o00<00000:`00ofH00`0000000?oo003oo`0Q003oo`0300000000I_l006Ko04/006Ko0P00
000C003oo`0300000000ofH00?mV00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`02
0?ooo`d00?oo00<00000003oIP00ofH07000ofH6000001P0<ol00`00000]003oIP0300000000ool0
0?oo02<00?oo00<00000001Vo`00I_l0B000I_l2000001@00?oo00@00000003oIP00ofH00?mV1@3o
ool100000040oooo000?0?ooo`030000003oool0oooo0080oooo3P00ool00`0000000?mV003oIP0Q
003oIPT000002@0co`06000003000?mV00<00000003oo`00ool09000ool00`00000006Ko001Vo`16
001Vo`0300000000ool00?oo01800?oo0P000004003oIPD0oooo0@0000010?ooo`003`3oool00`00
0000oooo0?ooo`020?ooo`l00?oo0P00000Z003oIPT00000=P00ofH00`0000000?oo003oo`0T003o
o`0300000000I_l006Ko04@006Ko0P00000D003oo`0300000000ofH00?mV00@00?mV1@3oool10000
0040oooo000?0?ooo`030000003oool0oooo0080oooo00<00000003oo`00ool03P00ool00`000000
0?mV003oIP1V003oIP0300000000ool00?oo02D00?oo00<00000001Vo`00I_l0@@00I_l2000001D0
0?oo00<00000003oIP00ofH01@00ofH50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool0
0P3oool00`00I_l00000003oo`0?003oo`0300000000ofH00?mV06@00?mV00<00000003oo`00ool0
9`00ool00`00000006Ko001Vo`0n001Vo`8000005P00ool00`0000000?mV003oIP06003oIPD0oooo
0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`8006Ko00<00000003oo`00ool03P00
ool2000006@00?mV00<00000003oo`00ool09`00ool00`00000006Ko001Vo`0l001Vo`8000005`00
ool00`0000000?mV003oIP07003oIPD0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`02
0?ooo`<006Ko00<00000003oo`00ool03`00ool00`0000000?mV003oIP1Q003oIP0300000000ool0
0?oo02P00?oo00<00000001Vo`00I_l0>@00I_l2000001P00?oo00<00000003oIP00ofH02000ofH5
0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool4001Vo`0300000000ool00?oo
00l00?oo0P00001P003oIP0300000000ool00?oo02X00?oo00<00000001Vo`00I_l0=P00I_l20000
01T00?oo00<00000003oIP00ofH02@00ofH50?ooo`4000000@3oool000l0oooo00<000000?ooo`3o
ool00P3oool5001Vo`0300000000ool00?oo01000?oo00<00000003oIP00ofH0G@00ofH00`000000
0?oo003oo`0[003oo`0300000000I_l006Ko03<006Ko0P00000J003oo`0300000000ofH00?mV00X0
0?mV1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1P00I_l00`0000000?oo
003oo`0@003oo`800000G000ofH00`0000000?oo003oo`0]003oo`800000<@00I_l2000001X00?oo
0P00000=003oIPD0oooo0@0000010?ooo`003`3oool2000000<0oooo1`00I_l00`0000000?oo003o
o`0A003oo`0300000000ofH00?mV05T00?mV00<00000003oo`00ool0;`00ool00`00000006Ko001V
o`0[001Vo`<000006`00ool00`0000000?mV003oIP0=003oIP040000003oool0oooo0?ooo`800000
0@3oool000l0oooo00<000000?ooo`3oool00P3oool8001Vo`0300000000ool00?oo01400?oo0P00
001H003oIP0300000000ool00?oo03400?oo00<00000001Vo`00I_l0:000I_l2000001d00?oo00<0
0000003oIP00ofH03@00ofH00`000000oooo0?ooo`030?ooo`4000000@3oool000l0oooo00<00000
0?ooo`3oool00P3oool9001Vo`0300000000ool00?oo01800?oo00<00000003oIP00ofH0E@00ofH0
0`0000000?oo003oo`0b003oo`0300000000I_l006Ko02D006Ko0P00000N003oo`0300000000ofH0
0?mV00d00?mV00<0000003?o003oool0103oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo2P00I_l00`0000000?oo003oo`0B003oo`800000E000ofH00`0000000?oo003oo`0d003o
o`0300000000I_l006Ko028006Ko0P00000O003oo`0300000000ofH00?mV00h00?mV00<0000003?o
003oool0103oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo2`00I_l00`000000
0?oo003oo`0C003oo`800000DP00ofH00`0000000?oo003oo`0e003oo`8000007`00I_l300000200
0?oo00<00000003oIP00ofH03P00ofH00`000000<ol003?o00050?ooo`4000000@3oool000l0oooo
00<000000?ooo`3oool00P3oool<001Vo`0300000000ool00?oo01@00?oo0P00001@003oIP030000
0000ool00?oo03L00?oo0`00000H001Vo`@000008P00ool00`0000000?mV003oIP0>003oIP040000
000co`00<ol003?o00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`d006Ko
00<00000003oo`00ool05@00ool2000004d00?mV00<00000003oo`00ool0>`00ool7000000T006Ko
2000000U003oo`0300000000ofH00?mV00h00?mV00<0000003?o000co`000P0co`050?ooo`400000
0@3oool000l0oooo00<000000?ooo`3oool00P3oool00`00000006Ko001Vo`0;001Vo`0300000000
ool00?oo01H00?oo00<00000003oIP00ofH0BP00ofH00`0000000?oo003oo`12003oo`T00000;000
ool00`0000000?mV003oIP0>003oIP030000000co`00<ol000<0<ol01@3oool100000040oooo000?
0?ooo`030000003oool0oooo0080oooo00<0<`3o00000000I_l03000I_l2000001L00?oo0P000019
003oIP0300000000ool00?oo07H00?oo0P00000@003oIP030000000co`00<ol000@0<ol01@3oool1
00000040oooo000?0?ooo`030000003oool0oooo0080oooo00<0<`3o00000000I_l03P00I_l00`00
00000?oo003oo`0F003oo`0300000000ofH00?mV04D00?mV00<00000003oo`00ool0MP00ool00`00
00000?mV003oIP0@003oIP030000000co`00<ol000@0<ol01@3oool100000040oooo000?0?ooo`03
0000003oool0oooo0080oooo0P0c0?l00`00000006Ko001Vo`0=001Vo`0300000000ool00?oo01H0
0?oo0P000015003oIP0300000000ool00?oo07D00?oo00<00000003oIP00ofH04000ofH00`000000
<ol003?o000503?o00D0oooo0@0000010?ooo`002@3oool3000000<0oooo00<000000?ooo`3oool0
0P3oool303<0o`0300000000I_l006Ko00d006Ko00<00000003oo`00ool05`00ool00`0000000?mV
003oIP11003oIP0300000000ool00?oo07D00?oo00<00000003oIP00ofH04000ofH00`000000<ol0
03?o000603?o00D0oooo0@0000010?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo100c0?l00`00000006Ko001Vo`0=001Vo`0300000000ool00?oo01L00?oo0P00
0010003oIP0300000000ool00?oo07D00?oo00<00000003oIP00ofH04000ofH00`000000<ol003?o
000703?o00D0oooo0@0000010?ooo`001`3oool5000000<0oooo0`0000020?ooo`@0<`3o00<00000
001Vo`00I_l03P00I_l00`0000000?oo003oo`0H003oo`800000?P00ofH00`0000000?oo003oo`1d
003oo`0300000000ofH00?mV01400?mV00<0000003?o000co`001`0co`040?ooo`8000000@3oool0
00030?ooo`0000000000008000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0080oooo1@0c0?l00`00000006Ko001Vo`0>001Vo`0300000000ool00?oo01T00?oo0`00000j
003oIP0300000000ool00?oo07@00?oo00<00000003oIP00ofH04@00ofH00`000000<ol003?o0008
03?o00D0oooo0@0000010?ooo`00203oool00`000000oooo000000040?ooo`030000003oool0oooo
0080oooo1P0c0?l00`00000006Ko001Vo`0>001Vo`0300000000ool00?oo01/00?oo0`00000e003o
IP800000MP00ool00`0000000?mV003oIP0A003oIP030000000co`00<ol000T0<ol01@3oool10000
0040oooo00090?ooo`800000103oool00`000000oooo0?ooo`020?ooo`L0<`3o00<00000001Vo`00
I_l03P00I_l00`0000000?oo003oo`0M003oo`800000<P00ofH00`0000000?oo003oo`1e003oo`03
00000000ofH00?mV01400?mV00<0000003?o000co`002P0co`050?ooo`4000000@3oool000l0oooo
00<000000?ooo`3oool00P3oool803<0o`0300000000I_l006Ko00h006Ko00<00000003oo`00ool0
7P00ool2000002h00?mV0P00001g003oo`0300000000ofH00?mV01400?mV00<0000003?o000co`00
2`0co`000`000000oooo0?ooo`020?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3o
ool903<0o`0300000000I_l006Ko00h006Ko00<00000003oo`00ool07`00ool2000002/00?mV00<0
0000003oo`00ool0MP00ool00`0000000?mV003oIP0A003oIP030000000co`00<ol000/0<ol000<0
00000?ooo`3oool00`3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo2P0c0?l0
0`00000006Ko001Vo`0>001Vo`0300000000ool00?oo02000?oo0`00000V003oIP800000N000ool0
0`0000000?mV003oIP0B003oIP030000000co`00<ol000/0<ol000<000000?ooo`3oool00`3oool1
00000040oooo000?0?ooo`030000003oool0oooo0080oooo2`0c0?l00`00000006Ko001Vo`0>001V
o`0300000000ool00?oo02800?oo0`00000R003oIP0300000000ool00?oo07L00?oo00<00000003o
IP00ofH04P00ofH00`000000<ol003?o000;03?o00030000003<o`00oooo00@0oooo0@0000010?oo
o`003`3oool00`000000oooo0?ooo`020?ooo`/0<`3o00<00000001Vo`00I_l03`00I_l00`000000
0?oo003oo`0T003oo`<000007@00ofH2000007T00?oo00<00000003oIP00ofH04P00ofH00`000000
<ol003?o000;03?o00030000003<o`00c?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo
0?ooo`020?ooo``0<`3o00<00000001Vo`00I_l03`00I_l00`0000000?oo003oo`0V003oo`<00000
6@00ofH00`0000000?oo003oo`1h003oo`0300000000ofH00?mV01800?mV00<0000003?o000co`00
300co`000`000000c?l00<co00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3o
ool=03<0o`0300000000I_l006Ko00l006Ko00<00000003oo`00ool0:000ool4000001000?mV1@00
001j003oo`0300000000ofH00?mV01<00?mV00<0000003?o000co`002`0co`0010000000c?l00<co
003<o`050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool00`000000<`3o03<0
o`0;03<0o`0300000000I_l006Ko00l006Ko00<00000003oo`00ool0:`00ool@000007h00?oo00<0
0000003oIP00ofH04`00ofH00`000000<ol003?o000;03?o00030000003<o`00c?l00080c?l01@3o
ool100000040oooo000?0?ooo`030000003oool0oooo0080oooo00<0c03o0000000c0?l0300c0?l0
0`00000006Ko001Vo`0?001Vo`0300000000ool00?oo0;H00?oo0P00000E003oIP030000000co`00
<ol000`0<ol000<000000<co003<o`000P3<o`050?ooo`4000000@3oool000l0oooo0P0000030?oo
o`030<`0o`000000<`3o00`0<`3o00<00000001Vo`00I_l04000I_l00`0000000?oo003oo`2d003o
o`0300000000ofH00?mV01D00?mV00<0000003?o000co`002`0co`000`000000c?l00<co00030<co
00@0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`80c03o00<0000003<0o`0c
0?l02`0c0?l00`00000006Ko001Vo`0@001Vo`0300000000ool00?oo0;800?oo00<00000003oIP00
ofH05@00ofH00`000000<ol003?o000;03?o00030000003<o`00c?l000@0c?l01@3oool100000040
oooo000?0?ooo`030000003oool0oooo0080oooo0P3<0?l00`000000<`3o03<0o`0<03<0o`030000
0000I_l006Ko010006Ko00<00000003oo`00ool0/000ool00`0000000?mV003oIP0E003oIP030000
000co`00<ol000`0<ol000<000000<co003<o`00103<o`050?ooo`4000000@3oool000l0oooo00<0
00000?ooo`3oool00P3oool30<`0o`030000000c0?l0<`3o00`0<`3o00<00000001Vo`00I_l04000
I_l00`0000000?oo003oo`2^003oo`0300000000ofH00?mV01D00?mV00<0000003?o000co`00300c
o`000`000000c?l00<co00050<co00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`02
0?ooo`@0c03o00<0000003<0o`0c0?l0300c0?l00`00000006Ko001Vo`0@001Vo`0300000000ool0
0?oo0:d00?oo00<00000003oIP00ofH05@00ofH00`000000<ol003?o000<03?o00030000003<o`00
c?l000D0c?l01@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo103<0?l00`00
0000<`3o03<0o`0<03<0o`0300000000I_l006Ko014006Ko00<00000003oo`00ool0Z`00ool00`00
00000?mV003oIP0E003oIP030000000co`00<ol000`0<ol000<000000<co003<o`001P3<o`050?oo
o`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool50<`0o`030000000c0?l0<`3o00`0
<`3o00<00000001Vo`00I_l04@00I_l00`0000000?oo003oo`2Y003oo`0300000000ofH00?mV01D0
0?mV00<0000003?o000co`003@0co`000`000000c?l00<co00060<co00D0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`H0c03o00<0000003<0o`0c0?l0300c0?l00`00000006Ko
001Vo`0A001Vo`0300000000ool00?oo0:L00?oo00<00000003oIP00ofH05@00ofH00`000000<ol0
03?o000=03?o00030000003<o`00c?l000L0c?l01@3oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo1P3<0?l00`000000<`3o03<0o`0<03<0o`0300000000I_l006Ko018006Ko00<0
0000003oo`00ool0Y000ool2000001L00?mV00<0000003?o000co`003P0co`000`000000c?l00<co
00070<co00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`L0c03o00<00000
03<0o`0c0?l0300c0?l00`00000006Ko001Vo`0B001Vo`0300000000ool00?oo0:800?oo00<00000
003oIP00ofH05P00ofH00`000000<ol003?o000>03?o00030000003<o`00c?l000P0c?l01@3oool1
00000040oooo000?0?ooo`030000003oool0oooo0080oooo203<0?l00`000000<`3o03<0o`0<03<0
o`0300000000I_l006Ko018006Ko00<00000003oo`00ool0X000ool00`0000000?mV003oIP0G003o
IP030000000co`00<ol000h0<ol000<000000<co003<o`00203<o`050?ooo`4000000@3oool000l0
oooo00<000000?ooo`3oool00P3oool80<`0o`030000000c0?l0<`3o00`0<`3o00<00000001Vo`00
I_l04`00I_l00`0000000?oo003oo`2N003oo`0300000000ofH00?mV01L00?mV00<0000003?o000c
o`003P0co`000`000000c?l00<co00090<co00030000003oool0oooo0080oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`T0c03o00<0000003<0o`0c0?l0300c0?l00`00000006Ko
001Vo`0C001Vo`0300000000ool00?oo09`00?oo00<00000003oIP00ofH06000ofH00`000000<ol0
03?o000>03?o00030000003<o`00c?l000P0c?l000<000000?ooo`3oool00`3oool100000040oooo
000?0?ooo`8000000`3oool:0<`0o`030000000c0?l0<`3o00`0<`3o00<00000001Vo`00I_l04`00
I_l00`0000000?oo003oo`2K003oo`0300000000ofH00?mV01L00?mV00<0000003?o000co`003P0c
o`000`000000c?l00<co00090<co00030000003oool0oooo0080oooo0P0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?ooo`X0c03o00<0000003<0o`0c0?l0300c0?l00`00000006Ko001Vo`0D
001Vo`0300000000ool00?oo09T00?oo00<00000003oIP00ofH06000ofH00`000000<ol003?o000>
03?o00030000003<o`00c?l000P0c?l000<000000?nI003oool0103oool100000040oooo000?0?oo
o`030000003oool0oooo0080oooo2`3<0?l00`000000<`3o03<0o`0<03<0o`0300000000I_l006Ko
01@006Ko00<00000003oo`00ool0U`00ool00`0000000?mV003oIP0H003oIP030000000co`00<ol0
00h0<ol000<000000<co003<o`002@3<o`000`000000oiT00?ooo`040?ooo`4000000@3oool000l0
oooo00<000000?ooo`3oool00P3oool<0<`0o`030000000c0?l0<`3o00`0<`3o00<00000001Vo`00
I_l05000I_l00`0000000?oo003oo`2E003oo`0300000000ofH00?mV01P00?mV00<0000003?o000c
o`003P0co`000`000000c?l00<co000:0<co00030000003oV@00oooo00@0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`030000003<0?l0c03o00T0c03o00<0000003<0o`0c0?l0
3@0c0?l00`00000006Ko001Vo`0D001Vo`0300000000ool00?oo09<00?oo00<00000003oIP00ofH0
6@00ofH00`000000<ol003?o000>03?o00030000003<o`00c?l000T0c?l000<000000?nI003oV@00
1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo00<000000<`0o`3<0?l02P3<
0?l00`000000<`3o03<0o`0<03<0o`0300000000I_l006Ko01@006Ko00<00000003oo`00ool0TP00
ool00`0000000?mV003oIP0I003oIP030000000co`00<ol000h0<ol000<000000<co003<o`002P3<
o`000`000000oiT00?nI00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool0
0`3o09T000000<`0o`0:0<`0o`030000000c0?l0<`3o00d0<`3o00<00000001Vo`00I_l05000I_l0
0`0000000?oo003oo`2@003oo`0300000000ofH00?mV01T00?mV00<0000003?o000co`003`0co`00
0`000000c?l00<co00090<co00040000003oV@00oiT00?nI00D0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?ooo`030?l0V@000000c03o00/0c03o00<0000003<0o`0c0?l0300c0?l0
0`00000006Ko001Vo`0E001Vo`0300000000ool00?oo08h00?oo00<00000003oIP00ofH06P00ofH0
0`000000<ol003?o000>03?o00030000003<o`00c?l000X0c?l000@000000?nI003oV@00oiT01@3o
ool100000040oooo000?0?ooo`030000003oool0oooo0080oooo0P3o09T00`000000c03o0<`0o`09
0<`0o`030000000c0?l0<`3o00d0<`3o00<00000001Vo`00I_l05@00I_l00`0000000?oo003oo`2<
003oo`0300000000ofH00?mV01X00?mV00<0000003?o000co`003`0co`000`000000c?l00<co0009
0<co00030000003oV@00oiT00080oiT01@3oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo0P3o09T00`000000c03o0<`0o`0:0<`0o`030000000c0?l0<`3o00d0<`3o00<00000001V
o`00I_l05@00I_l00`0000000?oo003oo`2:003oo`0300000000ofH00?mV01/00?mV00<0000003?o
000co`003P0co`000`000000c?l00<co000:0<co00030000003oV@00oiT00080oiT01@3oool10000
0040oooo000?0?ooo`030000003oool0oooo0080oooo0`3o09T00`000000c03o0<`0o`090<`0o`03
0000000c0?l0<`3o00d0<`3o00<00000001Vo`00I_l05P00I_l00`0000000?oo003oo`29003oo`03
00000000ofH00?mV01X00?mV00<0000003?o000co`003P0co`000`000000c?l00<co000:0<co0003
0000003oV@00oiT000<0oiT01@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo
0`3o09T00`000000c03o0<`0o`0:0<`0o`030000000c0?l0<`3o00d0<`3o00<00000001Vo`00I_l0
5P00I_l00`0000000?oo003oo`27003oo`0300000000ofH00?mV01/00?mV00<0000003?o000co`00
3P0co`000`000000c?l00<co000:0<co00030000003oV@00oiT000<0oiT01@3oool100000040oooo
000?0?ooo`030000003oool0oooo0080oooo0`3o09T00`000000c03o0<`0o`0:0<`0o`030000000c
0?l0<`3o00h0<`3o00<00000001Vo`00I_l05P00I_l00`0000000?oo003oo`25003oo`0300000000
ofH00?mV01/00?mV00<0000003?o000co`003`0co`000`000000c?l00<co000:0<co00030000003o
V@00oiT000<0oiT01@3oool100000040oooo000?0?ooo`8000000`3oool40?l0V@030000003<0?l0
c03o00X0c03o00<0000003<0o`0c0?l03@0c0?l00`00000006Ko001Vo`0F001Vo`0300000000ool0
0?oo08@00?oo00<00000003oIP00ofH07000ofH00`000000<ol003?o000>03?o00030000003<o`00
c?l000X0c?l000<000000?nI003oV@00103oV@040?ooo`8000000@3oool000l0oooo00<000000?oo
o`3oool00P3oool40?l0V@030000003<0?l0c03o00X0c03o00<0000003<0o`0c0?l03P0c0?l00`00
000006Ko001Vo`0F001Vo`0300000000ool00?oo08800?oo00<00000003oIP00ofH07000ofH00`00
0000<ol003?o000?03?o00030000003<o`00c?l000X0c?l000<000000?nI003oV@00103oV@050?oo
o`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool50?l0V@030000003<0?l0c03o00X0
c03o00<0000003<0o`0c0?l03@0c0?l00`00000006Ko001Vo`0G001Vo`0300000000ool00?oo0840
0?oo00<00000003oIP00ofH07000ofH00`000000<ol003?o000>03?o00030000003<o`00c?l000X0
c?l000<000000?nI003oV@001@3oV@050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool0
0P3oool50?l0V@030000003<0?l0c03o00X0c03o00<0000003<0o`0c0?l03P0c0?l00`00000006Ko
001Vo`0G001Vo`0300000000ool00?oo07l00?oo00<00000003oIP00ofH07000ofH00`000000<ol0
03?o000?03?o00030000003<o`00c?l000X0c?l000<000000?nI003oV@001@3oV@050?ooo`400000
0@3oool000l0oooo00<000000?ooo`3oool00P3oool60?l0V@030000003<0?l0c03o00T0c03o00<0
000003<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0G001Vo`0300000000ool00?oo07h00?oo00<0
0000003oIP00ofH07@00ofH00`000000<ol003?o000>03?o00030000003<o`00c?l000/0c?l000<0
00000?nI003oV@001@3oV@050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool6
0?l0V@030000003<0?l0c03o00X0c03o00<0000003<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0G
001Vo`0300000000ool00?oo07`00?oo00<00000003oIP00ofH07@00ofH00`000000<ol003?o000?
03?o00030000003<o`00c?l000X0c?l000<000000?nI003oV@001P3oV@050?ooo`4000000@3oool0
00l0oooo00<000000?ooo`3oool00P3oool70?l0V@030000003<0?l0c03o00T0c03o00<0000003<0
o`0c0?l03P0c0?l00`00000006Ko001Vo`0H001Vo`0300000000ool00?oo07X00?oo00<00000003o
IP00ofH07P00ofH00`000000<ol003?o000>03?o00030000003<o`00c?l000/0c?l000<000000?nI
003oV@001P3oV@050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool70?l0V@03
0000003<0?l0c03o00X0c03o00<0000003<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0H001Vo`03
00000000ool00?oo07T00?oo00<00000003oIP00ofH07@00ofH00`000000<ol003?o000?03?o0003
0000003<o`00c?l000/0c?l000<000000?nI003oV@001P3oV@050?ooo`4000000@3oool000l0oooo
00<000000?ooo`3oool00P3oool70?l0V@030000003<0?l0c03o00X0c03o00<0000003<0o`0c0?l0
3P0c0?l00`00000006Ko001Vo`0I001Vo`0300000000ool00?oo07L00?oo00<00000003oIP00ofH0
7P00ofH00`000000<ol003?o000?03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@00
1P3oV@050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool80?l0V@030000003<
0?l0c03o00X0c03o00<0000003<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0H001Vo`0300000000
ool00?oo07L00?oo00<00000003oIP00ofH07@00ofH00`000000<ol003?o000?03?o00030000003<
o`00c?l000/0c?l000<000000?nI003oV@001`3oV@050?ooo`4000000@3oool000l0oooo00<00000
0?ooo`3oool00P3oool80?l0V@030000003<0?l0c03o00X0c03o00<0000003<0o`0c0?l03P0c0?l0
0`00000006Ko001Vo`0I001Vo`0300000000ool00?oo07D00?oo00<00000003oIP00ofH07P00ofH0
0`000000<ol003?o000?03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@001`3oV@05
0?ooo`4000000@3oool000L0oooo100000040?ooo`030000003oool0oooo0080oooo2@3o09T00`00
0000c03o0<`0o`0:0<`0o`030000000c0?l0<`3o00h0<`3o00<00000001Vo`00I_l06@00I_l00`00
00000?oo003oo`1d003oo`0300000000ofH00?mV01d00?mV00<0000003?o000co`00400co`000`00
0000c?l00<co000;0<co00030000003oV@00oiT000L0oiT01@3oool100000040oooo00070?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool90?l0V@030000003<0?l0c03o00X0
c03o00<0000003<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0I001Vo`0300000000ool00?oo07<0
0?oo00<00000003oIP00ofH07P00ofH00`000000<ol003?o000?03?o00030000003<o`00c?l000/0
c?l000<000000?nI003oV@00203oV@000`000000oooo0?ooo`020?ooo`4000000@3oool000P0oooo
00<000000?ooo`3oool0103oool300000080oooo2@3o09T00`000000c03o0<`0o`0;0<`0o`030000
000c0?l0<`3o00h0<`3o00<00000001Vo`00I_l06@00I_l00`0000000?oo003oo`1b003oo`030000
0000ofH00?mV01d00?mV00<0000003?o000co`00400co`000`000000c?l00<co000;0<co00030000
003oV@00oiT000P0oiT000@000000?ooo`3oool0oooo0P0000010?ooo`0000<0oooo000000000000
0P0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool90?l0V@030000
003<0?l0c03o00/0c03o00<0000003<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0J001Vo`030000
0000ool00?oo07000?oo00<00000003oIP00ofH07P00ofH00`000000<ol003?o000@03?o00030000
003<o`00c?l000/0c?l000<000000?nI003oV@001`3oV@000`000000oooo0?ooo`030?ooo`400000
0@3oool000L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`X0o`2I
00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0>03<0o`0300000000I_l006Ko01T006Ko
00<00000003oo`00ool0L000ool00`0000000?mV003oIP0M003oIP030000000co`00<ol00100<ol0
00<000000<co003<o`002`3<o`000`000000oiT00?nI00080?nI00030000003oool0oooo00<0oooo
0@0000010?ooo`00203oool2000000D0oooo00<000000?ooo`3oool00P3oool:0?l0V@030000003<
0?l0c03o00/0c03o00<0000003<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0J001Vo`0300000000
ool00?oo06h00?oo00<00000003oIP00ofH07P00ofH00`000000<ol003?o000@03?o00030000003<
o`00c?l000/0c?l000<000000?nI003oV@00203oV@000`000000oooo0?ooo`030?ooo`4000000@3o
ool000l0oooo00<000000?ooo`3oool00P3oool:0?l0V@030000003<0?l0c03o00/0c03o00<00000
03<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0K001Vo`0300000000ool00?oo06`00?oo00<00000
003oIP00ofH07`00ofH00`000000<ol003?o000?03?o00030000003<o`00c?l000`0c?l000<00000
0?nI003oV@00203oV@000`000000oooo0?ooo`030?ooo`4000000@3oool000l0oooo00<000000?oo
o`3oool00P3oool00`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00/0c03o00<0000003<0
o`0c0?l03P0c0?l00`00000006Ko001Vo`0J001Vo`0300000000ool00?oo06`00?oo00<00000003o
IP00ofH07P00ofH00`000000<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI
003oV@002@3oV@000`000000oooo0?ooo`030?ooo`4000000@3oool000l0oooo00<000000?ooo`3o
ool00P3oool00`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c
0?l03P0c0?l00`00000006Ko001Vo`0K001Vo`0300000000ool00?oo06X00?oo00<00000003oIP00
ofH07`00ofH00`000000<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI003o
V@00203oV@000`000000o`000?ooo`040?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool0
0P3oool00`3o000000000?l0V@080?l0V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c0?l0
3`0c0?l00`00000006Ko001Vo`0J001Vo`0300000000ool00?oo06X00?oo00<00000003oIP00ofH0
7`00ofH00`000000<ol003?o000?03?o00030000003<o`00c?l000`0c?l000<000000?nI003oV@00
203oV@000`000000o`000?ooo`040?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3o
ool00`3o000000000?l0V@090?l0V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c0?l03P0c
0?l00`00000006Ko001Vo`0K001Vo`0300000000ool00?oo06P00?oo00<00000003oIP00ofH07`00
ofH00`000000<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3o
V@000`000000o`000?ooo`040?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool0
0`3o000000000?l0V@090?l0V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c0?l03`0c0?l0
0`00000006Ko001Vo`0J001Vo`0300000000ool00?oo06L00?oo00<00000003oIP00ofH08000ofH0
0`000000<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3oV@00
0`000000o`000?ooo`040?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool00`3o
000000000?l0V@090?l0V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c0?l03`0c0?l00`00
000006Ko001Vo`0K001Vo`0300000000ool00?oo06H00?oo00<00000003oIP00ofH08000ofH00`00
0000<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@00203oV@000`00
0000o`000?l000050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool20?l00003
0000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0?03<0o`03
00000000I_l006Ko01X006Ko00<00000003oo`00ool0I@00ool00`0000000?mV003oIP0P003oIP03
0000000co`00<ol00100<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00090?nI0003
0000003o0000o`0000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`80o`00
00<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0<`3o00l0<`3o
00<00000001Vo`00I_l06`00I_l00`0000000?oo003oo`1T003oo`0300000000ofH00?mV02000?mV
00<0000003?o000co`00400co`000`000000c?l00<co000;0<co00030000003oV@00oiT000T0oiT0
00<000000?l0003o00001@3oool100000040oooo000?0?ooo`8000000`3oool20?l000030000003o
09T0o`2I00P0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0?03<0o`0300000000
I_l006Ko01`006Ko00<00000003oo`00ool0H`00ool00`0000000?mV003oIP0P003oIP030000000c
o`00<ol00100<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00090?nI00030000003o
0000o`0000@0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`80o`0000<00000
0?l0V@3o09T0203o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0<`3o0100<`3o00<00000
001Vo`00I_l06`00I_l00`0000000?oo003oo`1R003oo`0300000000ofH00?mV02400?mV00<00000
03?o000co`00400co`000`000000c?l00<co000;0<co00030000003oV@00oiT000T0oiT000<00000
0?l0003o00001@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo0`3o00000`00
0000o`2I0?l0V@080?l0V@030000003<0?l0c03o00X0c03o00<0000003<0o`0c0?l0400c0?l00`00
000006Ko001Vo`0L001Vo`0300000000ool00?oo06400?oo00<00000003oIP00ofH08000ofH00`00
0000<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3oV@001000
0000o`000?l0003o00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool30?l0
00030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0?03<0
o`0300000000I_l006Ko01`006Ko00<00000003oo`00ool0H@00ool00`0000000?mV003oIP0P003o
IP030000000co`00<ol00100<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00090?nI
00040000003o0000o`000?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?oo
o`<0o`0000<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0<`3o
0100<`3o00<00000001Vo`00I_l07000I_l00`0000000?oo003oo`1O003oo`0300000000ofH00?mV
02400?mV00<0000003?o000co`00400co`000`000000c?l00<co000;0<co00030000003oV@00oiT0
00T0oiT000@000000?l0003o0000o`001@3oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo0`3o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00/0c03o00<0000003<0
o`0c0?l0400c0?l00`00000006Ko001Vo`0L001Vo`0300000000ool00?oo05l00?oo00<00000003o
IP00ofH08@00ofH00`000000<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI
003oV@002@3oV@0010000000o`000?l0003o00050?ooo`4000000@3oool000l0oooo00<000000?oo
o`3oool00P3oool40?l000030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l02P3<0?l00`00
0000<`3o03<0o`0@03<0o`0300000000I_l006Ko01d006Ko00<00000003oo`00ool0GP00ool00`00
00000?mV003oIP0P003oIP030000000co`00<ol00100<ol000<000000<co003<o`002`3<o`000`00
0000oiT00?nI00090?nI00030000003o0000o`000080o`001@3oool100000040oooo000?0?ooo`03
0000003oool0oooo0080oooo103o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00/0
c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko001Vo`0L001Vo`0300000000ool00?oo05d0
0?oo00<00000003oIP00ofH08@00ofH00`000000<ol003?o000@03?o00030000003<o`00c?l000/0
c?l000<000000?nI003oV@002@3oV@000`000000o`000?l000020?l000D0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`@0o`0000<000000?l0V@3o09T0203o09T00`000000c03o
0<`0o`0;0<`0o`030000000c0?l0<`3o0100<`3o00<00000001Vo`00I_l07@00I_l00`0000000?oo
003oo`1L003oo`0300000000ofH00?mV02400?mV00<0000003?o000co`00400co`000`000000c?l0
0<co000;0<co00030000003oV@00oiT000T0oiT000<000000?l0003o00000P3o00050?ooo`400000
0@3oool000l0oooo00<000000?ooo`3oool00P3oool40?l000030000003o09T0o`2I00P0o`2I00<0
00000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01d006Ko00<0
0000003oo`00ool0G000ool00`0000000?mV003oIP0Q003oIP030000000co`00<ol00100<ol000<0
00000<co003<o`002`3<o`000`000000oiT00?nI00090?nI00030000003o0000o`000080o`001@3o
ool100000040oooo000?0?ooo`030000003oool0oooo0080oooo103o00000`000000o`2I0?l0V@08
0?l0V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko001Vo`0N
001Vo`0300000000ool00?oo05/00?oo00<00000003oIP00ofH08@00ofH00`000000<ol003?o000@
03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3oV@000`000000o`000?l00002
0?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`D0o`0000<000000?l0
V@3o09T0203o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0<`3o0100<`3o00<00000001V
o`00I_l07@00I_l00`0000000?oo003oo`1J003oo`0300000000ofH00?mV02400?mV00<0000003?o
000co`004@0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000T0oiT000<000000?l0
003o00000P3o00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool50?l00003
0000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`03
00000000I_l006Ko01d006Ko00<00000003oo`00ool0FP00ool00`0000000?mV003oIP0Q003oIP03
0000000co`00<ol00140<ol000<000000<co003<o`002P3<o`000`000000oiT00?nI000:0?nI0003
0000003o0000o`000080o`001@3oool100000040oooo000?0?ooo`8000000`3oool50?l000030000
003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`030000
0000I_l006Ko01h006Ko00<00000003oo`00ool0F@00ool00`0000000?mV003oIP0Q003oIP030000
000co`00<ol00100<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00090?nI00030000
003o0000o`0000<0o`00103oool200000040oooo000?0?ooo`030000003oool0oooo0080oooo1@3o
00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c0?l0400c
0?l00`00000006Ko001Vo`0N001Vo`0300000000ool00?oo05T00?oo00<00000003oIP00ofH08@00
ofH00`000000<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3o
V@000`000000o`000?l000030?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`02
0?ooo`H0o`0000<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0
<`3o0100<`3o00<00000001Vo`00I_l07@00I_l00`0000000?oo003oo`1H003oo`0300000000ofH0
0?mV02400?mV00<0000003?o000co`004@0co`000`000000c?l00<co000;0<co00030000003oV@00
oiT000T0oiT000<000000?l0003o00000`3o00050?ooo`4000000@3oool000l0oooo00<000000?oo
o`3oool00P3oool60?l000030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l02`3<0?l00`00
0000<`3o03<0o`0@03<0o`0300000000I_l006Ko01h006Ko00<00000003oo`00ool0E`00ool00`00
00000?mV003oIP0Q003oIP030000000co`00<ol00140<ol000<000000<co003<o`002`3<o`000`00
0000oiT00?nI00090?nI00030000003o0000o`0000<0o`001@3oool100000040oooo000?0?ooo`03
0000003oool0oooo0080oooo1P3o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00/0
c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko001Vo`0N001Vo`0300000000ool00?oo05L0
0?oo00<00000003oIP00ofH08@00ofH00`000000<ol003?o000A03?o00030000003<o`00c?l000/0
c?l000<000000?nI003oV@002@3oV@000`000000o`000?l000030?l000D0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`H0o`0000<000000?l0V@3o09T0203o09T00`000000c03o
0<`0o`0;0<`0o`030000000c0?l0<`3o0100<`3o00<00000001Vo`00I_l07P00I_l00`0000000?oo
003oo`1G003oo`0300000000ofH00?mV02400?mV00<0000003?o000co`004@0co`000`000000c?l0
0<co000;0<co00030000003oV@00oiT000T0oiT000<000000?l0003o00000`3o00050?ooo`400000
0@3oool000l0oooo00<000000?ooo`3oool00P3oool60?l000030000003o09T0o`2I00P0o`2I00<0
00000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01l006Ko00<0
0000003oo`00ool0EP00ool00`0000000?mV003oIP0Q003oIP030000000co`00<ol00140<ol000<0
00000<co003<o`002`3<o`000`000000oiT00?nI00090?nI00030000003o0000o`0000<0o`001@3o
ool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1P3o00000`000000o`2I0?l0V@08
0?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko001Vo`0N
001Vo`0300000000ool00?oo05H00?oo00<00000003oIP00ofH08@00ofH00`000000<ol003?o000A
03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3oV@000`000000o`000?l00003
0?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`H0o`0000<000000?l0
V@3o09T02@3o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0<`3o0100<`3o00<00000001V
o`00I_l07P00I_l00`0000000?oo003oo`1F003oo`0300000000ofH00?mV02400?mV00<0000003?o
000co`004@0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000T0oiT000<000000?l0
003o00000`3o00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool70?l00003
0000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`03
00000000I_l006Ko01l006Ko00<00000003oo`00ool0E@00ool00`0000000?mV003oIP0P003oIP03
0000000co`00<ol00140<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00090?nI0003
0000003o0000o`0000@0o`001@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo
1`3o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c0?l0
400c0?l00`00000006Ko001Vo`0O001Vo`0300000000ool00?oo05D00?oo00<00000003oIP00ofH0
8000ofH00`000000<ol003?o000A03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@00
2@3oV@000`000000o`000?l000040?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?oo
o`020?ooo`L0o`0000<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0<0<`0o`030000000c
0?l0<`3o0100<`3o00<00000001Vo`00I_l07P00I_l00`0000000?oo003oo`1E003oo`0300000000
ofH00?mV02000?mV00<0000003?o000co`004@0co`000`000000c?l00<co000;0<co00030000003o
V@00oiT000T0oiT000<000000?l0003o0000103o00050?ooo`4000000@3oool000l0oooo00<00000
0?ooo`3oool00P3oool70?l000030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l0
0`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01l006Ko00<00000003oo`00ool0E000ool0
0`0000000?mV003oIP0P003oIP030000000co`00<ol00140<ol000<000000<co003<o`002`3<o`00
0`000000oiT00?nI00090?nI00030000003o0000o`0000@0o`001@3oool100000040oooo000?0?oo
o`8000000`3oool70?l000030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l00`00
0000<`3o03<0o`0@03<0o`0300000000I_l006Ko01l006Ko00<00000003oo`00ool0E000ool00`00
00000?mV003oIP0P003oIP030000000co`00<ol00140<ol000<000000<co003<o`002`3<o`000`00
0000oiT00?nI00090?nI00030000003o0000o`0000@0o`00103oool200000040oooo000?0?ooo`03
0000003oool0oooo0080oooo1`3o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00`0
c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko001Vo`0O001Vo`0300000000ool00?oo05@0
0?oo00<00000003oIP00ofH08000ofH00`000000<ol003?o000A03?o00030000003<o`00c?l000/0
c?l000<000000?nI003oV@002@3oV@000`000000o`000?l000040?l000D0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`L0o`0000<000000?l0V@3o09T0203o09T00`000000c03o
0<`0o`0<0<`0o`030000000c0?l0<`3o0100<`3o00<00000001Vo`00I_l07`00I_l00`0000000?oo
003oo`1D003oo`0300000000ofH00?mV02000?mV00<0000003?o000co`004@0co`000`000000c?l0
0<co000;0<co00030000003oV@00oiT000T0oiT000<000000?l0003o0000103o00050?ooo`400000
0@3oool000l0oooo00<000000?ooo`3oool00P3oool70?l000030000003o09T0o`2I00P0o`2I00<0
00000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01l006Ko00<0
0000003oo`00ool0E000ool00`0000000?mV003oIP0P003oIP030000000co`00<ol00140<ol000<0
00000<co003<o`002`3<o`000`000000oiT00?nI00090?nI00030000003o0000o`0000@0o`001@3o
ool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1`3o00000`000000o`2I0?l0V@08
0?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko001Vo`0O
001Vo`0300000000ool00?oo05@00?oo00<00000003oIP00ofH08000ofH00`000000<ol003?o000A
03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3oV@000`000000o`000?l00004
0?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`L0o`0000<000000?l0
V@3o09T02@3o09T00`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0100<`3o00<00000001V
o`00I_l07`00I_l00`0000000?oo003oo`1C003oo`0300000000ofH00?mV02000?mV00<0000003?o
000co`00400co`000`000000c?l00<co000<0<co00030000003oV@00oiT000T0oiT000<000000?l0
003o0000103o00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool70?l00003
0000003o09T0o`2I00T0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0@03<0o`03
00000000I_l006Ko01l006Ko00<00000003oo`00ool0D`00ool00`0000000?mV003oIP0P003oIP03
0000000co`00<ol00100<ol000<000000<co003<o`00303<o`000`000000oiT00?nI00090?nI0003
0000003o0000o`0000@0o`001@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo
1`3o00000`000000o`2I0?l0V@090?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l0
400c0?l00`00000006Ko001Vo`0O001Vo`0300000000ool00?oo05<00?oo00<00000003oIP00ofH0
8000ofH00`000000<ol003?o000@03?o00030000003<o`00c?l000`0c?l000<000000?nI003oV@00
2@3oV@000`000000o`000?l000040?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?oo
o`020?ooo`L0o`0000<000000?l0V@3o09T02@3o09T00`000000c03o0<`0o`0<0<`0o`030000000c
0?l0<`3o0100<`3o00<00000001Vo`00I_l07`00I_l00`0000000?oo003oo`1C003oo`0300000000
ofH00?mV02000?mV00<0000003?o000co`00400co`000`000000c?l00<co000<0<co00030000003o
V@00oiT000T0oiT000<000000?l0003o0000103o00050?ooo`4000000@3oool000l0oooo00<00000
0?ooo`3oool00P3oool70?l000030000003o09T0o`2I00T0o`2I00<000000<`0o`3<0?l0303<0?l0
0`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01l006Ko00<00000003oo`00ool0D`00ool0
0`0000000?mV003oIP0P003oIP030000000co`00<ol00100<ol000<000000<co003<o`00303<o`00
0`000000oiT00?nI00090?nI00030000003o0000o`0000@0o`001@3oool100000040oooo000?0?oo
o`030000003oool0oooo0080oooo1`3o00000`000000o`2I0?l0V@090?l0V@030000003<0?l0c03o
00`0c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko001Vo`0O001Vo`0300000000ool00?oo
05<00?oo00<00000003oIP00ofH08000ofH00`000000<ol003?o000@03?o00030000003<o`00c?l0
00`0c?l000<000000?nI003oV@002@3oV@000`000000o`000?l000040?l000D0oooo0@0000010?oo
o`00203oool2000000D0oooo00<000000?ooo`3oool00P3oool70?l000030000003o09T0o`2I00T0
o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01l0
06Ko00<00000003oo`00ool0D`00ool00`0000000?mV003oIP0P003oIP030000000co`00<ol00100
<ol000<000000<co003<o`00303<o`000`000000oiT00?nI00090?nI00030000003o0000o`0000@0
o`001@3oool100000040oooo00070?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00P3oool70?l000030000003o09T0o`2I00T0o`2I00<000000<`0o`3<0?l0303<0?l00`000000
<`3o03<0o`0@03<0o`0300000000I_l006Ko020006Ko00<00000003oo`00ool0DP00ool00`000000
0?mV003oIP0P003oIP030000000co`00<ol00100<ol000<000000<co003<o`00303<o`000`000000
oiT00?nI00090?nI00030000003o0000o`0000@0o`001@3oool100000040oooo00070?ooo`040000
003oool0oooo000000@0oooo0`0000020?ooo`L0o`0000<000000?l0V@3o09T02@3o09T00`000000
c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0100<`3o00<00000001Vo`00I_l08000I_l00`000000
0?oo003oo`1B003oo`0300000000ofH00?mV02000?mV00<0000003?o000co`00400co`000`000000
c?l00<co000<0<co00030000003oV@00oiT000T0oiT000<000000?l0003o0000103o00040?ooo`80
00000@3oool000L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`P0
o`0000<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0140
<`3o00<00000001Vo`00I_l07`00I_l00`0000000?oo003oo`1C003oo`0300000000ofH00?mV01l0
0?mV00<0000003?o000co`004@0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000T0
oiT000<000000?l0003o0000103o00050?ooo`4000000@3oool000L0oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`020?ooo`P0o`0000<000000?l0V@3o09T0203o09T00`000000
c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0140<`3o00<00000001Vo`00I_l07`00I_l00`000000
0?oo003oo`1C003oo`0300000000ofH00?mV01l00?mV00<0000003?o000co`004@0co`000`000000
c?l00<co000;0<co00030000003oV@00oiT000T0oiT000<000000?l0003o0000103o00050?ooo`40
00000@3oool000P0oooo0P0000050?ooo`030000003oool0oooo0080oooo203o00000`000000o`2I
0?l0V@080?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l04@0c0?l00`00000006Ko
001Vo`0P001Vo`0300000000ool00?oo05800?oo00<00000003oIP00ofH07`00ofH00`000000<ol0
03?o000A03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3oV@000`000000o`00
0?l000040?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`P0o`0000<0
00000?l0V@3o09T0203o09T00`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0140<`3o00<0
0000001Vo`00I_l08000I_l00`0000000?oo003oo`1B003oo`0300000000ofH00?mV01l00?mV00<0
000003?o000co`004@0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000T0oiT000<0
00000?l0003o0000103o00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool8
0?l000030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0A
03<0o`0300000000I_l006Ko020006Ko00<00000003oo`00ool0DP00ool00`0000000?mV003oIP0O
003oIP030000000co`00<ol00140<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI0009
0?nI00030000003o0000o`0000@0o`001@3oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo203o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00`0c03o00<0000003<0
o`0c0?l04@0c0?l00`00000006Ko001Vo`0P001Vo`0300000000ool00?oo05800?oo00<00000003o
IP00ofH07`00ofH00`000000<ol003?o000A03?o00030000003<o`00c?l000/0c?l000<000000?nI
003oV@002@3oV@000`000000o`000?l000040?l000D0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`020?ooo`P0o`0000<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0<0<`0o`03
0000000c0?l0<`3o0140<`3o00<00000001Vo`00I_l08000I_l00`0000000?oo003oo`1B003oo`03
00000000ofH00?mV01l00?mV00<0000003?o000co`004@0co`000`000000c?l00<co000;0<co0003
0000003oV@00oiT000T0oiT000<000000?l0003o0000103o00050?ooo`4000000@3oool000l0oooo
00<000000?ooo`3oool00P3oool80?l000030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0
303<0?l00`000000<`3o03<0o`0A03<0o`0300000000I_l006Ko020006Ko00<00000003oo`00ool0
D`00ool00`0000000?mV003oIP0N003oIP030000000co`00<ol00140<ol000<000000<co003<o`00
2`3<o`000`000000oiT00?nI00090?nI00030000003o0000o`0000@0o`001@3oool100000040oooo
000?0?ooo`030000003oool0oooo0080oooo203o00000`000000o`2I0?l0V@080?l0V@030000003<
0?l0c03o00`0c03o00<0000003<0o`0c0?l04@0c0?l00`00000006Ko001Vo`0P001Vo`0300000000
ool00?oo05<00?oo00<00000003oIP00ofH07P00ofH00`000000<ol003?o000A03?o00030000003<
o`00c?l000/0c?l000<000000?nI003oV@002@3oV@000`000000o`000?l000040?l000D0oooo0@00
00010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`L0o`0000<000000?l0V@3o09T02@3o09T0
0`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0140<`3o00<00000001Vo`00I_l08000I_l0
0`0000000?oo003oo`1C003oo`0300000000ofH00?mV01l00?mV00<0000003?o000co`004@0co`00
0`000000c?l00<co000;0<co00030000003oV@00oiT000T0oiT000<000000?l0003o00000`3o0005
0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool70?l000030000003o09T0o`2I
00T0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0A03<0o`0300000000I_l006Ko
020006Ko00<00000003oo`00ool0D`00ool00`0000000?mV003oIP0O003oIP030000000co`00<ol0
0140<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00090?nI00030000003o0000o`00
00<0o`001@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1`3o00000`000000
o`2I0?l0V@090?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l04@0c0?l00`000000
06Ko001Vo`0P001Vo`0300000000ool00?oo05@00?oo00<00000003oIP00ofH07P00ofH00`000000
<ol003?o000A03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3oV@000`000000
o`000?l000030?l000D0oooo0@0000010?ooo`003`3oool2000000<0oooo1`3o00000`000000o`2I
0?l0V@090?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l04@0c0?l00`00000006Ko
001Vo`0P001Vo`0300000000ool00?oo05@00?oo00<00000003oIP00ofH07P00ofH00`000000<ol0
03?o000A03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3oV@000`000000o`00
0?l000030?l000@0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`L0o`0000<0
00000?l0V@3o09T02@3o09T00`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0140<`3o00<0
0000001Vo`00I_l08000I_l00`0000000?oo003oo`1D003oo`0300000000ofH00?mV01h00?mV00<0
000003?o000co`004@0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000T0oiT000<0
00000?l0003o00000`3o00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool7
0?l000030000003o09T0o`2I00T0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0A
03<0o`0300000000I_l006Ko020006Ko00<00000003oo`00ool0E000ool00`0000000?mV003oIP0N
003oIP030000000co`00<ol00140<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI0009
0?nI00030000003o0000o`0000<0o`001@3oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo1`3o00000`000000o`2I0?l0V@090?l0V@030000003<0?l0c03o00`0c03o00<0000003<0
o`0c0?l04@0c0?l00`00000006Ko001Vo`0P001Vo`0300000000ool00?oo05D00?oo00<00000003o
IP00ofH07@00ofH00`000000<ol003?o000A03?o00030000003<o`00c?l000/0c?l000<000000?nI
003oV@002@3oV@000`000000o`000?l000030?l000D0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`020?ooo`L0o`0000<000000?l0V@3o09T02@3o09T00`000000c03o0<`0o`0<0<`0o`03
0000000c0?l0<`3o0140<`3o00<00000001Vo`00I_l08000I_l00`0000000?oo003oo`1E003oo`03
00000000ofH00?mV01h00?mV00<0000003?o000co`00400co`000`000000c?l00<co000;0<co0003
0000003oV@00oiT000T0oiT000<000000?l0003o00000`3o00050?ooo`4000000@3oool000l0oooo
00<000000?ooo`3oool00P3oool70?l000030000003o09T0o`2I00T0o`2I00<000000<`0o`3<0?l0
303<0?l00`000000<`3o03<0o`0A03<0o`0300000000I_l006Ko020006Ko00<00000003oo`00ool0
E@00ool00`0000000?mV003oIP0N003oIP030000000co`00<ol00100<ol000<000000<co003<o`00
2`3<o`000`000000oiT00?nI00090?nI00030000003o0000o`0000<0o`001@3oool100000040oooo
000?0?ooo`030000003oool0oooo0080oooo1`3o00000`000000o`2I0?l0V@080?l0V@030000003<
0?l0c03o00`0c03o00<0000003<0o`0c0?l04@0c0?l00`00000006Ko001Vo`0Q001Vo`0300000000
ool00?oo05H00?oo00<00000003oIP00ofH07@00ofH00`000000<ol003?o000A03?o00030000003<
o`00c?l000X0c?l000<000000?nI003oV@002P3oV@000`000000o`000?l000020?l000D0oooo0@00
00010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`L0o`0000<000000?l0V@3o09T0203o09T0
0`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0140<`3o00<00000001Vo`00I_l08@00I_l0
0`0000000?oo003oo`1F003oo`0300000000ofH00?mV01d00?mV00<0000003?o000co`004@0co`00
0`000000c?l00<co000;0<co00030000003oV@00oiT000T0oiT000<000000?l0003o00000P3o0005
0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool70?l000030000003o09T0o`2I
00P0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0A03<0o`0300000000I_l006Ko
024006Ko00<00000003oo`00ool0EP00ool00`0000000?mV003oIP0N003oIP030000000co`00<ol0
0100<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00090?nI00030000003o0000o`00
0080o`001@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1`3o00000`000000
o`2I0?l0V@080?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l04@0c0?l00`000000
06Ko001Vo`0Q001Vo`0300000000ool00?oo05L00?oo00<00000003oIP00ofH07@00ofH00`000000
<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@002@3oV@000`000000
o`000?l000020?l000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`L0o`00
00<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0140<`3o
00<00000001Vo`00I_l08@00I_l00`0000000?oo003oo`1G003oo`0300000000ofH00?mV01d00?mV
00<0000003?o000co`00400co`000`000000c?l00<co000;0<co00030000003oV@00oiT000T0oiT0
00<000000?l0003o00000P3o00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3o
ool70?l000030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0
o`0A03<0o`0300000000I_l006Ko024006Ko00<00000003oo`00ool0E`00ool00`0000000?mV003o
IP0M003oIP030000000co`00<ol00100<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI
00090?nI00030000003o0000o`000080o`001@3oool100000040oooo000?0?ooo`030000003oool0
oooo0080oooo1`3o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00`0c03o00<00000
03<0o`0c0?l04@0c0?l00`00000006Ko001Vo`0Q001Vo`0300000000ool00?oo05P00?oo00<00000
003oIP00ofH07@00ofH00`000000<ol003?o000?03?o00030000003<o`00c?l000/0c?l000<00000
0?nI003oV@002@3oV@000`000000o`000?l000020?l000D0oooo0@0000010?ooo`003`3oool20000
00<0oooo1`3o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00`0c03o00<0000003<0
o`0c0?l0400c0?l00`00000006Ko001Vo`0Q001Vo`0300000000ool00?oo05T00?oo00<00000003o
IP00ofH07@00ofH00`000000<ol003?o000@03?o00030000003<o`00c?l000/0c?l000<000000?nI
003oV@00203oV@000`000000o`000?l000020?l000@0oooo0P0000010?ooo`003`3oool00`000000
oooo0?ooo`020?ooo`L0o`0000<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0<0<`0o`03
0000000c0?l0<`3o0100<`3o00<00000001Vo`00I_l08@00I_l00`0000000?oo003oo`1I003oo`03
00000000ofH00?mV01d00?mV00<0000003?o000co`00400co`000`000000c?l00<co000;0<co0003
0000003oV@00oiT000P0oiT000<000000?l0003o00000P3o00050?ooo`4000000@3oool000l0oooo
00<000000?ooo`3oool00P3oool60?l000030000003o09T0o`2I00T0o`2I00<000000<`0o`3<0?l0
2`3<0?l00`000000<`3o03<0o`0A03<0o`0300000000I_l006Ko024006Ko00<00000003oo`00ool0
FP00ool00`0000000?mV003oIP0M003oIP030000000co`00<ol000l0<ol000<000000<co003<o`00
2`3<o`000`000000oiT00?nI00090?nI00040000003o0000o`000?l000D0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`H0o`0000<000000?l0V@3o09T0203o09T00`000000c03o
0<`0o`0<0<`0o`030000000c0?l0<`3o0140<`3o00<00000001Vo`00I_l08@00I_l00`0000000?oo
003oo`1J003oo`0300000000ofH00?mV01d00?mV00<0000003?o000co`003`0co`000`000000c?l0
0<co000;0<co00030000003oV@00oiT000T0oiT000@000000?l0003o0000o`001@3oool100000040
oooo000?0?ooo`030000003oool0oooo0080oooo1P3o00000`000000o`2I0?l0V@080?l0V@030000
003<0?l0c03o00`0c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko001Vo`0Q001Vo`030000
0000ool00?oo05`00?oo00<00000003oIP00ofH07000ofH00`000000<ol003?o000@03?o00030000
003<o`00c?l000/0c?l000<000000?nI003oV@00203oV@0010000000o`000?l0003o00050?ooo`40
00000@3oool000l0oooo00<000000?ooo`3oool00P3oool60?l000030000003o09T0o`2I00P0o`2I
00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko024006Ko
00<00000003oo`00ool0G000ool00`0000000?mV003oIP0M003oIP030000000co`00<ol000l0<ol0
00<000000<co003<o`002`3<o`000`000000oiT00?nI00080?nI00040000003o0000o`000?l000D0
oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`H0o`0000<000000?l0V@3o09T0
203o09T00`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0100<`3o00<00000001Vo`00I_l0
8@00I_l00`0000000?oo003oo`1M003oo`0300000000ofH00?mV01`00?mV00<0000003?o000co`00
3`0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000P0oiT000@000000?l0003o0000
o`001@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1P3o00000`000000o`2I
0?l0V@080?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko
001Vo`0Q001Vo`0300000000ool00?oo05h00?oo00<00000003oIP00ofH06`00ofH00`000000<ol0
03?o000?03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@00203oV@0010000000o`00
0?l0003o00050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool60?l000030000
003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0@03<0o`030000
0000I_l006Ko024006Ko00<00000003oo`00ool0GP00ool00`0000000?mV003oIP0L003oIP030000
000co`00<ol000l0<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00080?nI00030000
003o0000o`0000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`D0o`0000<0
00000?l0V@3o09T0203o09T00`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0100<`3o00<0
0000001Vo`00I_l08@00I_l00`0000000?oo003oo`1P003oo`0300000000ofH00?mV01/00?mV00<0
000003?o000co`003`0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000P0oiT000<0
00000?l0003o00001@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1@3o0000
0`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l0400c0?l0
0`00000006Ko001Vo`0Q001Vo`0300000000ool00?oo06000?oo00<00000003oIP00ofH06`00ofH0
0`000000<ol003?o000?03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@00203oV@00
0`000000o`000?l000050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool50?l0
00030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0@03<0
o`0300000000I_l006Ko024006Ko00<00000003oo`00ool0H@00ool00`0000000?mV003oIP0K003o
IP030000000co`00<ol000l0<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00080?nI
00030000003o0000oooo00@0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`D0
o`0000<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0100
<`3o00<00000001Vo`00I_l08@00I_l00`0000000?oo003oo`1Q003oo`0300000000ofH00?mV01/0
0?mV00<0000003?o000co`003`0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000P0
oiT000<000000?l0003oool0103oool100000040oooo000?0?ooo`8000000`3oool40?l000030000
003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0@03<0o`030000
0000I_l006Ko024006Ko00<00000003oo`00ool0H`00ool00`0000000?mV003oIP0J003oIP030000
000co`00<ol000l0<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00080?nI00030000
003o0000oooo00<0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`@0o`0000<0
00000?l0V@3o09T0203o09T00`000000c03o0<`0o`0<0<`0o`030000000c0?l0<`3o0100<`3o00<0
0000001Vo`00I_l08@00I_l00`0000000?oo003oo`1S003oo`0300000000ofH00?mV01/00?mV00<0
000003?o000co`003`0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000P0oiT000<0
00000?ooo`3oool00`3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo103o0000
0`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l0400c0?l0
0`00000006Ko001Vo`0Q001Vo`0300000000ool00?oo06@00?oo00<00000003oIP00ofH06P00ofH0
0`000000<ol003?o000?03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@00203oV@00
0`000000oooo0?ooo`030?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool40?l0
00030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0@03<0
o`0300000000I_l006Ko024006Ko00<00000003oo`00ool0I000ool00`0000000?mV003oIP0J003o
IP030000000co`00<ol000l0<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00080?nI
00030000003oool0oooo00<0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`@0
o`0000<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0<`3o0100
<`3o00<00000001Vo`00I_l08@00I_l00`0000000?oo003oo`1V003oo`0300000000ofH00?mV01X0
0?mV00<0000003?o000co`003`0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000L0
oiT000<000000?ooo`3oool00`3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo
0`3o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00`0c03o00<0000003<0o`0c0?l0
400c0?l00`00000006Ko001Vo`0Q001Vo`0300000000ool00?oo06L00?oo00<00000003oIP00ofH0
6@00ofH00`000000<ol003?o000?03?o00030000003<o`00c?l000/0c?l000<000000?nI003oV@00
203oV@000`000000oooo0?ooo`020?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3o
ool30?l000030000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0
o`0@03<0o`0300000000I_l006Ko024006Ko00<00000003oo`00ool0I`00ool00`0000000?mV003o
IP0J003oIP030000000co`00<ol000h0<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI
00080?nI00030000003oool0oooo0080oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`02
0?ooo`<0o`0000<000000?l0V@3o09T0203o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0
<`3o0100<`3o00<00000001Vo`00I_l08@00I_l00`0000000?oo003oo`1Y003oo`0300000000ofH0
0?mV01T00?mV00<0000003?o000co`003`0co`000`000000c?l00<co000;0<co00030000003oV@00
oiT000L0oiT000<000000?ooo`3oool00P3oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo0`3o00000`000000o`2I0?l0V@080?l0V@030000003<0?l0c03o00/0c03o00<0000003<0
o`0c0?l0400c0?l00`00000006Ko001Vo`0Q001Vo`0300000000ool00?oo06T00?oo00<00000003o
IP00ofH06P00ofH00`000000<ol003?o000>03?o00030000003<o`00c?l000/0c?l000<000000?nI
003oV@001`3oV@050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool20?l00003
0000003o09T0o`2I00P0o`2I00<000000<`0o`3<0?l0303<0?l00`000000<`3o03<0o`0@03<0o`03
00000000I_l006Ko024006Ko00<00000003oo`00ool0JP00ool00`0000000?mV003oIP0I003oIP03
0000000co`00<ol000h0<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00070?nI00D0
oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`80o`0000<000000?l0V@3o09T0
203o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0<`3o0100<`3o00<00000001Vo`00I_l0
8@00I_l00`0000000?oo003oo`1[003oo`0300000000ofH00?mV01X00?mV00<0000003?o000co`00
3P0co`000`000000c?l00<co000;0<co00030000003oV@00oiT000H0oiT01@3oool100000040oooo
00070?ooo`@00000103oool00`000000oooo0?ooo`020?ooo`80o`0000<000000?l0V@3o09T0203o
09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0<`3o0100<`3o00<00000001Vo`00I_l08@00
I_l00`0000000?oo003oo`1/003oo`0300000000ofH00?mV01T00?mV00<0000003?o000co`003P0c
o`000`000000c?l00<co000;0<co00030000003oV@00oiT000H0oiT01@3oool100000040oooo0007
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool20?l000030000003o09T0
o`2I00P0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l0
06Ko020006Ko00<00000003oo`00ool0KP00ool00`0000000?mV003oIP0H003oIP030000000co`00
<ol000h0<ol000<000000<co003<o`002`3<o`000`000000oiT00?nI00060?nI00D0oooo0@000001
0?ooo`00203oool00`000000oooo0?ooo`040?ooo`<000000P3oool00`3o000000000?l0V@090?l0
V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c0?l0400c0?l00`00000006Ko001Vo`0P001V
o`0300000000ool00?oo06l00?oo00<00000003oIP00ofH06@00ofH00`000000<ol003?o000>03?o
00030000003<o`00c?l000X0c?l000<000000?nI003oV@001P3oV@040?ooo`8000000@3oool000T0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030?l000000000o`2I00T0
o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko0200
06Ko00<00000003oo`00ool0L000ool00`0000000?mV003oIP0H003oIP030000000co`00<ol000h0
<ol000<000000<co003<o`002P3<o`000`000000oiT00?nI00060?nI00D0oooo0@0000010?ooo`00
1`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00<000000?l0V@3o
09T02@3o09T00`000000c03o0<`0o`0;0<`0o`030000000c0?l0<`3o0100<`3o00<00000001Vo`00
I_l07`00I_l00`0000000?oo003oo`1b003oo`0300000000ofH00?mV01P00?mV00<0000003?o000c
o`003P0co`000`000000c?l00<co000:0<co00030000003oV@00oiT000D0oiT01@3oool100000040
oooo00080?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`030000003o09T0o`2I00P0o`2I
00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01l006Ko
00<00000003oo`00ool0M000ool00`0000000?mV003oIP0G003oIP030000000co`00<ol000h0<ol0
00<000000<co003<o`002P3<o`000`000000oiT00?nI00050?nI00D0oooo0@0000010?ooo`003`3o
ool00`000000oooo0?ooo`020?ooo`/0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0
o`0@03<0o`0300000000I_l006Ko01l006Ko00<00000003oo`00ool0M000ool00`0000000?mV003o
IP0H003oIP030000000co`00<ol000h0<ol000<000000<co003<o`002P3<o`000`000000oiT00?nI
00040?nI00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`/0o`2I00<00000
0<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01h006Ko00<00000
003oo`00ool0MP00ool00`0000000?mV003oIP0G003oIP030000000co`00<ol000h0<ol000<00000
0<co003<o`002P3<o`000`000000oiT00?nI00040?nI00D0oooo0@0000010?ooo`003`3oool00`00
0000oooo0?ooo`020?ooo`X0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0@03<0
o`0300000000I_l006Ko01l006Ko00<00000003oo`00ool0M`00ool00`0000000?mV003oIP0G003o
IP030000000co`00<ol000h0<ol000<000000<co003<o`002P3<o`000`000000oiT00?nI00030?nI
00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`X0o`2I00<000000<`0o`3<
0?l02`3<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01h006Ko00<00000003oo`00
ool0N@00ool00`0000000?mV003oIP0G003oIP030000000co`00<ol000d0<ol000<000000<co003<
o`002P3<o`000`000000oiT00?nI00030?nI00D0oooo0@0000010?ooo`003`3oool00`000000oooo
0?ooo`020?ooo`X0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0?03<0o`030000
0000I_l006Ko01h006Ko00<00000003oo`00ool0N`00ool00`0000000?mV003oIP0G003oIP030000
000co`00<ol000`0<ol000<000000<co003<o`002P3<o`000`000000oiT00?nI00030?nI00D0oooo
0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`T0o`2I00<000000<`0o`3<0?l02`3<
0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01h006Ko00<00000003oo`00ool0O000
ool00`0000000?mV003oIP0F003oIP030000000co`00<ol000d0<ol000<000000<co003<o`002P3<
o`000`000000oiT00?nI00020?nI00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`02
0?ooo`T0o`2I00<000000<`0o`3<0?l02`3<0?l00`000000<`3o03<0o`0?03<0o`0300000000I_l0
06Ko01h006Ko00<00000003oo`00ool0O@00ool00`0000000?mV003oIP0G003oIP030000000co`00
<ol000d0<ol000<000000<co003<o`002@3<o`000`000000oiT00?nI00020?nI00D0oooo0@000001
0?ooo`003`3oool00`000000oooo0?ooo`020?ooo`T0o`2I00<000000<`0o`3<0?l02P3<0?l00`00
0000<`3o03<0o`0@03<0o`0300000000I_l006Ko01d006Ko00<00000003oo`00ool0O`00ool00`00
00000?mV003oIP0F003oIP030000000co`00<ol000d0<ol000<000000<co003<o`002P3<o`001000
0000oiT00?nI003oV@050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool80?l0
V@030000003<0?l0c03o00/0c03o00<0000003<0o`0c0?l03`0c0?l00`00000006Ko001Vo`0N001V
o`0300000000ool00?oo08000?oo00<00000003oIP00ofH05P00ofH00`000000<ol003?o000=03?o
00030000003<o`00c?l000T0c?l000@000000?nI003oV@00oiT01@3oool100000040oooo000?0?oo
o`8000000`3oool80?l0V@030000003<0?l0c03o00X0c03o00<0000003<0o`0c0?l0400c0?l00`00
000006Ko001Vo`0M001Vo`0300000000ool00?oo08800?oo00<00000003oIP00ofH05@00ofH00`00
0000<ol003?o000=03?o00030000003<o`00c?l000X0c?l000<000000?nI003oV@00103oool20000
0040oooo000?0?ooo`030000003oool0oooo0080oooo203o09T00`000000c03o0<`0o`0:0<`0o`03
0000000c0?l0<`3o00l0<`3o00<00000001Vo`00I_l07@00I_l00`0000000?oo003oo`23003oo`03
00000000ofH00?mV01H00?mV00<0000003?o000co`003@0co`000`000000c?l00<co00090<co0003
0000003oV@00oiT000D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`L0o`2I
00<000000<`0o`3<0?l02P3<0?l00`000000<`3o03<0o`0@03<0o`0300000000I_l006Ko01d006Ko
00<00000003oo`00ool0Q000ool00`0000000?mV003oIP0E003oIP030000000co`00<ol000d0<ol0
00<000000<co003<o`002P3<o`000`000000oiT00?ooo`040?ooo`4000000@3oool000l0oooo00<0
00000?ooo`3oool00P3oool70?l0V@030000003<0?l0c03o00X0c03o00<0000003<0o`0c0?l03`0c
0?l00`00000006Ko001Vo`0M001Vo`0300000000ool00?oo08H00?oo00<00000003oIP00ofH05@00
ofH00`000000<ol003?o000=03?o00030000003<o`00c?l000T0c?l000<000000?nI003oool0103o
ool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1`3o09T00`000000c03o0<`0o`09
0<`0o`030000000c0?l0<`3o00l0<`3o00<00000001Vo`00I_l07@00I_l00`0000000?oo003oo`28
003oo`0300000000ofH00?mV01D00?mV00<0000003?o000co`00300co`000`000000c?l00<co0009
0<co00030000003oV@00oooo00@0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?oo
o`H0o`2I00<000000<`0o`3<0?l02P3<0?l00`000000<`3o03<0o`0?03<0o`0300000000I_l006Ko
01`006Ko00<00000003oo`00ool0RP00ool00`0000000?mV003oIP0D003oIP030000000co`00<ol0
00d0<ol000<000000<co003<o`002@3<o`000`000000oooo0?ooo`030?ooo`4000000@3oool000l0
oooo00<000000?ooo`3oool00P3oool60?l0V@030000003<0?l0c03o00T0c03o00<0000003<0o`0c
0?l03`0c0?l00`00000006Ko001Vo`0L001Vo`0300000000ool00?oo08`00?oo00<00000003oIP00
ofH05000ofH00`000000<ol003?o000<03?o00030000003<o`00c?l000T0c?l000<000000?ooo`3o
ool00`3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1@3o09T00`000000c03o
0<`0o`0:0<`0o`030000000c0?l0<`3o00h0<`3o00<00000001Vo`00I_l07000I_l00`0000000?oo
003oo`2>003oo`0300000000ofH00?mV01<00?mV00<0000003?o000co`003@0co`000`000000c?l0
0<co00090<co00030000003oool0oooo0080oooo0@0000010?ooo`003`3oool00`000000oooo0?oo
o`020?ooo`D0o`2I00<000000<`0o`3<0?l02P3<0?l00`000000<`3o03<0o`0>03<0o`0300000000
I_l006Ko01/006Ko00<00000003oo`00ool0S`00ool00`0000000?mV003oIP0D003oIP030000000c
o`00<ol000`0<ol000<000000<co003<o`002@3<o`000`000000oooo0?ooo`020?ooo`4000000@3o
ool000l0oooo00<000000?ooo`3oool00P3oool40?l0V@030000003<0?l0c03o00X0c03o00<00000
03<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0K001Vo`0300000000ool00?oo09400?oo00<00000
003oIP00ofH05000ofH00`000000<ol003?o000<03?o00030000003<o`00c?l000P0c?l01@3oool1
00000040oooo000?0?ooo`030000003oool0oooo0080oooo103o09T00`000000c03o0<`0o`0:0<`0
o`030000000c0?l0<`3o00h0<`3o00<00000001Vo`00I_l06P00I_l00`0000000?oo003oo`2C003o
o`0300000000ofH00?mV01<00?mV00<0000003?o000co`00300co`000`000000c?l00<co00080<co
00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`<0o`2I00<000000<`0o`3<
0?l02P3<0?l00`000000<`3o03<0o`0>03<0o`0300000000I_l006Ko01X006Ko00<00000003oo`00
ool0U@00ool00`0000000?mV003oIP0C003oIP030000000co`00<ol000`0<ol000<000000<co003<
o`001`3<o`050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool30?l0V@030000
003<0?l0c03o00X0c03o00<0000003<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0J001Vo`030000
0000ool00?oo09H00?oo00<00000003oIP00ofH04`00ofH00`000000<ol003?o000;03?o00030000
003<o`00c?l000L0c?l01@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo0P3o
09T00`000000c03o0<`0o`0:0<`0o`030000000c0?l0<`3o00h0<`3o00<00000001Vo`00I_l06P00
I_l00`0000000?oo003oo`2H003oo`0300000000ofH00?mV01<00?mV00<0000003?o000co`002`0c
o`000`000000c?l00<co00060<co00D0oooo0@0000010?ooo`003`3oool2000000<0oooo0P3o09T0
0`000000c03o0<`0o`0:0<`0o`030000000c0?l0<`3o00d0<`3o00<00000001Vo`00I_l06P00I_l0
0`0000000?oo003oo`2J003oo`0300000000ofH00?mV01800?mV00<0000003?o000co`00300co`00
0`000000c?l00<co00050<co00@0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`020?oo
o`030?l0V@000000c03o00/0c03o00<0000003<0o`0c0?l03P0c0?l00`00000006Ko001Vo`0I001V
o`0300000000ool00?oo09`00?oo00<00000003oIP00ofH04P00ofH00`000000<ol003?o000;03?o
00030000003<o`00c?l000D0c?l01@3oool100000040oooo000?0?ooo`030000003oool0oooo0080
oooo00<0o`2I0000003<0?l02`3<0?l00`000000<`3o03<0o`0=03<0o`0300000000I_l006Ko01P0
06Ko0P00002P003oo`0300000000ofH00?mV01800?mV00<0000003?o000co`002`0co`000`000000
c?l00<co00040<co00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`030000
003<0?l0c03o00X0c03o00<0000003<0o`0c0?l03@0c0?l00`00000006Ko001Vo`0H001Vo`030000
0000ool00?oo0:000?oo00<00000003oIP00ofH04P00ofH00`000000<ol003?o000;03?o00030000
003<o`00c?l000@0c?l01@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo3@3<
0?l00`000000<`3o03<0o`0<03<0o`0300000000I_l006Ko01P006Ko00<00000003oo`00ool0XP00
ool00`0000000?mV003oIP0B003oIP030000000co`00<ol000/0<ol000<000000<co003<o`000`3<
o`050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool<0<`0o`030000000c0?l0
<`3o00d0<`3o00<00000001Vo`00I_l05`00I_l00`0000000?oo003oo`2T003oo`0300000000ofH0
0?mV01800?mV00<0000003?o000co`002`0co`000`000000c?l00<co00020<co00D0oooo0@000001
0?ooo`003`3oool00`000000oooo0?ooo`020?ooo``0c03o00<0000003<0o`0c0?l0300c0?l00`00
000006Ko001Vo`0G001Vo`0300000000ool00?oo0:H00?oo00<00000003oIP00ofH04@00ofH00`00
0000<ol003?o000;03?o00030000003<o`00c?l00080c?l01@3oool100000040oooo000?0?ooo`03
0000003oool0oooo0080oooo2`3<0?l00`000000<`3o03<0o`0=03<0o`0300000000I_l006Ko01H0
06Ko00<00000003oo`00ool0Z000ool00`0000000?mV003oIP0A003oIP030000000co`00<ol000/0
<ol000@000000<co003<o`00c?l01@3oool100000040oooo000?0?ooo`030000003oool0oooo0080
oooo2P3<0?l00`000000<`3o03<0o`0=03<0o`0300000000I_l006Ko01H006Ko00<00000003oo`00
ool0ZP00ool00`0000000?mV003oIP0A003oIP030000000co`00<ol000/0<ol000<000000<co003<
o`001@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo2@3<0?l00`000000<`3o
03<0o`0=03<0o`0300000000I_l006Ko01H006Ko00<00000003oo`00ool0[000ool00`0000000?mV
003oIP0A003oIP030000000co`00<ol000X0<ol000<000000<co003<o`001@3oool100000040oooo
000?0?ooo`030000003oool0oooo0080oooo203<0?l00`000000<`3o03<0o`0>03<0o`0300000000
I_l006Ko01D006Ko00<00000003oo`00ool0M@00ool7000003800?oo00<00000003oIP00ofH04000
ofH00`000000<ol003?o000;03?o00030000003<o`00oooo00@0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?ooo`P0c03o00<0000003<0o`0c0?l03@0c0?l00`00000006Ko001Vo`0E
001Vo`0300000000ool00?oo07800?oo10000007001Vo`H00000;@00ool00`0000000?mV003oIP0@
003oIP030000000co`00<ol000/0<ol000<000000?ooo`3oool00`3oool100000040oooo000?0?oo
o`030000003oool0oooo0080oooo1`3<0?l00`000000<`3o03<0o`0=03<0o`0300000000I_l006Ko
01D006Ko00<00000003oo`00ool0L000ool30000014006Ko0`00000[003oo`0300000000ofH00?mV
01000?mV00<0000003?o000co`002P0co`000`000000oooo0?ooo`030?ooo`4000000@3oool000l0
oooo0P0000030?ooo`L0c03o00<0000003<0o`0c0?l0300c0?l00`00000006Ko001Vo`0E001Vo`03
00000000ool00?oo06l00?oo0P00000G001Vo`<00000:@00ool00`0000000?mV003oIP0@003oIP03
0000000co`00<ol000X0<ol000@000000?ooo`3oool0oooo0P0000010?ooo`003`3oool00`000000
oooo0?ooo`020?ooo`H0c03o00<0000003<0o`0c0?l03@0c0?l00`00000006Ko001Vo`0D001Vo`03
00000000ool00?oo06h00?oo0P00000L001Vo`<000009`00ool00`0000000?mV003oIP0?003oIP03
0000000co`00<ol000X0<ol01@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo
1P3<0?l00`000000<`3o03<0o`0<03<0o`0300000000I_l006Ko01@006Ko00<00000003oo`00ool0
K@00ool20000024006Ko1000000T003oo`0300000000ofH00?mV00l00?mV00<0000003?o000co`00
2@0co`050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool50<`0o`030000000c
0?l0<`3o00`0<`3o00<00000001Vo`00I_l05000I_l00`0000000?oo003oo`1[003oo`<000009`00
I_l2000002<00?oo00<00000003oIP00ofH03`00ofH00`000000<ol003?o000803?o00D0oooo0@00
00010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`@0c03o00<0000003<0o`0c0?l0300c0?l0
0`00000006Ko001Vo`0D001Vo`0300000000ool00?oo06/00?oo00<00000001Vo`00I_l0:P00I_l3
000002400?oo00<00000003oIP00ofH03`00ofH00`000000<ol003?o000703?o00D0oooo0@000001
0?ooo`003`3oool00`000000oooo0?ooo`020?ooo`@0c03o00<0000003<0o`0c0?l02`0c0?l00`00
000006Ko001Vo`0D001Vo`0300000000ool00?oo06/00?oo00<00000001Vo`00I_l0;P00I_l20000
02000?oo00<00000003oIP00ofH03P00ofH00`000000<ol003?o000703?o00D0oooo0@0000010?oo
o`003`3oool00`000000oooo0?ooo`020?ooo`<0c03o00<0000003<0o`0c0?l02`0c0?l00`000000
06Ko001Vo`0C001Vo`800000KP00ool00`00000006Ko001Vo`0`001Vo`8000007`00ool00`000000
0?mV003oIP0>003oIP030000000co`00<ol000H0<ol01@3oool100000040oooo000?0?ooo`030000
003oool0oooo0080oooo0P3<0?l00`000000<`3o03<0o`0;03<0o`0300000000I_l006Ko01<006Ko
00<00000003oo`00ool0K@00ool00`00000006Ko001Vo`0c001Vo`8000007P00ool00`0000000?mV
003oIP0>003oIP030000000co`00<ol000D0<ol01@3oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo00<0c03o0000000c0?l0300c0?l00`00000006Ko001Vo`0C001Vo`0300000000
ool00?oo06d00?oo00<00000001Vo`00I_l0=P00I_l2000001d00?oo00<00000003oIP00ofH03P00
ofH00`000000<ol003?o000403?o00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`02
0?ooo`030<`0o`000000<`3o00`0<`3o00<00000001Vo`00I_l04P00I_l00`0000000?oo003oo`1]
003oo`0300000000I_l006Ko03T006Ko0P00000L003oo`0300000000ofH00?mV00d00?mV00<00000
03?o000co`00100co`050?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool00`00
0000<`3o03<0o`0;03<0o`0300000000I_l006Ko018006Ko00<00000003oo`00ool0KP00ool00`00
000006Ko001Vo`0k001Vo`8000006`00ool00`0000000?mV003oIP0=003oIP030000000co`00<ol0
00<0<ol01@3oool100000040oooo00090?ooo`<000000`3oool00`000000oooo0?ooo`020?ooo`d0
<`3o00<00000001Vo`00I_l04P00I_l00`0000000?oo003oo`1^003oo`0300000000I_l006Ko03h0
06Ko0P00000J003oo`0300000000ofH00?mV00d00?mV00<0000003?o000co`000P0co`050?ooo`40
00000@3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo``0<`3o
00<00000001Vo`00I_l04P00I_l00`0000000?oo003oo`1^003oo`0300000000I_l006Ko044006Ko
00<00000003oo`00ool06000ool00`0000000?mV003oIP0=003oIP040000000co`00<ol003?o00D0
oooo0@0000010?ooo`001`3oool5000000<0oooo0`0000020?ooo`/0<`3o00<00000001Vo`00I_l0
4@00I_l2000007000?oo00<00000001Vo`00I_l0@`00I_l2000001T00?oo00<00000003oIP00ofH0
3@00ofH00`000000<ol003?o00040?ooo`8000000@3oool000L0oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`020?ooo`X0<`3o00<00000001Vo`00I_l04@00I_l00`0000000?oo
003oo`1`003oo`0300000000I_l006Ko04D006Ko0P00000H003oo`0300000000ofH00?mV00d00?mV
00<0000003?o003oool0103oool100000040oooo00080?ooo`030000003oool0000000@0oooo00<0
00000?ooo`3oool00P3oool:03<0o`0300000000I_l006Ko00l006Ko0P00001b003oo`0300000000
I_l006Ko04P006Ko00<00000003oo`00ool05P00ool00`0000000?mV003oIP0<003oIP030000000c
o`00oooo00@0oooo0@0000010?ooo`002@3oool2000000@0oooo00<000000?ooo`3oool00P3oool9
03<0o`0300000000I_l006Ko00l006Ko00<00000003oo`00ool0LP00ool00`00000006Ko001Vo`19
001Vo`8000005`00ool00`0000000?mV003oIP0<003oIP030000003oool0oooo00<0oooo0@000001
0?ooo`003`3oool00`000000oooo0?ooo`020?ooo`P0<`3o00<00000001Vo`00I_l03`00I_l00`00
00000?oo003oo`1b003oo`0300000000I_l006Ko04`006Ko00<00000003oo`00ool05@00ool00`00
00000?mV003oIP0<003oIP030000003oool0oooo0080oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`020?ooo`L0<`3o00<00000001Vo`00I_l03`00I_l00`0000000?oo003oo`1c003oo`03
00000000I_l006Ko04d006Ko0P00000F003oo`0300000000ofH00?mV00/00?mV1@3oool100000040
oooo000?0?ooo`030000003oool0oooo0080oooo1`0c0?l00`00000006Ko001Vo`0>001Vo`030000
0000ool00?oo07@00?oo00<00000001Vo`00I_l0C`00I_l00`0000000?oo003oo`0D003oo`030000
0000ofH00?mV00X00?mV1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1P0c
0?l00`00000006Ko001Vo`0>001Vo`0300000000ool00?oo02`00?oo10000014003oo`0300000000
I_l006Ko054006Ko0P00000E003oo`0300000000ofH00?mV00T00?mV1@3oool100000040oooo000?
0?ooo`030000003oool0oooo0080oooo1@0c0?l00`00000006Ko001Vo`0>001Vo`0300000000ool0
0?oo02@00?oo2@000004003oIPD00000?`00ool00`00000006Ko001Vo`1C001Vo`0300000000ool0
0?oo01<00?oo00<00000003oIP00ofH02000ofH50?ooo`4000000@3oool000l0oooo00<000000?oo
o`3oool00P3oool403<0o`0300000000I_l006Ko00h006Ko00<00000003oo`00ool08@00ool40000
01800?mV1000000k003oo`0300000000I_l006Ko05@006Ko0P00000D003oo`0300000000ofH00?mV
00L00?mV1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo0`0c0?l00`000000
06Ko001Vo`0=001Vo`8000008000ool4000001X00?mV0P00000h003oo`0300000000I_l006Ko05L0
06Ko00<00000003oo`00ool04P00ool00`0000000?mV003oIP06003oIPD0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`80<`3o00<00000001Vo`00I_l03@00I_l00`0000000?oo
003oo`0M003oo`<000008000ofH2000003H00?oo00<00000001Vo`00I_l0F000I_l2000001<00?oo
00<00000003oIP00ofH01@00ofH50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3o
ool00`0c0?l00000001Vo`0>001Vo`0300000000ool00?oo01/00?oo0`00000U003oIP800000=000
ool00`00000006Ko001Vo`1J001Vo`0300000000ool00?oo01400?oo00<00000003oIP00ofH01000
ofH50?ooo`4000000@3oool000l0oooo0P0000030?ooo`0300000000I_l006Ko00d006Ko00<00000
003oo`00ool06P00ool2000002X00?mV0P00000a003oo`0300000000I_l006Ko05`006Ko0P00000B
003oo`0300000000ofH00?mV00<00?mV103oool200000040oooo000?0?ooo`030000003oool0oooo
0080oooo3`00I_l00`0000000?oo003oo`0I003oo`800000;P00ofH00`0000000?oo003oo`0^003o
o`0300000000I_l006Ko05h006Ko00<00000003oo`00ool04000ool00`0000000?mV003oIP02003o
IPD0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`h006Ko00<00000003oo`00
ool06000ool2000003400?mV0P00000^003oo`0300000000I_l006Ko05l006Ko00<00000003oo`00
ool04000ool0100000000?mV003oIP00ofH50?ooo`4000000@3oool000l0oooo00<000000?ooo`3o
ool00P3oool=001Vo`0300000000ool00?oo01L00?oo0P00000e003oIP0300000000ool00?oo02X0
0?oo00<00000001Vo`00I_l0H@00I_l2000001400?oo00<00000003oIP00ofH01@3oool100000040
oooo000?0?ooo`030000003oool0oooo0080oooo3000I_l00`0000000?oo003oo`0G003oo`030000
0000ofH00?mV03H00?mV00<00000003oo`00ool0:@00ool00`00000006Ko001Vo`1S001Vo`030000
0000ool00?oo00l00?oo00<00000003oIP3oool0103oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo2P00I_l2000001L00?oo0`00000j003oIP0300000000ool00?oo02P00?oo00<0
0000001Vo`00I_l0I000I_l2000001000?oo0P0000040?ooo`4000000@3oool000l0oooo00<00000
0?ooo`3oool00P3oool9001Vo`0300000000ool00?oo01D00?oo0P00000n003oIP0300000000ool0
0?oo02L00?oo00<00000001Vo`00I_l0IP00I_l00`0000000?oo003oo`0>003oo`D0oooo0@000001
0?ooo`003`3oool00`000000oooo0?ooo`020?ooo`P006Ko00<00000003oo`00ool05000ool20000
04000?mV00<00000003oo`00ool09P00ool00`00000006Ko001Vo`0e001Voa0000008`00I_l20000
00h00?oo1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1`00I_l00`000000
0?oo003oo`0C003oo`800000@`00ofH00`0000000?oo003oo`0U003oo`0300000000I_l006Ko02l0
06Ko1P00000@03<0o`@000008@00I_l00`0000000?oo003oo`0;003oo`D0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`H006Ko00<00000003oo`00ool04P00ool2000004H00?mV
00<00000003oo`00ool09000ool00`00000006Ko001Vo`0/001Vo`<000006P0c0?l4000001h006Ko
00<00000003oo`00ool02P00ool50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3o
ool4001Vo`8000004`00ool2000004T00?mV00<00000003oo`00ool08`00ool00`00000006Ko001V
o`0Y001Vo`<000008@0c0?l3000001`006Ko0P00000:003oo`D0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?ooo`<006Ko00<00000003oo`00ool04P00ool00`0000000?mV003oIP19
003oIP0300000000ool00?oo02800?oo00<00000001Vo`00I_l0:000I_l2000002L0<`3o0`00000K
001Vo`0300000000ool00?oo00L00?oo1@3oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo0P00I_l00`0000000?oo003oo`0A003oo`800000C@00ofH00`0000000?oo003oo`0Q003o
o`0300000000I_l006Ko02H006Ko0P00000/03<0o`8000006P00I_l00`0000000?oo003oo`06003o
o`D0oooo0@0000010?ooo`003`3oool2000000<0oooo00<006Ko00000000ool04P00ool00`000000
0?mV003oIP1>003oIP0300000000ool00?oo02000?oo00<00000001Vo`00I_l09@00I_l00`000000
<`3o03<0o`0^03<0o`8000006@00I_l2000000H00?oo103oool200000040oooo000?0?ooo`030000
003oool0oooo0?l0oooo3@3oool100000040oooo000?0?ooo`030000003oool0oooo0?l0oooo3@3o
ool100000040oooo000?0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`0L0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool10000
0040oooo000?0?ooool000004@0000010?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{81, 368}, {630.812, 343.812}} -> {-8.89277, 7.43633, \
0.0383087, 0.0383087}},
  CellTags->"b:1.1.0.5"]
}, Open  ]],

Cell[TextData[{
  "If an equation is not exact, it may be possible to find an integrating \
factor (a multiplier for the functions ",
  StyleBox["P", "MR"],
  " and ",
  StyleBox["Q", "MR"],
  StyleBox[", defined previously", "TR"],
  ") that converts the equation into exact form. ",
  StyleBox["DSolve", "MR"],
  " tries a variety of techniques to automatically find integrating factors \
in such situations."
}], "Text",
  CellTags->"b:1.1.0.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clairaut Equations", "Subsubsection",
  CellTags->{"ClairautODE", "c:15", "b:1.1.0.6"}],

Cell[TextData[{
  "This is an example of a ",
  ButtonBox["Clairaut equation",
    ButtonData:>"EquationTypes",
    ButtonStyle->"Hyperlink"],
  ". The warning message from ",
  StyleBox["Solve", "MR"],
  StyleBox[" can be ignored. It is given because ", "TR"],
  StyleBox["DSolve", "MR"],
  " first tries to find an expression for ",
  Cell[BoxData[
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]]],
  " from the given ODE",
  StyleBox[".", "TR"]
}], "MathCaption",
  CellTags->"b:1.1.0.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[y[x] \[Equal] 
          x*\(y'\)[x]\  + \(y'\)[x]^2\  + \ Exp[\(y'\)[x]]\ , y[x], 
        x]\)], "Input",
  CellLabel->"In[67]:=",
  CellTags->"b:1.1.0.6"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.6"],

Cell[BoxData[
    \({{y[x] \[Rule] \[ExponentialE]\^C[1] + x\ C[1] + C[1]\^2}}\)], "Output",\

  CellLabel->"Out[67]=",
  CellTags->"b:1.1.0.6"]
}, Open  ]],

Cell["\<\
The general solution to Clairaut equations is simply a family of \
straight lines. \
\>", "Text",
  CellTags->"b:1.1.0.6"],

Cell[TextData[{
  "This plots the solution for several values of ",
  StyleBox["C[1]", "MR"],
  StyleBox[".", "TR"]
}], "MathCaption",
  CellTags->"b:1.1.0.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[
      Evaluate[Table[\(y[x] /. sol\) /. {C[1] \[Rule] \ 1/k}, \ {k, \(-5\), 
            5, 2}]], \ {x, 1, 5}, \ PlotStyle\  \[Rule] \ {Red}]; \)], "Input",\

  CellLabel->"In[68]:=",
  CellTags->"b:1.1.0.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.214286 0.238095 0.187817 0.0476587 [
[.2619 .17532 -3 -9 ]
[.2619 .17532 3 0 ]
[.5 .17532 -3 -9 ]
[.5 .17532 3 0 ]
[.7381 .17532 -3 -9 ]
[.7381 .17532 3 0 ]
[.97619 .17532 -3 -9 ]
[.97619 .17532 3 0 ]
[.01131 .0925 -12 -4.5 ]
[.01131 .0925 0 4.5 ]
[.01131 .28313 -6 -4.5 ]
[.01131 .28313 0 4.5 ]
[.01131 .37845 -6 -4.5 ]
[.01131 .37845 0 4.5 ]
[.01131 .47377 -6 -4.5 ]
[.01131 .47377 0 4.5 ]
[.01131 .56909 -6 -4.5 ]
[.01131 .56909 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .18782 m
.2619 .19407 L
s
[(2)] .2619 .17532 0 1 Mshowa
.5 .18782 m
.5 .19407 L
s
[(3)] .5 .17532 0 1 Mshowa
.7381 .18782 m
.7381 .19407 L
s
[(4)] .7381 .17532 0 1 Mshowa
.97619 .18782 m
.97619 .19407 L
s
[(5)] .97619 .17532 0 1 Mshowa
.125 Mabswid
.07143 .18782 m
.07143 .19157 L
s
.11905 .18782 m
.11905 .19157 L
s
.16667 .18782 m
.16667 .19157 L
s
.21429 .18782 m
.21429 .19157 L
s
.30952 .18782 m
.30952 .19157 L
s
.35714 .18782 m
.35714 .19157 L
s
.40476 .18782 m
.40476 .19157 L
s
.45238 .18782 m
.45238 .19157 L
s
.54762 .18782 m
.54762 .19157 L
s
.59524 .18782 m
.59524 .19157 L
s
.64286 .18782 m
.64286 .19157 L
s
.69048 .18782 m
.69048 .19157 L
s
.78571 .18782 m
.78571 .19157 L
s
.83333 .18782 m
.83333 .19157 L
s
.88095 .18782 m
.88095 .19157 L
s
.92857 .18782 m
.92857 .19157 L
s
.25 Mabswid
0 .18782 m
1 .18782 L
s
.02381 .0925 m
.03006 .0925 L
s
[(-2)] .01131 .0925 1 0 Mshowa
.02381 .28313 m
.03006 .28313 L
s
[(2)] .01131 .28313 1 0 Mshowa
.02381 .37845 m
.03006 .37845 L
s
[(4)] .01131 .37845 1 0 Mshowa
.02381 .47377 m
.03006 .47377 L
s
[(6)] .01131 .47377 1 0 Mshowa
.02381 .56909 m
.03006 .56909 L
s
[(8)] .01131 .56909 1 0 Mshowa
.125 Mabswid
.02381 .02101 m
.02756 .02101 L
s
.02381 .04484 m
.02756 .04484 L
s
.02381 .06867 m
.02756 .06867 L
s
.02381 .11633 m
.02756 .11633 L
s
.02381 .14016 m
.02756 .14016 L
s
.02381 .16399 m
.02756 .16399 L
s
.02381 .21165 m
.02756 .21165 L
s
.02381 .23548 m
.02756 .23548 L
s
.02381 .25931 m
.02756 .25931 L
s
.02381 .30696 m
.02756 .30696 L
s
.02381 .33079 m
.02756 .33079 L
s
.02381 .35462 m
.02756 .35462 L
s
.02381 .40228 m
.02756 .40228 L
s
.02381 .42611 m
.02756 .42611 L
s
.02381 .44994 m
.02756 .44994 L
s
.02381 .4976 m
.02756 .4976 L
s
.02381 .52143 m
.02756 .52143 L
s
.02381 .54526 m
.02756 .54526 L
s
.02381 .59292 m
.02756 .59292 L
s
.02381 .61675 m
.02756 .61675 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .21921 m
.06244 .21766 L
.10458 .21598 L
.14415 .21439 L
.18221 .21287 L
.22272 .21125 L
.26171 .20969 L
.30316 .20803 L
.34309 .20643 L
.3815 .20489 L
.42237 .20326 L
.46172 .20168 L
.49955 .20017 L
.53984 .19855 L
.57861 .197 L
.61984 .19535 L
.65954 .19376 L
.69774 .19223 L
.73838 .1906 L
.77751 .18904 L
.81909 .18737 L
.85916 .18577 L
.89771 .18423 L
.93871 .18258 L
.97619 .18108 L
s
.02381 .21138 m
.06244 .2088 L
.10458 .20599 L
.14415 .20335 L
.18221 .20081 L
.22272 .1981 L
.26171 .1955 L
.30316 .19274 L
.34309 .19007 L
.3815 .18751 L
.42237 .18478 L
.46172 .18216 L
.49955 .17963 L
.53984 .17694 L
.57861 .17436 L
.61984 .17161 L
.65954 .16896 L
.69774 .16641 L
.73838 .1637 L
.77751 .16109 L
.81909 .15831 L
.85916 .15564 L
.89771 .15307 L
.93871 .15033 L
.97619 .14783 L
s
.02381 .20535 m
.06244 .19762 L
.10458 .18918 L
.14415 .18126 L
.18221 .17364 L
.22272 .16554 L
.26171 .15773 L
.30316 .14943 L
.34309 .14144 L
.3815 .13375 L
.42237 .12557 L
.46172 .1177 L
.49955 .11012 L
.53984 .10206 L
.57861 .0943 L
.61984 .08605 L
.65954 .0781 L
.69774 .07045 L
.73838 .06232 L
.77751 .05448 L
.81909 .04616 L
.85916 .03814 L
.89771 .03042 L
.93871 .02222 L
.97619 .01472 L
s
.02381 .41268 m
.06244 .42042 L
.10458 .42885 L
.14415 .43677 L
.18221 .44439 L
.22272 .4525 L
.26171 .4603 L
.30316 .4686 L
.34309 .47659 L
.3815 .48428 L
.42237 .49246 L
.46172 .50034 L
.49955 .50791 L
.53984 .51598 L
.57861 .52374 L
.61984 .53199 L
.65954 .53994 L
.69774 .54758 L
.73838 .55572 L
.77751 .56355 L
.81909 .57187 L
.85916 .57989 L
.89771 .58761 L
.93871 .59582 L
.97619 .60332 L
s
.02381 .27551 m
.06244 .27809 L
.10458 .2809 L
.14415 .28354 L
.18221 .28608 L
.22272 .28878 L
.26171 .29139 L
.30316 .29415 L
.34309 .29681 L
.3815 .29938 L
.42237 .3021 L
.46172 .30473 L
.49955 .30725 L
.53984 .30994 L
.57861 .31253 L
.61984 .31528 L
.65954 .31793 L
.69774 .32048 L
.73838 .32319 L
.77751 .3258 L
.81909 .32857 L
.85916 .33125 L
.89771 .33382 L
.93871 .33656 L
.97619 .33906 L
s
.02381 .25747 m
.06244 .25901 L
.10458 .2607 L
.14415 .26228 L
.18221 .26381 L
.22272 .26543 L
.26171 .26699 L
.30316 .26865 L
.34309 .27025 L
.3815 .27179 L
.42237 .27342 L
.46172 .275 L
.49955 .27651 L
.53984 .27812 L
.57861 .27968 L
.61984 .28133 L
.65954 .28292 L
.69774 .28445 L
.73838 .28607 L
.77751 .28764 L
.81909 .2893 L
.85916 .29091 L
.89771 .29245 L
.93871 .29409 L
.97619 .29559 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gR000`400?l00000o`00003oo`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`004`3oool00`000000oooo0?ooo`3o0?oooe<0oooo
000C0?ooo`030000003oool0oooo0?l0ooooD`3oool001<0oooo00<000000?ooo`3oool0o`3ooomC
0?ooo`004`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000C0?ooo`030000003oool0oooo0?l0
ooooD`3oool001<0oooo00<000000?ooo`3oool0o`3ooom70?ooo`<0o`002@3oool001<0oooo00<0
00000?ooo`3oool0o`3ooom30?ooo`@0o`00303oool001<0oooo00<000000?ooo`3oool0o`3ooolo
0?ooo`@0o`00403oool001<0oooo0P00003o0?oooc/0oooo1@3o000D0?ooo`004`3oool00`000000
oooo0?ooo`3o0?ooocH0oooo103o000I0?ooo`004`3oool00`000000oooo0?ooo`3o0?oooc40oooo
1@3o000M0?ooo`004`3oool00`000000oooo0?ooo`3o0?ooob`0oooo1@3o000R0?ooo`004`3oool0
0`000000oooo0?ooo`3o0?ooobP0oooo103o000W0?ooo`004`3oool00`000000oooo0?ooo`3o0?oo
ob<0oooo1@3o000[0?ooo`004`3oool00`000000oooo0?ooo`3o0?oooad0oooo1P3o000`0?ooo`00
4`3oool00`000000oooo0?ooo`3o0?oooaL0oooo1P3o000f0?ooo`004`3oool200000?l0oooo4P3o
ool60?l003`0oooo000C0?ooo`030000003oool0oooo0?l0oooo303oool50?l00480oooo000C0?oo
o`030000003oool0oooo0?l0oooo1`3oool50?l004L0oooo000C0?ooo`030000003oool0oooo0?l0
oooo0P3oool50?l004`0oooo000C0?ooo`030000003oool0oooo0?d0oooo103o001A0?ooo`004`3o
ool00`000000oooo0?ooo`3h0?ooo`D0o`00E@3oool001<0oooo00<000000?ooo`3oool0l`3oool5
0?l005X0oooo000C0?ooo`030000003oool0oooo0>l0oooo103o001O0?ooo`004`3oool200000>/0
oooo1@3o001S0?ooo`004`3oool00`000000oooo0?ooo`3T0?ooo`H0o`00J03oool001<0oooo00<0
00000?ooo`3oool0gP3oool60?l006h0oooo000C0?ooo`030000003oool0oooo0=P0oooo1P3o001d
0?ooo`004`3oool00`000000oooo0?ooo`3D0?ooo`@0o`00NP3oool000P0oooo1@0000060?ooo`03
0000003oool0oooo0<l0oooo1@3o001n0?ooo`00203oool01@000000oooo0?ooo`3oool0000000H0
oooo00<000000?ooo`3oool0bP3oool50?l008<0oooo00090?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0aP3oool40?l008P0oooo0006000000@0oooo00<000000?ooo`3oool01P3o
ool300000<40oooo1@3o002<0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0;`0oooo1@3o002A0?ooo`00303oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0;P0oooo103o002F0?ooo`00203oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?oo
o`3oool0/`3oool50?l009X0oooo00090?ooo`<000001`3oool00`000000oooo0?ooo`2^0?ooo`D0
o`00W`3oool001<0oooo00<000000?ooo`3oool0ZP3oool40?l00:@0oooo000C0?ooo`030000003o
ool0oooo0:D0oooo1@3o002X0?ooo`004`3oool00`000000oooo0?ooo`2O0?ooo`H0o`00[@3oool0
01<0oooo00<000000?ooo`3oool0V@3oool60?l00;<0oooo000C0?ooo`800000U03oool60?l00;T0
oooo000C0?ooo`030000003oool0oooo08l0oooo103o002o0?ooo`004`3oool00`000000oooo0?oo
o`2;0?ooo`@0o`00``3oool001<0oooo00<000000?ooo`3oool0QP3oool50?l00<L0oooo000C0?oo
o`030000003oool0oooo0840oooo1@3o003<0?ooo`004`3oool00`000000oooo0?ooo`1l0?ooo`D0
o`00d@3oool001<0oooo00<000000?ooo`3oool0M`3oool50?l00=H0oooo000C0?ooo`030000003o
ool0oooo07<0oooo103o003K0?ooo`004`3oool200000700oooo103o003O0?ooo`004`3oool00`00
0000oooo0?ooo`1=0?ooo`D000005`3oool60?l00380oooo0`00001A0?ooo`<00000CP3oool40000
00P0oooo000C0?ooo`030000003oool0oooo04d0oooo00D000000?ooo`3oool0oooo0000000@0?oo
o`L0o`00=`3oool01@000000oooo0?ooo`3oool000000540oooo00<000000?ooo`3oool0C03oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo000C0?ooo`030000003oool0oooo
04h0oooo00<000000?ooo`3oool02`3oool60?l00480oooo00<000000?ooo`3oool0C`3oool00`00
0000oooo0?ooo`190?ooo`L0o`0000<0oooo0000003oool01P3oool001<0oooo00<000000?ooo`3o
ool0C`3oool00`000000oooo0?ooo`060?ooo`@0o`00B03oool00`000000oooo0?ooo`1;0?ooo`H0
0000?@3oool=0?l000P0oooo00<000000?ooo`3oool01@3oool001<0oooo00<000000?ooo`3oool0
D03oool00`000000oooo0?ooo`050?l004X0oooo0P00001?0?ooo`040000003oool0oooo00000280
oooo703o000A0?ooo`@00000203oool001<0oooo00<000000?ooo`3oool0CP3oool50?l00540oooo
00<000000?ooo`3oool0C03oool010000000oooo0?ooo`00000D0?ooo`h0o`00;@3oool00`000000
oooo0?ooo`090?ooo`004`3oool00`000000oooo0?ooo`1:0?ooo`@0o`000`3oool00`000000oooo
0?ooo`1<0?ooo`050000003oool0oooo0?ooo`000000C`3oool00`000000oooo000000060?ooo`h0
o`00>`3oool00`000000oooo0?ooo`090?ooo`004`3oool2000004H0oooo1@3o00040?ooo`<00000
D03oool3000004/0oooo3P3o00190?ooo`D000001`3oool001<0oooo00<000000?ooo`3oool0@03o
ool50?l009`0oooo3P3o001S0?ooo`004`3oool00`000000oooo0?ooo`0l0?ooo`@0o`00U03oool=
0?l00740oooo000C0?ooo`030000003oool0oooo03L0oooo1@3o002:0?ooo`h0o`00OP3oool001<0
oooo00<000000?ooo`3oool0<@3oool60?l00840oooo3P3o002<0?ooo`004`3oool00`000000oooo
0?ooo`0[0?ooo`H0o`00N@3oool>0?l009X0oooo000C0?ooo`030000003oool0oooo02D0oooo1P3o
001a0?ooo`h0o`00V03oool70?l000T0oooo000C0?ooo`030000003oool0oooo0240oooo103o001Z
0?ooo`d0o`00R`3ooolK0?l00100oooo000C0?ooo`030000003oool0oooo01`0oooo1@3o001P0?oo
o`h0o`00O03ooolL0?l002/0oooo000;0?ooob8000001@3o001:000001/0o`00O000000>0?l004L0
0000000C0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool50?l000L0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool01@3oool>0?l000/0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3ooolL0?l000T0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`070?ooo`004`3oool00`000000oooo0?oo
o`0=0?ooo`D0o`00>03oool>0?l004/0oooo00<000000?ooo`3oool0803ooolK0?l001@0oooo00<0
00000?ooo`3oool0D03oool00`000000oooo0?ooo`070?ooo`004`3oool00`000000oooo0?ooo`08
0?ooo`D0o`00;`3oool>0?l00600oooo703o002<0?ooo`004`3oool00`000000oooo0?ooo`040?oo
o`@0o`009P3oool>0?l005<0oooo6`3o002X0?ooo`004`3oool00`000000oooo0?ooo`040?l001d0
oooo3@3o001C0?ooo`h0o`00``3oool001<0oooo0`3o000B0?ooo`l0o`00A@3ooolK0?l00=40oooo
000C0?ooo`030000003oool0oooo00@0oooo3P3o000h0?oooa`0o`00k03oool001<0oooo1`3o000Z
0?oooa`0o`00o`3oool90?ooo`004`3oool00`000000oooo0?ooo`0B0?oooa`0o`00o`3ooolU0?oo
o`004`3oool00`000000oooo0?ooo`040?ooo`h0o`00o`3ooom10?ooo`004`3oool70?l00?l0oooo
C`3oool001<0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`004`3oool00`000000oooo0?ooo`3o
0?oooe<0oooo000C0?ooo`030000003oool0oooo0?l0ooooD`3oool001<0oooo00<000000?ooo`3o
ool0o`3ooomC0?ooo`004`3oool200000?l0ooooE03oool001<0oooo00<000000?ooo`3oool0o`3o
oomC0?ooo`004`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000C0?ooo`030000003oool0oooo
0?l0ooooD`3oool001<0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`004`3oool00`000000oooo
0?ooo`3o0?oooe<0oooo000C0?ooo`030000003oool0oooo0?l0ooooD`3oool001<0oooo00<00000
0?ooo`3oool0o`3ooomC0?ooo`004`3ooolE0?l00?l0oooo@@3oool001<0oooo0P00000C0?ooo`h0
o`00o`3ooolc0?ooo`004`3oool00`000000oooo0?ooo`0P0?oooa/0o`00o`3ooolH0?ooo`004`3o
ool00`000000oooo0?ooo`0k0?oooa`0o`00n`3oool001<0oooo00<000000?ooo`3oool0E`3ooolL
0?l00=l0oooo000C0?ooo`030000003oool0oooo07<0oooo703o00330?ooo`00203oool5000000H0
oooo1`3o002;0?ooo`d0o`00]P3oool000P0oooo00D000000?ooo`3oool0oooo000000060?ooo`03
0000003oool0oooo00@0oooo3P3o002:0?oooa/0o`00V`3oool000T0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0B0?ooo`h0o`00U`3ooolL0?l007l0oooo000:0?ooo`030000003o
ool0oooo00H0oooo0`00000P0?ooo`h0o`00Y@3ooolK0?l006@0oooo000;0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0;P3oool=0?l00;<0oooo7@3o00170?ooo`00303oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo03/0oooo3P3o00320?ooo`h0o`00>@3oool000P0
oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo04T0oooo3P3o00320?oo
oa/0o`007P3oool000T0oooo0`0000070?ooo`030000003oool0oooo05L0oooo3P3o003?0?oooaD0
o`002@3oool001<0oooo00<000000?ooo`3oool0I@3ooolL0?l00=40oooo000C0?ooo`030000003o
ool0oooo0840oooo3P3o00330?ooo`004`3oool00`000000oooo0?ooo`2?0?ooo`d0o`00]P3oool0
01<0oooo0P00002M0?ooo`d0o`00Z@3oool001<0oooo00<000000?ooo`3oool0Z@3oool>0?l009/0
oooo000C0?ooo`030000003oool0oooo0;L0oooo3P3o002=0?ooo`004`3oool00`000000oooo0?oo
o`350?ooo`h0o`00O`3oool001<0oooo00<000000?ooo`3oool0d`3oool>0?l00740oooo000C0?oo
o`030000003oool0oooo0>40oooo3@3o001T0?ooo`004`3oool00`000000oooo0?ooo`3^0?ooo`h0
o`00EP3oool001<0oooo00<000000?ooo`3oool0o03oool?0?l004L0oooo000C0?ooo`800000o`3o
ool=0?ooo`h0o`00>@3oool001<0oooo00<000000?ooo`3oool0o`3ooolJ0?oooa/0o`007P3oool0
01<0oooo00<000000?ooo`3oool0o`3ooole0?ooo`h0o`00403oool001<0oooo00<000000?ooo`3o
ool0o`3ooom30?ooo`L0o`002@3oool001<0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`004`3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000C0?ooo`030000003oool0oooo0?l0ooooD`3oool0
01<0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`004`3oool00`000000oooo0?ooo`3o0?oooe<0
oooo000C0?ooo`800000o`3ooomD0?ooo`004`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000C
0?ooo`030000003oool0oooo0?l0ooooD`3oool001<0oooo00<000000?ooo`3oool0o`3ooomC0?oo
o`004`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000;0?ooo`<000001@3oool00`000000oooo
0?ooo`3o0?oooe<0oooo000<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3o
oomC0?ooo`00303oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooD`3oool0
00P0oooo1P0000050?ooo`<00000o`3ooomC0?ooo`002@3oool010000000oooo0?ooo`0000060?oo
o`030000003oool0oooo0?l0ooooD`3oool000T0oooo00@000000?ooo`3oool000001P3oool00`00
0000oooo0?ooo`3o0?oooe<0oooo000:0?ooo`030000003oool0000000H0oooo00<000000?ooo`3o
ool0o`3ooomC0?ooo`002`3oool2000000H0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`004`3o
ool00`000000oooo0?ooo`3o0?oooe<0oooo000C0?ooo`030000003oool0oooo0?l0ooooD`3oool0
01<0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`004`3oool200000?l0ooooE03oool001<0oooo
00<000000?ooo`3oool0o`3ooomC0?ooo`004`3oool00`000000oooo0?ooo`3o0?oooe<0oooo000C
0?ooo`030000003oool0oooo0?l0ooooD`3oool001<0oooo0`3o003o0?oooe<0oooo000C0?ooo`03
0000003oool0oooo00@0o`00o`3ooom?0?ooo`004`3oool00`000000oooo0?ooo`040?ooo`@0o`00
o`3ooom;0?ooo`004`3oool00`000000oooo0?ooo`080?ooo`D0o`00o`3ooom60?ooo`004`3oool0
0`000000oooo0?ooo`0=0?ooo`D0o`00o`3ooom10?ooo`004`3oool2000001<0oooo1@3o003o0?oo
oc`0oooo000C0?ooo`030000003oool0oooo01L0oooo1P3o003o0?ooocH0oooo000C0?ooo`030000
003oool0oooo01d0oooo1`3o003o0?ooobl0oooo000C0?ooo`030000003oool0oooo02@0oooo1P3o
003o0?ooobT0oooo000C0?ooo`030000003oool0oooo02X0oooo103o003o0?ooobD0oooo000C0?oo
o`030000003oool0oooo02h0oooo103o003o0?ooob40oooo000C0?ooo`030000003oool0oooo0380
oooo1@3o003o0?oooa`0oooo000C0?ooo`030000003oool0oooo03L0oooo103o003o0?oooaP0oooo
000C0?ooo`800000?03oool50?l00?l0oooo4`3oool001<0oooo00<000000?ooo`3oool0@03oool6
0?l00?l0oooo3@3oool001<0oooo00<000000?ooo`3oool0AP3oool70?l00?l0oooo1P3oool001<0
oooo00<000000?ooo`3oool0C@3oool60?l00?l0oooo000C0?ooo`030000003oool0oooo05<0oooo
103o003k0?ooo`002P3oool3000000H0oooo00<000000?ooo`3oool0E`3oool50?l00?H0oooo0009
0?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`1L0?ooo`D0o`00l@3o
ool000T0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo0640oooo103o
003]0?ooo`002@3oool01@000000oooo0?ooo`3oool0000000D0oooo0`00001U0?ooo`D0o`00j03o
ool000T0oooo100000060?ooo`030000003oool0oooo06X0oooo1@3o003S0?ooo`002@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo06l0oooo103o003O0?ooo`002P3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo07<0oooo103o003K0?ooo`002`3oool3000000D0oooo
00<000000?ooo`3oool0M`3oool50?l00=H0oooo000C0?ooo`030000003oool0oooo07`0oooo1@3o
003A0?ooo`004`3oool00`000000oooo0?ooo`210?ooo`D0o`00c03oool001<0oooo00<000000?oo
o`3oool0QP3oool60?l00<H0oooo000C0?ooo`800000S@3oool60?l00<00oooo000C0?ooo`030000
003oool0oooo0980oooo1P3o002j0?ooo`004`3oool00`000000oooo0?ooo`2H0?ooo`@0o`00]P3o
ool001<0oooo00<000000?ooo`3oool0W03oool40?l00;80oooo000C0?ooo`030000003oool0oooo
0:00oooo1@3o002]0?ooo`004`3oool00`000000oooo0?ooo`2U0?ooo`@0o`00Z@3oool001<0oooo
00<000000?ooo`3oool0Z@3oool50?l00:@0oooo000C0?ooo`030000003oool0oooo0:h0oooo1@3o
002O0?ooo`004`3oool00`000000oooo0?ooo`2c0?ooo`@0o`00V`3oool001<0oooo0P00002h0?oo
o`D0o`00UP3oool001<0oooo00<000000?ooo`3oool0_03oool60?l00900oooo000C0?ooo`030000
003oool0oooo0<80oooo1`3o00290?ooo`004`3oool00`000000oooo0?ooo`390?ooo`H0o`00P`3o
ool001<0oooo00<000000?ooo`3oool0c`3oool40?l007l0oooo000C0?ooo`030000003oool0oooo
0=<0oooo1@3o001j0?ooo`004`3oool00`000000oooo0?ooo`3H0?ooo`D0o`00M@3oool001<0oooo
00<000000?ooo`3oool0g@3oool40?l00740oooo000C0?ooo`800000hP3oool40?l006d0oooo000C
0?ooo`030000003oool0oooo0>D0oooo1@3o001X0?ooo`004`3oool00`000000oooo0?ooo`3Z0?oo
o`@0o`00I03oool001<0oooo00<000000?ooo`3oool0kP3oool50?l005l0oooo000C0?ooo`030000
003oool0oooo0?<0oooo1P3o001I0?ooo`002@3oool4000000H0oooo00<000000?ooo`3oool0n@3o
ool70?l00580oooo00080?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`3o0?ooo`40oooo1P3o001<0?ooo`00203oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3oool70?ooo`D0o`00A`3oool000P0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`<00000o`3oool<0?ooo`D0
o`00@P3oool000T0oooo100000060?ooo`030000003oool0oooo0?l0oooo4@3oool50?l003d0oooo
00080?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`3o0?oooaH0oooo103o000i0?ooo`00203oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0o`3ooolJ0?ooo`@0o`00=@3oool000T0oooo100000060?oo
o`030000003oool0oooo0?l0oooo7P3oool50?l00300oooo000C0?ooo`030000003oool0oooo0?l0
oooo8`3oool40?l002`0oooo000C0?ooo`030000003oool0oooo0?l0oooo9`3oool50?l002L0oooo
000C0?ooo`030000003oool0oooo0?l0oooo;03oool50?l00280oooo000C0?ooo`030000003oool0
oooo0?l0oooo<@3oool40?l001h0oooo000C0?ooo`800000o`3ooolf0?ooo`D0o`006@3oool001<0
oooo00<000000?ooo`3oool0o`3ooolj0?ooo`H0o`004`3oool001<0oooo00<000000?ooo`3oool0
o`3ooom00?ooo`H0o`003@3oool001<0oooo00<000000?ooo`3oool0o`3ooom60?ooo`@0o`002@3o
ool001<0oooo00<000000?ooo`3oool0o`3ooomC0?ooo`004`3oool00`000000oooo0?ooo`3o0?oo
oe<0oooo000C0?ooo`030000003oool0oooo0?l0ooooD`3oool001<0oooo00<000000?ooo`3oool0
o`3ooomC0?ooo`004`3oool200000?l0ooooE03oool00?l0ooooJ@3oool00?l0ooooJ@3oool00?l0
ooooJ@3oool00001\
\>"],
  ImageRangeCache->{{{81, 368}, {462.062, 285.125}} -> {-0.456831, 17.3784, \
0.0151002, 0.0754379}},
  CellTags->"b:1.1.0.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Abel Equations", "Subsubsection",
  CellTags->{"AbelODE", "c:16", "b:1.1.0.7"}],

Cell[TextData[{
  "As with Riccati equations, it is generally difficult to solve ",
  ButtonBox["Abel ODEs",
    ButtonData:>"EquationTypes",
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  CellTags->"b:1.1.0.7"],

Cell[TextData[{
  "Associated with any Abel ODE is a sequence of expressions that is built \
from the coefficients of the equation ",
  Cell[BoxData[
      \(TraditionalForm\`{f0, f1, f2, f3}\)]],
  " and invariant under certain coordinate transformations of the independent \
variable and the dependent variable. These ",
  StyleBox["invariants",
    FontSlant->"Italic"],
  " characterize each equation and can be used for identifying integrable \
classes of Abel ODEs. In particular, Abel ODEs with zero or constant \
invariants can be integrated easily and constitute an important integrable \
class of these equations."
}], "Text",
  CellTags->"b:1.1.0.7"],

Cell["\<\
Here is the construction of a particular invariant with value 0 and \
the solution of the corresponding Abel ODE.\
\>", "MathCaption",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    \(f0 = 0; f1 = 1\/x; f2 = \(-3\); f3 = x; \)], "Input",
  CellLabel->"In[69]:=",
  CellTags->"b:1.1.0.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Invariant = 
      f0\ f3\^2 + 
        1\/3\ \((\(2\ f2\^3\)\/9 - f1\ f3\ f2 - \[PartialD]\_x f3\ f2 + 
              f3\ \[PartialD]\_x f2)\)\)], "Input",
  CellLabel->"In[70]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[70]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AbelODE", "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], 
        "\[Equal]", \(f0 + f1\ y[x] + f2\ y[x]\^2 + 
          f3\ y[x]\^3\)}]}]], "Input",
  CellLabel->"In[71]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], 
      "\[Equal]", \(y[x]\/x - 3\ y[x]\^2 + x\ y[x]\^3\)}]], "Output",
  CellLabel->"Out[71]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[AbelODE, \ y, x]\)], "Input",
  CellLabel->"In[72]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            1\/x - 1\/\(x\^2\ \@\(1\/x\^2 + C[1]\)\)]}, {y \[Rule] 
          Function[{x}, 
            1\/x + 1\/\(x\^2\ \@\(1\/x\^2 + C[1]\)\)]}}\)], "Output",
  CellLabel->"Out[72]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(AbelODE /. sol // Simplify\)], "Input",
  CellLabel->"In[73]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    \({True, True}\)], "Output",
  CellLabel->"Out[73]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]],

Cell[BoxData[
    \(Clear[f0, f1, f2, f3]\)], "Input",
  CellLabel->"In[74]:=",
  CellTags->"b:1.1.0.7"],

Cell["\<\
Another important class of integrable Abel ODEs are those that can \
be reduced to inverse linear first-order ODEs using a nonlinear coordinate \
transformation.\
\>", "Text",
  CellTags->"b:1.1.0.7"],

Cell[TextData[{
  "This Abel ODE is solved by transforming it to an inverse linear \
first-order ODE. The ",
  StyleBox["ExpIntegralEi", "MR"],
  " term in the solution to this equation comes from solving the linear ODE."
}], "MathCaption",
  CellTags->"b:1.1.0.7"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Equal]", \(y[x]\^3 - \(x\ y[x]\^2\)\/\(x - 1\)\)}], 
        ",", \(y[x]\), ",", "x"}], "]"}]], "Input",
  CellLabel->"In[75]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    \(Solve[\[ExponentialE]\^\(1 - x + 1\/y[x]\)\/\(\(-1\) + x\) + C[1] + 
          ExpIntegralEi[1 - x + 1\/y[x]] \[Equal] 0, y[x]]\)], "Output",
  CellLabel->"Out[75]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]],

Cell[TextData[{
  "Another important class of integrable Abel ODEs consists of those that can \
be transformed to an inverse Riccati equation. Since Riccati equations can be \
transformed to second-order linear ODEs, the solutions for this class are \
usually given in terms of special functions such as ",
  StyleBox["AiryAi", "MR"],
  " and ",
  StyleBox["BesselJ", "MR"],
  "."
}], "Text",
  CellTags->"b:1.1.0.7"],

Cell["\<\
This Abel ODE is solved by reducing it to an inverse Riccati \
equation.\
\>", "MathCaption",
  CellTags->"b:1.1.0.7"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"AbelODE", "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], 
        "==", \(y[x]\^3\/\(8\ x\^2\) - y[x]\^2\)}]}]], "Input",
  CellLabel->"In[76]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], 
      "\[Equal]", \(\(-y[x]\^2\) + y[x]\^3\/\(8\ x\^2\)\)}]], "Output",
  CellLabel->"Out[76]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[AbelODE, y[x], x]\)], "Input",
  CellLabel->"In[77]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(InverseFunction :: \\\"ifun\\\"\\) will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], "Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    \(Solve[
      C[1] + \((AiryAiPrime[\(-\(\((\(-1\))\)\^\(2/3\)\/\(2\ 2\^\(1/3\)\ \
x\)\)\) + \((\(-\((\(-2\))\)\^\(1/3\)\)\ x + \
\((\(-2\))\)\^\(1/3\)\/y[x])\)\^2] + 
                AiryAi[\(-\(\((\(-1\))\)\^\(2/3\)\/\(2\ 2\^\(1/3\)\ x\)\)\) + \
\((\(-\((\(-2\))\)\^\(1/3\)\)\ x + \((\(-2\))\)\^\(1/3\)\/y[x])\)\^2]\ \((\(-\
\((\(-2\))\)\^\(1/3\)\)\ x + \
\((\(-2\))\)\^\(1/3\)\/y[x])\))\)/\((AiryBiPrime[\(-\(\((\(-1\))\)\^\(2/3\)\/\
\(2\ 2\^\(1/3\)\ x\)\)\) + \((\(-\((\(-2\))\)\^\(1/3\)\)\ x + \
\((\(-2\))\)\^\(1/3\)\/y[x])\)\^2] + 
                AiryBi[\(-\(\((\(-1\))\)\^\(2/3\)\/\(2\ 2\^\(1/3\)\ x\)\)\) + \
\((\(-\((\(-2\))\)\^\(1/3\)\)\ x + \((\(-2\))\)\^\(1/3\)\/y[x])\)\^2]\ \((\(-\
\((\(-2\))\)\^\(1/3\)\)\ x + \((\(-2\))\)\^\(1/3\)\/y[x])\))\) \[Equal] 0, 
      y[x]]\)], "Output",
  CellLabel->"Out[77]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
  CellTags->"b:1.1.0.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[D[sol[\([\)\(1\)\(]\)], x], \(y'\)[x]] // FullSimplify\)], "Input",\

  CellLabel->"In[78]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Rule]", \(1\/8\ y[x]\^2\ \((\(-8\) + y[x]\/x\^2)\)\)}], "}"}], 
      "}"}]], "Output",
  CellLabel->"Out[78]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]],

Cell[TextData[{
  "The Abel ODEs considered so far are said to be of the ",
  StyleBox["first kind.",
    FontSlant->"Italic"],
  " Abel ODEs of the ",
  StyleBox["second kind",
    FontSlant->"Italic"],
  " are given by the following general formula."
}], "Text",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "(", "x", ")"}], 
        "\[LongEqual]", \(\(f(
                x) + \(g(x)\)\ \(y(x)\) + \(h(x)\)\ \(y(x)\)\^2 + \(k(
                  x)\)\ \(y(x)\)\^3\)\/\(a(x) + \(b(x)\)\ \(y(x)\)\)\)}], 
      TraditionalForm]], "DisplayMath",
  CellTags->"b:1.1.0.7"],

Cell["\<\
An Abel ODE of the second kind can be converted to an equation of \
the first kind with a coordinate transformation. Thus, the solution methods \
for this kind of Abel ODE are identical to the methods for equations of the \
first kind.\
\>", "Text",
  CellTags->"b:1.1.0.7"],

Cell["Here is the solution for an Abel ODE of the second kind.", "MathCaption",
  CellTags->"b:1.1.0.7"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"sol", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], 
            "\[Equal]", \(\(\(-\(\(2  x\)\/9\)\) + \ x^3 + y[x]\)\/y[x]\)}], 
          ",", \(y[x]\), ",", "x"}], "]"}]}]], "Input",
  CellLabel->"In[79]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    \(Solve[
      C[1] \[Equal] \((\(-1\) + \((\@2\/\(3\ x\) - \(\@2\ y[x]\)\/x\^2)\)\^2)\
\)\^\(1/4\)\ \((\(-\(\(3\ x\)\/\@2\)\) - \((Hypergeometric2F1[1\/2, 3\/4, 
                      3\/2, \((\@2\/\(3\ x\) - \(\@2\ y[x]\)\/x\^2)\)\^2]\ \
\((\@2\/\(3\ x\) - \(\@2\ y[x]\)\/x\^2)\))\)/\((2\ \((1 - \((\@2\/\(3\ x\) - \
\(\@2\ y[x]\)\/x\^2)\)\^2)\)\^\(1/4\))\))\), y[x]]\)], "Output",
  CellLabel->"Out[79]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
  CellTags->"b:1.1.0.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[D[sol[\([\)\(1\)\(]\)], x], \(y'\)[x]] // FullSimplify\)], "Input",\

  CellLabel->"In[80]:=",
  CellTags->"b:1.1.0.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], 
          "\[Rule]", \(1 + \(\(-\(\(2\ x\)\/9\)\) + x\^3\)\/y[x]\)}], "}"}], 
      "}"}]], "Output",
  CellLabel->"Out[80]=",
  CellTags->"b:1.1.0.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chini Equations", "Subsubsection",
  CellTags->{"ChiniODE", "c:17", "b:1.1.0.8"}],

Cell[TextData[{
  ButtonBox["Chini equations",
    ButtonData:>"EquationTypes",
    ButtonStyle->"Hyperlink"],
  " are a generalization of Abel and Riccati equations. "
}], "Text",
  CellTags->"b:1.1.0.8"],

Cell["This solves a Chini equation.", "MathCaption",
  CellTags->"b:1.1.0.8"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y'\)[x] \[Equal] 5*y[x]^4 + \ 3*x^\((\(-4\)/3)\), \ y[x], 
      x]\)], "Input",
  CellLabel->"In[81]:=",
  CellTags->"b:1.1.0.8"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.8"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.0.8"],

Cell[BoxData[
    \(Solve[\(-45\)\ RootSum[\(-45\) + 3\^\(1/4\)\ 5\^\(3/4\)\ #1 - 
                45\ #1\^4 &, 
            Log[\(-#1\) + \((5\/3)\)\^\(1/4\)\ \((x\^\(4/3\))\)\^\(1/4\)\ \
y[x]]\/\(3\^\(1/4\)\ 5\^\(3/4\) - 180\ #1\^3\) &] \[Equal] 
        C[1] + \(3\^\(3/4\)\ 5\^\(1/4\)\ \((x\^\(4/3\))\)\^\(1/4\)\ \
Log[x]\)\/x\^\(1/3\), y[x]]\)], "Output",
  CellLabel->"Out[81]=",
  CellTags->"b:1.1.0.8"]
}, Open  ]],

Cell[TextData[{
  "This concludes the discussion of first-order ODEs. The problem of solving \
second-order ODEs using ",
  StyleBox["DSolve", "MR"],
  " is considered in the next section."
}], "Text",
  CellTags->"b:1.1.0.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linear Second-Order ODEs", "Subsection",
  CellTags->{"Linear second-order ODEs", "c:18"}],

Cell["Overview", "Subsubsection",
  CellTags->{"ODEwConstCoefs", "c:18.5", "b:1.1.1.0"}],

Cell["\<\
Solving linear first-order ODEs is straightforward and only \
requires the use of a suitable integrating factor. In sharp contrast, there \
are a large number of methods available for handling linear-second order \
ODEs, but the solution to the general equation belonging to this class is \
still not available. We will therefore discuss the linear case in detail \
before moving on to nonlinear second-order ODEs.\
\>", "Text",
  CellTags->"b:1.1.1.0"],

Cell[TextData[{
  "The general ",
  StyleBox["linear second-order ODE",
    FontSlant->"Italic"],
  " has the form "
}], "Text",
  CellTags->"b:1.1.1.0"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "(", "x", ")"}], " ", "+", " ", 
          RowBox[{\(P(x)\), " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "(", "x", ")"}]}], " ", "+", 
          " ", \(\(Q(x)\)\ \(y(x)\)\)}], "\[LongEqual]", " ", 
        RowBox[{\(R(x)\), 
          StyleBox[".",
            "TR"]}]}], TraditionalForm]], "DisplayMath",
  CellTags->"b:1.1.1.0"],

Cell[TextData[{
  "Here, ",
  Cell[BoxData[
      \(TraditionalForm\`P(x)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`Q(x)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`R(x)\)]],
  " are arbitrary functions of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The term \"linear\" refers to the fact that the degree of each term in \
",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "(", "x", ")"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "(", "x", ")"}], TraditionalForm]]],
  " is 1. (Thus, terms like ",
  Cell[BoxData[
      \(TraditionalForm\`\(y(x)\)\^2\)]],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(y(x)\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "(", "x", ")"}]}], 
        TraditionalForm]]],
  " would make the equation nonlinear.)"
}], "Text",
  CellTags->"b:1.1.1.0"],

Cell[CellGroupData[{

Cell["Equations with Constant Coefficients", "Subsubsection",
  CellTags->{"ODEwConstCoefs", "c:19", "b:1.1.1.1"}],

Cell[TextData[{
  "The simplest type of linear second-order ODE is one with ",
  StyleBox["constant coefficients",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"b:1.1.1.1"],

Cell["This linear second-order ODE has constant coefficients.", "MathCaption",
  CellTags->"b:1.1.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[\(y''\)[x]\  + 5*\(y'\)[x] - 6  y[x]\  \[Equal] 0, \ y, 
        x]\)], "Input",
  CellLabel->"In[82]:=",
  CellTags->"b:1.1.1.1"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, \[ExponentialE]\^\(\(-6\)\ x\)\ C[
                  1] + \[ExponentialE]\^x\ C[2]]}}\)], "Output",
  CellLabel->"Out[82]=",
  CellTags->"b:1.1.1.1"]
}, Open  ]],

Cell[TextData[{
  "Notice that the general solution is a linear combination of two \
exponential functions. The arbitrary constants ",
  StyleBox["C[1]", "MR"],
  " and ",
  StyleBox["C[2]", "MR"],
  StyleBox[" ", "TR"],
  "can be varied to produce particular solutions."
}], "Text",
  CellTags->"b:1.1.1.1"],

Cell["This is one particular solution to the equation.", "MathCaption",
  CellTags->"b:1.1.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = \ \(y[x] /. sol[\([\)\(1\)\(]\)]\) /. {C[1] \[Rule] \ 2, \ 
          C[2] \[Rule] 3}\)], "Input",
  CellLabel->"In[83]:=",
  CellTags->"b:1.1.1.1"],

Cell[BoxData[
    \(2\ \[ExponentialE]\^\(\(-6\)\ x\) + 3\ \[ExponentialE]\^x\)], "Output",
  CellLabel->"Out[83]=",
  CellTags->"b:1.1.1.1"]
}, Open  ]],

Cell[TextData[{
  "The exponents -6 and 1 in the ",
  StyleBox["basis ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \({\[ExponentialE]\^\(\(-6\)\ x\), \[ExponentialE]\^x}\)]],
  " are obtained by solving the associated quadratic equation. This quadratic \
equation is called the ",
  StyleBox["auxiliary",
    FontSlant->"Italic"],
  " or ",
  StyleBox["characteristic",
    FontSlant->"Italic"],
  " equation."
}], "Text",
  CellTags->"b:1.1.1.1"],

Cell["This solves the auxiliary equation.", "MathCaption",
  CellTags->"b:1.1.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[m^2 + 5  m - 6 \[Equal] 0, \ m]\)], "Input",
  CellLabel->"In[84]:=",
  CellTags->"b:1.1.1.1"],

Cell[BoxData[
    \({{m \[Rule] \(-6\)}, {m \[Rule] 1}}\)], "Output",
  CellLabel->"Out[84]=",
  CellTags->"b:1.1.1.1"]
}, Open  ]],

Cell["\<\
The roots are real and distinct in this case. There are two other \
cases of interest: real and equal roots, and imaginary roots.\
\>", "Text",
  CellTags->"b:1.1.1.1"],

Cell["This example has real and equal roots.", "MathCaption",
  CellTags->"b:1.1.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[\(y''\)[x]\  - \ 6\ \(y'\)[x]\  + 9  y[x] \[Equal] 0, \ y, \ 
        x]\)], "Input",
  CellLabel->"In[85]:=",
  CellTags->"b:1.1.1.1"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, \[ExponentialE]\^\(3\ x\)\ C[
                  1] + \[ExponentialE]\^\(3\ x\)\ x\ C[2]]}}\)], "Output",
  CellLabel->"Out[85]=",
  CellTags->"b:1.1.1.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = \ \(y[x] /. sol[\([\)\(1\)\(]\)]\) /. {C[1] \[Rule] \ 2, \ 
          C[2] \[Rule] \ 3}\)], "Input",
  CellLabel->"In[86]:=",
  CellTags->"b:1.1.1.1"],

Cell[BoxData[
    \(2\ \[ExponentialE]\^\(3\ x\) + 
      3\ \[ExponentialE]\^\(3\ x\)\ x\)], "Output",
  CellLabel->"Out[86]=",
  CellTags->"b:1.1.1.1"]
}, Open  ]],

Cell["This example has imaginary roots.", "MathCaption",
  CellTags->"b:1.1.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[\(y''\)[x]\  - \ \(y'\)[x]\  + y[x] \[Equal] 0, \ y, \ 
        x]\)], "Input",
  CellLabel->"In[87]:=",
  CellTags->"b:1.1.1.1"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, \[ExponentialE]\^\(x/2\)\ C[
                  1]\ Cos[\(\@3\ x\)\/2] + \[ExponentialE]\^\(x/2\)\ C[
                  2]\ Sin[\(\@3\ x\)\/2]]}}\)], "Output",
  CellLabel->"Out[87]=",
  CellTags->"b:1.1.1.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol3 = \ \(y[x] /. sol[\([\)\(1\)\(]\)]\) /. {C[1] \[Rule] \ 2, \ 
          C[2] \[Rule] \ 3}\)], "Input",
  CellLabel->"In[88]:=",
  CellTags->"b:1.1.1.1"],

Cell[BoxData[
    \(2\ \[ExponentialE]\^\(x/2\)\ Cos[\(\@3\ x\)\/2] + 
      3\ \[ExponentialE]\^\(x/2\)\ Sin[\(\@3\ x\)\/2]\)], "Output",
  CellLabel->"Out[88]=",
  CellTags->"b:1.1.1.1"]
}, Open  ]],

Cell["Here is a plot of the three solutions.", "MathCaption",
  CellTags->"b:1.1.1.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{sol1, \ sol2, \ sol3}, \ {x, \(-0.5\), \ 0.5}, \ 
      PlotStyle\  \[Rule] \ {Red, \ Green, \ Blue}, \ 
      PlotRange\  \[Rule] \ All]; \)], "Input",
  CellLabel->"In[89]:=",
  CellTags->"b:1.1.1.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.952381 0.0131471 0.0140548 [
[.11905 .00065 -12 -9 ]
[.11905 .00065 12 0 ]
[.30952 .00065 -12 -9 ]
[.30952 .00065 12 0 ]
[.69048 .00065 -9 -9 ]
[.69048 .00065 9 0 ]
[.88095 .00065 -9 -9 ]
[.88095 .00065 9 0 ]
[.4875 .1537 -12 -4.5 ]
[.4875 .1537 0 4.5 ]
[.4875 .29424 -12 -4.5 ]
[.4875 .29424 0 4.5 ]
[.4875 .43479 -12 -4.5 ]
[.4875 .43479 0 4.5 ]
[.4875 .57534 -12 -4.5 ]
[.4875 .57534 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .01315 m
.11905 .0194 L
s
[(-0.4)] .11905 .00065 0 1 Mshowa
.30952 .01315 m
.30952 .0194 L
s
[(-0.2)] .30952 .00065 0 1 Mshowa
.69048 .01315 m
.69048 .0194 L
s
[(0.2)] .69048 .00065 0 1 Mshowa
.88095 .01315 m
.88095 .0194 L
s
[(0.4)] .88095 .00065 0 1 Mshowa
.125 Mabswid
.16667 .01315 m
.16667 .0169 L
s
.21429 .01315 m
.21429 .0169 L
s
.2619 .01315 m
.2619 .0169 L
s
.35714 .01315 m
.35714 .0169 L
s
.40476 .01315 m
.40476 .0169 L
s
.45238 .01315 m
.45238 .0169 L
s
.54762 .01315 m
.54762 .0169 L
s
.59524 .01315 m
.59524 .0169 L
s
.64286 .01315 m
.64286 .0169 L
s
.7381 .01315 m
.7381 .0169 L
s
.78571 .01315 m
.78571 .0169 L
s
.83333 .01315 m
.83333 .0169 L
s
.07143 .01315 m
.07143 .0169 L
s
.02381 .01315 m
.02381 .0169 L
s
.92857 .01315 m
.92857 .0169 L
s
.97619 .01315 m
.97619 .0169 L
s
.25 Mabswid
0 .01315 m
1 .01315 L
s
.5 .1537 m
.50625 .1537 L
s
[(10)] .4875 .1537 1 0 Mshowa
.5 .29424 m
.50625 .29424 L
s
[(20)] .4875 .29424 1 0 Mshowa
.5 .43479 m
.50625 .43479 L
s
[(30)] .4875 .43479 1 0 Mshowa
.5 .57534 m
.50625 .57534 L
s
[(40)] .4875 .57534 1 0 Mshowa
.125 Mabswid
.5 .04126 m
.50375 .04126 L
s
.5 .06937 m
.50375 .06937 L
s
.5 .09748 m
.50375 .09748 L
s
.5 .12559 m
.50375 .12559 L
s
.5 .18181 m
.50375 .18181 L
s
.5 .20991 m
.50375 .20991 L
s
.5 .23802 m
.50375 .23802 L
s
.5 .26613 m
.50375 .26613 L
s
.5 .32235 m
.50375 .32235 L
s
.5 .35046 m
.50375 .35046 L
s
.5 .37857 m
.50375 .37857 L
s
.5 .40668 m
.50375 .40668 L
s
.5 .4629 m
.50375 .4629 L
s
.5 .49101 m
.50375 .49101 L
s
.5 .51912 m
.50375 .51912 L
s
.5 .54723 m
.50375 .54723 L
s
.5 .60345 m
.50375 .60345 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
1 0 0 r
.5 Mabswid
.02381 .60332 m
.06244 .4824 L
.10458 .38041 L
.14415 .3067 L
.18221 .25149 L
.22272 .20592 L
.26171 .17211 L
.30316 .14459 L
.34309 .12445 L
.3815 .10968 L
.42237 .09785 L
.46172 .08943 L
.49955 .08348 L
.52059 .08092 L
.53984 .07898 L
.57861 .07607 L
.5976 .07506 L
.61832 .07423 L
.63799 .07367 L
.64899 .07345 L
.65897 .0733 L
.66384 .07324 L
.66899 .07319 L
.67339 .07316 L
.67586 .07315 L
.67821 .07313 L
.68093 .07312 L
.68213 .07312 L
.68341 .07312 L
.68407 .07312 L
.68479 .07312 L
.68608 .07311 L
.6868 .07311 L
.68757 .07311 L
.68831 .07311 L
.68898 .07311 L
.69019 .07311 L
.69132 .07311 L
.69255 .07312 L
.69388 .07312 L
.69527 .07312 L
.69658 .07313 L
.69903 .07313 L
.70366 .07316 L
.70875 .07319 L
.71905 .07329 L
.72858 .07341 L
.7375 .07355 L
.75779 .07396 L
.77632 .07443 L
Mistroke
.81608 .07574 L
.85433 .07733 L
.89503 .07932 L
.93421 .08149 L
.97584 .08404 L
.97619 .08406 L
Mfstroke
0 1 0 r
.02381 .01472 m
.06244 .01535 L
.10458 .0162 L
.14415 .01717 L
.18221 .01831 L
.22272 .01976 L
.26171 .02144 L
.30316 .02358 L
.34309 .02606 L
.3815 .02889 L
.42237 .03247 L
.46172 .03656 L
.49955 .0412 L
.53984 .04701 L
.57861 .05361 L
.61984 .06189 L
.65954 .07129 L
.69774 .08187 L
.73838 .09507 L
.77751 .10997 L
.81909 .12855 L
.85916 .14957 L
.89771 .17316 L
.93871 .20245 L
.97619 .23361 L
s
0 0 1 r
.02381 .01924 m
.06244 .02076 L
.10458 .02247 L
.14415 .02413 L
.18221 .02578 L
.22272 .02759 L
.26171 .02937 L
.30316 .03132 L
.34309 .03325 L
.3815 .03515 L
.42237 .03721 L
.46172 .03924 L
.49955 .04123 L
.53984 .04339 L
.57861 .0455 L
.61984 .04779 L
.65954 .05002 L
.69774 .05219 L
.73838 .05454 L
.77751 .05681 L
.81909 .05926 L
.85916 .06163 L
.89771 .06393 L
.93871 .06638 L
.97619 .06863 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gR000`400?l00000o`00003o:`3oool4
000000D0oooo0P0000070?ooo`<00000;03oool4000000D0oooo0P0000040?ooo`D00000JP3oool4
000000D0oooo0P0000040?ooo`D00000;@3oool4000000D0oooo0P0000070?ooo`<00000:03oool0
02X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`800000203oool00`00
0000oooo0?ooo`0Z0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool20000
00@0oooo00D000000?ooo`3oool0oooo0000001Y0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00P3oool2000000@0oooo00D000000?ooo`3oool0oooo0000000/0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000P0oooo00<000000?ooo`3oool09`3o
ool002X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo02X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo06X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo02d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo02L0oooo000R0?ooo`H000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00P0oooo1P00000S0?ooo`H000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00P0oooo1P00000X0?ooo`00:P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0
oooo00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00T0oooo00@000000?ooo`3oool00000:@3oool002X0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`090?ooo`040000003oool0oooo000002`0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`090?ooo`040000003oool0oooo000002T0oooo000Z0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool02P3oool00`000000oooo0000000/0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000006T0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`000000
;03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo00<000000?ooo`000000
:@3oool002/0oooo1000000>0?ooo`800000;@3oool4000000`0oooo0`00001[0?ooo`@00000303o
ool3000002h0oooo1000000>0?ooo`800000:@3oool00?l0ooooJ@3oool00?l0ooooJ@3oool00?l0
ooooJ@3oool00;<0oooo00<000000?ooo`3oool0/P3oool00;<0oooo00<000000?ooo`3oool0/P3o
ool00;<0oooo00<000000?ooo`3oool0/P3oool00;<0oooo00<000000?ooo`3oool0/P3oool00;<0
oooo00<000000?ooo`3oool0/P3oool000T0oooo2000000D003o0?l00000>P00000:0?ooo`004@3o
ool00`000000oooo0?ooo`0=0?ooo`040000003oool0oooo0?ooobT00?l0103oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo0100oooo000A0?oooa@0003o303oool00`000000oooo0?oo
o`0J0?oooa/00?l02@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo03h0oooo00<0
00000?ooo`3oool0?P3oool00`000000oooo0?ooo`0`0?ooo`009@3ooolL0000obP0oooo3P00o`0l
0?ooo`030000003oool0oooo0;80oooo00110?ooo`d0003o:@3oool>003o02h0oooo00<000000?oo
o`3oool0/P3oool004h0oooo6`000?lL0?ooo`d00?l08@3oool00`000000oooo0?ooo`2b0?ooo`00
J@3ooolL0000o`d0oooo2`00o`0F0?ooo`030000003oool0oooo0;80oooo00250?ooo`d0003o2`3o
ool6003o0100oooo00<000000?ooo`3oool0/P3oool00980oooo3P000?l30?ooo`X00?l01P3oool0
0`000000oooo0?ooo`2b0?ooo`00X03ooolJ0000ojh0oooo002c0?ooo`040000003oool0oooo0?oo
o`<00?l03P000?nP0?ooo`00/`3oool00`000000oooo0?ooo`080?ooo`L00?l00`3ooolK0000ohD0
oooo002c0?ooo`030000003oool0oooo00l0oooo1P00o`0H0?ooo`d0003oN03oool00;<0oooo00<0
00000?ooo`3oool05@3oool6003o01l0oooo3@000?m[0?ooo`00/`3oool00`000000oooo0?ooo`0K
0?ooo`@00?l0:03ooolL0000odl0oooo002c0?ooo`030000003oool0oooo01l0oooo1@00o`0o0?oo
o`h0003o@@3oool00;<0oooo00<000000?ooo`3oool0903oool5003o04P0oooo3@000?ld0?ooo`00
/`3oool00`000000oooo0?ooo`0Y0?ooo`@00?l0D@3oool=0000obL0oooo002c0?ooo`030000003o
ool0oooo02d0oooo1000o`1J0?ooo`h0003o6@3oool00;<0oooo0P00000b0?ooo`@00?l0I03oool7
0000oa80oooo002c0?ooo`030000003oool0oooo0280oooo4`3o0003003o02X0o`00D03oool00;<0
oooo00<000000?ooo`3oool04P3oool@0?l001H0oooo1000o`0V0?oooa/0o`00=@3oool00;<0oooo
00<000000?ooo`3oool0203oool:0?l002X0oooo0`00o`0n0?ooo`d0o`00:03oool00;<0oooo00@0
00000?ooo`3oool0oooo1`3o000g0?ooo`<00?l0B03oool>0?l001X0oooo002`0?ooo`L0o`00@@3o
ool3003o05<0oooo203o000B0?ooo`00ZP3oool60?l000<0oooo00<000000?ooo`3oool0A@3oool2
003o06/0oooo002S0?ooo`L0o`002@3oool00`000000oooo0?ooo`170?ooo`<00?l0J03oool009d0
oooo1P3o000@0?ooo`030000003oool0oooo04X0oooo0`00o`1U0?ooo`00V03oool50?l001H0oooo
0P00001>0?ooo`<00?l0HP3oool009@0oooo103o000K0?ooo`030000003oool0oooo0500oooo0P00
o`1P0?ooo`00T@3oool30?l001l0oooo00<000000?ooo`3oool0DP3oool3003o05d0oooo002=0?oo
o`@0o`008P3oool00`000000oooo0?ooo`1E0?ooo`<00?l0FP3oool008X0oooo0`3o000V0?ooo`03
0000003oool0oooo05P0oooo0P00o`1H0?ooo`00R03oool20?l002T0oooo00<000000?ooo`3oool0
FP3oool3003o05D0oooo00260?ooo`80o`00:`3oool00`000000oooo0?ooo`1M0?ooo`800?l0D`3o
ool008@0oooo0P3o000]0?ooo`030000003oool0oooo05l0oooo0`00o`1@0?ooo`00PP3oool20?l0
02l0oooo00<000000?ooo`3oool0HP3oool2003o04h0oooo00200?ooo`80o`00<@3oool00`000000
oooo0?ooo`1T0?ooo`<00?l0B`3oool007d0oooo0`3o000c0?ooo`800000J03oool2003o04T0oooo
001k0?ooo`80o`00=P3oool00`000000oooo0?ooo`1Y0?ooo`800?l0A`3oool007T0oooo0P3o000h
0?ooo`030000003oool0oooo06/0oooo0P00o`150?ooo`00MP3oool30?l003X0oooo00<000000?oo
o`3oool0K@3oool2003o04<0oooo001d0?ooo`80o`00?@3oool00`000000oooo0?ooo`1_0?ooo`80
0?l0@@3oool00780oooo0P3o000o0?ooo`030000003oool0oooo0740oooo0P00o`0o0?ooo`00L03o
ool20?l002l0oooo1@0000030?ooo`@000001P3oool00`000000oooo0?ooo`1c0?ooo`800?l0?@3o
ool006h0oooo0P3o000c0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo07D0oooo0P00o`0k0?ooo`00K@3oool00`3o
0000oooo0?ooo`0c0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo07L0oooo00<00?l00?ooo`3oool0>03oool006`0
oooo00<0o`000?ooo`3oool0=03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool3000007P0oooo0P00o`0h0?ooo`00JP3oool20?l003L0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0NP3oool2003o03H0oooo001Y0?ooo`030?l0003oool0oooo03L0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0O03oool00`00o`00oooo0?ooo`0c0?ooo`00I`3oool20?l003P0oooo0`000004
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1m
0?ooo`800?l0<`3oool006H0oooo00<0o`000?ooo`3oool0>P3oool00`000000oooo0?ooo`030?oo
o`@000001P3oool00`000000oooo0?ooo`1o0?ooo`03003o003oool0oooo0300oooo001U0?ooo`03
0?l0003oool0oooo04/0oooo00<000000?ooo`3oool0P03oool2003o0300oooo001S0?ooo`80o`00
CP3oool00`000000oooo0?ooo`220?ooo`800?l0;P3oool00680oooo00<0o`000?ooo`3oool0CP3o
ool00`000000oooo0?ooo`240?ooo`03003o003oool0oooo02/0oooo001Q0?ooo`030?l0003oool0
oooo04l0oooo00<000000?ooo`3oool0Q@3oool2003o02/0oooo001P0?ooo`030?l0003oool0oooo
0500oooo00<000000?ooo`3oool0Q`3oool00`00o`00oooo0?ooo`0X0?ooo`00GP3oool20?l005<0
oooo0P0000290?ooo`03003o003oool0oooo02L0oooo001M0?ooo`030?l0003oool0oooo05<0oooo
00<000000?ooo`3oool0R@3oool2003o02L0oooo001L0?ooo`030?l0003oool0oooo05@0oooo00<0
00000?ooo`3oool0R`3oool00`00o`00oooo0?ooo`0T0?ooo`00F`3oool00`3o0000oooo0?ooo`1E
0?ooo`030000003oool0oooo08`0oooo0P00o`0T0?ooo`00FP3oool00`3o0000oooo0?ooo`1F0?oo
o`030000003oool0oooo08h0oooo00<00?l00?ooo`3oool08@3oool005P0oooo0P3o001I0?ooo`03
0000003oool0oooo08l0oooo00<00?l00?ooo`3oool0803oool005L0oooo00<0o`000?ooo`3oool0
F@3oool00`000000oooo0?ooo`2@0?ooo`800?l0803oool005H0oooo00<0o`000?ooo`3oool0FP3o
ool00`000000oooo0?ooo`2B0?ooo`03003o003oool0oooo01d0oooo001E0?ooo`030?l0003oool0
oooo05/0oooo00<000000?ooo`3oool0T`3oool00`00o`00oooo0?ooo`0L0?ooo`00E03oool00`3o
0000oooo0?ooo`1L0?ooo`030000003oool0oooo09@0oooo00<00?l00?ooo`3oool06`3oool005<0
oooo00<0o`000?ooo`3oool0G@3oool2000009H0oooo0P00o`0K0?ooo`00DP3oool00`3o0000oooo
0?ooo`1N0?ooo`030000003oool0oooo09L0oooo00<00?l00?ooo`3oool0603oool00540oooo00<0
o`000?ooo`3oool0G`3oool00`000000oooo0?ooo`2H0?ooo`03003o003oool0oooo01L0oooo001A
0?ooo`030?l0003oool0oooo05l0oooo00<000000?ooo`3oool0V@3oool00`00o`00oooo0?ooo`0F
0?ooo`00D03oool00`3o0000oooo0?ooo`1P0?ooo`030000003oool0oooo09X0oooo00<00?l00?oo
o`3oool05@3oool004l0oooo00<0o`000?ooo`3oool0H@3oool00`000000oooo0?ooo`2K0?ooo`80
0?l05@3oool004h0oooo00<0o`000?ooo`3oool0HP3oool00`000000oooo0?ooo`2M0?ooo`03003o
003oool0oooo0180oooo001=0?ooo`030?l0003oool0oooo06<0oooo00<000000?ooo`3oool0WP3o
ool00`00o`00oooo0?ooo`0A0?ooo`00C03oool00`3o0000oooo0?ooo`1T0?ooo`030000003oool0
oooo09l0oooo00<00?l00?ooo`3oool0403oool004/0oooo00<0o`000?ooo`3oool0I@3oool20000
0;<0oooo001:0?ooo`030?l0003oool0oooo06H0oooo00<000000?ooo`3oool0/P3oool004X0oooo
00<0o`000?ooo`3oool0IP3oool00`000000oooo0?ooo`2b0?ooo`00B@3oool00`3o0000oooo0?oo
o`1W0?ooo`030000003oool0oooo0;80oooo00180?ooo`030?l0003oool0oooo06P0oooo00<00000
0?ooo`3oool0/P3oool004L0oooo00<0o`000?ooo`3oool0J@3oool00`000000oooo0?ooo`2b0?oo
o`00AP3oool00`3o0000oooo0?ooo`1Z0?ooo`030000003oool0oooo0;80oooo00160?ooo`030?l0
003oool0oooo06X0oooo00<000000?ooo`3oool0/P3oool004D0oooo00<0o`000?ooo`3oool0J`3o
ool00`000000oooo0?ooo`2b0?ooo`00A03oool00`3o0000oooo0?ooo`1/0?ooo`030000003oool0
oooo0;80oooo00140?ooo`030?l0003oool0oooo06`0oooo0P00002c0?ooo`00@`3oool00`3o0000
oooo0?ooo`1]0?ooo`030000003oool0oooo0;80oooo00120?ooo`030?l0003oool0oooo06h0oooo
00<000000?ooo`3oool0/P3oool00480oooo00<0o`000?ooo`3oool0KP3oool00`000000oooo0?oo
o`2b0?ooo`00@@3oool00`3o0000oooo0?ooo`1_0?ooo`030000003oool0oooo0;80oooo00100?oo
o`030?l0003oool0oooo0700oooo00<000000?ooo`3oool0/P3oool003l0oooo00<0o`000?ooo`3o
ool0GP3oool5000000@0oooo100000060?ooo`030000003oool0oooo0;80oooo000o0?ooo`030?l0
003oool0oooo05h0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2b0?ooo`00?P3oool00`3o0000oooo
0?ooo`1P0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0;80oooo000m0?ooo`030?l0003oool0oooo0680oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0`00
002b0?ooo`00?@3oool00`3o0000oooo0?ooo`1S0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0;80oooo000l0?oo
o`030?l0003oool0oooo06D0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0/P3oool003/0oooo00<0o`000?ooo`3oool0HP3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0;80oooo000k0?ooo`030?l0003oool0oooo06<0oooo0`0000050?oo
o`@000001P3oool00`000000oooo0?ooo`2b0?ooo`00>P3oool00`3o0000oooo0?ooo`1f0?ooo`03
0000003oool0oooo0;80oooo000i0?ooo`030?l0003oool0oooo07L0oooo00<000000?ooo`3oool0
/P3oool003T0oooo00<0o`000?ooo`3oool0M`3oool00`000000oooo0?ooo`2b0?ooo`00>03oool0
0`3o0000oooo0?ooo`1h0?ooo`030000003oool0oooo0;80oooo000h0?ooo`030?l0003oool0oooo
07P0oooo00<000000?ooo`3oool0/P3oool003L0oooo00<0o`000?ooo`3oool0N@3oool200000;<0
oooo000g0?ooo`030?l0003oool0oooo07T0oooo00<000000?ooo`3oool0/P3oool003H0oooo00<0
o`000?ooo`3oool0NP3oool00`000000oooo0?ooo`2b0?ooo`00=P3oool00`3o0000oooo0?ooo`1j
0?ooo`030000003oool0oooo0;80oooo000e0?ooo`030?l0003oool0oooo07/0oooo00<000000?oo
o`3oool0/P3oool003@0oooo00<0o`000?ooo`3oool0O03oool00`000000oooo0?ooo`2b0?ooo`00
=03oool00`3o0000oooo0?ooo`1l0?ooo`030000003oool0oooo0;80oooo000c0?ooo`030?l0003o
ool0oooo07d0oooo00<000000?ooo`3oool0/P3oool003<0oooo00<0o`000?ooo`3oool0O@3oool0
0`000000oooo0?ooo`2b0?ooo`00<P3oool00`3o0000oooo0?ooo`1n0?ooo`800000/`3oool00380
oooo00<0o`000?ooo`3oool0OP3oool00`000000oooo0?ooo`2b0?ooo`00<@3oool00`3o0000oooo
0?ooo`1o0?ooo`030000003oool0oooo0;80oooo000`0?ooo`030?l0003oool0oooo0800oooo00<0
00000?ooo`3oool0/P3oool00300oooo00<0o`000?ooo`3oool0P03oool00`000000oooo0?ooo`2b
0?ooo`00;`3oool00`3o0000oooo0?ooo`210?ooo`030000003oool0oooo0;80oooo000_0?ooo`03
0?l0003oool0oooo0840oooo00<000000?ooo`3oool0/P3oool002h0oooo00<0o`000?ooo`3oool0
PP3oool00`000000oooo0?ooo`2b0?ooo`00;P3oool00`3o0000oooo0?ooo`220?ooo`030000003o
ool0oooo0;80oooo000]0?ooo`030?l0003oool0oooo08<0oooo00<000000?ooo`3oool0/P3oool0
02d0oooo00<0o`000?ooo`3oool0P`3oool200000;<0oooo000/0?ooo`030?l0003oool0oooo08@0
oooo00<000000?ooo`3oool0/P3oool002`0oooo00<0o`000?ooo`3oool0Q03oool00`000000oooo
0?ooo`2b0?ooo`00:`3oool00`3o0000oooo0?ooo`250?ooo`030000003oool0oooo0;80oooo000[
0?ooo`030?l0003oool0oooo08D0oooo00<000000?ooo`3oool0/P3oool002X0oooo00<0o`000?oo
o`3oool0QP3oool00`000000oooo0?ooo`2b0?ooo`00:P3oool00`3o0000oooo0?ooo`260?ooo`03
0000003oool0oooo0;80oooo000Z0?ooo`030?l0003oool0oooo08H0oooo00<000000?ooo`3oool0
/P3oool002T0oooo00<0o`000?ooo`3oool0Q`3oool00`000000oooo0?ooo`2b0?ooo`00:@3oool0
0`3o0000oooo0?ooo`270?ooo`030000003oool0oooo0;80oooo000X0?ooo`030?l0003oool0oooo
08P0oooo0P00002c0?ooo`00:03oool00`3o0000oooo0?ooo`280?ooo`030000003oool0oooo0;80
oooo000W0?ooo`030?l0003oool0oooo08T0oooo00<000000?ooo`3oool0/P3oool002L0oooo00<0
o`000?ooo`3oool0R@3oool00`000000oooo0?ooo`2b0?ooo`009`3oool00`3o0000oooo0?ooo`29
0?ooo`030000003oool0oooo0;80oooo000V0?ooo`030?l0003oool0oooo08X0oooo00<000000?oo
o`3oool0/P3oool002H0oooo00<0o`000?ooo`3oool0N03oool3000000D0oooo100000060?ooo`03
0000003oool0oooo0;80oooo000U0?ooo`030?l0003oool0oooo07P0oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`2b0?ooo`009@3oool00`3o0000oooo0?ooo`1l0?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0;80oooo000U0?ooo`030?l0
003oool0oooo07`0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00<0
oooo0`00002b0?ooo`00903oool00`3o0000oooo0?ooo`1k0?ooo`800000103oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0/P3oool002@0oooo00<0
o`000?ooo`3oool0O@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`2b0?ooo`008`3oool00`3o0000oooo0?ooo`1j0?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0/P3oool002<0oooo00<0o`000?ooo`3oool0N`3oool3000000D0oooo1000
00060?ooo`030000003oool0oooo0;80oooo000S0?ooo`030?l0003oool0oooo08d0oooo00<00000
0?ooo`3oool0/P3oool00280oooo00<0o`000?ooo`3oool0SP3oool00`000000oooo0?ooo`2b0?oo
o`008P3oool00`3o0000oooo0?ooo`2>0?ooo`030000003oool0oooo0;80oooo000Q0?ooo`030?l0
003oool0oooo08l0oooo00<000000?ooo`3oool0/P3oool00240oooo00<0o`000?ooo`3oool0S`3o
ool00`000000oooo0?ooo`2b0?ooo`00803oool00`3o0000oooo0?ooo`2@0?ooo`800000/`3oool0
0200oooo00<0o`000?ooo`3oool0T03oool00`000000oooo0?ooo`2b0?ooo`00803oool00`3o0000
oooo0?ooo`2@0?ooo`030000003oool0oooo0;80oooo000O0?ooo`030?l0003oool0oooo0940oooo
00<000000?ooo`3oool0/P3oool001l0oooo00<0o`000?ooo`3oool0T@3oool00`000000oooo0?oo
o`2b0?ooo`007P3oool00`3o0000oooo0?ooo`2B0?ooo`030000003oool0oooo0;80oooo000N0?oo
o`030?l0003oool0oooo0980oooo00<000000?ooo`3oool0/P3oool001h0oooo00<0o`000?ooo`3o
ool0TP3oool00`000000oooo0?ooo`2b0?ooo`007@3oool00`3o0000oooo0?ooo`2C0?ooo`030000
003oool0oooo0;80oooo000M0?ooo`030?l0003oool0oooo09<0oooo0P00002c0?ooo`007@3oool0
0`3o0000oooo0?ooo`2C0?ooo`030000003oool0oooo0;80oooo000L0?ooo`030?l0003oool0oooo
09@0oooo00<000000?ooo`3oool0/P3oool001`0oooo00<0o`000?ooo`3oool0U03oool00`000000
oooo0?ooo`2b0?ooo`00703oool00`3o0000oooo0?ooo`2D0?ooo`030000003oool0oooo0;80oooo
000K0?ooo`030?l0003oool0oooo09D0oooo00<000000?ooo`3oool0/P3oool001/0oooo00<0o`00
0?ooo`3oool0U@3oool00`000000oooo0?ooo`2b0?ooo`006`3oool00`3o0000oooo0?ooo`2E0?oo
o`030000003oool0oooo0;80oooo000K0?ooo`030?l0003oool0oooo09D0oooo00<000000?ooo`3o
ool0/P3oool001X0oooo00<0o`000?ooo`3oool0UP3oool00`000000oooo0?ooo`2b0?ooo`006P3o
ool00`3o0000oooo0?ooo`2F0?ooo`800000/`3oool001X0oooo00<0o`000?ooo`3oool0UP3oool0
0`000000oooo0?ooo`2b0?ooo`006@3oool00`3o0000oooo0?ooo`2G0?ooo`030000003oool0oooo
0;80oooo000I0?ooo`030?l0003oool0oooo09L0oooo00<000000?ooo`3oool0/P3oool001T0oooo
00<0o`000?ooo`3oool0U`3oool00`000000oooo0?ooo`2b0?ooo`00603oool00`3o0000oooo0?oo
o`2H0?ooo`030000003oool0oooo0;80oooo000H0?ooo`030?l0003oool0oooo09P0oooo00<00000
0?ooo`3oool0/P3oool001P0oooo00<0o`000?ooo`3oool0V03oool00`000000oooo0?ooo`2b0?oo
o`005`3oool00`3o0000oooo0?ooo`2I0?ooo`030000003oool0oooo0;80oooo000G0?ooo`030?l0
003oool0oooo09T0oooo0P00002c0?ooo`005`3oool00`3o0000oooo0?ooo`2I0?ooo`030000003o
ool0oooo0;80oooo000F0?ooo`030?l0003oool0oooo09X0oooo00<000000?ooo`3oool0/P3oool0
01H0oooo00<0o`000?ooo`3oool0VP3oool00`000000oooo0?ooo`2b0?ooo`005P3oool00`3o0000
oooo0?ooo`2J0?ooo`030000003oool0oooo0;80oooo000E0?ooo`030?l0003oool0oooo09/0oooo
00<000000?ooo`3oool0/P3oool001D0oooo00<0o`000?ooo`3oool0V`3oool00`000000oooo0?oo
o`2b0?ooo`005@3oool00`3o0000oooo0?ooo`2;0?ooo`<000000`3oool4000000H0oooo00<00000
0?ooo`3oool0/P3oool001@0oooo00<0o`000?ooo`3oool0S@3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2b0?ooo`00503oool00`3o
0000oooo0?ooo`2=0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0;80oooo000D0?ooo`030?l0003oool0oooo08T0oooo1P0000020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool300000;80oooo000D0?ooo`03
0?l0003oool0oooo08X0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0/P3oool001<0oooo00<0o`000?ooo`3o
ool0R`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`2b0?ooo`004`3oool00`3o0000oooo0?ooo`2<0?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0;80oooo000C0?ooo`030?l0003oool0oooo08d0oooo0P0000040?ooo`@00000
1P3oool00`000000oooo0?ooo`2b0?ooo`004P3oool00`3o0000oooo0?ooo`2N0?ooo`030000003o
ool0oooo0;80oooo000B0?ooo`030?l0003oool0oooo09h0oooo00<000000?ooo`3oool0/P3oool0
0180oooo00<0o`000?ooo`3oool0WP3oool00`000000oooo0?ooo`2b0?ooo`004@3oool00`3o0000
oooo0?ooo`2O0?ooo`030000003oool0oooo0;80oooo000A0?ooo`030?l0003oool0oooo09l0oooo
00<000000?ooo`3oool0/P3oool00;<0oooo0P00002c0?ooo`00/`3oool00`000000oooo0?ooo`2b
0?ooo`00/`3oool00`000000oooo0?ooo`2b0?ooo`00/`3oool00`000000oooo0?ooo`2b0?ooo`00
/`3oool00`000000oooo0?ooo`2b0?ooo`00\
\>"],
  ImageRangeCache->{{{81, 368}, {481.312, 304.375}} -> {-0.866592, 76.3712, \
0.0038601, 0.261568}},
  CellTags->"b:1.1.1.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Euler and Legendre Equations", "Subsubsection",
  CellTags->{"c:20", "b:1.1.1.2"}],

Cell[TextData[{
  "An ",
  StyleBox["Euler equation",
    FontSlant->"Italic"],
  " has the general form"
}], "Text",
  CellTags->"b:1.1.1.2"],

Cell[BoxData[
    FormBox[
      RowBox[{
      "                                                                      \
", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), "  ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]\[Prime]",
                  MultilineFunction->None], "(", "x", ")"}]}], " ", "+", 
            RowBox[{"a", " ", "x", " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "(", "x", ")"}]}], " ", 
            "+", \(b\ \(y(x)\)\)}], "\[LongEqual]", "0."}]}], 
      TraditionalForm]], "Text",
  CellTags->"b:1.1.1.2"],

Cell["\<\
Euler equations can be solved by transforming them to equations \
with constant coefficients.\
\>", "Text",
  CellTags->"b:1.1.1.2"],

Cell["This is an example of an Euler equation.", "MathCaption",
  CellTags->"b:1.1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[x^2*\(y''\)[x]\  + 5*x*\(y'\)[x] + 6*y[x] \[Equal] 0, \ y[x], 
      x]\)], "Input",
  CellLabel->"In[90]:=",
  CellTags->"b:1.1.1.2"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(C[2]\ Cos[\@2\ Log[x]]\)\/x\^2 + \(C[1]\ Sin[\@2\ \
Log[x]]\)\/x\^2}}\)], "Output",
  CellLabel->"Out[90]=",
  CellTags->"b:1.1.1.2"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Legendre Linear equation",
    FontSlant->"Italic"],
  " is a generalization of the Euler equation. It is an ODE of the form "
}], "Text",
  CellTags->{"LegendreODE", "b:1.1.1.2"}],

Cell[BoxData[
    FormBox[
      RowBox[{"                                                        ", 
        RowBox[{
          RowBox[{
            RowBox[{\(\((c\ x\  + \ d)\)\^2\), 
              RowBox[{
                SuperscriptBox["y", "\[Prime]\[Prime]",
                  MultilineFunction->None], "(", "x", ")"}]}], " ", "+", 
            RowBox[{"a", "  ", \((c\ x\  + \ d)\), 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "(", "x", ")"}]}], 
            "+", \(b\ \(y(x)\)\)}], "\[LongEqual]", "0."}]}], 
      TraditionalForm]], "Text",
  CellTags->"b:1.1.1.2"],

Cell["Here is an example of a Legendre Linear equation.", "MathCaption",
  CellTags->"b:1.1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\((3  x + 1)\)^2*\(y''\)[x]\  + 5*\((3  x + 1)\)*\(y'\)[x] + 
          6*y[x] \[Equal] 0, \ y[x], x]\)], "Input",
  CellLabel->"In[91]:=",
  CellTags->"b:1.1.1.2"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(C[2]\ Cos[1\/3\ \@5\ Log[1 + 3\ x]]\)\/\((1 + 3\ \
x)\)\^\(1/3\) + \(C[1]\ Sin[1\/3\ \@5\ Log[1 + 3\ x]]\)\/\((1 + 3\ \
x)\)\^\(1/3\)}}\)], "Output",
  CellLabel->"Out[91]=",
  CellTags->"b:1.1.1.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exact Linear Second-Order Equations", "Subsubsection",
  CellTags->{"c:21", "b:1.1.1.3"}],

Cell["\<\
As in the case of first-order ODEs, a linear second-order ODE can \
be exact. An exact linear second-order ODE is solved by reduction to a linear \
first-order ODE. \
\>", "Text",
  CellTags->"b:1.1.1.3"],

Cell[TextData[{
  "Here is an example. The appearance of the unevaluated integral in the \
solution is explained ",
  ButtonBox["here",
    ButtonData:>"k$_variables",
    ButtonStyle->"Hyperlink"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.3"],

Cell[BoxData[
    \(a0 = 1; \)], "Input",
  CellLabel->"In[92]:=",
  CellTags->"b:1.1.1.3"],

Cell[BoxData[
    \(a1 = Log[x]; \)], "Input",
  CellLabel->"In[93]:=",
  CellTags->"b:1.1.1.3"],

Cell[BoxData[
    \(a2 = 1/x; \)], "Input",
  CellLabel->"In[94]:=",
  CellTags->"b:1.1.1.3"],

Cell[BoxData[
    \(eqn = a0*\(y''\)[x] + a1*\(y'\)[x] + \ a2*y[x] \[Equal] 0; \)], "Input",\

  CellLabel->"In[95]:=",
  CellTags->"b:1.1.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(conditionforexactness\  = \ \((D[a0, \ {x, 2}] - D[a1, x] + a2 \[Equal] 
          0)\)\)], "Input",
  CellLabel->"In[96]:=",
  CellTags->"b:1.1.1.3"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[96]=",
  CellTags->"b:1.1.1.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[eqn, \ y, x]\)], "Input",
  CellLabel->"In[97]:=",
  CellTags->"b:1.1.1.3"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, \[ExponentialE]\^\(x - x\ Log[x]\)\ C[
                  2] + \[ExponentialE]\^\(x - x\ Log[x]\)\ \
\(\[Integral]\_1\%x\( \[ExponentialE]\^\(\(-K$6129\) + K$6129\ Log[K$6129]\)\ \
C[1]\) \[DifferentialD]K$6129\)]}}\)], "Output",
  CellLabel->"Out[97]=",
  CellTags->"b:1.1.1.3"]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
  CellTags->"b:1.1.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqn /. sol // FullSimplify\)], "Input",
  CellLabel->"In[98]:=",
  CellTags->"b:1.1.1.3"],

Cell[BoxData[
    \({True}\)], "Output",
  CellLabel->"Out[98]=",
  CellTags->"b:1.1.1.3"]
}, Open  ]],

Cell[BoxData[
    \(Clear[a0, a1, a2]\)], "Input",
  CellLabel->"In[99]:=",
  CellTags->"b:1.1.1.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equations with Solutions Involving Special Functions", "Subsubsection",
  CellTags->{"special_functions_in_solutions", "c:22", "b:1.1.1.4"}],

Cell[TextData[{
  StyleBox["DSolve", "MR"],
  " can find solutions for most of the standard linear second-order ODEs that \
occur in applied mathematics."
}], "Text",
  CellTags->"b:1.1.1.4"],

Cell[TextData[{
  "Here is the solution for ",
  StyleBox["Airy\[CloseCurlyQuote]s equation",
    FontSlant->"Italic"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y''\)[x] - x*y[x] \[Equal] 0, \ y[x], x]\)], "Input",
  CellLabel->"In[100]:=",
  CellTags->"b:1.1.1.4"],

Cell[BoxData[
    \({{y[x] \[Rule] AiryAi[x]\ C[1] + AiryBi[x]\ C[2]}}\)], "Output",
  CellLabel->"Out[100]=",
  CellTags->"b:1.1.1.4"]
}, Open  ]],

Cell[TextData[{
  "Here is a plot that shows the oscillatory behavior of the Airy functions \
for large negative values of ",
  StyleBox["x", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.4"],

Cell[CellGroupData[{

Cell["\<\
Plot[{AiryAi[x], AiryBi[x]}, {x, -15, -12}, PlotStyle -> {{Red}, \
{Dashing[{0.03}],Blue}}];\
\>", "Input",
  CellLabel->"In[101]:=",
  CellTags->"b:1.1.1.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
4.78571 0.31746 0.310305 0.982923 [
[.18254 .2978 -15 -9 ]
[.18254 .2978 15 0 ]
[.34127 .2978 -9 -9 ]
[.34127 .2978 9 0 ]
[.5 .2978 -15 -9 ]
[.5 .2978 15 0 ]
[.65873 .2978 -9 -9 ]
[.65873 .2978 9 0 ]
[.81746 .2978 -15 -9 ]
[.81746 .2978 15 0 ]
[.97619 .2978 -9 -9 ]
[.97619 .2978 9 0 ]
[.01131 .01543 -24 -4.5 ]
[.01131 .01543 0 4.5 ]
[.01131 .11372 -24 -4.5 ]
[.01131 .11372 0 4.5 ]
[.01131 .21201 -24 -4.5 ]
[.01131 .21201 0 4.5 ]
[.01131 .4086 -18 -4.5 ]
[.01131 .4086 0 4.5 ]
[.01131 .50689 -18 -4.5 ]
[.01131 .50689 0 4.5 ]
[.01131 .60518 -18 -4.5 ]
[.01131 .60518 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .3103 m
.18254 .31655 L
s
[(-14.5)] .18254 .2978 0 1 Mshowa
.34127 .3103 m
.34127 .31655 L
s
[(-14)] .34127 .2978 0 1 Mshowa
.5 .3103 m
.5 .31655 L
s
[(-13.5)] .5 .2978 0 1 Mshowa
.65873 .3103 m
.65873 .31655 L
s
[(-13)] .65873 .2978 0 1 Mshowa
.81746 .3103 m
.81746 .31655 L
s
[(-12.5)] .81746 .2978 0 1 Mshowa
.97619 .3103 m
.97619 .31655 L
s
[(-12)] .97619 .2978 0 1 Mshowa
.125 Mabswid
.05556 .3103 m
.05556 .31405 L
s
.0873 .3103 m
.0873 .31405 L
s
.11905 .3103 m
.11905 .31405 L
s
.15079 .3103 m
.15079 .31405 L
s
.21429 .3103 m
.21429 .31405 L
s
.24603 .3103 m
.24603 .31405 L
s
.27778 .3103 m
.27778 .31405 L
s
.30952 .3103 m
.30952 .31405 L
s
.37302 .3103 m
.37302 .31405 L
s
.40476 .3103 m
.40476 .31405 L
s
.43651 .3103 m
.43651 .31405 L
s
.46825 .3103 m
.46825 .31405 L
s
.53175 .3103 m
.53175 .31405 L
s
.56349 .3103 m
.56349 .31405 L
s
.59524 .3103 m
.59524 .31405 L
s
.62698 .3103 m
.62698 .31405 L
s
.69048 .3103 m
.69048 .31405 L
s
.72222 .3103 m
.72222 .31405 L
s
.75397 .3103 m
.75397 .31405 L
s
.78571 .3103 m
.78571 .31405 L
s
.84921 .3103 m
.84921 .31405 L
s
.88095 .3103 m
.88095 .31405 L
s
.9127 .3103 m
.9127 .31405 L
s
.94444 .3103 m
.94444 .31405 L
s
.25 Mabswid
0 .3103 m
1 .3103 L
s
.02381 .01543 m
.03006 .01543 L
s
[(-0.3)] .01131 .01543 1 0 Mshowa
.02381 .11372 m
.03006 .11372 L
s
[(-0.2)] .01131 .11372 1 0 Mshowa
.02381 .21201 m
.03006 .21201 L
s
[(-0.1)] .01131 .21201 1 0 Mshowa
.02381 .4086 m
.03006 .4086 L
s
[(0.1)] .01131 .4086 1 0 Mshowa
.02381 .50689 m
.03006 .50689 L
s
[(0.2)] .01131 .50689 1 0 Mshowa
.02381 .60518 m
.03006 .60518 L
s
[(0.3)] .01131 .60518 1 0 Mshowa
.125 Mabswid
.02381 .03509 m
.02756 .03509 L
s
.02381 .05474 m
.02756 .05474 L
s
.02381 .0744 m
.02756 .0744 L
s
.02381 .09406 m
.02756 .09406 L
s
.02381 .13338 m
.02756 .13338 L
s
.02381 .15304 m
.02756 .15304 L
s
.02381 .1727 m
.02756 .1727 L
s
.02381 .19235 m
.02756 .19235 L
s
.02381 .23167 m
.02756 .23167 L
s
.02381 .25133 m
.02756 .25133 L
s
.02381 .27099 m
.02756 .27099 L
s
.02381 .29065 m
.02756 .29065 L
s
.02381 .32996 m
.02756 .32996 L
s
.02381 .34962 m
.02756 .34962 L
s
.02381 .36928 m
.02756 .36928 L
s
.02381 .38894 m
.02756 .38894 L
s
.02381 .42826 m
.02756 .42826 L
s
.02381 .44791 m
.02756 .44791 L
s
.02381 .46757 m
.02756 .46757 L
s
.02381 .48723 m
.02756 .48723 L
s
.02381 .52655 m
.02756 .52655 L
s
.02381 .54621 m
.02756 .54621 L
s
.02381 .56586 m
.02756 .56586 L
s
.02381 .58552 m
.02756 .58552 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .58377 m
.02846 .58725 L
.03279 .58969 L
.03527 .59074 L
.03754 .59147 L
.03879 .59178 L
.04015 .59205 L
.04143 .59223 L
.04262 .59234 L
.04376 .59238 L
.04498 .59237 L
.04614 .5923 L
.0472 .59219 L
.04843 .592 L
.04978 .59172 L
.05224 .59102 L
.0548 .59002 L
.05753 .58865 L
.06244 .58542 L
.06791 .58068 L
.07382 .57421 L
.08454 .55905 L
.10458 .51972 L
.12452 .46842 L
.14558 .4044 L
.18355 .27679 L
.22398 .14901 L
.24262 .10101 L
.26289 .06053 L
.27392 .04445 L
.27877 .03881 L
.28413 .03363 L
.28916 .02978 L
.29388 .02707 L
.29649 .02596 L
.29887 .02518 L
.30012 .02486 L
.30149 .02458 L
.30218 .02447 L
.30292 .02437 L
.30362 .0243 L
.30425 .02425 L
.30544 .0242 L
.30656 .0242 L
.30778 .02427 L
.3091 .0244 L
.30976 .0245 L
.31047 .02462 L
.31178 .02489 L
.31423 .02559 L
Mistroke
.31654 .02647 L
.31901 .02764 L
.32343 .03034 L
.32906 .03488 L
.33435 .04025 L
.34423 .05308 L
.36435 .08973 L
.38283 .13429 L
.42237 .25409 L
.4604 .38078 L
.48158 .447 L
.50087 .50025 L
.52112 .54597 L
.53983 .57686 L
.54911 .58766 L
.5538 .59192 L
.55896 .59567 L
.56412 .59842 L
.56702 .59952 L
.5684 .59993 L
.56968 .60024 L
.57091 .60049 L
.57202 .60066 L
.57326 .60079 L
.57458 .60087 L
.57585 .60089 L
.57657 .60087 L
.57723 .60083 L
.57845 .60072 L
.57973 .60054 L
.58095 .60032 L
.58227 .60001 L
.58468 .59927 L
.58702 .59835 L
.58919 .59731 L
.59411 .59429 L
.59935 .59009 L
.60805 .5809 L
.61767 .56763 L
.63699 .53182 L
.65784 .48127 L
.69895 .35684 L
.73854 .2273 L
.77662 .11766 L
.7962 .07367 L
.8071 .05398 L
.81715 .03916 L
.82737 .02756 L
.83276 .02291 L
.83847 .01911 L
Mistroke
.84085 .01786 L
.84342 .01676 L
.84584 .01593 L
.84806 .01536 L
.8494 .0151 L
.85064 .01492 L
.85136 .01484 L
.85201 .01478 L
.85276 .01474 L
.85347 .01472 L
.85476 .01472 L
.85594 .01478 L
.85724 .0149 L
.85789 .01498 L
.85861 .01509 L
.86113 .01562 L
.86255 .01602 L
.86386 .01646 L
.86883 .01867 L
.87334 .02144 L
.87814 .02518 L
.88808 .03546 L
.89906 .05063 L
.91842 .08648 L
.93928 .13636 L
.97619 .24489 L
Mfstroke
0 0 1 r
[ .03 ] 0 setdash
.02381 .24236 m
.06244 .37382 L
.08255 .43856 L
.10458 .50064 L
.11448 .5244 L
.12507 .54641 L
.13499 .56355 L
.14415 .57617 L
.14901 .58156 L
.15437 .58642 L
.15975 .59015 L
.1627 .5917 L
.16546 .59283 L
.1667 .59323 L
.16805 .59361 L
.16925 .59387 L
.17052 .59409 L
.17178 .59424 L
.17293 .59432 L
.17408 .59435 L
.17516 .59433 L
.17643 .59424 L
.17707 .59417 L
.17777 .59407 L
.17901 .59385 L
.18017 .59359 L
.18279 .5928 L
.1856 .59164 L
.19088 .5886 L
.19577 .58479 L
.20684 .57272 L
.21659 .55826 L
.22696 .53921 L
.26471 .44301 L
.30491 .31221 L
.3436 .18553 L
.36325 .12948 L
.38474 .07926 L
.39466 .06085 L
.40527 .0449 L
.41041 .03861 L
.41527 .03358 L
.41997 .02957 L
.42436 .02658 L
.42899 .02423 L
.43145 .02333 L
.43408 .02262 L
.4354 .02237 L
.4361 .02226 L
.43684 .02217 L
Mistroke
.43756 .0221 L
.4382 .02206 L
.43946 .02202 L
.44068 .02204 L
.442 .02213 L
.44324 .02227 L
.44438 .02246 L
.44659 .02297 L
.44866 .02361 L
.45336 .02569 L
.45793 .02854 L
.46283 .03247 L
.47303 .04353 L
.48411 .05977 L
.50424 .09961 L
.54508 .21239 L
.5844 .34145 L
.6222 .46002 L
.64321 .51529 L
.66245 .55574 L
.67224 .57194 L
.68134 .58411 L
.69083 .59371 L
.69584 .59747 L
.69844 .59906 L
.70119 .60046 L
.70374 .60152 L
.70509 .60198 L
.70654 .6024 L
.70787 .60271 L
.70908 .60294 L
.71031 .60312 L
.71146 .60324 L
.7121 .60328 L
.7128 .60331 L
.71354 .60332 L
.71423 .60331 L
.71546 .60325 L
.71615 .60319 L
.71679 .60313 L
.71813 .60293 L
.71961 .60264 L
.72258 .60181 L
.72522 .60079 L
.72763 .59965 L
.73302 .5963 L
.73802 .59226 L
.74274 .58763 L
.75245 .57567 L
.76273 .55956 L
Mistroke
.78118 .52256 L
.81903 .42058 L
.85934 .29124 L
.89813 .16995 L
.91786 .11674 L
.93938 .06911 L
.94862 .05262 L
.95847 .03797 L
.96777 .02703 L
.97619 .01963 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gR000`400?l00000o`00003oo`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`008P3oool00`000000oooo0?oo
o`3o0?oood@0oooo000R0?ooo`030000003oool0oooo0?l0ooooA03oool000P0oooo100000050?oo
o`8000001@3oool3000000L0oooo00<000000?ooo`3oool0o`3ooom40?ooo`001`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?oo
o`0000001P3oool00`000000oooo0?ooo`3o0?oood@0oooo00070?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0
oooo3P3oool30?l003<0oooo000500000080oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00@0oooo0`00003o0?ooo``0oooo0`3o0000103oool0o`00
0?l0003o000a0?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo
0P0000070?ooo`030000003oool0oooo0?l0oooo2P3oool20?l000L0oooo0P3o000R0?ooo`030000
o`3oool0oooo00X0oooo00070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0880oooo00<0003o0?ooo`3oool0PP3o
ool20?l000/0oooo00<0o`000?ooo`3oool07P3oool00`000?l0oooo0?ooo`0;0?ooo`001`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo0000
00060?ooo`030000003oool0oooo05H0oooo203o000S0?ooo`80003oP`3oool00`3o0000oooo0?oo
o`0<0?ooo`80o`007@3oool00`000?l0oooo0?ooo`0<0?ooo`00203oool4000000`0oooo0`000007
0?ooo`030000003oool0oooo05@0oooo0`3o00070?ooo`030?l0003oool0oooo01h0oooo0P000?n4
0?ooo`030?l0003oool0oooo00l0oooo00<0o`000?ooo`3oool06@3oool00`000?l0oooo0?ooo`0=
0?ooo`008P3oool00`000000oooo0?ooo`1C0?ooo`030?l0003oool0oooo00T0oooo00<0o`000?oo
o`3oool0703oool00`000?l0oooo0?ooo`0<0?ooo`030000o`3oool0oooo07@0oooo00<0o`000?oo
o`3oool04@3oool00`3o0000oooo0?ooo`0G0?ooo`030000o`3oool0oooo00h0oooo000R0?ooo`80
0000D`3oool00`3o0000oooo0?ooo`0;0?ooo`80o`00703oool00`000?l0oooo0?ooo`0=0?ooo`03
0000o`3oool0oooo0780oooo00<0o`000?ooo`3oool04`3oool00`3o0000oooo0?ooo`0W0?ooo`00
8P3oool00`000000oooo0?ooo`1A0?ooo`030?l0003oool0oooo00h0oooo00<0o`000?ooo`3oool0
5`3oool20000oa40oooo00<0003o0?ooo`3oool0L@3oool00`3o0000oooo0?ooo`0D0?ooo`030?l0
003oool0oooo02H0oooo000R0?ooo`030000003oool0oooo0500oooo00<0o`000?ooo`3oool0403o
ool00`3o0000oooo0?ooo`0E0?ooo`030000o`3oool0oooo0180oooo00<0003o0?ooo`3oool0K`3o
ool00`3o0000oooo0?ooo`0F0?ooo`030?l0003oool0oooo02D0oooo000R0?ooo`030000003oool0
oooo04l0oooo00<0o`000?ooo`3oool04P3oool00`3o0000oooo0?ooo`0D0?ooo`030000o`3oool0
oooo01<0oooo00<0003o0?ooo`3oool0K@3oool00`3o0000oooo0?ooo`0G0?ooo`030?l0003oool0
oooo02D0oooo000R0?ooo`030000003oool0oooo04h0oooo00<0o`000?ooo`3oool04`3oool00`3o
0000oooo0?ooo`0Z0?ooo`030000o`3oool0oooo06`0oooo00<0o`000?ooo`3oool06@3oool00`3o
0000oooo0?ooo`0T0?ooo`008P3oool00`000000oooo0?ooo`1>0?ooo`030?l0003oool0oooo01@0
oooo00<0o`000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`1[0?ooo`030?l0003oool0oooo01X0
oooo00<0o`000?ooo`3oool08`3oool00280oooo00<000000?ooo`3oool0C@3oool00`3o0000oooo
0?ooo`0F0?ooo`030?l0003oool0oooo02T0oooo00<0003o0?ooo`3oool0JP3oool00`3o0000oooo
0?ooo`0K0?ooo`030?l0003oool0oooo02<0oooo000R0?ooo`800000C@3oool00`3o0000oooo0?oo
o`0H0?ooo`030?l0003oool0oooo02T0oooo00<0003o0?ooo`3oool0J03oool00`3o0000oooo0?oo
o`0M0?ooo`030?l0003oool0oooo00`0oooo00<0003o0?ooo`3oool04`3oool00280oooo00<00000
0?ooo`3oool0C03oool00`3o0000oooo0?ooo`0H0?ooo`030?l0003oool0oooo09@0oooo00<0o`00
0?ooo`3oool07@3oool00`3o0000oooo0?ooo`0;0?ooo`030000o`3oool0oooo01@0oooo000R0?oo
o`030000003oool0oooo04/0oooo00<0o`000?ooo`3oool06P3oool00`3o0000oooo0?ooo`2B0?oo
o`030?l0003oool0oooo01l0oooo00<0o`000?ooo`3oool02@3oool00`000?l0oooo0?ooo`0E0?oo
o`008P3oool00`000000oooo0?ooo`1;0?ooo`030?l0003oool0oooo01X0oooo00<0o`000?ooo`3o
ool0TP3oool00`3o0000oooo0?ooo`0O0?ooo`030?l0003oool0oooo00T0oooo00<0003o0?ooo`3o
ool05@3oool00280oooo00<000000?ooo`3oool0BP3oool00`3o0000oooo0?ooo`0L0?ooo`030?l0
003oool0oooo00T0oooo00<0003o0?ooo`3oool0Q03oool00`3o0000oooo0?ooo`0Q0?ooo`030?l0
003oool0oooo00L0oooo00<0003o0?ooo`3oool05P3oool00280oooo00<000000?ooo`3oool0BP3o
ool00`3o0000oooo0?ooo`0L0?ooo`030?l0003oool0oooo00P0oooo00<0003o0?ooo`3oool0Q@3o
ool00`3o0000oooo0?ooo`0Q0?ooo`030?l0003oool0oooo00L0oooo00<0003o0?ooo`3oool05P3o
ool00280oooo0P00001:0?ooo`030?l0003oool0oooo01h0oooo00<0o`000?ooo`3oool01`3oool0
0`000?l0oooo0?ooo`240?ooo`030?l0003oool0oooo02<0oooo00<0o`000?ooo`3oool01@3oool0
0`000?l0oooo0?ooo`0G0?ooo`008P3oool00`000000oooo0?ooo`190?ooo`030?l0003oool0oooo
01l0oooo00<0o`000?ooo`3oool01@3oool00`000?l0oooo0?ooo`250?ooo`030?l0003oool0oooo
02<0oooo00<0o`000?ooo`3oool01@3oool00`000?l0oooo0?ooo`0G0?ooo`008P3oool00`000000
oooo0?ooo`180?ooo`030?l0003oool0oooo0200oooo00<0o`000?ooo`3oool01@3oool00`000?l0
oooo0?ooo`240?ooo`030?l0003oool0oooo02D0oooo00<0o`000?ooo`3oool00`3oool00`000?l0
oooo0?ooo`0H0?ooo`008P3oool00`000000oooo0?ooo`180?ooo`030?l0003oool0oooo0240oooo
00<0o`000?ooo`3oool0103oool00`000?l0oooo0?ooo`0R0?ooo`030000o`3oool0oooo05l0oooo
00<0o`000?ooo`3oool09@3oool00`3o0000oooo0?ooo`030?ooo`030000o`3oool0oooo01P0oooo
000R0?ooo`030000003oool0oooo04L0oooo00<0o`000?ooo`3oool08P3oool00`3o0000oooo0?oo
o`030?ooo`030000o`3oool0oooo02@0oooo00<0003o0?ooo`3oool0G@3oool00`3o0000oooo0?oo
o`0W0?ooo`030?l0003oool0oooo01d0oooo000R0?ooo`030000003oool0oooo04L0oooo00<0o`00
0?ooo`3oool08`3oool00`3o0000oooo0?ooo`020?ooo`030000o`3oool0oooo02@0oooo00<0003o
0?ooo`3oool0G@3oool00`3o0000oooo0?ooo`0W0?ooo`030?l0003oool0oooo01d0oooo000R0?oo
o`030000003oool0oooo04H0oooo00<0o`000?ooo`3oool0903oool01@3o0000oooo0?ooo`3oool0
003o02P0oooo00<0003o0?ooo`3oool0F`3oool00`3o0000oooo0?ooo`0Y0?ooo`030?l0003oool0
oooo01`0oooo000R0?ooo`800000A`3oool00`3o0000oooo0?ooo`0U0?ooo`040?l0003oool0oooo
0000obP0oooo00<0003o0?ooo`3oool0F`3oool00`3o0000oooo0?ooo`0Y0?ooo`030?l0003oool0
oooo01`0oooo000R0?ooo`030000003oool0oooo04D0oooo00<0o`000?ooo`3oool09P3oool00`3o
0000oooo0?ooo`0Z0?ooo`030000o`3oool0oooo05X0oooo00<0o`000?ooo`3oool0:P3oool00`3o
0000oooo0?ooo`0K0?ooo`008P3oool00`000000oooo0?ooo`150?ooo`030?l0003oool0oooo02L0
oooo00<0o`000?ooo`3oool0:@3oool00`000?l0oooo0?ooo`1I0?ooo`030?l0003oool0oooo02/0
oooo00<0o`000?ooo`3oool06`3oool000P0oooo100000050?ooo`800000103oool5000000H0oooo
00<000000?ooo`3oool0A@3oool00`3o0000oooo0?ooo`0W0?ooo`030?l0003oool0oooo02T0oooo
00<0003o0?ooo`3oool0F@3oool00`3o0000oooo0?ooo`0[0?ooo`030?l0003oool0oooo01/0oooo
00070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool2000000@0oooo00D0
00000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo04@0oooo00<0o`000?ooo`3oool0
:03oool00`3o0000oooo0?ooo`0Z0?ooo`030000o`3oool0oooo05L0oooo00<0o`000?ooo`3oool0
;@3oool00`3o0000oooo0?ooo`0J0?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`140?ooo`030?l0003o
ool0oooo02T0oooo00<0o`000?ooo`3oool0:@3oool00`000?l0oooo0?ooo`1G0?ooo`030?l0003o
ool0oooo02/0oooo00<0003o0?ooo`3o0000703oool000D000000P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01P3oool3000004<0oooo00<0o`00
0?ooo`3oool0:P3oool00`3o0000oooo0?ooo`220?ooo`030?l0003oool0oooo02/0oooo00D0003o
0?ooo`3oool0oooo0?l0000K0?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`130?ooo`030?l0003oool0
oooo02/0oooo00<0o`000?ooo`3oool0P@3oool00`3o0000oooo0?ooo`0[0?ooo`050000o`3oool0
oooo0?ooo`3o00006`3oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0@`3oool00`3o0000oooo0?ooo`0[
0?ooo`030?l0003oool0oooo0840oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo0?ooo`02
0?ooo`030?l0003oool0oooo01P0oooo00070?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0203oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0@P3oool0
0`3o0000oooo0?ooo`0X0?ooo`050000o`3oool0oooo0?ooo`3o0000PP3oool00`3o0000oooo0?oo
o`0[0?ooo`030000o`3oool0oooo00<0oooo00<0o`000?ooo`3oool0603oool000P0oooo1000000<
0?ooo`<000001`3oool00`000000oooo0?ooo`120?ooo`030?l0003oool0oooo02L0oooo00<0003o
0?ooo`3oool00`3oool00`3o0000oooo0?ooo`1o0?ooo`030?l0003oool0oooo02/0oooo00<0003o
0?ooo`3oool00`3oool00`3o0000oooo0?ooo`0H0?ooo`008P3oool00`000000oooo0?ooo`120?oo
o`030?l0003oool0oooo02L0oooo00<0003o0?ooo`3oool00`3oool00`3o0000oooo0?ooo`1o0?oo
o`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0103oool00`3o0000oooo0?ooo`0G0?oo
o`008P3oool00`000000oooo0?ooo`110?ooo`030?l0003oool0oooo02P0oooo00<0003o0?ooo`3o
ool0103oool00`3o0000oooo0?ooo`1m0?ooo`030?l0003oool0oooo02`0oooo00<0003o0?ooo`3o
ool0103oool00`3o0000oooo0?ooo`0G0?ooo`008P3oool200000480oooo00<0o`000?ooo`3oool0
9`3oool00`000?l0oooo0?ooo`050?ooo`030?l0003oool0oooo07d0oooo00<0o`000?ooo`3oool0
:`3oool00`000?l0oooo0?ooo`060?ooo`030?l0003oool0oooo01H0oooo000R0?ooo`030000003o
ool0oooo0400oooo00<0o`000?ooo`3oool0:03oool00`000?l0oooo0?ooo`050?ooo`030?l0003o
ool0oooo02T0oooo00<0003o0?ooo`3oool0D03oool00`3o0000oooo0?ooo`0/0?ooo`030000o`3o
ool0oooo00H0oooo00<0o`000?ooo`3oool05P3oool00280oooo00<000000?ooo`3oool0@03oool0
0`3o0000oooo0?ooo`0X0?ooo`030000o`3oool0oooo00H0oooo00<0o`000?ooo`3oool0:03oool0
0`000?l0oooo0?ooo`1@0?ooo`030?l0003oool0oooo03D0oooo00<0o`000?ooo`3oool05P3oool0
0280oooo00<000000?ooo`3oool0@03oool00`3o0000oooo0?ooo`0X0?ooo`030000o`3oool0oooo
00H0oooo00<0o`000?ooo`3oool0:@3oool00`000?l0oooo0?ooo`1?0?ooo`030?l0003oool0oooo
03H0oooo00<0o`000?ooo`3oool05@3oool00280oooo00<000000?ooo`3oool0?`3oool00`3o0000
oooo0?ooo`0X0?ooo`030000o`3oool0oooo00L0oooo00<0o`000?ooo`3oool0:@3oool00`000?l0
oooo0?ooo`1>0?ooo`030?l0003oool0oooo03L0oooo00<0o`000?ooo`3oool05@3oool00280oooo
00<000000?ooo`3oool0?`3oool00`3o0000oooo0?ooo`0X0?ooo`030000o`3oool0oooo00P0oooo
00<0o`000?ooo`3oool0:@3oool00`000?l0oooo0?ooo`1=0?ooo`030?l0003oool0oooo03L0oooo
00<0o`000?ooo`3oool05@3oool00280oooo0P0000100?ooo`030?l0003oool0oooo02P0oooo00<0
003o0?ooo`3oool0203oool00`3o0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo04d0oooo00<0
o`000?ooo`3oool0>03oool00`3o0000oooo0?ooo`0D0?ooo`008P3oool00`000000oooo0?ooo`0n
0?ooo`030?l0003oool0oooo03@0oooo00<0o`000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`1;
0?ooo`030?l0003oool0oooo03T0oooo00<0o`000?ooo`3oool0503oool00280oooo00<000000?oo
o`3oool0?P3oool00`3o0000oooo0?ooo`0e0?ooo`030?l0003oool0oooo02T0oooo00<0003o0?oo
o`3oool0B`3oool00`3o0000oooo0?ooo`0i0?ooo`030?l0003oool0oooo01@0oooo000R0?ooo`03
0000003oool0oooo03h0oooo00<0o`000?ooo`3oool0=@3oool00`3o0000oooo0?ooo`0Z0?ooo`03
0000o`3oool0oooo04X0oooo00<0o`000?ooo`3oool0>P3oool00`3o0000oooo0?ooo`0C0?ooo`00
8P3oool00`000000oooo0?ooo`0m0?ooo`030?l0003oool0oooo03H0oooo00<0o`000?ooo`3oool0
:P3oool00`000?l0oooo0?ooo`190?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0
3@3oool00`3o0000oooo0?ooo`0C0?ooo`008P3oool00`000000oooo0?ooo`0m0?ooo`030?l0003o
ool0oooo03L0oooo00<0o`000?ooo`3oool0M@3oool00`3o0000oooo0?ooo`0[0?ooo`030000o`3o
ool0oooo00d0oooo00<0o`000?ooo`3oool04`3oool00280oooo0P00000n0?ooo`030?l0003oool0
oooo03L0oooo00<0o`000?ooo`3oool0M03oool00`3o0000oooo0?ooo`0/0?ooo`030000o`3oool0
oooo00h0oooo00<0o`000?ooo`3oool04P3oool00280oooo00<000000?ooo`3oool0?03oool00`3o
0000oooo0?ooo`0h0?ooo`030?l0003oool0oooo07@0oooo00<0o`000?ooo`3oool0;03oool00`00
0?l0oooo0?ooo`0>0?ooo`030?l0003oool0oooo0180oooo000R0?ooo`030000003oool0oooo03`0
oooo00<0o`000?ooo`3oool0>@3oool00`3o0000oooo0?ooo`1c0?ooo`030?l0003oool0oooo02/0
oooo00<0003o0?ooo`3oool03`3oool00`3o0000oooo0?ooo`0B0?ooo`008P3oool00`000000oooo
0?ooo`0l0?ooo`030?l0003oool0oooo02P0oooo00<0003o0?ooo`3oool03P3oool00`3o0000oooo
0?ooo`1b0?ooo`030?l0003oool0oooo02`0oooo00<0003o0?ooo`3oool0403oool00`3o0000oooo
0?ooo`0A0?ooo`008P3oool00`000000oooo0?ooo`0k0?ooo`030?l0003oool0oooo02P0oooo00<0
003o0?ooo`3oool03`3oool00`3o0000oooo0?ooo`1b0?ooo`030?l0003oool0oooo02/0oooo00<0
003o0?ooo`3oool04@3oool00`3o0000oooo0?ooo`0A0?ooo`008P3oool00`000000oooo0?ooo`0k
0?ooo`030?l0003oool0oooo02P0oooo00<0003o0?ooo`3oool0403oool00`3o0000oooo0?ooo`1a
0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool04@3oool00`3o0000oooo0?ooo`0A
0?ooo`008P3oool00`000000oooo0?ooo`0k0?ooo`030?l0003oool0oooo02P0oooo00<0003o0?oo
o`3oool0403oool00`3o0000oooo0?ooo`1`0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?oo
o`3oool04`3oool00`3o0000oooo0?ooo`0@0?ooo`008P3oool2000003/0oooo00<0o`000?ooo`3o
ool0:03oool00`000?l0oooo0?ooo`0A0?ooo`030?l0003oool0oooo02X0oooo00<0003o0?ooo`3o
ool0@`3oool00`3o0000oooo0?ooo`0[0?ooo`030000o`3oool0oooo01<0oooo00<0o`000?ooo`3o
ool0403oool00280oooo00<000000?ooo`3oool0>P3oool00`3o0000oooo0?ooo`0X0?ooo`030000
o`3oool0oooo0180oooo00<0o`000?ooo`3oool0:@3oool00`000?l0oooo0?ooo`130?ooo`030?l0
003oool0oooo0480oooo00<0o`000?ooo`3oool03`3oool00280oooo00<000000?ooo`3oool0>P3o
ool00`3o0000oooo0?ooo`0X0?ooo`030000o`3oool0oooo0180oooo00<0o`000?ooo`3oool0:P3o
ool00`000?l0oooo0?ooo`110?ooo`030?l0003oool0oooo04<0oooo00<0o`000?ooo`3oool03`3o
ool000P0oooo100000050?ooo`8000001@3oool5000000D0oooo00<000000?ooo`3oool0>@3oool0
0`3o0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo0180oooo00<0o`000?ooo`3oool0:P3oool0
0`000?l0oooo0?ooo`110?ooo`030?l0003oool0oooo04<0oooo00<0o`000?ooo`3oool03`3oool0
00L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`8000001`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo03T0oooo00<0o`000?ooo`3oool0:03oool00`00
0?l0oooo0?ooo`0D0?ooo`030?l0003oool0oooo02T0oooo00<0003o0?ooo`3oool0@@3oool00`3o
0000oooo0?ooo`140?ooo`030?l0003oool0oooo00h0oooo00070?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03T0
oooo00<0o`000?ooo`3oool0:03oool00`000?l0oooo0?ooo`0D0?ooo`030?l0003oool0oooo02T0
oooo00<0003o0?ooo`3oool0@03oool00`3o0000oooo0?ooo`150?ooo`030?l0003oool0oooo00h0
oooo000500000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00D0oooo0`00000h0?ooo`030?l0003oool0oooo0400oooo00<0o`000?ooo`3oool0
:P3oool00`000?l0oooo0?ooo`0o0?ooo`030?l0003oool0oooo04D0oooo00<0o`000?ooo`3oool0
3P3oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0>03oool00`3o0000oooo0?ooo`110?ooo`030?l0003o
ool0oooo02T0oooo00<0003o0?ooo`3oool0?P3oool00`3o0000oooo0?ooo`170?ooo`030?l0003o
ool0oooo00d0oooo00070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo03P0oooo00<0o`000?ooo`3oool0@@3oool0
0`3o0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo03h0oooo00<0o`000?ooo`3oool0A`3oool0
0`3o0000oooo0?ooo`0=0?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00T0oooo0`0000070?ooo`030000003oool0oooo03L0oooo00<0o`000?ooo`3oool0@P3oool00`3o
0000oooo0?ooo`0Z0?ooo`030000o`3oool0oooo03d0oooo00<0o`000?ooo`3oool0A`3oool00`3o
0000oooo0?ooo`0=0?ooo`00203oool4000000h0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0g0?ooo`030?l0003oool0oooo04<0oooo00<0o`000?ooo`3oool0:@3oool00`000?l0
oooo0?ooo`0l0?ooo`030?l0003oool0oooo02`0oooo00<0003o0?ooo`3oool06P3oool00`3o0000
oooo0?ooo`0<0?ooo`008P3oool00`000000oooo0?ooo`0g0?ooo`030?l0003oool0oooo04<0oooo
00<0o`000?ooo`3oool0J03oool00`3o0000oooo0?ooo`0/0?ooo`030000o`3oool0oooo01X0oooo
00<0o`000?ooo`3oool0303oool00280oooo00<000000?ooo`3oool0=P3oool00`3o0000oooo0?oo
o`140?ooo`030?l0003oool0oooo06P0oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo0?oo
o`0K0?ooo`030?l0003oool0oooo00`0oooo000R0?ooo`800000=`3oool00`3o0000oooo0?ooo`15
0?ooo`030?l0003oool0oooo06H0oooo00<0o`000?ooo`3oool0;03oool00`000?l0oooo0?ooo`0L
0?ooo`030?l0003oool0oooo00/0oooo000R0?ooo`030000003oool0oooo03H0oooo00<0o`000?oo
o`3oool0A@3oool00`3o0000oooo0?ooo`1V0?ooo`030?l0003oool0oooo02`0oooo00<0003o0?oo
o`3oool0703oool00`3o0000oooo0?ooo`0;0?ooo`008P3oool00`000000oooo0?ooo`0e0?ooo`03
0?l0003oool0oooo02T0oooo00<0003o0?ooo`3oool06P3oool00`3o0000oooo0?ooo`1V0?ooo`03
0?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool07@3oool00`3o0000oooo0?ooo`0;0?ooo`00
8P3oool00`000?l0oooo0?ooo`0e0?ooo`030?l0003oool0oooo02T0oooo00<0003o0?ooo`3oool0
6`3oool00`3o0000oooo0?ooo`1T0?ooo`030?l0003oool0oooo02`0oooo00<0003o0?ooo`3oool0
7P3oool00`3o0000oooo0?ooo`0:0?ooo`008P3oool00`000?l0oooo0?ooo`0e0?ooo`030?l0003o
ool0oooo02P0oooo00<0003o0?ooo`3oool0703oool00`3o0000oooo0?ooo`1T0?ooo`030?l0003o
ool0oooo02`0oooo00<0003o0?ooo`3oool07P3oool00`3o0000oooo0?ooo`0:0?ooo`008P3oool0
0`000?l0oooo0?ooo`0d0?ooo`030?l0003oool0oooo02T0oooo00<0003o0?ooo`3oool0703oool0
0`3o0000oooo0?ooo`1T0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0;03oool0
0280oooo00<000000000o`3oool0=03oool00`3o0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo
01d0oooo00<0o`000?ooo`3oool0:@3oool00`000?l0oooo0?ooo`0g0?ooo`030?l0003oool0oooo
02/0oooo00<0003o0?ooo`3oool0;03oool00280oooo00<000000000o`3oool0=03oool00`3o0000
oooo0?ooo`0X0?ooo`030000o`3oool0oooo01h0oooo00<0o`000?ooo`3oool0:@3oool00`000?l0
oooo0?ooo`0f0?ooo`030?l0003oool0oooo05/0oooo000R0?ooo`030000003oool0oooo03<0oooo
00<0o`000?ooo`3oool0:@3oool00`000?l0oooo0?ooo`0N0?ooo`030?l0003oool0oooo02X0oooo
00<0003o0?ooo`3oool0=@3oool00`3o0000oooo0?ooo`1K0?ooo`008P3oool00`000000oooo0?oo
o`0c0?ooo`030?l0003oool0oooo02T0oooo00<0003o0?ooo`3oool07`3oool00`3o0000oooo0?oo
o`0Y0?ooo`030000o`3oool0oooo03D0oooo00<0o`000?ooo`3oool0F`3oool00280oooo00<00000
0?ooo`3oool0<`3oool00`3o0000oooo0?ooo`0X0?ooo`030000o`3oool0oooo0200oooo00<0o`00
0?ooo`3oool0:@3oool00`000?l0oooo0?ooo`0d0?ooo`030?l0003oool0oooo05`0oooo000R0?oo
o`030000003oool0oooo02L0oooo1@0000050?ooo`030000003o0000000000@0oooo0P0000050?oo
o`@000006`3oool00`000?l0oooo0?ooo`020?ooo`D000001@3oool300000140oooo00<0o`000?oo
o`3oool02`3oool5000000<0oooo0`0000060?ooo`8000001@3oool400000080oooo00<0003o0?oo
o`3oool0703oool5000000<0oooo0`00000=0?ooo`030?l0003oool0oooo0140oooo1@0000020?oo
o`D000001@3oool2000000D0oooo1000000P0?ooo`D000000P3oool5000000<0oooo000R0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool01P3oool00`3o0000oooo0?ooo`030?ooo`80
0000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0@0?ooo`030?l0003oool0oooo00d0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo0P0000040?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool0003o7`3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`000000303oool00`3o0000oooo0?ooo`0C0?ooo`030000003oool0oooo0080oooo00D0
00000?ooo`3oool0oooo000000050?ooo`800000103oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0
oooo000R0?ooo`800000:P3oool00`000000oooo0?ooo`060?ooo`030?l0003oool0oooo00h0oooo
00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0140oooo
00<0o`000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00h0oooo
00@000000?ooo`3oool0003o7`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0
oooo00<0o`000?ooo`3oool0503oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0
oooo000R0?ooo`030000003oool0oooo01h0oooo1P0000050?ooo`030000003oool0oooo0080oooo
0`0000000`3o000000000000000?0?ooo`030000003oool0oooo01@0oooo1P0000050?ooo`030000
003oool0oooo0080oooo1P00000B0?ooo`040?l0003oool0oooo0?ooo`H000001@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00h0oooo00@000000?ooo`3oool0003o503oool60000
00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`030?l0003oool0oooo
00T0oooo1P0000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0D0?ooo`H000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo000R0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool00`3oool010000000
oooo0?l00000000<0?ooo`@000008P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000001<0oooo00<0o`000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`8000003@3oool4
000000@0oooo00<0003o0?ooo`3oool0703oool00`000000oooo0?ooo`040?ooo`800000303oool0
0`3o0000oooo0?ooo`0D0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool4
00000280oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`008P3oool01000
0000oooo0?ooo`000?lX0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3o00000000303o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000
503oool00`3o0000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`050?ooo`030000o`3oool0oooo01`0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`090?ooo`030?l0003oool0oooo01@0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0:0?ooo`03000000000?l0oooo02<0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`010?ooo`008P3oool010000000oooo0?ooo`000?lV0?ooo`<00000
1P3oool00`3o0000oooo0000000<0?ooo`030000003oool0oooo0240oooo0`0000060?ooo`030000
003oool0000001@0oooo00<0o`000?ooo`3oool02@3oool3000000@0oooo00D000000?ooo`3oool0
oooo0000000<0?ooo`030000003oool0oooo0280oooo0`0000040?ooo`050000003oool0oooo0?oo
o`0000002P3oool00`3o0000oooo0?ooo`0C0?ooo`<00000103oool01@000000oooo0?ooo`3oool0
000000`0oooo00<000000000o`3oool08@3oool3000000@0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`008P3oool01@000000oooo0?ooo`3oool0003o02L0oooo00<000000?ooo`3oool0103o
ool00`3o000000000000000<0?ooo`D000008@3oool00`000000oooo0?ooo`050?ooo`800000503o
ool00`3o0000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo0`00000=0?ooo`D000008P3o
ool00`000000oooo0?ooo`030?ooo`<000002`3oool00`3o0000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00<0oooo0`00000=0?ooo`030000o`0000000000008000008@3oool00`000000oooo0?oo
o`030?ooo`<00000103oool00280oooo0P0000020?ooo`030000o`3oool0oooo02`0oooo00<0o`00
0?ooo`3oool0D03oool00`3o0000oooo0?ooo`1L0?ooo`030?l0003oool0oooo02/0oooo00<0003o
0?ooo`3oool0<03oool00280oooo00D000000?ooo`3oool0oooo0000o`0^0?ooo`030?l0003oool0
oooo0540oooo00<0o`000?ooo`3oool0FP3oool00`3o0000oooo0?ooo`0/0?ooo`030000o`3oool0
oooo0300oooo000R0?ooo`050000003oool0oooo0?ooo`000?l0;@3oool00`3o0000oooo0?ooo`0Y
0?ooo`030000o`3oool0oooo02H0oooo00<0o`000?ooo`3oool0FP3oool00`3o0000oooo0?ooo`0/
0?ooo`030000o`3oool0oooo0300oooo000R0?ooo`030000003oool0oooo0080oooo00<0003o0?oo
o`3oool0:P3oool00`3o0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo02H0oooo00<0o`000?oo
o`3oool0FP3oool00`3o0000oooo0?ooo`0[0?ooo`030000o`3oool0oooo0340oooo000R0?ooo`03
0000003oool0oooo0080oooo00<0003o0?ooo`3oool0:P3oool00`3o0000oooo0?ooo`0X0?ooo`03
0000o`3oool0oooo02P0oooo00<0o`000?ooo`3oool0F03oool00`3o0000oooo0?ooo`0/0?ooo`03
0000o`3oool0oooo0340oooo000R0?ooo`030000003oool0oooo0080oooo00<0003o0?ooo`3oool0
:@3oool00`3o0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo02P0oooo00<0o`000?ooo`3oool0
F03oool00`3o0000oooo0?ooo`0[0?ooo`030000o`3oool0oooo0380oooo000R0?ooo`030000003o
ool0oooo00<0oooo00<0003o0?ooo`3oool0:03oool00`3o0000oooo0?ooo`0X0?ooo`030000o`3o
ool0oooo02T0oooo00<0o`000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`0[0?ooo`030?l0003o
ool0oooo02/0oooo00<0003o0?ooo`3oool0<P3oool001X0oooo3P0000000`000?l000000000000X
000000030?l000000000000002P0000000<0003o000000000000:@0000000`3o000000000000000Z
000000030000o`000000000002/0000000<0o`00000000000000G00000040?ooo`008P3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00@0o`000?ooo`3oool000002@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000?l0oooo000000090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`030000003o0000oooo00L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool0
0`000?l0oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00D0o`000?ooo`3oool0oooo0000
00090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00280oooo00<00000
0?ooo`3oool0;@3oool01@3o0000oooo0?ooo`3oool0000002H0oooo00<0003o0?ooo`3oool02P3o
ool00`000000oooo0?ooo`0N0?ooo`030?l0003oool0oooo0100oooo00<000000?ooo`3oool05`3o
ool00`000?l0oooo0?ooo`0H0?ooo`030000003oool0oooo00h0oooo00<0o`000?ooo`3oool0803o
ool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo00X0oooo000R0?ooo`030000003oool0
oooo02d0oooo00<0o`000?ooo`3oool0:03oool00`000?l0oooo0?ooo`0[0?ooo`030?l0003oool0
oooo02X0oooo00<0003o0?ooo`3oool0:@3oool00`3o0000oooo0?ooo`1Q0?ooo`008P3oool00`00
0000oooo0?ooo`0]0?ooo`030?l0003oool0oooo02P0oooo00<0003o0?ooo`3oool0;03oool00`3o
0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo02P0oooo00<0o`000?ooo`3oool0HP3oool00280
oooo00<000000?ooo`3oool0;03oool00`3o0000oooo0?ooo`1H0?ooo`030?l0003oool0oooo02X0
oooo00<0003o0?ooo`3oool09`3oool00`3o0000oooo0?ooo`1R0?ooo`008P3oool2000002d0oooo
00<0o`000?ooo`3oool0F03oool00`3o0000oooo0?ooo`0Z0?ooo`030000o`3oool0oooo02L0oooo
00<0o`000?ooo`3oool0HP3oool00280oooo00<000000?ooo`3oool0;03oool00`3o0000oooo0?oo
o`1H0?ooo`030?l0003oool0oooo02X0oooo00<0003o0?ooo`3oool09P3oool00`3o0000oooo0?oo
o`1S0?ooo`008P3oool00`000000oooo0?ooo`0/0?ooo`030?l0003oool0oooo05T0oooo00<0o`00
0?ooo`3oool0:P3oool00`000?l0oooo0?ooo`0U0?ooo`030?l0003oool0oooo02/0oooo00<0003o
0?ooo`3oool0=@3oool00280oooo00<000000?ooo`3oool01P3oool00`000?l0oooo0?ooo`0R0?oo
o`030?l0003oool0oooo05X0oooo00<0o`000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`0U0?oo
o`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0=@3oool00280oooo00<000000?ooo`3o
ool01P3oool00`000?l0oooo0?ooo`0R0?ooo`030?l0003oool0oooo05X0oooo00<0o`000?ooo`3o
ool0DP3oool00`3o0000oooo0?ooo`0Z0?ooo`030000o`3oool0oooo03H0oooo000R0?ooo`030000
003oool0oooo00L0oooo00<0003o0?ooo`3oool08@3oool00`3o0000oooo0?ooo`1K0?ooo`030?l0
003oool0oooo0500oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo0?ooo`0f0?ooo`008P3o
ool00`000000oooo0?ooo`070?ooo`030000o`3oool0oooo0200oooo00<0o`000?ooo`3oool0G03o
ool00`3o0000oooo0?ooo`1@0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0=P3o
ool00280oooo0P0000080?ooo`030000o`3oool0oooo0200oooo00<0o`000?ooo`3oool0G03oool0
0`3o0000oooo0?ooo`1@0?ooo`030?l0003oool0oooo02X0oooo00<0003o0?ooo`3oool0=`3oool0
0280oooo00<000000?ooo`3oool01`3oool00`000?l0oooo0?ooo`0P0?ooo`030?l0003oool0oooo
02P0oooo00<0003o0?ooo`3oool0<@3oool00`3o0000oooo0?ooo`1?0?ooo`030?l0003oool0oooo
02/0oooo00<0003o0?ooo`3oool0=`3oool00280oooo00<000000?ooo`3oool0203oool00`000?l0
oooo0?ooo`0O0?ooo`030?l0003oool0oooo02P0oooo00<0003o0?ooo`3oool0<P3oool00`3o0000
oooo0?ooo`1>0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0=`3oool00280oooo
00<000000?ooo`3oool0203oool00`000?l0oooo0?ooo`0N0?ooo`030?l0003oool0oooo02P0oooo
00<0003o0?ooo`3oool0<`3oool00`3o0000oooo0?ooo`1>0?ooo`030?l0003oool0oooo02/0oooo
00<0003o0?ooo`3oool0=`3oool00280oooo00<000000?ooo`3oool0203oool00`000?l0oooo0?oo
o`0N0?ooo`030?l0003oool0oooo02P0oooo00<0003o0?ooo`3oool0<`3oool00`3o0000oooo0?oo
o`1=0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0>03oool00280oooo00<00000
0?ooo`3oool02@3oool00`000?l0oooo0?ooo`0M0?ooo`030?l0003oool0oooo02P0oooo00<0003o
0?ooo`3oool0=03oool00`3o0000oooo0?ooo`0Z0?ooo`030000o`3oool0oooo01l0oooo00<0o`00
0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`0h0?ooo`008P3oool2000000X0oooo00<0003o0?oo
o`3oool0703oool00`3o0000oooo0?ooo`0X0?ooo`030000o`3oool0oooo03D0oooo00<0o`000?oo
o`3oool0:P3oool00`000?l0oooo0?ooo`0O0?ooo`030?l0003oool0oooo06H0oooo000R0?ooo`03
0000003oool0oooo02P0oooo00<0o`000?ooo`3oool0:03oool00`000?l0oooo0?ooo`0e0?ooo`03
0?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool07@3oool00`3o0000oooo0?ooo`1W0?ooo`00
8P3oool00`000000oooo0?ooo`0X0?ooo`030?l0003oool0oooo02P0oooo00<0003o0?ooo`3oool0
=@3oool00`3o0000oooo0?ooo`0[0?ooo`030000o`3oool0oooo01d0oooo00<0o`000?ooo`3oool0
I`3oool00280oooo00<000000?ooo`3oool0:03oool00`3o0000oooo0?ooo`0W0?ooo`030000o`3o
ool0oooo03L0oooo00<0o`000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`0M0?ooo`030?l0003o
ool0oooo06L0oooo000R0?ooo`030000003oool0oooo02L0oooo00<0o`000?ooo`3oool0:03oool0
0`000?l0oooo0?ooo`0g0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool06`3oool0
0`3o0000oooo0?ooo`1X0?ooo`008P3oool00`000000oooo0?ooo`0W0?ooo`030?l0003oool0oooo
0680oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo0?ooo`0K0?ooo`030?l0003oool0oooo
06P0oooo000R0?ooo`030000003oool0oooo02L0oooo00<0o`000?ooo`3oool0H`3oool00`3o0000
oooo0?ooo`0Z0?ooo`030000o`3oool0oooo01/0oooo00<0o`000?ooo`3oool0J03oool00280oooo
0P00000W0?ooo`030?l0003oool0oooo06@0oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo
0?ooo`0I0?ooo`030?l0003oool0oooo06T0oooo000R0?ooo`030000003oool0oooo02H0oooo00<0
o`000?ooo`3oool0I03oool00`3o0000oooo0?ooo`0[0?ooo`030000o`3oool0oooo01T0oooo00<0
o`000?ooo`3oool0:`3oool00`000?l0oooo0?ooo`0k0?ooo`008P3oool00`000000oooo0?ooo`0<
0?ooo`030000o`3oool0oooo01L0oooo00<0o`000?ooo`3oool0I@3oool00`3o0000oooo0?ooo`16
0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0>`3oool000P0oooo100000050?oo
o`8000001@3oool5000000D0oooo00<000000?ooo`3oool0303oool00`000?l0oooo0?ooo`0G0?oo
o`030?l0003oool0oooo06D0oooo00<0o`000?ooo`3oool0A@3oool00`3o0000oooo0?ooo`0[0?oo
o`030000o`3oool0oooo03`0oooo00070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool2000000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0=0?ooo`03
0000o`3oool0oooo01D0oooo00<0o`000?ooo`3oool0IP3oool00`3o0000oooo0?ooo`150?ooo`03
0?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0?03oool000L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
3@3oool00`000?l0oooo0?ooo`0E0?ooo`030?l0003oool0oooo06L0oooo00<0o`000?ooo`3oool0
A03oool00`3o0000oooo0?ooo`0[0?ooo`030000o`3oool0oooo03`0oooo00070?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`<000003@3o
ool00`000?l0oooo0?ooo`0E0?ooo`030?l0003oool0oooo02L0oooo00<0003o0?ooo`3oool0?@3o
ool00`3o0000oooo0?ooo`130?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0?@3o
ool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool03@3oool00`000?l0oooo0?ooo`0D0?ooo`030?l0003oool0
oooo02P0oooo00<0003o0?ooo`3oool0?@3oool00`3o0000oooo0?ooo`130?ooo`030?l0003oool0
oooo02/0oooo00<0003o0?ooo`3oool0?@3oool000L0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03P3oool00`00
0?l0oooo0?ooo`0C0?ooo`030?l0003oool0oooo02L0oooo00<0003o0?ooo`3oool0?P3oool00`3o
0000oooo0?ooo`130?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0?@3oool000L0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`<000001`3oool00`000000
oooo0?ooo`0>0?ooo`030000o`3oool0oooo01<0oooo00<0o`000?ooo`3oool09`3oool00`000?l0
oooo0?ooo`0o0?ooo`030?l0003oool0oooo0440oooo00<0o`000?ooo`3oool0:`3oool00`000?l0
oooo0?ooo`0n0?ooo`00203oool4000000h0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`0>0?ooo`030000o`3oool0oooo0180oooo00<0o`000?ooo`3oool0:03oool00`000?l0oooo
0?ooo`0o0?ooo`030?l0003oool0oooo0440oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo
0?ooo`0n0?ooo`008P3oool00`000000oooo0?ooo`0?0?ooo`030000o`3oool0oooo0140oooo00<0
o`000?ooo`3oool09`3oool00`000?l0oooo0?ooo`100?ooo`030?l0003oool0oooo02/0oooo00<0
003o0?ooo`3oool04P3oool00`3o0000oooo0?ooo`0/0?ooo`030000o`3oool0oooo03h0oooo000R
0?ooo`030000003oool0oooo00l0oooo00<0003o0?ooo`3oool04@3oool00`3o0000oooo0?ooo`0W
0?ooo`030000o`3oool0oooo0440oooo00<0o`000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`0B
0?ooo`030?l0003oool0oooo06d0oooo000R0?ooo`8000008`3oool00`3o0000oooo0?ooo`0X0?oo
o`030000o`3oool0oooo0440oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo0?ooo`0A0?oo
o`030?l0003oool0oooo06d0oooo000R0?ooo`030000003oool0oooo0280oooo00<0o`000?ooo`3o
ool0:03oool00`000?l0oooo0?ooo`110?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3o
ool0403oool00`3o0000oooo0?ooo`1^0?ooo`008P3oool00`000000oooo0?ooo`0R0?ooo`030?l0
003oool0oooo02L0oooo00<0003o0?ooo`3oool0@`3oool00`3o0000oooo0?ooo`0Z0?ooo`030000
o`3oool0oooo0100oooo00<0o`000?ooo`3oool0KP3oool00280oooo00<000000?ooo`3oool08@3o
ool00`3o0000oooo0?ooo`0X0?ooo`030000o`3oool0oooo04<0oooo00<0o`000?ooo`3oool0:`3o
ool00`000?l0oooo0?ooo`0?0?ooo`030?l0003oool0oooo06h0oooo000R0?ooo`030000003oool0
oooo0240oooo00<0o`000?ooo`3oool0KP3oool00`3o0000oooo0?ooo`0[0?ooo`030000o`3oool0
oooo00h0oooo00<0o`000?ooo`3oool0K`3oool00280oooo00<000000?ooo`3oool08@3oool00`3o
0000oooo0?ooo`1_0?ooo`030?l0003oool0oooo02X0oooo00<0003o0?ooo`3oool03P3oool00`3o
0000oooo0?ooo`1_0?ooo`008P3oool200000240oooo00<0o`000?ooo`3oool0L03oool00`3o0000
oooo0?ooo`0[0?ooo`030000o`3oool0oooo00d0oooo00<0o`000?ooo`3oool0K`3oool00280oooo
00<000000?ooo`3oool0803oool00`3o0000oooo0?ooo`1`0?ooo`030?l0003oool0oooo02/0oooo
00<0003o0?ooo`3oool0303oool00`3o0000oooo0?ooo`0/0?ooo`030000o`3oool0oooo0440oooo
000R0?ooo`030000003oool0oooo0180oooo00<0003o0?ooo`3oool02`3oool00`3o0000oooo0?oo
o`1a0?ooo`030?l0003oool0oooo03T0oooo00<0o`000?ooo`3oool0;03oool00`000?l0oooo0?oo
o`110?ooo`008P3oool00`000000oooo0?ooo`0B0?ooo`030000o`3oool0oooo00X0oooo00<0o`00
0?ooo`3oool0LP3oool00`3o0000oooo0?ooo`0i0?ooo`030?l0003oool0oooo02/0oooo00<0003o
0?ooo`3oool0@P3oool00280oooo00<000000?ooo`3oool04`3oool00`000?l0oooo0?ooo`090?oo
o`030?l0003oool0oooo07<0oooo00<0o`000?ooo`3oool0=`3oool00`3o0000oooo0?ooo`0/0?oo
o`030000o`3oool0oooo0480oooo000R0?ooo`030000003oool0oooo01<0oooo00<0003o0?ooo`3o
ool02@3oool00`3o0000oooo0?ooo`1c0?ooo`030?l0003oool0oooo03L0oooo00<0o`000?ooo`3o
ool0:`3oool00`000?l0oooo0?ooo`130?ooo`008P3oool00`000000oooo0?ooo`0C0?ooo`030000
o`3oool0oooo00P0oooo00<0o`000?ooo`3oool0:03oool00`000?l0oooo0?ooo`190?ooo`030?l0
003oool0oooo03L0oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo0?ooo`130?ooo`008P3o
ool2000001D0oooo00<0003o0?ooo`3oool01`3oool00`3o0000oooo0?ooo`0X0?ooo`030000o`3o
ool0oooo04X0oooo00<0o`000?ooo`3oool0=@3oool00`3o0000oooo0?ooo`0[0?ooo`030000o`3o
ool0oooo04@0oooo000R0?ooo`030000003oool0oooo01@0oooo00<0003o0?ooo`3oool01`3oool0
0`3o0000oooo0?ooo`0W0?ooo`030000o`3oool0oooo04/0oooo00<0o`000?ooo`3oool0=@3oool0
0`3o0000oooo0?ooo`0[0?ooo`030000o`3oool0oooo04@0oooo000R0?ooo`030000003oool0oooo
01@0oooo00<0003o0?ooo`3oool01P3oool00`3o0000oooo0?ooo`0X0?ooo`030000o`3oool0oooo
04`0oooo00<0o`000?ooo`3oool0=03oool00`3o0000oooo0?ooo`0Z0?ooo`030000o`3oool0oooo
04D0oooo000R0?ooo`030000003oool0oooo01D0oooo00<0003o0?ooo`3oool01@3oool00`3o0000
oooo0?ooo`0W0?ooo`030000o`3oool0oooo04d0oooo00<0o`000?ooo`3oool0<`3oool00`3o0000
oooo0?ooo`0[0?ooo`030000o`3oool0oooo04D0oooo000R0?ooo`030000003oool0oooo01D0oooo
00<0003o0?ooo`3oool0103oool00`3o0000oooo0?ooo`0X0?ooo`030000o`3oool0oooo04h0oooo
00<0o`000?ooo`3oool0:@3oool00`000?l0oooo0?ooo`060?ooo`030?l0003oool0oooo07<0oooo
000R0?ooo`030000003oool0oooo01`0oooo00<0o`000?ooo`3oool09`3oool00`000?l0oooo0?oo
o`1?0?ooo`030?l0003oool0oooo02T0oooo00<0003o0?ooo`3oool01P3oool00`3o0000oooo0?oo
o`1c0?ooo`008P3oool2000001d0oooo00<0o`000?ooo`3oool09`3oool00`000?l0oooo0?ooo`1?
0?ooo`030?l0003oool0oooo02X0oooo00<0003o0?ooo`3oool0103oool00`3o0000oooo0?ooo`1d
0?ooo`008P3oool00`000000oooo0?ooo`0K0?ooo`030?l0003oool0oooo02L0oooo00<0003o0?oo
o`3oool0D@3oool00`3o0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo00@0oooo00<0o`000?oo
o`3oool0M03oool00280oooo00<000000?ooo`3oool06`3oool00`3o0000oooo0?ooo`0W0?ooo`03
0000o`3oool0oooo0540oooo00<0o`000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`030?ooo`03
0?l0003oool0oooo07@0oooo000R0?ooo`030000003oool0oooo01X0oooo00<0o`000?ooo`3oool0
O@3oool00`3o0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo0080oooo00<0o`000?ooo`3oool0
M@3oool000P0oooo100000050?ooo`800000103oool5000000H0oooo00<000000?ooo`3oool06P3o
ool00`3o0000oooo0?ooo`1m0?ooo`030?l0003oool0oooo02X0oooo00D0003o0?ooo`3oool0oooo
0?l0001g0?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P00
00040?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`0I0?ooo`030?l0
003oool0oooo07h0oooo00<0o`000?ooo`3oool0:P3oool01@000?l0oooo0?ooo`3oool0o`0007L0
oooo00070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo01T0oooo00<0o`000?ooo`3oool0O`3oool00`3o0000oooo
0?ooo`0Z0?ooo`030000o`3oool0o`0007P0oooo00070?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`060?ooo`<000006@3oool00`3o0000oooo0?oo
o`1o0?ooo`030?l0003oool0oooo02X0oooo00<0003o0?ooo`3o0000;@3oool00`000?l0oooo0?oo
o`180?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0H0?ooo`030000o`3oool0oooo0840oooo00<0o`00
0?ooo`3oool0:P3oool00`3o0000oooo0?ooo`0/0?ooo`030000o`3oool0oooo04P0oooo00070?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo01P0oooo00<0003o0?ooo`3oool0P@3oool00`3o0000oooo0?ooo`0Z0?oo
o`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0B@3oool000L0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000001P3oool00`00
0000oooo0?ooo`0G0?ooo`030?l0003oool0003o0880oooo00<0o`000?ooo`3oool0:P3oool00`3o
0000oooo0?ooo`0[0?ooo`030000o`3oool0oooo04T0oooo00080?ooo`@00000303oool3000000L0
oooo00<000000?ooo`3oool05`3oool00`3o0000oooo0000o`230?ooo`030?l0003oool0oooo02P0
oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo0?ooo`1:0?ooo`008P3oool00`000000oooo
0?ooo`0G0?ooo`040?l0003oool0oooo0000obL0oooo00<0003o0?ooo`3oool0F03oool00`3o0000
oooo0?ooo`0X0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0BP3oool00280oooo
0P00000G0?ooo`050?l0003oool0oooo0?ooo`000?l09`3oool00`000?l0oooo0?ooo`1I0?ooo`03
0?l0003oool0oooo02L0oooo00<0o`000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`1;0?ooo`00
8P3oool00`000000oooo0?ooo`0F0?ooo`030?l0003oool0oooo0080oooo00<0003o0?ooo`3oool0
8`3oool00`000?l0oooo0?ooo`1J0?ooo`030?l0003oool0oooo02H0oooo00<0o`000?ooo`3oool0
:`3oool00`000?l0oooo0?ooo`1;0?ooo`008P3oool00`000000oooo0?ooo`0E0?ooo`030?l0003o
ool0oooo00<0oooo00<0003o0?ooo`3oool08`3oool00`000?l0oooo0?ooo`1J0?ooo`030?l0003o
ool0oooo02H0oooo00<0o`000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`1<0?ooo`008P3oool0
0`000000oooo0?ooo`0E0?ooo`030?l0003oool0oooo00@0oooo00<0003o0?ooo`3oool08@3oool0
0`000?l0oooo0?ooo`1L0?ooo`030?l0003oool0oooo02@0oooo00<0o`000?ooo`3oool00`3oool0
0`000?l0oooo0?ooo`0U0?ooo`030000o`3oool0oooo04`0oooo000R0?ooo`030000003oool0oooo
01@0oooo00<0o`000?ooo`3oool01@3oool00`000?l0oooo0?ooo`0Q0?ooo`030000o`3oool0oooo
05`0oooo00<0o`000?ooo`3oool0903oool00`3o0000oooo0?ooo`030?ooo`030000o`3oool0oooo
07@0oooo000R0?ooo`030000003oool0oooo01@0oooo00<0o`000?ooo`3oool0:03oool00`000?l0
oooo0?ooo`1N0?ooo`030?l0003oool0oooo0280oooo00<0o`000?ooo`3oool01@3oool00`000?l0
oooo0?ooo`1c0?ooo`008P3oool2000001@0oooo00<0o`000?ooo`3oool0:@3oool00`000?l0oooo
0?ooo`1N0?ooo`030?l0003oool0oooo0280oooo00<0o`000?ooo`3oool01@3oool00`000?l0oooo
0?ooo`1c0?ooo`008P3oool00`000000oooo0?ooo`0C0?ooo`030?l0003oool0oooo02P0oooo00<0
003o0?ooo`3oool0H03oool00`3o0000oooo0?ooo`0P0?ooo`030?l0003oool0oooo00L0oooo00<0
003o0?ooo`3oool0LP3oool00280oooo00<000000?ooo`3oool04P3oool00`3o0000oooo0?ooo`0Y
0?ooo`030000o`3oool0oooo0600oooo00<0o`000?ooo`3oool07`3oool00`3o0000oooo0?ooo`08
0?ooo`030000o`3oool0oooo0780oooo000R0?ooo`030000003oool0oooo0180oooo00<0o`000?oo
o`3oool0S@3oool00`3o0000oooo0?ooo`0N0?ooo`030?l0003oool0oooo00T0oooo00<0003o0?oo
o`3oool0L@3oool00280oooo00<000000?ooo`3oool04@3oool00`3o0000oooo0?ooo`2?0?ooo`03
0?l0003oool0oooo01`0oooo00<0o`000?ooo`3oool02P3oool00`000?l0oooo0?ooo`1a0?ooo`00
8P3oool00`000000oooo0?ooo`0A0?ooo`030?l0003oool0oooo08l0oooo00<0o`000?ooo`3oool0
703oool00`3o0000oooo0?ooo`0:0?ooo`030000o`3oool0oooo0740oooo000R0?ooo`030000003o
ool0oooo0100oooo00<0o`000?ooo`3oool03P3oool00`000?l0oooo0?ooo`200?ooo`030?l0003o
ool0oooo01X0oooo00<0o`000?ooo`3oool0303oool00`000?l0oooo0?ooo`1`0?ooo`008P3oool2
00000100oooo00<0o`000?ooo`3oool0403oool00`000?l0oooo0?ooo`1o0?ooo`030?l0003oool0
oooo01X0oooo00<0o`000?ooo`3oool0O`3oool00280oooo00<000000?ooo`3oool03`3oool00`3o
0000oooo0?ooo`0@0?ooo`030000o`3oool0oooo0800oooo00<0o`000?ooo`3oool0603oool00`3o
0000oooo0?ooo`200?ooo`008P3oool00`000000oooo0?ooo`0>0?ooo`030?l0003oool0oooo0180
oooo00<0003o0?ooo`3oool0P03oool00`3o0000oooo0?ooo`0F0?ooo`030?l0003oool0oooo02/0
oooo00<0003o0?ooo`3oool0D`3oool00280oooo00<000000?ooo`3oool03@3oool00`3o0000oooo
0?ooo`0D0?ooo`030000o`3oool0oooo0140oooo00<0003o0?ooo`3oool0J`3oool00`3o0000oooo
0?ooo`0E0?ooo`030?l0003oool0oooo02`0oooo00<0003o0?ooo`3oool0D`3oool00280oooo00<0
00000?ooo`3oool0303oool00`3o0000oooo0?ooo`0F0?ooo`030000o`3oool0oooo00l0oooo00<0
003o0?ooo`3oool0K@3oool00`3o0000oooo0?ooo`0D0?ooo`030?l0003oool0oooo02/0oooo00<0
003o0?ooo`3oool0E03oool00280oooo00<000000?ooo`3oool02`3oool00`3o0000oooo0?ooo`0H
0?ooo`030000o`3oool0oooo00d0oooo00<0003o0?ooo`3oool0K`3oool00`3o0000oooo0?ooo`0B
0?ooo`030?l0003oool0oooo02/0oooo00<0003o0?ooo`3oool0E@3oool00280oooo00<0o`000000
003oool02@3oool20?l001`0oooo00<0003o0?ooo`3oool02`3oool00`000?l0oooo0?ooo`1a0?oo
o`030?l0003oool0oooo0100oooo00<0o`000?ooo`3oool0:`3oool00`000?l0oooo0?ooo`1F0?oo
o`008P3oool00`000000o`000?ooo`080?ooo`030?l0003oool0oooo01d0oooo00<0003o0?ooo`3o
ool02@3oool00`000?l0oooo0?ooo`1c0?ooo`030?l0003oool0oooo00h0oooo00<0o`000?ooo`3o
ool0603oool00`000?l0oooo0?ooo`0@0?ooo`030000o`3oool0oooo05L0oooo000R0?ooo`030000
003oool0o`000080o`000`3oool30?l002X0oooo0P000?mf0?ooo`030?l0003oool0oooo00d0oooo
00<0o`000?ooo`3oool06P3oool00`000?l0oooo0?ooo`0>0?ooo`030000o`3oool0oooo05P0oooo
000R0?ooo`030000003oool0oooo0080oooo103o000[0?ooo`030000o`3oool0oooo07L0oooo00<0
o`000?ooo`3oool02P3oool20?l001h0oooo00<0003o0?ooo`3oool0303oool20000oeX0oooo0008
0?ooo`@000001@3oool2000000D0oooo0`0000070?ooo`030000003oool0oooo0:`0oooo0P3o0009
0?ooo`030?l0003oool0oooo01l0oooo0P000?mX0?ooo`001`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000001P3oool0
0`000000oooo0?ooo`2^0?ooo`T0o`00903oool20000ofH0oooo00070?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0;80oooo00<0o`000?ooo`3oool0:03oool20000of@0oooo00070?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooo`<00000o`3ooom40?ooo`00
1`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo0P0000070?ooo`030000
003oool0oooo0?l0ooooA03oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooom40?ooo`001`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo0000
00060?ooo`030000003oool0oooo0?l0ooooA03oool000P0oooo1000000<0?ooo`<000001`3oool0
0`000000oooo0?ooo`3o0?oood@0oooo003o0?ooofT0oooo003o0?ooofT0oooo003o0?ooofT0oooo
003o0?ooofT0oooo003o0?ooofT0oooo003o0?ooofT0oooo003o0?ooofT0oooo003o0?ooofT0oooo
003o0?ooofT0oooo0000\
\>"],
  ImageRangeCache->{{{81, 368}, {312.938, 136}} -> {-16.2958, 0.183698, \
0.0119662, 0.00386478}},
  CellTags->"b:1.1.1.4"]
}, Open  ]],

Cell[TextData[{
  "The solution to this equation is given in terms of the derivatives of the \
Airy functions, ",
  StyleBox["AiryAiPrime", "MR"],
  " and ",
  StyleBox["AiryBiPrime", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\ \((\((a*x + b\ )\))\)*\ \(\(Derivative[2]\)[y]\)[x] - 
          a*\(\(Derivative[1]\)[y]\)[x]\  - \((a*\((a*x + b)\))\)^2*\ 
            y[x]\  == \ 0, \ y, \ x]\)], "Input",
  CellLabel->"In[102]:=",
  CellTags->"b:1.1.1.4"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            AiryAiPrime[b + a\ x]\ C[1] + 
              AiryBiPrime[b + a\ x]\ C[2]]}}\)], "Output",
  CellLabel->"Out[102]=",
  CellTags->"b:1.1.1.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the solution for ",
  StyleBox[ButtonBox["Bessel\[CloseCurlyQuote]s equation",
    ButtonData:>"EquationTypes",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  " with ",
  StyleBox["n",
    FontSlant->"Italic"],
  " = 4. Note that the solution is given in terms of Bessel functions of the \
first kind, ",
  StyleBox["BesselJ", "MR"],
  ", as well as those of the second kind, ",
  StyleBox["BesselY", "MR"],
  "."
}], "MathCaption",
  CellTags->{"BesselODE", "b:1.1.1.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[
      x^2*\(y''\)[x]\  + \ x*\(y'\)[x]\  + \((x^2 - 16)\)*y[x] \[Equal] 0, \ 
      y[x], x]\)], "Input",
  CellLabel->"In[103]:=",
  CellTags->"b:1.1.1.4"],

Cell[BoxData[
    \({{y[x] \[Rule] BesselJ[4, x]\ C[1] + BesselY[4, x]\ C[2]}}\)], "Output",\

  CellLabel->"Out[103]=",
  CellTags->"b:1.1.1.4"]
}, Open  ]],

Cell[TextData[{
  "Here is a plot of the ",
  StyleBox["BesselJ", "MR"],
  " functions for specific values of ",
  StyleBox["n",
    FontSlant->"Italic"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{BesselJ[1, x], \ BesselJ[3, x], \ BesselJ[4, x]}, \ {x, 0, 10}, \ 
      PlotStyle\  \[Rule] \ {Red, \ Green, \ Blue}]; \)], "Input",
  CellLabel->"In[104]:=",
  CellTags->"b:1.1.1.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.234255 0.634279 [
[.21429 .22176 -3 -9 ]
[.21429 .22176 3 0 ]
[.40476 .22176 -3 -9 ]
[.40476 .22176 3 0 ]
[.59524 .22176 -3 -9 ]
[.59524 .22176 3 0 ]
[.78571 .22176 -3 -9 ]
[.78571 .22176 3 0 ]
[.97619 .22176 -6 -9 ]
[.97619 .22176 6 0 ]
[.01131 .1074 -24 -4.5 ]
[.01131 .1074 0 4.5 ]
[.01131 .36111 -18 -4.5 ]
[.01131 .36111 0 4.5 ]
[.01131 .48797 -18 -4.5 ]
[.01131 .48797 0 4.5 ]
[.01131 .61482 -18 -4.5 ]
[.01131 .61482 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .23426 m
.21429 .24051 L
s
[(2)] .21429 .22176 0 1 Mshowa
.40476 .23426 m
.40476 .24051 L
s
[(4)] .40476 .22176 0 1 Mshowa
.59524 .23426 m
.59524 .24051 L
s
[(6)] .59524 .22176 0 1 Mshowa
.78571 .23426 m
.78571 .24051 L
s
[(8)] .78571 .22176 0 1 Mshowa
.97619 .23426 m
.97619 .24051 L
s
[(10)] .97619 .22176 0 1 Mshowa
.125 Mabswid
.07143 .23426 m
.07143 .23801 L
s
.11905 .23426 m
.11905 .23801 L
s
.16667 .23426 m
.16667 .23801 L
s
.2619 .23426 m
.2619 .23801 L
s
.30952 .23426 m
.30952 .23801 L
s
.35714 .23426 m
.35714 .23801 L
s
.45238 .23426 m
.45238 .23801 L
s
.5 .23426 m
.5 .23801 L
s
.54762 .23426 m
.54762 .23801 L
s
.64286 .23426 m
.64286 .23801 L
s
.69048 .23426 m
.69048 .23801 L
s
.7381 .23426 m
.7381 .23801 L
s
.83333 .23426 m
.83333 .23801 L
s
.88095 .23426 m
.88095 .23801 L
s
.92857 .23426 m
.92857 .23801 L
s
.25 Mabswid
0 .23426 m
1 .23426 L
s
.02381 .1074 m
.03006 .1074 L
s
[(-0.2)] .01131 .1074 1 0 Mshowa
.02381 .36111 m
.03006 .36111 L
s
[(0.2)] .01131 .36111 1 0 Mshowa
.02381 .48797 m
.03006 .48797 L
s
[(0.4)] .01131 .48797 1 0 Mshowa
.02381 .61482 m
.03006 .61482 L
s
[(0.6)] .01131 .61482 1 0 Mshowa
.125 Mabswid
.02381 .13911 m
.02756 .13911 L
s
.02381 .17083 m
.02756 .17083 L
s
.02381 .20254 m
.02756 .20254 L
s
.02381 .26597 m
.02756 .26597 L
s
.02381 .29768 m
.02756 .29768 L
s
.02381 .3294 m
.02756 .3294 L
s
.02381 .39282 m
.02756 .39282 L
s
.02381 .42454 m
.02756 .42454 L
s
.02381 .45625 m
.02756 .45625 L
s
.02381 .51968 m
.02756 .51968 L
s
.02381 .55139 m
.02756 .55139 L
s
.02381 .58311 m
.02756 .58311 L
s
.02381 .07569 m
.02756 .07569 L
s
.02381 .04397 m
.02756 .04397 L
s
.02381 .01226 m
.02756 .01226 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .23426 m
.06244 .36028 L
.10458 .47975 L
.12507 .52599 L
.14415 .56016 L
.1536 .57359 L
.16254 .58406 L
.16748 .58889 L
.17284 .59335 L
.17735 .59648 L
.18221 .59918 L
.18475 .60033 L
.18708 .60122 L
.18945 .60196 L
.19165 .60251 L
.19298 .60277 L
.1942 .60297 L
.19554 .60313 L
.19628 .6032 L
.19698 .60325 L
.19825 .60331 L
.19941 .60332 L
.20069 .60329 L
.20134 .60325 L
.20205 .6032 L
.20345 .60306 L
.20479 .60287 L
.20729 .60237 L
.20999 .60164 L
.21292 .60062 L
.2182 .59817 L
.22307 .59521 L
.2327 .58748 L
.24174 .578 L
.26234 .54883 L
.28252 .51113 L
.30103 .46995 L
.34065 .3672 L
.37876 .26133 L
.41932 .15673 L
.45837 .07732 L
.46861 .06127 L
.47971 .04641 L
.48931 .0358 L
.49986 .02658 L
.50482 .02316 L
.51013 .02013 L
.51515 .01788 L
.51974 .01636 L
.52242 .0157 L
Mistroke
.52491 .01523 L
.52634 .01503 L
.52763 .0149 L
.52835 .01484 L
.52913 .01478 L
.52986 .01475 L
.53054 .01473 L
.53177 .01472 L
.53291 .01474 L
.53417 .01479 L
.53488 .01484 L
.53552 .0149 L
.53682 .01504 L
.53823 .01523 L
.54078 .0157 L
.54313 .01626 L
.54565 .01701 L
.55021 .01872 L
.55563 .02135 L
.5606 .02432 L
.57084 .03208 L
.58162 .04251 L
.6014 .06714 L
.61978 .09547 L
.65888 .16776 L
.70043 .25105 L
.74046 .32392 L
.75881 .35159 L
.77898 .37631 L
.78859 .38573 L
.79889 .39403 L
.80458 .39779 L
.80978 .4007 L
.81471 .40299 L
.81995 .40492 L
.82465 .40621 L
.82733 .40676 L
.82985 .40715 L
.83097 .40728 L
.83215 .4074 L
.83315 .40748 L
.83425 .40754 L
.83545 .40759 L
.83672 .4076 L
.83792 .40759 L
.83901 .40756 L
.8403 .40749 L
.84096 .40744 L
.84167 .40738 L
.84413 .4071 L
Mistroke
.84551 .40689 L
.847 .40663 L
.84968 .40605 L
.85495 .40453 L
.85976 .4027 L
.86962 .39767 L
.87876 .39153 L
.89949 .37269 L
.92003 .34817 L
.93864 .32194 L
.97619 .26183 L
Mfstroke
0 1 0 r
.02381 .23426 m
.02499 .23426 L
.02605 .23426 L
.02729 .23426 L
.02846 .23426 L
.02954 .23426 L
.03053 .23426 L
.03163 .23426 L
.03279 .23427 L
.03395 .23427 L
.0352 .23428 L
.03746 .23429 L
.03884 .23431 L
.04016 .23432 L
.04262 .23436 L
.045 .2344 L
.04753 .23446 L
.0521 .2346 L
.05752 .23484 L
.06244 .23513 L
.06787 .23555 L
.07287 .23603 L
.08414 .23753 L
.09408 .23938 L
.10458 .24196 L
.12422 .24869 L
.14255 .25747 L
.1629 .27022 L
.18146 .2846 L
.22131 .32363 L
.25964 .36883 L
.30042 .41939 L
.33968 .46341 L
.35938 .48144 L
.37743 .49461 L
.38686 .5 L
.39678 .50446 L
.4016 .50616 L
.40674 .50762 L
.4097 .5083 L
.41239 .5088 L
.41509 .50921 L
.41632 .50935 L
.41764 .50949 L
.41889 .50959 L
.42003 .50967 L
.42118 .50973 L
.42227 .50976 L
.42353 .50978 L
.4247 .50978 L
Mistroke
.42599 .50975 L
.42671 .50972 L
.42736 .50969 L
.42869 .50961 L
.42991 .50951 L
.43266 .50921 L
.43509 .50885 L
.43765 .50836 L
.44221 .50726 L
.44645 .50594 L
.4561 .50191 L
.46658 .4959 L
.4765 .48867 L
.49506 .47115 L
.53345 .41997 L
.57428 .34817 L
.6136 .27007 L
.6514 .19547 L
.69166 .12618 L
.71017 .10031 L
.7304 .07757 L
.74011 .0689 L
.75048 .06137 L
.75621 .05798 L
.76142 .05539 L
.76636 .05338 L
.77159 .05171 L
.77636 .0506 L
.77907 .05015 L
.78037 .04998 L
.7816 .04985 L
.78271 .04975 L
.78392 .04967 L
.78502 .04962 L
.78604 .04959 L
.78714 .04958 L
.78835 .04959 L
.78962 .04963 L
.79081 .04969 L
.79203 .04978 L
.79335 .04991 L
.79603 .05026 L
.79851 .0507 L
.80082 .0512 L
.80604 .05267 L
.81162 .05475 L
.82185 .05991 L
.83294 .06739 L
.85309 .08565 L
.89397 .13805 L
Mistroke
.93335 .20075 L
.9712 .26334 L
.97619 .27128 L
Mfstroke
0 0 1 r
.02381 .23426 m
.02499 .23426 L
.02605 .23426 L
.02729 .23426 L
.02846 .23426 L
.02954 .23426 L
.03053 .23426 L
.03163 .23426 L
.03279 .23426 L
.03395 .23426 L
.0352 .23426 L
.03638 .23426 L
.03746 .23426 L
.03873 .23426 L
.04011 .23426 L
.04141 .23426 L
.04262 .23426 L
.04386 .23426 L
.04521 .23426 L
.04765 .23426 L
.05003 .23426 L
.05221 .23427 L
.05459 .23427 L
.05719 .23428 L
.06244 .2343 L
.06527 .23431 L
.06795 .23433 L
.07296 .23437 L
.07836 .23443 L
.08424 .23452 L
.08936 .23462 L
.0948 .23475 L
.10458 .23508 L
.11395 .23552 L
.12405 .23617 L
.13359 .23698 L
.14233 .23792 L
.16125 .24071 L
.17198 .24282 L
.18195 .24518 L
.20241 .25134 L
.221 .25866 L
.26098 .28045 L
.29945 .30929 L
.34037 .34703 L
.37977 .38718 L
.41766 .42512 L
.43874 .4442 L
.458 .45944 L
.47814 .47245 L
Mistroke
.48794 .47749 L
.49682 .48125 L
.50603 .48429 L
.51109 .48557 L
.51584 .48651 L
.51837 .4869 L
.52104 .48724 L
.52332 .48746 L
.5246 .48755 L
.52581 .48763 L
.52649 .48766 L
.52722 .48769 L
.5285 .48773 L
.52923 .48774 L
.53 .48775 L
.53066 .48774 L
.53139 .48774 L
.53268 .48771 L
.5334 .48769 L
.53407 .48766 L
.53529 .48759 L
.53658 .4875 L
.53916 .48726 L
.5416 .48695 L
.54615 .48619 L
.55106 .48507 L
.55636 .48351 L
.56593 .47979 L
.57474 .47533 L
.59354 .46248 L
.6142 .44329 L
.65459 .39193 L
.69347 .32919 L
.73479 .25532 L
.77461 .18551 L
.81291 .12746 L
.83227 .10369 L
.84255 .09294 L
.85366 .08293 L
.8642 .07503 L
.87388 .06922 L
.88314 .06499 L
.88779 .06337 L
.89289 .06197 L
.89542 .06143 L
.89816 .06095 L
.89942 .06078 L
.90076 .06061 L
.90191 .0605 L
.90315 .06039 L
Mistroke
.90435 .06032 L
.90544 .06027 L
.90654 .06023 L
.90759 .06022 L
.9088 .06023 L
.90993 .06025 L
.91116 .06031 L
.91248 .06039 L
.91389 .06051 L
.91519 .06064 L
.91813 .06104 L
.92073 .06151 L
.92346 .06212 L
.92821 .06344 L
.93342 .06528 L
.94363 .07006 L
.95294 .07572 L
.97386 .09273 L
.97619 .09497 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gR000`400?l00000o`00003oo`3ooomY
0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY
0?ooo`008P3oool00`000000oooo0?ooo`3o0?oood@0oooo000R0?ooo`030000003oool0oooo0?l0
ooooA03oool00280oooo00<000000?ooo`3oool0o`3ooom40?ooo`008P3oool00`000000oooo0?oo
o`3o0?oood@0oooo000R0?ooo`800000o`3ooom50?ooo`008P3oool00`000000oooo0?ooo`2R0?oo
o`T0o`00V03oool00280oooo00<000000?ooo`3oool0WP3oool40?l000T0oooo0P3o002F0?ooo`00
8P3oool00`000000oooo0?ooo`2M0?ooo`030?l0003oool0oooo00d0oooo0P3o002D0?ooo`008P3o
ool00`000000oooo0?ooo`2L0?ooo`030?l0003oool0oooo0100oooo00<0o`000?ooo`3oool0T@3o
ool00280oooo00<000000?ooo`3oool0V`3oool00`3o0000oooo0?ooo`0B0?ooo`80o`00T@3oool0
0280oooo00<000000?ooo`3oool0VP3oool00`3o0000oooo0?ooo`0E0?ooo`80o`00S`3oool00280
oooo00<000000?ooo`3oool0V@3oool00`3o0000oooo0?ooo`0H0?ooo`030?l0003oool0oooo08`0
oooo000R0?ooo`030000003oool0oooo09P0oooo00<0o`000?ooo`3oool06@3oool00`3o0000oooo
0?ooo`2<0?ooo`008P3oool00`000000oooo0?ooo`2G0?ooo`030?l0003oool0oooo01/0oooo00<0
o`000?ooo`3oool0R`3oool00280oooo0P00002F0?ooo`80o`007`3oool00`3o0000oooo0?ooo`2:
0?ooo`008P3oool00`000000oooo0?ooo`2D0?ooo`030?l0003oool0oooo0200oooo00<0o`000?oo
o`3oool0R@3oool00280oooo00<000000?ooo`3oool0T`3oool00`3o0000oooo0?ooo`0R0?ooo`03
0?l0003oool0oooo03d0oooo1`00o`140?ooo`008P3oool00`000000oooo0?ooo`2C0?ooo`030?l0
003oool0oooo02<0oooo00<0o`000?ooo`3oool0>03oool4003o00H0oooo1000o`110?ooo`008P3o
ool00`000000oooo0?ooo`2B0?ooo`030?l0003oool0oooo02@0oooo00<0o`000?ooo`3oool0=P3o
ool2003o00h0oooo0P00o`0o0?ooo`008P3oool00`000000oooo0?ooo`2B0?ooo`030?l0003oool0
oooo02D0oooo00<0o`000?ooo`3oool0<`3oool2003o0180oooo0P00o`0m0?ooo`008P3oool00`00
0000oooo0?ooo`2A0?ooo`030?l0003oool0oooo02L0oooo00<0o`000?ooo`3oool0<03oool2003o
01H0oooo00<00?l00?ooo`3oool05@3oool;0000oaX0oooo000R0?ooo`030000003oool0oooo0900
oooo00<0o`000?ooo`3oool0:@3oool00`3o0000oooo0?ooo`0^0?ooo`03003o003oool0oooo01L0
oooo0P00o`0B0?ooo`<0003o2`3oool30000oaL0oooo000R0?ooo`030000003oool0oooo08l0oooo
00<0o`000?ooo`3oool0:`3oool00`3o0000oooo0?ooo`0/0?ooo`03003o003oool0oooo01X0oooo
0P00o`0>0?ooo`80003o4@3oool20000oaD0oooo000R0?ooo`030000003oool0oooo08l0oooo00<0
o`000?ooo`3oool0;03oool00`3o0000oooo0?ooo`0Z0?ooo`03003o003oool0oooo01d0oooo00<0
0?l00?ooo`3oool02P3oool00`000?l0oooo0?ooo`0C0?ooo`80003o4`3oool00280oooo00<00000
0?ooo`3oool0SP3oool00`3o0000oooo0?ooo`0]0?ooo`030?l0003oool0oooo02T0oooo00<00?l0
0?ooo`3oool07`3oool00`00o`00oooo0?ooo`070?ooo`80003o603oool20000oa40oooo000R0?oo
o`800000SP3oool00`3o0000oooo0?ooo`0_0?ooo`030?l0003oool0oooo02L0oooo00<00?l00?oo
o`3oool08@3oool2003o00D0oooo0P000?lL0?ooo`030000o`3oool0oooo00h0oooo000R0?ooo`03
0000003oool0oooo08d0oooo00<0o`000?ooo`3oool0<03oool00`3o0000oooo0?ooo`0U0?ooo`03
003o003oool0oooo02@0oooo00<00?l00?ooo`3oool00P000?lO0?ooo`030000o`3oool0oooo00d0
oooo000R0?ooo`030000003oool0oooo08`0oooo00<0o`000?ooo`3oool0<@3oool00`3o0000oooo
0?ooo`0T0?ooo`03003o003oool0oooo02H0oooo00<00?l00000o`3oool08@3oool00`000?l0oooo
0?ooo`0<0?ooo`008P3oool00`000000oooo0?ooo`2<0?ooo`030?l0003oool0oooo0380oooo00<0
o`000?ooo`3oool08P3oool00`00o`00oooo0?ooo`0W0?ooo`030000o`00o`00oooo0280oooo0P00
0?l<0?ooo`008P3oool00`000000oooo0?ooo`2;0?ooo`030?l0003oool0oooo03@0oooo00<0o`00
0?ooo`3oool0803oool00`00o`00oooo0?ooo`0W0?ooo`040000o`3oool0oooo003o02@0oooo00<0
003o0?ooo`3oool02@3oool00280oooo00<000000?ooo`3oool0R`3oool00`3o0000oooo0?ooo`0d
0?ooo`030?l0003oool0oooo01l0oooo00<00?l00?ooo`3oool09`3oool01@000?l0oooo0?ooo`3o
ool00?l002D0oooo00<0003o0?ooo`3oool0203oool00280oooo00<000000?ooo`3oool0RP3oool0
0`3o0000oooo0?ooo`0f0?ooo`030?l0003oool0oooo01d0oooo00<00?l00?ooo`3oool09`3oool0
0`000?l0oooo0?ooo`030?ooo`03003o003oool0oooo02<0oooo0P000?l80?ooo`00203oool40000
00D0oooo0P0000040?ooo`D000001P3oool00`000000oooo0?ooo`2:0?ooo`030?l0003oool0oooo
03L0oooo00<0o`000?ooo`3oool06`3oool00`00o`00oooo0?ooo`0W0?ooo`030000o`3oool0oooo
00D0oooo00<00?l00?ooo`3oool0;03oool000L0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`800000103oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?oo
o`3oool0R@3oool00`3o0000oooo0?ooo`0h0?ooo`030?l0003oool0oooo01X0oooo00<00?l00?oo
o`3oool09`3oool00`000?l0oooo0?ooo`070?ooo`03003o003oool0oooo02/0oooo00070?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo08T0oooo00<0o`000?ooo`3oool0>@3oool00`3o0000oooo0?ooo`0H0?ooo`03
003o003oool0oooo02L0oooo00<0003o0?ooo`3oool0203oool00`00o`00oooo0?ooo`0[0?ooo`00
1@0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`060?ooo`<00000R03oool00`3o0000oooo0?ooo`0j0?ooo`030?l0003oool0oooo01P0oooo
00<00?l00?ooo`3oool09P3oool00`000?l0oooo0?ooo`0:0?ooo`03003o003oool0oooo02X0oooo
00070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo08P0oooo00<0o`000?ooo`3oool0>`3oool00`3o0000oooo0?oo
o`0F0?ooo`03003o003oool0oooo02H0oooo00<0003o0?ooo`3oool0303oool00`00o`00oooo0?oo
o`0Y0?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`270?ooo`030?l0003oool0oooo03`0oooo00<0o`00
0?ooo`3oool05@3oool00`00o`00oooo0?ooo`0V0?ooo`030000o`3oool0oooo00d0oooo00<00?l0
0?ooo`3oool0:@3oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?oo
o`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`270?ooo`030?l0003oool0
oooo03d0oooo00<0o`000?ooo`3oool0503oool00`00o`00oooo0?ooo`0U0?ooo`030000o`3oool0
oooo00l0oooo00<00?l00?ooo`3oool0:03oool000P0oooo1000000<0?ooo`<000001`3oool00`00
0000oooo0?ooo`260?ooo`030?l0003oool0oooo03h0oooo00<0o`000?ooo`3oool04`3oool00`00
o`00oooo0?ooo`0V0?ooo`030000o`3oool0oooo0100oooo00<00?l00?ooo`3oool09`3oool00280
oooo00<000000?ooo`3oool0QP3oool00`3o0000oooo0?ooo`0o0?ooo`030?l0003oool0oooo0140
oooo00<00?l00?ooo`3oool09P3oool00`000?l0oooo0?ooo`0B0?ooo`03003o003oool0oooo02H0
oooo000R0?ooo`030000003oool0oooo08D0oooo00<0o`000?ooo`3oool0@03oool00`3o0000oooo
0?ooo`0A0?ooo`03003o003oool0oooo02D0oooo00<0003o0?ooo`3oool04`3oool00`00o`00oooo
0?ooo`0V0?ooo`008P3oool00`000000oooo0?ooo`250?ooo`030?l0003oool0oooo0440oooo00<0
o`000?ooo`3oool03`3oool00`00o`00oooo0?ooo`0U0?ooo`030000o`3oool0oooo01D0oooo00<0
0?l00?ooo`3oool09@3oool00280oooo00<000000?ooo`3oool0Q03oool00`3o0000oooo0?ooo`12
0?ooo`030?l0003oool0oooo00h0oooo00<00?l00?ooo`3oool09@3oool00`000?l0oooo0?ooo`0G
0?ooo`03003o003oool0oooo02@0oooo000R0?ooo`030000003oool0oooo08@0oooo00<0o`000?oo
o`3oool0@`3oool00`3o0000oooo0?ooo`0=0?ooo`03003o003oool0oooo02D0oooo00<0003o0?oo
o`3oool0603oool00`00o`00oooo0?ooo`0S0?ooo`008P3oool00`000000oooo0?ooo`230?ooo`03
0?l0003oool0oooo04@0oooo00<0o`000?ooo`3oool0303oool00`00o`00oooo0?ooo`0U0?ooo`03
0000o`3oool0oooo01T0oooo00<00?l00?ooo`3oool08`3oool00280oooo0P0000240?ooo`030?l0
003oool0oooo04D0oooo00<0o`000?ooo`3oool02`3oool00`00o`00oooo0?ooo`0T0?ooo`030000
o`3oool0oooo01/0oooo00<00?l00?ooo`3oool08P3oool00280oooo00<000000?ooo`3oool0PP3o
ool00`3o0000oooo0?ooo`160?ooo`030?l0003oool0oooo00X0oooo00<00?l00?ooo`3oool09@3o
ool00`000?l0oooo0?ooo`0L0?ooo`03003o003oool0oooo0240oooo000R0?ooo`030000003oool0
oooo0880oooo00<0o`000?ooo`3oool0A`3oool00`3o0000oooo0?ooo`090?ooo`03003o003oool0
oooo02@0oooo00<0003o0?ooo`3oool07@3oool00`00o`00oooo0?ooo`0Q0?ooo`008P3oool00`00
0000oooo0?ooo`210?ooo`030?l0003oool0oooo04P0oooo00<0o`000?ooo`3oool0203oool00`00
o`00oooo0?ooo`0T0?ooo`030000o`3oool0oooo01l0oooo00<00?l00?ooo`3oool0803oool00280
oooo00<000000?ooo`3oool0P@3oool00`3o0000oooo0?ooo`190?ooo`030?l0003oool0oooo00H0
oooo00<00?l00?ooo`3oool09@3oool00`000?l0oooo0?ooo`0O0?ooo`03003o003oool0oooo0200
oooo000R0?ooo`030000003oool0oooo0800oooo00<0o`000?ooo`3oool0BP3oool00`3o0000oooo
0?ooo`060?ooo`03003o003oool0oooo02@0oooo00<0003o0?ooo`3oool08@3oool00`00o`00oooo
0?ooo`0O0?ooo`008P3oool00`000000oooo0?ooo`200?ooo`030?l0003oool0oooo04/0oooo00<0
o`000?ooo`3oool0103oool00`00o`00oooo0?ooo`0T0?ooo`030000o`3oool0oooo02<0oooo00<0
0?l00?ooo`3oool07P3oool00280oooo00<000000?ooo`3oool0P03oool00`3o0000oooo0?ooo`1;
0?ooo`030?l0003oool0oooo00@0oooo00<00?l00?ooo`3oool08`3oool00`000?l0oooo0?ooo`0T
0?ooo`03003o003oool0oooo01h0oooo000R0?ooo`030000003oool0oooo07l0oooo00<0o`000?oo
o`3oool0C@3oool00`3o0000oooo0?ooo`020?ooo`03003o003oool0oooo02@0oooo00<0003o0?oo
o`3oool09@3oool00`00o`00oooo0?ooo`0M0?ooo`008P3oool00`000000oooo0?ooo`1o0?ooo`03
0?l0003oool0oooo04d0oooo00<0o`000?ooo`3oool00P3oool00`00o`00oooo0?ooo`0S0?ooo`03
0000o`3oool0oooo02L0oooo00<00?l00?ooo`3oool0703oool00280oooo00<000000?ooo`3oool0
O`3oool00`3o0000oooo0?ooo`1>0?ooo`040?l0003oool0oooo003o02D0oooo00<0003o0?ooo`3o
ool0:03oool00`00o`00oooo0?ooo`0L0?ooo`008P3oool2000007l0oooo00<0o`000?ooo`3oool0
D03oool00`3o0000oooo003o000U0?ooo`030000o`3oool0oooo02T0oooo00<00?l00?ooo`3oool0
6`3oool00280oooo00<000000?ooo`3oool0OP3oool00`3o0000oooo0?ooo`1@0?ooo`030?l00000
o`00oooo02@0oooo00<0003o0?ooo`3oool0:P3oool00`00o`00oooo0?ooo`0K0?ooo`008P3oool0
0`000000oooo0?ooo`1m0?ooo`030?l0003oool0oooo0540oooo00<00?l00?l0003oool08`3oool0
0`000?l0oooo0?ooo`0/0?ooo`03003o003oool0oooo01X0oooo000R0?ooo`030000003oool0oooo
07d0oooo00<0o`000?ooo`3oool0D@3oool00`00o`00o`000?ooo`0S0?ooo`030000o`3oool0oooo
02d0oooo00<00?l00?ooo`3oool06@3oool00280oooo00<000000?ooo`3oool0O@3oool00`3o0000
oooo0?ooo`1@0?ooo`04003o003oool0oooo0?l00280oooo00<0003o0?ooo`3oool0;P3oool00`00
o`00oooo0?ooo`0I0?ooo`008P3oool00`000000oooo0?ooo`0i0?ooo`D00000?@3oool00`000000
o`000000000l0?ooo`<000004`3oool01000o`00oooo0?ooo`3o000Q0?ooo`030000o`3oool0oooo
00@00000;03oool00`00o`00oooo0?ooo`090?ooo`D000000`3oool4000000<0oooo000R0?ooo`03
0000003oool0oooo03T0oooo00D000000?ooo`3oool0oooo0000000n0?ooo`030?l0003oool0oooo
03X0oooo00D000000?ooo`3oool0oooo0000000A0?ooo`03003o003oool0oooo0080oooo00<0o`00
0?ooo`3oool07P3oool00`000?l0oooo000000040?ooo`030000003oool0oooo02X0oooo00<00?l0
0?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0@000001
0?ooo`40oooo000R0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0?`3oool00`3o
0000oooo0?ooo`0j0?ooo`050000003oool0oooo0?ooo`0000004@3oool00`00o`00oooo0?ooo`02
0?ooo`030?l0003oool0oooo01d0oooo00@0003o0?ooo`3oool00000103oool00`000000oooo0?oo
o`0Z0?ooo`03003o003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`4000000@3oool10?ooo`008P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0
oooo03X0oooo0`0000000`3o000000000000000k0?ooo`050000003oool0oooo0?ooo`000000403o
ool00`00o`00oooo0?ooo`040?ooo`030?l0003oool0oooo01`0oooo00@0003o0?ooo`3oool00000
103oool00`000000oooo0?ooo`0[0?ooo`03003o003oool0oooo00T0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`4000000@3oool10?ooo`008P3oool00`000000oooo0?oo
o`0l0?ooo`030000003oool0oooo03X0oooo00@000000?ooo`3o00000000?03oool400000100oooo
00<00?l00?ooo`3oool01@3oool00`3o0000oooo0?ooo`0K0?ooo`030000o`3oool0oooo0080oooo
1000000^0?ooo`03003o003oool0oooo00T0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`020?ooo`4000000@3oool10?ooo`008P3oool2000003h0oooo00<000000?ooo`3oool0>@3o
ool010000000o`000?ooo`00000l0?ooo`030000003oool0oooo0140oooo00<00?l00?ooo`3oool0
1P3oool00`3o0000oooo0?ooo`0J0?ooo`050000o`3oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`0/0?ooo`03003o003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`4000000@3oool10?ooo`008P3oool00`000000oooo0?ooo`0i0?ooo`050000
003oool0oooo0?ooo`000000?03oool00`3o0000oooo0000000m0?ooo`030000003oool0oooo00l0
oooo00<00?l00?ooo`3oool01`3oool00`3o0000oooo0?ooo`0I0?ooo`030000o`3oool0oooo0080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0]0?ooo`03003o003oool0oooo00D0
oooo0`0000040?ooo`030000003oool0oooo0080oooo0@0000010?ooo`40oooo000R0?ooo`030000
003oool0oooo03X0oooo0`00000m0?ooo`030?l000000000000003h0oooo0`00000>0?ooo`03003o
003oool0oooo00P0oooo00<0o`000?ooo`3oool0603oool00`000?l0oooo0?ooo`030?ooo`@00000
<03oool00`00o`00oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo100000030?ooo`008P3o
ool00`000000oooo0?ooo`1i0?ooo`030?l0003oool0oooo04l0oooo00<00?l00?ooo`3oool02@3o
ool00`3o0000oooo0?ooo`0G0?ooo`030000o`3oool0oooo03T0oooo00<00?l00?ooo`3oool04`3o
ool00280oooo00<000000?ooo`3oool0N@3oool00`3o0000oooo0?ooo`1?0?ooo`03003o003oool0
oooo00X0oooo00<0o`000?ooo`3oool05P3oool00`000?l0oooo0?ooo`0j0?ooo`03003o003oool0
oooo0180oooo000R0?ooo`030000003oool0oooo07T0oooo00<0o`000?ooo`3oool0CP3oool00`00
o`00oooo0?ooo`0;0?ooo`030?l0003oool0oooo01D0oooo00<0003o0?ooo`3oool0>`3oool00`00
o`00oooo0?ooo`0B0?ooo`008P3oool00`000000oooo0?ooo`1h0?ooo`030?l0003oool0oooo04l0
oooo00<00?l00?ooo`3oool0303oool00`3o0000oooo0?ooo`0C0?ooo`030000o`3oool0oooo03d0
oooo00<00?l00?ooo`3oool04@3oool00280oooo00<000000?ooo`3oool0N03oool00`3o0000oooo
0?ooo`1>0?ooo`03003o003oool0oooo00d0oooo00<0o`000?ooo`3oool04`3oool00`000?l0oooo
0?ooo`0n0?ooo`03003o003oool0oooo0100oooo000R0?ooo`030000003oool0oooo07L0oooo00<0
o`000?ooo`3oool0C`3oool00`00o`00oooo0?ooo`0>0?ooo`030?l0003oool0oooo0140oooo00<0
003o0?ooo`3oool0?`3oool00`00o`00oooo0?ooo`0@0?ooo`008P3oool00`000000oooo0?ooo`1g
0?ooo`030?l0003oool0oooo04h0oooo00<00?l00?ooo`3oool03`3oool00`3o0000oooo0?ooo`0A
0?ooo`030000o`3oool0oooo0400oooo00<00?l00?ooo`3oool03`3oool00280oooo00<000000?oo
o`3oool0M`3oool00`3o0000oooo0?ooo`1>0?ooo`03003o003oool0oooo0100oooo00<0o`000?oo
o`3oool03`3oool00`000?l0oooo0?ooo`110?ooo`03003o003oool0oooo00l0oooo000J0?ooo`P0
00008`000?mF000000030?l000000000000004h0000000<00?l00000000000004@0000000`3o0000
00000000000?000000030000o`00000000000480000000<00?l00000000000003P0000000280oooo
00<0o`000?ooo`3oool03@3oool00`000000oooo003o0006003o00H0oooo00@000000?ooo`3oool0
oooo1`000?l50?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01`3oool00`3o0000
oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02@3oool01@00o`00
oooo0?ooo`3oool0000000l0oooo00<000000?l0003oool0303oool00`000000oooo0000o`0=0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00H0oooo00<00?l00?ooo`3oool0103oool00`000000oooo0?ooo`060?oo
o`008P3oool00`000000o`000?ooo`0F0?ooo`@00?l03@3oool50000oa00oooo00<000000?ooo`3o
ool0=`3oool00`3o0000oooo0?ooo`020?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3o
ool0203oool00`00o`00oooo0?ooo`0C0?ooo`030?l0003oool0oooo00d0oooo00<0003o0?ooo`3o
ool02`3oool00`000000oooo0?ooo`0f0?ooo`03003o003oool0oooo00@0oooo00<000000?ooo`3o
ool01P3oool00280oooo00<000000?l0003oool06P3oool3003o00l0oooo1`000?m20?ooo`030?l0
003oool0oooo04h0oooo00<00?l00?ooo`3oool0503oool00`3o0000oooo0?ooo`0;0?ooo`030000
o`3oool0oooo04H0oooo00<00?l00?ooo`3oool0303oool00280oooo00<000000?l0003oool07@3o
ool2003o01@0oooo10000?ln0?ooo`030?l0003oool0oooo04d0oooo00<00?l00?ooo`3oool05@3o
ool00`3o0000oooo0?ooo`0;0?ooo`030000o`3oool0oooo04L0oooo00<00?l00?ooo`3oool02`3o
ool00280oooo00<000000?ooo`3o00007`3oool2003o01H0oooo0P000?lk0?ooo`030?l0003oool0
oooo04h0oooo00<00?l00?ooo`3oool05P3oool00`3o0000oooo0?ooo`090?ooo`030000o`3oool0
oooo04P0oooo00<00?l00?ooo`3oool02`3oool00280oooo00<000000?ooo`3o00008@3oool2003o
01H0oooo0P000?li0?ooo`030?l0003oool0oooo04d0oooo00<00?l00?ooo`3oool0603oool00`3o
0000oooo0?ooo`080?ooo`030000o`3oool0oooo04T0oooo00<00?l00?ooo`3oool02P3oool00280
oooo00<000000?ooo`3o00008`3oool2003o01H0oooo0P000?lg0?ooo`030?l0003oool0oooo04d0
oooo00<00?l00?ooo`3oool0603oool00`3o0000oooo0?ooo`070?ooo`030000o`3oool0oooo04/0
oooo00<00?l00?ooo`3oool02@3oool00280oooo00<000000?ooo`3o00009@3oool2003o01H0oooo
0P000?ld0?ooo`030?l0003oool0oooo04d0oooo00<00?l00?ooo`3oool06P3oool00`3o0000oooo
0?ooo`050?ooo`030000o`3oool0oooo04`0oooo00<00?l00?ooo`3oool02@3oool00280oooo00@0
00000?ooo`3oool0o`009P3oool00`00o`00oooo0?ooo`0E0?ooo`80003o<P3oool00`3o0000oooo
0?ooo`1=0?ooo`03003o003oool0oooo01X0oooo00<0o`000?ooo`3oool01@3oool00`000?l0oooo
0?ooo`1=0?ooo`03003o003oool0o`0000P0oooo000R0?ooo`80000000<0oooo0?l0003oool09P3o
ool00`00o`00oooo0?ooo`0F0?ooo`80003o<03oool00`3o0000oooo0?ooo`1<0?ooo`03003o003o
ool0oooo01`0oooo00<0o`000?ooo`3oool00`3oool00`000?l0oooo0?ooo`1?0?ooo`03003o003o
ool0oooo00L0oooo000R0?ooo`040000003oool0oooo0?l002P0oooo0P00o`0H0?ooo`80003o;@3o
ool00`3o0000oooo0?ooo`1=0?ooo`03003o003oool0oooo01`0oooo00<0o`000?ooo`3oool00`3o
ool00`000?l0oooo0?ooo`1?0?ooo`03003o003oool0oooo00L0oooo000R0?ooo`050000003oool0
oooo0?ooo`3o0000:@3oool00`00o`00oooo0?ooo`0G0?ooo`80003o:`3oool00`3o0000oooo0?oo
o`1<0?ooo`03003o003oool0oooo01h0oooo00D0o`000?ooo`3oool0oooo0000o`1A0?ooo`030?l0
003oool00?l000P0oooo000R0?ooo`050000003oool0oooo0?ooo`3o0000:P3oool2003o01T0oooo
0P000?lY0?ooo`030?l0003oool0oooo04/0oooo00<00?l00?ooo`3oool07`3oool0103o0000oooo
0?ooo`000?mA0?ooo`030?l0003oool0oooo00T0oooo000R0?ooo`050000003oool0oooo0?ooo`3o
0000;03oool00`00o`00oooo0?ooo`0H0?ooo`80003o9P3oool00`3o0000oooo0?ooo`1<0?ooo`03
003o003oool0oooo0200oooo00<0o`000?ooo`000?l0D@3oool00`3o0000oooo0?ooo`090?ooo`00
8P3oool00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo02X0oooo0P00o`0J0?ooo`80003o
903oool00`3o0000oooo0?ooo`1;0?ooo`03003o003oool0oooo0240oooo00<0o`000000o`3oool0
D03oool00`3o0000oooo0?ooo`0:0?ooo`008P3oool00`000000oooo0?ooo`020?ooo`030?l0003o
ool0oooo02`0oooo00<00?l00?ooo`3oool06@3oool00`000?l0oooo0?ooo`0P0?ooo`030?l0003o
ool0oooo04`0oooo00<00?l00?ooo`3oool08P3oool00`000?l0oooo0?ooo`1>0?ooo`030?l0003o
ool0oooo00/0oooo000R0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool0;@3oool0
0`00o`00oooo0?ooo`0I0?ooo`030000o`3oool0oooo01l0oooo00<0o`000?ooo`3oool0B`3oool0
0`00o`00oooo0?ooo`0R0?ooo`030000o`3o0000oooo04l0oooo00<0o`000?ooo`3oool02`3oool0
0280oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?ooo`0]0?ooo`03003o003oool0oooo
01T0oooo0P000?lO0?ooo`030?l0003oool0oooo04/0oooo00<00?l00?ooo`3oool08P3oool00`00
0?l0oooo0?l0001>0?ooo`030?l0003oool0oooo00`0oooo000R0?ooo`030000003oool0oooo00<0
oooo00<0o`000?ooo`3oool0;P3oool00`00o`00oooo0?ooo`0J0?ooo`030000o`3oool0oooo01/0
oooo00<0o`000?ooo`3oool0B`3oool00`00o`00oooo0?ooo`0R0?ooo`050000o`3oool0oooo0?oo
o`3o0000C03oool00`3o0000oooo0?ooo`0=0?ooo`008P3oool00`000000oooo0?ooo`030?ooo`03
0?l0003oool0oooo02l0oooo00<00?l00?ooo`3oool06P3oool00`000?l0oooo0?ooo`0J0?ooo`03
0?l0003oool0oooo04/0oooo00<00?l00?ooo`3oool08@3oool00`000?l0oooo0?ooo`020?ooo`03
0?l0003oool0oooo04X0oooo00<0o`000?ooo`3oool03@3oool00280oooo0P0000040?ooo`030?l0
003oool0oooo0300oooo00<00?l00?ooo`3oool06P3oool00`000?l0oooo0?ooo`0I0?ooo`030?l0
003oool0oooo04X0oooo00<00?l00?ooo`3oool08P3oool00`000?l0oooo0?ooo`030?ooo`030?l0
003oool0oooo04P0oooo00<0o`000?ooo`3oool03P3oool00280oooo00<000000?ooo`3oool0103o
ool00`3o0000oooo0?ooo`0`0?ooo`03003o003oool0oooo01X0oooo00<0003o0?ooo`3oool05`3o
ool00`3o0000oooo0?ooo`1;0?ooo`03003o003oool0oooo0240oooo00<0003o0?ooo`3oool0103o
ool00`3o0000oooo0?ooo`180?ooo`030?l0003oool0oooo00h0oooo000R0?ooo`030000003oool0
oooo00@0oooo00<0o`000?ooo`3oool0<@3oool00`00o`00oooo0?ooo`0J0?ooo`80003o5`3oool0
0`3o0000oooo0?ooo`1:0?ooo`03003o003oool0oooo0280oooo00<0003o0?ooo`3oool01@3oool0
0`3o0000oooo0?ooo`160?ooo`030?l0003oool0oooo00l0oooo000R0?ooo`030000003oool0oooo
00@0oooo00<0o`000?ooo`3oool0<P3oool00`00o`00oooo0?ooo`0K0?ooo`030000o`3oool0oooo
01<0oooo00<0o`000?ooo`3oool0B`3oool00`00o`00oooo0?ooo`0Q0?ooo`030000o`3oool0oooo
00H0oooo00<0o`000?ooo`3oool0A@3oool00`3o0000oooo0?ooo`0@0?ooo`008P3oool00`000000
oooo0?ooo`050?ooo`030?l0003oool0oooo0380oooo00<00?l00?ooo`3oool06`3oool00`000?l0
oooo0?ooo`0B0?ooo`030?l0003oool0oooo04X0oooo00<00?l00?ooo`3oool08@3oool00`000?l0
oooo0?ooo`080?ooo`030?l0003oool0oooo04@0oooo00<0o`000?ooo`3oool0403oool00280oooo
00<000000?ooo`3oool01@3oool00`3o0000oooo0?ooo`0c0?ooo`03003o003oool0oooo01/0oooo
00<0003o0?ooo`3oool04@3oool00`3o0000oooo0?ooo`1:0?ooo`03003o003oool0oooo0240oooo
00<0003o0?ooo`3oool0203oool00`3o0000oooo0?ooo`130?ooo`030?l0003oool0oooo0140oooo
000R0?ooo`030000003oool0oooo00D0oooo00<0o`000?ooo`3oool0=03oool00`00o`00oooo0?oo
o`0K0?ooo`030000o`3oool0oooo00l0oooo00<0o`000?ooo`3oool0BP3oool00`00o`00oooo0?oo
o`0Q0?ooo`030000o`3oool0oooo00X0oooo00<0o`000?ooo`3oool0@@3oool00`3o0000oooo0?oo
o`0B0?ooo`008P3oool00`000000oooo0?ooo`060?ooo`030?l0003oool0oooo03@0oooo00<00?l0
0?ooo`3oool06`3oool20000o`l0oooo00<0o`000?ooo`3oool0BP3oool00`00o`00oooo0?ooo`0Q
0?ooo`030000o`3oool0oooo00X0oooo00<0o`000?ooo`3oool0@@3oool00`3o0000oooo0?ooo`0B
0?ooo`008P3oool00`000000oooo0?ooo`060?ooo`030?l0003oool0oooo03D0oooo00<00?l00?oo
o`3oool0703oool00`000?l0oooo0?ooo`0<0?ooo`030?l0003oool0oooo04T0oooo00<00?l00?oo
o`3oool08@3oool00`000?l0oooo0?ooo`0<0?ooo`030?l0003oool0oooo03l0oooo00<0o`000?oo
o`3oool04`3oool00280oooo00<000000?ooo`3oool01P3oool00`3o0000oooo0?ooo`0f0?ooo`03
003o003oool0oooo01`0oooo00<0003o0?ooo`3oool02P3oool00`3o0000oooo0?ooo`1:0?ooo`03
003o003oool0oooo0240oooo00<0003o0?ooo`3oool03@3oool00`3o0000oooo0?ooo`0m0?ooo`03
0?l0003oool0oooo01@0oooo000R0?ooo`800000203oool00`3o0000oooo0?ooo`0f0?ooo`03003o
003oool0oooo01`0oooo00<0003o0?ooo`3oool02@3oool00`3o0000oooo0?ooo`190?ooo`03003o
003oool0oooo0240oooo00<0003o0?ooo`3oool03P3oool00`3o0000oooo0?ooo`0m0?ooo`030?l0
003oool0oooo01@0oooo000R0?ooo`030000003oool0oooo00L0oooo00<0o`000?ooo`3oool0=`3o
ool00`00o`00oooo0?ooo`0L0?ooo`030000o`3oool0oooo00L0oooo00<0o`000?ooo`3oool0BP3o
ool00`00o`00oooo0?ooo`0P0?ooo`030000o`3oool0oooo0100oooo00<0o`000?ooo`3oool0>`3o
ool00`3o0000oooo0?ooo`0E0?ooo`008P3oool00`000000oooo0?ooo`070?ooo`030?l0003oool0
oooo03L0oooo00<00?l00?ooo`3oool07@3oool00`000?l0oooo0?ooo`060?ooo`030?l0003oool0
oooo04T0oooo00<00?l00?ooo`3oool08@3oool00`000?l0oooo0?ooo`0@0?ooo`030?l0003oool0
oooo03X0oooo00<0o`000?ooo`3oool05P3oool00280oooo00<000000?ooo`3oool0203oool00`3o
0000oooo0?ooo`0g0?ooo`03003o003oool0oooo01d0oooo0P000?l60?ooo`030?l0003oool0oooo
04T0oooo00<00?l00?ooo`3oool0803oool00`000?l0oooo0?ooo`0B0?ooo`030?l0003oool0oooo
03T0oooo00<0o`000?ooo`3oool05P3oool00280oooo00<000000?ooo`3oool0203oool00`3o0000
oooo0?ooo`0h0?ooo`03003o003oool0oooo01h0oooo00<0003o0?ooo`3oool00P3oool00`3o0000
oooo0?ooo`190?ooo`03003o003oool0oooo0240oooo00<0003o0?ooo`3oool04`3oool00`3o0000
oooo0?ooo`0g0?ooo`030?l0003oool0oooo01L0oooo000R0?ooo`030000003oool0oooo00P0oooo
00<0o`000?ooo`3oool0>@3oool00`00o`00oooo0?ooo`0N0?ooo`050000o`3oool0oooo0?ooo`3o
0000B`3oool00`00o`00oooo0?ooo`0P0?ooo`030000o`3oool0oooo01@0oooo00<0o`000?ooo`3o
ool0=P3oool00`3o0000oooo0?ooo`0H0?ooo`008P3oool00`000000oooo0?ooo`080?ooo`030?l0
003oool0oooo03X0oooo00<00?l00?ooo`3oool07P3oool010000?l0oooo0?ooo`3o001:0?ooo`03
003o003oool0oooo0240oooo00<0003o0?ooo`3oool05@3oool00`3o0000oooo0?ooo`0e0?ooo`03
0?l0003oool0oooo01P0oooo000R0?ooo`030000003oool0oooo00T0oooo00<0o`000?ooo`3oool0
>P3oool00`00o`00oooo0?ooo`0N0?ooo`030000o`3o0000oooo04X0oooo00<00?l00?ooo`3oool0
803oool00`000?l0oooo0?ooo`0F0?ooo`030?l0003oool0oooo03@0oooo00<0o`000?ooo`3oool0
6@3oool000P0oooo100000050?ooo`800000103oool5000000H0oooo00<000000?ooo`3oool02@3o
ool00`3o0000oooo0?ooo`0k0?ooo`03003o003oool0oooo01h0oooo00<0003o0?ooo`3oool0B03o
ool00`00o`00oooo0?ooo`0P0?ooo`030000o`3oool0oooo01P0oooo00<0o`000?ooo`3oool0<P3o
ool00`3o0000oooo0?ooo`0J0?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?oo
o`090?ooo`030?l0003oool0oooo03`0oooo00<00?l00?ooo`3oool0703oool00`3o0000oooo0000
o`190?ooo`03003o003oool0oooo0200oooo00<0003o0?ooo`3oool06@3oool00`3o0000oooo0?oo
o`0`0?ooo`030?l0003oool0oooo01/0oooo00070?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<0o`00
0?ooo`3oool0>`3oool00`00o`00oooo0?ooo`0L0?ooo`040?l0003oool0oooo0000odL0oooo00<0
0?l00?ooo`3oool0803oool00`000?l0oooo0?ooo`0K0?ooo`030?l0003oool0oooo02h0oooo00<0
o`000?ooo`3oool0703oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00H0oooo0`00000:0?ooo`030?l0003oool0oooo03`0oooo00<00?l0
0?ooo`3oool06`3oool01@3o0000oooo0?ooo`3oool0003o04H0oooo00<00?l00?ooo`3oool0803o
ool00`000?l0oooo0?ooo`0L0?ooo`030?l0003oool0oooo02`0oooo00<0o`000?ooo`3oool07@3o
ool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool02P3oool00`3o0000oooo0?ooo`0m0?ooo`03003o003oool0
oooo01T0oooo00<0o`000?ooo`3oool00`3oool00`000?l0oooo0?ooo`120?ooo`03003o003oool0
oooo0200oooo00<0003o0?ooo`3oool07@3oool00`3o0000oooo0?ooo`0/0?ooo`030?l0003oool0
oooo01d0oooo00070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<0o`000?ooo`3oool0?@3oool00`00
o`00oooo0?ooo`0H0?ooo`030?l0003oool0oooo00<0oooo00<0003o0?ooo`3oool0@@3oool00`00
o`00oooo0?ooo`0Q0?ooo`030000o`3oool0oooo01h0oooo00<0o`000?ooo`3oool0:P3oool00`3o
0000oooo0?ooo`0N0?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0
oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00/0oooo00<0o`000?oo
o`3oool0?P3oool00`00o`00oooo0?ooo`0G0?ooo`030?l0003oool0oooo00@0oooo00<0003o0?oo
o`3oool0@03oool00`00o`00oooo0?ooo`0P0?ooo`030000o`3oool0oooo0200oooo00<0o`000?oo
o`3oool0:03oool00`3o0000oooo0?ooo`0O0?ooo`00203oool4000000`0oooo0`0000070?ooo`03
0000003oool0oooo00/0oooo00<0o`000?ooo`3oool0?`3oool00`00o`00oooo0?ooo`0E0?ooo`03
0?l0003oool0oooo00H0oooo00<0003o0?ooo`3oool0?P3oool00`00o`00oooo0?ooo`0P0?ooo`03
0000o`3oool0oooo0280oooo00<0o`000?ooo`3oool09P3oool00`3o0000oooo0?ooo`0P0?ooo`00
8P3oool00`000000oooo0?ooo`0<0?ooo`030?l0003oool0oooo03h0oooo00<00?l00?ooo`3oool0
5@3oool00`3o0000oooo0?ooo`070?ooo`030000o`3oool0oooo03d0oooo00<00?l00?ooo`3oool0
803oool00`000?l0oooo0?ooo`0S0?ooo`030?l0003oool0oooo02@0oooo00<0o`000?ooo`3oool0
8@3oool00280oooo00<000000?ooo`3oool0303oool00`3o0000oooo0?ooo`0o0?ooo`03003o003o
ool0oooo01<0oooo00<0o`000?ooo`3oool02@3oool00`000?l0oooo0?ooo`0k0?ooo`03003o003o
ool0oooo0200oooo00<0003o0?ooo`3oool09@3oool00`3o0000oooo0?ooo`0R0?ooo`030?l0003o
ool0oooo0280oooo000R0?ooo`030000003oool0oooo00d0oooo00<0o`000?ooo`3oool0?`3oool0
0`00o`00oooo0?ooo`0B0?ooo`030?l0003oool0oooo00X0oooo00<0003o0?ooo`3oool0>@3oool0
0`00o`00oooo0?ooo`0Q0?ooo`030000o`3oool0oooo02H0oooo00<0o`000?ooo`3oool07`3oool2
0?l002D0oooo000R0?ooo`030000003oool0oooo00d0oooo00<0o`000?ooo`3oool0@03oool00`00
o`00oooo0?ooo`0A0?ooo`030?l0003oool0oooo00/0oooo00<0003o0?ooo`3oool0>03oool00`00
o`00oooo0?ooo`0P0?ooo`030000o`3oool0oooo02P0oooo00<0o`000?ooo`3oool07@3oool00`3o
0000oooo0?ooo`0U0?ooo`008P3oool00`000000oooo0?ooo`0=0?ooo`030?l0003oool0oooo0440
oooo00<00?l00?ooo`3oool03`3oool00`3o0000oooo0?ooo`0=0?ooo`030000o`3oool0oooo03H0
oooo00<00?l00?ooo`3oool08@3oool00`000?l0oooo0?ooo`0Y0?ooo`030?l0003oool0oooo01/0
oooo00<0o`000?ooo`3oool09P3oool00280oooo0P00000?0?ooo`030?l0003oool0oooo0440oooo
00<00?l00?ooo`3oool03P3oool00`3o0000oooo0?ooo`0>0?ooo`030000o`3oool0oooo03@0oooo
00<00?l00?ooo`3oool08@3oool00`000?l0oooo0?ooo`0[0?ooo`80o`006P3oool00`3o0000oooo
0?ooo`0W0?ooo`008P3oool00`000000oooo0?ooo`0>0?ooo`030?l0003oool0oooo0440oooo00<0
0?l00?ooo`3oool03P3oool00`3o0000oooo0?ooo`0?0?ooo`030000o`3oool0oooo03<0oooo00<0
0?l00?ooo`3oool0803oool00`000?l0oooo0?ooo`0^0?ooo`030?l0003oool0oooo01D0oooo0P3o
000Z0?ooo`008P3oool00`000000oooo0?ooo`0>0?ooo`030?l0003oool0oooo0480oooo00<00?l0
0?ooo`3oool0303oool00`3o0000oooo0?ooo`0A0?ooo`030000o`3oool0oooo0340oooo00<00?l0
0?ooo`3oool0803oool00`000?l0oooo0?ooo`0`0?ooo`030?l0003oool0oooo01<0oooo00<0o`00
0?ooo`3oool0:P3oool00280oooo00<000000?ooo`3oool03`3oool00`3o0000oooo0?ooo`120?oo
o`03003o003oool0oooo00/0oooo00<0o`000?ooo`3oool04P3oool00`000?l0oooo0?ooo`0`0?oo
o`03003o003oool0oooo0200oooo00<0003o0?ooo`3oool0<@3oool20?l00140oooo0P3o000]0?oo
o`008P3oool00`000000oooo0?ooo`0?0?ooo`030?l0003oool0oooo04<0oooo00<00?l00?ooo`3o
ool02@3oool00`3o0000oooo0?ooo`0D0?ooo`030000o`3oool0oooo02h0oooo00<00?l00?ooo`3o
ool0803oool00`000?l0oooo0?ooo`0d0?ooo`@0o`002P3oool30?l002l0oooo000R0?ooo`030000
003oool0oooo00l0oooo00<0o`000?ooo`3oool0A03oool00`00o`00oooo0?ooo`080?ooo`030?l0
003oool0oooo01D0oooo0P000?l]0?ooo`03003o003oool0oooo0200oooo00<0003o0?ooo`3oool0
>@3oool:0?l00380oooo000R0?ooo`030000003oool0oooo0100oooo00<0o`000?ooo`3oool0A03o
ool00`00o`00oooo0?ooo`070?ooo`030?l0003oool0oooo01L0oooo00<0003o0?ooo`3oool0:P3o
ool00`00o`00oooo0?ooo`0O0?ooo`030000o`3oool0oooo07H0oooo000R0?ooo`030000003oool0
oooo0100oooo00<0o`000?ooo`3oool0A03oool00`00o`00oooo0?ooo`060?ooo`030?l0003oool0
oooo01T0oooo00<0003o0?ooo`3oool0:03oool00`00o`00oooo0?ooo`0O0?ooo`030000o`3oool0
oooo07L0oooo000R0?ooo`030000003oool0oooo0100oooo00<0o`000?ooo`3oool0A@3oool00`00
o`00oooo0?ooo`050?ooo`030?l0003oool0oooo01X0oooo00<0003o0?ooo`3oool09`3oool00`00
o`00oooo0?ooo`0N0?ooo`030000o`3oool0oooo07P0oooo000R0?ooo`030000003oool0oooo0140
oooo00<0o`000?ooo`3oool0A@3oool00`00o`00oooo0?ooo`030?ooo`030?l0003oool0oooo01`0
oooo00<0003o0?ooo`3oool09@3oool00`00o`00oooo0?ooo`0O0?ooo`030000o`3oool0oooo07P0
oooo000R0?ooo`030000003oool0oooo0140oooo00<0o`000?ooo`3oool0AP3oool00`00o`00oooo
0?ooo`020?ooo`030?l0003oool0oooo01d0oooo00<0003o0?ooo`3oool08`3oool00`00o`00oooo
0?ooo`0O0?ooo`030000o`3oool0oooo07T0oooo000R0?ooo`8000004`3oool00`3o0000oooo0?oo
o`160?ooo`05003o003oool0oooo0?ooo`3o0000803oool00`000?l0oooo0?ooo`0Q0?ooo`03003o
003oool0oooo01l0oooo00<0003o0?ooo`3oool0NP3oool00280oooo00<000000?ooo`3oool04P3o
ool00`3o0000oooo0?ooo`170?ooo`03003o003oool0o`000280oooo00<0003o0?ooo`3oool0803o
ool00`00o`00oooo0?ooo`0N0?ooo`030000o`3oool0oooo07/0oooo000R0?ooo`030000003oool0
oooo0180oooo00<0o`000?ooo`3oool0A`3oool00`00o`00oooo0?l0000S0?ooo`030000o`3oool0
oooo01h0oooo00<00?l00?ooo`3oool07P3oool00`000?l0oooo0?ooo`1l0?ooo`008P3oool00`00
0000oooo0?ooo`0C0?ooo`030?l0003oool0oooo04L0oooo00<00?l00?l0003oool08`3oool00`00
0?l0oooo0?ooo`0L0?ooo`03003o003oool0oooo01h0oooo00<0003o0?ooo`3oool0O@3oool00280
oooo00<000000?ooo`3oool04`3oool00`3o0000oooo0?ooo`170?ooo`030?l00000o`00oooo02@0
oooo00<0003o0?ooo`3oool06P3oool00`00o`00oooo0?ooo`0O0?ooo`030000o`3oool0oooo07d0
oooo000R0?ooo`030000003oool0oooo01<0oooo00<0o`000?ooo`3oool0A`3oool00`3o0000oooo
003o000U0?ooo`030000o`3oool0oooo01T0oooo00<00?l00?ooo`3oool07P3oool00`000?l0oooo
0?ooo`1n0?ooo`008P3oool00`000000oooo0?ooo`0D0?ooo`030?l0003oool0oooo04D0oooo00D0
o`000?ooo`3oool0oooo003o000U0?ooo`030000o`3oool0oooo01L0oooo00<00?l00?ooo`3oool0
7P3oool00`000?l0oooo0?ooo`1o0?ooo`008P3oool00`000000oooo0?ooo`0D0?ooo`030?l0003o
ool0oooo04D0oooo00<0o`000?ooo`3oool00P3oool00`00o`00oooo0?ooo`0S0?ooo`030000o`3o
ool0oooo01D0oooo00<00?l00?ooo`3oool07P3oool00`000?l0oooo0?ooo`200?ooo`008P3oool0
0`000000oooo0?ooo`0D0?ooo`030?l0003oool0oooo04D0oooo00<0o`000?ooo`3oool00`3oool0
0`00o`00oooo0?ooo`0S0?ooo`030000o`3oool0oooo01<0oooo00<00?l00?ooo`3oool07P3oool0
0`000?l0oooo0?ooo`210?ooo`008P3oool00`000000oooo0?ooo`0E0?ooo`030?l0003oool0oooo
04<0oooo00<0o`000?ooo`3oool01@3oool00`00o`00oooo0?ooo`0S0?ooo`030000o`3oool0oooo
0180oooo00<00?l00?ooo`3oool07@3oool00`000?l0oooo0?ooo`220?ooo`008P3oool00`000000
oooo0?ooo`0E0?ooo`030?l0003oool0oooo04<0oooo00<0o`000?ooo`3oool01@3oool00`00o`00
oooo0?ooo`0T0?ooo`80003o4@3oool00`00o`00oooo0?ooo`0M0?ooo`030000o`3oool0oooo08<0
oooo000R0?ooo`8000005P3oool00`3o0000oooo0?ooo`130?ooo`030?l0003oool0oooo00H0oooo
00<00?l00?ooo`3oool09@3oool00`000?l0oooo0?ooo`0=0?ooo`03003o003oool0oooo01d0oooo
00<0003o0?ooo`3oool0Q03oool00280oooo00<000000?ooo`3oool05P3oool00`3o0000oooo0?oo
o`110?ooo`030?l0003oool0oooo00P0oooo00<00?l00?ooo`3oool09@3oool00`000?l0oooo0?oo
o`0;0?ooo`03003o003oool0oooo01d0oooo00<0003o0?ooo`3oool0Q@3oool00280oooo00<00000
0?ooo`3oool05P3oool00`3o0000oooo0?ooo`110?ooo`030?l0003oool0oooo00T0oooo00<00?l0
0?ooo`3oool09@3oool20000o`/0oooo00<00?l00?ooo`3oool0703oool00`000?l0oooo0?ooo`26
0?ooo`008P3oool00`000000oooo0?ooo`0G0?ooo`030?l0003oool0oooo03l0oooo00<0o`000?oo
o`3oool02`3oool00`00o`00oooo0?ooo`0V0?ooo`80003o203oool00`00o`00oooo0?ooo`0K0?oo
o`80003oR@3oool00280oooo00<000000?ooo`3oool05`3oool00`3o0000oooo0?ooo`0o0?ooo`03
0?l0003oool0oooo00`0oooo00<00?l00?ooo`3oool09`3oool20000o`D0oooo00<00?l00?ooo`3o
ool06`3oool00`000?l0oooo0?ooo`290?ooo`008P3oool00`000000oooo0?ooo`0G0?ooo`030?l0
003oool0oooo03l0oooo00<0o`000?ooo`3oool03@3oool00`00o`00oooo0?ooo`0X0?ooo`050000
o`3oool0oooo0?ooo`00o`00703oool20000oh`0oooo000R0?ooo`030000003oool0oooo01P0oooo
00<0o`000?ooo`3oool0?@3oool00`3o0000oooo0?ooo`0?0?ooo`03003o003oool0oooo02P0oooo
0P000?l00`00o`00oooo0?ooo`0I0?ooo`80003oSP3oool000P0oooo100000050?ooo`8000001`3o
ool3000000D0oooo00<000000?ooo`3oool0603oool00`3o0000oooo0?ooo`0m0?ooo`030?l0003o
ool0oooo0100oooo00<00?l00?ooo`3oool0:03oool00`00o`00003o0000o`0H0?ooo`80003oT03o
ool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`800000203oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo01P0oooo00<0o`000?ooo`3oool0?03oool0
0`3o0000oooo0?ooo`0B0?ooo`03003o003oool0oooo02H0oooo00@00?l00?ooo`3oool0oooo0`00
0?lC0?ooo`80003oTP3oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3oool00`3o0000oooo0?ooo`0k
0?ooo`030?l0003oool0oooo01<0oooo0P00o`0U0?ooo`03003o003oool0oooo00D0oooo10000?l:
0?ooo`D0003oU03oool000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`080?oo
o`H000001@3oool3000001T0oooo00<0o`000?ooo`3oool0>P3oool00`3o0000oooo0?ooo`0F0?oo
o`03003o003oool0oooo0240oooo00<00?l00?ooo`3oool02P3oool:0000oiT0oooo00070?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000060?oo
o`030000003oool0oooo01T0oooo00<0o`000?ooo`3oool0>P3oool00`3o0000oooo0?ooo`0G0?oo
o`800?l0803oool00`00o`00oooo0?ooo`2^0?ooo`001`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00T0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`0J0?oo
o`030?l0003oool0oooo03T0oooo00<0o`000?ooo`3oool06@3oool00`00o`00oooo0?ooo`0L0?oo
o`03003o003oool0oooo0:l0oooo00070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool02P3oool00`000000oooo000000060?ooo`030000003oool0oooo01X0oooo00<0o`000?ooo`3o
ool0>03oool00`3o0000oooo0?ooo`0K0?ooo`800?l06`3oool00`00o`00oooo0?ooo`2`0?ooo`00
203oool4000000h0oooo0P0000060?ooo`030000003oool0oooo01/0oooo00<0o`000?ooo`3oool0
=`3oool00`3o0000oooo0?ooo`0M0?ooo`03003o003oool0oooo01H0oooo0P00o`2c0?ooo`008P3o
ool00`000000oooo0?ooo`0K0?ooo`030?l0003oool0oooo03H0oooo00<0o`000?ooo`3oool07`3o
ool2003o01@0oooo0P00o`2e0?ooo`008P3oool00`000000oooo0?ooo`0K0?ooo`030?l0003oool0
oooo03H0oooo00<0o`000?ooo`3oool08@3oool3003o00h0oooo0`00o`2g0?ooo`008P3oool00`00
0000oooo0?ooo`0L0?ooo`030?l0003oool0oooo03@0oooo00<0o`000?ooo`3oool09@3oool>003o
0;X0oooo000R0?ooo`030000003oool0oooo01`0oooo00<0o`000?ooo`3oool0=03oool00`3o0000
oooo0?ooo`3]0?ooo`008P3oool00`000000oooo0?ooo`0L0?ooo`030?l0003oool0oooo03<0oooo
00<0o`000?ooo`3oool0kP3oool00280oooo00<000000?ooo`3oool07@3oool00`3o0000oooo0?oo
o`0b0?ooo`030?l0003oool0oooo0>h0oooo000R0?ooo`8000007P3oool00`3o0000oooo0?ooo`0a
0?ooo`030?l0003oool0oooo0>l0oooo000R0?ooo`030000003oool0oooo01h0oooo00<0o`000?oo
o`3oool0<03oool00`3o0000oooo0?ooo`3_0?ooo`008P3oool00`000000oooo0?ooo`0N0?ooo`03
0?l0003oool0oooo02l0oooo00<0o`000?ooo`3oool0l03oool00280oooo00<000000?ooo`3oool0
7`3oool00`3o0000oooo0?ooo`0]0?ooo`030?l0003oool0oooo0?40oooo000R0?ooo`030000003o
ool0oooo01l0oooo00<0o`000?ooo`3oool0;@3oool00`3o0000oooo0?ooo`3a0?ooo`008P3oool0
0`000000oooo0?ooo`0P0?ooo`030?l0003oool0oooo02/0oooo00<0o`000?ooo`3oool0lP3oool0
0280oooo00<000000?ooo`3oool08@3oool00`3o0000oooo0?ooo`0Z0?ooo`030?l0003oool0oooo
0?80oooo000R0?ooo`030000003oool0oooo0240oooo00<0o`000?ooo`3oool0:@3oool00`3o0000
oooo0?ooo`3c0?ooo`008P3oool00`000000oooo0?ooo`0R0?ooo`030?l0003oool0oooo02P0oooo
00<0o`000?ooo`3oool0l`3oool00280oooo00<000000?ooo`3oool08P3oool00`3o0000oooo0?oo
o`0W0?ooo`030?l0003oool0oooo0?@0oooo000R0?ooo`800000903oool00`3o0000oooo0?ooo`0U
0?ooo`030?l0003oool0oooo0?D0oooo000R0?ooo`030000003oool0oooo02@0oooo00<0o`000?oo
o`3oool0903oool00`3o0000oooo0?ooo`3e0?ooo`008P3oool00`000000oooo0?ooo`0T0?ooo`03
0?l0003oool0oooo02<0oooo00<0o`000?ooo`3oool0mP3oool00280oooo00<000000?ooo`3oool0
9@3oool00`3o0000oooo0?ooo`0Q0?ooo`030?l0003oool0oooo0?L0oooo000R0?ooo`030000003o
ool0oooo02H0oooo00<0o`000?ooo`3oool07`3oool00`3o0000oooo0?ooo`3h0?ooo`008P3oool0
0`000000oooo0?ooo`0V0?ooo`030?l0003oool0oooo01l0oooo00<0o`000?ooo`3oool0n03oool0
0280oooo00<000000?ooo`3oool09`3oool00`3o0000oooo0?ooo`0M0?ooo`030?l0003oool0oooo
0?T0oooo000R0?ooo`030000003oool0oooo02L0oooo00<0o`000?ooo`3oool0703oool00`3o0000
oooo0?ooo`3j0?ooo`008P3oool00`000000oooo0?ooo`0X0?ooo`030?l0003oool0oooo01/0oooo
00<0o`000?ooo`3oool0nP3oool00280oooo00<000000?ooo`3oool0:@3oool00`3o0000oooo0?oo
o`0I0?ooo`030?l0003oool0oooo0?/0oooo000R0?ooo`030000003oool0oooo02X0oooo00<0o`00
0?ooo`3oool05`3oool00`3o0000oooo0?ooo`3l0?ooo`008P3oool2000002`0oooo00<0o`000?oo
o`3oool05@3oool00`3o0000oooo0?ooo`3m0?ooo`008P3oool00`000000oooo0?ooo`0[0?ooo`03
0?l0003oool0oooo01@0oooo00<0o`000?ooo`3oool0oP3oool00280oooo00<000000?ooo`3oool0
;03oool00`3o0000oooo0?ooo`0B0?ooo`030?l0003oool0oooo0?l0oooo000R0?ooo`030000003o
ool0oooo02d0oooo0P3o000A0?ooo`030?l0003oool0oooo0?l0oooo0@3oool00280oooo00<00000
0?ooo`3oool0;`3oool20?l000h0oooo00<0o`000?ooo`3oool0o`3oool20?ooo`008P3oool00`00
0000oooo0?ooo`0a0?ooo`80o`002P3oool20?l00?l0oooo1@3oool00280oooo00<000000?ooo`3o
ool0<`3oool:0?l00?l0oooo1`3oool000P0oooo100000050?ooo`8000001P3oool3000000H0oooo
00<000000?ooo`3oool0o`3ooom40?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo
0?ooo`3o0?oood@0oooo00070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0o`3ooom40?ooo`001`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo
000000050?ooo`<00000o`3ooom40?ooo`001`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00T0oooo100000060?ooo`030000003oool0oooo0?l0ooooA03oool000L0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0?l0ooooCP3oool0
00L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
0?l0ooooC@3oool000P0oooo1000000>0?ooo`<00000o`3ooom<0?ooo`00o`3ooomY0?ooo`00o`3o
oomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3ooomY0?ooo`00o`3o
oomY0?ooo`00\
\>"],
  ImageRangeCache->{{{81, 368}, {312.438, 135.5}} -> {-4.27594, 0.407421, \
0.0394728, 0.00592691}},
  CellTags->"b:1.1.1.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the general solution for ",
  StyleBox["Legendre\[CloseCurlyQuote]s equation ",
    FontSlant->"Italic"],
  "with ",
  Cell[BoxData[
      \(TraditionalForm\`n = 7\)]],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[
      16 \((1 - x^2)\)*\(y''\)[x] - 32  x*\(y'\)[x] + 21*y[x] \[Equal] 0, \ 
      y[x], x]\)], "Input",
  CellLabel->"In[105]:=",
  CellTags->"b:1.1.1.4"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          C[1]\ LegendreP[3\/4, x] + C[2]\ LegendreQ[3\/4, x]}}\)], "Output",
  CellLabel->"Out[105]=",
  CellTags->"b:1.1.1.4"]
}, Open  ]],

Cell[TextData[{
  "These special functions can be expressed in terms of elementary functions \
for certain values of their parameters. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " performs this conversion automatically wherever it is possible."
}], "Text",
  CellTags->"b:1.1.1.4"],

Cell["\<\
These are some of these expressions that are automatically \
converted.\
\>", "MathCaption",
  CellTags->"b:1.1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \({BesselJ[1/2, x], \ LegendreP[4, x], \ HermiteH[5, x]}\)], "Input",
  CellLabel->"In[106]:=",
  CellTags->"b:1.1.1.4"],

Cell[BoxData[
    \({\(\@\(2\/\[Pi]\)\ Sin[x]\)\/\@x, 
      3\/8 - \(15\ x\^2\)\/4 + \(35\ x\^4\)\/8, 
      120\ x - 160\ x\^3 + 32\ x\^5}\)], "Output",
  CellLabel->"Out[106]=",
  CellTags->"b:1.1.1.4"]
}, Open  ]],

Cell["\<\
As a result of these conversions, the solutions of certain ODEs can \
be partially expressed in terms of elementary functions. Hermite\
\[CloseCurlyQuote]s equation is one such ODE. \
\>", "Text",
  CellTags->"b:1.1.1.4"],

Cell[TextData[{
  "Here is the solution for Hermite\[CloseCurlyQuote]s equation with \
arbitrary ",
  StyleBox["n.",
    FontSlant->"Italic"]
}], "MathCaption",
  CellTags->"b:1.1.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y''\)[x] - 2  x*\(y'\)[x] + 2  n*y[x] \[Equal] 0, \ y[x], 
      x]\)], "Input",
  CellLabel->"In[107]:=",
  CellTags->"b:1.1.1.4"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          C[1]\ HermiteH[n, x] + 
            C[2]\ Hypergeometric1F1[\(-\(n\/2\)\), 1\/2, x\^2]}}\)], "Output",\

  CellLabel->"Out[107]=",
  CellTags->"b:1.1.1.4"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["n",
    FontSlant->"Italic"],
  " set to ",
  StyleBox["5", "MR"],
  ", the solution is given in terms of polynomials, exponentials, and ",
  StyleBox["Erfi", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.4"],

Cell[CellGroupData[{

Cell["\<\
Collect[Simplify[PowerExpand[y[x] /. 
     DSolve[y''[x] - 2*x*y'[x] + 10*y[x] == 0, y[x], x][[1]]]], 
     {C[1], C[2]}]\
\>", "Input",
  CellLabel->"In[108]:=",
  CellTags->"b:1.1.1.4"],

Cell[BoxData[
    \(1\/8\ \((960\ x - 1280\ x\^3 + 256\ x\^5)\)\ C[1] + 
      1\/8\ C[2]\ \((8\ \[ExponentialE]\^\(x\^2\) - 
            18\ \[ExponentialE]\^\(x\^2\)\ x\^2 + 
            4\ \[ExponentialE]\^\(x\^2\)\ x\^4 + \@\[Pi]\ x\ \((\(-15\) + 
                  20\ x\^2 - 4\ x\^4)\)\ Erfi[x])\)\)], "Output",
  CellLabel->"Out[108]=",
  CellTags->"b:1.1.1.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hypergeometric Equations", "Subsubsection",
  CellTags->{"HypergeometricODE", "c:23", "b:1.1.1.5"}],

Cell["\<\
The hypergeometric functions play a unifying role in mathematical \
analysis since many important functions, such as the Bessel functions and \
Legendre functions, are special cases of them. Each hypergeometric function \
is associated with a linear ODE having rational coefficients. \
\>", "Text",
  CellTags->"b:1.1.1.5"],

Cell[TextData[{
  "Here is the ODE for the ",
  StyleBox["Hypergeometric2F1", "MR"],
  " function."
}], "MathCaption",
  CellTags->"b:1.1.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\((x^2 - x)\)*\(y''\)[x] + \ \((\((a + b + 1)\)*x - c)\)*\(y'\)[
              x] + b*a*y[x] \[Equal] 0, \ y[x], \ x]\)], "Input",
  CellLabel->"In[109]:=",
  CellTags->"b:1.1.1.5"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          C[1]\ Hypergeometric2F1[a, b, c, 
                x] + \((\(-1\))\)\^\(1 - c\)\ x\^\(1 - c\)\ C[
                2]\ Hypergeometric2F1[1 + a - c, 1 + b - c, 2 - c, 
                x]}}\)], "Output",
  CellLabel->"Out[109]=",
  CellTags->"b:1.1.1.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["DSolve", "MR"],
  " can solve a large class of second-order linear ODEs by reducing them to \
the ODEs for hypergeometric functions. The reduction involves coordinate \
transformations of both the independent and dependent variables."
}], "Text",
  CellTags->"b:1.1.1.5"],

Cell[TextData[{
  "This equation is ",
  StyleBox["equivalent",
    FontSlant->"Italic"],
  " to the ODE for ",
  StyleBox["Hypergeometric2F1", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      DSolve[64\ x\^2\ \((x - 1)\)\^2\ \(\(y'\)'\)[x] + 
            32\ x\ \((x - 1)\)\ \((3\ x - 1)\)\ \(y'\)[
                x] + \((5  x - 21)\)\ y[x] == 0, y, x]\)], "Input",
  CellLabel->"In[110]:=",
  CellTags->{"DSolve", "b:1.1.1.5"}],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, \(1\/x\^\(1/8\)\) \(\[ExponentialE]\^\(1\/4\ \
\((\(-2\)\ Log[\(-1\) + x] - Log[x])\)\)\ C[
                    1]\ Hypergeometric2F1[\(-\(7\/8\)\), \(-\(3\/8\)\), \
\(-\(1\/4\)\), 
                    x]\) - \((\(-1\))\)\^\(1/4\)\ \[ExponentialE]\^\(1\/4\ \
\((\(-2\)\ Log[\(-1\) + x] - Log[x])\)\)\ x\^\(9/8\)\ C[2]\ Hypergeometric2F1[
                  3\/8, 7\/8, 9\/4, x]]}}\)], "Output",
  CellLabel->"Out[110]=",
  CellTags->{"DSolve", "b:1.1.1.5"}]
}, Open  ]],

Cell["This verifies the solution using numerical values.", "MathCaption",
  CellTags->"b:1.1.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\ \)\(\(\(64\ x\^2\ \((x - 1)\)\^2\ \(\(y'\)'\)[x] + 
              32\ x\ \((x - 1)\)\ \((3\ x - 1)\)\ \(y'\)[
                  x] + \((5  x - 21)\)\ y[x] /. \ 
            sol[\([\)\(1\)\(]\)]\) /. {x \[Rule] \ Random[Complex]} // 
        Simplify\) // Chop\)\)\)], "Input",
  CellLabel->"In[111]:=",
  CellTags->"b:1.1.1.5"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[111]=",
  CellTags->"b:1.1.1.5"]
}, Open  ]],

Cell[TextData[{
  "Solutions to this equation are returned in terms of ",
  StyleBox["HypergeometricU", "MR"],
  " (the confluent hypergeometric function) and ",
  StyleBox["LaguerreL", "MR"],
  ". This example appears on page 403 of [",
  ButtonBox["K59",
    ButtonData:>"K59",
    ButtonStyle->"Hyperlink"],
  "]. "
}], "MathCaption",
  CellTags->"b:1.1.1.5"],

Cell[CellGroupData[{

Cell["\<\
sol = Simplify[PowerExpand[y[x] /. DSolve[Derivative[2][y][x] + 
         (a*x^(2*c) + b*x^(c - 1))*y[x] == 0, y, x][[1]]]]\
\>", "Input",
  CellLabel->"In[112]:=",
  CellTags->"b:1.1.1.5"],

Cell[BoxData[
    \(2\^\(c\/\(2 + 2\ c\)\)\ \[ExponentialE]\^\(-\(\(\@a\ x\^\(1 + c\)\)\/\@\
\(-\((1 + c)\)\^2\)\)\)\ \((C[
              1]\ HypergeometricU[\(-\(\(\((1 + c)\)\ \((b + 
                          b\ c + \@a\ c\ \@\(-\((1 + c)\)\^2\))\)\)\/\(2\ \@a\
\ \((\(-\((1 + c)\)\^2\))\)\^\(3/2\)\)\)\), 
              c\/\(1 + c\), \(2\ \@a\ x\^\(1 + c\)\)\/\@\(-\((1 + c)\)\^2\)] \
+ C[2]\ LaguerreL[\(-\(\(\((1 + 
                          c)\)\ \((\(-b\)\ \((1 + 
                                c)\) - \@a\ c\ \@\(-\((1 + \
c)\)\^2\))\)\)\/\(2\ \@a\ \((\(-\((1 + c)\)\^2\))\)\^\(3/2\)\)\)\), \
\(-\(1\/\(1 + 
                      c\)\)\), \(2\ \@a\ x\^\(1 + c\)\)\/\@\(-\((1 + \
c)\)\^2\)])\)\)], "Output",
  CellLabel->"Out[112]=",
  CellTags->"b:1.1.1.5"]
}, Open  ]],

Cell[TextData[{
  "The ODEs for special functions have been studied since the eighteenth \
century. During the last thirty years, powerful algorithms have been \
developed for systematically solving ODEs with rational coefficients. An \
important algorithm of this type is ",
  StyleBox["Kovacic\[CloseCurlyQuote]s algorithm",
    FontSlant->"Italic"],
  ", ",
  StyleBox["a decision procedure that either generates a solution for the \
given ODE in terms of Liouvillian functions or proves that the given ODE does \
not have a Liouvillian solution.",
    FontVariations->{"CompatibilityType"->0}]
}], "Text",
  CellTags->"b:1.1.1.5"],

Cell["\<\
This equation is solved using Kovacic\[CloseCurlyQuote]s algorithm.\
\
\>", "MathCaption",
  CellTags->"b:1.1.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[
      x*\(y''\)[x]\  + \((10  x^3 - 1)\)*\(y'\)[x]\  + 
          5  x^2 \((5  x^3 + 1)\)*y[x] \[Equal] 0, \ y[x], x]\)], "Input",
  CellLabel->"In[113]:=",
  CellTags->"b:1.1.1.5"],

Cell[BoxData[
    \({{y[x] \[Rule] \[ExponentialE]\^\(-\(\(5\ x\^3\)\/3\)\)\ C[1] + 
            1\/2\ \[ExponentialE]\^\(-\(\(5\ x\^3\)\/3\)\)\ x\^2\ C[
                2]}}\)], "Output",
  CellLabel->"Out[113]=",
  CellTags->"b:1.1.1.5"]
}, Open  ]],

Cell[TextData[{
  "The solution returned from Kovacic\[CloseCurlyQuote]s algorithm may \
occasionally include functions such as ",
  StyleBox["ExpIntegralEi", "MR"],
  " or an unevaluated integral of elementary functions because, while it is \
easy to find a second solution for a second-order linear ODE once one \
solution is known, the integral involved in finding the second solution may \
be hard to evaluate explicitly. "
}], "Text",
  CellTags->"b:1.1.1.5"],

Cell[TextData[{
  "The solution to this equation is obtained using Kovacic\[CloseCurlyQuote]s \
algorithm. It includes ",
  StyleBox["ExpIntegralEi", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[
      4  x*\(y''\)[x]\  + \((7  x + 12)\)*\(y'\)[x]\  + 21  y[x] \[Equal] 
        0, \ y[x], x]\)], "Input",
  CellLabel->"In[114]:=",
  CellTags->"b:1.1.1.5"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(\(\(-7\)\ x\)/4\)\ C[
                1] - \(\[ExponentialE]\^\(\(\(-7\)\ x\)/4\)\ C[2]\ \((16\ \
\[ExponentialE]\^\(\(7\ x\)/4\) + 28\ \[ExponentialE]\^\(\(7\ x\)/4\)\ x - 49\
\ x\^2\ ExpIntegralEi[\(7\ x\)\/4])\)\)\/\(32\ x\^2\)}}\)], "Output",
  CellLabel->"Out[114]=",
  CellTags->"b:1.1.1.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equations with Non-Rational Coefficients", "Subsubsection",
  CellTags->{"c:24", "b:1.1.1.6"}],

Cell[TextData[{
  "The ODEs that arise in practical applications often have non-rational \
coefficients. In such cases, ",
  StyleBox["DSolve", "MR"],
  " attempts to convert the equation into one with rational coefficients \
using a suitable coordinate transformation. "
}], "Text",
  CellTags->"b:1.1.1.6"],

Cell[TextData[{
  "Here is an equation that has ",
  StyleBox["Exp[x]", "MR"],
  " as a coefficient. It is solved by transforming it to Bessel\
\[CloseCurlyQuote]s equation."
}], "MathCaption",
  CellTags->"b:1.1.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(DSolve[\(y''\)[x]/y[x] \[Equal] \ Exp[5  x], y, 
      x]\)\(\ \)\)\)], "Input",
  CellLabel->"In[115]:=",
  CellTags->"b:1.1.1.6"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            BesselI[0, \(2\ \@\[ExponentialE]\^\(5\ x\)\)\/5]\ C[1] + 
              2\ BesselK[0, \(2\ \@\[ExponentialE]\^\(5\ x\)\)\/5]\ C[
                  2]]}}\)], "Output",
  CellLabel->"Out[115]=",
  CellTags->"b:1.1.1.6"]
}, Open  ]],

Cell[TextData[{
  "This equation (equation 2.437, page 507 of [",
  ButtonBox["K59",
    ButtonData:>"K59",
    ButtonStyle->"Hyperlink"],
  "]) has trigonometric coefficients. The solution is given in terms of \
elementary functions."
}], "MathCaption",
  CellTags->"b:1.1.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y''\)[x]*Sin[x]*
            Cos[x]^2\  - \ \(y'\)[x]*\((3*Sin[x]^2\  + \ 1)\)*Cos[x]\  - \ 
          y[x]*Sin[x]^3\  == \ 0, \ y, \ x]\)], "Input",
  CellLabel->"In[116]:=",
  CellTags->"b:1.1.1.6"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            C[2]\ Cos[x]\^\(\(-\(3\/2\)\) - \@13\/2\) + 
              C[1]\ Cos[x]\^\(\(-\(3\/2\)\) + \@13\/2\)]}}\)], "Output",
  CellLabel->"Out[116]=",
  CellTags->"b:1.1.1.6"]
}, Open  ]],

Cell[TextData[{
  "Here is an equation with a hyperbolic function in the coefficient of ",
  StyleBox["y[x]", "MR"],
  ". The solution is given in terms of Legendre functions."
}], "MathCaption",
  CellTags->"b:1.1.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(DSolve[\(y''\)[x]\  + \ \((k^2\  + \ 2*Sech[x]^2)\) y[x]\  == \ 
        0, \ y[x], \ x]\)\(\ \)\)\)], "Input",
  CellLabel->"In[117]:=",
  CellTags->"b:1.1.1.6"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          C[1]\ LegendreP[1, \[ImaginaryI]\ k, Tanh[x]] + 
            C[2]\ LegendreQ[1, \[ImaginaryI]\ k, Tanh[x]]}}\)], "Output",
  CellLabel->"Out[117]=",
  CellTags->"b:1.1.1.6"]
}, Open  ]],

Cell[TextData[{
  "The solution to this equation is given in terms of ",
  StyleBox["HypergeometricU", "MR"],
  " and ",
  StyleBox["LaguerreL", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.6"],

Cell[BoxData[
    \(expr = \(y''\)[
          x] + \ \((\(-d\) + d \((1 - Exp[\(-b\)\ x])\)^2)\)\ y[x]\  - 
        l\ y[x]; \)], "Input",
  CellLabel->"In[118]:=",
  CellTags->"b:1.1.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(sol\)\(=\)\(DSolve[expr \[Equal] 0, y, \ x]\)\(\ \)\)\)], "Input",
  CellLabel->"In[119]:=",
  CellTags->"b:1.1.1.6"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, \[ExponentialE]\^\(\(\(-\[ImaginaryI]\)\ \@d\ \
\[ExponentialE]\^\(\(-b\)\ x\) + \@l\ Log[\[ExponentialE]\^\(\(-b\)\ \
x\)]\)\/b\)\ C[1]\ HypergeometricU[\(-\(\(\(-b\) + 2\ \[ImaginaryI]\ \@d - 
                          2\ \@l\)\/\(2\ b\)\)\), 
                  1 + \(2\ \@l\)\/b, \(2\ \[ImaginaryI]\ \@d\ \[ExponentialE]\
\^\(\(-b\)\ x\)\)\/b] + \[ExponentialE]\^\(\(\(-\[ImaginaryI]\)\ \@d\ \
\[ExponentialE]\^\(\(-b\)\ x\) + \@l\ Log[\[ExponentialE]\^\(\(-b\)\ \
x\)]\)\/b\)\ C[
                  2]\ LaguerreL[\(\(-b\) + 2\ \[ImaginaryI]\ \@d - 2\ \@l\)\/\
\(2\ b\), \(2\ \@l\)\/b, \(2\ \[ImaginaryI]\ \@d\ \[ExponentialE]\^\(\(-b\)\ \
x\)\)\/b]]}}\)], "Output",
  CellLabel->"Out[119]=",
  CellTags->"b:1.1.1.6"]
}, Open  ]],

Cell[TextData[{
  "This verifies the solution using random values of ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["b", "MR"],
  ", ",
  StyleBox["d", "MR"],
  ", and ",
  StyleBox["l", "MR"],
  "."
}], "MathCaption",
  CellTags->"b:1.1.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(expr /. sol[\([\)\(1\)\(]\)]\) /. {x \[Rule] \ Random[Complex], \ 
            b \[Rule] \ Random[Complex], \ d \[Rule] \ Random[Complex], \ 
            l \[Rule] \ Random[Complex]} // Simplify\) // Chop\)], "Input",
  CellLabel->"In[120]:=",
  CellTags->"b:1.1.1.6"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[120]=",
  CellTags->"b:1.1.1.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inhomogeneous Linear Second-Order Equations", "Subsubsection",
  CellTags->{"c:25", "b:1.1.1.7"}],

Cell[TextData[{
  "The examples considered so far have been homogeneous second-order ODEs \
because no terms have been free of ",
  StyleBox["y[x]", "MR"],
  " or its derivatives. If the given ODE is inhomogeneous, ",
  StyleBox["DSolve", "MR"],
  " applies the ",
  StyleBox["method of variation of parameters",
    FontSlant->"Italic"],
  " to return a solution for the problem."
}], "Text",
  CellTags->"b:1.1.1.7"],

Cell["\<\
This solves an inhomogeneous linear second-order ODE. The solution \
is composed of two parts: the first part is the general solution to the \
homogeneous equation, and the second part is a particular solution to the \
inhomogenous equation. \
\>", "MathCaption",
  CellTags->"b:1.1.1.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[x^2 \( y''\)[x] + y[x] \[Equal] x^2, \ y[x], x]\)], "Input",\

  CellLabel->"In[121]:=",
  CellTags->"b:1.1.1.7"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \@x\ C[1]\ Cos[1\/2\ \@3\ Log[x]] + \@x\ C[2]\ Sin[
                1\/2\ \@3\ Log[x]] + 
            1\/3\ \((x\^2\ Cos[1\/2\ \@3\ Log[x]]\^2 + 
                  x\^2\ Sin[1\/2\ \@3\ Log[x]]\^2)\)}}\)], "Output",
  CellLabel->"Out[121]=",
  CellTags->"b:1.1.1.7"]
}, Open  ]],

Cell["\<\
This solves the homogeneous equation, which is an Euler equation.\
\
\>", "MathCaption",
  CellTags->"b:1.1.1.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[x^2 \( y''\)[x] + y[x] \[Equal] 0, \ y[x], x]\)], "Input",
  CellLabel->"In[122]:=",
  CellTags->"b:1.1.1.7"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \@x\ C[1]\ Cos[1\/2\ \@3\ Log[x]] + \@x\ C[2]\ Sin[
                1\/2\ \@3\ Log[x]]}}\)], "Output",
  CellLabel->"Out[122]=",
  CellTags->"b:1.1.1.7"]
}, Open  ]],

Cell[TextData[{
  "Different particular solutions can be obtained by varying the constants ",
  StyleBox["C[1]", "MR"],
  " and ",
  StyleBox["C[2]", "MR"],
  " in the solution. "
}], "MathCaption",
  CellTags->"b:1.1.1.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(particularsolutions = \ 
      Flatten[Table[\(y[x] /. sol\) /. {C[1] \[Rule] \ i, \ 
              C[2] \[Rule] \ j}, \ {i, 0, 5, 3}, \ {j, 1, 3}]]\)], "Input",
  CellLabel->"In[123]:=",
  CellTags->"b:1.1.1.7"],

Cell[BoxData[
    \({\@x\ Sin[1\/2\ \@3\ Log[x]] + 
        1\/3\ \((x\^2\ Cos[1\/2\ \@3\ Log[x]]\^2 + 
              x\^2\ Sin[1\/2\ \@3\ Log[x]]\^2)\), 
      2\ \@x\ Sin[1\/2\ \@3\ Log[x]] + 
        1\/3\ \((x\^2\ Cos[1\/2\ \@3\ Log[x]]\^2 + 
              x\^2\ Sin[1\/2\ \@3\ Log[x]]\^2)\), 
      3\ \@x\ Sin[1\/2\ \@3\ Log[x]] + 
        1\/3\ \((x\^2\ Cos[1\/2\ \@3\ Log[x]]\^2 + 
              x\^2\ Sin[1\/2\ \@3\ Log[x]]\^2)\), 
      3\ \@x\ Cos[1\/2\ \@3\ Log[x]] + \@x\ Sin[1\/2\ \@3\ Log[x]] + 
        1\/3\ \((x\^2\ Cos[1\/2\ \@3\ Log[x]]\^2 + 
              x\^2\ Sin[1\/2\ \@3\ Log[x]]\^2)\), 
      3\ \@x\ Cos[1\/2\ \@3\ Log[x]] + 2\ \@x\ Sin[1\/2\ \@3\ Log[x]] + 
        1\/3\ \((x\^2\ Cos[1\/2\ \@3\ Log[x]]\^2 + 
              x\^2\ Sin[1\/2\ \@3\ Log[x]]\^2)\), 
      3\ \@x\ Cos[1\/2\ \@3\ Log[x]] + 3\ \@x\ Sin[1\/2\ \@3\ Log[x]] + 
        1\/3\ \((x\^2\ Cos[1\/2\ \@3\ Log[x]]\^2 + 
              x\^2\ Sin[1\/2\ \@3\ Log[x]]\^2)\)}\)], "Output",
  CellLabel->"Out[123]=",
  CellTags->"b:1.1.1.7"]
}, Open  ]],

Cell[BoxData[
    \(colortable\  = \ Table[{Hue[1/i]}, \ {i, 1, 9}]; \)], "Input",
  CellLabel->"In[124]:=",
  CellTags->"b:1.1.1.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[particularsolutions], \ {x, 0.1, 2}, \ 
      PlotStyle\  \[Rule] colortable\ ]; \)], "Input",
  CellLabel->"In[125]:=",
  CellTags->"b:1.1.1.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.109665 0.0682708 [
[.2619 .09716 -9 -9 ]
[.2619 .09716 9 0 ]
[.5 .09716 -3 -9 ]
[.5 .09716 3 0 ]
[.7381 .09716 -9 -9 ]
[.7381 .09716 9 0 ]
[.97619 .09716 -3 -9 ]
[.97619 .09716 3 0 ]
[.01131 .24621 -6 -4.5 ]
[.01131 .24621 0 4.5 ]
[.01131 .38275 -6 -4.5 ]
[.01131 .38275 0 4.5 ]
[.01131 .51929 -6 -4.5 ]
[.01131 .51929 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .10966 m
.2619 .11591 L
s
[(0.5)] .2619 .09716 0 1 Mshowa
.5 .10966 m
.5 .11591 L
s
[(1)] .5 .09716 0 1 Mshowa
.7381 .10966 m
.7381 .11591 L
s
[(1.5)] .7381 .09716 0 1 Mshowa
.97619 .10966 m
.97619 .11591 L
s
[(2)] .97619 .09716 0 1 Mshowa
.125 Mabswid
.07143 .10966 m
.07143 .11341 L
s
.11905 .10966 m
.11905 .11341 L
s
.16667 .10966 m
.16667 .11341 L
s
.21429 .10966 m
.21429 .11341 L
s
.30952 .10966 m
.30952 .11341 L
s
.35714 .10966 m
.35714 .11341 L
s
.40476 .10966 m
.40476 .11341 L
s
.45238 .10966 m
.45238 .11341 L
s
.54762 .10966 m
.54762 .11341 L
s
.59524 .10966 m
.59524 .11341 L
s
.64286 .10966 m
.64286 .11341 L
s
.69048 .10966 m
.69048 .11341 L
s
.78571 .10966 m
.78571 .11341 L
s
.83333 .10966 m
.83333 .11341 L
s
.88095 .10966 m
.88095 .11341 L
s
.92857 .10966 m
.92857 .11341 L
s
.25 Mabswid
0 .10966 m
1 .10966 L
s
.02381 .24621 m
.03006 .24621 L
s
[(2)] .01131 .24621 1 0 Mshowa
.02381 .38275 m
.03006 .38275 L
s
[(4)] .01131 .38275 1 0 Mshowa
.02381 .51929 m
.03006 .51929 L
s
[(6)] .01131 .51929 1 0 Mshowa
.125 Mabswid
.02381 .1438 m
.02756 .1438 L
s
.02381 .17794 m
.02756 .17794 L
s
.02381 .21207 m
.02756 .21207 L
s
.02381 .28034 m
.02756 .28034 L
s
.02381 .31448 m
.02756 .31448 L
s
.02381 .34861 m
.02756 .34861 L
s
.02381 .41688 m
.02756 .41688 L
s
.02381 .45102 m
.02756 .45102 L
s
.02381 .48515 m
.02756 .48515 L
s
.02381 .07553 m
.02756 .07553 L
s
.02381 .04139 m
.02756 .04139 L
s
.02381 .00726 m
.02756 .00726 L
s
.02381 .55342 m
.02756 .55342 L
s
.02381 .58756 m
.02756 .58756 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.07143 .09021 m
.07996 .08746 L
.0893 .08505 L
.09905 .08311 L
.10813 .08172 L
.11334 .08109 L
.11826 .08059 L
.12747 .07988 L
.13263 .0796 L
.13739 .07941 L
.13988 .07933 L
.14262 .07927 L
.144 .07924 L
.14548 .07922 L
.14688 .0792 L
.14749 .0792 L
.14816 .07919 L
.14938 .07919 L
.15053 .07918 L
.15166 .07918 L
.15269 .07918 L
.15381 .07919 L
.15503 .07919 L
.15632 .0792 L
.15751 .07922 L
.15971 .07925 L
.1617 .07929 L
.1662 .0794 L
.17104 .07956 L
.17631 .07978 L
.18588 .08029 L
.20467 .08166 L
.22463 .08356 L
.26049 .08789 L
.29868 .09348 L
.33544 .09958 L
.37452 .10667 L
.41216 .11397 L
.44836 .12136 L
.4869 .12956 L
.52399 .13775 L
.56341 .14674 L
.6014 .15566 L
.63794 .16446 L
.67681 .17405 L
.71424 .1835 L
.75024 .19278 L
.78856 .20287 L
.82544 .21277 L
.86466 .22351 L
Mistroke
.90243 .23406 L
.93876 .24439 L
.97619 .25523 L
Mfstroke
0 1 1 r
.07143 .07053 m
.07996 .06493 L
.0893 .06001 L
.09905 .05598 L
.10813 .05307 L
.11826 .05062 L
.12747 .04902 L
.13257 .04836 L
.13811 .0478 L
.14064 .04759 L
.14333 .04741 L
.14581 .04727 L
.14816 .04717 L
.15039 .04709 L
.15157 .04706 L
.15283 .04703 L
.15399 .04701 L
.15504 .04699 L
.1561 .04698 L
.1571 .04698 L
.15827 .04698 L
.15951 .04698 L
.16056 .04699 L
.16172 .047 L
.16297 .04702 L
.16431 .04705 L
.16672 .04712 L
.16896 .0472 L
.17139 .0473 L
.17581 .04753 L
.1841 .04813 L
.19303 .04898 L
.20289 .05014 L
.22285 .05312 L
.26104 .06062 L
.29779 .06949 L
.33688 .08017 L
.37452 .09133 L
.41072 .10268 L
.44925 .11526 L
.48635 .12775 L
.52577 .14135 L
.56375 .15471 L
.6003 .16777 L
.63917 .18185 L
.6766 .19556 L
.71259 .20888 L
.75092 .22319 L
.7878 .23709 L
.82701 .25198 L
Mistroke
.86479 .26645 L
.90112 .28047 L
.93978 .2955 L
.97619 .30977 L
Mfstroke
0 1 0 r
.07143 .05084 m
.07996 .0424 L
.0893 .03497 L
.09905 .02885 L
.10813 .02441 L
.11826 .02066 L
.12747 .01816 L
.13257 .01711 L
.13811 .01621 L
.14333 .01557 L
.14585 .01533 L
.14816 .01514 L
.15028 .01501 L
.15259 .01489 L
.15385 .01483 L
.15503 .0148 L
.15615 .01476 L
.15735 .01474 L
.15846 .01473 L
.15967 .01472 L
.16081 .01472 L
.16186 .01472 L
.16281 .01473 L
.16385 .01475 L
.16493 .01477 L
.16595 .01479 L
.16849 .01488 L
.1709 .015 L
.17541 .01528 L
.18026 .01569 L
.18554 .01624 L
.20433 .01903 L
.22429 .02319 L
.26015 .033 L
.29834 .04584 L
.3351 .05979 L
.37418 .07585 L
.41182 .09216 L
.44802 .10841 L
.48656 .12615 L
.52365 .14354 L
.56307 .16228 L
.60106 .18052 L
.6376 .19818 L
.67647 .21707 L
.7139 .23532 L
.7499 .25293 L
.78822 .27171 L
.8251 .28983 L
.86432 .30912 L
Mistroke
.90209 .32773 L
.93842 .34565 L
.97619 .36431 L
Mfstroke
.5 1 0 r
.07143 .0636 m
.10813 .08789 L
.14816 .12072 L
.18575 .1513 L
.22191 .17907 L
.26039 .20655 L
.29743 .23101 L
.33681 .25503 L
.37474 .27643 L
.41123 .29558 L
.45006 .31459 L
.48744 .33172 L
.52338 .34721 L
.56166 .36279 L
.59849 .37699 L
.63765 .39133 L
.67538 .40449 L
.71166 .41662 L
.75027 .42903 L
.78745 .44054 L
.82695 .45237 L
.86501 .46344 L
.90164 .47381 L
.94059 .48458 L
.97619 .49424 L
s
.8 1 0 r
.07143 .04392 m
.07255 .04401 L
.07356 .04413 L
.07584 .04449 L
.07796 .04494 L
.07996 .04545 L
.0893 .04886 L
.09833 .05337 L
.10813 .05923 L
.14816 .08869 L
.18698 .1203 L
.22437 .15073 L
.26031 .17909 L
.29858 .20797 L
.33542 .23438 L
.37458 .26101 L
.4123 .28531 L
.44859 .30753 L
.4872 .33002 L
.52437 .35065 L
.56388 .37158 L
.60194 .39086 L
.63856 .40867 L
.67752 .42689 L
.71503 .44381 L
.7511 .45954 L
.7895 .47578 L
.82647 .49096 L
.86576 .50666 L
.90361 .5214 L
.94003 .53527 L
.97619 .54878 L
s
1 1 0 r
.07143 .02424 m
.07255 .02393 L
.07356 .02368 L
.07466 .02346 L
.07584 .02326 L
.07694 .02312 L
.07796 .02303 L
.07893 .02296 L
.07996 .02293 L
.08106 .02292 L
.08225 .02295 L
.08337 .02301 L
.0844 .02309 L
.0856 .02322 L
.08691 .02339 L
.0893 .02381 L
.09402 .02498 L
.09906 .02665 L
.10813 .03057 L
.12913 .04294 L
.14816 .05667 L
.18622 .08768 L
.22285 .11925 L
.2618 .15296 L
.29931 .1848 L
.33539 .21453 L
.37379 .24506 L
.41075 .27334 L
.45005 .30221 L
.4879 .32892 L
.52431 .35364 L
.56305 .37896 L
.60036 .40246 L
.63622 .42429 L
.67441 .44677 L
.71117 .46773 L
.75025 .48934 L
.78789 .50954 L
.8241 .52846 L
.86263 .54809 L
.89972 .56654 L
.93914 .58569 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gR000`400?l00000o`00003oo`3ooomY
0?ooo`002`3oool00`000000oooo0?ooo`3o0?oooe/0oooo000;0?ooo`030000003oool0oooo0?l0
ooooF`3oool000/0oooo00<000000?ooo`3oool0o`3ooomK0?ooo`002`3oool300000?l0ooooF`3o
ool000/0oooo00<000000?ooo`3oool0o`3ooomK0?ooo`002`3oool00`000000oooo0?ooo`0X0?oo
o``00?l0o`3ooolW0?ooo`002`3oool00`000000oooo0?ooo`0Q0?ooo`L00?l0303oool7003o0?l0
oooo803oool000/0oooo00<000000?ooo`3oool07`3oool2003o01X0oooo1`00o`3o0?oooaT0oooo
000;0?ooo`030000003oool0oooo00l0oooo1`3oo`070?ooo`800?l08`3oool5003o0?l0oooo503o
ool000/0oooo00<000000?ooo`3oool03P3oool00`3oo`00oooo0?ooo`050?ooo`<0ool000@0oooo
003o0000o`000?l0:P3oool3003o0?l0oooo4@3oool000/0oooo00<000000?ooo`3oool0603oool0
0`00o`00ool00?oo000_0?ooo`<00?l0o`3oool>0?ooo`002`3oool00`000000oooo0?ooo`0F0?oo
o`800?l00`3oool00`3oo`00oooo0?ooo`0_0?ooo`<00?l0o`3oool;0?ooo`002`3oool00`000000
oooo0?ooo`0E0?ooo`03003o003oool0oooo00@0oooo0P3oo`0b0?ooo`<00?l0o`3oool80?ooo`00
2`3oool00`000000oooo0?ooo`0D0?ooo`03003o003oool0oooo00L0oooo0P3oo`0c0?ooo`@00?l0
o`3oool40?ooo`002`3oool00`000000oooo0?ooo`0B0?ooo`800?l0303oool20?oo03D0oooo0`00
o`3o0?ooo`40oooo000;0?ooo`<000004@3oool00`00o`00oooo0?ooo`0>0?ooo`80ool0=P3oool4
003o0?`0oooo000;0?ooo`030000003oool0oooo00h0oooo1@3<o`0A0?ooo`80ool0>03oool3003o
0?T0oooo000;0?ooo`030000003oool0oooo00l0oooo00@00?l00?ooo`3oool0oooo0`3<o`0;0?oo
o`D00?oo00<0ool0003oo`00ool04`00oolU0?ooo`800?l0m`3oool000/0oooo00<000000?ooo`3o
ool03P3oool00`00o`00oooo0?ooo`050?ooo`80c?l01P3oool3003oo`H0oooo00<0ool00?ooo`3o
ool04P3oool5003oob80oooo0`00o`3d0?ooo`002`3oool00`000000oooo0?ooo`0H0?ooo`030<co
003oool00?oo00<00?oo2P3oool20?oo01L0oooo1P00oolO0?ooo`<00?l0l@3oool000/0oooo00<0
00000?ooo`3oool05`3oool2003oo`80c?l03`3oool00`3oo`00oooo0?ooo`0J0?ooo`@00?oo7P3o
ool2003o0>l0oooo000;0?ooo`030000003oool0oooo01D0oooo0P00ool40?ooo`030<co003oool0
oooo00d0oooo00<0ool00?ooo`3oool07@3oool5003ooa/0oooo0`00o`3/0?ooo`002`3oool00`00
0000oooo0?ooo`0C0?ooo`800?oo1`3oool20<co00h0oooo00<0ool00?ooo`3oool08@3oool5003o
oaT0oooo0P00o`3Z0?ooo`002`3oool00`000000oooo0?ooo`0>0?ooo`0307oo003oool0oooo0080
0?oo2`3oool00`3<o`00oooo0?ooo`0<0?ooo`80ool06@3oool4000000D0oooo0P0000020?ooo`@0
0?oo0`00000D0?ooo`800?l0<`3oool5000004L0oooo1@0000040?ooo`8000001@3oool4000004P0
oooo1@0000080?ooo`002`3oool00`000000oooo0?ooo`0?0?ooo`80Ool03P3oool20<co00h0oooo
00<0ool00?ooo`3oool05@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
0P0000040?ooo`030000003oool00?oo00<00?oo5@3oool3003o0380oooo00<000000?ooo`3oool0
B@3oool00`000000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo04D0oooo00D000000?ooo`3oool0oooo000000080?ooo`002`3oool00`000000oooo
0?ooo`0>0?ooo`03003oo`3oool0oooo0080Ool03P3oool00`3<o`00oooo0?ooo`0<0?ooo`030?oo
003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`030000
0000ool00?oo00<00?oo4`3oool2003o0300oooo00<000000?ooo`3oool0B@3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool02@3oool000/0oooo00<0
00000?ooo`3oool04`3oool00`1oo`00oooo0?ooo`0<0?ooo`80c?l03@3oool00`3oo`00oooo0?oo
o`0C0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`030?ooo`@00?oo4@3oool2003o02h0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0203oool000/0oooo0`00000D
0?ooo`80Ool03P3oool00`3<o`00oooo0?ooo`0;0?ooo`030?oo003oool0oooo0180oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`@000002P3oool5003oo`h0oooo0`00o`0[
0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool02`3oool4000004/0oooo00<00000
0?ooo`3oool01`3oool000/0oooo00<000000?ooo`3oool05P3oool00`1oo`00oooo0?ooo`080?oo
o`@0o`000P3<o`0<0?l00080ool01P3o000<0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`@00?oo3@3oool2003o02T0oooo00<000000?oo
o`3oool0B@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04d0oooo00<000000?oo
o`3oool01P3oool000/0oooo00<000000?ooo`3oool05`3oool207oo00P0o`001P3oool00`3<o`00
oooo0?ooo`0;0?ooo`030?oo003oool0oooo00<0oooo1`3o00050?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0D0?ooo`<00?oo303oool2003o02D0
oooo0`0000190?ooo`<000003@3oool00`000000oooo0?ooo`190?ooo`050000003oool0oooo0?oo
o`000000203oool000/0oooo00<000000?ooo`3oool0503oool30?l00080oooo0P1oo`0=0?ooo`80
c?l0303oool00`3oo`00oooo0?ooo`090?ooo`X0o`00303oool5000001D0oooo1000ool:0?ooo`80
0?l09@3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo00/0oooo1@0000180?ooo`<0
00002@3oool000/0oooo00<000000?ooo`3oool0403oool40?l000L0oooo00<0Ool00?ooo`3oool0
303oool00`3<o`00oooo0?ooo`0:0?ooo`030?oo003oool0oooo0180oooo2P3o000P0?ooo`<00?oo
2@3oool2003o0=H0oooo000;0?ooo`030000003oool0oooo00h0oooo0P3o000<0?ooo`0307oo003o
ool0oooo00`0oooo00<0c?l00?ooo`3oool02P3oool00`3oo`00oooo0?ooo`0K0?ooo`H0o`007@3o
ool3003oo`P0oooo0P00o`3D0?ooo`002`3oool00`000000oooo0?ooo`0M0?ooo`80Ool03@3oool0
0`3<o`00oooo0?ooo`0:0?ooo`030?oo003oool0oooo0200oooo1`3o000I0?ooo`<00?oo1`3oool3
003o0=40oooo000;0?ooo`030000003oool0oooo01l0oooo00<0Ool00?ooo`3oool02`3oool00`3<
o`00oooo0?ooo`0:0?ooo`80ool09`3oool60?l001H0oooo1000ool60?ooo`800?l0c`3oool000/0
oooo00<000000?ooo`3oool0803oool00`1oo`00oooo0?ooo`0;0?ooo`030<co003oool0oooo00/0
oooo00<0ool00?ooo`3oool0:P3oool60?l001@0oooo0`00ool50?ooo`<00?l0c03oool000/0oooo
00<000000?ooo`3oool08@3oool00`1oo`00oooo0?ooo`0;0?ooo`030<co003oool0oooo00/0oooo
00<0ool00?ooo`3oool0;`3oool40?l001<0oooo0`00ool50?ooo`<00?l0b@3oool000/0oooo00<0
00000?ooo`3oool08P3oool207oo00`0oooo0P3<o`0<0?ooo`030?oo003oool0oooo0380oooo1@3o
000A0?ooo`<00?oo1@3oool2003o0<L0oooo000;0?ooo`030000003oool0oooo02@0oooo00<0Ool0
0?ooo`3oool02`3oool00`3<o`00oooo0?ooo`0:0?ooo`030?oo003oool0oooo03H0oooo1P3o000>
0?ooo`800?oo1@3oool2003o0<D0oooo00030?oooc00000000<0Ool00000000000002`0000000`3<
o`0000000000000:00000080ool0?00000070?l000T000000`00ool4000000800?l0``00000000/0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0
oooo00<0Ool00?ooo`3oool01`3oool01@000000oooo0?ooo`3oool0c?l000`0oooo00<000000?oo
003oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool50?l000L0oooo0`00ool20?ooo`0300000000o`000?l000h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`070?ooo`002`3oool00`000000oooo0?ooo`0W0?ooo`80
Ool0303oool00`3<o`00oooo0?ooo`0;0?ooo`030?oo003oool0oooo00`0oooo00<000000?ooo`3o
ool0=@3oool40?l000H0oooo0`00ool20?ooo`800?l0303oool00`000000oooo0?ooo`1A0?ooo`03
0000003oool0oooo0580oooo00<000000?ooo`3oool01`3oool000/0oooo00<000000?ooo`3oool0
:@3oool00`1oo`00oooo0?ooo`0:0?ooo`030<co003oool0oooo00/0oooo00<0ool00?ooo`3oool0
A`3oool40?l000D0oooo0`00ool00`3oool00?l0003o002m0?ooo`002`3oool00`000000oooo0?oo
o`0Z0?ooo`0307oo003oool0oooo00X0oooo00<0c?l00?ooo`3oool02`3oool00`3oo`00oooo0?oo
o`1:0?ooo`D0o`000`3oool3003oo`800?l0^`3oool000/0oooo00<000000?ooo`3oool0:`3oool0
0`1oo`00oooo0?ooo`0:0?ooo`030<co003oool0oooo00/0oooo00<0ool00?ooo`3oool0CP3oool4
0?l000<0oooo00<00?oo003o0000o`00^@3oool000/0oooo00<000000?ooo`3oool0;03oool00`1o
o`00oooo0?ooo`0:0?ooo`80c?l0303oool20?oo0580oooo1@3o0000103oool00?l0003o0000o`2f
0?ooo`002`3oool00`000000oooo0?ooo`0]0?ooo`80Ool0303oool00`3<o`00oooo0?ooo`0;0?oo
o`030?oo003oool0oooo05@0oooo103o0002003o0003003oo`3oool0oooo0;40oooo000;0?ooo`03
0000003oool0oooo02l0oooo00<0Ool00?ooo`3oool02P3oool00`3<o`00oooo0?ooo`0;0?ooo`03
0?oo003oool0oooo05P0oooo00@0o`00003o0000o`000?oo/@3oool000/0oooo00<000000?ooo`3o
ool0<03oool00`1oo`00oooo0?ooo`0:0?ooo`030<co003oool0oooo00/0oooo00<0ool00?ooo`3o
ool0FP3oool2003o00800?oo00<0o`000?ooo`3oool0Z`3oool000/0oooo00<000000?ooo`3oool0
<@3oool00`1oo`00oooo0?ooo`0:0?ooo`80c?l0303oool00`3oo`00oooo0?ooo`1K0?ooo`800?l0
0`00ool30?l00:P0oooo000;0?ooo`030000003oool0oooo0380oooo00<0Ool00?ooo`3oool02`3o
ool00`3<o`00oooo0?ooo`0:0?ooo`030?oo003oool0oooo05`0oooo0P00o`00103oool00?oo003o
o`00ool40?l00:@0oooo000;0?ooo`<00000<`3oool207oo00`0oooo00<0c?l00?ooo`3oool02P3o
ool20?oo05h0oooo0P00o`020?ooo`800?oo0P3oool50?l009l0oooo000;0?ooo`030000003oool0
oooo03D0oooo00<0Ool00?ooo`3oool02P3oool20<co00`0oooo00<0ool00?ooo`3oool0G@3oool2
003o0080oooo0`00ool40?ooo`D0o`00VP3oool000/0oooo00<000000?ooo`3oool0=P3oool00`1o
o`00oooo0?ooo`0;0?ooo`030<co003oool0oooo00X0oooo00<0ool00?ooo`3oool0GP3oool2003o
00<0oooo0`00ool60?ooo`@0o`00UP3oool000/0oooo00<000000?ooo`3oool0=`3oool00`1oo`00
oooo0?ooo`0;0?ooo`030<co003oool0oooo00X0oooo00<0ool00?ooo`3oool0G`3oool2003o00@0
oooo0P00ool80?ooo`D0o`00T@3oool000/0oooo00<000000?ooo`3oool0>03oool00`1oo`00oooo
0?ooo`0;0?ooo`030<co003oool0oooo00X0oooo00<0ool00?ooo`3oool0H03oool2003o00@0oooo
0`00ool:0?ooo`D0o`00S03oool000/0oooo00<000000?ooo`3oool0>@3oool207oo00`0oooo0P3<
o`0;0?ooo`030?oo003oool0oooo0640oooo0P00o`050?ooo`800?oo3@3oool40?l008P0oooo000;
0?ooo`030000003oool0oooo03/0oooo00<0Ool00?ooo`3oool02`3oool00`3<o`00oooo0?ooo`09
0?ooo`030?oo003oool0oooo0680oooo0P00o`050?ooo`<00?oo3P3oool40?l008@0oooo000;0?oo
o`030000003oool0oooo03`0oooo00<0Ool00?ooo`3oool02`3oool00`3<o`00oooo0?ooo`090?oo
o`030?oo003oool0oooo06<0oooo0`00o`050?ooo`<00?oo3`3oool40?l00800oooo000;0?ooo`03
0000003oool0oooo03d0oooo0P1oo`0<0?ooo`80c?l02P3oool00`3oo`00oooo0?ooo`1U0?ooo`80
0?l01P3oool2003ooa40oooo103o001l0?ooo`002`3oool00`000000oooo0?ooo`0o0?ooo`0307oo
003oool0oooo00/0oooo00<0c?l00?ooo`3oool0203oool20?oo06L0oooo0P00o`060?ooo`<00?oo
4P3oool30?l007T0oooo000;0?ooo`030000003oool0oooo0400oooo00<0Ool00?ooo`3oool02`3o
ool00`3<o`00oooo0?ooo`090?ooo`030?oo003oool0oooo06H0oooo0`00o`060?ooo`<00?oo4P3o
ool40?l007D0oooo000;0?ooo`030000003oool0oooo0440oooo0P1oo`0<0?ooo`80c?l02P3oool0
0`3oo`00oooo0?ooo`1X0?ooo`800?l01`3oool2003ooa@0oooo103o001a0?ooo`002`3oool30000
04<0oooo00<0Ool00?ooo`3oool02`3oool00`3<o`00oooo0?ooo`080?ooo`030?oo003oool0oooo
06T0oooo0P00o`070?ooo`<00?oo5@3oool40?l006d0oooo000;0?ooo`030000003oool0oooo04@0
oooo00<0Ool00?ooo`3oool02`3oool00`3<o`00oooo0?ooo`080?ooo`030?oo003oool0oooo06X0
oooo0`00o`070?ooo`<00?oo5P3oool40?l006T0oooo000;0?ooo`030000003oool0oooo04D0oooo
0P1oo`0<0?ooo`030<co003oool0oooo00P0oooo00<0ool00?ooo`3oool0K03oool2003o00P0oooo
0`00oolG0?ooo`D0o`00I03oool000/0oooo00<000000?ooo`3oool0A`3oool00`1oo`00oooo0?oo
o`0:0?ooo`80c?l02@3oool00`3oo`00oooo0?ooo`1]0?ooo`800?l02@3oool4003ooaP0oooo103o
001P0?ooo`002`3oool00`000000oooo0?ooo`180?ooo`80Ool0303oool00`3<o`00oooo0?ooo`07
0?ooo`030?oo003oool0oooo06h0oooo0P00o`0;0?ooo`<00?oo6@3oool40?l005`0oooo000;0?oo
o`030000003oool0oooo04X0oooo00<0Ool00?ooo`3oool02P3oool00`3<o`00oooo0?ooo`070?oo
o`80ool0L03oool2003o00`0oooo1000oolI0?ooo`@0o`00F03oool000/0oooo00<000000?ooo`3o
ool0B`3oool207oo00/0oooo0P3<o`090?ooo`030?oo003oool0oooo06l0oooo0P00o`0>0?ooo`<0
0?oo6P3oool30?l005D0oooo000;0?ooo`030000003oool0oooo04d0oooo0P1oo`0;0?ooo`030<co
003oool0oooo00L0oooo00<0ool00?ooo`3oool0L03oool2003o00l0oooo0P00oolK0?ooo`@0o`00
D@3oool000/0oooo00<000000?ooo`3oool0C`3oool00`1oo`00oooo0?ooo`090?ooo`030<co003o
ool0oooo00L0oooo0P3oo`1b0?ooo`800?l03`3oool2003ooad0oooo0`3o001>0?ooo`002`3oool0
0`000000oooo0?ooo`1@0?ooo`80Ool02P3oool20<co00T0oooo00<0ool00?ooo`3oool0L@3oool2
003o00l0oooo0`00oolM0?ooo`<0o`00B`3oool000/0oooo00<000000?ooo`3oool0DP3oool00`1o
o`00oooo0?ooo`090?ooo`030<co003oool0oooo00L0oooo00<0ool00?ooo`3oool0LP3oool2003o
0100oooo0P00oolN0?ooo`<0o`00B03oool000/0oooo00<000000?ooo`3oool0D`3oool207oo00X0
oooo00<0c?l00?ooo`3oool01`3oool20?oo07@0oooo0P00o`0@0?ooo`<00?oo7P3oool40?l004@0
oooo000;0?ooo`<00000E@3oool00`1oo`00oooo0?ooo`080?ooo`80c?l02@3oool00`3oo`00oooo
0?ooo`1c0?ooo`800?l04@3oool3003ooal0oooo0`3o00110?ooo`002`3oool00`000000oooo0?oo
o`1F0?ooo`80Ool02P3oool00`3<o`00oooo0?ooo`070?ooo`030?oo003oool0oooo07@0oooo0P00
o`0B0?ooo`800?oo803oool40?l003d0oooo000;0?ooo`030000003oool0oooo05P0oooo00<0Ool0
0?ooo`3oool0203oool20<co00P0oooo00<0ool00?ooo`3oool0M@3oool00`00o`00oooo0?ooo`0A
0?ooo`<00?oo8@3oool40?l003T0oooo000;0?ooo`030000003oool0oooo05T0oooo00<0Ool00?oo
o`3oool02@3oool00`3<o`00oooo0?ooo`060?ooo`80ool0MP3oool2003o01@0oooo0`00oolR0?oo
o`D0o`00=03oool000/0oooo00<000000?ooo`3oool0FP3oool207oo00X0oooo00<0c?l00?ooo`3o
ool01`3oool00`3oo`00oooo0?ooo`1e0?ooo`800?l05@3oool3003oob@0oooo103o000`0?ooo`00
2`3oool00`000000oooo0?ooo`1L0?ooo`0307oo003oool0oooo00P0oooo0P3<o`080?ooo`030?oo
003oool0oooo07H0oooo0P00o`0F0?ooo`800?oo9P3oool40?l002`0oooo000;0?ooo`030000003o
ool0oooo05d0oooo0P1oo`0:0?ooo`030<co003oool0oooo00H0oooo00<0ool00?ooo`3oool0M`3o
ool2003o01H0oooo0`00oolW0?ooo`<0o`00:@3oool000/0oooo00<000000?ooo`3oool0G`3oool0
0`1oo`00oooo0?ooo`080?ooo`80c?l01`3oool20?oo07T0oooo0P00o`0G0?ooo`<00?oo9`3oool4
0?l002D0oooo000;0?ooo`030000003oool0oooo0600oooo0P1oo`0:0?ooo`030<co003oool0oooo
00H0oooo00<0ool00?ooo`3oool0N03oool2003o01P0oooo0P00oolY0?ooo`<0o`008P3oool000D0
00001P3oool00`000000oooo0?ooo`1R0?ooo`0307oo003oool0oooo00P0oooo0P3<o`070?ooo`03
0?oo003oool0oooo07T0oooo0`00o`0G0?ooo`<00?oo:@3oool30?l001l0oooo00001@000000oooo
0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0H`3oool207oo00X0oooo00<0c?l00?ooo`3o
ool01@3oool20?oo07`0oooo0P00o`0H0?ooo`800?oo:P3oool40?l001/0oooo00000`3oool00000
0?ooo`080?ooo`030000003oool0oooo06D0oooo00<0Ool00?ooo`3oool0203oool00`3<o`00oooo
0?ooo`060?ooo`030?oo003oool0oooo07/0oooo0P00o`0H0?ooo`800?oo;03oool30?l001P0oooo
00020?ooo`030000003oool0oooo00H0oooo1000001U0?ooo`80Ool02@3oool20<co00L0oooo00<0
ool00?ooo`3oool0O03oool2003o01P0oooo0`00ool/0?ooo`<0o`005@3oool000<0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`1X0?ooo`80Ool02@3oool00`3<o`00oooo0?ooo`05
0?ooo`030?oo003oool0oooo07d0oooo0P00o`0I0?ooo`800?oo;@3oool30?l00180oooo00040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0JP3oool00`1oo`00oooo0?ooo`070?oo
o`80c?l01P3oool20?oo07l0oooo0P00o`0I0?ooo`800?oo;P3oool40?l000h0oooo00001@000000
oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0J`3oool207oo00T0oooo00<0c?l00?oo
o`3oool01@3oool00`3oo`00oooo0?ooo`1n0?ooo`800?l06@3oool3003oobl0oooo0`3o000;0?oo
o`0000@0oooo00000000000000001`3oool00`000000oooo0?ooo`1]0?ooo`0307oo003oool0oooo
00L0oooo00<0c?l00?ooo`3oool01@3oool00`3oo`00oooo0?ooo`1o0?ooo`800?l06P3oool2003o
oc00oooo0P3o00090?ooo`002`3oool00`000000oooo0?ooo`1^0?ooo`80Ool0203oool20<co00H0
oooo0P3oo`210?ooo`800?l06P3oool3003oocP0oooo000;0?ooo`030000003oool0oooo0700oooo
0P1oo`080?ooo`030<co003oool0oooo00D0oooo00<0ool00?ooo`3oool0P03oool2003o01/0oooo
0`00oole0?ooo`002`3oool00`000000oooo0?ooo`1b0?ooo`80Ool01`3oool20<co00H0oooo00<0
ool00?ooo`3oool0P@3oool2003o01`0oooo0P00oolc0?ooo`002`3oool00`000000oooo0?ooo`1d
0?ooo`80Ool01`3oool20<co00D0oooo0P3oo`230?ooo`800?l0703oool3003ooc00oooo000;0?oo
o`030000003oool0oooo07H0oooo0P1oo`070?ooo`80c?l01@3oool00`3oo`00oooo0?ooo`220?oo
o`800?l07@3oool2003oobh0oooo000;0?ooo`030000003oool0oooo07P0oooo0P1oo`070?ooo`03
0<co003oool0oooo00<0oooo00<0ool00?ooo`3oool0P`3oool2003o01d0oooo0`00ool[0?ooo`00
2`3oool00`000000oooo0?ooo`1j0?ooo`0307oo003oool0oooo00D0oooo0P3<o`040?ooo`80ool0
Q@3oool2003o01h0oooo0`00oolX0?ooo`002`3oool00`000000oooo0?ooo`1k0?ooo`80Ool01`3o
ool20<co00@0oooo00<0ool00?ooo`3oool0Q03oool2003o01l0oooo0P00oolV0?ooo`002`3oool3
000007d0oooo0P1oo`070?ooo`80c?l00`3oool00`3oo`00oooo0?ooo`250?ooo`800?l07`3oool3
003oob<0oooo000;0?ooo`030000003oool0oooo07l0oooo0P1oo`070?ooo`040<co003oool0oooo
0?ooo`80ool0Q`3oool2003o0200oooo0`00oolP0?ooo`002`3oool00`000000oooo0?ooo`210?oo
o`80Ool01P3oool20<co00<0oooo00<0ool00?ooo`3oool0QP3oool2003o0240oooo0P00oolN0?oo
o`002`3oool00`000000oooo0?ooo`230?ooo`80Ool01P3oool0103<o`00oooo0?ooo`3oool20?oo
08P0oooo0P00o`0Q0?ooo`<00?oo6`3oool000/0oooo00<000000?ooo`3oool0Q@3oool207oo00D0
oooo0P3<o`030?ooo`030?oo003oool0oooo08L0oooo0P00o`0R0?ooo`<00?oo603oool000/0oooo
00<000000?ooo`3oool0Q`3oool00`1oo`00oooo0?ooo`040?ooo`050<co003oool0oooo0?ooo`3o
o`00RP3oool2003o02<0oooo0`00oolE0?ooo`002`3oool00`000000oooo0?ooo`280?ooo`80Ool0
1@3oool20<co0080oooo0P3oo`2:0?ooo`800?l0903oool2003ooa<0oooo000;0?ooo`030000003o
ool0oooo08X0oooo0P1oo`050?ooo`050<co003oool0oooo0?ooo`3oo`00R`3oool2003o02@0oooo
0`00ool@0?ooo`002`3oool00`000000oooo0?ooo`2<0?ooo`80Ool0103oool20<co0080oooo00<0
ool00?ooo`3oool0RP3oool2003o02D0oooo0`00ool=0?ooo`002`3oool00`000000oooo0?ooo`2>
0?ooo`80Ool0103oool00`3<o`00oooo0?ooo`020?oo08`0oooo0P00o`0V0?ooo`800?oo2`3oool0
00/0oooo00<000000?ooo`3oool0T03oool207oo00<0oooo0P3<o`020?ooo`030?oo003oool0oooo
08/0oooo0`00o`0U0?ooo`800?oo2@3oool000/0oooo00<000000?ooo`3oool0TP3oool207oo00<0
oooo0P3<o`000`3oool0ool00?ooo`2>0?ooo`800?l0;P3oool000/0oooo0`00002D0?ooo`<0Ool0
0P3oool20<co0080ool0S`3oool2003o02`0oooo000;0?ooo`030000003oool0oooo09L0oooo0P1o
o`020?ooo`030<co003oool0ool00900oooo0`00o`0Y0?ooo`002`3oool00`000000oooo0?ooo`2I
0?ooo`80Ool000@0oooo0<co003<o`00ool0TP3oool2003o02L0oooo000;0?ooo`030000003oool0
oooo09/0oooo0P1oo`00103oool0c?l00?oo003oo`2B0?ooo`800?l09@3oool000/0oooo00<00000
0?ooo`3oool0W@3oool207oo00030?ooo`3<o`00ool009<0oooo0P00o`0S0?ooo`002`3oool00`00
0000oooo0?ooo`2O0?ooo`80Ool000<0oooo0?oo003oool0T`3oool2003o0240oooo000;0?ooo`03
0000003oool0oooo0:40oooo0P1oo`020?oo09@0oooo0P00o`0O0?ooo`002`3oool00`000000oooo
0?ooo`2T0?ooo`0307oo003oo`00c?l009@0oooo0P00o`0M0?ooo`002`3oool00`000000oooo0?oo
o`2V0?ooo`80ool000<0Ool00?ooo`3oool0TP3oool2003o01/0oooo000;0?ooo`030000003oool0
oooo0:P0oooo00@0ool00<co001oo`00Ool0T`3oool2003o01T0oooo000;0?ooo`030000003oool0
oooo0:T0oooo00<0ool00<co003oool00P1oo`2C0?ooo`800?l05`3oool000/0oooo00<000000?oo
o`3oool0ZP3oool20?oo00030<co003oool0Ool00080Ool0TP3oool2003o01D0oooo000;0?ooo`<0
0000[03oool00`3oo`00c?l00<co00020?ooo`80Ool0TP3oool2003o01<0oooo000;0?ooo`030000
003oool0oooo0:d0oooo0P3oo`00103<o`00oooo0?ooo`3oool207oo0980oooo0P00o`0A0?ooo`00
2`3oool00`000000oooo0?ooo`2_0?ooo`030?oo003<o`00c?l000<0oooo0`1oo`2A0?ooo`800?l0
3`3oool000/0oooo00<000000?ooo`3oool0/03oool20?oo0080c?l0103oool207oo0940oooo0P00
o`0=0?ooo`002`3oool00`000000oooo0?ooo`2b0?ooo`040?oo003oool0c?l00<co00@0oooo0P1o
o`2A0?ooo`800?l02`3oool000/0oooo00<000000?ooo`3oool0/`3oool20?oo00030?ooo`3<o`00
c?l000@0oooo0`1oo`2@0?ooo`800?l02@3oool000/0oooo00<000000?ooo`3oool0]@3oool00`3o
o`00oooo0?ooo`020<co00D0oooo0P1oo`2I0?ooo`002`3oool00`000000oooo0?ooo`2f0?ooo`80
ool00P3oool20<co00D0oooo0`1oo`2F0?ooo`002`3oool00`000000oooo0?ooo`2h0?ooo`80ool0
0P3oool20<co00H0oooo0`1oo`2C0?ooo`000`3oool3000000D0oooo00<000000?ooo`3oool0^P3o
ool0103oo`00oooo0?ooo`3oool20<co00L0oooo0P1oo`2A0?ooo`00103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0;/0oooo0P3oo`030?ooo`80c?l01`3oool307oo08h0oooo0004
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0_@3oool00`3oo`00oooo0?ooo`02
0?ooo`80c?l0203oool307oo08/0oooo0006000000D0oooo1000002m0?ooo`80ool0103oool20<co
00T0oooo0P1oo`290?ooo`0000D0oooo0000003oool0oooo000000060?ooo`030000003oool0oooo
0<00oooo0P3oo`040?ooo`80c?l02@3oool307oo08H0oooo00001@3oool000000?ooo`3oool00000
00H0oooo00<000000?ooo`3oool0`P3oool00`3oo`00oooo0?ooo`030?ooo`80c?l02P3oool307oo
08<0oooo00020?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool0``3oool20?oo00D0
oooo0`3<o`0:0?ooo`<0Ool0P03oool000<0oooo0P0000060?ooo`030000003oool0oooo0<D0oooo
00<0ool00?ooo`3oool01@3oool20<co00/0oooo0P1oo`1n0?ooo`002`3oool00`000000oooo0?oo
o`360?ooo`80ool01`3oool20<co00/0oooo0`1oo`1k0?ooo`002`3oool00`000000oooo0?ooo`38
0?ooo`80ool01`3oool20<co00`0oooo0`1oo`1h0?ooo`002`3oool00`000000oooo0?ooo`3:0?oo
o`030?oo003oool0oooo00H0oooo0P3<o`0=0?ooo`80Ool0MP3oool000/0oooo00<000000?ooo`3o
ool0b`3oool20?oo00P0oooo0P3<o`0=0?ooo`<0Ool0L`3oool000/0oooo00<000000?ooo`3oool0
c@3oool20?oo00P0oooo0P3<o`0>0?ooo`<0Ool0L03oool000/0oooo00<000000?ooo`3oool0c`3o
ool00`3oo`00oooo0?ooo`070?ooo`80c?l03`3oool407oo06`0oooo000;0?ooo`030000003oool0
oooo0=00oooo0P3oo`090?ooo`80c?l04@3oool307oo06T0oooo000;0?ooo`<00000dP3oool00`3o
o`00oooo0?ooo`080?ooo`80c?l04P3oool307oo06H0oooo000;0?ooo`030000003oool0oooo0=<0
oooo0P3oo`0:0?ooo`80c?l04`3oool407oo0680oooo000;0?ooo`030000003oool0oooo0=D0oooo
0P3oo`0:0?ooo`80c?l05@3oool307oo05l0oooo000;0?ooo`030000003oool0oooo0=L0oooo00<0
ool00?ooo`3oool02@3oool20<co01H0oooo101oo`1K0?ooo`002`3oool00`000000oooo0?ooo`3H
0?ooo`80ool02`3oool30<co01L0oooo0`1oo`1H0?ooo`002`3oool00`000000oooo0?ooo`3J0?oo
o`80ool0303oool20<co01P0oooo0P1oo`1F0?ooo`002`3oool00`000000oooo0?ooo`3L0?ooo`80
ool0303oool20<co01P0oooo0`1oo`1C0?ooo`002`3oool00`000000oooo0?ooo`3N0?ooo`030?oo
003oool0oooo00/0oooo0P3<o`0I0?ooo`<0Ool0D03oool000/0oooo00<000000?ooo`3oool0g`3o
ool20?oo00d0oooo0P3<o`0J0?ooo`80Ool0CP3oool000/0oooo00<000000?ooo`3oool0h@3oool2
0?oo00d0oooo0P3<o`0J0?ooo`<0Ool0B`3oool000/0oooo00<000000?ooo`3oool0h`3oool20?oo
00d0oooo0`3<o`0J0?ooo`@0Ool0A`3oool000/0oooo00<000000?ooo`3oool0i@3oool00`3oo`00
oooo0?ooo`0=0?ooo`80c?l0703oool307oo04@0oooo000;0?ooo`<00000iP3oool20?oo00l0oooo
0`3<o`0L0?ooo`@0Ool0@03oool000/0oooo00<000000?ooo`3oool0j03oool20?oo0100oooo0`3<
o`0M0?ooo`<0Ool0?@3oool000/0oooo00<000000?ooo`3oool0jP3oool20?oo0140oooo0P3<o`0N
0?ooo`@0Ool0>@3oool000/0oooo00<000000?ooo`3oool0k03oool20?oo0140oooo0`3<o`0O0?oo
o`<0Ool0=P3oool000/0oooo00<000000?ooo`3oool0kP3oool20?oo0180oooo0P3<o`0P0?ooo`@0
Ool0<P3oool000/0oooo00<000000?ooo`3oool0l03oool20?oo0180oooo0P3<o`0R0?ooo`@0Ool0
;P3oool000/0oooo00<000000?ooo`3oool0lP3oool00`3oo`00oooo0?ooo`0A0?ooo`<0c?l08`3o
ool407oo02X0oooo000;0?ooo`030000003oool0oooo0?<0oooo0P3oo`0D0?ooo`80c?l09@3oool4
07oo02H0oooo000;0?ooo`030000003oool0oooo0?D0oooo0P3oo`0D0?ooo`80c?l09`3oool407oo
0280oooo000;0?ooo`030000003oool0oooo0?L0oooo0P3oo`0D0?ooo`<0c?l0:03oool307oo01l0
oooo000;0?ooo`030000003oool0oooo0?T0oooo00<0ool00?ooo`3oool0503oool20<co02T0oooo
101oo`0K0?ooo`002`3oool00`000000oooo0?ooo`3j0?ooo`80ool05P3oool30<co02X0oooo0`1o
o`0H0?ooo`002`3oool300000?`0oooo0P3oo`0G0?ooo`<0c?l0:P3oool307oo01D0oooo000;0?oo
o`030000003oool0oooo0?h0oooo0P3oo`0H0?ooo`80c?l0:`3oool307oo0180oooo000;0?ooo`03
0000003oool0oooo0?l0oooo0@3oool00`3oo`00oooo0?ooo`0G0?ooo`<0c?l0:`3oool407oo00h0
oooo000;0?ooo`030000003oool0oooo0?l0oooo0P3oool20?oo01X0oooo0P3<o`0]0?ooo`<0Ool0
2`3oool000/0oooo00<000000?ooo`3oool0o`3oool40?ooo`80ool06P3oool20<co02h0oooo0P1o
o`090?ooo`002`3oool00`000000oooo0?ooo`3o0?ooo`H0oooo0P3oo`0J0?ooo`<0c?l0=P3oool0
00/0oooo00<000000?ooo`3oool0o`3oool80?ooo`80ool06`3oool20<co03@0oooo000;0?ooo`03
0000003oool0oooo0?l0oooo2P3oool20?oo01/0oooo0P3<o`0b0?ooo`002`3oool00`000000oooo
0?ooo`3o0?ooo``0oooo0P3oo`0K0?ooo`<0c?l0;`3oool000/0oooo00<000000?ooo`3oool0o`3o
ool>0?ooo`030?oo003oool0oooo01/0oooo0P3<o`0]0?ooo`000P3oool3000000H0oooo00<00000
0?ooo`3oool0o`3oool?0?ooo`80ool07@3oool30<co02X0oooo00000`3oool000000?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`80ool07P3oool30<co
02L0oooo00000`3oool000000?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0o`3ooolC0?ooo`80ool07`3oool20<co02D0oooo00000`3oool000000?ooo`020?ooo`030000
003oool0oooo00<0oooo1000003o0?oooa@0oooo0P3oo`0O0?ooo`<0c?l08P3oool000030?ooo`00
00000000008000001P3oool00`000000oooo0?ooo`3o0?oooaL0oooo0P3oo`0P0?ooo`80c?l0803o
ool000030?ooo`000000oooo00P0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`80ool0803oool3
0<co01d0oooo00020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3ooolK0?oo
o`030?oo003oool0oooo0200oooo0`3<o`0J0?ooo`000`3oool3000000D0oooo00<000000?ooo`3o
ool0o`3ooolL0?ooo`80ool08`3oool20<co01P0oooo000;0?ooo`030000003oool0oooo0?l0oooo
7P3oool20?oo02<0oooo0`3<o`0E0?ooo`002`3oool00`000000oooo0?ooo`3o0?ooob00oooo0P3o
o`0T0?ooo`80c?l04`3oool000/0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`80ool0903oool3
0<co0100oooo000;0?ooo`030000003oool0oooo0?l0oooo903oool20?oo02D0oooo0`3<o`0=0?oo
o`002`3oool00`000000oooo0?ooo`3o0?ooobH0oooo0P3oo`0V0?ooo`80c?l02`3oool000/0oooo
00<000000?ooo`3oool0o`3ooolX0?ooo`<0ool09@3oool20<co00T0oooo000;0?ooo`030000003o
ool0oooo0?l0oooo:`3oool20?oo02h0oooo000;0?ooo`<00000o`3oool]0?ooo`80ool0;03oool0
00/0oooo00<000000?ooo`3oool0o`3oool_0?ooo`80ool0:P3oool000/0oooo00<000000?ooo`3o
ool0o`3ooola0?ooo`80ool0:03oool000/0oooo00<000000?ooo`3oool0o`3ooolc0?ooo`80ool0
9P3oool000/0oooo00<000000?ooo`3oool0o`3ooole0?ooo`80ool0903oool000/0oooo00<00000
0?ooo`3oool0o`3ooolg0?ooo`80ool08P3oool000/0oooo00<000000?ooo`3oool0o`3oooli0?oo
o`80ool0803oool000/0oooo00<000000?ooo`3oool0o`3ooolk0?ooo`80ool07P3oool000/0oooo
00<000000?ooo`3oool0o`3ooolm0?ooo`80ool0703oool000/0oooo00<000000?ooo`3oool0o`3o
oolo0?ooo`80ool06P3oool000/0oooo00<000000?ooo`3oool0o`3ooom10?ooo`80ool0603oool0
00/0oooo00<000000?ooo`3oool0o`3ooom30?ooo`<0ool05@3oool000/0oooo0`00003o0?ooodH0
oooo0P3oo`0C0?ooo`002`3oool00`000000oooo0?ooo`3o0?ooodP0oooo0P3oo`0A0?ooo`002`3o
ool00`000000oooo0?ooo`3o0?ooodX0oooo0P3oo`0?0?ooo`002`3oool00`000000oooo0?ooo`3o
0?oood`0oooo0P3oo`0=0?ooo`002`3oool00`000000oooo0?ooo`3o0?ooodh0oooo0P3oo`0;0?oo
o`002`3oool00`000000oooo0?ooo`3o0?oooe00oooo0P3oo`090?ooo`002`3oool00`000000oooo
0?ooo`3o0?oooe/0oooo000;0?ooo`030000003oool0oooo0?l0ooooF`3oool000/0oooo00<00000
0?ooo`3oool0o`3ooomK0?ooo`002`3oool00`000000oooo0?ooo`3o0?oooe/0oooo000;0?ooo`03
0000003oool0oooo0?l0ooooF`3oool000/0oooo00<000000?ooo`3oool0o`3ooomK0?ooo`00\
\>"],
  ImageRangeCache->{{{81, 368}, {271.25, 94.3125}} -> {-0.669091, 3.22116, \
0.00738887, 0.0515375}},
  CellTags->"b:1.1.1.7"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nonlinear Second-Order ODEs", "Subsection",
  CellTags->{"c:26", "b:1.1.2"}],

Cell["The general form of a nonlinear second-order ODE is", "Text",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \(TraditionalForm\`F(x, 
        y, \(y\^\[Prime]\)(x), \(y\^\[Prime]\[Prime]\)(x)) \[LongEqual] 
      0. \)], "DisplayMath",
  CellTags->"b:1.1.2"],

Cell[TextData[{
  "For simplicity, assume that the equation can be solved for the \
highest-order derivative ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "(", "x", ")"}], " "}], 
        TraditionalForm]]],
  "to give "
}], "Text",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    FormBox[
      StyleBox[\(\(y\^\[Prime]\[Prime]\)(
            x) \[LongEqual] \(\(f(x, y(x), \(y\^\[Prime]\)(x))\)\(.\)\)\),
        FontWeight->"Plain"], TraditionalForm]], "DisplayMath",
  CellTags->"b:1.1.2"],

Cell["\<\
There are a few classes of nonlinear second-order ODEs for which \
solutions can be easily found. \
\>", "Text",
  CellTags->"b:1.1.2"],

Cell[TextData[{
  "The first class consists of equations that do not explicitly depend on ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  "; that is, equations of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "(", "x", ")"}], "=", 
          RowBox[{"f", "(", 
            RowBox[{"x", ",", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "(", "x", ")"}]}], ")"}]}], 
        TraditionalForm]]],
  ". Such equations can be regarded as first-order ODEs in ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u(x)\), "=", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "(", "x", ")"}]}], 
        TraditionalForm]]],
  ". "
}], "Text",
  CellTags->"b:1.1.2"],

Cell["Here is an example of this type.", "MathCaption",
  CellTags->"b:1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\(eqn = \(y''\)[x] \[Equal] 
          5  x*\(y'\)[x]\  + \(y'\)[x]^2; \)\[IndentingNewLine]\(sol = 
        DSolve[eqn, \ y, x]\)\)\(\ \)\)\)], "Input",
  CellLabel->"In[126]:=",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            C[2] - Log[\(-10\)\ C[
                      1] + \@\(10\ \[Pi]\)\ Erfi[\@\(5\/2\)\ x]]]}}\)], \
"Output",
  CellLabel->"Out[127]=",
  CellTags->"b:1.1.2"]
}, Open  ]],

Cell[TextData[{
  "As in the case of linear second-order ODEs, the solution depends on two \
arbitrary parameters ",
  StyleBox["C[1]", "MR"],
  " and ",
  StyleBox["C[2]", "MR"],
  ". "
}], "Text",
  CellTags->"b:1.1.2"],

Cell["\<\
Here is a plot of the solution for a specific choice of parameters.\
\
\>", "MathCaption",
  CellTags->"b:1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[
      Evaluate[\(y[x] /. sol\) /. \ {C[1] \[Rule] \ \(-1\)/2, \ 
            C[2] \[Rule] \ \(-1\)/8}], \ {x, \(-0.4\), 1}, \ 
      PlotStyle\  \[Rule] \ {Red}]; \)], "Input",
  CellLabel->"In[128]:=",
  CellTags->"b:1.1.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.295918 0.680272 0.498893 0.130341 [
[.02381 .48639 -12 -9 ]
[.02381 .48639 12 0 ]
[.15986 .48639 -12 -9 ]
[.15986 .48639 12 0 ]
[.43197 .48639 -9 -9 ]
[.43197 .48639 9 0 ]
[.56803 .48639 -9 -9 ]
[.56803 .48639 9 0 ]
[.70408 .48639 -9 -9 ]
[.70408 .48639 9 0 ]
[.84014 .48639 -9 -9 ]
[.84014 .48639 9 0 ]
[.97619 .48639 -3 -9 ]
[.97619 .48639 3 0 ]
[.28342 .10787 -12 -4.5 ]
[.28342 .10787 0 4.5 ]
[.28342 .23821 -12 -4.5 ]
[.28342 .23821 0 4.5 ]
[.28342 .36855 -12 -4.5 ]
[.28342 .36855 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .49889 m
.02381 .50514 L
s
[(-0.4)] .02381 .48639 0 1 Mshowa
.15986 .49889 m
.15986 .50514 L
s
[(-0.2)] .15986 .48639 0 1 Mshowa
.43197 .49889 m
.43197 .50514 L
s
[(0.2)] .43197 .48639 0 1 Mshowa
.56803 .49889 m
.56803 .50514 L
s
[(0.4)] .56803 .48639 0 1 Mshowa
.70408 .49889 m
.70408 .50514 L
s
[(0.6)] .70408 .48639 0 1 Mshowa
.84014 .49889 m
.84014 .50514 L
s
[(0.8)] .84014 .48639 0 1 Mshowa
.97619 .49889 m
.97619 .50514 L
s
[(1)] .97619 .48639 0 1 Mshowa
.125 Mabswid
.05782 .49889 m
.05782 .50264 L
s
.09184 .49889 m
.09184 .50264 L
s
.12585 .49889 m
.12585 .50264 L
s
.19388 .49889 m
.19388 .50264 L
s
.22789 .49889 m
.22789 .50264 L
s
.2619 .49889 m
.2619 .50264 L
s
.32993 .49889 m
.32993 .50264 L
s
.36395 .49889 m
.36395 .50264 L
s
.39796 .49889 m
.39796 .50264 L
s
.46599 .49889 m
.46599 .50264 L
s
.5 .49889 m
.5 .50264 L
s
.53401 .49889 m
.53401 .50264 L
s
.60204 .49889 m
.60204 .50264 L
s
.63605 .49889 m
.63605 .50264 L
s
.67007 .49889 m
.67007 .50264 L
s
.7381 .49889 m
.7381 .50264 L
s
.77211 .49889 m
.77211 .50264 L
s
.80612 .49889 m
.80612 .50264 L
s
.87415 .49889 m
.87415 .50264 L
s
.90816 .49889 m
.90816 .50264 L
s
.94218 .49889 m
.94218 .50264 L
s
.25 Mabswid
0 .49889 m
1 .49889 L
s
.29592 .10787 m
.30217 .10787 L
s
[(-3)] .28342 .10787 1 0 Mshowa
.29592 .23821 m
.30217 .23821 L
s
[(-2)] .28342 .23821 1 0 Mshowa
.29592 .36855 m
.30217 .36855 L
s
[(-1)] .28342 .36855 1 0 Mshowa
.125 Mabswid
.29592 .13394 m
.29967 .13394 L
s
.29592 .16001 m
.29967 .16001 L
s
.29592 .18607 m
.29967 .18607 L
s
.29592 .21214 m
.29967 .21214 L
s
.29592 .26428 m
.29967 .26428 L
s
.29592 .29035 m
.29967 .29035 L
s
.29592 .31641 m
.29967 .31641 L
s
.29592 .34248 m
.29967 .34248 L
s
.29592 .39462 m
.29967 .39462 L
s
.29592 .42069 m
.29967 .42069 L
s
.29592 .44676 m
.29967 .44676 L
s
.29592 .47282 m
.29967 .47282 L
s
.29592 .0818 m
.29967 .0818 L
s
.29592 .05573 m
.29967 .05573 L
s
.29592 .02966 m
.29967 .02966 L
s
.29592 .0036 m
.29967 .0036 L
s
.29592 .52496 m
.29967 .52496 L
s
.29592 .55103 m
.29967 .55103 L
s
.29592 .5771 m
.29967 .5771 L
s
.29592 .60317 m
.29967 .60317 L
s
.25 Mabswid
.29592 0 m
.29592 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .60332 m
.02846 .57366 L
.03279 .55129 L
.04262 .51208 L
.0522 .48336 L
.06244 .45894 L
.08451 .41949 L
.10458 .39288 L
.14451 .35416 L
.18292 .32698 L
.22379 .30422 L
.26314 .28606 L
.30098 .2709 L
.34126 .25645 L
.38004 .24369 L
.42126 .23092 L
.46097 .2191 L
.49916 .20794 L
.53981 .19608 L
.57894 .18449 L
.62052 .17178 L
.66059 .15898 L
.69914 .14595 L
.74014 .13113 L
.77963 .11572 L
.8176 .09964 L
.85802 .08094 L
.89693 .06119 L
.93829 .03805 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00F03oool00`000000oooo0?ooo`350?ooo`00F03oool200000<H0oooo001H0?ooo`030000
003oool0oooo0<D0oooo001H0?ooo`030000003oool0oooo0<D0oooo001H0?ooo`030000003oool0
oooo0;d0oooo00<0o`000?ooo`3oool01@3oool005P0oooo00<000000?ooo`3oool0^`3oool20?l0
00P0oooo001H0?ooo`030000003oool0oooo0;X0oooo00<0o`000?ooo`3oool0203oool005P0oooo
00<000000?ooo`3oool0^03oool20?l000/0oooo001H0?ooo`800000]`3oool20?l000d0oooo001H
0?ooo`030000003oool0oooo0;D0oooo00<0o`000?ooo`3oool03@3oool005P0oooo00<000000?oo
o`3oool0/`3oool20?l00100oooo001H0?ooo`030000003oool0oooo0;80oooo00<0o`000?ooo`3o
ool0403oool005P0oooo00<000000?ooo`3oool0/03oool20?l001<0oooo001H0?ooo`030000003o
ool0oooo0:h0oooo0P3o000E0?ooo`00F03oool00`000000oooo0?ooo`2/0?ooo`80o`005`3oool0
05P0oooo00<000000?ooo`3oool0ZP3oool20?l001T0oooo001H0?ooo`800000Z@3oool20?l001/0
oooo001H0?ooo`030000003oool0oooo0:H0oooo0P3o000M0?ooo`00F03oool00`000000oooo0?oo
o`2T0?ooo`80o`007`3oool005P0oooo00<000000?ooo`3oool0XP3oool20?l00240oooo001H0?oo
o`030000003oool0oooo0:40oooo00<0o`000?ooo`3oool08@3oool005P0oooo00<000000?ooo`3o
ool0W`3oool20?l002@0oooo001H0?ooo`030000003oool0oooo09d0oooo0P3o000V0?ooo`00F03o
ool2000009`0oooo0P3o000X0?ooo`00F03oool00`000000oooo0?ooo`2I0?ooo`80o`00:P3oool0
05P0oooo00<000000?ooo`3oool0U`3oool20?l002`0oooo001H0?ooo`030000003oool0oooo09@0
oooo0`3o000^0?ooo`00F03oool00`000000oooo0?ooo`2B0?ooo`80o`00<@3oool00540oooo0P00
00050?ooo`030000003oool0oooo08l0oooo0`3o000c0?ooo`00D03oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo08d0oooo0P3o000f0?ooo`00DP3oool00`000000oooo0?ooo`03
0?ooo`<00000R`3oool20?l003P0oooo001:0?ooo`@000001@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo08T0oooo0P3o000j0?ooo`00D03oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo08L0oooo0P3o000l0?ooo`00D@3oool2000000D0oooo00<000000?ooo`3o
ool0Q03oool30?l003h0oooo001H0?ooo`030000003oool0oooo0840oooo0`3o00110?ooo`00F03o
ool00`000000oooo0?ooo`1o0?ooo`80o`00A03oool005P0oooo00<000000?ooo`3oool0O03oool3
0?l004H0oooo001H0?ooo`030000003oool0oooo07T0oooo0`3o00190?ooo`00F03oool2000007L0
oooo0`3o001<0?ooo`00F03oool00`000000oooo0?ooo`1d0?ooo`80o`00C`3oool005P0oooo00<0
00000?ooo`3oool0L@3oool30?l00540oooo001H0?ooo`030000003oool0oooo06h0oooo0`3o001D
0?ooo`00F03oool00`000000oooo0?ooo`1[0?ooo`<0o`00E`3oool005P0oooo00<000000?ooo`3o
ool0J@3oool20?l005X0oooo001H0?ooo`030000003oool0oooo06H0oooo0`3o001L0?ooo`00F03o
ool2000006@0oooo0`3o001O0?ooo`00F03oool00`000000oooo0?ooo`1O0?ooo`@0o`00HP3oool0
05P0oooo00<000000?ooo`3oool0F`3oool40?l006H0oooo001H0?ooo`030000003oool0oooo05P0
oooo0`3o001Z0?ooo`00F03oool00`000000oooo0?ooo`1E0?ooo`<0o`00K@3oool005P0oooo00<0
00000?ooo`3oool0DP3oool30?l00700oooo001H0?ooo`030000003oool0oooo04l0oooo0`3o001c
0?ooo`00F03oool2000004d0oooo0`3o001f0?ooo`00F03oool00`000000oooo0?ooo`180?ooo`@0
o`00N@3oool005P0oooo00<000000?ooo`3oool0A03oool40?l007d0oooo001H0?ooo`030000003o
ool0oooo0440oooo0`3o00210?ooo`00F03oool00`000000oooo0?ooo`0n0?ooo`<0o`00Q03oool0
05P0oooo00<000000?ooo`3oool0>`3oool30?l008L0oooo001H0?ooo`030000003oool0oooo03P0
oooo0`3o002:0?ooo`00F03oool00`000000oooo0?ooo`0e0?ooo`<0o`00S@3oool005P0oooo0P00
000c0?ooo`<0o`00T03oool005P0oooo00<000000?ooo`3oool0;P3oool40?l009<0oooo001H0?oo
o`030000003oool0oooo02/0oooo0`3o002G0?ooo`00F03oool00`000000oooo0?ooo`0W0?ooo`@0
o`00VP3oool005P0oooo00<000000?ooo`3oool08`3oool40?l009h0oooo001@0?ooo`@00000103o
ool00`000000oooo0?ooo`0O0?ooo`@0o`00XP3oool00500oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0L0?ooo`<0o`00YP3oool00540oooo00<000000?ooo`3oool0103oool30000
01X0oooo0P3o002Y0?ooo`00BP3oool4000000@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0G0?ooo`<0o`00Z`3oool00500oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`0D0?ooo`<0o`00[P3oool00540oooo0P0000050?ooo`030000003oool0oooo0100oooo
103o002a0?ooo`00F03oool00`000000oooo0?ooo`0<0?ooo`@0o`00]@3oool005P0oooo00<00000
0?ooo`3oool02@3oool30?l00;T0oooo001H0?ooo`030000003oool0oooo00H0oooo0`3o002l0?oo
o`00F03oool2000000D0oooo0P3o002o0?ooo`00F03oool010000000oooo0?ooo`3oool30?l00<40
oooo001H0?ooo`040000003o0000o`000?l00<@0oooo001G0?ooo`80o`00a`3oool005D0oooo0P3o
00000`3oool000000?ooo`360?ooo`00D`3oool20?l000<0oooo00<000000?ooo`3oool0a@3oool0
0540oooo0P3o00050?ooo`030000003oool0oooo0<D0oooo001>0?ooo`<0o`001`3oool00`000000
oooo0?ooo`350?ooo`00C03oool20?l000X0oooo0P0000360?ooo`00BP3oool20?l000`0oooo00<0
00000?ooo`3oool0a@3oool004P0oooo0P3o000>0?ooo`030000003oool0oooo0<D0oooo00160?oo
o`80o`00403oool00`000000oooo0?ooo`350?ooo`00A03oool20?l00180oooo00<000000?ooo`3o
ool0a@3oool00480oooo0P3o000D0?ooo`030000003oool0oooo0<D0oooo00100?ooo`80o`005P3o
ool00`000000oooo0?ooo`350?ooo`00?P3oool20?l001P0oooo0P0000360?ooo`00?03oool20?l0
01X0oooo00<000000?ooo`3oool0a@3oool003X0oooo0P3o000L0?ooo`030000003oool0oooo0<D0
oooo000h0?ooo`80o`007P3oool00`000000oooo0?ooo`350?ooo`00=`3oool00`3o0000oooo0?oo
o`0N0?ooo`030000003oool0oooo0<D0oooo000e0?ooo`80o`008@3oool00`000000oooo0?ooo`35
0?ooo`00=03oool00`3o0000oooo0?ooo`0Q0?ooo`030000003oool0oooo0<D0oooo000c0?ooo`03
0?l0003oool0oooo0280oooo0P0000360?ooo`00<P3oool00`3o0000oooo0?ooo`0S0?ooo`030000
003oool0oooo0<D0oooo000`0?ooo`80o`009P3oool00`000000oooo0?ooo`350?ooo`00;`3oool0
0`3o0000oooo0?ooo`0V0?ooo`030000003oool0oooo0<D0oooo000^0?ooo`030?l0003oool0oooo
02L0oooo00<000000?ooo`3oool0a@3oool002d0oooo00<0o`000?ooo`3oool0:03oool00`000000
oooo0?ooo`350?ooo`00;03oool00`3o0000oooo0?ooo`0Q0?ooo`D000000`3oool00`000000oooo
0?ooo`350?ooo`00:`3oool00`3o0000oooo0?ooo`0T0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0a@3oool002X0oooo00<0o`000?ooo`3oool09@3oool00`000000oooo0?ooo`03
0?ooo`<00000a@3oool002T0oooo00<0o`000?ooo`3oool07P3oool4000000@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`350?ooo`009`3oool20?l002T0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`350?ooo`009P3oool00`3o0000oooo0?ooo`0X0?ooo`800000
1@3oool00`000000oooo0?ooo`350?ooo`009@3oool00`3o0000oooo0?ooo`0`0?ooo`030000003o
ool0oooo0<D0oooo000T0?ooo`030?l0003oool0oooo0340oooo00<000000?ooo`3oool0a@3oool0
02<0oooo00<0o`000?ooo`3oool0<P3oool00`000000oooo0?ooo`350?ooo`008P3oool00`3o0000
oooo0?ooo`0c0?ooo`800000aP3oool00240oooo00<0o`000?ooo`3oool0=03oool00`000000oooo
0?ooo`350?ooo`008@3oool00`3o0000oooo0?ooo`0d0?ooo`030000003oool0oooo0<D0oooo000P
0?ooo`030?l0003oool0oooo03D0oooo00<000000?ooo`3oool0a@3oool001l0oooo00<0o`000?oo
o`3oool0=P3oool00`000000oooo0?ooo`350?ooo`007P3oool00`3o0000oooo0?ooo`0g0?ooo`03
0000003oool0oooo0<D0oooo000N0?ooo`030?l0003oool0oooo03L0oooo00<000000?ooo`3oool0
a@3oool001d0oooo00<0o`000?ooo`3oool0>03oool200000<H0oooo000L0?ooo`030?l0003oool0
oooo03T0oooo00<000000?ooo`3oool0a@3oool001`0oooo00<0o`000?ooo`3oool0>@3oool00`00
0000oooo0?ooo`350?ooo`006`3oool00`3o0000oooo0?ooo`0j0?ooo`030000003oool0oooo0<D0
oooo000J0?ooo`030?l0003oool0oooo03/0oooo00<000000?ooo`3oool0a@3oool001X0oooo00<0
o`000?ooo`3oool0>`3oool00`000000oooo0?ooo`350?ooo`006@3oool00`3o0000oooo0?ooo`0l
0?ooo`030000003oool0oooo0<D0oooo000I0?ooo`030?l0003oool0oooo03`0oooo00<000000?oo
o`3oool0a@3oool001P0oooo00<0o`000?ooo`3oool0?@3oool200000<H0oooo000G0?ooo`030?l0
003oool0oooo03h0oooo00<000000?ooo`3oool0a@3oool001L0oooo00<0o`000?ooo`3oool0?P3o
ool00`000000oooo0?ooo`350?ooo`00203oool2000000@0oooo0P0000050?ooo`030000003o0000
000001H0oooo0P0000040?ooo`8000000`3oool4000001/0oooo00<000000?ooo`3oool0703oool2
000000@0oooo0P0000030?ooo`@00000603oool2000000@0oooo0P0000050?ooo`<000005P3oool2
000000@0oooo0P0000030?ooo`<00000603oool2000000@0oooo0P0000040?ooo`8000007P3oool5
000000D0oooo00070?ooo`040000003oool0oooo000000/0oooo00<0o`000?ooo`3oool0503oool0
10000000oooo0?ooo`0000080?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool06`3o
ool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo01P0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`0D0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000005P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000001l0oooo
00<000000?ooo`3oool01@3oool000L0oooo00@000000?ooo`3oool00000203oool2000000030?l0
00000000000001D0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo01/0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0G0?oo
o`040000003oool0oooo000000P0oooo1@00000E0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000005P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
01l0oooo00<000000?ooo`3oool01@3oool000030?ooo`0000000000008000000P3oool010000000
oooo0?ooo`0000080?ooo`040000003oool0o`0000000100oooo100000020?ooo`040000003oool0
oooo000000X0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0K0?ooo`040000003o
ool0oooo000000X0oooo00<000000?ooo`3oool05P3oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo000001H0oooo00@000000?ooo`3oool00000203oool3000001L0oooo00@00000
0?ooo`3oool000002@3oool200000200oooo00<000000?ooo`3oool01@3oool000L0oooo00@00000
0?ooo`3oool000002@3oool00`000000o`000000000F0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000006`3oool2000001`0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`00000G0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`0000005P3o
ool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`00000O0?ooo`030000003oool0oooo00D0oooo00080?ooo`80
00002`3oool00`3o000000000?ooo`0F0?ooo`8000002P3oool2000001`0oooo00<000000?ooo`3o
ool0703oool2000000X0oooo0P00000I0?ooo`8000002`3oool2000001L0oooo0P00000:0?ooo`<0
00005`3oool2000000X0oooo0P00000O0?ooo`8000001`3oool001@0oooo00<0o`000?ooo`3oool0
@@3oool00`000000oooo0?ooo`350?ooo`00503oool00`3o0000oooo0?ooo`110?ooo`030000003o
ool0oooo0<D0oooo000D0?ooo`030?l0003oool0oooo0440oooo00<000000?ooo`3oool0a@3oool0
01<0oooo00<0o`000?ooo`3oool0@P3oool00`000000oooo0?ooo`350?ooo`004`3oool00`3o0000
oooo0?ooo`120?ooo`030000003oool0oooo0<D0oooo000B0?ooo`030?l0003oool0oooo04<0oooo
00<000000?ooo`3oool0a@3oool000D0oooo3@0000000`3o000000000000003o000000`00000000<
0?ooo`030000003oool0oooo00<0oooo00@0o`000?ooo`3oool000002@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00140oooo00<0o`00
0?ooo`3oool0A03oool00`000000oooo0?ooo`350?ooo`004@3oool00`3o0000oooo0?ooo`140?oo
o`030000003oool0oooo0<D0oooo000A0?ooo`030?l0003oool0oooo04@0oooo00<000000?ooo`3o
ool0a@3oool00100oooo00<0o`000?ooo`3oool0A@3oool00`000000oooo0?ooo`350?ooo`00403o
ool00`3o0000oooo0?ooo`150?ooo`030000003oool0oooo0<D0oooo000@0?ooo`030?l0003oool0
oooo04D0oooo0P0000360?ooo`00403oool00`3o0000oooo0?ooo`150?ooo`030000003oool0oooo
0<D0oooo000?0?ooo`030?l0003oool0oooo04H0oooo00<000000?ooo`3oool0a@3oool000l0oooo
00<0o`000?ooo`3oool0AP3oool00`000000oooo0?ooo`350?ooo`003`3oool00`3o0000oooo0?oo
o`160?ooo`030000003oool0oooo0<D0oooo000?0?ooo`030?l0003oool0oooo04H0oooo00<00000
0?ooo`3oool0a@3oool000h0oooo00<0o`000?ooo`3oool0A`3oool00`000000oooo0?ooo`350?oo
o`003P3oool00`3o0000oooo0?ooo`170?ooo`800000aP3oool000h0oooo00<0o`000?ooo`3oool0
A`3oool00`000000oooo0?ooo`350?ooo`003P3oool00`3o0000oooo0?ooo`170?ooo`030000003o
ool0oooo0<D0oooo000>0?ooo`030?l0003oool0oooo04L0oooo00<000000?ooo`3oool0a@3oool0
00d0oooo00<0o`000?ooo`3oool0B03oool00`000000oooo0?ooo`350?ooo`003@3oool00`3o0000
oooo0?ooo`180?ooo`030000003oool0oooo0<D0oooo000=0?ooo`030?l0003oool0oooo04P0oooo
00<000000?ooo`3oool0a@3oool000d0oooo00<0o`000?ooo`3oool0B03oool00`000000oooo0?oo
o`350?ooo`003@3oool00`3o0000oooo0?ooo`180?ooo`800000aP3oool000d0oooo00<0o`000?oo
o`3oool0B03oool00`000000oooo0?ooo`350?ooo`003@3oool00`3o0000oooo0?ooo`180?ooo`03
0000003oool0oooo0<D0oooo000<0?ooo`030?l0003oool0oooo04T0oooo00<000000?ooo`3oool0
a@3oool000`0oooo00<0o`000?ooo`3oool0B@3oool00`000000oooo0?ooo`350?ooo`00303oool0
0`3o0000oooo0?ooo`190?ooo`030000003oool0oooo0<D0oooo000<0?ooo`030?l0003oool0oooo
04T0oooo00<000000?ooo`3oool0a@3oool000`0oooo00<0o`000?ooo`3oool0B@3oool200000<H0
oooo001H0?ooo`030000003oool0oooo0<D0oooo001H0?ooo`030000003oool0oooo0<D0oooo001H
0?ooo`030000003oool0oooo0<D0oooo001H0?ooo`030000003oool0oooo0<D0oooo003o0?ooob40
oooo0000\
\>"],
  ImageRangeCache->{{{81, 368}, {312.438, 135.5}} -> {-0.885302, -0.17589, \
0.00521823, 0.0272348}},
  CellTags->"b:1.1.2"]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
  CellTags->"b:1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqn /. sol // Simplify\)], "Input",
  CellLabel->"In[129]:=",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \({True}\)], "Output",
  CellLabel->"Out[129]=",
  CellTags->"b:1.1.2"]
}, Open  ]],

Cell["\<\
The previous example, in fact, reduces to a Riccati equation. If \
the constant 7 is added to the right-hand side of the previous equation, the \
resulting Riccati equation is solved by transforming it to a second-order \
linear ODE. \
\>", "Text",
  CellTags->"b:1.1.2"],

Cell["This solves the new equation.", "MathCaption",
  CellTags->"b:1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(sol\)\(=\)\(DSolve[\(y''\)[x] \[Equal] 
          5  x*\(y'\)[x]\  + \(y'\)[x]^2\  + 7, \ y, x]\)\(\ \)\)\)], "Input",\

  CellLabel->"In[130]:=",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, 
            C[2] - Log[
                C[1]\ HermiteH[7\/5, \@\(5\/2\)\ x] + 
                  Hypergeometric1F1[\(-\(7\/10\)\), 
                    1\/2, \(5\ x\^2\)\/2]]]}}\)], "Output",
  CellLabel->"Out[130]=",
  CellTags->"b:1.1.2"]
}, Open  ]],

Cell[TextData[{
  "So both these nonlinear ODEs are",
  StyleBox[" linearizable",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"b:1.1.2"],

Cell[TextData[{
  "The second class of easily solvable nonlinear second-order equations \
consists of equations that do not depend explicitly on ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " or ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "(", "x", ")"}], TraditionalForm]]],
  "; that is, equations of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "(", "x", ")"}], 
          "\[LongEqual]", \(f(y(x))\)}], TraditionalForm]]],
  ". These equations can be reduced to first-order ODEs with independent \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". Inverse functions are needed to give the final solution for ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  ". "
}], "Text",
  CellTags->"b:1.1.2"],

Cell["Here is an example of this type.", "MathCaption",
  CellTags->"b:1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y''\)[x]\  == \ Exp[3*y[x]], \ y[x], x]\)], "Input",
  CellLabel->"In[131]:=",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    RowBox[{\(Solve::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse functions are \
being used by \\!\\(Solve\\), so some solutions may not be found; use Reduce \
for complete solution information. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          Log[\(-\((\(-\(3\/2\)\))\)\^\(1/3\)\)\ \((\(-C[1]\) + C[1]\ \
Tanh[3\/2\ \@\(C[1]\ \((x + C[2])\)\^2\)]\^2)\)\^\(1/3\)]}, {y[x] \[Rule] 
          Log[\((3\/2)\)\^\(1/3\)\ \((\(-C[1]\) + C[1]\ Tanh[3\/2\ \@\(C[1]\ \
\((x + C[2])\)\^2\)]\^2)\)\^\(1/3\)]}, {y[x] \[Rule] 
          Log[\((\(-1\))\)\^\(2/3\)\ \((3\/2)\)\^\(1/3\)\ \((\(-C[1]\) + C[1]\
\ Tanh[3\/2\ \@\(C[1]\ \((x + C[2])\)\^2\)]\^2)\)\^\(1/3\)]}}\)], "Output",
  CellLabel->"Out[131]=",
  CellTags->"b:1.1.2"]
}, Open  ]],

Cell[TextData[{
  "The third class consists of equations that do not depend explicitly on ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "; that is, equations of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "(", "x", ")"}], "=", 
          RowBox[{"f", "(", 
            RowBox[{\(y(x)\), ",", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "(", "x", ")"}]}], ")"}]}], 
        TraditionalForm]]],
  ". Once again, these equations can be reduced to first-order ODEs with \
independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". "
}], "Text",
  CellTags->"b:1.1.2"],

Cell[TextData[{
  "This example is based on equation 6.40 on page 550 of [",
  ButtonBox["K59",
    ButtonData:>"K59",
    ButtonStyle->"Hyperlink"],
  "]. The underlying first-order ODE is an Abel equation. The hyperbolic \
functions in the solution result from the automatic simplification of Bessel \
functions."
}], "MathCaption",
  CellTags->"b:1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = \ 
      y[x] /. \(DSolve[\(y''\)[x]\  == 
                3*y[x]*\(y'\)[x]\  + \((3  y[x]^2 + 4*y[x]\  + 1)\), \ y[x], 
              x]\)[\([\)\(1\)\(]\)] // Simplify\)], "Input",
  CellLabel->"In[132]:=",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \(\((\((\[ImaginaryI]\ \@6\ \@\[ExponentialE]\^\(\(-2\)\ x\)\ \@C[1] - 
                6\ C[2])\)\ Cosh[\@\(3\/2\)\ \@\[ExponentialE]\^\(\(-2\)\ x\)\
\ \@C[1]] + \((\(-3\)\ \[ImaginaryI] + 
                2\ \@6\ \@\[ExponentialE]\^\(\(-2\)\ x\)\ \@C[1]\ C[
                    2])\)\ Sinh[\@\(3\/2\)\ \@\[ExponentialE]\^\(\(-2\)\ x\)\ \
\@C[1]])\)/\((6\ C[
              2]\ Cosh[\@\(3\/2\)\ \@\[ExponentialE]\^\(\(-2\)\ x\)\ \@C[1]] \
+ 3\ \[ImaginaryI]\ Sinh[\@\(3\/2\)\ \@\[ExponentialE]\^\(\(-2\)\ x\)\ \
\@C[1]])\)\)], "Output",
  CellLabel->"Out[132]=",
  CellTags->"b:1.1.2"]
}, Open  ]],

Cell[TextData[{
  "The fourth class consists of equations that are homogeneous in some or all \
of the variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  ", and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "(", "x", ")"}], TraditionalForm]]],
  ". There are several possibilities in this case, but here only the \
following simple example is considered."
}], "Text",
  CellTags->"b:1.1.2"],

Cell[TextData[{
  "In this equation, each term has a total degree of 2 in the variables ",
  Cell[BoxData[
      \(y[x]\)]],
  ", ",
  Cell[BoxData[
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]]],
  ", and ",
  Cell[BoxData[
      RowBox[{
        SuperscriptBox["y", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]]],
  ". This equation can be solved by transforming it to a first-order ODE. "
}], "MathCaption",
  CellTags->"b:1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[7*y[x]*\(y''\)[x]\  - 11*\(y'\)[x]^2 \[Equal] 0, \ y[x], \ 
      x]\)], "Input",
  CellLabel->"In[133]:=",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \({{y[x] \[Rule] C[2]\/\((4\ x + 7\ C[1])\)\^\(7/4\)}}\)], "Output",
  CellLabel->"Out[133]=",
  CellTags->"b:1.1.2"]
}, Open  ]],

Cell["\<\
The fifth and final class of easily solvable nonlinear second-order \
ODEs consists of equations that are exact or can be made to be exact using an \
integrating factor. \
\>", "Text",
  CellTags->"b:1.1.2"],

Cell[TextData[{
  "Here is an example of this type, based on equation 6.51 on page 554 of [",
  ButtonBox["K59",
    ButtonData:>"K59",
    ButtonStyle->"Hyperlink"],
  "]."
}], "MathCaption",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    \(eqn = \(y''\)[x]\  + y[x]*\ \(y'\)[x]^2 - x^2*\(y'\)[x] \[Equal] 
        0; \)], "Input",
  CellLabel->"In[134]:=",
  CellTags->"b:1.1.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[eqn, \ y[x], \ x]\)], "Input",
  CellLabel->"In[135]:=",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"ifun"\), \(\(:\)\(\ \)\), "\<\"Inverse \
functions are being used. Values may be lost for multivalued inverses. \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"InverseFunction::ifun\\\"]\\)\"\>"}]], \
"Message",
  CellTags->"b:1.1.2"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{\(y[x]\), "\[Rule]", 
          RowBox[{\(\@2\), " ", 
            RowBox[{
              TagBox[\(Erfi\^\((\(-1\))\)\),
                {InverseFunction, 1, 1},
                Editable->False], 
              "[", \(\(3\ \@\(2\ \[Pi]\)\ C[
                        2] - \(3\^\(1/3\)\ \@\(2\ \[Pi]\)\ \
\((\(-x\^3\))\)\^\(2/3\)\ C[1]\ Gamma[1\/3, \(-\(x\^3\/3\)\)]\)\/x\^2\)\/\(3\ \
\[Pi]\)\), "]"}]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[135]=",
  CellTags->"b:1.1.2"]
}, Open  ]],

Cell["\<\
It is important to note that the solutions to fairly simple-looking \
nonlinear ODEs can be complicated. Verifying and applying the solutions in \
such cases is a difficult problem.\
\>", "Text",
  CellTags->"b:1.1.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Higher-Order ODEs", "Subsection",
  CellTags->"c:27"],

Cell["Overview", "Subsubsection",
  CellTags->{"c:27.5", "b:1.1.3.0"}],

Cell[TextData[{
  "The general form of an ODE with order ",
  StyleBox["n",
    FontSlant->"Italic"],
  " ",
  "is"
}], "Text",
  CellTags->"b:1.1.3.0"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"F", "(", 
          RowBox[{"x", ",", \(y(x)\), ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "(", "x", ")"}], ",", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "(", "x", ")"}], ",", "\[Ellipsis]",
             ",", \(\(y\^\((n)\)\)(x)\)}], ")"}], "=", "0."}], 
      TraditionalForm]], "DisplayMath",
  CellTags->"b:1.1.3.0"],

Cell[TextData[{
  "As in the case of second order ODEs, such an ODE can be classified as \
linear or nonlinear. The general form of a linear ODE of order ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is"
}], "Text",
  CellTags->"b:1.1.3.0"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\ \)\(\(\(a\_0\)(x)\) \(\(y\^\(\(\ \)\((n)\)\)\)(
            x)\) + \(\(a\_1\)(x)\) \(\(y\^\((n - 1)\)\)(
            x)\)\  + \[Ellipsis] + \ \(\(a\_n\)(x)\) \(y(x)\) = \(\(b(
          x)\)\(.\)\)\)\)\)], "DisplayMath",
  CellTags->"b:1.1.3.0"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`b(x)\)]],
  " is the zero function, the equation is said to be",
  StyleBox[" homogeneous",
    FontSlant->"Italic"],
  ". This section is primarily restricted to that case."
}], "Text",
  CellTags->"b:1.1.3.0"],

Cell[TextData[{
  "Many methods for solving linear second-order ODEs can be generalized to \
linear ODEs of order ",
  StyleBox["n",
    FontSlant->"Italic"],
  ", where",
  " ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is greater than 2. If the order of the ODE is not important, it is simply \
called a linear ODE."
}], "Text",
  CellTags->"b:1.1.3.0"],

Cell[CellGroupData[{

Cell["Equations with Constant Coefficients", "Subsubsection",
  CellTags->{"c:28", "b:1.1.3.1"}],

Cell[TextData[{
  "A linear ODE with ",
  StyleBox["constant coefficients",
    FontSlant->"Italic"],
  " can be easily solved once the roots of the auxiliary equation (or \
characteristic equation) are known. Some examples of this type follow."
}], "Text",
  CellTags->"b:1.1.3.1"],

Cell["\<\
The characteristic equation of this ODE has real and distinct \
roots: 4, 1 and 7. Hence the solution is composed entirely of exponential \
functions.\
\>", "MathCaption",
  CellTags->"b:1.1.3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y'''\)[x]\  - 4*\(y''\)[x] - 25*\(y'\)[x] + 28*y[x] \[Equal] 
        0, \ y[x], \ x]\)], "Input",
  CellLabel->"In[136]:=",
  CellTags->"b:1.1.3.1"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(\(-4\)\ x\)\ C[
                1] + \[ExponentialE]\^x\ C[2] + \[ExponentialE]\^\(7\ x\)\ C[
                3]}}\)], "Output",
  CellLabel->"Out[136]=",
  CellTags->"b:1.1.3.1"]
}, Open  ]],

Cell[TextData[{
  "The characteristic equation of this ODE has two pairs of equal roots: -3 \
and -5. The repeated roots give rise to the",
  StyleBox[" basis ",
    FontSlant->"Italic"],
  "of the solutions",
  StyleBox[",",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`{\[ExponentialE]\^\(3\ x\), 
        x\ \[ExponentialE]\^\(3\ x\), \[ExponentialE]\^\(5\ x\), 
        x\ \[ExponentialE]\^\(5\ x\)}\)]],
  "."
}], "MathCaption",
  CellTags->"b:1.1.3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y''''\)[x]\  - 16*\(y'''\)[x] + 94*\(y''\)[x] - 
          240*\(y'\)[x]\  + 225*y[x] \[Equal] 0, \ y[x], x]\)], "Input",
  CellLabel->"In[137]:=",
  CellTags->"b:1.1.3.1"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(3\ x\)\ C[
                1] + \[ExponentialE]\^\(3\ x\)\ x\ C[
                2] + \[ExponentialE]\^\(5\ x\)\ C[
                3] + \[ExponentialE]\^\(5\ x\)\ x\ C[4]}}\)], "Output",
  CellLabel->"Out[137]=",
  CellTags->"b:1.1.3.1"]
}, Open  ]],

Cell[TextData[{
  "The characteristic equation for this ODE has two pairs of imaginary roots: \
",
  Cell[BoxData[
      \(TraditionalForm\`3 + 4\ \[ImaginaryI]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`3 - 4\ \[ImaginaryI]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`2 + \[ImaginaryI]\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`2 - \[ImaginaryI]\)]],
  ". Hence the solution basis can be expressed with trigonometric and \
exponential functions."
}], "MathCaption",
  CellTags->"b:1.1.3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y''''\)[x]\  - 10*\(y'''\)[x] + 54*\(y''\)[x] - 
          130*\(y'\)[x] + 125*y[x] \[Equal] 0, \ y[x], x]\)], "Input",
  CellLabel->"In[138]:=",
  CellTags->"b:1.1.3.1"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(2\ x\)\ C[2]\ Cos[
                x] + \[ExponentialE]\^\(3\ x\)\ C[4]\ Cos[
                4\ x] + \[ExponentialE]\^\(2\ x\)\ C[1]\ Sin[
                x] + \[ExponentialE]\^\(3\ x\)\ C[3]\ Sin[4\ x]}}\)], "Output",\

  CellLabel->"Out[138]=",
  CellTags->"b:1.1.3.1"]
}, Open  ]],

Cell["\<\
Finally, here is an example that combines all the previous kinds of \
solutions.\
\>", "MathCaption",
  CellTags->"b:1.1.3.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(y'''''\)[x]\  - 17*\(y''''\)[x] + 108*\(y'''\)[x] - 
          330*\(y''\)[x] + 488*\(y'\)[x] - 280*y[x] \[Equal] 0, \ y[x], 
      x]\)], "Input",
  CellLabel->"In[139]:=",
  CellTags->"b:1.1.3.1"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \[ExponentialE]\^\(2\ x\)\ C[
                3] + \[ExponentialE]\^\(2\ x\)\ x\ C[
                4] + \[ExponentialE]\^\(7\ x\)\ C[
                5] + \[ExponentialE]\^\(3\ x\)\ C[2]\ Cos[
                x] + \[ExponentialE]\^\(3\ x\)\ C[1]\ Sin[x]}}\)], "Output",
  CellLabel->"Out[139]=",
  CellTags->"b:1.1.3.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Euler and Legendre Equations", "Subsubsection",
  CellTags->{"c:29", "b:1.1.3.2"}],

Cell[TextData[{
  "An ",
  StyleBox["Euler equation",
    FontSlant->"Italic"],
  " is an ODE of the form"
}], "Text",
  CellTags->"b:1.1.3.2"],

Cell[BoxData[
    FormBox[
      RowBox[{
      "                                                              ", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{\(x\^n\), "  ", 
                  RowBox[{
                    SuperscriptBox["y", \(\((n)\)\(\ \)\),
                      MultilineFunction->None], "(", "x", ")"}]}], " ", "+", 
                RowBox[{\(a\_\(\(1\)\(\ \)\)\), " ", \(x\^\(n - 1\)\), " ", 
                  RowBox[{
                    SuperscriptBox["y", \((n - 1)\),
                      MultilineFunction->None], "(", "x", ")"}]}], " ", "+", 
                RowBox[{\(a\_\(\(2\)\(\ \)\)\), " ", \(x\^\(n - 2\)\), " ", 
                  RowBox[{
                    SuperscriptBox["y", \((n - 2)\),
                      MultilineFunction->None], "(", "x", ")"}]}]}], " ", 
              "..."}], " ", "+", \(a\_n\ \(y(x)\)\)}], "\[LongEqual]", 
          "0."}]}], TraditionalForm]], "Text",
  CellTags->"b:1.1.3.2"],

Cell["The following is an example of an Euler equation.", "MathCaption",
  CellTags->"b:1.1.3.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[
      x^4*\(y''''\)[x]\  - 2*x^3*\(y'''\)[x]\  - x^2*\(y''\)[x]\  + 
          5*x*\(y'\)[x] + y[x] \[Equal] 0, \ y[x], x]\)], "Input",
  CellLabel->"In[140]:=",
  CellTags->"b:1.1.3.2"],

Cell[BoxData[
    \({{y[x] \[Rule] 
          x\^Root[1 - 4\ #1 + 16\ #1\^2 - 8\ #1\^3 + #1\^4 &, 1]\ C[1] + 
            x\^Root[1 - 4\ #1 + 16\ #1\^2 - 8\ #1\^3 + #1\^4 &, 2]\ C[2] + 
            x\^Root[1 - 4\ #1 + 16\ #1\^2 - 8\ #1\^3 + #1\^4 &, 3]\ C[3] + 
            x\^Root[1 - 4\ #1 + 16\ #1\^2 - 8\ #1\^3 + #1\^4 &, 4]\ C[
                4]}}\)], "Output",
  CellLabel->"Out[140]=",
  CellTags->"b:1.1.3.2"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Legendre Linear",
    FontSlant->"Italic"],
  " equation is a generalization of the Euler equation. It has the form "
}], "Text",
  CellTags->"b:1.1.3.2"],

Cell[BoxData[
    FormBox[
      RowBox[{"                     ", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{\(\(\((c\ x\  + \ d)\)\(\ \)\)\^n\), "  ", 
                  RowBox[{
                    SuperscriptBox["y", \(\((n)\)\(\ \)\),
                      MultilineFunction->None], "(", "x", ")"}]}], " ", "+", 
                
                RowBox[{\(a\_\(\(1\)\(\ \)\)\), 
                  " ", \(\(\((c\ x\  + \ d)\)\(\ \)\)\^\(n - 1\)\), " ", 
                  RowBox[{
                    SuperscriptBox["y", \((n - 1)\),
                      MultilineFunction->None], "(", "x", ")"}]}], " ", "+", 
                
                RowBox[{\(a\_\(\(2\)\(\ \)\)\), 
                  " ", \(\(\((c\ x\  + \ d)\)\(\ \