(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    167567,       8994]*)
(*NotebookOutlinePosition[    169143,       9050]*)
(*  CellTagsIndexPosition[    168918,       9039]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["DoubleStep", "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"s:1"],

Cell[TextData[{
  "The method ",
  StyleBox["DoubleStep", "MR"],
  " performs a single application of Richardson's extrapolation for any \
one-step integration method."
}], "Text"],

Cell["\<\
Although it is not always optimal, it is a general scheme for \
equipping a method with an error estimate (hence adaptivity in the step size) \
and extrapolating to increase the order of local accuracy.\
\>", "Text"],

Cell[TextData[{
  StyleBox["DoubleStep", "MR"],
  " is a special case of extrapolation but has been implemented as a separate \
method for efficiency."
}], "Text"],

Cell[TextData[{
  "Given a method of order ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ":"
}], "Text"],

Cell[TextData[{
  "Take a step of size ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " to get a solution ",
  Cell[BoxData[
      \(TraditionalForm\`y\_1\)]],
  "."
}], "BulletedList"],

Cell[TextData[{
  "Take two steps of size ",
  Cell[BoxData[
      \(TraditionalForm\`h/2\)]],
  " to get a solution ",
  Cell[BoxData[
      \(TraditionalForm\`y\_2\)]],
  "."
}], "BulletedList"],

Cell[TextData[{
  "Find an error estimate of order ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " as:"
}], "BulletedList"],

Cell[BoxData[
    FormBox[
      RowBox[{"e", "=", 
        RowBox[{
          FormBox[\(\(\(\ \)\(y\_2 - \ y\_1\)\)\/\(2\^p - \ 1\)\),
            "TraditionalForm"], "."}]}], TraditionalForm]], "NumberedEquation",\

  CellTags->"DSErrorEstimate"],

Cell[TextData[{
  "The correction term ",
  Cell[BoxData[
      \(TraditionalForm\`e\)]],
  " can be used for error estimation enabling an adaptive step-size scheme \
for any base method."
}], "BulletedList"],

Cell[TextData[{
  "Either use ",
  Cell[BoxData[
      \(TraditionalForm\`y\_2\)]],
  " for the new solution, or form an improved approximation using local \
extrapolation as:"
}], "BulletedList"],

Cell[BoxData[
    FormBox[
      RowBox[{\(y\&^\_2\), "=", 
        RowBox[{
          FormBox[\(y\_\(\(2\)\(\ \)\) + e\),
            "TraditionalForm"], "."}]}], TraditionalForm]], "NumberedEquation",\

  CellTags->"DSLocalExtrapolation"],

Cell[TextData[{
  "If the base numerical integration method is symmetric, then the improved \
approximation has order ",
  Cell[BoxData[
      \(TraditionalForm\`p + 2\)]],
  "; otherwise it has order ",
  Cell[BoxData[
      \(TraditionalForm\`p + 1\)]],
  "."
}], "BulletedList"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",
  CellTags->"s:2"],

Cell["\<\
Load some package with example problems and utility \
functions.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(Needs["\<DifferentialEquations`NDSolveProblems`\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(Needs["\<DifferentialEquations`NDSolveUtilities`\>"];\)\)}], "Input",
  CellLabel->"In[5]:=",
  InitializationCell->True],

Cell["Select a nonstiff problem from the package.", "MathCaption"],

Cell[BoxData[
    \(\(nonstiffsystem\  = \ 
        GetNDSolveProblem["\<BrusselatorODE\>"];\)\)], "Input",
  CellLabel->"In[7]:=",
  InitializationCell->True],

Cell["Select a stiff problem from the package.", "MathCaption"],

Cell[BoxData[
    \(\(stiffsystem\  = \ GetNDSolveProblem["\<Robertson\>"];\)\)], "Input",
  CellLabel->"In[8]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Extending built-in methods", "Subsection"],

Cell[TextData[{
  "The method ",
  StyleBox["ExplicitEuler", "MR"],
  " carries out one integration step using Euler's method. It has no local \
error control and hence uses fixed step sizes."
}], "Text"],

Cell[TextData[{
  "This integrates a differential system using one application of \
Richardson's extrapolation (see (",
  
  CounterBox["NumberedEquation", "DSLocalExtrapolation"],
  ")) with the base method ",
  StyleBox["ExplicitEuler", "MR"],
  "."
}], "MathCaption"],

Cell[TextData[{
  "The local error estimate (",
  
  CounterBox["NumberedEquation", "DSErrorEstimate"],
  ") is used to dynamically adjust the step size throughout the integration."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eesol\  = \ 
      NDSolve[nonstiffsystem, {T, \ 0, \ 1}, 
        Method \[Rule] {"\<DoubleStep\>", \ 
            Method \[Rule] "\<ExplicitEuler\>"}]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[9]="]
}, Open  ]],

Cell["\<\
This illustrates how the step size varies during the numerical \
integration.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StepDataPlot[eesol]\)], "Input",
  CellLabel->"In[10]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952556 -0.261802 2978.26 [
[.21432 -0.00626 -9 -9 ]
[.21432 -0.00626 9 0 ]
[.40483 -0.00626 -9 -9 ]
[.40483 -0.00626 9 0 ]
[.59534 -0.00626 -9 -9 ]
[.59534 -0.00626 9 0 ]
[.78585 -0.00626 -9 -9 ]
[.78585 -0.00626 9 0 ]
[.97637 -0.00626 -3 -9 ]
[.97637 -0.00626 3 0 ]
[.01131 .03602 -36 -4.5 ]
[.01131 .03602 0 4.5 ]
[.01131 .18494 -42 -4.5 ]
[.01131 .18494 0 4.5 ]
[.01131 .33385 -36 -4.5 ]
[.01131 .33385 0 4.5 ]
[.01131 .48276 -42 -4.5 ]
[.01131 .48276 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21432 .00624 m
.21432 .01249 L
s
[(0.2)] .21432 -0.00626 0 1 Mshowa
.40483 .00624 m
.40483 .01249 L
s
[(0.4)] .40483 -0.00626 0 1 Mshowa
.59534 .00624 m
.59534 .01249 L
s
[(0.6)] .59534 -0.00626 0 1 Mshowa
.78585 .00624 m
.78585 .01249 L
s
[(0.8)] .78585 -0.00626 0 1 Mshowa
.97637 .00624 m
.97637 .01249 L
s
[(1)] .97637 -0.00626 0 1 Mshowa
.125 Mabswid
.07144 .00624 m
.07144 .00999 L
s
.11907 .00624 m
.11907 .00999 L
s
.16669 .00624 m
.16669 .00999 L
s
.26195 .00624 m
.26195 .00999 L
s
.30958 .00624 m
.30958 .00999 L
s
.3572 .00624 m
.3572 .00999 L
s
.45246 .00624 m
.45246 .00999 L
s
.50009 .00624 m
.50009 .00999 L
s
.54772 .00624 m
.54772 .00999 L
s
.64297 .00624 m
.64297 .00999 L
s
.6906 .00624 m
.6906 .00999 L
s
.73823 .00624 m
.73823 .00999 L
s
.83348 .00624 m
.83348 .00999 L
s
.88111 .00624 m
.88111 .00999 L
s
.92874 .00624 m
.92874 .00999 L
s
.25 Mabswid
0 .00624 m
1 .00624 L
s
.02381 .03602 m
.03006 .03602 L
s
[(0.0001)] .01131 .03602 1 0 Mshowa
.02381 .18494 m
.03006 .18494 L
s
[(0.00015)] .01131 .18494 1 0 Mshowa
.02381 .33385 m
.03006 .33385 L
s
[(0.0002)] .01131 .33385 1 0 Mshowa
.02381 .48276 m
.03006 .48276 L
s
[(0.00025)] .01131 .48276 1 0 Mshowa
.125 Mabswid
.02381 .06581 m
.02756 .06581 L
s
.02381 .09559 m
.02756 .09559 L
s
.02381 .12537 m
.02756 .12537 L
s
.02381 .15515 m
.02756 .15515 L
s
.02381 .21472 m
.02756 .21472 L
s
.02381 .2445 m
.02756 .2445 L
s
.02381 .27428 m
.02756 .27428 L
s
.02381 .30407 m
.02756 .30407 L
s
.02381 .36363 m
.02756 .36363 L
s
.02381 .39341 m
.02756 .39341 L
s
.02381 .4232 m
.02756 .4232 L
s
.02381 .45298 m
.02756 .45298 L
s
.02381 .51254 m
.02756 .51254 L
s
.02381 .54233 m
.02756 .54233 L
s
.02381 .57211 m
.02756 .57211 L
s
.02381 .60189 m
.02756 .60189 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .1681 m
.02395 .16808 L
.02408 .16809 L
.02422 .1681 L
.02436 .16812 L
.0245 .16813 L
.02463 .16815 L
.02477 .16816 L
.02491 .16817 L
.02505 .16819 L
.02518 .1682 L
.02532 .16822 L
.02546 .16823 L
.0256 .16825 L
.02573 .16826 L
.02587 .16828 L
.02601 .16829 L
.02615 .16831 L
.02628 .16833 L
.02642 .16834 L
.02656 .16836 L
.0267 .16837 L
.02684 .16839 L
.02697 .16841 L
.02711 .16842 L
.02725 .16844 L
.02739 .16846 L
.02752 .16847 L
.02766 .16849 L
.0278 .16851 L
.02794 .16852 L
.02807 .16854 L
.02821 .16856 L
.02835 .16858 L
.02849 .16859 L
.02862 .16861 L
.02876 .16863 L
.0289 .16865 L
.02904 .16866 L
.02918 .16868 L
.02931 .1687 L
.02945 .16872 L
.02959 .16874 L
.02973 .16876 L
.02986 .16878 L
.03 .16879 L
.03014 .16881 L
.03028 .16883 L
.03041 .16885 L
.03055 .16887 L
Mistroke
.03069 .16889 L
.03083 .16891 L
.03097 .16893 L
.0311 .16895 L
.03124 .16897 L
.03138 .16899 L
.03152 .16901 L
.03165 .16903 L
.03179 .16905 L
.03193 .16907 L
.03207 .16909 L
.03221 .16912 L
.03234 .16914 L
.03248 .16916 L
.03262 .16918 L
.03276 .1692 L
.03289 .16922 L
.03303 .16924 L
.03317 .16927 L
.03331 .16929 L
.03345 .16931 L
.03358 .16933 L
.03372 .16936 L
.03386 .16938 L
.034 .1694 L
.03414 .16942 L
.03427 .16945 L
.03441 .16947 L
.03455 .16949 L
.03469 .16952 L
.03483 .16954 L
.03496 .16956 L
.0351 .16959 L
.03524 .16961 L
.03538 .16963 L
.03552 .16966 L
.03565 .16968 L
.03579 .16971 L
.03593 .16973 L
.03607 .16976 L
.03621 .16978 L
.03634 .16981 L
.03648 .16983 L
.03662 .16986 L
.03676 .16988 L
.0369 .16991 L
.03703 .16993 L
.03717 .16996 L
.03731 .16999 L
.03745 .17001 L
Mistroke
.03759 .17004 L
.03772 .17006 L
.03786 .17009 L
.038 .17012 L
.03814 .17014 L
.03828 .17017 L
.03841 .1702 L
.03855 .17022 L
.03869 .17025 L
.03883 .17028 L
.03897 .17031 L
.03911 .17033 L
.03924 .17036 L
.03938 .17039 L
.03952 .17042 L
.03966 .17045 L
.0398 .17048 L
.03994 .1705 L
.04007 .17053 L
.04021 .17056 L
.04035 .17059 L
.04049 .17062 L
.04063 .17065 L
.04077 .17068 L
.0409 .17071 L
.04104 .17074 L
.04118 .17077 L
.04132 .1708 L
.04146 .17083 L
.0416 .17086 L
.04173 .17089 L
.04187 .17092 L
.04201 .17095 L
.04215 .17098 L
.04229 .17101 L
.04243 .17104 L
.04256 .17107 L
.0427 .17111 L
.04284 .17114 L
.04298 .17117 L
.04312 .1712 L
.04326 .17123 L
.04339 .17127 L
.04353 .1713 L
.04367 .17133 L
.04381 .17136 L
.04395 .1714 L
.04409 .17143 L
.04423 .17146 L
.04436 .17149 L
Mistroke
.0445 .17153 L
.04464 .17156 L
.04478 .1716 L
.04492 .17163 L
.04506 .17166 L
.0452 .1717 L
.04533 .17173 L
.04547 .17177 L
.04561 .1718 L
.04575 .17184 L
.04589 .17187 L
.04603 .17191 L
.04617 .17194 L
.04631 .17198 L
.04644 .17201 L
.04658 .17205 L
.04672 .17208 L
.04686 .17212 L
.047 .17216 L
.04714 .17219 L
.04728 .17223 L
.04742 .17227 L
.04755 .1723 L
.04769 .17234 L
.04783 .17238 L
.04797 .17241 L
.04811 .17245 L
.04825 .17249 L
.04839 .17253 L
.04853 .17257 L
.04867 .1726 L
.0488 .17264 L
.04894 .17268 L
.04908 .17272 L
.04922 .17276 L
.04936 .1728 L
.0495 .17284 L
.04964 .17287 L
.04978 .17291 L
.04992 .17295 L
.05006 .17299 L
.05019 .17303 L
.05033 .17307 L
.05047 .17311 L
.05061 .17315 L
.05075 .17319 L
.05089 .17324 L
.05103 .17328 L
.05117 .17332 L
.05131 .17336 L
Mistroke
.05145 .1734 L
.05159 .17344 L
.05173 .17348 L
.05186 .17353 L
.052 .17357 L
.05214 .17361 L
.05228 .17365 L
.05242 .17369 L
.05256 .17374 L
.0527 .17378 L
.05284 .17382 L
.05298 .17387 L
.05312 .17391 L
.05326 .17395 L
.0534 .174 L
.05354 .17404 L
.05368 .17409 L
.05382 .17413 L
.05395 .17417 L
.05409 .17422 L
.05423 .17426 L
.05437 .17431 L
.05451 .17435 L
.05465 .1744 L
.05479 .17445 L
.05493 .17449 L
.05507 .17454 L
.05521 .17458 L
.05535 .17463 L
.05549 .17468 L
.05563 .17472 L
.05577 .17477 L
.05591 .17482 L
.05605 .17486 L
.05619 .17491 L
.05633 .17496 L
.05647 .17501 L
.05661 .17505 L
.05675 .1751 L
.05689 .17515 L
.05703 .1752 L
.05717 .17525 L
.05731 .1753 L
.05745 .17535 L
.05758 .17539 L
.05772 .17544 L
.05786 .17549 L
.058 .17554 L
.05814 .17559 L
.05828 .17564 L
Mistroke
.05842 .17569 L
.05856 .17574 L
.0587 .17579 L
.05884 .17585 L
.05898 .1759 L
.05912 .17595 L
.05926 .176 L
.0594 .17605 L
.05954 .1761 L
.05968 .17615 L
.05982 .17621 L
.05996 .17626 L
.0601 .17631 L
.06024 .17636 L
.06038 .17642 L
.06052 .17647 L
.06066 .17652 L
.06081 .17658 L
.06095 .17663 L
.06109 .17669 L
.06123 .17672 L
.06137 .1767 L
.06151 .17667 L
.06165 .17665 L
.06179 .17663 L
.06193 .17661 L
.06207 .17659 L
.06221 .17657 L
.06235 .17655 L
.06249 .17653 L
.06263 .17651 L
.06277 .17649 L
.06291 .17647 L
.06305 .17645 L
.06319 .17643 L
.06333 .17641 L
.06347 .17639 L
.06361 .17637 L
.06375 .17635 L
.06389 .17633 L
.06403 .17631 L
.06417 .17629 L
.06431 .17627 L
.06445 .17625 L
.06459 .17623 L
.06473 .17621 L
.06487 .17619 L
.06501 .17618 L
.06515 .17616 L
.06529 .17614 L
Mistroke
.06543 .17612 L
.06557 .1761 L
.06571 .17609 L
.06585 .17607 L
.06599 .17605 L
.06613 .17603 L
.06627 .17601 L
.06641 .176 L
.06655 .17598 L
.06669 .17596 L
.06683 .17595 L
.06697 .17593 L
.06711 .17591 L
.06725 .1759 L
.06739 .17588 L
.06753 .17586 L
.06767 .17585 L
.06781 .17583 L
.06795 .17581 L
.06809 .1758 L
.06823 .17578 L
.06837 .17577 L
.06851 .17575 L
.06865 .17573 L
.06879 .17572 L
.06893 .1757 L
.06907 .17569 L
.06921 .17567 L
.06935 .17566 L
.06949 .17564 L
.06963 .17563 L
.06977 .17561 L
.06991 .1756 L
.07005 .17559 L
.07019 .17557 L
.07033 .17556 L
.07047 .17554 L
.07061 .17553 L
.07075 .17552 L
.07089 .1755 L
.07103 .17549 L
.07117 .17548 L
.07131 .17546 L
.07145 .17545 L
.07159 .17544 L
.07173 .17542 L
.07187 .17541 L
.07201 .1754 L
.07215 .17539 L
.07229 .17537 L
Mistroke
.07243 .17536 L
.07257 .17535 L
.07271 .17534 L
.07285 .17533 L
.07299 .17531 L
.07313 .1753 L
.07327 .17529 L
.07341 .17528 L
.07355 .17527 L
.07369 .17526 L
.07383 .17525 L
.07397 .17523 L
.07411 .17522 L
.07424 .17521 L
.07438 .1752 L
.07452 .17519 L
.07466 .17518 L
.0748 .17517 L
.07494 .17516 L
.07508 .17515 L
.07522 .17514 L
.07536 .17513 L
.0755 .17512 L
.07564 .17511 L
.07578 .1751 L
.07592 .1751 L
.07606 .17509 L
.0762 .17508 L
.07634 .17507 L
.07648 .17506 L
.07662 .17505 L
.07676 .17504 L
.0769 .17504 L
.07704 .17503 L
.07718 .17502 L
.07732 .17501 L
.07746 .175 L
.0776 .175 L
.07774 .17499 L
.07788 .17498 L
.07802 .17497 L
.07816 .17497 L
.0783 .17496 L
.07844 .17495 L
.07858 .17495 L
.07872 .17494 L
.07886 .17493 L
.079 .17493 L
.07914 .17492 L
.07927 .17492 L
Mistroke
.07941 .17491 L
.07955 .1749 L
.07969 .1749 L
.07983 .17489 L
.07997 .17489 L
.08011 .17488 L
.08025 .17488 L
.08039 .17487 L
.08053 .17487 L
.08067 .17486 L
.08081 .17486 L
.08095 .17485 L
.08109 .17485 L
.08123 .17485 L
.08137 .17484 L
.08151 .17484 L
.08165 .17483 L
.08179 .17483 L
.08193 .17483 L
.08207 .17482 L
.08221 .17482 L
.08235 .17482 L
.08249 .17481 L
.08263 .17481 L
.08277 .17481 L
.08291 .17481 L
.08305 .1748 L
.08319 .1748 L
.08332 .1748 L
.08346 .1748 L
.0836 .1748 L
.08374 .17479 L
.08388 .17479 L
.08402 .17479 L
.08416 .17479 L
.0843 .17479 L
.08444 .17479 L
.08458 .17479 L
.08472 .17479 L
.08486 .17479 L
.085 .17479 L
.08514 .17479 L
.08528 .17479 L
.08542 .17479 L
.08556 .17479 L
.0857 .17479 L
.08584 .17479 L
.08598 .17479 L
.08612 .17479 L
.08626 .17479 L
Mistroke
.0864 .17479 L
.08654 .17479 L
.08668 .17479 L
.08682 .17479 L
.08696 .17479 L
.0871 .1748 L
.08723 .1748 L
.08737 .1748 L
.08751 .1748 L
.08765 .1748 L
.08779 .17481 L
.08793 .17481 L
.08807 .17481 L
.08821 .17482 L
.08835 .17482 L
.08849 .17482 L
.08863 .17482 L
.08877 .17483 L
.08891 .17483 L
.08905 .17484 L
.08919 .17484 L
.08933 .17484 L
.08947 .17485 L
.08961 .17485 L
.08975 .17486 L
.08989 .17486 L
.09003 .17487 L
.09017 .17487 L
.09031 .17488 L
.09045 .17488 L
.09059 .17489 L
.09073 .17489 L
.09087 .1749 L
.09101 .1749 L
.09115 .17491 L
.09128 .17492 L
.09142 .17492 L
.09156 .17493 L
.0917 .17493 L
.09184 .17494 L
.09198 .17495 L
.09212 .17496 L
.09226 .17496 L
.0924 .17497 L
.09254 .17498 L
.09268 .17499 L
.09282 .17499 L
.09296 .175 L
.0931 .17501 L
.09324 .17502 L
Mistroke
.09338 .17503 L
.09352 .17503 L
.09366 .17504 L
.0938 .17505 L
.09394 .17506 L
.09408 .17507 L
.09422 .17508 L
.09436 .17509 L
.0945 .1751 L
.09464 .17511 L
.09478 .17512 L
.09492 .17513 L
.09506 .17514 L
.0952 .17515 L
.09534 .17516 L
.09548 .17517 L
.09562 .17518 L
.09576 .17519 L
.0959 .1752 L
.09604 .17522 L
.09618 .17523 L
.09631 .17524 L
.09645 .17525 L
.09659 .17526 L
.09673 .17527 L
.09687 .17529 L
.09701 .1753 L
.09715 .17531 L
.09729 .17533 L
.09743 .17534 L
.09757 .17535 L
.09771 .17536 L
.09785 .17538 L
.09799 .17539 L
.09813 .17541 L
.09827 .17542 L
.09841 .17543 L
.09855 .17545 L
.09869 .17546 L
.09883 .17548 L
.09897 .17549 L
.09911 .17551 L
.09925 .17552 L
.09939 .17554 L
.09953 .17555 L
.09967 .17557 L
.09981 .17558 L
.09995 .1756 L
.10009 .17562 L
.10023 .17563 L
Mistroke
.10037 .17565 L
.10051 .17567 L
.10065 .17568 L
.10079 .1757 L
.10093 .17572 L
.10107 .17573 L
.10121 .17575 L
.10135 .17577 L
.10149 .17579 L
.10163 .17581 L
.10177 .17582 L
.10191 .17584 L
.10205 .17586 L
.10219 .17588 L
.10233 .1759 L
.10247 .17592 L
.10261 .17594 L
.10275 .17596 L
.10289 .17598 L
.10303 .176 L
.10317 .17602 L
.10331 .17604 L
.10345 .17606 L
.10359 .17608 L
.10373 .1761 L
.10387 .17612 L
.10401 .17614 L
.10415 .17616 L
.10429 .17618 L
.10443 .1762 L
.10457 .17622 L
.10471 .17625 L
.10485 .17627 L
.10499 .17629 L
.10513 .17631 L
.10527 .17634 L
.10541 .17636 L
.10555 .17638 L
.10569 .17641 L
.10583 .17643 L
.10597 .17645 L
.10611 .17648 L
.10625 .1765 L
.10639 .17652 L
.10653 .17655 L
.10667 .17657 L
.10681 .1766 L
.10695 .17662 L
.10709 .17665 L
.10723 .17667 L
Mistroke
.10737 .1767 L
.10751 .17672 L
.10765 .17675 L
.10779 .17678 L
.10793 .1768 L
.10807 .17683 L
.10822 .17685 L
.10836 .17688 L
.1085 .17691 L
.10864 .17693 L
.10878 .17696 L
.10892 .17699 L
.10906 .17702 L
.1092 .17705 L
.10934 .17707 L
.10948 .1771 L
.10962 .17713 L
.10976 .17716 L
.1099 .17719 L
.11004 .17722 L
.11018 .17725 L
.11032 .17728 L
.11046 .1773 L
.1106 .17733 L
.11074 .17736 L
.11088 .17739 L
.11102 .17743 L
.11116 .17746 L
.1113 .17749 L
.11144 .17752 L
.11158 .17755 L
.11173 .17758 L
.11187 .17761 L
.11201 .17764 L
.11215 .17768 L
.11229 .17771 L
.11243 .17774 L
.11257 .17777 L
.11271 .17781 L
.11285 .17784 L
.11299 .17787 L
.11313 .17791 L
.11327 .17794 L
.11341 .17797 L
.11355 .17801 L
.11369 .17804 L
.11383 .17808 L
.11398 .17811 L
.11412 .17814 L
.11426 .17818 L
Mistroke
.1144 .17822 L
.11454 .17825 L
.11468 .17829 L
.11482 .17832 L
.11496 .17836 L
.1151 .17839 L
.11524 .17843 L
.11538 .17847 L
.11552 .1785 L
.11566 .17854 L
.11581 .17858 L
.11595 .17862 L
.11609 .17865 L
.11623 .17869 L
.11637 .17873 L
.11651 .17877 L
.11665 .17881 L
.11679 .17885 L
.11693 .17889 L
.11707 .17893 L
.11721 .17896 L
.11736 .179 L
.1175 .17904 L
.11764 .17908 L
.11778 .17913 L
.11792 .17917 L
.11806 .17921 L
.1182 .17925 L
.11834 .17929 L
.11848 .17933 L
.11862 .17937 L
.11877 .17941 L
.11891 .17946 L
.11905 .1795 L
.11919 .17954 L
.11933 .17958 L
.11947 .17963 L
.11961 .17967 L
.11975 .17971 L
.11989 .17976 L
.12004 .1798 L
.12018 .17985 L
.12032 .17989 L
.12046 .17994 L
.1206 .17998 L
.12074 .18003 L
.12088 .18007 L
.12103 .18012 L
.12117 .18016 L
.12131 .18021 L
Mistroke
.12145 .18025 L
.12159 .1803 L
.12173 .18035 L
.12187 .1804 L
.12201 .18044 L
.12216 .18049 L
.1223 .18054 L
.12244 .18059 L
.12258 .18063 L
.12272 .18068 L
.12286 .18073 L
.12301 .18078 L
.12315 .18083 L
.12329 .18088 L
.12343 .18093 L
.12357 .18098 L
.12371 .18103 L
.12385 .18108 L
.124 .18113 L
.12414 .18118 L
.12428 .18123 L
.12442 .18128 L
.12456 .18133 L
.1247 .18139 L
.12485 .18144 L
.12499 .18149 L
.12513 .18154 L
.12527 .1816 L
.12541 .18165 L
.12556 .1817 L
.1257 .18176 L
.12584 .18181 L
.12598 .18186 L
.12612 .18192 L
.12627 .18197 L
.12641 .18203 L
.12655 .18208 L
.12669 .18214 L
.12683 .18219 L
.12698 .18225 L
.12712 .18231 L
.12726 .18236 L
.1274 .18242 L
.12754 .18248 L
.12769 .18253 L
.12783 .18259 L
.12797 .18265 L
.12811 .18271 L
.12825 .18276 L
.1284 .18282 L
Mistroke
.12854 .18288 L
.12868 .18294 L
.12882 .183 L
.12897 .18306 L
.12911 .18312 L
.12925 .18318 L
.12939 .18324 L
.12953 .1833 L
.12968 .18336 L
.12982 .18342 L
.12996 .18348 L
.1301 .18355 L
.13025 .18361 L
.13039 .18367 L
.13053 .18373 L
.13067 .1838 L
.13082 .18386 L
.13096 .18392 L
.1311 .18399 L
.13124 .18405 L
.13139 .18412 L
.13153 .18418 L
.13167 .18424 L
.13181 .18431 L
.13196 .18438 L
.1321 .18444 L
.13224 .18451 L
.13239 .18457 L
.13253 .18464 L
.13267 .18471 L
.13281 .18477 L
.13296 .18484 L
.1331 .18491 L
.13324 .18498 L
.13339 .18504 L
.13353 .18511 L
.13367 .18518 L
.13381 .18525 L
.13396 .18532 L
.1341 .18539 L
.13424 .18546 L
.13439 .18553 L
.13453 .1856 L
.13467 .18567 L
.13482 .18574 L
.13496 .18582 L
.1351 .18589 L
.13524 .18596 L
.13539 .18603 L
.13553 .1861 L
Mistroke
.13567 .18618 L
.13582 .18625 L
.13596 .18632 L
.1361 .1864 L
.13625 .18647 L
.13639 .18655 L
.13653 .18662 L
.13668 .1867 L
.13682 .18677 L
.13696 .18685 L
.13711 .18693 L
.13725 .187 L
.1374 .18708 L
.13754 .18716 L
.13768 .18723 L
.13783 .18731 L
.13797 .18739 L
.13811 .18747 L
.13826 .18755 L
.1384 .18763 L
.13854 .18771 L
.13869 .18778 L
.13883 .18786 L
.13898 .18795 L
.13912 .18803 L
.13926 .18811 L
.13941 .18819 L
.13955 .18827 L
.1397 .18835 L
.13984 .18843 L
.13998 .18852 L
.14013 .1886 L
.14027 .18868 L
.14042 .18877 L
.14056 .18885 L
.1407 .18894 L
.14085 .18902 L
.14099 .18911 L
.14114 .18919 L
.14128 .18928 L
.14143 .18936 L
.14157 .18945 L
.14171 .18954 L
.14186 .18962 L
.142 .18971 L
.14215 .1898 L
.14229 .18989 L
.14244 .18997 L
.14258 .19006 L
.14272 .19015 L
Mistroke
.14287 .19024 L
.14301 .19033 L
.14316 .19042 L
.1433 .19051 L
.14345 .1906 L
.14359 .1907 L
.14374 .19079 L
.14388 .19088 L
.14403 .19097 L
.14417 .19107 L
.14432 .19116 L
.14446 .19125 L
.14461 .19135 L
.14475 .19144 L
.1449 .19153 L
.14504 .19163 L
.14519 .19173 L
.14533 .19182 L
.14548 .19192 L
.14562 .19201 L
.14577 .19211 L
.14591 .19221 L
.14606 .19231 L
.1462 .1924 L
.14635 .1925 L
.14649 .1926 L
.14664 .1927 L
.14678 .1928 L
.14693 .1929 L
.14707 .193 L
.14722 .1931 L
.14737 .1932 L
.14751 .1933 L
.14766 .19341 L
.1478 .19351 L
.14795 .19361 L
.14809 .19372 L
.14824 .19382 L
.14838 .19392 L
.14853 .19403 L
.14868 .19413 L
.14882 .19424 L
.14897 .19434 L
.14911 .19445 L
.14926 .19456 L
.14941 .19466 L
.14955 .19477 L
.1497 .19488 L
.14984 .19499 L
.14999 .19509 L
Mistroke
.15014 .1952 L
.15028 .19531 L
.15043 .19542 L
.15057 .19553 L
.15072 .19564 L
.15087 .19575 L
.15101 .19587 L
.15116 .19598 L
.15131 .19609 L
.15145 .1962 L
.1516 .19632 L
.15175 .19643 L
.15189 .19654 L
.15204 .19666 L
.15219 .19677 L
.15233 .19689 L
.15248 .19701 L
.15263 .19712 L
.15277 .19724 L
.15292 .19736 L
.15307 .19747 L
.15321 .19759 L
.15336 .19771 L
.15351 .19783 L
.15365 .19795 L
.1538 .19807 L
.15395 .19819 L
.1541 .19831 L
.15424 .19843 L
.15439 .19855 L
.15454 .19868 L
.15468 .1988 L
.15483 .19892 L
.15498 .19905 L
.15513 .19917 L
.15527 .1993 L
.15542 .19942 L
.15557 .19955 L
.15572 .19967 L
.15586 .1998 L
.15601 .19993 L
.15616 .20005 L
.15631 .20018 L
.15645 .20031 L
.1566 .20044 L
.15675 .20057 L
.1569 .2007 L
.15705 .20083 L
.15719 .20096 L
.15734 .20109 L
Mistroke
.15749 .20122 L
.15764 .20136 L
.15779 .20149 L
.15793 .20162 L
.15808 .20176 L
.15823 .20189 L
.15838 .20203 L
.15853 .20216 L
.15868 .2023 L
.15882 .20244 L
.15897 .20257 L
.15912 .20271 L
.15927 .20285 L
.15942 .20299 L
.15957 .20313 L
.15972 .20327 L
.15986 .20341 L
.16001 .20355 L
.16016 .20369 L
.16031 .20383 L
.16046 .20398 L
.16061 .20412 L
.16076 .20426 L
.16091 .20441 L
.16106 .20455 L
.16121 .2047 L
.16135 .20484 L
.1615 .20499 L
.16165 .20514 L
.1618 .20528 L
.16195 .20543 L
.1621 .20558 L
.16225 .20573 L
.1624 .20588 L
.16255 .20603 L
.1627 .20618 L
.16285 .20633 L
.163 .20649 L
.16315 .20664 L
.1633 .20679 L
.16345 .20695 L
.1636 .2071 L
.16375 .20726 L
.1639 .20741 L
.16405 .20757 L
.1642 .20773 L
.16435 .20788 L
.1645 .20804 L
.16465 .2082 L
.1648 .20836 L
Mistroke
.16495 .20852 L
.1651 .20868 L
.16525 .20884 L
.1654 .20901 L
.16555 .20917 L
.1657 .20933 L
.16585 .2095 L
.166 .20966 L
.16615 .20983 L
.16631 .20999 L
.16646 .21016 L
.16661 .21032 L
.16676 .21049 L
.16691 .21066 L
.16706 .21083 L
.16721 .211 L
.16736 .21117 L
.16751 .21134 L
.16767 .21151 L
.16782 .21169 L
.16797 .21186 L
.16812 .21203 L
.16827 .21221 L
.16842 .21238 L
.16857 .21256 L
.16873 .21273 L
.16888 .21291 L
.16903 .21309 L
.16918 .21327 L
.16933 .21345 L
.16949 .21363 L
.16964 .21381 L
.16979 .21399 L
.16994 .21417 L
.17009 .21435 L
.17025 .21454 L
.1704 .21472 L
.17055 .21491 L
.1707 .21509 L
.17086 .21528 L
.17101 .21547 L
.17116 .21566 L
.17131 .21584 L
.17147 .21603 L
.17162 .21622 L
.17177 .21642 L
.17193 .21661 L
.17208 .2168 L
.17223 .21699 L
.17239 .21719 L
Mistroke
.17254 .21738 L
.17269 .21758 L
.17284 .21777 L
.173 .21797 L
.17315 .21817 L
.17331 .21837 L
.17346 .21857 L
.17361 .21877 L
.17377 .21897 L
.17392 .21917 L
.17407 .21937 L
.17423 .21958 L
.17438 .21978 L
.17454 .21999 L
.17469 .22019 L
.17484 .2204 L
.175 .22061 L
.17515 .22082 L
.17531 .22103 L
.17546 .22124 L
.17562 .22145 L
.17577 .22166 L
.17592 .22187 L
.17608 .22209 L
.17623 .2223 L
.17639 .22252 L
.17654 .22273 L
.1767 .22295 L
.17685 .22317 L
.17701 .22339 L
.17716 .22361 L
.17732 .22383 L
.17747 .22405 L
.17763 .22427 L
.17779 .2245 L
.17794 .22472 L
.1781 .22495 L
.17825 .22517 L
.17841 .2254 L
.17856 .22563 L
.17872 .22586 L
.17888 .22609 L
.17903 .22632 L
.17919 .22655 L
.17934 .22679 L
.1795 .22702 L
.17966 .22725 L
.17981 .22749 L
.17997 .22773 L
.18013 .22797 L
Mistroke
.18028 .2282 L
.18044 .22844 L
.1806 .22869 L
.18075 .22893 L
.18091 .22917 L
.18107 .22942 L
.18122 .22966 L
.18138 .22991 L
.18154 .23015 L
.1817 .2304 L
.18185 .23065 L
.18201 .2309 L
.18217 .23115 L
.18233 .23141 L
.18248 .23166 L
.18264 .23191 L
.1828 .23217 L
.18296 .23243 L
.18312 .23268 L
.18327 .23294 L
.18343 .2332 L
.18359 .23346 L
.18375 .23373 L
.18391 .23399 L
.18407 .23426 L
.18423 .23452 L
.18438 .23479 L
.18454 .23506 L
.1847 .23533 L
.18486 .2356 L
.18502 .23587 L
.18518 .23614 L
.18534 .23641 L
.1855 .23669 L
.18566 .23697 L
.18582 .23724 L
.18598 .23752 L
.18614 .2378 L
.1863 .23808 L
.18646 .23837 L
.18662 .23865 L
.18678 .23894 L
.18694 .23922 L
.1871 .23951 L
.18726 .2398 L
.18742 .24009 L
.18758 .24038 L
.18774 .24067 L
.1879 .24097 L
.18806 .24126 L
Mistroke
.18822 .24156 L
.18838 .24186 L
.18854 .24216 L
.1887 .24246 L
.18886 .24276 L
.18903 .24306 L
.18919 .24337 L
.18935 .24367 L
.18951 .24398 L
.18967 .24429 L
.18983 .2446 L
.19 .24491 L
.19016 .24523 L
.19032 .24554 L
.19048 .24586 L
.19065 .24618 L
.19081 .24649 L
.19097 .24682 L
.19113 .24714 L
.1913 .24746 L
.19146 .24779 L
.19162 .24811 L
.19178 .24844 L
.19195 .24877 L
.19211 .2491 L
.19227 .24943 L
.19244 .24977 L
.1926 .2501 L
.19277 .25044 L
.19293 .25078 L
.19309 .25112 L
.19326 .25146 L
.19342 .25181 L
.19359 .25215 L
.19375 .2525 L
.19391 .25285 L
.19408 .2532 L
.19424 .25355 L
.19441 .25391 L
.19457 .25426 L
.19474 .25462 L
.1949 .25498 L
.19507 .25534 L
.19523 .2557 L
.1954 .25607 L
.19557 .25643 L
.19573 .2568 L
.1959 .25717 L
.19606 .25754 L
.19623 .25792 L
Mistroke
.1964 .25829 L
.19656 .25867 L
.19673 .25905 L
.1969 .25943 L
.19706 .25981 L
.19723 .2602 L
.1974 .26058 L
.19756 .26097 L
.19773 .26136 L
.1979 .26175 L
.19806 .26215 L
.19823 .26254 L
.1984 .26294 L
.19857 .26334 L
.19874 .26375 L
.1989 .26415 L
.19907 .26456 L
.19924 .26496 L
.19941 .26538 L
.19958 .26579 L
.19975 .2662 L
.19992 .26662 L
.20008 .26704 L
.20025 .26746 L
.20042 .26789 L
.20059 .26831 L
.20076 .26874 L
.20093 .26917 L
.2011 .2696 L
.20127 .27004 L
.20144 .27047 L
.20161 .27091 L
.20178 .27136 L
.20195 .2718 L
.20212 .27225 L
.20229 .2727 L
.20246 .27315 L
.20264 .2736 L
.20281 .27406 L
.20298 .27452 L
.20315 .27498 L
.20332 .27544 L
.20349 .27591 L
.20367 .27638 L
.20384 .27685 L
.20401 .27732 L
.20418 .2778 L
.20435 .27828 L
.20453 .27876 L
.2047 .27924 L
Mistroke
.20487 .27973 L
.20505 .28022 L
.20522 .28071 L
.20539 .28121 L
.20557 .28171 L
.20574 .28221 L
.20592 .28271 L
.20609 .28322 L
.20626 .28373 L
.20644 .28424 L
.20661 .28476 L
.20679 .28527 L
.20696 .2858 L
.20714 .28632 L
.20731 .28685 L
.20749 .28738 L
.20766 .28791 L
.20784 .28845 L
.20802 .28899 L
.20819 .28953 L
.20837 .29008 L
.20854 .29063 L
.20872 .29118 L
.2089 .29174 L
.20908 .2923 L
.20925 .29286 L
.20943 .29343 L
.20961 .294 L
.20979 .29457 L
.20996 .29514 L
.21014 .29573 L
.21032 .29631 L
.2105 .2969 L
.21068 .29749 L
.21086 .29808 L
.21103 .29868 L
.21121 .29928 L
.21139 .29989 L
.21157 .3005 L
.21175 .30111 L
.21193 .30173 L
.21211 .30235 L
.21229 .30297 L
.21247 .3036 L
.21266 .30423 L
.21284 .30487 L
.21302 .30551 L
.2132 .30616 L
.21338 .30681 L
.21356 .30746 L
Mistroke
.21374 .30812 L
.21393 .30878 L
.21411 .30945 L
.21429 .31012 L
.21448 .3108 L
.21466 .31148 L
.21484 .31216 L
.21503 .31285 L
.21521 .31354 L
.21539 .31424 L
.21558 .31494 L
.21576 .31565 L
.21595 .31636 L
.21613 .31708 L
.21632 .31781 L
.2165 .31853 L
.21669 .31927 L
.21687 .32 L
.21706 .32075 L
.21725 .32149 L
.21743 .32225 L
.21762 .32301 L
.21781 .32377 L
.21799 .32454 L
.21818 .32532 L
.21837 .3261 L
.21856 .32688 L
.21874 .32768 L
.21893 .32847 L
.21912 .32928 L
.21931 .33009 L
.2195 .3309 L
.21969 .33172 L
.21988 .33255 L
.22007 .33339 L
.22026 .33423 L
.22045 .33507 L
.22064 .33593 L
.22083 .33679 L
.22102 .33765 L
.22122 .33853 L
.22141 .33941 L
.2216 .34029 L
.22179 .34118 L
.22199 .34209 L
.22218 .34299 L
.22237 .34391 L
.22257 .34483 L
.22276 .34576 L
.22295 .3467 L
Mistroke
.22315 .34764 L
.22334 .34859 L
.22354 .34955 L
.22374 .35052 L
.22393 .3515 L
.22413 .35248 L
.22432 .35347 L
.22452 .35447 L
.22472 .35548 L
.22491 .3565 L
.22511 .35752 L
.22531 .35856 L
.22551 .3596 L
.22571 .36065 L
.22591 .36172 L
.22611 .36279 L
.22631 .36387 L
.22651 .36496 L
.22671 .36606 L
.22691 .36716 L
.22711 .36828 L
.22731 .36941 L
.22751 .37055 L
.22771 .3717 L
.22792 .37286 L
.22812 .37403 L
.22832 .37522 L
.22853 .37641 L
.22873 .37761 L
.22894 .37883 L
.22914 .38006 L
.22935 .3813 L
.22955 .38255 L
.22976 .38381 L
.22996 .38509 L
.23017 .38638 L
.23038 .38768 L
.23059 .38899 L
.23079 .39032 L
.231 .39166 L
.23121 .39301 L
.23142 .39438 L
.23163 .39576 L
.23184 .39716 L
.23205 .39857 L
.23226 .39999 L
.23248 .40143 L
.23269 .40289 L
.2329 .40436 L
.23311 .40585 L
Mistroke
.23333 .40735 L
.23354 .40887 L
.23375 .41041 L
.23397 .41196 L
.23419 .41353 L
.2344 .41512 L
.23462 .41672 L
.23483 .41835 L
.23505 .41999 L
.23527 .42166 L
.23549 .42334 L
.23571 .42504 L
.23593 .42676 L
.23615 .4285 L
.23637 .43027 L
.23659 .43205 L
.23681 .43386 L
.23703 .43569 L
.23726 .43754 L
.23748 .43942 L
.23771 .44132 L
.23793 .44324 L
.23816 .44519 L
.23838 .44716 L
.23861 .44916 L
.23884 .45119 L
.23906 .45324 L
.23929 .45533 L
.23952 .45744 L
.23975 .45957 L
.23998 .46174 L
.24021 .46394 L
.24045 .46617 L
.24068 .46843 L
.24091 .47073 L
.24115 .47305 L
.24138 .47542 L
.24162 .47781 L
.24185 .48025 L
.24209 .48272 L
.24233 .48522 L
.24257 .48777 L
.24281 .49036 L
.24305 .49298 L
.24329 .49565 L
.24353 .49837 L
.24378 .50112 L
.24402 .50393 L
.24427 .50678 L
.24451 .50968 L
Mistroke
.24476 .51262 L
.24501 .51562 L
.24525 .51867 L
.2455 .52178 L
.24575 .52494 L
.24601 .52816 L
.24626 .53144 L
.24651 .53478 L
.24677 .53819 L
.24702 .54166 L
.24728 .54519 L
.24754 .5488 L
.2478 .55248 L
.24806 .55623 L
.24832 .56006 L
.24858 .56397 L
.24885 .56797 L
.24911 .57205 L
.24938 .57622 L
.24965 .58048 L
.24992 .58484 L
.25019 .5893 L
.25046 .59386 L
.25073 .59853 L
.25101 .60332 L
.25128 .59918 L
.25156 .594 L
.25183 .58893 L
.25211 .58398 L
.25238 .57913 L
.25265 .5744 L
.25291 .56976 L
.25318 .56523 L
.25344 .56079 L
.25371 .55644 L
.25397 .55218 L
.25423 .548 L
.25449 .54391 L
.25474 .53989 L
.255 .53596 L
.25526 .53209 L
.25551 .5283 L
.25576 .52458 L
.25601 .52093 L
.25627 .51734 L
.25651 .51381 L
.25676 .51035 L
.25701 .50694 L
.25726 .5036 L
.2575 .50031 L
Mistroke
.25774 .49707 L
.25799 .49388 L
.25823 .49075 L
.25847 .48767 L
.25871 .48464 L
.25895 .48165 L
.25919 .47871 L
.25942 .47581 L
.25966 .47296 L
.25989 .47015 L
.26013 .46738 L
.26036 .46465 L
.26059 .46196 L
.26082 .45931 L
.26105 .4567 L
.26128 .45412 L
.26151 .45158 L
.26174 .44907 L
.26197 .4466 L
.2622 .44416 L
.26242 .44175 L
.26265 .43938 L
.26287 .43703 L
.26309 .43472 L
.26332 .43243 L
.26354 .43018 L
.26376 .42795 L
.26398 .42575 L
.2642 .42358 L
.26442 .42143 L
.26464 .41931 L
.26486 .41722 L
.26507 .41515 L
.26529 .4131 L
.26551 .41108 L
.26572 .40908 L
.26594 .4071 L
.26615 .40515 L
.26636 .40322 L
.26658 .40131 L
.26679 .39942 L
.267 .39755 L
.26721 .39571 L
.26742 .39388 L
.26763 .39207 L
.26784 .39028 L
.26805 .38851 L
.26826 .38676 L
.26846 .38503 L
.26867 .38332 L
Mistroke
.26888 .38162 L
.26908 .37994 L
.26929 .37828 L
.26949 .37663 L
.2697 .375 L
.2699 .37339 L
.2701 .37179 L
.27031 .37021 L
.27051 .36864 L
.27071 .36709 L
.27091 .36555 L
.27111 .36403 L
.27131 .36252 L
.27151 .36103 L
.27171 .35955 L
.27191 .35808 L
.27211 .35663 L
.27231 .35519 L
.2725 .35376 L
.2727 .35235 L
.2729 .35095 L
.27309 .34956 L
.27329 .34818 L
.27348 .34682 L
.27368 .34547 L
.27387 .34413 L
.27407 .3428 L
.27426 .34148 L
.27445 .34017 L
.27464 .33888 L
.27484 .33759 L
.27503 .33632 L
.27522 .33505 L
.27541 .3338 L
.2756 .33256 L
.27579 .33132 L
.27598 .3301 L
.27617 .32889 L
.27636 .32769 L
.27655 .32649 L
.27674 .32531 L
.27692 .32413 L
.27711 .32297 L
.2773 .32181 L
.27748 .32066 L
.27767 .31952 L
.27786 .31839 L
.27804 .31727 L
.27823 .31616 L
.27841 .31506 L
Mistroke
.2786 .31396 L
.27878 .31287 L
.27896 .31179 L
.27915 .31072 L
.27933 .30965 L
.27951 .3086 L
.2797 .30755 L
.27988 .30651 L
.28006 .30547 L
.28024 .30445 L
.28042 .30343 L
.2806 .30242 L
.28078 .30141 L
.28096 .30042 L
.28114 .29942 L
.28132 .29844 L
.2815 .29746 L
.28168 .29649 L
.28186 .29553 L
.28204 .29457 L
.28222 .29362 L
.28239 .29268 L
.28257 .29174 L
.28275 .29081 L
.28292 .28988 L
.2831 .28896 L
.28328 .28805 L
.28345 .28714 L
.28363 .28624 L
.2838 .28535 L
.28398 .28446 L
.28415 .28357 L
.28433 .2827 L
.2845 .28182 L
.28468 .28096 L
.28485 .28009 L
.28502 .27924 L
.2852 .27839 L
.28537 .27754 L
.28554 .2767 L
.28571 .27587 L
.28589 .27504 L
.28606 .27421 L
.28623 .27339 L
.2864 .27258 L
.28657 .27177 L
.28674 .27096 L
.28691 .27016 L
.28708 .26937 L
.28725 .26858 L
Mistroke
.28742 .26779 L
.28759 .26701 L
.28776 .26623 L
.28793 .26546 L
.2881 .26469 L
.28827 .26393 L
.28843 .26317 L
.2886 .26242 L
.28877 .26167 L
.28894 .26092 L
.2891 .26018 L
.28927 .25944 L
.28944 .25871 L
.2896 .25798 L
.28977 .25726 L
.28994 .25654 L
.2901 .25582 L
.29027 .25511 L
.29043 .2544 L
.2906 .25369 L
.29076 .25299 L
.29093 .25229 L
.29109 .2516 L
.29126 .25091 L
.29142 .25023 L
.29158 .24954 L
.29175 .24886 L
.29191 .24819 L
.29207 .24752 L
.29224 .24685 L
.2924 .24619 L
.29256 .24553 L
.29272 .24487 L
.29289 .24421 L
.29305 .24356 L
.29321 .24292 L
.29337 .24227 L
.29353 .24163 L
.29369 .241 L
.29385 .24036 L
.29402 .23973 L
.29418 .23911 L
.29434 .23848 L
.2945 .23786 L
.29466 .23724 L
.29482 .23663 L
.29498 .23602 L
.29513 .23541 L
.29529 .2348 L
.29545 .2342 L
Mistroke
.29561 .2336 L
.29577 .233 L
.29593 .23241 L
.29609 .23182 L
.29624 .23123 L
.2964 .23065 L
.29656 .23006 L
.29672 .22948 L
.29687 .22891 L
.29703 .22833 L
.29719 .22776 L
.29734 .2272 L
.2975 .22663 L
.29766 .22607 L
.29781 .22551 L
.29797 .22495 L
.29812 .22439 L
.29828 .22384 L
.29843 .22329 L
.29859 .22274 L
.29874 .2222 L
.2989 .22166 L
.29905 .22112 L
.29921 .22058 L
.29936 .22005 L
.29952 .21951 L
.29967 .21898 L
.29982 .21846 L
.29998 .21793 L
.30013 .21741 L
.30028 .21689 L
.30044 .21637 L
.30059 .21585 L
.30074 .21534 L
.3009 .21483 L
.30105 .21432 L
.3012 .21381 L
.30135 .21331 L
.30151 .21281 L
.30166 .21231 L
.30181 .21181 L
.30196 .21132 L
.30211 .21082 L
.30226 .21033 L
.30241 .20984 L
.30256 .20935 L
.30271 .20887 L
.30287 .20839 L
.30302 .20791 L
.30317 .20743 L
Mistroke
.30332 .20695 L
.30347 .20648 L
.30362 .206 L
.30377 .20553 L
.30392 .20506 L
.30406 .2046 L
.30421 .20413 L
.30436 .20367 L
.30451 .20321 L
.30466 .20275 L
.30481 .20229 L
.30496 .20184 L
.30511 .20139 L
.30525 .20093 L
.3054 .20048 L
.30555 .20004 L
.3057 .19959 L
.30584 .19915 L
.30599 .19871 L
.30614 .19826 L
.30629 .19783 L
.30643 .19739 L
.30658 .19695 L
.30673 .19652 L
.30687 .19609 L
.30702 .19566 L
.30717 .19523 L
.30731 .1948 L
.30746 .19438 L
.3076 .19396 L
.30775 .19354 L
.3079 .19312 L
.30804 .1927 L
.30819 .19228 L
.30833 .19187 L
.30848 .19145 L
.30862 .19104 L
.30877 .19063 L
.30891 .19022 L
.30906 .18982 L
.3092 .18941 L
.30935 .18901 L
.30949 .1886 L
.30963 .1882 L
.30978 .1878 L
.30992 .18741 L
.31006 .18701 L
.31021 .18662 L
.31035 .18622 L
.3105 .18583 L
Mistroke
.31064 .18544 L
.31078 .18505 L
.31092 .18467 L
.31107 .18428 L
.31121 .1839 L
.31135 .18351 L
.31149 .18313 L
.31164 .18275 L
.31178 .18237 L
.31192 .18199 L
.31206 .18162 L
.3122 .18124 L
.31235 .18087 L
.31249 .1805 L
.31263 .18013 L
.31277 .17976 L
.31291 .17939 L
.31305 .17903 L
.31319 .17866 L
.31334 .1783 L
.31348 .17793 L
.31362 .17757 L
.31376 .17721 L
.3139 .17686 L
.31404 .1765 L
.31418 .17614 L
.31432 .17579 L
.31446 .17543 L
.3146 .17508 L
.31474 .17473 L
.31488 .17438 L
.31502 .17403 L
.31516 .17369 L
.3153 .17334 L
.31543 .17299 L
.31557 .17265 L
.31571 .17231 L
.31585 .17197 L
.31599 .17163 L
.31613 .17129 L
.31627 .17095 L
.31641 .17061 L
.31654 .17028 L
.31668 .16994 L
.31682 .16961 L
.31696 .16928 L
.3171 .16895 L
.31723 .16862 L
.31737 .16829 L
.31751 .16796 L
Mistroke
.31765 .16764 L
.31778 .16731 L
.31792 .16699 L
.31806 .16666 L
.3182 .16634 L
.31833 .16602 L
.31847 .1657 L
.31861 .16538 L
.31874 .16506 L
.31888 .16475 L
.31902 .16443 L
.31915 .16412 L
.31929 .1638 L
.31942 .16349 L
.31956 .16318 L
.3197 .16287 L
.31983 .16256 L
.31997 .16225 L
.3201 .16195 L
.32024 .16164 L
.32037 .16133 L
.32051 .16103 L
.32064 .16073 L
.32078 .16042 L
.32092 .16012 L
.32105 .15982 L
.32118 .15952 L
.32132 .15922 L
.32145 .15893 L
.32159 .15863 L
.32172 .15833 L
.32186 .15804 L
.32199 .15775 L
.32213 .15745 L
.32226 .15716 L
.32239 .15687 L
.32253 .15658 L
.32266 .15629 L
.3228 .156 L
.32293 .15572 L
.32306 .15543 L
.3232 .15514 L
.32333 .15486 L
.32346 .15458 L
.3236 .15429 L
.32373 .15401 L
.32386 .15373 L
.324 .15345 L
.32413 .15317 L
.32426 .15289 L
Mistroke
.32439 .15262 L
.32453 .15234 L
.32466 .15206 L
.32479 .15179 L
.32492 .15151 L
.32506 .15124 L
.32519 .15097 L
.32532 .1507 L
.32545 .15043 L
.32558 .15016 L
.32571 .14989 L
.32585 .14962 L
.32598 .14935 L
.32611 .14908 L
.32624 .14882 L
.32637 .14855 L
.3265 .14829 L
.32663 .14803 L
.32677 .14776 L
.3269 .1475 L
.32703 .14724 L
.32716 .14698 L
.32729 .14672 L
.32742 .14646 L
.32755 .1462 L
.32768 .14595 L
.32781 .14569 L
.32794 .14543 L
.32807 .14518 L
.3282 .14493 L
.32833 .14467 L
.32846 .14442 L
.32859 .14417 L
.32872 .14392 L
.32885 .14367 L
.32898 .14342 L
.32911 .14317 L
.32924 .14292 L
.32937 .14267 L
.3295 .14242 L
.32963 .14218 L
.32976 .14193 L
.32989 .14169 L
.33002 .14144 L
.33015 .1412 L
.33027 .14096 L
.3304 .14072 L
.33053 .14048 L
.33066 .14024 L
.33079 .14 L
Mistroke
.33092 .13976 L
.33105 .13952 L
.33117 .13928 L
.3313 .13904 L
.33143 .13881 L
.33156 .13857 L
.33169 .13834 L
.33181 .1381 L
.33194 .13787 L
.33207 .13764 L
.3322 .1374 L
.33233 .13717 L
.33245 .13694 L
.33258 .13671 L
.33271 .13648 L
.33284 .13625 L
.33296 .13602 L
.33309 .13579 L
.33322 .13557 L
.33334 .13534 L
.33347 .13512 L
.3336 .13489 L
.33373 .13467 L
.33385 .13444 L
.33398 .13422 L
.33411 .134 L
.33423 .13377 L
.33436 .13355 L
.33449 .13333 L
.33461 .13311 L
.33474 .13289 L
.33486 .13267 L
.33499 .13245 L
.33512 .13224 L
.33524 .13202 L
.33537 .1318 L
.33549 .13159 L
.33562 .13137 L
.33575 .13115 L
.33587 .13094 L
.336 .13073 L
.33612 .13051 L
.33625 .1303 L
.33637 .13009 L
.3365 .12988 L
.33662 .12967 L
.33675 .12946 L
.33687 .12925 L
.337 .12904 L
.33712 .12883 L
Mistroke
.33725 .12862 L
.33737 .12841 L
.3375 .12821 L
.33762 .128 L
.33775 .12779 L
.33787 .12759 L
.338 .12738 L
.33812 .12718 L
.33825 .12698 L
.33837 .12677 L
.3385 .12657 L
.33862 .12637 L
.33874 .12617 L
.33887 .12597 L
.33899 .12577 L
.33912 .12557 L
.33924 .12537 L
.33936 .12517 L
.33949 .12497 L
.33961 .12477 L
.33973 .12457 L
.33986 .12438 L
.33998 .12418 L
.34011 .12399 L
.34023 .12379 L
.34035 .1236 L
.34048 .1234 L
.3406 .12321 L
.34072 .12301 L
.34084 .12282 L
.34097 .12263 L
.34109 .12244 L
.34121 .12225 L
.34134 .12206 L
.34146 .12187 L
.34158 .12168 L
.3417 .12149 L
.34183 .1213 L
.34195 .12111 L
.34207 .12092 L
.34219 .12074 L
.34232 .12055 L
.34244 .12036 L
.34256 .12018 L
.34268 .11999 L
.34281 .11981 L
.34293 .11962 L
.34305 .11944 L
.34317 .11925 L
.34329 .11907 L
Mistroke
.34342 .11889 L
.34354 .11871 L
.34366 .11853 L
.34378 .11834 L
.3439 .11816 L
.34402 .11798 L
.34414 .1178 L
.34427 .11762 L
.34439 .11745 L
.34451 .11727 L
.34463 .11709 L
.34475 .11691 L
.34487 .11673 L
.34499 .11656 L
.34511 .11638 L
.34524 .11621 L
.34536 .11603 L
.34548 .11586 L
.3456 .11568 L
.34572 .11551 L
.34584 .11533 L
.34596 .11516 L
.34608 .11499 L
.3462 .11482 L
.34632 .11464 L
.34644 .11447 L
.34656 .1143 L
.34668 .11413 L
.3468 .11396 L
.34692 .11379 L
.34704 .11362 L
.34716 .11345 L
.34728 .11328 L
.3474 .11312 L
.34752 .11295 L
.34764 .11278 L
.34776 .11261 L
.34788 .11245 L
.348 .11228 L
.34812 .11212 L
.34824 .11195 L
.34836 .11179 L
.34848 .11162 L
.3486 .11146 L
.34872 .11129 L
.34884 .11113 L
.34896 .11097 L
.34908 .11081 L
.3492 .11064 L
.34932 .11048 L
Mistroke
.34943 .11032 L
.34955 .11016 L
.34967 .11 L
.34979 .10984 L
.34991 .10968 L
.35003 .10952 L
.35015 .10936 L
.35027 .1092 L
.35039 .10905 L
.3505 .10889 L
.35062 .10873 L
.35074 .10857 L
.35086 .10842 L
.35098 .10826 L
.3511 .1081 L
.35121 .10795 L
.35133 .10779 L
.35145 .10764 L
.35157 .10748 L
.35169 .10733 L
.35181 .10718 L
.35192 .10702 L
.35204 .10687 L
.35216 .10672 L
.35228 .10657 L
.35239 .10641 L
.35251 .10626 L
.35263 .10611 L
.35275 .10596 L
.35287 .10581 L
.35298 .10566 L
.3531 .10551 L
.35322 .10536 L
.35334 .10521 L
.35345 .10506 L
.35357 .10492 L
.35369 .10477 L
.3538 .10462 L
.35392 .10447 L
.35404 .10433 L
.35416 .10418 L
.35427 .10403 L
.35439 .10389 L
.35451 .10374 L
.35462 .1036 L
.35474 .10345 L
.35486 .10331 L
.35497 .10316 L
.35509 .10302 L
.35521 .10288 L
Mistroke
.35532 .10273 L
.35544 .10259 L
.35556 .10245 L
.35567 .10231 L
.35579 .10216 L
.35591 .10202 L
.35602 .10188 L
.35614 .10174 L
.35626 .1016 L
.35637 .10146 L
.35649 .10132 L
.3566 .10118 L
.35672 .10104 L
.35684 .1009 L
.35695 .10076 L
.35707 .10063 L
.35718 .10049 L
.3573 .10035 L
.35742 .10021 L
.35753 .10008 L
.35765 .09994 L
.35776 .0998 L
.35788 .09967 L
.358 .09953 L
.35811 .0994 L
.35823 .09926 L
.35834 .09913 L
.35846 .09899 L
.35857 .09886 L
.35869 .09872 L
.3588 .09859 L
.35892 .09846 L
.35903 .09832 L
.35915 .09819 L
.35926 .09806 L
.35938 .09793 L
.35949 .09779 L
.35961 .09766 L
.35972 .09753 L
.35984 .0974 L
.35995 .09727 L
.36007 .09714 L
.36018 .09701 L
.3603 .09688 L
.36041 .09675 L
.36053 .09662 L
.36064 .09649 L
.36076 .09637 L
.36087 .09624 L
.36099 .09611 L
Mistroke
.3611 .09598 L
.36121 .09585 L
.36133 .09573 L
.36144 .0956 L
.36156 .09547 L
.36167 .09535 L
.36179 .09522 L
.3619 .0951 L
.36201 .09497 L
.36213 .09485 L
.36224 .09472 L
.36236 .0946 L
.36247 .09447 L
.36259 .09435 L
.3627 .09422 L
.36281 .0941 L
.36293 .09398 L
.36304 .09386 L
.36315 .09373 L
.36327 .09361 L
.36338 .09349 L
.3635 .09337 L
.36361 .09325 L
.36372 .09312 L
.36384 .093 L
.36395 .09288 L
.36406 .09276 L
.36418 .09264 L
.36429 .09252 L
.3644 .0924 L
.36452 .09228 L
.36463 .09216 L
.36474 .09205 L
.36486 .09193 L
.36497 .09181 L
.36508 .09169 L
.3652 .09157 L
.36531 .09146 L
.36542 .09134 L
.36553 .09122 L
.36565 .09111 L
.36576 .09099 L
.36587 .09087 L
.36599 .09076 L
.3661 .09064 L
.36621 .09053 L
.36632 .09041 L
.36644 .0903 L
.36655 .09018 L
.36666 .09007 L
Mistroke
.36677 .08995 L
.36689 .08984 L
.367 .08972 L
.36711 .08961 L
.36722 .0895 L
.36734 .08939 L
.36745 .08927 L
.36756 .08916 L
.36767 .08905 L
.36779 .08894 L
.3679 .08882 L
.36801 .08871 L
.36812 .0886 L
.36823 .08849 L
.36835 .08838 L
.36846 .08827 L
.36857 .08816 L
.36868 .08805 L
.36879 .08794 L
.36891 .08783 L
.36902 .08772 L
.36913 .08761 L
.36924 .0875 L
.36935 .0874 L
.36946 .08729 L
.36958 .08718 L
.36969 .08707 L
.3698 .08696 L
.36991 .08686 L
.37002 .08675 L
.37013 .08664 L
.37025 .08654 L
.37036 .08643 L
.37047 .08632 L
.37058 .08622 L
.37069 .08611 L
.3708 .08601 L
.37091 .0859 L
.37102 .0858 L
.37114 .08569 L
.37125 .08559 L
.37136 .08548 L
.37147 .08538 L
.37158 .08527 L
.37169 .08517 L
.3718 .08507 L
.37191 .08496 L
.37202 .08486 L
.37213 .08476 L
.37225 .08466 L
Mistroke
.37236 .08455 L
.37247 .08445 L
.37258 .08435 L
.37269 .08425 L
.3728 .08415 L
.37291 .08404 L
.37302 .08394 L
.37313 .08384 L
.37324 .08374 L
.37335 .08364 L
.37346 .08354 L
.37357 .08344 L
.37368 .08334 L
.37379 .08324 L
.3739 .08314 L
.37401 .08304 L
.37412 .08295 L
.37423 .08285 L
.37435 .08275 L
.37446 .08265 L
.37457 .08255 L
.37468 .08245 L
.37479 .08236 L
.3749 .08226 L
.37501 .08216 L
.37512 .08207 L
.37523 .08197 L
.37534 .08187 L
.37545 .08178 L
.37556 .08168 L
.37567 .08158 L
.37578 .08149 L
.37589 .08139 L
.37599 .0813 L
.3761 .0812 L
.37621 .08111 L
.37632 .08101 L
.37643 .08092 L
.37654 .08082 L
.37665 .08073 L
.37676 .08064 L
.37687 .08054 L
.37698 .08045 L
.37709 .08036 L
.3772 .08026 L
.37731 .08017 L
.37742 .08008 L
.37753 .07999 L
.37764 .07989 L
.37775 .0798 L
Mistroke
.37786 .07971 L
.37797 .07962 L
.37807 .07953 L
.37818 .07943 L
.37829 .07934 L
.3784 .07925 L
.37851 .07916 L
.37862 .07907 L
.37873 .07898 L
.37884 .07889 L
.37895 .0788 L
.37906 .07871 L
.37917 .07862 L
.37927 .07853 L
.37938 .07844 L
.37949 .07835 L
.3796 .07827 L
.37971 .07818 L
.37982 .07809 L
.37993 .078 L
.38004 .07791 L
.38014 .07782 L
.38025 .07774 L
.38036 .07765 L
.38047 .07756 L
.38058 .07748 L
.38069 .07739 L
.3808 .0773 L
.3809 .07722 L
.38101 .07713 L
.38112 .07704 L
.38123 .07696 L
.38134 .07687 L
.38145 .07679 L
.38155 .0767 L
.38166 .07661 L
.38177 .07653 L
.38188 .07644 L
.38199 .07636 L
.3821 .07628 L
.3822 .07619 L
.38231 .07611 L
.38242 .07602 L
.38253 .07594 L
.38264 .07586 L
.38274 .07577 L
.38285 .07569 L
.38296 .07561 L
.38307 .07552 L
.38318 .07544 L
Mistroke
.38328 .07536 L
.38339 .07528 L
.3835 .07519 L
.38361 .07511 L
.38371 .07503 L
.38382 .07495 L
.38393 .07487 L
.38404 .07479 L
.38414 .0747 L
.38425 .07462 L
.38436 .07454 L
.38447 .07446 L
.38458 .07438 L
.38468 .0743 L
.38479 .07422 L
.3849 .07414 L
.38501 .07406 L
.38511 .07398 L
.38522 .0739 L
.38533 .07382 L
.38543 .07374 L
.38554 .07366 L
.38565 .07359 L
.38576 .07351 L
.38586 .07343 L
.38597 .07335 L
.38608 .07327 L
.38619 .07319 L
.38629 .07312 L
.3864 .07304 L
.38651 .07296 L
.38661 .07288 L
.38672 .07281 L
.38683 .07273 L
.38694 .07265 L
.38704 .07258 L
.38715 .0725 L
.38726 .07242 L
.38736 .07235 L
.38747 .07227 L
.38758 .0722 L
.38768 .07212 L
.38779 .07205 L
.3879 .07197 L
.388 .0719 L
.38811 .07182 L
.38822 .07175 L
.38832 .07167 L
.38843 .0716 L
.38854 .07152 L
Mistroke
.38864 .07145 L
.38875 .07137 L
.38886 .0713 L
.38896 .07123 L
.38907 .07115 L
.38918 .07108 L
.38928 .07101 L
.38939 .07093 L
.3895 .07086 L
.3896 .07079 L
.38971 .07072 L
.38981 .07064 L
.38992 .07057 L
.39003 .0705 L
.39013 .07043 L
.39024 .07035 L
.39035 .07028 L
.39045 .07021 L
.39056 .07014 L
.39066 .07007 L
.39077 .07 L
.39088 .06993 L
.39098 .06986 L
.39109 .06979 L
.3912 .06972 L
.3913 .06965 L
.39141 .06957 L
.39151 .0695 L
.39162 .06944 L
.39173 .06937 L
.39183 .0693 L
.39194 .06923 L
.39204 .06916 L
.39215 .06909 L
.39225 .06902 L
.39236 .06895 L
.39247 .06888 L
.39257 .06881 L
.39268 .06875 L
.39278 .06868 L
.39289 .06861 L
.39299 .06854 L
.3931 .06847 L
.39321 .06841 L
.39331 .06834 L
.39342 .06827 L
.39352 .0682 L
.39363 .06814 L
.39373 .06807 L
.39384 .068 L
Mistroke
.39394 .06794 L
.39405 .06787 L
.39416 .0678 L
.39426 .06774 L
.39437 .06767 L
.39447 .06761 L
.39458 .06754 L
.39468 .06747 L
.39479 .06741 L
.39489 .06734 L
.395 .06728 L
.3951 .06721 L
.39521 .06715 L
.39531 .06708 L
.39542 .06702 L
.39552 .06695 L
.39563 .06689 L
.39573 .06683 L
.39584 .06676 L
.39595 .0667 L
.39605 .06663 L
.39616 .06657 L
.39626 .06651 L
.39637 .06644 L
.39647 .06638 L
.39658 .06632 L
.39668 .06626 L
.39679 .06619 L
.39689 .06613 L
.39699 .06607 L
.3971 .066 L
.3972 .06594 L
.39731 .06588 L
.39741 .06582 L
.39752 .06576 L
.39762 .06569 L
.39773 .06563 L
.39783 .06557 L
.39794 .06551 L
.39804 .06545 L
.39815 .06539 L
.39825 .06533 L
.39836 .06527 L
.39846 .06521 L
.39857 .06515 L
.39867 .06509 L
.39877 .06503 L
.39888 .06497 L
.39898 .06491 L
.39909 .06485 L
Mistroke
.39919 .06479 L
.3993 .06473 L
.3994 .06467 L
.39951 .06461 L
.39961 .06455 L
.39972 .06449 L
.39982 .06443 L
.39992 .06437 L
.40003 .06431 L
.40013 .06425 L
.40024 .0642 L
.40034 .06414 L
.40045 .06408 L
.40055 .06402 L
.40065 .06396 L
.40076 .06391 L
.40086 .06385 L
.40097 .06379 L
.40107 .06373 L
.40117 .06368 L
.40128 .06362 L
.40138 .06356 L
.40149 .06351 L
.40159 .06345 L
.40169 .06339 L
.4018 .06334 L
.4019 .06328 L
.40201 .06322 L
.40211 .06317 L
.40221 .06311 L
.40232 .06306 L
.40242 .063 L
.40253 .06294 L
.40263 .06289 L
.40273 .06283 L
.40284 .06278 L
.40294 .06272 L
.40305 .06267 L
.40315 .06261 L
.40325 .06256 L
.40336 .0625 L
.40346 .06245 L
.40356 .0624 L
.40367 .06234 L
.40377 .06229 L
.40388 .06223 L
.40398 .06218 L
.40408 .06213 L
.40419 .06207 L
.40429 .06202 L
Mistroke
.40439 .06196 L
.4045 .06191 L
.4046 .06186 L
.4047 .06181 L
.40481 .06175 L
.40491 .0617 L
.40501 .06165 L
.40512 .06159 L
.40522 .06154 L
.40532 .06149 L
.40543 .06144 L
.40553 .06139 L
.40563 .06133 L
.40574 .06128 L
.40584 .06123 L
.40594 .06118 L
.40605 .06113 L
.40615 .06108 L
.40625 .06102 L
.40636 .06097 L
.40646 .06092 L
.40656 .06087 L
.40667 .06082 L
.40677 .06077 L
.40687 .06072 L
.40698 .06067 L
.40708 .06062 L
.40718 .06057 L
.40729 .06052 L
.40739 .06047 L
.40749 .06042 L
.4076 .06037 L
.4077 .06032 L
.4078 .06027 L
.4079 .06022 L
.40801 .06017 L
.40811 .06012 L
.40821 .06007 L
.40832 .06002 L
.40842 .05998 L
.40852 .05993 L
.40863 .05988 L
.40873 .05983 L
.40883 .05978 L
.40893 .05973 L
.40904 .05969 L
.40914 .05964 L
.40924 .05959 L
.40935 .05954 L
.40945 .05949 L
Mistroke
.40955 .05945 L
.40965 .0594 L
.40976 .05932 L
.40986 .05922 L
.40996 .05912 L
.41006 .05901 L
.41017 .05891 L
.41027 .05881 L
.41037 .05871 L
.41047 .0586 L
.41058 .0585 L
.41068 .0584 L
.41078 .0583 L
.41088 .0582 L
.41099 .0581 L
.41109 .058 L
.41119 .0579 L
.41129 .0578 L
.4114 .0577 L
.4115 .0576 L
.4116 .0575 L
.4117 .0574 L
.4118 .0573 L
.41191 .0572 L
.41201 .0571 L
.41211 .057 L
.41221 .05691 L
.41231 .05681 L
.41242 .05671 L
.41252 .05661 L
.41262 .05651 L
.41272 .05642 L
.41282 .05632 L
.41293 .05622 L
.41303 .05613 L
.41313 .05603 L
.41323 .05593 L
.41333 .05584 L
.41343 .05574 L
.41353 .05565 L
.41364 .05555 L
.41374 .05545 L
.41384 .05536 L
.41394 .05526 L
.41404 .05517 L
.41414 .05507 L
.41424 .05498 L
.41435 .05489 L
.41445 .05479 L
.41455 .0547 L
Mistroke
.41465 .0546 L
.41475 .05451 L
.41485 .05442 L
.41495 .05432 L
.41505 .05423 L
.41516 .05414 L
.41526 .05405 L
.41536 .05395 L
.41546 .05386 L
.41556 .05377 L
.41566 .05368 L
.41576 .05359 L
.41586 .05349 L
.41596 .0534 L
.41606 .05331 L
.41616 .05322 L
.41627 .05313 L
.41637 .05304 L
.41647 .05295 L
.41657 .05286 L
.41667 .05277 L
.41677 .05268 L
.41687 .05259 L
.41697 .0525 L
.41707 .05241 L
.41717 .05232 L
.41727 .05223 L
.41737 .05214 L
.41747 .05205 L
.41757 .05197 L
.41767 .05188 L
.41777 .05179 L
.41787 .0517 L
.41797 .05161 L
.41807 .05153 L
.41817 .05144 L
.41827 .05135 L
.41837 .05126 L
.41848 .05118 L
.41858 .05109 L
.41868 .051 L
.41878 .05092 L
.41888 .05083 L
.41898 .05074 L
.41908 .05066 L
.41918 .05057 L
.41928 .05049 L
.41937 .0504 L
.41947 .05032 L
.41957 .05023 L
Mistroke
.41967 .05015 L
.41977 .05006 L
.41987 .04998 L
.41997 .04989 L
.42007 .04981 L
.42017 .04972 L
.42027 .04964 L
.42037 .04956 L
.42047 .04947 L
.42057 .04939 L
.42067 .04931 L
.42077 .04922 L
.42087 .04914 L
.42097 .04906 L
.42107 .04897 L
.42117 .04889 L
.42127 .04881 L
.42137 .04873 L
.42147 .04865 L
.42157 .04856 L
.42166 .04848 L
.42176 .0484 L
.42186 .04832 L
.42196 .04824 L
.42206 .04816 L
.42216 .04808 L
.42226 .04799 L
.42236 .04791 L
.42246 .04783 L
.42256 .04775 L
.42266 .04767 L
.42276 .04759 L
.42285 .04751 L
.42295 .04743 L
.42305 .04735 L
.42315 .04728 L
.42325 .0472 L
.42335 .04712 L
.42345 .04704 L
.42355 .04696 L
.42364 .04688 L
.42374 .0468 L
.42384 .04672 L
.42394 .04665 L
.42404 .04657 L
.42414 .04649 L
.42424 .04641 L
.42434 .04633 L
.42443 .04626 L
.42453 .04618 L
Mistroke
.42463 .0461 L
.42473 .04603 L
.42483 .04595 L
.42493 .04587 L
.42502 .0458 L
.42512 .04572 L
.42522 .04564 L
.42532 .04557 L
.42542 .04549 L
.42552 .04542 L
.42561 .04534 L
.42571 .04526 L
.42581 .04519 L
.42591 .04511 L
.42601 .04504 L
.42611 .04496 L
.4262 .04489 L
.4263 .04481 L
.4264 .04474 L
.4265 .04467 L
.4266 .04459 L
.42669 .04452 L
.42679 .04444 L
.42689 .04437 L
.42699 .0443 L
.42709 .04422 L
.42718 .04415 L
.42728 .04408 L
.42738 .044 L
.42748 .04393 L
.42757 .04386 L
.42767 .04379 L
.42777 .04371 L
.42787 .04364 L
.42797 .04357 L
.42806 .0435 L
.42816 .04342 L
.42826 .04335 L
.42836 .04328 L
.42845 .04321 L
.42855 .04314 L
.42865 .04307 L
.42875 .043 L
.42884 .04292 L
.42894 .04285 L
.42904 .04278 L
.42914 .04271 L
.42923 .04264 L
.42933 .04257 L
.42943 .0425 L
Mistroke
.42953 .04243 L
.42962 .04236 L
.42972 .04229 L
.42982 .04222 L
.42991 .04215 L
.43001 .04208 L
.43011 .04201 L
.43021 .04195 L
.4303 .04188 L
.4304 .04181 L
.4305 .04174 L
.43059 .04167 L
.43069 .0416 L
.43079 .04153 L
.43089 .04147 L
.43098 .0414 L
.43108 .04133 L
.43118 .04126 L
.43127 .04119 L
.43137 .04113 L
.43147 .04106 L
.43156 .04099 L
.43166 .04092 L
.43176 .04086 L
.43185 .04079 L
.43195 .04072 L
.43205 .04066 L
.43215 .04059 L
.43224 .04052 L
.43234 .04046 L
.43244 .04039 L
.43253 .04033 L
.43263 .04026 L
.43273 .04019 L
.43282 .04013 L
.43292 .04006 L
.43301 .04 L
.43311 .03993 L
.43321 .03987 L
.4333 .0398 L
.4334 .03974 L
.4335 .03967 L
.43359 .03961 L
.43369 .03954 L
.43379 .03948 L
.43388 .03942 L
.43398 .03935 L
.43408 .03929 L
.43417 .03922 L
.43427 .03916 L
Mistroke
.43436 .0391 L
.43446 .03903 L
.43456 .03897 L
.43465 .03891 L
.43475 .03884 L
.43485 .03878 L
.43494 .03872 L
.43504 .03865 L
.43513 .03859 L
.43523 .03853 L
.43533 .03847 L
.43542 .0384 L
.43552 .03834 L
.43561 .03828 L
.43571 .03822 L
.43581 .03816 L
.4359 .03809 L
.436 .03803 L
.43609 .03797 L
.43619 .03791 L
.43629 .03785 L
.43638 .03779 L
.43648 .03773 L
.43657 .03767 L
.43667 .03761 L
.43676 .03754 L
.43686 .03748 L
.43696 .03742 L
.43705 .03736 L
.43715 .0373 L
.43724 .03724 L
.43734 .03718 L
.43743 .03712 L
.43753 .03706 L
.43763 .037 L
.43772 .03694 L
.43782 .03689 L
.43791 .03683 L
.43801 .03677 L
.4381 .03671 L
.4382 .03665 L
.43829 .03659 L
.43839 .03653 L
.43848 .03647 L
.43858 .03641 L
.43868 .03636 L
.43877 .0363 L
.43887 .03624 L
.43896 .03618 L
.43906 .03612 L
Mistroke
.43915 .03607 L
.43925 .03601 L
.43934 .03595 L
.43944 .03589 L
.43953 .03584 L
.43963 .03578 L
.43972 .03572 L
.43982 .03566 L
.43991 .03561 L
.44001 .03555 L
.4401 .03549 L
.4402 .03544 L
.44029 .03538 L
.44039 .03532 L
.44048 .03527 L
.44058 .03521 L
.44067 .03516 L
.44077 .0351 L
.44086 .03504 L
.44096 .03499 L
.44105 .03493 L
.44115 .03488 L
.44124 .03482 L
.44134 .03477 L
.44143 .03471 L
.44153 .03466 L
.44162 .0346 L
.44172 .03455 L
.44181 .03449 L
.44191 .03444 L
.442 .03438 L
.4421 .03433 L
.44219 .03427 L
.44229 .03422 L
.44238 .03417 L
.44248 .03411 L
.44257 .03406 L
.44267 .034 L
.44276 .03395 L
.44285 .0339 L
.44295 .03384 L
.44304 .03379 L
.44314 .03374 L
.44323 .03368 L
.44333 .03363 L
.44342 .03358 L
.44352 .03352 L
.44361 .03347 L
.4437 .03342 L
.4438 .03337 L
Mistroke
.44389 .03331 L
.44399 .03326 L
.44408 .03321 L
.44418 .03316 L
.44427 .03311 L
.44437 .03305 L
.44446 .033 L
.44455 .03295 L
.44465 .0329 L
.44474 .03285 L
.44484 .0328 L
.44493 .03274 L
.44503 .03269 L
.44512 .03264 L
.44521 .03259 L
.44531 .03254 L
.4454 .03249 L
.4455 .03244 L
.44559 .03239 L
.44568 .03234 L
.44578 .03229 L
.44587 .03224 L
.44597 .03219 L
.44606 .03214 L
.44615 .03209 L
.44625 .03204 L
.44634 .03199 L
.44644 .03194 L
.44653 .03189 L
.44662 .03184 L
.44672 .03179 L
.44681 .03174 L
.44691 .03169 L
.447 .03164 L
.44709 .03159 L
.44719 .03154 L
.44728 .03149 L
.44738 .03144 L
.44747 .03139 L
.44756 .03135 L
.44766 .0313 L
.44775 .03125 L
.44784 .0312 L
.44794 .03115 L
.44803 .0311 L
.44813 .03106 L
.44822 .03101 L
.44831 .03096 L
.44841 .03091 L
.4485 .03087 L
Mistroke
.44859 .03082 L
.44869 .03077 L
.44878 .03072 L
.44887 .03068 L
.44897 .03063 L
.44906 .03058 L
.44915 .03053 L
.44925 .03049 L
.44934 .03044 L
.44943 .03039 L
.44953 .03035 L
.44962 .0303 L
.44972 .03025 L
.44981 .03021 L
.4499 .03016 L
.45 .03012 L
.45009 .03007 L
.45018 .03002 L
.45028 .02998 L
.45037 .02993 L
.45046 .02989 L
.45056 .02984 L
.45065 .02979 L
.45074 .02975 L
.45084 .0297 L
.45093 .02966 L
.45102 .02961 L
.45111 .02957 L
.45121 .02952 L
.4513 .02948 L
.45139 .02943 L
.45149 .02939 L
.45158 .02934 L
.45167 .0293 L
.45177 .02926 L
.45186 .02921 L
.45195 .02917 L
.45205 .02912 L
.45214 .02908 L
.45223 .02903 L
.45233 .02899 L
.45242 .02895 L
.45251 .0289 L
.4526 .02886 L
.4527 .02882 L
.45279 .02877 L
.45288 .02873 L
.45298 .02869 L
.45307 .02864 L
.45316 .0286 L
Mistroke
.45325 .02856 L
.45335 .02851 L
.45344 .02847 L
.45353 .02843 L
.45363 .02839 L
.45372 .02834 L
.45381 .0283 L
.4539 .02826 L
.454 .02822 L
.45409 .02817 L
.45418 .02813 L
.45428 .02809 L
.45437 .02805 L
.45446 .02801 L
.45455 .02796 L
.45465 .02792 L
.45474 .02788 L
.45483 .02784 L
.45492 .0278 L
.45502 .02776 L
.45511 .02771 L
.4552 .02767 L
.45529 .02763 L
.45539 .02759 L
.45548 .02755 L
.45557 .02751 L
.45566 .02747 L
.45576 .02743 L
.45585 .02739 L
.45594 .02735 L
.45603 .02731 L
.45613 .02727 L
.45622 .02722 L
.45631 .02718 L
.4564 .02714 L
.4565 .0271 L
.45659 .02706 L
.45668 .02702 L
.45677 .02698 L
.45687 .02695 L
.45696 .02691 L
.45705 .02687 L
.45714 .02683 L
.45724 .02679 L
.45733 .02675 L
.45742 .02671 L
.45751 .02667 L
.45761 .02663 L
.4577 .02659 L
.45779 .02655 L
Mistroke
.45788 .02651 L
.45797 .02647 L
.45807 .02644 L
.45816 .0264 L
.45825 .02636 L
.45834 .02632 L
.45843 .02628 L
.45853 .02624 L
.45862 .02621 L
.45871 .02617 L
.4588 .02613 L
.4589 .02609 L
.45899 .02605 L
.45908 .02602 L
.45917 .02598 L
.45926 .02594 L
.45936 .0259 L
.45945 .02587 L
.45954 .02583 L
.45963 .02579 L
.45972 .02575 L
.45982 .02572 L
.45991 .02568 L
.46 .02564 L
.46009 .02561 L
.46018 .02557 L
.46028 .02553 L
.46037 .0255 L
.46046 .02546 L
.46055 .02542 L
.46064 .02539 L
.46073 .02535 L
.46083 .02531 L
.46092 .02528 L
.46101 .02524 L
.4611 .0252 L
.46119 .02517 L
.46129 .02513 L
.46138 .0251 L
.46147 .02506 L
.46156 .02503 L
.46165 .02499 L
.46174 .02495 L
.46184 .02492 L
.46193 .02488 L
.46202 .02485 L
.46211 .02481 L
.4622 .02478 L
.46229 .02474 L
.46239 .02471 L
Mistroke
.46248 .02467 L
.46257 .02464 L
.46266 .0246 L
.46275 .02457 L
.46284 .02453 L
.46294 .0245 L
.46303 .02447 L
.46312 .02443 L
.46321 .0244 L
.4633 .02436 L
.46339 .02433 L
.46349 .02429 L
.46358 .02426 L
.46367 .02423 L
.46376 .02419 L
.46385 .02416 L
.46394 .02412 L
.46403 .02409 L
.46413 .02406 L
.46422 .02402 L
.46431 .02399 L
.4644 .02396 L
.46449 .02392 L
.46458 .02389 L
.46467 .02386 L
.46477 .02382 L
.46486 .02379 L
.46495 .02376 L
.46504 .02373 L
.46513 .02369 L
.46522 .02366 L
.46531 .02363 L
.4654 .0236 L
.4655 .02356 L
.46559 .02353 L
.46568 .0235 L
.46577 .02347 L
.46586 .02343 L
.46595 .0234 L
.46604 .02337 L
.46613 .02334 L
.46623 .02331 L
.46632 .02327 L
.46641 .02324 L
.4665 .02321 L
.46659 .02318 L
.46668 .02315 L
.46677 .02312 L
.46686 .02308 L
.46695 .02305 L
Mistroke
.46705 .02302 L
.46714 .02299 L
.46723 .02296 L
.46732 .02293 L
.46741 .0229 L
.4675 .02287 L
.46759 .02284 L
.46768 .02281 L
.46777 .02277 L
.46787 .02274 L
.46796 .02271 L
.46805 .02268 L
.46814 .02265 L
.46823 .02262 L
.46832 .02259 L
.46841 .02256 L
.4685 .02253 L
.46859 .0225 L
.46868 .02247 L
.46878 .02244 L
.46887 .02241 L
.46896 .02238 L
.46905 .02235 L
.46914 .02232 L
.46923 .02229 L
.46932 .02226 L
.46941 .02223 L
.4695 .0222 L
.46959 .02218 L
.46968 .02215 L
.46977 .02212 L
.46987 .02209 L
.46996 .02206 L
.47005 .02203 L
.47014 .022 L
.47023 .02197 L
.47032 .02194 L
.47041 .02192 L
.4705 .02189 L
.47059 .02186 L
.47068 .02183 L
.47077 .0218 L
.47086 .02177 L
.47095 .02174 L
.47105 .02172 L
.47114 .02169 L
.47123 .02166 L
.47132 .02163 L
.47141 .0216 L
.4715 .02158 L
Mistroke
.47159 .02155 L
.47168 .02152 L
.47177 .02149 L
.47186 .02147 L
.47195 .02144 L
.47204 .02141 L
.47213 .02138 L
.47222 .02136 L
.47231 .02133 L
.4724 .0213 L
.47249 .02127 L
.47259 .02125 L
.47268 .02122 L
.47277 .02119 L
.47286 .02117 L
.47295 .02114 L
.47304 .02111 L
.47313 .02109 L
.47322 .02106 L
.47331 .02103 L
.4734 .02101 L
.47349 .02098 L
.47358 .02095 L
.47367 .02093 L
.47376 .0209 L
.47385 .02087 L
.47394 .02085 L
.47403 .02082 L
.47412 .0208 L
.47421 .02077 L
.4743 .02074 L
.47439 .02072 L
.47448 .02069 L
.47458 .02067 L
.47467 .02064 L
.47476 .02062 L
.47485 .02059 L
.47494 .02057 L
.47503 .02054 L
.47512 .02052 L
.47521 .02049 L
.4753 .02046 L
.47539 .02044 L
.47548 .02041 L
.47557 .02039 L
.47566 .02036 L
.47575 .02034 L
.47584 .02032 L
.47593 .02029 L
.47602 .02027 L
Mistroke
.47611 .02024 L
.4762 .02022 L
.47629 .02019 L
.47638 .02017 L
.47647 .02014 L
.47656 .02012 L
.47665 .0201 L
.47674 .02007 L
.47683 .02005 L
.47692 .02002 L
.47701 .02 L
.4771 .01998 L
.47719 .01995 L
.47728 .01993 L
.47737 .0199 L
.47746 .01988 L
.47755 .01986 L
.47764 .01983 L
.47773 .01981 L
.47782 .01979 L
.47791 .01976 L
.478 .01974 L
.47809 .01972 L
.47818 .01969 L
.47827 .01967 L
.47836 .01965 L
.47845 .01962 L
.47854 .0196 L
.47863 .01958 L
.47872 .01956 L
.47881 .01953 L
.4789 .01951 L
.47899 .01949 L
.47908 .01947 L
.47917 .01944 L
.47926 .01942 L
.47935 .0194 L
.47944 .01938 L
.47953 .01935 L
.47962 .01933 L
.47971 .01931 L
.4798 .01929 L
.47989 .01927 L
.47998 .01924 L
.48007 .01922 L
.48016 .0192 L
.48025 .01918 L
.48034 .01916 L
.48043 .01914 L
.48052 .01911 L
Mistroke
.48061 .01909 L
.4807 .01907 L
.48079 .01905 L
.48088 .01903 L
.48097 .01901 L
.48106 .01899 L
.48115 .01896 L
.48124 .01894 L
.48133 .01892 L
.48142 .0189 L
.48151 .01888 L
.4816 .01886 L
.48169 .01884 L
.48178 .01882 L
.48187 .0188 L
.48196 .01878 L
.48205 .01876 L
.48214 .01874 L
.48223 .01872 L
.48232 .01869 L
.48241 .01867 L
.4825 .01865 L
.48259 .01863 L
.48268 .01861 L
.48277 .01859 L
.48286 .01857 L
.48294 .01855 L
.48303 .01853 L
.48312 .01851 L
.48321 .01849 L
.4833 .01847 L
.48339 .01845 L
.48348 .01844 L
.48357 .01842 L
.48366 .0184 L
.48375 .01838 L
.48384 .01836 L
.48393 .01834 L
.48402 .01832 L
.48411 .0183 L
.4842 .01828 L
.48429 .01826 L
.48438 .01824 L
.48447 .01822 L
.48456 .0182 L
.48465 .01819 L
.48474 .01817 L
.48483 .01815 L
.48492 .01813 L
.48501 .01811 L
Mistroke
.4851 .01809 L
.48518 .01807 L
.48527 .01805 L
.48536 .01804 L
.48545 .01802 L
.48554 .018 L
.48563 .01798 L
.48572 .01796 L
.48581 .01795 L
.4859 .01793 L
.48599 .01791 L
.48608 .01789 L
.48617 .01787 L
.48626 .01786 L
.48635 .01784 L
.48644 .01782 L
.48653 .0178 L
.48662 .01778 L
.48671 .01777 L
.48679 .01775 L
.48688 .01773 L
.48697 .01771 L
.48706 .0177 L
.48715 .01768 L
.48724 .01766 L
.48733 .01765 L
.48742 .01763 L
.48751 .01761 L
.4876 .01759 L
.48769 .01758 L
.48778 .01756 L
.48787 .01754 L
.48796 .01753 L
.48805 .01751 L
.48814 .01749 L
.48822 .01748 L
.48831 .01746 L
.4884 .01744 L
.48849 .01743 L
.48858 .01741 L
.48867 .01739 L
.48876 .01738 L
.48885 .01736 L
.48894 .01735 L
.48903 .01733 L
.48912 .01731 L
.48921 .0173 L
.4893 .01728 L
.48939 .01727 L
.48947 .01725 L
Mistroke
.48956 .01723 L
.48965 .01722 L
.48974 .0172 L
.48983 .01719 L
.48992 .01717 L
.49001 .01716 L
.4901 .01714 L
.49019 .01712 L
.49028 .01711 L
.49037 .01709 L
.49046 .01708 L
.49055 .01706 L
.49063 .01705 L
.49072 .01703 L
.49081 .01702 L
.4909 .017 L
.49099 .01699 L
.49108 .01697 L
.49117 .01696 L
.49126 .01694 L
.49135 .01693 L
.49144 .01691 L
.49153 .0169 L
.49162 .01688 L
.4917 .01687 L
.49179 .01686 L
.49188 .01684 L
.49197 .01683 L
.49206 .01681 L
.49215 .0168 L
.49224 .01678 L
.49233 .01677 L
.49242 .01676 L
.49251 .01674 L
.4926 .01673 L
.49268 .01671 L
.49277 .0167 L
.49286 .01669 L
.49295 .01667 L
.49304 .01666 L
.49313 .01664 L
.49322 .01663 L
.49331 .01662 L
.4934 .0166 L
.49349 .01659 L
.49358 .01658 L
.49366 .01656 L
.49375 .01655 L
.49384 .01654 L
.49393 .01652 L
Mistroke
.49402 .01651 L
.49411 .0165 L
.4942 .01648 L
.49429 .01647 L
.49438 .01646 L
.49447 .01645 L
.49455 .01643 L
.49464 .01642 L
.49473 .01641 L
.49482 .01639 L
.49491 .01638 L
.495 .01637 L
.49509 .01636 L
.49518 .01634 L
.49527 .01633 L
.49536 .01632 L
.49544 .01631 L
.49553 .01629 L
.49562 .01628 L
.49571 .01627 L
.4958 .01626 L
.49589 .01625 L
.49598 .01623 L
.49607 .01622 L
.49616 .01621 L
.49624 .0162 L
.49633 .01619 L
.49642 .01617 L
.49651 .01616 L
.4966 .01615 L
.49669 .01614 L
.49678 .01613 L
.49687 .01612 L
.49696 .0161 L
.49704 .01609 L
.49713 .01608 L
.49722 .01607 L
.49731 .01606 L
.4974 .01605 L
.49749 .01604 L
.49758 .01603 L
.49767 .01601 L
.49776 .016 L
.49784 .01599 L
.49793 .01598 L
.49802 .01597 L
.49811 .01596 L
.4982 .01595 L
.49829 .01594 L
.49838 .01593 L
Mistroke
.49847 .01592 L
.49856 .01591 L
.49864 .0159 L
.49873 .01588 L
.49882 .01587 L
.49891 .01586 L
.499 .01585 L
.49909 .01584 L
.49918 .01583 L
.49927 .01582 L
.49935 .01581 L
.49944 .0158 L
.49953 .01579 L
.49962 .01578 L
.49971 .01577 L
.4998 .01576 L
.49989 .01575 L
.49998 .01574 L
.50006 .01573 L
.50015 .01572 L
.50024 .01571 L
.50033 .0157 L
.50042 .01569 L
.50051 .01569 L
.5006 .01568 L
.50069 .01567 L
.50077 .01566 L
.50086 .01565 L
.50095 .01564 L
.50104 .01563 L
.50113 .01562 L
.50122 .01561 L
.50131 .0156 L
.5014 .01559 L
.50148 .01558 L
.50157 .01557 L
.50166 .01557 L
.50175 .01556 L
.50184 .01555 L
.50193 .01554 L
.50202 .01553 L
.50211 .01552 L
.50219 .01551 L
.50228 .01551 L
.50237 .0155 L
.50246 .01549 L
.50255 .01548 L
.50264 .01547 L
.50273 .01546 L
.50282 .01545 L
Mistroke
.5029 .01545 L
.50299 .01544 L
.50308 .01543 L
.50317 .01542 L
.50326 .01541 L
.50335 .01541 L
.50344 .0154 L
.50352 .01539 L
.50361 .01538 L
.5037 .01537 L
.50379 .01537 L
.50388 .01536 L
.50397 .01535 L
.50406 .01534 L
.50415 .01534 L
.50423 .01533 L
.50432 .01532 L
.50441 .01531 L
.5045 .01531 L
.50459 .0153 L
.50468 .01529 L
.50477 .01529 L
.50485 .01528 L
.50494 .01527 L
.50503 .01526 L
.50512 .01526 L
.50521 .01525 L
.5053 .01524 L
.50539 .01524 L
.50547 .01523 L
.50556 .01522 L
.50565 .01522 L
.50574 .01521 L
.50583 .0152 L
.50592 .0152 L
.50601 .01519 L
.50609 .01518 L
.50618 .01518 L
.50627 .01517 L
.50636 .01516 L
.50645 .01516 L
.50654 .01515 L
.50663 .01514 L
.50671 .01514 L
.5068 .01513 L
.50689 .01513 L
.50698 .01512 L
.50707 .01511 L
.50716 .01511 L
.50725 .0151 L
Mistroke
.50733 .0151 L
.50742 .01509 L
.50751 .01508 L
.5076 .01508 L
.50769 .01507 L
.50778 .01507 L
.50787 .01506 L
.50795 .01506 L
.50804 .01505 L
.50813 .01505 L
.50822 .01504 L
.50831 .01503 L
.5084 .01503 L
.50849 .01502 L
.50857 .01502 L
.50866 .01501 L
.50875 .01501 L
.50884 .015 L
.50893 .015 L
.50902 .01499 L
.50911 .01499 L
.50919 .01498 L
.50928 .01498 L
.50937 .01497 L
.50946 .01497 L
.50955 .01496 L
.50964 .01496 L
.50973 .01496 L
.50981 .01495 L
.5099 .01495 L
.50999 .01494 L
.51008 .01494 L
.51017 .01493 L
.51026 .01493 L
.51034 .01492 L
.51043 .01492 L
.51052 .01492 L
.51061 .01491 L
.5107 .01491 L
.51079 .0149 L
.51088 .0149 L
.51096 .0149 L
.51105 .01489 L
.51114 .01489 L
.51123 .01488 L
.51132 .01488 L
.51141 .01488 L
.5115 .01487 L
.51158 .01487 L
.51167 .01486 L
Mistroke
.51176 .01486 L
.51185 .01486 L
.51194 .01485 L
.51203 .01485 L
.51211 .01485 L
.5122 .01484 L
.51229 .01484 L
.51238 .01484 L
.51247 .01483 L
.51256 .01483 L
.51265 .01483 L
.51273 .01482 L
.51282 .01482 L
.51291 .01482 L
.513 .01482 L
.51309 .01481 L
.51318 .01481 L
.51327 .01481 L
.51335 .0148 L
.51344 .0148 L
.51353 .0148 L
.51362 .0148 L
.51371 .01479 L
.5138 .01479 L
.51388 .01479 L
.51397 .01479 L
.51406 .01478 L
.51415 .01478 L
.51424 .01478 L
.51433 .01478 L
.51442 .01477 L
.5145 .01477 L
.51459 .01477 L
.51468 .01477 L
.51477 .01477 L
.51486 .01476 L
.51495 .01476 L
.51503 .01476 L
.51512 .01476 L
.51521 .01476 L
.5153 .01475 L
.51539 .01475 L
.51548 .01475 L
.51556 .01475 L
.51565 .01475 L
.51574 .01474 L
.51583 .01474 L
.51592 .01474 L
.51601 .01474 L
.5161 .01474 L
Mistroke
.51618 .01474 L
.51627 .01474 L
.51636 .01473 L
.51645 .01473 L
.51654 .01473 L
.51663 .01473 L
.51671 .01473 L
.5168 .01473 L
.51689 .01473 L
.51698 .01473 L
.51707 .01473 L
.51716 .01472 L
.51725 .01472 L
.51733 .01472 L
.51742 .01472 L
.51751 .01472 L
.5176 .01472 L
.51769 .01472 L
.51778 .01472 L
.51786 .01472 L
.51795 .01472 L
.51804 .01472 L
.51813 .01472 L
.51822 .01472 L
.51831 .01472 L
.5184 .01472 L
.51848 .01472 L
.51857 .01472 L
.51866 .01472 L
.51875 .01472 L
.51884 .01472 L
.51893 .01472 L
.51901 .01472 L
.5191 .01472 L
.51919 .01472 L
.51928 .01472 L
.51937 .01472 L
.51946 .01472 L
.51954 .01472 L
.51963 .01472 L
.51972 .01472 L
.51981 .01472 L
.5199 .01472 L
.51999 .01472 L
.52008 .01472 L
.52016 .01472 L
.52025 .01472 L
.52034 .01472 L
.52043 .01472 L
.52052 .01472 L
Mistroke
.52061 .01472 L
.52069 .01472 L
.52078 .01472 L
.52087 .01472 L
.52096 .01473 L
.52105 .01473 L
.52114 .01473 L
.52123 .01473 L
.52131 .01473 L
.5214 .01473 L
.52149 .01473 L
.52158 .01473 L
.52167 .01473 L
.52176 .01474 L
.52184 .01474 L
.52193 .01474 L
.52202 .01474 L
.52211 .01474 L
.5222 .01474 L
.52229 .01474 L
.52238 .01475 L
.52246 .01475 L
.52255 .01475 L
.52264 .01475 L
.52273 .01475 L
.52282 .01475 L
.52291 .01476 L
.52299 .01476 L
.52308 .01476 L
.52317 .01476 L
.52326 .01476 L
.52335 .01477 L
.52344 .01477 L
.52353 .01477 L
.52361 .01477 L
.5237 .01477 L
.52379 .01478 L
.52388 .01478 L
.52397 .01478 L
.52406 .01478 L
.52414 .01479 L
.52423 .01479 L
.52432 .01479 L
.52441 .01479 L
.5245 .0148 L
.52459 .0148 L
.52468 .0148 L
.52476 .0148 L
.52485 .01481 L
.52494 .01481 L
Mistroke
.52503 .01481 L
.52512 .01481 L
.52521 .01482 L
.52529 .01482 L
.52538 .01482 L
.52547 .01483 L
.52556 .01483 L
.52565 .01483 L
.52574 .01484 L
.52583 .01484 L
.52591 .01484 L
.526 .01484 L
.52609 .01485 L
.52618 .01485 L
.52627 .01485 L
.52636 .01486 L
.52644 .01486 L
.52653 .01487 L
.52662 .01487 L
.52671 .01487 L
.5268 .01488 L
.52689 .01488 L
.52698 .01488 L
.52706 .01489 L
.52715 .01489 L
.52724 .01489 L
.52733 .0149 L
.52742 .0149 L
.52751 .01491 L
.5276 .01491 L
.52768 .01491 L
.52777 .01492 L
.52786 .01492 L
.52795 .01493 L
.52804 .01493 L
.52813 .01494 L
.52821 .01494 L
.5283 .01494 L
.52839 .01495 L
.52848 .01495 L
.52857 .01496 L
.52866 .01496 L
.52875 .01497 L
.52883 .01497 L
.52892 .01498 L
.52901 .01498 L
.5291 .01498 L
.52919 .01499 L
.52928 .01499 L
.52937 .015 L
Mistroke
.52945 .015 L
.52954 .01501 L
.52963 .01501 L
.52972 .01502 L
.52981 .01502 L
.5299 .01503 L
.52999 .01503 L
.53007 .01504 L
.53016 .01504 L
.53025 .01505 L
.53034 .01505 L
.53043 .01506 L
.53052 .01506 L
.5306 .01507 L
.53069 .01508 L
.53078 .01508 L
.53087 .01509 L
.53096 .01509 L
.53105 .0151 L
.53114 .0151 L
.53122 .01511 L
.53131 .01511 L
.5314 .01512 L
.53149 .01513 L
.53158 .01513 L
.53167 .01514 L
.53176 .01514 L
.53184 .01515 L
.53193 .01516 L
.53202 .01516 L
.53211 .01517 L
.5322 .01517 L
.53229 .01518 L
.53238 .01519 L
.53246 .01519 L
.53255 .0152 L
.53264 .0152 L
.53273 .01521 L
.53282 .01522 L
.53291 .01522 L
.533 .01523 L
.53309 .01524 L
.53317 .01524 L
.53326 .01525 L
.53335 .01526 L
.53344 .01526 L
.53353 .01527 L
.53362 .01528 L
.53371 .01528 L
.53379 .01529 L
Mistroke
.53388 .0153 L
.53397 .0153 L
.53406 .01531 L
.53415 .01532 L
.53424 .01532 L
.53433 .01533 L
.53441 .01534 L
.5345 .01534 L
.53459 .01535 L
.53468 .01536 L
.53477 .01537 L
.53486 .01537 L
.53495 .01538 L
.53503 .01539 L
.53512 .0154 L
.53521 .0154 L
.5353 .01541 L
.53539 .01542 L
.53548 .01543 L
.53557 .01543 L
.53566 .01544 L
.53574 .01545 L
.53583 .01546 L
.53592 .01546 L
.53601 .01547 L
.5361 .01548 L
.53619 .01549 L
.53628 .0155 L
.53637 .0155 L
.53645 .01551 L
.53654 .01552 L
.53663 .01553 L
.53672 .01554 L
.53681 .01554 L
.5369 .01555 L
.53699 .01556 L
.53707 .01557 L
.53716 .01558 L
.53725 .01558 L
.53734 .01559 L
.53743 .0156 L
.53752 .01561 L
.53761 .01562 L
.5377 .01563 L
.53778 .01563 L
.53787 .01564 L
.53796 .01565 L
.53805 .01566 L
.53814 .01567 L
.53823 .01568 L
Mistroke
.53832 .01569 L
.53841 .0157 L
.53849 .0157 L
.53858 .01571 L
.53867 .01572 L
.53876 .01573 L
.53885 .01574 L
.53894 .01575 L
.53903 .01576 L
.53912 .01577 L
.5392 .01578 L
.53929 .01579 L
.53938 .0158 L
.53947 .0158 L
.53956 .01581 L
.53965 .01582 L
.53974 .01583 L
.53983 .01584 L
.53991 .01585 L
.54 .01586 L
.54009 .01587 L
.54018 .01588 L
.54027 .01589 L
.54036 .0159 L
.54045 .01591 L
.54054 .01592 L
.54063 .01593 L
.54071 .01594 L
.5408 .01595 L
.54089 .01596 L
.54098 .01597 L
.54107 .01598 L
.54116 .01599 L
.54125 .016 L
.54134 .01601 L
.54142 .01602 L
.54151 .01603 L
.5416 .01604 L
.54169 .01605 L
.54178 .01606 L
.54187 .01607 L
.54196 .01608 L
.54205 .01609 L
.54214 .0161 L
.54222 .01611 L
.54231 .01612 L
.5424 .01613 L
.54249 .01614 L
.54258 .01615 L
.54267 .01616 L
Mistroke
.54276 .01617 L
.54285 .01619 L
.54294 .0162 L
.54302 .01621 L
.54311 .01622 L
.5432 .01623 L
.54329 .01624 L
.54338 .01625 L
.54347 .01626 L
.54356 .01627 L
.54365 .01628 L
.54374 .01629 L
.54383 .01631 L
.54391 .01632 L
.544 .01633 L
.54409 .01634 L
.54418 .01635 L
.54427 .01636 L
.54436 .01637 L
.54445 .01638 L
.54454 .0164 L
.54463 .01641 L
.54471 .01642 L
.5448 .01643 L
.54489 .01644 L
.54498 .01645 L
.54507 .01647 L
.54516 .01648 L
.54525 .01649 L
.54534 .0165 L
.54543 .01651 L
.54552 .01652 L
.5456 .01654 L
.54569 .01655 L
.54578 .01656 L
.54587 .01657 L
.54596 .01658 L
.54605 .0166 L
.54614 .01661 L
.54623 .01662 L
.54632 .01663 L
.54641 .01665 L
.5465 .01666 L
.54658 .01667 L
.54667 .01668 L
.54676 .01669 L
.54685 .01671 L
.54694 .01672 L
.54703 .01673 L
.54712 .01674 L
Mistroke
.54721 .01676 L
.5473 .01677 L
.54739 .01678 L
.54748 .01679 L
.54756 .01681 L
.54765 .01682 L
.54774 .01683 L
.54783 .01685 L
.54792 .01686 L
.54801 .01687 L
.5481 .01688 L
.54819 .0169 L
.54828 .01691 L
.54837 .01692 L
.54846 .01694 L
.54854 .01695 L
.54863 .01696 L
.54872 .01698 L
.54881 .01699 L
.5489 .017 L
.54899 .01702 L
.54908 .01703 L
.54917 .01704 L
.54926 .01706 L
.54935 .01707 L
.54944 .01708 L
.54953 .0171 L
.54961 .01711 L
.5497 .01712 L
.54979 .01714 L
.54988 .01715 L
.54997 .01717 L
.55006 .01718 L
.55015 .01719 L
.55024 .01721 L
.55033 .01722 L
.55042 .01723 L
.55051 .01725 L
.5506 .01726 L
.55069 .01728 L
.55077 .01729 L
.55086 .0173 L
.55095 .01732 L
.55104 .01733 L
.55113 .01735 L
.55122 .01736 L
.55131 .01738 L
.5514 .01739 L
.55149 .0174 L
.55158 .01742 L
Mistroke
.55167 .01743 L
.55176 .01745 L
.55185 .01746 L
.55194 .01748 L
.55203 .01749 L
.55211 .01751 L
.5522 .01752 L
.55229 .01754 L
.55238 .01755 L
.55247 .01757 L
.55256 .01758 L
.55265 .01759 L
.55274 .01761 L
.55283 .01762 L
.55292 .01764 L
.55301 .01765 L
.5531 .01767 L
.55319 .01768 L
.55328 .0177 L
.55337 .01771 L
.55345 .01773 L
.55354 .01775 L
.55363 .01776 L
.55372 .01778 L
.55381 .01779 L
.5539 .01781 L
.55399 .01782 L
.55408 .01784 L
.55417 .01785 L
.55426 .01787 L
.55435 .01788 L
.55444 .0179 L
.55453 .01792 L
.55462 .01793 L
.55471 .01795 L
.5548 .01796 L
.55489 .01798 L
.55498 .01799 L
.55506 .01801 L
.55515 .01803 L
.55524 .01804 L
.55533 .01806 L
.55542 .01807 L
.55551 .01809 L
.5556 .01811 L
.55569 .01812 L
.55578 .01814 L
.55587 .01815 L
.55596 .01817 L
.55605 .01819 L
Mistroke
.55614 .0182 L
.55623 .01822 L
.55632 .01824 L
.55641 .01825 L
.5565 .01827 L
.55659 .01828 L
.55668 .0183 L
.55677 .01832 L
.55686 .01833 L
.55695 .01835 L
.55704 .01837 L
.55712 .01838 L
.55721 .0184 L
.5573 .01842 L
.55739 .01843 L
.55748 .01845 L
.55757 .01847 L
.55766 .01849 L
.55775 .0185 L
.55784 .01852 L
.55793 .01854 L
.55802 .01855 L
.55811 .01857 L
.5582 .01859 L
.55829 .0186 L
.55838 .01862 L
.55847 .01864 L
.55856 .01866 L
.55865 .01867 L
.55874 .01869 L
.55883 .01871 L
.55892 .01873 L
.55901 .01874 L
.5591 .01876 L
.55919 .01878 L
.55928 .0188 L
.55937 .01881 L
.55946 .01883 L
.55955 .01885 L
.55964 .01887 L
.55973 .01888 L
.55982 .0189 L
.55991 .01892 L
.55999 .01894 L
.56008 .01896 L
.56017 .01897 L
.56026 .01899 L
.56035 .01901 L
.56044 .01903 L
.56053 .01905 L
Mistroke
.56062 .01906 L
.56071 .01908 L
.5608 .0191 L
.56089 .01912 L
.56098 .01914 L
.56107 .01916 L
.56116 .01917 L
.56125 .01919 L
.56134 .01921 L
.56143 .01923 L
.56152 .01925 L
.56161 .01927 L
.5617 .01928 L
.56179 .0193 L
.56188 .01932 L
.56197 .01934 L
.56206 .01936 L
.56215 .01938 L
.56224 .0194 L
.56233 .01942 L
.56242 .01943 L
.56251 .01945 L
.5626 .01947 L
.56269 .01949 L
.56278 .01951 L
.56287 .01953 L
.56296 .01955 L
.56305 .01957 L
.56314 .01959 L
.56323 .01961 L
.56332 .01962 L
.56341 .01964 L
.5635 .01966 L
.56359 .01968 L
.56368 .0197 L
.56377 .01972 L
.56386 .01974 L
.56395 .01976 L
.56404 .01978 L
.56413 .0198 L
.56422 .01982 L
.56431 .01984 L
.5644 .01986 L
.56449 .01988 L
.56458 .0199 L
.56467 .01992 L
.56476 .01994 L
.56485 .01996 L
.56494 .01998 L
.56503 .02 L
Mistroke
.56512 .02002 L
.56521 .02004 L
.5653 .02006 L
.56539 .02008 L
.56548 .0201 L
.56557 .02012 L
.56566 .02014 L
.56575 .02016 L
.56584 .02018 L
.56593 .0202 L
.56602 .02022 L
.56611 .02024 L
.5662 .02026 L
.56629 .02028 L
.56639 .0203 L
.56648 .02032 L
.56657 .02034 L
.56666 .02036 L
.56675 .02038 L
.56684 .0204 L
.56693 .02042 L
.56702 .02044 L
.56711 .02046 L
.5672 .02049 L
.56729 .02051 L
.56738 .02053 L
.56747 .02055 L
.56756 .02057 L
.56765 .02059 L
.56774 .02061 L
.56783 .02063 L
.56792 .02065 L
.56801 .02067 L
.5681 .0207 L
.56819 .02072 L
.56828 .02074 L
.56837 .02076 L
.56846 .02078 L
.56855 .0208 L
.56864 .02082 L
.56873 .02084 L
.56882 .02087 L
.56891 .02089 L
.569 .02091 L
.56909 .02093 L
.56919 .02095 L
.56928 .02097 L
.56937 .021 L
.56946 .02102 L
.56955 .02104 L
Mistroke
.56964 .02106 L
.56973 .02108 L
.56982 .0211 L
.56991 .02113 L
.57 .02115 L
.57009 .02117 L
.57018 .02119 L
.57027 .02121 L
.57036 .02124 L
.57045 .02126 L
.57054 .02128 L
.57063 .0213 L
.57072 .02132 L
.57081 .02135 L
.5709 .02137 L
.571 .02139 L
.57109 .02141 L
.57118 .02144 L
.57127 .02146 L
.57136 .02148 L
.57145 .0215 L
.57154 .02153 L
.57163 .02155 L
.57172 .02157 L
.57181 .02159 L
.5719 .02162 L
.57199 .02164 L
.57208 .02166 L
.57217 .02168 L
.57226 .02171 L
.57235 .02173 L
.57245 .02175 L
.57254 .02178 L
.57263 .0218 L
.57272 .02182 L
.57281 .02184 L
.5729 .02187 L
.57299 .02189 L
.57308 .02191 L
.57317 .02194 L
.57326 .02196 L
.57335 .02198 L
.57344 .02201 L
.57353 .02203 L
.57362 .02205 L
.57372 .02208 L
.57381 .0221 L
.5739 .02212 L
.57399 .02215 L
.57408 .02217 L
Mistroke
.57417 .02219 L
.57426 .02222 L
.57435 .02224 L
.57444 .02227 L
.57453 .02229 L
.57462 .02231 L
.57471 .02234 L
.57481 .02236 L
.5749 .02238 L
.57499 .02241 L
.57508 .02243 L
.57517 .02246 L
.57526 .02248 L
.57535 .0225 L
.57544 .02253 L
.57553 .02255 L
.57562 .02258 L
.57571 .0226 L
.57581 .02262 L
.5759 .02265 L
.57599 .02267 L
.57608 .0227 L
.57617 .02272 L
.57626 .02275 L
.57635 .02277 L
.57644 .0228 L
.57653 .02282 L
.57662 .02284 L
.57672 .02287 L
.57681 .02289 L
.5769 .02292 L
.57699 .02294 L
.57708 .02297 L
.57717 .02299 L
.57726 .02302 L
.57735 .02304 L
.57744 .02307 L
.57754 .02309 L
.57763 .02312 L
.57772 .02314 L
.57781 .02317 L
.5779 .02319 L
.57799 .02322 L
.57808 .02324 L
.57817 .02327 L
.57826 .02329 L
.57836 .02332 L
.57845 .02334 L
.57854 .02337 L
.57863 .02339 L
Mistroke
.57872 .02342 L
.57881 .02344 L
.5789 .02347 L
.57899 .0235 L
.57909 .02352 L
.57918 .02355 L
.57927 .02357 L
.57936 .0236 L
.57945 .02362 L
.57954 .02365 L
.57963 .02367 L
.57972 .0237 L
.57982 .02373 L
.57991 .02375 L
.58 .02378 L
.58009 .0238 L
.58018 .02383 L
.58027 .02386 L
.58036 .02388 L
.58046 .02391 L
.58055 .02393 L
.58064 .02396 L
.58073 .02399 L
.58082 .02401 L
.58091 .02404 L
.581 .02407 L
.5811 .02409 L
.58119 .02412 L
.58128 .02414 L
.58137 .02417 L
.58146 .0242 L
.58155 .02422 L
.58164 .02425 L
.58174 .02428 L
.58183 .0243 L
.58192 .02433 L
.58201 .02436 L
.5821 .02438 L
.58219 .02441 L
.58228 .02444 L
.58238 .02446 L
.58247 .02449 L
.58256 .02452 L
.58265 .02454 L
.58274 .02457 L
.58283 .0246 L
.58293 .02463 L
.58302 .02465 L
.58311 .02468 L
.5832 .02471 L
Mistroke
.58329 .02473 L
.58338 .02476 L
.58348 .02479 L
.58357 .02482 L
.58366 .02484 L
.58375 .02487 L
.58384 .0249 L
.58393 .02493 L
.58403 .02495 L
.58412 .02498 L
.58421 .02501 L
.5843 .02504 L
.58439 .02506 L
.58448 .02509 L
.58458 .02512 L
.58467 .02515 L
.58476 .02517 L
.58485 .0252 L
.58494 .02523 L
.58503 .02526 L
.58513 .02529 L
.58522 .02531 L
.58531 .02534 L
.5854 .02537 L
.58549 .0254 L
.58559 .02543 L
.58568 .02545 L
.58577 .02548 L
.58586 .02551 L
.58595 .02554 L
.58605 .02557 L
.58614 .0256 L
.58623 .02562 L
.58632 .02565 L
.58641 .02568 L
.58651 .02571 L
.5866 .02574 L
.58669 .02577 L
.58678 .02579 L
.58687 .02582 L
.58696 .02585 L
.58706 .02588 L
.58715 .02591 L
.58724 .02594 L
.58733 .02597 L
.58743 .026 L
.58752 .02602 L
.58761 .02605 L
.5877 .02608 L
.58779 .02611 L
Mistroke
.58789 .02614 L
.58798 .02617 L
.58807 .0262 L
.58816 .02623 L
.58825 .02626 L
.58835 .02629 L
.58844 .02632 L
.58853 .02634 L
.58862 .02637 L
.58871 .0264 L
.58881 .02643 L
.5889 .02646 L
.58899 .02649 L
.58908 .02652 L
.58918 .02655 L
.58927 .02658 L
.58936 .02661 L
.58945 .02664 L
.58954 .02667 L
.58964 .0267 L
.58973 .02673 L
.58982 .02676 L
.58991 .02679 L
.59001 .02682 L
.5901 .02685 L
.59019 .02688 L
.59028 .02691 L
.59038 .02694 L
.59047 .02697 L
.59056 .027 L
.59065 .02703 L
.59074 .02706 L
.59084 .02709 L
.59093 .02712 L
.59102 .02715 L
.59111 .02718 L
.59121 .02721 L
.5913 .02724 L
.59139 .02727 L
.59148 .0273 L
.59158 .02733 L
.59167 .02736 L
.59176 .02739 L
.59185 .02742 L
.59195 .02745 L
.59204 .02748 L
.59213 .02751 L
.59222 .02754 L
.59232 .02758 L
.59241 .02761 L
Mistroke
.5925 .02764 L
.59259 .02767 L
.59269 .0277 L
.59278 .02773 L
.59287 .02776 L
.59296 .02779 L
.59306 .02782 L
.59315 .02785 L
.59324 .02789 L
.59334 .02792 L
.59343 .02795 L
.59352 .02798 L
.59361 .02801 L
.59371 .02804 L
.5938 .02807 L
.59389 .0281 L
.59398 .02814 L
.59408 .02817 L
.59417 .0282 L
.59426 .02823 L
.59436 .02826 L
.59445 .02829 L
.59454 .02832 L
.59463 .02836 L
.59473 .02839 L
.59482 .02842 L
.59491 .02845 L
.595 .02848 L
.5951 .02852 L
.59519 .02855 L
.59528 .02858 L
.59538 .02861 L
.59547 .02864 L
.59556 .02868 L
.59565 .02871 L
.59575 .02874 L
.59584 .02877 L
.59593 .0288 L
.59603 .02884 L
.59612 .02887 L
.59621 .0289 L
.59631 .02893 L
.5964 .02897 L
.59649 .029 L
.59658 .02903 L
.59668 .02906 L
.59677 .0291 L
.59686 .02913 L
.59696 .02916 L
.59705 .02919 L
Mistroke
.59714 .02923 L
.59724 .02926 L
.59733 .02929 L
.59742 .02932 L
.59752 .02936 L
.59761 .02939 L
.5977 .02942 L
.59779 .02946 L
.59789 .02949 L
.59798 .02952 L
.59807 .02955 L
.59817 .02959 L
.59826 .02962 L
.59835 .02965 L
.59845 .02969 L
.59854 .02972 L
.59863 .02975 L
.59873 .02979 L
.59882 .02982 L
.59891 .02985 L
.59901 .02989 L
.5991 .02992 L
.59919 .02995 L
.59929 .02999 L
.59938 .03002 L
.59947 .03005 L
.59957 .03009 L
.59966 .03012 L
.59975 .03016 L
.59985 .03019 L
.59994 .03022 L
.60003 .03026 L
.60013 .03029 L
.60022 .03032 L
.60031 .03036 L
.60041 .03039 L
.6005 .03043 L
.60059 .03046 L
.60069 .03049 L
.60078 .03053 L
.60087 .03056 L
.60097 .0306 L
.60106 .03063 L
.60115 .03067 L
.60125 .0307 L
.60134 .03073 L
.60144 .03077 L
.60153 .0308 L
.60162 .03084 L
.60172 .03087 L
Mistroke
.60181 .03091 L
.6019 .03094 L
.602 .03098 L
.60209 .03101 L
.60218 .03104 L
.60228 .03108 L
.60237 .03111 L
.60247 .03115 L
.60256 .03118 L
.60265 .03122 L
.60275 .03125 L
.60284 .03129 L
.60293 .03132 L
.60303 .03136 L
.60312 .03139 L
.60322 .03143 L
.60331 .03146 L
.6034 .0315 L
.6035 .03153 L
.60359 .03157 L
.60368 .0316 L
.60378 .03164 L
.60387 .03168 L
.60397 .03171 L
.60406 .03175 L
.60415 .03178 L
.60425 .03182 L
.60434 .03185 L
.60444 .03189 L
.60453 .03192 L
.60462 .03196 L
.60472 .032 L
.60481 .03203 L
.60491 .03207 L
.605 .0321 L
.60509 .03214 L
.60519 .03217 L
.60528 .03221 L
.60538 .03225 L
.60547 .03228 L
.60556 .03232 L
.60566 .03235 L
.60575 .03239 L
.60585 .03243 L
.60594 .03246 L
.60603 .0325 L
.60613 .03253 L
.60622 .03257 L
.60632 .03261 L
.60641 .03264 L
Mistroke
.6065 .03268 L
.6066 .03272 L
.60669 .03275 L
.60679 .03279 L
.60688 .03283 L
.60698 .03286 L
.60707 .0329 L
.60716 .03294 L
.60726 .03297 L
.60735 .03301 L
.60745 .03305 L
.60754 .03308 L
.60764 .03312 L
.60773 .03316 L
.60782 .03319 L
.60792 .03323 L
.60801 .03327 L
.60811 .0333 L
.6082 .03334 L
.6083 .03338 L
.60839 .03342 L
.60848 .03345 L
.60858 .03349 L
.60867 .03353 L
.60877 .03356 L
.60886 .0336 L
.60896 .03364 L
.60905 .03368 L
.60915 .03371 L
.60924 .03375 L
.60934 .03379 L
.60943 .03383 L
.60952 .03386 L
.60962 .0339 L
.60971 .03394 L
.60981 .03398 L
.6099 .03401 L
.61 .03405 L
.61009 .03409 L
.61019 .03413 L
.61028 .03417 L
.61038 .0342 L
.61047 .03424 L
.61057 .03428 L
.61066 .03432 L
.61075 .03436 L
.61085 .03439 L
.61094 .03443 L
.61104 .03447 L
.61113 .03451 L
Mistroke
.61123 .03455 L
.61132 .03459 L
.61142 .03462 L
.61151 .03466 L
.61161 .0347 L
.6117 .03474 L
.6118 .03478 L
.61189 .03482 L
.61199 .03485 L
.61208 .03489 L
.61218 .03493 L
.61227 .03497 L
.61237 .03501 L
.61246 .03505 L
.61256 .03509 L
.61265 .03513 L
.61275 .03516 L
.61284 .0352 L
.61294 .03524 L
.61303 .03528 L
.61313 .03532 L
.61322 .03536 L
.61332 .0354 L
.61341 .03544 L
.61351 .03548 L
.6136 .03552 L
.6137 .03556 L
.61379 .0356 L
.61389 .03563 L
.61398 .03567 L
.61408 .03571 L
.61417 .03575 L
.61427 .03579 L
.61436 .03583 L
.61446 .03587 L
.61455 .03591 L
.61465 .03595 L
.61474 .03599 L
.61484 .03603 L
.61493 .03607 L
.61503 .03611 L
.61512 .03615 L
.61522 .03619 L
.61532 .03623 L
.61541 .03627 L
.61551 .03631 L
.6156 .03635 L
.6157 .03639 L
.61579 .03643 L
.61589 .03647 L
Mistroke
.61598 .03651 L
.61608 .03655 L
.61617 .03659 L
.61627 .03663 L
.61636 .03667 L
.61646 .03671 L
.61656 .03675 L
.61665 .03679 L
.61675 .03683 L
.61684 .03687 L
.61694 .03691 L
.61703 .03695 L
.61713 .03699 L
.61722 .03704 L
.61732 .03708 L
.61742 .03712 L
.61751 .03716 L
.61761 .0372 L
.6177 .03724 L
.6178 .03728 L
.61789 .03732 L
.61799 .03736 L
.61808 .0374 L
.61818 .03744 L
.61828 .03749 L
.61837 .03753 L
.61847 .03757 L
.61856 .03761 L
.61866 .03765 L
.61875 .03769 L
.61885 .03773 L
.61895 .03777 L
.61904 .03782 L
.61914 .03786 L
.61923 .0379 L
.61933 .03794 L
.61943 .03798 L
.61952 .03802 L
.61962 .03806 L
.61971 .03811 L
.61981 .03815 L
.61991 .03819 L
.62 .03823 L
.6201 .03827 L
.62019 .03832 L
.62029 .03836 L
.62039 .0384 L
.62048 .03844 L
.62058 .03848 L
.62067 .03853 L
Mistroke
.62077 .03857 L
.62087 .03861 L
.62096 .03865 L
.62106 .03869 L
.62115 .03874 L
.62125 .03878 L
.62135 .03882 L
.62144 .03886 L
.62154 .03891 L
.62163 .03895 L
.62173 .03899 L
.62183 .03903 L
.62192 .03908 L
.62202 .03912 L
.62212 .03916 L
.62221 .0392 L
.62231 .03925 L
.6224 .03929 L
.6225 .03933 L
.6226 .03938 L
.62269 .03942 L
.62279 .03946 L
.62289 .0395 L
.62298 .03955 L
.62308 .03959 L
.62318 .03963 L
.62327 .03968 L
.62337 .03972 L
.62346 .03976 L
.62356 .03981 L
.62366 .03985 L
.62375 .03989 L
.62385 .03994 L
.62395 .03998 L
.62404 .04002 L
.62414 .04007 L
.62424 .04011 L
.62433 .04015 L
.62443 .0402 L
.62453 .04024 L
.62462 .04028 L
.62472 .04033 L
.62482 .04037 L
.62491 .04042 L
.62501 .04046 L
.62511 .0405 L
.6252 .04055 L
.6253 .04059 L
.6254 .04063 L
.62549 .04068 L
Mistroke
.62559 .04072 L
.62569 .04077 L
.62578 .04081 L
.62588 .04086 L
.62598 .0409 L
.62607 .04094 L
.62617 .04099 L
.62627 .04103 L
.62636 .04108 L
.62646 .04112 L
.62656 .04117 L
.62665 .04121 L
.62675 .04125 L
.62685 .0413 L
.62695 .04134 L
.62704 .04139 L
.62714 .04143 L
.62724 .04148 L
.62733 .04152 L
.62743 .04157 L
.62753 .04161 L
.62762 .04166 L
.62772 .0417 L
.62782 .04175 L
.62792 .04179 L
.62801 .04184 L
.62811 .04188 L
.62821 .04193 L
.6283 .04197 L
.6284 .04202 L
.6285 .04206 L
.6286 .04211 L
.62869 .04215 L
.62879 .0422 L
.62889 .04224 L
.62898 .04229 L
.62908 .04234 L
.62918 .04238 L
.62928 .04243 L
.62937 .04247 L
.62947 .04252 L
.62957 .04256 L
.62967 .04261 L
.62976 .04266 L
.62986 .0427 L
.62996 .04275 L
.63006 .04279 L
.63015 .04284 L
.63025 .04288 L
.63035 .04293 L
Mistroke
.63045 .04298 L
.63054 .04302 L
.63064 .04307 L
.63074 .04312 L
.63084 .04316 L
.63093 .04321 L
.63103 .04325 L
.63113 .0433 L
.63123 .04335 L
.63132 .04339 L
.63142 .04344 L
.63152 .04349 L
.63162 .04353 L
.63171 .04358 L
.63181 .04363 L
.63191 .04367 L
.63201 .04372 L
.6321 .04377 L
.6322 .04381 L
.6323 .04386 L
.6324 .04391 L
.6325 .04395 L
.63259 .044 L
.63269 .04405 L
.63279 .04409 L
.63289 .04414 L
.63298 .04419 L
.63308 .04424 L
.63318 .04428 L
.63328 .04433 L
.63338 .04438 L
.63347 .04442 L
.63357 .04447 L
.63367 .04452 L
.63377 .04457 L
.63387 .04461 L
.63396 .04466 L
.63406 .04471 L
.63416 .04476 L
.63426 .0448 L
.63436 .04485 L
.63445 .0449 L
.63455 .04495 L
.63465 .045 L
.63475 .04504 L
.63485 .04509 L
.63494 .04514 L
.63504 .04519 L
.63514 .04524 L
.63524 .04528 L
Mistroke
.63534 .04533 L
.63544 .04538 L
.63553 .04543 L
.63563 .04548 L
.63573 .04552 L
.63583 .04557 L
.63593 .04562 L
.63603 .04567 L
.63612 .04572 L
.63622 .04577 L
.63632 .04581 L
.63642 .04586 L
.63652 .04591 L
.63662 .04596 L
.63671 .04601 L
.63681 .04606 L
.63691 .04611 L
.63701 .04615 L
.63711 .0462 L
.63721 .04625 L
.6373 .0463 L
.6374 .04635 L
.6375 .0464 L
.6376 .04645 L
.6377 .0465 L
.6378 .04655 L
.6379 .0466 L
.638 .04664 L
.63809 .04669 L
.63819 .04674 L
.63829 .04679 L
.63839 .04684 L
.63849 .04689 L
.63859 .04694 L
.63869 .04699 L
.63878 .04704 L
.63888 .04709 L
.63898 .04714 L
.63908 .04719 L
.63918 .04724 L
.63928 .04729 L
.63938 .04734 L
.63948 .04739 L
.63958 .04744 L
.63967 .04749 L
.63977 .04754 L
.63987 .04759 L
.63997 .04764 L
.64007 .04769 L
.64017 .04774 L
Mistroke
.64027 .04779 L
.64037 .04784 L
.64047 .04789 L
.64057 .04794 L
.64066 .04799 L
.64076 .04804 L
.64086 .04809 L
.64096 .04814 L
.64106 .04819 L
.64116 .04824 L
.64126 .04829 L
.64136 .04834 L
.64146 .04839 L
.64156 .04844 L
.64166 .04849 L
.64176 .04854 L
.64185 .0486 L
.64195 .04865 L
.64205 .0487 L
.64215 .04875 L
.64225 .0488 L
.64235 .04885 L
.64245 .0489 L
.64255 .04895 L
.64265 .049 L
.64275 .04905 L
.64285 .04911 L
.64295 .04916 L
.64305 .04921 L
.64315 .04926 L
.64325 .04931 L
.64335 .04936 L
.64344 .04941 L
.64354 .04947 L
.64364 .04952 L
.64374 .04957 L
.64384 .04962 L
.64394 .04967 L
.64404 .04972 L
.64414 .04977 L
.64424 .04983 L
.64434 .04988 L
.64444 .04993 L
.64454 .04998 L
.64464 .05003 L
.64474 .05009 L
.64484 .05014 L
.64494 .05019 L
.64504 .05024 L
.64514 .05029 L
Mistroke
.64524 .05035 L
.64534 .0504 L
.64544 .05045 L
.64554 .0505 L
.64564 .05056 L
.64574 .05061 L
.64584 .05066 L
.64594 .05071 L
.64604 .05077 L
.64614 .05082 L
.64624 .05087 L
.64634 .05092 L
.64644 .05098 L
.64654 .05103 L
.64664 .05108 L
.64674 .05114 L
.64684 .05119 L
.64694 .05124 L
.64704 .05129 L
.64714 .05135 L
.64724 .0514 L
.64734 .05145 L
.64744 .05151 L
.64754 .05156 L
.64764 .05161 L
.64774 .05167 L
.64784 .05172 L
.64794 .05177 L
.64804 .05183 L
.64814 .05188 L
.64824 .05193 L
.64834 .05199 L
.64844 .05204 L
.64854 .05209 L
.64864 .05215 L
.64874 .0522 L
.64884 .05226 L
.64894 .05231 L
.64904 .05236 L
.64915 .05242 L
.64925 .05247 L
.64935 .05252 L
.64945 .05258 L
.64955 .05263 L
.64965 .05269 L
.64975 .05274 L
.64985 .0528 L
.64995 .05285 L
.65005 .0529 L
.65015 .05296 L
Mistroke
.65025 .05301 L
.65035 .05307 L
.65045 .05312 L
.65055 .05318 L
.65065 .05323 L
.65076 .05328 L
.65086 .05334 L
.65096 .05339 L
.65106 .05345 L
.65116 .0535 L
.65126 .05356 L
.65136 .05361 L
.65146 .05367 L
.65156 .05372 L
.65166 .05378 L
.65176 .05383 L
.65186 .05389 L
.65197 .05394 L
.65207 .054 L
.65217 .05405 L
.65227 .05411 L
.65237 .05416 L
.65247 .05422 L
.65257 .05427 L
.65267 .05433 L
.65277 .05439 L
.65288 .05444 L
.65298 .0545 L
.65308 .05455 L
.65318 .05461 L
.65328 .05466 L
.65338 .05472 L
.65348 .05477 L
.65358 .05483 L
.65368 .05489 L
.65379 .05494 L
.65389 .055 L
.65399 .05505 L
.65409 .05511 L
.65419 .05517 L
.65429 .05522 L
.65439 .05528 L
.6545 .05533 L
.6546 .05539 L
.6547 .05545 L
.6548 .0555 L
.6549 .05556 L
.655 .05562 L
.6551 .05567 L
.65521 .05573 L
Mistroke
.65531 .05579 L
.65541 .05584 L
.65551 .0559 L
.65561 .05596 L
.65571 .05601 L
.65582 .05607 L
.65592 .05613 L
.65602 .05618 L
.65612 .05624 L
.65622 .0563 L
.65632 .05635 L
.65643 .05641 L
.65653 .05647 L
.65663 .05652 L
.65673 .05658 L
.65683 .05664 L
.65693 .0567 L
.65704 .05675 L
.65714 .05681 L
.65724 .05687 L
.65734 .05693 L
.65744 .05698 L
.65755 .05704 L
.65765 .0571 L
.65775 .05716 L
.65785 .05721 L
.65795 .05727 L
.65806 .05733 L
.65816 .05739 L
.65826 .05744 L
.65836 .0575 L
.65846 .05756 L
.65857 .05762 L
.65867 .05768 L
.65877 .05773 L
.65887 .05779 L
.65898 .05785 L
.65908 .05791 L
.65918 .05797 L
.65928 .05802 L
.65938 .05808 L
.65949 .05814 L
.65959 .0582 L
.65969 .05826 L
.65979 .05832 L
.6599 .05838 L
.66 .05843 L
.6601 .05849 L
.6602 .05855 L
.66031 .05861 L
Mistroke
.66041 .05867 L
.66051 .05873 L
.66061 .05879 L
.66072 .05884 L
.66082 .0589 L
.66092 .05896 L
.66102 .05902 L
.66113 .05908 L
.66123 .05914 L
.66133 .0592 L
.66143 .05926 L
.66154 .05932 L
.66164 .05938 L
.66174 .05944 L
.66185 .0595 L
.66195 .05956 L
.66205 .05961 L
.66215 .05967 L
.66226 .05973 L
.66236 .05979 L
.66246 .05985 L
.66257 .05991 L
.66267 .05997 L
.66277 .06003 L
.66287 .06009 L
.66298 .06015 L
.66308 .06021 L
.66318 .06027 L
.66329 .06033 L
.66339 .06039 L
.66349 .06045 L
.6636 .06051 L
.6637 .06057 L
.6638 .06063 L
.6639 .06069 L
.66401 .06075 L
.66411 .06081 L
.66421 .06087 L
.66432 .06093 L
.66442 .06099 L
.66452 .06106 L
.66463 .06112 L
.66473 .06118 L
.66483 .06124 L
.66494 .0613 L
.66504 .06136 L
.66514 .06142 L
.66525 .06148 L
.66535 .06154 L
.66545 .0616 L
Mistroke
.66556 .06166 L
.66566 .06172 L
.66576 .06179 L
.66587 .06185 L
.66597 .06191 L
.66607 .06197 L
.66618 .06203 L
.66628 .06209 L
.66639 .06215 L
.66649 .06221 L
.66659 .06228 L
.6667 .06234 L
.6668 .0624 L
.6669 .06246 L
.66701 .06252 L
.66711 .06258 L
.66721 .06265 L
.66732 .06271 L
.66742 .06277 L
.66753 .06283 L
.66763 .06289 L
.66773 .06296 L
.66784 .06302 L
.66794 .06308 L
.66805 .06314 L
.66815 .0632 L
.66825 .06327 L
.66836 .06333 L
.66846 .06339 L
.66857 .06345 L
.66867 .06352 L
.66877 .06358 L
.66888 .06364 L
.66898 .0637 L
.66909 .06377 L
.66919 .06383 L
.66929 .06389 L
.6694 .06395 L
.6695 .06402 L
.66961 .06408 L
.66971 .06414 L
.66981 .06421 L
.66992 .06427 L
.67002 .06433 L
.67013 .06439 L
.67023 .06446 L
.67034 .06452 L
.67044 .06458 L
.67055 .06465 L
.67065 .06471 L
Mistroke
.67075 .06477 L
.67086 .06484 L
.67096 .0649 L
.67107 .06496 L
.67117 .06503 L
.67128 .06509 L
.67138 .06515 L
.67149 .06522 L
.67159 .06528 L
.67169 .06535 L
.6718 .06541 L
.6719 .06547 L
.67201 .06554 L
.67211 .0656 L
.67222 .06567 L
.67232 .06573 L
.67243 .06579 L
.67253 .06586 L
.67264 .06592 L
.67274 .06599 L
.67285 .06605 L
.67295 .06611 L
.67306 .06618 L
.67316 .06624 L
.67327 .06631 L
.67337 .06637 L
.67348 .06644 L
.67358 .0665 L
.67369 .06657 L
.67379 .06663 L
.6739 .0667 L
.674 .06676 L
.67411 .06683 L
.67421 .06689 L
.67432 .06695 L
.67442 .06702 L
.67453 .06708 L
.67463 .06715 L
.67474 .06722 L
.67484 .06728 L
.67495 .06735 L
.67505 .06741 L
.67516 .06748 L
.67526 .06754 L
.67537 .06761 L
.67547 .06767 L
.67558 .06774 L
.67569 .0678 L
.67579 .06787 L
.6759 .06793 L
Mistroke
.676 .068 L
.67611 .06807 L
.67621 .06813 L
.67632 .0682 L
.67642 .06826 L
.67653 .06833 L
.67663 .0684 L
.67674 .06846 L
.67685 .06853 L
.67695 .06859 L
.67706 .06866 L
.67716 .06873 L
.67727 .06879 L
.67737 .06886 L
.67748 .06893 L
.67759 .06899 L
.67769 .06906 L
.6778 .06912 L
.6779 .06919 L
.67801 .06926 L
.67812 .06932 L
.67822 .06939 L
.67833 .06946 L
.67843 .06953 L
.67854 .06959 L
.67865 .06966 L
.67875 .06973 L
.67886 .06979 L
.67896 .06986 L
.67907 .06993 L
.67918 .06999 L
.67928 .07006 L
.67939 .07013 L
.67949 .0702 L
.6796 .07026 L
.67971 .07033 L
.67981 .0704 L
.67992 .07047 L
.68003 .07053 L
.68013 .0706 L
.68024 .07067 L
.68034 .07074 L
.68045 .0708 L
.68056 .07087 L
.68066 .07094 L
.68077 .07101 L
.68088 .07108 L
.68098 .07114 L
.68109 .07121 L
.6812 .07128 L
Mistroke
.6813 .07135 L
.68141 .07142 L
.68152 .07148 L
.68162 .07155 L
.68173 .07162 L
.68183 .07169 L
.68194 .07176 L
.68205 .07183 L
.68216 .07189 L
.68226 .07196 L
.68237 .07203 L
.68248 .0721 L
.68258 .07217 L
.68269 .07224 L
.6828 .07231 L
.6829 .07238 L
.68301 .07244 L
.68312 .07251 L
.68322 .07258 L
.68333 .07265 L
.68344 .07272 L
.68354 .07279 L
.68365 .07286 L
.68376 .07293 L
.68387 .073 L
.68397 .07307 L
.68408 .07314 L
.68419 .07321 L
.68429 .07328 L
.6844 .07335 L
.68451 .07341 L
.68462 .07348 L
.68472 .07355 L
.68483 .07362 L
.68494 .07369 L
.68504 .07376 L
.68515 .07383 L
.68526 .0739 L
.68537 .07397 L
.68547 .07404 L
.68558 .07411 L
.68569 .07418 L
.6858 .07425 L
.6859 .07432 L
.68601 .07439 L
.68612 .07447 L
.68623 .07454 L
.68633 .07461 L
.68644 .07468 L
.68655 .07475 L
Mistroke
.68666 .07482 L
.68676 .07489 L
.68687 .07496 L
.68698 .07503 L
.68709 .0751 L
.6872 .07517 L
.6873 .07524 L
.68741 .07531 L
.68752 .07538 L
.68763 .07546 L
.68773 .07553 L
.68784 .0756 L
.68795 .07567 L
.68806 .07574 L
.68817 .07581 L
.68827 .07588 L
.68838 .07595 L
.68849 .07603 L
.6886 .0761 L
.68871 .07617 L
.68881 .07624 L
.68892 .07631 L
.68903 .07638 L
.68914 .07646 L
.68925 .07653 L
.68936 .0766 L
.68946 .07667 L
.68957 .07674 L
.68968 .07682 L
.68979 .07689 L
.6899 .07696 L
.69 .07703 L
.69011 .0771 L
.69022 .07718 L
.69033 .07725 L
.69044 .07732 L
.69055 .07739 L
.69066 .07747 L
.69076 .07754 L
.69087 .07761 L
.69098 .07768 L
.69109 .07776 L
.6912 .07783 L
.69131 .0779 L
.69142 .07798 L
.69152 .07805 L
.69163 .07812 L
.69174 .07819 L
.69185 .07827 L
.69196 .07834 L
Mistroke
.69207 .07841 L
.69218 .07849 L
.69229 .07856 L
.69239 .07863 L
.6925 .07871 L
.69261 .07878 L
.69272 .07885 L
.69283 .07893 L
.69294 .079 L
.69305 .07907 L
.69316 .07915 L
.69327 .07922 L
.69338 .0793 L
.69348 .07937 L
.69359 .07944 L
.6937 .07952 L
.69381 .07959 L
.69392 .07967 L
.69403 .07974 L
.69414 .07981 L
.69425 .07989 L
.69436 .07996 L
.69447 .08004 L
.69458 .08011 L
.69469 .08019 L
.6948 .08026 L
.6949 .08033 L
.69501 .08041 L
.69512 .08048 L
.69523 .08056 L
.69534 .08063 L
.69545 .08071 L
.69556 .08078 L
.69567 .08086 L
.69578 .08093 L
.69589 .08101 L
.696 .08108 L
.69611 .08116 L
.69622 .08123 L
.69633 .08131 L
.69644 .08138 L
.69655 .08146 L
.69666 .08153 L
.69677 .08161 L
.69688 .08169 L
.69699 .08176 L
.6971 .08184 L
.69721 .08191 L
.69732 .08199 L
.69743 .08206 L
Mistroke
.69754 .08214 L
.69765 .08222 L
.69776 .08229 L
.69787 .08237 L
.69798 .08244 L
.69809 .08252 L
.6982 .0826 L
.69831 .08267 L
.69842 .08275 L
.69853 .08282 L
.69864 .0829 L
.69875 .08298 L
.69886 .08305 L
.69897 .08313 L
.69908 .08321 L
.69919 .08328 L
.6993 .08336 L
.69941 .08344 L
.69952 .08351 L
.69963 .08359 L
.69974 .08367 L
.69985 .08374 L
.69996 .08382 L
.70007 .0839 L
.70018 .08397 L
.7003 .08405 L
.70041 .08413 L
.70052 .08421 L
.70063 .08428 L
.70074 .08436 L
.70085 .08444 L
.70096 .08452 L
.70107 .08459 L
.70118 .08467 L
.70129 .08475 L
.7014 .08483 L
.70151 .0849 L
.70162 .08498 L
.70173 .08506 L
.70185 .08514 L
.70196 .08521 L
.70207 .08529 L
.70218 .08537 L
.70229 .08545 L
.7024 .08553 L
.70251 .08561 L
.70262 .08568 L
.70273 .08576 L
.70285 .08584 L
.70296 .08592 L
Mistroke
.70307 .086 L
.70318 .08608 L
.70329 .08615 L
.7034 .08623 L
.70351 .08631 L
.70362 .08639 L
.70374 .08647 L
.70385 .08655 L
.70396 .08663 L
.70407 .08671 L
.70418 .08678 L
.70429 .08686 L
.7044 .08694 L
.70452 .08702 L
.70463 .0871 L
.70474 .08718 L
.70485 .08726 L
.70496 .08734 L
.70507 .08742 L
.70519 .0875 L
.7053 .08758 L
.70541 .08766 L
.70552 .08774 L
.70563 .08782 L
.70574 .0879 L
.70586 .08798 L
.70597 .08806 L
.70608 .08814 L
.70619 .08822 L
.7063 .0883 L
.70642 .08838 L
.70653 .08846 L
.70664 .08854 L
.70675 .08862 L
.70686 .0887 L
.70698 .08878 L
.70709 .08886 L
.7072 .08894 L
.70731 .08902 L
.70742 .0891 L
.70754 .08918 L
.70765 .08926 L
.70776 .08934 L
.70787 .08942 L
.70799 .0895 L
.7081 .08959 L
.70821 .08967 L
.70832 .08975 L
.70844 .08983 L
.70855 .08991 L
Mistroke
.70866 .08999 L
.70877 .09007 L
.70889 .09015 L
.709 .09024 L
.70911 .09032 L
.70922 .0904 L
.70934 .09048 L
.70945 .09056 L
.70956 .09064 L
.70967 .09072 L
.70979 .09081 L
.7099 .09089 L
.71001 .09097 L
.71013 .09105 L
.71024 .09113 L
.71035 .09122 L
.71046 .0913 L
.71058 .09138 L
.71069 .09146 L
.7108 .09155 L
.71092 .09163 L
.71103 .09171 L
.71114 .09179 L
.71126 .09187 L
.71137 .09196 L
.71148 .09204 L
.71159 .09212 L
.71171 .09221 L
.71182 .09229 L
.71193 .09237 L
.71205 .09245 L
.71216 .09254 L
.71227 .09262 L
.71239 .0927 L
.7125 .09279 L
.71261 .09287 L
.71273 .09295 L
.71284 .09304 L
.71296 .09312 L
.71307 .0932 L
.71318 .09329 L
.7133 .09337 L
.71341 .09345 L
.71352 .09354 L
.71364 .09362 L
.71375 .0937 L
.71386 .09379 L
.71398 .09387 L
.71409 .09396 L
.71421 .09404 L
Mistroke
.71432 .09412 L
.71443 .09421 L
.71455 .09429 L
.71466 .09438 L
.71477 .09446 L
.71489 .09455 L
.715 .09463 L
.71512 .09471 L
.71523 .0948 L
.71534 .09488 L
.71546 .09497 L
.71557 .09505 L
.71569 .09514 L
.7158 .09522 L
.71592 .09531 L
.71603 .09539 L
.71614 .09548 L
.71626 .09556 L
.71637 .09565 L
.71649 .09573 L
.7166 .09582 L
.71672 .0959 L
.71683 .09599 L
.71694 .09607 L
.71706 .09616 L
.71717 .09624 L
.71729 .09633 L
.7174 .09642 L
.71752 .0965 L
.71763 .09659 L
.71775 .09667 L
.71786 .09676 L
.71798 .09685 L
.71809 .09693 L
.7182 .09702 L
.71832 .0971 L
.71843 .09719 L
.71855 .09728 L
.71866 .09736 L
.71878 .09745 L
.71889 .09753 L
.71901 .09762 L
.71912 .09771 L
.71924 .09779 L
.71935 .09788 L
.71947 .09797 L
.71958 .09805 L
.7197 .09814 L
.71981 .09823 L
.71993 .09831 L
Mistroke
.72004 .0984 L
.72016 .09849 L
.72027 .09858 L
.72039 .09866 L
.72051 .09875 L
.72062 .09884 L
.72074 .09892 L
.72085 .09901 L
.72097 .0991 L
.72108 .09919 L
.7212 .09927 L
.72131 .09936 L
.72143 .09945 L
.72154 .09954 L
.72166 .09963 L
.72178 .09971 L
.72189 .0998 L
.72201 .09989 L
.72212 .09998 L
.72224 .10007 L
.72235 .10015 L
.72247 .10024 L
.72259 .10033 L
.7227 .10042 L
.72282 .10051 L
.72293 .1006 L
.72305 .10068 L
.72316 .10077 L
.72328 .10086 L
.7234 .10095 L
.72351 .10104 L
.72363 .10113 L
.72374 .10122 L
.72386 .10131 L
.72398 .10139 L
.72409 .10148 L
.72421 .10157 L
.72433 .10166 L
.72444 .10175 L
.72456 .10184 L
.72467 .10193 L
.72479 .10202 L
.72491 .10211 L
.72502 .1022 L
.72514 .10229 L
.72526 .10238 L
.72537 .10247 L
.72549 .10256 L
.72561 .10265 L
.72572 .10274 L
Mistroke
.72584 .10283 L
.72596 .10292 L
.72607 .10301 L
.72619 .1031 L
.72631 .10319 L
.72642 .10328 L
.72654 .10337 L
.72666 .10346 L
.72677 .10355 L
.72689 .10364 L
.72701 .10373 L
.72712 .10382 L
.72724 .10391 L
.72736 .104 L
.72747 .10409 L
.72759 .10418 L
.72771 .10427 L
.72783 .10436 L
.72794 .10446 L
.72806 .10455 L
.72818 .10464 L
.72829 .10473 L
.72841 .10482 L
.72853 .10491 L
.72865 .105 L
.72876 .1051 L
.72888 .10519 L
.729 .10528 L
.72912 .10537 L
.72923 .10546 L
.72935 .10555 L
.72947 .10565 L
.72959 .10574 L
.7297 .10583 L
.72982 .10592 L
.72994 .10601 L
.73006 .10611 L
.73017 .1062 L
.73029 .10629 L
.73041 .10638 L
.73053 .10647 L
.73064 .10657 L
.73076 .10666 L
.73088 .10675 L
.731 .10685 L
.73112 .10694 L
.73123 .10703 L
.73135 .10712 L
.73147 .10722 L
.73159 .10731 L
Mistroke
.73171 .1074 L
.73182 .1075 L
.73194 .10759 L
.73206 .10768 L
.73218 .10778 L
.7323 .10787 L
.73241 .10796 L
.73253 .10806 L
.73265 .10815 L
.73277 .10824 L
.73289 .10834 L
.73301 .10843 L
.73312 .10852 L
.73324 .10862 L
.73336 .10871 L
.73348 .10881 L
.7336 .1089 L
.73372 .10899 L
.73384 .10909 L
.73395 .10918 L
.73407 .10928 L
.73419 .10937 L
.73431 .10947 L
.73443 .10956 L
.73455 .10965 L
.73467 .10975 L
.73479 .10984 L
.7349 .10994 L
.73502 .11003 L
.73514 .11013 L
.73526 .11022 L
.73538 .11032 L
.7355 .11041 L
.73562 .11051 L
.73574 .1106 L
.73586 .1107 L
.73598 .11079 L
.73609 .11089 L
.73621 .11098 L
.73633 .11108 L
.73645 .11118 L
.73657 .11127 L
.73669 .11137 L
.73681 .11146 L
.73693 .11156 L
.73705 .11165 L
.73717 .11175 L
.73729 .11185 L
.73741 .11194 L
.73753 .11204 L
Mistroke
.73765 .11213 L
.73777 .11223 L
.73789 .11233 L
.73801 .11242 L
.73813 .11252 L
.73825 .11262 L
.73836 .11271 L
.73848 .11281 L
.7386 .11291 L
.73872 .113 L
.73884 .1131 L
.73896 .1132 L
.73908 .11329 L
.7392 .11339 L
.73932 .11349 L
.73944 .11359 L
.73956 .11368 L
.73968 .11378 L
.7398 .11388 L
.73992 .11397 L
.74004 .11407 L
.74016 .11417 L
.74029 .11427 L
.74041 .11437 L
.74053 .11446 L
.74065 .11456 L
.74077 .11466 L
.74089 .11476 L
.74101 .11485 L
.74113 .11495 L
.74125 .11505 L
.74137 .11515 L
.74149 .11525 L
.74161 .11535 L
.74173 .11544 L
.74185 .11554 L
.74197 .11564 L
.74209 .11574 L
.74221 .11584 L
.74233 .11594 L
.74246 .11604 L
.74258 .11613 L
.7427 .11623 L
.74282 .11633 L
.74294 .11643 L
.74306 .11653 L
.74318 .11663 L
.7433 .11673 L
.74342 .11683 L
.74354 .11693 L
Mistroke
.74366 .11703 L
.74379 .11713 L
.74391 .11723 L
.74403 .11733 L
.74415 .11743 L
.74427 .11753 L
.74439 .11763 L
.74451 .11773 L
.74464 .11783 L
.74476 .11793 L
.74488 .11803 L
.745 .11813 L
.74512 .11823 L
.74524 .11833 L
.74536 .11843 L
.74549 .11853 L
.74561 .11863 L
.74573 .11873 L
.74585 .11883 L
.74597 .11893 L
.74609 .11903 L
.74622 .11913 L
.74634 .11923 L
.74646 .11933 L
.74658 .11943 L
.7467 .11954 L
.74683 .11964 L
.74695 .11974 L
.74707 .11984 L
.74719 .11994 L
.74731 .12004 L
.74744 .12014 L
.74756 .12024 L
.74768 .12035 L
.7478 .12045 L
.74792 .12055 L
.74805 .12065 L
.74817 .12075 L
.74829 .12086 L
.74841 .12096 L
.74854 .12106 L
.74866 .12116 L
.74878 .12126 L
.7489 .12137 L
.74903 .12147 L
.74915 .12157 L
.74927 .12167 L
.74939 .12178 L
.74952 .12188 L
.74964 .12198 L
Mistroke
.74976 .12208 L
.74989 .12219 L
.75001 .12229 L
.75013 .12239 L
.75025 .1225 L
.75038 .1226 L
.7505 .1227 L
.75062 .12281 L
.75075 .12291 L
.75087 .12301 L
.75099 .12312 L
.75111 .12322 L
.75124 .12332 L
.75136 .12343 L
.75148 .12353 L
.75161 .12364 L
.75173 .12374 L
.75185 .12384 L
.75198 .12395 L
.7521 .12405 L
.75222 .12416 L
.75235 .12426 L
.75247 .12436 L
.75259 .12447 L
.75272 .12457 L
.75284 .12468 L
.75297 .12478 L
.75309 .12489 L
.75321 .12499 L
.75334 .1251 L
.75346 .1252 L
.75358 .12531 L
.75371 .12541 L
.75383 .12552 L
.75396 .12562 L
.75408 .12573 L
.7542 .12583 L
.75433 .12594 L
.75445 .12604 L
.75458 .12615 L
.7547 .12625 L
.75482 .12636 L
.75495 .12646 L
.75507 .12657 L
.7552 .12668 L
.75532 .12678 L
.75544 .12689 L
.75557 .12699 L
.75569 .1271 L
.75582 .12721 L
Mistroke
.75594 .12731 L
.75607 .12742 L
.75619 .12753 L
.75632 .12763 L
.75644 .12774 L
.75656 .12784 L
.75669 .12795 L
.75681 .12806 L
.75694 .12817 L
.75706 .12827 L
.75719 .12838 L
.75731 .12849 L
.75744 .12859 L
.75756 .1287 L
.75769 .12881 L
.75781 .12891 L
.75794 .12902 L
.75806 .12913 L
.75819 .12924 L
.75831 .12934 L
.75844 .12945 L
.75856 .12956 L
.75869 .12967 L
.75881 .12978 L
.75894 .12988 L
.75906 .12999 L
.75919 .1301 L
.75931 .13021 L
.75944 .13032 L
.75957 .13042 L
.75969 .13053 L
.75982 .13064 L
.75994 .13075 L
.76007 .13086 L
.76019 .13097 L
.76032 .13108 L
.76044 .13118 L
.76057 .13129 L
.7607 .1314 L
.76082 .13151 L
.76095 .13162 L
.76107 .13173 L
.7612 .13184 L
.76132 .13195 L
.76145 .13206 L
.76158 .13217 L
.7617 .13228 L
.76183 .13239 L
.76195 .1325 L
.76208 .13261 L
Mistroke
.76221 .13272 L
.76233 .13283 L
.76246 .13294 L
.76259 .13305 L
.76271 .13316 L
.76284 .13327 L
.76296 .13338 L
.76309 .13349 L
.76322 .1336 L
.76334 .13371 L
.76347 .13382 L
.7636 .13393 L
.76372 .13404 L
.76385 .13415 L
.76398 .13426 L
.7641 .13437 L
.76423 .13448 L
.76436 .13459 L
.76448 .1347 L
.76461 .13482 L
.76474 .13493 L
.76486 .13504 L
.76499 .13515 L
.76512 .13526 L
.76525 .13537 L
.76537 .13548 L
.7655 .1356 L
.76563 .13571 L
.76575 .13582 L
.76588 .13593 L
.76601 .13604 L
.76614 .13616 L
.76626 .13627 L
.76639 .13638 L
.76652 .13649 L
.76664 .1366 L
.76677 .13672 L
.7669 .13683 L
.76703 .13694 L
.76715 .13705 L
.76728 .13717 L
.76741 .13728 L
.76754 .13739 L
.76766 .13751 L
.76779 .13762 L
.76792 .13773 L
.76805 .13784 L
.76818 .13796 L
.7683 .13807 L
.76843 .13818 L
Mistroke
.76856 .1383 L
.76869 .13841 L
.76882 .13853 L
.76894 .13864 L
.76907 .13875 L
.7692 .13887 L
.76933 .13898 L
.76946 .13909 L
.76958 .13921 L
.76971 .13932 L
.76984 .13944 L
.76997 .13955 L
.7701 .13967 L
.77023 .13978 L
.77035 .13989 L
.77048 .14001 L
.77061 .14012 L
.77074 .14024 L
.77087 .14035 L
.771 .14047 L
.77113 .14058 L
.77125 .1407 L
.77138 .14081 L
.77151 .14093 L
.77164 .14104 L
.77177 .14116 L
.7719 .14127 L
.77203 .14139 L
.77216 .14151 L
.77229 .14162 L
.77241 .14174 L
.77254 .14185 L
.77267 .14197 L
.7728 .14208 L
.77293 .1422 L
.77306 .14232 L
.77319 .14243 L
.77332 .14255 L
.77345 .14266 L
.77358 .14278 L
.77371 .1429 L
.77384 .14301 L
.77397 .14313 L
.7741 .14325 L
.77422 .14336 L
.77435 .14348 L
.77448 .1436 L
.77461 .14372 L
.77474 .14383 L
.77487 .14395 L
Mistroke
.775 .14407 L
.77513 .14418 L
.77526 .1443 L
.77539 .14442 L
.77552 .14454 L
.77565 .14465 L
.77578 .14477 L
.77591 .14489 L
.77604 .14501 L
.77617 .14512 L
.7763 .14524 L
.77643 .14536 L
.77656 .14548 L
.77669 .1456 L
.77682 .14572 L
.77695 .14583 L
.77708 .14595 L
.77721 .14607 L
.77735 .14619 L
.77748 .14631 L
.77761 .14643 L
.77774 .14655 L
.77787 .14666 L
.778 .14678 L
.77813 .1469 L
.77826 .14702 L
.77839 .14714 L
.77852 .14726 L
.77865 .14738 L
.77878 .1475 L
.77891 .14762 L
.77904 .14774 L
.77918 .14786 L
.77931 .14798 L
.77944 .1481 L
.77957 .14822 L
.7797 .14834 L
.77983 .14846 L
.77996 .14858 L
.78009 .1487 L
.78022 .14882 L
.78036 .14894 L
.78049 .14906 L
.78062 .14918 L
.78075 .1493 L
.78088 .14942 L
.78101 .14954 L
.78115 .14966 L
.78128 .14978 L
.78141 .14991 L
Mistroke
.78154 .15003 L
.78167 .15015 L
.7818 .15027 L
.78194 .15039 L
.78207 .15051 L
.7822 .15063 L
.78233 .15075 L
.78246 .15088 L
.78259 .151 L
.78273 .15112 L
.78286 .15124 L
.78299 .15136 L
.78312 .15149 L
.78326 .15161 L
.78339 .15173 L
.78352 .15185 L
.78365 .15197 L
.78378 .1521 L
.78392 .15222 L
.78405 .15234 L
.78418 .15247 L
.78431 .15259 L
.78445 .15271 L
.78458 .15283 L
.78471 .15296 L
.78484 .15308 L
.78498 .1532 L
.78511 .15333 L
.78524 .15345 L
.78538 .15357 L
.78551 .1537 L
.78564 .15382 L
.78577 .15394 L
.78591 .15407 L
.78604 .15419 L
.78617 .15432 L
.78631 .15444 L
.78644 .15456 L
.78657 .15469 L
.78671 .15481 L
.78684 .15494 L
.78697 .15506 L
.78711 .15518 L
.78724 .15531 L
.78737 .15543 L
.78751 .15556 L
.78764 .15568 L
.78777 .15581 L
.78791 .15593 L
.78804 .15606 L
Mistroke
.78817 .15618 L
.78831 .15631 L
.78844 .15643 L
.78858 .15656 L
.78871 .15668 L
.78884 .15681 L
.78898 .15694 L
.78911 .15706 L
.78924 .15719 L
.78938 .15731 L
.78951 .15744 L
.78965 .15756 L
.78978 .15769 L
.78991 .15782 L
.79005 .15794 L
.79018 .15807 L
.79032 .1582 L
.79045 .15832 L
.79059 .15845 L
.79072 .15858 L
.79086 .1587 L
.79099 .15883 L
.79112 .15896 L
.79126 .15908 L
.79139 .15921 L
.79153 .15934 L
.79166 .15946 L
.7918 .15959 L
.79193 .15972 L
.79207 .15985 L
.7922 .15997 L
.79234 .1601 L
.79247 .16023 L
.79261 .16036 L
.79274 .16049 L
.79288 .16061 L
.79301 .16074 L
.79315 .16087 L
.79328 .161 L
.79342 .16113 L
.79355 .16125 L
.79369 .16138 L
.79382 .16151 L
.79396 .16164 L
.79409 .16177 L
.79423 .1619 L
.79437 .16203 L
.7945 .16216 L
.79464 .16228 L
.79477 .16241 L
Mistroke
.79491 .16254 L
.79504 .16267 L
.79518 .1628 L
.79532 .16293 L
.79545 .16306 L
.79559 .16319 L
.79572 .16332 L
.79586 .16345 L
.79599 .16358 L
.79613 .16371 L
.79627 .16384 L
.7964 .16397 L
.79654 .1641 L
.79668 .16423 L
.79681 .16436 L
.79695 .16449 L
.79708 .16462 L
.79722 .16475 L
.79736 .16488 L
.79749 .16501 L
.79763 .16514 L
.79777 .16528 L
.7979 .16541 L
.79804 .16554 L
.79818 .16567 L
.79831 .1658 L
.79845 .16593 L
.79859 .16606 L
.79872 .1662 L
.79886 .16633 L
.799 .16646 L
.79913 .16659 L
.79927 .16672 L
.79941 .16685 L
.79955 .16699 L
.79968 .16712 L
.79982 .16725 L
.79996 .16738 L
.80009 .16752 L
.80023 .16765 L
.80037 .16778 L
.80051 .16791 L
.80064 .16805 L
.80078 .16818 L
.80092 .16831 L
.80106 .16845 L
.80119 .16858 L
.80133 .16871 L
.80147 .16884 L
.80161 .16898 L
Mistroke
.80175 .16911 L
.80188 .16925 L
.80202 .16938 L
.80216 .16951 L
.8023 .16965 L
.80243 .16978 L
.80257 .16991 L
.80271 .17005 L
.80285 .17018 L
.80299 .17032 L
.80313 .17045 L
.80326 .17059 L
.8034 .17072 L
.80354 .17085 L
.80368 .17099 L
.80382 .17112 L
.80396 .17126 L
.80409 .17139 L
.80423 .17153 L
.80437 .17166 L
.80451 .1718 L
.80465 .17193 L
.80479 .17207 L
.80493 .17221 L
.80506 .17234 L
.8052 .17248 L
.80534 .17261 L
.80548 .17275 L
.80562 .17288 L
.80576 .17302 L
.8059 .17316 L
.80604 .17329 L
.80618 .17343 L
.80632 .17356 L
.80646 .1737 L
.80659 .17384 L
.80673 .17397 L
.80687 .17411 L
.80701 .17425 L
.80715 .17438 L
.80729 .17452 L
.80743 .17466 L
.80757 .1748 L
.80771 .17493 L
.80785 .17507 L
.80799 .17521 L
.80813 .17534 L
.80827 .17548 L
.80841 .17562 L
.80855 .17576 L
Mistroke
.80869 .1759 L
.80883 .17603 L
.80897 .17617 L
.80911 .17631 L
.80925 .17645 L
.80939 .17659 L
.80953 .17672 L
.80967 .17686 L
.80981 .177 L
.80995 .17714 L
.81009 .17728 L
.81023 .17742 L
.81037 .17756 L
.81051 .1777 L
.81065 .17783 L
.81079 .17797 L
.81093 .17811 L
.81107 .17825 L
.81122 .17839 L
.81136 .17853 L
.8115 .17867 L
.81164 .17881 L
.81178 .17895 L
.81192 .17909 L
.81206 .17923 L
.8122 .17937 L
.81234 .17951 L
.81248 .17965 L
.81263 .17979 L
.81277 .17993 L
.81291 .18007 L
.81305 .18021 L
.81319 .18035 L
.81333 .18049 L
.81347 .18064 L
.81362 .18078 L
.81376 .18092 L
.8139 .18106 L
.81404 .1812 L
.81418 .18134 L
.81432 .18148 L
.81447 .18162 L
.81461 .18177 L
.81475 .18191 L
.81489 .18205 L
.81503 .18219 L
.81517 .18233 L
.81532 .18247 L
.81546 .18262 L
.8156 .18276 L
Mistroke
.81574 .1829 L
.81589 .18304 L
.81603 .18319 L
.81617 .18333 L
.81631 .18347 L
.81645 .18361 L
.8166 .18376 L
.81674 .1839 L
.81688 .18404 L
.81702 .18419 L
.81717 .18433 L
.81731 .18447 L
.81745 .18462 L
.8176 .18476 L
.81774 .1849 L
.81788 .18505 L
.81802 .18519 L
.81817 .18534 L
.81831 .18548 L
.81845 .18562 L
.8186 .18577 L
.81874 .18591 L
.81888 .18606 L
.81903 .1862 L
.81917 .18635 L
.81931 .18649 L
.81946 .18663 L
.8196 .18678 L
.81974 .18692 L
.81989 .18707 L
.82003 .18721 L
.82017 .18736 L
.82032 .1875 L
.82046 .18765 L
.8206 .1878 L
.82075 .18794 L
.82089 .18809 L
.82104 .18823 L
.82118 .18838 L
.82132 .18852 L
.82147 .18867 L
.82161 .18882 L
.82176 .18896 L
.8219 .18911 L
.82204 .18926 L
.82219 .1894 L
.82233 .18955 L
.82248 .1897 L
.82262 .18984 L
.82277 .18999 L
Mistroke
.82291 .19014 L
.82306 .19028 L
.8232 .19043 L
.82335 .19058 L
.82349 .19072 L
.82363 .19087 L
.82378 .19102 L
.82392 .19117 L
.82407 .19132 L
.82421 .19146 L
.82436 .19161 L
.8245 .19176 L
.82465 .19191 L
.82479 .19206 L
.82494 .1922 L
.82508 .19235 L
.82523 .1925 L
.82537 .19265 L
.82552 .1928 L
.82567 .19295 L
.82581 .1931 L
.82596 .19324 L
.8261 .19339 L
.82625 .19354 L
.82639 .19369 L
.82654 .19384 L
.82668 .19399 L
.82683 .19414 L
.82698 .19429 L
.82712 .19444 L
.82727 .19459 L
.82741 .19474 L
.82756 .19489 L
.82771 .19504 L
.82785 .19519 L
.828 .19534 L
.82814 .19549 L
.82829 .19564 L
.82844 .19579 L
.82858 .19594 L
.82873 .19609 L
.82888 .19624 L
.82902 .19639 L
.82917 .19655 L
.82932 .1967 L
.82946 .19685 L
.82961 .197 L
.82976 .19715 L
.8299 .1973 L
.83005 .19745 L
Mistroke
.8302 .19761 L
.83034 .19776 L
.83049 .19791 L
.83064 .19806 L
.83078 .19821 L
.83093 .19837 L
.83108 .19852 L
.83123 .19867 L
.83137 .19882 L
.83152 .19898 L
.83167 .19913 L
.83182 .19928 L
.83196 .19943 L
.83211 .19959 L
.83226 .19974 L
.83241 .19989 L
.83255 .20005 L
.8327 .2002 L
.83285 .20035 L
.833 .20051 L
.83314 .20066 L
.83329 .20082 L
.83344 .20097 L
.83359 .20112 L
.83374 .20128 L
.83388 .20143 L
.83403 .20159 L
.83418 .20174 L
.83433 .20189 L
.83448 .20205 L
.83463 .2022 L
.83477 .20236 L
.83492 .20251 L
.83507 .20267 L
.83522 .20282 L
.83537 .20298 L
.83552 .20313 L
.83567 .20329 L
.83581 .20345 L
.83596 .2036 L
.83611 .20376 L
.83626 .20391 L
.83641 .20407 L
.83656 .20422 L
.83671 .20438 L
.83686 .20454 L
.83701 .20469 L
.83716 .20485 L
.83731 .20501 L
.83745 .20516 L
Mistroke
.8376 .20532 L
.83775 .20548 L
.8379 .20563 L
.83805 .20579 L
.8382 .20595 L
.83835 .2061 L
.8385 .20626 L
.83865 .20642 L
.8388 .20658 L
.83895 .20673 L
.8391 .20689 L
.83925 .20705 L
.8394 .20721 L
.83955 .20736 L
.8397 .20752 L
.83985 .20768 L
.84 .20784 L
.84015 .208 L
.8403 .20816 L
.84045 .20831 L
.8406 .20847 L
.84075 .20863 L
.8409 .20879 L
.84105 .20895 L
.8412 .20911 L
.84135 .20927 L
.8415 .20943 L
.84166 .20959 L
.84181 .20975 L
.84196 .20991 L
.84211 .21007 L
.84226 .21023 L
.84241 .21039 L
.84256 .21055 L
.84271 .21071 L
.84286 .21087 L
.84301 .21103 L
.84317 .21119 L
.84332 .21135 L
.84347 .21151 L
.84362 .21167 L
.84377 .21183 L
.84392 .21199 L
.84407 .21215 L
.84423 .21231 L
.84438 .21247 L
.84453 .21263 L
.84468 .2128 L
.84483 .21296 L
.84498 .21312 L
Mistroke
.84514 .21328 L
.84529 .21344 L
.84544 .21361 L
.84559 .21377 L
.84574 .21393 L
.8459 .21409 L
.84605 .21425 L
.8462 .21442 L
.84635 .21458 L
.84651 .21474 L
.84666 .2149 L
.84681 .21507 L
.84696 .21523 L
.84712 .21539 L
.84727 .21556 L
.84742 .21572 L
.84757 .21588 L
.84773 .21605 L
.84788 .21621 L
.84803 .21637 L
.84818 .21654 L
.84834 .2167 L
.84849 .21687 L
.84864 .21703 L
.8488 .21719 L
.84895 .21736 L
.8491 .21752 L
.84926 .21769 L
.84941 .21785 L
.84956 .21802 L
.84972 .21818 L
.84987 .21835 L
.85002 .21851 L
.85018 .21868 L
.85033 .21884 L
.85049 .21901 L
.85064 .21917 L
.85079 .21934 L
.85095 .2195 L
.8511 .21967 L
.85125 .21984 L
.85141 .22 L
.85156 .22017 L
.85172 .22033 L
.85187 .2205 L
.85203 .22067 L
.85218 .22083 L
.85233 .221 L
.85249 .22117 L
.85264 .22133 L
Mistroke
.8528 .2215 L
.85295 .22167 L
.85311 .22184 L
.85326 .222 L
.85342 .22217 L
.85357 .22234 L
.85373 .22251 L
.85388 .22267 L
.85404 .22284 L
.85419 .22301 L
.85435 .22318 L
.8545 .22334 L
.85466 .22351 L
.85481 .22368 L
.85497 .22385 L
.85512 .22402 L
.85528 .22419 L
.85543 .22436 L
.85559 .22452 L
.85574 .22469 L
.8559 .22486 L
.85605 .22503 L
.85621 .2252 L
.85637 .22537 L
.85652 .22554 L
.85668 .22571 L
.85683 .22588 L
.85699 .22605 L
.85715 .22622 L
.8573 .22639 L
.85746 .22656 L
.85761 .22673 L
.85777 .2269 L
.85793 .22707 L
.85808 .22724 L
.85824 .22741 L
.8584 .22758 L
.85855 .22775 L
.85871 .22792 L
.85887 .2281 L
.85902 .22827 L
.85918 .22844 L
.85934 .22861 L
.85949 .22878 L
.85965 .22895 L
.85981 .22913 L
.85996 .2293 L
.86012 .22947 L
.86028 .22964 L
.86044 .22981 L
Mistroke
.86059 .22999 L
.86075 .23016 L
.86091 .23033 L
.86106 .2305 L
.86122 .23068 L
.86138 .23085 L
.86154 .23102 L
.86169 .2312 L
.86185 .23137 L
.86201 .23154 L
.86217 .23172 L
.86233 .23189 L
.86248 .23206 L
.86264 .23224 L
.8628 .23241 L
.86296 .23258 L
.86312 .23276 L
.86327 .23293 L
.86343 .23311 L
.86359 .23328 L
.86375 .23346 L
.86391 .23363 L
.86407 .23381 L
.86422 .23398 L
.86438 .23415 L
.86454 .23433 L
.8647 .23451 L
.86486 .23468 L
.86502 .23486 L
.86518 .23503 L
.86534 .23521 L
.86549 .23538 L
.86565 .23556 L
.86581 .23573 L
.86597 .23591 L
.86613 .23609 L
.86629 .23626 L
.86645 .23644 L
.86661 .23662 L
.86677 .23679 L
.86693 .23697 L
.86709 .23715 L
.86725 .23732 L
.86741 .2375 L
.86757 .23768 L
.86773 .23786 L
.86789 .23803 L
.86805 .23821 L
.86821 .23839 L
.86837 .23857 L
Mistroke
.86853 .23874 L
.86869 .23892 L
.86885 .2391 L
.86901 .23928 L
.86917 .23946 L
.86933 .23963 L
.86949 .23981 L
.86965 .23999 L
.86981 .24017 L
.86997 .24035 L
.87013 .24053 L
.87029 .24071 L
.87045 .24089 L
.87061 .24107 L
.87077 .24125 L
.87093 .24143 L
.87109 .2416 L
.87125 .24178 L
.87142 .24196 L
.87158 .24214 L
.87174 .24232 L
.8719 .2425 L
.87206 .24269 L
.87222 .24287 L
.87238 .24305 L
.87254 .24323 L
.87271 .24341 L
.87287 .24359 L
.87303 .24377 L
.87319 .24395 L
.87335 .24413 L
.87351 .24431 L
.87368 .2445 L
.87384 .24468 L
.874 .24486 L
.87416 .24504 L
.87432 .24522 L
.87449 .2454 L
.87465 .24559 L
.87481 .24577 L
.87497 .24595 L
.87514 .24613 L
.8753 .24632 L
.87546 .2465 L
.87562 .24668 L
.87579 .24687 L
.87595 .24705 L
.87611 .24723 L
.87627 .24741 L
.87644 .2476 L
Mistroke
.8766 .24778 L
.87676 .24797 L
.87693 .24815 L
.87709 .24833 L
.87725 .24852 L
.87742 .2487 L
.87758 .24889 L
.87774 .24907 L
.87791 .24925 L
.87807 .24944 L
.87823 .24962 L
.8784 .24981 L
.87856 .24999 L
.87872 .25018 L
.87889 .25036 L
.87905 .25055 L
.87922 .25073 L
.87938 .25092 L
.87954 .25111 L
.87971 .25129 L
.87987 .25148 L
.88004 .25166 L
.8802 .25185 L
.88036 .25204 L
.88053 .25222 L
.88069 .25241 L
.88086 .2526 L
.88102 .25278 L
.88119 .25297 L
.88135 .25316 L
.88152 .25334 L
.88168 .25353 L
.88185 .25372 L
.88201 .25391 L
.88218 .25409 L
.88234 .25428 L
.88251 .25447 L
.88267 .25466 L
.88284 .25484 L
.883 .25503 L
.88317 .25522 L
.88333 .25541 L
.8835 .2556 L
.88366 .25579 L
.88383 .25597 L
.88399 .25616 L
.88416 .25635 L
.88432 .25654 L
.88449 .25673 L
.88466 .25692 L
Mistroke
.88482 .25711 L
.88499 .2573 L
.88515 .25749 L
.88532 .25768 L
.88549 .25787 L
.88565 .25806 L
.88582 .25825 L
.88599 .25844 L
.88615 .25863 L
.88632 .25882 L
.88648 .25901 L
.88665 .2592 L
.88682 .25939 L
.88698 .25958 L
.88715 .25977 L
.88732 .25997 L
.88749 .26016 L
.88765 .26035 L
.88782 .26054 L
.88799 .26073 L
.88815 .26092 L
.88832 .26112 L
.88849 .26131 L
.88865 .2615 L
.88882 .26169 L
.88899 .26188 L
.88916 .26208 L
.88932 .26227 L
.88949 .26246 L
.88966 .26266 L
.88983 .26285 L
.89 .26304 L
.89016 .26323 L
.89033 .26343 L
.8905 .26362 L
.89067 .26382 L
.89084 .26401 L
.891 .2642 L
.89117 .2644 L
.89134 .26459 L
.89151 .26479 L
.89168 .26498 L
.89185 .26517 L
.89201 .26537 L
.89218 .26556 L
.89235 .26576 L
.89252 .26595 L
.89269 .26615 L
.89286 .26634 L
.89303 .26654 L
Mistroke
.8932 .26673 L
.89336 .26693 L
.89353 .26713 L
.8937 .26732 L
.89387 .26752 L
.89404 .26771 L
.89421 .26791 L
.89438 .26811 L
.89455 .2683 L
.89472 .2685 L
.89489 .2687 L
.89506 .26889 L
.89523 .26909 L
.8954 .26929 L
.89557 .26948 L
.89574 .26968 L
.89591 .26988 L
.89608 .27008 L
.89625 .27027 L
.89642 .27047 L
.89659 .27067 L
.89676 .27087 L
.89693 .27107 L
.8971 .27126 L
.89727 .27146 L
.89744 .27166 L
.89761 .27186 L
.89778 .27206 L
.89795 .27226 L
.89812 .27246 L
.89829 .27266 L
.89847 .27286 L
.89864 .27305 L
.89881 .27325 L
.89898 .27345 L
.89915 .27365 L
.89932 .27385 L
.89949 .27405 L
.89966 .27425 L
.89984 .27445 L
.90001 .27465 L
.90018 .27486 L
.90035 .27506 L
.90052 .27526 L
.90069 .27546 L
.90087 .27566 L
.90104 .27586 L
.90121 .27606 L
.90138 .27626 L
.90155 .27646 L
Mistroke
.90173 .27667 L
.9019 .27687 L
.90207 .27707 L
.90224 .27727 L
.90241 .27747 L
.90259 .27768 L
.90276 .27788 L
.90293 .27808 L
.9031 .27828 L
.90328 .27849 L
.90345 .27869 L
.90362 .27889 L
.9038 .2791 L
.90397 .2793 L
.90414 .2795 L
.90432 .27971 L
.90449 .27991 L
.90466 .28011 L
.90484 .28032 L
.90501 .28052 L
.90518 .28073 L
.90536 .28093 L
.90553 .28113 L
.9057 .28134 L
.90588 .28154 L
.90605 .28175 L
.90622 .28195 L
.9064 .28216 L
.90657 .28236 L
.90675 .28257 L
.90692 .28277 L
.90709 .28298 L
.90727 .28319 L
.90744 .28339 L
.90762 .2836 L
.90779 .2838 L
.90797 .28401 L
.90814 .28422 L
.90832 .28442 L
.90849 .28463 L
.90867 .28484 L
.90884 .28504 L
.90901 .28525 L
.90919 .28546 L
.90936 .28567 L
.90954 .28587 L
.90972 .28608 L
.90989 .28629 L
.91007 .2865 L
.91024 .2867 L
Mistroke
.91042 .28691 L
.91059 .28712 L
.91077 .28733 L
.91094 .28754 L
.91112 .28775 L
.91129 .28795 L
.91147 .28816 L
.91165 .28837 L
.91182 .28858 L
.912 .28879 L
.91217 .289 L
.91235 .28921 L
.91253 .28942 L
.9127 .28963 L
.91288 .28984 L
.91306 .29005 L
.91323 .29026 L
.91341 .29047 L
.91359 .29068 L
.91376 .29089 L
.91394 .2911 L
.91412 .29131 L
.91429 .29152 L
.91447 .29173 L
.91465 .29194 L
.91482 .29216 L
.915 .29237 L
.91518 .29258 L
.91536 .29279 L
.91553 .293 L
.91571 .29321 L
.91589 .29343 L
.91607 .29364 L
.91624 .29385 L
.91642 .29406 L
.9166 .29428 L
.91678 .29449 L
.91695 .2947 L
.91713 .29492 L
.91731 .29513 L
.91749 .29534 L
.91767 .29555 L
.91785 .29577 L
.91802 .29598 L
.9182 .2962 L
.91838 .29641 L
.91856 .29662 L
.91874 .29684 L
.91892 .29705 L
.91909 .29727 L
Mistroke
.91927 .29748 L
.91945 .2977 L
.91963 .29791 L
.91981 .29813 L
.91999 .29834 L
.92017 .29856 L
.92035 .29877 L
.92053 .29899 L
.92071 .2992 L
.92089 .29942 L
.92107 .29964 L
.92125 .29985 L
.92142 .30007 L
.9216 .30028 L
.92178 .3005 L
.92196 .30072 L
.92214 .30093 L
.92232 .30115 L
.9225 .30137 L
.92268 .30159 L
.92286 .3018 L
.92304 .30202 L
.92322 .30224 L
.92341 .30246 L
.92359 .30267 L
.92377 .30289 L
.92395 .30311 L
.92413 .30333 L
.92431 .30355 L
.92449 .30376 L
.92467 .30398 L
.92485 .3042 L
.92503 .30442 L
.92521 .30464 L
.92539 .30486 L
.92558 .30508 L
.92576 .3053 L
.92594 .30552 L
.92612 .30574 L
.9263 .30596 L
.92648 .30618 L
.92666 .3064 L
.92685 .30662 L
.92703 .30684 L
.92721 .30706 L
.92739 .30728 L
.92757 .3075 L
.92776 .30772 L
.92794 .30794 L
.92812 .30816 L
Mistroke
.9283 .30839 L
.92849 .30861 L
.92867 .30883 L
.92885 .30905 L
.92903 .30927 L
.92922 .30949 L
.9294 .30972 L
.92958 .30994 L
.92976 .31016 L
.92995 .31038 L
.93013 .31061 L
.93031 .31083 L
.9305 .31105 L
.93068 .31128 L
.93086 .3115 L
.93105 .31172 L
.93123 .31195 L
.93141 .31217 L
.9316 .31239 L
.93178 .31262 L
.93196 .31284 L
.93215 .31307 L
.93233 .31329 L
.93252 .31352 L
.9327 .31374 L
.93288 .31397 L
.93307 .31419 L
.93325 .31442 L
.93344 .31464 L
.93362 .31487 L
.9338 .31509 L
.93399 .31532 L
.93417 .31554 L
.93436 .31577 L
.93454 .31599 L
.93473 .31622 L
.93491 .31645 L
.9351 .31667 L
.93528 .3169 L
.93547 .31713 L
.93565 .31735 L
.93584 .31758 L
.93602 .31781 L
.93621 .31804 L
.93639 .31826 L
.93658 .31849 L
.93677 .31872 L
.93695 .31895 L
.93714 .31918 L
.93732 .3194 L
Mistroke
.93751 .31963 L
.93769 .31986 L
.93788 .32009 L
.93807 .32032 L
.93825 .32055 L
.93844 .32078 L
.93863 .321 L
.93881 .32123 L
.939 .32146 L
.93918 .32169 L
.93937 .32192 L
.93956 .32215 L
.93975 .32238 L
.93993 .32261 L
.94012 .32284 L
.94031 .32307 L
.94049 .3233 L
.94068 .32354 L
.94087 .32377 L
.94105 .324 L
.94124 .32423 L
.94143 .32446 L
.94162 .32469 L
.9418 .32492 L
.94199 .32515 L
.94218 .32539 L
.94237 .32562 L
.94256 .32585 L
.94274 .32608 L
.94293 .32632 L
.94312 .32655 L
.94331 .32678 L
.9435 .32701 L
.94368 .32725 L
.94387 .32748 L
.94406 .32771 L
.94425 .32795 L
.94444 .32818 L
.94463 .32841 L
.94482 .32865 L
.945 .32888 L
.94519 .32912 L
.94538 .32935 L
.94557 .32959 L
.94576 .32982 L
.94595 .33005 L
.94614 .33029 L
.94633 .33052 L
.94652 .33076 L
.94671 .331 L
Mistroke
.9469 .33123 L
.94709 .33147 L
.94728 .3317 L
.94747 .33194 L
.94766 .33217 L
.94785 .33241 L
.94804 .33265 L
.94823 .33288 L
.94842 .33312 L
.94861 .33336 L
.9488 .33359 L
.94899 .33383 L
.94918 .33407 L
.94937 .33431 L
.94956 .33454 L
.94975 .33478 L
.94994 .33502 L
.95013 .33526 L
.95032 .33549 L
.95051 .33573 L
.95071 .33597 L
.9509 .33621 L
.95109 .33645 L
.95128 .33669 L
.95147 .33693 L
.95166 .33717 L
.95185 .33741 L
.95205 .33764 L
.95224 .33788 L
.95243 .33812 L
.95262 .33836 L
.95281 .3386 L
.953 .33884 L
.9532 .33908 L
.95339 .33933 L
.95358 .33957 L
.95377 .33981 L
.95397 .34005 L
.95416 .34029 L
.95435 .34053 L
.95454 .34077 L
.95474 .34101 L
.95493 .34125 L
.95512 .3415 L
.95531 .34174 L
.95551 .34198 L
.9557 .34222 L
.95589 .34247 L
.95609 .34271 L
.95628 .34295 L
Mistroke
.95647 .34319 L
.95667 .34344 L
.95686 .34368 L
.95705 .34392 L
.95725 .34417 L
.95744 .34441 L
.95764 .34465 L
.95783 .3449 L
.95802 .34514 L
.95822 .34539 L
.95841 .34563 L
.95861 .34587 L
.9588 .34612 L
.959 .34636 L
.95919 .34661 L
.95938 .34685 L
.95958 .3471 L
.95977 .34735 L
.95997 .34759 L
.96016 .34784 L
.96036 .34808 L
.96055 .34833 L
.96075 .34857 L
.96094 .34882 L
.96114 .34907 L
.96134 .34931 L
.96153 .34956 L
.96173 .34981 L
.96192 .35005 L
.96212 .3503 L
.96231 .35055 L
.96251 .3508 L
.96271 .35104 L
.9629 .35129 L
.9631 .35154 L
.96329 .35179 L
.96349 .35204 L
.96369 .35229 L
.96388 .35253 L
.96408 .35278 L
.96428 .35303 L
.96447 .35328 L
.96467 .35353 L
.96487 .35378 L
.96506 .35403 L
.96526 .35428 L
.96546 .35453 L
.96565 .35478 L
.96585 .35503 L
.96605 .35528 L
Mistroke
.96625 .35553 L
.96644 .35578 L
.96664 .35603 L
.96684 .35628 L
.96704 .35653 L
.96723 .35678 L
.96743 .35704 L
.96763 .35729 L
.96783 .35754 L
.96803 .35779 L
.96822 .35804 L
.96842 .35829 L
.96862 .35855 L
.96882 .3588 L
.96902 .35905 L
.96922 .3593 L
.96941 .35956 L
.96961 .35981 L
.96981 .36006 L
.97001 .36032 L
.97021 .36057 L
.97041 .36082 L
.97061 .36108 L
.97081 .36133 L
.97101 .36159 L
.97121 .36184 L
.97141 .3621 L
.9716 .36235 L
.9718 .36261 L
.972 .36286 L
.9722 .36312 L
.9724 .36337 L
.9726 .36363 L
.9728 .36388 L
.973 .36414 L
.9732 .36439 L
.9734 .36465 L
.9736 .36491 L
.97381 .36516 L
.97401 .36542 L
.97421 .36567 L
.97441 .36593 L
.97461 .36619 L
.97481 .36645 L
.97501 .3667 L
.97521 .36696 L
.97541 .36722 L
.97561 .36748 L
.97581 .36773 L
.97602 .28556 L
Mistroke
.97619 .28556 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00E@3oool2000000@0oooo00<000000?ooo`3oool0
0P3oool400000200oooo0P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
7`3oool2000000@0oooo00<000000?ooo`3oool00`3oool200000240oooo0P0000040?ooo`030000
003oool0oooo00<0oooo0P00000W0?ooo`@000001@3oool005@0oooo00@000000?ooo`3oool00000
203oool00`000000oooo0?ooo`0P0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3o
ool07P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000001l0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00000X0?ooo`030000003oool0oooo00@0oooo
001D0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool07`3oool010000000oooo
0?ooo`0000070?ooo`D000007`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
000001l0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000X0?ooo`030000
003oool0oooo00@0oooo001D0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0
7P3oool010000000oooo0?ooo`0000070?ooo`040000003oool0oooo00000200oooo00@000000?oo
o`3oool00000203oool300000200oooo00@000000?ooo`3oool000002@3oool2000002T0oooo00<0
00000?ooo`3oool0103oool005@0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?oo
o`0M0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`000000803oool010000000oooo
0?ooo`0000080?ooo`030000003oool0oooo0200oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`00000X0?ooo`030000003oool0oooo00@0oooo001D0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000007`3oool010000000oooo0?ooo`0000090?ooo`800000
803oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo0200oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`00000V0?ooo`<000001P3oool005D0oooo0P00000:0?oo
o`8000008@3oool2000000/0oooo00<000000?ooo`3oool07`3oool2000000X0oooo0`00000P0?oo
o`8000002P3oool2000002T0oooo00<000000?ooo`3oool0103oool00?l0oooo8@3oool00?l0oooo
8@3oool002d0oooo00<000000?ooo`3oool0l03oool002L0oooon@00000002d0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo000]0?ooo`03
0000003oool0oooo02`0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0D0?ooo``0
0000303oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3o
ool0103oool002d0oooo00<000000?ooo`3oool0K@3oool8000000H0oooo2@00001/0?ooo`00;@3o
ool00`000000oooo0?ooo`1Z0?ooo`D000004`3oool6000006P0oooo000]0?ooo`030000003oool0
oooo06L0oooo1000000K0?ooo`D00000I@3oool000P0oooo0P0000040?ooo`030000003oool0oooo
00<0oooo0P0000040?ooo`800000103oool2000000<0oooo100000040?ooo`030000003oool0oooo
06D0oooo1000000P0?ooo`D00000HP3oool000L0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06@0oooo0`00000U0?ooo`@00000
H03oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`03
0?ooo`800000H`3oool3000002X0oooo1000001M0?ooo`001`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0H@3oool2000002h0
oooo1000001K0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0G`3oool300000340oooo1000001I0?ooo`001`3oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`<000001@3oool00`000000oooo0?ooo`1N0?oo
o`800000=@3oool4000005L0oooo00080?ooo`8000002P3oool2000000@0oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo05d0oooo0P00000h0?ooo`@0
0000E@3oool002d0oooo00<000000?ooo`3oool0G03oool2000003/0oooo0`00001D0?ooo`00;@3o
ool00`000000oooo0?ooo`1J0?ooo`<00000?P3oool300000580oooo000]0?ooo`800000F@3oool3
00000440oooo1000001@0?ooo`00;@3oool00`000000oooo0?ooo`1G0?ooo`800000A@3oool30000
04l0oooo000]0?ooo`030000003oool0oooo05H0oooo0P0000180?ooo`<00000C@3oool002d0oooo
00<000000?ooo`3oool0E03oool3000004X0oooo0`00001<0?ooo`00;@3oool00`000000oooo0?oo
o`1C0?ooo`800000CP3oool3000004X0oooo000]0?ooo`030000003oool0oooo0580oooo0P00001@
0?ooo`<00000B@3oool002d0oooo00<000000?ooo`3oool0D@3oool2000005<0oooo0`0000170?oo
o`00;@3oool200000540oooo0P00001E0?ooo`<00000AP3oool002d0oooo00<000000?ooo`3oool0
C`3oool2000005L0oooo0`0000150?ooo`00;@3oool00`000000oooo0?ooo`1?0?ooo`030000003o
ool0oooo05P0oooo0P0000140?ooo`00;@3oool00`000000oooo0?ooo`1>0?ooo`800000F`3oool3
00000480oooo000]0?ooo`030000003oool0oooo04d0oooo0P00001M0?ooo`<00000@@3oool002d0
oooo00<000000?ooo`3oool0C03oool2000005l0oooo0`0000100?ooo`00;@3oool00`000000oooo
0?ooo`1<0?ooo`030000003oool0oooo0600oooo0P00000o0?ooo`00;@3oool00`000000oooo0?oo
o`1;0?ooo`800000H`3oool3000003d0oooo000]0?ooo`800000B`3oool2000006D0oooo0`00000l
0?ooo`00;@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo06D0oooo0`00000k0?oo
o`00;@3oool00`000000oooo0?ooo`190?ooo`800000J03oool3000003X0oooo000]0?ooo`030000
003oool0oooo04T0oooo00<000000?ooo`3oool0J@3oool2000003T0oooo000]0?ooo`030000003o
ool0oooo04P0oooo0P00001/0?ooo`800000>03oool002d0oooo00<000000?ooo`3oool0B03oool0
0`000000oooo0?ooo`1/0?ooo`800000=`3oool002d0oooo00<000000?ooo`3oool0A`3oool20000
06l0oooo0P00000f0?ooo`00;@3oool2000004P0oooo00<000000?ooo`3oool0K`3oool2000003D0
oooo000]0?ooo`030000003oool0oooo04H0oooo0P00001b0?ooo`<00000<`3oool002d0oooo00<0
00000?ooo`3oool0AP3oool00`000000oooo0?ooo`1b0?ooo`800000<`3oool002d0oooo10000014
0?ooo`800000M@3oool300000340oooo000]0?ooo`P00000@03oool00`000000oooo0?ooo`1e0?oo
o`<00000<03oool002d0oooo00<000000?ooo`3oool00`3ooolA00000340oooo00<000000?ooo`3o
ool0MP3oool200000300oooo00020?ooo`800000103oool00`000000oooo0?ooo`030?ooo`800000
103oool2000000@0oooo0P0000030?ooo`@000000P3oool3000000D0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`080?ooo`H00000;@3oool00`000000oooo0?ooo`1h0?ooo`800000
;`3oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool05@3oool4000002/0oooo00<00000
0?ooo`3oool0N@3oool2000002h0oooo00001@3oool000000?ooo`3oool0000000P0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`8000006@3oool3000002P0
oooo0P00001l0?ooo`800000;@3oool000050?ooo`000000oooo0?ooo`000000203oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103o
ool010000000oooo0?ooo`3oool3000000D0oooo00<000000?ooo`3oool06@3oool4000002H0oooo
00<000000?ooo`3oool0O03oool3000002/0oooo00001@3oool000000?ooo`3oool0000000P0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo01/0oooo0`00
000U0?ooo`030000003oool0oooo07d0oooo0`00000Z0?ooo`0000D0oooo0000003oool0oooo0000
00080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`<000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
01`0oooo0`00000S0?ooo`800000P03oool3000002T0oooo00020?ooo`8000002P3oool2000000@0
oooo0P0000040?ooo`8000001@3oool010000000oooo0?ooo`3oool4000000@0oooo00<000000?oo
o`3oool07P3oool200000280oooo00<000000?ooo`3oool0P03oool2000002T0oooo000]0?ooo`03
0000003oool0oooo01l0oooo0P00000Q0?ooo`030000003oool0oooo0840oooo0P00000X0?ooo`00
;@3oool00`000000oooo0?ooo`0P0?ooo`8000007`3oool2000008@0oooo0P00000W0?ooo`00;@3o
ool200000280oooo0P00000N0?ooo`030000003oool0oooo08@0oooo0P00000V0?ooo`00;@3oool0
0`000000oooo0?ooo`0Q0?ooo`8000007P3oool00`000000oooo0?ooo`250?ooo`8000009@3oool0
02d0oooo00<000000?ooo`3oool08P3oool2000001d0oooo00<000000?ooo`3oool0QP3oool20000
02@0oooo000]0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`280?ooo`8000008`3oool002d0oooo00<000000?ooo`3oool0903oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo08T0oooo0P00000R0?ooo`00;@3oool00`000000oooo0?oo
o`0T0?ooo`8000006P3oool00`000000oooo0?ooo`2:0?ooo`8000008@3oool002d0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0G0?ooo`800000S@3oool200000200oooo000]0?oo
o`8000009P3oool2000001P0oooo00<000000?ooo`3oool0S03oool3000001l0oooo000]0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`2=0?ooo`80
00007`3oool002d0oooo00<000000?ooo`3oool09P3oool2000001L0oooo00<000000?ooo`3oool0
SP3oool2000001h0oooo000]0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`2?0?ooo`8000007@3oool002d0oooo00<000000?ooo`3oool09`3oool2
000001D0oooo00<000000?ooo`3oool0T@3oool2000001`0oooo000]0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`2B0?ooo`8000006`3oool002d0
oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo09<0
oooo0P00000J0?ooo`00;@3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool0U03oool2000001T0oooo000]0?ooo`800000:P3oool00`000000oooo0?oo
o`0A0?ooo`800000U`3oool00`000000oooo0?ooo`0G0?ooo`00;@3oool00`000000oooo0?ooo`0Y
0?ooo`8000004P3oool00`000000oooo0?ooo`2F0?ooo`800000603oool002d0oooo00<000000?oo
o`3oool0:P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo09L0oooo0P00000@0?oo
o`030000003oool0oooo00@0oooo000]0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`2H0?ooo`8000003`3oool00`000000oooo0?ooo`040?ooo`00
;@3oool00`000000oooo0?ooo`0Z0?ooo`8000004@3oool00`000000oooo0?ooo`2I0?ooo`800000
3P3oool00`000000oooo0?ooo`040?ooo`00;@3oool00`000000oooo0?ooo`0[0?ooo`030000003o
ool0oooo00h0oooo0P00002L0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0103o
ool002d0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo09`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`00;@3oool20000
02`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`2L0?ooo`800000303oool00`00
0000oooo0?ooo`040?ooo`00;@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0W@3oool2000000/0oooo00<000000?ooo`3oool0103oool002d0oooo
00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo09h0oooo
0P00000:0?ooo`030000003oool0oooo00@0oooo000]0?ooo`030000003oool0oooo02`0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`2O0?ooo`8000002@3oool00`000000oooo0?oo
o`040?ooo`00;@3oool00`000000oooo0?ooo`0/0?ooo`8000003@3oool200000:80oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`00203oool2000000@0oooo00<000000?oo
o`3oool00`3oool2000000@0oooo0P0000040?ooo`8000000`3oool4000000@0oooo00<000000?oo
o`3oool0;@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0:40oooo0P0000080?oo
o`030000003oool0oooo00@0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0XP3oool2000000L0oooo00<000000?ooo`3oool0103oool000L0oooo00@0
00000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?ooo`800000;P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0:<0oooo0P0000060?ooo`030000003oool0
oooo00@0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0Y03oool2000000D0oooo00<000000?ooo`3oool0103oool000L0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02h0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`2U0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0103oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`2V0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool0
00P0oooo0P00000:0?ooo`800000103oool2000000@0oooo0P0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0Y`3oool20000
00<0oooo00<000000?ooo`3oool0103oool002d0oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo0:P0oooo0P0000020?ooo`030000003oool0oooo00@0
oooo000]0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`2Y0?ooo`80000000<0oooo0000003oool01@3oool002d0oooo00<000000?ooo`3oool0;`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0:X0oooo00<000000?ooo`0000001P3o
ool002d0oooo0P00000`0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0ZP3oool3
000000H0oooo000]0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`2[0?ooo`8000001P3oool002d0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo0;<0oooo000]0?ooo`030000003oool0oooo02l0oooo
00<000000?ooo`3oool01`3oool200000;D0oooo000]0?ooo`030000003oool0oooo02l0oooo0P00
00080?ooo`030000003oool0oooo0;@0oooo000]0?ooo`030000003oool0oooo0300oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`2d0?ooo`00;@3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0]03oool002d0oooo0P00000a0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0]03oool002d0oooo00<000000?ooo`3oool0
<03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0;@0oooo000]0?ooo`030000003o
ool0oooo0300oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2d0?ooo`00;@3oool0
0`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0]03oool0
02d0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0;@0oooo000]0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`2e0?ooo`00;@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0]@3oool002d0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0;D0oooo000]0?ooo`800000<P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0;D0oooo000]0?ooo`030000003oool0oooo0340oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`2e0?ooo`00;@3oool00`000000oooo0?ooo`0a0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0]@3oool002d0oooo00<000000?ooo`3oool0
<@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0;D0oooo000]0?ooo`030000003o
ool0oooo0380oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2e0?ooo`00;@3oool0
0`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0]@3oool0
02d0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0;D0oooo000]0?ooo`800000<`3oool00`000000oooo0?ooo`020?ooo`800000]`3oool002d0oooo
00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0;H0oooo
000]0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`2f0?ooo`00;@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0]P3oool002d0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0;H0oooo00020?ooo`800000103oool00`000000oooo0?ooo`030?ooo`80
0000103oool2000000@0oooo0P0000030?ooo`@000000P3oool3000000D0oooo00<000000?ooo`3o
ool0<P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0;H0oooo00001@3oool00000
0?ooo`3oool0000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo03<0oooo00D000000?ooo`3oool0oooo0000002h0?ooo`0000D0
oooo0000003oool0oooo000000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool00P3oool2000003@0oooo00D000000?ooo`3oool0oooo0000002h0?ooo`0000D0oooo
0000003oool0oooo000000080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo0?ooo`<000001@3oool0
0`000000oooo0?ooo`0c0?ooo`050000003oool0oooo0?ooo`000000^03oool000050?ooo`000000
oooo0?ooo`000000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool000001@3oool010000000oooo0?ooo`0000070?ooo`030000003oool0
oooo03<0oooo00D000000?ooo`3oool0oooo0000002h0?ooo`0000D0oooo0000003oool0oooo0000
00080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0c0?ooo`050000003oool0oooo0?ooo`000000^03oool00080oooo0P00000:
0?ooo`800000103oool2000000@0oooo0P0000040?ooo`8000000`3oool4000000@0oooo00<00000
0?ooo`3oool0<`3oool01@000000oooo0?ooo`3oool000000;P0oooo000]0?ooo`030000003oool0
oooo03<0oooo00D000000?ooo`3oool0oooo0000002h0?ooo`00;@3oool00`000000oooo0?ooo`0c
0?ooo`040000003oool0oooo00000;T0oooo000]0?ooo`030000003oool0oooo03<0oooo00@00000
0?ooo`3oool00000^@3oool002d0oooo0P00000d0?ooo`040000003oool0oooo00000;T0oooo000]
0?ooo`030000003oool0oooo03<0oooo00@000000?ooo`3oool00000^@3oool002d0oooo00<00000
0?ooo`3oool0=03oool00`000000oooo0000002i0?ooo`00;@3oool00`000000oooo0?ooo`0d0?oo
o`030000003oool000000;T0oooo000]0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`00
0000^@3oool002d0oooo00<000000?ooo`3oool0=03oool00`000000oooo0000002i0?ooo`00;@3o
ool00`000000oooo0?ooo`0d0?ooo`030000003oool000000;T0oooo000]0?ooo`800000=@3oool0
0`000000oooo0000002i0?ooo`00;@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool00000
0;T0oooo000]0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`000000^@3oool002d0oooo
00<000000?ooo`3oool0=03oool00`000000oooo0000002i0?ooo`00;@3oool00`000000oooo0?oo
o`0d0?ooo`030000003oool000000;T0oooo000]0?ooo`030000003oool0oooo03@0oooo00<00000
0?ooo`000000^@3oool002d0oooo00<000000?ooo`3oool0=03oool200000;X0oooo000]0?ooo`80
0000=@3oool200000;X0oooo000]0?ooo`030000003oool0oooo03@0oooo0P00002j0?ooo`00;@3o
ool00`000000oooo0?ooo`0d0?ooo`800000^P3oool002d0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`2h0?ooo`00;@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
0;P0oooo000]0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0^03oool002d0oooo
00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`2h0?ooo`00;@3oool00`000000oooo0?oo
o`0e0?ooo`030000003oool0oooo0;P0oooo000]0?ooo`800000=P3oool00`000000oooo0?ooo`2h
0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00
;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.191061, 6.46386*^-5, \
0.00423651, 1.35499*^-6}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "The stiffness detection device (described within ",
  ButtonBox["StiffnessTest",
    ButtonData:>{"StiffnessTest.nb", None},
    ButtonStyle->"Hyperlink"],
  ") ascertains that the ",
  StyleBox["ExplicitEuler", "MR"],
  " method is restricted by stability rather than local accuracy."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[stiffsystem, 
      Method \[Rule] {"\<DoubleStep\>", \ 
          Method \[Rule] "\<ExplicitEuler\>"}]\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndstf"\), \(\(:\)\(\ \)\), "\<\"At \\!\\(T\\) == \
\\!\\(0.010198618185165691`\\), system appears to be stiff. Methods \
Automatic, BDF or StiffnessSwitching may be more appropriate. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NDSolve::ndstf\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[11]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 0.010198618185165691`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 0.010198618185165691`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_3[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 0.010198618185165691`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[11]="]
}, Open  ]],

Cell["\<\
An alternative base method is more appropriate for this \
problem.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(liesol\  = \ 
      NDSolve[stiffsystem, 
        Method \[Rule] {"\<DoubleStep\>", \ 
            Method \[Rule] "\<LinearlyImplicitEuler\>"}]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.3`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.3`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_3[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.3`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[12]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["User-defined methods and method properties", "Subsection"],

Cell[TextData[{
  "Integration methods can be added to the ",
  StyleBox["NDSolve", "MR"],
  " framework."
}], "Text"],

Cell["\<\
In order for these to work like built-in methods it can be \
necessary to specify various method properties. These properties can then be \
used by other methods to build up compound integrators.\
\>", "Text"],

Cell[TextData[{
  "Here is how to define a top-level plug-in for the classical Runge-Kutta \
method (see ",
  StyleBox[ButtonBox["ExplicitRungeKutta",
    ButtonData:>{"ExplicitRungeKutta.nb", None},
    ButtonStyle->"Hyperlink"], "MR"],
  " for more details)."
}], "MathCaption"],

Cell[BoxData[
    \(\(\(ClassicalRungeKutta[___]\)["\<Step\>"[f_, t_, h_, y_, 
            yp_]] := \[IndentingNewLine]Block[{deltay, k1, k2, k3, 
            k4}, \[IndentingNewLine]k1 = yp; \[IndentingNewLine]k2 = 
            f[t + 1/2\ h, y + 1/2\ h\ k1]; \[IndentingNewLine]k3 = 
            f[t + 1/2\ h, y + 1/2\ h\ k2]; \[IndentingNewLine]k4 = 
            f[t + h, y + h\ k3]; \[IndentingNewLine]deltay = 
            h\ \((1/6\ k1 + 1/3\ k2 + 1/3\ k3 + 
                  1/6\ k4)\); \[IndentingNewLine]{h, 
            deltay}\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[13]:="],

Cell[TextData[{
  "Method properties used by ",
  StyleBox["DoubleStep", "MR"],
  " are now described."
}], "Text"],

Cell[CellGroupData[{

Cell["Order and symmetry", "Subsubsection"],

Cell["\<\
This attempts to integrate a system using one application of \
Richardson's extrapolation based on the classical Runge-Kutta method.\
\>", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(NDSolve[nonstiffsystem, 
        Method \[Rule] {"\<DoubleStep\>", 
            Method \[Rule] ClassicalRungeKutta, "\<StiffnessTest\>" \[Rule] 
              False}];\)\)], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"mtdp"\), \(\(:\)\(\ \)\), \
"\<\"\\!\\(ClassicalRungeKutta\\) does not have a correctly defined property \
\\!\\(\\\"DifferenceOrder\\\"\\) in \\!\\(\\\"DoubleStep\\\"\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NDSolve::mtdp\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[14]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"initf"\), \(\(:\)\(\ \)\), "\<\"The initialization of \
the method \\!\\(NDSolve`DoubleStep\\) failed. \\!\\(\\*ButtonBox[\\\"More\
\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"NDSolve::initf\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[14]:="]
}, Open  ]],

Cell[TextData[{
  "Without knowing the order of the base method, ",
  StyleBox["DoubleStep", "MR"],
  " is unable to carry out Richardson's extrapolation."
}], "Text"],

Cell["\<\
This defines a method property to communicate to the framework that \
the classical Runge-Kutta method has order four.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(\(ClassicalRungeKutta[___]\)["\<DifferenceOrder\>"[]] := 
        4;\)\)], "Input",
  CellLabel->"In[15]:="],

Cell[TextData[{
  "The method ",
  StyleBox["DoubleStep", "MR"],
  " is now able to ascertain that ",
  StyleBox["ClassicalRungeKutta", "MR"],
  " is of order four and can use this information when refining the solution \
and estimating the local error"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[nonstiffsystem, 
      Method \[Rule] {"\<DoubleStep\>", 
          Method \[Rule] ClassicalRungeKutta, "\<StiffnessTest\>" \[Rule] 
            False}]\)], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 20.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 20.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[16]="]
}, Open  ]],

Cell[TextData[{
  "The order of the result of Richardson's extrapolation depends on whether \
the extrapolated method has a local error expansion in powers of ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`h\^2\)]],
  " (the latter occurs if the base method is symmetric)."
}], "Text"],

Cell[TextData[{
  "If no method property for symmetry is defined, the ",
  StyleBox["DoubleStep", "MR"],
  " method assumes by default that the base integrator is not symmetric."
}], "Text"],

Cell[TextData[{
  "This explicitly specifies that the classical Runge-Kutta method is not \
symmetric using the ",
  StyleBox["SymmetricMethodQ", "MR"],
  " property."
}], "MathCaption"],

Cell[BoxData[
    \(\(\(ClassicalRungeKutta[___]\)["\<SymmetricMethodQ\>"[]] := 
        False;\)\)], "Input",
  CellLabel->"In[17]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stiffness detection", "Subsubsection"],

Cell["\<\
Stiffness detection relies on knowledge of the linear stability \
boundary of the method, which has not been defined.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(NDSolve[stiffsystem, 
        Method \[Rule] {"\<DoubleStep\>", 
            Method \[Rule] ClassicalRungeKutta}];\)\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"mtdp"\), \(\(:\)\(\ \)\), \
"\<\"\\!\\(ClassicalRungeKutta\\) does not have a correctly defined property \
\\!\\(\\\"LinearStabilityBoundary\\\"\\) in \\!\\(\\\"DoubleStep\\\"\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NDSolve::mtdp\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[18]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"initf"\), \(\(:\)\(\ \)\), "\<\"The initialization of \
the method \\!\\(NDSolve`DoubleStep\\) failed. \\!\\(\\*ButtonBox[\\\"More\
\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"NDSolve::initf\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[18]:="]
}, Open  ]],

Cell["\<\
This gives the linear stability boundary of the method for the \
framework.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(\(ClassicalRungeKutta[___]\)["\<LinearStabilityBoundary\>"[]] := 
        Root[24 + 12\ #1 + 4\ #1\^2 + #1\^3 &, 1];\)\)], "Input",
  CellLabel->"In[19]:="],

Cell["The scheme is now equipped with stiffness detection.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[stiffsystem, 
      Method \[Rule] {"\<DoubleStep\>", 
          Method \[Rule] ClassicalRungeKutta}]\)], "Input",
  CellLabel->"In[20]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndstf"\), \(\(:\)\(\ \)\), "\<\"At \\!\\(T\\) == \
\\!\\(0.010001367022689375`\\), system appears to be stiff. Methods \
Automatic, BDF or StiffnessSwitching may be more appropriate. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NDSolve::ndstf\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[20]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 0.010001367022689375`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 0.010001367022689375`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_3[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 0.010001367022689375`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[20]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["DoubleStep", "MR"],
  " assumes by default that a method is not appropriate for stiff problems \
(and hence uses stiffness detection) when no ",
  StyleBox["StiffMethodQ", "MR"],
  " property is specified. This shows how to define the property."
}], "MathCaption"],

Cell[BoxData[
    \(\(\(ClassicalRungeKutta[___]\)["\<StiffMethodQ\>"[]] := 
        False;\)\)], "Input",
  CellLabel->"In[21]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Higher order", "Subsubsection"],

Cell[TextData[{
  "The following example extrapolates the classical Runge-Kutta method of \
order four using two applications of (",
  
  CounterBox["NumberedEquation", "DSLocalExtrapolation"],
  ")."
}], "Text"],

Cell[TextData[{
  "The inner specification of ",
  StyleBox["DoubleStep", "MR"],
  " constructs a method of order five."
}], "Text"],

Cell[TextData[{
  " A second application of ",
  StyleBox["DoubleStep", "MR"],
  " is used to obtain a method of order-six, which uses adaptive step sizes."
}], "Text"],

Cell[TextData[{
  "Nested applications of ",
  StyleBox["DoubleStep", "MR"],
  " are used to raise the order and provide and adaptive step size estimate."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[nonstiffsystem, 
      Method \[Rule] {"\<DoubleStep\>", \ 
          Method \[Rule] {"\<DoubleStep\>", 
              Method -> ClassicalRungeKutta}, "\<StiffnessTest\>" \[Rule] 
            False}]\)], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 20.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 20.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[22]="]
}, Open  ]],

Cell[TextData[{
  "In general the method ",
  StyleBox["Extrapolation", "MR"],
  " is more appropriate for constructing high-order integration schemes from \
low-order methods."
}], "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option summary", "Section",
  CellTags->"s:3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["LocalExtrapolation",
              "MR"], 
            StyleBox["True",
              "MR"], 
            RowBox[{
            "specifies", " ", "whether", " ", "to", " ", "advance", " ", 
              "the", " ", "solution", " ", "using", " ", "local", " ", 
              "extrapolation", " ", "according", " ", "to", " ", 
              RowBox[{"(", 
                CounterBox["NumberedEquation", "DSLocalExtrapolation"], 
                ")"}]}]},
          {
            StyleBox["Method",
              "MR"], 
            StyleBox["None",
              
              "MR"], \(specifies\ the\ method\ to\ use\ as\ the\ base\ \
integration\ scheme\)},
          {
            StyleBox["StepSizeRatioBounds",
              "MR"], 
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                FractionBox[
                  StyleBox["1",
                    "MR"], "8"], 
                StyleBox[",",
                  "MR"], 
                StyleBox["4",
                  "MR"]}], 
              StyleBox["}",
                "MR"]}], 
            RowBox[{
              RowBox[{
              "specifies", " ", "the", " ", "bounds", " ", "on", " ", "a", 
                " ", "relative", " ", "change", " ", "in", " ", "the", " ", 
                "new", " ", "step", " ", "size", " ", 
                SubscriptBox[
                  StyleBox["h",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox["n",
                      FontSlant->"Italic"], "+", "1"}]], " ", "from", " ", 
                "the", " ", "current", " ", "step", " ", "size", " ", 
                SubscriptBox[
                  StyleBox["h",
                    FontSlant->"Italic"], 
                  StyleBox["n",
                    FontSlant->"Italic"]], " ", "as", " ", "low"}], " ", 
              "\[LessEqual]", " ", 
              RowBox[{
                SubscriptBox[
                  StyleBox["h",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox["n",
                      FontSlant->"Italic"], "+", "1"}]], "/", 
                SubscriptBox[
                  StyleBox["h",
                    FontSlant->"Italic"], 
                  StyleBox["n",
                    FontSlant->"Italic"]]}], " ", "\[LessEqual]", " ", 
              "high"}]},
          {
            StyleBox["StepSizeSafetyFactors",
              "MR"], \({9\/10, 9\/10}\), 
            RowBox[{
            "specifies", " ", "the", " ", "safety", " ", "factors", " ", "to",
               " ", "incorporate", " ", "into", " ", "the", " ", "error", " ",
               "estimate", " ", 
              RowBox[{"(", 
                CounterBox["NumberedEquation", "DSErrorEstimate"], ")"}], " ",
               "used", " ", "for", " ", "adaptive", " ", "step", " ", 
              "sizes"}]},
          {
            StyleBox["StiffnessTest",
              "MR"], 
            StyleBox["Automatic",
              
              "MR"], \(specifies\ whether\ to\ use\ the\ stiffness\ detection\
\ capability\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options of the method ",
  StyleBox["DoubleStep", "MR"],
  ". "
}], "Caption"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
AutoGeneratedPackage->None,
Saveable->False,
ScreenStyleEnvironment->"Brackets",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DoubleStep",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[1776, 53, 48, 1, 95, "Chapter",
      CellTags->"c:1"]},
  "s:1"->{
    Cell[1849, 58, 50, 1, 66, "Section",
      CellTags->"s:1"]},
  "DSErrorEstimate"->{
    Cell[3120, 114, 248, 7, 45, "NumberedEquation",
      CellTags->"DSErrorEstimate"]},
  "DSLocalExtrapolation"->{
    Cell[3781, 139, 240, 7, 33, "NumberedEquation",
      CellTags->"DSLocalExtrapolation"]},
  "s:2"->{
    Cell[4342, 162, 46, 1, 66, "Section",
      CellTags->"s:2"]},
  "s:3"->{
    Cell[163967, 8892, 52, 1, 66, "Section",
      CellTags->"s:3"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 168357, 9017},
  {"s:1", 168434, 9020},
  {"DSErrorEstimate", 168523, 9023},
  {"DSLocalExtrapolation", 168640, 9026},
  {"s:2", 168745, 9029},
  {"s:3", 168823, 9032}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 48, 1, 95, "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{
Cell[1849, 58, 50, 1, 66, "Section",
  CellTags->"s:1"],
Cell[1902, 61, 180, 5, 40, "Text"],
Cell[2085, 68, 226, 4, 40, "Text"],
Cell[2314, 74, 163, 4, 40, "Text"],
Cell[2480, 80, 111, 5, 24, "Text"],
Cell[2594, 87, 191, 8, 26, "BulletedList"],
Cell[2788, 97, 196, 8, 26, "BulletedList"],
Cell[2987, 107, 130, 5, 26, "BulletedList"],
Cell[3120, 114, 248, 7, 45, "NumberedEquation",
  CellTags->"DSErrorEstimate"],
Cell[3371, 123, 208, 6, 44, "BulletedList"],
Cell[3582, 131, 196, 6, 26, "BulletedList"],
Cell[3781, 139, 240, 7, 33, "NumberedEquation",
  CellTags->"DSLocalExtrapolation"],
Cell[4024, 148, 281, 9, 44, "BulletedList"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4342, 162, 46, 1, 66, "Section",
  CellTags->"s:2"],
Cell[4391, 165, 95, 3, 40, "MathCaption"],
Cell[4489, 170, 236, 5, 42, "Input",
  InitializationCell->True],
Cell[4728, 177, 66, 0, 40, "MathCaption"],
Cell[4797, 179, 159, 4, 26, "Input",
  InitializationCell->True],
Cell[4959, 185, 63, 0, 40, "MathCaption"],
Cell[5025, 187, 142, 3, 26, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5192, 194, 48, 0, 40, "Subsection"],
Cell[5243, 196, 204, 5, 40, "Text"],
Cell[5450, 203, 270, 8, 56, "MathCaption"],
Cell[5723, 213, 200, 5, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[5948, 222, 209, 5, 42, "Input"],
Cell[6160, 229, 543, 15, 41, "Output"]
}, Open  ]],
Cell[6718, 247, 108, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[6851, 254, 77, 2, 26, "Input"],
Cell[6931, 258, 143399, 8194, 184, 124159, 7951, "GraphicsData", \
"PostScript", "Graphics"],
Cell[150333, 8454, 155, 4, 25, "Output"]
}, Open  ]],
Cell[150503, 8461, 323, 8, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[150851, 8473, 169, 4, 26, "Input"],
Cell[151023, 8479, 417, 7, 44, "Message"],
Cell[151443, 8488, 914, 26, 57, "Output"]
}, Open  ]],
Cell[152372, 8517, 97, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[152494, 8524, 201, 5, 42, "Input"],
Cell[152698, 8531, 761, 20, 57, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[153508, 8557, 64, 0, 40, "Subsection"],
Cell[153575, 8559, 118, 4, 24, "Text"],
Cell[153696, 8565, 219, 4, 40, "Text"],
Cell[153918, 8571, 280, 7, 56, "MathCaption"],
Cell[154201, 8580, 598, 10, 154, "Input"],
Cell[154802, 8592, 115, 4, 24, "Text"],

Cell[CellGroupData[{
Cell[154942, 8600, 43, 0, 34, "Subsubsection"],
Cell[154988, 8602, 165, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[155178, 8610, 229, 5, 42, "Input"],
Cell[155410, 8617, 405, 7, 31, "Message"],
Cell[155818, 8626, 335, 5, 18, "Message"]
}, Open  ]],
Cell[156168, 8634, 167, 4, 40, "Text"],
Cell[156338, 8640, 149, 3, 56, "MathCaption"],
Cell[156490, 8645, 130, 3, 26, "Input"],
Cell[156623, 8650, 272, 7, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[156920, 8661, 218, 5, 42, "Input"],
Cell[157141, 8668, 546, 15, 41, "Output"]
}, Open  ]],
Cell[157702, 8686, 340, 9, 41, "Text"],
Cell[158045, 8697, 190, 4, 40, "Text"],
Cell[158238, 8703, 186, 5, 56, "MathCaption"],
Cell[158427, 8710, 135, 3, 26, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[158599, 8718, 44, 0, 34, "Subsubsection"],
Cell[158646, 8720, 141, 3, 40, "Text"],

Cell[CellGroupData[{
Cell[158812, 8727, 176, 4, 42, "Input"],
Cell[158991, 8733, 413, 7, 31, "Message"],
Cell[159407, 8742, 335, 5, 18, "Message"]
}, Open  ]],
Cell[159757, 8750, 106, 3, 40, "MathCaption"],
Cell[159866, 8755, 178, 3, 46, "Input"],
Cell[160047, 8760, 75, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[160147, 8764, 167, 4, 42, "Input"],
Cell[160317, 8770, 417, 7, 44, "Message"],
Cell[160737, 8779, 914, 26, 57, "Output"]
}, Open  ]],
Cell[161666, 8808, 292, 6, 72, "MathCaption"],
Cell[161961, 8816, 131, 3, 26, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[162129, 8824, 37, 0, 34, "Subsubsection"],
Cell[162169, 8826, 212, 6, 40, "Text"],
Cell[162384, 8834, 132, 4, 24, "Text"],
Cell[162519, 8840, 168, 4, 40, "Text"],
Cell[162690, 8846, 173, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[162888, 8854, 265, 6, 58, "Input"],
Cell[163156, 8862, 546, 15, 41, "Output"]
}, Open  ]],
Cell[163717, 8880, 189, 5, 40, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[163967, 8892, 52, 1, 66, "Section",
  CellTags->"s:3"],
Cell[164022, 8895, 3417, 89, 270, "DefinitionBox3Col"],
Cell[167442, 8986, 97, 4, 16, "Caption"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

