(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    813221,      31362]*)
(*NotebookOutlinePosition[    818278,      31502]*)
(*  CellTagsIndexPosition[    817148,      31470]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Extrapolation", "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"s:1"],

Cell[TextData[{
  "Extrapolation methods are a class of arbitrary-order methods with \
automatic order and step size control. The error estimate comes from \
computing a solution over an interval using the same method with a varying \
number of steps and using extrapolation on the polynomial that fits through \
the computed solutions, giving a composite higher-order method [",
  ButtonBox["BS64",
    ButtonData:>{"References.nb", "BS64"},
    ButtonStyle->"Hyperlink"],
  "]. At the same time, the polynomials give a means of error estimation."
}], "Text"],

Cell["\<\
Typically, for low precision, the extrapolation methods have not \
been competitive with Runge-Kutta-type methods. For high precision, however, \
the arbitrary order means that they can be arbitrarily faster than \
fixed-order methods for very precise tolerances.\
\>", "Text"],

Cell[TextData[{
  "The order and step size control is based on the codes odex.f and seulex.f \
described in [",
  ButtonBox["HNW93",
    ButtonData:>{"References.nb", "HNW93"},
    ButtonStyle->"Hyperlink"],
  "] and ",
  "[",
  ButtonBox["HW96",
    ButtonData:>{"References.nb", "HW96"},
    ButtonStyle->"Hyperlink"],
  "]",
  "."
}], "Text"],

Cell["\<\
This loads packages that contain some utility functions for \
plotting step sequences and some predefined problems.\
\>", "Text"],

Cell[BoxData[{
    \(\(Needs["\<DifferentialEquations`NDSolveProblems`\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(Needs["\<DifferentialEquations`NDSolveUtilities`\>"];\)\)}], "Input",
  CellLabel->"In[3]:=",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extrapolation", "Section",
  CellTags->"s:2"],

Cell[TextData[{
  "The method ",
  StyleBox["DoubleStep", "MR"],
  " performs a single application of Richardson's extrapolation for any one \
step integration method and is described within ",
  StyleBox[ButtonBox["DoubleStep",
    ButtonData:>{"DoubleStep.nb", None},
    ButtonStyle->"Hyperlink"], "MR"],
  "."
}], "Text"],

Cell["\<\
Extrapolation generalizes the idea of Richardson's extrapolation to \
a sequence of refinements. A solution is computed over an interval using the \
same method with a varying number of steps and using extrapolation on the \
polynomial that fits through the computed solutions, giving a composite \
higher-order method. The polynomials at the same time provide a means of \
error estimation.\
\>", "Text"],

Cell["Consider a differential system", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(y\^\[Prime]\)(t)\  = \ f(t, \ y(t)), \ 
    y(t\_0)\  = \ \(\(y\_0\)\(.\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "Let ",
  StyleBox["H",
    FontSlant->"Italic"],
  " > 0 be a basic step size and choose a monotonically increasing sequence \
of positive integers"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`n\_1 < \ n\_2 < \ n\_3 < \ \[CenterEllipsis]\  < 
      n\_k\)], "DisplayFormula"],

Cell["and define the corresponding step sizes", "Text"],

Cell[BoxData[
    \(TraditionalForm\`h\_1 > \ h\_2 > \ h\_3 > \ \[CenterEllipsis] > 
      h\_k\)], "DisplayFormula"],

Cell["by", "Text"],

Cell[BoxData[
    \(TraditionalForm\`h\_i = \ H\/n\_i, i = 1, 
    2, \[Ellipsis], \(\(k\)\(.\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "Choose a numerical method of order ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and compute the solution of the initial value problem by carrying out ",
  Cell[BoxData[
      \(TraditionalForm\`n\_i\)]],
  " steps with step size ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i\)]],
  "to obtain:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`T\_\(i, 1\) = \ \(y\_\(h\_i\)\)(t\_o + \ H), i = 1, 
    2, \[Ellipsis], \(\(k\)\(.\)\)\)], "DisplayFormula"],

Cell["\<\
Extrapolation is performed using the Aitken-Neville algorithm by \
building up a table of values:\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`T\_\(i, \ j\) = \ 
      T\_\(i, \ j - 1\)\  + \ \(T\_\(i, \ j\  - \ 1\)\  - \ T\_\(i - 1, \ j\  \
- \ 1\)\)\/\(\((n\_i\/n\_\(i\  - \ j\  + \ 1\))\)\^p\  - \ 1\)\ , 
    i = 2, \[Ellipsis], k, 
    j\  = \ 2, \[Ellipsis], \(\(i\)\(.\)\)\)], "NumberedEquation",
  CellTags->"AitkenNeville"],

Cell["\<\
A dependency graph of the values illustrates the \
relationship:\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(T\_11\), " ", " ", " ", " ", " ", " ", " "},
          {" ", "\[UpperLeftArrow]", " ", " ", " ", " ", " ", " "},
          {\(T\_21\), "\[LongLeftArrow]", \(T\_22\), " ", " ", " ", " ", 
            " "},
          {" ", "\[UpperLeftArrow]", " ", "\[UpperLeftArrow]", " ", " ", " ", 
            " "},
          {\(T\_31\), "\[LongLeftArrow]", \(T\_32\), 
            "\[LongLeftArrow]", \(T\_33\), " ", " ", " "},
          {" ", "\[UpperLeftArrow]", "  ", "\[UpperLeftArrow]", " ", 
            "\[UpperLeftArrow]", " ", " "},
          {\(T\_41\), "\[LongLeftArrow]", \(T\_42\), 
            "\[LongLeftArrow]", \(T\_43\), "\[LongLeftArrow]", \(T\_44\), 
            " "},
          {"\[CenterEllipsis]", "\[CenterEllipsis]", "\[CenterEllipsis]", 
            "\[CenterEllipsis]", "\[CenterEllipsis]", "\[CenterEllipsis]", 
            "\[CenterEllipsis]", "\[CenterEllipsis]"}
          }], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "For ",
  StyleBox["k",
    FontSlant->"Italic"],
  " =2, ",
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)]],
  "= 1, ",
  Cell[BoxData[
      \(TraditionalForm\`n\_2\)]],
  "= 2 extrapolation is identical to Richardson's extrapolation."
}], "Text"],

Cell[CellGroupData[{

Cell["Extrapolation sequences", "Subsection"],

Cell["\<\
Any extrapolation sequence can be specified in the implementation. \
Some common choices are as follows.\
\>", "Text"],

Cell["This is the Romberg sequence.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`RombergSequenceFunction[1, \ 10]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({1, 2, 4, 8, 16, 32, 64, 128, 256, 512}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell["This is the Bulirsch sequence.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`BulirschSequenceFunction[1, \ 10]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({1, 2, 3, 4, 6, 8, 12, 16, 24, 32}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell["This is the Harmonic sequence.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`HarmonicSequenceFunction[1, \ 10]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9, 10}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
  "A sequence that satisfies ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\((n\_i/
                n\_\(i\  - \ j\  + \ 1\))\)\^p\)\(\[GreaterEqual]\)\(2\)\(\ \
\)\)\)]],
  " has the effect of minimizing the roundoff errors for an order-",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " base integration method."
}], "Text"],

Cell["\<\
For a base method of order two the first entries in the sequence \
are given by the following.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`OptimalRoundingSequenceFunction[1, \ 10, \ 2]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \({1, 2, 3, 5, 8, 12, 17, 25, 36, 51}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell["\<\
Here is an example of adding a function to define the Harmonic \
sequence is where the method order is an optional pattern.\
\>", "Text"],

Cell[BoxData[{
    \(\(\(Default[myseqfun, \ 3]\  = \ 1;\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(myseqfun[n1_, \ n2_, \ p_. ] := \ Range[n1, \ n2]\)}], "Input",
  CellLabel->"In[9]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rounding error accumulation", "Subsection"],

Cell[TextData[{
  "For high-order extrapolation an important consideration is the \
accumulation of rounding errors in the Aitken-Neville algorithm (",
  
  CounterBox["NumberedEquation", "AitkenNeville"],
  ")."
}], "Text"],

Cell[TextData[{
  "As an example consider Exercise 5 of Section II.9 in [",
  ButtonBox["HNW93",
    ButtonData:>{"References.nb", "HNW93"},
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "Suppose that the entries ",
  Cell[BoxData[
      \(TraditionalForm\`T\_11, \ T\_21, \ T\_31, \ \[Ellipsis]\)]],
  " are disturbed with rounding errors ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Epsilon]\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\)]],
  ", \[Ellipsis] and compute the propagation of these errors into the \
extrapolation table."
}], "Text"],

Cell[TextData[{
  "Due to the linearity of the extrapolation process ",
  "(",
  
  CounterBox["NumberedEquation", "AitkenNeville"],
  "),",
  " suppose that the ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i, \ j\)\)]],
  " are equal to zero and take ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon]\  = \ 1\)]],
  "."
}], "Text"],

Cell[TextData[{
  "This shows the evolution of the Aitken-Neville algorithm (",
  
  CounterBox["NumberedEquation", "AitkenNeville"],
  ") on the initial data using the Harmonic sequence and a symmetric \
order-two base integration method."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {"1.`", " ", " ", " ", " ", " ", " ", " "},
          {\(-1. \), \(-1.6666666666666665`\), " ", " ", " ", " ", " ", " "},
          {"1.", "2.6`", "3.1333333333333333`", " ", " ", " ", " ", " "},
          {\(-1. \), \(-3.5714285714285716`\), \(-5.628571428571429`\), \
\(-6.212698412698413`\), " ", " ", " ", " "},
          {"1.", "4.555555555555555`", "9.126984126984127`", 
            "11.937566137566137`", "12.693827160493827`", " ", " ", " "},
          {\(-1. \), \(-5.545454545454546`\), \(-13.626262626262626`\), \
\(-21.21067821067821`\), \(-25.354208754208756`\), \(-26.44129549462883`\), 
            " ", " "},
          {"1.", "6.538461538461538`", "19.125874125874127`", 
            "35.00569800569801`", "47.65438265438266`", "54.14403522403523`", 
            "55.822896280674065`", " "},
          {\(-1. \), \(-7.533333333333333`\), \(-25.625641025641023`\), \
\(-54.31250971250971`\), \(-84.08524561857895`\), \(-105.64263933597267`\), \
\(-116.29508430663986`\), \(-119.02711574453373`\)}
          }], TraditionalForm]], "DisplayFormula"],

Cell["\<\
Hence, for an order-sixteen method approximately two decimal digits \
are lost due to rounding error accumulation.\
\>", "Text"],

Cell[TextData[{
  "This model is somewhat crude because, as we will see later, it is more \
likely that rounding errors are made in ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i + 1, \ 1\)\)]],
  "than in ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i, \ 1\)\)]],
  "for ",
  StyleBox["i",
    FontSlant->"Italic"],
  " \[GreaterEqual] 1."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rounding error reduction", "Subsection"],

Cell["\<\
It seems worthwhile to look for approaches that can reduce the \
effect of rounding errors in high-order extrapolation.\
\>", "Text"],

Cell[TextData[{
  "Selecting a different step sequence to diminish rounding errors is one \
approach, although the drawback is that the number of integration steps \
needed to form the ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i\ , \ 1\)\)]],
  " in the first column of the extrapolation table requires more work."
}], "Text"],

Cell[TextData[{
  "An alternative strategy, which does not appear to have received a great \
deal of attention in the context of extrapolation, is to modify the \
base-integration method in order to reduce the magnitude of the rounding \
errors in floating-point operations. This approach, based on ideas that dated \
back to [",
  ButtonBox["G51",
    ButtonData:>{"References.nb", "G51"},
    ButtonStyle->"Hyperlink"],
  "] (see also [",
  ButtonBox["K65",
    ButtonData:>{"References.nb", "K65"},
    ButtonStyle->"Hyperlink"],
  "], [",
  ButtonBox["M65a",
    ButtonData:>{"References.nb", "M65a"},
    ButtonStyle->"Hyperlink"],
  "], [",
  ButtonBox["M65b",
    ButtonData:>{"References.nb", "M65b"},
    ButtonStyle->"Hyperlink"],
  "], [",
  ButtonBox["V79",
    ButtonData:>{"References.nb", "V79"},
    ButtonStyle->"Hyperlink"],
  "]), are explained next."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Base methods", "Section",
  CellTags->"s:3"],

Cell["\<\
The following methods are the most common choices for base \
integrators in extrapolation.\
\>", "Text"],

Cell[TextData[StyleBox["ExplicitEuler", "MR"]], "BulletedList"],

Cell[TextData[StyleBox["ExplicitMidpoint", "MR"]], "BulletedList"],

Cell[TextData[{
  StyleBox["ExplicitModifiedMidpoint", "MR"],
  " ",
  "(Gragg smoothing step)"
}], "BulletedList"],

Cell[TextData[StyleBox["LinearlyImplicitEuler", "MR"]], "BulletedList"],

Cell[TextData[{
  StyleBox["LinearlyImplicitMidpoint", "MR"],
  " (Bader-Deuflhard formulation without smoothing step)"
}], "BulletedList"],

Cell[TextData[{
  StyleBox["LinearlyImplicitModifiedMidpoint", "MR"],
  " (Bader-Deuflhard formulation with smoothing step)"
}], "BulletedList"],

Cell[TextData[{
  "For efficiency, these have been built into ",
  StyleBox["NDSolve", "MR"],
  " and are callable via the ",
  StyleBox["Method", "MR"],
  " option."
}], "Text"],

Cell[TextData[{
  "The implementation of these methods has a special interpretation for \
multiple substeps within ",
  StyleBox["DoubleStep", "MR"],
  " and ",
  StyleBox["Extrapolation", "MR"],
  "."
}], "Text"],

Cell[TextData[{
  "The methods are now described together with an increment reformulation \
that is used to reduce rounding error accumulation throughout ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Multiple Euler steps", "Subsection"],

Cell[TextData[{
  "Given ",
  Cell[BoxData[
      \(TraditionalForm\`t\_0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\_0\)]],
  " and ",
  StyleBox["H",
    FontSlant->"Italic"],
  ", consider a succession of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " integration steps with step size ",
  Cell[BoxData[
      \(TraditionalForm\`h\  = \ H/n\)]],
  " carried out using Euler's method:"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(y\_1\), "=", \(y\_0 + \ h\ \(f(t\_0, y\_0)\)\)},
          {\(y\_2\), "=", \(y\_1 + \ h\ \(f(t\_1, y\_1)\)\)},
          {\(y\_3\), "=", \(y\_2 + \ h\ \(f(t\_2, y\_2)\)\)},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
            "\[VerticalEllipsis]"},
          {\(y\_n\), 
            "=", \(y\_\(n - 1\) + \ h\ \(f(t\_\(n - 1\), y\_\(n - 1\))\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"EulerSteps"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`t\_i = \ t\_0 + \ i\ h\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Correspondence with explicit Runge-Kutta methods", "Subsubsection"],

Cell[TextData[{
  "It is well known that, for certain base integration schemes, the entries \
",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i, \ j\)\)]],
  " in the extrapolation table produced from (",
  
  CounterBox["NumberedEquation", "AitkenNeville"],
  ") correspond to explicit Runge-Kutta methods (see Exercise 1, Section II.9 \
in [",
  ButtonBox["HNW93",
    ButtonData:>{"References.nb", "HNW93"},
    ButtonStyle->"Hyperlink"],
  "])."
}], "Text"],

Cell[TextData[{
  "For example, (",
  
  CounterBox["NumberedEquation", "EulerSteps"],
  ") is equivalent to an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-stage explicit Runge-Kutta method:"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(k\_i\), 
            "=", \(\(f(t\_0 + \ c\_i\ h, \ 
              y\_0 + \ H\ \(\[Sum]\+\(i = 1\)\%n\( a\_\(i, \ j\)\) 
                      k\_j\))\)\(,\)\(\ \)\), \(i\  = \ 1, \[Ellipsis], 
            n, \)},
          {\(y\_n\), 
            "=", \(y\_0 + \ H\ \(\[Sum]\+\(i = 1\)\%n\( b\_i\) k\_i\)\), " "}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"ExplicitRungeKuttaMethod"],

Cell["where the coefficients are represented by the Butcher table:", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {"0", " ", " ", " ", " "},
          {\(1/n\), \(1/n\), " ", " ", " "},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
            "\[DescendingEllipsis]", " ", " "},
          {\(\((n - 1)\)/n\), \(1/n\), "\[CenterEllipsis]", \(1/n\), " "},
          {" ", \(1/n\), "\[CenterEllipsis]", \(1/n\), \(1/n\)}
          },
        RowLines->{False, False, False, True},
        ColumnLines->{True, False}], TraditionalForm]], "NumberedEquation",
  CellTags->"ExplicitRungeKuttaCoefficients"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reformulation", "Subsubsection"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]y\_n\)]],
  " = ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(n + 1\)\  - \ y\_n\)]],
  ". Then the integration (",
  
  CounterBox["NumberedEquation", "EulerSteps"],
  ") can be rewritten to reflect the correspondence with an explicit \
Runge-Kutta method (",
  
  CounterBox["NumberedEquation", "ExplicitRungeKuttaMethod"],
  ", ",
  
  CounterBox["NumberedEquation", "ExplicitRungeKuttaCoefficients"],
  ") as:"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\[CapitalDelta]y\_0\), "=", \(h\ \(f(t\_0, y\_0)\)\)},
          {\(\[CapitalDelta]y\_1\), 
            "=", \(h\ \(f(t\_1, y\_0 + \[CapitalDelta]y\_0)\)\)},
          {\(\[CapitalDelta]y\_2\), 
            "=", \(h\ \(f(t\_2, 
                y\_0 + \((\[CapitalDelta]y\_0 + \ \
\[CapitalDelta]y\_1)\))\)\)},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
            "\[VerticalEllipsis]"},
          {\(\[CapitalDelta]y\_\(n - 1\)\), 
            "=", \(h\ \(f(t\_\(n - 1\), 
                y\_0 + \((\[CapitalDelta]y\_0 + \ \[CapitalDelta]y\_1 + \
\[CenterEllipsis] + \[CapitalDelta]y\_\(n - 2\))\))\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"EulerIncrements"],

Cell[TextData[{
  "where terms in the right-hand side of (",
  
  CounterBox["NumberedEquation", "EulerIncrements"],
  ") are now considered as departures from the ",
  StyleBox["same",
    FontSlant->"Italic"],
  " ",
  StyleBox["value",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`y\_0\)]],
  "."
}], "Text"],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]y\_i\)]],
  " in (",
  
  CounterBox["NumberedEquation", "EulerIncrements"],
  ") correspond to the ",
  Cell[BoxData[
      \(TraditionalForm\`k\_i\)]],
  " in (",
  
  CounterBox["NumberedEquation", "ExplicitRungeKuttaMethod"],
  ")."
}], "Text"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalSigma]\[CapitalDelta]y\_n\  = \ \[Sum]\+\(i \
= 0\)\%\(n - 1\)\[CapitalDelta]y\_i\)]],
  ", then the required result can be recovered as:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y\_n = \ 
      y\_0 + \ \[CapitalSigma]\[CapitalDelta]y\_n\)], "NumberedEquation",
  CellTags->"EulerIncrementResult"],

Cell[TextData[{
  "Mathematically the formulations (",
  
  CounterBox["NumberedEquation", "EulerSteps"],
  ") and (",
  
  CounterBox["NumberedEquation", "EulerIncrements"],
  ", ",
  
  CounterBox["NumberedEquation", "EulerIncrementResult"],
  ") are equivalent. For ",
  StyleBox["n",
    FontSlant->"Italic"],
  " > 1, however, the computations in (",
  
  CounterBox["NumberedEquation", "EulerIncrements"],
  ") have the advantage of accumulating a sum of smaller ",
  StyleBox["O",
    FontSlant->"Italic"],
  "(",
  StyleBox["h",
    FontSlant->"Italic"],
  ") quantities, or increments, which reduces rounding error accumulation in \
finite-precision floating-point arithmetic."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multiple linearly implicit Euler steps", "Subsection"],

Cell["\<\
Next consider a succession of integration steps carried out using \
the linearly implicit Euler method. Increments arise naturally in the \
description of many semi-implicit and implicit methods.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\((I\  - \ h\ J)\) \[CapitalDelta]y\_0\), 
            "=", \(h\ \(f(t\_0, y\_0)\)\)},
          {\(y\_1\), "=", \(y\_0 + \ \[CapitalDelta]y\_0\)},
          {\(\((I\  - \ h\ J)\)\ \[CapitalDelta]y\_1\), 
            "=", \(h\ \(f(t\_1, y\_1)\)\)},
          {\(y\_2\), "=", \(y\_1 + \ \[CapitalDelta]y\_1\)},
          {\(\((I\  - \ h\ J)\) \[CapitalDelta]y\_2\), 
            "=", \(h\ \(f(t\_2, y\_2)\)\)},
          {\(y\_3\), "=", \(y\_2 + \[CapitalDelta]y\_2\)},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
            "\[VerticalEllipsis]"},
          {\(\((I\  - \ h\ J)\)\ \[CapitalDelta]y\_\(n - 1\)\), 
            "=", \(h\ \(f(t\_\(n - 1\), y\_\(n - 1\))\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"LinearlyImplicitEulerSteps"],

Cell[TextData[{
  "Here ",
  StyleBox["I",
    FontSlant->"Italic"],
  " denotes the Identity matrix and ",
  StyleBox["J",
    FontSlant->"Italic"],
  " denotes the Jacobian of ",
  StyleBox["f",
    FontSlant->"Italic"],
  ":"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`J = \(\[PartialD]f\/\[PartialD]y\) \(\((t\_0, 
            y\_0)\)\(.\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "The solution of the equations for the increments in (",
  
  CounterBox["NumberedEquation", "LinearlyImplicitEulerSteps"],
  ") is accomplished using a single LU decomposition of the matrix (",
  StyleBox["I",
    FontSlant->"Italic"],
  " - ",
  StyleBox["h J",
    FontSlant->"Italic"],
  ") followed by the solution of triangular linear systems for each \
right-hand side."
}], "Text"],

Cell[TextData[{
  "The desired result is obtained from (",
  
  CounterBox["NumberedEquation", "LinearlyImplicitEulerSteps"],
  ") as:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y\_n = 
      y\_\(n - 1\) + \[CapitalDelta]y\_\(n - 1\)\)], "DisplayFormula"],

Cell[CellGroupData[{

Cell["Reformulation", "Subsubsection"],

Cell[TextData[{
  "Reformulation in terms of increments as departures from ",
  Cell[BoxData[
      \(TraditionalForm\`y\_0\)]],
  " can be accomplished as follows:"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\((I - h\ J)\)\ \[CapitalDelta]y\_0\), 
            "=", \(h\ \(f(t\_0, y\_0)\)\)},
          {\(\((I - h\ J)\) \[CapitalDelta]y\_1\), 
            "=", \(h\ \(f(t\_1, y\_0 + \[CapitalDelta]y\_0)\)\)},
          {\(\((I - h\ J)\) \[CapitalDelta]y\_2\), 
            "=", \(h\ \(f(t\_2, 
                y\_0 + \((\[CapitalDelta]y\_0 + \ \
\[CapitalDelta]y\_1)\))\)\)},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
            "\[VerticalEllipsis]"},
          {\(\((I - h\ J)\) \[CapitalDelta]y\_\(n - 1\)\), 
            "=", \(h\ \(f(t\_\(n - 1\), 
                y\_0 + \((\[CapitalDelta]y\_0 + \ \[CapitalDelta]y\_1 + \
\[CenterEllipsis] + \[CapitalDelta]y\_\(n - 2\))\))\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"LinearlyImplicitEulerIncrements"],

Cell[TextData[{
  "The result for ",
  Cell[BoxData[
      \(TraditionalForm\`y\_n\)]],
  " using (",
  
  CounterBox["NumberedEquation", "LinearlyImplicitEulerIncrements"],
  ") is obtained from (",
  
  CounterBox["NumberedEquation", "EulerIncrementResult"],
  ")."
}], "Text"],

Cell[TextData[{
  "Notice that (",
  
  CounterBox["NumberedEquation", "LinearlyImplicitEulerIncrements"],
  ") and (",
  
  CounterBox["NumberedEquation", "EulerIncrements"],
  ") are equivalent when ",
  StyleBox["J",
    FontSlant->"Italic"],
  " = 0."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multiple explicit midpoint steps", "Subsection"],

Cell[TextData[{
  "\"Expansions in even powers of ",
  StyleBox["h",
    FontSlant->"Italic"],
  " are extremely important for an efficient implementation of Richardson's \
extrapolation\" [",
  ButtonBox["S70",
    ButtonData:>{"References.nb", "S70"},
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell["\<\
Consider a succession of integration steps carried out using one \
Euler step followed by multiple explicit midpoint steps:\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(y\_1\), "=", \(y\_0 + \ h\ \(f(t\_0, y\_0)\)\)},
          {\(y\_2\), "=", \(y\_0 + 2\ h\ \(f(t\_1, y\_1)\)\)},
          {\(y\_3\), "=", \(y\_1 + 2\ h\ \(f(t\_2, y\_2)\)\)},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
            "\[VerticalEllipsis]"},
          {\(y\_n\), 
            "=", \(y\_\(n - 2\) + 2\ h\ \(f(t\_\(n - 1\), y\_\(n - 1\))\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"ExplicitMidpointSteps"],

Cell[TextData[{
  "If (",
  
  CounterBox["NumberedEquation", "ExplicitMidpointSteps"],
  ") is computed with ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(2\ m\  - \ 1\)\)\)]],
  " midpoint steps, then the method has a symmetric error expansion ([",
  ButtonBox["G65",
    ButtonData:>{"References.nb", "G65"},
    ButtonStyle->"Hyperlink"],
  "], [",
  ButtonBox["S70",
    ButtonData:>{"References.nb", "S70"},
    ButtonStyle->"Hyperlink"],
  "])."
}], "Text"],

Cell[CellGroupData[{

Cell["Reformulation", "Subsubsection"],

Cell[TextData[{
  "Reformulation of (",
  
  CounterBox["NumberedEquation", "ExplicitMidpointSteps"],
  ") can be accomplished in terms of increments as:"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\[CapitalDelta]y\_0\), "=", \(h\ \(f(t\_0, y\_0)\)\)},
          {\(\[CapitalDelta]y\_1\), 
            "=", \(2  
                h\ \(f(t\_1, 
                  y\_0 + \[CapitalDelta]y\_0)\)\ \  - \ \
\[CapitalDelta]y\_0\)},
          {\(\[CapitalDelta]y\_2\), 
            "=", \(2  
                h\ \(f(t\_2, 
                  y\_0 + \((\[CapitalDelta]y\_0 + \ \[CapitalDelta]y\_1)\))\)\
\ \  - \ \[CapitalDelta]y\_1\)},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
            "\[VerticalEllipsis]"},
          {\(\[CapitalDelta]y\_\(n - 1\)\), 
            "=", \(2  
                h\ \(f(t\_\(n - 1\), 
                  y\_0 + \((\[CapitalDelta]y\_0 + \ \[CapitalDelta]y\_1 + \
\[CenterEllipsis] + \[CapitalDelta]y\_\(n - 2\))\))\)\ \  - \ \
\[CapitalDelta]y\_\(n - 2\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"ExplicitMidpointIncrements"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gragg's smoothing step", "Subsubsection"],

Cell[TextData[{
  "The ",
  StyleBox["smoothing step",
    FontSlant->"Italic"],
  " of Gragg has its historical origins in the weak stability of the explicit \
midpoint rule:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(Sy\_h\)(n)\  = \ 
      1/4\ \((y\_\(n - 1\) + \ 2\ y\_n + \ 
            y\_\(n + 1\))\)\)], "NumberedEquation",
  CellTags->"GraggSmoothingStep"],

Cell[TextData[{
  "In order to make use of (",
  
  CounterBox["NumberedEquation", "GraggSmoothingStep"],
  "), the formulation (",
  
  CounterBox["NumberedEquation", "ExplicitMidpointIncrements"],
  ") is computed with ",
  Cell[BoxData[
      \(TraditionalForm\`2\ m\)]],
  " steps. This has the advantage of increasing the stability domain and \
evaluating the function at the end of the basic step [",
  ButtonBox["HNW93",
    ButtonData:>{"References.nb", "HNW93"},
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell["\<\
Notice that because of the construction, a sum of increments is \
available at the end of the algorithm together with two consecutive \
increments. This leads to the following formulation:\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(S\[CapitalDelta]y\_h\)(
        n)\ \  = \ \(\(Sy\_h\)(n)\  - 
          y\_0 = \ \[CapitalSigma]\[CapitalDelta]y\_n\  + \ 
          1/4\ \ \(\((\[CapitalDelta]y\_n - \ \[CapitalDelta]y\_\(n - \
1\))\)\(.\)\)\)\)], "NumberedEquation",
  CellTags->"ModifiedGraggSmoothingStep"],

Cell[TextData[{
  "Moreover (",
  
  CounterBox["NumberedEquation", "ModifiedGraggSmoothingStep"],
  ") has an advantage over (",
  
  CounterBox["NumberedEquation", "GraggSmoothingStep"],
  ") in finite-precision arithmetic because the values ",
  Cell[BoxData[
      \(TraditionalForm\`y\_i\)]],
  ", which typically have a larger magnitude than the increments ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]y\_i\)]],
  ", do not contribute to the computation."
}], "Text"],

Cell[TextData[{
  "Gragg's smoothing step is not of great importance if the method is \
followed by extrapolation, and Shampine proposes an alternative smoothing \
procedure that is slightly more efficient [",
  ButtonBox["SB83",
    ButtonData:>{"References.nb", "SB83"},
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "The method ",
  StyleBox["ExplicitMidpoint", "MR"],
  " uses ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(2\ m\  - \ 1\)\)\)]],
  " steps and ",
  StyleBox["ExplicitModifiedMidpoint", "MR"],
  " uses ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(2\ m\)\)\)]],
  " steps followed by the smoothing step (",
  
  CounterBox["NumberedEquation", "ModifiedGraggSmoothingStep"],
  ")."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stability regions", "Subsubsection"],

Cell[TextData[{
  "This illustrates the effect of the smoothing step on the linear stability \
domain (carried out using the package ",
  StyleBox["NumericalMath`OrderStar`", "MR"],
  ")."
}], "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[.5 .48869 -117.688 0 ]
[.5 .48869 117.688 41.625 ]
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .48869 -178.688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 49.625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.688 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Linear) show
99.375 13.688 moveto
(stability) show
142.438 13.688 moveto
(regions) show
184.812 13.688 moveto
(for) show
202.000 13.688 moveto
(T) show
209.312 15.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
211.188 15.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
213.500 15.562 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
216.438 13.688 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
223.062 13.688 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
229.000 13.688 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(=) show
240.000 13.688 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
246.625 13.688 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
253.250 13.688 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\274) show
265.250 13.688 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
271.875 13.688 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
63.000 28.250 moveto
(for) show
80.188 28.250 moveto
(the) show
100.062 28.250 moveto
(explicit) show
143.125 28.250 moveto
(midpoint) show
194.750 28.250 moveto
(rule) show
%%IncludeResource: font Math2
%%IncludeFont: Math2
/Math2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
217.875 28.250 moveto
(H) show
221.688 28.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(left) show
%%IncludeResource: font Math2
%%IncludeFont: Math2
/Math2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
237.562 28.250 moveto
(L) show
244.688 28.250 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(and) show
267.875 28.250 moveto
(the) show
63.000 42.000 moveto
(explicit) show
106.062 42.000 moveto
(midpoint) show
157.688 42.000 moveto
(rule) show
180.812 42.000 moveto
(with) show
205.312 42.000 moveto
(smoothing) show
%%IncludeResource: font Math2
%%IncludeFont: Math2
/Math2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
263.625 42.000 moveto
(H) show
267.438 42.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(right) show
%%IncludeResource: font Math2
%%IncludeFont: Math2
/Math2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
290.562 42.000 moveto
(L) show
294.375 42.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0714286 0.5 0.0714286 [
[.07143 -0.0125 -6 -9 ]
[.07143 -0.0125 6 0 ]
[.21429 -0.0125 -6 -9 ]
[.21429 -0.0125 6 0 ]
[.35714 -0.0125 -6 -9 ]
[.35714 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.64286 -0.0125 -3 -9 ]
[.64286 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.92857 -0.0125 -3 -9 ]
[.92857 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .07143 -12 -4.5 ]
[-0.0125 .07143 0 4.5 ]
[-0.0125 .21429 -12 -4.5 ]
[-0.0125 .21429 0 4.5 ]
[-0.0125 .35714 -12 -4.5 ]
[-0.0125 .35714 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .64286 -6 -4.5 ]
[-0.0125 .64286 0 4.5 ]
[-0.0125 .78571 -6 -4.5 ]
[-0.0125 .78571 0 4.5 ]
[-0.0125 .92857 -6 -4.5 ]
[-0.0125 .92857 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07143 0 m
.07143 .00625 L
s
[(-6)] .07143 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(-4)] .21429 -0.0125 0 1 Mshowa
.35714 0 m
.35714 .00625 L
s
[(-2)] .35714 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.64286 0 m
.64286 .00625 L
s
[(2)] .64286 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(4)] .78571 -0.0125 0 1 Mshowa
.92857 0 m
.92857 .00625 L
s
[(6)] .92857 -0.0125 0 1 Mshowa
.125 Mabswid
.10714 0 m
.10714 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.17857 0 m
.17857 .00375 L
s
.25 0 m
.25 .00375 L
s
.28571 0 m
.28571 .00375 L
s
.32143 0 m
.32143 .00375 L
s
.39286 0 m
.39286 .00375 L
s
.42857 0 m
.42857 .00375 L
s
.46429 0 m
.46429 .00375 L
s
.53571 0 m
.53571 .00375 L
s
.57143 0 m
.57143 .00375 L
s
.60714 0 m
.60714 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.71429 0 m
.71429 .00375 L
s
.75 0 m
.75 .00375 L
s
.82143 0 m
.82143 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.89286 0 m
.89286 .00375 L
s
.03571 0 m
.03571 .00375 L
s
.96429 0 m
.96429 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07143 m
.00625 .07143 L
s
[(-6)] -0.0125 .07143 1 0 Mshowa
0 .21429 m
.00625 .21429 L
s
[(-4)] -0.0125 .21429 1 0 Mshowa
0 .35714 m
.00625 .35714 L
s
[(-2)] -0.0125 .35714 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .64286 m
.00625 .64286 L
s
[(2)] -0.0125 .64286 1 0 Mshowa
0 .78571 m
.00625 .78571 L
s
[(4)] -0.0125 .78571 1 0 Mshowa
0 .92857 m
.00625 .92857 L
s
[(6)] -0.0125 .92857 1 0 Mshowa
.125 Mabswid
0 .10714 m
.00375 .10714 L
s
0 .14286 m
.00375 .14286 L
s
0 .17857 m
.00375 .17857 L
s
0 .25 m
.00375 .25 L
s
0 .28571 m
.00375 .28571 L
s
0 .32143 m
.00375 .32143 L
s
0 .39286 m
.00375 .39286 L
s
0 .42857 m
.00375 .42857 L
s
0 .46429 m
.00375 .46429 L
s
0 .53571 m
.00375 .53571 L
s
0 .57143 m
.00375 .57143 L
s
0 .60714 m
.00375 .60714 L
s
0 .67857 m
.00375 .67857 L
s
0 .71429 m
.00375 .71429 L
s
0 .75 m
.00375 .75 L
s
0 .82143 m
.00375 .82143 L
s
0 .85714 m
.00375 .85714 L
s
0 .89286 m
.00375 .89286 L
s
0 .03571 m
.00375 .03571 L
s
0 .96429 m
.00375 .96429 L
s
.25 Mabswid
0 0 m
0 1 L
s
.07143 .99375 m
.07143 1 L
s
.21429 .99375 m
.21429 1 L
s
.35714 .99375 m
.35714 1 L
s
.5 .99375 m
.5 1 L
s
.64286 .99375 m
.64286 1 L
s
.78571 .99375 m
.78571 1 L
s
.92857 .99375 m
.92857 1 L
s
.125 Mabswid
.10714 .99625 m
.10714 1 L
s
.14286 .99625 m
.14286 1 L
s
.17857 .99625 m
.17857 1 L
s
.25 .99625 m
.25 1 L
s
.28571 .99625 m
.28571 1 L
s
.32143 .99625 m
.32143 1 L
s
.39286 .99625 m
.39286 1 L
s
.42857 .99625 m
.42857 1 L
s
.46429 .99625 m
.46429 1 L
s
.53571 .99625 m
.53571 1 L
s
.57143 .99625 m
.57143 1 L
s
.60714 .99625 m
.60714 1 L
s
.67857 .99625 m
.67857 1 L
s
.71429 .99625 m
.71429 1 L
s
.75 .99625 m
.75 1 L
s
.82143 .99625 m
.82143 1 L
s
.85714 .99625 m
.85714 1 L
s
.89286 .99625 m
.89286 1 L
s
.03571 .99625 m
.03571 1 L
s
.96429 .99625 m
.96429 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .07143 m
1 .07143 L
s
.99375 .21429 m
1 .21429 L
s
.99375 .35714 m
1 .35714 L
s
.99375 .5 m
1 .5 L
s
.99375 .64286 m
1 .64286 L
s
.99375 .78571 m
1 .78571 L
s
.99375 .92857 m
1 .92857 L
s
.125 Mabswid
.99625 .10714 m
1 .10714 L
s
.99625 .14286 m
1 .14286 L
s
.99625 .17857 m
1 .17857 L
s
.99625 .25 m
1 .25 L
s
.99625 .28571 m
1 .28571 L
s
.99625 .32143 m
1 .32143 L
s
.99625 .39286 m
1 .39286 L
s
.99625 .42857 m
1 .42857 L
s
.99625 .46429 m
1 .46429 L
s
.99625 .53571 m
1 .53571 L
s
.99625 .57143 m
1 .57143 L
s
.99625 .60714 m
1 .60714 L
s
.99625 .67857 m
1 .67857 L
s
.99625 .71429 m
1 .71429 L
s
.99625 .75 m
1 .75 L
s
.99625 .82143 m
1 .82143 L
s
.99625 .85714 m
1 .85714 L
s
.99625 .89286 m
1 .89286 L
s
.99625 .03571 m
1 .03571 L
s
.99625 .96429 m
1 .96429 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.40816 .37959 m
.42857 .37625 L
.44898 .37959 L
.46683 .38776 L
.46939 .3906 L
.48418 .40816 L
.4898 .41623 L
.49358 .42857 L
.49813 .44898 L
.49983 .46939 L
.50017 .4898 L
.50017 .5102 L
.49983 .53061 L
.49813 .55102 L
.49358 .57143 L
.4898 .58377 L
.48418 .59184 L
.46939 .6094 L
.46683 .61224 L
.44898 .62041 L
.42857 .62375 L
.40816 .62041 L
.39031 .61224 L
.38776 .6094 L
.37296 .59184 L
.36735 .58377 L
.36356 .57143 L
.35901 .55102 L
.35731 .53061 L
.35697 .5102 L
.35697 .4898 L
.35731 .46939 L
.35901 .44898 L
.36356 .42857 L
.36735 .41623 L
.37296 .40816 L
.38776 .3906 L
.39031 .38776 L
.40816 .37959 L
s
.44898 .29717 m
.46939 .29066 L
.4898 .28836 L
.50815 .30612 L
.5102 .3095 L
.51639 .32653 L
.51653 .34694 L
.51123 .36735 L
.5102 .37015 L
.50589 .38776 L
.50204 .40816 L
.50051 .42857 L
.50011 .44898 L
.50006 .46939 L
.50007 .4898 L
.50007 .5102 L
.50006 .53061 L
.50011 .55102 L
.50051 .57143 L
.50204 .59184 L
.50589 .61224 L
.5102 .62985 L
.51123 .63265 L
.51653 .65306 L
.51639 .67347 L
.5102 .6905 L
.50815 .69388 L
.4898 .71164 L
.46939 .70934 L
.44898 .70283 L
.43987 .69388 L
.42857 .68353 L
.41948 .67347 L
.40816 .66354 L
.39238 .65306 L
.38776 .65044 L
.36735 .63897 L
.3567 .63265 L
.34694 .62524 L
.33251 .61224 L
.32653 .60495 L
.31808 .59184 L
.3093 .57143 L
.30612 .56176 L
.30435 .55102 L
.30189 .53061 L
.30098 .5102 L
.30098 .4898 L
.30189 .46939 L
.30435 .44898 L
Mistroke
.30612 .43824 L
.3093 .42857 L
.31808 .40816 L
.32653 .39505 L
.33251 .38776 L
.34694 .37476 L
.3567 .36735 L
.36735 .36103 L
.38776 .34956 L
.39238 .34694 L
.40816 .33646 L
.41948 .32653 L
.42857 .31647 L
.43987 .30612 L
.44898 .29717 L
Mfstroke
.55102 .73954 m
.57143 .75441 L
.57163 .7551 L
.57143 .76496 L
.56448 .77551 L
.55102 .779 L
.54285 .77551 L
.53412 .7551 L
.55102 .73954 L
s
.36735 .28201 m
.38776 .27441 L
.40816 .27213 L
.42857 .2741 L
.44898 .2804 L
.45988 .28571 L
.46939 .2911 L
.48402 .30612 L
.4898 .31627 L
.49315 .32653 L
.49714 .34694 L
.49897 .36735 L
.49973 .38776 L
.49999 .40816 L
.50006 .42857 L
.50007 .44898 L
.50007 .46939 L
.50007 .4898 L
.50007 .5102 L
.50007 .53061 L
.50007 .55102 L
.50006 .57143 L
.49999 .59184 L
.49973 .61224 L
.49897 .63265 L
.49714 .65306 L
.49315 .67347 L
.4898 .68373 L
.48402 .69388 L
.46939 .7089 L
.45988 .71429 L
.44898 .7196 L
.42857 .7259 L
.40816 .72787 L
.38776 .72559 L
.36735 .71799 L
.36055 .71429 L
.34694 .7046 L
.33626 .69388 L
.32653 .6834 L
.31822 .67347 L
.30612 .65876 L
.30141 .65306 L
.28571 .63277 L
.28563 .63265 L
.27167 .61224 L
.26531 .60006 L
.26153 .59184 L
.25419 .57143 L
.24966 .55102 L
Mistroke
.2472 .53061 L
.24618 .5102 L
.24618 .4898 L
.2472 .46939 L
.24966 .44898 L
.25419 .42857 L
.26153 .40816 L
.26531 .39994 L
.27167 .38776 L
.28563 .36735 L
.28571 .36723 L
.30141 .34694 L
.30612 .34124 L
.31822 .32653 L
.32653 .3166 L
.33626 .30612 L
.34694 .2954 L
.36055 .28571 L
.36735 .28201 L
Mfstroke
.55102 .221 m
.56448 .22449 L
.57143 .23504 L
.57163 .2449 L
.57143 .24559 L
.55102 .26046 L
.53412 .2449 L
.54285 .22449 L
.55102 .221 L
s
.42857 .19544 m
.44898 .19488 L
.46939 .20258 L
.47165 .20408 L
.4898 .22441 L
.48983 .22449 L
.49778 .2449 L
.50093 .26531 L
.50149 .28571 L
.50106 .30612 L
.50055 .32653 L
.50025 .34694 L
.50012 .36735 L
.50008 .38776 L
.50007 .40816 L
.50007 .42857 L
.50007 .44898 L
.50007 .46939 L
.50007 .4898 L
.50007 .5102 L
.50007 .53061 L
.50007 .55102 L
.50007 .57143 L
.50007 .59184 L
.50008 .61224 L
.50012 .63265 L
.50025 .65306 L
.50055 .67347 L
.50106 .69388 L
.50149 .71429 L
.50093 .73469 L
.49778 .7551 L
.48983 .77551 L
.4898 .77559 L
.47165 .79592 L
.46939 .79742 L
.44898 .80512 L
.42857 .80456 L
.4092 .79592 L
.40816 .79532 L
.38776 .78253 L
.37826 .77551 L
.36735 .76893 L
.34694 .758 L
.34117 .7551 L
.32653 .7479 L
.30612 .73598 L
.30413 .73469 L
.28571 .72066 L
.27895 .71429 L
Mistroke
.26531 .69922 L
.26112 .69388 L
.24674 .67347 L
.2449 .67055 L
.23394 .65306 L
.22449 .6356 L
.22289 .63265 L
.2128 .61224 L
.20523 .59184 L
.20408 .58826 L
.19927 .57143 L
.19513 .55102 L
.19267 .53061 L
.19155 .5102 L
.19155 .4898 L
.19267 .46939 L
.19513 .44898 L
.19927 .42857 L
.20408 .41174 L
.20523 .40816 L
.2128 .38776 L
.22289 .36735 L
.22449 .3644 L
.23394 .34694 L
.2449 .32945 L
.24674 .32653 L
.26112 .30612 L
.26531 .30078 L
.27895 .28571 L
.28571 .27934 L
.30413 .26531 L
.30612 .26402 L
.32653 .2521 L
.34117 .2449 L
.34694 .242 L
.36735 .23107 L
.37826 .22449 L
.38776 .21747 L
.40816 .20468 L
.4092 .20408 L
.42857 .19544 L
Mfstroke
.46939 .14266 m
.4898 .12667 L
.5102 .12511 L
.52836 .14286 L
.52869 .16327 L
.51955 .18367 L
.5102 .1989 L
.5082 .20408 L
.50211 .22449 L
.5003 .2449 L
.49992 .26531 L
.49993 .28571 L
.5 .30612 L
.50004 .32653 L
.50006 .34694 L
.50006 .36735 L
.50007 .38776 L
.50007 .40816 L
.50007 .42857 L
.50007 .44898 L
.50007 .46939 L
.50007 .4898 L
.50007 .5102 L
.50007 .53061 L
.50007 .55102 L
.50007 .57143 L
.50007 .59184 L
.50007 .61224 L
.50006 .63265 L
.50006 .65306 L
.50004 .67347 L
.5 .69388 L
.49993 .71429 L
.49992 .73469 L
.5003 .7551 L
.50211 .77551 L
.5082 .79592 L
.5102 .8011 L
.51955 .81633 L
.52869 .83673 L
.52836 .85714 L
.5102 .87489 L
.4898 .87333 L
.46939 .85734 L
.46921 .85714 L
.44898 .83962 L
.44419 .83673 L
.42857 .8342 L
.40816 .83337 L
.38776 .83285 L
Mistroke
.36735 .8307 L
.34694 .82568 L
.32655 .81633 L
.32653 .81632 L
.30612 .80394 L
.29596 .79592 L
.28571 .78804 L
.27083 .77551 L
.26531 .77095 L
.24715 .7551 L
.2449 .75304 L
.22621 .73469 L
.22449 .73279 L
.20877 .71429 L
.20408 .70776 L
.19461 .69388 L
.18367 .67471 L
.18298 .67347 L
.17232 .65306 L
.16366 .63265 L
.16327 .6316 L
.15558 .61224 L
.14913 .59184 L
.1445 .57143 L
.14286 .56217 L
.14113 .55102 L
.13882 .53061 L
.13772 .5102 L
.13772 .4898 L
.13882 .46939 L
.14113 .44898 L
.14286 .43783 L
.1445 .42857 L
.14913 .40816 L
.15558 .38776 L
.16327 .3684 L
.16366 .36735 L
.17232 .34694 L
.18298 .32653 L
.18367 .32529 L
.19461 .30612 L
.20408 .29224 L
.20877 .28571 L
.22449 .26721 L
.22621 .26531 L
.2449 .24696 L
.24715 .2449 L
.26531 .22905 L
.27083 .22449 L
.28571 .21196 L
Mistroke
.29596 .20408 L
.30612 .19606 L
.32653 .18368 L
.32655 .18367 L
.34694 .17432 L
.36735 .1693 L
.38776 .16715 L
.40816 .16663 L
.42857 .1658 L
.44419 .16327 L
.44898 .16038 L
.46921 .14286 L
.46939 .14266 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0714286 0.5 0.0714286 [
[.07143 -0.0125 -6 -9 ]
[.07143 -0.0125 6 0 ]
[.21429 -0.0125 -6 -9 ]
[.21429 -0.0125 6 0 ]
[.35714 -0.0125 -6 -9 ]
[.35714 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.64286 -0.0125 -3 -9 ]
[.64286 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.92857 -0.0125 -3 -9 ]
[.92857 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .07143 -12 -4.5 ]
[-0.0125 .07143 0 4.5 ]
[-0.0125 .21429 -12 -4.5 ]
[-0.0125 .21429 0 4.5 ]
[-0.0125 .35714 -12 -4.5 ]
[-0.0125 .35714 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .64286 -6 -4.5 ]
[-0.0125 .64286 0 4.5 ]
[-0.0125 .78571 -6 -4.5 ]
[-0.0125 .78571 0 4.5 ]
[-0.0125 .92857 -6 -4.5 ]
[-0.0125 .92857 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07143 0 m
.07143 .00625 L
s
[(-6)] .07143 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(-4)] .21429 -0.0125 0 1 Mshowa
.35714 0 m
.35714 .00625 L
s
[(-2)] .35714 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.64286 0 m
.64286 .00625 L
s
[(2)] .64286 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(4)] .78571 -0.0125 0 1 Mshowa
.92857 0 m
.92857 .00625 L
s
[(6)] .92857 -0.0125 0 1 Mshowa
.125 Mabswid
.10714 0 m
.10714 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.17857 0 m
.17857 .00375 L
s
.25 0 m
.25 .00375 L
s
.28571 0 m
.28571 .00375 L
s
.32143 0 m
.32143 .00375 L
s
.39286 0 m
.39286 .00375 L
s
.42857 0 m
.42857 .00375 L
s
.46429 0 m
.46429 .00375 L
s
.53571 0 m
.53571 .00375 L
s
.57143 0 m
.57143 .00375 L
s
.60714 0 m
.60714 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.71429 0 m
.71429 .00375 L
s
.75 0 m
.75 .00375 L
s
.82143 0 m
.82143 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.89286 0 m
.89286 .00375 L
s
.03571 0 m
.03571 .00375 L
s
.96429 0 m
.96429 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07143 m
.00625 .07143 L
s
[(-6)] -0.0125 .07143 1 0 Mshowa
0 .21429 m
.00625 .21429 L
s
[(-4)] -0.0125 .21429 1 0 Mshowa
0 .35714 m
.00625 .35714 L
s
[(-2)] -0.0125 .35714 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .64286 m
.00625 .64286 L
s
[(2)] -0.0125 .64286 1 0 Mshowa
0 .78571 m
.00625 .78571 L
s
[(4)] -0.0125 .78571 1 0 Mshowa
0 .92857 m
.00625 .92857 L
s
[(6)] -0.0125 .92857 1 0 Mshowa
.125 Mabswid
0 .10714 m
.00375 .10714 L
s
0 .14286 m
.00375 .14286 L
s
0 .17857 m
.00375 .17857 L
s
0 .25 m
.00375 .25 L
s
0 .28571 m
.00375 .28571 L
s
0 .32143 m
.00375 .32143 L
s
0 .39286 m
.00375 .39286 L
s
0 .42857 m
.00375 .42857 L
s
0 .46429 m
.00375 .46429 L
s
0 .53571 m
.00375 .53571 L
s
0 .57143 m
.00375 .57143 L
s
0 .60714 m
.00375 .60714 L
s
0 .67857 m
.00375 .67857 L
s
0 .71429 m
.00375 .71429 L
s
0 .75 m
.00375 .75 L
s
0 .82143 m
.00375 .82143 L
s
0 .85714 m
.00375 .85714 L
s
0 .89286 m
.00375 .89286 L
s
0 .03571 m
.00375 .03571 L
s
0 .96429 m
.00375 .96429 L
s
.25 Mabswid
0 0 m
0 1 L
s
.07143 .99375 m
.07143 1 L
s
.21429 .99375 m
.21429 1 L
s
.35714 .99375 m
.35714 1 L
s
.5 .99375 m
.5 1 L
s
.64286 .99375 m
.64286 1 L
s
.78571 .99375 m
.78571 1 L
s
.92857 .99375 m
.92857 1 L
s
.125 Mabswid
.10714 .99625 m
.10714 1 L
s
.14286 .99625 m
.14286 1 L
s
.17857 .99625 m
.17857 1 L
s
.25 .99625 m
.25 1 L
s
.28571 .99625 m
.28571 1 L
s
.32143 .99625 m
.32143 1 L
s
.39286 .99625 m
.39286 1 L
s
.42857 .99625 m
.42857 1 L
s
.46429 .99625 m
.46429 1 L
s
.53571 .99625 m
.53571 1 L
s
.57143 .99625 m
.57143 1 L
s
.60714 .99625 m
.60714 1 L
s
.67857 .99625 m
.67857 1 L
s
.71429 .99625 m
.71429 1 L
s
.75 .99625 m
.75 1 L
s
.82143 .99625 m
.82143 1 L
s
.85714 .99625 m
.85714 1 L
s
.89286 .99625 m
.89286 1 L
s
.03571 .99625 m
.03571 1 L
s
.96429 .99625 m
.96429 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .07143 m
1 .07143 L
s
.99375 .21429 m
1 .21429 L
s
.99375 .35714 m
1 .35714 L
s
.99375 .5 m
1 .5 L
s
.99375 .64286 m
1 .64286 L
s
.99375 .78571 m
1 .78571 L
s
.99375 .92857 m
1 .92857 L
s
.125 Mabswid
.99625 .10714 m
1 .10714 L
s
.99625 .14286 m
1 .14286 L
s
.99625 .17857 m
1 .17857 L
s
.99625 .25 m
1 .25 L
s
.99625 .28571 m
1 .28571 L
s
.99625 .32143 m
1 .32143 L
s
.99625 .39286 m
1 .39286 L
s
.99625 .42857 m
1 .42857 L
s
.99625 .46429 m
1 .46429 L
s
.99625 .53571 m
1 .53571 L
s
.99625 .57143 m
1 .57143 L
s
.99625 .60714 m
1 .60714 L
s
.99625 .67857 m
1 .67857 L
s
.99625 .71429 m
1 .71429 L
s
.99625 .75 m
1 .75 L
s
.99625 .82143 m
1 .82143 L
s
.99625 .85714 m
1 .85714 L
s
.99625 .89286 m
1 .89286 L
s
.99625 .03571 m
1 .03571 L
s
.99625 .96429 m
1 .96429 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0714286 0.5 0.0714286 [
[.07143 -0.0125 -6 -9 ]
[.07143 -0.0125 6 0 ]
[.21429 -0.0125 -6 -9 ]
[.21429 -0.0125 6 0 ]
[.35714 -0.0125 -6 -9 ]
[.35714 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.64286 -0.0125 -3 -9 ]
[.64286 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.92857 -0.0125 -3 -9 ]
[.92857 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .07143 -12 -4.5 ]
[-0.0125 .07143 0 4.5 ]
[-0.0125 .21429 -12 -4.5 ]
[-0.0125 .21429 0 4.5 ]
[-0.0125 .35714 -12 -4.5 ]
[-0.0125 .35714 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .64286 -6 -4.5 ]
[-0.0125 .64286 0 4.5 ]
[-0.0125 .78571 -6 -4.5 ]
[-0.0125 .78571 0 4.5 ]
[-0.0125 .92857 -6 -4.5 ]
[-0.0125 .92857 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07143 0 m
.07143 .00625 L
s
[(-6)] .07143 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(-4)] .21429 -0.0125 0 1 Mshowa
.35714 0 m
.35714 .00625 L
s
[(-2)] .35714 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.64286 0 m
.64286 .00625 L
s
[(2)] .64286 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(4)] .78571 -0.0125 0 1 Mshowa
.92857 0 m
.92857 .00625 L
s
[(6)] .92857 -0.0125 0 1 Mshowa
.125 Mabswid
.10714 0 m
.10714 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.17857 0 m
.17857 .00375 L
s
.25 0 m
.25 .00375 L
s
.28571 0 m
.28571 .00375 L
s
.32143 0 m
.32143 .00375 L
s
.39286 0 m
.39286 .00375 L
s
.42857 0 m
.42857 .00375 L
s
.46429 0 m
.46429 .00375 L
s
.53571 0 m
.53571 .00375 L
s
.57143 0 m
.57143 .00375 L
s
.60714 0 m
.60714 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.71429 0 m
.71429 .00375 L
s
.75 0 m
.75 .00375 L
s
.82143 0 m
.82143 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.89286 0 m
.89286 .00375 L
s
.03571 0 m
.03571 .00375 L
s
.96429 0 m
.96429 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07143 m
.00625 .07143 L
s
[(-6)] -0.0125 .07143 1 0 Mshowa
0 .21429 m
.00625 .21429 L
s
[(-4)] -0.0125 .21429 1 0 Mshowa
0 .35714 m
.00625 .35714 L
s
[(-2)] -0.0125 .35714 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .64286 m
.00625 .64286 L
s
[(2)] -0.0125 .64286 1 0 Mshowa
0 .78571 m
.00625 .78571 L
s
[(4)] -0.0125 .78571 1 0 Mshowa
0 .92857 m
.00625 .92857 L
s
[(6)] -0.0125 .92857 1 0 Mshowa
.125 Mabswid
0 .10714 m
.00375 .10714 L
s
0 .14286 m
.00375 .14286 L
s
0 .17857 m
.00375 .17857 L
s
0 .25 m
.00375 .25 L
s
0 .28571 m
.00375 .28571 L
s
0 .32143 m
.00375 .32143 L
s
0 .39286 m
.00375 .39286 L
s
0 .42857 m
.00375 .42857 L
s
0 .46429 m
.00375 .46429 L
s
0 .53571 m
.00375 .53571 L
s
0 .57143 m
.00375 .57143 L
s
0 .60714 m
.00375 .60714 L
s
0 .67857 m
.00375 .67857 L
s
0 .71429 m
.00375 .71429 L
s
0 .75 m
.00375 .75 L
s
0 .82143 m
.00375 .82143 L
s
0 .85714 m
.00375 .85714 L
s
0 .89286 m
.00375 .89286 L
s
0 .03571 m
.00375 .03571 L
s
0 .96429 m
.00375 .96429 L
s
.25 Mabswid
0 0 m
0 1 L
s
.07143 .99375 m
.07143 1 L
s
.21429 .99375 m
.21429 1 L
s
.35714 .99375 m
.35714 1 L
s
.5 .99375 m
.5 1 L
s
.64286 .99375 m
.64286 1 L
s
.78571 .99375 m
.78571 1 L
s
.92857 .99375 m
.92857 1 L
s
.125 Mabswid
.10714 .99625 m
.10714 1 L
s
.14286 .99625 m
.14286 1 L
s
.17857 .99625 m
.17857 1 L
s
.25 .99625 m
.25 1 L
s
.28571 .99625 m
.28571 1 L
s
.32143 .99625 m
.32143 1 L
s
.39286 .99625 m
.39286 1 L
s
.42857 .99625 m
.42857 1 L
s
.46429 .99625 m
.46429 1 L
s
.53571 .99625 m
.53571 1 L
s
.57143 .99625 m
.57143 1 L
s
.60714 .99625 m
.60714 1 L
s
.67857 .99625 m
.67857 1 L
s
.71429 .99625 m
.71429 1 L
s
.75 .99625 m
.75 1 L
s
.82143 .99625 m
.82143 1 L
s
.85714 .99625 m
.85714 1 L
s
.89286 .99625 m
.89286 1 L
s
.03571 .99625 m
.03571 1 L
s
.96429 .99625 m
.96429 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .07143 m
1 .07143 L
s
.99375 .21429 m
1 .21429 L
s
.99375 .35714 m
1 .35714 L
s
.99375 .5 m
1 .5 L
s
.99375 .64286 m
1 .64286 L
s
.99375 .78571 m
1 .78571 L
s
.99375 .92857 m
1 .92857 L
s
.125 Mabswid
.99625 .10714 m
1 .10714 L
s
.99625 .14286 m
1 .14286 L
s
.99625 .17857 m
1 .17857 L
s
.99625 .25 m
1 .25 L
s
.99625 .28571 m
1 .28571 L
s
.99625 .32143 m
1 .32143 L
s
.99625 .39286 m
1 .39286 L
s
.99625 .42857 m
1 .42857 L
s
.99625 .46429 m
1 .46429 L
s
.99625 .53571 m
1 .53571 L
s
.99625 .57143 m
1 .57143 L
s
.99625 .60714 m
1 .60714 L
s
.99625 .67857 m
1 .67857 L
s
.99625 .71429 m
1 .71429 L
s
.99625 .75 m
1 .75 L
s
.99625 .82143 m
1 .82143 L
s
.99625 .85714 m
1 .85714 L
s
.99625 .89286 m
1 .89286 L
s
.99625 .03571 m
1 .03571 L
s
.99625 .96429 m
1 .96429 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.40816 .32627 m
.42857 .32473 L
.43968 .32653 L
.44898 .32922 L
.46939 .34206 L
.47404 .34694 L
.48751 .36735 L
.4898 .37266 L
.49464 .38776 L
.4982 .40816 L
.49966 .42857 L
.50006 .44898 L
.5001 .46939 L
.50008 .4898 L
.50008 .5102 L
.5001 .53061 L
.50006 .55102 L
.49966 .57143 L
.4982 .59184 L
.49464 .61224 L
.4898 .62734 L
.48751 .63265 L
.47404 .65306 L
.46939 .65794 L
.44898 .67078 L
.43968 .67347 L
.42857 .67527 L
.40816 .67373 L
.40704 .67347 L
.38776 .66675 L
.36824 .65306 L
.36735 .65237 L
.34754 .63265 L
.34694 .63199 L
.33039 .61224 L
.32653 .60737 L
.31462 .59184 L
.30612 .57945 L
.301 .57143 L
.29037 .55102 L
.28571 .53931 L
.28341 .53061 L
.27986 .5102 L
.27986 .4898 L
.28341 .46939 L
.28571 .46069 L
.29037 .44898 L
.301 .42857 L
.30612 .42055 L
.31462 .40816 L
Mistroke
.32653 .39263 L
.33039 .38776 L
.34694 .36801 L
.34754 .36735 L
.36735 .34763 L
.36824 .34694 L
.38776 .33325 L
.40704 .32653 L
.40816 .32627 L
Mfstroke
.46939 .25725 m
.4898 .25668 L
.50906 .26531 L
.5102 .26627 L
.52254 .28571 L
.52539 .30612 L
.52014 .32653 L
.51142 .34694 L
.5102 .34963 L
.50539 .36735 L
.50201 .38776 L
.50063 .40816 L
.50018 .42857 L
.50007 .44898 L
.50006 .46939 L
.50007 .4898 L
.50007 .5102 L
.50006 .53061 L
.50007 .55102 L
.50018 .57143 L
.50063 .59184 L
.50201 .61224 L
.50539 .63265 L
.5102 .65037 L
.51142 .65306 L
.52014 .67347 L
.52539 .69388 L
.52254 .71429 L
.5102 .73373 L
.50906 .73469 L
.4898 .74332 L
.46939 .74275 L
.4525 .73469 L
.44898 .73166 L
.42857 .71812 L
.42271 .71429 L
.40816 .70717 L
.38776 .70038 L
.36735 .69516 L
.36233 .69388 L
.34694 .68972 L
.32653 .68279 L
.30633 .67347 L
.30612 .67335 L
.28571 .66104 L
.27504 .65306 L
.26531 .64496 L
.25234 .63265 L
.2449 .62495 L
.2335 .61224 L
Mistroke
.22449 .60122 L
.21716 .59184 L
.20408 .57227 L
.20356 .57143 L
.19253 .55102 L
.18552 .53061 L
.18367 .52179 L
.18201 .5102 L
.18201 .4898 L
.18367 .47821 L
.18552 .46939 L
.19253 .44898 L
.20356 .42857 L
.20408 .42773 L
.21716 .40816 L
.22449 .39878 L
.2335 .38776 L
.2449 .37505 L
.25234 .36735 L
.26531 .35504 L
.27504 .34694 L
.28571 .33896 L
.30612 .32665 L
.30633 .32653 L
.32653 .31721 L
.34694 .31028 L
.36233 .30612 L
.36735 .30484 L
.38776 .29962 L
.40816 .29283 L
.42271 .28571 L
.42857 .28188 L
.44898 .26834 L
.4525 .26531 L
.46939 .25725 L
Mfstroke
.57143 .77183 m
.57744 .77551 L
.58445 .79592 L
.57143 .80606 L
.55419 .79592 L
.55746 .77551 L
.57143 .77183 L
s
.36735 .24137 m
.38776 .23797 L
.40816 .23862 L
.42857 .24333 L
.43317 .2449 L
.44898 .25165 L
.46833 .26531 L
.46939 .26613 L
.48499 .28571 L
.4898 .29563 L
.49295 .30612 L
.49685 .32653 L
.49875 .34694 L
.49961 .36735 L
.49994 .38776 L
.50004 .40816 L
.50006 .42857 L
.50007 .44898 L
.50007 .46939 L
.50007 .4898 L
.50007 .5102 L
.50007 .53061 L
.50007 .55102 L
.50006 .57143 L
.50004 .59184 L
.49994 .61224 L
.49961 .63265 L
.49875 .65306 L
.49685 .67347 L
.49295 .69388 L
.4898 .70437 L
.48499 .71429 L
.46939 .73387 L
.46833 .73469 L
.44898 .74835 L
.43317 .7551 L
.42857 .75667 L
.40816 .76138 L
.38776 .76203 L
.36735 .75863 L
.35483 .7551 L
.34694 .7515 L
.32653 .7401 L
.31863 .73469 L
.30612 .72612 L
.29046 .71429 L
.28571 .71078 L
.26531 .69514 L
.26369 .69388 L
.2449 .67884 L
Mistroke
.23855 .67347 L
.22449 .66097 L
.21619 .65306 L
.20408 .64089 L
.19636 .63265 L
.18367 .61876 L
.17785 .61224 L
.16327 .59639 L
.15891 .59184 L
.14286 .57655 L
.13689 .57143 L
.12245 .56013 L
.10963 .55102 L
.10204 .54407 L
.08979 .53061 L
.08163 .51487 L
.08026 .5102 L
.08026 .4898 L
.08163 .48513 L
.08979 .46939 L
.10204 .45593 L
.10963 .44898 L
.12245 .43987 L
.13689 .42857 L
.14286 .42345 L
.15891 .40816 L
.16327 .40361 L
.17785 .38776 L
.18367 .38124 L
.19636 .36735 L
.20408 .35911 L
.21619 .34694 L
.22449 .33903 L
.23855 .32653 L
.2449 .32116 L
.26369 .30612 L
.26531 .30486 L
.28571 .28922 L
.29046 .28571 L
.30612 .27388 L
.31863 .26531 L
.32653 .2599 L
.34694 .2485 L
.35483 .2449 L
.36735 .24137 L
Mfstroke
.57143 .19394 m
.58445 .20408 L
.57744 .22449 L
.57143 .22817 L
.55746 .22449 L
.55419 .20408 L
.57143 .19394 L
s
.40816 .17344 m
.42857 .16644 L
.44898 .16686 L
.46939 .17292 L
.48143 .18367 L
.4898 .19574 L
.49408 .20408 L
.50006 .22449 L
.50209 .2449 L
.50205 .26531 L
.50134 .28571 L
.5007 .30612 L
.50033 .32653 L
.50015 .34694 L
.50009 .36735 L
.50007 .38776 L
.50007 .40816 L
.50007 .42857 L
.50007 .44898 L
.50007 .46939 L
.50007 .4898 L
.50007 .5102 L
.50007 .53061 L
.50007 .55102 L
.50007 .57143 L
.50007 .59184 L
.50007 .61224 L
.50009 .63265 L
.50015 .65306 L
.50033 .67347 L
.5007 .69388 L
.50134 .71429 L
.50205 .73469 L
.50209 .7551 L
.50006 .77551 L
.49408 .79592 L
.4898 .80426 L
.48143 .81633 L
.46939 .82708 L
.44898 .83314 L
.42857 .83356 L
.40816 .82656 L
.3908 .81633 L
.38776 .81493 L
.36735 .80441 L
.34803 .79592 L
.34694 .79551 L
.32653 .788 L
.30612 .77984 L
.29649 .77551 L
Mistroke
.28571 .77019 L
.26531 .75774 L
.26154 .7551 L
.2449 .7424 L
.23624 .73469 L
.22449 .72364 L
.21542 .71429 L
.20408 .70205 L
.19689 .69388 L
.18367 .67803 L
.18002 .67347 L
.16472 .65306 L
.16327 .65098 L
.151 .63265 L
.14286 .619 L
.13908 .61224 L
.12862 .59184 L
.12245 .5781 L
.11974 .57143 L
.11236 .55102 L
.10693 .53061 L
.10397 .5102 L
.10397 .4898 L
.10693 .46939 L
.11236 .44898 L
.11974 .42857 L
.12245 .4219 L
.12862 .40816 L
.13908 .38776 L
.14286 .381 L
.151 .36735 L
.16327 .34902 L
.16472 .34694 L
.18002 .32653 L
.18367 .32197 L
.19689 .30612 L
.20408 .29795 L
.21542 .28571 L
.22449 .27636 L
.23624 .26531 L
.2449 .2576 L
.26154 .2449 L
.26531 .24226 L
.28571 .22981 L
.29649 .22449 L
.30612 .22016 L
.32653 .212 L
.34694 .20449 L
.34803 .20408 L
.36735 .19559 L
Mistroke
.38776 .18507 L
.3908 .18367 L
.40816 .17344 L
Mfstroke
.5102 .09974 m
.51749 .10204 L
.53061 .11318 L
.53463 .12245 L
.53246 .14286 L
.53061 .14708 L
.51947 .16327 L
.5102 .17571 L
.5067 .18367 L
.50144 .20408 L
.50004 .22449 L
.49981 .2449 L
.49987 .26531 L
.49996 .28571 L
.50002 .30612 L
.50005 .32653 L
.50006 .34694 L
.50007 .36735 L
.50007 .38776 L
.50007 .40816 L
.50007 .42857 L
.50007 .44898 L
.50007 .46939 L
.50007 .4898 L
.50007 .5102 L
.50007 .53061 L
.50007 .55102 L
.50007 .57143 L
.50007 .59184 L
.50007 .61224 L
.50007 .63265 L
.50006 .65306 L
.50005 .67347 L
.50002 .69388 L
.49996 .71429 L
.49987 .73469 L
.49981 .7551 L
.50004 .77551 L
.50144 .79592 L
.5067 .81633 L
.5102 .82429 L
.51947 .83673 L
.53061 .85292 L
.53246 .85714 L
.53463 .87755 L
.53061 .88682 L
.51749 .89796 L
.5102 .90026 L
.49695 .89796 L
.4898 .89417 L
Mistroke
.47205 .87755 L
.46939 .87487 L
.44898 .86144 L
.42857 .85879 L
.40816 .85956 L
.38776 .86045 L
.36735 .85978 L
.34969 .85714 L
.34694 .85662 L
.32653 .85095 L
.30612 .84145 L
.29789 .83673 L
.28571 .82982 L
.26553 .81633 L
.26531 .81619 L
.2449 .80236 L
.23597 .79592 L
.22449 .78755 L
.20938 .77551 L
.20408 .77107 L
.18681 .7551 L
.18367 .75197 L
.16774 .73469 L
.16327 .72939 L
.1513 .71429 L
.14286 .70255 L
.13687 .69388 L
.124 .67347 L
.12245 .67079 L
.11235 .65306 L
.10239 .63265 L
.10204 .63188 L
.09353 .61224 L
.0863 .59184 L
.08163 .57541 L
.08062 .57143 L
.07619 .55102 L
.07324 .53061 L
.07178 .5102 L
.07178 .4898 L
.07324 .46939 L
.07619 .44898 L
.08062 .42857 L
.08163 .42459 L
.0863 .40816 L
.09353 .38776 L
.10204 .36812 L
.10239 .36735 L
.11235 .34694 L
.12245 .32921 L
Mistroke
.124 .32653 L
.13687 .30612 L
.14286 .29745 L
.1513 .28571 L
.16327 .27061 L
.16774 .26531 L
.18367 .24803 L
.18681 .2449 L
.20408 .22893 L
.20938 .22449 L
.22449 .21245 L
.23597 .20408 L
.2449 .19764 L
.26531 .18381 L
.26553 .18367 L
.28571 .17018 L
.29789 .16327 L
.30612 .15855 L
.32653 .14905 L
.34694 .14338 L
.34969 .14286 L
.36735 .14022 L
.38776 .13955 L
.40816 .14044 L
.42857 .14121 L
.44898 .13856 L
.46939 .12513 L
.47205 .12245 L
.4898 .10583 L
.49695 .10204 L
.5102 .09974 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0714286 0.5 0.0714286 [
[.07143 -0.0125 -6 -9 ]
[.07143 -0.0125 6 0 ]
[.21429 -0.0125 -6 -9 ]
[.21429 -0.0125 6 0 ]
[.35714 -0.0125 -6 -9 ]
[.35714 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.64286 -0.0125 -3 -9 ]
[.64286 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.92857 -0.0125 -3 -9 ]
[.92857 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .07143 -12 -4.5 ]
[-0.0125 .07143 0 4.5 ]
[-0.0125 .21429 -12 -4.5 ]
[-0.0125 .21429 0 4.5 ]
[-0.0125 .35714 -12 -4.5 ]
[-0.0125 .35714 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .64286 -6 -4.5 ]
[-0.0125 .64286 0 4.5 ]
[-0.0125 .78571 -6 -4.5 ]
[-0.0125 .78571 0 4.5 ]
[-0.0125 .92857 -6 -4.5 ]
[-0.0125 .92857 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07143 0 m
.07143 .00625 L
s
[(-6)] .07143 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(-4)] .21429 -0.0125 0 1 Mshowa
.35714 0 m
.35714 .00625 L
s
[(-2)] .35714 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.64286 0 m
.64286 .00625 L
s
[(2)] .64286 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(4)] .78571 -0.0125 0 1 Mshowa
.92857 0 m
.92857 .00625 L
s
[(6)] .92857 -0.0125 0 1 Mshowa
.125 Mabswid
.10714 0 m
.10714 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.17857 0 m
.17857 .00375 L
s
.25 0 m
.25 .00375 L
s
.28571 0 m
.28571 .00375 L
s
.32143 0 m
.32143 .00375 L
s
.39286 0 m
.39286 .00375 L
s
.42857 0 m
.42857 .00375 L
s
.46429 0 m
.46429 .00375 L
s
.53571 0 m
.53571 .00375 L
s
.57143 0 m
.57143 .00375 L
s
.60714 0 m
.60714 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.71429 0 m
.71429 .00375 L
s
.75 0 m
.75 .00375 L
s
.82143 0 m
.82143 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.89286 0 m
.89286 .00375 L
s
.03571 0 m
.03571 .00375 L
s
.96429 0 m
.96429 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07143 m
.00625 .07143 L
s
[(-6)] -0.0125 .07143 1 0 Mshowa
0 .21429 m
.00625 .21429 L
s
[(-4)] -0.0125 .21429 1 0 Mshowa
0 .35714 m
.00625 .35714 L
s
[(-2)] -0.0125 .35714 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .64286 m
.00625 .64286 L
s
[(2)] -0.0125 .64286 1 0 Mshowa
0 .78571 m
.00625 .78571 L
s
[(4)] -0.0125 .78571 1 0 Mshowa
0 .92857 m
.00625 .92857 L
s
[(6)] -0.0125 .92857 1 0 Mshowa
.125 Mabswid
0 .10714 m
.00375 .10714 L
s
0 .14286 m
.00375 .14286 L
s
0 .17857 m
.00375 .17857 L
s
0 .25 m
.00375 .25 L
s
0 .28571 m
.00375 .28571 L
s
0 .32143 m
.00375 .32143 L
s
0 .39286 m
.00375 .39286 L
s
0 .42857 m
.00375 .42857 L
s
0 .46429 m
.00375 .46429 L
s
0 .53571 m
.00375 .53571 L
s
0 .57143 m
.00375 .57143 L
s
0 .60714 m
.00375 .60714 L
s
0 .67857 m
.00375 .67857 L
s
0 .71429 m
.00375 .71429 L
s
0 .75 m
.00375 .75 L
s
0 .82143 m
.00375 .82143 L
s
0 .85714 m
.00375 .85714 L
s
0 .89286 m
.00375 .89286 L
s
0 .03571 m
.00375 .03571 L
s
0 .96429 m
.00375 .96429 L
s
.25 Mabswid
0 0 m
0 1 L
s
.07143 .99375 m
.07143 1 L
s
.21429 .99375 m
.21429 1 L
s
.35714 .99375 m
.35714 1 L
s
.5 .99375 m
.5 1 L
s
.64286 .99375 m
.64286 1 L
s
.78571 .99375 m
.78571 1 L
s
.92857 .99375 m
.92857 1 L
s
.125 Mabswid
.10714 .99625 m
.10714 1 L
s
.14286 .99625 m
.14286 1 L
s
.17857 .99625 m
.17857 1 L
s
.25 .99625 m
.25 1 L
s
.28571 .99625 m
.28571 1 L
s
.32143 .99625 m
.32143 1 L
s
.39286 .99625 m
.39286 1 L
s
.42857 .99625 m
.42857 1 L
s
.46429 .99625 m
.46429 1 L
s
.53571 .99625 m
.53571 1 L
s
.57143 .99625 m
.57143 1 L
s
.60714 .99625 m
.60714 1 L
s
.67857 .99625 m
.67857 1 L
s
.71429 .99625 m
.71429 1 L
s
.75 .99625 m
.75 1 L
s
.82143 .99625 m
.82143 1 L
s
.85714 .99625 m
.85714 1 L
s
.89286 .99625 m
.89286 1 L
s
.03571 .99625 m
.03571 1 L
s
.96429 .99625 m
.96429 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .07143 m
1 .07143 L
s
.99375 .21429 m
1 .21429 L
s
.99375 .35714 m
1 .35714 L
s
.99375 .5 m
1 .5 L
s
.99375 .64286 m
1 .64286 L
s
.99375 .78571 m
1 .78571 L
s
.99375 .92857 m
1 .92857 L
s
.125 Mabswid
.99625 .10714 m
1 .10714 L
s
.99625 .14286 m
1 .14286 L
s
.99625 .17857 m
1 .17857 L
s
.99625 .25 m
1 .25 L
s
.99625 .28571 m
1 .28571 L
s
.99625 .32143 m
1 .32143 L
s
.99625 .39286 m
1 .39286 L
s
.99625 .42857 m
1 .42857 L
s
.99625 .46429 m
1 .46429 L
s
.99625 .53571 m
1 .53571 L
s
.99625 .57143 m
1 .57143 L
s
.99625 .60714 m
1 .60714 L
s
.99625 .67857 m
1 .67857 L
s
.99625 .71429 m
1 .71429 L
s
.99625 .75 m
1 .75 L
s
.99625 .82143 m
1 .82143 L
s
.99625 .85714 m
1 .85714 L
s
.99625 .89286 m
1 .89286 L
s
.99625 .03571 m
1 .03571 L
s
.99625 .96429 m
1 .96429 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[88]:=",
  ImageSize->{400, 190.25},
  ImageMargins->{{2.25, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007d0000kB000`400?l00000o`00003ooooooooe
ooooo`00oooooooeooooo`00oooooooeooooo`00oooooooeooooo`00oooooooeooooo`00oooooooe
ooooo`00oooooooeooooo`00oooooooeooooo`00H_ooool01Oo^k^ko<S8bo`000?l@413oc<c<01?o
oooo0_l000000ol@413oooooooooo`0?ooooo`Go00003Oooool01Oo^k^ko<S8bo`000?lb<S;ok^k^
017ooooo1Ol0000Cooooo`;o000000?o410@ooooooooool03oooool01Oo^k^ko<S8bo`000?l@413o
c<c<03Sooooo00Gok^k^oc8b<_l0003o410@olc<c00Cooooo`;o000000?o410@ooooooooool03ooo
ool5o`0000gooooo00Gok^k^oc8b<_l0003o<S8bonk^kP0Aooooo`Go00004oooool2o`000003oa0@
4?oooooooooo00oooooo00Gok^k^oc8b<_l0003o410@olc<c01@ooooo`00H_ooool01OmEEEGoMgMg
oooooonHV9So8B4Q01Cooooo00?o0000ooooooooool04?ooool01OnHV9So8B4Qonk^k_ooooooA4A4
00gooooo00GoMgMgoiRHV?ooooooV9RHogMgM`0Aooooo`05oiRHV?lQ8B7ok^k^oooooom4A4@05?oo
ool00ol0003oooooooooo`0@ooooo`05oeEEEOmgMgOooooooiRHV?lQ8B40>?ooool01OmEEEGoMgMg
oooooonHV9So8B4Q01Cooooo00?o0000ooooooooool04?ooool01OnHV9So8B4Qonk^k_ooooooA4A4
00gooooo00GoMgMgoiRHV?ooooooV9RHogMgM`0Aooooo`05oiRHV?lQ8B7ok^k^oooooom4A4@05?oo
ool00ol0003oooooooooo`0@ooooo`05oeEEEOmgMgOooooooiRHV?lQ8B40D?ooool005[ooooo1_l0
0002ooooo`05o`000?ooooooooooooooool000002Oooool6o`0000;ooooo1Ol00009ooooo`Ko0000
0oooool00onHV9So8B4Qonk^kP0>ooooo`05oa0@4?ooooooooooooooool@41004_ooool00onHV9So
8B4Qonk^kP0Booooo`Go00004Oooool01Ol0003ooooooooooooooooo0000033ooooo1_l00002oooo
o`05o`000?ooooooooooooooool000002Oooool6o`0000;ooooo1Ol00009ooooo`Ko00000oooool0
0onHV9So8B4Qonk^kP0>ooooo`05oa0@4?ooooooooooooooool@41004_ooool00onHV9So8B4Qonk^
kP0Booooo`Go00004Oooool01Ol0003ooooooooooooooooo0000053ooooo001Rooooo`05o`000?nH
V9SooooooiRHV?lQ8B404Oooool01?m4A4CogMgMooooool0000Dooooo`03oiRHV?lQ8B7ok^k^00go
oooo00Go0000ooooooooooooooooo`00000Cooooo`03oiRHV?lQ8B7ok^k^017ooooo00CoA4A4omgM
gOoooooo00004_ooool01Ol0003oV9RHoooooonHV9So8B4Q03Sooooo00Go0000oiRHV?ooooooV9RH
ob4Q8@0Aooooo`04odA4A?oMgMgoooooo`0001Cooooo00?oV9RHob4Q8Oo^k^h03Oooool01Ol0003o
oooooooooooooooo000001?ooooo00?oV9RHob4Q8Oo^k^h04Oooool01?m4A4CogMgMooooool0000B
ooooo`05o`000?nHV9SooooooiRHV?lQ8B40D?ooool006;ooooo00Go0000oeEEEOl0003o410@olc<
c00Aooooo`04omgMgOmEEEGoooooo`0001Gooooo00?oMgMgofIVI_ooool03?ooool01Ol0003ooooo
oooooooooooo000001Cooooo00?oMgMgofIVI_ooool04?ooool01?oMgMgoEEEEooooool0000Boooo
o`05o`000?mEEEGo0000oa0@4?o<c<`0>?ooool01Ol0003oEEEEo`000?l@413oc<c<017ooooo00Co
gMgMoeEEEOoooooo00005Oooool00omgMgOoIVIVooooo`0<ooooo`05o`000?ooooooooooooooool0
00005?ooool00omgMgOoIVIVooooo`0@ooooo`04omgMgOmEEEGoooooo`0001;ooooo00Go0000oeEE
EOl0003o410@olc<c01@ooooo`00H_ooool00omEEEGoQhN7ooooo`0Dooooo`03ogMgMoo<c<co0000
01Kooooo00?o0000ooooooooool02oooool01Ol@413ooooooooooooooooo410@01Gooooo00?o0000
ooooooooool04?ooool00omgMgOoc<c<o`00000Booooo`03oeEEEOn7QhOooooo03[ooooo00?oEEEE
ohN7Qoooool05?ooool00omgMgOoc<c<o`00000Fooooo`03o`000?oooooooooo00_ooooo00Go410@
oooooooooooooooooa0@400Eooooo`03o`000?oooooooooo013ooooo00?oMgMgolc<c?l000004_oo
ool00omEEEGoQhN7ooooo`1Booooo`00H_ooool00ooMgMgo410@oiRHV00Dooooo`03onk^k_m4A4Co
000001;ooooo00Go0000okZj^_ooooooV9RHoa0@400=ooooo`05ogMgMonHV9SooooooiRHV?mgMgL0
4Oooool01Ol0003o^[ZjoooooonHV9So410@01;ooooo00?ok^k^odA4A?l000004_ooool00ooMgMgo
410@oiRHV00jooooo`03omgMgOl@413oV9RH01Cooooo00?ok^k^odA4A?l000004_ooool01Ol0003o
^[ZjoooooonHV9So410@00gooooo00GoMgMgoiRHV?ooooooV9RHogMgM`0Aooooo`05o`000?nj^[[o
oooooiRHV?l@41004_ooool00oo^k^koA4A4o`00000Booooo`03omgMgOl@413oV9RH05;ooooo001S
ooooo`04olc<c?m4A4Co0000oa0@41?ooooo00?oMgMgo`000?ooool04Oooool01OnHV9So410@o`00
0?lQ8B7oc<c<00gooooo00Gok^k^oc8b<_l0003o<S8bonk^kP0Aooooo`05oiRHV?l@413o0000ob4Q
8Oo<c<`04oooool00omgMgOo0000ooooo`0Booooo`04olc<c?m4A4Co0000oa0@43Wooooo00Coc<c<
odA4A?l0003o410@4oooool00omgMgOo0000ooooo`0Aooooo`05oiRHV?l@413o0000ob4Q8Oo<c<`0
3Oooool01Oo^k^ko<S8bo`000?lb<S;ok^k^017ooooo00GoV9RHoa0@4?l0003o8B4Qolc<c00Coooo
o`03ogMgMol0003ooooo01;ooooo00Coc<c<odA4A?l0003o410@D?ooool00?oooooomOooool00?oo
oooomOooool00?oooooomOooool005KoooooVP00000Roooooi/00000Aoooool005Kooooo00<00000
ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`0300000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool09?ooool00`00003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00<00000
ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`1:ooooo`00E_ooool00`00003oooooooooo`1:oooo
o`0300000?oooooooooo06cooooo00<00000ooooooooool0Boooool00`00003oooooooooo`2Aoooo
o`00E_ooool00`00003oooooooooo`1:ooooo`0300000?oooooooooo06cooooo00<00000oooooooo
ool0Boooool00`00003oooooooooo`2Aooooo`00E_ooool00`00003oooooooooo`1:ooooo`030000
0?oooooooooo06cooooo00<00000ooooooooool0Boooool00`00003oooooooooo`2Aooooo`00E_oo
ool00`00003oooooooooo`1:ooooo`0300000?oooooooooo06cooooo00<00000ooooooooool0Booo
ool00`00003oooooooooo`2Aooooo`00E_ooool00`00003oooooooooo`1:ooooo`0300000?oooooo
oooo06cooooo00<00000o`000?ooool0Boooool00`00003oooooooooo`19ooooo`;o0000A_ooool0
05Kooooo00<00000ooooooooool0B_ooool00`00003oooooooooo`1/ooooo`0300000?oooooooooo
04_ooooo00<00000ooooooooool0TOooool005Kooooo00<00000ooooooooool0B_ooool00`00003o
ooooooooo`1/ooooo`0300000?oooooooooo04_ooooo00<00000ooooooooool0TOooool004gooooo
00Gok^k^oc8b<_l0003o410@olc<c004ooooo`0300000?oooooooooo04[ooooo00<00000oooooooo
ool0I?ooool01Oo^k^ko<S8bo`000?l@413oc<c<00?ooooo00<00000ooooooooool0Boooool00`00
003oooooooooo`2Aooooo`00COooool01OmEEEGoMgMgoooooonHV9So8B4Q00Cooooo00<00000oooo
ooooool0B_ooool00`00003oooooooooo`1Tooooo`05oeEEEOmgMgOooooooiRHV?lQ8B400oooool0
0`00003oooooooooo`1;ooooo`0300000?oooooooooo097ooooo0015ooooo`Ko00000_ooool01Ol0
003ooooooooooooooooo000000Cooooo00<00000o`000?ooool0B_ooool00`00003oooooooooo`19
ooooo`;o00004Oooool6o`0000;ooooo00Go0000ooooooooooooooooo`000003ooooo`0300000?l0
003ooooo04_ooooo00<00000ooooooooool0BOooool2o`0004Kooooo001=ooooo`05o`000?nHV9So
oooooiRHV?lQ8B401?ooool00`00003oooooooooo`1:ooooo`0300000?oooooooooo06Cooooo00Go
0000oiRHV?ooooooV9RHob4Q8@03ooooo`0300000?oooooooooo04_ooooo00<00000ooooooooool0
TOooool004gooooo00Go0000oeEEEOl0003o410@olc<c004ooooo`0300000?oooooooooo04[ooooo
00<00000ooooooooool0I?ooool01Ol0003oEEEEo`000?l@413oc<c<00?ooooo00<00000oooooooo
ool0Boooool00`00003oooooooooo`2Aooooo`00COooool00omEEEGoQhN7ooooo`06ooooo`030000
0?oooooooooo04[ooooo00<00000ooooooooool0I?ooool00omEEEGoQhN7ooooo`05ooooo`030000
0?oooooooooo04_ooooo00<00000ooooooooool0TOooool004gooooo00?ogMgMoa0@4?nHV9P01_oo
ool00`00003oooooooooo`1:ooooo`0300000?oooooooooo06Cooooo00?ogMgMoa0@4?nHV9P01Ooo
ool00`00003oooooooooo`1;ooooo`0300000?oooooooooo097ooooo001>ooooo`04olc<c?m4A4Co
0000oa0@40Cooooo00<00000ooooooooool0B_ooool00`00003oooooooooo`1Uooooo`04olc<c?m4
A4Co0000oa0@40?ooooo00<00000ooooooooool0B_ooool40000097ooooo001Fooooo`0300000?oo
oooooooo04[ooooo00<00000ooooooooool0K?ooool00`00003o0000ooooo`18ooooo`0400000?l0
003ooooo000000;ooooo00<00000ooooooooool0A_ooool2o`0004Kooooo001Fooooo`0300000?oo
oooooooo04[ooooo00<00000ooooooooool0K?ooool00`00003oooooooooo`17ooooo`0500000?oo
ooooooooooooo`0000000oooool00ol0003oooooooooo`2=ooooo`00E_ooool00`00003ooooooooo
o`1:ooooo`0300000?oooooooooo06cooooo00<00000ooooooooool0A_ooool00`00003ooooooooo
o`02ooooo`0300000?oooooooooo00;ooooo00<00000ooooooooool0S?ooool005Kooooo00<00000
ooooooooool0Aoooool6000006cooooo00<00000ooooooooool0AOooool00`00003o0000ooooo`03
ooooo`0300000?oooooooooo00;ooooo00<00000ooooooooool0S?ooool005Kooooo00<00000oooo
ooooool0A_ooool01@00003oooooooooooooool0000000;ooooo00<00000ooooooooool0JOooool0
0`00003oooooooooo`14ooooo`0300000?oooooooooo00Cooooo00<00000ooooooooool00_ooool0
0`00003oooooooooo`2<ooooo`00E_ooool00`00003oooooooooo`15ooooo`03o`000?oooooooooo
00;ooooo00D00000oooooooooooooooo0000001Zooooo`0300000?l0003ooooo03;ooooo4P000007
ooooo`0300000?oooooooooo00;ooooo00?o0000ooooooooool0A?ooool2o`0004Kooooo001Foooo
o`0300000?oooooooooo04Cooooo00<00000ooooooooool00oooool01@00003oooooooooooooool0
000006[ooooo00<00000ooooooooool0;oooool3000001Wooooo00D00000oooooooooooooooo0000
002?ooooo`00E_ooool00`00003oooooooooo`13ooooo`0300000?oooooooooo00Cooooo00D00000
oooooooooooooooo0000001Zooooo`0300000?oooooooooo02kooooo00<00000ooooooooool06_oo
ool01@00003oooooooooooooool0000008oooooo001Fooooo`0300000?oooooooooo043ooooo00<0
0000o`00000000001oooool01@00003oooooooooooooool0000006[ooooo00<00000ooooooooool0
:oooool3000001gooooo00@00000ooooooooool00000T?ooool005Kooooo00<00000ooooooooool0
=?ooool<000000[ooooo00D00000oooooooooooooooo0000001Zooooo`0300000?oooooooooo02Wo
oooo00<00000o`000?ooool04_ooool8000000Gooooo00<00000ooooo`000000TOooool005Kooooo
00<00000ooooooooool0<Oooool3000001Kooooo00D00000oooooooooooooooo0000001Zooooo`03
00000?oooooooooo02Sooooo00<00000ooooooooool04Oooool2000000Sooooo00<00000oooooooo
ool00_ooool2000009;ooooo001Fooooo`0300000?oooooooooo02oooooo0P00000Iooooo`040000
0?oooooooooo000006_ooooo00<00000o`000?ooool09oooool00`00003oooooooooo`0Aooooo`03
00000?oooooooooo00Wooooo00@00000oooooooooooooooo0P00001:ooooo`;o0000A_ooool005Ko
oooo00<00000ooooooooool0;_ooool2000001[ooooo00@00000ooooooooool00000Joooool00`00
003oooooooooo`0Uooooo`8000004Oooool00`00003o00000000000=ooooo`03o`000?oooooooooo
00800000T_ooool005Kooooo00<00000ooooooooool0;?ooool20000013ooooo1`000005ooooo`04
00000?oooooooooo000006_ooooo00<00000ooooooooool09?ooool00`00003oooooooooo`0>oooo
o`<000004Oooool01000003ooooo000000000008ooooo`800000R?ooool004oooooo0_l000000ol@
413oooooooooo`02ooooo`0300000?oooooooooo02cooooo00<00000ooooooooool03_ooool00`00
003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00<00000ooooool00000I_ooool2o`00
0005oa0@4?ooooooooooooooo`0000009Oooool00`00003oooooooooo`0>ooooo`0300000?oooooo
oooo01;ooooo00<00000ooooo`0000002?ooool01000003oooooooooo`000027ooooo`00D?ooool0
0ol0003oooooooooo`03ooooo`0300000?oooooooooo02[ooooo0P00000?ooooo`8000002Oooool0
1000003oooooooooooooool2000006Sooooo00?o0000ooooooooool00_ooool00`00003ooooooooo
o`0Qooooo`0300000?l0003ooooo00kooooo0P00000Fooooo`8000001oooool00`00003ooooooooo
o`02ooooo`0300000?oooooooooo08Cooooo0015ooooo`Ko00000_ooool5o`0000Cooooo00<00000
o`000?ooool0:Oooool00`00003oooooooooo`0>ooooo`0300000?oooooooooo00Wooooo00@00000
oooooooooooooooo0P00001:ooooo`;o00004Oooool6o`0000;ooooo1Ol00003ooooo`0300000?l0
003ooooo023ooooo00<00000ooooooooool03?ooool3000001Sooooo0P000007ooooo`0300000?oo
oooooooo00;ooooo00<00000ooooooooool0??ooool2o`0004Kooooo001=ooooo`04odA4A?oMgMgo
ooooo`0000Gooooo00<00000ooooooooool0:?ooool00`00003oooooooooo`0=ooooo`8000003Ooo
ool01000003oooooooooo`000007ooooo`03o`000000003ooooo05cooooo00CoA4A4omgMgOoooooo
00001?ooool00`00003oooooooooo`0Oooooo`0300000?oooooooooo00[ooooo0`00000Looooo`03
00000?oooooooooo00Kooooo00@00000ooooooooool00000Qoooool004gooooo00CogMgMoeEEEOoo
oooo00001Oooool00`00003oooooooooo`0Wooooo`0300000?oooooooooo00gooooo00<00000oooo
ooooool03_ooool00`00003o000000000006ooooo`04o`000?ooooooooooo`0005cooooo00CogMgM
oeEEEOoooooo00001?ooool00`00003oooooooooo`0Nooooo`0300000?oooooooooo00[ooooo00<0
0000ooooooooool07Oooool00`00003oooooooooo`06ooooo`<0000000?o0000ooooooooool0QOoo
ool004kooooo00?oMgMgolc<c?l000001Oooool00`00003oooooooooo`0Uooooo`0300000?l0003o
oooo00gooooo00<00000o`000?ooool04?ooool00`00003ooooo00000006ooooo`0500000?oooooo
ooooooooo`000000G?ooool00omgMgOoc<c<o`000004ooooo`0300000?oooooooooo01cooooo00<0
0000o`000?ooool02_ooool00`00003o0000ooooo`0Oooooo`0300000?oooooooooo097ooooo001>
ooooo`03onk^k_m4A4Co000000Gooooo00<00000ooooooooool09?ooool00`00003oooooooooo`0<
ooooo`8000005?ooool2000000Gooooo00<00000ooooooooool00_ooool00`00003oooooooooo`1J
ooooo`03onk^k_m4A4Co000000Cooooo00<00000ooooooooool06oooool00`00003oooooooooo`09
ooooo`8000003?ooool:000000cooooo00<00000ooooooooool0TOooool004oooooo00?oMgMgo`00
0?ooool01?ooool00`00003oooooooooo`0Sooooo`0300000?oooooooooo00_ooooo0P00000Goooo
o`0300000?oooooooooo00;ooooo0P000003ooooo`800000GOooool00omgMgOo0000ooooo`03oooo
o`0300000?oooooooooo01[ooooo00<00000ooooooooool02?ooool2000000gooooo00<00000oooo
ooooool02?ooool4000000Sooooo00<00000ooooooooool0TOooool005Kooooo00<00000oooooooo
ool08_ooool00`00003oooooooooo`09ooooo`<000006Oooool00`00003oooooooooo`04ooooo`03
00000?ooool0000006Gooooo00<00000o`000?ooool06Oooool00`00003oooooooooo`08ooooo`03
00000?oooooooooo00_ooooo00<00000o`000?ooool03_ooool2000000Kooooo00<00000oooooooo
ool0BOooool2o`0004Kooooo001Fooooo`0300000?oooooooooo027ooooo00<00000ooooooooool0
2Oooool00`00003oooooooooo`0Jooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool0
I?ooool00`00003oooooooooo`0Hooooo`0300000?oooooooooo00Sooooo00<00000ooooooooool0
2_ooool2000001?ooooo1`00002Cooooo`00E_ooool00`00003oooooooooo`0Pooooo`0300000?oo
oooooooo00Sooooo0P00000Mooooo`0300000?oooooooooo06cooooo00<00000ooooooooool05ooo
ool00`00003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo00<00000o`000?ooool04_oo
ool200000003ooooo`00003ooooo00?ooooo0P00002Booooo`00E_ooool00`00003oooooooooo`0O
ooooo`0300000?oooooooooo00Sooooo00<00000ooooooooool03_ooool4000000_ooooo00<00000
ooooooooool0K?ooool00`00003oooooooooo`0Gooooo`03o`000?oooooooooo00Oooooo00<00000
ooooooooool02?ooool2000001Cooooo00D00000o`000?oooooooooo00000004ooooo`800000T_oo
ool005Kooooo00<00000ooooooooool07_ooool00`00003oooooooooo`08ooooo`0300000?oooooo
oooo00cooooo0`000004ooooo`D000001_ooool00`00003oooooooooo`1/ooooo`0300000?oooooo
oooo01Kooooo00<00000ooooooooool01oooool00`00003oooooooooo`08ooooo`0300000?oooooo
oooo01?ooooo00<00000ooooooooool00oooool01`00003oooooooooooooool00000ooooo`000000
TOooool005Kooooo00<00000ooooooooool07Oooool00`00003oooooooooo`08ooooo`03o`000?oo
oooooooo00Wooooo00@00000o`000?l0000000003?ooool00ol0003oooooooooo`03ooooo`030000
0?oooooooooo06cooooo00<00000o`000?ooool05Oooool00`00003oooooooooo`07ooooo`03o`00
0?oooooooooo00Sooooo00<00000ooooooooool04Oooool00`00003o000000000007ooooo`040000
0?oooooooooo000000;ooooo00<00000ooooooooool0A_ooool2o`0004Kooooo001Fooooo`030000
0?oooooooooo01cooooo00?o0000ooooooooool02Oooool00`00003oooooooooo`08ooooo`030000
0?oooooooooo00kooooo00?o00000000000000000ol000000`00003oooooooooo`1/ooooo`030000
0?oooooooooo01Gooooo00<00000ooooooooool01_ooool00`00003oooooooooo`08ooooo`030000
0?l0003ooooo00oooooo0`00000:ooooo`0400000?oooooooooo000000;ooooo00<00000oooooooo
ool0S_ooool005Kooooo00<00000ooooooooool07?ooool00`00003oooooooooo`08ooooo`030000
0?oooooooooo00Sooooo00<00000ooooooooool03Oooool2o`0000?ooooo00@00000ooooooooool0
0000K_ooool00`00003oooooooooo`0Dooooo`0300000?oooooooooo00Kooooo00<00000oooooooo
ool01oooool2000000oooooo0`00000>ooooo`03o`000?ooool0000000?ooooo00<00000oooooooo
ool0SOooool005Kooooo00<00000ooooooooool06oooool00`00003oooooooooo`07ooooo`03o`00
0000003ooooo00Wooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`04ooooo`040000
0?ooool00000o`0006gooooo00<00000ooooooooool04oooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo00Oooooo00<00000ooooooooool02oooool01000003o000000000000000Boooo
o`8000000oooool00`00003oooooooooo`2=ooooo`00E_ooool00`00003oooooooooo`0Kooooo`03
00000?oooooooooo00Oooooo00<00000ooooooooool02?ooool00`00003oooooooooo`0=ooooo`03
00000?oooooooooo00Gooooo00D00000ooooo`00003oooooo`00001/ooooo`0300000?oooooooooo
01?ooooo00<00000ooooooooool01_ooool00`00003oooooooooo`06ooooo`0300000?oooooooooo
00[ooooo0P00000Fooooo`8000000oooool00`00003oooooooooo`2=ooooo`00E_ooool00`00003o
ooooooooo`0Jooooo`0300000?oooooooooo00Oooooo00<00000ooooooooool02?ooool00`00003o
ooooooooo`0=ooooo`0300000?oooooooooo00Kooooo00D00000ooooo`00003oooooo`00001/oooo
o`0300000?oooooooooo01;ooooo00<00000ooooooooool01_ooool00`00003oooooooooo`06oooo
o`0300000?oooooooooo00Sooooo0`00000Hooooo`8000000oooool00`00003oooooooooo`2=oooo
o`00E_ooool00`00003oooooooooo`0Iooooo`0300000?oooooooooo00Sooooo00<00000oooooooo
ool02?ooool00`00003oooooooooo`0=ooooo`0300000?oooooooooo00Kooooo00<00000ooooo`00
00000_ooool00ol0003oooooooooo`1Yooooo`0300000?l0003ooooo01;ooooo00<00000oooooooo
ool01Oooool00`00003oooooooooo`06ooooo`0300000?oooooooooo00Sooooo00<00000oooooooo
ool03Oooool200000003o`000?oooooooooo00Oooooo0P000002ooooo`0300000?oooooooooo04Ko
oooo0_l00016ooooo`00E_ooool00`00003oooooooooo`0Iooooo`03o`000?oooooooooo00Oooooo
00<00000ooooooooool02?ooool00`00003oooooooooo`0<ooooo`8000002_ooool2000000;ooooo
00?o0000ooooooooool0JOooool00`00003oooooooooo`0@ooooo`03o`000000003ooooo00Kooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`8000003Oooool00`00003o0000
00000003ooooo`@000001Oooool2000000;ooooo00<00000ooooooooool0S_ooool005Kooooo00<0
0000ooooooooool06Oooool00`00003oooooooooo`07ooooo`0300000?oooooooooo00Oooooo00<0
0000ooooooooool02oooool2000000cooooo0P000002ooooo`03o`000?oooooooooo06Wooooo00<0
0000ooooooooool04?ooool00`00003oooooooooo`06ooooo`0300000?oooooooooo00Gooooo00<0
0000ooooooooool01oooool00`00003oooooooooo`0:ooooo`<000002_ooool00`00003ooooooooo
o`02ooooo`8000000_ooool00`00003oooooooooo`2>ooooo`00COooool5o`0000Cooooo00<00000
ooooooooool06?ooool00`00003oooooooooo`07ooooo`0300000?oooooooooo00Oooooo00<00000
ooooooooool02oooool00`00003oooooooooo`0=ooooo`0400000?ooooooooooo`0006?ooooo1Ol0
0003ooooo`0300000?oooooooooo00oooooo00<00000ooooooooool01_ooool00`00003ooooooooo
o`05ooooo`0300000?oooooooooo00Kooooo0P00000<ooooo`0300000?oooooooooo00cooooo00Co
0000oooooooooooooooo0P0000000oooool00000ooooo`2@ooooo`00COooool01OnHV9So8B4Qonk^
k_ooooooA4A400Cooooo00<00000ooooooooool05oooool00`00003oooooooooo`07ooooo`030000
0?oooooooooo00Oooooo00?o0000ooooooooool02_ooool20000013ooooo00@00000oooooooooooo
0000Hoooool01OnHV9So8B4Qonk^k_ooooooA4A400?ooooo00<00000ooooooooool03oooool00`00
003oooooooooo`05ooooo`0300000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool20000
00gooooo00<00000ooooooooool03_ooool00`00003oooooooooo`03000009;ooooo0015ooooo`Ko
00000oooool00onHV9So8B4Qonk^kP05ooooo`0300000?l0003ooooo01Oooooo00<00000oooooooo
ool01oooool00`00003oooooooooo`07ooooo`0300000?oooooooooo00Wooooo00<00000oooooooo
ool04?ooool01000003oooooooooool00018ooooo`;o00004Oooool6o`0000?ooooo00?oV9RHob4Q
8Oo^k^h01?ooool00`00003o0000ooooo`0?ooooo`0300000?oooooooooo00Gooooo00<00000oooo
ooooool01?ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo00cooooo00<00000oooo
ooooool03oooool00`00003oooooooooo`03000004[ooooo0_l00016ooooo`00Coooool00onHV9So
8B4Qonk^kP04ooooo`0300000?oooooooooo01Kooooo00<00000ooooooooool01oooool00`00003o
ooooooooo`07ooooo`0300000?oooooooooo00Sooooo0P00000Cooooo`0300000?oooooo000006Ko
oooo00?oV9RHob4Q8Oo^k^h00oooool00`00003oooooooooo`0>ooooo`0300000?oooooooooo00Go
oooo00<00000ooooooooool01?ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo00co
oooo00<00000ooooooooool04Oooool00`00003oooooooooo`02000009;ooooo001@ooooo`03ogMg
MomVIVKooooo00?ooooo00<00000ooooooooool05_ooool00`00003oooooooooo`06ooooo`03o`00
0?oooooooooo00Oooooo00<00000ooooooooool01oooool2000001Gooooo00<00000ooooool00000
Ioooool00omgMgOoIVIVooooo`02ooooo`0300000?oooooooooo00gooooo00<00000ooooooooool0
1Oooool00`00003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00<00000ooooooooool0
3?ooool00`00003oooooooooo`0Cooooo`04o`000?ooool00000000009;ooooo001Aooooo`03o`00
0?oooooooooo00;ooooo00<00000ooooooooool05_ooool00`00003oooooooooo`06ooooo`030000
0?oooooooooo00Oooooo00<00000ooooooooool01_ooool00`00003oooooooooo`09ooooo`@00000
2?ooool00`00003oooooo`00001Xooooo`05o`000?ooooooooooooooo`0000003oooool00`00003o
ooooooooo`05ooooo`0300000?oooooooooo00?ooooo00<00000ooooooooool01Oooool00ol0003o
ooooooooo`0<ooooo`0300000?oooooooooo01Cooooo00@00000ooooo`0000000000T_ooool004go
oooo00Go0000okZj^_ooooooV9RHoa0@4004ooooo`0300000?oooooooooo01Gooooo00<00000oooo
ooooool01_ooool00`00003oooooooooo`07ooooo`0300000?oooooooooo00Kooooo00<00000oooo
ooooool01oooool3000000Cooooo0`000005ooooo`0300000?l0003ooooo06Cooooo00Go0000okZj
^_ooooooV9RHoa0@4003ooooo`0300000?oooooooooo00cooooo00<00000ooooooooool01Oooool0
0`00003oooooooooo`03ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool02oooool0
0`00003oooooooooo`0Eooooo`0300000?ooool0000009?ooooo001=ooooo`05oiRHV?l@413o0000
ob4Q8Oo<c<`01?ooool00`00003oooooooooo`0Eooooo`0300000?oooooooooo00Kooooo00<00000
ooooooooool01_ooool00`00003oooooooooo`06ooooo`0300000?oooooooooo00Kooooo0P00000:
ooooo`0300000?oooooooooo00;ooooo00<00000o`000?ooool0I?ooool01OnHV9So410@o`000?lQ
8B7oc<c<00?ooooo00<00000ooooooooool03?ooool00`00003oooooooooo`04ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01_ooool00`00003oooooooooo`0;ooooo`0300000?oo
oooooooo01Oooooo0P00002Cooooo`00E_ooool00`00003oooooooooo`0Eooooo`0300000?oooooo
oooo00Kooooo00<00000ooooooooool01_ooool00`00003oooooooooo`05ooooo`03o`000?oooooo
oooo00Kooooo00<00000ooooooooool02oooool01P00003oooooooooooooool00000o`0006gooooo
00<00000o`000?ooool03?ooool00`00003oooooooooo`04ooooo`0300000?oooooooooo00;ooooo
00<00000ooooooooool01_ooool00`00003oooooooooo`0<ooooo`03o`000?oooooooooo01Oooooo
0P00001;ooooo`;o0000A_ooool005Kooooo00<00000ooooooooool05?ooool00`00003ooooooooo
o`06ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool01_ooool00`00003ooooooooo
o`05ooooo`0300000?oooooooooo00gooooo00@00000ooooooooool00000K_ooool00`00003ooooo
ooooo`0;ooooo`0300000?oooooooooo00Cooooo00<00000ooooooooool00_ooool00`00003ooooo
ooooo`06ooooo`0300000?oooooooooo00cooooo00<00000ooooooooool06?ooool2000009?ooooo
001Fooooo`0300000?oooooooooo01Cooooo00<00000ooooooooool01_ooool00`00003ooooooooo
o`05ooooo`03o`000?oooooooooo00Kooooo00<00000ooooooooool01Oooool00`00003ooooooooo
o`0?ooooo`03o`000?ooool0000006kooooo00<00000ooooooooool02oooool00`00003ooooooooo
o`03ooooo`0300000?oooooooooo00;ooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`0<ooooo`0300000?oooooooooo01Wooooo0P00002Cooooo`00E_ooool00`00003oooooooooo`0D
ooooo`0300000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00`00003oooooooooo`06
ooooo`0300000?oooooooooo00Gooooo00?o0000ooooooooool03oooool00`00003ooooo0000001^
ooooo`0300000?oooooooooo00_ooooo00<00000ooooooooool00oooool00`00003oooooooooo`02
ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool03?ooool00`00003oooooooooo`0I
ooooo`800000Toooool005Kooooo00<00000ooooooooool04oooool00`00003oooooooooo`06oooo
o`0300000?oooooooooo00Gooooo00<00000ooooooooool01_ooool00`00003oooooooooo`06oooo
o`0300000?oooooooooo00oooooo00<00000ooooo`000000K_ooool00`00003oooooooooo`0:oooo
o`0300000?oooooooooo00?ooooo00<00000ooooooooool00_ooool00`00003oooooooooo`06oooo
o`0300000?oooooooooo00cooooo00<00000ooooooooool06oooool00`00003oooooooooo`2Aoooo
o`00E_ooool00`00003oooooooooo`0Cooooo`0300000?oooooooooo00Kooooo00<00000oooooooo
ool01Oooool00`00003oooooooooo`06ooooo`0300000?oooooooooo00Gooooo00<00000oooooooo
ool04Oooool2000006kooooo00<00000o`000?ooool02_ooool00`00003oooooooooo`03ooooo`05
o`000?ooool00000o`00000000002?ooool00`00003oooooooooo`0<ooooo`03o`000?oooooooooo
01cooooo00<00000ooooooooool0BOooool2o`0004Kooooo001Fooooo`0300000?oooooooooo01?o
oooo00<00000ooooooooool01_ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo00Ko
oooo00<00000ooooooooool01Oooool00`00003oooooooooo`0Aooooo`800000K_ooool00`00003o
ooooooooo`0:ooooo`0300000?oooooooooo00?ooooo0P00000;ooooo`0300000?oooooooooo00co
oooo00<00000ooooooooool07?ooool00`00003oooooooooo`2Aooooo`00E_ooool00`00003ooooo
ooooo`0Cooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01Oooool00`00003ooooo
ooooo`06ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool04oooool00`00003ooooo
ooooo`1/ooooo`0300000?oooooooooo00Wooooo00<00000ooooooooool00oooool2000000_ooooo
00<00000ooooooooool03?ooool00`00003oooooooooo`0Mooooo`0300000?oooooooooo097ooooo
001Fooooo`0300000?oooooooooo01?ooooo00?o0000ooooooooool01Oooool00`00003ooooooooo
o`05ooooo`0300000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00`00003ooooooooo
o`0Cooooo`0300000?oooooooooo06cooooo00<00000ooooooooool02Oooool00`00003ooooooooo
o`02ooooo`8000002oooool00`00003oooooooooo`0<ooooo`0300000?oooooooooo01kooooo00<0
0000ooooooooool0TOooool005Kooooo00<00000ooooooooool04oooool00`00003oooooooooo`05
ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01_ooool00ol0003oooooooooo`05
ooooo`0300000?oooooooooo01?ooooo00<00000ooooooooool0K?ooool00`00003oooooooooo`09
ooooo`0300000?oooooooooo00;ooooo0P00000;ooooo`0300000?oooooooooo00cooooo00<00000
ooooooooool07_ooool00`00003oooooooooo`2Aooooo`00E_ooool00`00003oooooooooo`0Coooo
o`0300000?oooooooooo00Gooooo00<00000ooooooooool01Oooool00`00003oooooooooo`06oooo
o`03o`000?oooooooooo00Gooooo00<00000ooooooooool04oooool00`00003oooooooooo`1/oooo
o`0300000?oooooooooo00Wooooo00L00000oooooooooooooooo00000?ooool0000000_ooooo00<0
0000ooooooooool03?ooool00`00003oooooooooo`0Nooooo`0300000?oooooooooo097ooooo001F
ooooo`0300000?oooooooooo01;ooooo00<00000ooooooooool01_ooool00`00003oooooooooo`05
ooooo`0300000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00`00003oooooooooo`0C
ooooo`0300000?oooooooooo06cooooo00<00000o`000?ooool02Oooool01P00003oooooooooo`00
003ooooo000000_ooooo00<00000ooooooooool03Oooool00`00003oooooooooo`0Nooooo`030000
0?oooooooooo04Wooooo0_l00016ooooo`00E_ooool00`00003oooooooooo`0Booooo`0300000?oo
oooooooo00Kooooo00<00000ooooooooool01Oooool00`00003oooooooooo`05ooooo`03o`000?oo
oooooooo00Kooooo00<00000ooooooooool04oooool00`00003oooooooooo`1/ooooo`0300000?oo
oooooooo00Wooooo00<00000ooooo`0000000_ooool00`00003oooooooooo`09ooooo`0300000?oo
oooooooo00cooooo00<00000ooooooooool07oooool00`00003oooooooooo`2Aooooo`00E_ooool0
0`00003oooooooooo`0Booooo`0300000?oooooooooo00Kooooo00<00000ooooooooool01Oooool0
0`00003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00<00000ooooooooool04oooool0
0`00003oooooooooo`1/ooooo`0300000?oooooooooo00Wooooo00<00000ooooo`0000000_ooool0
0`00003oooooooooo`09ooooo`03o`000?oooooooooo00cooooo00<00000ooooooooool07oooool0
0`00003oooooooooo`2Aooooo`00COooool01Oo^k^ko<S8bo`000?lb<S;ok^k^00Cooooo00<00000
ooooooooool04_ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo00Kooooo00<00000
ooooooooool01Oooool00ol0003oooooooooo`06ooooo`0300000?oooooooooo01?ooooo00<00000
ooooooooool0I?ooool01Oo^k^ko<S8bo`000?lb<S;ok^k^00?ooooo00<00000ooooooooool02Ooo
ool2000000?ooooo00<00000ooooooooool02Oooool00`00003oooooooooo`0<ooooo`0300000?oo
oooooooo01oooooo00<00000ooooooooool0TOooool004gooooo00GoMgMgoiRHV?ooooooV9RHogMg
M`04ooooo`0300000?oooooooooo01;ooooo00<00000ooooooooool01Oooool00`00003ooooooooo
o`06ooooo`0300000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00`00003ooooooooo
o`0Cooooo`0300000?oooooooooo06Cooooo00GoMgMgoiRHV?ooooooV9RHogMgM`03ooooo`030000
0?oooooooooo00Wooooo00<00000o`000?ooool00_ooool00`00003oooooooooo`09ooooo`030000
0?oooooooooo00cooooo00<00000ooooooooool07oooool00`00003oooooooooo`2Aooooo`00COoo
ool01Ol@413ooooooooooooooooo410@00CoooooVP0000000ol0003oooooooooo`0Gooooo`05oa0@
4?ooooooooooooooool@41000ooooonK00000003o`000?oooooooooo04Cooooo001=ooooo`05o`00
0?ooooooooooooooool000001?ooool00`00003oooooooooo`0Booooo`0300000?oooooooooo00Go
oooo00<00000ooooooooool01_ooool00`00003oooooooooo`05ooooo`03o`000?oooooooooo00Ko
oooo00<00000ooooooooool04oooool00`00003oooooooooo`1Tooooo`05o`000?oooooooooooooo
ool000000oooool00`00003oooooooooo`09ooooo`8000000oooool00`00003oooooooooo`09oooo
o`0300000?oooooooooo00cooooo00<00000ooooooooool07oooool00`00003oooooooooo`2Aoooo
o`00COooool01Ol0003ooooooooooooooooo000000Cooooo00<00000ooooooooool04_ooool00`00
003oooooooooo`05ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool01Oooool00ol0
003oooooooooo`06ooooo`0300000?oooooooooo01?ooooo00<00000ooooooooool0I?ooool01Ol0
003ooooooooooooooooo000000?ooooo00<00000ooooooooool02Oooool2000000?ooooo00<00000
ooooooooool02Oooool00`00003oooooooooo`0<ooooo`0300000?oooooooooo01oooooo00<00000
ooooooooool0TOooool004gooooo00Go410@oooooooooooooooooa0@4004ooooo`0300000?oooooo
oooo01;ooooo00<00000ooooooooool01Oooool00`00003oooooooooo`06ooooo`0300000?oooooo
oooo00Gooooo00?o0000ooooooooool01_ooool00`00003oooooooooo`0Cooooo`0300000?oooooo
oooo06Cooooo00Go410@oooooooooooooooooa0@4003ooooo`0300000?oooooooooo00Wooooo00<0
0000o`000?ooool00_ooool00`00003oooooooooo`09ooooo`0300000?oooooooooo00cooooo00<0
0000ooooooooool07oooool00`00003oooooooooo`2Aooooo`00COooool01OmgMgOoV9RHoooooonH
V9SoMgMg00Cooooo00<00000ooooooooool04_ooool00`00003oooooooooo`06ooooo`0300000?oo
oooooooo00Gooooo00<00000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`0300000?oo
oooooooo01?ooooo00<00000ooooooooool0I?ooool01OmgMgOoV9RHoooooonHV9SoMgMg00?ooooo
00<00000ooooooooool02Oooool2000000?ooooo00<00000ooooooooool02Oooool00`00003ooooo
ooooo`0<ooooo`0300000?oooooooooo01oooooo00<00000ooooooooool0TOooool004gooooo00Go
k^k^oc8b<_l0003o<S8bonk^kP04ooooo`0300000?oooooooooo01;ooooo00<00000ooooooooool0
1_ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo00Gooooo00?o0000ooooooooool0
1_ooool00`00003oooooooooo`0Cooooo`0300000?oooooooooo06Cooooo00Gok^k^oc8b<_l0003o
<S8bonk^kP03ooooo`0300000?oooooooooo00Wooooo00<00000ooooo`0000000_ooool00`00003o
ooooooooo`09ooooo`03o`000?oooooooooo00cooooo00<00000ooooooooool07oooool00`00003o
ooooooooo`2Aooooo`00E_ooool00`00003oooooooooo`0Booooo`0300000?oooooooooo00Kooooo
00<00000ooooooooool01Oooool00`00003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo
00<00000ooooooooool04oooool00`00003oooooooooo`1/ooooo`0300000?l0003ooooo00Wooooo
00H00000ooooooooool00000ooooo`00000;ooooo`0300000?oooooooooo00gooooo00?o0000oooo
ooooool07_ooool00`00003oooooooooo`19ooooo`;o0000A_ooool005Kooooo00<00000oooooooo
ool04oooool00`00003oooooooooo`05ooooo`0300000?oooooooooo00Gooooo00<00000oooooooo
ool01_ooool00ol0003oooooooooo`05ooooo`0300000?oooooooooo01?ooooo00<00000oooooooo
ool0K?ooool00`00003oooooooooo`09ooooo`0700000?ooooooooooooooo`00003ooooo0000000;
ooooo`0300000?oooooooooo00cooooo00<00000ooooooooool07_ooool00`00003oooooooooo`2A
ooooo`00E_ooool00`00003oooooooooo`0Cooooo`0300000?oooooooooo00Gooooo00<00000oooo
ooooool01Oooool00`00003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00<00000oooo
ooooool04oooool00`00003oooooooooo`1/ooooo`0300000?oooooooooo00Wooooo00<00000oooo
ooooool00_ooool00ol000000000ooooo`0:ooooo`0300000?oooooooooo00cooooo00<00000oooo
ooooool07_ooool00`00003oooooooooo`2Aooooo`00E_ooool00`00003oooooooooo`0Cooooo`03
00000?oooooooooo00Gooooo00<00000ooooooooool01Oooool00`00003oooooooooo`06ooooo`03
o`000?oooooooooo00Gooooo00<00000ooooooooool04oooool00`00003oooooooooo`1/ooooo`03
00000?oooooooooo00Wooooo00<00000ooooooooool00oooool00`00003oooooooooo`09ooooo`03
00000?oooooooooo00cooooo00<00000ooooooooool07_ooool00`00003oooooooooo`2Aooooo`00
E_ooool00`00003oooooooooo`0Cooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool0
1Oooool00`00003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00<00000ooooooooool0
4Oooool2000006kooooo00<00000ooooooooool02_ooool00`00003oooooooooo`03ooooo`<00000
2Oooool00`00003oooooooooo`0<ooooo`0300000?oooooooooo01gooooo00<00000ooooooooool0
TOooool005Kooooo00<00000ooooooooool04oooool00ol0003oooooooooo`06ooooo`0300000?oo
oooooooo00Gooooo00<00000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`0300000?oo
oooooooo017ooooo0P00001^ooooo`0300000?l0003ooooo00[ooooo00<00000ooooooooool00ooo
ool01000003oooooooooo`000009ooooo`0300000?oooooooooo00cooooo00<00000ooooooooool0
7?ooool00`00003oooooooooo`19ooooo`;o0000A_ooool005Kooooo00<00000ooooooooool04ooo
ool00`00003oooooooooo`06ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01_oo
ool00ol0003oooooooooo`05ooooo`0300000?oooooooooo017ooooo0P00001^ooooo`0300000?oo
oooooooo00[ooooo00?o0000ooooooooool00oooool01Ol0003ooooooooooooooooo000000Sooooo
00?o0000ooooooooool03?ooool00`00003oooooooooo`0Looooo`0300000?oooooooooo097ooooo
001Fooooo`0300000?oooooooooo01?ooooo00<00000ooooooooool01_ooool00`00003ooooooooo
o`05ooooo`0300000?oooooooooo00Kooooo00?o0000ooooooooool01_ooool00`00003ooooooooo
o`0?ooooo`0300000?ooool0000006kooooo00<00000ooooooooool02_ooool00`00003ooooooooo
o`03ooooo`0500000?ooooooooooooooo`0000002?ooool00`00003oooooooooo`0=ooooo`030000
0?oooooooooo01_ooooo00<00000ooooooooool0TOooool005Kooooo00<00000ooooooooool05?oo
ool00`00003oooooooooo`05ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool01_oo
ool00ol0003oooooooooo`05ooooo`0300000?oooooooooo00oooooo00<00000ooooo`000000K_oo
ool00`00003oooooooooo`0;ooooo`0300000?oooooooooo00?ooooo00D00000oooooooooooooooo
00000008ooooo`0300000?oooooooooo00cooooo00<00000ooooooooool06_ooool2000009?ooooo
001Fooooo`0300000?oooooooooo01Cooooo00<00000ooooooooool01_ooool00ol0003ooooooooo
o`05ooooo`0300000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool2000000oooooo0P00
00000oooool00000ooooo`1]ooooo`0300000?oooooooooo00_ooooo00<00000ooooooooool00ooo
ool00`00003oooooooooo`02ooooo`0300000?l0003ooooo00Kooooo00<00000ooooooooool03?oo
ool00`00003oooooooooo`0Iooooo`800000Toooool005Kooooo00<00000ooooooooool05?ooool0
0`00003oooooooooo`06ooooo`0300000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`07ooooo`0300000?oooooooooo00_ooooo00D00000oooooooooooooooo0000
001^ooooo`0300000?oooooooooo00_ooooo00<00000ooooooooool00oooool00`00003ooooooooo
o`03ooooo`0300000?oooooooooo00Kooooo00?o0000ooooooooool03?ooool00`00003ooooooooo
o`0Hooooo`800000Toooool005Kooooo00<00000ooooooooool05Oooool00`00003oooooooooo`06
ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01_ooool00ol0003oooooooooo`07
ooooo`0300000?oooooooooo00Wooooo00?o0000ooooooooool00_ooool00`00003o0000ooooo`1/
ooooo`0300000?l0003ooooo00cooooo00<00000ooooooooool00oooool00`00003oooooooooo`03
ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool03?ooool00`00003oooooooooo`0G
ooooo`800000Boooool2o`0004Kooooo001Fooooo`0300000?oooooooooo01Gooooo00<00000oooo
ooooool01_ooool00`00003oooooooooo`06ooooo`0300000?oooooooooo00Kooooo00?o0000oooo
ooooool01_ooool00ol00000000000000008ooooo`8000001?ooool00`00003o0000ooooo`1/oooo
o`0300000?oooooooooo00cooooo00<00000ooooooooool01?ooool00`00003oooooooooo`03oooo
o`0300000?oooooooooo00Kooooo00<00000ooooooooool02oooool00ol0003oooooooooo`0Goooo
o`800000Toooool005Kooooo00<00000ooooooooool05Oooool00`00003oooooooooo`06ooooo`03
00000?oooooooooo00Kooooo00<00000ooooooooool01oooool00ol0003oooooooooo`08ooooo`P0
00001_ooool00`00003o0000ooooo`1/ooooo`0300000?oooooooooo00cooooo00<00000oooooooo
ool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo00<00000oooooooo
ool03?ooool00`00003oooooooooo`0Fooooo`800000Toooool004gooooo1Ol00004ooooo`030000
0?oooooooooo01Kooooo00<00000ooooooooool01_ooool00`00003oooooooooo`06ooooo`030000
0?oooooooooo00Oooooo0_l0000Fooooo`0300000?oooooo000006Cooooo1Ol00003ooooo`030000
0?oooooooooo00gooooo00<00000ooooooooool01?ooool00`00003oooooooooo`04ooooo`030000
0?oooooooooo00Gooooo00<00000ooooooooool03?ooool00`00003oooooooooo`0Dooooo`04o`00
0?ooool00000000009;ooooo001=ooooo`05oiRHV?lQ8B7ok^k^oooooom4A4@01?ooool00`00003o
ooooooooo`0Fooooo`0300000?oooooooooo00Kooooo00<00000o`000?ooool01oooool00`00003o
ooooooooo`08ooooo`;o00005?ooool00`00003oooooo`00001Tooooo`05oiRHV?lQ8B7ok^k^oooo
oom4A4@00oooool00`00003oooooooooo`0=ooooo`0300000?oooooooooo00Gooooo00<00000oooo
ooooool01?ooool00`00003oooooooooo`05ooooo`03o`000?oooooooooo00cooooo00<00000oooo
ooooool04oooool01000003ooooo00000000002Booooo`00C_ooool00onHV9So8B4Qonk^kP05oooo
o`0300000?l0003ooooo01Kooooo00<00000ooooooooool01oooool00`00003oooooooooo`06oooo
o`0300000?oooooooooo00[ooooo0_l0000Booooo`0300000?oooooo000004Wooooo0_l0000Joooo
o`03oiRHV?lQ8B7ok^k^00Cooooo00<00000o`000?ooool03Oooool00`00003oooooooooo`05oooo
o`0300000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00`00003oooooooooo`0<oooo
o`0300000?oooooooooo01;ooooo00@00000ooooo`0000000000B_ooool2o`0004Kooooo001?oooo
o`03oiRHV?lQ8B7ok^k^00Cooooo00<00000ooooooooool05oooool00`00003oooooooooo`07oooo
o`0300000?oooooooooo00Kooooo00<00000ooooooooool02oooool00ol0003oooooooooo`0?oooo
o`0400000?ooooooooooo`0006Gooooo00?oV9RHob4Q8Oo^k^h00oooool00`00003oooooooooo`0>
ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01Oooool00`00003oooooooooo`05
ooooo`8000003Oooool00`00003oooooooooo`0@ooooo`0300000?ooool0000000800000T_ooool0
053ooooo00?oMgMgofIVI_ooool00oooool00`00003oooooooooo`0Gooooo`0300000?oooooooooo
00Oooooo00<00000ooooooooool01oooool00`00003oooooooooo`0;ooooo`;o00003oooool01000
003oooooooooool0001Vooooo`03ogMgMomVIVKooooo00;ooooo00<00000ooooooooool03oooool0
0`00003oooooooooo`05ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01_ooool2
000000cooooo0P00000?ooooo`03o`000?oooooooooo00<00000T_ooool0057ooooo00?o0000oooo
ooooool00_ooool00`00003oooooooooo`0Gooooo`0300000?oooooooooo00Oooooo00<00000oooo
ooooool02?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00@00000oooo
oooooooo0000Ioooool01Ol0003oooooooooooooool00000017ooooo00<00000ooooooooool01Ooo
ool00`00003oooooooooo`06ooooo`03o`000?oooooooooo00Oooooo0P00000<ooooo`0300000?oo
oooooooo00[ooooo0P000003ooooo`<00000T_ooool004gooooo00Go0000okZj^_ooooooV9RHoa0@
4004ooooo`0300000?oooooooooo01Sooooo00<00000ooooooooool01oooool00`00003ooooooooo
o`08ooooo`0300000?oooooooooo00cooooo0_l0000;ooooo`8000000_ooool00ol0003ooooooooo
o`1Qooooo`05o`000?nj^[[ooooooiRHV?l@41000oooool00`00003oooooooooo`0@ooooo`030000
0?oooooooooo00Gooooo00<00000ooooooooool01_ooool00`00003oooooooooo`08ooooo`030000
0?oooooooooo00[ooooo0`000008ooooo`0300000?oooooooooo00?ooooo0P0000000oooool00000
ooooo`2@ooooo`00COooool01OnHV9So410@o`000?lQ8B7oc<c<00Cooooo00<00000ooooooooool0
6Oooool00`00003oooooooooo`07ooooo`0300000?oooooooooo00Sooooo00<00000ooooooooool0
3Oooool00ol0003oooooooooo`08ooooo`8000000_ooool00ol0003oooooooooo`1Qooooo`05oiRH
V?l@413o0000ob4Q8Oo<c<`00oooool00`00003oooooooooo`0@ooooo`0300000?l0003ooooo00Ko
oooo00<00000ooooooooool01_ooool00`00003oooooooooo`08ooooo`8000003Oooool500000003
o`0000000000000000Kooooo0P000002ooooo`0300000?oooooooooo08kooooo001Fooooo`030000
0?oooooooooo01Wooooo00<00000ooooooooool01oooool00`00003oooooooooo`08ooooo`030000
0?oooooooooo00gooooo00?o0000ooooooooool02?ooool2000000;ooooo00?o0000ooooooooool0
JOooool00`00003o0000ooooo`0Aooooo`0300000?oooooooooo00Kooooo00?o0000ooooooooool0
1_ooool00ol000000000ooooo`09ooooo`0300000?oooooooooo01Sooooo0P000002ooooo`030000
0?oooooooooo04Kooooo0_l00016ooooo`00E_ooool00`00003oooooooooo`0Jooooo`0300000?oo
oooooooo00Oooooo00<00000ooooooooool02?ooool2000000kooooo0_l00007ooooo`05o`000?oo
ool00000ooooool00000K?ooool00`00003oooooooooo`0Booooo`0300000?oooooooooo00Kooooo
00<00000ooooooooool01oooool00`00003oooooooooo`08ooooo`<000005oooool2000000?ooooo
00<00000ooooooooool0SOooool005Kooooo00<00000ooooooooool06oooool00`00003ooooooooo
o`07ooooo`0300000?oooooooooo00Wooooo00<00000ooooooooool03Oooool00ol0003ooooooooo
o`04ooooo`0300000?ooool0000000;o0000K?ooool00`00003oooooooooo`0Cooooo`0300000?oo
oooooooo00Kooooo00<00000ooooooooool01oooool2000000_ooooo0`0000000ol0000000000000
000Aooooo`8000000oooool00`00003oooooooooo`2=ooooo`00E_ooool00`00003oooooooooo`0K
ooooo`0300000?oooooooooo00Sooooo00?o0000ooooooooool02?ooool00`00003oooooooooo`0=
ooooo`03o`000?oooooooooo00?ooooo00@00000ooooooooool00000K_ooool00`00003ooooooooo
o`0Cooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool02Oooool00`00003ooooooooo
o`0>ooooo`<000003_ooool2000000?ooooo00<00000ooooooooool0SOooool005Kooooo00<00000
ooooooooool07?ooool00`00003oooooooooo`08ooooo`0300000?oooooooooo00Sooooo0`00000=
ooooo`?o000000Kooooo00000?ooooooooooo`000000001^ooooo`0300000?oooooooooo01Cooooo
00<00000ooooooooool01_ooool2000000[ooooo00<00000ooooooooool04?ooool3000000[ooooo
00?o0000ooooo`0000000_ooool00`00003oooooooooo`2>ooooo`00E_ooool00`00003ooooooooo
o`0Mooooo`03o`000?oooooooooo00Sooooo00<00000ooooooooool02_ooool00`00003ooooooooo
o`0;ooooo`8000001?l000000oooool00000ooooo`1]ooooo`0300000?l0003ooooo01Gooooo00?o
0000ooooooooool01oooool00`00003oooooooooo`08ooooo`8000004oooool00`00003ooooooooo
o`06ooooo`0400000?oooooooooo000000;ooooo00<00000ooooooooool0A_ooool2o`0004Kooooo
001Fooooo`0300000?oooooooooo01kooooo00<00000ooooooooool02?ooool00ol0003ooooooooo
o`0:ooooo`03o`0000000000000000Sooooo0P000007ooooo`0300000?oooooooooo06cooooo00<0
0000ooooooooool05Oooool00`00003oooooooooo`07ooooo`0300000?oooooooooo00[ooooo00<0
0000ooooooooool04Oooool00ol000000000ooooo`05ooooo`0400000?oooooooooo000000;ooooo
00<00000ooooooooool0S_ooool005Kooooo00<00000ooooooooool07oooool00`00003ooooooooo
o`08ooooo`0300000?oooooooooo00cooooo0`000002ooooo`<000002Oooool00`00003ooooooooo
o`1/ooooo`0300000?oooooooooo01Kooooo00<00000ooooooooool01oooool00`00003ooooooooo
o`0:ooooo`0300000?oooooooooo01;ooooo00<00000ooooooooool00_ooool01`00003ooooooooo
ooooool00000ooooo`000000TOooool005Kooooo00<00000ooooooooool08?ooool00`00003ooooo
ooooo`08ooooo`0300000?oooooooooo00kooooo0P00000<ooooo`0300000?oooooooooo06cooooo
00<00000ooooooooool05oooool00`00003oooooooooo`07ooooo`0300000?oooooooooo00[ooooo
00<00000ooooooooool04_ooool01000003oooooooooool00004ooooo`0300000?l0003ooooo097o
oooo001Fooooo`0300000?oooooooooo023ooooo00?o000000000?ooool02Oooool2000001cooooo
00<00000ooooooooool01Oooool00`00003oooooooooo`1Tooooo`0300000?oooooooooo01Oooooo
00?o000000000?ooool02?ooool00`00003oooooooooo`0:ooooo`0300000?l000000000017ooooo
00Co000000000000000000001?ooool2000009;ooooo001Fooooo`0300000?oooooooooo02;ooooo
00<00000ooooooooool02Oooool00`00003oooooooooo`0Iooooo`0300000?oooooooooo00Cooooo
00<00000ooooo`000000IOooool00`00003oooooooooo`0Iooooo`0300000?oooooooooo00Oooooo
00?o000000000?ooool03?ooool00`00003oooooooooo`0?ooooo`0300000?ooool0000000D00000
Toooool005Kooooo00<00000ooooooooool08oooool00`00003oooooooooo`09ooooo`<000006?oo
ool00`00003oooooooooo`03ooooo`0500000?ooooooooooooooo`000000I?ooool00`00003o0000
ooooo`0Jooooo`0300000?oooooooooo00Sooooo00<00000ooooooooool02oooool00`00003ooooo
ooooo`0<ooooo`8000001oooool00`00003oooooooooo`19ooooo`;o0000A_ooool005Kooooo00<0
0000ooooooooool08oooool00ol000000000ooooo`0<ooooo`8000005_ooool00`00003ooooooooo
o`02ooooo`0300000?oooooooooo00?ooooo00?o0000ooooooooool0HOooool00`00003ooooooooo
o`0Jooooo`03o`000000003ooooo00Wooooo0P00000<ooooo`03o`00000000000000008000001Ooo
ool4000000Wooooo00<00000ooooooooool0TOooool005Kooooo00<00000ooooooooool09Oooool0
0`00003oooooooooo`0<ooooo`8000005?ooool00`00003oooooooooo`02ooooo`0300000?oooooo
oooo00?ooooo00<00000ooooooooool0HOooool00`00003oooooooooo`0Looooo`0300000?oooooo
oooo00Wooooo0P00000?ooooo`D000003Oooool00`00003oooooooooo`2Aooooo`00Coooool2o`00
0003oa0@4?oooooooooo00;ooooo00<00000ooooooooool09_ooool00`00003oooooooooo`0=oooo
o`0300000?oooooooooo013ooooo0P000005ooooo`0300000?oooooooooo00;ooooo00<00000oooo
ooooool0Foooool2o`000005oa0@4?ooooooooooooooo`0000007oooool00`00003oooooooooo`0:
ooooo`0300000?oooooooooo01kooooo00<00000ooooooooool01oooool2000008Sooooo001@oooo
o`03o`000?oooooooooo00?ooooo00<00000ooooooooool09oooool00ol0003oooooooooo`0=oooo
o`03o`000000003ooooo00kooooo00<00000o`00000000001_ooool01000003o000000000000001O
ooooo`03o`000?oooooooooo00;ooooo00<00000ooooooooool07_ooool00ol0003oooooooooo`0:
ooooo`03o`000000003ooooo01gooooo00<00000ooooooooool01_ooool01000003oooooooooo`00
0027ooooo`00COooool5o`0000Cooooo00<00000o`000?ooool0:?ooool00`00003oooooooooo`0>
ooooo`8000003Oooool00`00003ooooo0000001;ooooo`;o00006Oooool5o`0000?ooooo00<00000
o`000?ooool07oooool00`00003oooooooooo`0;ooooo`<000006oooool00`00003oooooooooo`06
ooooo`0400000?oooooooooo000003oooooo0_l00016ooooo`00COooool01?m4A4CogMgMooooool0
0005ooooo`0300000?oooooooooo02Wooooo0P00000@ooooo`0300000?oooooooooo00Wooooo00<0
0000ooooooooool00P00001Uooooo`04odA4A?oMgMgoooooo`0000Cooooo00<00000ooooooooool0
8?ooool2000000kooooo0`00000Gooooo`8000001oooool00`00003oooooooooo`02ooooo`030000
0?oooooooooo08Cooooo001=ooooo`04omgMgOmEEEGoooooo`0000Gooooo00<00000ooooooooool0
:oooool00`00003oooooooooo`0>ooooo`<000001Oooool200000006o`000?ooooooooooooooo`00
003o0000IOooool01?oMgMgoEEEEooooool00004ooooo`0300000?oooooooooo02;ooooo00<00000
ooooooooool03_ooool3000001Cooooo00?o000000000?ooool01_ooool2000000?ooooo00<00000
ooooooooool0Q?ooool004kooooo00?oMgMgolc<c?l000001Oooool00`00003oooooooooo`0/oooo
o`03o`000000003ooooo013ooooo1@000006ooooo`0300000?ooool0000006Gooooo00?oMgMgolc<
c?l000001?ooool00`00003oooooooooo`0Sooooo`03o`000000003ooooo013ooooo0P00000Aoooo
o`0300000?ooool0000000Wooooo00<00000ooooo`000000Qoooool004kooooo00?ok^k^odA4A?l0
00001Oooool00`00003oooooooooo`0^ooooo`0300000?oooooooooo01Wooooo00<00000ooooo`00
0000IOooool00oo^k^koA4A4o`000004ooooo`0300000?oooooooooo02Gooooo00<00000oooooooo
ool04?ooool00`00003oooooooooo`0>ooooo`0400000?ooool00000000000Wooooo00<00000oooo
ooooool0Q_ooool004oooooo00?oMgMgo`000?ooool01?ooool00`00003oooooooooo`0_ooooo`80
00006Oooool01000003oooooooooo`00001Uooooo`03ogMgMol0003ooooo00?ooooo00<00000oooo
ooooool09_ooool20000017ooooo00<00000o`000?ooool03?ooool01@00003oooooooooo`00003o
000009;ooooo001Fooooo`0300000?oooooooooo037ooooo00<00000ooooooooool05_ooool01000
003oooooooooo`00001[ooooo`0300000?l0003ooooo02Sooooo0P00000Aooooo`0300000?oooooo
oooo00Wooooo00@00000oooooooooooooooo0P00001:ooooo`;o0000A_ooool005Kooooo00<00000
ooooooooool0<_ooool70000017ooooo00D00000oooooooooooooooo0000001Zooooo`0300000?oo
oooooooo02[ooooo00<00000ooooooooool03oooool3000000Kooooo0P000004ooooo`0300000?oo
ool00000097ooooo001Fooooo`0300000?oooooooooo03Wooooo2@000008ooooo`0500000?oooooo
ooooooooo`000000J_ooool00`00003oooooooooo`0[ooooo`03o`000000003ooooo017ooooo1P00
0006ooooo`0400000?oooooooooo0000093ooooo001Fooooo`0300000?oooooooooo04;ooooo00?o
000000000?ooool01Oooool01@00003oooooooooooooool0000006[ooooo00<00000ooooooooool0
;Oooool2000001cooooo00@00000ooooooooool00000T?ooool005Kooooo00<00000ooooooooool0
A?ooool00`00003oooooooooo`03ooooo`0500000?ooooooooooooooo`000000J_ooool00`00003o
ooooooooo`0_ooooo`0300000?oooooooooo01Wooooo00D00000oooooooooooooooo0000002?oooo
o`00E_ooool00`00003oooooooooo`15ooooo`0300000?oooooooooo00;ooooo00D00000oooooooo
oooooooo0000001Zooooo`0300000?l0003ooooo033ooooo1P00000Eooooo`0600000?oooooooooo
ooooool000000000A_ooool2o`0004Kooooo001Fooooo`0300000?oooooooooo04Gooooo00?o0000
00000?ooool00_ooool01@00003oooooooooooooool0000006[ooooo00<00000ooooooooool0=_oo
ool?000000Kooooo00<00000ooooooooool00_ooool00`00003oooooooooo`2<ooooo`00E_ooool0
0`00003oooooooooo`17ooooo`0400000?oooooooooo000000;ooooo00<00000ooooooooool0JOoo
ool00`00003oooooooooo`15ooooo`0300000?oooooooooo00?ooooo00<00000ooooooooool00_oo
ool00`00003oooooooooo`2<ooooo`00E_ooool00`00003oooooooooo`18ooooo`D00000K?ooool0
0`00003oooooooooo`16ooooo`0300000?oooooooooo00;ooooo00<00000ooooooooool00_ooool0
0`00003oooooooooo`2<ooooo`00E_ooool00`00003oooooooooo`1:ooooo`0300000?oooooooooo
06cooooo00<00000ooooooooool0A_ooool00ol000000000ooooo`02ooooo`0300000?oooooooooo
00;ooooo00?o0000ooooooooool0S?ooool005Kooooo00<00000ooooooooool0B_ooool00`00003o
ooooooooo`1/ooooo`0300000?oooooooooo04Sooooo00@00000ooooooooool000000oooool00`00
003oooooooooo`2=ooooo`00E_ooool00`00003oooooooooo`1:ooooo`0300000?oooooooooo06co
oooo00<00000o`000?ooool0BOooool00`00003ooooo00000002ooooo`0300000?oooooooooo04Ko
oooo0_l00016ooooo`00E_ooool00`00003oooooooooo`1:ooooo`0300000?oooooooooo06cooooo
00<00000ooooooooool0B_ooool01?l00000000000000?l0002Aooooo`00E_ooool00`00003ooooo
ooooo`1:ooooo`0300000?oooooooooo06cooooo00<00000ooooooooool0Boooool00`00003ooooo
ooooo`2Aooooo`00COooool01Oo^k^ko<S8bo`000?l@413oc<c<00Cooooo00<00000ooooooooool0
B_ooool00`00003oooooooooo`1Tooooo`05onk^k_lb<S;o0000oa0@4?o<c<`00oooool00`00003o
ooooooooo`1;ooooo`0300000?oooooooooo097ooooo001=ooooo`05oeEEEOmgMgOooooooiRHV?lQ
8B401?ooool00`00003oooooooooo`1:ooooo`0300000?oooooooooo06Cooooo00GoEEEEogMgMooo
ooooV9RHob4Q8@03ooooo`0300000?oooooooooo04_ooooo00<00000ooooooooool0TOooool004go
oooo00Go0000ooooooooooooooooo`000004ooooo`0300000?oooooooooo04[ooooo00<00000oooo
ooooool0I?ooool01Ol0003ooooooooooooooooo000000?ooooo00<00000ooooooooool0Boooool0
0`00003oooooooooo`2Aooooo`00COooool01Ol0003oV9RHoooooonHV9So8B4Q00Cooooo00<00000
o`000?ooool0B_ooool00`00003oooooooooo`19ooooo`;o00006Oooool01Ol0003oV9RHoooooonH
V9So8B4Q00?ooooo00<00000o`000?ooool0Boooool00`00003oooooooooo`19ooooo`;o0000A_oo
ool004gooooo00Go0000oeEEEOl0003o410@olc<c004ooooo`0300000?oooooooooo04[ooooo00<0
0000ooooooooool0I?ooool01Ol0003oEEEEo`000?l@413oc<c<00?ooooo00<00000ooooooooool0
Boooool00`00003oooooooooo`2Aooooo`00COooool00omEEEGoQhN7ooooo`06ooooo`0300000?oo
oooooooo04[ooooo00<00000ooooooooool0I?ooool00omEEEGoQhN7ooooo`05ooooo`0300000?oo
oooooooo04_ooooo00<00000ooooooooool0TOooool004gooooo00?ogMgMoa0@4?nHV9P01_ooool0
0`00003oooooooooo`1:ooooo`0300000?oooooooooo06Cooooo00?ogMgMoa0@4?nHV9P01Oooool0
0`00003oooooooooo`1;ooooo`0300000?oooooooooo097ooooo001>ooooo`04olc<c?m4A4Co0000
oa0@40Cooooo00<00000ooooooooool0B_ooool00`00003oooooooooo`1Uooooo`04olc<c?m4A4Co
0000oa0@40?ooooo00<00000ooooooooool0Boooool00`00003oooooooooo`2Aooooo`00E_ooool0
0`00003oooooooooo`1:ooooo`0300000?oooooooooo06cooooo00<00000o`000?ooool0Boooool0
0`00003oooooooooo`19ooooo`;o0000A_ooool005Kooooo00<00000ooooooooool0B_ooool00`00
003oooooooooo`1/ooooo`0300000?oooooooooo04_ooooo00<00000ooooooooool0TOooool005Ko
oooo00<00000ooooooooool0B_ooool00`00003oooooooooo`1/ooooo`0300000?oooooooooo04_o
oooo00<00000ooooooooool0TOooool005Kooooo00<00000ooooooooool0B_ooool00`00003ooooo
ooooo`1/ooooo`0300000?oooooooooo04_ooooo00<00000ooooooooool0TOooool005Kooooo00<0
0000ooooooooool0B_ooool00`00003oooooooooo`1/ooooo`0300000?oooooooooo04_ooooo00<0
0000ooooooooool0TOooool005Kooooo00<00000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`0300000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool09?ooool00`00003oooooooooo`03
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo00<00000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1:
ooooo`00E_oooonJ000002;oooooV`000017ooooo`00oooooooeooooo`00oooooooeooooo`00oooo
oooeooooo`00oooooooeooooo`00oooooooeooooo`00oooooooeooooo`00oooooooeooooo`00oooo
oooeooooo`00oooooooeooooo`00oooooooeooooo`00oooooooeooooo`00oooooooeooooo`00N_oo
ool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo09kooooo00KoV9RHo`000?l0003o0000
oa0@4?mgMgLBooooo`06oiRHV?l0003o0000o`000?l@413oMgMgOOooool007[ooooo00?o0000oooo
ooooool0>oooool00ol0003oooooooooo`2Nooooo`07o`000?nHV9Soooooooooooo<c<co<S8bogMg
M`06ooooo`03olc<c?n7QhOooooo00Sooooo00Oo0000oiRHV?ooooooooooolc<c?lb<S;oMgMg00go
oooo00?oZJVYokZj^_ooool0K?ooool007[ooooo00?o0000ooooooooool0>oooool00ol0003ooooo
ooooo`2Sooooo`03omgMgOl@413ooooo00Cooooo0_nHV9P?ooooo`03omgMgOl@413ooooo00gooooo
00?o^[ZjoiRHV?ooool0Joooool006[ooooo00GoV9RHo`000?l0003o0000oiRHV002ooooo`03olc<
c?lQ8B7ooooo00?ooooo00Ko8B4Qolc<c?oooooo0000oiRHV?l@4102o`000005oiRHV?oooooooooo
ooooool000000_ooool01Ol0003oooooooooooooooooV9RH00?o000000CoV9RHoooooooooooo0000
0_ooool00omgMgOo0000o`000008ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0_ooool01?l0003oooooooooool00003ooooo`06oiRHV?l0003o0000ob4Q8OnYZJWo00000_ooool0
0ol0003oV9RHoa0@4002o`000003oiRHV?oooooooooo00;ooooo00GoV9RHo`000?l0003o0000oiRH
V003ooooo`04o`000?ooooooooooo`0000Cooooo00Co0000ooooooooooooMgMg0_l00008ooooo`03
o`000?oooooooooo00;ooooo00Koc<c<oa0@4?l0003o410@ojVYZOl00002ooooo`05o`000?oooooo
oooooooooonHV9P00ol000000onHV9Soooooooooo`06ooooo`07omgMgOl0003o^[Zjoooooonj^[[o
0000olc<c003ooooo`04o`000?ooooooooooogMgM`;o000000?oooooo`000?ooool00oooool00ol0
003oooooooooo`04ooooo`03oiRHV?l0003o000000;o000000CoV9RHoooooooooooo00001?ooool0
0ol0003oooooooooo`02ooooo`05o`000?oooooooooooooooonHV9P00ol000000onHV9Sooooooooo
o`02ooooo`05oiRHV?l0003o0000o`000?nHV9P00oooool01OmgMgOo0000o`000?oooooo000000Co
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02ooooo`05o`000?oooooooooo
oooooonHV9P00_l000000ol@413oV9RHo`000004ooooo`03omgMgOm4A4Cooooo00;ooooo00?o0000
ooooooooool00_ooool01Ol0003oooooooooooooooooV9RH00;o000000?o410@oiRHV?l000000_oo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooogMgM`;o00000_ooool00omEEEGo^[Zj
ooooo`1Zooooo`00JOooool01onHV9So0000oiRHV?ooooooV9RHo`000?nHV9P00_ooool01?mgMgOo
QhN7ooooooooool2ogMgM`;ooooo00Oo0000ob4Q8OoMgMgooooooiRHV?l0003oV9RH00;ooooo00Co
0000oooooooooooo00000_ooool02OnHV9So0000oiRHV?ooooooV9RHo`000?nHV9Soooooo`000002
ooooo`03o`000?o^k^kooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooo`0000;ooooo00OoV9RHo`000?nHV9SooooookZj^_lQ8B7o000000;o
oooo00Oo0000ob4Q8OoMgMgooooooiRHV?l0003oV9RH00;ooooo00OoV9RHo`000?nHV9SooooooiRH
V?l0003oV9RH00;ooooo00Co0000oooooooooooo00001?ooool01Ol0003oooooooooool0003ok^k^
00Wooooo00?o0000ooooooooool00_ooool01_lQ8B7oMgMgoooooooMgMgo8B4Qo`0000;ooooo00[o
0000ooooooooooooV9RHo`000?nHV9SooooooiRHV?l0003oV9RH1oooool01on7QhOo0000ogMgMooo
ooooMgMgo`000?n7QhL00oooool01Ol0003oooooooooool0003ok^k^00;ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`04ooooo`06o`000?nHV9SooooooooooonHV9So00000_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00[o0000ooooooooooooV9RHo`00
0?nHV9SooooooiRHV?l0003oV9RH0_ooool01onHV9So0000oiRHV?ooooooV9RHo`000?nHV9P00_oo
ool01Ol0003ok^k^oooooooooooo000000Cooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`02ooooo`08o`000?oooooooooooiRHV?l0003oV9RHoooooonj^[X2o`0000Cooooo00?o
EEEEojVYZOooool00_ooool00ol0003oooooooooo`02ooooo`08o`000?oooooooooooiRHV?l0003o
V9RHoooooonj^[X2o`0000;ooooo00?o0000ooooooooool00_ooool01Ol0003oooooooooool0003o
k^k^00?ooooo00?oc<c<odA4A?ooool0J_ooool006Wooooo00?o0000oiRHV?ooool00_ooool00onH
V9So0000ooooo`02ooooo`04ob4Q8OoMgMgogMgMob4Q8@?ooooo00?o0000olc<c?ooool00_ooool0
1OnHV9So0000oooooooooooo000000;ooooo00Go0000oooooooooooo0000oiRHV003ooooo`04oiRH
V?l0003oooooo`0000;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oV9RHooooo`02oooo
o`06ojVYZOl0003oooooooooool0003oc<c<0oooool01_nHV9So0000oooooooooooo0000oiRHV0?o
oooo00GoV9RHo`000?ooooooooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooo00002_ooool00ol0003oooooooooo`02ooooo`06o`000?ooooooooooooooooo<c<co0000
0_ooool01Ol0003oooooooooool0003oV9RH00?ooooo00?oV9RHo`000?ooool01_ooool01olQ8B7o
IVIVodA4A?ooooooA4A4oeEEEOlQ8B400oooool01?l0003oooooooooool00003ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool01?ooool01_l0003oooooooooooooooooc<c<o`0000;o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooo`00
0?nHV9P00oooool01_nHV9So0000oooooooooooo0000oiRHV0?ooooo00GoV9RHo`000?oooooooooo
o`000003ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`02ooooo`05o`000?ooooooooooo`000?nHV9P00oooool00onYZJWo0000ooooo`03oooo
o`03oa0@4?oMgMgooooo00;ooooo00?o0000ooooooooool00_ooool01Ol0003oooooooooool0003o
V9RH00?ooooo00GoZJVYo`000?ooooooooooo`000004ooooo`04o`000?ooooooooooo`0000Gooooo
00?o0000ooooooooool0JOooool006Wooooo00?o0000ooooooooool01oooool01?nj^[[oA4A4oc8b
<_nj^[X3ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00007ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00ooo
ool01?l0003oooooooooool00005ooooo`04o`000?ooooooooooo`0000Gooooo00Co0000oooooooo
oooo00000_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool02_ooool02OoMgMgo0000omgMgOl0003oooooo`000?oMgMgo0000omgMg@02oooo
o`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05
ooooo`05omgMgOnHV9SoEEEEo`000?mgMgL00_ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00;ooooo00Co0000oooooooooooo00001Oooool01?l0003oooooooooool00005ooooo`04
o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001Oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_ooool01?l0003ooooooooo
ool00005ooooo`04o`000?ooooooooooo`0000Cooooo00Co0000oooooooooooo00001Oooool00ol0
003oooooooooo`1Yooooo`00JOooool7o`0000?ooooo00CogMgMoc8b<_lb<S;ogMgM0oooool00ol0
003oooooooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001ooo
ool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooo
oooo00001Oooool01?l0003oooooooooool00005ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool0000:ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`Oo00001_ooool02OnHV9So
EEEEooooool@413o^[Zjo`000?ooooooEEEEoiRHV002ooooo`04o`000?ooooooooooo`0000?ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`05oiRHV?l0003o8B4QoiRHV?o<
c<`00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooo
oooo00001Oooool01?l0003oooooooooool00005ooooo`04o`000?ooooooooooo`0000?ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo
00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00005ooooo`04o`000?oooooooooo
o`0000Cooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`1Yooooo`00JOooool0
0ol0003oV9RHooooo`02ooooo`03oiRHV?l0003ooooo00;ooooo00Co<S8bolc<c?o<c<co<S8b0ooo
ool00ol0003oZJVYooooo`02ooooo`05oiRHV?l0003oooooooooool000000_ooool01Ol0003ooooo
ooooool0003oV9RH00Cooooo00?o0000ooooool000000_ooool00ol0003oooooooooo`08ooooo`03
o`000?o<c<cooooo00;ooooo00?o0000omgMgOooool00_ooool01?l0003oooooooooool00002oooo
o`03o`000?nHV9Sooooo00;ooooo00Ko^[Zjo`000?ooooooooooo`000?nYZJT3ooooo`06oiRHV?l0
003oooooooooool0003oV9RH0oooool01OnHV9So0000oooooooooooo000000;ooooo00?o0000omgM
gOooool00_ooool01?l0003oooooooooool0000:ooooo`03o`000?oMgMgooooo00;ooooo00?o0000
ooooooooool00_ooool01?l0003oooooooooool00002ooooo`03o`000?nHV9Sooooo00;ooooo00?o
V9RHo`000?ooool01Oooool00om4A4CoZJVYooooo`03odA4A003oooooonYZJWoA4A400;ooooo00Co
0000oooooooooooo00000oooool00ol0003ogMgMooooo`02ooooo`03o`000?oooooooooo00Cooooo
00?o0000oiRHV?ooool01Oooool00ol0003oc<c<ooooo`02ooooo`03o`000?oMgMgooooo00;ooooo
00Go0000oooooooooooo0000oiRHV003ooooo`06oiRHV?l0003oooooooooool0003oV9RH0oooool0
1OnHV9So0000oooooooooooo000000?ooooo00?o0000omgMgOooool00_ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oMgMgooooo00;ooooo00Go0000oooooooooooo0000oiRHV003ooooo`03
okZj^_l0003ooooo00?ooooo00?o410@olc<c?ooool00_ooool00ol0003ogMgMooooo`02ooooo`05
o`000?ooooooooooo`000?nHV9P00oooool01_nj^[[o0000oooooooooooo0000omgMg@?ooooo00Co
0000oooooooooooo00001Oooool00ol0003oooooooooo`1Yooooo`00JOooool01onHV9So0000oiRH
V?ooooooV9RHo`000?nHV9P00_ooool2ogMgM`;ooooo0_mgMgL2ooooo`07o`000?lQ8B7oc<c<oooo
oonHV9So0000oiRHV002ooooo`04o`000?ooooooooooo`0000;ooooo00?oV9RHo`000?nHV9P00_oo
ool01?nHV9So0000ooooool00002ooooo`03o`000?oooooooooo00Sooooo00_o0000ob4Q8OoMgMgo
oooooiRHV?l0003oA4A4omgMgOooooooV9RHob4Q8@02ooooo`0:o`000?oooooooooooiRHV?l0003o
V9RHooooooo<c<co8B4Qo`0000;ooooo00Oo0000ob4Q8Oo<c<cooooooiRHV?l0003oV9RH00;ooooo
00OoV9RHo`000?nHV9SooooooiRHV?l0003oV9RH00;ooooo00Wo0000oooooooooooo0000ob4Q8OoM
gMgoooooogMgMolQ8B400_ooool00ol0003oooooooooo`08ooooo`03o`000?lQ8B7ogMgM00;ooooo
00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`07oiRHV?l0003oV9RHoooo
oonHV9So0000oiRHV005ooooo`0=onk^k_l0003ooooooooooon7QhOo0000ogMgMoooooook^k^o`00
0?o^k^koooooo`000002ooooo`0:o`000?ooooooooooooooool0003o8B4QomgMgOooooooMgMgob4Q
8@Kooooo00Ko0000oiRHV?oooooooooooiRHV?l00002ooooo`0;o`000?lQ8B7ogMgMoooooonHV9So
0000odA4A?oMgMgooooooiRHV?lQ8B400_ooool01onHV9So0000oiRHV?ooooooV9RHo`000?nHV9P0
0_ooool01onHV9So0000oiRHV?ooooooV9RHo`000?nHV9P00_ooool02_l0003ooooooooooooooooo
0000ob4Q8OoMgMgoooooogMgMolQ8B42ooooo`09o`000?ooooooooooo`000?lQ8B7ogMgMoooooomg
MgOo8B4Q00;ooooo00OoV9RHo`000?nHV9SooooookZj^_lQ8B7o000000Cooooo00?oEEEEohN7Qooo
ool00_ooool00ol0003o8B4QomgMg@02ooooo`0:o`000?oooooooooooiRHV?l0003oV9RHoooooonj
^[[o8B4Qo`0000;ooooo00Ko0000ob4Q8OoMgMgoooooogMgMolQ8B42ooooo`03o`000?oooooooooo
00;ooooo00?oc<c<odA4A?ooool0J_ooool006[ooooo00GoV9RHo`000?l0003o0000oiRHV002oooo
o`03olc<c?lQ8B7ooooo00?ooooo00Ko8B4Qolc<c?oooooo0000ojVYZOl@4102o`000005oiRHV?oo
ooooooooooooool000000_ooool01Ol0003oooooooooooooooooV9RH00Co000000CoV9RHooooool0
003ooooo1?l00008ooooo`0;o`000?nYZJWo410@o`000?l@413oV9RHohN7Qol@413o0000ob4Q8Oo<
c<`00_ooool01Ol0003oooooooooooooooooV9RH00;o000000?o410@oiRHV?l000000_ooool00ol0
003oZJVYoa0@4002o`000003oiRHV?oooooooooo00;ooooo00GoV9RHo`000?l0003o0000oiRHV003
ooooo`0:o`000?ooooooooooo`000?nYZJWo410@o`000?l@413oc<c<ooooo`Co00002?ooool01_l0
003oZJVYoa0@4?l0003oooooo`0000Cooooo00Co0000oooooooooooo00000oooool01OnHV9So0000
o`000?l0003oV9RH00Kooooo00OoV9RHodA4A?oooooooooookZj^_l0003o^[Zj00;ooooo00GoA4A4
oiRHV?oooooo0000ooooo`04o`000007ooooool0003oV9RHoa0@4?l0003o8B4Qolc<c006ooooo`03
oiRHV?l0003o000000;o000000koV9RHoooooooooooo0000ojVYZOl@413o0000oa0@4?nHV9SoQhN7
oa0@4?l0003o8B4Qolc<c0?ooooo00GoV9RHo`000?l0003o0000oiRHV004ooooo`05oiRHV?l0003o
0000o`000?nHV9P00_ooool4o`000007ooooool0003oV9RHoa0@4?l0003o8B4Qolc<c002ooooo`09
o`000?ooooooooooo`000?nYZJWo410@o`000?l@413oc<c<00?ooooo00KoV9RHo`000?l0003o410@
oiRHV?l00004ooooo`03omgMgOlQ8B7ooooo00;ooooo00Ko0000ojVYZOl@413o0000ooooool00003
ooooo`06oiRHV?l0003o0000oa0@4?nHV9So00000_ooool01ol0003oV9RHoa0@4?l0003o8B4Qolc<
c?ooool01?l00002ooooo`03oeEEEOnj^[[ooooo06[ooooo0023ooooo`03o`000?oooooooooo00ko
oooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo01Go
oooo00?o0000ooooooooool06oooool01Ol0003ooooooooooooooooo000003;ooooo00Go0000oooo
ooooooooooooo`00000Nooooo`03ojVYZOmVIVKooooo01;ooooo00?o0000ooooooooool01Oooool0
1?l0003oooooooooooooool2oiRHV6cooooo0023ooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool07_ooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo01Gooooo00?o0000
ooooooooool06oooool01Ol0003ooooooooooooooooo000003;ooooo00Go0000oooooooooooooooo
o`00000Oooooo`03olc<c?n7QhOooooo017ooooo00?o0000ooooooooool01Oooool01Ol0003ooooo
oooooonYZJWo^[Zj06gooooo0023ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000oooooooo
ool06?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool08?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0=?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01gooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`1gooooo`00oooooooeooooo`00oooooooeooooo`00oooooooe
ooooo`00ZOooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo0?oooooo2oooool00:Wo
oooo00?o0000ooooooooool0>oooool00ol0003oooooooooo`13ooooo`03olc<c?n7QhOooooo01?o
oooo00?oZJVYokZj^_ooool0[_ooool00:Wooooo00?o0000ooooooooool0>oooool00ol0003ooooo
ooooo`12ooooo`;oV9RH5_ooool00onj^[[oV9RHooooo`2]ooooo`00JOooool00ol0003ooooooooo
o`02ooooo`05oiRHV?l0003o0000o`000?nHV9P00oooool00ol0003oooooooooo`06ooooo`05ogMg
Mol0003o0000ooooool000001?ooool01Ol0003oooooooooooooooooV9RH00?o000000?oV9RHoooo
ooooool01_ooool01OnHV9So0000o`000?l0003oV9RH00;ooooo00?oc<c<ob4Q8Oooool00oooool0
1_lQ8B7oc<c<ooooool0003oV9RHoa0@40;o000000GoV9RHooooooooooooooooo`000002ooooo`05
o`000?oooooooooooooooonHV9P00ol000001?nHV9Soooooooooool00002ooooo`03ogMgMol0003o
000000Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`04o`000?oooooo
ooooo`0000?ooooo00KoV9RHo`000?l0003o8B4QojVYZOl00002ooooo`03o`000?nHV9So410@00;o
000000?oV9RHooooooooool00_ooool01OnHV9So0000o`000?l0003oV9RH00?ooooo00Co0000oooo
oooooooo00001?ooool01?l0003ooooooooooomgMgL2o`0000Oooooo00?o0000ooooooooool00_oo
ool01_o<c<co410@o`000?l@413oZJVYo`0000;ooooo00Go0000oooooooooooooooooiRHV003o`00
0003oiRHV?oooooooooo00Gooooo00?ogMgModA4A?ooool00_ooool01Ol0003ooooooooooooooooo
V9RH00?o000000GoV9RHooooooooooooooooo`000003ooooo`03ogMgMol0003o000000;ooooo00?o
EEEEokZj^_ooool01?ooool02_nHV9So0000o`000?l0003oA4A4okZj^_lb<S;o0000ooooool00004
ooooo`05o`000?oooooooooooooooonHV9P00_l000000olQ8B7oZJVYo`000005ooooo`05ogMgMol0
003o0000ooooool000001?ooool01Ol0003oooooooooooooooooV9RH00?o000000?oV9RHoooooooo
ool0Moooool006Wooooo00_o0000oooooooooooooooooiRHV?l0003oV9RHoooooonHV9So0000oiRH
V002ooooo`03o`000?oooooooooo00Kooooo00Go0000onk^k_ooooooooooo`000004ooooo`0:o`00
0?oooooooooooiRHV?l0003oV9RHoooooonHV9So0000oiRHV0Kooooo00OoV9RHo`000?nHV9Sooooo
oiRHV?l0003oV9RH00;ooooo00CoMgMgohN7Qooooooooooo0_mgMgL2ooooo`07o`000?lQ8B7ogMgM
oooooonHV9So0000oiRHV002ooooo`04o`000?ooooooooooo`0000;ooooo00WoV9RHo`000?nHV9So
oooooiRHV?l0003oV9RHooooool000000_ooool00ol0003ok^k^ooooo`08ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`07oiRHV?l0
003oV9RHoooooonj^[[o8B4Qo`000002ooooo`07o`000?lQ8B7ogMgMoooooonHV9So0000oiRHV002
ooooo`07oiRHV?l0003oV9RHoooooonHV9So0000oiRHV002ooooo`04o`000?ooooooooooo`0000Co
oooo00Go0000oooooooooooo0000onk^kP08ooooo`03o`000?oooooooooo00;ooooo00Ko8B4QogMg
MooooooogMgMob4Q8Ol00002ooooo`0:o`000?oooooooooooiRHV?l0003oV9RHoooooonHV9So0000
oiRHV0Kooooo00?oEEEEojVYZOooool00_ooool02_l0003ooooooooooonHV9So0000oiRHV?oooooo
V9RHo`000?nHV9P2ooooo`06o`000?ooooooooooooooool0003ok^k^0oooool00oo<c<coA4A4oooo
o`04ooooo`07o`000?nHV9Sooooooooooonj^[[o<S8bo`000002ooooo`03o`000?oooooooooo00;o
oooo00[o0000ooooooooooooV9RHo`000?nHV9SooooookZj^_lQ8B7o00001Oooool01Ol0003ok^k^
oooooooooooo000000Cooooo00[o0000ooooooooooooV9RHo`000?nHV9SooooooiRHV?l0003oV9RH
N?ooool006Wooooo00Ko0000ooooooooooooooooo`000?nHV9P3ooooo`05oiRHV?l0003ooooooooo
ool000002?ooool01Ol0003ooooooooooooooooo000000Cooooo00Go0000oooooooooooo0000oiRH
V003ooooo`03oiRHV?l0003ooooo00Gooooo00?o0000oiRHV?ooool00_ooool00onHV9So0000oooo
o`02ooooo`04ob4Q8OoMgMgogMgMob4Q8@?ooooo00?o0000olc<c?ooool00_ooool01OnHV9So0000
oooooooooooo000000;ooooo00Go0000oooooooooooo0000oiRHV003ooooo`04oiRHV?l0003ooooo
o`0000;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oV9RHooooo`02ooooo`06ojVYZOl0
003oooooooooool0003oc<c<0oooool01_nHV9So0000oooooooooooo0000oiRHV0?ooooo00GoV9RH
o`000?ooooooooooo`000002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000
2Oooool00ol0003oooooooooo`02ooooo`06o`000?ooooooooooooooooo<c<co00000_ooool01Ol0
003oooooooooool0003oV9RH00?ooooo00?oV9RHo`000?ooool01Oooool00ol@413ogMgMooooo`02
ooooo`05o`000?ooooooooooo`000?nHV9P00oooool01OnHV9So0000oooooooooooo000000?ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?o<c<cooooo00;ooooo
00Gok^k^o`000?ooooooooooo`000004ooooo`05o`000?ooooooooooo`000?nHV9P00oooool00onY
ZJWo0000ooooo`04ooooo`05o`000?ooooooooooooooool000001?ooool01Ol0003oooooooooool0
003oV9RH00?ooooo00?oV9RHo`000?ooool0Moooool006Wooooo00Go0000ooooooooooooooooo`00
0005ooooo`04o`000?ooooooooooo`0000Sooooo00Go0000ooooooooooooooooo`000004ooooo`04
o`000?ooooooooooo`0000cooooo00?o0000ooooooooool01oooool01?nj^[[oA4A4oc8b<_nj^[X3
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00007ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool01?l0
003oooooooooool00005ooooo`04o`000?ooooooooooo`0000Gooooo00Co0000oooooooooooo0000
0_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Sooooo00Go0000
ooooooooooooooooo`000005ooooo`03o`000?oooooooooo00?ooooo00Oo^[Zjoa0@4?lb<S;o<S8b
ofIVI_n7QhOo000000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00005oooo
o`03o`000?oooooooooo00?ooooo00Go0000ooooooooooooooooo`000004ooooo`04o`000?oooooo
ooooo`0007kooooo001Yooooo`05o`000?ooooooooooooooool000001Oooool01?l0003ooooooooo
ool00008ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`07o`0000Ko
oooo1ol00003ooooo`04omgMgOlb<S;o<S8bomgMg@?ooooo00?o0000ooooooooool00oooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Oooooo00Co0000oooooooooooo0000
2_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000Gooooo00Co0000oooo
oooooooo00001Oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00Co
0000oooooooooooo00002Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;ooooo
00Co0000oooooooooooo00000_ooool7o`0000Kooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`07o`0000;ooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo
00Gooooo00GogMgMojVYZOmVIVKoA4A4o`000002ooooo`03o`000?oooooooooo00;ooooo00Co0000
oooooooooooo00001Oooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool00000
1?ooool00ol0003oooooooooo`07o`0007Sooooo001Yooooo`06o`000?ooooooooooooooool0003o
V9RH0oooool01_nHV9So0000oooooooooooo0000omgMg@Oooooo00Ko0000ooooooooooooooooo`00
0?oMgMd3ooooo`05o`000?ooooooooooo`000?nHV9P00oooool00onHV9So0000ooooo`05ooooo`03
o`000?nHV9Sooooo00;ooooo00?oV9RHo`000?ooool00_ooool01?lb<S;oc<c<olc<c?lb<S83oooo
o`03o`000?nYZJWooooo00;ooooo00GoV9RHo`000?ooooooooooo`000002ooooo`05o`000?oooooo
ooooo`000?nHV9P01?ooool00ol0003oooooo`000002ooooo`03o`000?oooooooooo00Sooooo00?o
0000olc<c?ooool00_ooool00ol0003ogMgMooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000oiRHV?ooool00_ooool01_nj^[[o0000oooooooooooo0000ojVYZ@?ooooo00KoV9RHo`00
0?ooooooooooo`000?nHV9P3ooooo`05oiRHV?l0003oooooooooool000000_ooool00ol0003ogMgM
ooooo`02ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000omgMgOooool00_ooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oiRHV?ooool00_ooool00onH
V9So0000ooooo`05ooooo`03oa0@4?o<c<cooooo00;ooooo00Go0000oooooooooooo0000oiRHV003
ooooo`05oiRHV?l0003oooooooooool000000oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00oooool01Ol0003oooooooooool0003ogMgM00?ooooo
00Go0000oooooooooooo0000oiRHV003ooooo`03okZj^_l0003ooooo00Cooooo00Ko0000oooooooo
ooooooooo`000?oMgMd3ooooo`05o`000?ooooooooooo`000?nHV9P00oooool00onHV9So0000oooo
o`1gooooo`00JOooool02ol0003oooooooooooooooooV9RHo`000?nHV9SooooooiRHV?l0003oV9RH
00;ooooo00?o0000ob4Q8OoMgMd01_ooool02_l0003ooooooooooooooooo0000ob4Q8OoMgMgooooo
ogMgMolQ8B42ooooo`07oiRHV?l0003oV9RHoooooonHV9So0000oiRHV006ooooo`07oiRHV?l0003o
V9RHoooooonHV9So0000oiRHV002ooooo`;oMgMg0_ooool2ogMgM`;ooooo00Oo0000ob4Q8Oo<c<co
oooooiRHV?l0003oV9RH00;ooooo00Co0000oooooooooooo00000_ooool00onHV9So0000oiRHV002
ooooo`04oiRHV?l0003oooooo`0000;ooooo00?o0000ooooooooool02?ooool02ol0003o8B4QomgM
gOooooooV9RHo`000?m4A4CogMgMoooooonHV9So8B4Q00;ooooo00[o0000ooooooooooooV9RHo`00
0?nHV9Soooooolc<c?lQ8B7o00000_ooool01ol0003o8B4Qolc<c?ooooooV9RHo`000?nHV9P00_oo
ool01onHV9So0000oiRHV?ooooooV9RHo`000?nHV9P00_ooool02Ol0003oooooooooool0003o8B4Q
omgMgOooooooMgMgob4Q8@02ooooo`03o`000?oooooooooo00Oooooo00?o0000ob4Q8OoMgMd00_oo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00OoV9RHo`000?nHV9So
oooooiRHV?l0003oV9RH00Kooooo00?oEEEEohN7Qoooool00_ooool02_l0003ooooooooooonHV9So
0000oiRHV?ooooooV9RHo`000?nHV9P2ooooo`05o`000?ooooooooooooooool000001?ooool00oo<
c<coA4A4ooooo`04ooooo`03o`000?nHV9Sooooo00;ooooo00[oV9RHo`000?ooooooooooo`000?lQ
8B7ogMgMoooooomgMgOo8B4Q0_ooool01onHV9So0000oiRHV?ooooooc<c<ob4Q8Ol000001Oooool0
2_l0003ooooooooooooooooo0000ob4Q8OoMgMgoooooogMgMolQ8B42ooooo`07oiRHV?l0003oV9RH
oooooonHV9So0000oiRHV01hooooo`00J?ooool4o`0000;ooooo00GoV9RHo`000?l0003o0000oiRH
V003ooooo`04o`000?nYZJWo410@o`0000Cooooo1?l000001ooooooo0000oiRHV?l@413o0000ob4Q
8Oo<c<`00oooool01OnHV9So0000o`000?l0003oV9RH00Sooooo00GoV9RHo`000?l0003o0000oiRH
V002ooooo`03olc<c?lQ8B7ooooo00?ooooo00Ko8B4Qolc<c?oooooo0000ojVYZOl@4102o`000005
oiRHV?ooooooooooooooool000000_ooool01Ol0003oooooooooooooooooV9RH00Co000000CoV9RH
ooooool0003ooooo1?l00008ooooo`0;o`000?nYZJWo410@o`000?l@413oV9RHohN7Qol@413o0000
ob4Q8Oo<c<`00_ooool01Ol0003oooooooooooooooooV9RH00;o000000?o410@oiRHV?l000000_oo
ool00ol0003oZJVYoa0@4002o`000003oiRHV?oooooooooo00;ooooo00GoV9RHo`000?l0003o0000
oiRHV003ooooo`0:o`000?ooooooooooo`000?nYZJWo410@o`000?l@413oc<c<ooooo`Co00001ooo
ool01_l0003oZJVYoa0@4?l0003oooooo`0000Cooooo00Co0000oooooooooooo00000oooool01OnH
V9So0000o`000?l0003oV9RH00Oooooo00?ogMgMob4Q8Oooool00_ooool01Ol0003ooooooooooooo
ooooV9RH00?o000000?oV9RHooooooooool02?l00002ooooo`03oeEEEOnj^[[ooooo00Cooooo00?o
V9RHo`000?l000000ol000002OnHV9Soooooooooool0003oZJVYoa0@4?l0003o410@olc<c003oooo
o`06oiRHV?l0003o0000oa0@4?nHV9So00001?ooool4o`000007ooooool0003oV9RHoa0@4?l0003o
8B4Qolc<c003ooooo`05oiRHV?l0003o0000o`000?nHV9P0NOooool006Wooooo00?o0000oooooooo
ool04oooool01Ol0003ooooooooooooooooo000002kooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0Nooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool05?ooool00ol0
003oooooooooo`0>ooooo`05ojVYZOmVIVKoooooooooool000002oooool01Ol0003ooooooooooooo
oooo000000?ooooo0_nHV9PMooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooooooo
o`000026ooooo`00JOooool00ol0003oc<c<ooooo`0Cooooo`05o`000?ooooooooooooooool00000
;_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool0
7Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00oooooo00Coc<c<ohN7Qooooooo
00002oooool01Ol0003oc<c<oooooooooooo000000;ooooo00?oZJVYokZj^_ooool07Oooool00ol0
003oooooooooo`03ooooo`05o`000?ooooooooooooooool00000Q_ooool006Wooooo00?oQhN7o`00
0?l000005oooool00ol0003oooooooooo`0/ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool07oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Wooooo00?oQhN7
o`000?l000009?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo08Cooooo003ooooo
ooGooooo003oooooooGooooo003oooooooGooooo003oooooobCooooo00?o0000ooooooooool0c_oo
ool00<;ooooo0_l000000onHV9Soooooooooo`0Dooooo`06oiRHV?l0003o0000o`000?l@413oMgMg
@_ooool00ol0003oooooooooo`3>ooooo`00`oooool00oo^k^ko410@okZj^P0Eooooo`07o`000?nH
V9Soooooooooooo<c<co<S8bogMgM`0mooooo`07o`000?ooooooooooooooool0003oooooo`000003
ooooo`03ofIVI_oooooooooo02?ooooo00?oIVIVooooooooool05?ooool00omVIVKoooooooooo`2;
ooooo`00a?ooool00onHV9So<S8booooo`0Iooooo`03omgMgOl@413ooooo03cooooo00?o0000oooo
ooooool00oooool01Ol0003ooooooooooooooooo000002Gooooo00?o0000ooooooooool05?ooool0
0ol0003oooooooooo`2;ooooo`00JOooool7o`000005ooooool0003oooooooooool000001?ooool0
1Ol0003oooooooooooooooooV9RH00?o000000GoV9RHoooooooooooooooooiRHV003o`000006odA4
A?nj^[[o<S8bo`000?oooooo00002?ooool00onHV9So0000o`000002o`000004oiRHV?oooooooooo
ogMgM`;o000000?ooooooiRHV?l000000_l000002?m4A4Co^[Zjoc8b<_l0003oooooo`000?nHV9So
410@0_l000001OnHV9Sooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool0
0omgMgOo0000o`000003ooooo`03ojVYZOl0003o^[Zj00Kooooo00?o0000ooooooooool00oooool0
1OnHV9So0000o`000?l0003oV9RH00Cooooo00KoV9RHo`000?l0003o410@oiRHV?l00002ooooo`05
o`000?oooooooooooooooonHV9P00ol000001OnHV9Sooooooooooooooooo000000Cooooo00Co0000
ooooooooooooV9RH1?l000000onHV9Soooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00Go
V9RHo`000?l0003o0000oiRHV003ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`03ooooo`05o`000?ooooooooooooooool000001oooool00ol0003o
ooooooooo`0Fooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01_ooool00olb<S;o
ooooooooo`02ooooo`03oc8b<_oooooooooo00;ooooo00Go<S8booooooooooooooooo`000007oooo
o`05oiRHV?l0003o0000o`000?nHV9P0POooool006Wooooo00?o0000ooooooooool01Oooool01?l0
003oooooooooool00004ooooo`0:o`000?oooooooooooiRHV?l0003oV9RHoooooonHV9So0000oiRH
V0;ooooo00Oo0000oiRHV?oooooooooookZj^_lb<S;o000000;ooooo00?o0000ooooooooool01_oo
ool01_l0003oV9RHooooooooooooV9RHo`0000;ooooo00Ko0000onk^k_ooooooooooo`000?nHV9P2
ooooo`03okZj^_lb<S;o000000;ooooo00Oo0000ob4Q8Oo<c<cooooooiRHV?l0003oV9RH00;ooooo
00Co0000oooooooooooo00000_ooool01Ol0003oooooooooool0003ok^k^00Cooooo00?oEEEEoa0@
4?mEEED01_ooool00ol0003oooooooooo`02ooooo`07oiRHV?l0003oV9RHoooooonHV9So0000oiRH
V002ooooo`05oiRHV?l0003oV9RHoooooonj^[X00_l00002ooooo`0:o`000?oooooooooooiRHV?l0
003oV9RHoooooonHV9So0000oiRHV0;ooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooo
ool0003oV9RH00;ooooo00?oV9RHo`000?ooool00oooool02ol0003oooooooooooooooooV9RHo`00
0?nHV9SooooooiRHV?l0003oV9RH00;ooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0Fooooo`03o`000?oooooooooo023ooooo00OoV9RHo`000?nHV9SooooooiRHV?l0003oV9RH083o
oooo001Yooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00001?ooool01Ol0003o
ooooooooool0003oV9RH00?ooooo00KoV9RHo`000?ooooooooooo`000?o<c<`3ooooo`05onk^k_l0
003oooooooooool000002?ooool01_l0003oooooooooooooooooc<c<o`0000;ooooo00Ko0000oooo
ooooooooooooo`000?o<c<`3ooooo`06onk^k_l0003oooooooooool0003oZJVY0oooool01OnHV9So
0000oooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03
ooooo`03o`000?oMgMgo000000Kooooo00?o0000ooooooooool00_ooool00ol0003oV9RHooooo`02
ooooo`06oiRHV?l0003oooooooooool0003oV9RH0oooool01OnYZJWo0000oooooooooooo000000;o
oooo00?o0000oiRHV?ooool00_ooool01OnHV9So0000oooooooooooo000000Cooooo00Co0000oooo
oooooooo00000oooool00oo<c<co0000ooooo`03ooooo`06o`000?ooooooooooooooool0003oV9RH
0oooool01OnHV9So0000oooooooooooo000000[ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01Oooool8o`0000Wo
oooo00?o0000ooooooooool08?ooool00ol0003oV9RHooooo`02ooooo`03oiRHV?l0003ooooo07oo
oooo001Yooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00001?ooool01?l0003o
ooooooooool00008ooooo`07okZj^_l@413o<S8boc8b<_mVIVKoQhN7o`000002ooooo`03o`000?oo
oooooooo00Oooooo00GogMgMoiRHV?mEEEGo0000ogMgM`02ooooo`06o`000?oooooooooooooooonj
^[[o410@0_lb<S800omVIVKoQhN7o`000002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00Go
ZJVYodA4A?ooooooA4A4ojVYZ@05ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool00oooool01?l0003oooooooooool00004ooooo`09o`000?oooooooooooooooooMgMgoV9RHoeEE
EOl0003oMgMg00Cooooo00Go0000ooooooooooooooooo`000005ooooo`04o`000?ooooooooooo`00
00[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo
07kooooo001Yooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`07o`0000Cooooo00GogMgMojVYZOmVIVKoA4A4o`000002ooooo`03o`000?oooooo
oooo00Kooooo00GoV9RHo`000?lQ8B7oV9RHolc<c003ooooo`03o`000?oooooooooo00?ooooo00Go
gMgMojVYZOmVIVKoA4A4o`000002ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00GoEEEEoiRH
V?ooooooV9RHodA4A005ooooo`03o`000?oooooooooo00;ooooo1ol00002ooooo`03o`000?oooooo
oooo00?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`04o`000?oo
ooooooooo`0000Cooooo00So0000ooooooooooooV9RHo`000?lQ8B7oV9RHolc<c0Gooooo00Go0000
ooooooooooooooooo`000005ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool0
5?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo02Gooooo00?oV9RHo`000?ooool0
Ooooool006Wooooo00?o0000ooooooooool01Oooool01Ol0003oooooooooool0003ogMgM00?ooooo
00Go0000oooooooooooo0000oiRHV003ooooo`05oiRHV?l0003oooooooooool000001Oooool01Ol0
003oooooooooool0003ogMgM00Oooooo00?o0000oiRHV?ooool01Oooool01Ol0003ooooooooooooo
oooo000000Gooooo00Go0000oooooooooooo0000okZj^P03ooooo`05oiRHV?l0003oooooooooool0
00000_ooool01?l0003oooooooooool00002ooooo`0;o`000?ooooooooooooooooo^k^ko0000onk^
k_ooooook^k^o`000?o^k^h01?ooool00ol0003ogMgMooooo`02ooooo`03o`000?nHV9Sooooo00;o
oooo00KoV9RHo`000?ooooooooooo`000?nHV9P3ooooo`05okZj^_l0003oooooooooool000000_oo
ool00ol0003oV9RHooooo`02ooooo`06oiRHV?l0003oooooooooool0003ogMgM0oooool01Ol0003o
ooooooooool0003oV9RH00Sooooo00Ko0000ooooooooooooooooo`000?nHV9P3ooooo`06oiRHV?l0
003oooooooooool0003ogMgM2Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`So00002Oooool00ol0003o
ooooooooo`0Pooooo`07oc8b<_m4A4CogMgMoooooonHV9So0000oiRHV020ooooo`00JOooool00ol0
003oooooooooo`05ooooo`09o`000?ooooooooooo`000?lQ8B7ogMgMoooooomgMgOo8B4Q00;ooooo
00OoV9RHo`000?nHV9SooooooiRHV?l0003oV9RH00;ooooo00?o0000oiRHV?ooool00_ooool01onH
V9So0000oooooooooooo0000ob4Q8OoMgMd01_ooool01_l0003oV9RHooooooooooooV9RHo`0000;o
oooo00Ko0000ooooooooooooooooo`000?nHV9P3ooooo`0;oiRHV?l0003oooooooooool0003o8B4Q
okZj^_ooooooV9RHo`000?nHV9P00_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000?ooooo00?oV9RHodA4A?ooool00_ooool00omEEEGoV9RHooooo`03ooooo`03o`000?lQ
8B7ogMgM00;ooooo00OoV9RHo`000?nHV9SooooooiRHV?l0003oV9RH00;ooooo00OoV9RHo`000?nH
V9SooooookZj^_lQ8B7o000000;ooooo00[o0000ooooooooooooV9RHo`000?nHV9SooooooiRHV?l0
003oV9RH0_ooool01_l0003o8B4QomgMgOooooooMgMgob4Q8@;ooooo00Ko0000oiRHV?oooooooooo
oiRHV?l00004ooooo`0;o`000?oooooooooooooooonHV9So0000oiRHV?ooooooV9RHo`000?nHV9P0
0_ooool00ol0003o8B4QomgMg@08ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0
5_ooool00ol0003oooooooooo`0Pooooo`03oeEEEOlQ8B7o000000;o000000?oV9RHooooooooool0
Ooooool006Wooooo00?o0000ooooooooool01Oooool02Ol0003oooooooooool0003oZJVYoa0@4?l0
003o410@olc<c003ooooo`05oiRHV?l0003o0000o`000?nHV9P00oooool00onHV9So0000o`000003
o`000007oiRHV?ooooooooooo`000?nYZJWo410@o`000005ooooo`03oiRHV?l0003o000000;o0000
00?oV9RHooooool000000ol000000oooooooV9RHo`000004o`000006oiRHV?ooooooooooo`000?n7
QhOo410@0_l000001OnHV9Sooooooooooooooooo000000;ooooo00Go0000oooooooooooo0000oooo
o`04o`000003oooooom4A4CoZJVY00?ooooo00?oZJVYodA4A?ooool00oooool01?l0003oZJVYoa0@
4?l00002ooooo`05oiRHV?l0003o0000o`000?nHV9P01?ooool01_nHV9So0000o`000?l@413oV9RH
o`0000;ooooo00Go0000oooooooooooooooooiRHV003o`00000:oiRHV?ooooooooooooooool0003o
ZJVYoa0@4?l0003o410@olc<c0;ooooo00?oV9RHo`000?l000000_l000001?nHV9Sooooooooooooo
ool4o`0000;ooooo00GoV9RHo`000?l0003o0000oiRHV003ooooo`04o`000?nYZJWo410@o`0000Oo
oooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo023o
oooo0_mgMgN5ooooo`00JOooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo047ooooo
00?o0000ooooooooool05Oooool00ol0003oooooooooo`0Zooooo`Co00008_ooool00onHV9So<S8b
ooooo`24ooooo`00JOooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo047ooooo00?o
0000olc<c?ooool05Oooool00ol0003oooooooooo`0[ooooo`03okZj^_m4A4Co000002;ooooo00?o
^[Zjoc8b<_ooool0Q?ooool006Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0h
ooooo`03o`000?oooooooooo00Kooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0Vooooo`03o`000?oooooooooo01_ooooo00?oQhN7o`000?l000004Oooool9o`0001;ooooo00?o
0000ooooooooool05_ooool00ol@413oooooooooo`0Pooooo`03onk^k_l0003o000000?o0000POoo
ool00?oooooomOooool00001\
\>"],
  ImageRangeCache->{{{0, 499}, {236.812, 0}} -> {-0.385702, -0.0238147, \
0.0069424, 0.0069424}, {{69.4375, 240.875}, {232.5, 61}} -> {-0.40504, \
-0.0253425, 0.00729136, 0.00729136}, {{69.4375, 240.875}, {232.438, 61}} -> \
{-14.8338, -8.76945, 0.113378, 0.113378}, {{69.4375, 240.875}, {232.438, 61}} -> \
{-14.8338, -8.76945, 0.113378, 0.113378}, {{258.062, 429.5}, {232.5, 61}} -> \
{-1.50531, -0.0253425, 0.00729136, 0.00729136}, {{258.062, 429.5}, {232.438, \
61}} -> {-31.9426, -8.76945, 0.113378, 0.113378}, {{258.062, 429.5}, \
{232.438, 61}} -> {-31.9426, -8.76945, 0.113378, 0.113378}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multiple linearly implicit midpoint steps", "Subsection"],

Cell[TextData[{
  "Consider one step of the linearly implicit Euler method followed by \
multiple linearly implicit midpoint steps, using the formulation of Bader and \
Deuflhard ",
  "[",
  ButtonBox["BD83",
    ButtonData:>{"References.nb", "BD83"},
    ButtonStyle->"Hyperlink"],
  "]",
  ":"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\((I\  - \ h\ J)\) \[CapitalDelta]y\_0\), 
            "=", \(h\ \(f(t\_0, y\_0)\)\)},
          {\(y\_1\), "=", \(y\_0 + \[CapitalDelta]y\_0\)},
          {\(\((I\  - \ 
                  h\ J)\)\ \((\[CapitalDelta]y\_1 - \[CapitalDelta]y\_0)\)\), 
            "=", \(2 \((h\ \(f(t\_1, y\_1)\) - \[CapitalDelta]y\_0)\)\)},
          {\(y\_2\), "=", \(y\_1 + \[CapitalDelta]y\_1\)},
          {\(\((I\  - \ 
                  h\ J)\)\ \((\[CapitalDelta]y\_2 - \[CapitalDelta]y\_1)\)\), 
            "=", \(2 \((h\ \(f(t\_2, 
                      y\_1 + \ \[CapitalDelta]y\_1)\) - \
\[CapitalDelta]y\_1)\)\)},
          {\(y\_3\), "=", \(y\_2 + \[CapitalDelta]y\_2\)},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
            "\[VerticalEllipsis]"},
          {\(\((I\  - \ 
                  h\ J)\) \((\[CapitalDelta]y\_\(n - 1\) - \[CapitalDelta]y\_\
\(n - 2\))\)\), 
            "=", \(2 \((h\ \(f(t\_\(n - 1\), 
                      y\_\(n - 1\))\) - \[CapitalDelta]y\_\(n - 2\))\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"LinearlyImplicitMidpointSteps"],

Cell[TextData[{
  "If (",
  
  CounterBox["NumberedEquation", "LinearlyImplicitMidpointSteps"],
  ") is computed for ",
  Cell[BoxData[
      \(TraditionalForm\`2\ m\  - \ 1\)]],
  " linearly implicit midpoint steps, then the method has a symmetric error \
expansion ",
  "[",
  ButtonBox["BD83",
    ButtonData:>{"References.nb", "BD83"},
    ButtonStyle->"Hyperlink"],
  "]",
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Reformulation", "Subsubsection"],

Cell[TextData[{
  "Reformulation of (",
  
  CounterBox["NumberedEquation", "LinearlyImplicitMidpointSteps"],
  ") in terms of increments can be accomplished as follows:"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\((I - h\ J)\)\ \[CapitalDelta]y\_0\), 
            "=", \(h\ \(f(t\_0, y\_0)\)\)},
          {\(\((I - 
                  h\ J)\)\ \((\[CapitalDelta]y\_1 - \[CapitalDelta]y\_0)\)\), 
            "=", \(2 \((h\ \(f(t\_1, 
                      y\_0 + \[CapitalDelta]y\_0)\) - \
\[CapitalDelta]y\_0)\)\)},
          {\(\((I - h\ J)\) \((\[CapitalDelta]y\_2 - \[CapitalDelta]y\_1)\)\),
             "=", \(2 \((h\ \(f(t\_2, 
                      y\_0 + \((\[CapitalDelta]y\_0 + \ \
\[CapitalDelta]y\_1)\))\) - \[CapitalDelta]y\_1)\)\)},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
            "\[VerticalEllipsis]"},
          {\(\((I - 
                  h\ J)\) \((\[CapitalDelta]y\_\(n - 1\) - \[CapitalDelta]y\_\
\(n - 2\))\)\), 
            "=", \(2 \((h\ \(f(t\_\(n - 1\), 
                      y\_0 + \((\[CapitalDelta]y\_0 + \ \[CapitalDelta]y\_1 + \
\[CenterEllipsis] + \[CapitalDelta]y\_\(n - 2\))\))\) - \[CapitalDelta]y\_\(n \
- 2\))\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"LinearlyImplicitMidpointIncrements"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Smoothing step", "Subsubsection"],

Cell[TextData[{
  "An appropriate smoothing step for the linearly implicit midpoint rule is \
[",
  ButtonBox["BD83",
    ButtonData:>{"References.nb", "BD83"},
    ButtonStyle->"Hyperlink"],
  "]:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`Sy\_h\ \((n)\) = 
      1\/2\ \((y\_\(n - 1\) + y\_\(n + 1\))\)\)], "NumberedEquation",
  CellTags->"BaderSmoothingStep"],

Cell[TextData[{
  "Bader's smoothing step ",
  "(",
  
  CounterBox["NumberedEquation", "BaderSmoothingStep"],
  ") rewritten ",
  "in terms of increments becomes:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`S\[CapitalDelta]y\_h\ \((n)\) = \(Sy\_h\ \((n)\)\  - \ 
          y\_0 = \[CapitalSigma]\[CapitalDelta]y\_n + 
          1\/2\ \((\[CapitalDelta]y\_n - \[CapitalDelta]y\_\(n - 1\))\)\)\)], \
"NumberedEquation",
  CellTags->"ModifiedBaderSmoothingStep"],

Cell[TextData[{
  "The required quantities are obtained when (",
  
  CounterBox["NumberedEquation", "LinearlyImplicitMidpointIncrements"],
  ") is run with ",
  Cell[BoxData[
      \(TraditionalForm\`2\ m\)]],
  " steps."
}], "Text"],

Cell[TextData[{
  "The smoothing step for the linearly implicit midpoint rule has a different \
role to Gragg's smoothing for the explicit midpoint rule (see [",
  ButtonBox["BD83",
    ButtonData:>{"References.nb", "BD83"},
    ButtonStyle->"Hyperlink"],
  "] and ",
  "[",
  ButtonBox["SB83",
    ButtonData:>{"References.nb", "SB83"},
    ButtonStyle->"Hyperlink"],
  "]",
  "). Since there is no weakly stable term to eliminate, the aim is to \
improve the asymptotic stability."
}], "Text"],

Cell[TextData[{
  "The method ",
  StyleBox["LinearlyImplicitMidpoint", "MR"],
  " uses ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(2\ m\  - \ 1\)\)\)]],
  " steps and ",
  StyleBox["LinearlyImplicitModifiedMidpoint", "MR"],
  " uses ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(2\ m\)\)\)]],
  " steps followed by the smoothing step (",
  
  CounterBox["NumberedEquation", "ModifiedBaderSmoothingStep"],
  ")."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polynomial extrapolation in terms of increments", "Subsection"],

Cell[TextData[{
  "We have seen how to modify ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i, \ 1\)\)]],
  ",",
  " ",
  "the entries in the first column of the extrapolation table, in terms of \
increments."
}], "Text"],

Cell[TextData[{
  "However, for certain base integration methods, ",
  StyleBox["each",
    FontSlant->"Italic"],
  " of the ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i, \ j\)\)]],
  " corresponds to an explicit Runge-Kutta method."
}], "Text"],

Cell["\<\
Therefore, it appears that the correspondence has not yet been \
fully exploited and further refinement is possible.\
\>", "Text"],

Cell[TextData[{
  "Since the Aitken-Neville algorithm (",
  
  CounterBox["NumberedEquation", "AitkenNeville"],
  ") involves linear differences, the entire extrapolation process can be \
carried out using increments."
}], "Text"],

Cell["\<\
This leads to the following modification of the Aitken-Neville \
algorithm:\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalDelta]T\_\(i, \ j\) = \ \
\[CapitalDelta]T\_\(i, \ j - 1\)\  + \ \(\[CapitalDelta]T\_\(i, \ j\  - \ 1\)\
\  - \ \[CapitalDelta]T\_\(i - 1, \ j\  - \ 1\)\)\/\(\((n\_i\/n\_\(i\  - \ j\ \
 + \ 1\))\)\^p\  - \ 1\)\ , i = 2, \[Ellipsis], k, 
    j\  = \ 2, \[Ellipsis], \(\(i\)\(.\)\)\)], "NumberedEquation",
  CellTags->"ModifiedAitkenNeville"],

Cell[TextData[{
  "The quantities ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]T\_\(i, \ j\)\  = \ 
        T\_\(i, \ j\)\  - \ y\_0\)]],
  " in (",
  
  CounterBox["NumberedEquation", "ModifiedAitkenNeville"],
  ") can be computed iteratively, starting from the initial quantities ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i, \ 1\)\)]],
  "that are obtained from the modified base integration schemes without \
adding the contribution from ",
  Cell[BoxData[
      \(TraditionalForm\`y\_0\)]],
  "."
}], "Text"],

Cell[TextData[{
  "The final desired value ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(k, \ k\)\)]],
  " can be recovered as ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]T\_\(k, \ k\)\  + \ y\_0\)]],
  "."
}], "Text"],

Cell["\<\
The advantage is that the extrapolation table is built up using \
smaller quantities, and so the effect of rounding errors from subtractive \
cancellation is reduced.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation issues", "Section",
  CellTags->"s:4"],

Cell["\<\
There are a number of important implementation issues that should \
be considered, some of which are mentioned here.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Jacobian reuse", "Subsection"],

Cell[TextData[{
  "The Jacobian is evaluated only once for all entries ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i, \ 1\)\)]],
  " at each time step by storing it together with the associated time that it \
is evaluated. This also has the advantage that the Jacobian does not need to \
be recomputed for rejected steps."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dense linear algebra", "Subsection"],

Cell[TextData[{
  "For dense systems, the LAPACK routines xyytrf can be used for the LU \
decomposition and the routines xyytrs for solving the resulting triangular \
systems ",
  "[",
  ButtonBox["LAPACK99",
    ButtonData:>{"References.nb", "LAPACK99"},
    ButtonStyle->"Hyperlink"],
  "]",
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Adaptive order and work estimation", "Subsection"],

Cell["\<\
In order to adaptively change the order of the extrapolation \
throughout the integration, it is important to have a measure of the amount \
of work required by the base scheme and extrapolation sequence.\
\>", "Text"],

Cell["\<\
A measure of the relative cost of function evaluations is \
advantageous.\
\>", "Text"],

Cell["\<\
The dimension of the system, preferably with a weighting according \
to structure, needs to be incorporated for linearly implicit schemes in order \
to take account of the expense of solving each linear system.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stability check", "Subsection"],

Cell["\<\
Extrapolation methods use a large basic step size that can give \
rise to some difficulties.\
\>", "Text"],

Cell[TextData[{
  "\"Neither code can solve the van der Pol equation problem in a \
straightforward way because of overflow...\" ",
  "[",
  ButtonBox["S87",
    ButtonData:>{"References.nb", "S87"},
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "Two forms of stability check are used for the linearly implicit base \
schemes (for further discussion, see ",
  "[",
  ButtonBox["HW96",
    ButtonData:>{"References.nb", "HW96"},
    ButtonStyle->"Hyperlink"],
  "]",
  ")."
}], "Text"],

Cell[TextData[{
  "One check is performed during the extrapolation process. Let ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["err",
              FontSlant->"Italic"], "j"], 
          "=", \(\(||\)\(T\_\(j\ , \ j - 1\) - T\_\(j\ , \ j\)\)\(||\)\)}], 
        TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"If", " ", 
            SubscriptBox[
              StyleBox["err",
                FontSlant->"Italic"], "j"]}], " ", "\[GreaterEqual]", 
          RowBox[{
            SubscriptBox[
              StyleBox["err",
                FontSlant->"Italic"], \(j - 1\)], " ", "for", " ", "some", 
            " ", "j"}], "\[GreaterEqual]", "3"}], ",", 
        " ", \(then\ recompute\ the\ step\ with\ H\  = \ H/2\)}], 
      TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "In order to interrupt computations in the computation of ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(1\ , \ 1\)\)]],
  " Deuflhard suggests checking if the Newton iteration applied to a fully \
implicit scheme would converge."
}], "Text"],

Cell["\<\
For the implicit Euler method this leads to consideration of:\
\>", \
"Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\((I\  - \ h\ J)\)\ \[CapitalDelta]\_0\), 
            "=", \(h\ \(f(t\_0, \ y\_0)\)\)},
          {\(\((I\  - \ h\ J)\)\ \[CapitalDelta]\_1\), 
            "=", \(h\ \(f(t\_0, \ 
                  y\_0 + \ \[CapitalDelta]\_0)\)\  - \ \[CapitalDelta]\_0\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"ImplicitEulerStabilityCheck"],

Cell[TextData[{
  "Notice that (",
  
  CounterBox["NumberedEquation", "ImplicitEulerStabilityCheck"],
  ") differs from (",
  
  CounterBox["NumberedEquation", "LinearlyImplicitEulerSteps"],
  ") only in the second equation. It requires finding the solution for a \
different right-hand side but no extra function evaluation."
}], "Text"],

Cell[TextData[{
  "For the implicit midpoint method: ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_0\  = \ \[CapitalDelta]y\_0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_1\  = 
        1/2 \((\ \[CapitalDelta]y\_1 - \[CapitalDelta]y\_0)\)\)]],
  ", which simply requires a few basic arithmetic operations."
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`If\  || \[CapitalDelta]\_1 || \ \
\(\(\[GreaterEqual]\)\(\(||\)\(\[CapitalDelta]\_0\)\(||\)\(\ \)\(then\ the\ \
implicit\ iteration\ diverges\)\)\), \ 
    so\ recompute\ the\ step\ with\ H\  = \ H/2. \)], "DisplayFormula"],

Cell["\<\
Increments are a more accurate formulation for the implementation \
of both forms of stability check.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",
  CellTags->"s:5"],

Cell[CellGroupData[{

Cell["Stiff systems", "Subsection"],

Cell["\<\
One of the simplest nonlinear equations describing a circuit is van \
der Pol's equation.\
\>", "Text"],

Cell[BoxData[{
    \(\(system\  = \ 
        GetNDSolveProblem["\<VanderPol\>"];\)\), "\[IndentingNewLine]", 
    \(\(vars\  = \ 
        system["\<DependentVariables\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(time\  = \ system["\<TimeData\>"[]];\)\)}], "Input",
  CellLabel->"In[11]:="],

Cell[TextData[{
  "This solves the equations using ",
  StyleBox["Extrapolation", "MR"],
  " with the ",
  StyleBox["LinearlyImplicitEuler", "MR"],
  " base method with the default sub-Harmonic sequence 2,3 4,\[Ellipsis]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vdpsol\  = \ 
      Flatten[vars\  /. \ 
          NDSolve[system, \ 
            Method \[Rule] {"\<Extrapolation\>", 
                Method \[Rule] "\<LinearlyImplicitEuler\>"}]]\)], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          TagBox[\(InterpolatingFunction[{{0.`, 2.5`}}, "<>"]\),
            False,
            Editable->False], "[", "T", "]"}], ",", 
        RowBox[{
          TagBox[\(InterpolatingFunction[{{0.`, 2.5`}}, "<>"]\),
            False,
            Editable->False], "[", "T", "]"}]}], "}"}]], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell["\<\
Notice that the Jacobian matrix is computed automatically (user \
specifiable by using either numerical differences or symbolic derivatives) \
and appropriate linear algebra routines are selected and invoked at run time.\
\
\>", "Text"],

Cell["This plots the first solution component over time.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[Evaluate[First[vdpsol]], Evaluate[time], \ Frame \[Rule] True, \ 
        Axes \[Rule] False];\)\)], "Input",
  CellLabel->"In[15]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.380952 0.309023 0.146534 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -9 -9 ]
[.21429 -0.0125 9 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -9 -9 ]
[.59524 -0.0125 9 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -9 -9 ]
[.97619 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01596 -12 -4.5 ]
[-0.0125 .01596 0 4.5 ]
[-0.0125 .16249 -12 -4.5 ]
[-0.0125 .16249 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .45556 -6 -4.5 ]
[-0.0125 .45556 0 4.5 ]
[-0.0125 .60209 -6 -4.5 ]
[-0.0125 .60209 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(0.5)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(1)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(1.5)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(2)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(2.5)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.0619 0 m
.0619 .00375 L
s
.1 0 m
.1 .00375 L
s
.1381 0 m
.1381 .00375 L
s
.17619 0 m
.17619 .00375 L
s
.25238 0 m
.25238 .00375 L
s
.29048 0 m
.29048 .00375 L
s
.32857 0 m
.32857 .00375 L
s
.36667 0 m
.36667 .00375 L
s
.44286 0 m
.44286 .00375 L
s
.48095 0 m
.48095 .00375 L
s
.51905 0 m
.51905 .00375 L
s
.55714 0 m
.55714 .00375 L
s
.63333 0 m
.63333 .00375 L
s
.67143 0 m
.67143 .00375 L
s
.70952 0 m
.70952 .00375 L
s
.74762 0 m
.74762 .00375 L
s
.82381 0 m
.82381 .00375 L
s
.8619 0 m
.8619 .00375 L
s
.9 0 m
.9 .00375 L
s
.9381 0 m
.9381 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01596 m
.00625 .01596 L
s
[(-2)] -0.0125 .01596 1 0 Mshowa
0 .16249 m
.00625 .16249 L
s
[(-1)] -0.0125 .16249 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0)] -0.0125 .30902 1 0 Mshowa
0 .45556 m
.00625 .45556 L
s
[(1)] -0.0125 .45556 1 0 Mshowa
0 .60209 m
.00625 .60209 L
s
[(2)] -0.0125 .60209 1 0 Mshowa
.125 Mabswid
0 .04526 m
.00375 .04526 L
s
0 .07457 m
.00375 .07457 L
s
0 .10388 m
.00375 .10388 L
s
0 .13318 m
.00375 .13318 L
s
0 .1918 m
.00375 .1918 L
s
0 .2211 m
.00375 .2211 L
s
0 .25041 m
.00375 .25041 L
s
0 .27972 m
.00375 .27972 L
s
0 .33833 m
.00375 .33833 L
s
0 .36764 m
.00375 .36764 L
s
0 .39694 m
.00375 .39694 L
s
0 .42625 m
.00375 .42625 L
s
0 .48486 m
.00375 .48486 L
s
0 .51417 m
.00375 .51417 L
s
0 .54348 m
.00375 .54348 L
s
0 .57278 m
.00375 .57278 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.21429 .61178 m
.21429 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.59524 .61178 m
.59524 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.0619 .61428 m
.0619 .61803 L
s
.1 .61428 m
.1 .61803 L
s
.1381 .61428 m
.1381 .61803 L
s
.17619 .61428 m
.17619 .61803 L
s
.25238 .61428 m
.25238 .61803 L
s
.29048 .61428 m
.29048 .61803 L
s
.32857 .61428 m
.32857 .61803 L
s
.36667 .61428 m
.36667 .61803 L
s
.44286 .61428 m
.44286 .61803 L
s
.48095 .61428 m
.48095 .61803 L
s
.51905 .61428 m
.51905 .61803 L
s
.55714 .61428 m
.55714 .61803 L
s
.63333 .61428 m
.63333 .61803 L
s
.67143 .61428 m
.67143 .61803 L
s
.70952 .61428 m
.70952 .61803 L
s
.74762 .61428 m
.74762 .61803 L
s
.82381 .61428 m
.82381 .61803 L
s
.8619 .61428 m
.8619 .61803 L
s
.9 .61428 m
.9 .61803 L
s
.9381 .61428 m
.9381 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01596 m
1 .01596 L
s
.99375 .16249 m
1 .16249 L
s
.99375 .30902 m
1 .30902 L
s
.99375 .45556 m
1 .45556 L
s
.99375 .60209 m
1 .60209 L
s
.125 Mabswid
.99625 .04526 m
1 .04526 L
s
.99625 .07457 m
1 .07457 L
s
.99625 .10388 m
1 .10388 L
s
.99625 .13318 m
1 .13318 L
s
.99625 .1918 m
1 .1918 L
s
.99625 .2211 m
1 .2211 L
s
.99625 .25041 m
1 .25041 L
s
.99625 .27972 m
1 .27972 L
s
.99625 .33833 m
1 .33833 L
s
.99625 .36764 m
1 .36764 L
s
.99625 .39694 m
1 .39694 L
s
.99625 .42625 m
1 .42625 L
s
.99625 .48486 m
1 .48486 L
s
.99625 .51417 m
1 .51417 L
s
.99625 .54348 m
1 .54348 L
s
.99625 .57278 m
1 .57278 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60209 m
.06244 .592 L
.10458 .5801 L
.14415 .56799 L
.18221 .55521 L
.22272 .53987 L
.26171 .52242 L
.28158 .51183 L
.30316 .49795 L
.31323 .48996 L
.32392 .4794 L
.32831 .47394 L
.33304 .46667 L
.33575 .46136 L
.33823 .45524 L
.33942 .4516 L
.34072 .44682 L
.34194 .44117 L
.34309 .43433 L
.34437 .42344 L
.34502 .41577 L
.34573 .40447 L
.34699 .36946 L
.34816 .28951 L
.34887 .18867 L
.34964 .06861 L
.35036 .02371 L
.35103 .01586 L
.3523 .01472 L
.35294 .01483 L
.35365 .01501 L
.35846 .01623 L
.36361 .01756 L
.38221 .02244 L
.42242 .03351 L
.46111 .04496 L
.50225 .05827 L
.54187 .07262 L
.57998 .08854 L
.60123 .09884 L
.62054 .10963 L
.64062 .12333 L
.64965 .13099 L
.65478 .13609 L
.65958 .14162 L
.66466 .14877 L
.66931 .15752 L
.67185 .16409 L
.67427 .17278 L
.67559 .17943 L
Mistroke
.67682 .18784 L
.67752 .19431 L
.67816 .20179 L
.6789 .21341 L
.6796 .22929 L
.68064 .27197 L
.68178 .38527 L
.68278 .54544 L
.68385 .59945 L
.68509 .60332 L
.68623 .60319 L
.68726 .60293 L
.6884 .60264 L
.69339 .60136 L
.69805 .60016 L
.70784 .5976 L
.71817 .59487 L
.73665 .58985 L
.77691 .57834 L
.81565 .56634 L
.85684 .55225 L
.89652 .53679 L
.93468 .51907 L
.97529 .49354 L
.97619 .49282 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool001Ioo`8002Yoo`8000Aoo`03001oogoo009oo`<002Yoo`@002Uoo`@000=oo`03001oogoo009o
o`<002Uoo`@002Uoo`@000=oo`03001oogoo009oo`<000Eoo`005Goo00@007ooOol002Qoo`04001o
ogoo000;Ool00`00Oomoo`0YOol00`00Oomoo`0ZOol00`00Oomoo`0:Ool00`00Oomoo`0VOol00`00
Oomoo`0ZOol00`00Oomoo`0<Ool00`00Oomoo`02Ool001Eoo`04001oogoo000XOol01000Oomoo`00
2goo00<007ooOol0:Goo00<007ooOol0:Woo00<007ooOol02Woo00<007ooOol09goo00<007ooOol0
:Woo00<007ooOol02goo00<007ooOol00Woo000EOol01000Oomoo`00:7oo00@007ooOol000Qoo`<0
02aoo`03001oogoo02Yoo`03001oogoo00Moo`<002]oo`03001oogoo02Yoo`03001oogoo00Moo`<0
00Eoo`005Goo00@007ooOol002Qoo`04001oogoo0008Ool00`00Oomoo`0/Ool00`00Oomoo`0ZOol0
0`00Oomoo`07Ool00`00Oomoo`0/Ool00`00Oomoo`0ZOol00`00Oomoo`06Ool00`00Oomoo`05Ool0
01Eoo`04001oogoo000XOol01000Oomoo`0027oo00<007ooOol0:Woo0`00:Woo0`002Goo00<007oo
Ool0:Goo00@007ooOol002Uoo`04001oogoo0008Ool00`00Oomoo`05Ool001Ioo`8002Yoo`8000Uo
o`@002]oo`03001oogoo02Yoo`03001oogoo00Moo`@002Uoo`8002]oo`8000Uoo`@000Aoo`00ogoo
8Goo003oOolQOol00?moob5oo`0047ooo`0030001Goo000@Ool00`00Oomoo`04Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool000Qoo`@000Aoo`03001oogoo00Aoo`03001oogoo02moo`03001oogoo031o
o`03001oogoo031oo`03001oogoo02moo`03001oogoo031oo`03001oogoo00=oo`03001oogoo00=o
o`0027oo00<007ooOol01Goo00<007ooOol0ogoo27oo00<007ooOol00goo0009Ool00`00Oomoo`04
Ool3001KOol3002XOol20005Ool0009oo`@000Aoo`03001oogoo00=oo`03001oogoo05]oo`03001o
ogoo00<00:Ioo`03001oogoo00=oo`002goo00<007ooOol00Woo00<007ooOol0Fgoo00<007ooOol0
0goo1000XWoo00<007ooOol00goo0008Ool01000Oomoo`0017oo00<007ooOol0Fgoo00<007ooOol0
1goo1000WWoo00<007ooOol00goo0009Ool20005Ool00`00Oomoo`1KOol00`00Oomoo`0;Ool4002J
Ool00`00Oomoo`03Ool0011oo`03001oogoo05]oo`03001oogoo00moo`<009Moo`03001oogoo00=o
o`0047oo00<007ooOol0Fgoo00<007ooOol04Woo0`00U7oo00<007ooOol00goo000@Ool00`00Oomo
o`1KOol00`00Oomoo`0EOol4002@Ool00`00Oomoo`03Ool0011oo`8005aoo`03001oogoo01Uoo`<0
08aoo`8000Eoo`0047oo00<007ooOol0FWoo00<007ooOol07Goo1000RGoo00<007ooOol00goo000@
Ool00`00Oomoo`1JOol00`00Oomoo`0QOol40025Ool00`00Oomoo`03Ool0011oo`03001oogoo05Yo
o`03001oogoo02Eoo`<0089oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007ooOol0:7oo
0P00P7oo00<007ooOol00goo000@Ool00`00Oomoo`1JOol00`00Oomoo`0ZOol3001mOol00`00Oomo
o`03Ool0011oo`03001oogoo05Yoo`03001oogoo02eoo`8007]oo`03001oogoo00=oo`0047oo00<0
07ooOol0FWoo00<007ooOol0;goo0`00N7oo00<007ooOol00goo000@Ool2001KOol00`00Oomoo`0b
Ool3001dOol20005Ool0011oo`03001oogoo05Yoo`03001oogoo03Eoo`8007=oo`03001oogoo00=o
o`0047oo00<007ooOol0FWoo00<007ooOol0=goo0`00L7oo00<007ooOol00goo000@Ool00`00Oomo
o`1JOol00`00Oomoo`0jOol2001^Ool00`00Oomoo`03Ool0011oo`03001oogoo05Yoo`03001oogoo
03aoo`8006aoo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007ooOol0?Woo0P00JWoo00<0
07ooOol00goo000@Ool00`00Oomoo`1JOol00`00Oomoo`10Ool00`00Oomoo`1WOol00`00Oomoo`03
Ool0011oo`03001oogoo05Yoo`03001oogoo045oo`8006Moo`03001oogoo00=oo`0047oo0P00Fgoo
00<007ooOol0@goo0P00I7oo0P001Goo000@Ool00`00Oomoo`1JOol00`00Oomoo`15Ool00`00Oomo
o`1ROol00`00Oomoo`03Ool0011oo`03001oogoo05Yoo`03001oogoo04Ioo`80069oo`03001oogoo
00=oo`0047oo00<007ooOol0FWoo00<007ooOol0B7oo00<007ooOol0Ggoo00<007ooOol00goo000@
Ool00`00Oomoo`1JOol00`00Oomoo`19Ool2001OOol00`00Oomoo`03Ool0011oo`03001oogoo05Yo
o`03001oogoo04]oo`03001oogoo05aoo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007oo
Ool0C7oo00<007ooOol0Fgoo00<007ooOol00goo000@Ool2001KOol00`00Oomoo`1=Ool00`00Oomo
o`1IOol20005Ool0011oo`03001oogoo05Yoo`03001oogoo04ioo`03001oogoo05Uoo`03001oogoo
00=oo`0047oo00<007ooOol0FWoo00<007ooOol0Cgoo00<007ooOol0F7oo00<007ooOol00goo000@
Ool00`00Oomoo`1JOol00`00Oomoo`1@Ool00`00Oomoo`1GOol00`00Oomoo`03Ool0011oo`03001o
ogoo05Yoo`03001oogoo055oo`03001oogoo05Ioo`03001oogoo00=oo`0047oo00<007ooOol0FWoo
00<007ooOol0DGoo00<007ooOol0EWoo00<007ooOol00goo0008Ool40004Ool00`00Oomoo`1JOol0
0`00Oomoo`1BOol00`00Oomoo`1EOol00`00Oomoo`03Ool000Yoo`03001oogoo00=oo`03001oogoo
05Yoo`03001oogoo059oo`03001oogoo05Eoo`03001oogoo00=oo`002Woo00<007ooOol00goo0`00
FWoo00<007ooOol0DWoo00<007ooOol0E7oo0P001Goo0002Ool40004Ool00`00Oomoo`03Ool00`00
Oomoo`1JOol00`00Oomoo`1COol00`00Oomoo`1DOol00`00Oomoo`03Ool000Yoo`03001oogoo00=o
o`03001oogoo05Yoo`03001oogoo05=oo`03001oogoo05Aoo`03001oogoo00=oo`0027oo0`001Goo
00<007ooOol0FWoo00<007ooOol0E7oo00<007ooOol0Dgoo00<007ooOol00goo000:Ool00`00Oomo
o`03Ool00`00Oomoo`1JOol00`00Oomoo`1DOol00`00Oomoo`1COol00`00Oomoo`03Ool0011oo`03
001oogoo05Yoo`03001oogoo05Aoo`03001oogoo05=oo`03001oogoo00=oo`0047oo00<007ooOol0
FWoo00<007ooOol0E7oo00<007ooOol0Dgoo00<007ooOol00goo000@Ool00`00Oomoo`1JOol00`00
Oomoo`1DOol00`00Oomoo`1COol00`00Oomoo`03Ool0011oo`8005]oo`03001oogoo05Aoo`03001o
ogoo059oo`8000Eoo`0047oo00<007ooOol0FWoo00<007ooOol0EGoo00<007ooOol0DWoo00<007oo
Ool00goo000@Ool00`00Oomoo`1JOol00`00Oomoo`1EOol00`00Oomoo`1BOol00`00Oomoo`03Ool0
011oo`03001oogoo05Yoo`03001oogoo05Eoo`03001oogoo059oo`03001oogoo00=oo`0047oo00<0
07ooOol0FWoo00<007ooOol0EGoo00<007ooOol0DWoo00<007ooOol00goo000@Ool00`00Oomoo`1J
Ool00`00Oomoo`1EOol00`00Oomoo`1BOol00`00Oomoo`03Ool0011oo`03001oogoo05Yoo`03001o
ogoo05Eoo`03001oogoo059oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007ooOol0EGoo
00<007ooOol0DWoo00<007ooOol00goo000@Ool2001KOol00`00Oomoo`1EOol00`00Oomoo`1AOol2
0005Ool0011oo`03001oogoo05Yoo`03001oogoo05Eoo`03001oogoo059oo`03001oogoo00=oo`00
47oo00<007ooOol0FWoo00<007ooOol0EGoo00<007ooOol0DWoo00<007ooOol00goo000@Ool00`00
Oomoo`1JOol00`00Oomoo`1EOol00`00Oomoo`1BOol00`00Oomoo`03Ool0011oo`03001oogoo05Yo
o`03001oogoo05Eoo`03001oogoo059oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007oo
Ool0EGoo00<007ooOol0DWoo00<007ooOol00goo000@Ool00`00Oomoo`1JOol00`00Oomoo`1EOol0
0`00Oomoo`1BOol00`00Oomoo`03Ool0011oo`8005]oo`03001oogoo05Eoo`03001oogoo055oo`80
00Eoo`0047oo00<007ooOol0FWoo00<007ooOol0EGoo00<007ooOol0DWoo00<007ooOol00goo000@
Ool00`00Oomoo`1JOol00`00Oomoo`1EOol00`00Oomoo`1BOol00`00Oomoo`03Ool0011oo`03001o
ogoo05Yoo`03001oogoo05Eoo`03001oogoo059oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo
00<007ooOol0EGoo00<007ooOol0DWoo00<007ooOol00goo000@Ool00`00Oomoo`1JOol00`00Oomo
o`1EOol00`00Oomoo`1BOol00`00Oomoo`03Ool0011oo`03001oogoo05Yoo`03001oogoo05Eoo`03
001oogoo059oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007ooOol0EGoo00<007ooOol0
DWoo00<007ooOol00goo000@Ool2001KOol00`00Oomoo`1EOol00`00Oomoo`1AOol20005Ool0011o
o`03001oogoo05Yoo`03001oogoo05Eoo`03001oogoo059oo`03001oogoo00=oo`0047oo00<007oo
Ool0FWoo00<007ooOol0EGoo00<007ooOol0DWoo00<007ooOol00goo000@Ool00`00Oomoo`1JOol0
0`00Oomoo`1EOol00`00Oomoo`1BOol00`00Oomoo`03Ool0011oo`03001oogoo05Yoo`03001oogoo
05Eoo`03001oogoo059oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007ooOol0EGoo00<0
07ooOol0DWoo00<007ooOol00goo0009Ool20005Ool00`00Oomoo`1JOol00`00Oomoo`1EOol00`00
Oomoo`1BOol00`00Oomoo`03Ool000Qoo`04001oogoo0004Ool00`00Oomoo`1JOol00`00Oomoo`1E
Ool00`00Oomoo`1BOol00`00Oomoo`03Ool000Qoo`04001oogoo0004Ool3001JOol00`00Oomoo`1E
Ool00`00Oomoo`1AOol20005Ool000Qoo`04001oogoo0004Ool00`00Oomoo`1JOol00`00Oomoo`1E
Ool00`00Oomoo`1BOol00`00Oomoo`03Ool000Qoo`04001oogoo0004Ool00`00Oomoo`1JOol00`00
Oomoo`1EOol00`00Oomoo`1BOol00`00Oomoo`03Ool000Qoo`04001oogoo0004Ool00`00Oomoo`1J
Ool00`00Oomoo`1EOol00`00Oomoo`1BOol00`00Oomoo`03Ool000Uoo`8000Eoo`03001oogoo05Yo
o`03001oogoo05Eoo`03001oogoo059oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007oo
Ool0EGoo00<007ooOol0DWoo00<007ooOol00goo000@Ool00`00Oomoo`1JOol00`00Oomoo`1FOol0
0`00Oomoo`1AOol00`00Oomoo`03Ool0011oo`03001oogoo05Yoo`03001oogoo05Ioo`03001oogoo
055oo`03001oogoo00=oo`0047oo0P00Fgoo00<007ooOol0EWoo00<007ooOol0D7oo0P001Goo000@
Ool00`00Oomoo`1JOol00`00Oomoo`1FOol00`00Oomoo`1AOol00`00Oomoo`03Ool0011oo`03001o
ogoo05Yoo`03001oogoo05Ioo`03001oogoo055oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo
00<007ooOol0EWoo00<007ooOol0DGoo00<007ooOol00goo000@Ool00`00Oomoo`1JOol00`00Oomo
o`1FOol00`00Oomoo`1AOol00`00Oomoo`03Ool0011oo`03001oogoo05Yoo`03001oogoo05Ioo`03
001oogoo055oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007ooOol0EWoo00<007ooOol0
DGoo00<007ooOol00goo000@Ool00`00Oomoo`1JOol00`00Oomoo`1FOol00`00Oomoo`1AOol00`00
Oomoo`03Ool0011oo`8005]oo`03001oogoo05Ioo`03001oogoo051oo`8000Eoo`0047oo00<007oo
Ool0FWoo00<007ooOol0EWoo00<007ooOol0DGoo00<007ooOol00goo000@Ool00`00Oomoo`1JOol0
0`00Oomoo`1FOol00`00Oomoo`1AOol00`00Oomoo`03Ool0011oo`03001oogoo05Yoo`03001oogoo
05Ioo`03001oogoo055oo`03001oogoo00=oo`0047oo00<007ooOol0FWoo00<007ooOol0EWoo00<0
07ooOol0DGoo00<007ooOol00goo000@Ool00`00Oomoo`1IOol00`00Oomoo`1GOol00`00Oomoo`1A
Ool00`00Oomoo`03Ool0011oo`03001oogoo05Uoo`03001oogoo05Moo`03001oogoo055oo`03001o
ogoo00=oo`0047oo0P00FWoo00<007ooOol0Egoo00<007ooOol0D7oo0P001Goo000@Ool00`00Oomo
o`1IOol00`00Oomoo`1GOol00`00Oomoo`1AOol00`00Oomoo`03Ool0011oo`03001oogoo05Uoo`03
001oogoo05Moo`03001oogoo055oo`03001oogoo00=oo`0047oo00<007ooOol0FGoo00<007ooOol0
Egoo00<007ooOol0DGoo00<007ooOol00goo000@Ool00`00Oomoo`1IOol00`00Oomoo`1GOol00`00
Oomoo`1AOol00`00Oomoo`03Ool0011oo`03001oogoo05Uoo`03001oogoo05Moo`03001oogoo055o
o`03001oogoo00=oo`0047oo00<007ooOol0FGoo00<007ooOol0Egoo00<007ooOol0DGoo00<007oo
Ool00goo000@Ool00`00Oomoo`1IOol00`00Oomoo`1GOol00`00Oomoo`1AOol00`00Oomoo`03Ool0
011oo`8005Yoo`03001oogoo05Moo`03001oogoo051oo`8000Eoo`0047oo00<007ooOol0FGoo00<0
07ooOol0Egoo00<007ooOol0DGoo00<007ooOol00goo000@Ool00`00Oomoo`1IOol00`00Oomoo`1G
Ool00`00Oomoo`1AOol00`00Oomoo`03Ool0011oo`03001oogoo05Uoo`03001oogoo05Moo`03001o
ogoo055oo`03001oogoo00=oo`0047oo00<007ooOol0F7oo00<007ooOol0F7oo00<007ooOol0DGoo
00<007ooOol00goo000@Ool00`00Oomoo`1HOol00`00Oomoo`1HOol00`00Oomoo`1AOol00`00Oomo
o`03Ool000Qoo`@000Aoo`03001oogoo05Qoo`03001oogoo05Qoo`03001oogoo055oo`03001oogoo
00=oo`002Woo00<007ooOol00goo00<007ooOol0F7oo00<007ooOol0F7oo00<007ooOol0DGoo00<0
07ooOol00goo000:Ool00`00Oomoo`03Ool3001GOol00`00Oomoo`1IOol00`00Oomoo`1@Ool20005
Ool000Yoo`03001oogoo00=oo`03001oogoo05Moo`03001oogoo05Uoo`03001oogoo055oo`03001o
ogoo00=oo`002Woo00<007ooOol00goo00<007ooOol0Egoo00<007ooOol0FGoo00<007ooOol0DGoo
00<007ooOol00goo0008Ool30005Ool00`00Oomoo`1FOol00`00Oomoo`1JOol00`00Oomoo`1AOol0
0`00Oomoo`03Ool000Yoo`03001oogoo00=oo`03001oogoo05Ioo`03001oogoo05Yoo`03001oogoo
055oo`03001oogoo00=oo`0047oo00<007ooOol0EGoo00<007ooOol0Fgoo00<007ooOol0DGoo00<0
07ooOol00goo000@Ool00`00Oomoo`1DOol00`00Oomoo`1LOol00`00Oomoo`1AOol00`00Oomoo`03
Ool0011oo`03001oogoo05=oo`03001oogoo05eoo`03001oogoo055oo`03001oogoo00=oo`0047oo
0P00Dgoo00<007ooOol0GWoo00<007ooOol0D7oo0P001Goo000@Ool00`00Oomoo`1AOol00`00Oomo
o`1OOol00`00Oomoo`1AOol00`00Oomoo`03Ool0011oo`03001oogoo04moo`80069oo`03001oogoo
04]oo`03001oogoo00=oo`03001oogoo00=oo`0047oo00<007ooOol0CWoo00<007ooOol0HWoo00<0
07ooOol0BGoo0P001Woo00<007ooOol00goo000@Ool00`00Oomoo`1<Ool2001UOol00`00Oomoo`18
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool0011oo`03001oogoo04]oo`03001oogoo06Eoo`03001o
ogoo04Ioo`8000Uoo`03001oogoo00=oo`0047oo00<007ooOol0BGoo0P00J7oo00<007ooOol0A7oo
0P002goo00<007ooOol00goo000@Ool00`00Oomoo`18Ool00`00Oomoo`1XOol00`00Oomoo`13Ool0
0`00Oomoo`0;Ool00`00Oomoo`03Ool0011oo`8004Moo`8006]oo`03001oogoo045oo`8000eoo`80
00Eoo`0047oo00<007ooOol0A7oo0P00KGoo00<007ooOol0?goo0P0047oo00<007ooOol00goo000@
Ool00`00Oomoo`12Ool2001_Ool00`00Oomoo`0mOol2000BOol00`00Oomoo`03Ool0011oo`03001o
ogoo041oo`80075oo`03001oogoo03]oo`8001Aoo`03001oogoo00=oo`0047oo00<007ooOol0?Goo
0`00Lgoo00<007ooOol0>Goo0P005Woo00<007ooOol00goo000@Ool00`00Oomoo`0kOol2001fOol0
0`00Oomoo`0gOol2000HOol00`00Oomoo`03Ool0011oo`03001oogoo03Qoo`<007Qoo`03001oogoo
03Eoo`8001Yoo`03001oogoo00=oo`0047oo0P00=goo0P00Ngoo00<007ooOol0<Woo0`006goo0P00
1Goo000@Ool00`00Oomoo`0dOol2001mOol00`00Oomoo`0`Ool2000OOol00`00Oomoo`03Ool0011o
o`03001oogoo039oo`8007moo`03001oogoo02eoo`<0025oo`03001oogoo00=oo`0047oo00<007oo
Ool0<7oo0P00PGoo00<007ooOol0:Woo0`0097oo00<007ooOol00goo000@Ool00`00Oomoo`0]Ool3
0023Ool00`00Oomoo`0VOol4000WOol00`00Oomoo`03Ool0011oo`03001oogoo02Uoo`@008Ioo`03
001oogoo029oo`@002]oo`03001oogoo00=oo`0047oo00<007ooOol09Woo0`00RWoo00<007ooOol0
7goo0`00;goo00<007ooOol00goo000@Ool00`00Oomoo`0SOol3002=Ool00`00Oomoo`0MOol2000b
Ool00`00Oomoo`03Ool0011oo`80021oo`@0091oo`03001oogoo01Yoo`<003=oo`8000Eoo`0047oo
00<007ooOol06goo1000U7oo00<007ooOol067oo0P00=goo00<007ooOol00goo000@Ool00`00Oomo
o`0HOol3002HOol00`00Oomoo`0EOol3000iOol00`00Oomoo`03Ool0011oo`03001oogoo01Aoo`@0
09]oo`03001oogoo015oo`@003aoo`03001oogoo00=oo`0047oo00<007ooOol047oo1000Wgoo00<0
07ooOol03Goo1000@7oo00<007ooOol00goo000@Ool00`00Oomoo`0=Ool3002SOol00`00Oomoo`09
Ool40014Ool00`00Oomoo`03Ool000Qoo`@000Aoo`03001oogoo00Uoo`@00:Ioo`03001oogoo00Eo
o`@004Qoo`03001oogoo00=oo`0027oo00<007ooOol01Goo00<007ooOol01Woo0`00ZWoo00@007oo
Oomoo`@004aoo`03001oogoo00=oo`002Goo00<007ooOol017oo0`0017oo0P00[Woo0`00Cgoo0P00
1Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`3oOol8Ool00`00Oomoo`03Ool000]oo`03001oogoo
009oo`03001oogoo0?moo`Qoo`03001oogoo00=oo`0027oo00@007ooOol000Aoo`03001oogoo00Ao
o`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Mo
o`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Mo
o`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Mo
o`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Mo
o`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Mo
o`03001oogoo00=oo`03001oogoo00=oo`002Goo0P001Gooo`0030001Goo0000\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {318.5, 97.3125}} -> {-0.968075, \
-0.4267, 0.00987115, 0.0256625}}]
}, Open  ]],

Cell["This plots the step sizes taken in computing the solution.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(StepDataPlot[vdpsol];\)\)], "Input",
  CellLabel->"In[16]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.381631 0.0146658 7.49561 [
[.21463 .00217 -9 -9 ]
[.21463 .00217 9 0 ]
[.40544 .00217 -3 -9 ]
[.40544 .00217 3 0 ]
[.59626 .00217 -9 -9 ]
[.59626 .00217 9 0 ]
[.78707 .00217 -3 -9 ]
[.78707 .00217 3 0 ]
[.97789 .00217 -9 -9 ]
[.97789 .00217 9 0 ]
[.01131 .16458 -24 -4.5 ]
[.01131 .16458 0 4.5 ]
[.01131 .31449 -24 -4.5 ]
[.01131 .31449 0 4.5 ]
[.01131 .4644 -24 -4.5 ]
[.01131 .4644 0 4.5 ]
[.01131 .61431 -24 -4.5 ]
[.01131 .61431 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21463 .01467 m
.21463 .02092 L
s
[(0.5)] .21463 .00217 0 1 Mshowa
.40544 .01467 m
.40544 .02092 L
s
[(1)] .40544 .00217 0 1 Mshowa
.59626 .01467 m
.59626 .02092 L
s
[(1.5)] .59626 .00217 0 1 Mshowa
.78707 .01467 m
.78707 .02092 L
s
[(2)] .78707 .00217 0 1 Mshowa
.97789 .01467 m
.97789 .02092 L
s
[(2.5)] .97789 .00217 0 1 Mshowa
.125 Mabswid
.06197 .01467 m
.06197 .01842 L
s
.10014 .01467 m
.10014 .01842 L
s
.1383 .01467 m
.1383 .01842 L
s
.17646 .01467 m
.17646 .01842 L
s
.25279 .01467 m
.25279 .01842 L
s
.29095 .01467 m
.29095 .01842 L
s
.32911 .01467 m
.32911 .01842 L
s
.36728 .01467 m
.36728 .01842 L
s
.4436 .01467 m
.4436 .01842 L
s
.48177 .01467 m
.48177 .01842 L
s
.51993 .01467 m
.51993 .01842 L
s
.55809 .01467 m
.55809 .01842 L
s
.63442 .01467 m
.63442 .01842 L
s
.67258 .01467 m
.67258 .01842 L
s
.71075 .01467 m
.71075 .01842 L
s
.74891 .01467 m
.74891 .01842 L
s
.82524 .01467 m
.82524 .01842 L
s
.8634 .01467 m
.8634 .01842 L
s
.90156 .01467 m
.90156 .01842 L
s
.93972 .01467 m
.93972 .01842 L
s
.25 Mabswid
0 .01467 m
1 .01467 L
s
.02381 .16458 m
.03006 .16458 L
s
[(0.02)] .01131 .16458 1 0 Mshowa
.02381 .31449 m
.03006 .31449 L
s
[(0.04)] .01131 .31449 1 0 Mshowa
.02381 .4644 m
.03006 .4644 L
s
[(0.06)] .01131 .4644 1 0 Mshowa
.02381 .61431 m
.03006 .61431 L
s
[(0.08)] .01131 .61431 1 0 Mshowa
.125 Mabswid
.02381 .05214 m
.02756 .05214 L
s
.02381 .08962 m
.02756 .08962 L
s
.02381 .1271 m
.02756 .1271 L
s
.02381 .20206 m
.02756 .20206 L
s
.02381 .23953 m
.02756 .23953 L
s
.02381 .27701 m
.02756 .27701 L
s
.02381 .35197 m
.02756 .35197 L
s
.02381 .38945 m
.02756 .38945 L
s
.02381 .42692 m
.02756 .42692 L
s
.02381 .50188 m
.02756 .50188 L
s
.02381 .53936 m
.02756 .53936 L
s
.02381 .57684 m
.02756 .57684 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.5 Mabswid
.02381 .01473 m
.02381 .01472 L
.02382 .01475 L
.02382 .01486 L
.02383 .01521 L
.02386 .01581 L
.02392 .0168 L
.02402 .01802 L
.02419 .01965 L
.02445 .02201 L
.02482 .02573 L
.02539 .03195 L
.02627 .03305 L
.0272 .0351 L
.02824 .05116 L
.0301 .0877 L
.03382 .1504 L
.04073 .21763 L
.05106 .39407 L
.07038 .02526 L
.07092 .02526 L
.07146 .03097 L
.07229 .04939 L
.07406 .08054 L
.07741 .18995 L
.08633 .2686 L
.09926 .60332 L
.12923 .49673 L
.15378 .5723 L
.18217 .35093 L
.19929 .02187 L
.19966 .02187 L
.20002 .02196 L
.20039 .02196 L
.20076 .02193 L
.20113 .02193 L
.2015 .02195 L
.20187 .02195 L
.20225 .02194 L
.20262 .02194 L
.20299 .02194 L
.20336 .02194 L
.20373 .02194 L
.2041 .02194 L
.20447 .02194 L
.20484 .02194 L
.20521 .02194 L
.20558 .02194 L
.20595 .02195 L
.20632 .02195 L
Mistroke
.20669 .02195 L
.20706 .02195 L
.20743 .02195 L
.2078 .02195 L
.20818 .02196 L
.20855 .02196 L
.20892 .02196 L
.20929 .02196 L
.20966 .02196 L
.21003 .02196 L
.2104 .02197 L
.21077 .02197 L
.21115 .02197 L
.21152 .02197 L
.21189 .02198 L
.21226 .02198 L
.21264 .02199 L
.21301 .02199 L
.21338 .02199 L
.21375 .02199 L
.21413 .022 L
.2145 .022 L
.21487 .02201 L
.21525 .02201 L
.21562 .02202 L
.216 .02202 L
.21637 .02202 L
.21674 .02202 L
.21712 .02203 L
.21749 .02203 L
.21787 .02204 L
.21824 .02204 L
.21862 .02205 L
.219 .02205 L
.21937 .02206 L
.21975 .02206 L
.22013 .02208 L
.2205 .02208 L
.22088 .02209 L
.22126 .02209 L
.22164 .0221 L
.22202 .0221 L
.22239 .02212 L
.22277 .02212 L
.22315 .02213 L
.22353 .02213 L
.22391 .02214 L
.22429 .02214 L
.22467 .02216 L
.22506 .02216 L
Mistroke
.22544 .02218 L
.22582 .02218 L
.2262 .02219 L
.22659 .02219 L
.22697 .02221 L
.22735 .02221 L
.22774 .02223 L
.22812 .02223 L
.22851 .02225 L
.22889 .02225 L
.22928 .02951 L
.23004 .04216 L
.23144 .06546 L
.23402 .09375 L
.23805 .17353 L
.24614 .16555 L
.25382 .1546 L
.26094 .14449 L
.26755 .14672 L
.27428 .01964 L
.27453 .01917 L
.27476 .02111 L
.27509 .02809 L
.27577 .02696 L
.2764 .01961 L
.27665 .01906 L
.27687 .02093 L
.27719 .02786 L
.27786 .01949 L
.27811 .01896 L
.27833 .0208 L
.27864 .02769 L
.2793 .019 L
.27952 .01878 L
.27973 .02064 L
.28004 .02753 L
.28069 .0194 L
.28093 .01881 L
.28114 .02056 L
.28144 .02739 L
.28209 .01884 L
.2823 .01862 L
.28251 .02042 L
.2828 .02723 L
.28344 .02583 L
.28401 .0253 L
.28455 .02904 L
.28528 .04122 L
.28663 .0434 L
.28809 .01842 L
Mistroke
.28829 .01828 L
.28847 .01996 L
.28874 .02663 L
.28935 .03916 L
.2906 .05766 L
.29279 .01823 L
.29297 .01806 L
.29314 .01963 L
.29339 .02618 L
.29398 .03839 L
.29519 .05484 L
.29723 .01801 L
.2974 .01785 L
.29756 .01932 L
.2978 .02576 L
.29837 .03771 L
.29954 .05255 L
.30147 .01812 L
.30164 .01769 L
.3018 .01905 L
.30202 .02537 L
.30257 .03702 L
.3037 .05056 L
.30553 .05763 L
.30772 .01762 L
.30787 .0174 L
.30801 .01865 L
.30821 .02446 L
.30871 .03512 L
.30975 .04748 L
.31142 .06277 L
.31387 .01723 L
.314 .01714 L
.31413 .0183 L
.31431 .02359 L
.31477 .01716 L
.31489 .01711 L
.31502 .01826 L
.3152 .02348 L
.31565 .01712 L
.31578 .01708 L
.3159 .01821 L
.31608 .02337 L
.31652 .01709 L
.31665 .01705 L
.31677 .01817 L
.31695 .02327 L
.31738 .01706 L
.31751 .01702 L
.31763 .01813 L
Mistroke
.3178 .02318 L
.31824 .01703 L
.31836 .017 L
.31847 .0181 L
.31865 .02309 L
.31908 .01701 L
.3192 .01697 L
.31931 .01806 L
.31949 .02301 L
.31991 .01699 L
.32003 .01695 L
.32015 .01804 L
.32032 .02294 L
.32074 .01697 L
.32086 .01694 L
.32097 .01801 L
.32114 .02288 L
.32156 .01696 L
.32168 .01693 L
.32179 .01799 L
.32196 .02284 L
.32238 .01695 L
.3225 .01692 L
.32261 .01798 L
.32278 .02281 L
.32319 .03168 L
.32406 .04295 L
.3255 .05579 L
.32759 .08207 L
.33103 .11654 L
.33621 .07649 L
.33936 .01531 L
.33939 .01531 L
.33943 .01563 L
.33948 .01703 L
.3396 .02068 L
.3399 .02718 L
.34054 .03751 L
.3417 .04772 L
.34338 .03526 L
.34443 .03526 L
.34548 .0372 L
.34663 .02488 L
.34715 .02488 L
.34767 .02717 L
.34831 .02916 L
.34904 .02942 L
.34979 .02692 L
.35042 .03219 L
.35131 .04017 L
Mistroke
.35261 .03868 L
.35383 .03807 L
.35502 .03952 L
.35629 .03834 L
.35749 .03776 L
.35867 .06704 L
.36134 .12408 L
.36691 .19773 L
.37623 .33829 L
.3927 .35022 L
.40979 .35204 L
.42697 .0262 L
.42755 .02511 L
.42808 .0306 L
.4289 .04926 L
.43066 .07745 L
.43385 .15481 L
.44099 .16361 L
.44857 .16903 L
.45643 .17082 L
.46438 .16901 L
.47224 .16407 L
.47985 .15697 L
.48709 .14888 L
.49393 .14091 L
.50035 .21207 L
.5104 .18043 L
.51884 .02245 L
.51924 .02245 L
.51964 .02226 L
.52002 .02226 L
.52041 .02225 L
.5208 .02225 L
.52118 .02223 L
.52157 .02223 L
.52195 .02221 L
.52234 .02221 L
.52272 .0222 L
.5231 .0222 L
.52349 .02218 L
.52387 .02218 L
.52425 .02216 L
.52463 .02216 L
.52502 .02214 L
.5254 .02214 L
.52578 .02212 L
.52616 .02212 L
.52654 .02211 L
.52691 .02211 L
.52729 .02209 L
Mistroke
.52767 .02209 L
.52805 .02207 L
.52843 .02207 L
.5288 .02205 L
.52918 .02205 L
.52956 .02203 L
.52993 .02203 L
.53031 .02202 L
.53068 .02202 L
.53105 .022 L
.53143 .022 L
.5318 .02198 L
.53217 .02198 L
.53255 .02197 L
.53292 .02197 L
.53329 .02195 L
.53366 .02195 L
.53403 .02194 L
.5344 .02194 L
.53477 .02194 L
.53514 .02194 L
.53551 .02194 L
.53588 .02194 L
.53625 .02194 L
.53662 .02194 L
.537 .02194 L
.53737 .02194 L
.53774 .02194 L
.53811 .02194 L
.53848 .02194 L
.53885 .02194 L
.53922 .02195 L
.53959 .02195 L
.53996 .02195 L
.54033 .02195 L
.5407 .02195 L
.54107 .02195 L
.54144 .02195 L
.54181 .02195 L
.54218 .02196 L
.54256 .02196 L
.54293 .02196 L
.5433 .02196 L
.54367 .02196 L
.54404 .02196 L
.54441 .02197 L
.54478 .02197 L
.54516 .02198 L
.54553 .02198 L
.5459 .02198 L
Mistroke
.54627 .02198 L
.54665 .02199 L
.54702 .02199 L
.54739 .02199 L
.54776 .02199 L
.54814 .022 L
.54851 .022 L
.54888 .02201 L
.54926 .02201 L
.54963 .02202 L
.55001 .02202 L
.55038 .02203 L
.55076 .02203 L
.55113 .02204 L
.55151 .02204 L
.55188 .02205 L
.55226 .02205 L
.55263 .02206 L
.55301 .02206 L
.55339 .02207 L
.55376 .02207 L
.55414 .02208 L
.55452 .02208 L
.55489 .02209 L
.55527 .02209 L
.55565 .02211 L
.55603 .02211 L
.55641 .02212 L
.55679 .02212 L
.55717 .02213 L
.55755 .02213 L
.55793 .02215 L
.55831 .02215 L
.55869 .02217 L
.55907 .02217 L
.55945 .02218 L
.55984 .02218 L
.56022 .0222 L
.5606 .0222 L
.56099 .02222 L
.56137 .02222 L
.56175 .02224 L
.56214 .02224 L
.56253 .02959 L
.56329 .04249 L
.5647 .06508 L
.56727 .09352 L
.57128 .17395 L
.57939 .16628 L
.58711 .15538 L
Mistroke
.59428 .14509 L
.60092 .14615 L
.60761 .01967 L
.60787 .0192 L
.6081 .02115 L
.60843 .02815 L
.60911 .02703 L
.60974 .01947 L
.60999 .01905 L
.61021 .02095 L
.61053 .0279 L
.61121 .01962 L
.61146 .01901 L
.61168 .02084 L
.61199 .02774 L
.61266 .01949 L
.6129 .01891 L
.61312 .02071 L
.61343 .02758 L
.61409 .01926 L
.61432 .01879 L
.61453 .02058 L
.61483 .02743 L
.61548 .01883 L
.61569 .01863 L
.6159 .02045 L
.61619 .02727 L
.61683 .02589 L
.6174 .02535 L
.61795 .0291 L
.61868 .04132 L
.62004 .04365 L
.62151 .01845 L
.62171 .0183 L
.62189 .01998 L
.62216 .02666 L
.62277 .03922 L
.62402 .0579 L
.62623 .01824 L
.62641 .01808 L
.62658 .01965 L
.62683 .02621 L
.62742 .03845 L
.62863 .05503 L
.63069 .018 L
.63086 .01786 L
.63102 .01934 L
.63126 .02579 L
.63182 .03776 L
.633 .0527 L
Mistroke
.63494 .01811 L
.63511 .0177 L
.63527 .01907 L
.63549 .0254 L
.63604 .03708 L
.63718 .05071 L
.63901 .05795 L
.64122 .01763 L
.64137 .01741 L
.64151 .01867 L
.64171 .0245 L
.64221 .0352 L
.64326 .04761 L
.64494 .063 L
.6474 .01724 L
.64753 .01715 L
.64765 .01832 L
.64784 .02363 L
.6483 .01717 L
.64842 .01712 L
.64855 .01827 L
.64873 .02351 L
.64918 .01713 L
.64931 .01708 L
.64943 .01822 L
.64961 .0234 L
.65006 .0171 L
.65018 .01706 L
.6503 .01818 L
.65048 .0233 L
.65092 .01707 L
.65104 .01703 L
.65116 .01814 L
.65134 .0232 L
.65178 .01704 L
.6519 .017 L
.65202 .01811 L
.65219 .02311 L
.65262 .01701 L
.65274 .01698 L
.65286 .01807 L
.65303 .02303 L
.65346 .017 L
.65358 .01696 L
.65369 .01804 L
.65386 .02296 L
.65429 .01698 L
.6544 .01694 L
.65452 .01802 L
.65469 .0229 L
Mistroke
.65511 .01696 L
.65523 .01693 L
.65534 .018 L
.65551 .02285 L
.65593 .01695 L
.65604 .01692 L
.65616 .01798 L
.65633 .02282 L
.65674 .01695 L
.65686 .01691 L
.65697 .01798 L
.65714 .0228 L
.65756 .03167 L
.65842 .04288 L
.65986 .05569 L
.66195 .08193 L
.66537 .11544 L
.6705 .07607 L
.67363 .01527 L
.67366 .01527 L
.67369 .01556 L
.67374 .01686 L
.67385 .02031 L
.67414 .0263 L
.67473 .03603 L
.67582 .04561 L
.67739 .03446 L
.6784 .03446 L
.67941 .03635 L
.68051 .02465 L
.68102 .02465 L
.68153 .02692 L
.68215 .029 L
.68288 .02961 L
.68364 .02747 L
.68429 .03216 L
.68518 .01472 L
.68519 .01472 L
.68519 .01474 L
.68519 .01484 L
.6852 .01517 L
.68523 .01572 L
.68528 .01663 L
.68538 .01758 L
.68553 .01874 L
.68574 .02105 L
.68606 .02363 L
.68652 .02742 L
.68717 .02777 L
.68784 .02762 L
Mistroke
.68849 .01507 L
.68852 .01506 L
.68853 .01525 L
.68856 .01611 L
.68864 .01736 L
.68878 .01928 L
.68901 .02204 L
.68939 .02696 L
.69001 .03502 L
.69105 .05601 L
.69315 .08244 L
.6966 .15621 L
.70381 .19501 L
.71299 .32499 L
.72879 .34569 L
.74565 .35057 L
.76275 .02611 L
.76333 .0251 L
.76386 .03057 L
.76467 .04927 L
.76643 .07721 L
.76962 .15238 L
.77663 .16063 L
.78406 .16552 L
.79174 .16693 L
.79949 .16498 L
.80715 .16023 L
.81456 .15359 L
.82163 .14615 L
.82833 .13887 L
.83465 .2138 L
.84479 .18145 L
.85328 .02235 L
.85367 .02235 L
.85406 .02225 L
.85445 .02225 L
.85483 .02224 L
.85522 .02224 L
.85561 .02222 L
.85599 .02222 L
.85637 .0222 L
.85676 .0222 L
.85714 .02218 L
.85752 .02218 L
.85791 .02216 L
.85829 .02216 L
.85867 .02214 L
.85905 .02214 L
.85943 .02213 L
.85981 .02213 L
Mistroke
.86019 .02211 L
.86057 .02211 L
.86095 .02209 L
.86133 .02209 L
.8617 .02207 L
.86208 .02207 L
.86246 .02205 L
.86284 .02205 L
.86321 .02204 L
.86359 .02204 L
.86396 .02202 L
.86434 .02202 L
.86471 .022 L
.86508 .022 L
.86546 .02199 L
.86583 .02199 L
.8662 .02197 L
.86657 .02197 L
.86695 .02195 L
.86732 .02195 L
.86769 .02194 L
.86806 .02194 L
.86843 .02194 L
.8688 .02194 L
.86917 .02194 L
.86954 .02194 L
.86991 .02194 L
.87028 .02194 L
.87065 .02194 L
.87102 .02194 L
.87139 .02194 L
.87176 .02194 L
.87213 .02194 L
.8725 .02194 L
.87288 .02194 L
.87325 .02194 L
.87362 .02195 L
.87399 .02195 L
.87436 .02195 L
.87473 .02195 L
.8751 .02195 L
.87547 .02195 L
.87584 .02196 L
.87621 .02196 L
.87658 .02196 L
.87696 .02196 L
.87733 .02196 L
.8777 .02196 L
.87807 .02197 L
.87844 .02197 L
Mistroke
.87881 .02197 L
.87919 .02197 L
.87956 .02198 L
.87993 .02198 L
.8803 .02199 L
.88068 .02199 L
.88105 .02199 L
.88142 .02199 L
.88179 .022 L
.88217 .022 L
.88254 .02201 L
.88291 .02201 L
.88329 .02202 L
.88366 .02202 L
.88404 .02203 L
.88441 .02203 L
.88479 .02203 L
.88516 .02203 L
.88554 .02204 L
.88591 .02204 L
.88629 .02206 L
.88666 .02206 L
.88704 .02207 L
.88742 .02207 L
.88779 .02208 L
.88817 .02208 L
.88855 .02209 L
.88893 .02209 L
.88931 .0221 L
.88968 .0221 L
.89006 .02212 L
.89044 .02212 L
.89082 .02213 L
.8912 .02213 L
.89158 .02215 L
.89196 .02215 L
.89234 .02216 L
.89273 .02216 L
.89311 .02218 L
.89349 .02218 L
.89387 .0222 L
.89426 .0222 L
.89464 .02222 L
.89502 .02222 L
.89541 .02223 L
.89579 .02223 L
.89618 .02225 L
.89656 .02225 L
.89695 .0295 L
.89771 .04209 L
Mistroke
.8991 .06555 L
.90169 .09381 L
.90572 .17347 L
.91381 .16541 L
.92148 .15444 L
.9286 .14436 L
.9352 .20566 L
.94493 .01946 L
.94517 .01898 L
.94539 .02083 L
.9457 .02774 L
.94637 .01944 L
.94661 .0189 L
.94683 .02071 L
.94714 .02759 L
.9478 .01925 L
.94803 .01879 L
.94824 .02059 L
.94854 .02743 L
.94919 .01883 L
.9494 .01864 L
.9496 .02045 L
.9499 .02728 L
.95054 .02589 L
.95111 .02536 L
.95166 .02513 L
.95219 .01859 L
.95239 .01846 L
.95258 .02022 L
.95287 .02697 L
.95349 .0255 L
.95404 .0289 L
.95477 .01845 L
.95496 .01833 L
.95515 .02002 L
.95542 .02671 L
.95603 .03931 L
.95729 .05825 L
.95951 .01826 L
.95969 .0181 L
.95987 .01968 L
.96012 .02625 L
.96071 .03852 L
.96193 .0553 L
.96399 .018 L
.96416 .01788 L
.96433 .01937 L
.96457 .02583 L
.96514 .03783 L
.96632 .05293 L
Mistroke
.96826 .0181 L
.96844 .01772 L
.96859 .0191 L
.96882 .02544 L
.96937 .03717 L
.97051 .05092 L
.97236 .01791 L
.97253 .01754 L
.97267 .01883 L
.97288 .0249 L
.9734 .03605 L
.97449 .048 L
.97619 .048 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[16]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00AWoo0P0017oo00<007ooOol00Woo0`00:Goo1000:7oo10000goo00<007ooOol0
0Woo0`00:Goo1000:Goo10000goo00<007ooOol00Woo0`000goo0015Ool01000Oomoo`002goo00<0
07ooOol0:7oo00<007ooOol0:Goo00<007ooOol02Woo00<007ooOol09Woo00<007ooOol0:Woo00<0
07ooOol037oo0@000Goo0Goo0015Ool01000Oomoo`002goo00<007ooOol0:7oo00<007ooOol0:Goo
00<007ooOol02Woo00<007ooOol09goo00<007ooOol0:Woo00<007ooOol02goo0@000Goo0Goo0015
Ool01000Oomoo`0027oo0`00:goo00<007ooOol0:Goo00<007ooOol01goo0`00:goo00<007ooOol0
:Woo00<007ooOol01goo0`000goo0015Ool01000Oomoo`0027oo00<007ooOol0:goo00<007ooOol0
:Goo00<007ooOol01goo00<007ooOol0;7oo00<007ooOol0:Woo00<007ooOol01Woo00<007ooOol0
0goo0015Ool01000Oomoo`0027oo00<007ooOol0:Goo0`00:Goo0`002Goo00<007ooOol0:Goo00@0
07ooOol002Uoo`04001oogoo0008Ool00`00Oomoo`03Ool001]oo`03001oogoo02Qoo`8000Uoo`@0
02Yoo`03001oogoo02Uoo`03001oogoo00Moo`@002Uoo`8002]oo`8000Uoo`@0009oo`006goo00<0
07ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`005Gooo`00
200017oo000KOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool0
0`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`03Ool900001Woo00000000Ool0009oo`03001o
ogoo00Aoo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00<00003Ool0000000800003Ool007oo00<000=oo`80
009oo`8000Aoo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oo`0000800003Ool0000000800003Ool007oo00Qoo`00
6goo00<007ooOol0:goo2@002goo2@0000Aoo`00000000Aoo`03001oogoo00ioo`03001oogoo01]o
o``000Qoo`03001oogoo00<00003Ool0000000800003Ool007oo00<000Aoo`03001oogoo008001Qo
o`03001oogoo00moo``000aoo`P00003Ool007oo00Qoo`006goo00<007ooOol02Goo00<007ooOol0
7goo00<007ooOol01Goo00<007ooOol02Goo2`0000=oo`00Ool00goo00<007oo000057oo00<007oo
Ool05Goo00<007ooOol027oo00<007ooOol02Goo2P0000Aoo`00Ool000Aoo`D0019oo`03001oogoo
01Eoo`03001oogoo00Qoo`03001oogoo00Yoo`P000]oo`006goo00<007ooOol02Goo00<007ooOol0
7goo00<007ooOol01Goo00<007ooOol02Goo2`0000=oo`00Ool00goo00<007oo000057oo00<007oo
Ool05Goo00<007ooOol027oo00<007ooOol02Goo2P0000Aoo`00Ool000Aoo`D0019oo`03001oogoo
01Eoo`03001oogoo00Qoo`03001oogoo00Yoo`03001oo`0000D000]oo`006goo00<007ooOol02Goo
00<007ooOol07goo00<007ooOol01Goo00<007ooOol02Goo00<007oo0000200000=oo`00Ool00goo
0P0000=oo`00Ool04Woo00<007ooOol05Goo00<007ooOol027oo00<007ooOol02Goo00<007ooOol0
1`0000Aoo`00Ool000Aoo`<00003Ool007oo015oo`03001oogoo01Eoo`03001oogoo00Qoo`03001o
ogoo00Yoo`03001oogoo00D000]oo`006goo0P002Woo00<007ooOol07goo00<007ooOol01Goo00<0
07ooOol02Goo00<007oo0000200000=oo`00Ool00goo0P0000=oo`0000004Woo00<007ooOol05Goo
00<007ooOol02Goo00<007ooOol027oo00<007ooOol01`0000Aoo`00Ool000Aoo`80009oo`03001o
ogoo011oo`03001oogoo01Eoo`03001oogoo00Qoo`03001oogoo00Yoo`03001oogoo00D000]oo`00
6goo0P002Woo0P0087oo00<007ooOol01Goo00<007ooOol02Goo00<007oo000020000Woo00@007oo
Oomoo`800003Ool00000019oo`03001oogoo01Eoo`03001oogoo00Uoo`03001oogoo00Qoo`03001o
ogoo00L00005Ool007ooOol00003Ool01@00Oomoogoo00004Woo00<007ooOol05Goo00<007ooOol0
27oo00<007ooOol02Woo00<007ooOol01@002goo000KOol2000:Ool2000POol00`00Oomoo`05Ool0
0`00Oomoo`09Ool00`00Oomoo`070003Ool01@00Oomoogoo00000goo00<007ooOol047oo00<007oo
Ool05Goo00<007ooOol02Goo00<007ooOol027oo00<007ooOol01P0000=oo`00Ool00Woo00D007oo
Oomoo`0000=oo`03001oogoo011oo`03001oogoo01Eoo`03001oogoo00Qoo`03001oogoo00Yoo`03
001oogoo00H000Yoo`006goo0P002Woo0P0087oo00<007ooOol01Goo00<007ooOol02Goo00@007oo
Oomoo`H000=oo`03001oogoo008000=oo`03001oogoo011oo`03001oogoo01Eoo`03001oogoo00Uo
o`03001oogoo00Qoo`04001oogooOol500000goo001oo`02Ool01000Oomoo`0017oo00<007ooOol0
47oo00<007ooOol05Goo00<007ooOol027oo00<007ooOol02Woo00<007ooOol00`0000=oo`000000
2Woo000KOol2000:Ool2000POol00`00Oomoo`05Ool00`00Oomoo`08Ool00`00Oomoo`02Ool60003
Ool01000Oomoo`0017oo00<007ooOol047oo00<007ooOol05Goo00<007ooOol02Goo00<007ooOol0
1goo00<007ooOol00goo100000=oo`00Ool00Woo00@007ooOol000Aoo`03001oogoo011oo`03001o
ogoo01Eoo`03001oogoo00Qoo`03001oogoo00Uoo`04001oogooOol300000goo001oo`0:Ool001]o
o`8000Yoo`8001moo`03001oogoo00Ioo`03001oogoo00Qoo`03001oogoo009oo`80009oo`8000=o
o`04001oogoo0005Ool00`00Oomoo`0?Ool00`00Oomoo`0EOol00`00Oomoo`09Ool00`00Oomoo`07
Ool00`00Oomoo`03Ool2000017oo001oo`000goo00@007ooOol000Aoo`03001oogoo011oo`03001o
ogoo01Eoo`03001oogoo00Uoo`03001oogoo00Qoo`04001oogooOol2000>Ool001]oo`8000Yoo`80
01moo`03001oogoo00Ioo`03001oogoo00Qoo`03001oogoo00Moo`05001oogooOol00002Ool00`00
Oomoo`03Ool00`00Oomoo`0>Ool2000GOol00`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`06
Ool00`00Ool00003Ool01000Oomoo`0017oo00<007ooOol03goo0P005goo00<007ooOol02Goo00<0
07ooOol027oo00D007ooOomoo`0000moo`006goo0P002Goo00<007oo00007goo00<007ooOol01Woo
00<007ooOol027oo00<007ooOol01goo00D007ooOomoo`00009oo`03001oogoo00=oo`03001oogoo
00ioo`8001Ioo`03001oogoo00Yoo`03001oogoo00Moo`03001oogoo00Qoo`05001oogooOol00002
Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool2000FOol00`00Oomoo`0:Ool00`00Oomoo`08Ool00`00
Oomoo`0AOol001]oo`8000Uoo`03001oo`0001moo`03001oogoo00Ioo`03001oogoo00Qoo`03001o
ogoo00]oo`04001oogoo0005Ool00`00Oomoo`0>Ool00`00Ool0000EOol00`00Oomoo`0:Ool00`00
Oomoo`07Ool00`00Oomoo`0<Ool01000Oomoo`0017oo00<007ooOol03goo00<007oo00005Goo00<0
07ooOol02Woo00<007ooOol027oo00<007ooOol04Goo000KOol20009Ool00`00Ool0000OOol00`00
Oomoo`06Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool00`00Ool00005Ool00`00Oomoo`0>Ool00`00
Ool0000EOol00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`0<Ool01000Oomoo`001Goo00<0
07ooOol03Woo00<007oo00005Goo00<007ooOol02Woo00<007ooOol027oo00<007ooOol04Goo000K
Ool20009Ool00`00Ool0000OOol00`00Oomoo`06Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool00`00
Ool00005Ool00`00Oomoo`0>Ool00`00Ool0000EOol00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00
Oomoo`0<Ool01000Oomoo`001Goo00<007ooOol03Woo00<007oo00005Goo00<007ooOol02Woo00<0
07ooOol027oo00<007ooOol04Goo000KOol20009Ool00`00Ool0000OOol00`00Oomoo`06Ool00`00
Oomoo`08Ool00`00Oomoo`0<Ool00`00Ool00005Ool00`00Oomoo`0>Ool00`00Ool0000EOol00`00
Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`0<Ool01000Oomoo`001Goo00<007ooOol03Woo00<0
07oo00005Goo00<007ooOol02Woo00<007ooOol027oo00<007ooOol04Goo000KOol20009Ool00`00
Ool0000OOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`0<Ool00`00Ool00005Ool00`00
Oomoo`0>Ool00`00Ool0000EOol00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool01000
Oomoo`001Goo00<007ooOol03Woo00<007oo00005Goo00<007ooOol02Woo00<007ooOol027oo00<0
07ooOol04Goo000KOol20009Ool00`00Ool0000OOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`0<Ool00`00Ool00005Ool00`00Oomoo`0>Ool00`00Ool0000EOol00`00Oomoo`0;Ool00`00
Oomoo`06Ool00`00Oomoo`0<Ool00`00Ool00006Ool00`00Oomoo`0>Ool00`00Ool0000EOol00`00
Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`0AOol001]oo`8000Uoo`03001oo`0001moo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00aoo`03001oo`0000Eoo`03001oogoo00ioo`03001o
o`0001Eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00aoo`03001oo`0000Ioo`03001o
ogoo00ioo`03001oo`0001Eoo`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo015oo`006goo
0P002Goo00<007oo00007goo00<007ooOol01goo00<007ooOol01goo00<007ooOol037oo00<007oo
00001Goo00<007ooOol03Woo00<007oo00005Goo00<007ooOol02goo00<007ooOol01Woo00<007oo
Ool037oo00<007oo00001Woo00<007ooOol03Woo00<007oo00005Goo00<007ooOol02Woo00<007oo
Ool027oo00<007ooOol04Goo000KOol20009Ool00`00Ool0000OOol00`00Oomoo`07Ool00`00Oomo
o`07Ool00`00Oomoo`0<Ool20006Ool00`00Oomoo`0>Ool00`00Ool0000EOol00`00Oomoo`0;Ool0
0`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Ool00006Ool00`00Oomoo`0>Ool00`00Ool0000EOol0
0`00Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`0AOol001]oo`8000Uoo`03001oo`0001moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03
001oo`0001Eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00eoo`8000Ioo`03001oogoo
00ioo`03001oo`0001Eoo`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo015oo`006goo0P00
2Goo00<007oo00007goo00<007ooOol01goo00<007ooOol01goo00<007ooOol03Goo00<007ooOol0
17oo00<007ooOol03Woo00<007oo00005Goo00<007ooOol02goo00<007ooOol01Woo00<007ooOol0
3Goo0P001Woo00<007ooOol03Woo00<007oo00005Goo00<007ooOol02Woo00<007ooOol027oo00<0
07ooOol04Goo000KOol20009Ool00`00Ool0000OOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Ool0000EOol00`00Oomoo`0;Ool00`00
Oomoo`06Ool00`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`0>Ool00`00Ool0000EOol00`00
Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`0AOol001]oo`8000Uoo`03001oo`0001moo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03001o
o`0001Eoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00eoo`03001oogoo00Eoo`03001o
ogoo00ioo`03001oo`0001Eoo`03001oogoo00Yoo`03001oogoo00Moo`03001oogoo019oo`006goo
0P002Goo00<007oo00007goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol03Woo00<007oo
Ool017oo00<007ooOol03Woo00<007oo00005Goo00<007ooOol02goo00<007ooOol01Goo00<007oo
Ool03Woo00<007ooOol01Goo00<007ooOol03Woo00@007ooOol001Aoo`03001oogoo00]oo`03001o
ogoo00Ioo`03001oogoo019oo`006goo00<007oo000027oo00<007oo00007Woo00<007ooOol027oo
00<007ooOol01Woo00<007ooOol05Goo00<007ooOol03Woo00@007ooOol001Aoo`03001oogoo00]o
o`03001oogoo00Eoo`03001oogoo01Moo`03001oogoo00eoo`04001oogoo000DOol00`00Oomoo`0;
Ool00`00Oomoo`06Ool00`00Oomoo`0BOol001]oo`03001oo`0000Qoo`03001oo`0001ioo`03001o
ogoo00Qoo`03001oogoo00Ioo`03001oogoo01Eoo`03001oogoo00eoo`05001oogooOol0000DOol0
0`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`0GOol00`00Oomoo`0<Ool01@00Oomoogoo0000
57oo00<007ooOol02goo00<007ooOol01Woo00<007ooOol04Woo000KOol30008Ool00`00Ool0000N
Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`0EOol00`00Oomoo`0=Ool01@00Oomoogoo
000057oo00<007ooOol02goo00<007ooOol01Goo00<007ooOol05goo00<007ooOol037oo00D007oo
Oomoo`0001Aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo019oo`006goo00<007oo0000
27oo00<007oo00007Woo00<007ooOol027oo00<007ooOol01Woo00<007ooOol05Goo00<007ooOol0
3Goo00D007ooOomoo`0001Aoo`03001oogoo00]oo`03001oogoo00Eoo`03001oogoo01Moo`03001o
ogoo00aoo`05001oogooOol0000DOol00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0BOol0
01]oo`03001oo`0000Qoo`04001oogoo000MOol00`00Oomoo`09Ool00`00Oomoo`05Ool00`00Oomo
o`0EOol00`00Oomoo`0=Ool01@00Oomoogoo000057oo00<007ooOol037oo00<007ooOol017oo00<0
07ooOol05goo00<007ooOol037oo00D007ooOomoo`0001Aoo`03001oogoo00]oo`03001oogoo00Io
o`03001oogoo019oo`006goo00<007oo00001goo00D007ooOomoo`0001eoo`03001oogoo00Uoo`03
001oogoo00Eoo`03001oogoo01Eoo`03001oogoo00eoo`05001oogooOol0000>Ool00`00Oomoo`03
Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`0GOol00`00Oomoo`0<Ool01@00Oomoogoo
00003Woo00<007ooOol00goo00<007ooOol02goo00<007ooOol01Woo00<007ooOol04Woo000KOol0
0`00Ool00007Ool01@00Oomoogoo00007Goo00<007ooOol02Goo00<007ooOol00goo00<007oo0000
67oo00<007ooOol037oo00D007ooOomoo`0000ioo`03001oogoo009oo`03001oogoo00eoo`03001o
ogoo00=oo`8001Uoo`03001oogoo00aoo`05001oogooOol0000=Ool20004Ool00`00Oomoo`0<Ool0
0`00Oomoo`04Ool00`00Ool0000DOol001]oo`03001oo`0000Moo`05001oogooOol0000MOol00`00
Oomoo`09Ool00`00Oomoo`02Ool01000Ool0000067oo00<007ooOol037oo00D007ooOomoo`0000eo
o`8000Aoo`03001oogoo00eoo`03001oogoo009oo`03001oo`0001Uoo`03001oogoo00aoo`05001o
ogooOol0000<Ool00`00Ool00004Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool200000goo001oo`0C
Ool001]oo`03001oo`0000Moo`05001oogooOol0000MOol00`00Oomoo`09Ool00`00Oomoo`02Ool0
0`00Oomoo`0IOol00`00Oomoo`0<Ool01@00Oomoogoo000037oo00<007oo000017oo00<007ooOol0
3Goo00<007ooOol00Woo00<007ooOol06Goo00<007ooOol037oo00D007ooOomoo`0000aoo`03001o
o`0000Aoo`03001oogoo00aoo`03001oogoo00=oo`800003Ool007oo01=oo`006goo00<007oo0000
1goo00D007ooOomoo`0001eoo`03001oogoo00Uoo`05001oogooOol0000LOol00`00Oomoo`0<Ool0
1@00Oomoogoo000037oo00<007oo000017oo00<007ooOol03Goo00D007ooOomoo`0001aoo`03001o
ogoo00aoo`03001oogoo009oo`03001oogoo00Moo`80009oo`03001oogoo009oo`03001oogoo00eo
o`09001oogooOol007oo001oo`0001Aoo`000Woo0P0017oo00<007ooOol00goo0P000goo100017oo
00<007oo00001goo00D007ooOomoo`0001eoo`03001oogoo00Uoo`04001oogoo000MOol00`00Oomo
o`0<Ool01@00Oomoogoo00002Woo0P000goo00D007ooOomoo`0000moo`04001oogoo000MOol00`00
Oomoo`0<Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`03Ool01@00Oomoogoo00003goo
00@007ooOol0009oo`03001oo`0001Aoo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0002Ool00`00
Oomoo`05Ool00`00Ool00007Ool01@00Oomoogoo00007Goo00<007ooOol02Goo00@007ooOol001eo
o`03001oogoo00aoo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00=oo`05001oogooOol0
000?Ool01000Oomoo`007Goo00<007ooOol037oo00<007ooOol017oo00<007ooOol00goo00<007oo
Ool017oo00D007ooOomoo`0000moo`04001oogoo0002Ool00`00Ool0000DOol00005Ool007ooOol0
0008Ool01000Oomoo`000goo00<007ooOol017oo0`001goo00D007ooOomoo`0001eoo`03001oogoo
00Uoo`03001oo`0001ioo`03001oogoo00aoo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo
00Aoo`05001oogooOol0000?Ool00`00Ool0000NOol00`00Oomoo`0<Ool00`00Oomoo`05Ool50007
Ool01@00Oomoogoo00003goo00<007oo00000goo00<007oo000057oo00001Goo001oogoo000027oo
00@007ooOol000Aoo`03001oogoo00=oo`04001oogoo0006Ool01@00Oomoogoo00007Goo00<007oo
Ool02Goo0P007goo00<007ooOol037oo00<007ooOol017oo1P001goo00D007ooOomoo`0000moo`80
01moo`03001oogoo00aoo`03001oogoo015oo`05001oogooOol0000?Ool20004Ool00`00Ool0000D
Ool00005Ool007ooOol00008Ool01000Oomoo`001Goo00<007ooOol00Woo00@007ooOol000Ioo`05
001oogooOol0000MOol00`00Oomoo`09Ool00`00Oomoo`0NOol00`00Oomoo`0<Ool00`00Oomoo`0A
Ool01@00Oomoogoo00003goo00<007ooOol07Woo00<007ooOol037oo00<007ooOol04Goo00D007oo
Oomoo`0000moo`03001oogoo00=oo`8001Eoo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0002Ool0
1000Oomoo`0017oo00@007ooOol000Ioo`05001oogooOol0000MOol00`00Oomoo`0ZOol00`00Oomo
o`0<Ool00`00Oomoo`0AOol01@00Oomoogoo0000<Goo00<007ooOol02goo00<007ooOol04Goo00D0
07ooOomoo`0001Ioo`03001oogoo01=oo`000Woo0P002Woo0P0017oo0P001Goo00@007ooOol000Io
o`05001oogooOol0000MOol00`00Oomoo`0[Ool00`00Oomoo`0;Ool00`00Oomoo`0AOol01@00Oomo
ogoo0000<Goo00<007ooOol02goo00<007ooOol04Goo00D007ooOomoo`0001Ioo`03001oogoo01=o
o`006goo00@007ooOol000Ioo`05001oogooOol0000MOol00`00Oomoo`0[Ool00`00Oomoo`0;Ool0
0`00Oomoo`0AOol01@00Oomoogoo0000<Goo00<007ooOol02goo00<007ooOol04Goo00D007ooOomo
o`0001Ioo`03001oogoo01=oo`006goo00@007ooOol000Ioo`05001oogooOol0000LOol00`00Oomo
o`0/Ool00`00Oomoo`0;Ool00`00Oomoo`0AOol01000Oomoo`00<Woo00<007ooOol02Woo00<007oo
Ool04Woo00@007ooOol001Moo`03001oogoo01=oo`006goo00@007ooOol000Ioo`05001oogooOol0
000LOol00`00Oomoo`0/Ool00`00Oomoo`0:Ool00`00Oomoo`0BOol01000Oomoo`00<Woo00<007oo
Ool02Woo00<007ooOol04Woo00@007ooOol001Moo`03001oogoo01=oo`006goo00@007ooOol000Io
o`05001oogooOol0000LOol00`00Oomoo`0/Ool00`00Oomoo`0:Ool00`00Oomoo`0COol00`00Ool0
000bOol00`00Oomoo`0:Ool00`00Oomoo`0COol00`00Ool0000GOol00`00Oomoo`0COol001]oo`80
009oo`03001oogoo00=oo`05001oogooOol0000LOol00`00Oomoo`0/Ool00`00Oomoo`0:Ool00`00
Oomoo`0COol2000cOol00`00Oomoo`0:Ool00`00Oomoo`0COol2000HOol00`00Oomoo`0COol001]o
o`05001oogooOol00005Ool01@00Oomoogoo000077oo00<007ooOol0;7oo00<007ooOol02Woo00<0
07ooOol04goo0P00<goo00<007ooOol02Woo00<007ooOol04goo0P0067oo00<007ooOol04goo000K
Ool01@00Oomoogoo00001Goo00D007ooOomoo`0001aoo`03001oogoo02aoo`03001oogoo00Yoo`03
001oogoo01=oo`03001oogoo039oo`03001oogoo00Yoo`03001oogoo01=oo`03001oogoo02eoo`00
6goo00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo01Uoo`03001oogoo02aoo`03001o
ogoo00Yoo`03001oogoo01=oo`03001oogoo039oo`03001oogoo00Yoo`03001oogoo01=oo`03001o
ogoo02eoo`006goo00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo01Uoo`03001oogoo
02aoo`03001oogoo00Yoo`03001oogoo04Qoo`03001oogoo00Yoo`03001oogoo04=oo`006goo00D0
07ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo01Uoo`03001oogoo02aoo`03001oogoo00Yo
o`03001oogoo04Uoo`03001oogoo00Uoo`03001oogoo04=oo`006goo00D007ooOomoo`0000Aoo`03
001oogoo00=oo`03001oogoo01Uoo`03001oogoo02aoo`03001oogoo00Yoo`03001oogoo04Uoo`03
001oogoo00Uoo`03001oogoo04=oo`006goo00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001o
ogoo01Uoo`03001oogoo02aoo`03001oogoo00Yoo`03001oogoo04Uoo`03001oogoo00Uoo`03001o
ogoo04=oo`006goo00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo01Uoo`03001oogoo
02aoo`03001oogoo00Yoo`03001oogoo04Uoo`03001oogoo00Uoo`03001oogoo04=oo`006goo00D0
07ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo01Uoo`03001oogoo02eoo`03001oogoo00Uo
o`03001oogoo04Uoo`03001oogoo00Uoo`03001oogoo04=oo`006goo0P000Woo00<007ooOol00Woo
00<007ooOol00goo00<007ooOol06Goo00<007ooOol0;Goo00<007ooOol02Goo00<007ooOol0BGoo
00<007ooOol02Goo00<007ooOol0@goo000KOol01@00Oomoogoo000017oo00<007ooOol00goo00<0
07ooOol06Goo00<007ooOol0;Goo00<007ooOol02Goo00<007ooOol0BGoo00<007ooOol02Goo00<0
07ooOol0@goo000KOol00`00Oomoo`02Ool01@00Oomoogoo00001Goo00<007ooOol06Goo00<007oo
Ool0;Goo00<007ooOol02Goo00<007ooOol0BGoo00<007ooOol02Goo00<007ooOol0@goo000KOol0
0`00Oomoo`02Ool01@00Oomoogoo00001Woo00<007ooOol067oo00<007ooOol0;Goo00<007ooOol0
2Goo00<007ooOol0BGoo00<007ooOol02Goo00<007ooOol0@goo000KOol00`00Oomoo`02Ool01@00
Oomoogoo00001Woo00<007ooOol05goo00<007ooOol0;Woo00<007ooOol02Goo00<007ooOol0BGoo
00<007ooOol027oo00<007ooOol0A7oo000KOol00`00Oomoo`02Ool01@00Oomoogoo00001Woo00<0
07ooOol05goo00<007ooOol0;Woo00<007ooOol027oo00<007ooOol0BWoo00<007ooOol027oo00<0
07ooOol0A7oo000KOol00`00Oomoo`02Ool01@00Oomoogoo00001Woo00<007ooOol05goo00<007oo
Ool0;Woo00<007ooOol027oo00<007ooOol0BWoo00<007ooOol027oo00<007ooOol0A7oo000KOol0
0`00Oomoo`02Ool01@00Oomoogoo00001Woo00<007ooOol05goo00<007ooOol0;Woo00<007ooOol0
27oo00<007ooOol0Bgoo00<007ooOol01goo00<007ooOol0A7oo000KOol00`00Oomoo`02Ool01@00
Oomoogoo00001Woo00<007ooOol05goo00<007ooOol0;Woo00<007ooOol027oo00<007ooOol0Bgoo
00<007ooOol01goo00<007ooOol0A7oo000KOol00`00Oomoo`02Ool01@00Oomoogoo00001Woo00<0
07ooOol05goo00<007ooOol0;Woo00<007ooOol027oo00<007ooOol0Bgoo00<007ooOol01goo00<0
07ooOol0A7oo000KOol20003Ool01@00Oomoogoo00001Woo00<007ooOol05goo00<007ooOol0;Woo
00<007ooOol027oo00<007ooOol0Bgoo00<007ooOol01goo00<007ooOol0A7oo000KOol00`00Oomo
o`02Ool01@00Oomoogoo00001Woo00<007ooOol05goo00<007ooOol0;Woo00<007ooOol027oo00<0
07ooOol0Bgoo00<007ooOol01goo00<007ooOol0A7oo000KOol00`00Oomoo`02Ool01000Oomoo`00
1goo00<007ooOol05goo00<007ooOol0;Woo00<007ooOol027oo00<007ooOol0Bgoo00<007ooOol0
1goo00<007ooOol0A7oo000KOol00`00Oomoo`02Ool01000Oomoo`001goo00<007ooOol05goo00<0
07ooOol0;Woo00<007ooOol027oo00<007ooOol0Bgoo00<007ooOol01goo00<007ooOol0A7oo000K
Ool00`00Oomoo`02Ool01000Oomoo`001goo00<007ooOol05goo00<007ooOol0;Woo00<007ooOol0
27oo00<007ooOol0Bgoo00<007ooOol01goo00<007ooOol0A7oo000KOol00`00Oomoo`02Ool01000
Oomoo`001goo00<007ooOol05goo00<007ooOol0;Woo00<007ooOol027oo00<007ooOol0Bgoo00<0
07ooOol01goo00<007ooOol0A7oo000KOol00`00Oomoo`02Ool01000Oomoo`001goo00<007ooOol0
5goo00<007ooOol0;Woo00<007ooOol027oo00<007ooOol0Bgoo00<007ooOol01goo00<007ooOol0
A7oo000KOol00`00Oomoo`02Ool01000Oomoo`001goo00<007ooOol05goo00<007ooOol0;goo00<0
07ooOol01goo00<007ooOol0Bgoo00<007ooOol01goo00<007ooOol0A7oo0002Ool20004Ool00`00
Oomoo`03Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Ool00007Ool00`00Oomoo`0G
Ool00`00Oomoo`0_Ool00`00Oomoo`07Ool00`00Oomoo`1<Ool00`00Oomoo`06Ool00`00Oomoo`14
Ool00005Ool007ooOol00008Ool01000Oomoo`0017oo00<007ooOol00goo00<007ooOol00goo00<0
07oo00001goo00<007ooOol05goo00<007ooOol0;goo00<007ooOol01goo00<007ooOol0C7oo00<0
07ooOol01Woo00<007ooOol0A7oo00001Goo001oogoo000027oo00D007ooOol007oo00D000Aoo`80
00Aoo`03001oo`0000Qoo`03001oogoo01Ioo`03001oogoo02moo`03001oogoo00Moo`03001oogoo
04aoo`03001oogoo00Ioo`03001oogoo04Aoo`0000Eoo`00Oomoo`0000Qoo`06001oogoo001oo`00
0Woo00<007ooOol00goo00<007ooOol00goo00<007oo000027oo00<007ooOol05Goo00<007ooOol0
<7oo00<007ooOol01goo00<007ooOol0C7oo00<007ooOol01Goo00<007ooOol0AGoo00001Goo001o
ogoo000027oo00@007ooOol0009oo`03001oo`0000Eoo`03001oogoo00=oo`03001oo`0000Qoo`03
001oogoo01Eoo`03001oogoo031oo`03001oogoo00Ioo`03001oogoo04eoo`03001oogoo00Eoo`03
001oogoo04Eoo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0003Ool20005Ool00`00Oomoo`03Ool0
0`00Ool00008Ool00`00Oomoo`0EOol00`00Oomoo`0`Ool00`00Oomoo`06Ool00`00Oomoo`1=Ool0
0`00Oomoo`05Ool00`00Oomoo`15Ool0009oo`8000Yoo`8000Eoo`03001oogoo00=oo`03001oogoo
00=oo`03001oo`0000Qoo`03001oogoo01Eoo`03001oogoo031oo`03001oogoo00Ioo`03001oogoo
04ioo`03001oogoo00Aoo`03001oogoo04Eoo`006goo00<007ooOol00goo00<007oo000027oo00<0
07ooOol05Goo00<007ooOol0<7oo00<007ooOol01Woo00<007ooOol0Cgoo00<007ooOol00goo00<0
07ooOol0AGoo000KOol00`00Oomoo`03Ool00`00Ool00008Ool00`00Oomoo`0EOol00`00Oomoo`0`
Ool00`00Oomoo`06Ool00`00Oomoo`1?Ool00`00Oomoo`03Ool00`00Oomoo`15Ool001]oo`03001o
ogoo00=oo`03001oo`0000Qoo`03001oogoo01Eoo`03001oogoo035oo`8000Ioo`03001oogoo051o
o`03001oogoo009oo`03001oogoo04Eoo`006goo00<007ooOol00goo00<007oo000027oo00<007oo
Ool05Goo00<007ooOol0<goo0P0017oo00<007ooOol0DGoo0P000Woo00<007ooOol0AGoo000KOol0
0`00Oomoo`03Ool00`00Ool00008Ool00`00Oomoo`0EOol00`00Oomoo`0eOol20002Ool00`00Oomo
o`1COol30017Ool001]oo`8000Aoo`03001oo`0000Qoo`03001oogoo01Eoo`03001oogoo03Moo`<0
09moo`006goo00<007ooOol00goo00<007oo000027oo00<007ooOol05Goo00<007ooOol0fGoo000K
Ool00`00Oomoo`03Ool20009Ool00`00Oomoo`0EOol00`00Oomoo`3IOol001]oo`03001oogoo00=o
o`8000Uoo`03001oogoo01Eoo`03001oogoo0=Uoo`006goo00<007ooOol017oo00<007ooOol01goo
00<007ooOol057oo00<007ooOol0fWoo000KOol00`00Oomoo`04Ool00`00Oomoo`07Ool00`00Oomo
o`0DOol00`00Oomoo`3JOol001]oo`03001oogoo00Aoo`03001oogoo00Moo`03001oogoo01Aoo`03
001oogoo0=Yoo`006goo00<007ooOol017oo00<007ooOol01goo00<007ooOol057oo00<007ooOol0
fWoo000KOol00`00Oomoo`04Ool00`00Oomoo`07Ool00`00Oomoo`0DOol00`00Oomoo`3JOol001]o
o`03001oogoo00Aoo`03001oogoo00Moo`03001oogoo01Aoo`03001oogoo0=Yoo`006goo0P001Goo
00<007ooOol01goo00<007ooOol057oo00<007ooOol0fWoo000KOol00`00Oomoo`04Ool00`00Oomo
o`07Ool00`00Oomoo`0DOol00`00Oomoo`3JOol001]oo`03001oogoo00moo`03001oogoo019oo`03
001oogoo0=]oo`006goo00<007ooOol03goo00<007ooOol04Woo00<007ooOol0fgoo000KOol00`00
Oomoo`0?Ool00`00Oomoo`0BOol00`00Oomoo`3KOol001]oo`03001oogoo00moo`03001oogoo019o
o`03001oogoo0=]oo`006goo00<007ooOol03goo00<007ooOol04Woo00<007ooOol0fgoo000KOol0
0`00Oomoo`0?Ool00`00Oomoo`0BOol00`00Oomoo`3KOol001]oo`03001oogoo00moo`03001oogoo
019oo`03001oogoo0=]oo`006goo0P0047oo00<007ooOol04Woo00<007ooOol0fgoo000KOol00`00
Oomoo`0?Ool00`00Oomoo`0BOol00`00Oomoo`3KOol001]oo`03001oogoo00moo`03001oogoo015o
o`03001oogoo0=aoo`006goo00<007ooOol03goo00<007ooOol04Goo00<007ooOol0g7oo000KOol0
0`00Oomoo`0?Ool00`00Oomoo`0AOol00`00Oomoo`3LOol001]oo`03001oogoo00moo`03001oogoo
015oo`03001oogoo0=aoo`006goo00<007ooOol03goo00<007ooOol04Goo00<007ooOol0g7oo000K
Ool00`00Oomoo`0?Ool00`00Oomoo`0AOol00`00Oomoo`3LOol0009oo`8000Aoo`03001oogoo00=o
o`8000Aoo`8000Eoo`03001oogoo00moo`03001oogoo015oo`03001oogoo0=aoo`0000Eoo`00Oomo
o`0000Qoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol03goo00<007ooOol04Goo00<0
07ooOol0g7oo00001Goo001oogoo000027oo00@007ooOol0009oo`04001oogoo0004Ool2000@Ool0
0`00Oomoo`0@Ool00`00Oomoo`3MOol00005Ool007ooOol00008Ool01000Oomoo`000Woo0`001Goo
00<007ooOol03goo00<007ooOol047oo00<007ooOol0gGoo00001Goo001oogoo000027oo00@007oo
Ool0009oo`03001oogoo00Eoo`03001oogoo00moo`03001oogoo011oo`03001oogoo0=eoo`0000Eo
o`00Oomoo`0000Qoo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool00`00Oomoo`0@
Ool00`00Oomoo`3MOol0009oo`8000Yoo`8000Aoo`<000Aoo`03001oogoo00moo`03001oogoo011o
o`03001oogoo0=eoo`006goo00<007ooOol047oo00<007ooOol03goo00<007ooOol0gGoo000KOol0
0`00Oomoo`0@Ool00`00Oomoo`0?Ool00`00Oomoo`3MOol001]oo`03001oogoo011oo`03001oogoo
00moo`03001oogoo0=eoo`006goo00<007ooOol047oo00<007ooOol03Woo00<007ooOol0gWoo000K
Ool00`00Oomoo`0@Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`3NOol001]oo`80015o
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo0=ioo`006goo00<007ooOol047oo00<007oo
Ool01Goo0P001goo00<007ooOol0gWoo000KOol00`00Oomoo`0@Ool00`00Oomoo`04Ool00`00Ool0
0007Ool00`00Oomoo`3NOol001]oo`03001oogoo011oo`03001oogoo00Aoo`03001oo`0000Moo`03
001oogoo0=ioo`006goo00<007ooOol047oo00<007ooOol017oo00@007ooOol000Ioo`03001oogoo
0=ioo`006goo00<007ooOol047oo00<007ooOol017oo00@007ooOol000Ioo`03001oogoo0=ioo`00
6goo00<007ooOol047oo00<007ooOol00goo00D007ooOomoo`0000Ioo`03001oogoo0=ioo`006goo
00<007ooOol047oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0ggoo
000KOol00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`3OOol001]oo`03001oogoo011oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03
001oogoo0=moo`006goo0P004Goo00<007ooOol00Woo00<007ooOol017oo00D007ooOomoo`000>5o
o`006goo00<007ooOol047oo00<007ooOol00Woo00<007ooOol017oo00D007ooOomoo`000>5oo`00
6goo00<007ooOol047oo00<007ooOol00Woo00<007ooOol01Goo00@007ooOol00>5oo`006goo00<0
07ooOol047oo00<007ooOol00Woo00<007ooOol01Goo00@007ooOol00>5oo`006goo00<007ooOol0
47oo00D007ooOomoo`0000Qoo`04001oogoo003QOol001]oo`03001oogoo011oo`05001oogooOol0
0009Ool2003ROol001]oo`03001oogoo011oo`05001oogooOol00009Ool2003ROol001]oo`03001o
ogoo015oo`04001oogoo0009Ool2003ROol001]oo`03001oogoo015oo`03001oo`0000]oo`03001o
ogoo0>1oo`006goo00<007ooOol04Goo00<007oo00002goo00<007ooOol0h7oo000KOol2000BOol0
0`00Ool0003^Ool001]oo`03001oogoo015oo`03001oo`000>ioo`006goo00<007ooOol04Goo0P00
kgoo000KOol00`00Oomoo`0AOol2003_Ool001]oo`03001oogoo015oo`800>moo`006goo00<007oo
Ool04Goo0P00kgoo000KOol00`00Oomoo`0AOol00`00Oomoo`3^Ool001]oo`03001oogoo015oo`03
001oogoo0>ioo`000Woo0P0017oo00<007ooOol00goo0P0017oo0P001Goo00<007ooOol0ogoo0goo
00001Goo001oogoo000027oo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`3oOol3Ool0
0005Ool007ooOol00008Ool01000Oomoo`000Woo00@007ooOol000Aoo`800?moo`Aoo`0000Eoo`00
Oomoo`0000Qoo`04001oogoo0003Ool20005Ool00`00Oomoo`3oOol3Ool00005Ool007ooOol00008
Ool01000Oomoo`000Woo00@007ooOol00?moo`Yoo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0002
Ool01000Oomoo`00ogoo2Woo0002Ool2000:Ool20004Ool2003oOol;Ool00?moob5oo`00\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {605.938, 384.75}} -> {-1.01871, \
0.149383, 0.0099716, 0.000507693}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["High-precision comparison", "Subsubsection"],

Cell["Select the Lorenz equations.", "Text"],

Cell[BoxData[
    \(\(system\  = \ GetNDSolveProblem["\<Lorenz\>"];\)\)], "Input",
  CellLabel->"In[17]:="],

Cell[TextData[{
  "This invokes a bigfloat, or software floating-point number, embedded \
explicit Runge-Kutta method of order 9(8) [",
  ButtonBox["V78",
    ButtonData:>{"References.nb", "V78"},
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\[IndentingNewLine]\(erksol\  = \ 
          NDSolve[system, 
            Method \[Rule] {"\<ExplicitRungeKutta\>", "\<DifferenceOrder\>" \
\[Rule] 9}, WorkingPrecision \[Rule] 32];\)\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    \({9.234374`\ Second, Null}\)], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell[TextData[{
  "This invokes the ",
  StyleBox["Adams", "MR"],
  " method using a bigfloat version of LSODA. The maximum order of these \
methods is twelve."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\[IndentingNewLine]\(adamssol\  = 
          NDSolve[system, Method \[Rule] Adams, \ 
            WorkingPrecision \[Rule] 32];\)\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    \({5.408204`\ Second, Null}\)], "Output",
  CellLabel->"Out[19]="]
}, Open  ]],

Cell[TextData[{
  "This invokes the ",
  StyleBox["Extrapolation", "MR"],
  " method with ",
  StyleBox["ExplicitModifiedMidpoint", "MR"],
  " as the base integration scheme."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\[IndentingNewLine]\(extrapsol\  = \ 
          NDSolve[system, \ 
            Method \[Rule] {"\<Extrapolation\>", \ 
                Method -> "\<ExplicitModifiedMidpoint\>"}, 
            WorkingPrecision \[Rule] 32];\)\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[20]:="],

Cell[BoxData[
    \({2.007812000000001`\ Second, Null}\)], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell["\<\
As many as 14 entries in the first column of the extrapolation \
table are used, which results in a method of order 28. This means that a much \
larger step size can be taken.\
\>", "Text"],

Cell["Here are the step sizes taken by the various methods.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(methods\  = \ {"\<ExplicitRungeKutta\>", \ "\<Adams\>", \ \
"\<Extrapolation\>"};\)\), "\[IndentingNewLine]", 
    \(\(solutions\  = \ {erksol, adamssol, \ 
          extrapsol};\)\), "\[IndentingNewLine]", 
    \(MapThread[
      StepDataPlot[#2, \ PlotLabel \[Rule] #1] &, {methods\ , \ 
        solutions}]\)}], "Input",
  CellLabel->"In[21]:="],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0595372 -0.244138 145.844 [
[.17265 .03505 -9 -9 ]
[.17265 .03505 9 0 ]
[.3215 .03505 -3 -9 ]
[.3215 .03505 3 0 ]
[.47034 .03505 -9 -9 ]
[.47034 .03505 9 0 ]
[.61918 .03505 -6 -9 ]
[.61918 .03505 6 0 ]
[.76802 .03505 -12 -9 ]
[.76802 .03505 12 0 ]
[.91687 .03505 -6 -9 ]
[.91687 .03505 6 0 ]
[.01131 .19339 -30 -4.5 ]
[.01131 .19339 0 4.5 ]
[.01131 .33924 -30 -4.5 ]
[.01131 .33924 0 4.5 ]
[.01131 .48508 -30 -4.5 ]
[.01131 .48508 0 4.5 ]
[.5 .63053 -56 0 ]
[.5 .63053 56 10.125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17265 .04755 m
.17265 .0538 L
s
[(2.5)] .17265 .03505 0 1 Mshowa
.3215 .04755 m
.3215 .0538 L
s
[(5)] .3215 .03505 0 1 Mshowa
.47034 .04755 m
.47034 .0538 L
s
[(7.5)] .47034 .03505 0 1 Mshowa
.61918 .04755 m
.61918 .0538 L
s
[(10)] .61918 .03505 0 1 Mshowa
.76802 .04755 m
.76802 .0538 L
s
[(12.5)] .76802 .03505 0 1 Mshowa
.91687 .04755 m
.91687 .0538 L
s
[(15)] .91687 .03505 0 1 Mshowa
.125 Mabswid
.05358 .04755 m
.05358 .0513 L
s
.08335 .04755 m
.08335 .0513 L
s
.11312 .04755 m
.11312 .0513 L
s
.14288 .04755 m
.14288 .0513 L
s
.20242 .04755 m
.20242 .0513 L
s
.23219 .04755 m
.23219 .0513 L
s
.26196 .04755 m
.26196 .0513 L
s
.29173 .04755 m
.29173 .0513 L
s
.35126 .04755 m
.35126 .0513 L
s
.38103 .04755 m
.38103 .0513 L
s
.4108 .04755 m
.4108 .0513 L
s
.44057 .04755 m
.44057 .0513 L
s
.50011 .04755 m
.50011 .0513 L
s
.52988 .04755 m
.52988 .0513 L
s
.55964 .04755 m
.55964 .0513 L
s
.58941 .04755 m
.58941 .0513 L
s
.64895 .04755 m
.64895 .0513 L
s
.67872 .04755 m
.67872 .0513 L
s
.70849 .04755 m
.70849 .0513 L
s
.73826 .04755 m
.73826 .0513 L
s
.79779 .04755 m
.79779 .0513 L
s
.82756 .04755 m
.82756 .0513 L
s
.85733 .04755 m
.85733 .0513 L
s
.8871 .04755 m
.8871 .0513 L
s
.94664 .04755 m
.94664 .0513 L
s
.97641 .04755 m
.97641 .0513 L
s
.25 Mabswid
0 .04755 m
1 .04755 L
s
.02381 .19339 m
.03006 .19339 L
s
[(0.003)] .01131 .19339 1 0 Mshowa
.02381 .33924 m
.03006 .33924 L
s
[(0.004)] .01131 .33924 1 0 Mshowa
.02381 .48508 m
.03006 .48508 L
s
[(0.005)] .01131 .48508 1 0 Mshowa
.125 Mabswid
.02381 .07672 m
.02756 .07672 L
s
.02381 .10589 m
.02756 .10589 L
s
.02381 .13506 m
.02756 .13506 L
s
.02381 .16423 m
.02756 .16423 L
s
.02381 .22256 m
.02756 .22256 L
s
.02381 .25173 m
.02756 .25173 L
s
.02381 .2809 m
.02756 .2809 L
s
.02381 .31007 m
.02756 .31007 L
s
.02381 .36841 m
.02756 .36841 L
s
.02381 .39758 m
.02756 .39758 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45591 m
.02756 .45591 L
s
.02381 .01838 m
.02756 .01838 L
s
.02381 .51425 m
.02756 .51425 L
s
.02381 .54342 m
.02756 .54342 L
s
.02381 .57259 m
.02756 .57259 L
s
.02381 .60176 m
.02756 .60176 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -117 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(ExplicitRungeKutta) show
171.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.02381 .21955 m
.024 .06024 L
.02412 .13459 L
.02428 .09712 L
.02442 .11599 L
.02456 .10635 L
.02471 .11052 L
.02485 .10748 L
.025 .10785 L
.02514 .10642 L
.02528 .10585 L
.02543 .10486 L
.02557 .10413 L
.02571 .10334 L
.02585 .10266 L
.02599 .102 L
.02613 .10141 L
.02628 .10085 L
.02642 .10033 L
.02656 .09984 L
.0267 .09936 L
.02684 .09889 L
.02698 .0984 L
.02712 .0979 L
.02726 .09734 L
.0274 .09673 L
.02754 .09604 L
.02767 .09524 L
.02781 .09431 L
.02795 .09321 L
.02809 .09189 L
.02823 .09032 L
.02836 .08843 L
.0285 .09259 L
.02864 .0953 L
.02877 .09956 L
.02891 .10366 L
.02906 .10831 L
.0292 .11304 L
.02935 .118 L
.02949 .12305 L
.02964 .12822 L
.0298 .13345 L
.02995 .13874 L
.03011 .14408 L
.03027 .14944 L
.03043 .15482 L
.03059 .16022 L
.03075 .16561 L
.03092 .171 L
Mistroke
.03109 .17636 L
.03126 .18169 L
.03144 .18698 L
.03161 .19219 L
.03179 .19732 L
.03197 .20233 L
.03215 .20721 L
.03234 .21193 L
.03252 .21644 L
.03271 .22073 L
.0329 .22475 L
.03309 .22848 L
.03329 .2319 L
.03348 .23497 L
.03367 .23767 L
.03387 .24 L
.03407 .24196 L
.03427 .24353 L
.03447 .24474 L
.03467 .2456 L
.03487 .24612 L
.03507 .24634 L
.03527 .24628 L
.03547 .24596 L
.03567 .24543 L
.03587 .24471 L
.03607 .24383 L
.03627 .24282 L
.03646 .24171 L
.03666 .24052 L
.03686 .23927 L
.03706 .23799 L
.03725 .2367 L
.03745 .23542 L
.03765 .23417 L
.03784 .23296 L
.03804 .23181 L
.03823 .23074 L
.03842 .22976 L
.03862 .22889 L
.03881 .22816 L
.039 .22757 L
.0392 .22715 L
.03939 .22694 L
.03958 .22695 L
.03977 .22722 L
.03997 .2278 L
.04016 .22874 L
.04035 .23011 L
.04055 .23201 L
Mistroke
.04074 .23458 L
.04094 .23801 L
.04113 .24259 L
.04133 .24097 L
.04153 .2412 L
.04173 .23954 L
.04192 .23801 L
.04212 .23574 L
.04232 .23329 L
.04251 .23051 L
.04271 .2276 L
.0429 .22456 L
.04309 .2215 L
.04328 .21848 L
.04347 .21555 L
.04366 .21019 L
.04384 .20532 L
.04403 .20042 L
.04421 .19589 L
.04439 .19164 L
.04456 .18778 L
.04474 .18428 L
.04492 .1812 L
.04509 .17852 L
.04526 .17626 L
.04543 .17443 L
.0456 .17303 L
.04577 .17208 L
.04594 .17161 L
.04611 .17164 L
.04628 .1722 L
.04645 .17337 L
.04662 .1752 L
.0468 .17747 L
.04697 .17705 L
.04714 .17806 L
.04731 .17584 L
.04748 .17107 L
.04765 .16723 L
.04782 .16291 L
.04799 .15902 L
.04815 .15524 L
.04831 .15184 L
.04848 .14875 L
.04864 .14603 L
.0488 .14368 L
.04895 .14171 L
.04911 .14012 L
.04927 .13892 L
.04942 .1381 L
Mistroke
.04958 .13766 L
.04974 .13763 L
.04989 .13799 L
.05005 .13878 L
.0502 .14002 L
.05036 .14172 L
.05052 .14396 L
.05068 .14677 L
.05084 .15027 L
.051 .15456 L
.05116 .15986 L
.05133 .16646 L
.05149 .1749 L
.05166 .18 L
.05184 .1859 L
.05201 .19162 L
.05219 .19781 L
.05237 .20334 L
.05255 .20771 L
.05274 .19998 L
.05292 .1974 L
.0531 .19266 L
.05328 .18942 L
.05346 .18601 L
.05363 .18332 L
.05381 .18096 L
.05398 .17912 L
.05415 .17769 L
.05432 .1767 L
.0545 .17613 L
.05467 .17594 L
.05484 .17613 L
.05501 .17668 L
.05518 .17757 L
.05535 .17879 L
.05553 .18034 L
.0557 .18222 L
.05587 .18442 L
.05605 .18696 L
.05623 .18986 L
.0564 .19313 L
.05658 .19684 L
.05676 .20102 L
.05694 .20576 L
.05713 .21118 L
.05731 .21745 L
.0575 .22482 L
.05769 .23374 L
.05789 .24496 L
.05809 .26009 L
Mistroke
.05829 .27742 L
.05851 .26959 L
.05872 .27172 L
.05893 .26716 L
.05913 .2648 L
.05934 .2607 L
.05955 .25715 L
.05975 .25327 L
.05996 .24966 L
.06016 .24581 L
.06036 .24206 L
.06056 .23877 L
.06075 .23579 L
.06095 .23321 L
.06114 .23097 L
.06134 .22909 L
.06153 .22752 L
.06172 .22627 L
.06192 .22496 L
.06211 .2239 L
.0623 .22298 L
.06249 .22225 L
.06268 .22168 L
.06287 .22127 L
.06306 .22102 L
.06325 .22092 L
.06344 .22097 L
.06363 .22115 L
.06382 .22148 L
.06401 .22194 L
.0642 .22253 L
.06439 .22326 L
.06458 .22412 L
.06477 .22511 L
.06496 .22623 L
.06516 .22748 L
.06535 .22887 L
.06554 .23039 L
.06574 .23206 L
.06593 .23387 L
.06612 .23583 L
.06632 .23794 L
.06652 .24022 L
.06672 .24267 L
.06691 .24532 L
.06711 .24816 L
.06731 .25121 L
.06752 .25451 L
.06772 .25807 L
.06793 .26194 L
Mistroke
.06813 .26615 L
.06834 .27074 L
.06855 .27578 L
.06876 .28136 L
.06898 .28759 L
.06919 .29462 L
.06941 .30271 L
.06964 .31222 L
.06986 .32377 L
.0701 .33855 L
.07033 .35923 L
.07058 .39482 L
.07084 .60332 L
.07119 .35825 L
.07143 .42875 L
.07171 .36984 L
.07196 .37646 L
.07221 .35438 L
.07246 .34823 L
.0727 .33618 L
.07294 .32859 L
.07317 .32022 L
.0734 .31347 L
.07363 .307 L
.07385 .30133 L
.07407 .29607 L
.0743 .29131 L
.07451 .28691 L
.07473 .28286 L
.07495 .27908 L
.07516 .27556 L
.07537 .27225 L
.07558 .26912 L
.07579 .26614 L
.076 .2633 L
.07621 .26058 L
.07641 .25796 L
.07662 .25543 L
.07682 .25297 L
.07703 .25058 L
.07723 .24825 L
.07743 .24597 L
.07763 .24374 L
.07783 .24155 L
.07803 .23939 L
.07822 .23728 L
.07842 .2352 L
.07862 .23315 L
.07881 .23113 L
.079 .22916 L
Mistroke
.0792 .22721 L
.07939 .2253 L
.07958 .22343 L
.07977 .2216 L
.07996 .21982 L
.08015 .21808 L
.08034 .21639 L
.08053 .21476 L
.08072 .21318 L
.0809 .21167 L
.08109 .21023 L
.08127 .20887 L
.08146 .20759 L
.08164 .20641 L
.08183 .20533 L
.08201 .20436 L
.08219 .20352 L
.08238 .20282 L
.08256 .20228 L
.08274 .20192 L
.08292 .20176 L
.08311 .20183 L
.08329 .20217 L
.08347 .20282 L
.08365 .20385 L
.08383 .20533 L
.08402 .20738 L
.0842 .21013 L
.08439 .21384 L
.08458 .21402 L
.08476 .21341 L
.08495 .21222 L
.08514 .21048 L
.08532 .20832 L
.08551 .2058 L
.08569 .20302 L
.08587 .20004 L
.08605 .19694 L
.08623 .19379 L
.08641 .19066 L
.08659 .18759 L
.08677 .18466 L
.08694 .18006 L
.08711 .1755 L
.08729 .17112 L
.08745 .16699 L
.08762 .16316 L
.08779 .15967 L
.08795 .15653 L
.08812 .15376 L
Mistroke
.08828 .15137 L
.08844 .14938 L
.0886 .14779 L
.08876 .14661 L
.08892 .14586 L
.08908 .14557 L
.08924 .14577 L
.0894 .14651 L
.08956 .14784 L
.08972 .14781 L
.08988 .14761 L
.09004 .14765 L
.0902 .14786 L
.09036 .14359 L
.09052 .13979 L
.09067 .13563 L
.09083 .13175 L
.09098 .12799 L
.09113 .12454 L
.09128 .12138 L
.09143 .11856 L
.09158 .11607 L
.09173 .11394 L
.09187 .11215 L
.09202 .11071 L
.09216 .10963 L
.09231 .10889 L
.09245 .10851 L
.0926 .10849 L
.09274 .10884 L
.09289 .10957 L
.09303 .11071 L
.09317 .11229 L
.09332 .11435 L
.09347 .11696 L
.09361 .1202 L
.09376 .1242 L
.09391 .12916 L
.09407 .13539 L
.09422 .14344 L
.09438 .15016 L
.09454 .15537 L
.0947 .16157 L
.09487 .16768 L
.09504 .17176 L
.09521 .16943 L
.09537 .16335 L
.09554 .15949 L
.09571 .15498 L
.09587 .15129 L
Mistroke
.09603 .14777 L
.09619 .14479 L
.09635 .14218 L
.09651 .14 L
.09666 .1382 L
.09682 .13678 L
.09698 .13569 L
.09713 .13493 L
.09728 .13447 L
.09744 .13429 L
.09759 .13436 L
.09775 .13467 L
.0979 .13521 L
.09806 .13596 L
.09821 .13692 L
.09837 .13808 L
.09852 .13944 L
.09868 .14101 L
.09884 .14279 L
.099 .14479 L
.09916 .14705 L
.09931 .14959 L
.09948 .15247 L
.09964 .15574 L
.0998 .1595 L
.09997 .16421 L
.10013 .17248 L
.1003 .18105 L
.10048 .19216 L
.10065 .2059 L
.10084 .22529 L
.10103 .23992 L
.10123 .23647 L
.10142 .23915 L
.10162 .2367 L
.10182 .23487 L
.10201 .22823 L
.10221 .22409 L
.1024 .219 L
.10259 .21476 L
.10277 .2105 L
.10296 .2067 L
.10314 .20312 L
.10332 .19986 L
.10351 .19686 L
.10369 .19412 L
.10387 .19161 L
.10404 .18932 L
.10422 .18723 L
.1044 .18531 L
Mistroke
.10457 .18355 L
.10475 .18194 L
.10492 .18046 L
.10509 .17909 L
.10527 .17783 L
.10544 .17667 L
.10561 .1756 L
.10578 .1748 L
.10595 .17541 L
.10612 .17579 L
.1063 .17668 L
.10647 .17765 L
.10664 .17887 L
.10681 .18022 L
.10698 .18172 L
.10716 .18335 L
.10733 .18509 L
.10751 .18693 L
.10768 .18888 L
.10786 .19092 L
.10804 .19304 L
.10822 .19526 L
.1084 .19756 L
.10858 .19994 L
.10876 .20241 L
.10894 .20496 L
.10912 .20751 L
.10931 .20956 L
.10949 .21185 L
.10968 .21406 L
.10987 .21637 L
.11005 .21873 L
.11024 .22118 L
.11043 .22373 L
.11062 .2264 L
.11082 .2292 L
.11101 .23214 L
.1112 .23524 L
.1114 .23852 L
.1116 .242 L
.1118 .24569 L
.112 .24962 L
.1122 .25383 L
.1124 .25835 L
.11261 .26322 L
.11281 .2685 L
.11302 .2743 L
.11323 .28068 L
.11345 .28778 L
.11366 .29581 L
Mistroke
.11389 .30504 L
.11411 .31595 L
.11434 .32935 L
.11457 .34687 L
.11481 .37278 L
.11507 .42666 L
.11534 .43507 L
.11562 .39142 L
.11588 .3904 L
.11613 .37332 L
.11639 .3656 L
.11664 .35483 L
.11688 .34686 L
.11712 .33877 L
.11736 .3319 L
.11759 .32549 L
.11783 .31981 L
.11806 .31464 L
.11829 .30998 L
.11851 .30573 L
.11874 .30188 L
.11896 .29835 L
.11918 .29511 L
.1194 .29212 L
.11962 .28935 L
.11984 .28676 L
.12005 .28434 L
.12027 .28205 L
.12048 .27987 L
.1207 .2778 L
.12091 .27581 L
.12112 .27389 L
.12134 .27202 L
.12155 .2702 L
.12176 .26841 L
.12197 .26665 L
.12217 .2649 L
.12238 .26317 L
.12259 .26144 L
.1228 .25972 L
.123 .25798 L
.12321 .25624 L
.12341 .25448 L
.12361 .25271 L
.12382 .25092 L
.12402 .2491 L
.12422 .24727 L
.12442 .24541 L
.12462 .24352 L
.12482 .24161 L
Mistroke
.12502 .23967 L
.12522 .23771 L
.12541 .23572 L
.12561 .2337 L
.1258 .23166 L
.126 .2296 L
.12619 .22752 L
.12638 .22542 L
.12657 .22331 L
.12677 .22118 L
.12696 .21903 L
.12714 .21688 L
.12733 .21472 L
.12752 .21256 L
.12771 .2104 L
.12789 .20824 L
.12808 .20608 L
.12826 .20393 L
.12844 .2018 L
.12863 .19968 L
.12881 .19758 L
.12899 .1955 L
.12917 .19345 L
.12935 .19143 L
.12952 .18944 L
.1297 .18749 L
.12988 .18559 L
.13005 .18373 L
.13023 .18192 L
.1304 .18016 L
.13057 .17847 L
.13075 .17684 L
.13092 .17529 L
.13109 .17381 L
.13126 .17243 L
.13143 .17113 L
.1316 .16995 L
.13177 .16888 L
.13194 .16794 L
.13211 .16714 L
.13227 .16651 L
.13244 .16605 L
.13261 .16581 L
.13278 .1658 L
.13294 .16608 L
.13311 .16669 L
.13328 .1677 L
.13345 .16921 L
.13361 .17134 L
.13378 .1743 L
Mistroke
.13396 .17294 L
.13413 .17227 L
.1343 .17041 L
.13446 .16841 L
.13463 .16589 L
.1348 .16314 L
.13497 .16012 L
.13513 .15696 L
.1353 .15369 L
.13546 .15039 L
.13562 .14712 L
.13578 .14391 L
.13594 .14083 L
.13609 .13791 L
.13625 .13468 L
.1364 .13035 L
.13656 .12673 L
.13671 .12305 L
.13686 .11975 L
.13701 .11667 L
.13715 .11393 L
.1373 .11149 L
.13745 .10939 L
.13759 .10763 L
.13773 .10623 L
.13788 .10519 L
.13802 .10454 L
.13816 .1043 L
.1383 .1045 L
.13845 .10387 L
.13859 .10284 L
.13873 .10215 L
.13887 .10154 L
.13901 .10122 L
.13915 .10116 L
.13929 .09625 L
.13943 .09315 L
.13957 .08914 L
.13971 .08572 L
.13984 .08228 L
.13998 .0792 L
.14011 .07634 L
.14024 .07379 L
.14037 .07153 L
.1405 .06957 L
.14062 .06791 L
.14075 .06655 L
.14088 .06548 L
.14101 .06471 L
.14113 .06423 L
Mistroke
.14126 .06405 L
.14138 .06418 L
.14151 .06462 L
.14164 .0654 L
.14176 .06654 L
.14189 .06807 L
.14202 .07003 L
.14214 .07251 L
.14227 .0756 L
.1424 .07945 L
.14254 .0843 L
.14267 .0906 L
.14281 .09917 L
.14295 .10502 L
.14309 .11042 L
.14323 .11626 L
.14338 .12128 L
.14353 .11228 L
.14368 .1081 L
.14382 .10215 L
.14396 .09746 L
.1441 .09261 L
.14424 .08831 L
.14437 .08419 L
.14451 .08041 L
.14464 .07685 L
.14477 .07348 L
.1449 .07024 L
.14503 .06707 L
.14516 .06389 L
.14528 .0606 L
.14541 .05897 L
.14553 .06283 L
.14566 .06518 L
.14578 .06927 L
.14591 .07327 L
.14604 .07796 L
.14617 .08285 L
.1463 .0881 L
.14644 .09359 L
.14658 .09934 L
.14672 .10532 L
.14686 .11154 L
.14701 .11801 L
.14715 .12473 L
.1473 .13172 L
.14746 .13902 L
.14761 .14667 L
.14777 .15474 L
.14794 .16331 L
Mistroke
.1481 .17251 L
.14827 .18255 L
.14845 .19373 L
.14863 .20661 L
.14881 .22223 L
.149 .22796 L
.14919 .22301 L
.14938 .22141 L
.14957 .21686 L
.14976 .21299 L
.14995 .20841 L
.15013 .20408 L
.15032 .19971 L
.1505 .19557 L
.15068 .1916 L
.15085 .18786 L
.15103 .18435 L
.15121 .18107 L
.15138 .17801 L
.15155 .17516 L
.15172 .17251 L
.15189 .17003 L
.15206 .16772 L
.15223 .16556 L
.1524 .16353 L
.15256 .16162 L
.15273 .15981 L
.15289 .15809 L
.15306 .15646 L
.15322 .15489 L
.15339 .15337 L
.15355 .1519 L
.15371 .15047 L
.15387 .14906 L
.15403 .14766 L
.15419 .14626 L
.15435 .14486 L
.15451 .14344 L
.15467 .142 L
.15482 .14355 L
.15498 .14514 L
.15514 .14734 L
.1553 .14973 L
.15546 .1524 L
.15562 .15523 L
.15579 .1582 L
.15595 .16127 L
.15612 .16443 L
.15628 .16765 L
.15645 .17093 L
Mistroke
.15662 .17424 L
.15679 .17759 L
.15696 .18097 L
.15714 .18438 L
.15731 .18781 L
.15749 .19125 L
.15767 .19472 L
.15785 .1982 L
.15803 .2017 L
.15821 .20522 L
.15839 .20875 L
.15858 .21229 L
.15876 .21583 L
.15895 .21938 L
.15914 .22293 L
.15933 .22648 L
.15952 .23001 L
.15972 .23352 L
.15991 .237 L
.16011 .24045 L
.16031 .24384 L
.16051 .24716 L
.16071 .25041 L
.16091 .25357 L
.16111 .25661 L
.16132 .25953 L
.16152 .2623 L
.16173 .26491 L
.16194 .26734 L
.16214 .26957 L
.16235 .2716 L
.16256 .27341 L
.16278 .27499 L
.16299 .27633 L
.1632 .27743 L
.16341 .27829 L
.16363 .27891 L
.16384 .27929 L
.16405 .27944 L
.16427 .27938 L
.16448 .27911 L
.16469 .27864 L
.16491 .27799 L
.16512 .27717 L
.16533 .2762 L
.16555 .27509 L
.16576 .27385 L
.16597 .27249 L
.16618 .27103 L
.16639 .26948 L
Mistroke
.1666 .26785 L
.16681 .26615 L
.16702 .26438 L
.16723 .26257 L
.16743 .2607 L
.16764 .2588 L
.16784 .25686 L
.16805 .25489 L
.16825 .2529 L
.16845 .25088 L
.16866 .24885 L
.16886 .24681 L
.16906 .24476 L
.16926 .24271 L
.16946 .24065 L
.16965 .23859 L
.16985 .23654 L
.17005 .23449 L
.17024 .23245 L
.17044 .23043 L
.17063 .22842 L
.17082 .22643 L
.17102 .22445 L
.17121 .22251 L
.1714 .22059 L
.17159 .2187 L
.17178 .21685 L
.17197 .21503 L
.17215 .21326 L
.17234 .21154 L
.17253 .20987 L
.17271 .20826 L
.1729 .20671 L
.17308 .20524 L
.17326 .20384 L
.17345 .20252 L
.17363 .2013 L
.17381 .20018 L
.17399 .19917 L
.17417 .19829 L
.17435 .19755 L
.17453 .19697 L
.17471 .19656 L
.17489 .19636 L
.17507 .19638 L
.17525 .19668 L
.17543 .19729 L
.17561 .19826 L
.17579 .1997 L
.17598 .20169 L
Mistroke
.17616 .20439 L
.17634 .20804 L
.17652 .20756 L
.17671 .20706 L
.17689 .20563 L
.17708 .20385 L
.17726 .20157 L
.17744 .19899 L
.17762 .19614 L
.1778 .19311 L
.17798 .18996 L
.17816 .18678 L
.17833 .18361 L
.17851 .18051 L
.17868 .17755 L
.17885 .17335 L
.17902 .16871 L
.17919 .16448 L
.17936 .16036 L
.17953 .1566 L
.17969 .15313 L
.17985 .15002 L
.18001 .14727 L
.18017 .14489 L
.18033 .1429 L
.18049 .1413 L
.18065 .1401 L
.1808 .13933 L
.18096 .139 L
.18112 .13916 L
.18127 .13983 L
.18143 .14109 L
.18159 .14044 L
.18174 .14036 L
.1819 .14017 L
.18206 .14035 L
.18221 .13656 L
.18237 .1326 L
.18252 .12859 L
.18268 .1247 L
.18283 .121 L
.18297 .11756 L
.18312 .11442 L
.18327 .11161 L
.18341 .10912 L
.18356 .10698 L
.1837 .10518 L
.18384 .10372 L
.18399 .1026 L
.18413 .10182 L
Mistroke
.18427 .10139 L
.18441 .10131 L
.18455 .10158 L
.18469 .10223 L
.18483 .10327 L
.18498 .10474 L
.18512 .10667 L
.18526 .10912 L
.18541 .11217 L
.18555 .11594 L
.1857 .12062 L
.18585 .12649 L
.186 .13406 L
.18615 .14203 L
.18631 .14656 L
.18647 .15302 L
.18663 .15888 L
.1868 .16333 L
.18696 .16125 L
.18713 .15479 L
.18729 .15091 L
.18745 .1462 L
.18761 .14239 L
.18777 .13871 L
.18793 .13557 L
.18808 .13278 L
.18823 .13041 L
.18839 .1284 L
.18854 .12676 L
.18869 .12543 L
.18884 .12441 L
.18899 .12366 L
.18914 .12317 L
.18929 .1229 L
.18944 .12284 L
.18959 .12297 L
.18974 .12328 L
.18989 .12375 L
.19004 .12437 L
.19019 .12513 L
.19034 .12603 L
.19049 .12707 L
.19065 .12826 L
.1908 .12959 L
.19095 .13321 L
.1911 .13869 L
.19126 .14436 L
.19142 .151 L
.19158 .15821 L
.19174 .16629 L
Mistroke
.19191 .1753 L
.19208 .1856 L
.19226 .19774 L
.19244 .21291 L
.19263 .2341 L
.19282 .23572 L
.19302 .23673 L
.19321 .23557 L
.19341 .23377 L
.1936 .23114 L
.1938 .22822 L
.19399 .22507 L
.19418 .22188 L
.19437 .21872 L
.19456 .21567 L
.19475 .21258 L
.19494 .20959 L
.19512 .20684 L
.19531 .20428 L
.19549 .20193 L
.19567 .19978 L
.19585 .19783 L
.19603 .19605 L
.19621 .19445 L
.19639 .193 L
.19657 .1917 L
.19675 .19054 L
.19692 .18951 L
.1971 .18859 L
.19728 .18779 L
.19745 .18708 L
.19763 .18648 L
.19781 .18596 L
.19798 .18553 L
.19816 .18517 L
.19833 .18489 L
.19851 .18468 L
.19868 .18454 L
.19886 .18446 L
.19903 .18444 L
.19921 .18449 L
.19938 .18458 L
.19956 .18474 L
.19973 .18494 L
.19991 .1852 L
.20008 .18551 L
.20026 .18587 L
.20043 .18628 L
.20061 .18809 L
.20079 .18968 L
Mistroke
.20096 .19174 L
.20114 .19385 L
.20132 .1962 L
.2015 .19866 L
.20168 .20128 L
.20186 .20401 L
.20205 .20687 L
.20223 .20984 L
.20241 .21293 L
.2026 .21614 L
.20279 .21883 L
.20298 .22182 L
.20317 .22475 L
.20336 .22783 L
.20355 .23099 L
.20375 .2343 L
.20394 .23775 L
.20414 .24138 L
.20434 .2452 L
.20454 .24923 L
.20474 .25352 L
.20494 .25809 L
.20515 .26297 L
.20535 .26823 L
.20556 .27392 L
.20577 .28013 L
.20599 .28696 L
.2062 .29457 L
.20642 .30318 L
.20665 .3131 L
.20688 .32486 L
.20711 .33939 L
.20735 .35867 L
.20759 .38817 L
.20785 .4602 L
.20814 .42382 L
.20841 .406 L
.20868 .39424 L
.20894 .38264 L
.20919 .37267 L
.20944 .36337 L
.20969 .35509 L
.20994 .34758 L
.21018 .34086 L
.21042 .33482 L
.21065 .3294 L
.21089 .32453 L
.21112 .32015 L
.21135 .3162 L
.21158 .31262 L
Mistroke
.21181 .30938 L
.21203 .30642 L
.21226 .30371 L
.21248 .30122 L
.2127 .29892 L
.21292 .29678 L
.21315 .29478 L
.21337 .29291 L
.21358 .29114 L
.2138 .28945 L
.21402 .28784 L
.21424 .2863 L
.21445 .28481 L
.21467 .28336 L
.21489 .28195 L
.2151 .28056 L
.21532 .2792 L
.21553 .27784 L
.21574 .2765 L
.21595 .27516 L
.21617 .27382 L
.21638 .27247 L
.21659 .27112 L
.2168 .26975 L
.21701 .26836 L
.21722 .26695 L
.21743 .26551 L
.21763 .26406 L
.21784 .26257 L
.21805 .26105 L
.21826 .25949 L
.21846 .2579 L
.21867 .25628 L
.21887 .25461 L
.21907 .2529 L
.21928 .25116 L
.21948 .24937 L
.21968 .24754 L
.21988 .24567 L
.22008 .24376 L
.22028 .2418 L
.22048 .23981 L
.22068 .23778 L
.22087 .23571 L
.22107 .2336 L
.22126 .23146 L
.22146 .22928 L
.22165 .22708 L
.22184 .22485 L
.22203 .22259 L
Mistroke
.22223 .22031 L
.22241 .21801 L
.2226 .21569 L
.22279 .21337 L
.22298 .21103 L
.22316 .20868 L
.22335 .20633 L
.22353 .20399 L
.22372 .20164 L
.2239 .1993 L
.22408 .19697 L
.22426 .19466 L
.22444 .19236 L
.22462 .19008 L
.22479 .18782 L
.22497 .18559 L
.22515 .18339 L
.22532 .18122 L
.22549 .17909 L
.22567 .177 L
.22584 .17495 L
.22601 .17295 L
.22618 .171 L
.22635 .16911 L
.22652 .16727 L
.22669 .1655 L
.22685 .1638 L
.22702 .16217 L
.22718 .16062 L
.22735 .15916 L
.22751 .15779 L
.22768 .15653 L
.22784 .15538 L
.22801 .15436 L
.22817 .15348 L
.22833 .15275 L
.22849 .1522 L
.22865 .15185 L
.22882 .15172 L
.22898 .15187 L
.22914 .15233 L
.2293 .15317 L
.22946 .15448 L
.22963 .15639 L
.22979 .15907 L
.22995 .15723 L
.23012 .15653 L
.23028 .15446 L
.23044 .1524 L
.23061 .14977 L
Mistroke
.23077 .14696 L
.23093 .14389 L
.23109 .1407 L
.23124 .13741 L
.2314 .13409 L
.23155 .13079 L
.23171 .12757 L
.23186 .12447 L
.23201 .12153 L
.23216 .11879 L
.2323 .11516 L
.23245 .11148 L
.2326 .10803 L
.23274 .10477 L
.23288 .10178 L
.23302 .09905 L
.23316 .09662 L
.2333 .0945 L
.23344 .0927 L
.23358 .09122 L
.23372 .09009 L
.23385 .08932 L
.23399 .08893 L
.23412 .08894 L
.23426 .08738 L
.2344 .08651 L
.23453 .08547 L
.23467 .08479 L
.2348 .08427 L
.23493 .08407 L
.23507 .08078 L
.2352 .07717 L
.23533 .07363 L
.23546 .07015 L
.23559 .06686 L
.23572 .06378 L
.23584 .06096 L
.23597 .05841 L
.23609 .05613 L
.23621 .05413 L
.23633 .05241 L
.23646 .05096 L
.23658 .0498 L
.2367 .0489 L
.23682 .04828 L
.23694 .04793 L
.23705 .04786 L
.23717 .04808 L
.23729 .04859 L
.23741 .04943 L
Mistroke
.23753 .0506 L
.23765 .05216 L
.23777 .05415 L
.2379 .05665 L
.23802 .05978 L
.23814 .0637 L
.23827 .06873 L
.2384 .07539 L
.23853 .08491 L
.23866 .08881 L
.2388 .09502 L
.23893 .10026 L
.23908 .0961 L
.23921 .08868 L
.23935 .08358 L
.23948 .07776 L
.23962 .07264 L
.23974 .06753 L
.23987 .06274 L
.24 .05807 L
.24012 .05351 L
.24024 .04894 L
.24036 .04426 L
.24048 .03927 L
.24059 .04304 L
.24071 .04405 L
.24083 .04749 L
.24095 .05057 L
.24107 .05451 L
.24119 .05858 L
.24131 .06306 L
.24144 .06775 L
.24157 .07271 L
.2417 .07788 L
.24183 .08329 L
.24196 .0889 L
.2421 .09475 L
.24224 .10082 L
.24238 .10714 L
.24252 .11371 L
.24267 .12057 L
.24282 .12774 L
.24297 .13526 L
.24312 .14317 L
.24328 .15155 L
.24344 .16049 L
.24361 .17014 L
.24378 .1807 L
.24395 .19252 L
.24413 .2062 L
Mistroke
.24431 .22292 L
.2445 .21416 L
.24469 .21435 L
.24488 .20866 L
.24506 .20497 L
.24524 .19982 L
.24543 .19523 L
.24561 .19042 L
.24578 .1859 L
.24596 .18151 L
.24613 .17738 L
.2463 .17345 L
.24647 .16976 L
.24664 .16627 L
.24681 .16298 L
.24698 .15986 L
.24714 .1569 L
.24731 .15408 L
.24747 .15136 L
.24763 .14874 L
.24779 .14619 L
.24795 .14368 L
.24811 .1412 L
.24827 .13873 L
.24842 .13623 L
.24858 .13368 L
.24873 .13106 L
.24888 .13176 L
.24904 .1334 L
.24919 .13539 L
.24935 .13782 L
.2495 .1405 L
.24966 .14342 L
.24982 .14648 L
.24998 .14967 L
.25014 .15295 L
.2503 .15629 L
.25046 .15969 L
.25063 .16313 L
.25079 .16659 L
.25096 .17008 L
.25113 .17358 L
.2513 .17711 L
.25147 .18064 L
.25165 .18419 L
.25182 .18776 L
.252 .19134 L
.25218 .19493 L
.25236 .19854 L
.25254 .20217 L
Mistroke
.25272 .2058 L
.2529 .20945 L
.25309 .21311 L
.25327 .21678 L
.25346 .22046 L
.25365 .22414 L
.25384 .22782 L
.25404 .23149 L
.25423 .23514 L
.25443 .23877 L
.25462 .24236 L
.25482 .2459 L
.25502 .24938 L
.25522 .25278 L
.25543 .25609 L
.25563 .25928 L
.25584 .26233 L
.25604 .26524 L
.25625 .26797 L
.25646 .2705 L
.25667 .27282 L
.25688 .27491 L
.25709 .27676 L
.2573 .27834 L
.25752 .27967 L
.25773 .28072 L
.25795 .28149 L
.25816 .282 L
.25838 .28225 L
.25859 .28224 L
.25881 .282 L
.25902 .28152 L
.25923 .28084 L
.25945 .27996 L
.25966 .27891 L
.25988 .2777 L
.26009 .27635 L
.2603 .27488 L
.26051 .2733 L
.26072 .27163 L
.26094 .26989 L
.26115 .26808 L
.26135 .26622 L
.26156 .26432 L
.26177 .26239 L
.26198 .26044 L
.26218 .25849 L
.26239 .25652 L
.26259 .25457 L
.2628 .25262 L
Mistroke
.263 .25069 L
.2632 .24878 L
.2634 .24691 L
.2636 .24506 L
.2638 .24326 L
.264 .2415 L
.2642 .23979 L
.2644 .23813 L
.26459 .23653 L
.26479 .23501 L
.26499 .23355 L
.26518 .23218 L
.26538 .23089 L
.26557 .2297 L
.26576 .22861 L
.26596 .22764 L
.26615 .2268 L
.26634 .2261 L
.26653 .22556 L
.26672 .2252 L
.26692 .22503 L
.26711 .22509 L
.2673 .22542 L
.26749 .22604 L
.26768 .22701 L
.26787 .22841 L
.26807 .23031 L
.26826 .23286 L
.26846 .23623 L
.26865 .2407 L
.26885 .2403 L
.26905 .24026 L
.26925 .23903 L
.26944 .23754 L
.26964 .23547 L
.26984 .23312 L
.27003 .23047 L
.27022 .22765 L
.27042 .22471 L
.27061 .22173 L
.2708 .21877 L
.27099 .21591 L
.27117 .2111 L
.27136 .20607 L
.27154 .20133 L
.27173 .19678 L
.27191 .19258 L
.27208 .18873 L
.27226 .18526 L
.27244 .18219 L
Mistroke
.27261 .17953 L
.27278 .1773 L
.27296 .17549 L
.27313 .17412 L
.2733 .17321 L
.27347 .17278 L
.27364 .17285 L
.27381 .17347 L
.27398 .1747 L
.27415 .17663 L
.27432 .17854 L
.27449 .1783 L
.27467 .17924 L
.27484 .17622 L
.27501 .17177 L
.27518 .16773 L
.27535 .1635 L
.27552 .15958 L
.27568 .15585 L
.27584 .15246 L
.27601 .14941 L
.27617 .14673 L
.27633 .14442 L
.27648 .14249 L
.27664 .14095 L
.2768 .13979 L
.27696 .13902 L
.27711 .13863 L
.27727 .13864 L
.27742 .13906 L
.27758 .13991 L
.27774 .1412 L
.2779 .14298 L
.27805 .14529 L
.27821 .14819 L
.27837 .15178 L
.27853 .1562 L
.2787 .16165 L
.27886 .16845 L
.27903 .17719 L
.2792 .18152 L
.27938 .1878 L
.27955 .19335 L
.27973 .19965 L
.27991 .20491 L
.2801 .20921 L
.28028 .20051 L
.28046 .19843 L
.28064 .19349 L
.28082 .19041 L
Mistroke
.281 .187 L
.28118 .1844 L
.28135 .18208 L
.28153 .1803 L
.2817 .17893 L
.28187 .17801 L
.28204 .1775 L
.28222 .17737 L
.28239 .17763 L
.28256 .17824 L
.28273 .17919 L
.28291 .18048 L
.28308 .1821 L
.28325 .18405 L
.28343 .18633 L
.2836 .18895 L
.28378 .19194 L
.28396 .19532 L
.28414 .19914 L
.28432 .20346 L
.2845 .20836 L
.28469 .21398 L
.28487 .2205 L
.28506 .22822 L
.28526 .23761 L
.28545 .24957 L
.28565 .26608 L
.28586 .27616 L
.28607 .27128 L
.28628 .27147 L
.28649 .26755 L
.2867 .26467 L
.28691 .26072 L
.28712 .25706 L
.28732 .25324 L
.28753 .24964 L
.28773 .24618 L
.28793 .24261 L
.28813 .23945 L
.28832 .23661 L
.28852 .23415 L
.28871 .23201 L
.28891 .23022 L
.2891 .22856 L
.2893 .22705 L
.28949 .22578 L
.28968 .22468 L
.28987 .22378 L
.29006 .22306 L
.29025 .22252 L
Mistroke
.29044 .22213 L
.29063 .22191 L
.29082 .22184 L
.29101 .22192 L
.2912 .22214 L
.29139 .22251 L
.29159 .22301 L
.29178 .22365 L
.29197 .22442 L
.29216 .22532 L
.29235 .22636 L
.29254 .22753 L
.29273 .22884 L
.29293 .23028 L
.29312 .23186 L
.29332 .23358 L
.29351 .23546 L
.29371 .23748 L
.2939 .23967 L
.2941 .24203 L
.2943 .24457 L
.2945 .24731 L
.2947 .25025 L
.2949 .25342 L
.2951 .25685 L
.29531 .26057 L
.29551 .2646 L
.29572 .269 L
.29593 .27382 L
.29614 .27914 L
.29636 .28505 L
.29657 .29169 L
.29679 .29926 L
.29701 .30807 L
.29724 .31861 L
.29747 .33174 L
.2977 .34929 L
.29795 .37617 L
.2982 .43911 L
.29848 .41564 L
.29875 .39163 L
.29901 .3818 L
.29926 .36823 L
.29951 .35809 L
.29976 .3477 L
.3 .33874 L
.30024 .33031 L
.30047 .32277 L
.3007 .31584 L
.30093 .30956 L
Mistroke
.30116 .30381 L
.30138 .29854 L
.3016 .2937 L
.30182 .28923 L
.30204 .28509 L
.30226 .28124 L
.30247 .27763 L
.30268 .27424 L
.3029 .27103 L
.30311 .26798 L
.30332 .26508 L
.30352 .2623 L
.30373 .25963 L
.30394 .25705 L
.30414 .25455 L
.30434 .25212 L
.30455 .24975 L
.30475 .24744 L
.30495 .24518 L
.30515 .24297 L
.30535 .24079 L
.30555 .23866 L
.30574 .23656 L
.30594 .2345 L
.30613 .23248 L
.30633 .23049 L
.30652 .22853 L
.30672 .22662 L
.30691 .22474 L
.3071 .2229 L
.30729 .22111 L
.30748 .21937 L
.30767 .21767 L
.30786 .21603 L
.30804 .21445 L
.30823 .21294 L
.30842 .21149 L
.3086 .21012 L
.30879 .20884 L
.30898 .20765 L
.30916 .20656 L
.30934 .20558 L
.30953 .20473 L
.30971 .20402 L
.30989 .20346 L
.31008 .20308 L
.31026 .2029 L
.31044 .20295 L
.31062 .20326 L
.31081 .20388 L
Mistroke
.31099 .20487 L
.31117 .2063 L
.31136 .20827 L
.31154 .21094 L
.31173 .21452 L
.31191 .21558 L
.3121 .21472 L
.31229 .21381 L
.31248 .21206 L
.31266 .21001 L
.31285 .20753 L
.31303 .2048 L
.31322 .20184 L
.3134 .19877 L
.31358 .19563 L
.31376 .1925 L
.31394 .18943 L
.31411 .18648 L
.31429 .18212 L
.31446 .1774 L
.31463 .17305 L
.31481 .16884 L
.31497 .16498 L
.31514 .16142 L
.31531 .15824 L
.31547 .15542 L
.31563 .15298 L
.3158 .15094 L
.31596 .14929 L
.31612 .14807 L
.31628 .14727 L
.31644 .14693 L
.3166 .14707 L
.31676 .14775 L
.31692 .14902 L
.31708 .14946 L
.31724 .14905 L
.3174 .1492 L
.31756 .14934 L
.31772 .14575 L
.31788 .14165 L
.31804 .13763 L
.31819 .13365 L
.31835 .1299 L
.3185 .12639 L
.31865 .12319 L
.3188 .12032 L
.31895 .1178 L
.3191 .11562 L
.31924 .11379 L
Mistroke
.31939 .11231 L
.31954 .11119 L
.31968 .11042 L
.31983 .11 L
.31997 .10995 L
.32011 .11026 L
.32026 .11097 L
.3204 .11207 L
.32055 .11362 L
.3207 .11564 L
.32084 .11821 L
.32099 .1214 L
.32114 .12534 L
.32129 .13022 L
.32144 .13633 L
.3216 .14421 L
.32176 .15134 L
.32192 .15633 L
.32208 .16261 L
.32225 .16863 L
.32242 .17302 L
.32259 .17235 L
.32276 .16544 L
.32292 .16197 L
.32309 .15724 L
.32325 .15362 L
.32342 .15003 L
.32358 .14705 L
.32374 .14441 L
.3239 .14222 L
.32405 .14041 L
.32421 .13898 L
.32437 .1379 L
.32452 .13715 L
.32468 .13671 L
.32483 .13655 L
.32499 .13665 L
.32514 .137 L
.3253 .13759 L
.32546 .1384 L
.32561 .13942 L
.32577 .14065 L
.32593 .1421 L
.32608 .14376 L
.32624 .14564 L
.3264 .14777 L
.32656 .15016 L
.32672 .15285 L
.32688 .15589 L
.32705 .15934 L
Mistroke
.32721 .16331 L
.32738 .16793 L
.32755 .17341 L
.32772 .18223 L
.32789 .19278 L
.32807 .20665 L
.32825 .22631 L
.32844 .24036 L
.32864 .23718 L
.32884 .23974 L
.32904 .23737 L
.32923 .23276 L
.32943 .2271 L
.32962 .22218 L
.32981 .21726 L
.33 .21276 L
.33019 .20851 L
.33037 .20461 L
.33055 .201 L
.33074 .19769 L
.33092 .19466 L
.33109 .19188 L
.33127 .18933 L
.33145 .187 L
.33163 .18486 L
.3318 .1829 L
.33198 .18109 L
.33215 .17942 L
.33232 .17788 L
.33249 .17645 L
.33267 .17552 L
.33284 .17572 L
.33301 .17584 L
.33318 .17641 L
.33335 .17711 L
.33352 .17804 L
.3337 .17913 L
.33387 .18037 L
.33404 .18174 L
.33422 .18324 L
.33439 .18485 L
.33457 .18656 L
.33474 .18837 L
.33492 .19027 L
.3351 .19227 L
.33527 .19434 L
.33545 .19651 L
.33563 .19875 L
.33581 .20108 L
.33599 .2035 L
Mistroke
.33618 .206 L
.33636 .20802 L
.33655 .21015 L
.33673 .21224 L
.33692 .2144 L
.3371 .21661 L
.33729 .2189 L
.33748 .22128 L
.33767 .22377 L
.33786 .22637 L
.33805 .2291 L
.33825 .23198 L
.33844 .23502 L
.33864 .23824 L
.33883 .24165 L
.33903 .24528 L
.33923 .24915 L
.33943 .25328 L
.33964 .25772 L
.33984 .26252 L
.34005 .26772 L
.34026 .27342 L
.34047 .27969 L
.34068 .28667 L
.3409 .29455 L
.34112 .30359 L
.34134 .31425 L
.34157 .32728 L
.3418 .34421 L
.34204 .36883 L
.3423 .41706 L
.34256 .44815 L
.34285 .3881 L
.34311 .39331 L
.34337 .3728 L
.34362 .36636 L
.34387 .35467 L
.34411 .34687 L
.34435 .33846 L
.34459 .33153 L
.34483 .32495 L
.34506 .31918 L
.34529 .31388 L
.34552 .30913 L
.34574 .30479 L
.34597 .30085 L
.34619 .29725 L
.34641 .29393 L
.34663 .29087 L
.34685 .28803 L
Mistroke
.34706 .28537 L
.34728 .28288 L
.3475 .28053 L
.34771 .27829 L
.34792 .27615 L
.34814 .2741 L
.34835 .27211 L
.34856 .27018 L
.34877 .2683 L
.34898 .26645 L
.34919 .26462 L
.34939 .26282 L
.3496 .26102 L
.34981 .25923 L
.35001 .25744 L
.35022 .25564 L
.35042 .25384 L
.35062 .25202 L
.35083 .25019 L
.35103 .24834 L
.35123 .24647 L
.35143 .24458 L
.35163 .24267 L
.35183 .24074 L
.35203 .23878 L
.35222 .2368 L
.35242 .2348 L
.35261 .23277 L
.35281 .23073 L
.353 .22867 L
.3532 .22659 L
.35339 .22449 L
.35358 .22238 L
.35377 .22026 L
.35396 .21813 L
.35415 .216 L
.35434 .21386 L
.35452 .21172 L
.35471 .20958 L
.35489 .20745 L
.35508 .20533 L
.35526 .20322 L
.35544 .20113 L
.35563 .19906 L
.35581 .197 L
.35599 .19498 L
.35617 .19298 L
.35635 .19102 L
.35652 .1891 L
.3567 .18722 L
Mistroke
.35688 .18539 L
.35705 .18361 L
.35723 .18188 L
.3574 .18022 L
.35757 .17863 L
.35775 .17711 L
.35792 .17567 L
.35809 .17432 L
.35826 .17307 L
.35843 .17193 L
.3586 .17091 L
.35877 .17002 L
.35894 .16928 L
.35911 .16871 L
.35928 .16833 L
.35944 .16817 L
.35961 .16826 L
.35978 .16864 L
.35995 .16938 L
.36012 .17054 L
.36029 .17224 L
.36046 .17461 L
.36063 .17711 L
.3608 .17528 L
.36097 .17464 L
.36114 .17259 L
.36131 .17055 L
.36148 .16793 L
.36165 .16513 L
.36182 .16206 L
.36198 .15888 L
.36215 .1556 L
.36231 .15231 L
.36247 .14905 L
.36263 .14588 L
.36279 .14284 L
.36295 .13998 L
.36311 .13602 L
.36326 .13204 L
.36342 .12828 L
.36357 .12472 L
.36372 .12145 L
.36387 .11846 L
.36402 .1158 L
.36416 .11345 L
.36431 .11145 L
.36445 .1098 L
.3646 .1085 L
.36474 .10759 L
.36489 .10707 L
Mistroke
.36503 .10697 L
.36517 .10733 L
.36532 .10632 L
.36546 .10556 L
.3656 .10484 L
.36574 .10437 L
.36589 .10413 L
.36603 .10271 L
.36617 .09804 L
.36631 .09478 L
.36645 .09086 L
.36659 .08745 L
.36672 .08408 L
.36685 .08107 L
.36699 .07829 L
.36712 .07582 L
.36725 .07365 L
.36738 .07178 L
.36751 .07022 L
.36764 .06895 L
.36776 .06798 L
.36789 .06731 L
.36802 .06694 L
.36815 .06688 L
.36827 .06713 L
.3684 .0677 L
.36853 .06862 L
.36865 .06992 L
.36878 .07162 L
.36891 .0738 L
.36904 .07652 L
.36917 .07991 L
.3693 .08414 L
.36944 .08952 L
.36958 .09659 L
.36971 .10591 L
.36986 .10951 L
.37 .11611 L
.37015 .12149 L
.3703 .12388 L
.37045 .11355 L
.37059 .11025 L
.37074 .10406 L
.37088 .0997 L
.37102 .09493 L
.37116 .09085 L
.3713 .0869 L
.37143 .08333 L
.37157 .07996 L
.3717 .07681 L
Mistroke
.37183 .07379 L
.37196 .07086 L
.37209 .06794 L
.37221 .06496 L
.37234 .0618 L
.37247 .06598 L
.37259 .06808 L
.37272 .07226 L
.37285 .07622 L
.37298 .08097 L
.37311 .08589 L
.37325 .0912 L
.37338 .09675 L
.37352 .10257 L
.37366 .10862 L
.37381 .11492 L
.37396 .12147 L
.3741 .12828 L
.37426 .13538 L
.37441 .14279 L
.37457 .15058 L
.37473 .15881 L
.37489 .16759 L
.37506 .17708 L
.37523 .18752 L
.37541 .19931 L
.37559 .21316 L
.37578 .23057 L
.37597 .22545 L
.37616 .22519 L
.37636 .22082 L
.37655 .2174 L
.37673 .21289 L
.37692 .20866 L
.37711 .20426 L
.37729 .20007 L
.37747 .19601 L
.37765 .19219 L
.37783 .18859 L
.378 .18522 L
.37818 .18207 L
.37835 .17915 L
.37853 .17643 L
.3787 .1739 L
.37887 .17155 L
.37904 .16937 L
.37921 .16733 L
.37938 .16542 L
.37954 .16364 L
.37971 .16196 L
Mistroke
.37987 .16037 L
.38004 .15887 L
.3802 .15744 L
.38037 .15608 L
.38053 .15476 L
.38069 .15349 L
.38086 .15225 L
.38102 .15104 L
.38118 .14984 L
.38134 .14866 L
.3815 .14747 L
.38166 .14628 L
.38182 .14506 L
.38198 .14553 L
.38214 .14751 L
.3823 .14939 L
.38246 .15183 L
.38262 .15438 L
.38278 .15718 L
.38295 .16009 L
.38311 .16313 L
.38328 .16626 L
.38345 .16946 L
.38361 .17271 L
.38378 .17601 L
.38396 .17934 L
.38413 .18271 L
.3843 .18611 L
.38448 .18953 L
.38466 .19297 L
.38483 .19644 L
.38501 .19992 L
.3852 .20342 L
.38538 .20694 L
.38556 .21046 L
.38575 .214 L
.38594 .21755 L
.38612 .2211 L
.38631 .22464 L
.3865 .22818 L
.3867 .2317 L
.38689 .2352 L
.38709 .23866 L
.38728 .24208 L
.38748 .24544 L
.38768 .24873 L
.38788 .25194 L
.38809 .25505 L
.38829 .25804 L
.3885 .2609 L
Mistroke
.3887 .26361 L
.38891 .26615 L
.38912 .2685 L
.38933 .27066 L
.38954 .27261 L
.38975 .27434 L
.38996 .27584 L
.39017 .2771 L
.39038 .27813 L
.3906 .27891 L
.39081 .27947 L
.39102 .27979 L
.39124 .2799 L
.39145 .27979 L
.39167 .27948 L
.39188 .27899 L
.39209 .27832 L
.39231 .27749 L
.39252 .27651 L
.39273 .2754 L
.39294 .27417 L
.39316 .27283 L
.39337 .27138 L
.39358 .26986 L
.39379 .26825 L
.394 .26657 L
.39421 .26484 L
.39441 .26305 L
.39462 .26121 L
.39483 .25933 L
.39503 .25741 L
.39524 .25547 L
.39544 .2535 L
.39564 .2515 L
.39585 .24949 L
.39605 .24746 L
.39625 .24541 L
.39645 .24336 L
.39665 .2413 L
.39685 .23923 L
.39704 .23716 L
.39724 .2351 L
.39743 .23303 L
.39763 .23097 L
.39782 .22892 L
.39802 .22688 L
.39821 .22485 L
.3984 .22284 L
.39859 .22085 L
.39878 .21888 L
Mistroke
.39897 .21694 L
.39916 .21502 L
.39935 .21314 L
.39953 .2113 L
.39972 .2095 L
.3999 .20774 L
.40009 .20604 L
.40027 .20439 L
.40045 .2028 L
.40064 .20127 L
.40082 .19982 L
.401 .19846 L
.40118 .19717 L
.40136 .19599 L
.40154 .19492 L
.40172 .19396 L
.4019 .19314 L
.40208 .19247 L
.40226 .19196 L
.40243 .19165 L
.40261 .19155 L
.40279 .1917 L
.40297 .19215 L
.40315 .19293 L
.40332 .19413 L
.4035 .19584 L
.40368 .1982 L
.40386 .20139 L
.40404 .20274 L
.40423 .20159 L
.40441 .2007 L
.40459 .19884 L
.40477 .19676 L
.40495 .1942 L
.40513 .19142 L
.40531 .18841 L
.40548 .18528 L
.40566 .18207 L
.40583 .17886 L
.40601 .17571 L
.40618 .17268 L
.40635 .1698 L
.40652 .1646 L
.40668 .16063 L
.40685 .15632 L
.40701 .15255 L
.40717 .14894 L
.40734 .14574 L
.40749 .14284 L
.40765 .14033 L
Mistroke
.40781 .13818 L
.40797 .13642 L
.40812 .13505 L
.40828 .13409 L
.40843 .13356 L
.40858 .13348 L
.40874 .1339 L
.40889 .13487 L
.40905 .13467 L
.4092 .13419 L
.40936 .13399 L
.40951 .13393 L
.40967 .13288 L
.40982 .12778 L
.40997 .12441 L
.41012 .12019 L
.41027 .11658 L
.41042 .11298 L
.41056 .10978 L
.41071 .10682 L
.41085 .10422 L
.41099 .10193 L
.41113 .09999 L
.41127 .09838 L
.41141 .0971 L
.41155 .09616 L
.41169 .09555 L
.41183 .09529 L
.41197 .09536 L
.41211 .0958 L
.41225 .09661 L
.41239 .09781 L
.41253 .09945 L
.41267 .10156 L
.41281 .10422 L
.41295 .10753 L
.41309 .11161 L
.41324 .11671 L
.41339 .12318 L
.41354 .13172 L
.41369 .13744 L
.41384 .14315 L
.414 .14913 L
.41416 .15469 L
.41433 .15866 L
.41449 .14887 L
.41465 .14614 L
.41481 .14046 L
.41497 .13668 L
.41512 .13252 L
Mistroke
.41528 .12913 L
.41543 .12597 L
.41558 .12329 L
.41573 .12094 L
.41588 .11895 L
.41603 .11728 L
.41618 .11591 L
.41632 .11479 L
.41647 .11391 L
.41661 .11324 L
.41676 .11276 L
.41691 .11243 L
.41705 .11225 L
.4172 .11218 L
.41734 .11222 L
.41749 .11234 L
.41763 .11252 L
.41778 .11276 L
.41793 .11682 L
.41807 .12125 L
.41822 .1265 L
.41837 .13221 L
.41853 .13847 L
.41868 .14521 L
.41884 .15248 L
.419 .16032 L
.41917 .16886 L
.41934 .17829 L
.41951 .18894 L
.41969 .2014 L
.41987 .21688 L
.42006 .2384 L
.42025 .23349 L
.42045 .23626 L
.42064 .23305 L
.42084 .23133 L
.42103 .22792 L
.42123 .22481 L
.42142 .22129 L
.42161 .21792 L
.4218 .21457 L
.42198 .21139 L
.42217 .20836 L
.42235 .20554 L
.42254 .20292 L
.42272 .20051 L
.4229 .19829 L
.42308 .19627 L
.42326 .19444 L
.42344 .1928 L
Mistroke
.42362 .19132 L
.4238 .19 L
.42397 .18883 L
.42415 .18781 L
.42433 .18692 L
.4245 .18616 L
.42468 .18552 L
.42485 .185 L
.42503 .18458 L
.4252 .18426 L
.42538 .18405 L
.42555 .18392 L
.42573 .18389 L
.4259 .18395 L
.42608 .18409 L
.42625 .18431 L
.42643 .18461 L
.4266 .18499 L
.42678 .18545 L
.42695 .18599 L
.42713 .1866 L
.42731 .18728 L
.42748 .18804 L
.42766 .18888 L
.42783 .18978 L
.42801 .19077 L
.42819 .19182 L
.42837 .19296 L
.42855 .19417 L
.42872 .19546 L
.4289 .19682 L
.42908 .19827 L
.42926 .19979 L
.42945 .20141 L
.42963 .2031 L
.42981 .20488 L
.42999 .20676 L
.43018 .20872 L
.43036 .21078 L
.43055 .21294 L
.43074 .2152 L
.43092 .21756 L
.43111 .22003 L
.4313 .22262 L
.43149 .22532 L
.43168 .22815 L
.43188 .23112 L
.43207 .23421 L
.43226 .23746 L
.43246 .24086 L
Mistroke
.43266 .24442 L
.43286 .24816 L
.43306 .25209 L
.43326 .25623 L
.43347 .26058 L
.43367 .26518 L
.43388 .27005 L
.43409 .27522 L
.4343 .28072 L
.43452 .2866 L
.43473 .29292 L
.43495 .29974 L
.43517 .30716 L
.4354 .31531 L
.43563 .32437 L
.43586 .33457 L
.4361 .34631 L
.43634 .36023 L
.43658 .37749 L
.43684 .40063 L
.4371 .4373 L
.43738 .55542 L
.43771 .45297 L
.43799 .45831 L
.43828 .43517 L
.43855 .42788 L
.43883 .41543 L
.4391 .40718 L
.43936 .39855 L
.43963 .39155 L
.43989 .38508 L
.44014 .37953 L
.4404 .37456 L
.44065 .37022 L
.4409 .36636 L
.44115 .36296 L
.4414 .35993 L
.44164 .35723 L
.44189 .3548 L
.44213 .35262 L
.44238 .35063 L
.44262 .34882 L
.44286 .34715 L
.4431 .34559 L
.44334 .34414 L
.44359 .34277 L
.44382 .34147 L
.44406 .34022 L
.4443 .33902 L
.44454 .33785 L
Mistroke
.44478 .33671 L
.44502 .33558 L
.44525 .33447 L
.44549 .33337 L
.44572 .33228 L
.44596 .33119 L
.44619 .3301 L
.44643 .32901 L
.44666 .32792 L
.4469 .32682 L
.44713 .32572 L
.44736 .32462 L
.44759 .3235 L
.44783 .32239 L
.44806 .32127 L
.44829 .32014 L
.44852 .31901 L
.44875 .31787 L
.44898 .31673 L
.44921 .31558 L
.44943 .31443 L
.44966 .31327 L
.44989 .31211 L
.45012 .31094 L
.45034 .30976 L
.45057 .30858 L
.4508 .30738 L
.45102 .30618 L
.45125 .30497 L
.45147 .30375 L
.45169 .30252 L
.45192 .30127 L
.45214 .3 L
.45236 .29872 L
.45258 .29742 L
.4528 .29609 L
.45302 .29475 L
.45324 .29337 L
.45346 .29197 L
.45368 .29054 L
.4539 .28907 L
.45412 .28757 L
.45434 .28602 L
.45455 .28444 L
.45477 .28281 L
.45498 .28114 L
.4552 .27941 L
.45541 .27763 L
.45562 .27581 L
.45584 .27392 L
Mistroke
.45605 .27198 L
.45626 .26998 L
.45647 .26793 L
.45668 .26581 L
.45689 .26363 L
.45709 .2614 L
.4573 .25911 L
.4575 .25676 L
.45771 .25435 L
.45791 .25189 L
.45812 .24938 L
.45832 .24682 L
.45852 .24421 L
.45872 .24156 L
.45891 .23887 L
.45911 .23614 L
.45931 .23338 L
.4595 .23059 L
.4597 .22778 L
.45989 .22494 L
.46008 .22209 L
.46027 .21923 L
.46046 .21636 L
.46065 .21348 L
.46084 .2106 L
.46102 .20773 L
.46121 .20486 L
.46139 .202 L
.46157 .19916 L
.46175 .19633 L
.46193 .19352 L
.46211 .19074 L
.46229 .18798 L
.46246 .18525 L
.46264 .18255 L
.46281 .17988 L
.46299 .17725 L
.46316 .17466 L
.46333 .17211 L
.4635 .1696 L
.46367 .16713 L
.46384 .16471 L
.464 .16234 L
.46417 .16002 L
.46433 .15775 L
.4645 .15553 L
.46466 .15337 L
.46482 .15128 L
.46498 .14924 L
.46515 .14727 L
Mistroke
.46531 .14536 L
.46546 .14353 L
.46562 .14177 L
.46578 .14009 L
.46594 .1385 L
.46609 .137 L
.46625 .13559 L
.4664 .1343 L
.46656 .13311 L
.46671 .13205 L
.46687 .13114 L
.46702 .13037 L
.46717 .12979 L
.46732 .1294 L
.46748 .12924 L
.46763 .12934 L
.46778 .12977 L
.46793 .13058 L
.46809 .13187 L
.46824 .13378 L
.4684 .13352 L
.46855 .13208 L
.4687 .13044 L
.46886 .12824 L
.46901 .12576 L
.46916 .12296 L
.46931 .11996 L
.46946 .1168 L
.4696 .11354 L
.46975 .11023 L
.4699 .10693 L
.47004 .10368 L
.47018 .10053 L
.47032 .09751 L
.47046 .09466 L
.4706 .09201 L
.47074 .08961 L
.47087 .08591 L
.47101 .08297 L
.47114 .0799 L
.47127 .07719 L
.4714 .07465 L
.47153 .07241 L
.47166 .07042 L
.47179 .06872 L
.47192 .06732 L
.47205 .06623 L
.47217 .06547 L
.4723 .06497 L
.47243 .06301 L
Mistroke
.47255 .06188 L
.47268 .06053 L
.4728 .05956 L
.47293 .05873 L
.47305 .05819 L
.47317 .05792 L
.4733 .05463 L
.47342 .05135 L
.47354 .04799 L
.47366 .04477 L
.47378 .04169 L
.47389 .03881 L
.47401 .03616 L
.47412 .03375 L
.47424 .03159 L
.47435 .02968 L
.47446 .02802 L
.47457 .0266 L
.47468 .02543 L
.47479 .02449 L
.4749 .0238 L
.47501 .02334 L
.47512 .02313 L
.47523 .02316 L
.47534 .02345 L
.47545 .024 L
.47556 .02485 L
.47567 .02601 L
.47578 .02752 L
.47589 .02945 L
.476 .03187 L
.47611 .03493 L
.47623 .03884 L
.47634 .04397 L
.47646 .05113 L
.47658 .06057 L
.4767 .06369 L
.47683 .06999 L
.47696 .06664 L
.47708 .05737 L
.47721 .05193 L
.47733 .04496 L
.47745 .03882 L
.47756 .03228 L
.47767 .02574 L
.47779 .01871 L
.47789 .01917 L
.478 .0199 L
.47811 .02163 L
.47822 .02377 L
Mistroke
.47833 .02643 L
.47844 .02942 L
.47855 .03274 L
.47866 .03631 L
.47878 .04013 L
.47889 .04416 L
.47901 .04841 L
.47913 .05285 L
.47925 .0575 L
.47937 .06236 L
.4795 .06744 L
.47962 .07275 L
.47975 .07829 L
.47989 .0841 L
.48002 .09018 L
.48016 .09657 L
.4803 .10328 L
.48044 .11037 L
.48058 .11786 L
.48073 .12582 L
.48088 .13432 L
.48104 .14346 L
.48119 .15339 L
.48136 .16432 L
.48152 .17659 L
.48169 .1908 L
.48187 .19775 L
.48205 .19261 L
.48223 .19122 L
.48241 .18649 L
.48258 .18249 L
.48276 .17764 L
.48293 .17301 L
.4831 .16826 L
.48327 .16368 L
.48344 .15919 L
.4836 .15487 L
.48376 .15068 L
.48392 .14663 L
.48408 .1427 L
.48424 .13884 L
.4844 .13503 L
.48455 .13122 L
.48471 .12738 L
.48486 .12343 L
.48501 .11933 L
.48516 .11843 L
.4853 .12057 L
.48545 .12227 L
.4856 .125 L
Mistroke
.48575 .12782 L
.48591 .13106 L
.48606 .13443 L
.48621 .13799 L
.48637 .14164 L
.48653 .14539 L
.48669 .14921 L
.48685 .15307 L
.48701 .15697 L
.48717 .16089 L
.48734 .16485 L
.4875 .16882 L
.48767 .17282 L
.48784 .17684 L
.48801 .18087 L
.48819 .18492 L
.48836 .189 L
.48854 .1931 L
.48872 .19721 L
.4889 .20136 L
.48908 .20553 L
.48926 .20972 L
.48945 .21394 L
.48964 .21818 L
.48983 .22245 L
.49002 .22674 L
.49021 .23105 L
.4904 .23538 L
.4906 .23972 L
.4908 .24407 L
.49099 .24841 L
.4912 .25274 L
.4914 .25704 L
.4916 .26131 L
.49181 .26552 L
.49202 .26965 L
.49223 .27369 L
.49244 .2776 L
.49265 .28136 L
.49287 .28495 L
.49308 .28833 L
.4933 .29147 L
.49352 .29436 L
.49374 .29695 L
.49396 .29925 L
.49418 .30122 L
.4944 .30286 L
.49463 .30416 L
.49485 .30513 L
.49507 .30578 L
Mistroke
.4953 .30611 L
.49552 .30615 L
.49575 .30593 L
.49597 .30546 L
.4962 .30477 L
.49642 .3039 L
.49665 .30287 L
.49687 .3017 L
.49709 .30043 L
.49731 .29908 L
.49754 .29768 L
.49776 .29625 L
.49798 .29481 L
.4982 .29337 L
.49842 .29197 L
.49864 .29061 L
.49885 .28932 L
.49907 .28811 L
.49929 .28699 L
.49951 .28598 L
.49972 .2851 L
.49994 .28436 L
.50015 .28379 L
.50037 .28339 L
.50058 .2832 L
.5008 .28325 L
.50102 .28355 L
.50123 .28414 L
.50145 .28508 L
.50166 .28642 L
.50188 .28823 L
.5021 .2906 L
.50231 .29367 L
.50253 .29762 L
.50276 .30273 L
.50298 .30648 L
.5032 .30599 L
.50343 .30647 L
.50365 .30549 L
.50388 .30446 L
.5041 .30282 L
.50432 .30099 L
.50455 .2989 L
.50477 .29671 L
.50499 .29446 L
.50521 .29224 L
.50543 .2875 L
.50565 .2813 L
.50586 .27589 L
.50607 .27041 L
Mistroke
.50628 .26544 L
.50649 .26079 L
.5067 .25662 L
.5069 .2529 L
.5071 .24967 L
.5073 .24692 L
.50751 .24467 L
.5077 .24292 L
.5079 .24168 L
.5081 .24096 L
.5083 .2408 L
.5085 .24122 L
.5087 .24226 L
.50889 .244 L
.50909 .24652 L
.50929 .24995 L
.5095 .25449 L
.5097 .25472 L
.5099 .24973 L
.5101 .24653 L
.51031 .24211 L
.5105 .23827 L
.5107 .23434 L
.5109 .23083 L
.51109 .22758 L
.51128 .22475 L
.51147 .22232 L
.51166 .22032 L
.51185 .21875 L
.51204 .21764 L
.51223 .21699 L
.51242 .2168 L
.51261 .2171 L
.5128 .21789 L
.51298 .21922 L
.51317 .2211 L
.51336 .22359 L
.51355 .22675 L
.51375 .23067 L
.51394 .23548 L
.51414 .24136 L
.51433 .24859 L
.51454 .25212 L
.51474 .25681 L
.51494 .26088 L
.51515 .26533 L
.51536 .26972 L
.51557 .2743 L
.51578 .27894 L
.51599 .28369 L
Mistroke
.51621 .2885 L
.51642 .28502 L
.51664 .2831 L
.51686 .2804 L
.51707 .27833 L
.51728 .27639 L
.5175 .27496 L
.51771 .27391 L
.51792 .27337 L
.51813 .2733 L
.51834 .27374 L
.51855 .27467 L
.51877 .27612 L
.51898 .2781 L
.51919 .28063 L
.5194 .28375 L
.51962 .2875 L
.51984 .29196 L
.52006 .29724 L
.52028 .30349 L
.5205 .31095 L
.52073 .32001 L
.52096 .33131 L
.52119 .3461 L
.52143 .34379 L
.52167 .34065 L
.52191 .33629 L
.52215 .33156 L
.52238 .32655 L
.52262 .32156 L
.52285 .31668 L
.52308 .31204 L
.5233 .30769 L
.52353 .30366 L
.52375 .29997 L
.52398 .29662 L
.5242 .29362 L
.52442 .29096 L
.52463 .28862 L
.52485 .28659 L
.52507 .28486 L
.52528 .28342 L
.5255 .28225 L
.52571 .28135 L
.52593 .2807 L
.52614 .2803 L
.52636 .28014 L
.52657 .2802 L
.52679 .2805 L
.527 .28102 L
Mistroke
.52721 .28177 L
.52743 .28275 L
.52764 .28396 L
.52786 .2854 L
.52808 .28709 L
.52829 .28904 L
.52851 .29126 L
.52873 .29378 L
.52895 .29662 L
.52917 .29983 L
.52939 .30343 L
.52961 .30749 L
.52984 .31208 L
.53007 .3173 L
.5303 .3233 L
.53053 .33027 L
.53076 .33852 L
.531 .34856 L
.53124 .36127 L
.53149 .3785 L
.53174 .4052 L
.53201 .46731 L
.5323 .44819 L
.53258 .41875 L
.53285 .40917 L
.53312 .39343 L
.53338 .38247 L
.53363 .37076 L
.53389 .36088 L
.53413 .3515 L
.53438 .34317 L
.53462 .33552 L
.53485 .32862 L
.53509 .32234 L
.53532 .31664 L
.53555 .31145 L
.53577 .30673 L
.536 .30241 L
.53622 .29846 L
.53644 .29486 L
.53666 .29155 L
.53688 .28853 L
.5371 .28576 L
.53731 .28323 L
.53753 .28092 L
.53774 .27883 L
.53796 .27694 L
.53817 .27525 L
.53838 .27376 L
.53859 .27246 L
Mistroke
.5388 .27136 L
.53902 .27047 L
.53923 .26979 L
.53944 .26934 L
.53964 .26912 L
.53985 .26918 L
.54006 .26952 L
.54027 .27019 L
.54048 .27122 L
.54069 .27269 L
.5409 .27467 L
.54112 .27726 L
.54133 .28061 L
.54154 .28495 L
.54176 .29061 L
.54198 .2904 L
.5422 .29112 L
.54241 .29033 L
.54263 .28942 L
.54285 .28786 L
.54307 .28607 L
.54328 .28397 L
.5435 .28172 L
.54371 .27938 L
.54393 .27703 L
.54414 .27473 L
.54435 .26872 L
.54456 .26349 L
.54477 .25804 L
.54497 .25306 L
.54518 .24836 L
.54538 .2441 L
.54558 .24026 L
.54578 .2369 L
.54597 .23399 L
.54617 .23157 L
.54636 .22964 L
.54655 .2282 L
.54675 .22727 L
.54694 .22688 L
.54713 .22704 L
.54732 .22781 L
.54752 .22924 L
.54771 .23141 L
.5479 .23445 L
.5481 .23852 L
.5483 .24184 L
.5485 .23528 L
.54869 .23272 L
.54889 .22779 L
Mistroke
.54908 .22396 L
.54927 .21976 L
.54946 .21609 L
.54965 .21263 L
.54983 .2096 L
.55002 .20694 L
.5502 .20471 L
.55039 .20291 L
.55057 .20154 L
.55075 .20062 L
.55093 .20015 L
.55111 .20015 L
.55129 .20061 L
.55148 .20157 L
.55166 .20305 L
.55184 .20508 L
.55202 .20772 L
.55221 .21104 L
.55239 .21514 L
.55258 .22015 L
.55277 .22629 L
.55296 .23389 L
.55316 .23769 L
.55336 .2428 L
.55355 .24727 L
.55375 .25219 L
.55396 .25706 L
.55416 .26216 L
.55437 .26735 L
.55458 .27267 L
.55479 .26953 L
.555 .26681 L
.55521 .26387 L
.55541 .2613 L
.55562 .25899 L
.55583 .25713 L
.55603 .25569 L
.55623 .25473 L
.55644 .25425 L
.55664 .25425 L
.55684 .25473 L
.55705 .25569 L
.55725 .25713 L
.55746 .25906 L
.55766 .2615 L
.55787 .26447 L
.55808 .268 L
.55829 .27217 L
.5585 .27704 L
.55871 .28275 L
Mistroke
.55892 .28947 L
.55914 .2975 L
.55936 .30728 L
.55959 .31964 L
.55982 .33628 L
.56006 .32808 L
.56029 .32781 L
.56052 .32212 L
.56075 .3182 L
.56098 .31299 L
.56121 .30832 L
.56144 .30352 L
.56166 .29908 L
.56188 .29485 L
.5621 .29097 L
.56232 .28741 L
.56254 .28418 L
.56275 .28128 L
.56297 .27871 L
.56318 .27644 L
.56339 .27448 L
.5636 .2728 L
.56382 .27139 L
.56403 .27024 L
.56424 .26934 L
.56445 .26868 L
.56466 .26826 L
.56486 .26805 L
.56507 .26806 L
.56528 .26828 L
.56549 .26871 L
.5657 .26934 L
.56591 .27018 L
.56612 .27123 L
.56633 .27249 L
.56654 .27396 L
.56675 .27565 L
.56697 .27757 L
.56718 .27974 L
.56739 .28217 L
.56761 .28489 L
.56782 .28793 L
.56804 .29131 L
.56826 .29508 L
.56848 .2993 L
.5687 .30405 L
.56893 .30942 L
.56915 .31555 L
.56938 .32266 L
.56961 .33106 L
Mistroke
.56985 .34126 L
.57008 .35417 L
.57033 .37172 L
.57058 .39919 L
.57084 .46669 L
.57113 .43274 L
.57141 .41265 L
.57168 .39937 L
.57194 .38584 L
.5722 .3742 L
.57245 .36316 L
.5727 .35326 L
.57294 .34416 L
.57318 .33593 L
.57342 .32842 L
.57365 .32161 L
.57388 .3154 L
.57411 .30974 L
.57434 .30457 L
.57456 .29984 L
.57478 .2955 L
.575 .2915 L
.57522 .28782 L
.57544 .28441 L
.57566 .28126 L
.57587 .27835 L
.57608 .27564 L
.5763 .27314 L
.57651 .27082 L
.57672 .26867 L
.57693 .2667 L
.57713 .26488 L
.57734 .26322 L
.57755 .26173 L
.57776 .26039 L
.57796 .25921 L
.57817 .2582 L
.57837 .25737 L
.57858 .25673 L
.57878 .25628 L
.57899 .25606 L
.57919 .25607 L
.57939 .25635 L
.5796 .25693 L
.5798 .25785 L
.58001 .25918 L
.58021 .26099 L
.58042 .26337 L
.58063 .26646 L
.58084 .27048 L
Mistroke
.58105 .27573 L
.58126 .27598 L
.58147 .27632 L
.58168 .27556 L
.5819 .27446 L
.58211 .2728 L
.58232 .27084 L
.58253 .26858 L
.58274 .26616 L
.58295 .26362 L
.58315 .26106 L
.58336 .25853 L
.58356 .25414 L
.58377 .24832 L
.58397 .24331 L
.58417 .23821 L
.58436 .2336 L
.58456 .22929 L
.58475 .22545 L
.58494 .22201 L
.58513 .21904 L
.58532 .21652 L
.58551 .21448 L
.5857 .21291 L
.58589 .21183 L
.58607 .21126 L
.58626 .21123 L
.58644 .21177 L
.58663 .21294 L
.58682 .21481 L
.587 .21749 L
.58719 .22114 L
.58738 .22358 L
.58757 .22024 L
.58776 .21617 L
.58795 .21196 L
.58814 .2077 L
.58832 .20359 L
.5885 .19972 L
.58869 .19616 L
.58887 .19296 L
.58904 .19015 L
.58922 .18774 L
.5894 .18575 L
.58957 .18418 L
.58975 .18303 L
.58992 .18232 L
.5901 .18204 L
.59027 .18221 L
.59044 .18285 L
Mistroke
.59062 .18396 L
.59079 .18559 L
.59097 .18777 L
.59114 .19057 L
.59132 .19404 L
.5915 .19832 L
.59168 .20356 L
.59186 .21 L
.59205 .21804 L
.59224 .22191 L
.59243 .22753 L
.59262 .23236 L
.59282 .23778 L
.59301 .24316 L
.59321 .24886 L
.59341 .25468 L
.59362 .25211 L
.59382 .24842 L
.59402 .24532 L
.59422 .24221 L
.59442 .23957 L
.59462 .23727 L
.59481 .23546 L
.59501 .2341 L
.5952 .23323 L
.5954 .23282 L
.59559 .23287 L
.59579 .23338 L
.59598 .23434 L
.59618 .23574 L
.59637 .23759 L
.59657 .2399 L
.59677 .24267 L
.59697 .24594 L
.59717 .24975 L
.59737 .25416 L
.59757 .25926 L
.59778 .26519 L
.59799 .27213 L
.5982 .2804 L
.59841 .29051 L
.59863 .30338 L
.59885 .32102 L
.59908 .31279 L
.59931 .31312 L
.59954 .30764 L
.59976 .30407 L
.59999 .29906 L
.60021 .29462 L
.60043 .28999 L
Mistroke
.60065 .28571 L
.60086 .28161 L
.60108 .27784 L
.60129 .27436 L
.6015 .27121 L
.60171 .26836 L
.60192 .26583 L
.60213 .26359 L
.60234 .26163 L
.60254 .25995 L
.60275 .25853 L
.60295 .25735 L
.60316 .25641 L
.60336 .2557 L
.60357 .2552 L
.60377 .25491 L
.60398 .25482 L
.60418 .25492 L
.60438 .25522 L
.60459 .2557 L
.60479 .25636 L
.60499 .25721 L
.6052 .25825 L
.6054 .25947 L
.60561 .26088 L
.60582 .26248 L
.60602 .26428 L
.60623 .2663 L
.60644 .26853 L
.60665 .271 L
.60686 .27373 L
.60707 .27675 L
.60728 .28009 L
.6075 .28377 L
.60771 .28785 L
.60793 .29239 L
.60815 .29747 L
.60837 .3032 L
.60859 .30975 L
.60882 .31735 L
.60905 .32637 L
.60928 .3374 L
.60952 .35159 L
.60976 .37151 L
.61001 .4054 L
.61028 .58735 L
.61062 .37771 L
.61087 .43469 L
.61115 .38198 L
.6114 .38521 L
Mistroke
.61166 .36412 L
.61191 .3568 L
.61215 .34458 L
.6124 .33634 L
.61263 .32759 L
.61287 .32035 L
.6131 .31348 L
.61332 .30741 L
.61355 .30181 L
.61377 .29674 L
.61399 .29207 L
.61421 .28779 L
.61443 .28382 L
.61464 .28016 L
.61486 .27675 L
.61507 .27357 L
.61528 .27059 L
.61549 .26781 L
.6157 .26519 L
.61591 .26273 L
.61612 .26042 L
.61632 .25824 L
.61653 .25619 L
.61673 .25427 L
.61693 .25247 L
.61714 .2508 L
.61734 .24924 L
.61754 .24781 L
.61774 .2465 L
.61794 .24532 L
.61814 .24428 L
.61834 .24339 L
.61854 .24266 L
.61874 .24209 L
.61894 .24172 L
.61914 .24154 L
.61933 .2416 L
.61953 .24192 L
.61973 .24254 L
.61993 .2435 L
.62013 .24486 L
.62033 .24672 L
.62053 .24917 L
.62073 .25237 L
.62093 .25656 L
.62114 .26043 L
.62134 .25934 L
.62155 .25958 L
.62175 .25818 L
.62196 .2568 L
Mistroke
.62216 .25474 L
.62237 .25249 L
.62257 .24995 L
.62277 .24728 L
.62297 .24451 L
.62317 .24176 L
.62337 .23906 L
.62357 .23442 L
.62376 .22897 L
.62396 .22407 L
.62415 .21923 L
.62434 .2148 L
.62452 .2107 L
.62471 .20703 L
.62489 .20376 L
.62508 .20094 L
.62526 .19855 L
.62544 .19661 L
.62562 .19514 L
.6258 .19414 L
.62598 .19364 L
.62616 .19366 L
.62633 .19425 L
.62651 .19545 L
.62669 .19735 L
.62687 .20007 L
.62705 .20252 L
.62724 .20289 L
.62742 .20046 L
.6276 .19576 L
.62778 .19179 L
.62796 .18741 L
.62813 .18341 L
.62831 .17955 L
.62848 .17607 L
.62865 .17291 L
.62882 .17015 L
.62899 .16777 L
.62916 .1658 L
.62933 .16423 L
.62949 .16308 L
.62966 .16233 L
.62983 .162 L
.62999 .16209 L
.63016 .16262 L
.63032 .16361 L
.63049 .16508 L
.63066 .16707 L
.63083 .16963 L
.63099 .17284 L
Mistroke
.63117 .1768 L
.63134 .18165 L
.63151 .18762 L
.63169 .19507 L
.63187 .20177 L
.63205 .20645 L
.63223 .21225 L
.63242 .21771 L
.63261 .22367 L
.6328 .22976 L
.63299 .23533 L
.63319 .22864 L
.63338 .22621 L
.63357 .22193 L
.63376 .21895 L
.63395 .21586 L
.63414 .21345 L
.63433 .21139 L
.63451 .20986 L
.6347 .20877 L
.63488 .20815 L
.63507 .20796 L
.63525 .2082 L
.63544 .20886 L
.63562 .20992 L
.63581 .21138 L
.63599 .21324 L
.63618 .21549 L
.63637 .21816 L
.63656 .22125 L
.63675 .22481 L
.63694 .22887 L
.63713 .23352 L
.63733 .23885 L
.63752 .245 L
.63772 .2522 L
.63792 .2608 L
.63813 .27138 L
.63834 .28511 L
.63856 .30423 L
.63878 .29406 L
.639 .29598 L
.63922 .29031 L
.63944 .28738 L
.63966 .28256 L
.63987 .27848 L
.64008 .27409 L
.6403 .27005 L
.64051 .26615 L
.64071 .26256 L
Mistroke
.64092 .25924 L
.64113 .25622 L
.64133 .25348 L
.64153 .25103 L
.64174 .24886 L
.64194 .24695 L
.64214 .2453 L
.64234 .24389 L
.64254 .24271 L
.64274 .24175 L
.64293 .241 L
.64313 .24045 L
.64333 .2401 L
.64353 .23992 L
.64373 .23992 L
.64392 .2401 L
.64412 .24044 L
.64432 .24095 L
.64452 .24162 L
.64471 .24245 L
.64491 .24344 L
.64511 .24459 L
.64531 .2459 L
.64551 .24738 L
.64571 .24902 L
.64591 .25085 L
.64612 .25285 L
.64632 .25505 L
.64652 .25745 L
.64673 .26007 L
.64693 .26293 L
.64714 .26604 L
.64735 .26946 L
.64756 .2732 L
.64777 .2773 L
.64798 .28182 L
.6482 .28684 L
.64841 .29245 L
.64863 .29879 L
.64885 .30605 L
.64908 .31452 L
.64931 .3247 L
.64954 .33741 L
.64978 .3544 L
.65002 .38026 L
.65028 .43809 L
.65055 .42816 L
.65083 .39515 L
.65109 .38851 L
.65135 .37264 L
Mistroke
.6516 .36289 L
.65185 .35163 L
.65209 .34244 L
.65233 .33351 L
.65257 .32564 L
.6528 .31833 L
.65303 .31173 L
.65326 .30567 L
.65348 .30013 L
.6537 .29503 L
.65392 .29033 L
.65414 .28597 L
.65436 .28193 L
.65457 .27816 L
.65478 .27462 L
.655 .2713 L
.65521 .26816 L
.65542 .26519 L
.65562 .26237 L
.65583 .25968 L
.65604 .25712 L
.65624 .25466 L
.65644 .25231 L
.65665 .25005 L
.65685 .24789 L
.65705 .2458 L
.65725 .2438 L
.65745 .24188 L
.65765 .24004 L
.65785 .23828 L
.65804 .2366 L
.65824 .235 L
.65843 .23349 L
.65863 .23208 L
.65882 .23075 L
.65902 .22953 L
.65921 .22842 L
.6594 .22743 L
.6596 .22656 L
.65979 .22584 L
.65998 .22527 L
.66017 .22488 L
.66036 .22468 L
.66055 .22471 L
.66075 .22498 L
.66094 .22554 L
.66113 .22645 L
.66132 .22775 L
.66151 .22955 L
.66171 .23194 L
Mistroke
.6619 .23511 L
.6621 .2393 L
.66229 .24056 L
.66249 .24001 L
.66269 .23931 L
.66289 .23779 L
.66308 .23593 L
.66328 .23363 L
.66348 .23108 L
.66367 .2283 L
.66386 .2254 L
.66405 .22244 L
.66424 .2195 L
.66443 .21663 L
.66462 .21262 L
.66481 .2072 L
.66499 .20261 L
.66517 .19792 L
.66535 .19371 L
.66553 .18975 L
.66571 .18622 L
.66589 .18307 L
.66606 .18033 L
.66623 .17801 L
.66641 .17612 L
.66658 .17466 L
.66675 .17366 L
.66692 .17313 L
.66709 .17311 L
.66726 .17362 L
.66743 .17474 L
.6676 .17652 L
.66777 .17899 L
.66795 .17846 L
.66812 .1795 L
.66829 .17764 L
.66846 .17268 L
.66863 .1689 L
.6688 .16451 L
.66897 .1606 L
.66913 .15678 L
.6693 .15335 L
.66946 .15022 L
.66962 .14747 L
.66978 .14509 L
.66994 .14309 L
.6701 .14148 L
.67026 .14025 L
.67041 .1394 L
.67057 .13895 L
Mistroke
.67073 .13889 L
.67088 .13923 L
.67104 .14 L
.6712 .14121 L
.67135 .1429 L
.67151 .14511 L
.67167 .1479 L
.67183 .15136 L
.67199 .15562 L
.67215 .16087 L
.67232 .1674 L
.67249 .17573 L
.67266 .18108 L
.67283 .18683 L
.67301 .1926 L
.67319 .19872 L
.67337 .20449 L
.67355 .20876 L
.67374 .20216 L
.67392 .19908 L
.6741 .1946 L
.67428 .19124 L
.67446 .18788 L
.67463 .18516 L
.67481 .18279 L
.67498 .18093 L
.67516 .1795 L
.67533 .17851 L
.6755 .17792 L
.67567 .17774 L
.67585 .17793 L
.67602 .17848 L
.67619 .17938 L
.67636 .18062 L
.67654 .18219 L
.67671 .18408 L
.67688 .18631 L
.67706 .18888 L
.67724 .19181 L
.67742 .19513 L
.67759 .19888 L
.67778 .20312 L
.67796 .20793 L
.67814 .21344 L
.67833 .21981 L
.67852 .22732 L
.67871 .23641 L
.67891 .2479 L
.67911 .2635 L
.67932 .27797 L
Mistroke
.67953 .27123 L
.67974 .27257 L
.67995 .26823 L
.68016 .26563 L
.68037 .26156 L
.68057 .25795 L
.68078 .25407 L
.68098 .25045 L
.68118 .24694 L
.68138 .24356 L
.68158 .24026 L
.68178 .23743 L
.68198 .23489 L
.68217 .23272 L
.68237 .23088 L
.68256 .22909 L
.68276 .22756 L
.68295 .22623 L
.68314 .2251 L
.68333 .22416 L
.68352 .22341 L
.68371 .22284 L
.6839 .22243 L
.68409 .22218 L
.68428 .22209 L
.68448 .22214 L
.68467 .22235 L
.68486 .22269 L
.68505 .22318 L
.68524 .2238 L
.68543 .22455 L
.68562 .22544 L
.68581 .22646 L
.686 .22762 L
.6862 .22891 L
.68639 .23033 L
.68658 .2319 L
.68678 .23361 L
.68697 .23547 L
.68717 .23748 L
.68736 .23966 L
.68756 .242 L
.68776 .24452 L
.68796 .24724 L
.68816 .25016 L
.68836 .25332 L
.68857 .25672 L
.68877 .26041 L
.68898 .26443 L
.68918 .2688 L
Mistroke
.68939 .27358 L
.6896 .27886 L
.68982 .28472 L
.69003 .29131 L
.69025 .29881 L
.69047 .30752 L
.6907 .31792 L
.69093 .33084 L
.69116 .348 L
.69141 .37396 L
.69166 .43147 L
.69193 .42288 L
.69221 .38983 L
.69246 .38386 L
.69272 .36834 L
.69297 .35906 L
.69322 .34818 L
.69346 .33938 L
.6937 .3308 L
.69393 .32326 L
.69416 .31626 L
.69439 .30995 L
.69462 .30415 L
.69484 .29886 L
.69506 .29399 L
.69528 .2895 L
.6955 .28533 L
.69572 .28145 L
.69593 .27783 L
.69614 .27442 L
.69636 .2712 L
.69657 .26814 L
.69678 .26523 L
.69698 .26244 L
.69719 .25975 L
.6974 .25717 L
.6976 .25466 L
.6978 .25222 L
.69801 .24985 L
.69821 .24754 L
.69841 .24528 L
.69861 .24306 L
.69881 .24089 L
.69901 .23875 L
.6992 .23665 L
.6994 .23459 L
.6996 .23257 L
.69979 .23058 L
.69998 .22863 L
.70018 .22671 L
Mistroke
.70037 .22484 L
.70056 .22301 L
.70075 .22122 L
.70094 .21948 L
.70113 .21779 L
.70132 .21616 L
.70151 .21458 L
.70169 .21308 L
.70188 .21164 L
.70207 .21028 L
.70225 .20901 L
.70244 .20783 L
.70262 .20675 L
.70281 .20579 L
.70299 .20495 L
.70317 .20425 L
.70336 .20372 L
.70354 .20336 L
.70372 .2032 L
.7039 .20327 L
.70409 .20361 L
.70427 .20427 L
.70445 .2053 L
.70464 .20678 L
.70482 .20882 L
.705 .21157 L
.70519 .21526 L
.70538 .21576 L
.70557 .21508 L
.70575 .21399 L
.70594 .21226 L
.70613 .21014 L
.70631 .20764 L
.7065 .20488 L
.70668 .20192 L
.70686 .19884 L
.70704 .1957 L
.70722 .19257 L
.7074 .18952 L
.70758 .18659 L
.70775 .18194 L
.70793 .17737 L
.7081 .17296 L
.70827 .16881 L
.70844 .16496 L
.70861 .16145 L
.70877 .15829 L
.70894 .15551 L
.7091 .15311 L
.70926 .15111 L
Mistroke
.70942 .14951 L
.70958 .14832 L
.70974 .14757 L
.7099 .14728 L
.71006 .14748 L
.71022 .14821 L
.71038 .14955 L
.71054 .14976 L
.7107 .14949 L
.71087 .1496 L
.71103 .1498 L
.71119 .14557 L
.71135 .14174 L
.7115 .13758 L
.71166 .13368 L
.71181 .12991 L
.71197 .12645 L
.71212 .12327 L
.71227 .12044 L
.71242 .11795 L
.71256 .1158 L
.71271 .11401 L
.71286 .11257 L
.713 .11148 L
.71315 .11075 L
.71329 .11037 L
.71344 .11036 L
.71358 .11072 L
.71373 .11146 L
.71387 .11262 L
.71402 .11421 L
.71416 .1163 L
.71431 .11893 L
.71446 .1222 L
.71461 .12624 L
.71476 .13124 L
.71491 .13752 L
.71507 .14565 L
.71523 .15217 L
.71539 .15748 L
.71555 .16364 L
.71572 .16978 L
.71589 .17385 L
.71606 .17182 L
.71623 .16564 L
.7164 .16188 L
.71656 .15735 L
.71673 .1537 L
.71689 .15021 L
.71705 .14726 L
Mistroke
.71721 .14468 L
.71737 .14254 L
.71753 .14078 L
.71768 .1394 L
.71784 .13837 L
.718 .13766 L
.71815 .13726 L
.71831 .13715 L
.71846 .13729 L
.71862 .13769 L
.71878 .13831 L
.71893 .13917 L
.71909 .14024 L
.71924 .14152 L
.7194 .14301 L
.71956 .14472 L
.71972 .14667 L
.71988 .14885 L
.72004 .15132 L
.7202 .15409 L
.72036 .15722 L
.72053 .16079 L
.72069 .16489 L
.72086 .16968 L
.72103 .17537 L
.7212 .18368 L
.72137 .19482 L
.72155 .20908 L
.72174 .2302 L
.72193 .23938 L
.72213 .23821 L
.72233 .23944 L
.72252 .23751 L
.72272 .23116 L
.72291 .22627 L
.72311 .22091 L
.7233 .2162 L
.72348 .21161 L
.72367 .20743 L
.72385 .20352 L
.72404 .19995 L
.72422 .19666 L
.7244 .19366 L
.72458 .1909 L
.72475 .18837 L
.72493 .18606 L
.72511 .18393 L
.72528 .18197 L
.72546 .18017 L
.72563 .1785 L
Mistroke
.7258 .17696 L
.72597 .17591 L
.72614 .17599 L
.72632 .176 L
.72649 .17647 L
.72666 .17706 L
.72683 .17791 L
.727 .1789 L
.72718 .18006 L
.72735 .18135 L
.72752 .18277 L
.7277 .18431 L
.72787 .18595 L
.72805 .18769 L
.72822 .18952 L
.7284 .19144 L
.72858 .19345 L
.72876 .19555 L
.72894 .19773 L
.72912 .19999 L
.7293 .20234 L
.72948 .20478 L
.72966 .20704 L
.72985 .20901 L
.73003 .21112 L
.73022 .2132 L
.73041 .21537 L
.73059 .21758 L
.73078 .21989 L
.73097 .22229 L
.73116 .2248 L
.73135 .22744 L
.73155 .23021 L
.73174 .23314 L
.73193 .23623 L
.73213 .23951 L
.73233 .24299 L
.73253 .24669 L
.73273 .25064 L
.73293 .25488 L
.73313 .25943 L
.73334 .26436 L
.73355 .26973 L
.73376 .27562 L
.73397 .28212 L
.73418 .2894 L
.7344 .29766 L
.73462 .30723 L
.73485 .31864 L
.73508 .33286 L
Mistroke
.73531 .35195 L
.73556 .38182 L
.73581 .46239 L
.7361 .40442 L
.73636 .39876 L
.73663 .38141 L
.73688 .37223 L
.73713 .36084 L
.73738 .35196 L
.73762 .34321 L
.73786 .33566 L
.7381 .32867 L
.73833 .32246 L
.73857 .31681 L
.73879 .31173 L
.73902 .30711 L
.73925 .30292 L
.73947 .29909 L
.73969 .29559 L
.73991 .29236 L
.74013 .28937 L
.74035 .28659 L
.74057 .28399 L
.74078 .28154 L
.741 .27921 L
.74121 .277 L
.74142 .27489 L
.74163 .27285 L
.74184 .27087 L
.74206 .26894 L
.74226 .26705 L
.74247 .2652 L
.74268 .26337 L
.74289 .26155 L
.74309 .25974 L
.7433 .25793 L
.74351 .25613 L
.74371 .25431 L
.74391 .25249 L
.74412 .25065 L
.74432 .2488 L
.74452 .24693 L
.74472 .24504 L
.74492 .24312 L
.74512 .24119 L
.74532 .23924 L
.74551 .23726 L
.74571 .23526 L
.74591 .23324 L
.7461 .23121 L
Mistroke
.74629 .22915 L
.74649 .22707 L
.74668 .22498 L
.74687 .22288 L
.74706 .22077 L
.74725 .21864 L
.74744 .21652 L
.74763 .21438 L
.74782 .21225 L
.748 .21012 L
.74819 .208 L
.74837 .20588 L
.74856 .20378 L
.74874 .20169 L
.74892 .19962 L
.7491 .19757 L
.74928 .19555 L
.74946 .19356 L
.74964 .1916 L
.74982 .18968 L
.75 .18781 L
.75017 .18598 L
.75035 .1842 L
.75052 .18248 L
.7507 .18082 L
.75087 .17923 L
.75104 .17771 L
.75122 .17627 L
.75139 .17493 L
.75156 .17368 L
.75173 .17254 L
.7519 .17152 L
.75207 .17063 L
.75224 .1699 L
.75241 .16933 L
.75258 .16895 L
.75274 .16879 L
.75291 .16888 L
.75308 .16926 L
.75325 .17 L
.75342 .17116 L
.75359 .17286 L
.75376 .17523 L
.75393 .17784 L
.7541 .17598 L
.75427 .17538 L
.75445 .17333 L
.75462 .17131 L
.75479 .16869 L
.75495 .1659 L
Mistroke
.75512 .16284 L
.75529 .15966 L
.75545 .15638 L
.75562 .15309 L
.75578 .14983 L
.75594 .14666 L
.7561 .14362 L
.75626 .14076 L
.75641 .13676 L
.75657 .13278 L
.75672 .12901 L
.75688 .12545 L
.75703 .12217 L
.75718 .11918 L
.75732 .1165 L
.75747 .11415 L
.75762 .11215 L
.75776 .11049 L
.75791 .1092 L
.75805 .10828 L
.7582 .10776 L
.75834 .10766 L
.75848 .10803 L
.75863 .10709 L
.75877 .10631 L
.75891 .10561 L
.75906 .10514 L
.7592 .1049 L
.75934 .1035 L
.75948 .09881 L
.75962 .09555 L
.75976 .09161 L
.7599 .0882 L
.76003 .08483 L
.76017 .08181 L
.7603 .07902 L
.76043 .07656 L
.76056 .07438 L
.76069 .07251 L
.76082 .07094 L
.76095 .06968 L
.76108 .06871 L
.76121 .06804 L
.76134 .06767 L
.76146 .06761 L
.76159 .06786 L
.76172 .06845 L
.76185 .06937 L
.76197 .07068 L
.7621 .07239 L
Mistroke
.76223 .07458 L
.76236 .07732 L
.76249 .08072 L
.76262 .08498 L
.76276 .09039 L
.7629 .09749 L
.76304 .10672 L
.76318 .11037 L
.76332 .11697 L
.76347 .12237 L
.76362 .12478 L
.76377 .11447 L
.76392 .11119 L
.76406 .10501 L
.7642 .10067 L
.76435 .09592 L
.76448 .09185 L
.76462 .08793 L
.76476 .08439 L
.76489 .08105 L
.76502 .07794 L
.76516 .07498 L
.76529 .07211 L
.76541 .06926 L
.76554 .06636 L
.76567 .06331 L
.76579 .06628 L
.76592 .06883 L
.76605 .07267 L
.76618 .07672 L
.76631 .08136 L
.76644 .08628 L
.76658 .09156 L
.76671 .0971 L
.76685 .10291 L
.767 .10896 L
.76714 .11526 L
.76729 .12181 L
.76744 .12862 L
.76759 .13571 L
.76774 .14313 L
.7679 .15092 L
.76806 .15915 L
.76823 .16794 L
.7684 .17744 L
.76857 .1879 L
.76874 .19973 L
.76892 .21365 L
.76911 .2312 L
.76931 .22561 L
Mistroke
.7695 .22559 L
.76969 .22113 L
.76988 .21778 L
.77007 .21326 L
.77025 .20906 L
.77044 .20467 L
.77062 .2005 L
.7708 .19646 L
.77098 .19266 L
.77116 .18907 L
.77134 .18572 L
.77151 .18259 L
.77169 .17968 L
.77186 .17698 L
.77203 .17447 L
.7722 .17214 L
.77237 .16997 L
.77254 .16796 L
.77271 .16607 L
.77288 .16431 L
.77305 .16266 L
.77321 .1611 L
.77338 .15963 L
.77354 .15823 L
.77371 .15689 L
.77387 .15561 L
.77403 .15438 L
.7742 .15318 L
.77436 .15201 L
.77452 .15086 L
.77468 .14973 L
.77484 .1486 L
.775 .14747 L
.77516 .14632 L
.77532 .14516 L
.77548 .14765 L
.77564 .14903 L
.7758 .15154 L
.77596 .15391 L
.77613 .15668 L
.77629 .15952 L
.77645 .16253 L
.77662 .16561 L
.77679 .16878 L
.77696 .17201 L
.77713 .17529 L
.7773 .17861 L
.77747 .18197 L
.77764 .18535 L
.77782 .18877 L
Mistroke
.778 .1922 L
.77817 .19566 L
.77835 .19914 L
.77853 .20263 L
.77872 .20615 L
.7789 .20967 L
.77909 .21321 L
.77927 .21675 L
.77946 .2203 L
.77965 .22384 L
.77984 .22738 L
.78003 .23091 L
.78023 .23441 L
.78042 .23789 L
.78062 .24132 L
.78082 .2447 L
.78102 .24801 L
.78122 .25124 L
.78142 .25438 L
.78162 .2574 L
.78183 .26029 L
.78203 .26304 L
.78224 .26563 L
.78245 .26803 L
.78266 .27025 L
.78287 .27225 L
.78308 .27404 L
.78329 .2756 L
.7835 .27693 L
.78372 .27802 L
.78393 .27888 L
.78414 .2795 L
.78436 .27989 L
.78457 .28006 L
.78478 .28002 L
.785 .27977 L
.78521 .27934 L
.78543 .27873 L
.78564 .27795 L
.78585 .27702 L
.78607 .27596 L
.78628 .27477 L
.78649 .27347 L
.7867 .27207 L
.78691 .27057 L
.78712 .269 L
.78733 .26735 L
.78754 .26565 L
.78775 .26388 L
.78796 .26207 L
Mistroke
.78816 .26021 L
.78837 .25832 L
.78857 .25639 L
.78878 .25444 L
.78898 .25245 L
.78918 .25045 L
.78939 .24843 L
.78959 .2464 L
.78979 .24435 L
.78999 .24229 L
.79018 .24023 L
.79038 .23816 L
.79058 .23609 L
.79078 .23402 L
.79097 .23195 L
.79116 .22988 L
.79136 .22783 L
.79155 .22579 L
.79174 .22375 L
.79193 .22174 L
.79212 .21975 L
.79231 .21777 L
.7925 .21583 L
.79269 .21391 L
.79288 .21202 L
.79306 .21018 L
.79325 .20837 L
.79343 .20661 L
.79362 .2049 L
.7938 .20324 L
.79398 .20165 L
.79416 .20012 L
.79435 .19866 L
.79453 .19729 L
.79471 .196 L
.79489 .19481 L
.79507 .19373 L
.79524 .19277 L
.79542 .19194 L
.7956 .19125 L
.79578 .19074 L
.79596 .19041 L
.79613 .1903 L
.79631 .19044 L
.79649 .19087 L
.79667 .19164 L
.79684 .19283 L
.79702 .19452 L
.7972 .19685 L
.79738 .20001 L
Mistroke
.79756 .20132 L
.79774 .20017 L
.79793 .19926 L
.79811 .19739 L
.79829 .19529 L
.79847 .19273 L
.79865 .18994 L
.79882 .18692 L
.799 .18378 L
.79917 .18057 L
.79935 .17736 L
.79952 .1742 L
.79969 .17116 L
.79986 .16828 L
.80003 .16321 L
.80019 .15921 L
.80036 .15493 L
.80052 .15115 L
.80068 .14756 L
.80084 .14435 L
.801 .14146 L
.80116 .13895 L
.80131 .1368 L
.80147 .13503 L
.80162 .13365 L
.80178 .13268 L
.80193 .13213 L
.80209 .13204 L
.80224 .13244 L
.80239 .13338 L
.80255 .13309 L
.8027 .13261 L
.80286 .13238 L
.80301 .1323 L
.80316 .13143 L
.80332 .12626 L
.80347 .12294 L
.80362 .11871 L
.80377 .11511 L
.80391 .11151 L
.80406 .10831 L
.8042 .10535 L
.80434 .10274 L
.80449 .10045 L
.80463 .0985 L
.80477 .09688 L
.80491 .0956 L
.80504 .09464 L
.80518 .09402 L
.80532 .09374 L
Mistroke
.80546 .0938 L
.8056 .09421 L
.80573 .09499 L
.80587 .09617 L
.80601 .09777 L
.80615 .09985 L
.80629 .10246 L
.80643 .10571 L
.80658 .10973 L
.80672 .11474 L
.80687 .1211 L
.80702 .12948 L
.80717 .1356 L
.80732 .14109 L
.80748 .14715 L
.80764 .15277 L
.8078 .15672 L
.80797 .14718 L
.80813 .14428 L
.80828 .13863 L
.80844 .13478 L
.8086 .1306 L
.80875 .12716 L
.8089 .12396 L
.80905 .12123 L
.8092 .11882 L
.80935 .11678 L
.8095 .11505 L
.80964 .11361 L
.80979 .11241 L
.80993 .11145 L
.81008 .11069 L
.81022 .11011 L
.81037 .10967 L
.81051 .10937 L
.81066 .10916 L
.8108 .10904 L
.81095 .10899 L
.81109 .10898 L
.81123 .1106 L
.81138 .11556 L
.81153 .11993 L
.81167 .12551 L
.81182 .13127 L
.81198 .13767 L
.81213 .14444 L
.81229 .15175 L
.81245 .15958 L
.81262 .16808 L
.81279 .17742 L
Mistroke
.81296 .1879 L
.81314 .20008 L
.81332 .21501 L
.8135 .23523 L
.8137 .23416 L
.8139 .2352 L
.81409 .23294 L
.81429 .23078 L
.81448 .22758 L
.81467 .22432 L
.81486 .22082 L
.81505 .21738 L
.81524 .21398 L
.81543 .21075 L
.81561 .20767 L
.8158 .2048 L
.81598 .20213 L
.81616 .19966 L
.81635 .1974 L
.81653 .19534 L
.8167 .19346 L
.81688 .19177 L
.81706 .19025 L
.81724 .18888 L
.81742 .18767 L
.81759 .18661 L
.81777 .18568 L
.81794 .18487 L
.81812 .18418 L
.81829 .18361 L
.81847 .18315 L
.81864 .18278 L
.81882 .18252 L
.81899 .18235 L
.81916 .18226 L
.81934 .18226 L
.81951 .18235 L
.81969 .18251 L
.81986 .18275 L
.82004 .18307 L
.82021 .18347 L
.82038 .18393 L
.82056 .18447 L
.82073 .18509 L
.82091 .18577 L
.82108 .18652 L
.82126 .18735 L
.82144 .18825 L
.82161 .18921 L
.82179 .19025 L
Mistroke
.82197 .19136 L
.82215 .19255 L
.82232 .1938 L
.8225 .19513 L
.82268 .19654 L
.82286 .19803 L
.82304 .19959 L
.82322 .20123 L
.82341 .20295 L
.82359 .20476 L
.82377 .20665 L
.82395 .20863 L
.82414 .2107 L
.82433 .21286 L
.82451 .21512 L
.8247 .21747 L
.82489 .21993 L
.82508 .22249 L
.82527 .22516 L
.82546 .22794 L
.82565 .23083 L
.82585 .23385 L
.82604 .237 L
.82624 .24027 L
.82644 .24369 L
.82663 .24725 L
.82683 .25096 L
.82704 .25483 L
.82724 .25887 L
.82745 .26309 L
.82765 .2675 L
.82786 .27211 L
.82807 .27694 L
.82829 .28199 L
.8285 .28729 L
.82872 .29285 L
.82894 .2987 L
.82916 .30486 L
.82938 .31135 L
.82961 .31821 L
.82984 .32546 L
.83007 .33315 L
.83031 .34132 L
.83055 .35014 L
.83079 .35985 L
.83103 .37014 L
.83129 .38126 L
.83154 .39313 L
.8318 .40586 L
.83207 .41943 L
Mistroke
.83234 .4338 L
.83261 .44879 L
.8329 .46403 L
.83319 .47891 L
.83348 .49249 L
.83378 .50188 L
.83409 .50835 L
.83439 .51112 L
.8347 .51086 L
.83501 .50792 L
.83532 .50305 L
.83562 .49674 L
.83592 .48953 L
.83622 .48179 L
.83652 .4738 L
.83681 .46578 L
.8371 .45787 L
.83739 .45018 L
.83767 .44277 L
.83795 .43569 L
.83823 .42895 L
.83851 .42256 L
.83878 .41651 L
.83905 .4108 L
.83932 .40542 L
.83958 .40033 L
.83984 .39554 L
.8401 .39102 L
.84036 .38674 L
.84062 .3827 L
.84088 .37887 L
.84113 .37525 L
.84138 .37181 L
.84164 .36854 L
.84189 .36542 L
.84213 .36246 L
.84238 .35962 L
.84263 .35692 L
.84287 .35433 L
.84312 .35185 L
.84336 .34947 L
.8436 .34718 L
.84385 .34498 L
.84409 .34286 L
.84433 .34082 L
.84456 .33885 L
.8448 .33695 L
.84504 .33511 L
.84528 .33333 L
.84551 .3316 L
Mistroke
.84575 .32993 L
.84598 .32831 L
.84622 .32674 L
.84645 .32521 L
.84668 .32372 L
.84691 .32228 L
.84714 .32087 L
.84737 .3195 L
.8476 .31816 L
.84783 .31686 L
.84806 .31558 L
.84829 .31434 L
.84852 .31312 L
.84875 .31192 L
.84897 .31075 L
.8492 .3096 L
.84943 .30847 L
.84965 .30736 L
.84988 .30616 L
.8501 .30473 L
.85033 .30332 L
.85055 .30182 L
.85077 .30029 L
.85099 .2987 L
.85122 .29706 L
.85144 .29536 L
.85166 .29362 L
.85188 .29182 L
.8521 .28997 L
.85231 .28806 L
.85253 .28608 L
.85275 .28405 L
.85296 .28196 L
.85318 .2798 L
.85339 .27758 L
.8536 .27529 L
.85382 .27294 L
.85403 .27052 L
.85424 .26804 L
.85445 .2655 L
.85465 .2629 L
.85486 .26024 L
.85507 .25752 L
.85527 .25475 L
.85548 .25193 L
.85568 .24907 L
.85588 .24616 L
.85608 .24322 L
.85628 .24024 L
.85648 .23723 L
Mistroke
.85667 .2342 L
.85687 .23114 L
.85706 .22808 L
.85726 .22499 L
.85745 .22191 L
.85764 .21882 L
.85783 .21573 L
.85801 .21265 L
.8582 .20958 L
.85839 .20652 L
.85857 .20347 L
.85875 .20045 L
.85893 .19745 L
.85911 .19447 L
.85929 .19153 L
.85947 .18861 L
.85965 .18573 L
.85982 .18289 L
.86 .18008 L
.86017 .17731 L
.86034 .17459 L
.86051 .1719 L
.86068 .16927 L
.86085 .16668 L
.86102 .16413 L
.86119 .16164 L
.86135 .1592 L
.86152 .15681 L
.86168 .15448 L
.86184 .15221 L
.86201 .14999 L
.86217 .14783 L
.86233 .14574 L
.86249 .14371 L
.86264 .14175 L
.8628 .13985 L
.86296 .13804 L
.86311 .1363 L
.86327 .13464 L
.86342 .13307 L
.86358 .13159 L
.86373 .13022 L
.86388 .12895 L
.86404 .1278 L
.86419 .12678 L
.86434 .1259 L
.86449 .12518 L
.86464 .12465 L
.86479 .12432 L
.86494 .12423 L
Mistroke
.86509 .12442 L
.86524 .12495 L
.86539 .12589 L
.86554 .12735 L
.8657 .12935 L
.86585 .12717 L
.866 .12625 L
.86615 .12399 L
.8663 .12179 L
.86645 .11907 L
.8666 .1162 L
.86675 .11309 L
.86689 .10989 L
.86704 .1066 L
.86718 .1033 L
.86732 .10002 L
.86746 .09681 L
.8676 .09371 L
.86774 .09076 L
.86788 .088 L
.86801 .08545 L
.86815 .08295 L
.86828 .07943 L
.86841 .07658 L
.86854 .07365 L
.86867 .07106 L
.8688 .06864 L
.86893 .06652 L
.86906 .06464 L
.86918 .06306 L
.86931 .06176 L
.86943 .06078 L
.86956 .06012 L
.86968 .05865 L
.8698 .05713 L
.86993 .0558 L
.87005 .05461 L
.87017 .05364 L
.87029 .05291 L
.87041 .05244 L
.87054 .05226 L
.87066 .04769 L
.87078 .04505 L
.87089 .04145 L
.87101 .03846 L
.87113 .0354 L
.87124 .03267 L
.87135 .0301 L
.87147 .0278 L
.87158 .02573 L
Mistroke
.87169 .02391 L
.8718 .02233 L
.8719 .02099 L
.87201 .01989 L
.87212 .01902 L
.87223 .01838 L
.87234 .01797 L
.87244 .01779 L
.87255 .01786 L
.87266 .01817 L
.87276 .01875 L
.87287 .01961 L
.87298 .02078 L
.87309 .0223 L
.8732 .02424 L
.8733 .02668 L
.87342 .02977 L
.87353 .03373 L
.87364 .03901 L
.87376 .04651 L
.87387 .05529 L
.874 .0587 L
.87412 .0648 L
.87425 .05606 L
.87437 .04945 L
.87449 .04254 L
.87461 .03591 L
.87472 .0291 L
.87483 .02215 L
.87494 .01472 L
.87505 .01494 L
.87515 .01547 L
.87526 .01698 L
.87536 .0189 L
.87547 .02135 L
.87558 .02412 L
.87569 .02722 L
.8758 .03057 L
.87591 .03416 L
.87603 .03797 L
.87614 .04198 L
.87626 .0462 L
.87638 .05062 L
.8765 .05524 L
.87662 .06007 L
.87674 .06513 L
.87687 .07042 L
.877 .07596 L
.87713 .08178 L
.87726 .08789 L
Mistroke
.8774 .09432 L
.87754 .1011 L
.87768 .10827 L
.87782 .11589 L
.87797 .12401 L
.87812 .13273 L
.87827 .14216 L
.87843 .15247 L
.87859 .16392 L
.87876 .17695 L
.87893 .19233 L
.87911 .18696 L
.87928 .18724 L
.87946 .18277 L
.87963 .17939 L
.87981 .17472 L
.87998 .17029 L
.88015 .16559 L
.88031 .16103 L
.88048 .1565 L
.88064 .15211 L
.88081 .14783 L
.88097 .14366 L
.88112 .13958 L
.88128 .13557 L
.88144 .13158 L
.88159 .12756 L
.88174 .12348 L
.88189 .11925 L
.88204 .1148 L
.88219 .11668 L
.88233 .11793 L
.88248 .1205 L
.88263 .12315 L
.88278 .12633 L
.88293 .12967 L
.88308 .13325 L
.88324 .13695 L
.88339 .14077 L
.88355 .14467 L
.88371 .14863 L
.88387 .15264 L
.88403 .1567 L
.88419 .16078 L
.88436 .16489 L
.88453 .16903 L
.8847 .17319 L
.88487 .17738 L
.88504 .18159 L
.88521 .18583 L
Mistroke
.88539 .19009 L
.88556 .19438 L
.88574 .1987 L
.88592 .20305 L
.88611 .20743 L
.88629 .21184 L
.88648 .21629 L
.88667 .22076 L
.88685 .22527 L
.88705 .22981 L
.88724 .23437 L
.88744 .23896 L
.88763 .24358 L
.88783 .2482 L
.88803 .25283 L
.88824 .25746 L
.88844 .26207 L
.88865 .26665 L
.88886 .27119 L
.88907 .27565 L
.88928 .28003 L
.88949 .28429 L
.88971 .2884 L
.88993 .29234 L
.89014 .29607 L
.89036 .29956 L
.89059 .30278 L
.89081 .30571 L
.89103 .30831 L
.89126 .31058 L
.89149 .31249 L
.89171 .31405 L
.89194 .31525 L
.89217 .31611 L
.8924 .31664 L
.89263 .31687 L
.89286 .31681 L
.89309 .3165 L
.89331 .31596 L
.89354 .31524 L
.89377 .31436 L
.894 .31336 L
.89423 .31226 L
.89445 .3111 L
.89468 .3099 L
.89491 .30869 L
.89513 .3075 L
.89536 .30635 L
.89558 .30525 L
.89581 .30424 L
Mistroke
.89603 .30333 L
.89625 .30255 L
.89648 .30191 L
.8967 .30144 L
.89692 .30116 L
.89715 .3011 L
.89737 .30128 L
.89759 .30176 L
.89781 .30255 L
.89804 .30373 L
.89826 .30535 L
.89848 .30749 L
.89871 .31027 L
.89894 .31383 L
.89916 .31842 L
.89939 .32436 L
.89963 .3254 L
.89986 .32603 L
.90009 .3258 L
.90032 .32512 L
.90056 .32395 L
.90079 .32248 L
.90102 .32074 L
.90125 .31885 L
.90148 .31688 L
.90171 .31491 L
.90194 .31253 L
.90216 .30493 L
.90239 .29982 L
.90261 .2937 L
.90283 .28851 L
.90305 .28342 L
.90326 .27892 L
.90348 .27483 L
.90369 .27127 L
.9039 .26819 L
.90411 .26564 L
.90432 .26359 L
.90452 .26207 L
.90473 .26108 L
.90494 .26065 L
.90514 .26079 L
.90535 .26155 L
.90555 .26297 L
.90576 .26514 L
.90597 .26814 L
.90618 .27215 L
.90639 .27737 L
.9066 .27298 L
.90681 .27022 L
Mistroke
.90702 .26603 L
.90723 .26232 L
.90744 .25843 L
.90764 .25489 L
.90785 .25159 L
.90805 .24868 L
.90825 .24615 L
.90845 .24405 L
.90865 .24239 L
.90885 .2412 L
.90905 .24047 L
.90924 .24023 L
.90944 .24049 L
.90964 .24127 L
.90984 .24259 L
.91004 .24449 L
.91024 .24703 L
.91044 .25026 L
.91064 .25427 L
.91084 .25919 L
.91105 .26522 L
.91126 .27083 L
.91147 .27374 L
.91168 .27785 L
.91189 .28132 L
.91211 .28515 L
.91232 .2889 L
.91254 .29281 L
.91276 .29678 L
.91298 .30086 L
.9132 .305 L
.91343 .3092 L
.91365 .30636 L
.91388 .3051 L
.9141 .30303 L
.91432 .3016 L
.91455 .30028 L
.91477 .29946 L
.91499 .29905 L
.91521 .29914 L
.91543 .29973 L
.91566 .30086 L
.91588 .30255 L
.9161 .30482 L
.91633 .30772 L
.91655 .31131 L
.91678 .31566 L
.91701 .32089 L
.91724 .32716 L
.91747 .33473 L
Mistroke
.91771 .34399 L
.91795 .35566 L
.91819 .36995 L
.91844 .35916 L
.91869 .35874 L
.91893 .352 L
.91918 .3477 L
.91942 .34196 L
.91966 .33699 L
.9199 .3319 L
.92013 .32726 L
.92036 .32287 L
.9206 .31888 L
.92083 .31524 L
.92105 .31197 L
.92128 .30906 L
.92151 .3065 L
.92173 .30428 L
.92196 .30239 L
.92218 .30081 L
.9224 .29953 L
.92262 .29853 L
.92284 .29782 L
.92307 .29738 L
.92329 .2972 L
.92351 .29729 L
.92373 .29763 L
.92395 .29822 L
.92417 .29908 L
.92439 .30019 L
.92462 .30158 L
.92484 .30325 L
.92506 .30521 L
.92529 .30749 L
.92551 .31011 L
.92574 .31312 L
.92596 .31655 L
.92619 .32046 L
.92642 .32492 L
.92666 .33004 L
.92689 .33596 L
.92713 .3429 L
.92737 .35117 L
.92761 .36129 L
.92786 .37419 L
.92811 .3918 L
.92837 .41941 L
.92864 .48602 L
.92894 .45721 L
.92922 .43258 L
Mistroke
.9295 .42031 L
.92977 .40538 L
.93004 .39362 L
.9303 .38195 L
.93055 .37177 L
.9308 .36232 L
.93105 .35386 L
.9313 .34616 L
.93154 .33923 L
.93178 .33296 L
.93201 .32729 L
.93224 .32217 L
.93248 .31754 L
.93271 .31335 L
.93293 .30957 L
.93316 .30615 L
.93338 .30308 L
.93361 .30031 L
.93383 .29784 L
.93405 .29564 L
.93427 .29372 L
.93449 .29205 L
.93471 .29063 L
.93493 .28946 L
.93515 .28856 L
.93536 .28791 L
.93558 .28755 L
.9358 .28747 L
.93601 .28771 L
.93623 .28831 L
.93645 .28929 L
.93667 .29071 L
.93688 .29266 L
.9371 .29522 L
.93732 .29854 L
.93755 .30282 L
.93777 .30837 L
.93799 .31058 L
.93822 .31075 L
.93845 .31085 L
.93867 .31009 L
.9389 .30901 L
.93913 .30751 L
.93935 .30578 L
.93958 .30386 L
.9398 .30184 L
.94002 .29981 L
.94024 .29784 L
.94047 .29164 L
.94068 .28625 L
Mistroke
.9409 .28061 L
.94111 .27546 L
.94133 .27057 L
.94154 .26616 L
.94175 .26219 L
.94195 .2587 L
.94216 .2557 L
.94236 .2532 L
.94256 .25121 L
.94277 .24974 L
.94297 .2488 L
.94317 .24841 L
.94337 .2486 L
.94357 .24941 L
.94377 .25089 L
.94398 .25313 L
.94418 .25624 L
.94438 .26039 L
.94459 .26517 L
.9448 .25833 L
.945 .25625 L
.94521 .25134 L
.94541 .24771 L
.94561 .24359 L
.94581 .24004 L
.94601 .23665 L
.9462 .23372 L
.9464 .23115 L
.94659 .22903 L
.94678 .22734 L
.94698 .22612 L
.94717 .22535 L
.94736 .22506 L
.94755 .22526 L
.94774 .22596 L
.94794 .22718 L
.94813 .22897 L
.94832 .23137 L
.94851 .23443 L
.94871 .23824 L
.94891 .24293 L
.94911 .24865 L
.94931 .25568 L
.94951 .2591 L
.94972 .26355 L
.94992 .26743 L
.95013 .27164 L
.95034 .27578 L
.95056 .2801 L
.95077 .28448 L
Mistroke
.95099 .28896 L
.9512 .29351 L
.95142 .29535 L
.95164 .29133 L
.95186 .28997 L
.95208 .28742 L
.9523 .2858 L
.95251 .28422 L
.95273 .28322 L
.95294 .28261 L
.95316 .28252 L
.95337 .28291 L
.95359 .28382 L
.9538 .28526 L
.95402 .28724 L
.95424 .28979 L
.95446 .29296 L
.95467 .29679 L
.9549 .30137 L
.95512 .30681 L
.95534 .31329 L
.95557 .32108 L
.9558 .3306 L
.95604 .3426 L
.95628 .35821 L
.95652 .3473 L
.95676 .34738 L
.957 .34074 L
.95724 .33668 L
.95748 .33106 L
.95771 .32621 L
.95795 .32121 L
.95818 .31664 L
.95841 .3123 L
.95863 .30835 L
.95886 .30474 L
.95908 .30148 L
.95931 .29857 L
.95953 .29601 L
.95975 .29377 L
.95997 .29185 L
.96019 .29023 L
.96041 .28889 L
.96062 .28784 L
.96084 .28705 L
.96106 .28652 L
.96127 .28625 L
.96149 .28621 L
.96171 .28642 L
.96192 .28686 L
Mistroke
.96214 .28754 L
.96236 .28846 L
.96257 .28962 L
.96279 .29103 L
.96301 .29269 L
.96323 .29463 L
.96345 .29685 L
.96367 .29938 L
.96389 .30226 L
.96412 .30552 L
.96434 .3092 L
.96457 .31336 L
.96479 .31809 L
.96502 .3235 L
.96525 .32976 L
.96549 .33708 L
.96573 .34584 L
.96597 .35663 L
.96621 .37057 L
.96646 .39013 L
.96672 .42295 L
.96699 .55015 L
.96732 .41346 L
.96759 .44122 L
.96787 .40349 L
.96813 .40009 L
.96839 .38236 L
.96865 .3734 L
.9689 .36187 L
.96915 .35314 L
.96939 .34445 L
.96963 .33702 L
.96987 .33012 L
.97011 .32398 L
.97034 .31838 L
.97057 .31334 L
.97079 .30875 L
.97102 .30458 L
.97124 .3008 L
.97147 .29735 L
.97169 .29422 L
.97191 .29138 L
.97213 .2888 L
.97234 .28647 L
.97256 .28438 L
.97278 .28252 L
.97299 .28087 L
.97321 .27944 L
.97342 .27824 L
.97363 .27725 L
Mistroke
.97385 .27649 L
.97406 .27596 L
.97427 .2757 L
.97448 .2757 L
.97469 .276 L
.97491 .27663 L
.97512 .27764 L
.97533 .27908 L
.97555 .28103 L
.97576 .28359 L
.97598 .28144 L
.97619 .28144 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000QOol0
0`00Oomoo`3lOol0025oo`03001oogoo0?aoo`008Goo00<007ooOol06goo10000goo00<007ooOol0
0Woo0`007Woo0`007goo00<007ooOol00goo00<007ooOol00Woo0`006goo10000goo0P005goo1000
0Woo10000goo00<007ooOol00Woo0`0067oo10000Woo0`004goo000QOol00`00Oomoo`0KOol00`00
Oomoo`0<Ool00`00Oomoo`0NOol00`00Oomoo`0LOol00`00Oomoo`0;Ool00`00Oomoo`0JOol01@00
Oomoogoo00000Woo00<007ooOol05Woo00D007ooOomoo`0000ioo`03001oogoo01Moo`03001oogoo
00Aoo`03001oogoo011oo`008Goo00<007ooOol077oo00<007ooOol02goo00<007ooOol07Woo00<0
07ooOol07Goo00<007ooOol02Woo00<007ooOol06Woo00D007ooOomoo`00009oo`03001oogoo01Io
o`03001oogoo009oo`03001oogoo00]oo`03001oogoo00moo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo011oo`008Goo0P007Woo00<007ooOol01goo0`007Woo0`0087oo00<007ooOol01Goo
00<007oo00000P007Goo00D007ooOomoo`00009oo`03001oogoo01Ioo`03001oogoo00=oo`03001o
ogoo00Moo`<0015oo`8000Moo`04001oogooOol3000COol0025oo`03001oogoo01ioo`03001oogoo
00Ioo`03001oogoo01ioo`03001oogoo025oo`03001oogoo00=oo`800003Ool007oo01ioo`05001o
ogooOol00002Ool00`00Oomoo`0FOol00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`0AOol2
0007Ool01@00Oomoogoo00005Goo000QOol00`00Oomoo`0KOol01000Oomoo`0027oo00<007ooOol0
7Woo00<007ooOol07Woo00@007ooOol000Eoo`800003Ool007oo01aoo`<000=oo`04001oogoo000F
Ool30003Ool01000Oomoo`0027oo00<007ooOol04Goo0P001Goo0`000goo00<007ooOol04goo000Q
Ool00`00Oomoo`0LOol20009Ool4000MOol4000MOol40005Ool200000goo00000002000LOol00`00
Oomoo`02Ool2000IOol00`00Oomoo`02Ool20009Ool4000@Ool20007Ool01000Oomoogoo10004Woo
000QOol00`00Oomoo`1bOol2001UOol2000QOol0025oo`03001oogoo03Eoo`03001oogoo03Yoo`80
06Eoo`80025oo`008Goo00<007ooOol0=Goo00<007ooOol0>Woo0P00IGoo0P008Goo000KOooo0006
0000025oo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`<000Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`<000Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`04001oogooOol20002Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool0025oo`03001oogoo02=oo`03001oogoo
00ioo`8001Aoo`03001oogoo02Aoo`<002Aoo`03001oogoo02=oo`03001oogoo01Qoo`8000Yoo`03
001oogoo01Aoo`008Goo00<007ooOol077oo00<007ooOol05Goo0P00>goo0`00IGoo0P008Goo000Q
Ool00`00Oomoo`0LOol00`00Oomoo`0EOol2000QOol00`00Oomoo`0GOol3001:Ool00`00Oomoo`0G
Ool3000QOol0025oo`03001oogoo01]oo`8001Moo`80021oo`8001Uoo`<004Uoo`8001Uoo`03001o
o`00025oo`008Goo00<007ooOol06goo0P005goo0P0087oo0P006Goo00<007oo0000B7oo0`006Goo
00<007oo00008Goo000QOol00`00Oomoo`0KOol2000GOol2000POol2000IOol00`00Ool00018Ool3
000IOol00`00Ool0000QOol0025oo`8001aoo`<001Ioo`80021oo`8001Uoo`03001oo`0004Qoo`<0
01Uoo`04001oogoo000POol0025oo`03001oogoo01]oo`<001Ioo`80021oo`<001Qoo`03001oo`00
04Qoo`<001Uoo`04001oogoo000POol0025oo`03001oogoo01]oo`<001Ioo`80021oo`<001Qoo`03
001oo`0004Qoo`<001Uoo`04001oogoo000POol0025oo`8001aoo`<001Eoo`<0021oo`<001Qoo`03
001oo`0004Qoo`<001Uoo`04001oogoo000POol0025oo`8001aoo`<001Eoo`03001oo`00021oo`<0
01Qoo`03001oo`0004Qoo`<000Uoo`03001oogoo00eoo`04001oogoo000POol0025oo`8001aoo`<0
01Eoo`03001oo`00021oo`<000Uoo`03001oogoo00aoo`03001oo`0004Qoo`<000Uoo`03001oogoo
00eoo`04001oogoo000POol0025oo`8001aoo`<000Qoo`8000]oo`04001oo`00000OOol30008Ool2
000>Ool00`00Ool00018Ool30009Ool00`00Oomoo`0=Ool01000Oomoo`0087oo000QOol2000KOol4
0008Ool2000;Ool01000Oomoo`007goo0`0027oo0P003Woo00<007oo0000B7oo0`002Goo00<007oo
Ool03Goo00@007ooOol0021oo`008Goo0P0047oo00<007ooOol027oo00@007oo000000Qoo`8000]o
o`04001oogoo000COol00`00Oomoo`08Ool40008Ool2000>Ool00`00Ool00018Ool30009Ool3000=
Ool01000Oomoo`0087oo000QOol2000?Ool2000:Ool01000Ool0000027oo0P002goo00@007ooOol0
01=oo`03001oogoo00Qoo`04001oo`000008Ool3000=Ool00`00Ool0000lOol00`00Oomoo`08Ool4
0009Ool2000>Ool01000Oomoo`0087oo000QOol2000?Ool2000:Ool01000Ool0000027oo0P002goo
00@007ooOol001=oo`03001oogoo00Qoo`04001oo`000008Ool3000=Ool00`00Ool0000lOol00`00
Oomoo`08Ool01000Ool0000027oo0`003Woo00<007ooOol00P007goo000QOol2000?Ool2000:Ool0
1000Ool0000027oo0P002goo00@007ooOol0019oo`8000Yoo`04001oo`000008Ool3000=Ool01@00
Ool007oo0000>Woo00<007ooOol027oo00@007oo000000Qoo`@000eoo`03001oogoo008001moo`00
8Goo0P003goo0P002Woo00@007oo000000Qoo`<000Yoo`04001oogoo000BOol2000:Ool01000Ool0
000027oo0`003Goo00D007oo001oo`0003Yoo`03001oogoo00Qoo`04001oo`000008Ool4000<Ool2
0002Ool2000OOol0025oo`8000moo`8000Yoo`04001oogoo0008Ool3000:Ool01000Oomoo`004Woo
0P002Woo00@007ooOol000Qoo`<000aoo`04001oogooOol2000jOol00`00Oomoo`08Ool01000Oomo
o`0027oo100037oo0P000Woo0P007goo000QOol2000?Ool2000:Ool01000Oomoo`0027oo0`002Woo
00<007ooOol00P004Goo0P002Woo00@007ooOol000Qoo`<000aoo`04001oogooOol2000jOol00`00
Oomoo`08Ool01000Oomoo`0027oo100037oo0P000Woo0P007goo000QOol2000?Ool30009Ool01000
Oomoo`0027oo0`002Woo00<007ooOol00P004Goo0`002Goo00@007ooOol000Qoo`<000aoo`04001o
ogooOol2000jOol00`00Oomoo`08Ool01000Oomoo`0027oo100037oo00@007ooOomoo`8001moo`00
8Goo0P0017oo0P002Goo0`002Goo00@007ooOol000Qoo`<000Yoo`03001oogoo008000Moo`03001o
ogoo00Moo`<000Uoo`04001oogoo0008Ool3000<Ool01000Oomoogoo0P00;goo00<007ooOol027oo
0P002Goo00@007ooOol000Qoo`@000aoo`04001oogooOol2000OOol0025oo`8000Aoo`8000Uoo`<0
00Uoo`06001oogoo001oo`001Goo10002Woo00<007ooOol00P001Woo0P002Goo0`002Goo00@007oo
Ool000Moo`04001oo`00000<Ool01000Oomoogoo0P00;goo00<007ooOol01goo100027oo00@007oo
Ool000Qoo`@000aoo`04001oogooOol2000OOol0025oo`8000Aoo`8000Uoo`<000Uoo`06001oogoo
001oo`001Goo00@007oo000000Yoo`03001oogoo00<000Eoo`8000Uoo`<000Uoo`06001oogoo001o
o`001Goo00@007oo000000]oo`8000=oo`8002moo`03001oogoo00Moo`@000Qoo`06001oogoo001o
o`001Woo100037oo00@007ooOomoo`8001moo`008Goo0P0017oo0P002Goo0`002Goo00H007ooOol0
07oo0005Ool01000Ool000002Goo0P000Woo0`001Goo0P002Goo0`002Goo00H007ooOol007oo0005
Ool01000Ool000002goo00<007ooOol00Woo0P00;goo00<007ooOol01goo100027oo00H007ooOol0
07oo0006Ool4000<Ool01000Oomoogoo0P007goo000QOol20004Ool20008Ool01000Ool000002Goo
00<007ooOol00`001Goo00@007oo000000Uoo`04001oogooOol30005Ool20009Ool30009Ool00`00
Oomoo`030005Ool01000Ool000002goo00<007ooOol00Woo0P00;goo00<007ooOol01goo100027oo
00H007ooOol007oo0006Ool4000<Ool01000Oomoogoo0P007goo000QOol20004Ool20008Ool00`00
Ool000020008Ool00`00Oomoo`030005Ool01000Ool000002Goo00@007ooOomoo`<000Eoo`8000Uo
o`@000Qoo`03001oogoo00<000Eoo`04001oo`00000;Ool00`00Oomoo`02Ool2000^Ool20009Ool0
1000Ool0000027oo00H007ooOol007oo0006Ool01000Ool000002goo0P000goo0P007goo000QOol0
0`00Ool00003Ool20008Ool01@00Ool007oo000027oo00<007ooOol00`001Goo00@007oo000000Uo
o`04001oogooOol30005Ool20008Ool00`00Ool000020008Ool00`00Oomoo`030005Ool01000Oomo
o`002goo00<007ooOol00Woo0P0097oo00<007ooOol01goo0P002Goo00@007oo000000Qoo`06001o
ogoo001oo`001Woo00@007ooOol000]oo`03001oogoo009oo`8001moo`008Goo0`000goo0P0027oo
00D007oo001oo`0000Moo`80009oo`<000Eoo`04001oogoo0008Ool20003Ool30005Ool20008Ool0
1@00Ool007oo000027oo00<007ooOol00`001Goo00@007ooOol000]oo`03001oogoo009oo`8002Ao
o`03001oogoo00Moo`8000Uoo`04001oo`000008Ool00`00Oomoo`030006Ool01000Oomoo`002goo
00<007ooOol00Woo0P007goo000QOol00`00Ool00003Ool20008Ool01@00Ool007oo00001goo0P00
0Woo0`001Goo00@007ooOol000Qoo`03001oogoo009oo`<000Eoo`8000Qoo`05001oo`00Ool00007
Ool20002Ool30005Ool01@00Oomoogoo00002Woo00<007ooOol00Woo0P0097oo0P0027oo0P002Goo
00@007oo000000Moo`80009oo`<000Eoo`05001oogooOol0000;Ool00`00Oomoo`02Ool2000OOol0
025oo`03001oo`00009oo`<000Qoo`04001oo`00Ool20006Ool01000Oomoogoo0`001Goo00@007oo
Ool000Qoo`03001oogoo009oo`<000Eoo`8000Qoo`05001oo`00Ool00007Ool01000Oomoogoo0`00
1Goo00D007ooOomoo`0000Yoo`03001oogoo009oo`8002Aoo`8000Qoo`8000Uoo`04001oo`000007
Ool20002Ool200000goo001oo`03Ool01@00Oomoogoo00002goo00<007ooOol00Woo00<007oo0000
7Woo000QOol00`00Ool00002Ool40007Ool01000Oomoogoo0P001Woo00@007ooOomoo`<000Eoo`04
001oogoo0008Ool00`00Oomoo`02Ool30004Ool40007Ool01000Oomoogoo0P001Woo00@007ooOomo
o`<000Eoo`05001oogooOol0000:Ool00`00Oomoo`02Ool2000TOol20008Ool30008Ool00`00Oomo
o`030005Ool20002Ool200000goo001oo`03Ool01@00Oomoogoo00002goo00<007ooOol00Woo00<0
07oo00007Woo000QOol00`00Ool00002Ool01000Ool000001goo00@007ooOomoo`8000Eoo`03001o
ogoo009oo`<000Eoo`04001oogoo0008Ool00`00Oomoo`02Ool00`00Ool00004Ool40007Ool01000
Oomoogoo0P001Goo00<007ooOol00Woo0`001Goo00D007ooOomoo`0000Yoo`03001oogoo009oo`80
01Yoo`03001oogoo00Moo`8000Qoo`<000Qoo`03001oogoo00<000Eoo`04001oogooOol200000goo
001oo`03Ool01000Oomoogoo0`002Goo00<007ooOol00Woo00<007oo00007Woo0002Ool20004Ool0
0`00Oomoo`03Ool20004Ool20004Ool20005Ool00`00Ool00002Ool01000Ool000001goo00@007oo
Oomoo`8000Eoo`03001oogoo009oo`<000Eoo`05001oogoo001oo`020005Ool00`00Oomoo`02Ool0
0`00Ool00004Ool01000Ool000001goo00@007ooOomoo`8000Eoo`03001oogoo009oo`<000Eoo`04
001oogooOol30008Ool00`00Oomoo`02Ool2000JOol00`00Oomoo`07Ool20008Ool40007Ool00`00
Oomoo`030005Ool01000Oomoogoo0P0000=oo`00Ool00goo00@007ooOomoo`<000Uoo`03001oogoo
009oo`03001oo`0001ioo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0002Ool01000Oomoo`000Woo
00@007ooOol000Aoo`03001oo`00009oo`04001oo`000007Ool01000Oomoogoo0`0017oo00<007oo
Ool00Woo0`001Goo00D007ooOol007oo008000Eoo`03001oogoo009oo`03001oo`0000Aoo`04001o
o`000007Ool01000Oomoogoo0`0017oo00<007ooOol00Woo0P0000=oo`00Ool00goo00@007ooOomo
o`<000Qoo`03001oogoo009oo`03001oo`0001Uoo`03001oogoo00Moo`8000Qoo`@000Ioo`04001o
ogooOol30004Ool20003Ool200000goo001oo`03Ool01000Oomoogoo0`002Goo00<007ooOol00Woo
00<007oo00007Woo00001Goo001oogoo000027oo00@007ooOol0009oo`04001oogoo0005Ool00`00
Oomoo`02Ool30002Ool01000Ool000001goo00@007ooOomoo`<000Aoo`03001oogoo009oo`800003
Ool007oo00=oo`04001oogooOol30005Ool00`00Oomoo`02Ool00`00Ool00004Ool01000Ool00000
1goo00@007ooOomoo`<000Aoo`03001oogoo009oo`800003Ool007oo009oo`8000=oo`<000Qoo`03
001oogoo009oo`03001oo`0001Uoo`03001oogoo00Ioo`<000Qoo`04001oo`000006Ool01000Oomo
ogoo0`0017oo00<007ooOol00Woo0P0000=oo`00Ool00Woo0P000goo0`002Goo00<007ooOol00Woo
00<007oo00007Woo00001Goo001oogoo000027oo00@007ooOol0009oo`04001oogoo0003Ool20005
Ool00`00Ool00002Ool01000Ool000001goo00L007ooOomoo`00Ool00004Ool00`00Oomoo`02Ool2
00000goo001oo`02Ool20003Ool30005Ool00`00Oomoo`02Ool00`00Ool00004Ool01000Ool00000
1goo00@007ooOomoo`<000Aoo`03001oogoo009oo`800003Ool007oo009oo`8000=oo`<000Qoo`03
001oogoo009oo`03001oo`0001Uoo`03001oogoo00Ioo`<000Moo`03001oogoo008000Ioo`04001o
ogooOol30004Ool00`00Oomoo`02Ool200000goo001oo`02Ool20003Ool30009Ool00`00Oomoo`04
Ool00`00Oomoo`0LOol00005Ool007ooOol00008Ool01000Oomoo`000Woo00@007ooOol000Eoo`03
001oogoo009oo`03001oo`00009oo`04001oo`000006Ool20003Ool00`00Ool00004Ool00`00Oomo
o`02Ool200000goo001oo`02Ool20003Ool00`00Ool00005Ool00`00Oomoo`02Ool00`00Ool00004
Ool01000Ool000001goo00L007ooOomoo`00Ool00004Ool00`00Oomoo`02Ool200000goo001oo`02
Ool20003Ool00`00Ool00008Ool00`00Oomoo`04Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool00`00
Oomoo`06Ool30007Ool00`00Oomoo`020006Ool01000Oomoogoo0`0017oo00<007ooOol00Woo0P00
00=oo`00Ool00Woo0P000goo0P0000=oo`00Ool01goo00<007ooOol017oo00<007ooOol077oo0000
1Goo001oogoo000027oo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`0017oo00<007oo
00000Woo00@007oo000000Ioo`8000=oo`03001oo`0000Aoo`03001oogoo009oo`800003Ool007oo
009oo`8000=oo`03001oo`0000Eoo`03001oogoo009oo`03001oo`0000Aoo`04001oo`000006Ool2
0003Ool00`00Ool00004Ool00`00Oomoo`02Ool200000goo001oo`02Ool20003Ool00`00Ool00007
Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool20008Ool30007Ool00`00Oomoo`02
0005Ool20003Ool30004Ool00`00Oomoo`02Ool200000goo001oo`02Ool00`00Oomoo`02Ool20000
0goo001oo`07Ool00`00Oomoo`04Ool00`00Oomoo`0LOol0009oo`8000Yoo`8000Aoo`8000Aoo`80
00Eoo`03001oo`00009oo`04001oo`000006Ool20003Ool00`00Ool00004Ool00`00Oomoo`02Ool2
000017oo001oogoo0P0017oo00<007oo00001Goo00<007ooOol00Woo00<007oo000017oo00D007oo
001oo`0000Eoo`8000=oo`03001oo`0000Aoo`03001oogoo009oo`800004Ool007ooOol20004Ool0
0`00Ool00007Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool20008Ool01000Ool0
00001Woo00<007ooOol00P001Goo0P000goo0`0017oo00<007ooOol00Woo0P0000=oo`00Ool00Woo
00<007ooOol00Woo0P0000=oo`00Ool01goo00<007ooOol017oo00<007ooOol077oo000QOol00`00
Ool00002Ool01000Oomoo`001Woo0P000goo00<007oo000017oo00<007ooOol00Woo00@007ooOol0
009oo`03001oogoo00=oo`03001oo`0000Aoo`8000Aoo`03001oo`0000Aoo`05001oogooOol00005
Ool20003Ool00`00Ool00004Ool00`00Oomoo`02Ool01000Oomoo`000Woo00<007ooOol00goo00<0
07oo00001goo00<007ooOol01Goo00<007ooOol037oo0P0027oo0P0027oo00@007oo000000Ioo`05
001oogooOol00005Ool20003Ool30004Ool00`00Oomoo`02Ool200000goo001oo`02Ool00`00Oomo
o`02Ool200000goo001oo`07Ool00`00Oomoo`04Ool00`00Oomoo`0LOol0025oo`03001oo`00009o
o`04001oogoo0005Ool30003Ool00`00Ool00004Ool00`00Oomoo`02Ool01000Oomoo`000Woo00<0
07ooOol00goo00<007oo000017oo00<007ooOol00goo00<007oo000017oo00D007ooOomoo`0000Eo
o`8000=oo`03001oo`0000Aoo`03001oogoo009oo`04001oogoo0002Ool00`00Oomoo`03Ool01000
Oomoo`001Woo00<007ooOol01Goo00<007ooOol00goo00<007ooOol01Woo0P0027oo0P0027oo00@0
07oo000000Ioo`05001oogooOol00005Ool20003Ool30004Ool00`00Oomoo`02Ool200000goo001o
o`02Ool00`00Oomoo`02Ool01000Oomoo`0027oo00<007ooOol017oo00<007ooOol077oo000QOol0
0`00Ool00002Ool01P00Oomoo`00Ool000=oo`03001oogoo00=oo`03001oo`0000Aoo`03001oogoo
009oo`04001oogoo0002Ool00`00Oomoo`03Ool00`00Ool00004Ool00`00Oomoo`03Ool00`00Ool0
0004Ool01@00Oomoogoo000017oo0P0017oo00<007oo000017oo00<007ooOol00Woo00@007ooOol0
009oo`03001oogoo00=oo`04001oogoo0006Ool00`00Oomoo`05Ool00`00Oomoo`03Ool00`00Oomo
o`06Ool20008Ool20008Ool01000Ool000001Woo00D007ooOomoo`0000Eoo`03001oogoo009oo`@0
00=oo`03001oogoo009oo`800004Ool007ooOol20004Ool01000Oomoo`001goo00<007ooOol01Goo
00<007ooOol077oo000QOol30002Ool01000Oomoogoo0P000goo00<007ooOol00goo00<007oo0000
0goo0P0017oo00@007ooOol0009oo`03001oogoo00=oo`03001oo`0000Aoo`03001oogoo00=oo`03
001oo`0000=oo`8000=oo`8000=oo`03001oogoo00=oo`03001oo`0000=oo`03001oogoo00=oo`04
001oogoo0002Ool00`00Oomoo`03Ool01000Oomoo`001Woo00<007ooOol01Goo00<007ooOol00Woo
0P0027oo0P0027oo00<007oo00001goo00@007oo000000Eoo`8000=oo`<000=oo`03001oogoo009o
o`800003Ool007oo009oo`03001oogoo009oo`800005Ool007ooOol00005Ool01000Oomoo`001goo
00<007ooOol01Goo00<007ooOol077oo000QOol01000Ool007oo0P000goo0`000Woo00<007ooOol0
0goo00<007oo00000goo00<007ooOol00goo00@007ooOol0009oo`03001oogoo00=oo`03001oo`00
00Aoo`03001oogoo00Ioo`03001oogoo008000=oo`<0009oo`03001oogoo00=oo`03001oo`0000=o
o`03001oogoo00=oo`04001oogoo0002Ool00`00Oomoo`03Ool01000Oomoo`001Woo00<007ooOol0
1Goo00<007ooOol00Woo0P0027oo0P0027oo00<007oo00001goo00@007oo000000Eoo`8000=oo`<0
00=oo`03001oogoo009oo`04001oogoo0003Ool00`00Oomoo`02Ool200001Goo001oogoo00001Goo
00@007ooOol000Moo`03001oogoo00Eoo`03001oogoo00eoo`03001oogoo00aoo`008Goo00<007oo
00000`000goo0`000Woo00<007ooOol00goo00<007oo00000goo00<007ooOol01Woo00@007ooOol0
00Eoo`03001oo`0000Aoo`03001oogoo00Ioo`03001oo`00008000=oo`<0009oo`03001oogoo00=o
o`03001oo`0000=oo`03001oogoo00=oo`04001oogoo0002Ool00`00Oomoo`03Ool01000Oomoo`00
1Woo00<007ooOol01Goo00<007ooOol00Woo0P0027oo0P0027oo00<007oo00001goo00@007oo0000
00Eoo`8000=oo`<0009oo`03001oogoo00=oo`04001oogoo0003Ool00`00Oomoo`02Ool01000Oomo
o`000Woo00<007ooOol00goo00@007ooOol000Moo`03001oogoo00Eoo`03001oogoo00eoo`03001o
ogoo00aoo`008Goo00<007oo00000`000goo00<007oo00000Woo00<007ooOol00goo00<007oo0000
0goo00<007ooOol01Woo00@007ooOol000Eoo`04001oogoo0003Ool00`00Oomoo`06Ool00`00Ool0
00020003Ool30002Ool00`00Oomoo`03Ool01000Oomoo`000Woo00<007ooOol01Woo00@007ooOol0
00Eoo`04001oogoo0006Ool00`00Oomoo`05Ool00`00Oomoo`02Ool20007Ool30007Ool00`00Oomo
o`020006Ool01000Ool000001Goo0P000goo0`000Woo00<007ooOol00goo00@007ooOol0009oo`03
001oogoo00Ioo`04001oogoo0005Ool01000Oomoo`001goo00<007ooOol01Goo00<007ooOol03Goo
00<007ooOol037oo000QOol00`00Ool000020004Ool00`00Ool00002Ool00`00Oomoo`03Ool01000
Oomoo`000Woo00<007ooOol01Woo00@007ooOol000Eoo`04001oogoo0003Ool00`00Oomoo`06Ool0
0`00Ool000020003Ool30002Ool00`00Oomoo`03Ool01000Oomoo`000Woo00<007ooOol01Woo00@0
07ooOol000Eoo`04001oogoo0006Ool00`00Oomoo`05Ool00`00Oomoo`02Ool20007Ool30007Ool0
0`00Oomoo`020006Ool01P00Oomoo`00Ool000=oo`8000=oo`<0009oo`03001oogoo00=oo`04001o
ogoo0002Ool00`00Oomoo`06Ool01000Oomoo`0027oo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol00goo00<007ooOol01Woo0P003Woo000QOol00`00Ool000020004Ool00`00Ool00002Ool0
0`00Oomoo`06Ool01000Oomoo`0027oo00@007ooOol000Qoo`05001oogooOol00008Ool01000Ool0
000017oo00<007oo00000Woo00<007ooOol01Woo00@007ooOol000Qoo`04001oogoo0008Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`02Ool20007Ool30007Ool00`00Oomoo`020004Ool3
0002Ool00`00Ool00002Ool00`00Ool00003Ool30002Ool00`00Oomoo`06Ool01000Oomoo`0027oo
00@007ooOol000Qoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Io
o`8000ioo`008Goo00@007ooOol000Eoo`03001oo`00009oo`03001oogoo00Ioo`04001oogoo0008
Ool01000Ool0000027oo00D007ooOomoo`0000Qoo`03001oo`0000Eoo`03001oo`00009oo`03001o
ogoo00Ioo`04001oogoo0008Ool01000Oomoo`0027oo00<007ooOol017oo00<007ooOol01Goo00@0
07ooOomoo`<000Moo`03001oo`0000Moo`03001oogoo008000Aoo`8000=oo`<0009oo`03001oogoo
00=oo`<0009oo`03001oogoo00Ioo`04001oogoo0009Ool00`00Ool00008Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`03Ool00`00Oomoo`06Ool2000>Ool0025oo`8000Moo`03001oo`00
009oo`03001oogoo00Ioo`04001oogoo0008Ool00`00Ool00009Ool01@00Oomoogoo000027oo00<0
07oo00001Goo00<007oo00000Woo00<007ooOol01Woo00@007ooOol000Qoo`03001oo`0000Uoo`03
001oogoo00Aoo`03001oogoo00Eoo`04001oogooOol30007Ool00`00Ool00007Ool00`00Oomoo`02
0004Ool20003Ool30002Ool00`00Oomoo`03Ool30002Ool00`00Oomoo`06Ool01000Oomoo`002Goo
00<007oo000027oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol00goo00<007ooOol01Woo
0P003Woo000QOol00`00Oomoo`06Ool01000Ool007oo0P0027oo00@007ooOol000Qoo`03001oo`00
00Uoo`03001oogoo008000Qoo`03001oo`0000Eoo`03001oo`00009oo`03001oogoo00Ioo`04001o
ogoo0008Ool00`00Ool00009Ool00`00Oomoo`04Ool00`00Oomoo`05Ool01000Oomoogoo0`001goo
00@007ooOol000Eoo`80009oo`@0009oo`8000=oo`800004Ool007oo0005Ool30002Ool00`00Oomo
o`06Ool01000Oomoo`002Goo00<007oo00002Goo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool00Woo0P001goo0`003Woo000QOol00`00Oomoo`06Ool01@00Ool007oo00002Goo00@007ooOol0
00Qoo`03001oo`0000Uoo`04001oogoo0009Ool00`00Ool00005Ool00`00Ool00002Ool00`00Oomo
o`06Ool01000Ool0000027oo00<007oo00002Goo00<007ooOol00goo00<007ooOol01Woo00L007oo
Oomoo`00Ool00007Ool01000Oomoo`001Goo0P000goo0`000Woo0P000goo0P0000Aoo`00Ool000Eo
o`06001oogoo001oo`0027oo00@007ooOol000Uoo`<000Uoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo009oo`8000Moo`<000ioo`008Goo00<007ooOol01Woo00D007oo001oo`0000Uoo`03
001oo`0000Yoo`8000Uoo`04001oogoo0009Ool00`00Ool00005Ool01000Ool007oo0P0027oo00<0
07oo00002Woo0P002Goo00<007ooOol00goo00<007ooOol01Woo00L007ooOomoo`00Ool00007Ool0
0`00Oomoo`020004Ool20003Ool30002Ool20003Ool2000017oo001oo`001Goo00H007ooOol007oo
0008Ool01000Oomoo`002Goo0P002Woo00<007ooOol017oo00<007ooOol01Woo00@007ooOomoo`80
00Moo`<000ioo`008Goo00<007ooOol01Woo00D007oo001oo`0000Uoo`03001oo`0000Yoo`8000Uo
o`04001oogoo0009Ool30005Ool01@00Ool007oo00002Goo00<007oo00002Woo0P002Goo00<007oo
Ool00goo00<007ooOol01Woo00L007ooOomoo`00Ool00007Ool00`00Oomoo`020004Ool20003Ool3
0002Ool00`00Oomoo`02Ool2000017oo001oo`001Goo00H007ooOol007oo0008Ool01000Oomoo`00
2Goo0P002Woo00<007ooOol017oo00<007ooOol01Woo00@007ooOomoo`8000Moo`<000ioo`008Goo
00<007ooOol01Woo00D007oo001oo`0000Uoo`03001oo`0000Yoo`8000Uoo`04001oogoo0009Ool2
0006Ool01@00Ool007oo00002Goo00<007oo00002Woo0P002Goo00<007ooOol00goo00<007ooOol0
1Woo00D007ooOomoo`00009oo`03001oogoo00=oo`80009oo`@00004Ool007oo0003Ool300000goo
00000004Ool2000017oo001oo`001Goo00H007ooOol007oo0008Ool00`00Ool0000:Ool2000:Ool0
0`00Oomoo`04Ool00`00Oomoo`06Ool01000Oomoogoo0P001goo00<007oo00003Woo000QOol00`00
Oomoo`06Ool01@00Ool007oo00002Goo00<007oo00002Woo0P002Goo00@007ooOol000Uoo`8000Io
o`05001oo`00Ool00009Ool00`00Ool0000:Ool20009Ool00`00Oomoo`03Ool00`00Oomoo`07Ool0
1000Oomoo`000Woo00<007ooOol00goo0P000Woo100000Aoo`00Ool000=oo`<00003Ool007oo00Ao
o`800004Ool007oo0005Ool01P00Oomoo`00Ool000Qoo`03001oo`0000Yoo`8000Yoo`03001oogoo
00Aoo`03001oogoo00Ioo`03001oogoo00<000Moo`04001oogoo000=Ool0025oo`03001oogoo00Io
o`05001oo`00Ool00009Ool00`00Ool0000:Ool20009Ool01000Oomoo`002Goo0P001Woo00D007oo
001oo`0000Uoo`03001oo`0000Yoo`8000Uoo`03001oogoo00=oo`03001oogoo00Moo`04001oogoo
0002Ool00`00Oomoo`02Ool30003Ool3000017oo001oo`000goo0`0000=oo`00Ool017oo0P0000Ao
o`00Ool000Eoo`03001oogoo008000Uoo`03001oo`0000Yoo`8000Yoo`03001oogoo00=oo`03001o
ogoo00Moo`03001oogoo00800003Ool007oo00Eoo`04001oogoo0005Ool00`00Oomoo`05Ool0025o
o`8000Uoo`03001oo`0000Uoo`03001oo`0000Yoo`03001oogoo00Qoo`04001oo`00000:Ool00`00
Oomoo`07Ool20009Ool00`00Ool0000:Ool00`00Oomoo`08Ool00`00Oomoo`03Ool00`00Oomoo`07
Ool01000Ool000000Woo100000Aoo`00000000=oo`<00003Ool007oo00Aoo`<00003Ool007oo00Ao
o`800004Ool007oo0008Ool20009Ool00`00Ool0000:Ool2000:Ool00`00Oomoo`03Ool00`00Oomo
o`07Ool01000Oomoo`000Woo00<007ooOol017oo00@007ooOol000Aoo`<000Ioo`008Goo00<007oo
Ool027oo00<007oo00002Goo00<007oo00005Goo00<007oo00005Goo0P002Goo00<007oo00005Goo
00<007ooOol00goo00<007ooOol01goo10000Woo100000Aoo`00000000=oo`<00003Ool007oo00Ao
o`<00003Ool007oo00Aoo`800004Ool007oo0008Ool20009Ool00`00Ool0000FOol00`00Oomoo`03
Ool00`00Oomoo`07Ool01000Oomoo`000Woo00<007ooOol017oo00D007ooOol007oo00800003Ool0
000000Moo`008Goo00<007ooOol027oo00<007oo00002Goo00<007oo00005Goo00<007oo00005Goo
0P002Goo00<007oo00005Woo00<007ooOol00Woo00<007ooOol01goo10000Woo100000Aoo`000000
00=oo`<00003Ool007oo00Aoo`800003Ool0000000Eoo`800004Ool007oo0008Ool20009Ool00`00
Ool0000FOol00`00Oomoo`03Ool00`00Oomoo`07Ool01000Oomoo`000Woo00<007ooOol00goo0P00
0Woo100000=oo`00Ool01goo000QOol00`00Oomoo`08Ool00`00Ool00009Ool00`00Ool0000EOol0
0`00Ool0000EOol20009Ool00`00Ool0000FOol01@00Oomoogoo00002Woo10000goo0`0000Aoo`00
000000=oo`<00003Ool007oo00Aoo`800003Ool0000000Eoo`800004Ool007oo0008Ool20009Ool0
0`00Ool0000FOol00`00Oomoo`03Ool00`00Oomoo`07Ool01000Oomoo`000Woo00<007ooOol00Woo
0`000Woo100000=oo`00Ool01goo000QOol00`00Oomoo`09Ool20009Ool00`00Ool0000EOol00`00
Ool0000EOol20009Ool00`00Ool0000FOol01@00Oomoogoo00002Woo10000goo0`0000=oo`00Ool0
17oo0`0000=oo`00Ool017oo0P0000=oo`0000001Woo00@007oo000000Uoo`8000Uoo`03001oo`00
01Ioo`03001oogoo00=oo`03001oogoo00Moo`04001oogoo0002Ool01@00Ool00000Ool00`000Woo
100000=oo`00Ool01goo000QOol00`00Oomoo`09Ool20009Ool2000FOol00`00Ool0000EOol20009
Ool2000GOol01@00Oomoogoo00002Woo10000goo0`0000=oo`00Ool017oo0`0000=oo`00Ool017oo
0P0000=oo`0000001Woo00@007oo000000Uoo`8000Uoo`03001oo`0001Ioo`03001oogoo00=oo`03
001oogoo00Moo`04001oo`000002Ool4000017oo000000000goo0`0000=oo`00Ool01goo000QOol0
0`00Oomoo`09Ool20009Ool2000FOol00`00Ool0000EOol20009Ool2000GOol01@00Oomoogoo0000
2Woo10000goo0`0000=oo`00Ool017oo0`0000=oo`00Ool017oo00<007ooOol00P001Woo00@007oo
000000Uoo`8000Yoo`8001Ioo`03001oogoo00=oo`03001oogoo00Moo`@0009oo`@00004Ool00000
0003Ool300000goo001oo`07Ool0025oo`03001oogoo00Uoo`8000Uoo`8001Ioo`03001oo`0001Eo
o`8000Uoo`8001Moo`05001oogooOol0000:Ool00`00Ool00004Ool300000goo001oo`04Ool01@00
Ool007oo00001Goo00<007ooOol00P0027oo0P002Goo0P002Woo0P005Woo00<007ooOol00Woo00<0
07ooOol027oo10000Woo100000Aoo`00000000=oo`<00003Ool007oo00Moo`008Goo0P002Woo0P00
2Goo0P005Woo00<007oo00005Goo0P002Goo0P005goo00<007ooOol00P004Goo0`0000=oo`00Ool0
17oo00D007oo001oo`0000Eoo`03001oogoo008000Qoo`8000Uoo`8000Yoo`8001Ioo`03001oogoo
009oo`03001oogoo00Qoo`@000=oo`<00004Ool000000003Ool300000goo001oo`07Ool0025oo`03
001oogoo00Uoo`8000Uoo`8001Ioo`03001oo`0001Eoo`8000Uoo`8001Moo`04001oogoo000BOol0
1@00Ool007oo00001Goo00<007ooOol00P001Goo00<007ooOol00P0027oo0P002Goo0P002Woo0P00
5Woo00<007ooOol00Woo00<007ooOol027oo10000goo0`0000=oo`00Ool017oo0`0000=oo`00Ool0
1goo000QOol00`00Oomoo`09Ool20009Ool2000FOol2000FOol20009Ool2000GOol01000Oomoo`00
4Woo00D007oo001oo`0000Eoo`03001oogoo008000Eoo`03001oogoo008000Qoo`8000Uoo`8000Yo
o`8001Ioo`03001oogoo009oo`03001oogoo00Yoo`8000=oo`<00003Ool007oo00Aoo`<00003Ool0
07oo00Moo`008Goo00<007ooOol02Goo0P002Goo0P005Woo0P005Woo0P002Goo0P005goo00@007oo
Ool0019oo`05001oo`00Ool00005Ool00`00Oomoo`020008Ool20008Ool20009Ool2000:Ool00`00
Oomoo`0EOol00`00Oomoo`02Ool00`00Oomoo`0:Ool20003Ool300000goo001oo`04Ool300000goo
001oo`07Ool0025oo`03001oogoo00Uoo`8000Uoo`8001Ioo`8001Ioo`8000Uoo`8001Moo`04001o
ogoo000BOol01@00Ool007oo00001Goo00<007ooOol00P0027oo0P0027oo0P002Goo0P002Woo00<0
07ooOol05Goo00@007ooOomoo`8000aoo`8000=oo`<00003Ool007oo00Aoo`<00003Ool007oo00Mo
o`000Woo0P0017oo00<007ooOol00goo0P0017oo0P001Goo00<007ooOol00goo00<007ooOol02Goo
0P002Goo0P005Woo0P005Woo0P002Goo0P005goo00@007oo0000019oo`05001oo`00Ool00005Ool0
0`00Oomoo`020008Ool20008Ool20009Ool2000:Ool00`00Oomoo`0EOol01@00Oomoogoo00004Woo
0`0000=oo`00Ool017oo00D007oo001oo`0000Qoo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0002
Ool01000Oomoo`0017oo00<007ooOol00goo00<007ooOol02Goo00<007ooOol027oo0P005Woo0P00
5Woo0P002Goo0P005goo00<007oo00004goo00D007oo001oo`0000Eoo`03001oogoo008000Qoo`80
00Qoo`8000Uoo`8000Yoo`03001oogoo01Eoo`05001oogooOol0000BOol300000goo001oo`04Ool0
1@00Ool007oo000027oo00001Goo001oogoo000027oo00@007ooOol0009oo`05001oogoo001oo`05
0004Ool2000:Ool00`00Oomoo`08Ool2000FOol2000FOol20009Ool2000GOol00`00Ool0000COol0
0`00Oomoo`020008Ool20008Ool20008Ool20009Ool2000:Ool00`00Oomoo`0EOol01@00Oomoogoo
00004Woo0`0000=oo`00Ool017oo00<007ooOol00P0027oo00001Goo001oogoo000027oo00@007oo
Ool0009oo`06001oogoo001oo`000Woo00<007ooOol00goo00<007ooOol02Goo00<007ooOol027oo
0P005Woo0P005Woo0P002Goo0P005goo00<007oo00004goo00@007ooOol000Uoo`03001oogoo00Mo
o`8000Qoo`8000Uoo`8000Yoo`03001oogoo01Eoo`05001oogooOol0000BOol200000goo00000005
Ool00`00Oomoo`020008Ool00005Ool007ooOol00008Ool01000Oomoo`000Woo00@007ooOol0009o
o`03001oo`0000Eoo`03001oogoo00Uoo`03001oogoo00Qoo`8001Ioo`8001Ioo`03001oogoo00Qo
o`8001Moo`03001oo`0001=oo`04001oogoo0009Ool00`00Oomoo`07Ool20008Ool20009Ool2000:
Ool00`00Oomoo`0EOol01@00Oomoogoo00004Woo00<007ooOol00P001Goo00<007ooOol00P0027oo
00001Goo001oogoo000027oo00@007ooOol0009oo`04001oogoo0003Ool20005Ool00`00Oomoo`09
Ool00`00Oomoo`08Ool2000FOol2000FOol00`00Oomoo`08Ool2000GOol00`00Ool0000FOol00`00
Oomoo`07Ool00`00Oomoo`07Ool20008Ool20009Ool2000:Ool00`00Oomoo`0EOol01@00Oomoogoo
00004Woo00<007ooOol00P001Goo00<007ooOol00P0027oo0002Ool2000:Ool20004Ool20005Ool0
0`00Oomoo`03Ool00`00Oomoo`09Ool00`00Oomoo`08Ool2000FOol2000FOol00`00Oomoo`08Ool2
000GOol2000GOol00`00Oomoo`07Ool00`00Oomoo`07Ool20008Ool20009Ool2000:Ool00`00Oomo
o`0EOol01@00Oomoogoo00004Woo00<007ooOol00P001Goo00@007ooOol000Uoo`008Goo00<007oo
Ool02Goo00<007ooOol027oo0P005Woo0P005Woo00<007ooOol027oo0P005goo0P005goo00<007oo
Ool01goo00<007ooOol01goo0P0027oo0P002Goo0P002Woo00<007ooOol05Woo00@007ooOol0019o
o`03001oogoo008000Eoo`04001oogoo0009Ool0025oo`03001oogoo00Uoo`03001oogoo00Qoo`80
01Ioo`8001Ioo`03001oogoo00Qoo`8001Moo`8001Moo`03001oogoo00Moo`03001oogoo00Moo`80
00Qoo`8000Uoo`8000Yoo`03001oogoo01Ioo`03001oo`0001=oo`03001oogoo008000Qoo`03001o
ogoo00Moo`008Goo00<007ooOol02Goo00<007ooOol027oo0P005Woo0P005Woo00<007ooOol027oo
0P005goo0P005goo00<007ooOol01goo00<007ooOol01goo0P0027oo0P002Goo0P002Woo00<007oo
Ool05Woo00<007oo00004goo00<007ooOol00P0027oo00<007ooOol01goo000QOol2000:Ool00`00
Oomoo`08Ool2000FOol2000FOol00`00Oomoo`08Ool2000GOol2000GOol00`00Oomoo`07Ool00`00
Oomoo`07Ool20009Ool00`00Oomoo`07Ool2000:Ool00`00Oomoo`0FOol00`00Ool0000COol01000
Oomoo`002Goo00<007ooOol01goo000QOol00`00Oomoo`09Ool00`00Oomoo`08Ool2000FOol2000F
Ool00`00Oomoo`08Ool2000GOol2000GOol00`00Oomoo`07Ool00`00Oomoo`07Ool20009Ool00`00
Oomoo`07Ool2000:Ool00`00Oomoo`0FOol00`00Ool0000FOol00`00Oomoo`07Ool00`00Oomoo`07
Ool0025oo`03001oogoo00Uoo`03001oogoo00Qoo`8001Moo`03001oogoo01Aoo`03001oogoo00Qo
o`8001Moo`8001Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Mo
o`8000Yoo`03001oogoo01Ioo`03001oo`0001Ioo`03001oogoo00Moo`03001oogoo00Moo`008Goo
00<007ooOol02Goo00<007ooOol027oo0P005goo00<007ooOol057oo00<007ooOol027oo0P005goo
0P005goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo0P002Woo
00<007ooOol05Woo00<007oo00005Woo00<007ooOol01goo00<007ooOol01goo000QOol00`00Oomo
o`09Ool00`00Oomoo`08Ool2000GOol00`00Oomoo`0DOol00`00Oomoo`08Ool2000GOol2000GOol0
0`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool2000:Ool00`00Oomo
o`0FOol00`00Ool0000FOol00`00Oomoo`07Ool00`00Oomoo`07Ool0025oo`03001oogoo00Uoo`03
001oogoo00Qoo`8001Moo`03001oogoo01Aoo`03001oogoo00Qoo`8001Moo`8001Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Uoo`03001oogoo
01Ioo`03001oo`0001Ioo`03001oogoo00Moo`03001oogoo00Moo`008Goo00<007ooOol02Goo00<0
07ooOol027oo0P005goo00<007ooOol057oo00<007ooOol027oo0P005goo0P005goo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo00<007ooOol02Goo00<007ooOol0
5Woo00<007oo00005Woo00<007ooOol01goo00<007ooOol01goo000QOol2000:Ool00`00Oomoo`08
Ool2000GOol00`00Oomoo`0DOol00`00Oomoo`09Ool00`00Oomoo`0EOol2000GOol00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`09Ool00`00Oomoo`0F
Ool00`00Ool0000FOol00`00Oomoo`07Ool00`00Oomoo`07Ool0025oo`03001oogoo00Uoo`03001o
ogoo00Qoo`8001Moo`03001oogoo01Aoo`03001oogoo00Uoo`03001oogoo01Eoo`8001Moo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Uoo`03001o
ogoo01Ioo`03001oo`0001Ioo`03001oogoo00Moo`03001oogoo00Moo`008Goo00<007ooOol02Goo
00<007ooOol027oo0P005goo00<007ooOol057oo00<007ooOol02Goo00<007ooOol05Goo0P005goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo00<007ooOol02Goo
00<007ooOol05Woo00<007oo00005Woo00<007ooOol01goo00<007ooOol01goo000QOol00`00Oomo
o`09Ool00`00Oomoo`08Ool2000GOol00`00Oomoo`0DOol00`00Oomoo`09Ool00`00Oomoo`0EOol2
000GOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomo
o`09Ool00`00Oomoo`0FOol00`00Ool0000FOol00`00Oomoo`07Ool00`00Oomoo`07Ool0025oo`03
001oogoo00Uoo`03001oogoo00Qoo`8001Moo`03001oogoo01Aoo`03001oogoo00Uoo`03001oogoo
01Eoo`8001Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`03
001oogoo00Uoo`03001oogoo01Ioo`03001oo`0001Ioo`03001oogoo00Moo`03001oogoo00Moo`00
8Goo00<007ooOol02Goo00<007ooOol027oo0P005goo00<007ooOol057oo00<007ooOol02Goo00<0
07ooOol05Goo0P005goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol0
1goo00<007ooOol02Goo00<007ooOol05Woo00<007oo00005Woo00<007ooOol01goo00<007ooOol0
1goo000QOol00`00Oomoo`09Ool00`00Oomoo`08Ool2000GOol00`00Oomoo`0DOol00`00Oomoo`09
Ool00`00Oomoo`0EOol2000GOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00
Oomoo`07Ool00`00Oomoo`09Ool00`00Oomoo`0FOol00`00Ool0000FOol00`00Oomoo`07Ool00`00
Oomoo`07Ool0025oo`03001oogoo00Uoo`03001oogoo00Qoo`8001Moo`03001oogoo01Aoo`03001o
ogoo00Uoo`03001oogoo01Eoo`8001Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Qo
o`03001oogoo00Moo`03001oogoo00Uoo`03001oogoo01Ioo`03001oo`0001Ioo`03001oogoo00Mo
o`03001oogoo00Moo`008Goo0P002Woo00<007ooOol027oo0P005goo00<007ooOol057oo00<007oo
Ool02Goo00<007ooOol05Goo0P005goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo
00<007ooOol01goo00<007ooOol02Goo00<007ooOol05Woo00<007oo00005Woo00<007ooOol01goo
00<007ooOol01goo000QOol00`00Oomoo`09Ool00`00Oomoo`08Ool2000GOol00`00Oomoo`0DOol0
0`00Oomoo`09Ool00`00Oomoo`0EOol2000GOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomo
o`08Ool00`00Oomoo`07Ool00`00Oomoo`09Ool00`00Oomoo`0FOol2000GOol00`00Oomoo`07Ool0
0`00Oomoo`07Ool0025oo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo01Eoo`03001oogoo
01Aoo`03001oogoo00Uoo`03001oogoo01Eoo`03001oogoo01Ioo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Qoo`03001oogoo01=oo`03001oogoo01Ioo`8001Moo`03001oogoo00Moo`03
001oogoo00Moo`008Goo00<007ooOol02Goo00<007ooOol08Goo00<007ooOol057oo00<007ooOol0
2Goo00<007ooOol05Goo00<007ooOol05Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
27oo00<007ooOol04goo00<007ooOol05Woo0P005goo00<007ooOol01goo00<007ooOol01goo000Q
Ool00`00Oomoo`09Ool00`00Oomoo`0QOol00`00Oomoo`0POol00`00Oomoo`0EOol00`00Oomoo`0F
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`0NOol00`00Oomoo`0FOol2000GOol00`00
Oomoo`07Ool00`00Oomoo`07Ool0025oo`03001oogoo00Uoo`03001oogoo025oo`03001oogoo021o
o`03001oogoo01Eoo`03001oogoo01Ioo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo01io
o`03001oogoo01Ioo`8001Moo`03001oogoo00Moo`03001oogoo00Moo`008Goo00<007ooOol02Goo
00<007ooOol08Goo00<007ooOol087oo00<007ooOol05Goo00<007ooOol05Woo00<007ooOol01goo
00<007ooOol01goo00<007ooOol07Woo00<007ooOol05Woo0P005goo00<007ooOol01goo00<007oo
Ool01goo000QOol00`00Oomoo`09Ool00`00Oomoo`0QOol00`00Oomoo`0hOol00`00Oomoo`0FOol0
0`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`0NOol00`00Oomoo`0FOol2000GOol00`00Oomo
o`07Ool00`00Oomoo`07Ool0025oo`8000Yoo`03001oogoo025oo`03001oogoo03Qoo`03001oogoo
01Ioo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo01ioo`03001oogoo01Ioo`8001Moo`03
001oogoo00Moo`03001oogoo00Moo`008Goo00<007ooOol02Goo00<007ooOol08Goo00<007ooOol0
>7oo00<007ooOol05Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol07Woo00<007ooOol0
5Woo0P005goo00<007ooOol01goo00<007ooOol01goo000QOol00`00Oomoo`09Ool00`00Oomoo`1L
Ool00`00Oomoo`0FOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`0gOol2000GOol00`00
Oomoo`07Ool00`00Oomoo`07Ool0025oo`03001oogoo00Uoo`03001oogoo05aoo`03001oogoo02Yo
o`03001oogoo03Moo`8001Moo`03001oogoo00Moo`03001oogoo00Moo`008Goo00<007ooOol02Goo
00<007ooOol0G7oo00<007ooOol0:Woo00<007ooOol0=goo0P005goo00<007ooOol01goo00<007oo
Ool01goo0002Ool20004Ool00`00Oomoo`03Ool20004Ool20003Ool30005Ool00`00Oomoo`09Ool0
0`00Oomoo`1LOol00`00Oomoo`0ZOol00`00Oomoo`0gOol2000GOol00`00Oomoo`07Ool00`00Oomo
o`07Ool00005Ool007ooOol00008Ool01000Oomoo`000Woo00@007ooOol000Eoo`03001oogoo009o
o`03001oogoo00Uoo`03001oogoo05aoo`03001oogoo02Yoo`03001oogoo03Moo`8001Moo`03001o
ogoo00Moo`03001oogoo00Moo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0002Ool01000Oomoo`00
1Goo00<007ooOol00Woo0P002Woo00<007ooOol0G7oo00<007ooOol0:Woo00<007ooOol0=goo0P00
5goo00<007ooOol01goo00<007ooOol01goo00001Goo001oogoo000027oo00@007ooOol0009oo`04
001oogoo0002Ool30005Ool00`00Oomoo`09Ool00`00Oomoo`1LOol00`00Oomoo`0ZOol00`00Oomo
o`0gOol2000QOol00`00Oomoo`07Ool00005Ool007ooOol00008Ool01000Oomoo`000Woo00@007oo
Ool0009oo`03001oogoo00Eoo`03001oogoo00Uoo`03001oogoo05aoo`03001oogoo02Yoo`03001o
ogoo03Moo`80025oo`03001oogoo00Moo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0002Ool01000
Oomoo`000Woo00<007ooOol01Goo00<007ooOol02Goo00<007ooOol0G7oo00<007ooOol0:Woo00<0
07ooOol0=goo0P008Goo00<007ooOol01goo0002Ool2000:Ool20004Ool20003Ool40004Ool00`00
Oomoo`09Ool00`00Oomoo`1LOol00`00Oomoo`0ZOol00`00Oomoo`0gOol2000QOol00`00Oomoo`07
Ool0025oo`03001oogoo00Uoo`03001oogoo05aoo`03001oogoo02Yoo`03001oogoo03Moo`80025o
o`03001oogoo00Moo`008Goo00<007ooOol02Goo00<007ooOol0G7oo00<007ooOol0:Woo00<007oo
Ool0=goo0P008Goo00<007ooOol01goo000QOol00`00Oomoo`09Ool00`00Oomoo`1LOol00`00Oomo
o`0ZOol00`00Oomoo`0gOol2000QOol00`00Oomoo`07Ool0025oo`8000Yoo`03001oogoo05aoo`03
001oogoo02Yoo`03001oogoo05Yoo`03001oogoo00Moo`008Goo00<007ooOol02Goo00<007ooOol0
G7oo00<007ooOol0:Woo00<007ooOol0FWoo00<007ooOol01goo000QOol00`00Oomoo`09Ool00`00
Oomoo`1LOol00`00Oomoo`0ZOol00`00Oomoo`1JOol00`00Oomoo`07Ool0025oo`03001oogoo00Uo
o`03001oogoo05aoo`03001oogoo02Yoo`03001oogoo05Yoo`03001oogoo00Moo`008Goo00<007oo
Ool02Goo00<007ooOol0G7oo00<007ooOol0:Woo00<007ooOol0FWoo00<007ooOol01goo000QOol0
0`00Oomoo`09Ool00`00Oomoo`1LOol00`00Oomoo`0ZOol00`00Oomoo`1JOol00`00Oomoo`07Ool0
025oo`03001oogoo00Uoo`03001oogoo05aoo`03001oogoo02Yoo`03001oogoo05Yoo`03001oogoo
00Moo`008Goo0P002Woo00<007ooOol0G7oo00<007ooOol0:Woo00<007ooOol0FWoo00<007ooOol0
1goo000QOol00`00Oomoo`09Ool00`00Oomoo`1LOol00`00Oomoo`0ZOol00`00Oomoo`1JOol00`00
Oomoo`07Ool0025oo`03001oogoo00Uoo`03001oogoo05aoo`03001oogoo02Yoo`03001oogoo05Yo
o`03001oogoo00Moo`008Goo00<007ooOol02Goo00<007ooOol0G7oo00<007ooOol0:Woo00<007oo
Ool0I7oo000QOol00`00Oomoo`09Ool00`00Oomoo`29Ool00`00Oomoo`1TOol0025oo`03001oogoo
00Uoo`03001oogoo08Uoo`03001oogoo06Aoo`008Goo00<007ooOol02Goo00<007ooOol0RGoo00<0
07ooOol0I7oo000QOol00`00Oomoo`09Ool00`00Oomoo`29Ool00`00Oomoo`1TOol0025oo`8000Yo
o`03001oogoo08Uoo`03001oogoo06Aoo`008Goo00<007ooOol02Goo00<007ooOol0RGoo00<007oo
Ool0I7oo000QOol00`00Oomoo`09Ool00`00Oomoo`29Ool00`00Oomoo`1TOol0025oo`03001oogoo
00Uoo`03001oogoo08Uoo`03001oogoo06Aoo`008Goo00<007ooOol02Goo00<007ooOol0RGoo00<0
07ooOol0I7oo000QOol00`00Oomoo`09Ool00`00Oomoo`3`Ool0025oo`03001oogoo00Uoo`03001o
ogoo0?1oo`008Goo0P002Woo00<007ooOol0l7oo000QOol00`00Oomoo`09Ool00`00Oomoo`3`Ool0
025oo`03001oogoo0?aoo`008Goo00<007ooOol0o7oo000QOol00`00Oomoo`3lOol0025oo`03001o
ogoo0?aoo`00ogoo8Goo003oOolQOol00?moob5oo`00Lgoo0`00=7oo0`00Lgoo001dOol00`00Oomo
o`0fOol00`00Oomoo`1`Ool006Moo`D00004Ool00000Ool20002Ool30003Ool500000goo00000003
0002Ool20003Ool50003Ool2000017oo000000000Woo00<007ooOol00P0000=oo`0000000P0000=o
o`0000000Woo0`000goo0`0000Aoo`000000009oo`03001oogoo00800003Ool007oo009oo`8000Ao
o`8000=oo`800003Ool007oo04aoo`00J7oo00@007ooOol0009oo`03001oo`0000=oo`04001oogoo
0004Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo00H0
07ooOol007oo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomo
o`001Goo00@007ooOol0009oo`04001oogoo0003Ool01000Oomoo`000Woo00H007ooOol007oo0002
Ool00`00Oomoo`1<Ool006Qoo`03001oogoo00Aoo`03001oogoo009oo`04001oogoo0004Ool00`00
Oomoo`03Ool01@00Oomoogoo00001goo00<007ooOol00Woo00<007ooOol00Woo0`000goo00@007oo
Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo0`000goo00<007oo00000goo00@007ooOol0
00=oo`03001oogoo00=oo`03001oogoo00=oo`<004ioo`00J7oo0`000goo00<007oo00000goo00@0
07ooOol000Aoo`03001oogoo00=oo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomo
o`000Woo00@007ooOol0009oo`8000Aoo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`05
Ool00`00Oomoo`1<Ool006Qoo`05001oogoo001oo`0200001Woo000007oo001oo`8000Eoo`03001o
ogoo009oo`8000Aoo`8000Aoo`8000=oo`@0009oo`05001oogoo001oo`0200001Woo000007oo001o
o`8000Aoo`800004Ool007ooOol20003Ool00`00Ool00002Ool200000goo00000002Ool40002Ool4
0003Ool2001?Ool006Moo`D0011oo`03001oogoo01Aoo`04001oogooOol4000JOol200000goo0000
0009Ool00`00Oomoo`03Ool00`00Oomoo`1DOol007]oo`8000Eoo`03001oogoo00Uoo`03001oogoo
009oo`03001oogoo02eoo`03001oogoo00=oo`03001oogoo05Aoo`00ogoo8Goo003oOolQOol00001
\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {625.688, 404.5}} -> {-6.98668, \
0.0101721, 0.0646164, 2.63781*^-5}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0595319 0.0147151 124.072 [
[.17264 .00222 -9 -9 ]
[.17264 .00222 9 0 ]
[.32147 .00222 -3 -9 ]
[.32147 .00222 3 0 ]
[.4703 .00222 -9 -9 ]
[.4703 .00222 9 0 ]
[.61913 .00222 -6 -9 ]
[.61913 .00222 6 0 ]
[.76796 .00222 -12 -9 ]
[.76796 .00222 12 0 ]
[.91679 .00222 -6 -9 ]
[.91679 .00222 6 0 ]
[.01131 .13879 -30 -4.5 ]
[.01131 .13879 0 4.5 ]
[.01131 .26286 -30 -4.5 ]
[.01131 .26286 0 4.5 ]
[.01131 .38693 -30 -4.5 ]
[.01131 .38693 0 4.5 ]
[.01131 .511 -30 -4.5 ]
[.01131 .511 0 4.5 ]
[.5 .63053 -17 0 ]
[.5 .63053 17 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17264 .01472 m
.17264 .02097 L
s
[(2.5)] .17264 .00222 0 1 Mshowa
.32147 .01472 m
.32147 .02097 L
s
[(5)] .32147 .00222 0 1 Mshowa
.4703 .01472 m
.4703 .02097 L
s
[(7.5)] .4703 .00222 0 1 Mshowa
.61913 .01472 m
.61913 .02097 L
s
[(10)] .61913 .00222 0 1 Mshowa
.76796 .01472 m
.76796 .02097 L
s
[(12.5)] .76796 .00222 0 1 Mshowa
.91679 .01472 m
.91679 .02097 L
s
[(15)] .91679 .00222 0 1 Mshowa
.125 Mabswid
.05358 .01472 m
.05358 .01847 L
s
.08334 .01472 m
.08334 .01847 L
s
.11311 .01472 m
.11311 .01847 L
s
.14287 .01472 m
.14287 .01847 L
s
.20241 .01472 m
.20241 .01847 L
s
.23217 .01472 m
.23217 .01847 L
s
.26194 .01472 m
.26194 .01847 L
s
.2917 .01472 m
.2917 .01847 L
s
.35124 .01472 m
.35124 .01847 L
s
.381 .01472 m
.381 .01847 L
s
.41077 .01472 m
.41077 .01847 L
s
.44053 .01472 m
.44053 .01847 L
s
.50006 .01472 m
.50006 .01847 L
s
.52983 .01472 m
.52983 .01847 L
s
.5596 .01472 m
.5596 .01847 L
s
.58936 .01472 m
.58936 .01847 L
s
.64889 .01472 m
.64889 .01847 L
s
.67866 .01472 m
.67866 .01847 L
s
.70843 .01472 m
.70843 .01847 L
s
.73819 .01472 m
.73819 .01847 L
s
.79772 .01472 m
.79772 .01847 L
s
.82749 .01472 m
.82749 .01847 L
s
.85726 .01472 m
.85726 .01847 L
s
.88702 .01472 m
.88702 .01847 L
s
.94655 .01472 m
.94655 .01847 L
s
.97632 .01472 m
.97632 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13879 m
.03006 .13879 L
s
[(0.001)] .01131 .13879 1 0 Mshowa
.02381 .26286 m
.03006 .26286 L
s
[(0.002)] .01131 .26286 1 0 Mshowa
.02381 .38693 m
.03006 .38693 L
s
[(0.003)] .01131 .38693 1 0 Mshowa
.02381 .511 m
.03006 .511 L
s
[(0.004)] .01131 .511 1 0 Mshowa
.125 Mabswid
.02381 .03953 m
.02756 .03953 L
s
.02381 .06434 m
.02756 .06434 L
s
.02381 .08916 m
.02756 .08916 L
s
.02381 .11397 m
.02756 .11397 L
s
.02381 .1636 m
.02756 .1636 L
s
.02381 .18842 m
.02756 .18842 L
s
.02381 .21323 m
.02756 .21323 L
s
.02381 .23804 m
.02756 .23804 L
s
.02381 .28767 m
.02756 .28767 L
s
.02381 .31249 m
.02756 .31249 L
s
.02381 .3373 m
.02756 .3373 L
s
.02381 .36212 m
.02756 .36212 L
s
.02381 .41175 m
.02756 .41175 L
s
.02381 .43656 m
.02756 .43656 L
s
.02381 .46137 m
.02756 .46137 L
s
.02381 .48619 m
.02756 .48619 L
s
.02381 .53582 m
.02756 .53582 L
s
.02381 .56063 m
.02756 .56063 L
s
.02381 .58545 m
.02756 .58545 L
s
.02381 .61026 m
.02756 .61026 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Adams) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.02381 .01472 m
.02381 .01472 L
.02381 .01477 L
.02381 .01477 L
.02381 .01477 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01472 L
.02381 .01481 L
.02381 .01481 L
.02381 .01481 L
.02381 .01481 L
.02381 .01481 L
.02381 .01569 L
.02381 .01569 L
.02381 .01569 L
.02381 .01569 L
.02381 .01569 L
.02381 .02449 L
.02382 .02449 L
.02382 .02449 L
.02383 .02449 L
.02383 .02449 L
.02384 .02449 L
.02384 .04349 L
.02385 .04349 L
.02387 .04349 L
.02388 .04349 L
.0239 .04349 L
.02391 .04349 L
.02392 .04349 L
.02394 .06224 L
.02396 .05428 L
.02398 .05428 L
.024 .05428 L
.02402 .05428 L
.02404 .05428 L
Mistroke
.02405 .05428 L
.02407 .05428 L
.02409 .05428 L
.02411 .08655 L
.02415 .08655 L
.02418 .08655 L
.02422 .08655 L
.02425 .08655 L
.02428 .08655 L
.02432 .08655 L
.02435 .08655 L
.02439 .08655 L
.02442 .13084 L
.02448 .13084 L
.02453 .13084 L
.02459 .13084 L
.02464 .13084 L
.0247 .13084 L
.02476 .13084 L
.02481 .13084 L
.02487 .13084 L
.02492 .13084 L
.02498 .16114 L
.02505 .16114 L
.02512 .16114 L
.02519 .16114 L
.02526 .16114 L
.02533 .16114 L
.0254 .16114 L
.02547 .16114 L
.02554 .16114 L
.02561 .16114 L
.02568 .16114 L
.02575 .20081 L
.02584 .20081 L
.02593 .20081 L
.02602 .20081 L
.02611 .20081 L
.0262 .20081 L
.02629 .20081 L
.02638 .20081 L
.02647 .20081 L
.02656 .20081 L
.02664 .20081 L
.02673 .20081 L
.02682 .1907 L
.02691 .1907 L
.02699 .1907 L
.02708 .1907 L
.02716 .1907 L
Mistroke
.02725 .1907 L
.02733 .1907 L
.02741 .1907 L
.0275 .1907 L
.02758 .1907 L
.02767 .1907 L
.02775 .1907 L
.02784 .18204 L
.02792 .18204 L
.028 .18204 L
.02808 .18204 L
.02816 .18204 L
.02824 .18204 L
.02832 .18204 L
.0284 .18204 L
.02848 .18204 L
.02856 .18204 L
.02864 .18204 L
.02872 .1647 L
.02879 .1647 L
.02886 .1647 L
.02894 .1647 L
.02901 .1647 L
.02908 .1647 L
.02915 .1647 L
.02922 .1647 L
.0293 .1647 L
.02937 .1647 L
.02944 .20694 L
.02953 .20694 L
.02962 .20694 L
.02972 .20694 L
.02981 .20694 L
.0299 .20694 L
.02999 .20694 L
.03009 .20694 L
.03018 .20694 L
.03027 .20694 L
.03036 .23819 L
.03047 .23819 L
.03058 .23819 L
.03068 .23819 L
.03079 .23819 L
.0309 .23819 L
.03101 .23819 L
.03111 .23819 L
.03122 .23819 L
.03133 .23819 L
.03143 .23819 L
.03154 .29459 L
Mistroke
.03168 .29459 L
.03181 .29459 L
.03194 .29459 L
.03208 .29459 L
.03221 .29459 L
.03235 .29459 L
.03248 .29459 L
.03262 .29459 L
.03275 .29459 L
.03288 .29459 L
.03302 .29459 L
.03315 .29459 L
.03329 .29459 L
.03342 .29459 L
.03356 .29459 L
.03369 .29459 L
.03382 .29459 L
.03396 .29459 L
.03409 .29459 L
.03423 .32731 L
.03438 .32731 L
.03453 .32731 L
.03468 .32731 L
.03483 .32731 L
.03498 .32731 L
.03513 .32731 L
.03528 .32731 L
.03543 .32731 L
.03558 .32731 L
.03573 .32731 L
.03588 .32731 L
.03603 .30975 L
.03617 .30975 L
.03631 .30975 L
.03645 .30975 L
.03659 .30975 L
.03673 .30975 L
.03688 .30975 L
.03702 .30975 L
.03716 .30975 L
.0373 .30975 L
.03744 .30975 L
.03758 .30975 L
.03773 .3287 L
.03788 .3287 L
.03803 .3287 L
.03818 .3287 L
.03833 .3287 L
.03848 .3287 L
.03863 .3287 L
Mistroke
.03878 .3287 L
.03893 .3287 L
.03908 .3287 L
.03923 .3287 L
.03938 .3287 L
.03953 .3287 L
.03968 .3287 L
.03983 .3287 L
.03999 .3287 L
.04014 .3287 L
.04029 .3287 L
.04044 .3287 L
.04059 .3287 L
.04074 .3287 L
.04089 .3287 L
.04104 .3287 L
.04119 .3287 L
.04134 .3287 L
.04149 .3287 L
.04164 .3287 L
.04179 .3287 L
.04194 .3287 L
.04209 .3287 L
.04225 .3287 L
.0424 .3287 L
.04255 .3287 L
.0427 .3287 L
.04285 .3287 L
.043 .3287 L
.04315 .3287 L
.0433 .3287 L
.04345 .3287 L
.0436 .3287 L
.04375 .3287 L
.0439 .3287 L
.04405 .3287 L
.0442 .3287 L
.04435 .3287 L
.04451 .3287 L
.04466 .27344 L
.04478 .27344 L
.0449 .22471 L
.045 .18503 L
.04509 .14821 L
.04515 .01472 L
.04515 .01472 L
.04515 .01472 L
.04515 .01472 L
.04515 .01472 L
.04515 .01472 L
Mistroke
.04515 .01472 L
.04515 .01472 L
.04515 .01472 L
.04515 .01472 L
.04515 .01472 L
.04515 .01472 L
.04515 .01474 L
.04515 .01474 L
.04515 .01474 L
.04515 .01474 L
.04515 .01497 L
.04515 .01497 L
.04515 .01497 L
.04515 .01497 L
.04515 .01497 L
.04515 .01731 L
.04515 .01731 L
.04515 .01731 L
.04516 .01731 L
.04516 .01731 L
.04516 .01731 L
.04516 .04067 L
.04517 .04067 L
.04518 .04067 L
.0452 .04067 L
.04521 .04067 L
.04522 .04067 L
.04523 .04067 L
.04525 .08772 L
.04528 .07482 L
.04531 .07482 L
.04534 .07482 L
.04537 .07482 L
.0454 .07482 L
.04543 .07482 L
.04545 .07482 L
.04548 .07482 L
.04551 .11138 L
.04556 .11138 L
.0456 .11138 L
.04565 .11138 L
.0457 .11138 L
.04574 .11138 L
.04579 .11138 L
.04584 .11138 L
.04588 .11138 L
.04593 .16168 L
.046 .16168 L
.04607 .16168 L
.04614 .16168 L
Mistroke
.04621 .16168 L
.04628 .16168 L
.04635 .16168 L
.04642 .16168 L
.04649 .16168 L
.04656 .16168 L
.04663 .18844 L
.04672 .18844 L
.0468 .18844 L
.04688 .18844 L
.04697 .18844 L
.04705 .18844 L
.04713 .18844 L
.04722 .18844 L
.0473 .18844 L
.04738 .18844 L
.04747 .18844 L
.04755 .2238 L
.04765 .2238 L
.04775 .2238 L
.04785 .2238 L
.04795 .2238 L
.04805 .2238 L
.04815 .2238 L
.04825 .2238 L
.04835 .2238 L
.04845 .2238 L
.04855 .2238 L
.04865 .2238 L
.04876 .2238 L
.04886 .2238 L
.04896 .2238 L
.04906 .2238 L
.04916 .2238 L
.04926 .2238 L
.04936 .2238 L
.04946 .2238 L
.04956 .2238 L
.04966 .2238 L
.04976 .2238 L
.04986 .2238 L
.04996 .2238 L
.05006 .2238 L
.05016 .2238 L
.05026 .2238 L
.05036 .2238 L
.05046 .2086 L
.05055 .2086 L
.05065 .2086 L
.05074 .2086 L
Mistroke
.05083 .2086 L
.05093 .2086 L
.05102 .2086 L
.05111 .2086 L
.0512 .2086 L
.0513 .2086 L
.05139 .2086 L
.05148 .18123 L
.05156 .18123 L
.05164 .18123 L
.05172 .18123 L
.0518 .18123 L
.05188 .18123 L
.05196 .18123 L
.05204 .18123 L
.05212 .18123 L
.0522 .18123 L
.05228 .18123 L
.05236 .18123 L
.05244 .18123 L
.05252 .18123 L
.0526 .22167 L
.0527 .22167 L
.0528 .22167 L
.0529 .22167 L
.053 .22167 L
.0531 .22167 L
.0532 .22167 L
.0533 .22167 L
.0534 .22167 L
.0535 .22167 L
.0536 .22167 L
.05369 .22167 L
.05379 .24707 L
.05391 .24707 L
.05402 .24707 L
.05413 .24707 L
.05424 .24707 L
.05435 .24707 L
.05446 .24707 L
.05457 .24707 L
.05469 .24707 L
.0548 .24707 L
.05491 .24707 L
.05502 .24707 L
.05513 .11626 L
.05518 .11626 L
.05523 .11626 L
.05528 .11626 L
.05533 .11626 L
Mistroke
.05538 .11626 L
.05542 .11626 L
.05547 .11626 L
.05552 .11626 L
.05557 .11626 L
.05562 .11626 L
.05567 .14334 L
.05573 .14334 L
.05579 .14334 L
.05585 .14334 L
.05591 .14334 L
.05598 .14334 L
.05604 .14334 L
.0561 .14334 L
.05616 .14334 L
.05622 .14334 L
.05629 .14037 L
.05635 .14037 L
.05641 .14037 L
.05647 .14037 L
.05653 .14037 L
.05659 .14037 L
.05665 .14037 L
.05671 .14037 L
.05677 .14037 L
.05683 .14037 L
.05689 .2054 L
.05698 .2054 L
.05707 .2054 L
.05716 .2054 L
.05725 .2054 L
.05735 .2054 L
.05744 .2054 L
.05753 .2054 L
.05762 .2054 L
.05771 .2054 L
.0578 .2054 L
.05789 .15224 L
.05796 .15224 L
.05803 .15224 L
.05809 .15224 L
.05816 .15224 L
.05822 .15224 L
.05829 .15224 L
.05836 .15224 L
.05842 .15224 L
.05849 .15224 L
.05855 .20433 L
.05865 .20433 L
.05874 .20433 L
Mistroke
.05883 .20433 L
.05892 .20433 L
.05901 .20433 L
.0591 .20433 L
.05919 .20433 L
.05928 .20433 L
.05937 .20433 L
.05946 .20433 L
.05956 .27554 L
.05968 .27554 L
.05981 .27554 L
.05993 .27554 L
.06006 .27554 L
.06018 .27554 L
.06031 .27554 L
.06043 .27554 L
.06056 .27554 L
.06068 .27554 L
.06081 .27554 L
.06093 .27554 L
.06106 .3333 L
.06121 .3333 L
.06136 .3333 L
.06152 .3333 L
.06167 .3333 L
.06182 .3333 L
.06197 .3333 L
.06213 .3333 L
.06228 .3333 L
.06243 .3333 L
.06259 .3333 L
.06274 .3333 L
.06289 .3333 L
.06304 .33622 L
.0632 .33622 L
.06335 .33622 L
.06351 .33622 L
.06366 .33622 L
.06382 .33622 L
.06397 .33622 L
.06412 .33622 L
.06428 .33622 L
.06443 .33622 L
.06459 .33622 L
.06474 .33622 L
.0649 .33622 L
.06505 .41833 L
.06524 .41833 L
.06544 .41833 L
.06563 .41833 L
Mistroke
.06582 .41833 L
.06602 .41833 L
.06621 .41833 L
.06641 .41833 L
.0666 .41833 L
.06679 .41833 L
.06699 .41833 L
.06718 .41833 L
.06737 .41833 L
.06757 .33396 L
.06772 .33396 L
.06787 .33396 L
.06803 .33396 L
.06818 .33396 L
.06833 .33396 L
.06849 .33396 L
.06864 .33396 L
.06879 .33396 L
.06895 .33396 L
.0691 .33396 L
.06925 .33396 L
.06941 .38889 L
.06958 .38889 L
.06976 .38889 L
.06994 .38889 L
.07012 .38889 L
.0703 .38889 L
.07048 .38889 L
.07066 .38889 L
.07084 .38889 L
.07102 .38889 L
.0712 .38889 L
.07138 .43457 L
.07158 .43457 L
.07178 .43457 L
.07198 .43457 L
.07219 .43457 L
.07239 .43457 L
.07259 .43457 L
.07279 .43457 L
.07299 .43457 L
.07319 .43457 L
.07339 .43457 L
.0736 .43457 L
.0738 .43457 L
.074 .43457 L
.0742 .43457 L
.0744 .43457 L
.0746 .36378 L
.07477 .36378 L
Mistroke
.07494 .36378 L
.07511 .36378 L
.07527 .36378 L
.07544 .36378 L
.07561 .36378 L
.07578 .36378 L
.07594 .36378 L
.07611 .36378 L
.07628 .36378 L
.07645 .36378 L
.07661 .36378 L
.07678 .36378 L
.07695 .36378 L
.07712 .36378 L
.07728 .36378 L
.07745 .36378 L
.07762 .36378 L
.07779 .36378 L
.07795 .36378 L
.07812 .36378 L
.07829 .36378 L
.07846 .36378 L
.07862 .36378 L
.07879 .36378 L
.07896 .36378 L
.07913 .36378 L
.07929 .36378 L
.07946 .30512 L
.0796 .30512 L
.07974 .30512 L
.07988 .30512 L
.08002 .30512 L
.08016 .30512 L
.0803 .30512 L
.08044 .30512 L
.08058 .30512 L
.08071 .30512 L
.08085 .30512 L
.08099 .30512 L
.08113 .30512 L
.08127 .30512 L
.08141 .30512 L
.08155 .30512 L
.08169 .30512 L
.08183 .30512 L
.08197 .30512 L
.08211 .30512 L
.08225 .30512 L
.08239 .30512 L
.08253 .30512 L
Mistroke
.08267 .25656 L
.08278 .25656 L
.0829 .25656 L
.08301 .25656 L
.08313 .25656 L
.08325 .25656 L
.08336 .25656 L
.08348 .25656 L
.08359 .25656 L
.08371 .25656 L
.08383 .25656 L
.08394 .25656 L
.08406 .25656 L
.08417 .25656 L
.08429 .25656 L
.08441 .25656 L
.08452 .25656 L
.08464 .25656 L
.08475 .25656 L
.08487 .25656 L
.08499 .25656 L
.0851 .25656 L
.08522 .25656 L
.08533 .25656 L
.08545 .25656 L
.08557 .25656 L
.08568 .25656 L
.0858 .25656 L
.08591 .25656 L
.08603 .25656 L
.08615 .25656 L
.08626 .25656 L
.08638 .25656 L
.08649 .25656 L
.08661 .25656 L
.08673 .25656 L
.08684 .25656 L
.08696 .25656 L
.08707 .25656 L
.08719 .25656 L
.08731 .25656 L
.08742 .25656 L
.08754 .25656 L
.08766 .25656 L
.08777 .25656 L
.08789 .25656 L
.088 .25656 L
.08812 .25656 L
.08824 .25656 L
.08835 .25656 L
Mistroke
.08847 .21564 L
.08856 .21564 L
.08866 .21564 L
.08876 .21564 L
.08885 .21564 L
.08895 .21564 L
.08905 .21564 L
.08914 .21564 L
.08924 .21564 L
.08934 .21564 L
.08943 .21564 L
.08953 .21564 L
.08962 .21564 L
.08972 .21564 L
.08982 .21564 L
.08991 .21564 L
.09001 .21564 L
.09011 .21564 L
.0902 .21564 L
.0903 .21564 L
.0904 .21564 L
.09049 .21564 L
.09059 .21564 L
.09068 .21564 L
.09078 .21564 L
.09088 .21564 L
.09097 .21564 L
.09107 .21564 L
.09117 .21564 L
.09126 .21564 L
.09136 .21564 L
.09146 .21564 L
.09155 .21564 L
.09165 .21564 L
.09175 .21564 L
.09184 .21564 L
.09194 .21564 L
.09203 .21564 L
.09213 .21564 L
.09223 .21564 L
.09232 .21564 L
.09242 .21564 L
.09252 .21564 L
.09261 .21564 L
.09271 .21564 L
.09281 .21564 L
.0929 .21564 L
.093 .21564 L
.0931 .21564 L
.09319 .21564 L
Mistroke
.09329 .17258 L
.09336 .17258 L
.09344 .17258 L
.09352 .17258 L
.09359 .17258 L
.09367 .17258 L
.09374 .17258 L
.09382 .17258 L
.09389 .17258 L
.09397 .17258 L
.09405 .17258 L
.09412 .17258 L
.0942 .17258 L
.09427 .17258 L
.09435 .17258 L
.09442 .17258 L
.0945 .17258 L
.09458 .21105 L
.09467 .21105 L
.09476 .21105 L
.09486 .21105 L
.09495 .21105 L
.09505 .21105 L
.09514 .21105 L
.09524 .21105 L
.09533 .21105 L
.09542 .21105 L
.09552 .21105 L
.09561 .21105 L
.09571 .13234 L
.09576 .13234 L
.09582 .13234 L
.09588 .13234 L
.09593 .13234 L
.09599 .13234 L
.09604 .13234 L
.0961 .13234 L
.09616 .13234 L
.09621 .13234 L
.09627 .13234 L
.09633 .13536 L
.09638 .13536 L
.09644 .13536 L
.0965 .13536 L
.09656 .13536 L
.09662 .13536 L
.09667 .13536 L
.09673 .13536 L
.09679 .13536 L
.09685 .13536 L
Mistroke
.09691 .12759 L
.09696 .12759 L
.09701 .12759 L
.09707 .12759 L
.09712 .12759 L
.09718 .12759 L
.09723 .12759 L
.09728 .12759 L
.09734 .12759 L
.09739 .12759 L
.09745 .16372 L
.09752 .16372 L
.09759 .16372 L
.09766 .16372 L
.09773 .16372 L
.0978 .16372 L
.09788 .16372 L
.09795 .16372 L
.09802 .16372 L
.09809 .16372 L
.09816 .16372 L
.09823 .10592 L
.09828 .10592 L
.09832 .10592 L
.09837 .10592 L
.09841 .10592 L
.09845 .10592 L
.0985 .10592 L
.09854 .10592 L
.09858 .10592 L
.09863 .10592 L
.09867 .11664 L
.09872 .11664 L
.09877 .11664 L
.09882 .11664 L
.09887 .11664 L
.09892 .11664 L
.09896 .11664 L
.09901 .11664 L
.09906 .11664 L
.09911 .11664 L
.09916 .18105 L
.09924 .18105 L
.09932 .18105 L
.0994 .18105 L
.09948 .18105 L
.09956 .18105 L
.09964 .18105 L
.09972 .18105 L
.0998 .18105 L
Mistroke
.09988 .18105 L
.09996 .18105 L
.10004 .07418 L
.10007 .07418 L
.1001 .07418 L
.10012 .07418 L
.10015 .07418 L
.10018 .07418 L
.10021 .07418 L
.10024 .07418 L
.10027 .07418 L
.1003 .07418 L
.10032 .16889 L
.1004 .16889 L
.10047 .16889 L
.10055 .16889 L
.10062 .16889 L
.10069 .16889 L
.10077 .16889 L
.10084 .16889 L
.10092 .16889 L
.10099 .16889 L
.10106 .18505 L
.10115 .18505 L
.10123 .18505 L
.10131 .18505 L
.10139 .18505 L
.10147 .18505 L
.10155 .18505 L
.10164 .18505 L
.10172 .18505 L
.1018 .18505 L
.10188 .18505 L
.10196 .26618 L
.10208 .26618 L
.1022 .26618 L
.10232 .26618 L
.10245 .26618 L
.10257 .26618 L
.10269 .26618 L
.10281 .26618 L
.10293 .26618 L
.10305 .26618 L
.10317 .26618 L
.10329 .26618 L
.10341 .29321 L
.10354 .29321 L
.10368 .29321 L
.10381 .29321 L
.10394 .29321 L
Mistroke
.10408 .29321 L
.10421 .29321 L
.10435 .29321 L
.10448 .29321 L
.10461 .29321 L
.10475 .29321 L
.10488 .29321 L
.10501 .29321 L
.10515 .35266 L
.10531 .35266 L
.10547 .35266 L
.10563 .35266 L
.1058 .35266 L
.10596 .35266 L
.10612 .35266 L
.10628 .35266 L
.10644 .35266 L
.10661 .35266 L
.10677 .35266 L
.10693 .35266 L
.10709 .35266 L
.10726 .41572 L
.10745 .41572 L
.10764 .41572 L
.10783 .41572 L
.10803 .41572 L
.10822 .41572 L
.10841 .41572 L
.1086 .41572 L
.10879 .41572 L
.10899 .41572 L
.10918 .41572 L
.10937 .41572 L
.10956 .41572 L
.10976 .41572 L
.10995 .41572 L
.11014 .41572 L
.11033 .41572 L
.11053 .41572 L
.11072 .41572 L
.11091 .41572 L
.1111 .41572 L
.1113 .41572 L
.11149 .41572 L
.11168 .41572 L
.11187 .41572 L
.11207 .41572 L
.11226 .41572 L
.11245 .41572 L
.11264 .41572 L
Mistroke
.11284 .41572 L
.11303 .41572 L
.11322 .41572 L
.11341 .41572 L
.1136 .41572 L
.1138 .41863 L
.11399 .41863 L
.11418 .41863 L
.11438 .41863 L
.11457 .41863 L
.11477 .41863 L
.11496 .41863 L
.11515 .41863 L
.11535 .41863 L
.11554 .41863 L
.11574 .41863 L
.11593 .41863 L
.11612 .41863 L
.11632 .41863 L
.11651 .41863 L
.1167 .51408 L
.11694 .51408 L
.11718 .51408 L
.11742 .51408 L
.11766 .51408 L
.1179 .51408 L
.11814 .51408 L
.11838 .51408 L
.11862 .51408 L
.11886 .51408 L
.1191 .51408 L
.11934 .51408 L
.11958 .51408 L
.11982 .51408 L
.12006 .51408 L
.1203 .51408 L
.12054 .51408 L
.12078 .51408 L
.12102 .51408 L
.12126 .51408 L
.1215 .51408 L
.12174 .51408 L
.12198 .51408 L
.12222 .51408 L
.12245 .51408 L
.12269 .51408 L
.12293 .51408 L
.12317 .4244 L
.12337 .4244 L
.12357 .4244 L
Mistroke
.12376 .4244 L
.12396 .4244 L
.12416 .4244 L
.12435 .4244 L
.12455 .4244 L
.12475 .4244 L
.12494 .4244 L
.12514 .4244 L
.12534 .4244 L
.12553 .32378 L
.12568 .32378 L
.12583 .32378 L
.12598 .32378 L
.12613 .32378 L
.12627 .32378 L
.12642 .32378 L
.12657 .32378 L
.12672 .32378 L
.12687 .32378 L
.12702 .32378 L
.12716 .32378 L
.12731 .32378 L
.12746 .32378 L
.12761 .32378 L
.12776 .32378 L
.12791 .32378 L
.12805 .32378 L
.1282 .32378 L
.12835 .32378 L
.1285 .32378 L
.12865 .32378 L
.1288 .32378 L
.12894 .32378 L
.12909 .32378 L
.12924 .32378 L
.12939 .32378 L
.12954 .32378 L
.12968 .32378 L
.12983 .32378 L
.12998 .32378 L
.13013 .32378 L
.13028 .32378 L
.13043 .32378 L
.13057 .32378 L
.13072 .32378 L
.13087 .32378 L
.13102 .32378 L
.13117 .32378 L
.13132 .32378 L
.13146 .32378 L
Mistroke
.13161 .32378 L
.13176 .32378 L
.13191 .32378 L
.13206 .32378 L
.13221 .32378 L
.13235 .32378 L
.1325 .32378 L
.13265 .32378 L
.1328 .27058 L
.13292 .27058 L
.13304 .22378 L
.13315 .18187 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01472 L
.13323 .01475 L
.13323 .01475 L
.13323 .01475 L
.13323 .01475 L
.13323 .01504 L
.13323 .01504 L
.13323 .01504 L
.13323 .01504 L
.13323 .01504 L
.13323 .01801 L
.13323 .01801 L
.13323 .01801 L
.13323 .01801 L
.13323 .01801 L
.13323 .01801 L
.13324 .04762 L
.13325 .04762 L
.13327 .04762 L
.13328 .04762 L
.1333 .04762 L
.13331 .04762 L
.13333 .04762 L
.13335 .08867 L
.13338 .07208 L
.13341 .07208 L
.13344 .07208 L
Mistroke
.13346 .07208 L
.13349 .07208 L
.13352 .07208 L
.13355 .07208 L
.13357 .07208 L
.1336 .10206 L
.13364 .10206 L
.13369 .10206 L
.13373 .10206 L
.13377 .10206 L
.13381 .10206 L
.13385 .10206 L
.1339 .10206 L
.13394 .10206 L
.13398 .14982 L
.13404 .14982 L
.13411 .14982 L
.13417 .14982 L
.13424 .14982 L
.1343 .14982 L
.13437 .14982 L
.13443 .14982 L
.1345 .14982 L
.13456 .14982 L
.13463 .18471 L
.13471 .18471 L
.13479 .18471 L
.13487 .18471 L
.13495 .18471 L
.13504 .18471 L
.13512 .18471 L
.1352 .18471 L
.13528 .18471 L
.13536 .18471 L
.13544 .18471 L
.13552 .20479 L
.13562 .20479 L
.13571 .20479 L
.1358 .20479 L
.13589 .20479 L
.13598 .20479 L
.13607 .20479 L
.13616 .20479 L
.13625 .20479 L
.13635 .20479 L
.13644 .20479 L
.13653 .20479 L
.13662 .23554 L
.13672 .23554 L
.13683 .23554 L
Mistroke
.13694 .23554 L
.13704 .23554 L
.13715 .23554 L
.13725 .23554 L
.13736 .23554 L
.13747 .23554 L
.13757 .23554 L
.13768 .23554 L
.13778 .23554 L
.13789 .23554 L
.138 .23554 L
.1381 .23554 L
.13821 .23554 L
.13831 .23554 L
.13842 .23554 L
.13853 .23554 L
.13863 .23554 L
.13874 .23554 L
.13884 .21468 L
.13894 .21468 L
.13904 .21468 L
.13913 .21468 L
.13923 .21468 L
.13932 .21468 L
.13942 .21468 L
.13952 .21468 L
.13961 .21468 L
.13971 .21468 L
.1398 .21468 L
.1399 .21468 L
.14 .19167 L
.14008 .19167 L
.14017 .19167 L
.14025 .19167 L
.14033 .19167 L
.14042 .19167 L
.1405 .19167 L
.14059 .19167 L
.14067 .19167 L
.14076 .19167 L
.14084 .19167 L
.14093 .19167 L
.14101 .19167 L
.1411 .19167 L
.14118 .19167 L
.14127 .19167 L
.14135 .19167 L
.14144 .19167 L
.14152 .19167 L
.14161 .19167 L
Mistroke
.14169 .19167 L
.14178 .20975 L
.14187 .20975 L
.14197 .20975 L
.14206 .20975 L
.14215 .20975 L
.14225 .20975 L
.14234 .20975 L
.14243 .20975 L
.14253 .20975 L
.14262 .20975 L
.14271 .20975 L
.14281 .20975 L
.1429 .20975 L
.14299 .20975 L
.14309 .20975 L
.14318 .20975 L
.14328 .20975 L
.14337 .20975 L
.14346 .20975 L
.14356 .23282 L
.14366 .23282 L
.14377 .23282 L
.14387 .23282 L
.14397 .23282 L
.14408 .23282 L
.14418 .23282 L
.14429 .23282 L
.14439 .23282 L
.1445 .23282 L
.1446 .23282 L
.14471 .23282 L
.14481 .23282 L
.14492 .05014 L
.14493 .05014 L
.14495 .05014 L
.14497 .05014 L
.14498 .05014 L
.145 .05014 L
.14502 .05014 L
.14504 .05014 L
.14505 .05014 L
.14507 .05014 L
.14509 .05014 L
.1451 .05014 L
.14512 .07733 L
.14515 .07733 L
.14518 .07733 L
.14521 .07733 L
.14524 .07733 L
Mistroke
.14527 .07733 L
.1453 .07733 L
.14533 .07733 L
.14536 .07733 L
.14539 .07733 L
.14542 .07733 L
.14545 .15003 L
.14552 .15003 L
.14558 .15003 L
.14565 .15003 L
.14571 .15003 L
.14578 .15003 L
.14584 .15003 L
.14591 .15003 L
.14597 .15003 L
.14604 .15003 L
.1461 .15003 L
.14617 .1808 L
.14625 .1808 L
.14632 .1808 L
.1464 .1808 L
.14648 .1808 L
.14656 .1808 L
.14664 .1808 L
.14672 .1808 L
.1468 .1808 L
.14688 .1808 L
.14696 .1808 L
.14704 .1808 L
.14712 .21599 L
.14722 .21599 L
.14731 .21599 L
.14741 .21599 L
.14751 .21599 L
.1476 .21599 L
.1477 .21599 L
.1478 .21599 L
.14789 .21599 L
.14799 .21599 L
.14809 .21599 L
.14818 .21599 L
.14828 .24283 L
.14839 .24283 L
.1485 .24283 L
.14861 .24283 L
.14872 .24283 L
.14883 .24283 L
.14894 .24283 L
.14905 .24283 L
.14916 .24283 L
Mistroke
.14927 .24283 L
.14938 .24283 L
.14948 .24283 L
.14959 .24283 L
.1497 .24283 L
.14981 .24283 L
.14992 .29065 L
.15005 .29065 L
.15019 .29065 L
.15032 .29065 L
.15045 .29065 L
.15058 .29065 L
.15072 .29065 L
.15085 .29065 L
.15098 .29065 L
.15111 .29065 L
.15125 .29065 L
.15138 .29065 L
.15151 .29065 L
.15164 .29065 L
.15178 .29065 L
.15191 .29065 L
.15204 .29065 L
.15217 .29065 L
.15231 .29065 L
.15244 .29065 L
.15257 .29065 L
.1527 .29065 L
.15284 .29065 L
.15297 .29065 L
.1531 .29065 L
.15323 .29656 L
.15337 .29656 L
.1535 .29656 L
.15364 .29656 L
.15377 .29656 L
.15391 .29656 L
.15404 .29656 L
.15418 .29656 L
.15431 .29656 L
.15445 .29656 L
.15458 .29656 L
.15472 .29656 L
.15486 .29656 L
.15499 .29656 L
.15513 .29656 L
.15526 .29656 L
.1554 .29656 L
.15553 .29656 L
.15567 .26574 L
Mistroke
.15579 .26574 L
.15591 .26574 L
.15603 .26574 L
.15615 .26574 L
.15627 .26574 L
.15639 .26574 L
.15651 .26574 L
.15663 .26574 L
.15675 .26574 L
.15687 .26574 L
.15699 .29188 L
.15712 .29188 L
.15726 .29188 L
.15739 .29188 L
.15752 .29188 L
.15766 .29188 L
.15779 .29188 L
.15792 .29188 L
.15806 .29188 L
.15819 .29188 L
.15832 .29188 L
.15845 .3563 L
.15862 .3563 L
.15878 .3563 L
.15895 .3563 L
.15911 .3563 L
.15927 .3563 L
.15944 .3563 L
.1596 .3563 L
.15977 .3563 L
.15993 .3563 L
.16009 .3563 L
.16026 .40973 L
.16045 .40973 L
.16064 .40973 L
.16083 .40973 L
.16102 .40973 L
.16121 .40973 L
.16139 .40973 L
.16158 .40973 L
.16177 .40973 L
.16196 .40973 L
.16215 .40973 L
.16234 .40973 L
.16253 .40973 L
.16272 .40973 L
.16291 .40973 L
.1631 .40973 L
.16329 .40973 L
.16348 .40973 L
Mistroke
.16367 .40973 L
.16386 .40973 L
.16405 .40973 L
.16424 .40973 L
.16443 .40973 L
.16462 .40973 L
.16481 .40973 L
.165 .40973 L
.16519 .40973 L
.16537 .40973 L
.16556 .40973 L
.16575 .40973 L
.16594 .40973 L
.16613 .40973 L
.16632 .40973 L
.16651 .40973 L
.1667 .40973 L
.16689 .40973 L
.16708 .40973 L
.16727 .40973 L
.16746 .34283 L
.16762 .34283 L
.16777 .34283 L
.16793 .34283 L
.16809 .34283 L
.16825 .34283 L
.1684 .34283 L
.16856 .34283 L
.16872 .34283 L
.16888 .34283 L
.16903 .34283 L
.16919 .34283 L
.16935 .34283 L
.16951 .34283 L
.16966 .34283 L
.16982 .34283 L
.16998 .34283 L
.17014 .34283 L
.17029 .34283 L
.17045 .34283 L
.17061 .34283 L
.17077 .34283 L
.17092 .34283 L
.17108 .34283 L
.17124 .34283 L
.1714 .34283 L
.17155 .34283 L
.17171 .34283 L
.17187 .34283 L
.17203 .34283 L
Mistroke
.17218 .34283 L
.17234 .28674 L
.17247 .28674 L
.1726 .28674 L
.17273 .28674 L
.17286 .28674 L
.17299 .28674 L
.17312 .28674 L
.17325 .28674 L
.17338 .28674 L
.17351 .28674 L
.17365 .28674 L
.17378 .28674 L
.17391 .28674 L
.17404 .28674 L
.17417 .28674 L
.1743 .28674 L
.17443 .28674 L
.17456 .28674 L
.17469 .28674 L
.17482 .28674 L
.17495 .28674 L
.17508 .28674 L
.17521 .28674 L
.17534 .28674 L
.17547 .28674 L
.1756 .28674 L
.17573 .28674 L
.17586 .28674 L
.17599 .28674 L
.17613 .28674 L
.17626 .2397 L
.17636 .2397 L
.17647 .2397 L
.17658 .2397 L
.17669 .2397 L
.1768 .2397 L
.1769 .2397 L
.17701 .2397 L
.17712 .2397 L
.17723 .2397 L
.17734 .2397 L
.17744 .2397 L
.17755 .2397 L
.17766 .2397 L
.17777 .2397 L
.17788 .2397 L
.17798 .2397 L
.17809 .2397 L
.1782 .2397 L
Mistroke
.17831 .2397 L
.17841 .2397 L
.17852 .2397 L
.17863 .2397 L
.17874 .2397 L
.17885 .2397 L
.17895 .2397 L
.17906 .2397 L
.17917 .2397 L
.17928 .2397 L
.17939 .2397 L
.17949 .2397 L
.1796 .2397 L
.17971 .2397 L
.17982 .2397 L
.17993 .2397 L
.18003 .2397 L
.18014 .2397 L
.18025 .2397 L
.18036 .2397 L
.18047 .2397 L
.18057 .2397 L
.18068 .2397 L
.18079 .20091 L
.18088 .20091 L
.18097 .16969 L
.18104 .14238 L
.1811 .11822 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01472 L
.18115 .01474 L
.18115 .01474 L
.18115 .01474 L
.18115 .01474 L
.18115 .01493 L
.18115 .01493 L
.18115 .01493 L
.18115 .01493 L
.18115 .01493 L
.18115 .01691 L
Mistroke
.18116 .01691 L
.18116 .01691 L
.18116 .01691 L
.18116 .01691 L
.18116 .01691 L
.18116 .03665 L
.18117 .03665 L
.18118 .03665 L
.18119 .03665 L
.1812 .03665 L
.18121 .03665 L
.18122 .03665 L
.18123 .07636 L
.18126 .07636 L
.18129 .07636 L
.18132 .07636 L
.18135 .07636 L
.18138 .07636 L
.18141 .07636 L
.18144 .07636 L
.18147 .10192 L
.18151 .10192 L
.18155 .10192 L
.1816 .10192 L
.18164 .10192 L
.18168 .10192 L
.18172 .10192 L
.18176 .10192 L
.18181 .10192 L
.18185 .137 L
.18191 .137 L
.18196 .137 L
.18202 .137 L
.18208 .137 L
.18214 .137 L
.1822 .137 L
.18226 .137 L
.18232 .137 L
.18238 .137 L
.18243 .17614 L
.18251 .17614 L
.18259 .17614 L
.18267 .17614 L
.18274 .17614 L
.18282 .17614 L
.1829 .17614 L
.18298 .17614 L
.18305 .17614 L
.18313 .17614 L
.18321 .17614 L
Mistroke
.18329 .19296 L
.18337 .19296 L
.18346 .19296 L
.18354 .19296 L
.18363 .19296 L
.18371 .19296 L
.1838 .19296 L
.18389 .19296 L
.18397 .19296 L
.18406 .19296 L
.18414 .19296 L
.18423 .19296 L
.18431 .19296 L
.1844 .19296 L
.18448 .19296 L
.18457 .22315 L
.18467 .22315 L
.18477 .22315 L
.18487 .22315 L
.18497 .22315 L
.18507 .22315 L
.18517 .22315 L
.18527 .22315 L
.18537 .22315 L
.18547 .22315 L
.18557 .22315 L
.18567 .22315 L
.18577 .22315 L
.18587 .22315 L
.18597 .22315 L
.18607 .22315 L
.18617 .22315 L
.18627 .22315 L
.18637 .15491 L
.18644 .15491 L
.1865 .15491 L
.18657 .15491 L
.18664 .15491 L
.18671 .15491 L
.18677 .15491 L
.18684 .15491 L
.18691 .15491 L
.18697 .15491 L
.18704 .15491 L
.18711 .15491 L
.18718 .15491 L
.18724 .15491 L
.18731 .18928 L
.18739 .18928 L
.18748 .18928 L
Mistroke
.18756 .18928 L
.18765 .18928 L
.18773 .18928 L
.18781 .18928 L
.1879 .18928 L
.18798 .18928 L
.18807 .18928 L
.18815 .18928 L
.18823 .12016 L
.18828 .12016 L
.18833 .12016 L
.18838 .12016 L
.18843 .12016 L
.18849 .12016 L
.18854 .12016 L
.18859 .12016 L
.18864 .12016 L
.18869 .12016 L
.18874 .13262 L
.1888 .13262 L
.18885 .13262 L
.18891 .13262 L
.18896 .13262 L
.18902 .13262 L
.18908 .13262 L
.18913 .13262 L
.18919 .13262 L
.18925 .13262 L
.1893 .13262 L
.18936 .13262 L
.18942 .13262 L
.18947 .13262 L
.18953 .13262 L
.18959 .13262 L
.18964 .13262 L
.1897 .13262 L
.18976 .13262 L
.18981 .13262 L
.18987 .13262 L
.18993 .12217 L
.18998 .12217 L
.19003 .12217 L
.19008 .12217 L
.19013 .12217 L
.19018 .12217 L
.19024 .12217 L
.19029 .12217 L
.19034 .12217 L
.19039 .12217 L
.19044 .15918 L
Mistroke
.19051 .15918 L
.19058 .15918 L
.19065 .15918 L
.19072 .15918 L
.19079 .15918 L
.19086 .15918 L
.19093 .15918 L
.191 .15918 L
.19107 .15918 L
.19114 .18216 L
.19122 .18216 L
.1913 .18216 L
.19138 .18216 L
.19146 .18216 L
.19154 .18216 L
.19162 .18216 L
.1917 .18216 L
.19178 .18216 L
.19186 .18216 L
.19194 .18216 L
.19202 .21805 L
.19212 .21805 L
.19221 .21805 L
.19231 .21805 L
.19241 .21805 L
.19251 .21805 L
.1926 .21805 L
.1927 .21805 L
.1928 .21805 L
.1929 .21805 L
.19299 .21805 L
.19309 .25364 L
.19321 .25364 L
.19332 .25364 L
.19344 .25364 L
.19355 .25364 L
.19367 .25364 L
.19378 .25364 L
.19389 .25364 L
.19401 .25364 L
.19412 .25364 L
.19424 .25364 L
.19435 .25364 L
.19447 .28491 L
.1946 .28491 L
.19473 .28491 L
.19486 .28491 L
.19499 .28491 L
.19512 .28491 L
.19525 .28491 L
Mistroke
.19538 .28491 L
.19551 .28491 L
.19563 .28491 L
.19576 .28491 L
.19589 .28491 L
.19602 .28491 L
.19615 .3418 L
.19631 .3418 L
.19647 .3418 L
.19662 .3418 L
.19678 .3418 L
.19694 .3418 L
.19709 .3418 L
.19725 .3418 L
.19741 .3418 L
.19757 .3418 L
.19772 .3418 L
.19788 .3418 L
.19804 .3418 L
.19819 .38308 L
.19837 .38308 L
.19855 .38308 L
.19872 .38308 L
.1989 .38308 L
.19908 .38308 L
.19925 .38308 L
.19943 .38308 L
.19961 .38308 L
.19978 .38308 L
.19996 .38308 L
.20014 .38308 L
.20031 .38308 L
.20049 .38308 L
.20067 .38308 L
.20084 .38308 L
.20102 .37497 L
.20119 .37497 L
.20137 .37497 L
.20154 .37497 L
.20171 .37497 L
.20189 .37497 L
.20206 .37497 L
.20223 .37497 L
.2024 .37497 L
.20258 .37497 L
.20275 .37497 L
.20292 .37497 L
.2031 .37497 L
.20327 .37497 L
.20344 .37497 L
Mistroke
.20361 .37497 L
.20379 .37497 L
.20396 .37497 L
.20413 .37497 L
.20431 .41341 L
.2045 .41341 L
.20469 .41341 L
.20488 .41341 L
.20507 .41341 L
.20526 .41341 L
.20545 .41341 L
.20564 .41341 L
.20584 .41341 L
.20603 .41341 L
.20622 .41341 L
.20641 .41341 L
.2066 .50091 L
.20683 .50091 L
.20707 .50091 L
.2073 .50091 L
.20753 .50091 L
.20777 .50091 L
.208 .50091 L
.20823 .50091 L
.20847 .50091 L
.2087 .50091 L
.20893 .50091 L
.20917 .50091 L
.2094 .50091 L
.20963 .50091 L
.20987 .50091 L
.2101 .50091 L
.21033 .50091 L
.21057 .50091 L
.2108 .50091 L
.21103 .50091 L
.21127 .50091 L
.2115 .50091 L
.21173 .50091 L
.21197 .50091 L
.2122 .50091 L
.21243 .50091 L
.21267 .50091 L
.2129 .50091 L
.21313 .50091 L
.21337 .50091 L
.2136 .50091 L
.21383 .50091 L
.21407 .50091 L
.2143 .50091 L
Mistroke
.21453 .50091 L
.21477 .50091 L
.215 .50091 L
.21523 .50091 L
.21547 .50091 L
.2157 .50091 L
.21593 .50091 L
.21617 .50091 L
.2164 .50091 L
.21663 .50091 L
.21687 .50091 L
.2171 .50091 L
.21733 .50091 L
.21757 .50091 L
.2178 .50091 L
.21803 .50091 L
.21827 .50091 L
.2185 .50091 L
.21873 .50091 L
.21897 .50091 L
.2192 .50091 L
.21943 .50091 L
.21967 .41842 L
.21986 .41842 L
.22005 .34661 L
.22021 .28254 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01472 L
.22034 .01473 L
.22034 .01473 L
.22034 .01473 L
.22034 .01473 L
.22034 .01485 L
.22034 .01485 L
.22034 .01485 L
.22034 .01485 L
.22034 .01485 L
.22034 .01604 L
.22034 .01604 L
.22034 .01604 L
Mistroke
.22034 .01604 L
.22034 .01604 L
.22034 .01604 L
.22034 .02801 L
.22035 .02801 L
.22036 .02801 L
.22036 .02801 L
.22037 .02801 L
.22038 .02801 L
.22038 .02801 L
.22039 .10374 L
.22043 .10374 L
.22047 .10374 L
.22052 .10374 L
.22056 .10374 L
.2206 .10374 L
.22065 .10374 L
.22069 .10374 L
.22073 .16583 L
.2208 .16583 L
.22088 .16583 L
.22095 .16583 L
.22102 .16583 L
.22109 .16583 L
.22117 .16583 L
.22124 .16583 L
.22131 .16583 L
.22138 .21644 L
.22148 .21644 L
.22158 .21644 L
.22167 .21644 L
.22177 .21644 L
.22187 .21644 L
.22196 .21644 L
.22206 .21644 L
.22216 .21644 L
.22225 .21644 L
.22235 .25163 L
.22247 .25163 L
.22258 .25163 L
.22269 .25163 L
.22281 .25163 L
.22292 .25163 L
.22303 .25163 L
.22315 .25163 L
.22326 .25163 L
.22337 .25163 L
.22349 .25163 L
.2236 .28102 L
.22373 .28102 L
Mistroke
.22386 .28102 L
.22399 .28102 L
.22411 .28102 L
.22424 .28102 L
.22437 .28102 L
.2245 .28102 L
.22462 .28102 L
.22475 .28102 L
.22488 .28102 L
.22501 .28102 L
.22514 .30865 L
.22528 .30865 L
.22542 .30865 L
.22556 .30865 L
.2257 .30865 L
.22584 .30865 L
.22598 .30865 L
.22612 .30865 L
.22626 .30865 L
.2264 .30865 L
.22655 .30865 L
.22669 .30865 L
.22683 .30865 L
.22697 .30865 L
.22711 .30865 L
.22725 .30865 L
.22739 .30865 L
.22753 .30865 L
.22767 .30865 L
.22781 .30865 L
.22796 .30865 L
.2281 .30865 L
.22824 .30865 L
.22838 .30865 L
.22852 .30865 L
.22866 .30865 L
.2288 .25809 L
.22892 .25809 L
.22904 .21369 L
.22913 .17396 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
Mistroke
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01472 L
.22921 .01475 L
.22921 .01475 L
.22921 .01475 L
.22921 .01475 L
.22921 .01475 L
.22921 .01503 L
.22921 .01503 L
.22921 .01503 L
.22921 .01503 L
.22921 .01503 L
.22921 .01785 L
.22921 .01785 L
.22921 .01785 L
.22921 .01785 L
.22921 .01785 L
.22922 .01785 L
.22922 .04609 L
.22923 .04609 L
.22925 .04609 L
.22926 .04609 L
.22928 .04609 L
.22929 .04609 L
.22931 .04609 L
.22932 .08423 L
.22936 .06906 L
.22938 .06906 L
.22941 .06906 L
.22943 .06906 L
.22946 .06906 L
.22949 .06906 L
.22951 .06906 L
.22954 .06906 L
.22956 .09712 L
.2296 .09712 L
.22964 .09712 L
.22968 .09712 L
.22972 .09712 L
.22976 .09712 L
.2298 .09712 L
.22984 .09712 L
.22988 .09712 L
.22992 .14304 L
.22998 .14304 L
.23004 .14304 L
Mistroke
.23011 .14304 L
.23017 .14304 L
.23023 .14304 L
.23029 .14304 L
.23035 .14304 L
.23041 .14304 L
.23047 .14304 L
.23054 .1752 L
.23061 .1752 L
.23069 .1752 L
.23077 .1752 L
.23084 .1752 L
.23092 .1752 L
.231 .1752 L
.23108 .1752 L
.23115 .1752 L
.23123 .1752 L
.23131 .1752 L
.23138 .19511 L
.23147 .19511 L
.23156 .19511 L
.23164 .19511 L
.23173 .19511 L
.23182 .19511 L
.2319 .19511 L
.23199 .19511 L
.23208 .19511 L
.23216 .19511 L
.23225 .19511 L
.23234 .19511 L
.23242 .22313 L
.23252 .22313 L
.23262 .22313 L
.23272 .22313 L
.23282 .22313 L
.23292 .22313 L
.23302 .22313 L
.23312 .22313 L
.23322 .22313 L
.23332 .22313 L
.23342 .22313 L
.23352 .22313 L
.23362 .22313 L
.23372 .22313 L
.23382 .22313 L
.23392 .22313 L
.23402 .22313 L
.23412 .22313 L
.23422 .22313 L
.23432 .22313 L
Mistroke
.23442 .22313 L
.23452 .22313 L
.23462 .22313 L
.23472 .22313 L
.23482 .20586 L
.23491 .20586 L
.23501 .20586 L
.2351 .20586 L
.23519 .20586 L
.23528 .20586 L
.23537 .20586 L
.23546 .20586 L
.23556 .20586 L
.23565 .20586 L
.23574 .20586 L
.23583 .20586 L
.23592 .1798 L
.236 .1798 L
.23608 .1798 L
.23616 .1798 L
.23624 .1798 L
.23632 .1798 L
.2364 .1798 L
.23648 .1798 L
.23656 .1798 L
.23664 .1798 L
.23671 .1798 L
.23679 .1798 L
.23687 .1798 L
.23695 .1798 L
.23703 .1798 L
.23711 .1798 L
.23719 .1798 L
.23727 .1798 L
.23735 .19947 L
.23744 .19947 L
.23753 .19947 L
.23761 .19947 L
.2377 .19947 L
.23779 .19947 L
.23788 .19947 L
.23797 .19947 L
.23806 .19947 L
.23815 .19947 L
.23823 .19947 L
.23832 .19947 L
.23841 .19947 L
.2385 .19947 L
.23859 .19947 L
.23868 .19947 L
Mistroke
.23877 .19947 L
.23886 .19947 L
.23894 .19947 L
.23903 .19947 L
.23912 .19947 L
.23921 .19947 L
.2393 .20537 L
.23939 .20537 L
.23948 .20537 L
.23957 .20537 L
.23966 .20537 L
.23976 .20537 L
.23985 .20537 L
.23994 .20537 L
.24003 .20537 L
.24012 .20537 L
.24021 .20537 L
.24031 .20537 L
.2404 .20537 L
.24049 .04549 L
.2405 .04549 L
.24052 .04549 L
.24053 .04549 L
.24055 .04549 L
.24056 .04549 L
.24058 .04549 L
.24059 .04549 L
.24061 .04549 L
.24062 .04549 L
.24064 .04549 L
.24065 .04549 L
.24067 .06615 L
.24069 .06615 L
.24071 .06615 L
.24074 .06615 L
.24076 .06615 L
.24079 .06615 L
.24081 .06615 L
.24084 .06615 L
.24086 .06615 L
.24089 .06615 L
.24091 .06615 L
.24094 .12844 L
.24099 .12844 L
.24105 .12844 L
.2411 .12844 L
.24115 .12844 L
.24121 .12844 L
.24126 .12844 L
.24132 .12844 L
Mistroke
.24137 .12844 L
.24143 .12844 L
.24148 .12844 L
.24154 .17726 L
.24161 .17726 L
.24169 .17726 L
.24177 .17726 L
.24185 .17726 L
.24193 .17726 L
.242 .17726 L
.24208 .17726 L
.24216 .17726 L
.24224 .17726 L
.24232 .17726 L
.24239 .17726 L
.24247 .22281 L
.24257 .22281 L
.24267 .22281 L
.24277 .22281 L
.24287 .22281 L
.24297 .22281 L
.24307 .22281 L
.24317 .22281 L
.24327 .22281 L
.24337 .22281 L
.24347 .22281 L
.24357 .22281 L
.24367 .22281 L
.24377 .22907 L
.24387 .22907 L
.24398 .22907 L
.24408 .22907 L
.24418 .22907 L
.24429 .22907 L
.24439 .22907 L
.24449 .22907 L
.24459 .22907 L
.2447 .22907 L
.2448 .22907 L
.2449 .22907 L
.24501 .22907 L
.24511 .22907 L
.24521 .22907 L
.24531 .22907 L
.24542 .22907 L
.24552 .22907 L
.24562 .22907 L
.24572 .22907 L
.24583 .22907 L
.24593 .22907 L
Mistroke
.24603 .22907 L
.24614 .22907 L
.24624 .22907 L
.24634 .22907 L
.24644 .22907 L
.24655 .22907 L
.24665 .22907 L
.24675 .22907 L
.24686 .22907 L
.24696 .25477 L
.24707 .25477 L
.24719 .25477 L
.2473 .25477 L
.24742 .25477 L
.24754 .25477 L
.24765 .25477 L
.24777 .25477 L
.24788 .25477 L
.248 .25477 L
.24811 .25477 L
.24823 .25477 L
.24834 .25477 L
.24846 .25477 L
.24857 .25477 L
.24869 .30863 L
.24883 .30863 L
.24897 .30863 L
.24911 .30863 L
.24925 .30863 L
.24939 .30863 L
.24953 .30863 L
.24967 .30863 L
.24982 .30863 L
.24996 .30863 L
.2501 .30863 L
.25024 .30863 L
.25038 .30863 L
.25052 .30863 L
.25066 .30863 L
.2508 .30863 L
.25094 .30863 L
.25108 .30863 L
.25123 .30863 L
.25137 .30863 L
.25151 .30863 L
.25165 .30863 L
.25179 .30863 L
.25193 .30863 L
.25207 .30863 L
.25221 .30863 L
Mistroke
.25235 .30863 L
.25249 .30863 L
.25264 .30863 L
.25278 .30863 L
.25292 .30978 L
.25306 .30978 L
.2532 .30978 L
.25334 .30978 L
.25348 .30978 L
.25363 .30978 L
.25377 .30978 L
.25391 .30978 L
.25405 .30978 L
.25419 .30978 L
.25433 .30978 L
.25448 .30978 L
.25462 .3623 L
.25478 .3623 L
.25495 .3623 L
.25512 .3623 L
.25528 .3623 L
.25545 .3623 L
.25562 .3623 L
.25578 .3623 L
.25595 .3623 L
.25612 .3623 L
.25628 .3623 L
.25645 .39704 L
.25663 .39704 L
.25682 .39704 L
.257 .39704 L
.25719 .39704 L
.25737 .39704 L
.25755 .39704 L
.25774 .39704 L
.25792 .39704 L
.2581 .39704 L
.25829 .39704 L
.25847 .39704 L
.25865 .39704 L
.25884 .39704 L
.25902 .39704 L
.2592 .39704 L
.25939 .39704 L
.25957 .39704 L
.25975 .39704 L
.25994 .39704 L
.26012 .39704 L
.2603 .39704 L
.26049 .39704 L
Mistroke
.26067 .39704 L
.26085 .39704 L
.26104 .39704 L
.26122 .39704 L
.2614 .39704 L
.26159 .39704 L
.26177 .39704 L
.26195 .39704 L
.26214 .39704 L
.26232 .39704 L
.26251 .39704 L
.26269 .39704 L
.26287 .39704 L
.26306 .39704 L
.26324 .33248 L
.26339 .33248 L
.26354 .33248 L
.2637 .33248 L
.26385 .33248 L
.264 .33248 L
.26415 .33248 L
.26431 .33248 L
.26446 .33248 L
.26461 .33248 L
.26476 .33248 L
.26492 .33248 L
.26507 .33248 L
.26522 .33248 L
.26537 .33248 L
.26553 .33248 L
.26568 .33248 L
.26583 .33248 L
.26598 .33248 L
.26614 .33248 L
.26629 .27908 L
.26642 .27908 L
.26654 .27908 L
.26667 .27908 L
.2668 .27908 L
.26692 .27908 L
.26705 .27908 L
.26718 .27908 L
.2673 .27908 L
.26743 .27908 L
.26756 .27908 L
.26768 .27908 L
.26781 .27908 L
.26794 .27908 L
.26806 .27908 L
.26819 .27908 L
Mistroke
.26832 .27908 L
.26844 .27908 L
.26857 .27908 L
.2687 .27908 L
.26883 .27908 L
.26895 .27908 L
.26908 .27908 L
.26921 .27908 L
.26933 .27908 L
.26946 .27908 L
.26959 .27908 L
.26971 .27908 L
.26984 .27908 L
.26997 .27908 L
.27009 .27908 L
.27022 .27908 L
.27035 .27908 L
.27047 .27908 L
.2706 .27908 L
.27073 .27908 L
.27085 .27908 L
.27098 .27908 L
.27111 .27908 L
.27124 .27908 L
.27136 .27908 L
.27149 .27908 L
.27162 .27908 L
.27174 .27908 L
.27187 .27908 L
.272 .27908 L
.27212 .27908 L
.27225 .23491 L
.27236 .23491 L
.27246 .23491 L
.27257 .23491 L
.27267 .23491 L
.27278 .23491 L
.27288 .23491 L
.27299 .23491 L
.2731 .23491 L
.2732 .23491 L
.27331 .23491 L
.27341 .23491 L
.27352 .23491 L
.27362 .23491 L
.27373 .23491 L
.27383 .23491 L
.27394 .23491 L
.27405 .23491 L
.27415 .23491 L
Mistroke
.27426 .23491 L
.27436 .23491 L
.27447 .23491 L
.27457 .23491 L
.27468 .23491 L
.27479 .23491 L
.27489 .23491 L
.275 .23491 L
.2751 .23491 L
.27521 .23491 L
.27531 .23491 L
.27542 .23491 L
.27553 .23491 L
.27563 .23491 L
.27574 .23491 L
.27584 .23491 L
.27595 .23491 L
.27605 .23491 L
.27616 .23491 L
.27626 .23491 L
.27637 .23491 L
.27648 .23491 L
.27658 .23491 L
.27669 .23491 L
.27679 .23491 L
.2769 .23491 L
.277 .23491 L
.27711 .23491 L
.27722 .23491 L
.27732 .23491 L
.27743 .23491 L
.27753 .23491 L
.27764 .23491 L
.27774 .23491 L
.27785 .23491 L
.27796 .23491 L
.27806 .23491 L
.27817 .18717 L
.27825 .18717 L
.27833 .18717 L
.27841 .18717 L
.2785 .18717 L
.27858 .18717 L
.27866 .18717 L
.27875 .18717 L
.27883 .18717 L
.27891 .18717 L
.27899 .18717 L
.27908 .16535 L
.27915 .16535 L
Mistroke
.27922 .16535 L
.27929 .16535 L
.27937 .16535 L
.27944 .16535 L
.27951 .16535 L
.27958 .16535 L
.27966 .16535 L
.27973 .16535 L
.2798 .16535 L
.27987 .20377 L
.27996 .20377 L
.28005 .20377 L
.28014 .20377 L
.28023 .20377 L
.28033 .20377 L
.28042 .20377 L
.28051 .20377 L
.2806 .20377 L
.28069 .20377 L
.28078 .20377 L
.28087 .20377 L
.28096 .20377 L
.28105 .20377 L
.28114 .20377 L
.28123 .20377 L
.28132 .20377 L
.28141 .20377 L
.2815 .20377 L
.2816 .20377 L
.28169 .18552 L
.28177 .18552 L
.28185 .18552 L
.28193 .18552 L
.28201 .18552 L
.2821 .18552 L
.28218 .18552 L
.28226 .18552 L
.28234 .18552 L
.28242 .18552 L
.28251 .18552 L
.28259 .15407 L
.28265 .15407 L
.28272 .15407 L
.28279 .15407 L
.28286 .15407 L
.28292 .15407 L
.28299 .15407 L
.28306 .15407 L
.28312 .15407 L
.28319 .15407 L
Mistroke
.28326 .19313 L
.28334 .19313 L
.28343 .19313 L
.28351 .19313 L
.2836 .19313 L
.28368 .19313 L
.28377 .19313 L
.28386 .19313 L
.28394 .19313 L
.28403 .19313 L
.28411 .14345 L
.28417 .14345 L
.28424 .14345 L
.2843 .14345 L
.28436 .14345 L
.28442 .14345 L
.28448 .14345 L
.28454 .14345 L
.28461 .14345 L
.28467 .14345 L
.28473 .18223 L
.28481 .18223 L
.28489 .18223 L
.28497 .18223 L
.28505 .18223 L
.28513 .18223 L
.28521 .18223 L
.28529 .18223 L
.28537 .18223 L
.28545 .18223 L
.28553 .21747 L
.28563 .21747 L
.28573 .21747 L
.28583 .21747 L
.28592 .21747 L
.28602 .21747 L
.28612 .21747 L
.28621 .21747 L
.28631 .21747 L
.28641 .21747 L
.28651 .21747 L
.2866 .29121 L
.28674 .29121 L
.28687 .29121 L
.287 .29121 L
.28713 .29121 L
.28727 .29121 L
.2874 .29121 L
.28753 .29121 L
.28767 .29121 L
Mistroke
.2878 .29121 L
.28793 .29121 L
.28806 .29121 L
.2882 .35394 L
.28836 .35394 L
.28852 .35394 L
.28868 .35394 L
.28885 .35394 L
.28901 .35394 L
.28917 .35394 L
.28934 .35394 L
.2895 .35394 L
.28966 .35394 L
.28982 .35394 L
.28999 .35394 L
.29015 .35394 L
.29031 .2973 L
.29045 .2973 L
.29058 .2973 L
.29072 .2973 L
.29085 .2973 L
.29099 .2973 L
.29113 .2973 L
.29126 .2973 L
.2914 .2973 L
.29153 .2973 L
.29167 .2973 L
.2918 .2973 L
.29194 .42737 L
.29214 .42737 L
.29234 .42737 L
.29253 .42737 L
.29273 .42737 L
.29293 .42737 L
.29313 .42737 L
.29333 .42737 L
.29352 .42737 L
.29372 .42737 L
.29392 .42737 L
.29412 .42737 L
.29432 .36534 L
.29448 .36534 L
.29465 .36534 L
.29482 .36534 L
.29499 .36534 L
.29516 .36534 L
.29532 .36534 L
.29549 .36534 L
.29566 .36534 L
.29583 .36534 L
Mistroke
.296 .36534 L
.29617 .36534 L
.29633 .36534 L
.2965 .36534 L
.29667 .36534 L
.29684 .36534 L
.29701 .36534 L
.29718 .36534 L
.29734 .36534 L
.29751 .36534 L
.29768 .36534 L
.29785 .41257 L
.29804 .41257 L
.29823 .41257 L
.29842 .41257 L
.29861 .41257 L
.2988 .41257 L
.29899 .41257 L
.29918 .41257 L
.29938 .41257 L
.29957 .41257 L
.29976 .41257 L
.29995 .41257 L
.30014 .41257 L
.30033 .41257 L
.30052 .41257 L
.30071 .41257 L
.3009 .41257 L
.30109 .41257 L
.30128 .41257 L
.30148 .41257 L
.30167 .41257 L
.30186 .41257 L
.30205 .41257 L
.30224 .41257 L
.30243 .41257 L
.30262 .41257 L
.30281 .41257 L
.303 .34407 L
.30316 .34407 L
.30332 .34407 L
.30348 .34407 L
.30363 .34407 L
.30379 .34407 L
.30395 .34407 L
.30411 .34407 L
.30427 .34407 L
.30442 .34407 L
.30458 .34407 L
.30474 .34407 L
Mistroke
.3049 .34407 L
.30506 .34407 L
.30521 .34407 L
.30537 .34407 L
.30553 .34407 L
.30569 .34407 L
.30585 .34407 L
.306 .34407 L
.30616 .34407 L
.30632 .34407 L
.30648 .34407 L
.30664 .34407 L
.30679 .34407 L
.30695 .34407 L
.30711 .34407 L
.30727 .34407 L
.30743 .34407 L
.30759 .34407 L
.30774 .34407 L
.3079 .34407 L
.30806 .34407 L
.30822 .34407 L
.30838 .287 L
.30851 .287 L
.30864 .24138 L
.30875 .20233 L
.30884 .16784 L
.30891 .13739 L
.30897 .11256 L
.30901 .09247 L
.30905 .07642 L
.30908 .0712 L
.30911 .0712 L
.30914 .0712 L
.30916 .0712 L
.30919 .0712 L
.30922 .0712 L
.30924 .0712 L
.30927 .10099 L
.30931 .08075 L
.30934 .06833 L
.30937 .06833 L
.3094 .06833 L
.30942 .06833 L
.30945 .06833 L
.30947 .06833 L
.3095 .06833 L
.30952 .06833 L
.30955 .115 L
.3096 .115 L
Mistroke
.30965 .115 L
.30969 .115 L
.30974 .115 L
.30979 .115 L
.30984 .115 L
.30989 .115 L
.30994 .13858 L
.30999 .13858 L
.31005 .13858 L
.31011 .13858 L
.31017 .13858 L
.31023 .13858 L
.31029 .13858 L
.31035 .13858 L
.31041 .13858 L
.31047 .17139 L
.31055 .17139 L
.31062 .17139 L
.3107 .17139 L
.31077 .17139 L
.31085 .17139 L
.31092 .17139 L
.311 .17139 L
.31107 .17139 L
.31115 .17139 L
.31122 .22696 L
.31132 .22696 L
.31143 .22696 L
.31153 .22696 L
.31163 .22696 L
.31173 .22696 L
.31183 .22696 L
.31193 .22696 L
.31204 .22696 L
.31214 .22696 L
.31224 .22696 L
.31234 .22696 L
.31244 .22696 L
.31255 .22696 L
.31265 .22696 L
.31275 .22696 L
.31285 .22696 L
.31295 .22696 L
.31305 .22696 L
.31316 .22696 L
.31326 .22696 L
.31336 .22696 L
.31346 .22696 L
.31356 .22696 L
.31367 .22696 L
Mistroke
.31377 .22696 L
.31387 .22696 L
.31397 .22696 L
.31407 .22696 L
.31417 .22696 L
.31428 .22696 L
.31438 .22696 L
.31448 .22696 L
.31458 .22696 L
.31468 .22696 L
.31479 .22696 L
.31489 .22696 L
.31499 .22696 L
.31509 .22696 L
.31519 .22696 L
.3153 .22696 L
.3154 .22696 L
.3155 .22696 L
.3156 .22696 L
.3157 .22696 L
.3158 .22696 L
.31591 .22696 L
.31601 .22696 L
.31611 .22696 L
.31621 .22696 L
.31631 .22696 L
.31642 .22696 L
.31652 .22696 L
.31662 .22696 L
.31672 .22696 L
.31682 .22696 L
.31692 .22696 L
.31703 .22696 L
.31713 .22696 L
.31723 .22696 L
.31733 .22696 L
.31743 .22696 L
.31754 .22696 L
.31764 .22696 L
.31774 .22696 L
.31784 .22696 L
.31794 .22696 L
.31804 .22696 L
.31815 .22696 L
.31825 .22696 L
.31835 .22696 L
.31845 .22696 L
.31855 .22696 L
.31866 .22696 L
.31876 .22696 L
Mistroke
.31886 .22696 L
.31896 .22696 L
.31906 .22696 L
.31917 .19145 L
.31925 .19145 L
.31933 .19145 L
.31942 .19145 L
.3195 .19145 L
.31959 .19145 L
.31967 .19145 L
.31976 .19145 L
.31984 .19145 L
.31993 .19145 L
.32001 .19145 L
.3201 .19145 L
.32018 .19145 L
.32027 .19145 L
.32035 .19145 L
.32044 .19145 L
.32052 .19145 L
.32061 .175 L
.32068 .175 L
.32076 .175 L
.32084 .175 L
.32091 .175 L
.32099 .175 L
.32107 .175 L
.32114 .175 L
.32122 .175 L
.3213 .175 L
.32138 .175 L
.32145 .16509 L
.32152 .16509 L
.3216 .16509 L
.32167 .16509 L
.32174 .16509 L
.32181 .16509 L
.32189 .16509 L
.32196 .16509 L
.32203 .16509 L
.3221 .16509 L
.32217 .16509 L
.32225 .20905 L
.32234 .20905 L
.32243 .20905 L
.32253 .20905 L
.32262 .20905 L
.32271 .20905 L
.32281 .20905 L
.3229 .20905 L
Mistroke
.32299 .20905 L
.32309 .20905 L
.32318 .20905 L
.32327 .20905 L
.32337 .20905 L
.32346 .20905 L
.32355 .20905 L
.32364 .23988 L
.32375 .23988 L
.32386 .23988 L
.32397 .23988 L
.32408 .23988 L
.32419 .23988 L
.32429 .23988 L
.3244 .23988 L
.32451 .23988 L
.32462 .23988 L
.32473 .23988 L
.32483 .23988 L
.32494 .23988 L
.32505 .23988 L
.32516 .23988 L
.32527 .23988 L
.32537 .2333 L
.32548 .2333 L
.32558 .2333 L
.32569 .2333 L
.32579 .2333 L
.3259 .2333 L
.326 .2333 L
.32611 .2333 L
.32621 .2333 L
.32632 .2333 L
.32642 .2333 L
.32653 .2333 L
.32663 .2333 L
.32674 .07528 L
.32677 .07528 L
.3268 .07528 L
.32682 .07528 L
.32685 .07528 L
.32688 .07528 L
.32691 .07528 L
.32694 .07528 L
.32697 .07528 L
.327 .07528 L
.32703 .07528 L
.32706 .07528 L
.32709 .1391 L
.32715 .1391 L
Mistroke
.32721 .1391 L
.32726 .1391 L
.32732 .1391 L
.32738 .1391 L
.32744 .1391 L
.3275 .1391 L
.32756 .1391 L
.32762 .1391 L
.32768 .1391 L
.32774 .21472 L
.32784 .21472 L
.32793 .21472 L
.32803 .21472 L
.32813 .21472 L
.32822 .21472 L
.32832 .21472 L
.32841 .21472 L
.32851 .21472 L
.32861 .21472 L
.3287 .21472 L
.3288 .25285 L
.32891 .25285 L
.32903 .25285 L
.32914 .25285 L
.32925 .25285 L
.32937 .25285 L
.32948 .25285 L
.3296 .25285 L
.32971 .25285 L
.32983 .25285 L
.32994 .25285 L
.33005 .25285 L
.33017 .27481 L
.33029 .27481 L
.33042 .27481 L
.33054 .27481 L
.33067 .27481 L
.33079 .27481 L
.33092 .27481 L
.33104 .27481 L
.33117 .27481 L
.33129 .27481 L
.33142 .27481 L
.33154 .27481 L
.33167 .27481 L
.33179 .27481 L
.33192 .27481 L
.33204 .27481 L
.33217 .27481 L
.33229 .27481 L
Mistroke
.33242 .30908 L
.33256 .30908 L
.3327 .30908 L
.33284 .30908 L
.33298 .30908 L
.33312 .30908 L
.33326 .30908 L
.3334 .30908 L
.33355 .30908 L
.33369 .30908 L
.33383 .30908 L
.33397 .30908 L
.33411 .40087 L
.3343 .40087 L
.33448 .40087 L
.33467 .40087 L
.33485 .40087 L
.33504 .40087 L
.33522 .40087 L
.33541 .40087 L
.33559 .40087 L
.33578 .40087 L
.33596 .40087 L
.33615 .40087 L
.33633 .40087 L
.33652 .40087 L
.3367 .40087 L
.33689 .40087 L
.33707 .40087 L
.33726 .40087 L
.33745 .40087 L
.33763 .40087 L
.33782 .40087 L
.338 .40087 L
.33819 .40087 L
.33837 .40087 L
.33856 .40087 L
.33874 .40087 L
.33893 .40087 L
.33911 .40087 L
.3393 .40087 L
.33948 .40087 L
.33967 .45328 L
.33988 .45328 L
.34009 .45328 L
.3403 .45328 L
.34051 .45328 L
.34072 .45328 L
.34093 .45328 L
.34114 .45328 L
Mistroke
.34135 .45328 L
.34156 .45328 L
.34177 .45328 L
.34198 .45328 L
.34219 .46304 L
.34241 .46304 L
.34262 .46304 L
.34284 .46304 L
.34305 .46304 L
.34327 .46304 L
.34348 .46304 L
.3437 .46304 L
.34391 .46304 L
.34413 .46304 L
.34435 .46304 L
.34456 .46304 L
.34478 .49987 L
.34501 .49987 L
.34524 .49987 L
.34547 .49987 L
.34571 .49987 L
.34594 .49987 L
.34617 .49987 L
.3464 .49987 L
.34664 .49987 L
.34687 .49987 L
.3471 .49987 L
.34734 .49987 L
.34757 .49987 L
.3478 .49987 L
.34803 .49987 L
.34827 .49987 L
.3485 .49987 L
.34873 .49987 L
.34897 .49987 L
.3492 .49987 L
.34943 .49987 L
.34966 .42168 L
.34986 .42168 L
.35005 .42168 L
.35025 .42168 L
.35044 .42168 L
.35064 .42168 L
.35084 .42168 L
.35103 .42168 L
.35123 .42168 L
.35142 .42168 L
.35162 .42168 L
.35181 .42168 L
.35201 .34229 L
Mistroke
.35216 .34229 L
.35232 .34229 L
.35248 .34229 L
.35264 .34229 L
.35279 .34229 L
.35295 .34229 L
.35311 .34229 L
.35326 .34229 L
.35342 .34229 L
.35358 .34229 L
.35374 .34229 L
.35389 .34229 L
.35405 .34229 L
.35421 .34229 L
.35436 .34229 L
.35452 .34229 L
.35468 .34229 L
.35484 .34229 L
.35499 .34229 L
.35515 .34229 L
.35531 .34229 L
.35547 .34229 L
.35562 .34229 L
.35578 .34229 L
.35594 .34229 L
.35609 .34229 L
.35625 .34229 L
.35641 .34229 L
.35657 .34229 L
.35672 .34229 L
.35688 .34229 L
.35704 .34229 L
.35719 .34229 L
.35735 .34229 L
.35751 .34229 L
.35767 .34229 L
.35782 .34229 L
.35798 .34229 L
.35814 .34229 L
.35829 .34229 L
.35845 .34229 L
.35861 .28666 L
.35874 .28666 L
.35887 .23761 L
.35898 .19316 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
Mistroke
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01472 L
.35906 .01475 L
.35906 .01475 L
.35906 .01475 L
.35906 .01475 L
.35906 .01475 L
.35906 .01507 L
.35906 .01507 L
.35906 .01507 L
.35906 .01507 L
.35906 .01507 L
.35906 .01823 L
.35906 .01823 L
.35907 .01823 L
.35907 .01823 L
.35907 .01823 L
.35907 .01823 L
.35907 .04989 L
.35909 .04989 L
.35911 .04989 L
.35912 .04989 L
.35914 .04989 L
.35916 .04989 L
.35917 .04989 L
.35919 .09301 L
.35923 .07376 L
.35926 .06367 L
.35928 .06367 L
.3593 .06367 L
.35933 .06367 L
.35935 .06367 L
.35937 .06367 L
.3594 .06367 L
.35942 .06367 L
.35945 .09968 L
.35949 .09968 L
.35953 .09968 L
.35957 .09968 L
.35961 .09968 L
.35965 .09968 L
Mistroke
.35969 .09968 L
.35973 .09968 L
.35977 .12023 L
.35982 .12023 L
.35987 .12023 L
.35992 .12023 L
.35997 .12023 L
.36002 .12023 L
.36008 .12023 L
.36013 .12023 L
.36018 .12023 L
.36023 .14878 L
.36029 .14878 L
.36036 .14878 L
.36042 .14878 L
.36048 .14878 L
.36055 .14878 L
.36061 .14878 L
.36068 .14878 L
.36074 .14878 L
.36081 .14878 L
.36087 .19827 L
.36096 .19827 L
.36105 .19827 L
.36113 .19827 L
.36122 .19827 L
.36131 .19827 L
.3614 .19827 L
.36149 .19827 L
.36157 .19827 L
.36166 .19827 L
.36175 .19827 L
.36184 .19827 L
.36193 .19827 L
.36202 .19827 L
.3621 .19827 L
.36219 .19827 L
.36228 .19827 L
.36237 .19827 L
.36246 .19827 L
.36254 .19827 L
.36263 .19827 L
.36272 .19827 L
.36281 .19827 L
.3629 .19827 L
.36298 .19827 L
.36307 .19827 L
.36316 .19827 L
.36325 .19827 L
.36334 .19827 L
Mistroke
.36342 .19827 L
.36351 .19827 L
.3636 .19827 L
.36369 .19827 L
.36378 .19827 L
.36386 .19827 L
.36395 .19827 L
.36404 .19827 L
.36413 .19827 L
.36422 .19827 L
.36431 .19827 L
.36439 .19827 L
.36448 .19827 L
.36457 .19827 L
.36466 .19827 L
.36475 .19827 L
.36483 .19827 L
.36492 .19827 L
.36501 .19827 L
.3651 .19827 L
.36519 .19827 L
.36527 .19827 L
.36536 .19827 L
.36545 .19827 L
.36554 .19827 L
.36563 .19827 L
.36571 .19827 L
.3658 .19827 L
.36589 .19827 L
.36598 .19827 L
.36607 .19827 L
.36615 .19827 L
.36624 .19827 L
.36633 .19827 L
.36642 .19827 L
.36651 .19827 L
.36659 .19827 L
.36668 .19827 L
.36677 .19827 L
.36686 .19827 L
.36695 .19827 L
.36704 .19827 L
.36712 .19827 L
.36721 .19827 L
.3673 .19827 L
.36739 .19827 L
.36748 .19827 L
.36756 .19827 L
.36765 .19827 L
.36774 .19827 L
Mistroke
.36783 .19827 L
.36792 .19827 L
.368 .19827 L
.36809 .19827 L
.36818 .19827 L
.36827 .19827 L
.36836 .19827 L
.36844 .19827 L
.36853 .19827 L
.36862 .19827 L
.36871 .16321 L
.36878 .16321 L
.36885 .16321 L
.36892 .16321 L
.36899 .16321 L
.36906 .16321 L
.36914 .16321 L
.36921 .16321 L
.36928 .16321 L
.36935 .16321 L
.36942 .16321 L
.36949 .16321 L
.36956 .16321 L
.36963 .16321 L
.36971 .16321 L
.36978 .16321 L
.36985 .16321 L
.36992 .18821 L
.37 .18821 L
.37009 .18821 L
.37017 .18821 L
.37025 .18821 L
.37034 .18821 L
.37042 .18821 L
.3705 .18821 L
.37059 .18821 L
.37067 .18821 L
.37075 .18821 L
.37084 .18821 L
.37092 .18821 L
.371 .18821 L
.37109 .18821 L
.37117 .20625 L
.37126 .20625 L
.37135 .20625 L
.37144 .20625 L
.37154 .20625 L
.37163 .20625 L
.37172 .20625 L
.37181 .20625 L
Mistroke
.3719 .20625 L
.372 .20625 L
.37209 .20625 L
.37218 .20625 L
.37227 .20625 L
.37236 .20625 L
.37246 .20625 L
.37255 .20625 L
.37264 .20625 L
.37273 .20625 L
.37282 .20625 L
.37291 .23828 L
.37302 .23828 L
.37313 .23828 L
.37324 .23828 L
.37334 .23828 L
.37345 .23828 L
.37356 .23828 L
.37367 .23828 L
.37377 .23828 L
.37388 .23828 L
.37399 .23828 L
.37409 .23828 L
.3742 .23828 L
.37431 .06448 L
.37433 .06448 L
.37436 .06448 L
.37438 .06448 L
.3744 .06448 L
.37443 .06448 L
.37445 .06448 L
.37448 .06448 L
.3745 .06448 L
.37452 .06448 L
.37455 .06448 L
.37457 .06448 L
.3746 .11518 L
.37464 .11518 L
.37469 .11518 L
.37474 .11518 L
.37479 .11518 L
.37484 .11518 L
.37489 .11518 L
.37493 .11518 L
.37498 .11518 L
.37503 .11518 L
.37508 .11518 L
.37513 .20545 L
.37522 .20545 L
.37531 .20545 L
Mistroke
.3754 .20545 L
.37549 .20545 L
.37558 .20545 L
.37568 .20545 L
.37577 .20545 L
.37586 .20545 L
.37595 .20545 L
.37604 .20545 L
.37613 .23515 L
.37624 .23515 L
.37634 .23515 L
.37645 .23515 L
.37656 .23515 L
.37666 .23515 L
.37677 .23515 L
.37687 .23515 L
.37698 .23515 L
.37708 .23515 L
.37719 .23515 L
.3773 .23515 L
.3774 .26606 L
.37752 .26606 L
.37764 .26606 L
.37776 .26606 L
.37788 .26606 L
.37801 .26606 L
.37813 .26606 L
.37825 .26606 L
.37837 .26606 L
.37849 .26606 L
.37861 .26606 L
.37873 .26606 L
.37885 .26606 L
.37897 .26606 L
.37909 .26606 L
.37921 .29871 L
.37935 .29871 L
.37948 .29871 L
.37962 .29871 L
.37976 .29871 L
.37989 .29871 L
.38003 .29871 L
.38016 .29871 L
.3803 .29871 L
.38044 .29871 L
.38057 .29871 L
.38071 .29871 L
.38085 .33668 L
.381 .33668 L
.38116 .33668 L
Mistroke
.38131 .33668 L
.38146 .33668 L
.38162 .33668 L
.38177 .33668 L
.38193 .33668 L
.38208 .33668 L
.38224 .33668 L
.38239 .33668 L
.38255 .33668 L
.3827 .26234 L
.38282 .26234 L
.38294 .26234 L
.38306 .26234 L
.38318 .26234 L
.38329 .26234 L
.38341 .26234 L
.38353 .26234 L
.38365 .26234 L
.38377 .26234 L
.38389 .26234 L
.38401 .28937 L
.38414 .28937 L
.38427 .28937 L
.3844 .28937 L
.38453 .28937 L
.38467 .28937 L
.3848 .28937 L
.38493 .28937 L
.38506 .28937 L
.38519 .28937 L
.38532 .28937 L
.38546 .35893 L
.38562 .35893 L
.38579 .35893 L
.38595 .35893 L
.38612 .35893 L
.38628 .35893 L
.38645 .35893 L
.38661 .35893 L
.38678 .35893 L
.38694 .35893 L
.38711 .35893 L
.38727 .40936 L
.38746 .40936 L
.38765 .40936 L
.38784 .40936 L
.38803 .40936 L
.38822 .40936 L
.38841 .40936 L
.3886 .40936 L
Mistroke
.38879 .40936 L
.38898 .40936 L
.38917 .40936 L
.38936 .40936 L
.38955 .40936 L
.38974 .40936 L
.38992 .40936 L
.39011 .40936 L
.3903 .40936 L
.39049 .40936 L
.39068 .40936 L
.39087 .40936 L
.39106 .40936 L
.39125 .40936 L
.39144 .40936 L
.39163 .40936 L
.39182 .40936 L
.39201 .40936 L
.3922 .40936 L
.39239 .40936 L
.39258 .40936 L
.39276 .40936 L
.39295 .40936 L
.39314 .40936 L
.39333 .40936 L
.39352 .40936 L
.39371 .40936 L
.3939 .40936 L
.39409 .40936 L
.39428 .40936 L
.39447 .40936 L
.39466 .40936 L
.39485 .40936 L
.39504 .3403 L
.39519 .3403 L
.39535 .28544 L
.39548 .23811 L
.39559 .19736 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
.39567 .01472 L
Mistroke
.39567 .01475 L
.39567 .01475 L
.39567 .01475 L
.39567 .01475 L
.39567 .01475 L
.39567 .01509 L
.39567 .01509 L
.39567 .01509 L
.39567 .01509 L
.39568 .01509 L
.39568 .01844 L
.39568 .01844 L
.39568 .01844 L
.39568 .01844 L
.39568 .01844 L
.39568 .01844 L
.39569 .05199 L
.3957 .05199 L
.39572 .05199 L
.39574 .05199 L
.39576 .05199 L
.39578 .05199 L
.39579 .05199 L
.39581 .12316 L
.39586 .12316 L
.39592 .12316 L
.39597 .10502 L
.39601 .10502 L
.39605 .10502 L
.3961 .10502 L
.39614 .10502 L
.39618 .10502 L
.39623 .10502 L
.39627 .10502 L
.39631 .1658 L
.39639 .1658 L
.39646 .1658 L
.39653 .1658 L
.3966 .1658 L
.39668 .1658 L
.39675 .1658 L
.39682 .1658 L
.39689 .1658 L
.39697 .21264 L
.39706 .21264 L
.39716 .21264 L
.39725 .21264 L
.39735 .21264 L
.39744 .21264 L
.39754 .21264 L
Mistroke
.39763 .21264 L
.39773 .21264 L
.39782 .21264 L
.39792 .27554 L
.39804 .27554 L
.39817 .27554 L
.39829 .27554 L
.39842 .27554 L
.39854 .27554 L
.39867 .27554 L
.39879 .27554 L
.39892 .27554 L
.39904 .27554 L
.39917 .27554 L
.39929 .27554 L
.39942 .27554 L
.39954 .27554 L
.39967 .27554 L
.39979 .27554 L
.39992 .27554 L
.40004 .27554 L
.40017 .27554 L
.40029 .27554 L
.40042 .27554 L
.40054 .27554 L
.40067 .27554 L
.40079 .27554 L
.40092 .27554 L
.40104 .27554 L
.40117 .27554 L
.4013 .27554 L
.40142 .27554 L
.40155 .27554 L
.40167 .27554 L
.4018 .27554 L
.40192 .27554 L
.40205 .27554 L
.40217 .27554 L
.4023 .27554 L
.40242 .27554 L
.40255 .27554 L
.40267 .27554 L
.4028 .27554 L
.40292 .27554 L
.40305 .27554 L
.40317 .27554 L
.4033 .27554 L
.40342 .27554 L
.40355 .27554 L
.40367 .27554 L
Mistroke
.4038 .27554 L
.40392 .27554 L
.40405 .27554 L
.40417 .27554 L
.4043 .23128 L
.4044 .23128 L
.40451 .23128 L
.40461 .23128 L
.40471 .23128 L
.40482 .23128 L
.40492 .23128 L
.40503 .23128 L
.40513 .23128 L
.40523 .23128 L
.40534 .23128 L
.40544 .23128 L
.40555 .23128 L
.40565 .23128 L
.40575 .23128 L
.40586 .23128 L
.40596 .23128 L
.40607 .23128 L
.40617 .23128 L
.40627 .23128 L
.40638 .23128 L
.40648 .23128 L
.40658 .23128 L
.40669 .23128 L
.40679 .23128 L
.4069 .23128 L
.407 .23128 L
.4071 .23128 L
.40721 .23128 L
.40731 .23128 L
.40742 .23128 L
.40752 .23128 L
.40762 .23128 L
.40773 .23128 L
.40783 .23128 L
.40794 .23128 L
.40804 .23128 L
.40814 .23128 L
.40825 .23128 L
.40835 .23128 L
.40846 .23128 L
.40856 .19464 L
.40865 .19464 L
.40873 .19464 L
.40882 .19464 L
.4089 .19464 L
Mistroke
.40899 .19464 L
.40908 .19464 L
.40916 .19464 L
.40925 .19464 L
.40934 .19464 L
.40942 .19464 L
.40951 .19464 L
.4096 .19464 L
.40968 .19464 L
.40977 .19464 L
.40985 .19464 L
.40994 .19464 L
.41003 .19464 L
.41011 .19464 L
.4102 .19464 L
.41029 .19464 L
.41037 .19464 L
.41046 .19464 L
.41054 .19464 L
.41063 .19464 L
.41072 .19464 L
.4108 .19464 L
.41089 .19464 L
.41098 .19464 L
.41106 .19464 L
.41115 .19464 L
.41124 .19464 L
.41132 .19464 L
.41141 .19464 L
.41149 .19464 L
.41158 .19464 L
.41167 .19464 L
.41175 .19464 L
.41184 .19464 L
.41193 .19464 L
.41201 .19464 L
.4121 .19464 L
.41218 .19464 L
.41227 .19464 L
.41236 .19464 L
.41244 .19464 L
.41253 .19464 L
.41262 .16406 L
.41269 .16406 L
.41276 .16406 L
.41283 .16406 L
.4129 .16406 L
.41297 .16406 L
.41305 .16406 L
.41312 .16406 L
Mistroke
.41319 .16406 L
.41326 .16406 L
.41333 .16406 L
.4134 .14541 L
.41347 .14541 L
.41353 .14541 L
.41359 .14541 L
.41366 .14541 L
.41372 .14541 L
.41378 .14541 L
.41384 .14541 L
.41391 .14541 L
.41397 .14541 L
.41403 .14541 L
.41409 .14541 L
.41416 .14541 L
.41422 .14541 L
.41428 .19614 L
.41437 .19614 L
.41446 .19614 L
.41454 .19614 L
.41463 .19614 L
.41472 .19614 L
.41481 .19614 L
.41489 .19614 L
.41498 .19614 L
.41507 .19614 L
.41515 .19614 L
.41524 .19614 L
.41533 .22373 L
.41543 .22373 L
.41553 .22373 L
.41563 .22373 L
.41573 .22373 L
.41583 .22373 L
.41593 .22373 L
.41603 .22373 L
.41613 .22373 L
.41623 .22373 L
.41633 .22373 L
.41643 .22373 L
.41653 .22373 L
.41663 .22373 L
.41673 .22373 L
.41683 .22373 L
.41693 .25176 L
.41705 .25176 L
.41716 .25176 L
.41727 .25176 L
.41739 .25176 L
Mistroke
.4175 .25176 L
.41761 .25176 L
.41773 .25176 L
.41784 .25176 L
.41796 .25176 L
.41807 .25176 L
.41818 .25176 L
.4183 .25176 L
.41841 .04751 L
.41843 .04751 L
.41844 .04751 L
.41846 .04751 L
.41847 .04751 L
.41849 .04751 L
.41851 .04751 L
.41852 .04751 L
.41854 .04751 L
.41855 .04751 L
.41857 .04751 L
.41858 .04751 L
.4186 .08374 L
.41863 .08374 L
.41867 .08374 L
.4187 .08374 L
.41873 .08374 L
.41877 .08374 L
.4188 .08374 L
.41883 .08374 L
.41886 .08374 L
.4189 .08374 L
.41893 .08374 L
.41896 .19006 L
.41905 .19006 L
.41913 .19006 L
.41922 .19006 L
.4193 .19006 L
.41938 .19006 L
.41947 .19006 L
.41955 .19006 L
.41964 .19006 L
.41972 .19006 L
.41981 .19006 L
.41989 .24589 L
.42 .24589 L
.42011 .24589 L
.42022 .24589 L
.42033 .24589 L
.42044 .24589 L
.42055 .24589 L
.42067 .24589 L
Mistroke
.42078 .24589 L
.42089 .24589 L
.421 .24589 L
.42111 .24589 L
.42122 .27325 L
.42134 .27325 L
.42147 .27325 L
.42159 .27325 L
.42172 .27325 L
.42184 .27325 L
.42196 .27325 L
.42209 .27325 L
.42221 .27325 L
.42234 .27325 L
.42246 .27325 L
.42258 .27325 L
.42271 .27325 L
.42283 .27325 L
.42296 .27325 L
.42308 .27325 L
.42321 .27325 L
.42333 .27325 L
.42345 .27325 L
.42358 .27325 L
.4237 .27325 L
.42383 .30801 L
.42397 .30801 L
.42411 .30801 L
.42425 .30801 L
.42439 .30801 L
.42453 .30801 L
.42467 .30801 L
.42481 .30801 L
.42495 .30801 L
.42509 .30801 L
.42523 .30801 L
.42537 .30801 L
.42551 .37956 L
.42569 .37956 L
.42586 .37956 L
.42604 .37956 L
.42621 .37956 L
.42639 .37956 L
.42656 .37956 L
.42674 .37956 L
.42691 .37956 L
.42709 .37956 L
.42726 .37956 L
.42744 .37956 L
.42761 .37956 L
Mistroke
.42779 .37956 L
.42796 .37956 L
.42814 .37956 L
.42832 .37956 L
.42849 .37956 L
.42867 .37956 L
.42884 .37956 L
.42902 .37956 L
.42919 .37956 L
.42937 .37956 L
.42954 .37956 L
.42972 .37956 L
.42989 .37956 L
.43007 .37956 L
.43024 .37956 L
.43042 .37956 L
.43059 .37956 L
.43077 .37956 L
.43094 .37956 L
.43112 .37956 L
.43129 .42541 L
.43149 .42541 L
.43169 .42541 L
.43188 .42541 L
.43208 .42541 L
.43228 .42541 L
.43247 .42541 L
.43267 .42541 L
.43287 .42541 L
.43306 .42541 L
.43326 .42541 L
.43346 .42541 L
.43366 .48331 L
.43388 .48331 L
.43411 .48331 L
.43433 .48331 L
.43456 .48331 L
.43478 .48331 L
.435 .48331 L
.43523 .48331 L
.43545 .48331 L
.43568 .48331 L
.4359 .48331 L
.43613 .48331 L
.43635 .54268 L
.43661 .54268 L
.43686 .54268 L
.43711 .54268 L
.43737 .54268 L
.43762 .54268 L
Mistroke
.43787 .54268 L
.43813 .54268 L
.43838 .54268 L
.43863 .54268 L
.43889 .54268 L
.43914 .54268 L
.43939 .44391 L
.4396 .44391 L
.43981 .44391 L
.44001 .44391 L
.44022 .44391 L
.44042 .44391 L
.44063 .44391 L
.44084 .44391 L
.44104 .44391 L
.44125 .44391 L
.44145 .44391 L
.44166 .44391 L
.44186 .44391 L
.44207 .44391 L
.44228 .44391 L
.44248 .44391 L
.44269 .44391 L
.44289 .44391 L
.4431 .44391 L
.44331 .44391 L
.44351 .44391 L
.44372 .44391 L
.44392 .44391 L
.44413 .44391 L
.44434 .44391 L
.44454 .44391 L
.44475 .44391 L
.44495 .44391 L
.44516 .44391 L
.44537 .44391 L
.44557 .44391 L
.44578 .44391 L
.44598 .44391 L
.44619 .60332 L
.44647 .60332 L
.44675 .60332 L
.44704 .60332 L
.44732 .60332 L
.4476 .60332 L
.44788 .60332 L
.44817 .60332 L
.44845 .60332 L
.44873 .60332 L
.44901 .60332 L
Mistroke
.4493 .60332 L
.44958 .60332 L
.44986 .60332 L
.45014 .60332 L
.45043 .60332 L
.45071 .60332 L
.45099 .50119 L
.45122 .50119 L
.45146 .41193 L
.45165 .33236 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01472 L
.4518 .01473 L
.4518 .01473 L
.4518 .01473 L
.4518 .01473 L
.4518 .01487 L
.4518 .01487 L
.4518 .01487 L
.4518 .01487 L
.4518 .01487 L
.4518 .01628 L
.4518 .01628 L
.4518 .01628 L
.4518 .01628 L
.4518 .01628 L
.4518 .03037 L
.45181 .03037 L
.45182 .03037 L
.45183 .03037 L
.45183 .03037 L
.45184 .03037 L
.45185 .08599 L
.45188 .08599 L
.45192 .08599 L
.45195 .08599 L
.45199 .08599 L
.45202 .08599 L
.45206 .08599 L
.45209 .13835 L
Mistroke
.45215 .13835 L
.45221 .13835 L
.45227 .13835 L
.45233 .13835 L
.45239 .13835 L
.45245 .13835 L
.4525 .13835 L
.45256 .19848 L
.45265 .19848 L
.45274 .19848 L
.45283 .19848 L
.45292 .19848 L
.453 .19848 L
.45309 .19848 L
.45318 .19848 L
.45327 .19848 L
.45336 .25449 L
.45347 .25449 L
.45359 .25449 L
.4537 .25449 L
.45382 .25449 L
.45393 .25449 L
.45405 .25449 L
.45416 .25449 L
.45428 .25449 L
.45439 .25449 L
.45451 .34506 L
.45467 .34506 L
.45482 .34506 L
.45498 .34506 L
.45514 .34506 L
.4553 .34506 L
.45546 .34506 L
.45562 .34506 L
.45578 .34506 L
.45593 .34506 L
.45609 .34506 L
.45625 .34506 L
.45641 .34506 L
.45657 .34506 L
.45673 .34506 L
.45689 .34506 L
.45704 .34506 L
.4572 .34506 L
.45736 .34506 L
.45752 .34506 L
.45768 .34506 L
.45784 .34506 L
.458 .34506 L
.45815 .34506 L
Mistroke
.45831 .34506 L
.45847 .34506 L
.45863 .34506 L
.45879 .34506 L
.45895 .34506 L
.4591 .34506 L
.45926 .34506 L
.45942 .34506 L
.45958 .34506 L
.45974 .34506 L
.4599 .34506 L
.46006 .34506 L
.46021 .34506 L
.46037 .28893 L
.4605 .28893 L
.46064 .28893 L
.46077 .28893 L
.4609 .28893 L
.46103 .28893 L
.46116 .28893 L
.46129 .28893 L
.46143 .28893 L
.46156 .28893 L
.46169 .28893 L
.46182 .28893 L
.46195 .28893 L
.46208 .28893 L
.46221 .28893 L
.46235 .28893 L
.46248 .28893 L
.46261 .28893 L
.46274 .28893 L
.46287 .28893 L
.463 .28893 L
.46314 .28893 L
.46327 .28893 L
.4634 .28893 L
.46353 .28893 L
.46366 .28893 L
.46379 .24021 L
.4639 .24021 L
.46401 .20134 L
.4641 .16801 L
.46417 .13917 L
.46423 .01472 L
.46423 .01472 L
.46423 .01472 L
.46423 .01472 L
.46423 .01472 L
.46423 .01472 L
Mistroke
.46423 .01472 L
.46423 .01472 L
.46423 .01472 L
.46423 .01472 L
.46423 .01472 L
.46423 .01472 L
.46423 .01474 L
.46423 .01474 L
.46423 .01474 L
.46423 .01474 L
.46423 .01497 L
.46423 .01497 L
.46423 .01497 L
.46423 .01497 L
.46423 .01497 L
.46423 .01729 L
.46423 .01729 L
.46424 .01729 L
.46424 .01729 L
.46424 .01729 L
.46424 .01729 L
.46424 .04042 L
.46425 .04042 L
.46427 .04042 L
.46428 .04042 L
.46429 .04042 L
.4643 .04042 L
.46431 .04042 L
.46433 .09115 L
.46436 .07371 L
.46439 .07371 L
.46442 .07371 L
.46445 .07371 L
.46448 .07371 L
.46451 .07371 L
.46453 .07371 L
.46456 .07371 L
.46459 .11534 L
.46464 .11534 L
.46469 .11534 L
.46474 .11534 L
.46478 .11534 L
.46483 .11534 L
.46488 .11534 L
.46493 .11534 L
.46498 .11534 L
.46502 .15384 L
.46509 .15384 L
.46516 .15384 L
.46523 .15384 L
Mistroke
.46529 .15384 L
.46536 .15384 L
.46543 .15384 L
.46549 .15384 L
.46556 .15384 L
.46563 .15384 L
.46569 .19033 L
.46578 .19033 L
.46586 .19033 L
.46595 .19033 L
.46603 .19033 L
.46611 .19033 L
.4662 .19033 L
.46628 .19033 L
.46637 .19033 L
.46645 .19033 L
.46653 .19033 L
.46662 .21527 L
.46672 .21527 L
.46681 .21527 L
.46691 .21527 L
.467 .21527 L
.4671 .21527 L
.4672 .21527 L
.46729 .21527 L
.46739 .21527 L
.46749 .21527 L
.46758 .21527 L
.46768 .21527 L
.46777 .21527 L
.46787 .21527 L
.46797 .21527 L
.46806 .23646 L
.46817 .23646 L
.46828 .23646 L
.46838 .23646 L
.46849 .23646 L
.46859 .23646 L
.4687 .23646 L
.46881 .23646 L
.46891 .23646 L
.46902 .23646 L
.46913 .23646 L
.46923 .23646 L
.46934 .23646 L
.46945 .23646 L
.46955 .23646 L
.46966 .23646 L
.46977 .23646 L
.46987 .23646 L
Mistroke
.46998 .23646 L
.47008 .24179 L
.47019 .24179 L
.4703 .24179 L
.47041 .24179 L
.47052 .24179 L
.47063 .24179 L
.47074 .24179 L
.47085 .24179 L
.47096 .24179 L
.47106 .24179 L
.47117 .24179 L
.47128 .24179 L
.47139 .24179 L
.4715 .20844 L
.47159 .20844 L
.47169 .20844 L
.47178 .20844 L
.47187 .20844 L
.47197 .20844 L
.47206 .20844 L
.47215 .20844 L
.47224 .20844 L
.47234 .20844 L
.47243 .20844 L
.47252 .20844 L
.47262 .20844 L
.47271 .20844 L
.4728 .20844 L
.47289 .20844 L
.47299 .20844 L
.47308 .20844 L
.47317 .20844 L
.47327 .20844 L
.47336 .20844 L
.47345 .20844 L
.47355 .20844 L
.47364 .20844 L
.47373 .20844 L
.47382 .14661 L
.47389 .14661 L
.47395 .14661 L
.47401 .14661 L
.47408 .14661 L
.47414 .14661 L
.4742 .14661 L
.47427 .14661 L
.47433 .14661 L
.47439 .14661 L
.47446 .14661 L
Mistroke
.47452 .14661 L
.47458 .14661 L
.47465 .14661 L
.47471 .14661 L
.47477 .14661 L
.47484 .14661 L
.4749 .14661 L
.47496 .14661 L
.47503 .14661 L
.47509 .14661 L
.47515 .17909 L
.47523 .17909 L
.47531 .17909 L
.47539 .17909 L
.47547 .17909 L
.47555 .17909 L
.47563 .17909 L
.47571 .17909 L
.47578 .17909 L
.47586 .17909 L
.47594 .17909 L
.47602 .17909 L
.4761 .17909 L
.47618 .17909 L
.47626 .17909 L
.47634 .17909 L
.47642 .17909 L
.47649 .17909 L
.47657 .17909 L
.47665 .17909 L
.47673 .17909 L
.47681 .07203 L
.47684 .07203 L
.47686 .07203 L
.47689 .07203 L
.47692 .07203 L
.47695 .07203 L
.47697 .07203 L
.477 .07203 L
.47703 .07203 L
.47706 .07203 L
.47708 .07203 L
.47711 .08365 L
.47715 .08365 L
.47718 .08365 L
.47721 .08365 L
.47724 .08365 L
.47728 .08365 L
.47731 .08365 L
.47734 .08365 L
Mistroke
.47738 .08365 L
.47741 .08365 L
.47744 .12503 L
.4775 .12503 L
.47755 .12503 L
.4776 .12503 L
.47765 .12503 L
.47771 .12503 L
.47776 .12503 L
.47781 .12503 L
.47787 .12503 L
.47792 .12503 L
.47797 .12503 L
.47803 .04371 L
.47804 .04371 L
.47805 .04371 L
.47807 .04371 L
.47808 .04371 L
.47809 .04371 L
.47811 .04371 L
.47812 .04371 L
.47814 .04371 L
.47815 .04371 L
.47816 .08683 L
.4782 .08683 L
.47823 .08683 L
.47827 .08683 L
.4783 .08683 L
.47834 .08683 L
.47837 .08683 L
.47841 .08683 L
.47844 .08683 L
.47848 .10579 L
.47852 .10579 L
.47856 .10579 L
.47861 .10579 L
.47865 .10579 L
.47869 .10579 L
.47874 .10579 L
.47878 .10579 L
.47883 .10579 L
.47887 .10579 L
.47891 .10579 L
.47896 .10579 L
.479 .10579 L
.47904 .10579 L
.47909 .10579 L
.47913 .10579 L
.47917 .10579 L
.47922 .10579 L
Mistroke
.47926 .11906 L
.47931 .11906 L
.47936 .11906 L
.47941 .11906 L
.47946 .11906 L
.47951 .11906 L
.47956 .11906 L
.47961 .11906 L
.47966 .11906 L
.47971 .11906 L
.47976 .15534 L
.47983 .15534 L
.4799 .15534 L
.47997 .15534 L
.48003 .15534 L
.4801 .15534 L
.48017 .15534 L
.48024 .15534 L
.4803 .15534 L
.48037 .15534 L
.48044 .15534 L
.48051 .15534 L
.48057 .15534 L
.48064 .17254 L
.48072 .17254 L
.48079 .17254 L
.48087 .17254 L
.48094 .17254 L
.48102 .17254 L
.48109 .17254 L
.48117 .17254 L
.48125 .17254 L
.48132 .17254 L
.4814 .17254 L
.48147 .18851 L
.48156 .18851 L
.48164 .18851 L
.48172 .18851 L
.48181 .18851 L
.48189 .18851 L
.48197 .18851 L
.48206 .18851 L
.48214 .18851 L
.48222 .18851 L
.48231 .18851 L
.48239 .20863 L
.48248 .20863 L
.48258 .20863 L
.48267 .20863 L
.48276 .20863 L
Mistroke
.48286 .20863 L
.48295 .20863 L
.48304 .20863 L
.48313 .20863 L
.48323 .20863 L
.48332 .20863 L
.48341 .20863 L
.48351 .21317 L
.4836 .21317 L
.4837 .21317 L
.48379 .21317 L
.48389 .21317 L
.48398 .21317 L
.48408 .21317 L
.48417 .21317 L
.48427 .21317 L
.48436 .21317 L
.48446 .21317 L
.48455 .21317 L
.48465 .20249 L
.48474 .20249 L
.48483 .20249 L
.48492 .20249 L
.48501 .20249 L
.4851 .20249 L
.48519 .20249 L
.48528 .20249 L
.48537 .20249 L
.48546 .20249 L
.48555 .20249 L
.48564 .20249 L
.48573 .20249 L
.48582 .20249 L
.48591 .24127 L
.48602 .24127 L
.48613 .24127 L
.48624 .24127 L
.48635 .24127 L
.48645 .24127 L
.48656 .24127 L
.48667 .24127 L
.48678 .24127 L
.48689 .24127 L
.487 .24127 L
.48711 .24672 L
.48722 .24672 L
.48733 .24672 L
.48744 .24672 L
.48755 .24672 L
.48766 .24672 L
Mistroke
.48777 .24672 L
.48789 .24672 L
.488 .24672 L
.48811 .24672 L
.48822 .24672 L
.48833 .27608 L
.48846 .27608 L
.48858 .27608 L
.48871 .27608 L
.48883 .27608 L
.48896 .27608 L
.48908 .27608 L
.48921 .27608 L
.48933 .27608 L
.48946 .27608 L
.48959 .27608 L
.48971 .30754 L
.48985 .30754 L
.48999 .30754 L
.49013 .30754 L
.49027 .30754 L
.49041 .30754 L
.49055 .30754 L
.49069 .30754 L
.49083 .30754 L
.49098 .30754 L
.49112 .30754 L
.49126 .36027 L
.49142 .36027 L
.49159 .36027 L
.49175 .36027 L
.49192 .36027 L
.49209 .36027 L
.49225 .36027 L
.49242 .36027 L
.49258 .36027 L
.49275 .36027 L
.49291 .36027 L
.49308 .36027 L
.49325 .36027 L
.49341 .36027 L
.49358 .36027 L
.49374 .36027 L
.49391 .36027 L
.49407 .36027 L
.49424 .36027 L
.49441 .36027 L
.49457 .40547 L
.49476 .40547 L
.49495 .40547 L
Mistroke
.49513 .40547 L
.49532 .40547 L
.49551 .40547 L
.4957 .40547 L
.49588 .40547 L
.49607 .40547 L
.49626 .40547 L
.49645 .40547 L
.49663 .40547 L
.49682 .36867 L
.49699 .36867 L
.49716 .36867 L
.49733 .36867 L
.4975 .36867 L
.49767 .36867 L
.49784 .36867 L
.49801 .36867 L
.49818 .36867 L
.49835 .36867 L
.49852 .36867 L
.49869 .36867 L
.49886 .40947 L
.49905 .40947 L
.49924 .40947 L
.49943 .40947 L
.49962 .40947 L
.49981 .40947 L
.5 .40947 L
.50019 .40947 L
.50038 .40947 L
.50057 .40947 L
.50075 .40947 L
.50094 .40947 L
.50113 .40947 L
.50132 .40947 L
.50151 .40947 L
.5017 .40947 L
.50189 .40947 L
.50208 .40947 L
.50227 .40947 L
.50246 .40947 L
.50265 .40947 L
.50284 .40947 L
.50303 .40947 L
.50322 .40947 L
.50341 .40947 L
.5036 .40947 L
.50378 .40947 L
.50397 .40947 L
.50416 .40947 L
Mistroke
.50435 .40947 L
.50454 .40947 L
.50473 .40947 L
.50492 .40947 L
.50511 .34977 L
.50527 .34977 L
.50543 .34977 L
.50559 .34977 L
.50575 .34977 L
.50591 .34977 L
.50608 .34977 L
.50624 .34977 L
.5064 .34977 L
.50656 .34977 L
.50672 .34977 L
.50688 .34977 L
.50704 .34977 L
.5072 .34977 L
.50736 .34977 L
.50752 .34977 L
.50768 .34977 L
.50784 .34977 L
.508 .34977 L
.50817 .34977 L
.50833 .34977 L
.50849 .24809 L
.5086 .24809 L
.50871 .24809 L
.50882 .24809 L
.50893 .24809 L
.50905 .24809 L
.50916 .24809 L
.50927 .24809 L
.50938 .24809 L
.50949 .24809 L
.50961 .24809 L
.50972 .24809 L
.50983 .24809 L
.50994 .24809 L
.51005 .24809 L
.51017 .24809 L
.51028 .24809 L
.51039 .24809 L
.5105 .24809 L
.51061 .24809 L
.51073 .24809 L
.51084 .29852 L
.51097 .29852 L
.51111 .29852 L
.51125 .29852 L
Mistroke
.51138 .29852 L
.51152 .29852 L
.51166 .29852 L
.51179 .29852 L
.51193 .29852 L
.51206 .29852 L
.5122 .29852 L
.51234 .29852 L
.51247 .29852 L
.51261 .29852 L
.51274 .29852 L
.51288 .29852 L
.51302 .29852 L
.51315 .29852 L
.51329 .29852 L
.51343 .29852 L
.51356 .29852 L
.5137 .29852 L
.51383 .29852 L
.51397 .29852 L
.51411 .29852 L
.51424 .29852 L
.51438 .29852 L
.51452 .29852 L
.51465 .29852 L
.51479 .29852 L
.51492 .24553 L
.51503 .24553 L
.51515 .24553 L
.51526 .24553 L
.51537 .24553 L
.51548 .24553 L
.51559 .24553 L
.5157 .24553 L
.51581 .24553 L
.51592 .24553 L
.51603 .24553 L
.51614 .24553 L
.51625 .24553 L
.51636 .24553 L
.51647 .24553 L
.51658 .31113 L
.51673 .31113 L
.51687 .31113 L
.51701 .31113 L
.51715 .31113 L
.5173 .31113 L
.51744 .31113 L
.51758 .31113 L
.51772 .31113 L
Mistroke
.51786 .31113 L
.51801 .31113 L
.51815 .31113 L
.51829 .31113 L
.51843 .31113 L
.51858 .31113 L
.51872 .31113 L
.51886 .31113 L
.519 .31113 L
.51914 .19911 L
.51923 .19911 L
.51932 .19911 L
.51941 .19911 L
.5195 .19911 L
.51959 .19911 L
.51968 .19911 L
.51976 .19911 L
.51985 .19911 L
.51994 .19911 L
.52003 .19911 L
.52012 .24135 L
.52023 .24135 L
.52034 .24135 L
.52044 .24135 L
.52055 .24135 L
.52066 .24135 L
.52077 .24135 L
.52088 .24135 L
.52099 .24135 L
.5211 .24135 L
.52121 .24135 L
.52131 .24135 L
.52142 .24135 L
.52153 .27947 L
.52166 .27947 L
.52179 .27947 L
.52191 .27947 L
.52204 .27947 L
.52217 .27947 L
.52229 .27947 L
.52242 .27947 L
.52255 .27947 L
.52268 .27947 L
.5228 .27947 L
.52293 .33172 L
.52308 .33172 L
.52323 .33172 L
.52339 .33172 L
.52354 .33172 L
.52369 .33172 L
Mistroke
.52384 .33172 L
.52399 .33172 L
.52415 .33172 L
.5243 .33172 L
.52445 .33172 L
.5246 .33172 L
.52475 .33172 L
.52491 .33172 L
.52506 .33172 L
.52521 .40635 L
.5254 .40635 L
.52559 .40635 L
.52577 .40635 L
.52596 .40635 L
.52615 .40635 L
.52634 .40635 L
.52653 .40635 L
.52671 .40635 L
.5269 .40635 L
.52709 .40635 L
.52728 .40635 L
.52747 .40635 L
.52765 .40635 L
.52784 .40635 L
.52803 .40635 L
.52822 .40635 L
.52841 .40635 L
.52859 .45911 L
.52881 .45911 L
.52902 .45911 L
.52923 .45911 L
.52945 .45911 L
.52966 .45911 L
.52987 .45911 L
.53009 .45911 L
.5303 .45911 L
.53051 .45911 L
.53073 .45911 L
.53094 .45911 L
.53115 .50444 L
.53139 .50444 L
.53162 .50444 L
.53186 .50444 L
.53209 .50444 L
.53233 .50444 L
.53256 .50444 L
.5328 .50444 L
.53303 .50444 L
.53327 .50444 L
.5335 .50444 L
Mistroke
.53374 .50444 L
.53397 .50444 L
.53421 .50444 L
.53444 .50444 L
.53468 .50444 L
.53491 .50444 L
.53515 .50444 L
.53538 .44214 L
.53559 .44214 L
.53579 .44214 L
.536 .44214 L
.5362 .44214 L
.53641 .44214 L
.53661 .44214 L
.53682 .44214 L
.53702 .44214 L
.53723 .44214 L
.53743 .44214 L
.53764 .44214 L
.53784 .44214 L
.53805 .44214 L
.53825 .44214 L
.53846 .44214 L
.53866 .44214 L
.53887 .44214 L
.53907 .44214 L
.53928 .44214 L
.53948 .44214 L
.53969 .44214 L
.53989 .44214 L
.5401 .44214 L
.5403 .44214 L
.54051 .44214 L
.54071 .44214 L
.54092 .44214 L
.54112 .36507 L
.54129 .36507 L
.54146 .29818 L
.5416 .24396 L
.54171 .19403 L
.54179 .01472 L
.54179 .01472 L
.54179 .01472 L
.54179 .01472 L
.54179 .01472 L
.54179 .01472 L
.54179 .01472 L
.54179 .01472 L
.54179 .01472 L
.54179 .01472 L
Mistroke
.54179 .01472 L
.54179 .01472 L
.54179 .01475 L
.54179 .01475 L
.54179 .01475 L
.54179 .01475 L
.54179 .01506 L
.54179 .01506 L
.54179 .01506 L
.54179 .01506 L
.54179 .01506 L
.54179 .0182 L
.54179 .0182 L
.5418 .0182 L
.5418 .0182 L
.5418 .0182 L
.5418 .0182 L
.5418 .04953 L
.54182 .04953 L
.54184 .04953 L
.54185 .04953 L
.54187 .04953 L
.54189 .04953 L
.5419 .04953 L
.54192 .1115 L
.54197 .1115 L
.54201 .1115 L
.54206 .1115 L
.54211 .1115 L
.54215 .1115 L
.5422 .1115 L
.54225 .1115 L
.54229 .14315 L
.54235 .14315 L
.54241 .14315 L
.54248 .14315 L
.54254 .14315 L
.5426 .14315 L
.54266 .14315 L
.54272 .14315 L
.54278 .14315 L
.54285 .19658 L
.54293 .19658 L
.54302 .19658 L
.54311 .19658 L
.5432 .19658 L
.54328 .19658 L
.54337 .19658 L
.54346 .19658 L
.54354 .19658 L
Mistroke
.54363 .19658 L
.54372 .23959 L
.54383 .23959 L
.54393 .23959 L
.54404 .23959 L
.54415 .23959 L
.54426 .23959 L
.54437 .23959 L
.54447 .23959 L
.54458 .23959 L
.54469 .23959 L
.5448 .23959 L
.54491 .27602 L
.54503 .27602 L
.54516 .27602 L
.54528 .27602 L
.54541 .27602 L
.54553 .27602 L
.54566 .27602 L
.54578 .27602 L
.54591 .27602 L
.54603 .27602 L
.54616 .27602 L
.54628 .27602 L
.54641 .27602 L
.54654 .27602 L
.54666 .27602 L
.54679 .27602 L
.54691 .27602 L
.54704 .27602 L
.54716 .27602 L
.54729 .27602 L
.54741 .27602 L
.54754 .27602 L
.54766 .27602 L
.54779 .27602 L
.54791 .27602 L
.54804 .27602 L
.54817 .27602 L
.54829 .27602 L
.54842 .27602 L
.54854 .27602 L
.54867 .27602 L
.54879 .27602 L
.54892 .27602 L
.54904 .27602 L
.54917 .27602 L
.54929 .27602 L
.54942 .27602 L
.54954 .27602 L
Mistroke
.54967 .27602 L
.5498 .27602 L
.54992 .27602 L
.55005 .27602 L
.55017 .27602 L
.5503 .27602 L
.55042 .27602 L
.55055 .27602 L
.55067 .27602 L
.5508 .27602 L
.55092 .27602 L
.55105 .27602 L
.55117 .27602 L
.5513 .27602 L
.55143 .27602 L
.55155 .27602 L
.55168 .27602 L
.5518 .27602 L
.55193 .27602 L
.55205 .27602 L
.55218 .27602 L
.5523 .22 L
.5524 .22 L
.5525 .22 L
.5526 .22 L
.5527 .22 L
.5528 .22 L
.55289 .22 L
.55299 .22 L
.55309 .22 L
.55319 .22 L
.55329 .22 L
.55339 .19814 L
.55347 .19814 L
.55356 .19814 L
.55365 .19814 L
.55374 .19814 L
.55383 .19814 L
.55391 .19814 L
.554 .19814 L
.55409 .19814 L
.55418 .19814 L
.55427 .19814 L
.55435 .24076 L
.55446 .24076 L
.55457 .24076 L
.55468 .24076 L
.55479 .24076 L
.5549 .24076 L
.55501 .24076 L
Mistroke
.55511 .24076 L
.55522 .24076 L
.55533 .24076 L
.55544 .24076 L
.55555 .21844 L
.55565 .21844 L
.55574 .21844 L
.55584 .21844 L
.55594 .21844 L
.55604 .21844 L
.55613 .21844 L
.55623 .21844 L
.55633 .21844 L
.55643 .21844 L
.55653 .21844 L
.55662 .21844 L
.55672 .21844 L
.55682 .21844 L
.55692 .27855 L
.55704 .27855 L
.55717 .27855 L
.5573 .27855 L
.55742 .27855 L
.55755 .27855 L
.55768 .27855 L
.5578 .27855 L
.55793 .27855 L
.55806 .27855 L
.55818 .27855 L
.55831 .27855 L
.55844 .30708 L
.55858 .30708 L
.55872 .30708 L
.55886 .30708 L
.559 .30708 L
.55914 .30708 L
.55928 .30708 L
.55942 .30708 L
.55956 .30708 L
.5597 .30708 L
.55984 .30708 L
.55998 .30708 L
.56012 .30708 L
.56026 .30708 L
.5604 .30708 L
.56054 .34038 L
.5607 .34038 L
.56085 .34038 L
.56101 .34038 L
.56116 .34038 L
Mistroke
.56132 .34038 L
.56148 .34038 L
.56163 .34038 L
.56179 .34038 L
.56195 .34038 L
.5621 .34038 L
.56226 .34038 L
.56241 .26776 L
.56254 .26776 L
.56266 .26776 L
.56278 .26776 L
.5629 .26776 L
.56302 .26776 L
.56314 .26776 L
.56326 .26776 L
.56339 .26776 L
.56351 .26776 L
.56363 .26776 L
.56375 .32221 L
.5639 .32221 L
.56405 .32221 L
.56419 .32221 L
.56434 .32221 L
.56449 .32221 L
.56464 .32221 L
.56478 .32221 L
.56493 .32221 L
.56508 .32221 L
.56523 .32221 L
.56537 .36166 L
.56554 .36166 L
.56571 .36166 L
.56587 .36166 L
.56604 .36166 L
.56621 .36166 L
.56637 .36166 L
.56654 .36166 L
.5667 .36166 L
.56687 .36166 L
.56704 .36166 L
.5672 .41448 L
.5674 .41448 L
.56759 .41448 L
.56778 .41448 L
.56797 .41448 L
.56816 .41448 L
.56836 .41448 L
.56855 .41448 L
.56874 .41448 L
.56893 .41448 L
Mistroke
.56912 .41448 L
.56931 .41448 L
.56951 .41448 L
.5697 .41448 L
.56989 .41448 L
.57008 .41448 L
.57027 .41448 L
.57047 .41448 L
.57066 .41448 L
.57085 .41448 L
.57104 .41448 L
.57123 .41448 L
.57142 .41448 L
.57162 .41448 L
.57181 .41448 L
.572 .41448 L
.57219 .41448 L
.57238 .41448 L
.57258 .41448 L
.57277 .41448 L
.57296 .41448 L
.57315 .41448 L
.57334 .41448 L
.57353 .41448 L
.57373 .41448 L
.57392 .41448 L
.57411 .41448 L
.5743 .41448 L
.57449 .41448 L
.57469 .41448 L
.57488 .41448 L
.57507 .41448 L
.57526 .41448 L
.57545 .41448 L
.57564 .41448 L
.57584 .41448 L
.57603 .41448 L
.57622 .41448 L
.57641 .34446 L
.57657 .34446 L
.57673 .28848 L
.57686 .24079 L
.57697 .19872 L
.57706 .01472 L
.57706 .01472 L
.57706 .01472 L
.57706 .01472 L
.57706 .01472 L
.57706 .01472 L
.57706 .01472 L
Mistroke
.57706 .01472 L
.57706 .01472 L
.57706 .01472 L
.57706 .01472 L
.57706 .01472 L
.57706 .01475 L
.57706 .01475 L
.57706 .01475 L
.57706 .01475 L
.57706 .01509 L
.57706 .01509 L
.57706 .01509 L
.57706 .01509 L
.57706 .01509 L
.57706 .0185 L
.57706 .0185 L
.57706 .0185 L
.57706 .0185 L
.57706 .0185 L
.57707 .0185 L
.57707 .05254 L
.57709 .05254 L
.5771 .05254 L
.57712 .05254 L
.57714 .05254 L
.57716 .05254 L
.57718 .05254 L
.57719 .12564 L
.57725 .10349 L
.57729 .10349 L
.57733 .10349 L
.57738 .10349 L
.57742 .10349 L
.57746 .10349 L
.5775 .10349 L
.57755 .10349 L
.57759 .15766 L
.57766 .15766 L
.57773 .15766 L
.57779 .15766 L
.57786 .15766 L
.57793 .15766 L
.578 .15766 L
.57807 .15766 L
.57814 .15766 L
.57821 .21503 L
.5783 .21503 L
.5784 .21503 L
.57849 .21503 L
.57859 .21503 L
Mistroke
.57869 .21503 L
.57878 .21503 L
.57888 .21503 L
.57898 .21503 L
.57907 .21503 L
.57917 .26755 L
.57929 .26755 L
.57941 .26755 L
.57953 .26755 L
.57965 .26755 L
.57977 .26755 L
.5799 .26755 L
.58002 .26755 L
.58014 .26755 L
.58026 .26755 L
.58038 .26755 L
.5805 .29771 L
.58064 .29771 L
.58077 .29771 L
.58091 .29771 L
.58104 .29771 L
.58118 .29771 L
.58132 .29771 L
.58145 .29771 L
.58159 .29771 L
.58172 .29771 L
.58186 .29771 L
.582 .29771 L
.58213 .29771 L
.58227 .29771 L
.5824 .29771 L
.58254 .29771 L
.58267 .29771 L
.58281 .29771 L
.58295 .32856 L
.5831 .32856 L
.58325 .32856 L
.5834 .32856 L
.58355 .32856 L
.5837 .32856 L
.58385 .32856 L
.584 .32856 L
.58415 .32856 L
.5843 .32856 L
.58445 .32856 L
.5846 .32856 L
.58475 .32856 L
.5849 .32856 L
.58505 .32856 L
.5852 .32856 L
Mistroke
.58536 .32856 L
.58551 .32856 L
.58566 .32856 L
.58581 .32856 L
.58596 .32856 L
.58611 .32856 L
.58626 .32856 L
.58641 .32856 L
.58656 .24268 L
.58667 .24268 L
.58678 .24268 L
.58689 .24268 L
.587 .24268 L
.58711 .24268 L
.58722 .24268 L
.58733 .24268 L
.58744 .24268 L
.58754 .24268 L
.58765 .24268 L
.58776 .24268 L
.58787 .24268 L
.58798 .24268 L
.58809 .24268 L
.5882 .24268 L
.58831 .24268 L
.58842 .24268 L
.58853 .24268 L
.58864 .24268 L
.58875 .24268 L
.58886 .27984 L
.58898 .27984 L
.58911 .27984 L
.58924 .27984 L
.58937 .27984 L
.58949 .27984 L
.58962 .27984 L
.58975 .27984 L
.58987 .27984 L
.59 .27984 L
.59013 .27984 L
.59026 .27984 L
.59038 .27984 L
.59051 .27984 L
.59064 .27984 L
.59077 .27984 L
.59089 .27984 L
.59102 .27984 L
.59115 .27984 L
.59127 .27984 L
.5914 .27984 L
Mistroke
.59153 .27984 L
.59166 .27984 L
.59178 .27984 L
.59191 .27984 L
.59204 .27984 L
.59216 .27984 L
.59229 .27984 L
.59242 .27984 L
.59255 .27984 L
.59267 .18645 L
.59276 .18645 L
.59284 .18645 L
.59292 .18645 L
.593 .18645 L
.59309 .18645 L
.59317 .18645 L
.59325 .18645 L
.59333 .18645 L
.59342 .18645 L
.5935 .18645 L
.59358 .18645 L
.59366 .18645 L
.59374 .18645 L
.59383 .24163 L
.59394 .24163 L
.59404 .24163 L
.59415 .24163 L
.59426 .24163 L
.59437 .24163 L
.59448 .24163 L
.59459 .24163 L
.5947 .24163 L
.59481 .24163 L
.59492 .24163 L
.59502 .24163 L
.59513 .24163 L
.59524 .24163 L
.59535 .24163 L
.59546 .24163 L
.59557 .24163 L
.59568 .26526 L
.5958 .26526 L
.59592 .26526 L
.59604 .26526 L
.59616 .26526 L
.59628 .26526 L
.5964 .26526 L
.59652 .26526 L
.59664 .26526 L
.59676 .26526 L
Mistroke
.59688 .26526 L
.597 .26526 L
.59712 .26526 L
.59724 .26526 L
.59736 .26526 L
.59748 .30229 L
.59762 .30229 L
.59776 .30229 L
.5979 .30229 L
.59803 .30229 L
.59817 .30229 L
.59831 .30229 L
.59845 .30229 L
.59859 .30229 L
.59872 .30229 L
.59886 .30229 L
.599 .30229 L
.59914 .30229 L
.59928 .31697 L
.59942 .31697 L
.59957 .31697 L
.59971 .31697 L
.59986 .31697 L
.6 .31697 L
.60015 .31697 L
.60029 .31697 L
.60044 .31697 L
.60058 .31697 L
.60073 .31697 L
.60087 .31697 L
.60102 .31697 L
.60116 .31697 L
.60131 .31697 L
.60145 .31697 L
.6016 .31697 L
.60174 .31697 L
.60189 .31697 L
.60203 .20885 L
.60212 .20885 L
.60222 .20885 L
.60231 .20885 L
.6024 .20885 L
.6025 .20885 L
.60259 .20885 L
.60268 .20885 L
.60278 .20885 L
.60287 .20885 L
.60296 .20885 L
.60306 .20885 L
.60315 .30173 L
Mistroke
.60329 .30173 L
.60342 .30173 L
.60356 .30173 L
.6037 .30173 L
.60384 .30173 L
.60397 .30173 L
.60411 .30173 L
.60425 .30173 L
.60439 .30173 L
.60453 .30173 L
.60466 .37922 L
.60484 .37922 L
.60501 .37922 L
.60519 .37922 L
.60536 .37922 L
.60554 .37922 L
.60571 .37922 L
.60589 .37922 L
.60606 .37922 L
.60624 .37922 L
.60641 .37922 L
.60659 .37922 L
.60676 .37922 L
.60694 .37922 L
.60711 .37922 L
.60729 .37922 L
.60746 .37922 L
.60764 .37922 L
.60781 .37922 L
.60799 .37922 L
.60816 .37922 L
.60834 .37922 L
.60851 .37922 L
.60869 .37922 L
.60886 .37922 L
.60904 .37922 L
.60921 .4411 L
.60942 .4411 L
.60962 .4411 L
.60982 .4411 L
.61003 .4411 L
.61023 .4411 L
.61044 .4411 L
.61064 .4411 L
.61085 .4411 L
.61105 .4411 L
.61126 .4411 L
.61146 .4411 L
.61167 .4411 L
.61187 .4411 L
Mistroke
.61207 .4411 L
.61228 .4411 L
.61248 .4411 L
.61269 .4411 L
.61289 .4411 L
.6131 .4411 L
.6133 .4411 L
.61351 .4411 L
.61371 .4411 L
.61392 .4411 L
.61412 .4411 L
.61433 .4411 L
.61453 .4411 L
.61473 .4411 L
.61494 .4411 L
.61514 .4411 L
.61535 .4411 L
.61555 .4411 L
.61576 .4411 L
.61596 .4411 L
.61617 .4411 L
.61637 .4411 L
.61658 .4411 L
.61678 .4411 L
.61698 .4411 L
.61719 .4411 L
.61739 .36925 L
.61756 .36925 L
.61773 .30581 L
.61787 .24836 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01472 L
.61799 .01476 L
.61799 .01476 L
.61799 .01476 L
.61799 .01476 L
.61799 .01518 L
.61799 .01518 L
.61799 .01518 L
.61799 .01518 L
Mistroke
.61799 .01518 L
.61799 .01933 L
.61799 .01933 L
.61799 .01933 L
.61799 .01933 L
.618 .01933 L
.618 .01933 L
.618 .06087 L
.61802 .06087 L
.61804 .06087 L
.61807 .06087 L
.61809 .06087 L
.61811 .06087 L
.61813 .06087 L
.61816 .11879 L
.61821 .09306 L
.61824 .07968 L
.61827 .07968 L
.61831 .07968 L
.61834 .07968 L
.61837 .07968 L
.6184 .07968 L
.61843 .07968 L
.61846 .07968 L
.61849 .12945 L
.61855 .12945 L
.6186 .12945 L
.61866 .12945 L
.61871 .12945 L
.61877 .12945 L
.61882 .12945 L
.61888 .12945 L
.61893 .15878 L
.619 .15878 L
.61907 .15878 L
.61914 .15878 L
.61921 .15878 L
.61928 .15878 L
.61935 .15878 L
.61942 .15878 L
.61949 .15878 L
.61955 .1905 L
.61964 .1905 L
.61972 .1905 L
.61981 .1905 L
.61989 .1905 L
.61998 .1905 L
.62006 .1905 L
.62015 .1905 L
.62023 .1905 L
Mistroke
.62031 .1905 L
.6204 .2592 L
.62052 .2592 L
.62063 .2592 L
.62075 .2592 L
.62087 .2592 L
.62099 .2592 L
.6211 .2592 L
.62122 .2592 L
.62134 .2592 L
.62145 .2592 L
.62157 .2592 L
.62169 .2592 L
.62181 .2592 L
.62192 .2592 L
.62204 .2592 L
.62216 .2592 L
.62228 .2592 L
.62239 .2592 L
.62251 .2592 L
.62263 .2592 L
.62274 .2592 L
.62286 .2592 L
.62298 .2592 L
.6231 .2592 L
.62321 .2592 L
.62333 .2592 L
.62345 .2592 L
.62357 .2592 L
.62368 .2592 L
.6238 .2592 L
.62392 .2592 L
.62404 .2592 L
.62415 .2592 L
.62427 .2592 L
.62439 .2592 L
.6245 .2592 L
.62462 .2592 L
.62474 .2592 L
.62486 .2592 L
.62497 .2592 L
.62509 .2592 L
.62521 .2592 L
.62533 .2592 L
.62544 .2592 L
.62556 .2592 L
.62568 .2592 L
.62579 .2592 L
.62591 .2592 L
.62603 .2592 L
Mistroke
.62615 .2592 L
.62626 .2592 L
.62638 .2592 L
.6265 .2592 L
.62662 .2592 L
.62673 .2592 L
.62685 .2592 L
.62697 .2592 L
.62709 .2592 L
.6272 .2592 L
.62732 .2592 L
.62744 .2592 L
.62755 .2592 L
.62767 .2592 L
.62779 .2592 L
.62791 .2592 L
.62802 .2592 L
.62814 .2592 L
.62826 .2592 L
.62838 .2592 L
.62849 .2592 L
.62861 .2592 L
.62873 .2592 L
.62884 .2592 L
.62896 .2592 L
.62908 .21776 L
.62918 .21776 L
.62927 .21776 L
.62937 .21776 L
.62947 .21776 L
.62957 .21776 L
.62966 .21776 L
.62976 .21776 L
.62986 .21776 L
.62996 .21776 L
.63005 .21776 L
.63015 .21776 L
.63025 .21776 L
.63035 .21776 L
.63044 .21776 L
.63054 .21776 L
.63064 .21776 L
.63074 .20258 L
.63083 .20258 L
.63092 .20258 L
.63101 .20258 L
.6311 .20258 L
.63119 .20258 L
.63128 .20258 L
.63137 .20258 L
Mistroke
.63146 .20258 L
.63155 .20258 L
.63164 .20258 L
.63173 .19538 L
.63181 .19538 L
.6319 .19538 L
.63199 .19538 L
.63207 .19538 L
.63216 .19538 L
.63225 .19538 L
.63233 .19538 L
.63242 .19538 L
.63251 .19538 L
.63259 .19538 L
.63268 .23841 L
.63279 .23841 L
.6329 .23841 L
.633 .23841 L
.63311 .23841 L
.63322 .23841 L
.63332 .23841 L
.63343 .23841 L
.63354 .23841 L
.63365 .23841 L
.63375 .23841 L
.63386 .23841 L
.63397 .26302 L
.63409 .26302 L
.63421 .26302 L
.63433 .26302 L
.63445 .26302 L
.63456 .26302 L
.63468 .26302 L
.6348 .26302 L
.63492 .26302 L
.63504 .26302 L
.63516 .26302 L
.63528 .26302 L
.6354 .26302 L
.63552 .26302 L
.63564 .26302 L
.63576 .14403 L
.63582 .14403 L
.63588 .14403 L
.63594 .14403 L
.636 .14403 L
.63607 .14403 L
.63613 .14403 L
.63619 .14403 L
.63625 .14403 L
Mistroke
.63631 .14403 L
.63638 .14403 L
.63644 .1819 L
.63652 .1819 L
.6366 .1819 L
.63668 .1819 L
.63676 .1819 L
.63684 .1819 L
.63692 .1819 L
.637 .1819 L
.63708 .1819 L
.63716 .1819 L
.63724 .20894 L
.63733 .20894 L
.63743 .20894 L
.63752 .20894 L
.63761 .20894 L
.63771 .20894 L
.6378 .20894 L
.63789 .20894 L
.63799 .20894 L
.63808 .20894 L
.63817 .25739 L
.63829 .20998 L
.63838 .17335 L
.63846 .14318 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01472 L
.63852 .01474 L
.63852 .01474 L
.63852 .01474 L
.63852 .01474 L
.63852 .01498 L
.63852 .01498 L
.63852 .01498 L
.63852 .01498 L
.63852 .01498 L
.63852 .01736 L
.63852 .01736 L
.63852 .01736 L
Mistroke
.63852 .01736 L
.63853 .01736 L
.63853 .01736 L
.63853 .04115 L
.63854 .04115 L
.63855 .04115 L
.63857 .04115 L
.63858 .04115 L
.63859 .04115 L
.6386 .04115 L
.63862 .09946 L
.63866 .08467 L
.63869 .08467 L
.63873 .08467 L
.63876 .08467 L
.63879 .08467 L
.63883 .08467 L
.63886 .08467 L
.63889 .08467 L
.63893 .14268 L
.63899 .14268 L
.63905 .14268 L
.63911 .14268 L
.63917 .14268 L
.63923 .14268 L
.63929 .14268 L
.63936 .14268 L
.63942 .14268 L
.63948 .18001 L
.63956 .18001 L
.63964 .18001 L
.63972 .18001 L
.6398 .18001 L
.63988 .18001 L
.63995 .18001 L
.64003 .18001 L
.64011 .18001 L
.64019 .18001 L
.64027 .22482 L
.64037 .22482 L
.64047 .22482 L
.64057 .22482 L
.64068 .22482 L
.64078 .22482 L
.64088 .22482 L
.64098 .22482 L
.64108 .22482 L
.64118 .22482 L
.64128 .22482 L
.64138 .30557 L
Mistroke
.64152 .30557 L
.64166 .30557 L
.6418 .30557 L
.64194 .30557 L
.64208 .30557 L
.64222 .30557 L
.64236 .30557 L
.6425 .30557 L
.64264 .30557 L
.64278 .30557 L
.64292 .30557 L
.64306 .36672 L
.64322 .36672 L
.64339 .36672 L
.64356 .36672 L
.64373 .36672 L
.6439 .36672 L
.64407 .36672 L
.64424 .36672 L
.64441 .36672 L
.64458 .36672 L
.64474 .36672 L
.64491 .36672 L
.64508 .36672 L
.64525 .22923 L
.64535 .22923 L
.64546 .22923 L
.64556 .22923 L
.64566 .22923 L
.64577 .22923 L
.64587 .22923 L
.64597 .22923 L
.64607 .22923 L
.64618 .22923 L
.64628 .22923 L
.64638 .22923 L
.64649 .35226 L
.64665 .35226 L
.64681 .35226 L
.64697 .35226 L
.64713 .35226 L
.6473 .35226 L
.64746 .35226 L
.64762 .35226 L
.64778 .35226 L
.64794 .35226 L
.64811 .35226 L
.64827 .39752 L
.64845 .39752 L
.64864 .39752 L
Mistroke
.64882 .39752 L
.649 .39752 L
.64919 .39752 L
.64937 .39752 L
.64955 .39752 L
.64974 .39752 L
.64992 .39752 L
.6501 .39752 L
.65029 .39752 L
.65047 .39752 L
.65066 .39752 L
.65084 .39752 L
.65102 .39752 L
.65121 .39752 L
.65139 .39752 L
.65157 .39752 L
.65176 .39752 L
.65194 .39752 L
.65213 .39752 L
.65231 .39752 L
.65249 .39752 L
.65268 .39752 L
.65286 .39752 L
.65304 .39752 L
.65323 .39752 L
.65341 .39752 L
.65359 .39752 L
.65378 .39752 L
.65396 .39752 L
.65415 .39752 L
.65433 .39752 L
.65451 .39752 L
.6547 .39752 L
.65488 .39752 L
.65506 .39752 L
.65525 .39752 L
.65543 .39752 L
.65562 .39752 L
.6558 .39752 L
.65598 .39752 L
.65617 .39752 L
.65635 .39752 L
.65653 .39752 L
.65672 .33202 L
.65687 .33202 L
.65702 .33202 L
.65717 .33202 L
.65733 .33202 L
.65748 .33202 L
.65763 .33202 L
Mistroke
.65778 .33202 L
.65794 .33202 L
.65809 .33202 L
.65824 .33202 L
.65839 .33202 L
.65854 .33202 L
.6587 .33202 L
.65885 .33202 L
.659 .33202 L
.65915 .33202 L
.65931 .33202 L
.65946 .33202 L
.65961 .33202 L
.65976 .27888 L
.65989 .27888 L
.66002 .27888 L
.66014 .27888 L
.66027 .27888 L
.6604 .27888 L
.66052 .27888 L
.66065 .27888 L
.66078 .27888 L
.6609 .27888 L
.66103 .27888 L
.66116 .27888 L
.66128 .27888 L
.66141 .27888 L
.66154 .27888 L
.66166 .27888 L
.66179 .27888 L
.66192 .27888 L
.66204 .27888 L
.66217 .27888 L
.6623 .27888 L
.66242 .27888 L
.66255 .27888 L
.66268 .27888 L
.6628 .27888 L
.66293 .27888 L
.66306 .27888 L
.66318 .27888 L
.66331 .27888 L
.66344 .27888 L
.66356 .27888 L
.66369 .27888 L
.66382 .27888 L
.66395 .27888 L
.66407 .27888 L
.6642 .27888 L
.66433 .27888 L
Mistroke
.66445 .27888 L
.66458 .27888 L
.66471 .27888 L
.66483 .27888 L
.66496 .27888 L
.66509 .27888 L
.66521 .27888 L
.66534 .27888 L
.66547 .27888 L
.66559 .27888 L
.66572 .27888 L
.66585 .23461 L
.66595 .23461 L
.66606 .23461 L
.66616 .23461 L
.66627 .23461 L
.66637 .23461 L
.66648 .23461 L
.66658 .23461 L
.66669 .23461 L
.6668 .23461 L
.6669 .23461 L
.66701 .23461 L
.66711 .23461 L
.66722 .23461 L
.66732 .23461 L
.66743 .23461 L
.66753 .23461 L
.66764 .23461 L
.66775 .23461 L
.66785 .23461 L
.66796 .23461 L
.66806 .23461 L
.66817 .23461 L
.66827 .23461 L
.66838 .23461 L
.66848 .23461 L
.66859 .23461 L
.6687 .23461 L
.6688 .23461 L
.66891 .23461 L
.66901 .23461 L
.66912 .23461 L
.66922 .23461 L
.66933 .23461 L
.66943 .23461 L
.66954 .23461 L
.66964 .23461 L
.66975 .23461 L
.66986 .23461 L
Mistroke
.66996 .23461 L
.67007 .23461 L
.67017 .23461 L
.67028 .23461 L
.67038 .23461 L
.67049 .23461 L
.67059 .23461 L
.6707 .23461 L
.67081 .23461 L
.67091 .23461 L
.67102 .23461 L
.67112 .23461 L
.67123 .23461 L
.67133 .23461 L
.67144 .2038 L
.67153 .2038 L
.67162 .2038 L
.67171 .2038 L
.6718 .2038 L
.67189 .2038 L
.67198 .2038 L
.67207 .2038 L
.67216 .2038 L
.67225 .2038 L
.67235 .2038 L
.67244 .17419 L
.67251 .17419 L
.67259 .17419 L
.67267 .17419 L
.67274 .17419 L
.67282 .17419 L
.6729 .17419 L
.67297 .17419 L
.67305 .17419 L
.67312 .17419 L
.6732 .17419 L
.67328 .2101 L
.67337 .2101 L
.67347 .2101 L
.67356 .2101 L
.67365 .2101 L
.67375 .2101 L
.67384 .2101 L
.67393 .2101 L
.67403 .2101 L
.67412 .2101 L
.67422 .2101 L
.67431 .2101 L
.6744 .2463 L
.67451 .2463 L
Mistroke
.67463 .2463 L
.67474 .2463 L
.67485 .2463 L
.67496 .2463 L
.67507 .2463 L
.67518 .2463 L
.67529 .2463 L
.6754 .2463 L
.67551 .2463 L
.67563 .2463 L
.67574 .26383 L
.67586 .26383 L
.67598 .26383 L
.67609 .26383 L
.67621 .26383 L
.67633 .26383 L
.67645 .26383 L
.67657 .26383 L
.67669 .26383 L
.67681 .26383 L
.67693 .26383 L
.67705 .26383 L
.67717 .11721 L
.67722 .11721 L
.67727 .11721 L
.67732 .11721 L
.67737 .11721 L
.67742 .11721 L
.67747 .11721 L
.67751 .11721 L
.67756 .11721 L
.67761 .11721 L
.67766 .11721 L
.67771 .19067 L
.6778 .19067 L
.67788 .19067 L
.67796 .19067 L
.67805 .19067 L
.67813 .19067 L
.67822 .19067 L
.6783 .19067 L
.67839 .19067 L
.67847 .19067 L
.67856 .19067 L
.67864 .15314 L
.67871 .15314 L
.67877 .15314 L
.67884 .15314 L
.67891 .15314 L
.67897 .15314 L
Mistroke
.67904 .15314 L
.67911 .15314 L
.67917 .15314 L
.67924 .15314 L
.6793 .15906 L
.67937 .15906 L
.67944 .15906 L
.67951 .15906 L
.67958 .15906 L
.67965 .15906 L
.67972 .15906 L
.67979 .15906 L
.67986 .15906 L
.67993 .15906 L
.68 .21029 L
.68009 .21029 L
.68018 .21029 L
.68028 .21029 L
.68037 .21029 L
.68047 .21029 L
.68056 .21029 L
.68065 .21029 L
.68075 .21029 L
.68084 .21029 L
.68094 .21029 L
.68103 .27266 L
.68115 .27266 L
.68128 .27266 L
.6814 .27266 L
.68152 .27266 L
.68165 .27266 L
.68177 .27266 L
.6819 .27266 L
.68202 .27266 L
.68214 .27266 L
.68227 .27266 L
.68239 .27266 L
.68251 .33014 L
.68267 .33014 L
.68282 .33014 L
.68297 .33014 L
.68312 .33014 L
.68327 .33014 L
.68342 .33014 L
.68357 .33014 L
.68373 .33014 L
.68388 .33014 L
.68403 .33014 L
.68418 .33014 L
.68433 .33014 L
Mistroke
.68448 .28649 L
.68461 .28649 L
.68474 .28649 L
.68487 .28649 L
.685 .28649 L
.68513 .28649 L
.68526 .28649 L
.68539 .28649 L
.68553 .28649 L
.68566 .28649 L
.68579 .28649 L
.68592 .28649 L
.68605 .39035 L
.68623 .39035 L
.68641 .39035 L
.68659 .39035 L
.68677 .39035 L
.68695 .39035 L
.68713 .39035 L
.68731 .39035 L
.68749 .39035 L
.68767 .39035 L
.68785 .39035 L
.68803 .39035 L
.68821 .3622 L
.68838 .3622 L
.68854 .3622 L
.68871 .3622 L
.68888 .3622 L
.68904 .3622 L
.68921 .3622 L
.68938 .3622 L
.68954 .3622 L
.68971 .3622 L
.68988 .3622 L
.69004 .3622 L
.69021 .3622 L
.69038 .3622 L
.69054 .3622 L
.69071 .39728 L
.69089 .39728 L
.69108 .39728 L
.69126 .39728 L
.69144 .39728 L
.69163 .39728 L
.69181 .39728 L
.692 .39728 L
.69218 .39728 L
.69236 .39728 L
.69255 .39728 L
Mistroke
.69273 .43954 L
.69293 .43954 L
.69314 .43954 L
.69334 .43954 L
.69355 .43954 L
.69375 .43954 L
.69395 .43954 L
.69416 .43954 L
.69436 .43954 L
.69456 .43954 L
.69477 .43954 L
.69497 .43954 L
.69518 .36832 L
.69535 .36832 L
.69552 .36832 L
.69568 .36832 L
.69585 .36832 L
.69602 .36832 L
.69619 .36832 L
.69636 .36832 L
.69653 .36832 L
.6967 .36832 L
.69687 .36832 L
.69704 .36832 L
.69721 .36832 L
.69738 .36832 L
.69755 .36832 L
.69772 .36832 L
.69789 .36832 L
.69806 .36832 L
.69823 .36832 L
.6984 .36832 L
.69857 .36832 L
.69874 .36832 L
.69891 .36832 L
.69908 .36832 L
.69925 .36832 L
.69942 .36832 L
.69959 .36832 L
.69976 .36832 L
.69993 .36832 L
.7001 .30853 L
.70024 .30853 L
.70038 .30853 L
.70052 .30853 L
.70066 .30853 L
.7008 .30853 L
.70094 .30853 L
.70108 .30853 L
.70122 .30853 L
Mistroke
.70137 .30853 L
.70151 .30853 L
.70165 .30853 L
.70179 .30853 L
.70193 .30853 L
.70207 .30853 L
.70221 .30853 L
.70235 .30853 L
.70249 .30853 L
.70263 .30853 L
.70277 .30853 L
.70292 .30853 L
.70306 .30853 L
.7032 .30853 L
.70334 .25834 L
.70346 .25834 L
.70357 .25834 L
.70369 .25834 L
.70381 .25834 L
.70392 .25834 L
.70404 .25834 L
.70416 .25834 L
.70427 .25834 L
.70439 .25834 L
.70451 .25834 L
.70462 .25834 L
.70474 .25834 L
.70486 .25834 L
.70498 .25834 L
.70509 .25834 L
.70521 .25834 L
.70533 .25834 L
.70544 .25834 L
.70556 .25834 L
.70568 .25834 L
.70579 .25834 L
.70591 .25834 L
.70603 .25834 L
.70614 .25834 L
.70626 .25834 L
.70638 .25834 L
.70649 .25834 L
.70661 .25834 L
.70673 .25834 L
.70685 .25834 L
.70696 .25834 L
.70708 .25834 L
.7072 .25834 L
.70731 .25834 L
.70743 .25834 L
Mistroke
.70755 .25834 L
.70766 .25834 L
.70778 .25834 L
.7079 .25834 L
.70801 .25834 L
.70813 .25834 L
.70825 .25834 L
.70837 .25834 L
.70848 .25834 L
.7086 .25834 L
.70872 .25834 L
.70883 .21766 L
.70893 .21766 L
.70903 .21766 L
.70912 .21766 L
.70922 .21766 L
.70932 .21766 L
.70942 .21766 L
.70951 .21766 L
.70961 .21766 L
.70971 .21766 L
.70981 .21766 L
.7099 .21766 L
.71 .21766 L
.7101 .21766 L
.7102 .21766 L
.71029 .21766 L
.71039 .21766 L
.71049 .21766 L
.71059 .21766 L
.71068 .21766 L
.71078 .21766 L
.71088 .21766 L
.71098 .21766 L
.71107 .21766 L
.71117 .21766 L
.71127 .21766 L
.71136 .21766 L
.71146 .21766 L
.71156 .21766 L
.71166 .21766 L
.71175 .21766 L
.71185 .21766 L
.71195 .21766 L
.71205 .21766 L
.71214 .21766 L
.71224 .21766 L
.71234 .21766 L
.71244 .21766 L
.71253 .21766 L
Mistroke
.71263 .21766 L
.71273 .21766 L
.71283 .21766 L
.71292 .21766 L
.71302 .21766 L
.71312 .21766 L
.71321 .21766 L
.71331 .21766 L
.71341 .21766 L
.71351 .21766 L
.7136 .21766 L
.7137 .21766 L
.7138 .21766 L
.7139 .21766 L
.71399 .21766 L
.71409 .21766 L
.71419 .21766 L
.71429 .16993 L
.71436 .16993 L
.71443 .16993 L
.71451 .16993 L
.71458 .16993 L
.71466 .16993 L
.71473 .16993 L
.71481 .16993 L
.71488 .16993 L
.71496 .16993 L
.71503 .16993 L
.7151 .14671 L
.71517 .14671 L
.71523 .14671 L
.7153 .14671 L
.71536 .14671 L
.71542 .14671 L
.71549 .14671 L
.71555 .14671 L
.71561 .14671 L
.71568 .14671 L
.71574 .14671 L
.7158 .19978 L
.71589 .19978 L
.71598 .19978 L
.71607 .19978 L
.71616 .19978 L
.71625 .19978 L
.71633 .19978 L
.71642 .19978 L
.71651 .19978 L
.7166 .19978 L
.71669 .19978 L
Mistroke
.71678 .19978 L
.71687 .23753 L
.71697 .23753 L
.71708 .23753 L
.71719 .23753 L
.71729 .23753 L
.7174 .23753 L
.71751 .23753 L
.71762 .23753 L
.71772 .23753 L
.71783 .23753 L
.71794 .23753 L
.71804 .23753 L
.71815 .23753 L
.71826 .23753 L
.71836 .23753 L
.71847 .23753 L
.71858 .26679 L
.7187 .26679 L
.71882 .26679 L
.71894 .26679 L
.71906 .26679 L
.71918 .26679 L
.7193 .26679 L
.71942 .26679 L
.71955 .26679 L
.71967 .26679 L
.71979 .26679 L
.71991 .26679 L
.72003 .26679 L
.72015 .07178 L
.72018 .07178 L
.7202 .07178 L
.72023 .07178 L
.72026 .07178 L
.72029 .07178 L
.72031 .07178 L
.72034 .07178 L
.72037 .07178 L
.7204 .07178 L
.72042 .07178 L
.72045 .07178 L
.72048 .11669 L
.72053 .11669 L
.72058 .11669 L
.72063 .11669 L
.72067 .11669 L
.72072 .11669 L
.72077 .11669 L
.72082 .11669 L
Mistroke
.72087 .11669 L
.72092 .11669 L
.72097 .11669 L
.72102 .21477 L
.72111 .21477 L
.72121 .21477 L
.7213 .21477 L
.7214 .21477 L
.7215 .21477 L
.72159 .21477 L
.72169 .21477 L
.72178 .21477 L
.72188 .21477 L
.72198 .21477 L
.72207 .26973 L
.7222 .22459 L
.7223 .18822 L
.72238 .15645 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01472 L
.72245 .01474 L
.72245 .01474 L
.72245 .01474 L
.72245 .01474 L
.72245 .01474 L
.72245 .015 L
.72245 .015 L
.72245 .015 L
.72245 .015 L
.72245 .015 L
.72245 .01758 L
.72245 .01758 L
.72245 .01758 L
.72245 .01758 L
.72245 .01758 L
.72245 .01758 L
Mistroke
.72246 .04337 L
.72247 .04337 L
.72248 .04337 L
.7225 .04337 L
.72251 .04337 L
.72252 .04337 L
.72254 .04337 L
.72255 .08044 L
.72258 .06724 L
.72261 .06724 L
.72263 .06724 L
.72266 .06724 L
.72268 .06724 L
.72271 .06724 L
.72274 .06724 L
.72276 .06724 L
.72279 .11976 L
.72284 .11976 L
.72289 .11976 L
.72294 .11976 L
.72299 .11976 L
.72304 .11976 L
.72309 .11976 L
.72314 .11976 L
.72319 .11976 L
.72324 .16789 L
.72331 .16789 L
.72339 .16789 L
.72346 .16789 L
.72353 .16789 L
.72361 .16789 L
.72368 .16789 L
.72375 .16789 L
.72383 .16789 L
.7239 .16789 L
.72397 .22101 L
.72407 .22101 L
.72417 .22101 L
.72427 .22101 L
.72437 .22101 L
.72447 .22101 L
.72457 .22101 L
.72467 .22101 L
.72477 .22101 L
.72487 .22101 L
.72496 .22101 L
.72506 .22101 L
.72516 .22101 L
.72526 .22101 L
.72536 .22101 L
Mistroke
.72546 .22101 L
.72556 .25415 L
.72567 .25415 L
.72579 .25415 L
.7259 .25415 L
.72602 .25415 L
.72613 .25415 L
.72625 .25415 L
.72636 .25415 L
.72648 .25415 L
.72659 .25415 L
.72671 .25415 L
.72682 .30955 L
.72696 .30955 L
.7271 .30955 L
.72725 .30955 L
.72739 .30955 L
.72753 .30955 L
.72767 .30955 L
.72781 .30955 L
.72795 .30955 L
.72809 .30955 L
.72824 .30955 L
.72838 .30955 L
.72852 .3728 L
.72869 .3728 L
.72886 .3728 L
.72903 .3728 L
.72921 .3728 L
.72938 .3728 L
.72955 .3728 L
.72972 .3728 L
.72989 .3728 L
.73007 .3728 L
.73024 .3728 L
.73041 .3728 L
.73058 .3728 L
.73075 .3728 L
.73092 .3728 L
.7311 .3728 L
.73127 .3728 L
.73144 .3728 L
.73161 .41859 L
.73181 .41859 L
.732 .41859 L
.73219 .41859 L
.73239 .41859 L
.73258 .41859 L
.73277 .41859 L
.73297 .41859 L
Mistroke
.73316 .41859 L
.73336 .41859 L
.73355 .41859 L
.73374 .41859 L
.73394 .47366 L
.73416 .47366 L
.73438 .47366 L
.7346 .47366 L
.73482 .47366 L
.73504 .47366 L
.73526 .47366 L
.73548 .47366 L
.7357 .47366 L
.73592 .47366 L
.73614 .47366 L
.73636 .47366 L
.73658 .46437 L
.7368 .46437 L
.73701 .46437 L
.73723 .46437 L
.73744 .46437 L
.73766 .46437 L
.73787 .46437 L
.73809 .46437 L
.73831 .46437 L
.73852 .46437 L
.73874 .46437 L
.73895 .46437 L
.73917 .51074 L
.73941 .51074 L
.73964 .51074 L
.73988 .51074 L
.74012 .51074 L
.74036 .51074 L
.7406 .51074 L
.74083 .51074 L
.74107 .51074 L
.74131 .51074 L
.74155 .51074 L
.74179 .51074 L
.74202 .51074 L
.74226 .51074 L
.7425 .51074 L
.74274 .42386 L
.74294 .42386 L
.74313 .42386 L
.74333 .42386 L
.74352 .42386 L
.74372 .42386 L
.74392 .42386 L
Mistroke
.74411 .42386 L
.74431 .42386 L
.74451 .42386 L
.7447 .42386 L
.7449 .42386 L
.74509 .34136 L
.74525 .34136 L
.74541 .34136 L
.74556 .34136 L
.74572 .34136 L
.74588 .34136 L
.74604 .34136 L
.74619 .34136 L
.74635 .34136 L
.74651 .34136 L
.74666 .34136 L
.74682 .34136 L
.74698 .34136 L
.74713 .34136 L
.74729 .34136 L
.74745 .34136 L
.7476 .34136 L
.74776 .34136 L
.74792 .34136 L
.74807 .34136 L
.74823 .34136 L
.74839 .34136 L
.74854 .34136 L
.7487 .34136 L
.74886 .34136 L
.74901 .34136 L
.74917 .34136 L
.74933 .34136 L
.74948 .34136 L
.74964 .34136 L
.7498 .34136 L
.74995 .34136 L
.75011 .34136 L
.75027 .34136 L
.75042 .34136 L
.75058 .34136 L
.75074 .34136 L
.75089 .34136 L
.75105 .34136 L
.75121 .34136 L
.75136 .34136 L
.75152 .34136 L
.75168 .34136 L
.75183 .34136 L
.75199 .28668 L
Mistroke
.75212 .28668 L
.75225 .2384 L
.75236 .19436 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01472 L
.75245 .01475 L
.75245 .01475 L
.75245 .01475 L
.75245 .01475 L
.75245 .01475 L
.75245 .01507 L
.75245 .01507 L
.75245 .01507 L
.75245 .01507 L
.75245 .01507 L
.75245 .01827 L
.75245 .01827 L
.75245 .01827 L
.75245 .01827 L
.75245 .01827 L
.75245 .01827 L
.75246 .05023 L
.75247 .05023 L
.75249 .05023 L
.75251 .05023 L
.75252 .05023 L
.75254 .05023 L
.75256 .05023 L
.75258 .09237 L
.75261 .07341 L
.75264 .06339 L
.75266 .06339 L
.75269 .06339 L
.75271 .06339 L
.75273 .06339 L
.75276 .06339 L
Mistroke
.75278 .06339 L
.7528 .06339 L
.75283 .09904 L
.75287 .09904 L
.75291 .09904 L
.75295 .09904 L
.75299 .09904 L
.75303 .09904 L
.75307 .09904 L
.75311 .09904 L
.75315 .12068 L
.7532 .10299 L
.75324 .10299 L
.75329 .10299 L
.75333 .10299 L
.75337 .10299 L
.75341 .10299 L
.75346 .10299 L
.7535 .10299 L
.75354 .10299 L
.75358 .13664 L
.75364 .13664 L
.7537 .13664 L
.75376 .13664 L
.75382 .13664 L
.75388 .13664 L
.75393 .13664 L
.75399 .13664 L
.75405 .13664 L
.75411 .13664 L
.75417 .19183 L
.75425 .19183 L
.75434 .19183 L
.75442 .19183 L
.75451 .19183 L
.75459 .19183 L
.75468 .19183 L
.75476 .19183 L
.75485 .19183 L
.75493 .19183 L
.75502 .19183 L
.7551 .21107 L
.7552 .21107 L
.75529 .21107 L
.75539 .21107 L
.75548 .21107 L
.75557 .21107 L
.75567 .21107 L
.75576 .21107 L
.75586 .21107 L
Mistroke
.75595 .21107 L
.75605 .21107 L
.75614 .21107 L
.75623 .23787 L
.75634 .23787 L
.75645 .23787 L
.75656 .23787 L
.75666 .23787 L
.75677 .23787 L
.75688 .23787 L
.75698 .23787 L
.75709 .23787 L
.7572 .23787 L
.7573 .23787 L
.75741 .23787 L
.75752 .23787 L
.75763 .23787 L
.75773 .23787 L
.75784 .23787 L
.75795 .23787 L
.75805 .23787 L
.75816 .23787 L
.75827 .23787 L
.75838 .23787 L
.75848 .23787 L
.75859 .23787 L
.7587 .23787 L
.7588 .21898 L
.7589 .21898 L
.759 .21898 L
.7591 .21898 L
.7592 .21898 L
.75929 .21898 L
.75939 .21898 L
.75949 .21898 L
.75959 .21898 L
.75969 .21898 L
.75978 .21898 L
.75988 .21898 L
.75998 .1998 L
.76007 .1998 L
.76016 .1998 L
.76025 .1998 L
.76034 .1998 L
.76042 .1998 L
.76051 .1998 L
.7606 .1998 L
.76069 .1998 L
.76078 .1998 L
.76087 .1998 L
Mistroke
.76096 .1998 L
.76105 .1998 L
.76113 .1998 L
.76122 .1998 L
.76131 .1998 L
.7614 .1998 L
.76149 .1998 L
.76158 .1998 L
.76167 .1998 L
.76176 .1998 L
.76185 .1998 L
.76193 .1998 L
.76202 .1998 L
.76211 .22097 L
.76221 .22097 L
.76231 .22097 L
.76241 .22097 L
.76251 .22097 L
.76261 .22097 L
.76271 .22097 L
.7628 .22097 L
.7629 .22097 L
.763 .22097 L
.7631 .22097 L
.7632 .22097 L
.7633 .22097 L
.7634 .15104 L
.76346 .15104 L
.76353 .15104 L
.76359 .15104 L
.76366 .15104 L
.76373 .15104 L
.76379 .15104 L
.76386 .15104 L
.76392 .15104 L
.76399 .15104 L
.76405 .15104 L
.76412 .15104 L
.76418 .18811 L
.76427 .18811 L
.76435 .18811 L
.76443 .18811 L
.76452 .18811 L
.7646 .18811 L
.76468 .18811 L
.76477 .18811 L
.76485 .18811 L
.76493 .18811 L
.76502 .18811 L
.7651 .18811 L
Mistroke
.76518 .18811 L
.76526 .18811 L
.76535 .18811 L
.76543 .18811 L
.76551 .18811 L
.7656 .18811 L
.76568 .18811 L
.76576 .18811 L
.76585 .18811 L
.76593 .04522 L
.76594 .04522 L
.76596 .04522 L
.76597 .04522 L
.76599 .04522 L
.766 .04522 L
.76602 .04522 L
.76603 .04522 L
.76605 .04522 L
.76606 .04522 L
.76608 .04522 L
.76609 .08549 L
.76613 .08549 L
.76616 .08549 L
.76619 .08549 L
.76623 .08549 L
.76626 .08549 L
.76629 .08549 L
.76633 .08549 L
.76636 .08549 L
.7664 .08549 L
.76643 .13091 L
.76649 .13091 L
.76654 .13091 L
.7666 .13091 L
.76665 .13091 L
.76671 .13091 L
.76677 .13091 L
.76682 .13091 L
.76688 .13091 L
.76693 .13091 L
.76699 .13091 L
.76704 .13091 L
.7671 .13091 L
.76716 .16483 L
.76723 .16483 L
.7673 .16483 L
.76737 .16483 L
.76744 .16483 L
.76752 .16483 L
.76759 .16483 L
Mistroke
.76766 .16483 L
.76773 .16483 L
.7678 .16483 L
.76788 .16483 L
.76795 .16483 L
.76802 .16483 L
.76809 .16483 L
.76816 .20323 L
.76825 .20323 L
.76834 .20323 L
.76844 .20323 L
.76853 .20323 L
.76862 .20323 L
.76871 .20323 L
.7688 .20323 L
.76889 .20323 L
.76898 .20323 L
.76907 .20323 L
.76916 .24847 L
.76927 .24847 L
.76938 .24847 L
.7695 .24847 L
.76961 .24847 L
.76972 .24847 L
.76983 .24847 L
.76994 .24847 L
.77006 .24847 L
.77017 .24847 L
.77028 .24847 L
.77039 .24847 L
.7705 .24847 L
.77062 .24847 L
.77073 .24847 L
.77084 .28396 L
.77097 .28396 L
.7711 .28396 L
.77123 .28396 L
.77136 .28396 L
.77149 .28396 L
.77162 .28396 L
.77175 .28396 L
.77187 .28396 L
.772 .28396 L
.77213 .28396 L
.77226 .28396 L
.77239 .28396 L
.77252 .28396 L
.77265 .28396 L
.77278 .28396 L
.77291 .28396 L
Mistroke
.77304 .28396 L
.77317 .28396 L
.7733 .28396 L
.77343 .28396 L
.77355 .28396 L
.77368 .31532 L
.77383 .31532 L
.77397 .31532 L
.77412 .31532 L
.77426 .31532 L
.7744 .31532 L
.77455 .31532 L
.77469 .31532 L
.77484 .31532 L
.77498 .31532 L
.77513 .31532 L
.77527 .31532 L
.77541 .31532 L
.77556 .31532 L
.7757 .31532 L
.77585 .26031 L
.77596 .26031 L
.77608 .26031 L
.7762 .26031 L
.77632 .26031 L
.77644 .26031 L
.77655 .26031 L
.77667 .26031 L
.77679 .26031 L
.77691 .26031 L
.77703 .26031 L
.77714 .2743 L
.77727 .2743 L
.77739 .2743 L
.77752 .2743 L
.77764 .2743 L
.77777 .2743 L
.77789 .2743 L
.77802 .2743 L
.77814 .2743 L
.77826 .2743 L
.77839 .2743 L
.77851 .35261 L
.77868 .35261 L
.77884 .35261 L
.779 .35261 L
.77916 .35261 L
.77932 .35261 L
.77949 .35261 L
.77965 .35261 L
Mistroke
.77981 .35261 L
.77997 .35261 L
.78013 .35261 L
.7803 .40147 L
.78048 .40147 L
.78067 .40147 L
.78085 .40147 L
.78104 .40147 L
.78122 .40147 L
.78141 .40147 L
.7816 .40147 L
.78178 .40147 L
.78197 .40147 L
.78215 .40147 L
.78234 .44141 L
.78254 .44141 L
.78275 .44141 L
.78295 .44141 L
.78316 .44141 L
.78336 .44141 L
.78357 .44141 L
.78377 .44141 L
.78398 .44141 L
.78418 .44141 L
.78439 .44141 L
.78459 .44141 L
.78479 .48335 L
.78502 .48335 L
.78524 .48335 L
.78547 .48335 L
.78569 .48335 L
.78592 .48335 L
.78614 .48335 L
.78637 .48335 L
.78659 .48335 L
.78682 .48335 L
.78704 .48335 L
.78727 .48335 L
.78749 .48335 L
.78772 .48335 L
.78794 .48335 L
.78817 .48335 L
.78839 .48335 L
.78862 .48335 L
.78884 .40255 L
.78903 .40255 L
.78921 .33172 L
.78937 .26824 L
.78949 .01472 L
.78949 .01472 L
Mistroke
.78949 .01472 L
.78949 .01472 L
.78949 .01472 L
.78949 .01472 L
.78949 .01472 L
.78949 .01472 L
.78949 .01472 L
.78949 .01472 L
.78949 .01472 L
.78949 .01472 L
.78949 .01477 L
.78949 .01477 L
.78949 .01477 L
.78949 .01477 L
.78949 .01477 L
.78949 .01521 L
.78949 .01521 L
.78949 .01521 L
.78949 .01521 L
.78949 .01521 L
.78949 .01971 L
.78949 .01971 L
.78949 .01971 L
.7895 .01971 L
.7895 .01971 L
.7895 .01971 L
.7895 .06467 L
.78953 .06467 L
.78955 .06467 L
.78958 .06467 L
.7896 .06467 L
.78962 .06467 L
.78965 .06467 L
.78967 .12745 L
.78973 .10201 L
.78977 .10201 L
.78981 .10201 L
.78985 .10201 L
.78989 .10201 L
.78994 .10201 L
.78998 .10201 L
.79002 .10201 L
.79006 .1538 L
.79013 .1538 L
.79019 .1538 L
.79026 .1538 L
.79033 .1538 L
.79039 .1538 L
.79046 .1538 L
.79053 .1538 L
Mistroke
.79059 .1538 L
.79066 .20979 L
.79076 .20979 L
.79085 .20979 L
.79094 .20979 L
.79104 .20979 L
.79113 .20979 L
.79122 .20979 L
.79132 .20979 L
.79141 .20979 L
.7915 .20979 L
.7916 .27061 L
.79172 .27061 L
.79184 .27061 L
.79197 .27061 L
.79209 .27061 L
.79221 .27061 L
.79233 .27061 L
.79246 .27061 L
.79258 .27061 L
.7927 .27061 L
.79283 .27061 L
.79295 .27061 L
.79307 .27061 L
.79319 .27061 L
.79332 .27061 L
.79344 .27061 L
.79356 .27061 L
.79368 .27061 L
.79381 .27061 L
.79393 .27061 L
.79405 .27061 L
.79418 .27061 L
.7943 .27061 L
.79442 .27061 L
.79454 .27061 L
.79467 .27061 L
.79479 .27061 L
.79491 .27061 L
.79504 .27061 L
.79516 .27061 L
.79528 .27061 L
.7954 .27061 L
.79553 .27061 L
.79565 .27061 L
.79577 .27061 L
.79589 .27061 L
.79602 .27061 L
.79614 .27061 L
.79626 .27061 L
Mistroke
.79639 .27061 L
.79651 .27061 L
.79663 .27061 L
.79675 .27061 L
.79688 .27061 L
.797 .27061 L
.79712 .27061 L
.79725 .27061 L
.79737 .27061 L
.79749 .27061 L
.79761 .27061 L
.79774 .27061 L
.79786 .27061 L
.79798 .27061 L
.79811 .27061 L
.79823 .27061 L
.79835 .27061 L
.79847 .22665 L
.79858 .22665 L
.79868 .22665 L
.79878 .22665 L
.79888 .22665 L
.79898 .22665 L
.79908 .22665 L
.79919 .22665 L
.79929 .22665 L
.79939 .22665 L
.79949 .22665 L
.79959 .22665 L
.79969 .22665 L
.7998 .22665 L
.7999 .22665 L
.8 .22665 L
.8001 .22665 L
.8002 .22665 L
.8003 .22665 L
.80041 .22665 L
.80051 .22665 L
.80061 .22665 L
.80071 .22665 L
.80081 .22665 L
.80091 .22665 L
.80102 .22665 L
.80112 .22665 L
.80122 .22665 L
.80132 .22665 L
.80142 .22665 L
.80152 .22665 L
.80163 .22665 L
.80173 .22665 L
Mistroke
.80183 .22665 L
.80193 .22665 L
.80203 .22665 L
.80213 .22665 L
.80224 .22665 L
.80234 .22665 L
.80244 .22665 L
.80254 .22665 L
.80264 .22665 L
.80274 .22665 L
.80285 .22665 L
.80295 .22665 L
.80305 .22665 L
.80315 .22665 L
.80325 .22665 L
.80335 .22665 L
.80346 .22665 L
.80356 .22665 L
.80366 .22665 L
.80376 .22665 L
.80386 .22665 L
.80396 .22665 L
.80407 .22665 L
.80417 .18999 L
.80425 .18999 L
.80434 .16028 L
.80441 .13973 L
.80447 .11694 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01472 L
.80452 .01477 L
.80452 .01477 L
.80452 .01477 L
.80452 .01477 L
.80452 .01477 L
.80452 .01526 L
Mistroke
.80452 .01526 L
.80452 .01526 L
.80452 .01526 L
.80452 .01526 L
.80452 .02017 L
.80452 .02017 L
.80452 .02017 L
.80452 .02017 L
.80453 .02017 L
.80453 .02017 L
.80453 .0483 L
.80455 .0483 L
.80456 .0483 L
.80458 .0483 L
.8046 .0483 L
.80461 .0483 L
.80463 .0483 L
.80465 .07261 L
.80467 .05922 L
.80469 .05127 L
.80471 .05127 L
.80473 .05127 L
.80475 .05127 L
.80476 .05127 L
.80478 .05127 L
.8048 .05127 L
.80482 .05127 L
.80483 .08783 L
.80487 .08783 L
.8049 .08783 L
.80494 .08783 L
.80497 .08783 L
.80501 .08783 L
.80505 .08783 L
.80508 .08783 L
.80512 .09908 L
.80516 .09908 L
.8052 .09908 L
.80524 .09908 L
.80528 .09908 L
.80532 .09908 L
.80536 .09908 L
.8054 .09908 L
.80544 .09908 L
.80548 .14082 L
.80554 .14082 L
.8056 .14082 L
.80566 .14082 L
.80572 .14082 L
.80578 .14082 L
Mistroke
.80584 .14082 L
.8059 .14082 L
.80596 .14082 L
.80602 .14082 L
.80608 .17127 L
.80616 .17127 L
.80623 .17127 L
.80631 .17127 L
.80639 .17127 L
.80646 .17127 L
.80654 .17127 L
.80661 .17127 L
.80669 .17127 L
.80676 .17127 L
.80684 .17127 L
.80691 .17127 L
.80699 .17127 L
.80706 .17127 L
.80714 .20764 L
.80723 .20764 L
.80732 .20764 L
.80741 .20764 L
.80751 .20764 L
.8076 .20764 L
.80769 .20764 L
.80778 .20764 L
.80788 .20764 L
.80797 .20764 L
.80806 .20764 L
.80815 .20764 L
.80825 .12431 L
.8083 .12431 L
.80835 .12431 L
.8084 .12431 L
.80846 .12431 L
.80851 .12431 L
.80856 .12431 L
.80862 .12431 L
.80867 .12431 L
.80872 .12431 L
.80877 .12431 L
.80883 .13054 L
.80888 .13054 L
.80894 .13054 L
.80899 .13054 L
.80905 .13054 L
.8091 .13054 L
.80916 .13054 L
.80921 .13054 L
.80927 .13054 L
Mistroke
.80933 .13054 L
.80938 .13302 L
.80944 .13302 L
.80949 .13302 L
.80955 .13302 L
.80961 .13302 L
.80967 .13302 L
.80972 .13302 L
.80978 .13302 L
.80984 .13302 L
.80989 .13302 L
.80995 .15558 L
.81002 .15558 L
.81008 .15558 L
.81015 .15558 L
.81022 .15558 L
.81029 .15558 L
.81035 .15558 L
.81042 .15558 L
.81049 .15558 L
.81056 .15558 L
.81062 .15558 L
.81069 .19268 L
.81078 .19268 L
.81086 .19268 L
.81095 .19268 L
.81103 .19268 L
.81112 .19268 L
.8112 .19268 L
.81129 .19268 L
.81138 .19268 L
.81146 .19268 L
.81155 .19268 L
.81163 .19268 L
.81172 .06071 L
.81174 .06071 L
.81176 .06071 L
.81178 .06071 L
.81181 .06071 L
.81183 .06071 L
.81185 .06071 L
.81187 .06071 L
.81189 .06071 L
.81192 .06071 L
.81194 .06071 L
.81196 .14545 L
.81202 .14545 L
.81209 .14545 L
.81215 .14545 L
.81221 .14545 L
Mistroke
.81227 .14545 L
.81234 .14545 L
.8124 .14545 L
.81246 .14545 L
.81252 .14545 L
.81259 .19219 L
.81267 .19219 L
.81276 .19219 L
.81284 .19219 L
.81293 .19219 L
.81301 .19219 L
.8131 .19219 L
.81318 .19219 L
.81327 .19219 L
.81335 .19219 L
.81344 .19219 L
.81352 .25939 L
.81364 .25939 L
.81376 .25939 L
.81388 .25939 L
.81399 .25939 L
.81411 .25939 L
.81423 .25939 L
.81435 .25939 L
.81446 .25939 L
.81458 .25939 L
.8147 .25939 L
.81482 .25939 L
.81493 .30771 L
.81507 .30771 L
.81521 .30771 L
.81535 .30771 L
.8155 .30771 L
.81564 .30771 L
.81578 .30771 L
.81592 .30771 L
.81606 .30771 L
.8162 .30771 L
.81634 .30771 L
.81648 .30771 L
.81662 .30771 L
.81676 .30468 L
.8169 .30468 L
.81704 .30468 L
.81718 .30468 L
.81732 .30468 L
.81746 .30468 L
.8176 .30468 L
.81773 .30468 L
.81787 .30468 L
Mistroke
.81801 .30468 L
.81815 .30468 L
.81829 .30468 L
.81843 .30468 L
.81857 .37734 L
.81874 .37734 L
.81892 .37734 L
.81909 .37734 L
.81926 .37734 L
.81944 .37734 L
.81961 .37734 L
.81979 .37734 L
.81996 .37734 L
.82013 .37734 L
.82031 .37734 L
.82048 .37734 L
.82066 .37734 L
.82083 .37734 L
.821 .37734 L
.82118 .37734 L
.82135 .37734 L
.82153 .37734 L
.8217 .37734 L
.82187 .37734 L
.82205 .37734 L
.82222 .37734 L
.8224 .37734 L
.82257 .37734 L
.82274 .37734 L
.82292 .37734 L
.82309 .37734 L
.82327 .37734 L
.82344 .37734 L
.82361 .37734 L
.82379 .37734 L
.82396 .37734 L
.82414 .37734 L
.82431 .37734 L
.82448 .37734 L
.82466 .37734 L
.82483 .37734 L
.82501 .37734 L
.82518 .37734 L
.82535 .37734 L
.82553 .41639 L
.82572 .41639 L
.82591 .41639 L
.82611 .41639 L
.8263 .41639 L
.82649 .41639 L
Mistroke
.82669 .41639 L
.82688 .41639 L
.82707 .41639 L
.82726 .41639 L
.82746 .41639 L
.82765 .41639 L
.82784 .45524 L
.82805 .45524 L
.82826 .45524 L
.82848 .45524 L
.82869 .45524 L
.8289 .45524 L
.82911 .45524 L
.82932 .45524 L
.82953 .45524 L
.82974 .45524 L
.82996 .45524 L
.83017 .45524 L
.83038 .55652 L
.83064 .55652 L
.8309 .55652 L
.83116 .55652 L
.83142 .55652 L
.83168 .55652 L
.83194 .55652 L
.8322 .55652 L
.83246 .55652 L
.83272 .55652 L
.83298 .55652 L
.83324 .55652 L
.8335 .44483 L
.8337 .44483 L
.83391 .44483 L
.83412 .44483 L
.83432 .44483 L
.83453 .44483 L
.83474 .44483 L
.83494 .44483 L
.83515 .44483 L
.83536 .44483 L
.83556 .44483 L
.83577 .44483 L
.83597 .44483 L
.83618 .44483 L
.83639 .44483 L
.83659 .46689 L
.83681 .46689 L
.83703 .46689 L
.83724 .46689 L
.83746 .46689 L
Mistroke
.83768 .46689 L
.8379 .46689 L
.83811 .46689 L
.83833 .46689 L
.83855 .46689 L
.83876 .46689 L
.83898 .46945 L
.8392 .46945 L
.83942 .46945 L
.83963 .46945 L
.83985 .46945 L
.84007 .46945 L
.84029 .46945 L
.84051 .46945 L
.84073 .46945 L
.84094 .46945 L
.84116 .46945 L
.84138 .46984 L
.8416 .46984 L
.84182 .46984 L
.84204 .46984 L
.84225 .46984 L
.84247 .46984 L
.84269 .46984 L
.84291 .46984 L
.84313 .46984 L
.84335 .46984 L
.84356 .46984 L
.84378 .46984 L
.844 .46984 L
.84422 .46984 L
.84444 .46984 L
.84466 .46984 L
.84487 .46984 L
.84509 .46984 L
.84531 .46984 L
.84553 .46984 L
.84575 .46984 L
.84597 .46984 L
.84618 .46984 L
.8464 .46984 L
.84662 .46984 L
.84684 .46984 L
.84706 .46984 L
.84728 .46984 L
.84749 .46984 L
.84771 .46984 L
.84793 .46984 L
.84815 .46984 L
.84837 .46984 L
Mistroke
.84859 .46984 L
.8488 .46984 L
.84902 .46984 L
.84924 .46984 L
.84946 .39141 L
.84964 .39141 L
.84982 .39141 L
.85 .39141 L
.85018 .39141 L
.85036 .39141 L
.85054 .39141 L
.85073 .39141 L
.85091 .39141 L
.85109 .39141 L
.85127 .39141 L
.85145 .39141 L
.85163 .39141 L
.85181 .39141 L
.85199 .39141 L
.85217 .39141 L
.85235 .39141 L
.85253 .39141 L
.85271 .39141 L
.85289 .39141 L
.85307 .39141 L
.85326 .39141 L
.85344 .39141 L
.85362 .39141 L
.8538 .39141 L
.85398 .39141 L
.85416 .39141 L
.85434 .39141 L
.85452 .39141 L
.8547 .39141 L
.85488 .32643 L
.85503 .32643 L
.85518 .27381 L
.85531 .22811 L
.85541 .18891 L
.85549 .01472 L
.85549 .01472 L
.85549 .01472 L
.85549 .01472 L
.85549 .01472 L
.85549 .01472 L
.85549 .01472 L
.85549 .01472 L
.85549 .01472 L
.85549 .01472 L
.85549 .01472 L
Mistroke
.85549 .01472 L
.85549 .01475 L
.85549 .01475 L
.85549 .01475 L
.85549 .01475 L
.85549 .01507 L
.85549 .01507 L
.85549 .01507 L
.85549 .01507 L
.85549 .01507 L
.85549 .01821 L
.85549 .01821 L
.8555 .01821 L
.8555 .01821 L
.8555 .01821 L
.8555 .01821 L
.8555 .04971 L
.85552 .04971 L
.85554 .04971 L
.85555 .04971 L
.85557 .04971 L
.85559 .04971 L
.8556 .04971 L
.85562 .11466 L
.85567 .09588 L
.85571 .09588 L
.85575 .09588 L
.85579 .09588 L
.85582 .09588 L
.85586 .09588 L
.8559 .09588 L
.85594 .09588 L
.85598 .14638 L
.85604 .14638 L
.85611 .14638 L
.85617 .14638 L
.85623 .14638 L
.8563 .14638 L
.85636 .14638 L
.85642 .14638 L
.85649 .14638 L
.85655 .20167 L
.85664 .20167 L
.85673 .20167 L
.85682 .20167 L
.85691 .20167 L
.857 .20167 L
.85709 .20167 L
.85718 .20167 L
.85727 .20167 L
Mistroke
.85736 .20167 L
.85745 .24531 L
.85756 .24531 L
.85767 .24531 L
.85778 .24531 L
.85789 .24531 L
.858 .24531 L
.85811 .24531 L
.85822 .24531 L
.85833 .24531 L
.85844 .24531 L
.85855 .24531 L
.85866 .27694 L
.85879 .27694 L
.85891 .27694 L
.85904 .27694 L
.85917 .27694 L
.85929 .27694 L
.85942 .27694 L
.85954 .27694 L
.85967 .27694 L
.85979 .27694 L
.85992 .27694 L
.86005 .27694 L
.86017 .27694 L
.8603 .27694 L
.86042 .27694 L
.86055 .27694 L
.86068 .27694 L
.8608 .27694 L
.86093 .27694 L
.86105 .27694 L
.86118 .27694 L
.8613 .27694 L
.86143 .27694 L
.86156 .27694 L
.86168 .27694 L
.86181 .27694 L
.86193 .27694 L
.86206 .27694 L
.86219 .27694 L
.86231 .27694 L
.86244 .27694 L
.86256 .27694 L
.86269 .27694 L
.86281 .27694 L
.86294 .27694 L
.86307 .27694 L
.86319 .27694 L
.86332 .27694 L
Mistroke
.86344 .27694 L
.86357 .27694 L
.8637 .27694 L
.86382 .27694 L
.86395 .27694 L
.86407 .27694 L
.8642 .27694 L
.86432 .27694 L
.86445 .27694 L
.86458 .27694 L
.8647 .27694 L
.86483 .23131 L
.86493 .23131 L
.86504 .19149 L
.86512 .15597 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01472 L
.86519 .01474 L
.86519 .01474 L
.86519 .01474 L
.86519 .01474 L
.86519 .01474 L
.86519 .01499 L
.86519 .01499 L
.86519 .01499 L
.86519 .01499 L
.86519 .01499 L
.86519 .01749 L
.86519 .01749 L
.86519 .01749 L
.86519 .01749 L
.86519 .01749 L
.8652 .01749 L
.8652 .04251 L
.86521 .04251 L
.86522 .04251 L
Mistroke
.86524 .04251 L
.86525 .04251 L
.86526 .04251 L
.86528 .04251 L
.86529 .07598 L
.86532 .06371 L
.86534 .06371 L
.86537 .06371 L
.86539 .06371 L
.86541 .06371 L
.86544 .06371 L
.86546 .06371 L
.86548 .06371 L
.86551 .08915 L
.86554 .08915 L
.86558 .08915 L
.86561 .08915 L
.86565 .08915 L
.86569 .08915 L
.86572 .08915 L
.86576 .08915 L
.86579 .08915 L
.86583 .13103 L
.86588 .13103 L
.86594 .13103 L
.866 .13103 L
.86605 .13103 L
.86611 .13103 L
.86616 .13103 L
.86622 .13103 L
.86628 .13103 L
.86633 .13103 L
.86639 .1576 L
.86646 .1576 L
.86652 .1576 L
.86659 .1576 L
.86666 .1576 L
.86673 .1576 L
.8668 .1576 L
.86687 .1576 L
.86694 .1576 L
.867 .1576 L
.86707 .1576 L
.86714 .17754 L
.86722 .17754 L
.8673 .17754 L
.86738 .17754 L
.86745 .17754 L
.86753 .17754 L
.86761 .17754 L
Mistroke
.86769 .17754 L
.86777 .17754 L
.86784 .17754 L
.86792 .17754 L
.868 .17754 L
.86808 .20161 L
.86817 .20161 L
.86826 .20161 L
.86835 .20161 L
.86844 .20161 L
.86853 .20161 L
.86862 .20161 L
.86871 .20161 L
.8688 .20161 L
.86889 .20161 L
.86898 .20161 L
.86907 .20161 L
.86915 .20161 L
.86924 .20161 L
.86933 .20161 L
.86942 .20161 L
.86951 .20161 L
.8696 .20161 L
.86969 .20161 L
.86978 .20161 L
.86987 .20161 L
.86996 .20161 L
.87005 .20161 L
.87014 .20161 L
.87023 .20161 L
.87032 .20161 L
.87041 .20161 L
.8705 .20161 L
.87059 .20161 L
.87068 .20161 L
.87077 .20161 L
.87086 .20161 L
.87095 .20161 L
.87104 .20161 L
.87113 .20161 L
.87122 .20161 L
.87131 .20161 L
.8714 .20161 L
.87149 .20161 L
.87158 .20161 L
.87167 .20161 L
.87176 .20161 L
.87185 .13962 L
.87191 .13962 L
.87197 .13962 L
Mistroke
.87203 .13962 L
.87209 .13962 L
.87214 .13962 L
.8722 .13962 L
.87226 .13962 L
.87232 .13962 L
.87238 .13962 L
.87244 .13962 L
.8725 .13962 L
.87256 .13962 L
.87262 .13962 L
.87268 .13962 L
.87274 .16041 L
.87281 .16041 L
.87288 .16041 L
.87295 .16041 L
.87302 .16041 L
.87309 .16041 L
.87316 .16041 L
.87323 .16041 L
.8733 .16041 L
.87337 .16041 L
.87344 .16041 L
.87351 .16041 L
.87358 .15514 L
.87365 .15514 L
.87372 .15514 L
.87379 .15514 L
.87385 .15514 L
.87392 .15514 L
.87399 .15514 L
.87405 .15514 L
.87412 .15514 L
.87419 .15514 L
.87426 .15514 L
.87432 .15514 L
.87439 .06668 L
.87442 .06668 L
.87444 .06668 L
.87447 .06668 L
.87449 .06668 L
.87452 .06668 L
.87454 .06668 L
.87457 .06668 L
.87459 .06668 L
.87462 .06668 L
.87464 .06668 L
.87467 .10479 L
.87471 .10479 L
.87475 .10479 L
Mistroke
.8748 .10479 L
.87484 .10479 L
.87488 .10479 L
.87493 .10479 L
.87497 .10479 L
.87501 .10479 L
.87505 .10479 L
.8751 .10479 L
.87514 .04664 L
.87516 .04664 L
.87517 .04664 L
.87519 .04664 L
.8752 .04664 L
.87522 .04664 L
.87523 .04664 L
.87525 .04664 L
.87526 .04664 L
.87528 .04664 L
.87529 .08166 L
.87533 .08166 L
.87536 .08166 L
.87539 .08166 L
.87542 .08166 L
.87546 .08166 L
.87549 .08166 L
.87552 .08166 L
.87555 .08166 L
.87558 .09511 L
.87562 .09511 L
.87566 .09511 L
.8757 .09511 L
.87574 .09511 L
.87578 .09511 L
.87582 .09511 L
.87585 .09511 L
.87589 .09511 L
.87593 .10494 L
.87597 .10494 L
.87602 .10494 L
.87606 .10494 L
.8761 .10494 L
.87615 .10494 L
.87619 .10494 L
.87623 .10494 L
.87628 .10494 L
.87632 .10494 L
.87636 .10494 L
.87641 .10494 L
.87645 .1178 L
.8765 .1178 L
Mistroke
.87655 .1178 L
.8766 .1178 L
.87665 .1178 L
.8767 .1178 L
.87675 .1178 L
.8768 .1178 L
.87685 .1178 L
.8769 .1178 L
.87694 .1526 L
.87701 .1526 L
.87708 .1526 L
.87714 .1526 L
.87721 .1526 L
.87728 .1526 L
.87734 .1526 L
.87741 .1526 L
.87747 .1526 L
.87754 .1526 L
.87761 .1526 L
.87767 .1526 L
.87774 .1526 L
.87781 .16948 L
.87788 .16948 L
.87795 .16948 L
.87803 .16948 L
.8781 .16948 L
.87818 .16948 L
.87825 .16948 L
.87832 .16948 L
.8784 .16948 L
.87847 .16948 L
.87855 .16948 L
.87862 .18606 L
.8787 .18606 L
.87879 .18606 L
.87887 .18606 L
.87895 .18606 L
.87903 .18606 L
.87912 .18606 L
.8792 .18606 L
.87928 .18606 L
.87936 .18606 L
.87944 .18606 L
.87953 .2058 L
.87962 .2058 L
.87971 .2058 L
.8798 .2058 L
.87989 .2058 L
.87998 .2058 L
.88008 .2058 L
Mistroke
.88017 .2058 L
.88026 .2058 L
.88035 .2058 L
.88044 .2058 L
.88053 .2058 L
.88063 .19911 L
.88071 .19911 L
.8808 .19911 L
.88089 .19911 L
.88098 .19911 L
.88107 .19911 L
.88116 .19911 L
.88125 .19911 L
.88133 .19911 L
.88142 .19911 L
.88151 .19911 L
.8816 .19911 L
.88169 .18256 L
.88177 .18256 L
.88185 .18256 L
.88193 .18256 L
.88201 .18256 L
.88209 .18256 L
.88217 .18256 L
.88225 .18256 L
.88233 .18256 L
.88241 .18256 L
.88249 .18256 L
.88257 .16782 L
.88265 .16782 L
.88272 .16782 L
.88279 .16782 L
.88287 .16782 L
.88294 .16782 L
.88301 .16782 L
.88309 .16782 L
.88316 .16782 L
.88324 .16782 L
.88331 .21398 L
.8834 .21398 L
.8835 .21398 L
.8836 .21398 L
.88369 .21398 L
.88379 .21398 L
.88388 .21398 L
.88398 .21398 L
.88407 .21398 L
.88417 .21398 L
.88426 .21398 L
.88436 .25673 L
Mistroke
.88448 .25673 L
.88459 .25673 L
.88471 .25673 L
.88482 .25673 L
.88494 .25673 L
.88506 .25673 L
.88517 .25673 L
.88529 .25673 L
.88541 .25673 L
.88552 .25673 L
.88564 .25673 L
.88575 .25673 L
.88587 .25673 L
.88599 .28828 L
.88612 .28828 L
.88625 .28828 L
.88638 .28828 L
.88651 .28828 L
.88664 .28828 L
.88677 .28828 L
.88691 .28828 L
.88704 .28828 L
.88717 .28828 L
.8873 .28828 L
.88743 .28828 L
.88756 .28828 L
.88769 .28828 L
.88782 .28828 L
.88796 .37768 L
.88813 .37768 L
.8883 .37768 L
.88848 .37768 L
.88865 .37768 L
.88883 .37768 L
.889 .37768 L
.88917 .37768 L
.88935 .37768 L
.88952 .37768 L
.8897 .37768 L
.88987 .37768 L
.89005 .39304 L
.89023 .39304 L
.89041 .39304 L
.89059 .39304 L
.89077 .39304 L
.89095 .39304 L
.89113 .39304 L
.89132 .39304 L
.8915 .39304 L
.89168 .39304 L
Mistroke
.89186 .39304 L
.89204 .39304 L
.89222 .39304 L
.8924 .39304 L
.89259 .39304 L
.89277 .40081 L
.89295 .40081 L
.89314 .40081 L
.89332 .40081 L
.89351 .40081 L
.89369 .40081 L
.89388 .40081 L
.89406 .40081 L
.89425 .40081 L
.89444 .40081 L
.89462 .40081 L
.89481 .40081 L
.89499 .40081 L
.89518 .40081 L
.89536 .40081 L
.89555 .40081 L
.89573 .40081 L
.89592 .40081 L
.8961 .40081 L
.89629 .40081 L
.89647 .40081 L
.89666 .40081 L
.89684 .40081 L
.89703 .40081 L
.89721 .40081 L
.8974 .40081 L
.89758 .40081 L
.89777 .40081 L
.89796 .40081 L
.89814 .40081 L
.89833 .40081 L
.89851 .40081 L
.8987 .40081 L
.89888 .40081 L
.89907 .40081 L
.89925 .40081 L
.89944 .40081 L
.89962 .40081 L
.89981 .40081 L
.89999 .40081 L
.90018 .40081 L
.90036 .40081 L
.90055 .40081 L
.90073 .40081 L
.90092 .40081 L
Mistroke
.9011 .40081 L
.90129 .40081 L
.90147 .40081 L
.90166 .34531 L
.90182 .34531 L
.90198 .34531 L
.90214 .34531 L
.90229 .34531 L
.90245 .34531 L
.90261 .34531 L
.90277 .34531 L
.90293 .34531 L
.90309 .34531 L
.90325 .34531 L
.90341 .34531 L
.90356 .32024 L
.90371 .32024 L
.90386 .32024 L
.904 .32024 L
.90415 .32024 L
.9043 .32024 L
.90444 .32024 L
.90459 .32024 L
.90474 .32024 L
.90488 .32024 L
.90503 .32024 L
.90518 .32024 L
.90532 .25062 L
.90544 .25062 L
.90555 .25062 L
.90566 .25062 L
.90578 .25062 L
.90589 .25062 L
.906 .25062 L
.90612 .25062 L
.90623 .25062 L
.90634 .25062 L
.90645 .25062 L
.90657 .25062 L
.90668 .25062 L
.90679 .25062 L
.90691 .25062 L
.90702 .32794 L
.90717 .32794 L
.90732 .32794 L
.90747 .32794 L
.90762 .32794 L
.90777 .32794 L
.90792 .32794 L
.90807 .32794 L
Mistroke
.90822 .32794 L
.90837 .32794 L
.90852 .32794 L
.90867 .32794 L
.90882 .32794 L
.90897 .32794 L
.90912 .32794 L
.90928 .32794 L
.90943 .32794 L
.90958 .32794 L
.90973 .27444 L
.90985 .27444 L
.90998 .27444 L
.9101 .27444 L
.91022 .27444 L
.91035 .27444 L
.91047 .27444 L
.9106 .27444 L
.91072 .27444 L
.91085 .27444 L
.91097 .27444 L
.9111 .27444 L
.91122 .27444 L
.91135 .27444 L
.91147 .27444 L
.9116 .2646 L
.91172 .2646 L
.91184 .2646 L
.91195 .2646 L
.91207 .2646 L
.91219 .2646 L
.91231 .2646 L
.91243 .2646 L
.91255 .2646 L
.91267 .2646 L
.91279 .2646 L
.91291 .2646 L
.91303 .21651 L
.91313 .21651 L
.91323 .21651 L
.91332 .21651 L
.91342 .21651 L
.91352 .21651 L
.91362 .21651 L
.91371 .21651 L
.91381 .21651 L
.91391 .21651 L
.914 .21651 L
.9141 .21692 L
.9142 .21692 L
Mistroke
.91429 .21692 L
.91439 .21692 L
.91449 .21692 L
.91458 .21692 L
.91468 .21692 L
.91478 .21692 L
.91488 .21692 L
.91497 .21692 L
.91507 .21692 L
.91517 .21209 L
.91526 .21209 L
.91536 .21209 L
.91545 .21209 L
.91555 .21209 L
.91564 .21209 L
.91573 .21209 L
.91583 .21209 L
.91592 .21209 L
.91602 .21209 L
.91611 .21209 L
.91621 .3254 L
.91636 .3254 L
.91651 .3254 L
.91666 .3254 L
.9168 .3254 L
.91695 .3254 L
.9171 .3254 L
.91725 .3254 L
.9174 .3254 L
.91755 .3254 L
.9177 .3254 L
.91785 .3254 L
.918 .3254 L
.91815 .3254 L
.9183 .3254 L
.91844 .37673 L
.91862 .37673 L
.91879 .37673 L
.91897 .37673 L
.91914 .37673 L
.91931 .37673 L
.91949 .37673 L
.91966 .37673 L
.91983 .37673 L
.92001 .37673 L
.92018 .37673 L
.92035 .37673 L
.92053 .37673 L
.9207 .37673 L
.92088 .37673 L
Mistroke
.92105 .37673 L
.92122 .41502 L
.92142 .41502 L
.92161 .41502 L
.9218 .41502 L
.92199 .41502 L
.92218 .41502 L
.92238 .41502 L
.92257 .41502 L
.92276 .41502 L
.92295 .41502 L
.92314 .41502 L
.92334 .41502 L
.92353 .41502 L
.92372 .41502 L
.92391 .41502 L
.9241 .41502 L
.9243 .41502 L
.92449 .41502 L
.92468 .41502 L
.92487 .41502 L
.92506 .41502 L
.92526 .46262 L
.92547 .46262 L
.92569 .46262 L
.9259 .46262 L
.92612 .46262 L
.92633 .46262 L
.92655 .46262 L
.92676 .46262 L
.92698 .46262 L
.92719 .46262 L
.92741 .46262 L
.92762 .46262 L
.92784 .5133 L
.92808 .5133 L
.92831 .5133 L
.92855 .5133 L
.92879 .5133 L
.92903 .5133 L
.92927 .5133 L
.92951 .5133 L
.92975 .5133 L
.92999 .5133 L
.93023 .5133 L
.93047 .5133 L
.93071 .45216 L
.93092 .45216 L
.93113 .45216 L
.93134 .45216 L
Mistroke
.93155 .45216 L
.93176 .45216 L
.93197 .45216 L
.93218 .45216 L
.93239 .45216 L
.9326 .45216 L
.93281 .45216 L
.93302 .45216 L
.93323 .45216 L
.93344 .45216 L
.93365 .45216 L
.93385 .45216 L
.93406 .45216 L
.93427 .45216 L
.93448 .45216 L
.93469 .45216 L
.9349 .45216 L
.93511 .45216 L
.93532 .45216 L
.93553 .45216 L
.93574 .45216 L
.93595 .45216 L
.93616 .45216 L
.93637 .45216 L
.93658 .45216 L
.93679 .45216 L
.937 .45216 L
.93721 .37636 L
.93739 .37636 L
.93756 .30952 L
.9377 .24991 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01472 L
.93781 .01476 L
.93781 .01476 L
.93781 .01476 L
.93781 .01476 L
.93781 .01518 L
.93781 .01518 L
.93782 .01518 L
Mistroke
.93782 .01518 L
.93782 .01518 L
.93782 .01933 L
.93782 .01933 L
.93782 .01933 L
.93782 .01933 L
.93782 .01933 L
.93783 .01933 L
.93783 .06089 L
.93785 .06089 L
.93787 .06089 L
.9379 .06089 L
.93792 .06089 L
.93794 .06089 L
.93796 .06089 L
.93798 .1162 L
.93803 .1162 L
.93808 .1162 L
.93813 .1162 L
.93818 .1162 L
.93823 .1162 L
.93828 .1162 L
.93833 .1162 L
.93837 .14966 L
.93844 .14966 L
.9385 .14966 L
.93857 .14966 L
.93863 .14966 L
.9387 .14966 L
.93876 .14966 L
.93883 .14966 L
.93889 .14966 L
.93896 .20756 L
.93905 .20756 L
.93914 .20756 L
.93923 .20756 L
.93933 .20756 L
.93942 .20756 L
.93951 .20756 L
.9396 .20756 L
.9397 .20756 L
.93979 .20756 L
.93988 .25353 L
.94 .25353 L
.94011 .25353 L
.94023 .25353 L
.94034 .25353 L
.94045 .25353 L
.94057 .25353 L
.94068 .25353 L
Mistroke
.9408 .25353 L
.94091 .25353 L
.94103 .25353 L
.94114 .28989 L
.94127 .28989 L
.94141 .28989 L
.94154 .28989 L
.94167 .28989 L
.9418 .28989 L
.94193 .28989 L
.94207 .28989 L
.9422 .28989 L
.94233 .28989 L
.94246 .28989 L
.94259 .28989 L
.94273 .28989 L
.94286 .28989 L
.94299 .28989 L
.94312 .28989 L
.94325 .28989 L
.94339 .28989 L
.94352 .28989 L
.94365 .28989 L
.94378 .28989 L
.94391 .28989 L
.94405 .28989 L
.94418 .28989 L
.94431 .28989 L
.94444 .28989 L
.94458 .28989 L
.94471 .28989 L
.94484 .28989 L
.94497 .28989 L
.9451 .28989 L
.94524 .28989 L
.94537 .28989 L
.9455 .28989 L
.94563 .28989 L
.94576 .28989 L
.9459 .28989 L
.94603 .28989 L
.94616 .28989 L
.94629 .28989 L
.94642 .28989 L
.94656 .28989 L
.94669 .28989 L
.94682 .28989 L
.94695 .28989 L
.94708 .28989 L
.94722 .28989 L
Mistroke
.94735 .28989 L
.94748 .28989 L
.94761 .28989 L
.94774 .28989 L
.94788 .28989 L
.94801 .28989 L
.94814 .28989 L
.94827 .28989 L
.9484 .28989 L
.94854 .23304 L
.94864 .23304 L
.94875 .23304 L
.94885 .23304 L
.94896 .23304 L
.94906 .23304 L
.94916 .23304 L
.94927 .23304 L
.94937 .23304 L
.94948 .23304 L
.94958 .23304 L
.94969 .21444 L
.94978 .21444 L
.94988 .21444 L
.94998 .21444 L
.95007 .21444 L
.95017 .21444 L
.95026 .21444 L
.95036 .21444 L
.95046 .21444 L
.95055 .21444 L
.95065 .21444 L
.95074 .29062 L
.95087 .29062 L
.95101 .29062 L
.95114 .29062 L
.95127 .29062 L
.9514 .29062 L
.95154 .29062 L
.95167 .29062 L
.9518 .29062 L
.95193 .29062 L
.95207 .29062 L
.9522 .29062 L
.95233 .29062 L
.95246 .29062 L
.9526 .29062 L
.95273 .32079 L
.95288 .32079 L
.95302 .32079 L
.95317 .32079 L
Mistroke
.95332 .32079 L
.95346 .32079 L
.95361 .32079 L
.95376 .32079 L
.9539 .32079 L
.95405 .32079 L
.9542 .32079 L
.95434 .32079 L
.95449 .32079 L
.95464 .15034 L
.9547 .15034 L
.95477 .15034 L
.95483 .15034 L
.9549 .15034 L
.95496 .15034 L
.95503 .15034 L
.95509 .15034 L
.95516 .15034 L
.95522 .15034 L
.95529 .15034 L
.95535 .15034 L
.95542 .21729 L
.95552 .21729 L
.95561 .21729 L
.95571 .21729 L
.95581 .21729 L
.9559 .21729 L
.956 .21729 L
.9561 .21729 L
.9562 .21729 L
.95629 .21729 L
.95639 .21729 L
.95649 .24184 L
.9566 .24184 L
.95671 .24184 L
.95681 .24184 L
.95692 .24184 L
.95703 .24184 L
.95714 .24184 L
.95725 .24184 L
.95736 .24184 L
.95747 .24184 L
.95758 .24184 L
.95769 .25482 L
.9578 .25482 L
.95792 .25482 L
.95803 .25482 L
.95815 .25482 L
.95826 .25482 L
.95838 .25482 L
Mistroke
.95849 .25482 L
.95861 .25482 L
.95872 .25482 L
.95884 .25482 L
.95895 .36885 L
.95912 .36885 L
.95929 .36885 L
.95946 .36885 L
.95963 .36885 L
.9598 .36885 L
.95997 .36885 L
.96014 .36885 L
.96031 .36885 L
.96048 .36885 L
.96065 .36885 L
.96082 .36885 L
.96099 .41724 L
.96119 .41724 L
.96138 .41724 L
.96157 .41724 L
.96177 .41724 L
.96196 .41724 L
.96215 .41724 L
.96234 .41724 L
.96254 .41724 L
.96273 .41724 L
.96292 .41724 L
.96312 .41724 L
.96331 .41724 L
.9635 .41724 L
.9637 .41724 L
.96389 .46814 L
.96411 .46814 L
.96432 .46814 L
.96454 .46814 L
.96476 .46814 L
.96498 .46814 L
.9652 .46814 L
.96541 .46814 L
.96563 .46814 L
.96585 .46814 L
.96607 .46814 L
.96628 .46814 L
.9665 .46814 L
.96672 .46814 L
.96694 .46814 L
.96715 .51711 L
.96739 .51711 L
.96764 .51711 L
.96788 .51711 L
Mistroke
.96812 .51711 L
.96836 .51711 L
.9686 .51711 L
.96884 .51711 L
.96908 .51711 L
.96932 .51711 L
.96956 .51711 L
.9698 .51711 L
.97005 .4322 L
.97025 .4322 L
.97045 .4322 L
.97065 .4322 L
.97085 .4322 L
.97105 .4322 L
.97125 .4322 L
.97145 .4322 L
.97165 .4322 L
.97185 .4322 L
.97205 .4322 L
.97225 .4322 L
.97245 .32815 L
.9726 .32815 L
.97275 .32815 L
.9729 .32815 L
.97305 .32815 L
.9732 .32815 L
.97335 .32815 L
.9735 .32815 L
.97365 .32815 L
.9738 .32815 L
.97395 .32815 L
.9741 .32815 L
.97425 .32815 L
.9744 .32815 L
.97456 .32815 L
.97471 .32848 L
.97486 .32848 L
.97501 .32848 L
.97516 .32848 L
.97531 .32848 L
.97546 .32848 L
.97561 .32848 L
.97576 .32848 L
.97591 .32848 L
.97606 .28553 L
.97619 .28553 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool0049oo`@000=oo`03001oogoo009oo`<001eoo`<001eoo`03001oogoo00=oo`03001oogoo009o
o`<001Yoo`@000=oo`8001Ioo`@0009oo`@000=oo`03001oogoo009oo`<001Ioo`@0009oo`<001Mo
o`00@Woo00<007ooOol037oo00<007ooOol07Goo00<007ooOol06Woo00<007ooOol02goo00<007oo
Ool06Goo00D007ooOomoo`00009oo`03001oogoo01Eoo`05001oogooOol0000>Ool00`00Oomoo`0E
Ool00`00Oomoo`04Ool00`00Oomoo`0DOol004=oo`03001oogoo00]oo`03001oogoo01eoo`03001o
ogoo01]oo`03001oogoo00Yoo`03001oogoo01Uoo`05001oogooOol00002Ool00`00Oomoo`0EOol0
0`00Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`0EOol00`00Oomoo`04Ool00`00Oomoo`0DOol0
04Aoo`03001oogoo00Moo`<001eoo`<001ioo`03001oogoo00Moo`<001aoo`05001oogooOol00002
Ool00`00Oomoo`0EOol00`00Oomoo`03Ool00`00Oomoo`07Ool3000HOol01000Oomoogoo0`005goo
0015Ool00`00Oomoo`06Ool00`00Oomoo`0MOol00`00Oomoo`0OOol00`00Oomoo`06Ool00`00Oomo
o`0LOol01@00Oomoogoo00000Woo00<007ooOol05Goo00<007ooOol017oo00<007ooOol01Woo00<0
07ooOol067oo00D007ooOomoo`0001Uoo`00@Woo00@007ooOol000Qoo`03001oogoo01eoo`03001o
ogoo01aoo`04001oogoo0008Ool00`00Oomoo`0JOol30003Ool01000Oomoo`005Goo0`000goo00@0
07ooOol000Qoo`03001oogoo01Ioo`<000=oo`03001oogoo01Moo`009Goo00<007ooOol06goo0P00
2Goo100077oo10006goo100027oo10006goo00<007ooOol00Woo0P0067oo00<007ooOol00Woo0P00
2Goo10005goo00@007ooOomoo`@001Ioo`009Goo00<007ooOol0n7oo000UOol00`00Oomoo`3hOol0
02Eoo`03001oogoo009oo`03001oogoo01Aoo`03001oogoo00Uoo`03001oogoo00Ioo`04001oogoo
000OOol00`00Oomoo`07Ool00`00Oomoo`0;Ool01000Oomoo`004Woo00<007ooOol01Woo00<007oo
Ool027oo00<007ooOol00Woo00<007ooOol04Woo00<007ooOol017oo00<007ooOol01goo00@007oo
Ool000aoo`04001oogoo000AOol00`00Oomoo`0BOol001mooo`000Eoo`009Goo00<007ooOol00Woo
00<007oo00001goo00<007ooOol017oo00<007ooOol00Woo00@007ooOol000Ioo`03001oo`0000Eo
o`06001oogooOol007oo0P001goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<0
07oo00001Goo00@007ooOol000=oo`03001oogoo00Eoo`03001oo`0000=oo`8000Moo`03001oogoo
00Aoo`04001oogoo0004Ool01@00Oomoogoo00000Woo00<007ooOol017oo0P000goo00@007ooOol0
00Moo`03001oogoo00Aoo`05001oogooOol00003Ool01000Oomoo`000goo00<007ooOol00Woo0P00
00=oo`0000001Goo00<007ooOol017oo00<007oo00001Goo00<007ooOol017oo00<007ooOol00goo
00<007oo00001Woo00<007ooOol02Goo000UOol00`00Oomoo`02Ool00`00Oomoo`0COol00`00Oomo
o`09Ool00`00Oomoo`07Ool00`00Ool0000POol00`00Oomoo`06Ool00`00Oomoo`0;Ool01@00Oomo
ogoo00004Woo00<007ooOol01Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol04goo00<0
07ooOol017oo00<007ooOol01Woo00D007ooOomoo`0000aoo`03001oo`00019oo`03001oogoo019o
o`009Goo00<007ooOol00Woo00<007ooOol04goo00<007ooOol02Goo00<007ooOol01goo00<007oo
000087oo00<007ooOol01Woo00<007ooOol02goo0P000Woo00<007ooOol047oo00<007ooOol01Woo
00<007ooOol01goo00<007ooOol00Woo00<007ooOol04goo00<007ooOol017oo00<007ooOol01Woo
00D007ooOomoo`0000aoo`03001oo`00019oo`03001oogoo019oo`009Goo00<007ooOol00Woo00<0
07ooOol04goo00<007ooOol02Goo00<007ooOol01goo00<007oo000087oo00<007ooOol01Woo00<0
07ooOol02goo00D007ooOomoo`00019oo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo009o
o`03001oogoo01=oo`03001oogoo00Aoo`03001oogoo00Ioo`05001oogooOol0000<Ool00`00Ool0
000BOol00`00Oomoo`0BOol002Eoo`03001oogoo009oo`03001oogoo01=oo`03001oogoo00Uoo`80
00Qoo`03001oo`00021oo`03001oogoo00Ioo`03001oogoo00]oo`05001oogooOol0000BOol00`00
Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`0COol00`00Oomoo`04Ool00`00
Oomoo`06Ool01@00Oomoogoo000037oo00<007oo00004Woo00<007ooOol04Woo000UOol20003Ool0
0`00Oomoo`0COol00`00Oomoo`09Ool00`00Oomoo`07Ool00`00Ool0000POol00`00Oomoo`06Ool0
0`00Oomoo`0;Ool01@00Oomoogoo00004Woo00<007ooOol01Woo00<007ooOol01goo00<007ooOol0
0Woo0P0057oo00<007ooOol017oo00<007ooOol01Woo00D007ooOomoo`0000aoo`04001oo`00000A
Ool00`00Oomoo`0BOol002Eoo`03001oogoo009oo`03001oogoo01=oo`03001oogoo00Uoo`03001o
ogoo00Moo`05001oo`00001oo`02000LOol00`00Oomoo`06Ool00`00Oomoo`0;Ool01@00Oomoogoo
00000Woo00<007ooOol03Goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol00Woo00<007oo
Ool04goo00<007ooOol017oo00D007ooOomoo`0000Aoo`05001oogooOol0000<Ool01P00Ool00000
Ool000moo`03001oogoo019oo`009Goo00<007ooOol00Woo00<007ooOol04goo0P0000=oo`000000
1goo00<007ooOol01goo00<007oo00000Woo00<007ooOol06goo00<007ooOol01Woo00<007ooOol0
0goo00<007ooOol01Goo00D007ooOomoo`00009oo`03001oogoo00eoo`03001oogoo00Ioo`03001o
ogoo00Moo`03001oogoo009oo`03001oogoo01=oo`03001oogoo00Aoo`05001oogooOol00004Ool0
1@00Oomoogoo000037oo00H007oo000007oo000?Ool00`00Oomoo`0BOol002Eoo`03001oogoo009o
o`03001oogoo01=oo`04001oogoo0008Ool00`00Oomoo`07Ool00`00Ool00002Ool00`00Oomoo`0K
Ool00`00Oomoo`06Ool20004Ool00`00Oomoo`05Ool01@00Oomoogoo00000Woo00<007ooOol03Goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol04goo00<007ooOol017oo
00D007ooOomoo`0000Aoo`04001oogooOol2000;Ool01P00Ool00000Ool000moo`03001oogoo019o
o`009Goo00<007ooOol00Woo00<007ooOol04goo00@007ooOol000Qoo`03001oogoo00Moo`03001o
o`00009oo`03001oogoo01]oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Eoo`05001o
ogooOol00002Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`02Ool0
0`00Oomoo`0COol00`00Oomoo`04Ool01@00Oomoogoo000017oo00D007ooOomoo`0000aoo`06001o
o`00001oo`003goo00<007ooOol04Woo000UOol00`00Oomoo`02Ool00`00Oomoo`0COol01000Oomo
o`0027oo00<007ooOol01goo00<007oo00000Woo00<007ooOol06goo00<007ooOol01Woo00<007oo
Ool00goo00<007ooOol01Goo00D007ooOomoo`00009oo`03001oogoo00eoo`03001oogoo00Ioo`03
001oogoo00Moo`8000=oo`03001oogoo01=oo`03001oogoo00Aoo`05001oogooOol00004Ool01`00
Oomoogoo001oo`0000Yoo`06001oo`00001oo`003goo00<007ooOol04Woo000UOol20003Ool00`00
Oomoo`0COol01000Oomoo`0027oo00<007ooOol01goo00<007oo00000Woo0P0077oo00D007ooOomo
o`0000Aoo`03001oogoo00=oo`03001oogoo00Eoo`05001oogooOol00002Ool00`00Oomoo`0=Ool0
0`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`0COol00`00Oomoo`04Ool0
1@00Oomoogoo000017oo0P000Woo00<007oo00002Woo00H007oo000007oo000?Ool00`00Oomoo`0B
Ool002Eoo`03001oogoo009oo`03001oogoo01=oo`04001oogoo0008Ool00`00Oomoo`07Ool01P00
Ool00000Ool0015oo`03001oogoo00Uoo`05001oogooOol00004Ool00`00Oomoo`03Ool00`00Oomo
o`05Ool01@00Oomoogoo00000Woo00<007ooOol03Goo00<007ooOol01Woo00<007ooOol01goo00<0
07ooOol00Woo00<007ooOol04goo00<007ooOol017oo00D007ooOomoo`0000Aoo`07001oogooOol0
07oo00002Woo00H007oo000007oo000?Ool00`00Oomoo`0BOol002Eoo`03001oogoo009oo`03001o
ogoo00]oo`03001oogoo00Eoo`800003Ool007oo00Moo`03001oogoo00Moo`06001oo`00001oo`00
4Goo00<007ooOol02Goo00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo00Eoo`05001o
ogooOol00002Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`02Ool0
0`00Oomoo`0BOol20006Ool01@00Oomoogoo000017oo00L007ooOomoo`00Ool0000:Ool01P00Ool0
0000Ool000moo`03001oogoo019oo`009Goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol0
1Goo00<007ooOol00P001goo0P0027oo00H007oo000007oo000AOol01@00Oomoogoo00001goo00D0
07ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo00Eoo`05001oogooOol00002Ool00`00Oomo
o`0=Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`0BOol20006Ool0
1@00Oomoogoo000017oo00L007ooOomoo`00Ool0000:Ool01P00Ool00000Ool000moo`03001oogoo
019oo`009Goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol01Goo00@007ooOol000Qoo`03
001oogoo00Moo`06001oo`00001oo`004Goo00D007ooOomoo`0000Moo`05001oogooOol00004Ool0
0`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo00000Woo00<007ooOol03Goo00<007ooOol0
1Woo00<007ooOol01goo0P000goo00<007ooOol04Woo0P001Woo00D007ooOomoo`0000Aoo`07001o
ogooOol007oo00002Woo00H007oo000007oo000?Ool00`00Oomoo`0BOol002Eoo`03001oogoo009o
o`03001oogoo00]oo`03001oogoo00Eoo`04001oogoo0008Ool00`00Oomoo`07Ool01P00Ool00000
Ool0015oo`05001oogooOol00007Ool01@00Oomoogoo000017oo00<007ooOol00goo00<007ooOol0
1Goo0P000Woo00@007ooOol000moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo009oo`80
01=oo`8000Ioo`05001oogooOol00004Ool01`00Oomoogoo001oo`0000Yoo`06001oo`00001oo`00
3goo00<007ooOol04Woo000UOol20003Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool01000Oomoo`00
27oo00<007ooOol01goo00H007oo000007oo000AOol01@00Oomoogoo00001goo00D007ooOomoo`00
00Aoo`03001oogoo00=oo`03001oogoo00Eoo`80009oo`04001oogoo000?Ool00`00Oomoo`06Ool0
0`00Oomoo`07Ool00`00Oomoo`02Ool2000COol20006Ool01@00Oomoogoo000017oo00@007ooOomo
o`<000Yoo`06001oo`00001oo`003goo00<007ooOol04Woo000UOol00`00Oomoo`02Ool00`00Oomo
o`0;Ool00`00Oomoo`05Ool01000Oomoo`0027oo00<007ooOol01goo00H007oo000007oo000AOol0
1@00Oomoogoo00001goo00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo00Eoo`80009o
o`04001oogoo000?Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`02Ool2000COol20006
Ool01@00Oomoogoo000017oo00L007ooOomoo`00Ool0000:Ool01P00Ool00000Ool000moo`03001o
ogoo019oo`009Goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol01Goo00@007ooOol000Qo
o`03001oogoo00Moo`06001oo`00001oo`004Goo00D007ooOomoo`0000Moo`05001oogooOol00004
Ool00`00Oomoo`03Ool00`00Oomoo`05Ool20002Ool01000Oomoo`003goo00<007ooOol01Woo00<0
07ooOol01goo00<007ooOol00Woo0P004goo0P001Woo00D007ooOomoo`0000Aoo`07001oogooOol0
07oo00002Woo00H007oo000007oo000?Ool00`00Oomoo`0BOol002Eoo`03001oogoo009oo`03001o
ogoo00]oo`03001oogoo00Eoo`800003Ool007oo00Moo`8000Qoo`06001oo`00001oo`004Goo00D0
07ooOomoo`0000Moo`80009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Eoo`80009o
o`04001oogoo000?Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`02Ool2000COol20006
Ool20002Ool00`00Oomoo`02Ool20002Ool3000:Ool01P00Ool00000Ool000moo`03001oogoo019o
o`009Goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol01Goo00@007ooOol000Qoo`8000Qo
o`@00003Ool007oo011oo`05001oogooOol00007Ool01@00Oomoogoo000017oo0P0017oo00<007oo
Ool01Goo0P000Woo00<007ooOol00P003Woo00<007ooOol01Woo00<007ooOol01goo00<007ooOol0
0Woo0P004goo0P001Woo0P000Woo00<007ooOol00Woo0P000Woo00<007oo00002Woo00D007oo0000
07oo008000ioo`03001oogoo019oo`009Goo00<007ooOol00Woo00<007ooOol02Woo0P001goo00@0
07ooOol000Qoo`8000Qoo`06001oo`00001oo`004Goo00D007ooOomoo`0000Moo`05001oogooOol0
0004Ool00`00Oomoo`03Ool00`00Oomoo`05Ool20002Ool01000Oomoo`003goo00<007ooOol01Woo
00<007ooOol01goo00<007ooOol00Woo0P004goo0P001Woo00D007ooOomoo`0000Aoo`80009oo`03
001oo`0000Yoo`06001oo`00001oo`003goo00<007ooOol04Woo000UOol00`00Oomoo`02Ool2000;
Ool20007Ool01000Oomoo`0027oo0P0027oo00H007oo000007oo000AOol01@00Oomoogoo00001goo
00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo00Eoo`80009oo`04001oogoo000?Ool0
0`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`02Ool2000COol20006Ool01@00Oomoogoo0000
17oo0P000Woo00<007oo00002Woo00H007oo000007oo000?Ool00`00Oomoo`0BOol002Eoo`8000=o
o`04001oogoo0009Ool20007Ool01000Oomoo`0027oo0P0027oo00H007oo000007oo000AOol01@00
Oomoogoo00001goo00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo00Eoo`80009oo`04
001oogoo000?Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`02Ool20008Ool20009Ool2
0006Ool01@00Oomoogoo000017oo0P000Woo00<007oo00002Woo00D007oo000007oo008000ioo`03
001oogoo019oo`009Goo00<007ooOol00Woo00@007ooOol000Uoo`8000Moo`04001oogoo0008Ool4
0006Ool01P00Ool00000Ool0015oo`05001oogooOol00007Ool20002Ool00`00Oomoo`02Ool00`00
Oomoo`03Ool00`00Oomoo`05Ool20002Ool00`00Oomoo`02000>Ool00`00Oomoo`06Ool00`00Oomo
o`07Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`08Ool20006Ool00`00Oomoo`020004Ool20002
Ool00`00Ool0000:Ool01P00Ool00000Ool000moo`03001oogoo019oo`009Goo00<007ooOol00Woo
00@007ooOol000Uoo`8000Moo`04001oogoo0008Ool40006Ool01P00Ool00000Ool0015oo`05001o
ogooOol00007Ool01@00Oomoogoo000017oo0P0017oo00<007ooOol01Goo0P000Woo00@007ooOol0
00moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo009oo`8000Qoo`03001oogoo00Qoo`80
00Ioo`03001oogoo008000Aoo`80009oo`<000Yoo`06001oo`00001oo`003goo00<007ooOol04Woo
000UOol00`00Oomoo`02Ool01000Oomoo`002Goo0P001goo00@007ooOol000Qoo`@000Ioo`05001o
o`00001oo`02000?Ool20003Ool00`00Oomoo`05Ool01@00Oomoogoo000017oo00<007ooOol00goo
00<007ooOol01Goo0P000Woo00@007ooOol000moo`03001oogoo00Ioo`03001oogoo00Moo`8000=o
o`8000Qoo`03001oogoo00Qoo`8000Ioo`03001oogoo008000Aoo`80009oo`<000Yoo`06001oo`00
001oo`003goo00<007ooOol04Woo0006Ool20004Ool00`00Oomoo`03Ool20004Ool20003Ool40004
Ool00`00Oomoo`02Ool01000Oomoo`002Goo0P001goo00@007ooOol000Qoo`@000Ioo`05001oo`00
001oo`02000?Ool20003Ool00`00Oomoo`05Ool01@00Oomoogoo000017oo00<007ooOol00goo00<0
07ooOol01Goo0P000Woo00@007ooOol000moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo
009oo`8000Qoo`03001oogoo00Qoo`8000Ioo`03001oogoo008000Aoo`80009oo`<000Yoo`06001o
o`00001oo`003goo00<007ooOol04Woo0005Ool01000Oomoo`0027oo00@007ooOol0009oo`04001o
ogoo0004Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01000Oomoo`002Goo0P001goo00@007ooOol0
00Qoo`@000Ioo`05001oo`00001oo`02000?Ool20003Ool00`00Oomoo`05Ool01@00Oomoogoo0000
17oo00<007ooOol00goo00<007ooOol01Goo0P000Woo00@007ooOol000moo`03001oogoo00Ioo`03
001oogoo00Moo`03001oogoo009oo`8000Qoo`03001oogoo00Qoo`8000Ioo`800003Ool0000000Ao
o`80009oo`<000Yoo`06001oo`00001oo`003goo00<007ooOol04Woo0005Ool01000Oomoo`0027oo
00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`03Ool20003Ool01000Oomoo`002Goo0P00
1goo00@007ooOol000Qoo`@000Ioo`05001oo`00001oo`02000?Ool20003Ool00`00Oomoo`05Ool0
1@00Oomoogoo000017oo00<007ooOol00goo00<007ooOol01Goo0P000Woo00@007ooOol000moo`03
001oogoo00Ioo`03001oogoo00Moo`03001oogoo009oo`8000Qoo`03001oogoo00Qoo`8000Ioo`80
0003Ool0000000Aoo`80009oo`<000Yoo`03001oo`0000<000moo`03001oogoo019oo`001Goo00@0
07ooOol000Qoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00goo00<007ooOol00Woo
00@007ooOol000Uoo`8000Moo`04001oogoo0008Ool40006Ool01@00Ool00000Ool00P002Goo0P00
17oo0P000goo00<007ooOol01Goo00D007ooOomoo`0000Aoo`03001oogoo009oo`8000Moo`80009o
o`04001oogoo000?Ool20007Ool00`00Oomoo`07Ool00`00Oomoo`02Ool20008Ool00`00Oomoo`08
Ool20006Ool200000goo00000004Ool20002Ool3000:Ool00`00Ool00003000?Ool00`00Oomoo`0B
Ool000Eoo`04001oogoo0008Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo00=oo`03
001oogoo009oo`04001oogoo0009Ool20007Ool200000goo001oo`07Ool40006Ool01@00Ool00000
Ool00P002Goo00<007ooOol00goo0P000goo00<007ooOol01Goo0P000Woo00<007ooOol00Woo00<0
07ooOol00Woo0P001goo0P000Woo00@007oo000000moo`03001oogoo00Ioo`03001oogoo00Moo`80
00=oo`8000Qoo`03001oogoo00Moo`<000Ioo`800003Ool0000000Aoo`80009oo`<000Yoo`H000mo
o`03001oogoo019oo`001Goo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomoo`000Woo0`00
1Goo00<007ooOol00Woo00<007ooOol00P0027oo0P001goo0P0000=oo`0000001goo10001Woo00D0
07oo000007oo008000Uoo`03001oogoo00=oo`8000=oo`03001oogoo00Eoo`80009oo`03001oogoo
009oo`03001oogoo009oo`8000Moo`80009oo`04001oo`00000?Ool00`00Oomoo`06Ool00`00Oomo
o`07Ool20003Ool20008Ool20008Ool30006Ool200000goo00000004Ool20002Ool3000:Ool00`00
Ool00004000>Ool01@00Oomoogoo000047oo0006Ool2000:Ool20004Ool20005Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool01000Oomoo`002Goo0P001goo0P0000=oo`0000001goo10001Woo00D007oo
000007oo008000Uoo`03001oogoo00=oo`8000=oo`03001oogoo00Eoo`80009oo`03001oogoo009o
o`03001oogoo009oo`8000Moo`80009oo`03001oo`00008000ioo`03001oogoo00Ioo`03001oogoo
00Moo`8000=oo`8000Qoo`8000Qoo`<000Ioo`800003Ool0000000Aoo`80009oo`<000Yoo`03001o
o`0000@000ioo`05001oogooOol0000@Ool002Eoo`03001oogoo009oo`800003Ool007oo00Qoo`80
00Moo`800003Ool0000000Moo`@000Ioo`05001oo`00001oo`020009Ool00`00Oomoo`03Ool20003
Ool00`00Oomoo`05Ool20002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20007Ool20002Ool00`00
Ool00002000>Ool00`00Oomoo`06Ool00`00Oomoo`07Ool20003Ool20008Ool20008Ool30006Ool2
00000goo00000004Ool20002Ool3000:Ool00`00Ool00004000>Ool01@00Oomoogoo000047oo000U
Ool20003Ool01000Oomoo`002Goo0P001goo0P0000=oo`0000001goo10001Woo100000=oo`000000
27oo0P001Goo0P000Woo0P001goo0P0000=oo`00000017oo0P000goo0P001goo0P000Woo00<007oo
00000P003Woo00<007ooOol01Woo00<007ooOol01goo0P000goo0P0027oo0P0027oo0`001Woo0P00
00=oo`00000017oo0P000Woo0`002Woo00<007oo00000P0000=oo`00Ool03Goo00D007ooOomoo`00
011oo`009Goo0P000goo00@007ooOol000Uoo`8000Moo`800003Ool0000000Moo`@000Ioo`05001o
o`00001oo`020008Ool20005Ool20002Ool20007Ool200000goo00000004Ool20003Ool20007Ool2
0002Ool00`00Ool00002000>Ool00`00Oomoo`06Ool00`00Oomoo`07Ool20003Ool20008Ool20008
Ool30006Ool200000goo00000004Ool20002Ool3000:Ool00`00Ool0000200000goo0000000=Ool0
1@00Oomoogoo000047oo000UOol20003Ool01000Oomoo`0027oo0`001goo0P0000=oo`0000001goo
10001Woo00D007oo000007oo008000Qoo`8000Eoo`80009oo`8000Moo`800003Ool0000000Aoo`80
00=oo`8000Moo`80009oo`03001oo`00008000ioo`03001oogoo00Ioo`03001oogoo00Moo`8000=o
o`8000Qoo`8000Qoo`<000Ioo`800003Ool0000000Aoo`80009oo`<000Yoo`03001oo`0000800003
Ool0000000eoo`05001oogooOol0000@Ool002Eoo`8000=oo`04001oogoo0008Ool30007Ool20000
0goo00000007Ool40006Ool01@00Ool00000Ool00P0027oo0P001Goo0P0000Aoo`00000000Moo`80
0003Ool0000000Aoo`8000=oo`8000Moo`80009oo`03001oo`00008000ioo`03001oogoo00Ioo`03
001oogoo00Moo`8000=oo`8000Moo`<000Qoo`<000Ioo`800003Ool0000000Aoo`80009oo`<000Yo
o`03001oo`0000800003Ool0000000eoo`05001oogooOol0000@Ool002Eoo`8000=oo`04001oo`00
0008Ool30007Ool200000goo00000007Ool40006Ool00`00Ool000040008Ool20005Ool2000017oo
000000001goo0P0000=oo`00000017oo0P000goo0P001goo0P000Woo00<007oo00000P003Woo00<0
07ooOol01Woo00<007ooOol01goo0P000goo0P001goo0`0027oo0`001Woo0P0000=oo`00000017oo
0P000Woo0`002Woo00<007oo00000P0000=oo`0000003Goo00D007ooOomoo`00011oo`009Goo0P00
0goo00@007oo000000Qoo`@000Ioo`800003Ool0000000Moo`@000Ioo`03001oo`0000@000Qoo`<0
00Aoo`800004Ool000000007Ool200000goo00000004Ool20003Ool20007Ool20002Ool01@00Ool0
07oo00003Woo00<007ooOol01Woo00<007ooOol01goo0P000goo0P001goo0`0027oo0`001Woo0P00
00=oo`00000017oo0P000Woo0`002Woo00<007oo00000P0000=oo`0000003Goo00D007ooOomoo`00
011oo`009Goo0P000goo100027oo0`001goo0P0000=oo`0000001goo10001Woo00<007oo00001000
27oo0`0017oo0P0000Aoo`00000000Moo`800003Ool0000000Aoo`8000=oo`8000Moo`80009oo`05
001oo`00Ool0000>Ool00`00Oomoo`06Ool01@00Oomoogoo00001Goo0P000goo0P001goo0`0027oo
0`001Woo0P0000=oo`00000017oo0P000Woo0`002Woo00<007oo00000P0000=oo`0000003Goo00D0
07ooOomoo`00011oo`009Goo0P000goo100027oo0`001goo1@001goo10001Woo00<007oo00001000
27oo0`0017oo0P0000Aoo`00000000Moo`800003Ool0000000Aoo`8000=oo`<000Ioo`80009oo`05
001oo`00Ool0000>Ool00`00Oomoo`06Ool01@00Oomoogoo00001Goo0P000goo0P001goo0`0027oo
0`001Woo0P0000=oo`00000017oo0P000Woo10002Goo00<007oo00000P0000=oo`0000003Goo00D0
07ooOomoo`00011oo`009Goo0P000goo100027oo0`001goo1@001goo10001Woo00<007oo00001000
27oo0`0017oo0P0000Aoo`00000000Moo`800003Ool0000000Aoo`80009oo`<000Moo`80009oo`05
001oo`00Ool0000>Ool20007Ool01@00Oomoogoo00001Goo0P000Woo0`001goo0`0027oo0`001Woo
0P0000=oo`00000017oo0P000Woo0`002Woo00<007oo00000P0000=oo`0000003Goo00D007ooOomo
o`00011oo`009Goo0P000goo100027oo0`001goo1@001goo10001Woo00<007oo0000100027oo0`00
17oo0P0000Aoo`00000000Moo`D000Aoo`80009oo`<000Moo`80009oo`05001oo`00Ool00008Ool2
0004Ool200000goo001oo`04Ool01@00Oomoogoo00001Goo0P000Woo0`001goo0`001goo10001Woo
1@0017oo0P000Woo0`002Woo00<007oo00000P0000=oo`0000003Goo00D007ooOomoo`00011oo`00
9Goo0P000goo1@001goo0`001goo1@001goo10001Woo00<007oo0000100027oo0`0017oo0P0000Ao
o`00000000Moo`03001oogoo00<000=oo`80009oo`<000Moo`80009oo`04001oo`00Ool20007Ool2
0004Ool200000goo001oo`04Ool01@00Oomoogoo00001Goo0P0000=oo`0000000P001goo0`001goo
10001Woo1P000goo0P000Woo0`002Woo1@0000=oo`0000003Goo00D007ooOomoo`00011oo`009Goo
0`000Woo1@001goo0`001goo1@001goo10001Woo00<007oo0000100027oo00<007oo000017oo0P00
00Aoo`00000000Moo`03001oogoo008000Aoo`80009oo`<000Moo`80009oo`<00003Ool0000000Mo
o`8000Aoo`800003Ool007oo00Aoo`05001oogooOol00002Ool00`00Oomoo`0200000goo00000002
0007Ool30007Ool40006Ool50004Ool20002Ool3000:Ool30003Ool2000=Ool01@00Oomoogoo0000
47oo000UOol20003Ool50007Ool30007Ool50007Ool40006Ool00`00Ool0000200000goo001oo`07
Ool00`00Ool00004Ool2000017oo000000001goo00D007ooOomoo`0000Aoo`80009oo`<000Moo`80
009oo`80009oo`8000Moo`8000Aoo`800003Ool007oo00Aoo`06001oogooOol007oo0P000Woo0P00
00=oo`0000000P001goo0`001goo10001Woo1@0017oo0P000Woo00<007oo00002Woo0`0017oo00<0
07ooOol01Goo0P0017oo00D007ooOomoo`00011oo`009Goo0P000goo1@001Woo0P0000=oo`00Ool0
1Woo1@001goo10001Woo1@0000=oo`00Ool01goo00<007oo000017oo0P0000=oo`0000000P001Woo
00D007ooOomoo`0000Aoo`80009oo`<000Moo`80009oo`80009oo`8000Moo`8000Aoo`800003Ool0
07oo00Aoo`80009oo`04001oo`000002Ool200000goo000000020007Ool30007Ool40006Ool50004
Ool20002Ool00`00Ool0000:Ool30004Ool20006Ool00`00Oomoo`03Ool00`00Oomoo`03000?Ool0
02Eoo`8000=oo`D000Ioo`04001oogoo0007Ool50007Ool50005Ool500000goo001oo`07Ool00`00
Ool00004Ool2000017oo000000001goo00D007ooOomoo`0000Aoo`80009oo`<000Moo`80009oo`80
00=oo`03001oogoo00Eoo`8000Aoo`800003Ool0000000Aoo`06001oogooOol007oo0P000Woo0P00
00=oo`0000000P001goo0`001Woo1P001Goo1@0017oo0P000Woo00<007oo00002Woo0`0017oo00<0
07ooOol01Goo00<007ooOol00goo00<007ooOol00P0047oo000UOol20003Ool50006Ool01000Oomo
o`001goo1@001goo10001Woo1@0000=oo`00Ool01goo00<007oo000017oo0P0000Aoo`00000000Mo
o`05001oogooOol00004Ool20002Ool30007Ool2000017oo001oo`000goo00<007ooOol01Goo0P00
17oo0P0000=oo`00000017oo00H007ooOomoo`00Ool20002Ool200000goo000000020007Ool30006
Ool00`00Ool000020006Ool50004Ool20002Ool00`00Ool0000:Ool30004Ool00`00Oomoo`05Ool0
0`00Oomoo`03Ool00`00Oomoo`02000@Ool002Eoo`8000=oo`03001oo`00008000Ioo`04001oogoo
0007Ool50007Ool01000Oomoo`001Woo0`000goo0P001goo00<007oo000017oo1P001goo00D007oo
Oomoo`0000Aoo`80009oo`03001oo`0000Moo`800004Ool007oo0003Ool00`00Oomoo`05Ool20004
Ool200000goo00000004Ool01P00Oomoogoo001oo`80009oo`800003Ool0000000@000Eoo`<000Io
o`03001oo`00008000Ioo`<00003Ool007oo00=oo`800005Ool00000Ool0000:Ool30004Ool00`00
Oomoo`05Ool00`00Oomoo`03Ool00`00Oomoo`02000@Ool002Eoo`8000=oo`03001oo`00008000Io
o`04001oogoo0007Ool50007Ool01000Oomoo`001Woo0`000goo0P001goo00<007oo000017oo00@0
07ooOomoo`8000Moo`05001oogooOol00004Ool500000goo001oo`06Ool2000017oo001oo`000goo
00<007ooOol01Goo0P0017oo0P0000=oo`00000017oo00H007ooOomoo`00Ool20002Ool200000goo
000000030006Ool30006Ool00`00Ool000020006Ool300000goo001oo`03Ool200001Goo001oogoo
00002Woo10000goo00<007ooOol01Goo00<007ooOol00goo00<007ooOol00P0047oo000UOol20003
Ool00`00Ool000020006Ool01000Oomoo`001goo1@001goo00@007ooOol000Ioo`<000Aoo`03001o
ogoo00=oo`<00003Ool007oo00=oo`04001oogooOol20007Ool01000Oomoogoo0P000goo0`000goo
00<007ooOol01Goo0P0000Aoo`00Ool000=oo`03001oogoo00Eoo`8000Aoo`800003Ool0000000Ao
o`06001oogooOol007oo0P000Woo0P0000=oo`0000000`0017oo1@001Woo00<007oo00000P001Woo
0`0000=oo`00Ool00goo0P0000Eoo`00Oomoo`0000Yoo`<000Aoo`03001oogoo00Eoo`03001oogoo
00=oo`03001oo`000080011oo`009Goo0`000Woo00<007oo00000P001Woo00@007ooOol000Moo`05
001oogooOol00006Ool20002Ool00`00Oomoo`04Ool30004Ool00`00Oomoo`03Ool01@00Oomoogoo
000017oo00@007ooOomoo`8000Moo`04001oogooOol20003Ool30003Ool00`00Oomoo`05Ool20000
17oo000000000goo0P001Woo0P0017oo0P0000=oo`00000017oo00H007ooOomoo`00Ool20002Ool2
00000goo000000030004Ool00`00Ool000020006Ool00`00Ool000020006Ool300000goo001oo`03
Ool200001Goo001oogoo00002Woo0`0017oo00<007ooOol01Goo00<007ooOol00goo00<007oo0000
0P0047oo000UOol00`00Ool00002Ool00`00Ool000020006Ool01000Oomoo`001goo00@007ooOomo
o`8000Eoo`05001oogooOol00006Ool30004Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<0
07ooOol00Woo00<007ooOol01Goo00<007ooOol00Woo00@007ooOomoo`<000=oo`03001oogoo00Eo
o`800003Ool007oo0080009oo`03001oogoo00Eoo`8000Aoo`800003Ool0000000Aoo`P0009oo`80
0003Ool0000000<000Aoo`03001oo`00008000Ioo`03001oogoo008000Ioo`05001oogooOol00004
Ool200001Goo001oogoo00002Woo0`0017oo00<007ooOol017oo0P001Goo00<007oo00000`003goo
000UOol00`00Ool00002Ool00`00Ool000020006Ool01000Oomoo`001goo00D007ooOomoo`0000Io
o`05001oogooOol00006Ool30004Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol0
0Woo00<007ooOol01Goo00<007ooOol00Woo00@007ooOomoo`<000=oo`8000Ioo`800003Ool007oo
00Aoo`8000Aoo`@000Aoo`800003Ool0000000Aoo`P0009oo`800003Ool0000000<000Aoo`03001o
o`00008000Ioo`03001oogoo008000Ioo`04001oogooOol20003Ool200001Goo001oogoo00002Woo
0`0017oo00<007ooOol017oo0P001Goo00<007oo00000`003goo000UOol00`00Ool00002Ool01@00
Oomoogoo00001Woo00@007ooOol000Moo`05001oogooOol00006Ool01@00Oomoogoo00001Woo0`00
17oo00<007ooOol00goo00D007ooOomoo`0000Aoo`03001oogoo009oo`8000Ioo`03001oogoo009o
o`04001oogooOol30003Ool20006Ool200000goo001oo`05Ool00`00Oomoo`02Ool40004Ool20000
0goo00000004Ool80002Ool200000goo000000030004Ool00`00Oomoo`020006Ool00`00Oomoo`02
0006Ool01000Oomoogoo0P000goo0P0000Eoo`00Oomoo`0000Yoo`<000Aoo`03001oogoo00=oo`<0
00Eoo`03001oo`0000<000moo`001Woo0P0017oo00<007ooOol00goo0P0017oo0P000goo100017oo
00<007oo00000Woo00D007ooOomoo`0000Eoo`80009oo`03001oogoo00Eoo`05001oogooOol00006
Ool01000Oomoogoo0P001Goo0`0017oo0P0017oo00D007ooOomoo`0000Aoo`03001oogoo009oo`80
00Ioo`03001oogoo009oo`04001oogooOol30004Ool00`00Oomoo`04Ool200000goo001oo`05Ool0
0`00Oomoo`02Ool40004Ool200000goo00000004Ool80002Ool200000goo000000030004Ool00`00
Oomoo`020006Ool00`00Oomoo`030005Ool00`00Oomoo`02Ool01000Oomoogoo0P0000Eoo`00Oomo
o`0000Yoo`<000Aoo`8000Aoo`<000Eoo`H000moo`001Goo00@007ooOol000Qoo`04001oogoo0002
Ool01000Oomoo`000Woo00<007ooOol01Goo00<007oo00000Woo00D007ooOomoo`0000Eoo`80009o
o`03001oogoo00Eoo`05001oogooOol00006Ool00`00Oomoo`02Ool00`00Oomoo`03Ool40003Ool0
0`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol00goo00<007ooOol017oo00<007ooOol0
0Woo00@007ooOomoo`<000Aoo`03001oogoo00Aoo`800003Ool007oo00Eoo`03001oogoo009oo`@0
00Aoo`800003Ool0000000Aoo`P0009oo`P000Aoo`03001oogoo008000Eoo`80009oo`03001oo`00
00Eoo`03001oogoo009oo`<00005Ool00000Ool00002Ool20009Ool30004Ool20004Ool30005Ool6
000?Ool000Eoo`04001oogoo0008Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo00Ao
o`<0009oo`05001oogooOol00005Ool01@00Oomoogoo00001goo00D007ooOomoo`0000Ioo`03001o
ogoo009oo`03001oogoo00=oo`<000Aoo`03001oogoo00=oo`05001oogooOol00004Ool00`00Oomo
o`03Ool00`00Oomoo`04Ool00`00Oomoo`02Ool3000017oo0000000017oo00<007ooOol017oo0P00
00=oo`00Ool01Goo00<007ooOol00Woo100017oo0P0000=oo`00000017oo20000Woo00@007ooOomo
o`@000Aoo`03001oogoo008000Eoo`07001oogooOol007oo00001Goo00<007ooOol00Woo0P000Woo
0P0000=oo`00Ool00Woo00<007ooOol01goo0`001Goo00<007ooOol00Woo0`001Goo1P003goo0005
Ool01000Oomoo`0027oo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`03Ool00`00Ool0
0002Ool01@00Oomoogoo00001Goo00@007ooOomoo`8000Ioo`07001oogooOol007oo000017oo00<0
07ooOol00Woo00<007ooOol00goo0`0017oo00<007ooOol00goo00D007ooOomoo`0000Aoo`03001o
ogoo00=oo`03001oogoo00Aoo`03001oogoo009oo`80009oo`<000Aoo`03001oogoo00Aoo`800003
Ool007oo00Eoo`03001oogoo009oo`@000Aoo`800003Ool000000080009oo`P0009oo`03001oogoo
00=oo`8000Aoo`05001oogooOol00005Ool01`00Oomoogoo001oo`0000Eoo`03001oogoo009oo`80
009oo`800003Ool007oo009oo`03001oogoo00Moo`<000Eoo`03001oogoo009oo`<000Eoo`H000mo
o`001Goo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomoo`001Goo00<007ooOol00Woo00<0
07oo00000Woo00D007ooOomoo`0000Eoo`03001oogoo009oo`03001oogoo00Aoo`07001oogooOol0
07oo000017oo00<007ooOol00Woo00<007ooOol00goo0`0017oo00<007ooOol00goo00D007ooOomo
o`0000Aoo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo009oo`80009oo`<000Aoo`03001o
ogoo00Aoo`800003Ool007oo00Eoo`03001oogoo009oo`@000Aoo`800003Ool000000080009oo`P0
009oo`03001oogoo00=oo`8000Aoo`04001oogooOol20004Ool01`00Oomoogoo001oo`0000Eoo`03
001oogoo009oo`80009oo`@000=oo`03001oogoo00Moo`<000Eoo`03001oogoo009oo`<000Eoo`H0
00moo`001Goo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol000Ao
o`03001oo`00009oo`05001oogooOol00005Ool00`00Oomoo`02Ool00`00Oomoo`04Ool01`00Oomo
ogoo001oo`0000Aoo`03001oogoo009oo`03001oogoo00=oo`<000Aoo`03001oogoo00=oo`05001o
ogooOol00004Ool00`00Oomoo`03Ool20005Ool00`00Oomoo`02Ool20002Ool40003Ool20005Ool2
00000goo001oo`05Ool00`00Oomoo`02Ool40004Ool70002Ool80002Ool00`00Oomoo`03Ool20004
Ool01@00Oomoogoo00001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo0`0000=o
o`00Ool01Goo00<007ooOol01goo100017oo00<007ooOol00Woo0`001Goo1P003goo0006Ool2000:
Ool20004Ool20004Ool20005Ool00`00Ool00002Ool01@00Oomoogoo00001Goo00<007ooOol00Woo
00<007ooOol017oo00L007ooOomoo`00Ool00004Ool00`00Oomoo`02Ool00`00Oomoo`03Ool30004
Ool00`00Oomoo`02Ool20003Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00
Oomoo`02Ool20002Ool00`00Oomoo`04Ool00`00Oomoo`04Ool200000goo001oo`05Ool00`00Oomo
o`02Ool50003Ool01000Oomoogoo0`000Woo20000Woo00<007ooOol00goo0P000goo0`000Woo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo0`0000=oo`00Ool01Goo
00<007ooOol01goo0`001Goo00<007ooOol00Woo0`001Goo1P003goo000UOol00`00Ool00002Ool0
1@00Oomoogoo00001Goo00<007ooOol00Woo00<007ooOol017oo00L007ooOomoo`00Ool00004Ool0
0`00Oomoo`02Ool00`00Oomoo`03Ool30004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`02Ool20002Ool00`00Oomoo`04Ool0
0`00Oomoo`04Ool200000goo001oo`05Ool00`00Oomoo`02Ool40004Ool01000Oomoogoo0`000Woo
0`000Woo0`000Woo00<007ooOol00goo0P000goo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00Woo0`0000=oo`00Ool01Goo00<007ooOol01goo00<0
07ooOol01Goo00<007ooOol00Woo0`001Goo1P003goo000UOol30002Ool01@00Oomoogoo00001Goo
00<007ooOol00Woo00<007ooOol017oo00L007ooOomoo`00Ool00003Ool20004Ool00`00Oomoo`03
Ool30004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00
Oomoo`04Ool00`00Oomoo`02Ool20002Ool00`00Oomoo`04Ool00`00Oomoo`04Ool200000goo0000
0005Ool00`00Oomoo`02Ool40004Ool01000Oomoogoo0`000Woo0`000Woo0`000Woo00<007ooOol0
0goo0P000goo00<007ooOol00Woo0`000goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0Woo0`0000=oo`00Ool01Goo00<007ooOol01goo00<007ooOol01Goo00<007ooOol00Woo0`001Goo
1P000goo0P002Woo000UOol00`00Ool00002Ool01@00Oomoogoo00001Goo00<007ooOol00Woo00<0
07ooOol017oo00@007ooOomoo`@0009oo`03001oogoo00=oo`03001oogoo00=oo`<000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Aoo`03001o
ogoo009oo`<00003Ool007oo00Eoo`03001oogoo00Aoo`800003Ool007oo00Eoo`03001oogoo009o
o`@000Aoo`04001oogooOol30002Ool30002Ool30002Ool00`00Oomoo`03Ool20003Ool00`00Oomo
o`02Ool20004Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool300000goo001oo`05
Ool00`00Oomoo`07Ool00`00Oomoo`05Ool00`00Oomoo`02Ool30005Ool60003Ool00`00Oomoo`09
Ool002Eoo`06001oo`00001oo`000goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo
00<007ooOol00Woo0`000Woo00<007ooOol00goo00<007ooOol00goo0`0017oo00<007ooOol00Woo
00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol017oo00<007ooOol00Woo
0`0000=oo`00Ool01Goo00<007ooOol017oo0P0000=oo`00Ool01Goo00<007ooOol00Woo100017oo
00@007ooOomoo`<0009oo`<0009oo`<0009oo`03001oogoo00=oo`8000=oo`03001oogoo009oo`80
00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo009oo`<00003Ool007oo00Eoo`03001o
ogoo00Moo`03001oogoo00Eoo`03001oogoo009oo`<000Eoo`03001oogoo00<000=oo`03001oogoo
00Uoo`009Goo00<007oo00000Woo00D007ooOomoo`0000Eoo`03001oogoo009oo`03001oogoo00Ao
o`03001oogoo009oo`<0009oo`03001oogoo00=oo`03001oogoo00=oo`<000Aoo`03001oogoo009o
o`03001oogoo009oo`8000=oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo009oo`<00003
Ool007oo00Eoo`03001oogoo00Aoo`800003Ool007oo00Eoo`03001oogoo009oo`@000Aoo`04001o
ogooOol30002Ool30002Ool30002Ool00`00Oomoo`03Ool20003Ool00`00Oomoo`02Ool20004Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool300000goo001oo`05Ool00`00Oomoo`07
Ool00`00Oomoo`05Ool00`00Oomoo`02Ool30005Ool00`00Oomoo`030003Ool00`00Oomoo`09Ool0
02Eoo`03001oo`00009oo`05001oogooOol00005Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool01000Oomoo`001Goo00<007ooOol00goo0`0017oo00<007ooOol00Woo00<007ooOol0
0Woo0P000goo00<007ooOol00goo00<007ooOol017oo00<007ooOol00goo0P0000=oo`00Ool01Goo
00<007ooOol017oo0P0000=oo`00Ool01Goo00<007ooOol00Woo00@007oo000000Aoo`04001oogoo
Ool30002Ool30002Ool30002Ool00`00Oomoo`03Ool20003Ool00`00Oomoo`02Ool20004Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool300000goo001oo`05Ool20008Ool00`00Oomo
o`05Ool00`00Oomoo`02Ool30005Ool00`00Oomoo`030003Ool00`00Oomoo`09Ool002Eoo`03001o
o`00009oo`05001oogooOol00004Ool20004Ool00`00Oomoo`04Ool00`00Oomoo`04Ool01000Oomo
o`001Goo00<007ooOol00goo10000goo0`000Woo00<007ooOol00Woo0P000goo00<007ooOol00goo
00<007ooOol017oo00<007ooOol00goo0P0000=oo`00Ool01Goo0P001Goo0P0000=oo`00Ool01Goo
0P000goo00@007oo000000Aoo`04001oogooOol30002Ool30003Ool20002Ool00`00Oomoo`03Ool2
0003Ool00`00Oomoo`03Ool01000Oomoogoo0P001Goo00<007ooOol00goo00<007ooOol00Woo0`00
00=oo`00Ool01Goo0P0027oo00<007ooOol01Goo00<007ooOol00Woo0`001Goo00<007ooOol00`00
0goo00<007ooOol02Goo000UOol01P00Ool00000Ool000=oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo00Aoo`03001oogoo00Aoo`04001oogoo0005Ool00`00Oomoo`03Ool30004Ool30002
Ool00`00Oomoo`02Ool20003Ool00`00Oomoo`03Ool20005Ool00`00Oomoo`03Ool200000goo001o
o`05Ool20005Ool200000goo001oo`05Ool00`00Oomoo`02Ool01000Ool0000017oo00<007ooOol0
0Woo0P000Woo0`000goo0P000Woo00<007ooOol017oo00D007ooOomoo`0000Eoo`04001oogooOol2
0005Ool00`00Oomoo`03Ool00`00Oomoo`02Ool300000goo001oo`06Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool00`00Oomoo`02Ool30005Ool01000Oomoogoo0P000goo00<007ooOol02Goo000UOol4
00000goo001oo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool01000Oomoo`001Goo00<007ooOol00goo00<007ooOol01Woo00@007ooOol000Aoo`8000=oo`03
001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`800003Ool007oo00Ioo`03001oogoo00=o
o`800003Ool007oo00Eoo`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`02Ool20002Ool3
0003Ool20002Ool00`00Oomoo`04Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000Ioo`03001o
ogoo00=oo`03001oogoo009oo`<00003Ool007oo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03
001oogoo009oo`<000Eoo`04001oogooOol20003Ool00`00Oomoo`09Ool002Eoo`06001oo`00001o
o`000goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol017oo00<007ooOol017oo00@007oo
Ool000Eoo`03001oogoo00=oo`03001oogoo00Ioo`04001oogoo0004Ool20003Ool00`00Oomoo`04
Ool00`00Oomoo`03Ool00`00Oomoo`03Ool200000goo001oo`06Ool00`00Oomoo`03Ool200000goo
001oo`05Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007ooOol00Woo0P000Woo0`000goo0P00
0Woo00<007ooOol017oo00D007ooOomoo`0000Eoo`05001oogooOol00006Ool00`00Oomoo`03Ool0
0`00Oomoo`04Ool00`00Ool00007Ool00`00Oomoo`06Ool00`00Oomoo`05Ool01000Oomoogoo1000
1Goo00@007ooOomoo`8000=oo`03001oogoo00Uoo`009Goo00H007oo000007oo0003Ool00`00Oomo
o`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool30006Ool01000Oomoo`001Goo00<007ooOol00goo
00<007ooOol01Woo00@007ooOol000Aoo`8000=oo`03001oogoo00Aoo`03001oogoo00=oo`03001o
ogoo00=oo`800003Ool007oo00Ioo`03001oogoo00=oo`800003Ool007oo00Eoo`03001oogoo009o
o`04001oogoo0004Ool00`00Oomoo`02Ool20002Ool30004Ool01000Oomoo`001Woo00D007ooOomo
o`0000Eoo`05001oogooOol00006Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Ool00007Ool0
0`00Oomoo`06Ool00`00Oomoo`05Ool01000Oomoogoo10001Goo00@007ooOomoo`8000=oo`03001o
ogoo00Uoo`009Goo00<007oo00000`000goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol01Woo00@007ooOol000Eoo`03001oogoo00=oo`03001oogoo00Ioo`04001oogoo
0004Ool20003Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool200000goo001oo`06
Ool00`00Oomoo`03Ool200000goo001oo`05Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007oo
Ool00Woo0P000Woo0`0017oo00@007ooOol000Ioo`05001oogooOol00005Ool01@00Oomoogoo0000
1Woo00<007ooOol00goo00<007ooOol017oo00<007oo00001goo00<007ooOol01Woo00<007ooOol0
1Goo00@007ooOomoo`D000Aoo`03001oogoo009oo`04001oogooOol2000:Ool002Eoo`03001oogoo
00<000=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Ioo`04001o
ogoo0005Ool00`00Oomoo`03Ool00`00Oomoo`06Ool01000Ool0000017oo0P000goo00<007ooOol0
17oo00<007ooOol00goo00<007ooOol00goo0P0000=oo`00Ool01Woo00<007ooOol00goo0P0000=o
o`00Ool01Goo00<007ooOol00Woo00<007ooOol00P000goo00<007ooOol00Woo0P000Woo0`0017oo
00@007ooOol000Ioo`03001oogoo008000Eoo`05001oogooOol00006Ool00`00Oomoo`03Ool00`00
Oomoo`04Ool00`00Ool00007Ool00`00Oomoo`06Ool00`00Oomoo`05Ool01000Oomoogoo0`0000=o
o`00Ool00goo00<007ooOol00Woo00<007ooOol00P002goo000UOol00`00Oomoo`06Ool30002Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`06Ool01000Oomoo`001Goo00<007ooOol00goo
00<007ooOol01Woo00@007oo000000Aoo`8000=oo`03001oogoo00Aoo`03001oogoo00=oo`03001o
ogoo00=oo`800003Ool007oo00Ioo`03001oogoo00=oo`800003Ool007oo00Eoo`03001oogoo009o
o`05001oogooOol00003Ool00`00Oomoo`02Ool20002Ool00`00Oomoo`04Ool01000Oomoo`001Woo
00<007ooOol00P001Goo00D007ooOomoo`0000Ioo`03001oogoo00=oo`03001oogoo00Aoo`03001o
o`0000Moo`03001oogoo00Ioo`03001oogoo00Eoo`05001oogooOol00003Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool01000Oomoo`0037oo000UOol20008Ool20002Ool00`00Oomoo`03Ool00`00Oomo
o`02Ool00`00Oomoo`06Ool01000Oomoo`001Goo00<007ooOol00goo00<007ooOol01Woo00<007oo
00001Goo0P000goo00<007ooOol017oo00<007ooOol00goo00<007ooOol00goo0P0000=oo`00Ool0
1Woo00<007ooOol00goo0P0000=oo`00Ool01Goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03
001oogoo009oo`80009oo`03001oogoo00Aoo`04001oogoo0006Ool01000Oomoo`001Woo00D007oo
Oomoo`0000Ioo`03001oogoo00=oo`03001oogoo00Aoo`03001oo`0000Moo`03001oogoo00Ioo`03
001oogoo00Eoo`05001oogooOol00003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`00
37oo000UOol00`00Oomoo`07Ool20002Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`06
Ool01000Ool000001Goo0P0017oo00<007ooOol01Woo00<007oo00001Goo0P000Woo0P001Woo00@0
07ooOomoo`<000Ioo`03001oo`0000Moo`03001oogoo00=oo`800003Ool007oo00Eoo`03001oogoo
009oo`05001oogooOol00003Ool00`00Oomoo`02Ool20002Ool00`00Oomoo`04Ool01000Oomoo`00
1Woo00@007ooOol000Ioo`05001oogooOol00006Ool01000Oomoogoo0`001Woo00<007oo00001goo
00<007ooOol01Woo00<007ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo009oo`03001oogoo
009oo`04001oogoo000<Ool002Eoo`03001oogoo00Moo`80009oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo00Ioo`03001oo`0000Moo`03001oogoo009oo`03001oogoo00Ioo`03001oo`00
00Eoo`80009oo`8000Ioo`05001oogooOol00008Ool00`00Ool00007Ool00`00Oomoo`03Ool40006
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00goo00@007ooOol000Ioo`04001o
ogoo0006Ool01000Oomoo`001Woo00D007ooOomoo`0000Ioo`05001oogooOol00008Ool00`00Ool0
0007Ool00`00Oomoo`06Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<0
07ooOol00Woo00@007ooOol000aoo`009Goo00<007ooOol01goo0P000Woo00<007ooOol00goo00<0
07ooOol00Woo00<007ooOol01Woo00<007oo00001goo00<007ooOol00Woo00<007ooOol01Woo00<0
07oo00001Goo0P000Woo00<007ooOol01Goo00D007ooOomoo`0000Qoo`03001oo`0000Moo`03001o
ogoo00=oo`03001oogoo00Moo`04001oogooOol20003Ool01@00Oomoogoo00001Goo00@007ooOol0
00Ioo`04001oogoo0006Ool200000goo001oo`05Ool01@00Oomoogoo00001Woo00D007ooOomoo`00
00Qoo`03001oo`0000Moo`03001oogoo00Ioo`03001oogoo00Eoo`05001oogooOol00003Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0037oo000UOol00`00Oomoo`07Ool20002Ool00`00
Oomoo`03Ool20003Ool00`00Oomoo`06Ool00`00Ool00007Ool00`00Oomoo`02Ool00`00Oomoo`06
Ool00`00Ool00005Ool20002Ool00`00Oomoo`05Ool01@00Oomoogoo000027oo00<007oo00001goo
00<007ooOol00goo00<007ooOol01goo00D007ooOomoo`0000Aoo`05001oogooOol00005Ool01000
Oomoo`001Woo00@007ooOol000Ioo`800003Ool007oo00Eoo`05001oogooOol00006Ool01@00Oomo
ogoo000027oo00<007oo00001goo00<007ooOol01Woo00<007ooOol01Goo00D007ooOomoo`0000=o
o`03001oogoo009oo`03001oogoo009oo`04001oogoo000<Ool002Eoo`03001oogoo00Moo`80009o
o`03001oogoo00Aoo`05001oogooOol00008Ool00`00Ool00007Ool00`00Oomoo`02Ool00`00Oomo
o`06Ool00`00Ool00006Ool01000Oomoo`001goo00D007ooOomoo`0000Qoo`03001oo`0000Moo`03
001oogoo00=oo`03001oogoo00Moo`80009oo`03001oogoo009oo`05001oogooOol00005Ool01000
Oomoo`001Woo00@007ooOol000Ioo`800003Ool007oo00Eoo`05001oogooOol00006Ool01@00Oomo
ogoo000027oo00<007oo00001goo00<007ooOol01Woo00<007ooOol01Goo00D007ooOomoo`0000=o
o`03001oogoo009oo`03001oogoo009oo`04001oogoo000<Ool002Eoo`8000Qoo`800003Ool00000
00Ioo`05001oogooOol00008Ool00`00Ool00007Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00
Ool00006Ool01000Oomoo`001goo00D007ooOomoo`0000Qoo`03001oo`0000Moo`03001oogoo00=o
o`03001oogoo00Moo`80009oo`03001oogoo009oo`05001oogooOol00005Ool200000goo001oo`05
Ool01000Oomoo`001Woo0P0000=oo`00Ool01Goo0`0000=oo`00Ool01Goo00D007ooOomoo`0000Qo
o`03001oo`0000Moo`03001oogoo00Ioo`03001oogoo00Eoo`05001oogooOol00003Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool01000Oomoo`0037oo000UOol00`00Oomoo`07Ool200000goo00000006
Ool01@00Oomoogoo000027oo00<007oo00001goo00<007ooOol00Woo00<007ooOol01Woo00<007oo
00001Woo10001goo00D007ooOomoo`0000Qoo`03001oo`0000Moo`03001oogoo00=oo`03001oogoo
00Qoo`04001oogoo0004Ool01@00Oomoogoo00001Goo00@007ooOol000Ioo`04001oogoo0006Ool2
00000goo001oo`05Ool50006Ool01@00Oomoogoo000027oo00<007oo00001goo00<007ooOol01Woo
00<007ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo009oo`03001oogoo009oo`04001oogoo
000<Ool002Eoo`03001oogoo00Moo`800003Ool007oo00Ioo`05001oogooOol00008Ool00`00Ool0
0007Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Ool00006Ool40007Ool01@00Oomoogoo0000
27oo00<007oo00001goo00<007ooOol00goo00<007ooOol027oo0P0000=oo`00Ool00goo00D007oo
Oomoo`0000Eoo`04001oogoo0006Ool01000Oomoo`001goo00<007oo00001Woo1@001Woo00D007oo
Oomoo`0000Qoo`03001oo`0000Moo`03001oogoo00Ioo`03001oogoo00Eoo`05001oogooOol00003
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool200000goo001oo`0;Ool002Eoo`03001oogoo00Moo`80
0003Ool007oo00Ioo`05001oogooOol00008Ool00`00Ool00007Ool20003Ool00`00Oomoo`06Ool0
0`00Ool00006Ool40007Ool01@00Oomoogoo000027oo00<007oo00001goo00<007ooOol00goo00<0
07ooOol027oo0P0000=oo`00Ool00goo00D007ooOomoo`0000Eoo`04001oogoo0006Ool01000Oomo
o`001goo00<007oo00001Woo10001goo0P000Woo00<007ooOol01Woo00<007oo00001goo00<007oo
Ool01Woo00<007ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo009oo`03001oogoo00=oo`03
001oo`0000aoo`001Woo0P0017oo00<007ooOol00goo0P0017oo0P0017oo0P001Goo00<007ooOol0
1goo0P0000=oo`00Ool01Woo00D007ooOomoo`0000Qoo`03001oo`0000Moo`8000=oo`03001oogoo
00Ioo`03001oo`0000Ioo`@000Moo`05001oogooOol00008Ool00`00Ool00007Ool20004Ool00`00
Oomoo`08Ool200000goo001oo`03Ool01@00Oomoogoo00001Goo00@007ooOol000Ioo`800003Ool0
07oo00Ioo`03001oo`0000Ioo`@000Qoo`04001oogoo0008Ool00`00Ool00007Ool30006Ool00`00
Oomoo`05Ool20002Ool01000Oomoogoo0P000goo00<007ooOol00goo00<007oo000037oo0005Ool0
1000Oomoo`0027oo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol0
1goo0P0000=oo`00Ool01Woo00D007ooOomoo`0000Qoo`03001oo`0000Moo`8000=oo`03001oogoo
00Ioo`03001oo`0000Ioo`@000Moo`05001oogooOol00008Ool00`00Ool00007Ool20004Ool00`00
Oomoo`08Ool200000goo001oo`03Ool01@00Oomoogoo00001Goo00@007ooOol000Moo`03001oo`00
00Moo`03001oo`0000Ioo`@000Qoo`04001oogoo0008Ool00`00Ool00008Ool00`00Oomoo`05Ool0
0`00Oomoo`06Ool01000Oomoo`0017oo00D007ooOomoo`0000Eoo`03001oo`0000aoo`001Goo00@0
07ooOol000Qoo`04001oogoo0002Ool01000Oomoo`001Goo00<007ooOol00Woo0P0027oo0P0000=o
o`00Ool01Woo00D007ooOomoo`0000Qoo`03001oo`0000Qoo`05001oogooOol00008Ool00`00Ool0
0006Ool40007Ool01@00Oomoogoo000027oo00<007oo000027oo00<007ooOol00Woo00<007ooOol0
27oo0P0000=oo`00Ool00goo00D007ooOomoo`0000Eoo`04001oogoo0007Ool00`00Ool00007Ool0
0`00Ool00006Ool40008Ool01000Oomoo`0027oo00<007oo000027oo00<007ooOol01Goo00<007oo
Ool01Woo00@007ooOol000Aoo`05001oogooOol00005Ool00`00Ool0000<Ool000Eoo`04001oogoo
0008Ool01000Oomoo`000Woo00@007ooOol000=oo`8000Eoo`03001oogoo00Moo`@000Moo`05001o
ogooOol00008Ool00`00Ool00008Ool01@00Oomoogoo000027oo00<007oo00001Woo10001goo00D0
07ooOomoo`0000Qoo`03001oo`0000Qoo`03001oogoo009oo`03001oogoo00Qoo`800003Ool007oo
00=oo`05001oogooOol00005Ool01000Oomoo`001goo00<007oo00001goo00<007oo00001Woo1000
27oo00@007ooOol000Qoo`03001oo`0000Qoo`03001oogoo00Aoo`8000Qoo`04001oogoo0004Ool0
1@00Oomoogoo00001Goo00<007oo000037oo0005Ool01000Oomoo`0027oo00@007ooOol0009oo`04
001oogoo0005Ool00`00Oomoo`02Ool00`00Oomoo`07Ool40007Ool01@00Oomoogoo000027oo00<0
07oo000027oo00D007ooOomoo`0000Qoo`03001oo`0000Ioo`@000Moo`05001oogooOol00008Ool0
0`00Ool00008Ool00`00Oomoo`02Ool00`00Oomoo`08Ool200000goo001oo`03Ool01@00Oomoogoo
00001Goo00@007ooOol000Moo`03001oo`0000Moo`03001oo`0000Qoo`8000Qoo`04001oogoo0008
Ool00`00Ool00008Ool00`00Oomoo`04Ool20008Ool01000Oomoo`0017oo00D007ooOomoo`0000Eo
o`03001oo`0000aoo`001Goo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomoo`000Woo00@0
07ooOol000Aoo`03001oogoo00Moo`@000Moo`05001oogooOol00008Ool00`00Ool00008Ool01@00
Oomoogoo000027oo0`001Woo10001goo00D007ooOomoo`0000Qoo`03001oo`0000Qoo`03001oogoo
009oo`03001oogoo00Qoo`800003Ool007oo00=oo`05001oogooOol00005Ool01000Oomoo`001goo
00<007oo00001goo0`0027oo0P0027oo00@007ooOol000Qoo`03001oo`0000Qoo`03001oogoo00Ao
o`03001oogoo00Moo`04001oogoo0004Ool01@00Oomoogoo00001Goo00<007oo000037oo0006Ool2
000:Ool20004Ool20004Ool20005Ool00`00Oomoo`07Ool30008Ool01@00Oomoogoo000027oo00<0
07oo000027oo00D007ooOomoo`00015oo`@000Moo`80009oo`03001oogoo00Ioo`03001oo`0000Qo
o`03001oogoo009oo`03001oogoo00Qoo`800003Ool007oo00=oo`05001oogooOol00005Ool01000
Oomoo`001goo00<007oo00004Woo0P0027oo00@007ooOol000Qoo`<000Uoo`03001oogoo00=oo`03
001oogoo00Moo`@000Aoo`05001oogooOol00005Ool00`00Ool0000<Ool002Eoo`03001oogoo00Mo
o`<000Qoo`05001oogooOol00008Ool00`00Ool00008Ool01@00Oomoogoo00004Goo100027oo00@0
07ooOol000Qoo`03001oo`0000Qoo`03001oogoo009oo`03001oogoo00Qoo`800003Ool007oo00=o
o`80009oo`03001oogoo00=oo`04001oogoo0007Ool00`00Ool0000BOol20008Ool01000Oomoo`00
2Goo0P002Goo00<007ooOol00goo00<007ooOol03goo00D007ooOomoo`0000Eoo`03001oo`0000ao
o`009Goo00<007ooOol01goo0`0027oo00D007ooOomoo`0000Qoo`<000Qoo`05001oogooOol0000A
Ool40008Ool01000Oomoo`0027oo0`0027oo00<007ooOol00Woo00<007ooOol02Goo0`001Goo00@0
07ooOol000Eoo`04001oogoo0007Ool00`00Ool0000BOol20008Ool01000Oomoo`002Goo0P002Goo
00<007ooOol00goo00<007ooOol03goo00D007ooOomoo`0000Eoo`03001oo`0000aoo`009Goo0P00
27oo0`0027oo0P000Woo00<007ooOol04Goo0P000Woo00<007ooOol03goo100027oo00@007ooOol0
01=oo`03001oogoo009oo`03001oogoo015oo`04001oogoo0005Ool40007Ool00`00Ool0000BOol2
0008Ool01000Oomoo`002Goo0P002Goo00<007ooOol00goo00<007ooOol03goo0P000Woo00<007oo
Ool00goo00<007oo000037oo000UOol00`00Oomoo`07Ool30008Ool300000goo001oo`0COol01000
Oomoo`004Goo0P002Woo00@007ooOol001=oo`03001oogoo009oo`03001oogoo015oo`04001oogoo
000@Ool00`00Ool0000BOol20008Ool200000goo001oo`08Ool20009Ool00`00Oomoo`03Ool00`00
Oomoo`0@Ool01000Oomoo`001Goo00<007oo000037oo000UOol00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Ool0000DOol01000Oomoo`004Goo0P002Woo00@007ooOol001=oo`03001oogoo009oo`03
001oogoo015oo`04001oogoo000@Ool00`00Ool0000BOol20008Ool01000Oomoo`002Goo0P002Goo
00<007ooOol00goo00<007ooOol047oo00@007ooOol000Eoo`03001oo`0000aoo`009Goo00<007oo
Ool02Goo00<007ooOol027oo00<007oo000057oo00@007ooOol0015oo`8000Yoo`04001oogoo000C
Ool20003Ool00`00Oomoo`0AOol01000Oomoo`0047oo00<007oo00004Woo0P0027oo00@007ooOol0
00Uoo`8000Uoo`03001oogoo00=oo`03001oogoo011oo`04001oogoo0005Ool00`00Ool0000<Ool0
02Eoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oo`0001Aoo`04001oogoo000AOol2000:Ool0
1000Oomoo`0057oo00D007ooOomoo`0001=oo`04001oogoo000@Ool00`00Ool0000BOol20008Ool0
1000Oomoo`002Goo0P002Goo00<007ooOol00goo00<007ooOol047oo00@007ooOol000Eoo`03001o
o`0000aoo`009Goo00<007ooOol02Goo0P002Goo00<007oo000057oo00@007ooOol001eoo`04001o
ogoo000DOol01@00Oomoogoo00004goo00@007ooOol0011oo`03001oo`00019oo`8000Qoo`04001o
ogoo0009Ool20009Ool00`00Oomoo`02Ool00`00Oomoo`0AOol01000Oomoo`001Goo00@007oo0000
00]oo`009Goo0P005Goo00<007oo000057oo00@007ooOol001eoo`04001oogoo000DOol01@00Oomo
ogoo00004goo00@007ooOol0011oo`03001oo`00019oo`8000Qoo`04001oogoo0009Ool20009Ool0
0`00Oomoo`02Ool00`00Oomoo`0AOol01000Oomoo`001Goo00<007oo000037oo000UOol00`00Oomo
o`0DOol00`00Ool0000DOol01000Oomoo`007Goo00@007ooOol001Aoo`03001oo`00008001=oo`@0
011oo`<0019oo`8000Qoo`04001oogoo0009Ool20009Ool00`00Oomoo`02Ool00`00Oomoo`0AOol0
1000Oomoo`001Goo00<007oo000037oo000UOol00`00Oomoo`0DOol00`00Ool0000DOol01000Oomo
o`007Goo00@007ooOol001Aoo`D001=oo`80035oo`04001oogoo0009Ool20009Ool00`00Ool00002
Ool00`00Oomoo`0AOol01000Oomoo`001Goo00<007oo000037oo000UOol00`00Oomoo`0DOol00`00
Ool0000DOol01000Oomoo`007Goo00@007ooOol001Aoo`800003Ool0000001=oo`80035oo`04001o
ogoo0009Ool20009Ool00`00Ool00002Ool00`00Oomoo`0AOol01000Oomoo`001Goo00<007oo0000
37oo000UOol00`00Oomoo`0DOol00`00Ool0000DOol01000Oomoo`007Goo0P0000=oo`00Ool04goo
0P0000=oo`0000004goo0P00<Goo00@007ooOol000Uoo`8000Uoo`<0009oo`03001oogoo015oo`@0
00Eoo`03001oo`0000aoo`009Goo00<007ooOol057oo00<007oo000057oo00@007ooOol001ioo`03
001oo`0001Aoo`800003Ool0000001=oo`80035oo`04001oogoo0009Ool20009Ool30002Ool00`00
Oomoo`0AOol20007Ool00`00Ool0000<Ool002Eoo`8001Eoo`03001oo`0001Aoo`04001oogoo000N
Ool00`00Ool0000DOol200000goo0000000COol2000aOol01000Oomoo`002Goo0P002Woo0P000Woo
00<007ooOol04Goo0P001goo00<007oo000037oo000UOol00`00Oomoo`0DOol00`00Ool0000DOol0
1000Oomoo`007Woo00<007oo000057oo0P0000=oo`0000004goo0P00<Goo10002Goo0P002Woo0`00
00=oo`00Ool04Woo0P001goo00<007oo000037oo000UOol00`00Oomoo`0DOol00`00Ool0000DOol0
1000Oomoo`007Woo00<007oo000057oo0P0000=oo`0000004goo0P00<Goo10002Goo0P002Woo1P00
4Woo0P001goo0`0037oo000UOol00`00Oomoo`0DOol00`00Ool0000DOol01000Oomoo`007Woo00<0
07oo000057oo0P0000=oo`0000004goo0P00<Goo10002Goo0P002Woo0P005Woo0P0027oo0P0037oo
000UOol00`00Oomoo`0DOol00`00Ool0000DOol01000Oomoo`007Woo00<007oo000057oo0P0000=o
o`0000004goo0P00<goo0P002Goo0P002Woo0P005Woo0P0027oo0P0037oo000UOol00`00Oomoo`0D
Ool00`00Ool0000DOol01000Oomoo`007Woo00<007oo000057oo0P0000=oo`0000004goo0P00<goo
0P002Goo0P002Woo0P005Woo0P0027oo0P0037oo000UOol2000EOol00`00Ool0000DOol01000Oomo
o`007goo0P0057oo0P0000=oo`0000004goo0P00<goo0P002Goo0P002Woo0P005Woo0P0027oo0P00
37oo000UOol00`00Oomoo`0DOol00`00Ool0000DOol01000Oomoo`007goo0P005Goo00@007oo0000
01=oo`8003=oo`8001Eoo`8001Ioo`8000Qoo`8000aoo`009Goo00<007ooOol057oo00<007oo0000
57oo00@007ooOol001moo`8001Eoo`04001oo`00000COol2000cOol2000EOol2000FOol20008Ool2
000<Ool002Eoo`03001oogoo01Aoo`03001oo`0001Aoo`04001oogoo000OOol2000EOol01000Ool0
00004goo0P00<goo0P005Goo0P005Woo0P0027oo0P0037oo000UOol00`00Oomoo`0DOol00`00Ool0
000DOol4000OOol2000EOol01000Ool000004goo0P00<goo0P005Goo0P005Woo0P0027oo0P0037oo
0006Ool20004Ool00`00Oomoo`03Ool20004Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`0DOol0
0`00Ool0001>Ool01000Ool000004goo0P00<goo0P005Goo00<007ooOol05Goo0P0027oo0P0037oo
0005Ool01000Oomoo`0027oo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`03Ool00`00
Oomoo`0DOol00`00Ool0001>Ool01000Ool00000B7oo0P005Goo00<007ooOol05Goo0P0027oo0P00
37oo0005Ool01000Oomoo`0027oo00@007ooOol0009oo`05001oogoo001oo`050004Ool2000EOol3
001>Ool01000Ool00000B7oo0P005Goo00<007ooOol05Goo0P0027oo0P0037oo0005Ool01000Oomo
o`0027oo00@007ooOol0009oo`06001oogoo001oo`000Woo00<007ooOol00goo00<007ooOol0IGoo
00@007oo000005moo`03001oogoo01moo`8000aoo`001Goo00@007ooOol000Qoo`04001oogoo0002
Ool01000Oomoo`000Woo00<007oo00001Goo00<007ooOol0IGoo00@007oo000005moo`03001oogoo
02eoo`001Goo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomoo`000goo0P001Goo00<007oo
Ool0IGoo00@007oo000005moo`03001oogoo02eoo`001Woo0P002Woo0P0017oo0P001Goo00<007oo
Ool00goo00<007ooOol0IGoo00@007oo000005moo`03001oogoo02eoo`009Goo00<007ooOol0IGoo
00@007oo000005moo`03001oogoo02eoo`009Goo0P00IWoo00@007oo000005moo`03001oogoo02eo
o`009Goo00<007ooOol0IGoo00@007oo000005moo`03001oogoo02eoo`009Goo00<007ooOol0IGoo
00@007oo000005moo`03001oogoo02eoo`009Goo00<007ooOol0Igoo0P00Ggoo00<007ooOol0;Goo
000UOol00`00Oomoo`1WOol2001OOol00`00Oomoo`0]Ool002Eoo`03001oogoo06Moo`8005moo`03
001oogoo02eoo`009Goo0P00J7oo0P00Sgoo000UOol00`00Oomoo`1WOol2002?Ool002Eoo`03001o
ogoo06Moo`8008moo`009Goo00<007ooOol0Igoo0P00Sgoo000UOol00`00Oomoo`1WOol2002?Ool0
02Eoo`03001oogoo06Moo`8008moo`009Goo0P00J7oo0P00Sgoo000UOol00`00Oomoo`1WOol2002?
Ool002Eoo`03001oogoo06Moo`8008moo`009Goo00<007ooOol0Igoo0P00Sgoo000UOol00`00Oomo
o`1WOol2002?Ool002Eoo`03001oogoo06Moo`8008moo`009Goo00<007ooOol0n7oo000UOol2003i
Ool002Eoo`03001oogoo0?Qoo`009Goo00<007ooOol0n7oo003oOolQOol00?moob5oo`00ogoo8Goo
003oOolQOol00?moob5oo`00SWoo0P000Woo0P000Woo0P0000Aoo`00Oomoo`800006Ool00000Ool0
07oo0P0000Aoo`00000007Ioo`00Sgoo00@007ooOol0009oo`04001oogoo0002Ool02P00Oomoo`00
Ool007oo001oo`001Goo00<007ooOol0Lgoo002?Ool40002Ool01000Oomoo`000goo0`0000Ioo`00
Ool007oo0003Ool2001fOol008moo`04001oogoo0002Ool01000Oomoo`001Goo00L007oo001oo`00
Ool00002Ool00`00Oomoo`1fOol0091oo`03001oo`0000=oo`<000=oo`80009oo`800003Ool007oo
00=oo`<007Eoo`00Sgoo0`001Woo00<007ooOol0QGoo002GOol20027Ool00001\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {855.625, 634.438}} -> {-7.48304, \
0.0158663, 0.0667464, 3.20261*^-5}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0597482 0.0133493 4.53751 [
[.17318 .00085 -9 -9 ]
[.17318 .00085 9 0 ]
[.32255 .00085 -3 -9 ]
[.32255 .00085 3 0 ]
[.47192 .00085 -9 -9 ]
[.47192 .00085 9 0 ]
[.62129 .00085 -6 -9 ]
[.62129 .00085 6 0 ]
[.77066 .00085 -12 -9 ]
[.77066 .00085 12 0 ]
[.92003 .00085 -6 -9 ]
[.92003 .00085 6 0 ]
[.01131 .1041 -24 -4.5 ]
[.01131 .1041 0 4.5 ]
[.01131 .19485 -24 -4.5 ]
[.01131 .19485 0 4.5 ]
[.01131 .2856 -24 -4.5 ]
[.01131 .2856 0 4.5 ]
[.01131 .37635 -24 -4.5 ]
[.01131 .37635 0 4.5 ]
[.01131 .4671 -18 -4.5 ]
[.01131 .4671 0 4.5 ]
[.01131 .55785 -24 -4.5 ]
[.01131 .55785 0 4.5 ]
[.5 .63053 -41 0 ]
[.5 .63053 41 10.125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17318 .01335 m
.17318 .0196 L
s
[(2.5)] .17318 .00085 0 1 Mshowa
.32255 .01335 m
.32255 .0196 L
s
[(5)] .32255 .00085 0 1 Mshowa
.47192 .01335 m
.47192 .0196 L
s
[(7.5)] .47192 .00085 0 1 Mshowa
.62129 .01335 m
.62129 .0196 L
s
[(10)] .62129 .00085 0 1 Mshowa
.77066 .01335 m
.77066 .0196 L
s
[(12.5)] .77066 .00085 0 1 Mshowa
.92003 .01335 m
.92003 .0196 L
s
[(15)] .92003 .00085 0 1 Mshowa
.125 Mabswid
.05368 .01335 m
.05368 .0171 L
s
.08356 .01335 m
.08356 .0171 L
s
.11343 .01335 m
.11343 .0171 L
s
.14331 .01335 m
.14331 .0171 L
s
.20305 .01335 m
.20305 .0171 L
s
.23293 .01335 m
.23293 .0171 L
s
.2628 .01335 m
.2628 .0171 L
s
.29268 .01335 m
.29268 .0171 L
s
.35242 .01335 m
.35242 .0171 L
s
.3823 .01335 m
.3823 .0171 L
s
.41217 .01335 m
.41217 .0171 L
s
.44205 .01335 m
.44205 .0171 L
s
.5018 .01335 m
.5018 .0171 L
s
.53167 .01335 m
.53167 .0171 L
s
.56154 .01335 m
.56154 .0171 L
s
.59142 .01335 m
.59142 .0171 L
s
.65117 .01335 m
.65117 .0171 L
s
.68104 .01335 m
.68104 .0171 L
s
.71091 .01335 m
.71091 .0171 L
s
.74079 .01335 m
.74079 .0171 L
s
.80054 .01335 m
.80054 .0171 L
s
.83041 .01335 m
.83041 .0171 L
s
.86028 .01335 m
.86028 .0171 L
s
.89016 .01335 m
.89016 .0171 L
s
.94991 .01335 m
.94991 .0171 L
s
.97978 .01335 m
.97978 .0171 L
s
.25 Mabswid
0 .01335 m
1 .01335 L
s
.02381 .1041 m
.03006 .1041 L
s
[(0.02)] .01131 .1041 1 0 Mshowa
.02381 .19485 m
.03006 .19485 L
s
[(0.04)] .01131 .19485 1 0 Mshowa
.02381 .2856 m
.03006 .2856 L
s
[(0.06)] .01131 .2856 1 0 Mshowa
.02381 .37635 m
.03006 .37635 L
s
[(0.08)] .01131 .37635 1 0 Mshowa
.02381 .4671 m
.03006 .4671 L
s
[(0.1)] .01131 .4671 1 0 Mshowa
.02381 .55785 m
.03006 .55785 L
s
[(0.12)] .01131 .55785 1 0 Mshowa
.125 Mabswid
.02381 .03604 m
.02756 .03604 L
s
.02381 .05872 m
.02756 .05872 L
s
.02381 .08141 m
.02756 .08141 L
s
.02381 .12679 m
.02756 .12679 L
s
.02381 .14947 m
.02756 .14947 L
s
.02381 .17216 m
.02756 .17216 L
s
.02381 .21754 m
.02756 .21754 L
s
.02381 .24022 m
.02756 .24022 L
s
.02381 .26291 m
.02756 .26291 L
s
.02381 .30829 m
.02756 .30829 L
s
.02381 .33098 m
.02756 .33098 L
s
.02381 .35366 m
.02756 .35366 L
s
.02381 .39904 m
.02756 .39904 L
s
.02381 .42173 m
.02756 .42173 L
s
.02381 .44441 m
.02756 .44441 L
s
.02381 .48979 m
.02756 .48979 L
s
.02381 .51248 m
.02756 .51248 L
s
.02381 .53516 m
.02756 .53516 L
s
.02381 .58054 m
.02756 .58054 L
s
.02381 .60323 m
.02756 .60323 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.5 .63053 -102 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Extrapolation) show
141.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.02381 .01479 m
.02383 .01472 L
.02385 .01558 L
.02388 .01911 L
.02395 .03297 L
.02421 .05539 L
.02476 .0855 L
.02571 .10186 L
.02688 .15532 L
.02875 .18459 L
.031 .2789 L
.0345 .38811 L
.03943 .44642 L
.04514 .37301 L
.04987 .32547 L
.05398 .31864 L
.058 .46279 L
.06392 .43195 L
.06943 .45783 L
.07529 .45652 L
.08112 .38293 L
.08599 .38293 L
.09085 .31271 L
.0948 .31444 L
.09876 .30948 L
.10266 .28644 L
.10626 .33495 L
.11049 .40289 L
.11562 .42039 L
.12098 .43119 L
.12648 .48924 L
.13275 .30772 L
.13662 .30772 L
.1405 .27643 L
.14396 .25929 L
.1472 .27578 L
.15066 .27175 L
.15406 .37687 L
.15885 .32294 L
.16292 .39163 L
.16791 .43679 L
.17348 .4618 L
.17939 .38285 L
.18425 .31101 L
.18817 .28431 L
.19174 .32494 L
.19584 .29268 L
.19952 .43707 L
.2051 .42103 L
.21047 .41111 L
Mistroke
.21571 .42994 L
.22119 .46289 L
.22711 .33429 L
.23134 .33429 L
.23556 .28109 L
.23909 .25734 L
.2423 .2586 L
.24553 .37361 L
.25027 .48673 L
.25651 .54657 L
.26353 .56834 L
.27084 .40135 L
.27594 .40135 L
.28105 .38473 L
.28594 .35284 L
.29041 .33262 L
.29462 .44799 L
.30034 .45025 L
.30609 .47824 L
.31222 .344 L
.31657 .34129 L
.32089 .30723 L
.32476 .29523 L
.32847 .42832 L
.33393 .38673 L
.33885 .4466 L
.34456 .42137 L
.34993 .43881 L
.35553 .47318 L
.36159 .30922 L
.36548 .30475 L
.36932 .27367 L
.37275 .26438 L
.37605 .3829 L
.38092 .3761 L
.38569 .54737 L
.39273 .53323 L
.39957 .56245 L
.4068 .36191 L
.41139 .36191 L
.41598 .34449 L
.42034 .31812 L
.42435 .29996 L
.42813 .4534 L
.43392 .41736 L
.43924 .40207 L
.44436 .40939 L
.44958 .43698 L
.45515 .4505 L
.46091 .43533 L
Mistroke
.46647 .31661 L
.47046 .31661 L
.47445 .26684 L
.47779 .23448 L
.4807 .23998 L
.48369 .35067 L
.48813 .37033 L
.49283 .4327 L
.49835 .4695 L
.50436 .48714 L
.5106 .42297 L
.51599 .38221 L
.52085 .40647 L
.52602 .58786 L
.53359 .56018 L
.54079 .5289 L
.54758 .42736 L
.55303 .3719 L
.55775 .36513 L
.56238 .53122 L
.5692 .51216 L
.57577 .50131 L
.58219 .51432 L
.58879 .41468 L
.59408 .35972 L
.59864 .37112 L
.60335 .51977 L
.61002 .60332 L
.61778 .49407 L
.62411 .45544 L
.62994 .35421 L
.63442 .35064 L
.63887 .3544 L
.64336 .3362 L
.64761 .50678 L
.6541 .47112 L
.66013 .50845 L
.66665 .41989 L
.672 .33532 L
.67624 .31152 L
.68017 .34936 L
.6846 .3207 L
.68864 .48526 L
.69486 .45088 L
.70062 .47452 L
.70669 .34132 L
.71101 .34132 L
.71533 .32358 L
.71941 .29266 L
.72309 .41533 L
Mistroke
.72838 .3868 L
.7333 .54167 L
.74026 .53088 L
.74707 .56453 L
.75433 .3685 L
.75901 .34328 L
.76335 .2843 L
.76692 .25951 L
.77016 .29187 L
.77383 .28199 L
.77736 .32395 L
.78145 .38908 L
.7864 .42441 L
.79181 .43705 L
.79739 .46698 L
.80337 .35948 L
.80792 .30691 L
.81179 .28297 L
.81534 .41027 L
.82057 .38522 L
.82546 .44811 L
.83119 .40669 L
.83637 .39962 L
.84145 .41191 L
.8467 .42871 L
.85217 .4362 L
.85774 .43313 L
.86327 .43797 L
.86886 .26715 L
.8722 .26332 L
.87549 .23612 L
.87842 .22888 L
.88126 .30238 L
.88507 .40475 L
.89022 .41632 L
.89553 .46852 L
.90152 .49231 L
.90783 .4673 L
.91381 .39684 L
.91886 .51526 L
.92546 .48024 L
.93161 .54612 L
.93863 .54513 L
.94563 .44086 L
.95126 .38742 L
.95619 .39334 L
.96119 .35514 L
.96569 .53814 L
.9726 .28606 L
.97619 .28606 L
Mistroke
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool0041oo`@000=oo`03001oogoo009oo`<001aoo`<001ioo`03001oogoo00=oo`03001oogoo009o
o`<001Uoo`@000=oo`8001Ioo`@0009oo`@000=oo`03001oogoo009oo`<001Moo`@0009oo`<001Uo
o`00@7oo00<007ooOol037oo00<007ooOol077oo00<007ooOol06goo00<007ooOol02goo00<007oo
Ool067oo00D007ooOomoo`00009oo`03001oogoo01Eoo`05001oogooOol0000>Ool00`00Oomoo`0F
Ool00`00Oomoo`04Ool00`00Oomoo`0FOol0045oo`03001oogoo00]oo`03001oogoo01aoo`03001o
ogoo01aoo`03001oogoo00Yoo`03001oogoo01Qoo`05001oogooOol00002Ool00`00Oomoo`0EOol0
0`00Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`0FOol00`00Oomoo`04Ool00`00Oomoo`0FOol0
049oo`03001oogoo00Moo`<001aoo`<001moo`03001oogoo00Moo`<001]oo`05001oogooOol00002
Ool00`00Oomoo`0EOol00`00Oomoo`03Ool00`00Oomoo`07Ool3000IOol01000Oomoogoo0`006Goo
0013Ool00`00Oomoo`06Ool00`00Oomoo`0LOol00`00Oomoo`0POol00`00Oomoo`06Ool00`00Oomo
o`0KOol01@00Oomoogoo00000Woo00<007ooOol05Goo00<007ooOol017oo00<007ooOol01Woo00<0
07ooOol06Goo00D007ooOomoo`0001]oo`00@7oo00@007ooOol000Qoo`03001oogoo01aoo`03001o
ogoo01eoo`04001oogoo0008Ool00`00Oomoo`0IOol30003Ool01000Oomoo`005Goo0`000goo00@0
07ooOol000Qoo`03001oogoo01Moo`<000=oo`03001oogoo01Uoo`008Woo00<007ooOol077oo0P00
2Goo10006goo100077oo100027oo10006Woo00<007ooOol00Woo0P0067oo00<007ooOol00Woo0P00
2Goo100067oo00@007ooOomoo`@001Qoo`008Woo00<007ooOol0ngoo000ROol00`00Oomoo`3kOol0
029oo`03001oogoo0?]oo`0077ooo00027oo000ROol00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`0;Ool0029oo`03001oogoo0?]oo`008Woo00<007ooOol0ngoo000ROol00`00Oomoo`3kOol0
029oo`800?aoo`008Woo00<007ooOol0ngoo000ROol00`00Oomoo`3kOol0029oo`03001oogoo0?]o
o`008Woo00<007ooOol0ngoo000ROol00`00Oomoo`3kOol0029oo`800?aoo`008Woo00<007ooOol0
ngoo000ROol00`00Oomoo`3kOol0029oo`03001oogoo0?]oo`008Woo00<007ooOol0ngoo000ROol0
0`00Oomoo`3kOol0029oo`800?aoo`008Woo00<007ooOol0ngoo000ROol00`00Oomoo`3kOol000Uo
o`8000Aoo`03001oogoo00=oo`8000=oo`@000Aoo`03001oogoo0?]oo`0027oo00@007ooOol000Qo
o`04001oogoo0002Ool00`00Oomoo`05Ool2003lOol000Qoo`04001oogoo0008Ool01000Oomoo`00
0goo00<007ooOol017oo0`00ngoo0008Ool01000Oomoo`0027oo00@007ooOol000Aoo`03001oogoo
00=oo`800?aoo`0027oo00@007ooOol000Qoo`04001oogoo0005Ool00`00Oomoo`02Ool2003lOol0
00Qoo`04001oogoo0008Ool01000Oomoo`000Woo00@007ooOol000Aoo`800?aoo`002Goo0P002Woo
0P0017oo0P001Goo0P00o7oo000ROol2003lOol0029oo`800?aoo`008Woo0P00o7oo000ROol2003l
Ool0029oo`800?aoo`008Woo0P00o7oo000ROol2003lOol0029oo`800?aoo`008Woo0P00o7oo000R
Ool2003lOol0029oo`800?aoo`008Woo0P00o7oo000ROol2003lOol0029oo`800?aoo`008Woo0P00
o7oo000ROol2003lOol000Uoo`8000Aoo`03001oogoo00=oo`8000Eoo`03001oogoo00=oo`800?ao
o`0027oo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomoo`03Ool2003lOol000Qoo`04001o
ogoo0008Ool01@00Oomoo`00Ool01@0017oo0`00ngoo0008Ool01000Oomoo`0027oo00H007ooOol0
07oo0002Ool00`00Oomoo`03Ool2003lOol000Qoo`04001oogoo0008Ool01000Oomoo`000Woo00<0
07oo00001Goo0P00o7oo0008Ool01000Oomoo`0027oo00@007ooOol000=oo`8000Eoo`800?aoo`00
2Goo0P002Woo0P001Goo00<007ooOol00goo0P00o7oo000ROol2003lOol0029oo`800?aoo`008Woo
0P00o7oo000ROol2003lOol0029oo`800=Aoo`03001oogoo02Eoo`008Woo00<007oo0000Kgoo00<0
07ooOol0HGoo00<007ooOol09Goo000ROol00`00Ool0001_Ool2001ROol00`00Oomoo`0UOol0029o
o`<006moo`80069oo`03001oogoo02Eoo`008Woo00<007oo0000Kgoo0P00HWoo00<007ooOol09Goo
000ROol00`00Ool0001_Ool2001ROol00`00Oomoo`0UOol0029oo`03001oo`0006ioo`03001oo`00
065oo`8002Moo`008Woo00<007oo00006goo00<007ooOol05Goo0P00>Goo00<007oo0000AWoo00<0
07ooOol067oo0P009goo000ROol3000KOol00`00Oomoo`0EOol2000iOol00`00Ool00016Ool00`00
Oomoo`0HOol2000WOol0029oo`03001oo`0001]oo`03001oogoo01Eoo`80021oo`03001oogoo01Io
o`03001oo`0004Ioo`03001oogoo01Moo`03001oo`0002Moo`008Woo00<007oo00006Woo00@007oo
000001Eoo`80021oo`03001oogoo01Ioo`03001oo`0004Ioo`03001oogoo01Moo`04001oogoo000V
Ool0029oo`03001oo`0001Yoo`04001oo`00000DOol00`00Ool0000OOol2000HOol00`00Ool00016
Ool00`00Oomoo`0GOol01000Oomoo`009Woo0009Ool20004Ool00`00Oomoo`03Ool20004Ool20005
Ool00`00Ool0000JOol01000Oomoo`0057oo00<007oo00007goo0P0067oo00<007oo0000AWoo0P00
67oo00@007ooOol002Ioo`0027oo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomoo`0017oo
00<007oo00006Woo00@007ooOol001Aoo`03001oo`0001moo`8001Qoo`03001oo`0004Ioo`<000Uo
o`03001oogoo00]oo`04001oogoo000VOol000Qoo`04001oogoo0008Ool01000Oomoo`000Woo00@0
07ooOol000Aoo`<0015oo`03001oogoo00Ioo`04001oogoo0008Ool00`00Oomoo`09Ool00`00Ool0
000OOol2000HOol00`00Ool00016Ool30009Ool00`00Oomoo`0;Ool01000Oomoo`005Woo0P003Woo
0008Ool01000Oomoo`0027oo00@007ooOol0009oo`<000Eoo`03001oo`00015oo`03001oogoo00Io
o`04001oogoo0008Ool00`00Oomoo`09Ool00`00Ool0000OOol2000HOol00`00Ool00016Ool30009
Ool00`00Oomoo`0;Ool01000Oomoo`005Woo00<007ooOol03Goo0008Ool01000Oomoo`0027oo00@0
07ooOol0009oo`03001oogoo00Eoo`03001oo`00015oo`03001oogoo00Ioo`04001oogoo0008Ool0
0`00Ool00009Ool00`00Ool0000DOol00`00Oomoo`07Ool00`00Ool0000GOol01000Oomoo`00>goo
00<007ooOol027oo00<007oo00002Goo00<007ooOol02goo00@007ooOol001Ioo`03001oogoo00eo
o`0027oo00@007ooOol000Qoo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Ool0000AOol00`00
Oomoo`06Ool01000Oomoo`0027oo00<007oo00002Goo00<007oo000057oo00<007ooOol01goo00<0
07oo00005goo00@007ooOol003]oo`03001oogoo00Qoo`03001oo`0000Qoo`8000eoo`04001oogoo
000FOol00`00Oomoo`0=Ool000Uoo`8000Yoo`8000Aoo`<000Aoo`03001oo`00011oo`8000Qoo`04
001oogoo0007Ool200000goo001oo`08Ool00`00Ool0000COol20009Ool00`00Ool0000<Ool00`00
Oomoo`08Ool01000Oomoo`00>goo00<007ooOol01goo00@007ooOol000Qoo`8000eoo`04001oogoo
000FOol00`00Oomoo`0=Ool0029oo`03001oo`00011oo`8000Moo`80009oo`03001oogoo00Eoo`80
0003Ool007oo00Qoo`03001oo`0001=oo`8000Uoo`03001oo`0000aoo`03001oogoo00Qoo`04001o
ogoo000kOol00`00Oomoo`07Ool01@00Oomoogoo00001goo0P003Goo00@007ooOol001Ioo`03001o
ogoo00eoo`008Woo0`0047oo0P001goo00D007ooOomoo`0000Moo`04001oo`000008Ool01000Oomo
o`004goo0P0027oo00@007ooOol000aoo`03001oogoo00Qoo`04001oogoo000`Ool00`00Oomoo`07
Ool20009Ool01@00Oomoogoo00001goo0P003Goo00@007ooOol001Ioo`03001oogoo00eoo`008Woo
00<007oo00003Woo0P000Woo00<007ooOol017oo00D007ooOomoo`0000Moo`04001oo`000008Ool0
1000Oomoo`004goo0P0027oo00@007ooOol000]oo`8000Yoo`04001oogoo000`Ool00`00Oomoo`07
Ool20009Ool01@00Oomoogoo00001goo0P003Goo00@007ooOol001Ioo`03001oogoo00eoo`008Woo
00<007oo00001Goo00<007ooOol01Woo00D007ooOomoo`0000Ioo`05001oogooOol00007Ool01000
Ool0000027oo00D007ooOomoo`00019oo`8000Qoo`04001oogoo000;Ool20009Ool20002Ool00`00
Oomoo`0^Ool00`00Oomoo`07Ool20009Ool01@00Oomoogoo00001goo0P003Goo00@007ooOol001Io
o`03001oogoo00eoo`008Woo00<007oo00001Goo00<007ooOol01Woo00D007ooOomoo`0000Ioo`07
001oogooOol007oo00001Goo00@007oo000000Qoo`05001oogooOol0000BOol20008Ool01000Oomo
o`002goo0P002Goo00D007ooOomoo`00031oo`03001oo`0000Moo`8000Uoo`05001oogooOol00007
Ool2000=Ool01000Oomoo`005Woo00<007ooOol03Goo000ROol00`00Ool00004Ool20008Ool01@00
Oomoogoo00001Woo00<007ooOol00Woo0P001Goo00@007oo000000Qoo`05001oogooOol0000AOol0
0`00Ool00008Ool01@00Oomoogoo00002Woo0P002Goo00D007ooOomoo`0002moo`800003Ool007oo
00Ioo`8000Uoo`05001oogooOol00007Ool2000=Ool01000Oomoo`005Woo00<007ooOol03Goo000R
Ool30004Ool20008Ool01@00Oomoogoo00001Woo00<007ooOol00Woo0P001Goo00@007ooOol000Qo
o`05001oogooOol0000AOol00`00Ool00008Ool01@00Oomoogoo00002Woo0P002Goo00D007ooOomo
o`0002moo`800003Ool007oo00Eoo`03001oo`0000Qoo`03001oogoo009oo`03001oogoo00Eoo`80
00eoo`04001oogoo000FOol00`00Oomoo`0=Ool0029oo`03001oo`0000Aoo`8000Qoo`05001oogoo
Ool00006Ool00`00Oomoo`02Ool20005Ool01000Oomoo`001goo0P000goo00<007ooOol027oo00<0
07ooOol017oo00<007oo000027oo00D007ooOomoo`0000Uoo`03001oo`0000Uoo`05001oogooOol0
000_Ool01000Ool000001Woo00<007oo000027oo00<007ooOol00Woo00<007ooOol017oo00<007oo
00003Goo00@007ooOol001Ioo`03001oogoo00eoo`008Woo00@007ooOol000=oo`8000Qoo`05001o
ogooOol00006Ool00`00Oomoo`02Ool20005Ool01000Oomoo`001goo00<007ooOol00Woo00<007oo
Ool027oo00<007ooOol017oo00<007oo000027oo00D007ooOomoo`0000Uoo`03001oo`0000Uoo`05
001oogooOol0000XOol00`00Oomoo`04Ool01000Ool000001Goo00@007ooOol000Qoo`03001oogoo
009oo`03001oogoo00Aoo`03001oo`0000eoo`04001oogoo000FOol00`00Oomoo`0=Ool0029oo`04
001oogoo0003Ool20008Ool01@00Oomoogoo00001Woo00<007ooOol00Woo0P001Goo00@007ooOol0
00Moo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo00Aoo`03001oo`0000Qoo`05001oogoo
Ool00009Ool00`00Ool00009Ool01@00Oomoogoo0000:7oo00<007ooOol017oo00@007oo000000Ao
o`80009oo`03001oogoo00Ioo`03001oogoo009oo`03001oogoo00Aoo`03001oo`0000eoo`04001o
ogoo000FOol00`00Oomoo`0=Ool0029oo`04001oogoo0003Ool20008Ool01@00Oomoogoo00001Woo
00<007ooOol00Woo0P001Goo00@007ooOol000Moo`03001oogoo009oo`03001oogoo00Moo`8000Eo
o`04001oogoo0008Ool01@00Oomoogoo00002Goo00<007oo00002Goo00D007ooOomoo`0002Moo`80
00Ioo`04001oo`000004Ool01@00Oomoogoo000027oo00<007ooOol00Woo00<007ooOol017oo00<0
07oo00003Goo00@007ooOol001Ioo`03001oogoo00eoo`008Woo00@007ooOol000=oo`8000Moo`03
001oogoo009oo`03001oogoo00Aoo`03001oogoo009oo`8000Aoo`05001oogooOol00007Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool20005Ool01000Oomoo`0027oo00D007ooOomoo`0000Uoo`03001o
o`0000Uoo`05001oogooOol0000UOol01000Ool000001Woo00@007oo000000Aoo`05001oogooOol0
0008Ool00`00Oomoo`02Ool00`00Oomoo`04Ool01000Oomoo`0037oo00@007ooOol001Eoo`03001o
ogoo00ioo`008Woo0P0000Moo`00Oomoo`00Ool00007Ool00`00Oomoo`02Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool20004Ool01@00Oomoogoo00001goo00<007ooOol00Woo00<007ooOol01goo0P00
1Goo00@007ooOol000Moo`03001oogoo009oo`03001oogoo00Ioo`04001oogoo0009Ool01@00Oomo
ogoo000097oo00D007oo001oo`0000Ioo`04001oogoo0004Ool01@00Oomoogoo000027oo00<007oo
Ool00Woo00<007ooOol017oo00@007ooOol000]oo`05001oogooOol0000COol00`00Ool0000@Ool0
029oo`04001oogoo0002Ool00`00Ool00007Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomo
o`03Ool00`00Ool00003Ool01@00Oomoogoo00001goo00<007ooOol00Woo00<007ooOol01goo0P00
1Goo00@007ooOol000Moo`03001oogoo009oo`03001oogoo00Ioo`04001oogoo0009Ool00`00Oomo
o`02Ool00`00Oomoo`0QOol01@00Oomoogoo00001Goo00D007ooOomoo`0000Aoo`05001oogooOol0
0007Ool00`00Oomoo`03Ool00`00Oomoo`04Ool01000Oomoo`002goo00<007ooOol00Woo00<007oo
Ool047oo00<007oo000047oo000ROol01000Oomoo`000Woo00<007oo00001goo00<007ooOol00Woo
00<007ooOol00goo00<007ooOol00goo00<007oo00000goo00D007ooOomoo`0000Moo`03001oogoo
009oo`03001oogoo00Moo`8000Eoo`04001oogoo0007Ool00`00Oomoo`02Ool00`00Oomoo`04Ool2
0003Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`0HOol00`00Oomoo`06Ool01@00Oomo
ogoo00001Goo00D007ooOomoo`0000Aoo`05001oogooOol00007Ool00`00Oomoo`04Ool00`00Oomo
o`03Ool01000Oomoo`002goo00<007ooOol00Woo00<007ooOol047oo00<007oo000047oo000ROol0
1000Oomoo`000Woo00<007oo00001goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00goo
00<007oo00000goo00D007ooOomoo`0000Moo`03001oogoo009oo`03001oogoo00Moo`8000Eoo`05
001oogooOol00006Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`06Ool01@00Oomoogoo
00001Goo00D007ooOomoo`0000Aoo`05001oogooOol00007Ool00`00Oomoo`04Ool00`00Oomoo`03
Ool01000Oomoo`002goo00<007ooOol00Woo00<007ooOol047oo00<007oo000047oo0009Ool20004
Ool00`00Oomoo`03Ool20004Ool20005Ool01000Oomoo`000Woo00<007oo00001goo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol00goo00<007oo00000goo00<007ooOol00Woo00<007ooOol0
17oo00<007ooOol00Woo00<007ooOol01goo0P001Goo00D007ooOomoo`0000Ioo`03001oogoo009o
o`03001oogoo00Aoo`03001oogoo009oo`03001oogoo00Moo`03001oogoo00=oo`03001oogoo00io
o`03001oogoo00Ioo`8000Moo`05001oogooOol00005Ool01@00Oomoogoo000017oo00D007ooOomo
o`0000Moo`03001oogoo00Aoo`03001oogoo00=oo`04001oogoo000;Ool00`00Oomoo`02Ool00`00
Oomoo`0@Ool00`00Ool0000@Ool000Qoo`04001oogoo0008Ool01000Oomoo`000Woo00@007ooOol0
00Aoo`04001oogoo0002Ool00`00Ool00007Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool00`00Ool00003Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomo
o`06Ool00`00Ool00005Ool01@00Oomoogoo00001Woo00<007ooOol00Woo00<007ooOol017oo00<0
07ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol03Goo0P0027oo0P001goo00D0
07ooOomoo`0000Eoo`05001oogooOol00004Ool01@00Oomoogoo00001goo00<007ooOol017oo00<0
07ooOol00goo00@007ooOol000]oo`03001oogoo009oo`03001oogoo011oo`03001oo`00011oo`00
27oo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomoo`0017oo10000Woo00<007oo00001goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007oo00000goo00<007ooOol00Woo
00<007ooOol017oo00<007ooOol00Woo00<007ooOol01Woo00<007oo00001Goo00D007ooOomoo`00
00Ioo`03001oogoo009oo`8000Eoo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00Aoo`03
001oogoo00eoo`8000Qoo`8000Moo`05001oogooOol00005Ool01@00Oomoogoo000017oo00D007oo
Oomoo`0000Moo`03001oogoo00Aoo`03001oogoo00=oo`04001oogoo000;Ool00`00Oomoo`02Ool0
0`00Oomoo`0?Ool200000goo001oo`0?Ool000Qoo`04001oogoo0008Ool01000Oomoo`000goo0P00
1Goo00@007ooOol0009oo`03001oo`0000Ioo`8000Eoo`03001oogoo009oo`03001oogoo00Eoo`05
001oogooOol00004Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Ool00004
Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`03Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`06Ool20008Ool20007Ool01@00
Oomoogoo00001Goo00D007ooOomoo`0000Aoo`05001oogooOol00007Ool00`00Oomoo`04Ool00`00
Oomoo`03Ool01000Oomoo`002goo00<007ooOol00Woo00<007ooOol03goo0P0000=oo`00Ool03goo
0008Ool01000Oomoo`0027oo00@007ooOol0009oo`04001oogoo0004Ool01000Oomoo`000Woo00<0
07oo00001Woo00<007ooOol017oo00<007ooOol00Woo00<007ooOol01Goo00D007ooOomoo`0000Ao
o`03001oogoo00Aoo`03001oogoo009oo`03001oogoo00Ioo`03001oo`0000Aoo`03001oogoo009o
o`8000Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo00Ioo`8000Qoo`8000Moo`05001oogooOol00005Ool0
1@00Oomoogoo000017oo00L007ooOomoo`00Ool00005Ool00`00Oomoo`04Ool00`00Oomoo`02Ool0
1000Oomoogoo0P002Woo00<007ooOol00Woo00<007ooOol03Woo0`0000=oo`00Ool03goo0008Ool0
1000Oomoo`0027oo00@007ooOol0009oo`04001oogoo0004Ool01000Oomoo`000Woo00<007oo0000
1Woo00<007ooOol017oo00<007ooOol00Woo00<007ooOol01Goo00D007ooOomoo`0000Aoo`03001o
ogoo00Aoo`03001oogoo009oo`03001oogoo00Ioo`03001oo`0000Aoo`03001oogoo009oo`8000Eo
o`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Aoo`03001oogoo00Ioo`8000Moo`03001oo`0000Moo`05001oogooOol00005Ool0
1@00Oomoogoo000017oo00L007ooOomoo`00Ool00005Ool00`00Oomoo`04Ool00`00Oomoo`02Ool0
1000Oomoogoo0P002Woo00<007ooOol00Woo00<007ooOol03Woo0`0000=oo`00Ool03goo0009Ool2
000:Ool20004Ool20005Ool01P00Oomoo`00Ool000=oo`03001oogoo00=oo`03001oogoo00Aoo`03
001oogoo009oo`03001oogoo00Eoo`05001oogooOol00004Ool00`00Oomoo`04Ool00`00Oomoo`02
Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00<007ooOol00Woo0P001Goo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol00goo
0P0027oo0P001goo00<007oo00001goo00D007ooOomoo`0000Eoo`05001oogooOol00004Ool01000
Oomoogoo0`001Goo00<007ooOol017oo00<007ooOol00Woo00@007ooOomoo`8000Yoo`03001oogoo
009oo`03001oogoo00ioo`<00003Ool007oo00moo`008Woo0P0000Aoo`00Ool000=oo`03001oogoo
00=oo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo00Eoo`05001oogooOol00004Ool00`00
Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00<007ooOol00Woo
0P001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol00goo00<007oo00001goo0P001goo00<007oo00001goo00D007ooOomoo`00
00Eoo`05001oogooOol00004Ool01000Oomoogoo0`001Goo00<007ooOol017oo00<007ooOol00Woo
00@007ooOomoo`8000Yoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo00Moo`05001oo`00
Ool0000@Ool0029oo`06001oogoo001oo`000goo00<007ooOol00Woo00<007ooOol01Goo00<007oo
Ool00Woo00<007ooOol01Goo00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo00=oo`8000Aoo`05001oogooOol00004Ool20005Ool00`00Oomoo`03Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool00`00Ool00005Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Ool00006
Ool00`00Ool00007Ool00`00Ool00007Ool01@00Oomoogoo000017oo00<007ooOol00Woo00<007oo
Ool00Woo00@007ooOomoo`<000Eoo`03001oogoo00Aoo`03001oogoo009oo`04001oogooOol20003
Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`06Ool01P00Oomoo`00
Ool0011oo`008Woo00H007ooOol007oo0003Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`00Oomo
o`02Ool00`00Oomoo`05Ool01@00Oomoogoo000017oo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00D007ooOomoo`0000Aoo`8000Eoo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo00=oo`04001oo`000004Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00
Ool00006Ool00`00Ool00007Ool00`00Ool00006Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`03Ool01@00Oomoogoo00000goo0`001Goo00<007ooOol017oo00<007ooOol00Woo00@007oo
Oomoo`80009oo`8000Ioo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo00Ioo`06001oogoo
001oo`0047oo000ROol01P00Oomoo`00Ool000=oo`03001oogoo009oo`03001oogoo00Eoo`03001o
ogoo009oo`03001oogoo00Eoo`05001oogooOol00004Ool01000Oomoo`000Woo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00D007ooOomoo`0000Aoo`8000Eoo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo00=oo`05001oo`00Ool00003Ool00`00Oomoo`05Ool00`00Oomoo`02
Ool00`00Ool00006Ool00`00Ool00007Ool00`00Ool00006Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007oo00001Goo00<007ooOol01Goo00D007ooOomo
o`0000=oo`80009oo`03001oo`0000Eoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo00Io
o`06001oogoo001oo`0047oo000ROol01P00Oomoo`00Ool000=oo`03001oogoo009oo`03001oogoo
00Ioo`05001oogooOol00007Ool01@00Oomoogoo000017oo00@007ooOol0009oo`03001oogoo00=o
o`03001oogoo00=oo`03001oogoo00=oo`05001oogooOol00004Ool20005Ool00`00Oomoo`03Ool0
0`00Oomoo`02Ool00`00Oomoo`04Ool20002Ool01@00Oomoogoo00001goo00D007ooOomoo`00009o
o`03001oogoo00Aoo`03001oo`0000Moo`03001oo`0000Ioo`03001oogoo009oo`03001oogoo009o
o`03001oogoo00=oo`04001oogoo0004Ool00`00Ool00005Ool00`00Oomoo`05Ool01@00Oomoogoo
000017oo00H007ooOol007oo0005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`06Ool0
1P00Oomoo`00Ool0011oo`008Woo00H007ooOol007oo0003Ool00`00Oomoo`02Ool00`00Oomoo`06
Ool01@00Oomoogoo000027oo00@007ooOol000Aoo`04001oo`000002Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007oo000017oo00<007ooOol00goo
00<007ooOol00Woo00<007ooOol017oo0P000Woo00D007ooOomoo`0000Moo`05001oogooOol00002
Ool00`00Oomoo`04Ool00`00Ool00007Ool00`00Ool00006Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool01000Oomoo`001Woo00<007ooOol00goo00<007ooOol01Goo00D007ooOomo
o`0000Aoo`03001oo`00009oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo00Ioo`06001oogoo001oo`0047oo000ROol20002Ool20003Ool00`00Oomoo`02Ool00`00Oomo
o`06Ool01@00Oomoogoo000027oo00@007ooOol000Aoo`07001oo`00Ool007oo00001Goo00<007oo
Ool00goo00<007ooOol00goo00D007ooOomoo`0000Aoo`05001oo`00Ool00002Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`04Ool20002Ool01@00Oomoogoo00001goo00D007ooOomoo`00
009oo`03001oogoo00Aoo`03001oo`0000Moo`03001oo`0000Ioo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00=oo`04001oogoo0006Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomo
ogoo00001Goo0P000Woo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
1Woo00H007ooOol007oo000@Ool0029oo`04001oogooOol20003Ool00`00Oomoo`02Ool00`00Oomo
o`07Ool01000Oomoo`0027oo00<007oo00001Goo00L007oo001oo`00Ool00005Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00D007oo001oo`00009oo`03001oogoo00=oo`03
001oogoo009oo`03001oogoo00Aoo`8000=oo`04001oogoo0007Ool01@00Oomoogoo00000Woo00<0
07ooOol017oo00<007oo00001goo00<007oo00001Woo00<007ooOol00goo00D007ooOomoo`0000Eo
o`04001oogoo0006Ool00`00Oomoo`03Ool00`00Oomoo`05Ool01@00Oomoogoo00001Goo0P000goo
00<007ooOol00Woo00<007ooOol00goo00<007ooOol00goo00<007ooOol01Woo00H007ooOol007oo
000@Ool0029oo`05001oogooOol00004Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Ool00008
Ool00`00Ool00005Ool20002Ool00`00Ool00005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool01@00
Oomoogoo000017oo00<007oo00000P000Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0
17oo0P000goo00@007ooOol000Moo`05001oogooOol00002Ool00`00Oomoo`04Ool00`00Ool00007
Ool00`00Ool00006Ool00`00Oomoo`03Ool01@00Oomoogoo00001Goo00@007ooOol000Ioo`03001o
ogoo00=oo`03001oogoo00Ioo`04001oogoo0005Ool20003Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool20006Ool01`00Oomoogoo001oo`00011oo`008Woo00D007ooOomoo`0000Ao
o`8000=oo`03001oogoo00Qoo`03001oo`0000Qoo`03001oo`0000Eoo`80009oo`03001oo`0000Io
o`03001oogoo009oo`03001oogoo00=oo`05001oogooOol00006Ool200000goo00000006Ool00`00
Oomoo`02Ool00`00Oomoo`04Ool20003Ool01000Oomoo`001goo00D007ooOomoo`00009oo`03001o
ogoo00Aoo`03001oo`0000Moo`03001oo`0000Ioo`03001oogoo00=oo`05001oogooOol00005Ool0
1000Oomoo`001Woo00<007ooOol00goo00<007ooOol01Woo00@007ooOol000Eoo`8000Aoo`05001o
o`00Ool00006Ool01`00Oomoogoo001oo`0000Ioo`07001oogooOol007oo000047oo000ROol01@00
Oomoogoo000017oo0P000goo00<007ooOol027oo00<007oo000027oo00<007oo00001Goo00L007oo
Oomoo`00Ool00006Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo00001Woo0P0000=o
o`0000001Woo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00Woo00@007ooOol000Moo`05
001oogooOol00002Ool00`00Oomoo`04Ool00`00Ool00007Ool00`00Ool00006Ool00`00Oomoo`03
Ool01@00Oomoogoo00001Goo00@007ooOol000Ioo`03001oogoo00=oo`03001oogoo00Moo`03001o
o`0000Eoo`8000Eoo`04001oo`000006Ool01`00Oomoogoo001oo`0000Ioo`07001oogooOol007oo
000047oo000ROol01@00Oomoogoo000017oo0`0000=oo`00Ool02Woo00<007oo000027oo00<007oo
00002Woo0P001Woo00<007ooOol00Woo00<007ooOol00goo00D007ooOomoo`0000Ioo`03001oogoo
008000Ioo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo009oo`03001oo`0000Qoo`05001o
ogooOol00002Ool00`00Oomoo`04Ool00`00Ool00006Ool01000Oomoo`001Woo00<007ooOol00goo
00D007ooOomoo`0000Eoo`04001oogoo0006Ool00`00Oomoo`03Ool00`00Oomoo`07Ool20006Ool0
0`00Oomoo`0>Ool01`00Oomoogoo001oo`0000Ioo`07001oogooOol007oo000047oo000ROol20002
Ool00`00Oomoo`02Ool300000goo001oo`0:Ool2000:Ool2000:Ool20006Ool01@00Oomoogoo0000
1Woo00@007ooOol000Moo`03001oogoo008000Ioo`03001oogoo009oo`03001oogoo00Aoo`03001o
ogoo00=oo`8000Qoo`05001oogooOol00002Ool00`00Oomoo`04Ool00`00Ool00006Ool01000Oomo
o`001Woo00<007ooOol00goo00D007ooOomoo`0000Eoo`04001oogoo0006Ool00`00Oomoo`03Ool0
0`00Oomoo`07Ool20006Ool00`00Oomoo`0>Ool01`00Oomoogoo001oo`0000Ioo`07001oogooOol0
07oo000047oo000ROol00`00Oomoo`06Ool01@00Ool007oo00002goo0P002Woo0P002Woo0P001Woo
00D007ooOomoo`0000Ioo`@000Yoo`8000Ioo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo
00=oo`03001oogoo00Moo`05001oogooOol00002Ool00`00Oomoo`04Ool01000Oomoo`001Goo00D0
07ooOomoo`0000Eoo`03001oogoo00=oo`05001oogooOol00005Ool200000goo001oo`05Ool00`00
Oomoo`03Ool00`00Oomoo`07Ool20006Ool00`00Oomoo`0>Ool01`00Oomoogoo001oo`0000Ioo`03
001oogoo009oo`80011oo`008Woo00<007ooOol01Woo00<007ooOol00P002goo0P002Woo0P002Woo
0P001Woo00D007ooOomoo`0000Qoo`8000Yoo`8000Ioo`03001oogoo009oo`03001oogoo00Aoo`03
001oogoo00ioo`04001oogoo0002Ool00`00Oomoo`03Ool01@00Oomoogoo00001Goo00D007ooOomo
o`0000Eoo`03001oogoo00=oo`05001oogooOol00005Ool200000goo001oo`05Ool00`00Oomoo`03
Ool00`00Oomoo`08Ool00`00Oomoo`0EOol01`00Oomoogoo001oo`0000Ioo`03001oogoo009oo`80
011oo`003goo0P0017oo00<007ooOol00Woo100017oo00<007ooOol01Woo00<007ooOol00P002goo
0P002goo00<007ooOol02Goo00<007ooOol017oo00D007ooOomoo`0000Qoo`8000]oo`03001oogoo
00Aoo`03001oogoo009oo`03001oogoo01Eoo`03001oo`0000=oo`03001oogoo00=oo`05001oogoo
Ool00005Ool01@00Oomoogoo00001Goo00<007ooOol00goo00D007ooOomoo`0000Eoo`@000Ioo`03
001oogoo00=oo`03001oogoo00Qoo`03001oogoo01Ioo`06001oogoo001oo`001Woo00<007ooOol0
0Woo0P0047oo000>Ool01000Oomoo`002Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol0
3Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol017oo00D007ooOomoo`0000Qoo`8000]o
o`03001oogoo00Aoo`03001oogoo009oo`03001oogoo01Eoo`03001oo`0000=oo`03001oogoo00=o
o`05001oogooOol00005Ool01@00Oomoogoo00001Goo00<007ooOol00goo00D007ooOomoo`0000Eo
o`@000Ioo`03001oogoo00=oo`03001oogoo00Qoo`03001oogoo01Ioo`06001oogoo001oo`001Woo
00<007ooOol00Woo0P0047oo000>Ool01000Oomoo`002Woo00<007ooOol00goo0`005goo00<007oo
Ool077oo00D007ooOomoo`0000Uoo`03001oogoo00Uoo`03001oogoo00Eoo`05001oogooOol0000G
Ool00`00Ool00003Ool00`00Oomoo`03Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000Aoo`03
001oogoo00Aoo`05001oogooOol00005Ool40007Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00
Oomoo`0FOol01P00Oomoo`00Ool000Ioo`03001oogoo009oo`80011oo`003Woo00@007ooOol000Yo
o`03001oogoo00=oo`03001oogoo01Moo`03001oogoo01aoo`05001oogooOol00009Ool00`00Oomo
o`09Ool00`00Oomoo`05Ool01@00Oomoogoo00005goo00<007oo00000goo00<007ooOol00goo00D0
07ooOomoo`0000Eoo`05001oogooOol00004Ool00`00Oomoo`04Ool200000goo001oo`05Ool01000
Oomoo`001goo00D007ooOomoo`0002Aoo`06001oogoo001oo`001Woo00<007ooOol00Woo0P0047oo
000>Ool01000Oomoo`002Woo00<007ooOol00goo00<007ooOol05goo00<007ooOol077oo00D007oo
Oomoo`0000Uoo`03001oogoo00Uoo`03001oogoo00Eoo`05001oogooOol0000GOol00`00Ool00003
Ool00`00Oomoo`03Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000Aoo`03001oogoo00Aoo`80
0003Ool007oo00Eoo`04001oogoo0007Ool01@00Oomoogoo000097oo00<007oo00000Woo00<007oo
Ool017oo00<007ooOol00Woo0P0047oo000>Ool01000Oomoo`0027oo0`001Goo00<007ooOol05goo
00<007ooOol077oo00D007ooOomoo`0000Uoo`03001oogoo015oo`05001oogooOol0000HOol20003
Ool00`00Oomoo`03Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000Aoo`03001oogoo00Aoo`80
0003Ool007oo00Eoo`03001oogoo00Qoo`05001oogooOol0000TOol00`00Ool00002Ool00`00Oomo
o`04Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool000moo`8000]oo`03001oogoo00=oo`03001oogoo
01Moo`03001oogoo01aoo`05001oogooOol0000MOol01@00Oomoogoo000067oo0P000goo00<007oo
Ool00goo00D007ooOomoo`0000Eoo`05001oogooOol00004Ool00`00Oomoo`04Ool40006Ool00`00
Oomoo`08Ool01@00Oomoogoo000097oo00<007oo00000Woo00<007oo000017oo00<007ooOol00Woo
00<007ooOol03goo000ROol00`00Oomoo`0GOol00`00Oomoo`0LOol01@00Oomoogoo00007Goo00D0
07ooOomoo`0001Uoo`05001oogooOol00005Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000=o
o`03001oogoo00Eoo`@000Ioo`03001oogoo00Qoo`05001oogooOol0000UOol20003Ool20004Ool0
0`00Oomoo`02Ool00`00Oomoo`0?Ool0029oo`8001Qoo`03001oogoo01aoo`05001oogooOol0000M
Ool01@00Oomoogoo00007Goo00<007ooOol00goo00D007ooOomoo`0000Aoo`03001oogoo009oo`05
001oogooOol00007Ool01000Ool000004Goo00D007ooOomoo`0002Eoo`03001oogoo009oo`8000Ao
o`03001oogoo009oo`03001oogoo00moo`008Woo00<007ooOol0=Woo00D007ooOomoo`0001eoo`05
001oogooOol0000MOol00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol00Woo00D007oo
Oomoo`0000Moo`04001oo`00000AOol01@00Oomoogoo00009Goo00<007ooOol00Woo0P0017oo00<0
07ooOol00Woo00<007ooOol03goo000ROol00`00Oomoo`0fOol01@00Oomoogoo00007Goo00D007oo
Oomoo`0001eoo`03001oogoo00=oo`05001oogooOol00004Ool00`00Oomoo`02Ool01@00Oomoogoo
00001goo00@007oo0000015oo`05001oogooOol0000ZOol20003Ool00`00Oomoo`03Ool00`00Oomo
o`0?Ool0029oo`03001oogoo03Moo`04001oogoo000MOol01@00Oomoogoo00007Woo00<007ooOol0
0Woo00D007ooOomoo`0000=oo`8000Aoo`05001oogooOol00007Ool01000Oomoo`004Goo00D007oo
Oomoo`0002Yoo`03001oo`00009oo`03001oogoo00=oo`03001oogoo00moo`008Woo00<007ooOol0
=goo00@007ooOol001eoo`05001oogooOol0000NOol01@00Oomoogoo000017oo00<007ooOol00`00
17oo00D007ooOomoo`0000Moo`04001oogoo000AOol01@00Oomoogoo0000:Woo00<007oo00000Woo
00<007ooOol00goo00<007ooOol03goo000ROol00`00Oomoo`0gOol01000Oomoo`007Goo00D007oo
Oomoo`0001ioo`05001oogooOol00004Ool01P00Oomoo`00Ool000Aoo`05001oogooOol0000:Ool0
0`00Oomoo`0?Ool01@00Oomoogoo0000:Woo00<007oo00000Woo00<007ooOol00goo00<007ooOol0
3goo000ROol2000hOol01000Oomoo`007Goo00@007ooOol001moo`05001oogooOol00004Ool00`00
Ool00002Ool00`00Oomoo`02Ool01@00Oomoogoo000077oo00D007ooOomoo`0002Yoo`03001oo`00
009oo`03001oogoo00=oo`03001oogoo00moo`008Woo00<007ooOol0=goo00@007ooOol001eoo`04
001oogoo000OOol01@00Oomoogoo000017oo00<007oo00001goo00D007ooOomoo`0001aoo`05001o
ogooOol0000/Ool01000Oomoo`001Goo00<007ooOol03goo000ROol00`00Oomoo`0gOol01000Oomo
o`007Goo00@007ooOol001moo`05001oogooOol00004Ool20008Ool01@00Oomoogoo000077oo00D0
07ooOomoo`0002aoo`04001oogoo0005Ool00`00Oomoo`0?Ool0029oo`03001oogoo03Moo`04001o
ogoo000MOol01000Oomoo`007goo00D007ooOomoo`0000Aoo`8000Qoo`04001oogoo000MOol01@00
Oomoogoo0000;7oo00@007ooOol000Eoo`03001oogoo00moo`008Woo00<007ooOol0=goo00<007oo
00007Woo00@007ooOol001moo`05001oogooOol00004Ool00`00Oomoo`07Ool01000Oomoo`007Goo
00D007oo001oo`0002aoo`04001oogoo0005Ool00`00Oomoo`0?Ool0029oo`8003Uoo`8001ioo`04
001oo`00000OOol01@00Oomoogoo00003Woo00@007ooOol001eoo`<00003Ool007oo02aoo`03001o
o`0000Eoo`03001oogoo00moo`008Woo00<007ooOol0>7oo0P007Woo00@007oo000001moo`05001o
ogooOol0000>Ool01000Oomoo`007Goo0`0000=oo`00Ool0;7oo00<007oo00001Goo00<007ooOol0
3goo000ROol00`00Oomoo`0hOol2000NOol4000OOol01000Oomoo`003goo00@007ooOol001eoo`03
001oogoo008002eoo`03001oo`0001Moo`008Woo00<007ooOol0>7oo0P007Woo10007goo00@007oo
Ool0011oo`03001oo`00021oo`8002eoo`<001Moo`002Goo0P0017oo00<007ooOol00Woo10000Woo
100017oo00<007ooOol0>7oo0P007Woo00@007ooOol001moo`04001oogoo000@Ool00`00Ool0000P
Ool20017Ool000Qoo`04001oogoo000:Ool01@00Oomoogoo00001goo00<007ooOol0>7oo0P008Goo
00<007ooOol07Goo00@007ooOol0011oo`03001oo`00021oo`8004Moo`0027oo00@007ooOol000Yo
o`03001oogoo009oo`03001oogoo00Aoo`<003Qoo`80025oo`03001oogoo01eoo`03001oo`00015o
o`03001oo`00025oo`03001oogoo04Eoo`0027oo00@007ooOol000Yoo`03001oogoo00=oo`03001o
ogoo00=oo`03001oogoo03Uoo`03001oogoo01moo`03001oogoo01eoo`03001oo`00015oo`03001o
o`00025oo`03001oogoo04Eoo`0027oo00@007ooOol000Yoo`03001oogoo00Aoo`03001oogoo009o
o`03001oogoo03Uoo`03001oogoo03moo`03001oo`00015oo`03001oo`00025oo`03001oogoo04Eo
o`0027oo00@007ooOol000Qoo`<000=oo`04001oogoo0004Ool00`00Oomoo`0iOol00`00Oomoo`0o
Ool2000BOol00`00Ool0001YOol000Uoo`8000]oo`03001oogoo009oo`8000Eoo`03001oogoo07]o
o`80019oo`03001oo`0006Uoo`008Woo00<007ooOol0Ngoo0P004Woo00<007oo0000JGoo000ROol2
001lOol2000BOol2001ZOol0029oo`03001oogoo07]oo`03001oogoo019oo`03001oogoo06Qoo`00
8Woo00<007ooOol0Ngoo00<007ooOol04Woo00<007ooOol0J7oo000ROol00`00Oomoo`2@Ool00`00
Oomoo`1XOol0029oo`03001oogoo091oo`03001oogoo06Qoo`008Woo00<007ooOol0T7oo00<007oo
Ool0J7oo000ROol2002AOol00`00Oomoo`1XOol0029oo`03001oogoo0?]oo`008Woo00<007ooOol0
ngoo000ROol00`00Oomoo`3kOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00TGoo0`00
S7oo002BOol00`00Oomoo`2;Ool007=oo`D00004Ool00000Ool20004Ool20002Ool40003Ool20000
0goo001oo`030004Ool20003Ool50002Ool200000goo001oo`02Ool20002Ool50002Ool20002Ool3
00000goo0000001OOol007Aoo`04001oogoo0002Ool00`00Ool00004Ool01000Oomoo`000Woo00<0
07ooOol00Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`0017oo00D007ooOomoo`00
009oo`05001oogooOol00002Ool01@00Oomoogoo00000goo00@007ooOol0009oo`04001oogoo001P
Ool007Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`<0009o
o`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0`000goo00<007ooOol017oo00D0
07ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`1NOol007Aoo`<000=oo`03001oo`0000Ao
o`03001oogoo00=oo`03001oogoo00Eoo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol0
0Woo00<007ooOol017oo00D007ooOomoo`0000Ioo`05001oogooOol00002Ool01000Oomoo`000Woo
00<007ooOol0GWoo001dOol01@00Oomoo`00Ool00P0000=oo`0000000Woo10000Woo00<007oo0000
0P000Woo0P000Woo00@007oo000000Aoo`8000Eoo`03001oogoo009oo`8000=oo`@000=oo`8000Ao
o`80009oo`04001oo`00001QOol007=oo`D000Uoo`03001oogoo01aoo`03001oogoo00Qoo`03001o
ogoo079oo`00PGoo00<007ooOol06goo0P002Woo00<007ooOol017oo00<007ooOol0Jgoo0000\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {291, 69.8125}} -> {-7.32025, \
0.0384645, 0.0667818, 0.000879357}}]
}, Open  ]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
            False,
            Editable->False], "}"}], ",", 
        RowBox[{"{", 
          TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
            False,
            Editable->False], "}"}], ",", 
        RowBox[{"{", 
          TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
            False,
            Editable->False], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[23]="]
}, Open  ]],

Cell["\<\
Here are the solutions obtained by the various methods at the end \
of the integration.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DisplayForm[\[IndentingNewLine]GridBox[\[IndentingNewLine]MapThread[{#1,\
 \ FinalSolutions[system, \ #2]} &, {methods\ , \ 
            solutions}], \[IndentingNewLine]RowLines \[Rule] True, 
        ColumnLines \[Rule] True, \ 
        GridFrame \[Rule] 
          True\[IndentingNewLine]]\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[24]:="],

Cell[BoxData[
    TagBox[GridBox[{
          {
            "ExplicitRungeKutta", \
\({{\(-9.131313027740720493921509635875998449821110954951`30.224687046657813\)\
, \(-12.476178811579588711260321937383939305716482241758`30.343072841887015\),\
 22.843338961368839981497238724669613880976514156718`30.41875313882358}}\)},
          {
            "Adams", \
\({{\(-9.131313013783925588436308925148842413170895852129`30.22468704662482\),\
 \(-12.476178792768735388592056583387404596987848701142`30.343072840274164\), 
                22.843338946868537299691315618480874894247118059958`30.\
418753141006217}}\)},
          {
            "Extrapolation", \
\({{\(-9.131313029366549055758313533090426956640794156578`30.224687046661654\)\
, \(-12.476178813770865245911603756394244673172173579677`30.3430728420749\), 
                22.843338963057985030719794194806304437680993417037`30.\
41875313856933}}\)}
          },
        GridFrame->True,
        RowLines->True,
        ColumnLines->True],
      DisplayForm]], "Output",
  CellLabel->"Out[24]//DisplayForm="]
}, Open  ]],

Cell[TextData[{
  "For comparison, here is a higher-precision reference solution obtained \
using ",
  StyleBox["Extrapolation", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(refsol\  = \ 
        NDSolve[system, \ 
          Method \[Rule] {"\<Extrapolation\>", \ 
              Method -> "\<ExplicitModifiedMidpoint\>"}, 
          WorkingPrecision \[Rule] 64];\)\), "\[IndentingNewLine]", 
    \(SetPrecision[FinalSolutions[system, \ refsol], \ 32]\)}], "Input",
  CellLabel->"In[25]:="],

Cell[BoxData[
    \({{\(-9.131313027368752927862672950512580041842616480377`32. \), \
\(-12.476178811078253333918996179371732188248987988331`32. \), 
        22.843338960982388205501905628017674839945515704188`32. }}\)], \
"Output",
  CellLabel->"Out[26]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Work-error comparison", "Subsection"],

Cell[TextData[{
  "For comparing different extrapolation schemes consider an example from ",
  "[",
  ButtonBox["HW96",
    ButtonData:>{"References.nb", "HW96"},
    ButtonStyle->"Hyperlink"],
  "]",
  "."
}], "Text"],

Cell[BoxData[{
    \(\(t0\  = \ \[Pi]/6;\)\), "\[IndentingNewLine]", 
    \(\(h0\  = \ 1/10;\)\), "\[IndentingNewLine]", 
    \(\(y0\  = \ {2/\@3};\)\), "\[IndentingNewLine]", 
    \(\(eqs\  = \ {\(y'\)[
              t] \[Equal] \((\(-y[t]\)\ Sin[t] + 2\ Tan[t])\)\ y[t], 
          y[t0] \[Equal] y0};\)\), "\[IndentingNewLine]", 
    \(\(exactsol = \(y[t] /. First[DSolve[eqs, y[t], t]]\) /. 
          t \[Rule] t0 + h0;\)\), "\[IndentingNewLine]", 
    \(\(idata\  = \ \ {{eqs, y[t], t}, h0, exactsol};\)\)}], "Input",
  CellLabel->"In[27]:="],

Cell[TextData[{
  "The exact solution is given by ",
  StyleBox["y",
    FontSlant->"Italic"],
  "(",
  StyleBox["t",
    FontSlant->"Italic"],
  ") = 1/cos(",
  StyleBox["t",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell["Increment formulation", "Subsubsection"],

Cell[TextData[{
  "This example involves an eighth-order extrapolation of ",
  StyleBox["ExplicitEuler", "MR"],
  " with the Harmonic sequence. Approximately two digits of accuracy are \
gained by using the increment-based formulation throughout the extrapolation \
process."
}], "Text"],

Cell[TextData[{
  "The results for the standard formulation (",
  
  CounterBox["NumberedEquation", "EulerSteps"],
  ") are depicted in green."
}], "BulletedList"],

Cell[TextData[{
  "The results for the increment formulation (",
  
  CounterBox["NumberedEquation", "EulerIncrements"],
  ") followed by standard extrapolation (",
  
  CounterBox["NumberedEquation", "AitkenNeville"],
  ") is depicted in blue."
}], "BulletedList"],

Cell[TextData[{
  "The results for the increment formulation (",
  
  CounterBox["NumberedEquation", "EulerIncrements"],
  ") with extrapolation carried out on the increments using (",
  
  CounterBox["NumberedEquation", "ModifiedAitkenNeville"],
  ") is depicted in red."
}], "BulletedList"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10  scalefont  setfont
% Scaling calculations
0.97619 0.0677249 0.0147151 0.402492 [
[.02804 -0.0125 -23.4688 -14.375 ]
[.02804 -0.0125 23.4688 0 ]
[.23122 -0.0125 -23.4688 -14.375 ]
[.23122 -0.0125 23.4688 0 ]
[.43439 -0.0125 -21.5 -14.375 ]
[.43439 -0.0125 21.5 0 ]
[.63757 -0.0125 -19.875 -11.1875 ]
[.63757 -0.0125 19.875 0 ]
[.84074 -0.0125 -11.625 -11.1875 ]
[.84074 -0.0125 11.625 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -9.5 -5.59375 ]
[-0.0125 .01472 0 5.59375 ]
[-0.0125 .08559 -17.75 -5.59375 ]
[-0.0125 .08559 0 5.59375 ]
[-0.0125 .13588 -9.5 -5.59375 ]
[-0.0125 .13588 0 5.59375 ]
[-0.0125 .20675 -9.5 -5.59375 ]
[-0.0125 .20675 0 5.59375 ]
[-0.0125 .29605 -9.5 -5.59375 ]
[-0.0125 .29605 0 5.59375 ]
[-0.0125 .35486 -9.5 -5.59375 ]
[-0.0125 .35486 0 5.59375 ]
[-0.0125 .41721 -15 -5.59375 ]
[-0.0125 .41721 0 5.59375 ]
[-0.0125 .48808 -15 -5.59375 ]
[-0.0125 .48808 0 5.59375 ]
[-0.0125 .53837 -15 -5.59375 ]
[-0.0125 .53837 0 5.59375 ]
[-0.0125 .60924 -15 -5.59375 ]
[-0.0125 .60924 0 5.59375 ]
[ 0 0 -0.125 0 ]
[.02804 .63053 -23.4688 0 ]
[.02804 .63053 23.4688 14.375 ]
[.23122 .63053 -23.4688 0 ]
[.23122 .63053 23.4688 14.375 ]
[.43439 .63053 -21.5 0 ]
[.43439 .63053 21.5 14.375 ]
[.63757 .63053 -19.875 0 ]
[.63757 .63053 19.875 11.1875 ]
[.84074 .63053 -11.625 0 ]
[.84074 .63053 11.625 11.1875 ]
[ 0 .61803 .125 0 ]
[1.0125 .01472 0 -5.59375 ]
[1.0125 .01472 9.5 5.59375 ]
[1.0125 .08559 0 -5.59375 ]
[1.0125 .08559 17.75 5.59375 ]
[1.0125 .13588 0 -5.59375 ]
[1.0125 .13588 9.5 5.59375 ]
[1.0125 .20675 0 -5.59375 ]
[1.0125 .20675 9.5 5.59375 ]
[1.0125 .29605 0 -5.59375 ]
[1.0125 .29605 9.5 5.59375 ]
[1.0125 .35486 0 -5.59375 ]
[1.0125 .35486 9.5 5.59375 ]
[1.0125 .41721 0 -5.59375 ]
[1.0125 .41721 15 5.59375 ]
[1.0125 .48808 0 -5.59375 ]
[1.0125 .48808 15 5.59375 ]
[1.0125 .53837 0 -5.59375 ]
[1.0125 .53837 15 5.59375 ]
[1.0125 .60924 0 -5.59375 ]
[1.0125 .60924 15 5.59375 ]
[ 1 0 .125 0 ]
[.5 .63053 -105.219 14.375 ]
[.5 .63053 105.219 27.6875 ]
[ -0.0005 -0.0005 0 0 ]
[ 1.0005 .61853 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02804 0 m
.02804 .00625 L
s
gsave
.02804 -0.0125 -84.4688 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.23122 0 m
.23122 .00625 L
s
gsave
.23122 -0.0125 -84.4688 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.43439 0 m
.43439 .00625 L
s
gsave
.43439 -0.0125 -82.5 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(8) show
100.125 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.63757 0 m
.63757 .00625 L
s
gsave
.63757 -0.0125 -80.875 -15.1875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.00001) show
98.750 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.84074 0 m
.84074 .00625 L
s
gsave
.84074 -0.0125 -72.625 -15.1875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
82.250 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.16683 0 m
.16683 .00375 L
s
.18708 0 m
.18708 .00375 L
s
.19896 0 m
.19896 .00375 L
s
.2074 0 m
.2074 .00375 L
s
.21395 0 m
.21395 .00375 L
s
.21931 0 m
.21931 .00375 L
s
.22383 0 m
.22383 .00375 L
s
.22776 0 m
.22776 .00375 L
s
.37 0 m
.37 .00375 L
s
.39026 0 m
.39026 .00375 L
s
.40214 0 m
.40214 .00375 L
s
.41058 0 m
.41058 .00375 L
s
.41713 0 m
.41713 .00375 L
s
.42248 0 m
.42248 .00375 L
s
.42701 0 m
.42701 .00375 L
s
.43093 0 m
.43093 .00375 L
s
.57317 0 m
.57317 .00375 L
s
.59343 0 m
.59343 .00375 L
s
.60531 0 m
.60531 .00375 L
s
.61375 0 m
.61375 .00375 L
s
.6203 0 m
.6203 .00375 L
s
.62565 0 m
.62565 .00375 L
s
.63018 0 m
.63018 .00375 L
s
.63411 0 m
.63411 .00375 L
s
.77635 0 m
.77635 .00375 L
s
.7966 0 m
.7966 .00375 L
s
.80849 0 m
.80849 .00375 L
s
.81693 0 m
.81693 .00375 L
s
.82348 0 m
.82348 .00375 L
s
.82883 0 m
.82883 .00375 L
s
.83336 0 m
.83336 .00375 L
s
.83728 0 m
.83728 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
gsave
-0.0125 .01472 -70.5 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .08559 m
.00625 .08559 L
s
gsave
-0.0125 .08559 -78.75 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
76.750 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .13588 m
.00625 .13588 L
s
gsave
-0.0125 .13588 -70.5 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .20675 m
.00625 .20675 L
s
gsave
-0.0125 .20675 -70.5 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .29605 m
.00625 .29605 L
s
gsave
-0.0125 .29605 -70.5 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .35486 m
.00625 .35486 L
s
gsave
-0.0125 .35486 -70.5 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .41721 m
.00625 .41721 L
s
gsave
-0.0125 .41721 -76 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .48808 m
.00625 .48808 L
s
gsave
-0.0125 .48808 -76 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(15) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .53837 m
.00625 .53837 L
s
gsave
-0.0125 .53837 -76 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .60924 m
.00625 .60924 L
s
gsave
-0.0125 .60924 -76 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(30) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
0 .03138 m
.00375 .03138 L
s
0 .04658 m
.00375 .04658 L
s
0 .06058 m
.00375 .06058 L
s
0 .07353 m
.00375 .07353 L
s
0 .09687 m
.00375 .09687 L
s
0 .10747 m
.00375 .10747 L
s
0 .11746 m
.00375 .11746 L
s
0 .12691 m
.00375 .12691 L
s
0 .25704 m
.00375 .25704 L
s
0 .32791 m
.00375 .32791 L
s
0 .3782 m
.00375 .3782 L
s
0 .39879 m
.00375 .39879 L
s
0 .43387 m
.00375 .43387 L
s
0 .44908 m
.00375 .44908 L
s
0 .46307 m
.00375 .46307 L
s
0 .47602 m
.00375 .47602 L
s
0 .49936 m
.00375 .49936 L
s
0 .50996 m
.00375 .50996 L
s
0 .51995 m
.00375 .51995 L
s
0 .5294 m
.00375 .5294 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02804 .61178 m
.02804 .61803 L
s
gsave
.02804 .63053 -84.4688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.23122 .61178 m
.23122 .61803 L
s
gsave
.23122 .63053 -84.4688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.43439 .61178 m
.43439 .61803 L
s
gsave
.43439 .63053 -82.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(8) show
100.125 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.63757 .61178 m
.63757 .61803 L
s
gsave
.63757 .63053 -80.875 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.00001) show
98.750 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.84074 .61178 m
.84074 .61803 L
s
gsave
.84074 .63053 -72.625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.01) show
82.250 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.16683 .61428 m
.16683 .61803 L
s
.18708 .61428 m
.18708 .61803 L
s
.19896 .61428 m
.19896 .61803 L
s
.2074 .61428 m
.2074 .61803 L
s
.21395 .61428 m
.21395 .61803 L
s
.21931 .61428 m
.21931 .61803 L
s
.22383 .61428 m
.22383 .61803 L
s
.22776 .61428 m
.22776 .61803 L
s
.37 .61428 m
.37 .61803 L
s
.39026 .61428 m
.39026 .61803 L
s
.40214 .61428 m
.40214 .61803 L
s
.41058 .61428 m
.41058 .61803 L
s
.41713 .61428 m
.41713 .61803 L
s
.42248 .61428 m
.42248 .61803 L
s
.42701 .61428 m
.42701 .61803 L
s
.43093 .61428 m
.43093 .61803 L
s
.57317 .61428 m
.57317 .61803 L
s
.59343 .61428 m
.59343 .61803 L
s
.60531 .61428 m
.60531 .61803 L
s
.61375 .61428 m
.61375 .61803 L
s
.6203 .61428 m
.6203 .61803 L
s
.62565 .61428 m
.62565 .61803 L
s
.63018 .61428 m
.63018 .61803 L
s
.63411 .61428 m
.63411 .61803 L
s
.77635 .61428 m
.77635 .61803 L
s
.7966 .61428 m
.7966 .61803 L
s
.80849 .61428 m
.80849 .61803 L
s
.81693 .61428 m
.81693 .61803 L
s
.82348 .61428 m
.82348 .61803 L
s
.82883 .61428 m
.82883 .61803 L
s
.83336 .61428 m
.83336 .61803 L
s
.83728 .61428 m
.83728 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
gsave
1.0125 .01472 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .08559 m
1 .08559 L
s
gsave
1.0125 .08559 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
76.750 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .13588 m
1 .13588 L
s
gsave
1.0125 .13588 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .20675 m
1 .20675 L
s
gsave
1.0125 .20675 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .29605 m
1 .29605 L
s
gsave
1.0125 .29605 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .35486 m
1 .35486 L
s
gsave
1.0125 .35486 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .41721 m
1 .41721 L
s
gsave
1.0125 .41721 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .48808 m
1 .48808 L
s
gsave
1.0125 .48808 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(15) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .53837 m
1 .53837 L
s
gsave
1.0125 .53837 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .60924 m
1 .60924 L
s
gsave
1.0125 .60924 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(30) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.99625 .03138 m
1 .03138 L
s
.99625 .04658 m
1 .04658 L
s
.99625 .06058 m
1 .06058 L
s
.99625 .07353 m
1 .07353 L
s
.99625 .09687 m
1 .09687 L
s
.99625 .10747 m
1 .10747 L
s
.99625 .11746 m
1 .11746 L
s
.99625 .12691 m
1 .12691 L
s
.99625 .25704 m
1 .25704 L
s
.99625 .32791 m
1 .32791 L
s
.99625 .3782 m
1 .3782 L
s
.99625 .39879 m
1 .39879 L
s
.99625 .43387 m
1 .43387 L
s
.99625 .44908 m
1 .44908 L
s
.99625 .46307 m
1 .46307 L
s
.99625 .47602 m
1 .47602 L
s
.99625 .49936 m
1 .49936 L
s
.99625 .50996 m
1 .50996 L
s
.99625 .51995 m
1 .51995 L
s
.99625 .5294 m
1 .5294 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -166.219 10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.3125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Plot) show
86.875 13.688 moveto
(of) show
100.125 13.688 moveto
(work) show
128.625 13.688 moveto
(vs) show
143.938 13.688 moveto
(error) show
172.312 13.688 moveto
(on) show
188.875 13.688 moveto
(a) show
198.812 13.688 moveto
(log) show
214.688 13.688 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
222.375 13.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(log) show
241.562 13.688 moveto
(scale) show
269.438 13.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.83602 .01472 m
.8163 .13588 L
.72509 .13588 L
.83602 .01472 L
s
.8163 .13588 m
.80459 .20675 L
.69286 .25704 L
.8163 .13588 L
s
.80459 .20675 m
.79624 .25704 L
.67248 .32791 L
.80459 .20675 L
s
.79624 .25704 m
.78974 .29605 L
.65744 .3782 L
.79624 .25704 L
s
.78974 .29605 m
.78442 .32791 L
.64551 .41721 L
.78974 .29605 L
s
.78442 .32791 m
.77992 .35486 L
.6356 .44908 L
.78442 .32791 L
s
.77992 .35486 m
.77602 .3782 L
.62714 .47602 L
.77992 .35486 L
s
.72509 .13588 m
.69286 .25704 L
.53423 .25704 L
.72509 .13588 L
s
.69286 .25704 m
.67248 .32791 L
.40147 .35486 L
.69286 .25704 L
s
.67248 .32791 m
.65744 .3782 L
.44516 .41721 L
.67248 .32791 L
s
.65744 .3782 m
.64551 .41721 L
.43699 .46307 L
.65744 .3782 L
s
.64551 .41721 m
.6356 .44908 L
.42639 .49936 L
.64551 .41721 L
s
.6356 .44908 m
.62714 .47602 L
.4161 .5294 L
.6356 .44908 L
s
.53423 .25704 m
.40147 .35486 L
.50317 .35486 L
.53423 .25704 L
s
.40147 .35486 m
.44516 .41721 L
.45739 .43387 L
.40147 .35486 L
s
.44516 .41721 m
.43699 .46307 L
.42563 .48808 L
.44516 .41721 L
s
.43699 .46307 m
.42639 .49936 L
.40101 .5294 L
.43699 .46307 L
s
.42639 .49936 m
.4161 .5294 L
.3808 .5628 L
.42639 .49936 L
s
.50317 .35486 m
.45739 .43387 L
.37672 .43387 L
.50317 .35486 L
s
.45739 .43387 m
.42563 .48808 L
.3205 .49936 L
.45739 .43387 L
s
.42563 .48808 m
.40101 .5294 L
.28173 .5469 L
.42563 .48808 L
s
.40101 .5294 m
.3808 .5628 L
.25163 .58423 L
.40101 .5294 L
s
.37672 .43387 m
.3205 .49936 L
.26526 .49936 L
.37672 .43387 L
s
.3205 .49936 m
.28173 .5469 L
.21236 .55503 L
.3205 .49936 L
s
.28173 .5469 m
.25163 .58423 L
.17318 .59718 L
.28173 .5469 L
s
.26526 .49936 m
.21236 .55503 L
.15843 .55503 L
.26526 .49936 L
s
.21236 .55503 m
.17318 .59718 L
.09502 .60332 L
.21236 .55503 L
s
.15843 .55503 m
.09502 .60332 L
.02381 .60332 L
.15843 .55503 L
s
0 0 1 r
.83602 .01472 m
.8163 .13588 L
.72509 .13588 L
.83602 .01472 L
s
.8163 .13588 m
.80459 .20675 L
.69286 .25704 L
.8163 .13588 L
s
.80459 .20675 m
.79624 .25704 L
.67248 .32791 L
.80459 .20675 L
s
.79624 .25704 m
.78974 .29605 L
.65744 .3782 L
.79624 .25704 L
s
.78974 .29605 m
.78442 .32791 L
.64551 .41721 L
.78974 .29605 L
s
.78442 .32791 m
.77992 .35486 L
.6356 .44908 L
.78442 .32791 L
s
.77992 .35486 m
.77602 .3782 L
.62714 .47602 L
.77992 .35486 L
s
.72509 .13588 m
.69286 .25704 L
.53423 .25704 L
.72509 .13588 L
s
.69286 .25704 m
.67248 .32791 L
.40147 .35486 L
.69286 .25704 L
s
.67248 .32791 m
.65744 .3782 L
.44516 .41721 L
.67248 .32791 L
s
.65744 .3782 m
.64551 .41721 L
.43699 .46307 L
.65744 .3782 L
s
.64551 .41721 m
.6356 .44908 L
.42639 .49936 L
.64551 .41721 L
s
.6356 .44908 m
.62714 .47602 L
.4161 .5294 L
.6356 .44908 L
s
.53423 .25704 m
.40147 .35486 L
.50317 .35486 L
.53423 .25704 L
s
.40147 .35486 m
.44516 .41721 L
.45739 .43387 L
.40147 .35486 L
s
.44516 .41721 m
.43699 .46307 L
.42563 .48808 L
.44516 .41721 L
s
.43699 .46307 m
.42639 .49936 L
.40101 .5294 L
.43699 .46307 L
s
.42639 .49936 m
.4161 .5294 L
.3808 .5628 L
.42639 .49936 L
s
.50317 .35486 m
.45739 .43387 L
.37672 .43387 L
.50317 .35486 L
s
.45739 .43387 m
.42563 .48808 L
.3205 .49936 L
.45739 .43387 L
s
.42563 .48808 m
.40101 .5294 L
.28172 .5469 L
.42563 .48808 L
s
.40101 .5294 m
.3808 .5628 L
.25162 .58423 L
.40101 .5294 L
s
.37672 .43387 m
.3205 .49936 L
.26525 .49936 L
.37672 .43387 L
s
.3205 .49936 m
.28172 .5469 L
.21251 .55503 L
.3205 .49936 L
s
.28172 .5469 m
.25162 .58423 L
.17318 .59718 L
.28172 .5469 L
s
.26525 .49936 m
.21251 .55503 L
.15963 .55503 L
.26525 .49936 L
s
.21251 .55503 m
.17318 .59718 L
.09217 .60332 L
.21251 .55503 L
s
.15963 .55503 m
.09217 .60332 L
.05404 .60332 L
.15963 .55503 L
s
0 1 0 r
.83602 .01472 m
.8163 .13588 L
.72509 .13588 L
.83602 .01472 L
s
.8163 .13588 m
.80459 .20675 L
.69286 .25704 L
.8163 .13588 L
s
.80459 .20675 m
.79624 .25704 L
.67248 .32791 L
.80459 .20675 L
s
.79624 .25704 m
.78974 .29605 L
.65744 .3782 L
.79624 .25704 L
s
.78974 .29605 m
.78442 .32791 L
.64551 .41721 L
.78974 .29605 L
s
.78442 .32791 m
.77992 .35486 L
.6356 .44908 L
.78442 .32791 L
s
.77992 .35486 m
.77602 .3782 L
.62714 .47602 L
.77992 .35486 L
s
.72509 .13588 m
.69286 .25704 L
.53423 .25704 L
.72509 .13588 L
s
.69286 .25704 m
.67248 .32791 L
.40147 .35486 L
.69286 .25704 L
s
.67248 .32791 m
.65744 .3782 L
.44516 .41721 L
.67248 .32791 L
s
.65744 .3782 m
.64551 .41721 L
.43699 .46307 L
.65744 .3782 L
s
.64551 .41721 m
.6356 .44908 L
.42639 .49936 L
.64551 .41721 L
s
.6356 .44908 m
.62714 .47602 L
.4161 .5294 L
.6356 .44908 L
s
.53423 .25704 m
.40147 .35486 L
.50317 .35486 L
.53423 .25704 L
s
.40147 .35486 m
.44516 .41721 L
.45739 .43387 L
.40147 .35486 L
s
.44516 .41721 m
.43699 .46307 L
.42563 .48808 L
.44516 .41721 L
s
.43699 .46307 m
.42639 .49936 L
.40101 .5294 L
.43699 .46307 L
s
.42639 .49936 m
.4161 .5294 L
.3808 .5628 L
.42639 .49936 L
s
.50317 .35486 m
.45739 .43387 L
.37673 .43387 L
.50317 .35486 L
s
.45739 .43387 m
.42563 .48808 L
.32049 .49936 L
.45739 .43387 L
s
.42563 .48808 m
.40101 .5294 L
.28178 .5469 L
.42563 .48808 L
s
.40101 .5294 m
.3808 .5628 L
.25142 .58423 L
.40101 .5294 L
s
.37673 .43387 m
.32049 .49936 L
.2653 .49936 L
.37673 .43387 L
s
.32049 .49936 m
.28178 .5469 L
.2115 .55503 L
.32049 .49936 L
s
.28178 .5469 m
.25142 .58423 L
.1787 .59718 L
.28178 .5469 L
s
.2653 .49936 m
.2115 .55503 L
.15118 .55503 L
.2653 .49936 L
s
.2115 .55503 m
.1787 .59718 L
.14487 .60332 L
.2115 .55503 L
s
.15118 .55503 m
.14487 .60332 L
.14385 .60332 L
.15118 .55503 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[27]:=",
  ImageSize->{398.812, 246.5},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006>0000mQ000`40O003h00OogooSgoo003oOon?
Ool00?moohmoo`00ogooSgoo000NOol00`00Oomoo`02Ool00`00Ool00003Ool00`00Oomoo`03Ool0
0`00Oomoo`02Ool3000WOol00`00Oomoo`02Ool01000Oomoo`000goo00<007ooOol00goo00<007oo
Ool00Woo0`00:7oo00<007ooOol00Woo00@007ooOol000=oo`03001oogoo00=oo`03001oogoo009o
o`<00=Aoo`007Woo00<007ooOol01Goo00<007oo00001Woo00D007ooOomoo`0000=oo`03001oogoo
02Aoo`03001oogoo00Ioo`03001oo`0000Ioo`05001oogooOol00003Ool00`00Oomoo`0UOol00`00
Oomoo`06Ool00`00Ool00006Ool01@00Oomoogoo00000goo00<007ooOol0dGoo000NOol00`00Oomo
o`06Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00<007ooOol097oo00<007ooOol01goo00<0
07ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo02Eoo`03001oogoo00Moo`03001oogoo00Eo
o`05001oogooOol00003Ool00`00Oomoo`3AOol001ioo`03001oogoo00Eoo`03001oo`0000Ioo`05
001oogooOol00003Ool00`00Oomoo`0TOol00`00Oomoo`06Ool00`00Ool00006Ool01@00Oomoogoo
00000goo00<007ooOol09Goo00<007ooOol01Woo00<007oo00001Woo00D007ooOomoo`0000=oo`03
001oogoo02Aoo`<000=oo`03001oogoo00<000=oo`<000=oo`<000=oo`<000Aoo`03001oogoo02Ao
o`<000=oo`03001oogoo00<000Aoo`03001oogoo055oo`007Woo00<007ooOol017oo00D007ooOomo
o`0000Eoo`05001oogooOol00003Ool00`00Oomoo`0TOol00`00Oomoo`05Ool01@00Oomoogoo0000
1Goo00D007ooOomoo`0000=oo`03001oogoo02Eoo`03001oogoo00Eoo`05001oogooOol00005Ool0
1@00Oomoogoo00000goo00<007ooOol08goo00D007ooOomoo`0000Aoo`07001oogooOol007oo0000
0goo00<007oo00000goo00<007oo00000goo00D007ooOomoo`0002Eoo`05001oogooOol00004Ool0
1@00Oomoogoo00000goo00<007ooOol0DGoo000NOol00`00Oomoo`0>Ool01@00Oomoogoo00000goo
00<007ooOol01Goo00D007ooOomoo`0001Yoo`03001oogoo00moo`05001oogooOol00003Ool00`00
Oomoo`04Ool01@00Oomoogoo000077oo00<007ooOol03goo00D007ooOomoo`0000=oo`03001oogoo
00=oo`8001ioo`05001oogooOol00004Ool01`00Oomoogoo001oo`0000=oo`03001oo`0000=oo`03
001oo`0000=oo`05001oogooOol0000UOol01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03
001oogoo055oo`007Goo0P003goo0P000goo00@007ooOomoo`D000=oo`03001oo`0000<001Qoo`80
011oo`8000=oo`04001oogooOol50002Ool01@00Oomoogoo00006goo0P0047oo0P000goo00@007oo
Oomoo`H0009oo`03001oogoo01]oo`05001oogooOol00004Ool01`00Oomoogoo001oo`0000=oo`03
001oo`0000=oo`03001oo`0000=oo`05001oogooOol0000UOol01@00Oomoogoo000017oo00D007oo
Oomoo`0000=oo`03001oogoo055oo`007Woo00<007ooOol03Woo00<007ooOol00Woo0`0027oo00<0
07ooOol00P006Woo00<007ooOol03goo00<007ooOol00Woo0`001goo00D007ooOomoo`0001aoo`03
001oogoo00moo`03001oogoo009oo`<000Ioo`8001ioo`05001oogooOol00004Ool01`00Oomoogoo
001oo`0000=oo`03001oo`0000=oo`03001oo`0000=oo`05001oogooOol0000UOol01@00Oomoogoo
000017oo00D007ooOomoo`0000=oo`03001oogoo055oo`00?goo00<007ooOol00P00>goo00D007oo
Oomoo`0003]oo`04001oogoo000MOol01@00Oomoogoo000017oo00L007ooOomoo`00Ool00003Ool0
0`00Ool00003Ool00`00Ool00003Ool01@00Oomoogoo00009Goo00D007ooOomoo`0000Aoo`05001o
ogooOol00003Ool00`00Oomoo`1AOol003moo`05001oogooOol0000kOol01@00Oomoogoo0000?7oo
0P007Woo00D007ooOomoo`0000Aoo`07001oogooOol007oo00000goo00<007oo00000goo00<007oo
00000goo00<007ooOol00P009Goo00D007ooOomoo`0000Aoo`05001oogooOol00002Ool2001COol0
0>5oo`<000Ioo`<000=oo`<000=oo`<000=oo`<000Aoo`03001oogoo02Aoo`<000Ioo`<000Aoo`03
001oogoo055oo`00ogooSgoo003oOon?Ool00?moohmoo`00:7ooo`00?`00:7oo000XOol00`00Oomo
o`06Ool00`00Oomoo`0YOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00@007oo001oo`@002]o
o`03001oogoo00Aoo`04001oogoo0002Ool01000Ool007oo0P0000=oo`000000:goo00<007ooOol0
0goo00`007ooOomoo`00Ool007oo001oo`00Ool3000[Ool00`00Oomoo`03Ool01@00Oomoogoo0000
0Woo00D007oo000007oo00<0039oo`03001oogoo02Ioo`00:7oo00<007ooOol01Woo00<007ooOol0
:Goo00<007ooOol00goo00D007ooOomoo`00009oo`04001oo`00Ool4000[Ool00`00Oomoo`04Ool0
1000Oomoo`000Woo00@007oo001oo`800003Ool0000002]oo`03001oogoo00=oo`0<001oogooOol0
07oo001oo`00Ool007oo0`00:goo00<007ooOol00goo00D007ooOomoo`00009oo`05001oo`00001o
o`03000bOol00`00Oomoo`0VOol001moo`03001oogoo00Ioo`03001oogoo0?mooc]oo`03001oogoo
00Eoo`03001oogoo01ioo`007goo00<007ooOol01Woo00<007ooOol0ogoo>goo00<007ooOol01Goo
00<007ooOol07Woo000OOol00`00Oomoo`06Ool3003oOol7Ool00`?POomoo`0_Ool30007Ool00`00
Oomoo`0NOol001moo`03001oogoo00Ioo`03001oogoo0?moo`Ioo`83h3=oo`03001oogoo00Eoo`03
001oogoo01ioo`007goo00<007ooOol01Woo00<007ooOol0ogoo1Goo00<3h7oo0n00<goo00<007oo
Ool01Goo00<007ooOol07Woo000OOol00`00Oomoo`06Ool00`00Oomoo`3oOol4Ool00`?POol3h00d
Ool00`00Oomoo`05Ool00`00Oomoo`0NOol001ioo`8000Qoo`03001oogoo0?moo`=oo`040n1oogoo
0n0dOol00`00Oomoo`04Ool2000POol001moo`03001oogoo00Ioo`800?moo`=oo`050n1oogooOol3
h00bOol30007Ool00`00Oomoo`0NOol002Qoo`03001oogoo0?moo`5oo`030n1oogoo009oo`030n1o
ogoo039oo`03001oogoo02Ioo`00:7oo00<007ooOol0ogoo0Goo00<3h7ooOol00Woo00<3h7ooOol0
<Woo00<007ooOol09Woo000XOol00`00Oomoo`3oOol00`?POomoo`03Ool00`?POomoo`0bOol00`00
Oomoo`0VOol002Qoo`03001oogoo0?ioo`030n1oogoo00=oo`030n1oogoo03=oo`03001oogoo02Io
o`00:7oo0P00oWoo00<3h7ooOol017oo00<3h7ooOol0<Goo0`00:7oo000XOol00`00Oomoo`3lOol0
0`?POomoo`05Ool00`?POomoo`0cOol00`00Oomoo`0VOol002Qoo`03001oogoo0?]oo`030n1oogoo
00Ioo`030n1oogoo03=oo`03001oogoo02Ioo`00:7oo00<007ooOol0nWoo00<3h7ooOol01goo00<3
h7ooOol0<goo00<007ooOol09Woo000XOol2003jOol00`?POomoo`07Ool00`?POomoo`0bOol3000X
Ool002Qoo`03001oogoo0?Qoo`030n1oogoo00Qoo`030n1oogoo03Aoo`03001oogoo02Ioo`00:7oo
00<007ooOol0mgoo00<3h7ooOol02Goo00<3h7ooOol0=7oo00<007ooOol09Woo000XOol00`00Oomo
o`3fOol00`?POomoo`0:Ool00`?POomoo`0dOol00`00Oomoo`0VOol002Qoo`03001oogoo0?Eoo`03
0n1oogoo00]oo`030n1oogoo03Aoo`03001oogoo02Ioo`00:7oo0P00mWoo00<3h7ooOol02goo00<3
h7ooOol0<Woo0`00:7oo000XOol00`00Oomoo`3dOol00`?POomoo`0;Ool00`?POomoo`0eOol00`00
Oomoo`0VOol001Moo`03001oogoo009oo`03001oogoo00<000Ioo`03001oogoo0?=oo`030n1oogoo
00aoo`030n1oogoo03Eoo`03001oogoo00Eoo`03001oogoo009oo`03001oogoo00<001Ioo`005goo
00<007ooOol017oo00D007ooOomoo`0000Eoo`<00?9oo`030n1oogoo00eoo`030n1oogoo03=oo`<0
00Moo`03001oogoo00Aoo`05001oogooOol0000EOol001Moo`03001oogoo00Qoo`03001oogoo00=o
o`03001oogoo0?5oo`030n1oogoo00ioo`030n1oogoo03Eoo`03001oogoo00Eoo`03001oogoo00Qo
o`03001oogoo01=oo`005goo00<007ooOol027oo00<007ooOol00goo00<007ooOol0l7oo00<3h7oo
Ool03goo00<3h7ooOol0=Goo00<007ooOol01Goo00<007ooOol027oo00<007ooOol04goo000GOol0
0`00Oomoo`04Ool40006Ool00`00Oomoo`3_Ool00`?POomoo`0?Ool00`?POomoo`0fOol00`00Oomo
o`05Ool00`00Oomoo`04Ool4000FOol001Moo`03001oogoo00Aoo`03001oogoo00Moo`800>moo`03
0n1oogoo011oo`030n1oogoo03Aoo`<000Moo`03001oogoo00Aoo`03001oogoo01Moo`005Woo0P00
1Woo00<007ooOol01goo00<007ooOol0kGoo00<3h7ooOol04Goo00<3h7ooOol0=Woo00<007ooOol0
17oo0P001Woo00<007ooOol05goo000GOol00`00Oomoo`04Ool50005Ool00`00Oomoo`3/Ool00`?P
Oomoo`0BOol00`?POomoo`0fOol00`00Oomoo`05Ool00`00Oomoo`04Ool5000EOol002Qoo`800>ao
o`030n1oogoo01=oo`030n1oogoo03Aoo`<002Qoo`00:7oo00<007ooOol0jWoo00<3h7ooOol04goo
00<3h7ooOol0=goo00<007ooOol09Woo000XOol00`00Oomoo`3YOol00`?POomoo`0DOol00`?POomo
o`0gOol00`00Oomoo`0VOol002Qoo`800>Yoo`030n1oogoo01Aoo`030n1oogoo03Eoo`<002Qoo`00
:7oo00<007ooOol0j7oo00<3h7ooOol05Goo00<3h7ooOol0=goo00<007ooOol09Woo000XOol00`00
Oomoo`3WOol00`?POomoo`0FOol00`?POomoo`0gOol00`00Oomoo`0VOol002Qoo`800>Moo`030n1o
ogoo01Moo`030n1oogoo03Eoo`<002Qoo`00:7oo00<007ooOol0iGoo00<3h7ooOol05goo00<3h7oo
Ool0>7oo00<007ooOol09Woo000MOol50006Ool00`00Oomoo`3TOol00`?POomoo`0HOol00`?POomo
o`0hOol00`00Oomoo`03Ool5000NOol001eoo`03001oogoo00Qoo`<00>=ooad3h3Qoo`<000Eoo`03
001oogoo021oo`007Woo00<007ooOol01goo00<007ooOol0hGoo0`?P6Woo0P?P>Woo00<007ooOol0
17oo00<007ooOol07goo000OOol20007Ool00`00Oomoo`3POol00`?POol3h00JOol00`?POol3h00j
Ool00`00Oomoo`05Ool2000OOol0025oo`03001oogoo00Aoo`03001oogoo0=ioo`83h09oo`030n1o
ogoo01Moo`040n1oogoo0n0jOol00`00Oomoo`07Ool00`00Oomoo`0LOol0025oo`03001oogoo00Ao
o`03001oogoo0=aoo`83h0Aoo`030n1oogoo01Ioo`040n1oogoo0n0kOol00`00Oomoo`07Ool00`00
Oomoo`0LOol001eoo`05001oogooOol00006Ool00`00Oomoo`3KOol00`?POomoo`04Ool00`?POomo
o`0EOol01@?POomoogoo0n00>goo00<007ooOol00goo00D007ooOomoo`0001ioo`007Woo0`001goo
00<007ooOol0fGoo0P?P1Woo00<3h7ooOol05Goo00<3h7ooOol00Woo00<3h7ooOol0>Goo00<007oo
Ool017oo0`007goo000XOol00`00Oomoo`3HOol00`?POomoo`06Ool00`?POomoo`0DOol00`?POomo
o`03Ool00`?POomoo`0iOol00`00Oomoo`0VOol002Qoo`03001oogoo0=Ioo`83h0Uoo`030n1oogoo
01=oo`030n1oogoo00Aoo`030n1oogoo03Uoo`03001oogoo02Ioo`00:7oo00<007ooOol0eGoo00<3
h7ooOol027oo00<3h7ooOol04goo00<3h7ooOol01Goo00<3h7ooOol0>Goo00<007ooOol09Woo000X
Ool00`00Oomoo`3COol20n0;Ool00`?POomoo`0BOol00`?POomoo`06Ool00`?POomoo`0iOol00`00
Oomoo`0VOol002Qoo`03001oogoo0=9oo`030n1oogoo00]oo`030n1oogoo015oo`030n1oogoo00Mo
o`030n1oogoo03Uoo`03001oogoo02Ioo`00:7oo00<007ooOol0d7oo0P?P3Woo00<3h7ooOol047oo
00<3h7ooOol01goo00<3h7ooOol0>Woo00<007ooOol09Woo000XOol00`00Oomoo`3>Ool20n0?Ool0
0`?POomoo`0@Ool00`?POomoo`08Ool00`?POomoo`0jOol00`00Oomoo`0VOol002Qoo`03001oogoo
0<eoo`030n1oogoo00moo`030n1oogoo00moo`030n1oogoo00Uoo`030n1oogoo03Yoo`03001oogoo
02Ioo`00:7oo00<007ooOol0bgoo0P?P4Woo00<3h7ooOol03Woo00<3h7ooOol02Woo00<3h7ooOol0
>Woo00<007ooOol09Woo000XOol00`00Oomoo`3:Ool00`?POomoo`0AOol00`?POomoo`0>Ool00`?P
Oomoo`0;Ool00`?POomoo`0jOol00`00Oomoo`0VOol002Qoo`03001oogoo0<Qoo`83h1Aoo`030n1o
ogoo00eoo`030n1oogoo00aoo`030n1oogoo03Yoo`03001oogoo02Ioo`00:7oo00<007ooOol0agoo
00<3h7ooOol057oo00<3h7ooOol037oo00<3h7ooOol03Goo00<3h7ooOol0>Woo00<007ooOol09Woo
000XOol00`00Oomoo`35Ool20n0GOol00`?POomoo`0;Ool00`?POomoo`0>Ool00`?POomoo`0jOol0
0`00Oomoo`0VOol002Qoo`03001oogoo0<=oo`83h1Qoo`030n1oogoo00]oo`030n1oogoo00ioo`03
0n1oogoo03]oo`03001oogoo02Ioo`007Woo0`001goo00<007ooOol0`Woo00<3h7ooOol067oo00<3
h7ooOol02Woo00<3h7ooOol03goo00<3h7ooOol0>goo00<007ooOol017oo0`007goo000MOol01@00
Oomoogoo00001Woo00<007ooOol0`7oo0P?P6goo00<3h7ooOol02Goo00<3h7ooOol047oo00<3h7oo
Ool0>goo00<007ooOol00goo00D007ooOomoo`0001ioo`008Goo00<007ooOol017oo0`00_goo00<3
h7ooOol06goo00<3h7ooOol027oo00<3h7ooOol047oo0P?P>goo0`002Goo00<007ooOol077oo000Q
Ool00`00Oomoo`04Ool00`00Oomoo`2mOol20n0MOol00`?POomoo`08Ool00`?POomoo`0?Ool40n0m
Ool00`00Oomoo`07Ool00`00Oomoo`0LOol001moo`8000Moo`03001oogoo0;aoo`030n1oogoo01eo
o`030n1oogoo00Moo`030n1oogoo00ioo`83h004Ool3h7oo0n0mOol00`00Oomoo`05Ool2000OOol0
025oo`03001oogoo00Aoo`03001oogoo0;Yoo`83h21oo`030n1oogoo00Ioo`030n1oogoo00eoo`83
h09oo`030n1oo`?P03ioo`03001oogoo00Moo`03001oogoo01aoo`007Goo00D007ooOomoo`0000Io
o`03001oogoo0;Qoo`83h25oo`030n1oogoo00Ioo`030n1oogoo00]oo`<3h0=oo`040n1oogoo0n0n
Ool00`00Oomoo`03Ool01@00Oomoogoo00007Woo000NOol30007Ool00`00Oomoo`2gOol00`?POomo
o`0QOol00`?POomoo`05Ool00`?POomoo`0:Ool20n04Ool20n03Ool00`?POomoo`0lOol00`00Oomo
o`04Ool3000OOol002Qoo`03001oogoo0;Eoo`83h2Aoo`030n1oogoo00Aoo`030n1oogoo00Uoo`83
h0Eoo`030n1oogoo00=oo`030n1oogoo03aoo`03001oogoo02Ioo`00:7oo00<007ooOol0]7oo00<3
h7ooOol097oo00<3h7ooOol00goo00<3h7ooOol027oo0P?P1Woo00<3h7ooOol017oo00<3h7ooOol0
?7oo00<007ooOol09Woo000XOol00`00Oomoo`2bOol20n0VOol00`?POomoo`03Ool00`?POomoo`06
Ool30n07Ool00`?POomoo`05Ool00`?POomoo`0lOol00`00Oomoo`0VOol002Qoo`03001oogoo0;5o
o`030n1oogoo02Ioo`030n1oogoo009oo`030n1oogoo00Eoo`83h0Uoo`030n1oogoo00Eoo`030n1o
ogoo03eoo`03001oogoo02Ioo`00:7oo00<007ooOol0[goo0P?P:Goo00D3h7ooOomoo`?P00Ioo`83
h0Yoo`030n1oogoo00Ioo`030n1oogoo03eoo`03001oogoo02Ioo`00:7oo00<007ooOol0[Woo00<3
h7ooOol0:7oo00D3h7ooOomoo`?P00Eoo`83h0]oo`030n1oogoo00Moo`030n1oogoo03eoo`03001o
ogoo02Ioo`00:7oo00<007ooOol0[7oo0P?P:goo00@3h7ooOol3h0=oo`<3h0aoo`030n1oogoo00Qo
o`030n1oogoo03eoo`03001oogoo02Ioo`00:7oo00<007ooOol0ZWoo0P?P;Goo00<3h7oo0n000Woo
0P?P3Woo00<3h7ooOol02Goo00<3h7ooOol0?Goo00<007ooOol09Woo000XOol00`00Oomoo`2YOol0
0`?POomoo`0]Ool20n000goo0n03h00>Ool20n0;Ool00`?POomoo`0nOol00`00Oomoo`0VOol002Qo
o`03001oogoo0:Moo`83h2moo`@3h0moo`030n1oogoo00]oo`030n1oogoo03ioo`03001oogoo02Io
o`00:7oo0P00Ygoo=0?P47oo00<3h7ooOol037oo00<3h7ooOol0?7oo0`00:7oo000XOol00`00Oomo
o`2TOol30n0]Ool30n000goo0n1oo`0?Ool00`?POomoo`0;Ool30n10Ool00`00Oomoo`0VOol002Qo
o`03001oogoo0:=oo`030n1oo`?P02]oo`<3h0=oo`030n1oogoo00ioo`030n1oogoo00Yoo`<3h003
Ool3h7oo03moo`03001oogoo02Ioo`00:7oo00<007ooOol0XWoo00@3h7ooOol3h2Qoo`<3h0Ioo`03
0n1oogoo00eoo`030n1oogoo00Uoo`@3h09oo`030n1oogoo03ioo`03001oogoo02Ioo`00:7oo00<0
07ooOol0X7oo0P?P0goo00<3h7ooOol08goo0`?P2Goo00<3h7ooOol037oo00<3h7ooOol02Goo00<3
h7oo0n000goo00<3h7ooOol0?goo00<007ooOol09Woo000XOol00`00Oomoo`2OOol00`?POomoo`02
Ool00`?POomoo`0QOol30n0<Ool00`?POomoo`0;Ool00`?POomoo`08Ool20n000goo0n1oo`03Ool0
0`?POomoo`0oOol00`00Oomoo`0VOol002Qoo`03001oogoo09ioo`030n1oogoo00=oo`030n1oogoo
01ioo`<3h0ioo`030n1oogoo00]oo`030n1oogoo00Moo`83h09oo`030n1oogoo00=oo`030n1oogoo
03moo`03001oogoo02Ioo`00:7oo00<007ooOol0W7oo0P?P1Woo00<3h7ooOol06goo0`?P4Goo00<3
h7ooOol02Woo00<3h7ooOol01Woo0P?P0goo00<3h7ooOol017oo00<3h7ooOol0?goo00<007ooOol0
9Woo000XOol00`00Oomoo`2KOol00`?POomoo`05Ool00`?POomoo`0IOol30n0DOol00`?POomoo`08
Ool20n07Ool20n04Ool00`?POomoo`05Ool00`?POomoo`0oOol00`00Oomoo`0VOol002Qoo`03001o
ogoo09Yoo`030n1oogoo00Ioo`030n1oogoo01Ioo`<3h1Moo`030n1oogoo00Moo`030n1oogoo00Io
o`030n1oogoo009oo`83h0Qoo`030n1oogoo03moo`03001oogoo02Ioo`007Woo0`001goo00<007oo
Ool0V7oo0P?P2Goo00<3h7ooOol04goo0`?P6Goo00<3h7ooOol01goo00<3h7ooOol01Goo0P?P17oo
00<3h7ooOol01goo00<3h7ooOol0@7oo00<007ooOol017oo0`007goo000MOol01@00Oomoogoo0000
1Woo00<007ooOol0Ugoo00<3h7ooOol027oo00<3h7ooOol04Goo0`?P77oo00<3h7ooOol01Woo00<3
h7ooOol017oo0P?P1Goo00<3h7ooOol027oo00<3h7ooOol0@7oo00<007ooOol00goo00D007ooOomo
o`0001ioo`008Goo00<007ooOol017oo0`00UWoo00<3h7ooOol02Goo00<3h7ooOol03Woo0`?P7goo
00<3h7ooOol01Goo00<3h7ooOol00goo0P?P1Woo00<3h7ooOol02Goo00<3h7ooOol0?Woo0`002Goo
00<007ooOol077oo000QOol00`00Oomoo`04Ool00`00Oomoo`2DOol20n0<Ool00`?POomoo`0;Ool3
0n0QOol00`?POomoo`05Ool00`?POomoo`03Ool00`?POomoo`05Ool00`?POomoo`08Ool30n12Ool0
0`00Oomoo`07Ool00`00Oomoo`0LOol001eoo`@000Moo`03001oogoo09=oo`030n1oogoo00]oo`03
0n1oogoo00Uoo`<3h2Aoo`030n1oogoo00Aoo`030n1oogoo009oo`83h0Moo`030n1oogoo00Moo`<3
h003Ool3h7oo045oo`03001oogoo00=oo`@001moo`007Goo00<007ooOol027oo00<007ooOol0TGoo
0P?P3Woo00<3h7ooOol01Woo0`?P9goo00<3h7ooOol00goo00@3h7ooOomoo`83h0Qoo`030n1oogoo
00Moo`83h09oo`030n1oogoo045oo`03001oogoo00=oo`03001oogoo021oo`007Goo00<007ooOol0
27oo00<007ooOol0T7oo00<3h7ooOol03Woo00<3h7ooOol017oo0P?P:Woo00<3h7ooOol00Woo00<3
h7ooOol00P?P27oo0P?P27oo0`?P0goo00<3h7ooOol0@Goo00<007ooOol00goo00<007ooOol087oo
000MOol50006Ool00`00Oomoo`2?Ool00`?POomoo`0?Ool010?POomoogoo0`?P:goo00@3h7ooOomo
o`83h003Ool3h0?P00Uoo`030n1oogoo00Moo`030n1oo`?P00Aoo`030n1oogoo045oo`03001oogoo
00=oo`D001ioo`00:7oo00<007ooOol0SGoo0P?P4Goo00<3h7oo0n000P?P;Woo00@3h7ooOol3h09o
o`030n1oogoo00Qoo`030n1oogoo00Ioo`83h003Ool3h7oo00Aoo`030n1oogoo045oo`03001oogoo
02Ioo`00:7oo00<007ooOol0S7oo00<3h7ooOol047oo0`?P<Goo00@3h7oo0n1oo`83h0Yoo`030n1o
ogoo00Eoo`83h003Ool3h0?P00Ioo`030n1oogoo045oo`03001oogoo02Ioo`00:7oo00<007ooOol0
Rgoo00<3h7ooOol03Woo0`?P00=oo`?POol0<Goo10?P2goo00<3h7ooOol01Goo00@3h7ooOol3h0Mo
o`030n1oogoo049oo`03001oogoo02Ioo`00:7oo00<007ooOol0RGoo0P?P3Woo0`?P0goo00<3h7oo
Ool0<7oo0`?P37oo00<3h7ooOol017oo0P?P0Woo00<3h7ooOol01Woo00<3h7ooOol0@Woo00<007oo
Ool09Woo000XOol20029Ool00`?POomoo`0;Ool30n06Ool00`?POomoo`0/Ool50n0<Ool20n06Ool0
1@?POomoogoo0n002Goo00<3h7ooOol0@7oo0`00:7oo000XOol00`00Oomoo`27Ool00`?POomoo`09
Ool30n09Ool00`?POomoo`0ROol:0n001Goo0n03h7oo0n002goo00<3h7ooOol017oo0P?P0goo00<3
h7ooOol01Woo0`?PA7oo00<007ooOol09Woo000XOol00`00Oomoo`25Ool20n09Ool30n0;Ool00`?P
Oomoo`0JOol90n08Ool30n02Ool00`?POomoo`09Ool00`?POomoo`03Ool20n03Ool20n08Ool20n00
0goo0n1oo`13Ool00`00Oomoo`0VOol002Qoo`03001oogoo08Aoo`030n1oogoo00Ioo`<3h0ioo`03
0n1oogoo011oo`X3h0ioo`<3h0Eoo`030n1oogoo00Qoo`030n1oogoo00=oo`030n1oogoo009oo`03
0n1oogoo00Ioo`83h0=oo`030n1oogoo049oo`03001oogoo02Ioo`00:7oo00<007ooOol0Pgoo00<3
h7ooOol017oo0`?P4Goo00<3h7ooOol01Woo2P?P5Woo0P?P27oo00<3h7ooOol01goo00<3h7ooOol0
0Woo0P?P17oo00<3h7ooOol01Goo0`?P17oo00<3h7ooOol0@Woo00<007ooOol09Woo000XOol00`00
Oomoo`21Ool20n04Ool30n0COol:0n0MOol30n09Ool00`?POomoo`07Ool010?POomoogoo0P?P1Goo
00<3h7ooOol01Goo00<3h7oo0n0017oo00<3h7ooOol0@goo00<007ooOol09Woo000XOol00`00Oomo
o`20Ool010?POomoogoo0`?P3Goo2P?P97oo0P?P37oo00<3h7ooOol01Goo0P?P0goo00<3h7ooOol0
17oo00<3h7ooOol017oo10?P1Goo00<3h7ooOol0@goo00<007ooOol09Woo000NOol00`00Oomoo`07
Ool00`00Oomoo`1oOol00`?POol3h0020n07Ool90n09Ool00`?POomoo`0OOol30n0>Ool00`?POomo
o`04Ool010?POomoogoo0P?P1Goo0P?P1Woo00<3h7oo0n001goo00<3h7ooOol0@goo00<007ooOol0
17oo00<007ooOol07goo000NOol00`00Oomoo`07Ool00`00Oomoo`1mOol>0n0AOol00`?POomoo`0N
Ool20n0AOol00`?POomoo`03Ool01@?POomoogoo0n001Woo00<3h7ooOol017oo0P?P00=oo`?POol0
1goo00<3h7ooOol0@goo00<007ooOol017oo00<007ooOol07goo000OOol00`00Oomoo`06Ool3001l
OolQ0n0MOol30n0BOol00`?POomoo`03Ool00`?POomoo`020n06Ool00`?POomoo`04Ool010?POomo
o`?P2Goo00<3h7ooOol0@Goo0`001goo00<007ooOol07Woo000OOol00`00Oomoo`06Ool00`00Oomo
o`1mOol00`?POomoo`0JOol20n0KOol30n0EOol00`?POomoo`02Ool010?POol3h0?P1goo00<3h7oo
Ool00goo0P?P0Woo00<3h7ooOol01Woo0`?PAGoo00<007ooOol01Goo00<007ooOol07Woo000POol0
0`00Oomoo`05Ool00`00Oomoo`1mOol00`?POomoo`0HOol20n000goo0n1oo`0HOol20n0HOol01`?P
Oomoogoo0n1oo`?P00Moo`83h0Aoo`83h09oo`83h0Qoo`83h003Ool3h7oo04Aoo`03001oogoo00Io
o`03001oogoo01eoo`0087oo00<007ooOol01Goo00<007ooOol0OWoo00<3h7ooOol05Woo00@3h7oo
Ool3h1Moo`<3h1Uoo`040n1oogooOol30n07Ool00`?POomoo`03Ool01@?POomoogoo0n0027oo0P?P
0goo00<3h7ooOol0@goo00<007ooOol01Woo00<007ooOol07Goo000QOol00`00Oomoo`04Ool00`00
Oomoo`1oOol00`?POomoo`0COol20n03Ool00`?POomoo`0COol20n0LOol00`?POol3h0020n08Ool0
0`?POomoo`02Ool20n03Ool00`?POomoo`05Ool30n03Ool00`?POomoo`14Ool00`00Oomoo`07Ool0
0`00Oomoo`0LOol001eoo`D000Ioo`03001oogoo081oo`030n1oogoo015oo`030n1oogoo009oo`03
0n1oogoo015oo`<3h1ioo`@3h0Qoo`030n1oogoo009oo`030n1oogoo009oo`030n1oogoo00Eoo`03
0n1oo`?P00Aoo`030n1oogoo04Aoo`03001oogoo00=oo`D001ioo`00:7oo00<007ooOol0P7oo00<3
h7ooOol03goo0P?P1Goo00<3h7ooOol03goo0P?P87oo0`?P2Goo00@3h7ooOomoo`83h0=oo`83h0Io
o`@3h0Eoo`030n1oogoo04Aoo`03001oogoo02Ioo`00:7oo0P00PWoo00<3h7ooOol037oo0P?P1Woo
00<3h7ooOol03Goo0`?P87oo0`?P2Goo0P?P0goo00<3h7ooOol00Woo00<3h7ooOol01Goo00<3h7oo
0n001goo00<3h7ooOol0@Woo0`00:7oo000XOol00`00Oomoo`22Ool00`?POomoo`0:Ool00`?POomo
o`06Ool00`?POomoo`0:Ool30n0MOol70n000goo0n1oo`07Ool010?POomoogoo0P?P17oo00<3h7oo
Ool017oo0P?P00=oo`?POol01Goo0P?PAgoo00<007ooOol09Woo000XOol00`00Oomoo`22Ool20n09
Ool20n08Ool00`?POomoo`09Ool20n0KOol50n02Ool30n02Ool00`?POomoo`06Ool00`?POomoo`02
0n05Ool00`?POomoo`03Ool20n000goo0n03h006Ool00`?POomoo`17Ool00`00Oomoo`0VOol002Qo
o`03001oogoo08=oo`030n1oogoo00Ioo`030n1oogoo00Moo`030n1oogoo00Moo`<3h1Moo`H3h0Ao
o`<3h0Eoo`030n1oogoo00Eoo`040n1oogoo0n05Ool20n05Ool010?POomoo`?P1Woo0P?PBWoo00<0
07ooOol09Woo000XOol00`00Oomoo`24Ool00`?POomoo`03Ool20n0:Ool00`?POomoo`05Ool20n0D
Ool60n08Ool20n08Ool00`?POomoo`04Ool010?POol3h0?P1Goo00<3h7ooOol00goo0P?P0Woo00<3
h7ooOol017oo00<3h7ooOol0BWoo00<007ooOol09Woo000XOol00`00Oomoo`25Ool00`?POomoo`02
0n0;Ool00`?POomoo`03Ool30n0AOol50n0;Ool30n09Ool00`?POomoo`03Ool20n000goo0n1oo`05
Ool00`?POomoo`03Ool01@?POomoogoo0n001Goo0P?PCGoo00<007ooOol09Woo000XOol20026Ool3
0n0=Ool010?POomoogoo0P?P3Woo1P?P3Woo0P?P37oo00<3h7ooOol00Woo00@3h7oo0n03h0Ioo`03
0n1oogoo009oo`83h09oo`83h0Eoo`030n1oogoo04]oo`<002Qoo`00:7oo00<007ooOol0QGoo0P?P
3Goo00<3h7oo0n000P?P2goo1@?P4Goo0`?P3Woo00L3h7ooOomoo`?POol3h006Ool20n03Ool20n03
Ool00`?POomoo`03Ool20n1@Ool00`00Oomoo`0VOol002Qoo`03001oogoo08Aoo`040n1oogoo0n0;
Ool30n08Ool60n0COol30n0@Ool010?POomoogoo0`?P1Woo00<3h7ooOol00Woo00<3h7ooOol00Woo
00<3h7ooOol00goo00<3h7ooOol0D7oo00<007ooOol09Woo000XOol00`00Oomoo`22Ool20n04Ool0
0`?POomoo`06Ool30n04Ool60n0GOol20n0COol00`?POomoo`020n07Ool010?POomoogoo0P?P17oo
00<3h7ooOol00Woo0P?PDgoo00<007ooOol09Woo000XOol00`00Oomoo`20Ool20n06Ool20n04Ool3
0n000goo0n03h0040n0JOol30n0EOol30n08Ool01@?POomoogoo0n0017oo0P?P17oo00<3h7ooOol0
Dgoo00<007ooOol09Woo000IOol00`00Oomoo`02Ool30007Ool00`00Oomoo`1oOol00`?POomoo`07
Ool00`?POomoo`070n0MOol20n0GOol30n07Ool20n02Ool20n04Ool00`?POomoo`02Ool20n1FOol0
0`00Oomoo`05Ool00`00Oomoo`02Ool3000IOol001Uoo`05001oogooOol00003Ool00`00Oomoo`04
Ool3001mOol20n0;Ool30n04Ool00`?POomoo`0IOol30n0GOol30n08Ool01@?POomoogoo0n001Goo
00<3h7ooOol00Woo00<3h7ooOol0E7oo0`001goo00D007ooOomoo`0000=oo`03001oogoo01Ioo`00
6Goo00D007ooOomoo`0000=oo`03001oogoo00Aoo`03001oogoo07aoo`030n1oogoo00]oo`83h0Eo
o`030n1oogoo01Ioo`<3h1Ioo`D3h003Ool3h7oo00Ioo`030n1oogoo0083h0Eoo`040n1oogooOol2
0n1IOol00`00Oomoo`05Ool01@00Oomoogoo00000goo00<007ooOol05Woo000IOol01@00Oomoogoo
00000goo00<007ooOol017oo00<007ooOol0NWoo0P?P3Goo0`?P17oo00<3h7ooOol05Goo0P?P57oo
20?P0Woo00<3h7ooOol01Goo00@3h7oo0n03h0Eoo`83h0=oo`030n1oogoo05Uoo`03001oogoo00Eo
o`05001oogooOol00003Ool00`00Oomoo`0FOol001Uoo`05001oogooOol00003Ool00`00Oomoo`04
Ool00`00Oomoo`1hOol20n0?Ool010?POomoo`?P0goo00<3h7ooOol04Woo0`?P4Woo10?P0Woo0`?P
1Goo00<3h7ooOol017oo00<3h7oo0n001Woo00@3h7ooOomoo`83h5aoo`03001oogoo00Eoo`05001o
ogooOol00003Ool00`00Oomoo`0FOol001Uoo`05001oogooOol00003Ool00`00Oomoo`04Ool00`00
Oomoo`1gOol00`?POomoo`0?Ool01`?POomoogoo0n1oo`?P01=oo`83h15oo`@3h0Aoo`83h0Qoo`03
0n1oogoo009oo`@3h0Ioo`030n1oogoo0083h5ioo`03001oogoo00Eoo`05001oogooOol00003Ool0
0`00Oomoo`0FOol001Qoo`8000=oo`05001oogooOol00006Ool00`00Oomoo`1eOol20n0BOol01`?P
Oomoogoo0n1oo`?P011oo`<3h0ioo`D3h0Eoo`<3h0Yoo`070n1oogooOol3h7oo0n001goo00@3h7oo
Ool3h61oo`03001oogoo00Aoo`8000=oo`05001oogooOol0000HOol001Uoo`03001oogoo009oo`<0
00Moo`8007Eooa/3h0moo`83h0eoo`@3h0Moo`<3h0aoo`040n1oogooOol30n06Ool20n000goo0n03
h01OOol30007Ool00`00Oomoo`02Ool3000IOol002Qoo`03001oogoo079oo`83h1Aoo`83h004Ool3
h0?P0n0=Ool30n0:Ool50n09Ool20n0?Ool00`?POomoo`020n07Ool010?POomoo`?PHgoo00<007oo
Ool09Woo000XOol00`00Oomoo`1`Ool30n0EOol30n02Ool00`?POomoo`08Ool30n09Ool40n0;Ool3
0n0AOol30n08Ool010?POol3h0?PI7oo00<007ooOol09Woo000XOol00`00Oomoo`1^Ool20n000goo
0n1oo`0DOol20n03Ool00`?POomoo`07Ool20n08Ool40n0<Ool30n0COol30n07Ool20n000goo0n1o
o`1UOol00`00Oomoo`0VOol002Qoo`8006ioo`050n1oogooOol3h00COol40n03Ool00`?POomoo`04
Ool30n05Ool50n0>Ool20n0DOol30n08Ool010?POol3h0?PIGoo0`00:7oo000XOol00`00Oomoo`1[
Ool20n03Ool00`?POomoo`0@Ool20n02Ool20n02Ool00`?POomoo`03Ool20n04Ool40n0@Ool30n0B
Ool50n000goo0n1oo`06Ool00`?POol3h01YOol00`00Oomoo`0VOol002Qoo`03001oogoo06Uoo`83
h0Aoo`030n1oogoo00moo`83h0Aoo`83h003Ool3h7oo009oo`<3h003Ool3h0?P00<3h15oo`<3h15o
o`L3h0=oo`030n1oogoo00Aoo`<3h6Yoo`03001oogoo02Ioo`00:7oo00<007ooOol0Igoo0P?P1Goo
00<3h7ooOol03Goo0`?P1Woo00<3h7ooOol020?P57oo0P?P47oo10?P00Aoo`?P0n03h0Eoo`030n1o
ogoo00=oo`<3h6aoo`03001oogoo02Ioo`00:7oo00<007ooOol0IWoo00<3h7ooOol017oo00<3h7oo
Ool037oo0P?P27oo0P?P00=oo`?P0n000`?P5Goo0`?P3Woo10?P0goo0P?P27oo00<3h7ooOol00Woo
0`?PKGoo00<007ooOol09Woo000XOol2001UOol20n06Ool00`?POomoo`0;Ool20n0:Ool40n0FOol3
0n0=Ool40n04Ool30n0:Ool010?POomoogoo0P?PKGoo0`00:7oo000XOol00`00Oomoo`1ROol20n08
Ool00`?POomoo`09Ool20n0<Ool30n0EOol20n0<Ool40n05Ool30n0=Ool00`?POomoo`020n1`Ool0
0`00Oomoo`0VOol002Qoo`03001oogoo061oo`83h0Uoo`030n1oogoo00Qoo`83h0ioo`030n1oo`?P
019oo`<3h0Yoo`@3h0Moo`83h0moo`040n1oo`?P0n1bOol00`00Oomoo`0VOol002Qoo`03001oogoo
05moo`030n1oogoo00Qoo`030n1oogoo00Moo`83h0moo`<3h11oo`<3h0Qoo`D3h0Qoo`<3h15oo`<3
h7=oo`03001oogoo02Ioo`00:7oo0P00GWoo0P?P2Woo00<3h7ooOol01Goo0`?P4Goo0P?P3goo0P?P
1goo10?P2Woo0`?P4goo0P?PLgoo0`00:7oo000XOol00`00Oomoo`1KOol20n0;Ool00`?POomoo`04
Ool20n0COol30n0<Ool30n05Ool40n0<Ool20n0BOol40n1gOol00`00Oomoo`0VOol001Uoo`03001o
ogoo009oo`<000Moo`03001oogoo05Uoo`83h0aoo`030n1oogoo00=oo`83h1Eoo`83h0Yoo`<3h0Ao
o`@3h0eoo`<3h11oo`@3h7]oo`03001oogoo00Eoo`03001oogoo009oo`<001Uoo`006Goo00D007oo
Oomoo`0000=oo`03001oogoo00Aoo`03001oogoo05Qoo`030n1oogoo00]oo`030n1oogoo009oo`83
h1Ioo`<3h0Qoo`83h0=oo`@3h0ioo`<3h0moo`@3h7moo`03001oogoo00Eoo`05001oogooOol00003
Ool00`00Oomoo`0FOol001Uoo`03001oogoo00Eoo`03001oogoo00Aoo`<005Ioo`83h0ioo`030n1o
ogoo0083h1Aoo`L3h0Eoo`<3h003Ool3h0?P0083h11oo`83h0ioo`@3h85oo`<000Moo`03001oogoo
00Eoo`03001oogoo01Ioo`006Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0E7oo0P?P
3goo00@3h7oo0n03h0]oo`/3h09oo`<3h004Ool3h7ooOol70n0AOol30n0<Ool40n27Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`0FOol001Uoo`04001oogooOol40007Ool00`00Oomoo`1B
Ool20n0@Ool30n02Ool;0n0:Ool30n001Goo0n03h0?POol01@?P4Woo0`?P2goo10?PRgoo00<007oo
Ool01Goo00@007ooOomoo`@001Uoo`006Goo00D007ooOomoo`0000Yoo`80055ooaT3h1=oo`83h0=o
o`83h004Ool3h0?P0n0DOol20n0:Ool40n2=Ool30007Ool01@00Oomoogoo000077oo000HOol20003
Ool00`00Oomoo`08Ool00`00Oomoo`1>Ool30n0@Ool20n0FOol30n05Ool40n0COol30n08Ool40n2C
Ool00`00Oomoo`04Ool20003Ool00`00Oomoo`0JOol001Uoo`04001oogooOol50006Ool00`00Oomo
o`1<Ool20n000`0O0n1oo`0>Ool30n0DOol30n07Ool40n0AOol30n07Ool40n2GOol00`00Oomoo`05
Ool01000Oomoogoo1@0067oo000XOol00`00Oomoo`1:Ool20n000`0OOol3h00>Ool20n000goo0n1o
o`0BOol20n0:Ool010?POol3h0?P3goo0P?P1Woo10?PVgoo00<007ooOol09Woo000XOol20019Ool2
0n00100OOomoo`?P3Goo0P?P0goo00<3h7ooOol03Woo0`?P2goo0`?P00=oo`?POol02goo0`?P17oo
10?PWGoo0`00:7oo000XOol00`00Oomoo`16Ool20n001@0OOomoogoo0n0037oo0P?P17oo00<3h7oo
Ool03Goo0P?P3Woo0`?P00=oo`?POol027oo0`?P0goo10?PXgoo00<007ooOol09Woo000XOol00`00
Oomoo`14Ool20n000`0OOomoo`02Ool00`?POomoo`09Ool20n05Ool00`?POomoo`0;Ool30n0?Ool3
0n000goo0n1oo`07Ool20n02Ool40n2WOol00`00Oomoo`0VOol002Qoo`8004=oo`83h0807`Aoo`03
0n1oogoo00Qoo`83h0Ioo`030n1oogoo00Yoo`83h19oo`83h09oo`030n1oogoo00=oo`L3h:Uoo`<0
02Qoo`00:7oo00<007ooOol0@7oo0P?P0P0O1Goo00<3h7ooOol01goo0P?P1goo00<3h7ooOol027oo
0`?P4goo0P?P0goo00<3h7ooOol01P?P[goo00<007ooOol09Woo000XOol00`00Oomoo`0nOol20n02
01l7Ool00`?POomoo`05Ool20n08Ool00`?POomoo`07Ool20n0FOol20n02Ool00`?POol3h0030n2c
Ool00`00Oomoo`0VOol002Qoo`8003eoo`83h0807`Qoo`030n1oogoo00Aoo`83h0Uoo`030n1oogoo
00Eoo`<3h1Aoo`D3h0=oo`83h;Eoo`<002Qoo`005goo1@000Woo0`001goo00<007ooOol0>Woo0P?P
0P0O2Goo00<3h7ooOol00goo0P?P2Woo00<3h7ooOol00goo0`?P3goo30?P0goo00<3h7ooOol0]goo
00<007ooOol00goo1@000Woo0`006Goo000GOol00`00Oomoo`03Ool01@00Oomoogoo00001Woo00<0
07ooOol0>7oo0P?P00=l000OOol02Goo00<3h7ooOol00Woo0P?P37oo00@3h7ooOomoo`83h0Yoo`P3
h0Eoo`83h0=oo`83h09oo`030n1oogoo0;Qoo`03001oogoo00=oo`03001oogoo00=oo`05001oogoo
Ool0000HOol001Qoo`03001oogoo009oo`05001oogooOol00006Ool3000fOol20n000g`001l07`0:
Ool010?POomoogoo0P?P3Goo00<3h7oo0n000P?P1Goo1`?P2Woo0`?P17oo0P?P0Woo00<3h7ooOol0
]goo0`001Woo00<007ooOol00Woo00D007ooOomoo`0001Qoo`006Goo0P000Woo00D007ooOomoo`00
00Ioo`03001oogoo03Aoo`83h003O0007`0O00]oo`030n1oogoo0083h0ioo`/3h0ioo`<3h0Moo`04
0n1oogoo0n2lOol00`00Oomoo`05Ool20002Ool01@00Oomoogoo000067oo000KOol00`00Ool00003
Ool00`00Oomoo`04Ool00`00Oomoo`0bOol20n000g`001l07`0<Ool010?POol3h0?P37oo1`?P4goo
0`?P2Goo10?P_Goo00<007ooOol01goo00<007oo00000goo00<007ooOol05Woo000KOol00`00Ool0
0003Ool00`00Oomoo`04Ool00`00Oomoo`0`Ool20n000g`001l07`0=Ool30n06Ool;0n0EOol20n0;
Ool30n2oOol00`00Oomoo`07Ool00`00Ool00003Ool00`00Oomoo`0FOol001Moo`07001oogooOol0
07oo00000goo00<007ooOol017oo00<007ooOol0;Woo0P?P00=l000O01l03Woo0P?P00=oo`?P0n00
1@?P1Woo0P?P0Woo00<3h7ooOol047oo0`?P3Goo0P?P`7oo00<007ooOol00goo00L007ooOomoo`00
Ool00003Ool00`00Oomoo`0FOol001Qoo`<000=oo`<000Moo`03001oogoo02eooaL3h0]oo`83h0=o
o`030n1oogoo00ioo`<3h0moo`83h<5oo`03001oogoo00Aoo`<000=oo`<001Uoo`00:7oo00<007oo
Ool0:goo0W`000<3h00O01l03Goo00<07`?P0n003Goo0P?P17oo00<3h7ooOol037oo0`?P4Woo00<3
h7ooOol0`7oo00<007ooOol09Woo000XOol00`00Oomoo`0XOol3O00201l00`?POomoo`0:Ool301l2
0n0<Ool20n05Ool00`?POomoo`0:Ool30n0BOol30n33Ool00`00Oomoo`0VOol002Qoo`03001oogoo
02Ioo`9l0003Ool07`0O00807`030n1oogoo00Qoo`807`9oo`030n007`?P00Yoo`83h0Moo`030n1o
ogoo00Qoo`83h0moo`H3h<Ioo`03001oogoo02Ioo`00:7oo00<007ooOol08goo0g`00`0O00Al000O
Ool3h0Qoo`<07`9oo`83h00301l3h7oo00Qoo`83h0Qoo`030n1oogoo00Ioo`<3h0]oo`H3h<aoo`03
001oogoo02Ioo`00:7oo00<007ooOol087oo0g`000=oo`0O01l00Woo0P0O0Woo00<3h7ooOol017oo
0P0O17oo00@3h7oo01l3h0Moo`0301l3h0?P00Uoo`030n1oogoo00Aoo`<3h0Qoo`H3h=9oo`03001o
ogoo02Ioo`00:7oo00<007ooOol07Goo0g`00Woo0P0O0goo00<07gooOol00Woo00@3h7ooOomoo`<0
7`Aoo`83h003Ool07`?P00Ioo`0301l3h0?P00Yoo`030n1oogoo009oo`<3h0Eoo`H3h=Qoo`03001o
ogoo02Ioo`00:7oo00<007ooOol06Woo0g`00Woo0`0O0goo0P0O1Goo00@3h00O01l07`Ioo`060n1o
ogooOol07`?P17oo00<07`?P0n0037oo00<3h7ooOol00P?P0Woo1P?PgWoo00<007ooOol09Woo000X
Ool00`00Oomoo`0HOol2O003Ool201l5Ool00`0OOomoo`04Ool00`0O0n1l0007Ool01P?POomoogoo
01l3h0=oo`0301l3h0?P00eoo`P3h>Aoo`03001oogoo02Ioo`00:7oo00<007ooOol05Goo0g`00goo
0P0O1Woo00<07gooOol00Woo0`0O00=l00?POol01Goo0P?P0goo00D07`?POomoo`0O0083h0]oo`03
01l3h0?P00<3h>Yoo`03001oogoo02Ioo`00:7oo00<007ooOol04Woo0g`017oo0P0O1Woo0P0O0goo
0P0O00El07ooOomoo`?P00Eoo`030n1oogoo009oo`0401l3h7oo01l20n07Ool00`0O0n03h0040n3_
Ool00`00Oomoo`0VOol002Qoo`03001oogoo00moo`=l00Aoo`<07`Moo`0301moogoo00<07`03O01o
ogoo00=oo`040n1oogooOol20n04Ool00`0OOol3h0020n03Ool00`0O0n03h0040n3eOol00`00Oomo
o`0VOol002Qoo`03001oogoo00aoo`=l00Eoo`807`Qoo`807`04Ool07`0OO007Ool01@?POomoogoo
0n001Goo0P0O20?Pngoo00<007ooOol09Woo000XOol00`00Oomoo`0:Ool2O006Ool201l9Ool401l0
0g`0Oomoo`07Ool010?POomoo`?P1@0O1@?Pogoo0Woo00<007ooOol09Woo000XOol00`00Oomoo`07
Ool3O006Ool201l9Ool301l00g`0Oomoo`0:01l90n3oOol7Ool00`00Oomoo`0VOol002Qoo`03001o
ogoo00Eoo`Ul01<07`03O01oogoo00Moo`<3h?moo`eoo`03001oogoo02Ioo`0067oo0`000goo0`00
1goo00<007ooOol0ogoo>goo00<007ooOol017oo0`000goo0`006Goo000GOol01`00Oomoogoo001o
o`0000=oo`03001oogoo00Aoo`<00?moocUoo`<000Eoo`07001oogooOol007oo00000goo00<007oo
Ool05Woo000KOol00`00Ool00003Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`0mOol0
0`00Oomoo`0nOol00`00Oomoo`0mOol00`00Oomoo`0mOol00`00Oomoo`0`Ool00`00Oomoo`07Ool0
0`00Ool00003Ool00`00Oomoo`0FOol001]oo`03001oo`0000=oo`03001oogoo00Aoo`03001oogoo
00Ioo`03001oogoo02Uoo`03001oogoo00=oo`05001oogooOol00002Ool01000Ool007oo1000:goo
00<007ooOol017oo00@007ooOol0009oo`04001oo`00Ool200000goo0000000[Ool00`00Oomoo`03
Ool03000Oomoogoo001oo`00Ool007oo001oo`<002]oo`03001oogoo00=oo`05001oogooOol00002
Ool01@00Ool00000Ool00`00<Woo00<007ooOol01goo00<007oo00000goo00<007ooOol05Woo000I
Ool20002Ool01@00Oomoogoo00001Wooo`00?`001goo0P000Woo00D007ooOomoo`0001Qoo`006goo
00<007oo00000goo00<007ooOol0ogooC7oo00<007oo00000goo00<007ooOol05Woo000GOol01`00
Oomoogoo001oo`0000=oo`03001oogoo0?moodQoo`07001oogooOol007oo00000goo00<007ooOol0
5Woo000HOol30003Ool3003oOom<Ool30003Ool3000IOol00?moohmoo`00ogooSgoo003oOon?Ool0
0?moohmoo`007Woo00<007ooOol00Woo00<007oo00000goo00<007ooOol00goo00<007ooOol00Woo
0`009goo00<007ooOol00Woo00@007ooOol000=oo`03001oogoo00=oo`03001oogoo009oo`<002Qo
o`03001oogoo009oo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`02Ool3000WOol30003
Ool00`00Oomoo`030003Ool30003Ool30003Ool30004Ool00`00Oomoo`0TOol30003Ool00`00Oomo
o`030004Ool00`00Oomoo`1AOol001ioo`03001oogoo00Eoo`03001oo`0000Ioo`05001oogooOol0
0003Ool00`00Oomoo`0TOol00`00Oomoo`06Ool00`00Ool00006Ool01@00Oomoogoo00000goo00<0
07ooOol09Goo00<007ooOol01Woo00<007oo00001Woo00D007ooOomoo`0000=oo`03001oogoo02=o
o`05001oogooOol00004Ool01`00Oomoogoo001oo`0000=oo`03001oo`0000=oo`03001oo`0000=o
o`05001oogooOol0000UOol01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03001oogoo055o
o`007Woo00<007ooOol01Woo00<007ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo02Aoo`03
001oogoo00Moo`03001oogoo00Eoo`05001oogooOol00003Ool00`00Oomoo`0UOol00`00Oomoo`07
Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00<007ooOol08goo00D007ooOomoo`0000Aoo`07
001oogooOol007oo00000goo00<007oo00000goo00<007oo00000goo00D007ooOomoo`0002Eoo`05
001oogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol0DGoo000NOol00`00Oomoo`05Ool0
0`00Ool00006Ool01@00Oomoogoo00000goo00<007ooOol097oo00<007ooOol01Woo00<007oo0000
1Woo00D007ooOomoo`0000=oo`03001oogoo02Eoo`03001oogoo00Ioo`03001oo`0000Ioo`05001o
ogooOol00003Ool00`00Oomoo`0SOol01@00Oomoogoo000017oo00L007ooOomoo`00Ool00003Ool0
0`00Ool00003Ool00`00Ool00003Ool01@00Oomoogoo00009Goo00D007ooOomoo`0000Aoo`05001o
ogooOol00003Ool00`00Oomoo`1AOol001ioo`03001oogoo00Aoo`05001oogooOol00005Ool01@00
Oomoogoo00000goo00<007ooOol097oo00<007ooOol01Goo00D007ooOomoo`0000Eoo`05001oogoo
Ool00003Ool00`00Oomoo`0UOol00`00Oomoo`05Ool01@00Oomoogoo00001Goo00D007ooOomoo`00
00=oo`03001oogoo02=oo`05001oogooOol00004Ool01`00Oomoogoo001oo`0000=oo`03001oo`00
00=oo`03001oo`0000=oo`05001oogooOol0000UOol01@00Oomoogoo000017oo00D007ooOomoo`00
00=oo`03001oogoo055oo`007Woo00<007ooOol03Woo00D007ooOomoo`0000=oo`03001oogoo00Eo
o`05001oogooOol0000JOol00`00Oomoo`0?Ool01@00Oomoogoo00000goo00<007ooOol017oo00D0
07ooOomoo`0001aoo`03001oogoo00moo`05001oogooOol00003Ool00`00Oomoo`03Ool2000NOol0
1@00Oomoogoo000017oo00L007ooOomoo`00Ool00003Ool00`00Ool00003Ool00`00Ool00003Ool0
1@00Oomoogoo00009Goo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`1AOol0
01eoo`8000moo`8000=oo`04001oogooOol50003Ool00`00Ool00003000HOol2000@Ool20003Ool0
1000Oomoogoo1@000Woo00D007ooOomoo`0001]oo`80011oo`8000=oo`04001oogooOol60002Ool0
0`00Oomoo`0KOol01@00Oomoogoo000017oo00L007ooOomoo`00Ool00003Ool00`00Ool00003Ool0
0`00Ool00003Ool00`00Oomoo`02000UOol01@00Oomoogoo000017oo00D007ooOomoo`00009oo`80
05=oo`007Woo00<007ooOol03Woo00<007ooOol00Woo0`0027oo00<007ooOol00P006Woo00<007oo
Ool03goo00<007ooOol00Woo0`001goo00D007ooOomoo`0001aoo`03001oogoo00moo`03001oogoo
009oo`<000Ioo`8001moo`<000Ioo`<000=oo`<000=oo`<000=oo`<000Aoo`03001oogoo02Aoo`<0
00Ioo`<000Aoo`03001oogoo055oo`00?goo00<007ooOol00P00>goo00D007ooOomoo`0003]oo`04
001oogoo003;Ool003moo`05001oogooOol0000kOol01@00Oomoogoo0000?7oo0P00c7oo003oOon?
Ool00?moohmoo`00lgoo0`005Goo0`00P7oo003bOol01@00Oomoogoo00004goo00D007ooOomoo`00
07moo`00mWoo00<007ooOol05Goo00<007ooOol0OGoo001POol00`00Oomoo`05Ool01000Oomoogoo
0`000goo0P001Goo0`000goo00<007ooOol017oo00D007ooOomoo`0000Aoo`<000=oo`05001oogoo
Ool00003Ool00`00Oomoo`04Ool00`00Oomoo`03Ool20006Ool30003Ool01@00Oomoogoo000017oo
0`000goo00<007ooOol01Goo0`000goo00D007ooOomoo`0000Eoo`<00003Ool007oo00=oo`04001o
ogooOol30004Ool200000goo001oo`08Ool01000Oomoogoo0`0017oo0P0000=oo`00Ool017oo0P00
17oo0`0017oo0`0000Aoo`00Ool000=oo`<0061oo`00H7oo00<007ooOol01Goo00@007ooOol000=o
o`04001oogoo0005Ool01@00Oomoogoo00000Woo00<007ooOol017oo00D007ooOomoo`0000=oo`05
001oogooOol00002Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007ooOol00Woo00@007oo
Ool000Aoo`05001oogooOol00002Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`03001o
ogoo00Aoo`05001oogooOol00002Ool01@00Oomoogoo000017oo00D007ooOomoo`0000Eoo`04001o
ogoo0003Ool01000Oomoo`000Woo0P002Goo00@007ooOol000=oo`04001oogoo0002Ool20004Ool0
1000Oomoo`000Woo00D007ooOomoo`00009oo`05001oogooOol00002Ool01000Oomoo`000goo00<0
07ooOol0GGoo001POol00`00Oomoo`05Ool01000Oomoo`000goo00@007ooOol000Eoo`05001oogoo
Ool00002Ool00`00Oomoo`03Ool01`00Ool007oo001oo`00009oo`05001oogooOol00002Ool01`00
Oomoogoo001oo`0000Moo`03001oo`0000Ioo`03001oogoo009oo`03001oogoo00Aoo`05001oogoo
Ool00003Ool01@00Oomoogoo00000Woo00<007ooOol017oo00D007ooOomoo`00009oo`05001oogoo
Ool00004Ool01@00Oomoogoo00001Goo00@007ooOol000=oo`04001oogoo0003Ool00`00Oomoo`07
Ool01000Oomoo`000goo00@007ooOol000=oo`03001oogoo00Eoo`04001oogoo0006Ool01@00Oomo
ogoo00000Woo00@007ooOol006=oo`00H7oo00<007ooOol01Goo00@007ooOol000=oo`04001oogoo
0005Ool01@00Oomoogoo00000Woo00<007ooOol00goo00@007ooOol0009oo`04001oogoo0003Ool0
1000Oomoo`000goo0P0027oo00<007oo000017oo0P001Goo1@000Woo00D007ooOomoo`0000=oo`05
001oogooOol00002Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000Eoo`@0
00Eoo`04001oogoo0003Ool01000Oomoo`000goo00<007oo00001P0000Eoo`00Oomoo`0000=oo`04
001oogoo0003Ool00`00Oomoo`03Ool20003Ool00`00Oomoo`05Ool40002Ool00`00Oomoo`05001O
Ool0061oo`D000=oo`04001oogoo0003Ool01000Oomoo`001Goo00D007ooOomoo`00009oo`03001o
ogoo00=oo`04001oogoo0002Ool01000Oomoo`000goo00@007ooOol000=oo`8000Moo`05001oogoo
Ool00002Ool00`00Oomoo`05Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000=oo`05001oogoo
Ool00002Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000Qoo`03001oogoo
00=oo`04001oogoo0003Ool01000Oomoo`000goo00<007ooOol01goo00@007ooOol000=oo`04001o
ogoo0003Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`08Ool01000Oomoo`000Woo00D0
07ooOomoo`0005moo`00H7oo00<007ooOol00Woo00@007ooOol0009oo`05001oogooOol00002Ool0
0`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001o
o`0000=oo`03001oogoo0080009oo`03001oo`0000Ioo`05001oogooOol00002Ool01000Oomoo`00
17oo00D007ooOomoo`00009oo`80009oo`80009oo`05001oogooOol00002Ool20005Ool01@00Oomo
ogoo00000Woo0P000Woo00<007ooOol00Woo00D007ooOomoo`0000Eoo`04001oogoo0003Ool01000
Oomoo`000Woo0P002Goo00@007ooOol000=oo`04001oogoo0002Ool20004Ool01000Oomoo`000Woo
00D007ooOomoo`00009oo`05001oogooOol00002Ool01000Oomoo`000goo00<007ooOol0GGoo001P
Ool00`00Oomoo`02Ool01000Oomoo`000goo0`000Woo0`001Goo0`000Woo0`000goo00D007ooOomo
o`0000=oo`03001oogoo00<000=oo`05001oo`00Ool00002Ool00`00Oomoo`03Ool01@00Oomoogoo
00000goo0P001Woo0`000goo00L007oo001oo`00Ool00002Ool30003Ool00`00Ool00005Ool30003
Ool01000Ool000001Woo0`001Woo00@007ooOomoo`<000Aoo`800003Ool007oo00Qoo`04001oogoo
Ool30004Ool200000goo001oo`04Ool20004Ool30004Ool30003Ool01000Oomoogoo0`00H7oo001P
Ool00`00Oomoo`02Ool01000Oomoo`002Goo00<007ooOol02Woo00<007ooOol05goo00<007ooOol0
C7oo00<007ooOol05Goo00<007ooOol097oo00<007ooOol0I7oo001POol50003Ool00`00Oomoo`07
Ool00`00Oomoo`0;Ool2000GOol00`00Oomoo`1<Ool00`00Oomoo`0EOol00`00Oomoo`0TOol00`00
Oomoo`1TOol00001\
\>"],
  ImageRangeCache->{{{93.5625, 590.812}, {531.688, 224.812}} -> {-19.8092, \
1.23208, 0.046672, 0.00785321}}],

Cell["\<\
Approximately two decimal digits of accuracy are gained by using \
the increment-based formulation throughout the extrapolation process.\
\>", \
"Text"],

Cell["\<\
This compares the relative error in the integration data that forms \
the initial column of the extrapolation table for the previous example.\
\>", \
"Text"],

Cell["\<\
Reference values were computed using software arithmetic with 32 \
decimal digits and converted to the nearest IEEE double-precision \
floating-point numbers, where an ULP signifies a Unit in the Last Place or \
Unit in the Last Position.\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        FrameBox[GridBox[{
              {
                " ", \(T\_11\), \(T\_21\), \(T\_31\), \(T\_41\), \(T\_51\), \
\(T\_61\), \(T\_71\), \(T\_81\)},
              {\(Standard\ formulation\), "0", \(\(-1\)\ ULP\), 
                "0", \(1\ ULP\), "0", \(1.5\ ULPs\), "0", \(1\ ULP\)},
              {\(Increment\ formulation\[IndentingNewLine]
                applied\ to\ the\ base\ method\), "0", "0", "0", 
                "0", \(1\ ULP\), "0", "0", \(1\ ULP\)}
              },
            RowLines->True,
            ColumnLines->True]], TraditionalForm]]],
  Cell[BoxData[
      \(TraditionalForm\`\ \)]]
}], "Text"],

Cell[TextData[{
  "Notice that the rounding error model that was used to motivate the study \
of rounding error growth is limited because in practice errors in ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i, \ 1\)\)]],
  " can exceed 1 ULP."
}]],

Cell[TextData[{
  "The increment formulation used throughout the extrapolation process \
produces rounding errors",
  " ",
  "in ",
  Cell[BoxData[
      \(TraditionalForm\`T\_\(i, \ 1\)\)]],
  "that are smaller than 1 ULP."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method comparison", "Subsubsection"],

Cell[TextData[{
  "This compares the work required for extrapolation based on ",
  StyleBox["ExplicitEuler", "MR"],
  " (red), the ",
  StyleBox["ExplicitMidpoint", "MR"],
  " (blue), and ",
  StyleBox["ExplicitModifiedMidpoint", "MR"],
  " (green)."
}], "Text"],

Cell["\<\
All computations are carried out using software arithmetic with 32 \
decimal digits.\
\>", "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10  scalefont  setfont
% Scaling calculations
0.97619 0.0418789 0.0147151 0.33522 [
[.01298 -0.0125 -23.4688 -14.375 ]
[.01298 -0.0125 23.4688 0 ]
[.18049 -0.0125 -23.4688 -14.375 ]
[.18049 -0.0125 23.4688 0 ]
[.34801 -0.0125 -23.4688 -14.375 ]
[.34801 -0.0125 23.4688 0 ]
[.51552 -0.0125 -23.4688 -14.375 ]
[.51552 -0.0125 23.4688 0 ]
[.68304 -0.0125 -21.5 -14.25 ]
[.68304 -0.0125 21.5 0 ]
[.85055 -0.0125 -14.375 -11.1875 ]
[.85055 -0.0125 14.375 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -9.5 -5.59375 ]
[-0.0125 .01472 0 5.59375 ]
[-0.0125 .11563 -9.5 -5.59375 ]
[-0.0125 .11563 0 5.59375 ]
[-0.0125 .24902 -9.5 -5.59375 ]
[-0.0125 .24902 0 5.59375 ]
[-0.0125 .34993 -15 -5.59375 ]
[-0.0125 .34993 0 5.59375 ]
[-0.0125 .45085 -15 -5.59375 ]
[-0.0125 .45085 0 5.59375 ]
[-0.0125 .58424 -15 -5.59375 ]
[-0.0125 .58424 0 5.59375 ]
[ 0 0 -0.125 0 ]
[.01298 .63053 -23.4688 0 ]
[.01298 .63053 23.4688 14.375 ]
[.18049 .63053 -23.4688 0 ]
[.18049 .63053 23.4688 14.375 ]
[.34801 .63053 -23.4688 0 ]
[.34801 .63053 23.4688 14.375 ]
[.51552 .63053 -23.4688 0 ]
[.51552 .63053 23.4688 14.375 ]
[.68304 .63053 -21.5 0 ]
[.68304 .63053 21.5 14.25 ]
[.85055 .63053 -14.375 0 ]
[.85055 .63053 14.375 11.1875 ]
[ 0 .61803 .125 0 ]
[1.0125 .01472 0 -5.59375 ]
[1.0125 .01472 9.5 5.59375 ]
[1.0125 .11563 0 -5.59375 ]
[1.0125 .11563 9.5 5.59375 ]
[1.0125 .24902 0 -5.59375 ]
[1.0125 .24902 9.5 5.59375 ]
[1.0125 .34993 0 -5.59375 ]
[1.0125 .34993 15 5.59375 ]
[1.0125 .45085 0 -5.59375 ]
[1.0125 .45085 15 5.59375 ]
[1.0125 .58424 0 -5.59375 ]
[1.0125 .58424 15 5.59375 ]
[ 1 0 .125 0 ]
[.5 .63053 -105.219 14.375 ]
[.5 .63053 105.219 27.6875 ]
[ -0.0005 -0.0005 0 0 ]
[ 1.0005 .61853 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01298 0 m
.01298 .00625 L
s
gsave
.01298 -0.0125 -84.4688 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(23) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.18049 0 m
.18049 .00625 L
s
gsave
.18049 -0.0125 -84.4688 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(19) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34801 0 m
.34801 .00625 L
s
gsave
.34801 -0.0125 -84.4688 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(15) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.51552 0 m
.51552 .00625 L
s
gsave
.51552 -0.0125 -84.4688 -18.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68304 0 m
.68304 .00625 L
s
gsave
.68304 -0.0125 -82.5 -18.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.188 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.188 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.188 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.188 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 9.875 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 9.875 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 9.875 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
100.125 9.875 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.85055 0 m
.85055 .00625 L
s
gsave
.85055 -0.0125 -75.375 -15.1875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.001) show
87.750 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.14054 0 m
.14054 .00375 L
s
.15314 0 m
.15314 .00375 L
s
.16051 0 m
.16051 .00375 L
s
.16574 0 m
.16574 .00375 L
s
.1698 0 m
.1698 .00375 L
s
.17312 0 m
.17312 .00375 L
s
.17592 0 m
.17592 .00375 L
s
.17835 0 m
.17835 .00375 L
s
.30806 0 m
.30806 .00375 L
s
.32066 0 m
.32066 .00375 L
s
.32803 0 m
.32803 .00375 L
s
.33326 0 m
.33326 .00375 L
s
.33732 0 m
.33732 .00375 L
s
.34063 0 m
.34063 .00375 L
s
.34344 0 m
.34344 .00375 L
s
.34586 0 m
.34586 .00375 L
s
.47557 0 m
.47557 .00375 L
s
.48817 0 m
.48817 .00375 L
s
.49554 0 m
.49554 .00375 L
s
.50078 0 m
.50078 .00375 L
s
.50483 0 m
.50483 .00375 L
s
.50815 0 m
.50815 .00375 L
s
.51095 0 m
.51095 .00375 L
s
.51338 0 m
.51338 .00375 L
s
.64309 0 m
.64309 .00375 L
s
.65569 0 m
.65569 .00375 L
s
.66306 0 m
.66306 .00375 L
s
.66829 0 m
.66829 .00375 L
s
.67235 0 m
.67235 .00375 L
s
.67566 0 m
.67566 .00375 L
s
.67847 0 m
.67847 .00375 L
s
.6809 0 m
.6809 .00375 L
s
.81061 0 m
.81061 .00375 L
s
.8232 0 m
.8232 .00375 L
s
.83058 0 m
.83058 .00375 L
s
.83581 0 m
.83581 .00375 L
s
.83986 0 m
.83986 .00375 L
s
.84318 0 m
.84318 .00375 L
s
.84598 0 m
.84598 .00375 L
s
.84841 0 m
.84841 .00375 L
s
.97812 0 m
.97812 .00375 L
s
.99072 0 m
.99072 .00375 L
s
.99809 0 m
.99809 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
gsave
-0.0125 .01472 -70.5 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .11563 m
.00625 .11563 L
s
gsave
-0.0125 .11563 -70.5 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .24902 m
.00625 .24902 L
s
gsave
-0.0125 .24902 -70.5 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .34993 m
.00625 .34993 L
s
gsave
-0.0125 .34993 -76 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .45085 m
.00625 .45085 L
s
gsave
-0.0125 .45085 -76 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .58424 m
.00625 .58424 L
s
gsave
-0.0125 .58424 -76 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(50) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
0 .17466 m
.00375 .17466 L
s
0 .21654 m
.00375 .21654 L
s
0 .27557 m
.00375 .27557 L
s
0 .29801 m
.00375 .29801 L
s
0 .31745 m
.00375 .31745 L
s
0 .3346 m
.00375 .3346 L
s
0 .50988 m
.00375 .50988 L
s
0 .55176 m
.00375 .55176 L
s
0 .61079 m
.00375 .61079 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.01298 .61178 m
.01298 .61803 L
s
gsave
.01298 .63053 -84.4688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(23) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.18049 .61178 m
.18049 .61803 L
s
gsave
.18049 .63053 -84.4688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(19) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34801 .61178 m
.34801 .61803 L
s
gsave
.34801 .63053 -84.4688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(15) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.51552 .61178 m
.51552 .61803 L
s
gsave
.51552 .63053 -84.4688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.312 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.312 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.312 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 10.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
104.062 10.000 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68304 .61178 m
.68304 .61803 L
s
gsave
.68304 .63053 -82.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 15.188 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
%%BeginResource: font Helvetica-MISO
%%BeginFont: Helvetica-MISO
/Helvetica /Helvetica-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.188 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
71.250 15.188 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
72.750 15.188 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
80.625 15.188 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
91.625 9.875 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
91.625 9.875 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
96.188 9.875 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
100.125 9.875 moveto
%%IncludeResource: font Helvetica-MISO
%%IncludeFont: Helvetica-MISO
/Helvetica-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.85055 .61178 m
.85055 .61803 L
s
gsave
.85055 .63053 -75.375 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.001) show
87.750 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.14054 .61428 m
.14054 .61803 L
s
.15314 .61428 m
.15314 .61803 L
s
.16051 .61428 m
.16051 .61803 L
s
.16574 .61428 m
.16574 .61803 L
s
.1698 .61428 m
.1698 .61803 L
s
.17312 .61428 m
.17312 .61803 L
s
.17592 .61428 m
.17592 .61803 L
s
.17835 .61428 m
.17835 .61803 L
s
.30806 .61428 m
.30806 .61803 L
s
.32066 .61428 m
.32066 .61803 L
s
.32803 .61428 m
.32803 .61803 L
s
.33326 .61428 m
.33326 .61803 L
s
.33732 .61428 m
.33732 .61803 L
s
.34063 .61428 m
.34063 .61803 L
s
.34344 .61428 m
.34344 .61803 L
s
.34586 .61428 m
.34586 .61803 L
s
.47557 .61428 m
.47557 .61803 L
s
.48817 .61428 m
.48817 .61803 L
s
.49554 .61428 m
.49554 .61803 L
s
.50078 .61428 m
.50078 .61803 L
s
.50483 .61428 m
.50483 .61803 L
s
.50815 .61428 m
.50815 .61803 L
s
.51095 .61428 m
.51095 .61803 L
s
.51338 .61428 m
.51338 .61803 L
s
.64309 .61428 m
.64309 .61803 L
s
.65569 .61428 m
.65569 .61803 L
s
.66306 .61428 m
.66306 .61803 L
s
.66829 .61428 m
.66829 .61803 L
s
.67235 .61428 m
.67235 .61803 L
s
.67566 .61428 m
.67566 .61803 L
s
.67847 .61428 m
.67847 .61803 L
s
.6809 .61428 m
.6809 .61803 L
s
.81061 .61428 m
.81061 .61803 L
s
.8232 .61428 m
.8232 .61803 L
s
.83058 .61428 m
.83058 .61803 L
s
.83581 .61428 m
.83581 .61803 L
s
.83986 .61428 m
.83986 .61803 L
s
.84318 .61428 m
.84318 .61803 L
s
.84598 .61428 m
.84598 .61803 L
s
.84841 .61428 m
.84841 .61803 L
s
.97812 .61428 m
.97812 .61803 L
s
.99072 .61428 m
.99072 .61803 L
s
.99809 .61428 m
.99809 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
gsave
1.0125 .01472 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .11563 m
1 .11563 L
s
gsave
1.0125 .11563 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .24902 m
1 .24902 L
s
gsave
1.0125 .24902 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
68.500 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .34993 m
1 .34993 L
s
gsave
1.0125 .34993 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .45085 m
1 .45085 L
s
gsave
1.0125 .45085 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .58424 m
1 .58424 L
s
gsave
1.0125 .58424 -61 -9.59375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(50) show
74.000 12.125 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.99625 .17466 m
1 .17466 L
s
.99625 .21654 m
1 .21654 L
s
.99625 .27557 m
1 .27557 L
s
.99625 .29801 m
1 .29801 L
s
.99625 .31745 m
1 .31745 L
s
.99625 .3346 m
1 .3346 L
s
.99625 .50988 m
1 .50988 L
s
.99625 .55176 m
1 .55176 L
s
.99625 .61079 m
1 .61079 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -166.219 10.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.3125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Plot) show
86.875 13.688 moveto
(of) show
100.125 13.688 moveto
(work) show
128.625 13.688 moveto
(vs) show
143.938 13.688 moveto
(error) show
172.312 13.688 moveto
(on) show
188.875 13.688 moveto
(a) show
198.812 13.688 moveto
(log) show
214.688 13.688 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
222.375 13.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(log) show
241.562 13.688 moveto
(scale) show
269.438 13.688 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .271 0 r
.5 Mabswid
.88951 .01472 m
.87732 .11563 L
.82092 .11563 L
.88951 .01472 L
s
.87732 .11563 m
.87008 .17466 L
.80099 .21654 L
.87732 .11563 L
s
.87008 .17466 m
.86492 .21654 L
.78838 .27557 L
.87008 .17466 L
s
.86492 .21654 m
.8609 .24902 L
.77909 .31745 L
.86492 .21654 L
s
.8609 .24902 m
.85761 .27557 L
.77171 .34993 L
.8609 .24902 L
s
.85761 .27557 m
.85482 .29801 L
.76558 .37648 L
.85761 .27557 L
s
.82092 .11563 m
.80099 .21654 L
.70289 .21654 L
.82092 .11563 L
s
.80099 .21654 m
.78838 .27557 L
.6208 .29801 L
.80099 .21654 L
s
.78838 .27557 m
.77909 .31745 L
.64782 .34993 L
.78838 .27557 L
s
.77909 .31745 m
.77171 .34993 L
.64277 .38813 L
.77909 .31745 L
s
.77171 .34993 m
.76558 .37648 L
.63621 .41836 L
.77171 .34993 L
s
.70289 .21654 m
.6208 .29801 L
.68369 .29801 L
.70289 .21654 L
s
.6208 .29801 m
.64782 .34993 L
.65538 .36381 L
.6208 .29801 L
s
.64782 .34993 m
.64277 .38813 L
.63574 .40896 L
.64782 .34993 L
s
.64277 .38813 m
.63621 .41836 L
.62051 .44338 L
.64277 .38813 L
s
.68369 .29801 m
.65538 .36381 L
.6055 .36381 L
.68369 .29801 L
s
.65538 .36381 m
.63574 .40896 L
.57073 .41836 L
.65538 .36381 L
s
.63574 .40896 m
.62051 .44338 L
.54676 .45795 L
.63574 .40896 L
s
.6055 .36381 m
.57073 .41836 L
.53657 .41836 L
.6055 .36381 L
s
.57073 .41836 m
.54676 .45795 L
.50386 .46472 L
.57073 .41836 L
s
.53657 .41836 m
.50386 .46472 L
.47047 .46472 L
.53657 .41836 L
s
.274 .51 .706 r
.82092 .11563 m
.79577 .21654 L
.69818 .24902 L
.82092 .11563 L
s
.79577 .21654 m
.78103 .27557 L
.6584 .3346 L
.79577 .21654 L
s
.78103 .27557 m
.77057 .31745 L
.63323 .38813 L
.78103 .27557 L
s
.77057 .31745 m
.76245 .34993 L
.61466 .42719 L
.77057 .31745 L
s
.76245 .34993 m
.75582 .37648 L
.59992 .45795 L
.76245 .34993 L
s
.75582 .37648 m
.75022 .39892 L
.58768 .48333 L
.75582 .37648 L
s
.69818 .24902 m
.6584 .3346 L
.57678 .34993 L
.69818 .24902 L
s
.6584 .3346 m
.63323 .38813 L
.52667 .41836 L
.6584 .3346 L
s
.63323 .38813 m
.61466 .42719 L
.49341 .46472 L
.63323 .38813 L
s
.61466 .42719 m
.59992 .45795 L
.46822 .49983 L
.61466 .42719 L
s
.59992 .45795 m
.58768 .48333 L
.44788 .5281 L
.59992 .45795 L
s
.57678 .34993 m
.52667 .41836 L
.4538 .42719 L
.57678 .34993 L
s
.52667 .41836 m
.49341 .46472 L
.39575 .48333 L
.52667 .41836 L
s
.49341 .46472 m
.46822 .49983 L
.3559 .52375 L
.49341 .46472 L
s
.46822 .49983 m
.44788 .5281 L
.32512 .55535 L
.46822 .49983 L
s
.4538 .42719 m
.39575 .48333 L
.33037 .48904 L
.4538 .42719 L
s
.39575 .48333 m
.3559 .52375 L
.26589 .53642 L
.39575 .48333 L
s
.3559 .52375 m
.32512 .55535 L
.22049 .5721 L
.3559 .52375 L
s
.33037 .48904 m
.26589 .53642 L
.20663 .54041 L
.33037 .48904 L
s
.26589 .53642 m
.22049 .5721 L
.13678 .5813 L
.26589 .53642 L
s
.20663 .54041 m
.13678 .5813 L
.08267 .58424 L
.20663 .54041 L
s
.486 .988 0 r
.80835 .17466 m
.78317 .24902 L
.6726 .29801 L
.80835 .17466 L
s
.78317 .24902 m
.76843 .29801 L
.63274 .36381 L
.78317 .24902 L
s
.76843 .29801 m
.75797 .3346 L
.60755 .40896 L
.76843 .29801 L
s
.75797 .3346 m
.74985 .36381 L
.58897 .44338 L
.75797 .3346 L
s
.74985 .36381 m
.74322 .38813 L
.57423 .47119 L
.74985 .36381 L
s
.74322 .38813 m
.73761 .40896 L
.56199 .49454 L
.74322 .38813 L
s
.6726 .29801 m
.63274 .36381 L
.54064 .38813 L
.6726 .29801 L
s
.63274 .36381 m
.60755 .40896 L
.49044 .44338 L
.63274 .36381 L
s
.60755 .40896 m
.58897 .44338 L
.45715 .48333 L
.60755 .40896 L
s
.58897 .44338 m
.57423 .47119 L
.43196 .51465 L
.58897 .44338 L
s
.57423 .47119 m
.56199 .49454 L
.41161 .54041 L
.57423 .47119 L
s
.54064 .38813 m
.49044 .44338 L
.41107 .45795 L
.54064 .38813 L
s
.49044 .44338 m
.45715 .48333 L
.35288 .50494 L
.49044 .44338 L
s
.45715 .48333 m
.43196 .51465 L
.313 .54041 L
.45715 .48333 L
s
.43196 .51465 m
.41161 .54041 L
.28221 .5689 L
.43196 .51465 L
s
.41107 .45795 m
.35288 .50494 L
.28181 .51465 L
.41107 .45795 L
s
.35288 .50494 m
.313 .54041 L
.21715 .55535 L
.35288 .50494 L
s
.313 .54041 m
.28221 .5689 L
.17171 .58713 L
.313 .54041 L
s
.28181 .51465 m
.21715 .55535 L
.15268 .56229 L
.28181 .51465 L
s
.21715 .55535 m
.17171 .58713 L
.08262 .59812 L
.21715 .55535 L
s
.15268 .56229 m
.08262 .59812 L
.02381 .60332 L
.15268 .56229 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[141]:=",
  ImageSize->{401, 247.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006A0000ma000`40O003h00OogooTWoo003oOonB
Ool00?mooi9oo`00ogooTWoo000IOol00`00Oomoo`02Ool01000Oomoo`000goo00<007ooOol00goo
00<007ooOol00Woo0`0077oo00<007ooOol00Woo00<007oo00000goo00<007ooOol00goo00<007oo
Ool00Woo0`0077oo00<007ooOol00Woo00@007ooOol000=oo`03001oogoo009oo`03001oogoo009o
o`<001aoo`03001oogoo009oo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`02Ool3000M
Ool00`00Oomoo`02Ool01000Oomoo`000goo00<007ooOol00goo00<007ooOol00Woo0`00Qgoo000I
Ool00`00Oomoo`06Ool00`00Ool00006Ool01@00Oomoogoo00000goo00<007ooOol06Goo00<007oo
Ool01Goo00<007oo00001Woo00D007ooOomoo`0000=oo`03001oogoo01Uoo`03001oogoo00Ioo`03
001oo`0000Eoo`05001oogooOol00003Ool00`00Oomoo`0IOol00`00Oomoo`06Ool00`00Ool00006
Ool01@00Oomoogoo00000goo00<007ooOol06Woo00<007ooOol01Woo00<007oo00001Woo00D007oo
Oomoo`0000=oo`03001oogoo08Aoo`006Goo00<007ooOol01goo00<007ooOol01Goo00D007ooOomo
o`0000=oo`03001oogoo01Uoo`03001oogoo00Ioo`03001oogoo00Eoo`05001oogooOol00003Ool0
0`00Oomoo`0IOol00`00Oomoo`07Ool00`00Oomoo`04Ool01@00Oomoogoo00000goo00<007ooOol0
6Goo00<007ooOol01goo00<007ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo01Yoo`03001o
ogoo00Moo`03001oogoo00Eoo`05001oogooOol00003Ool00`00Oomoo`24Ool001Uoo`03001oogoo
00Ioo`03001oo`0000Ioo`05001oogooOol00003Ool00`00Oomoo`0IOol00`00Oomoo`05Ool00`00
Ool00006Ool01@00Oomoogoo00000goo00<007ooOol06Goo00<007ooOol01Woo00<007oo00001Goo
00D007ooOomoo`0000=oo`03001oogoo01Uoo`03001oogoo00Ioo`03001oo`0000Ioo`05001oogoo
Ool00003Ool00`00Oomoo`0JOol00`00Oomoo`06Ool00`00Ool00006Ool01@00Oomoogoo00000goo
00<007ooOol07goo0`000goo00<007ooOol00`000goo0`0017oo00<007ooOol0C7oo000IOol00`00
Oomoo`05Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000=oo`03001oogoo01Uoo`03001oogoo
00Aoo`05001oogooOol00005Ool01@00Oomoogoo00000goo00<007ooOol06Goo00<007ooOol01Goo
00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`0IOol00`00Oomoo`05Ool01@00
Oomoogoo00001Goo00D007ooOomoo`0000=oo`03001oogoo01Yoo`03001oogoo00Eoo`05001oogoo
Ool00005Ool01@00Oomoogoo00000goo00<007ooOol07Woo00D007ooOomoo`0000Aoo`07001oogoo
Ool007oo00000goo00D007ooOomoo`0004ioo`006Goo00<007ooOol03goo00D007ooOomoo`0000=o
o`03001oogoo009oo`L0011oo`03001oogoo00ioo`05001oogooOol00003Ool00`00Oomoo`05Ool0
0`00Oomoo`02000?Ool00`00Oomoo`0>Ool01@00Oomoogoo00000goo00<007ooOol01Goo00<007oo
Ool00P003goo00<007ooOol03goo00D007ooOomoo`0000=oo`03001oogoo00Aoo`05001oogooOol0
000AOol00`00Oomoo`0?Ool01@00Oomoogoo00000goo00<007ooOol01Goo00<007ooOol05Woo00D0
07ooOomoo`0000Aoo`07001oogooOol007oo00000goo00D007ooOomoo`0004ioo`0067oo0P0047oo
0P000goo00@007ooOomoo`D00003Ool007oo00Aoo`03001oogoo00aoo`8000moo`8000=oo`04001o
ogooOol50003Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool2000?Ool20003Ool01000Oomoogoo1@00
0goo00<007ooOol00Woo00<007ooOol02goo0P0047oo0P000goo00@007ooOomoo`D0009oo`05001o
ogooOol0000@Ool2000@Ool20003Ool01000Oomoogoo1@000goo00<007ooOol05Woo00D007ooOomo
o`0000Aoo`07001oogooOol007oo00000goo00D007ooOomoo`0004ioo`006Goo00<007ooOol03goo
00<007ooOol00Woo0`001Woo0P000goo00<007ooOol03Woo00<007ooOol03Woo00<007ooOol00Woo
0`0027oo00<007oo00000`003Woo00<007ooOol03Woo00<007ooOol00Woo0`0027oo00<007oo0000
0Woo00<007ooOol037oo00<007ooOol03goo00<007ooOol00Woo0`001goo00D007ooOomoo`00015o
o`03001oogoo00moo`03001oogoo009oo`<000Qoo`03001oogoo01Ioo`05001oogooOol00004Ool0
1`00Oomoogoo001oo`0000=oo`05001oogooOol0001>Ool003Qoo`03001oogoo0080009oo`03001o
ogoo02ioo`03001oo`00009oo`03001oogoo02eoo`03001oogoo0080031oo`05001oogooOol0000d
Ool00`00Oomoo`0EOol01@00Oomoogoo000017oo00L007ooOomoo`00Ool00003Ool01@00Oomoogoo
0000CWoo000iOol6000aOol00`00Oomoo`03000_Ool00`00Oomoo`03000_Ool01@00Oomoogoo0000
<Woo0`005goo00D007ooOomoo`0000Aoo`07001oogooOol007oo00000goo00<007ooOol00P00CWoo
003oOol]Ool30006Ool30003Ool30004Ool00`00Oomoo`1<Ool00?mooi9oo`00ogooTWoo003oOonB
Ool002Uoool0040002Uoo`00:Goo00D007ooOomoo`0002Moo`05001oogooOol00002Ool200000goo
00000002000XOol02000Oomoogoo001oo`00Ool5000XOol02000Oomoogoo001oo`00Ool6000WOol0
1@00Oomoogoo00000Woo0P0000=oo`0000000P00:7oo00P007ooOomoo`00Ool007oo1@00:7oo00H0
07ooOomoo`00Ool2000YOol002Uoo`05001oogooOol0000dOol00`00Oomoo`0bOol00`00Oomoo`0c
Ool00`00Oomoo`0bOol00`00Oomoo`0bOol00`00Oomoo`0]Ool00`00Oomoo`0WOol001moo`03001o
ogoo00Moo`03001oogoo0?moocaoo`03001oogoo00Eoo`03001oogoo01moo`007goo00<007ooOol0
1goo00<007ooOol0ogoo?7oo00<007ooOol01Goo00<007ooOol07goo000OOol00`00Oomoo`07Ool3
003oOolIOol00gd0Oomoo`0NOol30007Ool00`00Oomoo`0OOol001moo`03001oogoo00Moo`03001o
ogoo0?mooaQoo`9m029oo`03001oogoo00Eoo`03001oogoo01moo`007goo00<007ooOol01goo00<0
07ooOol0ogoo67oo0Wd08Woo00<007ooOol01Goo00<007ooOol07goo000OOol00`00Oomoo`07Ool0
0`00Oomoo`3oOolGOol00gd0Oomm000ROol00`00Oomoo`05Ool00`00Oomoo`0OOol001ioo`8000Uo
o`03001oogoo0?mooaIoo`04O@1oogooO@0ROol00`00Oomoo`04Ool2000QOol001moo`03001oogoo
00Moo`03001oogoo0?mooaIoo`03O@1oogd002=oo`03001oogoo00Eoo`03001oogoo01moo`00:Goo
00<007ooOol0ogoo5Goo00Am07ooOomm02=oo`03001oogoo02Moo`00:Goo00<007ooOol0ogoo57oo
00Em07ooOomoogd002=oo`03001oogoo02Moo`00:Goo00<007ooOol0ogoo57oo00Em07ooOomoogd0
02=oo`03001oogoo02Moo`00:Goo00<007ooOol0ogoo4goo00=m07ooOol00Woo00=m07ooOol08Goo
00<007ooOol09goo000YOol00`00Oomoo`3oOolBOol00gd0Oomoo`03Ool00gd0Oomoo`0QOol00`00
Oomoo`0WOol002Uoo`03001oogoo0?mooa5oo`03O@1oogoo00Aoo`03O@1oogoo025oo`03001oogoo
02Moo`00:Goo00<007ooOol0ogoo4Goo00=m07ooOol017oo00=m07ooOol08Goo00<007ooOol09goo
000YOol00`00Oomoo`3oOol@Ool00gd0Oomoo`04Ool00gd0Oomoo`0ROol00`00Oomoo`0WOol002Uo
o`03001oogoo0?moo`moo`03O@1oogoo00Eoo`03O@1oogoo029oo`03001oogoo02Moo`00:Goo00<0
07ooOol0ogoo3goo00=m07ooOol01Goo00=m07ooOol08Woo00<007ooOol09goo000YOol00`00Oomo
o`3oOol>Ool00gd0Oomoo`06Ool00gd0Oomoo`0ROol00`00Oomoo`0WOol002Uoo`03001oogoo0?mo
o`eoo`03O@1oogoo00Moo`03O@1oogoo029oo`03001oogoo02Moo`00:Goo00<007ooOol0ogoo3Goo
00=m07ooOol01goo00=m07ooOol08Woo00<007ooOol09goo000YOol00`00Oomoo`3oOol<Ool00gd0
Oomoo`08Ool00gd0Oomoo`0ROol00`00Oomoo`0WOol002Uoo`03001oogoo0?moo`]oo`03O@1oogoo
00Uoo`03O@1oogoo029oo`03001oogoo02Moo`00:Goo00<007ooOol0ogoo2goo00=m07ooOol027oo
00=m07ooOol08goo00<007ooOol09goo000YOol00`00Oomoo`3oOol:Ool00gd0Oomoo`09Ool00gd0
Oomoo`0SOol00`00Oomoo`0WOol002Uoo`03001oogoo0?moo`Uoo`03O@1oogoo00Yoo`03O@1oogoo
02=oo`03001oogoo02Moo`00:Goo00<007ooOol0ogoo2Goo00=m07ooOol02Woo00=m07ooOol08goo
00<007ooOol09goo000YOol00`00Oomoo`3oOol8Ool00gd0Oomoo`0;Ool00gd0Oomoo`0SOol00`00
Oomoo`0WOol002Uoo`03001oogoo0?moo`Moo`03O@1oogoo00aoo`03O@1oogoo02=oo`03001oogoo
02Moo`00:Goo00<007ooOol0ogoo1Woo00=m07ooOol03Goo00=m07ooOol08goo00<007ooOol09goo
000YOol00`00Oomoo`3oOol6Ool00gd0Oomoo`0=Ool00gd0Oomoo`0SOol00`00Oomoo`0WOol002Uo
o`03001oogoo0?moo`Eoo`03O@1oogoo00eoo`03O@1oogoo02Aoo`03001oogoo02Moo`007Goo1@00
1goo00<007ooOol0ogoo17oo00=m07ooOol03Woo00=m07ooOol097oo00<007ooOol00goo1@007goo
000MOol00`00Oomoo`09Ool00`00Oomoo`3oOol4Ool00gd0Oomoo`0>Ool00gd0Oomoo`0TOol00`00
Oomoo`03Ool00`00Oomoo`0QOol001ioo`03001oogoo00Qoo`<00?moo`=oo`038QIm07d0011m02Ao
o`<000Ioo`03001oogoo021oo`007goo0P0027oo00<007ooOol0ogoo0Woo0R8F47oo0Wd09Woo00<0
07ooOol01Goo0P0087oo000QOol00`00Oomoo`05Ool00`00Oomoo`3oOol1Ool00b8FOolR5P0?Ool0
0gd0Oomm000VOol00`00Oomoo`07Ool00`00Oomoo`0MOol0025oo`03001oogoo00Eoo`03001oogoo
0?ioo`04O@0R5Woo8QH@Ool00gd0Oomm000VOol00`00Oomoo`07Ool00`00Oomoo`0MOol001eoo`05
001oogooOol00007Ool00`00Oomoo`3mOol01Gd08QIoogoo8QH03goo00=m07ooO@009goo00<007oo
Ool00goo00D007ooOomoo`0001moo`007Woo0`0027oo00<007ooOol0o7oo00=m028FOol00Woo00<R
5WooOol037oo00Am07ooOomm02Moo`03001oogoo00Aoo`<0021oo`00:Goo00<007ooOol0ngoo00=m
028FOol00goo00<R5WooOol02goo00Em07ooOomoogd002Moo`03001oogoo02Moo`00:Goo00<007oo
Ool0nWoo00=m07oo8QH00goo00<R5WooOol037oo00Em07ooOomoogd002Moo`03001oogoo02Moo`00
:Goo00<007ooOol0n7oo0Wd000=oob8FOol00goo00<R5WooOol02goo00=m07ooOol00Woo00=m07oo
Ool09Goo00<007ooOol09goo000YOol00`00Oomoo`3gOol017d0Oomoob8F1Goo00<R5WooOol02Woo
00=m07ooOol00goo00=m07ooOol09Goo00<007ooOol09goo000YOol00`00Oomoo`3fOol017d0Oomo
ob8F1Woo00<R5WooOol02Goo00=m07ooOol00goo00=m07ooOol09Woo00<007ooOol09goo000YOol0
0`00Oomoo`3eOol017d0Oomoob8F1Woo00<R5Wd0Ool02Goo00=m07ooOol017oo00=m07ooOol09Woo
00<007ooOol09goo000YOol00`00Oomoo`3dOol017d0Oomoob8F1goo00<R5WooOol02Goo00=m07oo
Ool017oo00=m07ooOol09Woo00<007ooOol09goo000YOol00`00Oomoo`3bOol2O@02Ool00b8FOomo
o`06Ool00b8FOomoo`08Ool00gd0Oomoo`05Ool00gd0Oomoo`0VOol00`00Oomoo`0WOol002Uoo`03
001oogoo0?5oo`05O@1oogooOolR5P09Ool00b8FOomoo`07Ool00gd0Oomoo`06Ool00gd0Oomoo`0V
Ool00`00Oomoo`0WOol002Uoo`03001oogoo0?1oo`05O@1oogooOolR5P09Ool00b8FO@1oo`07Ool0
0gd0Oomoo`07Ool00gd0Oomoo`0VOol00`00Oomoo`0WOol002Uoo`03001oogoo0>moo`05O@1oogoo
OolR5P0:Ool00b8FO@1oo`07Ool00gd0Oomoo`06Ool00gd0Oomoo`0WOol00`00Oomoo`0WOol002Uo
o`03001oogoo0>ioo`05O@1oogooOolR5P0;Ool00b8FOomoo`06Ool00gd0Oomoo`07Ool00gd0Oomo
o`0WOol00`00Oomoo`0WOol002Uoo`03001oogoo0>eoo`05O@1oogooOolR5P0<Ool00b8FOomoo`05
Ool00gd0Oomoo`08Ool00gd0Oomoo`0WOol00`00Oomoo`0WOol002Uoo`800>aoo`9m00=oo`038QIo
ogoo00Yoo`038QHoh7oo00Eoo`03O@1oogoo00Uoo`03O@1oogoo02Ioo`8002Uoo`00:Goo00<007oo
Ool0jWoo00=m07ooOol00Woo00<R5WooOol02goo0SoP1Goo00=m07ooOol027oo0gd0:Goo00<007oo
Ool09goo000YOol00`00Oomoo`3YOol00gd0Oomoo`03Ool00b8FOomoo`0:Ool2?n06Ool00gd0Oomo
o`06Ool3O@000gooO@1oo`0XOol00`00Oomoo`0WOol002Uoo`03001oogoo0>Qoo`03O@1oogoo00=o
o`038QIoogoo00Yoo`03?n1oocoP00Eoo`03O@1oogoo00Ioo`06O@1oogooO@1oogd0:Goo00<007oo
Ool09goo000YOol00`00Oomoo`3WOol00gd0Oomoo`03Ool00b8FOomoo`0:Ool013oPOolR5SoP17oo
00=m07ooOol01Goo0Wd00Woo00Am07ooOomm02Uoo`03001oogoo02Moo`00:Goo00<007ooOol0iGoo
0Wd01Goo00<R5WooOol02Goo0SoP0Woo00<oh7d0Ool00Woo00=m07ooOol017oo0Wd00goo00Em07oo
Oomoogd002Uoo`03001oogoo02Moo`00:Goo00<007ooOol0i7oo00=m07ooOol017oo00<R5WooOol0
2Goo00<oh7ooOol00Woo00Doh7d0Oomoogd000Eoo`9m00Aoo`03O@1oogoo009oo`03O@1oogoo02Mo
o`03001oogoo02Moo`00:Goo00<007ooOol0hgoo00=m07ooOol017oo00<R5WooOol02Goo00<oh7oo
Ool00goo00Doh7ooOomoogd000Aoo`03O@1oogoo00=oo`03O@1oogoo009oo`03O@1oogoo02Qoo`03
001oogoo02Moo`00:Goo00<007ooOol0hWoo00=m07ooOol017oo00<R5WooOol02Goo00<oh7ooOol0
0goo00Doh7d0Oomoogd000=oo`9m00Ioo`03O@1oogoo009oo`03O@1oogoo02Qoo`03001oogoo02Mo
o`00:Goo00<007ooOol0hGoo00=m07ooOol017oo00<R5WooOol02Goo00<oh7ooOol017oo00@oh7d0
Oomm009oo`9m00Moo`03O@1oogoo00=oo`03O@1oogoo02Qoo`03001oogoo02Moo`00:Goo00<007oo
Ool0ggoo0Wd01Woo00<R5WooOol02Goo00<oh7ooOol01Goo00<oh7d0O@000Woo00=m07ooOol01Woo
00=m07ooOol017oo00=m07ooOol0:7oo00<007ooOol09goo000YOol00`00Oomoo`3NOol00gd0Oomo
o`05Ool00b8FOomoo`09Ool00coPOomoo`05Ool00coP8QIoo`03O@08Ool00gd0Oomoo`05Ool00gd0
Oomoo`0XOol00`00Oomoo`0WOol002Uoo`03001oogoo0=eoo`03O@1oogoo00Eoo`038QIoogoo00Uo
o`03?n1oogoo00Ioo`04?n1m07d0O@09Ool00gd0Oomoo`06Ool00gd0Oomoo`0XOol00`00Oomoo`0W
Ool002Uoo`800=eoo`Qm00038QIm07d000Um0003?n1m07d000Im0003?n0R5Wd000Yoo`03O@1oogoo
00Moo`03O@1oogoo02Moo`8002Uoo`00:Goo00<007ooOol0fgoo0Wd01Woo00<R5WooOol02Goo00<o
h7ooOol017oo0b8F00<oh28FO@002Woo00=m07ooOol01Woo0Wd0:Woo00<007ooOol09goo000YOol0
0`00Oomoo`3JOol00gd0Oomm0005Ool00b8FOomoo`08Ool2?n04Ool38QH2O@00128F?n1oogd02Goo
00=m07ooOol01Goo0Wd000=oogd0Ool0:Goo00<007ooOol09goo000YOol00`00Oomoo`3IOol00gd0
Oomm0006Ool00b8FOomoo`07Ool013oPOomoogoo0b8F00=oogd0O@000R8F00<oh28FO@002Goo00=m
07ooOol01Goo0Wd00Woo00=m07ooOol0:7oo00<007ooOol09goo000YOol00`00Oomoo`3HOol017d0
Oomoogd01Goo00<R5WooOol01goo00<oh7oo8QH00R8F0Woo0Wd000Moob8FOomoocoP8QIm0008Ool0
0gd0Oomoo`05Ool00gd0Oomm0002Ool00gd0Oomoo`0XOol00`00Oomoo`0WOol002Uoo`03001oogoo
0=Moo`05O@1oogooOomm0004Ool00b8FOomoo`06Ool0128F?n0R5R8F0Woo0gd00Woo00LR5WooOomo
ocoP8QIm0007Ool00gd0Oomoo`04Ool2O@000gooO@1oo`02Ool00gd0Oomoo`0XOol00`00Oomoo`0W
Ool002Uoo`03001oogoo0=Ioo`03O@1oogoo009oo`05O@1oogooOolR5P06Ool38QH013oPOomoogoo
0Wd017oo00PR5WooOomoocoP8QIoogd01goo00=m07ooOol00goo00Am07ooOomm00=oo`03O@1oogoo
02Uoo`03001oogoo02Moo`00:Goo00<007ooOol0eGoo00=m07ooOol00Woo00Em07ooOomoob8F00Ao
o`<R5P9oo`03?n1oogoo009m00Eoo`038QIoogoo009oo`04?n0R5WooO@06Ool00gd0Oomoo`03Ool0
17d0Oomoogd017oo00=m07ooOol0:Goo00<007ooOol09goo000YOol00`00Oomoo`3DOol00gd0Oomo
o`03Ool017d0Oomoob8F0Woo0b8F17oo00@oh7ooO@1m00Ioo`038QIoogoo00=oo`03?n0R5Wd000Io
o`03O@1oogoo009oo`9m009oo`03O@1oogoo00=oo`03O@1oogoo02Uoo`03001oogoo02Moo`007Woo
0`0027oo00<007ooOol0dgoo00=m07ooOol017oo00=m07oo8QH00b8F1Woo00<oh7d0O@001Woo0R8F
1Goo00@oh7oo8QIm00Eoo`03O@1oogoo009oo`05O@1oogooOomm0006Ool00gd0Oomoo`0YOol00`00
Oomoo`04Ool3000POol001eoo`05001oogooOol00007Ool3003BOol00gd0Oomoo`05Ool00gd08QHR
5P07Ool00gd0?n1m0007Ool00b8FOomoo`04Ool2?n000b8FOomm0004Ool00gd0Oomoo`02Ool00gd0
Oomoo`02Ool00gd0Oomoo`04Ool00gd0Oomoo`0WOol30005Ool01@00Oomoogoo00007goo000QOol0
0`00Oomoo`05Ool00`00Oomoo`3AOol00gd0Oomoo`05Ool00gd08QHR5P06Ool00gd0?n0oh008Ool0
0b8FOomoo`03Ool4?n000b8FOomm0004Ool00gd0Oomoo`02O@04Ool00gd0Oomoo`04Ool2O@0[Ool0
0`00Oomoo`07Ool00`00Oomoo`0MOol0025oo`03001oogoo00Eoo`03001oogoo0=1oo`03O@1oogoo
00Eoo`<R5PEoo`9m0003?n1oogoo00Moo`038QIoogoo009oo`Doh003OolR5Wd000Aoo`04O@1oogoo
O@05Ool00gd0Oomoo`04Ool00gd0Oomm000[Ool00`00Oomoo`07Ool00`00Oomoo`0MOol001eoo`@0
00Qoo`03001oogoo0<moo`03O@1oogoo00Eoo`048QIoogd08QH3Ool2O@000goo?n1oo`08Ool0128F
Oomoogoo0SoP00QoocoPOomoocoPOolR5Wd00goo00Am07ooOomm00Eoo`03O@1oogoo00=oo`9m009o
o`03O@1oogoo02Uoo`03001oogoo00=oo`@0021oo`007Goo00<007ooOol02Goo00<007ooOol0cWoo
00=m07ooOol01Goo00@R5WooOolR5P9oo`9m009oo`03?n1oogoo00Moo`038QIoogoo008oh09oo`08
?n1oogooOoloh28FOomm009oo`04O@1oogd0O@05Ool00gd0Oomoo`03Ool2O@03Ool00gd0Oomoo`0Y
Ool00`00Oomoo`03Ool00`00Oomoo`0QOol001eoo`03001oogoo00Uoo`03001oogoo0<eoo`03O@1o
ogoo00Eoo`058QIoogooOolR5P02O@03Ool00coPOomoo`07Ool0128F?n0oh3oP0Woo0SoP0goo00To
h7oo8QIoogd0Oomm07ooO@001Woo00=m07ooOol00goo0Wd00goo00=m07ooOol0:Woo00<007ooOol0
0goo00<007ooOol08Goo000MOol50007Ool00`00Oomoo`3<Ool00gd0Oomoo`05Ool01R8FOomoogd0
8QIm00Aoo`03?n1oogoo00Ioo`038QHoh3oP00Aoo`03?n1oogoo00=oo`04?n1oob8FOol2O@000goo
O@1oo`06Ool00gd0Oomoo`02Ool00gd0Oomm0003Ool00gd0Oomoo`0ZOol00`00Oomoo`03Ool5000O
Ool002Uoo`03001oogoo0<]oo`03O@1oogoo00Aoo`8R5P05Oomm07d0OolR5P04Ool00coPOomoo`06
Ool2?n05Ool00coPOomoo`04Ool01CoPOolR5Wd0Ool00Wd01goo00=m07ooOol00Woo00=m07ooO@00
17oo00=m07ooOol0:Woo00<007ooOol09goo000YOol00`00Oomoo`3:Ool00gd0Oomoo`04Ool0128F
Oomm07d00Woo00<R5Wd0Ool00Woo00<oh7ooOol01Goo0SoP1Goo0SoP1goo00<oh28FOol00Wd027oo
00Am07ooOomoo`9m0003Oomm07oo00Aoo`03O@1oogoo02Yoo`03001oogoo02Moo`00:Goo0P00bWoo
00=m07ooOol017oo00<R5Wd0O@0017oo00DR5Wd0OomoocoP00Ioo`8oh0038QIoogoo00=oo`03?n1o
ogoo00Ioo`03?n0R5R8F009m00Qoo`05O@1oogooOomm0002Ool00gd0Oomoo`04Ool00gd0Oomoo`0Y
Ool2000YOol002Uoo`03001oogoo0<Qoo`03O@1oogoo00Aoo`038QIm07oo00Aoo`058QIm07ooOolo
h005Ool2?n000goo8QIoo`04Ool00coPOomoo`06O@00128F?n0R5R8F0Wd01goo00Em07ooOomoogd0
009oo`03O@1oogoo00Aoo`9m02aoo`03001oogoo02Moo`00:Goo00<007ooOol0agoo00=m07ooOol0
0Woo00=m028F8QH01goo00@R5Wd0?n0oh0=oo`<oh09oo`038QIoogoo00=m0004?n1m07d0O@04Ool3
8QH01CoPO@0R5WooO@001Woo00Em07ooOomoogd0009oo`03O@1oogoo00=oo`9m0003Oomm07oo02]o
o`03001oogoo02Moo`00:Goo00<007ooOol0aWoo00Am07ooOomoo`9m00038QIoogoo00Ioo`038QIo
ocoP00=oo`8oh0=m008R5P=m0003Ooloh3oP00Ioo`8R5P05OolR5SoPOolR5P02Ool00gd0Oomoo`03
Ool01Gd0OomoogooO@000Woo00=m07ooOol00goo0Wd00Woo00=m07ooOol0:Woo00<007ooOol09goo
000YOol00`00Oomoo`35Ool00gd0Oomoo`02O@000goo8QIoo`08Ool0128F?n1m07d00SoP0Wd00Woo
00<R5WooOol00goo00<oh7ooOol017oo0R8F00Uoogd08QIoocoPOolR5WooO@001Woo00Am07ooOomm
009oo`03O@1oogoo00=oo`9m009oo`03O@1oogoo02]oo`03001oogoo02Moo`00:Goo00<007ooOol0
a7oo00Am07ooO@1m009oo`048QIoogooOol7O@0013oPO@0oh3oP1Goo00<R5WooOol00goo00<oh7oo
Ool00goo0R8F00Aoogd08QHR5P9oo`05?n1oob8FOomm0005Ool017d0Oomm07d00Woo00=m07ooOol0
0goo0Wd00goo00=m07ooOol0:goo00<007ooOol09goo000YOol00`00Oomoo`33Ool6O@000b8FO@1m
0002O@06Ool3?n06Ool00b8FOomoo`02Ool2?n04Ool28QH017ooO@1m028F0goo00Hoh7ooOolR5Woo
O@04Ool00gd0Oomm0003Ool00gd0Oomoo`03Ool2O@04Ool00gd0Oomoo`0[Ool00`00Oomoo`0WOol0
02Uoo`800<=oo`Em008R5PYm008oh09m00Eoo`038QIoogoo009oo`03?n1oogoo009oo`8R5P05Oomm
07d0OolR5P03Ool2?n001Goo8QIoogooO@000goo00=m07ooO@0017oo00Am07ooOomoo`=m00Eoo`03
O@1oogoo02Yoo`8002Uoo`00:Goo00<007ooOol0`goo00Am07ooOolR5PYoo`8oh0048QIoogd0O@04
Ool00b8FOomoo`02Ool013oPOomoogoo0R8F00Aoogd0O@1oo`8R5P9oo`@oh005OolR5WooOomm0002
Ool00gd0Oomm0004Ool01Gd0OomoogooO@000Woo00=m07ooOol00Woo00=m07ooOol0;7oo00<007oo
Ool09goo000YOol00`00Oomoo`33Ool00gd0OolR5P0:Ool013oPOoloh28F0Wd00goo0R8F0goo0SoP
0Woo0R8F00=oogd0O@000Woo00<R5WooOol00coP0Woo00<oh7oo8QH00Woo00Em07ooO@1oogd000Ao
o`05O@1oogooOomm0002Ool00gd0Oomoo`02Ool00gd0Oomoo`0]Ool00`00Oomoo`0WOol002Uoo`03
001oogoo0<Aoo`038QIoogoo00Moo`8oh006Ooloh28FO@1oogd00Woo00<R5WooOol00Woo00<oh7oo
Ool00R8F00=oogd0O@000goo00<R5Woo?n000coP0Woo00Hoh7ooOolR5WooO@02Ool2O@04Ool01Gd0
OomoogooO@000Woo00Am07ooOomoo`9m031oo`03001oogoo02Moo`00:Goo00<007ooOol0`goo00<R
5Wd0Ool01goo00Poh7ooOomoocoP8QIoogd00Woo00<R5WooOol00Woo00Doh7oo8QHR5Woo009m00=o
o`8R5P8oh003Ooloh7oo00=oo`03?n1oob8F009oo`03O@1oogd000Eoo`03O@1oogoo009m009oo`05
O@1oogooOomm000bOol00`00Oomoo`0WOol002Uoo`03001oogoo0<5oo`8R5P9oo`03O@1oogoo00Ao
o`06?n1oogooOoloh28F0Woo00=m07oo8QH017oo00<oh28F8QH00Woo00=m07ooOol00Woo00@R5SoP
?n1oo`8oh0Eoo`03?n1oob8F009oo`9m00Eoo`04O@1oogooO@03Ool01Gd0OomoogooO@00<goo00<0
07ooOol09goo000YOol20031Ool00b8FOomoo`02Ool00gd0Oomoo`02Ool2?n03Ool01coPOolR5Woo
O@1oob8F00=oo`8oh0038QIoogoo009m00Aoo`8oh09oo`03?n1oogoo00Eoo`03?n1oob8F00=m00Eo
o`04O@1oogooO@03Ool01Gd0OomoogooO@00<goo0P00:Goo000YOol00`00Oomoo`2oOol00b8FOomo
o`04Ool017d0OomoocoP17oo00=m03oP8QH00Woo00=m028FOol00Woo00@oh28FOomoo`9m00Aoo`8o
h0=oo`03?n1oogoo00Eoo`04?n0R5R8F8QH3O@04Ool017d0Oomoogd00goo00Em07ooOomoogd003Eo
o`03001oogoo02Moo`00:Goo00<007ooOol0_Woo00<R5WooOol01Goo00=m03oP?n000goo0Wd000<o
h7oo8QH00Woo00DR5WooOolR5SoP009oo`9m00Aoo`8oh0038QIoogoo008oh0Aoo`=m00078QHoh7oo
8QIm07ooO@0017oo00Am07ooOomm00=oo`05O@1oogooOomm000fOol00`00Oomoo`0WOol002Uoo`03
001oogoo0;aoo`8R5PQoo`03?n1m07oo009oo`06O@1oocoPOolR5Woo0R8F00Eoob8F?n0oh7oo009m
00Aoo`8oh0058QIoogooOoloh002Ool4O@001goo8QHR5R8F?n1m028F009oo`06O@1oogooOomm07oo
0Wd00goo00=m07ooOol00Wd0=goo00<007ooOol09goo000YOol00`00Oomoo`2kOol00b8FOomoo`06
Ool2?n001GooO@1m07ooO@000Woo00Doh7oo8QHR5Woo008R5P04?n1oogd0O@04Ool2?n0017oo8QIo
ogoo0SoP0gd00goo0b8F0Wd000<oh7oo8QH00Woo00Im07ooOomm07ooO@04Ool017d0Oomoogd0>Goo
00<007ooOol09goo000YOol00`00Oomoo`2jOol00b8FOomoo`06Ool00coPOomoo`02Ool2O@02Ool0
0coPOolR5P038QH017oo?n1m07d017oo0SoP00=oob8F8QH00Wd000<oh7d0Ool017oo0R8F00Eoob8F
O@1oocoP009oo`048QIoogooO@02Ool2O@04Ool017d0Oomoogd0>Woo00<007ooOol09goo000YOol2
002jOol00b8FOomoo`05Ool2?n05Ool2O@000goo8QHoh0038QH017ooO@0oh7d017oo0SoP0Wd000<R
5Wd0Ool00SoP1Goo0R8F00=oob8F8QH00Woo0SoP00Eoob8FOomoogd0009oo`9m00Aoo`04O@1oogoo
O@0jOol2000YOol002Uoo`03001oogoo0;Qoo`038QIoogoo00Eoo`03?n1oogoo009oo`HR5P05?n0R
5R8F8QIoo`02?n04Ool2?n02O@001Goo8QIoogoo?n001Goo0R8F00=oogd08QH00Woo13oP00Ioob8F
Oomoogd0Ool2O@04Ool017d0Oomoogd0?7oo00<007ooOol09goo000YOol00`00Oomoo`2fOol28QH6
Ool2?n058QH03Gd0OomoogooO@0oh28FOolR5Wd0?n1m07oo009m008oh0=oo`8R5P03Ooloh3oP00Ao
o`8R5P05Oomm028F8QIoo`03?n001Goo?n1oogoo8QH00Woo0gd017oo00Am07ooOomm03eoo`03001o
ogoo02Moo`006Woo00<007ooOol00Woo0`001goo00<007ooOol0]Goo00<R5WooOol01B8F00<oh7oo
Ool017oo00=m07ooOol00Woo00HR5SoPOomm028F?n03O@02?n04Ool0128FOomoocoP17oo0R8F00Eo
ogd0O@0R5Woo00@oh09oo`03?n1oob8F009oo`9m00Eoo`04O@1oogooO@0nOol00`00Oomoo`05Ool0
0`00Oomoo`02Ool3000JOol001Yoo`05001oogooOol00003Ool00`00Oomoo`04Ool3002dOol48QH4
Ool00coPOomoo`04Ool017d0Oomoogoo0R8F00<oh7d0O@000SoP00Aoogd0?n0oh0Eoo`048QIoocoP
?n03Ool28QH00gooO@1m00028QH4?n04Ool013oPOolR5Woo0Wd01Goo00Am07ooO@1m03eoo`<000Mo
o`05001oogooOol00003Ool00`00Oomoo`0GOol001Yoo`05001oogooOol00003Ool00`00Oomoo`04
Ool00`00Oomoo`2bOol28QH6Ool2?n06Ool01gd0Oomoogoo8QIoocoP009oo`03?n0R5Woo008oh0Io
o`038QIoocoP00=oo`8R5P05Oomm07d0OolR5P02?n000goo?n1oo`04Ool013oP8QHR5R8F0gd01Goo
0Wd0@Goo00<007ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo01Moo`006Woo00D007ooOomo
o`0000=oo`03001oogoo00Aoo`03001oogoo0;5oo`038QIoob8F00Eoo`03?n1oogoo00Aoo`9m009o
o`8R5P9oo`04?n1oocoP8QH2?n000gd0Oomoo`03Ool28QH00goo?n1oo`02Ool0128FOomoogd00Woo
0SoP00=oocoP?n001Goo00DR5SoPO@1m028F009oo`03O@1oogoo009oo`9m049oo`03001oogoo00Eo
o`05001oogooOol00003Ool00`00Oomoo`0GOol001Yoo`05001oogooOol00003Ool00`00Oomoo`04
Ool00`00Oomoo`2_Ool28QH00goo8QIoo`03Ool2?n06Ool00gd0Oomoo`028QH3Ool5?n000gd0Oomm
0004Ool0128FOoloh3oP0Woo0R8F00Aoogd0O@1oo`8oh09oo`04?n1oogooOol2O@038QH00coPO@0R
5P02Ool00gd0Oomoo`02Ool2O@13Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00<007ooOol0
5goo000JOol01@00Oomoogoo00000goo00<007ooOol017oo00<007ooOol0[Goo0R8F0Woo00<R5Woo
Ool00Woo00<oh7ooOol01Goo00Am07ooOolR5PEoo`<oh0048QIoogd0O@04Ool00b8FOoloh002Ool2
8QH017ooO@1m07oo0SoP0Woo0SoP00Aoogd0O@1m00<R5P05O@0oh7ooOolR5P02Ool017d0Oomoogoo
0Wd0A7oo00<007ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo01Moo`006Goo0P000goo00D0
07ooOomoo`0000Ioo`03001oogoo0:aoo`058QIoogooOolR5P03Ool2?n07Ool2O@028QH4O@03?n02
O@00128FO@1m07d00Woo0R8F0SoP00Aoob8F8QIoo`9m0005Ooloh3oP8QIoo`02?n03O@000goo8QHR
5P028QH00gd0?n0oh002Ool0128FOomoogd00Woo0Wd0AGoo00<007ooOol017oo0P000goo00D007oo
Oomoo`0001Uoo`006Woo00<007ooOol00Woo0`001goo00<007ooOol0ZWoo0R8F17oo00@R5WooOolo
h0Qoo`03O@1oob8F009oo`Doh0=oo`038QIm07d0009m0005OolR5Woo?n1oo`028QH017ooO@1m07oo
0SoP00@R5WooOoloh09m009oo`8R5P03OolR5Wd000@oh09oo`058QIoogooO@1oo`02O@16Ool00`00
Oomoo`05Ool00`00Oomoo`02Ool3000JOol002Uoo`03001oogoo0:Uoo`038QIoogoo00=oo`048QIo
ocoP?n07Ool2O@000b8F?n0oh002?n001Goo?n0oh7oo?n000goo00HR5Wd0Oomm07oo8QH2?n028QH0
0gooO@1m0003?n028QH00gd0?n0oh003Ool28QH00goo8QHR5P03?n02Ool00coPOolR5P02Ool00gd0
Oomm0018Ool00`00Oomoo`0WOol002Uoo`03001oogoo0:Moo`8R5PEoo`038QIoocoP00Qoo`04O@0o
h3oP?n03Ool2?n02Ool01CoPOomoogoo8QH00Wd000Aoob8F8QHoh08R5P03Oomm07d0008oh09oo`04
8QIm07d0?n04Ool0128FOomm028F0coP0goo00@oh7ooOolR5P9oo`9m04Uoo`03001oogoo02Moo`00
:Goo00<007ooOol0YWoo00<R5WooOol017oo00<R5Woo?n001Woo13oP00Am07ooOomoo`8oh0Aoo`05
?n1oogd0O@0R5P02O@001B8F?n0oh28FOol00Wd00SoP00Eoogd0O@0R5Woo008oh0=oo`8R5P03O@0R
5SoP00<oh0Aoo`05?n1oogoo8QIoo`02O@1:Ool00`00Oomoo`0WOol002Uoo`03001oogoo0:Aoo`8R
5PMoo`8oh0Aoo`<oh005O@0R5R8FOomm0002Ool00coPOomoo`03Ool02coPOomm07oo8QIoogd08QHo
h28FOol00Wd00SoP0gd00R8F0SoP0goo0R8F0Wd013oP1Woo00Doh28F8QHR5Wd004aoo`03001oogoo
02Moo`00:Goo00<007ooOol0Xgoo00<R5WooOol01Woo00<oh7ooOol013oP0Woo0R8F0Woo00Am07oo
?n0oh0Ioo`04?n1m07ooOol28QH2?n000gooO@1m0002?n001gd0Oomoogoo8QIoocoP00=oo`8R5P9m
008oh003Ooloh7oo00Ioo`048QHoh7d08QI>Ool00`00Oomoo`0WOol002Uoo`03001oogoo0:5oo`8R
5PMoo`Doh0Eoo`058QIoogooOomm0002?n07Ool013oPOomoogoo0R8F00@oh7d0O@1m008oh0Aoo`8R
5P8oh09oo`8R5P9m008oh003Ooloh3oP00Aoo`9m008R5P04?n1oogoo8QI>Ool00`00Oomoo`0WOol0
02Uoo`03001oogoo09moo`8R5PQoo`8oh0038QIoogoo00Aoo`8R5P=oo`8oh0Moo`03O@0oh7oo009o
o`8R5P03?n1m07d0008oh0Eoo`038QIoocoP009oo`8R5P9m008oh0038QHoh3oP00=oo`=m00<R5P8o
h09oo`038QIoogoo04aoo`03001oogoo02Moo`00:Goo00<007ooOol0WWoo00<R5WooOol01Woo0SoP
00=oob8FOol01Goo00@R5WooOomoo`8oh003O@1oogoo00Aoo`9m0003Ooloh28F008R5P8oh003Oolo
h3oP00Eoo`8R5P8oh003OolR5R8F009m008oh0038QIoocoP009oo`=m0004OolR5R8F8QH4?n02Ool0
0b8FOomoo`1<Ool00`00Oomoo`0WOol002Uoo`03001oogoo09aoo`8R5PMoo`<oh003OolR5Woo00Ao
o`8R5P=oo`04?n1oogooO@05Ool38QH01SoPOolR5R8F?n0R5P8oh09m00Aoo`048QIoocoPOol28QH2
O@02?n028QH2?n03O@02Ool38QH3?n001Goo?n1oogoo8QH0Cgoo00<007ooOol09goo000YOol00`00
Oomoo`2KOol00b8FOomoo`05Ool2?n0017oo?n1oob8F17oo0R8F00=m07ooOol00SoP0Woo00=m07oo
Ool0128F0goo00<oh28F?n000coP0Woo00=m07ooOol00Woo00<R5SoP?n000R8F0Wd00SoP00Aoob8F
Ooloh09m00=oo`8R5P04Ooloh3oP?n03Ool013oPOomoob8FCgoo00<007ooOol09goo000YOol00`00
Oomoo`2IOol28QH6Ool2?n02Ool013oPOomoob8F0goo00@R5Wd0O@1oo`8oh0=oo`@R5P03Oomm07oo
009oo`038QHoh7oo00<oh0038QIoogoo009m009oo`058QHoh3oPOolR5P02O@02?n000goo8QHR5P02
?n04Ool28QH00goo?n0oh002?n04Ool00coP8QHR5P1@Ool00`00Oomoo`0WOol002Uoo`03001oogoo
09Qoo`038QIoogoo00Aoo`8oh0=oo`04?n1oogoo8QH2Ool28QH017d0Ooloh3oP0Woo0b8F00=m07oo
Ool00Wd00Woo0R8F00AoocoP?n0oh09oo`038QIoogoo009m0004OolR5SoPOol28QH01Wd0?n0oh7oo
O@0R5P8oh0Aoo`8R5P03Ooloh3oP008oh0Eoo`03?n0R5Woo055oo`03001oogoo02Moo`00:Goo00<0
07ooOol0UWoo0R8F1Goo0SoP17oo00@oh7ooOolR5P9oo`038QIoogd0008oh0@R5P9oo`04O@1oogd0
O@03Ool00b8FOoloh002?n03Ool00b8FO@1m0002O@000b8F?n0oh0028QH00gd0?n0oh003O@000b8F
?n1oo`03Ool28QH00goo?n0oh002?n05Ool00b8F?n0oh01COol00`00Oomoo`0WOol002Uoo`03001o
ogoo09Eoo`038QIoogoo00=oo`8oh0Eoo`05?n1oogoo8QIoo`028QH00gd08QHoh0028QH5Ool00gd0
Oomm0003Ool5?n05O@001R8FOomm07d08QHoh08R5P04O@0oh3oPO@02Ool00b8F?n0oh003Ool28QH0
1Goo?n0oh28F?n001Goo00<R5SoP?n00EGoo00<007ooOol09goo000YOol00`00Oomoo`2COol28QH4
Ool2?n06Ool013oPOomoogoo128F0SoP27oo0Wd000=oocoP?n000coP0Wd000<oh7ooOol00Woo00@R
5Wd0O@0R5P8oh0048QIm03oP?n04Ool2?n03Ool28QH017oo?n0oh28F0SoP17oo00<R5SoP?n00Egoo
00<007ooOol09goo000YOol00`00Oomoo`2AOol28QH4Ool2?n08Ool00coP8QHR5P028QH00goo?n0o
h00:O@03?n000b8F?n0oh003Ool00coPOomoo`02Ool00gd08QIoo`02?n00128FO@0oh3oP17oo00<R
5SoPOol00goo00DR5Woo?n0oh28F008oh0Aoo`038QHoh3oP05Uoo`03001oogoo02Moo`00:Goo00<0
07ooOol0T7oo00<R5WooOol00Woo0SoP0Woo1b8F00Doh28F8QHR5Woo008oh0Qoo`@oh08R5P8oh0Eo
o`0:?n1oogooOomm028FOoloh28FO@02?n05Ool2?n03Ool28QH2?n000goo8QHoh004Ool00b8F?n0o
h01KOol00`00Oomoo`0WOol002Uoo`03001oogoo08ioo`8R5P05OolR5R8F8QHoh0048QH6Ool013oP
8QIoogoo0SoP00=oogd0Ool017oo0coP00Am07oo8QHR5P8oh0Ioo`03?n1oogoo009m0004Ooloh3oP
Ool2?n000gd0Oomoo`02Ool2?n03Ool28QH2?n0017oo8QHoh3oP0goo00<R5SoP?n00GGoo00<007oo
Ool09goo000YOol00`00Oomoo`2=Ool48QH00goo?n0oh009Ool00b8F?n1oo`02Ool013oPO@1oogd0
0goo0coP0Woo00=m07oo8QH00SoP27oo00Loh7d0O@1oob8F?n1oo`02?n02O@04Ool013oPOomoogoo
0R8F0SoP0Woo0SoP17oo0SoPGgoo00<007ooOol09goo000YOol00`00Oomoo`2;Ool28QH3Ool2?n09
Ool28QH00coPOomoo`02?n000gd0Oomm0004?n03Ool2O@000b8F?n0oh009Ool013oPO@0R5R8F13oP
0Woo0Wd00Woo0SoP0Woo00@R5SoP?n0oh09oo`8oh0Aoo`8oh65oo`03001oogoo02Moo`00:Goo00<0
07ooOol0RGoo0b8F0Woo0SoP2Goo0R8F00=oocoPOol00SoP00=m028F?n000SoP1Woo00Em028F?n0o
h7d000Uoo`038QHoh28F00@oh0=oo`9m0003Ooloh3oP009oo`038QHoh3oP00Aoo`03?n1oogoo009o
o`8oh6=oo`03001oogoo02Moo`00:Goo00<007ooOol0Qgoo0R8F00=oob8FOol00SoP2Goo0R8F0Woo
0coP00Im03oP?n0oh7ooO@05Ool017d08QHoh3oP0Woo00=m07ooOol00goo128F00<oh28F?n000SoP
00=oob8FOol00Woo00Im07oo?n0R5Woo8QH2?n04Ool2?n03Ool2?n1UOol00`00Oomoo`0WOol002Uo
o`03001oogoo08Eoo`8R5P9oo`038QHoh3oP00Uoo`8R5P=oo`Doh0048QIoogooO@05Ool00b8F?n0o
h003Ool017d0Oomoogoo0b8F0Wd00R8F0coP0Woo00DR5WooOomoogd0008oh004OolR5SoP?n04Ool2
?n03Ool2?n1WOol00`00Oomoo`0WOol002Uoo`03001oogoo08=oo`8R5P=oo`8oh0Uoo`8R5P9oo`@o
h005Oomm07ooOolR5P02Ool01Gd0Oomoogoo8QH00SoP1Goo00Em028F8QHR5Woo009m008R5P<oh0Ao
o`038QIoogd0008oh08R5P8oh0Eoo`04?n0R5WooOol2?n1YOol00`00Oomoo`0WOol001Qoo`D0009o
o`<000Moo`03001oogoo085oo`8R5P=oo`8oh0Uoo`038QHoh3oP00Doh003Oomm07d0009oo`048QIo
ogooO@03Ool2?n05Ool38QH3Ool00gd08QHoh003?n04Ool01Gd08QIm07d0?n000R8F0SoP1Goo0SoP
0Woo0SoPJgoo00<007ooOol00goo1@000Woo0`006Woo000HOol00`00Oomoo`03Ool01@00Oomoogoo
00001Woo00<007ooOol0Ogoo0R8F0goo0SoP00<R5WooOol00goo1SoP0Woo0SoP00AoocoPOomm00=o
o`048QIoogooO@02Ool2?n04Ool38QH017ooO@1oogoo1CoP0Woo00<oh7d0O@000Wd000Eoob8F?n0o
h28F008oh0Eoo`8oh09oo`8oh6eoo`03001oogoo00=oo`03001oogoo00=oo`05001oogooOol0000I
Ool001Uoo`03001oogoo009oo`05001oogooOol00006Ool3001mOol28QH3Ool2?n000goo8QIoo`05
?n000goo8QHR5P03Ool2?n02Ool00coPO@1m0004Ool0128FOomoogd00SoP00=m07ooOol00b8F0goo
00Em03oP?n0oh28F008oh0=m0003?n1oogoo00=oo`038QHoh28F008oh0Ioo`03?n0R5Woo008oh6eo
o`<000Ioo`03001oogoo009oo`05001oogooOol0000IOol001Yoo`80009oo`05001oogooOol00006
Ool00`00Oomoo`1kOol28QH3Ool7?n04Ool28QH3Ool2?n04Ool00coPOomoo`03Ool00b8FOomoo`02
?n000gd08QHR5P028QH4Ool3?n028QH2?n000gd0Oomoo`02Ool00coPOomoo`02Ool4?n06Ool2?n00
0goo?n0oh01aOol00`00Oomoo`05Ool20002Ool01@00Oomoogoo00006Goo000LOol00`00Ool00003
Ool00`00Oomoo`04Ool00`00Oomoo`1iOol28QH3Ool4?n000b8FOomoo`04Ool28QH2Ool3?n05Ool0
0coPOomoo`03Ool0128FOoloh3oP0b8F1Goo0coP00=m028F8QH00SoP1Woo00@oh7ooOomoo`@oh0Io
o`8oh0048QHoh3oP8QIbOol00`00Oomoo`07Ool00`00Ool00003Ool00`00Oomoo`0GOol001aoo`03
001oo`0000=oo`03001oogoo00Aoo`03001oogoo07Moo`8R5P=oo`<oh09oo`038QIoogoo00=oo`8R
5P9oo`8oh0Ioo`03O@0oh7oo00Eoo`8oh08R5P04O@1oogd0O@04?n000gd0OolR5P03?n08Ool00coP
OolR5P03?n000b8FOomoo`03Ool2?n00128F?n0oh28FM7oo00<007ooOol01goo00<007oo00000goo
00<007ooOol05goo000HOol01`00Oomoogoo001oo`0000=oo`03001oogoo00Aoo`03001oogoo07Eo
o`8R5P=oo`@oh09oo`038QIoogoo009oo`8R5P9oo`8oh0Moo`03O@0oh7d000=m00048QHoh3oP8QH4
O@03?n04Ool00b8F?n0oh00:Ool00coP8QHoh002?n000goo8QIoo`04Ool01CoP8QHoh3oP8QH0MWoo
00<007ooOol00goo00L007ooOomoo`00Ool00003Ool00`00Oomoo`0GOol001Uoo`<000=oo`<000Mo
o`03001oogoo07=oo`8R5P=oo`8oh003Ooloh7oo009oo`048QIoogooOol28QH2Ool2?n09Ool00coP
8QHR5P028QH2?n00128FOomoogoo0coP1Goo00<R5SoP?n0027oo128F0coP0goo00@R5WooOomoo`@o
h0038QIoogoo07Ioo`03001oogoo00Aoo`<000=oo`<001Yoo`00:Goo00<007ooOol0LGoo0R8F0Woo
0coP0Woo00Doh7ooOomoob8F009oo`8R5P9oo`8oh0Ioo`@R5P04?n1oogooOol2?n02Ool0128F?n0o
h3oP1Woo00<R5SoP?n001goo0b8F0Woo0coP1Goo00<R5Woo?n000coP00<R5WooOol0N7oo00<007oo
Ool09goo000YOol00`00Oomoo`1_Ool28QH2Ool2?n04Ool01SoPOomoogoo8QIoo`8R5P04Ooloh3oP
?n03Ool58QH4Ool013oP8QHoh3oP0Woo0coP1goo00<R5SoP?n001Woo0b8F0Woo0coP00=oocoPOol0
17oo00<R5Woo?n000SoP00<R5WooOol0NWoo00<007ooOol09goo000YOol00`00Oomoo`1]Ool28QH2
Ool2?n05Ool013oPOomoogoo0b8F00=oocoP?n001R8F27oo1coP00<R5WooOol01Goo0coP1Goo0b8F
00=oocoP?n000coP0Woo00<oh7ooOol017oo0coP00<R5WooOol0O7oo00<007ooOol09goo000YOol0
0`00Oomoo`1[Ool28QH017oo?n0oh3oP1Goo0SoP0goo0b8F0SoP0R8F37oo00<R5SoP?n000SoP0goo
00<R5WooOol017oo0SoP1Goo0b8F00=oocoP?n0013oP17oo00<oh7ooOol00Woo0coP00<R5WooOol0
OWoo00<007ooOol09goo000YOol00`00Oomoo`1YOol28QH00goo?n0oh007Ool00coP8QHR5P048QH2
?n0=Ool00b8F?n0oh002?n06Ool00b8FOomoo`02Ool2?n04Ool38QH01Goo?n0oh3oPOol00SoP1Woo
00@oh7ooOomoo`<oh0038QIoogoo081oo`03001oogoo02Moo`00:Goo00<007ooOol0Igoo0R8F00=o
ocoP?n00228F00<oh7ooOol00b8F0SoP2goo1coP1goo00@R5WooOomoo`8oh0=oo`<R5P04Ooloh3oP
?n02Ool2?n08Ool00coPOomoo`02?n000b8FOomoo`22Ool00`00Oomoo`0WOol002Uoo`03001oogoo
06Eoo`<R5P8oh0038QIoogoo00Ioo`04?n0R5R8F8QH3?n09Ool4?n001R8F?n0oh3oPOoloh0Moo`03
8QIoogoo008oh003OolR5R8F008R5P04Ooloh3oP?n02Ool3?n09Ool013oP8QHoh3oPQgoo00<007oo
Ool09goo000YOol00`00Oomoo`1SOol28QH3?n0:Ool00coP8QIoo`02?n000b8FOomoo`04Ool5?n00
0goo8QHR5P02?n04Ool00coPOomoo`04Ool0128FOoloh3oP0b8F00=oocoP?n000SoP0goo0SoP00<R
5WooOol01Woo0b8F0SoPRGoo00<007ooOol09goo000YOol00`00Oomoo`1POol38QH2?n0;Ool2?n00
1Goo?n0oh7oo8QH00Woo1CoP17oo00@R5SoP?n0oh0Eoo`03?n1oogoo00Aoo`<oh08R5P04Ooloh3oP
?n05Ool2?n08Ool38QH00goo?n0oh02;Ool00`00Oomoo`0WOol002Uoo`03001oogoo05ioo`8R5P03
Ooloh3oP00Yoo`8R5P04?n1oocoP?n02Ool4?n07Ool3?n07Ool00coPOomoo`03Ool2?n028QH017oo
?n0oh3oP1Goo0coP1goo0b8F13oPSGoo00<007ooOol09goo000YOol00`00Oomoo`1KOol38QH3?n00
0b8FOomoo`07Ool28QH00goo?n0oh005?n09Ool2?n09Ool00coPOomoo`028QH2?n028QH3?n06Ool2
?n000b8FOomoo`04Ool38QH3?n2AOol00`00Oomoo`0WOol002Uoo`03001oogoo05Uoo`8R5P05Oolo
h3oPOolR5P08Ool28QH6?n04Ool00b8FOomoo`04Ool3?n09Ool00b8F?n0R5P028QH2?n00128F?n0o
h3oP1goo0SoP00<R5WooOol00Woo128F0coPU7oo00<007ooOol09goo000YOol2001GOol38QH017oo
?n0oh7oo0R8F0goo2coP1Woo00<R5WooOol00goo0SoP27oo128F00=oocoPOol01CoP00=oob8FOol0
1Goo0SoP00@R5WooOomoo`<R5P@oh9Ioo`8002Uoo`00:Goo00<007ooOol0E7oo0R8F0Woo2SoP0Woo
0R8F00=oocoP?n000Woo00<oh7ooOol017oo00@R5WooOomoo`<oh0Eoo`DR5PAoo`@oh0Aoo`038QIo
ogoo009oo`<oh0=oo`<R5P<oh9]oo`03001oogoo02Moo`00:Goo00<007ooOol0DGoo0b8F00=oocoP
?n000coP00=oob8FOol017oo0b8F0coP0Woo0SoP1Woo00<R5WooOol00SoP00@R5WooOomoo`@R5PIo
o`@oh0Ioo`048QIoogooOol2?n000b8FOomoo`038QH3?n2NOol00`00Oomoo`0WOol002Uoo`03001o
ogoo04moo`8R5P03Ooloh3oP008oh0=oo`8R5PAoo`8R5P<oh0Aoo`03?n1oogoo00Eoo`058QHoh3oP
?n1oo`058QH5Ool7?n07Ool00b8FOomoo`02?n00128FOolR5R8F13oPXGoo00<007ooOol09goo000Y
Ool00`00Oomoo`1<Ool38QH01Goo?n0oh7oo?n0017oo00@R5WooOomoo`<R5P8oh0Ioo`03?n1oogoo
00Eoo`8oh0@R5PIoo`Loh0=oo`03?n1oogoo00Eoo`<oh0<R5P<oh:Eoo`03001oogoo02Moo`00:Goo
00<007ooOol0BWoo0R8F00EoocoP?n0oh7oo008oh0=oo`8R5P9oo`8R5P<oh0Moo`03?n1oogoo009o
o`048QHoh3oP?n028QH5Ool5?n02Ool2?n05Ool00coPOomoo`04Ool2?n038QH3?n2XOol00`00Oomo
o`0WOol002Uoo`03001oogoo04Moo`<R5P<oh0=oo`03?n1oogoo009oo`048QIoogoo8QH3?n08Ool0
0b8F?n0R5P028QH3?n028QH3Ool5?n04Ool3?n06Ool00coPOomoo`03Ool2?n000b8F?n0oh002?n2[
Ool00`00Oomoo`0WOol002Uoo`03001oogoo04Eoo`8R5P<oh0Aoo`8oh0Aoo`<R5P8oh0=oo`LR5P8o
h09oo`8oh0038QIoogoo00Doh0Ioo`<oh0Qoo`04?n1oogoo8QH6?n2_Ool00`00Oomoo`0WOol002Uo
o`03001oogoo049oo`<R5P8oh0Eoo`8oh0Aoo`8R5P<oh0DR5PIoo`03?n1oocoP008oh003Ooloh3oP
008oh0Qoo`<oh0038QIoogoo00Moo`038QHoh28F00Doh;9oo`03001oogoo02Moo`00:Goo00<007oo
Ool0@7oo0R8F0coP0goo0b8F00<oh28F8QH00b8F0coP00<R5WooOol02Woo1coP0Woo00<R5WooOol0
17oo0coP00<R5WooOol01Goo1B8F1CoP]Goo00<007ooOol09goo000YOol00`00Oomoo`0mOol28QH3
?n068QH00goo?n0oh002Ool28QH2?n0<Ool6?n06Ool00b8FOomoo`02Ool3?n028QH5Ool48QH2Ool4
?n2iOol00`00Oomoo`0WOol002Uoo`03001oogoo03Yoo`<R5P8oh0Uoo`04?n1oob8F8QH3?n000b8F
Oomoo`05Ool9?n08Ool0128FOomoogoo0SoP0R8F17oo128F00=oocoP?n000coP_Goo00<007ooOol0
9goo000YOol00`00Oomoo`0hOol28QH3?n09Ool2?n001R8F?n0oh3oPOolR5P=oo`Hoh09oo`<oh09o
o`03?n1oogoo00Ioo`038QIoocoP008oh0038QIoogoo00DR5P03Ooloh3oP008oh<9oo`03001oogoo
02Moo`00:Goo00<007ooOol0=Goo0R8F0coP2Woo00<R5SoP8QH00SoP0Woo1SoP1Goo0coP17oo00<o
h7ooOol01Woo0coP1R8F00=oocoP?n000coPaWoo00<007ooOol09goo000YOol2000cOol28QH3?n02
8QH8Ool28QH8?n000b8FOomoo`05Ool3?n05Ool2?n06Ool3?n058QH5?n3:Ool2000YOol002Uoo`03
001oogoo02moo`<R5P8oh003OolR5R8F00Ioo`Poh0Aoo`038QIoogoo00Aoo`<oh0Moo`03?n1oogoo
00=oo`<oh0@R5P@oh=1oo`03001oogoo02Moo`00:Goo00<007ooOol0;7oo0b8F0coP00=oocoP?n00
23oP00<R5SoP?n000SoP1Woo00<R5WooOol00Woo0coP2Goo00<oh7oo8QH00R8F0SoP00<R5Woo?n00
13oPe7oo00<007ooOol09goo000YOol00`00Oomoo`0ZOol28QH7?n06Ool00b8F?n0oh002?n000goo
?n1oo`06Ool00b8FOomoo`03?n000b8FOomoo`04Ool48QH00coP8QHR5P07?n3IOol00`00Oomoo`0W
Ool002Uoo`03001oogoo02Moo`8R5P<oh0Aoo`8R5PAoo`048QHoh3oP?n03Ool2?n06Ool28QH3?n00
0b8FOomoo`078QH3Ool6?n3NOol00`00Oomoo`0WOol002Uoo`03001oogoo02Aoo`8R5P@oh0Aoo`8R
5P=oo`048QHoh3oP?n05Ool00coPOomoo`05Ool3?n068QH7Ool5?n3ROol00`00Oomoo`0WOol002Uo
o`03001oogoo025oo`038QHoh3oP00@oh0Eoo`038QIoogoo00@oh0Ioo`8oh0=oo`8R5P<oh0<R5PMo
o`Hoh>Moo`03001oogoo02Moo`00:Goo00<007ooOol07Woo00@R5SoP?n0oh09oo`8oh0Eoo`8R5P<o
h0Ioo`<R5P03?n0R5R8F008R5P<oh0Moo`Hoh>eoo`03001oogoo02Moo`00:Goo00<007ooOol077oo
0coP0goo0SoP1Goo00@R5SoP?n0oh0TR5P03Ooloh3oP009oo`<oh0Aoo`Hoh?=oo`03001oogoo02Mo
o`006Goo0`000goo0`001goo00<007ooOol06Goo0coP17oo0SoP128F13oP0b8F2Goo00<oh7oo?n00
0SoP00=oocoP?n0013oPnGoo00<007ooOol017oo0`000goo0`006Woo000HOol01`00Oomoogoo001o
o`0000=oo`03001oogoo00Aoo`<001Ioo`<oh0DR5P8oh0=oo`<oh0ioo`Poh?eoo`<000Eoo`07001o
ogooOol007oo00000goo00<007ooOol05goo000LOol00`00Ool00003Ool00`00Oomoo`04Ool00`00
Oomoo`0COol3?n06Ool2?n02Ool3?n0<Ool7?n3oOol6Ool00`00Oomoo`07Ool00`00Ool00003Ool0
0`00Oomoo`0GOol001aoo`03001oo`0000=oo`03001oogoo00Aoo`03001oogoo011oo`<oh0Moo`Ho
h0Eoo`Xoh?moo`eoo`03001oogoo00Moo`03001oo`0000=oo`03001oogoo01Moo`0067oo10000Woo
00D007ooOomoo`0000Ioo`03001oogoo00aoo`@oh0Qoo`doh?mooaMoo`03001oogoo00=oo`@0009o
o`05001oogooOol0000IOol001Qoo`03001oogoo00=oo`05001oogooOol00006Ool00`00Oomoo`09
Ool3?n07Ool9?n3oOolPOol00`00Oomoo`03Ool00`00Oomoo`03Ool01@00Oomoogoo00006Goo000H
Ool00`00Oomoo`03Ool01@00Oomoogoo00001Woo00<007ooOol01Woo3CoPogoo:Goo00<007ooOol0
0goo00<007ooOol00goo00D007ooOomoo`0001Uoo`0067oo1@000Woo0`001goo00<007ooOol017oo
1CoPogoo<goo00<007ooOol00goo1@000Woo0`006Woo000YOol00`00Oomoo`3oOollOol00`00Oomo
o`0WOol002Uoo`03001oogoo0?moocaoo`03001oogoo02Moo`00:Goo0P000Woo00<007ooOol0<Woo
00<007ooOol0<Woo00<007ooOol0<goo00<007ooOol0<Woo00<007ooOol0<Woo00<007ooOol0;7oo
0P00:Goo000YOol01@00Oomoogoo00009goo00D007ooOomoo`00009oo`800003Ool00000008002Qo
o`08001oogooOol007oo001oo`D002Qoo`08001oogooOol007oo001oo`H002Moo`05001oogooOol0
0002Ool200000goo00000002000XOol02000Oomoogoo001oo`00Ool5000XOol01P00Oomoogoo001o
o`8002Uoo`00:Gooo`00@000:Goo003oOonBOol00?mooi9oo`00ogooTWoo003oOonBOol00?mooi9o
o`00ogooTWoo003oOonBOol001Uoo`03001oogoo009oo`04001oogoo0003Ool00`00Oomoo`03Ool0
0`00Oomoo`02Ool3000LOol00`00Oomoo`02Ool00`00Ool00003Ool00`00Oomoo`03Ool00`00Oomo
o`02Ool3000LOol00`00Oomoo`02Ool01000Oomoo`000goo00<007ooOol00Woo00<007ooOol00Woo
0`0077oo00<007ooOol00Woo00@007ooOol000=oo`03001oogoo00=oo`03001oogoo009oo`<001eo
o`03001oogoo009oo`04001oogoo0003Ool00`00Oomoo`03Ool00`00Oomoo`02Ool3000ROol30003
Ool00`00Oomoo`030003Ool30004Ool00`00Oomoo`1<Ool001Uoo`03001oogoo00Ioo`03001oo`00
00Ioo`05001oogooOol00003Ool00`00Oomoo`0IOol00`00Oomoo`05Ool00`00Ool00006Ool01@00
Oomoogoo00000goo00<007ooOol06Goo00<007ooOol01Woo00<007oo00001Goo00D007ooOomoo`00
00=oo`03001oogoo01Uoo`03001oogoo00Ioo`03001oo`0000Ioo`05001oogooOol00003Ool00`00
Oomoo`0JOol00`00Oomoo`06Ool00`00Ool00006Ool01@00Oomoogoo00000goo00<007ooOol07Woo
00D007ooOomoo`0000Aoo`07001oogooOol007oo00000goo00D007ooOomoo`0004ioo`006Goo00<0
07ooOol01goo00<007ooOol01Goo00D007ooOomoo`0000=oo`03001oogoo01Uoo`03001oogoo00Io
o`03001oogoo00Eoo`05001oogooOol00003Ool00`00Oomoo`0IOol00`00Oomoo`07Ool00`00Oomo
o`04Ool01@00Oomoogoo00000goo00<007ooOol06Goo00<007ooOol01goo00<007ooOol01Goo00D0
07ooOomoo`0000=oo`03001oogoo01Yoo`03001oogoo00Moo`03001oogoo00Eoo`05001oogooOol0
0003Ool00`00Oomoo`0NOol01@00Oomoogoo000017oo00L007ooOomoo`00Ool00003Ool01@00Oomo
ogoo0000CWoo000IOol00`00Oomoo`06Ool00`00Ool00006Ool01@00Oomoogoo00000goo00<007oo
Ool06Goo00<007ooOol01Goo00<007oo00001Woo00D007ooOomoo`0000=oo`03001oogoo01Uoo`03
001oogoo00Ioo`03001oo`0000Eoo`05001oogooOol00003Ool00`00Oomoo`0IOol00`00Oomoo`06
Ool00`00Ool00006Ool01@00Oomoogoo00000goo00<007ooOol06Woo00<007ooOol01Woo00<007oo
00001Woo00D007ooOomoo`0000=oo`03001oogoo01ioo`05001oogooOol00004Ool01`00Oomoogoo
001oo`0000=oo`05001oogooOol0001>Ool001Uoo`03001oogoo00Eoo`05001oogooOol00005Ool0
1@00Oomoogoo00000goo00<007ooOol06Goo00<007ooOol017oo00D007ooOomoo`0000Eoo`05001o
ogooOol00003Ool00`00Oomoo`0IOol00`00Oomoo`05Ool01@00Oomoogoo000017oo00D007ooOomo
o`0000=oo`03001oogoo01Uoo`03001oogoo00Eoo`05001oogooOol00005Ool01@00Oomoogoo0000
0goo00<007ooOol06Woo00<007ooOol01Goo00D007ooOomoo`0000Eoo`05001oogooOol00003Ool0
0`00Oomoo`0NOol01@00Oomoogoo000017oo00L007ooOomoo`00Ool00003Ool01@00Oomoogoo0000
CWoo000IOol00`00Oomoo`0?Ool01@00Oomoogoo00000goo00<007ooOol00Woo1`0047oo00<007oo
Ool03Woo00D007ooOomoo`0000=oo`03001oogoo00Eoo`03001oogoo008000moo`03001oogoo00io
o`05001oogooOol00003Ool00`00Oomoo`05Ool00`00Oomoo`02000?Ool00`00Oomoo`0?Ool01@00
Oomoogoo00000goo00<007ooOol017oo00D007ooOomoo`00015oo`03001oogoo00moo`05001oogoo
Ool00003Ool00`00Oomoo`05Ool00`00Oomoo`0FOol01@00Oomoogoo000017oo00L007ooOomoo`00
Ool00003Ool01@00Oomoogoo0000CWoo000HOol2000@Ool20003Ool01000Oomoogoo1@0000=oo`00
Ool017oo00<007ooOol037oo0P003goo0P000goo00@007ooOomoo`D000=oo`03001oogoo009oo`03
001oogoo00]oo`8000moo`8000=oo`04001oogooOol50003Ool00`00Oomoo`02Ool00`00Oomoo`0;
Ool2000@Ool20003Ool01000Oomoogoo1@000Woo00D007ooOomoo`00011oo`80011oo`8000=oo`04
001oogooOol50003Ool00`00Oomoo`0FOol01@00Oomoogoo000017oo00L007ooOomoo`00Ool00003
Ool00`00Oomoo`02001>Ool001Uoo`03001oogoo00moo`03001oogoo009oo`<000Ioo`8000=oo`03
001oogoo00ioo`03001oogoo00ioo`03001oogoo009oo`<000Qoo`03001oo`0000<000ioo`03001o
ogoo00ioo`03001oogoo009oo`<000Qoo`03001oo`00009oo`03001oogoo00aoo`03001oogoo00mo
o`03001oogoo009oo`<000Moo`05001oogooOol0000AOol00`00Oomoo`0?Ool00`00Oomoo`02Ool3
0008Ool00`00Oomoo`0GOol30006Ool30003Ool30004Ool00`00Oomoo`1<Ool003Qoo`03001oogoo
0080009oo`03001oogoo02ioo`03001oo`00009oo`03001oogoo02eoo`03001oogoo0080031oo`05
001oogooOol0000dOol00`00Oomoo`1kOol003Uoo`H0035oo`03001oogoo00<002moo`03001oogoo
00<002moo`05001oogooOol0000bOol3001mOol00?mooi9oo`00ogooTWoo003dOol3000EOol30022
Ool00?=oo`05001oogooOol0000COol01@00Oomoogoo0000PGoo003gOol00`00Oomoo`0EOol00`00
Oomoo`1oOol0065oo`03001oogoo00Eoo`04001oogooOol30003Ool20005Ool30003Ool00`00Oomo
o`05Ool01@00Oomoogoo000017oo0`000goo00D007ooOomoo`0000=oo`03001oogoo00=oo`03001o
ogoo00=oo`8000Ioo`<000=oo`05001oogooOol00004Ool30003Ool00`00Oomoo`05Ool30003Ool0
1@00Oomoogoo00001Goo0`0000=oo`00Ool00goo00@007ooOomoo`<000Aoo`800003Ool007oo00Qo
o`04001oogooOol30004Ool200000goo001oo`04Ool20004Ool30004Ool3000017oo001oo`000goo
0`00HWoo001QOol00`00Oomoo`05Ool01000Oomoo`000goo00@007ooOol000Eoo`05001oogooOol0
0002Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`05001oogooOol0
0002Ool00`00Oomoo`04Ool00`00Oomoo`02Ool01000Oomoo`0017oo00D007ooOomoo`00009oo`05
001oogooOol00003Ool01@00Oomoogoo00000Woo00<007ooOol017oo00D007ooOomoo`00009oo`05
001oogooOol00004Ool01@00Oomoogoo00001Goo00@007ooOol000=oo`04001oogoo0002Ool20009
Ool01000Oomoo`000goo00@007ooOol0009oo`8000Aoo`04001oogoo0002Ool01@00Oomoogoo0000
0Woo00D007ooOomoo`00009oo`04001oogoo0003Ool00`00Oomoo`1OOol0065oo`03001oogoo00Eo
o`04001oogoo0003Ool01000Oomoo`001Goo00D007ooOomoo`00009oo`03001oogoo00Aoo`07001o
o`00Ool007oo00000Woo00D007ooOomoo`00009oo`07001oogooOol007oo00001Woo00<007oo0000
1Woo00<007ooOol00Woo00<007ooOol017oo00D007ooOomoo`0000=oo`05001oogooOol00002Ool0
0`00Oomoo`04Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000Aoo`05001oogooOol00005Ool0
1000Oomoo`000goo00@007ooOol000=oo`03001oogoo00Moo`04001oogoo0003Ool01000Oomoo`00
0goo00<007ooOol01Goo00@007ooOol000Ioo`05001oogooOol00002Ool01000Oomoo`00IGoo001Q
Ool00`00Oomoo`05Ool01000Oomoo`000goo00@007ooOol000Eoo`05001oogooOol00002Ool00`00
Oomoo`04Ool01000Oomoo`000Woo00@007ooOol000=oo`04001oogoo0003Ool20007Ool00`00Ool0
0004Ool20005Ool50002Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`03001oogoo00Ao
o`05001oogooOol00002Ool01@00Oomoogoo00001Goo10001Goo00@007ooOol000=oo`04001oogoo
0003Ool00`00Ool0000600001Goo001oogoo00000goo00@007ooOol000=oo`03001oogoo00=oo`80
00=oo`03001oogoo00Eoo`@0009oo`03001oogoo00D0065oo`00HGoo1@000goo00@007ooOol000=o
o`04001oogoo0005Ool01@00Oomoogoo00000Woo00<007ooOol017oo00@007ooOol0009oo`04001o
ogoo0003Ool01000Oomoo`000goo0P001Woo00D007ooOomoo`00009oo`03001oogoo00Eoo`05001o
ogooOol00002Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`03001oogoo00Aoo`05001o
ogooOol00002Ool01@00Oomoogoo000027oo00<007ooOol00goo00@007ooOol000=oo`04001oogoo
0003Ool00`00Oomoo`07Ool01000Oomoo`000goo00@007ooOol000=oo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo00Qoo`04001oogoo0002Ool01@00Oomoogoo0000HGoo001QOol00`00Oomo
o`02Ool01000Oomoo`000Woo00D007ooOomoo`00009oo`03001oogoo00=oo`05001oogooOol00002
Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00<007oo00000goo00<007ooOol00P000Woo00<0
07oo00001Goo00D007ooOomoo`00009oo`04001oogoo0004Ool01@00Oomoogoo00000Woo0P000Woo
0P000Woo00D007ooOomoo`00009oo`8000Eoo`05001oogooOol00002Ool20002Ool00`00Oomoo`02
Ool01@00Oomoogoo00001Goo00@007ooOol000=oo`04001oogoo0002Ool20009Ool01000Oomoo`00
0goo00@007ooOol0009oo`8000Aoo`04001oogoo0002Ool01@00Oomoogoo00000Woo00D007ooOomo
o`00009oo`04001oogoo0003Ool00`00Oomoo`1OOol0065oo`03001oogoo009oo`04001oogoo0003
Ool30002Ool30005Ool30002Ool30004Ool01@00Oomoogoo00000goo00<007ooOol00`000goo00D0
07oo001oo`00009oo`03001oogoo009oo`05001oogooOol00003Ool20006Ool30003Ool01`00Ool0
07oo001oo`00009oo`<000=oo`03001oo`0000Eoo`<000=oo`04001oo`000006Ool30006Ool01000
Oomoogoo0`0017oo0P0000=oo`00Ool027oo00@007ooOomoo`<000Aoo`800003Ool007oo00Aoo`80
00Aoo`<000Aoo`<000=oo`04001oogooOol3001ROol0065oo`03001oogoo009oo`04001oogoo0009
Ool00`00Oomoo`0:Ool00`00Oomoo`0HOol00`00Oomoo`1;Ool00`00Oomoo`0EOol00`00Oomoo`0T
Ool00`00Oomoo`1VOol0065oo`D000=oo`03001oogoo00Moo`03001oogoo00]oo`8001Qoo`03001o
ogoo04]oo`03001oogoo01Eoo`03001oogoo02Aoo`03001oogoo06Ioo`00\
\>"],
  ImageRangeCache->{{{93.5625, 593.562}, {479.5, 171.062}} -> {-32.0039, \
1.06683, 0.0750152, 0.00937161}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fine-tuning", "Section",
  CellTags->"s:6"],

Cell[CellGroupData[{

Cell["StepSizeSafetyFactors", "Subsection"],

Cell[TextData[{
  "As with most methods, you want a balance between taking too small a step \
and trying to take too big a step that will be frequently rejected. The \
option ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["StepSizeSafetyFactors",
            "MR"], "->", \({s\_1, s\_2}\)}], TraditionalForm]]],
  " constrains the choice of step size as follows. The step size chosen by \
the method for order ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " satisfies:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(h\_\(n + 1\)\), "=", " ", 
        RowBox[{\(h\_n\), \(s\_1\), " ", 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{\(s\_2\), 
                FormBox[
                  FractionBox[
                    StyleBox["Tol",
                      FontSlant->"Italic"], 
                    RowBox[{"\[LeftDoubleBracketingBar]", 
                      SubscriptBox[
                        StyleBox["err",
                          FontSlant->"Italic"], "n"], 
                      "\[RightDoubleBracketingBar]"}]],
                  "TraditionalForm"]}], ")"}], \(1\/\(p + 1\)\)]}]}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"ExtrapolationStepControl"],

Cell["\<\
This includes both an order-dependent factor and an \
order-independent factor.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["StepSizeRatioBounds", "Subsection"],

Cell[TextData[{
  "The option ",
  StyleBox["StepSizeRatioBounds\[Rule]{", "MR"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`sr\_min\)], "MR"], "MR"],
  StyleBox[",", "MR"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`sr\_max\)], "MR"], "MR"],
  StyleBox["}", "MR"],
  " specifies bounds on the next step size to take such that:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          StyleBox["sr",
            FontSlant->"Italic"], 
          StyleBox["min",
            FontSlant->"Italic"]], 
        "\[LessEqual]", \(\[LeftBracketingBar]h\_\(n + 1\)\/h\_n\
\[RightBracketingBar]\), "\[LessEqual]", 
        SubscriptBox[
          StyleBox["sr",
            FontSlant->"Italic"], 
          StyleBox["max",
            FontSlant->"Italic"]]}], TraditionalForm]], "DisplayFormula"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OrderSafetyFactors", "Subsection"],

Cell[TextData[{
  "An important aspect in ",
  StyleBox["Extrapolation", "MR"],
  " is the choice of order. "
}], "Text"],

Cell[TextData[{
  "Each extrapolation of order ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " has an associated work estimate ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalA]\_k\)]],
  " which is based on, for example, the number of function evaluations of the \
base method and the step sequence used."
}], "Text"],

Cell["\<\
The work estimate for explicit base methods is based on the number \
of function evaluations and the step sequence used.\
\>", "Text"],

Cell["\<\
The work estimate for linearly implicit base methods also includes \
an estimate of the cost of evaluating the Jacobian, the cost of an LU \
decomposition, and the cost of back solving the linear equations.\
\>", "Text"],

Cell[TextData[{
  "Estimates for the work per unit step are formed from the work estimate ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalA]\_k\)]],
  " and the expected new step size to take for a method of order ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " (computed from (",
  
  CounterBox["NumberedEquation", "ExtrapolationStepControl"],
  ")): ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalW]\_k\  = \ \[ScriptCapitalA]\_k/\ 
          h\_\(n + 1\)\%k\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Comparing consecutive estimates, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[ScriptCapitalW]\_k\)\(\ \)\)\)]],
  " allows a decision about when a different order method will be more \
efficient."
}], "Text"],

Cell[TextData[{
  "The option ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["OrderSafetyFactors",
            "MR"], "->", \({f\_1, \ f\_2}\)}], TraditionalForm]]],
  " specifies safety factors to be included in the comparison of estimates ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalW]\_k\)]],
  "."
}], "Text"],

Cell[TextData[{
  "An order decrease is made when ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\[ScriptCapitalW]\_\(k - 
              1\)\)\(<\)\)\(\ \)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(f\_1\) \[ScriptCapitalW]\_k\)]],
  "."
}], "Text"],

Cell[TextData[{
  "An order increase is made when ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[ScriptCapitalW]\_\(k + 1\)\), "<", " ", 
          FormBox[\(\(f\_2\) \[ScriptCapitalW]\_k\),
            "TraditionalForm"]}], TraditionalForm]]],
  "."
}], "Text"],

Cell["\<\
There are some additional restrictions, such as when the maximal \
order increase per step is one (two for symmetric methods), and when an \
increase in order is prevented immediately after a rejected step.\
\>", "Text"],

Cell["\<\
For a nonstiff base method the default values are {4/5, 9/10} \
whereas for a stiff method they are {7/10, 9/10}.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option summary", "Section",
  CellTags->"s:7"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["ExtrapolationSequence",
              "MR"], 
            StyleBox["Automatic",
              
              "MR"], \(specifies\ the\ sequence\ to\ use\ in\ \
extrapolation\)},
          {
            StyleBox["MaxDifferenceOrder",
              "MR"], 
            StyleBox["Automatic",
              "MR"], \(specifies\ the\ maximum\ order\ to\ use\)},
          {
            StyleBox["Method",
              "MR"], 
            StyleBox["ExplicitModifiedMidpoint",
              "MR"], Cell[
            "specifies the base integration method to use", "Text"]},
          {
            StyleBox["MinDifferenceOrder",
              "MR"], 
            StyleBox["Automatic",
              "MR"], \(specifies\ the\ minimum\ order\ to\ use\)},
          {
            StyleBox["OrderSafetyFactors",
              "MR"], 
            StyleBox["Automatic",
              
              "MR"], \(specifies\ the\ safety\ factors\ to\ use\ in\ the\ \
estimates\ for\ adaptive\ order\ selection\)},
          {
            StyleBox["StartingDifferenceOrder",
              "MR"], 
            StyleBox["Automatic",
              "MR"], \(specifies\ the\ initial\ order\ to\ use\)},
          {
            StyleBox["StepSizeRatioBounds",
              "MR"], 
            StyleBox["Automatic",
              "MR"], 
            RowBox[{
              RowBox[{
              "specifies", " ", "the", " ", "bounds", " ", "on", " ", "a", 
                " ", "relative", " ", "change", " ", "in", " ", "the", " ", 
                "new", " ", "step", " ", "size", " ", 
                SubscriptBox[
                  StyleBox["h",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox["n",
                      FontSlant->"Italic"], "+", "1"}]], " ", "from", " ", 
                "the", " ", "current", " ", "step", " ", "size", " ", 
                SubscriptBox[
                  StyleBox["h",
                    FontSlant->"Italic"], 
                  StyleBox["n",
                    FontSlant->"Italic"]], " ", "as", " ", "low"}], " ", "<=",
               " ", 
              RowBox[{
                SubscriptBox[
                  StyleBox["h",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox["n",
                      FontSlant->"Italic"], "+", "1"}]], "/", 
                SubscriptBox[
                  StyleBox["h",
                    FontSlant->"Italic"], 
                  StyleBox["n",
                    FontSlant->"Italic"]]}], " ", "<=", " ", "high"}]},
          {
            StyleBox["StepSizeSafetyFactors",
              "MR"], 
            StyleBox[\({9\/10, 9\/10}\),
              
              "MR"], \(specifies\ the\ safety\ factors\ to\ incorporate\ into\
\ the\ error\ estimate\ used\ for\ adaptive\ step\ sizes\)},
          {
            StyleBox["StiffnessTest",
              "MR"], 
            StyleBox["Automatic",
              
              "MR"], \(specifies\ whether\ to\ use\ the\ stiffness\ detection\
\ capability\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options of the method ",
  StyleBox["Extrapolation", "MR"],
  "."
}], "Caption"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["StabilityCheck",
              "MR"], 
            StyleBox["True",
              "MR"], 
            RowBox[{
            "specifies", " ", "whether", " ", "to", " ", "carry", " ", "out", 
              " ", "a", " ", "stability", " ", "check", " ", "on", " ", 
              "consecutive", " ", "implicit", " ", "solutions", " ", 
              RowBox[{"(", 
                RowBox[{"see", " ", 
                  RowBox[{"e", ".", "g", ".", " ", 
                    RowBox[{"(", 
                      
                      CounterBox["NumberedEquation", 
                        "ImplicitEulerStabilityCheck"], ")"}]}]}], ")"}]}]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options of the method ",
  StyleBox["LinearlyImplicitEuler", "MR"],
  ", ",
  StyleBox["LinearlyImplicitMidpoint", "MR"],
  ", and ",
  StyleBox["LinearlyImplicitModifiedMidpoint", "MR"],
  "."
}], "Caption"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
AutoGeneratedPackage->None,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Extrapolation",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[1776, 53, 51, 1, 87, "Chapter",
      CellTags->"c:1"]},
  "s:1"->{
    Cell[1852, 58, 50, 1, 67, "Section",
      CellTags->"s:1"]},
  "s:2"->{
    Cell[3521, 110, 51, 1, 67, "Section",
      CellTags->"s:2"]},
  "AitkenNeville"->{
    Cell[5748, 185, 326, 6, 61, "NumberedEquation",
      CellTags->"AitkenNeville"]},
  "s:3"->{
    Cell[14229, 469, 50, 1, 51, "Section",
      CellTags->"s:3"]},
  "EulerSteps"->{
    Cell[16108, 546, 492, 10, 92, "NumberedEquation",
      CellTags->"EulerSteps"]},
  "ExplicitRungeKuttaMethod"->{
    Cell[17500, 595, 455, 10, 48, "NumberedEquation",
      CellTags->"ExplicitRungeKuttaMethod"]},
  "ExplicitRungeKuttaCoefficients"->{
    Cell[18037, 609, 544, 11, 93, "NumberedEquation",
      CellTags->"ExplicitRungeKuttaCoefficients"]},
  "EulerIncrements"->{
    Cell[19173, 647, 753, 16, 98, "NumberedEquation",
      CellTags->"EulerIncrements"]},
  "EulerIncrementResult"->{
    Cell[20834, 705, 156, 3, 28, "NumberedEquation",
      CellTags->"EulerIncrementResult"]},
  "LinearlyImplicitEulerSteps"->{
    Cell[22025, 748, 830, 16, 151, "NumberedEquation",
      CellTags->"LinearlyImplicitEulerSteps"]},
  "LinearlyImplicitEulerIncrements"->{
    Cell[24157, 819, 843, 17, 98, "NumberedEquation",
      CellTags->"LinearlyImplicitEulerIncrements"]},
  "ExplicitMidpointSteps"->{
    Cell[26114, 887, 506, 10, 92, "NumberedEquation",
      CellTags->"ExplicitMidpointSteps"]},
  "ExplicitMidpointIncrements"->{
    Cell[27330, 928, 943, 22, 98, "NumberedEquation",
      CellTags->"ExplicitMidpointIncrements"]},
  "GraggSmoothingStep"->{
    Cell[28551, 965, 186, 4, 28, "NumberedEquation",
      CellTags->"GraggSmoothingStep"]},
  "ModifiedGraggSmoothingStep"->{
    Cell[29479, 995, 316, 6, 28, "NumberedEquation",
      CellTags->"ModifiedGraggSmoothingStep"]},
  "LinearlyImplicitMidpointSteps"->{
    Cell[155776, 5025, 1150, 23, 151, "NumberedEquation",
      CellTags->"LinearlyImplicitMidpointSteps"]},
  "LinearlyImplicitMidpointIncrements"->{
    Cell[157575, 5078, 1116, 23, 98, "NumberedEquation",
      CellTags->"LinearlyImplicitMidpointIncrements"]},
  "BaderSmoothingStep"->{
    Cell[158983, 5117, 158, 3, 43, "NumberedEquation",
      CellTags->"BaderSmoothingStep"]},
  "ModifiedBaderSmoothingStep"->{
    Cell[159323, 5131, 289, 5, 43, "NumberedEquation",
      CellTags->"ModifiedBaderSmoothingStep"]},
  "ModifiedAitkenNeville"->{
    Cell[161872, 5225, 386, 6, 61, "NumberedEquation",
      CellTags->"ModifiedAitkenNeville"]},
  "s:4"->{
    Cell[163275, 5271, 59, 1, 51, "Section",
      CellTags->"s:4"]},
  "ImplicitEulerStabilityCheck"->{
    Cell[166882, 5404, 401, 8, 42, "NumberedEquation",
      CellTags->"ImplicitEulerStabilityCheck"]},
  "s:5"->{
    Cell[168432, 5451, 46, 1, 51, "Section",
      CellTags->"s:5"]},
  "s:6"->{
    Cell[803151, 31040, 49, 1, 51, "Section",
      CellTags->"s:6"]},
  "ExtrapolationStepControl"->{
    Cell[803785, 31063, 735, 18, 50, "NumberedEquation",
      CellTags->"ExtrapolationStepControl"]},
  "s:7"->{
    Cell[808521, 31227, 52, 1, 51, "Section",
      CellTags->"s:7"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 814013, 31385},
  {"s:1", 814090, 31388},
  {"s:2", 814167, 31391},
  {"AitkenNeville", 814255, 31394},
  {"s:3", 814353, 31397},
  {"EulerSteps", 814439, 31400},
  {"ExplicitRungeKuttaMethod", 814557, 31403},
  {"ExplicitRungeKuttaCoefficients", 814695, 31406},
  {"EulerIncrements", 814824, 31409},
  {"EulerIncrementResult", 814943, 31412},
  {"LinearlyImplicitEulerSteps", 815072, 31415},
  {"LinearlyImplicitEulerIncrements", 815214, 31418},
  {"ExplicitMidpointSteps", 815350, 31421},
  {"ExplicitMidpointIncrements", 815481, 31424},
  {"GraggSmoothingStep", 815609, 31427},
  {"ModifiedGraggSmoothingStep", 815736, 31430},
  {"LinearlyImplicitMidpointSteps", 815874, 31433},
  {"LinearlyImplicitMidpointIncrements", 816025, 31436},
  {"BaderSmoothingStep", 816164, 31439},
  {"ModifiedBaderSmoothingStep", 816293, 31442},
  {"ModifiedAitkenNeville", 816425, 31445},
  {"s:4", 816534, 31448},
  {"ImplicitEulerStabilityCheck", 816639, 31451},
  {"s:5", 816754, 31454},
  {"s:6", 816835, 31457},
  {"ExtrapolationStepControl", 816938, 31460},
  {"s:7", 817052, 31463}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 51, 1, 87, "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{
Cell[1852, 58, 50, 1, 67, "Section",
  CellTags->"s:1"],
Cell[1905, 61, 560, 10, 72, "Text"],
Cell[2468, 73, 287, 5, 56, "Text"],
Cell[2758, 80, 345, 13, 24, "Text"],
Cell[3106, 95, 139, 3, 40, "Text"],
Cell[3248, 100, 236, 5, 42, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[3521, 110, 51, 1, 67, "Section",
  CellTags->"s:2"],
Cell[3575, 113, 325, 9, 40, "Text"],
Cell[3903, 124, 415, 7, 72, "Text"],
Cell[4321, 133, 46, 0, 24, "Text"],
Cell[4370, 135, 136, 2, 30, "DisplayFormula"],
Cell[4509, 139, 179, 6, 24, "Text"],
Cell[4691, 147, 119, 2, 30, "DisplayFormula"],
Cell[4813, 151, 55, 0, 21, "Text"],
Cell[4871, 153, 117, 2, 28, "DisplayFormula"],
Cell[4991, 157, 18, 0, 21, "Text"],
Cell[5012, 159, 119, 2, 45, "DisplayFormula"],
Cell[5134, 163, 338, 11, 35, "Text"],
Cell[5475, 176, 146, 2, 30, "DisplayFormula"],
Cell[5624, 180, 121, 3, 35, "Text"],
Cell[5748, 185, 326, 6, 61, "NumberedEquation",
  CellTags->"AitkenNeville"],
Cell[6077, 193, 88, 3, 21, "Text"],
Cell[6168, 198, 980, 18, 146, "DisplayFormula"],
Cell[7151, 218, 269, 11, 21, "Text"],

Cell[CellGroupData[{
Cell[7445, 233, 45, 0, 35, "Subsection"],
Cell[7493, 235, 128, 3, 35, "Text"],
Cell[7624, 240, 45, 0, 21, "Text"],

Cell[CellGroupData[{
Cell[7694, 244, 97, 2, 24, "Input"],
Cell[7794, 248, 97, 2, 24, "Output"]
}, Open  ]],
Cell[7906, 253, 46, 0, 21, "Text"],

Cell[CellGroupData[{
Cell[7977, 257, 98, 2, 24, "Input"],
Cell[8078, 261, 92, 2, 24, "Output"]
}, Open  ]],
Cell[8185, 266, 46, 0, 21, "Text"],

Cell[CellGroupData[{
Cell[8256, 270, 98, 2, 24, "Input"],
Cell[8357, 274, 89, 2, 24, "Output"]
}, Open  ]],
Cell[8461, 279, 348, 10, 35, "Text"],
Cell[8812, 291, 118, 3, 35, "Text"],

Cell[CellGroupData[{
Cell[8955, 298, 110, 2, 24, "Input"],
Cell[9068, 302, 93, 2, 24, "Output"]
}, Open  ]],
Cell[9176, 307, 147, 3, 35, "Text"],
Cell[9326, 312, 209, 4, 55, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9572, 321, 49, 0, 35, "Subsection"],
Cell[9624, 323, 224, 6, 35, "Text"],
Cell[9851, 331, 190, 6, 21, "Text"],
Cell[10044, 339, 471, 15, 35, "Text"],
Cell[10518, 356, 341, 13, 35, "Text"],
Cell[10862, 371, 252, 6, 35, "Text"],
Cell[11117, 379, 1109, 18, 138, "DisplayFormula"],
Cell[12229, 399, 138, 3, 35, "Text"],
Cell[12370, 404, 360, 12, 35, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12767, 421, 46, 0, 35, "Subsection"],
Cell[12816, 423, 143, 3, 35, "Text"],
Cell[12962, 428, 333, 7, 48, "Text"],
Cell[13298, 437, 882, 26, 62, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14229, 469, 50, 1, 51, "Section",
  CellTags->"s:3"],
Cell[14282, 472, 114, 3, 21, "Text"],
Cell[14399, 477, 63, 0, 23, "BulletedList"],
Cell[14465, 479, 66, 0, 23, "BulletedList"],
Cell[14534, 481, 115, 4, 23, "BulletedList"],
Cell[14652, 487, 71, 0, 23, "BulletedList"],
Cell[14726, 489, 139, 3, 38, "BulletedList"],
Cell[14868, 494, 144, 3, 38, "BulletedList"],
Cell[15015, 499, 178, 6, 21, "Text"],
Cell[15196, 507, 213, 7, 35, "Text"],
Cell[15412, 516, 203, 5, 35, "Text"],

Cell[CellGroupData[{
Cell[15640, 525, 42, 0, 35, "Subsection"],
Cell[15685, 527, 420, 17, 35, "Text"],
Cell[16108, 546, 492, 10, 92, "NumberedEquation",
  CellTags->"EulerSteps"],
Cell[16603, 558, 114, 5, 21, "Text"],

Cell[CellGroupData[{
Cell[16742, 567, 73, 0, 31, "Subsubsection"],
Cell[16818, 569, 462, 14, 48, "Text"],
Cell[17283, 585, 214, 8, 21, "Text"],
Cell[17500, 595, 455, 10, 48, "NumberedEquation",
  CellTags->"ExplicitRungeKuttaMethod"],
Cell[17958, 607, 76, 0, 21, "Text"],
Cell[18037, 609, 544, 11, 93, "NumberedEquation",
  CellTags->"ExplicitRungeKuttaCoefficients"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18618, 625, 38, 0, 31, "Subsubsection"],
Cell[18659, 627, 511, 18, 35, "Text"],
Cell[19173, 647, 753, 16, 98, "NumberedEquation",
  CellTags->"EulerIncrements"],
Cell[19929, 665, 340, 14, 35, "Text"],
Cell[20272, 681, 330, 14, 21, "Text"],
Cell[20605, 697, 226, 6, 23, "Text"],
Cell[20834, 705, 156, 3, 28, "NumberedEquation",
  CellTags->"EulerIncrementResult"],
Cell[20993, 710, 698, 24, 62, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21740, 740, 60, 0, 35, "Subsection"],
Cell[21803, 742, 219, 4, 48, "Text"],
Cell[22025, 748, 830, 16, 151, "NumberedEquation",
  CellTags->"LinearlyImplicitEulerSteps"],
Cell[22858, 766, 240, 11, 21, "Text"],
Cell[23101, 779, 132, 2, 45, "DisplayFormula"],
Cell[23236, 783, 407, 12, 48, "Text"],
Cell[23646, 797, 147, 5, 21, "Text"],
Cell[23796, 804, 115, 2, 28, "DisplayFormula"],

Cell[CellGroupData[{
Cell[23936, 810, 38, 0, 31, "Subsubsection"],
Cell[23977, 812, 177, 5, 35, "Text"],
Cell[24157, 819, 843, 17, 98, "NumberedEquation",
  CellTags->"LinearlyImplicitEulerIncrements"],
Cell[25003, 838, 279, 11, 21, "Text"],
Cell[25285, 851, 267, 11, 21, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[25601, 868, 54, 0, 35, "Subsection"],
Cell[25658, 870, 303, 10, 35, "Text"],
Cell[25964, 882, 147, 3, 35, "Text"],
Cell[26114, 887, 506, 10, 92, "NumberedEquation",
  CellTags->"ExplicitMidpointSteps"],
Cell[26623, 899, 472, 16, 35, "Text"],

Cell[CellGroupData[{
Cell[27120, 919, 38, 0, 31, "Subsubsection"],
Cell[27161, 921, 166, 5, 21, "Text"],
Cell[27330, 928, 943, 22, 98, "NumberedEquation",
  CellTags->"ExplicitMidpointIncrements"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28310, 955, 47, 0, 31, "Subsubsection"],
Cell[28360, 957, 188, 6, 35, "Text"],
Cell[28551, 965, 186, 4, 28, "NumberedEquation",
  CellTags->"GraggSmoothingStep"],
Cell[28740, 971, 521, 16, 48, "Text"],
Cell[29264, 989, 212, 4, 48, "Text"],
Cell[29479, 995, 316, 6, 28, "NumberedEquation",
  CellTags->"ModifiedGraggSmoothingStep"],
Cell[29798, 1003, 487, 14, 48, "Text"],
Cell[30288, 1019, 322, 8, 48, "Text"],
Cell[30613, 1029, 426, 15, 35, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31076, 1049, 42, 0, 31, "Subsubsection"],
Cell[31121, 1051, 200, 5, 35, "Text"],
Cell[31324, 1058, 124027, 3947, 196, 40121, 2906, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[155400, 5011, 63, 0, 35, "Subsection"],
Cell[155466, 5013, 307, 10, 35, "Text"],
Cell[155776, 5025, 1150, 23, 151, "NumberedEquation",
  CellTags->"LinearlyImplicitMidpointSteps"],
Cell[156929, 5050, 395, 15, 35, "Text"],

Cell[CellGroupData[{
Cell[157349, 5069, 38, 0, 31, "Subsubsection"],
Cell[157390, 5071, 182, 5, 21, "Text"],
Cell[157575, 5078, 1116, 23, 98, "NumberedEquation",
  CellTags->"LinearlyImplicitMidpointIncrements"]
}, Open  ]],

Cell[CellGroupData[{
Cell[158728, 5106, 39, 0, 31, "Subsubsection"],
Cell[158770, 5108, 210, 7, 21, "Text"],
Cell[158983, 5117, 158, 3, 43, "NumberedEquation",
  CellTags->"BaderSmoothingStep"],
Cell[159144, 5122, 176, 7, 21, "Text"],
Cell[159323, 5131, 289, 5, 43, "NumberedEquation",
  CellTags->"ModifiedBaderSmoothingStep"],
Cell[159615, 5138, 234, 8, 21, "Text"],
Cell[159852, 5148, 495, 14, 48, "Text"],
Cell[160350, 5164, 442, 15, 35, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[160841, 5185, 69, 0, 35, "Subsection"],
Cell[160913, 5187, 224, 8, 35, "Text"],
Cell[161140, 5197, 251, 8, 35, "Text"],
Cell[161394, 5207, 140, 3, 35, "Text"],
Cell[161537, 5212, 230, 6, 35, "Text"],
Cell[161770, 5220, 99, 3, 21, "Text"],
Cell[161872, 5225, 386, 6, 61, "NumberedEquation",
  CellTags->"ModifiedAitkenNeville"],
Cell[162261, 5233, 533, 16, 48, "Text"],
Cell[162797, 5251, 236, 8, 21, "Text"],
Cell[163036, 5261, 190, 4, 35, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[163275, 5271, 59, 1, 51, "Section",
  CellTags->"s:4"],
Cell[163337, 5274, 140, 3, 35, "Text"],

Cell[CellGroupData[{
Cell[163502, 5281, 36, 0, 35, "Subsection"],
Cell[163541, 5283, 339, 7, 48, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[163917, 5295, 42, 0, 35, "Subsection"],
Cell[163962, 5297, 311, 10, 35, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[164310, 5312, 56, 0, 35, "Subsection"],
Cell[164369, 5314, 228, 4, 48, "Text"],
Cell[164600, 5320, 97, 3, 21, "Text"],
Cell[164700, 5325, 234, 4, 48, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[164971, 5334, 37, 0, 35, "Subsection"],
Cell[165011, 5336, 116, 3, 21, "Text"],
Cell[165130, 5341, 249, 8, 35, "Text"],
Cell[165382, 5351, 256, 9, 35, "Text"],
Cell[165641, 5362, 348, 11, 21, "Text"],
Cell[165992, 5375, 532, 14, 28, "DisplayFormula"],
Cell[166527, 5391, 262, 6, 35, "Text"],
Cell[166792, 5399, 87, 3, 21, "Text"],
Cell[166882, 5404, 401, 8, 42, "NumberedEquation",
  CellTags->"ImplicitEulerStabilityCheck"],
Cell[167286, 5414, 339, 9, 35, "Text"],
Cell[167628, 5425, 364, 9, 35, "Text"],
Cell[167995, 5436, 260, 4, 43, "DisplayFormula"],
Cell[168258, 5442, 125, 3, 35, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[168432, 5451, 46, 1, 51, "Section",
  CellTags->"s:5"],

Cell[CellGroupData[{
Cell[168503, 5456, 35, 0, 35, "Subsection"],
Cell[168541, 5458, 113, 3, 21, "Text"],
Cell[168657, 5463, 288, 6, 55, "Input"],
Cell[168948, 5471, 234, 6, 35, "Text"],

Cell[CellGroupData[{
Cell[169207, 5481, 239, 6, 40, "Input"],
Cell[169449, 5489, 393, 11, 39, "Output"]
}, Open  ]],
Cell[169857, 5503, 246, 5, 48, "Text"],
Cell[170106, 5510, 66, 0, 21, "Text"],

Cell[CellGroupData[{
Cell[170197, 5514, 161, 3, 40, "Input"],
Cell[170361, 5519, 19575, 631, 184, 5779, 456, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[189951, 6153, 74, 0, 21, "Text"],

Cell[CellGroupData[{
Cell[190050, 6157, 83, 2, 24, "Input"],
Cell[190136, 6161, 40234, 1295, 184, 15007, 979, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[230407, 7461, 50, 0, 31, "Subsubsection"],
Cell[230460, 7463, 44, 0, 21, "Text"],
Cell[230507, 7465, 107, 2, 24, "Input"],
Cell[230617, 7469, 246, 7, 35, "Text"],

Cell[CellGroupData[{
Cell[230888, 7480, 268, 5, 85, "Input"],
Cell[231159, 7487, 84, 2, 24, "Output"]
}, Open  ]],
Cell[231258, 7492, 172, 5, 35, "Text"],

Cell[CellGroupData[{
Cell[231455, 7501, 214, 4, 70, "Input"],
Cell[231672, 7507, 84, 2, 24, "Output"]
}, Open  ]],
Cell[231771, 7512, 187, 6, 35, "Text"],

Cell[CellGroupData[{
Cell[231983, 7522, 307, 6, 85, "Input"],
Cell[232293, 7530, 93, 2, 24, "Output"]
}, Open  ]],
Cell[232401, 7535, 199, 4, 35, "Text"],
Cell[232603, 7541, 69, 0, 21, "Text"],

Cell[CellGroupData[{
Cell[232697, 7545, 371, 8, 85, "Input"],

Cell[CellGroupData[{
Cell[233093, 7557, 123640, 5968, 184, 86011, 5498, "GraphicsData", \
"PostScript", "Graphics"],
Cell[356736, 13527, 194894, 9846, 184, 144482, 9219, "GraphicsData", \
"PostScript", "Graphics"],
Cell[551633, 23375, 39065, 901, 184, 8166, 515, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[590713, 24279, 562, 15, 24, "Output"]
}, Open  ]],
Cell[591290, 24297, 111, 3, 21, "Text"],

Cell[CellGroupData[{
Cell[591426, 24304, 369, 7, 116, "Input"],
Cell[591798, 24313, 1061, 24, 75, "Output"]
}, Open  ]],
Cell[592874, 24340, 153, 5, 35, "Text"],

Cell[CellGroupData[{
Cell[593052, 24349, 338, 7, 70, "Input"],
Cell[593393, 24358, 257, 5, 54, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[593711, 24370, 43, 0, 35, "Subsection"],
Cell[593757, 24372, 218, 8, 21, "Text"],
Cell[593978, 24382, 548, 10, 108, "Input"],
Cell[594529, 24394, 220, 11, 21, "Text"],

Cell[CellGroupData[{
Cell[594774, 24409, 46, 0, 31, "Subsubsection"],
Cell[594823, 24411, 287, 6, 48, "Text"],
Cell[595113, 24419, 163, 5, 23, "BulletedList"],
Cell[595279, 24426, 265, 8, 38, "BulletedList"],
Cell[595547, 24436, 292, 8, 38, "BulletedList"],
Cell[595842, 24446, 100701, 3301, 252, 64352, 2847, "GraphicsData", \
"PostScript", "Graphics"],
Cell[696546, 27749, 162, 4, 35, "Text"],
Cell[696711, 27755, 167, 4, 35, "Text"],
Cell[696881, 27761, 262, 5, 48, "Text"],
Cell[697146, 27768, 675, 17, 89, "Text"],
Cell[697824, 27787, 249, 6, 35, InheritFromParent],
Cell[698076, 27795, 236, 8, 35, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[698349, 27808, 42, 0, 31, "Subsubsection"],
Cell[698394, 27810, 262, 8, 35, "Text"],
Cell[698659, 27820, 108, 3, 21, "Text"],
Cell[698770, 27825, 104320, 3208, 253, 61612, 2676, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[803151, 31040, 49, 1, 51, "Section",
  CellTags->"s:6"],

Cell[CellGroupData[{
Cell[803225, 31045, 43, 0, 35, "Subsection"],
Cell[803271, 31047, 511, 14, 62, "Text"],
Cell[803785, 31063, 735, 18, 50, "NumberedEquation",
  CellTags->"ExtrapolationStepControl"],
Cell[804523, 31083, 103, 3, 21, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[804663, 31091, 41, 0, 35, "Subsection"],
Cell[804707, 31093, 354, 10, 35, "Text"],
Cell[805064, 31105, 475, 14, 45, "DisplayFormula"]
}, Open  ]],

Cell[CellGroupData[{
Cell[805576, 31124, 40, 0, 35, "Subsection"],
Cell[805619, 31126, 121, 4, 21, "Text"],
Cell[805743, 31132, 336, 9, 48, "Text"],
Cell[806082, 31143, 144, 3, 35, "Text"],
Cell[806229, 31148, 230, 4, 48, "Text"],
Cell[806462, 31154, 514, 15, 51, "Text"],
Cell[806979, 31171, 232, 6, 35, "Text"],
Cell[807214, 31179, 351, 11, 35, "Text"],
Cell[807568, 31192, 259, 8, 21, "Text"],
Cell[807830, 31202, 269, 8, 21, "Text"],
Cell[808102, 31212, 230, 4, 48, "Text"],
Cell[808335, 31218, 137, 3, 35, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[808521, 31227, 52, 1, 51, "Section",
  CellTags->"s:7"],
Cell[808576, 31230, 3355, 89, 381, "DefinitionBox3Col"],
Cell[811934, 31321, 99, 4, 12, "Caption"],
Cell[812036, 31327, 927, 21, 87, "DefinitionBox3Col"],
Cell[812966, 31350, 227, 8, 23, "Caption"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

