(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    147625,       5156]*)
(*NotebookOutlinePosition[    149699,       5224]*)
(*  CellTagsIndexPosition[    149363,       5210]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Numerical methods for solving the Lotka-Volterra equations", "Chapter"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"s:1"],

Cell["\<\
The Lotka-Volterra system arises in mathematical biology and models \
the growth of animal species.\
\>", "Text"],

Cell[TextData[{
  "Consider two species where ",
  Cell[BoxData[
      \(TraditionalForm\`\(Y\_1\)(T)\)]],
  "denotes the number of predators and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(Y\_2\)(T)\)\(\ \)\)\)]],
  " denotes the number of prey."
}], "Text"],

Cell["\<\
A particular case of the Lotka-Volterra differential system \
is:\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\(Y\_1\)\& . \), 
            "=", \(\(Y\_1\ \((Y\_2 - 1\ )\)\)\(\ \)\(,\)\), \(\(Y\_2\)\& . \),
             "=", \(Y\_2\ \((2\  - \ Y\_1)\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"LotkaVolterraSystem"],

Cell[TextData[{
  "where the dot denotes differentiation with respect to time ",
  StyleBox["T",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "The Lotka-Volterra system (",
  
  CounterBox["NumberedEquation", "LotkaVolterraSystem"],
  ") has an invariant ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", which is constant for all ",
  StyleBox["T",
    FontSlant->"Italic"],
  ":"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`H(Y\_1, \ Y\_2)\  = \ 
      2\ ln\ Y\_1\  - \ Y\_1 + \ ln\ Y\_2 - \ Y\_2\)], "NumberedEquation",
  CellTags->"LotkaVolterraInvariant"],

Cell[TextData[{
  "The level curves of the invariant (",
  
  CounterBox["NumberedEquation", "LotkaVolterraInvariant"],
  ") are closed so that the solution is periodic."
}], "Text"],

Cell[TextData[{
  "It is desirable that the numerical solution of (",
  
  CounterBox["NumberedEquation", "LotkaVolterraSystem"],
  ") is also periodic, but this is not always the case. "
}], "Text"],

Cell[TextData[{
  "Note that (",
  
  CounterBox["NumberedEquation", "LotkaVolterraSystem"],
  ") is a Poisson system:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`Y\& . \  = \ \(B(
          Y)\)\ \[Del]\(H(Y)\)\)], "NumberedEquation",
  CellTags->"PoissonSystemt"],

Cell[TextData[{
  "where ",
  StyleBox["H",
    FontSlant->"Italic"],
  "(",
  StyleBox["Y",
    FontSlant->"Italic"],
  ") is defined in (",
  
  CounterBox["NumberedEquation", "LotkaVolterraInvariant"],
  ")."
}], "Text"],

Cell[TextData[{
  "Poisson systems and Poisson integrators are discussed in Chapter VII.2 of \
[",
  ButtonBox["HLW02",
    ButtonData:>{"References.nb", "HLW02"},
    ButtonStyle->"Hyperlink"],
  "] and [",
  ButtonBox["MQ02",
    ButtonData:>{"References.nb", "MQ02"},
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell["\<\
Load a package with some predefined problems and select the \
Lotka-Volterra system.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(Needs["\<DifferentialEquations`NDSolveProblems`\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(\(Needs["\<DifferentialEquations`NDSolveUtilities`\>"];\)\(\
\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(system\  = \ 
        GetNDSolveProblem["\<LotkaVolterra\>"];\)\), "\[IndentingNewLine]", 
    \(\(invts\  = \ system["\<Invariants\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(time\  = \ system["\<TimeData\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(vars\  = \ 
        system["\<DependentVariables\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(step\  = \ 3/25;\)\)}], "Input",
  CellLabel->"In[9]:=",
  InitializationCell->True],

Cell["Define a utility function for visualizing solutions.", "MathCaption"],

Cell[BoxData[
    \(LotkaVolterraPlot[sol_, \ vars_, \ time_, \ 
        opts___?OptionQ] := \[IndentingNewLine]ParametricPlot[
        Evaluate[vars /. \ sol], time, 
        Evaluate[FilterOptions[ParametricPlot, opts]], \ Axes \[Rule] False, 
        Frame \[Rule] True, 
        FrameLabel \[Rule] Join[Map[TraditionalForm, vars], {None, None}], 
        RotateLabel \[Rule] False]\)], "Input",
  CellLabel->"In[16]:=",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Explicit Euler", "Section",
  CellTags->"s:2"],

Cell[TextData[{
  "Use the explicit or forward Euler method to solve the system ",
  "(",
  
  CounterBox["NumberedEquation", "LotkaVolterraSystem"],
  ")",
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(fesol\  = \ 
        NDSolve[system, Method \[Rule] "\<ExplicitEuler\>", 
          StartingStepSize \[Rule] step];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(LotkaVolterraPlot[fesol, \ vars, \ time];\)\)}], "Input",
  CellLabel->"In[17]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .71601 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.198 0.253464 0.0170478 0.253464 [
[.05546 -0.0125 -3 -9 ]
[.05546 -0.0125 3 0 ]
[.1822 -0.0125 -9 -9 ]
[.1822 -0.0125 9 0 ]
[.30893 -0.0125 -3 -9 ]
[.30893 -0.0125 3 0 ]
[.43566 -0.0125 -9 -9 ]
[.43566 -0.0125 9 0 ]
[.56239 -0.0125 -3 -9 ]
[.56239 -0.0125 3 0 ]
[.68913 -0.0125 -9 -9 ]
[.68913 -0.0125 9 0 ]
[.81586 -0.0125 -3 -9 ]
[.81586 -0.0125 3 0 ]
[.94259 -0.0125 -9 -9 ]
[.94259 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -13.8125 -19.9375 ]
[.5 -0.0125 13.8125 -9 ]
[-0.0125 .01705 -6 -4.5 ]
[-0.0125 .01705 0 4.5 ]
[-0.0125 .14378 -18 -4.5 ]
[-0.0125 .14378 0 4.5 ]
[-0.0125 .27051 -6 -4.5 ]
[-0.0125 .27051 0 4.5 ]
[-0.0125 .39724 -18 -4.5 ]
[-0.0125 .39724 0 4.5 ]
[-0.0125 .52398 -6 -4.5 ]
[-0.0125 .52398 0 4.5 ]
[-0.0125 .65071 -18 -4.5 ]
[-0.0125 .65071 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .358 -45.625 -5.46875 ]
[-0.01875 .358 -18 5.46875 ]
[ 0 .71601 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .71601 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05546 0 m
.05546 .00625 L
s
[(1)] .05546 -0.0125 0 1 Mshowa
.1822 0 m
.1822 .00625 L
s
[(1.5)] .1822 -0.0125 0 1 Mshowa
.30893 0 m
.30893 .00625 L
s
[(2)] .30893 -0.0125 0 1 Mshowa
.43566 0 m
.43566 .00625 L
s
[(2.5)] .43566 -0.0125 0 1 Mshowa
.56239 0 m
.56239 .00625 L
s
[(3)] .56239 -0.0125 0 1 Mshowa
.68913 0 m
.68913 .00625 L
s
[(3.5)] .68913 -0.0125 0 1 Mshowa
.81586 0 m
.81586 .00625 L
s
[(4)] .81586 -0.0125 0 1 Mshowa
.94259 0 m
.94259 .00625 L
s
[(4.5)] .94259 -0.0125 0 1 Mshowa
.125 Mabswid
.08081 0 m
.08081 .00375 L
s
.10616 0 m
.10616 .00375 L
s
.1315 0 m
.1315 .00375 L
s
.15685 0 m
.15685 .00375 L
s
.20754 0 m
.20754 .00375 L
s
.23289 0 m
.23289 .00375 L
s
.25824 0 m
.25824 .00375 L
s
.28358 0 m
.28358 .00375 L
s
.33428 0 m
.33428 .00375 L
s
.35962 0 m
.35962 .00375 L
s
.38497 0 m
.38497 .00375 L
s
.41031 0 m
.41031 .00375 L
s
.46101 0 m
.46101 .00375 L
s
.48635 0 m
.48635 .00375 L
s
.5117 0 m
.5117 .00375 L
s
.53705 0 m
.53705 .00375 L
s
.58774 0 m
.58774 .00375 L
s
.61309 0 m
.61309 .00375 L
s
.63843 0 m
.63843 .00375 L
s
.66378 0 m
.66378 .00375 L
s
.71447 0 m
.71447 .00375 L
s
.73982 0 m
.73982 .00375 L
s
.76516 0 m
.76516 .00375 L
s
.79051 0 m
.79051 .00375 L
s
.8412 0 m
.8412 .00375 L
s
.86655 0 m
.86655 .00375 L
s
.8919 0 m
.8919 .00375 L
s
.91724 0 m
.91724 .00375 L
s
.03012 0 m
.03012 .00375 L
s
.00477 0 m
.00477 .00375 L
s
.96794 0 m
.96794 .00375 L
s
.99328 0 m
.99328 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -74.8125 -23.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
0 .01705 m
.00625 .01705 L
s
[(0)] -0.0125 .01705 1 0 Mshowa
0 .14378 m
.00625 .14378 L
s
[(0.5)] -0.0125 .14378 1 0 Mshowa
0 .27051 m
.00625 .27051 L
s
[(1)] -0.0125 .27051 1 0 Mshowa
0 .39724 m
.00625 .39724 L
s
[(1.5)] -0.0125 .39724 1 0 Mshowa
0 .52398 m
.00625 .52398 L
s
[(2)] -0.0125 .52398 1 0 Mshowa
0 .65071 m
.00625 .65071 L
s
[(2.5)] -0.0125 .65071 1 0 Mshowa
.125 Mabswid
0 .04239 m
.00375 .04239 L
s
0 .06774 m
.00375 .06774 L
s
0 .09309 m
.00375 .09309 L
s
0 .11843 m
.00375 .11843 L
s
0 .16913 m
.00375 .16913 L
s
0 .19447 m
.00375 .19447 L
s
0 .21982 m
.00375 .21982 L
s
0 .24517 m
.00375 .24517 L
s
0 .29586 m
.00375 .29586 L
s
0 .3212 m
.00375 .3212 L
s
0 .34655 m
.00375 .34655 L
s
0 .3719 m
.00375 .3719 L
s
0 .42259 m
.00375 .42259 L
s
0 .44794 m
.00375 .44794 L
s
0 .47328 m
.00375 .47328 L
s
0 .49863 m
.00375 .49863 L
s
0 .54932 m
.00375 .54932 L
s
0 .57467 m
.00375 .57467 L
s
0 .60002 m
.00375 .60002 L
s
0 .62536 m
.00375 .62536 L
s
0 .67606 m
.00375 .67606 L
s
0 .7014 m
.00375 .7014 L
s
.25 Mabswid
0 0 m
0 .71601 L
s
gsave
-0.01875 .358 -106.625 -9.46875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
.05546 .70976 m
.05546 .71601 L
s
.1822 .70976 m
.1822 .71601 L
s
.30893 .70976 m
.30893 .71601 L
s
.43566 .70976 m
.43566 .71601 L
s
.56239 .70976 m
.56239 .71601 L
s
.68913 .70976 m
.68913 .71601 L
s
.81586 .70976 m
.81586 .71601 L
s
.94259 .70976 m
.94259 .71601 L
s
.125 Mabswid
.08081 .71226 m
.08081 .71601 L
s
.10616 .71226 m
.10616 .71601 L
s
.1315 .71226 m
.1315 .71601 L
s
.15685 .71226 m
.15685 .71601 L
s
.20754 .71226 m
.20754 .71601 L
s
.23289 .71226 m
.23289 .71601 L
s
.25824 .71226 m
.25824 .71601 L
s
.28358 .71226 m
.28358 .71601 L
s
.33428 .71226 m
.33428 .71601 L
s
.35962 .71226 m
.35962 .71601 L
s
.38497 .71226 m
.38497 .71601 L
s
.41031 .71226 m
.41031 .71601 L
s
.46101 .71226 m
.46101 .71601 L
s
.48635 .71226 m
.48635 .71601 L
s
.5117 .71226 m
.5117 .71601 L
s
.53705 .71226 m
.53705 .71601 L
s
.58774 .71226 m
.58774 .71601 L
s
.61309 .71226 m
.61309 .71601 L
s
.63843 .71226 m
.63843 .71601 L
s
.66378 .71226 m
.66378 .71601 L
s
.71447 .71226 m
.71447 .71601 L
s
.73982 .71226 m
.73982 .71601 L
s
.76516 .71226 m
.76516 .71601 L
s
.79051 .71226 m
.79051 .71601 L
s
.8412 .71226 m
.8412 .71601 L
s
.86655 .71226 m
.86655 .71601 L
s
.8919 .71226 m
.8919 .71601 L
s
.91724 .71226 m
.91724 .71601 L
s
.03012 .71226 m
.03012 .71601 L
s
.00477 .71226 m
.00477 .71601 L
s
.96794 .71226 m
.96794 .71601 L
s
.99328 .71226 m
.99328 .71601 L
s
.25 Mabswid
0 .71601 m
1 .71601 L
s
.99375 .01705 m
1 .01705 L
s
.99375 .14378 m
1 .14378 L
s
.99375 .27051 m
1 .27051 L
s
.99375 .39724 m
1 .39724 L
s
.99375 .52398 m
1 .52398 L
s
.99375 .65071 m
1 .65071 L
s
.125 Mabswid
.99625 .04239 m
1 .04239 L
s
.99625 .06774 m
1 .06774 L
s
.99625 .09309 m
1 .09309 L
s
.99625 .11843 m
1 .11843 L
s
.99625 .16913 m
1 .16913 L
s
.99625 .19447 m
1 .19447 L
s
.99625 .21982 m
1 .21982 L
s
.99625 .24517 m
1 .24517 L
s
.99625 .29586 m
1 .29586 L
s
.99625 .3212 m
1 .3212 L
s
.99625 .34655 m
1 .34655 L
s
.99625 .3719 m
1 .3719 L
s
.99625 .42259 m
1 .42259 L
s
.99625 .44794 m
1 .44794 L
s
.99625 .47328 m
1 .47328 L
s
.99625 .49863 m
1 .49863 L
s
.99625 .54932 m
1 .54932 L
s
.99625 .57467 m
1 .57467 L
s
.99625 .60002 m
1 .60002 L
s
.99625 .62536 m
1 .62536 L
s
.99625 .67606 m
1 .67606 L
s
.99625 .7014 m
1 .7014 L
s
.25 Mabswid
1 0 m
1 .71601 L
s
0 0 m
1 0 L
1 .71601 L
0 .71601 L
closepath
clip
newpath
.5 Mabswid
.49269 .27051 m
.49276 .26824 L
.49293 .26594 L
.4934 .2613 L
.49361 .259 L
.49374 .25671 L
.49374 .25445 L
.49357 .25224 L
.49318 .25009 L
.49253 .24801 L
.49131 .2438 L
.48905 .2353 L
.47904 .21875 L
.46447 .20429 L
.42814 .18293 L
.38514 .16883 L
.33564 .16074 L
.31284 .15916 L
.30716 .15889 L
.30434 .15877 L
.30153 .15867 L
.29875 .15862 L
.296 .15863 L
.2933 .15869 L
.29062 .15879 L
.28474 .15892 L
.27885 .15904 L
.26746 .15972 L
.24557 .16207 L
.2071 .17083 L
.17726 .18398 L
.1516 .20364 L
.13457 .2276 L
.12901 .24159 L
.12528 .25699 L
.12372 .2657 L
.12337 .27035 L
.12331 .2752 L
.12311 .27998 L
.12302 .28237 L
.12296 .28478 L
.12298 .28723 L
.12309 .28974 L
.12367 .29497 L
.12621 .31471 L
.13146 .33574 L
.1529 .38378 L
.18967 .42995 L
.24007 .46617 L
.27549 .47952 L
Mistroke
.29587 .48296 L
.3062 .48469 L
.31661 .48628 L
.3216 .48678 L
.32673 .48704 L
.33204 .48697 L
.33757 .48651 L
.3487 .48564 L
.35971 .48514 L
.40608 .47639 L
.51072 .43123 L
.59974 .35785 L
.62754 .31942 L
.637 .30072 L
.64364 .28217 L
.64713 .27215 L
.64837 .2673 L
.64907 .26261 L
.64911 .25813 L
.64862 .25381 L
.64827 .24488 L
.64707 .22725 L
.63996 .21217 L
.62228 .18608 L
.59615 .16461 L
.5285 .13504 L
.4459 .11597 L
.36917 .10655 L
.32986 .10419 L
.3113 .10374 L
.302 .10353 L
.29278 .10336 L
.28834 .10332 L
.284 .10333 L
.27977 .10341 L
.27564 .10353 L
.25878 .10388 L
.22723 .10564 L
.17475 .112 L
.12726 .12371 L
.09173 .14003 L
.06416 .16171 L
.04204 .19284 L
.02921 .2313 L
.02539 .25638 L
.02462 .26291 L
.0243 .26626 L
.02405 .26971 L
.02392 .27331 L
.02391 .27709 L
Mistroke
.02395 .28094 L
.02394 .28472 L
.02384 .29168 L
.02381 .29519 L
.02382 .29875 L
.02391 .3024 L
.02409 .30617 L
.02481 .31417 L
.02806 .34667 L
.04401 .42039 L
.07959 .51141 L
.13654 .59901 L
.24045 .67652 L
.27651 .68631 L
.29503 .69112 L
.31359 .69588 L
.3233 .69768 L
.33352 .69878 L
.34442 .69896 L
.35617 .69799 L
.38008 .69587 L
.40338 .69496 L
.42554 .69326 L
.44906 .68891 L
.50101 .67155 L
.60793 .62672 L
.842 .45854 L
.92186 .3654 L
.94556 .32336 L
.96489 .28162 L
.97278 .26193 L
.97521 .25282 L
.97619 .24441 L
.97541 .23685 L
.97379 .22966 L
.97196 .21441 L
.96747 .18442 L
.95051 .1621 L
.90098 .1216 L
.83365 .0949 L
.69177 .06751 L
.54416 .05407 L
.5401 .05384 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  ImageSize->{288, 206.188},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000cQ000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
X_oo0`001?oo00<00?ooool01Ooo00<00?ooool0K?oo002Sool00`00ooooo`02ool00`00ooooo`07
ool00`00ooooo`1[ool009coo`<000Coo`03003ooooo00;oo`03003oo`00008000Goo`03003ooooo
06_oo`00WOoo00<00?ooool00ooo00<00?ooool00_oo00@00?ooool000Koo`03003ooooo06_oo`00
W_oo00<00?ooool00_oo00<00?ooool00_oo00@00?ooool000Koo`03003ooooo06_oo`00W_oo0P00
2?oo00D00?ooooooo`0000Goo`03003ooooo06_oo`00W_oo00<00?oo00001ooo00D00?ooooooo`00
00Goo`03003ooooo06_oo`00W_oo00@00?ooool000Koo`03003oo`0000;oo`03003oo`0000;oo`03
003ooooo06_oo`00WOoo0`0000?oo`0000001_oo00<00?oo00001P00K_oo003ooolQool00?ooob7o
o`00?Ooo10005?oo10000ooo00<00?ooool00_oo0`005Ooo10005?oo10000ooo00<00?ooool00_oo
0`005_oo0P005_oo0P001?oo00<00?ooool00_oo0`005ooo00<00?ooool05Ooo00<00?ooool00_oo
00<00?ooool00_oo0`002?oo000oool00`00ooooo`0Eool00`00ooooo`0:ool00`00ooooo`0Bool0
0`00ooooo`0Eool00`00ooooo`0<ool00`00ooooo`0Bool01000ooooo`005?oo00@00?ooool000_o
o`03003ooooo01Coo`03003ooooo01Goo`03003ooooo00[oo`03003ooooo00Goo`00?ooo00<00?oo
ool05Ooo00<00?ooool02_oo00<00?ooool04ooo00<00?ooool05Ooo00<00?ooool02ooo00<00?oo
ool05Ooo00<00?ooool05Ooo00<00?ooool02Ooo00<00?ooool04Ooo1@004ooo1@002ooo00<00?oo
ool01Ooo000oool00`00ooooo`0Eool00`00ooooo`07ool3000Gool00`00ooooo`0Eool00`00oooo
o`07ool3000Fool2000Fool20009ool3000Dool01000ooooo`005?oo00@00?ooool000Woo`<000So
o`00?ooo00<00?ooool05Ooo00<00?ooool01ooo00<00?ooool06?oo00<00?ooool05Ooo00<00?oo
ool01_oo00<00?ooool06?oo00<00?ooool05Ooo00<00?ooool01_oo00<00?ooool05Ooo00<00?oo
00005Ooo00<00?oo00002Ooo00<00?ooool02?oo000mool3000Eool30009ool00`00ooooo`0Eool0
1000ooooo`005?oo00@00?ooool000Soo`03003ooooo01Goo`04003ooooo000Dool01000ooooo`00
2?oo00<00?ooool05_oo0P005_oo0P002Ooo00<00?ooool02?oo000oool00`00ooooo`0Eool00`00
ooooo`07ool4000Eool2000Fool20009ool4000Eool2000Fool20009ool4000Fool00`00ooooo`0E
ool00`00ooooo`07ool40007ool00?ooob7oo`00oooo8Ooo003ooolQool003;oond0007oo`00<_oo
00<00?ooool02_oo00<00?ooool06ooo00<00?ooool06ooo00<00?ooool06ooo00<00?ooool06ooo
00<00?ooool06ooo00<00?ooool06ooo00<00?ooool06ooo00<00?ooool02_oo0@000Ooo000[ool2
0005ool00`00ooooo`3Yool10001ool002[oo`04003ooooo0004ool00`00ooooo`3Yool10001ool0
02[oo`04003ooooo0004ool2003Yool20001ool002[oo`04003ooooo0004ool00`00ooooo`3Yool1
0001ool002[oo`04003ooooo0004ool00`00ooooo`3Yool10001ool002[oo`04003ooooo0004ool0
0`00ooooo`3Yool10001ool002_oo`8000Goo`03003ooooo0>Woo`40007oo`00<_oo00<00?ooool0
jOoo0@000Ooo000bool00`00ooooo`3Xool20001ool003;oo`03003ooooo0>Woo`40007oo`00<_oo
00<00?ooool0O?oo1P00Iooo0@000Ooo000bool00`00ooooo`22ool9001Nool10001ool003;oo`03
003ooooo08_oo`P005Koo`40007oo`00<_oo00<00?ooool0Tooo2@00COoo0@000Ooo000bool00`00
ooooo`2Lool70015ool20001ool003;oo`03003ooooo0:?oo`H0043oo`40007oo`00<_oo00<00?oo
ool0ZOoo1P00>_oo0@000Ooo000bool00`00ooooo`2_ool5000eool10001ool003;oo`03003ooooo
0;Coo`H002ooo`40007oo`00<_oo00<00?ooool0^_oo1P00:Ooo0@000Ooo000bool00`00ooooo`30
ool4000Tool20001ool003;oo`03003ooooo0<Coo`8002?oo`40007oo`00<_oo00<00?ooool0=_oo
6P00M_oo0`008?oo0@000Ooo000bool00`00ooooo`0/ool:000Jool9001`ool3000Mool10001ool0
03;oo`03003ooooo02Goo`L002goo`T006[oo`8001_oo`40007oo`00<_oo00<00?ooool08Ooo1000
?Ooo1P00I_oo0`006?oo0@000Ooo000bool00`00ooooo`0Mool40017ool4001Uool2000Eool20001
ool003;oo`03003ooooo01[oo`<004ooo`@006?oo`03003ooooo01?oo`40007oo`00<_oo00<00?oo
ool06?oo0P00E_oo1000H?oo00<00?ooool04_oo0@000Ooo000bool00`00ooooo`0Fool2001Lool4
001Mool2000Bool10001ool001ooo`8000Coo`03003ooooo00;oo`<000Goo`03003ooooo01Coo`80
06;oo`@005_oo`03003ooooo00ooo`40007oo`007_oo00@00?ooool000_oo`03003ooooo00;oo`03
003ooooo01;oo`8006Soo`8005[oo`03003ooooo00koo`40007oo`007_oo00@00?ooool000_oo`03
003ooooo00;oo`8001;oo`03003ooooo06[oo`8005Woo`03003ooooo00coo`80007oo`007_oo00@0
0?ooool000Soo`<000Goo`03003ooooo00ooo`8006ooo`8005Soo`03003ooooo00coo`40007oo`00
7_oo00@00?ooool000Soo`03003ooooo00Goo`03003ooooo00koo`03003ooooo077oo`<005Koo`80
00coo`40007oo`007_oo00@00?ooool000Soo`03003ooooo00Goo`03003ooooo00goo`03003ooooo
02[ooa0003_oo`8005Koo`03003ooooo00Woo`40007oo`007ooo0P002Ooo10001?oo00<00?ooool0
3?oo00<00?ooool09_oo1@004?oo1@00>?oo0P00EOoo00<00?ooool02?oo0@000Ooo000bool00`00
ooooo`0;ool00`00ooooo`0Sool4000Jool6000dool2001Dool00`00ooooo`07ool10001ool003;o
o`03003ooooo00_oo`03003ooooo01ooo`@002Coo`D0037oo`03003ooooo05;oo`03003ooooo00Go
o`80007oo`00<_oo00<00?ooool02_oo00<00?ooool07_oo0P00;Ooo0`00;ooo00<00?ooool0DOoo
00<00?ooool01_oo0@000Ooo000bool00`00ooooo`09ool00`00ooooo`0Mool2000bool4000/ool2
001Bool00`00ooooo`05ool10001ool003;oo`03003ooooo00Soo`03003ooooo01coo`8003Soo`80
02coo`03003ooooo053oo`03003ooooo00Coo`40007oo`00<_oo00<00?ooool02?oo00<00?ooool0
6_oo0P00??oo0P00:ooo00<00?ooool0Cooo00<00?ooool01?oo0@000Ooo000bool00`00ooooo`07
ool00`00ooooo`0Jool00`00ooooo`0nool2000Zool00`00ooooo`1>ool00`00ooooo`04ool10001
ool003;oo`03003ooooo00Ooo`03003ooooo01Woo`03003ooooo047oo`8002Soo`03003ooooo04ko
o`03003ooooo00?oo`80007oo`00<_oo00<00?ooool01_oo00<00?ooool06?oo0P00A_oo0P009ooo
00<00?ooool0C_oo00<00?ooool00ooo0@000Ooo000bool00`00ooooo`06ool00`00ooooo`0Gool0
0`00ooooo`18ool00`00ooooo`0Uool00`00ooooo`1=ool00`00ooooo`03ool10001ool003;oo`03
003ooooo00Goo`03003ooooo01Ooo`03003ooooo04[oo`03003ooooo02Coo`03003ooooo04goo`03
003ooooo00?oo`40007oo`00<_oo00<00?ooool01Ooo00<00?ooool05_oo00<00?ooool0C?oo00<0
0?ooool09?oo00<00?ooool0C?oo00<00?ooool00ooo0@000Ooo000bool00`00ooooo`04ool00`00
ooooo`0Gool00`00ooooo`1=ool00`00ooooo`0Tool00`00ooooo`1;ool00`00ooooo`03ool10001
ool003;oo`03003ooooo00Coo`03003ooooo01Koo`03003ooooo04koo`03003ooooo02Coo`03003o
oooo04_oo`03003ooooo00;oo`80007oo`00<_oo00<00?ooool00ooo00<00?ooool05_oo00<00?oo
ool0D?oo00<00?ooool09?oo00<00?ooool0B_oo00<00?ooool00ooo0@000Ooo000bool00`00oooo
o`03ool00`00ooooo`0Fool00`00ooooo`1@ool00`00ooooo`0Tool00`00ooooo`1:ool00`00oooo
o`03ool10001ool003;oo`03003ooooo00?oo`03003ooooo01Koo`03003ooooo057oo`03003ooooo
02?oo`03003ooooo04[oo`03003ooooo00?oo`40007oo`00<_oo00<00?ooool00ooo00<00?ooool0
5Ooo00<00?ooool0D_oo00<00?ooool08ooo00<00?ooool0Booo00<00?ooool00_oo0@000Ooo000b
ool00`00ooooo`03ool00`00ooooo`0Eool00`00ooooo`1Cool00`00ooooo`0Rool00`00ooooo`1;
ool00`00ooooo`02ool10001ool003;oo`03003ooooo00?oo`03003ooooo01Goo`03003ooooo05?o
o`03003ooooo02;oo`03003ooooo04_oo`04003oooooool20001ool003;oo`03003ooooo00?oo`03
003ooooo01Coo`03003ooooo05Coo`03003ooooo02;oo`03003ooooo04_oo`03003ooooo00;oo`40
007oo`00<_oo00<00?ooool00ooo00<00?ooool05?oo00<00?ooool0E?oo00<00?ooool08_oo00<0
0?ooool0Booo00<00?ooool00_oo0@000Ooo000bool00`00ooooo`03ool00`00ooooo`0Dool00`00
ooooo`1Dool00`00ooooo`0Rool00`00ooooo`1:ool00`00ooooo`03ool10001ool002[oo`@000Co
o`03003ooooo00;oo`03003ooooo01Goo`03003ooooo05Coo`03003ooooo02;oo`03003ooooo04[o
o`03003ooooo00?oo`40007oo`00;?oo00<00?ooool00ooo00<00?ooool00_oo00<00?ooool05Ooo
00<00?ooool0E?oo00<00?ooool08_oo00<00?ooool0B_oo00<00?ooool00ooo0@000Ooo000/ool0
0`00ooooo`03ool20003ool00`00ooooo`0Eool00`00ooooo`1Dool00`00ooooo`0Rool00`00oooo
o`19ool00`00ooooo`03ool20001ool002coo`03003ooooo00?oo`03003ooooo00;oo`03003ooooo
01Goo`03003ooooo07Woo`03003ooooo04Woo`03003ooooo00Coo`40007oo`00;?oo00<00?ooool0
0ooo00<00?ooool00_oo00<00?ooool05Ooo00<00?ooool0N?oo00<00?ooool0BOoo00<00?ooool0
1Ooo0@000Ooo000Zool30005ool00`00ooooo`02ool00`00ooooo`0Eool00`00ooooo`1hool00`00
ooooo`19ool00`00ooooo`05ool10001ool002coo`03003ooooo00?oo`03003ooooo00;oo`03003o
oooo01Goo`03003ooooo07Ooo`03003ooooo04Woo`03003ooooo00Koo`40007oo`00<_oo00<00?oo
ool00_oo00<00?ooool05Ooo00<00?ooool0Mooo00<00?ooool0BOoo00<00?ooool01_oo0@000Ooo
000bool00`00ooooo`02ool00`00ooooo`0Eool00`00ooooo`1fool00`00ooooo`19ool00`00oooo
o`06ool20001ool003;oo`03003ooooo00;oo`03003ooooo01Goo`03003ooooo07Koo`03003ooooo
04Woo`03003ooooo00Ooo`40007oo`00<_oo00<00?ooool00_oo00<00?ooool05Ooo00<00?ooool0
M_oo00<00?ooool0B?oo00<00?ooool02?oo0@000Ooo000bool00`00ooooo`02ool00`00ooooo`0E
ool00`00ooooo`1eool00`00ooooo`19ool00`00ooooo`08ool10001ool003;oo`03003ooooo00;o
o`03003ooooo01Goo`03003ooooo07Goo`03003ooooo04Soo`03003ooooo00Woo`40007oo`00<_oo
00<00?ooool00_oo00<00?ooool05Ooo00<00?ooool0M?oo00<00?ooool0BOoo00<00?ooool02Ooo
0@000Ooo000bool00`00ooooo`02ool00`00ooooo`0Fool00`00ooooo`1bool00`00ooooo`19ool0
0`00ooooo`09ool20001ool003;oo`03003ooooo00;oo`03003ooooo01Koo`03003ooooo07;oo`03
003ooooo04Woo`03003ooooo00[oo`40007oo`00<_oo00<00?ooool00_oo00<00?ooool05ooo00<0
0?ooool0L?oo00<00?ooool0BOoo00<00?ooool02ooo0@000Ooo000bool00`00ooooo`03ool00`00
ooooo`0Fool00`00ooooo`1_ool00`00ooooo`1:ool00`00ooooo`0;ool10001ool003;oo`03003o
oooo00?oo`03003ooooo01Koo`03003ooooo06ooo`03003ooooo04Woo`03003ooooo00coo`40007o
o`001ooo0`001?oo00<00?ooool01Ooo00<00?ooool06Ooo00<00?ooool00ooo00<00?ooool05ooo
00<00?ooool0KOoo00<00?ooool0B_oo00<00?ooool03?oo0@000Ooo0007ool00`00ooooo`03ool0
0`00ooooo`07ool00`00ooooo`0Hool00`00ooooo`03ool00`00ooooo`0Gool00`00ooooo`1/ool0
0`00ooooo`1:ool00`00ooooo`0<ool20001ool000;oo`<000?oo`03003ooooo00;oo`03003ooooo
00<000Coo`03003ooooo01Soo`03003ooooo00?oo`03003ooooo01Soo`03003ooooo06_oo`03003o
oooo04[oo`03003ooooo00goo`40007oo`000ooo00<00?ooool00ooo00D00?ooooooo`0000?oo`03
003ooooo00?oo`03003ooooo01Soo`03003ooooo00?oo`03003ooooo01Soo`03003ooooo06[oo`03
003ooooo04[oo`03003ooooo00koo`40007oo`001?oo00<00?ooool00`000ooo00D00?ooooooo`00
00Goo`03003ooooo01Soo`03003ooooo00Coo`03003ooooo01Soo`03003ooooo06Soo`03003ooooo
04_oo`03003ooooo00koo`40007oo`001?oo0P001ooo00<00?ooool00_oo00<00?ooool00_oo00<0
0?ooool06?oo00<00?ooool01?oo00<00?ooool06?oo00<00?ooool0Iooo00<00?ooool0Booo00<0
0?ooool03ooo0@000Ooo0004ool00`00ool00006ool00`00ooooo`02ool00`00ooooo`02ool00`00
ooooo`0Hool00`00ooooo`04ool00`00ooooo`0Iool00`00ooooo`1Tool2001=ool00`00ooooo`0@
ool10001ool000Coo`04003ooooo0005ool01000ooooo`000_oo00D00?oo003oo`0001[oo`03003o
oooo00Coo`03003ooooo01Woo`03003ooooo06?oo`03003ooooo04coo`03003ooooo013oo`80007o
o`000ooo0`0000?oo`0000001Ooo00<00?ooool01P006ooo00<00?ooool01Ooo00<00?ooool06Ooo
00<00?ooool0HOoo00<00?ooool0C?oo00<00?ooool04_oo0@000Ooo000bool00`00ooooo`05ool0
0`00ooooo`0Iool00`00ooooo`1Pool00`00ooooo`1=ool00`00ooooo`0Bool10001ool003;oo`03
003ooooo00Goo`03003ooooo01[oo`03003ooooo05koo`03003ooooo04goo`03003ooooo01?oo`40
007oo`007_oo10000ooo00<00?ooool00_oo0`001Ooo00<00?ooool01Ooo00<00?ooool06_oo00<0
0?ooool0GOoo00<00?ooool0COoo00<00?ooool05?oo0@000Ooo000Pool00`00ooooo`0:ool00`00
ooooo`02ool00`00ooooo`06ool00`00ooooo`0Jool00`00ooooo`1Jool2001?ool00`00ooooo`0E
ool10001ool0023oo`03003ooooo00[oo`03003ooooo00;oo`8000Ooo`03003ooooo01_oo`03003o
oooo05Soo`03003ooooo04koo`03003ooooo01Goo`80007oo`008?oo00<00?ooool01ooo0`001Ooo
00<00?ooool01_oo00<00?ooool07?oo00<00?ooool0E_oo00<00?ooool0C_oo00<00?ooool05ooo
0@000Ooo000Pool00`00ooooo`07ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`0Lool0
0`00ooooo`1Eool00`00ooooo`1>ool00`00ooooo`0Hool10001ool001koo`<000Woo`03003ooooo
00Goo`03003ooooo00Ooo`03003ooooo01coo`03003ooooo05?oo`03003ooooo04ooo`03003ooooo
01Soo`40007oo`008?oo00<00?ooool01ooo10001?oo00<00?ooool01ooo00<00?ooool07Ooo00<0
0?ooool0DOoo00<00?ooool0Cooo00<00?ooool06Ooo0@000Ooo000bool00`00ooooo`07ool00`00
ooooo`0Nool00`00ooooo`1>ool2001Aool00`00ooooo`0Jool10001ool003;oo`03003ooooo00Oo
o`03003ooooo01koo`03003ooooo04goo`03003ooooo053oo`03003ooooo01[oo`80007oo`00<_oo
00<00?ooool02?oo00<00?ooool07_oo00<00?ooool0Booo00<00?ooool0D?oo00<00?ooool07?oo
0@000Ooo000bool00`00ooooo`08ool00`00ooooo`0Oool00`00ooooo`18ool2001Bool00`00oooo
o`0Mool10001ool003;oo`03003ooooo00Soo`03003ooooo023oo`8004Koo`8005?oo`03003ooooo
01koo`40007oo`00<_oo00<00?ooool02Ooo00<00?ooool08Ooo00<00?ooool0@?oo0`00E?oo00<0
0?ooool07ooo0@000Ooo000bool00`00ooooo`09ool00`00ooooo`0Rool00`00ooooo`0mool2001G
ool00`00ooooo`0Oool10001ool003;oo`03003ooooo00[oo`03003ooooo02;oo`8003[oo`<005So
o`03003ooooo01ooo`80007oo`00<_oo00<00?ooool02_oo00<00?ooool09?oo00<00?ooool0=Ooo
0P00F_oo00<00?ooool08Ooo0@000Ooo000bool00`00ooooo`0:ool00`00ooooo`0Uool00`00oooo
o`0aool3001Kool00`00ooooo`0Rool10001ool003;oo`03003ooooo00_oo`03003ooooo02Goo`80
02ooo`8005coo`8002Goo`40007oo`00<_oo00<00?ooool02ooo00<00?ooool09ooo0P00:_oo0`00
GOoo00<00?ooool09Ooo0@000Ooo000bool00`00ooooo`0;ool00`00ooooo`0Yool3000Uool2001O
ool00`00ooooo`0Vool10001ool003;oo`03003ooooo00coo`03003ooooo02_oo`<001koo`@005oo
o`8002Soo`80007oo`00<_oo00<00?ooool03?oo00<00?ooool0;_oo10005?oo1P00H_oo00<00?oo
ool0:Ooo0@000Ooo000bool00`00ooooo`0<ool00`00ooooo`0bool6000:ool4001Wool00`00oooo
o`0Zool10001ool003;oo`03003ooooo00goo`03003ooooo03Ooo`X006Woo`8002goo`40007oo`00
<_oo00<00?ooool03Ooo00<00?ooool0ZOoo00<00?ooool0;Ooo0@000Ooo000bool00`00ooooo`0>
ool00`00ooooo`2Vool2000`ool10001ool003;oo`03003ooooo00koo`03003ooooo0:Goo`03003o
oooo02ooo`80007oo`00<_oo00<00?ooool03_oo00<00?ooool0Y?oo00<00?ooool0<Ooo0@000Ooo
000bool00`00ooooo`0?ool00`00ooooo`2Qool2000dool10001ool003;oo`03003ooooo00ooo`03
003ooooo0:3oo`03003ooooo03Coo`40007oo`00:_oo10001?oo00<00?ooool04?oo00<00?ooool0
W_oo00<00?ooool0=Ooo0@000Ooo000Zool00`00ooooo`05ool00`00ooooo`0@ool00`00ooooo`2L
ool2000hool10001ool002_oo`03003ooooo00Coo`8001;oo`03003ooooo09[oo`03003ooooo03Oo
o`80007oo`00;?oo00<00?ooool00ooo00<00?ooool04_oo00<00?ooool0Uooo0P00>ooo0@000Ooo
000]ool00`00ooooo`02ool00`00ooooo`0Bool00`00ooooo`2Fool00`00ooooo`0kool10001ool0
02[oo`04003ooooo0004ool00`00ooooo`0Cool00`00ooooo`2Dool00`00ooooo`0lool10001ool0
02_oo`8000Goo`03003ooooo01Coo`03003ooooo097oo`8003ooo`40007oo`00<_oo00<00?ooool0
5Ooo00<00?ooool0Sooo00<00?ooool0?ooo0@000Ooo000bool00`00ooooo`0Eool00`00ooooo`2>
ool00`00ooooo`0oool20001ool003;oo`03003ooooo01Koo`03003ooooo08_oo`8004?oo`40007o
o`00<_oo00<00?ooool05ooo00<00?ooool0ROoo00<00?ooool0@ooo0@000Ooo000bool00`00oooo
o`0Gool00`00ooooo`27ool20016ool10001ool003;oo`03003ooooo01Soo`03003ooooo08Goo`03
003ooooo04Koo`40007oo`00<_oo00<00?ooool06Ooo00<00?ooool0Pooo00<00?ooool0Aooo0@00
0Ooo000bool00`00ooooo`0Iool00`00ooooo`21ool20019ool20001ool003;oo`03003ooooo01[o
o`03003ooooo07ooo`03003ooooo04[oo`40007oo`00<_oo00<00?ooool06ooo00<00?ooool0OOoo
00<00?ooool0Booo0@000Ooo000bool00`00ooooo`0Lool00`00ooooo`1jool2001>ool10001ool0
03;oo`03003ooooo01coo`03003ooooo07Woo`03003ooooo04koo`40007oo`00<_oo00<00?ooool0
7Ooo00<00?ooool0M_oo0P00DOoo0@000Ooo000bool00`00ooooo`0Nool00`00ooooo`1dool00`00
ooooo`1@ool20001ool003;oo`03003ooooo01ooo`8007?oo`03003ooooo05;oo`40007oo`00<_oo
00<00?ooool08Ooo00<00?ooool0K_oo0P00EOoo0@000Ooo000bool00`00ooooo`0Rool00`00oooo
o`1/ool00`00ooooo`1Eool10001ool003;oo`03003ooooo02?oo`8006_oo`03003ooooo05Koo`40
007oo`00<_oo00<00?ooool09Ooo00<00?ooool0I_oo0P00FOoo0@000Ooo000bool00`00ooooo`0V
ool00`00ooooo`1Sool2001Jool20001ool003;oo`03003ooooo02Ooo`80067oo`8005goo`40007o
o`00<_oo00<00?ooool0:Ooo00<00?ooool0G?oo0P00Gooo0@000Ooo000bool00`00ooooo`0Zool0
0`00ooooo`1Hool3001Qool10001ool001koo`@000?oo`03003ooooo00;oo`<000Goo`03003ooooo
02_oo`8005Koo`8006Coo`40007oo`007_oo00<00?ooool03?oo00<00?ooool00_oo00<00?ooool0
;Ooo00<00?ooool0D?oo0`00I_oo0@000Ooo000Oool00`00ooooo`0;ool00`00ooooo`02ool2000_
ool00`00ooooo`1=ool2001Xool20001ool0023oo`03003ooooo00Ooo`<000Goo`03003ooooo02oo
o`8004_oo`8006_oo`40007oo`008Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool0<Ooo
00<00?ooool0AOoo0`00KOoo0@000Ooo000Nool01000ooooo`002?oo00<00?ooool01Ooo00<00?oo
ool0<_oo00<00?ooool0@_oo0P00L?oo0@000Ooo000Oool20009ool40004ool00`00ooooo`0cool2
0010ool2001bool10001ool003;oo`03003ooooo03Goo`03003ooooo03[oo`<007Coo`40007oo`00
<_oo00<00?ooool0=_oo0P00=ooo0`00M_oo0P000Ooo000bool00`00ooooo`0hool4000`ool3001j
ool10001ool003;oo`03003ooooo03coo`@002Woo`<007goo`40007oo`00<_oo00<00?ooool0@?oo
1@007ooo1@00P?oo0@000Ooo000bool00`00ooooo`15ool3000<ool@0025ool10001ool003;oo`03
003ooooo04Soo``009Goo`40007oo`00<_oo00<00?ooool0j?oo0P000Ooo000bool00`00ooooo`3Y
ool10001ool003;oo`8000Goo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`80007o
o`00<_ook@000Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo
0000\
\>"],
  ImageRangeCache->{{{0, 287}, {205.188, 0}} -> {-0.052955, -0.554817, \
0.0166605, 0.0166605}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Backward Euler", "Section",
  CellTags->"s:3"],

Cell[TextData[{
  "Define the backward or implicit Euler method in terms of the RadauIIA \
implicit Runge-Kutta method and use it to solve ",
  "(",
  
  CounterBox["NumberedEquation", "LotkaVolterraSystem"],
  ")",
  " ."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(BackwardEuler\  = {"\<FixedStep\>", 
          Method \[Rule] \ {"\<ImplicitRungeKutta\>", "\<Coefficients\>" \
\[Rule] "\<ImplicitRungeKuttaRadauIIACoefficients\>", "\<DifferenceOrder\>" \
\[Rule] 1, "\<ImplicitSolver\>" \[Rule] {"\<FixedPoint\>", 
                  AccuracyGoal \[Rule] MachinePrecision, \ 
                  PrecisionGoal \[Rule] 
                    MachinePrecision, "\<IterationSafetyFactor\>" \[Rule] 
                    1}}};\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(besol\  = \ 
        NDSolve[system, Method \[Rule] BackwardEuler, 
          StartingStepSize \[Rule] step];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(LotkaVolterraPlot[besol, \ vars, \ time];\)\)}], "Input",
  CellLabel->"In[19]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .58816 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.20531 0.80055 -0.503578 0.80055 [
[.07557 -0.0125 -9 -9 ]
[.07557 -0.0125 9 0 ]
[.23568 -0.0125 -9 -9 ]
[.23568 -0.0125 9 0 ]
[.39579 -0.0125 -3 -9 ]
[.39579 -0.0125 3 0 ]
[.5559 -0.0125 -9 -9 ]
[.5559 -0.0125 9 0 ]
[.71601 -0.0125 -9 -9 ]
[.71601 -0.0125 9 0 ]
[.87612 -0.0125 -9 -9 ]
[.87612 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -13.8125 -19.9375 ]
[.5 -0.0125 13.8125 -9 ]
[-0.0125 .05681 -18 -4.5 ]
[-0.0125 .05681 0 4.5 ]
[-0.0125 .13686 -18 -4.5 ]
[-0.0125 .13686 0 4.5 ]
[-0.0125 .21692 -18 -4.5 ]
[-0.0125 .21692 0 4.5 ]
[-0.0125 .29697 -6 -4.5 ]
[-0.0125 .29697 0 4.5 ]
[-0.0125 .37703 -18 -4.5 ]
[-0.0125 .37703 0 4.5 ]
[-0.0125 .45708 -18 -4.5 ]
[-0.0125 .45708 0 4.5 ]
[-0.0125 .53714 -18 -4.5 ]
[-0.0125 .53714 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .29408 -45.625 -5.46875 ]
[-0.01875 .29408 -18 5.46875 ]
[ 0 .58816 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .58816 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07557 0 m
.07557 .00625 L
s
[(1.6)] .07557 -0.0125 0 1 Mshowa
.23568 0 m
.23568 .00625 L
s
[(1.8)] .23568 -0.0125 0 1 Mshowa
.39579 0 m
.39579 .00625 L
s
[(2)] .39579 -0.0125 0 1 Mshowa
.5559 0 m
.5559 .00625 L
s
[(2.2)] .5559 -0.0125 0 1 Mshowa
.71601 0 m
.71601 .00625 L
s
[(2.4)] .71601 -0.0125 0 1 Mshowa
.87612 0 m
.87612 .00625 L
s
[(2.6)] .87612 -0.0125 0 1 Mshowa
.125 Mabswid
.1156 0 m
.1156 .00375 L
s
.15563 0 m
.15563 .00375 L
s
.19565 0 m
.19565 .00375 L
s
.27571 0 m
.27571 .00375 L
s
.31574 0 m
.31574 .00375 L
s
.35576 0 m
.35576 .00375 L
s
.43582 0 m
.43582 .00375 L
s
.47585 0 m
.47585 .00375 L
s
.51587 0 m
.51587 .00375 L
s
.59593 0 m
.59593 .00375 L
s
.63596 0 m
.63596 .00375 L
s
.67598 0 m
.67598 .00375 L
s
.75604 0 m
.75604 .00375 L
s
.79607 0 m
.79607 .00375 L
s
.83609 0 m
.83609 .00375 L
s
.03554 0 m
.03554 .00375 L
s
.91615 0 m
.91615 .00375 L
s
.95618 0 m
.95618 .00375 L
s
.9962 0 m
.9962 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -74.8125 -23.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
0 .05681 m
.00625 .05681 L
s
[(0.7)] -0.0125 .05681 1 0 Mshowa
0 .13686 m
.00625 .13686 L
s
[(0.8)] -0.0125 .13686 1 0 Mshowa
0 .21692 m
.00625 .21692 L
s
[(0.9)] -0.0125 .21692 1 0 Mshowa
0 .29697 m
.00625 .29697 L
s
[(1)] -0.0125 .29697 1 0 Mshowa
0 .37703 m
.00625 .37703 L
s
[(1.1)] -0.0125 .37703 1 0 Mshowa
0 .45708 m
.00625 .45708 L
s
[(1.2)] -0.0125 .45708 1 0 Mshowa
0 .53714 m
.00625 .53714 L
s
[(1.3)] -0.0125 .53714 1 0 Mshowa
.125 Mabswid
0 .07282 m
.00375 .07282 L
s
0 .08883 m
.00375 .08883 L
s
0 .10484 m
.00375 .10484 L
s
0 .12085 m
.00375 .12085 L
s
0 .15287 m
.00375 .15287 L
s
0 .16888 m
.00375 .16888 L
s
0 .18489 m
.00375 .18489 L
s
0 .20091 m
.00375 .20091 L
s
0 .23293 m
.00375 .23293 L
s
0 .24894 m
.00375 .24894 L
s
0 .26495 m
.00375 .26495 L
s
0 .28096 m
.00375 .28096 L
s
0 .31298 m
.00375 .31298 L
s
0 .32899 m
.00375 .32899 L
s
0 .345 m
.00375 .345 L
s
0 .36102 m
.00375 .36102 L
s
0 .39304 m
.00375 .39304 L
s
0 .40905 m
.00375 .40905 L
s
0 .42506 m
.00375 .42506 L
s
0 .44107 m
.00375 .44107 L
s
0 .47309 m
.00375 .47309 L
s
0 .4891 m
.00375 .4891 L
s
0 .50511 m
.00375 .50511 L
s
0 .52113 m
.00375 .52113 L
s
0 .0408 m
.00375 .0408 L
s
0 .02478 m
.00375 .02478 L
s
0 .00877 m
.00375 .00877 L
s
0 .55315 m
.00375 .55315 L
s
0 .56916 m
.00375 .56916 L
s
0 .58517 m
.00375 .58517 L
s
.25 Mabswid
0 0 m
0 .58816 L
s
gsave
-0.01875 .29408 -106.625 -9.46875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
.07557 .58191 m
.07557 .58816 L
s
.23568 .58191 m
.23568 .58816 L
s
.39579 .58191 m
.39579 .58816 L
s
.5559 .58191 m
.5559 .58816 L
s
.71601 .58191 m
.71601 .58816 L
s
.87612 .58191 m
.87612 .58816 L
s
.125 Mabswid
.1156 .58441 m
.1156 .58816 L
s
.15563 .58441 m
.15563 .58816 L
s
.19565 .58441 m
.19565 .58816 L
s
.27571 .58441 m
.27571 .58816 L
s
.31574 .58441 m
.31574 .58816 L
s
.35576 .58441 m
.35576 .58816 L
s
.43582 .58441 m
.43582 .58816 L
s
.47585 .58441 m
.47585 .58816 L
s
.51587 .58441 m
.51587 .58816 L
s
.59593 .58441 m
.59593 .58816 L
s
.63596 .58441 m
.63596 .58816 L
s
.67598 .58441 m
.67598 .58816 L
s
.75604 .58441 m
.75604 .58816 L
s
.79607 .58441 m
.79607 .58816 L
s
.83609 .58441 m
.83609 .58816 L
s
.03554 .58441 m
.03554 .58816 L
s
.91615 .58441 m
.91615 .58816 L
s
.95618 .58441 m
.95618 .58816 L
s
.9962 .58441 m
.9962 .58816 L
s
.25 Mabswid
0 .58816 m
1 .58816 L
s
.99375 .05681 m
1 .05681 L
s
.99375 .13686 m
1 .13686 L
s
.99375 .21692 m
1 .21692 L
s
.99375 .29697 m
1 .29697 L
s
.99375 .37703 m
1 .37703 L
s
.99375 .45708 m
1 .45708 L
s
.99375 .53714 m
1 .53714 L
s
.125 Mabswid
.99625 .07282 m
1 .07282 L
s
.99625 .08883 m
1 .08883 L
s
.99625 .10484 m
1 .10484 L
s
.99625 .12085 m
1 .12085 L
s
.99625 .15287 m
1 .15287 L
s
.99625 .16888 m
1 .16888 L
s
.99625 .18489 m
1 .18489 L
s
.99625 .20091 m
1 .20091 L
s
.99625 .23293 m
1 .23293 L
s
.99625 .24894 m
1 .24894 L
s
.99625 .26495 m
1 .26495 L
s
.99625 .28096 m
1 .28096 L
s
.99625 .31298 m
1 .31298 L
s
.99625 .32899 m
1 .32899 L
s
.99625 .345 m
1 .345 L
s
.99625 .36102 m
1 .36102 L
s
.99625 .39304 m
1 .39304 L
s
.99625 .40905 m
1 .40905 L
s
.99625 .42506 m
1 .42506 L
s
.99625 .44107 m
1 .44107 L
s
.99625 .47309 m
1 .47309 L
s
.99625 .4891 m
1 .4891 L
s
.99625 .50511 m
1 .50511 L
s
.99625 .52113 m
1 .52113 L
s
.99625 .0408 m
1 .0408 L
s
.99625 .02478 m
1 .02478 L
s
.99625 .00877 m
1 .00877 L
s
.99625 .55315 m
1 .55315 L
s
.99625 .56916 m
1 .56916 L
s
.99625 .58517 m
1 .58517 L
s
.25 Mabswid
1 0 m
1 .58816 L
s
0 0 m
1 0 L
1 .58816 L
0 .58816 L
closepath
clip
newpath
.5 Mabswid
.97619 .29697 m
.97579 .29 L
.97468 .2833 L
.97084 .27052 L
.9603 .24604 L
.93407 .20009 L
.84602 .11943 L
.73823 .06691 L
.62232 .03438 L
.55864 .02323 L
.52693 .01931 L
.49573 .0165 L
.46703 .01521 L
.45263 .01436 L
.44553 .0141 L
.43853 .014 L
.4316 .01404 L
.42472 .01417 L
.41106 .01459 L
.38364 .01522 L
.32742 .02046 L
.27495 .02946 L
.184 .05753 L
.11538 .09597 L
.0619 .15124 L
.03275 .21393 L
.02569 .24774 L
.02466 .26553 L
.02425 .26992 L
.02388 .27432 L
.02381 .27879 L
.02398 .28331 L
.02438 .28828 L
.02494 .29329 L
.02627 .30336 L
.02869 .32337 L
.04037 .36404 L
.08071 .43771 L
.15024 .50737 L
.24309 .55536 L
.29323 .56768 L
.31907 .5715 L
.34589 .57284 L
.35312 .57333 L
.36028 .57393 L
.3675 .57416 L
.37477 .57399 L
.3821 .57352 L
.38946 .57283 L
.40422 .57112 L
Mistroke
.4624 .56145 L
.56439 .52398 L
.65219 .46119 L
.70544 .3895 L
.71867 .35562 L
.72247 .33881 L
.72407 .33052 L
.72434 .32647 L
.72436 .32245 L
.72417 .31813 L
.72387 .31383 L
.72327 .30523 L
.72181 .28824 L
.71105 .25657 L
.67212 .20605 L
.61783 .16738 L
.5467 .13872 L
.47555 .12457 L
.45626 .1222 L
.44669 .12168 L
.43713 .12133 L
.42757 .12089 L
.4228 .12062 L
.41808 .12052 L
.41341 .12055 L
.40878 .12069 L
.39958 .12115 L
.39055 .12164 L
.38149 .12198 L
.36408 .12385 L
.33046 .12936 L
.27448 .14698 L
.22583 .17571 L
.19286 .20996 L
.17431 .24947 L
.17182 .26089 L
.17117 .26676 L
.17047 .27261 L
.17 .27551 L
.1697 .27842 L
.16961 .28137 L
.16968 .28434 L
.16988 .28732 L
.17015 .29032 L
.17076 .29632 L
.17114 .3019 L
.17178 .30745 L
.17473 .31859 L
.18234 .34065 L
.21182 .38548 L
Mistroke
.25421 .41953 L
.30585 .44268 L
.33705 .44996 L
.35336 .45159 L
.36145 .45256 L
.3655 .45292 L
.36957 .45309 L
.3734 .45309 L
.37724 .453 L
.38495 .45263 L
.40034 .45208 L
.43056 .44727 L
.49119 .42666 L
.53933 .39506 L
.56944 .35915 L
.57869 .33864 L
.58195 .32842 L
.58327 .31823 L
.58407 .31347 L
.58435 .31111 L
.58442 .30879 L
.58433 .30648 L
.58412 .30419 L
.5835 .29963 L
.58245 .2905 L
.57998 .28178 L
.5625 .25021 L
.53068 .22293 L
.4934 .20443 L
.44813 .19226 L
.44675 .19199 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[19]:=",
  ImageSize->{288, 169.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000ZA000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00:Woo`03003ooooo00Goo`03003ooooo06coo`00X_oo
0`000ooo00<00?ooool01ooo00<00?ooool0Jooo002Lool30004ool00`00ooooo`02ool00`00ool0
00020005ool00`00ooooo`1[ool009goo`03003ooooo00?oo`03003ooooo00;oo`04003ooooo0006
ool00`00ooooo`1[ool009koo`03003ooooo00;oo`03003ooooo00;oo`04003ooooo0006ool00`00
ooooo`1[ool009koo`8000?oo`03003ooooo00;oo`05003oooooool00005ool00`00ooooo`1[ool0
09koo`03003oo`0000Ooo`05003oooooool00005ool00`00ooooo`1[ool009koo`04003ooooo0006
ool00`00ool00002ool00`00ool00002ool00`00ooooo`1[ool009goo`<00003ool0000000Koo`03
003oo`0000H006koo`00oooo8Ooo003ooolQool003_oo`@000?oo`03003ooooo00?oo`8001Ooo`@0
00?oo`03003ooooo00?oo`8001goo`@001coo`@000?oo`03003ooooo00;oo`@001Koo`@000?oo`03
003ooooo00Coo`03003ooooo01Goo`@000?oo`03003ooooo00?oo`8001Soo`00?Ooo00<00?ooool0
1ooo00@00?ooool001Soo`03003ooooo00Ooo`04003ooooo000Lool00`00ooooo`0Mool00`00oooo
o`09ool00`00ooooo`0Gool00`00ooooo`0;ool00`00ooooo`0Eool00`00ooooo`09ool01000oooo
o`005ooo000mool00`00ooooo`07ool01000ooooo`006?oo00<00?ooool01ooo00@00?ooool001go
o`03003ooooo01goo`03003ooooo00Woo`03003ooooo01Ooo`03003ooooo00Ooo`D001Ooo`03003o
oooo00Soo`04003ooooo000Gool003goo`03003ooooo00Ooo`<001Woo`03003ooooo00Soo`8001oo
o`03003ooooo01goo`03003ooooo00Woo`03003ooooo01Ooo`03003ooooo00Koo`04003ooooo000I
ool00`00ooooo`07ool3000Hool003goo`03003ooooo00Ooo`03003ooooo01Woo`03003ooooo00Oo
o`04003ooooo000Oool00`00ooooo`0Mool00`00ooooo`09ool00`00ooooo`0Gool00`00ooooo`06
ool00`00ool0000Jool00`00ooooo`06ool00`00ooooo`0Hool003_oo`<000Woo`03003ooooo01Oo
o`<000Woo`04003ooooo000Lool01000ooooo`007?oo00@00?ooool000Soo`04003ooooo000Fool0
1000ooooo`002Ooo0P005ooo00@00?ooool000Soo`03003ooooo01Soo`00?Ooo00<00?ooool02?oo
0`006?oo00<00?ooool02?oo0P007_oo0P007_oo0P002_oo0P006?oo0P002ooo00<00?ooool05_oo
0P002_oo0`005ooo003ooolQool00?ooob7oo`00oooo8Ooo000booo]0001ool003;oo`03003ooooo
00Goo`03003ooooo00Koo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo00Ooo`03003ooooo
00Koo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo
00Ooo`03003ooooo00Koo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo00Ooo`03003ooooo
00Koo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo
00Ooo`03003ooooo00Koo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo00Koo`80007oo`00
<_oo00<00?ooool03_oo00<00?ooool08ooo00<00?ooool08ooo00<00?ooool08ooo00<00?ooool0
8ooo00<00?ooool08ooo00<00?ooool06Ooo0P000Ooo000bool00`00ooooo`1Pool70022ool10001
ool003;oo`03003ooooo057oo`l000Ooo`l007?oo`40007oo`00<_oo00<00?ooool0Aooo2P009Ooo
1`00K?oo0@000Ooo000bool00`00ooooo`11ool6000fool8001Sool20001ool003;oo`03003ooooo
03goo`@004Coo`P005coo`40007oo`00<_oo00<00?ooool0>_oo0`00D?oo1@00Eooo0@000Ooo000b
ool00`00ooooo`0gool3001Hool4001Cool10001ool003;oo`03003ooooo03?oo`@005ooo`<004oo
o`80007oo`00<_oo00<00?ooool0<?oo0`00I_oo0`00COoo0@000Ooo000Oool20004ool00`00oooo
o`03ool00`00ooooo`04ool00`00ooooo`0]ool3001/ool40019ool10001ool001koo`04003ooooo
0009ool00`00ooooo`04ool00`00ooooo`0Zool3001cool30016ool10001ool001koo`04003ooooo
000:ool00`00ooooo`03ool2000Yool2001iool30012ool20001ool001koo`04003ooooo000:ool0
0`00ooooo`03ool00`00ooooo`0Vool2001nool4000oool10001ool001koo`04003ooooo000;ool0
0`00ooooo`02ool00`00ooooo`0Tool20024ool3000lool10001ool001koo`04003ooooo0008ool0
1000ooooo`001?oo00<00?ooool08_oo0P00ROoo0P00>Ooo0P000Ooo000Oool20009ool40004ool0
0`00ooooo`0Pool2002=ool2000hool10001ool003;oo`03003ooooo01ooo`03003ooooo08ooo`80
03Koo`40007oo`00<_oo00<00?ooool07Ooo0P00U?oo0P00=?oo0@000Ooo000bool00`00ooooo`0K
ool2002Hool2000aool20001ool003;oo`03003ooooo01Woo`8009coo`<002ooo`40007oo`00<_oo
00<00?ooool06?oo00<00?ooool0Wooo0P00;Ooo0@000Ooo000bool00`00ooooo`0Gool00`00oooo
o`2Rool2000[ool10001ool003;oo`03003ooooo01Koo`03003ooooo0:Goo`8002Soo`80007oo`00
<_oo00<00?ooool05Ooo00<00?ooool0Z?oo0P009ooo0@000Ooo000bool00`00ooooo`0Dool00`00
ooooo`2[ool2000Uool10001ool003;oo`03003ooooo01?oo`03003ooooo0:koo`8002?oo`40007o
o`00<_oo00<00?ooool04_oo00<00?ooool0??oo6P00Fooo00<00?ooool07ooo0P000Ooo000bool0
0`00ooooo`0Aool00`00ooooo`0iool4000Jool5001Gool00`00ooooo`0Oool10001ool001ooo`80
00Coo`03003ooooo00?oo`8000Goo`03003ooooo013oo`03003ooooo03Ooo`<002?oo`H005;oo`03
003ooooo01koo`40007oo`007_oo00@00?ooool000Soo`04003ooooo0004ool00`00ooooo`0?ool0
0`00ooooo`0eool3000/ool6001=ool00`00ooooo`0Mool10001ool001koo`04003ooooo0008ool0
1000ooooo`001?oo0P003ooo00<00?ooool0<_oo1000=Ooo1000B_oo00<00?ooool06ooo0P000Ooo
000Nool01000ooooo`002Ooo0P001Ooo00<00?ooool03Ooo00<00?ooool0<?oo0`00?Ooo0P00BOoo
00<00?ooool06ooo0@000Ooo000Nool01000ooooo`002?oo00@00?ooool000Coo`03003ooooo00co
o`03003ooooo02ooo`8004;oo`<004Ooo`03003ooooo01[oo`40007oo`007_oo00@00?ooool000So
o`04003ooooo0004ool00`00ooooo`0;ool00`00ooooo`0^ool20017ool20016ool00`00ooooo`0H
ool20001ool001ooo`8000[oo`8000Goo`03003ooooo00_oo`03003ooooo02coo`8004_oo`8004Go
o`03003ooooo01Soo`40007oo`00<_oo00<00?ooool02_oo00<00?ooool0:ooo0P00Cooo0`00@ooo
0P006?oo0@000Ooo000bool00`00ooooo`0:ool00`00ooooo`0Zool00`00ooooo`1Bool20013ool0
0`00ooooo`0Eool10001ool003;oo`03003ooooo00Woo`03003ooooo02Woo`8005Ooo`8004;oo`03
003ooooo01?oo`80007oo`00<_oo00<00?ooool02Ooo00<00?ooool09ooo0P00Fooo0P00@Ooo00<0
0?ooool04ooo0@000Ooo000bool00`00ooooo`08ool00`00ooooo`0Wool00`00ooooo`1Mool00`00
ooooo`0oool00`00ooooo`0Bool10001ool003;oo`03003ooooo00Soo`03003ooooo02Koo`03003o
oooo05ooo`80043oo`03003ooooo017oo`40007oo`00<_oo00<00?ooool01ooo00<00?ooool09_oo
00<00?ooool0H_oo00<00?ooool0?_oo00<00?ooool03ooo0P000Ooo000bool00`00ooooo`07ool0
0`00ooooo`0Uool00`00ooooo`1Tool00`00ooooo`0nool00`00ooooo`0?ool10001ool003;oo`03
003ooooo00Koo`03003ooooo02Goo`03003ooooo03Goo`<002koo`8003ooo`03003ooooo00koo`40
007oo`00<_oo00<00?ooool01_oo00<00?ooool09?oo00<00?ooool0>Ooo0`00;Ooo00<00?ooool0
?Ooo00<00?ooool03Ooo0@000Ooo000bool00`00ooooo`05ool00`00ooooo`0Tool00`00ooooo`0m
ool4000Zool2000nool00`00ooooo`0;ool20001ool001ooo`8000Coo`03003ooooo00;oo`<000Go
o`03003ooooo00Goo`03003ooooo02?oo`03003ooooo04;oo`<002Woo`03003ooooo03coo`03003o
oooo00_oo`40007oo`007_oo00@00?ooool000_oo`03003ooooo00;oo`03003ooooo00Coo`03003o
oooo02?oo`03003ooooo04Koo`8002Soo`03003ooooo03_oo`03003ooooo00_oo`40007oo`007_oo
00@00?ooool000_oo`03003ooooo00;oo`8000Goo`03003ooooo02?oo`03003ooooo04Soo`8002Ko
o`03003ooooo03coo`03003ooooo00Woo`80007oo`007_oo00@00?ooool000Woo`<000Coo`03003o
oooo00Coo`03003ooooo02;oo`03003ooooo04_oo`8002Goo`03003ooooo03_oo`03003ooooo00[o
o`40007oo`007_oo00@00?ooool000Soo`04003ooooo0004ool00`00ooooo`04ool00`00ooooo`0R
ool00`00ooooo`1=ool2000Tool00`00ooooo`0kool00`00ooooo`09ool10001ool001koo`04003o
oooo0008ool01000ooooo`001?oo00<00?ooool01?oo00<00?ooool08Ooo00<00?ooool0D?oo00<0
0?ooool08_oo00<00?ooool0>ooo00<00?ooool02?oo0@000Ooo000Oool2000:ool20005ool00`00
ooooo`04ool00`00ooooo`0Qool00`00ooooo`1Aool2000Rool00`00ooooo`0kool00`00ooooo`07
ool20001ool003;oo`03003ooooo00?oo`03003ooooo027oo`03003ooooo05Coo`03003ooooo023o
o`03003ooooo03_oo`03003ooooo00Ooo`40007oo`00<_oo00<00?ooool00ooo00<00?ooool08Ooo
00<00?ooool0EOoo00<00?ooool08?oo00<00?ooool0>_oo00<00?ooool01ooo0@000Ooo000bool0
0`00ooooo`03ool00`00ooooo`0Pool00`00ooooo`1Gool2000Qool00`00ooooo`0jool00`00oooo
o`06ool10001ool003;oo`03003ooooo00?oo`03003ooooo023oo`03003ooooo05Woo`03003ooooo
01koo`03003ooooo03[oo`03003ooooo00Goo`80007oo`00<_oo00<00?ooool00ooo00<00?ooool0
8?oo00<00?ooool0FOoo00<00?ooool07ooo00<00?ooool0>_oo00<00?ooool01Ooo0@000Ooo000b
ool00`00ooooo`03ool00`00ooooo`0Oool00`00ooooo`1Kool00`00ooooo`0Oool00`00ooooo`0i
ool00`00ooooo`05ool10001ool003;oo`03003ooooo00;oo`03003ooooo023oo`03003ooooo05_o
o`03003ooooo01ooo`03003ooooo03Woo`03003ooooo00Goo`40007oo`00<_oo00<00?ooool00_oo
00<00?ooool08?oo00<00?ooool0G?oo00<00?ooool07ooo00<00?ooool0>Ooo00<00?ooool00ooo
0P000Ooo000bool00`00ooooo`02ool00`00ooooo`0Pool00`00ooooo`1Lool00`00ooooo`0Oool0
0`00ooooo`0iool00`00ooooo`04ool10001ool003;oo`03003ooooo00;oo`03003ooooo023oo`03
003ooooo05goo`03003ooooo01koo`03003ooooo03Woo`03003ooooo00Coo`40007oo`003_oo00<0
0?ooool01Ooo00<00?ooool06Ooo00<00?ooool00_oo00<00?ooool08?oo00<00?ooool0GOoo00<0
0?ooool07_oo00<00?ooool0>_oo00<00?ooool00ooo0@000Ooo0007ool30003ool00`00ooooo`07
ool00`00ooooo`0Hool00`00ooooo`02ool00`00ooooo`0Pool00`00ooooo`1Nool00`00ooooo`0N
ool00`00ooooo`0iool00`00ooooo`02ool20001ool000;oo`<000;oo`03003ooooo00?oo`03003o
oooo00<000Coo`03003ooooo013oo`@000Coo`03003ooooo00;oo`03003ooooo023oo`03003ooooo
05koo`03003ooooo01koo`03003ooooo03Woo`03003ooooo00?oo`40007oo`000ooo00<00?ooool0
0_oo00<00?ooool00_oo00D00?ooooooo`0000Goo`03003ooooo01;oo`03003ooooo00?oo`03003o
oooo00;oo`03003ooooo023oo`03003ooooo05koo`03003ooooo01koo`03003ooooo03[oo`03003o
oooo00;oo`40007oo`001?oo00<00?ooool00_oo00D00?ooooooo`0000?oo`03003ooooo00?oo`03
003ooooo01;oo`03003ooooo00?oo`8000?oo`03003ooooo023oo`03003ooooo05koo`03003ooooo
01koo`03003ooooo03[oo`04003oooooool20001ool000Coo`800004ool000000003ool00`00oooo
o`02ool00`00ooooo`02ool00`00ooooo`0Bool00`00ooooo`03ool00`00ooooo`02ool00`00oooo
o`0Pool00`00ooooo`1Oool00`00ooooo`0Nool00`00ooooo`0nool10001ool000Coo`03003oo`00
00Koo`03003ooooo00;oo`03003ooooo00;oo`03003ooooo01;oo`03003ooooo00?oo`03003ooooo
00?oo`03003ooooo01ooo`03003ooooo05ooo`03003ooooo01koo`03003ooooo03koo`40007oo`00
1?oo00@00?ooool000Goo`04003ooooo0002ool01@00ool00?oo00004_oo0`001Ooo00<00?ooool0
0ooo00<00?ooool07ooo00<00?ooool0Gooo00<00?ooool07_oo00<00?ooool0?_oo0@000Ooo0003
ool300000ooo00000005ool00`00ooooo`06000Eool00`00ooooo`03ool00`00ooooo`03ool00`00
ooooo`0Oool00`00ooooo`1Oool00`00ooooo`0Nool00`00ooooo`0mool20001ool003;oo`03003o
oooo00?oo`03003ooooo023oo`03003ooooo05koo`03003ooooo01koo`03003ooooo03koo`40007o
o`00<_oo00<00?ooool00ooo00<00?ooool08?oo00<00?ooool0G_oo00<00?ooool07_oo00<00?oo
ool0?_oo0@000Ooo000bool00`00ooooo`03ool00`00ooooo`0Pool00`00ooooo`1Mool00`00oooo
o`0Oool00`00ooooo`0nool10001ool003;oo`03003ooooo00?oo`03003ooooo027oo`03003ooooo
05coo`03003ooooo01ooo`03003ooooo03goo`80007oo`00<_oo00<00?ooool01?oo00<00?ooool0
8?oo00<00?ooool0G?oo00<00?ooool07ooo00<00?ooool0?_oo0@000Ooo000bool00`00ooooo`04
ool00`00ooooo`0Qool00`00ooooo`1Kool00`00ooooo`0Oool00`00ooooo`0nool10001ool003;o
o`03003ooooo00Coo`03003ooooo027oo`03003ooooo05[oo`03003ooooo023oo`03003ooooo03ko
o`40007oo`00<_oo00<00?ooool01Ooo00<00?ooool08Ooo00<00?ooool0FOoo00<00?ooool08?oo
00<00?ooool0?Ooo0P000Ooo000bool00`00ooooo`05ool00`00ooooo`0Qool00`00ooooo`1Hool0
0`00ooooo`0Pool00`00ooooo`0oool10001ool003;oo`03003ooooo00Goo`03003ooooo02;oo`03
003ooooo05Ooo`03003ooooo023oo`03003ooooo03ooo`40007oo`00<_oo00<00?ooool01_oo00<0
0?ooool08_oo00<00?ooool0EOoo00<00?ooool08Ooo00<00?ooool0?ooo0@000Ooo000bool00`00
ooooo`06ool00`00ooooo`0Rool00`00ooooo`1Dool00`00ooooo`0Qool00`00ooooo`0oool20001
ool001koo`@000?oo`03003ooooo00;oo`@000Coo`03003ooooo00Ooo`03003ooooo02;oo`03003o
oooo05;oo`03003ooooo02;oo`03003ooooo043oo`40007oo`008?oo00<00?ooool02Ooo00<00?oo
ool00ooo00<00?ooool01ooo00<00?ooool08ooo00<00?ooool0DOoo00<00?ooool08_oo00<00?oo
ool0@?oo0@000Ooo000Pool00`00ooooo`09ool00`00ooooo`03ool20009ool00`00ooooo`0Sool0
0`00ooooo`1?ool00`00ooooo`0Rool00`00ooooo`10ool20001ool0023oo`03003ooooo00Woo`03
003ooooo00?oo`03003ooooo00Soo`03003ooooo02?oo`03003ooooo04koo`03003ooooo02?oo`03
003ooooo047oo`40007oo`008?oo00<00?ooool02Ooo00<00?ooool00ooo00<00?ooool02Ooo00<0
0?ooool08ooo00<00?ooool0C?oo00<00?ooool08ooo00<00?ooool0@_oo0@000Ooo000Nool30009
ool30005ool00`00ooooo`09ool00`00ooooo`0Tool00`00ooooo`1;ool00`00ooooo`0Sool00`00
ooooo`12ool10001ool0023oo`03003ooooo00Woo`03003ooooo00?oo`03003ooooo00[oo`03003o
oooo02Coo`8004[oo`03003ooooo02?oo`03003ooooo04;oo`80007oo`00<_oo00<00?ooool02_oo
00<00?ooool09_oo00<00?ooool0A_oo00<00?ooool08ooo00<00?ooool0A?oo0@000Ooo000bool0
0`00ooooo`0;ool00`00ooooo`0Vool00`00ooooo`13ool2000Vool00`00ooooo`14ool10001ool0
03;oo`03003ooooo00coo`03003ooooo02Koo`03003ooooo047oo`03003ooooo02Goo`03003ooooo
04Goo`40007oo`00<_oo00<00?ooool03?oo00<00?ooool09ooo0P00?ooo0P009ooo00<00?ooool0
AOoo0P000Ooo000bool00`00ooooo`0=ool00`00ooooo`0Xool00`00ooooo`0jool2000Xool00`00
ooooo`17ool10001ool003;oo`03003ooooo00goo`03003ooooo02Woo`03003ooooo03Soo`03003o
oooo02Soo`03003ooooo04Ooo`40007oo`00<_oo00<00?ooool03_oo00<00?ooool0:Ooo0P00=_oo
0P00:_oo00<00?ooool0B?oo0@000Ooo000bool00`00ooooo`0>ool00`00ooooo`0[ool2000bool2
000[ool00`00ooooo`18ool20001ool003;oo`03003ooooo00ooo`03003ooooo02coo`8002goo`<0
02coo`03003ooooo04[oo`40007oo`00<_oo00<00?ooool03ooo00<00?ooool0;_oo0P00:?oo0`00
;ooo00<00?ooool0B_oo0@000Ooo000bool00`00ooooo`0@ool00`00ooooo`0_ool2000Tool2000a
ool00`00ooooo`1;ool10001ool003;oo`03003ooooo017oo`03003ooooo033oo`<001koo`<003;o
o`03003ooooo04_oo`80007oo`007_oo10000ooo00<00?ooool00_oo10001?oo00<00?ooool04_oo
00<00?ooool0<_oo10005?oo1P00=?oo00<00?ooool0COoo0@000Ooo000Pool00`00ooooo`07ool0
0`00ooooo`05ool00`00ooooo`0Cool00`00ooooo`0eoolD000jool00`00ooooo`1=ool10001ool0
023oo`03003ooooo00Soo`03003ooooo00Coo`8001Goo`03003ooooo087oo`03003ooooo04goo`80
007oo`008?oo00<00?ooool02Ooo00<00?ooool00ooo00<00?ooool05Ooo00<00?ooool0Oooo00<0
0?ooool0Cooo0@000Ooo000Pool00`00ooooo`0:ool00`00ooooo`02ool00`00ooooo`0Fool00`00
ooooo`1lool2001Bool10001ool001koo`<000Woo`04003ooooo0004ool00`00ooooo`0Gool00`00
ooooo`1jool00`00ooooo`1Bool10001ool0023oo`03003ooooo00Soo`8000Goo`03003ooooo01So
o`03003ooooo07Soo`03003ooooo05;oo`80007oo`00<_oo00<00?ooool06Ooo00<00?ooool0MOoo
0P00E_oo0@000Ooo000bool00`00ooooo`0Jool00`00ooooo`1cool00`00ooooo`1Fool10001ool0
03;oo`03003ooooo01_oo`03003ooooo073oo`8005Woo`40007oo`00<_oo00<00?ooool07?oo00<0
0?ooool0K_oo00<00?ooool0F?oo0P000Ooo000bool00`00ooooo`0Mool00`00ooooo`1/ool00`00
ooooo`1Jool10001ool003;oo`03003ooooo01koo`03003ooooo06Woo`8005goo`40007oo`00<_oo
00<00?ooool07ooo00<00?ooool0Iooo00<00?ooool0GOoo0@000Ooo000bool00`00ooooo`0Pool0
0`00ooooo`1Tool2001Oool20001ool003;oo`03003ooooo027oo`8006?oo`03003ooooo063oo`40
007oo`00<_oo00<00?ooool08ooo0P00H?oo00<00?ooool0HOoo0@000Ooo000bool00`00ooooo`0U
ool2001Lool2001Tool10001ool003;oo`03003ooooo02Ooo`8005Soo`8006Goo`80007oo`007_oo
10000ooo00<00?ooool00ooo0P001Ooo00<00?ooool0:Ooo0P00Dooo0`00J?oo0@000Ooo000Pool0
0`00ooooo`07ool01000ooooo`001?oo00<00?ooool0:ooo00<00?ooool0C_oo0P00Jooo0@000Ooo
000Pool00`00ooooo`0:ool00`00ooooo`02ool2000]ool2001;ool3001/ool20001ool0023oo`03
003ooooo00Soo`8000Goo`03003ooooo02koo`8004Koo`<0073oo`40007oo`008?oo00<00?ooool0
2_oo00<00?ooool00_oo00<00?ooool0<?oo0P00@_oo0P00Looo0@000Ooo000Nool30009ool01000
ooooo`001?oo00<00?ooool0<_oo0P00?Ooo0`00MOoo0@000Ooo000Pool00`00ooooo`08ool20005
ool00`00ooooo`0dool2000hool3001gool20001ool003;oo`03003ooooo03Koo`8003Coo`8007_o
o`40007oo`00<_oo00<00?ooool0>?oo1000:ooo1@00OOoo0@000Ooo000bool00`00ooooo`0lool4
000Pool70022ool10001ool003;oo`03003ooooo043oo`/0013oo`D008Soo`80007oo`00<_oo00<0
0?ooool0Booo4000S_oo0@000Ooo000bool00`00ooooo`3Yool10001ool003;oo`03003ooooo00ko
o`03003ooooo02?oo`03003ooooo02?oo`03003ooooo02?oo`03003ooooo02?oo`03003ooooo02?o
o`03003ooooo01[oo`40007oo`00<_ook@000Ooo003ooolQool00?ooob7oo`00oooo8Ooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {168.375, 0}} -> {1.24151, 0.491913, \
0.00527492, 0.00527492}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Projection", "Section",
  CellTags->"s:4"],

Cell[TextData[{
  "Projection of the forward Euler method using the invariant (",
  
  CounterBox["NumberedEquation", "LotkaVolterraInvariant"],
  ") of the Lotka-Volterra equations gives a periodic solution."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(pfesol\  = \ 
        NDSolve[system, 
          Method \[Rule] {Projection, Method \[Rule] "\<ExplicitEuler\>", \ 
              Invariants \[Rule] invts}, 
          StartingStepSize \[Rule] step];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(LotkaVolterraPlot[pfesol, \ vars, \ time];\)\)}], "Input",
  CellLabel->"In[22]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70917 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.00733 0.727898 -0.42481 0.727898 [
[.01173 -0.0125 -9 -9 ]
[.01173 -0.0125 9 0 ]
[.15731 -0.0125 -9 -9 ]
[.15731 -0.0125 9 0 ]
[.30288 -0.0125 -9 -9 ]
[.30288 -0.0125 9 0 ]
[.44846 -0.0125 -3 -9 ]
[.44846 -0.0125 3 0 ]
[.59404 -0.0125 -9 -9 ]
[.59404 -0.0125 9 0 ]
[.73962 -0.0125 -9 -9 ]
[.73962 -0.0125 9 0 ]
[.8852 -0.0125 -9 -9 ]
[.8852 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -13.8125 -19.9375 ]
[.5 -0.0125 13.8125 -9 ]
[-0.0125 .01193 -18 -4.5 ]
[-0.0125 .01193 0 4.5 ]
[-0.0125 .15751 -18 -4.5 ]
[-0.0125 .15751 0 4.5 ]
[-0.0125 .30309 -6 -4.5 ]
[-0.0125 .30309 0 4.5 ]
[-0.0125 .44867 -18 -4.5 ]
[-0.0125 .44867 0 4.5 ]
[-0.0125 .59425 -18 -4.5 ]
[-0.0125 .59425 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .35458 -45.625 -5.46875 ]
[-0.01875 .35458 -18 5.46875 ]
[ 0 .70917 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .70917 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01173 0 m
.01173 .00625 L
s
[(1.4)] .01173 -0.0125 0 1 Mshowa
.15731 0 m
.15731 .00625 L
s
[(1.6)] .15731 -0.0125 0 1 Mshowa
.30288 0 m
.30288 .00625 L
s
[(1.8)] .30288 -0.0125 0 1 Mshowa
.44846 0 m
.44846 .00625 L
s
[(2)] .44846 -0.0125 0 1 Mshowa
.59404 0 m
.59404 .00625 L
s
[(2.2)] .59404 -0.0125 0 1 Mshowa
.73962 0 m
.73962 .00625 L
s
[(2.4)] .73962 -0.0125 0 1 Mshowa
.8852 0 m
.8852 .00625 L
s
[(2.6)] .8852 -0.0125 0 1 Mshowa
.125 Mabswid
.04812 0 m
.04812 .00375 L
s
.08452 0 m
.08452 .00375 L
s
.12091 0 m
.12091 .00375 L
s
.1937 0 m
.1937 .00375 L
s
.2301 0 m
.2301 .00375 L
s
.26649 0 m
.26649 .00375 L
s
.33928 0 m
.33928 .00375 L
s
.37567 0 m
.37567 .00375 L
s
.41207 0 m
.41207 .00375 L
s
.48486 0 m
.48486 .00375 L
s
.52125 0 m
.52125 .00375 L
s
.55765 0 m
.55765 .00375 L
s
.63044 0 m
.63044 .00375 L
s
.66683 0 m
.66683 .00375 L
s
.70323 0 m
.70323 .00375 L
s
.77602 0 m
.77602 .00375 L
s
.81241 0 m
.81241 .00375 L
s
.84881 0 m
.84881 .00375 L
s
.9216 0 m
.9216 .00375 L
s
.95799 0 m
.95799 .00375 L
s
.99439 0 m
.99439 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -74.8125 -23.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
0 .01193 m
.00625 .01193 L
s
[(0.6)] -0.0125 .01193 1 0 Mshowa
0 .15751 m
.00625 .15751 L
s
[(0.8)] -0.0125 .15751 1 0 Mshowa
0 .30309 m
.00625 .30309 L
s
[(1)] -0.0125 .30309 1 0 Mshowa
0 .44867 m
.00625 .44867 L
s
[(1.2)] -0.0125 .44867 1 0 Mshowa
0 .59425 m
.00625 .59425 L
s
[(1.4)] -0.0125 .59425 1 0 Mshowa
.125 Mabswid
0 .04832 m
.00375 .04832 L
s
0 .08472 m
.00375 .08472 L
s
0 .12111 m
.00375 .12111 L
s
0 .1939 m
.00375 .1939 L
s
0 .2303 m
.00375 .2303 L
s
0 .26669 m
.00375 .26669 L
s
0 .33948 m
.00375 .33948 L
s
0 .37588 m
.00375 .37588 L
s
0 .41227 m
.00375 .41227 L
s
0 .48506 m
.00375 .48506 L
s
0 .52146 m
.00375 .52146 L
s
0 .55785 m
.00375 .55785 L
s
0 .63064 m
.00375 .63064 L
s
0 .66704 m
.00375 .66704 L
s
0 .70343 m
.00375 .70343 L
s
.25 Mabswid
0 0 m
0 .70917 L
s
gsave
-0.01875 .35458 -106.625 -9.46875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
.01173 .70292 m
.01173 .70917 L
s
.15731 .70292 m
.15731 .70917 L
s
.30288 .70292 m
.30288 .70917 L
s
.44846 .70292 m
.44846 .70917 L
s
.59404 .70292 m
.59404 .70917 L
s
.73962 .70292 m
.73962 .70917 L
s
.8852 .70292 m
.8852 .70917 L
s
.125 Mabswid
.04812 .70542 m
.04812 .70917 L
s
.08452 .70542 m
.08452 .70917 L
s
.12091 .70542 m
.12091 .70917 L
s
.1937 .70542 m
.1937 .70917 L
s
.2301 .70542 m
.2301 .70917 L
s
.26649 .70542 m
.26649 .70917 L
s
.33928 .70542 m
.33928 .70917 L
s
.37567 .70542 m
.37567 .70917 L
s
.41207 .70542 m
.41207 .70917 L
s
.48486 .70542 m
.48486 .70917 L
s
.52125 .70542 m
.52125 .70917 L
s
.55765 .70542 m
.55765 .70917 L
s
.63044 .70542 m
.63044 .70917 L
s
.66683 .70542 m
.66683 .70917 L
s
.70323 .70542 m
.70323 .70917 L
s
.77602 .70542 m
.77602 .70917 L
s
.81241 .70542 m
.81241 .70917 L
s
.84881 .70542 m
.84881 .70917 L
s
.9216 .70542 m
.9216 .70917 L
s
.95799 .70542 m
.95799 .70917 L
s
.99439 .70542 m
.99439 .70917 L
s
.25 Mabswid
0 .70917 m
1 .70917 L
s
.99375 .01193 m
1 .01193 L
s
.99375 .15751 m
1 .15751 L
s
.99375 .30309 m
1 .30309 L
s
.99375 .44867 m
1 .44867 L
s
.99375 .59425 m
1 .59425 L
s
.125 Mabswid
.99625 .04832 m
1 .04832 L
s
.99625 .08472 m
1 .08472 L
s
.99625 .12111 m
1 .12111 L
s
.99625 .1939 m
1 .1939 L
s
.99625 .2303 m
1 .2303 L
s
.99625 .26669 m
1 .26669 L
s
.99625 .33948 m
1 .33948 L
s
.99625 .37588 m
1 .37588 L
s
.99625 .41227 m
1 .41227 L
s
.99625 .48506 m
1 .48506 L
s
.99625 .52146 m
1 .52146 L
s
.99625 .55785 m
1 .55785 L
s
.99625 .63064 m
1 .63064 L
s
.99625 .66704 m
1 .66704 L
s
.99625 .70343 m
1 .70343 L
s
.25 Mabswid
1 0 m
1 .70917 L
s
0 0 m
1 0 L
1 .70917 L
0 .70917 L
closepath
clip
newpath
.5 Mabswid
.97619 .30309 m
.97609 .29666 L
.97577 .29031 L
.97452 .27786 L
.96958 .25375 L
.95125 .20982 L
.87884 .13146 L
.78198 .07799 L
.67038 .0424 L
.54226 .02141 L
.5124 .019 L
.49776 .01814 L
.48307 .01751 L
.46833 .0171 L
.46099 .01697 L
.4537 .0169 L
.44647 .01688 L
.43933 .01692 L
.43229 .01702 L
.42529 .01717 L
.40999 .01769 L
.3947 .01847 L
.36507 .02075 L
.30826 .0284 L
.20935 .05494 L
.13453 .09314 L
.07438 .14875 L
.0392 .21235 L
.02928 .24753 L
.02624 .26587 L
.02436 .28517 L
.02389 .29551 L
.02381 .30074 L
.02383 .30604 L
.02394 .31145 L
.02416 .317 L
.02486 .32828 L
.02739 .35031 L
.03169 .37338 L
.06265 .46098 L
.12649 .55477 L
.22219 .63284 L
.33922 .67979 L
.37601 .68696 L
.39431 .68939 L
.41297 .69107 L
.43245 .69203 L
.4426 .69225 L
.45267 .69228 L
.46262 .69213 L
Mistroke
.47251 .69178 L
.49232 .69049 L
.51115 .68853 L
.53069 .68582 L
.56968 .67844 L
.64765 .65524 L
.80651 .56989 L
.92383 .45182 L
.95648 .39303 L
.96705 .36402 L
.97338 .33614 L
.9753 .32109 L
.97586 .3137 L
.97614 .30643 L
.97615 .29933 L
.97589 .29239 L
.97466 .27887 L
.96935 .2529 L
.96045 .2281 L
.90237 .15064 L
.81431 .09262 L
.69715 .04921 L
.57845 .02555 L
.51364 .01908 L
.48191 .01747 L
.466 .01705 L
.45807 .01694 L
.45017 .01689 L
.44249 .0169 L
.4349 .01698 L
.42002 .01731 L
.39017 .01876 L
.33318 .0245 L
.23669 .0455 L
.15011 .08324 L
.08902 .13166 L
.0483 .19081 L
.03439 .22708 L
.0295 .24649 L
.02618 .26622 L
.02433 .28582 L
.0239 .29552 L
.02381 .30038 L
.02381 .30528 L
.0239 .31025 L
.02407 .31531 L
.02468 .3258 L
.02685 .34657 L
.03657 .39312 L
.05339 .44083 L
Mistroke
.10512 .52907 L
.18429 .60757 L
.30229 .66929 L
.36748 .68553 L
.40199 .69018 L
.41949 .6915 L
.42847 .69192 L
.43766 .69217 L
.44791 .69228 L
.45819 .6922 L
.46834 .69193 L
.4784 .69147 L
.51893 .68755 L
.60318 .66984 L
.76469 .5981 L
.88853 .49632 L
.93613 .43287 L
.95285 .40124 L
.96545 .3691 L
.97256 .34097 L
.97468 .32698 L
.97588 .31315 L
.97613 .30636 L
.97615 .29968 L
.97593 .29313 L
.97549 .28672 L
.974 .27424 L
.97171 .26213 L
.9553 .21728 L
.92884 .17792 L
.84434 .10881 L
.74034 .06234 L
.61375 .0309 L
.60988 .03025 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[22]:=",
  ImageSize->{288, 204.188},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000c1000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
X_oo0`001?oo00<00?ooool01Ooo00<00?ooool0K?oo002Sool00`00ooooo`02ool00`00ooooo`07
ool00`00ooooo`1[ool009coo`<000Coo`03003ooooo00;oo`03003oo`00008000Goo`03003ooooo
06_oo`00WOoo00<00?ooool00ooo00<00?ooool00_oo00@00?ooool000Koo`03003ooooo06_oo`00
W_oo00<00?ooool00_oo00<00?ooool00_oo00@00?ooool000Koo`03003ooooo06_oo`00W_oo0P00
2?oo00D00?ooooooo`0000Goo`03003ooooo06_oo`00W_oo00<00?oo00001ooo00D00?ooooooo`00
00Goo`03003ooooo06_oo`00W_oo00@00?ooool000Koo`03003oo`0000;oo`03003oo`0000;oo`03
003ooooo06_oo`00WOoo0`0000?oo`0000001_oo00<00?oo00001P00K_oo003ooolQool002coo`@0
00?oo`03003ooooo00Coo`03003ooooo01;oo`@000?oo`03003ooooo00?oo`8001?oo`@000?oo`03
003ooooo00?oo`8001[oo`@001Soo`@000?oo`03003ooooo00;oo`@001?oo`@000?oo`03003ooooo
00Coo`03003ooooo017oo`@000?oo`03003ooooo00?oo`8001Koo`00;_oo00<00?ooool02Ooo00<0
0?ooool05?oo00<00?ooool01ooo00@00?ooool001Coo`03003ooooo00Ooo`04003ooooo000Iool0
0`00ooooo`0Iool00`00ooooo`09ool00`00ooooo`0Dool00`00ooooo`0;ool00`00ooooo`0Aool0
0`00ooooo`09ool01000ooooo`005Ooo000^ool00`00ooooo`06ool5000Eool00`00ooooo`07ool0
1000ooooo`005?oo00<00?ooool01ooo00@00?ooool001[oo`03003ooooo01Woo`03003ooooo00Wo
o`03003ooooo01Coo`03003ooooo00Ooo`D001?oo`03003ooooo00Soo`04003ooooo000Eool002ko
o`03003ooooo00Koo`04003ooooo000Fool00`00ooooo`07ool3000Eool00`00ooooo`08ool2000L
ool00`00ooooo`0Iool00`00ooooo`09ool00`00ooooo`0Dool00`00ooooo`06ool01000ooooo`00
5Ooo00<00?ooool01ooo0`005_oo000^ool00`00ooooo`07ool00`00ool0000Fool00`00ooooo`07
ool00`00ooooo`0Eool00`00ooooo`07ool01000ooooo`007?oo00<00?ooool06Ooo00<00?ooool0
2Ooo00<00?ooool05?oo00<00?ooool01_oo00<00?oo00005_oo00<00?ooool01_oo00<00?ooool0
5_oo000/ool3000:ool2000Dool30009ool00`00ooooo`0Cool30009ool01000ooooo`006Ooo00@0
0?ooool001Soo`04003ooooo0008ool01000ooooo`004ooo00@00?ooool000Woo`8001?oo`04003o
oooo0008ool00`00ooooo`0Fool002koo`03003ooooo00Woo`03003ooooo01Coo`03003ooooo00So
o`<001Coo`03003ooooo00Soo`8001_oo`8001[oo`8000[oo`8001Goo`8000_oo`03003ooooo01;o
o`8000[oo`<001Goo`00oooo8Ooo003ooolQool00?ooob7oo`00<_ook@000Ooo000Oool20004ool0
0`00ooooo`03ool20005ool00`00ool00008ool00`00ooooo`06ool00`00ooooo`05ool00`00oooo
o`06ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`06ool00`00ooooo`05ool00`00oooo
o`06ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`05ool00`00oooo
o`06ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`05ool00`00oooo
o`06ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`06ool00`00oooo
o`05ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`06ool20001ool001koo`04003ooooo
0008ool01000ooooo`001?oo00<00?oo00008_oo00<00?ooool07ooo00<00?ooool08?oo00<00?oo
ool07ooo00<00?ooool08?oo00<00?ooool07ooo00<00?ooool06?oo0@000Ooo000Nool01000oooo
o`002?oo00@00?ooool000Coo`800>Woo`80007oo`007_oo00@00?ooool000Soo`<000Goo`03003o
oooo05gooa0007coo`40007oo`007_oo00@00?ooool000Soo`03003ooooo00Goo`03003ooooo053o
oa0000gooa<006Woo`40007oo`007_oo00@00?ooool000Soo`03003ooooo00Goo`03003ooooo04Wo
o`T002coo`/0063oo`40007oo`007ooo0P002_oo0`001?oo00<00?ooool0A?oo1P00??oo1`00G?oo
0@000Ooo000bool00`00ooooo`10ool50017ool6001Gool10001ool003;oo`03003ooooo03coo`@0
057oo`L0057oo`40007oo`00<_oo00<00?ooool0>?oo1000FOoo2000C?oo0@000Ooo000bool00`00
ooooo`0dool4001Qool70019ool10001ool003;oo`03003ooooo033oo`@006Woo`L004Coo`80007o
o`00<_oo00<00?ooool0;Ooo1@00L?oo1@00@_oo0@000Ooo000bool00`00ooooo`0[ool5001fool4
000oool10001ool003;oo`03003ooooo02Woo`@007coo`D003_oo`40007oo`00<_oo00<00?ooool0
9ooo1000POoo1000>Ooo0@000Ooo000bool00`00ooooo`0Uool40026ool3000gool10001ool003;o
o`03003ooooo02?oo`<008_oo`@003Coo`40007oo`00<_oo00<00?ooool08Ooo0`00T?oo0`00<_oo
0@000Ooo000bool00`00ooooo`0Oool3002Eool2000_ool20001ool003;oo`03003ooooo01goo`<0
09Woo`<002goo`40007oo`00<_oo00<00?ooool07?oo00<00?oo0000W?oo0`00:ooo0@000Ooo000b
ool00`00ooooo`0Kool3002Oool3000Yool10001ool003;oo`03003ooooo01[oo`800:;oo`@002Oo
o`40007oo`00<_oo00<00?ooool06Ooo0P00YOoo10009Ooo0@000Ooo000bool00`00ooooo`0Hool2
002Xool4000Sool10001ool003;oo`03003ooooo01Ooo`800:_oo`<002;oo`40007oo`00<_oo00<0
0?ooool05_oo0P00[_oo0P008Ooo0@000Ooo000bool00`00ooooo`0Eool2002`ool3000Nool20001
ool003;oo`03003ooooo01Coo`03003ooooo0;;oo`8001koo`40007oo`00<_oo00<00?ooool04ooo
00<00?ooool0]?oo0`007?oo0@000Ooo000bool00`00ooooo`0Bool00`00ooooo`2gool2000Kool1
0001ool003;oo`03003ooooo017oo`03003ooooo0;Woo`8001[oo`40007oo`00<_oo00<00?ooool0
4?oo0P00_?oo0P006Ooo0@000Ooo000bool00`00ooooo`0?ool2002nool3000Gool10001ool001oo
o`8000Coo`03003ooooo00?oo`8000Goo`03003ooooo00koo`800<7oo`8001Koo`40007oo`007_oo
00@00?ooool000Soo`04003ooooo0004ool00`00ooooo`0=ool20033ool2000Eool10001ool001ko
o`04003ooooo0008ool01000ooooo`001?oo0P003_oo0P00a?oo0P004ooo0P000Ooo000Nool01000
ooooo`002Ooo0P001Ooo00<00?ooool03?oo0P00a_oo00<00?ooool04_oo0@000Ooo000Nool01000
ooooo`002?oo00@00?ooool000Coo`03003ooooo00coo`03003ooooo0<Koo`8001;oo`40007oo`00
7_oo00@00?ooool000Soo`04003ooooo0004ool00`00ooooo`0;ool20038ool3000Aool10001ool0
01ooo`8000[oo`8000Goo`03003ooooo00_oo`03003ooooo0<Soo`<0013oo`40007oo`00<_oo00<0
0?ooool02_oo00<00?ooool0b_oo00<00?oo00003ooo0@000Ooo000bool00`00ooooo`09ool2003=
ool00`00ool0000>ool10001ool003;oo`03003ooooo00Woo`03003ooooo0<goo`8000koo`40007o
o`00<_oo00<00?ooool02?oo0P00d?oo0P003?oo0P000Ooo000bool00`00ooooo`08ool00`00oooo
o`3@ool2000<ool10001ool003;oo`03003ooooo00Ooo`800=;oo`8000coo`40007oo`00<_oo00<0
0?ooool01ooo00<00?ooool0d_oo0P002ooo0@000Ooo000bool00`00ooooo`07ool00`00ooooo`3C
ool2000:ool10001ool003;oo`03003ooooo00Koo`03003ooooo0=Goo`03003ooooo00Soo`40007o
o`00<_oo00<00?ooool01_oo00<00?ooool0eOoo0P002Ooo0@000Ooo000bool00`00ooooo`05ool2
003Hool00`00ooooo`07ool10001ool003;oo`03003ooooo00Goo`03003ooooo0=Soo`03003ooooo
00Koo`40007oo`00<_oo00<00?ooool01Ooo00<00?ooool0f?oo00<00?ooool01Ooo0P000Ooo000b
ool00`00ooooo`05ool00`00ooooo`3Hool20007ool10001ool003;oo`03003ooooo00Coo`800=_o
o`03003ooooo00Goo`40007oo`00<_oo00<00?ooool01?oo00<00?ooool0f_oo00<00?ooool01Ooo
0@000Ooo000bool00`00ooooo`04ool00`00ooooo`3Kool00`00ooooo`04ool10001ool003;oo`03
003ooooo00Coo`03003ooooo0=_oo`03003ooooo00Coo`40007oo`00<_oo00<00?ooool01?oo00<0
0?ooool0fooo0P001Ooo0@000Ooo000bool00`00ooooo`03ool00`00ooooo`3Lool20005ool10001
ool003;oo`03003ooooo00?oo`03003ooooo0=coo`8000Goo`40007oo`00<_oo00<00?ooool00ooo
00<00?ooool0gOoo00<00?ooool00_oo0P000Ooo000bool00`00ooooo`03ool00`00ooooo`3Mool0
0`00ooooo`03ool10001ool003;oo`03003ooooo00;oo`03003ooooo0=koo`03003ooooo00?oo`40
007oo`00<_oo00<00?ooool00_oo00<00?ooool0g_oo0P001?oo0@000Ooo000bool00`00ooooo`02
ool00`00ooooo`3Nool20004ool10001ool003;oo`03003ooooo00;oo`03003ooooo0=ooo`03003o
oooo00;oo`40007oo`00:_oo10001?oo00<00?ooool00_oo00<00?ooool0gooo00<00?ooool00_oo
0@000Ooo000/ool00`00ooooo`03ool00`00ooooo`02ool00`00ooooo`3Oool00`00ooooo`02ool1
0001ool002coo`03003ooooo00?oo`8000?oo`03003ooooo0=ooo`04003oooooool20001ool002co
o`03003ooooo00?oo`03003ooooo00;oo`03003ooooo0=ooo`03003ooooo00;oo`40007oo`00;?oo
00<00?ooool00ooo00<00?ooool00_oo00<00?ooool0gooo00<00?ooool00_oo0@000Ooo000Zool3
0005ool00`00ooooo`02ool00`00ooooo`3Oool00`00ooooo`02ool10001ool002coo`03003ooooo
00?oo`03003ooooo00;oo`03003ooooo0=ooo`03003ooooo00;oo`40007oo`00<_oo00<00?ooool0
0_oo00<00?ooool0g_oo0P001?oo0@000Ooo000bool00`00ooooo`02ool00`00ooooo`3Nool20004
ool10001ool003;oo`03003ooooo00;oo`03003ooooo0=koo`03003ooooo00?oo`40007oo`00<_oo
00<00?ooool00_oo00<00?ooool0g_oo00<00?ooool00ooo0@000Ooo0007ool30004ool00`00oooo
o`05ool00`00ooooo`0Iool00`00ooooo`03ool00`00ooooo`3Mool00`00ooooo`02ool20001ool0
00Ooo`03003ooooo00?oo`03003ooooo00Ooo`03003ooooo01Soo`03003ooooo00?oo`03003ooooo
0=goo`03003ooooo00?oo`40007oo`000_oo0`000ooo00<00?ooool00_oo00<00?ooool00`001?oo
00<00?ooool06?oo00<00?ooool00ooo00<00?ooool0g?oo0P001Ooo0@000Ooo0003ool00`00oooo
o`03ool01@00oooooooo00000ooo00<00?ooool00ooo00<00?ooool06?oo00<00?ooool00ooo00<0
0?ooool0g?oo00<00?ooool01?oo0@000Ooo0004ool00`00ooooo`030003ool01@00oooooooo0000
1Ooo00<00?ooool06?oo00<00?ooool00ooo0P00gOoo00<00?ooool01?oo0@000Ooo0004ool20007
ool00`00ooooo`02ool00`00ooooo`02ool00`00ooooo`0Hool00`00ooooo`03ool2003Mool00`00
ooooo`04ool10001ool000Coo`03003oo`0000Koo`03003ooooo00;oo`03003ooooo00;oo`03003o
oooo01Soo`03003ooooo00Coo`03003ooooo0=[oo`8000Koo`40007oo`001?oo00@00?ooool000Go
o`04003ooooo0002ool01@00ool00?oo00006_oo00<00?ooool01?oo00<00?ooool0f_oo0P001_oo
0@000Ooo0003ool300000ooo00000005ool00`00ooooo`06000Kool00`00ooooo`04ool00`00oooo
o`3Jool00`00ooooo`04ool20001ool003;oo`03003ooooo00Coo`03003ooooo0=Woo`8000Ooo`40
007oo`00<_oo00<00?ooool01Ooo00<00?ooool0f?oo00<00?ooool01_oo0@000Ooo000bool00`00
ooooo`05ool00`00ooooo`3Gool20008ool10001ool003;oo`03003ooooo00Goo`03003ooooo0=Oo
o`03003ooooo00Ooo`40007oo`00<_oo00<00?ooool01Ooo0P00eooo00<00?ooool02?oo0@000Ooo
000bool00`00ooooo`06ool00`00ooooo`3Eool00`00ooooo`08ool10001ool003;oo`03003ooooo
00Koo`03003ooooo0=Coo`8000[oo`40007oo`00<_oo00<00?ooool01_oo0P00eOoo00<00?ooool0
2Ooo0@000Ooo000bool00`00ooooo`07ool00`00ooooo`3Bool2000:ool20001ool003;oo`03003o
oooo00Ooo`03003ooooo0=;oo`03003ooooo00[oo`40007oo`00<_oo00<00?ooool01ooo0P00d_oo
0P003?oo0@000Ooo000bool00`00ooooo`08ool00`00ooooo`3?ool2000=ool10001ool003;oo`03
003ooooo00Soo`03003ooooo0<ooo`8000goo`40007oo`00<_oo00<00?ooool02?oo0P00cooo0P00
3_oo0@000Ooo000bool00`00ooooo`09ool00`00ooooo`3=ool00`00ooooo`0=ool10001ool001ko
o`@000?oo`03003ooooo00;oo`@000Coo`03003ooooo00Woo`03003ooooo0<coo`8000ooo`40007o
o`008?oo00<00?ooool01ooo00<00?ooool01Ooo00<00?ooool02_oo00<00?ooool0booo00<00?oo
ool03_oo0@000Ooo000Pool00`00ooooo`08ool00`00ooooo`04ool2000;ool00`00ooooo`3:ool0
0`00ooooo`0>ool20001ool0023oo`03003ooooo00Woo`03003ooooo00?oo`03003ooooo00[oo`80
0<[oo`03003ooooo013oo`40007oo`008?oo00<00?ooool02_oo00<00?ooool00_oo00<00?ooool0
2ooo00<00?ooool0aooo0P004_oo0@000Ooo000Nool30009ool01000ooooo`001?oo00<00?ooool0
2ooo0P00aooo0P004ooo0@000Ooo000Pool00`00ooooo`08ool20005ool00`00ooooo`0<ool00`00
ooooo`34ool2000Dool10001ool003;oo`03003ooooo00coo`800<Coo`8001Goo`40007oo`00<_oo
00<00?ooool03Ooo0P00`_oo00<00?oo00005Ooo0@000Ooo000bool00`00ooooo`0>ool00`00oooo
o`2oool00`00ool0000Fool10001ool003;oo`03003ooooo00ooo`03003ooooo0;goo`03003oo`00
01Koo`80007oo`00<_oo00<00?ooool03ooo00<00?ooool0_?oo00<00?oo00006?oo0@000Ooo000b
ool00`00ooooo`0@ool00`00ooooo`2jool01000ooooo`006?oo0@000Ooo000bool00`00ooooo`0@
ool2002jool01000ooooo`006Ooo0@000Ooo000bool00`00ooooo`0Aool2002hool01000ooooo`00
6_oo0@000Ooo000bool00`00ooooo`0Bool00`00ooooo`2eool01000ool000006ooo0@000Ooo000b
ool00`00ooooo`0Bool2002fool2000Mool10001ool003;oo`03003ooooo01?oo`800;Coo`8001ko
o`40007oo`00<_oo00<00?ooool04ooo0P00/ooo0P007ooo0@000Ooo000bool00`00ooooo`0Dool2
002aool2000Oool20001ool003;oo`03003ooooo01Coo`03003oo`000:ooo`80027oo`40007oo`00
<_oo00<00?ooool05Ooo00<00?oo0000[Ooo00<00?ooool08Ooo0@000Ooo000bool00`00ooooo`0F
ool2002/ool00`00ooooo`0Rool10001ool003;oo`03003ooooo01Ooo`800:[oo`03003ooooo02?o
o`40007oo`00<_oo00<00?ooool06?oo0P00Z?oo00<00?ooool09?oo0@000Ooo000bool00`00oooo
o`0Iool2002Uool2000Wool10001ool003;oo`03003ooooo01[oo`03003ooooo0:;oo`8002Soo`40
007oo`00<_oo00<00?ooool06ooo00<00?ooool0X?oo0P00:?oo0P000Ooo000bool00`00ooooo`0L
ool00`00ooooo`2Nool2000Zool10001ool003;oo`03003ooooo01goo`8009goo`8002_oo`40007o
o`00<_oo00<00?ooool07_oo0P00V_oo0`00;?oo0@000Ooo000bool00`00ooooo`0Pool00`00oooo
o`2Fool3000]ool10001ool003;oo`03003ooooo027oo`03003ooooo09Coo`8002ooo`40007oo`00
<_oo00<00?ooool08_oo00<00?ooool0TOoo0P00<Ooo0@000Ooo000Nool40003ool00`00ooooo`04
ool00`00ooooo`03ool00`00ooooo`0Sool2002?ool3000bool10001ool0023oo`03003ooooo00Wo
o`03003ooooo00?oo`03003ooooo02Coo`8008goo`<003?oo`40007oo`008?oo00<00?ooool01_oo
1@001?oo0P009_oo0P00R_oo0`00=?oo0P000Ooo000Pool00`00ooooo`06ool01000ooooo`001Ooo
00<00?ooool09_oo0P00Qooo1000=_oo0@000Ooo000Pool00`00ooooo`07ool00`00ool00005ool0
0`00ooooo`0Wool30023ool4000hool10001ool001koo`<000[oo`8000Goo`03003ooooo02Soo`03
003oo`00083oo`@003[oo`40007oo`008?oo00<00?ooool02Ooo00<00?ooool00ooo00<00?ooool0
:Ooo0`00OOoo1000??oo0@000Ooo000bool00`00ooooo`0[ool2001kool2000oool10001ool003;o
o`03003ooooo02goo`8007Ooo`80047oo`40007oo`00<_oo00<00?ooool0;_oo0`00Looo0P00@ooo
0@000Ooo000bool00`00ooooo`0`ool3001^ool30015ool10001ool003;oo`03003ooooo037oo`@0
06[oo`<004Koo`80007oo`00<_oo00<00?ooool0<ooo0`00Iooo0`00BOoo0@000Ooo000bool00`00
ooooo`0eool3001Rool5001:ool10001ool003;oo`03003ooooo03Soo`8005koo`800003ool00000
04coo`40007oo`00<_oo00<00?ooool0>_oo0`00FOoo0P0000?oo`000000C_oo0@000Ooo000bool0
0`00ooooo`0lool3001Eool200000ooo0000001@ool10001ool003;oo`03003ooooo03koo`@004oo
o`<00003ool0000005;oo`40007oo`00<_oo00<00?ooool0@?oo1@00B_oo1P00E?oo0@000Ooo000b
ool00`00ooooo`12ool200000ooo00000016ool4001Gool20001ool003;oo`03003ooooo04Coo`80
0004ool00000000oool4001Lool10001ool003;oo`03003ooooo04Koo`H003Soo`D0063oo`40007o
o`00<_oo00<00?ooool0B_oo1P00;ooo1P00I?oo0@000Ooo000bool00`00ooooo`1>ool6000Vool7
001Xool10001ool003;oo`03003ooooo05;oo`H001_oo`X006coo`40007oo`00<_oo00<00?ooool0
F?oo7000MOoo0@000Ooo000bool00`00ooooo`3Yool10001ool003;oo`03003ooooo0>Woo`40007o
o`00<_oo00<00?oo00002?oo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01Ooo00<00?ooool01_oo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01_oo00<00?ooool01Ooo00<00?oo
ool01_oo00<00?ooool01Ooo00<00?ooool01_oo0P000Ooo000booo]0001ool00?ooob7oo`00oooo
8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {203.188, 0}} -> {1.09343, 0.414941, \
0.00580142, 0.00580142}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Splitting", "Section",
  CellTags->"s:5"],

Cell[TextData[{
  "Another approach for obtaining the correct qualitative behavior is to \
additively split (",
  
  CounterBox["NumberedEquation", "LotkaVolterraSystem"],
  ") into two systems"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\(Y\_1\)\& . \), 
            "=", \(Y\_1\ \((Y\_2\  - \ 1\ )\)\), \(\(Y\_2\)\& . \), "=", 
            "0"},
          {\(\(Y\_1\)\& . \), "=", "0", \(\(Y\_2\)\& . \), 
            "=", \(Y\_2\ \((2\  - \ Y\_1)\)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"LotkaVolterraSplitting"],

Cell[TextData[{
  "By appropriately solving (",
  
  CounterBox["NumberedEquation", "LotkaVolterraSplitting"],
  ") it is possible to construct Poisson integrators."
}], "Text"],

Cell["\<\
Define the coefficients and equations required for a first-order \
splitting of the Lotka-Volterra equations.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(\(TrotterSplittingCoefficients[1, \ p_] := \ 
        N[{1, 1}, \ p];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(eqs\  = \ system["\<System\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(Y1\  = \ eqs;\)\), "\[IndentingNewLine]", 
    \(\(Part[Y1, \ 2, \ 2]\  = \ 0;\)\), "\[IndentingNewLine]", 
    \(\(Y2\  = \ eqs;\)\), "\[IndentingNewLine]", 
    \(\(Part[Y2, 1, \ 2]\  = \ 0;\)\)}], "Input",
  CellLabel->"In[24]:="],

Cell[CellGroupData[{

Cell["Symplectic Euler", "Subsection"],

Cell[TextData[{
  "Define the symplectic Euler method in terms of a splitting method using \
the backward and forward Euler methods for each system in (",
  
  CounterBox["NumberedEquation", "LotkaVolterraSplitting"],
  ")."
}], "MathCaption"],

Cell[BoxData[{
    \(\(\(SymplecticEuler = \ {"\<Splitting\>", "\<Coefficients\>" -> 
            TrotterSplittingCoefficients, \[IndentingNewLine]\ \
"\<DifferenceOrder\>" \[Rule] 
            1, "\<Equations\>" \[Rule] {Y1, 
              Y2}, \ "\<Method\>" \[Rule] {BackwardEuler, \
"\<ExplicitEuler\>"}};\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(sesol\  = \ 
        NDSolve[system, Method \[Rule] SymplecticEuler, 
          StartingStepSize \[Rule] step];\)\)}], "Input",
  CellLabel->"In[30]:="],

Cell["\<\
The numerical solution using the symplectic Euler method is \
periodic.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(LotkaVolterraPlot[sesol, \ vars, \ time];\)\)], "Input",
  CellLabel->"In[32]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70925 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.979064 0.716316 -0.411217 0.716316 [
[.02378 -0.0125 -9 -9 ]
[.02378 -0.0125 9 0 ]
[.16704 -0.0125 -9 -9 ]
[.16704 -0.0125 9 0 ]
[.3103 -0.0125 -9 -9 ]
[.3103 -0.0125 9 0 ]
[.45357 -0.0125 -3 -9 ]
[.45357 -0.0125 3 0 ]
[.59683 -0.0125 -9 -9 ]
[.59683 -0.0125 9 0 ]
[.74009 -0.0125 -9 -9 ]
[.74009 -0.0125 9 0 ]
[.88336 -0.0125 -9 -9 ]
[.88336 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -13.8125 -19.9375 ]
[.5 -0.0125 13.8125 -9 ]
[-0.0125 .01857 -18 -4.5 ]
[-0.0125 .01857 0 4.5 ]
[-0.0125 .16184 -18 -4.5 ]
[-0.0125 .16184 0 4.5 ]
[-0.0125 .3051 -6 -4.5 ]
[-0.0125 .3051 0 4.5 ]
[-0.0125 .44836 -18 -4.5 ]
[-0.0125 .44836 0 4.5 ]
[-0.0125 .59163 -18 -4.5 ]
[-0.0125 .59163 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .35462 -45.625 -5.46875 ]
[-0.01875 .35462 -18 5.46875 ]
[ 0 .70925 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .70925 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02378 0 m
.02378 .00625 L
s
[(1.4)] .02378 -0.0125 0 1 Mshowa
.16704 0 m
.16704 .00625 L
s
[(1.6)] .16704 -0.0125 0 1 Mshowa
.3103 0 m
.3103 .00625 L
s
[(1.8)] .3103 -0.0125 0 1 Mshowa
.45357 0 m
.45357 .00625 L
s
[(2)] .45357 -0.0125 0 1 Mshowa
.59683 0 m
.59683 .00625 L
s
[(2.2)] .59683 -0.0125 0 1 Mshowa
.74009 0 m
.74009 .00625 L
s
[(2.4)] .74009 -0.0125 0 1 Mshowa
.88336 0 m
.88336 .00625 L
s
[(2.6)] .88336 -0.0125 0 1 Mshowa
.125 Mabswid
.05959 0 m
.05959 .00375 L
s
.09541 0 m
.09541 .00375 L
s
.13123 0 m
.13123 .00375 L
s
.20286 0 m
.20286 .00375 L
s
.23867 0 m
.23867 .00375 L
s
.27449 0 m
.27449 .00375 L
s
.34612 0 m
.34612 .00375 L
s
.38194 0 m
.38194 .00375 L
s
.41775 0 m
.41775 .00375 L
s
.48938 0 m
.48938 .00375 L
s
.5252 0 m
.5252 .00375 L
s
.56101 0 m
.56101 .00375 L
s
.63265 0 m
.63265 .00375 L
s
.66846 0 m
.66846 .00375 L
s
.70428 0 m
.70428 .00375 L
s
.77591 0 m
.77591 .00375 L
s
.81173 0 m
.81173 .00375 L
s
.84754 0 m
.84754 .00375 L
s
.91917 0 m
.91917 .00375 L
s
.95499 0 m
.95499 .00375 L
s
.9908 0 m
.9908 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -74.8125 -23.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
0 .01857 m
.00625 .01857 L
s
[(0.6)] -0.0125 .01857 1 0 Mshowa
0 .16184 m
.00625 .16184 L
s
[(0.8)] -0.0125 .16184 1 0 Mshowa
0 .3051 m
.00625 .3051 L
s
[(1)] -0.0125 .3051 1 0 Mshowa
0 .44836 m
.00625 .44836 L
s
[(1.2)] -0.0125 .44836 1 0 Mshowa
0 .59163 m
.00625 .59163 L
s
[(1.4)] -0.0125 .59163 1 0 Mshowa
.125 Mabswid
0 .05439 m
.00375 .05439 L
s
0 .0902 m
.00375 .0902 L
s
0 .12602 m
.00375 .12602 L
s
0 .19765 m
.00375 .19765 L
s
0 .23347 m
.00375 .23347 L
s
0 .26928 m
.00375 .26928 L
s
0 .34091 m
.00375 .34091 L
s
0 .37673 m
.00375 .37673 L
s
0 .41255 m
.00375 .41255 L
s
0 .48418 m
.00375 .48418 L
s
0 .51999 m
.00375 .51999 L
s
0 .55581 m
.00375 .55581 L
s
0 .62744 m
.00375 .62744 L
s
0 .66326 m
.00375 .66326 L
s
0 .69907 m
.00375 .69907 L
s
.25 Mabswid
0 0 m
0 .70925 L
s
gsave
-0.01875 .35462 -106.625 -9.46875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
.02378 .703 m
.02378 .70925 L
s
.16704 .703 m
.16704 .70925 L
s
.3103 .703 m
.3103 .70925 L
s
.45357 .703 m
.45357 .70925 L
s
.59683 .703 m
.59683 .70925 L
s
.74009 .703 m
.74009 .70925 L
s
.88336 .703 m
.88336 .70925 L
s
.125 Mabswid
.05959 .7055 m
.05959 .70925 L
s
.09541 .7055 m
.09541 .70925 L
s
.13123 .7055 m
.13123 .70925 L
s
.20286 .7055 m
.20286 .70925 L
s
.23867 .7055 m
.23867 .70925 L
s
.27449 .7055 m
.27449 .70925 L
s
.34612 .7055 m
.34612 .70925 L
s
.38194 .7055 m
.38194 .70925 L
s
.41775 .7055 m
.41775 .70925 L
s
.48938 .7055 m
.48938 .70925 L
s
.5252 .7055 m
.5252 .70925 L
s
.56101 .7055 m
.56101 .70925 L
s
.63265 .7055 m
.63265 .70925 L
s
.66846 .7055 m
.66846 .70925 L
s
.70428 .7055 m
.70428 .70925 L
s
.77591 .7055 m
.77591 .70925 L
s
.81173 .7055 m
.81173 .70925 L
s
.84754 .7055 m
.84754 .70925 L
s
.91917 .7055 m
.91917 .70925 L
s
.95499 .7055 m
.95499 .70925 L
s
.9908 .7055 m
.9908 .70925 L
s
.25 Mabswid
0 .70925 m
1 .70925 L
s
.99375 .01857 m
1 .01857 L
s
.99375 .16184 m
1 .16184 L
s
.99375 .3051 m
1 .3051 L
s
.99375 .44836 m
1 .44836 L
s
.99375 .59163 m
1 .59163 L
s
.125 Mabswid
.99625 .05439 m
1 .05439 L
s
.99625 .0902 m
1 .0902 L
s
.99625 .12602 m
1 .12602 L
s
.99625 .19765 m
1 .19765 L
s
.99625 .23347 m
1 .23347 L
s
.99625 .26928 m
1 .26928 L
s
.99625 .34091 m
1 .34091 L
s
.99625 .37673 m
1 .37673 L
s
.99625 .41255 m
1 .41255 L
s
.99625 .48418 m
1 .48418 L
s
.99625 .51999 m
1 .51999 L
s
.99625 .55581 m
1 .55581 L
s
.99625 .62744 m
1 .62744 L
s
.99625 .66326 m
1 .66326 L
s
.99625 .69907 m
1 .69907 L
s
.25 Mabswid
1 0 m
1 .70925 L
s
0 0 m
1 0 L
1 .70925 L
0 .70925 L
closepath
clip
newpath
.5 Mabswid
.9729 .3051 m
.97309 .29868 L
.97357 .29218 L
.97491 .27908 L
.9755 .27255 L
.97586 .26608 L
.97586 .25971 L
.97538 .25347 L
.97427 .24739 L
.97245 .24151 L
.969 .2299 L
.96266 .20715 L
.93516 .16295 L
.89591 .12519 L
.80044 .07148 L
.69028 .03833 L
.56399 .01994 L
.53518 .01842 L
.52044 .01749 L
.51314 .01718 L
.50596 .01702 L
.49886 .01699 L
.49182 .01705 L
.48481 .01717 L
.47783 .01732 L
.44972 .01766 L
.39123 .02208 L
.33577 .03003 L
.23761 .05552 L
.16108 .09137 L
.09555 .14399 L
.05219 .20565 L
.03823 .2403 L
.03262 .25862 L
.02914 .27777 L
.02543 .29885 L
.02492 .3043 L
.02471 .30988 L
.02478 .31556 L
.02474 .32118 L
.02441 .33231 L
.02427 .33788 L
.02423 .34349 L
.02436 .34917 L
.02473 .35496 L
.02643 .36693 L
.03378 .41097 L
.0481 .45614 L
.10365 .55268 L
.19339 .63394 L
Mistroke
.24764 .66178 L
.27814 .6729 L
.31021 .68072 L
.3472 .68877 L
.36666 .69014 L
.3865 .6907 L
.40645 .69149 L
.41643 .6922 L
.42667 .69231 L
.43717 .69176 L
.44788 .69069 L
.46958 .68756 L
.55065 .67231 L
.63258 .64466 L
.79941 .54782 L
.92019 .42593 L
.95338 .36834 L
.96411 .34005 L
.97094 .31284 L
.97451 .29793 L
.97568 .29063 L
.97619 .28352 L
.97588 .27664 L
.97492 .26997 L
.9738 .25656 L
.97094 .23022 L
.96076 .20594 L
.93648 .16448 L
.90164 .12899 L
.8088 .07505 L
.68921 .03781 L
.57242 .02088 L
.54037 .01827 L
.52488 .0178 L
.50949 .01754 L
.49394 .01717 L
.48609 .01693 L
.47836 .01689 L
.47075 .01702 L
.46322 .01728 L
.44833 .01803 L
.41917 .01941 L
.3908 .02207 L
.33639 .0296 L
.24454 .05305 L
.16059 .09169 L
.09918 .1401 L
.05574 .19967 L
.03925 .23671 L
.03368 .25654 L
Mistroke
.02855 .27693 L
.02643 .29702 L
.02524 .30705 L
.02422 .31717 L
.02391 .32232 L
.02381 .32756 L
.02397 .33291 L
.02442 .33837 L
.02565 .35978 L
.03366 .40784 L
.04897 .45696 L
.0985 .54624 L
.17897 .62378 L
.23598 .65676 L
.30219 .68021 L
.33631 .68579 L
.35388 .68822 L
.37173 .69116 L
.38093 .69202 L
.39031 .69236 L
.39984 .69229 L
.40948 .69191 L
.4289 .69068 L
.44827 .68958 L
.49117 .68546 L
.53618 .67493 L
.62575 .64637 L
.78953 .5555 L
.90581 .44374 L
.94767 .38004 L
.96017 .34975 L
.97105 .31894 L
.97355 .29248 L
.97512 .27918 L
.97574 .27258 L
.97606 .26604 L
.97596 .25963 L
.97529 .25336 L
.97204 .24136 L
.96613 .21794 L
.94412 .17587 L
.91238 .1392 L
.81698 .07847 L
.70634 .04189 L
.57824 .0204 L
.57432 .01995 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[32]:=",
  ImageSize->{288, 204.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000c1000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
X_oo0`001?oo00<00?ooool01Ooo00<00?ooool0K?oo002Sool00`00ooooo`02ool00`00ooooo`07
ool00`00ooooo`1[ool009coo`<000Coo`03003ooooo00;oo`03003oo`00008000Goo`03003ooooo
06_oo`00WOoo00<00?ooool00ooo00<00?ooool00_oo00@00?ooool000Koo`03003ooooo06_oo`00
W_oo00<00?ooool00_oo00<00?ooool00_oo00@00?ooool000Koo`03003ooooo06_oo`00W_oo0P00
2?oo00D00?ooooooo`0000Goo`03003ooooo06_oo`00W_oo00<00?oo00001ooo00D00?ooooooo`00
00Goo`03003ooooo06_oo`00W_oo00@00?ooool000Koo`03003oo`0000;oo`03003oo`0000;oo`03
003ooooo06_oo`00WOoo0`0000?oo`0000001_oo00<00?oo00001P00K_oo003ooolQool002ooo`@0
00?oo`03003ooooo00Coo`03003ooooo017oo`@000?oo`03003ooooo00?oo`8001?oo`@000?oo`03
003ooooo00?oo`8001Woo`@001Soo`@000?oo`03003ooooo00;oo`@001;oo`@000?oo`03003ooooo
00Coo`03003ooooo017oo`@000?oo`03003ooooo00?oo`8001Koo`00<Ooo00<00?ooool02Ooo00<0
0?ooool04ooo00<00?ooool01ooo00@00?ooool001Coo`03003ooooo00Ooo`04003ooooo000Hool0
0`00ooooo`0Iool00`00ooooo`09ool00`00ooooo`0Cool00`00ooooo`0;ool00`00ooooo`0Aool0
0`00ooooo`09ool01000ooooo`005Ooo000aool00`00ooooo`06ool5000Dool00`00ooooo`07ool0
1000ooooo`005?oo00<00?ooool01ooo00@00?ooool001Woo`03003ooooo01Woo`03003ooooo00Wo
o`03003ooooo01?oo`03003ooooo00Ooo`D001?oo`03003ooooo00Soo`04003ooooo000Eool0037o
o`03003ooooo00Koo`04003ooooo000Eool00`00ooooo`07ool3000Eool00`00ooooo`08ool2000K
ool00`00ooooo`0Iool00`00ooooo`09ool00`00ooooo`0Cool00`00ooooo`06ool01000ooooo`00
5Ooo00<00?ooool01ooo0`005_oo000aool00`00ooooo`07ool00`00ool0000Eool00`00ooooo`07
ool00`00ooooo`0Eool00`00ooooo`07ool01000ooooo`006ooo00<00?ooool06Ooo00<00?ooool0
2Ooo00<00?ooool04ooo00<00?ooool01_oo00<00?oo00005_oo00<00?ooool01_oo00<00?ooool0
5_oo000_ool3000:ool2000Cool30009ool00`00ooooo`0Cool30009ool01000ooooo`006?oo00@0
0?ooool001Soo`04003ooooo0008ool01000ooooo`004_oo00@00?ooool000Woo`8001?oo`04003o
oooo0008ool00`00ooooo`0Fool0037oo`03003ooooo00Woo`03003ooooo01?oo`03003ooooo00So
o`<001Coo`03003ooooo00Soo`8001[oo`8001[oo`8000[oo`8001Coo`8000_oo`03003ooooo01;o
o`8000[oo`<001Goo`00oooo8Ooo003ooolQool00?ooob7oo`00<_ook@000Ooo000bool00`00oooo
o`02ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`05ool00`00oooo
o`06ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`06ool00`00oooo
o`05ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`06ool00`00oooo
o`05ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`05ool00`00oooo
o`06ool00`00ooooo`05ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`06ool00`00oooo
o`05ool00`00ooooo`06ool00`00ooooo`05ool00`00ool00001ool003;oo`03003ooooo00;oo`03
003ooooo01ooo`03003ooooo01ooo`03003ooooo01ooo`03003ooooo01ooo`03003ooooo01ooo`03
003ooooo01ooo`03003ooooo01Soo`40007oo`007ooo0P001?oo00<00?ooool00ooo0P001Ooo00<0
0?ooool0jOoo0@000Ooo000Nool01000ooooo`002?oo00@00?ooool000Coo`03003ooooo06Wooa40
06ooo`40007oo`007_oo00@00?ooool000Soo`04003ooooo0004ool2001Nool>000<oolB001Oool2
0001ool001koo`04003ooooo0008ool30005ool00`00ooooo`1Cool=000Vool9001Jool10001ool0
01koo`04003ooooo0008ool00`00ooooo`05ool00`00ooooo`1;ool8000kool8001Cool10001ool0
01koo`04003ooooo0008ool00`00ooooo`05ool00`00ooooo`17ool4001:ool8001<ool10001ool0
01ooo`8000[oo`<000Coo`03003ooooo04?oo`@005Coo`L004Ooo`40007oo`00<_oo00<00?ooool0
?ooo1000G_oo1@00@ooo0@000Ooo000bool00`00ooooo`0kool5001Uool40010ool10001ool003;o
o`03003ooooo03Ooo`D006coo`@003goo`40007oo`00<_oo00<00?ooool0=?oo1000Looo1000>Ooo
0P000Ooo000bool00`00ooooo`0bool3001iool4000gool10001ool003;oo`03003ooooo033oo`<0
07koo`D003?oo`40007oo`00<_oo00<00?ooool0;_oo0`00Pooo1@00<?oo0@000Ooo000bool00`00
ooooo`0/ool30028ool4000^ool10001ool003;oo`03003ooooo02[oo`<008goo`<002coo`40007o
o`00<_oo00<00?ooool0:?oo0`00T_oo0P00:_oo0@000Ooo000bool00`00ooooo`0Vool3002Fool2
000Xool10001ool003;oo`03003ooooo02Coo`<009[oo`8002Koo`40007oo`00<_oo00<00?ooool0
8ooo0P00WOoo0P009?oo0P000Ooo000bool00`00ooooo`0Qool2002Qool2000Sool10001ool003;o
o`03003ooooo023oo`800:Coo`80027oo`40007oo`00<_oo00<00?ooool07ooo00<00?ooool0YOoo
0`007ooo0@000Ooo000bool00`00ooooo`0Mool2002Zool2000Nool10001ool003;oo`03003ooooo
01coo`800:goo`8001coo`40007oo`00<_oo00<00?ooool06ooo0P00[ooo0`006_oo0@000Ooo000b
ool00`00ooooo`0Iool2002cool3000Hool10001ool003;oo`03003ooooo01Soo`800;Koo`8001Ko
o`80007oo`00<_oo00<00?ooool05ooo0P00^?oo0P005_oo0@000Ooo000bool00`00ooooo`0Eool3
002kool2000Dool10001ool003;oo`03003ooooo01Coo`800;koo`8001?oo`40007oo`00<_oo00<0
0?ooool04ooo0P00`?oo0P004_oo0@000Ooo000bool00`00ooooo`0Bool20032ool2000Aool10001
ool003;oo`03003ooooo01;oo`800<?oo`03003ooooo00ooo`40007oo`007ooo0P001?oo00<00?oo
ool00ooo0P001Ooo00<00?ooool04Ooo0P00aOoo00<00?ooool03_oo0@000Ooo000Nool01000oooo
o`002?oo00@00?ooool000Coo`03003ooooo013oo`800<Ooo`03003ooooo00goo`40007oo`007_oo
00@00?ooool000Soo`04003ooooo0004ool2000Aool00`00ooooo`37ool00`00ooooo`0;ool20001
ool001koo`04003ooooo0009ool20005ool00`00ooooo`0?ool20039ool2000=ool10001ool001ko
o`04003ooooo0008ool01000ooooo`001?oo00<00?ooool03_oo0P00booo00<00?ooool02ooo0@00
0Ooo000Nool01000ooooo`002?oo00@00?ooool000Coo`03003ooooo00koo`03003ooooo0<_oo`03
003ooooo00[oo`40007oo`007ooo0P002_oo0P001Ooo00<00?ooool03Ooo0P00cOoo0P002ooo0@00
0Ooo000bool00`00ooooo`0<ool2003?ool00`00ooooo`09ool10001ool003;oo`03003ooooo00co
o`03003ooooo0<koo`8000[oo`40007oo`00<_oo00<00?ooool02ooo00<00?ooool0d?oo0P002Ooo
0@000Ooo000bool00`00ooooo`0:ool2003Bool30007ool20001ool003;oo`03003ooooo00[oo`03
003ooooo0=;oo`8000Soo`40007oo`00<_oo00<00?ooool02Ooo0P00e?oo0`001ooo0@000Ooo000b
ool00`00ooooo`09ool00`00ooooo`3Dool20007ool10001ool003;oo`03003ooooo00Soo`800=Ko
o`8000Ooo`40007oo`00<_oo00<00?ooool02?oo00<00?ooool0e_oo00<00?ooool01Ooo0@000Ooo
000bool00`00ooooo`08ool00`00ooooo`3Fool20006ool10001ool003;oo`03003ooooo00Ooo`03
003ooooo0=Soo`03003ooooo00Coo`40007oo`00<_oo00<00?ooool01ooo00<00?ooool0f?oo00<0
0?ooool01?oo0@000Ooo000bool00`00ooooo`06ool00`00ooooo`3Iool20004ool20001ool003;o
o`03003ooooo00Koo`03003ooooo0=Woo`8000Goo`40007oo`00<_oo00<00?ooool01_oo00<00?oo
ool0fOoo0P001Ooo0@000Ooo000bool00`00ooooo`05ool00`00ooooo`3Kool20004ool10001ool0
03;oo`03003ooooo00Goo`03003ooooo0=_oo`8000Coo`40007oo`00<_oo00<00?ooool01?oo0P00
gOoo0P001?oo0@000Ooo000bool00`00ooooo`04ool2003Mool20004ool10001ool003;oo`03003o
oooo00Coo`03003ooooo0=coo`8000Coo`40007oo`00<_oo00<00?ooool01?oo00<00?ooool0g?oo
0P000ooo0P000Ooo000bool00`00ooooo`03ool00`00ooooo`3Mool20004ool10001ool003;oo`03
003ooooo00?oo`03003ooooo0=goo`8000Coo`40007oo`00<_oo00<00?ooool00ooo00<00?ooool0
gOoo0P001?oo0@000Ooo000bool00`00ooooo`03ool00`00ooooo`3Mool20004ool10001ool003;o
o`03003ooooo00?oo`03003ooooo0=goo`8000Coo`40007oo`00<_oo00<00?ooool00ooo00<00?oo
ool0gOoo0P001?oo0@000Ooo000Zool40004ool00`00ooooo`03ool00`00ooooo`3Mool00`00oooo
o`03ool10001ool002coo`03003ooooo00?oo`03003ooooo00;oo`800=ooo`03003ooooo00?oo`40
007oo`00;?oo00<00?ooool00ooo0P000ooo0P00g_oo0P001?oo0P000Ooo000/ool00`00ooooo`03
ool00`00ooooo`02ool2003Nool20005ool10001ool002coo`03003ooooo00?oo`03003ooooo00;o
o`03003ooooo0=goo`8000Goo`40007oo`00:_oo0`001Ooo00<00?ooool00_oo00<00?ooool0gOoo
0P001Ooo0@000Ooo000/ool00`00ooooo`03ool00`00ooooo`02ool00`00ooooo`3Mool20005ool1
0001ool003;oo`03003ooooo00;oo`03003ooooo0=coo`8000Koo`40007oo`00<_oo00<00?ooool0
0_oo00<00?ooool0g?oo0P001_oo0@000Ooo000bool00`00ooooo`02ool00`00ooooo`3Lool00`00
ooooo`05ool10001ool000Ooo`<000Coo`03003ooooo00Goo`03003ooooo01Woo`03003ooooo00;o
o`03003ooooo0=coo`03003ooooo00Coo`80007oo`001ooo00<00?ooool00ooo00<00?ooool01ooo
00<00?ooool06?oo00<00?ooool00_oo00<00?ooool0fooo0P001ooo0@000Ooo0002ool30003ool0
0`00ooooo`02ool00`00ooooo`030004ool00`00ooooo`0Hool00`00ooooo`02ool00`00ooooo`3K
ool00`00ooooo`06ool10001ool000?oo`03003ooooo00?oo`05003oooooool00003ool00`00oooo
o`03ool00`00ooooo`0Hool00`00ooooo`02ool2003Lool00`00ooooo`06ool10001ool000Coo`03
003ooooo00<000?oo`05003oooooool00005ool00`00ooooo`0Hool00`00ooooo`02ool2003Kool0
0`00ooooo`07ool10001ool000Coo`8000Ooo`03003ooooo00;oo`03003ooooo00;oo`03003ooooo
01Soo`03003ooooo00?oo`03003ooooo0=Woo`03003ooooo00Ooo`40007oo`001?oo00<00?oo0000
1_oo00<00?ooool00_oo00<00?ooool00_oo00<00?ooool06?oo00<00?ooool00ooo00<00?ooool0
f?oo00<00?ooool02?oo0@000Ooo0004ool01000ooooo`001Ooo00@00?ooool000;oo`05003oo`00
ool0000Jool00`00ooooo`03ool00`00ooooo`3Hool00`00ooooo`08ool10001ool000?oo`<00003
ool0000000Goo`03003ooooo00H001_oo`03003ooooo00?oo`800=Soo`03003ooooo00Woo`40007o
o`00<_oo00<00?ooool01?oo00<00?ooool0e_oo00<00?ooool02?oo0P000Ooo000bool00`00oooo
o`04ool00`00ooooo`3Eool00`00ooooo`0:ool10001ool003;oo`03003ooooo00Coo`03003ooooo
0=Goo`03003ooooo00[oo`40007oo`00<_oo00<00?ooool01?oo00<00?ooool0e?oo00<00?ooool0
2ooo0@000Ooo000bool00`00ooooo`04ool00`00ooooo`3Cool00`00ooooo`0<ool10001ool003;o
o`03003ooooo00Coo`800=Coo`03003ooooo00coo`40007oo`00<_oo00<00?ooool01Ooo00<00?oo
ool0dOoo00<00?ooool03Ooo0@000Ooo000bool00`00ooooo`05ool00`00ooooo`3@ool00`00oooo
o`0>ool10001ool003;oo`03003ooooo00Goo`03003ooooo0=3oo`03003ooooo00goo`80007oo`00
<_oo00<00?ooool01Ooo00<00?ooool0cooo00<00?ooool03ooo0@000Ooo000bool00`00ooooo`06
ool00`00ooooo`3=ool2000Aool10001ool003;oo`03003ooooo00Koo`03003ooooo0<goo`03003o
oooo013oo`40007oo`00<_oo00<00?ooool01_oo00<00?ooool0c?oo00<00?ooool04Ooo0@000Ooo
000bool00`00ooooo`06ool00`00ooooo`3;ool00`00ooooo`0Bool10001ool003;oo`03003ooooo
00Ooo`03003ooooo0<Woo`8001Coo`40007oo`007_oo10000ooo00<00?ooool00_oo10001?oo00<0
0?ooool01ooo00<00?ooool0b?oo0P005Ooo0@000Ooo000Pool00`00ooooo`07ool00`00ooooo`05
ool00`00ooooo`07ool00`00ooooo`37ool2000Fool10001ool0023oo`03003ooooo00Soo`03003o
oooo00Coo`8000Soo`800<Ooo`8001Koo`80007oo`008?oo00<00?ooool02Ooo00<00?ooool00ooo
00<00?ooool02?oo00<00?ooool0a?oo0P006?oo0@000Ooo000Pool00`00ooooo`0:ool00`00oooo
o`02ool00`00ooooo`08ool20034ool2000Iool10001ool001koo`<000Woo`04003ooooo0004ool0
0`00ooooo`09ool00`00ooooo`31ool2000Jool10001ool0023oo`03003ooooo00Soo`8000Goo`03
003ooooo00Woo`800<7oo`8001_oo`40007oo`00<_oo00<00?ooool02_oo00<00?ooool0__oo0P00
7?oo0@000Ooo000bool00`00ooooo`0:ool2002nool2000Mool10001ool003;oo`03003ooooo00_o
o`03003ooooo0;_oo`8001koo`40007oo`00<_oo00<00?ooool02ooo0P00^ooo0P007_oo0P000Ooo
000bool00`00ooooo`0<ool2002jool00`00ooooo`0Nool10001ool003;oo`03003ooooo00goo`03
003ooooo0;Ooo`03003ooooo01ooo`40007oo`00<_oo00<00?ooool03Ooo0P00]ooo00<00?ooool0
8?oo0@000Ooo000bool00`00ooooo`0>ool00`00ooooo`2dool00`00ooooo`0Qool10001ool003;o
o`03003ooooo00koo`800;Coo`03003ooooo02;oo`40007oo`00<_oo00<00?ooool03ooo00<00?oo
ool0/Ooo00<00?ooool08ooo0@000Ooo000bool00`00ooooo`0?ool2002aool00`00ooooo`0Tool1
0001ool003;oo`03003ooooo013oo`03003ooooo0:koo`03003ooooo02Coo`80007oo`00<_oo00<0
0?ooool04Ooo00<00?ooool0[?oo00<00?ooool09_oo0@000Ooo000bool00`00ooooo`0Aool2002/
ool00`00ooooo`0Wool10001ool003;oo`03003ooooo01;oo`03003ooooo0:Woo`03003ooooo02So
o`40007oo`00<_oo00<00?ooool04_oo0P00ZOoo00<00?ooool0:Ooo0@000Ooo000bool00`00oooo
o`0Cool00`00ooooo`2Vool00`00ooooo`0Zool10001ool003;oo`03003ooooo01?oo`800:Koo`03
003ooooo02_oo`40007oo`00<_oo00<00?ooool05?oo00<00?ooool0Xooo00<00?ooool0;?oo0@00
0Ooo000bool00`00ooooo`0Eool00`00ooooo`2Pool2000_ool10001ool003;oo`03003ooooo01Ko
o`03003ooooo09goo`<002ooo`80007oo`00<_oo00<00?ooool05ooo00<00?ooool0V_oo1000<Ooo
0@000Ooo000bool00`00ooooo`0Hool00`00ooooo`2Hool3000cool10001ool003;oo`03003ooooo
01Woo`03003ooooo09Goo`<003Goo`40007oo`00<_oo00<00?ooool06_oo0P00Tooo0`00=ooo0@00
0Ooo000bool00`00ooooo`0Kool2002@ool3000iool10001ool001koo`@000?oo`03003ooooo00Co
o`03003ooooo00?oo`03003ooooo01coo`8008koo`8003_oo`40007oo`008?oo00<00?ooool02Ooo
00<00?ooool00ooo00<00?ooool07Ooo0P00Rooo0P00?Ooo0@000Ooo000Pool00`00ooooo`06ool5
0004ool2000Pool00`00ooooo`26ool3000mool20001ool0023oo`03003ooooo00Koo`04003ooooo
0005ool00`00ooooo`0Pool00`00ooooo`23ool30010ool10001ool0023oo`03003ooooo00Ooo`03
003oo`0000Goo`03003ooooo027oo`03003ooooo087oo`8004;oo`40007oo`007_oo0`002_oo0P00
1Ooo00<00?ooool08_oo00<00?ooool0O_oo0P00A?oo0@000Ooo000Pool00`00ooooo`09ool00`00
ooooo`03ool00`00ooooo`0Sool00`00ooooo`1kool20016ool10001ool003;oo`03003ooooo02Co
o`8007Woo`8004Soo`40007oo`00<_oo00<00?ooool09Ooo0P00Mooo0P00BOoo0@000Ooo000bool0
0`00ooooo`0Vool2001dool2001;ool10001ool003;oo`03003ooooo02Ooo`80077oo`8004goo`40
007oo`00<_oo00<00?ooool0:?oo0P00K_oo0P00C_oo0P000Ooo000bool00`00ooooo`0Zool2001Z
ool3001@ool10001ool003;oo`03003ooooo02_oo`8006Ooo`<005;oo`40007oo`00<_oo00<00?oo
ool0;Ooo0P00Hooo0`00E?oo0@000Ooo000bool00`00ooooo`0_ool2001Oool3001Fool10001ool0
03;oo`03003ooooo033oo`<005[oo`@005Soo`40007oo`00<_oo00<00?ooool0<_oo0`00EOoo1000
Fooo0@000Ooo000bool00`00ooooo`0dool3001@ool5001Mool10001ool003;oo`03003ooooo03Ko
o`<004_oo`D005ooo`80007oo`00<_oo00<00?ooool0>Ooo0`00AOoo1@00Hooo0@000Ooo000bool0
0`00ooooo`0kool5000nool6001Uool10001ool003;oo`03003ooooo03goo`H003Soo`H006Soo`40
007oo`00<_oo00<00?ooool0@?oo1P00<?oo1P00KOoo0@000Ooo000bool00`00ooooo`14ool7000U
ool7001bool10001ool003;oo`03003ooooo04[oo`T001Ooo`T007Koo`40007oo`00<_oo00<00?oo
ool0DOoo6`00OOoo0@000Ooo000bool00`00ooooo`3Yool10001ool003;oo`03003ooooo0>Soo`80
007oo`00<_oo00<00?ooool00_oo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<0
0?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<0
0?ooool01_oo00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<0
0?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<0
0?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<0
0?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?oo00000Ooo000b
ooo]0001ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00001
\
\>"],
  ImageRangeCache->{{{0, 287}, {203.25, 0}} -> {1.07165, 0.402545, \
0.00589522, 0.00589522}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Flows", "Subsection"],

Cell[TextData[{
  "Consider splitting the Lotka-Volterra equations and computing the flow (or \
exact solution) of each system in (",
  
  CounterBox["NumberedEquation", "LotkaVolterraSplitting"],
  ")."
}], "Text"],

Cell[TextData[{
  "This has the advantage that it yields an ",
  StyleBox["explicit,",
    FontSlant->"Italic"],
  " and hence very efficient, integration procedure."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox[ButtonBox["LocallyExact",
    ButtonData:>{"LocallyExact.nb", None},
    ButtonStyle->"Hyperlink"], "MR"],
  " method provides a general way of computing the flow of each splitting \
using ",
  StyleBox["DSolve", "MR"],
  " during the initialization phase."
}], "Text"],

Cell[BoxData[{
    \(\(SplittingLotkaVolterra = \ {"\<Splitting\>", "\<Coefficients\>" -> 
            TrotterSplittingCoefficients, \[IndentingNewLine]\ \
"\<DifferenceOrder\>" \[Rule] 
            1, "\<Equations\>" \[Rule] {Y1, 
              Y2}, \ "\<Method\>" \[Rule] {"\<LocallyExact\>", \
"\<LocallyExact\>"}};\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(spsol\  = \ 
        NDSolve[system, Method \[Rule] SplittingLotkaVolterra, 
          StartingStepSize \[Rule] step];\)\)}], "Input",
  CellLabel->"In[33]:="],

Cell["\<\
The numerical solution using the splitting method is \
periodic.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(LotkaVolterraPlot[spsol, \ vars, \ time];\)\)], "Input",
  CellLabel->"In[35]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .70948 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.0001 0.724026 -0.421325 0.724026 [
[.01354 -0.0125 -9 -9 ]
[.01354 -0.0125 9 0 ]
[.15834 -0.0125 -9 -9 ]
[.15834 -0.0125 9 0 ]
[.30315 -0.0125 -9 -9 ]
[.30315 -0.0125 9 0 ]
[.44795 -0.0125 -3 -9 ]
[.44795 -0.0125 3 0 ]
[.59276 -0.0125 -9 -9 ]
[.59276 -0.0125 9 0 ]
[.73756 -0.0125 -9 -9 ]
[.73756 -0.0125 9 0 ]
[.88237 -0.0125 -9 -9 ]
[.88237 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -13.8125 -19.9375 ]
[.5 -0.0125 13.8125 -9 ]
[-0.0125 .01309 -18 -4.5 ]
[-0.0125 .01309 0 4.5 ]
[-0.0125 .1579 -18 -4.5 ]
[-0.0125 .1579 0 4.5 ]
[-0.0125 .3027 -6 -4.5 ]
[-0.0125 .3027 0 4.5 ]
[-0.0125 .44751 -18 -4.5 ]
[-0.0125 .44751 0 4.5 ]
[-0.0125 .59231 -18 -4.5 ]
[-0.0125 .59231 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .35474 -45.625 -5.46875 ]
[-0.01875 .35474 -18 5.46875 ]
[ 0 .70948 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .70948 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01354 0 m
.01354 .00625 L
s
[(1.4)] .01354 -0.0125 0 1 Mshowa
.15834 0 m
.15834 .00625 L
s
[(1.6)] .15834 -0.0125 0 1 Mshowa
.30315 0 m
.30315 .00625 L
s
[(1.8)] .30315 -0.0125 0 1 Mshowa
.44795 0 m
.44795 .00625 L
s
[(2)] .44795 -0.0125 0 1 Mshowa
.59276 0 m
.59276 .00625 L
s
[(2.2)] .59276 -0.0125 0 1 Mshowa
.73756 0 m
.73756 .00625 L
s
[(2.4)] .73756 -0.0125 0 1 Mshowa
.88237 0 m
.88237 .00625 L
s
[(2.6)] .88237 -0.0125 0 1 Mshowa
.125 Mabswid
.04974 0 m
.04974 .00375 L
s
.08594 0 m
.08594 .00375 L
s
.12214 0 m
.12214 .00375 L
s
.19454 0 m
.19454 .00375 L
s
.23074 0 m
.23074 .00375 L
s
.26694 0 m
.26694 .00375 L
s
.33935 0 m
.33935 .00375 L
s
.37555 0 m
.37555 .00375 L
s
.41175 0 m
.41175 .00375 L
s
.48415 0 m
.48415 .00375 L
s
.52035 0 m
.52035 .00375 L
s
.55655 0 m
.55655 .00375 L
s
.62896 0 m
.62896 .00375 L
s
.66516 0 m
.66516 .00375 L
s
.70136 0 m
.70136 .00375 L
s
.77376 0 m
.77376 .00375 L
s
.80996 0 m
.80996 .00375 L
s
.84617 0 m
.84617 .00375 L
s
.91857 0 m
.91857 .00375 L
s
.95477 0 m
.95477 .00375 L
s
.99097 0 m
.99097 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -74.8125 -23.9375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
0 .01309 m
.00625 .01309 L
s
[(0.6)] -0.0125 .01309 1 0 Mshowa
0 .1579 m
.00625 .1579 L
s
[(0.8)] -0.0125 .1579 1 0 Mshowa
0 .3027 m
.00625 .3027 L
s
[(1)] -0.0125 .3027 1 0 Mshowa
0 .44751 m
.00625 .44751 L
s
[(1.2)] -0.0125 .44751 1 0 Mshowa
0 .59231 m
.00625 .59231 L
s
[(1.4)] -0.0125 .59231 1 0 Mshowa
.125 Mabswid
0 .04929 m
.00375 .04929 L
s
0 .08549 m
.00375 .08549 L
s
0 .12169 m
.00375 .12169 L
s
0 .1941 m
.00375 .1941 L
s
0 .2303 m
.00375 .2303 L
s
0 .2665 m
.00375 .2665 L
s
0 .3389 m
.00375 .3389 L
s
0 .3751 m
.00375 .3751 L
s
0 .41131 m
.00375 .41131 L
s
0 .48371 m
.00375 .48371 L
s
0 .51991 m
.00375 .51991 L
s
0 .55611 m
.00375 .55611 L
s
0 .62851 m
.00375 .62851 L
s
0 .66471 m
.00375 .66471 L
s
0 .70092 m
.00375 .70092 L
s
.25 Mabswid
0 0 m
0 .70948 L
s
gsave
-0.01875 .35474 -106.625 -9.46875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.9375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.812 moveto
%%IncludeResource: font Times-Italic
%%IncludeFont: Times-Italic
%%BeginResource: font Times-Italic-MISO
%%BeginFont: Times-Italic-MISO
/Times-Italic /Times-Italic-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
68.500 13.375 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
73.938 11.812 moveto
(H) show
77.125 11.812 moveto
%%IncludeResource: font Times-Italic-MISO
%%IncludeFont: Times-Italic-MISO
/Times-Italic-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
83.438 11.812 moveto
(L) show
1.000 setlinewidth
grestore
.01354 .70323 m
.01354 .70948 L
s
.15834 .70323 m
.15834 .70948 L
s
.30315 .70323 m
.30315 .70948 L
s
.44795 .70323 m
.44795 .70948 L
s
.59276 .70323 m
.59276 .70948 L
s
.73756 .70323 m
.73756 .70948 L
s
.88237 .70323 m
.88237 .70948 L
s
.125 Mabswid
.04974 .70573 m
.04974 .70948 L
s
.08594 .70573 m
.08594 .70948 L
s
.12214 .70573 m
.12214 .70948 L
s
.19454 .70573 m
.19454 .70948 L
s
.23074 .70573 m
.23074 .70948 L
s
.26694 .70573 m
.26694 .70948 L
s
.33935 .70573 m
.33935 .70948 L
s
.37555 .70573 m
.37555 .70948 L
s
.41175 .70573 m
.41175 .70948 L
s
.48415 .70573 m
.48415 .70948 L
s
.52035 .70573 m
.52035 .70948 L
s
.55655 .70573 m
.55655 .70948 L
s
.62896 .70573 m
.62896 .70948 L
s
.66516 .70573 m
.66516 .70948 L
s
.70136 .70573 m
.70136 .70948 L
s
.77376 .70573 m
.77376 .70948 L
s
.80996 .70573 m
.80996 .70948 L
s
.84617 .70573 m
.84617 .70948 L
s
.91857 .70573 m
.91857 .70948 L
s
.95477 .70573 m
.95477 .70948 L
s
.99097 .70573 m
.99097 .70948 L
s
.25 Mabswid
0 .70948 m
1 .70948 L
s
.99375 .01309 m
1 .01309 L
s
.99375 .1579 m
1 .1579 L
s
.99375 .3027 m
1 .3027 L
s
.99375 .44751 m
1 .44751 L
s
.99375 .59231 m
1 .59231 L
s
.125 Mabswid
.99625 .04929 m
1 .04929 L
s
.99625 .08549 m
1 .08549 L
s
.99625 .12169 m
1 .12169 L
s
.99625 .1941 m
1 .1941 L
s
.99625 .2303 m
1 .2303 L
s
.99625 .2665 m
1 .2665 L
s
.99625 .3389 m
1 .3389 L
s
.99625 .3751 m
1 .3751 L
s
.99625 .41131 m
1 .41131 L
s
.99625 .48371 m
1 .48371 L
s
.99625 .51991 m
1 .51991 L
s
.99625 .55611 m
1 .55611 L
s
.99625 .62851 m
1 .62851 L
s
.99625 .66471 m
1 .66471 L
s
.99625 .70092 m
1 .70092 L
s
.25 Mabswid
1 0 m
1 .70948 L
s
0 0 m
1 0 L
1 .70948 L
0 .70948 L
closepath
clip
newpath
.5 Mabswid
.97287 .3027 m
.97306 .29629 L
.97353 .28994 L
.97482 .2774 L
.97539 .27121 L
.97574 .26508 L
.97574 .259 L
.97527 .25297 L
.9742 .247 L
.97244 .24109 L
.96909 .22959 L
.96291 .20778 L
.93601 .16433 L
.89736 .12694 L
.80244 .07325 L
.69152 .03951 L
.56383 .02031 L
.53437 .01865 L
.51962 .01764 L
.51228 .01729 L
.50497 .01711 L
.49769 .01705 L
.49045 .01708 L
.48325 .01718 L
.47608 .01731 L
.4477 .01756 L
.43248 .0182 L
.41742 .01935 L
.38801 .0219 L
.33148 .02995 L
.23189 .05616 L
.15483 .09331 L
.08953 .14832 L
.04755 .21305 L
.03475 .24923 L
.02977 .2685 L
.02708 .28826 L
.02543 .2993 L
.02473 .3049 L
.02422 .31054 L
.02395 .31622 L
.02399 .32194 L
.02433 .32769 L
.02455 .33347 L
.02507 .35689 L
.02845 .38099 L
.03812 .42654 L
.05504 .4726 L
.11685 .56882 L
.21267 .64608 L
Mistroke
.26909 .67073 L
.30048 .67993 L
.33304 .68573 L
.35176 .68938 L
.36131 .69072 L
.37092 .69145 L
.3806 .69171 L
.39035 .69164 L
.40018 .69136 L
.41008 .691 L
.43015 .69059 L
.45065 .69022 L
.47162 .68747 L
.49285 .68323 L
.57263 .66415 L
.65217 .63351 L
.81119 .53475 L
.92472 .4162 L
.95562 .36059 L
.96544 .33326 L
.9716 .30696 L
.97481 .29293 L
.97581 .286 L
.97619 .27915 L
.97578 .27238 L
.97475 .26571 L
.97345 .2527 L
.97025 .22771 L
.95999 .20378 L
.93558 .16368 L
.90066 .12908 L
.80769 .07554 L
.6873 .03819 L
.56874 .02101 L
.5365 .01832 L
.52062 .01784 L
.50486 .01757 L
.48918 .01718 L
.48136 .01694 L
.47357 .01689 L
.46581 .01702 L
.4581 .01729 L
.44281 .01806 L
.41339 .01947 L
.3845 .02223 L
.3294 .03003 L
.23644 .05446 L
.15214 .09505 L
.09162 .14592 L
.04999 .20864 L
Mistroke
.03496 .24777 L
.03031 .26843 L
.0261 .29006 L
.02502 .31077 L
.02434 .32135 L
.02404 .3267 L
.02385 .33208 L
.02381 .33751 L
.02399 .34297 L
.02445 .34847 L
.02521 .35401 L
.02767 .37624 L
.03862 .42574 L
.05719 .47584 L
.11331 .56509 L
.20035 .63854 L
.26051 .66773 L
.29331 .67731 L
.32914 .68643 L
.36368 .68954 L
.38153 .69069 L
.39065 .69153 L
.3999 .69236 L
.40925 .69259 L
.41867 .69229 L
.42816 .69157 L
.43771 .69056 L
.47626 .68568 L
.56285 .66606 L
.64982 .63363 L
.80575 .53942 L
.91376 .42964 L
.95187 .36859 L
.96295 .33924 L
.97244 .31019 L
.97401 .2843 L
.9751 .27174 L
.97549 .26555 L
.9756 .25942 L
.97529 .25334 L
.97445 .24732 L
.97093 .23545 L
.96443 .21303 L
.94164 .17235 L
.90936 .13691 L
.81278 .07775 L
.70105 .04152 L
.57193 .02012 L
.56803 .01967 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[35]:=",
  ImageSize->{288, 204.312},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000c1000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
X_oo0`001?oo00<00?ooool01Ooo00<00?ooool0K?oo002Sool00`00ooooo`02ool00`00ooooo`07
ool00`00ooooo`1[ool009coo`<000Coo`03003ooooo00;oo`03003oo`00008000Goo`03003ooooo
06_oo`00WOoo00<00?ooool00ooo00<00?ooool00_oo00@00?ooool000Koo`03003ooooo06_oo`00
W_oo00<00?ooool00_oo00<00?ooool00_oo00@00?ooool000Koo`03003ooooo06_oo`00W_oo0P00
2?oo00D00?ooooooo`0000Goo`03003ooooo06_oo`00W_oo00<00?oo00001ooo00D00?ooooooo`00
00Goo`03003ooooo06_oo`00W_oo00@00?ooool000Koo`03003oo`0000;oo`03003oo`0000;oo`03
003ooooo06_oo`00WOoo0`0000?oo`0000001_oo00<00?oo00001P00K_oo003ooolQool002goo`@0
00?oo`03003ooooo00Coo`03003ooooo017oo`@000?oo`03003ooooo00?oo`8001?oo`@000?oo`03
003ooooo00?oo`8001[oo`@001Soo`@000?oo`03003ooooo00;oo`@001;oo`@000?oo`03003ooooo
00Coo`03003ooooo01;oo`@000?oo`03003ooooo00?oo`8001Koo`00;ooo00<00?ooool02Ooo00<0
0?ooool04ooo00<00?ooool01ooo00@00?ooool001Coo`03003ooooo00Ooo`04003ooooo000Iool0
0`00ooooo`0Iool00`00ooooo`09ool00`00ooooo`0Cool00`00ooooo`0;ool00`00ooooo`0Bool0
0`00ooooo`09ool01000ooooo`005Ooo000_ool00`00ooooo`06ool5000Dool00`00ooooo`07ool0
1000ooooo`005?oo00<00?ooool01ooo00@00?ooool001[oo`03003ooooo01Woo`03003ooooo00Wo
o`03003ooooo01?oo`03003ooooo00Ooo`D001Coo`03003ooooo00Soo`04003ooooo000Eool002oo
o`03003ooooo00Koo`04003ooooo000Eool00`00ooooo`07ool3000Eool00`00ooooo`08ool2000L
ool00`00ooooo`0Iool00`00ooooo`09ool00`00ooooo`0Cool00`00ooooo`06ool01000ooooo`00
5_oo00<00?ooool01ooo0`005_oo000_ool00`00ooooo`07ool00`00ool0000Eool00`00ooooo`07
ool00`00ooooo`0Eool00`00ooooo`07ool01000ooooo`007?oo00<00?ooool06Ooo00<00?ooool0
2Ooo00<00?ooool04ooo00<00?ooool01_oo00<00?oo00005ooo00<00?ooool01_oo00<00?ooool0
5_oo000]ool3000:ool2000Cool30009ool00`00ooooo`0Cool30009ool01000ooooo`006Ooo00@0
0?ooool001Soo`04003ooooo0008ool01000ooooo`004_oo00@00?ooool000Woo`8001Coo`04003o
oooo0008ool00`00ooooo`0Fool002ooo`03003ooooo00Woo`03003ooooo01?oo`03003ooooo00So
o`<001Coo`03003ooooo00Soo`8001_oo`8001[oo`8000[oo`8001Coo`8000_oo`03003ooooo01?o
o`8000[oo`<001Goo`00oooo8Ooo003ooolQool00?ooob7oo`00<_ook@000Ooo000Oool20004ool0
0`00ooooo`03ool20005ool01000ooooo`001ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?oo
ool01_oo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?oo
ool01_oo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?oo
ool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01_oo00<00?ooool01Ooo00<00?oo
ool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?oo00000Ooo000Nool0
1000ooooo`002?oo00@00?ooool000Coo`04003ooooo000Qool00`00ooooo`0Oool00`00ooooo`0P
ool00`00ooooo`0Oool00`00ooooo`0Oool00`00ooooo`0Pool00`00ooooo`0Hool10001ool001ko
o`04003ooooo0008ool01000ooooo`001?oo0P00jOoo0P000Ooo000Nool01000ooooo`002?oo0`00
1Ooo00<00?ooool0IOoo5@00Kooo0@000Ooo000Nool01000ooooo`002?oo00<00?ooool01Ooo00<0
0?ooool0EOoo4P003ooo4P00HOoo0@000Ooo000Nool01000ooooo`002?oo00<00?ooool01Ooo00<0
0?ooool0Cooo3000:_oo2@00Fooo0@000Ooo000Oool2000:ool30004ool00`00ooooo`1:ool8000i
ool:001Dool10001ool003;oo`03003ooooo04Koo`@004Ooo`/004goo`40007oo`00<_oo00<00?oo
ool0@_oo1000DOoo2P00B?oo0@000Ooo000bool00`00ooooo`0oool4001Jool80014ool10001ool0
03;oo`03003ooooo03_oo`@006?oo`H0047oo`40007oo`00<_oo00<00?ooool0=ooo1@00J_oo1@00
?Ooo0P000Ooo000bool00`00ooooo`0dool5001`ool5000kool10001ool003;oo`03003ooooo03;o
o`<007Ooo`D003Soo`40007oo`00<_oo00<00?ooool0<?oo0P00O_oo1000=Ooo0@000Ooo000bool0
0`00ooooo`0^ool20023ool5000aool10001ool003;oo`03003ooooo02coo`8008Soo`D002koo`40
007oo`00<_oo00<00?ooool0:Ooo0`00SOoo1000;?oo0@000Ooo000bool00`00ooooo`0Wool3002B
ool3000Zool10001ool003;oo`03003ooooo02Goo`<009Koo`<002Soo`40007oo`00<_oo00<00?oo
ool08ooo0`00V_oo0P009_oo0P000Ooo000bool00`00ooooo`0Qool3002Nool2000Uool10001ool0
03;oo`03003ooooo023oo`800:7oo`<002?oo`40007oo`00<_oo00<00?ooool07ooo0P00Y?oo0P00
8_oo0@000Ooo000bool00`00ooooo`0Mool3002Wool2000Pool10001ool003;oo`03003ooooo01co
o`800:[oo`<001koo`40007oo`00<_oo00<00?ooool06ooo0P00[Ooo0`007?oo0@000Ooo000bool0
0`00ooooo`0Jool2002_ool4000Jool10001ool003;oo`03003ooooo01Woo`800;;oo`@001Ooo`80
007oo`00<_oo00<00?ooool06?oo00<00?ooool0]?oo0`005ooo0@000Ooo000bool00`00ooooo`0G
ool00`00ooooo`2fool3000Fool10001ool003;oo`03003ooooo01Goo`800;_oo`8001Goo`40007o
o`00<_oo00<00?ooool05?oo0P00__oo00<00?ooool04_oo0@000Ooo000bool00`00ooooo`0Cool0
0`00ooooo`2oool00`00ooooo`0Aool10001ool003;oo`03003ooooo01;oo`03003ooooo0<7oo`03
003ooooo013oo`40007oo`007ooo0P001?oo00<00?ooool00ooo0P001Ooo00<00?ooool04Ooo00<0
0?ooool0`ooo00<00?ooool03ooo0@000Ooo000Nool01000ooooo`002?oo00@00?ooool000Coo`03
003ooooo017oo`03003ooooo0<Coo`03003ooooo00koo`40007oo`007_oo00@00?ooool000Soo`04
003ooooo0004ool2000Aool00`00ooooo`36ool00`00ooooo`0<ool20001ool001koo`04003ooooo
0009ool20005ool00`00ooooo`0?ool20039ool00`00ooooo`0<ool10001ool001koo`04003ooooo
0008ool01000ooooo`001?oo00<00?ooool03ooo00<00?ooool0bOoo00<00?ooool02ooo0@000Ooo
000Nool01000ooooo`002?oo00@00?ooool000Coo`03003ooooo00koo`03003ooooo0<[oo`8000co
o`40007oo`007ooo0P002_oo0P001Ooo00<00?ooool03Ooo0P00cOoo00<00?ooool02_oo0@000Ooo
000bool00`00ooooo`0=ool00`00ooooo`3<ool2000;ool10001ool003;oo`03003ooooo00coo`03
003ooooo0<koo`03003ooooo00Woo`40007oo`00<_oo00<00?ooool02ooo0P00dOoo00<00?ooool0
2?oo0@000Ooo000bool00`00ooooo`0;ool00`00ooooo`3@ool20008ool20001ool003;oo`03003o
oooo00[oo`800=?oo`8000Soo`40007oo`00<_oo00<00?ooool02Ooo0P00e?oo0P002?oo0@000Ooo
000bool00`00ooooo`09ool00`00ooooo`3Dool20007ool10001ool003;oo`03003ooooo00Soo`80
0=Koo`8000Ooo`40007oo`00<_oo00<00?ooool02?oo00<00?ooool0e_oo00<00?ooool01Ooo0@00
0Ooo000bool00`00ooooo`07ool2003Hool00`00ooooo`05ool10001ool003;oo`03003ooooo00Oo
o`03003ooooo0=Ooo`8000Koo`40007oo`00<_oo00<00?ooool01ooo00<00?ooool0f?oo00<00?oo
ool01?oo0@000Ooo000bool00`00ooooo`06ool2003Jool00`00ooooo`03ool20001ool003;oo`03
003ooooo00Koo`03003ooooo0=Woo`03003ooooo00Coo`40007oo`00<_oo00<00?ooool01_oo00<0
0?ooool0fOoo0P001Ooo0@000Ooo000bool00`00ooooo`05ool00`00ooooo`3Kool00`00ooooo`03
ool10001ool003;oo`03003ooooo00Goo`03003ooooo0=_oo`03003ooooo00?oo`40007oo`00<_oo
00<00?ooool01Ooo00<00?ooool0fooo0P001?oo0@000Ooo000bool00`00ooooo`05ool00`00oooo
o`3Kool20004ool10001ool003;oo`03003ooooo00Coo`03003ooooo0=coo`8000Coo`40007oo`00
<_oo00<00?ooool01?oo00<00?ooool0g?oo0P000ooo0P000Ooo000bool00`00ooooo`04ool00`00
ooooo`3Lool20004ool10001ool003;oo`03003ooooo00Coo`03003ooooo0=coo`8000Coo`40007o
o`00<_oo00<00?ooool01?oo00<00?ooool0g?oo0P001?oo0@000Ooo000bool00`00ooooo`03ool0
0`00ooooo`3Mool20004ool10001ool003;oo`03003ooooo00?oo`03003ooooo0=goo`8000Coo`40
007oo`00<_oo00<00?ooool00ooo00<00?ooool0gOoo0P001?oo0@000Ooo000Zool40004ool00`00
ooooo`03ool00`00ooooo`3Mool00`00ooooo`03ool10001ool002coo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo0=goo`03003ooooo00?oo`40007oo`00;?oo00<00?ooool00ooo0P000ooo
00<00?ooool0g_oo00<00?ooool00_oo0P000Ooo000/ool00`00ooooo`03ool00`00ooooo`02ool0
0`00ooooo`3Nool00`00ooooo`03ool10001ool002coo`03003ooooo00?oo`03003ooooo00;oo`03
003ooooo0=koo`03003ooooo00?oo`40007oo`00:_oo0`001Ooo00<00?ooool00_oo00<00?ooool0
gOoo0P001Ooo0@000Ooo000/ool00`00ooooo`03ool00`00ooooo`02ool00`00ooooo`3Mool00`00
ooooo`04ool10001ool003;oo`03003ooooo00;oo`03003ooooo0=goo`03003ooooo00Coo`40007o
o`00<_oo00<00?ooool00_oo00<00?ooool0g?oo0P001_oo0@000Ooo000bool00`00ooooo`02ool0
0`00ooooo`3Lool20006ool10001ool003;oo`03003ooooo00;oo`03003ooooo0=coo`03003ooooo
00Goo`40007oo`001ooo0`001?oo00<00?ooool01Ooo00<00?ooool06Ooo00<00?ooool00_oo00<0
0?ooool0fooo0P001_oo0P000Ooo0007ool00`00ooooo`03ool00`00ooooo`07ool00`00ooooo`0H
ool00`00ooooo`02ool00`00ooooo`3Kool20007ool10001ool000;oo`<000?oo`03003ooooo00;o
o`03003ooooo00<000Coo`03003ooooo01Soo`03003ooooo00;oo`800=coo`03003ooooo00Koo`40
007oo`000ooo00<00?ooool00ooo00D00?ooooooo`0000?oo`03003ooooo00?oo`03003ooooo01So
o`03003ooooo00?oo`03003ooooo0=[oo`03003ooooo00Koo`40007oo`001?oo00<00?ooool00`00
0ooo00D00?ooooooo`0000Goo`03003ooooo01Soo`03003ooooo00?oo`03003ooooo0=Woo`03003o
oooo00Ooo`40007oo`001?oo0P001ooo00<00?ooool00_oo00<00?ooool00_oo00<00?ooool06?oo
00<00?ooool00ooo00<00?ooool0fOoo00<00?ooool01ooo0@000Ooo0004ool00`00ool00006ool0
0`00ooooo`02ool00`00ooooo`02ool00`00ooooo`0Hool00`00ooooo`03ool00`00ooooo`3Hool0
0`00ooooo`08ool10001ool000Coo`04003ooooo0005ool01000ooooo`000_oo00D00?oo003oo`00
01[oo`03003ooooo00?oo`03003ooooo0=Soo`03003ooooo00Soo`40007oo`000ooo0`0000?oo`00
00001Ooo00<00?ooool01P006ooo00<00?ooool00ooo00<00?ooool0eooo00<00?ooool02?oo0P00
0Ooo000bool00`00ooooo`03ool00`00ooooo`3Gool00`00ooooo`09ool10001ool003;oo`03003o
oooo00?oo`03003ooooo0=Koo`03003ooooo00[oo`40007oo`00<_oo00<00?ooool00ooo0P00e_oo
0P003?oo0@000Ooo000bool00`00ooooo`04ool00`00ooooo`3Dool00`00ooooo`0;ool10001ool0
03;oo`03003ooooo00Coo`03003ooooo0=?oo`8000goo`40007oo`00<_oo00<00?ooool01?oo00<0
0?ooool0dooo00<00?ooool03?oo0@000Ooo000bool00`00ooooo`04ool2003Cool2000>ool10001
ool003;oo`03003ooooo00Goo`03003ooooo0=3oo`8000ooo`40007oo`00<_oo00<00?ooool01Ooo
00<00?ooool0d?oo0P003_oo0P000Ooo000bool00`00ooooo`05ool00`00ooooo`3?ool2000@ool1
0001ool003;oo`03003ooooo00Koo`03003ooooo0<goo`80017oo`40007oo`00<_oo00<00?ooool0
1_oo00<00?ooool0cOoo00<00?ooool04?oo0@000Ooo000bool00`00ooooo`06ool00`00ooooo`3<
ool00`00ooooo`0Aool10001ool003;oo`03003ooooo00Ooo`03003ooooo0<[oo`03003ooooo01;o
o`40007oo`007_oo10000ooo00<00?ooool00_oo10001?oo00<00?ooool01ooo00<00?ooool0bOoo
00<00?ooool04ooo0@000Ooo000Pool00`00ooooo`07ool00`00ooooo`05ool00`00ooooo`07ool0
0`00ooooo`38ool00`00ooooo`0Dool10001ool0023oo`03003ooooo00Soo`03003ooooo00Coo`80
00Woo`03003ooooo0<Koo`03003ooooo01Coo`80007oo`008?oo00<00?ooool02Ooo00<00?ooool0
0ooo00<00?ooool02?oo00<00?ooool0aOoo00<00?ooool05_oo0@000Ooo000Pool00`00ooooo`0:
ool00`00ooooo`02ool00`00ooooo`08ool20035ool00`00ooooo`0Gool10001ool001koo`<000Wo
o`04003ooooo0004ool00`00ooooo`09ool00`00ooooo`32ool00`00ooooo`0Hool10001ool0023o
o`03003ooooo00Soo`8000Goo`03003ooooo00Woo`03003ooooo0<7oo`03003ooooo01Woo`40007o
o`00<_oo00<00?ooool02Ooo0P00`Ooo00<00?ooool06_oo0@000Ooo000bool00`00ooooo`0:ool0
0`00ooooo`2nool00`00ooooo`0Kool10001ool003;oo`03003ooooo00[oo`800;koo`8001goo`40
007oo`00<_oo00<00?ooool02ooo00<00?ooool0^ooo0P007_oo0@000Ooo000bool00`00ooooo`0;
ool2002kool2000Nool20001ool003;oo`03003ooooo00coo`03003ooooo0;Soo`80023oo`40007o
o`00<_oo00<00?ooool03?oo0P00^?oo0P008Ooo0@000Ooo000bool00`00ooooo`0=ool2002fool2
000Rool10001ool003;oo`03003ooooo00koo`03003ooooo0;?oo`8002?oo`40007oo`00<_oo00<0
0?ooool03_oo0P00/ooo0P009?oo0@000Ooo000bool00`00ooooo`0?ool00`00ooooo`2`ool2000U
ool10001ool003;oo`03003ooooo013oo`03003ooooo0:koo`8002Koo`40007oo`00<_oo00<00?oo
ool04?oo0P00[_oo0P009_oo0P000Ooo000bool00`00ooooo`0Aool00`00ooooo`2[ool2000Xool1
0001ool003;oo`03003ooooo017oo`800:_oo`8002Woo`40007oo`00<_oo00<00?ooool04_oo0P00
ZOoo0P00:_oo0@000Ooo000bool00`00ooooo`0Cool00`00ooooo`2Vool2000[ool10001ool003;o
o`03003ooooo01?oo`800:Koo`8002coo`40007oo`00<_oo00<00?ooool05?oo00<00?ooool0X_oo
0P00;_oo0@000Ooo000bool00`00ooooo`0Eool00`00ooooo`2Oool2000`ool10001ool003;oo`03
003ooooo01Goo`8009ooo`80037oo`40007oo`00<_oo00<00?ooool05_oo00<00?ooool0Vooo0P00
<_oo0P000Ooo000bool00`00ooooo`0Fool2002Jool2000eool10001ool003;oo`03003ooooo01Oo
o`03003ooooo09Ooo`8003Koo`40007oo`00<_oo00<00?ooool06?oo00<00?ooool0U?oo0P00>?oo
0@000Ooo000bool00`00ooooo`0Iool2002Bool2000jool10001ool003;oo`03003ooooo01[oo`80
093oo`8003_oo`40007oo`00<_oo00<00?ooool07?oo00<00?ooool0Rooo0P00?Ooo0@000Ooo000N
ool40003ool00`00ooooo`04ool00`00ooooo`03ool00`00ooooo`0Mool00`00ooooo`28ool2000o
ool10001ool0023oo`03003ooooo00Woo`03003ooooo00?oo`03003ooooo01koo`8008Koo`<0043o
o`40007oo`008?oo00<00?ooool01_oo1@001?oo0P008Ooo00<00?ooool0P_oo0P00@Ooo0P000Ooo
000Pool00`00ooooo`06ool01000ooooo`001Ooo00<00?ooool08Ooo00<00?ooool0Oooo0`00@ooo
0@000Ooo000Pool00`00ooooo`07ool00`00ool00005ool00`00ooooo`0Rool00`00ooooo`1lool3
0015ool10001ool001koo`<000[oo`8000Goo`03003ooooo02?oo`8007_oo`8004Ooo`40007oo`00
8?oo00<00?ooool02Ooo00<00?ooool00ooo00<00?ooool09?oo0P00N?oo0`00B?oo0@000Ooo000b
ool00`00ooooo`0Vool00`00ooooo`1cool3001:ool10001ool003;oo`03003ooooo02Ooo`03003o
oooo077oo`8004coo`40007oo`00<_oo00<00?ooool0:?oo0P00Kooo0`00COoo0@000Ooo000bool0
0`00ooooo`0Yool2001/ool3001>ool20001ool003;oo`03003ooooo02_oo`03003ooooo06Ooo`<0
057oo`40007oo`00<_oo00<00?ooool0;?oo0P00IOoo0`00Dooo0@000Ooo000bool00`00ooooo`0]
ool2001Qool4001Eool10001ool003;oo`03003ooooo02ooo`8005goo`@005Ooo`40007oo`00<_oo
00<00?ooool0<Ooo0P00F?oo1000F_oo0@000Ooo000bool00`00ooooo`0cool2001Dool4001Lool1
0001ool003;oo`03003ooooo03Goo`8004ooo`@005ooo`40007oo`00<_oo00<00?ooool0=ooo0P00
Booo1000HOoo0@000Ooo000bool00`00ooooo`0iool30014ool6001Rool20001ool003;oo`03003o
oooo03_oo`<003koo`H006Ooo`40007oo`00<_oo00<00?ooool0?_oo1000=_oo1@00K?oo0@000Ooo
000bool00`00ooooo`11ool5000^ool5001`ool10001ool003;oo`03003ooooo04Goo`D002Goo`D0
07Goo`40007oo`00<_oo00<00?ooool0BOoo1P006_oo1`00NOoo0@000Ooo000bool00`00ooooo`1>
oolL001oool10001ool003;oo`03003ooooo0>Woo`40007oo`00<_oo00<00?ooool0j?oo0P000Ooo
000bool01000ooooo`001ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01Ooo00<00?ooool01_oo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01_oo00<00?oo
ool01Ooo00<00?ooool01_oo00<00?ooool01Ooo00<00?oo00000Ooo000booo]0001ool00?ooob7o
o`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {203.312, 0}} -> {1.08929, 0.412196, \
0.00583244, 0.00583244}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
AutoGeneratedPackage->None,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical methods for solving the Lotka-Volterra equations",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "s:1"->{
    Cell[1878, 57, 50, 1, 61, "Section",
      CellTags->"s:1"]},
  "LotkaVolterraSystem"->{
    Cell[2417, 80, 281, 6, 31, "NumberedEquation",
      CellTags->"LotkaVolterraSystem"]},
  "LotkaVolterraInvariant"->{
    Cell[3122, 108, 172, 3, 28, "NumberedEquation",
      CellTags->"LotkaVolterraInvariant"]},
  "PoissonSystemt"->{
    Cell[3818, 134, 139, 3, 31, "NumberedEquation",
      CellTags->"PoissonSystemt"]},
  "s:2"->{
    Cell[5863, 202, 52, 1, 67, "Section",
      CellTags->"s:2"]},
  "s:3"->{
    Cell[36424, 1284, 52, 1, 67, "Section",
      CellTags->"s:3"]},
  "s:4"->{
    Cell[65431, 2306, 48, 1, 67, "Section",
      CellTags->"s:4"]},
  "s:5"->{
    Cell[91834, 3218, 47, 1, 67, "Section",
      CellTags->"s:5"]},
  "LotkaVolterraSplitting"->{
    Cell[92093, 3229, 356, 8, 55, "NumberedEquation",
      CellTags->"LotkaVolterraSplitting"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"s:1", 148471, 5179},
  {"LotkaVolterraSystem", 148564, 5182},
  {"LotkaVolterraInvariant", 148686, 5185},
  {"PoissonSystemt", 148804, 5188},
  {"s:2", 148903, 5191},
  {"s:3", 148981, 5194},
  {"s:4", 149061, 5197},
  {"s:5", 149141, 5200},
  {"LotkaVolterraSplitting", 149240, 5203}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 77, 0, 118, "Chapter"],

Cell[CellGroupData[{
Cell[1878, 57, 50, 1, 61, "Section",
  CellTags->"s:1"],
Cell[1931, 60, 123, 3, 22, "Text"],
Cell[2057, 65, 265, 8, 22, "Text"],
Cell[2325, 75, 89, 3, 22, "Text"],
Cell[2417, 80, 281, 6, 31, "NumberedEquation",
  CellTags->"LotkaVolterraSystem"],
Cell[2701, 88, 140, 5, 24, "Text"],
Cell[2844, 95, 275, 11, 24, "Text"],
Cell[3122, 108, 172, 3, 28, "NumberedEquation",
  CellTags->"LotkaVolterraInvariant"],
Cell[3297, 113, 182, 5, 22, "Text"],
Cell[3482, 120, 199, 5, 22, "Text"],
Cell[3684, 127, 131, 5, 22, "Text"],
Cell[3818, 134, 139, 3, 31, "NumberedEquation",
  CellTags->"PoissonSystemt"],
Cell[3960, 139, 223, 11, 24, "Text"],
Cell[4186, 152, 320, 11, 24, "Text"],
Cell[4509, 165, 115, 3, 40, "MathCaption"],
Cell[4627, 170, 667, 14, 138, "Input",
  InitializationCell->True],
Cell[5297, 186, 75, 0, 40, "MathCaption"],
Cell[5375, 188, 451, 9, 90, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5863, 202, 52, 1, 67, "Section",
  CellTags->"s:2"],
Cell[5918, 205, 181, 7, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[6124, 216, 290, 6, 58, "Input"],
Cell[6417, 224, 29958, 1054, 213, 13400, 844, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36424, 1284, 52, 1, 67, "Section",
  CellTags->"s:3"],
Cell[36479, 1287, 241, 8, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[36745, 1299, 805, 15, 154, "Input"],
Cell[37553, 1316, 27829, 984, 176, 12739, 793, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[65431, 2306, 48, 1, 67, "Section",
  CellTags->"s:4"],
Cell[65482, 2309, 228, 5, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[65735, 2318, 375, 8, 90, "Input"],
Cell[66113, 2328, 25672, 884, 211, 11902, 709, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[91834, 3218, 47, 1, 67, "Section",
  CellTags->"s:5"],
Cell[91884, 3221, 206, 6, 24, "Text"],
Cell[92093, 3229, 356, 8, 55, "NumberedEquation",
  CellTags->"LotkaVolterraSplitting"],
Cell[92452, 3239, 177, 5, 24, "Text"],
Cell[92632, 3246, 140, 3, 40, "MathCaption"],
Cell[92775, 3251, 464, 9, 122, "Input"],

Cell[CellGroupData[{
Cell[93264, 3264, 38, 0, 41, "Subsection"],
Cell[93305, 3266, 243, 6, 56, "MathCaption"],
Cell[93551, 3274, 529, 11, 106, "Input"],
Cell[94083, 3287, 102, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[94210, 3294, 103, 2, 26, "Input"],
Cell[94316, 3298, 25790, 896, 211, 12074, 721, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[120155, 4200, 27, 0, 41, "Subsection"],
Cell[120185, 4202, 215, 6, 24, "Text"],
Cell[120403, 4210, 178, 5, 24, "Text"],
Cell[120584, 4217, 306, 9, 40, "Text"],
Cell[120893, 4228, 534, 10, 122, "Input"],
Cell[121430, 4240, 95, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[121550, 4247, 103, 2, 26, "Input"],
Cell[121656, 4251, 25917, 899, 211, 12139, 724, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

