(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    462784,      12003]*)
(*NotebookOutlinePosition[    486345,      12568]*)
(*  CellTagsIndexPosition[    485186,      12522]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Overview", "Chapter"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"s:1"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["NDSolve", "MR"],
  " is a general numerical differential equation solver.  It can handle a \
wide range of ",
  StyleBox["ordinary differential equations", "TI"],
  " (ODEs) as well as some ",
  StyleBox["partial differential equations", "TI"],
  " (PDEs). In a system of ordinary differential equations there can be any \
number of unknown functions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\* \
StyleBox[\\\"\\\\\\\"x\\\\\\\"\\\",\\n\\\"TI\\\"]\\)\"\>", "i"], 
        TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  ", but all of these functions must depend on a single \
\[OpenCurlyDoubleQuote]independent variable\[CloseCurlyDoubleQuote] ",
  StyleBox["t", "TI"],
  ", which is the same for each function. Partial differential equations \
involve two or more independent variables.  NDSolve can also solve some ",
  StyleBox["differential-algebraic equations",
    FontSlant->"Italic"],
  " (DAEs), which are typically a mix of differential and algebraic \
equations."
}], "Text",
  CellTags->{"S3.9.7", "7.2", "b:1", "ndsg:0"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NDSolve",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["eqn",
                          "MR",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox[
                          FormBox["eqn",
                            "TextForm"],
                          "MR",
                          FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                    "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["u",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    StyleBox["t",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["tmin",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["tmax",
                      "MR",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    "MR"]}]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "find a numerical solution for the function ",
              StyleBox["u",
                FontSlant->"Italic"],
              " with ",
              StyleBox["t",
                FontSlant->"Italic"],
              " in the range ",
              StyleBox["tmin",
                FontSlant->"Italic"],
              " to ",
              StyleBox["tmax",
                FontSlant->"Italic"]
            }], "Text"]},
          {
            RowBox[{
              StyleBox["NDSolve",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["eqn",
                          "MR",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox[
                          FormBox["eqn",
                            "TextForm"],
                          "MR",
                          FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                    "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["u",
                          "MR",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox["u",
                          "MR",
                          FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                    "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    StyleBox["t",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["tmin",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["tmax",
                      "MR",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    "MR"]}]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "find numerical solutions for several functions ",
              Cell[BoxData[
                  \(TraditionalForm\`u\_i\)]]
            }], "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell["\<\
Finding numerical solutions to ordinary differential equations. \
\
\>", "Caption",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " represents solutions for the functions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\* \
StyleBox[\\\"\\\\\\\"x\\\\\\\"\\\",\\n\\\"TI\\\"]\\)\"\>", "i"], 
        TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  " as ",
  StyleBox["InterpolatingFunction", "MR"],
  " objects. The",
  StyleBox["InterpolatingFunction", "MR"],
  " objects provide approximations to the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\* \
StyleBox[\\\"\\\\\\\"x\\\\\\\"\\\",\\n\\\"TI\\\"]\\)\"\>", "i"], 
        TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  " over the range of values ",
  StyleBox["tmin", "TI"],
  " to ",
  StyleBox["tmax", "TI"],
  " for the independent variable ",
  StyleBox["t", "TI"],
  ". \nIn general, ",
  StyleBox["NDSolve", "MR"],
  " finds solutions iteratively. It starts at a particular value of ",
  StyleBox["t", "TI"],
  ", then takes a sequence of steps, trying eventually to cover the whole \
range ",
  StyleBox["tmin", "TI"],
  " to ",
  StyleBox["tmax", "TI"],
  ". \nIn order to get started, ",
  StyleBox["NDSolve", "MR"],
  " has to be given appropriate initial or boundary conditions for the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\* \
StyleBox[\\\"\\\\\\\"x\\\\\\\"\\\",\\n\\\"TI\\\"]\\)\"\>", "i"], 
        TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  " and their derivatives. These conditions specify values for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            
            SubscriptBox["\<\"\\!\\(\\* \
StyleBox[\\\"\\\\\\\"x\\\\\\\"\\\",\\n\\\"TI\\\"]\\)\"\>", "i"],
            "TraditionalForm"], "[", "t"}], TraditionalForm]]],
  StyleBox["]", "MR"],
  ", and perhaps derivatives ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              
              SubscriptBox["\<\"\\!\\(\\* StyleBox[\\\"\\\\\\\"x\\\\\\\"\\\",\
\\n\\\"TI\\\"]\\)\"\>", "i"],
              "TraditionalForm"], "'"}], "[", "t"}], TraditionalForm]]],
  StyleBox["]", "MR"],
  ", at particular points ",
  StyleBox["t", "TI"],
  ". When there is only one ",
  StyleBox["t", "TI"],
  " at which conditions are given, the equations and initial conditions are \
collectively referred to as an initial value problem. A boundary value occurs \
when there are multiple points ",
  StyleBox["t", "TI"],
  ". ",
  StyleBox["NDSolve", "MR"],
  " can solve nearly all initial value problems that can symbolically be put \
in normal form (i.e. are solvable for the highest derivative order), but only \
linear boundary value problems."
}], "Text",
  CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"}],

Cell[TextData[{
  "This finds a solution for ",
  StyleBox["x", "MR"],
  " with ",
  StyleBox["t", "MR"],
  " in the range ",
  StyleBox["0", "MR"],
  " to ",
  StyleBox["2", "MR"],
  ", using an initial condition for ",
  StyleBox["x", "MR",
    FontFamily->"Courier"],
  " at ",
  StyleBox["t\[Equal]1", "MR",
    FontFamily->"Courier"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell["NDSolve[{x'[t] == x[t], x[1] == 3}, x, {t, 0, 2}]", "Input",
  CellLabel->"In[56]:=",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[56]=",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell[TextData[{
  "When you use ",
  StyleBox["NDSolve", "MR"],
  ", the initial or boundary conditions you give must be sufficient to \
determine the solutions for the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\<\"\\!\\(\\* \
StyleBox[\\\"\\\\\\\"x\\\\\\\"\\\",\\n\\\"TI\\\"]\\)\"\>", "i"], 
        TraditionalForm]], "InlineFormula",
    FormatType->StandardForm],
  " completely. When you use",
  StyleBox[" ", "MR"],
  StyleBox[ButtonBox["DSolve",
    ButtonStyle->"RefGuideLink"], "MR"],
  " to find symbolic solutions to differential equations, you may specify \
fewer conditions. The reason is that ",
  StyleBox["DSolve", "MR"],
  " automatically inserts arbitrary symbolic constants ",
  StyleBox["C[", "MR"],
  StyleBox["i", "MR"],
  StyleBox["]", "MR"],
  " to represent degrees of freedom associated with initial conditions that \
you have not specified explicitly. Since ",
  StyleBox["NDSolve", "MR"],
  " must give a numerical solution, it cannot represent these kinds of \
additional degrees of freedom. As a result, you must explicitly give all the \
initial or boundary conditions that are needed to determine the solution. \n\
In a typical case, if you have differential equations with up to ",
  Cell[BoxData[
      \(TraditionalForm\`n\)], "InlineFormula",
    FormatType->StandardForm],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^"th"\)], "InlineFormula",
    FormatType->StandardForm],
  " derivatives, then you need to either give initial conditions for up to ",
  Cell[BoxData[
      \(TraditionalForm\`\((n - 1)\)\)], "InlineFormula",
    FormatType->StandardForm],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^"th"\)], "InlineFormula",
    FormatType->StandardForm],
  " derivatives, or give boundary conditions at ",
  Cell[BoxData[
      \(TraditionalForm\`n\)], "InlineFormula",
    FormatType->StandardForm],
  " points. "
}], "Text",
  CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"}],

Cell["\<\
This solves an initial value problem for a second order equation, \
which requires two conditions, and are given at t \[Equal] 0.\
\>", \
"MathCaption",
  CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[{x''[t] == x[t]^2, x[0] == 1, x'[0] == 0}, x, {t, 0, \
2}]\
\>", "Input",
  CellLabel->"In[64]:=",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[64]=",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell["This plots the solution obtained.", "MathCaption",
  CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[ x[t] /. % ], {t, 0, 2}];", "Input",
  CellLabel->"In[65]:=",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.0931026 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .10782 -6 -4.5 ]
[.01131 .10782 0 4.5 ]
[.01131 .20092 -6 -4.5 ]
[.01131 .20092 0 4.5 ]
[.01131 .29402 -6 -4.5 ]
[.01131 .29402 0 4.5 ]
[.01131 .38713 -6 -4.5 ]
[.01131 .38713 0 4.5 ]
[.01131 .48023 -6 -4.5 ]
[.01131 .48023 0 4.5 ]
[.01131 .57333 -6 -4.5 ]
[.01131 .57333 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .10782 m
.03006 .10782 L
s
[(1)] .01131 .10782 1 0 Mshowa
.02381 .20092 m
.03006 .20092 L
s
[(2)] .01131 .20092 1 0 Mshowa
.02381 .29402 m
.03006 .29402 L
s
[(3)] .01131 .29402 1 0 Mshowa
.02381 .38713 m
.03006 .38713 L
s
[(4)] .01131 .38713 1 0 Mshowa
.02381 .48023 m
.03006 .48023 L
s
[(5)] .01131 .48023 1 0 Mshowa
.02381 .57333 m
.03006 .57333 L
s
[(6)] .01131 .57333 1 0 Mshowa
.125 Mabswid
.02381 .03334 m
.02756 .03334 L
s
.02381 .05196 m
.02756 .05196 L
s
.02381 .07058 m
.02756 .07058 L
s
.02381 .0892 m
.02756 .0892 L
s
.02381 .12644 m
.02756 .12644 L
s
.02381 .14506 m
.02756 .14506 L
s
.02381 .16368 m
.02756 .16368 L
s
.02381 .1823 m
.02756 .1823 L
s
.02381 .21954 m
.02756 .21954 L
s
.02381 .23816 m
.02756 .23816 L
s
.02381 .25678 m
.02756 .25678 L
s
.02381 .2754 m
.02756 .2754 L
s
.02381 .31264 m
.02756 .31264 L
s
.02381 .33126 m
.02756 .33126 L
s
.02381 .34988 m
.02756 .34988 L
s
.02381 .36851 m
.02756 .36851 L
s
.02381 .40575 m
.02756 .40575 L
s
.02381 .42437 m
.02756 .42437 L
s
.02381 .44299 m
.02756 .44299 L
s
.02381 .46161 m
.02756 .46161 L
s
.02381 .49885 m
.02756 .49885 L
s
.02381 .51747 m
.02756 .51747 L
s
.02381 .53609 m
.02756 .53609 L
s
.02381 .55471 m
.02756 .55471 L
s
.02381 .59195 m
.02756 .59195 L
s
.02381 .61057 m
.02756 .61057 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .10782 m
.02499 .10782 L
.02605 .10782 L
.02729 .10782 L
.02846 .10782 L
.03053 .10783 L
.03279 .10783 L
.03527 .10784 L
.0379 .10786 L
.04262 .10789 L
.04749 .10793 L
.05205 .10798 L
.06244 .10812 L
.07305 .10832 L
.08274 .10853 L
.10458 .10916 L
.12357 .10988 L
.14429 .11083 L
.18493 .11325 L
.22406 .1163 L
.26565 .12036 L
.30571 .12514 L
.34426 .13062 L
.38527 .13748 L
.42475 .14523 L
.46273 .15387 L
.50315 .16453 L
.54206 .17642 L
.58342 .19114 L
.62326 .20771 L
.66159 .22629 L
.70238 .24952 L
.74164 .27599 L
.77939 .30615 L
.8196 .34464 L
.85828 .38958 L
.89942 .44844 L
.93905 .51948 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[65]:=",
  ImageSize->{299.438, 185.062},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^A000`40n007h00Ooooo;?oo003oool/
ool004_oo`8000Coo`03003ooooo00;oo`<003_oo`@003[oo`@000?oo`03003ooooo00;oo`<003[o
o`@000coo`00B_oo00@00?ooool000_oo`03003ooooo03[oo`03003ooooo03_oo`03003ooooo00[o
o`03003ooooo03Ooo`03003ooooo00goo`00B_oo00@00?ooool000_oo`03003ooooo03[oo`03003o
oooo03_oo`03003ooooo00[oo`03003ooooo03Soo`03003ooooo00coo`00B_oo00@00?ooool000So
o`<003goo`03003ooooo03_oo`03003ooooo00Ooo`<003coo`03003ooooo00_oo`00B_oo00@00?oo
ool000Soo`03003ooooo03goo`03003ooooo03_oo`03003ooooo00Ooo`03003ooooo03goo`03003o
oooo00[oo`00B_oo00@00?ooool000Soo`03003ooooo03_oo`<003_oo`<000Woo`03003ooooo03[o
o`04003ooooo000<ool004_oo`8000Woo`@003coo`03003ooooo03_oo`03003ooooo00Ooo`@003[o
o`8000goo`003ooo00<00?ooool0oooo6_oo000?ool00`00ooooo`3ooolJool000ooo`03003ooooo
0?oooa[oo`003ooo00<00?ooool0oooo6_oo0008oooo000N0006ool000ooo`03003ooooo00[oo`03
003ooooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03
003ooooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03
003ooooo00[oo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03003ooooo00[oo`03
003ooooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00_oo`00
3ooo00<00?ooool0@?oo00<00?ooool0@Ooo00<00?ooool0@Ooo00<00?ooool0@?oo00<00?ooool0
2ooo000?ool00`00ooooo`3ooolJool000ooo`03003ooooo0?oooa[oo`003ooo0P00oooo6ooo000?
ool00`00ooooo`3ooolJool000ooo`03003ooooo0?oooa[oo`003ooo00<00?ooool0oooo6_oo000?
ool00`00ooooo`3ooolJool000ooo`03003ooooo0?oooa[oo`003ooo0P00oooo6ooo000?ool00`00
ooooo`3ooolJool000ooo`03003ooooo0?oooa[oo`003ooo00<00?ooool0oooo6_oo000?ool00`00
ooooo`3ooolJool000ooo`800?oooa_oo`003ooo00<00?ooool0oooo6_oo000?ool00`00ooooo`3o
oolJool000ooo`03003ooooo0?oooa[oo`003ooo00<00?ooool0oooo6_oo000?ool2003ooolKool0
00ooo`03003ooooo0?oooa[oo`003ooo00<00?ooool0oooo6_oo0006ool40005ool00`00ooooo`3o
oolJool000Soo`03003ooooo00Coo`03003ooooo0?oooa[oo`002?oo00<00?ooool01?oo1`00oooo
5_oo0008ool00`00ooooo`04ool00`00ooooo`04oolQ003dool000Soo`03003ooooo00Coo`03003o
oooo02Goo``00>Soo`001_oo0`001_oo00<00?ooool0<Ooo2`00gOoo0008ool00`00ooooo`04ool0
0`00ooooo`0lool;003Bool000ooo`03003ooooo04Ooo`T00<Woo`003ooo0P00DOoo1P00`ooo000?
ool00`00ooooo`1Fool5002nool000ooo`03003ooooo05_oo`H00;Soo`003ooo00<00?ooool0HOoo
1@00/ooo000?ool00`00ooooo`1Vool6002]ool000ooo`8006goo`D00:Soo`003ooo00<00?ooool0
LOoo1000Y?oo000?ool00`00ooooo`1eool4002Pool000ooo`03003ooooo07Woo`<009goo`003ooo
00<00?ooool0O?oo1000VOoo000?ool20021ool4002Eool000ooo`03003ooooo08Coo`<009;oo`00
3ooo00<00?ooool0Qooo1000S_oo000?ool00`00ooooo`2;ool4002:ool000ooo`03003ooooo08oo
o`<008Ooo`003ooo00<00?ooool0T_oo0`00Q?oo000?ool2002Fool30021ool000ooo`03003ooooo
09Soo`<007koo`003ooo00<00?ooool0Vooo0`00Nooo0006ool40005ool00`00ooooo`2Nool2001i
ool000Koo`03003ooooo00Koo`03003ooooo0:3oo`8007Ooo`001ooo00<00?ooool01Ooo0`00X_oo
0P00MOoo0008ool00`00ooooo`04ool00`00ooooo`2Tool2001cool000Woo`03003ooooo00?oo`03
003ooooo0:Koo`<0073oo`001_oo00@00?ooool000Goo`03003ooooo0:Woo`8006koo`001ooo0P00
1_oo00<00?ooool0Zooo0P00K?oo000?ool2002^ool2001Zool000ooo`03003ooooo0:ooo`8006So
o`003ooo00<00?ooool0/Ooo0P00I_oo000?ool00`00ooooo`2cool2001Tool000ooo`03003ooooo
0;Goo`8006;oo`003ooo00<00?ooool0]ooo00<00?ooool0Gooo000?ool2002iool2001Oool000oo
o`03003ooooo0;[oo`8005goo`003ooo00<00?ooool0_?oo0P00Fooo000?ool00`00ooooo`2nool0
0`00ooooo`1Hool000ooo`03003ooooo0;ooo`8005Soo`003ooo0P00`_oo00<00?ooool0EOoo000?
ool00`00ooooo`32ool2001Eool000ooo`03003ooooo0<Coo`8005?oo`003ooo00<00?ooool0a_oo
00<00?ooool0D?oo000?ool00`00ooooo`37ool2001@ool000ooo`800<[oo`03003ooooo04goo`00
3ooo00<00?ooool0b_oo00<00?ooool0C?oo000?ool00`00ooooo`3;ool2001<ool000Ooo`8000Ko
o`03003ooooo0<goo`03003ooooo04Woo`001_oo00@00?ooool000Goo`03003ooooo0<koo`03003o
oooo04Soo`002Ooo00<00?ooool00ooo0`00cooo00<00?ooool0Aooo0007ool20006ool00`00oooo
o`3@ool00`00ooooo`16ool000Woo`03003ooooo00?oo`03003ooooo0=7oo`8004Koo`001_oo00@0
0?ooool000Goo`03003ooooo0=?oo`03003ooooo04?oo`001ooo0P001_oo00<00?ooool0e?oo00<0
0?ooool0@_oo000?ool00`00ooooo`3Eool00`00ooooo`11ool000ooo`800=Ooo`03003ooooo043o
o`003ooo00<00?ooool0eooo00<00?ooool0?ooo000?ool00`00ooooo`3Hool00`00ooooo`0nool0
00ooo`03003ooooo0=Woo`03003ooooo03goo`003ooo00<00?ooool0f_oo00<00?ooool0??oo000?
ool2003Lool00`00ooooo`0kool000ooo`03003ooooo0=coo`03003ooooo03[oo`003ooo00<00?oo
ool0gOoo00<00?ooool0>Ooo000?ool00`00ooooo`3Nool00`00ooooo`0hool000ooo`03003ooooo
0=ooo`03003ooooo03Ooo`003ooo0P00hOoo00<00?ooool0=_oo000?ool00`00ooooo`3Qool00`00
ooooo`0eool000ooo`03003ooooo0>;oo`03003ooooo03Coo`003ooo00<00?ooool0h_oo00<00?oo
ool0=?oo000?ool00`00ooooo`3Sool00`00ooooo`0cool000ooo`03003ooooo0>Coo`03003ooooo
03;oo`003ooo0P00i_oo00<00?ooool0<Ooo000?ool00`00ooooo`3Vool00`00ooooo`0`ool000oo
o`03003ooooo0>Ooo`03003ooooo02ooo`002?oo00<00?ooool01?oo00<00?ooool0iooo00<00?oo
ool0;ooo0008ool00`00ooooo`04ool00`00ooooo`3Xool00`00ooooo`0^ool000Goo`D000Goo`<0
0>Woo`03003ooooo02goo`001Ooo00@00?ooool000Koo`03003ooooo0>[oo`03003ooooo02coo`00
1_oo00<00?oo00001_oo00<00?ooool0jooo00<00?ooool0:ooo0007ool20006ool00`00ooooo`3[
ool00`00ooooo`0[ool000Soo`03003ooooo00Coo`03003ooooo0>coo`03003ooooo02[oo`003ooo
0P00k_oo00<00?ooool0:Ooo000?ool00`00ooooo`3^ool00`00ooooo`0Xool000ooo`03003ooooo
0>koo`03003ooooo02Soo`003ooo00<00?ooool0kooo00<00?ooool09ooo000?ool00`00ooooo`3`
ool00`00ooooo`0Vool000ooo`800?;oo`03003ooooo02Goo`003ooo00<00?ooool0lOoo00<00?oo
ool09Ooo000?ool00`00ooooo`3bool00`00ooooo`0Tool000ooo`03003ooooo0??oo`03003ooooo
02?oo`003ooo00<00?ooool0m?oo00<00?ooool08_oo000?ool00`00ooooo`3dool00`00ooooo`0R
ool000ooo`800?Koo`03003ooooo027oo`003ooo00<00?ooool0m_oo00<00?ooool08?oo000?ool0
0`00ooooo`3gool00`00ooooo`0Oool000ooo`03003ooooo0?Ooo`03003ooooo01ooo`003ooo00<0
0?ooool0n?oo00<00?ooool07_oo000?ool2003iool00`00ooooo`0Nool000ooo`03003ooooo0?Wo
o`03003ooooo01goo`003ooo00<00?ooool0nOoo00<00?ooool07Ooo0006ool30006ool00`00oooo
o`3jool00`00ooooo`0Lool000Woo`03003ooooo00?oo`03003ooooo0?[oo`03003ooooo01coo`00
2Ooo00<00?ooool00ooo0`00nooo00<00?ooool06ooo0006ool30006ool00`00ooooo`3kool00`00
ooooo`0Kool000Koo`03003ooooo00Koo`03003ooooo0?coo`03003ooooo01[oo`001_oo00<00?oo
ool01_oo00<00?ooool0oOoo00<00?ooool06Ooo0006ool40005ool00`00ooooo`3mool00`00oooo
o`0Iool000ooo`03003ooooo0?koo`03003ooooo01Soo`003ooo0P00oooo00<00?ooool06?oo000?
ool00`00ooooo`3oool00`00ooooo`0Gool000ooo`03003ooooo0?ooo`03003ooooo01Ooo`003ooo
00<00?ooool0oooo0Ooo00<00?ooool05_oo000?ool00`00ooooo`3oool1ool00`00ooooo`0Fool0
00ooo`800?ooo`?oo`03003ooooo01Goo`003ooo00<00?ooool0oooo0_oo00<00?ooool05Ooo000?
ool00`00ooooo`3oool3ool00`00ooooo`0Dool000ooo`03003ooooo0?ooo`?oo`03003ooooo01Co
o`003ooo00<00?ooool0oooo1?oo00<00?ooool04ooo000?ool2003oool5ool00`00ooooo`0Cool0
00ooo`03003ooooo0?ooo`Coo`03003ooooo01?oo`003ooo00<00?ooool0oooo1Ooo00<00?ooool0
4_oo000?ool00`00ooooo`3oool5ool00`00ooooo`0Bool000ooo`03003ooooo0?ooo`Koo`03003o
oooo017oo`003ooo0P00oooo1ooo00<00?ooool04Ooo000?ool00`00ooooo`3oool7ool00`00oooo
o`0@ool000ooo`03003ooooo0?ooo`Ooo`03003ooooo013oo`003ooo00<00?ooool0oooo1ooo00<0
0?ooool04?oo0007ool20006ool00`00ooooo`3oool8ool00`00ooooo`0?ool000Koo`04003ooooo
0005ool00`00ooooo`3oool8ool00`00ooooo`0?ool000Koo`04003ooooo0005ool3003oool9ool0
0`00ooooo`0>ool000Koo`<000Koo`03003ooooo0?ooo`Woo`03003ooooo00koo`001_oo00<00?oo
ool01_oo00<00?ooool0oooo2Ooo00<00?ooool03_oo0006ool00`00ooooo`06ool00`00ooooo`3o
ool:ool00`00ooooo`0=ool000Ooo`<000Goo`03003ooooo0?ooo`[oo`03003ooooo00goo`003ooo
0P00oooo3?oo00<00?ooool03?oo000?ool00`00ooooo`3oool;ool00`00ooooo`0<ool000ooo`03
003ooooo0?ooo`coo`03003ooooo00_oo`003ooo00<00?ooool0oooo3?oo00<00?ooool02ooo000?
ool00`00ooooo`3ooolJool000ooo`800?oooa_oo`003ooo00<00?ooool0oooo6_oo000?ool00`00
ooooo`3ooolJool00001\
\>"],
  ImageRangeCache->{{{74.875, 373.312}, {362.938, 178.875}} -> {-0.665702, \
6.28414, 0.00738716, 0.037783}},
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell["Here is a simple boundary value problem. ", "MathCaption",
  CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[{y''[x] + x y[x] == 0, y[0] == 1, y[1] == -1},
     y, {x, 0, 1}]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["NDSolve", "MR"],
  " to solve systems of coupled differential equations as long as each \
variable has the appropriate number of conditions. "
}], "Text",
  CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"}],

Cell["\<\
This finds a numerical solution to a pair of coupled equations. \
\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = \ 
      NDSolve[{\(x''\)[t]\  \[Equal] \ 
            y[t]\ x[t], \ \(y'\)[
              t]\  \[Equal] \ \(-\(1\/\(x[t]\^2 + y[t]\^2\)\)\), \ 
          x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0, \ 
          y[0]\  \[Equal] \ 0}, {x, y}, \ {t, 0, 100}]\)], "Input",
  CellLabel->"In[84]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 100.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 100.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[84]="]
}, Open  ]],

Cell["Here is a plot of both solutions. ", "MathCaption",
  CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[Evaluate[{x[t], \ y[t]}\  /. \ %], \ {t, 0, 100}, \ 
        PlotRange \[Rule] All, \ PlotPoints \[Rule] 200];\)\)], "Input",
  CellLabel->"In[85]:=",
  CellTags->{"b:1", "ndsg:0"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00952381 0.526359 0.07696 [
[.21429 .51386 -6 -9 ]
[.21429 .51386 6 0 ]
[.40476 .51386 -6 -9 ]
[.40476 .51386 6 0 ]
[.59524 .51386 -6 -9 ]
[.59524 .51386 6 0 ]
[.78571 .51386 -6 -9 ]
[.78571 .51386 6 0 ]
[.97619 .51386 -9 -9 ]
[.97619 .51386 9 0 ]
[.01131 .0646 -12 -4.5 ]
[.01131 .0646 0 4.5 ]
[.01131 .21852 -12 -4.5 ]
[.01131 .21852 0 4.5 ]
[.01131 .37244 -12 -4.5 ]
[.01131 .37244 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .52636 m
.21429 .53261 L
s
[(20)] .21429 .51386 0 1 Mshowa
.40476 .52636 m
.40476 .53261 L
s
[(40)] .40476 .51386 0 1 Mshowa
.59524 .52636 m
.59524 .53261 L
s
[(60)] .59524 .51386 0 1 Mshowa
.78571 .52636 m
.78571 .53261 L
s
[(80)] .78571 .51386 0 1 Mshowa
.97619 .52636 m
.97619 .53261 L
s
[(100)] .97619 .51386 0 1 Mshowa
.125 Mabswid
.07143 .52636 m
.07143 .53011 L
s
.11905 .52636 m
.11905 .53011 L
s
.16667 .52636 m
.16667 .53011 L
s
.2619 .52636 m
.2619 .53011 L
s
.30952 .52636 m
.30952 .53011 L
s
.35714 .52636 m
.35714 .53011 L
s
.45238 .52636 m
.45238 .53011 L
s
.5 .52636 m
.5 .53011 L
s
.54762 .52636 m
.54762 .53011 L
s
.64286 .52636 m
.64286 .53011 L
s
.69048 .52636 m
.69048 .53011 L
s
.7381 .52636 m
.7381 .53011 L
s
.83333 .52636 m
.83333 .53011 L
s
.88095 .52636 m
.88095 .53011 L
s
.92857 .52636 m
.92857 .53011 L
s
.25 Mabswid
0 .52636 m
1 .52636 L
s
.02381 .0646 m
.03006 .0646 L
s
[(-6)] .01131 .0646 1 0 Mshowa
.02381 .21852 m
.03006 .21852 L
s
[(-4)] .01131 .21852 1 0 Mshowa
.02381 .37244 m
.03006 .37244 L
s
[(-2)] .01131 .37244 1 0 Mshowa
.125 Mabswid
.02381 .10308 m
.02756 .10308 L
s
.02381 .14156 m
.02756 .14156 L
s
.02381 .18004 m
.02756 .18004 L
s
.02381 .257 m
.02756 .257 L
s
.02381 .29548 m
.02756 .29548 L
s
.02381 .33396 m
.02756 .33396 L
s
.02381 .41092 m
.02756 .41092 L
s
.02381 .4494 m
.02756 .4494 L
s
.02381 .48788 m
.02756 .48788 L
s
.02381 .02612 m
.02756 .02612 L
s
.02381 .56484 m
.02756 .56484 L
s
.02381 .60332 m
.02756 .60332 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.5 Mabswid
.02381 .60332 m
.02395 .60332 L
.02408 .60332 L
.02423 .60332 L
.02437 .60332 L
.0245 .60331 L
.02462 .60331 L
.02475 .60331 L
.02489 .6033 L
.02503 .60329 L
.02518 .60328 L
.02546 .60325 L
.02562 .60323 L
.02578 .60321 L
.02608 .60315 L
.02636 .60307 L
.02667 .60297 L
.02722 .60274 L
.02788 .60234 L
.02847 .60185 L
.02912 .60116 L
.02973 .60036 L
.03109 .59792 L
.03228 .59494 L
.03355 .59089 L
.03592 .58066 L
.03813 .56801 L
.04282 .5335 L
.04521 .51431 L
.04781 .49486 L
.04902 .48697 L
.05031 .47978 L
.0514 .47479 L
.05262 .4707 L
.05321 .46929 L
.05353 .46868 L
.05383 .46823 L
.05409 .46793 L
.05422 .46781 L
.05437 .46769 L
.05452 .4676 L
.05467 .46754 L
.05482 .4675 L
.05495 .4675 L
.05509 .46751 L
.05525 .46755 L
.0554 .46762 L
.05553 .46771 L
.05569 .46784 L
.05586 .46801 L
Mistroke
.05617 .46842 L
.0565 .46897 L
.05684 .4697 L
.05747 .47136 L
.05871 .47604 L
.06005 .48297 L
.06249 .49968 L
.06744 .54174 L
.06991 .56089 L
.07111 .56854 L
.07221 .5742 L
.07275 .57649 L
.07334 .57856 L
.0739 .58008 L
.07442 .58111 L
.0747 .58152 L
.07497 .5818 L
.07512 .58191 L
.07526 .58199 L
.07541 .58204 L
.07549 .58205 L
.07557 .58206 L
.07565 .58205 L
.07573 .58204 L
.07588 .58199 L
.07603 .58191 L
.07612 .58184 L
.0762 .58178 L
.07649 .58146 L
.07679 .581 L
.07739 .57971 L
.07793 .57811 L
.07916 .57305 L
.08029 .56672 L
.08137 .55944 L
.08599 .51989 L
.08832 .49983 L
.08956 .49063 L
.0909 .48245 L
.09152 .4794 L
.09217 .47675 L
.09273 .47496 L
.09305 .47414 L
.09334 .47353 L
.09364 .47304 L
.09391 .47271 L
.09407 .47257 L
.09421 .47248 L
.09436 .47242 L
.09444 .4724 L
Mistroke
.09453 .47239 L
.09467 .4724 L
.0948 .47244 L
.09495 .47251 L
.0951 .47262 L
.09535 .47289 L
.09563 .47331 L
.09594 .4739 L
.09627 .47471 L
.09688 .4766 L
.09801 .48155 L
.09933 .48945 L
.10054 .4984 L
.1053 .54114 L
.1077 .56068 L
.10875 .56749 L
.10988 .57329 L
.11051 .57569 L
.11079 .57655 L
.11109 .57737 L
.11136 .57796 L
.11165 .57846 L
.11181 .57868 L
.11195 .57885 L
.11209 .57897 L
.11224 .57907 L
.1124 .57913 L
.11254 .57915 L
.11262 .57915 L
.11271 .57914 L
.11286 .57908 L
.11301 .57898 L
.11317 .57885 L
.11344 .5785 L
.11377 .57793 L
.11407 .57724 L
.11476 .57513 L
.11536 .57268 L
.11602 .56939 L
.11721 .56194 L
.11945 .54387 L
.12202 .51976 L
.12436 .49903 L
.12553 .49026 L
.12614 .48628 L
.12679 .48264 L
.12736 .47996 L
.12799 .4776 L
.12826 .47676 L
.12856 .47601 L
Mistroke
.12881 .47548 L
.12908 .47502 L
.12925 .47482 L
.1294 .47467 L
.12955 .47455 L
.12964 .4745 L
.12972 .47447 L
.12987 .47445 L
.13003 .47447 L
.13018 .47452 L
.13032 .47461 L
.1304 .47468 L
.13049 .47477 L
.13066 .47497 L
.13096 .47546 L
.13132 .47625 L
.13165 .47717 L
.13222 .47916 L
.13283 .48193 L
.13408 .48925 L
.13643 .50804 L
.13896 .53191 L
.14134 .55348 L
.1426 .56294 L
.14329 .56728 L
.14394 .57073 L
.14456 .57341 L
.14513 .5753 L
.14543 .57609 L
.14576 .57674 L
.14591 .57699 L
.14608 .57721 L
.14618 .57731 L
.14627 .57738 L
.14635 .57744 L
.14644 .57749 L
.14658 .57755 L
.14673 .57756 L
.14687 .57753 L
.14701 .57748 L
.14716 .57737 L
.1473 .57723 L
.14747 .57702 L
.14762 .57678 L
.14816 .57562 L
.14846 .57474 L
.14875 .57377 L
.15002 .56775 L
.15122 .55985 L
.15347 .54079 L
Mistroke
.15569 .51936 L
.15812 .49744 L
.15929 .48892 L
.16053 .48188 L
.16122 .47907 L
.16185 .47724 L
.16215 .47661 L
.16231 .47634 L
.16248 .47612 L
.16263 .47596 L
.1627 .4759 L
.16279 .47584 L
.16294 .47577 L
.16307 .47575 L
.16323 .47576 L
.16336 .47581 L
.16352 .47591 L
.16367 .47605 L
.16394 .47641 L
.16423 .47695 L
.16455 .47772 L
.16489 .47875 L
.16549 .48109 L
.16671 .48762 L
.16804 .49727 L
.17291 .54303 L
.17515 .56163 L
.17577 .56568 L
.17642 .56934 L
.17699 .57194 L
.1776 .57411 L
.17792 .57499 L
.17822 .57562 L
.17851 .57606 L
.17865 .57622 L
.17881 .57635 L
.1789 .57641 L
.17899 .57644 L
.17907 .57646 L
.17915 .57647 L
.17924 .57646 L
.17934 .57644 L
.17942 .5764 L
.17951 .57635 L
.17967 .57621 L
.17984 .57601 L
.18016 .5755 L
.18047 .5748 L
.1808 .57384 L
.18142 .57153 L
Mistroke
.18258 .56541 L
.18383 .55656 L
.18495 .54693 L
.18748 .5224 L
.19 .49897 L
.1911 .49054 L
.19169 .48676 L
.19232 .48331 L
.19293 .4806 L
.19349 .47872 L
.19375 .47803 L
.19405 .47744 L
.19418 .47723 L
.19432 .47704 L
.19444 .47691 L
.19458 .4768 L
.19473 .47672 L
.19489 .47669 L
.19502 .4767 L
.19517 .47675 L
.19525 .4768 L
.19533 .47686 L
.1955 .47703 L
.19566 .47724 L
.19581 .47748 L
.1961 .47808 L
.19637 .47878 L
.19697 .48085 L
.19753 .4834 L
.19814 .48676 L
.19923 .49427 L
.20172 .51649 L
.2041 .54013 L
.20536 .55167 L
.2067 .56212 L
.20737 .56643 L
.20801 .56979 L
.20857 .57219 L
.20887 .57319 L
.20919 .5741 L
.20949 .57476 L
.20977 .57522 L
.20993 .5754 L
.21007 .57552 L
.21015 .57557 L
.21024 .57561 L
.21039 .57565 L
.21052 .57564 L
.21067 .57558 L
.21082 .57548 L
Mistroke
.21096 .57534 L
.21122 .57499 L
.21149 .57446 L
.2118 .5737 L
.21213 .57268 L
.21271 .57033 L
.21341 .56672 L
.21404 .56274 L
.21646 .54252 L
.21898 .51748 L
.22008 .50684 L
.22129 .49633 L
.22238 .48846 L
.22298 .48492 L
.22355 .48215 L
.22386 .4809 L
.2242 .47975 L
.22448 .47896 L
.22479 .47828 L
.22508 .47782 L
.22524 .47764 L
.22538 .47752 L
.22552 .47745 L
.22565 .47742 L
.22579 .47743 L
.22594 .47748 L
.22609 .47758 L
.22617 .47766 L
.22625 .47774 L
.22654 .47817 L
.22681 .47871 L
.22709 .47945 L
.22767 .48148 L
.22832 .48448 L
.22946 .4916 L
.23053 .50005 L
.23521 .54562 L
.23643 .55628 L
.23708 .56116 L
.23776 .56567 L
.23842 .56924 L
.23902 .57177 L
.23931 .57274 L
.23962 .57359 L
.23992 .57422 L
.24019 .57463 L
.24034 .57479 L
.24048 .5749 L
.24061 .57496 L
.24075 .57499 L
Mistroke
.24091 .57497 L
.24099 .57494 L
.24107 .57489 L
.24122 .57477 L
.24136 .57461 L
.24164 .57418 L
.24189 .57364 L
.24246 .57195 L
.24304 .56955 L
.24367 .5662 L
.24495 .55738 L
.24752 .53373 L
.24985 .51024 L
.25101 .49961 L
.25227 .48993 L
.25285 .48632 L
.25346 .48315 L
.25399 .48102 L
.25428 .48005 L
.25456 .47932 L
.25486 .4787 L
.25502 .47845 L
.2551 .47835 L
.25519 .47825 L
.25527 .47817 L
.25535 .47812 L
.2555 .47804 L
.25564 .47802 L
.25579 .47804 L
.25592 .47809 L
.25606 .4782 L
.2562 .47834 L
.25632 .4785 L
.25662 .47903 L
.25691 .47972 L
.25754 .48182 L
.25812 .48447 L
.25943 .49273 L
.26169 .51258 L
.26417 .53787 L
.26651 .55887 L
.26719 .56363 L
.26783 .56744 L
.2684 .5702 L
.26903 .57245 L
.26934 .57325 L
.2695 .57359 L
.26967 .57389 L
.26982 .5741 L
.2699 .57419 L
Mistroke
.26999 .57427 L
.27014 .57437 L
.27028 .57443 L
.27042 .57444 L
.27058 .57439 L
.27073 .5743 L
.27087 .57417 L
.27099 .57402 L
.27113 .57382 L
.2714 .57328 L
.27173 .57242 L
.27203 .57144 L
.27271 .56854 L
.2733 .56525 L
.27393 .56109 L
.27631 .54036 L
.27853 .5177 L
.28079 .49663 L
.28141 .4919 L
.28206 .48755 L
.28263 .48442 L
.28324 .48176 L
.28357 .48064 L
.28387 .47982 L
.28402 .47949 L
.28417 .47919 L
.28432 .47896 L
.28446 .47878 L
.28455 .4787 L
.28464 .47863 L
.28472 .47858 L
.2848 .47855 L
.28489 .47853 L
.28498 .47852 L
.28507 .47854 L
.28516 .47857 L
.28525 .47862 L
.28533 .47868 L
.28548 .47884 L
.28564 .47906 L
.28581 .47936 L
.2861 .48002 L
.28642 .48096 L
.28707 .48353 L
.28768 .48667 L
.28824 .49023 L
.29068 .51101 L
.29291 .53391 L
.29411 .54582 L
.29539 .55706 L
Mistroke
.29601 .5617 L
.2966 .56549 L
.29712 .56832 L
.2977 .57081 L
.29797 .57174 L
.29826 .57256 L
.29842 .57293 L
.29856 .57322 L
.29871 .57347 L
.29885 .57366 L
.29897 .57379 L
.29911 .57389 L
.29924 .57395 L
.29939 .57397 L
.29952 .57395 L
.29966 .57388 L
.29979 .57377 L
.29991 .57365 L
.30005 .57345 L
.30019 .5732 L
.30046 .57262 L
.30078 .57173 L
.30107 .57072 L
.3017 .56791 L
.3023 .56453 L
.30347 .55607 L
.30471 .54499 L
.30693 .52229 L
.30816 .50987 L
.30932 .49916 L
.31045 .49042 L
.3115 .48429 L
.31204 .48199 L
.31232 .48105 L
.31262 .48023 L
.31279 .47985 L
.31295 .47956 L
.3131 .47934 L
.31318 .47924 L
.31326 .47915 L
.31341 .47904 L
.31354 .47898 L
.3137 .47896 L
.31384 .47899 L
.314 .47908 L
.31408 .47915 L
.31416 .47924 L
.31432 .47944 L
.31446 .47968 L
.31478 .48039 L
Mistroke
.31513 .48142 L
.31577 .48398 L
.31636 .48708 L
.31754 .49527 L
.31864 .50481 L
.32114 .53016 L
.3234 .55234 L
.32468 .56232 L
.32528 .56611 L
.32585 .569 L
.32645 .5713 L
.32676 .5722 L
.3271 .57292 L
.32727 .57318 L
.32736 .57329 L
.32746 .57339 L
.32755 .57346 L
.32763 .57351 L
.32772 .57354 L
.32779 .57356 L
.32795 .57355 L
.3281 .57348 L
.32817 .57343 L
.32826 .57336 L
.32843 .57316 L
.32859 .57291 L
.32874 .57261 L
.32903 .57191 L
.32935 .57094 L
.32968 .56965 L
.33086 .56332 L
.33199 .55478 L
.33325 .54328 L
.33578 .51704 L
.33708 .50421 L
.33832 .49371 L
.33943 .48639 L
.34006 .48331 L
.34064 .48121 L
.34093 .48045 L
.34109 .48013 L
.34125 .47984 L
.34139 .47965 L
.34155 .47949 L
.34169 .4794 L
.34183 .47935 L
.34197 .47935 L
.3421 .47939 L
.34222 .47946 L
.34235 .47958 L
Mistroke
.34249 .47974 L
.34263 .47998 L
.3429 .48052 L
.34319 .48128 L
.34349 .48231 L
.34405 .48469 L
.34471 .48836 L
.34531 .49247 L
.3476 .5128 L
.35009 .53882 L
.35131 .55059 L
.35245 .56005 L
.35309 .56435 L
.35378 .56814 L
.35408 .56949 L
.3544 .5707 L
.35468 .57156 L
.35498 .57229 L
.35514 .57259 L
.35529 .57281 L
.35543 .57298 L
.35557 .5731 L
.35572 .57318 L
.35586 .5732 L
.35598 .57318 L
.35612 .57312 L
.35627 .573 L
.35635 .57291 L
.35643 .57281 L
.35675 .57223 L
.35704 .57154 L
.35734 .57058 L
.35793 .56812 L
.3585 .56509 L
.35955 .55779 L
.36195 .53527 L
.36418 .51199 L
.36526 .50158 L
.36643 .49206 L
.3671 .48766 L
.36771 .48441 L
.3683 .48206 L
.36859 .48118 L
.36876 .48076 L
.36891 .48044 L
.36906 .48019 L
.36922 .47997 L
.3693 .47989 L
.36938 .47981 L
.36947 .47975 L
Mistroke
.36955 .47971 L
.36963 .47969 L
.36972 .47969 L
.36987 .47972 L
.37002 .4798 L
.37016 .47993 L
.37029 .4801 L
.37042 .48029 L
.3707 .48088 L
.37098 .48164 L
.37128 .48266 L
.37192 .48552 L
.3726 .48947 L
.37381 .49864 L
.3784 .54499 L
.37961 .55596 L
.38076 .56426 L
.3814 .56776 L
.38173 .56926 L
.38208 .57058 L
.38238 .57146 L
.38254 .57184 L
.38271 .57219 L
.38287 .57244 L
.38301 .57262 L
.38315 .57276 L
.38329 .57284 L
.38344 .57287 L
.38352 .57287 L
.3836 .57285 L
.38374 .57278 L
.38389 .57265 L
.38403 .57248 L
.38416 .57229 L
.38444 .5717 L
.38475 .57085 L
.38504 .56987 L
.38568 .56701 L
.38681 .55979 L
.38789 .55085 L
.39252 .50379 L
.39375 .49337 L
.3949 .48596 L
.39548 .48329 L
.39581 .48212 L
.39611 .48127 L
.39642 .48062 L
.39659 .48035 L
.39675 .48017 L
.39684 .48009 L
Mistroke
.39693 .48004 L
.39708 .48 L
.39717 .48 L
.39725 .48001 L
.39734 .48005 L
.39744 .48011 L
.39758 .48025 L
.39774 .48046 L
.39803 .481 L
.39831 .48172 L
.39857 .48256 L
.39917 .48503 L
.3998 .48852 L
.40096 .49695 L
.402 .50641 L
.40453 .53273 L
.40563 .54412 L
.40684 .55525 L
.40741 .55973 L
.40802 .56388 L
.40854 .56687 L
.40911 .56945 L
.40944 .57061 L
.40975 .57146 L
.41005 .57204 L
.4102 .57226 L
.41028 .57235 L
.41036 .57243 L
.41051 .57253 L
.41064 .57257 L
.41079 .57257 L
.41095 .57251 L
.41109 .5724 L
.41123 .57223 L
.41137 .57202 L
.4115 .57179 L
.41178 .57115 L
.41209 .57022 L
.41271 .56768 L
.41328 .56455 L
.41382 .56102 L
.41633 .53845 L
.41857 .51461 L
.41976 .5029 L
.42102 .49242 L
.42165 .48821 L
.42235 .48453 L
.42265 .48326 L
.42298 .48213 L
.42329 .48131 L
Mistroke
.42358 .48077 L
.42372 .48057 L
.42387 .48041 L
.42401 .48032 L
.42414 .48028 L
.42429 .48029 L
.42438 .48031 L
.42446 .48036 L
.4246 .48048 L
.42476 .48066 L
.4249 .4809 L
.42506 .48121 L
.42535 .48192 L
.42569 .48303 L
.426 .48429 L
.42719 .49106 L
.42829 .49977 L
.43079 .52495 L
.43306 .54845 L
.43426 .55872 L
.43491 .56331 L
.43552 .56682 L
.43616 .56963 L
.4365 .57073 L
.43667 .57118 L
.43686 .57159 L
.43703 .57188 L
.43711 .57198 L
.43719 .57208 L
.43735 .57222 L
.43743 .57227 L
.43751 .5723 L
.43766 .57231 L
.43779 .57227 L
.43794 .57218 L
.4381 .57202 L
.43825 .5718 L
.43839 .57156 L
.4387 .57083 L
.43899 .56995 L
.43926 .56893 L
.43987 .56603 L
.44053 .56197 L
.44168 .55298 L
.44293 .54093 L
.44547 .51392 L
.44668 .50206 L
.44782 .49259 L
.44845 .48837 L
.44914 .48473 L
Mistroke
.44944 .48347 L
.44976 .48237 L
.45006 .48156 L
.45034 .48103 L
.45048 .48083 L
.45062 .48068 L
.45077 .48058 L
.45085 .48055 L
.45093 .48053 L
.45108 .48055 L
.45117 .48059 L
.45125 .48064 L
.4514 .48077 L
.45155 .48097 L
.45183 .48148 L
.45208 .48212 L
.45267 .48419 L
.4533 .48733 L
.45388 .49096 L
.45518 .50144 L
.45766 .5269 L
.45997 .55057 L
.46112 .5601 L
.46168 .5639 L
.4622 .56682 L
.46279 .56942 L
.46311 .57044 L
.46327 .57087 L
.46344 .57126 L
.46359 .57152 L
.46372 .57172 L
.46385 .57188 L
.46398 .57198 L
.46413 .57205 L
.46426 .57206 L
.46441 .57202 L
.46457 .57192 L
.46471 .57177 L
.46486 .57156 L
.46516 .57096 L
.46544 .5702 L
.4657 .56932 L
.46629 .56673 L
.46692 .56309 L
.46808 .55435 L
.46912 .54457 L
.47163 .51791 L
.47273 .50658 L
.47395 .4957 L
.47451 .49148 L
Mistroke
.47511 .48763 L
.47568 .48474 L
.4762 .48276 L
.4765 .48191 L
.47678 .48133 L
.47695 .48109 L
.47709 .48093 L
.47717 .48086 L
.47726 .48081 L
.47735 .48078 L
.47742 .48077 L
.47756 .48079 L
.47769 .48085 L
.47783 .48097 L
.47799 .48116 L
.47815 .48142 L
.4783 .48172 L
.47858 .48246 L
.47914 .48446 L
.47975 .48752 L
.48099 .49616 L
.48321 .51761 L
.48574 .54461 L
.48685 .5549 L
.48744 .55957 L
.48806 .56384 L
.48868 .56723 L
.48924 .56953 L
.48952 .57037 L
.48966 .57074 L
.48981 .57107 L
.48994 .57131 L
.49009 .57152 L
.49022 .57167 L
.49034 .57176 L
.49049 .57183 L
.49057 .57184 L
.49065 .57183 L
.49079 .57177 L
.49095 .57166 L
.49108 .57151 L
.49121 .57132 L
.4915 .57074 L
.49181 .56987 L
.49209 .56887 L
.49274 .56588 L
.49331 .56245 L
.49392 .55803 L
.49501 .54843 L
.49751 .52218 L
Mistroke
.49991 .49821 L
.50056 .49296 L
.50126 .48831 L
.50185 .48517 L
.50219 .48377 L
.50251 .4827 L
.50281 .48192 L
.50298 .48159 L
.50314 .48134 L
.50328 .48117 L
.50341 .48107 L
.50356 .481 L
.50371 .48099 L
.50386 .48105 L
.50394 .4811 L
.50403 .48118 L
.50418 .48136 L
.50433 .48159 L
.50465 .4823 L
.505 .48335 L
.50562 .48601 L
.50622 .48937 L
.50733 .49764 L
.51195 .54524 L
.51318 .55647 L
.51434 .56462 L
.51492 .56763 L
.51521 .56886 L
.51554 .56996 L
.51588 .5708 L
.51606 .57114 L
.51615 .57127 L
.51623 .57138 L
.51631 .57146 L
.5164 .57153 L
.51654 .5716 L
.51662 .57162 L
.51671 .57162 L
.51687 .57157 L
.51702 .57146 L
.51718 .57128 L
.51733 .57105 L
.51747 .57078 L
.51773 .57013 L
.51801 .56925 L
.51865 .5665 L
.51923 .56317 L
.52037 .55462 L
.52144 .54461 L
.52366 .52079 L
Mistroke
.52492 .50755 L
.5261 .49676 L
.52726 .48842 L
.52791 .48503 L
.5282 .48385 L
.52851 .48284 L
.52866 .48242 L
.52883 .48202 L
.52899 .48173 L
.52913 .48151 L
.52921 .48142 L
.5293 .48133 L
.5294 .48126 L
.52949 .48122 L
.52957 .4812 L
.52966 .4812 L
.52981 .48125 L
.5299 .4813 L
.52997 .48136 L
.53015 .48157 L
.5303 .48181 L
.53046 .48214 L
.53074 .48286 L
.53105 .48389 L
.53168 .48674 L
.53228 .49031 L
.5334 .49897 L
.53592 .52463 L
.53812 .54785 L
.53937 .55875 L
.53998 .56305 L
.54054 .56628 L
.5411 .56875 L
.54138 .5697 L
.54169 .5705 L
.54185 .57083 L
.542 .57106 L
.54208 .57117 L
.54217 .57126 L
.54225 .57133 L
.54233 .57138 L
.54247 .57142 L
.54262 .57141 L
.54278 .57133 L
.54293 .5712 L
.54308 .571 L
.54325 .5707 L
.54356 .56997 L
.54387 .56901 L
.54415 .56791 L
Mistroke
.54478 .56472 L
.54546 .56031 L
.5467 .5499 L
.54804 .53626 L
.55048 .50993 L
.55172 .49812 L
.55288 .48943 L
.55347 .48614 L
.55377 .48477 L
.5541 .48354 L
.55428 .48296 L
.55445 .4825 L
.55461 .48214 L
.55479 .48183 L
.55495 .48162 L
.5551 .48148 L
.55526 .4814 L
.55535 .48139 L
.55543 .48139 L
.55558 .48145 L
.55573 .48157 L
.55586 .48172 L
.556 .48193 L
.55632 .48261 L
.55661 .48348 L
.55715 .48562 L
.55771 .48864 L
.5589 .49728 L
.56021 .50958 L
.56275 .53714 L
.56396 .5494 L
.56508 .55899 L
.56568 .56319 L
.56623 .5663 L
.56684 .5689 L
.56717 .56993 L
.56732 .57029 L
.56748 .57063 L
.56762 .57085 L
.56776 .57103 L
.56791 .57116 L
.56805 .57122 L
.5682 .57123 L
.56833 .5712 L
.56845 .57112 L
.56858 .57099 L
.56872 .5708 L
.56888 .57052 L
.56919 .56977 L
.56949 .56883 L
Mistroke
.56976 .56776 L
.57036 .56476 L
.57102 .56055 L
.57221 .55069 L
.57444 .52738 L
.57576 .51295 L
.57701 .50063 L
.57813 .4916 L
.57876 .48764 L
.57904 .48617 L
.57934 .48482 L
.57964 .48371 L
.57991 .48289 L
.58004 .48257 L
.58018 .48227 L
.58031 .48203 L
.58043 .48186 L
.58058 .4817 L
.58074 .4816 L
.58089 .48157 L
.58098 .48158 L
.58106 .48161 L
.58119 .48169 L
.58134 .48184 L
.58149 .48206 L
.58164 .48232 L
.58195 .4831 L
.58225 .48407 L
.58281 .4865 L
.58341 .48996 L
.58406 .49461 L
.58646 .51768 L
.58899 .54514 L
.59013 .55569 L
.59076 .56056 L
.59136 .56442 L
.59191 .56726 L
.5922 .56846 L
.59251 .56949 L
.5928 .57022 L
.59306 .57068 L
.59318 .57084 L
.59332 .57097 L
.59345 .57104 L
.59356 .57106 L
.59372 .57104 L
.59386 .57095 L
.59399 .57083 L
.59413 .57065 L
.59429 .57038 L
Mistroke
.59445 .57003 L
.59474 .56923 L
.59526 .56723 L
.59584 .56423 L
.59713 .55486 L
.59833 .54343 L
.60056 .51913 L
.60183 .50586 L
.603 .49531 L
.60361 .49087 L
.60418 .48741 L
.60449 .48583 L
.60483 .48439 L
.60514 .48336 L
.60543 .48262 L
.60557 .48232 L
.60573 .48207 L
.60582 .48196 L
.60591 .48188 L
.60599 .48182 L
.60607 .48177 L
.60615 .48175 L
.60624 .48174 L
.60634 .48176 L
.60642 .4818 L
.60658 .48192 L
.60667 .48202 L
.60675 .48213 L
.60703 .48265 L
.6072 .48304 L
.60735 .48347 L
.60797 .48591 L
.60858 .48921 L
.60924 .49375 L
.61044 .50413 L
.61268 .52801 L
.61502 .55235 L
.61567 .5578 L
.61636 .56275 L
.61701 .56643 L
.61761 .56888 L
.6179 .56973 L
.61806 .5701 L
.61821 .57039 L
.61835 .5706 L
.61851 .57076 L
.61864 .57085 L
.61877 .57089 L
.61892 .57088 L
.61907 .57081 L
Mistroke
.61922 .57067 L
.61931 .57056 L
.61939 .57044 L
.61955 .57015 L
.61972 .56976 L
.62004 .56883 L
.62062 .56643 L
.62124 .56295 L
.62236 .55458 L
.62691 .50687 L
.62805 .49642 L
.62867 .49169 L
.62925 .48804 L
.62987 .48498 L
.6302 .48378 L
.63037 .48327 L
.63056 .48281 L
.63073 .48247 L
.63088 .48223 L
.63103 .48206 L
.63119 .48195 L
.63133 .4819 L
.63146 .48191 L
.63161 .48198 L
.63176 .48212 L
.63184 .48222 L
.63192 .48233 L
.63207 .48259 L
.6324 .48338 L
.63268 .48429 L
.63298 .48551 L
.63368 .48917 L
.63432 .49353 L
.63674 .51657 L
.63921 .54358 L
.64042 .555 L
.64151 .56315 L
.64206 .5662 L
.64235 .56751 L
.64265 .56866 L
.64292 .56947 L
.64306 .56982 L
.64321 .57013 L
.64335 .57036 L
.64348 .57052 L
.64361 .57064 L
.64373 .57071 L
.64388 .57074 L
.64401 .57071 L
.64417 .57061 L
Mistroke
.64432 .57046 L
.64445 .57026 L
.64458 .57004 L
.64486 .56936 L
.64515 .56846 L
.64546 .56722 L
.6461 .56393 L
.64733 .55495 L
.64845 .54435 L
.65097 .51677 L
.65209 .50514 L
.65327 .49462 L
.65389 .4902 L
.65457 .48635 L
.65487 .48503 L
.65519 .48387 L
.6555 .48303 L
.65563 .48275 L
.65578 .48249 L
.65593 .48228 L
.65608 .48215 L
.65622 .48207 L
.65635 .48205 L
.65649 .48209 L
.65665 .48219 L
.65672 .48227 L
.65681 .48237 L
.65696 .48261 L
.65725 .48325 L
.65753 .48408 L
.65806 .4862 L
.65868 .4896 L
.65925 .49357 L
.66055 .50495 L
.66282 .52943 L
.66528 .55454 L
.66593 .55978 L
.66663 .56432 L
.66722 .56728 L
.66755 .56856 L
.66786 .56947 L
.66802 .56982 L
.66818 .57012 L
.66834 .57034 L
.66848 .57048 L
.66861 .57056 L
.66875 .57059 L
.6689 .57056 L
.66904 .57047 L
.66919 .57031 L
Mistroke
.66927 .57021 L
.66936 .57008 L
.66965 .56946 L
.66998 .56846 L
.6703 .56724 L
.67091 .56416 L
.67157 .55979 L
.67277 .54959 L
.67501 .52567 L
.67736 .50094 L
.67801 .49539 L
.6787 .49036 L
.67935 .48663 L
.67995 .48418 L
.68024 .48332 L
.68041 .48295 L
.68056 .48267 L
.68069 .48248 L
.68082 .48234 L
.68098 .48223 L
.68112 .4822 L
.68127 .48223 L
.68142 .48231 L
.68157 .48248 L
.68166 .4826 L
.68174 .48272 L
.68207 .48346 L
.68239 .48445 L
.68297 .48693 L
.6835 .48998 L
.68471 .49922 L
.68716 .52467 L
.68836 .53799 L
.68945 .54927 L
.69051 .55843 L
.69106 .56238 L
.69165 .56579 L
.69198 .56731 L
.69228 .56843 L
.69258 .56932 L
.69287 .56992 L
.69301 .57014 L
.69315 .5703 L
.69328 .57039 L
.69342 .57044 L
.69357 .57043 L
.69365 .5704 L
.69373 .57035 L
.69388 .57021 L
.69402 .57002 L
Mistroke
.69416 .56978 L
.6943 .56946 L
.69457 .56873 L
.69489 .5676 L
.69518 .56632 L
.69579 .563 L
.69642 .55857 L
.69864 .53736 L
.70105 .51073 L
.7021 .50037 L
.70324 .49127 L
.70387 .48745 L
.70415 .48608 L
.70445 .48482 L
.70472 .48392 L
.70501 .48317 L
.70517 .48286 L
.70532 .48264 L
.70546 .48248 L
.7056 .48238 L
.70576 .48234 L
.70591 .48236 L
.70599 .4824 L
.70607 .48247 L
.70623 .48264 L
.70638 .48287 L
.70653 .48317 L
.70681 .48389 L
.70714 .48499 L
.70744 .48629 L
.70813 .4901 L
.70939 .49992 L
.71059 .51175 L
.71283 .53661 L
.714 .54876 L
.71524 .55945 L
.71575 .56294 L
.71629 .56599 L
.71661 .56739 L
.7169 .56844 L
.71717 .56923 L
.71732 .56957 L
.71746 .56983 L
.71761 .57005 L
.71769 .57014 L
.71777 .57021 L
.71791 .57029 L
.71806 .57031 L
.7182 .57027 L
.71835 .57017 L
Mistroke
.71849 .57002 L
.71861 .56983 L
.71892 .5692 L
.71909 .56872 L
.71925 .56821 L
.71985 .56566 L
.72036 .56275 L
.72092 .55882 L
.72206 .54887 L
.72459 .52148 L
.7257 .50943 L
.72691 .49783 L
.72748 .49328 L
.72808 .48919 L
.72866 .48617 L
.72891 .4851 L
.72918 .48417 L
.72932 .48375 L
.72949 .48335 L
.72963 .48305 L
.72977 .48283 L
.72993 .48263 L
.73002 .48256 L
.7301 .48251 L
.73025 .48247 L
.73033 .48248 L
.73041 .4825 L
.73056 .4826 L
.7307 .48275 L
.73083 .48294 L
.73097 .4832 L
.73128 .48398 L
.73157 .48493 L
.73214 .48748 L
.73275 .49113 L
.73384 .49982 L
.73634 .52603 L
.73873 .55144 L
.73938 .55713 L
.74008 .5622 L
.74067 .56563 L
.74099 .5671 L
.74133 .56834 L
.74163 .56918 L
.74179 .56955 L
.74195 .56981 L
.7421 .56999 L
.74223 .57011 L
.74238 .57017 L
.74252 .57018 L
Mistroke
.74268 .57011 L
.74276 .57005 L
.74284 .56996 L
.743 .56975 L
.74314 .5695 L
.74346 .56871 L
.74381 .56753 L
.74443 .56459 L
.74503 .56088 L
.74614 .55183 L
.74856 .52612 L
.75075 .50265 L
.75134 .49733 L
.75198 .49236 L
.75253 .48879 L
.75313 .48576 L
.75346 .48451 L
.75377 .48362 L
.75394 .48324 L
.7541 .48298 L
.75419 .48286 L
.75428 .48276 L
.75437 .48268 L
.75445 .48263 L
.7546 .4826 L
.75473 .48262 L
.75488 .4827 L
.75496 .48278 L
.75504 .48287 L
.75519 .48309 L
.75536 .48342 L
.75566 .48421 L
.75597 .48529 L
.7563 .48674 L
.75691 .49011 L
.75804 .49871 L
.76056 .52509 L
.76292 .55039 L
.76357 .55614 L
.76426 .56137 L
.76491 .56528 L
.76551 .56788 L
.7658 .5688 L
.76596 .5692 L
.76612 .5695 L
.76625 .56971 L
.76638 .56988 L
.76654 .57 L
.76668 .57005 L
.76683 .57004 L
Mistroke
.76698 .56997 L
.76713 .56982 L
.76722 .56971 L
.7673 .56958 L
.76746 .56927 L
.76764 .56886 L
.76795 .56788 L
.76854 .56533 L
.76916 .56166 L
.77027 .55287 L
.77266 .52776 L
.77484 .5041 L
.77604 .49362 L
.77659 .48982 L
.77718 .48661 L
.77751 .48522 L
.77781 .48422 L
.77795 .48382 L
.77811 .48346 L
.77825 .48319 L
.77839 .48299 L
.77855 .48283 L
.77863 .48277 L
.77872 .48273 L
.77882 .48272 L
.77891 .48273 L
.77899 .48276 L
.77907 .48282 L
.77923 .48297 L
.77931 .48308 L
.7794 .48322 L
.7797 .48387 L
.77999 .48472 L
.7803 .48591 L
.78092 .48911 L
.78204 .49719 L
.78456 .52302 L
.78588 .53789 L
.78712 .55071 L
.78824 .56008 L
.78887 .56414 L
.78915 .56563 L
.78945 .56699 L
.78975 .56808 L
.79002 .56886 L
.79015 .56916 L
.79029 .56943 L
.79042 .56964 L
.79055 .56978 L
.79069 .56989 L
Mistroke
.79082 .56994 L
.79097 .56993 L
.79113 .56984 L
.79128 .56969 L
.79136 .56958 L
.79145 .56945 L
.79175 .56881 L
.79206 .56785 L
.79235 .56673 L
.793 .56339 L
.7936 .55935 L
.79417 .55478 L
.7988 .50548 L
.80004 .49443 L
.80064 .49017 L
.8012 .48706 L
.80148 .48581 L
.80178 .48468 L
.80194 .48418 L
.8021 .48378 L
.80225 .48346 L
.8024 .4832 L
.80249 .48308 L
.80258 .48299 L
.80266 .48292 L
.80274 .48287 L
.80289 .48284 L
.80297 .48284 L
.80305 .48287 L
.80314 .48292 L
.80322 .48299 L
.80338 .48318 L
.80355 .48347 L
.80373 .48388 L
.80402 .48469 L
.80432 .48582 L
.80487 .48851 L
.80552 .49271 L
.80612 .49743 L
.80865 .52359 L
.80985 .53713 L
.81113 .55039 L
.81175 .55594 L
.81234 .56047 L
.81286 .56383 L
.81316 .56543 L
.81343 .56671 L
.81373 .56782 L
.81399 .56863 L
.81428 .56927 L
Mistroke
.81443 .56952 L
.81458 .56969 L
.81471 .56978 L
.81484 .56982 L
.81497 .56981 L
.81509 .56976 L
.81523 .56965 L
.81537 .56947 L
.81551 .56924 L
.81564 .56898 L
.81593 .56821 L
.8162 .56729 L
.8168 .56444 L
.8174 .56073 L
.81803 .55585 L
.82043 .53143 L
.82169 .51711 L
.82303 .50306 L
.82422 .49291 L
.8249 .48854 L
.82522 .48686 L
.82553 .48553 L
.82581 .48456 L
.82595 .48414 L
.82611 .48376 L
.82626 .48347 L
.82639 .48327 L
.82652 .48311 L
.82664 .48301 L
.82679 .48295 L
.82694 .48296 L
.82707 .48303 L
.82722 .48316 L
.82737 .48336 L
.82754 .48367 L
.82784 .48442 L
.82815 .48547 L
.82848 .48688 L
.82907 .49014 L
.8304 .50058 L
.83283 .52647 L
.83398 .53947 L
.8352 .55183 L
.83624 .56038 L
.83683 .56412 L
.83738 .5668 L
.83768 .56792 L
.83797 .56873 L
.83823 .56926 L
.83837 .56947 L
Mistroke
.8385 .5696 L
.83865 .56969 L
.83878 .56971 L
.83893 .56968 L
.83909 .56957 L
.83917 .56948 L
.83926 .56937 L
.83941 .56911 L
.83971 .56841 L
.84004 .56733 L
.84034 .56608 L
.84101 .56239 L
.84222 .553 L
.84474 .52623 L
.84585 .51377 L
.84706 .50138 L
.84763 .49639 L
.84823 .49179 L
.84875 .48853 L
.84932 .4858 L
.84966 .48462 L
.8498 .4842 L
.84997 .48382 L
.85011 .48354 L
.85026 .48332 L
.85035 .48322 L
.85042 .48315 L
.85057 .48307 L
.85071 .48306 L
.85084 .4831 L
.85098 .48319 L
.85113 .48337 L
.85129 .48362 L
.85144 .48392 L
.85171 .48467 L
.852 .48569 L
.85227 .48685 L
.85289 .49024 L
.85413 .49988 L
.85636 .52337 L
.8586 .54803 L
.85921 .55381 L
.85987 .55916 L
.86043 .56299 L
.86104 .56621 L
.86137 .56752 L
.86167 .56844 L
.86196 .56908 L
.8621 .5693 L
.86226 .56948 L
Mistroke
.86235 .56955 L
.86243 .56959 L
.86251 .56961 L
.86259 .56961 L
.86268 .56958 L
.86278 .56953 L
.86286 .56946 L
.86295 .56936 L
.86311 .56913 L
.86329 .56878 L
.8636 .56794 L
.86391 .56682 L
.86425 .56529 L
.86487 .5617 L
.86603 .55251 L
.8686 .52497 L
.87093 .50018 L
.87209 .49095 L
.87241 .48898 L
.87275 .48719 L
.87304 .4859 L
.87336 .48478 L
.87351 .48434 L
.87365 .48399 L
.87379 .48371 L
.87392 .4835 L
.87404 .48334 L
.87417 .48323 L
.8743 .48317 L
.87445 .48317 L
.8746 .48323 L
.87475 .48335 L
.8749 .48356 L
.87507 .48385 L
.87534 .48453 L
.87565 .48554 L
.87628 .4885 L
.87689 .4923 L
.87801 .50164 L
.88054 .52905 L
.88275 .55248 L
.88335 .55765 L
.884 .5623 L
.88462 .5657 L
.88489 .56688 L
.88518 .5679 L
.88534 .56836 L
.88548 .56871 L
.88563 .569 L
.88577 .56921 L
Mistroke
.88592 .56939 L
.88601 .56945 L
.8861 .56949 L
.88624 .5695 L
.88633 .56948 L
.88641 .56944 L
.88656 .56932 L
.8867 .56913 L
.88683 .56891 L
.88697 .56862 L
.88729 .56774 L
.88757 .56667 L
.88816 .5638 L
.88881 .55958 L
.89011 .5482 L
.89265 .52015 L
.89376 .50799 L
.89497 .49656 L
.89554 .49218 L
.89615 .48838 L
.89644 .48689 L
.89672 .48571 L
.89697 .48485 L
.89725 .48412 L
.8974 .48381 L
.89754 .48358 L
.89768 .48341 L
.89784 .4833 L
.89799 .48326 L
.89813 .48329 L
.89826 .48337 L
.8984 .48351 L
.89854 .48372 L
.89871 .48404 L
.89904 .48493 L
.89935 .48605 L
.89964 .48735 L
.90021 .49055 L
.90082 .49498 L
.90207 .50636 L
.9043 .53122 L
.90552 .54461 L
.90666 .55553 L
.9073 .56046 L
.90799 .56469 L
.90829 .56615 L
.90861 .56742 L
.90889 .56826 L
.90904 .56863 L
.90919 .56892 L
Mistroke
.90934 .56914 L
.90949 .5693 L
.90958 .56936 L
.90966 .56939 L
.90982 .5694 L
.90997 .56934 L
.9101 .56922 L
.91025 .56902 L
.91041 .56874 L
.91069 .56807 L
.91095 .56724 L
.91153 .56463 L
.91217 .56074 L
.91275 .55632 L
.91405 .54397 L
.91655 .51583 L
.91765 .50419 L
.91823 .49873 L
.91886 .4936 L
.91946 .48954 L
.92002 .48666 L
.92029 .48555 L
.92055 .48472 L
.92081 .48406 L
.92095 .4838 L
.9211 .48359 L
.92118 .4835 L
.92126 .48344 L
.92141 .48337 L
.92157 .48337 L
.92166 .4834 L
.92175 .48346 L
.9219 .48362 L
.92204 .48382 L
.9222 .48413 L
.92235 .4845 L
.92263 .48536 L
.92289 .48637 L
.92348 .48937 L
.9241 .49347 L
.92476 .49889 L
.92597 .5108 L
.92821 .53625 L
.92946 .54944 L
.93062 .55946 L
.93121 .56334 L
.93184 .56648 L
.9322 .56777 L
.93237 .56826 L
.93253 .56863 L
Mistroke
.93268 .5689 L
.93284 .56911 L
.93299 .56925 L
.93308 .56929 L
.93317 .56931 L
.93332 .56929 L
.9334 .56925 L
.93348 .56919 L
.93363 .56903 L
.93376 .56881 L
.93393 .56849 L
.93408 .56811 L
.93442 .56702 L
.935 .56439 L
.93561 .56062 L
.93667 .55191 L
.93784 .53999 L
.94039 .51114 L
.9416 .49913 L
.94272 .49053 L
.94327 .4874 L
.94356 .48613 L
.94387 .48503 L
.94403 .48457 L
.94418 .48422 L
.94433 .48393 L
.94447 .48372 L
.94462 .48356 L
.9447 .4835 L
.94479 .48347 L
.94488 .48345 L
.94496 .48346 L
.94504 .48349 L
.94512 .48354 L
.94527 .48368 L
.9454 .48387 L
.94554 .48414 L
.9457 .4845 L
.94602 .48546 L
.94631 .4866 L
.94687 .48948 L
.94741 .493 L
.94856 .5029 L
.9498 .5159 L
.95202 .54113 L
.95326 .55354 L
.95391 .55893 L
.9546 .56352 L
.95521 .5665 L
.95555 .56771 L
Mistroke
.95572 .56817 L
.95587 .56853 L
.95601 .56879 L
.95617 .56901 L
.95631 .56914 L
.95643 .5692 L
.95657 .56922 L
.95673 .56916 L
.9568 .56911 L
.95689 .56903 L
.95704 .56883 L
.95719 .56856 L
.95733 .56825 L
.95764 .56735 L
.95792 .56626 L
.95819 .56501 L
.9588 .56147 L
.95946 .55658 L
.962 .53045 L
.96436 .50433 L
.965 .4983 L
.96569 .49278 L
.96635 .48863 L
.96694 .48587 L
.96724 .4849 L
.9674 .48447 L
.96755 .48414 L
.96768 .48392 L
.96782 .48374 L
.96797 .4836 L
.96811 .48355 L
.96827 .48356 L
.96841 .48363 L
.96856 .48379 L
.96865 .48391 L
.96873 .48404 L
.96889 .48436 L
.96907 .4848 L
.96939 .48583 L
.96997 .48851 L
.97059 .49238 L
.9717 .50162 L
.97619 .55047 L
Mfstroke
.02381 .52636 m
.02847 .4909 L
.03355 .45967 L
.03832 .43498 L
.04291 .41503 L
.0478 .39894 L
.0525 .38755 L
.0575 .37758 L
.06232 .36853 L
.06695 .36015 L
.07188 .35227 L
.07662 .34565 L
.08119 .33958 L
.08604 .3332 L
.09072 .32749 L
.09569 .32199 L
.10048 .31687 L
.10509 .31198 L
.10999 .30711 L
.11471 .30274 L
.11972 .29815 L
.12456 .29381 L
.1292 .2899 L
.13415 .28589 L
.13891 .28204 L
.14349 .27847 L
.14837 .27486 L
.15306 .27143 L
.15805 .26782 L
.16285 .26452 L
.16748 .26142 L
.17239 .25812 L
.17713 .25505 L
.18168 .25221 L
.18653 .24919 L
.1912 .24633 L
.19616 .24341 L
.20094 .24063 L
.20553 .23797 L
.21043 .23524 L
.21513 .23265 L
.22014 .22991 L
.22496 .22735 L
.2296 .22494 L
.23454 .22237 L
.23929 .21996 L
.24386 .2177 L
.24872 .21528 L
.2534 .213 L
.25838 .21065 L
Mistroke
.26318 .20837 L
.26779 .20622 L
.2727 .20399 L
.27742 .20184 L
.28244 .19959 L
.28728 .19748 L
.29194 .19544 L
.29689 .1933 L
.30166 .1913 L
.30624 .18936 L
.31113 .18733 L
.31582 .18542 L
.32082 .18339 L
.32563 .18145 L
.33026 .17963 L
.33518 .17769 L
.33993 .17584 L
.34449 .1741 L
.34934 .17225 L
.35401 .17049 L
.35898 .16865 L
.36377 .16687 L
.36837 .16519 L
.37327 .16342 L
.37798 .16172 L
.38299 .15994 L
.38782 .15825 L
.39247 .15662 L
.39741 .15492 L
.40217 .15329 L
.40674 .15173 L
.41161 .15009 L
.4163 .14853 L
.42129 .14687 L
.42609 .1453 L
.43071 .14379 L
.43562 .14219 L
.44035 .14069 L
.4449 .13923 L
.44975 .1377 L
.45441 .13625 L
.45937 .1347 L
.46414 .13322 L
.46873 .13182 L
.47362 .13033 L
.47833 .12891 L
.48333 .12741 L
.48814 .12597 L
.49278 .12461 L
.49771 .12316 L
Mistroke
.50246 .12177 L
.50702 .12045 L
.51189 .11905 L
.51656 .11771 L
.52154 .1163 L
.52633 .11495 L
.53094 .11366 L
.53584 .11229 L
.54056 .11098 L
.54558 .10961 L
.55042 .10829 L
.55507 .10702 L
.56002 .10569 L
.56478 .10441 L
.56936 .10319 L
.57424 .1019 L
.57893 .10066 L
.58393 .09936 L
.58873 .0981 L
.59336 .09691 L
.59828 .09564 L
.60302 .09443 L
.60757 .09327 L
.61242 .09204 L
.61709 .09086 L
.62206 .08963 L
.62684 .08843 L
.63144 .08729 L
.63633 .08609 L
.64104 .08493 L
.64605 .08372 L
.65087 .08254 L
.65551 .08142 L
.66045 .08024 L
.66521 .0791 L
.66978 .07802 L
.67465 .07687 L
.67933 .07577 L
.68431 .0746 L
.68911 .07348 L
.69372 .07242 L
.69863 .07128 L
.70336 .0702 L
.70839 .06905 L
.71323 .06795 L
.71788 .0669 L
.72284 .06578 L
.72761 .06471 L
.7322 .06369 L
.73708 .0626 L
Mistroke
.74178 .06156 L
.74678 .06047 L
.75159 .05941 L
.75622 .0584 L
.76115 .05733 L
.7659 .0563 L
.77046 .05533 L
.77532 .05428 L
.77999 .05329 L
.78496 .05223 L
.78975 .05122 L
.79435 .05025 L
.79925 .04922 L
.80397 .04823 L
.80898 .04719 L
.81381 .04619 L
.81846 .04523 L
.82341 .04421 L
.82817 .04324 L
.83274 .04231 L
.83762 .04132 L
.84231 .04037 L
.8473 .03936 L
.8521 .0384 L
.85672 .03748 L
.86164 .0365 L
.86637 .03556 L
.87092 .03466 L
.87577 .03371 L
.88044 .03279 L
.8854 .03182 L
.89017 .03089 L
.89477 .03 L
.89966 .02906 L
.90437 .02815 L
.90937 .02719 L
.91419 .02627 L
.91883 .02539 L
.92376 .02445 L
.92851 .02355 L
.93308 .02269 L
.93794 .02178 L
.94262 .02091 L
.9476 .01998 L
.95239 .01909 L
.957 .01824 L
.96191 .01733 L
.96663 .01646 L
.97165 .01555 L
.97619 .01472 L
Mistroke
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[85]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`003ooo00<00?ooool0oooo3ooo000?ool00`00ooooo`3oool?ool000ooo`03003o
oooo0?ooo`ooo`003ooo00<00?ooool0oooo3ooo000?ool00`00ooooo`3oool2ool40009ool000oo
o`03003ooooo0?coo`D000goo`003ooo00<00?ooool0m_oo1P004_oo000?ool2003bool5000Hool0
00ooo`03003ooooo0>coo`D001goo`003ooo00<00?ooool0i_oo1P008_oo000?ool00`00ooooo`3Q
ool5000Xool000ooo`03003ooooo0=goo`@002goo`003ooo00<00?ooool0f?oo1@00<Ooo000?ool0
0`00ooooo`3Cool5000fool000ooo`03003ooooo0<ooo`@003_oo`003ooo00<00?ooool0b_oo1@00
?ooo0007ool30005ool00`00ooooo`36ool40014ool000Ooo`04003ooooo0004ool00`00ooooo`30
ool60018ool000Ooo`04003ooooo0004ool3002lool4001>ool00003ool00000008000;oo`<000Go
o`03003ooooo0;Ooo`D005;oo`002?oo00<00?ooool01?oo00<00?ooool0/ooo1000Eooo0008ool3
0004ool00`00ooooo`2_ool4001Kool000ooo`03003ooooo0:_oo`@005ooo`003ooo00<00?ooool0
Yooo1000Hooo000?ool00`00ooooo`2Sool4001Wool000ooo`03003ooooo09ooo`@006_oo`003ooo
00<00?ooool0Vooo1000Kooo000?ool00`00ooooo`2Gool4001cool000ooo`8009Coo`@007Ooo`00
3ooo00<00?ooool0Sooo1000Nooo000?ool00`00ooooo`2;ool4001oool000ooo`03003ooooo08Wo
o`8008?oo`003ooo00<00?ooool0QOoo1000QOoo000?ool00`00ooooo`21ool40029ool000ooo`03
003ooooo07koo`<008goo`003ooo00<00?ooool0N_oo1000T?oo000?ool00`00ooooo`1hool2002D
ool000ooo`03003ooooo07Coo`@009Koo`003ooo00<00?ooool0LOoo0`00V_oo000?ool2001^ool4
002Mool000ooo`03003ooooo06_oo`800:7oo`003ooo00<00?ooool0J?oo0`00Xooo000?ool00`00
ooooo`1Uool3002Vool000ooo`03003ooooo067oo`@00:Woo`003ooo00<00?ooool0Gooo0P00[Ooo
000?ool00`00ooooo`1Lool3002_ool000ooo`03003ooooo05Woo`<00;;oo`003ooo00<00?ooool0
Eooo0P00]Ooo000?ool00`00ooooo`1Dool3002gool000ooo`8005;oo`<00;[oo`003ooo00<00?oo
ool0Cooo0P00_Ooo000?ool00`00ooooo`1<ool3002oool000ooo`03003ooooo04_oo`03003ooooo
0<3oo`003ooo00<00?ooool0B?oo0`00`ooo000?ool00`00ooooo`16ool20036ool000ooo`03003o
oooo04?oo`<00<Soo`003ooo00<00?ooool0@_oo00<00?ooool0bOoo000?ool00`00ooooo`0oool3
003<ool000Woo`<000?oo`03003ooooo03koo`03003ooooo0<goo`002_oo00<00?ooool00_oo00<0
0?ooool0>ooo0`00d?oo0007ool50003ool3000hool3003Cool00003ool00000008000;oo`04003o
oooo0004ool00`00ooooo`0gool00`00ooooo`3Dool000Soo`03003oo`0000Coo`03003ooooo03Ko
o`03003ooooo0=Goo`002Ooo0P001?oo00<00?ooool0<ooo0`00f?oo000?ool00`00ooooo`0bool0
0`00ooooo`3Iool000ooo`03003ooooo02ooo`<00=coo`003ooo00<00?ooool0;_oo00<00?ooool0
gOoo000?ool00`00ooooo`0/ool2003Pool000ooo`03003ooooo02_oo`03003ooooo0>3oo`003ooo
00<00?ooool0:?oo0`00hooo000?ool00`00ooooo`0Wool00`00ooooo`3Tool000ooo`8002Ooo`03
003ooooo0>Goo`003ooo00<00?ooool09Ooo00<00?ooool0i_oo000?ool00`00ooooo`0Sool2003Y
ool000ooo`03003ooooo02;oo`03003ooooo0>Woo`003ooo00<00?ooool08Ooo00<00?ooool0j_oo
000?ool00`00ooooo`0Oool2003]ool000ooo`03003ooooo01koo`03003ooooo0>goo`003ooo00<0
0?ooool07Ooo00<00?ooool0k_oo000?ool00`00ooooo`0Kool2003aool000ooo`03003ooooo01[o
o`03003ooooo0?7oo`003ooo0P006_oo00<00?ooool0l_oo000?ool00`00ooooo`0Gool2003eool0
00ooo`03003ooooo01Koo`03003ooooo0?Goo`003ooo00<00?ooool05Ooo00<00?ooool0m_oo000?
ool00`00ooooo`0Eool00`00ooooo`3fool000ooo`03003ooooo01?oo`800?Woo`003ooo00<00?oo
ool04_oo00<00?ooool0nOoo000?ool00`00ooooo`0Aool00`00ooooo`3jool000ooo`03003ooooo
017oo`03003ooooo0?[oo`003ooo00<00?ooool03ooo0P00oOoo000?ool00`00ooooo`0>ool00`00
ooooo`3mool000ooo`8000ooo`03003ooooo0?goo`003ooo00<00?ooool03Ooo00<00?ooool0o_oo
000?ool00`00ooooo`0<ool00`00ooooo`3oool000ooo`03003ooooo00coo`03003ooooo0?ooo`00
3ooo00<00?ooool02ooo00<00?ooool0oooo0Ooo000?ool00`00ooooo`0:ool00`00ooooo`3oool2
ool000ooo`03003ooooo00Woo`03003ooooo0?ooo`?oo`003ooo00<00?ooool02Ooo00<00?ooool0
oooo0ooo000?ool00`00ooooo`08ool00`00ooooo`3oool4ool000Ooo`@000Coo`03003ooooo00So
o`03003ooooo0?ooo`Coo`001ooo00<00?ooool01Ooo00<00?ooool01ooo00<00?ooool0oooo1Ooo
0008ool00`00ooooo`04ool30007ool00`00ooooo`3oool5ool00003ool00000008000Coo`03003o
oooo00?oo`03003ooooo00Koo`03003ooooo0?ooo`Koo`001ooo00@00?ooool000Coo`03003ooooo
00Koo`03003ooooo0?ooo`Koo`002?oo0P001Ooo00<00?ooool01Ooo00<00?ooool0oooo1ooo000?
ool00`00ooooo`05ool00`00ooooo`3oool7ool000ooo`03003ooooo00Goo`03003ooooo0?ooo`Oo
o`003ooo00<00?ooool01?oo00<00?ooool0oooo2?oo000?ool00`00ooooo`04ool00`00ooooo`3o
ool8ool000ooo`03003ooooo00?oo`03003ooooo0?ooo`Woo`003ooo00<00?ooool00ooo00<00?oo
ool0oooo2Ooo000?ool20003ool00`00ooooo`3oool:ool000ooo`03003ooooo00;oo`03003ooooo
0?ooo`[oo`003ooo00<00?ooool00_oo00<00?ooool0oooo2_oo000?ool00`00ooooo`02ool00`00
ooooo`3oool:ool000ooo`05003oooooool0003oool=ool000ooo`05003oooooool0003oool=ool0
00ooo`05003oooooool0003oool=ool000ooo`05003oooooool0003oool=ool000ooo`05003ooooo
ool0003oool=ool000ooo`05003oooooool0003oool=ool000ooo`05003oooooool0003oool=ool0
00ooo`800003ool00?oo0?ooo`goo`003ooo00@00?ooool00?ooo`koo`003ooo00@00?ooool00?oo
o`koo`003ooo00@00?ooool00?ooo`koo`003ooo00@00?ooool000Goo`03003ooooo0?ooo`Koo`00
3ooo00<00?oo00001Ooo0P00oooo2?oo000?ool00`00ool00005ool20009ool20008ool2003bool0
00ooo`03003oo`0000Goo`03003oo`0000Soo`8000Soo`8000Ooo`8000Ooo`03003ooooo00Koo`03
003ooooo00Goo`03003ooooo0<koo`003ooo00<00?oo00001?oo00@00?ooool000Soo`8000Ooo`<0
00Ooo`8000Ooo`8000Koo`8000Koo`8000Ooo`03003ooooo00Coo`8000Koo`8000Koo`8000Koo`03
003ooooo00Coo`8000Koo`03003ooooo00Coo`03003ooooo00Coo`8000Goo`8000Koo`03003ooooo
00Coo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo05ooo`003ooo0P00
1Ooo00@00?ooool000Ooo`03003oo`0000Ooo`03003oo`0000Ooo`8000Koo`03003oo`0000Koo`80
00Koo`<000Goo`03003oo`0000Goo`8000Koo`8000Koo`8000Goo`8000Koo`8000Goo`8000Koo`03
003ooooo00Coo`8000Goo`8000Goo`8000Goo`8000Goo`8000Goo`8000Goo`8000Goo`8000Goo`03
003ooooo00?oo`8000Goo`8000Goo`03003ooooo00?oo`8000Goo`8000Goo`03003ooooo00?oo`80
00Goo`03003ooooo00?oo`8000Goo`03003ooooo00?oo`8000_oo`003ooo0P001Ooo00@00?ooool0
00Ooo`03003oo`0000Ooo`03003oo`0000Koo`03003oo`0000Koo`D000?oo`<000Koo`03003oo`00
00Goo`03003oo`0000Goo`03003oo`0000Goo`8000Koo`8000Goo`<000;oo`800003ool0000000Go
o`8000Goo`03003oo`0000Goo`8000Goo`8000Goo`8000Coo`<000Coo`<000Goo`8000Goo`8000Go
o`8000Coo`8000Goo`8000Goo`8000?oo`<000?oo`@000Goo`8000Goo`03003ooooo00?oo`8000Co
o`8000Goo`8000Coo`/000Coo`8000?oo`003ooo0P001Ooo00@00?ooool000Ooo`04003ooooo0006
ool00`00ool00006ool00`00ool00006ool30004ool00`00ool000020005ool00`00ool00005ool0
0`00ool00005ool00`00ool00005ool20005ool00`00ool00005ool300001ooo003ooooo003oo`00
00Goo`03003oo`0000Coo`03003oo`0000Coo`03003oo`0000Goo`8000Goo`8000Coo`@000;oo`04
003oo`000005ool20005ool20004ool00`00ool00004ool00`00ool00004ool20005ool20002ool0
0`00ool0000200001?oo003ooooo0P001Ooo0P001?oo00<00?oo00001?oo0P001?oo00<00?oo0000
1?oo0P001?oo0P000_oo00<00?ooool00P000_oo00@00?ooool000;oo`40007oo`7oo`003ooo0P00
1Ooo00D00?ooooooo`0000Koo`04003ooooo0006ool00`00ool00006ool01000ooooo`001Ooo00<0
0?oo00001?oo0P0000?oo`0000001Ooo00<00?oo00001Ooo00<00?oo00001Ooo00<00?oo00001Ooo
00<00?oo00001?oo00<00?oo00000ooo1@0000Ooo`00ooooo`00ool00005ool00`00ool00004ool0
0`00ool00004ool00`00ool00004ool00`00ool00004ool00`00ool00004ool40002ool01000ool0
00001Ooo0P001?oo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo0P001Ooo0P000_oo
00<00?oo00000P0000Coo`00ooooo`8000Goo`8000Coo`03003oo`0000Coo`8000Coo`03003oo`00
00Coo`8000Coo`05003oo`00ool00002ool20002ool01000ooooo`000_oo0@000Ooo0Ooo000?ool2
0005ool01@00oooooooo00001_oo00@00?ooool000Koo`03003oo`0000Koo`04003ooooo0005ool0
1000ool000000ooo0P0000?oo`0000001Ooo00<00?oo00001Ooo00<00?oo00001Ooo00<00?oo0000
1Ooo00<00?oo00001?oo00<00?oo00000ooo00<00?oo00000P0000Ooo`00ooooo`00ool00005ool0
0`00ool00004ool00`00ool00004ool00`00ool00004ool00`00ool00004ool00`00ool00004ool3
0003ool01000ool000001Ooo0P001?oo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo
00<00?oo00001?oo0P000ooo0P0000Coo`00ool000;oo`03003oo`0000Coo`8000Coo`03003oo`00
00?oo`03003oo`0000Coo`03003oo`0000Coo`8000Coo`09003oo`00ool00?oo003oo`0000;oo`04
003ooooo0002ool10001ool1ool000ooo`8000Goo`05003oooooool00006ool01000ooooo`001_oo
00@00?ooool000Goo`04003ooooo0005ool300001?oo003ooooo0P0000?oo`0000001Ooo00<00?oo
00001Ooo00<00?oo00001Ooo00<00?oo00001?oo00@00?ooool000Coo`03003oo`0000Coo`@00007
ool00?ooool00?oo00001Ooo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo00<00?oo
00001?oo00<00?oo00001?oo0`000ooo0P0000?oo`0000001?oo0P001?oo00<00?oo00001?oo00<0
0?oo00001?oo00<00?oo00001?oo00<00?oo00000ooo00<00?oo00000_oo00<00?oo00000P0000Oo
o`00ooooo`00ool00003ool00`00ool00004ool00`00ool00003ool00`00ool00004ool00`00ool0
0003ool00`00ool00004ool02@00ool00?oo003oo`00ool00002ool01000ooooo`000_oo0@000Ooo
0Ooo000?ool20004ool00`00ooooo`02ool00`00ooooo`04ool01000ooooo`001_oo00@00?ooool0
00Goo`04003ooooo0005ool01000ool000001?oo0P0000?oo`00ool01?oo00@00?ooool000Coo`04
003ooooo0003ool01000ooooo`001?oo00@00?ooool000Coo`03003oo`0000Goo`<000;oo`<00003
ool00?oo00Coo`03003oo`0000Coo`03003oo`0000Coo`03003oo`0000Coo`03003oo`0000Coo`04
003ooooo0003ool40003ool200000ooo003oo`02ool00`00ool00004ool00`00ool00004ool00`00
ool00004ool00`00ool00003ool01000ooooo`000ooo00<00?oo00000ooo0P0000Coo`00ooooo`<0
0003ool00?oo00;oo`03003oo`0000Coo`03003oo`0000?oo`03003oo`0000Coo`03003oo`0000?o
o`03003oo`0000Coo`03003oo`0000800003ool00?oo00<000Coo`8000?oo`003ooo00<00?ooool0
0ooo00<00?ooool00_oo00<00?ooool01?oo00@00?ooool000Goo`05003oooooool00004ool01@00
oooooooo00001Ooo00@00?ooool000Coo`04003ooooo0004ool01@00oooooooo00000ooo00D00?oo
ooooo`0000?oo`04003ooooo0004ool01000ooooo`001?oo00<00?oo00001Ooo00<00?oo00001?oo
00<00?oo00001?oo00@00?ooool000Coo`03003oo`0000Coo`03003oo`0000Coo`03003oo`0000Co
o`04003ooooo0003ool01000ooooo`000ooo00@00?ooool000?oo`04003ooooo0003ool00`00ool0
0004ool00`00ool00004ool00`00ool00003ool01000ooooo`000ooo00<00?oo00001?oo00<00?oo
00001?oo00<00?oo00000ooo00<00?oo00001?oo00<00?oo00000ooo00<00?oo00001?oo00<00?oo
00000ooo00@00?ooool000?oo`03003oo`0000?oo`03003oo`0000_oo`003ooo00<00?ooool00ooo
00<00?ooool00_oo00<00?ooool00ooo00D00?ooooooo`0000Goo`05003oooooool00004ool01@00
oooooooo00001?oo00D00?ooooooo`0000Coo`04003ooooo0004ool01@00oooooooo00000ooo00D0
0?ooooooo`0000?oo`04003ooooo0004ool01000ooooo`001?oo00@00?ooool000Coo`03003oo`00
00Coo`03003oo`0000Coo`04003ooooo0003ool01@00oooooooo00000ooo00@00?ooool000?oo`04
003ooooo0003ool01000ooooo`000ooo00@00?ooool000?oo`04003ooooo0003ool01000ooooo`00
0ooo00<00?oo00001?oo00@00?ooool000?oo`03003oo`0000?oo`04003ooooo0003ool00`00ool0
0004ool01000ooooo`000ooo00<00?oo00000ooo00<00?oo00001?oo00<00?oo00000ooo00<00?oo
00001?oo00<00?oo00000ooo00@00?ooool000?oo`03003oo`0000?oo`03003oo`0000_oo`003ooo
00<00?ooool00ooo00<00?ooool00_oo00<00?ooool00ooo00D00?ooooooo`0000Goo`05003ooooo
ool00004ool01@00oooooooo00001?oo00D00?ooooooo`0000Coo`04003ooooo0004ool01@00oooo
oooo00000ooo00D00?ooooooo`0000?oo`04003ooooo0004ool01000ooooo`001?oo00@00?ooool0
00Coo`03003oo`0000Coo`04003ooooo0003ool01@00oooooooo00000_oo00D00?ooooooo`0000?o
o`04003ooooo0003ool01000ooooo`000ooo00@00?ooool000?oo`04003ooooo0003ool01000oooo
o`000ooo00@00?ooool000?oo`03003oo`0000?oo`05003oooooool00003ool00`00ool00003ool0
1000ooooo`000ooo00@00?ooool000;oo`05003oooooool00003ool00`00ool00003ool01000oooo
o`000ooo00<00?oo00000ooo00<00?oo00000ooo00@00?ooool000?oo`04003ooooo0003ool00`00
ool00003ool01000ooooo`002_oo000?ool00`00ooooo`03ool00`00ooooo`02ool00`00ooooo`03
ool01@00oooooooo00001Ooo00D00?ooooooo`0000Coo`05003oooooool00004ool01@00oooooooo
00001?oo00@00?ooool000Coo`05003oooooool00003ool01@00oooooooo00000ooo00D00?oooooo
o`0000?oo`04003ooooo0004ool01000ooooo`000ooo00@00?ooool000Coo`04003ooooo0003ool0
1@00oooooooo00000_oo00D00?ooooooo`0000?oo`04003ooooo0003ool01000ooooo`000ooo00@0
0?ooool000?oo`04003ooooo0003ool01000ooooo`000ooo00@00?ooool000?oo`04003ooooo0002
ool01@00oooooooo00000ooo00<00?oo00000ooo00@00?ooool000?oo`04003ooooo0002ool01@00
oooooooo00000_oo00@00?ooool000?oo`04003ooooo0002ool01000ooooo`000ooo00@00?ooool0
00;oo`05003oooooool00002ool01000ooooo`000ooo00<00?oo00000ooo00@00?ooool000[oo`00
3ooo00<00?ooool00ooo00<00?ooool00ooo00<00?ooool00_oo00<00?ooool00_oo00<00?ooool0
0_oo00<00?ooool00_oo00D00?ooooooo`0000Coo`05003oooooool00003ool00`00ooooo`02ool0
1000ooooo`001?oo00D00?ooooooo`0000?oo`05003oooooool00003ool01@00oooooooo00000ooo
00@00?ooool000?oo`05003oooooool00003ool01@00oooooooo00000ooo00@00?ooool000?oo`05
003oooooool00002ool01@00oooooooo00000ooo00@00?ooool000?oo`04003ooooo0002ool01@00
oooooooo00000ooo00@00?ooool000?oo`04003ooooo0003ool01000ooooo`000ooo00@00?ooool0
00;oo`05003oooooool00003ool00`00ool00003ool01000ooooo`000ooo00@00?ooool000;oo`05
003oooooool00002ool01000ooooo`000ooo00@00?ooool000;oo`04003ooooo0003ool01000oooo
o`000_oo00D00?ooooooo`0000;oo`04003ooooo0003ool00`00ool00003ool01000ooooo`002_oo
0008oooo000F0003ool000ooo`03003ooooo00;oo`03003ooooo00Coo`8000?oo`03003ooooo00;o
o`04003oooooool20004ool01@00oooooooo00000_oo00<00?oo00000ooo00<00?ooool00_oo00@0
0?oo000000Coo`05003oooooool00003ool01@00oooooooo00000ooo00@00?ooooooo`8000;oo`04
003ooooo0004ool01000ool000000ooo00D00?ooooooo`0000?oo`04003ooooo0003ool01000oooo
o`000_oo00<00?oo00000_oo00D00?ooooooo`0000?oo`04003ooooo0003ool01000ooooo`000_oo
00<00?ooool00_oo00@00?ooool000;oo`05003oo`00ool00002ool01@00oooooooo00000_oo00@0
0?oo000000?oo`04003ooooo0003ool200000ooo003oo`02ool01000ooooo`000_oo0P000_oo00@0
0?ooool000;oo`05003oooooool00002ool01000ooooo`000ooo00@00?ooool000;oo`04003ooooo
0003ool01000ooooo`000_oo00L00?ooooooo`00ool00003ool01000ooooo`000ooo00@00?ooool0
00;oo`8000Woo`003ooo00<00?ooool00_oo00<00?ooool01?oo00<00?ooool00_oo00<00?ooool0
0_oo00D00?ooooooo`0000Goo`05003oooooool00004ool01@00oooooooo00001?oo00@00?oo0000
00Coo`05003oooooool00003ool01@00oooooooo00000ooo00@00?ooool000Coo`04003ooooo0004
ool01000ooooo`001?oo00@00?ooool000?oo`04003ooooo0003ool01000ooooo`001?oo00@00?oo
ool000?oo`05003oooooool00003ool00`00ool00003ool01000ooooo`001?oo00@00?ooool000?o
o`<000?oo`04003ooooo0004ool00`00ool00003ool01000ooooo`000ooo00@00?ooool000?oo`04
003ooooo0002ool01@00oooooooo00000_oo00@00?ooool000?oo`04003ooooo0003ool01000oooo
o`000_oo00@00?ooool000;oo`05003oooooool00002ool01000ooooo`000ooo00<00?oo00000ooo
00@00?ooool000?oo`04003ooooo0002ool20009ool000ooo`03003ooooo00;oo`03003ooooo00Co
o`03003ooooo00;oo`03003ooooo00;oo`05003oooooool00005ool01@00oooooooo00001?oo00@0
0?ooool000Goo`04003ooooo0004ool01@00oooooooo00000ooo00D00?ooooooo`0000?oo`04003o
oooo0004ool01000ooooo`001?oo00@00?ooool000Coo`04003ooooo0003ool01000ooooo`000ooo
00@00?ooool000Coo`04003ooooo0003ool01000ooooo`001?oo00<00?oo00001?oo00<00?oo0000
1?oo00@00?ooool000?oo`03003oo`0000?oo`04003ooooo0004ool00`00ool00003ool01000oooo
o`000ooo00@00?ooool000?oo`03003oo`0000?oo`05003oooooool00002ool01000ooooo`000ooo
00@00?ooool000?oo`04003ooooo0002ool01000ooooo`000ooo00@00?ooool000;oo`04003ooooo
0003ool00`00ool00003ool01000ooooo`000ooo00@00?ooool000;oo`03003ooooo00Soo`003ooo
00<00?ooool00_oo00<00?ooool01?oo00D00?ooooooo`0000Goo`05003oooooool00005ool01@00
oooooooo00001?oo00@00?ooool000Goo`04003ooooo0004ool01@00oooooooo00000ooo00D00?oo
ooooo`0000?oo`04003ooooo0004ool01000ooooo`001?oo00@00?ooool000Coo`03003oo`0000Co
o`04003ooooo0004ool00`00ool00004ool01000ooooo`000ooo00@00?ooool000Coo`03003oo`00
00Coo`03003oo`0000Coo`03003oo`0000Coo`03003oo`0000Coo`03003oo`0000Coo`03003oo`00
00?oo`04003ooooo0003ool01000ooooo`000ooo00<00?oo00001?oo00<00?oo00001?oo00<00?oo
00000ooo00@00?ooool000?oo`04003ooooo0002ool01000ooooo`000ooo00<00?oo00000ooo00@0
0?ooool000?oo`03003oo`0000?oo`04003ooooo0003ool01000ooooo`000ooo00<00?ooool01ooo
000?ool00`00ooooo`02ool00`00ooooo`04ool01@00oooooooo00001Ooo00D00?ooooooo`0000Go
o`05003oooooool00004ool01000ooooo`001Ooo00@00?ooool000Coo`04003ooooo0004ool01@00
oooooooo00000ooo00@00?ooool000Goo`03003oo`0000Coo`04003ooooo0004ool00`00ool00004
ool01000ooooo`001?oo00<00?oo00001?oo00@00?ooool000?oo`04003ooooo0004ool00`00ool0
0004ool00`00ool00004ool00`00ool00004ool00`00ool00004ool00`00ool00004ool00`00ool0
0004ool00`00ool00003ool01000ooooo`000ooo00<00?oo00001?oo00<00?oo00001?oo00<00?oo
00000ooo00<00?oo00001?oo00<00?oo00000ooo00@00?ooool000?oo`03003oo`0000Coo`03003o
o`0000?oo`03003oo`0000Coo`03003oo`0000?oo`03003oo`0000Coo`03003ooooo00Ooo`003ooo
00<00?ooool00_oo00<00?ooool01?oo00D00?ooooooo`0000Goo`05003oooooool00005ool01@00
oooooooo00001?oo00@00?ooool000Goo`04003ooooo0004ool01000ooooo`001?oo00D00?oooooo
o`0000?oo`04003ooooo0005ool00`00ool00004ool01000ooooo`001?oo00<00?oo00001?oo00@0
0?ooool000Coo`03003oo`0000Coo`04003ooooo0003ool01000ooooo`001?oo00<00?oo00001?oo
00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo
00<00?oo00000ooo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00000ooo
00<00?oo00001?oo00<00?oo00001?oo00<00?oo00000ooo00<00?oo00001?oo00<00?oo00000ooo
00<00?oo00001?oo00<00?oo00000ooo00<00?oo00001?oo00<00?ooool01ooo000?ool01@00oooo
oooo00002?oo00@00?ooool000Koo`04003ooooo0005ool01000ooooo`001Ooo00@00?ooool000Go
o`03003oo`0000Koo`03003oo`0000Goo`03003oo`0000Goo`03003oo`0000Goo`03003oo`0000Co
o`04003ooooo0004ool00`00ool00005ool20005ool00`00ool00004ool00`00ool00005ool00`00
ool00004ool00`00ool00004ool00`00ool00004ool00`00ool00004ool00`00ool00004ool00`00
ool00004ool00`00ool00004ool00`00ool00003ool00`00ool00004ool00`00ool00004ool00`00
ool00004ool00`00ool00003ool00`00ool00004ool00`00ool00004ool00`00ool00003ool00`00
ool00004ool00`00ool00003ool00`00ool00004ool00`00ool00003ool00`00ool00004ool00`00
ooooo`07ool000ooo`05003oooooool00008ool01000ooooo`001_oo00@00?ooool000Goo`04003o
oooo0006ool00`00ool00005ool00`00ool00006ool00`00ool00005ool00`00ool00005ool00`00
ool00005ool00`00ool00004ool01000ooooo`001?oo00<00?oo00001Ooo0P001Ooo00<00?oo0000
1?oo00<00?oo00001Ooo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo00<00?oo0000
1?oo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo00<00?oo00001?oo0P001Ooo0P00
1?oo00<00?oo00001?oo00<00?oo00000ooo00<00?oo00001?oo00<00?oo00001?oo00<00?oo0000
0ooo00<00?oo00001?oo0P001?oo00<00?oo00001?oo0P001?oo00<00?oo00003_oo000?ool01@00
oooooooo00002?oo00@00?ooool000Koo`04003ooooo0006ool00`00ool00006ool00`00ool00005
ool00`00ool00006ool00`00ool00005ool00`00ool00005ool00`00ool00005ool00`00ool00005
ool00`00ool00004ool00`00ool00005ool20005ool00`00ool00005ool20005ool00`00ool00004
ool00`00ool00004ool00`00ool00004ool00`00ool00004ool00`00ool00004ool00`00ool00004
ool00`00ool00004ool00`00ool00004ool20005ool20004ool00`00ool00004ool20005ool20004
ool00`00ool00004ool20004ool00`00ool00004ool20005ool20004ool20004ool00`00ool0000>
ool000ooo`05003oooooool00008ool01000ooooo`001_oo00@00?ooool000Koo`03003oo`0000Ko
o`03003oo`0000Goo`03003oo`0000Koo`03003oo`0000Goo`03003oo`0000Goo`03003oo`0000Go
o`03003oo`0000Goo`8000Goo`03003oo`0000Goo`8000Goo`03003oo`0000Goo`8000Goo`8000Go
o`03003oo`0000Coo`03003oo`0000Coo`03003oo`0000Coo`03003oo`0000Coo`03003oo`0000Co
o`03003oo`0000Coo`8000Goo`8000Goo`8000Coo`03003oo`0000Coo`8000Goo`8000Coo`03003o
o`0000Coo`8000Goo`8000Coo`8000Goo`8000Coo`8000Goo`8000koo`003ooo0P000_oo00<00?oo
ool01_oo00@00?ooool000Koo`03003oo`0000Ooo`03003oo`0000Koo`03003oo`0000Koo`8000Ko
o`03003oo`0000Goo`03003oo`0000Goo`03003oo`0000Goo`8000Koo`8000Koo`8000Goo`8000Go
o`03003oo`0000Goo`8000Goo`8000Goo`8000Goo`<000Coo`<000Goo`03003ooooo00?oo`8000Go
o`8000Goo`8000Goo`8000Goo`8000Goo`03003ooooo00?oo`8000Goo`8000Goo`03003ooooo00?o
o`8000Goo`8000Coo`8000Goo`8000Coo`8000Goo`8000koo`003ooo00D00?ooooooo`0000Soo`03
003oo`0000Ooo`03003oo`0000Ooo`8000Ooo`8000Ooo`8000Koo`8000Koo`<000Goo`8000Koo`80
00Koo`8000Koo`8000Goo`8000Koo`03003ooooo00Coo`8000Goo`8000Goo`8000Koo`03003ooooo
00Coo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00?oo`8000Goo`80
00Goo`8000Goo`03003ooooo00Coo`03003ooooo00?oo`8000Goo`03003ooooo00?oo`8000Goo`03
003ooooo00?oo`8000Goo`03003ooooo00?oo`8000Goo`03003ooooo00goo`003ooo00@00?ooool0
00Woo`03003oo`0000Soo`8000Ooo`8000Ooo`8000Ooo`8000Koo`8000Ooo`03003ooooo00Goo`03
003ooooo00Coo`8000Koo`8000Koo`03003ooooo00Coo`8000Koo`03003ooooo00Coo`03003ooooo
09Goo`003ooo00@00?ooool000Woo`<000Soo`8000Ooo`8000Soo`03003ooooo00Goo`03003ooooo
0=_oo`003ooo00@00?ooool000[oo`800?ooo`;oo`003ooo00@00?ooool00?ooo`koo`003ooo00@0
0?ooool00?ooo`koo`003ooo00@00?ooool00?ooo`koo`003ooo00<00?oo0000oooo3ooo000?ool0
0`00ool0003oool?ool000ooo`800?oooa3oo`003ooo00<00?ooool0oooo3ooo000?ool00`00oooo
o`3oool?ool000ooo`03003ooooo0?ooo`ooo`003ooo00<00?ooool0oooo3ooo003ooolQool00?oo
ob7oo`00oooo8Ooo0000\
\>"],
  ImageRangeCache->{{{74.875, 361.875}, {284.312, 107.375}} -> {-34.4017, \
-1.933, 0.380877, 0.0471336}}]
}, Open  ]],

Cell[TextData[{
  "You can give initial conditions as equations of any kind. If these \
equations have multiple solutions, ",
  StyleBox["NDSolve", "MR"],
  " will generate multiple solutions. "
}], "Text",
  CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"}],

Cell["\<\
The initial conditions in this case lead to multiple solutions. \
\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell["NDSolve[{y'[x]^2 - y[x]^3 == 0, y[0]^2 == 4},y, {x, 1}]", "Input",
  CellLabel->"In[99]:=",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[BoxData[
    \(NDSolve::"mxst" \(\(:\)\(\ \)\) 
      "Maximum number of \!\(10000\) steps reached at the point \!\(x\) == \!\
\(1.1160976563722613`*^-8\)."\)], "Message",
  CellLabel->"From In[99]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"y", "\[Rule]", 
            
            TagBox[\(InterpolatingFunction[{{0.`, 1.1160976563722613`*^-8}}, 
                "<>"]\),
              False,
              Editable->False]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[99]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " was not able to find the solution for y'[x] \[Equal] - Sqrt[y[x]^3], y[0] \
\[Equal] -2 because of problems with the branch cut in the square root \
function."
}], "Text"],

Cell[TextData[{
  "This shows the real part of the solutions that ",
  StyleBox["NDSolve", "MR"],
  " was able to find. (The upper two solutions are strictly real.)"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[
      Evaluate[Part[Re[y[x]\  /. \ %], {1, 2, 4}]], \ {x, 0, \ 1}]\)], "Input",\

  CellLabel->"In[100]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.097398 0.0413414 [
[.21429 .0849 -9 -9 ]
[.21429 .0849 9 0 ]
[.40476 .0849 -9 -9 ]
[.40476 .0849 9 0 ]
[.59524 .0849 -9 -9 ]
[.59524 .0849 9 0 ]
[.78571 .0849 -9 -9 ]
[.78571 .0849 9 0 ]
[.97619 .0849 -3 -9 ]
[.97619 .0849 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .18008 -6 -4.5 ]
[.01131 .18008 0 4.5 ]
[.01131 .26276 -6 -4.5 ]
[.01131 .26276 0 4.5 ]
[.01131 .34545 -6 -4.5 ]
[.01131 .34545 0 4.5 ]
[.01131 .42813 -6 -4.5 ]
[.01131 .42813 0 4.5 ]
[.01131 .51081 -12 -4.5 ]
[.01131 .51081 0 4.5 ]
[.01131 .5935 -12 -4.5 ]
[.01131 .5935 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .0974 m
.21429 .10365 L
s
[(0.2)] .21429 .0849 0 1 Mshowa
.40476 .0974 m
.40476 .10365 L
s
[(0.4)] .40476 .0849 0 1 Mshowa
.59524 .0974 m
.59524 .10365 L
s
[(0.6)] .59524 .0849 0 1 Mshowa
.78571 .0974 m
.78571 .10365 L
s
[(0.8)] .78571 .0849 0 1 Mshowa
.97619 .0974 m
.97619 .10365 L
s
[(1)] .97619 .0849 0 1 Mshowa
.125 Mabswid
.07143 .0974 m
.07143 .10115 L
s
.11905 .0974 m
.11905 .10115 L
s
.16667 .0974 m
.16667 .10115 L
s
.2619 .0974 m
.2619 .10115 L
s
.30952 .0974 m
.30952 .10115 L
s
.35714 .0974 m
.35714 .10115 L
s
.45238 .0974 m
.45238 .10115 L
s
.5 .0974 m
.5 .10115 L
s
.54762 .0974 m
.54762 .10115 L
s
.64286 .0974 m
.64286 .10115 L
s
.69048 .0974 m
.69048 .10115 L
s
.7381 .0974 m
.7381 .10115 L
s
.83333 .0974 m
.83333 .10115 L
s
.88095 .0974 m
.88095 .10115 L
s
.92857 .0974 m
.92857 .10115 L
s
.25 Mabswid
0 .0974 m
1 .0974 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-2)] .01131 .01472 1 0 Mshowa
.02381 .18008 m
.03006 .18008 L
s
[(2)] .01131 .18008 1 0 Mshowa
.02381 .26276 m
.03006 .26276 L
s
[(4)] .01131 .26276 1 0 Mshowa
.02381 .34545 m
.03006 .34545 L
s
[(6)] .01131 .34545 1 0 Mshowa
.02381 .42813 m
.03006 .42813 L
s
[(8)] .01131 .42813 1 0 Mshowa
.02381 .51081 m
.03006 .51081 L
s
[(10)] .01131 .51081 1 0 Mshowa
.02381 .5935 m
.03006 .5935 L
s
[(12)] .01131 .5935 1 0 Mshowa
.125 Mabswid
.02381 .03539 m
.02756 .03539 L
s
.02381 .05606 m
.02756 .05606 L
s
.02381 .07673 m
.02756 .07673 L
s
.02381 .11807 m
.02756 .11807 L
s
.02381 .13874 m
.02756 .13874 L
s
.02381 .15941 m
.02756 .15941 L
s
.02381 .20075 m
.02756 .20075 L
s
.02381 .22142 m
.02756 .22142 L
s
.02381 .24209 m
.02756 .24209 L
s
.02381 .28343 m
.02756 .28343 L
s
.02381 .30411 m
.02756 .30411 L
s
.02381 .32478 m
.02756 .32478 L
s
.02381 .36612 m
.02756 .36612 L
s
.02381 .38679 m
.02756 .38679 L
s
.02381 .40746 m
.02756 .40746 L
s
.02381 .4488 m
.02756 .4488 L
s
.02381 .46947 m
.02756 .46947 L
s
.02381 .49014 m
.02756 .49014 L
s
.02381 .53148 m
.02756 .53148 L
s
.02381 .55215 m
.02756 .55215 L
s
.02381 .57282 m
.02756 .57282 L
s
.02381 .61417 m
.02756 .61417 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.03053 .01472 L
.03279 .01473 L
.03527 .01473 L
.0379 .01474 L
.04262 .01476 L
.04749 .01479 L
.05205 .01482 L
.06244 .01492 L
.07305 .01505 L
.08274 .01519 L
.10458 .0156 L
.12357 .01606 L
.14429 .01667 L
.18493 .01818 L
.22406 .02 L
.26565 .0223 L
.30571 .02483 L
.34426 .02753 L
.38527 .03063 L
.42475 .03381 L
.46273 .037 L
.50315 .04051 L
.54206 .04395 L
.58342 .04765 L
.62326 .05121 L
.66159 .0546 L
.70238 .05815 L
.74164 .06149 L
.77939 .06462 L
.8196 .06783 L
.85828 .0708 L
.89942 .07381 L
.93905 .07657 L
.97619 .07902 L
s
.02381 .18008 m
.06244 .17553 L
.10458 .17099 L
.14415 .16707 L
.18221 .1636 L
.22272 .16017 L
.26171 .15712 L
.30316 .15411 L
.34309 .15143 L
.3815 .14902 L
.42237 .14663 L
.46172 .14448 L
.49955 .14255 L
.53984 .14062 L
.57861 .13887 L
.61984 .13713 L
.65954 .13556 L
.69774 .13413 L
.73838 .13269 L
.77751 .13139 L
.81909 .13008 L
.85916 .12889 L
.89771 .12781 L
.93871 .12672 L
.97619 .12577 L
s
.02381 .18008 m
.06244 .18504 L
.10458 .19097 L
.14415 .1971 L
.18221 .20359 L
.22272 .21122 L
.26171 .21936 L
.30316 .22901 L
.34309 .23944 L
.3815 .25069 L
.42237 .26419 L
.46172 .27894 L
.49955 .29505 L
.53984 .31468 L
.57861 .33648 L
.61984 .36345 L
.65954 .39399 L
.69774 .42861 L
.73838 .47256 L
.77751 .52369 L
.81909 .59039 L
s
.81909 .59039 m
.83289 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[100]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo003ooolQ
ool000ooo`03003ooooo0?ooo`ooo`003ooo00<00?ooool0oooo3ooo0007ool40004ool00`00oooo
o`3oool?ool000Ooo`03003ooooo00Goo`03003ooooo0?ooo`ooo`002?oo00<00?ooool01?oo3`00
oooo0ooo00000ooo000000020004ool00`00ooooo`03ool00`00ooooo`0<oolT003Nool000Ooo`04
003ooooo0004ool00`00ooooo`0`oolF0038ool000Soo`8000Goo`03003ooooo04Koo`/00;goo`00
3ooo00<00?ooool0DOoo2`00/_oo000?ool00`00ooooo`1Lool;002Wool000ooo`8006Soo`/009co
o`003ooo00<00?ooool0L_oo2`00TOoo000?ool00`00ooooo`1mool;0026ool000ooo`03003ooooo
08Soo`/007_oo`003ooo00<00?ooool0Tooo3000Kooo000?ool00`00ooooo`2OoolE001Jool000oo
o`8002coo`8000Coo`8000?oo`@002Koo`8000Coo`8000Goo`<002Goo`8000Coo`8000?oo`<0017o
o``000[oo`8000Coo`8000Coo`8002coo`D000Goo`003ooo00<00?ooool0:_oo00@00?ooool000So
o`03003ooooo02Koo`04003ooooo000;ool00`00ooooo`0Sool01000ooooo`002?oo00@00?ooool0
01coo`X000;oo`03003ooooo00Koo`04003ooooo000]ool00`00ooooo`05ool000ooo`03003ooooo
02[oo`04003ooooo0009ool00`00ooooo`0Uool01000ooooo`002?oo1@009?oo00@00?ooool000So
o`04003ooooo000Uool=0002ool00`00ooooo`0[ool00`00ooooo`05ool000ooo`03003ooooo02[o
o`04003ooooo000:ool00`00ooooo`0Tool01000ooooo`002?oo00@00?ooool002Goo`04003ooooo
0008ool3000Vool01000ooooo`002?oo2`009_oo00<00?ooool01Ooo000?ool00`00ooooo`0Zool0
1000ooooo`002?oo00@00?ooool002Goo`04003ooooo0009ool00`00ool0000Uool01000ooooo`00
2Ooo00<00?ooool09Ooo00@00?ooool000Soo`04003ooooo0007ool;000Kool00`00ooooo`05ool0
00ooo`03003ooooo02_oo`8000[oo`8002Ooo`8000_oo`8002Koo`8000[oo`<002Koo`8000[oo`80
01?oo``000koo`8000Ooo`003ooo0P00n?oo40001ooo000?ool00`00ooooo`3oool?ool000ooo`03
003ooooo0?ooo`ooo`003ooo00<00?ooool0oooo3ooo000?ool00`00ooooo`3oool?ool000Soool0
01T000003ooo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02ooo00<00?ooool02_oo00<0
0?ooool02_oo00<00?ooool02_oo00<00?ooool02ooo00<00?ooool02_oo00<00?ooool02_oo00<0
0?ooool02_oo00<00?ooool02ooo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<0
0?ooool02ooo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02ooo00<0
0?ooool02_oo00<00?ooool01Ooo000?ool00`00ooooo`0bool00`00ooooo`0bool00`00ooooo`0b
ool00`00ooooo`0bool00`00ooooo`0bool00`00ooooo`05ool000ooo`03003ooooo0?ooo`ooo`00
3ooo00<00?ooool0oooo3ooo000?ool00`00ooooo`3oool?ool000ooo`800?oooa3oo`003ooo00<0
0?ooool0oooo3ooo000?ool00`00ooooo`3oool2ool60007ool000ooo`03003ooooo0=Goob`000go
o`003ooo00<00?ooool0_ooo5P00>Ooo000?ool00`00ooooo`2NoolQ001?ool000ooo`8008WooaH0
073oo`003ooo00<00?ooool0L_oo5P00Q_oo000?ool00`00ooooo`1Wool;002Lool000ooo`03003o
oooo057ooaH00:Ooo`003ooo00<00?ooool0A_oo2`00_Ooo000?ool00`00ooooo`0jool<0038ool0
00ooo`80033oo`/00=Coo`003ooo00<00?ooool09?oo2`00gooo000?ool00`00ooooo`0Iool;003Z
ool000Ooo`@000Coo`03003ooooo00koo`/00?Goo`001ooo00<00?ooool01Ooo00<00?ooool00ooo
2`00oooo0Ooo0008ool00`00ooooo`04ool6003oool<ool000Woo`03003ooooo00?oo`03003ooooo
00H00?ooo`Woo`001ooo00@00?ooool000Coo`03003ooooo00Koo`P00?ooo`7oo`002?oo0P001Ooo
00<00?ooool03_oo2000n?oo000?ool00`00ooooo`0Fool6003bool000ooo`03003ooooo01coo`D0
0>goo`003ooo0P008_oo1P00iooo000?ool00`00ooooo`0Wool5003Rool000ooo`03003ooooo02co
o`H00=coo`003ooo00<00?ooool0<_oo1@00eooo000?ool00`00ooooo`0gool6003Aool000ooo`03
003ooooo03goo`@00<goo`003ooo0P00@_oo1000bOoo000?ool00`00ooooo`15ool40035ool000oo
o`03003ooooo04Woo`@00<7oo`003ooo00<00?ooool0COoo1000_Ooo000?ool00`00ooooo`1Aool4
002iool000ooo`03003ooooo05Goo`<00;Koo`003ooo0P00FOoo0`00/ooo000?ool00`00ooooo`1K
ool4002_ool000ooo`03003ooooo05ooo`<00:coo`002Ooo0`000ooo00<00?ooool0H_oo0`00ZOoo
000:ool00`00ooooo`02ool00`00ooooo`1Uool3002Vool000Ooo`D000?oo`<006Soo`<00:?oo`00
1ooo00@00?ooool000Coo`03003ooooo06_oo`<00:3oo`002?oo00<00?oo00001?oo00<00?ooool0
K_oo0`00WOoo0009ool20004ool00`00ooooo`1aool2002Kool000ooo`03003ooooo07?oo`<009So
o`003ooo00<00?ooool0M_oo0`00UOoo000?ool2001jool2002Cool000ooo`03003ooooo07_oo`<0
093oo`003ooo00<00?ooool0O_oo0P00S_oo000?ool00`00ooooo`20ool2002<ool000ooo`03003o
oooo08;oo`8008[oo`003ooo00<00?ooool0Q?oo0P00R?oo000?ool20027ool20026ool000ooo`03
003ooooo08Soo`8008Coo`003ooo00<00?ooool0R_oo0P00P_oo000?ool00`00ooooo`2<ool20020
ool000ooo`03003ooooo08koo`8007koo`003ooo00<00?ooool0T?oo0P00O?oo000?ool2002Cool0
0`00ooooo`1iool000ooo`03003ooooo09?oo`8007Woo`003ooo00<00?ooool0UOoo0P00Mooo0007
ool30005ool00`00ooooo`2Gool00`00ooooo`1dool000Ooo`04003ooooo0004ool00`00ooooo`2H
ool2001dool000Ooo`04003ooooo0004ool3002Jool2001bool000Ooo`<000Goo`03003ooooo09co
o`03003ooooo06ooo`002?oo00<00?ooool01?oo00<00?ooool0WOoo0P00Kooo0008ool30004ool0
0`00ooooo`2Oool2001]ool000ooo`03003ooooo0:7oo`8006_oo`003ooo00<00?ooool0Xooo00<0
0?ooool0J?oo000?ool2002Uool00`00ooooo`1Wool000ooo`03003ooooo0:Goo`8006Ooo`003ooo
00<00?ooool0Yooo00<00?ooool0I?oo000?ool00`00ooooo`2Xool00`00ooooo`1Sool000ooo`03
003ooooo0:Woo`03003ooooo06;oo`003ooo00<00?ooool0Z_oo00<00?ooool0HOoo000?ool2002/
ool2001Qool000ooo`03003ooooo0:goo`03003ooooo05koo`003ooo00<00?ooool0[_oo00<00?oo
ool0GOoo000?ool00`00ooooo`2_ool00`00ooooo`1Lool000ooo`03003ooooo0;3oo`03003ooooo
05_oo`003ooo00<00?ooool0/Ooo00<00?ooool0F_oo000?ool2002cool00`00ooooo`1Iool000oo
o`03003ooooo0;?oo`8005Woo`003ooo00<00?ooool0]Ooo00<00?ooool0E_oo0008ool20005ool0
0`00ooooo`2fool00`00ooooo`1Eool000Ooo`04003ooooo0004ool00`00ooooo`2gool00`00oooo
o`1Dool000Ooo`04003ooooo0004ool3002hool00`00ooooo`1Cool000Soo`8000Goo`03003ooooo
0;Woo`03003ooooo05;oo`001ooo00@00?ooool000Coo`03003ooooo0;[oo`03003ooooo057oo`00
2?oo0P001Ooo00<00?ooool0^ooo00<00?ooool0D?oo000?ool00`00ooooo`2lool00`00ooooo`1?
ool000ooo`03003ooooo0;goo`03003ooooo04koo`003ooo0P00_ooo00<00?ooool0COoo000?ool0
0`00ooooo`2nool00`00ooooo`1=ool000ooo`03003ooooo0;ooo`03003ooooo04coo`003ooo00<0
0?ooool0`?oo00<00?ooool0Booo000?ool00`00ooooo`31ool00`00ooooo`1:ool000ooo`03003o
oooo0<;oo`03003ooooo04Woo`003ooo0P00a?oo00<00?ooool0B?oo000?ool00`00ooooo`34ool0
0`00ooooo`17ool000ooo`03003ooooo0<Goo`03003ooooo04Koo`003ooo00<00?ooool0a_oo00<0
0?ooool0AOoo000?ool00`00ooooo`36ool00`00ooooo`15ool000ooo`03003ooooo0<Ooo`03003o
oooo04Coo`003ooo0P00bOoo00<00?ooool0@ooo000?ool00`00ooooo`39ool00`00ooooo`12ool0
00ooo`03003ooooo0<Woo`03003ooooo04;oo`0000?oo`0000000`000_oo0P001Ooo00<00?ooool0
b_oo00<00?ooool0@Ooo0003ool01@00oooooooo00000_oo00<00?ooool00_oo00<00?ooool0booo
00<00?ooool0@?oo0003ool01@00oooooooo00000_oo00<00?ooool00_oo0`00c?oo00<00?ooool0
?ooo0003ool01@00oooooooo00000_oo00<00?ooool00_oo00<00?ooool0cOoo00<00?ooool0?_oo
0003ool01@00oooooooo00000_oo00<00?ooool00_oo00<00?ooool0cOoo00<00?ooool0?_oo0002
ool20004ool20005ool00`00ooooo`3>ool00`00ooooo`0mool000ooo`03003ooooo0<ooo`03003o
oooo03coo`003ooo00<00?ooool0d?oo00<00?ooool0>ooo000?ool2003Aool00`00ooooo`0kool0
00ooo`03003ooooo0=7oo`03003ooooo03[oo`003ooo00<00?ooool0dOoo00<00?ooool0>_oo000?
ool00`00ooooo`3Bool00`00ooooo`0iool000ooo`03003ooooo0=?oo`03003ooooo03Soo`003ooo
00<00?ooool0dooo00<00?ooool0>?oo000?ool2003Eool00`00ooooo`0gool000ooo`03003ooooo
0=Coo`03003ooooo03Ooo`003ooo00<00?ooool0eOoo00<00?ooool0=_oo000?ool00`00ooooo`3F
ool00`00ooooo`0eool000ooo`03003ooooo0=Koo`03003ooooo03Goo`003ooo00<00?ooool0eooo
00<00?ooool0=?oo000?ool2003Iool00`00ooooo`0cool000ooo`03003ooooo0=Soo`03003ooooo
03?oo`003ooo00<00?ooool0fOoo00<00?ooool0<_oo00000ooo0000000300000ooo000000020004
ool00`00ooooo`3Iool00`00ooooo`0bool000?oo`05003oooooool00007ool00`00ooooo`3Jool0
0`00ooooo`0aool000?oo`03003ooooo00;oo`03003ooooo00Coo`<00=[oo`03003ooooo037oo`00
0ooo00<00?ooool00ooo00<00?ooool00ooo00<00?ooool0fooo00<00?ooool0<?oo0003ool01@00
oooooooo00000_oo00<00?ooool00_oo00<00?ooool0fooo00<00?ooool0<?oo0002ool20004ool2
0005ool00`00ooooo`3Lool00`00ooooo`0_ool000ooo`03003ooooo0=coo`03003ooooo02ooo`00
3ooo00<00?ooool0gOoo00<00?ooool0;_oo000?ool2003Nool00`00ooooo`0^ool000ooo`03003o
oooo0=koo`03003ooooo02goo`00oooo8Ooo003ooolQool00001\
\>"],
  ImageRangeCache->{{{74.875, 361.875}, {293.312, 116.375}} -> {-0.341086, \
7.528, 0.00377504, 0.0869654}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[100]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " can solve a mixed system of differential and algebraic equations, \
referred to as ",
  StyleBox["differential-algebraic equations",
    FontSlant->"Italic"],
  " (DAEs).  In fact, the example above is an example of a sort of DAE, where \
the equations are not expressed explicitly in terms of the derivatives.  \
Typically, however, in DAEs, you are not able to solve for the derivatives at \
all and the problem must be solved using a different method entirely."
}], "Text",
  CellTags->{"b:1", "ndsg:0"}],

Cell["Here is a simple DAE.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ y[t]\  \[Equal] \ x[t], \ 
        x[t]^2\  + \ y[t]^2\  \[Equal] \ 1, \ 
        x[0]\  \[Equal] \ 0, \ \(x'\)[0]\  \[Equal] \ 1}, {x, y}, {t, 0, 
        2}]\)], "Input",
  CellLabel->"In[119]:="],

Cell[BoxData[
    \(NDSolve::"ndsz" \(\(:\)\(\ \)\) 
      "At \!\(t\) == \!\(1.6656481721762024`\), step size is effectively \
zero; singularity or stiff system suspected."\)], "Message",
  CellLabel->"From In[119]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"x", "\[Rule]", 
            
            TagBox[\(InterpolatingFunction[{{0.`, 1.6656481721761813`}}, 
                "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"y", "\[Rule]", 
            
            TagBox[\(InterpolatingFunction[{{0.`, 1.6656481721761813`}}, 
                "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[119]="]
}, Open  ]],

Cell[TextData[{
  "Note that while both of the equations have derivative terms, the variable \
",
  StyleBox["y",
    FontSlant->"Italic"],
  " appears without any derivatives, so NDSolve issues a warning message.  \
When the usual substitution to convert to first order equations is made, one \
of the equations does indeed become effectively algebraic.  "
}], "Text"],

Cell[TextData[{
  "Also, since ",
  StyleBox["y",
    FontSlant->"Italic"],
  " only appears algebraically, it is not necessary to give an initial \
condition to determine its values.  Finding initial conditions that are \
consistent with DAEs can, in fact, be quite difficult.  The advanced \
documentation notebook specifically on ",
  ButtonBox["DAEs",
    ButtonData:>{"DAE.nb", None},
    ButtonStyle->"Hyperlink"],
  " has more information."
}], "Text"],

Cell["This shows a plot of the solutions.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[Evaluate[{x[t], \ y[t]}\  /. \ %], {t, 0, 1.66}];\)\)], "Input",
  CellLabel->"In[120]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.573723 0.0147151 0.588604 [
[.16724 .00222 -12 -9 ]
[.16724 .00222 12 0 ]
[.31067 .00222 -9 -9 ]
[.31067 .00222 9 0 ]
[.4541 .00222 -12 -9 ]
[.4541 .00222 12 0 ]
[.59753 .00222 -3 -9 ]
[.59753 .00222 3 0 ]
[.74096 .00222 -12 -9 ]
[.74096 .00222 12 0 ]
[.88439 .00222 -9 -9 ]
[.88439 .00222 9 0 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16724 .01472 m
.16724 .02097 L
s
[(0.25)] .16724 .00222 0 1 Mshowa
.31067 .01472 m
.31067 .02097 L
s
[(0.5)] .31067 .00222 0 1 Mshowa
.4541 .01472 m
.4541 .02097 L
s
[(0.75)] .4541 .00222 0 1 Mshowa
.59753 .01472 m
.59753 .02097 L
s
[(1)] .59753 .00222 0 1 Mshowa
.74096 .01472 m
.74096 .02097 L
s
[(1.25)] .74096 .00222 0 1 Mshowa
.88439 .01472 m
.88439 .02097 L
s
[(1.5)] .88439 .00222 0 1 Mshowa
.125 Mabswid
.0525 .01472 m
.0525 .01847 L
s
.08118 .01472 m
.08118 .01847 L
s
.10987 .01472 m
.10987 .01847 L
s
.13855 .01472 m
.13855 .01847 L
s
.19593 .01472 m
.19593 .01847 L
s
.22461 .01472 m
.22461 .01847 L
s
.2533 .01472 m
.2533 .01847 L
s
.28199 .01472 m
.28199 .01847 L
s
.33936 .01472 m
.33936 .01847 L
s
.36804 .01472 m
.36804 .01847 L
s
.39673 .01472 m
.39673 .01847 L
s
.42542 .01472 m
.42542 .01847 L
s
.48279 .01472 m
.48279 .01847 L
s
.51147 .01472 m
.51147 .01847 L
s
.54016 .01472 m
.54016 .01847 L
s
.56885 .01472 m
.56885 .01847 L
s
.62622 .01472 m
.62622 .01847 L
s
.65491 .01472 m
.65491 .01847 L
s
.68359 .01472 m
.68359 .01847 L
s
.71228 .01472 m
.71228 .01847 L
s
.76965 .01472 m
.76965 .01847 L
s
.79834 .01472 m
.79834 .01847 L
s
.82702 .01472 m
.82702 .01847 L
s
.85571 .01472 m
.85571 .01847 L
s
.91308 .01472 m
.91308 .01847 L
s
.94177 .01472 m
.94177 .01847 L
s
.97045 .01472 m
.97045 .01847 L
s
.99914 .01472 m
.99914 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.2)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.4)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.6)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.8)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .05305 L
.10458 .09202 L
.14415 .12613 L
.18221 .15684 L
.22272 .18746 L
.26171 .21509 L
.30316 .24268 L
.34309 .2677 L
.3815 .29049 L
.42237 .31355 L
.46172 .33474 L
.49955 .35435 L
.53984 .37456 L
.57861 .39351 L
.61984 .4133 L
.65954 .4322 L
.69774 .45038 L
.73838 .46994 L
.77751 .48915 L
.81909 .51021 L
.85916 .53139 L
.89771 .55285 L
.93871 .57717 L
.97619 .60115 L
s
.02381 .60332 m
.02499 .60332 L
.02605 .60331 L
.02729 .60331 L
.02846 .6033 L
.03053 .60328 L
.03279 .60325 L
.03527 .6032 L
.0379 .60315 L
.04262 .60301 L
.05205 .60264 L
.06244 .60207 L
.0842 .60037 L
.10458 .59822 L
.14335 .59281 L
.18458 .58544 L
.22428 .57705 L
.26248 .56797 L
.30312 .55739 L
.34225 .54642 L
.38383 .534 L
.4239 .52132 L
.46245 .50846 L
.50346 .49404 L
.54294 .47933 L
.58091 .4643 L
.62134 .44716 L
.66025 .4293 L
.70161 .40846 L
.74145 .38602 L
.77978 .36155 L
.82057 .33123 L
.85983 .29601 L
.89758 .25335 L
.91856 .22363 L
.93779 .19003 L
.95649 .14678 L
.9659 .11695 L
.96848 .1069 L
.97123 .09467 L
.97619 .0652 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[120]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo000bool2
0004ool20003ool40003ool2000Fool20004ool20004ool2000Fool20004ool20005ool00`00oooo
o`02ool2000Kool5000Iool50002ool20003ool40003ool2000Eool50002ool20004ool2000Jool0
037oo`04003ooooo0008ool00`00ooooo`03ool01000ooooo`005?oo00@00?ooool000Soo`04003o
oooo000Dool01000ooooo`002_oo00D00?ooooooo`0000;oo`03003ooooo01[oo`03003ooooo01_o
o`03003ooooo00Ooo`03003ooooo00?oo`04003ooooo000Fool00`00ooooo`07ool01000ooooo`00
6Ooo000aool01000ooooo`002Ooo00<00?ooool01Ooo00<00?ooool04_oo00@00?ooool000_oo`03
003ooooo01;oo`04003ooooo000:ool00`00ooooo`04ool00`00ooooo`0Jool00`00ooooo`0Kool0
0`00ooooo`08ool00`00ooooo`05ool00`00ooooo`0Dool00`00ooooo`0:ool00`00ooooo`0Gool0
037oo`04003ooooo000:ool00`00ooooo`02ool2000Eool01000ooooo`002Ooo0P005Ooo00@00?oo
ool000_oo`04003oooooool2000Mool00`00ooooo`0Kool00`00ooooo`09ool00`00ooooo`02ool2
000Gool00`00ooooo`08ool2000Jool0037oo`04003ooooo0008ool01000ooooo`000ooo00<00?oo
ool05?oo00@00?ooool000Woo`03003ooooo01Coo`04003ooooo0008ool01000ooooo`000ooo00<0
0?ooool07?oo00<00?ooool06ooo00<00?ooool01ooo00@00?ooool000?oo`03003ooooo01Koo`03
003ooooo00Soo`03003ooooo01Woo`00<_oo0P002_oo0P001?oo0`005Ooo0P002_oo0`005Ooo0P00
2Ooo10000ooo0`006ooo0P007?oo0P002_oo0P001?oo0`005Ooo0P002_oo0`006Ooo003ooolQool0
01Goo`03003ooooo0?ooo`Woo`005Ooo00<00?ooool0oooo2Ooo000Eool00`00ooooo`3oool9ool0
01Goo`03003ooooo0?ooo`Woo`003oooo`004@000Ooo000Eool20006ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool10001ool001Goo`03003oo`0002Coo`03003ooooo02Coo`03003o
oooo02Coo`03003ooooo02Coo`03003ooooo02Coo`03003ooooo02Coo`03003ooooo01koo`005Ooo
00@00?ooool00?ooo`Soo`005Ooo00D00?ooooooo`000?ooo`Ooo`005Ooo00<00?ooool00_oo00<0
0?ooool0oooo1?oo000Eool00`00ooooo`03ool00`00ooooo`3oool3ool001Goo`03003ooooo00Co
o`03003ooooo0?ooo`;oo`005Ooo0P001_oo00<00?ooool0oooo0Ooo000Eool00`00ooooo`06ool0
0`00ooooo`3oool001Goo`03003ooooo00Ooo`03003ooooo0?koo`005Ooo00<00?ooool02?oo00<0
0?ooool0oOoo000Eool00`00ooooo`09ool00`00ooooo`3lool001Goo`03003ooooo00[oo`03003o
oooo0?_oo`005Ooo00<00?ooool02ooo00<00?ooool0l_oo00<00?ooool01Ooo000Eool00`00oooo
o`0<ool00`00ooooo`3aool00`00ooooo`05ool001Goo`8000koo`800?7oo`03003ooooo00Goo`00
5Ooo00<00?ooool03ooo00<00?ooool0k_oo00<00?ooool01Ooo000Eool00`00ooooo`0@ool00`00
ooooo`3/ool00`00ooooo`06ool001Goo`03003ooooo017oo`03003ooooo0>_oo`03003ooooo00Ko
o`005Ooo00<00?ooool04_oo00<00?ooool0j_oo00<00?ooool01_oo000Eool00`00ooooo`0Cool0
0`00ooooo`3Yool00`00ooooo`06ool001Goo`03003ooooo01Coo`03003ooooo0>Soo`03003ooooo
00Koo`005Ooo00<00?ooool05Ooo0P00j?oo00<00?ooool01_oo000Eool2000Hool00`00ooooo`3T
ool00`00ooooo`07ool001Goo`03003ooooo01Soo`03003ooooo0>?oo`03003ooooo00Ooo`005Ooo
00<00?ooool06Ooo00<00?ooool0h_oo00<00?ooool01ooo000Eool00`00ooooo`0Jool00`00oooo
o`3Pool00`00ooooo`08ool001Goo`03003ooooo01_oo`800>3oo`03003ooooo00Soo`005Ooo00<0
0?ooool07Ooo00<00?ooool0gOoo00<00?ooool02?oo0002ool20004ool20003ool40004ool00`00
ooooo`0Nool00`00ooooo`3Kool00`00ooooo`09ool00005ool00?ooool00008ool00`00ooooo`05
ool00`00ooooo`0Oool00`00ooooo`3Jool00`00ooooo`09ool00005ool00?ooool00009ool00`00
ooooo`04ool3000Pool00`00ooooo`3Iool00`00ooooo`09ool00005ool00?ooool0000:ool00`00
ooooo`03ool00`00ooooo`0Qool00`00ooooo`3Hool00`00ooooo`09ool00005ool00?ooool00008
ool01000ooooo`001?oo00<00?ooool08_oo00<00?ooool0e_oo00<00?ooool02_oo0002ool2000:
ool20005ool00`00ooooo`0Sool2003Fool00`00ooooo`0:ool001Goo`03003ooooo02Goo`03003o
oooo0=?oo`03003ooooo00[oo`005Ooo00<00?ooool09_oo00<00?ooool0dOoo00<00?ooool02ooo
000Eool00`00ooooo`0Wool00`00ooooo`3@ool00`00ooooo`0;ool001Goo`03003ooooo02Soo`03
003ooooo0<koo`03003ooooo00coo`005Ooo0P00:_oo0P00c_oo00<00?ooool03?oo000Eool00`00
ooooo`0[ool00`00ooooo`3:ool00`00ooooo`0=ool001Goo`03003ooooo02coo`03003ooooo0<Wo
o`03003ooooo00goo`005Ooo00<00?ooool0;Ooo0P00b?oo00<00?ooool03_oo000Eool00`00oooo
o`0_ool00`00ooooo`35ool00`00ooooo`0>ool001Goo`03003ooooo033oo`03003ooooo0<?oo`03
003ooooo00ooo`005Ooo00<00?ooool0<Ooo0P00`ooo00<00?ooool03ooo000Eool00`00ooooo`0c
ool00`00ooooo`2oool00`00ooooo`0@ool001Goo`8003Goo`800;ooo`03003ooooo013oo`005Ooo
00<00?ooool0=_oo00<00?ooool0^ooo00<00?ooool04Ooo000Eool00`00ooooo`0gool2002kool0
0`00ooooo`0Aool001Goo`03003ooooo03Woo`800;Soo`03003ooooo01;oo`005Ooo00<00?ooool0
>ooo00<00?ooool0]Ooo00<00?ooool04_oo000Eool00`00ooooo`0lool2002dool00`00ooooo`0C
ool001Goo`03003ooooo03koo`03003ooooo0;7oo`03003ooooo01?oo`005Ooo00<00?ooool0?ooo
0P00/?oo00<00?ooool05?oo000Eool20012ool00`00ooooo`2]ool00`00ooooo`0Dool001Goo`03
003ooooo04;oo`03003ooooo0:_oo`03003ooooo01Goo`005Ooo00<00?ooool0@ooo0P00Z_oo00<0
0?ooool05_oo000Eool00`00ooooo`15ool00`00ooooo`2Wool00`00ooooo`0Fool001Goo`03003o
oooo04Koo`03003ooooo0:Goo`03003ooooo01Ooo`005Ooo00<00?ooool0Aooo0P00Y?oo00<00?oo
ool06?oo0002ool20004ool20005ool30003ool00`00ooooo`19ool00`00ooooo`2Qool00`00oooo
o`0Hool00005ool00?ooool0000;ool00`00ooooo`02ool00`00ooooo`1:ool2002Pool00`00oooo
o`0Iool00005ool00?ooool00008ool50003ool3001<ool00`00ooooo`2Mool00`00ooooo`0Iool0
0005ool00?ooool00008ool01000ooooo`001?oo00<00?ooool0COoo0P00W?oo00<00?ooool06_oo
00001Ooo003ooooo00002Ooo00<00?oo00001?oo00<00?ooool0Cooo0P00VOoo00<00?ooool06ooo
0002ool2000;ool20004ool00`00ooooo`1Aool00`00ooooo`2Eool00`00ooooo`0Lool001Goo`03
003ooooo05;oo`8009Coo`03003ooooo01goo`005Ooo00<00?ooool0E?oo00<00?ooool0T?oo00<0
0?ooool07_oo000Eool00`00ooooo`1Eool2002?ool00`00ooooo`0Oool001Goo`03003ooooo05Oo
o`8008coo`03003ooooo023oo`005Ooo0P00F_oo00<00?ooool0R?oo00<00?ooool08Ooo000Eool0
0`00ooooo`1Jool20027ool00`00ooooo`0Rool001Goo`03003ooooo05coo`8008Coo`03003ooooo
02?oo`005Ooo00<00?ooool0G_oo00<00?ooool0P?oo00<00?ooool09?oo000Eool00`00ooooo`1O
ool2001oool00`00ooooo`0Uool001Goo`03003ooooo067oo`8007coo`03003ooooo02Koo`005Ooo
00<00?ooool0Hooo0P00NOoo00<00?ooool09ooo000Eool00`00ooooo`1Uool2001fool00`00oooo
o`0Xool001Goo`8006Soo`8007?oo`03003ooooo02Woo`005Ooo00<00?ooool0JOoo00<00?ooool0
Kooo00<00?ooool0:_oo000Eool00`00ooooo`1Zool2001^ool00`00ooooo`0[ool001Goo`03003o
oooo06coo`8006_oo`03003ooooo02coo`005Ooo00<00?ooool0K_oo0P00J?oo00<00?ooool0;Ooo
000Eool00`00ooooo`1`ool2001Uool00`00ooooo`0^ool001Goo`03003ooooo07;oo`8006;oo`03
003ooooo02ooo`005Ooo00<00?ooool0M?oo00<00?ooool0GOoo0P00<_oo000Eool2001fool2001L
ool00`00ooooo`0bool001Goo`03003ooooo07Ooo`8005Woo`03003ooooo03?oo`005Ooo00<00?oo
ool0NOoo0P00EOoo0P00=_oo000Eool00`00ooooo`1kool2001Bool00`00ooooo`0fool001Goo`03
003ooooo07goo`8004ooo`03003ooooo03Ooo`005Ooo00<00?ooool0Oooo0P00Booo0P00>_oo0002
ool20004ool20003ool30005ool00`00ooooo`21ool20018ool00`00ooooo`0jool00005ool00?oo
ool00008ool01000ooooo`001?oo00<00?ooool0Pooo0P00A?oo0P00?Ooo00001Ooo003ooooo0000
2?oo00@00?ooool000Coo`<008Goo`80047oo`03003ooooo03goo`0000Goo`00ooooo`0000Soo`<0
00Goo`03003ooooo08Ooo`8003goo`80043oo`0000Goo`00ooooo`0000Woo`03003ooooo00Coo`03
003ooooo08Woo`8003Woo`8004;oo`000_oo0P002_oo0`001?oo00<00?ooool0Rooo0P00=_oo00<0
0?ooool0@_oo000Eool00`00ooooo`2=ool2000bool20015ool001Goo`03003ooooo08ooo`8002oo
o`03003ooooo04Goo`005Ooo00<00?ooool0TOoo0P00:ooo0P00B?oo000Eool00`00ooooo`2Cool3
000Vool2001:ool001Goo`8009Ooo`8002;oo`8004coo`005Ooo00<00?ooool0V?oo0P007_oo0P00
C_oo000Eool00`00ooooo`2Jool2000Jool2001@ool001Goo`03003ooooo09coo`8001Ooo`03003o
oooo053oo`005Ooo00<00?ooool0W_oo0`004_oo0P00Dooo000Eool00`00ooooo`2Qool2000>ool2
001Eool001Goo`03003ooooo0:?oo`8000[oo`8005Ooo`005Ooo00<00?ooool0YOoo0P001_oo0P00
FOoo000Eool2002Xool20002ool2001Kool001Goo`03003ooooo0:Woo`8005goo`005Ooo00<00?oo
ool0Yooo0P000_oo0P00Fooo000Eool00`00ooooo`2Uool20006ool2001Iool001Goo`03003ooooo
0:?oo`8000[oo`8005Ooo`005Ooo00<00?ooool0XOoo0P003_oo0P00EOoo000Eool00`00ooooo`2N
ool3000Bool2001Cool001Goo`03003ooooo09_oo`<001Ooo`80057oo`005Ooo0P00V_oo0P007?oo
0P00Cooo000Eool00`00ooooo`2Fool3000Pool2001=ool001Goo`03003ooooo09?oo`<002Goo`80
04_oo`005Ooo00<00?ooool0TOoo0P00:_oo0P00BOoo000Eool00`00ooooo`2>ool3000^ool20017
ool001Goo`03003ooooo08coo`8003?oo`8004Goo`000_oo0P001?oo0P001?oo0P001Ooo00<00?oo
ool0ROoo0`00=ooo0P00@ooo00001Ooo003ooooo00002?oo00@00?ooool000Coo`03003ooooo08Ko
o`<003coo`80047oo`0000Goo`00ooooo`0000Soo`04003ooooo0004ool30024ool20011ool2000o
ool00005ool00?ooool00009ool20005ool00`00ooooo`21ool30015ool2000mool00005ool00?oo
ool00008ool01000ooooo`001?oo00<00?ooool0O_oo0`00B_oo0P00>ooo0002ool2000:ool20005
ool00`00ooooo`1kool3001?ool2000iool001Goo`03003ooooo07Woo`8005Coo`8003Ooo`005Ooo
00<00?ooool0M_oo0`00F?oo0P00=Ooo000Eool00`00ooooo`1cool3001Mool2000cool001Goo`03
003ooooo077oo`8006;oo`80037oo`005Ooo0P00Kooo0`00I_oo0P00;ooo000Eool00`00ooooo`1/
ool2001[ool2000]ool001Goo`03003ooooo06Woo`<006ooo`8002_oo`005Ooo00<00?ooool0IOoo
1000M?oo0P00:Ooo000Eool00`00ooooo`1Qool4001jool2000Wool001Goo`03003ooooo05koo`<0
083oo`8002Goo`005Ooo00<00?ooool0Fooo0`00QOoo0P008ooo000Eool00`00ooooo`1Iool2002:
ool2000Qool001Goo`8005Ooo`<008koo`8001ooo`005Ooo00<00?ooool0Dooo0`00Tooo0P007Ooo
000Eool00`00ooooo`1?ool4002Hool00`00ooooo`0Jool001Goo`03003ooooo04_oo`@009goo`80
01[oo`005Ooo00<00?ooool0Aooo1000Xooo00<00?ooool05ooo000Eool00`00ooooo`11ool6002X
ool2000Gool001Goo`03003ooooo03goo`@00;3oo`8001Goo`005Ooo00<00?ooool0>Ooo1000]_oo
00<00?ooool04_oo000Eool2000fool4002kool2000Bool001Goo`03003ooooo037oo`@00<7oo`03
003ooooo00ooo`005Ooo00<00?ooool0;?oo1@00a_oo0P003ooo000Eool00`00ooooo`0Wool5003=
ool2000=ool001Goo`03003ooooo027oo`H00=Coo`03003ooooo00[oo`005Ooo00<00?ooool06ooo
1P00fooo0P002_oo000=ool50003ool00`00ooooo`0Fool5003Sool20008ool000ooo`03003ooooo
00?oo`03003ooooo00_oo`/00>[oo`03003ooooo00Goo`003ooo00<00?ooool00ooo3P00oOoo000?
ool00`00ooooo`03ool00`00ooooo`3oool9ool000ooo`03003ooooo00?oo`03003ooooo0?ooo`Wo
o`003_oo0P001Ooo00<00?ooool0oooo2Ooo000Eool00`00ooooo`3oool9ool00001\
\>"],
  ImageRangeCache->{{{74.875, 361.875}, {293.312, 116.375}} -> {-0.617747, \
0.6497, 0.00641058, 0.00624851}}]
}, Open  ]],

Cell[TextData[{
  "From the plot, you can see that the derivative of ",
  StyleBox["y",
    FontSlant->"Italic"],
  " is tending to vary arbitrarily fast.  Even though it does not explicitly \
appear in the equations, this condition means that the solver cannot continue \
further."
}], "Text"],

Cell[TextData[{
  "Unknown functions in differential equations do not necessarily have to be \
represented by single symbols. If you have a large number of unknown \
functions, for example, you will often find it more convenient to give the \
functions names like ",
  StyleBox["x", "MR"],
  StyleBox["[", "MR"],
  StyleBox["i", "MR"],
  StyleBox["]", "MR"],
  " or ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          SubscriptBox[
            StyleBox["x",
              FontSlant->"Plain"], 
            StyleBox["i",
              FontSlant->"Plain"]],
          "MR"], TraditionalForm]]],
  "."
}], "Text",
  CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"}],

Cell["\<\
This constructs a set of twenty-five coupled differential equations \
and initial conditions and solves them.\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell[BoxData[{\(n = 25;\), "\n", 
    RowBox[{
      RowBox[{
        RowBox[{
          FormBox[\(x\_0\),
            "TraditionalForm"], "[", "t_", "]"}], ":=", "0"}], ";"}], "\n", 
    RowBox[{
      RowBox[{
        RowBox[{
          FormBox[\(x\_n\),
            "TraditionalForm"], "[", "t_", "]"}], ":=", "1"}], 
      ";"}], "\n", \(eqns\  = \ 
        Table[{\(x\_i'\)[
                t]\  \[Equal] \ \(n\^2\) \((\ 
                  x\_\(i + 1\)[t]\  - \ 2\ x\_i[t]\  + \ 
                    x\_\(i - 1\)[t])\), \ 
            x\_i[0]\  \[Equal] \ \((i/n)\)\^10}, {i, 
            n - 1}];\), "\[IndentingNewLine]", \(vars\  = \ 
        Table[x\_i[t], {i, n - 1}];\), "\[IndentingNewLine]", \(NDSolve[eqns, 
      vars, {t, 0,  .25}]\)}], "Input",
  CellLabel->"In[271]:=",
  CellTags->{"b:1", "ndsg:0"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(x\_1[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_2[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_3[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_4[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_5[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_6[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_7[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_8[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_9[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_10[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_11[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_12[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_13[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_14[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_15[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_16[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_17[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_18[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_19[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_20[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_21[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_22[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_23[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}], ",", 
          RowBox[{\(x\_24[t]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
                False,
                Editable->False], "[", "t", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[276]=",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell[TextData[{
  "This actually computes an approximate solution of the heat equation for a \
rod with constant temperatures at either end of the rod.  (For more accurate \
solutions, you can increase ",
  StyleBox["n",
    FontSlant->"Italic"],
  ".)"
}], "Text",
  CellTags->{"b:1", "ndsg:0"}],

Cell["\<\
The result is an approximate solution to the heat equation for a \
1-dimensional rod of length 1 with constant temperature maintained at either \
end.  This shows the solutions considered as spatial values as a function of \
time.\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot3D[
        Table[vars\  /. \ First[%], \ {t, 0,  .25,  .025}]];\)\)], "Input",
  CellLabel->"In[277]:=",
  CellTags->{"b:1", "ndsg:0"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.78351e-17 1.04977 -0.0679587 1.04977 [
[.13022 .20578 -5.99462 -9 ]
[.13022 .20578 .00538 0 ]
[.26461 .1529 -11.4453 -9 ]
[.26461 .1529 .55465 0 ]
[.40627 .09719 -10.9015 -9 ]
[.40627 .09719 1.09854 0 ]
[.55581 .03841 -10.3576 -9 ]
[.55581 .03841 1.64244 0 ]
[.73498 .04732 0 -6.2105 ]
[.73498 .04732 6 2.7895 ]
[.79846 .14452 0 -6.11593 ]
[.79846 .14452 6 2.88407 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.90976 .31495 0 -5.95504 ]
[.90976 .31495 6 3.04496 ]
[.95881 .39008 0 -5.88604 ]
[.95881 .39008 12 3.11396 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01527 .32056 -24 -2.78921 ]
[.01527 .32056 0 6.21079 ]
[.00609 .37805 -18 -2.83799 ]
[.00609 .37805 0 6.16201 ]
[-0.00342 .43769 -24 -2.88879 ]
[-0.00342 .43769 0 6.11121 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.13949 .21507 m
.14412 .21971 L
s
[(5)] .13022 .20578 .99821 1 Mshowa
.27343 .16262 m
.27784 .16748 L
s
[(10)] .26461 .1529 .90756 1 Mshowa
.41457 .10735 m
.41872 .11244 L
s
[(15)] .40627 .09719 .81691 1 Mshowa
.56352 .04903 m
.56737 .05434 L
s
[(20)] .55581 .03841 .72626 1 Mshowa
.125 Mabswid
.16573 .20479 m
.16848 .20761 L
s
.19224 .19441 m
.19497 .19725 L
s
.21902 .18393 m
.22172 .18679 L
s
.24608 .17333 m
.24876 .17622 L
s
.30106 .1518 m
.30368 .15474 L
s
.32899 .14087 m
.33158 .14383 L
s
.35721 .12981 m
.35977 .13281 L
s
.38574 .11864 m
.38826 .12167 L
s
.44372 .09594 m
.44617 .09902 L
s
.47318 .08441 m
.4756 .08751 L
s
.50296 .07274 m
.50535 .07587 L
s
.53307 .06095 m
.53543 .06411 L
s
.11352 .22524 m
.11632 .228 L
s
.08781 .23531 m
.09064 .23804 L
s
.06236 .24527 m
.06521 .24798 L
s
.5943 .03698 m
.59658 .04019 L
s
.62543 .02479 m
.62766 .02803 L
s
.6569 .01246 m
.6591 .01573 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.72272 .05198 m
.71658 .05431 L
s
[(2)] .73498 .04732 -1 .38011 Mshowa
.78611 .14895 m
.77994 .15117 L
s
[(4)] .79846 .14452 -1 .3591 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(6)] .8565 .23339 -1 .34028 Mshowa
.89727 .31899 m
.89103 .32101 L
s
[(8)] .90976 .31495 -1 .32334 Mshowa
.94627 .39394 m
.94 .39587 L
s
[(10)] .95881 .39008 -1 .30801 Mshowa
.125 Mabswid
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.7708 .12553 m
.7671 .12688 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.9099 .3383 m
.90615 .3395 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.70593 .0263 m
.70226 .02771 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02753 .3159 m
.03366 .31357 L
s
[(0.25)] .01527 .32056 1 -0.38018 Mshowa
.0184 .3735 m
.02456 .37123 L
s
[(0.5)] .00609 .37805 1 -0.36933 Mshowa
.00893 .43326 m
.01511 .43105 L
s
[(0.75)] -0.00342 .43769 1 -0.35805 Mshowa
.125 Mabswid
.0346 .27129 m
.03827 .26986 L
s
.03285 .28232 m
.03652 .2809 L
s
.03109 .29343 m
.03477 .29202 L
s
.02932 .30463 m
.03299 .30322 L
s
.02573 .32725 m
.02941 .32586 L
s
.02392 .33869 m
.0276 .33731 L
s
.02209 .35021 m
.02578 .34883 L
s
.02025 .36181 m
.02394 .36044 L
s
.01654 .38528 m
.02023 .38392 L
s
.01466 .39714 m
.01835 .39579 L
s
.01276 .40909 m
.01646 .40775 L
s
.01085 .42113 m
.01456 .4198 L
s
.007 .44549 m
.0107 .44417 L
s
.00504 .4578 m
.00876 .45649 L
s
.00308 .4702 m
.00679 .4689 L
s
.0011 .48271 m
.00481 .48141 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.521 .694 .947 r
.37388 .58135 .40489 .61047 .42705 .6106 .39627 .58096 Metetra
.521 .691 .945 r
.39627 .58096 .42705 .6106 .4495 .61078 .41893 .58061 Metetra
.521 .689 .944 r
.41893 .58061 .4495 .61078 .47222 .61102 .44187 .58033 Metetra
.52 .686 .942 r
.44187 .58033 .47222 .61102 .49523 .61134 .4651 .58015 Metetra
.518 .683 .941 r
.4651 .58015 .49523 .61134 .51853 .61176 .48862 .58009 Metetra
.515 .68 .94 r
.48862 .58009 .51853 .61176 .54213 .6123 .51245 .58018 Metetra
.512 .677 .939 r
.51245 .58018 .54213 .6123 .56603 .61298 .53659 .58043 Metetra
.508 .674 .939 r
.53659 .58043 .56603 .61298 .59026 .61381 .56106 .58087 Metetra
.504 .67 .938 r
.56106 .58087 .59026 .61381 .61481 .6148 .58586 .58151 Metetra
.5 .667 .938 r
.58586 .58151 .61481 .6148 .63971 .61596 .611 .58237 Metetra
.495 .665 .938 r
.611 .58237 .63971 .61596 .66495 .61731 .6365 .58346 Metetra
.49 .662 .938 r
.6365 .58346 .66495 .61731 .69055 .61885 .66237 .58479 Metetra
.485 .659 .938 r
.66237 .58479 .69055 .61885 .71652 .62059 .68862 .58636 Metetra
.479 .657 .939 r
.68862 .58636 .71652 .62059 .74287 .62252 .71527 .58817 Metetra
.473 .655 .939 r
.71527 .58817 .74287 .62252 .76962 .62465 .74232 .59023 Metetra
.468 .653 .94 r
.74232 .59023 .76962 .62465 .79677 .62697 .7698 .59253 Metetra
.462 .651 .941 r
.7698 .59253 .79677 .62697 .82434 .62948 .79772 .59507 Metetra
.456 .65 .942 r
.79772 .59507 .82434 .62948 .85235 .63217 .82609 .59782 Metetra
.451 .649 .944 r
.82609 .59782 .85235 .63217 .88079 .63503 .85492 .60077 Metetra
.446 .648 .945 r
.85492 .60077 .88079 .63503 .90969 .63803 .88423 .60392 Metetra
.441 .648 .946 r
.88423 .60392 .90969 .63803 .93906 .64118 .91403 .60723 Metetra
.437 .648 .948 r
.91403 .60723 .93906 .64118 .9689 .64444 .94432 .61069 Metetra
.433 .649 .95 r
.94432 .61069 .9689 .64444 .99922 .6478 .97514 .61426 Metetra
.534 .698 .945 r
.34176 .55109 .37388 .58135 .39627 .58096 .36438 .55004 Metetra
.534 .695 .942 r
.36438 .55004 .39627 .58096 .41893 .58061 .38726 .54905 Metetra
.533 .691 .94 r
.38726 .54905 .41893 .58061 .44187 .58033 .41043 .54814 Metetra
.532 .688 .939 r
.41043 .54814 .44187 .58033 .4651 .58015 .43389 .54735 Metetra
.529 .684 .937 r
.43389 .54735 .4651 .58015 .48862 .58009 .45765 .54671 Metetra
.526 .68 .936 r
.45765 .54671 .48862 .58009 .51245 .58018 .48171 .54625 Metetra
.522 .676 .935 r
.48171 .54625 .51245 .58018 .53659 .58043 .50608 .54599 Metetra
.517 .673 .934 r
.50608 .54599 .53659 .58043 .56106 .58087 .53078 .54597 Metetra
.512 .669 .934 r
.53078 .54597 .56106 .58087 .58586 .58151 .55582 .5462 Metetra
.507 .665 .933 r
.55582 .5462 .58586 .58151 .611 .58237 .58121 .5467 Metetra
.5 .661 .933 r
.58121 .5467 .611 .58237 .6365 .58346 .60697 .54749 Metetra
.494 .658 .934 r
.60697 .54749 .6365 .58346 .66237 .58479 .6331 .54858 Metetra
.487 .655 .934 r
.6331 .54858 .66237 .58479 .68862 .58636 .65963 .54997 Metetra
.48 .652 .935 r
.65963 .54997 .68862 .58636 .71527 .58817 .68657 .55167 Metetra
.473 .649 .935 r
.68657 .55167 .71527 .58817 .74232 .59023 .71393 .55368 Metetra
.466 .647 .937 r
.71393 .55368 .74232 .59023 .7698 .59253 .74173 .55598 Metetra
.459 .645 .938 r
.74173 .55598 .7698 .59253 .79772 .59507 .76999 .55858 Metetra
.452 .643 .939 r
.76999 .55858 .79772 .59507 .82609 .59782 .79873 .56145 Metetra
.445 .642 .941 r
.79873 .56145 .82609 .59782 .85492 .60077 .82795 .56458 Metetra
.439 .641 .942 r
.82795 .56458 .85492 .60077 .88423 .60392 .85767 .56795 Metetra
.433 .641 .944 r
.85767 .56795 .88423 .60392 .91403 .60723 .88792 .57152 Metetra
.427 .641 .946 r
.88792 .57152 .91403 .60723 .94432 .61069 .91869 .57527 Metetra
.422 .641 .948 r
.91869 .57527 .94432 .61069 .97514 .61426 .95 .57917 Metetra
.55 .703 .941 r
.30847 .51958 .34176 .55109 .36438 .55004 .33132 .51774 Metetra
.549 .699 .938 r
.33132 .51774 .36438 .55004 .38726 .54905 .35445 .51595 Metetra
.548 .695 .936 r
.35445 .51595 .38726 .54905 .41043 .54814 .37787 .51427 Metetra
.546 .69 .934 r
.37787 .51427 .41043 .54814 .43389 .54735 .40156 .51274 Metetra
.542 .686 .932 r
.40156 .51274 .43389 .54735 .45765 .54671 .42555 .51139 Metetra
.538 .681 .931 r
.42555 .51139 .45765 .54671 .48171 .54625 .44985 .51026 Metetra
.533 .676 .929 r
.44985 .51026 .48171 .54625 .50608 .54599 .47446 .50939 Metetra
.528 .671 .929 r
.47446 .50939 .50608 .54599 .53078 .54597 .4994 .50881 Metetra
.521 .667 .928 r
.4994 .50881 .53078 .54597 .55582 .5462 .52467 .50855 Metetra
.514 .662 .928 r
.52467 .50855 .55582 .5462 .58121 .5467 .55031 .50863 Metetra
.507 .658 .928 r
.55031 .50863 .58121 .5467 .60697 .54749 .57631 .50906 Metetra
.499 .653 .928 r
.57631 .50906 .60697 .54749 .6331 .54858 .6027 .50988 Metetra
.49 .649 .929 r
.6027 .50988 .6331 .54858 .65963 .54997 .6295 .51108 Metetra
.482 .645 .929 r
.6295 .51108 .65963 .54997 .68657 .55167 .65672 .51266 Metetra
.473 .642 .931 r
.65672 .51266 .68657 .55167 .71393 .55368 .68438 .51464 Metetra
.464 .639 .932 r
.68438 .51464 .71393 .55368 .74173 .55598 .7125 .51699 Metetra
.455 .636 .933 r
.7125 .51699 .74173 .55598 .76999 .55858 .7411 .51972 Metetra
.447 .634 .935 r
.7411 .51972 .76999 .55858 .79873 .56145 .7702 .52279 Metetra
.438 .632 .937 r
.7702 .52279 .79873 .56145 .82795 .56458 .79981 .52619 Metetra
.43 .631 .939 r
.79981 .52619 .82795 .56458 .85767 .56795 .82996 .52988 Metetra
.422 .631 .941 r
.82996 .52988 .85767 .56795 .88792 .57152 .86066 .53384 Metetra
.415 .631 .943 r
.86066 .53384 .88792 .57152 .91869 .57527 .89192 .53802 Metetra
.408 .631 .946 r
.89192 .53802 .91869 .57527 .95 .57917 .92375 .54237 Metetra
.568 .709 .936 r
.27394 .48674 .30847 .51958 .33132 .51774 .29706 .48392 Metetra
.567 .704 .933 r
.29706 .48392 .33132 .51774 .35445 .51595 .32045 .48117 Metetra
.566 .698 .93 r
.32045 .48117 .35445 .51595 .37787 .51427 .34412 .47855 Metetra
.562 .693 .928 r
.34412 .47855 .37787 .51427 .40156 .51274 .36807 .4761 Metetra
.558 .687 .926 r
.36807 .4761 .40156 .51274 .42555 .51139 .39231 .47388 Metetra
.553 .681 .924 r
.39231 .47388 .42555 .51139 .44985 .51026 .41685 .47194 Metetra
.547 .675 .923 r
.41685 .47194 .44985 .51026 .47446 .50939 .4417 .47032 Metetra
.54 .67 .922 r
.4417 .47032 .47446 .50939 .4994 .50881 .46687 .46905 Metetra
.532 .664 .921 r
.46687 .46905 .4994 .50881 .52467 .50855 .49238 .46819 Metetra
.523 .658 .921 r
.49238 .46819 .52467 .50855 .55031 .50863 .51825 .46775 Metetra
.514 .653 .921 r
.51825 .46775 .55031 .50863 .57631 .50906 .5445 .46777 Metetra
.504 .647 .921 r
.5445 .46777 .57631 .50906 .6027 .50988 .57113 .46827 Metetra
.494 .642 .922 r
.57113 .46827 .6027 .50988 .6295 .51108 .59819 .46925 Metetra
.483 .638 .923 r
.59819 .46925 .6295 .51108 .65672 .51266 .62568 .47073 Metetra
.473 .633 .924 r
.62568 .47073 .65672 .51266 .68438 .51464 .65362 .4727 Metetra
.461 .629 .926 r
.65362 .4727 .68438 .51464 .7125 .51699 .68205 .47515 Metetra
.45 .626 .928 r
.68205 .47515 .7125 .51699 .7411 .51972 .71098 .47808 Metetra
.439 .623 .93 r
.71098 .47808 .7411 .51972 .7702 .52279 .74044 .48145 Metetra
.428 .62 .932 r
.74044 .48145 .7702 .52279 .79981 .52619 .77044 .48524 Metetra
.418 .619 .934 r
.77044 .48524 .79981 .52619 .82996 .52988 .80101 .48941 Metetra
.408 .618 .937 r
.80101 .48941 .82996 .52988 .86066 .53384 .83217 .49392 Metetra
.399 .618 .94 r
.83217 .49392 .86066 .53384 .89192 .53802 .86393 .49871 Metetra
.39 .618 .942 r
.86393 .49871 .89192 .53802 .92375 .54237 .89631 .50373 Metetra
.589 .715 .93 r
.23811 .45248 .27394 .48674 .29706 .48392 .26153 .44846 Metetra
.588 .708 .926 r
.26153 .44846 .29706 .48392 .32045 .48117 .28522 .44454 Metetra
.585 .702 .923 r
.28522 .44454 .32045 .48117 .34412 .47855 .30917 .44076 Metetra
.581 .695 .92 r
.30917 .44076 .34412 .47855 .36807 .4761 .33339 .4372 Metetra
.576 .689 .918 r
.33339 .4372 .36807 .4761 .39231 .47388 .35789 .43392 Metetra
.57 .682 .916 r
.35789 .43392 .39231 .47388 .41685 .47194 .38268 .43097 Metetra
.562 .675 .914 r
.38268 .43097 .41685 .47194 .4417 .47032 .40777 .42842 Metetra
.554 .668 .913 r
.40777 .42842 .4417 .47032 .46687 .46905 .43319 .42631 Metetra
.544 .661 .912 r
.43319 .42631 .46687 .46905 .49238 .46819 .45893 .4247 Metetra
.534 .654 .912 r
.45893 .4247 .49238 .46819 .51825 .46775 .48503 .42363 Metetra
.523 .647 .912 r
.48503 .42363 .51825 .46775 .5445 .46777 .5115 .42313 Metetra
.511 .64 .913 r
.5115 .42313 .5445 .46777 .57113 .46827 .53837 .42323 Metetra
.499 .634 .913 r
.53837 .42323 .57113 .46827 .59819 .46925 .56567 .42395 Metetra
.486 .628 .915 r
.56567 .42395 .59819 .46925 .62568 .47073 .59341 .4253 Metetra
.472 .622 .916 r
.59341 .4253 .62568 .47073 .65362 .4727 .62162 .42728 Metetra
.458 .617 .918 r
.62162 .42728 .65362 .4727 .68205 .47515 .65034 .42989 Metetra
.444 .612 .92 r
.65034 .42989 .68205 .47515 .71098 .47808 .67958 .43312 Metetra
.43 .608 .922 r
.67958 .43312 .71098 .47808 .74044 .48145 .70938 .43692 Metetra
.416 .605 .925 r
.70938 .43692 .74044 .48145 .77044 .48524 .73976 .44127 Metetra
.403 .602 .928 r
.73976 .44127 .77044 .48524 .80101 .48941 .77075 .44612 Metetra
.39 .601 .931 r
.77075 .44612 .80101 .48941 .83217 .49392 .80237 .4514 Metetra
.378 .6 .934 r
.80237 .4514 .83217 .49392 .86393 .49871 .83464 .45706 Metetra
.367 .601 .937 r
.83464 .45706 .86393 .49871 .89631 .50373 .86759 .46302 Metetra
.612 .721 .923 r
.20092 .4167 .23811 .45248 .26153 .44846 .22468 .41128 Metetra
.61 .714 .918 r
.22468 .41128 .26153 .44846 .28522 .44454 .24869 .40596 Metetra
.607 .706 .915 r
.24869 .40596 .28522 .44454 .30917 .44076 .27295 .4008 Metetra
.602 .699 .911 r
.27295 .4008 .30917 .44076 .33339 .4372 .29748 .39589 Metetra
.596 .691 .908 r
.29748 .39589 .33339 .4372 .35789 .43392 .32226 .39131 Metetra
.588 .683 .906 r
.32226 .39131 .35789 .43392 .38268 .43097 .34733 .38713 Metetra
.58 .674 .904 r
.34733 .38713 .38268 .43097 .40777 .42842 .37268 .38341 Metetra
.57 .666 .903 r
.37268 .38341 .40777 .42842 .43319 .42631 .39834 .38023 Metetra
.559 .658 .902 r
.39834 .38023 .43319 .42631 .45893 .4247 .42432 .37766 Metetra
.547 .649 .902 r
.42432 .37766 .45893 .4247 .48503 .42363 .45064 .37574 Metetra
.534 .641 .901 r
.45064 .37574 .48503 .42363 .5115 .42313 .47733 .37454 Metetra
.52 .632 .902 r
.47733 .37454 .5115 .42313 .53837 .42323 .50441 .37409 Metetra
.505 .624 .903 r
.50441 .37409 .53837 .42323 .56567 .42395 .53192 .37444 Metetra
.489 .616 .904 r
.53192 .37444 .56567 .42395 .59341 .4253 .55988 .3756 Metetra
.472 .609 .906 r
.55988 .3756 .59341 .4253 .62162 .42728 .58833 .37758 Metetra
.455 .602 .907 r
.58833 .37758 .62162 .42728 .65034 .42989 .61731 .38039 Metetra
.437 .595 .91 r
.61731 .38039 .65034 .42989 .67958 .43312 .64683 .38401 Metetra
.419 .589 .913 r
.64683 .38401 .67958 .43312 .70938 .43692 .67695 .38841 Metetra
.401 .584 .915 r
.67695 .38841 .70938 .43692 .73976 .44127 .70769 .39354 Metetra
.384 .581 .919 r
.70769 .39354 .73976 .44127 .77075 .44612 .73909 .39934 Metetra
.366 .578 .922 r
.73909 .39934 .77075 .44612 .80237 .4514 .77117 .40574 Metetra
.35 .576 .926 r
.77117 .40574 .80237 .4514 .83464 .45706 .80396 .41266 Metetra
.335 .576 .93 r
.80396 .41266 .83464 .45706 .86759 .46302 .83749 .41997 Metetra
.635 .727 .914 r
.16227 .37941 .20092 .4167 .22468 .41128 .18641 .37243 Metetra
.633 .719 .91 r
.18641 .37243 .22468 .41128 .24869 .40596 .21079 .36553 Metetra
.629 .711 .906 r
.21079 .36553 .24869 .40596 .27295 .4008 .23541 .3588 Metetra
.624 .703 .902 r
.23541 .3588 .27295 .4008 .29748 .39589 .26028 .35232 Metetra
.617 .695 .899 r
.26028 .35232 .29748 .39589 .32226 .39131 .28539 .34618 Metetra
.609 .686 .896 r
.28539 .34618 .32226 .39131 .34733 .38713 .31076 .34046 Metetra
.6 .676 .894 r
.31076 .34046 .34733 .38713 .37268 .38341 .3364 .33525 Metetra
.59 .666 .892 r
.3364 .33525 .37268 .38341 .39834 .38023 .36232 .33065 Metetra
.578 .656 .891 r
.36232 .33065 .39834 .38023 .42432 .37766 .38855 .32674 Metetra
.564 .646 .89 r
.38855 .32674 .42432 .37766 .45064 .37574 .4151 .32362 Metetra
.549 .636 .889 r
.4151 .32362 .45064 .37574 .47733 .37454 .442 .32136 Metetra
.533 .625 .889 r
.442 .32136 .47733 .37454 .50441 .37409 .46928 .32004 Metetra
.515 .614 .889 r
.46928 .32004 .50441 .37409 .53192 .37444 .49697 .31972 Metetra
.496 .603 .89 r
.49697 .31972 .53192 .37444 .55988 .3756 .52512 .32047 Metetra
.476 .593 .891 r
.52512 .32047 .55988 .3756 .58833 .37758 .55377 .32232 Metetra
.454 .583 .893 r
.55377 .32232 .58833 .37758 .61731 .38039 .58295 .32528 Metetra
.432 .574 .895 r
.58295 .32528 .61731 .38039 .64683 .38401 .61271 .32936 Metetra
.408 .565 .898 r
.61271 .32936 .64683 .38401 .67695 .38841 .64309 .33453 Metetra
.384 .557 .901 r
.64309 .33453 .67695 .38841 .70769 .39354 .67415 .34074 Metetra
.36 .55 .904 r
.67415 .34074 .70769 .39354 .73909 .39934 .70593 .34792 Metetra
.336 .545 .908 r
.70593 .34792 .73909 .39934 .77117 .40574 .73845 .35597 Metetra
.312 .541 .912 r
.73845 .35597 .77117 .40574 .80396 .41266 .77177 .36476 Metetra
.289 .54 .916 r
.77177 .36476 .80396 .41266 .83749 .41997 .80591 .37414 Metetra
.654 .733 .908 r
.12206 .34078 .16227 .37941 .18641 .37243 .14661 .33232 Metetra
.652 .726 .904 r
.14661 .33232 .18641 .37243 .21079 .36553 .17139 .3239 Metetra
.649 .719 .9 r
.17139 .3239 .21079 .36553 .23541 .3588 .1964 .31557 Metetra
.644 .712 .896 r
.1964 .31557 .23541 .3588 .26028 .35232 .22165 .3074 Metetra
.639 .704 .893 r
.22165 .3074 .26028 .35232 .28539 .34618 .24714 .29948 Metetra
.632 .694 .89 r
.24714 .29948 .28539 .34618 .31076 .34046 .27287 .29189 Metetra
.624 .685 .886 r
.27287 .29189 .31076 .34046 .3364 .33525 .29886 .28475 Metetra
.615 .674 .883 r
.29886 .28475 .3364 .33525 .36232 .33065 .3251 .27817 Metetra
.603 .662 .88 r
.3251 .27817 .36232 .33065 .38855 .32674 .35162 .27227 Metetra
.59 .649 .877 r
.35162 .27227 .38855 .32674 .4151 .32362 .37843 .2672 Metetra
.574 .636 .875 r
.37843 .2672 .4151 .32362 .442 .32136 .40556 .2631 Metetra
.556 .622 .873 r
.40556 .2631 .442 .32136 .46928 .32004 .43304 .26012 Metetra
.536 .607 .871 r
.43304 .26012 .46928 .32004 .49697 .31972 .46091 .25839 Metetra
.514 .592 .87 r
.46091 .25839 .49697 .31972 .52512 .32047 .4892 .25804 Metetra
.49 .577 .87 r
.4892 .25804 .52512 .32047 .55377 .32232 .51798 .2592 Metetra
.463 .562 .87 r
.51798 .2592 .55377 .32232 .58295 .32528 .54729 .26195 Metetra
.433 .547 .872 r
.54729 .26195 .58295 .32528 .61271 .32936 .57719 .26633 Metetra
.402 .532 .874 r
.57719 .26633 .61271 .32936 .64309 .33453 .60776 .27238 Metetra
.368 .519 .876 r
.60776 .27238 .64309 .33453 .67415 .34074 .63906 .28006 Metetra
.333 .507 .879 r
.63906 .28006 .67415 .34074 .70593 .34792 .67114 .28928 Metetra
.296 .496 .883 r
.67114 .28928 .70593 .34792 .73845 .35597 .70408 .29991 Metetra
.259 .487 .887 r
.70408 .29991 .73845 .35597 .77177 .36476 .73792 .31176 Metetra
.222 .481 .891 r
.73792 .31176 .77177 .36476 .80591 .37414 .7727 .3246 Metetra
.663 .738 .906 r
.08012 .30115 .12206 .34078 .14661 .33232 .10504 .29175 Metetra
.662 .735 .904 r
.10504 .29175 .14661 .33232 .17139 .3239 .1302 .28229 Metetra
.661 .732 .902 r
.1302 .28229 .17139 .3239 .1964 .31557 .15561 .27277 Metetra
.66 .727 .899 r
.15561 .27277 .1964 .31557 .22165 .3074 .18126 .26322 Metetra
.658 .722 .896 r
.18126 .26322 .22165 .3074 .24714 .29948 .20717 .25368 Metetra
.655 .715 .892 r
.20717 .25368 .24714 .29948 .27287 .29189 .23333 .2442 Metetra
.651 .707 .888 r
.23333 .2442 .27287 .29189 .29886 .28475 .25974 .23485 Metetra
.646 .696 .883 r
.25974 .23485 .29886 .28475 .3251 .27817 .28641 .22572 Metetra
.638 .684 .877 r
.28641 .22572 .3251 .27817 .35162 .27227 .31334 .21696 Metetra
.629 .67 .871 r
.31334 .21696 .35162 .27227 .37843 .2672 .34053 .20871 Metetra
.616 .654 .864 r
.34053 .20871 .37843 .2672 .40556 .2631 .36801 .20121 Metetra
.601 .636 .857 r
.36801 .20121 .40556 .2631 .43304 .26012 .39577 .19469 Metetra
.582 .616 .851 r
.39577 .19469 .43304 .26012 .46091 .25839 .42386 .18945 Metetra
.559 .594 .845 r
.42386 .18945 .46091 .25839 .4892 .25804 .45231 .18583 Metetra
.532 .57 .839 r
.45231 .18583 .4892 .25804 .51798 .2592 .48117 .18417 Metetra
.5 .546 .835 r
.48117 .18417 .51798 .2592 .54729 .26195 .51051 .18481 Metetra
.463 .521 .832 r
.51051 .18481 .54729 .26195 .57719 .26633 .54041 .18807 Metetra
.42 .494 .83 r
.54041 .18807 .57719 .26633 .60776 .27238 .57098 .1942 Metetra
.371 .468 .829 r
.57098 .1942 .60776 .27238 .63906 .28006 .60231 .20337 Metetra
.316 .442 .83 r
.60231 .20337 .63906 .28006 .67114 .28928 .63454 .2156 Metetra
.253 .416 .831 r
.63454 .2156 .67114 .28928 .70408 .29991 .66776 .23076 Metetra
.184 .391 .832 r
.66776 .23076 .70408 .29991 .73792 .31176 .7021 .24856 Metetra
.11 .368 .831 r
.7021 .24856 .73792 .31176 .7727 .3246 .73762 .26851 Metetra
.664 .741 .908 r
.03634 .26033 .08012 .30115 .10504 .29175 .06157 .25048 Metetra
.664 .741 .908 r
.06157 .25048 .10504 .29175 .1302 .28229 .08706 .24052 Metetra
.663 .74 .907 r
.08706 .24052 .1302 .28229 .15561 .27277 .11281 .23046 Metetra
.663 .74 .907 r
.11281 .23046 .15561 .27277 .18126 .26322 .13882 .2203 Metetra
.663 .739 .906 r
.13882 .2203 .18126 .26322 .20717 .25368 .1651 .21004 Metetra
.663 .737 .905 r
.1651 .21004 .20717 .25368 .23333 .2442 .19166 .19967 Metetra
.663 .735 .903 r
.19166 .19967 .23333 .2442 .25974 .23485 .21848 .18919 Metetra
.663 .732 .901 r
.21848 .18919 .25974 .23485 .28641 .22572 .24559 .17861 Metetra
.662 .726 .897 r
.24559 .17861 .28641 .22572 .31334 .21696 .27298 .16792 Metetra
.661 .719 .892 r
.27298 .16792 .31334 .21696 .34053 .20871 .30066 .15715 Metetra
.659 .709 .885 r
.30066 .15715 .34053 .20871 .36801 .20121 .32863 .14631 Metetra
.656 .695 .875 r
.32863 .14631 .36801 .20121 .39577 .19469 .35689 .13544 Metetra
.651 .678 .863 r
.35689 .13544 .39577 .19469 .42386 .18945 .38546 .12463 Metetra
.643 .655 .847 r
.38546 .12463 .42386 .18945 .45231 .18583 .41432 .11403 Metetra
.632 .628 .829 r
.41432 .11403 .45231 .18583 .48117 .18417 .4435 .10385 Metetra
.616 .597 .809 r
.4435 .10385 .48117 .18417 .51051 .18481 .473 .09449 Metetra
.596 .563 .787 r
.473 .09449 .51051 .18481 .54041 .18807 .50286 .08652 Metetra
.568 .525 .767 r
.50286 .08652 .54041 .18807 .57098 .1942 .53313 .08083 Metetra
.531 .483 .747 r
.53313 .08083 .57098 .1942 .60231 .20337 .56392 .07877 Metetra
.48 .436 .73 r
.56392 .07877 .60231 .20337 .63454 .2156 .5954 .08233 Metetra
.404 .377 .716 r
.5954 .08233 .63454 .2156 .66776 .23076 .62789 .09446 Metetra
.276 .292 .697 r
.62789 .09446 .66776 .23076 .7021 .24856 .66189 .11957 Metetra
.033 .144 .649 r
.66189 .11957 .7021 .24856 .73762 .26851 .69828 .16433 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.13949 .21507 m
.14412 .21971 L
s
[(5)] .13022 .20578 .99821 1 Mshowa
.27343 .16262 m
.27784 .16748 L
s
[(10)] .26461 .1529 .90756 1 Mshowa
.41457 .10735 m
.41872 .11244 L
s
[(15)] .40627 .09719 .81691 1 Mshowa
.56352 .04903 m
.56737 .05434 L
s
[(20)] .55581 .03841 .72626 1 Mshowa
.125 Mabswid
.16573 .20479 m
.16848 .20761 L
s
.19224 .19441 m
.19497 .19725 L
s
.21902 .18393 m
.22172 .18679 L
s
.24608 .17333 m
.24876 .17622 L
s
.30106 .1518 m
.30368 .15474 L
s
.32899 .14087 m
.33158 .14383 L
s
.35721 .12981 m
.35977 .13281 L
s
.38574 .11864 m
.38826 .12167 L
s
.44372 .09594 m
.44617 .09902 L
s
.47318 .08441 m
.4756 .08751 L
s
.50296 .07274 m
.50535 .07587 L
s
.53307 .06095 m
.53543 .06411 L
s
.11352 .22524 m
.11632 .228 L
s
.08781 .23531 m
.09064 .23804 L
s
.06236 .24527 m
.06521 .24798 L
s
.5943 .03698 m
.59658 .04019 L
s
.62543 .02479 m
.62766 .02803 L
s
.6569 .01246 m
.6591 .01573 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[277]:=",
  ImageSize->{288, 233.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jA000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003;ool2001Cool00<Woo`800003ool0000005;oo`00a_oo0`000ooo0P00D_oo002Pool4
0003ool2000Kool20006ool00`00ool0001Aool00:3oo`03003ooooo00?oo`04003ooooo000Gool4
0007ool01000ooooo`00D?oo002Qool00`00ooooo`02ool01000ooooo`005Ooo0P000ooo00<00?oo
ool01Ooo00@00?ooool0053oo`00X_oo00D00?ooooooo`0000;oo`03003ooooo013oo`<000goo`05
003oooooool0001?ool00:?oo`04003ooooo0002ool00`00ooooo`0=ool4000?ool00`00ooooo`02
ool00`00ooooo`1<ool00:3oo`04003ooooo0002ool01000ooooo`003Ooo0P000ooo00<00?ooool0
3Ooo00@00?ooooooo`8004koo`00XOoo0P001?oo0P002ooo0`005_oo00<00?ooool00_oo00<00?oo
ool01?oo1000@ooo002bool2000Iool00`00ooooo`03ool00`00ooooo`03ool00`00ooooo`14ool0
0:ooo`<000;oo`03003ooooo01Koo`03003ooooo00?oo`03003ooooo00Coo`03003ooooo04?oo`00
[Ooo0P007_oo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool0@_oo002Zool3000Pool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`11ool00:Soo`800003ool00?oo023oo`03003ooooo
00Coo`8000?oo`04003ooooo0013ool00:Goo`<000Coo`03003ooooo01koo`03003ooooo00?oo`04
003ooooo0003ool20014ool00:?oo`8002Soo`03003ooooo00Koo`03003ooooo04Ooo`00X?oo0`00
00?oo`00ool09ooo00<00?ooool01ooo00<00?ooool0A_oo002Nool2000]ool00`00ooooo`08ool0
0`00ooooo`15ool007Soo`@000;oo`<001[oo`<002ooo`03003ooooo00Soo`03003ooooo04Goo`00
N_oo00<00?ooool01?oo00<00?ooool05?oo0`0000?oo`00ool0;ooo00<00?ooool02Ooo00<00?oo
ool0A?oo001jool00`00ooooo`04ool00`00ooooo`0Bool2000?ool9000Mool00`00ooooo`08ool3
0015ool007[oo`04003oooooool3000Bool3000:ool700002H?GPoN3eh?g001kMg]GNgMkE`06000G
ool00`00ooooo`0:ool00`00ooooo`13ool007[oo`05003oooooool0000Bool200000ooo003oo`04
ool60003U1P02P00PmN3mh?GPoN3eh?gPmN3m`001g]G00@006<F000001Goo`03003ooooo00_oo`03
003ooooo04;oo`00N?oo0`000ooo00<00?ooool03Ooo0`001Ooo100001jL^IbI002D69@iU1RD>I@H
U3VD6000PmN3mh?GPoN3eh?gPmL007]GNgMkEg]gNeMkMg]GNgL006<fHaH3000Bool00`00ooooo`0<
ool00`00ooooo`11ool007[oo`04003oooooool4000:ool20005ool3000029bIW;VLVIbiW9VL^IbI
0006U1P02@00PoN3eh?gPmN3mh?GPoL00008NeL00`00HaIS5P03HaH2000Aool00`00ooooo`0;ool0
0`00ooooo`11ool008Woo`<00004ool00?ooool30000:IcI002LVIbiW9VL^IbIW;VLVIbi002D>I@H
U3VD69@iU1P008?GPoN3eh?gPmN3mh?GPoL007]gNeMkMg]GNgMkEg]g001S=V<FHcIS5V<fHaH00P00
4?oo00<00?ooool03?oo00<00?ooool0@?oo0027ool20005ool200003YcIW?VLfIciW=T009bIW;VL
VIbiW9VL^IbI0007U1P02@00PmN3mh?GPoN3eh?gPmL00007NeL00`00HaIS5P05HaH3000>ool00`00
ooooo`0;ool30011ool008Coo`<000?oo`@0000cW?VLfIciW=VLnIcIW?T009biW9VL^IbIW;VLVIbi
W9T009@HU3VD69@iU1RD>@00PoN3eh?gPmN3mh?GPoL007]gNeMkMg]GNgMkEg]gNeL006<FHcIS5V<f
HaIS=P00@WI2EP0000goo`03003ooooo00goo`03003ooooo03ooo`00P_oo0P0000?oo`0000000`00
01FU6ZDj002LnIcIW?VLfIciW=VLnIcIW?T009biW9VL^IbIW;VLVIbi00001Y@H00X008?GPoN3eh?g
PmN3mh?GPoL000MkE`03001S5V<F00AS5P05000jET9F>UH0000<ool00`00ooooo`0>ool00`00oooo
o`0nool007ooo`<00003ool000000080000kYAZU>ZDJYCZU6ZDj002LnIcIW?VLfIciW=VLnIcI002L
VIbiW9VL^IbIW;VLV@00U1RD>I@HU3VD69@iU1P008?GPoN3eh?gPmN3mh?G001kEg]gNeMkMg]GNgMk
E`00HaIS=V<FHcIS5V<fHaH0049F@WI2EP02000:ool00`00ooooo`0?ool00`00ooooo`0mool007go
o`8000;oo`80000MYC^U6`00YAZU>ZDJYCZU6ZDjYAX009cIW?VLfIciW=VLnIcIW?T009biW9VL^IbI
W;VLVIbiW9T00006U1P02@00PoN3eh?gPmN3mh?GPoL00008NeL00`00HaIS5P04HaH01`00@UHjET9F
>UI2EP0000Woo`03003ooooo00ooo`03003ooooo03goo`00N_oo0`0004Woo`0000000:DKYC^U6jDk
002U>ZDJYCZU6ZDjYAZU>ZDJ002LfIciW=VLnIcIW?VLfIci002L^IbIW;VLVIbiW9VL^@00U3VD69@i
U1RD>I@H0023eh?gPmN3mh?GPoN3eh?g001kMg]GNgMkEg]gNeMkM`00HcIS5V<fHaIS=V<F0012ET9f
@UI2MT9F@WH00008ool00`00ooooo`0@ool00`00ooooo`0lool005?oo`@000?oo`8001_oo`<000;o
o`<0000QYC^U6jDkYA^U>jDKYC/00:DjYAZU>ZDJYCZU6ZDj002LnIcIW?VLfIciW=VLnIcI002LVIbi
W9VL^IbIW;VLV@0000ND60090023eh?gPmN3mh?GPoN3e`0000MkE`03001S5V<F00AS5P070012ESYF
@UHjET9F>UH00P001ooo00<00?ooool04?oo0P00?Ooo001Eool01@00oooooooo00000_oo00<00?oo
ool05_oo0P000_oo0`0004ZUNjEK002U6jDkYA^U>jDKYC^U6`00YAZU>ZDJYCZU6ZDjYAZU>P00W?VL
fIciW=VLnIcIW?VLf@00W9VL^IbIW;VLVIbiW9T009@HU3VD69@iU1RD>@00PoN3eh?gPmN3mh?GPoL0
07]gNeMkMg]GNgMkEg]g001S=V<FHcIS5V<fHaIS=P00@WI2ET9f@UI2MT9F0P001_oo00<00?ooool0
3ooo00<00?oo00002Ooo00<00?ooool0<Ooo001Eool01@00oooooooo00000_oo00<00?ooool04ooo
0`0002coo`0000000:EkYE^UNjEKYG/00:DkYA^U>jDKYC^U6jDkYA/00:DJYCZU6ZDjYAZU>ZDJ002L
fIciW=VLnIcIW?VLfIci002L^IbIW;VLVIbiW9VL^@001Y@H00X008?GPoN3eh?gPmN3mh?GPoL000Mk
E`03001S5V<F00AS5P0:000jET9F>UI2ESYF@UH000TD0005ool00`00ooooo`0Bool00`00ooooo`06
ool00`00ooooo`0aool005Goo`05003oooooool00002ool00`00ooooo`0Aool20002ool30000D:EK
YG^UFjEkYE^UNjEKYG/00:DkYA^U>jDKYC^U6jDk002U>ZDJYCZU6ZDjYAZU>ZDJ002LfIciW=VLnIcI
W?VLfIci002L^IbIW;VLVIbiW9T009@HU3VD69@iU1RD>I@H0023eh?gPmN3mh?GPoN3e`00NeMkMg]G
NgMkEg]gNeL006<FHcIS5V<fHaIS=P00@WI2ET9f@UI2MT9F00022A@00`00ooooo`02ool00`00oooo
o`0Bool00`00ooooo`03ool5000bool005Goo`05003oooooool00002ool00`00ooooo`0>ool30002
ool20000;ZFKYK/00:EkYE^UNjEKYG^UFjEkYE/00:DKYC^U6jDkYA^U>jDKYC/00:DjYAZU>ZDJYCZU
6ZDj002LnIcIW?VLfIciW=VLnIcI002LVIbiW9VL^IbIW;VLV@001Y@H00T008?gPmN3mh?GPoN3eh?g
00001g]G00<006<FHaH01F<F00/0049F>UI2ESYF@UHjEP000?@9500000?oo`03003ooooo01?oo`03
003ooooo00;oo`04003ooooo000cool005?oo`<000?oo`04003ooooo000>ool20002ool30000EZFk
YI^U^jFK002UFjEkYE^UNjEKYG^UFjEkYE/00:DKYC^U6jDkYA^U>jDK002U6ZDjYAZU>ZDJYCZU6ZDj
002LnIcIW?VLfIciW=VLn@00W;VLVIbiW9VL^IbIW;T009@iU1RD>I@HU3VD69@i0023mh?GPoN3eh?g
PmN3m`00NgMkEg]gNeMkMg]GNgL006<fHaIS=V<FHcIS5P00@UI2MT9F@WI2ET9f00022A@01@00oooo
oooo00005_oo00<00?ooool00_oo00<00?oo0000<ooo001Eool00`00ooooo`02ool2000<ool30002
ool30000<jFKYK^UVjFkYI^U^jFK002UFjEkYE^UNjEKYG^UFjEkYE/00:DKYC^U6jDkYA^U>jDK002U
6ZDjYAZU>ZDJYCZU6P00W=VLnIcIW?VLfIciW=VLn@00W;VLVIbiW9VL^IbIW;T00006U1P02@00PmN3
mh?GPoN3eh?gPmL00007NeL00`00HaIS5P04HaH03000@UHjET9F>UI2ESYF0000m0TD0?@000;oo`03
003ooooo01Coo`03003ooooo00?oo`8003?oo`00I_oo0P0000?oo`0000000P0005b]W:fm002U^jFK
YK^UVjFkYI^U^jFK002UFjEkYE^UNjEKYG^UFjEk002U>jDKYC^U6jDkYA^U>`00YCZU6ZDjYAZU>ZDJ
YCZU6P00W=VLnIcIW?VLfIciW=T009bIW;VLVIbiW9VL^IbI002D69@iU1RD>I@HU3T008?gPmN3mh?G
PoN3eh?gPmL007]GNgMkEg]gNeMkM`00HcIS5V<fHaIS=V<FHcH0049f@UI2MT9F@WI2EP000`TD00<0
0?oo00005Ooo00<00?oo00001Ooo00<00?ooool0<Ooo001Sool60000>Zfl[Ib]_:fL[Kb]W000YI^U
^jFKYK^UVjFkYI^U^jFK002UFjEkYE^UNjEKYG^UFjEk002U>jDKYC^U6jDkYA^U>`00YCZU6ZDjYAZU
>ZDJYCX009ciW=VLnIcIW?VLfIciW=T009bIW;VLVIbiW9VL^@001i@H00T008?gPmN3mh?GPoN3eh?g
00001W]G00<006<FHaH01F<F00l003YF@UHjET9F>UI2EP002A@0m0TD0?@00?oo00005ooo00<00?oo
ool0=_oo001Qool20000I_oo00000:gm[O`00:fL[Kf]W:fm[Ib]_JfL002UVjFkYI^U^jFKYK^UVjFk
002UNjEKYG^UFjEkYE^UNjEK002U6jDkYA^U>jDKYC^U6`00YAZU>ZDJYCZU6ZDjYAZU>P00W?VLfIci
W=VLnIcIW?T009biW9VL^IbIW;VLVIbi002D>I@HU3VD69@iU1P008?GPoN3eh?gPmN3mh?G001kEg]g
NeMkMg]GNgMkE`00HaIS=V<FHcIS5V<f0012MT9F@WI2ET9f@UH000D9508001Ooo`03003ooooo03Ko
o`00G_oo0`0004?oo`00002]g:gl[Mb]o000[Kb]W:fl[Ib]_:fL[Kb]W000YI^U^jFKYK^UVjFkYI^U
^`00YG^UFjEkYE^UNjEKYG^UF`00YA^U>jDKYC^U6jDkYA/00:DJYCZU6ZDjYAZU>ZDJ002LfIciW=VL
nIcIW?VLf@00W9VL^IbIW;VLVIbiW9T00006U1P02P00PoN3eh?gPmN3mh?GPoN3e`001W]G00<006<F
HaH016<F00l003YF@UHjET9F>UI2ESYF0000m0TD0?@9503d00006?oo00<00?ooool0=Ooo001Lool2
0000K?oo00000000[Of]o:gm[Ob]oJgl[Od00:fm[Ib]_JfL[Kf]W:fm[I`00:FKYK^UVjFkYI^U^jFK
YK/00:EkYE^UNjEKYG^UFjEk002U>jDKYC^U6jDkYA^U>`00YCZU6ZDjYAZU>ZDJYCZU6P00W=VLnIcI
W?VLfIciW=T009bIW;VLVIbiW9VL^@00U3VD69@iU1RD>I@HU3T008?gPmN3mh?GPoN3eh?g001kMg]G
NgMkEg]gNeL006<FHcIS5V<fHaIS=V<F0012ET9f@UI2MT9F@WH000D95003003ooooo01Ooo`03003o
oooo03Coo`00FOoo1P0004J]o:gL002]g:gl[Mb]o:gL[Ob]g:gl002]_:fL[Kb]W:fl[Ib]_000YK^U
VjFkYI^U^jFKYK^UVjFk002UNjEKYG^UFjEkYE^UN`00YC^U6jDkYA^U>jDKYC/00:DjYAZU>ZDJYCZU
6ZDj002LnIcIW?VLfIciW=VLn@00W;VLVIbiW9VL^IbIW;T000JD60090023eh?gPmN3mh?GPoN3e`00
00MkE`03001S5V<F00AS5P0=0012ESYF@UHjET9F>UH0003d2A@0m0TD0?@00P006?oo00<00?ooool0
=?oo001Gool50000Kjgm[Ob]oJgl[Of]o000[Ob]oJgl[Of]o:gm[Ob]o@00[Kf]W:fm[Ib]_JfL[Kd0
0:FkYI^U^jFKYK^UVjFkYI/00:EKYG^UFjEkYE^UNjEKYG/00:DkYA^U>jDKYC^U6`00YAZU>ZDJYCZU
6ZDjYAZU>P00W?VLfIciW=VLnIcIW?T009biW9VL^IbIW;VLV@00U1RD>I@HU3VD69@i0023mh?GPoN3
eh?gPmN3mh?G001kEg]gNeMkMg]GNgL006<fHaIS=V<FHcIS5P00@UI2MT9F@WI2ET9f@UH000042A@2
000Gool00`00ool0000eool003Goo`<001coo`H0001;[Mb]o:gL[Ob]g:gl[Mb]o000[Ob]g:gl[Mb]
o:gL[Ob]g000[Ib]_:fL[Kb]W:fl[Ib]_000YK^UVjFkYI^U^jFKYK^UV`00YE^UNjEKYG^UFjEkYE/0
0:DKYC^U6jDkYA^U>jDK002U6ZDjYAZU>ZDJYCZU6P00W=VLnIcIW?VLfIciW=T009bIW;VLVIbiW9VL
^@0000ND60090023mh?GPoN3eh?gPmN3m`0000IkE`03001S5V<F00ES5P0<000jET9F>UI2ESYF@UH0
00TD0?@9503d0P006_oo00<00?ooool0<_oo000hool00`00ooooo`0Fool30000?_oo00000:gl[Od0
0:gm[Ob]oJgl[Of]o:gm[Ob]o@00[Of]o:gm[Ob]oJgl[Of]o000[Ib]_JfL[Kf]W:fm[I`00:FKYK^U
VjFkYI^U^jFKYK^UV`00YE^UNjEKYG^UFjEkYE/00:DKYC^U6jDkYA^U>`00YCZU6ZDjYAX80000<Ici
W=VLnIcI002LVIbiW9VL^IbIW;T009@iU1RD>I@HU3VD6000PmN3mh?GPoN3eh?gPmL007]GNgMkEg]g
NeMkM`00HcIS5V<fHaIS=V<FHcH0049f@UI2MT9F@WI2EP0000@950030009500001Woo`03003ooooo
03;oo`00>?oo00<00?ooool05?oo0P0003[oo`0000000:gl[Mb]o:gL[O`00:gl[Mb]o:gL[Ob]g:gl
[Mb]o000[Ob]g:gl[Mb]o:gL[Ob]g000[Ib]_:fL[Kb]W:fl[I`00:FKYK^UVjFkYI^U^jFKYK^UV`00
YE^UNjEKYG^UFjEk002U>jDKYC^U6`L00005S9Z<^XbJS;X00003O5X=0005U1P02P00PoN3eh?gPmN3
mh?GPoN3e`001W]G00<006<FHaH016<F00l003YF@UHjET9F>UI2ESYF0000m0TD0?@0003d00006_oo
00<00?ooool0<Ooo000eool3000Dool30000=Ooo00000000[Ob]oJgl[Of]o:gm[Ob]o@00[Of]o:gm
[Ob]oJgl[Of]o:gm002]oJgl[Of]o:gm[Ob]o@00[Kf]W:fm[Ib]_JfL[Kf]W000YI^U^jFKYK^UVjFk
YI^U^`00YG^UFjEkYE/01`0001b<fhckS=^<n`00S;Z<VXbjS9Z<^XbJS;X007ajO5YlNWaJO7YlFP00
M1Yd>W@JM3Yd6W@j001[nP@0000QU1RD>@00PoN3eh?gPmN3mh?GPoL007]gNeMkMg]GNgMkE`00HaIS
=V<FHcIS5V<fHaH0049F@WI2ET9f@UI2MP0000<95004000950TD000Jool00`00ooooo`0`ool003Go
o`03003ooooo01;oo`8000;oo`80000^[Mb]o000[Ob]g:gl[Mb]o:gL[Ob]g:gl002]o:gL[Ob]g:gl
[Mb]o:gL002]g:gl[Mb]o:gL[Ob]g:gl002]_:fL[Kb]W:fl[Ib]_:fL002UVjFkYI^U^jFKYK/60000
59CKU?^DfiCk002<nhcKS?^<fhckS=/008bJS;Z<VXbjS9Z<^XbJ0007O5X00`00M1Yd6P04M1X01@00
JoYSfV_jHmX01@0000J3eh?gPmN3mh?G0006NeL00`00HaIS5P05HaH03`00@UHjET9F>UI2ESYF0000
m0TD0?@0003d2A@0000Iool2000bool003Goo`03003ooooo00ooo`<0000`ool00000002]oJgl[Of]
o:gm002]oJgl[Of]o:gm[Ob]oJgl[Od00:gm[Ob]oJgl[Of]o:gm[O`00:gl[Of]o:gm[Ob]oJgl[Od0
0:fm[Ib]_JfL[Kf]W:fm002U^jFK100003:M>idKWC/009CkU=^DniCKU?^Df`00S=^<nhcKS?^<fhck
S=/008bJS;Z<VXbjS9Z<^XbJ001lFWajO5YlNWaJO7X007@jM1Yd>W@JM3Yd6P00JmY[nV_JJoY[fV_j
001K^U^J100001V3mh?G001kEg]gNeMkMg]GNgL006<fHaIS=V<FHcIS5P00@UI2MT9F@WI2ET9f@UH0
00022A@010002A@950006ooo00<00?ooool0;ooo000eool4000<ool20002ool30000:jgL[Ob]g:gl
[Mb]o:gL[O`00:gl[Mb]o:gL[Ob]g:gl[M`00:gL[Ob]g:gl[Mb]o:gL[Ob]g000[Mb]o:gL[Ob]g:gl
[Mb]o000[Kb]W:fl[Ib]_:fL00<0000OWA^M>idKWC^M6idkWA/009CKU?^DfiCkU=^DniCK002<fhck
S=^<nhcKS?/008bjS9Z<^XbJS;Z<VXbj00001gaJ00<007@JM1X017@J00d006?JJoYSfV_jHmY[nP00
FkYKVU^jFiYK^P030006NeL00`00HaIS5P05HaH03`00>UI2ESYF@UHjET9F0009503d0000m0TD0?@0
000Kool00`00ooooo`0^ool004;oo`L0000Z[Ob]o@00[Of]o:gm[Ob]oJgl[Of]o:gm002]oJgl[Of]
o:gm[Ob]oJgl002]o:gm[Ob]oJgl[Of]o:gm[O`00:gl[Of]o:gm[Ob]oJgl002]W:fm100003nM6idk
002M>idKWC^M6idkWA^M>idK002DfiCkU=^DniCKU?/008ckS=^<nhcKS?^<fhck002<^XbJS;Z<VXbj
S9Z<^P00O7YlFWajO5YlNWaJ001d6W@jM1Yd>W@JM3X006_jJmY[nV_JJoY[fP00FiYK^U^JFkYKVU^j
FiX00`0001AkEg]gNeMkM`00HcIS5V<fHaIS=V<FHcH0049f@UI2MT9F@WI2EP000PTD00D000TD2A@9
500001_oo`03003ooooo02koo`00@?oo1@0002^]o:gL[Ob]g:gl[Mb]o000[Ob]g:gl[Mb]o:gL[Ob]
g:gl002]o:gL[Ob]g:gl[Mb]o:gL002]g:gl[Mb]o:gL[Ob]g:gl002]o:gL[Ob]g:gl[Mb]o0030000
9idkWA^M>idKWC^M6`00WA^M>idKWC^M6idkWA^M>`00U?^DfiCkU=^DniCKU?/008ckS=^<nhcKS?^<
f`00S9Z<^XbJS;Z<VXbjS9X00007O5X00`00M1Yd6P04M1X04@00JoYSfV_jHmY[nV?J001KVU^jFiYK
^U^JFkYKVP00DiX00P000W]G00<006<FHaH01F<F00l003YF@UHjET9F>UI2ESYF0000m0000?@9503d
00007?oo00<00?ooool0;Ooo000mool50000:Zgm[O`00:gl[Of]o:gm[Ob]oJgl[Od00:gm[Ob]oJgl
[Of]o:gm[O`00:gl[Of]o:gm[Ob]oJgl[Of]o000[Ob]oJgl[Of]o:gm[Ob]o@00[Of]o0@0001;YG^U
F`00WA^M>idKWC^M6idkWA/009dKWC^M6idkWA^M>idKWC/009CkU=^DniCKU?^Df`00S=^<nhcKS?^<
fhckS=/008bJS;Z<VXbjS9Z<^XbJ001lFWajO5YlNWaJO7X007@jM1Yd>W@JM3Yd6P00JmY[nV_JJoY[
fV_j001K^U^JFkYKVU^jFiYK^P00DkYCVU>j0080000CNeL006<FHcIS5V<fHaIS=P00@WI2ET9f@UI2
MT9F@WH000TD000010TD00<00?ooool06Ooo00<00?ooool0;Ooo000kool50000:JgL[Ob]g:gl[M`0
0:gL[Ob]g:gl[Mb]o:gL[O`00:gl[Mb]o:gL[Ob]g:gl[M`00:gL[Ob]g:gl[Mb]o:gL[Ob]g000[Mb]
o:gL[Ob]g:gl[M`00`0002nUFjEkYE^UNjEKYG/009dkWA^M>idKWC^M6idk002M>idKWC^M6idkWA^M
>idK002DfiCkU=^DniCKU?^Df`00S=^<nhcKS?^<fhck002<^XbJS;Z<VXbjS9Z<^P0000MlFP03001d
6W@J00Ad6P0D001SfV_jHmY[nV?JJoX005^jFiYK^U^JFkYKVU^j001C^U>JDkYCVP<000IS5P0?0012
ESYF@UHjET9F>UH0003d2A@000TD0?@9500001_oo`8002koo`00>?oo0`0002[oo`0000000:gl[Of]
o:gm[Ob]oJgl002]o:gm[Ob]oJgl[Of]o:gm002]oJgl[Of]o:gm[Ob]oJgl002]o:gm[Ob]oJgl[Of]
o:gm[O`00:gl[Od40000EjELYGd00:EkYE^UNjEKYG^UFjEk002M>idKWC^M6idkWA^M>`00WC^M6idk
WA^M>idKWC^M6`00U=^DniCKU?^DfiCk002<nhcKS?^<fhckS=^<n`00S;Z<VXbjS9Z<^XbJS;X007aj
O5YlNWaJO7YlFP00M1Yd>W@JM3Yd6W@j001[nV_JJoY[fV_jJmX005^JFkYKVU^jFiYK^U^J001CVU>j
DiYC^U>J0013FP0200003f<fHaIS=V<F0012ET9f@UI2MT9F@WI2EP002A@000042A@00`00ooooo`0J
ool00`00ooooo`05ool2000Tool003Koo`8000;oo`80000V[Mf]o@00[Ob]g:gl[Mb]o:gL[Ob]g000
[Mb]o:gL[Ob]g:gl[Mb]o000[Ob]g:gl[Mb]o:gL[Ob]g000[Mb]o:gL[Ob]g:gl[Mb]o0<0000gYGbU
G:ElYEbUO:EL002UFjEkYE^UNjEKYG^UFjEk002M>idKWC^M6idkWA^M>`00WC^M6idkWA^M>idKWC/0
09CkU=^DniCKU?^DfiCk002<nhcKS?^<fhckS=/008bJS;Z<VXbjS9Z<^XbJ00001WaJ00<007@JM1X0
1G@J01P006_jHmY[nV?JJoYSfP00FiYK^U^JFkYKVU^jFiX005>JDkYCVU>jDiX003]J@eX20002HaH0
4000@UHjET9F>UI2ESYF@UH000TD0009503d2A@0m0007?oo00<00?ooool01?oo00@00?ooool002?o
o`00<ooo0`0002[oo`0000000:gn[Of]oZgm[Oh00:gm[Ob]oJgl[Of]o:gm[O`00:gl[Of]o:gm[Ob]
oJgl[Od00:gm[Ob]oJgl[Of]o:gm[O`00:gl[Of]o:gm[O`20000HZFmYI`00:ELYGfUG:EmYEbUOJEL
002UFjEkYE^UNjEKYG^UF`00WA^M>idKWC^M6idkWA/009dKWC^M6idkWA^M>idKWC/009CkU=^DniCK
U?^DfiCk002<nhcKS?^<fhckS=/008bJS;Z<VXbjS9Z<^XbJ001lFWajO5YlNWaJO7X007@jM1Yd>W@J
M3Yd6P00JmY[nV_JJoY[fV_j001K^U^JFkYKVU^jFiYK^P00DkYCVU>jDiYC^P00@gY3FT=j@eX20000
2f<f0012MT9F@WI2ET9f@UH000TD000010TD00<00?ooool06ooo00<00?ooool00ooo00@00?ooool0
02?oo`00<?oo0`000_oo0`0002J]gJgm[Mf]oJgM[Of]gJgm002]o:gL[Ob]g:gl[Mb]o000[Ob]g:gl
[Mb]o:gL[Ob]g:gl002]o:gL[Ob]g:gl[Mb]o:gL002]g:gl0P0003fUW:FlYIbU_000YGbUG:ElYEbU
O:ELYGbUG000YE^UNjEKYG^UFjEkYE/009dKWC^M6idkWA^M>idK002M6idkWA^M>idKWC^M6`00U=^D
niCKU?^DfiCkU=/008cKS?^<fhckS=^<n`00S;Z<VXbjS9Z<^XbJS;X00006O5X00`00M1Yd6P05M1X0
6`00HmY[nV?JJoYSfV_j001K^U^JFkYKVU^jFiYK^P00DkYCVU>jDiYC^P00@eXkFT=J>eY3FP030000
1T9F>UI2ESYF@UHjEP8000062A@0m0TD0?@950007Ooo00<00?ooool00_oo0`009?oo000^ool20000
0ooo0000000200009Zgm[Oh00:gn[Of]oZgm[Oj]oJgn[Of]oP00[Of]o:gm[Ob]oJgl[Od00:gm[Ob]
oJgl[Of]o:gm[Ob]o@00[Of]o:gm[Ob]oJgl[Od30000JjFmYIbU_JFLYKfUW:Fm002UOJELYGfUG:Em
YEbUOJEL002UFjEkYE^UNjEKYG^UF`00WA^M>idKWC^M6idkWA/009dKWC^M6idkWA^M>idK002DfiCk
U=^DniCKU?^Df`00S=^<nhcKS?^<fhck002<^XbJS;Z<VXbjS9Z<^P00O7YlFWajO5YlNWaJ001d6W@j
M1Yd>W@JM3X006_jJmY[nV_JJoY[fP00FiYK^U^JFkYKVU^jFiX005>JDkYCVU>jDiX004=J@gY3FT=j
@eY3NP00:cX00P0000A2ET9f@UI2MP8000D95003003ooooo01_oo`8000?oo`03003ooooo02Coo`00
:ooo1P0002J]oJgM[Of]gJgm[Mf]o@00[Of]gJgm[Mf]oJgM[Of]gJgm002]o:gL[Ob]g:gl[Mb]o000
[Ob]g:gl[Mb]o:gL[Ob]g:gl002]o:gL100004>U_:FL002UW:FlYIbU_:FLYKbUW:Fl002UO:ELYGbU
G:ElYEbUO000YG^UFjEkYE^UNjEKYG/009dkWA^M>idKWC^M6idk002M>idKWC^M6idkWA^M>`00U?^D
fiCkU=^DniCKU?/008ckS=^<nhcKS?^<f`00S9Z<^XbJS;Z<VXbjS9X00006O5X00`00M1Yd6P05M1X0
7@00JoYSfV_jHmY[nV?J001KVU^jFiYK^U^JFkX005>jDiYC^U>JDkYCVP00>eY3FS]J@eXkFT=J0000
0R/J0P0000Y2ESYF000000TD0?@9503d2A@001coo`03003oo`0000?oo`03003ooooo02Coo`00:Ooo
0P0002Woo`00002]oZgm002]oJgn[Of]oZgm[Oj]oJgn002]oZgm[Oj]oJgn[Of]oZgm[Oh00:gm[Ob]
oJgl[Of]o:gm002]oJgl[Of]o:gm[Ob]oJgl00<0001fYIbU_JFLYKfUW:FmYI`00:FLYKfUW:FmYIbU
_JFLYKd00:EmYEbUOJELYGfUG:Em002UNjEKYG^UFjEkYE^UN`00WC^M6idkWA^M>idKWC/009dkWA^M
>idKWC^M6idk002DniCKU?^DfiCkU=^Dn`00S?^<fhckS=^<nhcK002<VXbjS9Z<^XbJS;Z<VP00O5Yl
NWaJO7YlFWaj001d>W@JM3Yd6W@jM1X006_JJoY[fV_jJmY[nP00FkYKVU^jFiYK^U^JFkX005>jDiYC
^U>JDkX004=j@eY3NT=J@gY3FP00:aX[>R/J:cX400062A@00`00ooooo`0Lool01000oooooooo0`00
8ooo000Vool600009ZgM[Of]gJgm[Md00:gM[Of]gJgm[Mf]oJgM[Od00:gm[Mf]oJgM[Of]gJgm[Mf]
o@00[Ob]g:gl[Mb]o:gL[O`00:gl[Mb]o:gL[O`20000BjFLYK`00:FlYIbU_:FLYKbUW:Fl002U_:FL
YKbUW:FlYIbU_:FL002UG:ElYEbUO:ELYGbUG:El002UNjEKYG^UFjEkYE^UN`00WC^M6idkWA^M>idK
002M6idkWA^M>idKWC^M6`00U=^DniCKU?^DfiCkU=/008cKS?^<fhckS=^<n`00S;Z<VXbjS9Z<^XbJ
S;X00006O5X00`00M1Yd6P05M1X07@00HmY[nV?JJoYSfV_j001K^U^JFkYKVU^jFiX005>JDkYCVU>j
DiYC^P00@eXkFT=J>eY3FS]J00000R/J1P0000H0m0TD0?@9503d000Nool00`00ooooo`0Wool002Co
o`80000Zool00000002]oZgm[Oj]oJgn[Of]oZgm002]oJgn[Of]oZgm[Oj]oJgn002]oZgm[Oj]oJgn
[Of]oZgm[Oh00:gm[Ob]oJgl[Of]o:gm002]oJgl0P0007NU_JFLYKfUW:Fm002U_JFLYKfUW:FmYIbU
_@00YKfUW:FmYIbU_JFLYKfUW000YEbUOJELYGfUG:EmYE`00:EKYG^UFjEkYE^UNjEK002M6idkWA^M
>idKWC^M6`00WA^M>idKWC^M6idkWA/009CKU?^DfiCkU=^DniCK002<fhckS=^<nhcKS?/008bjS9Z<
^XbJS;Z<VXbj001lNWaJO7YlFWajO5X007@JM3Yd6W@jM1Yd>P00JoY[fV_jJmY[nV_J001KVU^jFiYK
^U^JFkYKVP00DiYC^U>JDkYCVP00@eY3NT=J@gY3FT=j00<00005:cX[6R/j:aX[>P0200052A@00`00
ooooo`0Lool00`00ooooo`0Vool002;oo`D0000V[Of]g@00[Mf]oJgM[Of]gJgm[Mf]oJgM002]gJgm
[Mf]oJgM[Of]gJgm002]oJgM[Of]gJgm[Mf]oJgM[Od00:gl[Mb]o:gL[Ob]g0<0001@YIbU_:FLYKbU
W:FlYIbU_000YKbUW:FlYIbU_:FLYK`00:FlYIbU_:FLYKbUW:FlYI`00:ELYGbUG:ElYEbUO:EL002U
FjEkYE^UNjEKYG^UF`00WA^M>idKWC^M6idkWA/009dKWC^M6idkWA^M>`00U?^DfiCkU=^DniCKU?/0
08ckS=^<nhcKS?^<f`00S9Z<^XbJS;Z<VXbjS9X000IlFP03001d6W@J00Ed6P0H001[nV?JJoYSfV_j
HmX005^JFkYKVU^jFiYK^P00DkYCVU>jDiYC^U>J000kFT=J0`0000=3FP00:aX01B/J100000@9503d
2A@001ooo`03003ooooo02Goo`008_oo0P0002J]oZgm[Oj]oJgn[Od00:gm[Oj]oJgn[Of]oZgm[Oj]
o@00[Of]oZgm[Oj]oJgn[Of]oP00[Oj]oJgn[Of]oZgm[Oj]oJgn002]oJgl0`0003V]o:gm002U_JFL
YKfUW:FmYIbU_JFL002UW:FmYIbU_JFLYKfUW:Fm002U_JFLYKfUW:FmYIbU_@00YGfUG:EmYEbUOJEL
YGfUG000YE^UNjEKYG^UFjEkYE/009dKWC^M6idkWA^M>`00WC^M6idkWA/07P0001mlNWaJO7X007@j
M1Yd>W@JM3Yd6P00JmY[nV_JJoY[fV_j001K^U^JFkYKVU^jFiYK^P00DkYCVU>jDiYC^P03000034=j
@eY3NT=J000[6R/j:aX[>R/J:cX[6P8000056_X000002A@0000Nool2000Wool002;oo`80000S[Mf]
oJgM[Of]gJgm[Md00:gM[Of]gJgm[Mf]oJgM[Of]g@00[Mf]oJgM[Of]gJgm[Mf]o@00[Of]gJgm[Mf]
oJgM[Of]g@030000=JgL[Ob]g:gl[Mb]o000YKbUW:FlYIbU_:FLYKbUW000YIbU_:FLYKbUW:FlYI`0
0:FLYKbUW:FlYIbU_:FLYK`00:ElYEbUO:ELYGbUG:ElYE`00:EKYG^UFjEkYE^UN`00WC^M6idkWA/0
1`0001b<fhckS=^<n`00S?^<fhckS=^<nhcKS?/008BkQ9^4^hBKQ;^4V`00O9]l^gbKO;]lVgbkO9/0
009dF`L000Ad6P0B001SfV_jHmY[nV?JJoX005^jFiYK^U^JFkYKVP00DiYC^U>J100000M3FS]J@eXk
FT=J>eX00006:aX01@006]X001[J2]X00`007ooo00<00?ooool09?oo000Kool20005ool08`00ool0
0:gm[Oj]oJgn[Of]oZgm002]oJgn[Of]oZgm[Oj]oJgn[Od00:gm[Oj]oJgn[Of]oZgm[Oh00:gn[Of]
oZgm[Oh00P00036]o:gm002]oJgl[Of]o:gm[Ob]o@00YKfUW:FmYIbU_JFLYKfUW000YIbU_JFLYKfU
W:FmYI`00:FLYKfUW:FmYIbU_JFLYKd00:EmYEbUOJELYGfUG:Em002UNjEKYG^UF`070000;9DKUC^E
6iDk002<nhcKS?^<fhckS=/008cKS?^<fhckS=^<nhcK0024VhBkQ9^4^hBKQ;/007bkO9]l^gbKO;]l
Vgbk001dNgAKM7]dFgAkM5/006aKK7/800002f_JJoY[fP00FiYK^U^JFkYKVU^jFiX00`00019CVU>j
DiX004=J@gY3FT=j@eY3NP00:cX[6R/j:aX[>R/J:cX200001A[J6_XJfQ[j00008?oo00<00?ooool0
8ooo000Jool01000ooooo`000ooo0P000_oo01h00:gM[Of]gJgm[Mf]oJgM002]gJgm[Mf]oJgM[Of]
gJgm[Md00:gM[Of]gJgm[Mf]oJgM[Od00:gm[Md20000;Zgl[Mb]o:gL[O`00:gl[Mb]o:gL[Ob]g:gl
002U_:FLYKbUW:FlYIbU_:FL002UW:FlYIbU_:FLYKbUW000YIbU_:FLYKbUW:FlYIbU_000YGbUG:El
YEbUO:EL1@0002^E79DlUAbE?000UC^E6iDkUA^E>iDK002<fhckS=^<nhcKS?^<f`00S=^<nhcKS?^<
fhckS=/008BKQ;^4VhBkQ9^4^`00O;]lVgbkO9]l^gbKO;/00005M5/02@00K5]TFfaKI5]/FfAKK5/0
0002I5/600000e^jFiX0000300003U>jDiYC^U>JDkYCVP00>eY3FS]J@eXkFT=J0006:aX020002]X0
00[J6]X:fQ[J000Oool00`00ooooo`0Sool001[oo`04003ooooo0003ool00`00ooooo`02ool02000
[Of]oZgm[Oj]oJgn[Od200004:gn[Of]oZgm[Oj]oJgn[Od00:gm[Oj]oJgn[Of]oZgm0`0002b]o:gm
[Ob]oJgl[Of]o000[Ob]oJgl[Of]o:gm[Ob]o@00YKfUW:FmYIbU_JFLYKfUW000YIbU_JFLYKfUW:Fm
YI`00:FLYKfUW:FmYIbU_JFL002UG:Em100004FMG9em002E?IDLUCfE79DmUA`009DKUC^E6iDkUA^E
>iDK002<fhckS=^<nhcKS?/008ckS=^<nhcKS?^<fhck0024^hBKQ;^4VhBkQ9/007bKO;]lVgbkO9]l
^gbK001dFgAkM5]dNgAKM7/006akK5]/NfaKK7]/F`00I5]TNfAKI7]TFfAkI5/01@0001iKVU^j001C
^U>JDkYCVU>j0013NT=J@gY3FT=j@eX002/J:cX[6R/j:aX[>R/J000JfP006]XJnQ[J000Pool00`00
ooooo`0Rool001[oo`04003ooooo0003ool00`00ooooo`03ool05@00[Mf]oJgM[Of]gJgm[Mf]o@00
[Of]gJgm[Mf]oJgM[Of]g@00[Mf]o@040000;:gL[O`00:gl[Mb]o:gL[Ob]g:gl[M`00:gL[Ob]g:gl
[Mb]o:gL002UW:FlYIbU_:FLYKbUW:FlYI`00:FLYKbUW:FlYIbU_000YKbUW:FlYIbU_:FLYK`30000
=IelWEbMO9eLWGbMG000UAbE?9DLUCbE79DlUA`009DKUC^E6iDkUA^E>iDK002<fhckS=^<nhcKS?/0
08ckS=^<nhcKS?^<fhck0024^hBKQ;^4VhBkQ9/007bKO;]lVgbkO9]l^gbK00001GAK00T006AKK5]T
FfaKI5]/FfAK00000fAK100015`L100000eC^U>JDkYCVU>j0013FS]J@eXkFT=J>eX00006:aX02000
6]X001[J2]XJfP[J000Pool00`00ooooo`0Qool001[oo`04003ooooo0003ool20005ool04@00[Of]
oZgm[Oj]oJgn[Of]oP00[Oj]oJgn[Of]oZgm[Oh00`0002b]oJgl[Of]o:gm[Ob]o@00[Of]o:gm[Ob]
oJgl[Of]o000[Ob]oJgl[Of]o:gm[O`00:FLYKfUW:FmYIbU_JFLYKd00:FmYIbU_JFLYKfUW:Fm002U
_JFL100004FMOIeL002MG9emWEbMOIeLWGfMG000UAbE?IDLUCfE79DmUA`009DKUC^E6iDkUA^E>`00
S?^<fhckS=^<nhcKS?/008ckS=^<nhcKS?^<f`00Q9^4^hBKQ;^4VhBk001l^gbKO;]lVgbkO9]l^`00
M7]dFgAkM5]dNgAK001/FfakK5]/NfaKK7/0100000]TFfAkI5]TN`00G3eL75`mG1aL?E`L00<0000I
DiYC^U>J0013FT=j@eY3NT=J@gX002/j:aX[>R/J:cX[6R/j000JnP006_XJfQ[j00007ooo0P008ooo
000Jool01000ooooo`000ooo00<00?ooool01Ooo00h00:gM[Of]gJgm[Mf]oJgM[Od00:gm[Mf]oJgM
0P0002b]o:gL002]g:gl[Mb]o:gL[Ob]g:gl002]o:gL[Ob]g:gl[Mb]o:gL002]g:gl[Mb]o:gL[Ob]
g000YIbU_:FLYKbUW:FlYIbU_000YKbUW:FlYIbU_:FL0`0003fMG9elWEbMO9eLWG`009elWEbMO9eL
WGbMG9elWE`009DLUCbE79DlUAbE?000UC^E6iDkUA^E>iDKUC/008ckS=^<nhcKS?^<f`00S=^<nhcK
S?^<fhckS=/008BKQ;^4VhBkQ9^4^`00O;]lVgbkO9]l^gbKO;/00005M5/01@00K5]TFfaKI5/01000
1VAK00<005`LG1`015`L00<005@LE1`00`0000UCVP00>eY3FS]J@eXkFT=J00001R/J00P000[J6]X0
01[J2]XJfP008?oo00<00?ooool08?oo000Kool20004ool00`00ooooo`06ool02`00[Of]oZgm[Oj]
oJgn[Of]oP00[Oh00P0002^]o:gm[Ob]oJgl002]o:gm[Ob]oJgl[Of]o:gm002]oJgl[Of]o:gm[Ob]
oJgl002]o:gm[Ob]oJgl[Of]o000YIbU_JFLYKfUW:FmYIbU_@00YKfUW0030000B9eLWGd009emWEbM
OIeLWGfMG9em002MOIeLWGfMG9emWEbMO@00UCfE79DmUAbE?IDLUCd009DkUA^E>iDKUC^E6iDk002<
nhcKS?^<fhckS=/008cKS?^<fhckS=^<n`00Q;^4VhBkQ9^4^hBK001lVgbkO9]l^gbKO;]lV`00M5]d
NgAKM7]dFgAk001/N`80000GK5]/NfaK001TFfAkI5]TNfAKI7]TF`00G1aL?E`LG3eL75`m001D?E@L
E3eD700300005D=J@gY3FT=j@eX002/J:cX[6R/j:aX[>R/J000JfQ[j000JnQ[J6_X0000Pool00`00
ooooo`0Oool0023oo`8000Woo`08002]gJgm[Mf]oJgM[Of]g@80000Z[Ob]g:gl[Mb]o:gL[Ob]g000
[Mb]o:gL[Ob]g:gl[Mb]o000[Ob]g:gl[Mb]o:gL[Ob]g000[Mb]o:gL[Ob]g:gl[M`00:FLYKbUW:Fl
YIbU_:FL0`0004BMG9elWEbMO9eLWG`009elWEbMO9eLWGbMG9el002MO9eLWGbMG9elWEbMO000UCbE
79DlUAbE?9DLUC`009DkUA^E>iDKUC^E6`00S=^<nhcKS?^<fhckS=/008cKS?^<fhckS=^<n`00Q;^4
VhBkQ9^4^hBK001lVgbkO9]l^gbKO;]lV`0017AK0`0000M/FfAKK5]TFfaKI5/00006I5/00`00G1aL
7004G1`00`00E1aD7004E1`4000013]J@eXkFP001R/J00P001[J2]X000[J6]X:fP008?oo00<00?oo
ool07ooo000Pool00`00ooooo`09ool00`00[Of]oP040000::gl[Od00:gm[Ob]oJgl[Of]o:gm[O`0
0:gl[Of]o:gm[Ob]oJgl[Od00:gm[Ob]oJgl[Of]o:gm002]oJgl[Of]o:gm[Ob]oJgl002UW:Fm1000
04RUW:Fm002MOIeLWGfMG9emWE`009eLWGfMG9emWEbMOIeLWGd009emWEbMOIeLWGfMG9em002E?IDL
UCfE79DmUA`009DKUC^E6iDkUA^E>iDK002<fhckS=^<nhcKS?/008ckS=^<nhcKS?^<fhck0024^hBK
Q;^4VhBkQ9/007bKO;]lVgbkO9]l^`00M7/300008WAkM5/006aKK7]/FfakK5]/N`00I7]TFfAkI5]T
NfAKI7/005`mG1aL?E`LG3eL7000E1aD?E@LE3eD7000Bma;oD_L100000l[>R/J:cX[6R/j:aX[>P00
6_XJfP006]XJnQ[J00008?oo00<00?ooool07_oo000Pool00`00ooooo`0:ool20000:Jgl[Mb]o:gL
[Ob]g:gl002]o:gL[Ob]g:gl[Mb]o:gL002]g:gl[Mb]o:gL[Ob]g:gl002]o:gL[Ob]g:gl[Mb]o000
[Ob]g:gl[Mb]o:gL[O`00`0004VU_:FLYKbUW:FlYI`009eLWGbMG9elWEbMO9eL002MG9elWEbMO9eL
WGbMG000WEbMO9eLWGbMG9elWE`009DLUCbE79DlUAbE?9DL002E6iDkUA^E>iDKUC^E6`00S=^<nhcK
S?^<fhck002<nhcKS?^<fhckS=/008BKQ;^4VhBkQ9^4^`00O;]lVgbkO9]l^`030006M5/02000I5]/
FfAKK5]TFfaK0006I5/00`00G1aL7004G1`00`00E1aD7004E1`01P00Bma;o4_LBoa;g0<000D[6P08
000:fQ[J2]X000[J6]X001ooo`8000Soo`8001Koo`008?oo0P003?oo02H00:gl[Of]o:gm[Ob]oJgl
[Od00:gm[Ob]oJgl[Of]o:gm[O`00:gl[Of]o:gm[Ob]oJgl[Od00:gm[Ob]oJgl[Of]o:gm002]oJgl
100004VU_JFL002UW:FmYIbU_JFLYKfUW000WEbMOIeLWGfMG9emWE`009eLWGfMG9emWEbMOIeL002M
G9emWEbMOIeLWGfMG000UAbE?IDLUCfE79DmUA`009DKUC^E6iDkUA^E>`00S?^<fhckS=^<nhcK002<
fhckS=^<nhcKS?^<f`00Q9^4^hBKQ;^4VhBk001l^`030000;GbkO9/007AKM7]dFgAkM5]dN`00K7]/
FfakK5]/NfaKK7/006AkI5]TNfAKI7]TF`00G1aL?E`LG3eL75`m001D?E@LE3eD75@mE1`004_LBoe;
g4_mBma;o@0400002b/J:cX[6P006]XJnQ[J000JfQ[j00008?oo00<00?ooool01?oo00@00?ooool0
01Goo`008?oo00<00?ooool03?oo02800:gL[Ob]g:gl[Mb]o:gL[O`00:gl[Mb]o:gL[Ob]g:gl[M`0
0:gL[Ob]g:gl[Mb]o:gL[O`00:gl[Mb]o:gL[Ob]g0<0001:YIbU_:FLYKbUW:FlYI`00:FLYKbUW:Fl
YIbU_:FL002MG9elWEbMO9eLWGbMG000WEbMO9eLWGbMG9elWE`009eLWGbMG9elWEbMO9eL002E79Dl
UAbE?9DLUC`009DkUA^E>iDKUC^E6iDk002<nhcKS?^<fhckS=/008cKS?^<fhckS=^<n`00Q;^4VhBk
Q9^4^`<00007O;]lVgbkO9]l^gbK00001WAK00P006aKI5]/FfAKK5]TF`001VAK00<005`LG1`015`L
00<005@LE1`015@L00/004_lBma;o4_LBoa;g000>ma3o3_L00@000086]X:fQ[J000JfP[J6]X0023o
o`03003ooooo00?oo`04003ooooo000Eool0023oo`8000koo`09002]o:gm[Ob]oJgl[Of]o:gm0080
000C[Ob]oJgl[Of]o:gm[O`00:gl[Of]o:gm[Ob]oJgl[Od00:gm[O`00`0004ZUW:Fm002U_JFLYKfU
W:FmYIbU_@00YKfUW:FmYIbU_JFLYKfUW000WEbMOIeLWGfMG9em002MOIeLWGfMG9emWEbMO@00WGfM
G9emWEbMOIeLWGd009DmUAbE?IDLUCfE79Dm002E>iDKUC^E6iDkUA^E>`00S?^<fhckS=^<nhcK002<
fhckS=^<nhcKS?/008Bk0`0003Z4^hBK001lVgbkO9]l^gbKO;/007AkM5]dNgAKM7]dF`00K5]/NfaK
K7]/FfakK5/006AKI7]TFfAkI5]TN`00G3eL75`mG1aL?E`L001D75@mE1aD?E@LE3d004_mBma;oD_L
Boe;g000@ma3oD?L@oe3g0<000066]XJnP006_XJfP008?oo00<00?ooool01?oo0P005_oo000Oool2
000@ool06P00[Mb]o:gL[Ob]g:gl[Mb]o:gL002]g:gl[Mb]o:gL[Ob]g000[Mb]o:gL[Ob]g:gl[M`3
0000BZFLYKbUW:FlYIbU_000YKbUW:FlYIbU_:FLYK`00:FlYIbU_:FLYKbUW:Fl002MO9eLWGbMG9el
WEbMO000WGbMG9elWEbMO9eLWG`009elWEbMO9eLWGbMG9el002E?9DLUCbE79DlUAbE?000UC^E6iDk
UA^E>iDK002<fhckS=^<nhcKS?/008ckS=^<nhcKS?/300003XBkQ9^4^hBKQ;/007bkO9]l^gbKO;]l
Vgbk0006M5/02000I5]/FfAKK5]TFfaK0006I5/00`00G1aL7005G1`00`00E1aD7004E1`03P00Boa;
g4_lBma;o4_L000kg4?l>ma3o3_L@o`500000a[J2]X0000Pool00`00ooooo`02ool01000ooooo`00
5Ooo0006ool20004ool00`00ooooo`02ool40002ool30005ool00`00ooooo`0@ool200004jgm[Ob]
oJgl[Of]o:gm[O`00:gl[Of]o:gm[Ob]oJgl002]o:gm00@0000nYObUo@00YKfUW:FmYIbU_JFLYKd0
0:FmYIbU_JFLYKfUW:Fm002U_JFLYKfUW:FmYIbU_@00WGfMG9emWEbMOIeLWGd009emWEbMOIeLWGfM
G9em002MOIeLWGfMG9emWEbMO@00UCfE79DmUAbE?IDL002E6iDkUA^E>a`0000iO9]l^gbK001dFgAk
M5]dNgAKM7/006akK5]/NfaKK7]/Ffak001TNfAKI7]TFfAkI5/005`LG3eL75`mG1aL?@00E3eD75@m
E1aD?E@L001;g4_mBma;oD_LBod004?m@ma3oD?L@oe3g000>m`koC_L00@001ooo`<000?oo`04003o
oooo000Eool000Goo`04003ooooo0008ool00`00ooooo`06ool00`00ooooo`02ool2000Cool04000
[Ob]g:gl[Mb]o:gL[Ob]g000[Mb]o:gL[Ob]g:gl0`0003^Uo:GLYObUg:GlYMbUo000YKbUW:FlYIbU
_:FLYK`00:FlYIbU_:FLYKbUW:Fl002U_:FLYKbUW:FlYIbU_000WGbMG9elWEbMO9eLWG`009elWEbM
O9eLWGbMG9el002MO9eLWGbMG9elWE`009DLUCbE79Dl00L0000:SCb=78dlSA`008cLS?b<g8clS=`3
00003hCLQ?b4g8ClQ=`007cLO?alg7clO=alo000O;alW00?000016AKK5]TF`001VAK00<005`LG1`0
1E`L00<005@LE1`015@L01@004_LBoa;g4_lBma;o000@o`kg4?l>ma3o3_L000cg3_l<m`003?L0P00
8?oo00<00?ooool00_oo0P005_oo0005ool01000ooooo`002Ooo00<00?ooool01Ooo00<00?ooool0
0_oo00<00?ooool04ooo00`00:gm[Ob]oJgl[Of]o:gm[O`00:gl[Od30000=jGmYO`00:GlYOfUo:Gm
YObUoJGlYOd00:FmYIbU_JFLYKfUW:Fm002U_JFLYKfUW:FmYIbU_@00YKfUW:FmYIbU_JFLYKd009em
WEbMOIeLWGfMG000WEbMOIeLWGfMG9emWE`009eLWGfMG9em00L0000>UCfE79DmUA`008dLSCf=78dm
SAb=?@00S?f<g0<0000QS=`008CLQ?f4g8CmQ=b4o@00O?elg7cmO=aloGcL001lW7bmO9al_GbLO;el
W000M9ad_GBLM;edW7Bm001/_FbL00H0000ZI7]TFfAkI5]TN`00G3eL75`mG1aL?E`L001D75@mE1aD
?E@LE3eD7000Bma;oD_LBoe;g000@ma3oD?L@oe3g4?m@m`003_L>odkg000>m`ko@008?oo00<00?oo
ool06Ooo0005ool01000ooooo`002_oo00@00?ooooooo`<000Goo`03003ooooo01Coo`08002]o:gL
[Ob]g:gl[Mb]o0<0000cYObUg:GlYMbUo:GL002Ug:GlYMbUo:GLYObUg:Gl002U_:FLYKbUW:FlYI`0
0:FLYKbUW:FlYIbU_:FLYK`00:FlYIbU_:FLYKbUW000WEbMO9eLWGbMG9elWE`009eLWGbMG9el00L0
000BUCbE79DlUA`009DLUCbE79DlUAbE?000SCb=78dlSAb=?8dL0`0002V<g8clS=b<o8cL0024g8Cl
Q=b4o8CLQ?`007clO=alo7cLO?alg000O9al_7bLO;alW7bl001d_7BLM;adW7BlM9`006BLK;aTW6bl
I9a/_6BL00D00003I5/005`L00IL7003001D75@L00AD700F001;o4_LBoa;g4_lBm`003_L@o`kg4?l
>ma3o000>o`cg3_l<m`003?L000Qool00`00ooooo`0Hool000Goo`04003ooooo000;ool01000oooo
o`001ooo0P005_oo00<00:gm[O`0100002nUoZGm002Uo:GmYObUoJGlYOfUo000YObUoJGlYOfUo:Gm
YObUo@00YKfUW:FmYIbU_JFL002UW:FmYIbU_JFLYKfUW000YIbU_JFLYKfUW:FmYI`009eLWGfMG9em
00L0000FUGfEG9EmUE`009DLUCfE79DmUAbE?@00UCfE79DmUAbE?IDLUCd008dmSA`30000<HdLSCd0
08cmS=b<oHcLS?f<g000Q=b4oHCLQ?f4g8Cm001loGcLO?elg7cmO=`007bLO;elW7bmO9al_@00M;ed
W7BmM9ad_GBL001/W6bmK9a/_FbLK;d006bmK9a/_FbL00H0000QG3eL75`m001D?E@LE3eD75@mE1aD
?@00Boe;g4_mBma;oD_L0013g4?m@ma3oD?L@od003_m>m`ko@00>odkg000023oo`03003ooooo01So
o`001Ooo00@00?ooool000Soo`04003ooooo0002ool00`00ooooo`04ool2000Hool20000;ZGMYOfU
gJGmYMfUoJGM002Ug:GlYMbUo:GLYObUg000YMbUo:GLYObUg:GlYM`00:FLYKbUW:FlYIbU_:FL002U
W:FlYIbU_:FLYKbUW000YIbU_:FLYKbUW:Fl1@0001ZMO9eLWGbMG000UEbEO9ELUGbEG9El002E?9DL
UCbE79DlUAbE?000UCbE79DlUAbE?9DL0`0003R=78dlSAb=?8dL002<g8clS=b<o8cLS?`008ClQ=b4
o8CLQ?b4g000O=alo7cLO?alg7cl001l_7bLO;alW7blO9al_000M;adW7BlM9ad_000K;aTW6blI9a/
_6BLK;`006blI9a/_6BLK;aTW0000VAL1`001E@L01H004_lBma;o4_LBo`004?l>ma3o3_L@o`kg000
<m`ko3?L>o`003_l<m`001ooo`8001Woo`001_oo0P002_oo0P000ooo10000ooo00<00?ooool06?oo
02`00:GnYOfUoZGmYOjUoJGnYOd00:GlYOfUo:GmYObUoJGl002Uo:GmYObUoJGlYOfUo000YIbU_JFL
YKfUW:FmYI`00:FLYKfUW:FmYIbU_JFL002UW:Fm0`0001bMOIeL002MG9emWEbMOIeLWGfMG000UEbE
OIELUGfEG9Em002E?IDLUCfE79DmUAbE?@00UCfE70<00014UA`008dLSCf=78dmSAb=?HdL002<g8cm
S=b<oHcLS?d008CmQ=b4oHCLQ?f4g000O=aloGcLO?elg7cm001l_GbLO;elW7bmO9`007BLM;edW7Bm
M9ad_@00K;e/W6bmK9a/_FbL001/W6bmK9a/_FbLK;d006AmI5aTOFALI7eTG6Am001LO@@0000GE1`0
04_LBoe;g4_mBma;o@00@oe3g4?m@ma3oD?L000kg3_m>m`ko@00>od0000Qool00`00ooooo`0Fool0
01koo`8001[oo`0V002UoJGMYOfUgJGmYMfUoJGM002Ug:GlYMbUo:GLYO`00:GlYMbUo:GLYObUg:Gl
YM`00:FLYKbUW:FlYIbU_:FL002UW:FlYIbU_0D0000LWGbMG9elWEbMO9eL002MG9elWEbMO9eLWG`0
09ElUEbEO9ELUGbEG9El002E?9DLUCbE79DlUA`30000?iDLUCbE79DlUA`008dLSCb=78dlSAb=?000
S?b<g8clS=b<o8cL0024g8ClQ=b4o8CLQ?`007clO=alo7cLO?alg000O9al_7bLO;alW7blO9`007BL
M;adW7BlM9ad_000K;aTW6blI9a/_6BL001TW6blI9a/_6BLK;`00006I5`00`00G5aLG003G5`40000
54_lBma;o4_LBo`004?l>ma3o3_L@o`kg000<m`ko3?L000cg3_l000Pool00`00ooooo`0Fool001ko
o`03003ooooo01[oo`0P002UoZGmYOjUoJGnYOfUoZGm002Uo:GmYObUoJGlYOd00:GmYObUoJGlYOfU
o:GmYO`00:FLYKfUW:FmYIbU_@D0000OWKfMW9fmWI`009eLWGfMG9emWEbMO@00WGfMG9emWEbMOIeL
WGd009EmUEbEOIELUGfEG000UAbE?IDLUCd00P00056E7000UAbE?IDLUCfE79DmUA`008dLSCf=78dm
SAb=?@00S?f<g8cmS=b<oHcL0024g8CmQ=b4oHCLQ?d007cmO=aloGcLO?elg000O9al_GbLO;elW7bm
001d_GBLM;edW7BmM9`006bLK;e/W6bmK9a/_FbL001/W6bmK9a/_FbLK;d006AmI5aTOFALI7eTG000
G5aLOEaLG7eLG5amG5`01@00015;g000@ma3oD?L@oe3g4?m000koC_L>odkg000>m`ko@00023oo`03
003ooooo01Goo`007_oo00<00?ooool06ooo01`00:GmYMfUoJGMYOfUgJGm002Uo:GLYObUg:GlYMbU
o000YObUg:GlYMbUo:GLYObUg000YIbU_0<0000PWKbMW000WIbM_9fLWKbMW9flWI`009eLWGbMG9el
WEbMO000WGbMG9elWEbMO9eLWG`009ElUEbEO9ELUGbEG0@00015UCbE79DlUA`009DLUCbE79DlUAbE
?9DL002=78dlSAb=?8dLSC`008clS=b<o8cLS?b<g000Q=b4o8CLQ?b4g8Cl001lo7cLO?alg7clO=`0
07bLO;alW7blO9al_000M;adW7BlM9ad_7BL001TW6blI9a/_6BLK;`006blI9a/_6BLK;aTW00000MT
G003001LG5aL00ALG003001DGEAM009DG@@0000>@o`kg4?l>ma3o000>o`cg3_l<m`003?L>o`0023o
o`03003ooooo01Coo`007_oo0P007Ooo0P0001JUoJGnYOfUoZGmYOh00:GmYObUoJGlYOfUo:Gm002U
oJGlYOfUo:GmYObUo@<0000QWKfMW9fmWIbM_IfL002MW9fmWIbM_IfLWKd009emWEbMOIeLWGfMG9em
002MOIeLWGfMG9emWEbMO@00UGfEG9Em00@0001MUAbE?IDLUCfE79DmUA`009DLUCfE79DmUAbE?@00
SCf=78dmSAb=?HdL002<g8cmS=b<oHcLS?d008CmQ=b4oHCLQ?f4g000O=aloGcLO?elg7cm001l_GbL
O;elW7bmO9al_@00M;edW7BmM9ad_@00K;e/W6bmK9a/_FbLK;d006bmK9a/_FbLK;e/W000I5aTOFAL
I7eTG6Am001LOEaLG7eLG5amG5aLO@00E7iDGEAnE5eDOUAM00@0000;@oe3g4?m000koC_L>odkg000
>m`0000Oool2000Fool001goo`80023oo`0B002UgJGmYMfUoJGMYOd00:GlYMbUo:GLYObUg:Gl002U
o:GL1000026U_:FL002MW9flWIbM_9fLWK`009flWIbM_9fLWKbMW9fl002MO9eLWGbMG9elWEbMO000
WGbMG9elWEbMO9eLWG`00`0004bEO9ELUGbEG000UAbE?9DLUCbE79Dl002E?9DLUCbE79DlUAbE?000
SCb=78dlSAb=?8dL002<g8clS=b<o8cLS?`008ClQ=b4o8CLQ?b4g000O=alo7cLO?alg7cl001l_7bL
O;alW7blO9`007BLM;adW7BlM9ad_000K;aTW6blI9a/_6BL001TW6blI9a/_6BLK;`000MTG003001L
G5aL00ALG003001DGEAM00ADG@04001<GDaMC5d4000023?L>o`cg3_l000ko3?L000Pool00`00oooo
o`0Cool001goo`03003ooooo023oo`0>002UoJGnYOfUoZGmYOh00:GmYObUoJGlYOfUo0<0000RYIbU
_JFLYKfUW:FmYI`009fLWKfMW9fmWIbM_@00WKfMW9fmWIbM_IfLWKd009emWEbMOIeLWGfMG9em002M
OIeLWGd30000Jiem002EOIELUGfEG9Em002E?IDLUCfE79DmUAbE?@00UCfE79DmUAbE?IDLUCd008dm
SAb=?HdLSCf=7000S=b<oHcLS?f<g8cm0024oHCLQ?f4g8CmQ=`007cLO?elg7cmO=alo@00O;elW7bm
O9al_GbL001dW7BmM9ad_GBLM;d006bmK9a/_FbLK;e/W000K9a/_FbLK;e/W6bm001TOFALI7eTG6Am
I5`005aLG7eLG5amG5aLOEaL001DGEAnE5eDOUAME7h004anC5e<OTaMC7h0100000Hkg3_m000koC_L
000Pool00`00ooooo`0Bool001goo`<0027oo`0:002UgJGmYMfUoJGMYOd00:GlYM`300008ZGMYOd0
0:FlYIbU_:FLYKbUW:FlYI`009fLWKbMW9flWIbM_000WKbMW9flWIbM_9fLWK`009elWEbMO9eLWGbM
G9el0`0005BMO9eLWGbMG000UEbEO9ELUGbEG9El002E?9DLUCbE79DlUAbE?000UCbE79DlUAbE?9DL
002=78dlSAb=?8dLSC`008clS=b<o8cLS?b<g000Q=b4o8CLQ?b4g8Cl001lo7cLO?alg7clO=`007bL
O;alW7blO9al_7bL001dW7BlM9ad_7BL001TW6blI9a/_6BLK;aTW000I9a/_6BLK;aTW6bl0006I5`0
0`00G5aLG004G5`00`00E5eDG@05E5d00`00C5e<G@04C5d00`00C5d0000300000c_l003oo`0Oool0
0`00ooooo`0Bool001goo`03003ooooo02;oo`04002UoJGnYOd500008ZGmYOjUoJGnYOfUoP00YKfU
W:FmYIbU_JFLYKfUW000WIbM_IfLWKfMW9fm002M_IfLWKfMW9fmWIbM_@00WGfMG9em100001ZMG9em
WEbMOIeLWGfMG000UEbEOIELUGfEG9Em002E?IDLUCfE79DmUA`009DLUCfE79Dm8`0003Yl_GbLO;d0
07BmM9ad_GBLM;edW000K9a/_FbLK;e/W6bm001/_FbLK;e/W6bmK9`006ALI7eTG6AmI5aTOFAL001L
G5amG5aLOEaLG7d005AnE5eDOUAME7iDG@00C5e<OTaMC7i<GDan001<OTaMC7i<G@@0023oo`03003o
oooo017oo`002_oo0P001?oo00<00?ooool00_oo0`001Ooo00<00?ooool08ooo0`0002BUgJGmYMfU
o@00YOfUgJGmYMfUoJGMYOd00:FlYIbU_:FLYKbUW:FlYI`009fLWKbMW9flWIbM_000WKbMW9flWIbM
_9fLWK`300005ielWEbMO9eL002MG9elWEbMO9eLWGbMG000UEbEO9ELUGbEG000UAbE?9DLUC`01`00
02>=?8dLSCb=7000SAb=?8dLSCb=78dl0025?8DLQCb578DlQA`008CLQ?b4g8ClQ=b4o000O?alg7cl
O=alo7cL001lg7cl00P0000BM9ad_000K;aTW6blI9a/_6BLK;`006blI9a/_6BLK;aTW0001VAL00<0
05aLG5`01EaL00<005AME5d015AM00<004aMC5d014aM00<004aMC5d00TaM00@004aMC5d001koo`03
003oo`0000Koo`@000?oo`8000?oo`002Ooo00@00?ooool000_oo`03003ooooo00;oo`03003ooooo
02Coo`0T002UoJGnYOfUoZGmYOh00:GnYOfUoZGmYOjUoJGn002U_JFLYKfUW:FmYIbU_@00WKfMW9fm
WIbM_IfLWKd009fmWIbM_IfL0`0000bMG9emWEbMOIeLWGfMG000WEbMOIeLWGd=0000<XemSEb=OHeL
002=78dmSAb=?HdLSCd008dmSAb=?HdLSCf=7000QAb5?HDLQCf578Dm0024oHCLQ?f4g8CmQ=`007cL
O?elg7cmO=alo@00O?elg7cmO=aloGcLO?d007CnM=d70000<6bLK;e/W000K9a/_FbLK;e/W6bmK9`0
06ALI7eTG6AmI5aTO@00G7eLG5amG5aLOEaL001DGEAnE5eDOUAME7iDG@00C5e<OTaMC7i<GDan001<
OTaMC7i<G@00C5d0023oo`03003ooooo00Koo`05003oooooool00002ool10001ool1ool000Woo`04
003ooooo000;ool01000oooooooo0`009_oo02000:GMYOfUgJGmYMfUo@00YOfUgJGmYMfUoJGMYOd0
0:FlYIbU_:FLYKbUW:Fl002M_9fLWKbMW9flWI`009fL0`0000RMW9flWI`009eLWGbMG9el1`0004JE
O9ELUGbEG000UEbEO9ELUGbEG000SEb=O8eLSGb=G8el002=?8dLSCb=78dlSAb=?000SCb=78dlSAb=
?8dL002578DlQAb5?8DLQC`008ClQ=b4o8CLQ?b4g000O=alo7cLO?alg7cl001lo7cLO?alg7clO=`0
07CMM?edgGCmM=edo@00K?eTg@P00004K;aTW6bl0007I5`00`00G5aLG004G5`00`00E5eDG@05E5d0
0`00C5e<G@03C5d00`00C5e<G@03C5d00`00C5d0000Pool00`00ooooo`05ool01@00oooooooo0000
0_oo0@000Ooo0Ooo0009ool01000ooooo`002?oo0`001?oo00<00?ooool09ooo01`00:GmYOjUoJGn
YOfUoP00YOjUoJGnYOfUoZGmYOh00:FmYIbU_JFLYKfUW:Fm002M_IfLWKfMW0<00006WIbM_IfLWKfM
W9fm1@0005FEOIELUGfEG000UEbEOIELUGfEG9Em002EOIELUGfEG9Em002=OHeLSGf=G8emSEb=O@00
SCf=78dmSAb=?HdLSCd008dmSAb=?HdLSCf=7000QAb5?HDLQCf578Dm0024oHCLQ?f4g8CmQ=`007cL
O?elg7cmO=alo@00O?elg7cmO=aloGcL001dgGCnM=edoWCM001/gFcnK=e/oVcMK?i/g@00K9e/_P08
00008VALI7eTG000G5aLOEaLG7eLG5am001DOUAME7iDGEAnE5eDOP00C7i<GDanC5e<OTaM001<GDan
C5e<OP00C7i<G@007ooo00<00?ooool01Ooo00D00?ooooooo`0000;oo`40007oo`7oo`002Ooo00@0
0?ooool000Soo`03003ooooo00Coo`03003ooooo02Soo`0G002UgJGmYMfUoJGMYOd00:GmYMfUoJGM
YOfUgJGm002U_:FLYKbUW:FlYIbU_00400001YfLWKbMW000WIbM_0<0001RWKfMW@00UEbEO9ELUGbE
G9El002EO9ELUGbEG9ElUEbEO000UGbEG9ElUEbEO000SGb=G8elSEb=O8eLSG`008dlSAb=?8dLSCb=
7000SAb=?8dLSCb=78dl0025?8DLQCb578DlQA`008CLQ?b4g8ClQ=b4o000O?alg7clO=alo7cL001l
g7clO=alo7cLO?alg000M=edoGCMM?edg@00I=e/oFCMK?eTgFcm001/_FBMK;eTWFbmI9e/_@00I;eT
W@H000ELG003001DGEAM00EDG@03001<GDaM00A<G@03001<GDaM009<G@03001<G@00023oo`03003o
oooo00Coo`05003oooooool00002ool10001ool1ool000Woo`04003ooooo0008ool00`00ooooo`04
ool2000Zool05000YOfUoZGmYOjUoJGn002UoZGmYOjUoJGnYOfUoP00YKfUW:FmYI`400000ifmWIbM
_@050000JYfnWIfM_YfMWKjMW@00UEbEOIELUGfEG9Em002EOIELUGfEG9EmUEbEO@00UGfEG9EmUEbE
O@00SGf=G8emSEb=OHeLSGd008dmSAb=?HdLSCf=7000SAb=?HdLSCf=78dm0025?HDLQCf578DmQA`0
08CLQ?f4g8CmQ=b4o@00O?elg7cmO=aloGcL001lg7cmO=aloGcLO?d007CnM=edoWCMM?idg@00K=e/
oVcMK?i/gFcn001/_VbMK;i/WFbnK9d006BMI;iTWFBnI9eT_VBM1@0001ULG000E5eDOUAME7iDGEAn
E5eDOP00C7i<GDanC5e<OP00C7i<GDanC5e<OP00C7h0000Nool00`00ool00003ool30003ool01000
ooooo`000_oo000:ool20009ool40003ool00`00ooooo`0Zool03`00YMfUoJGMYOfUgJGm002UoJGM
YOfUgJGmYMfUo@0400000jFL000000040000M9fmWIfM_IfM002MWIfmWIfM_IfMWKd009ElUEbEO9EL
UGbEG9El002EO9ELUGbEG9ElUEbEO000UGbEG9ElUEbEO000SGb=G8elSEb=O8eL002=78dlSAb=?8dL
SCb=7000SAb=?8dLSCb=78dl0025?8DLQCb578DlQA`008CLQ?b4g8ClQ=b4o000O?alg7clO=alo7cL
001lg7clO=alo7cLO?`007CmM=edoGCMM?d006cmI=e/oFCMK?eTgFcm001/_FBMK;eTWFbmI9d006BM
I;eTWFBmI9eT_@00I;eTWFBmI9d70003E5d00`00C5e<G@04C5d00`00C5e<G@03C5d00`00C5d0000O
ool00`00ooooo`03ool00`00ooooo`02ool20003ool001coo`03003ooooo02_oo`0<002UoJGnYOfU
oZGmYOh00:GnYOfUoZGm1`00086MWIfnWIfM_P00WKjMWIfnWIfM_YfM002MWIfnWIfM_YfMWKh009Em
UEbEOIELUGfEG9Em002EOIELUGfEG9EmUE`009ELUGfEG9EmUE`008eLSGf=G8emSEb=OHeL002=78dm
SAb=?HdLSCf=7000SAb=?HdLSCf=78dm0025?HDLQCf578DmQA`008CLQ?f4g8CmQ=b4o@00O?elg7cm
O=aloGcL001lg7cmO=aloGcLO?d007CnM=edoWCMM?h006cnK=e/oVcMK?i/gFcn001/_VbMK;i/WFbn
K9d006BMI;iTWFBnI9eT_P00I;iTWFBnI9eT_VBM001LWEbnG9d01P0000e<OTaMC7i<GDan001<OTaM
C7i<G@00C5d0000Pool00`00ooooo`0<ool001_oo`<002goo`07002UgJGmYMfUoJGMYOd01P0008^M
WIfm002M_IfMWKfMWIfmWIfM_@00WKfMWIfmWIfM_IfM002MWIfmWIfM_IfMWKd009ElUEbEO9ELUGbE
G000UEbEO9ELUGbEG9ElUE`009ELUGbEG9ElUE`008eLSGb=G8elSEb=O8eL002=78dlSAb=?8dLSC`0
08dlSAb=?8dLSCb=7000QAb5?8DLQCb578Dl0024o8CLQ?b4g8ClQ=`007cLO?alg7clO=alo000O?al
g7clO=alo7cLO?`007CmM=edoGCMM?d006cmI=e/oFCMK?eTg@00I9e/_FBMK;eTWFbm001T_FBMI;eT
WFBmI9d006BMI;eTWFBmI9eT_@00G;eLWEbmG9eL_EbMG;eLW@0500000daM001<G@04C5d00`00C5d0
000Pool00`00ooooo`0;ool001_oo`03003ooooo02koo`04002UoJGnYOd50000TifMWKjMWIfnWIfM
_P00WKjMWIfnWIfM_YfMWKh009fnWIfM_YfMWKjMW@00WIfM_YfMWKjMWIfn002EOIELUGfEG9EmUE`0
09ELUGfEG9EmUEbEOIEL002EG9EmUEbEOIEL002=G8emSEb=OHeLSGf=G000SAb=?HdLSCf=78dm002=
?HdLSCf=78dmSA`008DLQCf578DmQAb5?@00Q?f4g8CmQ=b4oHCL001lg7cmO=aloGcLO?d007cmO=al
oGcLO?elg000M=edoWCMM?idgGCn001/oVcMK?i/gFcnK=d006bMK;i/WFbnK9e/_P00I;iTWFBnI9eT
_VBM001TWFBnI9eT_VBMI;h005bnG9eL_UbMG;iLWEbn001L_UbMG;iLW@0500001TaMC7i<G@00C5d0
01koo`8000goo`006ooo00<00?ooool0;ooo100009bMoIgMWOd009fmWIfM_IfMWKfMWIfm002M_IfM
WKfMWIfmWIfM_@00WKfMWIfmWIfM_@00WKfMWIfmWIfM_IfMWKd009ElUEbEO9ELUGbEG000UEbEO9EL
UGbEG9ElUE`009ELUGbEG9ElUE`008eLSGb=G8elSEb=O000SCb=78dlSAb=?8dLSC`008dlSAb=?8dL
SCb=7000QAb5?8DLQCb578Dl0024o8CLQ?b4g8ClQ=`007cLO?alg7clO=alo000O?alg7clO=alo7cL
001dgGCmM=edoGCM001TgFcmI=e/oFCMK?eTg@00I9e/_FBMK;eTWFbm001T_FBMI;eTWFBmI9d006BM
I;eTWFBmI9eT_@00G;eLWEbmG9eL_EbMG;d005bmG9eL_EbMG;eLW@00E9d400000daM003oo`0Oool0
0`00ooooo`0:ool001_oo`8002koo`@0002RWOfMoYgmWOjMoIgn002M_YfMWKjMWIfnWIfM_P00WKjM
WIfnWIfM_YfM002MWIfnWIfM_YfMWKh009fnWIfM_YfMWKjMWIfn002EOIELUGfEG9EmUE`009ELUGfE
G9EmUEbEO@00UGfEG9EmUEbEO@00SGf=G8emSEb=OHeLSGd008dmSAb=?HdLSCf=7000SAb=?HdLSCf=
78dm0025?HDLQCf578DmQA`008CLQ?f4g8CmQ=b4o@00O?elg7cmO=aloGcL001lg7cmO=aloGcLO?el
g000M=edoWCMM?idg@00K=e/oVcMK?i/gFcnK=d006bMK;i/WFbnK9d006BMI;iTWFBnI9eT_P00I;iT
WFBnI9eT_VBM001LWEbnG9eL_UbMG;iLWEbn001L_UbMG;iLWEbn001D_UBME;iDWEBn0`008?oo00<0
0?ooool02Ooo000Kool00`00ooooo`0Zool30004ool0?P00WMfMoIgMWOfMgIgm002M_IfMWKfMWIfm
WIfM_@00WKfMWIfmWIfM_IfM002MWIfmWIfM_IfMWKd009fmWIfM_IfMWKfMW@00UEbEO9ELUGbEG9El
002EO9ELUGbEG9ElUEbEO000UGbEG9ElUEbEO000SGb=G8elSE`Z0000?WclO=alo000M?edgGCmM=ed
oGCM001TgFcmI=e/oFCMK?d006bmI9e/_FBMK;eTW@00I9eT_FBMI;eTWFBm001T_FBMI;eTWFBmI9d0
05bMG;eLWEbmG9eL_EbM001LWEbmG9eL_EbMG;d005BmE9eD_EBME;d005Bm000Oool00`00ooooo`09
ool001_oo`03003ooooo02Ooo`<000Soo`0`002MoIgnWOfMoYgmWOh009fnWIfM_YfMWKjMWIfn002M
_YfMWKjMWIfnWId009fMWKjMWIfnWIfM_P00WKjMWIfnWIfM_YfM002EG9EmUEbEOIELUGd009EmUEbE
OIEL3@0002Z=GHenSEf=OP00SCj=7HdnSAf=?XdM00257HDnQAf5?XDMQCh008DnQAf5?XDMQCj57@00
OAem?WdMOCim7Gdn001m?WdMOCim7GdnOAd007cMO?h80000=7CMM?h006cnK=e/oVcMK?i/gFcn001/
_VbMK;i/WFbnK9d006BMI;iTWFBnI9eT_P00I;iTWFBnI9eT_VBM001LWEbnG9eL_UbMG;iLW@00G9eL
_UbMG;iLWEbn001D_UBME;iDWEBn0P007ooo0P002_oo000Jool3000Uool3000<ool01`00WMfMoIgM
WOfMgIgm0080000OWIfM_IfMWKfMWIfm002M_IfMWKfMWIfmWId009fMWKfMWIfmWIfM_@00WKfMWIfm
WIfM_IfM002EG9ElUE`01`0003n=GHemSEf=O@00SGf=GHemSEf=O@00SGf=GHemSEf=OHeM002=7Hdm
SAf=?HdMSCf=7@00QAf5?HDMQCf57@00QAf5?HDMQCf57HDm001m?GdMOCem7GdmOAd007dMOCem7Gdm
OAem?@00O?elgGcmO=eloGcMO?d007CmM=d03`0002QTWFbm001T_FBMI;eTWFBmI9d006BMI;eTWFBm
I9eT_@00G;eLWEbmG9eL_EbMG;eLW@00G9eL_EbMG;eLW@00E9eD_EBME;eDW@00E9d001_oo`<00003
ool00?oo00Woo`000_oo0P001?oo00<00?ooool00ooo00<00?ooool00_oo0`001?oo00<00?ooool0
8_oo0`004?oo0P0001RMoYgmWOjMoIgnWOd009fMWKjMWIfnWIfM_P00WKjMWIfnWIfM_YfM002MWIfn
WId=0000EIEMUGjEGIEn002=OXeMSGj=GHenSEf=OP00SGj=GHenSEf=OP00SGj=GHenSEf=OXeM002=
7HdnSAf=?XdMSCh008DnQAf5?XDMQCj57@00QAf5?XDMQCj57HDn001m?WdMOCim7GdnOAd007dMOCim
7GdnOAem?P00O?ilgGcnO=eloWcM001dgGCnM=edoWCMM?h007CnM=edoWCMM?idgGCn001/oVcM00D0
000TI9eT_VBMI;iTW@00I9eT_VBMI;iTWFBn001L_UbMG;iLWEbnG9eL_P00G;iLWEbnG9eL_UbM001D
WEBnE9eD_UBM001DW@005_oo10001?oo00<00?ooool02?oo00001Ooo003ooooo00002Ooo00<00?oo
ool01Ooo00D00?ooooooo`00027oo`<001Goo`0B002MoIgMWOfMgIgmWMd009fMWKfMWIfmWIfM_@00
WKfMWIfm1P0006JEWIFmUIfE_@00UKfEWIFmUIfE_IFM002EGIEmUEfEOIEMUGd008emSEf=OHeMSGf=
G@00SEf=OHeMSGf=G@00SEf=OHeMSGf=GHemSEd008dMSCf=7HdmSAf=?@00QCf57HDmQAf5?HDM0025
7HDmQAf5?HDMQCd007dmOAem?GdMOCem7@00OAem?GdMOCem7Gdm001loGcMO?elgGcmO=d007CMM?ed
gGCmM=d007CMM?edgGCmM=edoGCM001TgFcmI=e/oFCMK?d500008FBm001T_FBMI;eTWFBmI9eT_@00
G;eLWEbmG9eL_EbMG;d005bmG9eL_EbMG;eLW@00E9eD_EBME;eDW@00E9d0000Bool30008ool00`00
ooooo`08ool00005ool00?ooool0000:ool00`00ooooo`04ool01000oooooooo0P007_oo0P006Ooo
00/009gnWOfMoYgmWOjMo@00WIfM_YfM00H0001aUKjEWIFnUId009FMUKjEWIFnUIfE_P00UKjEWIFn
UIfE_YFM002EGIEnUEfEOYEM002=GHenSEf=OXeMSGj=G@00SEf=OXeMSGj=G@00SEf=OXeMSGj=GHen
SEd008dMSCj=7HdnSAf=?P00QCj57HDnQAf5?XDM00257HDnQAf5?XDM001m7GdnOAem?WdMOCh007dn
OAem?WdMOCim7Gdn001loWcMO?ilgGcnO=d007CMM?idgGCnM=d007CMM?idgGCnM=edoWCM001/gFcn
K=e/oVcM001/gFcnK=e/oP0600006fBMI;iTW@00G9eL_UbMG;iLWEbnG9eL_P00G;iLWEbnG9eL_P00
E;iDWEBnE9eD_P00E;h0000?ool3000<ool00`00ooooo`07ool00005ool00?ooool0000:ool01000
oooooooo0`001?oo00<00?ooool06_oo0`007?oo00@009gmWMfMo@H0001mUIfE_IFMUKd009FmUIfE
_IFMUKfEW@00UIfE_IFMUKfEW@00UIfE_IFMUKfEWIFmUId009EMUGfEGIEmUEd008eMSGf=GHemSEf=
OHeM002=GHemSEf=OHeM002=GHemSEf=OHeMSGd008dmSAf=?HdMSCf=7Hdm0025?HDMQCf57HDm0025
?HDMQCf57HDmQAd007dMOCem7GdmOAem?@00OCem7GdmOAem?GdM001lgGcmO=eloGcMO?d007CmM=ed
oGCMM?edg@00M=edoGCMM?edgGCmM=d006CMK?eTgFcmI=d006CMK?eTgFcmI=e/o@00I?eTg@090000
4ebMG;eLW@00G9eL_EbMG;eLWEbm001D_EBME;eDWEBm001D_@0000_oo`<000ooo`03003ooooo00Oo
o`0000Goo`00ooooo`0000_oo`04003ooooo0006ool00`00ooooo`0Gool3000Pool30000S9FnUIfE
_YFM002EWIFnUIfE_YFMUKh009FnUIfE_YFMUKjEW@00UIfE_YFMUKjEW@00UIfE_YFMUKjEWIFnUId0
09EMUGjEGIEnUEd008eMSGj=GHenSEf=OXeM002=GHenSEf=OXeM002=GHenSEf=OXeMSGh008dnSAf=
?XdMSCj=7Hdn0025?XDMQCj57HDn0025?XDMQCj57HDnQAd007dMOCim7GdnOAem?P00OCim7GdnOAem
?WdM001lgGcnO=eloWcMO?h007CnM=edoWCMM?idg@00M=edoWCMM?idgGCn001/oVcMK?i/gFcnK=d0
06cMK?i/gFcnK=d006CMI?iTgFCnI=eToVCM001TgFCnI=d600003UbnG9eL_UbMG;h005BnE9eD_UBM
E;h005Bn0006ool4000Bool00`00ooooo`07ool00005ool00?ooool00008ool01000ooooo`000_oo
00<00?ooool00ooo00<00?oo00005Ooo0`009?oo09<009FmUIfE_IFMUKfEW@00UIfE_IFMUKfEWIFm
002E_IFMUKfEWIFmUId009FMUKfEWIFmUId009FMUKfEWIFmUIfE_@00UGfEGIEmUEfEOIEM002=GHem
SEf=OHeMSGf=G@00SEf=OHeMSGf=G@00SEf=OHeMSGf=GHem002=?HdMSCf=7HdmSAf=?@00QCf57HDm
QAf5?@00QCf57HDmQAf5?@00OCem7GdmOAem?GdM001m7GdmOAem?GdMOCem7@00O=eloGcMO?elgGcm
001doGCMM?edgGCm001doGCMM?edgGCmM=edo@00K?eTgFcmI=e/oFCM001TgFcmI=e/oFCM001TgFCm
I=eToFCMI?d006CmI=eToFCMI?eTgFCmI=d01@0000]LW@00E9eD_EBME;eDWEBm001D_@0000;oo`<0
01Koo`03003ooooo00Ooo`000_oo0P002Ooo10000_oo10000_oo0P004ooo0`00:?oo09L009FnUIfE
_YFMUKjEW@00UIfE_YFMUKjEWIFn002E_YFMUKjEWIFn002E_YFMUKjEWIFnUId009FMUKjEWIFnUIfE
_P00UGjEGIEnUEfEOYEM002=GHenSEf=OXeMSGj=G@00SEf=OXeMSGj=G@00SEf=OXeMSGj=GHen002=
?XdMSCj=7HdnSAd008DMQCj57HDnQAf5?P00QCj57HDnQAf5?P00OCim7GdnOAem?WdM001m7GdnOAem
?WdMOCim7@00O=eloWcMO?ilg@00M=edoWCMM?idgGCn001doWCMM?idgGCnM=edoP00K?i/gFcnK=e/
oP00K?i/gFcnK=e/oVcM001TgFCnI=eToVCMI?h006CnI=eToVCMI?iTgFCn001ToVCMI?iTg@070000
0eBM001DW@03000Iool00`00ooooo`07ool001Woo`03003ooooo00ooo`<002coo`2M002E_IFMUKfE
WIFmUId009FMUKfEWIFmUId009FMUKfEWIFmUIfE_@00UKfEWIFmUIfE_IFM002EWIFmUIfE_IFMUKd0
09EmUEfEOIEMUGfEG@00SEf=OHeMSGf=GHem002=OHeMSGf=GHem002=OHeMSGf=GHemSEd008dMSCf=
7HdmSAf=?HdM00257HDmQAf5?HDM00257HDmQAf5?HDMQCd007dmOAem?GdMOCem7@00OAem?GdMOCem
7Gdm001loGcMO?elgGcmO=d007CMM?edgGCmM=edo@00M?edgGCmM=edoGCM001TgFcmI=e/oFCMK?d0
06cmI=e/oFCMK?eTg@00I=eToFCMI?eTgFCm001ToFCMI?eTgFCmI=eTo@00I?eTgFCmI=eToFCM001L
gEcmG=d01@006_oo00<00?ooool01ooo000Iool00`00ooooo`0<ool3000`ool0@P00UKjEWIFnUIfE
_P00UKjEWIFnUIfE_YFM002EWIFnUIfE_YFMUKh009FnUIfE_YFMUKjEW@00UIfE_YFMUKjEWIFn002E
OYEMUGjEGIEn002=OXeMSGj=GHenSEf=OP00SGj=GHenSEf=OP00SGj=GHenSEf=OXeM002=7HdnSAf=
?Pd0001CQCj57@00OAem?WdMOCim7Gdn001m?WdMOCim7GdnOAem?P00O?ilgGcnO=eloWcM001dgGCn
M=edoWCMM?h007CnM=edoWCMM?idg@00K=e/oVcMK?i/gFcn001/oVcMK?i/gFcn001ToVCMI?iTgFCn
I=eToP00I?iTgFCnI=eToVCMI?h006CnI=eToVCMI?h005cnG=eLoUcMG?iLg@00G=d0000Iool00`00
ooooo`07ool001Woo`8000[oo`<003Coo`0]002E_IFMUKfEWIFm002E_IFMUKfEWIFmUId009FMUKfE
WIFmUIfE_@00UKfEWIFmUIfE_@00UKfEWIFmUIfE_IFMUKd009EmUEfEOIEMUGd008emSEf=OHeM01@0
000=QGf5GHEmQEd008DMQCf57HDmQAd008DMQCd05P0003elgGcm001doGCMM?edgGCmM=d007CMM?ed
gGCmM=edoGCM001TgFcmI=e/oFCMK?d006cmI=e/oFCMK?d006CmI=eToFCMI?eTg@00I=eToFCMI?eT
gFCmI=d006CMI?eTgFCmI=eTo@00G?eLgEcmG=eLo@00G?d0000Iool00`00ooooo`07ool001Woo`03
003ooooo00Ooo`8003Soo`0O002E_YFMUKjEWIFn002E_YFMUKjEWIFnUId009FMUKjEWIFnUIfE_P00
UKjEWIFnUIfE_P00UKjEWIFnUId03@0003N=GHenSEf=OP00SGj=GHenSEf=OP00SGj=GHenSEf=OXeM
0025GHEnQEf5OXEMQGh008DnQAf5?XDMQCj57@00QAf5?XDMQCj57@00OAem?WdMOCim7Gdn001m?WdM
OCim7GdnOAem?P00OCim7@0>0000<7CnM=edoP00K?i/gFcnK=e/oVcM001/gFcnK=e/oVcMK?h006Cn
I=eToVCMI?iTg@00I=eToVCMI?iTgFCnI=d006CMI?iTgFCnI=eToP00G?iLgEcnG=eLoP00G?h001Wo
o`03003ooooo00Koo`006?oo00<00?ooool01Ooo0`00>ooo014009FmUIfE_IFMUKd009FmUIfE_IFM
UKfEW@00UIfE_IFM00d0001BSEf=OHeMSGd008emSEf=OHeMSGd008emSEf=OHeMSGf=GHem002=OHeM
SGf=GHem002=OHeMSGf=GHemSEd008EMQGf5GHEmQEf5O@00QCf57HDmQAf5?@00QCf57HDmQAf5?HDM
001m7GdmOAem?GdMOCd007dmOAem?GdMOCem7@00OAem?GdMOCem7Gdm001e?GDMMCee7GDmMAd007DM
MCd80000:FCMK?eTg@00I=e/oFCMK?eTgFcm001ToFCMI?eTgFCmI=d006CMI?eTgFCmI=eTo@00I?eT
gFCmI=eToFCMI?d005cmG=eLoEcMG?d005cm00006?oo00<00?ooool01_oo000Hool30002ool3000o
ool02P00UKjEWIFnUIfE_P00UKjEWIFn1P0006NEWIFnUIfE_P00SKj=WHfnSIf=_P00SGj=GHenSEf=
OXeMSGh008enSEf=OXeMSGh008enSEf=OXeMSGj=G@00SEf=OXeMSGj=GHen002=OXeMSGj=GHen0025
OXEMQGj5GHEnQEf5OP00QCj57HDnQAf5?P00QCj57HDnQAf5?XDM001m7GdnOAem?WdM001m7GdnOAem
?WdMOCim7@00OAem?WdMOCim7@00MAee?WDMMCie7GDn001e?WDMMCie7GDnMAee?P00M?idg@080000
7fcnK=d006CMI?iTgFCnI=eToVCM001TgFCnI=eToVCMI?h006CnI=eToVCMI?iTg@00G=eLoUcMG?iL
gEcn008001Soo`03003ooooo00Koo`006?oo00<00?oo00000P00@ooo2@0007FE_IFMUKfEW@00UIfE
_IFMUKfEWIFm002=_HfMSKf=WHfm002=OHeMSGf=GHemSEd008eMSGf=GHemSEf=O@00SGf=GHemSEf=
OHeM002=GHemSEf=OHeMSGd008emSEf=OHeMSGd008EmQEf5OHEMQGf5GHEm0025?HDMQCf57HDm0025
?HDMQCf57HDmQAd007dMOCem7GdmOAd007dMOCem7GdmOAem?GdM001m7GdmOAem?GdM001e7GDmMAee
?GDMMCd007DmMAee?GDMMCee7@00M=edoGCMM?edgGCmM=d006CMK?d01`0001]ToFCMI?d006CmI=eT
oFCMI?eTgFCm001ToFCMI?eTgFCmI=d005cMG?eLgEcmG=d005cM00005ooo00<00?ooool01_oo000H
ool20017ool0Q000UKjEWIFnUIfE_P00UKjEWIFnUIfE_YFM002EWIFnUIfE_YFMUKh008fnSIf=_XfM
SKh008enSEf=OXeMSGj=G@00SEf=OXeMSGj=GHen002=OXeMSGj=GHenSEd008eMSGj=GHenSEd008eM
SGj=GHenSEf=OP00QGj5GHEnQEf5OXEM00257HDnQAf5?XDMQCh008DnQAf5?XDMQCh007dnOAem?WdM
OCim7@00OAem?WdMOCim7GdnOAd007dMOCim7GdnOAd007DMMCie7GDnMAee?P00MCie7GDnMAee?WDM
001dgGCnM=edoWCMM?h006cnK=e/oVcMK?i/g@00K=e/oPP0000AI=eToVCM001TgFCnI=eToVCMI?iT
g@00G=eLoUcMG?iLg@02000Gool00`00ooooo`06ool001Woo`03003ooooo04Koo`2;002E_IFMUKfE
WIFm002E_IFMUKfEWIFmUId009FMUKfEWIFmUIfE_@00SKf=WHfmSIf=_@00SGf=GHemSEf=OHeM002=
GHemSEf=OHeM002=GHemSEf=OHeMSGf=G@00SEf=OHeMSGf=G@00SEf=OHeMSGf=GHem0025OHEMQGf5
GHEmQEd008DMQCf57HDmQAf5?@00QCf57HDmQAf5?@00OCem7GdmOAem?GdM001m7GdmOAem?GdMOCd0
07dmOAem?GdMOCem7@00MAee?GDMMCee7GDm001e?GDMMCee7GDmMAd007CMM?edgGCmM=edo@00K?eT
gFcmI=e/o@00K?eTgFcmI=e/oFCMK?d006cmI=d01`0000]TgFCmI=eToFCM001LgEcmG=eLoEcM0080
01Koo`03003ooooo00Koo`006_oo0P00Aooo094009FnUIfE_YFMUKh009FnUIfE_YFMUKjEW@00UIfE
_YFMUKjEW@00SIf=_XfMSKj=WHfn002=OXeMSGj=GHenSEd008eMSGj=GHenSEd008eMSGj=GHenSEf=
OXeM002=GHenSEf=OXeM002=GHenSEf=OXeMSGh008EnQEf5OXEMQGj5G@00QAf5?XDMQCj57HDn0025
?XDMQCj57HDn001m?WdMOCim7GdnOAd007dMOCim7GdnOAem?P00OCim7GdnOAem?P00MCie7GDnMAee
?WDM001e7GDnMAee?WDMMCie7@00M=edoWCMM?idgGCn001/oVcMK?i/gFcn001/oVcMK?i/gFcnK=d0
06cMK?i/gFcnK=e/oVcM001TgP0400002VCn001LoUcMG?iLgEcn001LoP005Ooo00<00?ooool01_oo
000Lool00`00ooooo`15ool01P00UKfEWIFmUIfE_@80002<UIfE_IFMUKfEW@00UIfE_IFMUKfEW@00
SIf=_HfMSKf=WHfm002=OHeMSGf=GHemSEd008eMSGf=GHemSEd008eMSGf=GHemSEf=O@00SGf=GHem
SEf=OHeM002=GHemSEf=OHeM0025GHEmQEf5OHEMQGf5G@00QAf5?HDMQCf57@00QAf5?HDMQCf57HDm
001m?GdMOCem7GdmOAd007dMOCem7GdmOAem?@00OCem7GdmOAem?@00MCee7GDmMAee?GDM001e7GDm
MAee?GDMMCd007CmM=edoGCMM?edg@00I=e/oFCMK?eTgFcm001/oFCMK?eTgFcmI=d006CMK?eTgFcm
I=e/o@00I?iTgVCnI=iToPH00004G=eLo@00000Fool00`00ooooo`05ool001goo`03003ooooo04Go
o`2I002E_YFMUKjEWIFnUId009FMUKjEWIFnUId009FMUKjEWIFnUId008fMSKj=WHfnSIf=_P00SGj=
GHenSEf=OP00SGj=GHenSEf=OXeM002=GHenSEf=OXeMSGh008enSEf=OXeMSGj=G@00SEf=OXeMSGj=
G@00QEf5OXEMQGj5GHEn0025?XDMQCj57HDnQAd008DMQCj57HDnQAf5?P00OCim7GdnOAem?P00OCim
7GdnOAem?WdMOCh007dnOAem?WdMOCh007DnMAee?WDMMCie7@00MAee?WDMMCie7GDn001doWCMM?id
gGCnM=d006cMK?i/gFcnK=e/oP00K?i/gFcnK=e/oVcM001/gFcnK=e/oVcMK?h006CoI=iTofCNI?mT
gVCo001TofCN00D001Goo`03003ooooo00Goo`007_oo00<00?ooool0AOoo02/009FmUIfE_IFMUKfE
W@00UIfE_IFMUKfEW@00UIfE_IFMUKfEW@00SIf=_HfMSKf=WHfm002=OHeMSGf=GHem002=OHeMSGf=
GHemSEd008eMSGf=G@0Y0000B7dMOCd007dmOAem?GdMOCem7@00OAem?GdMOCem7Gdm001e?GDMMCee
7GDmMAd007DMMCee7GDmMAee?@00M?edgGCmM=edo@00K?eTgFcmI=e/oFCM001TgFcmI=e/oFCMK?eT
g@00I=e/oFCMK?eTgFcm001ToVCNI?iTgVCnI=h006CNI?iTgVCnI=iToP8001Coo`03003ooooo00Go
o`007ooo0P00A_oo01L009FnUIfE_YFMUKjEW@00UIfE_YFMUKjEW@00UIfE_YFMUKjEW@00SIf=_XfM
01<0000YSEf=OXeMSGh008EnQEf5OXEMQGj5G@00QEf5OXEMQGj5G@00QEf5OXEMQGj5GHEn0025OXEM
QGj5GHEnQEd007dMOCim7GdnOAem?P00OCim7@0>0000>WdnOAd007DMMCie7GDnMAee?P00MCie7GDn
MAee?WDMMCh007CnM=edoWCMM?h006cnK=e/oVcMK?i/g@00K=e/oVcMK?i/gFcn001/oVcMK?i/gFcn
K=e/oP00I?mTgVCoI=iTofCN001TgVCoI=iTofCN0P005?oo00<00?ooool01Ooo000Qool00`00oooo
o`14ool01000UKfEWIFm4P0004Z=WHfmSIf=_@00SGf=GHemSEf=O@00SGf=GHemSEf=OHeM002=GHem
SEf=OHeMSGd008EmQEf5OHEMQGf5G@00QEf5OHEMQGf5G@00QEf5OHEMQGf5GHEm0025OHEMQGf5GHEm
QEd007dMOCem7GdmOAd007dMOCem7GdmOAem?@00OCem7GdmOAem?GdM001m7Gdm3P0002ee7GDmMAd0
07CMM?edgGCmM=edo@00K?eTgFcmI=e/oFCM001TgFcmI=e/oFCMK?d006cmI=e/oFCMK?eTg@00I=iT
oVCNI?iTgVCnI=h006CNI?iTgVCnI=h00P004ooo00<00?ooool01Ooo000Rool00`00ooooo`14ool3
0000JXfoSIj=_hfN002=WXfoSIj=_hfN002=WHfnSIf=_XfM002=WHfnSIf=_XfMSKh008enSEf=OXeM
SGh008enSEf=OXeMSGj=G@00SEf=OXeMSGj=G@00QEf5OXEMQGj5GHEn0025OXEMQGj5GHEn0025OXEM
QGj5GHEnQEd008EMQGj5GHEnQEf5OP00OCim7GdnOAem?WdM001m7GdnOAem?WdM001m7GdnOAem?WdM
OCh007dnOAem?WdMOCim7@00MAee?WDMMCie7GDn001e?WDM200002IdoWCM001/gFcnK=e/oVcMK?i/
g@00K=e/oVcMK?i/gFcn001/oVcMK?i/gFcnK=d006CNI?mTgVCoI=iTo`00I?mTgVCoI=iTofCN0P00
4_oo00<00?ooool01Ooo000Sool00`00ooooo`14ool0M000SKj=WXfnSIj=_XfN002=WXfnSIj=_XfN
002=WHfmSIf=_HfM002=WHfmSIf=_HfMSKd008emSEf=OHeMSGd008emSEf=OHeMSGf=G@00SEf=OHeM
SGf=G@00QEf5OHEMQGf5GHEm0025OHEMQGf5GHEm0025OHEMQGf5GHEmQEd008EMQGf5GHEmQEf5O@00
OCem7GdmOAem?GdM001m7GdmOAem?GdM001m7GdmOAem?GdMOCd007dmOAem?GdMOCem7@00MAee?GDM
MCee7GDm001e?GDMMCee7GDmMAd007DMMCd700008FcmI=e/o@00K?eTgFcmI=e/oFCMK?d006cmI=e/
oFCMK?eTg@00I=iToVCNI?iTgVCn001ToVCNI?iTgVCnI=h0000Bool00`00ooooo`05ool002Coo`03
003ooooo04Coo`1j002=_hfNSKn=WXfoSIh008fNSKn=WXfoSIh008fMSKj=WHfnSId008fMSKj=WHfn
SIf=_P00SGj=GHenSEf=OP00SGj=GHenSEf=OXeM002=GHenSEf=OXeM0025GHEnQEf5OXEMQGh008En
QEf5OXEMQGh008EnQEf5OXEMQGj5G@00QEf5OXEMQGj5GHEn001m?WdMOCim7GdnOAd007dMOCim7Gdn
OAd007dMOCim7GdnOAem?P00OCim7GdnOAem?P00MCie7GDnMAee?WDM001e7GDnMAee?WDMMCh007Dn
MAee?WDMMCie7@00MAee?PP0000HK=e/oVcM001/gFcnK=e/oVcMK?i/g@00I=iTofCNI?mTgVCo001T
ofCNI?mTgVCo0P004_oo00<00?ooool01?oo000Uool20015ool0P@00SKj=WXfnSIj=_XfN002=WXfn
SIj=_XfN002=WHfmSIf=_HfM002=WHfmSIf=_HfMSKd008emSEf=OHeMSGd008emSEf=OHeMSGd008em
SEf=OHeMSGf=G@00QEf5OHEMQGf5GHEm0025OHEMQGf5GHEm0025OHEMQGf5GHEmQEd008EMQGf5GHEm
QEf5O@00OCem7GdmOAem?@00OCem7GdmOAem?@00OCem7GdmOAem?GdM001m7GdmOAem?GdMOCd007Dm
MAee?GDMMCee7@00MAee?GDMMCee7GDm001e?GDMMCee7GDmMAd007DMMCee7GDmMAee?@00KCiU7P08
00004FcmI=e/o@00I?iTgVCnI=iToVCNI?h006CnI=iToVCNI?h00P004Ooo00<00?ooool01?oo000W
ool00`00ooooo`13ool20000QXfNSKn=WXfo002=_hfNSKn=WXfo002=_XfMSKj=WHfnSId008fMSKj=
WHfnSIf=_P00SGj=GHenSEf=OP00SGj=GHenSEf=OP00SGj=GHenSEf=OXeM0025GHEnQEf5OXEMQGh0
08EnQEf5OXEMQGh008EnQEf5OXEMQGj5G@00QEf5OXEMQGj5GHEn001m?WdMOCim7Gdn001m?WdMOCim
7Gdn001m?WdMOCim7GdnOAd007dMOCim7GdnOAem?P00MCie7GDnMAee?WDM001e7GDnMAee?WDMMCh0
07DnMAee?WDMMCh007DnMAee?WDMMCie7@00KAi]?fdNKCm]7VdoKAh006dNKCl800002VCNI?mTgP00
I=iTofCNI?mTgVCo0P004?oo00<00?ooool01?oo000Xool00`00ooooo`14ool0SP00SIj=_XfNSKh0
08fnSIj=_XfNSKh008fmSIf=_HfMSKf=W@00SIf=_HfMSKf=WHfm002=OHeMSGf=GHem002=OHeMSGf=
GHem002=OHeMSGf=GHem0025OHEMQGf5GHEmQEd008EMQGf5GHEmQEd008EMQGf5GHEmQEf5O@00QGf5
GHEmQEf5OHEM001m7GdmOAem?GdMOCd007dmOAem?GdMOCd007dmOAem?GdMOCem7@00OAem?GdMOCem
7Gdm001e?GDMMCee7GDmMAd007DMMCee7GDmMAd007DMMCee7GDmMAee?@00MCee7GDmMAee?GDM001U
7VdnIAi]?VDNKCh006dnIAi]?VDNKCiU7Vdn001]?VDN200000AToVCN0000013oo`03003ooooo00Co
o`00:Ooo00<00?ooool0A?oo09D008fNSKn=WXfo002=_hfNSKn=WXfo002=_XfMSKj=WHfnSId008fM
SKj=WHfnSIf=_P00SGj=GHenSEf=OP00SGj=GHenSEf=OP00SGj=GHenSEf=OP00QGj5GHEnQEf5OXEM
0025GHEnQEf5OXEM0025GHEnQEf5OXEMQGh008EnQEf5OXEMQGj5G@00OAem?WdMOCim7Gdn001m?WdM
OCim7Gdn001m?WdMOCim7GdnOAd007dMOCim7GdnOAem?P00MCie7GDnMAee?WDM001e7GDnMAee?WDM
001e7GDnMAee?WDMMCh007DnMAee?WDMMCie7@00KAi]?fdNKCm]7Vdo001]?fdNKCm]7VdoKAh006dN
KCm]7VdoKAi]?fdN001]7Vdo00D000ooo`03003ooooo00Coo`00:_oo0P00AOoo00l008fNSKj=WXfn
002=_XfNSKj=WXfn002=_HfMSKd0>`0004im?GdM001m7GdmOAem?GdM001m7GdmOAem?GdMOCd007dm
OAem?GdMOCem7@00MAee?GDMMCee7GDm001e?GDMMCee7GDmMAd007DMMCee7GDmMAee?@00MCee7GDm
MAee?@00KCiU7VdnIAi]?VDNKCh006dnIAi]?VDNKCiU7P00IAi]?VDNKCiU7VdnIAh006DNKCiU7Vdn
IAh2000>ool00`00ooooo`04ool002coo`03003ooooo04?oo`h0000kSKn=WXfoSIh008fNSKn=WXfo
SIj=_`00QGj5GHEnQEf5OP00QGj5GHEnQEf5OP00QGj5GHEnQEf5OP00QGj5GHEnQEf5OXEM0025GHEn
QEf5OXEM0025GHEnQEf5OXEMQGh007enOEemOWeMOGimG@00OEemOP0D0000?7dMOCim7@00MAee?WDM
MCie7GDn001e?WDMMCie7GDnMAd007DMMCie7GDnMAee?P00MCie7GDnMAee?P00KCm]7VdoKAi]?fdN
001]7VdoKAi]?fdNKCm]7P00KAi]?fdNKCm]7Vdo001]?fdNKCm]7VdoKAh000koo`03003ooooo00Co
o`00;Ooo00<00?ooool0@ooo05`008fNSKj=WXfn002=_XfNSKj=WXfn002=_XfNSKj=WXfnSIh008fN
SKj=WXfnSIj=_P00QGf5GHEmQEf5O@00QGf5GHEmQEf5O@00QGf5GHEmQEf5O@00QGf5GHEmQEf5OHEM
0025GHEmQEf5OHEM0025GHEmQEf5OHEMQGd007emOEemOGeMOGd007emOEemOGeMOGemG@00OAem?GdM
OCem7@00OAem?GdMOCem7Gdm001m?GdM3`0002ae7GDm001e?GDMMCee7GDmMAd007DMMCee7GDmMAee
?@00KCiU7VdnIAi]?VDN001U7VdnIAi]?VDNKCh006dnIAi]?VDNKCiU7Vdn001]?VDNKCiU7Vdn0P00
3Ooo00<00?ooool01?oo000^ool00`00ooooo`13ool0JP00SIj=_hfNSKl008foSIj=_hfNSKl008fo
SIj=_hfNSKn=WP00SIj=_hfNSKn=WXfo0025OXEMQGj5GHEn0025OXEMQGj5GHEn0025OXEMQGj5GHEn
0025OXEMQGj5GHEnQEd008EMQGj5GHEnQEd008EMQGj5GHEnQEf5OP00OGimGGenOEemOP00OGimGGen
OEemOWeM001m7GdnOAem?WdM001m7GdnOAem?WdMOCh007dnOAem?WdMOCim7@00MAee?WDMMCie7GDn
001e?gDN1`0002Ie7GDnMAd007DMMCie7GDnMAee?P00KCm]7VdoKAi]?fdN001]7VdoKAi]?fdNKCl0
06doKAi]?fdNKCm]7Vdo001]?fdNKCm]7Vdo0P003Ooo00<00?ooool00ooo000_ool20014ool0L000
SIj=_XfNSKh008fnSIj=_XfNSKh008fnSIj=_XfNSKj=WP00SIj=_XfNSKj=WXfn0025OHEMQGf5GHEm
0025OHEMQGf5GHEm0025OHEMQGf5GHEm0025OHEMQGf5GHEmQEd008EMQGf5GHEmQEd008EMQGf5GHEm
QEf5O@00OGemGGemOEemO@00OGemGGemOEemO@00OCem7GdmOAem?GdM001m7GdmOAem?GdM001m7Gdm
OAem?GdMOCem7@00MAee?GDMMCee7@00MAie?WDNMCie7WDn001e?WDN2000021e?GDM001U7VdnIAi]
?VDNKCiU7P00IAi]?VDNKCiU7Vdn001]?VDNKCiU7VdnIAi]?P00KCiU7VdnIAi]?P003Ooo00<00?oo
ool00ooo000aool00`00ooooo`12ool01@00SIj=_hfNSKl00P0000B=WXfoSIj=_`80001ZSIj=_hfN
SKn=WP00SIj=_hfNSKn=WP00QEf5OXEMQGj5G@00QEf5OXEMQGj5G@00QEf5OXEMQGj5G@00QEf5OXEM
QGj5GHEn0025OXEMQGj5GHEn0025OXEMQGj5GHEnQEd007eMOGimGGenOEd007eMOGimGGenOEemOP00
OCim7GdnOAem?WdM001m7GdnOAem?WdM001m7GdnOAem?WdMOCh007DnMAee?WDMMCie7@00MAie?gDN
MCme7P00MAie?gDNMCme7WDoMAh007DNMCl7000066doKAi]?`00KCm]7VdoKAi]?fdNKCl006doKAi]
?fdNKCm]7P00KAi]?fdNKCm]7P8000coo`03003ooooo00?oo`00<_oo00<00?ooool0@_oo07d008fN
SKj=WXfnSIh008fNSKj=WXfnSIh008fNSKj=WXfnSIh008fNSKj=WXfnSIh008EMQGf5GHEmQEd008EM
QGf5GHEmQEd008EMQGf5GHEmQEd008EMQGf5GHEmQEf5O@00QGf5GHEmQEf5O@00QGf5GHEmQEf5OHEM
001mGGemOEemOGeM001mGGemOEemOGeMOGd007dmOAem?GdMOCd007dmOAem?GdMOCem7@00OAem?GdM
OCem7Gdm001e?GDMMCee7GDmMAd007DNMCie7WDnMAh007DNMCie7WDnMAie?WDN001e7WDnMAie?WDN
001e7WDn00P0000AIAi]?VDN001U7VdnIAi]?VDNKCiU7P00IAi]?VDNKCiU7P02000;ool00`00oooo
o`03ool003?oo`03003ooooo04;oo`24002=WXfoSIj=_hfN002=WXfoSIj=_hfN002=WXfoSIj=_hfN
002=WXfoSIj=_hfN0025GHEnQEf5OXEM0025GHEnQEf5OXEM0025GHEnQEf5OXEM0025GHEnQEf5OXEM
QGh008EnQEf5OXEMQGh008EnQEf5OXEMQGj5G@00OEemOWeMOGimG@00OEemOWeMOGimGGen001m?WdM
OCim7Gdn001m?WdMOCim7GdnOAd007dMOCim7GdnOAem?P00MCie7GDnMAee?P00MCme7WDoMAie?gDN
001e7WDoMAie?gDNMCl007DoMAie?gDNMCme7P00MAie?gDNMCme7WDo001]?fdN3P0000A]?fdNKCm]
7P8000[oo`03003ooooo00?oo`00=?oo0P00@ooo090008fNSKj=WXfnSIh008fNSKj=WXfnSIh008fN
SKj=WXfnSIh008fNSKj=WXfnSIh008EMQGf5GHEmQEd008EMQGf5GHEmQEd008EMQGf5GHEmQEd008EM
QGf5GHEmQEf5O@00QGf5GHEmQEf5O@00QGf5GHEmQEf5OHEM001mGGemOEemOGeM001mGGemOEemOGeM
001m7GdmOAem?GdMOCd007dmOAem?GdMOCem7@00OAem?GdMOCem7Gdm001e?GDMMCee7GDm001e?WDN
MCie7WDn001e?WDNMCie7WDnMAie?P00MCie7WDnMAie?P00MCie7WDnMAie?WDNMCh006dnIAi]?VDN
KCiU7P00IAi]?VDNKCiU7VdnIAh500000fDN003oo`09ool00`00ooooo`03ool003Koo`03003ooooo
047ood40001COEemOP00OGimGGenOEemOWeM001m7GdnOAem?WdMOCh007dnOAem?WdMOCh007dnOAem
?WdMOCim7@00MAee?WDMMCie7GDn001e?gDNMCme7WDo001e?gDNMCme7WDoMAie?`00MCme7WDoMAie
?`00MCme7WDoMAie?gDN001]7VdoKAi]?fdNKCm]7P00KAi]?fdNKCm]7Vdo001]?fdNKCm]7P030009
ool00`00ooooo`03ool003Ooo`03003ooooo047oo`100025WXFnQIj5_XFN0025WXFnQIj5_XFN0025
WXFnQIj5_XFN0025GXEnQEj5OXEN0025GXEnQEj5OXEN0025GXEnQEj5OXEN0025GXEnQEj5OXEN0025
GXEnQEj5OXENQGh008EnQEj5OXENQGh007enOEimOWeNOGimGP00OEhE0000@7dMOCd007dmOAem?GdM
OCem7@00MAee?GDMMCee7GDm001e?WDNMCie7WDn001e?WDNMCie7WDnMAie?P00MCie7WDnMAie?P00
MCie7WDnMAie?WDN001U7VdnIAi]?VDNKCh006dnIAi]?VDNKCiU7Vdn001]?VDNKCiU7Vdn0P002Ooo
00<00?ooool00_oo000hool00`00ooooo`11ool0E000QIj5_hFNQKn5WP00QIj5_hFNQKn5WP00QIj5
_hFNQKn5WP00QEj5OhENQGn5GP00QEj5OhENQGn5GP00QEj5OhENQGn5GP00QEj5OhENQGn5GP00QEj5
OhENQGn5GXEo0025OhENQGn5GXEo001mOgeNOGmmGWeoOEh007eNOGmmGWeo001mOgeNOGmmGWeoOEh0
07eNOGmmGWeoOEimO`00OGmmGPh0000cMCie7@00MAie?gDNMCme7WDo001e?gDNMCme7WDoMAh007DN
MCme7WDoMAie?`00MCme7WDoMAie?gDN001]7VdoKAi]?fdNKCl006doKAi]?fdNKCm]7Vdo001]?fdN
KCm]7Vdo008000Soo`03003ooooo00;oo`00>Ooo0P00@_oo064008FNQKj5WXFnQIh008FNQKj5WXFn
QIh008FNQKj5WXFnQIh008ENQGj5GXEnQEh008ENQGj5GXEnQEh008ENQGj5GXEnQEh008ENQGj5GXEn
QEh008ENQGj5GXEnQEh008ENQGj5GXEnQEj5OP00OGimGWenOEimOP00OGimGWenOEimOP00OGimGWen
OEimOWeN001mGWenOEimOWeNOGh007enOEimOWeNOGh007dnOAim?WdNOCim7P00MAie?P070000;7Dn
MAh007DNMCie7WDnMAie?WDN001e7WDnMAie?WDN001e7WDnMAie?WDNMCie7P00IAi]?VDNKCiU7Vdn
001]?VDNKCiU7VdnIAh006DNKCiU7VdnIAh20008ool00`00ooooo`02ool003_oo`03003ooooo043o
o`1W0025WXFoQIj5_hFN0025WXFoQIj5_hFN0025WXFoQIj5_hFN0025GXEoQEj5OhEN0025GXEoQEj5
OhEN0025GXEoQEj5OhEN0025GXEoQEj5OhEN0025GXEoQEj5OhEN0025GXEoQEj5OhENQGl007eoOEim
OgeNOGl007eoOEimOgeNOGl007eoOEimOgeNOGmmGP00OEimOgeNOGmmGP00OEimOgeNOGmmGWeo001m
?gdNOCmm7WdoOAh007DNMCme7WDoMAh007DNMCl03`0001ie?gDN001e7WDoMAie?gDNMCl006doKAi]
?fdNKCm]7Vdo001]?fdNKCm]7VdoKAh006dNKCm]7VdoKAh20007ool00`00ooooo`02ool003coo`03
003ooooo043oo`1e0025WXFnQIj5_XFN0025WXFnQIj5_XFN0025WXFnQIj5_XFN0025GXEnQEj5OXEN
0025GXEnQEj5OXEN0025GXEnQEj5OXEN0025GXEnQEj5OXEN0025GXEnQEj5OXEN0025GXEnQEj5OXEN
001mGWenOEimOWeNOGh007enOEimOWeNOGh007enOEimOWeNOGimGP00OEimOWeNOGimGP00OEimOWeN
OGimGP00OAim?WdNOCim7Wdn001e?WDNMCie7WDnMAh007DNMCie7WDnMAh007DNMCie7WDnMAie?WDN
001e7WDn00L0000HMCie7WDn001]?VDNKCiU7VdnIAh006DNKCiU7VdnIAi]?VDN001U7VdnIAi]?VDN
0P001_oo00<00?ooool00_oo000mool00`00ooooo`10ool0N`00QIj5_hFNQKn5WP00QIj5_hFNQKn5
WP00QIj5_hFNQKn5WP00QEj5OhENQGn5GP00QEj5OhENQGn5GP00QEj5OhENQGn5GP00QEj5OhENQGn5
GP00QEj5OhENQGn5GP00QEj5OhENQGn5GP00OEimOgeNOGmmGWeo001mOgeNOGmmGWeo001mOgeNOGmm
GWeo001mOgeNOGmmGWeoOEh007eNOGmmGWeoOEh007dNOCmm7WdoOAim?`00MCme7WDoMAie?`00MCme
7WDoMAie?gDN001e7WDoMAie?gDNMCme7P00MAie?gDNMCme7P00MAie?`0800004FdNKCm]7P00KAi]
?fdNKCm]7VdoKAh006dNKCm]7VdoKAh00P001Ooo00<00?ooool00_oo000nool00`00ooooo`10ool0
PP00QIj5_XFNQKj5WP00QIj5_XFNQKj5WP00QIj5_XFNQKj5WP00QEj5OXENQGj5GP00QEj5OXENQGj5
GP00QEj5OXENQGj5GP00QEj5OXENQGj5GP00QEj5OXENQGh008EnQEj5OXENQGj5GP00OEimOWeNOGim
GP00OEimOWeNOGimGWen001mOWeNOGimGWen001mOWeNOGimGWenOEh007eNOGimGWenOEh007dNOCim
7WdnOAim?P00MCie7WDnMAie?P00MCie7WDnMAie?P00MCie7WDnMAie?WDNMCh007DnMAie?WDNMCie
7P00MAie?WDNMCie7WDn001e?WDN200000U]?VDNKCh006dnIAi]?VDNKCh00P001Ooo00<00?ooool0
0_oo000oool20011ool]0000G8ENQGl008EoQEj5OhENQGn5GP00OEimOgeNOGmmGP00OEimOgeNOGmm
GWeo001mOgeNOGmmGWeo001mOgeNOGmmGWeo001mOgeNOGmmGWeoOEh007dNOCmm7WdoOAim?`00MCme
7WDoMAie?`00MCme7WDoMAie?`00MCme7WDoMAie?gDNMCl007DoMAie?gDNMCl007DoMAie?gDNMCme
7WDo001e?gDNMCme7WDoMAh006dNKCl8000016dNKCl000001Ooo00<00?ooool00Ooo0011ool00`00
ooooo`0nool00`00ooooo`0ZoolK0000BGeNOGh007enOEimOWeNOGh007enOEimOWeNOGh007dnOAim
?WdNOCim7P00MAie?WDNMCie7WDn001e?WDNMCie7WDn001e?WDNMCie7WDnMAie?P00MCie7WDnMAie
?P00MCie7WDnMAie?WDN001e7WDnMAie?WDNMCh006dnIAi]?VDNKCiU7Vdn001]?VDN00D000Coo`03
003ooooo007oo`00@_oo00<00?ooool0?Ooo00<00?ooool0AOoo3@00041mGWeo001m?gdNOCmm7Wdo
OAh007DNMCme7WDoMAh007DNMCme7WDoMAie?`00MCme7WDoMAie?gDNMCl007DoMAie?gDNMCl007Do
MAie?gDNMCme7P00MAie?gDNMCme7WDo001]?fdNKCm]7VdoKAh006dNKCm]7VdoKAi]?`8000?oo`03
003ooooo007oo`00@ooo00<00?ooool0??oo00<00?ooool0D_oo3P00039e?WDN001e7WDnMAie?WDN
001e7WDnMAie?WDNMCie7P00MAie?WDNMCie7WDn001e?WDNMCie7WDnMAh007DNMCie7WDnMAie?P00
KCiU7VdnIAi]?VDN001U7VdnIAi]?VDN0P000ooo00<00?ooool00Ooo0014ool2000lool00`00oooo
o`1Pool70000;7DoMAh007DNMCme7WDoMAie?gDN001e7WDoMAie?gDN001e7WDoMAie?gDNMCme7P00
MAie?gDNMCme7P00KAi]?fdNKCm]7VdoKAh006dNKCm]7VdoKAh20002ool00`00ooooo`01ool004Ko
o`03003ooooo03Woo`03003ooooo06Ooo`l0000NMCie7P00MAie?WDNMCie7WDn001e?WDNMCie7WDn
MAh006DNKCiU7VdnIAi]?P00KCiU7VdnIAi]?VDN0P0000?oo`00ool00_oo0017ool00`00ooooo`0h
ool00`00ooooo`1fool700006GDoMAie?`00MCme7WDoMAie?gDN001]7VdoKAi]?fdNKCl006doKAi]
?fdNKCl006do008000?oo`00B?oo00<00?ooool0=ooo00<00?ooool0OOoo2000011e7WDn001]?VDN
KCiU7VdnIAi]?P00KCiU7VdnIAi]?P<000?oo`00BOoo0P00=ooo00<00?ooool0QOoo1`0000Y]7Vdo
KAh006dNKCm]7VdoKAi]?`<000;oo`00Booo00<00?ooool0=?oo00<00?ooool0S?oo3@000_oo001<
ool00`00ooooo`0cool00`00ooooo`2Gool20002ool004goo`03003ooooo037oo`03003ooooo09So
o`8000;oo`00C_oo0P00<Ooo00<00?ooool0U?oo10001?oo001@ool00`00ooooo`0^ool00`00oooo
o`2@ool40008ool0057oo`03003ooooo02goo`03003ooooo08coo`@000coo`00D_oo00<00?ooool0
;?oo00<00?ooool0R?oo10004?oo001Cool2000/ool00`00ooooo`24ool4000Dool005Goo`03003o
oooo02Woo`03003ooooo087oo`<001Soo`00E_oo00<00?ooool0:?oo00<00?ooool0OOoo10006ooo
001Gool00`00ooooo`0Wool00`00ooooo`1iool4000Oool005Soo`03003ooooo02Koo`03003ooooo
07Goo`@002?oo`00FOoo0P009_oo00<00?ooool0LOoo10009ooo001Kool00`00ooooo`0Sool00`00
ooooo`1]ool4000[ool005coo`03003ooooo02;oo`03003ooooo06[oo`<002ooo`00GOoo00<00?oo
ool08Ooo00<00?ooool0I_oo1000<_oo001Nool2000Qool00`00ooooo`1Rool4000fool0063oo`03
003ooooo01koo`03003ooooo05koo`@003[oo`00HOoo00<00?ooool07Ooo00<00?ooool0F_oo1000
?_oo001Rool00`00ooooo`0Lool00`00ooooo`1Fool40012ool006?oo`8001coo`03003ooooo05?o
o`<004Koo`00IOoo00<00?ooool06Ooo00<00?ooool0Cooo1000BOoo001Vool00`00ooooo`0Hool0
0`00ooooo`1;ool4001=ool006Ooo`03003ooooo01Ooo`03003ooooo04Ooo`@0057oo`00J?oo0P00
5ooo00<00?ooool0@ooo1000EOoo001Zool00`00ooooo`0Dool00`00ooooo`10ool3001Iool006_o
o`03003ooooo01?oo`03003ooooo03coo`@005coo`00K?oo00<00?ooool04_oo00<00?ooool0>?oo
1000H?oo001]ool2000Bool00`00ooooo`0dool4001Tool006ooo`03003ooooo00ooo`03003ooooo
033oo`@006Soo`00L?oo00<00?ooool03Ooo00<00?ooool0;Ooo1000K?oo001aool00`00ooooo`0<
ool00`00ooooo`0Zool3001`ool007;oo`03003ooooo00_oo`03003ooooo02Koo`@007?oo`00Looo
0P002ooo00<00?ooool08_oo1000Mooo001eool00`00ooooo`08ool00`00ooooo`0Nool4001kool0
07Koo`03003ooooo00Ooo`03003ooooo01[oo`@007ooo`00Mooo00<00?ooool01_oo00<00?ooool0
5_oo1000Pooo001hool20006ool00`00ooooo`0Cool30027ool007[oo`03003ooooo00?oo`03003o
oooo00ooo`@008[oo`00Nooo00<00?ooool00_oo00<00?ooool02ooo1000S_oo001lool01@00oooo
oooo00002Ooo1000T_oo001mool200000ooo003oo`04ool4002Fool007ooo`800003ool000000080
09[oo`00P?oo0P00W_oo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo
8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00001\
\>"],
  ImageRangeCache->{{{74.875, 361.875}, {356.938, 124.375}} -> {-0.364341, \
0.480636, 0.00365187, 0.00365187}},
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell[TextData[{
  "An unknown function can also be specified to have a vector (or matrix) \
value.  The dimensionality of an unknown function is taken from its initial \
condition.  You can mix scalar and vector unknown functions as long as the \
equations have consistent dimensionality according to the rules of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " arithmetic.  The InterpolatingFunction result will give values with the \
same dimensionality as the unknown function.  Using non-scalar variables is \
very convenient when a system of differential equations is governed by a \
process that may be difficult or inefficient to express symbolically."
}], "Text",
  CellTags->{"b:1", "ndsg:0"}],

Cell["\<\
This uses a vector valued unknown function to solve the same system \
as above.\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(f[x_?VectorQ]\  := \ 
        ListConvolve[{1, \(-2\), 1}, x, \ {2, 2}, 
          0];\)\), "\[IndentingNewLine]", 
    \(NDSolve[{\(X'\)[t]\  \[Equal] \ f[X[t]], 
        X[0]\  \[Equal] \ \((Range[n - 1]/n)\)^10}, 
      X, {t, 0,  .25}]\)}], "Input",
  CellLabel->"In[221]:=",
  CellTags->{"b:1", "ndsg:0"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"X", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.25`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[222]=",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " is able to solve some partial differential equations directly when you \
specify more independent variables."
}], "Text",
  CellTags->{"b:1", "ndsg:0"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NDSolve",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["eqn",
                          "MR",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox[
                          FormBox["eqn",
                            "TextForm"],
                          "MR",
                          FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                    "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["u",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    StyleBox["t",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["tmin",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["tmax",
                      "MR",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    "MR"]}], ",", 
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    StyleBox["x",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["xmin",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["xmax",
                      "MR",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    "MR"]}], ",", " ", 
                StyleBox["...",
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "solve a sytem of partial differential equations for a function \
",
              StyleBox["u[t,x,", "MR",
                FontSlant->"Italic"],
              StyleBox["...", "MR"],
              StyleBox["]", "MR",
                FontSlant->"Italic"],
              " with  ",
              StyleBox["t",
                FontSlant->"Italic"],
              " in the range ",
              StyleBox["tmin",
                FontSlant->"Italic"],
              " to ",
              StyleBox["tmax",
                FontSlant->"Italic"],
              " and ",
              StyleBox["x",
                FontSlant->"Italic"],
              " in the range ",
              StyleBox["xmin",
                FontSlant->"Italic"],
              " to ",
              StyleBox["xmax,",
                FontSlant->"Italic"],
              StyleBox["...", "MR"]
            }], "Text"]},
          {
            RowBox[{
              StyleBox["NDSolve",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["eqn",
                          "MR",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox[
                          FormBox["eqn",
                            "TextForm"],
                          "MR",
                          FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                    "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["u",
                          "MR",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox["u",
                          "MR",
                          FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                    "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    StyleBox["t",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["tmin",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["tmax",
                      "MR",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    StyleBox["x",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["xmin",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["xmax",
                      "MR",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    "MR"]}], ",", " ", 
                StyleBox["...",
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "solve a system of partial differential equations for several \
functions ",
              StyleBox[Cell[BoxData[
                  \(TraditionalForm\`u\_i\)], "MR"], "MR"]
            }], "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell["\<\
Finding numerical solutions to partial differential equations. \
\
\>", "Caption",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[TextData[{
  "Here is a solution of the heat equation found directly by ",
  StyleBox["NDSolve", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ x\^10, \ u[0, t]\  \[Equal] \ 0, \ 
        u[1, t]\  \[Equal] \ 1}, u, {x, 0, 1}, {t, 0,  .25}]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"b:1", "ndsg:0"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 0.25`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell["Here is a plot of the solution. ", "MathCaption",
  CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot3D[
        Evaluate[First[u[x, t]\  /. \ %]], {x, 0, 1}, {t, 
          0,  .25}];\)\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"b:1", "ndsg:0"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
2.51264e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.14598 .19958 -17.886 -9 ]
[.14598 .19958 .11404 0 ]
[.27013 .15073 -17.1354 -9 ]
[.27013 .15073 .86461 0 ]
[.40046 .09948 -16.3848 -9 ]
[.40046 .09948 1.61518 0 ]
[.53743 .04564 -15.6342 -9 ]
[.53743 .04564 2.36575 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.76745 .09703 0 -6.16187 ]
[.76745 .09703 24 2.83813 ]
[.82812 .18993 0 -6.07246 ]
[.82812 .18993 18 2.92754 ]
[.88369 .27502 0 -5.99218 ]
[.88369 .27502 24 3.00782 ]
[.93478 .35327 0 -5.9197 ]
[.93478 .35327 18 3.0803 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 24 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -18 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -24 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(0.2)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(0.4)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(0.6)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(0.8)] .53743 .04564 .73714 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.18558 .19702 m
.18832 .19985 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.3108 .14799 m
.31341 .15094 L
s
.34306 .13535 m
.34564 .13834 L
s
.37572 .12257 m
.37826 .12558 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.51046 .06981 m
.51284 .07294 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.75514 .10158 m
.74899 .10385 L
s
[(0.05)] .76745 .09703 -1 .3693 Mshowa
.81573 .19425 m
.80953 .19642 L
s
[(0.1)] .82812 .18993 -1 .34944 Mshowa
.87123 .27915 m
.865 .28122 L
s
[(0.15)] .88369 .27502 -1 .3316 Mshowa
.92227 .35722 m
.91601 .35919 L
s
[(0.2)] .93478 .35327 -1 .31549 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(0.25)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70252 .02109 m
.69885 .02251 L
s
.71605 .04178 m
.71237 .04318 L
s
.72932 .06208 m
.72564 .06347 L
s
.74235 .08201 m
.73866 .08339 L
s
.7677 .12078 m
.764 .12213 L
s
.78003 .13965 m
.77633 .14098 L
s
.79214 .15817 m
.78843 .1595 L
s
.80404 .17637 m
.80033 .17768 L
s
.82721 .21182 m
.82349 .21311 L
s
.8385 .22909 m
.83478 .23037 L
s
.8496 .24606 m
.84587 .24733 L
s
.86051 .26275 m
.85677 .264 L
s
.88178 .29529 m
.87804 .29651 L
s
.89215 .31115 m
.88841 .31237 L
s
.90235 .32676 m
.89861 .32797 L
s
.91239 .34211 m
.90864 .34331 L
s
.93198 .37208 m
.92823 .37326 L
s
.94155 .38671 m
.93779 .38788 L
s
.95096 .40111 m
.9472 .40226 L
s
.96022 .41528 m
.95646 .41643 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(0.25)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0.5)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.75)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40054 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43642 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.511 .692 .95 r
.38313 .58323 .40512 .60371 .44161 .60426 .41986 .58316 Metetra
.512 .688 .947 r
.41986 .58316 .44161 .60426 .47885 .60493 .45736 .58322 Metetra
.51 .683 .944 r
.45736 .58322 .47885 .60493 .51686 .60583 .49564 .58353 Metetra
.507 .678 .942 r
.49564 .58353 .51686 .60583 .5557 .60706 .53474 .58423 Metetra
.501 .672 .941 r
.53474 .58423 .5557 .60706 .59539 .60871 .5747 .58541 Metetra
.495 .667 .94 r
.5747 .58541 .59539 .60871 .63597 .61086 .61558 .58717 Metetra
.486 .662 .939 r
.61558 .58717 .63597 .61086 .6775 .61357 .65741 .58959 Metetra
.477 .657 .939 r
.65741 .58959 .6775 .61357 .72003 .61686 .70027 .59269 Metetra
.468 .653 .94 r
.70027 .59269 .72003 .61686 .76361 .62075 .7442 .59649 Metetra
.458 .649 .941 r
.7442 .59649 .76361 .62075 .80831 .62523 .78928 .60097 Metetra
.448 .647 .943 r
.78928 .60097 .80831 .62523 .85416 .63025 .83556 .60608 Metetra
.439 .645 .945 r
.83556 .60608 .85416 .63025 .90123 .63575 .8831 .61174 Metetra
.431 .645 .947 r
.8831 .61174 .90123 .63575 .94957 .64163 .93195 .61786 Metetra
.425 .646 .95 r
.93195 .61786 .94957 .64163 .99922 .6478 .98216 .62429 Metetra
.52 .695 .948 r
.36056 .56222 .38313 .58323 .41986 .58316 .39756 .56143 Metetra
.521 .69 .945 r
.39756 .56143 .41986 .58316 .45736 .58322 .43532 .56078 Metetra
.519 .685 .942 r
.43532 .56078 .45736 .58322 .49564 .58353 .47387 .56043 Metetra
.514 .679 .94 r
.47387 .56043 .49564 .58353 .53474 .58423 .51324 .56051 Metetra
.508 .672 .938 r
.51324 .56051 .53474 .58423 .5747 .58541 .55348 .56116 Metetra
.5 .666 .937 r
.55348 .56116 .5747 .58541 .61558 .58717 .59464 .56249 Metetra
.49 .66 .937 r
.59464 .56249 .61558 .58717 .65741 .58959 .63678 .56458 Metetra
.479 .654 .937 r
.63678 .56458 .65741 .58959 .70027 .59269 .67996 .56748 Metetra
.468 .649 .938 r
.67996 .56748 .70027 .59269 .7442 .59649 .72424 .5712 Metetra
.456 .645 .939 r
.72424 .5712 .7442 .59649 .78928 .60097 .7697 .57571 Metetra
.445 .642 .941 r
.7697 .57571 .78928 .60097 .83556 .60608 .81641 .58097 Metetra
.435 .64 .943 r
.81641 .58097 .83556 .60608 .8831 .61174 .86442 .58687 Metetra
.425 .64 .946 r
.86442 .58687 .8831 .61174 .93195 .61786 .91379 .59328 Metetra
.418 .641 .949 r
.91379 .59328 .93195 .61786 .98216 .62429 .96458 .60007 Metetra
.53 .699 .947 r
.33741 .54067 .36056 .56222 .39756 .56143 .37469 .53905 Metetra
.53 .693 .943 r
.37469 .53905 .39756 .56143 .43532 .56078 .41272 .53758 Metetra
.528 .687 .939 r
.41272 .53758 .43532 .56078 .47387 .56043 .45154 .53645 Metetra
.523 .68 .937 r
.45154 .53645 .47387 .56043 .51324 .56051 .49119 .53583 Metetra
.515 .672 .935 r
.49119 .53583 .51324 .56051 .55348 .56116 .5317 .53588 Metetra
.505 .665 .934 r
.5317 .53588 .55348 .56116 .59464 .56249 .57315 .53672 Metetra
.494 .658 .933 r
.57315 .53672 .59464 .56249 .63678 .56458 .61558 .53845 Metetra
.481 .651 .934 r
.61558 .53845 .63678 .56458 .67996 .56748 .65908 .54113 Metetra
.468 .645 .935 r
.65908 .54113 .67996 .56748 .72424 .5712 .70371 .54478 Metetra
.455 .64 .936 r
.70371 .54478 .72424 .5712 .7697 .57571 .74955 .54936 Metetra
.441 .636 .938 r
.74955 .54936 .7697 .57571 .81641 .58097 .79668 .55482 Metetra
.429 .634 .941 r
.79668 .55482 .81641 .58097 .86442 .58687 .84517 .56104 Metetra
.418 .633 .944 r
.84517 .56104 .86442 .58687 .91379 .59328 .89507 .56785 Metetra
.409 .634 .947 r
.89507 .56785 .91379 .59328 .96458 .60007 .94646 .5751 Metetra
.542 .703 .945 r
.31365 .51855 .33741 .54067 .37469 .53905 .35121 .51596 Metetra
.542 .697 .94 r
.35121 .51596 .37469 .53905 .41272 .53758 .38953 .51355 Metetra
.538 .689 .936 r
.38953 .51355 .41272 .53758 .45154 .53645 .42864 .51153 Metetra
.532 .681 .933 r
.42864 .51153 .45154 .53645 .49119 .53583 .46856 .5101 Metetra
.523 .672 .931 r
.46856 .5101 .49119 .53583 .5317 .53588 .50935 .50945 Metetra
.512 .663 .93 r
.50935 .50945 .5317 .53588 .57315 .53672 .55108 .50973 Metetra
.498 .655 .929 r
.55108 .50973 .57315 .53672 .61558 .53845 .59381 .51106 Metetra
.484 .647 .93 r
.59381 .51106 .61558 .53845 .65908 .54113 .63761 .51351 Metetra
.468 .64 .931 r
.63761 .51351 .65908 .54113 .70371 .54478 .68258 .5171 Metetra
.452 .634 .933 r
.68258 .5171 .70371 .54478 .74955 .54936 .7288 .52181 Metetra
.437 .63 .935 r
.7288 .52181 .74955 .54936 .79668 .55482 .77636 .52754 Metetra
.422 .627 .938 r
.77636 .52754 .79668 .55482 .84517 .56104 .82532 .53417 Metetra
.409 .626 .942 r
.82532 .53417 .84517 .56104 .89507 .56785 .87577 .54151 Metetra
.398 .627 .946 r
.87577 .54151 .89507 .56785 .94646 .5751 .92776 .54934 Metetra
.555 .708 .942 r
.28926 .49583 .31365 .51855 .35121 .51596 .32713 .49214 Metetra
.554 .7 .937 r
.32713 .49214 .35121 .51596 .38953 .51355 .36575 .48863 Metetra
.55 .691 .933 r
.36575 .48863 .38953 .51355 .42864 .51153 .40514 .48557 Metetra
.543 .681 .929 r
.40514 .48557 .42864 .51153 .46856 .5101 .44535 .4832 Metetra
.532 .672 .927 r
.44535 .4832 .46856 .5101 .50935 .50945 .48642 .48174 Metetra
.519 .662 .925 r
.48642 .48174 .50935 .50945 .55108 .50973 .52842 .48138 Metetra
.503 .652 .925 r
.52842 .48138 .55108 .50973 .59381 .51106 .57144 .48226 Metetra
.487 .643 .925 r
.57144 .48226 .59381 .51106 .63761 .51351 .61555 .48446 Metetra
.468 .634 .927 r
.61555 .48446 .63761 .51351 .68258 .5171 .66085 .48802 Metetra
.45 .627 .929 r
.66085 .48802 .68258 .5171 .7288 .52181 .70744 .4929 Metetra
.431 .622 .932 r
.70744 .4929 .7288 .52181 .77636 .52754 .75541 .499 Metetra
.414 .618 .935 r
.75541 .499 .77636 .52754 .82532 .53417 .80486 .50616 Metetra
.398 .617 .939 r
.80486 .50616 .82532 .53417 .87577 .54151 .85586 .51417 Metetra
.385 .618 .943 r
.85586 .51417 .87577 .54151 .92776 .54934 .90848 .52276 Metetra
.57 .713 .939 r
.2642 .4725 .28926 .49583 .32713 .49214 .3024 .46752 Metetra
.569 .704 .933 r
.3024 .46752 .32713 .49214 .36575 .48863 .34134 .46275 Metetra
.563 .694 .928 r
.34134 .46275 .36575 .48863 .40514 .48557 .38104 .45849 Metetra
.554 .682 .924 r
.38104 .45849 .40514 .48557 .44535 .4832 .42154 .45503 Metetra
.542 .671 .922 r
.42154 .45503 .44535 .4832 .48642 .48174 .4629 .45264 Metetra
.527 .659 .92 r
.4629 .45264 .48642 .48174 .52842 .48138 .50518 .45154 Metetra
.509 .648 .92 r
.50518 .45154 .52842 .48138 .57144 .48226 .54847 .45189 Metetra
.489 .637 .92 r
.54847 .45189 .57144 .48226 .61555 .48446 .59287 .45382 Metetra
.468 .628 .922 r
.59287 .45382 .61555 .48446 .66085 .48802 .63848 .45735 Metetra
.447 .619 .924 r
.63848 .45735 .66085 .48802 .70744 .4929 .68543 .46246 Metetra
.425 .612 .927 r
.68543 .46246 .70744 .4929 .75541 .499 .73381 .46904 Metetra
.404 .608 .931 r
.73381 .46904 .75541 .499 .80486 .50616 .78374 .4769 Metetra
.385 .606 .936 r
.78374 .4769 .80486 .50616 .85586 .51417 .8353 .48577 Metetra
.369 .607 .941 r
.8353 .48577 .85586 .51417 .90848 .52276 .88857 .49533 Metetra
.586 .719 .935 r
.23846 .44853 .2642 .4725 .3024 .46752 .27702 .44207 Metetra
.584 .708 .928 r
.27702 .44207 .3024 .46752 .34134 .46275 .31631 .43584 Metetra
.578 .696 .923 r
.31631 .43584 .34134 .46275 .38104 .45849 .35633 .4302 Metetra
.567 .684 .918 r
.35633 .4302 .38104 .45849 .42154 .45503 .39714 .42549 Metetra
.553 .671 .916 r
.39714 .42549 .42154 .45503 .4629 .45264 .43878 .422 Metetra
.536 .657 .914 r
.43878 .422 .4629 .45264 .50518 .45154 .48133 .42003 Metetra
.516 .644 .914 r
.48133 .42003 .50518 .45154 .54847 .45189 .52489 .41976 Metetra
.493 .632 .914 r
.52489 .41976 .54847 .45189 .59287 .45382 .56956 .42136 Metetra
.469 .62 .916 r
.56956 .42136 .59287 .45382 .63848 .45735 .61548 .42488 Metetra
.443 .609 .918 r
.61548 .42488 .63848 .45735 .68543 .46246 .66276 .43029 Metetra
.417 .601 .922 r
.66276 .43029 .68543 .46246 .73381 .46904 .71155 .43748 Metetra
.392 .595 .926 r
.71155 .43748 .73381 .46904 .78374 .4769 .76195 .44622 Metetra
.369 .592 .931 r
.76195 .44622 .78374 .4769 .8353 .48577 .81407 .45618 Metetra
.35 .592 .937 r
.81407 .45618 .8353 .48577 .88857 .49533 .868 .46699 Metetra
.603 .724 .93 r
.212 .42389 .23846 .44853 .27702 .44207 .25096 .41576 Metetra
.601 .712 .923 r
.25096 .41576 .27702 .44207 .31631 .43584 .29062 .40788 Metetra
.593 .699 .917 r
.29062 .40788 .31631 .43584 .35633 .4302 .331 .40066 Metetra
.581 .685 .912 r
.331 .40066 .35633 .4302 .39714 .42549 .37212 .39447 Metetra
.565 .67 .909 r
.37212 .39447 .39714 .42549 .43878 .422 .41406 .3897 Metetra
.546 .655 .907 r
.41406 .3897 .43878 .422 .48133 .42003 .45688 .38667 Metetra
.523 .64 .906 r
.45688 .38667 .48133 .42003 .52489 .41976 .5007 .38564 Metetra
.497 .625 .907 r
.5007 .38564 .52489 .41976 .56956 .42136 .54563 .38682 Metetra
.469 .611 .909 r
.54563 .38682 .56956 .42136 .61548 .42488 .59182 .3903 Metetra
.439 .598 .911 r
.59182 .3903 .61548 .42488 .66276 .43029 .63942 .39608 Metetra
.409 .587 .915 r
.63942 .39608 .66276 .43029 .71155 .43748 .68858 .40403 Metetra
.378 .579 .92 r
.68858 .40403 .71155 .43748 .76195 .44622 .73944 .41389 Metetra
.35 .575 .925 r
.73944 .41389 .76195 .44622 .81407 .45618 .79213 .42528 Metetra
.325 .575 .931 r
.79213 .42528 .81407 .45618 .868 .46699 .84674 .4377 Metetra
.621 .73 .924 r
.18479 .39856 .212 .42389 .25096 .41576 .22418 .38859 Metetra
.618 .717 .917 r
.22418 .38859 .25096 .41576 .29062 .40788 .26426 .37888 Metetra
.609 .703 .91 r
.26426 .37888 .29062 .40788 .331 .40066 .30502 .36986 Metetra
.596 .687 .905 r
.30502 .36986 .331 .40066 .37212 .39447 .34649 .36197 Metetra
.579 .671 .902 r
.34649 .36197 .37212 .39447 .41406 .3897 .38874 .35565 Metetra
.558 .654 .9 r
.38874 .35565 .41406 .3897 .45688 .38667 .43183 .3513 Metetra
.533 .636 .899 r
.43183 .3513 .45688 .38667 .5007 .38564 .4759 .34927 Metetra
.503 .618 .899 r
.4759 .34927 .5007 .38564 .54563 .38682 .52107 .34985 Metetra
.471 .601 .9 r
.52107 .34985 .54563 .38682 .59182 .3903 .5675 .35321 Metetra
.436 .585 .902 r
.5675 .35321 .59182 .3903 .63942 .39608 .61538 .3594 Metetra
.399 .571 .906 r
.61538 .3594 .63942 .39608 .68858 .40403 .66488 .36829 Metetra
.362 .56 .911 r
.66488 .36829 .68858 .40403 .73944 .41389 .71619 .37959 Metetra
.326 .553 .916 r
.71619 .37959 .73944 .41389 .79213 .42528 .76944 .39285 Metetra
.295 .551 .923 r
.76944 .39285 .79213 .42528 .84674 .4377 .82477 .40742 Metetra
.638 .735 .918 r
.1568 .3725 .18479 .39856 .22418 .38859 .19667 .36062 Metetra
.634 .722 .911 r
.19667 .36062 .22418 .38859 .26426 .37888 .23719 .34896 Metetra
.626 .707 .904 r
.23719 .34896 .26426 .37888 .30502 .36986 .27837 .33797 Metetra
.613 .691 .899 r
.27837 .33797 .30502 .36986 .34649 .36197 .32023 .32812 Metetra
.595 .674 .895 r
.32023 .32812 .34649 .36197 .38874 .35565 .36281 .3199 Metetra
.573 .655 .892 r
.36281 .3199 .38874 .35565 .43183 .3513 .4062 .31382 Metetra
.545 .634 .89 r
.4062 .31382 .43183 .3513 .4759 .34927 .45051 .31038 Metetra
.513 .612 .889 r
.45051 .31038 .4759 .34927 .52107 .34985 .4959 .31 Metetra
.476 .591 .889 r
.4959 .31 .52107 .34985 .5675 .35321 .54254 .31301 Metetra
.434 .57 .891 r
.54254 .31301 .5675 .35321 .61538 .3594 .59064 .31956 Metetra
.39 .551 .894 r
.59064 .31956 .61538 .3594 .66488 .36829 .64044 .32959 Metetra
.344 .535 .898 r
.64044 .32959 .66488 .36829 .71619 .37959 .69215 .34278 Metetra
.297 .524 .904 r
.69215 .34278 .71619 .37959 .76944 .39285 .74596 .35855 Metetra
.255 .52 .91 r
.74596 .35855 .76944 .39285 .82477 .40742 .80203 .37608 Metetra
.652 .738 .913 r
.128 .34568 .1568 .3725 .19667 .36062 .16835 .33202 Metetra
.648 .727 .906 r
.16835 .33202 .19667 .36062 .23719 .34896 .20935 .31848 Metetra
.641 .714 .9 r
.20935 .31848 .23719 .34896 .27837 .33797 .25099 .30543 Metetra
.63 .699 .895 r
.25099 .30543 .27837 .33797 .32023 .32812 .29328 .29334 Metetra
.614 .681 .89 r
.29328 .29334 .32023 .32812 .36281 .3199 .33625 .28276 Metetra
.592 .66 .885 r
.33625 .28276 .36281 .3199 .4062 .31382 .37998 .27431 Metetra
.563 .635 .881 r
.37998 .27431 .4062 .31382 .45051 .31038 .42456 .26872 Metetra
.528 .609 .877 r
.42456 .26872 .45051 .31038 .4959 .31 .47015 .26666 Metetra
.487 .581 .875 r
.47015 .26666 .4959 .31 .54254 .31301 .51695 .26875 Metetra
.438 .553 .874 r
.51695 .26875 .54254 .31301 .59064 .31956 .56522 .2754 Metetra
.383 .526 .876 r
.56522 .2754 .59064 .31956 .64044 .32959 .61523 .28672 Metetra
.324 .502 .879 r
.61523 .28672 .64044 .32959 .69215 .34278 .66729 .30243 Metetra
.261 .484 .884 r
.66729 .30243 .69215 .34278 .74596 .35855 .72164 .32179 Metetra
.201 .474 .89 r
.72164 .32179 .74596 .35855 .80203 .37608 .77849 .34365 Metetra
.661 .741 .909 r
.09834 .31807 .128 .34568 .16835 .33202 .13916 .30307 Metetra
.659 .733 .905 r
.13916 .30307 .16835 .33202 .20935 .31848 .18063 .288 Metetra
.655 .724 .9 r
.18063 .288 .20935 .31848 .25099 .30543 .22275 .27308 Metetra
.647 .712 .895 r
.22275 .27308 .25099 .30543 .29328 .29334 .26553 .25863 Metetra
.635 .695 .889 r
.26553 .25863 .29328 .29334 .33625 .28276 .30898 .24519 Metetra
.617 .673 .881 r
.30898 .24519 .33625 .28276 .37998 .27431 .35314 .23347 Metetra
.591 .646 .873 r
.35314 .23347 .37998 .27431 .42456 .26872 .39806 .22443 Metetra
.556 .613 .865 r
.39806 .22443 .42456 .26872 .47015 .26666 .44389 .21919 Metetra
.51 .575 .857 r
.44389 .21919 .47015 .26666 .51695 .26875 .49082 .21895 Metetra
.453 .536 .852 r
.49082 .21895 .51695 .26875 .56522 .2754 .53915 .22474 Metetra
.385 .496 .849 r
.53915 .22474 .56522 .2754 .61523 .28672 .58925 .23719 Metetra
.307 .459 .849 r
.58925 .23719 .61523 .28672 .66729 .30243 .64154 .2563 Metetra
.218 .427 .852 r
.64154 .2563 .66729 .30243 .72164 .32179 .69639 .28117 Metetra
.124 .403 .854 r
.69639 .28117 .72164 .32179 .77849 .34365 .7541 .31005 Metetra
.663 .741 .908 r
.0678 .28963 .09834 .31807 .13916 .30307 .10902 .27389 Metetra
.663 .739 .907 r
.10902 .27389 .13916 .30307 .18063 .288 .15092 .25791 Metetra
.662 .736 .904 r
.15092 .25791 .18063 .288 .22275 .27308 .19351 .24173 Metetra
.66 .73 .901 r
.19351 .24173 .22275 .27308 .26553 .25863 .23679 .22545 Metetra
.656 .719 .895 r
.23679 .22545 .26553 .25863 .30898 .24519 .28079 .20929 Metetra
.647 .702 .886 r
.28079 .20929 .30898 .24519 .35314 .23347 .3255 .19371 Metetra
.631 .675 .874 r
.3255 .19371 .35314 .23347 .39806 .22443 .37093 .17956 Metetra
.603 .637 .858 r
.37093 .17956 .39806 .22443 .44389 .21919 .41715 .16827 Metetra
.56 .589 .84 r
.41715 .16827 .44389 .21919 .49082 .21895 .46427 .16195 Metetra
.499 .532 .822 r
.46427 .16195 .49082 .21895 .53915 .22474 .51257 .1632 Metetra
.417 .47 .808 r
.51257 .1632 .53915 .22474 .58925 .23719 .56253 .1746 Metetra
.31 .405 .797 r
.56253 .1746 .58925 .23719 .64154 .2563 .61479 .19779 Metetra
.175 .34 .791 r
.61479 .19779 .64154 .2563 .69639 .28117 .67004 .23237 Metetra
.008 .28 .779 r
.67004 .23237 .69639 .28117 .7541 .31005 .72883 .27522 Metetra
.664 .741 .908 r
.03634 .26033 .0678 .28963 .10902 .27389 .07793 .24409 Metetra
.664 .741 .908 r
.07793 .24409 .10902 .27389 .15092 .25791 .12022 .22757 Metetra
.664 .741 .908 r
.12022 .22757 .15092 .25791 .19351 .24173 .16322 .21077 Metetra
.663 .74 .907 r
.16322 .21077 .19351 .24173 .23679 .22545 .20695 .19369 Metetra
.663 .738 .906 r
.20695 .19369 .23679 .22545 .28079 .20929 .25144 .17632 Metetra
.662 .733 .902 r
.25144 .17632 .28079 .20929 .3255 .19371 .29669 .15868 Metetra
.66 .722 .895 r
.29669 .15868 .3255 .19371 .37093 .17956 .34273 .14086 Metetra
.654 .7 .88 r
.34273 .14086 .37093 .17956 .41715 .16827 .38956 .12314 Metetra
.64 .661 .855 r
.38956 .12314 .41715 .16827 .46427 .16195 .43721 .1063 Metetra
.61 .601 .818 r
.43721 .1063 .46427 .16195 .51257 .1632 .48573 .09218 Metetra
.557 .522 .772 r
.48573 .09218 .51257 .1632 .56253 .1746 .53533 .08482 Metetra
.47 .426 .727 r
.53533 .08482 .56253 .1746 .61479 .19779 .58657 .09256 Metetra
.303 .294 .683 r
.58657 .09256 .61479 .19779 .67004 .23237 .64103 .13229 Metetra
0 .003 .56 r
.64103 .13229 .67004 .23237 .72883 .27522 .70262 .2391 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.1552 .20892 m
.15981 .21359 L
s
[(0.2)] .14598 .19958 .98733 1 Mshowa
.27893 .16047 m
.28333 .16533 L
s
[(0.4)] .27013 .15073 .90393 1 Mshowa
.40878 .10962 m
.41294 .11469 L
s
[(0.6)] .40046 .09948 .82054 1 Mshowa
.54521 .0562 m
.54911 .06148 L
s
[(0.8)] .53743 .04564 .73714 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.18558 .19702 m
.18832 .19985 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.3108 .14799 m
.31341 .15094 L
s
.34306 .13535 m
.34564 .13834 L
s
.37572 .12257 m
.37826 .12558 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.51046 .06981 m
.51284 .07294 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  ImageSize->{288, 233.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jA000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00;[oo`@006;oo`00_?oo00<00?oo
ool0HOoo002lool00`00ooooo`1Qool00;coo`03003ooooo067oo`00_?oo00<00?ooool01Ooo0P00
F_oo002jool30006ool01000ooooo`00FOoo002lool00`00ooooo`04ool01000ooooo`00FOoo0033
ool01000ooooo`00FOoo0033ool01000ooooo`00FOoo0033ool01000ooooo`00FOoo002nool20004
ool2001Jool00;coo`800003ool0000005ooo`00^Ooo0`000ooo0P00Gooo002fool30006ool00`00
ool0001Nool008goo`8000Coo`03003ooooo00?oo`8001Woo`@000Ooo`04003ooooo001Mool008co
o`04003ooooo0008ool01000ooooo`005Ooo0`002ooo00<00?ooool00P00G?oo002<ool01000oooo
o`002?oo00@00?ooool001;oo`<000koo`05003oooooool0001Lool008coo`04003ooooo0009ool2
000Aool3000@ool00`00ooooo`02ool00`00ooooo`1Iool008coo`04003ooooo0008ool01000oooo
o`003_oo0P005?oo00D00?ooooooo`0005_oo`00S?oo00@00?ooool000Soo`04003ooooo000;ool3
000Fool00`00ooooo`02ool00`00ooooo`1Hool008goo`8000[oo`8000[oo`8001Woo`03003ooooo
00;oo`8005Woo`00X_oo0`0000?oo`00ool06?oo00<00?ooool00ooo00<00?ooool0Eooo002Pool2
000Nool00`00ooooo`04ool00`00ooooo`1Fool009coo`@0023oo`03003ooooo00Coo`03003ooooo
05Koo`00Vooo0`008_oo00<00?ooool01Ooo00<00?ooool0EOoo002Hool3000Uool00`00ooooo`05
ool2001Fool009Coo`@002Soo`03003ooooo00Koo`03003ooooo05Coo`00Jooo0P001?oo00<00?oo
ool00ooo0P006_oo0`00:_oo00<00?ooool01ooo00<00?ooool0Dooo001Zool01000ooooo`002?oo
00@00?ooool001Koo`<002goo`03003ooooo00Soo`03003ooooo05;oo`00J_oo00@00?ooool000So
o`04003ooooo000Dool2000`ool00`00ooooo`08ool20007ool20004ool00`00ooooo`03ool20003
ool3000hool006[oo`04003ooooo0008ool3000Bool30009ool6000Sool00`00ooooo`08ool20006
ool01000ooooo`002?oo00@00?ooool000Goo`03003ooooo03Goo`00J_oo00@00?ooool000Soo`03
003ooooo013oo`800003ool00?oo00?oo`H000><6003001kEg]G00H001goo`03003ooooo00[oo`03
003ooooo00?oo`04003ooooo0008ool01000ooooo`001Ooo00<00?ooool0=Ooo001Zool01000oooo
o`002?oo00<00?ooool03Ooo0`000ooo1@0001:<68`iS1R<>H`HS3V<68`iS1R<>@00NgMkEg]gNeMk
Mg]GNgL4000Iool00`00ooooo`0:ool00`00ooooo`03ool01000ooooo`002?oo00@00?ooool000;o
o`<003Soo`00Jooo0P002_oo0`002Ooo0`000_oo100000>LfYcj000038`H00<007]GNeL027]G0`00
6?oo00<00?ooool02_oo00<00?ooool00_oo00@00?ooool000Soo`04003ooooo0002ool00`00oooo
o`0hool0087oo`L0000RW?ZLfYcjW=ZLnYcJW?X008`iS1R<>H`HS3V<68`iS1R<>H`HS3T007]gNeMk
Mg]GNgMkEg]gNeMkMg]GNgL004Ye000Gool00`00ooooo`0;ool01@00oooooooo00000_oo00<00?oo
ool01_oo00@00?ooool000;oo`03003ooooo03Soo`00Oooo1@0000bLfYcjW=ZLnYcJW?ZLfYcjW=ZL
nYcJ000<S1P00`00NeMkE`08NeL01000BUE:E@005_oo00<00?ooool02_oo0P001?oo0P002_oo0P00
0ooo1000=ooo001kool60000:ZEK002LfYcjW=ZLnYcJW?ZLfYcjW=ZLnYcJW?ZLfP00S1R<>H`HS3V<
68`iS1R<>H`HS3V<6000NeMkMg]GNgMkEg]gNeMkMg]GNgL004YeBUE:M@8001Coo`03003ooooo00co
o`03003ooooo04goo`00NOoo1@0001>UFjEkYE^UNjEK002LfYcjW=ZLnYcJW?ZLfYcjW=ZLnYcJW?X0
000;S1P00`00NeMkE`08NeL00`00BUE:E@03BUD00`00ooooo`0Aool00`00ooooo`0=ool00`00oooo
o`1<ool007Ooo`D0000bYG^UFjEkYE^UNjEKYG/009cjW=ZLnYcJW?ZLfYcjW=ZLnYcJW?ZLfP00S1R<
>H`HS3V<68`iS1R<>H`HS3V<68`i001kMg]GNgMkEg]gNeMkMg]GNgMkE`00BUE:MDYEBWE:E@80017o
o`03003ooooo00goo`03003ooooo04coo`00B_oo0P001?oo00<00?ooool01?oo00<00?ooool06Ooo
1P0001VUNjEKYG^UFjEkYE^UNjEKYG^UFjEk002LnYcJW?ZLfYcjW=ZLnYcJW?ZLfYcjW=X0000;S1P0
0`00NeMkE`08NeL00`00BUE:E@05BUD00`00ooooo`0>ool00`00ooooo`0>ool00`00ooooo`1;ool0
04Woo`04003ooooo000:ool00`00ooooo`0Hool40000?:FmYI`00:EKYG^UFjEkYE^UNjEKYG^UFjEk
YE/009cJW?ZLfYcjW=ZLnYcJW?ZLfYcjW=ZLnP00S3V<68`iS1R<>H`HS3V<68`iS1R<>@00NgMkEg]g
NeMkMg]GNgMkEg]gNeL004YEBWE:EDYeBUE:MDYEBWD000ooo`03003ooooo00ooo`03003ooooo04[o
o`00BOoo00@00?ooool000Ooo`D001Koo`D0000OYIbU_:FLYK`00:EkYE^UNjEKYG^UFjEkYE^UNjEK
YG^UF`00W=ZLnYcJW?ZLfYcjW=ZLnYcJW?ZLfYcj00002X`H00<007]GNeL027]G00<004YEBUD01dYE
0P003Ooo00<00?ooool03ooo00<00?ooool0B_oo0019ool01000ooooo`001ooo00@00?ooool001?o
o`03003oo`0000<00014YIbU_JFLYKfUW:FmYIbU_@00YG^UFjEkYE^UNjEKYG^UFjEkYE^UN`00W?ZL
fYcjW=ZLnYcJW?ZLfYcjW=ZLnYcJ002<68`iS1R<>H`HS3V<68`iS1R<>H`H001kEg]gNeMkMg]GNgMk
Eg]gNeMkM`00BWE:EDYeBUE:MDYEBWE:EDYeBUD000coo`03003ooooo013oo`03003ooooo04Woo`00
BOoo00@00?ooool000Soo`03003oo`0001;oo`D0000UYKbUW:FlYIbU_:FLYKbUW:FlYI`00:EKYG^U
FjEkYE^UNjEKYG^UFjEkYE^UN`00W?ZLfYcjW=ZLnYcJW?ZLfYcjW=ZLnYcJ00002X`H00<007]GNeL0
27]G00<004YEBUD024YE0P002ooo00<00?ooool04Ooo00<00?ooool0B?oo0019ool01000ooooo`00
2Ooo0P004?oo1@0004VUW:FmYIbU_JFLYKfUW:FmYIbU_JFLYKfUW000YE^UNjEKYG^UFjEkYE^UNjEK
YG^UF`00W=ZLnYcJW?ZLfYcjW=ZLnYcJW?ZLfYcj002<>H`HS3V<68`iS1R<>H`HS3V<6000NeMkMg]G
NgMkEg]gNeMkMg]GNgL004YeBUE:MDYEBWE:EDYeBUE:MDYEBWD0000;ool00`00ooooo`0Aool00`00
ooooo`18ool004[oo`8000_oo`03003ooooo00Woo`03003oo`0000@0000Z[Mb]o000YKbUW:FlYIbU
_:FLYKbUW:FlYIbU_:FLYK`00:EkYE^UNjEKYG^UFjEkYE^UNjEKYG^UF`00W=ZLnYcJW?ZLfYcjW=ZL
nYcJW?ZLfP002h`H00<007]GNeL01g]G00<004YEBUD02DYE0P002_oo00<00?ooool04_oo00<00?oo
ool0Aooo001Rool50000CZgl[Of]o:gm[Ob]o@00YKfUW:FmYIbU_JFLYKfUW:FmYIbU_JFLYKd00:Ek
YE^UNjEKYG^UFjEkYE^UNjEKYG/009cjW=ZLnYcJW?ZLfYcjW=ZLnYcJW?ZLfP00S1R<>H`HS3V<68`i
S1R<>H`HS3T007]gNeMkMg]GNgMkEg]gNeMkMg]G001:EDYeBUE:MDYEBWE:EDYeBUE:M@8000[oo`03
003ooooo01?oo`03003ooooo04Koo`00H?oo1@00032]o:gL[Ob]g:gl[Mb]o:gL002UW:FlYIbU_:FL
YKbUW:FlYIbU_:FLYKbUW000YE^UNjEKYG^UFjEkYE^UNjEKYG^UFjEk002LnYcJW?ZLfYcjW=ZLnYcJ
W?ZLfYcj000:S1P00`00NeMkE`08NeL00`00BUE:E@08BUD00`000140000:ool00`00ooooo`0Bool0
0`00ooooo`16ool005goo`D0001D[Of]o:gm[Ob]oJgl[Of]o:gm[Ob]oJgl002UW:FmYIbU_JFLYKfU
W:FmYIbU_JFLYKfUW000YE^UNjEKYG^UFjEkYE^UNjEKYG^UF`00W=ZLnYcJW?ZLfYcjW=ZLnYcJW?ZL
fYcj002<>H`HS3V<68`iS1R<>H`HS3V<6000NeMkMg]GNgMkEg]gNeMkMg]G001:EDYeBUE:MDYEBWE:
EDYeBUE:MDYE0P002_oo00<00?ooool04ooo00<00?ooool0AOoo001Kool400009:gl[M`00:gL[Ob]
g:gl[Mb]o:gL[Ob]g:gl[Mb]o:gL002UW:FlYIbU_:FLYKbUW:FlYIbU_:FLYK`00:EkYE^UNjEKYG^U
Fa@000V<6003001kEg]G00QkE`03001:EDYE00Q:E@0300004@0000Woo`03003ooooo01?oo`03003o
oooo04Goo`00F?oo1000022]o@00[Of]o:gm[O`00:gl[Of]o:gm[Ob]oJgl[Of]o:gm[Ob]oJgl002U
W:FmYIbU_JFLYKfUW:FmYIbU_JFL1`0001B<VXbjS9Z<^XbJS;X007ajO5YlNWaJO7YlFWajO5YlNWaJ
O7X006_i100001b<68`iS1R<>H`H001kEg]gNeMkMg]GNgMkEg]gNeMkM`00BWE:EDYeBUE:MDYEBWE:
EDYeBUD000804@03003ooooo00Koo`03003ooooo01Coo`03003ooooo04Coo`00;?oo0P001?oo00<0
0?ooool00_oo10006ooo100001j]g:gl[Mb]o:gL[Ob]g:gl002]o:gL[Ob]g:gl[Mb]o:gL[Ob]g:gl
[Mb]o000YKbUW:FlYIbU_:FLYK`400003idKWC/008bjS9Z<^XbJS;Z<VXbjS9Z<^XbJS;X0000;O5X0
1@00JoUSfF_iHmT010000X`H00<007]GNeL01g]G00<004YEBUD02DYE00<0000A00002?oo00<00?oo
ool05Ooo00<00?ooool0@ooo000[ool01000ooooo`002?oo00<00?ooool06Ooo100001f]o:gm[Ob]
oJgl[Of]o:gm[Ob]oJgl[Od00:gm[Ob]oJgl[Of]o:gm[Ob]oJgl[Of]o:gm002U_JFL00@0000WWC^M
6idkWA^M>idK002<VXbjS9Z<^XbJS;Z<VXbjS9Z<^XbJ001lFWajO5YlNWaJO7YlFWajO5YlNWaJ001[
fF_iJmU[nF_IJoU[fF_i00<0000FNgMkEg]gNeMkMg]GNgMkEg]g001:MDYEBWE:EDYeBUE:MDYEBWE:
EDYe000201400`00ooooo`05ool00`00ooooo`0Eool20007ool20004ool00`00ooooo`02ool4000^
ool002_oo`04003ooooo0009ool00`00ooooo`0Fool300007JgL[O`00:gl[Mb]o:gL[Ob]g:gl[Mb]
o:gL[Ob]g:gl002]o:gL[Ob]g:gl[Mb]o:gL[Ob]g:gl[M`00`0001RM6idkWA^M>idKWC^M6idkWA^M
>idK002<VXbjS9Z<^XbJS;Z<VXbjS9Z<^XbJ000;O5X02P00HmU[nF?IJoUSfF_iHmU[nF?I0`0027]G
00<004YEBUD024YE00@0000A014000Ooo`03003ooooo01Goo`8000Koo`04003ooooo000:ool00`00
ooooo`0]ool002_oo`04003ooooo000:ool00`00ooooo`0Aool500007:gm[Ob]oJgl[Od00:gm[Ob]
oJgl[Of]o:gm[Ob]oJgl[Of]o:gm002]oJgl[Of]o:gm[Ob]oJgl0`0003>UFjEk002M>idKWC^M6idk
WA^M>idKWC^M6idk002<^XbJS;Z<VXbjS9Z<^XbJS;Z<VXbj001lNWaJO7YlFWajO5YlNWaJO7YlFWaj
001[nF_IJoU[fF_iJmU[nF_IJoU[f@00BaT00P00019kMg]GNgMkEg]gNeL004YEBWE:EDYeBUE:MDYE
BWE:EDYe000301400`00ooooo`04ool00`00ooooo`0Gool00`00ooooo`03ool01000ooooo`002_oo
00<00?ooool0;Ooo000[ool01000ooooo`002ooo00<00?ooool03ooo100001b]g:gl[Mb]o:gL[Ob]
g:gl002]o:gL[Ob]g:gl[Mb]o:gL[Ob]g:gl[M`00:gL[Ob]g:gl[Mb]o080000OYE^UNjEKYG^UF`00
WA^M>idKWC^M6idkWA^M>idKWC^M6idk002<^XbJS;Z<VXbjS9Z<^XbJS;Z<VXbj00002WaJ00`006?I
JoUSfF_iHmU[nF?IJoUSfF_i0003BaT20004NeL00`00BUE:E@09BUD0100001404@001_oo00<00?oo
ool05ooo00<00?ooool00ooo00@00?ooool000[oo`03003ooooo02goo`00:ooo00@00?ooool000So
o`04003ooooo000>ool500006jgm[Ob]oJgl[Of]o:gm[Ob]oJgl002]o:gm[Ob]oJgl[Of]o:gm[Ob]
oJgl[Of]o000[Ob]o@030000?:EkYE^UNjEKYG^UFjEkYE/009dKWC^M6idkWA^M>idKWC^M6idkWA/0
08bJS;Z<VXbjS9Z<^XbJS;Z<VXbjS9X007aJO7YlFWajO5YlNWaJO7YlFWajO5X006_IJoU[fF_iJmU[
nF_IJoU[fF_i001;>D/IBcU;6@80000?NgMkE`00BUE:MDYEBWE:EDYeBUE:MDYEBWE:E@0000<04@03
003ooooo00?oo`03003ooooo01Soo`03003ooooo00;oo`04003ooooo000:ool00`00ooooo`0]ool0
02coo`8000[oo`8000_oo`L0000J[Mb]o:gL[Ob]g:gl[Mb]o:gL[Ob]g:gl[M`00:gL[Ob]g:gl[Mb]
o:gL[Ob]g:gl[Mb]o0<0000TYG^UFjEkYE^UNjEKYG^UFjEkYE^UNjEK002M6idkWA^M>idKWC^M6idk
WA^M>idK002<VXbjS9Z<^XbJS;Z<VXbjS9Z<^P002gaJ00`006_iHmU[nF?IJoUSfF_iHmU[nF?I0006
BaT200000g]G001:E@09BUD00`0001404@0201400`00ooooo`02ool00`00ooooo`0Hool20003ool0
1000ooooo`002?oo0`00;ooo0014ool500006Jgm[Oh00:gm[Ob]oJgl[Of]o:gm[Ob]oJgl[Of]o:gm
[O`00:gl[Of]o:gm[Ob]oJgl00@00016YKfUW000YE^UNjEKYG^UFjEkYE^UNjEKYG^UFjEk002M>idK
WC^M6idkWA^M>idKWC^M6idk002<^XbJS;Z<VXbjS9Z<^XbJS;Z<VXbj001lNWaJO7YlFWajO5YlNWaJ
O7YlFWaj001[nF_IJoU[fF_iJmU[nF_IJoT004/iBaU;>D/IBcU;6D/iBaT2000034YeBUE:MDYEBWE:
EDYeBUE:MDYEBWD000<04@03003ooooo00;oo`03003ooooo01Woo`03003ooooo00;oo`8000_oo`03
003ooooo02goo`00@Ooo1P0001N]oJgM[Of]gJgm002]o:gL[Ob]g:gl[Mb]o:gL[Ob]g:gl[Mb]o:gL
002]g:gl00@0000/YIbU_:FLYKbUW:FlYI`00:EKYG^UFjEkYE^UNjEKYG^UFjEkYE^UN`00WC^M6idk
WA^M>idKWC^M6idkWA^M>`00S;Z<VXbjS9Z<^XbJS;Z<VXbjS9X000]lFP0<001SfF_iHmU[nF?IJoUS
fF_iHmU[n@0024/I0`002DYE00<0000A01400P0A00D00?ooooooo`0001coo`03003ooooo03koo`00
?_oo0`0001[oo`00002]oZgm[Oj]oJgn[Of]oZgm[Oh00:gm[Ob]oJgl[Of]o:gm[Ob]oJgl[Of]o:gm
0`0005:U_JFLYKfUW:FmYIbU_JFLYKfUW:Fm002UNjEKYG^UFjEkYE^UNjEKYG^UFjEkYE/009dKWC^M
6idkWA^M>idKWC^M6idkWA/008bJS;Z<VXbjS9Z<^XbJS;Z<VXbjS9X007aJO7YlFWajO5YlNWaJO7Yl
FWaj001[nF_IJoU[fF_iJmU[nF_IJoU[f@00BaU;>D/IBcU;6D/iBaU;>D/I000ZV@800008BWE:EDYe
BUE:MDYEBWD000@04@05003oooooool0000Mool00`00ooooo`0mool003coo`H0000<[Mf]oJgM[Of]
gJgm[Mf]oJgM[Of]gJgm0P0000V]g:gl[Mb]o:gL[Ob]g:gl[M`00P0003BUo:GL002UW:FlYIbU_:FL
YKbUW:FlYIbU_:FLYK`00:EkYE^UNjEKYG^UFjEkYE^UNjEKYG^UF`00WA^M>idKWC^M6idkWA^M>idK
WC^M6`00S9Z<^XbJS;Z<VXbjS9Z<^XbJS;X000]lFP0<001[nF?IJoUSfF_iHmU[nF?IJoUSf@0024/I
00@002ZI:YTZV@8000I:E@0300004@0A00804@04003ooooo000Mool2000nool003[oo`D0000G[Of]
oP00[Oj]oJgn[Of]oZgm[Oj]oJgn[Of]oZgm[Oj]o@00[Ob]oJgl[Of]o0030000HZGlYOfUo:GmYO`0
0:FLYKfUW:FmYIbU_JFLYKfUW:FmYIbU_@00YG^UFjEkYE^UNjEKYG^UFjEkYE^UNjEK002M6idkWA^M
>idKWC^M6idkWA^M>`00S;Z<VXbjS9Z<^XbJS;Z<VXbjS9Z<^P00O7YlFWajO5YlNWaJO7YlFWajO5X0
06_IJoU[fF_iJmU[nF_IJoU[fF_i001;>D/IBcU;6D/iBaU;>D/IBcT002Zi:YTZ^BZI001:EDYeBUE:
MDYE000501401000ooooo`007Ooo00<00?ooool0??oo000Kool2000Iool600006:gM[Of]gJgm[Mf]
o@00[Of]gJgm[Mf]oJgM[Of]gJgm[Mf]oJgM[Of]g@00[Mb]o080000YYMbUo:GLYObUg:GlYMbUo000
YKbUW:FlYIbU_:FLYKbUW:FlYIbU_:FLYK`00:EkYE^UNjEKYG^UFjEkYE^UNjEKYG/009dkWA^M>idK
WC^M6`0F0006O5X02`00HmU[nF?IJoUSfF_iHmU[nF?I00002D/I00<002ZI:YT00bZI0P000dYE00<0
000A01400`0A00@00?ooool001koo`03003ooooo03_oo`006_oo00@00?ooool001Ooo`D0000G[Oj]
oJgn[Of]oZgm[Oj]oJgn002]oZgm[Oj]oJgn[Of]oZgm[Oj]oJgn[Of]oP0300008jGmYObUoJGlYOfU
o:GmYObUoJGlYOd00:FmYIbU_JFLYKfUW:FmYIbU_JFLYKfUW000YE^UNjEKYG^UFjEkYE^UNjEKYG/0
200001J<fhckS=^<nhcKS?/008BkQ9^4^hBKQ;^4VhBkQ9^4^hBK001dFgAkM5]dN`P0000JJmU[nF_I
JoU[fF_iJmU[nF_I001;6D/iBaU;>D/IBcU;6D/iBaT002ZI:[TZVBZi:YTZ^@800003BUD0000A00D0
4@03003oo`0001koo`03003ooooo03_oo`006_oo00@00?ooool001Coo`D0000G[Of]gJgm[Mf]oJgM
[Of]gJgm[Mf]oJgM[Od00:gm[Mf]oJgM[Of]gJgm[Mf]o@0300008:gl[M`00:GLYObUg:GlYMbUo:GL
YObUg:GlYMbUo000YKbUW:FlYIbU_:FLYKbUW:FlYIbU_:FL002UFjEkYE/600006YDkUA^E>`00S?^<
fhckS=^<nhcKS?^<fhckS=/008BKQ;^4VhBkQ9^4^hBKQ;^4VhBk000:M5/00`00Hm/0000300001V_i
HmU[nF?IJoT000U;6@03000ZVBZI00HZV@<000D04@03003oo`0001ooo`8003_oo`006_oo00@00?oo
ool0017oo`D0000H[Oj]o@00[Of]oZgm[Oj]oJgn[Of]oZgm[Oj]oJgn[Of]oP00[Oj]oJgn[Of]oZgm
0P0001n]oJgl[Of]o:gm[O`00:GlYOfUo:GmYObUoJGlYOfUo:GmYObUo@00YKfUW:FmYIbU_JFLYKfU
W:FmYIbU_@040000<9DKUC^E6iDkUA^E>iDKUC^E6`00S=^<nhcKS?^<fhckS=^<nhcKS?^<f`00Q9^4
^hBKQ;^4VhBkQ9^4^hBKQ;/007AkM5]dNgAKM7]dFgAkM5]dNgAK001Sff?kHm]Sn`@0000GJmU[n@00
BcU;6D/iBaU;>D/IBcU;6D/i000Z^BZI:[TZVBZi:YTZ^BZI:[T000060142000Pool00`00ooooo`0i
ool001[oo`04003ooooo000?ool500005jgM[Of]gJgm[Md00:gM[Of]gJgm[Mf]oJgM[Of]gJgm[Mf]
oJgM[Od00:gm[Md00`0001f]g:gl[Mb]o:gL[Ob]g:gl[M`00:GLYObUg:GlYMbUo:GLYObUg:GlYM`0
0:FLYKbUW:FlYIbU_:FL00@0000UWGbMG000UA^E>iDKUC^E6iDkUA^E>iDKUC^E6`00S=^<nhcKS?^<
fhckS=^<nhcKS?/008BkQ9^4^hBKQ;^4VhBkQ9^4^hBK00002WAK00T006?kHm]Snf?KHo]Sff?kHm/0
100024/I00<002ZI:YT01bZI0`00100A0P008?oo00<00?ooool0>Ooo000Jool01000ooooo`003?oo
1@0001N]oJgn[Of]oZgm[Oj]oJgn[Od00:gm[Oj]oJgn[Of]oZgm[Oj]oJgn[Of]oZgm00<0000L[Ob]
oJgl[Of]o:gm[Ob]oJgl[Of]o:gm002UoJGlYOfUo:GmYObUoJGlYOfUo:GmYO`00:FLYKd40000@9eL
WGfMG9emWEbMO@00UC^E6iDkUA^E>iDKUC^E6iDkUA^E>`00S?^<fhckS=^<nhcKS?^<fhckS=^<n`00
Q;^4VhBkQ9^4^hBKQ;^4VhBkQ9/007AKM7]dFgAkM5]dNgAKM7]dFgAk001Snf?KHo]Sff?kHm]Snf?K
Ho/004^k0P0001A;6D/iBaU;>D/IBcU;6@00:YTZ^BZI:[TZVBZi:YTZ^BZI00026000100A00<00?oo
ool07ooo00<00?ooool0>?oo000Kool2000;ool500003:gm[Mf]oJgM[Of]gJgm[Mf]oJgM[Of]g@80
0009[Of]gJgm[Mf]oJgM[Of]gJgm0080000L[Mb]o000[Ob]g:gl[Mb]o:gL[Ob]g:gl[Mb]o:gL[O`0
0:GlYMbUo:GLYObUg:GlYMbUo:GLYO`30000;YelWEbMO9eLWGbMG9elWEbMO9eLWG`009DkUA^E>iDK
UC^E6iDkUA^E>iDKUC/008ckS=^<nhcKS?^<fhckS=^<nhcK0024VhBkQ9^4^hBKQ;^4VhBkQ9^4^`00
2WAK00h006?KHo]Sff?kHm]Snf?KHo]Sff?k001;^d^K0`0014/I00<002ZI:YT01bZI00@0008H0QP0
00804@<0027oo`03003ooooo03Ooo`009Ooo1@0001N]oZgm002]oJgn[Of]oZgm[Oj]oJgn[Of]oZgm
[Oj]oJgn002]oZgm[Oj]oJgn00<0000J[Of]o:gm[Ob]o@00[Of]o:gm[Ob]oJgl[Of]o:gm[Ob]oJgl
[Od00:GmYObUoJGlYOfUo0@0001<YKfUW000WEbMOIeLWGfMG9emWEbMOIeLWGfMG000UA^E>iDKUC^E
6iDkUA^E>iDKUC^E6`00S=^<nhcKS?^<fhckS=^<nhcKS?^<f`00Q9^4^hBKQ;^4VhBkQ9^4^hBKQ;/0
07AkM5]dNgAKM7]dFgAkM5]dNgAK001Sff?kHm]Snf?KHo]Sff?kHm/004^KBk];Vd^kBi/300003T/I
BcT002Zi:YTZ^BZI:[TZVBZi:YTZ^@000QT3000201400`00ooooo`0Nool2000iool002?oo`D0000G
[Mf]oJgM[Of]g@00[Mf]oJgM[Of]gJgm[Mf]oJgM[Of]gJgm[Mf]o@00[Of]g@0200006Zgl[Mb]o:gL
[Ob]g:gl[Mb]o000[Ob]g:gl[Mb]o:gL[Ob]g:gl[Mb]o:gL[O`00:GlYM`30000=jFLYKbUW:FlYIbU
_:FL002MG9elWEbMO9eLWGbMG9elWEbMO9eL002E6iDkUA^E>iDKUC^E6iDkUA^E>iDK002<fhckS=^<
nhcKS?^<fhckS=^<n`00Q;^4VhBkQ9^4^hBKQ;^4VhBkQ9^4^`0000UdF`0C001Snf?KHo]Sff?kHm]S
nf?KHo]Sf`00Bi];^d^KBk];Vd^kBi/00`0022ZI0`000`8H00@0000A0000027oo`03003ooooo03Ko
o`008Ooo100001N]oJgn[Of]oZgm[Oj]oJgn[Od00:gm[Oj]oJgn[Of]oZgm[Oj]oJgn[Of]oZgm00<0
000I[Ob]oJgl[Of]o:gm[Ob]oJgl[Of]o000[Ob]oJgl[Of]o:gm[Ob]oJgl[Of]o:gm[O`00`0005RU
W:FmYIbU_JFLYKfUW:FmYIbU_@00WGfMG9emWEbMOIeLWGfMG9emWEbMOIeL002E6iDkUA^E>iDKUC^E
6iDkUA^E>`00S?^<fhckS=^<nhcKS?^<fhckS=^<n`00Q;^4VhBkQ9^4^hBKQ;^4VhBkQ9/007AKM7]d
FgAkM5]dNgAKM7]dFgAk001Snf?KHo]Sff?kHm]Snf?KHo/004^kBi];^d^KBk];Vd^kBi];^`<00003
:[TZVBZi00<00007:[TZV@000QP26@8H0QT010008Ooo00<00?ooool0=Ooo000Qool200005Zgm[Mf]
oJgM[Of]gJgm[Mf]oJgM[Of]g@00[Mf]oJgM[Of]gJgm[Mf]oJgM0`0001V]gJgm002]o:gL[Ob]g:gl
[Mb]o:gL[Ob]g:gl[M`00:gL[Ob]g:gl[Mb]o:gL[Ob]g0030000?ZFLYK`00:FlYIbU_:FLYKbUW:Fl
YIbU_:FLYK`009elWEbMO9eLWGbMG9elWEbMO9eLWG`009DkUA^E>iDKUC^E6iDkUA^E>iDKUC/008ck
S=^<nhcKS?^<fhckS=^<nhcK0024VhBkQ9^4^hBKQ;^4VhBkQ9^4^hBK0009M5/05P00Hm]Snf?KHo]S
ff?kHm]Snf?KHo/004^kBi];^d^KBk];Vd^kBi];^d^K10001BZI00<0008H0QP0108H0`008?oo0P00
1ooo0P001?oo00<00?ooool00_oo10000_oo0`006ooo000Jool20005ool200005:gm[Oj]oJgn[Of]
oZgm[Oj]oJgn[Of]oZgm002]oJgn[Of]oZgm[Oh200006Zgm[Oj]oJgn[Of]oP00[Of]o:gm[Ob]oJgl
[Of]o:gm[Ob]oJgl002]o:gm[Ob]oJgl[Od20000<:FLYKfUW:FmYI`00:FLYKfUW:FmYIbU_JFLYKfU
W:FmYIbU_@00WGfMG9emWEbMOIeLWGfMG9emWEbMO@00UC^E6iDkUA^E>iDKUC^E6iDkUA/008cKS?^<
fhckS=^<n`/0000TQ;^4VhBkQ9^4^`00M7]dFgAkM5]dNgAKM7]dFgAkM5/006?KHo]Sff?kHm]Snf?K
Ho]Sf`00Bi];^d^KBk];Vd^kBi];^d^K0P00010cNc=K000002Zi:YTZ^BZI:[T0008I0QP26@8H0QT2
6080023oo`8000Koo`04003ooooo000:ool00`00ooooo`04ool00`00ooooo`0Hool001Woo`04003o
oooo0003ool200004_oo002]gJgm[Mf]oJgM[Of]gJgm[Mf]oJgM[Of]g@00[Mf]o@<0000I[Of]gJgm
[Mf]oJgM[Of]gJgm002]o:gL[Ob]g:gl[Mb]o:gL[Ob]g:gl[M`00:gL[O`00`0002NU_:FLYKbUW:Fl
YIbU_:FL002UW:FlYIbU_:FLYKbUW:FlYIbU_:FLYK`009elWEbMO9eLWGbMG9elWEbMO9eL002E6iDk
UA^E>iDKUC/02`0000^4o8CLQ?b4g8ClQ=`007bKO;]lVgbk00`000AdF`0A001Snf?KHo]Sff?kHm]S
nf?KHo]Sf`00Bi];^d^KBk];V`0300000d^KBk/00003<e/20003:YT00`000QP260050QP2000Pool0
0`00ooooo`04ool01000ooooo`002_oo00<00?ooool01?oo00<00?ooool06?oo000Iool01000oooo
o`000ooo01400?ooooooo`00[Of]oZgm[Oj]oJgn[Of]oZgm[Oj]oJgn00<0000I[Oj]oJgn[Of]oZgm
[Oj]oJgn[Of]oZgm[Oh00:gm[Ob]oJgl[Of]o:gm[Ob]oJgl[Od00`0002:U_JFLYKfUW:FmYIbU_JFL
YKfUW:FmYI`00:FLYKfUW:FmYIbU_JFLYKfUW:FmYI`009eLWGfMG9emWEbMOIeLWGfMG0P0000RUCfE
79DmUAbE?IDL0024g8CmQ=b4oHCLQ?f4g8CmQ=b4o@00O;]lVgbkO9]l^gbKO;]lVgbkO9]l^`00M7]d
FgAkM5/700002f?KHo]Sff?kHm]Snf?KHo/004^kBi/00`0000];Vd^kBi];^d^K000cFc=k<e/cNc=K
0080000::[TZV@000QP26@8H0QT2608I0QP2000Pool00`00ooooo`03ool01000ooooo`002_oo00@0
0?ooooooo`<001_oo`006Ooo00@00?ooool000?oo`03003ooooo00;oo`0:002]gJgm[Mf]oJgM[Of]
gJgm[Md200006:gm[Md00:gM[Of]gJgm[Mf]oJgM[Of]gJgm[Mf]oJgM[Od00:gl[Mb]o:gL[Ob]g0@0
000PYObUg000YIbU_:FLYKbUW:FlYIbU_:FLYKbUW:Fl002U_:FLYKbUW:FlYIbU_:FLYKbUW:FlYI`0
09eLWGbMG0D0000VUEbEO9EL002E79DlUAbE?9DLUCbE79DlUAbE?000Q?b4g8ClQ=b4o8CLQ?b4g8Cl
Q=b4o000O;]lVgbkO9]l^gbKO;]lVgbkO9/000YdF`D00004Ho]Sff?kHm/300002T^KBk];Vd^kBi];
^d^KBk];V`001S=K0`00208H0P008?oo0P000ooo00@00?ooool000[oo`05003oooooool0000Mool0
01Woo`04003ooooo0003ool20004ool01P00[Of]oZgm[Oj]o@<0000G[Of]oZgm[Oj]o@00[Of]oZgm
[Oj]oJgn[Of]oZgm[Oj]oJgn[Of]oP00[Of]o00300008:GlYOfUo:GmYObUoJGl002UW:FmYIbU_JFL
YKfUW:FmYIbU_JFLYKd00:FmYIbU_JFLYKfUW:FmYIbU_JFLYKd40000>YELUGfEG9EmUEbEOIELUGd0
09DmUAbE?IDLUCfE79DmUAbE?IDLUCd008CmQ=b4oHCLQ?f4g8CmQ=b4oHCL001lVgbkO9]l^gbKO;]l
VgbkO9]l^gbK001dFgAkM5]dNgAKM7]dFgAkM5/006@LI3eT76@m100001ESf`00Bi];^d^KBk];Vd^k
Bi];^d^KBk/003=k<e/cNc=K<g/cFc=k<e/00P0000T26@8H0QT2608I0QP26@8H00007ooo0P001?oo
00@00?ooool000Soo`<000?oo`03003ooooo01_oo`006Ooo00@00?ooool000?oo`03003ooooo00Co
o`03002]gJgm0080000G[Mf]oJgM[Of]gJgm[Mf]oJgM002]gJgm[Mf]oJgM[Of]gJgm[Mf]oJgM[Of]
g@0300007jGLYObUg:GlYMbUo:GLYObUg:GlYM`00:FLYKbUW:FlYIbU_:FLYKbUW:FlYIbU_000YKbU
W:FlYIbU_:FL00@0000`WGbMG000UEbEO9ELUGbEG9ElUEbEO9ELUG`009DlUAbE?9DLUCbE79DlUAbE
?9DL0024g8ClQ=b4o8CLQ?b4g8ClQ=b4o8CL001lVgbkO9]l^gbKO;]lVgbkO9]l^`002WAK00<006@L
00000P000f@L100000Y;^d^KBk];Vd^kBi];^d^KBk/000TcF`8000H26080023oo`03003ooooo00;o
o`8000_oo`04003oooooool4000Jool001[oo`8000Coo`8000Koo`80000<[Oj]oJgn[Of]oZgm[Oj]
oJgn[Of]oZgm0P0000V]oZgm[Oj]oJgn[Of]oZgm[Oh00P0001j]o:gm002UoJGlYOfUo:GmYObUoJGl
YOfUo:Gm002U_JFLYKfUW:FmYIbU_JFLYKfUW:FmYI`00:FLYKd40000?IeLWGfMG9emWEbMO@00UGfE
G9EmUEbEOIELUGfEG9EmUEbEO@00UCfE79DmUAbE?IDLUCfE79DmUA`008CLQ?f4g8CmQ=b4oHCLQ?f4
g8Cm001l^gbKO;]lVgbkO9]l^gbKO;]lVgbk001dNgAKM7]dFgAkM5]dNgAK00<00009I1aT?F@LI3eT
76@mI1aT?F@L00@0000BBk];Vd^kBi];^d^K000cFc=k<e/cNc=K<g/cFc=k<e/001/K0P0000D26@8H
0QT2608I0080023oo`03003ooooo033oo`008?oo00<00?ooool01_oo01D00:gM[Of]gJgm[Mf]oJgM
[Of]gJgm[Mf]oJgM[Od00:gm[Mf]oJgM[Od00`0001f]o:gL[Ob]g:gl002Uo:GLYObUg:GlYMbUo:GL
YObUg:Gl002U_:FLYKbUW:FlYIbU_:FLYKbUW:Fl00<0000iWGbMG9elWEbMO9eLWGbMG9elWEbMO000
UGbEG9ElUEbEO9ELUGbEG9ElUE`009DLUCbE79DlUAbE?9DLUCbE79DlUA`008CLQ?b4g8ClQ=b4o8CL
Q?b4g8Cl001l^gbKO;]lVgbkO9]l^gbKO;]lV`0000EdF`<0009dF`03001T76@L00MT7004001D75@L
E1`4000014^KBk];V`002C=K00<000/K6a/00P00108H00<00?ooool07_oo0P00<Ooo000Oool00`00
ooooo`08ool04P00[Of]oZgm[Oj]oJgn[Of]oZgm[Oj]oJgn[Of]oP00[Oj]o@80000L[Of]o:gm[Ob]
oJgl[Of]o:gm002UoJGlYOfUo:GmYObUoJGlYOfUo:Gm002U_JFLYKfUW:FmYI`40000?ZFmYI`009eL
WGfMG9emWEbMOIeLWGfMG9emWEbMO@00UGfEG9EmUEbEOIELUGfEG9EmUE`009DLUCfE79DmUAbE?IDL
UCfE79Dm0024oHCLQ?f4g8CmQ=b4oHCLQ?f4g000O9]l^gbKO;]lVgbkO9]l^gbKO;]lV`00M5/30000
5gAKM7]dFgAkM5/006@LI3eT76@mI1aT?F@LI3eT76@m001D?E@LE3eD75@mE1`0100000hcNc=K<g/c
Fc=k<e/cNc=K<g/001/k6a/K>a/K0P0000@26@8H000001ooo`80037oo`007ooo0P002_oo00h00:gM
[Of]gJgm[Mf]oJgM[Of]gJgm[Mf]oJgM0`0001^]g:gl[Mb]o:gL[Ob]g:gl[Mb]o:gL002Ug:GlYMbU
o:GLYObUg:GlYMbUo:GLYO`00:FlYI`00`0003nUW:FlYIbU_:FLYKbUW000WEbMO9eLWGbMG9elWEbM
O9eLWGbMG000UEbEO9ELUGbEG9ElUEbEO9ELUGbEG000UAbE?9DLUCbE79DlUAbE?9DLUC`008ClQ=b4
o8CLQ?b4g8ClQ=b4o8CL001lVgbkO9]l^gbKO;]lVgbkO9/00`002GAK00<006@LI1`026@L00<005@L
E1`01U@L0`0023=K00H001/K2a/K6`/K6a/200000`8H0000000Pool00`00ooooo`0^ool001ooo`03
003ooooo00[oo`800009[Oj]oJgn[Of]oZgm[Oj]oJgn0080000K[Of]oP00[Of]o:gm[Ob]oJgl[Of]
o:gm[Ob]oJgl002Uo:GmYObUoJGlYOfUo:GmYObUoJGl00<00010YIbU_JFLYKfUW:FmYIbU_JFLYKfU
W000WEbMOIeLWGfMG9emWEbMOIeLWGfMG000UEbEOIELUGfEG9EmUEbEOIELUGfEG000UAbE?IDLUCfE
79DmUAbE?IDL0024g8CmQ=b4oHCLQ?f4g8CmQ=b4o@00O;]lVgbkO9]l^gbKO;/200008WbKO;/007Ak
M5]dNgAKM7]dFgAkM5]dN`00I3eT76@mI1aT?F@LI3eT76@mI1`005@LE3eD75@mE1aD?E@LE3eD75@m
0`0000hcNc=K<g/cFc=k<e/cN`006c/K6a/k6a/K>a/K0`008?oo00<00?ooool0;_oo000Oool2000=
ool01P00[Of]gJgm[Mf]o@<0000I[Of]gJgm[Mf]o@00[Ob]g:gl[Mb]o:gL[Ob]g:gl[Mb]o:gL002U
g:GlYMbUo:GLYO`0100002bUW:Fl002U_:FLYKbUW:FlYIbU_:FLYKbUW:Fl002MO9eLWGbMG9elWEbM
O9eLWGbMG9elWE`009ELUGbEG9ElUEbEO9ELUGbEG9El002E?9DLUCbE79Dl5`0000El^gbKO;]lV`00
00YdF`03001T76@L00QT7003001D75@L00MD7003000kg4?l00<000@cF`09000;6a/K2a/K6`/K6a/;
6a/K0080023oo`8002koo`007ooo00<00?ooool03Ooo00<00:gn[Od00P0001V]oZgm[Oj]oJgn[Of]
oZgm[Oh00:gm[Ob]oJgl[Of]o:gm[Ob]oJgl[Of]o000YObUo@0300009ZFmYIbU_JFLYKfUW:Fm002U
_JFLYKfUW:FmYIbU_JFLYKfUW:Fm002MOIeLWGfMG9emWEbMOIeLWGfMG9em002EOIELUGfEG9EmUE`:
00004HdmSAb=?HdLSCf=7000Q=b4oHCLQ?f4g8CmQ=b4oHCLQ?d00`0000=l_GbL00002`0001mdNgAK
M7]dF`00I1aT?F@LI3eT76@mI1aT?F@LI3d005@mE1aD?E@LE3eD75@mE1aD?E@L0013g4?m@ma3o@03
00002c=k<e/001/K6c/K6a/k6a/K>a/K6c/00P008?oo00<00?ooool0;?oo0006ool20004ool00`00
ooooo`02ool40002ool30005ool00`00ooooo`0>ool200006:gM[Of]gJgm[Mf]oJgM[Of]gJgm[Mf]
o@00[Ob]g:gl[Mb]o:gL[Ob]g:gl[Mb]o0<0000QYKbUW:FlYIbU_:FLYKbUW:FlYIbU_000YKbUW:Fl
YIbU_:FLYKbUW:FlYIbU_000WGbMG9elWEbMO9eLWGbMG9el00P0000HUAbE?9DLUCbE79Dl002=?8dL
SCb=78dlSAb=?8dLSCb=7000Q=b4o8CLQ?b4g8Cl1000011lW7blO9al_7bLO;alW7blO9al_7bL001T
W6blI9a/_0P000QT7003001D75@L00MD70080013o3_L@o`kg4?l>ma3o0<0000:6a/;6a/K2a/K6`/K
6a/;6a/K000Pool00`00ooooo`0/ool000Goo`04003ooooo0008ool00`00ooooo`06ool01000oooo
oooo0P004Ooo01D00:gn[Of]oZgm[Oj]oJgn[Of]oZgm[Oj]oJgn002]oJgl[Of]o:gm[O`0100001nU
oJGl002UW:FmYIbU_JFLYKfUW:FmYIbU_JFL002UW:FmYIbU_JFLYKfUW:FmYIbU_JFLYKd009emWEbM
O@0500007IemWEbMO@00UCfE79DmUAbE?IDLUCfE79DmUA`008dLSCf=78dmSAb=?HdLSCf=78dm0024
oHCLQ?d00`0001b4oHCLQ?f4g000O9al_GbLO;elW7bmO9al_GbLO;d006bmK9a/_FbLK;e/W6bmK9a/
_FbL001TG0@0000HI3eT76@mI1aT?@00E3eD75@mE1aD?E@LE3eD75@m0013oD?L@oe3g4?m@ma3oD?L
0`0000TK6a/k6a/K>a/K6c/K6a/k00008?oo00<00?ooool0:ooo0005ool01000ooooo`002Ooo00<0
0?ooool01Ooo00D00?ooooooo`0001?oo`0A002]oJgM[Of]gJgm[Mf]oJgM[Of]gJgm[Mf]o@00[Ob]
g00300007jGLYObUg:GlYMbUo:GL002UW:FlYIbU_:FLYKbUW:FlYIbU_:FL002UW:FlYIbU_:FLYKbU
W:FlYIbU_:FL00@0000OWGbMG9elWEbMO9eLWGbMG000UAbE?9DLUCbE79DlUAbE?9DLUCbE7000SAb=
?8dLSCb=78dlSAb=?8dLSC`00`0001j4o8CLQ?b4g8ClQ=b4o8CL001lW7blO9al_7bLO;alW7blO9al
_000K;aTW6blI9a/_6BLK;aTW6bl0005I5`400000f@L001D7009E1`02P00@o`kg4?l>ma3o3_L@o`k
g4?l100000L;6a/K2a/K6`/K6a/0000Oool2000/ool000Goo`04003ooooo000:ool01000oooooooo
0`001?oo00<00?ooool04_oo00d00:gn[Of]oZgm[Oj]oJgn[Of]oZgm[Oj]o@0300007ZGlYOfUo:Gm
YObUoJGlYOfUo:GmYO`00:FLYKfUW:FmYIbU_JFLYKfUW:FmYI`00:FLYKfUW:FmYIbU_@@0000PWIbM
_@00WGfMG9emWEbMOIeLWGfMG9emWE`009DLUCfE79DmUAbE?IDLUCfE79DmUA`008dLSCf=78dmSAb=
?@<0000ZSCd008CmQ=b4oHCLQ?f4g8CmQ=b4o@00O;elW7bmO9al_GbLO;elW7bmO9al_@00K;e/W6bm
K9a/_FbLK;e/W6bm001TOFALI7eTG6AmI5aTOFAL100001ID?E@LE3eD75@mE1aD?E@L0013g4?m@ma3
oD?L@oe3g4?m@m`003?L<odcg08000046c/K6a/k6a/2000Oool00`00ooooo`0Zool000Goo`04003o
oooo000;ool01000ooooo`001_oo0P005?oo00X00:gm[Mf]oJgM[Of]gJgm[Mf]o@80000NYMfUo@00
YObUg:GlYMbUo:GLYObUg:GlYMbUo:GL002UW:FlYIbU_:FLYKbUW:FlYIbU_:FL002UW:Fl0`00026M
_9fLWKbMW9flWI`009eLWGbMG9elWEbMO9eLWGbMG9elWE`009DLUCbE79DlUAbE?9DLUCbE79Dl002=
?8dLSC`00`0002F=?8dLSCb=78dl0024o8CLQ?b4g8ClQ=b4o8CLQ?`007blO9al_7bLO;alW7blO9al
_7bL001TW6blI9a/_6BLK;aTW6blI9`0000;I5`50005E1`03`00>ma3o3_L@o`kg4?l>ma3o3_L000c
g3?l<m`co00300000a/K2a/0000Pool00`00ooooo`0Yool000Goo`04003ooooo0008ool01000oooo
o`000_oo00<00?ooool01?oo00<00?ooool05?oo00H00:gn[Of]oZgm[Oh300007:GnYOfUoZGmYOh0
0:GmYObUoJGlYOfUo:GmYObUoJGlYOfUo000YIbU_JFLYKfUW:FmYIbU_JFL1000026M_IfLWKfMW9fm
WIbM_IfLWKfMW000WEbMOIeLWGfMG9emWEbMOIeLWGd009DmUAbE?IDLUCfE79DmUAbE?IDLUCd00`00
03R=?HdLSCf=78dmSAb=?HdL0024g8CmQ=b4oHCLQ?f4g8CmQ=b4o@00O;elW7bmO9al_GbLO;elW7bm
O9`006bLK;e/W6bmK9a/_FbLK;e/W000I5aTOFALI7eTG6AmI5aTOFALI7d005amG5aLOEaL100001=D
?@00@oe3g4?m@ma3oD?L@oe3g4?m@m`003?L<odcg3?m<m`co@04000Pool00`00ooooo`05ool20004
ool00`00ooooo`02ool4000Dool000Koo`8000[oo`8000?oo`@000?oo`03003ooooo01Goo`03002]
oJgM0080000JYOfUgJGmYMfUoJGMYOfUgJGm002Uo:GLYObUg:GlYMbUo:GLYObUg:GlYM`00:FLYKbU
W0D0000RYIbU_:FL002MW9flWIbM_9fLWKbMW9flWIbM_9fL002MG9elWEbMO9eLWGbMG9elWEbMO000
UCbE79DlUAbE?9DLUC`30000;IDl002=?8dLSCb=78dlSAb=?8dLSCb=7000Q=b4o8CLQ?b4g8ClQ=b4
o8CLQ?`007blO9al_7bLO;alW7blO9al_7bL001TW6blI9a/_6BLK;aTW6blI9`0000:I5`00`00G5aL
G005G5`400004S_L@o`kg4?l>ma3o3_L@o`003?l<m`co3?L<o`cg3?l<m`co08001ooo`8000Goo`04
003ooooo0008ool00`00ooooo`0Eool001goo`8001Soo`80000HYOfUoZGmYOjUoJGnYOfUoZGmYOjU
oJGn002UoJGlYOfUo:GmYObUoJGlYOfUo:Gm100002FUW:FmYIbU_JFLYKfUW:FmYI`009fLWKfMW9fm
WIbM_IfLWKfMW9fmWI`009eLWGfMG9emWEbMOIeLWGfMG9em002E?IDLUCfE700200002iDmUAbE?IDL
002=78dmSAb=?HdLSCd02`0002n4oHCLQ?f4g000O9al_GbLO;elW7bmO9al_GbLO;d006bmK9a/_FbL
K;e/W6bmK9a/_@00I7eTG6AmI5aTOFALI7eTG6AmI5`005aLG7eLG5amG5aLOEaLG7eLG5am00@0000@
@ma3oD?L@oe3g4?m000coC?L<odcg3?m<m`coC?L<od2000Oool00`00ooooo`03ool01000ooooo`00
2Ooo00<00?ooool05?oo000Mool00`00ooooo`0Hool05@00YOfUgJGmYMfUoJGMYOfUgJGmYMfUoJGM
YOd00:GlYMbUo:GLYObUg00400009ZGmYMd00:FLYKbUW:FlYIbU_:FLYKbUW:FlYI`009fLWKbMW9fl
WIbM_9fLWKbMW9fl002MO9eLWGbMG9elWEbMO9eLWGbMG000UA`300000iDLUC`0000:00002hdlSAb=
?8dLSCb=7000Q=b4o8CLQ?`04`0000Q/_6BLK;aTW6blI9a/_0002VAL00<005aLG5`01eaL00@004`L
C1a<70@0000>@o`kg4?l000co3?L<o`cg3?l<m`co3?L<o`0023oo`03003ooooo00;oo`04003ooooo
000:ool00`00ooooo`0Cool001goo`8001[oo`0A002UoZGmYOjUoJGnYOfUoZGmYOjUoJGnYOfUoP00
YOfUo00300009:GmYOjUoJGnYOfUoP00YKfUW:FmYIbU_JFLYKfUW:FmYIbU_@00WKfMW9fmWIbM_IfL
WKfMW9fmWIbM_@00WGfMG9emWEbMO@/0000YSCf=78dmSAb=?HdL002=78dmSAb=?HdLSCf=78dmSAb=
?@00Q?f4g8CmQ=b4oHCLQ?f4g8CmQ=`007cLO?elg7cmO=aloGcLO?elg7cm001/_@0600007VbL001T
G6AmI5aTOFALI7eTG6AmI5aTO@00G7eLG5amG5aLOEaLG7eLG5amG5`004`LC3e<74`mC1a<?@@0000;
<m`coC?L<odcg3?m<m`coC?L<od0000Oool20003ool01000ooooo`002ooo00<00?ooool04_oo000M
ool00`00ooooo`0Jool200002jGMYOfUgJGmYMfUoJGMYOfUgJGmYMd00`00022UgJGmYMfUoJGMYOfU
gJGmYMfUo@00YKbUW:FlYIbU_:FLYKbUW:FlYIbU_000WKbMW9flWIbM_9fLWKbMW9fl2P0003NEG9El
UE`008dLSCb=78dlSAb=?8dLSCb=78dl002=?8dLSCb=78dlSAb=?8dLSCb=78dl0024o8CLQ?b4g8Cl
Q=b4o8CLQ?`007clO=alo7cLO?alg7clO=alo7cL001TW6blI9a/_6BLK;aTW0050008I5`00`00G5aL
G008G5`00`00C1a<7006C1`3000023?l<m`co3?L<o`cg3?l<m`2000Mool00`00ool00003ool01000
ooooo`002?oo00@00?ooool001Coo`007Ooo0P007Ooo00L00:GmYOjUoJGnYOfUoP0400007ZGmYOh0
0:GnYOfUoZGmYOjUoJGnYOfUoZGmYOh00:FmYIbU_JFLYKfUW:FmYIbU_JFLYKd009fmWIbM_@D00003
WGfMG9em00@0000oUEbEOIELUGfEG9EmUE`008dLSCf=78dmSAb=?HdLSCf=78dm002=?HdLSCf=78dm
SAb=?HdLSCf=78dm0024oHCLQ?f4g8CmQ=b4oHCLQ?d007cmO=aloGcLO?elg7cmO=aloGcL001/W6bm
K9a/_FbLK;e/W6bmK9`006BL00H0000HI7eTG000G5aLOEaLG7eLG5amG5aLOEaLG7d004`mC1a<?D`L
C3e<74`mC1a<?D`L1@0000Dcg3?m<m`coC?L008001ooo`04003oooooool2000:ool2000Eool001go
o`03003ooooo01goo`03002UgJGm00<0000NYOfUgJGmYMfUoJGMYOd00:GmYMfUoJGMYOfUgJGmYMfU
oJGMYOd00:FlYIbU_:FLYKbUW:FlYIbU_:FL100000JMO9eLWGbMG9elWE`30000B9ELUGbEG9ElUEbE
O9ELUGbEG9ElUE`008dLSCb=78dlSAb=?8dLSCb=78dl002=?8dLSCb=78dlSAb=?8dLSCb=7000Q=b4
o8CLQ?b4g8ClQ=b4o8CLQ?`007clO=alo7cLO?alg7clO=alo7cL001TW6blI9a/_6BLK;aTW6bl001T
_6BLI;aTW6BlI9aT_0H000QLG003001<74`L00M<700500147C`MA1dl7@03000013?L<o`cg0007ooo
00<00?ooool09?oo000:ool20004ool00`00ooooo`02ool30005ool00`00ooooo`0Nool200007JGn
YOfUoZGmYOjUoJGnYOfUoZGmYOh00:GnYOfUoZGmYOjUoJGnYOfUoZGm002UW:FmYIbU_JFLYKd01000
00NMWIfn002MOIeLWGfMG0030000DIeLWGfMG000UEbEOIELUGfEG9EmUEbEOIELUGd008dmSAb=?HdL
SCf=78dmSAb=?HdLSCd008dmSAb=?HdLSCf=78dmSAb=?HdL0024g8CmQ=b4oHCLQ?f4g8CmQ=b4o@00
O?elg7cmO=aloGcLO?elg7cm001/_FbLK;e/W6bmK9a/_FbLK;d006BmI9aT_FBLI;eTW6BmI9aT_FBL
001LG@0400005UamG5aLOEaLG7d004`mC1a<?D`LC3e<74`mC1a<?@00A3i47D@nA1e4?T@M1@007_oo
0P009Ooo0009ool01000ooooo`002ooo00@00?ooooooo`80027oo`0K002UgJGmYMfUoJGMYOfUgJGm
YMfUoJGM002UgJGmYMfUoJGMYOfUgJGmYMfUoJGM002UW:Fl00<00008WKfMWIfmWIfM_IfM002MG0<0
001CWEbMO9eLWGbMG9elWE`009ELUGbEG9ElUEbEO9ELUGbEG9El002=?8dLSCb=78dlSAb=?8dLSCb=
7000SAb=?8dLSCb=78dlSAb=?8dLSCb=7000Q=b4o8CLQ?b4g8ClQ=b4o8CL001lg7clO=alo7cLO?al
g7clO=alo000K;aTW6blI9a/_6BLK;aTW6bl001T_6BLI;aTW6BlI9aT_6BLI;`00005G5d400000eaL
001<7009C1`02P00A1dl7D@M?1e47C`MA1dl7D@M0P007_oo00<00?ooool08ooo0009ool01000oooo
o`002ooo00D00?ooooooo`0002?oo`0F002UoJGnYOfUoZGmYOjUoJGnYOfUoZGm002UoJGnYOfUoZGm
YOjUoJGnYOd4000029fnWIfM_YfMWKjMWIfnWId30000GieLWGfMG9emWEbMOIeLWGfMG9emWE`009EL
UGfEG9EmUEbEOIELUGfEG9Em002=?HdLSCf=78dmSAb=?HdLSCf=7000SAb=?HdLSCf=78dmSAb=?HdL
SCd008CmQ=b4oHCLQ?f4g8CmQ=b4oHCL001lg7cmO=aloGcLO?elg7cmO=alo@00K;e/W6bmK9a/_FbL
K;e/W000I9aT_FBLI;eTW6BmI9aT_FBLI;d005anG5eLOUaMG7iLGEanG5d01@00019<74`mC1a<?D`L
C3e<74`m0014?T@MA3i47D@nA1e4?T@MA3h2000Nool00`00ooooo`0Rool000Woo`04003ooooo0008
ool30004ool00`00ooooo`0Rool200003ZGmYMfUoJGMYOfUgJGmYMfUoJGM002UgJGmYMd500002YfM
WKfMW@00WIfM_IfMWKfMWIfm0P00022MWIfmWId009eLWGbMG9elWEbMO9eLWGbMG9el002EO9ELUGbE
G9ElUEbEO9ELUGbEG9El002=?8dLSCb=78dl8@0001Ylo7cLO?alg000I9a/_6BLK;aTW6blI9a/_6BL
001TW6BlI9aT_6BLI;aTW6BlI9aT_0002UaM00<005AM00000`0014`L00`003`MA1dl7D@M?1e47C`M
A1dl7D@M000Oool2000Rool000Woo`04003ooooo0008ool00`00ooooo`04ool2000Uool02@00YOjU
oJGnYOfUoZGmYOjUo@05000039fMWKjMWIfnWIfM_YfMWKjMW@00WIfM_P<0000HWKjMWIfnWIfM_YfM
002MG9emWEbMOIeLWGfMG9emWEbMO@00UGfEG9EmUEbEOIEL2P00026=?XdMSCj=7HdnSAd008DLQCf5
78DmQAb5?HDLQCf578Dm001loWcMO?ilgGcnO=eloWcMO?ilg@00O=eloWcMO?h02000029/W6bmK9a/
_FbLK;e/W000I9aT_FBLI;eTW6BmI9aT_FBL001LGEanG5eLOUaMG7iLGEanG5eLOP00E7iDGEAnE5eD
OP@0000;C1`004@MA3i47D@nA1e4?T@MA3i47@02000Nool00`00ooooo`0Qool000Woo`04003ooooo
0008ool00`00ooooo`04ool00`00ooooo`0Uool01000YOfUgJGm100000jMgIgmWMd009fMWKfMWIfm
WIfM_IfMWKfMWIfm0`0001>M_IfMWKfMWIfmWIfM_IfMWKd009elWEbMO9eLWGbMG9elWEbMO0080000
<iEMUGfEGIEmUEfEO@00SCf=7HdmSAf=?HdMSCf=7Hdm0025?8DLQCb578DlQAb5?8DLQCb57000O=el
oGcMO?elgGcmO=eloGcMO?d007cmO=eloGcMO?elgGcmO=eloGcM001dg@0600003Fbl001T_6BLI;aT
W6BlI9aT_6BLI;aTW00000YLG@03001DGEAM00IDG@D00007?1e47C`MA1dl7D@M?1d00P007_oo00<0
0?ooool08?oo000:ool20009ool40003ool00`00ooooo`0Vool300003ignWOfMoYgmWOjMoIgnWOd0
09fMWKjMWIfnWIfM_P0300004IfnWId009fMWKjMWIfnWIfM_YfMWKjMWIfn002MOIeLWGd01@00046E
OYEMUGh009EnUEfEOYEMUGjEGIEnUEfEOYEM002=7HdnSAf=?XdMSCj=7HdnSAf=?P00QCf578DmQAb5
?HDLQCf578DmQA`007cMO?ilgGcnO=eloWcMO?ilgGcn001loWcMO?ilgGcnO=eloWcMO?h007CnM=ed
oWCMM?idgGCn00D0000PI;eTW6BmI9aT_FBLI;eTW000G5eLOUaMG7iLGEanG5eLOUaMG7h005AnE5eD
OUAME7iDGEAnE5eDOUAM001<G@@00004A3i47D@nA1d2000Nool00`00ooooo`0Oool001_oo`8002Wo
o`0>002MoIgMWOfMgIgmWMfMoIgMWOfMg@00WIfM_@<0000?WKfMWIfmWIfM_IfM002MWIfmWIfM_IfM
WKfMWIfm00D0001;UGfEGIEmUEfEOIEMUGfEG@00UEfEOIEMUGfEGIEmUEfEOIEMUGfEG@00SAf=?HdM
SCf=7HdmSAf=?HdMSCd008DlQAb5?8DLQCb578DlQAb5?000O?elgGcmO=eloGcMO?elgGcmO=d007cM
O?elgGcmO=eloGcMO?elgGcm001doGCMM?edgGCmM=edoGCMM?d006bm00H00003I9aT_00000]LG@03
001DGEAM00MDG@03001<GDaM00=<G@@00003?1d00?oo01goo`80023oo`006ooo00<00?ooool0:Ooo
00X009gnWOfMoYgmWOjMoIgnWOfMoP<0000>WKjMWIfnWIfM_YfMWKjMWIfnWId009fMWKjMW@@0001F
UKjEWIFn002EOYEMUGjEGIEnUEfEOYEMUGjEG@00UEfEOYEMUGjEGIEnUEfEOYEMUGjEG@00SAf=?XdM
SCj=7HdnSAf=?XdM002578DmQAb5?HDLQCf578DmQAb5?@00O?ilgGcnO=eloWcMO?ilgGcnO=d007cM
O?ilgGcnO=eloWcMO?ilg@00M=edoWCMM?idgGCnM=edoWCM001/WFbnK9e/_VbMK;i/W@L0000KG5eL
OUaMG7iLGEanG5d005AME7iDGEAnE5eDOUAME7iDGEAn001<OTaMC7i<GDanC5e<OTaM00<001koo`03
003ooooo01koo`006ooo00<00?ooool0:_oo0P0000BMgIgmWMfMo@<0000<WOfMg@00WIfM_IfMWKfM
WIfmWIfM_IfM1@00066EWIFmUIfE_IFMUKfEWIFm002EOIEMUGfEGIEmUEfEOIEMUGfEG@00UEfEOIEM
UGfEGIEmUEfEOIEMUGfEG@00SAf=?HdMSCf=7HdmSAf=?HdM002578DlQAb5?8DLQCb578DlQAb5?000
O?elgGcmO=eloGcMO?elgGcm001loGcMO?elgGcmO=eloGcMO?elg@00M=edoGCMM?edgGCmM=edoGCM
001TWFbmI9e/_FBMK;eTWFbmI9e/_@00I;eTW@060002G5d00`00E5eDG@07E5d00`00C5e<G@08C5d2
000Nool00`00ooooo`06ool20004ool00`00ooooo`02ool40002ool30003ool001_oo`8002goo`@0
000:WOjMoIgnWOfMoYgm002MWIfnWId50000K9fMWKjMW@00UIfE_YFMUKjEWIFnUIfE_YFMUKh009En
UEfEOYEMUGjEGIEnUEfEOYEM002EGIEnUEfEOYEMUGjEGIEnUEfEOP00SCj=7HdnSAf=?XdMSCj=7Hdn
SAd008DLQCf578DmQAb5?HDLQCf57000O=eloWcMO?ilgGcnO=eloWcMO?h007cnO=eloWcMO?ilgGcn
O=eloP00M?idgGCnM=edoWCMM?idgGCnM=d006bMK;i/WFbnK9e/_VbMK;i/W@00I9eT_VBMI;iTWFBn
I9eT_PD0000DE7iDGEAnE5eDOUAME7iDG@00C5e<OTaMC7i<GDanC5e<OTaMC7h001koo`8000Koo`04
003ooooo0008ool00`00ooooo`06ool10001ool1ool001_oo`03003ooooo02[oo`@00005WMfMoIgM
WOfMg@070000>YfMWKfMWIfmWIfM_IfMWKfMW@00UIfE_IFMUKfEWIFmUIfE_IFMUKd009EmUEfEOIEM
UGfEGIEmUEfEO@00UGfEGIEmUEfEOIEMUGfEGIEmUEfEO@00SCf=7HdmSAf=?HdMSCf=7Hdm0025?8DL
QCb578Dl2`00031loGcMO?elg@00O=eloGcMO?elgGcmO=eloGcMO?d007CmM=edoGCMM?edgGCmM=ed
oGCM001TWFbmI9e/_FBMK;eTWFbmI9d006BMI;eTWFBmI9eT_FBMI;eTWFBmI9d50005E5d00`00C5e<
G@08C5d00`00ooooo`0Kool20006ool01000ooooo`002Ooo00<00?ooool01Ooo0@000Ooo0Ooo000K
ool2000Xool30004ool50000;IgmWOjMoIgnWOd009fMWKjMWIfnWIfM_YfMWKjMWIfnWId009FMUKjE
WIFnUIfE_YFMUKjEWIFn002EOYEMUGjEGIEnUEfEOYEMUGh009EnUEfEOYEMUGjEG@0D00002hDnQAf5
?XDMQCj57@00OAem?WdMOCh02`0002YloWcMO?ilg@00M=edoWCMM?idgGCnM=edoWCMM?h006bnK9e/
_VbMK;i/WFbnK9e/_VbM001TWFBnI9eT_VBMI;iTWFBnI9eT_P00G;iLWEbnG9d4000035An001<OTaM
C7i<GDanC5e<OTaMC7i<G@8001koo`03003ooooo00?oo`04003ooooo000:ool01000oooooooo0`00
0ooo000Jool2000Wool20008ool09`00WMfMoIgMWOfMgIgmWMfMoIgM002MWIfmWIfM_IfMWKfMWIfm
WIfM_IfM002EWIFmUIfE_IFMUKfEWIFmUIfE_@00UGfEGIEmUEfEO@0:0000:XeMSGf=GHemSEf=O@00
SGf=GHemSEf=OHeMSGf=GHem0025?HDMQCf57HDmQAf5?HDMQCd007dmOAem?GdMOCem7GdmOAem?GdM
001lgGcmO=elo@/0000SM?edgGCmM=edo@00K;eTWFbmI9e/_FBMK;eTWFbmI9d006BMI;eTWFBmI9eT
_FBMI;eTWFBm001L_EbMG;eLWEbmG9eL_@050008C5d2000Mool00`00ooooo`03ool01000ooooo`00
2ooo00@00?ooool000Goo`000_oo0P001?oo00<00?ooool00ooo00<00?ooool00_oo0`001?oo00<0
0?ooool08ooo0`002ooo01`009gmWOjMoIgnWOfMoYgmWOjMo@00WIfM_YfMWKjMWIfnWIfM_YfMWKjM
W@00UIfE_YFMUKjEW@X0000oUGjEGIEnUEfEOP00SGj=GHenSEf=OXeMSGj=GHenSEd008eMSGj=GHen
SEf=OXeMSGj=GHen0025?XDMQCj57HDnQAf5?XDMQCh007dnOAem?WdMOCim7GdnOAem?P00O?ilgGcn
O=eloWcMO?ilgGcnO=d007CMM?idgGCn00T0000OK;i/WFbnK9e/_VbMK;h006BnI9eT_VBMI;iTWFBn
I9eT_VBM001LWEbnG9eL_UbMG;iLWEbnG9eL_P00E;h0100000I<GDanC5e<OTaM000Mool20004ool0
1000ooooo`002?oo00@00?ooool000;oo`03003ooooo00?oo`0000Goo`00ooooo`0000Woo`03003o
oooo00Goo`04003oooooool2000Qool3000?ool05000WMfMoIgMWOfMgIgmWMfMoIgM002MWIfmWIfM
_IfMWKfMWIfmWId70000DYFMUKfEWIFmUIfE_@00UGfEGIEmUEfEOIEMUGfEGIEm002=OHeMSGf=GHem
SEf=OHeMSGf=G@00SEf=OHeMSGf=GHemSEf=OHeMSGd008DmQAf5?HDMQCf57HDmQAf5?@00OCem7Gdm
OAem?GdMOCem7Gdm001loGcMO?elgGcmO=eloGcMO?d007CmM=edoGCMM?edgGCmM=edoGCMM?d006cm
1P0001eTWFbm001T_FBMI;eTWFBmI9eT_FBMI;eTW@00G9eL_EbMG;eLWEbmG9eL_EbMG;d005BmE9eD
_EBM00L001Soo`@00003ool00?oo00Coo`8000[oo`8000?oo`@000;oo`0000Goo`00ooooo`0000[o
o`03003ooooo00Coo`05003oooooool0000Oool3000Cool03P00WOfMoYgmWOjMoIgnWOfMoYgm002M
WIfnWId50000GiFMUKjEW@00UIfE_YFMUKjEWIFnUIfE_YFMUKh009EnUEfEOYEMUGjEGIEnUEfEOP00
SGj=GHenSEf=OXeMSGj=GHenSEd008eMSGj=GHenSEf=OXeMSGj=G@00QAf5?XDMQCj57HDnQAf5?XDM
QCh007dnOAem?WdMOCim7GdnOAem?P00O?ilgGcnO=eloWcMO?ilgGcn001doWCMM?idgGCnM=edoWCM
M?idg@00K=e/oVcMK?i/gFcnK=d01P0001aT_VBMI;iTWFBnI9eT_VBM001LWEbnG9eL_UbMG;iLWEbn
G9eL_P00E;iDWEBnE9eD_UBME;iDW@<001Coo`<000Goo`03003ooooo01[oo`0000Goo`00ooooo`00
00[oo`04003oooooool30004ool00`00ooooo`0Jool3000Gool01P00WMfMoIgMWOfMg@L0001ZUIfE
_IFMUKfEWIFmUIfE_IFM002EWIFmUIfE_IFMUKfEWIFmUIfE_@00UGfEGIEmUEfEOIEMUGfEG@00SEf=
OHeMSGf=GHemSEf=OHeMSGf=G@00SEf=OHeMSGf=GHemSEf=OHeM00257HDmQAf5?HDMQCf57HDmQAd0
07dMOCem7GdmOAem?GdMOCem7Gdm001loGcMO?elgGcmO=eloGcMO?d007CmM=edoGCMM?edgGCmM=ed
oGCM001TgFcmI=e/oFCMK?eTgFcmI=e/o@00I?d6000066BMI;d005bmG9eL_EbMG;eLWEbmG9eL_EbM
001DWEBmE9eD_EBME;eDWEBmE9eD_@80013oo`<000Soo`03003ooooo01[oo`0000Goo`00ooooo`00
00_oo`04003ooooo0006ool2000Hool3000Kool50000MiGmUOjEoIGnUOd009FMUKjEWIFnUIfE_YFM
UKjEWIFnUId009FMUKjEWIFnUIfE_YFMUKjEW@00UEfEOYEMUGjEGIEnUEfEOYEM002=GHenSEf=OXeM
SGj=GHenSEf=OP00SGj=GHenSEf=OXeMSGj=GHenSEd008DMQCj57HDnQAf5?XDMQCj57@00OAem?WdM
OCim7GdnOAem?WdM001lgGcnO=eloWcMO?ilgGcnO=eloP00M?idgGCnM=edoWCMM?idgGCn001/oVcM
K?i/gFcnK=e/oVcMK?i/g@00I=eToVCMI?iTgFCnI=d01`0001=LWEbnG9eL_UbMG;iLW@00E9eD_UBM
E;iDWEBnE9eD_UBME;h0000<ool4000<ool00`00ooooo`0Iool00005ool00?ooool00008ool01000
ooooo`000_oo00<00?ooool00ooo00<00?ooool05Ooo0`007ooo030009GMUOfEgIGmUMfEoIGMUOfE
g@00UIfE_IFMUKfEWIFmUIfE_IFMUKd009FmUIfE_IFMUKfEWIFmUIfE_IFM002EGIEmUEfEOIEMUGfE
GIEmUEd008eMSGf=GHemSEdP0000<WdmOAem?GdM001lgGcmO=eloGcMO?elgGcmO=d007CMM?edgGCm
M=edoGCMM?edgGCm001/oFCMK?eTgFcmI=e/oFCMK?eTg@00I=eToFCMI?eTgFCmI=eToFCMI?d005bm
G9d6000035bmG9d005BME;eDWEBmE9eD_EBME;eDW@8000Soo`<0013oo`03003ooooo01Woo`000_oo
0P002Ooo10000_oo10000_oo00<00?ooool04_oo0`008ooo02H009GmUOjEoIGnUOfEoYGmUOjEo@00
UIfE_YFMUKjEWIFnUIfE_YFMUKh009FnUIfE_YFMUKjEWIFnUIfE_YFM002EGIEnUEfEOYEM2@00022=
GHenSEf=OXeMSGh008EnQEf5OXEMQGj5GHEnQEf5OXEM00257HDnQAf5?XDMQCj57HDnQAd007dMOCim
7Gdn2`0002eloWcMO?ilg@00M=edoWCMM?idgGCnM=edoWCMM?h006cnK=e/oVcMK?i/gFcnK=e/oVcM
001TgFCnI=eToVCMI?iTgFCnI=d005bMG;iLWEbnG9eL_UbMG;h01P0000MDWEBnE9eD_UBME;iDW@02
0004ool3000Cool00`00ooooo`0Iool001Woo`80013oo`<002Ooo`0K002EgIGmUMfEoIGMUOfEgIGm
UMd009FMUKfEWIFmUIfE_IFMUKfEWIFm002E_IFMUKfEWIFm00X0000dSEf=OHeMSGf=G@00SEf=OHeM
SGf=GHemSEf=OHeM0025GHEmQEf5OHEMQGf5GHEmQEf5O@00QCf57HDmQAf5?HDMQCf57HDm001m?GdM
OCem7GdmOAem?GdMOCem7@00MAee?GDMMCd;0000:7CmM=edoGCM001TgFcmI=e/oFCMK?eTgFcmI=e/
oFCM001TgFCmI=eToFCMI?eTgFCmI=d005bMG;eLWEbmG9eL_EbMG;eLWEbmG9d005bM100000AD_EBM
E;eDW@D001Koo`03003ooooo01Woo`006Ooo00<00?ooool03?oo0`00:ooo010009GmUOjEoIGnUOfE
oYGmUOjEo@00UIfE_YFMUKjEW@X00019UKjEWIFnUIfE_YFM002=GHenSEf=OXeMSGj=GHenSEd008eM
SGj=GHenSEf=OXeMSGj=G@00QEf5OXEMQGj5GHEnQEf5OXEMQGh008DnQAf5?XDMQCj57HDnQAf5?P00
OCim7GdnOAem?WdMOCim7GdnOAd007DMMCie7GDnMAee?WDMMCie7@00M=edoWCMM?h02`00025/oVcM
K?i/gFcn001ToVCMI?iTgFCnI=eToVCMI?iTg@00G9eL_UbMG;iLWEbnG9eL_UbMG;h005bnG9eL_UbM
G;h0100000=DW@00ool06?oo00<00?ooool06Ooo000Iool00`00ooooo`0:ool2000_ool01P00UMfE
oIGMUOfEg@T0001NUIfE_IFMUKfEWIFm002E_IFMUKfEWIFmUIfE_IFMUKfEW@00SEf=OHeMSGf=GHem
SEf=OHeM002=GHemSEf=OHeMSGf=GHemSEd008EMQGf5GHEmQEf5OHEMQGf5GHEm0025?HDMQCf57HDm
QAf5?HDMQCd007dmOAem?GdMOCem7GdmOAem?GdM001e7GDmMAee?GDMMCee7GDmMAd007CMM?edgGCm
M=edoGCMM?edg@00I=e/oFCMK?d9000076CmI=eToFCMI?eTgFCmI=d005bMG;eLWEbmG9eL_EbMG;eL
WEbm001L_EbMG;eLWEbmG9eL_EbM0`006?oo00<00?ooool06Ooo000Iool20008ool3000bool50000
L9FNUKnEWYFoUIh009FMUKjEWIFnUIfE_YFMUKjEWIFn002E_YFMUKjEWIFnUIfE_YFMUKh008enSEf=
OXeMSGj=GHenSEf=OP00SGj=GHenSEf=OXeMSGj=GHenSEd008EMQGj5GHEnQEf5OXEMQGj5GHEn0025
?XDMQCj57HDnQAf5?XDMQCh007dnOAem?WdMOCim7GdnOAem?P00MCie7GDnMAee?WDMMCie7GDnMAd0
07CMM?idgGCnM=edoWCMM?idg@00K=e/oVcMK?i/gFcnK=e/oVcMK?h006Cn1P0001QTgFCn001L_UbM
G;iLWEbnG9eL_UbMG;iLW@00G9eL_UbMG;iLWEbnG9eL_UbMG;h2000Gool00`00ooooo`0Iool001So
o`03003ooooo00Goo`<003Koo`1j002EWYFnUIjE_YFNUKjEWYFnUIh009FMUKfEWIFmUIfE_IFMUKfE
WIFm002E_IFMUKfEWIFmUIfE_IFMUKd008emSEf=OHeMSGf=GHemSEf=O@00SGf=GHemSEf=OHeMSGf=
GHem0025OHEMQGf5GHEmQEf5OHEMQGf5G@00QAf5?HDMQCf57HDmQAf5?HDM001m7GdmOAem?GdMOCem
7GdmOAem?@00MCee7GDmMAee?GDMMCee7GDm001doGCMM?edgGCmM=edoGCMM?edg@00I=e/oFCMK?eT
gFcmI=e/oFCM001TgFCmI=eToFCMI?eTg@H0000DG;eLWEbmG9eL_EbMG;eLW@00G9eL_EbMG;eLWEbm
G9eL_EbMG;d001Soo`03003ooooo01Soo`006?oo0`000_oo0`00>_oo03T009FNUKnEWYFoUIjE_iFN
UKnEWP00UIfE_YFMUKjEWIFnUIfE_YFMUKh009FnUIfE_YFMUKjEWIFnUIfE_P00SGj=GHenSEf=OXeM
SGj=GHen002=OXeMSGj=GHenSEf=OXeMSGh008EnQEf5OXEMQGh02`0003^5?XDMQCj57@00OAem?WdM
OCim7GdnOAem?WdMOCh007DnMAee?WDMMCie7GDnMAee?P00M?idgGCnM=edoWCMM?idgGCn001/oVcM
K?i/gFcnK=e/oVcMK?i/g@00I=eToVCMI?iTgFCnI=eToVCMI?h006Cn00@0000?G9eL_UbMG;iLW@00
G9eL_UbMG;iLWEbnG9eL_UbM008001Ooo`03003ooooo01Soo`006?oo00<00?oo00000P00?_oo01/0
09FNUKjEWYFnUIjE_YFNUKjEWP00UIfE_IFMUKfEWIFmUIfE_IFMUKd009FmUIfE_IFMUKd07@0000^5
OHEMQGf5GHEmQEd008DMQCf57HDm01H0000YMAee?GDMMCd007CmM=edoGCMM?edgGCmM=edo@00K?eT
gFcmI=e/oFCMK?eTgFcm001ToFCMI?eTgFCmI=eToFCMI?eTg@00I=eToFCMI?eTg@04000035bm001L
_EbMG;eLWEbmG9eL_EbMG;eLW@8001Koo`03003ooooo01Soo`004?oo10001?oo0P00@_oo010009FN
UKnEWYFoUIjE_iFNUKnEWP00UIfE_YFMUKjEW@X0000nSKj=WHfnSIf=_P00SGj=GHenSEf=OXeMSGj=
GHen002=OXeMSGj=GHenSEf=OXeMSGh008EnQEf5OXEMQGj5GHEnQEf5OXEM00257HDnQAf5?XDMQCj5
7HDnQAd007dMOCim7GdnOAem?WdMOCim7Gdn001e?WDMMCie7@/0000RM=edoWCMM?h006cnK=e/oVcM
K?i/gFcnK=e/oP00I?iTgFCnI=eToVCMI?iTgFCnI=d006CMI?iTgFCnI=eToVCMI?h600001ebMG;iL
WEbnG9eL_UbM008001Goo`03003ooooo01Soo`004_oo00<00?ooool01?oo00<00?ooool0@Ooo00H0
09FNUKjEWYFnUIh90000DhfMSKf=WHfmSIf=_@00SKf=WHfmSIf=_HfMSKf=WHfm002=OHeMSGf=GHem
SEf=OHeMSGd008emSEf=OHeMSGf=GHemSEf=O@00QGf5GHEmQEf5OHEMQGf5GHEmQEd008DMQCf57HDm
QAf5?HDMQCd007dmOAem?GdMOCem7GdmOAem?GdM001e7GDmMAee?GDMMCee7GDmMAee?@00MCee7GDm
MAd02000021/oFCMK?eTgFcmI=e/o@00I?eTgFCmI=eToFCMI?eTgFCmI=d006CMI?eTgFCmI=eToFCM
I?eTgFCm001LoUcN1P0000=L_EbM00005Ooo00<00?ooool06?oo000Bool00`00ooooo`05ool20012
ool50000I8fNSKn=WXfoSIh008fMSKj=WHfnSIf=_XfMSKj=WHfn002=_XfMSKj=WHfnSIf=_XfMSKh0
08enSEf=OXeMSGj=GHenSEf=OP00SGj=GHenSEf=OXeMSGj=GHen0025OXEMQGj5GHEnQEf5OXEMQGh0
08DnQAf5?XDMQCj57HDnQAf5?P00OCim7GdnOAem?WdMOCim7GdnOAd007DMMCie7GDnMAee?WDMMCie
7@00MAee?WDMMCie7GDnMAee?WDMMCh006cn1P00021/g@00I=eToVCMI?iTgFCnI=eToVCMI?iTg@00
I=eToVCMI?iTgFCnI=eToVCMI?h005coG=iLoecNG?mLgUco10005?oo00<00?ooool06?oo000Bool0
0`00ooooo`07ool00`00ooooo`10ool0KP00SIj=_XfNSKj=WXfnSIj=_XfN002=WHfmSIf=_HfMSKf=
WHfmSIf=_@00SKf=WHfmSIf=_HfMSKf=W@00SEf=OHeMSGf=GHemSEf=OHeMSGd008emSEf=OHeMSGf=
GHemSEf=O@00QGf5GHEmQEf5OHEMQGf5GHEm0025?HDMQCf57HDmQAf5?HDMQCd007dmOAem?GdMOCem
7GdmOAem?GdM001e7GDmMAee?GDMMCee7GDmMAd007DMMCee7GDmMAee?GDMMCee7@00I=e/oFCMK?eT
gFcmI=d800006fCmI=eToFCMI?d006CmI=eToFCMI?eTgFCmI=eToFCM001LgUcnG=iLoUcNG?iLgUcn
G=iLoP02000Dool00`00ooooo`0Gool001;oo`03003ooooo00Soo`03003ooooo043oo`1e002=WXfo
SIj=_hfNSKn=WXfoSIh008fMSKj=WHfnSIf=_XfMSKj=WHfn002=_XfMSKj=WHfnSIf=_XfM002=GHen
SEf=OXeMSGj=GHenSEf=OP00SGj=GHenSEf=OXeMSGj=GHen0025OXEMQGj5GHEnQEf5OXEMQGh008Dn
QAf5?XDMQCj57HDnQAf5?P00OCim7GdnOAem?WdMOCim7GdnOAd007DMMCie7GDnMAee?WDMMCie7@00
MAee?WDMMCie7GDnMAee?WDM001/gFcnK=e/oVcMK?i/gFcnK=d006cMK?i/gFcn00X0000CI=eToVCM
I?iTgFCnI=d005cNG?mLgUcoG=iLoecNG?mLgUco00005?oo00<00?ooool05ooo000@ool3000;ool0
0`00ooooo`10ool200008XfnSIj=_XfNSKj=WXfnSIh008fMSKf=WHfmSIf=_HfMSKf=WHfm002=_HfM
SKf=WHfmSIf=_HfM002=GHemSEf=OHeM7P0003b5?HDMQCf57@00OAem?GdMOCem7GdmOAem?GdMOCd0
07DmMAee?GDMMCee7GDmMAee?GDM001e7GDmMAee?GDMMCee7GDmMAd006CMK?eTgFcmI=e/oFCMK?eT
g@00I=e/oFCMK?eTgFcmI=e/oFCMK?d006CnI=h600003VCmI=d005cNG?iLgUcnG=iLoUcNG?iLgUcn
000Cool00`00ooooo`0Gool001;oo`03003ooooo00[oo`03003ooooo047oo`0?002=_hfNSKn=WXfo
SIj=_hfN002=WHfnSIf=_XfM01<0000NSEf=OXeMSGj=GHen0025OXEMQGj5GHEnQEf5OXEMQGh008En
QEf5OXEMQGj5GHEnQEf5OP00OCim7Gdn5P0002ae7GDnMAee?P00MCie7GDnMAee?WDMMCie7GDnMAd0
06cMK?i/gFcnK=e/oVcMK?i/g@00K=e/oVcMK?i/gFcnK=e/oVcM001TgVCoI=iTofCNI?mTgVCo1P00
00MLgUcoG=iLoecNG?mLgP02000Bool00`00ooooo`0Gool0023oo`8004;oo`h00017SIj=_XfNSKj=
WXfn002=_HfMSKf=WHfmSIf=_HfM002=GHemSEf=OHeMSGf=GHemSEd008EMQGf5GHEmQEf5OHEMQGf5
G@00QEf5OHEMQGf5GHEmQEf5OHEM001m7GdmOAem?GdMOCem7GdmOAd007dMOCem7GdmOAem?GdMOCem
7Gdm001e?GDMMCee7@0;00009gDMMCee7GDm001/oFCMK?eTgFcmI=e/oFCMK?d006cmI=e/oFCMK?eT
gFcmI=e/oFCM001TgVCnI=iToVCNI?iTgVCnI=iToVCN001TgP04000015cnG=iLoUcN0P004Ooo00<0
0?ooool05ooo000Rool00`00ooooo`10ool0G`00SKn=WXfoSIj=_hfNSKn=WP00SIj=_hfNSKn=WXfo
SIj=_hfNSKl008fnSIf=_XfMSKj=WHfnSId008eMSGj=GHenSEf=OXeMSGj=G@00QEf5OXEMQGj5GHEn
QEf5OXEM0025GHEnQEf5OXEMQGj5GHEnQEd007dMOCim7GdnOAem?WdMOCim7@00OAem?WdMOCim7Gdn
OAem?WdM001e7GDnMAee?WDMMCie7GDnMAee?P00MCie7GDnMAd0200002=/oVcMK?i/gFcnK=e/oP00
K?i/gFcnK=e/oVcMK?i/gFcnK=d006CNI?mTgVCoI=iTofCNI?mTgVCo001TofCNI?mTgVCo00@00003
G=h00?oo013oo`03003ooooo01Ooo`008ooo00<00?ooool0@?oo06H008fnSIj=_XfNSKj=WXfnSIh0
08fNSKj=WXfnSIj=_XfNSKj=WP00SIf=_HfMSKf=WHfmSIf=_HfM002=GHemSEf=OHeMSGf=GHemSEd0
08EMQGf5GHEmQEf5OHEMQGf5G@00QEf5OHEMQGf5GHEmQEf5OHEM001m7GdmOAem?GdMOCem7GdmOAd0
07dMOCem7GdmOAem?GdMOCem7@00MAee?GDMMCee7GDmMAee?GDM001e7GDmMAee?GDMMCee7GDmMAee
?@00KCd600008FCMK?d006cmI=e/oFCMK?eTgFcmI=e/oFCM001TgVCnI=iToVCNI?iTgVCnI=iToP00
I?iTgVCnI=iToVCNI?iTgP03000@ool00`00ooooo`0Gool002Coo`03003ooooo043oo`09002=_hfN
SKn=WXfoSIj=_hfN0080001PSKn=WXfoSIj=_hfNSKn=WP00SIf=_XfMSKj=WHfnSIf=_XfM002=GHen
SEf=OXeMSGj=GHenSEd008EMQGj5GHEnQEf5OXEMQGj5G@00QEf5OXEMQGj5GHEnQEf5OXEM001m7Gdn
OAem?WdMOCim7GdnOAd007dMOCim7GdnOAem?WdMOCim7@00MAee?WDMMCie7GDnMAee?WDM001e7GDn
MAee?WDMMCie7GDnMAd006dMKCi]7FdnKAe]?VdM2@0001Y/gFcnK=e/oP00I?mTgVCoI=iTofCNI?mT
gVCoI=iTo`00I?mTgVCoI=iTofCNI?mTgVCo0P004?oo00<00?ooool05_oo000Uool20011ool0L`00
SKj=WXfnSIj=_XfNSKj=WXfn002=_XfNSKj=WXfnSIj=_XfN002=WHfmSIf=_HfMSKf=WHfmSId008eM
SGf=GHemSEf=OHeMSGd008EmQEf5OHEMQGf5GHEmQEf5O@00QGf5GHEmQEf5OHEMQGf5GHEm001m?GdM
OCem7GdmOAem?GdMOCem7@00OAem?GdMOCem7GdmOAem?GdM001e7GDmMAee?GDMMCee7GDmMAd007DM
MCee7GDmMAee?GDMMCee7@00IAe]?FDMKCeU7FdmIAe]?FDMKCd006dnIAi]?VDN00T0000CI=iToVCN
I?iTgVCnI=iToP00I?iTgVCnI=iToVCNI?iTgVCn00004?oo00<00?ooool05_oo000Wool00`00oooo
o`0oool01P00SKn=WXfoSIj=_d@0000aOAem?WdMOCh007DnMAee?WDMMCie7GDnMAee?WDM001e7GDn
MAee?WDMMCie7GDnMAd006dMKCi]7FdnKAe]?VdMKCi]7Fdn001]?fdNKCm]7VdoKAi]?fdNKCl006do
KAh01P0000iTofCN001TgVCoI=iTofCNI?mTgVCoI=iTo`003ooo00<00?ooool05_oo000Xool00`00
ooooo`0oool50000A8FnQIj5_XFNQKh008FnQIj5_XFNQKj5WXFnQIh008ENQGj5GXEnQEj5OXENQGj5
GP00QEf5OHEMQGf5GHEmQEf5O@00QGf5GHEmQEf5OHEMQGf5GHEm0025OHEMQGf5GHEmQEf5OHEMQGd0
07emOEemOGeMOGemGGemOEemOGeM001m7GdmOAd;0000;7DMMCee7GDm001e?GDMMCee7GDmMAee?GDM
MCee7@00IAe]?FDMKCeU7FdmIAe]?FDM001U7VdnIAi]?VDNKCiU7VdnIAh006DNKCiU7VdnIAi]?VDN
KCh600001fCNI?iTgVCnI=iToVCN008000koo`03003ooooo01Koo`00:Ooo00<00?ooool0?ooo05<0
08FoQIj5_hFNQKn5WXFoQIj5_`00QKn5WXFoQIj5_hFNQKn5WP00QEj5OhENQGn5GXEoQEj5OhEN0025
GHEnQEf5OXEMQGj5GHEn0025OXEMQGj5GHEnQEf5OXEMQGh008EnQEf5OXEMQGj5GHEnQEf5OP00OGim
GGenOEemOWeMOGimGGen001m?WdMOCim7GdnOAem?WdMOCh007DnMAee?WDM00/0000WMAee?WDMMCh0
06dnKAe]?VdMKCi]7FdnKAe]?VdM001]7VdoKAi]?fdNKCm]7VdoKAh006dNKCm]7VdoKAi]?fdNKCm]
7VdoKAh006DN00H00003I?mTgP0000koo`03003ooooo01Koo`00:_oo0P00@?oo05d008FnQIj5_XFN
QKj5WXFnQIj5_P00QKj5WXFnQIj5_XFNQKj5WP00QEj5OXENQGj5GXEnQEj5OP00QGf5GHEmQEf5OHEM
QGf5GHEm0025OHEMQGf5GHEmQEf5OHEM0025GHEmQEf5OHEMQGf5GHEmQEd007eMOGemGGemOEemOGeM
OGemGGem001m?GdMOCem7GdmOAem?GdMOCd007DmMAee?GDMMCee7GDmMAee?@00MCee7GDmMAd02`00
029U7FdmIAe]?FDM001U7VdnIAi]?VDNKCiU7VdnIAh006DNKCiU7VdnIAi]?VDNKCiU7Vdn001U?VDN
ICiU7VDnIAiU?P@000goo`03003ooooo01Koo`00;?oo00<00?ooool0?_oo0P0006F5WXFoQIj5_hFN
QKn5WXFo0025_hFNQKn5WXFoQIj5_hFN0025GXEoQEj5OhENQGn5GXEo0025OXEMQGj5GHEnQEf5OXEM
QGh008EnQEf5OXEMQGj5GHEnQEd008EMQGj5GHEnQEf5OXEMQGj5G@00OEemOWeMOGimGGenOEemOWeM
OGh007dnOAem?WdMOCim7GdnOAd007DMMCie7GDnMAee?WDMMCie7GDn001e?WDMMCie7GDnMAee?WDM
MCh007DoMAie?gDN00T0000NKAi]?fdNKCm]7VdoKAh006dNKCm]7VdoKAi]?fdNKCm]7Vdo001U?fDN
ICmU7VDoIAiU?fDNICmU7P003?oo00<00?ooool05_oo000]ool00`00ooooo`0oool0KP00QIj5_XFN
QKj5WXFnQIj5_P00QKj5WXFnQIj5_XFNQKj5WP00QEj5OXENQGj5GXEnQEj5OP00QGf5GHEmQEf5OHEM
QGf5GHEm0025OHEMQGf5GHEmQEf5OHEM0025GHEmQEf5OHEMQGf5GHEmQEd007eMOGemGGemOEemOGeM
OGemGGem001m?GdMOCem7GdmOAem?GdM001e7GDmMAee?GDMMCee7GDmMAd007DMMCee7GDmMAee?GDM
MCee7GDm001e?WDNMCie7WDnMAie?WDNMCie7P00IAh600005fdn001]?VDNKCiU7VdnIAi]?VDNKCiU
7Vdn001U?VDNICiU7VDnIAiU?VDNICh00P003?oo00<00?ooool05Ooo000^ool00`00ooooo`0oooln
0000=GenOEemOWeM001m7GdnOAem?WdMOCim7GdnOAd007DMMCie7GDnMAee?WDMMCie7@00MAee?WDM
MCie7GDnMAee?WDM001e7WDoMAie?gDNMCme7WDoMAie?`00KCm]7VdoKAi]?fdNKCl02000015]7Vdo
KAi]?fdN001U7VDoIAiU?fDNICmU7VDoIAiU?`0000coo`03003ooooo01Goo`00;ooo00<00?ooool0
?ooo03d008FNQKj5WXFnQIj5_XFNQKh008FnQIj5_XFNQKj5WXFnQIh008ENQGj5GXEnQEj5OXENQGh0
08EnQEj5OXENQGj5GXEnQEj5OP00QGj5GXEnQEj5OXENQGj5GP00OEemOGeMOGemGGemOEemOGeM001m
GGemOEemO@0E0000:7DmMAee?GDM001e7GDmMAee?GDMMCee7GDmMAd007DNMCie7WDnMAie?WDNMCie
7WDn001]?VDNKCiU7VdnIAi]?VDNKCh006dnIAi]?VDN2P0000QU?VDNICiU7VDnIAiU?P002ooo00<0
0?ooool05Ooo000`ool20010ool0D@00QIj5_hFNQKn5WXFoQIj5_`00QKn5WXFoQIj5_hFNQKn5WP00
QEj5OhENQGn5GXEoQEj5O`00QGn5GXEoQEj5OhENQGn5GXEo0025OhENQGn5GXEoQEj5OhEN001mGGen
OEemOWeMOGimGGenOEd007eMOGimGGenOEemOWeMOGimG@00OAem?WdMOCim7GdnOAem?WdM001e7WDo
MAie?`0;00009gDnMAee?WDM001e7WDoMAie?gDNMCme7WDoMAh006dNKCm]7VdoKAi]?fdNKCm]7Vdo
001]?fdNKCm]7VdoKAi]?fdNKCm]7P00KAi]?`0600000fDN0000000:ool00`00ooooo`0Eool003;o
o`03003ooooo03koo`1K0025WXFnQIj5_XFNQKj5WXFn0025_XFNQKj5WXFnQIj5_XFN0025GXEnQEj5
OXENQGj5GXEn0025OXENQGj5GXEnQEj5OXENQGh008EnQEj5OXENQGj5GXEnQEh007eMOGemGGemOEem
OGeMOGemG@00OEemOGeMOGemGGemOEemOGeM001m7GdmOAem?GdMOCem7GdmOAd007DNMCie7WDnMAie
?WDNMCie7P00MAie?WDNMCh0200002Ee7WDnMAie?WDNMCie7P00IAi]?VDNKCiU7VdnIAi]?VDN001U
7VdnIAi]?VDNKCiU7VdnIAi]?P00KCiU7VdnIAi]?VDNKCiU7P040009ool00`00ooooo`0Eool003?o
o`03003ooooo03koo`1R0025WXFoQIj5_hFNQKn5WXFo0025_hFNQKn5WXFoQIj5_hFN0025GXEoQEj5
OhENQGn5GXEo0025OhENQGn5GXEoQEj5OhENQGl008EoQEj5OhENQGn5GXEoQEh007eMOGimGGenOEem
OWeMOGimG@00OEemOWeMOGimGGenOEemOP00OCim7GdnOAem?WdMOCim7Gdn001e?gDNMCme7WDoMAie
?gDNMCme7P00MAie?gDNMCme7WDoMAie?gDN001e7PH0000RMCl006doKAi]?fdNKCm]7VdoKAi]?fdN
001]7VdoKAi]?fdNKCm]7VdoKAi]?`00KCm]7VdoKAi]?fdNKCm]7VdoKAh20008ool00`00ooooo`0E
ool003Coo`03003ooooo03koobX0000mQGj5GXEnQEh007eMOGemGGemOEemOGeMOGemG@00OEemOGeM
OGemGGemOEemO@00OCem7GdmOAem?GdMOCem7Gdm001e?WDNMCie7WDnMAie?WDNMCh007DnMAie?WDN
MCie7WDnMAie?P00MCie7WDnMAie?WDNMCh0200001aU7VdnIAi]?VDN001U7VdnIAi]?VDNKCiU7Vdn
IAi]?P00KCiU7VdnIAi]?VDNKCiU7VdnIAh000Soo`03003ooooo01Goo`00=Ooo0P00?ooo02T008FN
QKn5WXFoQIj5_hFNQKl008FoQIj5_hFNQKn5WXFoQIh008ENQGn5GXEoQEj5OhENQGl008EoQEj5OhEN
QGn5GXEoQEj5O`00QGn5GXEo01@0000aOEemOWeMOGh007dnOAem?WdMOCim7GdnOAem?P00MCme7WDo
MAie?gDNMCme7WDo001e?gDNMCme7WDoMAie?gDNMCl007DoMAie?gDNMCme7WDoMAie?`00KCm]7Vdo
KAh02@00019]7VdoKAi]?fdNKCm]7Vdo001]?fdNKCm]7VdoKAi]?fdNKCl20008ool00`00ooooo`0D
ool003Ooo`03003ooooo03goo`0l0025WXFnQIj5_XFNQKj5WXFn0025_XFNQKj5WXFnQIj5_XFN0025
GXEnQEj5OXENQGj5GXEn0025OXENQGj5GXEnQEj5OXENQGh008EnQEj5OXENQGj5GXEnQEh007eNOGim
GWenOEimOWeNOGimGP00OEimOWeN5@0002Ee7WDnMAie?P00MCie7WDnMAie?WDNMCie7WDn001e?WDN
MCie7WDnMAie?WDNMCh006dnIAi]?VDNKCiU7VdnIAi]?VDN001U7P0600003FdnIAh006DNKCiU7Vdn
IAi]?VDNKCiU7Vdn008000Ooo`03003ooooo01Coo`00>?oo00<00?ooool0?Ooo050008FNQKn5WXFo
QIj5_hFNQKl008FoQIj5_hFNQKn5WXFoQIh008ENQGn5GXEoQEj5OhENQGl008EoQEj5OhENQGn5GXEo
QEh008ENQGn5GXEoQEj5OhENQGn5GP00OEimOgeNOGmmGWeoOEimO`00OGmmGWeoOEimOgeNOGmmGWeo
001mOgeNOGmmGWeoOEimOgeNOGl007DoMAie?gDN200002=e?gDNMCme7WDoMAie?`00MCme7WDoMAie
?gDNMCme7P00KAi]?fdNKCm]7VdoKAi]?fdNKCm]7P00KAi]?fdNKCm]7Vdo00T00006KCm]7VdoKAi]
?`001ooo00<00?ooool05?oo000iool00`00ooooo`0mool0E`00QIj5_XFNQKj5WXFnQIj5_P00QKj5
WXFnQIj5_XFNQKj5WP00QEj5OXENQGj5GXEnQEj5OP00QGj5GXEnQEj5OXENQGj5GP00QEj5OXENQGj5
GXEnQEj5OXEN001mGWenOEimOWeNOGimGWen001mOWeNOGimGWenOEimOWeNOGh007enOEimOWeNOGim
GWenOEimOP00MCie7WDnMAie?WDNMCie7WDn001e?P0600009WDN001e7WDnMAie?WDNMCie7WDnMAh0
06DNKCiU7VdnIAi]?VDNKCiU7Vdn001]?VDNKCiU7VdnIAi]?VDNKCiU7P00IAi]?VDNKCh70006ool0
0`00ooooo`0Dool003[oo`03003ooooo03gooaL00015QEj5OhENQGl008EoQEj5OhENQGn5GXEoQEh0
08ENQGn5GXEoQEj5OhENQGn5GP00OEimOgeNOGmmGWeoOEimO`00OGmmGWeoOEimOgeNOGmmGP00OEim
OgeNOGmmGWeoOEimOgeN001e7WDoMAie?gDNMCme7WDoMAh007DNMCme7WDoMAie?gDN00P0000TMCme
7WDoMAh006dNKCm]7VdoKAi]?fdNKCm]7Vdo001]?fdNKCm]7VdoKAi]?fdNKCl006doKAi]?fdNKCm]
7VdoKAi]?fdN0P001Ooo00<00?ooool05?oo000kool2000mool00`00ooooo`0DoolM0000<7eNOGim
GP00OEimOWeNOGimGWenOEimOWeN001mGWenOEimOWeNOGimGWenOEh007DNMCie7WDnMAie?WDNMCie
7P00MAie?WDNMCie7WDnMAie?WDN001e7WDnMAie?P/0000JKCiU7VdnIAi]?P00KCiU7VdnIAi]?VDN
KCiU7Vdn001]?VDNKCiU7VdnIAi]?VDNKCiU7P8000Coo`03003ooooo01Coo`00?Ooo00<00?ooool0
>_oo00<00?ooool0<Ooo2P00035mOgeNOGmmGP00OEimOgeNOGmmGWeoOEimOgeN001e7WDoMAie?gDN
MCme7WDoMAh007DNMCme7WDoMAie?gDNMCme7P00MAie?gDNMCme7WDoMAie?gDN001e7WDoMAie?`09
00004fdoKAi]?fdNKCm]7Vdo001]?fdNKCm]7VdoKAi]?fdNKCm]7P0000Goo`03003ooooo01?oo`00
?_oo00<00?ooool0>Ooo00<00?ooool0>ooo500002Ie7WDnMAie?P00MCie7WDnMAie?WDNMCie7WDn
001e?WDNMCie7WDnMAie?WDNMCh007DnMAie?WDNMCie7WDnMAie?WDNMCh006dn1P0000aU7P00IAi]
?VDNKCiU7VdnIAi]?VDNKCh20004ool00`00ooooo`0Cool003ooo`03003ooooo03Soo`03003ooooo
04ooo`/0000QMAie?gDNMCl007DoMAie?gDNMCme7WDoMAie?`00MCme7WDoMAie?gDNMCme7WDoMAh0
06dNKCm]7VdoKAi]?fdN00T00004KAi]?fdNKCl20003ool00`00ooooo`0Cool0043oo`8003Soo`03
003ooooo05[oo`P0000RMCie7WDnMAie?WDNMCh007DnMAie?WDNMCie7WDnMAie?WDN001U7VdnIAi]
?VDNKCiU7VdnIAh006DNKCiU7VdnIAh70002ool00`00ooooo`0Cool004;oo`03003ooooo03Goo`03
003ooooo06;oo`H0000RMAh007DNMCme7WDoMAie?gDNMCme7WDoMAh006dNKCm]7VdoKAi]?fdNKCm]
7P00KAi]?fdNKCm]7VdoKAi]?fdNKCl200000ooo003oo`0Dool004?oo`03003ooooo03Coo`03003o
oooo06Soo`P0000JMCie7WDnMAie?P00KCiU7VdnIAi]?VDNKCiU7VdnIAh006DNKCiU7VdnIAi]?VDN
KCiU7P800003ool00?oo01Coo`00A?oo00<00?ooool0<ooo00<00?ooool0L?oo300000m]7VdoKAi]
?fdN001]7VdoKAi]?fdNKCm]7VdoKAh00`005Ooo0015ool2000cool00`00ooooo`1lool900001fDN
KCiU7VdnIAi]?VDN00<001Coo`00Aooo00<00?ooool0<?oo00<00?ooool0QOoo1P0000A]?fdN0000
01Coo`00B?oo00<00?ooool0;ooo00<00?ooool0Rooo10005?oo0019ool00`00ooooo`0^ool00`00
ooooo`2=ool2000Dool004[oo`03003ooooo02goo`03003ooooo08Woo`@001Koo`00Booo0P00;Ooo
00<00?ooool0QOoo10006_oo001=ool00`00ooooo`0Zool00`00ooooo`21ool4000Nool004koo`03
003ooooo02Woo`03003ooooo07koo`<002;oo`00Cooo00<00?ooool0:?oo00<00?ooool0N_oo1000
9Ooo001@ool2000Xool00`00ooooo`1fool4000Yool005;oo`03003ooooo02Goo`03003ooooo07;o
o`@002goo`00Dooo00<00?ooool09?oo00<00?ooool0Kooo0`00<Ooo001Dool00`00ooooo`0Sool0
0`00ooooo`1[ool4000dool005Goo`8002?oo`03003ooooo06Ooo`@003Soo`00Eooo00<00?ooool0
8?oo00<00?ooool0Hooo1000??oo001Hool00`00ooooo`0Oool00`00ooooo`1Pool30010ool005Wo
o`03003ooooo01koo`03003ooooo05coo`@004?oo`00F_oo00<00?ooool07?oo00<00?ooool0FOoo
1000Aooo001Kool2000Lool00`00ooooo`1Eool4001;ool005goo`03003ooooo01Woo`03003ooooo
05;oo`<004ooo`00G_oo00<00?ooool06?oo00<00?ooool0C_oo1000D_oo001Oool00`00ooooo`0G
ool00`00ooooo`1:ool4001Fool0063oo`8001Ooo`03003ooooo04Koo`@005[oo`00H_oo00<00?oo
ool05?oo00<00?ooool0@ooo0`00G_oo001Sool00`00ooooo`0Cool00`00ooooo`0oool4001Qool0
06Coo`03003ooooo01;oo`03003ooooo03_oo`@006Goo`00IOoo00<00?ooool04Ooo00<00?ooool0
>?oo0`00JOoo001Vool2000Aool00`00ooooo`0dool4001/ool006Soo`03003ooooo00koo`03003o
oooo033oo`@0073oo`00JOoo00<00?ooool03Ooo00<00?ooool0;?oo1000M?oo001Zool00`00oooo
o`0<ool00`00ooooo`0Yool3001hool006_oo`8000coo`03003ooooo02Goo`@007_oo`00KOoo00<0
0?ooool02Ooo00<00?ooool08Ooo1000Oooo001^ool00`00ooooo`08ool00`00ooooo`0Mool40023
ool006ooo`03003ooooo00Ooo`03003ooooo01[oo`<008Ooo`00L?oo0P001ooo00<00?ooool05_oo
1000R_oo001bool00`00ooooo`04ool00`00ooooo`0Bool4002>ool007?oo`03003ooooo00?oo`03
003ooooo00koo`@009;oo`00M?oo00<00?ooool00_oo00<00?ooool02ooo0`00U_oo001eool01@00
oooooooo00002Ooo1000VOoo001fool200000ooo003oo`04ool4002Mool007Soo`800003ool00000
00800:7oo`00NOoo0P00YOoo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00\
\>"],
  ImageRangeCache->{{{74.875, 361.875}, {422.125, 189.562}} -> {-0.38977, \
0.715606, 0.00392196, 0.00392196}},
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " currently uses the numerical method of lines to compute solutions to \
partial differential equations.  The method is restricted to problems that \
can be posed with an initial condition in at least one independent variable.  \
For example, the method cannot solve elliptic PDEs such as Laplace's equation \
because these require boundary values. For the problems it does solve, the \
method of lines is quite general, handling systems of PDEs or nonlinearity \
well, and often quite fast.  Details of the method are given in the advanced \
documentation on ",
  ButtonBox["PDEs",
    ButtonData:>{"PDE.nb", None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{"b:1", "ndsg:0"}],

Cell["\<\
This finds a numerical solution to a generalization of the \
nonlinear sine\[Hyphen]Gordon equation to two spatial dimensions with \
periodic boundary conditions.\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[t, \ x, \ y], \ t, \ t]\  \[Equal] \ 
          D[u[t, \ x, \ y], \ x, \ x]\  + \ D[u[t, \ x, \ y], \ y, \ y]\  - \ 
            Sin[u[t, \ x, \ y]], \ 
        u[0, \ x, \ y]\  \[Equal] \ 
          Exp[\(-\((x\^2 + y\^2)\)\)], \ \(\(Derivative[1, 0, 0]\)[u]\)[0, x, 
            y]\  \[Equal] \ 0, \ 
        u[t, \ \(-5\), \ y]\  \[Equal] \ u[t, \ 5, \ y]\  \[Equal] \ 0, \ 
        u[t, \ x, \ \(-5\)]\  \[Equal] \ u[t, \ x, \ 5]\  \[Equal] \ 0}, 
      u, {t, 0, 3}, {x, \(-5\), 5}, {y, \(-5\), 5}]\)], "Input",
  CellLabel->"In[124]:=",
  CellTags->{"b:1", "ndsg:0"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 3.`}, {\(-5.`\), 
                  5.`}, {\(-5.`\), 5.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[124]="]
}, Open  ]],

Cell["\<\
Here is a plot of the result at t\[Equal]3.\
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot3D[
        First[u[3, x, y]\  /. \ %], {x, \(-5\), 5}, {y, \(-5\), 
          5}];\)\)], "Input",
  CellLabel->"In[126]:=",
  CellTags->{"b:1", "ndsg:0"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.55041e-017 1.04977 -0.0679587 1.04977 [
[.08608 .22315 -12 -8.87306 ]
[.08608 .22315 0 .12694 ]
[.20731 .17545 -11.6738 -9 ]
[.20731 .17545 .32622 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.46808 .07289 -5.33651 -9 ]
[.46808 .07289 .66349 0 ]
[.60856 .01769 -5.08632 -9 ]
[.60856 .01769 .91368 0 ]
[.73498 .04732 0 -6.2105 ]
[.73498 .04732 12 2.7895 ]
[.79846 .14452 0 -6.11593 ]
[.79846 .14452 12 2.88407 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.90976 .31495 0 -5.95504 ]
[.90976 .31495 6 3.04496 ]
[.95881 .39008 0 -5.88604 ]
[.95881 .39008 6 3.11396 ]
[.02043 .28822 -24 -2.76184 ]
[.02043 .28822 0 6.23816 ]
[.0083 .36424 -24 -2.82626 ]
[.0083 .36424 0 6.17374 ]
[-0.00444 .44408 -6 -2.89425 ]
[-0.00444 .44408 0 6.10575 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.72272 .05198 m
.71658 .05431 L
s
[(-4)] .73498 .04732 -1 .38011 Mshowa
.78611 .14895 m
.77994 .15117 L
s
[(-2)] .79846 .14452 -1 .3591 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.89727 .31899 m
.89103 .32101 L
s
[(2)] .90976 .31495 -1 .32334 Mshowa
.94627 .39394 m
.94 .39587 L
s
[(4)] .95881 .39008 -1 .30801 Mshowa
.125 Mabswid
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.7708 .12553 m
.7671 .12688 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.9099 .3383 m
.90615 .3395 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.70593 .0263 m
.70226 .02771 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03267 .28349 m
.03879 .28113 L
s
[(-0.2)] .02043 .28822 1 -0.38626 Mshowa
.0206 .35966 m
.02675 .35738 L
s
[(-0.1)] .0083 .36424 1 -0.37194 Mshowa
.00792 .43967 m
.0141 .43746 L
s
[(0)] -0.00444 .44408 1 -0.35683 Mshowa
.125 Mabswid
.0303 .29843 m
.03397 .29702 L
s
.02791 .31352 m
.03159 .31212 L
s
.02549 .32875 m
.02918 .32736 L
s
.02306 .34413 m
.02674 .34275 L
s
.01811 .37535 m
.0218 .37399 L
s
.0156 .39119 m
.0193 .38984 L
s
.01306 .40719 m
.01676 .40585 L
s
.0105 .42335 m
.01421 .42201 L
s
.03501 .26869 m
.03868 .26727 L
s
.0053 .45615 m
.00902 .45484 L
s
.00267 .47281 m
.00638 .4715 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.65 .758 .929 r
.38602 .7552 .39944 .7664 .42182 .76035 .40852 .74906 Metetra
.65 .758 .929 r
.40852 .74906 .42182 .76035 .44439 .75426 .4312 .74288 Metetra
.649 .758 .929 r
.4312 .74288 .44439 .75426 .46715 .74811 .45408 .73667 Metetra
.648 .758 .93 r
.45408 .73667 .46715 .74811 .4901 .74191 .47716 .73049 Metetra
.643 .759 .933 r
.47716 .73049 .4901 .74191 .51324 .73566 .50043 .72448 Metetra
.634 .762 .94 r
.50043 .72448 .51324 .73566 .53658 .72936 .5239 .71883 Metetra
.618 .771 .954 r
.5239 .71883 .53658 .72936 .56012 .723 .5476 .71373 Metetra
.592 .788 .974 r
.5476 .71373 .56012 .723 .58387 .71659 .57152 .70918 Metetra
.556 .814 .994 r
.57152 .70918 .58387 .71659 .60781 .71012 .59568 .70492 Metetra
.509 .84 .998 r
.59568 .70492 .60781 .71012 .63197 .7036 .62008 .70046 Metetra
.462 .855 .975 r
.62008 .70046 .63197 .7036 .65634 .69702 .64471 .69532 Metetra
.44 .863 .943 r
.64471 .69532 .65634 .69702 .68091 .69038 .66953 .68915 Metetra
.465 .88 .935 r
.66953 .68915 .68091 .69038 .70571 .68369 .69453 .68183 Metetra
.529 .905 .955 r
.69453 .68183 .70571 .68369 .73072 .67694 .71969 .67345 Metetra
.602 .912 .979 r
.71969 .67345 .73072 .67694 .75595 .67012 .74501 .66436 Metetra
.649 .89 .983 r
.74501 .66436 .75595 .67012 .78141 .66325 .77051 .65506 Metetra
.666 .849 .97 r
.77051 .65506 .78141 .66325 .80709 .65631 .79624 .64602 Metetra
.666 .811 .953 r
.79624 .64602 .80709 .65631 .83301 .64931 .82222 .63752 Metetra
.66 .784 .94 r
.82222 .63752 .83301 .64931 .85915 .64225 .84848 .62956 Metetra
.654 .768 .933 r
.84848 .62956 .85915 .64225 .88554 .63513 .875 .62197 Metetra
.651 .762 .93 r
.875 .62197 .88554 .63513 .91216 .62794 .90179 .61453 Metetra
.65 .759 .929 r
.90179 .61453 .91216 .62794 .93903 .62068 .92884 .60712 Metetra
.65 .758 .929 r
.92884 .60712 .93903 .62068 .96614 .61336 .95613 .59967 Metetra
.65 .758 .929 r
.95613 .59967 .96614 .61336 .9935 .60597 .98368 .59215 Metetra
.65 .758 .929 r
.37239 .74383 .38602 .7552 .40852 .74906 .39501 .7376 Metetra
.649 .758 .929 r
.39501 .7376 .40852 .74906 .4312 .74288 .41781 .73135 Metetra
.647 .758 .93 r
.41781 .73135 .4312 .74288 .45408 .73667 .44081 .72519 Metetra
.639 .758 .935 r
.44081 .72519 .45408 .73667 .47716 .73049 .46401 .71935 Metetra
.619 .76 .946 r
.46401 .71935 .47716 .73049 .50043 .72448 .4874 .71433 Metetra
.579 .767 .968 r
.4874 .71433 .50043 .72448 .5239 .71883 .511 .71064 Metetra
.501 .778 .994 r
.511 .71064 .5239 .71883 .5476 .71373 .53486 .70848 Metetra
.363 .771 .982 r
.53486 .70848 .5476 .71373 .57152 .70918 .55899 .70736 Metetra
.182 .707 .863 r
.55899 .70736 .57152 .70918 .59568 .70492 .58341 .70624 Metetra
.58341 .70624 .59568 .70492 .62008 .70046 .6081 .70405 Metetra
.6081 .70405 .62008 .70046 .64471 .69532 .63302 .70015 Metetra
.63302 .70015 .64471 .69532 .66953 .68915 .65813 .69431 Metetra
.65813 .69431 .66953 .68915 .69453 .68183 .6834 .68651 Metetra
.6834 .68651 .69453 .68183 .71969 .67345 .70878 .67676 Metetra
.39 .841 .749 r
.70878 .67676 .71969 .67345 .74501 .66436 .73425 .66522 Metetra
.557 .934 .876 r
.73425 .66522 .74501 .66436 .77051 .65506 .75981 .65255 Metetra
.667 .951 .954 r
.75981 .65255 .77051 .65506 .79624 .64602 .78552 .63982 Metetra
.698 .901 .969 r
.78552 .63982 .79624 .64602 .82222 .63752 .81147 .6281 Metetra
.688 .84 .956 r
.81147 .6281 .82222 .63752 .84848 .62956 .83773 .61791 Metetra
.67 .796 .942 r
.83773 .61791 .84848 .62956 .875 .62197 .86434 .60907 Metetra
.658 .772 .934 r
.86434 .60907 .875 .62197 .90179 .61453 .89126 .60105 Metetra
.652 .762 .93 r
.89126 .60105 .90179 .61453 .92884 .60712 .91847 .59336 Metetra
.65 .759 .929 r
.91847 .59336 .92884 .60712 .95613 .59967 .94595 .58574 Metetra
.65 .758 .929 r
.94595 .58574 .95613 .59967 .98368 .59215 .97369 .57809 Metetra
.649 .758 .929 r
.35855 .73228 .37239 .74383 .39501 .7376 .38128 .72598 Metetra
.646 .758 .93 r
.38128 .72598 .39501 .7376 .41781 .73135 .40421 .71978 Metetra
.636 .758 .936 r
.40421 .71978 .41781 .73135 .44081 .72519 .42732 .71402 Metetra
.607 .758 .951 r
.42732 .71402 .44081 .72519 .46401 .71935 .45061 .70949 Metetra
.532 .758 .98 r
.45061 .70949 .46401 .71935 .4874 .71433 .4741 .70722 Metetra
.354 .734 .987 r
.4741 .70722 .4874 .71433 .511 .71064 .49783 .70769 Metetra
.037 .593 .815 r
.49783 .70769 .511 .71064 .53486 .70848 .52186 .70995 Metetra
.183 0 0 r
.52186 .70995 .53486 .70848 .55899 .70736 .54622 .71173 Metetra
.182 0 0 r
.54622 .71173 .55899 .70736 .58341 .70624 .57089 .71088 Metetra
.034 0 0 r
.57089 .71088 .58341 .70624 .6081 .70405 .59579 .70681 Metetra
.189 .715 .707 r
.59579 .70681 .6081 .70405 .63302 .70015 .6209 .70058 Metetra
.356 .829 .86 r
.6209 .70058 .63302 .70015 .65813 .69431 .64622 .69367 Metetra
.404 .853 .904 r
.64622 .69367 .65813 .69431 .6834 .68651 .67178 .68678 Metetra
.382 .845 .868 r
.67178 .68678 .6834 .68651 .70878 .67676 .69754 .67922 Metetra
.355 .825 .775 r
.69754 .67922 .70878 .67676 .73425 .66522 .72341 .66944 Metetra
.393 .834 .709 r
.72341 .66944 .73425 .66522 .75981 .65255 .74926 .65635 Metetra
.516 .903 .753 r
.74926 .65635 .75981 .65255 .78552 .63982 .77507 .6405 Metetra
.663 .973 .874 r
.77507 .6405 .78552 .63982 .81147 .6281 .80095 .62405 Metetra
.726 .949 .951 r
.80095 .62405 .81147 .6281 .83773 .61791 .82709 .60937 Metetra
.709 .868 .957 r
.82709 .60937 .83773 .61791 .86434 .60907 .85363 .59746 Metetra
.678 .805 .943 r
.85363 .59746 .86434 .60907 .89126 .60105 .88061 .58785 Metetra
.66 .774 .934 r
.88061 .58785 .89126 .60105 .91847 .59336 .90795 .5795 Metetra
.652 .762 .93 r
.90795 .5795 .91847 .59336 .94595 .58574 .9356 .5716 Metetra
.65 .759 .929 r
.9356 .5716 .94595 .58574 .97369 .57809 .96353 .56378 Metetra
.647 .757 .93 r
.34449 .72054 .35855 .73228 .38128 .72598 .36734 .71427 Metetra
.638 .757 .935 r
.36734 .71427 .38128 .72598 .40421 .71978 .39037 .70841 Metetra
.605 .755 .95 r
.39037 .70841 .40421 .71978 .42732 .71402 .41356 .70396 Metetra
.506 .746 .981 r
.41356 .70396 .42732 .71402 .45061 .70949 .43691 .7025 Metetra
.233 .671 .957 r
.43691 .7025 .45061 .70949 .4741 .70722 .46045 .70502 Metetra
.176 0 0 r
.46045 .70502 .4741 .70722 .49783 .70769 .48431 .70994 Metetra
.26 0 0 r
.48431 .70994 .49783 .70769 .52186 .70995 .50854 .71259 Metetra
.50854 .71259 .52186 .70995 .54622 .71173 .5331 .70824 Metetra
.703 .93 .965 r
.5331 .70824 .54622 .71173 .57089 .71088 .55785 .69595 Metetra
.762 .756 .848 r
.55785 .69595 .57089 .71088 .59579 .70681 .58267 .6793 Metetra
.708 .634 .772 r
.58267 .6793 .59579 .70681 .6209 .70058 .6076 .66367 Metetra
.652 .563 .742 r
.6076 .66367 .6209 .70058 .64622 .69367 .63279 .65324 Metetra
.602 .523 .737 r
.63279 .65324 .64622 .69367 .67178 .68678 .65843 .64952 Metetra
.559 .51 .757 r
.65843 .64952 .67178 .68678 .69754 .67922 .6846 .65108 Metetra
.534 .546 .814 r
.6846 .65108 .69754 .67922 .72341 .66944 .7112 .65377 Metetra
.554 .687 .927 r
.7112 .65377 .72341 .66944 .74926 .65635 .73793 .65211 Metetra
.612 .912 .981 r
.73793 .65211 .74926 .65635 .77507 .6405 .76444 .64235 Metetra
.63 .962 .837 r
.76444 .64235 .77507 .6405 .80095 .62405 .79061 .62534 Metetra
.707 .985 .844 r
.79061 .62534 .80095 .62405 .82709 .60937 .81667 .60589 Metetra
.756 .966 .932 r
.81667 .60589 .82709 .60937 .85363 .59746 .84302 .58879 Metetra
.723 .875 .952 r
.84302 .58879 .85363 .59746 .88061 .58785 .8699 .57576 Metetra
.68 .804 .941 r
.8699 .57576 .88061 .58785 .90795 .5795 .89728 .56581 Metetra
.659 .771 .932 r
.89728 .56581 .90795 .5795 .9356 .5716 .92508 .55731 Metetra
.652 .761 .929 r
.92508 .55731 .9356 .5716 .96353 .56378 .95319 .54922 Metetra
.64 .756 .932 r
.33021 .70862 .34449 .72054 .36734 .71427 .35316 .70259 Metetra
.614 .754 .945 r
.35316 .70259 .36734 .71427 .39037 .70841 .37627 .69772 Metetra
.52 .742 .976 r
.37627 .69772 .39037 .70841 .41356 .70396 .39948 .69603 Metetra
.22 .648 .954 r
.39948 .69603 .41356 .70396 .43691 .7025 .42282 .69938 Metetra
.243 0 0 r
.42282 .69938 .43691 .7025 .46045 .70502 .44643 .70617 Metetra
.218 0 0 r
.44643 .70617 .46045 .70502 .48431 .70994 .4705 .70891 Metetra
.611 .937 .955 r
.4705 .70891 .48431 .70994 .50854 .71259 .49503 .69832 Metetra
.826 .768 .797 r
.49503 .69832 .50854 .71259 .5331 .70824 .51974 .67173 Metetra
.77 .625 .699 r
.51974 .67173 .5331 .70824 .55785 .69595 .54435 .63588 Metetra
.713 .547 .663 r
.54435 .63588 .55785 .69595 .58267 .6793 .56879 .60121 Metetra
.663 .495 .647 r
.56879 .60121 .58267 .6793 .6076 .66367 .59322 .5753 Metetra
.619 .457 .641 r
.59322 .5753 .6076 .66367 .63279 .65324 .61794 .56148 Metetra
.575 .424 .64 r
.61794 .56148 .63279 .65324 .65843 .64952 .64324 .56055 Metetra
.528 .394 .643 r
.64324 .56055 .65843 .64952 .6846 .65108 .66938 .57187 Metetra
.478 .37 .653 r
.66938 .57187 .6846 .65108 .7112 .65377 .69651 .59228 Metetra
.437 .369 .683 r
.69651 .59228 .7112 .65377 .73793 .65211 .72439 .61415 Metetra
.445 .443 .762 r
.72439 .61415 .73793 .65211 .76444 .64235 .75238 .62684 Metetra
.585 .709 .929 r
.75238 .62684 .76444 .64235 .79061 .62534 .77974 .62322 Metetra
.74 .977 .921 r
.77974 .62322 .79061 .62534 .81667 .60589 .8063 .60583 Metetra
.776 .996 .86 r
.8063 .60583 .81667 .60589 .84302 .58879 .83257 .58412 Metetra
.78 .956 .927 r
.83257 .58412 .84302 .58879 .8699 .57576 .85922 .56586 Metetra
.722 .859 .946 r
.85922 .56586 .8699 .57576 .89728 .56581 .88652 .55278 Metetra
.675 .792 .937 r
.88652 .55278 .89728 .56581 .92508 .55731 .91439 .54299 Metetra
.657 .767 .93 r
.91439 .54299 .92508 .55731 .95319 .54922 .94266 .53441 Metetra
.625 .752 .938 r
.31569 .69651 .33021 .70862 .35316 .70259 .33873 .69114 Metetra
.561 .745 .963 r
.33873 .69114 .35316 .70259 .37627 .69772 .36186 .68824 Metetra
.317 .676 .977 r
.36186 .68824 .37627 .69772 .39948 .69603 .38503 .69074 Metetra
0 .38 .697 r
.38503 .69074 .39948 .69603 .42282 .69938 .40836 .69856 Metetra
.232 0 0 r
.40836 .69856 .42282 .69938 .44643 .70617 .43218 .70317 Metetra
.729 .935 .955 r
.43218 .70317 .44643 .70617 .4705 .70891 .45672 .68969 Metetra
.843 .724 .733 r
.45672 .68969 .4705 .70891 .49503 .69832 .48171 .65082 Metetra
.787 .61 .66 r
.48171 .65082 .49503 .69832 .51974 .67173 .50655 .59624 Metetra
.732 .543 .637 r
.50655 .59624 .51974 .67173 .54435 .63588 .53094 .54361 Metetra
.683 .498 .63 r
.53094 .54361 .54435 .63588 .56879 .60121 .55501 .5043 Metetra
.643 .467 .63 r
.55501 .5043 .56879 .60121 .59322 .5753 .57908 .47981 Metetra
.61 .445 .633 r
.57908 .47981 .59322 .5753 .61794 .56148 .60339 .46709 Metetra
.578 .423 .635 r
.60339 .46709 .61794 .56148 .64324 .56055 .62815 .46445 Metetra
.535 .393 .634 r
.62815 .46445 .64324 .56055 .66938 .57187 .65368 .47373 Metetra
.476 .351 .63 r
.65368 .47373 .66938 .57187 .69651 .59228 .68041 .49817 Metetra
.407 .307 .629 r
.68041 .49817 .69651 .59228 .72439 .61415 .70864 .53646 Metetra
.352 .288 .645 r
.70864 .53646 .72439 .61415 .75238 .62684 .738 .57723 Metetra
.365 .351 .711 r
.738 .57723 .75238 .62684 .77974 .62322 .76728 .60232 Metetra
.555 .631 .882 r
.76728 .60232 .77974 .62322 .8063 .60583 .79531 .60145 Metetra
.797 .96 .917 r
.79531 .60145 .8063 .60583 .83257 .58412 .82209 .58181 Metetra
.824 .986 .877 r
.82209 .58181 .83257 .58412 .85922 .56586 .84861 .55867 Metetra
.78 .922 .931 r
.84861 .55867 .85922 .56586 .88652 .55278 .87572 .54097 Metetra
.706 .828 .94 r
.87572 .54097 .88652 .55278 .91439 .54299 .90357 .52886 Metetra
.669 .779 .932 r
.90357 .52886 .91439 .54299 .94266 .53441 .93195 .51932 Metetra
.595 .743 .947 r
.30095 .68421 .31569 .69651 .33873 .69114 .32402 .6801 Metetra
.455 .715 .98 r
.32402 .6801 .33873 .69114 .36186 .68824 .34711 .68017 Metetra
0 .497 .853 r
.34711 .68017 .36186 .68824 .38503 .69074 .3702 .68714 Metetra
.308 0 0 r
.3702 .68714 .38503 .69074 .40836 .69856 .39364 .69536 Metetra
.603 .907 .983 r
.39364 .69536 .40836 .69856 .43218 .70317 .41801 .68668 Metetra
.862 .743 .731 r
.41801 .68668 .43218 .70317 .45672 .68969 .44336 .64485 Metetra
.816 .63 .651 r
.44336 .64485 .45672 .68969 .48171 .65082 .46887 .57754 Metetra
.76 .564 .632 r
.46887 .57754 .48171 .65082 .50655 .59624 .49372 .51155 Metetra
.703 .516 .633 r
.49372 .51155 .50655 .59624 .53094 .54361 .5179 .46689 Metetra
.652 .486 .647 r
.5179 .46689 .53094 .54361 .55501 .5043 .54186 .44466 Metetra
.62 .485 .675 r
.54186 .44466 .55501 .5043 .57908 .47981 .56598 .43484 Metetra
.619 .514 .713 r
.56598 .43484 .57908 .47981 .60339 .46709 .59033 .42757 Metetra
.633 .54 .731 r
.59033 .42757 .60339 .46709 .62815 .46445 .61487 .41911 Metetra
.609 .509 .714 r
.61487 .41911 .62815 .46445 .65368 .47373 .63972 .41321 Metetra
.529 .426 .681 r
.63972 .41321 .65368 .47373 .68041 .49817 .66537 .41988 Metetra
.416 .326 .646 r
.66537 .41988 .68041 .49817 .70864 .53646 .69265 .44949 Metetra
.307 .244 .622 r
.69265 .44949 .70864 .53646 .738 .57723 .72209 .50124 Metetra
.249 .221 .63 r
.72209 .50124 .738 .57723 .76728 .60232 .75288 .555 Metetra
.317 .329 .715 r
.75288 .555 .76728 .60232 .79531 .60145 .78301 .58306 Metetra
.624 .698 .898 r
.78301 .58306 .79531 .60145 .82209 .58181 .81114 .57697 Metetra
.844 .958 .884 r
.81114 .57697 .82209 .58181 .84861 .55867 .83793 .5532 Metetra
.832 .954 .895 r
.83793 .5532 .84861 .55867 .87572 .54097 .86486 .53059 Metetra
.751 .868 .933 r
.86486 .53059 .87572 .54097 .90357 .52886 .89261 .51511 Metetra
.69 .797 .931 r
.89261 .51511 .90357 .52886 .93195 .51932 .92104 .50397 Metetra
.545 .727 .959 r
.28596 .6717 .30095 .68421 .32402 .6801 .30902 .66948 Metetra
.285 .644 .967 r
.30902 .66948 .32402 .6801 .34711 .68017 .33202 .67303 Metetra
0 .323 .684 r
.33202 .67303 .34711 .68017 .3702 .68714 .35507 .68294 Metetra
.093 .627 .864 r
.35507 .68294 .3702 .68714 .39364 .69536 .37889 .68499 Metetra
.862 .804 .792 r
.37889 .68499 .39364 .69536 .41801 .68668 .4042 .65391 Metetra
.85 .67 .657 r
.4042 .65391 .41801 .68668 .44336 .64485 .43047 .58395 Metetra
.8 .6 .632 r
.43047 .58395 .44336 .64485 .46887 .57754 .45626 .5052 Metetra
.736 .547 .638 r
.45626 .5052 .46887 .57754 .49372 .51155 .48089 .45308 Metetra
.651 .506 .674 r
.48089 .45308 .49372 .51155 .5179 .46689 .50485 .4366 Metetra
.497 .505 .796 r
.50485 .4366 .5179 .46689 .54186 .44466 .52893 .44142 Metetra
.237 0 0 r
.52893 .44142 .54186 .44466 .56598 .43484 .55343 .44883 Metetra
.373 0 0 r
.55343 .44883 .56598 .43484 .59033 .42757 .57823 .4472 Metetra
.146 0 0 r
.57823 .4472 .59033 .42757 .61487 .41911 .60305 .43295 Metetra
.60305 .43295 .61487 .41911 .63972 .41321 .6277 .40954 Metetra
.835 .949 .894 r
.6277 .40954 .63972 .41321 .66537 .41988 .65245 .38863 Metetra
.554 .536 .79 r
.65245 .38863 .66537 .41988 .69265 .44949 .67825 .38924 Metetra
.287 .268 .663 r
.67825 .38924 .69265 .44949 .72209 .50124 .70646 .42631 Metetra
.143 .147 .603 r
.70646 .42631 .72209 .50124 .75288 .555 .73745 .49117 Metetra
.14 .168 .628 r
.73745 .49117 .75288 .555 .78301 .58306 .76931 .54777 Metetra
.366 .416 .78 r
.76931 .54777 .78301 .58306 .81114 .57697 .79932 .56462 Metetra
.773 .839 .903 r
.79932 .56462 .81114 .57697 .83793 .5532 .82696 .54707 Metetra
.863 .943 .869 r
.82696 .54707 .83793 .5532 .86486 .53059 .8539 .52113 Metetra
.797 .896 .913 r
.8539 .52113 .86486 .53059 .89261 .51511 .88152 .50174 Metetra
.719 .817 .926 r
.88152 .50174 .89261 .51511 .92104 .50397 .90993 .48833 Metetra
.473 .699 .967 r
.27073 .65899 .28596 .6717 .30902 .66948 .29373 .65901 Metetra
.092 .536 .908 r
.29373 .65901 .30902 .66948 .33202 .67303 .31664 .66576 Metetra
0 .31 .671 r
.31664 .66576 .33202 .67303 .35507 .68294 .33976 .67597 Metetra
.672 .865 .972 r
.33976 .67597 .35507 .68294 .37889 .68499 .36424 .66645 Metetra
.876 .728 .696 r
.36424 .66645 .37889 .68499 .4042 .65391 .39068 .61158 Metetra
.847 .649 .636 r
.39068 .61158 .4042 .65391 .43047 .58395 .4177 .52468 Metetra
.792 .596 .636 r
.4177 .52468 .43047 .58395 .45626 .5052 .4434 .45388 Metetra
.692 .545 .681 r
.4434 .45388 .45626 .5052 .48089 .45308 .46758 .42999 Metetra
.207 .4 .832 r
.46758 .42999 .48089 .45308 .50485 .4366 .49133 .44435 Metetra
.746 .292 .171 r
.49133 .44435 .50485 .4366 .52893 .44142 .5156 .47021 Metetra
.641 .268 .322 r
.5156 .47021 .52893 .44142 .55343 .44883 .54056 .4875 Metetra
.516 .172 .322 r
.54056 .4875 .55343 .44883 .57823 .4472 .56592 .48845 Metetra
.344 .023 .268 r
.56592 .48845 .57823 .4472 .60305 .43295 .5913 .47158 Metetra
.078 0 .148 r
.5913 .47158 .60305 .43295 .6277 .40954 .61631 .43815 Metetra
.61631 .43815 .6277 .40954 .65245 .38863 .64084 .39585 Metetra
.805 .977 .687 r
.64084 .39585 .65245 .38863 .67825 .38924 .66556 .36496 Metetra
.412 .513 .851 r
.66556 .36496 .67825 .38924 .70646 .42631 .69219 .37289 Metetra
.007 .095 .607 r
.69219 .37289 .70646 .42631 .73745 .49117 .72225 .42907 Metetra
0 .029 .562 r
.72225 .42907 .73745 .49117 .76931 .54777 .75486 .50256 Metetra
.123 .211 .684 r
.75486 .50256 .76931 .54777 .79932 .56462 .78662 .54372 Metetra
.615 .674 .883 r
.78662 .54372 .79932 .56462 .82696 .54707 .81547 .53796 Metetra
.862 .903 .861 r
.81547 .53796 .82696 .54707 .8539 .52113 .84269 .51148 Metetra
.832 .899 .887 r
.84269 .51148 .8539 .52113 .88152 .50174 .87024 .48845 Metetra
.751 .832 .914 r
.87024 .48845 .88152 .50174 .90993 .48833 .89862 .47241 Metetra
.393 .664 .967 r
.25524 .64606 .27073 .65899 .29373 .65901 .27818 .64819 Metetra
0 .441 .844 r
.27818 .64819 .29373 .65901 .31664 .66576 .30101 .65728 Metetra
0 .433 .801 r
.30101 .65728 .31664 .66576 .33976 .67597 .32431 .66559 Metetra
.82 .816 .846 r
.32431 .66559 .33976 .67597 .36424 .66645 .3496 .64331 Metetra
.881 .707 .661 r
.3496 .64331 .36424 .66645 .39068 .61158 .37712 .57015 Metetra
.854 .654 .631 r
.37712 .57015 .39068 .61158 .4177 .52468 .4046 .47851 Metetra
.791 .613 .66 r
.4046 .47851 .4177 .52468 .4434 .45388 .42998 .42483 Metetra
.507 .523 .807 r
.42998 .42483 .4434 .45388 .46758 .42999 .45365 .42807 Metetra
.823 .356 .102 r
.45365 .42807 .46758 .42999 .49133 .44435 .47724 .46352 Metetra
.757 .367 .316 r
.47724 .46352 .49133 .44435 .5156 .47021 .50169 .49865 Metetra
.649 .271 .315 r
.50169 .49865 .5156 .47021 .54056 .4875 .52702 .51757 Metetra
.494 .114 .249 r
.52702 .51757 .54056 .4875 .56592 .48845 .55285 .5183 Metetra
.239 0 .13 r
.55285 .5183 .56592 .48845 .5913 .47158 .57877 .50158 Metetra
.57877 .50158 .5913 .47158 .61631 .43815 .60436 .46642 Metetra
.60436 .46642 .61631 .43815 .64084 .39585 .62923 .41462 Metetra
.797 .874 .44 r
.62923 .41462 .64084 .39585 .66556 .36496 .65361 .36214 Metetra
.807 .971 .905 r
.65361 .36214 .66556 .36496 .69219 .37289 .67909 .3422 Metetra
0 .102 .652 r
.67909 .3422 .69219 .37289 .72225 .42907 .70796 .38043 Metetra
0 0 .464 r
.70796 .38043 .72225 .42907 .75486 .50256 .74047 .4583 Metetra
0 .017 .578 r
.74047 .4583 .75486 .50256 .78662 .54372 .7734 .518 Metetra
.431 .531 .859 r
.7734 .518 .78662 .54372 .81547 .53796 .80345 .52525 Metetra
.835 .853 .86 r
.80345 .52525 .81547 .53796 .84269 .51148 .83113 .50048 Metetra
.85 .882 .863 r
.83113 .50048 .84269 .51148 .87024 .48845 .85872 .47474 Metetra
.776 .836 .898 r
.85872 .47474 .87024 .48845 .89862 .47241 .88709 .45619 Metetra
.327 .631 .961 r
.23949 .63292 .25524 .64606 .27818 .64819 .26239 .63653 Metetra
0 .396 .818 r
.26239 .63653 .27818 .64819 .30101 .65728 .28519 .64689 Metetra
.119 .562 .919 r
.28519 .64689 .30101 .65728 .32431 .66559 .30872 .65285 Metetra
.852 .783 .784 r
.30872 .65285 .32431 .66559 .3496 .64331 .33474 .621 Metetra
.893 .71 .648 r
.33474 .621 .3496 .64331 .37712 .57015 .36314 .53733 Metetra
.873 .678 .635 r
.36314 .53733 .37712 .57015 .4046 .47851 .39094 .447 Metetra
.799 .654 .703 r
.39094 .447 .4046 .47851 .42998 .42483 .41604 .40805 Metetra
0 .146 .669 r
.41604 .40805 .42998 .42483 .45365 .42807 .43932 .42863 Metetra
.854 .427 .208 r
.43932 .42863 .45365 .42807 .47724 .46352 .46278 .47405 Metetra
.79 .37 .251 r
.46278 .47405 .47724 .46352 .50169 .49865 .48737 .51084 Metetra
.654 .19 .139 r
.48737 .51084 .50169 .49865 .52702 .51757 .51295 .52807 Metetra
.328 0 0 r
.51295 .52807 .52702 .51757 .55285 .5183 .53909 .52776 Metetra
.53909 .52776 .55285 .5183 .57877 .50158 .56542 .51191 Metetra
.784 .962 .65 r
.56542 .51191 .57877 .50158 .60436 .46642 .59152 .4783 Metetra
.935 .941 .596 r
.59152 .4783 .60436 .46642 .62923 .41462 .6169 .42463 Metetra
.973 .916 .588 r
.6169 .42463 .62923 .41462 .65361 .36214 .64145 .36184 Metetra
.94 .95 .758 r
.64145 .36184 .65361 .36214 .67909 .3422 .66647 .32398 Metetra
0 .233 .749 r
.66647 .32398 .67909 .3422 .70796 .38043 .6945 .34683 Metetra
0 0 .304 r
.6945 .34683 .70796 .38043 .74047 .4583 .72663 .4229 Metetra
0 0 .409 r
.72663 .4229 .74047 .4583 .7734 .518 .7601 .49309 Metetra
.228 .418 .842 r
.7601 .49309 .7734 .518 .80345 .52525 .791 .51001 Metetra
.806 .819 .861 r
.791 .51001 .80345 .52525 .83113 .50048 .81916 .48743 Metetra
.852 .857 .845 r
.81916 .48743 .83113 .50048 .85872 .47474 .8469 .46007 Metetra
.79 .829 .882 r
.8469 .46007 .85872 .47474 .88709 .45619 .87535 .43967 Metetra
.301 .618 .958 r
.22348 .61956 .23949 .63292 .26239 .63653 .24641 .62366 Metetra
0 .397 .829 r
.24641 .62366 .26239 .63653 .28519 .64689 .26921 .63439 Metetra
.243 .603 .953 r
.26921 .63439 .28519 .64689 .30872 .65285 .29288 .63927 Metetra
.859 .774 .767 r
.29288 .63927 .30872 .65285 .33474 .621 .31937 .60377 Metetra
.91 .729 .645 r
.31937 .60377 .33474 .621 .36314 .53733 .34843 .51652 Metetra
.904 .716 .638 r
.34843 .51652 .36314 .53733 .39094 .447 .37666 .42717 Metetra
.83 .724 .748 r
.37666 .42717 .39094 .447 .41604 .40805 .40178 .39367 Metetra
.587 .087 0 r
.40178 .39367 .41604 .40805 .43932 .42863 .4249 .41996 Metetra
.872 .429 .101 r
.4249 .41996 .43932 .42863 .46278 .47405 .44824 .46805 Metetra
.813 .328 .008 r
.44824 .46805 .46278 .47405 .48737 .51084 .47285 .5047 Metetra
.477 0 0 r
.47285 .5047 .48737 .51084 .51295 .52807 .49855 .52091 Metetra
.349 .753 .983 r
.49855 .52091 .51295 .52807 .53909 .52776 .52489 .52007 Metetra
.756 .893 .939 r
.52489 .52007 .53909 .52776 .56542 .51191 .55148 .50451 Metetra
.897 .88 .809 r
.55148 .50451 .56542 .51191 .59152 .4783 .57793 .47165 Metetra
.952 .847 .703 r
.57793 .47165 .59152 .4783 .6169 .42463 .60373 .41789 Metetra
.965 .828 .658 r
.60373 .41789 .6169 .42463 .64145 .36184 .62865 .35212 Metetra
.929 .843 .737 r
.62865 .35212 .64145 .36184 .66647 .32398 .65376 .30818 Metetra
0 .342 .818 r
.65376 .30818 .66647 .32398 .6945 .34683 .68156 .32516 Metetra
.795 .392 0 r
.68156 .32516 .6945 .34683 .72663 .4229 .71344 .39987 Metetra
.75 .35 0 r
.71344 .39987 .72663 .4229 .7601 .49309 .747 .47341 Metetra
.015 .339 .82 r
.747 .47341 .7601 .49309 .791 .51001 .77827 .49384 Metetra
.795 .809 .863 r
.77827 .49384 .791 .51001 .81916 .48743 .80677 .47209 Metetra
.845 .83 .832 r
.80677 .47209 .81916 .48743 .8469 .46007 .83474 .44405 Metetra
.792 .816 .871 r
.83474 .44405 .8469 .46007 .87535 .43967 .86339 .42283 Metetra
.327 .631 .961 r
.2072 .60597 .22348 .61956 .24641 .62366 .23024 .60944 Metetra
.004 .428 .861 r
.23024 .60944 .24641 .62366 .26921 .63439 .25311 .61971 Metetra
.251 .576 .942 r
.25311 .61971 .26921 .63439 .29288 .63927 .27677 .62553 Metetra
.849 .778 .782 r
.27677 .62553 .29288 .63927 .31937 .60377 .30333 .5932 Metetra
.928 .756 .649 r
.30333 .5932 .31937 .60377 .34843 .51652 .33277 .50859 Metetra
.94 .763 .635 r
.33277 .50859 .34843 .51652 .37666 .42717 .36167 .41734 Metetra
.895 .807 .754 r
.36167 .41734 .37666 .42717 .40178 .39367 .38733 .3779 Metetra
0 .114 .628 r
.38733 .3779 .40178 .39367 .4249 .41996 .41062 .39841 Metetra
.757 .328 0 r
.41062 .39841 .4249 .41996 .44824 .46805 .43387 .44396 Metetra
0 0 .446 r
.43387 .44396 .44824 .46805 .47285 .5047 .45835 .48085 Metetra
.101 .35 .818 r
.45835 .48085 .47285 .5047 .49855 .52091 .48402 .498 Metetra
.535 .613 .877 r
.48402 .498 .49855 .52091 .52489 .52007 .51043 .49747 Metetra
.726 .699 .824 r
.51043 .49747 .52489 .52007 .55148 .50451 .53715 .48126 Metetra
.825 .723 .753 r
.53715 .48126 .55148 .50451 .57793 .47165 .56381 .44713 Metetra
.877 .725 .69 r
.56381 .44713 .57793 .47165 .60373 .41789 .58989 .3928 Metetra
.893 .724 .666 r
.58989 .3928 .60373 .41789 .62865 .35212 .6152 .3293 Metetra
.848 .732 .735 r
.6152 .3293 .62865 .35212 .65376 .30818 .64078 .29094 Metetra
0 .211 .728 r
.64078 .29094 .65376 .30818 .68156 .32516 .66892 .31369 Metetra
.876 .45 .04 r
.66892 .31369 .68156 .32516 .71344 .39987 .70081 .39008 Metetra
.857 .414 .005 r
.70081 .39008 .71344 .39987 .747 .47341 .73414 .46061 Metetra
0 .348 .801 r
.73414 .46061 .747 .47341 .77827 .49384 .76529 .47743 Metetra
.804 .812 .858 r
.76529 .47743 .77827 .49384 .80677 .47209 .79396 .45439 Metetra
.832 .805 .824 r
.79396 .45439 .80677 .47209 .83474 .44405 .82224 .42652 Metetra
.782 .798 .866 r
.82224 .42652 .83474 .44405 .86339 .42283 .8512 .40567 Metetra
.393 .664 .967 r
.19064 .59215 .2072 .60597 .23024 .60944 .21389 .59395 Metetra
.112 .483 .899 r
.21389 .59395 .23024 .60944 .25311 .61971 .2369 .60283 Metetra
.197 .514 .914 r
.2369 .60283 .25311 .61971 .27677 .62553 .26042 .61093 Metetra
.805 .777 .827 r
.26042 .61093 .27677 .62553 .30333 .5932 .28658 .58785 Metetra
.94 .789 .666 r
.28658 .58785 .30333 .5932 .33277 .50859 .316 .51298 Metetra
.971 .81 .625 r
.316 .51298 .33277 .50859 .36167 .41734 .3457 .41943 Metetra
.962 .871 .701 r
.3457 .41943 .36167 .41734 .38733 .3779 .37252 .36454 Metetra
.354 .645 .965 r
.37252 .36454 .38733 .3779 .41062 .39841 .39653 .36739 Metetra
0 0 .558 r
.39653 .36739 .41062 .39841 .43387 .44396 .41987 .40294 Metetra
0 .111 .64 r
.41987 .40294 .43387 .44396 .45835 .48085 .44413 .43819 Metetra
.312 .344 .734 r
.44413 .43819 .45835 .48085 .48402 .498 .4696 .45699 Metetra
.545 .498 .754 r
.4696 .45699 .48402 .498 .51043 .49747 .49592 .45729 Metetra
.683 .58 .734 r
.49592 .45729 .51043 .49747 .53715 .48126 .52265 .43984 Metetra
.765 .619 .698 r
.52265 .43984 .53715 .48126 .56381 .44713 .54936 .40363 Metetra
.809 .635 .667 r
.54936 .40363 .56381 .44713 .58989 .3928 .57561 .35055 Metetra
.815 .64 .666 r
.57561 .35055 .58989 .3928 .6152 .3293 .60135 .29683 Metetra
.724 .632 .755 r
.60135 .29683 .6152 .3293 .64078 .29094 .62767 .27611 Metetra
.63 .153 0 r
.62767 .27611 .64078 .29094 .66892 .31369 .65653 .31438 Metetra
.891 .471 .176 r
.65653 .31438 .66892 .31369 .70081 .39008 .68855 .39295 Metetra
.851 .398 .12 r
.68855 .39295 .70081 .39008 .73414 .46061 .72134 .45317 Metetra
.027 .543 .867 r
.72134 .45317 .73414 .46061 .76529 .47743 .75202 .46005 Metetra
.819 .807 .84 r
.75202 .46005 .76529 .47743 .79396 .45439 .78076 .43432 Metetra
.814 .779 .821 r
.78076 .43432 .79396 .45439 .82224 .42652 .80941 .40759 Metetra
.763 .78 .867 r
.80941 .40759 .82224 .42652 .8512 .40567 .83878 .38818 Metetra
.473 .699 .967 r
.17379 .57809 .19064 .59215 .21389 .59395 .19733 .57756 Metetra
.247 .552 .93 r
.19733 .57756 .21389 .59395 .2369 .60283 .22058 .58394 Metetra
.158 .464 .889 r
.22058 .58394 .2369 .60283 .26042 .61093 .24397 .59387 Metetra
.683 .735 .89 r
.24397 .59387 .26042 .61093 .28658 .58785 .26937 .5835 Metetra
.935 .822 .709 r
.26937 .5835 .28658 .58785 .316 .51298 .29813 .52653 Metetra
.988 .852 .616 r
.29813 .52653 .316 .51298 .3457 .41943 .32837 .4368 Metetra
.986 .901 .614 r
.32837 .4368 .3457 .41943 .37252 .36454 .35676 .36373 Metetra
.867 .955 .863 r
.35676 .36373 .37252 .36454 .39653 .36739 .38222 .33866 Metetra
.249 .389 .809 r
.38222 .33866 .39653 .36739 .41987 .40294 .40619 .35268 Metetra
.246 .266 .684 r
.40619 .35268 .41987 .40294 .44413 .43819 .4304 .37846 Metetra
.406 .348 .68 r
.4304 .37846 .44413 .43819 .4696 .45699 .45558 .39549 Metetra
.545 .438 .683 r
.45558 .39549 .4696 .45699 .49592 .45729 .48165 .39579 Metetra
.646 .504 .676 r
.48165 .39579 .49592 .45729 .52265 .43984 .50823 .37783 Metetra
.711 .544 .661 r
.50823 .37783 .52265 .43984 .54936 .40363 .53485 .34292 Metetra
.742 .565 .654 r
.53485 .34292 .54936 .40363 .57561 .35055 .56119 .29896 Metetra
.724 .57 .68 r
.56119 .29896 .57561 .35055 .60135 .29683 .58743 .26668 Metetra
.426 .489 .822 r
.58743 .26668 .60135 .29683 .62767 .27611 .61468 .27404 Metetra
.856 .401 .088 r
.61468 .27404 .62767 .27611 .65653 .31438 .64436 .33069 Metetra
.855 .45 .271 r
.64436 .33069 .65653 .31438 .68855 .39295 .67634 .40523 Metetra
.774 .314 .152 r
.67634 .40523 .68855 .39295 .72134 .45317 .70829 .44673 Metetra
.487 .853 .989 r
.70829 .44673 .72134 .45317 .75202 .46005 .73835 .44004 Metetra
.821 .782 .816 r
.73835 .44004 .75202 .46005 .78076 .43432 .76718 .41206 Metetra
.788 .755 .822 r
.76718 .41206 .78076 .43432 .80941 .40759 .79629 .38762 Metetra
.738 .764 .873 r
.79629 .38762 .80941 .40759 .83878 .38818 .82611 .37035 Metetra
.545 .727 .959 r
.15664 .56378 .17379 .57809 .19733 .57756 .18052 .56074 Metetra
.384 .622 .946 r
.18052 .56074 .19733 .57756 .22058 .58394 .20413 .56367 Metetra
.197 .471 .889 r
.20413 .56367 .22058 .58394 .24397 .59387 .22754 .5732 Metetra
.471 .615 .911 r
.22754 .5732 .24397 .59387 .26937 .5835 .2521 .57455 Metetra
.875 .834 .802 r
.2521 .57455 .26937 .5835 .29813 .52653 .27955 .54152 Metetra
.985 .894 .639 r
.27955 .54152 .29813 .52653 .32837 .4368 .3095 .46825 Metetra
.956 .904 .528 r
.3095 .46825 .32837 .4368 .35676 .36373 .33923 .38606 Metetra
.895 .937 .568 r
.33923 .38606 .35676 .36373 .38222 .33866 .36668 .3315 Metetra
.794 .891 .914 r
.36668 .3315 .38222 .33866 .40619 .35268 .3921 .31367 Metetra
.494 .471 .761 r
.3921 .31367 .40619 .35268 .4304 .37846 .41685 .31773 Metetra
.494 .403 .682 r
.41685 .31773 .4304 .37846 .45558 .39549 .44198 .32446 Metetra
.558 .429 .661 r
.44198 .32446 .45558 .39549 .48165 .39579 .46777 .32186 Metetra
.62 .467 .653 r
.46777 .32186 .48165 .39579 .50823 .37783 .49405 .30626 Metetra
.66 .497 .652 r
.49405 .30626 .50823 .37783 .53485 .34292 .52048 .28121 Metetra
.664 .514 .67 r
.52048 .28121 .53485 .34292 .56119 .29896 .54692 .25875 Metetra
.545 .501 .758 r
.54692 .25875 .56119 .29896 .58743 .26668 .57374 .25839 Metetra
.742 .231 0 r
.57374 .25839 .58743 .26668 .61468 .27404 .60191 .29552 Metetra
.826 .427 .294 r
.60191 .29552 .61468 .27404 .64436 .33069 .63216 .36143 Metetra
.78 .388 .311 r
.63216 .36143 .64436 .33069 .67634 .40523 .6637 .41897 Metetra
.595 .095 .034 r
.6637 .41897 .67634 .40523 .70829 .44673 .69465 .43543 Metetra
.778 .884 .922 r
.69465 .43543 .70829 .44673 .73835 .44004 .72422 .4162 Metetra
.803 .746 .8 r
.72422 .4162 .73835 .44004 .76718 .41206 .7533 .38828 Metetra
.758 .734 .831 r
.7533 .38828 .76718 .41206 .79629 .38762 .78291 .36713 Metetra
.712 .752 .884 r
.78291 .36713 .79629 .38762 .82611 .37035 .81319 .35217 Metetra
.595 .743 .947 r
.1392 .54922 .15664 .56378 .18052 .56074 .1634 .544 Metetra
.497 .678 .946 r
.1634 .544 .18052 .56074 .20413 .56367 .18744 .54312 Metetra
.313 .538 .909 r
.18744 .54312 .20413 .56367 .22754 .5732 .21113 .54946 Metetra
.319 .503 .881 r
.21113 .54946 .22754 .5732 .2521 .57455 .23517 .55711 Metetra
.674 .738 .898 r
.23517 .55711 .2521 .57455 .27955 .54152 .26108 .54702 Metetra
.947 .934 .75 r
.26108 .54702 .27955 .54152 .3095 .46825 .28966 .50223 Metetra
.889 .903 .492 r
.28966 .50223 .3095 .46825 .33923 .38606 .31961 .43092 Metetra
.697 .787 .31 r
.31961 .43092 .33923 .38606 .36668 .3315 .34875 .36117 Metetra
.652 .818 .388 r
.34875 .36117 .36668 .3315 .3921 .31367 .37611 .31371 Metetra
.847 .976 .872 r
.37611 .31371 .3921 .31367 .41685 .31773 .40219 .28956 Metetra
.666 .63 .804 r
.40219 .28956 .41685 .31773 .44198 .32446 .42785 .27824 Metetra
.612 .516 .722 r
.42785 .27824 .44198 .32446 .46777 .32186 .45367 .26955 Metetra
.612 .5 .702 r
.45367 .26955 .46777 .32186 .49405 .30626 .47976 .25961 Metetra
.6 .509 .723 r
.47976 .25961 .49405 .30626 .52048 .28121 .50607 .25231 Metetra
.433 .509 .837 r
.50607 .25231 .52048 .28121 .54692 .25875 .53271 .25799 Metetra
.73 .204 0 r
.53271 .25799 .54692 .25875 .57374 .25839 .56015 .28745 Metetra
.773 .382 .313 r
.56015 .28745 .57374 .25839 .60191 .29552 .58902 .33999 Metetra
.741 .372 .355 r
.58902 .33999 .60191 .29552 .63216 .36143 .61937 .3948 Metetra
.663 .26 .271 r
.61937 .3948 .63216 .36143 .6637 .41897 .65017 .42287 Metetra
.65017 .42287 .6637 .41897 .69465 .43543 .68028 .41524 Metetra
.808 .782 .829 r
.68028 .41524 .69465 .43543 .72422 .4162 .70969 .38908 Metetra
.77 .713 .798 r
.70969 .38908 .72422 .4162 .7533 .38828 .7392 .36414 Metetra
.726 .722 .847 r
.7392 .36414 .7533 .38828 .78291 .36713 .76932 .34663 Metetra
.687 .747 .897 r
.76932 .34663 .78291 .36713 .81319 .35217 .80002 .33363 Metetra
.625 .752 .938 r
.12144 .53441 .1392 .54922 .1634 .544 .14592 .52761 Metetra
.573 .716 .939 r
.14592 .52761 .1634 .544 .18744 .54312 .17038 .52341 Metetra
.449 .622 .925 r
.17038 .52341 .18744 .54312 .21113 .54946 .19457 .52488 Metetra
.336 .507 .878 r
.19457 .52488 .21113 .54946 .23517 .55711 .21863 .53198 Metetra
.433 .554 .878 r
.21863 .53198 .23517 .55711 .26108 .54702 .24346 .53566 Metetra
.749 .835 .917 r
.24346 .53566 .26108 .54702 .28966 .50223 .27017 .5202 Metetra
.848 .968 .647 r
.27017 .5202 .28966 .50223 .31961 .43092 .29888 .47791 Metetra
.29888 .47791 .31961 .43092 .34875 .36117 .32831 .41915 Metetra
.32831 .41915 .34875 .36117 .37611 .31371 .3571 .36258 Metetra
0 0 .021 r
.3571 .36258 .37611 .31371 .40219 .28956 .38474 .32007 Metetra
.38474 .32007 .40219 .28956 .42785 .27824 .41153 .29309 Metetra
.41153 .29309 .42785 .27824 .45367 .26955 .43793 .27841 Metetra
.114 0 0 r
.43793 .27841 .45367 .26955 .47976 .25961 .46429 .27424 Metetra
.511 .017 .02 r
.46429 .27424 .47976 .25961 .50607 .25231 .49086 .2825 Metetra
.655 .252 .269 r
.49086 .2825 .50607 .25231 .53271 .25799 .51797 .3066 Metetra
.684 .323 .356 r
.51797 .3066 .53271 .25799 .56015 .28745 .54606 .3453 Metetra
.676 .326 .372 r
.54606 .3453 .56015 .28745 .58902 .33999 .57534 .38671 Metetra
.627 .255 .319 r
.57534 .38671 .58902 .33999 .61937 .3948 .60545 .41169 Metetra
.311 0 0 r
.60545 .41169 .61937 .3948 .65017 .42287 .63559 .40926 Metetra
.803 .859 .891 r
.63559 .40926 .65017 .42287 .68028 .41524 .66532 .38699 Metetra
.772 .706 .79 r
.66532 .38699 .68028 .41524 .70969 .38908 .69494 .36103 Metetra
.734 .694 .813 r
.69494 .36103 .70969 .38908 .7392 .36414 .72495 .34079 Metetra
.696 .722 .869 r
.72495 .34079 .7392 .36414 .76932 .34663 .75552 .32641 Metetra
.669 .748 .909 r
.75552 .32641 .76932 .34663 .80002 .33363 .78658 .31471 Metetra
.64 .756 .932 r
.10337 .51932 .12144 .53441 .14592 .52761 .12807 .51157 Metetra
.617 .739 .933 r
.12807 .51157 .14592 .52761 .17038 .52341 .15288 .50505 Metetra
.552 .688 .929 r
.15288 .50505 .17038 .52341 .19457 .52488 .1776 .50188 Metetra
.448 .587 .898 r
.1776 .50188 .19457 .52488 .21863 .53198 .20213 .50407 Metetra
.394 .509 .856 r
.20213 .50407 .21863 .53198 .24346 .53566 .22673 .50991 Metetra
.478 .577 .875 r
.22673 .50991 .24346 .53566 .27017 .5202 .25216 .51142 Metetra
.704 .872 .961 r
.25216 .51142 .27017 .5202 .29888 .47791 .27907 .49868 Metetra
.519 .82 .491 r
.27907 .49868 .29888 .47791 .32831 .41915 .30731 .46885 Metetra
0 0 .018 r
.30731 .46885 .32831 .41915 .3571 .36258 .33605 .42919 Metetra
.134 0 .191 r
.33605 .42919 .3571 .36258 .38474 .32007 .3645 .39083 Metetra
.266 0 .262 r
.3645 .39083 .38474 .32007 .41153 .29309 .39234 .3618 Metetra
.375 .063 .302 r
.39234 .3618 .41153 .29309 .43793 .27841 .4197 .34556 Metetra
.471 .146 .333 r
.4197 .34556 .43793 .27841 .46429 .27424 .44688 .34294 Metetra
.543 .213 .359 r
.44688 .34294 .46429 .27424 .49086 .2825 .47425 .35328 Metetra
.584 .252 .373 r
.47425 .35328 .49086 .2825 .51797 .3066 .50219 .37325 Metetra
.592 .253 .364 r
.50219 .37325 .51797 .3066 .54606 .3453 .53095 .39481 Metetra
.551 .185 .299 r
.53095 .39481 .54606 .3453 .57534 .38671 .56048 .4066 Metetra
.271 0 0 r
.56048 .4066 .57534 .38671 .60545 .41169 .59037 .40101 Metetra
.786 .895 .921 r
.59037 .40101 .60545 .41169 .63559 .40926 .62023 .38071 Metetra
.764 .703 .794 r
.62023 .38071 .63559 .40926 .66532 .38699 .65004 .35581 Metetra
.73 .672 .794 r
.65004 .35581 .66532 .38699 .69494 .36103 .68008 .33455 Metetra
.701 .697 .843 r
.68008 .33455 .69494 .36103 .72495 .34079 .71056 .31878 Metetra
.674 .731 .893 r
.71056 .31878 .72495 .34079 .75552 .32641 .74151 .30648 Metetra
.658 .751 .919 r
.74151 .30648 .75552 .32641 .78658 .31471 .77287 .29541 Metetra
.647 .757 .93 r
.08497 .50397 .10337 .51932 .12807 .51157 .10985 .49571 Metetra
.638 .75 .93 r
.10985 .49571 .12807 .51157 .15288 .50505 .13492 .48786 Metetra
.611 .727 .928 r
.13492 .48786 .15288 .50505 .1776 .50188 .16007 .48151 Metetra
.553 .669 .914 r
.16007 .48151 .1776 .50188 .20213 .50407 .18518 .47834 Metetra
.482 .579 .876 r
.18518 .47834 .20213 .50407 .22673 .50991 .21021 .47945 Metetra
.45 .522 .84 r
.21021 .47945 .22673 .50991 .25216 .51142 .23543 .4831 Metetra
.489 .563 .857 r
.23543 .4831 .25216 .51142 .27907 .49868 .2613 .4843 Metetra
.592 .771 .965 r
.2613 .4843 .27907 .49868 .30731 .46885 .28814 .47792 Metetra
.384 .822 .675 r
.28814 .47792 .30731 .46885 .33605 .42919 .31585 .46297 Metetra
.098 0 0 r
.31585 .46297 .33605 .42919 .3645 .39083 .344 .44331 Metetra
.282 0 .197 r
.344 .44331 .3645 .39083 .39234 .3618 .3722 .42472 Metetra
.379 .05 .276 r
.3722 .42472 .39234 .3618 .4197 .34556 .40032 .4117 Metetra
.441 .111 .309 r
.40032 .4117 .4197 .34556 .44688 .34294 .42845 .40586 Metetra
.476 .137 .312 r
.42845 .40586 .44688 .34294 .47425 .35328 .45683 .40566 Metetra
.475 .117 .277 r
.45683 .40566 .47425 .35328 .50219 .37325 .48566 .40665 Metetra
.388 0 .134 r
.48566 .40665 .50219 .37325 .53095 .39481 .51501 .40293 Metetra
.51501 .40293 .53095 .39481 .56048 .4066 .54473 .39047 Metetra
.776 .823 .889 r
.54473 .39047 .56048 .4066 .59037 .40101 .57461 .37018 Metetra
.743 .68 .79 r
.57461 .37018 .59037 .40101 .62023 .38071 .60456 .34725 Metetra
.717 .654 .786 r
.60456 .34725 .62023 .38071 .65004 .35581 .63468 .32683 Metetra
.696 .676 .827 r
.63468 .32683 .65004 .35581 .68008 .33455 .66513 .31075 Metetra
.676 .715 .878 r
.66513 .31075 .68008 .33455 .71056 .31878 .69599 .29792 Metetra
.66 .743 .912 r
.69599 .29792 .71056 .31878 .74151 .30648 .72725 .28662 Metetra
.653 .755 .925 r
.72725 .28662 .74151 .30648 .77287 .29541 .75888 .27572 Metetra
.649 .758 .929 r
.06623 .48833 .08497 .50397 .10985 .49571 .09126 .47979 Metetra
.647 .756 .929 r
.09126 .47979 .10985 .49571 .13492 .48786 .11653 .47131 Metetra
.637 .747 .928 r
.11653 .47131 .13492 .48786 .16007 .48151 .14198 .46329 Metetra
.614 .721 .922 r
.14198 .46329 .16007 .48151 .18518 .47834 .16756 .45657 Metetra
.573 .666 .901 r
.16756 .45657 .18518 .47834 .21021 .47945 .19317 .45227 Metetra
.528 .593 .863 r
.19317 .45227 .21021 .47945 .23543 .4831 .21884 .45092 Metetra
.504 .542 .828 r
.21884 .45092 .23543 .4831 .2613 .4843 .24472 .45149 Metetra
.514 .544 .825 r
.24472 .45149 .2613 .4843 .28814 .47792 .27108 .45151 Metetra
.55 .617 .872 r
.27108 .45151 .28814 .47792 .31585 .46297 .29806 .44864 Metetra
.583 .777 .972 r
.29806 .44864 .31585 .46297 .344 .44331 .32564 .44224 Metetra
.447 .874 .921 r
.32564 .44224 .344 .44331 .3722 .42472 .35369 .43345 Metetra
.35369 .43345 .3722 .42472 .40032 .4117 .38207 .42391 Metetra
.38207 .42391 .40032 .4117 .42845 .40586 .41076 .41434 Metetra
.41076 .41434 .42845 .40586 .45683 .40566 .43977 .40401 Metetra
.57 .93 .937 r
.43977 .40401 .45683 .40566 .48566 .40665 .46913 .39124 Metetra
.736 .821 .917 r
.46913 .39124 .48566 .40665 .51501 .40293 .49878 .37484 Metetra
.727 .693 .817 r
.49878 .37484 .51501 .40293 .54473 .39047 .52863 .35542 Metetra
.709 .641 .779 r
.52863 .35542 .54473 .39047 .57461 .37018 .55862 .33533 Metetra
.696 .637 .786 r
.55862 .33533 .57461 .37018 .60456 .34725 .58879 .31713 Metetra
.685 .664 .824 r
.58879 .31713 .60456 .34725 .63468 .32683 .61924 .30189 Metetra
.672 .705 .871 r
.61924 .30189 .63468 .32683 .66513 .31075 .65003 .2891 Metetra
.66 .736 .906 r
.65003 .2891 .66513 .31075 .69599 .29792 .68119 .27763 Metetra
.653 .752 .922 r
.68119 .27763 .69599 .29792 .72725 .28662 .71271 .2666 Metetra
.651 .757 .927 r
.71271 .2666 .72725 .28662 .75888 .27572 .7446 .25562 Metetra
.65 .758 .929 r
.04715 .47241 .06623 .48833 .09126 .47979 .07232 .46367 Metetra
.649 .758 .929 r
.07232 .46367 .09126 .47979 .11653 .47131 .09774 .45488 Metetra
.647 .755 .928 r
.09774 .45488 .11653 .47131 .14198 .46329 .12341 .44614 Metetra
.64 .746 .926 r
.12341 .44614 .14198 .46329 .16756 .45657 .14928 .43774 Metetra
.624 .723 .917 r
.14928 .43774 .16756 .45657 .19317 .45227 .17533 .43019 Metetra
.6 .679 .896 r
.17533 .43019 .19317 .45227 .21884 .45092 .20152 .42407 Metetra
.574 .623 .863 r
.20152 .42407 .21884 .45092 .24472 .45149 .22788 .41958 Metetra
.559 .576 .828 r
.22788 .41958 .24472 .45149 .27108 .45151 .25449 .4162 Metetra
.559 .555 .806 r
.25449 .4162 .27108 .45151 .29806 .44864 .28149 .41279 Metetra
.572 .56 .802 r
.28149 .41279 .29806 .44864 .32564 .44224 .30894 .40817 Metetra
.595 .585 .811 r
.30894 .40817 .32564 .44224 .35369 .43345 .33688 .40164 Metetra
.621 .614 .823 r
.33688 .40164 .35369 .43345 .38207 .42391 .36528 .39295 Metetra
.645 .633 .824 r
.36528 .39295 .38207 .42391 .41076 .41434 .39409 .38208 Metetra
.662 .634 .811 r
.39409 .38208 .41076 .41434 .43977 .40401 .42325 .36902 Metetra
.672 .623 .791 r
.42325 .36902 .43977 .40401 .46913 .39124 .45272 .35399 Metetra
.676 .613 .778 r
.45272 .35399 .46913 .39124 .49878 .37484 .48244 .33767 Metetra
.677 .615 .779 r
.48244 .33767 .49878 .37484 .52863 .35542 .51236 .32126 Metetra
.676 .633 .799 r
.51236 .32126 .52863 .35542 .55862 .33533 .5425 .30592 Metetra
.672 .666 .835 r
.5425 .30592 .55862 .33533 .58879 .31713 .5729 .2922 Metetra
.666 .704 .876 r
.5729 .2922 .58879 .31713 .61924 .30189 .60362 .27992 Metetra
.658 .734 .906 r
.60362 .27992 .61924 .30189 .65003 .2891 .63468 .26848 Metetra
.653 .75 .921 r
.63468 .26848 .65003 .2891 .68119 .27763 .6661 .25736 Metetra
.651 .756 .927 r
.6661 .25736 .68119 .27763 .71271 .2666 .69788 .24627 Metetra
.65 .758 .928 r
.69788 .24627 .71271 .2666 .7446 .25562 .73002 .2351 Metetra
.65 .758 .929 r
.02772 .45619 .04715 .47241 .07232 .46367 .05303 .44728 Metetra
.65 .758 .929 r
.05303 .44728 .07232 .46367 .09774 .45488 .07859 .43829 Metetra
.649 .757 .928 r
.07859 .43829 .09774 .45488 .12341 .44614 .10442 .42923 Metetra
.648 .755 .928 r
.10442 .42923 .12341 .44614 .14928 .43774 .13049 .42017 Metetra
.644 .748 .925 r
.13049 .42017 .14928 .43774 .17533 .43019 .15682 .41126 Metetra
.636 .731 .917 r
.15682 .41126 .17533 .43019 .20152 .42407 .18337 .40271 Metetra
.626 .702 .9 r
.18337 .40271 .20152 .42407 .22788 .41958 .21015 .39473 Metetra
.614 .664 .875 r
.21015 .39473 .22788 .41958 .25449 .4162 .23717 .38732 Metetra
.606 .627 .845 r
.23717 .38732 .25449 .4162 .28149 .41279 .26449 .38018 Metetra
.605 .6 .82 r
.26449 .38018 .28149 .41279 .30894 .40817 .29216 .3728 Metetra
.609 .586 .802 r
.29216 .3728 .30894 .40817 .33688 .40164 .32021 .36462 Metetra
.618 .582 .791 r
.32021 .36462 .33688 .40164 .36528 .39295 .34865 .35526 Metetra
.629 .585 .786 r
.34865 .35526 .36528 .39295 .39409 .38208 .37746 .34458 Metetra
.639 .593 .786 r
.37746 .34458 .39409 .38208 .42325 .36902 .40662 .3327 Metetra
.648 .605 .792 r
.40662 .3327 .42325 .36902 .45272 .35399 .43608 .32001 Metetra
.655 .624 .806 r
.43608 .32001 .45272 .35399 .48244 .33767 .46583 .30702 Metetra
.66 .651 .83 r
.46583 .30702 .48244 .33767 .51236 .32126 .49585 .29429 Metetra
.661 .683 .86 r
.49585 .29429 .51236 .32126 .5425 .30592 .52616 .2821 Metetra
.659 .714 .889 r
.52616 .2821 .5425 .30592 .5729 .2922 .55678 .27046 Metetra
.655 .738 .91 r
.55678 .27046 .5729 .2922 .60362 .27992 .58774 .25918 Metetra
.652 .751 .922 r
.58774 .25918 .60362 .27992 .63468 .26848 .61905 .24802 Metetra
.65 .756 .927 r
.61905 .24802 .63468 .26848 .6661 .25736 .65071 .23683 Metetra
.65 .758 .928 r
.65071 .23683 .6661 .25736 .69788 .24627 .68274 .22555 Metetra
.65 .758 .929 r
.68274 .22555 .69788 .24627 .73002 .2351 .71513 .21414 Metetra
.65 .758 .929 r
.00792 .43967 .02772 .45619 .05303 .44728 .03336 .43059 Metetra
.65 .758 .929 r
.03336 .43059 .05303 .44728 .07859 .43829 .05907 .42141 Metetra
.65 .758 .929 r
.05907 .42141 .07859 .43829 .10442 .42923 .08505 .41215 Metetra
.65 .758 .928 r
.08505 .41215 .10442 .42923 .13049 .42017 .11129 .40278 Metetra
.65 .756 .927 r
.11129 .40278 .13049 .42017 .15682 .41126 .13781 .39332 Metetra
.65 .752 .924 r
.13781 .39332 .15682 .41126 .18337 .40271 .1646 .38376 Metetra
.65 .741 .917 r
.1646 .38376 .18337 .40271 .21015 .39473 .19168 .3741 Metetra
.649 .724 .904 r
.19168 .3741 .21015 .39473 .23717 .38732 .21904 .36433 Metetra
.646 .7 .886 r
.21904 .36433 .23717 .38732 .26449 .38018 .24669 .35446 Metetra
.643 .675 .865 r
.24669 .35446 .26449 .38018 .29216 .3728 .27465 .34449 Metetra
.639 .652 .847 r
.27465 .34449 .29216 .3728 .32021 .36462 .3029 .33441 Metetra
.636 .638 .835 r
.3029 .33441 .32021 .36462 .34865 .35526 .33146 .32422 Metetra
.635 .633 .831 r
.33146 .32422 .34865 .35526 .37746 .34458 .36032 .31392 Metetra
.636 .638 .835 r
.36032 .31392 .37746 .34458 .40662 .3327 .38951 .3035 Metetra
.639 .652 .847 r
.38951 .3035 .40662 .3327 .43608 .32001 .41901 .29297 Metetra
.643 .675 .865 r
.41901 .29297 .43608 .32001 .46583 .30702 .44884 .28233 Metetra
.646 .7 .886 r
.44884 .28233 .46583 .30702 .49585 .29429 .47901 .27157 Metetra
.649 .724 .904 r
.47901 .27157 .49585 .29429 .52616 .2821 .50951 .26068 Metetra
.65 .741 .917 r
.50951 .26068 .52616 .2821 .55678 .27046 .54035 .24968 Metetra
.65 .752 .924 r
.54035 .24968 .55678 .27046 .58774 .25918 .57154 .23855 Metetra
.65 .756 .927 r
.57154 .23855 .58774 .25918 .61905 .24802 .60309 .22729 Metetra
.65 .758 .928 r
.60309 .22729 .61905 .24802 .65071 .23683 .635 .2159 Metetra
.65 .758 .929 r
.635 .2159 .65071 .23683 .68274 .22555 .66728 .20439 Metetra
.65 .758 .929 r
.66728 .20439 .68274 .22555 .71513 .21414 .69992 .19274 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[126]:=",
  ImageSize->{288, 233.562},
  ImageMargins->{{3, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jA000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00;Goo`<006So
o`00]_oo00<00?ooool0Iooo002cool5001Xool00;?oo`04003ooooo000Dool2001Cool00;Coo`03
003oo`0001;oo`800003ool0000005;oo`00]Ooo0P003ooo0`000ooo0P00D_oo0033ool30006ool0
0`00ool0001Aool00<7oo`<000Soo`04003ooooo001@ool00;koo`<000_oo`04003ooooo001@ool0
0;coo`8000koo`05003oooooool0001?ool00;Woo`<0013oo`04003oooooool2001>ool00;Ooo`<0
01;oo`03003ooooo00;oo`03003ooooo00goo`<003coo`00]?oo0`000ooo00<00?ooool04?oo00<0
0?ooool00_oo00<00?ooool03Ooo00<00?ooool0>ooo002aool3000Iool00`00ooooo`02ool00`00
ooooo`0:ool5000lool008goo`@001koo`8001coo`03003ooooo00?oo`03003ooooo00?oo`@000;o
o`04003ooooo000mool008goo`03003ooooo01coo`<00003ool00?oo01_oo`03003ooooo00Coo`03
003ooooo00Woo`03003oo`0003goo`00S_oo00<00?ooool06Ooo0P008Ooo00<00?ooool01?oo00<0
0?ooool02_oo0P00?Ooo002?ool00`00ooooo`0Eool3000Sool00`00ooooo`03ool3001:ool008go
o`04003ooooo000Cool3000Vool00`00ooooo`06ool00`00ooooo`17ool008koo`8001;oo`8000?o
o`03003ooooo02?oo`03003ooooo00Koo`03003ooooo04Ooo`00Wooo0`00:ooo00<00?ooool01ooo
00<00?ooool0A_oo002Mool2000^ool00`00ooooo`08ool00`00ooooo`15ool009[oo`@002ooo`03
003ooooo00Soo`03003ooooo04Goo`00V?oo0P00<ooo00<00?ooool02Ooo00<00?ooool0A?oo002E
ool3000eool00`00ooooo`08ool00`00ool00015ool009;oo`<003Soo`03003ooooo00[oo`03003o
oooo04?oo`00T?oo0P000ooo00<00?ooool0=Ooo00<00?ooool02ooo00<00?ooool0@_oo002=ool3
000mool00`00ooooo`0<ool00`00ooooo`11ool006[oo`8001ooo`80047oo`03003ooooo00_oo`03
003ooooo047oo`00JOoo00@00?ooool001_oo`@004;oo`03003ooooo00coo`03003ooooo043oo`00
JOoo00@00?ooool001Soo`<004Koo`03003ooooo00coo`80047oo`00JOoo00@00?ooool001Koo`80
04Woo`03003ooooo00goo`03003ooooo03ooo`00JOoo00@00?ooool001?oo`<004_oo`03003ooooo
00koo`03003ooooo03koo`00J_oo0P004_oo0P000_oo00<00?ooool0BOoo00<00?ooool03_oo00<0
0?ooool0?_oo001kool3001@ool00`00ooooo`0?ool00`00ooooo`0mool007Woo`8005?oo`03003o
oooo013oo`03003ooooo03coo`00M_oo0`0000?oo`00ool0D_oo00<00?ooool04?oo0P00?Ooo001c
ool3001Hool00`00ooooo`0Aool00`00ooooo`0;ool4000/ool0077oo`8005_oo`03003ooooo01;o
o`03003ooooo00[oo`03003ooooo02goo`00K_oo0`00GOoo00<00?ooool04_oo00<00?ooool02ooo
00<00?ooool0;?oo001/ool20003ool00`00ooooo`1Jool00`00ooooo`0Cool00`00ooooo`03ool4
0004ool00`00ooooo`0[ool004Soo`@001goo`<006;oo`03003ooooo01Coo`03003ooooo00Soo`04
003ooooo000/ool004Soo`03003ooooo01coo`8006Goo`03003ooooo01Coo`8000[oo`8002goo`00
BOoo00<00?ooool06?oo0`0000?oo`00ool0I?oo00<00?ooool04ooo0`00>Ooo0012ool40004ool0
0`00ooooo`0Dool3001[ool00`00ooooo`0Eool00`00ooooo`0fool004Soo`04003ooooo000Cool2
001^ool00`00ooooo`0Eool00`00ooooo`0fool004Woo`80017oo`<00003ool00?oo06goo`03003o
oooo01Koo`03003ooooo03Goo`00F_oo0P00Looo00<00?ooool05ooo00<00?ooool0=?oo001Gool3
001eool00`00ooooo`0Gool2000eool005Coo`D007Koo`03003ooooo01Ooo`8003Goo`00D_oo0P00
Nooo00<00?ooool06Ooo00<00?ooool0<_oo001?ool3001mool00`00ooooo`0Iool00`00ooooo`0b
ool004goo`<007ooo`03003ooooo01[oo`03003ooooo037oo`00B_oo0`000ooo00<00?ooool0O?oo
00<00?ooool06_oo00<00?ooool0<Ooo000Yool3000Lool20024ool2000Mool2000aool002[oo`03
003ooooo01Soo`<008?oo`<00003YQd0000001coo`80037oo`009ooo1@005_oo0`000_oo00<00?oo
ool0O_oo0`0000BV?JhmYSf^?@8001goo`03003ooooo02ooo`008Ooo10000_oo00@00?ooool001Go
o`8008?oo`<0000:YQfV?JHMYSfV7JHmYQd00:HM000Mool00`00ooooo`0^ool002Soo`03003oo`00
01;oo`<008?oo`80000>YSf^?@00[SfV?JhmYSf^?JHm[Sd00:hmYSd001goo`03003ooooo02goo`00
:Ooo0P004?oo0P000_oo00<00?ooool0O_oo0`00012V?JHMYSfV7@00YQfV?JHMYSfV7JHmYQd00:HM
YSd001goo`03003ooooo02goo`00>?oo0`00P_oo0`0001:^?JHm[SfV?JhmYSf^?JHm002V?JhmYSf^
?JHm[SfV?@00YSd2000Lool2000^ool003Goo`<008;oo`<0000BYSfV7@00YQfV?JHMYSfV7JHmYQfV
?JHM002V7JHmYQfV?JHM0`0000>V7JHm00007Ooo00<00?ooool01Ooo0P009?oo000cool20002ool0
0`00ooooo`1mool300004ZhmYSf^?JHm[Sd00:hmYSf^?JHm[SfV?JhmYSf^?@00[SfV?@<00007YSd0
0:Hm[SfV?Jhm00007?oo00<00?ooool01?oo00@00?ooool002?oo`00<?oo0`00POoo0`0001:V?JHM
YSfV7JHmYQfV?JHMYSd00:HmYQfV?JHMYSfV7JHmYQd300002ZHMYSfV7JHm002V?JHMYSfV7@007Ooo
00<00?ooool00ooo00@00?ooool002?oo`00;_oo0P00P_oo0P0001>^?JHm002V?JhmYSf^?JHm[SfV
?JhmYSf^?@00[SfV?JhmYSf^?@0200003ZHm[Sd00:hmYSf^?JHm002V?JhmYSf^?JHm000Mool00`00
ooooo`02ool01000ooooo`008ooo000[ool300000ooo003oo`1nool300004ZGMYSfUgJHm002V?JHM
YSfV7JHmYQfV?JHMYSfV7@00YQfV?@<0000?YSfV7JHmYQfV?@00YSfV7JHm002V?JHMYSfV7JHm0080
01coo`03003ooooo00;oo`04003ooooo000Sool002Woo`8000Goo`03003ooooo07Woo`<0000BYSf^
?JHm[SfV?JhmYSf^?@00[SfV?JhmYSf^?JHm[SfV?Jhm0`0000n^?JHm[SfV?JhmYSf^?JHm002V?Jhm
YSd00:Hm[Sd00`0000>^?JHm00006ooo0P001?oo0P009?oo000Vool30021ool200004ZGLYSd00:Hm
YMfV?JGMYSfUgJHmYMfV?@00YSfV7JHmYQfV?@<0000?YSfUg@00YQfV?JHMYSfV7JHmYQfV?JHM002V
7JHm00<00006YSfV7JHmYQfV?@007Ooo00<00?ooool09ooo000Sool30002ool00`00ooooo`1lool3
00004JhmYOf^?JGm002V?JhmYSf^?JHm[SfV?JhmYSd00:Hm[Sd00`0000n^?JHm[SfV?JhmYSd00:Hm
[SfV?JhmYSf^?JHm[Sd0100000VV?JhmYSf^?JHm[SfV?Jhm00007?oo00<00?ooool09ooo000Qool2
0021ool300004JHmYMbV?JGLYSfUg:HmYM`00:GMYSfUgJHmYMfV?JGMYSd00`00012V?JGMYSfUgJHm
YMfV?JGMYSd00:HmYQfV?JHMYSfV7@D0000;YQd00:HMYSfV7JHmYQfV?JHMYSd0000Lool00`00oooo
o`0Vool001ooo`8007[oo`D0000Fool00000002]oJGl002UoJhmYOf^?JGm[SfUoJhmYOd00:Hm[SfV
?JhmYSd200004:hmYOd00:Hm[SfV?JhmYSf^?JHm[SfV?Jhm002^?JHm100000n^?JHm[Sd00:hm002^
?JHm[SfV?JhmYSf^?JHm00007?oo00<00?ooool09_oo000Oool2001fool500000j77XPP000020000
4ZGmYMbUoJGLYOd00:HmYMbV?JGLYSfUg:HmYMbV?@00YSfUg@<0000?YMbV?JGLYSfUg000YMfV?JGM
YSfUgJHmYMfV?JGM00@0000AYSfUgJHmYMfV?JGMYSd00:Hm002V?JHMYSfV7JHmYQfV?@02000Lool2
000Vool001ooo`03003oo`0007;oo`<00004P0200H00P04300004ZgmYOb]oJGl[OfUo:gmYOb]o@00
[SfUoJhmYOf^?JGm[SfUo@<0000@YOf^?JGm[SfUoJhmYOf^?JGm002V?JhmYSf^?JHm[Sd300004Jhm
002^?JHm[SfV?JhmYSf^?JHm[Sd00:hm002^?JHm[Sd00`0000>^?JHm00006ooo0P009_oo000Oool0
1000ooooo`00KOoo1@0000B00GP0P05h0080000CYObUW000YMbUoJGLYOfUg:GmYMbUoJGLYOd00:Hm
YMbV?JGLYSd00P00012Ug:Gl002V?JGLYSfUg:HmYMbV?JGLYSfUg000YMfV?@@0000@YMbUoJGLYOd0
0:HmYMfV?JGMYSfUgJHmYMd00:HMYSd300001jHmYMfV?JGMYSfUg@0001_oo`03003ooooo02Coo`00
7_oo0`000_oo00<00?ooool0Iooo0`0000HP01P000000801P00300004ZGl[OfUo:gmYO`00:Gl[OfU
o:gmYOb]oJGl[OfUo000YOf^?@<0000?[OfUo:gmYOb]o@00[SfUoJhmYOf^?JGm[SfUoJhm00@0000@
YOf^?JGm[SfUoJhmYOd00:Hm[SfV?JhmYSf^?JHm[Sd400002JHm[SfV?JhmYSf^?JHm[Sd0000Lool0
0`00ooooo`0Sool001koo`03003ooooo00?oo`03003ooooo06Coo`<00005400P0100001h00030000
4ZFLYObUW:GlYIbUo:FLYO`00:GmYMbUoJGLYOfUg:GmYMbUo@<0000?YObUg:GlYMbUo:GLYObUg000
YMbV?JGLYSfUg:Hm00@0000?YM`00:GLYOfUg:GmYMbUoJGLYOfUg000YMfV?JGM00@0000>YSfUg000
YMd00:GMYSfUgJHmYMfV?JGMYSd001coo`03003ooooo02;oo`007_oo00<00?ooool01?oo00<00?oo
ool0HOoo0`0000<P00000000100001>UVjFl002]oJGl[OfUo:gmYOb]oJGl[Od00:gmYOb]oJGl[OfU
o00200003jflYI`00:Gl[OfUo:gmYOb]oJGl[OfUo000YOf^?@0400003ZGl[OfUo:gmYO`00:Gm[SfU
oJhmYOf^?JGm[Sd400004JGm[SfUoJhmYOf^?JGm002V?@00YSf^?JHm[SfV?JhmYSd00P006ooo00<0
0?ooool08_oo000Nool00`00ool00005ool00`00ooooo`1Mool700005WT:00000000YKbUVjFlYI^U
_000YObUW:GlYIbUo:FLYObUW:Gl002UoJGL0`0000jUVjflYI^]_:FK002Ug:GlYMbUo:GLYObUg:Gl
100000nUg:glYMb]o:GL[ObUg:gl002UoJGLYOfUg:GmYM`00P0001:]o:GL002Ug:HmYMbV?JGLYSfU
g:Hm002V?JGM002UgJHmYMd300000jGLYSd0000Jool2000Sool001koo`8000Ooo`8005_oo`H0000F
N@/00000002U_:FKYKbUVjFlYI^U_:FK002Uo:gmYOb]oJGl[OfUo:gmYO`300003jFL[KbUW:flYIb]
_:FL[K`00:gmYOb]oJGl[OfUo00300003jfK002Uo:gmYOb]oJGl[OfUo:gmYOb]o@00[SfUo@030000
4:Gl[OfUo:gm002^?JGm[SfUoJhmYOf^?JGm[Sd00:hm100000JV?JhmYSf^?JHm000Lool00`00oooo
o`0Pool001koo`03003ooooo00Soo`03003ooooo05Koo`D0000GH8UH:@00002UNjEK002UVjFlYI^U
_:FKYKbUVjFlYI/00:FLYObUW:GlYIbUo00200003jEJ[G/00:flYI^]_:FK[KbUVjflYI^]_000YObU
g00300004:FK[K^UVjfkYI/00:GL[ObUg:glYMb]o:GL[ObUg:gl0P00016Ug:glYMb]o:GL[ObUg:gl
002V?JGLYSfUg:HmYMbV?JGL00@00009YSfUg:HmYMbV?JGLYSfUg00001_oo`03003ooooo023oo`00
2ooo0P001?oo0P000ooo10000ooo00<00?ooool02_oo00<00?ooool0Dooo1@0001IHR@0000000:EK
YG^UFjEkYE/00:FKYKbUVjFlYI^U_:FKYKbUV`00YOb]o@<0000?[G^UFjekYE/00:FL[KbUW:flYIb]
_:FL[KbUW:fl0080000A[I^]_:fK[Kb]Vjfl[I^]_000[OfUo:gmYOb]oJGl[OfUo00200004Jfk002]
oJGl[OfUo:gmYOb]oJGl[Od00:hmYOf^?JGm[Sd00P0000fUo:gm002^?@00[SfV?JhmYSf^?JHm[Sd0
000Lool00`00ooooo`0Oool000[oo`04003ooooo0008ool00`00ooooo`04ool00`00ooooo`0;ool0
0`00ooooo`1Aool700004ZEKYG^UFjEkYE^UNjEKYG/00:FlYI^U_:FKYKbUVjFlYI^U_0<0000?[G^U
FZekYEZ]NjEJ[G^UFP00YI^]_:FK[KbUVjfl00<0000A[GX00:fkYI^]^jFK[K^UVjfkYI^]^`00[ObU
g:glYMb]o00200004:fK[K^]V`00YMb]o:GL[ObUg:glYMb]o:GL002Ug:Hm0`0000j]oJGL[OfUg:gm
002V?@00YSfUg:HmYMbV?JGL0P007?oo00<00?ooool07_oo000:ool01000ooooo`002Ooo00<00?oo
ool00ooo0P003Ooo00<00?ooool0Cooo1@0001>U6ZDk002UNjEKYG^UFjEkYE^UNjEKYG/00:FlYI^U
_:FKYKbUV`0200003jdjYAX00:EK[G^UFjekYE^]NjEK[G^UF`00YIb]_00400004JeJ[GZ]FP00[I^]
_:fK[Kb]Vjfl[I^]_:fK[K`00:gmYO`00P0000n]^jfK[K^]Vjfk[I/00:Gl[OfUo:gmYOb]oJGl[Od0
0`0000n]oJGl[OfUo:gmYOb]oJGl002V?@00YSf^?JHm[Sd00P0000>UoJhm00006ooo0P001ooo1000
5?oo0004ool40002ool01000ooooo`002_oo00<00?ooool00_oo00<00?ooool03Ooo00<00?ooool0
C?oo0`0001BU>YdJYCZM6ZDjWAX00:EKYG^UFjEkYE^UNjEKYG^UFjEk002U_:FK0`0000jU6JdjYAV]
>P00[G^UFZekYEZ]NjEJ[G^UFZek1@00012]NZeJ[GZ]FZej[EX00:FK[K^UVjfkYI^]^jFK[K^UV`<0
000?[I^]^jfK[K^]Vjfk[I^]^jfK002Ug:glYMb]o:GL0080000>[K^]V`00YMb]oJGL[OfUg:gmYMb]
oJGL002Ug0@00006[SfUg:hmYMb^?@006_oo0P001ooo00<00?ooool05Ooo000:ool01000ooooo`00
2?oo00@00?ooool000?oo`03003ooooo00koo`03003ooooo04Woo`80000EYCX00:DkYAZU>jDJYC^U
6ZDkYAX00:EKYG^UFjEkYE^UNjEKYG^UFjEk0080000>YAZ]>ZDJ[CZU6ZdjYAZ]>P00[G^UFjekYE^]
N`<0000C[G/00000[EZ]NZeJ[GZ]FZej[EZ]NP00[Kb]Vjfl[I^]_:fK[K`00P0000n]FKEj002]^jfK
[K^]Vjfk[I^]^jfK[K/00:gmYO`00`0000j]Vjgl[I^]o:fK002Uo:gmYOb]oJGl[OfUo:gm100000RU
oJhmYOf^?JGm[SfUo@007?oo00<00?ooool01Ooo00<00?ooool05?oo000;ool2000:ool20004ool0
0`00ooooo`0?ool00`00ooooo`15ool300005IdJYCZM6ZDj002U>YdJYCZM6ZDjWAZU>YdJ002UFjEk
YE^UNjEKYG^UF`0300003:DI[CZU6JdjYAV]>ZDI[CZU6@00YEZ]N`<00003[G^UFP000080000?[EZ]
NZeJ[GZ]FZej[EZ]NZeJ[GX00:fkYI^]^jFK0080000?[GZ]6Jej[AT00:fK[K^]Vjfk[I^]^jfK[K^]
Vjfk0080000?[I^]^jfK[K^]Vjfk[I^]^`00[OfUg:gmYMb]oJGL0080000=[Ob]f`00002^?JGL[SfU
g:hmYMb^?JGL00006ooo00<00?ooool01_oo00<00?ooool04ooo000Lool3000Aool00`00ooooo`11
ool300005ZDJYCZU6ZDjYAZU>ZDJ002U6ZDkYAZU>jDJYC^U6ZDkYAX00:EKYG^UFjEk0P0000bTfJdi
Y=T00:DJ[CZU6ZdjYAZ]>ZDJ[CX300000jekYE^]N`0200004:dI[CV]6@00[EZ]NZeJ[GZ]FZej[EZ]
NZeJ002]Vjfl0P0000n]FKEj[EVeNZeI]GZ]F@00[I^]^jfK[K^]Vjfk[I/00P0000jeNP00[Ob]Vjgl
[I^]o:fK[Ob]Vjgl002]oJGl0`001Jgl0P0000N^?JGm[SfUoJhmYOf^?@02000Kool00`00ooooo`03
ool01000ooooo`005?oo000Lool00`00ooooo`0Bool00`00ooooo`0nool200005idI002M6ZDjWAZU
>YdJYCZM6ZDjWAX009dJYCZM6ZDjWAZU>YdJYCX00:EkYE/00P0000^TnJCIY?VTfJCi002]>ZDI[CZU
6Jdj00<00004[CX00:ekYEX200004:di[AV]>JdI[CT00:ej[EZ]NZeJ[GZ]FZej[EZ]NZeJ0P0000n]
NZdI[GZ]6Jej[AV]NZdI[GZ]6@00[I^]^jfK[K/00P0000j]FKEj[ET00:fK[K^]Vjfk[I^]^jfK[K^]
Vjfk0P0000n]fjgl[M^]o:gK[Ob]fjgl002^?@00[SfUg:hmYM`00P0000>]o:GL00006ooo00<00?oo
ool00ooo0P005Ooo000Lool00`00ooooo`0Cool00`00ooooo`0jool300005ZDjYAZU>ZDJ002U6ZDj
YAZU>ZDJYCZU6ZDj002U>jDJYC^U6ZDkYAZU>jDJ0`0000^TfJdiY=V]>JCI[CVTfJdi002]>ZDJ0080
0005[CZU6ZdjYAZ]>P0200004:dI[CV]6Jdi[AV]>JdI[CT00:ej[EZ]NZeJ[GZ]FZej0P0000ne6000
[EVeNZeI]GZ]FKEj[EVeNZeI]GX00:fk[I/00P0000jeN[EJ]GZeF[Ej]EX00:fK[Ob]Vjgl[I^]o:fK
0P0000>e^`00[O`02:gl00<00:hm00000`0000F]o:hm[Ob^?@0001[oo`8001coo`007?oo00<00?oo
ool05?oo00<00?ooool0=_oo0`0001NU>YdIYCZM6JDjWAVU>P00YCZM6ZDjWAZU>YdJYCZM6ZDj002U
>YdJYCZM6ZDj0080000;Y=P00:CIY?VTfJCiY=VTnJCIY?VTf@0300001JDI[CZU6JdjYAT00`00022]
6Jdi[AV]>JdI[CV]6Jdi[AT00:eJ[GZ]FZej[EZ]NP00]CV]6;Di002]NZdI[GZ]6Jej[AV]NZdI[GZ]
6Jej0P0001j]FKEj[EVeNZeI]GZ]FKEj002]^jfK[K^]Vjfk[I/00:fJ]KZ]VP00[M^]o:gK[Ob]fjgl
[M^]o:gK[O`200002JGL[ObUg:glYMb]o:GL[O`0000Kool00`00ooooo`0Iool001coo`8001Koo`03
003ooooo037oo`@0000GYCZU6P00YAZU>ZDJYCZU6ZDjYAZU>P00YCZU6ZDjYAZU>ZDJYCZU6P00YAZU
>`0300002ZCiY=VTnJCI002TfJdiY=V]>JCI0`0000JTf@00YAZ]>ZDJ[CX200004JcH[?V/f000[AV]
>JdI[CV]6Jdi[AV]>JdI002]FZej[EX00P0000ne>KDH]CVe6;Di002eNZeI]GZ]FKEj[EVeNZeI]GX0
0P0000jeF[Ej]EZeN[EJ]GZeF[Ej]EZeNP00[Ob]Vjgl0P0000JeV[Fk]IZe^kFJ0007[O`300002Zgl
002]o:hm[Ob^?Jgl[Sf]o0006ooo00<00?ooool06Ooo000Lool00`00ooooo`0Fool00`00ooooo`0]
ool3000069dJYCZM6ZDjWAZU>P00YCZM6JDjWAVU>YdIYCZM6@00WAZU>YdJYCZM6ZDjWAZU>P<0000:
Y?VTf:CiY=RTnJCHY?T00:CiY=T300001jCIY?VTfJCi002]>ZDI0080000A[?R/f:ch[=R/n000[CV]
6Jdi[AV]>JdI[CV]6Jdi002]NP0200003jdH]CV]6;Di[ARe>JdH002]6Jej[AV]NZdI[GZ]6@020000
3[Di]AP00:eI]GZ]FKEj[EVeNZeI]GZ]F@00[I/200003KFj[IZe^ZfJ]KZ]V[Fj[IX00:gK[Ob]fjgl
0080000>[I^enjfK002Ug000YMb]o:GL[ObUg:glYM`001_oo`03003ooooo01Soo`007?oo00<00?oo
ool05ooo00<00?ooool0:_oo0P0001VU6P00YAZU>ZDJYCZU6ZDjYAZU>P00YCZU6ZDjYAZU>ZDJYCZU
6P00YAZU>ZDJYCZU6P0200002ZCi002TnJCIY?VTfJCiY=VTnJCI0`0000RTfJdiY=V]>JCI[CVTfJdi
0P0003n/f:ci[=R/nJcH[?V/f:ci002]>JdI[CV]6Jdi[AV]>JdI[CT00;Di]ARe>KDH]CVe6;Di]ARe
>KDH002]FKEj[EVeNZeI002e6;ei]ARmN@00]GZeF[Ej]EZeN[EJ]GZeF[Ej]EX00;FJ]K^eV[Fk]IZe
^kFJ]K^eV[Fk00000Zgl0P0000fenkFK]O^eVkGk002^?Jgl002]o:hm[Ob^?@0200000jgl003oo`0J
ool00`00ooooo`0Gool001_oo`03003ooooo01Woo`8002Ooo`<0000HYCZM6ZDjWAX009dJYCZM6ZDj
WAZU>YdJ002M6JDjWAVU>YdIYCZM6JDj002U>YdJ0`0000VLV:BiW9RT^@00Y?VTf:CiY=P00`0000VT
f000Y=VTnJCIY?VTfJCiY=T00`00016/f:ch[=R/n:cH[?R/f:ch[=P00:dI[CV]6Jdi[AV]>JdI0080
000O]CP00;Di[ARe>JdH]CV]6;Di[ARe>JdH002]6Jej[AT00;DH]CVe6;Di]ARe>@00]GZ]FKEj[EVe
NZeI]GX00P0000beF000[IZe^ZfJ]KZ]V[Fj[IZe^ZfJ]KX200003JfK]O^]VkGk[I^enjfK]O/00:gl
002]o:GL00800005[Ob]g:gl[M`0000Jool2000Hool001_oo`8001coo`03003ooooo027oo`<0000H
YC^U6ZDkYAZU>jDJYC/00:DjYAZU>ZDJYCZU6ZDjYAX00:DJYCZU6ZDjYAZU>ZDJ0`0000VTV:CiY9RT
nJBHY?VTV000Y=T00`00032TfJCiY=VTnJCI002TfJdiY=V]>JCI002/f:ci[=P00:cH[?V/f:ci[=R/
nJcH[?V/f000[AV]>JdI[CV]6@00]ARe>KDH002e6;Di]ARe>KDH]CVe6;Di]ARe>@00]GX200007;DH
_GVe6;ei]ARmNKDH002eF[Ej]EZeN[EJ]GX00;ei_EVmN@00]K^eV[Fk]IZe^kFJ]K^eV[Fk0P0000be
VkGk]I^enkFK]O^eVkGk]I/00:gl[Sd200001jgl]Sb]o;Hl[Obf?00001_oo`03003ooooo01Koo`00
6ooo00<00?ooool07?oo00<00?ooool07_oo0P0001VUNjEK002M6ZDjWAZU>YdJYCZM6ZDj002U>YdJ
YCZM6ZDjWAZU>YdJ002M6JDjWAVU>P0200002IbH002LV:BiW9RT^IbHY;VLV00300003:CHY?VTf:Ci
Y=RTnJCHY?T00:CiY=VTn@80000B[=R/n:cH[?P00:ch[=R/n:cH[?R/f:ch[=R/n000[CV]6Jdi0P00
01ne6;Dh]ARe>;DH002]6;Di[ARe>JdH]CV]6;Di[ARe>@00]CVe6;Di]ARe>KDH]CVe6;Di]AP00:eI
]GZ]F@0200003;ei]ERmNKEH_GT00;Fj[IZe^ZfJ]KZ]VP80000<_KVeF@00[I^enjfK]O^]VkGk[I^e
njfK0P0000Z]o000[Ob]g:gl[Mb]o:gL[O`001_oo`03003ooooo01Goo`006ooo00<00?ooool07Ooo
00<00?ooool06ooo0P0001VUFjEkYE^UN`00YC^U6ZDkYAZU>jDJYC^U6P00YAZU>ZDJYCZU6ZDjYAZU
>P00YCZU6P0200002JBiW9RT^IbH002TV:CiY9RTn@0200003:BHY?T00:CiY=VTnJCIY?VTfJCiY=VT
n@<0000A[?V/f:ci[=R/nJcH[?T00:ci[=R/nJcH[?V/f:ci[=R/n@0300004KDi]ARe>KDH]CVe6;Di
002e>KDH]CVe6;Di]ARe>KDH]CT00P0000be6;ei]ARmNKDH_GVe6;ei]ARmN@00]GX200006[eI_GVm
FKei_EVmNKeI002eV[Fk]IZe^kFJ002mVKfj_IVm^P00]O^eVkGk]I^enkFK]O/200003KFJ002]o000
[Obf?:gl]Sb]o;Hl[Obf?00001[oo`03003ooooo01Goo`006ooo00<00?ooool07_oo00<00?ooool0
5ooo0`0001RUNjEKYG^UFjEkYE^UN`00YCZM6ZDjWAZU>YdJYCZM6P00WAZU>YdJYCZM6ZDjWAX30000
29bHY;VLV:BiW9RT^@00Y;T30000=:BiW9RT^IbHY;T00:CiY=RTnJCHY?VTf:CiY=P00:cH[?R/f:ch
[=R/n:cH[?R/f000[=R/n:cH[?R/f:ch[=R/n:cH002e6;Dh]ARe>;DH]CRe6;Dh]ARe>000]CV]6;Di
[ARe>JdH0P0002RmNKeH002e6;Di]ARe>KDH]CVe6;Di]ARe>@00_GVeF;ei]ERmNKEH_GVeF;ei]EP0
0:fJ]KZ]VP00]EVm^KEI_KVeFKfi002enjfK]O^]V`80000<_OZeV[gj]IX00:gL002]g:gl[Mb]o:gL
0P0000>f?000ool06Ooo00<00?ooool05?oo000Kool2000Pool00`00ooooo`0Bool400006JFlYI/0
0:EKYG^UFjEkYE^UNjEK002U6ZDkYAZU>jDJYC^U6ZDk002U>ZDJYCZU6ZDj00800008W9T009bHY;VL
V:BiW9RT^@<0000?Y?VTV:CiY9RTnJBHY?VTV000Y=VTnJCIY?VTfJCi00<0000A[?V/f:ci[=R/nJcH
[?V/f:ci[=P00:cH[?V/f:ci[=R/n@0200008;fI002e6;Di]ARe>KDH]CVe6;Di]AP00;DH]CVe6;Di
]AP00;eIaGVmFLEi002mNKDH_GVe6;ei]ARmNKDH_GT200003;eI_GVmFKei_EVmNKeI_GVmFKei002e
^`80000:_IVm^[fI_KZmVKfj_IT00;FK]O/200003;FJ_O^eV[gk]IZmn`00]Sb]o000[Obf?0800004
]O^n?;Gk000Jool2000Eool001[oo`03003ooooo027oo`03003ooooo00goo`@0000JYI^U_:FKYKbU
VjFl002UNjEKYG^UFjEkYE^UNjEK002M6ZDjWAZU>YdJYCZM6ZDj002U>P<00007W;VLV9biW9P009bH
Y;T00`00012T^IbH002LV:BiW9RT^IbHY;VLV:BiW9P00:CHY?VTf080001>[?V/f:ci002/n:cH[?R/
f:ch[=R/n:cH[?P00:ch[=R/n:cH[?P00;fj]EVm^P00]CRe6;Dh]ARe>;DH]CRe6;Dh]AP00:dH]CV]
6000_ERmNKeH_GVmF;ei002e>KDH]CVe6;Di]ARe>@00aKVmV000]ERmNKEH_GVeF;ei]ERmNKEH_GT0
0;fi]EVm^KEI_KVeFKfi]EVm^KEI0P0000bmn[FJ_OZeV[gj]IZmn[FJ_OX00:gl[M`200001kHl]M^f
?;GK]Sbef`0001[oo`03003ooooo01?oo`002?oo0P001?oo0P000ooo1@000_oo00<00?ooool08_oo
00<00?ooool02_oo0P0001^]oJGl002UVjFlYI^U_:FKYKbUVjFl002UNjEKYG^UFjEkYE^UNjEK002U
6ZDkYAZU>jDJYC/00`0000NT^IbIY;VLVJBiW9VT^@0300004JBiW9RT^IbHY;VLV000Y9RTnJBHY?VT
V:CiY9RTn@00Y?T00P0002J/fJdi[=V]>JcI002/f:ci[=R/nJcH[?V/f:ci[=R/n@00[?V/f:ci002m
^[fI_KZmVKfj002e>KDH]CVe6;Di]ARe>KDH]CT00;Di0P0003BmFLEi_EW5NKeIaGVmF@00]ARmNKDH
_GVe6;ei0035^LFIaKT00;ei_EVmNKeI_GVmFKei_EVmN@00aKT00;fj_IVm^[fI_KZmVKfj_IT00<FI
002eV[gk]IZmnkFJ_O^eV[gk]IZmn`<00008_Sbenkhl]O^n?;Gk_S`001_oo`03003ooooo01;oo`00
1ooo00@00?ooool000[oo`03003ooooo00;oo`03003ooooo02?oo`03003ooooo00Ooo`80000IYIbU
o:FLYO`00:FlYI^U_:FKYKbUVjFlYI/00:EKYG^UFjEkYE^UNjEKYG/00:DjWAX0100000NL^IBI002L
V9biW9RL^@0300004Ybi002T^IbHY;VLV:BiW9RT^@00Y;VLV:BiW9RT^IbHY;VLV080000D[?V/f:ci
[=R/nJcH[?V/f000[=R/n:cH[?R/f:ch[=R/n:cH002/f080000P_KZeFKfj]EVm^[EI002e6;Dh]ARe
>;DH]CRe6;Dh]ARe>000_GVmF;ei_ERmNKeH_GVmF;ei_EP00;DH]CVe6080000<aKVmV<Fi_IS5^@00
_GVeF;ei]ERmNKEH0P0001O5^LFH002eFKfi]EVm^KEI_KVeF@00aIW5^@00_OZeV[gj]IZmn[FJ_OZe
V[gj0080000;]M^f?000]SbefkHl]M^f?;GK]S`0000Kool00`00ooooo`0Aool000Ooo`04003ooooo
000:ool00`00ooooo`02ool2000Uool00`00ooooo`03ool300006:gmYOb]oJGl[OfUo:gm002U_:FK
YKbUVjFlYI^U_:FK002UFjEkYE^UNjEKYG^UF`<00008W9VL^IbIW;VLVIbi002T^@<0000CY;VLVJBi
W9T009bHY;VLV:BiW9RT^IbHY;T00:CiY9RTnJBHY?T00P0002NU6@00[=V]>JcI[CV/fJdi[=V]>@00
[?V/f:ci[=R/nJcH[?V/f:ci[=P00;fI_KZmVKfj_IVm^[fI_KZmV@00]ARe>KDH]CVe6;Di]AP00`00
03>mFLEi_EW5NKeIaGVmFLEi_EW5N@00_GVe6000aIW5^LFIaKW5VLFiaIT00;eI_GVmFKei_ET00<FI
aKW5VLFiaIT00;fI_KZmVKfj_IT00<FIaKW5VLFi002mnkFJ_O^eV[gk]IX00P000/Gj00P00;Gk_S`0
0;hl]O^n?;Gk0P0000>n?000ool06Ooo0P002Ooo0`001_oo00000ooo000000020002ool01000oooo
o`002_oo00<00?ooool00_oo00<00?ooool09Ooo00<00?ooool00P0001NUoJGL002UW:GlYIbUo:FL
YObUW:Gl002U_:FKYKbUVjFlYI^U_000YG^UFjEk00@00008U9T009BIW;VDVIbiU9VL^@<0000CW;VL
V9biW9RL^IbHW;T00:BiW9RT^IbHY;VLV:BiW9P009bHY;T00`0001F]>JDI[CVU6@00[=R/nJcH[?V/
f:ci[=R/n@00[?R/f:ch[=R/n:cH[?P00`0001nm^[EI_KZeFKfj]EVm^[EI_KX00;Dh]ARe>;DH]CRe
6000aY_6_<JK002mF;ei_ERmNKeH_GVmF;ei_ERmN@020000=kfHaKVmV<Fi_IS5^KfHaKVmV000]ERm
NKEH0035V<FiaIS5^LFHaKT00;fi]EVm^KEI0035VLFiaIW5^LFI002eV[gj]IZmn[FJ002mfLGj_MW5
nP00]SbefkHl002f?;GK002n6khk_Q^n>`0001Woo`8000[oo`03003ooooo00Goo`001ooo00@00?oo
ool000[oo`03003ooooo00;oo`03003ooooo02Koo`80000EYOb]oJGl[OfUo000YOb]oJGl[OfUo:gm
YOb]o@00YKbUVjFlYI^U_:FK00@00009W?ZLfIcjW=VLnYcI002LVIbi00<0000CW;VLV@00W9VT^IbI
Y;VLVJBiW9VT^@00Y;VLV:BiW9RT^IbHY;T00`0002V]>ZDI[CZU6JdjYAV]>P00[CV/fJdi[=V]>JcI
[CV/f@00[=R/nJcH[?V/f:ci002n_Kjl_[d00;fj_IVm^[fI_KZmVKfj_IVm^P00]CVe6;Di0080000L
a[c>_<Jlc[`00<Ei_EW5NKeIaGVmFLEi_EW5NKeI0035VLFiaIW5^LFIaKW5VLFiaIW5^@00_GT20000
6<FIaKW5VLFiaIW5^LFIaKT00;fj_IT00<FIaKW5VLFiaIW5^LFI002eV[gk]IX000K5nP03002n?;Gk
00<00006_S^n?;hk_Sbn>`006ooo00<00?ooool01?oo1@001_oo0008ool2000:ool20003ool00`00
ooooo`0Tool300004jGmYMbUoJGLYOfUg:GmYM`00:FLYObUW:GlYIbUo:FL002UVjFl00@0000:U=ZM
>P00W?ZDVIcjU9VLnYBIW?X3000059biU9VL^IBIW;VDV@00W9RL^IbHW;VLV9biW9P009bHY;VLV:Bi
W9P200006:Dj002]>JDI[CVU6JdiYAV]>JDI[CT00:ci[=R/nJcH[?V/f:ci[=P00:cH[?R/f080000@
_[fnW;jm_Y`00;EI_KZeFKfj]EVm^[EI_KZeF@00]AP200003lJlaY_6_<JKa[c6VlJl002mNKeH_GVm
F;ei_ERmN@0200009<Ll002mV<Fi_IS5^KfHaKVmV<Fi_IS5^@00aKW5V<FiaIS5^LFHaKW5V<FiaIP0
0;EI0035VLFiaIW5^LFIaKW5VLFi002mnP800009_MW5n[gIaOZmfLGj_MT00;GK00<00008_Q^n>khK
_S^n6khk_Q/001[oo`03003ooooo00Coo`04003ooooo0007ool001Woo`80027oo`@0000A[SfUo@00
YOb]oJGl[OfUo:gmYOb]oJGl002Uo:gmYOb]o@05000039dkW=ZM>icJWC^LfP00W=VLnYcIW?ZLf@@0
000BW;VLVIbiW9VL^IbIW;T00:BiW9VT^IbIY;VLVJBiW9T009bH0`0001RU6JDjYAVU>P00[CZU6Jdj
YAV]>ZDI[CZU6@00[=V]>JcI[CV/fJdi[=V]>@00[?T20000<;jl_[fn_;jm_[bn_Kjl002mVKfj_IVm
^[fI_KZmVKfj_IT00<Jlc[c6_<jla[c>_<Jlc[c6_000_EW5NKeIaGVmFLEi003??LLmccd00<FiaIW5
^LFIaKW5VLFiaIW5^@80000GaIW5^LFIaKW5VLFiaIW5^LFIaKW5V@00aIW5^LFIaKW5VLFiaIW5^LFI
aKT0000:aOX03@00_S^n?;hk002n>khl_S^n?;hk_Sbn>`0001[oo`03003ooooo00Coo`03003oo`00
00Ooo`006Ooo00<00?ooool07Ooo0`00012Ug:HmYMbV?JGLYSfUg000YMbUoJGLYOfUg:GmYMbUo@D0
000>WG^M6iekWA/009CJWCZDfYdjU=ZM>YCJ002DV@<0000CU9VLnYBI002DVIbiU9VL^IBIW;VDVIbi
002L^IbHW;VLV9biW9P00`0001VU6JDjYAVU>ZDIYCZU6@00YAV]>JDI[CVU6JdiYAV]>JDI002/f:ci
[=R/nJcH[?V/f00200004Kjm_Ybn_KjL_[fnW;jm_Ybn_@00_KZeFKfj]EVm^[EI_KX0100000g6VlJl
aY_6_<JKa[c6VlJlaY/00;eH_GVmF00200003<lmacc??LLlccd00<Fi_IS5^KfHaKVmV080000<c_c>
n`00aIS5^LFHaKW5V<FiaIS5^LFH0P0001o5^LFIaKW5VLFiaIW5^LFIaKT00<gi0035n[gIaOZmfLGj
_MW5n[gI0035f@00_Q^n>khK002n6khk_Q^n>`0200000khK003oo`0Iool00`00ooooo`04ool20007
ool001Woo`03003ooooo01_oo`80000AYSf^?@00[SfUoJhmYOf^?JGm[SfUo@00YOb]oJGl[OfUo002
00004:FlWI`009eKWGbMFielWE^MO000WC^LfYdkW=ZM>icJ0`0001:LfIcjW=VLnYcIW?ZLf@00W9VL
^IbIW;VLVIbiW9T009bIY;T400006YcIY?X00:DjYAVU>ZDIYCZU6JDjYAT00:DI[CZU6JdjYAV]>ZDI
[CX00:di[=V]>JcI[CT200004IMmUgh00;jm_[bn_Kjl_[fn_;jm_[bn_@00_KZmVKfj_IT01`0000[6
_<jla[c>_<Jlc[c6_<jl0035N@80000>acg??LLmccg7?Llmacd00<FIaKW5VLFiaIT000C>o00E0035
^LFIaKW5VLFiaIW5^LFI003>>/ij0035^LFIaKW5VLFiaIW5^@0000;=n@030035n/Gj00G5nP0@0036
>LhjaST00;hk_S`00;hl_S^n?000aW_6>lIk000Iool2000?ool001Woo`03003ooooo01Woo`80000A
YSfUgJHmYMfV?@00YSfUg:HmYMbV?JGLYSfUg000YMbUo@0200003ifLYKbMW:Fl002MNidKWG^M6iek
WA^MN`00WCZDfP0300004YCJWCX009cjU9VLnYBIW?ZDVIcj002L^IBIW;VDVIbiU9VL^@<0000KW?ZL
fIcjW=VLnYcI002U6JDjYAVU>ZDIYCZU6JDj002]>JDI[CVU6JdiYAV]>JDI[CT00:ci00<0000AUgf?
OIMmSgfGO@00_[fnW;jm_Ybn_KjL_[fnW000]EVm^P0200000kAD]5D0000400002<JlaY_6_<JKa[c6
VlJlaY/20000<Llmacc??LLlccg7?<lmacc??LLl002mV<Fi_IP00<kkc_c>nlklc__>o000aKW5V<Fi
aIS5^LFH003>6LijcQT00<FIaKW5VLFiaIW5^@00cOW=fLgicMT00;gIaOZmfLGj00800008aMW>>/GI
cSX00;hk_Q^n>`<00006aS^n6lHk_Q_6>`006_oo00<00?ooool03?oo000Iool2000Gool300004:Hm
[SfV?JhmYSf^?JHm[Sd00:hmYOf^?JGm[SfUoJhm0`0000jU_9fLYKbMW:FlWIbU_000WGbMFielWE^M
O9eK0`00016LfYdkW=ZM>icJWC/009cjW=VLnYcIW?ZLfIcj002L^IbI00@0000KW;X00:CjW=VTnYcI
Y?ZLfJCjW=T00:DIYCZU6JDjYAVU>ZDIYCX00:djYAV]>ZDI[CZU6Jdj00T00009UgjGOIMn002n_Kjl
_[fn_;jm00D00006_7FdE;ae]5BlMKAD100000?>_<Jlc[`0100000kMmNGf003??LLmccg7?Llmacg?
?LLmccd00<Fi0P001lkl00D00<FIaKW5VLFi00800009cS[>N/hjcW[>>P00aIW5^LFI008000K=n@0=
0035n/Gj003>>/HicS[6>LhjaSW>>P00_S`00`0000S6NlHkaW_6>lIkaS_6N`006Ooo00<00?ooool0
3?oo000Hool2000Dool400003jHMYSd00:HmYMfV?JGMYSfUgJHmYMfV?@00YSfUg00400003ZGmWM`0
09fLYKbMW:FlWIbU_9fLYK`009ekWA/300003YdKWG/009djU=ZM>YCJWCZDfP00U9VLnYBIW?X60000
7IBIW;VDVIbiU9VL^@00W?ZLfIcjW=VLnYcIW?X00:DjYAVU>ZDIYCZU6JDjYAT00:DI[CVU6JdiYAT0
0`0000QReF[EH]EZeF;E002;EH^e2@0000^T5J?EY1D00;AE]5BdEKAD]5FdE;AE00800003cA@00000
00800007cCG=5<de003Mm]fEgOH00P0000G7?<lmacc??LLl00@0000jc_c>nlklc__>o<kkc_c>nlkl
c_/00<FHaKT00<ijcQW>N/hIcW[>6Lij0035^LFI003=fLgicMW=nLgIcOW=fLgi0035nP00cS[5fLhj
aMW>>/GIcS[5fLhj0036>khK002n6lHk_Q_6>khKaS/00<ik000Iool00`00ooooo`0;ool001Soo`03
003ooooo013oo`<00007[SfV?JhmYSf^?JHm[Sd00P0000NV?JhmYSf^?JHm[SfV?@0300003jGlYOfU
o:GmYObUoJGl002MW:FlWIbU_9fLYKbMW00300002YeKWGbMFielWE/009cJWC^LfYdk1`00022D^IAI
U;VDF@00U9VL^YBIW;ZDVIbjU9T009cIY?ZLfJCjW=VTnYcIY?X00:DjYAVU>ZDIYCZU6JDjYAT00:DI
0`0002lj5D8F001ZmV;EJ_IReF[f002;]X^ERkJ;UH^fRiD00:@EY3FT5J@eY1FT=J@E002dE;ae]5Bl
MKAD_7D00<Cfa=H00<dEeCG=5MDecAGE=@00iOKMmNGfgOD00>Ge00D00003mg800000008000W>o00<
0035^@00cW[>>/ijcS[>N/hjcW[>>/ij0P002/gi01<00<hjaSW>>/HicS[6>LhjaSW>>P00eWX00<Ik
aS/00<HkaW_6>`0200000likaW/0000Iool2000<ool001Soo`03003ooooo00koo`80000?YSfV7@00
YQfV?JHMYSfV7JHmYQfV?JHM002UgJHm00@0000@YMbUo@00YOfMg:GmWMbUoIgLYOfMg000WIbU_9fL
YK`200001YfL002M6iekWA^MN`L0000TU5V<FIAI002DFHaIU5V<FIAIS5VDF@00W;VDVIbiU9VL^IBI
W;VDV@00W=VLnYcIW?ZLfIcjW=VLnP00YCZU6JDjYAVU>ZDI100003L04@00000b5@00H]EZeF;EJ]ER
e@00ReF;]H]ERkF;EH^e002T5J?EY1FSeJ@EXmFT5@00]5FdE;AE]5BdEKAD002leLCf003==LdDcCG=
5<decA@00=fEgOKMUMgfgID00?JDm[GfU?Je003oLP0200002i@F00000<klc__>o<kkc_c>nlklc_/0
0P0001G>N/hIcW[>6LijcQW>N/hIcW[>6@00cMW=nLgIcOW=fLgicMW=nLgIcOT00P0001S5fLhjaMW>
>/GIcS[5fLhj003>>/hI002n6lHk_Q/00;hK0036FlikaU_>NlIK000Iool00`00ooooo`0:ool001So
o`03003ooooo00coo`80000>YSf^?JHm[SfV?@00YSf^?JHm[SfV?JhmYSf^?@<0000@YSfUoJHmYOfV
?JGmYSd00:GmYObUoJGlYOfUo:GmYO`400000jFl0000000500009iBjS9ZD^P00U7V<FIAiS5VDNHaI
U7T009BiU5VD^IAIU;VDFIBi002L^YBIW;ZDVIbjU9VL^P00Y?ZLfJCjW=VTnYcIY?ZLf@00YAVU>P04
00001=Gg003=5/ef0P0002h0e000>QD006;EJ_IReF[f002;]X^ERkJ;UH^fRiD00:@EY3FT5J@eY1FT
=J@EY3D00;ae]5BlMKAD0034e/Cfa=H00<dEeCG=5MDecAD00=geiOKMmNGfgOGUmP800003m[Cn]@00
00<00005W1JL=`00RgH00003c_`700001lijcS[>N/hjcW[>>/ij00800003acd00<gi00O=n@0K003F
N/hi0036>LhjaSW>>/HicSX00=IjcSWFN/hi0036>lIkaS/00<IkcW_6NlikaW_>N`0001[oo`03003o
oooo00Woo`006?oo0P002_oo0`0000jV?JHMYSfV7JHmYQfV?JHM002V7JHmYQfV?JHM0P00016V?JGM
002Ug:GmYMbUoJGLYOfUg:Gm002UoIgLYOfMg:Gm00L0000[U?^<fYCk002D^XbIU;Z<VIBjS9VD^P00
U5V<FIAIS5VDFHaI002<FIAIS5VDFHaIU5V<F@00U9VL^IBIW;VDVIbiU9VL^@00W?ZLfIcjW=VLnYcI
W?X00`0000SEmlfGeOO=U`00cAG==/dE0P000300e000@QD006[EH]EZeF;EJ]D008^eReF;]H]ERkF;
E@00XmFT5J?EY1FSeJ@EXmD00;AD]5FdE000_=G4m[cEa?Jle@00cAC==LdDcCD00=gfgIGMm]fEgOKM
U@00kYD300002>mb002D5Y`FU1JL5P00ReD300000h]E0000000500006/ijcQW>N/hIcWX00<Lmacc7
?@00cOW=fLgicMW=nLgIcOT00=IicQWFN@00cS[5fLhjaMT200001lhjcQW>>/hIcSX00<Hk00<00008
cW_6FlikaU_>NlIKcW/001[oo`03003ooooo00Soo`006?oo00<00?ooool01Ooo100000n^?JHm002V
?JhmYSf^?JHm[SfV?JhmYSd00:Hm[Sd00P001JHm00/00:GmYSfUoJHmYOfV?JGmYSd00:Gm00D0000^
WGbMG000U=^E>iCKUC^DfiDk002D^XbJU;Z<VYBjS9X008aIU7V<FIAiS5VDNHaI002DFIBiU5VD^IAI
U;VDF@00U9VL^YBIW;ZDVIbjU9T009cIY?ZLfJCjW=T200003=GheOOEn=GgeOSEm`00cAK=M/dFcGK=
5P8000100=@00000H]EZmV;EJ_IRe@00RiF;]X^ERkJ;UH^f002T=J@EY3FT5J@eY1FT=@00_7FdE000
a=K4m/CFa?K4e/Cf003E=LdEeCD00>GfgOGUm]geiOKMm@00m[Kfm_Jfm_H00?Nc002L=i`FW3NL5P00
PeF;MX=ERgJ3E@00JY@500002lhjcW[>>/ij003??LLmccg7?Llm00001Lgi01l00=IjcSWFN/hieWX0
0<hjaST00<hieW[>>MIjcSWFN/hieWX00<ikaW_>N`00cW_6NlikaW_>N`00c[/0000Iool00`00oooo
o`08ool001Soo`03003ooooo00;oo`<00007YQfV?JHMYSfV7JHmYQd00P0000NV?JHMYSfV7JHmYQfV
?@0300003jHmYMfV?JGMYSfUgJHmYMd00:GLYOfUg:GmYMbUo@040000;iELWGbEG9elUEbMO000U?^<
fYCkS=ZDnhcJ002<VIBjS9VD^XbIU;Z<V@00S5VDFHaIU5V<FIAI002DFHaIU5V<FIAIS5VDF@00W;VD
VIbiU9VL^IBIW;VDV@00W=T00`0000k^4`00003EmlfGeOO=UmGg003==/dEcCK=5Ldf0P0004<0/`3D
001ZeF;EJ]EReF[E002;]H]ERkF;EH^eReD00:?EY1FSeJ@EXmFT5J?E002dE;AE0034m[cEa?JleLCf
_=G4mP00cCG=5000gIGMm]fEgOKMUMgf003fm^jEm_H00>nc002L5Y@FW1JD5Y`F002;EH=EReF3EH]E
PeD006:D002<60030000;/hI00000<Lmacc7?LLlacg7?000cMW=nLgIcOT00=IicQWFNLhIeWW>6@00
aMT00<hIcS[>6LhjcQW>>/hIcSX00=Ij003>NlIKcW/00<ikaU_>N`00c[_6F`006Ooo0P002Ooo000G
ool00`00ool0000300003jHm[Sd00:hmYSf^?JHm[SfV?JhmYSf^?@00[SfV?@0400000jhmYSd00009
YSd00`00YOfV?@040000;iglYOd009elWEbMO9eLWGbMG9el002E>iCKUC^DfiDkU=/008bJU;Z<VYBj
S9ZD^P00U7V<FIAiS5VDNHaI002DFIBiU5VD^IAIU;VDFIBi002L^YBIW;ZDVIbjU9T00`00017^=?Hd
kS@00>FDkO@00=GheOOEn000cGK=5/efcAK=M/dF00800080e080000DJ_IReF[fH]D008^ERkJ;UH^f
RiF;]P00Y3FT5J@eY1FT=J@EY3FT5@80000Za?K4e/Cfa=K4m/CFa?K4eP00cAD00=geiOKMmNGfgOGU
mP00m_Kf]_Kfm[H00>mb002L5Y`gW1JL=i`F0023EH]fPeF;MX=ERgH006Zd002DNHaI0`0000[7?Llm
acg??LLmccg7?Llmacd000;=n@0J003FN/hieW[>>MIjcSWFN/hi003>>MIjcSWFN/hieW[>>MIj003F
N]IieWX00<ikaW_>N`<00005c[_>NljkcW/0000Eool300000ooo003oo`08ool001Ooo`800007YSfV
7JHmYQfV?JHMYSd00P0000NV7JHmYQfV?JHMYSfV7@0300001jGMYSfUgJHmYMfV?JGM00800007YSfU
gJHmYMfV?JGMYSd00`0002nMoIfLWOfMW9gmWIbMo@00WGbEG9elUEbMO9EL002<fYCkS=ZDnhcJU?/0
09BjS9VD^XbIU;Z<V@00S5VDFHaIU5V<FIAIS5T008aIU5V<FIAIS5VDFHaI002DVIbi00H00015kQ?^
=>hCkS@00>FdiI<00<fGeOL00<dfcAG==/dEcCK=5@00a=@0002c0=@0/`00H]EZeF;EJ]ERe@00ReF;
]H]ERkF;EH^e002T5J?EY1FSeJ@EXmFT5@00a?JleLCf_=G4m[cEa?JleLCf003==@00gOKMUMgfgIGM
m]fE003^UOKfkYD00>mb00800013W1JD5Y`FU1JL5Y@F0023EH]EPeF;EH=E001RU6ZD002<F@00BQDj
5000acc7?LLlacg7?<Lmacc7?@00cOT00=IicQWFNLhIeWW>6MIicQT00<iJ003>6LhjcQW>>/hIcSX0
0=IjcUWFN/iI0036FlikaU/00<IKc[_6FljkaU_>^lIK00004?oo10001?oo00<00?ooool01ooo000G
ool200003:Hm[SfV?JhmYSf^?JHm[SfV?@00YSf^?@@0000=YSf^?@00[SfV?JhmYSf^?JHm[SfV?Jhm
00000ZHm10000ZGm02d009glYOfMo:GmWObUoIgl002MG9elWEbMO9eLWGbMG000U=^E>iCKUC^DfiDk
002D^XbJU;Z<VYBjS9X008aIU7V<FIAiS5VDN@00U;VDFIBiU5VD^IAIU;T01`0001On]000mSC^=?Hd
kS@00>FDkOCUU000eOL00<dFcGK=5/efcAK=MP00c?G<e0000080e0<0000@J_IReF[f002;]X^ERkJ;
UH^fRiD00:@EY3FT5J@eY1D300006<CFa?K4e/Cfa=K4m/CFa?K4e/Cf003Um]geiOKMmNGfgOD00?Jf
m_Kf]_Kf003g/`80000@W1JL=i`FW3NL5Y`g002;MX=ERgJ3EH]f001Z]6ZDJ[@200002DXDBQE:5000
acg??LLmccg7?@0400009MIjcSWFN/hieW[>>MIjcST00<ijeW_>NP00cSWFN/hieWX00=IjeWWFN]Ii
eW[FN@00aW/00<ik003>NljkcW_>^lik003>^`0000coo`<000Soo`03003ooooo00Ooo`004?oo0P00
1Ooo00`00?oo002V7JHmYQfV?JHMYSfV7JHmYQd200001jHmYQfV?JHMYSfV7JHm00800007YMfV?JGM
YSfUgJHmYMd0100002jUoIgMYOfMgJGmWMd009fLWOfMW9gmWIbMoIfL002EG9elUEbMO9ELWG`009Ck
S=ZDnhcJU?^<fP00S9VD^XbIU;Z<VIBj002DFHaIU5V<FIAIS5VDF@00U5V<F@@0001>USjF7YHnUQjF
?P00mW?fD`00kQ?^=>hCkS@00>FdiI?U]>FC003=5LdfcAG==/dEcCK=5@00a=C<m@000=@0/`3D001B
e`00J]ERe@00ReF;]H]ERkF;EH^e002T5J?EY1FSe@00[9J/]jbF002leLCf_=G4m[cEa?JleLCf_=D0
0=fEgOKMUMgfgIGMmP00m_K^UOKf003_/nmb0P00016L5Y@FW1JD5Y`FU1H008=EReF3EH]EPeD006:D
JYARU6ZD00800003>QA:5CXD00D000Ano`0V003FNLhIeWW>6MIicQT00<iJeW[>F]Ij003>>/hIcSX0
0=IjcUWFN/iIeW[>FMIjcUT00<IKc[_6F`00aU_>^lIK0036VljlaY/000Soo`<000coo`03003ooooo
00Koo`003ooo00@00?ooool000Coo`03003ooooo00800005[SfV?JhmYSf^?@0200003ZHm002V?Jhm
YSf^?JHm[SfV?JhmYSd00:Hm[Sd70008YOd03@00WObUoIglYOfMo:GmWO`009eLWGbMG9el00H0000>
U=^E>iCK002<VYBjS9ZD^XbJU;X009AiS5VDN@H00007USjN?iHnWSnF?YhoUSh00P0001[n]?Ic003^
=?HdkSCf=000kOCUU>gdiIC]m000cGK=5/efcAK=M/dF003<e<cec=C<m@000P3D04H004[GD_L006[f
002;]X^ERkJ;UH^fRiD00:@EY3FT5@00[9Nd]jbG];L00<Cfa=K4m/CFa?K4e/Cfa=H00=Gg003MmNGf
gOGUm]ge003f]_Kfm[H00>mb002TEjAg002L=i`FW3NL5Y`g002;MX=ERgJ3EH]fPeD006ZDJ[AZU6Zd
001:5DXDBQE:508000Mno`0N003FN/hieW[>>@00cW[FNlijeW_>N]Ik003FNP00eW[FNMIjeWWFN]Ii
eW[FN@00e[X00<ikc[/00<jk0P0000G>^ljlc[_>_00000Coo`@000ooo`03003ooooo00Koo`003ooo
00@00?ooool000Coo`8000?oo`03002V?JHM0080000=YSfV7JHmYQd00:HMYSfV7JHmYQfV?JHMYSd0
1P0001:UgJHmYMfV?@00YOfMgJGmWMfUoIgMYOfMg@00WIbMoIfLWOd700001XbkQ9Z<^`00Q5YlF@h0
000<S?^<fhckS=/009HNUSjF7YHnUQjF?YHN0P0001[fLoICmW<00>hdkQ?^=>hC003UTnFdiI?U]000
gG@00<dfcAG==/dEcCH00<cea=C<mLCD0P0000D0e000D]M:UU;G00<00006RkF;EH^eReF;]H]E0`00
036/UZbg[9J/]jbF002leLCf_=G4m[cEa?Jle@00cIOEn000gOKMUMgfgID00>jEm_K^U@00kg;_/`00
Y5NLEP00U1JL5Y@FW1JD5Y`F002;EH=EReF3EH]E001ZU6:DJYARU00200001DXE>QA:5@008A<00`00
17ko02D00<hIeWW>6@00cU[FN/iJeW[>F]IjcU[FNP00eW[>FMIjcUWFN/iIeW[>F@00eYWF^P00c[_6
Fljk003>_<JKc[c6VljlaY_>_004000Cool00`00ooooo`06ool000ooo`04003ooooo0003ool20005
ool200003JHm[SfV?JhmYSf^?JHm002V?JhmYSf^?JHm00D000RV?@03002UoJGm00FUo@D0000PUGbE
G9ElUE`008BKS?^4VhckQ9/008AJQ7Z4FXAjQ5Z4NP00Q7Z4FXAjQ5Z4NXAJ002<fhclS=^<o8cKS?b<
f`80000SWSnF?YhoUSh00?kc003fLojdmW<00>hdmSC^=?Hd003]m>FDkOCUU000gE@00<dFcGK=5/ef
003<mLcDc?G<e<cec=@000020=@01@00D_M:ee;gB]L0200003>d]jbG];N/UkBg[9Nd]jbG0034e/Cf
a=K4m/CFa?H00=GheOOEn000iOKMmNGf003fm_Jfm_H00?Nc002TMjAGY7L009`gW1JL=i`FW3NL5P00
PeF;MX=ERgJ3E@00JYAZ]6ZDJ[@00P0000I:54XEBQA:5@00:A<600009gko003>>@00cW[FNlijeW_>
N]IkcW[FN`00c[/00=IjeWWFN]IieW[FN@00e[[N^]Jjg[X00<jk003>_000c[c>^ljlc[_>_<jkc[`0
000Eool00`00ooooo`06ool000ooo`04003ooooo0003ool00`00ooooo`05ool03000YSfV7JHmYQfV
?JHMYSfV7@00YQfV?@@0000?YQfV?JHM002UgJHmYMfV?JGMYSfUgJHm002UoIgM00@0000YWOfMW000
SEbEO8eLUGb=G9El002<^hBJS;^4VXbkQ9X007aIQ5YlFHAJO5T008AIQ5Z4FHAJQ5V4FP00S?^<fhck
S=^<nhcKS?^<fhck002F?P0200007_Kc003fDoIcmU?fL`00kSC^4nhd003U]>FCiKCUTnFd003MM=eC
003=5LdfcAD00<CDc?G4e<cea=C<m@8000120;<004ZFD]M:UU;G002<68_GS1R;eh`HRmL00:bF[;N/
UZbg[9J/]jbF[;L00<Cf_=G4m[cEa?H00=GhcIOEn<fG003MUMgf003fm^jEm_H00>nckg8009aFY5NL
EZAG002L5Y@FW1JD5Y`F002;EH=EReF3EH]E001ZU6:DJYARU6ZD0P0000Lj54XE>Q@001Sb0000LP02
00000`aK15/0000200001liJeW[>F]IjcU[FN/iJ00800007cW_>FP00cUWFN/iIeWX00P0000oFVMJj
eYWF^]JIe[X00<jlaY_>_000c[c6VljlaY/00P0000?6_000ool04ooo00<00?ooool01_oo000@ool2
0004ool00`00ooooo`06ool200001ZHm[SfV?JhmYSf^?@@00008YSf^?JHm[SfV?JhmYSd000NV?@<0
000/WIfMoIfMWOfMWIgm002EO9ELUGbEG9ElUEbEO000S?^4VhckQ9^<n`00Q7Z4FXAjQ5Z4NXAJ0024
FXAjQ5Z4NXAJQ7X008clS=^<o8cKS?b<fhclS=^<o08000;nl`0M003n]?Ico[@00?HdkSCf=>hd003U
U>gdiIC]m>FD003ME>Ed003=M/dFcGH00<cec=C<mLcDc?G<e0030000;03D001:ee;gB]MBm`00S3R;
eh`hRmN<>8_G002/UkBg[9Nd]jbG];N/UkBg0034m/CFa?H00=GheOOEn=GgeOSEm`00gOD00?Jfm_Kf
]P00kg800:AGY7L5000049`gW1JL=i`F0023EH]fPeF;MX=E001ZU6ZdJYAZ]6ZD0P0000I:5DXDBQD0
02TC8A<20000:`1B000000AK37/4F`00cW[FNlijeW_>NP00cW_>^likc[_>N`00eWWFNP00g[[F^]jj
e[[N^]Jjg[X00=kk003>_<jk003>^ljlc[/00<Jlc[c6_00001Coo`03003ooooo00Koo`005_oo00<0
0?ooool02?oo00<00:HMYSd0100000jV7@00002V?JHMYSfV7JHmYQfV?JHM002UgJHm100002fMgJGm
002MoIfLWOfMW9gmWIbMo@00UGb=G9ElSEbEO8eL0024VXbkQ9Z<^hBJS;/008AJO5V4FWaIQ5X008AJ
Q5V4FXAIQ5Z4FHAJ002<nhcKS?^<fhckS=/00`0002;flokcm_<00?ICmW?fD`00kQ?^=>hCkS@00>Fd
iI?U]>FC003MDmedgE?MM000cCH00<cea=C<mLCDc?G4e<ce003<m0<0000OD]M:UU;GBYH008_GS1R;
eh`HRmN<6000[;N/UZbg[9J/]jbF[;N/UP00_=G4mP00eOS=UmGhcIOEn<fGeOP00P0000K^UOKfkYD0
0>mbkk<300001I=DTe>CE000Ra@0100001BD5P00PeF;EH=EReD006ZDHYAZU6:DJY@0057C001:5CXD
000HlR4C0P0000<04@0000000P0001h<F`00eW[>F]IjcUX00<iJcW_>F/ikcU[>N`00eWX00=JjeYWF
^]JIe[[FVMJj003Nn]Kj0036VljlaY/300001/JLa[c6W<JlaY`001Coo`03003ooooo00Goo`005_oo
0P002_oo0`0000jV?JhmYSf^?JHm[Sd00:hmYSf^?JHm[SfV?Jhm0`0002nV?JGmYSfUoJHmYOfV?@00
WOfMWIgmWIfMoIfMWOd009ElUEbEO9ELUGbEG000Q9^<nhBKS?^4V`00Q5Z4NXAJQ7Z4FXAj0024NXAJ
Q7Z4FXAjQ5Z4NP00S?b<fhcl00<00003oc@00?kc00;nl`0O003n]?Ico[@00?HdkSCf=000kOCUU>gd
iIC]m000iGCME>EdgE@00<dF003<e<cec=C<mLcDc?D00<cdc9@00`0003=:ee;gB]MBm`00S3R;eh`h
RmN<>8_G002/UkBg[9Nd]jbG];N/UkBg0034m/CF003EmmGheOOEn=GgeOSEmmGh003fm_Jfm_H00?Nc
002CM9=DTgBCE9=dTe@008<DRcB358/dPa@00P0001>;MX=ERgJ3EH]f001Z]6ZDJ[AZU000BM<004XD
BQD002TC8A<Y4`020000100A000000;i0`0001[FN`00003>NljkcW_>^likc[_>Nljk003N^]Jjg[[F
^]jje[[N^P00g__Fn]kke_X00<jk0`0000S6_<jla[c>_<Jlc[c6_0004ooo00<00?ooool01Ooo000F
ool00`00ooooo`07ool200002_oo002V7JHmYQfV?JHMYSfV7JHm0P0000>V7JHm00000P00032V?JGM
002MgJGmWMfUoIgMYOfMgJGm002MoIfLWOfMW9gmWI`008eLUGb=G9ElSEbEO000S;^4VXbkQ9Z<^hBJ
001lFHAJO5V4FWaIQ5X008AJQ5V4FXAIQ5Z4F@00S=/400009Oldmc<00?Kco_<00?IcmU?fLoIC003^
4nhdkQ<00>FCiKCUTnFdiI<00=eCgGCMDmedgE<00<CDc?G4e<cea=C<mLCD0034Tlcd00@0000DBYIB
edZFD]L008`HRmN<68_GS1R;e`00[9J/]jbF[;N/UZbg[9J/]`80000:cIOEn<fGeOS=UmGhcIOEn000
icT600003I=CTeBCDi=DTe>CE000RaB34h/DPa>;58<C0080000BReF3EH]EPeD006:DJYARU6ZD001A
ddWC000j54XE000Q4aSb0P0000<0DP0000000P0002@2f@00003>NliJcW_>F/ikcU[>NliJcW/00<ik
003F^]JIe[[FVMJj003Nn]Kjg_[Fn]kje_X00<JLa[c6W000aYc6_<JLa[`200000kjL003oo`0Aool0
0`00ooooo`05ool001Goo`03003ooooo00Goo`<000Coo`800007[SfV?JhmYSf^?JHm[Sd00`001ZHm
0P0000bV?JGmYSfUoJHmYOfV?@00WOfMWIgmWId=00003XBKS?/008AjQ5Z4NXAJQ7Z4FP00Q5Z4NXAJ
Q7X400001YHn00000000oc@000?nl`0R003fLojdmW<00>hdmSC^=?Hd003]m>FDkOCUU000gECUM=eD
iGCME>Ed003<mLcDc?G<e<cec=@00<bDc?C<U000[5D2000095;gB]MBmd[G002;eh`hRmN<>8_GS3P0
0;Bg[9Nd]jbG];N/UkBg[9L00=GgeOSEmmGheOOEn=GgeOP00>LjicWW>^Li0037]080000TTgBCE9=d
TeBCM9=DTg@008/dPaB;=8<DRc@007[d002;MX=ERgH006ZdJYAZ]6ZD0019de8DBM<004XD000Q4bTC
8A<0000A0`0002<2V@000]T2n@00c[_>NljkcW_>^likc[/00<jkcW_>^`00g[[F^]jj003NnmKjg__F
n]kke_X00=Lk0036_<jl003>_<Jl00800004a[fn_<Jm000Bool00`00ooooo`05ool001Goo`03003o
oooo00;oo`<000Woo`03002V?JHM00@0000@YSfV7@00YMfV?JGMYSfUgJHmYMfV?@00YOfMgJGmWMd7
00002XeLSGf=G000O9]l^gbKO;]lV`000g@J3P0000BN?YHNWSjF7P<0000Ymc?o=000o_?flokc003f
LoICmW<00>hdkQ?^=>hC003UTnFdiI?U]000gGCMDmedgE?MM=eC0034e<cea=C<mLCDc?D00<cda9?<
m<BC002/E@03000044ZFD]M:UP00RmN<68_GS1R;eh`H002/]jbF[;N/UZbg0P0003NeV@00cIOEn<fG
eOS=UmGhcIL00>KiicWVn@00ak@009^CVk@009=DTe>CE9=CTeBCD`00Pa>;58<CRaB34`00L]=je000
ReF3E@00HYAZU6:DJYARU000BM=Ad`00BQD0024C6?8Q4`0005804@0300002@:I000000;I003>NliJ
cW_>FP0200005LikaU[>NlIJcW/00=Jj003Nn]Kjg_[Fn]kje_X00=Kjgc_FnP00aYc6_00200001kjL
a[fnW<Jm_Yc6_@00017oo`03003ooooo00Goo`005Ooo00<00?oo00000P003Ooo0P0000RV?JhmYSf^
?JHm[SfV?@001jHm1@0019gm024009EmSEbEOHeLUGf=G000O9]l_7bKO;alV`00M1Yd>g@JM3]d6W@k
0024^gaKQ;]lFhBkO5/009HnWSnF?YhoUSh0100000?o=000o_<00_kc01D00?jdmW?n]?Ic003^=?Hd
kS@00>FDkOCUU>gdiI@00=eDiGCME>EdgE@00P0000g<mLcDc?G<e<cec=@00<bDc?C<U<cd002dMP02
0000@Q[I001:ee;g002<>8_GS3R;eh`hRmL00:bG];N/UkBg002m^[FI_KX00=GheOOEn=GgeOSEm`00
icWW>^Li0037]000ViBK]9^D002CE9=dTeBCM9=DTg@008/dPaB;=8<DRcB35000N]=jm000RgH006Zd
JYAZ]6ZDJ[@0058DBM=B508000068A<Y4b4C:A<0001B0P0000@04P000YT:nP80000IcW_>^lik003>
NljkcW_>^likc[_>Nljk003NnmKjg__Fn]kke_X00=Lkgc_G>mlkec/00P0000[6_@00a[fn_<Jm_[c6
_Kjla[d0013oo`03003ooooo00Goo`005Ooo0P004Ooo00`00:HmYQfV?JHMYSfV7JHmYQd00:GMYSd4
00005igMYOd009gmWMfMoIgMWOfMgIgm002=OHeLSGf=G8em001l^gbKO;]lVgbk00001W@J00`007aJ
O;]lFWbkO5Yl^gaJ002F7YhnUQh40000:oldmc<00?Kco_?fl`00mU?fLoIC003^4nhdkQ?^=000iKCU
TnFdiI<00=eCgGCMDmedgE?MM000gC@00<cea=C<mLCD0034Tlcda9?<m<BC002/EKAE0080000N4]T0
04ZF002;eh`HRmN<68_GS1P00:bg[9J/]`00_KZeVKfj]IVm^P00eOS=UmGhcIL00>KiicWVnNLi0P00
026KTi^dVi>K]000TeBCDi=DTe>CE9=C00234h/DPa>;58<CRa@007[DL]=je000ReD006ZDHYAZU6:D
0019de7CBM<00P0000dQ4aSb8A<HlP000140DP00018000:J0YT2VP0200008LiJ0036F/ikaU[>NlIJ
cW_6F/ik003>^`00g_[Fn]kje_X00=Kjgc_Fn]lke_X00<lk002nW<Jm0036_KjLa[fnW00200000kjm
003oo`0>ool00`00ooooo`05ool001Koo`03003ooooo013oo`800006YSf^?JHm[SfV?Jhm0`0000RV
?JGmYSfUoJHmYOfV?@001Ygm020008eLUGf=G9EmSEbEO@00O;alVgblO9]l_000M3]d6W@kM1Yd>g@J
001lFhBkO5^4^gaKQ;]lF`00USh00;Kn0`000_ld02d00?kco_?nl`00o[CfLojd003f=>hdmSC^=000
iIC]m>FDkO@00>EdgECUM=eDiGCME000eA<00<cDc?G<e<ce003<m<bDc?C<U<cd002dMP00_7@001[j
6]T00`0000J;eh`hRmN<>8_GS3P30000:Kfj]IVm^[FI_KZeV@00eOOEn=Gg003W>NLjicWW>P00ckD0
09^dViBK]9^D002CE9=dTeBCM9=DTg@008/dPaB;=8<DRcB35000N]=jm7[CN_@00P0000UZU6ZdJYAZ
]000DQA9de8DBM<00P0000<Y4b4C:A<00P0001404@0001804P002_X2V@[j0YT00<ikc[_>NljkcW_>
^lik008000;>^`0;003Fn]kke_X00=Lkgc_G>mlkec/00002ec`01P00a[fn_000_[c6_@800004][fn
_KJm000@ool00`00ooooo`04ool001Ooo`8001;oo`03002V7JHm00<0000OYSfUg@00WMfUoIgMYOfM
gJGmWMfUo@00WOfMgIgmWMfMoIgM002=G8emSEb=OHeLSGd007bkO9]l^gbK00001W@J00P007bkO5Yl
^gaJO;]lFWbk0P0000>foP0000000P0002Wo=000o_?flokc003fLoICmW?fD`00kQ?^=>hC003UTnFd
iI?U]>FC003MDmedgE?MM=eC003E4mdd003<mLCDc?G4e000a9?<m<BCc?C4Tlcd00800006_5>lE000
6]XBfA[J200003JeVKfj]IVm^[FI_KZeVKfj]IT00<fGeOP00>Lii_WW>@00ck@009^dVi>K]9^CVk@0
09=DTe>CE9=CTeBCD`00Pa>;58<CRaB34h/D001je7;CN]Abdg[D001ZU6:DJYARU000BM=AddWCDM<2
00000aSb8A<HlP020000101B0140000B0`0001H2V@:J0YT00<IJcW_6F/ikaUX00<iJc[_>F/jkcUX0
0=Kj003Fn]lke_[O>`800007cc_G?<lkec`00<Jm_Y`00P0000Nn_KIM_[ffGKjm]Ud0000?ool00`00
ooooo`04ool001Woo`03003ooooo013oo`8000JV?@800008YSfUoJHmYOfV?JGmYSd000BMo@/0000?
O9]l_7bK001d6W@kM1Yd>g@JM3/008BkO5^4^gaK00800003]cjfo[Ln00<000;o=019003nlokco_<0
0?Ico[CfLojd003f=>hdmS@00>gdiIC]m>FDkO@00>EdgECUM=eDiG@00=edeA<00<cDc?G<e000c9C<
m<bDc?C<U<cdc9@00;aD_7BlE0006]TJnQ[I6_X008clQ=^<o8CKS?b4f`00]IVm^[FI_KZeVKfj]IVm
^P00eOP00>LjicWW>P00ckD00P0001VKU9^dViBK]9^D002CE9=dTeBCM9=DTgBCE000PaB;=8<DRcB3
5000N]=jm7[CN_Ajd`0200003VZdJYAZ]000DQA9de8DBM=B5000:A<Q4bTC8A<200001P1B00004P0B
000kFP8000072_X00<jkcW_>^lik00001ljk00H00=Lkgc_G>mlk0007ec`200002;Jm002f_Kjm][fn
_KJm_[d2000>ool00`00ooooo`04ool001[oo`03003ooooo013oo`0>002UgJHmYMfV?JGMYSfUgJHm
002UoIgMYOfMg@L0000;SEf=_HeM001TW7BlI9ad_6BL001T6P040006M1X00`00O5Yl^`020004]_h2
0000Bnmg003g<old003nloKco_<00?IcmU?fL`00kSC^4nhdkQ<00>FCiKCUTnFd003MM=eCgGCMDmed
gE<00=DCgCCE4`00a=C<m@00c?C4Tlcda9?<m<BCc?@00;aD_5>lE;aC000BfA[J4]T008CKS?^4fhck
Q=^<n`00_KZeVKfj]IVm^[FI_KZeVKfj003W>NKiicWVn@0200006j?d002K]9^CVkBKTi^dVi<009=C
TeBCDi=DTe>CE000RaB34h/DPa>;5000N]Abdg[DL]=je00200002F:DJYARU6ZD001AddWCDM=9d`02
00000b4C6?8Q4`020000200A0000000B000kFS=J>eX300003<ik00000<iJc[_>F/jkcU[>^liJ003F
nP800008gc/00=Llcc_G?<lkecc?>`800008ccd00;jm002n_KIM_[ffG@800003]Wd00?oo00goo`03
003ooooo00Coo`006ooo00<00?ooool04?oo00<00:HmYSd01ZHm100019gm014009FmSEfE_HeMUKf=
G@00M9ad_7BLM;adW000I1]/>f@K00X00005]cjfo[Ln]_jg?P040002oc@01`00o_?nlokc003n]?Ic
00<0000UkSCf=>hdmS@00>gdiIC]m>FD003ME>EdgECUM=eD003E4medeA?MM000c?D00<cdc9C<m<bD
c?C<U<cdc9@00;aD_7BlE;ad_5@00P00010JnQ[I0024fhclQ=^<o8CKS?`00;fj]IVm^[FI_KZeV@80
0004ach00000icT200009j?dXi<009^DVkBKU9^dViBK]000TgBCE9=dTeBCM9=D002358/dPaB;=8<D
Rc@007[dN]=jm7[C001RD`00JYAZ]6ZD0019de8DBM=B500200001b4C:A<Q4`008E<0000A00800006
018003]k>eXkNc]J0P001ljk0P001=Kk00<00=Llec`01=Ll00L00<llccg??<lm002n_@0400001Jim
]Wf^OKIm00003Ooo00<00?ooool01?oo000Lool2000Aool01P00YMfV?JGMYSfUg@80000RYSd009gm
WMfMoIgMWOfMgIgm002=_HeMSKf=GHfm001d_6BLM;aTW7Bl001T6f@JI1]T6V@K001l^gBKO;]dVgbk
M9/20003]_h300002?Mg003o=?Lc003flokcm_<300000nhDkWD0000200007>hd003U]>FCiKCUTnFd
003MM=eCgGCMDmed003M==DCgCCE4`00a=@00<BCc?C4Tlcda9?<m<BC0P0000NlE;aC_5BlDkaD_5>l
E002000031;I0024fhckQ=^<nhCKS?/00;fj]IVm^P80000`_cg7?Klmacfo?@00Xi>Sm:>CXo@009^d
Vi>K]9^CVkBKT`00Te>CE9=CTeBCDi=D002;58<CRaB34h/DPa<007;CN]Abdg[DL]<0069C001RU6ZD
001AddWCDM=9de7C0P0000HHlR4C000QE000058200008P0B000cFS]J<eXkFS=J>eX00<jkcU[>^liJ
c[/00=Kke_[FnmKje_/00=lk003G?<lkecc?>`00ccc??Lllccg??<lm0`0000NfOJiM]Wf^GKIm[Ud0
000=ool00`00ooooo`04ool001koo`03003ooooo00ooo`03002V?JHm008000BV?@03002MoIgm00BM
o@0K002=GIFmSEfE_HeMUKd007BlM9ad_7BLM;`006`kI1]/>f@K001lVgblO9]l_7bKO;alVgbl0080
0006]_h00;jl003_M`000_ld00<00?kc00000P0000OfMNiemWD00>hekSC^=@0200009>FDkOCUU>gd
003UM=eDiGCME>EdgE@00=DCgGCE4med003<m@00c?C<U<cdc9C<m<bDc?@00<cd002lM;aD_7BlE;ad
_5BlM0<00008S?b4fhclQ=^<o8CK002eV@800005acjo?LLn_cg7?P020000:j>CXoBSTj?dXi>Sm000
VkBKU9^dViBK]000TgBCE9=dTeBCM9=D002358/dPaB;=8<DRc@007[dN]=jm7[CN_@006Zd001Z]6ZD
0019de8DBM=B54WC00800005:A<Q4bTC000YE00200000b6E00004P0200001C]k>eXkNc]J00001<jk
00<00=Kke_/00mKk00H00=mkgc_ON`00ec`200001Lllccg??<lmcc`00P0000_6o@00]Wd00;Im[Wff
OJim]Wf^O@0000goo`03003ooooo00?oo`007ooo00<00?ooool03ooo0P00036V?IgMYSfMgJHmWMfV
?@00WOfMgIgmWMfMoIgM002=GHfmSEf=_HeMSKd007BlI9ad_6BL001T6V@KI1YT6f@J001dVgbkM9]l
^gBKO;]dVgbkM9/00;jL003_M`00mc?o=00300002njf003^MNhDkWG^5000kMC^=>gDkS@00P0002GU
TnFdiI<00=eCgGCMDmedgE<00=DCgCCE4mddeA?M=000c?C4Tlcda9?<m<BCc?C4T`00c9<00;aC_5Bl
DkaD_5>lE;aC002lD`0900001Klmacfo?LLm_cd00`0003VSTj?dXi>Sm:>CXoBST`00Vi>K]9^CVkBK
T`00Te>CE9=CTeBCDi=D002;58<CRaB34h/DPa<007;CN]Abdg[DL]<0069CJU@006ZD001AddWCDM=9
de7C0011e0008A<HlP006E<0000A000AU@0001801@0000<cFP00cUX00P0001kFnmKje__Fn]Kk003O
>mLjgc_G>]lk003??Lllccg??<lmcc`00;kma_fno@00[Ud00:iM]Wf^GKIm[Ud2000=ool00`00oooo
o`03ool0023oo`03003ooooo00ooo`03002V?JHm00JV?@03002MoIgm00:Mo@/0000@M9ad_7BL001T
6f`kI1]/>f@K001lVgblO9]l_7bKO;`200001Kjl003_MoNh00000_ld03L00>jfm[K^]P00kWGfMNie
mWD00>hekSC^=@00kOCUm000iIC]m000iGCME>EdgECUM000gGCE4medeA?MM=DC003<U<cdc9C<m<bD
c?C<U000c=?<m000_7BlE;ad_5BlM;aD_7@00<Bd002d=00200001EgoGSmMoehoGOl00P0002_7?P00
002[dk@d002Sm:>CXoBSTj?dXi>Sm000VkBKU9^dViBK]000TgBCE9=dTeBCM9=DTg@008/dPaB;=8<D
Rc@007[dN]=jm7[CN_@006ZdHU=Z]00200003DWCDQA9de8DBM<003WC000Q4bTC000YE25C00800008
8MHQU@00001dNf`KM7]/6`<000KFn`0E003ONmlkgg_O>mmk003O^`00ccg??<lmcc`00;kma_fnoLKm
__d00:im00D00003[Sf^O@0000coo`03003ooooo00?oo`008Ooo0P004?oo0P0000JV?IgMYSfMgJHm
WMd500002XfMUKf=W@00I=adoFCLM?eTg7Cm1@0000YT6f@JI1]T6V@KI1X007BKO;]dV`800008_[fn
W;jm003gM`00ocCg<`80000hk[K^UP00kQC^MNhDkWD00>hdkMC^=>gD003Ue>Gd003U]>FC003MDmed
gE?MM=eC003E4mddeA?M==DCgC@00<cda9?<m<BCc?C4Tlcd003<m<bC002lDkaD_5>lE;aC_5@00<Bd
_5<00:`C]1B/4`P0000[[1B[dj`DZm<00:>CXoBSTj?dXi>Sm:>C002KTi^dVi>K]9^CVk@009=DTe>C
E9=CTeBCD`00Pa>;58<CRaB34`00L]=je7;CN]Abd`00HU=ZE69CJU@00P0000a9de7CBM=Ad`00@M@a
T`006?8001UC8E@200000a6E8IDAU@0200005f`KI1Y/6f@JK1]T6P00e_[FnmKje_/00=lkec[O>mLj
gc/00=nkeg_O^`00ccd00P0000JnoLKm__g6oKkma_d400001ZHM[SfV7JhmYQd000coo`03003ooooo
00?oo`008ooo00<00?ooool03ooo00<00:HmYSd00`0001>MoJHn002EoYFMUOjEWIGnUId007CMMCed
gGDmM=d005@KG3aD6`05000016@KK3/007bl0P0000Nn_<Jm_[c6_@00mkS_M`0400004OJfk[Kf]P00
mWG^MOIekWD00>hdkSG^=>he003]m>GdkO@00P0000cME>EdgECUM=eD003E4medeA?MM=DCgG@20000
BlbDc?C<U<cdc9C<m<bD003<dlcd002lM;aD_7BlE;ad_5@00<ACa;@00;@d]1Bd=;@D]3Bd5;@d]1@0
0:?D002[dk@dZm>d=000XoBSTj?dXi>Sm:>CXo@009^dViBK]9^DVkBKU000TeBCM9=DTgBCE9=d002;
=8<DRcB358/d001jm7[CN_Ajdg[d001Z]69CJ[ARD`0200003E8DBM=B54WCDQ@0047D>M<0024C000Q
DbUD0080000;8IDQeR6E001/6gAkK1]dNf`KM7]/6`0200002=Kk003ONmlkgg_O>mmk0005gk/01`00
a_fnoLKm__g6oKkm0080000;][jf_@00[Sd00:hm[Wf^?Jim[Sd0000;ool00`00ooooo`03ool002Co
o`03003ooooo00ooo`800006WMfN?IgMWSfMgIhm0P0001>=WIFmSIfE_HfM001Tg7CmI=adoFCL001C
fe`KDm]L6`00K5]TF`0400002;jm_Ybn_KjL_[fnW000kgL20000@MjigYT00>jFk[K^UP00kQC^MNhD
003]e>hdkMC^=000iOCUe>GdiMCUm000gGCMDmedgE?MM000gCCE4mddeA?M==DC003E4`00a9?<m<BC
c?C4T`00c9?<m<bCc?@00;aD_5>lE;aC_5@00<Bd_5<00:`C]1B/4k@D[1>d5:`C]1@00P0003^[dj`D
Zm>/5:_C002STj?dXi>Sm:>CXoBST`00Vi>K]9^CVkBKTi^d002CE9=CTeBCDi=DTe<008<CRaB34h/D
Pa>;5000N]Abdg[DL]=je000JUARDfYDHU<004WCDM=9de7CBM<0036C@M@0024C000QE1UC00800003
8IDAUB6E00800007I1Y/6f@JK1]T6V`KI1X00P0000gO>mLjgc_G>]lk003O^mMkgk_GNmnk003G_002
00004;kma_d00000]Yff_KJM][d00:hm002^?JHM[SfV7Jhm0P002_oo00<00?ooool00ooo000Uool0
0`00ooooo`0?ool08000YSjMoJHnWOfV?YgmYSjMo@00UIfEoYFMUOjEW@00M=ee?GCMMCd005`lE1]L
?5@K001/FgAlK5]dO6aKM7`20000BKjla[fn_000kgOg^000i[WN^@00k[Kf]^jf003^MOIekWGfM@00
kSG^=>hekS@00>GdkOCUm>gdiO@00=eDiGCME>EdgE@00=DCgGCE4medeA?MM000gC@00<cdc9C<m<bD
c?@00<cdc=?<m<cC002lE;ad_5BlM000a;C4DlBd002d=;@D]3Bd5;@d]1Bd=;@D0080000]]3B[dk@d
Zm>d=000XoBSTj?dXi>Sm:>CXoBST`00ViBK]9^DVkBKU000TeBCM9=DTgBCE9=d002;=8<DRcB358/d
Pa@007[CN_Ajdg[dN]<0069CJ[ARDfZd00800008BM=B54WCDQ@0047D>M=1e080000<8E<YE25C000Q
UB7F8IDQeP00M7]/6gAk100000NMFiel003ONmlkgg/00005gk/00`00ekcG_002ek`200002KJn][ff
_[Jm][jf_KJn002^O@0500000jhmYSd00009ool00`00ooooo`03ool002Koo`80013oo`800004WMfN
?IgMWSd;000047CmI=ado@00G1]Cfe`KDm/006AKK5]TFfaKI5]/FfAK0P0007Jn_@0000000=jigYWN
^@00k[K^U^jf003^MNhDkWG^5000kMC^=>gDkS@00>GdiMCUm>GD003MU000gE?MM=eC003E4mddeA?M
==DCgC@00=DdeA<00<BCc?C4Tlcda9<00<bCc?C<Tlcd002lE;aC_5BlD`00_5?4];aCa;@00;@D[1>d
5:`C]1B/4k@D002/5:_C[1B[dj`DZm>/5000XoBSTj?dXi>Sm:>CXo@009^dVi>K]9^CVk@009=DTe>C
E9=CTeBCD`00Pa>;58<CRaB34h/D001je7;CN]Abdg[D001ZE69CJUARD`800008DM=9de7CBM<0036C
@M@aT`8000038E@IDb5D008000044IDQUA6E8ID300003YelWE^MO9eKWGbMFiel003O>`00gk_GNmnk
eg/200000mNlckcG_00200002LMm002fWKJm]Yff_KJM][ffW@0400001jhmYQf^?JHM[SfV7@0000Wo
o`03003ooooo00;oo`00:?oo00<00?ooool03ooo100000ZMoYGmWOjEo@00OEf5OWeMQGimG@D0000=
E1]L?5@KG3aD6`00K5]dO6aKM7a/FgAlK5/0100007CV^Mjii[T00?Jfk[Kf]P00mWG^MOIekWD00>hd
kSG^=>he003]m>GdkOCUm>gd003U]000iGCME>Ed003MM=DCgGCE4medeA<00=DDgC@00<cdc9C<m<bD
003<dlcdc=?<m<cC002lE;ad_5BlM000a;C4DlBda5<00;@D]3Bd5;@d]1Bd=;@D002[dk@dZm>d=:_C
]3B[d`00Xi>Sm:>CXoBSTj?dXi<009^DVkBKU9^dVi@009=DTgBCE9=dTeBCM9=D002358/dPaB;=8<D
001jdg[dN]=jm7[C001RDfZdHU=Z]69C0P0000QB54WCDQ@0047D>M=1e3WC0P0001@YE25C:E@0027F
8IDQeR6E002MFielWE^MO9eKWGbMFielWE^MO0001=nk00<00=Nlek`00]Nl00P00<mmagg?O@00][jf
_KJn100000Z^OJin002^?@00[SfV?JhmYSf^?@8000Soo`03003ooooo00;oo`00:Ooo00<00?ooool0
3ooo014009GMWOjEgIgnUMfMoYGM001mGHEnOEf5OWeM001<75AL00<00009G1]Cfe`KDm/006AKK5]T
FfaK00800017[Mb]o:gL003NVMjigYT00>jFk[K^UP00kQC^MNhDkWD00>hdkMC^=>gD003Ue>GdiMCU
m>GD003MU000gE?MM=eC003E4mddeA?M==DCgC@00=DdeA<00<BCc?C4Tlcd003<m<bCc?C<Tlcdc9<0
0;aC_5@00<Bd_5?4];aCa;@00;@D[1>d5:`C]1B/4`020000>J`DZm>/5:_C[1B[dj`D002Sm:>CXoBS
Tj?dXi>Sm000VkBKTi^dVi>K]9^C002CDi=DTe>CE9=CTe@008/DPa>;58<CRa@007[DL]=je7;CN]@0
06YDHU=ZE69CJU@005YD001AddWCDM<0047D<I=1e00200000aUC8E@ID`0300002a6E8IDAU@00WE^M
O9eKWGbMFielWE/00P0000S6_000003GN`00ckcG_<nl0P001LMm0`0000b^OJiM[Wf^GJim[Ud00:HM
002V7JhmYQd200000jHmYQd00007ool00`00ooooo`02ool002[oo`03003ooooo00ooo`80000@WOjE
oIgnUOfMoP00QGimGHEnOEf5OP00E7eDG5AmE5`6000017AlK5/000001:gl04D00=jii[WN^@00k[Kf
]^jfm[H00?IekWGfMNie003^=>hekSC^=@00kOCUm>gdiO@00>FDiKCUU000gE@00=DCgGCE4medeA?M
M=DC003E5=dd003<m<bDc?C<U000c=?<m<cCc?C<dlcd002lM;aD0034DlBda5?4]<AC002d5;@d]1Bd
=;@D]3@00P0005:[dk@dZm>d=:_C]3B[d`00Xi>Sm:>CXoBSTj?dXi<009^DVkBKU9^dViBK]000TgBC
E9=dTeBCM9=D002358/dPaB;=8<D001jdg[dN]=jm7[C001RDfZdHU=Z]69C001JE5Yd001B54WC000i
dd7D>M=1e000:E@QDbUD8E<005]H000QUB7F002MO9eKWGbMFielWE/00<Jla[g6_<Jma[`000;G_080
0005agg?OLMmcgg7O@0200003;kn002^OZim[Wj^OJin[Wf^OZim002V?@<00005YSf^?JHm[Sd00007
ool00`00ooooo`02ool002_oo`80017oo`0E002MoYGMWOjEgIgn0025OWeMQGimGHEn001DG4`LE5a<
7000Bm]D74_K00<0001W[Mb]o:gL[Ob]g000gYWN^MjIg[T00>jfkYK^]P00kWG^5>iekQ@00>gDkSC]
e>hd003Um>GDiOCUe>Gd003U]=fDiK@00=ed003M==DCgCCE4mddeA<00=DCeCCE4mDd003<m<BC003<
Tlcdc9?<m<bCc?C<T`00_5>lE000a;BlDlBd_5?4]000]1B/4k@D[1>d5000_5BdD`00Zm>/5:_C[1B[
dj`D002Sm:>CXoBSTj?dXi>Sm000VkBKTi^dVi>K]9^C002CDi=DTe<01@0001634h/DPa>;58<C001b
dg[DL]=je7;C001RDfYDHU=ZE000009JE0080019de7C0011e36C@M@aT`8000048E@IDb5D0002FeP2
00001B6E002MO9eKWG`00P0000O6W<JlaYc6_<JL003G^`020005agd200003;Km__jfo@00[Uf^OJiM
[Wf^GJim[Uf^O@@00007YQfV?JHMYSfV7JHm00001_oo00<00?ooool00_oo000]ool00`00ooooo`0?
ool>00002EALE7d005@lDm]D?5?KE3`00004[O`0G`00g[WV^Mjii[WN^@00k[Kf]^jf003^MOIekWGf
M@00kSG^=>hekS@00>GdkOCUm>gdiO@00>FDiKCUU000gE@00=DCgGCE4medeA?MM000gCCE5=ddeA@0
0<bDc?@00<cdc=?<m<cCc?C<dlcd002lM000a;C4DlBda5?4]<AC002d5;@d]1Bd=;@D002lE;ad002d
=:_C]3B[dk@dZm<00:>CXoBSTj?dXi>Sm:>CXo@009^dViBK]9^DVk@0100000FCE9=dTe@008<D0080
000JRcB358/d001jm7[CN_Ajdg[d001Z]69CJ[ARD`00FUAJM5YD0019d`00>M=1e3WC@M@id`800007
:E@QDbUD001SNE]HHgT00P0000RMF`000036_LJla[g6_<Jm0P0000CG^mnl003Go080000=agd00000
__jfoKkn]_fno[Km002^OJin[Wd0100000Z^?JHm00000:hmYSf^?JHm[SfV?@8000Goo`03003ooooo
00;oo`00;_oo00<00?ooool03ooo00`008gnSMj=oXgNSOh006CnI=eToVCMI?h30000J5AL001D74_K
E1a;fe@L002]o:gL[O`00=jigYWN^MjI003^U^jfkYH00>hDkWG^5>iekQ@00>gDkSC]e000iMCUm>GD
iOCUe000gICU]=fDiKCMU000eA?M==DCgCCE4mddeA<00=DCeCCE4mDd003<m<BC003<Tlcdc9?<m<bC
c?C<T`00_5<00;aCa;BlDlBd_5?4];aC002/4k@D[1<00;AC_5BdD`00Zm>/5:_C[1B[dj`DZm<00:>C
XoBSTj?dXi>Sm:>C002KTi^dVi<300002Y=CTeBCDi=DTe>CE000RaB358/D0P0000j34`00L]=je7;C
N]Abd`00HU=ZE69CJUARD`000eYD0P0000]1e36C@M@aTd7D001BUP008E@ID`0000EKF00I0036W<Jl
aYc6_<JLa[`00=Nlek_G_000eo_?nmOkco/00;Km__jfoKkn]_fno[Km__h0100000ZV7JhmYQf^?JHM
[Sd00:Hm002V?@@00003YQfV?@0000Coo`03003ooooo00;oo`00;ooo00<00?ooool03ooo00<008gn
SOh00hgn0P0000ITgFDnI=eU?P00<o`30000@5@lDm]D?5?KE3`00:gl003V^Mjii[WN^NJi003f]^jf
m[H00?IekWGfMNie003^=>hekSC^=@00kOCUm>gdiOC]m000iKCUU>FdiICU]000gGCE4medeA?MM=DC
003E5=ddeACM==DD003<U000c=?<m<cCc?C<dlcdc=?<m<cC0P000274]<ACa;C4DlBda5?4]000]3Bd
5;@d002lM;aD_7@00;@dZm>d=:_C]3B[dk@d002Sm:>CXoBSTj?dXi>Sm000Vk@00P0000nKU:>d002C
M9=DTgBCE9=dTe@008<DRcB358/dPa@00P00011jm7[CN_Ajdg[d001Z]69CJ[ARDfZd001JM5YDFWAJ
E0800007@M@idd7D>M<005:FD[L00P0000lQD`00FeQSNE]HHgUKF000a[c6_LJla[d00=nlek/00P00
00?Go<okeo`00P0000O7_@00]_fno[Km__jfo@0200002[In[Wd00:Hm[SfV?JhmYSf^?JHm100000N^
?JHm[SfV?JhmYSd00005ool00`00ooooo`01ool0033oo`80013oo`0?002=oXgNSOj=gXgnSMh006CM
I?iTg@00<i/co3>K00P0001Jg[WNVMjigYWN^@00k[K^U^jfkYH00>hDkWG^5>ie003^=>gDkSC]e000
iMCUm>GDiOCUe000gICU]=fDiKCMU000eA?M==DCgCCE4mdd003E==DCeCCE4mDd003<m000c?C<Tlcd
c9?<m<bCc?C<Tlcd0034];aCa;BlDlBd_5?4];aC002/4k@D[1<00;AC_5BdD`00Zm>/5:_C[1B[dj`D
Zm<00:>CXoBSTj?dXi>Sm:>C0P0001:K]9^DVkBKU000Te>CE9=CTeBCDi=DTe<008<DRaB358/DPa@2
00002g[DL]=je7;C001RDfYDHU=ZE69C000015YD0P0000TaTd7D<I=1e36C001:UU:FBYH00P001U]H
00`00<JL00000=Nlek/00<okeo_?nmOk0004akd00`00]_fnoP0200002:iM[Wf^GJim[Ud00:HM[Sd4
00003:HMYSd00:Hm002V?JHMYSfV7JHmYQd000Coo`03003ooooo007oo`00<_oo00<00?ooool03_oo
2@0000eU?VCM000cg3?l<m`co000O?edg7cmM=alo@020000;=jii[WN^@00k[Kf]^jf003^MOIekWGf
M@00kSG^=>hekS@00>GdkOCUm>gdiO@00>FDiKCUU>FdiI@00=fD003E4medeA?MM=DC003E5=ddeACM
==DDgC@20000:LcCc?C<dlcdc=?<m<cCc?C<d`00a5?4]<ACa;C4DlBda5?4]000]3Bd5000_5BlM;aD
_7@00;@dZm>d=:_C]3B[dk@d002Sm:>CXoBSTj?dXi<00P00032S]9^DXkBKU:>dVi@009=DTgBCE9=d
TeBCM000RcB358/dPaB;=000NcD007[dN]=jm000J[ARDfZdHU=Z]000FWAJE5YdFUAJM000@M@idd7D
>M=1e000D[MBUU:gDYH200000f=iFeQSN@0500003Mnlek/00<okeoc?nmOl003?_LNmckg7_Lnm00<0
0007]Wj^OKIn[WffOZim]Wh00`0000n^?JHm[SfV?JhmYSd00:Hm002V?JhmYSf^?JHm[Sd00P000ooo
00<00?ooool00Ooo000cool00`00ooooo`0>ool01`00OKieWWfnMIim_WFN00D0000;<i/co3>K<o`0
07cmM=aloGCLO?edg0030000K>jFk[K^U^jf003^MNhDkWG^5000kMC^=>gDkS@00>GdiMCUm>GDiO@0
0>FdgICU]=fDiK@00>Fe003M==DCgCCE4`00eA?E==DCeCCE4mDdeA<00<bCc?C<Tlcdc9?<m<bCc?C<
Tlcd0034];aCa;BlDlBd_5?4];aC002/4k@D002lE;AC_5BdDkaD002/5:_C[1B[dj`DZm<00:>CXoBS
Tj?dXi<00:?D002KU9^dViBK]9^DVk@009=DTe>CE9=CTeBCD`00PaB;58<DRaB358/D001je0800008
L]=je000JUARDfYDHU<000EJE080000:@M@aTd7D<I<004ZFDYI:UU:FBYH400001IflWIbM_9fLWK`0
0`0000CGnlok000000C7_@800008__jfo@00[Uf^OJiM[Wf^G@80000>[SfV7@00YQfV?JHMYSfV7JHm
YQd00:HM002V7@@00003YSd00?oo00;oo`03003ooooo007oo`00=?oo00<00?ooool03_oo0P0000Qm
WWfoOIim_gfN000lGDAm0`0000Xco3?L001dg7cmM=aloGCLO?edg0<0000bk[Kf]P00mWG^MOIekWGf
M@00kSG^=>hekS@00>GdkOCUm>gd003U]>FDiKCUU>FdiI@00=fD003E4medeA?MM000gCCE5=ddeACM
==DDgC@00<cdc=?<m<cCc?C<dlcdc=?<m0800017a5?4]<ACa;C4DlBda5?4]000]3@00;ad_5BlM;aD
_7BlE000Zm>d=:_C]3B[dk@d002Sm:>CXoBST`00XmB/=000XkBKU:>dViBS]9^D002CE9=dTeBCM9=D
Tg@008/dPaB;=8<DRcB35000N]Ak=G[D001jd`00HU=Z]69CJ[@005YdFUAJM5YDFWAJE00200004D7D
>M=1e000D[MBUU:gDYIB]e:F002MW:FlWIbU_9fLYK`00P0000??_<nm00000P0000??_LNmckd00P00
00Rfo[ln]_jo?[Kn002^OKIn0P0000bV?JhnYSf^?P00[SfV?JhmYSf^?JHm[Sd400001jHm[SfV?Jhm
YSf^?@0000;oo`03003ooooo007oo`00=Ooo0P004?oo00X007FNOKieWWfnMIh003AMA5ddG@D00003
M=alo@0000<00003[M^]o:gK00D0000]kQC^M@00kSC]e>hdkM@00>GDiOCUe>GdiM@00=fDiKCMU>Fd
gI@00=fDiKGMU000eA?M==DC003E4mDdeA?E==DCeCCE4`00c9?<m<bCc?C<Tlcdc9?<m<bC00800009
a;BlDlBd_5?4];aCa;BlDlBd0080000_]5>lE;AC_5BdDkaD002/5:_C[1B[dj`DZm>/5000XoBST`00
XmB[m:?D002KU9^dViBK]9^DVk@009=DTe>CE9=CTeBCD`00PaB;58<DRaB358/D001je7;DN]Abe002
00001VYDHU=ZE69CJU@000EJE00F001JeP00@M@aTd7D001BUTZFDYI:UU:F002M_9fLWKbMW9fl003?
_Lnlckd200000lOjao/0000200001kkn]_fno[Km__jfoKkn00<0000:[SfV7JhmYQf^?JHM[Sd00:Hm
YQd400002jHmYQd00:HM002V7JHmYQfV?JHM00000_oo00<00?ooool00Ooo000gool00`00ooooo`0>
ool700001SaMA7dlG@00:i`[o0<00009]Ob]o;Gl[Obeo:gl]Ob]o00000?>>P<0000OkSC^=NhdkSD0
0>gdiOC]m>GdkO@00>FdiICU]>FDiK@00>FegICU]@00gGCE4med003M==DDgCCE5=ddeA@00P0005G<
m<cCc?C<dlcdc=?<m<cC003=5=De0034]<ACa;C4DlBda5?4]<AC002lE;ad_5BlM;aD_7BlE000Zm>d
=:_C]3B[dk@dZm<00:>C002Se:`dXmB/=:?D002KU:>dViBS]9^D002CE9=dTeBCM9=DTg@008/dPaB;
=8<DRcB35000N]Ak=G[DNcEje000HU=Z]69CJ[ARD`00FUAJM5YDFWAJE000F]IRm`02000053WC001B
UU:gDYIB]e:FD[L00:FlWIbU_000ckg?_<nm003?nlOkco/200001Knm00000;ln]_h0100000Z^OZim
002V?JhnYSf^?ZHm[SjV?@<0000>YSf^?JHm[SfV?Jhm002^?@00[SfV?JhmYSf^?@8000;oo`40007o
o`7oo`00>?oo00<00?ooool03_oo00H006DNIGiU7VEnIAh20000FdAM000[_1^K:k`KV`00[M^]o:gK
[Ob]fjgl[M/00<hIcS[>6LhjcQT00=HH003]e>hdkM@00>GDiOCUe>Gd003U]=fDiKCMU>Fd003U]MfD
iKGMU>Fe003M=000eCCE4mDdeA?E==DCeC@00=ee003<m<bCc?C<Tlcdc9?<m000cCC<e000_5?4];aC
a;BlDlBd_5?4]000_5BdDkaD]5>lE;AC_5@00:`DZm>/5:_C[1B[dj`D0080000PXmB[m:?DZoBSe:_d
002K]9^DVkBKU9^d002CE9=CTeBCDi=DTe>CE000RaB358/DPaB;5000N]Abe7[DL]Aje0800005HU=Z
E69CJU@00006FU@01000F]IJeU[F0P0000QBUTZFDYI:UU:FBYH009fL0P0000K?_Lnlckd00<OkaoX2
00001<Nm_kg7_Knm0`0000Z^GJin[Uf^OZiM[Wj^G@00YQf^?@@0000<YQfV?@00YSfV7JHmYQfV?JHM
YSd00:Hm1@0000FV?JHM003oo`0000;oo`00>Ooo00<00?ooool03_oo00H006ENKGmUGVeoIEh40000
2B_l:i`[o2^L002]o;Gl[Obeo0020005cSX01000eSSNNMHh0`00033Um>gdiOC]m>Gd003UU>FdiICU
]>FD003MU>FegICU]MfD003E4`00eACM==DDgCCE5=dd003MMMED003<dlcdc=?<m<cCc?C<d`00cACE
=@00a;C4DlBda5?4]<ACa;@20000@kaD_7BlE;ad_5BlM;aD002[dk@dZm>d=:_C]3B[d`00XmB/=:?D
[3BSe:`dXm@009^DXkBKU:>dViBS]000TgBCE9=dTeBCM9=D002358/dPaB;=8<DRc@007/eN]Ak=G[D
001Ze@00HU=Z]69C001JE5YdFUAJM5YDFW@006;gF]IRme[F00800003D[MBUU:g00D00005ckg?_000
003?n`0200001;nmaofo_LOm0P000[Kn00P00:in[Wf^OZim[Wj^OJin0`0000j^?JHm[SfV?JhmYSd0
0:Hm[SfV?JhmYSf^?JHm100000R^?JHm[SfV?Jhm003oo`000_oo000jool2000?ool02000IAiUOVDN
IGiU7P004m`30000AA^K:k`00:gl[M^]o000cS[>6LhjcQW>>/hIcSX00=hieQSN>MHHgST00>GdiMCU
m>GDiO@00>FdgICU]=fDiK@00>FegICU]MfDiKD00=dd003E==DCeCCE4mDdeA<00=EDgGD00<cdc9?<
m<bCc?C<T`00c=C==<cD002lDlBd_5?4];aCa;BlD`0200003[aD]5>lE;AC_5BdDkaD]5<00:_C[1B[
dj`DZm<200009:_dXmB[m:?DZoBSe:_d002K]9^DVkBKU9^dVi@009=CTeBCDi=DTe>CE000RaB358/D
PaB;58<D001be7[DL]Aje7;D001Re@800003JU@005YD00EJE003001JeU[F00=JeP@00005SCb<fhdl
S=^=?00600000knmakfo_@0200002;Kn]_ffo[Km]_h00:in[Ud400003Jhm002V?JHMYSfV7JHmYQfV
?JHM002V7JHm00@0000:YQfV?@00002V7JHmYQfV?JHMYSd20002ool003coo`03003ooooo00goo`L0
00036m`So00000@00003]O`00<hj00K>>P18003NNMHhgWWF>=ii003N>000kOCUm>gd003U]>FDiKCU
U>Fd003U]MfDiKGMU>FegICU]@00gCCE5=ddeACM==DDgC@00=eeeE@00<cCc?C<dlcdc=?<m000eCG=
5=De0034]<ACa;C4DlBda5<00<CD002lE;ad_5BlM;aD_7BlE;ad002d=:_C]3B[dk@d0P0003bSe:`d
XmB/=:?D[3BSe000ViBS]9^DXkBKU:>d002CM9=DTgBCE9=dTe@008<DRcB358/dPaB;=000NcEje7/e
N]Ak=@00LcIZeG<f001Z]000FWAJE5YdFUAJM000H_MJeV;gF]IRme[F002=6iDlSA^E?8dKUC`20002
_od00`00]o^gnP030007]_h300003ZHm[SjV?JhnYSf^?P00[SfV?JhmYSf^?JHm[Sd300001jhmYSf^
?JHm[SfV?Jhm00800003YSf^?JHm00@000;oo`00?Ooo00<00?ooool03Ooo0P0000AE?UCNECiDgP80
00046o`003@M=1`20000NLhjcQW>>/hIcS[>6Lhj003N>MHHgSWF6=hi003N>=HHgSP00>GdiM@00=fD
iKCMU>FdgI@00=fDiKGMU>FegICU]MfD003E4mDdeA?E==DCeC@00=eeeECMMMED003<Tlcdc9?<m000
cCC<e<ddc=@00;aCa;BlDlBd_5?4]000c?G4e000]5>lE;AC_5BdDkaD]5<00:_C[1B[dj`D002dEKAD
002Se:_dXmB[m:?DZo@009^dViBK]9^DVkBKU000Te>CE9=CTeBCDi=D002;58<DRaB358/DPa@007;D
N]Abe7[DL]@006;EL]EReG;E008000IJE003001JeU[F00=JeP0;002=?8cKSCb<fhdl002ooKol_od0
0002]oX200001knn002fo[Km]_jfoKKn0080000=YUd00:HM[SfV7JhmYQf^?JHM002V7JHmYQd01000
00ZV?JHM002V7JHmYQfV?JHMYSfV7@D000?oo`40007oo`7oo`00?_oo00<00?ooool03_oo0P0000=E
7UDnEAh0100000@d?C@L=3d000G>>P08003NNMHhgWWF>=iieSP000?N>01Y003Um>gd003U]>FDiKCU
U>Fd003U]MfDiKGMU>FegICU]@00gCCE5=ddeACM==DD003EE=eeeECMM@00c?C<dlcdc=<00<dDeCG=
5=DecA@00<ACa;C4DlBd003<mLCDc?D00;ad_5BlM;aD_7BlE;ad002d=:_C]3@00;ae]5BlM@00[3BS
e:`dXmB/=:?D002KU:>dViBS]9^DXk@009=dTeBCM9=DTgBCE000PaB;=8<DRcB358/d001k=G[DNcEj
e7/e001c=V[ELcIZeG<f0080000AFUAJM5YDFWAJE000F]IRme[FH_MJeV;g002E?8dKUC`00002_od2
00001kOk00000;Nn_kjg_P0000:foP<0000;[Wj^OJin[Wd00:Hm[SjV?JhnYSf^?P0400002ZHm[SfV
?JhmYSf^?@00[SfV?Jhm10000ooo00<00?ooool00_oo0@000Ooo0Ooo000oool2000@ool300000eCN
ECh0000300004c@L=1d00000cQW>>/hI003F6=hieQSN>MHH003F6=hheQSN>=HH0080001XiKCMU>Fd
gICU]000iKGMU>FegICU]MfDiKD00=gf003E==DCeCCE4`00eECMMMEDgGGEE000c9?<m<bCc?@00<dd
c=C==<cDcC@00<Bd_5?4];aC0034e<cea=@00;AC_5BdDkaD]5>lE;AC002[dj`DZm<00;AD]5FdE000
XmB[m:?DZoBSe:_d002K]9^DVkBKU9^dVi@009=CTeBCDi=DTe>CE9=C002358/DPaB;58<D001be7[D
L]Aje7;DN]@007;EH]EbeF;E001SU`8000=JE003001JeU[F00AJeP08002<f`00002ooKol002gnP80
0005_kjg_Knn]kfo_P0300002ZinYUf^OZIM[WjVGJin002^?JHM100000ZV?JHM002V7JHmYQfV?JHM
YSfV7@@000Ooo`03003ooooo00?oo`40007oo`00@Ooo00<00?ooool03_oo00<004cN00000`0000<3
N`000000100000S>>P00eSSNNMHhgWWF>0001mhh06/00>FDiKCUU>FdiI@00=fDiKGMU>FegICU]MfD
003MmP00eACM==DDgC@00=eeeECMMMEDgGD00<cdc=?<m000eCG=5=DecACE=LdD0034DlBda5<00<CD
c?G4e<ce002lM;aD_7BlE;ad_5BlM000]3B[d`00]5BlMKAD_7D00:`dXmB/=:?D[3BSe:`d002S]9^D
XkBKU:>dVi@009=DTgBCE9=dTeBCM000RcB358/dPaB;=8<D001je7/eN]Ak=G[D001ZeG<fJ]Ec=V[E
001cV7>h00<00005FW@006;gF]IRm`050002_od400000knn]kjo_P0300002[Kn[[h00:im[Wj^OJin
[Wf^OZim0`0000ZV?JhmYSf^?JHm[SfV?@00YSf^?@@000coo`03003ooooo00;oo`40007oo`00@_oo
00<00?ooool03_oo00D004cNC?i<gTcn00@0001:=9e4_P00003F6=hieQSN>MHH003F6=hheQSN>=HH
gSSF6000eQP00=fDiKCMU000gICU]MfDiKGMU>FegI@00=gEgOH00=DdeA?E==DC003EE=eeeECMMMED
gGD00<cdc9<00<cDcCC<e<ddc=C==000a;BlDlBd003<mLCDc?G4e000]5>lE;AC_5BdDkaD]5>lE080
000d]5BdEKAD]5FdE000XmB[m:?DZoBSe:_dXm@009^DVkBKU9^dViBK]000TeBCDi=DTe>CE9=C0023
58/DPaB;58<DRa@007[DL]Aje7;DN]@007;EH]EbeF;EL]D007>hHiMc^6>GLkP500001IFmUIfE_IFM
UKd0100000>W^jok00000P0000Vf_ZjM][j^WKJn[Yd00:IM[Wh0100000ZV7JHm002V?JHMYSfV7JHm
YQfV?@<0017oo`05003oooooool00001ool004?oo`03003ooooo00koo`05001<gUCnC=iDoP040000
2DBMA;i4W@00eSSNNMHhgWT00006gSP0>P00eSSNNMHh003UU>Fd003U]MfDiKGMU>FegICU]@00iOKM
mP00eACM==DD003EE=eeeECMMMEDgGGEE000c=?<m000eCG=5=DecACE=LdD0034DlBd003<mLCDc?G4
e<ce002lM;aD_7BlE;ad_5BlM;aD0P0003flMKAD_7FdE;ae]5@00:?D[3BSe:`dXmB/=000XkBKU:>d
ViBS]9^D002CE9=dTeBCM9=DTg@008/dPaB;=8<DRcB35000N]Ak=G[DNcEje000J]Ec=V[ELcIZeG<f
001c^7>HLkQcV7>hLiP009FMWKfEWIfmUIfM_@0300003JolYo/00000]cng?P00[[jfoZjn]_j^_[Kn
00<0000:[SfV?JhmYSf^?JHm[Sd00:hmYSd4000Eool01000ooooo`000Ooo0014ool2000?ool30000
14cNC?h000<J100008<dW@00003N>@00gSSF6=hheQSN>=HH003F6=iieQSNN@00iKCMU000gICU]MfD
iKGMU>Fe003Mm]gEgOKMe@00eA?E=000gGGEE=eeeECMMMEDgGD00<cd003==<cDcCC<e<ddc=C==000
a;BlD`00a=C<mLCDc?G4e000]5>lE;AC_5BdDkaD]5>lE000]5FdE;AE]5BdEKAD]5D00:_dXmB[m:?D
ZoBSe000ViBK]9^DVkBKU9^d002CE9=CTeBCDi=DTe<008<DRaB358/DPaB;5000N]Abe7[DL]Aje7;D
001ReG;EH]EbeF;E001SUg>hHiMc^6>GLkP009FmUIfE_IFM00800003YkX00:ok00800007[cjg?Zln
]ch00;Jn[Yd0100000Z^OJHM002V7JHmYQfV?JHMYSfV7@<001Woo`04003ooooo0001ool004Koo`03
003ooooo00goo`03001E7P0000@000030aX003cN00@000KN>007003F>=iieSSNNMHhgWT00P0002;M
U>FegICU]MfDiKGMU000gOKUm]gfiOH00=ddeA@00=EDgGGEE=eeeECMMMED003<d`00cACE=LdDeCG=
5=DecACE=@80000>a=C<mLCDc?G4e<cea=@00;aD_7BlE;ad_5BlM080000j]5BlMKAD_7FdE;ae]5@0
0:?D[3BSe:`dXmB/=000XkBKU:>dViBS]9^D002CE9=dTeBCM9=DTg@008/dPaB;=8<DRcB35000N]Ak
=G[DNcEje7/e001c=V[ELcIZeG<f001c^7>HLkQcV7>hLiQc^000WKd200000inj0000000200001[Lo
]cjg?kLn]cng?P<0000:YSf^OZHm[WjV?JinYSd00:Hm[Sd4000Mool00`00ool00001ool004Ooo`03
003ooooo00goo`800003ECiDgUDn00D0000dA?hdgDCn003N>=HHgSSF6=hh003NNMHHgWWF6=iieQSN
N@00iKGMU>FegICU]MfD003MeMgfgMGMm]gE003E4`00eECMMMEDgGGEE=eeeECMMMED003<e<ddc=C=
=<cDcCC<e<ddc=@200003/cea=C<mLCDc?G4e<ce002lE;AC_5BdDkaD]5<20000>;AE]5BdEKAD]5Fd
E;AE002[m:?DZoBSe:_dXm@009^DVkBKU9^dViBK]000TeBCDi=DTe>CE9=CTe@008/DPaB;58<DRaB3
5000L]Aje7;DN]Abe000H]EbeF;EL]EReG;E001c^6>GLkQSUg>hHiL700001:Nm002_?[Ln100000ZV
GJin002^OJHM[WfV7JimYQf^O@<002;oo`40007oo`400000B?oo00<00?ooool03_oo0`0000AE?P00
00036@<00003?=i4oP0000?N>01d003NNMHhgWWF>=iieSSNN@00e[/00>FegICU]MfDiKD00>GfgOKU
m]gfiOH00=dd003MMMEDgGGEE=eeeECMMMEDgGD00=DecACE=LdDeCG=5=DecACE=@00c?G4e<cea=C<
mLCDc?G4e000_5BlM;aD_7BlE000a=K5=P00_7FdE;ae]5BlMKAD002Se:`dXmB/=:?D[3@00:>dViBS
]9^DXkBKU:>d002CM9=DTgBCE9=dTe@008<DRcB358/dPaB;=000NcEje7/eN]Ak=@00LcIZeG<fJ]Ec
=V[E001cV7>hLiQc^08000:OO`<000B__P80000:[[j^OZjn[Wj^_Zin[[h00:inYSd4000Vool20000
04Woo`03003ooooo00koo`03001UOP0000@000030aX0000000<0000SgSP00=iieQSNNMHHgWWF6=ii
003F^/iJ003MU>FegICU]@00gOKMeMgfgMGMm]gEgOH00=eeeECMMMEDgGGEE=eeeECMM@020000=LcD
cCC<e<ddc=C==<cDcCC<e000a=C<mLCDc?G4e<cea=C<m@00_5BdDkaD]5<00<CEa?K4e@00]5BdEKAD
]5FdE;AE002[m:?DZoBSe:_dXm@009^DVkBKU9^dViBK]9^D002CDi=DTe<03P0000aje7;DN]@007;E
H]EbeF;EL]ERe@00HiL200000imoWch0000200001:Nm[kjW_Jnn0P0000VVWP00YUf^OZIM[WjVGJin
YUd00`00:_oo0P00001:ool2000?ool01@00KGmUGVeoIEh01@0000TLG@00003NNMHhgWWF>=iieSP0
0P0001[F^lije[_>NP00gICU]MfD003Mm^GfgOKUm]gfiOKMmP00eECMMMEDgGGEE=eeeECMMMED0P00
00SE=LdDeCG=5=DecACE=LdD0P0002K<mLCDc?G4e<cea=C<mLCD002lE;ad_5@00<CFaCK4e/Df002l
MKAD_7FdE;ae]5BlM@00[3BSe:`dXmB/=:?D002KU:>dViBS]9^D1@0000jL5i`gW1L008`GU3R<5i@h
S1ND>000S7Z4FHaj30000Ymo10000jnn0P0000N^ojkn[_n^oP00[Wj^_P04000]ool2000004coo`03
003ooooo00goo`05001UOVDNIGiU7P02000070>j0000000095d00=iieQSNNMHH003>F]JjcU[F^/iJ
e[X00>FegI@00=gEgOKMeMgfgMGMm]gE0P0003WMMMEDgGGEE=eeeECMMMED003Ee]gg003==<cDcCC<
e<ddc=C==000eOL00<cea=C<mLCDc?G4e<ce002lE;AC_5@00<Cfa=G4m/CE002dE;AE]5BdEKAD]5Fd
E000XmB[m:?DZoBSe:_d002K]9^DVk@00P0001nTE`00U1NL5i@GW1ND5i`GU1L008`GU1R<5i@HS1ND
6000S5V4FHaIQ5V<FHAI002=GHemSEf=OHeMSGf=G@030003Sg/300001ZJN[_jVWZknYYj^oP<002go
o`@000;oo`00COoo00<00?ooool03Ooo3P0001CF>000cW[F^lije[_>N]JkcW[F^`00iKD00>GfgOKU
m]gfiOKMmP000]ii00P00=eeeECMMMEDgGGEE0000mgg02`00<dDeCG=5=DecACE=@00gOOEm`00a=C<
mLCDc?G4e<cea=C<m@00_7@00<Dfa=K5=/CFaCH00;ae]5BlMKAD_7FdE;ae002/=:?D[3BSe:`dXm@0
09^D0P0001n/]jAG[;NTE`00W1NL=i`GW3NL5i`g002D>8`GU3R<5i@hS1L008AIS7Z4FHajQ5V<NP00
UKf=GIFmSEfE_@0300000iNl0000000200001ZLo[cl00000[_j^o`<002coo`@000Koo`00C_oo00<0
0?ooool03Ooo00H007fnMIim_WFNOKh800002LiJe[[>F]JjcU[F^/iJe[[>FP020000:=gfgMGMm]gE
gOKMeMgf003NNMIH003EE=eeeECMMMEDgGD00=ggeMKMm`00cCC<e<ddc=C==000eOOEU]Gg003<mLCD
c?G4e<cea=C<mLCD0P0001G4m/CEa?K4eLCfa=D00;AD]5FdE;AE]5BdEKAD002Se:_dXmB[m:?DZo@0
0P0001nTEjBgY5NT]jAGY;L009`GU1NL5i@GW1ND5`00S1ND68`GU1R<5i@H002<FHAIS5V4FHaIQ5V<
F@00SGf=G@0600001jLoYcjW?jLnYcnW?ZLo00<002_oo`@000[oo`00Cooo0P003_oo0P0000AmWWfo
OIim_`P00008cW[F^lije[_>N]JkcW[F^`800007gOKUm]gfiOKMm^Gf00001=ii00H00=EDgGGEE=ee
0004gOL04`00cACE=LdDeCG=5000eOOMmmGggOL00<cea=C<mLCDc?G4e<ce0080000Ca=K5=/CFaCK4
e/Dfa=H00;AD_7FdE;ae]5BlM@00[3BSe:`dXm@00`0001fTEjbgY5N/]jAG[;NTE`00W1NL=i`GW3NL
5i`g002D>8`GU3R<5i@hS1ND>000S7Z4FHajQ5V<NXAI00H00006WgnOOP00002_?jLo1000:_oo1000
3_oo001Aool00`00ooooo`0=ool400001HgnSMj=oP00CCh01@0000?F^/iJ00000`000Zkn05/00=gE
gOKMeMgf003NNMIHgWWFF=ii003MMMEDgGGEE000eMKMmmGFgOOEeP00c=C==<cD003EU]GgeIKEmmFF
0034e<cea=C<mLCDc?G4e000a=G4m/CEa?K4eLCfa=G4mP00]5FdE;AE]5BdEKAD]5D00:_dXm@00;DH
]CRe6000Y5NT]jAGY;NTEjBgY5L009@GW1ND5i`GU1NL5`00U1R<5i@HS1ND68`G0024FHaIQ5V<F@04
00001ILnWgnG?YmoUch01@00:ooo0`004_oo001Bool00`00ooooo`0=ool00`00SOj=oP04SOh20000
0ddNCCm=7P0300002jkn[_n^oZko[_j^ojkn003Mm^Gf00001mii00@00=eeeE@000KMm`0A003E=LdD
eCD00=ggeOOMmmGggOL00<cea=C<mLCDc?G4e00200004<Dfa=K5=/CFaCK4e/Dfa=H00;AD_7FdE;ae
]5BlMKAD0`0001fe6;Dh]ARe>000[;NTEjbgY5N/]jAG[;L009`gW1NL=i`GW3NL5`00S1ND>8`GU3R<
5i@hS1L008AI00<00003Qcj?OXLn00D002coo`@001Goo`00Dooo00<00?ooool03Ooo0P0000B=oXgN
SOj=gPT000N^oP1D003Me@00eUSNNMIHgWWFF=iieUP00=ED003Ee]ggeMKMmmGFgOOEeP00c=C==000
eOOEU]GgeIKEmmFF0034e<cea=C<mLCD003>6MHi0034m/CEa?K4eLCfa=G4mP00]5FdE;AE]5BdEKAD
]5D00;Dh]ARe>;DH]CRe6;Dh002T]jAGY;NTEjBgY5NT]`00W1ND5i`GU1NL5`00U1R<5i@HS1ND68`G
100000>??P0000000P00;Ooo10006Ooo001Dool2000?ool400002IGmWOjEo@00MIieogFNMOmeWP09
0009gWT20007gOL04000eCD00=ggeOOMmmGggOOEmmggeOL00<CDc?G4e0000mHi00h00<CFaCK4e/Df
a=K5=/CF002dE;ae]5BlMKAD0`0001Re6;Dh]ARe>;DH]CRe6000Y5N/]jAG[;NTEjbgY5L009`GW3NL
5i`gW1NL=`00U3P9000]ool4000Mool005Koo`03003ooooo00goo`07002MoYGMWOjEgIgnUMd00P00
00Ae_gFNMKmeWPH0000:7C/<f`00eUSNNMIHgWWFF=iieUP200002MggeMKMmmGFgOOEe]ggeMKMm`02
00007=FFeOOEU]GgeIKEmmFFeOL00<cea=C<m@00eSW>6MHicQT00<CEa?K4eLCfa=G4m/CE002dE;AE
0P0001Rmf/Hk_MX00;DH]CRe6;Dh]ARe>000Y;NTEjBgY5NT]jAGY;L009`GU1NL5i@GW1L9000/ool4
000Qool005Ooo`03003ooooo00goo`07002MoYGmWOjEoIgnUOd01@0000F=oYGnSOh005EN00H000;N
N@<00003WcnOO`0000SMm`0>003EmmggeOOMmmGggOOEmmggeOL00<CDc?D000GF>@080035=/CFaCK4
e/Dfa=K5=P<0000GaS_6>/HkaS[6>`00]CRe6;Dh]ARe>;DH]CP00:bgY5N/]jAG[;NTEjbg002L=`09
000/ool3000Uool005Soo`03003ooooo00goo`03002MoYGM00<00009WMfN?@00UOj=gYGnSMjEoXgN
00800004EGm=GUEoCEh3000039LnWgnG?YmoUcjOO`00gOOEe]ggeMKMm`80000;]gd00=FFeOOEU]Gg
eIKEmmFFeOOEUP0200009MHicQWF>LhIeSW>6@00a=G4m/CEa?K4eLCfa=D00;gJaS^mf/Hk_M[6>kgJ
aS/00;Dh]ARe>;DH]CRe6000Y5NT]jAGY;NTEjBg00T002_oo`@002Soo`00FOoo0P003_oo0P0000JM
oJHnWOfV?YgmYSh2000018gnUOj=oYGn1P0000>5oXgoQOh01@0000>O?imo00000]gg0P0000bo_[mn
_kjoOP00eOOMmmGggOOEmmggeOL20008eST01@00a=K5=/CFaCH00P0001>gOP00aS[6>lHjaS_6>/Hk
aSX00;DH]CRe6;Dh]ARe>;DH002TE`09000[ool4000/ool005_oo`03003ooooo00coo`08002N?IgM
WSfMgIhmWMfN?@D0000:WSjMgIhn0025ohGNQOn5gXGoQMh200000cdn=Ad0000400003;Mm_gjgOKmn
]gfoOP00eOOEU]GgeIKEm`80000OWgfOOP00eSW>6MHicQWF>LhIeST00<Cfa=G4mP00]gj_O[Mn[gh0
0;gJaS^mf/Hk_M[6>kgJ002e6;Dh]AP02P00:ooo1000<?oo001Lool00`00ooooo`0<ool200000igm
YSh000020002YSd01`00WSfN?YhmWSjN?Ihn00800004QOj=ohGnSOl60003QOl500001Kmn_kh00=gg
eOL00P0000FO_YmnWkjOOP0000SF>@<0000;]gngO[Mo]gjgOkMn0036>/HkaS[6>`0;000/ool4000d
ool005goo`03003ooooo00goo`800006YSfMgJHmWMfV?IgM0P0000BN?YgMWSjMg@H00003WSjEgIhn
00800005OMj5oggNQOmmgP0>00001imnWgd00<hIeSW>6MHi00D00005]gj_O[Mn[gjgOP07000018jo
SUn>_hiO0`00;?oo1000>?oo001Nool2000>ool00`00YSfV?@05YSd500001:HmYSjV?@001ihn1@00
0ihn00P008HnSSn6?XhoQSj>?hHn2P0000>6OghoQWl0200000>FOYioUWh00P0000>F_hio00000P00
;?oo0`00??oo001Pool00`00ooooo`0<ool200000jHmWMd0000200003:GMYSd00:HmWMfV?IgMYSfM
g@00UMfN?P@0000<WQfV?@00WSjF7IhnUQfN?YHM00267Xho100000VN7Ihn002F?YHNUSjF7YHnUQh0
1@0000^N7IhnWQfN?P00WWnF7YioUQjNOiHN00<002_oo`@003ooo`00HOoo00<00?ooool03Ooo0P00
1ZHm00D00:HnYSfV?ZHm00@00008YSjV?JHnYSfV?ZHmYSh000BN?P@0000:YSjN?JHnWSfV?YhmYSh0
09HoUSh300003JHmYSh00:HnWSjV?YhnYSjN?ZHn002NOiIn00<002[oo`@004?oo`00H_oo00<00?oo
ool03Ooo00L00:HmYMfV?JGMYSfUg@0500002jHMYSfV7@00WQfV?IhMYSfN7JHmWQd01@0000^N7JHm
WQd009hMWSjN7IhnWQfN?YhM00<00006WQfV?IhMYSfN7JHm0P0000BN7IhnWQfN?P@002Woo`@004Oo
o`00Hooo0P003_oo00<00:HmYSd00`0000>V?Jhm00001ZHm0P0000>V?ZHm00000P000ZHm00L00:Hn
YSfV?ZHmYSjV?@0200000jHnWSd000020002YSd02000YSjV?JHnYSfV?ZHmYSh5000Yool4001;ool0
06Goo`03003ooooo00coo`800006YQfV?JHMYSfV7JHm0P0000BV7JHmYQfV?@@00006YQfV?JHMYSfV
7JHm0P0000BN7JHmWQfV?@@00009YQfV?JHMYSfV7JHm002V?IhM00@002_oo`<004ooo`00I_oo00<0
0?ooool03?oo00P00:hmYSf^?JHm[SfV?Jhm1@0000B^?JHm[Sd000NV?@D000>V?@03002V?JHm00BV
?@<002_oo`@005;oo`00Iooo00<00?ooool03?oo0P0000>V7JHm00000P0000VV?JHM002V7JHmYQfV
?JHMYSd00P0000>V7JHm00000P0000bV?JHM002V7JHmYQfV?JHMYSd00:HmYQd3000Zool4001Fool0
06Soo`8000koo`800006[SfV?JhmYSf^?JHm0P0000B^?JHm[SfV?@@00007[SfV?JhmYSf^?JHm0000
1:Hm1000:Ooo1000F_oo001Zool00`00ooooo`0<ool02000YQfV?JHMYSfV7JHmYQd500002ZHMYSfV
7@00YQfV?JHMYSfV7JHm1@00:Ooo1000G_oo001[ool00`00ooooo`0<ool200000jhmYSd000020000
3:Hm[Sd00:hmYSf^?JHm[SfV?@00YSf^?@<002_oo`<006;oo`00K?oo00<00?ooool03Ooo0P0000^V
7JHmYQfV?JHMYSd00:HmYQfV?JHM00@002[oo`@006Goo`00KOoo0P003_oo00L00:hmYSf^?JHm[SfV
?@05000Zool4001Yool006ooo`03003ooooo00coo`03002V?JHM00<002_oo`@006goo`00L?oo00<0
0?ooool03?oo0P00:_oo1000LOoo001aool00`00ooooo`0;ool00`00ooooo`0Vool3001eool007;o
o`8000_oo`03003ooooo02;oo`@007Soo`00M?oo00<00?ooool02?oo00<00?ooool07_oo1000O?oo
001eool00`00ooooo`07ool00`00ooooo`0Jool40020ool007Koo`03003ooooo00Koo`03003ooooo
01Koo`@008Coo`00Mooo0P001_oo00<00?ooool04_oo1000R?oo001iool00`00ooooo`03ool00`00
ooooo`0?ool3002<ool007[oo`03003ooooo00;oo`03003ooooo00_oo`@008ooo`00Nooo00D00?oo
ooooo`0000Woo`@009?oo`00O?oo0P0000?oo`00ool01?oo1000Uooo001nool200000ooo00000002
002Kool007ooo`8009ooo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?oo
ob7oo`00\
\>"],
  ImageRangeCache->{{{77.875, 364.875}, {348.938, 116.375}} -> {-0.358032, \
0.443677, 0.00359199, 0.00359199}}]
}, Open  ]],

Cell[TextData[{
  "As mentioned above, ",
  StyleBox["NDSolve", "MR"],
  " works by taking a sequence of steps in the independent variable ",
  StyleBox["t", "TI"],
  ". ",
  StyleBox["NDSolve", "MR"],
  " uses an adaptive procedure to determine the size of these steps. In \
general, if the solution appears to be varying rapidly in a particular \
region, then ",
  StyleBox["NDSolve", "MR"],
  " will reduce the step size to be able to better track the solution. "
}], "Text",
  CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"}],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " allows you to specify the precision or accuracy of result you want. In \
general, ",
  StyleBox["NDSolve", "MR"],
  " makes the steps it takes smaller and smaller until the solution reached \
satisfies either the ",
  StyleBox["AccuracyGoal", "MR"],
  " ",
  StyleBox["or", "TI"],
  " the ",
  StyleBox["PrecisionGoal", "MR"],
  " you give. The setting for ",
  StyleBox["AccuracyGoal", "MR"],
  " effectively determines the absolute error to allow in the solution, while \
the setting for ",
  StyleBox["PrecisionGoal", "MR"],
  " determines the relative error. If you need to track a solution whose \
value comes close to zero, then you will typically need to increase the \
setting for ",
  StyleBox["AccuracyGoal", "MR"],
  ". By setting ",
  StyleBox["AccuracyGoal -> Infinity", "MR"],
  ", you tell ",
  StyleBox["NDSolve", "MR"],
  " to use ",
  StyleBox["PrecisionGoal", "MR"],
  " only.   Generally,  ",
  StyleBox["AccuracyGoal", "MR"],
  " and ",
  StyleBox["PrecisionGoal", "MR"],
  " are used to control the error local to a particular time step.  For some \
differential equations, this error can accumulate, so it is possible that the \
precision or accuracy of the result at the end of the time interval may be \
much less than what you might expect from the settings of ",
  StyleBox["AccuracyGoal", "MR"],
  " and ",
  StyleBox["PrecisionGoal.", "MR"],
  "\n",
  StyleBox["NDSolve", "MR"],
  " uses the setting you give for ",
  StyleBox["WorkingPrecision", "MR"],
  " to determine the precision to use in its internal computations. If you \
specify large values for ",
  StyleBox["AccuracyGoal", "MR"],
  " or ",
  StyleBox["PrecisionGoal", "MR"],
  ", then you typically need to give a somewhat larger value for ",
  StyleBox["WorkingPrecision", "MR"],
  ". With the default setting of ",
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["AccuracyGoal", "MR"],
  " and ",
  StyleBox["PrecisionGoal", "MR"],
  " are both equal to half of the setting for ",
  StyleBox["WorkingPrecision", "MR"],
  ".  "
}], "Text",
  CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"}],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " uses error estimates for determining whether it is meeting the specified \
tolerances.  When working with systems of equations, it uses the setting of \
the option ",
  StyleBox["NormFunction->f ", "MR"],
  "to combine errors in different components.   The norm is scaled in terms \
of the tolerances, given so that ",
  StyleBox["NDSolve", "MR"],
  " tries to take steps such that \n",
  Cell[BoxData[
      \(f[{err\_1\/\(\(tol\_r\) Abs[x\_1]\  + \ tol\_a\), \ 
            err\_2\/\(\(tol\_r\) Abs[x\_2]\  + \ tol\_a\), \  ... }]\  \
\[LessEqual] \ 1\)]],
  "\nwhere ",
  Cell[BoxData[
      \(err\_i\)]],
  "is the ",
  Cell[BoxData[
      \(TraditionalForm\`i\^th\)]],
  "component of the error and ",
  Cell[BoxData[
      \(x\_i\)]],
  " is the ",
  Cell[BoxData[
      \(TraditionalForm\`i\^\(\(th\)\(\ \)\)\)]],
  "component of the current solution."
}], "Text"],

Cell["\<\
This generates a high\[Hyphen]precision solution to a differential \
equation. \
\>", "MathCaption",
  CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[{x'''[t] == x[t], x[0] == 1, x'[0] == x''[0] == 0}, x, {t, \
1},
            AccuracyGoal -> 20, PrecisionGoal -> 20,
                             WorkingPrecision -> 25]\
\>", "Input",
  CellLabel->"In[128]:=",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0, 1.`25. }}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[128]="]
}, Open  ]],

Cell["Here is the value of the solution at the endpoint.", "MathCaption",
  CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell["x[1] /. %", "Input",
  CellLabel->"In[129]:=",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[BoxData[
    \({1.16805831337591852558062006876187245696`24.843082604958617}\)], \
"Output",
  CellLabel->"Out[129]="]
}, Open  ]],

Cell[TextData[{
  "Through its adaptive procedure, ",
  StyleBox["NDSolve", "MR"],
  " is able to solve \[OpenCurlyDoubleQuote]stiff\[CloseCurlyDoubleQuote] \
differential equations in which there are several components varying with ",
  StyleBox["t", "TI"],
  " at extremely different rates.   "
}], "Text",
  CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"}],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " follows the general procedure of reducing step size until it tracks \
solutions accurately. There is a problem, however, when the true solution has \
a singularity. In this case, ",
  StyleBox["NDSolve", "MR"],
  " might go on reducing the step size forever, and never terminate. To avoid \
this problem, the option ",
  StyleBox["MaxSteps", "MR"],
  " specifies the maximum number of steps that ",
  StyleBox["NDSolve", "MR"],
  " will ever take in attempting to find a solution. For ordinary \
differential equations, the default setting is ",
  StyleBox["MaxSteps", "MR"],
  StyleBox[" ", "MR"],
  StyleBox["->", "MR"],
  StyleBox[" ", "MR"],
  StyleBox["10000", "MR"],
  ". "
}], "Text",
  CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " stops after taking 10,000 steps. "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell["NDSolve[{y'[x] == 1/x^2, y[-1] == 1}, y[x], {x, -1, 0}]", "Input",
  CellLabel->"In[40]:=",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[BoxData[
    \(NDSolve::"mxst" \(\(:\)\(\ \)\) 
      "Maximum number of \!\(10000\) steps reached at the point \!\(x\) == \!\
\(-1.8024722723866666`*^-212\)."\)], "Message",
  CellLabel->"From In[40]:=",
  CellTags->{"b:1", "ndsg:0"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{\(y[x]\), "\[Rule]", 
          RowBox[{
            
            TagBox[\(InterpolatingFunction[{{\(-1.`\), \
\(-1.8024722723866666`*^-212\)}}, "<>"]\),
              False,
              Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[40]=",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell[TextData[{
  "There is in fact a singularity in the solution at ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)], "InlineFormula",
    FormatType->StandardForm],
  ". "
}], "MathCaption",
  CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[y[x] /. %], {x, -1, 0}];", "Input",
  CellLabel->"In[41]:=",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.97619 0.952381 0.0147151 0.0022426 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.21429 .00222 -12 -9 ]
[.21429 .00222 12 0 ]
[.40476 .00222 -12 -9 ]
[.40476 .00222 12 0 ]
[.59524 .00222 -12 -9 ]
[.59524 .00222 12 0 ]
[.78571 .00222 -12 -9 ]
[.78571 .00222 12 0 ]
[.96369 .12685 -12 -4.5 ]
[.96369 .12685 0 4.5 ]
[.96369 .23898 -18 -4.5 ]
[.96369 .23898 0 4.5 ]
[.96369 .35111 -18 -4.5 ]
[.96369 .35111 0 4.5 ]
[.96369 .46324 -18 -4.5 ]
[.96369 .46324 0 4.5 ]
[.96369 .57537 -18 -4.5 ]
[.96369 .57537 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-1)] .02381 .00222 0 1 Mshowa
.21429 .01472 m
.21429 .02097 L
s
[(-0.8)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(-0.6)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(-0.4)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(-0.2)] .78571 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.97619 .12685 m
.98244 .12685 L
s
[(50)] .96369 .12685 1 0 Mshowa
.97619 .23898 m
.98244 .23898 L
s
[(100)] .96369 .23898 1 0 Mshowa
.97619 .35111 m
.98244 .35111 L
s
[(150)] .96369 .35111 1 0 Mshowa
.97619 .46324 m
.98244 .46324 L
s
[(200)] .96369 .46324 1 0 Mshowa
.97619 .57537 m
.98244 .57537 L
s
[(250)] .96369 .57537 1 0 Mshowa
.125 Mabswid
.97619 .03714 m
.97994 .03714 L
s
.97619 .05957 m
.97994 .05957 L
s
.97619 .08199 m
.97994 .08199 L
s
.97619 .10442 m
.97994 .10442 L
s
.97619 .14927 m
.97994 .14927 L
s
.97619 .1717 m
.97994 .1717 L
s
.97619 .19412 m
.97994 .19412 L
s
.97619 .21655 m
.97994 .21655 L
s
.97619 .2614 m
.97994 .2614 L
s
.97619 .28383 m
.97994 .28383 L
s
.97619 .30625 m
.97994 .30625 L
s
.97619 .32868 m
.97994 .32868 L
s
.97619 .37353 m
.97994 .37353 L
s
.97619 .39596 m
.97994 .39596 L
s
.97619 .41838 m
.97994 .41838 L
s
.97619 .44081 m
.97994 .44081 L
s
.97619 .48566 m
.97994 .48566 L
s
.97619 .50809 m
.97994 .50809 L
s
.97619 .53051 m
.97994 .53051 L
s
.97619 .55294 m
.97994 .55294 L
s
.97619 .59779 m
.97994 .59779 L
s
.25 Mabswid
.97619 0 m
.97619 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01696 m
.06244 .01705 L
.10458 .01717 L
.14415 .01728 L
.18221 .01741 L
.22272 .01755 L
.26171 .0177 L
.30316 .01789 L
.34309 .01809 L
.3815 .01831 L
.42237 .01857 L
.46172 .01887 L
.49955 .0192 L
.53984 .01961 L
.57861 .02009 L
.61984 .02071 L
.65954 .02146 L
.69774 .02239 L
.73838 .0237 L
.77751 .02547 L
.79892 .02676 L
.81909 .02831 L
.83917 .0303 L
.85764 .03273 L
.87647 .03613 L
.88716 .0387 L
.89713 .04173 L
.90758 .04585 L
.91748 .0511 L
.92637 .05759 L
.93139 .06239 L
.93604 .06791 L
.94067 .07485 L
.94567 .08469 L
.94796 .09038 L
.95038 .09747 L
.95471 .11413 L
.95717 .12701 L
.9598 .14504 L
.96229 .16834 L
.96454 .19811 L
.96593 .22281 L
.9672 .25231 L
.9686 .2961 L
.96931 .32492 L
.97008 .3643 L
.97138 .45895 L
.97211 .53858 L
s
.97211 .53858 m
.97263 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[41]:=",
  ImageSize->{299.438, 185},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^A000`40n007h00Ooooo;?oo003oool/
ool000koo`@002koo`8000Coo`03003ooooo00?oo`8002Soo`8000Coo`03003ooooo00?oo`8002So
o`8000Coo`03003ooooo00Coo`03003ooooo02Koo`8000Coo`03003ooooo00;oo`@003[oo`004?oo
00<00?ooool0;?oo00@00?ooool000Soo`04003ooooo000Vool01000ooooo`002?oo00@00?ooool0
02Koo`04003ooooo000:ool00`00ooooo`0Uool01000ooooo`002?oo00<00?ooool0>ooo000@ool0
0`00ooooo`0/ool01000ooooo`002?oo00@00?ooool002Koo`04003ooooo0008ool01000ooooo`00
9_oo00@00?ooool000Ooo`D002Koo`04003ooooo0009ool00`00ooooo`0jool000Soo`@000Coo`03
003ooooo02Koo`@000;oo`04003ooooo0009ool2000Qool40002ool01000ooooo`002?oo0`008Ooo
10000_oo00@00?ooool000Ooo`04003ooooo000Qool40002ool01000ooooo`002_oo00<00?ooool0
>Ooo000@ool00`00ooooo`0/ool01000ooooo`002?oo00@00?ooool002Koo`04003ooooo0008ool0
0`00ooooo`0Wool01000ooooo`002?oo00<00?oo00009ooo00@00?ooool000_oo`03003ooooo03So
o`003_oo0`00;_oo00@00?ooool000Soo`04003ooooo000Vool01000ooooo`002?oo00<00?ooool0
9ooo00@00?ooool000Woo`8002Ooo`04003ooooo0008ool01000ooooo`00>_oo000@ool00`00oooo
o`0]ool2000:ool2000Xool2000:ool3000Wool2000;ool00`00ooooo`0Vool2000:ool2000kool0
0?oooagoo`03003ooooo00coo`00oooo7Ooo00<00?ooool03?oo003ooolMool00`00ooooo`0<ool0
0?oooagoo`03003ooooo00coo`001oooo`007P001ooo000=oonI000:ool00`00ooooo`0:ool00`00
ooooo`0;ool00`00ooooo`0:ool00`00ooooo`0;ool00`00ooooo`0:ool00`00ooooo`0;ool00`00
ooooo`0;ool00`00ooooo`0:ool00`00ooooo`0<ool000goo`03003ooooo03Coo`03003ooooo03?o
o`03003ooooo02Woobd001?oo`03003ooooo03?oo`03003ooooo00coo`00dooo6P00;ooo00<00?oo
ool03?oo003]ool;000Tool00`00ooooo`0<ool00?Soo`D001ooo`03003ooooo00coo`00oOoo1@00
6_oo0P003Ooo003oool3ool3000Gool00`00ooooo`0<ool00?ooo`Koo`<001Coo`03003ooooo00co
o`00oooo2Ooo0P004_oo00<00?ooool03?oo003oool;ool2000@ool00`00ooooo`0<ool00?ooo`go
o`8000koo`03003ooooo00coo`00oooo3ooo00<00?ooool02ooo00<00?ooool03?oo003oool?ool0
0`00ooooo`0;ool2000=ool00?oooa3oo`03003ooooo00[oo`03003ooooo00coo`00oooo4Ooo0P00
2_oo00<00?ooool03?oo003ooolBool00`00ooooo`08ool00`00ooooo`0<ool00?oooa?oo`03003o
oooo00Ooo`03003ooooo00coo`00oooo4ooo00<00?ooool01ooo00<00?ooool03?oo003ooolDool0
0`00ooooo`06ool2000=ool00?oooaCoo`03003ooooo00Koo`03003ooooo00coo`00oooo5?oo00<0
0?ooool01_oo00<00?ooool03?oo003ooolEool00`00ooooo`05ool00`00ooooo`0<ool00?oooaGo
o`03003ooooo00Goo`03003ooooo00coo`00oooo5_oo00<00?ooool01?oo00<00?ooool03?oo003o
oolFool00`00ooooo`04ool00`00ooooo`0<ool00?oooaKoo`03003ooooo00Coo`8000goo`00oooo
5ooo00<00?ooool00ooo00<00?ooool03?oo003ooolGool00`00ooooo`03ool00`00ooooo`0<ool0
0?oooaOoo`03003ooooo00?oo`03003ooooo00coo`00oooo3_oo0`001?oo0`001Ooo00<00?ooool0
3?oo003ooolAool01000ooooo`000_oo0P001?oo00<00?ooool03?oo003ooolAool01000ooooo`00
0_oo0P001?oo0`003?oo003oool>ool30003ool00`00ooooo`020004ool00`00ooooo`0<ool00?oo
o`koo`03003ooooo00?oo`03003ooooo008000Coo`03003ooooo00coo`00oooo3_oo00<00?ooool0
0ooo00<00?ooool00P001?oo00<00?ooool03?oo003oool>ool40003ool200000ooo003oo`03ool0
0`00ooooo`0<ool00?oooaSoo`03003ooooo00;oo`03003ooooo00coo`00oooo6?oo00<00?ooool0
0_oo0P003Ooo003ooolHool00`00ooooo`02ool00`00ooooo`0<ool00?oooaSoo`03003ooooo00;o
o`03003ooooo00coo`00oooo6Ooo00D00?ooooooo`0000koo`00oooo6Ooo00D00?ooooooo`0000ko
o`00oooo6Ooo00D00?ooooooo`0000koo`00oooo6Ooo00D00?ooooooo`0000koo`00oooo6Ooo00@0
0?ooooooo`8000goo`00oooo6Ooo00D00?ooooooo`0000koo`00oooo6Ooo00D00?ooooooo`0000ko
o`00oooo6Ooo00D00?ooooooo`0000koo`00oooo6_oo00@00?ooool000koo`00oooo6_oo00@00?oo
ool000koo`00oooo6_oo00<00?ooool00P003Ooo003ooolJool01000ooooo`003_oo003ooolJool0
1000ooooo`003_oo003ooolJool01000ooooo`003_oo003ooolJool01000ooooo`003_oo003ooolJ
ool01000ooooo`003_oo003ooolJool00`00ooooo`02000=ool00?oooa[oo`04003ooooo000>ool0
0?oooa[oo`04003ooooo000>ool00?oooa[oo`04003ooooo000>ool00?oooa[oo`04003ooooo000>
ool00?ooo`Soo`@000?oo`8000Coo`8000?oo`04003ooooo000>ool00?ooo`[oo`05003oooooool0
0002ool01000ooooo`000_oo00@00?ooool000;oo`03003ooooo00coo`00oooo2_oo00D00?oooooo
o`0000;oo`04003ooooo0002ool01000ooooo`000_oo0`003?oo003oool:ool01@00oooooooo0000
0_oo00@00?ooool000;oo`04003ooooo0002ool00`00ooooo`0<ool00?ooo`[oo`05003oooooool0
0002ool01000ooooo`000_oo00@00?ooool000;oo`03003ooooo00coo`00oooo2?oo0`000ooo00@0
0?ooool000;oo`04003ooooo0002ool01000ooooo`003_oo003oool:ool00`00ooooo`02ool20004
ool20003ool01000ooooo`003_oo003ooolJool01000ooooo`003_oo003ooolJool00`00ooooo`02
000=ool00?oooa[oo`04003ooooo000>ool00?oooa[oo`04003ooooo000>ool00?oooa[oo`04003o
oooo000>ool00?oooa[oo`04003ooooo000>ool00?oooa_oo`03003oo`0000koo`00oooo6ooo00<0
0?oo00003_oo003ooolKool01000ool000003Ooo003ooolKool00`00ool0000>ool00?oooa_oo`03
003oo`0000koo`00oooo6ooo00<00?oo00003_oo003ooolKool00`00ool0000>ool00?oooa_oo`03
003oo`0000koo`00oooo6ooo00@00?oo000000goo`00oooo6ooo00<00?oo00003_oo003ooolKool0
0`00ool0000>ool00?oooa_oo`03003oo`0000koo`00oooo6ooo00<00?oo00003_oo003ooolKool0
0`00ool0000>ool00?oooa_oo`04003oo`00000=ool00?oooa_oo`03003oo`0000koo`00oooo6ooo
00<00?oo00003_oo003ooolKool00`00ool0000>ool00?oooa_oo`03003oo`0000koo`00oooo2?oo
10000_oo0`001?oo0P001?oo00<00?oo00003_oo003oool:ool00`00ooooo`04ool01000ooooo`00
0_oo00L00?ooooooo`00ool0000>ool00?ooo`[oo`03003ooooo00Coo`04003ooooo0002ool01P00
oooooooo003oo`<000coo`00oooo2_oo00@00?ooooooo`<000?oo`04003ooooo0003ool00`00ool0
000>ool00?ooo`[oo`05003oooooool00005ool01000ooooo`000ooo00<00?oo00003_oo003oool8
ool30003ool00`00ooooo`03ool01000ooooo`000ooo00<00?oo00003_oo003oool:ool01000oooo
oooo10000ooo0P001?oo00<00?oo00003_oo003ooolKool00`00ool0000>ool00?oooa_oo`04003o
o`00000=ool00?oooa_oo`03003oo`0000koo`00oooo6ooo00<00?oo00003_oo003ooolKool00`00
ool0000>ool00?oooa_oo`03003oo`0000koo`00oooo6ooo00<00?oo00003_oo003ooolKool01000
ool000003Ooo003ooolKool00`00ool0000>ool00?oooa_oo`03003oo`0000koo`00oooo6ooo00<0
0?oo00003_oo003ooolKool00`00ool0000>ool00?oooacoo`8000koo`00oooo7?oo0P003_oo003o
oolLool3000=ool00?oooacoo`8000koo`00oooo7?oo0P003_oo003ooolLool2000>ool00?oooaco
o`8000koo`00oooo7?oo0P003_oo003ooolLool3000=ool00?oooacoo`8000koo`00oooo7?oo0P00
3_oo003ooolLool2000>ool00?oooacoo`8000koo`00oooo2?oo10000ooo0P001?oo0P001Ooo0P00
3_oo003oool8ool00`00ooooo`03ool01000ooooo`000_oo00@00?ooool000Coo`8000koo`00oooo
2Ooo00<00?ooool00_oo00@00?ooool000;oo`04003ooooo0004ool4000<ool00?ooo`[oo`05003o
ooooool00002ool01000ooooo`000_oo00<00?ooool00_oo0P003_oo003oool;ool01000ooooo`00
0_oo00@00?ooool000;oo`03003ooooo00;oo`8000koo`00oooo2?oo00@00?ooool000;oo`04003o
oooo0002ool01000ooooo`001?oo0P003_oo003oool9ool20004ool20004ool20005ool2000>ool0
0?oooacoo`8000koo`00oooo7?oo0`003Ooo003ooolLool2000>ool00?oooacoo`8000koo`00oooo
7?oo0P003_oo003ooolLool2000>ool00?oooacoo`8000koo`00oooo7?oo0`003Ooo003ooolLool2
000>ool00?oooacoo`8000koo`00oooo7?oo0P003_oo003ooolLool2000>ool00?oooacoo`8000ko
o`00oooo7?oo0P003_oo003ooolLool3000=ool00?oooacoo`8000koo`00oooo7?oo0P003_oo003o
oolLool2000>ool00?oooacoo`8000koo`00oooo7?oo0P003_oo003ooolLool3000=ool00?oooaco
o`8000koo`00oooo7?oo0P003_oo003ooolLool2000>ool00?ooo`Soo`@000;oo`<000Coo`8000Go
o`8000koo`00oooo2?oo00<00?ooool01_oo00@00?ooool000;oo`03003ooooo00;oo`8000koo`00
oooo2Ooo00<00?ooool01Ooo00@00?ooool000;oo`03003ooooo00;oo`@000coo`00oooo2_oo00@0
0?ooooooo`<000?oo`04003ooooo0004ool2000>ool00?ooo`_oo`04003ooooo0005ool01000oooo
o`001?oo0P003_oo003oool8ool01000ooooo`000_oo00<00?ooool00ooo00@00?ooool000Coo`80
00koo`00oooo2Ooo0P000ooo10000ooo0P001Ooo0P003_oo003ooolLool2000>ool00?oooacoo`80
00koo`00oooo7?oo0`003Ooo003ooolLool2000>ool00?oooacoo`8000koo`00oooo7?oo0P003_oo
003ooolLool2000>ool00?oooacoo`8000koo`00\
\>"],
  ImageRangeCache->{{{74.875, 373.312}, {688.688, 504.688}} -> {-1.328, \
772.229, 0.0036949, 1.56914}},
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],

Cell[TextData[{
  "The default setting ",
  StyleBox["MaxSteps", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["10000", "MR"],
  " should be sufficient for most equations with smooth solutions. When \
solutions have a complicated structure, however, you may sometimes have to \
choose larger settings for ",
  StyleBox["MaxSteps", "MR"],
  ". With the setting ",
  StyleBox["MaxSteps", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Infinity", "MR"],
  " there is no upper limit on the number of steps used. "
}], "Text",
  CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"}],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " has several different methods built in for computing solutions as well as \
a mechanism for adding additional methods.  With the default setting ",
  StyleBox["Method->Automatic", "MR"],
  ", ",
  StyleBox["NDSolve", "MR"],
  " will choose a method which should be appropriate for the differential \
equations.  For example, if the equations have stiffness, implicit methods \
will be used as needed, or if the equations make a DAE, a special DAE method \
will be used.  In general, it is not possible to determine the nature of \
solutions to differential equations without actually solving them: thus, the \
default Automatic methods are good for solving as wide variety of problems, \
but the one chosen may not be the best one available for your particular \
problem.  Also, you may want to choose methods, such as symplectic \
integrators, which preserve certain properties of the solution."
}], "Text",
  CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],

Cell[TextData[{
  "Choosing an appropriate method for a particular system can be quite \
difficult.  To complicate it further, many methods have their own settings \
which can greatly affect solution efficiency and accuracy.  Much of this \
documentation consists of descriptions of methods to give you an idea of when \
they should be used and how to adjust them to solve particular problems.  \
Furthermore, ",
  StyleBox["NDSolve", "MR"],
  " has a ",
  ButtonBox["mechanism",
    ButtonData:>{"Plug-ins.nb", "Plug-in"},
    ButtonStyle->"Hyperlink"],
  " that allows you to define your own methods and still have the equations \
and results processed by NDSolve just as for the built-in methods.  "
}], "Text",
  CellTags->{"b:1", "ndsg:0"}],

Cell[TextData[{
  "When ",
  StyleBox["NDSolve", "MR"],
  " computes a solution, there are typically three phases. First, the \
equations are processed, usually into a function which represents the right \
hand side of the equations in normal form.  Next, the function is used to \
iterate the solution from the initial conditions.  Finally, data saved during \
the iteration procedure is processed into one or more  ",
  StyleBox["InterpolatingFunction", "MR",
    FontFamily->"Courier"],
  StyleBox["s", "MR"],
  ".  Using functions in the ",
  StyleBox["NDSolve`", "MR",
    FontFamily->"Courier"],
  " context, you can run these steps separately and, more importantly, have \
more control over the iteration process.  The steps are tied by an ",
  StyleBox[ButtonBox["NDSolve`StateData",
    ButtonData:>{"StateData.nb", None},
    ButtonStyle->"Hyperlink"], "MR"],
  " object which keeps all of the data necessary for solving the differential \
equations."
}], "Text",
  CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Design", "Section",
  CellTags->"s:2"],

Cell[CellGroupData[{

Cell["Features", "Subsection",
  CellTags->"s:2.1"],

Cell["\<\
Supporting a large number of numerical integration methods for \
differential equations is a lot of work.\
\>", "Text"],

Cell["\<\
In order to cut down on maintenance and duplication of code, common \
components are shared between methods.\
\>", "Text"],

Cell["\<\
This approach also allows code optimization to be carried out in \
just a few central routines.\
\>", "Text"],

Cell[TextData[{
  "The principal features of the ",
  StyleBox["NDSolve", "MR"],
  " framework are:"
}], "Text"],

Cell["Uniform design and interface.", "BulletedList"],

Cell["Code reuse (common code base).", "BulletedList"],

Cell["\<\
Objection orientation (method property specification and \
communication).\
\>", "BulletedList"],

Cell["Data hiding.", "BulletedList"],

Cell["\<\
Separation of method initialization phase and run-time computation.\
\
\>", "BulletedList"],

Cell["Numerical methods are hierarchical and reentrant.", "BulletedList"],

Cell[TextData[{
  "Uniform treatment of rounding errors (see [",
  ButtonBox["HLW02",
    ButtonData:>{"References.nb", "HLW02"},
    ButtonStyle->"Hyperlink"],
  "], [",
  ButtonBox["SS02",
    ButtonData:>{"References.nb", "SS02"},
    ButtonStyle->"Hyperlink"],
  "] and the references therein)."
}], "BulletedList"],

Cell[TextData[{
  "Vectorized framework based on a generalization of the BLAS model [",
  ButtonBox["LAPACK99",
    ButtonData:>{"References.nb", "LAPACK99"},
    ButtonStyle->"Hyperlink"],
  "] using optimized in-place arithmetic."
}], "BulletedList"],

Cell[TextData[{
  "Many schemes such as ",
  StyleBox["ExplicitRungeKutta", "MR"],
  " and  ",
  StyleBox["ImplicitRungeKutta", "MR"],
  " use a tensor framework that allows families of methods to share one \
implementation."
}], "BulletedList"],

Cell["All methods are type and precision dynamic.", "BulletedList"],

Cell["\<\
Plug-in capabilities allow user extensibility and \
prototyping.\
\>", "BulletedList"],

Cell["Specialized data structures.", "BulletedList"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common time stepping", "Subsection",
  CellTags->"s:2.2"],

Cell["\<\
A common time stepping mechanism is used for all one-step methods. \
The routine handles a number of different criteria including:\
\>", "Text"],

Cell["\<\
step sizes in a numerical integration do not become too small in \
value, which may happen in solving stiff systems\
\>", "BulletedList"],

Cell["\<\
step sizes do not change sign unexpectedly, which may be a \
consequence of user programming error\
\>", "BulletedList"],

Cell["step sizes are not increased after a step rejection", "BulletedList"],

Cell["\<\
step sizes are not decreased drastically towards the end of an \
integration\
\>", "BulletedList"],

Cell["\<\
specified (or detected) singularities are handled by restarting the \
integration\
\>", "BulletedList"],

Cell["\<\
divergence of iterations in implicit methods (e.g. using fixed \
large step sizes)\
\>", "BulletedList"],

Cell["unrecoverable integration errors (e.g. numerical exceptions)", \
"BulletedList"],

Cell["\<\
rounding error feedback (compensated summation) is particularly \
advantageous for high order methods or methods that conserve specific \
quantities during the numerical integration.\
\>", "BulletedList"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data encapsulation", "Subsection",
  CellTags->"s:2.3"],

Cell[TextData[{
  "Each method has its own data object that contains information that is \
needed for the invocation of the method. This includes, but is not limited \
to, coefficients, workspaces, step size control parameters, step size \
acceptance/rejection information, and Jacobian matrices. This is a \
generalization of the ideas used in codes like LSODA ([",
  ButtonBox["H83",
    ButtonData:>{"References.nb", "H83"},
    ButtonStyle->"Hyperlink"],
  "], [",
  ButtonBox["P83",
    ButtonData:>{"References.nb", "P83"},
    ButtonStyle->"Hyperlink"],
  "])."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method hierarchy", "Subsection",
  CellTags->"s:2.4"],

Cell[TextData[{
  "Methods are reentrant and hierarchical, meaning that one method can call \
another. This is a generalization of the ideas used in the Generic ODE \
Solving System, Godess (see [",
  ButtonBox["O95",
    ButtonData:>{"References.nb", "O95"},
    ButtonStyle->"Hyperlink"],
  "], [",
  ButtonBox["O98",
    ButtonData:>{"References.nb", "O98"},
    ButtonStyle->"Hyperlink"],
  "] and the references therein), which is implemented in C++."
}], "Text"],

Cell[CellGroupData[{

Cell["Initial design", "Subsubsection"],

Cell["\<\
The original method framework design allowed a number of methods to \
be invoked in the solver.\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        FrameBox[
          StyleBox["NDSolve",
            "MR"],
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
  " ",
  "\[LongRightArrow]",
  " ",
  Cell[BoxData[
      FormBox[
        FrameBox["ExplicitRungeKutta",
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        FrameBox[
          StyleBox["NDSolve",
            "MR"],
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
  " ",
  "\[LongRightArrow]",
  " ",
  Cell[BoxData[
      FormBox[
        FrameBox["ImplicitRungeKutta",
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["First revision", "Subsubsection"],

Cell["\<\
This was later extended to allow one method to call another in a \
sequential fashion, with an arbitrary number of levels of nesting.\
\>", \
"Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        FrameBox[
          StyleBox["NDSolve",
            "MR"],
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
  " \[LongRightArrow] ",
  Cell[BoxData[
      FormBox[
        FrameBox["Extrapolation",
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
  " ",
  "\[LongRightArrow]",
  " ",
  Cell[BoxData[
      FormBox[
        FrameBox["ExplicitMidpoint",
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]]
}], "Text"],

Cell["\<\
The construction of compound integration methods is particularly \
useful in geometric numerical integration.\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        FrameBox[
          StyleBox["NDSolve",
            "MR"],
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
  " ",
  "\[LongRightArrow]",
  " ",
  Cell[BoxData[
      FormBox[
        FrameBox["Projection",
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
  " \[LongRightArrow] ",
  Cell[BoxData[
      FormBox[
        FrameBox["ExplicitRungeKutta",
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second revision", "Subsubsection"],

Cell["\<\
A more general tree invocation process was required to implement \
composition methods:\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        FrameBox[
          StyleBox["NDSolve",
            "MR"],
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
  " ",
  Cell[BoxData[
      FormBox[GridBox[{
            {"\[LongRightArrow]", 
              RowBox[{
                FrameBox[
                  StyleBox["Composition",
                    "Text"],
                  BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], " ", 
                FormBox[GridBox[{
                      {"\[UpperRightArrow]", 
                        FrameBox["ExplicitEuler",
                          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}]},
                      {"\[VerticalEllipsis]", "\[VerticalEllipsis]"},
                      {"\[LongRightArrow]", GridBox[{
                            {
                              FrameBox["ImplicitEuler",
                                BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], ""}
                            }]},
                      {"\[VerticalEllipsis]", "\[VerticalEllipsis]"},
                      {"\[LowerRightArrow]", GridBox[{
                            {
                              FrameBox["ExplicitEuler",
                                BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], ""}
                            }]}
                      }],
                  "TraditionalForm"]}]}
            }], TraditionalForm]]]
}], "Text"],

Cell["This is an example of a method composed with its adjoint.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Current state", "Subsubsection"],

Cell["\<\
The tree invocation process was extended to allow for a subfield to \
be solved by each method, instead of the entire vector field.\
\>", "Text"],

Cell[TextData[{
  "This example turns up in the ABC flow (see ",
  ButtonBox["Composition and Splitting",
    ButtonData:>{"Splitting.nb", None},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        FrameBox[
          StyleBox["NDSolve",
            "MR"],
          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
  " ",
  Cell[BoxData[
      FormBox[GridBox[{
            {"\[LongRightArrow]", 
              RowBox[{
                RowBox[{
                  FrameBox[
                    RowBox[{
                      StyleBox[\(Splitting\ f\),
                        "Text"], 
                      StyleBox["=",
                        "Text"], 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["f",
                            "Text"], "1"], "+", \(f\_2\)}]}],
                    BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], " "}], " ", 
                FormBox[GridBox[{
                      {"\[UpperRightArrow]", 
                        FrameBox[\(LocallyExact\ \ f\_1\),
                          BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}]},
                      {"\[LongRightArrow]", GridBox[{
                            {
                              FrameBox[\(ImplicitMidpoint\ f\_2\),
                                BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], ""}
                            }]},
                      {"\[LowerRightArrow]", GridBox[{
                            {
                              FrameBox[\(LocallyExact\ f\_1\),
                                BoxMargins->{{0.2, 0.2}, {0.4, 0.4}}], ""}
                            }]}
                      }],
                  "TraditionalForm"]}]}
            }], TraditionalForm]]]
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["User extensibility", "Subsection",
  CellTags->"s:2.5"],

Cell["\<\
Built-in methods can be used as building blocks for the efficient \
construction of special purpose (compound) integrators. User defined methods \
can also be added.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method classes", "Subsection",
  CellTags->"s:2.6"],

Cell[TextData[{
  "Methods such as ",
  StyleBox["ExplicitRungeKutta", "MR"],
  " include a number of schemes of different orders. Moreover, alternative \
coefficient choices can be specified by the user. This is a generalization of \
the ideas found in RKSUITE [",
  ButtonBox["BGS93",
    ButtonData:>{"References.nb", "BGS93"},
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Automatic selection and user controllability", "Subsection",
  CellTags->"s:2.7"],

Cell["\<\
The framework provides automatic step size selection and method \
order selection. Methods are user configurable via method options.\
\>", \
"Text"],

Cell[TextData[{
  "For example a user can select the class of ",
  StyleBox["ExplicitRungeKutta", "MR"],
  " methods and the code will automatically attempt to ascertain the \
\"optimal\" order according to problem, the relative and absolute local error \
tolerances, and the initial step size estimate."
}], "Text"],

Cell[TextData[{
  "Here is a list of options appropriate for ",
  StyleBox["ExplicitRungeKutta", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[NDSolve`ExplicitRungeKutta]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({"Coefficients" \[Rule] "EmbeddedExplicitRungeKuttaCoefficients", 
      "DifferenceOrder" \[Rule] Automatic, 
      "EmbeddedDifferenceOrder" \[Rule] Automatic, 
      "StepSizeControlParameters" \[Rule] Automatic, 
      "StepSizeRatioBounds" \[Rule] {1\/8, 4}, 
      "StepSizeSafetyFactors" \[Rule] {9\/10, 9\/10}, 
      "StiffnessTest" \[Rule] Automatic}\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shared features", "Subsection",
  CellTags->"s:2.8"],

Cell[TextData[{
  "These features are not necessarily restricted to ",
  StyleBox["NDSolve", "MR"],
  " since they can also be used for other types of numerical methods."
}], "Text"],

Cell[TextData[{
  "Function evaluation is performed using a ",
  StyleBox["NumericalFunction", "MR"],
  " that dynamically changes type as needed, such as when IEEE floating point \
overflow or underflow occurs. It also calls ",
  StyleBox["Mathematica'",
    FontSlant->"Italic"],
  "s compiler ",
  StyleBox["Compile", "MR"],
  " for efficiency when appropriate."
}], "BulletedList"],

Cell["\<\
Jacobian evaluation uses symbolic differentiation or finite \
difference approximations, including automatic or user specifiable sparsity \
detection.\
\>", "BulletedList"],

Cell["\<\
Dense linear algebra is based on LAPACK and sparse linear algebra \
uses special purpose packages such as UMFPACK.\
\>", "BulletedList"],

Cell["\<\
Common subexpressions in the numerical evaluation of the function \
representing a differential system are detected and collected to avoid \
repeated work.\
\>", "BulletedList"],

Cell[TextData[{
  "Other supporting functionality that has been implemented is described in \
",
  StyleBox[ButtonBox["Norm",
    ButtonData:>{"VectorNorm.nb", None},
    ButtonStyle->"Hyperlink"], "MR"],
  ButtonBox[" and ",
    ButtonData:>{"VectorNorm.nb", None},
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["ScaledVectorNorm",
    ButtonData:>{"VectorNorm.nb", None},
    ButtonStyle->"Hyperlink"], "MR"],
  "."
}], "BulletedList"],

Cell["\<\
This system dynamically switches type from real to complex during \
the numerical integration, automatically recompiling as needed.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[1/2] /. 
      NDSolve[{\(y'\)[t] \[Equal] Sqrt[y[t]] - 1, y[0] \[Equal] 1/10}, 
        y, {t, 0, 1}, Method \[Rule] ExplicitRungeKutta]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({\(-0.34904263429088933`\) + 
        0.15044141626052263`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some basic methods", "Subsection",
  CellTags->"s:2.9"],

Cell["\<\
The following table gives some of the one-step methods that have \
been implemented:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[GridBox[{
            {
              StyleBox["Order",
                FontWeight->"Bold"], 
              StyleBox["Method",
                FontWeight->"Bold"], 
              StyleBox["Formula",
                FontWeight->"Bold"]},
            {
              "1", \(Explicit\ Euler\), \(y\_\(n + 1\) = 
                y\_n + \(h\_n\) \(f(t\_n, y\_n)\)\)},
            {
              "2", \(Explicit\ Midpoint\), \(y\_\(n + 1/2\) = \ 
                y\_n + \ \(h\_n\/2\) \(f(t\_n, y\_n)\)\[IndentingNewLine]
              
              y\_\(n + 1\) = \ 
                y\_n + \ \(h\_n\) \(f(t\_\(n + 1/2\), y\_\(n + 1/2\))\)\)},
            {"1", \(Backward\ or\ Implicit\ Euler\[IndentingNewLine]
              \ \ \ \ \ \ \ \ \ \((1\ stage\ RadauIIA)\)\), \(y\_\(n + 1\) = \
\ y\_n + \ \(h\_n\) \(f(t\_\(n + 1\), y\_\(n + 1\))\)\)},
            {"2", \(Implicit\ Midpoint\[IndentingNewLine]
              \ \ \ \ \ \((1\ stage\ Gauss)\)\), \(y\_\(n + 1\) = 
                y\_n + \ 
                  h\_n\ \(f(
                      t\_\(n + 1/2\), \(1\/2\) \((y\_\(n + 1\) + \ 
                            y\_n)\))\)\)},
            {"2", \(\(\ \ \ \ \ \ \ \ \ \ \)\(Trapezoidal\[IndentingNewLine]
              \((2\ stage\ Lobatto\ IIIA)\)\)\), \(y\_\(n + 1\) = 
                y\_n + \(h\_n\/2\) \((f(t\_n, y\_n) + 
                        f(t\_\(n + 1\), y\_\(n + 1\)))\)\)},
            {
              "1", \(Linearly\ Implicit\ Euler\), \(\((I - \(h\_n\) 
                        J)\) \((y\_\(n + 1\) - y\_n)\)\  = \ \(h\_n\) \(f(
                    t\_n, y\_n)\)\)},
            {
              "2", \(Linearly\ Implicit\ Midpoint\), \(\(\ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \)\(\((I - \(h\_n\/2\) J)\) \((y\_\(n + 1/2\) - 
                      y\_n)\)\  = \ \(h\_n\/2\) \(f(t\_n, 
                    y\_n)\)\[IndentingNewLine]
              \((I\  - \ \(h\_n\/2\) 
                        J)\)\ \((\[CapitalDelta]y\_n - \[CapitalDelta]y\_\(n \
- 1/2\))\)\/2 = \ \(h\_n\/2\) \(f(t\_\(n + 1/2\), 
                      y\_\(n + 1/2\))\) - \[CapitalDelta]y\_\(n - 1/2\)\)\)}
            },
          RowLines->True,
          ColumnLines->True]], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "Here ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]y\_n = \ 
        y\_\(n + 1\) - \ y\_\(n + 1/2\)\)]],
  ", I denotes the identity matrix and J denotes the Jacobian matrix ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]f\/\[PartialD]y\) \((t\_n, y\_n)\)\)]]
}], "Text"],

Cell[TextData[{
  "Although the implicit midpoint method has not been implemented as a \
separate method, it is available through the one stage Guass scheme of the ",
  StyleBox["ImplicitRungeKutta", "MR"],
  " method."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Acknowledgements", "Subsection",
  CellTags->"s:2.10"],

Cell[TextData[{
  "A number of people have helped in shaping the design and implementation of \
the methods and framework in ",
  StyleBox["NDSolve", "MR"],
  ". We would like to thank them for sharing their experience and their \
enthusiasm for the project."
}], "Text"],

Cell["\<\
Thanks to Giulia Spaletta who collaborated in the development of a \
number of methods.\
\>", "Text"],

Cell["\<\
Thanks to Alan Hindmarsh for allowing us to use the codes LSODA, \
CVODE and IDA.\
\>", "Text"],

Cell["\<\
Thanks also to the following people for fruitful discussions: John \
Butcher, Jeff Cash, Ernst Hairer, Robert McLachlan, Per Christian Moan, \
Reinout Quispel.\
\>", "Text"],

Cell[TextData[{
  "Aspects of the new framework have been presented at various symposia and \
workshops over the years. We would particularly like to thank the groups at \
",
  ButtonBox["Bergen and Trondheim, Norway,",
    ButtonData:>{
      URL[ "http://www.math.ntnu.no/num/synode/people.php"], None},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Bari, Italy",
    ButtonData:>{
      URL[ "http://www.dm.uniba.it/%7Edelbuono/homegnig.htm"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell["\<\
Thanks also to Andrew Hunt of Wolfram Research for a number of \
stylistic improvements to the documentation.\
\>", "Text"],

Cell["Robert Knapp and Mark Sofroniou.", "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDSolve Overview",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "s:1"->{
    Cell[1828, 57, 50, 1, 66, "Section",
      CellTags->"s:1"]},
  "S3.9.7"->{
    Cell[1881, 60, 1186, 29, 104, "Text",
      CellTags->{"S3.9.7", "7.2", "b:1", "ndsg:0"}],
    Cell[7917, 238, 134, 4, 16, "Caption",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[8054, 244, 2753, 79, 200, "Text",
      CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"}],
    Cell[10810, 325, 413, 17, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"}],
    Cell[11248, 346, 132, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[11678, 361, 1940, 48, 70, "Text",
      CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"}],
    Cell[13621, 411, 210, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"}],
    Cell[13856, 420, 157, 5, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[14311, 438, 105, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"}],
    Cell[14441, 443, 122, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[26411, 830, 112, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"}],
    Cell[26548, 835, 164, 5, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[26715, 842, 290, 8, 70, "Output",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[27020, 853, 249, 6, 70, "Text",
      CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"}],
    Cell[27272, 861, 146, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"}],
    Cell[28230, 893, 106, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"}],
    Cell[83978, 3426, 255, 6, 70, "Text",
      CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"}],
    Cell[84236, 3434, 146, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"}],
    Cell[84407, 3442, 138, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[116837, 4475, 669, 21, 70, "Text",
      CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"}],
    Cell[117509, 4498, 189, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[124205, 4668, 310, 6, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[213950, 6387, 159, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[222074, 6639, 133, 4, 70, "Caption",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[222210, 6645, 183, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],
    Cell[222999, 6672, 104, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],
    Cell[300476, 8230, 242, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"}],
    Cell[301681, 8264, 123, 3, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"}],
    Cell[421122, 10653, 527, 13, 70, "Text",
      CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"}],
    Cell[421652, 10668, 2132, 59, 70, "Text",
      CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"}],
    Cell[424710, 10758, 159, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"}],
    Cell[424894, 10766, 270, 7, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[425434, 10785, 122, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"}],
    Cell[425581, 10790, 93, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[425815, 10800, 357, 8, 70, "Text",
      CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"}],
    Cell[426175, 10810, 789, 20, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
    Cell[426967, 10832, 151, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"}],
    Cell[427143, 10840, 138, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[427916, 10865, 245, 7, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"}],
    Cell[428186, 10876, 121, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[439934, 11254, 590, 19, 70, "Text",
      CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"}],
    Cell[440527, 11275, 1006, 17, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
    Cell[442284, 11311, 1022, 22, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}]},
  "7.2"->{
    Cell[1881, 60, 1186, 29, 104, "Text",
      CellTags->{"S3.9.7", "7.2", "b:1", "ndsg:0"}]},
  "b:1"->{
    Cell[1881, 60, 1186, 29, 104, "Text",
      CellTags->{"S3.9.7", "7.2", "b:1", "ndsg:0"}],
    Cell[7917, 238, 134, 4, 16, "Caption",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[8054, 244, 2753, 79, 200, "Text",
      CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"}],
    Cell[10810, 325, 413, 17, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"}],
    Cell[11248, 346, 132, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[11383, 350, 280, 8, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[11678, 361, 1940, 48, 70, "Text",
      CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"}],
    Cell[13621, 411, 210, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"}],
    Cell[13856, 420, 157, 5, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[14016, 427, 280, 8, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[14311, 438, 105, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"}],
    Cell[14441, 443, 122, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[14566, 447, 11830, 380, 70, 3875, 276, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[26411, 830, 112, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"}],
    Cell[26548, 835, 164, 5, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[26715, 842, 290, 8, 70, "Output",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[27020, 853, 249, 6, 70, "Text",
      CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"}],
    Cell[27272, 861, 146, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"}],
    Cell[28230, 893, 106, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"}],
    Cell[28361, 898, 208, 4, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[83978, 3426, 255, 6, 70, "Text",
      CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"}],
    Cell[84236, 3434, 146, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"}],
    Cell[84407, 3442, 138, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[99044, 3937, 556, 11, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[116837, 4475, 669, 21, 70, "Text",
      CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"}],
    Cell[117509, 4498, 189, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[117723, 4506, 818, 21, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[118544, 4529, 5347, 126, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[123906, 4658, 296, 8, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[124205, 4668, 310, 6, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[124540, 4678, 166, 4, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[124709, 4684, 88510, 1686, 70, 24066, 885, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[213234, 6373, 713, 12, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[213950, 6387, 159, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[214134, 6395, 333, 8, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[214470, 6405, 283, 8, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[214768, 6416, 201, 5, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[222074, 6639, 133, 4, 70, "Caption",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[222210, 6645, 183, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],
    Cell[222418, 6654, 269, 5, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[222690, 6661, 294, 8, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[222999, 6672, 104, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],
    Cell[223128, 6677, 180, 5, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[223311, 6684, 76404, 1526, 70, 21994, 849, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[299730, 8213, 743, 15, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[300476, 8230, 242, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"}],
    Cell[300743, 8239, 606, 11, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[301681, 8264, 123, 3, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"}],
    Cell[301829, 8271, 181, 5, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[421122, 10653, 527, 13, 70, "Text",
      CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"}],
    Cell[421652, 10668, 2132, 59, 70, "Text",
      CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"}],
    Cell[424710, 10758, 159, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"}],
    Cell[424894, 10766, 270, 7, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[425434, 10785, 122, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"}],
    Cell[425581, 10790, 93, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[425815, 10800, 357, 8, 70, "Text",
      CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"}],
    Cell[426175, 10810, 789, 20, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
    Cell[426967, 10832, 151, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"}],
    Cell[427143, 10840, 138, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[427284, 10844, 240, 5, 70, "Message",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[427527, 10851, 374, 11, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[427916, 10865, 245, 7, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"}],
    Cell[428186, 10876, 121, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[428310, 10880, 11609, 371, 70, 3886, 270, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[439934, 11254, 590, 19, 70, "Text",
      CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"}],
    Cell[440527, 11275, 1006, 17, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
    Cell[441536, 11294, 745, 15, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[442284, 11311, 1022, 22, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}]},
  "ndsg:0"->{
    Cell[1881, 60, 1186, 29, 104, "Text",
      CellTags->{"S3.9.7", "7.2", "b:1", "ndsg:0"}],
    Cell[7917, 238, 134, 4, 16, "Caption",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[8054, 244, 2753, 79, 200, "Text",
      CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"}],
    Cell[10810, 325, 413, 17, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"}],
    Cell[11248, 346, 132, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[11383, 350, 280, 8, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[11678, 361, 1940, 48, 70, "Text",
      CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"}],
    Cell[13621, 411, 210, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"}],
    Cell[13856, 420, 157, 5, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[14016, 427, 280, 8, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[14311, 438, 105, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"}],
    Cell[14441, 443, 122, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[14566, 447, 11830, 380, 70, 3875, 276, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[26411, 830, 112, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"}],
    Cell[26548, 835, 164, 5, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[26715, 842, 290, 8, 70, "Output",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[27020, 853, 249, 6, 70, "Text",
      CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"}],
    Cell[27272, 861, 146, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"}],
    Cell[28230, 893, 106, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"}],
    Cell[28361, 898, 208, 4, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[83978, 3426, 255, 6, 70, "Text",
      CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"}],
    Cell[84236, 3434, 146, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"}],
    Cell[84407, 3442, 138, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[99044, 3937, 556, 11, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[116837, 4475, 669, 21, 70, "Text",
      CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"}],
    Cell[117509, 4498, 189, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[117723, 4506, 818, 21, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[118544, 4529, 5347, 126, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[123906, 4658, 296, 8, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[124205, 4668, 310, 6, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[124540, 4678, 166, 4, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[124709, 4684, 88510, 1686, 70, 24066, 885, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[213234, 6373, 713, 12, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[213950, 6387, 159, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[214134, 6395, 333, 8, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[214470, 6405, 283, 8, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[214768, 6416, 201, 5, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[222074, 6639, 133, 4, 70, "Caption",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[222210, 6645, 183, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],
    Cell[222418, 6654, 269, 5, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[222690, 6661, 294, 8, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[222999, 6672, 104, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],
    Cell[223128, 6677, 180, 5, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[223311, 6684, 76404, 1526, 70, 21994, 849, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[299730, 8213, 743, 15, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[300476, 8230, 242, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"}],
    Cell[300743, 8239, 606, 11, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[301681, 8264, 123, 3, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"}],
    Cell[301829, 8271, 181, 5, 70, "Input",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[421122, 10653, 527, 13, 70, "Text",
      CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"}],
    Cell[421652, 10668, 2132, 59, 70, "Text",
      CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"}],
    Cell[424710, 10758, 159, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"}],
    Cell[424894, 10766, 270, 7, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[425434, 10785, 122, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"}],
    Cell[425581, 10790, 93, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[425815, 10800, 357, 8, 70, "Text",
      CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"}],
    Cell[426175, 10810, 789, 20, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
    Cell[426967, 10832, 151, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"}],
    Cell[427143, 10840, 138, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[427284, 10844, 240, 5, 70, "Message",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[427527, 10851, 374, 11, 70, "Output",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[427916, 10865, 245, 7, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"}],
    Cell[428186, 10876, 121, 2, 70, "Input",
      CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
    Cell[428310, 10880, 11609, 371, 70, 3886, 270, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[439934, 11254, 590, 19, 70, "Text",
      CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"}],
    Cell[440527, 11275, 1006, 17, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
    Cell[441536, 11294, 745, 15, 70, "Text",
      CellTags->{"b:1", "ndsg:0"}],
    Cell[442284, 11311, 1022, 22, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}]},
  "7.4"->{
    Cell[8054, 244, 2753, 79, 200, "Text",
      CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"}]},
  "7.5"->{
    Cell[10810, 325, 413, 17, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"}]},
  "7.8"->{
    Cell[11678, 361, 1940, 48, 70, "Text",
      CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"}]},
  "7.6"->{
    Cell[13621, 411, 210, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"}]},
  "7.10"->{
    Cell[14311, 438, 105, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"}]},
  "7.7"->{
    Cell[26411, 830, 112, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"}]},
  "7.18"->{
    Cell[27020, 853, 249, 6, 70, "Text",
      CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"}]},
  "7.19"->{
    Cell[27272, 861, 146, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"}]},
  "7.17"->{
    Cell[28230, 893, 106, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"}]},
  "7.15"->{
    Cell[83978, 3426, 255, 6, 70, "Text",
      CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"}]},
  "7.16"->{
    Cell[84236, 3434, 146, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"}]},
  "7.22"->{
    Cell[116837, 4475, 669, 21, 70, "Text",
      CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"}]},
  "7.23"->{
    Cell[117509, 4498, 189, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[124205, 4668, 310, 6, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],
    Cell[213950, 6387, 159, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}]},
  "7.25"->{
    Cell[222210, 6645, 183, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],
    Cell[222999, 6672, 104, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}]},
  "7.46"->{
    Cell[300476, 8230, 242, 5, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"}]},
  "7.47"->{
    Cell[301681, 8264, 123, 3, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"}]},
  "7.30"->{
    Cell[421122, 10653, 527, 13, 70, "Text",
      CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"}]},
  "7.27"->{
    Cell[421652, 10668, 2132, 59, 70, "Text",
      CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"}]},
  "7.28"->{
    Cell[424710, 10758, 159, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"}]},
  "7.29"->{
    Cell[425434, 10785, 122, 1, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"}]},
  "7.33"->{
    Cell[425815, 10800, 357, 8, 70, "Text",
      CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"}]},
  "7.36"->{
    Cell[426175, 10810, 789, 20, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
    Cell[440527, 11275, 1006, 17, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
    Cell[442284, 11311, 1022, 22, 70, "Text",
      CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}]},
  "7.37"->{
    Cell[426967, 10832, 151, 4, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"}]},
  "7.38"->{
    Cell[427916, 10865, 245, 7, 70, "MathCaption",
      CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"}]},
  "7.39"->{
    Cell[439934, 11254, 590, 19, 70, "Text",
      CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"}]},
  "s:2"->{
    Cell[443343, 11338, 44, 1, 70, "Section",
      CellTags->"s:2"]},
  "s:2.1"->{
    Cell[443412, 11343, 51, 1, 70, "Subsection",
      CellTags->"s:2.1"]},
  "s:2.2"->{
    Cell[445494, 11426, 63, 1, 70, "Subsection",
      CellTags->"s:2.2"]},
  "s:2.3"->{
    Cell[446762, 11473, 61, 1, 70, "Subsection",
      CellTags->"s:2.3"]},
  "s:2.4"->{
    Cell[447443, 11495, 59, 1, 70, "Subsection",
      CellTags->"s:2.4"]},
  "s:2.5"->{
    Cell[454076, 11725, 61, 1, 40, "Subsection",
      CellTags->"s:2.5"]},
  "s:2.6"->{
    Cell[454366, 11737, 57, 1, 40, "Subsection",
      CellTags->"s:2.6"]},
  "s:2.7"->{
    Cell[454843, 11755, 87, 1, 40, "Subsection",
      CellTags->"s:2.7"]},
  "s:2.8"->{
    Cell[456121, 11798, 58, 1, 40, "Subsection",
      CellTags->"s:2.8"]},
  "s:2.9"->{
    Cell[458285, 11873, 61, 1, 40, "Subsection",
      CellTags->"s:2.9"]},
  "s:2.10"->{
    Cell[461301, 11950, 60, 1, 70, "Subsection",
      CellTags->"s:2.10"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"s:1", 463551, 12025},
  {"S3.9.7", 463631, 12028},
  {"7.2", 467849, 12115},
  {"b:1", 467956, 12118},
  {"ndsg:0", 474400, 12259},
  {"7.4", 480841, 12400},
  {"7.5", 480949, 12403},
  {"7.8", 481063, 12406},
  {"7.6", 481171, 12409},
  {"7.10", 481285, 12412},
  {"7.7", 481399, 12415},
  {"7.18", 481513, 12418},
  {"7.19", 481621, 12421},
  {"7.17", 481736, 12424},
  {"7.15", 481851, 12427},
  {"7.16", 481960, 12430},
  {"7.22", 482076, 12433},
  {"7.23", 482187, 12436},
  {"7.25", 482512, 12443},
  {"7.46", 482733, 12448},
  {"7.47", 482850, 12451},
  {"7.30", 482967, 12454},
  {"7.27", 483079, 12457},
  {"7.28", 483192, 12460},
  {"7.29", 483310, 12463},
  {"7.33", 483428, 12466},
  {"7.36", 483539, 12469},
  {"7.37", 483851, 12476},
  {"7.38", 483969, 12479},
  {"7.39", 484087, 12482},
  {"s:2", 484198, 12485},
  {"s:2.1", 484282, 12488},
  {"s:2.2", 484371, 12491},
  {"s:2.3", 484460, 12494},
  {"s:2.4", 484549, 12497},
  {"s:2.5", 484638, 12500},
  {"s:2.6", 484727, 12503},
  {"s:2.7", 484816, 12506},
  {"s:2.8", 484905, 12509},
  {"s:2.9", 484994, 12512},
  {"s:2.10", 485084, 12515}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 27, 0, 95, "Chapter"],

Cell[CellGroupData[{
Cell[1828, 57, 50, 1, 66, "Section",
  CellTags->"s:1"],
Cell[1881, 60, 1186, 29, 104, "Text",
  CellTags->{"S3.9.7", "7.2", "b:1", "ndsg:0"}],
Cell[3070, 91, 4844, 145, 100, "DefinitionBox"],
Cell[7917, 238, 134, 4, 16, "Caption",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[8054, 244, 2753, 79, 200, "Text",
  CellTags->{"S3.9.7", "7.4", "b:1", "ndsg:0"}],
Cell[10810, 325, 413, 17, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.5", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[11248, 346, 132, 2, 70, "Input",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[11383, 350, 280, 8, 70, "Output",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[11678, 361, 1940, 48, 70, "Text",
  CellTags->{"S3.9.7", "7.8", "b:1", "ndsg:0"}],
Cell[13621, 411, 210, 5, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.6", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[13856, 420, 157, 5, 70, "Input",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[14016, 427, 280, 8, 70, "Output",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[14311, 438, 105, 1, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.10", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[14441, 443, 122, 2, 70, "Input",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[14566, 447, 11830, 380, 70, 3875, 276, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[26411, 830, 112, 1, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.7", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[26548, 835, 164, 5, 70, "Input",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[26715, 842, 290, 8, 70, "Output",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}]
}, Open  ]],
Cell[27020, 853, 249, 6, 70, "Text",
  CellTags->{"S3.9.7", "7.18", "b:1", "ndsg:0"}],
Cell[27272, 861, 146, 4, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.19", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[27443, 869, 327, 7, 70, "Input"],
Cell[27773, 878, 442, 12, 70, "Output"]
}, Open  ]],
Cell[28230, 893, 106, 1, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.17", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[28361, 898, 208, 4, 70, "Input",
  CellTags->{"b:1", "ndsg:0"}],
Cell[28572, 904, 55391, 2519, 70, 35162, 2264, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[83978, 3426, 255, 6, 70, "Text",
  CellTags->{"S3.9.7", "7.15", "b:1", "ndsg:0"}],
Cell[84236, 3434, 146, 4, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.16", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[84407, 3442, 138, 2, 70, "Input",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[84548, 3446, 206, 4, 70, "Message"],
Cell[84757, 3452, 899, 25, 70, "Output"]
}, Open  ]],
Cell[85671, 3480, 220, 5, 70, "Text"],
Cell[85894, 3487, 184, 4, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[86103, 3495, 133, 4, 70, "Input"],
Cell[86239, 3501, 12631, 427, 70, 4679, 324, "GraphicsData", "PostScript", \
"Graphics"],
Cell[98873, 3930, 156, 4, 70, "Output"]
}, Open  ]],
Cell[99044, 3937, 556, 11, 70, "Text",
  CellTags->{"b:1", "ndsg:0"}],
Cell[99603, 3950, 44, 0, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[99672, 3954, 244, 5, 70, "Input"],
Cell[99919, 3961, 219, 4, 70, "Message"],
Cell[100141, 3967, 531, 16, 70, "Output"]
}, Open  ]],
Cell[100687, 3986, 369, 8, 70, "Text"],
Cell[101059, 3996, 459, 12, 70, "Text"],
Cell[101521, 4010, 58, 0, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[101604, 4014, 117, 2, 70, "Input"],
Cell[101724, 4018, 14801, 445, 70, 4482, 313, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[116540, 4466, 294, 7, 70, "Text"],
Cell[116837, 4475, 669, 21, 70, "Text",
  CellTags->{"S3.9.7", "7.22", "b:1", "ndsg:0"}],
Cell[117509, 4498, 189, 4, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[117723, 4506, 818, 21, 70, "Input",
  CellTags->{"b:1", "ndsg:0"}],
Cell[118544, 4529, 5347, 126, 70, "Output",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[123906, 4658, 296, 8, 70, "Text",
  CellTags->{"b:1", "ndsg:0"}],
Cell[124205, 4668, 310, 6, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[124540, 4678, 166, 4, 70, "Input",
  CellTags->{"b:1", "ndsg:0"}],
Cell[124709, 4684, 88510, 1686, 70, 24066, 885, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[213234, 6373, 713, 12, 70, "Text",
  CellTags->{"b:1", "ndsg:0"}],
Cell[213950, 6387, 159, 4, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.23", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[214134, 6395, 333, 8, 70, "Input",
  CellTags->{"b:1", "ndsg:0"}],
Cell[214470, 6405, 283, 8, 70, "Output",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[214768, 6416, 201, 5, 70, "Text",
  CellTags->{"b:1", "ndsg:0"}],
Cell[214972, 6423, 7099, 214, 70, "DefinitionBox"],
Cell[222074, 6639, 133, 4, 70, "Caption",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[222210, 6645, 183, 5, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[222418, 6654, 269, 5, 70, "Input",
  CellTags->{"b:1", "ndsg:0"}],
Cell[222690, 6661, 294, 8, 70, "Output",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[222999, 6672, 104, 1, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.25", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[223128, 6677, 180, 5, 70, "Input",
  CellTags->{"b:1", "ndsg:0"}],
Cell[223311, 6684, 76404, 1526, 70, 21994, 849, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[299730, 8213, 743, 15, 70, "Text",
  CellTags->{"b:1", "ndsg:0"}],
Cell[300476, 8230, 242, 5, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.46", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[300743, 8239, 606, 11, 70, "Input",
  CellTags->{"b:1", "ndsg:0"}],
Cell[301352, 8252, 314, 9, 70, "Output"]
}, Open  ]],
Cell[301681, 8264, 123, 3, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.47", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[301829, 8271, 181, 5, 70, "Input",
  CellTags->{"b:1", "ndsg:0"}],
Cell[302013, 8278, 119094, 2372, 70, 50675, 1522, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[421122, 10653, 527, 13, 70, "Text",
  CellTags->{"S3.9.7", "7.30", "b:1", "ndsg:0"}],
Cell[421652, 10668, 2132, 59, 70, "Text",
  CellTags->{"S3.9.7", "7.27", "b:1", "ndsg:0"}],
Cell[423787, 10729, 920, 27, 70, "Text"],
Cell[424710, 10758, 159, 4, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.28", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[424894, 10766, 270, 7, 70, "Input",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[425167, 10775, 252, 7, 70, "Output"]
}, Open  ]],
Cell[425434, 10785, 122, 1, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.29", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[425581, 10790, 93, 2, 70, "Input",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[425677, 10794, 123, 3, 70, "Output"]
}, Open  ]],
Cell[425815, 10800, 357, 8, 70, "Text",
  CellTags->{"S3.9.7", "7.33", "b:1", "ndsg:0"}],
Cell[426175, 10810, 789, 20, 70, "Text",
  CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
Cell[426967, 10832, 151, 4, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.37", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[427143, 10840, 138, 2, 70, "Input",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[427284, 10844, 240, 5, 70, "Message",
  CellTags->{"b:1", "ndsg:0"}],
Cell[427527, 10851, 374, 11, 70, "Output",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[427916, 10865, 245, 7, 70, "MathCaption",
  CellTags->{"S3.9.7", "7.38", "b:1", "ndsg:0"}],

Cell[CellGroupData[{
Cell[428186, 10876, 121, 2, 70, "Input",
  CellTags->{"S3.9.7", "b:1", "ndsg:0"}],
Cell[428310, 10880, 11609, 371, 70, 3886, 270, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->{"b:1", "ndsg:0"}]
}, Open  ]],
Cell[439934, 11254, 590, 19, 70, "Text",
  CellTags->{"S3.9.7", "7.39", "b:1", "ndsg:0"}],
Cell[440527, 11275, 1006, 17, 70, "Text",
  CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}],
Cell[441536, 11294, 745, 15, 70, "Text",
  CellTags->{"b:1", "ndsg:0"}],
Cell[442284, 11311, 1022, 22, 70, "Text",
  CellTags->{"S3.9.7", "7.36", "b:1", "ndsg:0"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[443343, 11338, 44, 1, 70, "Section",
  CellTags->"s:2"],

Cell[CellGroupData[{
Cell[443412, 11343, 51, 1, 70, "Subsection",
  CellTags->"s:2.1"],
Cell[443466, 11346, 129, 3, 70, "Text"],
Cell[443598, 11351, 132, 3, 70, "Text"],
Cell[443733, 11356, 119, 3, 70, "Text"],
Cell[443855, 11361, 112, 4, 70, "Text"],
Cell[443970, 11367, 53, 0, 70, "BulletedList"],
Cell[444026, 11369, 54, 0, 70, "BulletedList"],
Cell[444083, 11371, 106, 3, 70, "BulletedList"],
Cell[444192, 11376, 36, 0, 70, "BulletedList"],
Cell[444231, 11378, 101, 3, 70, "BulletedList"],
Cell[444335, 11383, 73, 0, 70, "BulletedList"],
Cell[444411, 11385, 319, 10, 70, "BulletedList"],
Cell[444733, 11397, 252, 6, 70, "BulletedList"],
Cell[444988, 11405, 245, 7, 70, "BulletedList"],
Cell[445236, 11414, 67, 0, 70, "BulletedList"],
Cell[445306, 11416, 96, 3, 70, "BulletedList"],
Cell[445405, 11421, 52, 0, 70, "BulletedList"]
}, Open  ]],

Cell[CellGroupData[{
Cell[445494, 11426, 63, 1, 70, "Subsection",
  CellTags->"s:2.2"],
Cell[445560, 11429, 154, 3, 70, "Text"],
Cell[445717, 11434, 147, 3, 70, "BulletedList"],
Cell[445867, 11439, 130, 3, 70, "BulletedList"],
Cell[446000, 11444, 75, 0, 70, "BulletedList"],
Cell[446078, 11446, 108, 3, 70, "BulletedList"],
Cell[446189, 11451, 113, 3, 70, "BulletedList"],
Cell[446305, 11456, 114, 3, 70, "BulletedList"],
Cell[446422, 11461, 86, 1, 70, "BulletedList"],
Cell[446511, 11464, 214, 4, 70, "BulletedList"]
}, Open  ]],

Cell[CellGroupData[{
Cell[446762, 11473, 61, 1, 70, "Subsection",
  CellTags->"s:2.3"],
Cell[446826, 11476, 580, 14, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[447443, 11495, 59, 1, 70, "Subsection",
  CellTags->"s:2.4"],
Cell[447505, 11498, 468, 12, 70, "Text"],

Cell[CellGroupData[{
Cell[447998, 11514, 39, 0, 70, "Subsubsection"],
Cell[448040, 11516, 119, 3, 70, "Text"],
Cell[448162, 11521, 369, 14, 70, "Text"],
Cell[448534, 11537, 369, 14, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[448940, 11556, 39, 0, 70, "Subsubsection"],
Cell[448982, 11558, 159, 4, 70, "Text"],
Cell[449144, 11564, 526, 19, 70, "Text"],
Cell[449673, 11585, 133, 3, 70, "Text"],
Cell[449809, 11590, 525, 19, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[450371, 11614, 40, 0, 70, "Subsubsection"],
Cell[450414, 11616, 111, 3, 70, "Text"],
Cell[450528, 11621, 1392, 35, 70, "Text"],
Cell[451923, 11658, 73, 0, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[452033, 11663, 38, 0, 70, "Subsubsection"],
Cell[452074, 11665, 155, 3, 40, "Text"],
Cell[452232, 11670, 195, 6, 70, "Text"],
Cell[452430, 11678, 1597, 41, 83, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[454076, 11725, 61, 1, 40, "Subsection",
  CellTags->"s:2.5"],
Cell[454140, 11728, 189, 4, 40, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[454366, 11737, 57, 1, 40, "Subsection",
  CellTags->"s:2.6"],
Cell[454426, 11740, 380, 10, 56, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[454843, 11755, 87, 1, 40, "Subsection",
  CellTags->"s:2.7"],
Cell[454933, 11758, 158, 4, 40, "Text"],
Cell[455094, 11764, 316, 6, 56, "Text"],
Cell[455413, 11772, 121, 4, 24, "Text"],

Cell[CellGroupData[{
Cell[455559, 11780, 92, 2, 26, "Input"],
Cell[455654, 11784, 418, 8, 121, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[456121, 11798, 58, 1, 40, "Subsection",
  CellTags->"s:2.8"],
Cell[456182, 11801, 182, 4, 40, "Text"],
Cell[456367, 11807, 385, 10, 62, "BulletedList"],
Cell[456755, 11819, 182, 4, 44, "BulletedList"],
Cell[456940, 11825, 146, 3, 44, "BulletedList"],
Cell[457089, 11830, 187, 4, 44, "BulletedList"],
Cell[457279, 11836, 443, 13, 26, "BulletedList"],
Cell[457725, 11851, 155, 3, 40, "Text"],

Cell[CellGroupData[{
Cell[457905, 11858, 196, 4, 42, "Input"],
Cell[458104, 11864, 132, 3, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[458285, 11873, 61, 1, 40, "Subsection",
  CellTags->"s:2.9"],
Cell[458349, 11876, 108, 3, 24, "Text"],
Cell[458460, 11881, 2253, 47, 319, "DisplayFormula"],
Cell[460716, 11930, 314, 8, 70, "Text"],
Cell[461033, 11940, 231, 5, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[461301, 11950, 60, 1, 70, "Subsection",
  CellTags->"s:2.10"],
Cell[461364, 11953, 271, 6, 70, "Text"],
Cell[461638, 11961, 111, 3, 70, "Text"],
Cell[461752, 11966, 105, 3, 70, "Text"],
Cell[461860, 11971, 183, 4, 70, "Text"],
Cell[462046, 11977, 511, 14, 70, "Text"],
Cell[462560, 11993, 133, 3, 70, "Text"],
Cell[462696, 11998, 48, 0, 70, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

