(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    340401,      23261]*)
(*NotebookOutlinePosition[    341913,      23310]*)
(*  CellTagsIndexPosition[    341725,      23301]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["DifferentialEquations Utility Packages", "Chapter"],

Cell[CellGroupData[{

Cell["InterpolatingFunctionAnatomy", "Section",
  CellTags->{"s:1", "InterpolatingFunctionAnatomy"}],

Cell[TextData[{
  StyleBox["NDSolve ", "MR"],
  "returns solutions as ",
  StyleBox["InterpolatingFunction", "MR"],
  " objects.  Most of the time, simply using these as functions does what is \
needed, but occasionally it is useful to access the data inside, which \
includes the actual values and points ",
  StyleBox["NDSolve", "MR"],
  " computed when taking steps.   The exact structure of an ",
  StyleBox["InterpolatingFunction", "MR"],
  " object is arranged to make the data storage efficient and evaluation at a \
given point fast.  This structure may change between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versions, so code which is written in terms of accessing parts of \
InterpolatingFunction objects may not work with new versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  The ",
  StyleBox["DifferentialEquations`InterpolatingFunctionAnatomy`", "MR"],
  " package provides an interface to the data in an InterpolatingFunction \
object which will be maintained for future ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versions."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["InterpolatingFunctionDomain",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ifun",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "Return a list with the domain of definition for each of the \
dimensions of the InterpolatingFunction object ",
              StyleBox["ifun.", "TI"],
              " "
            }], "Text"]},
          {
            RowBox[{
              StyleBox["InterpolatingFunctionCoordinates",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ifun",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "Return a list with the coordinates at which data is specified \
in each of the dimensions for the InterpolatingFunction object ",
              StyleBox["ifun", "TI"],
              "."
            }], "Text"]},
          {
            RowBox[{
              StyleBox["InterpolatingFunctionGrid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ifun",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "Return the grid of points at which data is specified for the \
InterpolatingFunction object ",
              StyleBox["ifun", "TI"],
              ". "
            }], "Text"]},
          {
            RowBox[{
              StyleBox["InterpolatingFunctionValuesOnGrid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ifun",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "Return the values which would be returned by evaluating the \
InterpolatingFunction object ",
              StyleBox["ifun", "TI"],
              " at each of its grid points.  "
            }], "Text"]},
          {
            RowBox[{
              StyleBox["InterpolatingFunctionInterpolationOrder",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ifun",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "Return", " ", "the", " ", "interpolation", " ", "order", " ", 
              "used", " ", "for", " ", "each", " ", "of", " ", "the", " ", 
              "dimensions", " ", "for", " ", "the", " ", 
              "InterpolatingFunction", " ", "object", " ", 
              RowBox[{
                StyleBox["ifun",
                  "TI"], "."}]}]},
          {
            RowBox[{
              StyleBox["InterpolatingFunctionDerivativeOrder",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["ifun",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "Return", " ", "the", " ", "order", " ", "of", " ", "the", " ", 
              "derivative", " ", "of", " ", "the", " ", "base", " ", 
              "function", " ", "for", " ", "which", " ", "values", " ", "are",
               " ", "specified", " ", "when", " ", "evaluating", " ", "the", 
              " ", "InterpolatingFunction", " ", "object", " ", 
              RowBox[{
                StyleBox["ifun",
                  "TI"], "."}]}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->0.5}],

Cell[TextData[{
  "Anatomy of ",
  StyleBox["InterpolatingFunction", "MR"],
  " objects."
}], "Caption"],

Cell["This loads the package.", "MathCaption"],

Cell[BoxData[
    \(<< DifferentialEquations`InterpolatingFunctionAnatomy`\)], "Input",
  CellLabel->"In[1]:="],

Cell["\<\
One common situation where the InterpolatingFunctionAnatomy package \
is useful is when NDSolve cannot compute a solution over the full range of \
values that you specified, and you want to plot all of the solution which was \
computed to try to understand better when might have gone wrong.\
\>", "Text"],

Cell["\<\
Here is an example of a differential equation which cannot be \
computed up to the specified endpoint. \
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ifun\  = \ 
      First[x\  /. \ 
          NDSolve[{\(x'\)[t]\  \[Equal] \ Exp[x[t]]\  - \ x[t], \ 
              x[0]\  \[Equal] \ 1}, x, {t, 0, 10}]]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndsz"\), \(\(:\)\(\ \)\), "\<\"At \\!\\(t\\) == \
\\!\\(0.5160191740198966`\\), step size is effectively zero; singularity or \
stiff system suspected. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[2]:="],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 0.5160191740198966`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell["This gets the domain.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(domain\  = \ InterpolatingFunctionDomain[ifun]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{0.`, 0.5160191740198966`}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell["\<\
Once the domain has been returned in a list, it is easy to use Part \
to get the desired endpoints and make the plot.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({begin, \ end}\  = \ domain[\([1]\)];\)\), "\[IndentingNewLine]", 
    \(Plot[ifun[t], {t, begin, \ end}]\)}], "Input",
  CellLabel->"In[4]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 1.84563 0.0147151 0.0526231 [
[.20837 .00222 -9 -9 ]
[.20837 .00222 9 0 ]
[.39294 .00222 -9 -9 ]
[.39294 .00222 9 0 ]
[.5775 .00222 -9 -9 ]
[.5775 .00222 9 0 ]
[.76206 .00222 -9 -9 ]
[.76206 .00222 9 0 ]
[.94663 .00222 -9 -9 ]
[.94663 .00222 9 0 ]
[.01131 .11996 -6 -4.5 ]
[.01131 .11996 0 4.5 ]
[.01131 .22521 -6 -4.5 ]
[.01131 .22521 0 4.5 ]
[.01131 .33045 -6 -4.5 ]
[.01131 .33045 0 4.5 ]
[.01131 .4357 -6 -4.5 ]
[.01131 .4357 0 4.5 ]
[.01131 .54095 -12 -4.5 ]
[.01131 .54095 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.20837 .01472 m
.20837 .02097 L
s
[(0.1)] .20837 .00222 0 1 Mshowa
.39294 .01472 m
.39294 .02097 L
s
[(0.2)] .39294 .00222 0 1 Mshowa
.5775 .01472 m
.5775 .02097 L
s
[(0.3)] .5775 .00222 0 1 Mshowa
.76206 .01472 m
.76206 .02097 L
s
[(0.4)] .76206 .00222 0 1 Mshowa
.94663 .01472 m
.94663 .02097 L
s
[(0.5)] .94663 .00222 0 1 Mshowa
.125 Mabswid
.06072 .01472 m
.06072 .01847 L
s
.09763 .01472 m
.09763 .01847 L
s
.13455 .01472 m
.13455 .01847 L
s
.17146 .01472 m
.17146 .01847 L
s
.24529 .01472 m
.24529 .01847 L
s
.2822 .01472 m
.2822 .01847 L
s
.31911 .01472 m
.31911 .01847 L
s
.35602 .01472 m
.35602 .01847 L
s
.42985 .01472 m
.42985 .01847 L
s
.46676 .01472 m
.46676 .01847 L
s
.50367 .01472 m
.50367 .01847 L
s
.54059 .01472 m
.54059 .01847 L
s
.61441 .01472 m
.61441 .01847 L
s
.65132 .01472 m
.65132 .01847 L
s
.68824 .01472 m
.68824 .01847 L
s
.72515 .01472 m
.72515 .01847 L
s
.79897 .01472 m
.79897 .01847 L
s
.83589 .01472 m
.83589 .01847 L
s
.8728 .01472 m
.8728 .01847 L
s
.90971 .01472 m
.90971 .01847 L
s
.98354 .01472 m
.98354 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .11996 m
.03006 .11996 L
s
[(2)] .01131 .11996 1 0 Mshowa
.02381 .22521 m
.03006 .22521 L
s
[(4)] .01131 .22521 1 0 Mshowa
.02381 .33045 m
.03006 .33045 L
s
[(6)] .01131 .33045 1 0 Mshowa
.02381 .4357 m
.03006 .4357 L
s
[(8)] .01131 .4357 1 0 Mshowa
.02381 .54095 m
.03006 .54095 L
s
[(10)] .01131 .54095 1 0 Mshowa
.125 Mabswid
.02381 .04103 m
.02756 .04103 L
s
.02381 .06734 m
.02756 .06734 L
s
.02381 .09365 m
.02756 .09365 L
s
.02381 .14627 m
.02756 .14627 L
s
.02381 .17258 m
.02756 .17258 L
s
.02381 .1989 m
.02756 .1989 L
s
.02381 .25152 m
.02756 .25152 L
s
.02381 .27783 m
.02756 .27783 L
s
.02381 .30414 m
.02756 .30414 L
s
.02381 .35676 m
.02756 .35676 L
s
.02381 .38308 m
.02756 .38308 L
s
.02381 .40939 m
.02756 .40939 L
s
.02381 .46201 m
.02756 .46201 L
s
.02381 .48832 m
.02756 .48832 L
s
.02381 .51463 m
.02756 .51463 L
s
.02381 .56726 m
.02756 .56726 L
s
.02381 .59357 m
.02756 .59357 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .06734 m
.06244 .06927 L
.10458 .07145 L
.14415 .0736 L
.18221 .07575 L
.22272 .07816 L
.26171 .08059 L
.30316 .08332 L
.34309 .08611 L
.3815 .08896 L
.42237 .09221 L
.46172 .09557 L
.49955 .09906 L
.53984 .10311 L
.57861 .10738 L
.61984 .11242 L
.65954 .11789 L
.69774 .12388 L
.73838 .13129 L
.77751 .1398 L
.81909 .15103 L
.83996 .15791 L
.85916 .1653 L
.8791 .17446 L
.89771 .18498 L
.91654 .19866 L
.92651 .20785 L
.9372 .22011 L
.94679 .23449 L
.95221 .24492 L
.95722 .25698 L
.96159 .27051 L
.96642 .29132 L
.96884 .30616 L
.97021 .31687 L
.97146 .32912 L
.97256 .34297 L
.97376 .36407 L
.97502 .40236 L
s
.97502 .40236 m
.97549 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo000mool2
0004ool20003ool5000Rool20004ool20003ool4000Tool20004ool20004ool2000Tool20004ool2
0005ool3000Rool20004ool20004ool2000<ool003coo`04003ooooo000:ool00`00ooooo`0Qool0
1000ooooo`002?oo00<00?ooool09?oo00@00?ooool000Soo`04003ooooo000Rool01000ooooo`00
2ooo00<00?ooool08?oo00@00?ooool000Soo`04003ooooo000;ool003coo`04003ooooo000:ool0
0`00ooooo`0Qool01000ooooo`002Ooo00<00?ooool08ooo00@00?ooool000[oo`03003ooooo027o
o`04003ooooo0008ool5000Qool01000ooooo`002ooo00<00?ooool02Ooo000lool01000ooooo`00
2_oo00<00?ooool08Ooo00@00?ooool000[oo`03003ooooo02;oo`04003ooooo000;ool00`00oooo
o`0Pool01000ooooo`002?oo00@00?ooool002;oo`04003ooooo0009ool2000<ool003coo`04003o
oooo000:ool00`00ooooo`0Qool01000ooooo`002?oo00@00?ooool002?oo`04003ooooo0008ool0
1000ooooo`008_oo00@00?ooool000Woo`03003oo`0002;oo`04003ooooo0009ool00`00ooooo`0;
ool003goo`8000[oo`8002Coo`8000[oo`8002Goo`8000[oo`8002Coo`8000_oo`8002?oo`8000[o
o`<000_oo`00oooo8Ooo000Bool00`00ooooo`3oool<ool001;oo`03003ooooo0?ooo`coo`004_oo
00<00?ooool0oooo3?oo000Bool00`00ooooo`3oool<ool000_oool001<000?oo`004_oo00<00?oo
ool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?oo
ool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?oo
ool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool02?oo00<00?ooool01ooo00<00?oo
ool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?oo
ool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?oo
ool01ooo00<00?ooool01_oo000Bool00`00ooooo`0_ool00`00ooooo`0_ool00`00ooooo`0`ool0
0`00ooooo`0_ool00`00ooooo`0_ool00`00ooooo`0@ool001;oo`03003ooooo0?ooo`coo`004_oo
00<00?ooool0oooo3?oo000Bool00`00ooooo`3oool<ool001;oo`03003ooooo0?ooo`coo`004_oo
0P00oooo3Ooo000Bool00`00ooooo`3oool<ool001;oo`03003ooooo0?ooo`coo`004_oo00<00?oo
ool0oooo3?oo000Bool00`00ooooo`3oool<ool001;oo`03003ooooo0?ooo`coo`004_oo00<00?oo
ool0oooo3?oo000Bool5003oool:ool001;oo`03003ooooo00;ooaH00??oo`004_oo00<00?ooool0
6?oo2`00j?oo000Bool00`00ooooo`0SoolE003Cool001;oo`03003ooooo03Soo`/00<Soo`004_oo
00<00?ooool0@ooo5P00/_oo000Bool00`00ooooo`1Iool;002Wool001;oo`8006Goo`/009coo`00
4_oo00<00?ooool0Kooo2P00T_oo000Bool00`00ooooo`1iool;0027ool001;oo`03003ooooo08Co
o`/007coo`004_oo00<00?ooool0Sooo2000M?oo000Bool00`00ooooo`2Gool6001^ool000Woo`@0
00Goo`03003ooooo09goo`P006Koo`002Ooo00<00?ooool01_oo00<00?ooool0YOoo2000G_oo000:
ool00`00ooooo`05ool2002^ool5001Iool000_oo`03003ooooo00Coo`03003ooooo0;;oo`D005Co
o`002Ooo00@00?ooool000Goo`03003ooooo0;Ooo`H004koo`002_oo0P001_oo00<00?ooool0_Ooo
1@00BOoo000Bool00`00ooooo`32ool60013ool001;oo`03003ooooo0<Soo`@003ooo`004_oo00<0
0?ooool0c?oo1000>ooo000Bool2003Aool4000gool001;oo`03003ooooo0=Coo`<003Coo`004_oo
00<00?ooool0eooo0`00<Ooo000Bool00`00ooooo`3Jool3000^ool001;oo`03003ooooo0=goo`80
02coo`004_oo00<00?ooool0gooo0P00:_oo000Bool00`00ooooo`3Qool2000Xool001;oo`800>Co
o`8002Koo`004_oo00<00?ooool0iOoo0`008ooo000Bool00`00ooooo`3Xool2000Qool001;oo`03
003ooooo0>[oo`8001ooo`004_oo00<00?ooool0k?oo00<00?ooool07?oo000Bool00`00ooooo`3]
ool2000Lool001;oo`03003ooooo0>ooo`03003ooooo01Woo`004_oo0P00lOoo00<00?ooool06?oo
000Bool00`00ooooo`3aool00`00ooooo`0Gool001;oo`03003ooooo0?;oo`03003ooooo01Koo`00
4_oo00<00?ooool0looo00<00?ooool05Ooo000Bool00`00ooooo`3dool00`00ooooo`0Dool000_o
o`<000Coo`03003ooooo0?Goo`03003ooooo01?oo`003?oo00<00?ooool00ooo00<00?ooool0m_oo
00<00?ooool04_oo0009ool50004ool2003gool00`00ooooo`0Bool000Woo`04003ooooo0005ool0
0`00ooooo`3gool00`00ooooo`0Aool000[oo`03003oo`0000Goo`03003ooooo0?Ooo`03003ooooo
017oo`002ooo0P001Ooo00<00?ooool0n?oo00<00?ooool04?oo000Bool00`00ooooo`3iool00`00
ooooo`0?ool001;oo`03003ooooo0?Woo`03003ooooo00ooo`004_oo00<00?ooool0n_oo00<00?oo
ool03_oo000Bool00`00ooooo`3jool00`00ooooo`0>ool001;oo`800?coo`03003ooooo00goo`00
4_oo00<00?ooool0nooo00<00?ooool03Ooo000Bool00`00ooooo`3kool00`00ooooo`0=ool001;o
o`03003ooooo0?_oo`03003ooooo00goo`004_oo00<00?ooool0o?oo00<00?ooool03?oo000Bool0
0`00ooooo`3lool00`00ooooo`0<ool001;oo`03003ooooo0?coo`03003ooooo00coo`004_oo0P00
o_oo00<00?ooool02ooo000Bool00`00ooooo`3mool00`00ooooo`0;ool001;oo`03003ooooo0?ko
o`03003ooooo00[oo`004_oo00<00?ooool0o_oo00<00?ooool02_oo000Bool00`00ooooo`3nool0
0`00ooooo`0:ool001;oo`03003ooooo0?koo`03003ooooo00[oo`004_oo00<00?ooool0o_oo00<0
0?ooool02_oo000Bool2003oool00`00ooooo`0:ool001;oo`03003ooooo0?koo`03003ooooo00[o
o`004_oo00<00?ooool0oooo00<00?ooool02Ooo000Bool00`00ooooo`3oool00`00ooooo`09ool0
01;oo`03003ooooo0?ooo`03003ooooo00Woo`002Ooo0`001_oo00<00?ooool0oooo00<00?ooool0
2Ooo0009ool01000ooooo`001Ooo00<00?ooool0oooo00<00?ooool02Ooo0009ool01000ooooo`00
1Ooo0P00oooo0Ooo00<00?ooool02Ooo0009ool30006ool00`00ooooo`3oool00`00ooooo`09ool0
00[oo`03003ooooo00Goo`03003ooooo0?ooo`03003ooooo00Woo`002_oo0`001Ooo00<00?ooool0
oooo00<00?ooool02Ooo000Bool00`00ooooo`3oool00`00ooooo`09ool001;oo`03003ooooo0?oo
o`03003ooooo00Woo`004_oo00<00?ooool0oooo00<00?ooool02Ooo000Bool2003oool2ool00`00
ooooo`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo00Soo`004_oo00<00?ooool0oooo0Ooo
00<00?ooool02?oo000Bool00`00ooooo`3oool1ool00`00ooooo`08ool001;oo`03003ooooo0?oo
o`7oo`03003ooooo00Soo`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool00`00oooo
o`3oool1ool00`00ooooo`08ool001;oo`800?ooo`;oo`03003ooooo00Soo`004_oo00<00?ooool0
oooo0Ooo00<00?ooool02?oo000Bool00`00ooooo`3oool1ool00`00ooooo`08ool001;oo`03003o
oooo0?ooo`7oo`03003ooooo00Soo`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool0
0`00ooooo`3oool1ool00`00ooooo`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo00Soo`00
4_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool2003oool2ool00`00ooooo`08ool001;o
o`03003ooooo0?ooo`7oo`03003ooooo00Soo`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo
000Bool00`00ooooo`3oool1ool00`00ooooo`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo
00Soo`002_oo0P001_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo0009ool01000ooooo`001Ooo
00<00?ooool0oooo0Ooo00<00?ooool02?oo0009ool01000ooooo`001Ooo0P00oooo0_oo00<00?oo
ool02?oo000:ool20006ool00`00ooooo`3oool1ool00`00ooooo`08ool000Woo`04003ooooo0005
ool00`00ooooo`3oool1ool00`00ooooo`08ool000[oo`8000Koo`03003ooooo0?ooo`7oo`03003o
oooo00Soo`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool00`00ooooo`3oool1ool0
0`00ooooo`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo00Soo`004_oo0P00oooo0_oo00<0
0?ooool02?oo000Bool00`00ooooo`3oool1ool00`00ooooo`08ool001;oo`03003ooooo0?ooo`7o
o`03003ooooo00Soo`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool00`00ooooo`3o
ool1ool00`00ooooo`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo00Soo`004_oo00<00?oo
ool0oooo0Ooo00<00?ooool02?oo000Bool2003oool2ool00`00ooooo`08ool001;oo`03003ooooo
0?ooo`7oo`03003ooooo00Soo`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool00`00
ooooo`3oool1ool00`00ooooo`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo00Soo`004_oo
00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool00`00ooooo`3oool1ool00`00ooooo`08ool0
01;oo`800?ooo`;oo`03003ooooo00Soo`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo000B
ool00`00ooooo`3oool1ool00`00ooooo`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo00So
o`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo0003ool50002ool20006ool00`00ooooo`3o
ool1ool00`00ooooo`08ool000Goo`05003oooooool00002ool00`00ooooo`03ool00`00ooooo`3o
ool1ool00`00ooooo`08ool000Goo`05003oooooool00002ool00`00ooooo`03ool2003oool2ool0
0`00ooooo`08ool000Goo`05003oooooool00002ool00`00ooooo`03ool00`00ooooo`3oool1ool0
0`00ooooo`08ool000Goo`05003oooooool00002ool00`00ooooo`03ool00`00ooooo`3oool1ool0
0`00ooooo`08ool000Coo`8000Coo`8000Koo`03003ooooo0?ooo`7oo`03003ooooo00Soo`004_oo
00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool00`00ooooo`3oool1ool00`00ooooo`08ool0
01;oo`03003ooooo0?ooo`7oo`03003ooooo00Soo`004_oo00<00?ooool0oooo0Ooo00<00?ooool0
2?oo000Bool2003oool2ool00`00ooooo`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo00So
o`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool00`00ooooo`3oool1ool00`00oooo
o`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo00Soo`004_oo00<00?ooool0oooo0Ooo00<0
0?ooool02?oo000Bool00`00ooooo`3oool1ool00`00ooooo`08ool001;oo`800?ooo`;oo`03003o
oooo00Soo`004_oo00<00?ooool0oooo0Ooo00<00?ooool02?oo000Bool00`00ooooo`3oool1ool0
0`00ooooo`08ool001;oo`03003ooooo0?ooo`7oo`03003ooooo00Soo`004_oo00<00?ooool0oooo
0Ooo00<00?ooool02?oo000Bool00`00ooooo`3oool1ool00`00ooooo`08ool001;oo`03003ooooo
0?ooo`7oo`03003ooooo00Soo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.035956, -0.864651, \
0.00198682, 0.069683}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell["\<\
From the plot, it is quite apparent that a singularity has formed \
and it will not be possible to integrate the system any further.\
\>", "Text"],

Cell["\<\
Sometimes it is useful to see where NDSolve took steps.  Getting \
the coordinates is useful for doing this.\
\>", "Text"],

Cell["\<\
This shows the values which NDSolve computed at each step it took.  \
It is quite apparent from this that nearly all of the steps were used to try \
to resolve the singularity.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(coords\  = \ 
        First[InterpolatingFunctionCoordinates[
            ifun]];\)\), "\[IndentingNewLine]", 
    \(ListPlot[Transpose[{coords, \ ifun[coords]}]]\)}], "Input",
  CellLabel->"In[6]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-11.926 25.0034 0.0147151 0.0195847 [
[.07559 .00222 -12 -9 ]
[.07559 .00222 12 0 ]
[.20061 .00222 -15 -9 ]
[.20061 .00222 15 0 ]
[.32562 .00222 -12 -9 ]
[.32562 .00222 12 0 ]
[.45064 .00222 -15 -9 ]
[.45064 .00222 15 0 ]
[.70067 .00222 -15 -9 ]
[.70067 .00222 15 0 ]
[.82569 .00222 -12 -9 ]
[.82569 .00222 12 0 ]
[.95071 .00222 -15 -9 ]
[.95071 .00222 15 0 ]
[.56316 .11264 -6 -4.5 ]
[.56316 .11264 0 4.5 ]
[.56316 .21056 -12 -4.5 ]
[.56316 .21056 0 4.5 ]
[.56316 .30849 -12 -4.5 ]
[.56316 .30849 0 4.5 ]
[.56316 .40641 -12 -4.5 ]
[.56316 .40641 0 4.5 ]
[.56316 .50433 -12 -4.5 ]
[.56316 .50433 0 4.5 ]
[.56316 .60226 -12 -4.5 ]
[.56316 .60226 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07559 .01472 m
.07559 .02097 L
s
[(0.48)] .07559 .00222 0 1 Mshowa
.20061 .01472 m
.20061 .02097 L
s
[(0.485)] .20061 .00222 0 1 Mshowa
.32562 .01472 m
.32562 .02097 L
s
[(0.49)] .32562 .00222 0 1 Mshowa
.45064 .01472 m
.45064 .02097 L
s
[(0.495)] .45064 .00222 0 1 Mshowa
.70067 .01472 m
.70067 .02097 L
s
[(0.505)] .70067 .00222 0 1 Mshowa
.82569 .01472 m
.82569 .02097 L
s
[(0.51)] .82569 .00222 0 1 Mshowa
.95071 .01472 m
.95071 .02097 L
s
[(0.515)] .95071 .00222 0 1 Mshowa
.125 Mabswid
.10059 .01472 m
.10059 .01847 L
s
.1256 .01472 m
.1256 .01847 L
s
.1506 .01472 m
.1506 .01847 L
s
.1756 .01472 m
.1756 .01847 L
s
.22561 .01472 m
.22561 .01847 L
s
.25061 .01472 m
.25061 .01847 L
s
.27562 .01472 m
.27562 .01847 L
s
.30062 .01472 m
.30062 .01847 L
s
.35063 .01472 m
.35063 .01847 L
s
.37563 .01472 m
.37563 .01847 L
s
.40063 .01472 m
.40063 .01847 L
s
.42564 .01472 m
.42564 .01847 L
s
.47564 .01472 m
.47564 .01847 L
s
.50065 .01472 m
.50065 .01847 L
s
.52565 .01472 m
.52565 .01847 L
s
.55065 .01472 m
.55065 .01847 L
s
.60066 .01472 m
.60066 .01847 L
s
.62566 .01472 m
.62566 .01847 L
s
.65067 .01472 m
.65067 .01847 L
s
.67567 .01472 m
.67567 .01847 L
s
.72568 .01472 m
.72568 .01847 L
s
.75068 .01472 m
.75068 .01847 L
s
.77568 .01472 m
.77568 .01847 L
s
.80069 .01472 m
.80069 .01847 L
s
.85069 .01472 m
.85069 .01847 L
s
.8757 .01472 m
.8757 .01847 L
s
.9007 .01472 m
.9007 .01847 L
s
.9257 .01472 m
.9257 .01847 L
s
.05059 .01472 m
.05059 .01847 L
s
.02558 .01472 m
.02558 .01847 L
s
.00058 .01472 m
.00058 .01847 L
s
.97571 .01472 m
.97571 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.57566 .11264 m
.58191 .11264 L
s
[(5)] .56316 .11264 1 0 Mshowa
.57566 .21056 m
.58191 .21056 L
s
[(10)] .56316 .21056 1 0 Mshowa
.57566 .30849 m
.58191 .30849 L
s
[(15)] .56316 .30849 1 0 Mshowa
.57566 .40641 m
.58191 .40641 L
s
[(20)] .56316 .40641 1 0 Mshowa
.57566 .50433 m
.58191 .50433 L
s
[(25)] .56316 .50433 1 0 Mshowa
.57566 .60226 m
.58191 .60226 L
s
[(30)] .56316 .60226 1 0 Mshowa
.125 Mabswid
.57566 .0343 m
.57941 .0343 L
s
.57566 .05388 m
.57941 .05388 L
s
.57566 .07347 m
.57941 .07347 L
s
.57566 .09305 m
.57941 .09305 L
s
.57566 .13222 m
.57941 .13222 L
s
.57566 .15181 m
.57941 .15181 L
s
.57566 .17139 m
.57941 .17139 L
s
.57566 .19098 m
.57941 .19098 L
s
.57566 .23015 m
.57941 .23015 L
s
.57566 .24973 m
.57941 .24973 L
s
.57566 .26932 m
.57941 .26932 L
s
.57566 .2889 m
.57941 .2889 L
s
.57566 .32807 m
.57941 .32807 L
s
.57566 .34765 m
.57941 .34765 L
s
.57566 .36724 m
.57941 .36724 L
s
.57566 .38682 m
.57941 .38682 L
s
.57566 .42599 m
.57941 .42599 L
s
.57566 .44558 m
.57941 .44558 L
s
.57566 .46516 m
.57941 .46516 L
s
.57566 .48475 m
.57941 .48475 L
s
.57566 .52392 m
.57941 .52392 L
s
.57566 .5435 m
.57941 .5435 L
s
.57566 .56309 m
.57941 .56309 L
s
.57566 .58267 m
.57941 .58267 L
s
.25 Mabswid
.57566 0 m
.57566 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.03951 .08043 Mdot
.08578 .08137 Mdot
.13205 .08236 Mdot
.17833 .08341 Mdot
.21619 .08432 Mdot
.25406 .08528 Mdot
.29192 .08629 Mdot
.32978 .08735 Mdot
.3607 .08828 Mdot
.39162 .08925 Mdot
.42254 .09027 Mdot
.45346 .09136 Mdot
.47866 .09229 Mdot
.50386 .09327 Mdot
.52906 .09431 Mdot
.55425 .09541 Mdot
.57475 .09636 Mdot
.59524 .09736 Mdot
.61573 .09841 Mdot
.63622 .09953 Mdot
.65286 .10048 Mdot
.66949 .10149 Mdot
.68612 .10256 Mdot
.70275 .10369 Mdot
.71623 .10466 Mdot
.7297 .10568 Mdot
.74318 .10676 Mdot
.75665 .1079 Mdot
.76754 .10888 Mdot
.77844 .10991 Mdot
.78933 .111 Mdot
.80023 .11216 Mdot
.80902 .11315 Mdot
.81781 .11419 Mdot
.8266 .1153 Mdot
.83539 .11647 Mdot
.84247 .11746 Mdot
.84955 .11852 Mdot
.85663 .11963 Mdot
.86372 .12081 Mdot
.86941 .12182 Mdot
.8751 .12288 Mdot
.8808 .124 Mdot
.88649 .1252 Mdot
.89106 .12621 Mdot
.89563 .12728 Mdot
.9002 .12842 Mdot
.90477 .12962 Mdot
.90843 .13065 Mdot
.91209 .13173 Mdot
.91575 .13287 Mdot
.91941 .13409 Mdot
.92234 .13512 Mdot
.92527 .1362 Mdot
.9282 .13736 Mdot
.93112 .13858 Mdot
.93346 .13962 Mdot
.9358 .14072 Mdot
.93814 .14188 Mdot
.94048 .14312 Mdot
.94234 .14416 Mdot
.9442 .14527 Mdot
.94607 .14644 Mdot
.94793 .14768 Mdot
.94941 .14874 Mdot
.9509 .14985 Mdot
.95238 .15103 Mdot
.95386 .15228 Mdot
.95504 .15334 Mdot
.95622 .15446 Mdot
.9574 .15565 Mdot
.95857 .15691 Mdot
.95951 .15798 Mdot
.96044 .1591 Mdot
.96138 .1603 Mdot
.96231 .16157 Mdot
.96305 .16264 Mdot
.96379 .16378 Mdot
.96453 .16498 Mdot
.96527 .16626 Mdot
.96586 .16734 Mdot
.96644 .16848 Mdot
.96703 .16969 Mdot
.96761 .17098 Mdot
.96808 .17207 Mdot
.96854 .17321 Mdot
.969 .17443 Mdot
.96946 .17573 Mdot
.96983 .17682 Mdot
.97019 .17797 Mdot
.97055 .1792 Mdot
.97092 .18051 Mdot
.97121 .1816 Mdot
.97149 .18276 Mdot
.97178 .184 Mdot
.97207 .18531 Mdot
.97229 .18641 Mdot
.97252 .18758 Mdot
.97274 .18882 Mdot
.97297 .19014 Mdot
.97315 .19125 Mdot
.97332 .19242 Mdot
.9735 .19367 Mdot
.97368 .195 Mdot
.97382 .19611 Mdot
.97395 .19729 Mdot
.97409 .19854 Mdot
.97423 .19988 Mdot
.97434 .201 Mdot
.97445 .20218 Mdot
.97456 .20344 Mdot
.97465 .20456 Mdot
.97474 .20574 Mdot
.97483 .207 Mdot
.97492 .20834 Mdot
.97499 .20947 Mdot
.97506 .21066 Mdot
.97513 .21193 Mdot
.97519 .21306 Mdot
.97525 .21425 Mdot
.97531 .21552 Mdot
.97537 .21688 Mdot
.97541 .21801 Mdot
.97546 .21921 Mdot
.97551 .22049 Mdot
.97555 .22163 Mdot
.97558 .22283 Mdot
.97562 .22411 Mdot
.97565 .22524 Mdot
.97569 .22645 Mdot
.97572 .22773 Mdot
.97575 .2291 Mdot
.97578 .23025 Mdot
.9758 .23147 Mdot
.97583 .23276 Mdot
.97585 .23391 Mdot
.97587 .23512 Mdot
.97589 .23642 Mdot
.9759 .23756 Mdot
.97592 .23878 Mdot
.97594 .24008 Mdot
.97595 .24123 Mdot
.97597 .24245 Mdot
.97598 .24375 Mdot
.97599 .2449 Mdot
.97601 .24613 Mdot
.97602 .24743 Mdot
.97603 .24859 Mdot
.97604 .24982 Mdot
.97605 .25113 Mdot
.97606 .25228 Mdot
.97606 .25352 Mdot
.97607 .25483 Mdot
.97608 .25599 Mdot
.97609 .25723 Mdot
.97609 .25855 Mdot
.9761 .25971 Mdot
.9761 .26095 Mdot
.97611 .26227 Mdot
.97611 .26344 Mdot
.97612 .26468 Mdot
.97612 .26601 Mdot
.97613 .26718 Mdot
.97613 .26843 Mdot
.97614 .26976 Mdot
.97614 .27093 Mdot
.97614 .27218 Mdot
.97614 .27352 Mdot
.97615 .2747 Mdot
.97615 .27595 Mdot
.97615 .27729 Mdot
.97616 .27847 Mdot
.97616 .27972 Mdot
.97616 .28107 Mdot
.97616 .28225 Mdot
.97616 .28351 Mdot
.97616 .28486 Mdot
.97617 .28604 Mdot
.97617 .28731 Mdot
.97617 .28866 Mdot
.97617 .28985 Mdot
.97617 .29111 Mdot
.97617 .29247 Mdot
.97617 .29366 Mdot
.97618 .29493 Mdot
.97618 .29629 Mdot
.97618 .29748 Mdot
.97618 .29876 Mdot
.97618 .30012 Mdot
.97618 .30132 Mdot
.97618 .30259 Mdot
.97618 .30396 Mdot
.97618 .30516 Mdot
.97618 .30644 Mdot
.97618 .30781 Mdot
.97618 .30901 Mdot
.97618 .3103 Mdot
.97618 .31167 Mdot
.97618 .31288 Mdot
.97618 .31416 Mdot
.97619 .31554 Mdot
.97619 .31675 Mdot
.97619 .31804 Mdot
.97619 .31942 Mdot
.97619 .32063 Mdot
.97619 .32193 Mdot
.97619 .32331 Mdot
.97619 .32453 Mdot
.97619 .32582 Mdot
.97619 .32721 Mdot
.97619 .32843 Mdot
.97619 .32973 Mdot
.97619 .33112 Mdot
.97619 .33234 Mdot
.97619 .33364 Mdot
.97619 .33504 Mdot
.97619 .33626 Mdot
.97619 .33757 Mdot
.97619 .33896 Mdot
.97619 .34019 Mdot
.97619 .3415 Mdot
.97619 .3429 Mdot
.97619 .34413 Mdot
.97619 .34544 Mdot
.97619 .34685 Mdot
.97619 .34808 Mdot
.97619 .34939 Mdot
.97619 .3508 Mdot
.97619 .35204 Mdot
.97619 .35336 Mdot
.97619 .35477 Mdot
.97619 .356 Mdot
.97619 .35733 Mdot
.97619 .35874 Mdot
.97619 .35998 Mdot
.97619 .3613 Mdot
.97619 .36272 Mdot
.97619 .36397 Mdot
.97619 .36529 Mdot
.97619 .36672 Mdot
.97619 .36796 Mdot
.97619 .36929 Mdot
.97619 .37072 Mdot
.97619 .37196 Mdot
.97619 .3733 Mdot
.97619 .37473 Mdot
.97619 .37598 Mdot
.97619 .37731 Mdot
.97619 .37875 Mdot
.97619 .38 Mdot
.97619 .38134 Mdot
.97619 .38277 Mdot
.97619 .38403 Mdot
.97619 .38537 Mdot
.97619 .38681 Mdot
.97619 .38807 Mdot
.97619 .38941 Mdot
.97619 .39085 Mdot
.97619 .39211 Mdot
.97619 .39346 Mdot
.97619 .39491 Mdot
.97619 .39617 Mdot
.97619 .39752 Mdot
.97619 .39897 Mdot
.97619 .40024 Mdot
.97619 .40159 Mdot
.97619 .40304 Mdot
.97619 .40431 Mdot
.97619 .40566 Mdot
.97619 .40712 Mdot
.97619 .40839 Mdot
.97619 .40975 Mdot
.97619 .41121 Mdot
.97619 .41248 Mdot
.97619 .41384 Mdot
.97619 .4153 Mdot
.97619 .41658 Mdot
.97619 .41794 Mdot
.97619 .41941 Mdot
.97619 .42069 Mdot
.97619 .42205 Mdot
.97619 .42352 Mdot
.97619 .4248 Mdot
.97619 .42617 Mdot
.97619 .42764 Mdot
.97619 .42893 Mdot
.97619 .4303 Mdot
.97619 .43177 Mdot
.97619 .43306 Mdot
.97619 .43443 Mdot
.97619 .43591 Mdot
.97619 .4372 Mdot
.97619 .43858 Mdot
.97619 .44006 Mdot
.97619 .44135 Mdot
.97619 .44273 Mdot
.97619 .44421 Mdot
.97619 .4455 Mdot
.97619 .44689 Mdot
.97619 .44837 Mdot
.97619 .44967 Mdot
.97619 .45105 Mdot
.97619 .45254 Mdot
.97619 .45384 Mdot
.97619 .45523 Mdot
.97619 .45672 Mdot
.97619 .45802 Mdot
.97619 .45941 Mdot
.97619 .46091 Mdot
.97619 .46221 Mdot
.97619 .4636 Mdot
.97619 .4651 Mdot
.97619 .46641 Mdot
.97619 .4678 Mdot
.97619 .46931 Mdot
.97619 .47061 Mdot
.97619 .47201 Mdot
.97619 .47352 Mdot
.97619 .47482 Mdot
.97619 .47623 Mdot
.97619 .47773 Mdot
.97619 .47904 Mdot
.97619 .48045 Mdot
.97619 .48196 Mdot
.97619 .48327 Mdot
.97619 .48468 Mdot
.97619 .48619 Mdot
.97619 .48751 Mdot
.97619 .48892 Mdot
.97619 .49044 Mdot
.97619 .49175 Mdot
.97619 .49316 Mdot
.97619 .49468 Mdot
.97619 .496 Mdot
.97619 .49742 Mdot
.97619 .49894 Mdot
.97619 .50026 Mdot
.97619 .50168 Mdot
.97619 .50321 Mdot
.97619 .50453 Mdot
.97619 .50595 Mdot
.97619 .50748 Mdot
.97619 .5088 Mdot
.97619 .51022 Mdot
.97619 .51176 Mdot
.97619 .51308 Mdot
.97619 .51451 Mdot
.97619 .51604 Mdot
.97619 .51737 Mdot
.97619 .5188 Mdot
.97619 .52034 Mdot
.97619 .52167 Mdot
.97619 .5231 Mdot
.97619 .52464 Mdot
.97619 .52597 Mdot
.97619 .52741 Mdot
.97619 .52895 Mdot
.97619 .53029 Mdot
.97619 .53172 Mdot
.97619 .53327 Mdot
.97619 .53461 Mdot
.97619 .53604 Mdot
.97619 .53759 Mdot
.97619 .53893 Mdot
.97619 .54037 Mdot
.97619 .54192 Mdot
.97619 .54327 Mdot
.97619 .54471 Mdot
.97619 .54626 Mdot
.97619 .54761 Mdot
.97619 .54905 Mdot
.97619 .55061 Mdot
.97619 .55195 Mdot
.97619 .5534 Mdot
.97619 .55496 Mdot
.97619 .55631 Mdot
.97619 .55776 Mdot
.97619 .55932 Mdot
.97619 .56067 Mdot
.97619 .56212 Mdot
.97619 .56369 Mdot
.97619 .56504 Mdot
.97619 .5665 Mdot
.97619 .56806 Mdot
.97619 .56942 Mdot
.97619 .57087 Mdot
.97619 .57245 Mdot
.97619 .5738 Mdot
.97619 .57526 Mdot
.97619 .57684 Mdot
.97619 .57819 Mdot
.97619 .57965 Mdot
.97619 .58123 Mdot
.97619 .58259 Mdot
.97619 .58406 Mdot
.97619 .58564 Mdot
.97619 .587 Mdot
.97619 .58846 Mdot
.97619 .59005 Mdot
.97619 .59141 Mdot
.97619 .59288 Mdot
.97619 .59446 Mdot
.97619 .59583 Mdot
.97619 .5973 Mdot
.97619 .59889 Mdot
.97619 .60026 Mdot
.97619 .60173 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo000Aool2
0004ool20005ool30002ool2000;ool20004ool20005ool30002ool20004ool2000;ool20004ool2
0005ool300001?oo000000002ooo0P001?oo0P001Ooo0`0000Coo`00000000Coo`8002[oo`8000Co
o`8000Coo`8000Coo`8000Coo`8000_oo`8000Coo`8000Coo`8000?oo`D000Woo`8000Coo`8000Co
o`8000?oo`D000;oo`8000[oo`004?oo00@00?ooool000_oo`04003ooooo0002ool00`00ooooo`07
ool01000ooooo`002ooo00@00?ooool000;oo`04003ooooo0002ool00`00ooooo`07ool01000oooo
o`002ooo00<00?ooool00_oo00<00?ooool02?oo00@00?ooool000_oo`03003ooooo00;oo`05003o
ooooool00002ool00`00ooooo`0Vool01000ooooo`002?oo00@00?ooool000;oo`04003ooooo0002
ool01000ooooo`002Ooo00@00?ooool000Soo`04003ooooo0004ool00`00ooooo`08ool01000oooo
o`002?oo00@00?ooool000Coo`05003oooooool00002ool00`00ooooo`07ool0013oo`04003ooooo
0008ool500001Ooo003ooooo00002Ooo00@00?ooool000Soo`D00005ool00?ooool00005ool00`00
ooooo`07ool01000ooooo`002?oo1@000_oo0`002Ooo00@00?ooool000Soo`D000;oo`<000Goo`03
003ooooo02Koo`04003ooooo000;ool01000ooooo`000_oo00<00?ooool00ooo00<00?ooool01ooo
00@00?ooool000_oo`03003ooooo00;oo`03003ooooo00Soo`04003ooooo000;ool00`00ooooo`02
ool00`00ooooo`04ool00`00ooooo`07ool0013oo`04003ooooo0008ool01000ooooo`000ooo0P00
2_oo00@00?ooool000Soo`04003ooooo0003ool20004ool2000:ool01000ooooo`002?oo00@00?oo
ool000;oo`04003ooooo0009ool01000ooooo`002?oo00@00?ooool000;oo`04003ooooo0003ool2
000Yool01000ooooo`002Ooo0P000ooo00@00?ooool000?oo`8000[oo`04003ooooo0009ool20005
ool00`00ooooo`08ool01000ooooo`002Ooo0P001Ooo00<00?ooool00_oo0P002_oo000@ool01000
ooooo`002Ooo00<00?oo00000_oo00@00?ooool000Woo`04003ooooo0009ool00`00ool00002ool0
1000ooooo`000ooo00<00?ooool02Ooo00@00?ooool000Woo`03003oo`0000;oo`04003ooooo0009
ool01000ooooo`002Ooo00<00?oo00000_oo00@00?ooool000?oo`03003ooooo02Soo`04003ooooo
0009ool00`00ooooo`02ool01000ooooo`000ooo00<00?ooool02Ooo00@00?ooool000Woo`03003o
oooo00Coo`03003ooooo00Soo`04003ooooo0009ool00`00ooooo`04ool00`00ooooo`02ool00`00
ooooo`09ool0017oo`8000_oo`8000?oo`8000_oo`8000_oo`8000?oo`8000Coo`<000[oo`8000_o
o`8000?oo`<000[oo`8000_oo`8000?oo`<000?oo`<002Woo`8000[oo`<000?oo`8000Coo`<000[o
o`8000[oo`<000?oo`8000_oo`8000[oo`<000?oo`8000Coo`<000Woo`00oooo8Ooo002Sool00`00
ooooo`1jool00:?oo`03003ooooo07[oo`00Xooo00<00?ooool0N_oo002Sool00`00ooooo`1jool0
00Koool0018000Woo`001_oo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01?oo00<00?oo
ool00ooo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01?oo00<00?oo
ool00ooo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01?oo00<00?oo
ool01?oo00<00?ooool00ooo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01?oo00<00?oo
ool01?oo00<00?ooool00ooo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01?oo00<00?oo
ool01?oo00<00?ooool00ooo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01?oo00<00?oo
ool01?oo00<00?ooool00ooo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01?oo00<00?oo
ool01?oo00<00?ooool01?oo00<00?ooool00ooo00<00?ooool01?oo00<00?ooool01?oo00<00?oo
ool01?oo00<00?ooool03Ooo000Kool00`00ooooo`0Oool00`00ooooo`0Oool00`00ooooo`0Oool0
0`00ooooo`0Oool00`00ooooo`0Oool00`00ooooo`0Oool00`00ooooo`0Oool00`00ooooo`0Dool0
0:?oo`03003ooooo07[oo`00Xooo00<00?ooool0N_oo002Sool2001kool00:?oo`03003ooooo07[o
o`00Xooo00<00?ooool0N_oo002Sool00`00ooooo`1jool00:?oo`03003ooooo07[oo`00Xooo00<0
0?ooool0N_oo002Sool2001kool00:?oo`03003ooooo07[oo`00Xooo00<00?ooool0N_oo002Sool0
0`00ooooo`1jool00:?oo`03003ooooo07[oo`00Xooo0P00Nooo000@ool00`00ooooo`2@ool00`00
ooooo`1jool0013oo`03003ooooo00[oo`03003ooooo00Woo`03003ooooo00[oo`03003ooooo00Oo
o`03003ooooo063oo`03003ooooo07[oo`007Ooo00<00?ooool02Ooo00<00?ooool02_oo00<00?oo
ool01ooo00<00?ooool02?oo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool0@Ooo00<00?oo
ool0N_oo001;ool00`00ooooo`07ool00`00ooooo`07ool00`00ooooo`06ool00`00ooooo`05ool0
0`00ooooo`06ool00`00ooooo`05ool00`00ooooo`0Oool00`00ooooo`1jool006Soo`03003ooooo
00Goo`03003ooooo00Koo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo
00Coo`03003ooooo00[oo`8007_oo`00R?oo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool0
0ooo00<00?ooool00ooo0P001?oo00<00?ooool00_oo00<00?ooool0L?oo002Lool00`00ooooo`03
ool20004ool00`00ooooo`02ool00`00ooooo`03ool01@00oooooooo00001?oo00D00?ooooooo`00
05ooo`00Xooo00<00?ooool03Ooo00D00?ooooooo`0000Coo`05003oooooool00004ool01@00oooo
oooo00000_oo00<00?ooool0DOoo002Kool20006ool00`00ooooo`0Oool01@00oooooooo00000_oo
00D00?ooooooo`0000?oo`06003ooooo003oo`00A_oo002Jool01000ooooo`001Ooo00<00?ooool0
:_oo00D00?ooooooo`0000;oo`03003oo`0000;oo`04003ooooo0002ool00`00ooooo`0kool009go
o`03003ooooo00?oo`<003Koo`04003ooooo0002ool00`00ool00002ool00`00ool0000fool009_o
o`8000Koo`03003ooooo03koo`0>003ooooo003oo`00ool00?oo003oo`00ool002koo`00Vooo00<0
0?ooool01Ooo00<00?ooool0AOoo00H00?oo003oo`00ool200000ooo0000000Zool009_oo`<000Go
o`03003ooooo04coo`05003oo`00003oo`0300000ooo003oo`0Sool00:?oo`03003ooooo057oo`<0
0003ool000000080027oo`00Xooo0P00Eooo1P007_oo002Sool00`00ooooo`1Iool5000Lool00:?o
o`03003ooooo05_oo`D001[oo`00Xooo00<00?ooool0G_oo10006?oo002Sool00`00ooooo`1Pool3
000Gool00:?oo`8006?oo`<001Goo`00Xooo00<00?ooool0Hooo0`005?oo002Sool00`00ooooo`1T
ool2000Dool00:?oo`03003ooooo06Goo`8001?oo`00Xooo00<00?ooool0I_oo0P004_oo002Sool0
0`00ooooo`1Vool2000Bool00:?oo`8006Soo`80017oo`00Xooo00<00?ooool0Iooo0P004Ooo002S
ool00`00ooooo`1Xool00`00ooooo`0?ool00:?oo`03003ooooo06Soo`03003ooooo00ooo`00Xooo
00<00?ooool0J?oo00<00?ooool03ooo002Sool2001Yool2000@ool00:?oo`03003ooooo06Woo`03
003ooooo00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Dool50002ool20006ool00`00
ooooo`1Yool00`00ooooo`0>ool009Koo`05003oooooool00002ool00`00ooooo`03ool00`00oooo
o`1Yool00`00ooooo`0>ool009Koo`05003oooooool00002ool00`00ooooo`03ool3001Yool00`00
ooooo`0>ool009Koo`05003oooooool00002ool00`00ooooo`03ool00`00ooooo`1Yool00`00oooo
o`0>ool009Koo`05003oooooool00002ool00`00ooooo`03ool00`00ooooo`1Yool00`00ooooo`0>
ool009Goo`8000Coo`8000Koo`03003ooooo06Woo`03003ooooo00koo`00Xooo00<00?ooool0JOoo
00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool00:?oo`8006[oo`03003ooooo
00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>
ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo
002Sool2001Zool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo00<0
0?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool00:?oo`03003o
oooo06Woo`03003ooooo00koo`00Xooo0P00J_oo00<00?ooool03_oo002Sool00`00ooooo`1Yool0
0`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo00<00?ooool0JOoo00<0
0?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003o
oooo00koo`00Xooo0P00J_oo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool0
0:?oo`03003ooooo06Woo`03003ooooo00koo`00U?oo1@000_oo0P001_oo00<00?ooool0JOoo00<0
0?ooool03_oo002Fool01@00oooooooo00000_oo00<00?ooool00ooo00<00?ooool0JOoo00<00?oo
ool03_oo002Fool00`00ooooo`04ool00`00ooooo`03ool3001Yool00`00ooooo`0>ool009Koo`03
003ooooo00;oo`8000Koo`03003ooooo06Woo`03003ooooo00koo`00U_oo00<00?ooool00_oo00<0
0?ooool01Ooo00<00?ooool0JOoo00<00?ooool03_oo002Eool20004ool30005ool00`00ooooo`1Y
ool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo0P00J_oo00<00?oo
ool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo
00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>
ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo0P00J_oo00<00?ooool03_oo002Sool0
0`00ooooo`1Yool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo00<0
0?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool00:?oo`8006[o
o`03003ooooo00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool0
0`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo00<00?ooool0JOoo00<0
0?ooool03_oo002Sool2001Zool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00ko
o`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool0
09Coo`@000?oo`8000Koo`03003ooooo06Woo`03003ooooo00koo`00U?oo00<00?ooool00ooo00@0
0?ooool000Goo`03003ooooo06Woo`03003ooooo00koo`00UOoo00<00?ooool00_oo00@00?ooool0
00Goo`<006Woo`03003ooooo00koo`00U_oo00D00?ooooooo`0000;oo`03003ooooo00?oo`03003o
oooo06Woo`03003ooooo00koo`00U?oo00@00?ooool000;oo`04003ooooo0005ool00`00ooooo`1Y
ool00`00ooooo`0>ool009Goo`8000Coo`8000Koo`03003ooooo06Woo`03003ooooo00koo`00Xooo
00<00?ooool0JOoo00<00?ooool03_oo002Sool2001Zool00`00ooooo`0>ool00:?oo`03003ooooo
06Woo`03003ooooo00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Y
ool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo0P00J_oo00<00?oo
ool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo
00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>
ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo0P00J_oo00<00?ooool03_oo002Sool0
0`00ooooo`1Yool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo00<0
0?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool00:?oo`8006[o
o`03003ooooo00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool0
0`00ooooo`0>ool009Coo`@000?oo`8000Koo`03003ooooo06Woo`03003ooooo00koo`00U?oo00<0
0?ooool00ooo00@00?ooool000Goo`03003ooooo06Woo`03003ooooo00koo`00UOoo00<00?ooool0
1Ooo00<00?ooool00ooo0`00JOoo00<00?ooool03_oo002Fool00`00ooooo`02ool20006ool00`00
ooooo`1Yool00`00ooooo`0>ool009Coo`04003ooooo0003ool00`00ooooo`05ool00`00ooooo`1Y
ool00`00ooooo`0>ool009Goo`8000Coo`<000Goo`03003ooooo06Woo`03003ooooo00koo`00Xooo
00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool00:?oo`80
06[oo`03003ooooo00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Y
ool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo00<00?ooool0JOoo
00<00?ooool03_oo002Sool2001Zool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo
00koo`00Xooo00<00?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>
ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo0P00J_oo00<00?ooool03_oo002Sool0
0`00ooooo`1Yool00`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00Xooo00<0
0?ooool0JOoo00<00?ooool03_oo002Sool00`00ooooo`1Yool00`00ooooo`0>ool00:?oo`03003o
oooo06Woo`03003ooooo00koo`00Xooo0P00J_oo00<00?ooool03_oo002Sool00`00ooooo`1Yool0
0`00ooooo`0>ool00:?oo`03003ooooo06Woo`03003ooooo00koo`00UOoo0P001?oo0P001_oo00<0
0?ooool0JOoo00<00?ooool03_oo002Dool01000ooooo`000_oo00@00?ooool000Goo`03003ooooo
06Woo`03003ooooo00koo`00U_oo00D00?ooooooo`0000;oo`03003ooooo00?oo`<006Woo`03003o
oooo00koo`00Uooo00@00?ooool000;oo`03003ooooo00?oo`03003ooooo06Woo`03003ooooo00ko
o`00U?oo00@00?ooool000;oo`04003ooooo0005ool00`00ooooo`1jool009Goo`8000Coo`8000Ko
o`03003ooooo07[oo`00Xooo00<00?ooool0N_oo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {0.476017, -2.32532, \
0.000146836, 0.187463}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell["\<\
The package is particularly useful for analyzing the computed \
solutions of PDEs\
\>", "Text"],

Cell["\<\
With this initial condition, Burgers' equation forms a steep front.\
\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mdfun\  = \ 
      First[u\  /. 
          NDSolve[{D[u[x, t], t]\  \[Equal] \ 
                0.01\ D[u[x, t], x, x]\  - \ u[x, t]\ D[u[x, t], x], \ 
              u[0, \ t]\  \[Equal] \ u[1, t], \ 
              u[x, 0]\  \[Equal] \ Sin[2\ Pi\ x]}, 
            u, {x, 0, 1}, {t, 0, 0.5}]]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndsz"\), \(\(:\)\(\ \)\), "\<\"At \\!\\(t\\) == \
\\!\\(0.4721511683265256`\\), step size is effectively zero; singularity or \
stiff system suspected. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"NDSolve::ndsz\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[8]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"eerr"\), \(\(:\)\(\ \)\), "\<\"Warning: Scaled local \
spatial error estimate of \\!\\(9.135898727911104`*^12\\) at \\!\\(t\\) = \\!\
\\(0.4721511683265256`\\) in the direction of independent variable \\!\\(x\\) \
is much greater than prescribed error tolerance. Grid spacing with \
\\!\\(27\\) points may be too large to achieve the desired accuracy or \
precision.  A singularity may have formed or you may want to specify a \
smaller grid spacing using the MaxStepSize or MinPoints options. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NDSolve::eerr\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[8]:="],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{"...", 0.`, 1.`, "..."}, {0.`, 
            0.4721511683265256`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell["This shows the number of points used in each dimension.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Length, \ InterpolatingFunctionCoordinates[mdfun]]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({27, 312}\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["This shows the interpolation order used in each dimension.", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingFunctionInterpolationOrder[mdfun]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \({5, 3}\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell["\<\
This shows that the inability to resolve the front has manifested \
itself as numerical instability.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Max[Abs[InterpolatingFunctionValuesOnGrid[mdfun]]]\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \(1.1492807485974258`*^12\)], "Output",
  CellLabel->"Out[11]="]
}, Open  ]],

Cell["\<\
This shows the values computed at the spatial grid points at the \
endpoint of the temporal integration.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(end\  = \ \(InterpolatingFunctionDomain[
            mdfun]\)[\([2, \(-1\)]\)];\)\), "\[IndentingNewLine]", 
    \(\(X\  = \ \(InterpolatingFunctionCoordinates[
            mdfun]\)[\([1]\)];\)\), "\[IndentingNewLine]", 
    \(ListPlot[Transpose[{X, \ mdfun[X, \ end]}], \ 
      PlotStyle \[Rule] PointSize[ .025], \ 
      PlotRange \[Rule] {\(-1\), 1}]\)}], "Input",
  CellLabel->"In[12]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.309017 0.309017 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 0 -12 -4.5 ]
[.01131 0 0 4.5 ]
[.01131 .07725 -30 -4.5 ]
[.01131 .07725 0 4.5 ]
[.01131 .15451 -24 -4.5 ]
[.01131 .15451 0 4.5 ]
[.01131 .23176 -30 -4.5 ]
[.01131 .23176 0 4.5 ]
[.01131 .38627 -24 -4.5 ]
[.01131 .38627 0 4.5 ]
[.01131 .46353 -18 -4.5 ]
[.01131 .46353 0 4.5 ]
[.01131 .54078 -24 -4.5 ]
[.01131 .54078 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(0.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(0.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(0.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(0.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 0 m
.03006 0 L
s
[(-1)] .01131 0 1 0 Mshowa
.02381 .07725 m
.03006 .07725 L
s
[(-0.75)] .01131 .07725 1 0 Mshowa
.02381 .15451 m
.03006 .15451 L
s
[(-0.5)] .01131 .15451 1 0 Mshowa
.02381 .23176 m
.03006 .23176 L
s
[(-0.25)] .01131 .23176 1 0 Mshowa
.02381 .38627 m
.03006 .38627 L
s
[(0.25)] .01131 .38627 1 0 Mshowa
.02381 .46353 m
.03006 .46353 L
s
[(0.5)] .01131 .46353 1 0 Mshowa
.02381 .54078 m
.03006 .54078 L
s
[(0.75)] .01131 .54078 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .01545 m
.02756 .01545 L
s
.02381 .0309 m
.02756 .0309 L
s
.02381 .04635 m
.02756 .04635 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .10816 m
.02756 .10816 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .13906 m
.02756 .13906 L
s
.02381 .16996 m
.02756 .16996 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .20086 m
.02756 .20086 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .26266 m
.02756 .26266 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .29357 m
.02756 .29357 L
s
.02381 .32447 m
.02756 .32447 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .35537 m
.02756 .35537 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .41717 m
.02756 .41717 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .44807 m
.02756 .44807 L
s
.02381 .47898 m
.02756 .47898 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .50988 m
.02756 .50988 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57168 m
.02756 .57168 L
s
.02381 .58713 m
.02756 .58713 L
s
.02381 .60258 m
.02756 .60258 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.025 w
.02381 .30902 Mdot
.06044 .3276 Mdot
.09707 .34617 Mdot
.1337 .36469 Mdot
.17033 .38313 Mdot
.20696 .40149 Mdot
.24359 .41971 Mdot
.28022 .43777 Mdot
.31685 .45561 Mdot
.35348 .47314 Mdot
.39011 .50778 Mdot
.42674 .48748 Mdot
.53663 .20432 Mdot
.60989 .28656 Mdot
.64652 .03535 Mdot
.68315 .17687 Mdot
.71978 .17745 Mdot
.75641 .19848 Mdot
.79304 .21661 Mdot
.82967 .23485 Mdot
.8663 .25335 Mdot
.90293 .27187 Mdot
.93956 .29043 Mdot
.97619 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`006Ooo1@00oooo0ooo000Kool00`00oooo
o`3oool3ool001_oo`03003ooooo00?oo`800?goo`004ooo10001?oo00<00?ooool00ooo00<00?oo
ool0o?oo000Kool00`00ooooo`03ool00`00ooooo`3lool001[oo`8000Goo`03003ooooo0?coo`00
8Ooo0P00oOoo000Qool00`00ooooo`3lool0027oo`03003ooooo0?coo`008Ooo00<00?ooool0W_oo
0P00G?oo000Qool2002Nool4001Kool0027oo`03003ooooo09coo`H005[oo`008Ooo00<00?ooool0
W?oo1P00F_oo000Qool00`00ooooo`2Mool4001Kool0027oo`8009ooo`8005coo`008Ooo00<00?oo
ool0o?oo000Qool00`00ooooo`3lool0027oo`03003ooooo0?coo`008Ooo0P00oOoo000Qool00`00
ooooo`3lool000Soo`8000Coo`8000Goo`03003ooooo00;oo`8000Goo`03003ooooo0?coo`001ooo
00@00?ooool000[oo`05003oooooool00002ool00`00ooooo`02ool00`00ooooo`3lool000Ooo`04
003ooooo000:ool00`00ooooo`04ool00`00ooooo`02ool2003mool00003ool00000008000;oo`04
003ooooo000;ool01000oooooooo0P001Ooo00<00?ooool0o?oo0007ool01000ooooo`002?oo00@0
0?ooool000?oo`03003ooooo00Coo`03003ooooo0?coo`002?oo0P002Ooo10000ooo0`001?oo00<0
0?ooool0o?oo000Qool2003mool0027oo`03003ooooo0?coo`008Ooo00<00?ooool0o?oo000Qool0
0`00ooooo`3lool0027oo`800?goo`008Ooo00<00?ooool0o?oo000Qool00`00ooooo`3lool0027o
o`03003ooooo0?coo`008Ooo0P00oOoo000Qool00`00ooooo`3lool0027oo`03003ooooo0?coo`00
8Ooo00<00?ooool0o?oo000Qool2003mool0027oo`03003ooooo0?coo`003_oo0P001?oo0P001?oo
0P001Ooo00<00?ooool0o?oo000=ool01000ooooo`002?oo00@00?ooool000Coo`03003ooooo0?co
o`003Ooo00@00?ooool000_oo`03003ooooo00;oo`800?goo`001ooo10000_oo00@00?ooool000Wo
o`8000Goo`03003ooooo0?coo`003Ooo00@00?ooool000Woo`03003ooooo00Coo`03003ooooo0?co
o`003_oo0P002_oo0`001?oo00<00?ooool0Yooo0P00Dooo000Qool2002Wool40007ool20019ool0
027oo`03003ooooo0:Goo`H000Goo`@004Soo`008Ooo00<00?ooool0YOoo1P001?oo1P00Aooo000Q
ool00`00ooooo`2Vool40005ool60017ool0027oo`800:Soo`8000Ooo`@004Soo`008Ooo00<00?oo
ool0/Ooo0P001ooo0P00@?oo000Qool00`00ooooo`2iool4000oool0027oo`03003ooooo087oo`80
03Goo`H003koo`008Ooo0P00POoo1000=?oo1P00?_oo000Qool00`00ooooo`1oool6000dool4000o
ool0027oo`03003ooooo07ooo`H003Goo`8000Soo`8003Koo`008Ooo00<00?ooool0P?oo1000?ooo
1000=Ooo000Qool20022ool2000oool6000dool0027oo`03003ooooo0<;oo`H003Coo`002?oo0P00
1?oo0P000ooo10000ooo0P001Ooo00<00?ooool0`ooo1000=Ooo0007ool01000ooooo`002?oo00<0
0?ooool00ooo00@00?ooool000Coo`03003ooooo0<Coo`8000Ooo`8002goo`001ooo00@00?ooool0
00Woo`03003ooooo00Goo`03003ooooo00;oo`800<goo`@002coo`0000?oo`0000000P000_oo00@0
0?ooool000[oo`03003ooooo00;oo`8000Goo`03003ooooo0<_oo`H002_oo`001ooo00@00?ooool0
00Soo`04003ooooo0003ool00`00ooooo`04ool00`00ooooo`3;ool6000[ool000Soo`8000[oo`80
00Coo`<000Coo`03003ooooo0<coo`@000Ooo`8002?oo`008Ooo0P00c_oo0P001ooo10008_oo000Q
ool00`00ooooo`3Eool6000Qool0027oo`03003ooooo0=Goo`H0027oo`008Ooo00<00?ooool0e_oo
10008_oo000Qool2003Hool20008ool2000Iool0027oo`03003ooooo02Ooo`8000Coo`8000?oo`@0
02?oo`8000Coo`8000Goo`<0027oo`8000Coo`8000?oo`<002Coo`8000Coo`8000Coo`8001Koo`@0
00koo`D000Goo`008Ooo00<00?ooool09_oo00@00?ooool000Soo`03003ooooo02?oo`04003ooooo
000;ool00`00ooooo`0Oool01000ooooo`002?oo00@00?ooool002;oo`04003ooooo0008ool01000
ooooo`005?oo1P003ooo00<00?ooool01Ooo000Qool00`00ooooo`0Vool01000ooooo`002Ooo00<0
0?ooool08_oo00@00?ooool000Soo`D0023oo`04003ooooo0008ool01000ooooo`008_oo00@00?oo
ool000Soo`04003ooooo000Dool6000?ool00`00ooooo`05ool0027oo`8002Ooo`04003ooooo000:
ool00`00ooooo`0Qool01000ooooo`002?oo00@00?ooool0027oo`04003ooooo0007ool4000Sool0
1000ooooo`002Ooo0P005_oo10004?oo00<00?ooool01Ooo000Qool00`00ooooo`0Vool01000oooo
o`002?oo00@00?ooool002;oo`04003ooooo0009ool00`00ool0000Qool01000ooooo`001_oo1000
9?oo00@00?ooool000Soo`04003ooooo000Fool20007ool20008ool00`00ooooo`05ool0027oo`03
003ooooo02Ooo`8000[oo`8002Coo`8000_oo`8002;oo`8000Koo`L002?oo`8000[oo`8001ooo`@0
00Koo`8000Ooo`008Ooo00<00?ooool0T_oo1P00D?oo1P003_oo000Qool2002Dool4001Aool6000>
ool0027oo`03003ooooo09Coo`8005?oo`@000ooo`008?oo0P00k?oo0P002?oo0P001_oo000Oool4
003dool40005ool001_oool000H000007_oo1P002Ooo00<00?ooool02_oo00<00?ooool02Ooo00<0
0?ooool02Ooo00<00?ooool02_oo00<00?ooool02Ooo00<00?ooool02Ooo00<00?ooool02_oo00<0
0?ooool02Ooo00<00?ooool02_oo00<00?ooool02Ooo00<00?ooool02Ooo00<00?ooool02_oo00<0
0?ooool02Ooo00<00?ooool02Ooo00<00?ooool02_oo00<00?ooool02Ooo00<00?ooool02_oo00<0
0?ooool02Ooo00<00?ooool01ooo1P001?oo000Oool4000_ool00`00ooooo`0_ool00`00ooooo`0^
ool00`00ooooo`0_ool00`00ooooo`0]ool40005ool0023oo`8000Soo`800>coo`8000Koo`008Ooo
0P001_oo1000looo000Qool00`00ooooo`04ool6003bool0027oo`03003ooooo00Coo`H00?;oo`00
8Ooo00<00?ooool01Ooo10001_oo0P00jooo000Qool20007ool20006ool4003Zool0027oo`03003o
oooo00goo`H00>Woo`008Ooo00<00?ooool03Ooo1P00jOoo000Qool00`00ooooo`0>ool4003Zool0
027oo`80013oo`8000Soo`800>7oo`008Ooo00<00?ooool06?oo1000h?oo000Qool00`00ooooo`0G
ool6003Oool0027oo`03003ooooo01Ooo`H00=ooo`008Ooo0P006Ooo1000h?oo000Qool00`00oooo
o`0Iool20007ool2003Hool000Soo`8000Coo`8000?oo`@000?oo`8000Goo`03003ooooo027oo`@0
0=Ooo`001ooo00@00?ooool000Soo`03003ooooo00?oo`04003ooooo0004ool00`00ooooo`0Pool6
003Fool000Ooo`04003ooooo0009ool00`00ooooo`05ool00`00ooooo`02ool2000Qool6003Fool0
00Ooo`04003ooooo000:ool00`00ooooo`02ool20005ool00`00ooooo`0Qool4003Gool000Ooo`04
003ooooo0008ool01000ooooo`000ooo00<00?ooool01?oo00<00?ooool08_oo0P002?oo0P00c_oo
0008ool2000:ool20004ool30004ool00`00ooooo`0[ool4003=ool0027oo`8002_oo`H00<coo`00
8Ooo00<00?ooool0:_oo1P00c?oo000Qool00`00ooooo`0[ool4003=ool0027oo`03003ooooo02co
o`8000Ooo`800<Goo`008Ooo0P00=Ooo1000a?oo000Qool00`00ooooo`0cool60033ool0027oo`03
003ooooo03?oo`H00<?oo`008Ooo00<00?ooool0=?oo10001ooo0P00^ooo000Qool2000fool20007
ool4002jool0027oo`03003ooooo03goo`H00;Woo`008Ooo00<00?ooool0?Ooo1P00^Ooo000Qool0
0`00ooooo`0nool4002jool0027oo`80043oo`8000Ooo`800;;oo`008Ooo00<00?ooool0Aooo1000
/Ooo000>ool20004ool20004ool20005ool00`00ooooo`16ool6002`ool000goo`04003ooooo0008
ool01000ooooo`001?oo00<00?ooool0A_oo1P00/?oo000=ool01000ooooo`002ooo00<00?ooool0
0_oo0P00B?oo10001ooo0P00Z?oo000=ool01000ooooo`002Ooo0P001Ooo00<00?ooool0B?oo0P00
1ooo1000Yooo000=ool01000ooooo`002Ooo00<00?ooool01?oo00<00?ooool0D?oo1P00Y_oo000>
ool2000:ool30004ool00`00ooooo`1@ool6002Vool0027oo`8005;oo`@0013oo`8009Goo`008Ooo
00<00?ooool0D_oo0P004?oo1000U?oo000Qool00`00ooooo`1Sool6002Cool0027oo`03003ooooo
06?oo`H009?oo`008Ooo0P00IOoo1000U?oo000Qool00`00ooooo`1Kool20008ool2002Eool0027o
o`03003ooooo05[oo`@009koo`008Ooo00<00?ooool0FOoo1P00WOoo000Qool2001Jool6002Mool0
027oo`03003ooooo05[oo`@009koo`008Ooo00<00?ooool0Fooo0P00Wooo000Qool00`00ooooo`3l
ool0027oo`800?goo`008Ooo00<00?ooool0o?oo0008ool20004ool20005ool00`00ooooo`02ool2
0005ool00`00ooooo`3lool000Ooo`04003ooooo000:ool01@00oooooooo00000_oo00<00?ooool0
0_oo00<00?ooool0o?oo0007ool01000ooooo`002_oo00<00?ooool01?oo00<00?ooool00_oo0P00
oOoo0007ool01000ooooo`002ooo00@00?ooooooo`8000Goo`03003ooooo0?coo`001ooo00@00?oo
ool000Soo`04003ooooo0003ool00`00ooooo`04ool00`00ooooo`3lool000Soo`8000Woo`@000?o
o`<000Coo`03003ooooo0?coo`008Ooo0P00oOoo000Qool00`00ooooo`3lool0027oo`03003ooooo
0?coo`008Ooo00<00?ooool0o?oo000Qool2003mool0027oo`03003ooooo0?coo`008Ooo00<00?oo
ool0o?oo000Qool00`00ooooo`3lool0027oo`800?goo`008Ooo00<00?ooool0o?oo000Qool00`00
ooooo`3lool0027oo`03003ooooo0?coo`008Ooo0P00oOoo000Qool00`00ooooo`3lool001Woo`D0
00?oo`03003ooooo0?coo`006ooo00<00?ooool00ooo00<00?ooool0o?oo000Kool00`00ooooo`03
ool2003mool001_oo`03003ooooo0?ooo`?oo`006ooo00<00?ooool0oooo0ooo000Jool2003oool5
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.134313, -1.10139, \
0.00403944, 0.0124494}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell["\<\
It is easily seen from the point plot above that the front has not \
been resolved.\
\>", "Text"],

Cell["\<\
This makes a 3-D plot showing how the time evolution for each of \
the spatial grid points.  The initial condition is shown in red.\
\>", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[{Map[Line, \ 
            MapThread[
              Append, \ {InterpolatingFunctionGrid[mdfun], \ 
                InterpolatingFunctionValuesOnGrid[mdfun]}, \ 2]], \ {RGBColor[
              1, 0, 0], Line[Transpose[{X, \ 0. \ X, \ mdfun[X, 0. ]}]]}}], \ 
      BoxRatios \[Rule] {1, 1, 1}, \ 
      PlotRange \[Rule] {All, \ All, \ {\(-1\), 1}}]\)], "Input",
  CellLabel->"In[15]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 -4.43981e-017 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49571 m
.73206 .49571 L
s
.73206 .49572 m
.73206 .49571 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49572 m
.73206 .49572 L
s
.73206 .49573 m
.73206 .49572 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49573 m
.73206 .49573 L
s
.73206 .49574 m
.73206 .49573 L
s
.73206 .49574 m
.73206 .49574 L
s
.73206 .49574 m
.73206 .49574 L
s
.73206 .49574 m
.73206 .49574 L
s
.73206 .49574 m
.73206 .49574 L
s
.73207 .49574 m
.73206 .49574 L
s
.73207 .49574 m
.73207 .49574 L
s
.73207 .49575 m
.73207 .49574 L
s
.73207 .49575 m
.73207 .49575 L
s
.73207 .49575 m
.73207 .49575 L
s
.73207 .49575 m
.73207 .49575 L
s
.73207 .49575 m
.73207 .49575 L
s
.73207 .49575 m
.73207 .49575 L
s
.73207 .49576 m
.73207 .49575 L
s
.73207 .49576 m
.73207 .49576 L
s
.73207 .49576 m
.73207 .49576 L
s
.73207 .49576 m
.73207 .49576 L
s
.73207 .49577 m
.73207 .49576 L
s
.73207 .49577 m
.73207 .49577 L
s
.73207 .49577 m
.73207 .49577 L
s
.73207 .49577 m
.73207 .49577 L
s
.73207 .49578 m
.73207 .49577 L
s
.73207 .49578 m
.73207 .49578 L
s
.73207 .49578 m
.73207 .49578 L
s
.73207 .49579 m
.73207 .49578 L
s
.73207 .49579 m
.73207 .49579 L
s
.73207 .49579 m
.73207 .49579 L
s
.73207 .4958 m
.73207 .49579 L
s
.73207 .4958 m
.73207 .4958 L
s
.73207 .49581 m
.73207 .4958 L
s
.73207 .49581 m
.73207 .49581 L
s
.73207 .49581 m
.73207 .49581 L
s
.73207 .49582 m
.73207 .49581 L
s
.73207 .49582 m
.73207 .49582 L
s
.73207 .49583 m
.73207 .49582 L
s
.73207 .49583 m
.73207 .49583 L
s
.73207 .49584 m
.73207 .49583 L
s
.73207 .49585 m
.73207 .49584 L
s
.73207 .49585 m
.73207 .49585 L
s
.73207 .49586 m
.73207 .49585 L
s
.73207 .49587 m
.73207 .49586 L
s
.73207 .49587 m
.73207 .49587 L
s
.73207 .49588 m
.73207 .49587 L
s
.73207 .49589 m
.73207 .49588 L
s
.73208 .4959 m
.73207 .49589 L
s
.73208 .4959 m
.73208 .4959 L
s
.73208 .49591 m
.73208 .4959 L
s
.73208 .49592 m
.73208 .49591 L
s
.73208 .49593 m
.73208 .49592 L
s
.73208 .49594 m
.73208 .49593 L
s
.73208 .49595 m
.73208 .49594 L
s
.73208 .49596 m
.73208 .49595 L
s
.73208 .49597 m
.73208 .49596 L
s
.73208 .49598 m
.73208 .49597 L
s
.73208 .496 m
.73208 .49598 L
s
.73208 .49601 m
.73208 .496 L
s
.73208 .49602 m
.73208 .49601 L
s
.73209 .49604 m
.73208 .49602 L
s
.73209 .49605 m
.73209 .49604 L
s
.73209 .49607 m
.73209 .49605 L
s
.73209 .49608 m
.73209 .49607 L
s
.73209 .4961 m
.73209 .49608 L
s
.73209 .49612 m
.73209 .4961 L
s
.73209 .49613 m
.73209 .49612 L
s
.73209 .49615 m
.73209 .49613 L
s
.73209 .49617 m
.73209 .49615 L
s
.7321 .49619 m
.73209 .49617 L
s
.7321 .49622 m
.7321 .49619 L
s
.7321 .49624 m
.7321 .49622 L
s
.7321 .49626 m
.7321 .49624 L
s
.7321 .49629 m
.7321 .49626 L
s
.7321 .49631 m
.7321 .49629 L
s
.73211 .49634 m
.7321 .49631 L
s
.73211 .49636 m
.73211 .49634 L
s
.73211 .4964 m
.73211 .49636 L
s
.73211 .49642 m
.73211 .4964 L
s
.73211 .49646 m
.73211 .49642 L
s
.73212 .49649 m
.73211 .49646 L
s
.73212 .49652 m
.73212 .49649 L
s
.73212 .49656 m
.73212 .49652 L
s
.73212 .4966 m
.73212 .49656 L
s
.73213 .49663 m
.73212 .4966 L
s
.73213 .49668 m
.73213 .49663 L
s
.73213 .49672 m
.73213 .49668 L
s
.73213 .49676 m
.73213 .49672 L
s
.73214 .49681 m
.73213 .49676 L
s
.73214 .49686 m
.73214 .49681 L
s
.73214 .49691 m
.73214 .49686 L
s
.73215 .49696 m
.73214 .49691 L
s
.73215 .49701 m
.73215 .49696 L
s
.73216 .49707 m
.73215 .49701 L
s
.73216 .49713 m
.73216 .49707 L
s
.73216 .49719 m
.73216 .49713 L
s
.73217 .49725 m
.73216 .49719 L
s
.73217 .49732 m
.73217 .49725 L
s
.73218 .49739 m
.73217 .49732 L
s
.73218 .49747 m
.73218 .49739 L
s
.73219 .49754 m
.73218 .49747 L
s
.73219 .49762 m
.73219 .49754 L
s
.7322 .4977 m
.73219 .49762 L
s
.7322 .49779 m
.7322 .4977 L
s
.73221 .49788 m
.7322 .49779 L
s
.73222 .49798 m
.73221 .49788 L
s
.73222 .49807 m
.73222 .49798 L
s
.73223 .49817 m
.73222 .49807 L
s
.73224 .49827 m
.73223 .49817 L
s
.73224 .49839 m
.73224 .49827 L
s
.73225 .4985 m
.73224 .49839 L
s
.73226 .49862 m
.73225 .4985 L
s
.66944 .45302 m
.66822 .45627 L
s
.73227 .49874 m
.73226 .49862 L
s
.73228 .49888 m
.73227 .49874 L
s
.73229 .499 m
.73228 .49888 L
s
.7323 .49915 m
.73229 .499 L
s
.73231 .49929 m
.7323 .49915 L
s
.73232 .49945 m
.73231 .49929 L
s
.73233 .4996 m
.73232 .49945 L
s
.73234 .49977 m
.73233 .4996 L
s
.73235 .49993 m
.73234 .49977 L
s
.73236 .50011 m
.73235 .49993 L
s
.73237 .50029 m
.73236 .50011 L
s
.73239 .50049 m
.73237 .50029 L
s
.7324 .50068 m
.73239 .50049 L
s
.73241 .50089 m
.7324 .50068 L
s
.73243 .50109 m
.73241 .50089 L
s
.73244 .50133 m
.73243 .50109 L
s
.73246 .50154 m
.73244 .50133 L
s
.73247 .50179 m
.73246 .50154 L
s
.73249 .50203 m
.73247 .50179 L
s
.7325 .5023 m
.73249 .50203 L
s
.73252 .50255 m
.7325 .5023 L
s
.73254 .50284 m
.73252 .50255 L
s
.73256 .50311 m
.73254 .50284 L
s
.73258 .50342 m
.73256 .50311 L
s
.7326 .50371 m
.73258 .50342 L
s
.73262 .50405 m
.7326 .50371 L
s
.73264 .50436 m
.73262 .50405 L
s
.73266 .50472 m
.73264 .50436 L
s
.73268 .50505 m
.73266 .50472 L
s
.73271 .50543 m
.73268 .50505 L
s
.73273 .50579 m
.73271 .50543 L
s
.73275 .5062 m
.73273 .50579 L
s
.73278 .50658 m
.73275 .5062 L
s
.7328 .50701 m
.73278 .50658 L
s
.66588 .46042 m
.66822 .45627 L
s
.73283 .50742 m
.7328 .50701 L
s
.73286 .50788 m
.73283 .50742 L
s
.73288 .50832 m
.73286 .50788 L
s
.73291 .50881 m
.73288 .50832 L
s
.73294 .50927 m
.73291 .50881 L
s
.73297 .50979 m
.73294 .50927 L
s
.733 .51028 m
.73297 .50979 L
s
.73303 .51083 m
.733 .51028 L
s
.73306 .51135 m
.73303 .51083 L
s
.73309 .51193 m
.73306 .51135 L
s
.73312 .51248 m
.73309 .51193 L
s
.73315 .5131 m
.73312 .51248 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41465 .80504 m
.41465 .80504 L
s
.41464 .80503 m
.41465 .80504 L
s
.41464 .80503 m
.41464 .80503 L
s
.41464 .80503 m
.41464 .80503 L
s
.41464 .80503 m
.41464 .80503 L
s
.41464 .80503 m
.41464 .80503 L
s
.41464 .80503 m
.41464 .80503 L
s
.41464 .80503 m
.41464 .80503 L
s
.41464 .80503 m
.41464 .80503 L
s
.41464 .80503 m
.41464 .80503 L
s
.41464 .80503 m
.41464 .80503 L
s
.41464 .80503 m
.41464 .80503 L
s
.41463 .80503 m
.41464 .80503 L
s
.41463 .80502 m
.41463 .80503 L
s
.41463 .80502 m
.41463 .80502 L
s
.41463 .80502 m
.41463 .80502 L
s
.41463 .80502 m
.41463 .80502 L
s
.41462 .80502 m
.41463 .80502 L
s
.41462 .80501 m
.41462 .80502 L
s
.41462 .80501 m
.41462 .80501 L
s
.41462 .80501 m
.41462 .80501 L
s
.41461 .80501 m
.41462 .80501 L
s
.41461 .805 m
.41461 .80501 L
s
.4146 .805 m
.41461 .805 L
s
.4146 .80499 m
.4146 .805 L
s
.41459 .80499 m
.4146 .80499 L
s
.41459 .80499 m
.41459 .80499 L
s
.41458 .80498 m
.41459 .80499 L
s
.41458 .80497 m
.41458 .80498 L
s
.41457 .80497 m
.41458 .80497 L
s
.41456 .80496 m
.41457 .80497 L
s
.41455 .80495 m
.41456 .80496 L
s
.41454 .80494 m
.41455 .80495 L
s
.41453 .80493 m
.41454 .80494 L
s
.41452 .80492 m
.41453 .80493 L
s
.41451 .80491 m
.41452 .80492 L
s
.41449 .8049 m
.41451 .80491 L
s
.41448 .80489 m
.41449 .8049 L
s
.41446 .80487 m
.41448 .80489 L
s
.41444 .80486 m
.41446 .80487 L
s
.41442 .80484 m
.41444 .80486 L
s
.73318 .51367 m
.73315 .5131 L
s
.4144 .80482 m
.41442 .80484 L
s
.41437 .80479 m
.4144 .80482 L
s
.41435 .80477 m
.41437 .80479 L
s
.41431 .80474 m
.41435 .80477 L
s
.41428 .80471 m
.41431 .80474 L
s
.41424 .80468 m
.41428 .80471 L
s
.4142 .80465 m
.41424 .80468 L
s
.41416 .8046 m
.4142 .80465 L
s
.41411 .80456 m
.41416 .8046 L
s
.41405 .80451 m
.41411 .80456 L
s
.73322 .51432 m
.73318 .51367 L
s
.41399 .80446 m
.41405 .80451 L
s
.41392 .8044 m
.41399 .80446 L
s
.41385 .80433 m
.41392 .8044 L
s
.41376 .80426 m
.41385 .80433 L
s
.41367 .80418 m
.41376 .80426 L
s
.73325 .51493 m
.73322 .51432 L
s
.41356 .80408 m
.41367 .80418 L
s
.41345 .80399 m
.41356 .80408 L
s
.41332 .80387 m
.41345 .80399 L
s
.73328 .51562 m
.73325 .51493 L
s
.41319 .80375 m
.41332 .80387 L
s
.41303 .80361 m
.41319 .80375 L
s
.41286 .80347 m
.41303 .80361 L
s
.73331 .51625 m
.73328 .51562 L
s
.41267 .80329 m
.41286 .80347 L
s
.41247 .80311 m
.41267 .80329 L
s
.73335 .51697 m
.73331 .51625 L
s
.41222 .8029 m
.41247 .80311 L
s
.41198 .80268 m
.41222 .8029 L
s
.73338 .51764 m
.73335 .51697 L
s
.41168 .80242 m
.41198 .80268 L
s
.73341 .5184 m
.73338 .51764 L
s
.41138 .80216 m
.41168 .80242 L
s
.41101 .80183 m
.41138 .80216 L
s
.73344 .5191 m
.73341 .5184 L
s
.41064 .80151 m
.41101 .80183 L
s
.73347 .51989 m
.73344 .5191 L
s
.41019 .80111 m
.41064 .80151 L
s
.66279 .46382 m
.66588 .46042 L
s
.73349 .52062 m
.73347 .51989 L
s
.40974 .80071 m
.41019 .80111 L
s
.73352 .52145 m
.73349 .52062 L
s
.40918 .80022 m
.40974 .80071 L
s
.73354 .52221 m
.73352 .52145 L
s
.40862 .79972 m
.40918 .80022 L
s
.73357 .52307 m
.73354 .52221 L
s
.60902 .43775 m
.60591 .45538 L
s
.40793 .79912 m
.40862 .79972 L
s
.73359 .52386 m
.73357 .52307 L
s
.7336 .52476 m
.73359 .52386 L
s
.40724 .79851 m
.40793 .79912 L
s
.73362 .52558 m
.7336 .52476 L
s
.40639 .79776 m
.40724 .79851 L
s
.73363 .52651 m
.73362 .52558 L
s
.40554 .79701 m
.40639 .79776 L
s
.73363 .52736 m
.73363 .52651 L
s
.73363 .52832 m
.73363 .52736 L
s
.40448 .79608 m
.40554 .79701 L
s
.73363 .5292 m
.73363 .52832 L
s
.40342 .79515 m
.40448 .79608 L
s
.73361 .53017 m
.73363 .5292 L
s
.73359 .53105 m
.73361 .53017 L
s
.40211 .79399 m
.40342 .79515 L
s
.73356 .53202 m
.73359 .53105 L
s
.73352 .53289 m
.73356 .53202 L
s
.6596 .4657 m
.66279 .46382 L
s
.40079 .79283 m
.40211 .79399 L
s
.73347 .53386 m
.73352 .53289 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81505 m
.43263 .81505 L
s
.43263 .81504 m
.43263 .81505 L
s
.43263 .81504 m
.43263 .81504 L
s
.43262 .81504 m
.43263 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43262 .81504 m
.43262 .81504 L
s
.43261 .81504 m
.43262 .81504 L
s
.43261 .81503 m
.43261 .81504 L
s
.43261 .81503 m
.43261 .81503 L
s
.43261 .81503 m
.43261 .81503 L
s
.43261 .81503 m
.43261 .81503 L
s
.43261 .81503 m
.43261 .81503 L
s
.4326 .81503 m
.43261 .81503 L
s
.4326 .81502 m
.4326 .81503 L
s
.4326 .81502 m
.4326 .81502 L
s
.4326 .81502 m
.4326 .81502 L
s
.43259 .81502 m
.4326 .81502 L
s
.43259 .81501 m
.43259 .81502 L
s
.43259 .81501 m
.43259 .81501 L
s
.43258 .81501 m
.43259 .81501 L
s
.43258 .815 m
.43258 .81501 L
s
.43257 .815 m
.43258 .815 L
s
.43257 .81499 m
.43257 .815 L
s
.43256 .81499 m
.43257 .81499 L
s
.43255 .81498 m
.43256 .81499 L
s
.43255 .81498 m
.43255 .81498 L
s
.43254 .81497 m
.43255 .81498 L
s
.43253 .81496 m
.43254 .81497 L
s
.43252 .81496 m
.43253 .81496 L
s
.43251 .81495 m
.43252 .81496 L
s
.4325 .81494 m
.43251 .81495 L
s
.43248 .81493 m
.4325 .81494 L
s
.43247 .81491 m
.43248 .81493 L
s
.43245 .8149 m
.43247 .81491 L
s
.43244 .81489 m
.43245 .8149 L
s
.43242 .81487 m
.43244 .81489 L
s
.4324 .81485 m
.43242 .81487 L
s
.43238 .81483 m
.4324 .81485 L
s
.43235 .81481 m
.43238 .81483 L
s
.43232 .81479 m
.43235 .81481 L
s
.43229 .81476 m
.43232 .81479 L
s
.73341 .53472 m
.73347 .53386 L
s
.43226 .81474 m
.43229 .81476 L
s
.43222 .8147 m
.43226 .81474 L
s
.39915 .79138 m
.40079 .79283 L
s
.43218 .81467 m
.43222 .8147 L
s
.43213 .81463 m
.43218 .81467 L
s
.43209 .81459 m
.43213 .81463 L
s
.43203 .81454 m
.43209 .81459 L
s
.43197 .81449 m
.43203 .81454 L
s
.4319 .81443 m
.43197 .81449 L
s
.43183 .81437 m
.4319 .81443 L
s
.43174 .8143 m
.43183 .81437 L
s
.43165 .81422 m
.43174 .8143 L
s
.43154 .81413 m
.43165 .81422 L
s
.73332 .53567 m
.73341 .53472 L
s
.43143 .81404 m
.43154 .81413 L
s
.4313 .81393 m
.43143 .81404 L
s
.43117 .81382 m
.4313 .81393 L
s
.43101 .81368 m
.43117 .81382 L
s
.43084 .81354 m
.43101 .81368 L
s
.43065 .81337 m
.43084 .81354 L
s
.73323 .5365 m
.73332 .53567 L
s
.39751 .78993 m
.39915 .79138 L
s
.43045 .81321 m
.43065 .81337 L
s
.4302 .813 m
.43045 .81321 L
s
.42996 .8128 m
.4302 .813 L
s
.73311 .53741 m
.73323 .5365 L
s
.42966 .81254 m
.42996 .8128 L
s
.42936 .81229 m
.42966 .81254 L
s
.42899 .81198 m
.42936 .81229 L
s
.73299 .5382 m
.73311 .53741 L
s
.39545 .78812 m
.39751 .78993 L
s
.42862 .81167 m
.42899 .81198 L
s
.42817 .81129 m
.42862 .81167 L
s
.73282 .53906 m
.73299 .5382 L
s
.42772 .81091 m
.42817 .81129 L
s
.42716 .81044 m
.42772 .81091 L
s
.73265 .53979 m
.73282 .53906 L
s
.42661 .80997 m
.42716 .81044 L
s
.39338 .7863 m
.39545 .78812 L
s
.73243 .54056 m
.73265 .53979 L
s
.42592 .80939 m
.42661 .80997 L
s
.65543 .46649 m
.6596 .4657 L
s
.42523 .80881 m
.42592 .80939 L
s
.7322 .54122 m
.73243 .54056 L
s
.42438 .8081 m
.42523 .80881 L
s
.39078 .78401 m
.39338 .7863 L
s
.73191 .54189 m
.7322 .54122 L
s
.42353 .80738 m
.42438 .8081 L
s
.73161 .54243 m
.73191 .54189 L
s
.60078 .47729 m
.60591 .45538 L
s
.42247 .80649 m
.42353 .80738 L
s
.73123 .54297 m
.73161 .54243 L
s
.38817 .78171 m
.39078 .78401 L
s
.42142 .8056 m
.42247 .80649 L
s
.73084 .54337 m
.73123 .54297 L
s
.4201 .8045 m
.42142 .8056 L
s
.73035 .54373 m
.73084 .54337 L
s
.41879 .80339 m
.4201 .8045 L
s
.38487 .77879 m
.38817 .78171 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.4509 .8252 m
.4509 .8252 L
s
.45089 .82519 m
.4509 .8252 L
s
.45089 .82519 m
.45089 .82519 L
s
.45089 .82519 m
.45089 .82519 L
s
.45089 .82519 m
.45089 .82519 L
s
.45089 .82519 m
.45089 .82519 L
s
.45089 .82519 m
.45089 .82519 L
s
.45089 .82519 m
.45089 .82519 L
s
.45089 .82519 m
.45089 .82519 L
s
.45088 .82519 m
.45089 .82519 L
s
.45088 .82519 m
.45088 .82519 L
s
.45088 .82518 m
.45088 .82519 L
s
.45088 .82518 m
.45088 .82518 L
s
.45088 .82518 m
.45088 .82518 L
s
.45087 .82518 m
.45088 .82518 L
s
.45087 .82518 m
.45087 .82518 L
s
.45087 .82517 m
.45087 .82518 L
s
.45086 .82517 m
.45087 .82517 L
s
.45086 .82517 m
.45086 .82517 L
s
.45086 .82516 m
.45086 .82517 L
s
.45085 .82516 m
.45086 .82516 L
s
.45085 .82516 m
.45085 .82516 L
s
.45084 .82515 m
.45085 .82516 L
s
.45084 .82515 m
.45084 .82515 L
s
.45083 .82514 m
.45084 .82515 L
s
.45082 .82514 m
.45083 .82514 L
s
.45081 .82513 m
.45082 .82514 L
s
.4508 .82512 m
.45081 .82513 L
s
.45079 .82511 m
.4508 .82512 L
s
.45078 .82511 m
.45079 .82511 L
s
.72986 .54396 m
.73035 .54373 L
s
.45077 .8251 m
.45078 .82511 L
s
.45076 .82509 m
.45077 .8251 L
s
.45074 .82507 m
.45076 .82509 L
s
.45073 .82506 m
.45074 .82507 L
s
.45071 .82505 m
.45073 .82506 L
s
.45069 .82503 m
.45071 .82505 L
s
.45067 .82502 m
.45069 .82503 L
s
.45065 .825 m
.45067 .82502 L
s
.45063 .82498 m
.45065 .825 L
s
.4506 .82496 m
.45063 .82498 L
s
.45057 .82493 m
.4506 .82496 L
s
.45054 .82491 m
.45057 .82493 L
s
.4505 .82487 m
.45054 .82491 L
s
.45046 .82484 m
.4505 .82487 L
s
.45041 .8248 m
.45046 .82484 L
s
.45036 .82477 m
.45041 .8248 L
s
.45031 .82472 m
.45036 .82477 L
s
.45025 .82467 m
.45031 .82472 L
s
.41715 .80202 m
.41879 .80339 L
s
.45018 .82462 m
.45025 .82467 L
s
.4501 .82456 m
.45018 .82462 L
s
.45002 .82449 m
.4501 .82456 L
s
.44993 .82442 m
.45002 .82449 L
s
.44982 .82433 m
.44993 .82442 L
s
.44971 .82424 m
.44982 .82433 L
s
.44958 .82414 m
.44971 .82424 L
s
.72923 .5441 m
.72986 .54396 L
s
.44945 .82403 m
.44958 .82414 L
s
.44929 .8239 m
.44945 .82403 L
s
.44912 .82377 m
.44929 .8239 L
s
.44893 .82361 m
.44912 .82377 L
s
.65116 .46599 m
.65543 .46649 L
s
.44873 .82345 m
.44893 .82361 L
s
.44848 .82325 m
.44873 .82345 L
s
.41551 .80064 m
.41715 .80202 L
s
.44824 .82306 m
.44848 .82325 L
s
.38155 .77587 m
.38487 .77879 L
s
.7286 .5441 m
.72923 .5441 L
s
.44794 .82282 m
.44824 .82306 L
s
.44764 .82258 m
.44794 .82282 L
s
.44728 .82228 m
.44764 .82258 L
s
.44691 .82199 m
.44728 .82228 L
s
.41345 .79891 m
.41551 .80064 L
s
.7278 .54396 m
.7286 .5441 L
s
.44646 .82162 m
.44691 .82199 L
s
.44601 .82126 m
.44646 .82162 L
s
.44545 .82081 m
.44601 .82126 L
s
.67814 .62002 m
.67833 .62064 L
s
.67795 .61944 m
.67814 .62002 L
s
.67772 .61878 m
.67795 .61944 L
s
.67833 .62064 m
.67849 .62117 L
s
.6775 .61816 m
.67772 .61878 L
s
.67849 .62117 m
.67864 .62175 L
s
.67722 .61744 m
.6775 .61816 L
s
.67864 .62175 m
.67878 .62226 L
s
.67878 .62226 m
.67891 .62281 L
s
.67695 .61676 m
.67722 .61744 L
s
.67891 .62281 m
.67902 .6233 L
s
.67661 .61597 m
.67695 .61676 L
s
.67902 .6233 m
.67913 .62382 L
s
.72699 .54368 m
.7278 .54396 L
s
.67913 .62382 m
.67923 .62428 L
s
.67628 .61521 m
.67661 .61597 L
s
.44489 .82037 m
.44545 .82081 L
s
.37732 .77214 m
.38155 .77587 L
s
.67923 .62428 m
.67932 .62479 L
s
.67587 .61432 m
.67628 .61521 L
s
.67932 .62479 m
.6794 .62523 L
s
.6794 .62523 m
.67948 .62571 L
s
.41138 .79718 m
.41345 .79891 L
s
.67547 .61347 m
.67587 .61432 L
s
.67948 .62571 m
.67955 .62613 L
s
.44421 .81982 m
.44489 .82037 L
s
.67955 .62613 m
.67962 .62659 L
s
.67497 .61245 m
.67547 .61347 L
s
.67962 .62659 m
.67968 .62699 L
s
.67968 .62699 m
.67974 .62743 L
s
.67447 .61147 m
.67497 .61245 L
s
.67974 .62743 m
.67979 .62781 L
s
.67979 .62781 m
.67984 .62823 L
s
.44352 .81927 m
.44421 .81982 L
s
.67984 .62823 m
.67988 .62861 L
s
.67386 .6103 m
.67447 .61147 L
s
.72598 .54318 m
.72699 .54368 L
s
.67988 .62861 m
.67993 .62901 L
s
.67993 .62901 m
.67997 .62937 L
s
.67326 .60915 m
.67386 .6103 L
s
.67997 .62937 m
.68001 .62976 L
s
.68001 .62976 m
.68004 .63011 L
s
.44267 .81859 m
.44352 .81927 L
s
.68004 .63011 m
.68008 .63048 L
s
.6725 .60777 m
.67326 .60915 L
s
.68008 .63048 m
.68011 .63082 L
s
.68011 .63082 m
.68014 .63118 L
s
.40879 .795 m
.41138 .79718 L
s
.68014 .63118 m
.68017 .6315 L
s
.68017 .6315 m
.6802 .63185 L
s
.67175 .60641 m
.6725 .60777 L
s
.6802 .63185 m
.68022 .63216 L
s
.44182 .8179 m
.44267 .81859 L
s
.68022 .63216 m
.68025 .6325 L
s
.68025 .6325 m
.68027 .6328 L
s
.72495 .54255 m
.72598 .54318 L
s
.68027 .6328 m
.6803 .63312 L
s
.67083 .60474 m
.67175 .60641 L
s
.6803 .63312 m
.68032 .6334 L
s
.68032 .6334 m
.68034 .63371 L
s
.68034 .63371 m
.68036 .63399 L
s
.44077 .81706 m
.44182 .8179 L
s
.68036 .63399 m
.68038 .63428 L
s
.68038 .63428 m
.6804 .63454 L
s
.6804 .63454 m
.68041 .63482 L
s
.6699 .60309 m
.67083 .60474 L
s
.37306 .7684 m
.37732 .77214 L
s
.64565 .46402 m
.65116 .46599 L
s
.68041 .63482 m
.68043 .63508 L
s
.68043 .63508 m
.68045 .63534 L
s
.68045 .63534 m
.68046 .63558 L
s
.68046 .63558 m
.68048 .63584 L
s
.68048 .63584 m
.68049 .63607 L
s
.68049 .63607 m
.68051 .63631 L
s
.72367 .54162 m
.72495 .54255 L
s
.43972 .81622 m
.44077 .81706 L
s
.66875 .60105 m
.6699 .60309 L
s
.68051 .63631 m
.68052 .63652 L
s
.40618 .79281 m
.40879 .795 L
s
.68052 .63652 m
.68053 .63675 L
s
.68053 .63675 m
.68054 .63696 L
s
.68054 .63696 m
.68056 .63718 L
s
.68056 .63718 m
.68057 .63737 L
s
.68057 .63737 m
.68058 .63757 L
s
.68058 .63757 m
.68059 .63776 L
s
.68059 .63776 m
.6806 .63795 L
s
.6806 .63795 m
.68061 .63812 L
s
.66759 .59902 m
.66875 .60105 L
s
.68061 .63812 m
.68062 .63831 L
s
.68062 .63831 m
.68063 .63847 L
s
.43841 .81517 m
.43972 .81622 L
s
.68063 .63847 m
.68064 .63864 L
s
.68064 .63864 m
.68065 .63879 L
s
.68065 .63879 m
.68065 .63895 L
s
.68065 .63895 m
.68066 .63909 L
s
.68066 .63909 m
.68067 .63925 L
s
.68067 .63925 m
.68068 .63938 L
s
.68068 .63938 m
.68068 .63952 L
s
.68068 .63952 m
.68069 .63965 L
s
.68069 .63965 m
.6807 .63978 L
s
.6807 .63978 m
.6807 .63989 L
s
.6807 .63989 m
.68071 .64002 L
s
.66616 .59647 m
.66759 .59902 L
s
.68071 .64002 m
.68072 .64013 L
s
.68072 .64013 m
.68072 .64024 L
s
.72237 .54054 m
.72367 .54162 L
s
.68072 .64024 m
.68073 .64034 L
s
.68073 .64034 m
.68073 .64045 L
s
.68073 .64045 m
.68074 .64054 L
s
.68074 .64054 m
.68074 .64064 L
s
.68074 .64064 m
.68075 .64073 L
s
.68075 .64073 m
.68075 .64083 L
s
.68075 .64083 m
.68076 .64091 L
s
.68076 .64091 m
.68076 .64099 L
s
.68076 .64099 m
.68076 .64107 L
s
.68076 .64107 m
.68077 .64115 L
s
.43709 .81412 m
.43841 .81517 L
s
.68077 .64115 m
.68077 .64122 L
s
.68077 .64122 m
.68077 .64129 L
s
.68077 .64129 m
.68078 .64136 L
s
.68078 .64136 m
.68078 .64143 L
s
.68078 .64143 m
.68078 .64149 L
s
.68078 .64149 m
.68079 .64155 L
s
.68079 .64155 m
.68079 .64161 L
s
.68079 .64161 m
.68079 .64167 L
s
.68079 .64167 m
.6808 .64172 L
s
.40287 .79005 m
.40618 .79281 L
s
.6808 .64172 m
.6808 .64177 L
s
.6808 .64177 m
.6808 .64182 L
s
.6808 .64182 m
.6808 .64187 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83549 m
.46948 .83549 L
s
.46948 .83548 m
.46948 .83549 L
s
.46948 .83548 m
.46948 .83548 L
s
.46948 .83548 m
.46948 .83548 L
s
.46948 .83548 m
.46948 .83548 L
s
.46948 .83548 m
.46948 .83548 L
s
.46948 .83548 m
.46948 .83548 L
s
.46948 .83548 m
.46948 .83548 L
s
.46948 .83548 m
.46948 .83548 L
s
.46948 .83548 m
.46948 .83548 L
s
.46948 .83548 m
.46948 .83548 L
s
.46948 .83548 m
.46948 .83548 L
s
.46947 .83548 m
.46948 .83548 L
s
.46947 .83548 m
.46947 .83548 L
s
.46947 .83548 m
.46947 .83548 L
s
.46947 .83548 m
.46947 .83548 L
s
.46947 .83548 m
.46947 .83548 L
s
.46947 .83548 m
.46947 .83548 L
s
.46947 .83547 m
.46947 .83548 L
s
.46947 .83547 m
.46947 .83547 L
s
.46946 .83547 m
.46947 .83547 L
s
.46946 .83547 m
.46946 .83547 L
s
.6808 .64187 m
.68081 .64192 L
s
.46946 .83547 m
.46946 .83547 L
s
.46946 .83547 m
.46946 .83547 L
s
.46946 .83547 m
.46946 .83547 L
s
.46945 .83546 m
.46946 .83547 L
s
.46945 .83546 m
.46945 .83546 L
s
.46945 .83546 m
.46945 .83546 L
s
.46944 .83545 m
.46945 .83546 L
s
.46944 .83545 m
.46944 .83545 L
s
.68081 .64192 m
.68081 .64196 L
s
.46943 .83545 m
.46944 .83545 L
s
.46943 .83544 m
.46943 .83545 L
s
.46942 .83544 m
.46943 .83544 L
s
.46942 .83544 m
.46942 .83544 L
s
.68081 .64196 m
.68081 .642 L
s
.46941 .83543 m
.46942 .83544 L
s
.4694 .83543 m
.46941 .83543 L
s
.46939 .83542 m
.4694 .83543 L
s
.68081 .642 m
.68081 .64205 L
s
.46939 .83541 m
.46939 .83542 L
s
.46938 .8354 m
.46939 .83541 L
s
.68081 .64205 m
.68081 .64208 L
s
.46937 .8354 m
.46938 .8354 L
s
.46935 .83539 m
.46937 .8354 L
s
.68081 .64208 m
.68082 .64212 L
s
.46934 .83538 m
.46935 .83539 L
s
.68082 .64212 m
.68082 .64216 L
s
.46933 .83537 m
.46934 .83538 L
s
.46931 .83536 m
.46933 .83537 L
s
.68082 .64216 m
.68082 .6422 L
s
.46929 .83534 m
.46931 .83536 L
s
.68082 .6422 m
.68082 .64223 L
s
.46928 .83533 m
.46929 .83534 L
s
.68082 .64223 m
.68082 .64226 L
s
.68082 .64226 m
.68082 .64229 L
s
.46925 .83531 m
.46928 .83533 L
s
.66472 .59391 m
.66616 .59647 L
s
.68082 .64229 m
.68083 .64232 L
s
.46923 .83529 m
.46925 .83531 L
s
.68083 .64232 m
.68083 .64235 L
s
.68083 .64235 m
.68083 .64238 L
s
.46921 .83527 m
.46923 .83529 L
s
.68083 .64238 m
.68083 .6424 L
s
.68083 .6424 m
.68083 .64243 L
s
.46918 .83525 m
.46921 .83527 L
s
.68083 .64243 m
.68083 .64245 L
s
.68083 .64245 m
.68083 .64248 L
s
.46915 .83523 m
.46918 .83525 L
s
.68083 .64248 m
.68083 .6425 L
s
.68083 .6425 m
.68084 .64252 L
s
.68084 .64252 m
.68084 .64254 L
s
.46912 .83521 m
.46915 .83523 L
s
.68084 .64254 m
.68084 .64256 L
s
.68084 .64256 m
.68084 .64258 L
s
.68084 .64258 m
.68084 .6426 L
s
.68084 .6426 m
.68084 .64262 L
s
.46908 .83518 m
.46912 .83521 L
s
.68084 .64262 m
.68084 .64263 L
s
.68084 .64263 m
.68084 .64265 L
s
.68084 .64265 m
.68084 .64266 L
s
.68084 .64266 m
.68084 .64268 L
s
.68084 .64268 m
.68084 .64269 L
s
.46904 .83515 m
.46908 .83518 L
s
.68084 .64269 m
.68084 .64271 L
s
.68084 .64271 m
.68085 .64272 L
s
.68085 .64272 m
.68085 .64273 L
s
.68085 .64273 m
.68085 .64274 L
s
.68085 .64274 m
.68085 .64276 L
s
.68085 .64276 m
.68085 .64277 L
s
.46899 .83511 m
.46904 .83515 L
s
.68085 .64277 m
.68085 .64278 L
s
.68085 .64278 m
.68085 .64279 L
s
.68085 .64279 m
.68085 .6428 L
s
.68085 .6428 m
.68085 .64281 L
s
.68085 .64281 m
.68085 .64282 L
s
.68085 .64282 m
.68085 .64282 L
s
.68085 .64282 m
.68085 .64283 L
s
.68085 .64283 m
.68085 .64284 L
s
.68085 .64284 m
.68085 .64285 L
s
.68085 .64285 m
.68085 .64286 L
s
.68085 .64286 m
.68085 .64286 L
s
.46895 .83507 m
.46899 .83511 L
s
.68085 .64286 m
.68085 .64287 L
s
.68085 .64287 m
.68085 .64287 L
s
.36763 .76361 m
.37306 .7684 L
s
.68085 .64287 m
.68085 .64288 L
s
.68085 .64288 m
.68085 .64289 L
s
.68085 .64289 m
.68085 .64289 L
s
.68085 .64289 m
.68085 .6429 L
s
.68085 .6429 m
.68085 .6429 L
s
.68085 .6429 m
.68085 .64291 L
s
.68085 .64291 m
.68085 .64291 L
s
.68085 .64291 m
.68085 .64292 L
s
.68085 .64292 m
.68086 .64292 L
s
.68086 .64292 m
.68086 .64293 L
s
.68086 .64293 m
.68086 .64293 L
s
.68086 .64293 m
.68086 .64293 L
s
.68086 .64293 m
.68086 .64294 L
s
.68086 .64294 m
.68086 .64294 L
s
.68086 .64294 m
.68086 .64294 L
s
.68086 .64294 m
.68086 .64295 L
s
.68086 .64295 m
.68086 .64295 L
s
.68086 .64295 m
.68086 .64295 L
s
.68086 .64295 m
.68086 .64296 L
s
.68086 .64296 m
.68086 .64296 L
s
.68086 .64296 m
.68086 .64296 L
s
.46889 .83503 m
.46895 .83507 L
s
.68086 .64296 m
.68086 .64296 L
s
.68086 .64296 m
.68086 .64297 L
s
.68086 .64297 m
.68086 .64297 L
s
.68086 .64297 m
.68086 .64297 L
s
.68086 .64297 m
.68086 .64297 L
s
.68086 .64297 m
.68086 .64298 L
s
.68086 .64298 m
.68086 .64298 L
s
.68086 .64298 m
.68086 .64298 L
s
.68086 .64298 m
.68086 .64298 L
s
.68086 .64298 m
.68086 .64298 L
s
.68086 .64298 m
.68086 .64298 L
s
.68086 .64298 m
.68086 .64299 L
s
.68086 .64299 m
.68086 .64299 L
s
.68086 .64299 m
.68086 .64299 L
s
.68086 .64299 m
.68086 .64299 L
s
.68086 .64299 m
.68086 .64299 L
s
.68086 .64299 m
.68086 .64299 L
s
.68086 .64299 m
.68086 .64299 L
s
.68086 .64299 m
.68086 .643 L
s
.68086 .643 m
.68086 .643 L
s
.68086 .643 m
.68086 .643 L
s
.68086 .643 m
.68086 .643 L
s
.68086 .643 m
.68086 .643 L
s
.68086 .643 m
.68086 .643 L
s
.68086 .643 m
.68086 .643 L
s
.68086 .643 m
.68086 .643 L
s
.68086 .643 m
.68086 .643 L
s
.68086 .643 m
.68086 .643 L
s
.68086 .643 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64301 L
s
.68086 .64301 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.68086 .64302 m
.68086 .64302 L
s
.46883 .83499 m
.46889 .83503 L
s
.46876 .83493 m
.46883 .83499 L
s
.46869 .83488 m
.46876 .83493 L
s
.4686 .83481 m
.46869 .83488 L
s
.46851 .83474 m
.4686 .83481 L
s
.43546 .81281 m
.43709 .81412 L
s
.4684 .83466 m
.46851 .83474 L
s
.72073 .53905 m
.72237 .54054 L
s
.4683 .83458 m
.4684 .83466 L
s
.46817 .83448 m
.4683 .83458 L
s
.66291 .59066 m
.66472 .59391 L
s
.46803 .83437 m
.46817 .83448 L
s
.46787 .83425 m
.46803 .83437 L
s
.46771 .83413 m
.46787 .83425 L
s
.46751 .83398 m
.46771 .83413 L
s
.46731 .83382 m
.46751 .83398 L
s
.46707 .83364 m
.46731 .83382 L
s
.46683 .83345 m
.46707 .83364 L
s
.43382 .8115 m
.43546 .81281 L
s
.6611 .58736 m
.66291 .59066 L
s
.46653 .83322 m
.46683 .83345 L
s
.46623 .833 m
.46653 .83322 L
s
.39956 .78727 m
.40287 .79005 L
s
.46587 .83272 m
.46623 .833 L
s
.71908 .53742 m
.72073 .53905 L
s
.4655 .83244 m
.46587 .83272 L
s
.65882 .58311 m
.6611 .58736 L
s
.46505 .83209 m
.4655 .83244 L
s
.43176 .80986 m
.43382 .8115 L
s
.59377 .49996 m
.60078 .47729 L
s
.4646 .83175 m
.46505 .83209 L
s
.71342 .59652 m
.71408 .5986 L
s
.71277 .59452 m
.71342 .59652 L
s
.71408 .5986 m
.71462 .60038 L
s
.71197 .59215 m
.71277 .59452 L
s
.71462 .60038 m
.71516 .60224 L
s
.71118 .58987 m
.71197 .59215 L
s
.46405 .83132 m
.4646 .83175 L
s
.71516 .60224 m
.71561 .60382 L
s
.7102 .58716 m
.71118 .58987 L
s
.71561 .60382 m
.71606 .60549 L
s
.70923 .58454 m
.7102 .58716 L
s
.71606 .60549 m
.71643 .60692 L
s
.36216 .75879 m
.36763 .76361 L
s
.71643 .60692 m
.71681 .60843 L
s
.70803 .58139 m
.70923 .58454 L
s
.71699 .53522 m
.71908 .53742 L
s
.46349 .8309 m
.46405 .83132 L
s
.64004 .46093 m
.64565 .46402 L
s
.71681 .60843 m
.71712 .60973 L
s
.65653 .57874 m
.65882 .58311 L
s
.71712 .60973 m
.71743 .6111 L
s
.70684 .57833 m
.70803 .58139 L
s
.71743 .6111 m
.7177 .61228 L
s
.46281 .83038 m
.46349 .8309 L
s
.4297 .80822 m
.43176 .80986 L
s
.39533 .78374 m
.39956 .78727 L
s
.70536 .57463 m
.70684 .57833 L
s
.7177 .61228 m
.71796 .61354 L
s
.71796 .61354 m
.71818 .61462 L
s
.46213 .82986 m
.46281 .83038 L
s
.71818 .61462 m
.71841 .61577 L
s
.70388 .571 m
.70536 .57463 L
s
.71841 .61577 m
.71859 .61677 L
s
.65362 .57304 m
.65653 .57874 L
s
.71859 .61677 m
.71878 .61783 L
s
.70204 .56656 m
.70388 .571 L
s
.46128 .82921 m
.46213 .82986 L
s
.71878 .61783 m
.71894 .61875 L
s
.71894 .61875 m
.71911 .61974 L
s
.71911 .61974 m
.71924 .62059 L
s
.42711 .80616 m
.4297 .80822 L
s
.71488 .53288 m
.71699 .53522 L
s
.7002 .56218 m
.70204 .56656 L
s
.46043 .82857 m
.46128 .82921 L
s
.71924 .62059 m
.71938 .62151 L
s
.71938 .62151 m
.7195 .62231 L
s
.7195 .62231 m
.71962 .62316 L
s
.69789 .55675 m
.7002 .56218 L
s
.6507 .5671 m
.65362 .57304 L
s
.45938 .82777 m
.46043 .82857 L
s
.71962 .62316 m
.71972 .6239 L
s
.71972 .6239 m
.71983 .62469 L
s
.71983 .62469 m
.71992 .62538 L
s
.71992 .62538 m
.72001 .62611 L
s
.69557 .55136 m
.69789 .55675 L
s
.39108 .7802 m
.39533 .78374 L
s
.45833 .82697 m
.45938 .82777 L
s
.72001 .62611 m
.72008 .62675 L
s
.3552 .75265 m
.36216 .75879 L
s
.72008 .62675 m
.72016 .62744 L
s
.4245 .80409 m
.42711 .80616 L
s
.72016 .62744 m
.72023 .62805 L
s
.7122 .52978 m
.71488 .53288 L
s
.64697 .5592 m
.6507 .5671 L
s
.72023 .62805 m
.7203 .6287 L
s
.69265 .54459 m
.69557 .55136 L
s
.7203 .6287 m
.72036 .62927 L
s
.45702 .82598 m
.45833 .82697 L
s
.72036 .62927 m
.72042 .62988 L
s
.72042 .62988 m
.72048 .63043 L
s
.75887 .59371 m
.75893 .59389 L
s
.75882 .59354 m
.75887 .59371 L
s
.75875 .59333 m
.75882 .59354 L
s
.75893 .59389 m
.75898 .59404 L
s
.75898 .59404 m
.75902 .5942 L
s
.75868 .59314 m
.75875 .59333 L
s
.75902 .5942 m
.75906 .59433 L
s
.7586 .5929 m
.75868 .59314 L
s
.75906 .59433 m
.7591 .59447 L
s
.75852 .59267 m
.7586 .5929 L
s
.7591 .59447 m
.75913 .59459 L
s
.75913 .59459 m
.75916 .59471 L
s
.75842 .5924 m
.75852 .59267 L
s
.75916 .59471 m
.75919 .59481 L
s
.75919 .59481 m
.75922 .59492 L
s
.75832 .59214 m
.75842 .5924 L
s
.75922 .59492 m
.75924 .59502 L
s
.75924 .59502 m
.75927 .59512 L
s
.75819 .59182 m
.75832 .59214 L
s
.75927 .59512 m
.75929 .5952 L
s
.72048 .63043 m
.72053 .63101 L
s
.75929 .5952 m
.75931 .59529 L
s
.75931 .59529 m
.75932 .59537 L
s
.75807 .59152 m
.75819 .59182 L
s
.75932 .59537 m
.75934 .59545 L
s
.75934 .59545 m
.75935 .59552 L
s
.75793 .59116 m
.75807 .59152 L
s
.75935 .59552 m
.75937 .59559 L
s
.75937 .59559 m
.75938 .59565 L
s
.75938 .59565 m
.75939 .59572 L
s
.75939 .59572 m
.7594 .59578 L
s
.75778 .59081 m
.75793 .59116 L
s
.7594 .59578 m
.75941 .59584 L
s
.75941 .59584 m
.75942 .59589 L
s
.75942 .59589 m
.75943 .59594 L
s
.75943 .59594 m
.75944 .59599 L
s
.7576 .59039 m
.75778 .59081 L
s
.75944 .59599 m
.75945 .59604 L
s
.75945 .59604 m
.75945 .59609 L
s
.75945 .59609 m
.75946 .59613 L
s
.75946 .59613 m
.75947 .59617 L
s
.72053 .63101 m
.72058 .63153 L
s
.75947 .59617 m
.75947 .59622 L
s
.75947 .59622 m
.75948 .59625 L
s
.75743 .58998 m
.7576 .59039 L
s
.75948 .59625 m
.75948 .59629 L
s
.75948 .59629 m
.75949 .59632 L
s
.75949 .59632 m
.75949 .59636 L
s
.75949 .59636 m
.7595 .59639 L
s
.7595 .59639 m
.7595 .59642 L
s
.7595 .59642 m
.75951 .59645 L
s
.75951 .59645 m
.75951 .59648 L
s
.75951 .59648 m
.75951 .59651 L
s
.75721 .58948 m
.75743 .58998 L
s
.75951 .59651 m
.75952 .59653 L
s
.75952 .59653 m
.75952 .59656 L
s
.75952 .59656 m
.75952 .59658 L
s
.75952 .59658 m
.75952 .59661 L
s
.75952 .59661 m
.75953 .59663 L
s
.75953 .59663 m
.75953 .59665 L
s
.75953 .59665 m
.75953 .59667 L
s
.75953 .59667 m
.75953 .59669 L
s
.75953 .59669 m
.75953 .59671 L
s
.72058 .63153 m
.72063 .63209 L
s
.75953 .59671 m
.75954 .59673 L
s
.75954 .59673 m
.75954 .59674 L
s
.75954 .59674 m
.75954 .59676 L
s
.75954 .59676 m
.75954 .59678 L
s
.75699 .589 m
.75721 .58948 L
s
.75954 .59678 m
.75954 .59679 L
s
.75954 .59679 m
.75954 .59681 L
s
.75954 .59681 m
.75954 .59682 L
s
.75954 .59682 m
.75955 .59683 L
s
.75955 .59683 m
.75955 .59685 L
s
.75955 .59685 m
.75955 .59686 L
s
.75955 .59686 m
.75955 .59687 L
s
.75955 .59687 m
.75955 .59688 L
s
.75955 .59688 m
.75955 .59689 L
s
.75955 .59689 m
.75955 .5969 L
s
.75955 .5969 m
.75955 .59691 L
s
.75955 .59691 m
.75955 .59692 L
s
.75955 .59692 m
.75955 .59693 L
s
.75955 .59693 m
.75956 .59694 L
s
.75956 .59694 m
.75956 .59695 L
s
.75956 .59695 m
.75956 .59696 L
s
.75956 .59696 m
.75956 .59696 L
s
.75956 .59696 m
.75956 .59697 L
s
.75956 .59697 m
.75956 .59698 L
s
.75956 .59698 m
.75956 .59699 L
s
.75956 .59699 m
.75956 .59699 L
s
.75956 .59699 m
.75956 .597 L
s
.75956 .597 m
.75956 .597 L
s
.75956 .597 m
.75956 .59701 L
s
.75956 .59701 m
.75956 .59701 L
s
.75956 .59701 m
.75956 .59702 L
s
.75956 .59702 m
.75956 .59703 L
s
.75956 .59703 m
.75956 .59703 L
s
.75673 .58842 m
.75699 .589 L
s
.75956 .59703 m
.75956 .59703 L
s
.75956 .59703 m
.75956 .59704 L
s
.75956 .59704 m
.75956 .59704 L
s
.75956 .59704 m
.75956 .59705 L
s
.75956 .59705 m
.75956 .59705 L
s
.75956 .59705 m
.75957 .59706 L
s
.75957 .59706 m
.75957 .59706 L
s
.75957 .59706 m
.75957 .59706 L
s
.75957 .59706 m
.75957 .59707 L
s
.75957 .59707 m
.75957 .59707 L
s
.75957 .59707 m
.75957 .59707 L
s
.75957 .59707 m
.75957 .59707 L
s
.75957 .59707 m
.75957 .59708 L
s
.75957 .59708 m
.75957 .59708 L
s
.75957 .59708 m
.75957 .59708 L
s
.75957 .59708 m
.75957 .59708 L
s
.68973 .5378 m
.69265 .54459 L
s
.75957 .59708 m
.75957 .59709 L
s
.75957 .59709 m
.75957 .59709 L
s
.75957 .59709 m
.75957 .59709 L
s
.75957 .59709 m
.75957 .59709 L
s
.75957 .59709 m
.75957 .5971 L
s
.75957 .5971 m
.75957 .5971 L
s
.75957 .5971 m
.75957 .5971 L
s
.75957 .5971 m
.75957 .5971 L
s
.75957 .5971 m
.75957 .5971 L
s
.75957 .5971 m
.75957 .5971 L
s
.75957 .5971 m
.75957 .59711 L
s
.75957 .59711 m
.75957 .59711 L
s
.75957 .59711 m
.75957 .59711 L
s
.75957 .59711 m
.75957 .59711 L
s
.75957 .59711 m
.75957 .59711 L
s
.75957 .59711 m
.75957 .59711 L
s
.75957 .59711 m
.75957 .59711 L
s
.75957 .59711 m
.75957 .59711 L
s
.75957 .59711 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59712 L
s
.75957 .59712 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.75957 .59713 m
.75957 .59713 L
s
.45572 .82498 m
.45702 .82598 L
s
.75957 .59713 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.75957 .59714 m
.75957 .59714 L
s
.72063 .63209 m
.72068 .63259 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84589 m
.48838 .84589 L
s
.48838 .84588 m
.48838 .84589 L
s
.48838 .84588 m
.48838 .84588 L
s
.48838 .84588 m
.48838 .84588 L
s
.48838 .84588 m
.48838 .84588 L
s
.48837 .84588 m
.48838 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.75647 .58786 m
.75673 .58842 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48837 .84588 m
.48837 .84588 L
s
.48836 .84588 m
.48837 .84588 L
s
.48836 .84588 m
.48836 .84588 L
s
.48836 .84587 m
.48836 .84588 L
s
.48836 .84587 m
.48836 .84587 L
s
.48836 .84587 m
.48836 .84587 L
s
.48836 .84587 m
.48836 .84587 L
s
.48835 .84587 m
.48836 .84587 L
s
.48835 .84587 m
.48835 .84587 L
s
.48835 .84586 m
.48835 .84587 L
s
.48834 .84586 m
.48835 .84586 L
s
.48834 .84586 m
.48834 .84586 L
s
.48834 .84586 m
.48834 .84586 L
s
.48833 .84585 m
.48834 .84586 L
s
.48833 .84585 m
.48833 .84585 L
s
.48832 .84585 m
.48833 .84585 L
s
.48832 .84584 m
.48832 .84585 L
s
.48831 .84584 m
.48832 .84584 L
s
.48831 .84583 m
.48831 .84584 L
s
.4883 .84583 m
.48831 .84583 L
s
.48829 .84582 m
.4883 .84583 L
s
.48828 .84582 m
.48829 .84582 L
s
.48827 .84581 m
.48828 .84582 L
s
.48826 .8458 m
.48827 .84581 L
s
.48825 .84579 m
.48826 .8458 L
s
.48824 .84578 m
.48825 .84579 L
s
.48822 .84577 m
.48824 .84578 L
s
.72068 .63259 m
.72073 .63313 L
s
.48821 .84576 m
.48822 .84577 L
s
.75614 .58717 m
.75647 .58786 L
s
.48819 .84575 m
.48821 .84576 L
s
.48817 .84574 m
.48819 .84575 L
s
.48815 .84572 m
.48817 .84574 L
s
.48813 .8457 m
.48815 .84572 L
s
.4881 .84569 m
.48813 .8457 L
s
.48808 .84567 m
.4881 .84569 L
s
.48805 .84564 m
.48808 .84567 L
s
.64321 .55087 m
.64697 .5592 L
s
.48801 .84562 m
.48805 .84564 L
s
.75582 .5865 m
.75614 .58717 L
s
.48798 .84559 m
.48801 .84562 L
s
.72073 .63313 m
.72077 .63361 L
s
.48794 .84556 m
.48798 .84559 L
s
.48789 .84553 m
.48794 .84556 L
s
.4212 .80148 m
.4245 .80409 L
s
.48784 .8455 m
.48789 .84553 L
s
.48779 .84545 m
.48784 .8455 L
s
.75543 .58569 m
.75582 .5865 L
s
.72077 .63361 m
.72081 .63413 L
s
.48773 .84541 m
.48779 .84545 L
s
.48766 .84536 m
.48773 .84541 L
s
.48759 .84531 m
.48766 .84536 L
s
.4875 .84525 m
.48759 .84531 L
s
.72081 .63413 m
.72085 .6346 L
s
.75504 .58489 m
.75543 .58569 L
s
.48741 .84518 m
.4875 .84525 L
s
.4873 .8451 m
.48741 .84518 L
s
.72085 .6346 m
.72089 .6351 L
s
.75455 .58392 m
.75504 .58489 L
s
.4872 .84503 m
.4873 .8451 L
s
.45408 .82375 m
.45572 .82498 L
s
.48707 .84493 m
.4872 .84503 L
s
.72089 .6351 m
.72093 .63556 L
s
.68601 .52915 m
.68973 .5378 L
s
.63262 .45565 m
.64004 .46093 L
s
.70951 .52654 m
.7122 .52978 L
s
.48693 .84483 m
.48707 .84493 L
s
.38564 .77567 m
.39108 .7802 L
s
.75407 .58296 m
.75455 .58392 L
s
.72093 .63556 m
.72096 .63605 L
s
.48677 .84472 m
.48693 .84483 L
s
.48661 .8446 m
.48677 .84472 L
s
.72096 .63605 m
.721 .63649 L
s
.75348 .58179 m
.75407 .58296 L
s
.48642 .84446 m
.48661 .8446 L
s
.721 .63649 m
.72103 .63697 L
s
.48622 .84431 m
.48642 .84446 L
s
.72103 .63697 m
.72107 .6374 L
s
.6384 .53965 m
.64321 .55087 L
s
.75288 .58064 m
.75348 .58179 L
s
.48598 .84414 m
.48622 .84431 L
s
.72107 .6374 m
.7211 .63786 L
s
.48573 .84396 m
.48598 .84414 L
s
.7211 .63786 m
.72113 .63829 L
s
.75215 .57922 m
.75288 .58064 L
s
.72113 .63829 m
.72116 .63874 L
s
.48544 .84375 m
.48573 .84396 L
s
.45245 .82251 m
.45408 .82375 L
s
.72116 .63874 m
.72119 .63916 L
s
.68227 .52043 m
.68601 .52915 L
s
.48514 .84353 m
.48544 .84375 L
s
.72119 .63916 m
.72122 .63961 L
s
.75142 .57782 m
.75215 .57922 L
s
.72122 .63961 m
.72125 .64002 L
s
.48478 .84327 m
.48514 .84353 L
s
.72125 .64002 m
.72128 .64046 L
s
.41789 .79885 m
.4212 .80148 L
s
.72128 .64046 m
.72131 .64086 L
s
.48441 .843 m
.48478 .84327 L
s
.75052 .57611 m
.75142 .57782 L
s
.34817 .74646 m
.3552 .75265 L
s
.72131 .64086 m
.72134 .6413 L
s
.72134 .6413 m
.72137 .64169 L
s
.48396 .84268 m
.48441 .843 L
s
.72137 .64169 m
.7214 .64213 L
s
.63355 .5277 m
.6384 .53965 L
s
.7214 .64213 m
.72142 .64252 L
s
.74961 .5744 m
.75052 .57611 L
s
.4504 .82096 m
.45245 .82251 L
s
.70606 .52227 m
.70951 .52654 L
s
.48352 .84235 m
.48396 .84268 L
s
.72142 .64252 m
.72145 .64294 L
s
.67751 .50921 m
.68227 .52043 L
s
.72145 .64294 m
.72147 .64333 L
s
.48296 .84195 m
.48352 .84235 L
s
.72147 .64333 m
.7215 .64376 L
s
.74849 .57229 m
.74961 .5744 L
s
.7215 .64376 m
.72153 .64414 L
s
.72153 .64414 m
.72155 .64456 L
s
.48241 .84155 m
.48296 .84195 L
s
.72155 .64456 m
.72158 .64494 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59143 m
.77992 .59143 L
s
.77992 .59142 m
.77992 .59143 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77992 .59142 m
.77992 .59142 L
s
.77991 .59142 m
.77992 .59142 L
s
.77991 .59141 m
.77991 .59142 L
s
.77991 .59141 m
.77991 .59141 L
s
.77991 .59141 m
.77991 .59141 L
s
.77991 .59141 m
.77991 .59141 L
s
.77991 .59141 m
.77991 .59141 L
s
.77991 .59141 m
.77991 .59141 L
s
.77991 .5914 m
.77991 .59141 L
s
.7799 .5914 m
.77991 .5914 L
s
.7799 .5914 m
.7799 .5914 L
s
.7799 .5914 m
.7799 .5914 L
s
.7799 .59139 m
.7799 .5914 L
s
.77989 .59139 m
.7799 .59139 L
s
.77989 .59139 m
.77989 .59139 L
s
.77989 .59138 m
.77989 .59139 L
s
.72158 .64494 m
.72161 .64536 L
s
.77988 .59138 m
.77989 .59138 L
s
.77988 .59137 m
.77988 .59138 L
s
.77987 .59137 m
.77988 .59137 L
s
.77987 .59136 m
.77987 .59137 L
s
.77986 .59135 m
.77987 .59136 L
s
.77986 .59135 m
.77986 .59135 L
s
.77985 .59134 m
.77986 .59135 L
s
.77985 .59133 m
.77985 .59134 L
s
.77984 .59132 m
.77985 .59133 L
s
.77983 .59131 m
.77984 .59132 L
s
.77982 .59129 m
.77983 .59131 L
s
.77981 .59128 m
.77982 .59129 L
s
.7798 .59127 m
.77981 .59128 L
s
.77979 .59125 m
.7798 .59127 L
s
.77977 .59123 m
.77979 .59125 L
s
.77976 .59121 m
.77977 .59123 L
s
.77974 .59119 m
.77976 .59121 L
s
.77972 .59117 m
.77974 .59119 L
s
.72161 .64536 m
.72163 .64573 L
s
.7797 .59114 m
.77972 .59117 L
s
.77968 .59111 m
.7797 .59114 L
s
.77965 .59108 m
.77968 .59111 L
s
.74737 .5702 m
.74849 .57229 L
s
.77963 .59104 m
.77965 .59108 L
s
.7796 .591 m
.77963 .59104 L
s
.62737 .51159 m
.63355 .5277 L
s
.77956 .59096 m
.7796 .591 L
s
.72163 .64573 m
.72166 .64615 L
s
.77953 .59091 m
.77956 .59096 L
s
.48173 .84106 m
.48241 .84155 L
s
.77949 .59085 m
.77953 .59091 L
s
.77944 .59079 m
.77949 .59085 L
s
.77939 .59073 m
.77944 .59079 L
s
.72166 .64615 m
.72168 .64652 L
s
.77934 .59065 m
.77939 .59073 L
s
.38017 .77112 m
.38564 .77567 L
s
.77928 .59057 m
.77934 .59065 L
s
.7792 .59047 m
.77928 .59057 L
s
.44834 .81941 m
.4504 .82096 L
s
.72168 .64652 m
.72171 .64694 L
s
.77913 .59037 m
.7792 .59047 L
s
.77904 .59025 m
.77913 .59037 L
s
.72171 .64694 m
.72173 .64731 L
s
.77896 .59013 m
.77904 .59025 L
s
.41366 .79552 m
.41789 .79885 L
s
.77885 .58998 m
.77896 .59013 L
s
.48105 .84056 m
.48173 .84106 L
s
.72173 .64731 m
.72176 .64772 L
s
.67273 .49784 m
.67751 .50921 L
s
.74597 .56759 m
.74737 .5702 L
s
.77874 .58983 m
.77885 .58998 L
s
.72176 .64772 m
.72178 .64809 L
s
.77861 .58964 m
.77874 .58983 L
s
.77848 .58946 m
.77861 .58964 L
s
.72178 .64809 m
.7218 .6485 L
s
.77831 .58923 m
.77848 .58946 L
s
.7218 .6485 m
.72183 .64886 L
s
.4802 .83996 m
.48105 .84056 L
s
.77815 .589 m
.77831 .58923 L
s
.72183 .64886 m
.72185 .64927 L
s
.77795 .58872 m
.77815 .589 L
s
.72185 .64927 m
.72188 .64964 L
s
.62115 .49451 m
.62737 .51159 L
s
.77775 .58843 m
.77795 .58872 L
s
.72188 .64964 m
.7219 .65004 L
s
.74457 .56499 m
.74597 .56759 L
s
.7219 .65004 m
.72192 .6504 L
s
.77751 .58808 m
.77775 .58843 L
s
.72192 .6504 m
.72195 .65081 L
s
.70259 .51786 m
.70606 .52227 L
s
.47936 .83935 m
.4802 .83996 L
s
.77726 .58773 m
.77751 .58808 L
s
.72195 .65081 m
.72197 .65117 L
s
.44575 .81746 m
.44834 .81941 L
s
.72197 .65117 m
.722 .65157 L
s
.77696 .5873 m
.77726 .58773 L
s
.722 .65157 m
.72202 .65193 L
s
.66666 .48329 m
.67273 .49784 L
s
.77666 .58686 m
.77696 .5873 L
s
.72202 .65193 m
.72204 .65233 L
s
.74282 .56175 m
.74457 .56499 L
s
.61304 .47131 m
.62115 .49451 L
s
.72204 .65233 m
.72207 .65269 L
s
.47831 .83859 m
.47936 .83935 L
s
.77629 .58633 m
.77666 .58686 L
s
.72207 .65269 m
.72209 .65308 L
s
.72209 .65308 m
.72211 .65344 L
s
.77592 .58579 m
.77629 .58633 L
s
.72211 .65344 m
.72214 .65383 L
s
.72214 .65383 m
.72216 .65419 L
s
.33899 .73837 m
.34817 .74646 L
s
.72216 .65419 m
.72218 .65458 L
s
.77547 .58512 m
.77592 .58579 L
s
.72218 .65458 m
.72221 .65493 L
s
.6049 .44758 m
.61304 .47131 L
s
.47727 .83784 m
.47831 .83859 L
s
.72221 .65493 m
.72223 .65532 L
s
.74106 .5585 m
.74282 .56175 L
s
.77501 .58445 m
.77547 .58512 L
s
.72223 .65532 m
.72225 .65568 L
s
.72225 .65568 m
.72228 .65606 L
s
.40941 .79218 m
.41366 .79552 L
s
.72228 .65606 m
.7223 .65641 L
s
.44315 .81552 m
.44575 .81746 L
s
.77445 .58363 m
.77501 .58445 L
s
.7223 .65641 m
.72232 .6568 L
s
.59449 .41781 m
.6049 .44758 L
s
.72232 .6568 m
.72234 .65715 L
s
.3732 .76534 m
.38017 .77112 L
s
.47596 .8369 m
.47727 .83784 L
s
.62507 .44917 m
.63262 .45565 L
s
.72234 .65715 m
.72237 .65753 L
s
.66057 .46862 m
.66666 .48329 L
s
.72237 .65753 m
.72239 .65788 L
s
.77388 .58279 m
.77445 .58363 L
s
.72239 .65788 m
.72241 .65826 L
s
.73885 .55442 m
.74106 .5585 L
s
.72241 .65826 m
.72243 .6586 L
s
.72243 .6586 m
.72246 .65898 L
s
.69815 .51207 m
.70259 .51786 L
s
.77318 .58176 m
.77388 .58279 L
s
.72246 .65898 m
.72248 .65932 L
s
.72248 .65932 m
.7225 .65969 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85638 m
.50759 .85638 L
s
.50759 .85637 m
.50759 .85638 L
s
.50759 .85637 m
.50759 .85637 L
s
.50759 .85637 m
.50759 .85637 L
s
.50759 .85637 m
.50759 .85637 L
s
.50759 .85637 m
.50759 .85637 L
s
.50758 .85637 m
.50759 .85637 L
s
.50758 .85637 m
.50758 .85637 L
s
.50758 .85637 m
.50758 .85637 L
s
.50758 .85637 m
.50758 .85637 L
s
.50758 .85637 m
.50758 .85637 L
s
.50758 .85637 m
.50758 .85637 L
s
.50758 .85637 m
.50758 .85637 L
s
.50757 .85637 m
.50758 .85637 L
s
.50757 .85636 m
.50757 .85637 L
s
.50757 .85636 m
.50757 .85636 L
s
.50757 .85636 m
.50757 .85636 L
s
.50757 .85636 m
.50757 .85636 L
s
.50756 .85636 m
.50757 .85636 L
s
.50756 .85636 m
.50756 .85636 L
s
.50756 .85635 m
.50756 .85636 L
s
.50755 .85635 m
.50756 .85635 L
s
.50755 .85635 m
.50755 .85635 L
s
.50754 .85634 m
.50755 .85635 L
s
.50754 .85634 m
.50754 .85634 L
s
.50753 .85634 m
.50754 .85634 L
s
.50753 .85633 m
.50753 .85634 L
s
.50752 .85633 m
.50753 .85633 L
s
.50751 .85632 m
.50752 .85633 L
s
.50751 .85632 m
.50751 .85632 L
s
.5075 .85631 m
.50751 .85632 L
s
.50749 .85631 m
.5075 .85631 L
s
.50748 .8563 m
.50749 .85631 L
s
.7225 .65969 m
.72252 .66003 L
s
.50746 .85629 m
.50748 .8563 L
s
.50745 .85628 m
.50746 .85629 L
s
.50744 .85627 m
.50745 .85628 L
s
.58411 .39039 m
.59449 .41781 L
s
.50742 .85626 m
.50744 .85627 L
s
.47466 .83597 m
.47596 .8369 L
s
.50741 .85625 m
.50742 .85626 L
s
.50739 .85624 m
.50741 .85625 L
s
.50737 .85622 m
.50739 .85624 L
s
.50735 .85621 m
.50737 .85622 L
s
.50732 .85619 m
.50735 .85621 L
s
.72252 .66003 m
.72254 .66041 L
s
.50729 .85617 m
.50732 .85619 L
s
.50726 .85615 m
.50729 .85617 L
s
.50723 .85613 m
.50726 .85615 L
s
.50719 .8561 m
.50723 .85613 L
s
.50715 .85608 m
.50719 .8561 L
s
.72254 .66041 m
.72257 .66074 L
s
.77249 .58073 m
.77318 .58176 L
s
.50711 .85604 m
.50715 .85608 L
s
.50706 .85601 m
.50711 .85604 L
s
.507 .85597 m
.50706 .85601 L
s
.72257 .66074 m
.72259 .66111 L
s
.50695 .85593 m
.507 .85597 L
s
.50688 .85588 m
.50695 .85593 L
s
.50681 .85583 m
.50688 .85588 L
s
.72259 .66111 m
.72261 .66145 L
s
.50672 .85577 m
.50681 .85583 L
s
.50663 .85571 m
.50672 .85577 L
s
.72261 .66145 m
.72263 .66182 L
s
.50652 .85564 m
.50663 .85571 L
s
.73664 .55032 m
.73885 .55442 L
s
.43986 .81305 m
.44315 .81552 L
s
.72263 .66182 m
.72265 .66215 L
s
.50642 .85557 m
.50652 .85564 L
s
.77162 .57944 m
.77249 .58073 L
s
.50629 .85548 m
.50642 .85557 L
s
.72265 .66215 m
.72267 .66251 L
s
.50616 .85539 m
.50629 .85548 L
s
.72267 .66251 m
.72269 .66284 L
s
.65265 .44964 m
.66057 .46862 L
s
.47303 .8348 m
.47466 .83597 L
s
.506 .85528 m
.50616 .85539 L
s
.72269 .66284 m
.72272 .6632 L
s
.50584 .85517 m
.506 .85528 L
s
.72272 .6632 m
.72274 .66353 L
s
.50564 .85503 m
.50584 .85517 L
s
.72274 .66353 m
.72276 .66389 L
s
.50544 .8549 m
.50564 .85503 L
s
.72276 .66389 m
.72278 .66421 L
s
.77075 .57814 m
.77162 .57944 L
s
.72278 .66421 m
.7228 .66457 L
s
.5052 .85473 m
.50544 .8549 L
s
.40398 .78792 m
.40941 .79218 L
s
.7228 .66457 m
.72282 .66489 L
s
.50496 .85456 m
.5052 .85473 L
s
.72282 .66489 m
.72284 .66524 L
s
.72284 .66524 m
.72286 .66556 L
s
.50467 .85436 m
.50496 .85456 L
s
.73384 .54513 m
.73664 .55032 L
s
.72286 .66556 m
.72288 .66591 L
s
.57375 .36677 m
.58411 .39039 L
s
.76968 .57653 m
.77075 .57814 L
s
.72288 .66591 m
.7229 .66622 L
s
.58643 .51791 m
.59377 .49996 L
s
.50437 .85416 m
.50467 .85436 L
s
.4714 .83364 m
.47303 .8348 L
s
.7229 .66622 m
.72292 .66657 L
s
.72292 .66657 m
.72294 .66688 L
s
.50401 .85391 m
.50437 .85416 L
s
.72294 .66688 m
.72297 .66723 L
s
.72297 .66723 m
.72298 .66754 L
s
.50365 .85366 m
.50401 .85391 L
s
.72298 .66754 m
.72301 .66787 L
s
.72301 .66787 m
.72302 .66818 L
s
.72302 .66818 m
.72305 .66852 L
s
.7686 .57491 m
.76968 .57653 L
s
.5032 .85335 m
.50365 .85366 L
s
.72305 .66852 m
.72306 .66882 L
s
.43655 .81059 m
.43986 .81305 L
s
.72306 .66882 m
.72308 .66915 L
s
.69367 .5061 m
.69815 .51207 L
s
.72308 .66915 m
.7231 .66945 L
s
.50275 .85305 m
.5032 .85335 L
s
.7231 .66945 m
.72312 .66978 L
s
.46936 .83218 m
.4714 .83364 L
s
.64471 .43101 m
.65265 .44964 L
s
.72312 .66978 m
.72314 .67008 L
s
.72314 .67008 m
.72316 .67041 L
s
.73102 .5399 m
.73384 .54513 L
s
.5022 .85267 m
.50275 .85305 L
s
.72316 .67041 m
.72318 .6707 L
s
.36616 .75953 m
.3732 .76534 L
s
.76725 .57288 m
.7686 .57491 L
s
.72318 .6707 m
.7232 .67102 L
s
.7232 .67102 m
.72322 .67131 L
s
.3297 .73019 m
.33899 .73837 L
s
.72322 .67131 m
.72324 .67163 L
s
.50165 .85229 m
.5022 .85267 L
s
.72324 .67163 m
.72326 .67192 L
s
.72326 .67192 m
.72327 .67224 L
s
.72327 .67224 m
.72329 .67252 L
s
.72329 .67252 m
.72331 .67283 L
s
.72331 .67283 m
.72333 .67312 L
s
.50098 .85183 m
.50165 .85229 L
s
.72333 .67312 m
.72335 .67342 L
s
.72335 .67342 m
.72337 .6737 L
s
.7659 .57084 m
.76725 .57288 L
s
.72337 .6737 m
.72338 .67401 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60194 m
.80187 .60194 L
s
.80187 .60193 m
.80187 .60194 L
s
.80187 .60193 m
.80187 .60193 L
s
.80187 .60193 m
.80187 .60193 L
s
.80187 .60193 m
.80187 .60193 L
s
.80187 .60193 m
.80187 .60193 L
s
.80187 .60193 m
.80187 .60193 L
s
.80186 .60193 m
.80187 .60193 L
s
.80186 .60193 m
.80186 .60193 L
s
.80186 .60193 m
.80186 .60193 L
s
.80186 .60192 m
.80186 .60193 L
s
.80186 .60192 m
.80186 .60192 L
s
.80186 .60192 m
.80186 .60192 L
s
.80186 .60192 m
.80186 .60192 L
s
.80186 .60191 m
.80186 .60192 L
s
.80185 .60191 m
.80186 .60191 L
s
.80185 .60191 m
.80185 .60191 L
s
.80185 .6019 m
.80185 .60191 L
s
.80185 .6019 m
.80185 .6019 L
s
.80184 .6019 m
.80185 .6019 L
s
.80184 .60189 m
.80184 .6019 L
s
.80184 .60189 m
.80184 .60189 L
s
.80184 .60188 m
.80184 .60189 L
s
.80183 .60187 m
.80184 .60188 L
s
.80183 .60187 m
.80183 .60187 L
s
.80182 .60186 m
.80183 .60187 L
s
.80182 .60185 m
.80182 .60186 L
s
.80181 .60184 m
.80182 .60185 L
s
.72338 .67401 m
.7234 .67428 L
s
.80181 .60183 m
.80181 .60184 L
s
.8018 .60182 m
.80181 .60183 L
s
.80179 .60181 m
.8018 .60182 L
s
.80178 .6018 m
.80179 .60181 L
s
.80178 .60178 m
.80178 .6018 L
s
.80177 .60177 m
.80178 .60178 L
s
.80176 .60175 m
.80177 .60177 L
s
.80174 .60173 m
.80176 .60175 L
s
.80173 .60171 m
.80174 .60173 L
s
.80172 .60169 m
.80173 .60171 L
s
.46731 .83072 m
.46936 .83218 L
s
.8017 .60166 m
.80172 .60169 L
s
.80168 .60163 m
.8017 .60166 L
s
.7234 .67428 m
.72342 .67458 L
s
.80167 .6016 m
.80168 .60163 L
s
.80164 .60157 m
.80167 .6016 L
s
.80162 .60153 m
.80164 .60157 L
s
.5003 .85137 m
.50098 .85183 L
s
.8016 .60149 m
.80162 .60153 L
s
.80157 .60145 m
.8016 .60149 L
s
.80154 .6014 m
.80157 .60145 L
s
.72342 .67458 m
.72344 .67486 L
s
.80151 .60134 m
.80154 .6014 L
s
.80147 .60128 m
.80151 .60134 L
s
.80143 .60122 m
.80147 .60128 L
s
.72744 .53323 m
.73102 .5399 L
s
.80138 .60114 m
.80143 .60122 L
s
.72344 .67486 m
.72346 .67516 L
s
.80133 .60106 m
.80138 .60114 L
s
.80127 .60097 m
.80133 .60106 L
s
.72346 .67516 m
.72347 .67542 L
s
.80121 .60087 m
.80127 .60097 L
s
.80114 .60075 m
.80121 .60087 L
s
.39851 .78365 m
.40398 .78792 L
s
.72347 .67542 m
.72349 .67572 L
s
.80107 .60063 m
.80114 .60075 L
s
.80098 .60049 m
.80107 .60063 L
s
.43233 .80746 m
.43655 .81059 L
s
.72349 .67572 m
.72351 .67598 L
s
.80089 .60035 m
.80098 .60049 L
s
.56462 .35006 m
.57375 .36677 L
s
.49946 .85079 m
.5003 .85137 L
s
.80078 .60017 m
.80089 .60035 L
s
.72351 .67598 m
.72352 .67628 L
s
.80067 .59999 m
.80078 .60017 L
s
.72352 .67628 m
.72354 .67654 L
s
.80054 .59978 m
.80067 .59999 L
s
.72354 .67654 m
.72356 .67683 L
s
.76421 .56828 m
.7659 .57084 L
s
.8004 .59956 m
.80054 .59978 L
s
.72356 .67683 m
.72357 .67709 L
s
.80024 .5993 m
.8004 .59956 L
s
.72357 .67709 m
.72359 .67737 L
s
.80007 .59903 m
.80024 .5993 L
s
.72359 .67737 m
.72361 .67763 L
s
.63454 .40817 m
.64471 .43101 L
s
.61522 .43933 m
.62507 .44917 L
s
.72361 .67763 m
.72362 .67791 L
s
.79987 .59871 m
.80007 .59903 L
s
.49862 .85022 m
.49946 .85079 L
s
.72362 .67791 m
.72364 .67816 L
s
.79967 .59838 m
.79987 .59871 L
s
.72364 .67816 m
.72366 .67844 L
s
.72366 .67844 m
.72367 .67869 L
s
.79942 .59799 m
.79967 .59838 L
s
.46473 .8289 m
.46731 .83072 L
s
.72367 .67869 m
.72369 .67896 L
s
.72369 .67896 m
.72371 .67921 L
s
.79918 .59759 m
.79942 .59799 L
s
.72371 .67921 m
.72372 .67948 L
s
.68795 .49832 m
.69367 .5061 L
s
.72372 .67948 m
.72374 .67972 L
s
.79887 .5971 m
.79918 .59759 L
s
.49757 .84951 m
.49862 .85022 L
s
.72374 .67972 m
.72375 .67999 L
s
.72375 .67999 m
.72377 .68023 L
s
.72377 .68023 m
.72378 .68049 L
s
.79857 .59661 m
.79887 .5971 L
s
.76251 .5657 m
.76421 .56828 L
s
.72378 .68049 m
.7238 .68073 L
s
.7238 .68073 m
.72382 .68099 L
s
.72385 .52651 m
.72744 .53323 L
s
.7982 .59601 m
.79857 .59661 L
s
.72382 .68099 m
.72383 .68123 L
s
.72383 .68123 m
.72385 .68148 L
s
.72385 .68148 m
.72386 .68172 L
s
.72386 .68172 m
.72388 .68197 L
s
.79783 .59541 m
.7982 .59601 L
s
.72388 .68197 m
.72389 .6822 L
s
.49653 .8488 m
.49757 .84951 L
s
.72389 .6822 m
.72391 .68245 L
s
.72391 .68245 m
.72392 .68267 L
s
.79737 .59468 m
.79783 .59541 L
s
.72392 .68267 m
.72393 .68292 L
s
.72393 .68292 m
.72395 .68314 L
s
.72395 .68314 m
.72396 .68339 L
s
.72396 .68339 m
.72398 .68361 L
s
.79691 .59394 m
.79737 .59468 L
s
.72398 .68361 m
.72399 .68385 L
s
.72399 .68385 m
.72401 .68407 L
s
.76037 .56244 m
.76251 .5657 L
s
.72401 .68407 m
.72402 .6843 L
s
.35696 .75194 m
.36616 .75953 L
s
.72402 .6843 m
.72403 .68452 L
s
.46214 .82707 m
.46473 .8289 L
s
.49523 .84792 m
.49653 .8488 L
s
.79634 .59303 m
.79691 .59394 L
s
.42809 .80433 m
.43233 .80746 L
s
.72403 .68452 m
.72405 .68475 L
s
.72405 .68475 m
.72406 .68496 L
s
.72406 .68496 m
.72408 .6852 L
s
.72408 .6852 m
.72409 .6854 L
s
.72409 .6854 m
.7241 .68563 L
s
.7241 .68563 m
.72411 .68584 L
s
.79577 .59211 m
.79634 .59303 L
s
.72411 .68584 m
.72413 .68606 L
s
.72413 .68606 m
.72414 .68627 L
s
.72414 .68627 m
.72415 .68649 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52714 .86694 m
.52714 .86694 L
s
.52713 .86694 m
.52714 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86694 m
.52713 .86694 L
s
.52713 .86693 m
.52713 .86694 L
s
.52713 .86693 m
.52713 .86693 L
s
.52713 .86693 m
.52713 .86693 L
s
.52713 .86693 m
.52713 .86693 L
s
.52713 .86693 m
.52713 .86693 L
s
.52713 .86693 m
.52713 .86693 L
s
.52713 .86693 m
.52713 .86693 L
s
.52712 .86693 m
.52713 .86693 L
s
.52712 .86693 m
.52712 .86693 L
s
.52712 .86693 m
.52712 .86693 L
s
.52712 .86693 m
.52712 .86693 L
s
.52712 .86693 m
.52712 .86693 L
s
.52712 .86693 m
.52712 .86693 L
s
.52712 .86693 m
.52712 .86693 L
s
.52711 .86692 m
.52712 .86693 L
s
.52711 .86692 m
.52711 .86692 L
s
.52711 .86692 m
.52711 .86692 L
s
.52711 .86692 m
.52711 .86692 L
s
.5271 .86692 m
.52711 .86692 L
s
.5271 .86691 m
.5271 .86692 L
s
.5271 .86691 m
.5271 .86691 L
s
.39154 .77824 m
.39851 .78365 L
s
.52709 .86691 m
.5271 .86691 L
s
.72415 .68649 m
.72417 .68669 L
s
.52709 .86691 m
.52709 .86691 L
s
.52708 .8669 m
.52709 .86691 L
s
.52708 .8669 m
.52708 .8669 L
s
.52707 .8669 m
.52708 .8669 L
s
.52706 .86689 m
.52707 .8669 L
s
.52706 .86689 m
.52706 .86689 L
s
.52705 .86688 m
.52706 .86689 L
s
.52704 .86688 m
.52705 .86688 L
s
.52703 .86687 m
.52704 .86688 L
s
.52702 .86686 m
.52703 .86687 L
s
.52701 .86686 m
.52702 .86686 L
s
.72417 .68669 m
.72418 .68691 L
s
.527 .86685 m
.52701 .86686 L
s
.71925 .5179 m
.72385 .52651 L
s
.52698 .86684 m
.527 .86685 L
s
.52697 .86683 m
.52698 .86684 L
s
.52695 .86682 m
.52697 .86683 L
s
.52693 .86681 m
.52695 .86682 L
s
.52691 .86679 m
.52693 .86681 L
s
.72418 .68691 m
.72419 .68711 L
s
.79507 .59099 m
.79577 .59211 L
s
.52689 .86678 m
.52691 .86679 L
s
.52686 .86676 m
.52689 .86678 L
s
.52684 .86674 m
.52686 .86676 L
s
.52681 .86672 m
.52684 .86674 L
s
.72419 .68711 m
.72421 .68732 L
s
.52678 .8667 m
.52681 .86672 L
s
.52674 .86668 m
.52678 .8667 L
s
.5267 .86665 m
.52674 .86668 L
s
.72421 .68732 m
.72422 .68752 L
s
.49394 .84704 m
.49523 .84792 L
s
.52665 .86662 m
.5267 .86665 L
s
.72422 .68752 m
.72423 .68773 L
s
.52661 .86659 m
.52665 .86662 L
s
.52655 .86656 m
.52661 .86659 L
s
.72423 .68773 m
.72424 .68792 L
s
.52649 .86652 m
.52655 .86656 L
s
.52642 .86647 m
.52649 .86652 L
s
.72424 .68792 m
.72426 .68814 L
s
.52635 .86643 m
.52642 .86647 L
s
.72426 .68814 m
.72427 .68833 L
s
.52627 .86637 m
.52635 .86643 L
s
.72427 .68833 m
.72428 .68853 L
s
.31767 .71959 m
.3297 .73019 L
s
.79437 .58986 m
.79507 .59099 L
s
.52618 .86631 m
.52627 .86637 L
s
.62435 .38697 m
.63454 .40817 L
s
.72428 .68853 m
.72429 .68872 L
s
.52607 .86624 m
.52618 .86631 L
s
.75823 .55916 m
.76037 .56244 L
s
.72429 .68872 m
.72431 .68893 L
s
.52597 .86618 m
.52607 .86624 L
s
.72431 .68893 m
.72432 .68911 L
s
.72432 .68911 m
.72433 .68931 L
s
.52584 .86609 m
.52597 .86618 L
s
.72433 .68931 m
.72434 .6895 L
s
.52571 .86601 m
.52584 .86609 L
s
.72434 .6895 m
.72435 .68969 L
s
.72435 .68969 m
.72436 .68987 L
s
.52555 .8659 m
.52571 .86601 L
s
.72436 .68987 m
.72438 .69007 L
s
.7935 .58846 m
.79437 .58986 L
s
.45885 .82476 m
.46214 .82707 L
s
.72438 .69007 m
.72439 .69025 L
s
.52539 .8658 m
.52555 .8659 L
s
.72439 .69025 m
.7244 .69044 L
s
.49232 .84595 m
.49394 .84704 L
s
.7244 .69044 m
.72441 .69062 L
s
.52519 .86567 m
.52539 .8658 L
s
.72441 .69062 m
.72442 .69081 L
s
.72442 .69081 m
.72443 .69098 L
s
.525 .86554 m
.52519 .86567 L
s
.72443 .69098 m
.72444 .69117 L
s
.72444 .69117 m
.72445 .69134 L
s
.72445 .69134 m
.72447 .69153 L
s
.52476 .86539 m
.525 .86554 L
s
.72447 .69153 m
.72448 .6917 L
s
.72448 .6917 m
.72449 .69188 L
s
.79263 .58706 m
.7935 .58846 L
s
.72449 .69188 m
.7245 .69205 L
s
.52452 .86523 m
.52476 .86539 L
s
.7245 .69205 m
.72451 .69223 L
s
.72451 .69223 m
.72452 .69239 L
s
.68217 .49026 m
.68795 .49832 L
s
.72452 .69239 m
.72453 .69257 L
s
.52423 .86504 m
.52452 .86523 L
s
.72453 .69257 m
.72454 .69273 L
s
.72454 .69273 m
.72455 .69291 L
s
.72455 .69291 m
.72456 .69306 L
s
.72456 .69306 m
.72457 .69324 L
s
.52393 .86485 m
.52423 .86504 L
s
.72457 .69324 m
.72458 .6934 L
s
.75551 .55499 m
.75823 .55916 L
s
.72458 .6934 m
.72459 .69357 L
s
.42267 .80034 m
.42809 .80433 L
s
.72459 .69357 m
.7246 .69372 L
s
.79155 .58531 m
.79263 .58706 L
s
.7246 .69372 m
.72461 .69389 L
s
.72461 .69389 m
.72462 .69404 L
s
.52357 .86462 m
.52393 .86485 L
s
.49069 .84486 m
.49232 .84595 L
s
.72462 .69404 m
.72463 .69421 L
s
.72463 .69421 m
.72464 .69436 L
s
.71464 .50922 m
.71925 .5179 L
s
.72464 .69436 m
.72465 .69453 L
s
.72465 .69453 m
.72466 .69467 L
s
.72466 .69467 m
.72467 .69484 L
s
.52321 .86438 m
.52357 .86462 L
s
.72467 .69484 m
.72468 .69498 L
s
.72468 .69498 m
.72469 .69514 L
s
.72469 .69514 m
.7247 .69529 L
s
.7247 .69529 m
.72471 .69544 L
s
.72471 .69544 m
.72472 .69559 L
s
.72472 .69559 m
.72473 .69574 L
s
.52277 .8641 m
.52321 .86438 L
s
.72473 .69574 m
.72473 .69588 L
s
.72473 .69588 m
.72474 .69604 L
s
.79047 .58356 m
.79155 .58531 L
s
.72474 .69604 m
.72475 .69617 L
s
.72475 .69617 m
.72476 .69633 L
s
.72476 .69633 m
.72477 .69646 L
s
.72477 .69646 m
.72478 .69661 L
s
.72478 .69661 m
.72479 .69675 L
s
.52232 .86381 m
.52277 .8641 L
s
.72479 .69675 m
.7248 .69689 L
s
.7248 .69689 m
.72481 .69703 L
s
.72481 .69703 m
.72481 .69717 L
s
.72481 .69717 m
.72482 .6973 L
s
.45555 .82245 m
.45885 .82476 L
s
.72482 .6973 m
.72483 .69745 L
s
.72483 .69745 m
.72484 .69757 L
s
.72484 .69757 m
.72485 .69772 L
s
.48866 .84349 m
.49069 .84486 L
s
.52178 .86346 m
.52232 .86381 L
s
.72485 .69772 m
.72486 .69784 L
s
.72486 .69784 m
.72486 .69798 L
s
.78912 .58138 m
.79047 .58356 L
s
.52123 .8631 m
.52178 .86346 L
s
.75279 .55079 m
.75551 .55499 L
s
.52055 .86267 m
.52123 .8631 L
s
.3845 .7728 m
.39154 .77824 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.82401 .61031 m
.82401 .61031 L
s
.824 .61031 m
.82401 .61031 L
s
.824 .6103 m
.824 .61031 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .6103 m
.824 .6103 L
s
.824 .61029 m
.824 .6103 L
s
.824 .61029 m
.824 .61029 L
s
.824 .61029 m
.824 .61029 L
s
.824 .61029 m
.824 .61029 L
s
.82399 .61029 m
.824 .61029 L
s
.82399 .61029 m
.82399 .61029 L
s
.82399 .61029 m
.82399 .61029 L
s
.82399 .61028 m
.82399 .61029 L
s
.82399 .61028 m
.82399 .61028 L
s
.82399 .61028 m
.82399 .61028 L
s
.82399 .61028 m
.82399 .61028 L
s
.82398 .61027 m
.82399 .61028 L
s
.82398 .61027 m
.82398 .61027 L
s
.82398 .61027 m
.82398 .61027 L
s
.82398 .61026 m
.82398 .61027 L
s
.82397 .61026 m
.82398 .61026 L
s
.82397 .61025 m
.82397 .61026 L
s
.82397 .61025 m
.82397 .61025 L
s
.82396 .61024 m
.82397 .61025 L
s
.82396 .61024 m
.82396 .61024 L
s
.82396 .61023 m
.82396 .61024 L
s
.82395 .61022 m
.82396 .61023 L
s
.82395 .61021 m
.82395 .61022 L
s
.78776 .57919 m
.78912 .58138 L
s
.82394 .6102 m
.82395 .61021 L
s
.82393 .61019 m
.82394 .6102 L
s
.82393 .61018 m
.82393 .61019 L
s
.82392 .61017 m
.82393 .61018 L
s
.82391 .61016 m
.82392 .61017 L
s
.8239 .61014 m
.82391 .61016 L
s
.82389 .61013 m
.8239 .61014 L
s
.82388 .61011 m
.82389 .61013 L
s
.82387 .61009 m
.82388 .61011 L
s
.82385 .61007 m
.82387 .61009 L
s
.82384 .61005 m
.82385 .61007 L
s
.82382 .61002 m
.82384 .61005 L
s
.8238 .60999 m
.82382 .61002 L
s
.82378 .60996 m
.8238 .60999 L
s
.82376 .60993 m
.82378 .60996 L
s
.82373 .60989 m
.82376 .60993 L
s
.61415 .36769 m
.62435 .38697 L
s
.82371 .60985 m
.82373 .60989 L
s
.82368 .6098 m
.82371 .60985 L
s
.82364 .60975 m
.82368 .6098 L
s
.51988 .86223 m
.52055 .86267 L
s
.82361 .60969 m
.82364 .60975 L
s
.70877 .49817 m
.71464 .50922 L
s
.82357 .60964 m
.82361 .60969 L
s
.82352 .60956 m
.82357 .60964 L
s
.82347 .60949 m
.82352 .60956 L
s
.34766 .7443 m
.35696 .75194 L
s
.82342 .6094 m
.82347 .60949 L
s
.48662 .84213 m
.48866 .84349 L
s
.82336 .60931 m
.82342 .6094 L
s
.82329 .6092 m
.82336 .60931 L
s
.82321 .60909 m
.82329 .6092 L
s
.60517 .42777 m
.61522 .43933 L
s
.82313 .60896 m
.82321 .60909 L
s
.82304 .60882 m
.82313 .60896 L
s
.82293 .60866 m
.82304 .60882 L
s
.51904 .8617 m
.51988 .86223 L
s
.82282 .6085 m
.82293 .60866 L
s
.82269 .60829 m
.82282 .6085 L
s
.78607 .57645 m
.78776 .57919 L
s
.82256 .60809 m
.82269 .60829 L
s
.8224 .60785 m
.82256 .60809 L
s
.45135 .81952 m
.45555 .82245 L
s
.82224 .6076 m
.8224 .60785 L
s
.4172 .79635 m
.42267 .80034 L
s
.67461 .47937 m
.68217 .49026 L
s
.82204 .60729 m
.82224 .6076 L
s
.74931 .54541 m
.75279 .55079 L
s
.51821 .86116 m
.51904 .8617 L
s
.82184 .60699 m
.82204 .60729 L
s
.8216 .60662 m
.82184 .60699 L
s
.82136 .60625 m
.8216 .60662 L
s
.48404 .84042 m
.48662 .84213 L
s
.82106 .60579 m
.82136 .60625 L
s
.51717 .86049 m
.51821 .86116 L
s
.78437 .57369 m
.78607 .57645 L
s
.82076 .60533 m
.82106 .60579 L
s
.82039 .60477 m
.82076 .60533 L
s
.82003 .6042 m
.82039 .60477 L
s
.51613 .85983 m
.51717 .86049 L
s
.81957 .60351 m
.82003 .6042 L
s
.30547 .70884 m
.31767 .71959 L
s
.78223 .57021 m
.78437 .57369 L
s
.81912 .60282 m
.81957 .60351 L
s
.70287 .48707 m
.70877 .49817 L
s
.51484 .85901 m
.51613 .85983 L
s
.81856 .60196 m
.81912 .60282 L
s
.5766 .53577 m
.58643 .51791 L
s
.74581 .53997 m
.74931 .54541 L
s
.48146 .83871 m
.48404 .84042 L
s
.44711 .8166 m
.45135 .81952 L
s
.81801 .6011 m
.81856 .60196 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.54701 .87753 m
.54701 .87753 L
s
.547 .87753 m
.54701 .87753 L
s
.547 .87753 m
.547 .87753 L
s
.547 .87753 m
.547 .87753 L
s
.547 .87753 m
.547 .87753 L
s
.547 .87753 m
.547 .87753 L
s
.547 .87753 m
.547 .87753 L
s
.547 .87753 m
.547 .87753 L
s
.547 .87752 m
.547 .87753 L
s
.547 .87752 m
.547 .87752 L
s
.54699 .87752 m
.547 .87752 L
s
.54699 .87752 m
.54699 .87752 L
s
.54699 .87752 m
.54699 .87752 L
s
.54699 .87752 m
.54699 .87752 L
s
.54698 .87752 m
.54699 .87752 L
s
.54698 .87752 m
.54698 .87752 L
s
.54698 .87751 m
.54698 .87752 L
s
.54698 .87751 m
.54698 .87751 L
s
.54697 .87751 m
.54698 .87751 L
s
.54697 .87751 m
.54697 .87751 L
s
.54696 .8775 m
.54697 .87751 L
s
.54696 .8775 m
.54696 .8775 L
s
.54695 .8775 m
.54696 .8775 L
s
.54695 .87749 m
.54695 .8775 L
s
.54694 .87749 m
.54695 .87749 L
s
.54693 .87749 m
.54694 .87749 L
s
.54692 .87748 m
.54693 .87749 L
s
.54692 .87748 m
.54692 .87748 L
s
.54691 .87747 m
.54692 .87748 L
s
.5469 .87746 m
.54691 .87747 L
s
.54688 .87746 m
.5469 .87746 L
s
.54687 .87745 m
.54688 .87746 L
s
.54686 .87744 m
.54687 .87745 L
s
.54684 .87743 m
.54686 .87744 L
s
.54683 .87742 m
.54684 .87743 L
s
.54681 .87741 m
.54683 .87742 L
s
.54679 .8774 m
.54681 .87741 L
s
.54677 .87738 m
.54679 .8774 L
s
.54674 .87737 m
.54677 .87738 L
s
.54672 .87735 m
.54674 .87737 L
s
.54668 .87733 m
.54672 .87735 L
s
.54665 .87731 m
.54668 .87733 L
s
.54662 .87729 m
.54665 .87731 L
s
.54658 .87727 m
.54662 .87729 L
s
.54653 .87724 m
.54658 .87727 L
s
.54649 .87721 m
.54653 .87724 L
s
.54643 .87718 m
.54649 .87721 L
s
.81732 .60004 m
.81801 .6011 L
s
.37529 .76574 m
.3845 .7728 L
s
.54637 .87714 m
.54643 .87718 L
s
.5463 .8771 m
.54637 .87714 L
s
.51355 .85819 m
.51484 .85901 L
s
.54623 .87705 m
.5463 .8771 L
s
.54615 .877 m
.54623 .87705 L
s
.78008 .56672 m
.78223 .57021 L
s
.54606 .87695 m
.54615 .877 L
s
.54595 .87688 m
.54606 .87695 L
s
.54585 .87682 m
.54595 .87688 L
s
.54572 .87674 m
.54585 .87682 L
s
.41023 .79131 m
.4172 .79635 L
s
.81663 .59897 m
.81732 .60004 L
s
.54559 .87666 m
.54572 .87674 L
s
.54543 .87656 m
.54559 .87666 L
s
.6039 .35032 m
.61415 .36769 L
s
.54527 .87647 m
.54543 .87656 L
s
.54508 .87635 m
.54527 .87647 L
s
.81577 .59765 m
.81663 .59897 L
s
.51194 .85717 m
.51355 .85819 L
s
.54489 .87623 m
.54508 .87635 L
s
.47819 .83656 m
.48146 .83871 L
s
.54465 .87608 m
.54489 .87623 L
s
.54441 .87594 m
.54465 .87608 L
s
.54412 .87576 m
.54441 .87594 L
s
.74134 .53297 m
.74581 .53997 L
s
.81491 .59633 m
.81577 .59765 L
s
.77736 .56228 m
.78008 .56672 L
s
.33559 .73444 m
.34766 .7443 L
s
.54383 .87558 m
.54412 .87576 L
s
.69518 .47267 m
.70287 .48707 L
s
.66694 .46791 m
.67461 .47937 L
s
.54347 .87536 m
.54383 .87558 L
s
.54982 .33117 m
.54245 .3249 L
s
.51032 .85615 m
.51194 .85717 L
s
.81385 .59469 m
.81491 .59633 L
s
.54311 .87514 m
.54347 .87536 L
s
.4417 .81289 m
.44711 .8166 L
s
.54267 .87487 m
.54311 .87514 L
s
.54223 .8746 m
.54267 .87487 L
s
.81278 .59304 m
.81385 .59469 L
s
.54169 .87427 m
.54223 .8746 L
s
.5083 .85487 m
.51032 .85615 L
s
.77463 .55781 m
.77736 .56228 L
s
.4749 .83441 m
.47819 .83656 L
s
.59493 .4144 m
.60517 .42777 L
s
.54114 .87394 m
.54169 .87427 L
s
.81145 .59098 m
.81278 .59304 L
s
.54047 .87354 m
.54114 .87394 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84653 .61891 m
.84653 .61891 L
s
.84652 .61891 m
.84653 .61891 L
s
.84652 .61891 m
.84652 .61891 L
s
.84652 .61891 m
.84652 .61891 L
s
.84652 .61891 m
.84652 .61891 L
s
.84652 .6189 m
.84652 .61891 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .6189 m
.84652 .6189 L
s
.84652 .61889 m
.84652 .6189 L
s
.84652 .61889 m
.84652 .61889 L
s
.84652 .61889 m
.84652 .61889 L
s
.84651 .61889 m
.84652 .61889 L
s
.84651 .61889 m
.84651 .61889 L
s
.84651 .61889 m
.84651 .61889 L
s
.84651 .61888 m
.84651 .61889 L
s
.84651 .61888 m
.84651 .61888 L
s
.84651 .61888 m
.84651 .61888 L
s
.84651 .61888 m
.84651 .61888 L
s
.8465 .61887 m
.84651 .61888 L
s
.8465 .61887 m
.8465 .61887 L
s
.8465 .61887 m
.8465 .61887 L
s
.8465 .61886 m
.8465 .61887 L
s
.84649 .61886 m
.8465 .61886 L
s
.84649 .61885 m
.84649 .61886 L
s
.84649 .61885 m
.84649 .61885 L
s
.84648 .61884 m
.84649 .61885 L
s
.84648 .61883 m
.84648 .61884 L
s
.84647 .61883 m
.84648 .61883 L
s
.84647 .61882 m
.84647 .61883 L
s
.84646 .61881 m
.84647 .61882 L
s
.84645 .6188 m
.84646 .61881 L
s
.84645 .61879 m
.84645 .6188 L
s
.84644 .61878 m
.84645 .61879 L
s
.84643 .61876 m
.84644 .61878 L
s
.84642 .61875 m
.84643 .61876 L
s
.84641 .61873 m
.84642 .61875 L
s
.8464 .61872 m
.84641 .61873 L
s
.84639 .6187 m
.8464 .61872 L
s
.84637 .61868 m
.84639 .6187 L
s
.84636 .61865 m
.84637 .61868 L
s
.84634 .61863 m
.84636 .61865 L
s
.84632 .6186 m
.84634 .61863 L
s
.8463 .61857 m
.84632 .6186 L
s
.84628 .61854 m
.8463 .61857 L
s
.84626 .6185 m
.84628 .61854 L
s
.84623 .61846 m
.84626 .6185 L
s
.8462 .61841 m
.84623 .61846 L
s
.84617 .61836 m
.8462 .61841 L
s
.84613 .61831 m
.84617 .61836 L
s
.73684 .52587 m
.74134 .53297 L
s
.5398 .87313 m
.54047 .87354 L
s
.84609 .61825 m
.84613 .61831 L
s
.84605 .61818 m
.84609 .61825 L
s
.846 .61811 m
.84605 .61818 L
s
.84594 .61802 m
.846 .61811 L
s
.84589 .61793 m
.84594 .61802 L
s
.81012 .58892 m
.81145 .59098 L
s
.84581 .61782 m
.84589 .61793 L
s
.84574 .61771 m
.84581 .61782 L
s
.84566 .61758 m
.84574 .61771 L
s
.50627 .8536 m
.5083 .85487 L
s
.84557 .61745 m
.84566 .61758 L
s
.84546 .61729 m
.84557 .61745 L
s
.53897 .87263 m
.5398 .87313 L
s
.84536 .61713 m
.84546 .61729 L
s
.4032 .78626 m
.41023 .79131 L
s
.84523 .61693 m
.84536 .61713 L
s
.77116 .5521 m
.77463 .55781 L
s
.8451 .61673 m
.84523 .61693 L
s
.84494 .61649 m
.8451 .61673 L
s
.84478 .61624 m
.84494 .61649 L
s
.84458 .61594 m
.84478 .61624 L
s
.80845 .58633 m
.81012 .58892 L
s
.53814 .87213 m
.53897 .87263 L
s
.84439 .61565 m
.84458 .61594 L
s
.2931 .69793 m
.30547 .70884 L
s
.47071 .83169 m
.4749 .83441 L
s
.36597 .75865 m
.37529 .76574 L
s
.68743 .45831 m
.69518 .47267 L
s
.84415 .61528 m
.84439 .61565 L
s
.84391 .61491 m
.84415 .61528 L
s
.43625 .80918 m
.4417 .81289 L
s
.84361 .61446 m
.84391 .61491 L
s
.53711 .87151 m
.53814 .87213 L
s
.59358 .3346 m
.6039 .35032 L
s
.50371 .85201 m
.50627 .8536 L
s
.84332 .61401 m
.84361 .61446 L
s
.84295 .61346 m
.84332 .61401 L
s
.80678 .58373 m
.80845 .58633 L
s
.65699 .45227 m
.66694 .46791 L
s
.84259 .61291 m
.84295 .61346 L
s
.53608 .87089 m
.53711 .87151 L
s
.84214 .61222 m
.84259 .61291 L
s
.76766 .54634 m
.77116 .5521 L
s
.73111 .51674 m
.73684 .52587 L
s
.8417 .61154 m
.84214 .61222 L
s
.5348 .87012 m
.53608 .87089 L
s
.84115 .6107 m
.8417 .61154 L
s
.80467 .58045 m
.80678 .58373 L
s
.53175 .32066 m
.54245 .3249 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56723 .88812 m
.56723 .88812 L
s
.56722 .88812 m
.56723 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88812 m
.56722 .88812 L
s
.56722 .88811 m
.56722 .88812 L
s
.56722 .88811 m
.56722 .88811 L
s
.56721 .88811 m
.56722 .88811 L
s
.56721 .88811 m
.56721 .88811 L
s
.56721 .88811 m
.56721 .88811 L
s
.56721 .88811 m
.56721 .88811 L
s
.56721 .88811 m
.56721 .88811 L
s
.56721 .88811 m
.56721 .88811 L
s
.5672 .88811 m
.56721 .88811 L
s
.5672 .88811 m
.5672 .88811 L
s
.5672 .8881 m
.5672 .88811 L
s
.5672 .8881 m
.5672 .8881 L
s
.56719 .8881 m
.5672 .8881 L
s
.56719 .8881 m
.56719 .8881 L
s
.56719 .8881 m
.56719 .8881 L
s
.56718 .88809 m
.56719 .8881 L
s
.56718 .88809 m
.56718 .88809 L
s
.56717 .88809 m
.56718 .88809 L
s
.56717 .88809 m
.56717 .88809 L
s
.56716 .88808 m
.56717 .88809 L
s
.56716 .88808 m
.56716 .88808 L
s
.56715 .88808 m
.56716 .88808 L
s
.56714 .88807 m
.56715 .88808 L
s
.56713 .88807 m
.56714 .88807 L
s
.56712 .88806 m
.56713 .88807 L
s
.56711 .88805 m
.56712 .88806 L
s
.5671 .88805 m
.56711 .88805 L
s
.56709 .88804 m
.5671 .88805 L
s
.56707 .88803 m
.56709 .88804 L
s
.50114 .85042 m
.50371 .85201 L
s
.56706 .88802 m
.56707 .88803 L
s
.56704 .88801 m
.56706 .88802 L
s
.56703 .888 m
.56704 .88801 L
s
.567 .88799 m
.56703 .888 L
s
.84059 .60985 m
.84115 .6107 L
s
.56698 .88798 m
.567 .88799 L
s
.56696 .88796 m
.56698 .88798 L
s
.56693 .88795 m
.56696 .88796 L
s
.5669 .88793 m
.56693 .88795 L
s
.56687 .88791 m
.5669 .88793 L
s
.56683 .88789 m
.56687 .88791 L
s
.5668 .88787 m
.56683 .88789 L
s
.56675 .88784 m
.5668 .88787 L
s
.5667 .88782 m
.56675 .88784 L
s
.56665 .88779 m
.5667 .88782 L
s
.56659 .88775 m
.56665 .88779 L
s
.56652 .88771 m
.56659 .88775 L
s
.56645 .88767 m
.56652 .88771 L
s
.83991 .60881 m
.84059 .60985 L
s
.56637 .88762 m
.56645 .88767 L
s
.46649 .82897 m
.47071 .83169 L
s
.56628 .88757 m
.56637 .88762 L
s
.53351 .86936 m
.5348 .87012 L
s
.56618 .88751 m
.56628 .88757 L
s
.56607 .88745 m
.56618 .88751 L
s
.32334 .7245 m
.33559 .73444 L
s
.56594 .88738 m
.56607 .88745 L
s
.56582 .8873 m
.56594 .88738 L
s
.83923 .60776 m
.83991 .60881 L
s
.56566 .88721 m
.56582 .8873 L
s
.5655 .88712 m
.56566 .88721 L
s
.56531 .88701 m
.5655 .88712 L
s
.80255 .57715 m
.80467 .58045 L
s
.56512 .8869 m
.56531 .88701 L
s
.39399 .77972 m
.4032 .78626 L
s
.76319 .53895 m
.76766 .54634 L
s
.83838 .60647 m
.83923 .60776 L
s
.56488 .88676 m
.56512 .8869 L
s
.53191 .8684 m
.53351 .86936 L
s
.67744 .44009 m
.68743 .45831 L
s
.42929 .80451 m
.43625 .80918 L
s
.56465 .88663 m
.56488 .88676 L
s
.49788 .84842 m
.50114 .85042 L
s
.56436 .88646 m
.56465 .88663 L
s
.83754 .60517 m
.83838 .60647 L
s
.56407 .8863 m
.56436 .88646 L
s
.58451 .3991 m
.59493 .4144 L
s
.56371 .88609 m
.56407 .8863 L
s
.56335 .88589 m
.56371 .88609 L
s
.83648 .60355 m
.83754 .60517 L
s
.79987 .57296 m
.80255 .57715 L
s
.5303 .86745 m
.53191 .8684 L
s
.56292 .88564 m
.56335 .88589 L
s
.72532 .50741 m
.73111 .51674 L
s
.56248 .88539 m
.56292 .88564 L
s
.35387 .74956 m
.36597 .75865 L
s
.4611 .82553 m
.46649 .82897 L
s
.83543 .60193 m
.83648 .60355 L
s
.56194 .88508 m
.56248 .88539 L
s
.52829 .86627 m
.5303 .86745 L
s
.5614 .88477 m
.56194 .88508 L
s
.49461 .84642 m
.49788 .84842 L
s
.83411 .59991 m
.83543 .60193 L
s
.75869 .53149 m
.76319 .53895 L
s
.58316 .32003 m
.59358 .3346 L
s
.56073 .88439 m
.5614 .88477 L
s
.28055 .68687 m
.2931 .69793 L
s
.79718 .56874 m
.79987 .57296 L
s
.64686 .43536 m
.65699 .45227 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62787 m
.86946 .62787 L
s
.86946 .62786 m
.86946 .62787 L
s
.86946 .62786 m
.86946 .62786 L
s
.86946 .62786 m
.86946 .62786 L
s
.86946 .62786 m
.86946 .62786 L
s
.86946 .62786 m
.86946 .62786 L
s
.86945 .62786 m
.86946 .62786 L
s
.86945 .62786 m
.86945 .62786 L
s
.86945 .62786 m
.86945 .62786 L
s
.86945 .62786 m
.86945 .62786 L
s
.86945 .62786 m
.86945 .62786 L
s
.86945 .62785 m
.86945 .62786 L
s
.86945 .62785 m
.86945 .62785 L
s
.86945 .62785 m
.86945 .62785 L
s
.86945 .62785 m
.86945 .62785 L
s
.86945 .62785 m
.86945 .62785 L
s
.86944 .62784 m
.86945 .62785 L
s
.86944 .62784 m
.86944 .62784 L
s
.86944 .62784 m
.86944 .62784 L
s
.86944 .62784 m
.86944 .62784 L
s
.86944 .62783 m
.86944 .62784 L
s
.86943 .62783 m
.86944 .62783 L
s
.86943 .62783 m
.86943 .62783 L
s
.86943 .62782 m
.86943 .62783 L
s
.86942 .62782 m
.86943 .62782 L
s
.86942 .62781 m
.86942 .62782 L
s
.86942 .6278 m
.86942 .62781 L
s
.86941 .6278 m
.86942 .6278 L
s
.86941 .62779 m
.86941 .6278 L
s
.8694 .62778 m
.86941 .62779 L
s
.8694 .62777 m
.8694 .62778 L
s
.86939 .62776 m
.8694 .62777 L
s
.86938 .62775 m
.86939 .62776 L
s
.86938 .62774 m
.86938 .62775 L
s
.86937 .62773 m
.86938 .62774 L
s
.86936 .62772 m
.86937 .62773 L
s
.86935 .6277 m
.86936 .62772 L
s
.86934 .62768 m
.86935 .6277 L
s
.86932 .62767 m
.86934 .62768 L
s
.86931 .62764 m
.86932 .62767 L
s
.8693 .62762 m
.86931 .62764 L
s
.86928 .6276 m
.8693 .62762 L
s
.86926 .62757 m
.86928 .6276 L
s
.86924 .62754 m
.86926 .62757 L
s
.86922 .62751 m
.86924 .62754 L
s
.8692 .62747 m
.86922 .62751 L
s
.56007 .88401 m
.56073 .88439 L
s
.86917 .62743 m
.8692 .62747 L
s
.86914 .62739 m
.86917 .62743 L
s
.86911 .62734 m
.86914 .62739 L
s
.86907 .62729 m
.86911 .62734 L
s
.86903 .62723 m
.86907 .62729 L
s
.86899 .62716 m
.86903 .62723 L
s
.86894 .62709 m
.86899 .62716 L
s
.86889 .62701 m
.86894 .62709 L
s
.86883 .62692 m
.86889 .62701 L
s
.86876 .62682 m
.86883 .62692 L
s
.83279 .59789 m
.83411 .59991 L
s
.86869 .62671 m
.86876 .62682 L
s
.8686 .62658 m
.86869 .62671 L
s
.86852 .62646 m
.8686 .62658 L
s
.55924 .88354 m
.56007 .88401 L
s
.86841 .6263 m
.86852 .62646 L
s
.52627 .86509 m
.52829 .86627 L
s
.86831 .62614 m
.86841 .6263 L
s
.86818 .62595 m
.86831 .62614 L
s
.86805 .62576 m
.86818 .62595 L
s
.86789 .62552 m
.86805 .62576 L
s
.86774 .62529 m
.86789 .62552 L
s
.55842 .88308 m
.55924 .88354 L
s
.86754 .625 m
.86774 .62529 L
s
.83114 .59534 m
.83279 .59789 L
s
.86735 .62471 m
.86754 .625 L
s
.42226 .79985 m
.42929 .80451 L
s
.86712 .62435 m
.86735 .62471 L
s
.79375 .56335 m
.79718 .56874 L
s
.71775 .49501 m
.72532 .50741 L
s
.86688 .624 m
.86712 .62435 L
s
.49044 .8439 m
.49461 .84642 L
s
.55739 .8825 m
.55842 .88308 L
s
.86659 .62356 m
.86688 .624 L
s
.66737 .42207 m
.67744 .44009 L
s
.8663 .62312 m
.86659 .62356 L
s
.52373 .86361 m
.52627 .86509 L
s
.75297 .52194 m
.75869 .53149 L
s
.86594 .62259 m
.8663 .62312 L
s
.45566 .82211 m
.4611 .82553 L
s
.82949 .59279 m
.83114 .59534 L
s
.38466 .7732 m
.39399 .77972 L
s
.86558 .62205 m
.86594 .62259 L
s
.55637 .88192 m
.55739 .8825 L
s
.86514 .62139 m
.86558 .62205 L
s
.56637 .54884 m
.5766 .53577 L
s
.3109 .71447 m
.32334 .7245 L
s
.8647 .62072 m
.86514 .62139 L
s
.5551 .88121 m
.55637 .88192 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58778 .8986 m
.58778 .8986 L
s
.58777 .8986 m
.58778 .8986 L
s
.58777 .8986 m
.58777 .8986 L
s
.58777 .89859 m
.58777 .8986 L
s
.58777 .89859 m
.58777 .89859 L
s
.58777 .89859 m
.58777 .89859 L
s
.58777 .89859 m
.58777 .89859 L
s
.58777 .89859 m
.58777 .89859 L
s
.58777 .89859 m
.58777 .89859 L
s
.58776 .89859 m
.58777 .89859 L
s
.58776 .89859 m
.58776 .89859 L
s
.58776 .89859 m
.58776 .89859 L
s
.58776 .89859 m
.58776 .89859 L
s
.58775 .89858 m
.58776 .89859 L
s
.58775 .89858 m
.58775 .89858 L
s
.58775 .89858 m
.58775 .89858 L
s
.58774 .89858 m
.58775 .89858 L
s
.58774 .89858 m
.58774 .89858 L
s
.58774 .89857 m
.58774 .89858 L
s
.58773 .89857 m
.58774 .89857 L
s
.58773 .89857 m
.58773 .89857 L
s
.58772 .89857 m
.58773 .89857 L
s
.58771 .89856 m
.58772 .89857 L
s
.58771 .89856 m
.58771 .89856 L
s
.5877 .89855 m
.58771 .89856 L
s
.58769 .89855 m
.5877 .89855 L
s
.58768 .89854 m
.58769 .89855 L
s
.58767 .89854 m
.58768 .89854 L
s
.86416 .61991 m
.8647 .62072 L
s
.58766 .89853 m
.58767 .89854 L
s
.58765 .89853 m
.58766 .89853 L
s
.58763 .89852 m
.58765 .89853 L
s
.58762 .89851 m
.58763 .89852 L
s
.5876 .8985 m
.58762 .89851 L
s
.58758 .89849 m
.5876 .8985 L
s
.58756 .89848 m
.58758 .89849 L
s
.58754 .89847 m
.58756 .89848 L
s
.58752 .89845 m
.58754 .89847 L
s
.58749 .89844 m
.58752 .89845 L
s
.57393 .38181 m
.58451 .3991 L
s
.58746 .89842 m
.58749 .89844 L
s
.58743 .89841 m
.58746 .89842 L
s
.8274 .58957 m
.82949 .59279 L
s
.58739 .89839 m
.58743 .89841 L
s
.58736 .89837 m
.58739 .89839 L
s
.58731 .89834 m
.58736 .89837 L
s
.58727 .89832 m
.58731 .89834 L
s
.58721 .89829 m
.58727 .89832 L
s
.58715 .89826 m
.58721 .89829 L
s
.7903 .55791 m
.79375 .56335 L
s
.58709 .89822 m
.58715 .89826 L
s
.86361 .61909 m
.86416 .61991 L
s
.52117 .86214 m
.52373 .86361 L
s
.58702 .89818 m
.58709 .89822 L
s
.58693 .89814 m
.58702 .89818 L
s
.58685 .89809 m
.58693 .89814 L
s
.58674 .89803 m
.58685 .89809 L
s
.58664 .89798 m
.58674 .89803 L
s
.58651 .89791 m
.58664 .89798 L
s
.55382 .8805 m
.5551 .88121 L
s
.86294 .61808 m
.86361 .61909 L
s
.58638 .89784 m
.58651 .89791 L
s
.58623 .89775 m
.58638 .89784 L
s
.58607 .89767 m
.58623 .89775 L
s
.48623 .84139 m
.49044 .8439 L
s
.58588 .89757 m
.58607 .89767 L
s
.86227 .61706 m
.86294 .61808 L
s
.58569 .89746 m
.58588 .89757 L
s
.58546 .89733 m
.58569 .89746 L
s
.82531 .58633 m
.8274 .58957 L
s
.58522 .89721 m
.58546 .89733 L
s
.52081 .32061 m
.53175 .32066 L
s
.55223 .87961 m
.55382 .8805 L
s
.86143 .61581 m
.86227 .61706 L
s
.58494 .89705 m
.58522 .89721 L
s
.63658 .41703 m
.64686 .43536 L
s
.58465 .8969 m
.58494 .89705 L
s
.7472 .51229 m
.75297 .52194 L
s
.51793 .86028 m
.52117 .86214 L
s
.5843 .89671 m
.58465 .8969 L
s
.8606 .61455 m
.86143 .61581 L
s
.34158 .74043 m
.35387 .74956 L
s
.44872 .81781 m
.45566 .82211 L
s
.41306 .79385 m
.42226 .79985 L
s
.57261 .30601 m
.58316 .32003 L
s
.58394 .89652 m
.5843 .89671 L
s
.7101 .48222 m
.71775 .49501 L
s
.78589 .55092 m
.7903 .55791 L
s
.58351 .89628 m
.58394 .89652 L
s
.55063 .87873 m
.55223 .87961 L
s
.85956 .61299 m
.8606 .61455 L
s
.26782 .67566 m
.28055 .68687 L
s
.82266 .58222 m
.82531 .58633 L
s
.58307 .89605 m
.58351 .89628 L
s
.58254 .89576 m
.58307 .89605 L
s
.6572 .40424 m
.66737 .42207 L
s
.85852 .61142 m
.85956 .61299 L
s
.582 .89548 m
.58254 .89576 L
s
.48086 .83822 m
.48623 .84139 L
s
.54864 .87763 m
.55063 .87873 L
s
.58134 .89512 m
.582 .89548 L
s
.85722 .60946 m
.85852 .61142 L
s
.51468 .85844 m
.51793 .86028 L
s
.58068 .89477 m
.58134 .89512 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .637 m
.8928 .637 L
s
.8928 .63699 m
.8928 .637 L
s
.37255 .76487 m
.38466 .7732 L
s
.8928 .63699 m
.8928 .63699 L
s
.89279 .63699 m
.8928 .63699 L
s
.89279 .63699 m
.89279 .63699 L
s
.89279 .63699 m
.89279 .63699 L
s
.89279 .63699 m
.89279 .63699 L
s
.89279 .63699 m
.89279 .63699 L
s
.89279 .63699 m
.89279 .63699 L
s
.89279 .63698 m
.89279 .63699 L
s
.89279 .63698 m
.89279 .63698 L
s
.89279 .63698 m
.89279 .63698 L
s
.89278 .63698 m
.89279 .63698 L
s
.89278 .63698 m
.89278 .63698 L
s
.89278 .63697 m
.89278 .63698 L
s
.89278 .63697 m
.89278 .63697 L
s
.89278 .63697 m
.89278 .63697 L
s
.89277 .63696 m
.89278 .63697 L
s
.89277 .63696 m
.89277 .63696 L
s
.89277 .63696 m
.89277 .63696 L
s
.89277 .63695 m
.89277 .63696 L
s
.89276 .63694 m
.89277 .63695 L
s
.89276 .63694 m
.89276 .63694 L
s
.89275 .63693 m
.89276 .63694 L
s
.89275 .63693 m
.89275 .63693 L
s
.89274 .63692 m
.89275 .63693 L
s
.89274 .63691 m
.89274 .63692 L
s
.89273 .6369 m
.89274 .63691 L
s
.89273 .63689 m
.89273 .6369 L
s
.89272 .63688 m
.89273 .63689 L
s
.89271 .63687 m
.89272 .63688 L
s
.8927 .63685 m
.89271 .63687 L
s
.89269 .63684 m
.8927 .63685 L
s
.81999 .57809 m
.82266 .58222 L
s
.89268 .63682 m
.89269 .63684 L
s
.89267 .6368 m
.89268 .63682 L
s
.89265 .63678 m
.89267 .6368 L
s
.89264 .63676 m
.89265 .63678 L
s
.89262 .63674 m
.89264 .63676 L
s
.89261 .63671 m
.89262 .63674 L
s
.89259 .63668 m
.89261 .63671 L
s
.89256 .63665 m
.89259 .63668 L
s
.89254 .63662 m
.89256 .63665 L
s
.89252 .63658 m
.89254 .63662 L
s
.89249 .63654 m
.89252 .63658 L
s
.89245 .63649 m
.89249 .63654 L
s
.89242 .63644 m
.89245 .63649 L
s
.89238 .63638 m
.89242 .63644 L
s
.89234 .63632 m
.89238 .63638 L
s
.89229 .63625 m
.89234 .63632 L
s
.89224 .63617 m
.89229 .63625 L
s
.89218 .63608 m
.89224 .63617 L
s
.89211 .63598 m
.89218 .63608 L
s
.57986 .89433 m
.58068 .89477 L
s
.89204 .63588 m
.89211 .63598 L
s
.89196 .63576 m
.89204 .63588 L
s
.89187 .63563 m
.89196 .63576 L
s
.85592 .6075 m
.85722 .60946 L
s
.78145 .54385 m
.78589 .55092 L
s
.89177 .63548 m
.89187 .63563 L
s
.73966 .4996 m
.7472 .51229 L
s
.54663 .87654 m
.54864 .87763 L
s
.56321 .36267 m
.57393 .38181 L
s
.89167 .63533 m
.89177 .63548 L
s
.89154 .63514 m
.89167 .63533 L
s
.89141 .63495 m
.89154 .63514 L
s
.89126 .63472 m
.89141 .63495 L
s
.57905 .8939 m
.57986 .89433 L
s
.8911 .6345 m
.89126 .63472 L
s
.89091 .63421 m
.8911 .6345 L
s
.89072 .63393 m
.89091 .63421 L
s
.89049 .63359 m
.89072 .63393 L
s
.85429 .60503 m
.85592 .6075 L
s
.57803 .89336 m
.57905 .8939 L
s
.89026 .63324 m
.89049 .63359 L
s
.29827 .70437 m
.3109 .71447 L
s
.8166 .5728 m
.81999 .57809 L
s
.88997 .63282 m
.89026 .63324 L
s
.51053 .85612 m
.51468 .85844 L
s
.62614 .39724 m
.63658 .41703 L
s
.70016 .4652 m
.7101 .48222 L
s
.88969 .6324 m
.88997 .63282 L
s
.5441 .87517 m
.54663 .87654 L
s
.44171 .81353 m
.44872 .81781 L
s
.88933 .63188 m
.88969 .6324 L
s
.57702 .89283 m
.57803 .89336 L
s
.88898 .63136 m
.88933 .63188 L
s
.85266 .60256 m
.85429 .60503 L
s
.47544 .83508 m
.48086 .83822 L
s
.88855 .63071 m
.88898 .63136 L
s
.57575 .89217 m
.57702 .89283 L
s
.88811 .63007 m
.88855 .63071 L
s
.77579 .53479 m
.78145 .54385 L
s
.60856 .91001 m
.60858 .91006 L
s
.60855 .90997 m
.60856 .91001 L
s
.60858 .91006 m
.60859 .91011 L
s
.60853 .90992 m
.60855 .90997 L
s
.60859 .91011 m
.6086 .91015 L
s
.60851 .90988 m
.60853 .90992 L
s
.6086 .91015 m
.60862 .9102 L
s
.60849 .90983 m
.60851 .90988 L
s
.60862 .9102 m
.60863 .91025 L
s
.60847 .90978 m
.60849 .90983 L
s
.60863 .91025 m
.60864 .91029 L
s
.60864 .91029 m
.60864 .91034 L
s
.60845 .90973 m
.60847 .90978 L
s
.60864 .91034 m
.60865 .91038 L
s
.60842 .90969 m
.60845 .90973 L
s
.60865 .91038 m
.60866 .91043 L
s
.60866 .91043 m
.60867 .91048 L
s
.60839 .90963 m
.60842 .90969 L
s
.60867 .91048 m
.60867 .91053 L
s
.60836 .90959 m
.60839 .90963 L
s
.60867 .91053 m
.60868 .91057 L
s
.88758 .62928 m
.88811 .63007 L
s
.60868 .91057 m
.60868 .91062 L
s
.40374 .78788 m
.41306 .79385 L
s
.60832 .90953 m
.60836 .90959 L
s
.60868 .91062 m
.60869 .91067 L
s
.60869 .91067 m
.60869 .91072 L
s
.60828 .90948 m
.60832 .90953 L
s
.60869 .91072 m
.6087 .91076 L
s
.6087 .91076 m
.6087 .91081 L
s
.60824 .90943 m
.60828 .90948 L
s
.6087 .91081 m
.60871 .91086 L
s
.60871 .91086 m
.60871 .91091 L
s
.60819 .90937 m
.60824 .90943 L
s
.60871 .91091 m
.60871 .91096 L
s
.60871 .91096 m
.60872 .91101 L
s
.60872 .91101 m
.60872 .91106 L
s
.60813 .90931 m
.60819 .90937 L
s
.60872 .91106 m
.60872 .91111 L
s
.60872 .91111 m
.60873 .91116 L
s
.60808 .90925 m
.60813 .90931 L
s
.60873 .91116 m
.60873 .91122 L
s
.60873 .91122 m
.60873 .91126 L
s
.60873 .91126 m
.60873 .91132 L
s
.60801 .90919 m
.60808 .90925 L
s
.60873 .91132 m
.60874 .91137 L
s
.60874 .91137 m
.60874 .91142 L
s
.60874 .91142 m
.60874 .91147 L
s
.60794 .90913 m
.60801 .90919 L
s
.60874 .91147 m
.60874 .91153 L
s
.60874 .91153 m
.60874 .91158 L
s
.60874 .91158 m
.60875 .91164 L
s
.60875 .91164 m
.60875 .91169 L
s
.60786 .90905 m
.60794 .90913 L
s
.60875 .91169 m
.60875 .91174 L
s
.60875 .91174 m
.60875 .9118 L
s
.60875 .9118 m
.60875 .91185 L
s
.60875 .91185 m
.60875 .91191 L
s
.60777 .90898 m
.60786 .90905 L
s
.60875 .91191 m
.60876 .91196 L
s
.60876 .91196 m
.60876 .91202 L
s
.60876 .91202 m
.60876 .91207 L
s
.60767 .9089 m
.60777 .90898 L
s
.60876 .91207 m
.60876 .91213 L
s
.8506 .59945 m
.85266 .60256 L
s
.60876 .91213 m
.60876 .91219 L
s
.60876 .91219 m
.60876 .91224 L
s
.88704 .62849 m
.88758 .62928 L
s
.60876 .91224 m
.60877 .9123 L
s
.64693 .38646 m
.6572 .40424 L
s
.60877 .9123 m
.60877 .91235 L
s
.54157 .87381 m
.5441 .87517 L
s
.60756 .90882 m
.60767 .9089 L
s
.60877 .91235 m
.60877 .91241 L
s
.60877 .91241 m
.60877 .91247 L
s
.60877 .91247 m
.60877 .91253 L
s
.60877 .91253 m
.60877 .91259 L
s
.60877 .91259 m
.60878 .91265 L
s
.60744 .90873 m
.60756 .90882 L
s
.60878 .91265 m
.60878 .9127 L
s
.60878 .9127 m
.60878 .91276 L
s
.60878 .91276 m
.60878 .91282 L
s
.60878 .91282 m
.60878 .91288 L
s
.81318 .56747 m
.8166 .5728 L
s
.60878 .91288 m
.60878 .91294 L
s
.57449 .8915 m
.57575 .89217 L
s
.60878 .91294 m
.60878 .913 L
s
.60731 .90865 m
.60744 .90873 L
s
.60878 .913 m
.60879 .91306 L
s
.60879 .91306 m
.60879 .91312 L
s
.60879 .91312 m
.60879 .91318 L
s
.60879 .91318 m
.60879 .91324 L
s
.60879 .91324 m
.60879 .9133 L
s
.60716 .90854 m
.60731 .90865 L
s
.60879 .9133 m
.60879 .91336 L
s
.60879 .91336 m
.60879 .91342 L
s
.60879 .91342 m
.6088 .91348 L
s
.6088 .91348 m
.6088 .91354 L
s
.6088 .91354 m
.6088 .91361 L
s
.6088 .91361 m
.6088 .91366 L
s
.6088 .91366 m
.6088 .91373 L
s
.607 .90844 m
.60716 .90854 L
s
.88638 .62751 m
.88704 .62849 L
s
.6088 .91373 m
.6088 .91379 L
s
.56191 .29197 m
.57261 .30601 L
s
.6088 .91379 m
.60881 .91385 L
s
.60881 .91385 m
.60881 .91391 L
s
.60881 .91391 m
.60881 .91398 L
s
.60881 .91398 m
.60881 .91404 L
s
.60881 .91404 m
.60881 .9141 L
s
.60681 .90833 m
.607 .90844 L
s
.60881 .9141 m
.60881 .91416 L
s
.60881 .91416 m
.60881 .91423 L
s
.60881 .91423 m
.60882 .91429 L
s
.60882 .91429 m
.60882 .91435 L
s
.60882 .91435 m
.60882 .91441 L
s
.60882 .91441 m
.60882 .91448 L
s
.60882 .91448 m
.60882 .91454 L
s
.60882 .91454 m
.60882 .91461 L
s
.60882 .91461 m
.60883 .91467 L
s
.60662 .90821 m
.60681 .90833 L
s
.60883 .91467 m
.60883 .91474 L
s
.60883 .91474 m
.60883 .9148 L
s
.60883 .9148 m
.60883 .91486 L
s
.60883 .91486 m
.60883 .91493 L
s
.60883 .91493 m
.60883 .91499 L
s
.60883 .91499 m
.60883 .91506 L
s
.60883 .91506 m
.60884 .91512 L
s
.60884 .91512 m
.60884 .91519 L
s
.60639 .90807 m
.60662 .90821 L
s
.60884 .91519 m
.60884 .91525 L
s
.60884 .91525 m
.60884 .91532 L
s
.3291 .73131 m
.34158 .74043 L
s
.60884 .91532 m
.60884 .91538 L
s
.60884 .91538 m
.60884 .91545 L
s
.60884 .91545 m
.60885 .91551 L
s
.60885 .91551 m
.60885 .91558 L
s
.88572 .62652 m
.88638 .62751 L
s
.60885 .91558 m
.60885 .91565 L
s
.60885 .91565 m
.60885 .91571 L
s
.60885 .91571 m
.60885 .91578 L
s
.50635 .85381 m
.51053 .85612 L
s
.60616 .90794 m
.60639 .90807 L
s
.60885 .91578 m
.60885 .91584 L
s
.60885 .91584 m
.60885 .91591 L
s
.2549 .66428 m
.26782 .67566 L
s
.60885 .91591 m
.60886 .91597 L
s
.60886 .91597 m
.60886 .91604 L
s
.60886 .91604 m
.60886 .91611 L
s
.60886 .91611 m
.60886 .91618 L
s
.73204 .48672 m
.73966 .4996 L
s
.60886 .91618 m
.60886 .91624 L
s
.60886 .91624 m
.60886 .91631 L
s
.60886 .91631 m
.60887 .91637 L
s
.57291 .89068 m
.57449 .8915 L
s
.60887 .91637 m
.60887 .91645 L
s
.60587 .90777 m
.60616 .90794 L
s
.60887 .91645 m
.60887 .91651 L
s
.60887 .91651 m
.60887 .91658 L
s
.60887 .91658 m
.60887 .91664 L
s
.60887 .91664 m
.60887 .91672 L
s
.62929 .89791 m
.62929 .89791 L
s
.62929 .8979 m
.62929 .89791 L
s
.62929 .8979 m
.62929 .8979 L
s
.62929 .89791 m
.62929 .89792 L
s
.62928 .89791 m
.62929 .8979 L
s
.62929 .89792 m
.62929 .89793 L
s
.62928 .89791 m
.62928 .89791 L
s
.62929 .89793 m
.62929 .89794 L
s
.62929 .89794 m
.62929 .89795 L
s
.62928 .89792 m
.62928 .89791 L
s
.62929 .89795 m
.62929 .89796 L
s
.62928 .89793 m
.62928 .89792 L
s
.62929 .89796 m
.6293 .89798 L
s
.62928 .89794 m
.62928 .89793 L
s
.60887 .91672 m
.60888 .91678 L
s
.6293 .89798 m
.6293 .898 L
s
.62928 .89796 m
.62928 .89794 L
s
.6293 .898 m
.6293 .89802 L
s
.6293 .89802 m
.6293 .89804 L
s
.62928 .89798 m
.62928 .89796 L
s
.6293 .89804 m
.6293 .89806 L
s
.60888 .91678 m
.60888 .91685 L
s
.62927 .898 m
.62928 .89798 L
s
.6293 .89806 m
.6293 .89808 L
s
.62927 .89802 m
.62927 .898 L
s
.6293 .89808 m
.6293 .89811 L
s
.6293 .89811 m
.6293 .89813 L
s
.62927 .89805 m
.62927 .89802 L
s
.60888 .91685 m
.60888 .91692 L
s
.6293 .89813 m
.6293 .89816 L
s
.62927 .89809 m
.62927 .89805 L
s
.6293 .89816 m
.6293 .89818 L
s
.6293 .89818 m
.62931 .89821 L
s
.60888 .91692 m
.60888 .91699 L
s
.62927 .89812 m
.62927 .89809 L
s
.62931 .89821 m
.62931 .89824 L
s
.62931 .89824 m
.62931 .89827 L
s
.62926 .89816 m
.62927 .89812 L
s
.60888 .91699 m
.60888 .91705 L
s
.62931 .89827 m
.62931 .8983 L
s
.62931 .8983 m
.62931 .89833 L
s
.62926 .89821 m
.62926 .89816 L
s
.60888 .91705 m
.60888 .91712 L
s
.62931 .89833 m
.62931 .89836 L
s
.62931 .89836 m
.62931 .89839 L
s
.62926 .89825 m
.62926 .89821 L
s
.62931 .89839 m
.62931 .89842 L
s
.60888 .91712 m
.60889 .91719 L
s
.62931 .89842 m
.62931 .89846 L
s
.62925 .89831 m
.62926 .89825 L
s
.62931 .89846 m
.62932 .89849 L
s
.60889 .91719 m
.60889 .91726 L
s
.60559 .90761 m
.60587 .90777 L
s
.62932 .89849 m
.62932 .89852 L
s
.62925 .89836 m
.62925 .89831 L
s
.62932 .89852 m
.62932 .89856 L
s
.60889 .91726 m
.60889 .91733 L
s
.62932 .89856 m
.62932 .89859 L
s
.62925 .89843 m
.62925 .89836 L
s
.62932 .89859 m
.62932 .89862 L
s
.60889 .91733 m
.60889 .9174 L
s
.62932 .89862 m
.62932 .89866 L
s
.62932 .89866 m
.62932 .89869 L
s
.62924 .89849 m
.62925 .89843 L
s
.60889 .9174 m
.60889 .91746 L
s
.8849 .62531 m
.88572 .62652 L
s
.62932 .89869 m
.62932 .89873 L
s
.62932 .89873 m
.62932 .89876 L
s
.60889 .91746 m
.60889 .91754 L
s
.62924 .89856 m
.62924 .89849 L
s
.62932 .89876 m
.62932 .8988 L
s
.84854 .59632 m
.8506 .59945 L
s
.62932 .8988 m
.62933 .89883 L
s
.60889 .91754 m
.6089 .9176 L
s
.62933 .89883 m
.62933 .89886 L
s
.62923 .89863 m
.62924 .89856 L
s
.62933 .89886 m
.62933 .8989 L
s
.6089 .9176 m
.6089 .91767 L
s
.62933 .8989 m
.62933 .89893 L
s
.62933 .89893 m
.62933 .89896 L
s
.62922 .89872 m
.62923 .89863 L
s
.6089 .91767 m
.6089 .91774 L
s
.62933 .89896 m
.62933 .899 L
s
.62933 .899 m
.62933 .89903 L
s
.6089 .91774 m
.6089 .91781 L
s
.62933 .89903 m
.62933 .89907 L
s
.62922 .8988 m
.62922 .89872 L
s
.62933 .89907 m
.62933 .8991 L
s
.6089 .91781 m
.6089 .91788 L
s
.62933 .8991 m
.62934 .89913 L
s
.62934 .89913 m
.62934 .89916 L
s
.6089 .91788 m
.6089 .91795 L
s
.62934 .89916 m
.62934 .8992 L
s
.62921 .89889 m
.62922 .8988 L
s
.62934 .8992 m
.62934 .89923 L
s
.6089 .91795 m
.60891 .91802 L
s
.62934 .89923 m
.62934 .89926 L
s
.60524 .90742 m
.60559 .90761 L
s
.62934 .89926 m
.62934 .89929 L
s
.60891 .91802 m
.60891 .91809 L
s
.62934 .89929 m
.62934 .89933 L
s
.6292 .89898 m
.62921 .89889 L
s
.62934 .89933 m
.62934 .89936 L
s
.62934 .89936 m
.62934 .89939 L
s
.60891 .91809 m
.60891 .91816 L
s
.62934 .89939 m
.62934 .89942 L
s
.62934 .89942 m
.62934 .89945 L
s
.60891 .91816 m
.60891 .91823 L
s
.62919 .89909 m
.6292 .89898 L
s
.62934 .89945 m
.62935 .89948 L
s
.62935 .89948 m
.62935 .89951 L
s
.55236 .34227 m
.56321 .36267 L
s
.60891 .91823 m
.60891 .9183 L
s
.62935 .89951 m
.62935 .89954 L
s
.62935 .89954 m
.62935 .89957 L
s
.62935 .89957 m
.62935 .89959 L
s
.60891 .9183 m
.60891 .91837 L
s
.62918 .89919 m
.62919 .89909 L
s
.62935 .89959 m
.62935 .89962 L
s
.62935 .89962 m
.62935 .89965 L
s
.60891 .91837 m
.60892 .91844 L
s
.62935 .89965 m
.62935 .89968 L
s
.62935 .89968 m
.62935 .8997 L
s
.62935 .8997 m
.62935 .89973 L
s
.60892 .91844 m
.60892 .91851 L
s
.62935 .89973 m
.62935 .89976 L
s
.62916 .8993 m
.62918 .89919 L
s
.62935 .89976 m
.62936 .89978 L
s
.60892 .91851 m
.60892 .91858 L
s
.62936 .89978 m
.62936 .89981 L
s
.62936 .89981 m
.62936 .89984 L
s
.62936 .89984 m
.62936 .89986 L
s
.60892 .91858 m
.60892 .91865 L
s
.62936 .89986 m
.62936 .89989 L
s
.62936 .89989 m
.62936 .89991 L
s
.62915 .89941 m
.62916 .8993 L
s
.62936 .89991 m
.62936 .89993 L
s
.60892 .91865 m
.60892 .91872 L
s
.62936 .89993 m
.62936 .89996 L
s
.62936 .89996 m
.62936 .89998 L
s
.62936 .89998 m
.62936 .9 L
s
.60892 .91872 m
.60892 .91879 L
s
.62936 .9 m
.62936 .90003 L
s
.62936 .90003 m
.62936 .90005 L
s
.62936 .90005 m
.62936 .90007 L
s
.60892 .91879 m
.60893 .91886 L
s
.62936 .90007 m
.62936 .90009 L
s
.62914 .89954 m
.62915 .89941 L
s
.62936 .90009 m
.62936 .90011 L
s
.62936 .90011 m
.62937 .90013 L
s
.60893 .91886 m
.60893 .91894 L
s
.62937 .90013 m
.62937 .90015 L
s
.62937 .90015 m
.62937 .90017 L
s
.62937 .90017 m
.62937 .90019 L
s
.62937 .90019 m
.62937 .90021 L
s
.60893 .91894 m
.60893 .919 L
s
.62937 .90021 m
.62937 .90023 L
s
.60489 .90723 m
.60524 .90742 L
s
.62937 .90023 m
.62937 .90025 L
s
.62937 .90025 m
.62937 .90027 L
s
.62937 .90027 m
.62937 .90028 L
s
.62912 .89966 m
.62914 .89954 L
s
.60893 .919 m
.60893 .91908 L
s
.62937 .90028 m
.62937 .9003 L
s
.62937 .9003 m
.62937 .90032 L
s
.62937 .90032 m
.62937 .90034 L
s
.53835 .8721 m
.54157 .87381 L
s
.62937 .90034 m
.62937 .90035 L
s
.60893 .91908 m
.60893 .91915 L
s
.62937 .90035 m
.62937 .90037 L
s
.62937 .90037 m
.62937 .90039 L
s
.62937 .90039 m
.62937 .9004 L
s
.62937 .9004 m
.62937 .90042 L
s
.60893 .91915 m
.60893 .91922 L
s
.62937 .90042 m
.62937 .90043 L
s
.62937 .90043 m
.62938 .90045 L
s
.62938 .90045 m
.62938 .90046 L
s
.6291 .8998 m
.62912 .89966 L
s
.62938 .90046 m
.62938 .90048 L
s
.62938 .90048 m
.62938 .90049 L
s
.60893 .91922 m
.60894 .91929 L
s
.62938 .90049 m
.62938 .9005 L
s
.62938 .9005 m
.62938 .90052 L
s
.62938 .90052 m
.62938 .90053 L
s
.62938 .90053 m
.62938 .90055 L
s
.62938 .90055 m
.62938 .90056 L
s
.60894 .91929 m
.60894 .91936 L
s
.62938 .90056 m
.62938 .90057 L
s
.62938 .90057 m
.62938 .90058 L
s
.62938 .90058 m
.62938 .9006 L
s
.62938 .9006 m
.62938 .90061 L
s
.62938 .90061 m
.62938 .90062 L
s
.62938 .90062 m
.62938 .90063 L
s
.60894 .91936 m
.60894 .91943 L
s
.62938 .90063 m
.62938 .90064 L
s
.62938 .90064 m
.62938 .90065 L
s
.62938 .90065 m
.62938 .90066 L
s
.62938 .90066 m
.62938 .90067 L
s
.62938 .90067 m
.62938 .90068 L
s
.62908 .89993 m
.6291 .8998 L
s
.62938 .90068 m
.62938 .90069 L
s
.62938 .90069 m
.62938 .9007 L
s
.60894 .91943 m
.60894 .91951 L
s
.62938 .9007 m
.62938 .90071 L
s
.62938 .90071 m
.62938 .90072 L
s
.62938 .90072 m
.62938 .90073 L
s
.62938 .90073 m
.62938 .90074 L
s
.62938 .90074 m
.62938 .90075 L
s
.62938 .90075 m
.62938 .90076 L
s
.62938 .90076 m
.62938 .90077 L
s
.62938 .90077 m
.62939 .90078 L
s
.60894 .91951 m
.60894 .91958 L
s
.62939 .90078 m
.62939 .90078 L
s
.62939 .90078 m
.62939 .90079 L
s
.62939 .90079 m
.62939 .9008 L
s
.62939 .9008 m
.62939 .90081 L
s
.62939 .90081 m
.62939 .90082 L
s
.62939 .90082 m
.62939 .90082 L
s
.62939 .90082 m
.62939 .90083 L
s
.62939 .90083 m
.62939 .90084 L
s
.62939 .90084 m
.62939 .90084 L
s
.60894 .91958 m
.60894 .91965 L
s
.62939 .90084 m
.62939 .90085 L
s
.62939 .90085 m
.62939 .90086 L
s
.62939 .90086 m
.62939 .90087 L
s
.62939 .90087 m
.62939 .90087 L
s
.62939 .90087 m
.62939 .90088 L
s
.62939 .90088 m
.62939 .90088 L
s
.62939 .90088 m
.62939 .90089 L
s
.62939 .90089 m
.62939 .9009 L
s
.62905 .90008 m
.62908 .89993 L
s
.62939 .9009 m
.62939 .9009 L
s
.62939 .9009 m
.62939 .90091 L
s
.62939 .90091 m
.62939 .90091 L
s
.62939 .90091 m
.62939 .90092 L
s
.60894 .91965 m
.60895 .91972 L
s
.62939 .90092 m
.62939 .90092 L
s
.62939 .90092 m
.62939 .90093 L
s
.62939 .90093 m
.62939 .90093 L
s
.62939 .90093 m
.62939 .90094 L
s
.62939 .90094 m
.62939 .90094 L
s
.62939 .90094 m
.62939 .90095 L
s
.62939 .90095 m
.62939 .90095 L
s
.62939 .90095 m
.62939 .90096 L
s
.62939 .90096 m
.62939 .90096 L
s
.62939 .90096 m
.62939 .90097 L
s
.62939 .90097 m
.62939 .90097 L
s
.88407 .62409 m
.8849 .62531 L
s
.62939 .90097 m
.62939 .90097 L
s
.62939 .90097 m
.62939 .90098 L
s
.62939 .90098 m
.62939 .90098 L
s
.62939 .90098 m
.62939 .90099 L
s
.60895 .91972 m
.60895 .9198 L
s
.62939 .90099 m
.62939 .90099 L
s
.62939 .90099 m
.62939 .90099 L
s
.62939 .90099 m
.62939 .901 L
s
.62939 .901 m
.62939 .901 L
s
.62939 .901 m
.62939 .901 L
s
.62939 .901 m
.62939 .90101 L
s
.62939 .90101 m
.62939 .90101 L
s
.62939 .90101 m
.62939 .90101 L
s
.62939 .90101 m
.62939 .90102 L
s
.62939 .90102 m
.62939 .90102 L
s
.62939 .90102 m
.62939 .90102 L
s
.62939 .90102 m
.62939 .90103 L
s
.62939 .90103 m
.62939 .90103 L
s
.62939 .90103 m
.62939 .90103 L
s
.62939 .90103 m
.62939 .90103 L
s
.62939 .90103 m
.62939 .90104 L
s
.62939 .90104 m
.62939 .90104 L
s
.62939 .90104 m
.62939 .90104 L
s
.62939 .90104 m
.62939 .90105 L
s
.62939 .90105 m
.62939 .90105 L
s
.62939 .90105 m
.62939 .90105 L
s
.62939 .90105 m
.62939 .90105 L
s
.62939 .90105 m
.62939 .90105 L
s
.62939 .90105 m
.62939 .90106 L
s
.62939 .90106 m
.62939 .90106 L
s
.60895 .9198 m
.60895 .91986 L
s
.62939 .90106 m
.62939 .90106 L
s
.62939 .90106 m
.62939 .90106 L
s
.62939 .90106 m
.62939 .90107 L
s
.62939 .90107 m
.62939 .90107 L
s
.62939 .90107 m
.62939 .90107 L
s
.62939 .90107 m
.62939 .90107 L
s
.62939 .90107 m
.62939 .90107 L
s
.62939 .90107 m
.62939 .90108 L
s
.62939 .90108 m
.62939 .90108 L
s
.60895 .91986 m
.60895 .91994 L
s
.62903 .90022 m
.62905 .90008 L
s
.60446 .907 m
.60489 .90723 L
s
.60895 .91994 m
.60895 .92001 L
s
.60895 .92001 m
.60896 .92009 L
s
.60896 .92009 m
.60896 .92016 L
s
.629 .90038 m
.62903 .90022 L
s
.60896 .92016 m
.60896 .92023 L
s
.60896 .92023 m
.60896 .9203 L
s
.60896 .9203 m
.60896 .92038 L
s
.60896 .92038 m
.60896 .92045 L
s
.62897 .90053 m
.629 .90038 L
s
.60896 .92045 m
.60897 .92052 L
s
.60897 .92052 m
.60897 .92059 L
s
.60897 .92059 m
.60897 .92067 L
s
.60897 .92067 m
.60897 .92074 L
s
.62893 .9007 m
.62897 .90053 L
s
.57133 .88987 m
.57291 .89068 L
s
.60897 .92074 m
.60897 .92082 L
s
.60897 .92082 m
.60897 .92089 L
s
.60897 .92089 m
.60898 .92097 L
s
.60898 .92097 m
.60898 .92104 L
s
.62889 .90086 m
.62893 .9007 L
s
.60898 .92104 m
.60898 .92111 L
s
.60898 .92111 m
.60898 .92118 L
s
.60402 .90677 m
.60446 .907 L
s
.60898 .92118 m
.60898 .92126 L
s
.80882 .56063 m
.81318 .56747 L
s
.60898 .92126 m
.60899 .92133 L
s
.62884 .90105 m
.62889 .90086 L
s
.60899 .92133 m
.60899 .92141 L
s
.60899 .92141 m
.60899 .92148 L
s
.60899 .92148 m
.60899 .92156 L
s
.60899 .92156 m
.60899 .92163 L
s
.60899 .92163 m
.60899 .92171 L
s
.46853 .83114 m
.47544 .83508 L
s
.62879 .90122 m
.62884 .90105 L
s
.60899 .92171 m
.609 .92178 L
s
.609 .92178 m
.609 .92186 L
s
.609 .92186 m
.609 .92193 L
s
.609 .92193 m
.609 .92201 L
s
.88305 .62257 m
.88407 .62409 L
s
.609 .92201 m
.609 .92208 L
s
.62873 .90141 m
.62879 .90122 L
s
.609 .92208 m
.60901 .92216 L
s
.60901 .92216 m
.60901 .92223 L
s
.60901 .92223 m
.60901 .92231 L
s
.60901 .92231 m
.60901 .92239 L
s
.61556 .37607 m
.62614 .39724 L
s
.60349 .90649 m
.60402 .90677 L
s
.60901 .92239 m
.60901 .92247 L
s
.60901 .92247 m
.60901 .92254 L
s
.62867 .90159 m
.62873 .90141 L
s
.60901 .92254 m
.60902 .92262 L
s
.60902 .92262 m
.60902 .92269 L
s
.60902 .92269 m
.60902 .92277 L
s
.60902 .92277 m
.60902 .92284 L
s
.43253 .80805 m
.44171 .81353 L
s
.60902 .92284 m
.60902 .92292 L
s
.6286 .9018 m
.62867 .90159 L
s
.60902 .92292 m
.60903 .923 L
s
.84592 .59234 m
.84854 .59632 L
s
.60903 .923 m
.60903 .92308 L
s
.60903 .92308 m
.60903 .92315 L
s
.60903 .92315 m
.60903 .92323 L
s
.60903 .92323 m
.60903 .9233 L
s
.60903 .9233 m
.60903 .92339 L
s
.62852 .90199 m
.6286 .9018 L
s
.60903 .92339 m
.60904 .92346 L
s
.60904 .92346 m
.60904 .92354 L
s
.77009 .52558 m
.77579 .53479 L
s
.60904 .92354 m
.60904 .92361 L
s
.60904 .92361 m
.60904 .9237 L
s
.60904 .9237 m
.60904 .92377 L
s
.60904 .92377 m
.60905 .92385 L
s
.60296 .90622 m
.60349 .90649 L
s
.60905 .92385 m
.60905 .92393 L
s
.62843 .9022 m
.62852 .90199 L
s
.60905 .92393 m
.60905 .92401 L
s
.60905 .92401 m
.60905 .92408 L
s
.60905 .92408 m
.60905 .92416 L
s
.60905 .92416 m
.60906 .92424 L
s
.60906 .92424 m
.60906 .92432 L
s
.60906 .92432 m
.60906 .9244 L
s
.60906 .9244 m
.60906 .92448 L
s
.62833 .90239 m
.62843 .9022 L
s
.60906 .92448 m
.60906 .92455 L
s
.60906 .92455 m
.60906 .92464 L
s
.36024 .75658 m
.37255 .76487 L
s
.60906 .92464 m
.60907 .92471 L
s
.60907 .92471 m
.60907 .92479 L
s
.60907 .92479 m
.60907 .92487 L
s
.88203 .62105 m
.88305 .62257 L
s
.60907 .92487 m
.60907 .92495 L
s
.62822 .9026 m
.62833 .90239 L
s
.56934 .88885 m
.57133 .88987 L
s
.69008 .44741 m
.70016 .4652 L
s
.60231 .90588 m
.60296 .90622 L
s
.6281 .90279 m
.62822 .9026 L
s
.62796 .903 m
.6281 .90279 L
s
.501 .8509 m
.50635 .85381 L
s
.62781 .90319 m
.62796 .903 L
s
.60165 .90555 m
.60231 .90588 L
s
.50959 .32389 m
.52081 .32061 L
s
.53512 .8704 m
.53835 .8721 L
s
.62763 .90339 m
.62781 .90319 L
s
.88075 .61916 m
.88203 .62105 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64634 m
.91656 .64634 L
s
.91656 .64633 m
.91656 .64634 L
s
.91656 .64633 m
.91656 .64633 L
s
.91656 .64633 m
.91656 .64633 L
s
.91656 .64633 m
.91656 .64633 L
s
.91656 .64633 m
.91656 .64633 L
s
.91656 .64633 m
.91656 .64633 L
s
.91656 .64633 m
.91656 .64633 L
s
.91656 .64633 m
.91656 .64633 L
s
.91656 .64633 m
.91656 .64633 L
s
.91655 .64633 m
.91656 .64633 L
s
.91655 .64633 m
.91655 .64633 L
s
.91655 .64633 m
.91655 .64633 L
s
.91655 .64632 m
.91655 .64633 L
s
.91655 .64632 m
.91655 .64632 L
s
.91655 .64632 m
.91655 .64632 L
s
.91655 .64632 m
.91655 .64632 L
s
.91655 .64632 m
.91655 .64632 L
s
.91654 .64631 m
.91655 .64632 L
s
.91654 .64631 m
.91654 .64631 L
s
.91654 .64631 m
.91654 .64631 L
s
.91654 .6463 m
.91654 .64631 L
s
.91654 .6463 m
.91654 .6463 L
s
.91653 .6463 m
.91654 .6463 L
s
.91653 .64629 m
.91653 .6463 L
s
.91653 .64629 m
.91653 .64629 L
s
.91652 .64628 m
.91653 .64629 L
s
.91652 .64628 m
.91652 .64628 L
s
.91652 .64627 m
.91652 .64628 L
s
.91651 .64626 m
.91652 .64627 L
s
.91651 .64626 m
.91651 .64626 L
s
.9165 .64625 m
.91651 .64626 L
s
.91649 .64624 m
.9165 .64625 L
s
.91649 .64623 m
.91649 .64624 L
s
.91648 .64622 m
.91649 .64623 L
s
.91647 .64621 m
.91648 .64622 L
s
.91646 .64619 m
.91647 .64621 L
s
.91645 .64618 m
.91646 .64619 L
s
.91644 .64616 m
.91645 .64618 L
s
.91643 .64615 m
.91644 .64616 L
s
.91642 .64613 m
.91643 .64615 L
s
.62745 .90358 m
.62763 .90339 L
s
.9164 .64611 m
.91642 .64613 L
s
.91639 .64608 m
.9164 .64611 L
s
.91637 .64606 m
.91639 .64608 L
s
.91635 .64603 m
.91637 .64606 L
s
.91633 .646 m
.91635 .64603 L
s
.91631 .64597 m
.91633 .646 L
s
.91628 .64593 m
.91631 .64597 L
s
.91625 .64589 m
.91628 .64593 L
s
.91622 .64584 m
.91625 .64589 L
s
.60084 .90514 m
.60165 .90555 L
s
.91619 .64579 m
.91622 .64584 L
s
.91615 .64574 m
.91619 .64579 L
s
.91611 .64567 m
.91615 .64574 L
s
.62724 .90377 m
.62745 .90358 L
s
.91606 .64561 m
.91611 .64567 L
s
.91601 .64553 m
.91606 .64561 L
s
.91595 .64545 m
.91601 .64553 L
s
.8433 .58834 m
.84592 .59234 L
s
.91588 .64535 m
.91595 .64545 L
s
.28545 .69421 m
.29827 .70437 L
s
.91582 .64525 m
.91588 .64535 L
s
.91573 .64513 m
.91582 .64525 L
s
.62701 .90394 m
.62724 .90377 L
s
.56735 .88783 m
.56934 .88885 L
s
.91565 .64501 m
.91573 .64513 L
s
.91555 .64486 m
.91565 .64501 L
s
.91545 .64472 m
.91555 .64486 L
s
.62674 .90411 m
.62701 .90394 L
s
.87947 .61725 m
.88075 .61916 L
s
.55577 .55759 m
.56637 .54884 L
s
.60003 .90473 m
.60084 .90514 L
s
.91532 .64454 m
.91545 .64472 L
s
.9152 .64436 m
.91532 .64454 L
s
.63655 .36851 m
.64693 .38646 L
s
.80443 .55372 m
.80882 .56063 L
s
.72218 .46994 m
.73204 .48672 L
s
.91505 .64413 m
.9152 .64436 L
s
.62647 .90426 m
.62674 .90411 L
s
.39162 .78032 m
.40374 .78788 L
s
.91489 .64391 m
.91505 .64413 L
s
.91471 .64364 m
.91489 .64391 L
s
.62613 .90441 m
.62647 .90426 L
s
.91452 .64337 m
.91471 .64364 L
s
.59903 .90423 m
.60003 .90473 L
s
.91429 .64304 m
.91452 .64337 L
s
.91406 .6427 m
.91429 .64304 L
s
.6258 .90453 m
.62613 .90441 L
s
.87787 .61487 m
.87947 .61725 L
s
.54141 .32171 m
.55236 .34227 L
s
.91378 .64229 m
.91406 .6427 L
s
.56484 .88657 m
.56735 .88783 L
s
.62538 .90464 m
.6258 .90453 L
s
.53099 .86826 m
.53512 .8704 L
s
.9135 .64188 m
.91378 .64229 L
s
.59802 .90373 m
.59903 .90423 L
s
.76262 .51342 m
.77009 .52558 L
s
.83995 .58324 m
.8433 .58834 L
s
.91316 .64138 m
.9135 .64188 L
s
.62497 .90472 m
.62538 .90464 L
s
.60486 .35381 m
.61556 .37607 L
s
.91281 .64088 m
.91316 .64138 L
s
.55105 .27757 m
.56191 .29197 L
s
.46154 .82724 m
.46853 .83114 L
s
.91238 .64026 m
.91281 .64088 L
s
.62445 .90479 m
.62497 .90472 L
s
.87626 .61248 m
.87787 .61487 L
s
.59677 .90311 m
.59802 .90373 L
s
.49561 .84802 m
.501 .8509 L
s
.91196 .63963 m
.91238 .64026 L
s
.2418 .65273 m
.2549 .66428 L
s
.62394 .90482 m
.62445 .90479 L
s
.91143 .63887 m
.91196 .63963 L
s
.31641 .72218 m
.3291 .73131 L
s
.79883 .54488 m
.80443 .55372 L
s
.59551 .9025 m
.59677 .90311 L
s
.6233 .90483 m
.62394 .90482 L
s
.56233 .88531 m
.56484 .88657 L
s
.9109 .6381 m
.91143 .63887 L
s
.87423 .60946 m
.87626 .61248 L
s
.67986 .42882 m
.69008 .44741 L
s
.91025 .63715 m
.9109 .6381 L
s
.42322 .80264 m
.43253 .80805 L
s
.62266 .9048 m
.6233 .90483 L
s
.83658 .57809 m
.83995 .58324 L
s
.59395 .90174 m
.59551 .9025 L
s
.9096 .6362 m
.91025 .63715 L
s
.62187 .90473 m
.62266 .9048 L
s
.52684 .86614 m
.53099 .86826 L
s
.90879 .63503 m
.9096 .6362 L
s
.8722 .60644 m
.87423 .60946 L
s
.55913 .88373 m
.56233 .88531 L
s
.62108 .90462 m
.62187 .90473 L
s
.59238 .90098 m
.59395 .90174 L
s
.90799 .63385 m
.90879 .63503 L
s
.62603 .35016 m
.63655 .36851 L
s
.53035 .30258 m
.54141 .32171 L
s
.34771 .74836 m
.36024 .75658 L
s
.71219 .45281 m
.72218 .46994 L
s
.62009 .90445 m
.62108 .90462 L
s
.59406 .33095 m
.60486 .35381 L
s
.90698 .63238 m
.90799 .63385 L
s
.75507 .501 m
.76262 .51342 L
s
.83227 .57149 m
.83658 .57809 L
s
.48873 .84443 m
.49561 .84802 L
s
.86962 .60259 m
.8722 .60644 L
s
.59041 .90004 m
.59238 .90098 L
s
.6191 .90424 m
.62009 .90445 L
s
.27242 .68398 m
.28545 .69421 L
s
.79318 .53591 m
.79883 .54488 L
s
.90598 .63092 m
.90698 .63238 L
s
.45239 .82227 m
.46154 .82724 L
s
.52152 .86348 m
.52684 .86614 L
s
.55592 .88216 m
.55913 .88373 L
s
.61788 .90394 m
.6191 .90424 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65586 m
.94075 .65586 L
s
.94075 .65585 m
.94075 .65586 L
s
.94075 .65585 m
.94075 .65585 L
s
.94075 .65585 m
.94075 .65585 L
s
.94075 .65585 m
.94075 .65585 L
s
.94074 .65585 m
.94075 .65585 L
s
.94074 .65585 m
.94074 .65585 L
s
.94074 .65585 m
.94074 .65585 L
s
.94074 .65585 m
.94074 .65585 L
s
.94074 .65584 m
.94074 .65585 L
s
.94074 .65584 m
.94074 .65584 L
s
.94074 .65584 m
.94074 .65584 L
s
.94074 .65584 m
.94074 .65584 L
s
.94073 .65584 m
.94074 .65584 L
s
.94073 .65583 m
.94073 .65584 L
s
.94073 .65583 m
.94073 .65583 L
s
.94073 .65583 m
.94073 .65583 L
s
.94073 .65582 m
.94073 .65583 L
s
.94072 .65582 m
.94073 .65582 L
s
.94072 .65581 m
.94072 .65582 L
s
.94072 .65581 m
.94072 .65581 L
s
.94071 .6558 m
.94072 .65581 L
s
.94071 .6558 m
.94071 .6558 L
s
.9407 .65579 m
.94071 .6558 L
s
.9407 .65578 m
.9407 .65579 L
s
.94069 .65578 m
.9407 .65578 L
s
.94069 .65577 m
.94069 .65578 L
s
.94068 .65576 m
.94069 .65577 L
s
.94067 .65575 m
.94068 .65576 L
s
.90472 .62908 m
.90598 .63092 L
s
.94066 .65574 m
.94067 .65575 L
s
.94066 .65572 m
.94066 .65574 L
s
.94065 .65571 m
.94066 .65572 L
s
.94064 .65569 m
.94065 .65571 L
s
.94062 .65568 m
.94064 .65569 L
s
.94061 .65566 m
.94062 .65568 L
s
.9406 .65564 m
.94061 .65566 L
s
.94058 .65562 m
.9406 .65564 L
s
.94056 .65559 m
.94058 .65562 L
s
.94055 .65556 m
.94056 .65559 L
s
.94053 .65554 m
.94055 .65556 L
s
.9405 .6555 m
.94053 .65554 L
s
.94048 .65547 m
.9405 .6555 L
s
.94045 .65543 m
.94048 .65547 L
s
.94042 .65538 m
.94045 .65543 L
s
.94038 .65533 m
.94042 .65538 L
s
.94035 .65528 m
.94038 .65533 L
s
.94031 .65522 m
.94035 .65528 L
s
.94026 .65516 m
.94031 .65522 L
s
.94021 .65508 m
.94026 .65516 L
s
.3793 .77286 m
.39162 .78032 L
s
.94015 .655 m
.94021 .65508 L
s
.94009 .65491 m
.94015 .655 L
s
.58844 .89911 m
.59041 .90004 L
s
.94002 .65481 m
.94009 .65491 L
s
.93994 .6547 m
.94002 .65481 L
s
.93986 .65458 m
.93994 .6547 L
s
.93976 .65444 m
.93986 .65458 L
s
.86704 .59873 m
.86962 .60259 L
s
.93966 .6543 m
.93976 .65444 L
s
.93954 .65412 m
.93966 .6543 L
s
.93942 .65395 m
.93954 .65412 L
s
.61664 .90361 m
.61788 .90394 L
s
.90346 .62725 m
.90472 .62908 L
s
.93927 .65373 m
.93942 .65395 L
s
.66949 .40945 m
.67986 .42882 L
s
.54003 .26284 m
.55105 .27757 L
s
.93912 .65352 m
.93927 .65373 L
s
.93893 .65326 m
.93912 .65352 L
s
.93875 .653 m
.93893 .65326 L
s
.93853 .65267 m
.93875 .653 L
s
.82794 .56482 m
.83227 .57149 L
s
.22851 .64102 m
.2418 .65273 L
s
.9383 .65235 m
.93853 .65267 L
s
.58595 .89795 m
.58844 .89911 L
s
.90189 .62495 m
.90346 .62725 L
s
.93803 .65196 m
.9383 .65235 L
s
.61511 .90316 m
.61664 .90361 L
s
.58317 .30804 m
.59406 .33095 L
s
.93775 .65156 m
.93803 .65196 L
s
.55183 .88019 m
.55592 .88216 L
s
.41111 .79584 m
.42322 .80264 L
s
.93741 .65108 m
.93775 .65156 L
s
.86374 .5938 m
.86704 .59873 L
s
.3035 .71309 m
.31641 .72218 L
s
.93707 .65059 m
.93741 .65108 L
s
.78579 .52411 m
.79318 .53591 L
s
.74528 .48468 m
.75507 .501 L
s
.93665 .64999 m
.93707 .65059 L
s
.51916 .28652 m
.53035 .30258 L
s
.61538 .33115 m
.62603 .35016 L
s
.9003 .62264 m
.90189 .62495 L
s
.61356 .90267 m
.61511 .90316 L
s
.93624 .64939 m
.93665 .64999 L
s
.48178 .8409 m
.48873 .84443 L
s
.51616 .86086 m
.52152 .86348 L
s
.70208 .43526 m
.71219 .45281 L
s
.93572 .64865 m
.93624 .64939 L
s
.58346 .89679 m
.58595 .89795 L
s
.49804 .32933 m
.50959 .32389 L
s
.9352 .64791 m
.93572 .64865 L
s
.89831 .61973 m
.9003 .62264 L
s
.93456 .647 m
.9352 .64791 L
s
.61163 .90203 m
.61356 .90267 L
s
.82241 .55629 m
.82794 .56482 L
s
.93393 .64608 m
.93456 .647 L
s
.86042 .58883 m
.86374 .5938 L
s
.54771 .87825 m
.55183 .88019 L
s
.4431 .8174 m
.45239 .82227 L
s
.54484 .56222 m
.55577 .55759 L
s
.93313 .64495 m
.93393 .64608 L
s
.33497 .74022 m
.34771 .74836 L
s
.58029 .89534 m
.58346 .89679 L
s
.65899 .38934 m
.66949 .40945 L
s
.5722 .28561 m
.58317 .30804 L
s
.89631 .61681 m
.89831 .61973 L
s
.60968 .90135 m
.61163 .90203 L
s
.25918 .67371 m
.27242 .68398 L
s
.93234 .64381 m
.93313 .64495 L
s
.93136 .6424 m
.93234 .64381 L
s
.50932 .8576 m
.51616 .86086 L
s
.77832 .51208 m
.78579 .52411 L
s
.85618 .58246 m
.86042 .58883 L
s
.89378 .61311 m
.89631 .61681 L
s
.60723 .90046 m
.60968 .90135 L
s
.93037 .64098 m
.93136 .6424 L
s
.52885 .24831 m
.54003 .26284 L
s
.36676 .76554 m
.3793 .77286 L
s
.57711 .89391 m
.58029 .89534 L
s
.47266 .83642 m
.48178 .8409 L
s
.54243 .87581 m
.54771 .87825 L
s
.6046 .31134 m
.61538 .33115 L
s
.81684 .54765 m
.82241 .55629 L
s
.21501 .62913 m
.22851 .64102 L
s
.92914 .63922 m
.93037 .64098 L
s
.73534 .46786 m
.74528 .48468 L
s
.69182 .41725 m
.70208 .43526 L
s
.50779 .27469 m
.51916 .28652 L
s
.89124 .60939 m
.89378 .61311 L
s
.9279 .63745 m
.92914 .63922 L
s
.60477 .89954 m
.60723 .90046 L
s
.39879 .7892 m
.41111 .79584 L
s
.29037 .70404 m
.3035 .71309 L
s
.56114 .26403 m
.5722 .28561 L
s
.92636 .63524 m
.9279 .63745 L
s
.57305 .89211 m
.57711 .89391 L
s
.85191 .57604 m
.85618 .58246 L
s
.64837 .36859 m
.65899 .38934 L
s
.888 .60464 m
.89124 .60939 L
s
.43103 .81133 m
.4431 .8174 L
s
.60165 .89835 m
.60477 .89954 L
s
.92481 .63301 m
.92636 .63524 L
s
.80954 .53628 m
.81684 .54765 L
s
.76863 .49634 m
.77832 .51208 L
s
.53711 .8734 m
.54243 .87581 L
s
.50241 .8544 m
.50932 .8576 L
s
.92285 .63022 m
.92481 .63301 L
s
.322 .73221 m
.33497 .74022 L
s
.59369 .29067 m
.6046 .31134 L
s
.24571 .66341 m
.25918 .67371 L
s
.56897 .89033 m
.57305 .89211 L
s
.84646 .56783 m
.85191 .57604 L
s
.88473 .59986 m
.888 .60464 L
s
.5985 .89713 m
.60165 .89835 L
s
.72527 .45053 m
.73534 .46786 L
s
.68143 .39869 m
.69182 .41725 L
s
.54999 .24351 m
.56114 .26403 L
s
.46341 .83205 m
.47266 .83642 L
s
.5175 .23485 m
.52885 .24831 L
s
.92089 .62741 m
.92285 .63022 L
s
.63762 .34729 m
.64837 .36859 L
s
.20132 .61706 m
.21501 .62913 L
s
.35398 .75838 m
.36676 .76554 L
s
.53032 .87043 m
.53711 .8734 L
s
.91841 .62385 m
.92089 .62741 L
s
.88056 .59374 m
.88473 .59986 L
s
.59449 .89556 m
.5985 .89713 L
s
.56373 .8881 m
.56897 .89033 L
s
.80216 .5247 m
.80954 .53628 L
s
.49618 .26734 m
.50779 .27469 L
s
.48614 .33553 m
.49804 .32933 L
s
.49334 .85036 m
.50241 .8544 L
s
.53361 .56297 m
.54484 .56222 L
s
.27701 .69507 m
.29037 .70404 L
s
.84097 .55952 m
.84646 .56783 L
s
.38625 .78275 m
.39879 .7892 L
s
.58265 .26927 m
.59369 .29067 L
s
.75879 .48019 m
.76863 .49634 L
s
.91591 .62027 m
.91841 .62385 L
s
.53872 .22422 m
.54999 .24351 L
s
.87636 .58757 m
.88056 .59374 L
s
.41873 .80547 m
.43103 .81133 L
s
.6709 .37949 m
.68143 .39869 L
s
.62676 .32552 m
.63762 .34729 L
s
.59046 .89398 m
.59449 .89556 L
s
.71505 .43265 m
.72527 .45053 L
s
.91273 .61572 m
.91591 .62027 L
s
.23203 .65309 m
.24571 .66341 L
s
.55845 .88591 m
.56373 .8881 L
s
.30879 .72434 m
.322 .73221 L
s
.45138 .82666 m
.46341 .83205 L
s
.52345 .86752 m
.53032 .87043 L
s
.83377 .5486 m
.84097 .55952 L
s
.79258 .50957 m
.80216 .5247 L
s
.50595 .22338 m
.5175 .23485 L
s
.18742 .60481 m
.20132 .61706 L
s
.57149 .24738 m
.58265 .26927 L
s
.87101 .57969 m
.87636 .58757 L
s
.90953 .61113 m
.91273 .61572 L
s
.58528 .89196 m
.59046 .89398 L
s
.48414 .84646 m
.49334 .85036 L
s
.34096 .75143 m
.35398 .75838 L
s
.74882 .4636 m
.75879 .48019 L
s
.61579 .3033 m
.62676 .32552 L
s
.55172 .88319 m
.55845 .88591 L
s
.66022 .35958 m
.6709 .37949 L
s
.52732 .20643 m
.53872 .22422 L
s
.2634 .68621 m
.27701 .69507 L
s
.70468 .4142 m
.71505 .43265 L
s
.90544 .60527 m
.90953 .61113 L
s
.51444 .86386 m
.52345 .86752 L
s
.37346 .77654 m
.38625 .78275 L
s
.48427 .26381 m
.49618 .26734 L
s
.8265 .5375 m
.83377 .5486 L
s
.63867 .9715 m
.64039 .97728 L
s
.63699 .96682 m
.63867 .9715 L
s
.64039 .97728 m
.64181 .98303 L
s
.63491 .96206 m
.63699 .96682 L
s
.8656 .57173 m
.87101 .57969 L
s
.58007 .88993 m
.58528 .89196 L
s
.64181 .98303 m
.64328 .9902 L
s
.56022 .22538 m
.57149 .24738 L
s
.63286 .95815 m
.63491 .96206 L
s
.40619 .79986 m
.41873 .80547 L
s
.64328 .9902 m
.64451 .99742 L
s
.2181 .6428 m
.23203 .65309 L
s
.78286 .49405 m
.79258 .50957 L
s
.63031 .95409 m
.63286 .95815 L
s
.52212 .5602 m
.53361 .56297 L
s
.6047 .28063 m
.61579 .3033 L
s
.90132 .59937 m
.90544 .60527 L
s
.29532 .71667 m
.30879 .72434 L
s
.64451 .99742 m
.64581 1.00646 L
s
.17331 .59238 m
.18742 .60481 L
s
.62777 .95069 m
.63031 .95409 L
s
.43912 .82152 m
.45138 .82666 L
s
.5449 .88054 m
.55172 .88319 L
s
.73869 .44653 m
.74882 .4636 L
s
.64941 .33888 m
.66022 .35958 L
s
.49416 .2145 m
.50595 .22338 L
s
.47217 .84168 m
.48414 .84646 L
s
.64653 1.01235 m
.64581 1.00646 L
s
.47391 .34115 m
.48614 .33553 L
s
.62457 .94706 m
.62777 .95069 L
s
.69417 .39516 m
.70468 .4142 L
s
.85853 .56129 m
.8656 .57173 L
s
.51576 .19058 m
.52732 .20643 L
s
.5734 .88739 m
.58007 .88993 L
s
.81705 .52302 m
.8265 .5375 L
s
.54885 .20371 m
.56022 .22538 L
s
.32769 .74473 m
.34096 .75143 L
s
.89606 .59184 m
.90132 .59937 L
s
.62138 .94394 m
.62457 .94706 L
s
.5053 .86033 m
.51444 .86386 L
s
.24954 .67751 m
.2634 .68621 L
s
.59351 .25751 m
.6047 .28063 L
s
.77299 .47814 m
.78286 .49405 L
s
.36042 .77061 m
.37346 .77654 L
s
.61731 .94049 m
.62138 .94394 L
s
.63845 .31737 m
.64941 .33888 L
s
.53596 .87719 m
.5449 .88054 L
s
.20392 .63254 m
.2181 .6428 L
s
.72842 .42895 m
.73869 .44653 L
s
.15899 .57976 m
.17331 .59238 L
s
.68351 .37549 m
.69417 .39516 L
s
.85137 .5507 m
.85853 .56129 L
s
.56667 .88487 m
.5734 .88739 L
s
.89076 .58425 m
.89606 .59184 L
s
.39341 .79453 m
.40619 .79986 L
s
.53736 .18287 m
.54885 .20371 L
s
.28159 .70925 m
.29532 .71667 L
s
.47203 .26278 m
.48427 .26381 L
s
.61324 .93742 m
.61731 .94049 L
s
.5822 .23396 m
.59351 .25751 L
s
.42661 .81667 m
.43912 .82152 L
s
.50527 .17839 m
.51576 .19058 L
s
.80746 .50822 m
.81705 .52302 L
s
.51038 .55438 m
.52212 .5602 L
s
.45996 .83716 m
.47217 .84168 L
s
.4834 .20878 m
.49416 .2145 L
s
.4934 .85603 m
.5053 .86033 L
s
.62736 .29502 m
.63845 .31737 L
s
.60803 .93388 m
.61324 .93742 L
s
.31415 .73833 m
.32769 .74473 L
s
.76297 .4618 m
.77299 .47814 L
s
.88382 .5743 m
.89076 .58425 L
s
.2354 .66901 m
.24954 .67751 L
s
.67271 .35514 m
.68351 .37549 L
s
.57079 .21013 m
.5822 .23396 L
s
.55783 .88165 m
.56667 .88487 L
s
.84208 .53692 m
.85137 .5507 L
s
.71799 .4108 m
.72842 .42895 L
s
.52689 .87395 m
.53596 .87719 L
s
.52698 .16542 m
.53736 .18287 L
s
.34711 .76501 m
.36042 .77061 L
s
.18948 .62238 m
.20392 .63254 L
s
.14444 .56694 m
.15899 .57976 L
s
.60279 .9306 m
.60803 .93388 L
s
.46135 .34515 m
.47391 .34115 L
s
.61613 .27184 m
.62736 .29502 L
s
.79773 .49307 m
.80746 .50822 L
s
.49459 .16827 m
.50527 .17839 L
s
.38037 .78954 m
.39341 .79453 L
s
.26758 .70214 m
.28159 .70925 L
s
.55928 .18625 m
.57079 .21013 L
s
.8768 .56424 m
.88382 .5743 L
s
.66177 .33406 m
.67271 .35514 L
s
.41386 .81213 m
.42661 .81667 L
s
.75279 .44499 m
.76297 .4618 L
s
.51648 .14951 m
.52698 .16542 L
s
.70741 .39204 m
.71799 .4108 L
s
.59611 .92668 m
.60279 .9306 L
s
.49844 .54606 m
.51038 .55438 L
s
.44751 .83293 m
.45996 .83716 L
s
.48127 .85197 m
.4934 .85603 L
s
.47238 .20475 m
.4834 .20878 L
s
.83265 .52287 m
.84208 .53692 L
s
.54885 .87848 m
.55783 .88165 L
s
.60479 .24785 m
.61613 .27184 L
s
.51508 .86994 m
.52689 .87395 L
s
.30032 .73229 m
.31415 .73833 L
s
.4608 .26277 m
.47203 .26278 L
s
.22097 .66078 m
.2354 .66901 L
s
.54891 .16521 m
.55928 .18625 L
s
.13126 .55532 m
.14444 .56694 L
s
.17476 .61236 m
.18948 .62238 L
s
.78784 .47756 m
.79773 .49307 L
s
.65068 .31218 m
.66177 .33406 L
s
.33351 .75979 m
.34711 .76501 L
s
.86769 .55118 m
.8768 .56424 L
s
.58936 .92289 m
.59611 .92668 L
s
.4837 .16016 m
.49459 .16827 L
s
.59333 .2231 m
.60479 .24785 L
s
.74246 .42769 m
.75279 .44499 L
s
.50583 .13548 m
.51648 .14951 L
s
.69667 .3726 m
.70741 .39204 L
s
.25326 .69541 m
.26758 .70214 L
s
.36705 .78493 m
.38037 .78954 L
s
.53845 .14483 m
.54891 .16521 L
s
.82307 .50854 m
.83265 .52287 L
s
.53717 .87448 m
.54885 .87848 L
s
.40084 .80794 m
.41386 .81213 L
s
.48629 .5358 m
.49844 .54606 L
s
.63945 .28942 m
.65068 .31218 L
s
.11789 .54354 m
.13126 .55532 L
s
.43481 .829 m
.44751 .83293 L
s
.58175 .19769 m
.59333 .2231 L
s
.20623 .65291 m
.22097 .66078 L
s
.44848 .34689 m
.46135 .34515 L
s
.58051 .91802 m
.58936 .92289 L
s
.46889 .84815 m
.48127 .85197 L
s
.28619 .72669 m
.30032 .73229 L
s
.50304 .86607 m
.51508 .86994 L
s
.77779 .46166 m
.78784 .47756 L
s
.46109 .20179 m
.47238 .20475 L
s
.52789 .12559 m
.53845 .14483 L
s
.68577 .35244 m
.69667 .3726 L
s
.15974 .60255 m
.17476 .61236 L
s
.85843 .53792 m
.86769 .55118 L
s
.73197 .40985 m
.74246 .42769 L
s
.495 .12352 m
.50583 .13548 L
s
.44931 .26266 m
.4608 .26277 L
s
.31962 .75504 m
.33351 .75979 L
s
.57133 .17459 m
.58175 .19769 L
s
.62807 .26572 m
.63945 .28942 L
s
.47257 .15373 m
.4837 .16016 L
s
.81333 .49392 m
.82307 .50854 L
s
.23862 .68915 m
.25326 .69541 L
s
.35344 .78077 m
.36705 .78493 L
s
.10433 .5316 m
.11789 .54354 L
s
.51722 .10796 m
.52789 .12559 L
s
.57153 .91306 m
.58051 .91802 L
s
.67471 .33147 m
.68577 .35244 L
s
.47395 .52411 m
.48629 .5358 L
s
.56082 .15134 m
.57133 .17459 L
s
.52526 .8705 m
.53717 .87448 L
s
.76759 .44535 m
.77779 .46166 L
s
.38753 .80416 m
.40084 .80794 L
s
.72131 .39142 m
.73197 .40985 L
s
.61656 .24103 m
.62807 .26572 L
s
.19115 .64551 m
.20623 .65291 L
s
.42183 .82542 m
.43481 .829 L
s
.84903 .52445 m
.85843 .53792 L
s
.45626 .84459 m
.46889 .84815 L
s
.27173 .72163 m
.28619 .72669 L
s
.49075 .8623 m
.50304 .86607 L
s
.14605 .59405 m
.15974 .60255 L
s
.49138 .12002 m
.495 .12352 L
s
.55024 .12829 m
.56082 .15134 L
s
.44954 .19923 m
.46109 .20179 L
s
.51366 .10256 m
.51722 .10796 L
s
.80345 .47899 m
.81333 .49392 L
s
.6635 .30962 m
.67471 .33147 L
s
.09059 .51949 m
.10433 .5316 L
s
.48774 .11673 m
.49138 .12002 L
s
.60493 .2153 m
.61656 .24103 L
s
.30541 .75081 m
.31962 .75504 L
s
.43676 .34632 m
.44848 .34689 L
s
.55985 .90638 m
.57153 .91306 L
s
.46884 .15188 m
.47257 .15373 L
s
.51009 .09738 m
.51366 .10256 L
s
.43756 .26179 m
.44931 .26266 L
s
.75722 .42858 m
.76759 .44535 L
s
.7105 .37234 m
.72131 .39142 L
s
.53958 .10591 m
.55024 .12829 L
s
.22361 .6835 m
.23862 .68915 L
s
.46142 .51141 m
.47395 .52411 L
s
.33951 .7771 m
.35344 .78077 L
s
.48407 .11363 m
.48774 .11673 L
s
.50651 .09244 m
.51009 .09738 L
s
.83948 .51077 m
.84903 .52445 L
s
.5131 .86648 m
.52526 .8705 L
s
.46508 .15015 m
.46884 .15188 L
s
.59443 .19144 m
.60493 .2153 L
s
.37393 .80081 m
.38753 .80416 L
s
.13207 .5859 m
.14605 .59405 L
s
.65213 .28679 m
.6635 .30962 L
s
.17569 .63871 m
.19115 .64551 L
s
.5047 .09003 m
.50651 .09244 L
s
.40858 .82217 m
.42183 .82542 L
s
.48223 .11213 m
.48407 .11363 L
s
.53605 .09877 m
.53958 .10591 L
s
.44336 .84126 m
.45626 .84459 L
s
.25691 .7172 m
.27173 .72163 L
s
.47822 .85856 m
.49075 .8623 L
s
.08601 .51545 m
.09059 .51949 L
s
.5029 .08767 m
.5047 .09003 L
s
.7934 .46373 m
.80345 .47899 L
s
.48038 .11068 m
.48223 .11213 L
s
.5325 .09178 m
.53605 .09877 L
s
.46129 .1485 m
.46508 .15015 L
s
.69951 .35255 m
.7105 .37234 L
s
.58384 .16684 m
.59443 .19144 L
s
1 0 0 r
.5029 .08767 m
.52538 .07829 L
s
.48038 .11068 m
.5029 .08767 L
s
0 g
.74669 .41132 m
.75722 .42858 L
s
1 0 0 r
.45747 .14689 m
.48038 .11068 L
s
0 g
.52894 .08497 m
.5325 .09178 L
s
.08141 .5114 m
.08601 .51545 L
s
.54796 .89899 m
.55985 .90638 L
s
.44567 .19836 m
.44954 .19923 L
s
.29085 .7472 m
.30541 .75081 L
s
.6406 .26289 m
.65213 .28679 L
s
.44869 .498 m
.46142 .51141 L
s
.52716 .08161 m
.52894 .08497 L
s
.57318 .14162 m
.58384 .16684 L
s
.45938 .14769 m
.46129 .1485 L
s
.07678 .50732 m
.08141 .5114 L
s
.52538 .07829 m
.52716 .08161 L
s
.42483 .34379 m
.43676 .34632 L
s
.20822 .67858 m
.22361 .6835 L
s
.82977 .49687 m
.83948 .51077 L
s
1 0 0 r
.52538 .07829 m
.54816 .08257 L
s
0 g
.42557 .25975 m
.43756 .26179 L
s
.32526 .77398 m
.33951 .7771 L
s
.45747 .14689 m
.45938 .14769 L
s
.11778 .57823 m
.13207 .5859 L
s
.07447 .50528 m
.07678 .50732 L
s
.44177 .19745 m
.44567 .19836 L
s
.50071 .86229 m
.5131 .86648 L
s
.68835 .33196 m
.69951 .35255 L
s
.78319 .44813 m
.7934 .46373 L
s
.56244 .11606 m
.57318 .14162 L
s
1 0 0 r
.43389 .19547 m
.45747 .14689 L
s
0 g
.07214 .50323 m
.07447 .50528 L
s
.16153 .6333 m
.17569 .63871 L
s
.36002 .79792 m
.37393 .80081 L
s
.62893 .23781 m
.6406 .26289 L
s
.73598 .39352 m
.74669 .41132 L
s
1 0 0 r
.07214 .50323 m
.08316 .56337 L
s
0 g
.39503 .81926 m
.40858 .82217 L
s
.43019 .83812 m
.44336 .84126 L
s
.46542 .85477 m
.47822 .85856 L
s
.24171 .71353 m
.25691 .7172 L
s
.43785 .19649 m
.44177 .19745 L
s
.55888 .10763 m
.56244 .11606 L
s
.53584 .89042 m
.54796 .89899 L
s
.55532 .09923 m
.55888 .10763 L
s
.43576 .48411 m
.44869 .498 L
s
.81991 .48274 m
.82977 .49687 L
s
.55174 .09087 m
.55532 .09923 L
s
.61837 .2143 m
.62893 .23781 L
s
.67702 .31047 m
.68835 .33196 L
s
.27591 .74431 m
.29085 .7472 L
s
.54995 .08671 m
.55174 .09087 L
s
.43587 .19599 m
.43785 .19649 L
s
.54816 .08257 m
.54995 .08671 L
s
.10313 .5712 m
.11778 .57823 L
s
.77281 .43216 m
.78319 .44813 L
s
1 0 0 r
.54816 .08257 m
.57163 .10015 L
s
0 g
.1924 .67458 m
.20822 .67858 L
s
.7251 .37514 m
.73598 .39352 L
s
.4127 .33945 m
.42483 .34379 L
s
.43389 .19547 m
.43587 .19599 L
s
.31065 .77149 m
.32526 .77398 L
s
.6077 .1897 m
.61837 .2143 L
s
.14701 .6287 m
.16153 .6333 L
s
.48806 .85772 m
.50071 .86229 L
s
.42156 .25879 m
.42557 .25975 L
s
1 0 0 r
.40939 .25504 m
.43389 .19547 L
s
0 g
.34578 .79551 m
.36002 .79792 L
s
.66552 .28797 m
.67702 .31047 L
s
.38117 .81667 m
.39503 .81926 L
s
.42262 .46986 m
.43576 .48411 L
s
.45237 .85078 m
.46542 .85477 L
s
.41673 .83508 m
.43019 .83812 L
s
.52352 .88005 m
.53584 .89042 L
s
.59694 .16395 m
.6077 .1897 L
s
.22608 .71077 m
.24171 .71353 L
s
.80989 .46838 m
.81991 .48274 L
s
.41753 .25768 m
.42156 .25879 L
s
.71405 .35609 m
.7251 .37514 L
s
.76226 .41579 m
.77281 .43216 L
s
.09821 .56907 m
.10313 .5712 L
s
.58608 .13707 m
.59694 .16395 L
s
.26058 .74223 m
.27591 .74431 L
s
.65385 .26431 m
.66552 .28797 L
s
.41347 .25641 m
.41753 .25768 L
s
.17787 .67196 m
.1924 .67458 L
s
.40038 .33351 m
.4127 .33945 L
s
.09325 .56705 m
.09821 .56907 L
s
.13206 .62513 m
.14701 .6287 L
s
.58248 .12797 m
.58608 .13707 L
s
.47517 .85243 m
.48806 .85772 L
s
.57887 .11878 m
.58248 .12797 L
s
.29567 .76966 m
.31065 .77149 L
s
.41071 .45688 m
.42262 .46986 L
s
.57525 .1095 m
.57887 .11878 L
s
.511 .86709 m
.52352 .88005 L
s
.41144 .25574 m
.41347 .25641 L
s
.7997 .45379 m
.80989 .46838 L
s
.70281 .3363 m
.71405 .35609 L
s
.57344 .10483 m
.57525 .1095 L
s
.08823 .56516 m
.09325 .56705 L
s
.57163 .10015 m
.57344 .10483 L
s
.33119 .79358 m
.34578 .79551 L
s
1 0 0 r
.57163 .10015 m
.59612 .13028 L
s
0 g
.75153 .39899 m
.76226 .41579 L
s
.64327 .24207 m
.65385 .26431 L
s
.43905 .84639 m
.45237 .85078 L
s
.40939 .25504 m
.41144 .25574 L
s
.367 .81433 m
.38117 .81667 L
s
.40298 .832 m
.41673 .83508 L
s
.20999 .70909 m
.22608 .71077 L
s
1 0 0 r
.38383 .3236 m
.40939 .25504 L
s
0 g
.0857 .56425 m
.08823 .56516 L
s
.08316 .56337 m
.0857 .56425 L
s
.63256 .21863 m
.64327 .24207 L
s
.39861 .44369 m
.41071 .45688 L
s
.69139 .31568 m
.70281 .3363 L
s
1 0 0 r
.08316 .56337 m
.09538 .62262 L
s
0 g
.24481 .74106 m
.26058 .74223 L
s
.1629 .67045 m
.17787 .67196 L
s
.49831 .85065 m
.511 .86709 L
s
.39628 .33123 m
.40038 .33351 L
s
.11663 .62289 m
.13206 .62513 L
s
.78935 .43896 m
.7997 .45379 L
s
.46203 .8459 m
.47517 .85243 L
s
.74062 .38171 m
.75153 .39899 L
s
.28029 .76852 m
.29567 .76966 L
s
.62172 .19385 m
.63256 .21863 L
s
.39215 .32881 m
.39628 .33123 L
s
.42547 .84132 m
.43905 .84639 L
s
.31624 .79208 m
.33119 .79358 L
s
.38894 .82868 m
.40298 .832 L
s
.35249 .8121 m
.367 .81433 L
s
.67978 .29408 m
.69139 .31568 L
s
.388 .32626 m
.39215 .32881 L
s
.38634 .4303 m
.39861 .44369 L
s
.61076 .16754 m
.62172 .19385 L
s
.4855 .82992 m
.49831 .85065 L
s
.19519 .70865 m
.20999 .70909 L
s
.77882 .42387 m
.78935 .43896 L
s
.72953 .36392 m
.74062 .38171 L
s
.38592 .32495 m
.388 .32626 L
s
.60712 .1585 m
.61076 .16754 L
s
.14745 .67029 m
.1629 .67045 L
s
.44868 .83736 m
.46203 .8459 L
s
.11142 .62251 m
.11663 .62289 L
s
.60346 .14927 m
.60712 .1585 L
s
.38383 .3236 m
.38592 .32495 L
s
.22857 .74089 m
.24481 .74106 L
s
.59979 .13985 m
.60346 .14927 L
s
.47261 .80446 m
.4855 .82992 L
s
.66924 .27385 m
.67978 .29408 L
s
.59796 .13509 m
.59979 .13985 L
s
1 0 0 r
.35716 .39846 m
.38383 .3236 L
s
0 g
.59612 .13028 m
.59796 .13509 L
s
1 0 0 r
.59612 .13028 m
.62195 .1717 L
s
0 g
.37389 .41671 m
.38634 .4303 L
s
.10614 .62234 m
.11142 .62251 L
s
.26449 .76805 m
.28029 .76852 L
s
.41164 .83518 m
.42547 .84132 L
s
.30091 .79089 m
.31624 .79208 L
s
.37461 .8248 m
.38894 .82868 L
s
.45971 .77444 m
.47261 .80446 L
s
.33766 .8098 m
.35249 .8121 L
s
.71825 .34554 m
.72953 .36392 L
s
.76812 .40854 m
.77882 .42387 L
s
.65855 .25256 m
.66924 .27385 L
s
.17993 .70934 m
.19519 .70865 L
s
.10079 .62239 m
.10614 .62234 L
s
.44681 .74083 m
.45971 .77444 L
s
.43516 .82582 m
.44868 .83736 L
s
.13145 .67174 m
.14745 .67029 L
s
.36974 .41218 m
.37389 .41671 L
s
.43392 .70517 m
.44681 .74083 L
s
.09809 .62248 m
.10079 .62239 L
s
.421 .6692 m
.43392 .70517 L
s
.64771 .23005 m
.65855 .25256 L
s
.21365 .7416 m
.22857 .74089 L
s
.09538 .62262 m
.09809 .62248 L
s
.36556 .40763 m
.36974 .41218 L
s
.408 .63438 m
.421 .6692 L
s
.70678 .3265 m
.71825 .34554 L
s
.39758 .82738 m
.41164 .83518 L
s
1 0 0 r
.09538 .62262 m
.10937 .67654 L
s
0 g
.39487 .60164 m
.408 .63438 L
s
.75723 .39294 m
.76812 .40854 L
s
.36137 .40305 m
.36556 .40763 L
s
.24826 .76816 m
.26449 .76805 L
s
.36001 .81993 m
.37461 .8248 L
s
.63671 .20608 m
.64771 .23005 L
s
.28521 .78979 m
.30091 .79089 L
s
.32251 .80708 m
.33766 .8098 L
s
.38298 .57446 m
.39487 .60164 L
s
.42152 .81024 m
.43516 .82582 L
s
.35927 .40076 m
.36137 .40305 L
s
.16419 .71128 m
.17993 .70934 L
s
.35716 .39846 m
.35927 .40076 L
s
.37092 .5492 m
.38298 .57446 L
s
1 0 0 r
.32947 .47615 m
.35716 .39846 L
s
0 g
.69635 .30885 m
.70678 .3265 L
s
.63304 .19779 m
.63671 .20608 L
s
.12603 .67262 m
.13145 .67174 L
s
.62936 .1893 m
.63304 .19779 L
s
.74616 .37708 m
.75723 .39294 L
s
.35867 .52566 m
.37092 .5492 L
s
.38335 .81714 m
.39758 .82738 L
s
.62567 .18059 m
.62936 .1893 L
s
.1983 .7431 m
.21365 .7416 L
s
.40785 .78988 m
.42152 .81024 L
s
.62381 .17618 m
.62567 .18059 L
s
.62195 .1717 m
.62381 .17618 L
s
1 0 0 r
.62195 .1717 m
.64939 .22256 L
s
0 g
.12055 .67372 m
.12603 .67262 L
s
.34517 .81346 m
.36001 .81993 L
s
.68577 .29049 m
.69635 .30885 L
s
.34622 .50358 m
.35867 .52566 L
s
.23338 .76855 m
.24826 .76816 L
s
.30707 .80345 m
.32251 .80708 L
s
.26915 .78843 m
.28521 .78979 L
s
.14792 .71452 m
.16419 .71128 L
s
.11499 .67504 m
.12055 .67372 L
s
.39419 .76465 m
.40785 .78988 L
s
.7349 .36095 m
.74616 .37708 L
s
.34207 .49656 m
.34622 .50358 L
s
.36901 .80359 m
.38335 .81714 L
s
.67502 .27131 m
.68577 .29049 L
s
.33789 .48966 m
.34207 .49656 L
s
.11219 .67576 m
.11499 .67504 L
s
.18253 .74522 m
.1983 .7431 L
s
.33369 .48287 m
.33789 .48966 L
s
.38057 .73527 m
.39419 .76465 L
s
.10937 .67654 m
.11219 .67576 L
s
.33017 .80461 m
.34517 .81346 L
s
.33159 .4795 m
.33369 .48287 L
s
.32947 .47615 m
.33159 .4795 L
s
1 0 0 r
.10937 .67654 m
.12562 .7205 L
s
0 g
.21817 .76892 m
.23338 .76855 L
s
1 0 0 r
.30104 .55254 m
.32947 .47615 L
s
0 g
.36699 .7031 m
.38057 .73527 L
s
.29138 .79823 m
.30707 .80345 L
s
.66409 .25113 m
.67502 .27131 L
s
.72467 .3463 m
.7349 .36095 L
s
.25453 .78651 m
.26915 .78843 L
s
.35462 .786 m
.36901 .80359 L
s
.35484 .67332 m
.36699 .7031 L
s
.14243 .71585 m
.14792 .71452 L
s
.34262 .64361 m
.35484 .67332 L
s
.66044 .24421 m
.66409 .25113 L
s
.33029 .61471 m
.34262 .64361 L
s
.13689 .7173 m
.14243 .71585 L
s
.31506 .79253 m
.33017 .80461 L
s
.16634 .74764 m
.18253 .74522 L
s
.65678 .23714 m
.66044 .24421 L
s
.34026 .76404 m
.35462 .786 L
s
.71428 .33141 m
.72467 .3463 L
s
.3178 .58703 m
.33029 .61471 L
s
.6531 .22992 m
.65678 .23714 L
s
.20266 .76877 m
.21817 .76892 L
s
.27722 .79152 m
.29138 .79823 L
s
.13128 .71886 m
.13689 .7173 L
s
.2397 .78333 m
.25453 .78651 L
s
.65125 .22626 m
.6531 .22992 L
s
.31364 .5782 m
.3178 .58703 L
s
.64939 .22256 m
.65125 .22626 L
s
1 0 0 r
.64939 .22256 m
.6786 .28029 L
s
0 g
.30946 .56951 m
.31364 .5782 L
s
.32748 .741 m
.34026 .76404 L
s
.30526 .56097 m
.30946 .56951 L
s
.12846 .71967 m
.13128 .71886 L
s
.30154 .77843 m
.31506 .79253 L
s
.30315 .55674 m
.30526 .56097 L
s
.70373 .3163 m
.71428 .33141 L
s
.30104 .55254 m
.30315 .55674 L
s
1 0 0 r
.27227 .62302 m
.30104 .55254 L
s
0 g
.12562 .7205 m
.12846 .71967 L
s
.31475 .71538 m
.32748 .741 L
s
1 0 0 r
.12562 .7205 m
.14445 .75024 L
s
0 g
.16092 .7484 m
.16634 .74764 L
s
.26299 .7822 m
.27722 .79152 L
s
.18692 .76741 m
.20266 .76877 L
s
.22473 .7782 m
.2397 .78333 L
s
.30202 .68807 m
.31475 .71538 L
s
.28806 .76095 m
.30154 .77843 L
s
.15546 .7491 m
.16092 .7484 L
s
.69301 .30094 m
.70373 .3163 L
s
.28926 .65999 m
.30202 .68807 L
s
.14997 .74971 m
.15546 .7491 L
s
.28503 .6507 m
.28926 .65999 L
s
.24877 .76975 m
.26299 .7822 L
s
.27465 .74022 m
.28806 .76095 L
s
.28079 .64143 m
.28503 .6507 L
s
.27653 .63221 m
.28079 .64143 L
s
.2744 .62761 m
.27653 .63221 L
s
.20971 .77037 m
.22473 .7782 L
s
.14721 .74999 m
.14997 .74971 L
s
.27227 .62302 m
.2744 .62761 L
s
.68944 .29582 m
.69301 .30094 L
s
1 0 0 r
.24372 .68291 m
.27227 .62302 L
s
0 g
.18169 .76655 m
.18692 .76741 L
s
.14445 .75024 m
.14721 .74999 L
s
.2613 .71675 m
.27465 .74022 L
s
.68584 .29067 m
.68944 .29582 L
s
1 0 0 r
.14445 .75024 m
.16594 .76239 L
s
0 g
.23461 .75387 m
.24877 .76975 L
s
.17645 .76544 m
.18169 .76655 L
s
.68223 .28549 m
.68584 .29067 L
s
.25691 .70853 m
.2613 .71675 L
s
.68041 .2829 m
.68223 .28549 L
s
.1712 .76403 m
.17645 .76544 L
s
.25252 .70013 m
.25691 .70853 L
s
.20476 .76708 m
.20971 .77037 L
s
.6786 .28029 m
.68041 .2829 L
s
.24812 .69157 m
.25252 .70013 L
s
.24592 .68726 m
.24812 .69157 L
s
.22996 .74789 m
.23461 .75387 L
s
.24372 .68291 m
.24592 .68726 L
s
.16857 .76325 m
.1712 .76403 L
s
.19982 .76342 m
.20476 .76708 L
s
1 0 0 r
.21607 .72798 m
.24372 .68291 L
s
0 g
.22532 .74155 m
.22996 .74789 L
s
.16594 .76239 m
.16857 .76325 L
s
.19488 .75937 m
.19982 .76342 L
s
1 0 0 r
.16594 .76239 m
.18995 .75502 L
s
0 g
.22069 .73489 m
.22532 .74155 L
s
.21838 .73147 m
.22069 .73489 L
s
.19241 .75724 m
.19488 .75937 L
s
.21607 .72798 m
.21838 .73147 L
s
.18995 .75502 m
.19241 .75724 L
s
1 0 0 r
.18995 .75502 m
.21607 .72798 L
s
0 g
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  ImageSize->{265.312, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004900017a000`40n007h00O/?oo0P00Eooo002^
ool200000ooo0000001Fool00:_oo`<000?oo`8005Koo`00ZOoo0P001_oo00<00?oo0000EOoo002W
ool20008ool00`00ool0001Eool00:Coo`<000[oo`04003ooooo001Dool00:;oo`8000goo`05003o
ooooool0001Cool009ooo`<000ooo`05003oooooool0001Cool009goo`8001;oo`03003ooooo00;o
o`03003ooooo053oo`00Vooo0P005Ooo00<00?ooool00_oo00<00?ooool0Cooo002Hool3000Gool0
0`00ooooo`02ool00`00ooooo`1?ool009Koo`8001[oo`03003ooooo00?oo`03003ooooo04koo`00
Tooo0`007?oo00<00?ooool00ooo00<00?ooool0C_oo002Aool2000Oool00`00ooooo`04ool00`00
ooooo`1=ool008ooo`80027oo`03003ooooo00Goo`03003ooooo04coo`00S?oo0`008ooo00<00?oo
ool01Ooo00<00?ooool0C?oo002:ool2000Vool00`00ooooo`06ool00`00ooooo`1;ool008Ooo`<0
02Soo`03003ooooo00Ooo`03003ooooo04[oo`00QOoo0P00:ooo00<00?ooool01ooo00<00?ooool0
B_oo0023ool2000]ool00`00ooooo`08ool00`00ooooo`19ool0083oo`<000Ooo`?h02Goo`03003o
oooo00Soo`03003ooooo04Woo`00O_oo0P002?oo0_P000?oo`00ool01?P08Ooo00<00?ooool02Ooo
00<00?ooool0B?oo001kool30008ool2n003ool00`00ooooo`03ool2n00Oool00`00ooooo`0:ool0
0`00ooooo`17ool007Woo`8000Woo`;h00Goo`03003ooooo00?oo`03003oooP001koo`03003ooooo
00[oo`03003ooooo04Ooo`00Mooo0P002_oo00?h0?oo00001_oo00<00?ooool00_oo00@00?oooooh
01goo`03003ooooo00_oo`03003ooooo04Koo`00M?oo0`002ooo00Gh0?ooooooo`0000Goo`03003o
oooo00;oo`04003oooooool2n00Kool00`00ooooo`0<ool00`00ooooo`15ool007;oo`8000goo`03
n03ooooo00;oo`03003ooooo00Coo`03003ooooo00;oo`03003ooooo00;oo`03n03ooooo01Woo`03
003ooooo00_oo`03003ooooo04Goo`00Kooo0`003_oo00?h0?ooool01?oo00<00?ooool00ooo00<0
0?ooool00_oo00<00?ooool00_oo00<00?P0ool06Ooo00<00?ooool03?oo00<00?ooool0A?oo001]
ool2000@ool00oP0ooooo`06ool00`00ooooo`03ool00`00ooooo`02ool01P00oooooooo003h01[o
o`03003ooooo00coo`03003ooooo04Coo`00Jooo0P004Ooo00?h0000ool02?oo00<00?ooool00ooo
00D00?ooooooo`0000Coo`03003h0?oo01Soo`03003ooooo00goo`03003ooooo04?oo`00J?oo0`00
4_oo00Ch0?oo000000Soo`03003ooooo00?oo`03003ooooo00;oo`07003oooooool00?oon0006?oo
00<00?ooool03_oo00<00?ooool0@_oo001Vool2000Eool01OP0oooooooo00002?oo00<00?ooool0
0ooo00D00?ooooooo`0000Coo`03003oooP001Ooo`03003ooooo00koo`03003ooooo04;oo`00Hooo
0`005_oo00?h0?ooool00ooo00<00?ooool01Ooo00<00?ooool00ooo00<00?ooool00_oo00L00?oo
ooooo`00oooh000Gool00`00ooooo`0?ool00`00ooooo`11ool0067oo`8001Soo`03n03ooooo00Go
o`03003ooooo00Goo`03003ooooo00?oo`05003oooooool00003ool01000ooooooP05_oo00<00?oo
ool04?oo00<00?ooool0@?oo001Nool3000Jool00oP0ooooo`06ool00`00ooooo`05ool00`00oooo
o`02ool00`00ooooo`02ool01000ooooo`000ooo00?h0?ooool04ooo00<00?ooool04?oo00<00?oo
ool0@?oo001Lool2000Lool00oP0ooooo`08ool00`00ooooo`04ool00`00ooooo`03ool01@00oooo
oooo00000ooo00D00?ooooooooP001Coo`03003ooooo017oo`03003ooooo03ooo`00F_oo0P007Ooo
00?h0?ooool02_oo00<00?ooool01?oo00<00?ooool00_oo00<00?ooool00_oo00@00?ooool000?o
o`03n03ooooo01;oo`03003ooooo017oo`03003ooooo03ooo`00Eooo0`007ooo00?h0?ooool02_oo
00<00?ooool01?oo00<00?ooool00ooo00D00?ooooooo`0000;oo`06003oooooool00?P04ooo00<0
0?ooool04_oo00<00?ooool0?_oo001Eool2000Qool00oP0ooooo`0<ool00`00ooooo`04ool00`00
ooooo`02ool01@00oooooooo00000ooo00H00?ooool00?oon00Bool00`00ooooo`0Cool00`00oooo
o`0mool005;oo`<002?oo`03n000000000goo`03003ooooo00Coo`03003ooooo00;oo`05003ooooo
ool00002ool01P00oooooooo003h01;oo`03003ooooo01?oo`03003ooooo03goo`00D?oo0P009Ooo
00Ch0?ooooooo`8000coo`03003ooooo00?oo`03003ooooo00;oo`05003oooooool00003ool01P00
ooooo`00oooh017oo`03003ooooo01Coo`03003ooooo03coo`00C_oo0P009ooo00?h0?ooool00ooo
0P002_oo00<00?ooool01?oo00D00?ooooooo`0000Coo`04003ooooo0003ool00`00n03oo`0@ool0
0`00ooooo`0Eool00`00ooooo`0kool004_oo`<002Soo`03n03ooooo00Koo`03003ooooo00Soo`03
003ooooo00?oo`03003ooooo00;oo`05003oooooool00003ool01P00ooooo`00oooh013oo`03003o
oooo01Goo`03003ooooo03_oo`00BOoo0P00:ooo00?h0?ooool01ooo0P002Ooo00<00?ooool00ooo
00D00?ooooooo`0000Coo`04003ooooo0003ool00`00oooh000@ool00`00ooooo`0Eool00`00oooo
o`0jool004Koo`<002coo`03n03ooooo00[oo`03003ooooo00Ooo`03003ooooo00;oo`03003ooooo
00;oo`05003oooooool00002ool01`00oooooooo003oooP0013oo`03003ooooo01Goo`03003ooooo
03[oo`00A?oo0P00;ooo00?h0?ooool02ooo00<00?ooool01_oo00<00?ooool00ooo00D00?oooooo
o`0000?oo`05003oooooool00002ool01000ooooooP03ooo00<00?ooool05_oo00<00?ooool0>Ooo
0012ool2000`ool00oP0ooooo`0=ool00`00ooooo`06ool00`00ooooo`02ool00`00ooooo`02ool0
1@00oooooooo00000_oo00P00?ooooooo`00ool00?P03_oo00<00?ooool05ooo00<00?ooool0>?oo
000oool3000bool00oP0ooooo`0>ool00`00ooooo`05ool00`00ooooo`02ool00`00ooooo`02ool0
1@00oooooooo00000ooo00@00?ooool000;oo`03n03ooooo00coo`03003ooooo01Ooo`03003ooooo
03Soo`00?Ooo0P00=?oo00?h0?ooool04?oo00<00?ooool01Ooo00<00?ooool00_oo00<00?ooool0
0_oo00D00?ooooooo`0000;oo`08003oooooool00?oo003h00goo`03003ooooo01Soo`03003ooooo
03Ooo`00>_oo0`00=_oo00?h0?ooool04Ooo00<00?ooool01Ooo00D00?ooooooo`0000Coo`05003o
ooooool00003ool01000ooooo`000_oo00?h0?ooool02ooo00<00?ooool06Ooo00<00?ooool0=_oo
000hool2000hool00oP0ooooo`0Cool00`00ooooo`04ool01@00oooooooo00001?oo00<00?ooool0
0_oo00@00?ooool000?oo`04003oo`00n00<ool00`00ooooo`0Iool00`00ooooo`0fool003Koo`80
03[oo`03n0000?oo01Coo`03003ooooo00Coo`05003oooooool00004ool01@00oooooooo00000_oo
00P00?ooooooo`00ool00?P03?oo00<00?ooool06_oo00<00?ooool0=Ooo000cool3000lool00oP0
00000003000Aool00`00ooooo`04ool01@00oooooooo00001?oo00<00?ooool00_oo00@00?ooool0
00;oo`05003ooooo003h000;ool00`00ooooo`0Jool00`00ooooo`0eool0037oo`8003koo`03n03o
oooo00Coo`<000ooo`03003ooooo00Coo`05003oooooool00003ool00`00ooooo`02ool01000oooo
o`000ooo00@00?oo003h00_oo`03003ooooo01_oo`03003ooooo03Coo`00;_oo0`00@?oo00?h0?oo
ool01ooo0`003Ooo00<00?ooool00ooo00D00?ooooooo`0000Coo`05003oooooool00003ool01000
ooooo`000_oo00<00?P0ool02Ooo00<00?ooool07?oo00<00?ooool0<ooo000/ool20012ool00oP0
ooooo`0;ool3000;ool00`00ooooo`03ool01@00oooooooo00000ooo00<00?ooool00_oo00@00?oo
ool000?oo`04003oo`00n00:ool00`00ooooo`0Lool00`00ooooo`0cool002[oo`8004Coo`03n03o
oooo00koo`8000Woo`03003ooooo00?oo`05003oooooool00004ool01@00oooooooo00000ooo00@0
0?ooool000;oo`03003h0?oo00Soo`03003ooooo01goo`03003ooooo03;oo`009ooo0`00A_oo00?h
0?ooool04?oo00<00?ooool01ooo00<00?ooool00ooo00D00?ooooooo`0000?oo`05003oooooool0
0003ool02000oooooooo003oo`00n009ool00`00ooooo`0Nool00`00ooooo`0aool002Goo`8004So
o`03n03ooooo01;oo`03003ooooo00Koo`03003ooooo00?oo`05003oooooool00004ool01@00oooo
oooo00000ooo00@00?ooool000;oo`03003h0?oo00Ooo`03003ooooo01koo`03003ooooo037oo`00
8_oo0`00B_oo00?h0?ooool04ooo00<00?ooool01_oo00<00?ooool00ooo00D00?ooooooo`0000?o
o`05003oooooool00003ool02@00oooooooo003oo`00n0000007ool00`00ooooo`0Oool00`00oooo
o`0`ool0023oo`8004goo`03n03ooooo01Coo`03003ooooo00Koo`03003ooooo00;oo`05003ooooo
ool00003ool00`00ooooo`02ool01@00oooooooo00000_oo00D00?ooool00?P000Soo`03003ooooo
01koo`03003ooooo033oo`007_oo0P00C_oo00?h0?ooool05_oo00<00?ooool01Ooo00<00?ooool0
0ooo00D00?ooooooo`0000?oo`05003oooooool00003ool02000oooooooo003oo`00n008ool00`00
ooooo`0Oool00`00ooooo`0_ool001_oo`<0053oo`03n03ooooo01Ooo`03003ooooo00Goo`03003o
oooo00;oo`05003oooooool00003ool00`00ooooo`02ool01@00oooooooo00000_oo00D00?ooool0
0?P000Ooo`03003ooooo023oo`03003ooooo02koo`006Ooo0P00D_oo00?h0?ooool06Ooo00<00?oo
ool01?oo00<00?ooool00ooo00D00?ooooooo`0000?oo`05003oooooool00003ool02000oooooooo
003oo`00n007ool00`00ooooo`0Pool00`00ooooo`0^ool001Ooo`8005Coo`03n03ooooo01[oo`03
003ooooo00Coo`03003ooooo00;oo`05003oooooool00003ool00`00ooooo`02ool01@00oooooooo
00000_oo00D00?ooool00?P000Koo`03003ooooo027oo`03003ooooo02goo`005ooo0P00E?oo00?h
0?ooool06ooo00<00?ooool01?oo00<00?ooool00_oo00D00?ooooooo`0000?oo`05003oooooool0
0003ool01000ooooo`000_oo00<00?P0ool01Ooo00<00?ooool08_oo00<00?ooool0;?oo000Gool0
0`00ool0001Bool00oP0ooooo`0Mool00`00ooooo`03ool00`00ooooo`02ool01@00oooooooo0000
0ooo00<00?ooool00_oo00D00?ooooooo`0000;oo`05003ooooo003h0005ool00`00ooooo`0Rool0
0`00ooooo`0/ool001Ooo`04003ooooo001Aool00oP0003oo`0Mool00`00ooooo`04ool00`00oooo
o`02ool01@00oooooooo00000ooo00D00?ooooooo`0000?oo`04003ooooo0002ool00`00n0000004
ool00`00ooooo`0Sool00`00ooooo`0[ool001Koo`03003ooooo00;oo`03003ooooo04koo`03n03o
o`0000<001_oo`03003ooooo00?oo`03003ooooo00;oo`05003oooooool00003ool00`00ooooo`02
ool01@00oooooooo00000_oo00D00?ooool00?P000Coo`03003ooooo02?oo`03003ooooo02_oo`00
5_oo00<00?ooool00ooo00<00?ooool0C?oo00?h0?ooool01?oo40003?oo00<00?ooool00ooo00<0
0?ooool00_oo00@00?ooool000Coo`05003oooooool00003ool01000ooooo`000_oo00<00?P00000
0ooo00<00?ooool09?oo00<00?ooool0:_oo000Fool00`00ooooo`04ool00`00ooooo`1;ool00oP0
ooooo`0Dool2000;ool00`00ooooo`02ool00`00ooooo`02ool01@00oooooooo00000ooo00<00?oo
ool00_oo00@00?ooool000;oo`06003ooooo003oooP00ooo00<00?ooool09Ooo00<00?ooool0:Ooo
000Fool00`00ooooo`05ool00`00ooooo`19ool00oP0ooooo`0Gool20009ool00`00ooooo`03ool0
0`00ooooo`02ool01000ooooo`001?oo00D00?ooooooo`0000?oo`04003ooooo0002ool00`00n000
0002ool00`00ooooo`0Uool00`00ooooo`0Yool001Koo`03003ooooo00Koo`03003ooooo04Soo`03
n03ooooo01Woo`03003ooooo00Ooo`03003ooooo00;oo`03003ooooo00;oo`05003oooooool00003
ool00`00ooooo`02ool01000ooooo`000_oo00T00?ooool00?oon0000?oo0000:?oo00<00?ooool0
:?oo000Fool00`00ooooo`07ool00`00ooooo`17ool00oP0ooooo`0Jool00`00ooooo`07ool00`00
ooooo`02ool00`00ooooo`02ool01000ooooo`001?oo00D00?ooooooo`0000?oo`04003ooooo0002
ool01@00n0000?oo0000:Ooo00<00?ooool09ooo000Eool00`00ooooo`09ool00`00ooooo`15ool0
0oP0ooooo`0Lool00`00ooooo`07ool01@00oooooooo00001?oo00D00?ooooooo`0000?oo`03003o
oooo00;oo`04003ooooo0002ool01@00ooooo`00ool00`00:Ooo00<00?ooool09ooo000Eool00`00
ooooo`0:ool00`00ooooo`14ool00oP0ooooo`0Mool00`00ooooo`06ool00`00ooooo`02ool00`00
ooooo`02ool01000ooooo`001?oo00D00?ooooooo`0000?oo`04003ooooo0002ool01000ool00000
:_oo00<00?ooool09_oo000Eool00`00ooooo`0;ool00`00ooooo`12ool00oP0ooooo`0Oool00`00
ooooo`06ool01@00oooooooo00001?oo00D00?ooooooo`0000?oo`03003ooooo00;oo`04003ooooo
0002ool01000ooooo`000_oo00<00?ooool0:?oo00<00?ooool09_oo000Eool00`00ooooo`0<ool0
0`00ooooo`11ool00oP0ooooo`0Oool00`00ooooo`07ool01@00oooooooo00000ooo00D00?oooooo
o`0000Coo`05003oooooool00003ool00`00ool00003ool01000ool00000:_oo00<00?ooool09Ooo
000Eool00`00ooooo`0=ool00`00ooooo`10ool00oP0ooooo`0Pool00`00ooooo`07ool01000oooo
o`001?oo00D00?ooooooo`0000?oo`03003ooooo00;oo`04003ooooo0002ool01000ooooo`000_oo
00<00?ooool0:Ooo00<00?ooool09?oo000Eool00`00ooooo`0>ool00`00ooooo`0nool00oP0oooo
o`0Qool00`00ooooo`08ool01000ooooo`000ooo00D00?ooooooo`0000Coo`05003oooooool00003
ool00`00ool00003ool01000ool00000:_oo00<00?ooool09?oo000Eool00`00ooooo`0?ool00`00
ooooo`0mool00oP0ooooo`0Rool00`00ooooo`08ool00`00ool00004ool01@00oooooooo00000ooo
00D00?ooooooo`0000?oo`04003ooooo0002ool00`00ool00002000Zool00`00ooooo`0Sool001Co
o`03003ooooo017oo`03003ooooo03coo`03n03ooooo02?oo`03003ooooo00Soo`03003oo`0000?o
o`05003oooooool00004ool01@00oooooooo00000ooo00<00?oo00000ooo0P0000?oo`00ool0:_oo
00<00?ooool08_oo000Dool00`00ooooo`0Bool00`00ooooo`0jool00oP0ooooo`0Tool00`00oooo
o`08ool00`00ool00004ool01@00oooooooo00000ooo00D00?ooooooo`0000?oo`04003ooooo0002
ool200000ooo0000000Zool00`00ooooo`0Rool001Coo`03003ooooo01?oo`03003ooooo03Woo`03
n03ooooo02Goo`03003ooooo00Soo`03003oo`0000Coo`04003ooooo0004ool01000ooooo`001?oo
00@00?ooool000;oo`03003ooooo008002[oo`03003ooooo027oo`005?oo00<00?ooool05?oo00<0
0?ooool0=ooo00?h0?ooool08?oo1`002ooo0P001?oo00D00?ooooooo`0000?oo`05003oooooool0
0003ool01000ooooo`000_oo0P0000?oo`000000:_oo00<00?ooool08Ooo000Dool00`00ooooo`0E
ool00`00ooooo`0fool00oP0003oo`0Nool20006ool2000:ool00`00ool00004ool01000ooooo`00
1?oo00@00?ooool000Coo`05003ooooo003oo`020002ool2000Zool00`00ooooo`0Pool001Coo`03
003ooooo01Koo`03003ooooo03Goo`03n000000001coo`8000Woo`8000[oo`8000Coo`05003ooooo
ool00003ool01@00oooooooo00000ooo00T00?ooool00?oo003oo`00ool00P00:ooo00<00?ooool0
7ooo000Cool00`00ooooo`0Gool00`00ooooo`0dool01OP0oooooooo00006Ooo0P003?oo0P002Ooo
00<00?oo00001?oo00D00?ooooooo`0000?oo`04003ooooo0004ool00`00ooooo`0200001?oo003o
oooo0P00:_oo00<00?ooool07ooo000Cool00`00ooooo`0Hool00`00ooooo`0cool00oP0ooooo`02
ool2000Eool2000>ool00`00ooooo`09ool20005ool01000ooooo`000ooo00D00?ooooooo`0000?o
o`03003ooooo008000;oo`05003oo`00ool0000Zool00`00ooooo`0Nool001?oo`03003ooooo01Wo
o`03003ooooo03;oo`03n03ooooo00Coo`@000ooo`80017oo`03003ooooo00Woo`8000Coo`05003o
ooooool00003ool01@00oooooooo00000ooo00@00?ooool000;oo`03003ooooo008002_oo`03003o
oooo01goo`004ooo00<00?ooool06_oo00<00?ooool0<?oo00?h0?ooool02Ooo0`002_oo0P004ooo
00<00?ooool02Ooo0P001Ooo00@00?ooool000?oo`05003oooooool00003ool01000ooooo`000ooo
00D00?oo003oo`0002[oo`03003ooooo01goo`004ooo00<00?ooool06ooo00<00?ooool0;ooo00?h
0?ooool03?oo2P005_oo00<00?ooool02Ooo00<00?ooool00ooo00D00?ooooooo`0000?oo`05003o
ooooool00003ool01000ool000000_oo00H00?ooool00?oo000Zool00`00ooooo`0Lool001?oo`03
003ooooo01coo`03003ooooo02koo`03n03ooooo02coo`04003ooooo0009ool00`00ooooo`03ool0
1000ooooo`000ooo00D00?ooooooo`0000?oo`04003oo`000003ool01P00ooooo`00ool002Woo`03
003ooooo01coo`004_oo00<00?ooool07_oo00<00?ooool0;?oo00?h0?ooool0;_oo00<00?oo0000
2Ooo0P001Ooo00@00?ooool000?oo`05003oooooool00003ool200001Ooo003ooooo00000_oo00<0
0?oo0000:_oo00<00?ooool06ooo000Bool00`00ooooo`0Oool00`00ooooo`0[ool00oP0ooooo`0^
ool01000ooooo`002?oo0P001Ooo00@00?ooool000?oo`05003oooooool00004ool01000ooooo`00
0_oo00H00?ooool00?oo000Zool00`00ooooo`0Jool001;oo`03003ooooo023oo`03003ooooo02Wo
o`03n03ooooo033oo`03003oo`0000Woo`8000Goo`04003ooooo0003ool01@00oooooooo00000ooo
0P0000?oo`00ool00_oo00<00?oo00000_oo00<00?ooool09ooo00<00?ooool06_oo000Bool00`00
ooooo`0Qool00`00ooooo`0Xool00oP0ooooo`0aool00`00ool00008ool20005ool01000ooooo`00
1?oo00@00?ooool000Coo`04003ooooo0002ool01000ooooo`000_oo00<00?ooool09ooo00<00?oo
ool06Ooo000Bool00`00ooooo`0Rool00`00ooooo`0Wool00oP0ooooo`0aool00`00ool00009ool2
0005ool01000ooooo`000ooo00D00?ooooooo`0000?oo`04003ooooo0003ool01P00ooooo`00ool0
02[oo`03003ooooo01Soo`004_oo00<00?ooool08ooo00<00?ooool09Ooo00?h0?ooool0<ooo0P00
2Ooo00<00?oo00001?oo00D00?ooooooo`0000?oo`04003ooooo0003ool20002ool01000ooooo`00
0_oo00@00?ooool002Woo`03003ooooo01Soo`004_oo00<00?ooool09?oo00<00?ooool09?oo00?h
0?ooool0<ooo00<00?oo00002Ooo0P001Ooo00@00?ooool000?oo`05003oooooool00002ool20003
ool01000ooooo`000_oo00@00?ooool002Woo`03003ooooo01Ooo`004Ooo00<00?ooool09_oo00<0
0?ooool08ooo00?h0?ooool0=?oo0P002Ooo00<00?oo00001?oo00D00?ooooooo`0000?oo`09003o
ooooool00?oo003oo`0000;oo`05003oooooool00002ool01000ooooo`00:?oo00<00?ooool05ooo
000Aool00`00ooooo`0Wool00`00ooooo`0Qool00oP0ooooo`0fool20009ool20005ool01000oooo
o`001?oo00P00?ooool00?oo003oo`000ooo00@00?ooool000?oo`03003oo`0002Woo`03003ooooo
01Koo`004Ooo00<00?ooool0:?oo00<00?ooool08?oo00?h0?ooool0=_oo0P002Ooo00<00?oo0000
1?oo00D00?ooooooo`0000?oo`04003oooooool20002ool01000ooooo`000ooo00@00?ooool000;o
o`03003ooooo02Ooo`03003ooooo01Goo`004Ooo00<00?ooool0:Ooo00<00?ooool07ooo00?h0?oo
ool0=ooo0P002Ooo0P001Ooo00@00?ooool000Coo`03003ooooo008000;oo`05003oooooool00002
ool01@00oooooooo00000_oo00<00?ooool09_oo00<00?ooool05Ooo000Aool00`00ooooo`0Zool0
0`00ooooo`0Mool00oP0ooooo`0hool20009ool00`00ool00004ool01@00oooooooo00000ooo00D0
0?ooooooo`0000?oo`05003oooooool00002ool01000ooooo`000ooo00<00?ooool09_oo00<00?oo
ool05?oo000Aool00`00ooooo`0[ool00`00ooooo`0Lool00oP0ooooo`0iool20009ool20005ool0
1000ooooo`001?oo00<00?ooool00P000_oo00D00?ooooooo`0000?oo`04003ooooo0002ool00`00
ooooo`0Wool00`00ooooo`0Cool0013oo`03003ooooo02goo`03003ooooo01_oo`03n0000?oo03[o
o`03003ooooo00Soo`8000Goo`03003oo`0000Coo`03003ooooo008000?oo`05003oooooool00002
ool01@00oooooooo00000_oo00<00?ooool09_oo00<00?ooool04ooo000@ool00`00ooooo`0^ool0
0`00ooooo`0Iool01?P0ooooo`00>_oo0P002Ooo0P001_oo00<00?oo00001?oo00D00?oo003oo`00
00;oo`05003oooooool00003ool01000ooooo`000_oo00<00?ooool09ooo00<00?ooool04_oo000@
ool00`00ooooo`0_ool00`00ooooo`0Hool01?P0ooooo`00>ooo00<00?ooool02?oo00<00?ooool0
1?oo00<00?oo00001?oo00D00?oo003oo`0000?oo`05003oooooool00003ool01000ooooo`000_oo
00<00?ooool09_oo00<00?ooool04_oo000@ool00`00ooooo`0`ool00`00ooooo`0Gool01OP0oooo
oooo0000>ooo00<00?ooool01ooo0P001_oo00<00?oo00001?oo0P000_oo00D00?ooooooo`0000?o
o`05003oooooool00002ool00`00ool0000Xool2000Cool0013oo`03003ooooo037oo`03003ooooo
01Goo`03n03ooooo00?oo`03003ooooo03Soo`03003ooooo00Soo`03003ooooo00Coo`03003oo`00
00Coo`8000;oo`05003oooooool00003ool01@00oooooooo00000ooo00<00?oo00009?oo0`0000?o
o`00ool04_oo000@ool00`00ooooo`0bool00`00ooooo`0Dool00oP0ooooo`04ool00`00ooooo`0g
ool20009ool20006ool00`00ool00004ool01@00oooooooo00000ooo00D00?ooooooo`0000?oo`06
003ooooo003oo`008Ooo0`001?oo00<00?ooool04Ooo000@ool00`00ooooo`0cool00`00ooooo`0C
ool00oP0ooooo`05ool2000gool2000:ool00`00ooooo`05ool20004ool20002ool01@00oooooooo
00000ooo00D00?ooooooo`0000?oo`03003oo`0001goo`<000Ooo`03003ooooo017oo`003ooo00<0
0?ooool0=Ooo00<00?ooool04Ooo00?h0?ooool02?oo00<00?ooool0=Ooo0P002Ooo0P001_oo00<0
0?oo00001?oo00D00?ooooooo`0000?oo`05003oooooool00003ool01000ooooo`000_oo00<00?oo
ool05ooo0`002ooo00<00?ooool04?oo000?ool00`00ooooo`0fool00`00ooooo`0@ool00oP0oooo
o`09ool00`00ooooo`0dool00`00ool00009ool00`00ooooo`05ool00`00ool00003ool01@00oooo
oooo00001?oo00@00?ooool000?oo`07003oooooool00?oo00005_oo0`003_oo00<00?ooool04?oo
000?ool00`00ooooo`0gool00`00ooooo`0>ool00oP0ooooo`0:ool00`00ooooo`0dool01000ool0
00002?oo0P001_oo00<00?oo00000ooo0P000ooo00D00?ooooooo`0000?oo`05003oooooool00003
ool00`00ool0000Bool3000Aool00`00ooooo`0@ool000ooo`03003ooooo03Soo`03003ooooo00go
o`03n03ooooo00_oo`03003ooooo03?oo`05003oo`00ool00008ool00`00ooooo`05ool00`00ool0
0002ool00`00ool00002ool00`00ooooo`02ool01000ooooo`000ooo00D00?ooooooo`0000;oo`03
003ooooo00_oo`@001Coo`03003ooooo013oo`003ooo00<00?ooool0>Ooo00<00?ooool03?oo00?h
0?ooool03?oo00<00?ooool0<ooo0P000_oo0P001_oo0P001_oo00<00?oo00000_oo00<00?oo0000
0ooo00D00?ooooooo`0000?oo`05003oooooool00003ool01000ooooo`002Ooo0`006?oo00<00?oo
ool04?oo000?ool00`00ooooo`0jool00`00ooooo`0:ool00oP0ooooo`0>ool00`00ooooo`0bool2
0004ool00`00ooooo`04ool00`00ooooo`05ool01@00ool00?oo00000_oo00@00?ooool000Coo`05
003oooooool00003ool01`00oooooooo003oo`0000Koo`<001_oo`03003ooooo013oo`003_oo00<0
0?ooool0??oo00<00?ooool02Ooo00?h0?ooool03ooo00<00?ooool0<Ooo0P001Ooo00<00?ooool0
0ooo0P000_oo00D00?ooooooo`0000;oo`8000?oo`04003ooooo0003ool01@00oooooooo00000ooo
00D00?ooooooo`0000;oo`03003ooooo00<001koo`03003ooooo013oo`003_oo00<00?ooool0?Ooo
00<00?ooool02?oo00?h0?ooool04?oo00<00?ooool0<Ooo00<00?ooool01?oo00<00?ooool00ooo
0P0000?oo`00ool00ooo00@00?oo000000?oo`05003oooooool00003ool01@00oooooooo00000ooo
00H00?ooooooo`00ool3000Qool00`00ooooo`0@ool000koo`03003ooooo03koo`03003ooooo00Ko
o`03n03ooooo01;oo`03003ooooo033oo`03003ooooo00Goo`8000?oo`800003ool00?oo00?oo`04
003ooooo0004ool01000ooooo`000ooo00D00?ooooooo`0000?oo`03003ooooo00<000;oo`03003o
oooo023oo`03003ooooo00ooo`003_oo00<00?ooool0?ooo00<00?ooool01Ooo00?h0?ooool04_oo
00<00?ooool0;ooo00<00?oo00002?oo00@00?ooooooo`8000Goo`04003ooooo0004ool01@00oooo
oooo00000ooo00D00?ooooooo`0000;oo`<000;oo`05003oooooool0000Qool00`00ooooo`0?ool0
00koo`03003ooooo043oo`03003ooooo00Coo`03n03ooooo01?oo`03003ooooo02koo`03003oo`00
00Woo`@00003ool00?oo00Coo`04003oo`000004ool01@00oooooooo00000ooo00<00?ooool00`00
0_oo00D00?ooooooo`0000?oo`03003ooooo01koo`03003ooooo00ooo`003_oo00<00?ooool0@Ooo
00<00?ooool00_oo00?h0?ooool05Ooo00<00?ooool0;Ooo00@00?ooool000_oo`04003ooooo0004
ool01000ool000001?oo00D00?ooooooo`0000?oo`<00003ool00?oo00;oo`05003oooooool00003
ool00`00ooooo`0Nool00`00ooooo`0?ool000koo`03003ooooo04;oo`05003ooooooooh000Hool0
0`00ooooo`0[ool01@00oooooooo00003?oo00<00?oo00001Ooo0P0000?oo`00ool00ooo00@00?oo
ooooo`<00003ool00?oo00;oo`05003oooooool00003ool01@00oooooooo00007ooo00<00?ooool0
3ooo000=ool00`00ooooo`14ool01000ooooooP06Ooo00<00?ooool0:_oo00<00?ooool00_oo00<0
0?ooool02Ooo00@00?ooool000Goo`03003oo`0000Coo`D000Coo`05003oooooool00003ool01@00
oooooooo00000_oo00<00?ooool07Ooo00<00?ooool03ooo000=ool00`00ooooo`15ool01000n03o
o`006Ooo00<00?ooool0:Ooo00<00?ooool00_oo00<00?ooool02_oo00@00?ooool000Coo`05003o
oooo003oo`040003ool00`00ooooo`02ool01000ooooo`000ooo00D00?ooooooo`0000?oo`03003o
oooo01coo`03003ooooo00ooo`003Ooo00<00?ooool0A_oo00?h0?oo00006_oo00<00?ooool09ooo
00<00?ooool00ooo00<00?ooool02_oo00@00?ooool000Coo`D000Coo`04003ooooo0004ool01@00
oooooooo00000ooo00D00?ooooooo`0000?oo`03003ooooo01coo`03003ooooo00koo`003Ooo00<0
0?ooool0AOoo00Gh0?oo003oo`0001[oo`03003ooooo02Koo`03003ooooo00Coo`03003ooooo00Wo
o`05003oooooool00002ool400000ooo003oo`03ool01@00oooooooo00001?oo00@00?ooool000?o
o`05003oooooool00003ool00`00ooooo`0Lool00`00ooooo`0>ool000goo`03003ooooo04Goo`03
n03ooooo008001_oo`03003ooooo02Goo`03003ooooo00Coo`03003ooooo00[oo`03003ooooo00<0
00;oo`8000;oo`04003oooooool20002ool00`00ooooo`02ool01@00oooooooo00000ooo00D00?oo
ooooo`0000?oo`03003ooooo01_oo`03003ooooo00koo`003Ooo00<00?ooool0AOoo00Kh0?ooool0
0?oo000Kool00`00ooooo`0Sool00`00ooooo`05ool00`00ooooo`09ool400000ooo003oo`02ool0
1@00ool00?oo00000ooo0P000ooo00<00?ooool00_oo00D00?ooooooo`0000?oo`05003oooooool0
0003ool00`00ooooo`0Jool00`00ooooo`0>ool000coo`03003ooooo04Goo`03n03ooooo00;oo`80
01coo`03003ooooo02;oo`03003ooooo00Goo`03003ooooo00Koo`<000;oo`05003oooooool00002
ool00`00ool00002ool01P00ooooo`00ool000?oo`05003oooooool00003ool01@00oooooooo0000
0ooo00D00?ooooooo`0001coo`03003ooooo00koo`003?oo00<00?ooool01?oo00?h0?ooool0?_oo
00?h0?ooool00ooo0P006ooo00<00?ooool08_oo00<00?ooool01_oo00<00?ooool00_oo0`001Ooo
00<00?ooool00_oo00<00?oo00000_oo00<00?oo00000_oo00@00?ooool000?oo`05003oooooool0
0003ool01@00oooooooo00000ooo00D00?ooooooo`0001_oo`03003ooooo00koo`003?oo00<00?oo
ool01?oo00?h0000ool0?_oo00?h0?ooool01?oo00<00?ooool06_oo00<00?ooool08?oo00<00?oo
ool01ooo00<00?oo00000P002Ooo00L00?ooooooo`00ool00002ool01P00ooooo`00ool000;oo`05
003oooooool00003ool00`00ooooo`02ool01@00oooooooo00000ooo00@00?ooool001_oo`03003o
oooo00koo`003?oo00<00?ooool01?oo00?h0?oo0000?Ooo00?h0?ooool01_oo00<00?ooool06_oo
00<00?ooool07ooo00<00?ooool01_oo0`003?oo00<00?ooool00_oo0P000ooo00<00?ooool00P00
0ooo00D00?ooooooo`0000?oo`03003ooooo00;oo`04003ooooo0004ool01000ooooo`006ooo00<0
0?ooool03Ooo000<ool00`00ooooo`04ool01?P0ooooo`00??oo00?h0?ooool01_oo0P007?oo00<0
0?ooool07_oo00<00?ooool00ooo0`0000?oo`00ool03Ooo00<00?ooool00_oo00<00?ooool00_oo
00@00?ooool000Coo`05003oooooool00003ool01@00oooooooo00000ooo00D00?ooooooo`0000?o
o`03003ooooo01Soo`03003ooooo00goo`003?oo00<00?ooool01Ooo00Ch0?ooool003[oo`03n03o
oooo00Soo`8001coo`8001goo`04003oooooool30005ool00`00ooooo`0;ool00`00ooooo`02ool0
0`00ooooo`02ool01000ooooo`001?oo00D00?ooooooo`0000?oo`03003ooooo00;oo`04003ooooo
0004ool01@00oooooooo00006Ooo00<00?ooool03Ooo000;ool00`00ooooo`06ool01OP0oooooooo
0000>Ooo00?h0?ooool02?oo00<00?oo00007Ooo00<00?ooool06_oo10002?oo00<00?ooool02ooo
00<00?ooool00_oo0P001?oo00@00?oo000000Coo`05003oooooool00003ool00`00ooooo`02ool0
1000ooooo`001?oo00D00?ooooooo`0001Soo`03003ooooo00goo`002ooo00<00?ooool01_oo00?h
0?ooool00_oo0P00=ooo00?h0?ooool02Ooo00<00?oo00007Ooo00<00?ooool05ooo0`003?oo00<0
0?ooool02ooo00L00?ooooooo`00ool00003ool01000ool000001?oo00<00?ooool00_oo00D00?oo
ooooo`0000?oo`05003oooooool00004ool01000ooooo`006?oo00<00?ooool03Ooo000;ool00`00
ooooo`06ool00oP0ooooo`04ool00`00ooooo`0cool00oP0ooooo`0;ool00`00ool0000Mool00`00
ooooo`0Cool300000ooo003oo`0<ool00`00ooooo`0;ool01@00oooooooo00000_oo00P00?ooool0
0?oo003oo`001?oo00D00?ooooooo`0000?oo`03003ooooo00;oo`04003ooooo0004ool01@00oooo
oooo00005ooo00<00?ooool03Ooo000;ool00`00ooooo`06ool00oP0ooooo`05ool00`00ooooo`0b
ool00oP0ooooo`0;ool01000ooooo`007Ooo00<00?ooool03ooo0`000ooo00<00?ooool03Ooo00<0
0?ooool02ooo00@00?ooool000?oo`03003ooooo008000;oo`05003oooooool00004ool01@00oooo
oooo00000ooo00D00?ooooooo`0000Coo`04003ooooo000Gool00`00ooooo`0=ool000_oo`03003o
oooo00Koo`03n03ooooo00Koo`8003;oo`03n03ooooo00coo`04003ooooo000Mool00`00ooooo`0;
ool30005ool00`00ooooo`0>ool00`00ooooo`0;ool01000ooooo`001?oo00@00?ooool000?oo`05
003oooooool00003ool00`00ooooo`02ool01@00oooooooo00000ooo00<00?ooool00_oo00@00?oo
ool001Koo`03003ooooo00goo`002ooo00<00?ooool01_oo00?h0?ooool02?oo00<00?ooool0;_oo
00?h0?ooool03_oo00@00?ooool001goo`03003ooooo00Ooo`<000Ooo`03003ooooo013oo`03003o
oooo00[oo`04003ooooo0005ool30003ool01@00oooooooo00001?oo00D00?ooooooo`0000?oo`03
003ooooo00;oo`05003oooooool00003ool00`00ooooo`0Dool00`00ooooo`0<ool000_oo`03003o
oooo00Koo`03n03ooooo00Woo`03003ooooo02goo`03n03ooooo00koo`05003oooooool0000Mool0
0`00ooooo`03ool3000:ool00`00ooooo`0@ool00`00ooooo`0;ool00`00ool00007ool00`00oooo
o`02ool01@00oooooooo00000ooo00<00?ooool00_oo00D00?ooooooo`0000?oo`03003ooooo00;o
o`05003oooooool0000Eool00`00ooooo`0<ool000[oo`03003ooooo00Soo`03n03ooooo00Woo`03
003ooooo02_oo`03n03ooooo013oo`05003oooooool0000Mool5000<ool00`00ooooo`0Bool00`00
ooooo`0:ool00`00ool00008ool01@00oooooooo00000ooo00<00?ooool00_oo00D00?ooooooo`00
00Coo`05003oooooool00004ool01@00oooooooo00005?oo00<00?ooool03?oo000:ool00`00oooo
o`08ool00oP0ooooo`0:ool00`00ooooo`0Zool00oP0ooooo`0@ool00`00ooooo`02ool00`00oooo
o`0Hool5000<ool2000Eool00`00ooooo`0:ool01000ooooo`002?oo00D00?ooooooo`0000?oo`05
003oooooool00004ool01@00oooooooo00001?oo00D00?ooooooo`0000?oo`03003ooooo01;oo`03
003ooooo00coo`002_oo00<00?ooool02?oo00?h0?ooool02ooo00<00?ooool0:Ooo00?h0000ool0
4Ooo00<00?ooool00_oo00<00?ooool05?oo0`001Ooo0P002Ooo00<00?ooool05_oo00<00?ooool0
2_oo00<00?oo00002?oo00<00?ooool00_oo00D00?ooooooo`0000?oo`05003oooooool00004ool0
0`00ooooo`02ool01@00oooooooo00000ooo00<00?ooool04Ooo00<00?ooool03?oo000:ool00`00
ooooo`08ool00oP0ooooo`0<ool2000Xool00oP0ool0000Bool00`00ooooo`03ool00`00ooooo`0@
ool3000:ool9000Iool00`00ooooo`0;ool20009ool01@00oooooooo00001?oo00D00?ooooooo`00
00?oo`05003oooooool00004ool01@00oooooooo00000ooo00<00?ooool04Ooo00<00?ooool03?oo
000:ool00`00ooooo`08ool01?P0000000003Ooo00<00?ooool09Ooo00?h0?oo00004ooo00<00?oo
ool00ooo00<00?ooool03?oo0`00;ooo00<00?ooool02ooo0P002Ooo00<00?ooool00_oo00<00?oo
ool00_oo00@00?ooool000?oo`03003ooooo00;oo`03003ooooo00;oo`05003oooooool00003ool0
0`00ooooo`0@ool00`00ooooo`0<ool000[oo`03003ooooo00Soo`05n03oooooool0000=ool00`00
ooooo`0Sool01OP0oooooooo00004_oo00<00?ooool01?oo00<00?ooool02?oo0`00<_oo00<00?oo
ool03?oo00<00?ooool02?oo00@00?ooooooo`8000?oo`05003oooooool00003ool01@00oooooooo
00001?oo00D00?ooooooo`0000Coo`03003ooooo013oo`03003ooooo00_oo`002Ooo00<00?ooool0
2_oo00Ch0?ooooooo`<000_oo`03003ooooo02;oo`05n03oooooool0000Cool00`00ooooo`04ool0
0`00ooooo`04ool3000fool00`00ooooo`0;ool00`00ooooo`08ool20003ool00`00ooooo`02ool0
1@00oooooooo00000ooo00D00?ooooooo`0000Coo`05003oooooool00004ool00`00ooooo`0?ool0
0`00ooooo`0;ool000Woo`03003ooooo00[oo`03n03ooooo00Coo`<000Woo`03003ooooo023oo`03
n03ooooo00?oo`03003ooooo013oo`03003ooooo00Goo`03003ooooo00<003Woo`03003ooooo00_o
o`03003ooooo00Woo`03003ooooo00;oo`05003oooooool00004ool01@00oooooooo00000ooo0P00
0ooo00D00?ooooooo`0000Coo`03003ooooo00koo`03003ooooo00_oo`002Ooo00<00?ooool02_oo
00?h0?ooool01ooo0P002?oo00<00?ooool07ooo00?h0?ooool01?oo00<00?ooool04?oo00<00?oo
ool01Ooo0P00?Ooo00<00?ooool02_oo0P002_oo0P000ooo0P000ooo00D00?ooooooo`0000Coo`05
003oooooool00003ool00`00ooooo`02ool01@00oooooooo00004?oo00<00?ooool02ooo0009ool0
0`00ooooo`0:ool00oP0ooooo`09ool00`00ooooo`06ool00`00ooooo`0Mool00oP0ooooo`05ool0
0`00ooooo`0@ool00`00ooooo`05ool00`00ooooo`0mool00`00ooooo`08ool3000;ool00`00oooo
o`02ool20002ool20003ool01@00oooooooo00001?oo00D00?ooooooo`0000?oo`03003ooooo00;o
o`03003ooooo00goo`03003ooooo00_oo`002Ooo00<00?ooool02ooo00?h0?ooool02Ooo00<00?oo
ool01_oo00<00?ooool07?oo00?h0?ooool01_oo00<00?ooool03ooo00<00?ooool01Ooo00<00?oo
ool0?Ooo00<00?ooool01Ooo0`000_oo00<00?ooool02Ooo0P001?oo0P000_oo00@00?ooooooo`80
00?oo`05003oooooool00004ool01@00oooooooo00000ooo00<00?ooool03Ooo00<00?ooool02ooo
0009ool00`00ooooo`0;ool00oP0ooooo`0:ool20007ool00`00ooooo`0Kool00oP0ooooo`06ool0
0`00ooooo`0@ool00`00ooooo`04ool00`00ooooo`0nool00`00ooooo`040006ool00`00ooooo`09
ool00`00ooooo`02ool20003ool01@00oooooooo00001?oo00D00?ooooooo`0000?oo`05003ooooo
ool00004ool00`00ooooo`0<ool00`00ooooo`0;ool000Woo`03003ooooo00_oo`03n03ooooo00co
o`03003ooooo00Goo`03003ooooo01Woo`03n03ooooo00Soo`03003ooooo00ooo`03003ooooo00Co
o`03003ooooo03koo`<000[oo`03003ooooo00Woo`8000Soo`8000?oo`05003oooooool00004ool0
1@00oooooooo00000ooo00<00?ooool00_oo00<00?ooool02ooo00<00?ooool02ooo0008ool00`00
ooooo`0<ool00oP0ooooo`0=ool20006ool2000Iool00oP0ooooo`08ool00`00ooooo`0@ool00`00
ooooo`03ool00`00ooooo`0kool300000ooo003oo`0:ool2000Eool20002ool20003ool01@00oooo
oooo00001?oo00D00?ooooooo`0000Coo`03003ooooo00_oo`03003ooooo00[oo`002?oo00<00?oo
ool03Ooo00?h0?ooool03_oo0P001_oo00<00?ooool05Ooo00?h0?ooool02_oo00<00?ooool03ooo
00<00?ooool00ooo00<00?ooool0>?oo0`001Ooo00<00?ooool02Ooo0P005?oo00<00?ooool00_oo
00@00?ooooooo`8000?oo`05003oooooool00004ool01@00oooooooo00003Ooo00<00?ooool02_oo
0008ool00`00ooooo`0=ool00oP0ooooo`0@ool20005ool00`00ooooo`0Dool00oP0ooooo`0:ool0
0`00ooooo`0?ool00`00ooooo`03ool00`00ooooo`0eool30008ool00`00ooooo`09ool00`00ool0
000Hool20003ool00`00ooooo`02ool01@00oooooooo00000ooo00<00?ooool00_oo00<00?ooool0
2_oo00<00?ooool02_oo0008ool00`00ooooo`0=ool00oP0ooooo`0Bool20004ool00`00ooooo`0B
ool00oP0ooooo`0<ool00`00ooooo`0?ool00`00ooooo`02ool00`00ooooo`0aool4000;ool2000:
ool01000ooooo`006?oo0P000ooo00D00?ooooooo`0000Coo`05003oooooool00004ool00`00oooo
o`09ool00`00ooooo`0:ool000Soo`03003ooooo00goo`03n03ooooo01Coo`03003ooooo00;oo`03
003ooooo017oo`03n03ooooo00coo`03003ooooo00ooo`03003ooooo00;oo`03003ooooo02koo`<0
013oo`03003ooooo00Soo`04003ooooo000Mool20003ool00`00ooooo`02ool01@00oooooooo0000
1?oo00<00?ooool02?oo00<00?ooool02_oo0008ool00`00ooooo`0>ool00oP0ooooo`0Dool20003
ool00`00ooooo`0?ool00oP0ooooo`0=ool00`00ooooo`0?ool00`00ooooo`02ool00`00ooooo`0[
ool3000Cool20009ool20002ool00`00ooooo`0Kool01000oooooooo0P000ooo00@00?ooooooo`80
00?oo`03003ooooo00Soo`03003ooooo00[oo`001ooo00<00?ooool03ooo00?h0000000010004_oo
00D00?ooooooo`00013oo`03n03ooooo00koo`03003ooooo00ooo`05003oooooool0000Zool3000G
ool00`00ooooo`08ool01@00oooooooo00008Ooo0P000ooo00D00?ooooooo`0000Coo`03003ooooo
00Ooo`03003ooooo00[oo`001ooo00<00?ooool03ooo00?h0?ooool01?oo10003ooo00D00?oooooo
o`0000ooo`03n0000?oo00koo`03003ooooo00ooo`05003oooooool0000Wool3000Jool00`00oooo
o`08ool00`00ooooo`02ool00`00ooooo`0Oool20002ool20003ool00`00ooooo`02ool00`00oooo
o`07ool00`00ooooo`09ool000Ooo`03003ooooo00ooo`03n03ooooo00Soo`@000coo`05003ooooo
ool0000=ool00oP0ool0000?ool00`00ooooo`0@ool01000ooooo`008ooo10007Ooo00<00?ooool0
2?oo00<00?ooool00ooo00<00?ooool07_oo00<00?ooool00_oo00<00?ooool00_oo00D00?oooooo
o`0000Woo`03003ooooo00Woo`001ooo00<00?ooool04?oo00?h0?ooool02ooo10002Ooo00D00?oo
ooooo`0000coo`04n03ooooo000?ool00`00ooooo`0?ool00`00ool0000Qool3000Qool00`00oooo
o`08ool00`00ooooo`04ool00`00ooooo`0Sool20002ool20003ool00`00ooooo`06ool00`00oooo
o`09ool000Ooo`03003ooooo013oo`03n03ooooo00ooo`<000Ooo`8000;oo`8000Woo`05n03ooooo
ool0000?ool00`00ooooo`0?ool00`00ool0000Nool3000Tool20009ool00`00ooooo`04ool00`00
ooooo`0Sool20003ool00`00ooooo`02ool00`00ooooo`05ool00`00ooooo`09ool000Ooo`03003o
oooo013oo`03n03ooooo01;oo`8000Ooo`8000;oo`03003ooooo00Koo`03n03ooooo00;oo`03003o
oooo00goo`03003ooooo00ooo`8001_oo`<002Ooo`8000Woo`03003ooooo00Goo`03003ooooo02So
o`04003oooooool20006ool00`00ooooo`09ool000Ooo`03003ooooo013oo`03n03ooooo01Coo`80
00Ooo`04003ooooo0006ool00oP0ooooo`03ool00`00ooooo`0=ool00`00ooooo`0?ool2000Hool3
000Zool00`00ooooo`08ool00`00ooooo`06ool00`00ooooo`0Wool20003ool00`00ooooo`04ool0
0`00ooooo`09ool000Koo`03003ooooo017oo`03n03ooooo01Koo`8000Koo`800003ool00?oo00Co
o`03n03ooooo00Coo`03003ooooo00coo`03003ooooo013oo`03003ooooo01;oo`@003Soo`03003o
oooo00Ooo`03003ooooo02coo`03003ooooo00?oo`03003ooooo00Woo`001_oo00<00?ooool04_oo
00?h0?ooool05ooo0P001_oo00<00?oo00000ooo00?h0?ooool01Ooo00<00?ooool03Ooo00<00?oo
ool03ooo00<00?ooool03ooo0`00??oo00<00?ooool02?oo00<00?ooool0:ooo0P001?oo00<00?oo
ool02Ooo0006ool00`00ooooo`0Bool00oP0ooooo`0Iool20005ool00`00ool00002ool00oP0oooo
o`05ool00`00ooooo`0=ool00`00ooooo`0?ool2000=ool3000oool00`00ooooo`08ool00`00oooo
o`0/ool00`00ooooo`03ool00`00ooooo`08ool000Koo`03003ooooo01;oo`03n03ooooo01_oo`80
00Coo`05003oo`00003h0008ool00`00ooooo`0<ool00`00ooooo`0?ool2000:ool30012ool00`00
ooooo`09ool00`00ooooo`0aool00`00ooooo`08ool000Koo`03003ooooo01;oo`03n03ooooo01go
o`8000?oo`04003oooP00008ool00`00ooooo`0=ool00`00ooooo`0>ool00`00ool00006ool30016
ool00`00ooooo`09ool00`00ooooo`0`ool00`00ooooo`08ool000Koo`03003ooooo01?oo`03n03o
oooo01koo`8000;oo`04003h0?oo0008ool00`00ooooo`0<ool00`00ooooo`0>ool00`00ool00002
ool40019ool00`00ooooo`0:ool00`00ooooo`0_ool00`00ooooo`08ool000Goo`03003ooooo01Co
o`03n03ooooo00;ooa0000koo`03003oooP000800003ool00?oo00Koo`03003ooooo00goo`03003o
oooo00goo`03003oo`00008004goo`03003ooooo00_oo`03003ooooo02koo`03003ooooo00Soo`00
1Ooo00<00?ooool05?oo00?h000000000P004?oo10002ooo00L00?P0ooooo`00ool00007ool00`00
ooooo`0<ool00`00ooooo`0<ool300000ooo003oo`1=ool00`00ooooo`0;ool00`00ooooo`0^ool0
0`00ooooo`08ool000Goo`03003ooooo01Coo`03n03ooooo01Koo`@000Ooo`03n0000?oo00;oo`<0
00Koo`03003ooooo00goo`03003ooooo00Soo`<00005ool00?ooool0001>ool00`00ooooo`0<ool0
0`00ooooo`0]ool00`00ooooo`08ool000Goo`03003ooooo01Goo`03n03ooooo01Woo`<000Coo`04
n03oo`000003ool30005ool00`00ooooo`0<ool00`00ooooo`05ool30004ool01000ooooo`00C_oo
00<00?ooool03Ooo00<00?ooool0;Ooo00<00?ooool01ooo0005ool00`00ooooo`0Eool00oP0oooo
o`0Lool200001?oon03oo`000_oo0P000ooo0P001?oo00<00?ooool03Ooo00<00?ooool010001ooo
00@00?ooool004koo`03003ooooo00koo`03003ooooo02coo`03003ooooo00Ooo`001Ooo00<00?oo
ool05_oo00?h0?ooool07Ooo00@00?P0000000Coo`8000;oo`8000?oo`03003ooooo00goo`<000_o
o`05003oooooool0001=ool00`00ooooo`0?ool00`00ooooo`0[ool00`00ooooo`07ool000Goo`03
003ooooo01Koo`03n03ooooo01goo`03n03ooooo008000Goo`800003ool0000000?oo`03003ooooo
00Woo`<00003ool00?oo00_oo`05003oooooool0001=ool00`00ooooo`0@ool00`00ooooo`0Zool0
0`00ooooo`07ool000Coo`03003ooooo01Ooo`03n03ooooo01goo`04n03oooooool30005ool01000
ool000000_oo00<00?ooool01_oo0`001?oo00<00?ooool02_oo00D00?ooooooo`0004goo`03003o
oooo013oo`03003ooooo02[oo`03003ooooo00Ooo`001?oo00<00?ooool06?oo00?h0?ooool06ooo
00?h0?ooool00_oo00<00?ooool00P001?oo00@00?oo000000;oo`04003oooooool40008ool00`00
ooooo`09ool00`00ooooo`02ool00`00ooooo`1Nool00`00ooooo`0Yool00`00ooooo`07ool000Co
o`03003ooooo01Soo`03n03ooooo01[oo`03n03ooooo00?oo`03003ooooo00;oo`8000?oo`05003o
o`00003oo`04000<ool00`00ooooo`09ool00`00ooooo`02ool00`00ooooo`1Oool00`00ooooo`0X
ool00`00ooooo`07ool000Coo`03003ooooo01Woo`03n03ooooo00_oo`h00003n03ooooo00Coo`03
003ooooo00?oo`8000;oo`H000ooo`03003ooooo00Soo`03003ooooo00;oo`03003ooooo063oo`03
003ooooo02Soo`03003ooooo00Koo`001?oo00<00?ooool06Ooo00?h0?ooool01?oo1`003Ooo00?h
0?oo00000`000ooo00<00?ooool01?oo20003ooo00<00?ooool02?oo00<00?ooool00ooo00<00?oo
ool0H?oo00<00?ooool09ooo00<00?ooool01_oo0004ool00`00ooooo`0Jool00oP0ooooo`03000D
ool00oP0ooooo`03ool50003ool300000ooo00000002ool3000>ool00`00ooooo`08ool00`00oooo
o`03ool00`00ooooo`1Pool00`00ooooo`0Wool00`00ooooo`06ool000?oo`03003ooooo01_oo`03
n000000001Koo`03n03ooooo00Soo`@000Koo`8000;oo`8000koo`03003ooooo00Ooo`03003ooooo
00Coo`03003ooooo063oo`03003ooooo02Koo`03003ooooo00Koo`000ooo00<00?ooool07?oo00?h
0?ooool05Ooo00?h0?ooool01Ooo0`0000?oo`00ool00P001ooo00<00?ooool00P003Ooo00<00?oo
ool01ooo00<00?ooool01?oo00<00?ooool0HOoo00<00?ooool09Ooo00<00?ooool01_oo0003ool0
0`00ooooo`0Lool00oP0ooooo`0Dool00oP0ooooo`03ool30004ool01000oooooooo0`001Ooo1@00
3?oo00<00?ooool01ooo00<00?ooool01Ooo00<00?ooool0HOoo00<00?ooool09?oo00<00?ooool0
1_oo0003ool00`00ooooo`0Mool00oP0ooooo`0Bool01?P0003ooooo0`002?oo00<00?ooool00ooo
0`001?oo10003?oo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool0H_oo00<00?ooool08ooo
00<00?ooool01_oo0003ool00`00ooooo`0Mool00oP0ooooo`0Aool00oP0ool00002000;ool00`00
ooooo`06ool20003ool4000;ool00`00ooooo`05ool00`00ooooo`07ool00`00ooooo`1Qool00`00
ooooo`0Sool00`00ooooo`06ool000?oo`03003ooooo01koo`03n03ooooo00koo`@00003ool00000
00H000Koo`03003ooooo00Ooo`<00003ool00?oo00<000Woo`03003ooooo00Goo`03003ooooo00Oo
o`03003ooooo06;oo`03003ooooo02?oo`03003ooooo00Goo`000_oo00<00?ooool08?oo00?h0?oo
ool02_oo0`0000?h0000000010001_oo20002ooo0P000_oo0`002Ooo00<00?ooool01?oo00<00?oo
ool01ooo00<00?ooool0Hooo00<00?ooool08_oo00<00?ooool01Ooo0002ool00`00ooooo`0Pool0
0oP0ooooo`02ool900000ooon03oo`06ool00`00ooooo`0:ool50009ool20002ool30007ool00`00
ooooo`04ool00`00ooooo`08ool00`00ooooo`1Sool00`00ooooo`0Qool00`00ooooo`05ool000;o
o`03003ooooo027oo`04n00000000002ool30004ool00oP0ooooo`07ool00`00ooooo`0:ool01000
oooooooo10001Ooo00D00?oo00000?oo00<000Ooo`03003ooooo00?oo`03003ooooo00Soo`03003o
oooo06Coo`03003ooooo023oo`03003ooooo00Goo`000_oo00<00?ooool08_oo0_P00`001Ooo0_P0
2ooo00<00?ooool02_oo00<00?ooool01?oo10000_oo00<00?ooool01@001_oo00<00?ooool00ooo
00<00?ooool02?oo00<00?ooool0IOoo00<00?ooool07ooo00<00?ooool01Ooo0002ool00`00oooo
o`0Pool40002n002ool4n0000ooo0000000;ool00`00ooooo`09ool00`00ooooo`08ool30004ool4
0006ool00`00ooooo`02ool00`00ooooo`09ool00`00ooooo`1Tool00`00ooooo`0Oool00`00oooo
o`05ool000;oo`03003ooooo01goo`<000Koo`;h00Ooo`03003ooooo00Soo`03003ooooo00[oo`03
003ooooo00[oo`8000?oo`D000Coo`03003ooooo00;oo`03003ooooo00Woo`03003ooooo06Goo`03
003ooooo01koo`03003ooooo00Goo`000_oo00<00?ooool06_oo0`002ooo1P000_oo0P002Ooo00<0
0?ooool02_oo00<00?ooool02Ooo00@00?oo000000?oo`@000Coo`05003oooooool0000;ool00`00
ooooo`1Vool00`00ooooo`0Nool00`00ooooo`04ool00003ool00?oo01Woo`<001Coob4000Koo`03
003ooooo00<00003ool00000008000?oo`05003oooooool0000<ool00`00ooooo`1Vool00`00oooo
o`0Mool00`00ooooo`04ool00003ool00?oo01Koo`<001coo`8000Soo`03003ooooo00Woo`03003o
oooo00?oo`<000Coo`03003ooooo00;oo`800004ool000000003ool01000ooooo`003?oo00<00?oo
ool0Iooo00<00?ooool07?oo00<00?ooool01?oo00000ooo003oo`0Bool4000Qool20007ool2000:
ool00`00ooooo`05ool50006ool600001Ooo003ooooo00003?oo00<00?ooool0Iooo00<00?ooool0
7?oo00<00?ooool01?oo00000ooo003oo`0?ool3000Wool20007ool00`00ooooo`08ool00`00oooo
o`08ool40005ool500001?oo003oo`003Ooo00<00?ooool0Iooo00<00?ooool06ooo00<00?ooool0
1?oo00000ooo003oo`0<ool3000/ool700000ooo003oo`09ool00`00ooooo`09ool00`00ool00003
0004ool400000ooo003oo`0<ool00`00ooooo`1Xool00`00ooooo`0Jool00`00ooooo`04ool00003
ool00?oo00Woo`<003Koo`P000Goo`03003ooooo00Woo`03003ooooo00;oo`8000?oo`D000goo`03
003ooooo06Woo`03003ooooo01Woo`03003ooooo00Coo`0000<00?ooool01_oo0`00?Ooo00@00?oo
ooooo``000Koo`03003ooooo00?oo`8000;oo`D000goo`03003ooooo06Woo`03003ooooo01Soo`03
003ooooo00Coo`0000<00?ooool00_oo1000@Ooo0P002?oo00<00?ooool00_oo20001_oo0P0000?o
o`0000000`003?oo00<00?ooool0JOoo00<00?ooool06Ooo00<00?ooool00ooo00000`00ool00002
0017ool30006ool20009ool40005ool7000<ool00`00ooooo`1Yool00`00ooooo`0Hool00`00oooo
o`03ool0008004goo`@000Coo`03003ooooo00Ooo`03003ooooo00@000Coo`H000[oo`03003ooooo
06[oo`03003ooooo01Ooo`03003ooooo00?oo`0000?oo`000000D?oo100000?oo`00ool02?oo00<0
0?ooool00ooo0`0000?oo`00ool01P002Ooo00<00?ooool0J_oo00<00?ooool05_oo00<00?ooool0
0ooo0003ool00`00ooooo`1Aool80004ool00`00ooooo`05ool:0008ool00`00ooooo`1[ool00`00
ooooo`0Eool00`00ooooo`03ool000Coo`03003ooooo05Coo`8000;oo`L000Koo`03003ooooo00P0
00Ooo`03003ooooo06_oo`03003ooooo01Coo`03003ooooo00?oo`001Ooo0P00E_oo0`001Ooo1@00
0_oo00<00?ooool00_oo0P0000?oo`0000000P001_oo00<00?ooool0Jooo00<00?ooool05?oo00<0
0?ooool00ooo0007ool00`00ooooo`1Fool20004ool20002ool30005ool70006ool00`00ooooo`1[
ool00`00ooooo`0Dool00`00ooooo`02ool000Soo`8005Soo`<000?oo`8000;oo`D000;oo`03003o
oooo00D000Coo`03003ooooo06coo`03003ooooo01?oo`03003ooooo00;oo`002_oo00<00?ooool0
F?oo20001?oo10001?oo10000ooo00<00?ooool0K?oo00<00?ooool04_oo00<00?ooool00_oo000;
ool2001Nool50004ool40002ool40003ool00`00ooooo`1/ool00`00ooooo`0Aool00`00ooooo`02
ool000goo`03003ooooo05_oo`05003oo`00003oo`030003ool00`00ool0000200000ooo00000002
00000ooo003oo`1]ool00`00ooooo`0Aool00`00ooooo`02ool000koo`03003ooooo05[oo`04003o
ooooool300000ooo000000040002ool600000ooo003oo`1]ool00`00ooooo`0@ool00`00ooooo`02
ool000ooo`8005[oo`03003ooooo00Coo`@00003ool00000008000?oo`D006ooo`03003ooooo00oo
o`03003ooooo00;oo`004Ooo00<00?ooool0Eooo00<00?ooool02?oo0`0000Coo`00000000Coo`@0
06koo`03003ooooo00koo`03003ooooo00;oo`004_oo0P00Eooo00<00?ooool02ooo0`0000?oo`00
00000P000_oo1000KOoo00<00?ooool03_oo00<00?ooool00Ooo000Dool00`00ooooo`1Dool00`00
ooooo`0>ool200000ooo0000000300000ooo00000002001[ool00`00ooooo`0>ool00`00ooooo`01
ool001Goo`03003ooooo05?oo`03003ooooo013oo`P00004ool00000001[ool00`00ooooo`0=ool0
0`00ooooo`01ool001Koo`8005?oo`03003ooooo01Goo`T006[oo`03003ooooo00coo`03003ooooo
007oo`006?oo00<00?ooool0D?oo00<00?ooool05ooo2@00JOoo00<00?ooool02ooo00<00?ooool0
0Ooo000Iool2001@ool00`00ooooo`0Iool8001Yool00`00ooooo`0:ool00`00ooooo`01ool001_o
o`03003ooooo04goo`03003ooooo01_oo`P006Soo`03003ooooo00Woo`03003ooooo007oo`007?oo
0P00COoo00<00?ooool07?oo00<00?ooool00_oo1000I_oo00<00?ooool02_oo0@000Ooo0Ooo000N
ool00`00ooooo`1:ool00`00ooooo`0Mool00`00ooooo`03ool5001Tool00`00ooooo`09ool10001
ool1ool001ooo`03003ooooo04Woo`03003ooooo01koo`03003ooooo00?oo`H006?oo`03003ooooo
00Soo`40007oo`7oo`008?oo0P00BOoo00<00?ooool07ooo00<00?ooool01_oo1@00HOoo00<00?oo
ool01ooo0@000Ooo0Ooo000Rool00`00ooooo`16ool00`00ooooo`0Pool20008ool6001Oool00`00
ooooo`06ool10001ool1ool002?oo`8004Koo`03003ooooo02;oo`03003ooooo00Ooo`<00003ool0
000000Koo`03003ooooo05Coo`03003ooooo00Koo`40007oo`7oo`009Ooo00<00?ooool0@ooo00<0
0?ooool08ooo0P002Ooo0`0000?oo`0000000P0000?oo`000000Eooo00<00?ooool01Ooo0@000Ooo
0Ooo000Vool20013ool00`00ooooo`0Uool00`00ooooo`08ool30002ool3001Iool00`00ooooo`05
ool10001ool002Soo`03003ooooo043oo`03003ooooo02Koo`8000[oo`8005koo`03003ooooo00Co
o`40007oo`00:Ooo00<00?ooool0?ooo00<00?ooool0:?oo0P002?oo0P00Gooo00<00?ooool00ooo
0@000Ooo000Zool2000oool00`00ooooo`0Zool20006ool2001Oool00`00ooooo`03ool10001ool0
02coo`03003ooooo03coo`03003ooooo02coo`03003ooooo00?oo`80063oo`03003ooooo00;oo`40
007oo`00;Ooo0P00??oo00<00?ooool0;Ooo00<00?ooool00_oo0P00HOoo00D00?ooooooo`00007o
o`00;ooo00<00?ooool0>Ooo00<00?ooool0;_oo0P00I_oo00@00?ooool0007oo`00<?oo00<00?oo
ool0>?oo00<00?ooool0<?oo0`00I?oo00<00?oo00000Ooo000aool2000gool00`00ooooo`0dool2
001Sool10001ool1000003?oo`03003ooooo03Coo`03003ooooo03Koo`03003ooooo063oo`40007o
o`400000=?oo0P00=?oo00<00?ooool0=ooo00<00?ooool0H?oo0P00000fool00`00ooooo`0aool0
0`00ooooo`0hool00`00ooooo`1Nool3000003Ooo`80037oo`03003ooooo03Soo`03003ooooo05[o
o`@000?oo`00>Ooo00<00?ooool0;_oo00<00?ooool0>Ooo00<00?ooool0E?oo1@001ooo000jool0
0`00ooooo`0]ool00`00ooooo`0jool00`00ooooo`1?ool4000<ool003_oo`8002goo`03003ooooo
03[oo`03003ooooo04_oo`@0013oo`00?Ooo00<00?ooool0:_oo00<00?ooool0>ooo00<00?ooool0
AOoo1@005?oo000nool2000Zool00`00ooooo`0kool00`00ooooo`11ool4000Iool0043oo`03003o
oooo02Ooo`03003ooooo03_oo`03003ooooo03coo`D001goo`00@Ooo00<00?ooool09_oo00<00?oo
ool0??oo00<00?ooool0=ooo10008_oo0012ool2000Vool00`00ooooo`0lool00`00ooooo`0cool4
000Vool004Coo`03003ooooo02?oo`03003ooooo03coo`03003ooooo02koo`D002[oo`00AOoo0P00
8ooo00<00?ooool0?Ooo00<00?ooool0:Ooo1000;ooo0017ool00`00ooooo`0Pool00`00ooooo`0m
ool00`00ooooo`0Tool5000cool004Soo`80023oo`03003ooooo03goo`03003ooooo023oo`@003So
o`00B_oo00<00?ooool07Ooo00<00?ooool0?Ooo00<00?ooool06ooo1@00??oo001;ool00`00oooo
o`0Lool00`00ooooo`0mool00`00ooooo`0Gool40011ool004coo`8001coo`03003ooooo03goo`03
003ooooo01?oo`@004Goo`00C_oo00<00?ooool06Ooo00<00?ooool0?Ooo00<00?ooool03_oo1@00
BOoo001?ool2000Iool00`00ooooo`1:ool4001>ool0057oo`03003ooooo01Koo`03003ooooo04Go
o`D005;oo`00D_oo0P005_oo00<00?ooool0@Ooo1000Eooo001Dool00`00ooooo`0Cool00`00oooo
o`0mool4001Kool005Goo`03003ooooo01;oo`03003ooooo03Soo`D005ooo`00E_oo0P004Ooo00<0
0?ooool0=Ooo1000I?oo001Hool00`00ooooo`0>ool00`00ooooo`0`ool5001Xool005Woo`8000ko
o`03003ooooo02coo`@006goo`00Fooo00<00?ooool02ooo00<00?ooool09ooo1@00LOoo001Lool0
0`00ooooo`0:ool00`00ooooo`0Sool4001fool005goo`8000[oo`03003ooooo01ooo`@007[oo`00
Gooo00<00?ooool01ooo00<00?ooool06_oo1@00O_oo001Pool20007ool00`00ooooo`0Fool40023
ool006;oo`03003ooooo00Coo`03003ooooo017oo`D008Ooo`00Hooo0P001?oo00<00?ooool03Ooo
1000S?oo001Uool01@00oooooooo00002ooo1000T?oo001Vool01000ooooo`001_oo1@00U?oo001W
ool30002ool4002Iool006Woo`<009goo`00\
\>"],
  ImageRangeCache->{{{0, 264.312}, {286.938, 0}} -> {0.0486402, -4.72903*^-5, \
0.00324458, 0.00324458}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[15]="]
}, Open  ]],

Cell["\<\
When a derivative is taken of an InterpolatingFunction object, a \
new InterpolatingFunction object is returned which gives the requested \
derivative when evaluated at a point.  The \
InterpolatingFunctionDerivativeOrder is a way of determining what derivative \
will be evaluated.\
\>", "Text"],

Cell["The derivative returns a new InterpolatingFunction object.", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dmdfun\  = \ \(Derivative[0, 1]\)[mdfun]\)], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{"...", 0.`, 1.`, "..."}, {0.`, 
            0.4721511683265256`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[16]="]
}, Open  ]],

Cell["This shows what derivative will be evaluated.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingFunctionDerivativeOrder[dmdfun]\)], "Input",
  CellLabel->"In[17]:="],

Cell[BoxData[
    \(Derivative[0, 1]\)], "Output",
  CellLabel->"Out[17]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolveUtilities", "Section",
  CellTags->{"s:2", "NDSolveUtilities"}],

Cell[TextData[{
  "A number of utilitiy routines have been written to facilitate the \
investigation and comparison of various ",
  StyleBox["NDSolve", "MR"],
  " methods. These functions have been collected in the package ",
  StyleBox["DifferentialEquations`NDSolveUtilities`", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{GridBox[{
            {
              RowBox[{
                StyleBox["CompareMethods",
                  "MR"], "[", 
                RowBox[{
                  StyleBox["sys",
                    "TI"], ",", " ", 
                  StyleBox["refsol",
                    "TI"], ",", " ", 
                  StyleBox["methods",
                    "TI"], ",", " ", 
                  StyleBox["opts",
                    "TI"]}], "]"}], Cell[TextData[{
                
                "Return statistics for various methods applied to the system \
",
                StyleBox["sys", "TI"],
                "."
              }], "Text"]},
            {
              RowBox[{
                StyleBox["FinalSolutions",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox[\(sys, \ sols\),
                  "TI"], 
                StyleBox["]",
                  "MR"]}], Cell[TextData[{
                
                "Return the solution values at the end of the numerical \
integration for various solutions ",
                StyleBox["sols", "TI"],
                "  corresponding to the system ",
                StyleBox["sys", "TI"],
                "."
              }], "Text"]},
            {
              RowBox[{
                StyleBox["InvariantErrorPlot",
                  "MR"], "[", 
                RowBox[{
                  StyleBox["invts",
                    "TI"], ",", " ", 
                  StyleBox["dvars",
                    "TI"], ",", " ", 
                  StyleBox["ivar",
                    "TI"], ",", 
                  StyleBox[" ",
                    "TI"], 
                  StyleBox["sol",
                    "TI"], 
                  StyleBox[",",
                    "TI"], 
                  StyleBox[" ",
                    "TI"], 
                  StyleBox["opts",
                    "TI"]}], "]"}], 
              RowBox[{
              Cell["Return a plot of the error", "Text"], "in", " ", "the", 
                " ", "invariants", " ", 
                StyleBox["invts",
                  "TI"], " ", "for", " ", "the", " ", "solution", " ", 
                RowBox[{
                  StyleBox["sol",
                    "TI"], "."}]}]},
            {
              RowBox[{
                StyleBox["RungeKuttaLinearStabilityFunction",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox[\(amat, \ bvec, \ var\),
                  "TI"], 
                StyleBox["]",
                  "MR"]}], Cell[TextData[{
                
                "Return the linear stability function for the \
Runge\[LongDash]Kutta method with coefficient matrix ",
                StyleBox["amat", "TI"],
                ", weight vector ",
                StyleBox["bvec", "TI"],
                " using the variable ",
                StyleBox["var", "TI"],
                ".  "
              }], "Text"]},
            {
              RowBox[{
                StyleBox["StepDataPlot",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox[\(sols, \ opts\),
                  "TI"], 
                StyleBox["]",
                  "MR"]}], 
              RowBox[{
              "Return", " ", "plots", " ", "of", " ", "the", " ", "step", " ",
                 "sizes", " ", "taken", " ", "for", " ", "the", " ", 
                "solutions", " ", 
                RowBox[{
                  StyleBox["sols",
                    "TI"], "."}]}]}
            }], ","}], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->0.5}],

Cell[TextData[{
  "Functions provided in the ",
  StyleBox["NDSolveUtilities", "MR"],
  " package."
}], "Caption"],

Cell["This loads the package.", "MathCaption"],

Cell[BoxData[
    \(<< DifferentialEquations`NDSolveUtilities`\)], "Input",
  CellLabel->"In[2]:="],

Cell[TextData[{
  "A useful means of analysing Runge--Kutta methods is to study how they \
behave when applied to a scalar linear test problem (see the package ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " )."
}], "Text"],

Cell["\<\
This assigns the (exact or infinitely precise) coefficients for the \
2 stage implicit Runge\[LongDash]Kutta Gauss method of order 4.\
\>", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \({amat, \ bvec, \ cvec}\  = 
      NDSolve`ImplicitRungeKuttaGaussCoefficients[4, \ Infinity]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{{1\/4, 1\/12\ \((3 - 2\ \@3)\)}, {1\/12\ \((3 + 2\ \@3)\), 
          1\/4}}, {1\/2, 1\/2}, {1\/6\ \((3 - \@3)\), 
        1\/6\ \((3 + \@3)\)}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell["\<\
This computes the linear stability function, which corresponds to \
the (2,2) Pad\[EAcute] approximation to the exponential at the origin.\
\>", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RungeKuttaLinearStabilityFunction[amat, \ bvec, \ z]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \(\(1 + z\/2 + z\^2\/12\)\/\(1 - z\/2 + z\^2\/12\)\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "Examples of the functions ",
  StyleBox["CompareMethods", "MR"],
  ", ",
  StyleBox["FinalSolutions", "MR"],
  ", ",
  StyleBox["RungeKuttaLinearStabilityFunction", "MR"],
  " and ",
  StyleBox["StepDataPlot", "MR"],
  " can be found within ",
  StyleBox[ButtonBox["ExplicitRungeKutta",
    ButtonData:>{"ExplicitRungeKutta.nb", None},
    ButtonStyle->"Hyperlink"], "MR"],
  " ."
}], "Text"],

Cell[TextData[{
  "Examples of the function ",
  StyleBox["InvariantErrorPlot", "MR"],
  " can be found within ",
  StyleBox[ButtonBox["Projection",
    ButtonData:>{"Projection.nb", None},
    ButtonStyle->"Hyperlink"], "MR"],
  " ."
}], "Text"],

Cell[CellGroupData[{

Cell["InvariantErrorPlot Options", "Subsection",
  CellTags->"s:1"],

Cell[TextData[{
  "The function ",
  StyleBox["InvariantErrorPlot", "MR"],
  " has a number of options that can be used to control the form of the \
result."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["InvariantDimensions",
              "MR"], 
            StyleBox["Automatic",
              "MR"], \(specifies\ the\ dimensions\ of\ the\ invariants\)},
          {
            StyleBox["InvariantErrorFunction",
              "MR"], 
            StyleBox[\(Abs[Subtract[#1, #2]] &\),
              
              "MR"], \(specifies\ the\ function\ to\ use\ for\ comparing\ \
errors\)},
          {
            StyleBox["InvariantErrorSampleRate",
              "MR"], 
            StyleBox["Automatic",
              "MR"], \(specifies\ how\ often\ errors\ are\ sampled\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options of the function ",
  StyleBox["InvariantErrorPlot", "MR"],
  ". "
}], "Caption"],

Cell[TextData[{
  "The default value for ",
  StyleBox["InvariantDimensions", "MR"],
  " is to determine the dimensions from the structure of the input, ",
  StyleBox["Dimensions[", "MR"],
  StyleBox["invts", "TI"],
  StyleBox["]", "MR"],
  "."
}], "Text"],

Cell[TextData[{
  "The default value for ",
  StyleBox["InvariantErrorFunction", "MR"],
  " is a function to compute the absolute error."
}], "Text"],

Cell[TextData[{
  "The default value for ",
  StyleBox["InvariantErrorSampleRate", "MR"],
  " is to sample all points if there are less than 1000 steps taken. Above \
this threshold a logarithmic sample rate is used."
}], "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Utility Packages",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "s:1"->{
    Cell[1858, 57, 100, 1, 67, "Section",
      CellTags->{"s:1", "InterpolatingFunctionAnatomy"}],
    Cell[338503, 23195, 67, 1, 41, "Subsection",
      CellTags->"s:1"]},
  "InterpolatingFunctionAnatomy"->{
    Cell[1858, 57, 100, 1, 67, "Section",
      CellTags->{"s:1", "InterpolatingFunctionAnatomy"}]},
  "s:2"->{
    Cell[332164, 22988, 76, 1, 67, "Section",
      CellTags->{"s:2", "NDSolveUtilities"}]},
  "NDSolveUtilities"->{
    Cell[332164, 22988, 76, 1, 67, "Section",
      CellTags->{"s:2", "NDSolveUtilities"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"s:1", 341168, 23283},
  {"InterpolatingFunctionAnatomy", 341378, 23288},
  {"s:2", 341490, 23291},
  {"NDSolveUtilities", 341607, 23294}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 57, 0, 87, "Chapter"],

Cell[CellGroupData[{
Cell[1858, 57, 100, 1, 67, "Section",
  CellTags->{"s:1", "InterpolatingFunctionAnatomy"}],
Cell[1961, 60, 1109, 25, 136, "Text"],
Cell[3073, 87, 3611, 104, 322, "DefinitionBox"],
Cell[6687, 193, 104, 4, 16, "Caption"],
Cell[6794, 199, 46, 0, 40, "MathCaption"],
Cell[6843, 201, 111, 2, 26, "Input"],
Cell[6957, 205, 315, 5, 56, "Text"],
Cell[7275, 212, 134, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[7434, 219, 209, 5, 42, "Input"],
Cell[7646, 226, 382, 6, 31, "Message"],
Cell[8031, 234, 159, 4, 25, "Output"]
}, Open  ]],
Cell[8205, 241, 44, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[8274, 245, 103, 2, 26, "Input"],
Cell[8380, 249, 86, 2, 25, "Output"]
}, Open  ]],
Cell[8481, 254, 148, 3, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[8654, 261, 166, 3, 42, "Input"],
Cell[8823, 266, 12275, 377, 184, 3794, 267, "GraphicsData", "PostScript", \
"Graphics"],
Cell[21101, 645, 154, 4, 25, "Output"]
}, Open  ]],
Cell[21270, 652, 156, 3, 40, "Text"],
Cell[21429, 657, 132, 3, 24, "Text"],
Cell[21564, 662, 207, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[21796, 670, 223, 5, 42, "Input"],
Cell[22022, 677, 22557, 842, 184, 11793, 704, "GraphicsData", "PostScript", \
"Graphics"],
Cell[44582, 1521, 154, 4, 25, "Output"]
}, Open  ]],
Cell[44751, 1528, 105, 3, 24, "Text"],
Cell[44859, 1533, 100, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[44984, 1540, 349, 8, 58, "Input"],
Cell[45336, 1550, 382, 6, 31, "Message"],
Cell[45721, 1558, 726, 11, 83, "Message"],
Cell[46450, 1571, 198, 5, 25, "Output"]
}, Open  ]],
Cell[46663, 1579, 78, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[46766, 1583, 111, 2, 26, "Input"],
Cell[46880, 1587, 67, 2, 25, "Output"]
}, Open  ]],
Cell[46962, 1592, 83, 1, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[47070, 1597, 104, 2, 26, "Input"],
Cell[47177, 1601, 65, 2, 25, "Output"]
}, Open  ]],
Cell[47257, 1606, 131, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[47413, 1613, 108, 2, 26, "Input"],
Cell[47524, 1617, 82, 2, 26, "Output"]
}, Open  ]],
Cell[47621, 1622, 135, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[47781, 1629, 417, 8, 74, "Input"],
Cell[48201, 1639, 11854, 392, 184, 4231, 293, "GraphicsData", "PostScript", \
"Graphics"],
Cell[60058, 2033, 155, 4, 25, "Output"]
}, Open  ]],
Cell[60228, 2040, 107, 3, 24, "Text"],
Cell[60338, 2045, 164, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[60527, 2053, 428, 9, 90, "Input"],
Cell[60958, 2064, 269977, 20874, 294, 226725, 20335, "GraphicsData", \
"PostScript", "Graphics"],
Cell[330938, 22940, 157, 4, 25, "Output"]
}, Open  ]],
Cell[331110, 22947, 306, 6, 56, "Text"],
Cell[331419, 22955, 83, 1, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[331527, 22960, 98, 2, 26, "Input"],
Cell[331628, 22964, 199, 5, 25, "Output"]
}, Open  ]],
Cell[331842, 22972, 68, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[331935, 22976, 102, 2, 26, "Input"],
Cell[332040, 22980, 75, 2, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[332164, 22988, 76, 1, 67, "Section",
  CellTags->{"s:2", "NDSolveUtilities"}],
Cell[332243, 22991, 304, 7, 56, "Text"],
Cell[332550, 23000, 3696, 107, 252, "DefinitionBox"],
Cell[336249, 23109, 114, 4, 16, "Caption"],
Cell[336366, 23115, 46, 0, 40, "MathCaption"],
Cell[336415, 23117, 99, 2, 26, "Input"],
Cell[336517, 23121, 307, 7, 40, "Text"],
Cell[336827, 23130, 166, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[337018, 23138, 149, 3, 42, "Input"],
Cell[337170, 23143, 204, 4, 78, "Output"]
}, Open  ]],
Cell[337389, 23150, 171, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[337585, 23158, 109, 2, 26, "Input"],
Cell[337697, 23162, 106, 2, 60, "Output"]
}, Open  ]],
Cell[337818, 23167, 411, 14, 40, "Text"],
Cell[338232, 23183, 246, 8, 24, "Text"],

Cell[CellGroupData[{
Cell[338503, 23195, 67, 1, 41, "Subsection",
  CellTags->"s:1"],
Cell[338573, 23198, 169, 5, 24, "Text"],
Cell[338745, 23205, 863, 22, 122, "DefinitionBox3Col"],
Cell[339611, 23229, 107, 4, 16, "Caption"],
Cell[339721, 23235, 256, 8, 40, "Text"],
Cell[339980, 23245, 149, 4, 24, "Text"],
Cell[340132, 23251, 229, 5, 40, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

