(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    241949,       5623]*)
(*NotebookOutlinePosition[    243213,       5670]*)
(*  CellTagsIndexPosition[    243067,       5661]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Method Plug-in Framework", "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"s:1"],

Cell[TextData[{
  "The control mechanisms set up for ",
  StyleBox["NDSolve", "MR"],
  " enable you to define your own numerical integration algorithms and use \
them as specifications for the ",
  StyleBox["Method", "MR"],
  " option of ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " accesses its numerical algorithms and the information it needs from them \
in an object-oriented manner.",
  " ",
  "At each step of a numerical integration, ",
  StyleBox["NDSolve", "MR"],
  " keeps the method in a form so that it can keep private data as needed."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["AlgorithmIdentifier",
                "TI"], 
              StyleBox["[",
                "MR"], 
              StyleBox["data",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "An algorithm object that contains any ",
              StyleBox["data", "TI"],
              
              " that a particular numerical ODE integration algorithm may \
need to use. The data is effectively private to the algorithm. ",
              StyleBox["AlgorithmIdentifier", "TI"],
              " should be a ",
              StyleBox["Mathematica",
                FontSlant->"Italic"],
              " symbol. The algorithm is accessed from ",
              StyleBox["NDSolve", "MR"],
              " by using the option ",
              StyleBox["Method->", "MR"],
              StyleBox["AlgorithmIdentifier.", "TI"]
            }], "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "The structure for method data used in ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Caption"],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " does not access the data associated with an algorithm directly, so you \
can keep the information needed in any form that is convenient or efficient \
to use.",
  " ",
  "The algorithm and information which might be saved in its private data are \
accessed only through method functions of the algorithm object."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["AlgorithmObject",
              "TI"], "[", 
            RowBox[{
              StyleBox["Step",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["rhs",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["t",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["h",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["y",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["yp",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox["]",
              "MR"]}], " "}
        }]], "TopSpanBox"],

Cell[BoxData[
    FormBox[GridBox[{
          {" ", Cell[TextData[{
              "Attempt to take a single time step of size ",
              StyleBox["h", "TI"],
              " from time ",
              StyleBox["t", "TI"],
              " to time ",
              StyleBox["t", "TI"],
              " + ",
              StyleBox["h", "TI"],
              " using the numerical algorithm. ",
              StyleBox["y", "TI"],
              " and ",
              StyleBox["yp", "TI"],
              
              " are the approximate solution vector and its time derivative, \
respectively, at time ",
              StyleBox["t", "TI"],
              ". The function should generally return a list ",
              StyleBox["{", "MR"],
              StyleBox["newh", "TI"],
              StyleBox[", ", "MR"],
              StyleBox["\[CapitalDelta]y", "TI"],
              StyleBox["}", "MR"],
              " where ",
              StyleBox["newh", "TI"],
              
              " is the best size for the next step determined by the \
algorithm and ",
              StyleBox["\[CapitalDelta]y", "TI"],
              " is the ",
              StyleBox["increment",
                FontSlant->"Italic"],
              " such that the approximate solution at time ",
              StyleBox["t", "TI"],
              " + ",
              StyleBox["h", "TI"],
              " is given by ",
              StyleBox["y", "TI"],
              " + ",
              StyleBox["\[CapitalDelta]y", "TI"],
              
              ". If the time step is too large, the function should only \
return the value {",
              StyleBox["hnew", "TI"],
              StyleBox["}", "TI",
                FontSlant->"Plain",
                FontVariations->{"CompatibilityType"->0}],
              " where ",
              StyleBox["hnew",
                FontSlant->"Italic"],
              
              " should be small enough for an acceptable step. See below for \
complete descriptions of possible return values."
            }]]}
          }], TextFrom]], "MiddleBox"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["AlgorithmObject",
              "TI"], "[", 
            StyleBox[\(DifferenceOrder[]\),
              "MR"], 
            StyleBox["]",
              "MR"]}], " "}
        }]], "MiddleSpanBox"],

Cell[BoxData[
    FormBox[GridBox[{
          {" ", 
            Cell["\<\
Return the current asymptotic difference order of the \
algorithm.\
\>"]}
          }], TextFrom]], "MiddleBox"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["AlgorithmObject",
              "TI"], "[", 
            StyleBox[\(Stepmode[]\),
              "MR"], 
            StyleBox["]",
              "MR"]}], " "}
        }]], "MiddleSpanBox"],

Cell[BoxData[
    FormBox[GridBox[{
          {" ", Cell[TextData[{
              
              "Return the step mode for the algorithm object. The step mode \
should either be ",
              StyleBox["Automatic", "MR"],
              " or ",
              StyleBox["Fixed", "MR"],
              ". ",
              StyleBox["Automatic", "MR"],
              
              " means that the algorithm has a means to estimate error and \
determines an appropriate size ",
              StyleBox["newh", "TI"],
              " for the next time step. ",
              StyleBox["Fixed", "MR"],
              " ",
              
              "means that the algorithm will be called from a time step \
controller and is not expected to do any error estimation."
            }]]}
          }], TextFrom]], "BottomBox"],

Cell[TextData[{
  "Required method functions for algorithms used from ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Caption"],

Cell[TextData[{
  "These method functions must be defined for the algorithm work with ",
  StyleBox["NDSolve", "MR"],
  ". The Step method function should always return a list, but the length of \
the list depends on whether the step was successful or not. Also, some \
methods may need to compute the function value rhs[",
  StyleBox["t",
    FontSlant->"Italic"],
  " + ",
  StyleBox["h",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  " + \[CapitalDelta]",
  StyleBox["y",
    FontSlant->"Italic"],
  "] at the step end, so to avoid recomputation, you can add that to the \
list."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox["Step",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["rhs",
                    "TI"], 
                  StyleBox[",",
                    "SO10"], 
                  StyleBox[" ",
                    "SO10"], 
                  StyleBox["t",
                    "TI"], 
                  StyleBox[",",
                    "SO10"], 
                  StyleBox[" ",
                    "SO10"], 
                  StyleBox["h",
                    "TI"], 
                  StyleBox[",",
                    "SO10"], 
                  StyleBox[" ",
                    "SO10"], 
                  StyleBox["y",
                    "TI"], 
                  StyleBox[",",
                    "SO10"], 
                  StyleBox[" ",
                    "SO10"], 
                  StyleBox["yp",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox[" ",
                "SO10"], 
              StyleBox["method",
                "SO10"], 
              StyleBox[" ",
                "SO10"], 
              StyleBox["output",
                "SO10"]}], 
            StyleBox["Interpretation",
              "SO10"]},
          {
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                StyleBox["newh",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["\[CapitalDelta]y",
                  "TI"]}], 
              StyleBox["}",
                "MR"]}], Cell[TextData[{
              "successful step with computed solution increment ",
              StyleBox["\[CapitalDelta]y", "TI"],
              " and recommended next step ",
              StyleBox["newh.", "TI"]
            }], "Text"]},
          {
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                StyleBox["newh",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["\[CapitalDelta]y",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["yph",
                  "TI"]}], 
              StyleBox["}",
                "MR"]}], Cell[TextData[{
              "successful step with computed solution increment ",
              StyleBox["\[CapitalDelta]y", "TI"],
              " and recommended next step ",
              StyleBox["newh", "TI"],
              " and time derivatives computed at the step endpoint,",
              " ",
              StyleBox["yph", "TI"],
              StyleBox[" = ", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox["[", "MR"],
              StyleBox["t", "TI"],
              StyleBox[" + ", "MR"],
              StyleBox["h", "TI"],
              StyleBox[", ", "MR"],
              StyleBox["y", "TI"],
              StyleBox[" + ", "MR"],
              StyleBox["\[CapitalDelta]y", "TI"],
              StyleBox["]", "MR"],
              "."
            }], "Text"]},
          {
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                StyleBox["newh",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["\[CapitalDelta]y",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["yph",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["newobj",
                  "TI"]}], 
              StyleBox["}",
                "MR"]}], Cell[TextData[{
              "successful step with computed solution increment ",
              StyleBox["\[CapitalDelta]y", "TI"],
              " and recommended next step ",
              StyleBox["newh", "TI"],
              " and time derivatives computed at the step endpoint, ",
              StyleBox["yph", "TI"],
              StyleBox[" = ", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox["[", "MR"],
              StyleBox["t", "TI"],
              StyleBox[" + ", "MR"],
              StyleBox["h", "TI"],
              StyleBox[", ", "MR"],
              StyleBox["y", "TI"],
              StyleBox[" + ", "MR"],
              StyleBox["\[CapitalDelta]y", "TI"],
              StyleBox["]", "MR"],
              
              ". Any changes in the object data are returned in the new \
instance of the method object, ",
              StyleBox["newobj.", "TI"]
            }], "Text"]},
          {
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                StyleBox["newh",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["\[CapitalDelta]y",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["None",
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["newobj",
                  "TI"]}], 
              StyleBox["}",
                "MR"]}], 
            RowBox[{
              RowBox[{
              "successful", " ", "step", " ", "with", " ", "computed", " ", 
                "solution", " ", "increment", " ", 
                StyleBox["\[CapitalDelta]y",
                  "TI"], 
                StyleBox[" ",
                  "TI"], "and", " ", "recommended", " ", "next", " ", "step", 
                " ", 
                RowBox[{
                  StyleBox["newh",
                    "TI"], ".", " ", "Any"}], " ", "changes", " ", "in", " ", 
                "the", " ", "object", " ", "data", " ", "are", " ", 
                "returned", " ", "in", " ", "the", " ", "new", " ", 
                "instance", " ", "of", " ", "the", " ", "method", " ", 
                "object"}], ",", " ", 
              RowBox[{
                StyleBox["newobj",
                  "TI"], "."}]}]},
          {
            RowBox[{
              StyleBox["{",
                "MR"], 
              StyleBox["newh",
                "TI"], 
              StyleBox["}",
                "MR"]}], 
            RowBox[{
              RowBox[{
              "rejected", " ", "step", " ", "with", " ", "recommended", " ", 
                "next", " ", "step", " ", 
                StyleBox["newh",
                  "TI"], " ", "such", " ", "that"}], " ", "|", 
              StyleBox["newh",
                "TI"], "|", " ", 
              RowBox[{"<", " ", 
                RowBox[{"|", 
                  StyleBox["h",
                    "TI"], "|", "."}]}]}]},
          {
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                StyleBox["newh",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["$Failed",
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["None",
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["newobj",
                  "TI"]}], 
              StyleBox["}",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                "rejected", " ", "step", " ", "with", " ", "recommended", " ",
                   "next", " ", "step", " ", 
                  StyleBox["newh",
                    "TI"], " ", "such", " ", "that"}], " ", "|", 
                StyleBox["newh",
                  "TI"], "|", " ", 
                RowBox[{"<", " ", 
                  RowBox[{"|", 
                    StyleBox["h",
                      "TI"], 
                    "|", \(\(\(.\)\(\ \)\(Any\)\)\ changes\ in\ the\ object\ \
data\ are\ returned\ in\ the\ new\ instance\ of\ the\ method\ object\)}]}]}], 
              ",", " ", 
              RowBox[{
                StyleBox["newobj",
                  "TI"], "."}]}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell["Interpretation of Step method output.", "Caption"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Classical Runge-Kutta", "Section",
  CellTags->"s:2"],

Cell["\<\
Here is an example of how to set up and access a simple numerical \
algorithm.\
\>", "Text"],

Cell["\<\
This defines a method function to take a single step towards \
integrating an ODE using the classical fourth order RungeKutta method. Since \
the method is so simple, it is not necessary to save any private data.\
\>", \
"MathCaption"],

Cell[BoxData[
    \(\(CRK4[]\)["\<Step\>"[rhs_, \ t_, \ h_, \ y_, \ yp_]]\  := 
      Module[{k0, k1, k2, k3}, \[IndentingNewLine]k0 = 
          h\ yp; \[IndentingNewLine]k1 = 
          h\ rhs[t + h/2, y + k0/2]; \[IndentingNewLine]k2 = 
          h\ rhs[t + h/2, y + k1/2]; \[IndentingNewLine]k3 = 
          h\ rhs[t + h, 
              y + k2]; \[IndentingNewLine]{h, \ \((k0 + 2\ \ k1 + 2\ \ k2 + 
                k3)\)/6}]\)], "Input",
  CellLabel->"In[15]:="],

Cell[TextData[{
  "This defines a method function so that ",
  StyleBox["NDSolve", "MR"],
  " can obtain the proper difference order to use for the method. The ___ \
template is used because the difference order for the method is always 4."
}], "MathCaption"],

Cell[BoxData[
    \(\(CRK4[___]\)["\<DifferenceOrder\>"[]]\  := \ 4\)], "Input",
  CellLabel->"In[16]:="],

Cell[TextData[{
  "This defines a method function for the step mode so that ",
  StyleBox["NDSolve", "MR"],
  " will know how to control time steps. This algorithm method does not have \
any step control, so we define the step mode to be ",
  StyleBox["Fixed", "MR"],
  "."
}], "MathCaption"],

Cell[BoxData[
    \(\(CRK4[___]\)["\<Stepmode\>"[]]\  := \ Fixed\)], "Input",
  CellLabel->"In[17]:="],

Cell["\<\
This integrates the simple harmonic oscillator equation with fixed \
step size.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fixed\  = \ 
      NDSolve[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 0, \ 
          x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, 
        x, {t, 0, 2\ \[Pi]}, \ Method \[Rule] CRK4]\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 6.283185307179586`}}, "<>"]\),
            
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell[TextData[{
  "Generally using a fixed step size is less efficient than allowing the step \
size to vary with the local difficulty of the integration. Modern explicit \
Runge-Kutta methods (accessed in ",
  StyleBox["NDSolve", "MR"],
  " with ",
  StyleBox["Method->ExplicitRungeKutta", "MR"],
  ") have a so-called embedded error estimator that makes it possible to very \
efficiently determine appropriate step sizes. An alternative is to use \
built-in step controller methods that use extrapolation. The method ",
  StyleBox["DoubleStep", "MR"],
  " uses an extrapolation based on integrating a time step with a single step \
of size ",
  StyleBox["h",
    FontSlant->"Italic"],
  " and two steps of size ",
  StyleBox["h",
    FontSlant->"Italic"],
  "/2. The method ",
  StyleBox["Extrapolation", "MR"],
  " does a more sophisticated extrapolation and modifies the degree of \
extrapolation automatically as the integration is performed, but is generally \
used with base methods of difference orders 1 and 2."
}], "Text"],

Cell[TextData[{
  "This integrates the simple harmonic oscillator using the classical \
fourth-order Runge-Kutta method with steps controlled by using the ",
  StyleBox["DoubleStep", "MR"],
  " method."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dstep\  = \ 
      NDSolve[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 0, \ 
          x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, 
        x, {t, 0, 2\ \[Pi]}, \ 
        Method \[Rule] {DoubleStep, \ Method \[Rule] CRK4, \ 
            StiffnessTest \[Rule] False}]\)], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 6.283185307179586`}}, "<>"]\),
            
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[19]="]
}, Open  ]],

Cell[TextData[{
  "This makes a plot comparing the error in the computed solutions at the \
step ends.  The error for the ",
  StyleBox["DoubleStep", "MR"],
  " method is shown in blue."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ploterror[{sol_}, \ opts___]\  := \ 
        Module[{\[IndentingNewLine]points\  = \ 
              x@Coordinates[1]\  /. \ sol, \ \[IndentingNewLine]values\  = \ 
              x@ValuesOnGrid[]\  /. \ sol}, \ \[IndentingNewLine]ListPlot[
            Transpose[{points, \ values\  - \ Cos[points]}], \ 
            opts]\[IndentingNewLine]];\)\), "\[IndentingNewLine]", 
    \(\(Show[
        Block[{$DisplayFunction\  = \ 
              Identity}, {\[IndentingNewLine]ploterror[
              fixed], \[IndentingNewLine]ploterror[dstep, \ 
              PlotStyle \[Rule] 
                RGBColor[0, 0, 1]]\[IndentingNewLine]}]];\)\)}], "Input",
  CellLabel->"In[20]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.353883 1.0058e+007 [
[.17539 .34138 -3 -9 ]
[.17539 .34138 3 0 ]
[.32696 .34138 -3 -9 ]
[.32696 .34138 3 0 ]
[.47854 .34138 -3 -9 ]
[.47854 .34138 3 0 ]
[.63011 .34138 -3 -9 ]
[.63011 .34138 3 0 ]
[.78169 .34138 -3 -9 ]
[.78169 .34138 3 0 ]
[.93327 .34138 -3 -9 ]
[.93327 .34138 3 0 ]
[.01131 .05214 -39 -6.25 ]
[.01131 .05214 0 6.25 ]
[.01131 .15272 -39 -6.25 ]
[.01131 .15272 0 6.25 ]
[.01131 .2533 -39 -6.25 ]
[.01131 .2533 0 6.25 ]
[.01131 .45446 -33 -6.25 ]
[.01131 .45446 0 6.25 ]
[.01131 .55504 -33 -6.25 ]
[.01131 .55504 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .35388 m
.17539 .36013 L
s
[(1)] .17539 .34138 0 1 Mshowa
.32696 .35388 m
.32696 .36013 L
s
[(2)] .32696 .34138 0 1 Mshowa
.47854 .35388 m
.47854 .36013 L
s
[(3)] .47854 .34138 0 1 Mshowa
.63011 .35388 m
.63011 .36013 L
s
[(4)] .63011 .34138 0 1 Mshowa
.78169 .35388 m
.78169 .36013 L
s
[(5)] .78169 .34138 0 1 Mshowa
.93327 .35388 m
.93327 .36013 L
s
[(6)] .93327 .34138 0 1 Mshowa
.125 Mabswid
.05412 .35388 m
.05412 .35763 L
s
.08444 .35388 m
.08444 .35763 L
s
.11476 .35388 m
.11476 .35763 L
s
.14507 .35388 m
.14507 .35763 L
s
.2057 .35388 m
.2057 .35763 L
s
.23602 .35388 m
.23602 .35763 L
s
.26633 .35388 m
.26633 .35763 L
s
.29665 .35388 m
.29665 .35763 L
s
.35728 .35388 m
.35728 .35763 L
s
.38759 .35388 m
.38759 .35763 L
s
.41791 .35388 m
.41791 .35763 L
s
.44822 .35388 m
.44822 .35763 L
s
.50885 .35388 m
.50885 .35763 L
s
.53917 .35388 m
.53917 .35763 L
s
.56948 .35388 m
.56948 .35763 L
s
.5998 .35388 m
.5998 .35763 L
s
.66043 .35388 m
.66043 .35763 L
s
.69074 .35388 m
.69074 .35763 L
s
.72106 .35388 m
.72106 .35763 L
s
.75137 .35388 m
.75137 .35763 L
s
.81201 .35388 m
.81201 .35763 L
s
.84232 .35388 m
.84232 .35763 L
s
.87264 .35388 m
.87264 .35763 L
s
.90295 .35388 m
.90295 .35763 L
s
.96358 .35388 m
.96358 .35763 L
s
.9939 .35388 m
.9939 .35763 L
s
.25 Mabswid
0 .35388 m
1 .35388 L
s
.02381 .05214 m
.03006 .05214 L
s
gsave
.01131 .05214 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-3) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .15272 m
.03006 .15272 L
s
gsave
.01131 .15272 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .2533 m
.03006 .2533 L
s
gsave
.01131 .2533 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .45446 m
.03006 .45446 L
s
gsave
.01131 .45446 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .55504 m
.03006 .55504 L
s
gsave
.01131 .55504 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.125 Mabswid
.02381 .07226 m
.02756 .07226 L
s
.02381 .09237 m
.02756 .09237 L
s
.02381 .11249 m
.02756 .11249 L
s
.02381 .13261 m
.02756 .13261 L
s
.02381 .17284 m
.02756 .17284 L
s
.02381 .19295 m
.02756 .19295 L
s
.02381 .21307 m
.02756 .21307 L
s
.02381 .23319 m
.02756 .23319 L
s
.02381 .27342 m
.02756 .27342 L
s
.02381 .29353 m
.02756 .29353 L
s
.02381 .31365 m
.02756 .31365 L
s
.02381 .33377 m
.02756 .33377 L
s
.02381 .374 m
.02756 .374 L
s
.02381 .39411 m
.02756 .39411 L
s
.02381 .41423 m
.02756 .41423 L
s
.02381 .43435 m
.02756 .43435 L
s
.02381 .47458 m
.02756 .47458 L
s
.02381 .49469 m
.02756 .49469 L
s
.02381 .51481 m
.02756 .51481 L
s
.02381 .53493 m
.02756 .53493 L
s
.02381 .03203 m
.02756 .03203 L
s
.02381 .01191 m
.02756 .01191 L
s
.02381 .57516 m
.02756 .57516 L
s
.02381 .59527 m
.02756 .59527 L
s
.02381 .61539 m
.02756 .61539 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .35388 Mdot
.02839 .35389 Mdot
.03298 .35403 Mdot
.03756 .3543 Mdot
.04214 .35469 Mdot
.04673 .35521 Mdot
.05131 .35586 Mdot
.0559 .35663 Mdot
.06048 .35753 Mdot
.06506 .35855 Mdot
.06965 .35968 Mdot
.07423 .36094 Mdot
.07881 .36231 Mdot
.0834 .36379 Mdot
.08798 .36539 Mdot
.09256 .36709 Mdot
.09715 .3689 Mdot
.10173 .3708 Mdot
.10632 .37281 Mdot
.1109 .37491 Mdot
.11548 .3771 Mdot
.12007 .37938 Mdot
.12465 .38173 Mdot
.12923 .38417 Mdot
.13382 .38668 Mdot
.1384 .38925 Mdot
.14299 .39189 Mdot
.14757 .39459 Mdot
.15215 .39734 Mdot
.15674 .40013 Mdot
.16132 .40297 Mdot
.1659 .40585 Mdot
.17049 .40875 Mdot
.17507 .41169 Mdot
.17965 .41464 Mdot
.18424 .4176 Mdot
.18882 .42057 Mdot
.19341 .42355 Mdot
.19799 .42652 Mdot
.20257 .42947 Mdot
.20716 .43241 Mdot
.21174 .43533 Mdot
.21632 .43822 Mdot
.22091 .44107 Mdot
.22549 .44388 Mdot
.23008 .44664 Mdot
.23466 .44934 Mdot
.23924 .45198 Mdot
.24383 .45456 Mdot
.24841 .45706 Mdot
.25299 .45949 Mdot
.25758 .46182 Mdot
.26216 .46407 Mdot
.26674 .46622 Mdot
.27133 .46826 Mdot
.27591 .47019 Mdot
.2805 .47201 Mdot
.28508 .47371 Mdot
.28966 .47529 Mdot
.29425 .47673 Mdot
.29883 .47803 Mdot
.30341 .4792 Mdot
.308 .48022 Mdot
.31258 .48108 Mdot
.31716 .4818 Mdot
.32175 .48235 Mdot
.32633 .48274 Mdot
.33092 .48296 Mdot
.3355 .48301 Mdot
.34008 .48288 Mdot
.34467 .48258 Mdot
.34925 .48209 Mdot
.35383 .48142 Mdot
.35842 .48057 Mdot
.363 .47952 Mdot
.36759 .47828 Mdot
.37217 .47685 Mdot
.37675 .47523 Mdot
.38134 .4734 Mdot
.38592 .47138 Mdot
.3905 .46916 Mdot
.39509 .46674 Mdot
.39967 .46413 Mdot
.40425 .46131 Mdot
.40884 .45829 Mdot
.41342 .45507 Mdot
.41801 .45165 Mdot
.42259 .44804 Mdot
.42717 .44423 Mdot
.43176 .44023 Mdot
.43634 .43603 Mdot
.44092 .43164 Mdot
.44551 .42706 Mdot
.45009 .4223 Mdot
.45468 .41735 Mdot
.45926 .41223 Mdot
.46384 .40693 Mdot
.46843 .40145 Mdot
.47301 .39581 Mdot
.47759 .39001 Mdot
.48218 .38404 Mdot
.48676 .37792 Mdot
.49134 .37166 Mdot
.49593 .36524 Mdot
.50051 .35869 Mdot
.5051 .35201 Mdot
.50968 .3452 Mdot
.51426 .33827 Mdot
.51885 .33123 Mdot
.52343 .32408 Mdot
.52801 .31683 Mdot
.5326 .30948 Mdot
.53718 .30205 Mdot
.54177 .29455 Mdot
.54635 .28697 Mdot
.55093 .27934 Mdot
.55552 .27164 Mdot
.5601 .26391 Mdot
.56468 .25613 Mdot
.56927 .24833 Mdot
.57385 .24051 Mdot
.57843 .23267 Mdot
.58302 .22484 Mdot
.5876 .21701 Mdot
.59219 .20919 Mdot
.59677 .20141 Mdot
.60135 .19365 Mdot
.60594 .18594 Mdot
.61052 .17829 Mdot
.6151 .1707 Mdot
.61969 .16318 Mdot
.62427 .15574 Mdot
.62886 .14839 Mdot
.63344 .14114 Mdot
.63802 .13401 Mdot
.64261 .12699 Mdot
.64719 .1201 Mdot
.65177 .11336 Mdot
.65636 .10676 Mdot
.66094 .10031 Mdot
.66552 .09404 Mdot
.67011 .08794 Mdot
.67469 .08202 Mdot
.67928 .0763 Mdot
.68386 .07078 Mdot
.68844 .06547 Mdot
.69303 .06039 Mdot
.69761 .05552 Mdot
.70219 .0509 Mdot
.70678 .04652 Mdot
.71136 .04239 Mdot
.71594 .03852 Mdot
.72053 .03491 Mdot
.72511 .03158 Mdot
.7297 .02853 Mdot
.73428 .02577 Mdot
.73886 .0233 Mdot
.74345 .02113 Mdot
.74803 .01927 Mdot
.75261 .01771 Mdot
.7572 .01648 Mdot
.76178 .01556 Mdot
.76637 .01497 Mdot
.77095 .01472 Mdot
.77553 .01479 Mdot
.78012 .01521 Mdot
.7847 .01596 Mdot
.78928 .01706 Mdot
.79387 .01851 Mdot
.79845 .02031 Mdot
.80303 .02246 Mdot
.80762 .02496 Mdot
.8122 .02782 Mdot
.81679 .03103 Mdot
.82137 .0346 Mdot
.82595 .03853 Mdot
.83054 .04281 Mdot
.83512 .04744 Mdot
.8397 .05243 Mdot
.84429 .05778 Mdot
.84887 .06347 Mdot
.85346 .06951 Mdot
.85804 .0759 Mdot
.86262 .08263 Mdot
.86721 .0897 Mdot
.87179 .09711 Mdot
.87637 .10485 Mdot
.88096 .11292 Mdot
.88554 .1213 Mdot
.89012 .13001 Mdot
.89471 .13902 Mdot
.89929 .14834 Mdot
.90388 .15796 Mdot
.90846 .16787 Mdot
.91304 .17807 Mdot
.91763 .18854 Mdot
.92221 .19928 Mdot
.92679 .21028 Mdot
.93138 .22153 Mdot
.93596 .23303 Mdot
.94055 .24475 Mdot
.94513 .25671 Mdot
.94971 .26887 Mdot
.9543 .28124 Mdot
.95888 .2938 Mdot
.96346 .30654 Mdot
.96805 .31946 Mdot
.97212 .3311 Mdot
.97619 .34283 Mdot
0 0 1 r
.02381 .35388 Mdot
.03202 .35394 Mdot
.04756 .35664 Mdot
.0634 .35957 Mdot
.07955 .36267 Mdot
.09603 .36585 Mdot
.11287 .36901 Mdot
.13009 .37199 Mdot
.14776 .37462 Mdot
.16592 .37666 Mdot
.18404 .3771 Mdot
.20162 .37548 Mdot
.21871 .37224 Mdot
.23538 .36774 Mdot
.25166 .36228 Mdot
.26758 .35609 Mdot
.28317 .34939 Mdot
.29896 .34204 Mdot
.31506 .33398 Mdot
.33148 .32515 Mdot
.34826 .3155 Mdot
.36542 .30496 Mdot
.38301 .29344 Mdot
.40109 .2808 Mdot
.4193 .26782 Mdot
.43696 .25635 Mdot
.45413 .24654 Mdot
.47086 .23847 Mdot
.4872 .23217 Mdot
.50318 .22763 Mdot
.51882 .22483 Mdot
.53456 .22333 Mdot
.55061 .22307 Mdot
.56698 .22417 Mdot
.5837 .22677 Mdot
.6008 .23106 Mdot
.61832 .2372 Mdot
.63632 .24544 Mdot
.65463 .25619 Mdot
.67237 .26981 Mdot
.68961 .28564 Mdot
.70641 .3031 Mdot
.7228 .32172 Mdot
.73883 .34108 Mdot
.75452 .36083 Mdot
.77022 .38111 Mdot
.78622 .40215 Mdot
.80254 .42385 Mdot
.81921 .4461 Mdot
.83625 .4688 Mdot
.8537 .49183 Mdot
.87162 .51513 Mdot
.89002 .53853 Mdot
.90784 .55874 Mdot
.92516 .57562 Mdot
.94201 .58914 Mdot
.95847 .59932 Mdot
.96733 .60174 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[20]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool002[oo`03003ooooo0??oo`00:_oo00<00?ooool0looo000Zool00`00oooo
o`3cool002[oo`800;Coo`@00003ool0000000<003Koo`00:_oo00<00?ooool0/Ooo1P0000?oo`00
00001@00=?oo000Zool00`00ooooo`2^ool200000ooo0000000:ool200000ooo0000000aool002[o
o`03003ooooo0:goo`<0013oo`<0033oo`00:_oo00<00?ooool0[?oo0P005?oo0P00;ooo000Zool2
002/ool2000Fool2000^ool000Soo`8000?oo`03003ooooo00D000;oo`80017oo`03003ooooo0:[o
o`8001Soo`8002goo`001ooo00@00?ooool000?oo`05003oo`00ool00003ool01000ooooo`004?oo
00<00?ooool0ZOoo0P006_oo0P00;?oo0009ool00`00ooooo`03ool01000ooooo`000ooo00@00?oo
ool0013oo`03003ooooo0:Ooo`03003oo`0001coo`03003oo`0002[oo`0000?oo`0000000P001Ooo
00T00?ooooooo`00ool00?oo00000ooo00@00?ooool0013oo`03003ooooo0:Koo`80023oo`8002Wo
o`001ooo00@00?ooool000;oo`04003oooooool20003ool01000ooooo`004?oo0P00Y_oo0P008_oo
00<00?ooool09ooo0008ool20007ool20004ool2000Aool00`00ooooo`2Tool2000Tool00`00oooo
o`0Vool0027oo`<000Koo`03003ooooo0:?oo`8002Goo`8002Ooo`008Ooo00<00?oo00001_oo00<0
0?ooool0Xooo00<00?ooool09Ooo0P009_oo000Lool30003ool00`00ooooo`05ool00`00ooooo`2R
ool00`00ooooo`0Wool00`00ooooo`0Tool0027oo`03003oo`0000Koo`800:;oo`8002[oo`03003o
oooo02?oo`008Ooo0`001_oo00<00?ooool0XOoo00<00?ooool0:Ooo00<00?ooool08ooo000Zool0
0`00ooooo`2Oool00`00ooooo`0]ool00`00ooooo`0Qool002[oo`03003ooooo09koo`8002ooo`03
003ooooo027oo`00:_oo00<00?ooool0W_oo00<00?ooool0;ooo00<00?ooool08?oo000Zool2002N
ool00`00ooooo`0`ool2000Qool002[oo`03003ooooo09coo`8003?oo`03003ooooo01ooo`00:_oo
00<00?ooool0W?oo00<00?ooool0<ooo00<00?ooool07_oo000Zool00`00ooooo`2Kool00`00oooo
o`0dool00`00ooooo`0Nool002[oo`03003ooooo09[oo`8003Ooo`03003ooooo01goo`00:_oo0P00
Vooo00<00?ooool0=_oo00<00?ooool07Ooo000Zool00`00ooooo`2Iool00`00ooooo`0hool00`00
ooooo`0Lool002[oo`03003ooooo09Woo`03003ooooo03Soo`03003ooooo01coo`00:_oo00<00?oo
ool0Uooo00<00?ooool0FOoo000Zool00`00ooooo`2Gool00`00ooooo`0kool00`00ooooo`0Kool0
02[oo`8009Ooo`03003ooooo03coo`03003ooooo01_oo`00:_oo00<00?ooool0UOoo0P00@?oo00<0
0?ooool06Ooo0007ool40002ool00`00ooooo`050002ool2000Aool00`00ooooo`2Eool00`00oooo
o`0oool00`00ooooo`0Iool000Ooo`03003ooooo00Coo`05003oo`00ool00003ool01000ooooo`00
4?oo00<00?ooool0U?oo00<00?ooool0@Ooo00<00?ooool06?oo0008ool00`00ooooo`04ool01000
ooooo`000ooo00@00?ooool0013oo`03003ooooo09Coo`03003ooooo047oo`03003ooooo01Soo`00
00?oo`0000000P001?oo00<00?ooool00_oo00D00?oo003oo`0000?oo`04003ooooo000@ool2002D
ool00`00ooooo`1Mool000Ooo`04003ooooo0002ool01000oooooooo0P000ooo00@00?ooool0013o
o`03003ooooo09?oo`03003ooooo04?oo`03003ooooo01Ooo`002?oo0P001ooo0P001?oo0P002?oo
0`001_oo00<00?ooool0T_oo00<00?ooool0A?oo00<00?ooool05ooo000Qool00`00ool00006ool0
0`00ooooo`2Bool00`00ooooo`15ool00`00ooooo`0Fool001coo`<000?oo`03003ooooo00Goo`03
003ooooo093oo`03003ooooo04Ooo`03003ooooo01Koo`008Ooo00<00?oo00001_oo0P00TOoo00<0
0?ooool0H?oo000Qool30006ool00`00ooooo`2?ool00`00ooooo`19ool00`00ooooo`0Eool002[o
o`03003ooooo08ooo`03003ooooo04Woo`03003ooooo01Goo`00:_oo00<00?ooool0S_oo00<00?oo
ool0Booo00<00?ooool05?oo000Zool00`00ooooo`2>ool00`00ooooo`1;ool00`00ooooo`0Dool0
02[oo`8008koo`03003ooooo06?oo`00:_oo00<00?ooool0SOoo00<00?ooool0COoo00<00?ooool0
4ooo000Zool00`00ooooo`2<ool00`00ooooo`1>ool00`00ooooo`0Cool002[oo`03003ooooo08_o
o`8006Koo`00:_oo00<00?ooool0Rooo00<00?ooool0DOoo00<00?ooool04Ooo000Zool2002;ool0
0`00ooooo`1Bool00`00ooooo`0Aool002[oo`03003ooooo08[oo`03003ooooo06Koo`00:_oo00<0
0?ooool0N?oo00D07oooooooo`0O00?oo`0501ooooooool07`03ool00`00ooooo`1Eool00`00oooo
o`0@ool002[oo`03003ooooo07Coo`0501ooooooool07`03ool01@0Ooooooooo01l00ooo00H07ooo
ooooo`0001mFool00`00ooooo`0@ool002[oo`03003ooooo073oo`0501ooooooool07`0Bool00`00
ool07`03ool00`0Oooooo`1Aool00`00ooooo`0?ool002[oo`80077oo`0301oooooo01Coo`03003o
oooo00?oo`0301oooooo057oo`03003ooooo00ooo`00:_oo00<00?ooool0K?oo00<07oooool05ooo
00<00?ooool02?oo00<07oooool0Gooo0007ool500001?oo003ooooo1@000_oo0P004Ooo00<00?oo
ool0K?oo00<07oooool05ooo00<00?ooool02?oo00<07oooool0C_oo00<00?ooool03_oo0009ool0
0`00ooooo`02ool01@00ool00?oo00000ooo00@00?ooool0013oo`03003ooooo06Soo`0301oooooo
01[oo`03003ooooo00koo`0301oooooo04Woo`03003ooooo00koo`002Ooo00<00?ooool00ooo00@0
0?ooool000?oo`04003ooooo000@ool00`00ooooo`1Xool00`0Oooooo`0Jool00`00ooooo`0>ool0
0`0Oooooo`1Jool00003ool00000008000Coo`03003ooooo00;oo`05003oo`00ool00003ool01000
ooooo`004?oo0P00IOoo00<07oooool07Ooo00<00?ooool04ooo00<07oooool0A_oo00<00?ooool0
3Ooo0009ool01@00oooooooo00000ooo0P000ooo00@00?ooool0013oo`03003ooooo06Coo`0301oo
oooo01goo`03003ooooo01?oo`0301oooooo04Koo`03003ooooo00goo`002?oo0P001ooo0P001?oo
0P002?oo0`001_oo00<00?ooool0Pooo00<00?ooool0KOoo000Qool00`00ool00006ool00`00oooo
o`1Oool00`0Oooooo`0Qool00`00ooooo`1Nool00`00ooooo`0<ool001coo`<000?oo`03003ooooo
00Goo`03003ooooo05ooo`0301oooooo023oo`03003ooooo01[oo`0301oooooo04;oo`03003ooooo
00coo`008Ooo00<00?oo00001_oo0P00Pooo00<00?ooool06_oo00<07oooool0DOoo000Qool30006
ool00`00ooooo`1Kool00`0Oooooo`0Rool00`00ooooo`1`ool002[oo`03003ooooo05_oo`0301oo
oooo02;oo`03003ooooo06?oo`03003ooooo00[oo`00:_oo00<00?ooool0Oooo00<00?ooool08Ooo
00<07oooool0@?oo00<00?ooool02_oo000Zool00`00ooooo`1oool00`00ooooo`0Qool00`0Ooooo
o`1=ool002[oo`8005Ooo`0301oooooo02Goo`03003ooooo06Koo`03003ooooo00Woo`00:_oo00<0
0?ooool0E_oo00<07oooool09Ooo00<00?ooool0I_oo00<00?ooool02Ooo000Zool00`00ooooo`1m
ool00`00ooooo`0Wool00`0Oooooo`19ool002[oo`03003ooooo05;oo`0301oooooo02Soo`03003o
oooo02Ooo`0301oooooo03koo`03003ooooo00Soo`00:_oo00<00?ooool08Ooo1@008Ooo10001ooo
00<07oooool06Ooo0P003?oo00<00?ooool05_oo0`008_oo0P008ooo0`001_oo00<00?ooool02?oo
000Zool2000Tool00`00ooooo`0Qool00`00ooooo`04ool00`0Oooooo`0Lool01000ooooo`002_oo
0P006Ooo00<00?ooool08?oo00@00?ooool002;oo`04003ooooo000@ool002[oo`03003ooooo02?o
o`03003ooooo02;oo`03003ooooo00?oo`0301oooooo01koo`03003ooooo00Woo`03003ooooo01Go
o`D002Coo`03003ooooo023oo`04003ooooo0006ool00`00ooooo`07ool002[oo`03003ooooo02?o
o`03003ooooo02?oo`03003ooooo02Coo`03003ooooo00Koo`03003ooooo01Ooo`04003ooooo000D
ool00`0Oooooo`0<ool2000Sool30007ool00`00ooooo`07ool002[oo`03003ooooo02?oo`03003o
oooo027oo`04003oo`0O000Rool01000ooooo`002?oo00<00?ooool06?oo00<00?oo00005?oo00<0
7oooool03?oo00<00?ooool08ooo00<00?ooool04?oo000Zool00`00ooooo`0Rool2000Tool00`00
01ooo`0Sool20008ool00`00ooooo`0Jool2000Sool3000Sool30007ool00`00ooooo`06ool002[o
o`8004Koo`0301oooooo033oo`03003ooooo06ooo`03003ooooo00Koo`00:_oo00<00?ooool0AOoo
00<07oooool0;ooo00<00?ooool0NOoo000Zool00`00ooooo`11ool00`0Oooooo`0cool00`00oooo
o`0eool00`0Oooooo`0iool00`00ooooo`05ool002[oo`03003ooooo047oo`0301oooooo03;oo`03
003ooooo03Koo`0301oooooo03Woo`03003ooooo00Goo`00:_oo00<00?ooool0?Ooo00<07oooool0
=Ooo0P00O?oo000Tool500000`0O00007`0300000`0O0000000d00001@0O0000000001l0]@00000Y
ool0100O00007ooo0P0000L07`000000000Oool00003ool00`00ooooo`04ool00`00ooooo`05ool0
0`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`0Oooooo`05ool0
0`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool0
0`00ooooo`05ool00`00ooooo`02ool00`00ool00007ool00`00ooooo`05ool00`00ooooo`04ool0
0`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`04ool0
0`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`04ool0
0`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool10001ool1ool002[oo`03003ooooo00Go
o`0300007ooo0080000301l00?oo01Koo`03003ooooo00ooo`0301oooooo017oo`03003ooooo02?o
o`03003ooooo00;oo`03003ooooo01koo`03003ooooo01_oo`0301oooooo00Goo`03003ooooo02?o
o`03003ooooo00ooo`00:_oo00<00?ooool02Ooo00<0000O00000P0000<07oooool08?oo00D07ooo
ooooo`0O03goo`03003ooooo03goo`0301oooooo03goo`00:_oo00<00?ooool03?oo0P0000D07`00
003oo`0O00Coo`0301oooooo01?oo`0501ooooooool07`0oool00`00ool0001oool002[oo`80013o
o`<0000301oooooo00;oo`0501ooooooool07`04ool00`0Oooooo`06ool01@0Ooooooooo01l0@ooo
00<00?ooool0Oooo000Zool00`00ooooo`0Aool40006ool00`0Oooooo`02ool01@0Ooooooooo01l0
1?oo00<07oooool0A?oo00<00?ooool0P?oo000Zool00`00ooooo`0Cool300000ooo003oo`0;ool0
0`0Oooooo`18ool20016ool00`0Oooooo`0iool002[oo`03003ooooo01Goo`04003oo`00001Fool0
0`00ooooo`15ool00`0Oooooo`0iool002[oo`03003ooooo01Soo`<005?oo`03003ooooo08;oo`00
:_oo0P006_oo0`00DOoo0P00Q?oo000Zool00`00ooooo`0Kool3001?ool00`00ooooo`23ool002[o
o`03003ooooo01coo`800003ool00?oo04_oo`03003ooooo04coo`0301oooooo03Goo`00:_oo00<0
0?ooool07ooo0P00B_oo0P00C_oo00<07oooool0=Ooo000Zool00`00ooooo`0Pool30016ool00`00
ool00027ool002[oo`8002;oo`<004Goo`03003ooooo08Ooo`00:_oo00<00?ooool08ooo0P00@ooo
00<00?ooool0R?oo000Zool00`00ooooo`0Tool01000ool00000?ooo0P00E_oo00<07oooool0<Ooo
000Zool00`00ooooo`0Vool3000mool2001Gool00`0Oooooo`0aool002[oo`03003ooooo02Soo`<0
03[oo`8008coo`00:_oo0P00:_oo0`00>?oo0P00SOoo000Zool00`00ooooo`0[ool2000eool00`00
ool0002>ool000Ooo`D00004ool00?ooool50002ool2000Aool00`00ooooo`0/ool01000ool00000
<Ooo0P00T?oo0009ool00`00ooooo`02ool01@00ool00?oo00000ooo00@00?ooool0013oo`03003o
oooo02koo`<002ooo`8006;oo`0301oooooo02coo`002Ooo00<00?ooool00ooo00@00?ooool000?o
o`04003ooooo000@ool00`00ooooo`0`ool3000/ool2001Sool00`0Oooooo`0/ool000Woo`03003o
oooo00;oo`05003oo`00ool00003ool01000ooooo`004?oo00<00?ooool0<Ooo0`00:_oo0P00Tooo
0009ool01@00oooooooo00000ooo0P000ooo00@00?ooool0013oo`8003Coo`800003ool00?oo02Go
o`8009Coo`002?oo0P001ooo0P001?oo0P004Ooo00<00?ooool0=?oo00<00?oo00000P008Ooo00@0
0?oo000009Goo`008Ooo0`001_oo00<00?ooool0=ooo10007_oo0P0000?oo`00ool0UOoo000Qool0
0`00ool00006ool00`00ooooo`0iool300000ooo003oo`0Hool3001^ool00`0Oooooo`0Xool001co
o`<000?oo`03003ooooo00Goo`03003ooooo03_oo`03003oo`00008001Goo`@006ooo`0301oooooo
02Soo`008Ooo00<00?oo00001_oo0P00?ooo1P003Ooo0P0000Coo`00000009coo`008Ooo0`001_oo
00<00?ooool0@?oo100000?oo`0000001@0000?oo`000000100000?oo`00ool0WOoo000Zool00`00
ooooo`15ool700000ooo00000002002Rool002[oo`03003ooooo0<coo`0301oooooo02Coo`00:_oo
00<00?ooool0c?oo00<07oooool09?oo000Zool2003dool002[oo`03003ooooo0??oo`00:_oo00<0
0?ooool0looo000Zool00`00ooooo`3cool002[oo`03003ooooo0=7oo`0301oooooo01ooo`00:_oo
0P00d_oo00<07oooool07ooo000Zool00`00ooooo`3cool002[oo`03003ooooo0??oo`00:_oo00<0
0?ooool0looo000Zool00`00ooooo`3cool002[oo`800=Koo`0301oooooo01_oo`001ooo10000_oo
00<00?ooool01@000_oo0P004Ooo00<00?ooool0eOoo00<07oooool06ooo0007ool00`00ooooo`04
ool01@00ool00?oo00000ooo00@00?ooool0013oo`03003ooooo0??oo`002?oo00<00?ooool01?oo
00@00?ooool000?oo`04003ooooo000@ool00`00ooooo`3cool000Woo`03003ooooo00;oo`05003o
o`00ool00003ool01000ooooo`004?oo00<00?ooool0looo0007ool01000ooooo`000_oo00@00?oo
ooooo`8000?oo`04003ooooo000@ool2003Kool00`0Oooooo`0Fool000Soo`8000Ooo`8000Coo`80
017oo`03003ooooo0=[oo`0301oooooo01Koo`008Ooo0`001_oo00<00?ooool0looo000Qool00`00
ool00006ool00`00ooooo`3cool001coo`<000?oo`03003ooooo00Goo`03003ooooo0=koo`0301oo
oooo01;oo`008Ooo00<00?oo00001_oo0P00gooo00<07oooool04_oo000Qool30006ool00`00oooo
o`3cool002[oo`03003ooooo0??oo`00:_oo00<00?ooool0h_oo00<07oooool03_oo000Zool00`00
ooooo`3Rool00`0Oooooo`0>ool002[oo`800>Soo`0301oooooo00Woo`00:_oo00<00?ooool0iooo
00D07ooo01ooo`0O00Ooo`00:_oo00<00?ooool0jOoo00<07ooo01l01ooo000Zool00`00ooooo`3c
ool002[oo`03003ooooo0??oo`00:_oo0P00m?oo000Zool00`00ooooo`3cool00?ooob7oo`00oooo
8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool0
0?ooob7oo`00\
\>"],
  ImageRangeCache->{{{0, 358.75}, {221.125, 0}} -> {-1.10826, -3.95273*^-8, \
0.0263016, 3.9637*^-10}}]
}, Open  ]],

Cell["\<\
The fixed step size ended up with smaller overall error mostly \
because the steps are so much smaller; it required more than three times as \
many steps. For a problem where the local solution structure changes more \
significantly, the difference can be even greater.\
\>", "Text"],

Cell[TextData[{
  "In computing the solution above, the option ",
  StyleBox["StiffnessTest->False", "MR"],
  " was used for the ",
  StyleBox["DoubleStep", "MR"],
  " adaptive step method.  For simple equations like the harmonic oscillator \
that are known not to be stiff, this setting is fine.  However, if you plan \
to work with equations where the properties of the solution are not known, it \
is better to leave the stiffness test active, since otherwise you may get \
solutions corrupted from instability.  The stiffness test requires the ",
  StyleBox["LinearStabilityBoundary", "MR"],
  " property be defined for the method."
}], "Text"],

Cell[TextData[{
  "One way to gain some understanding of the ",
  StyleBox["LinearStabilityBoundary", "MR"],
  " property is to use the ",
  StyleBox["OrderStar", "MR"],
  " package, which can plot the linear stability region for methods."
}], "Text"],

Cell[TextData[{
  "This loads the ",
  StyleBox["OrderStar", "MR"],
  " package."
}], "MathCaption"],

Cell[BoxData[
    \(\(Needs["\<NumericalMath`OrderStar`\>"];\)\)], "Input",
  CellLabel->"In[22]:="],

Cell["\<\
The linear stability region for a method is the region in the \
complex z = h\[Lambda] plane where the method with step h applied to the test \
equation x' = \[Lambda]x has modulus less than |x|, so that errors are not \
amplified.  \
\>", "Text"],

Cell[TextData[{
  "This computes symbolically a step for the ",
  StyleBox["CRK4", "MR"],
  " method as defined above."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CRK4[]\)["\<Step\>"[Function[{t, x}, \ \[Lambda]\ x], \ t, h, 
        x, \[Lambda]\ x]]\)], "Input",
  CellLabel->"In[23]:="],

Cell[BoxData[
    \({h, 
      1\/6\ \((h\ x\ \[Lambda] + 
            2\ h\ \[Lambda]\ \((x + \(h\ x\ \[Lambda]\)\/2)\) + 
            2\ h\ \[Lambda]\ \((x + 
                  1\/2\ h\ \[Lambda]\ \((x + \(h\ x\ \[Lambda]\)\/2)\))\) + 
            h\ \[Lambda]\ \((x + 
                  h\ \[Lambda]\ \((x + 
                        1\/2\ h\ \[Lambda]\ \((x + \(h\ x\ \[Lambda]\)\/2)\))\
\))\))\)}\)], "Output",
  CellLabel->"Out[23]="]
}, Open  ]],

Cell[TextData[{
  "This computes the factor multiplying x, converting h\[Lambda]->z.  Note \
that x had to be added to the result of the method because the ",
  StyleBox["\"Step\"", "MR"],
  " function was defined to only return the increment."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\ \)\(poly\  = 
      Expand[\((x\  + Last[%])\)/
            x\  /. \ {h \[Rule] 1, \ \[Lambda] \[Rule] z}]\)\)\)], "Input",
  CellLabel->"In[24]:="],

Cell[BoxData[
    \(1 + z + z\^2\/2 + z\^3\/6 + z\^4\/24\)], "Output",
  CellLabel->"Out[24]="]
}, Open  ]],

Cell["\<\
The absolute stability region for the method is shown in \
white.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(OrderStar[poly, \ 1, \ Ticks \[Rule] True];\)\)], "Input",
  CellLabel->"In[25]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 2.00373 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 2.00373 [
[ 0 0 0 0 ]
[ 1 2.00373 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 2.00373 L
0 2.00373 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 2.00373 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.703547 0.23539 1.00187 0.23539 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 2.00373 .125 0 ]
[ 1 0 .125 0 ]
[.23277 .98937 -6 -9 ]
[.23277 .98937 6 0 ]
[.46816 .98937 -6 -9 ]
[.46816 .98937 6 0 ]
[.93894 .98937 -3 -9 ]
[.93894 .98937 3 0 ]
[.69105 .06031 -12 -4.5 ]
[.69105 .06031 0 4.5 ]
[.69105 .53109 -12 -4.5 ]
[.69105 .53109 0 4.5 ]
[.69105 1.47265 -6 -4.5 ]
[.69105 1.47265 0 4.5 ]
[.69105 1.94342 -6 -4.5 ]
[.69105 1.94342 0 4.5 ]
[ 0 0 0 0 ]
[ 1 2.00373 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 2.00373 L
s
0 2.00373 m
1 2.00373 L
s
1 0 m
1 2.00373 L
s
.23277 1.00187 m
.23277 1.00812 L
s
[(-2)] .23277 .98937 0 1 Mshowa
.46816 1.00187 m
.46816 1.00812 L
s
[(-1)] .46816 .98937 0 1 Mshowa
.93894 1.00187 m
.93894 1.00812 L
s
[(1)] .93894 .98937 0 1 Mshowa
.125 Mabswid
.04446 1.00187 m
.04446 1.00562 L
s
.09153 1.00187 m
.09153 1.00562 L
s
.13861 1.00187 m
.13861 1.00562 L
s
.18569 1.00187 m
.18569 1.00562 L
s
.27985 1.00187 m
.27985 1.00562 L
s
.32692 1.00187 m
.32692 1.00562 L
s
.374 1.00187 m
.374 1.00562 L
s
.42108 1.00187 m
.42108 1.00562 L
s
.51523 1.00187 m
.51523 1.00562 L
s
.56231 1.00187 m
.56231 1.00562 L
s
.60939 1.00187 m
.60939 1.00562 L
s
.65647 1.00187 m
.65647 1.00562 L
s
.75062 1.00187 m
.75062 1.00562 L
s
.7977 1.00187 m
.7977 1.00562 L
s
.84478 1.00187 m
.84478 1.00562 L
s
.89186 1.00187 m
.89186 1.00562 L
s
.98601 1.00187 m
.98601 1.00562 L
s
.25 Mabswid
0 1.00187 m
1 1.00187 L
s
.70355 .06031 m
.7098 .06031 L
s
[(-4)] .69105 .06031 1 0 Mshowa
.70355 .53109 m
.7098 .53109 L
s
[(-2)] .69105 .53109 1 0 Mshowa
.70355 1.47265 m
.7098 1.47265 L
s
[(2)] .69105 1.47265 1 0 Mshowa
.70355 1.94342 m
.7098 1.94342 L
s
[(4)] .69105 1.94342 1 0 Mshowa
.125 Mabswid
.70355 .178 m
.7073 .178 L
s
.70355 .2957 m
.7073 .2957 L
s
.70355 .41339 m
.7073 .41339 L
s
.70355 .64878 m
.7073 .64878 L
s
.70355 .76648 m
.7073 .76648 L
s
.70355 .88417 m
.7073 .88417 L
s
.70355 1.11956 m
.7073 1.11956 L
s
.70355 1.23726 m
.7073 1.23726 L
s
.70355 1.35495 m
.7073 1.35495 L
s
.70355 1.59034 m
.7073 1.59034 L
s
.70355 1.70804 m
.7073 1.70804 L
s
.70355 1.82573 m
.7073 1.82573 L
s
.25 Mabswid
.70355 0 m
.70355 2.00373 L
s
0 0 m
1 0 L
1 2.00373 L
0 2.00373 L
closepath
clip
newpath
.5 g
0 2.00373 m
1 2.00373 L
1 0 L
0 0 L
F
1 g
.55696 .32758 m
.56962 .32182 L
.58228 .31728 L
.59494 .31391 L
.60759 .31169 L
.62025 .31061 L
.63291 .31067 L
.64557 .31193 L
.65823 .31444 L
.67089 .31832 L
.68354 .32373 L
.69428 .32973 L
.6962 .33092 L
.70886 .34007 L
.72152 .35239 L
.72385 .35509 L
.73418 .36815 L
.74112 .38046 L
.74684 .39093 L
.75165 .40582 L
.7574 .43118 L
.75941 .45655 L
.75833 .48191 L
.75472 .50727 L
.74914 .53264 L
.74684 .54153 L
.74225 .558 L
.73479 .58337 L
.73418 .58544 L
.72752 .60873 L
.72152 .63196 L
.72102 .63409 L
.71567 .65946 L
.71155 .68482 L
.70886 .70729 L
.70858 .71018 L
.70655 .73555 L
.70523 .76091 L
.70443 .78628 L
.70397 .81164 L
.70373 .837 L
.70361 .86237 L
.70357 .88773 L
.70355 .91309 L
.70355 .93846 L
.70355 .96382 L
.70355 .98919 L
.70355 1.01455 L
.70355 1.03991 L
.70355 1.06528 L
.70355 1.09064 L
.70357 1.116 L
.70361 1.14137 L
.70373 1.16673 L
.70397 1.19209 L
.70443 1.21746 L
.70523 1.24282 L
.70655 1.26819 L
.70858 1.29355 L
.70886 1.29644 L
.71155 1.31891 L
.71567 1.34428 L
.72102 1.36964 L
.72152 1.37177 L
.72752 1.395 L
.73418 1.41829 L
.73479 1.42037 L
.74225 1.44573 L
.74684 1.4622 L
.74914 1.4711 L
.75472 1.49646 L
.75833 1.52182 L
.75941 1.54719 L
.7574 1.57255 L
.75165 1.59791 L
.74684 1.61281 L
.74112 1.62328 L
.73418 1.63559 L
.72385 1.64864 L
.72152 1.65135 L
.70886 1.66366 L
.6962 1.67281 L
.69428 1.67401 L
.68354 1.68 L
.67089 1.68542 L
.65823 1.68929 L
.64557 1.69181 L
.63291 1.69306 L
.62025 1.69313 L
.60759 1.69204 L
.59494 1.68982 L
.58228 1.68646 L
.56962 1.68191 L
.55696 1.67615 L
.55283 1.67401 L
.5443 1.66934 L
.53165 1.66125 L
.51899 1.65178 L
.51514 1.64864 L
.50633 1.64135 L
.49367 1.62967 L
.48718 1.62328 L
.48101 1.61721 L
.46835 1.60417 L
.46237 1.59791 L
.4557 1.59104 L
.44304 1.57822 L
.43725 1.57255 L
.43038 1.56605 L
.41772 1.55471 L
.40871 1.54719 L
.40506 1.54426 L
.39241 1.53465 L
.37975 1.52578 L
.37379 1.52182 L
.36709 1.51752 L
.35443 1.50973 L
.34177 1.5023 L
.33151 1.49646 L
.32911 1.49511 L
.31646 1.48806 L
.3038 1.48106 L
.29114 1.47401 L
.28595 1.4711 L
.27848 1.46685 L
.26582 1.45948 L
.25316 1.45184 L
.24344 1.44573 L
.24051 1.44384 L
.22785 1.43542 L
.21519 1.42647 L
.20701 1.42037 L
.20253 1.41691 L
.18987 1.40664 L
.17722 1.39552 L
.17666 1.395 L
.16456 1.38342 L
.1519 1.37011 L
.15147 1.36964 L
.13924 1.3554 L
.13056 1.34428 L
.12658 1.3389 L
.11392 1.32011 L
.11317 1.31891 L
.10127 1.29834 L
.09876 1.29355 L
.08861 1.27224 L
.08688 1.26819 L
.07717 1.24282 L
.07595 1.23928 L
.06934 1.21746 L
.06329 1.19279 L
.06314 1.19209 L
.05834 1.16673 L
.05472 1.14137 L
.05208 1.116 L
.05063 1.09725 L
.05024 1.09064 L
.04902 1.06528 L
.04829 1.03991 L
.04796 1.01455 L
.04796 .98919 L
.04829 .96382 L
.04902 .93846 L
.05024 .91309 L
.05063 .90648 L
.05208 .88773 L
.05472 .86237 L
.05834 .837 L
.06314 .81164 L
.06329 .81094 L
.06934 .78628 L
.07595 .76445 L
.07717 .76091 L
.08688 .73555 L
.08861 .7315 L
.09876 .71018 L
.10127 .70539 L
.11317 .68482 L
.11392 .68362 L
.12658 .66483 L
.13056 .65946 L
.13924 .64833 L
.15147 .63409 L
.1519 .63362 L
.16456 .62031 L
.17666 .60873 L
.17722 .60822 L
.18987 .59709 L
.20253 .58682 L
.20701 .58337 L
.21519 .57726 L
.22785 .56832 L
.24051 .55989 L
.24344 .558 L
.25316 .5519 L
.26582 .54425 L
.27848 .53689 L
.28595 .53264 L
.29114 .52972 L
.3038 .52268 L
.31646 .51567 L
.32911 .50862 L
.33151 .50727 L
.34177 .50144 L
.35443 .49401 L
.36709 .48622 L
.37379 .48191 L
.37975 .47795 L
.39241 .46908 L
.40506 .45947 L
.40871 .45655 L
.41772 .44902 L
.43038 .43769 L
.43725 .43118 L
.44304 .42551 L
.4557 .41269 L
.46237 .40582 L
.46835 .39956 L
.48101 .38653 L
.48718 .38046 L
.49367 .37406 L
.50633 .36238 L
.51514 .35509 L
.51899 .35196 L
.53165 .34248 L
.5443 .3344 L
.55283 .32973 L
F
0 g
.5 Mabswid
.55696 .32758 m
.56962 .32182 L
.58228 .31728 L
.59494 .31391 L
.60759 .31169 L
.62025 .31061 L
.63291 .31067 L
.64557 .31193 L
.65823 .31444 L
.67089 .31832 L
.68354 .32373 L
.69428 .32973 L
.6962 .33092 L
.70886 .34007 L
.72152 .35239 L
.72385 .35509 L
.73418 .36815 L
.74112 .38046 L
.74684 .39093 L
.75165 .40582 L
.7574 .43118 L
.75941 .45655 L
.75833 .48191 L
.75472 .50727 L
.74914 .53264 L
.74684 .54153 L
.74225 .558 L
.73479 .58337 L
.73418 .58544 L
.72752 .60873 L
.72152 .63196 L
.72102 .63409 L
.71567 .65946 L
.71155 .68482 L
.70886 .70729 L
.70858 .71018 L
.70655 .73555 L
.70523 .76091 L
.70443 .78628 L
.70397 .81164 L
.70373 .837 L
.70361 .86237 L
.70357 .88773 L
.70355 .91309 L
.70355 .93846 L
.70355 .96382 L
.70355 .98919 L
.70355 1.01455 L
.70355 1.03991 L
.70355 1.06528 L
Mistroke
.70355 1.09064 L
.70357 1.116 L
.70361 1.14137 L
.70373 1.16673 L
.70397 1.19209 L
.70443 1.21746 L
.70523 1.24282 L
.70655 1.26819 L
.70858 1.29355 L
.70886 1.29644 L
.71155 1.31891 L
.71567 1.34428 L
.72102 1.36964 L
.72152 1.37177 L
.72752 1.395 L
.73418 1.41829 L
.73479 1.42037 L
.74225 1.44573 L
.74684 1.4622 L
.74914 1.4711 L
.75472 1.49646 L
.75833 1.52182 L
.75941 1.54719 L
.7574 1.57255 L
.75165 1.59791 L
.74684 1.61281 L
.74112 1.62328 L
.73418 1.63559 L
.72385 1.64864 L
.72152 1.65135 L
.70886 1.66366 L
.6962 1.67281 L
.69428 1.67401 L
.68354 1.68 L
.67089 1.68542 L
.65823 1.68929 L
.64557 1.69181 L
.63291 1.69306 L
.62025 1.69313 L
.60759 1.69204 L
.59494 1.68982 L
.58228 1.68646 L
.56962 1.68191 L
.55696 1.67615 L
.55283 1.67401 L
.5443 1.66934 L
.53165 1.66125 L
.51899 1.65178 L
.51514 1.64864 L
.50633 1.64135 L
Mistroke
.49367 1.62967 L
.48718 1.62328 L
.48101 1.61721 L
.46835 1.60417 L
.46237 1.59791 L
.4557 1.59104 L
.44304 1.57822 L
.43725 1.57255 L
.43038 1.56605 L
.41772 1.55471 L
.40871 1.54719 L
.40506 1.54426 L
.39241 1.53465 L
.37975 1.52578 L
.37379 1.52182 L
.36709 1.51752 L
.35443 1.50973 L
.34177 1.5023 L
.33151 1.49646 L
.32911 1.49511 L
.31646 1.48806 L
.3038 1.48106 L
.29114 1.47401 L
.28595 1.4711 L
.27848 1.46685 L
.26582 1.45948 L
.25316 1.45184 L
.24344 1.44573 L
.24051 1.44384 L
.22785 1.43542 L
.21519 1.42647 L
.20701 1.42037 L
.20253 1.41691 L
.18987 1.40664 L
.17722 1.39552 L
.17666 1.395 L
.16456 1.38342 L
.1519 1.37011 L
.15147 1.36964 L
.13924 1.3554 L
.13056 1.34428 L
.12658 1.3389 L
.11392 1.32011 L
.11317 1.31891 L
.10127 1.29834 L
.09876 1.29355 L
.08861 1.27224 L
.08688 1.26819 L
.07717 1.24282 L
.07595 1.23928 L
Mistroke
.06934 1.21746 L
.06329 1.19279 L
.06314 1.19209 L
.05834 1.16673 L
.05472 1.14137 L
.05208 1.116 L
.05063 1.09725 L
.05024 1.09064 L
.04902 1.06528 L
.04829 1.03991 L
.04796 1.01455 L
.04796 .98919 L
.04829 .96382 L
.04902 .93846 L
.05024 .91309 L
.05063 .90648 L
.05208 .88773 L
.05472 .86237 L
.05834 .837 L
.06314 .81164 L
.06329 .81094 L
.06934 .78628 L
.07595 .76445 L
.07717 .76091 L
.08688 .73555 L
.08861 .7315 L
.09876 .71018 L
.10127 .70539 L
.11317 .68482 L
.11392 .68362 L
.12658 .66483 L
.13056 .65946 L
.13924 .64833 L
.15147 .63409 L
.1519 .63362 L
.16456 .62031 L
.17666 .60873 L
.17722 .60822 L
.18987 .59709 L
.20253 .58682 L
.20701 .58337 L
.21519 .57726 L
.22785 .56832 L
.24051 .55989 L
.24344 .558 L
.25316 .5519 L
.26582 .54425 L
.27848 .53689 L
.28595 .53264 L
.29114 .52972 L
Mistroke
.3038 .52268 L
.31646 .51567 L
.32911 .50862 L
.33151 .50727 L
.34177 .50144 L
.35443 .49401 L
.36709 .48622 L
.37379 .48191 L
.37975 .47795 L
.39241 .46908 L
.40506 .45947 L
.40871 .45655 L
.41772 .44902 L
.43038 .43769 L
.43725 .43118 L
.44304 .42551 L
.4557 .41269 L
.46237 .40582 L
.46835 .39956 L
.48101 .38653 L
.48718 .38046 L
.49367 .37406 L
.50633 .36238 L
.51514 .35509 L
.51899 .35196 L
.53165 .34248 L
.5443 .3344 L
.55283 .32973 L
.55696 .32758 L
Mfstroke
1 g
.63319 1.10205 m
.73319 1.10205 L
.73319 .90168 L
.63319 .90168 L
F
.5 g
.70356 1.10205 m
.70355 1.09692 L
.70355 1.09178 L
.70355 1.08664 L
.70355 1.0815 L
.70355 1.07636 L
.70355 1.07123 L
.70355 1.06609 L
.70355 1.06095 L
.70355 1.05581 L
.70355 1.05068 L
.70355 1.04554 L
.70355 1.0404 L
.70355 1.03526 L
.70355 1.03012 L
.70355 1.02499 L
.70355 1.01985 L
.70355 1.01471 L
.70355 1.00957 L
.70355 1.00444 L
.70355 .9993 L
.70355 .99416 L
.70355 .98902 L
.70355 .98388 L
.70355 .97875 L
.70355 .97361 L
.70355 .96847 L
.70355 .96333 L
.70355 .9582 L
.70355 .95306 L
.70355 .94792 L
.70355 .94278 L
.70355 .93764 L
.70355 .93251 L
.70355 .92737 L
.70355 .92223 L
.70355 .91709 L
.70355 .91196 L
.70355 .90682 L
.70356 .90168 L
.73319 .90168 L
.73319 1.10205 L
F
0 g
.70356 1.10205 m
.70355 1.09692 L
.70355 1.09178 L
.70355 1.08664 L
.70355 1.0815 L
.70355 1.07636 L
.70355 1.07123 L
.70355 1.06609 L
.70355 1.06095 L
.70355 1.05581 L
.70355 1.05068 L
.70355 1.04554 L
.70355 1.0404 L
.70355 1.03526 L
.70355 1.03012 L
.70355 1.02499 L
.70355 1.01985 L
.70355 1.01471 L
.70355 1.00957 L
.70355 1.00444 L
.70355 .9993 L
.70355 .99416 L
.70355 .98902 L
.70355 .98388 L
.70355 .97875 L
.70355 .97361 L
.70355 .96847 L
.70355 .96333 L
.70355 .9582 L
.70355 .95306 L
.70355 .94792 L
.70355 .94278 L
.70355 .93764 L
.70355 .93251 L
.70355 .92737 L
.70355 .92223 L
.70355 .91709 L
.70355 .91196 L
.70355 .90682 L
.70356 .90168 L
s
1 g
.28645 .78261 m
.30645 .78261 L
.30645 .80261 L
.28645 .80261 L
.28645 .78261 L
F
.28645 1.20112 m
.30645 1.20112 L
.30645 1.22112 L
.28645 1.22112 L
.28645 1.20112 L
F
.62986 .40227 m
.64986 .40227 L
.64986 .42227 L
.62986 .42227 L
.62986 .40227 L
F
.62986 1.58146 m
.64986 1.58146 L
.64986 1.60146 L
.62986 1.60146 L
.62986 1.58146 L
F
0 g
.003 w
.28645 .78261 m
.30645 .78261 L
.30645 .80261 L
.28645 .80261 L
.28645 .78261 L
s
.28645 1.20112 m
.30645 1.20112 L
.30645 1.22112 L
.28645 1.22112 L
.28645 1.20112 L
s
.62986 .40227 m
.64986 .40227 L
.64986 .42227 L
.62986 .42227 L
.62986 .40227 L
s
.62986 1.58146 m
.64986 1.58146 L
.64986 1.60146 L
.62986 1.60146 L
.62986 1.58146 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 2.00373 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.703547 0.23539 1.00187 0.23539 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 2.00373 .125 0 ]
[ 1 0 .125 0 ]
[.23277 .98937 -6 -9 ]
[.23277 .98937 6 0 ]
[.46816 .98937 -6 -9 ]
[.46816 .98937 6 0 ]
[.93894 .98937 -3 -9 ]
[.93894 .98937 3 0 ]
[.69105 .06031 -12 -4.5 ]
[.69105 .06031 0 4.5 ]
[.69105 .53109 -12 -4.5 ]
[.69105 .53109 0 4.5 ]
[.69105 1.47265 -6 -4.5 ]
[.69105 1.47265 0 4.5 ]
[.69105 1.94342 -6 -4.5 ]
[.69105 1.94342 0 4.5 ]
[ 0 0 0 0 ]
[ 1 2.00373 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 2.00373 L
s
0 2.00373 m
1 2.00373 L
s
1 0 m
1 2.00373 L
s
.23277 1.00187 m
.23277 1.00812 L
s
[(-2)] .23277 .98937 0 1 Mshowa
.46816 1.00187 m
.46816 1.00812 L
s
[(-1)] .46816 .98937 0 1 Mshowa
.93894 1.00187 m
.93894 1.00812 L
s
[(1)] .93894 .98937 0 1 Mshowa
.125 Mabswid
.04446 1.00187 m
.04446 1.00562 L
s
.09153 1.00187 m
.09153 1.00562 L
s
.13861 1.00187 m
.13861 1.00562 L
s
.18569 1.00187 m
.18569 1.00562 L
s
.27985 1.00187 m
.27985 1.00562 L
s
.32692 1.00187 m
.32692 1.00562 L
s
.374 1.00187 m
.374 1.00562 L
s
.42108 1.00187 m
.42108 1.00562 L
s
.51523 1.00187 m
.51523 1.00562 L
s
.56231 1.00187 m
.56231 1.00562 L
s
.60939 1.00187 m
.60939 1.00562 L
s
.65647 1.00187 m
.65647 1.00562 L
s
.75062 1.00187 m
.75062 1.00562 L
s
.7977 1.00187 m
.7977 1.00562 L
s
.84478 1.00187 m
.84478 1.00562 L
s
.89186 1.00187 m
.89186 1.00562 L
s
.98601 1.00187 m
.98601 1.00562 L
s
.25 Mabswid
0 1.00187 m
1 1.00187 L
s
.70355 .06031 m
.7098 .06031 L
s
[(-4)] .69105 .06031 1 0 Mshowa
.70355 .53109 m
.7098 .53109 L
s
[(-2)] .69105 .53109 1 0 Mshowa
.70355 1.47265 m
.7098 1.47265 L
s
[(2)] .69105 1.47265 1 0 Mshowa
.70355 1.94342 m
.7098 1.94342 L
s
[(4)] .69105 1.94342 1 0 Mshowa
.125 Mabswid
.70355 .178 m
.7073 .178 L
s
.70355 .2957 m
.7073 .2957 L
s
.70355 .41339 m
.7073 .41339 L
s
.70355 .64878 m
.7073 .64878 L
s
.70355 .76648 m
.7073 .76648 L
s
.70355 .88417 m
.7073 .88417 L
s
.70355 1.11956 m
.7073 1.11956 L
s
.70355 1.23726 m
.7073 1.23726 L
s
.70355 1.35495 m
.7073 1.35495 L
s
.70355 1.59034 m
.7073 1.59034 L
s
.70355 1.70804 m
.7073 1.70804 L
s
.70355 1.82573 m
.7073 1.82573 L
s
.25 Mabswid
.70355 0 m
.70355 2.00373 L
s
0 0 m
1 0 L
1 2.00373 L
0 2.00373 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[25]:=",
  ImageSize->{188.375, 377.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002l0001NA000`40n007h00O_?oo002lool0002k
001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/007__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001
ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`000;/008@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`0007h007__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnl30000>W__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@0Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`0007`007__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`D0000jNnn44000001k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0001f002447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1040000@G__Q100
08@@Nnl007__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q10008@@002447__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`0007h008@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1020000>g__Q11kk`00
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@007oo`000;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo
0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__007oo`000;/007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0002k002447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`000;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0002k001kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/007__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0002k
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`000;/008@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01
ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/007__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn44001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000P`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000P00
03Ikkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0002k0024
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`000;/008@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0
002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/007__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
4001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`000;/008@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0
07__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/0
07__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn44001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007o
o`000;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__007oo`000;/007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@007oo`000;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool00023001kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
40020000=W__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`00
0;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000L@00Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl02@00045kkh@@Nnn447__Q11kkh@@Nnl007__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`0006`007__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl50009ool50000?7__Q11kkh@@002447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0006X008@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn4408001?oo`80000jQ11kk`00Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0001X001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kk`8001Ooo`0j00244000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q101ool0001U002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`03000Jool20000=g__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`0006D007__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`0001koo`80000fNnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@0Ooo0000I000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`007ooo03P00?oo001kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo0000H`00Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0000Pool0
>000ooooo`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0001P
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@0P008Ooo03P00?ooooooo`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__0Ooo0000H000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10002?oo`03003ooooo00;oo`0c001kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`0005l008@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4400002Coo`03003ooooo
00;oo`0c002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`0005h007__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q10002Goo`03003ooooo00?oo`0b002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
407oo`0005d008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@00009_oo00<00?ooool00ooo038007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__0Ooo0000G000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@000Wool00`00ooooo`04ool0<@00Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@007oo`0005/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100000Xool00`00ooooo`04ool0<@00Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`0005X007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@000Yool00`00ooooo`05ool0<000Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0005T008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4400002[oo`03003ooooo00Goo`0`001kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo0000F000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn440007Ooo1@002Ooo00<00?ooool01_oo02l007__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`0005L008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@00007_oo00D00?ooooooo`0000Woo`03003ooooo00Koo`0_
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0001F001kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10001ooo`05003oooooool00009ool20007ool0
;`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000E@00Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000023oo`05003oooooool00009ool00`00oooo
o`06ool0;`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000E000Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100027oo`D000Woo`03003ooooo00Ooo`0^
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0001C002447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q100000`ool00`00ooooo`07ool0;P00Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__0Ooo0000DP00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn44000<Ooo00<00?ooool01ooo02h008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`00
054008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0000<_oo00<00?ooool01ooo
02h007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`00050007__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn44000<ooo00<00?ooool01ooo02h008@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn4407oo`0004l008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100000dool0
0`00ooooo`08ool0;@00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0001<001kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnl2000eool00`00ooooo`08ool0;@00Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn44001ool0001<002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__000gool00`00
ooooo`08ool0;@00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0001;001kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kk`0003Soo`03003ooooo00Soo`0]001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@007oo`0004X008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00>Ooo00<00?ooool02?oo02d0
08@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000A`00Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100
0P00>_oo00<00?ooool02?oo02d007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000A`00
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@0000??oo00<00?ooool02?oo02d008@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnl00Ooo0000A000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl2000mool00`00ooooo`08ool0;@00Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool00012002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0P00?ooo00<00?ooool02?oo
02d008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000@P00Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100047oo`03003o
oooo00Ooo`0^002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool00011002447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000012
ool00`00ooooo`07ool0;P00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo0000?@00Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@00<0
04?oo`03003ooooo00Ooo`0^002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000k0024
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`020016
ool00`00ooooo`07ool0;P00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo0000>@00Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn440020011ool40003
ool00`00ooooo`07ool0;P00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo0000>@00Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000013ool00`00oooo
o`04ool00`00ooooo`06ool0;`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000
=P00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`8004Goo`03003o
oooo00?oo`8000Ooo`0_001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0000d0024
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1020010ool40004ool00`00oooo
o`02ool00`00ooooo`06ool0;`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000
<P00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl20018ool01000ooooo`000ooo
00<00?ooool01Ooo030008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000b0024
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl004_oo`8000Coo`03003ooooo00Goo`0`
001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo0000;`00Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q1000P00D_oo00<00?ooool01Ooo030008@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q101ool0000]002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__008005Coo`03
003ooooo00Goo`0`001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo0000;000Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnl2001Eool00`00ooooo`05ool0<000Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn4407oo`0002X008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q102001Gool00`00
ooooo`04ool0<@00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`0002X007__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@001Iool00`00ooooo`04ool0<@00Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@007oo`0002T008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4400005[oo`03003ooooo00?o
o`0b001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0002H007__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__0P00Fooo00<00?ooool00ooo038008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@0Ooo00009`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100001Lool00`00ooooo`03ool0<P00Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000T001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0P00GOoo00<00?oo
ool00ooo038008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00009000Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnl005ooo`03003ooooo00;oo`0c002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__007oo`0002<007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kk`00063oo`03003ooooo00;oo`0c001kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`00028008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0067oo`03003ooooo00;oo`0c0024
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`0001l007__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44002001Rool00`00
ooooo`02ool0<`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0000O
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
0000I?oo03P00?ooooooo`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
0Ooo00007P00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q10006Goo`0h003oooooool008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn4407oo`0001d008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn4400006Koo`0h003oooooool007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`7oo`0001`007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q10006Ooo`0h003oooooool008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn4407oo`0001`008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnl006Ooo`0h003oooooool007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`7oo`0001/007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__0000J?oo0P0003Koo`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q101ool0000J002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnl006Woo`0h003ooooo002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
k`7oo`0001T007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0001Z
ool0>000ooooo`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0
000H002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Jooo03P00?oo
ool008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00005`00Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0000K?oo03P00?ooool007__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00005`00Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0000K?oo03P00?oo001kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00005P00Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn44000KOoo03P00?oo002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@0Ooo00005P00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`00KOoo03P00?oo001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__0Ooo00005@00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0001^ool0
>000ool008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000E
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4400006koo`80000fQ11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00005000Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@001_ool20000=W__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0001@008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`00Kooo0P0003J447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnl1ool0000C001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0000L?oo0P0003Ik
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000B002447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00LOoo0P0003J447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000B001kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn44000LOoo0P0003Ikkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q101ool0000A002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100001bool20000=X@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`00014007__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kk`0007;oo`80000fNnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@0Ooo00004@00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
0000L_oo0P0003J447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1
ool0000@001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@001cool20000=W__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`00010008@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnl007?oo`80000fQ11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__0Ooo00003`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0001dool20000=W__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000l008@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@0000M?oo0P0003J447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnl1ool0000?001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`0007Coo`80
000fNnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00003`00
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100001dool20000=X@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0000h007__Q11kkh@@Nnn447__Q11kkh@@Nnn44000
MOoo03P008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo
00003P00Q11kkh@@Nnn447__Q11kkh@@Nnn447__000Wool50019ool0>000Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000>001kkh@@Nnn447__Q11kkh@@
Nnn447__Q10002Ooo`05003oooooool00019ool0>000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000>002447__Q11kkh@@Nnn447__Q11kkh@@Nnl002Oo
o`05003oooooool00019ool0>000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnl1ool0000=001kkh@@Nnn447__Q11kkh@@Nnn447__0000:?oo00D00?ooooooo`00
04Woo`0h002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407o
o`0000d008@@Nnn447__Q11kkh@@Nnn447__Q100000Xool50019ool0>000Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000<001kkh@@Nnn447__Q11kkh@@
Nnn44000Mooo03P008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@0Ooo00003000Q11kkh@@Nnn447__Q11kkh@@Nnl007Ooo`0h001kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0000`007__Q11kkh@@Nnn447__Q11kkh@@
001gool0>000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101
ool0000<002447__Q11kkh@@Nnn447__Q11kk`00Mooo03P007__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00003000Nnn447__Q11kkh@@Nnn447__Q10007Oo
o`0h002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`00
00`008@@Nnn447__Q11kkh@@Nnn447__001gool0>000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000<001kkh@@Nnn447__Q11kkh@@Nnn44000Mooo03P0
08@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00003000
Q11kkh@@Nnn447__Q11kkh@@Nnl007Ooo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kk`7oo`0000/007__Q11kkh@@Nnn447__Q11kk`0007Soo`0h002447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000/008@@Nnn4
47__Q11kkh@@Nnn4400007Soo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kk`7oo`0000/007__Q11kkh@@Nnn447__Q11kk`0007Soo`0h002447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000/008@@Nnn447__Q11k
kh@@Nnn4400007Soo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`7oo`0000/007__Q11kkh@@Nnn447__Q11kk`0007Soo`0h002447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000X008@@Nnn447__Q11kkh@@Nnl0
07Woo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7o
o`0000X007__Q11kkh@@Nnn447__Q10007Woo`80000fNnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@0Ooo00002P00Q11kkh@@Nnn447__Q11kk`00NOoo03P007__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00002P00Nnn447__
Q11kkh@@Nnn44000NOoo03P008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@0Ooo00002P00Q11kkh@@Nnn447__Q11kk`00NOoo03P007__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00002P00Nnn447__Q11kkh@@Nnn44000
NOoo03P008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo
00002P00Q11kkh@@Nnn447__Q11kk`00NOoo03P007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__0Ooo00002P00Nnn447__Q11kkh@@Nnn44000NOoo03P008@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00002P00Q11kkh@@
Nnn447__Q11kk`00NOoo03P007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__0Ooo00002P00Nnn447__Q11kkh@@Nnn44000NOoo03P008@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00002P00Q11kkh@@Nnn447__Q11kk`00
NOoo03P007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo
00002P00Nnn447__Q11kkh@@Nnn44000NOoo03P008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@0Ooo00002P00Q11kkh@@Nnn447__Q11kk`00NOoo03P007__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00002P00Nnn447__
Q11kkh@@Nnn440008_oo1000:?oo1@009_oo02X008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10500002H@@
Nnn447__Q11kkh@@Nnn44001ool0000:002447__Q11kkh@@Nnn447__000Rool00`00ooooo`0[ool0
0`00ooooo`0Vool0>000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@Nnn447__Q11k
kh@@Nnl1ool0000:001kkh@@Nnn447__Q11kkh@@000Sool00`00ooooo`0Zool00`00ooooo`0Vool0
>000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@Nnn447__Q101ool0000:
002447__Q11kkh@@Nnn447__000Lool40004ool00`00ooooo`0Qool40004ool00`00ooooo`0Vool0
>000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000:
001kkh@@Nnn447__Q11kkh@@000Rool01000ooooo`00:_oo00<00?ooool09_oo03P008@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00002P00Q11kkh@@Nnn4
47__Q11kk`008ooo0P00:_oo0P00:?oo02/007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4400200002g__
Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo00002P00Nnn447__Q11kkh@@Nnn44000NOoo03P008@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00002P00Q11kkh@@
Nnn447__Q11kk`00NOoo03P007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__0Ooo00002P00Nnn447__Q11kkh@@Nnn44000NOoo03P008@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00002P00Q11kkh@@Nnn447__Q11kk`00
NOoo03P007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo
002k0001ool00008002447__Q11kkh@@Nnn4408000Ooo`03003ooooo00Koo`03003ooooo00Goo`03
003ooooo00Koo`03003ooooo00Koo`03003ooooo00Koo`03003ooooo00Koo`03003ooooo00Goo`03
003ooooo00Koo`03003ooooo00Koo`03003ooooo00Koo`03003ooooo00Koo`03003ooooo00Goo`03
003ooooo00Koo`0h001kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__001kkh@@Nnn447__
Q11kkh@@002447__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn44000
Q11kk`7oo`0000X007__Q11kkh@@Nnn447__Q10007Woo`0h002447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000X008@@Nnn447__Q11kkh@@Nnl007Woo`0h
001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0000X0
07__Q11kkh@@Nnn447__Q10007Woo`0h002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn4407oo`0000X008@@Nnn447__Q11kkh@@Nnl007Woo`0h001kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0000X007__Q11kkh@@Nnn4
47__Q10007Woo`0h002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn4407oo`0000X008@@Nnn447__Q11kkh@@Nnl007Woo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0000X007__Q11kkh@@Nnn447__Q10007Woo`0h
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000X0
08@@Nnn447__Q11kkh@@Nnl007Woo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kk`7oo`0000X007__Q11kkh@@Nnn447__Q10007Woo`0h002447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000X008@@Nnn447__Q11k
kh@@Nnl007Woo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kk`7oo`0000X007__Q11kkh@@Nnn447__Q10007Woo`0h002447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000X008@@Nnn447__Q11kkh@@Nnl007Woo`0h
001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0000X0
07__Q11kkh@@Nnn447__Q10007Woo`0h002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn4407oo`0000X008@@Nnn447__Q11kkh@@Nnl007Woo`0h001kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0000X007__Q11kkh@@Nnn4
47__Q10007Woo`0h002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn4407oo`0000X008@@Nnn447__Q11kkh@@Nnl007Woo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0000X007__Q11kkh@@Nnn447__Q10007Woo`0h
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000X0
08@@Nnn447__Q11kkh@@Nnl007Woo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kk`7oo`0000X007__Q11kkh@@Nnn447__Q10007Woo`0h002447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000X008@@Nnn447__Q11k
kh@@Nnl007Woo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kk`7oo`0000X007__Q11kkh@@Nnn447__Q10007Woo`80000fNnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00002P00Q11kkh@@Nnn447__Q11kk`00NOoo03P0
07__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00002P00
Nnn447__Q11kkh@@Nnn44000NOoo03P008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@0Ooo00002`00Q11kkh@@Nnn447__Q11kkh@@0000N?oo03P007__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00002`00Nnn447__Q11k
kh@@Nnn447__0000N?oo03P008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@0Ooo00002`00Q11kkh@@Nnn447__Q11kkh@@0000N?oo03P007__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00002`00Nnn447__Q11kkh@@Nnn4
47__0000N?oo03P008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@0Ooo00003000Q11kkh@@Nnn447__Q11kkh@@Nnl007Ooo`0h001kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0000`007__Q11kkh@@Nnn447__Q11kkh@@
001gool0>000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101
ool0000<002447__Q11kkh@@Nnn447__Q11kk`00Mooo03P007__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00003000Nnn447__Q11kkh@@Nnn447__Q10007Oo
o`0h002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`00
00`008@@Nnn447__Q11kkh@@Nnn447__001gool0>000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000<001kkh@@Nnn447__Q11kkh@@Nnn44000Mooo03P0
08@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00003000
Q11kkh@@Nnn447__Q11kkh@@Nnl007Ooo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kk`7oo`0000`007__Q11kkh@@Nnn447__Q11kkh@@001gool0>000Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000<002447__
Q11kkh@@Nnn447__Q11kk`00Mooo03P007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__0Ooo00003@00Nnn447__Q11kkh@@Nnn447__Q11kk`0002Soo`D004Woo`0h
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000d0
08@@Nnn447__Q11kkh@@Nnn447__Q100000Xool01@00oooooooo0000BOoo03P007__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00003P00Nnn447__Q11kkh@@
Nnn447__Q11kkh@@000Wool01@00oooooooo0000BOoo03P008@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00003P00Q11kkh@@Nnn447__Q11kkh@@Nnn447__
000Wool50019ool0>000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnl1ool0000>001kkh@@Nnn447__Q11kkh@@Nnn447__Q10007Goo`0h002447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000h008@@Nnn447__Q11kkh@@
Nnn447__Q11kk`00MOoo03P007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__0Ooo00003`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0001dool20000=W__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0000l008@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@0000M?oo0P0003J447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnl1ool0000?001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`0007Coo`80
000fNnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00004000
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Looo0P0003J447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000@001kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@001cool20000=W__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
407oo`00014008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4400007;oo`80000fQ11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00004@00Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__0000L_oo0P0003Ikkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q101ool0000A002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100001b
ool20000=X@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`00
014007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`0007;oo`80000fNnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00004P00Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnl0077oo`80000fQ11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__0Ooo00004P00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100077oo`80
000fNnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00004`00
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000073oo`80000fQ11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00005000Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@001_ool20000=W__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn4407oo`0001@008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
k`00Kooo0P0003J447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1
ool0000E001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`0006koo`0h003oo`00
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0001D008@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0000K_oo03P00?oo001kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0Ooo00005P00Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn44000KOoo03P00?oo002447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@0Ooo00005`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@0000K?oo03P00?oo001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__0Ooo00005`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__0000K?oo03P00?oo002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@0Ooo00006000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl006_o
o`0h003ooooo002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`00
01T007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0001Zool0>000
ooooo`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000J0024
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl006Woo`0h003ooooo
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0001/007__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0000J?oo0P0003Koo`00
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000L002447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001Wool0>000oooooooo
001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000L001kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@001Wool0>000oooooooo
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000M002447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100001Vool0>000oooo
oooo001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000N001kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000IOoo03P0
0?ooooooo`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo00007P00
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl006Go
o`0h003oooooool007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`00
01l007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnl0001Tool0>000oooooooo002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q101ool0000O002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnl00P00H_oo00<00?ooool00_oo03<008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnl00Ooo00008P00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000HOoo00<00?ooool00_oo03<007__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo00008`00Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0000H?oo00<00?ooool0
0_oo03<008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo00009000Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q10005ooo`03003ooooo00;oo`0c001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@007oo`0002@008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q102001Mool00`00ooooo`03ool0<P00Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000W001kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`0005coo`03003o
oooo00?oo`0b002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0002L008@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@0000G?oo00<00?ooool00ooo038007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__0Ooo00009`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44002001Jool00`00ooooo`03ool0<P00
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000Y002447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`02001Hool00`00ooooo`04ool0<@00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__007oo`0002/007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44002001Fool00`00ooooo`04ool0
<@00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`0002h008@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnl005Goo`03003ooooo00Goo`0`001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__0Ooo0000;`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0000E?oo00<0
0?ooool01Ooo030008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0000`002447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Dooo00<00?ooool01Ooo030007__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0000`001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__0`00BOoo10000ooo00<00?ooool01Ooo030008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q101ool0000c002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__0080
04Ooo`03003ooooo00Coo`03003ooooo00Goo`0`001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__0Ooo0000=P00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100
04Ooo`03003ooooo00?oo`8000Ooo`0_001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001
ool0000g002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0000Aooo
00<00?ooool00_oo00<00?ooool01_oo02l008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
007oo`0003L007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44003
0012ool01000ooooo`000ooo00<00?ooool01_oo02l007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@007oo`0003X008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn44080047oo`8000Coo`03003ooooo00Ooo`0^001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnl1ool0000m001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__0000A_oo00<00?ooool01ooo02h008@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn4407oo`0003d008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kk`020014ool00`00ooooo`07ool0;P00Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__0Ooo0000?`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn440020012ool00`00ooooo`07ool0;P00Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@0Ooo0000@@00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00P00@?oo00<00?ooool01ooo02h007__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0004@007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000?ooo00<00?ooool0
2?oo02d007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000A@00Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100
000nool00`00ooooo`08ool0;@00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool00015001k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@00<003_oo`03003ooooo00Soo`0]001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@007oo`0004T008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100000jool00`00ooooo`08ool0;@00
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0001:001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q10003Woo`03003ooooo00Soo`0]001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`0004/0
08@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0000>?oo00<00?ooool02?oo02d008@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnl00Ooo0000B`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44002000f
ool00`00ooooo`08ool0;@00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0001>002447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00=Ooo00<00?ooool02?oo02d008@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnl00Ooo0000C`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
k`0003Coo`03003ooooo00Soo`0]001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`000500
08@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00<ooo00<00?ooool01ooo02h007__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`00054007__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__0000<_oo00<00?ooool01ooo02h008@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn4407oo`00058008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0037o
o`03003ooooo00Ooo`0^001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0001B001kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl2000_ool00`00ooooo`07ool0;P00
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo0000E@00Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn44000023oo`D000Woo`03003ooooo00Ooo`0^001kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0001E001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__00008?oo00D00?ooooooo`0000Woo`8000Ooo`0_001kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0001F002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnl001ooo`05003oooooool00009ool00`00ooooo`06ool0;`00Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000E`00Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0000Nool01@00oooooooo00002Ooo00<00?ooool0
1_oo02l007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`0005P008@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl001goo`D000Woo`03003ooooo
00Koo`0_002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0001H001kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl2000Yool00`00ooooo`05
ool0<000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`0005/008@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100000Xool00`00oooo
o`05ool0<000Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0005/007__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0000Xool00`00
ooooo`04ool0<@00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`0005`008@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00
9ooo00<00?ooool01?oo034008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0
001M001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`0002Koo`03003ooooo00?oo`0b002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn4407oo`0005h008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnl002Goo`03003ooooo00?oo`0b001kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kk`7oo`0005l007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`0002Coo`03003ooooo00;oo`0c001kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`0005l008@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__008002;o
o`0h003oooooool007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`00
068007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn440008Ooo03P00?ooooooo`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@0Ooo0000H`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100000Pool0>000ool00000Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0001T001kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@000Oool20000=W__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
407oo`0006@008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4408001goo`0h001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`7oo`0006H007__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl3
000Iool20000=h@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
007oo`0006X008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl001Goo`<0000iNnl007__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`0006X007__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kk`@000ooo`80000lNnn447__Q10008@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo0000KP00Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q1050005ool50000?X@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl1ool0001c001kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1001@0004>447__Q11kkh@@Nnn447__Q11kkh@@
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0002k
002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnl00Ooo0000P`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000P0003Ikkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q101ool0002k002447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0
0Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@007oo`000;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0002k001kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/007__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0024
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0002k0024
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`000;/008@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0
002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/007__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
4001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`000;/008@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl0
07__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/0
07__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn44001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007o
o`000;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kk`01ool00023001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn440020000=W__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4407oo`000;/008@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl007__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/007__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn44001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`00
0;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
007oo`000;/007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@007oo`000;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000^`00
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__007oo`000;/007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0002k002447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo
0000^`00Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q10008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@007oo`000;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0001n001kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
0`0003Ykkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
47__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn4
407oo`000;/008@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kk`01ool0001l001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@
Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl50000>W__Q1000000Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0Ooo0000^`00Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@002447__
001kkh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
007oo`000;/007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@00244000Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn44001ool0001n002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__
Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@0P0003]kkh@@Nnl007__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007oo`000;/007__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn44001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo0000^`00Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q100
08@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@007oo`000;/0
08@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kk`01ool0002k001kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn44000Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q1000Ooo0000^`00Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnl007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__007o
o`000;/007__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn44001ool0002k002447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kk`00Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11k
kh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnn447__Q11kkh@@Nnl00Ooo002k0001ool00001\
\>"],
  ImageRangeCache->{{{0, 234.188}, {470.5, 0}} -> {-5.00005*^-6, -0.00132156, \
0.00533694, 0.0026635}, {{0, 234.188}, {469.875, 0.5}} -> {-2.99172, \
-4.27387, 0.0227031, 0.0227031}}]
}, Open  ]],

Cell[TextData[{
  "You can see from the plot that the linear stability boundary is at about \
-2.8.  You could use this value, but for higher precision solutions, it is \
good to have an exact value, if possible.   ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s symbolic capabilities make this quite feasible."
}], "Text"],

Cell["\<\
This computes the factor exactly using the symbolic command Reduce. \
 \
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[{poly\  \[Equal] 1, \ z\  < \ 0}, z]\)], "Input",
  CellLabel->"In[26]:="],

Cell[BoxData[
    \(z \[Equal] Root[24 + 12\ #1 + 4\ #1\^2 + #1\^3 &, 1]\)], "Output",
  CellLabel->"Out[26]="]
}, Open  ]],

Cell[TextData[{
  "This sets the ",
  StyleBox["\"LinearStabilityBoundary\"", "MR"],
  " property"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CRK4[___]\)["\<LinearStabilityBoundary\>"[]]\  = \ 
      Root[24 + 12\ #1 + 4\ #1\^2 + #1\^3 &, 1]\)], "Input",
  CellLabel->"In[27]:="],

Cell[BoxData[
    \(Root[24 + 12\ #1 + 4\ #1\^2 + #1\^3 &, 1]\)], "Output",
  CellLabel->"Out[27]="]
}, Open  ]],

Cell["\<\
Now it is possible to compute the solution without the stiffness \
test disabled.  The solution is the same as the one computed above because \
this equation is not stiff.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dstep\  = \ 
      NDSolve[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 0, \ 
          x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, 
        x, {t, 0, 2\ \[Pi]}, \ 
        Method \[Rule] {DoubleStep, \ Method \[Rule] CRK4}]\)], "Input",
  CellLabel->"In[28]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 6.283185307179586`}}, "<>"]\),
            
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[28]="]
}, Open  ]],

Cell[TextData[{
  "For more sophisticated methods, it may be necessary or more efficient to \
set up some data for the method to use. When ",
  StyleBox["NDSolve", "MR"],
  " uses a particular numerical algorithm for the first time, it calls an \
initialization function. You can define rules for the initialization that \
will set up appropriate data for your method. "
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["InitializeMethod",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[\(Algorithm\ Identifier\),
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["stepmode",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["state",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox[\(Algorithm\ Options\),
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "The expression that ",
              StyleBox["NDSolve", "MR"],
              
              " evaluates for initialization when it first uses an algorithm \
for a particular integration. ",
              StyleBox["stepmode", "TI"],
              " is either ",
              StyleBox["Automatic", "MR"],
              " or ",
              StyleBox["Fixed", "MR"],
              
              " depending on whether your method is expected to called within \
the framework of a step controller or another method or not. ",
              StyleBox["state", "TI"],
              " is the ",
              StyleBox["NDSolveState", "MR"],
              " object used by ",
              StyleBox["NDSolve", "MR"],
              ". ",
              StyleBox["Algorithm Options", "TI"],
              
              " is a list that contains any options given specifically with \
the specification to use the particular algorithm, for example, ",
              StyleBox["{", "MR"],
              StyleBox["opts", "TI"],
              StyleBox["}", "MR"],
              " in ",
              StyleBox["Method", "MR"],
              "\[Rule]",
              StyleBox["{", "MR"],
              StyleBox["Algorithm Identifier", "TI"],
              StyleBox[", ", "MR"],
              StyleBox["opts", "TI"],
              StyleBox["}", "MR"],
              "."
            }], "Text"]},
          {
            RowBox[{
              StyleBox[\(Algorithm\ Identifier\),
                "TI"], 
              StyleBox[" ",
                "TI"], 
              StyleBox["/:",
                "MR"], 
              StyleBox[" ",
                "TI"], 
              RowBox[{
                StyleBox["InitializeMethod",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox[\(Algorithm\ Identifier\),
                    "TI"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox[" ",
                    "MR"], 
                  StyleBox["\n",
                    "MR"], 
                  StyleBox["stepmode_",
                    "MR"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox[" ",
                    "MR"], 
                  StyleBox["rhs_NumericalFunction",
                    "MR"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox[" ",
                    "MR"], 
                  StyleBox["state_NDSolveState",
                    "MR"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox[" ",
                    "MR"], 
                  StyleBox[\({opts___?OptionQ}\),
                    "MR"]}], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox[" ",
                "MR"], 
              StyleBox[":=",
                "MR"], 
              StyleBox[" ",
                "MR"], 
              StyleBox["initialization",
                "TI"]}], Cell[TextData[{
              
              "Definition of the initialization so that the rule is \
associated with the algorithm. ",
              StyleBox["initialization", "TI"],
              " should return an algorithm object in the form ",
              StyleBox["Algorithm Identifier", "TI"],
              StyleBox["[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              "."
            }], "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell["Initializing a method from NDSolve.", "Caption"],

Cell[TextData[{
  "As a system symbol, ",
  StyleBox["InitializeMethod", "MR"],
  " is protected, so to attach rules to it, you would need to unprotect it \
first. It is better to keep the rules associated with your method. A tidy way \
to do this is to make the initialization definition using",
  " ",
  ButtonBox["TagSet",
    ButtonStyle->"RefGuideLink"],
  " as shown above."
}], "Text"],

Cell["\<\
As an example, suppose we want to redefine the Runge-Kutta method \
shown above so that instead of using the exact coefficients 2, 1/2, and 1/6, \
numerical values with the appropriate precision are used instead to make the \
computation slightly faster.\
\>", "Text"],

Cell["\<\
This defines a method function to take a single step towards \
integrating an ODE using the classical fourth-order RungeKutta method using \
saved numerical values for the required coefficients. \
\>", "MathCaption"],

Cell[BoxData[
    \(\(CRK4[{two_, \ half_, \ sixth_}]\)["\<Step\>"[rhs_, \ t_, \ h_, \ 
          y_, \ yp_]]\  := 
      Module[{k0, k1, k2, k3}, \[IndentingNewLine]k0 = 
          h\ yp; \[IndentingNewLine]k1 = 
          h\ rhs[t + half\ h, y + half\ k0]; \[IndentingNewLine]k2 = 
          h\ rhs[t + half\ h, y + half\ k1]; \[IndentingNewLine]k3 = 
          h\ rhs[t + h, y + k2]; \[IndentingNewLine]{h, \ 
          sixth\ \((k0 + two\ \((k1 + k2)\) + k3)\)}]\)], "Input",
  CellLabel->"In[13]:="],

Cell["\<\
This defines a rule that initializes the algorithm object with the data to be \
used later.\
\>", "MathCaption"],

Cell[BoxData[
    \(CRK4\  /: \ 
      NDSolve`InitializeMethod[CRK4, \ stepmode_, \ rhs_, \ state_, \ 
        opts___]\  := \ 
      Module[{prec}, \[IndentingNewLine]prec\  = \ 
          state@"\<WorkingPrecision\>"[]; \[IndentingNewLine]CRK4[
          N[{2, \ 1/2, \ 1/6}, \ prec]]]\)], "Input",
  CellLabel->"In[11]:="],

Cell[TextData[{
  "Saving the numerical values of the numbers gives between 5 and 10 percent \
speedup for a longer integration using ",
  StyleBox["DoubleStep", "MR"],
  ". "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Adams methods", "Section",
  CellTags->"s:4"],

Cell[TextData[{
  "In terms of the ",
  StyleBox["NDSolve", "MR"],
  " framework, it is not really any more difficult to write an algorithm that \
controls steps automatically. However, the requirements for estimating error \
and determining an appropriate step size usually make this much more \
difficult from both the mathematical and programming standpoints. The \
following example is a partial adaptation of the FORTRAN DEABM code of \
Shampine and Watts to fit into the ",
  StyleBox["NDSolve", "MR"],
  " framework. The algorithm adaptively chooses both step size and order \
based on criteria described in [",
  ButtonBox["SG75",
    ButtonData:>{"References.nb", "SG75"},
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "The first stage is to define the coefficients. The integration method uses \
variable step-size coefficients. Given a sequence of step sizes ",
  Cell[BoxData[
      \(TraditionalForm\`{h\_\(n - k + 1\), \ h\_\(n - k + 2\), \  ... , \ 
        h\_n}\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`h\_n\)]],
  "is the current step to take, the coefficients for the method with \
Adams-Bashforth predictor of order ",
  StyleBox["k",
    FontSlant->"Italic"],
  " and Adams-Moulton corrector of order ",
  StyleBox["k",
    FontSlant->"Italic"],
  " + 1, ",
  Cell[BoxData[
      \(TraditionalForm\`\(g\_j\)(n)\)]],
  "such that"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y\_\(n + 1\) = 
      p\_\(n + 1\) + 
        h\_n\ \(\(g\_k\)(n)\)\ \(\(\[CapitalPhi]\_k\)(
            n + 1)\)\)], "DisplayMath"],

Cell[BoxData[
    \(TraditionalForm\`p\_\(n + 1\) = 
      y\_n + h\_n\ \(\[Sum]\+\(j = 0\)\%\(k - 1\)\(\(g\_j\)(
                n)\)\ \(\[CapitalPhi]\_k\%*\)\[InvisibleApplication] \
\((n)\)\)\)], "DisplayMath"],

Cell[TextData[{
  "where the ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_j\)(n)\)]],
  "are the divided differences."
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\[CapitalPhi]\_j\)(
        n) == \[Product]\+\(i = 0\)\%\(j - 1\)\((t\_n - 
              t\_\(n - i\))\)\ \[Delta]\^k\ f[t\_n, \[Ellipsis], 
            t\_\(n - j\)]\)], "DisplayMath",
  CellLabel->"In[19]:="],

Cell[BoxData[
    \(TraditionalForm\`\(\((\[CapitalPhi]\_j)\)\^*\)\[InvisibleApplication] \
\((n)\) = \(\(\(\[Beta]\_j\)(n)\)\ \(\(\[CapitalPhi]\_j\)(
            n)\)\ \ \ \ \ \ \ \ with\ \ \ \ \ \ \(\(\[Beta]\_j\)(
            n)\) = \[Product]\+\(i = 0\)\%\(j - 1\)\(t\_\(n + 1\) - t\_\(n - \
i\)\)\/\(t\_n - t\_\(\(-i\) + n - 1\)\)\)\)], "DisplayMath"],

Cell[TextData[{
  "This defines a function that computes the coefficients ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi]\_j\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta]\_j\)]],
  ", along with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_j\)]],
  " that are used in error estimation. The formulas are from [",
  ButtonBox["HNW93",
    ButtonData:>{"References.nb", "HNW93"},
    ButtonStyle->"Hyperlink"],
  "] and use essentially the same notation."
}], "MathCaption"],

Cell[BoxData[
    \(AdamsBMCoefficients[hlist_List] := 
      Module[{k, h, \[CapitalDelta]h, brat, \[Beta], \[Alpha], \[Sigma], 
          c}, \[IndentingNewLine]k = Length[hlist]; \[IndentingNewLine]h = 
          Last[hlist]; \[IndentingNewLine]\[CapitalDelta]h = 
          Drop[FoldList[Plus, 0, Reverse[hlist]], 
            1]; \[IndentingNewLine]brat = 
          Drop[\[CapitalDelta]h, \(-1\)]\/\(Drop[\[CapitalDelta]h, 1] - h\); \
\[IndentingNewLine]\[Beta] = 
          FoldList[Times, 1, brat]; \[IndentingNewLine]\[Alpha] = 
          h\/\[CapitalDelta]h; \[IndentingNewLine]\[Sigma] = 
          FoldList[Times, 
            1, \[Alpha]\ Range[Length[\[Alpha]]]]; \[IndentingNewLine]c[0] = 
          Table[1\/q, {q, 1, k}]; \[IndentingNewLine]c[1] = 
          Table[1\/\(q\ \((q + 1)\)\), {q, 1, k}]; 
        Do[c[j] = 
            Drop[c[j - 
                    1], \(-1\)] - \(Drop[c[j - 1], 1]\ h\)\/\[CapitalDelta]h\
\[LeftDoubleBracket]j\[RightDoubleBracket], {j, 2, 
            k}]; {\((First[c[#1]] &)\) /@ 
            Range[0, k], \[Beta], \[Sigma]}]\)], "Input",
  CellLabel->"In[16]:="],

Cell[TextData[{
  StyleBox["hlist", "MR"],
  " is the list of step sizes ",
  Cell[BoxData[
      \(TraditionalForm\`{h\_\(n - k\), \ \(h\_\(\(n - k + 
                1\)\(,\)\)\) \[Ellipsis], \ h\_n}\)]],
  "from past steps. The constant-coefficient Adams coefficients can be \
computed once, and much more easily. Since the constant step size \
Adams-Moulton coefficients are used in error prediction for changing the \
method order, it makes sense to define them once with rules that save the \
values."
}], "Text"],

Cell["\<\
This defines a function that computes and saves the values of the \
constant step size Adams-Moulton coefficients.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(Moulton[0] = 1;\)\), "\n", 
    \(Moulton[
        m_] := \(Moulton[
          m] = \(-Sum[
            Moulton[k]/\((1 + m - k)\), {k, 0, m - 1}]\)\)\)}], "Input",
  CellLabel->"In[17]:="],

Cell[TextData[{
  "The next stage is to set up a data structure that will keep the necessary \
information between steps and define how that data should be initialized. The \
key information that needs to be saved is the list of past step sizes, ",
  StyleBox["hlist", "MR"],
  ", and the divided differences, \[CapitalPhi]. Since the method does the \
error estimation, it needs to get the correct norm to use from the ",
  StyleBox["NDSolveStateData", "MR"],
  " object. Some other data such as precision is saved for optimization and \
convenience. "
}], "Text"],

Cell[TextData[{
  "This defines a rule for initializing the ",
  StyleBox["AdamsBM", "MR"],
  " method from ",
  StyleBox["NDSolve", "MR"],
  "."
}], "MathCaption"],

Cell[BoxData[
    \(\(AdamsBM /: \[IndentingNewLine]NDSolve`InitializeMethod[AdamsBM, 
          Automatic, rhs_, ndstate_, opts___] := 
        Module[{prec, norm, hlist, \[CapitalPhi], mord}, 
          mord = MaxDifferenceOrder /. \[InvisibleSpace]Flatten[{opts, 
                  Options[AdamsBM]}]; \[IndentingNewLine]If[
            mord\  \[NotEqual] \ \[Infinity]\  && \ \(! \((IntegerQ[
                      mord]\  && \ mord\  > \ 0)\)\), 
            Return[$Failed]]; \[IndentingNewLine]prec = 
            ndstate["\<WorkingPrecision\>"[]]; \[IndentingNewLine]norm = 
            ndstate["\<Norm\>"[]]; \[IndentingNewLine]hlist = {}; \
\[IndentingNewLine]\[CapitalPhi] = \
{ndstate["\<SolutionDerivativeVector\>"["\<Active\>"]]}; 
          AdamsBM[{{hlist, \[CapitalPhi], 
                N[0, prec]\ \[CapitalPhi]\[LeftDoubleBracket]1\
\[RightDoubleBracket]}, {norm, prec, mord, 0, True}}]];\)\)], "Input",
  CellLabel->"In[19]:="],

Cell[TextData[{
  StyleBox["hlist", "MR"],
  " is initialized to {} since at initialization time there have been no \
steps. \[CapitalPhi] is initialized to the derivative of the solution vector \
at the initial condition since the ",
  Cell[BoxData[
      \(TraditionalForm\`0\^th\)]],
  "divided difference is just the function value. Note that \[CapitalPhi] is \
a matrix. The third element, which is initialized to a zero vector, is used \
for determining the best order for the next step. It is effectively an \
additional divided difference. The use of the other parts of the data is \
clarified in the definition of the stepping function."
}], "Text"],

Cell[TextData[{
  "The initialization is also set up to get the value of an option that can \
be used to limit the maximum order of the method to use. In the code DEABM, \
this is limited to 12, because this is a practical limit for \
machine-precision calculations. However, in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", computations can be done in higher precision where higher-order methods \
may be of significant advantage, so there is no good reason for an absolute \
limit of this sort. Thus, we set the default of the option to be \
\[Infinity]."
}], "Text"],

Cell[TextData[{
  "This sets the default for the ",
  StyleBox["MaxDifferenceOrder", "MR"],
  " option of the ",
  StyleBox["AdamsBM", "MR"],
  " method."
}], "MathCaption"],

Cell[BoxData[
    \(\(Options[
          AdamsBM]\  = \ {MaxDifferenceOrder \[Rule] \[Infinity]};\)\)], \
"Input",
  CellLabel->"In[20]:="],

Cell[TextData[{
  "Before proceeding to the more complicated ",
  StyleBox["Step", "MR"],
  " method functions, it makes sense to define the simple ",
  StyleBox["Stepmode", "MR"],
  " and ",
  StyleBox["DifferenceOrder", "MR"],
  " method functions."
}], "Text"],

Cell[TextData[{
  "This defines the step mode for the ",
  StyleBox["AdamsBM", "MR"],
  " method to always be ",
  StyleBox["Automatic", "MR"],
  ". This means that it cannot be called from step controller methods that \
request fixed step sizes of possibly varying sizes. "
}], "MathCaption"],

Cell[BoxData[
    \(\(\(AdamsBM[___]\)["\<Stepmode\>"[]] = Automatic;\)\)], "Input",
  CellLabel->"In[21]:="],

Cell[TextData[{
  "This defines the difference order for the ",
  StyleBox["AdamsBM", "MR"],
  " method.",
  " ",
  "This varies with the number of past values saved."
}], "MathCaption"],

Cell[BoxData[
    \(\(\(AdamsBM[data_]\)["\<DifferenceOrder\>"[]] := 
        Length[data[\([1, 2]\)]];\)\)], "Input",
  CellLabel->"In[22]:="],

Cell["\<\
Finally, the definition of the Step function. The actual process of \
taking a step is only a few lines. The rest of the code handles the automatic \
step size and order selection following very closely the DEABM code of \
Shampine and Watts.\
\>", "Text"],

Cell[TextData[{
  "This defines the ",
  StyleBox["Step", "MR"],
  " method function for ",
  StyleBox["AdamsBM", "MR"],
  " that returns step data according to the templates described above. "
}], "MathCaption"],

Cell[BoxData[
    \(\(\(AdamsBM[data_]\)["\<Step\>"[rhs_, t_, h_, y_, yp_]] := 
        Module[{prec, norm, hlist, \[CapitalPhi], \[CapitalPhi]1, ns, 
            starting, k, zero, g, \[Beta], \[Sigma], p, f, \[CapitalDelta]y, 
            normh, ev, err, PE, knew, hnew, 
            temp}, {{hlist, \[CapitalPhi], \[CapitalPhi]1}, {norm, prec, 
                mord, ns, starting}} = data; \[IndentingNewLine] (*\ 
            Norm\ scaling\ will\ be\ based\ on\ current\ solution\ \(\(y\)\(.\
\)\)\ *) normh = \((Abs[h]\ temp[#1, 
                      y] &)\) /. \[InvisibleSpace]{temp \[Rule] 
                  norm}; \[IndentingNewLine]k = 
            Length[\[CapitalPhi]]; \[IndentingNewLine]zero = 
            N[0, prec]; \[IndentingNewLine] (*\ 
            Keep\ track\ of\ number\ of\ steps\ at\ this\ stepsize\ \
\(\(h\)\(.\)\)\ *) \[IndentingNewLine]If[
            Length[hlist] > 0 && Last[hlist] == h, \(ns++\), ns = 1]; 
          hlist = Join[
              hlist, {h}]; \[IndentingNewLine]{g, \[Beta], \[Sigma]} = 
            AdamsBMCoefficients[hlist]; \[IndentingNewLine] (*\ 
            Convert\ \[CapitalPhi]\ to\ \(\[CapitalPhi]\^*\)\ \
*) \[IndentingNewLine]\[CapitalPhi] = \[CapitalPhi]\ Reverse[\[Beta]]; \
\[IndentingNewLine] (*\ 
            PE : \ Predict\ and\ evaluate\ *) \[IndentingNewLine]p = 
            Reverse[Drop[g, \(-1\)]] . \[CapitalPhi]; \[IndentingNewLine]f = 
            rhs[h + t, h\ p + y]; \[IndentingNewLine] (*\ 
            Update\ divided\ differences\ *) \[IndentingNewLine]\[CapitalPhi] \
= FoldList[Plus, 
              zero\ \[CapitalPhi]1, \[CapitalPhi]]; \[IndentingNewLine] (*\ 
            Compute\ scaled\ error\ estimate\ *) \[IndentingNewLine]ev = 
            f - Last[\[CapitalPhi]]; \[IndentingNewLine]err = \((g\
\[LeftDoubleBracket]\(-2\)\[RightDoubleBracket] - 
                  g\[LeftDoubleBracket]\(-1\)\[RightDoubleBracket])\)\ normh[
                ev]; \[IndentingNewLine] (*\ 
            First\ order\ \(check : \ 
                determines\ if\ order\ should\ be\ lowered\[IndentingNewLine]
              
              even\ in\ the\ case\ of\ a\ rejected\ step\)\ \
*) \[IndentingNewLine]knew = 
            OrderCheck[PE, k, \[CapitalPhi], ev, 
              normh, \[Sigma]]; \[IndentingNewLine]If[
            err > 1, \[IndentingNewLine] (*\ 
              Rejected\ \(step : \ reduce\ h\ by\ half\), \ 
              make\ sure\ starting\ mode\ flag\ is\ unset\ and\ reset\ \
\[CapitalPhi]\ to\ previous\ values\ *) \[IndentingNewLine]hnew = 
              h\/2; \[CapitalDelta]y = $Failed; f = None; 
            starting = False; \[CapitalPhi] = 
              data\[LeftDoubleBracket]1, 
                2\[RightDoubleBracket], \[IndentingNewLine] (*\ 
              Sucessful\ \(step : \[IndentingNewLine]\(CE : \ 
                    Correct\ and\ evaluate\)\)\ *) \[IndentingNewLine]\
\[CapitalDelta]y = h\ \((p + ev\ Last[g])\); \[IndentingNewLine]f = 
              rhs[h + t, y + \[CapitalDelta]y]; 
            temp = f - Last[\[CapitalPhi]]; \[IndentingNewLine] (*\ 
              Update\ the\ divided\ differences\ *) \[IndentingNewLine]\
\[CapitalPhi] = \((temp + #1 &)\) /@ \[CapitalPhi]; \[IndentingNewLine] (*\ 
              Determine\ best\ order\ and\ stepsize\ for\ the\ next\ step\ \
*) \[IndentingNewLine]\[CapitalPhi]1 = temp - \[CapitalPhi]1; 
            knew = ChooseNextOrder[starting, PE, k, knew, \[CapitalPhi]1, 
                normh, \[Sigma], mord, ns]; 
            hnew = ChooseNextStep[PE, knew, h]]; \[IndentingNewLine] (*\ 
            Truncate\ hlist\ and\ \[CapitalPhi]\ to\ the\ appropriate\ length\
\ for\ the\ chosen\ \(\(order\)\(.\)\)\ *) \[IndentingNewLine]hlist = 
            Take[hlist, 1 - knew]; \[IndentingNewLine]If[
            Length[\[CapitalPhi]] > 
              knew, \[CapitalPhi]1 = \[CapitalPhi]\[LeftDoubleBracket]Length[\
\[CapitalPhi]] - knew\[RightDoubleBracket]; \[CapitalPhi] = 
              Take[\[CapitalPhi], \(-knew\)];]; \[IndentingNewLine] (*\ 
            Return\ step\ data\ along\ with\ updated\ method\ data\ \
*) \[IndentingNewLine]{hnew, \[CapitalDelta]y, f, 
            AdamsBM[{{hlist, \[CapitalPhi], \[CapitalPhi]1}, {norm, prec, 
                  mord, ns, starting}}]}];\)\)], "Input",
  CellLabel->"In[23]:="],

Cell[TextData[{
  "There are a few deviations from DEABM in the code here. The most \
significant is that coefficients are recomputed at each step, whereas DEABM \
computes only those that need updating. This modification was made to keep \
the code simpler, but does incur a clear performance loss, particularly for \
small to moderately sized systems. A second significant modification is that \
much of the code for limiting rejected steps is left to ",
  StyleBox["NDSolve", "MR"],
  ", so there are no checks in this code to see if the step size is too small \
or the tolerances are too large. The stiffness detection heuristic has also \
been left out. The order and step size determination code has been \
modularized into separate functions."
}], "Text"],

Cell[TextData[{
  "This defines a function that constructs error estimates ",
  Cell[BoxData[
      \(TraditionalForm\`PE\_j\)]],
  " for ",
  StyleBox["j",
    FontSlant->"Italic"],
  " == ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-2, ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-1, and ",
  StyleBox["k",
    FontSlant->"Italic"],
  " and determines if the order should be lowered or not."
}], "MathCaption"],

Cell[BoxData[
    \(\(OrderCheck[PE_, k_, \[CapitalPhi]_, ev_, normh_, \[Sigma]_] := 
        Module[{knew = k}, \[IndentingNewLine]PE\_k = 
            Abs[\[Sigma]\[LeftDoubleBracket]
                  k + 1\[RightDoubleBracket]\ Moulton[k]\ normh[ev]]; 
          If[k > 1, \[IndentingNewLine]PE\_\(k - 1\) = 
              Abs[\[Sigma]\[LeftDoubleBracket]k\[RightDoubleBracket]\ Moulton[
                    k - 1]\ normh[
                    ev + \[CapitalPhi]\[LeftDoubleBracket]2\
\[RightDoubleBracket]]]; \[IndentingNewLine]If[
              k > 2, \[IndentingNewLine]PE\_\(k - 2\) = 
                Abs[\[Sigma]\[LeftDoubleBracket]
                      k - 1\[RightDoubleBracket]\ Moulton[k - 2]\ normh[
                      ev + \[CapitalPhi]\[LeftDoubleBracket]3\
\[RightDoubleBracket]]]; 
              If[Max[PE\_\(k - 1\), PE\_\(k - 2\)] < PE\_k, 
                knew = k - 1]], \[IndentingNewLine]\(If[
                PE\_\(k - 1\) < PE\_k\/2, 
                knew = k - 
                    1];\)\[IndentingNewLine]]; \[IndentingNewLine]knew\
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[24]:="],

Cell["\<\
This defines a function that determines the best order to use after \
a successful step.\
\>", "MathCaption"],

Cell[BoxData[{
    \(\(SetAttributes[ChooseNextOrder, HoldFirst];\)\), "\n", 
    \(\(ChooseNextOrder[starting_, PE_, k_, knw_, \[CapitalPhi]1_, 
          normh_, \[Sigma]_, mord_, ns_] := 
        Module[{knew = knw}, \[IndentingNewLine]starting = 
            starting && knew \[GreaterEqual] k && 
              k < mord; \[IndentingNewLine]If[
            starting, \[IndentingNewLine]knew = k + 1; 
            PE\_\(k + 1\) = 
              0, \[IndentingNewLine]\(If[
                knew \[GreaterEqual] k && 
                  ns \[GreaterEqual] 
                    k + 1, \[IndentingNewLine]PE\_\(k + 1\) = 
                  Abs[Moulton[
                        k + 1]\ normh[\[CapitalPhi]1]]; \[IndentingNewLine]If[
                  k > 1, \[IndentingNewLine]If[
                    PE\_\(k - 1\) \[LessEqual] 
                      Min[PE\_k, PE\_\(k + 1\)], \[IndentingNewLine]knew = 
                      k - 1, \[IndentingNewLine]If[
                      PE\_\(k + 1\) < PE\_k && k < mord, 
                      knew = k + 
                          1]\[IndentingNewLine]], \[IndentingNewLine]If[
                    PE\_\(k + 1\) < PE\_k\/2, 
                    knew = k + 
                        1]\[IndentingNewLine]];\[IndentingNewLine]];\)\
\[IndentingNewLine]]; \[IndentingNewLine]knew\[IndentingNewLine]];\)\)}], \
"Input",
  CellLabel->"In[25]:="],

Cell[TextData[{
  "This defines a function that determines the best step size to use after a \
successful step of size ",
  StyleBox["h",
    FontSlant->"Italic"],
  ". "
}], "MathCaption"],

Cell[BoxData[
    \(\(ChooseNextStep[PE_, k_, h_] := \[IndentingNewLine]If[
          PE\_k < 2\^\(-\((k + 2)\)\), \[IndentingNewLine]2\ h, \
\[IndentingNewLine]If[PE\_k < 1\/2, h, 
            h\ Max[1\/2, 
                Min[9\/10, \((1\/\(2\ PE\_k\))\)\^\(1\/\(k + 1\)\)]]]\
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[27]:="],

Cell[TextData[{
  "Once these definitions are entered, you can access the method in ",
  StyleBox["NDSolve", "MR"],
  " by simply using ",
  StyleBox["Method->AdamsBM", "MR"],
  "."
}], "Text"],

Cell["\<\
This solves the harmonic oscillator equation with the Adams method \
defined earlier.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(asol\  = \ 
      NDSolve[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 0, \ 
          x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, 
        x, {t, 0, 2\ \[Pi]}, \ Method \[Rule] AdamsBM]\)], "Input",
  CellLabel->"In[28]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 6.283185307179586`}}, "<>"]\),
            
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[28]="]
}, Open  ]],

Cell["\<\
This shows the error of the computed solution. It is apparent that \
the error is kept within reasonable bounds. Note that after the first few \
points, the step size has been increased.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ploterror[asol];\)\)], "Input",
  CellLabel->"In[38]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.275523 354764 [
[.17539 .26302 -3 -9 ]
[.17539 .26302 3 0 ]
[.32696 .26302 -3 -9 ]
[.32696 .26302 3 0 ]
[.47854 .26302 -3 -9 ]
[.47854 .26302 3 0 ]
[.63011 .26302 -3 -9 ]
[.63011 .26302 3 0 ]
[.78169 .26302 -3 -9 ]
[.78169 .26302 3 0 ]
[.93327 .26302 -3 -9 ]
[.93327 .26302 3 0 ]
[.01131 .00945 -51 -6.25 ]
[.01131 .00945 0 6.25 ]
[.01131 .09814 -39 -6.25 ]
[.01131 .09814 0 6.25 ]
[.01131 .18683 -51 -6.25 ]
[.01131 .18683 0 6.25 ]
[.01131 .36421 -45 -6.25 ]
[.01131 .36421 0 6.25 ]
[.01131 .4529 -33 -6.25 ]
[.01131 .4529 0 6.25 ]
[.01131 .5416 -45 -6.25 ]
[.01131 .5416 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .27552 m
.17539 .28177 L
s
[(1)] .17539 .26302 0 1 Mshowa
.32696 .27552 m
.32696 .28177 L
s
[(2)] .32696 .26302 0 1 Mshowa
.47854 .27552 m
.47854 .28177 L
s
[(3)] .47854 .26302 0 1 Mshowa
.63011 .27552 m
.63011 .28177 L
s
[(4)] .63011 .26302 0 1 Mshowa
.78169 .27552 m
.78169 .28177 L
s
[(5)] .78169 .26302 0 1 Mshowa
.93327 .27552 m
.93327 .28177 L
s
[(6)] .93327 .26302 0 1 Mshowa
.125 Mabswid
.05412 .27552 m
.05412 .27927 L
s
.08444 .27552 m
.08444 .27927 L
s
.11476 .27552 m
.11476 .27927 L
s
.14507 .27552 m
.14507 .27927 L
s
.2057 .27552 m
.2057 .27927 L
s
.23602 .27552 m
.23602 .27927 L
s
.26633 .27552 m
.26633 .27927 L
s
.29665 .27552 m
.29665 .27927 L
s
.35728 .27552 m
.35728 .27927 L
s
.38759 .27552 m
.38759 .27927 L
s
.41791 .27552 m
.41791 .27927 L
s
.44822 .27552 m
.44822 .27927 L
s
.50885 .27552 m
.50885 .27927 L
s
.53917 .27552 m
.53917 .27927 L
s
.56948 .27552 m
.56948 .27927 L
s
.5998 .27552 m
.5998 .27927 L
s
.66043 .27552 m
.66043 .27927 L
s
.69074 .27552 m
.69074 .27927 L
s
.72106 .27552 m
.72106 .27927 L
s
.75137 .27552 m
.75137 .27927 L
s
.81201 .27552 m
.81201 .27927 L
s
.84232 .27552 m
.84232 .27927 L
s
.87264 .27552 m
.87264 .27927 L
s
.90295 .27552 m
.90295 .27927 L
s
.96358 .27552 m
.96358 .27927 L
s
.9939 .27552 m
.9939 .27927 L
s
.25 Mabswid
0 .27552 m
1 .27552 L
s
.02381 .00945 m
.03006 .00945 L
s
gsave
.01131 .00945 -51 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-7.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .09814 m
.03006 .09814 L
s
gsave
.01131 .09814 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .18683 m
.03006 .18683 L
s
gsave
.01131 .18683 -51 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .36421 m
.03006 .36421 L
s
gsave
.01131 .36421 -45 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .4529 m
.03006 .4529 L
s
gsave
.01131 .4529 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .5416 m
.03006 .5416 L
s
gsave
.01131 .5416 -45 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(7.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.125 Mabswid
.02381 .02719 m
.02756 .02719 L
s
.02381 .04493 m
.02756 .04493 L
s
.02381 .06266 m
.02756 .06266 L
s
.02381 .0804 m
.02756 .0804 L
s
.02381 .11588 m
.02756 .11588 L
s
.02381 .13362 m
.02756 .13362 L
s
.02381 .15136 m
.02756 .15136 L
s
.02381 .16909 m
.02756 .16909 L
s
.02381 .20457 m
.02756 .20457 L
s
.02381 .22231 m
.02756 .22231 L
s
.02381 .24005 m
.02756 .24005 L
s
.02381 .25778 m
.02756 .25778 L
s
.02381 .29326 m
.02756 .29326 L
s
.02381 .311 m
.02756 .311 L
s
.02381 .32874 m
.02756 .32874 L
s
.02381 .34648 m
.02756 .34648 L
s
.02381 .38195 m
.02756 .38195 L
s
.02381 .39969 m
.02756 .39969 L
s
.02381 .41743 m
.02756 .41743 L
s
.02381 .43517 m
.02756 .43517 L
s
.02381 .47064 m
.02756 .47064 L
s
.02381 .48838 m
.02756 .48838 L
s
.02381 .50612 m
.02756 .50612 L
s
.02381 .52386 m
.02756 .52386 L
s
.02381 .55933 m
.02756 .55933 L
s
.02381 .57707 m
.02756 .57707 L
s
.02381 .59481 m
.02756 .59481 L
s
.02381 .61255 m
.02756 .61255 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .27552 Mdot
.02404 .27552 Mdot
.02451 .27552 Mdot
.02545 .27552 Mdot
.02733 .27551 Mdot
.03109 .27569 Mdot
.0386 .26629 Mdot
.05363 .2668 Mdot
.06866 .26656 Mdot
.08369 .26651 Mdot
.09872 .26601 Mdot
.11375 .26484 Mdot
.12877 .26325 Mdot
.15883 .25741 Mdot
.18889 .24408 Mdot
.21895 .2218 Mdot
.249 .201 Mdot
.27906 .19279 Mdot
.30912 .2094 Mdot
.33917 .25681 Mdot
.36923 .34088 Mdot
.39929 .40077 Mdot
.42934 .46961 Mdot
.4594 .50804 Mdot
.48946 .55619 Mdot
.51952 .58115 Mdot
.54957 .60108 Mdot
.57963 .60332 Mdot
.60969 .59394 Mdot
.63974 .57355 Mdot
.6698 .54036 Mdot
.69986 .50043 Mdot
.72992 .4464 Mdot
.75997 .39225 Mdot
.79003 .32887 Mdot
.82009 .27217 Mdot
.85014 .20878 Mdot
.8802 .15464 Mdot
.91026 .10064 Mdot
.94031 .05805 Mdot
.95825 .03457 Mdot
.97619 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[38]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`002?oo00<00?ooool0
0ooo00<00?ooool00_oo0`000ooo00D00?ooooooo`0000;oo`@000?oo`800?Ooo`002?oo00<00?oo
ool02ooo00L00?ooooooo`00ool00005ool01@00oooooooo00000_oo00<00?ooool02Ooo00<00?oo
ool0j?oo0009ool00`00ooooo`0:ool00`00ooooo`02ool00`00ooooo`04ool01@00oooooooo0000
0_oo00<00?ooool02Ooo00<00?ooool0j?oo00000ooo000000020004ool00`00ooooo`07ool30004
ool00`00ool00005ool01@00oooooooo00000_oo00<00?ooool02Ooo00<00?ooool0j?oo000:ool0
0`00ooooo`06ool00`00ooooo`03ool01@00oooooooo00001?oo00D00?ooooooo`0000;oo`03003o
oooo00Woo`<00>Soo`001ooo00@00?ooool000Soo`03003ooooo00[oo`<000?oo`04003ooooo000;
ool00`00ooooo`3Pool00`00ooooo`05ool000Ooo`@000Soo`@000_oo`03003ooooo00;oo`8000Wo
o`04003ooooo003Zool003;oo`04003ooooo003Zool002coo`<000?oo`03003ooooo00800>Woo`00
<ooo00<00?oo0000j_oo000aool01@00ool00?oo0000g_oo00<00?ooool02Ooo000aool300000ooo
003oo`3Yool003Goo`800>Woo`00=Ooo00<00?ooool0j?oo000eool00`00ooooo`3Xool003Goo`03
003ooooo0>Soo`00=Ooo0P00fOoo00<00?ooool03Ooo000eool00`00ooooo`3Xool003Goo`03003o
oooo0>Soo`00=Ooo00<00?ooool0j?oo000eool2003Yool001?oo`<000?oo`05003oooooool00002
ool40003ool2000<ool00`00ooooo`3Xool001Koo`07003oooooool00?oo00001Ooo00D00?oooooo
o`0000;oo`03003ooooo00Woo`03003ooooo0>Soo`005_oo00<00?ooool00_oo00<00?ooool01?oo
00D00?ooooooo`0000;oo`03003ooooo00Woo`03003ooooo0>Soo`003Ooo10000_oo0`001?oo00<0
0?oo00001Ooo00D00?ooooooo`0000;oo`03003ooooo00Woo`03003ooooo0>Soo`004ooo00<00?oo
ool00ooo00D00?ooooooo`0000Coo`05003oooooool00002ool00`00ooooo`09ool3003Xool001?o
o`03003ooooo00[oo`<000?oo`04003ooooo000;ool00`00ooooo`3Aool00`00ooooo`0Dool001?o
o`@000_oo`03003ooooo00;oo`8000Woo`04003ooooo003Zool003;oo`04003ooooo003Zool002co
o`<000?oo`03003ooooo00800>Woo`00<ooo00<00?oo0000j_oo000aool01@00ool00?oo0000j_oo
000aool300000ooo003oo`3Yool003Goo`800>Woo`00=Ooo00<00?ooool0j?oo000eool00`00oooo
o`3Xool003Goo`03003ooooo0>Soo`00=Ooo0P00jOoo000eool00`00ooooo`3Xool003Goo`03003o
oooo0<Woo`03003ooooo01coo`00=Ooo00<00?ooool0j?oo000eool00`00ooooo`3Xool003Goo`80
0>Woo`001ooo10000ooo00<00?ooool00_oo0`000ooo00D00?ooooooo`0000;oo`@000?oo`8000co
o`03003ooooo0>Soo`001ooo00<00?ooool03?oo00L00?ooooooo`00ool00005ool01@00oooooooo
00000_oo00<00?ooool02Ooo00<00?ooool0j?oo0008ool00`00ooooo`0;ool00`00ooooo`02ool0
0`00ooooo`04ool01@00oooooooo00000_oo00<00?ooool02Ooo00<00?ooool0j?oo00000ooo0000
00020004ool00`00ooooo`07ool30004ool00`00ool00005ool01@00oooooooo00000_oo00<00?oo
ool02Ooo0`00j?oo000:ool00`00ooooo`06ool00`00ooooo`03ool01@00oooooooo00001?oo00D0
0?ooooooo`0000;oo`03003ooooo00Woo`03003ooooo0>Soo`001ooo00@00?ooool000Soo`03003o
oooo00[oo`<000?oo`04003ooooo0008ool01000ooooo`00??oo00<00?ooool0Zooo0008ool20009
ool4000;ool00`00ooooo`02ool20009ool01000ooooo`00j_oo000/ool30003ool00`00ooooo`02
000dool00`00ooooo`2bool003?oo`03003oo`000>[oo`00<Ooo00D00?oo003oo`0004?oo`03003o
oooo07koo`03003ooooo02?oo`00<Ooo0`0000?oo`00ool0jOoo000eool2003Yool003Goo`03003o
oooo02coo`03003ooooo0;Woo`00=Ooo00<00?ooool0j?oo000eool00`00ooooo`0Pool4000Pool4
000Qool2000Sool00`00ooooo`0Oool3000Sool2000@ool003Goo`03003ooooo02;oo`03003ooooo
01ooo`03003ooooo027oo`04003ooooo000Rool00`00ooooo`0Rool00`00ooooo`0Oool01000oooo
o`003ooo000eool2000Sool00`00ooooo`0Pool00`00ooooo`0Sool00`00ooooo`0Mool5000Sool0
0`00ooooo`0Oool01000ooooo`003ooo000eool00`00ooooo`0Rool00`00ool0000Qool00`00oooo
o`0Pool2000Pool01000ooooo`008Ooo0`008_oo0`004?oo000eool00`00ooooo`0Rool00`00oooo
o`0Rool00`00ooooo`0Qool00`00ooooo`0Nool00`00ool0000Qool00`00ooooo`0Rool00`00oooo
o`0@ool003Goo`03003ooooo023oo`<0027oo`04003ooooo000Pool01000ooooo`008Ooo0P008Ooo
00<00?ooool08_oo00<00?ooool04?oo000eool2000Nool00`00ooooo`02ool00`00ooooo`0Pool2
00000ooo003oo`0Oool2000Sool00`00ooooo`0Oool4000Rool3000?ool003Goo`03003ooooo0>So
o`00=Ooo00D00?ooooooo`0000;oo`05003oooooool00002ool01@00oooooooo00000ooo00@00?oo
ool00=7oo`00=Ooo00<00?ooool0j?oo000`ooo`000003Goo`03003oo`0000Goo`03003ooooo00Co
o`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Co
o`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Co
o`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Go
o`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Go
o`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Co
o`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Co
o`40007oo`7oo`00=Ooo00<00?ooool08_oo00<00?ooool08Ooo00<00?ooool08Ooo00<00?ooool0
8Ooo00<00?ooool08Ooo00<00?ooool08_oo00<00?ooool03_oo000eool00`00ooooo`3Xool003Go
o`800>Woo`00=Ooo00<00?ooool0j?oo000eool00`00ooooo`3Xool003Goo`03003ooooo0>Soo`00
=Ooo00<00?ooool0j?oo000eool2003Yool003Goo`03003ooooo0>Soo`00=Ooo00<00?ooool0j?oo
000eool00`00ooooo`3Xool003Goo`800;Goo`03003ooooo037oo`00=Ooo00<00?ooool0j?oo000e
ool00`00ooooo`3Xool003Goo`03003ooooo053oo`03003ooooo09Goo`00=Ooo0P00jOoo0007ool4
0003ool00`00ooooo`02ool30003ool01@00oooooooo00000_oo10000ooo0P003?oo00<00?ooool0
j?oo0007ool00`00ooooo`0<ool01`00oooooooo003oo`0000Goo`05003oooooool00002ool00`00
ooooo`09ool00`00ooooo`3Xool000Soo`03003ooooo00_oo`03003ooooo00;oo`03003ooooo00Co
o`05003oooooool00002ool00`00ooooo`09ool00`00ooooo`3Xool000Woo`03003ooooo00Ooo`<0
00Coo`03003oo`0000Goo`05003oooooool00002ool00`00ooooo`09ool3003Xool000[oo`03003o
oooo00Koo`03003ooooo00?oo`05003oooooool00004ool01@00oooooooo00000_oo00<00?ooool0
2Ooo00<00?ooool0j?oo0007ool01000ooooo`002?oo00<00?ooool02_oo0`000ooo00@00?ooool0
00Soo`04003ooooo003Zool000Soo`8000Woo`@000_oo`03003ooooo00;oo`8000Woo`04003ooooo
003Zool002coo`<000?oo`03003ooooo00800>Woo`00<ooo00<00?oo0000j_oo000aool01@00ool0
0?oo0000j_oo000aool300000ooo003oo`2^ool00`00ooooo`0hool003Goo`03003ooooo0>Soo`00
=Ooo0P00F?oo00<00?ooool0S_oo000eool00`00ooooo`3Xool003Goo`03003ooooo0>Soo`00=Ooo
00<00?ooool0j?oo000eool2003Yool003Goo`03003ooooo0>Soo`00=Ooo00<00?ooool0j?oo000e
ool00`00ooooo`3Xool003Goo`800>Woo`004ooo0`000ooo00D00?ooooooo`0000;oo`@000?oo`80
00coo`03003ooooo0>Soo`005_oo00L00?ooooooo`00ool00005ool01@00oooooooo00000_oo00<0
0?ooool02Ooo00<00?ooool0j?oo000Fool00`00ooooo`02ool00`00ooooo`04ool01@00oooooooo
00000_oo00<00?ooool02Ooo00<00?ooool0Y_oo00<00?ooool0?ooo000Cool30004ool00`00ool0
0005ool01@00oooooooo00000_oo00<00?ooool02Ooo0`00j?oo000Cool00`00ooooo`03ool01@00
oooooooo00001?oo00D00?ooooooo`0000;oo`03003ooooo00Woo`03003ooooo0>Soo`004ooo00<0
0?ooool02_oo0`000ooo00@00?ooool000Soo`04003ooooo003Zool001?oo`@000_oo`03003ooooo
00;oo`8000Woo`04003ooooo003Zool002coo`<000?oo`04003ooooo003Zool003?oo`04003oo`00
001Oool00`00ooooo`27ool0037oo`05003oo`00ool0003Zool0037oo`<00003ool00?oo0>Woo`00
=Ooo00<00?ooool0j?oo000eool2003Yool003Goo`03003ooooo0>Soo`00=Ooo00<00?ooool0j?oo
000eool00`00ooooo`2Nool00`00ooooo`17ool003Goo`800>Woo`00=Ooo00<00?ooool0IOoo00<0
0?ooool0P?oo000eool00`00ooooo`3Xool003Goo`03003ooooo0>Soo`00=Ooo0P00jOoo0008ool0
0`00ooooo`03ool00`00ooooo`02ool30003ool01@00oooooooo00000_oo10000ooo0P003?oo00<0
0?ooool0j?oo0008ool00`00ooooo`0;ool01`00oooooooo003oo`0000Goo`05003oooooool00002
ool00`00ooooo`09ool00`00ooooo`3Xool000Woo`03003ooooo00[oo`03003ooooo00;oo`03003o
oooo00Coo`05003oooooool00002ool00`00ooooo`09ool00`00ooooo`3Xool000Woo`03003ooooo
00Ooo`<000Coo`03003oo`0000Goo`05003oooooool00002ool00`00ooooo`09ool00`00ooooo`3X
ool000[oo`03003ooooo00Koo`03003ooooo00?oo`05003oooooool00004ool01@00oooooooo0000
0_oo00<00?ooool02Ooo0`00Uooo00<00?ooool0C_oo0007ool01000ooooo`002?oo00<00?ooool0
2_oo0`000ooo00@00?ooool000_oo`03003ooooo0>Soo`001ooo10002?oo10002ooo00<00?ooool0
0_oo0P002Ooo00@00?ooool00>[oo`00<_oo00@00?ooool006koo`03003ooooo07Woo`00;?oo0`00
0ooo00<00?ooool00P00jOoo000cool00`00ool0003Zool0037oo`05003oo`00ool0003Zool0037o
o`<00003ool00?oo0>Woo`00=Ooo0P00TOoo00<00?ooool0EOoo000eool00`00ooooo`1cool00`00
ooooo`1bool003Goo`03003ooooo0>Soo`00=Ooo00<00?ooool0j?oo000eool2002:ool00`00oooo
o`1Lool003Goo`03003ooooo0>Soo`00=Ooo00<00?ooool0Nooo00<00?ooool0J_oo000eool00`00
ooooo`22ool00`00ooooo`1Sool003Goo`800>Woo`00=Ooo00<00?ooool0j?oo000eool00`00oooo
o`3Xool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7o
o`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00001\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {467.562, 246.375}} -> {-3.56155, \
1.35394*^-6, 0.027639, 1.1809*^-8}}]
}, Open  ]],

Cell["\<\
Where this method has the potential to outperform some of the \
built-in methods is with high-precision computations with strict tolerances. \
This is because the built-in methods are adapted from codes with the \
restriction to order 12. \
\>", "Text"],

Cell[BoxData[{
    \(\(LorenzEquations\  = \ {\[IndentingNewLine]{\(x'\)[
                t]\  == \ \(-3\)\ \((x[t]\  - \ y[t])\), \ 
            x[0]\  == \ 0}, {\(y'\)[t]\  == \ \(-x[t]\)\ z[t]\  + \ 
                53/2\ x[t]\  - \ y[t], 
            y[0]\  == \ 1}, {\(z'\)[t]\  == \ x[t]\ y[t]\  - \ z[t], \ 
            z[0]\  == \ 0}};\)\), "\[IndentingNewLine]", 
    \(\(vars\  = \ {x[t], y[t], z[t]};\)\)}], "Input",
  CellLabel->"In[4]:="],

Cell["A lot of time is required for coefficient computation.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      NDSolve[LorenzEquations, \ vars, \ {t, 0, 20}, \ 
        Method \[Rule] AdamsBM]]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(7.04`\ Second\), ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{\(x[t]\), "\[Rule]", 
                RowBox[{
                  TagBox[\(InterpolatingFunction[{{0.`, 20.`}}, "<>"]\),
                    False,
                    Editable->False], "[", "t", "]"}]}], ",", 
              RowBox[{\(y[t]\), "\[Rule]", 
                RowBox[{
                  TagBox[\(InterpolatingFunction[{{0.`, 20.`}}, "<>"]\),
                    False,
                    Editable->False], "[", "t", "]"}]}], ",", 
              RowBox[{\(z[t]\), "\[Rule]", 
                RowBox[{
                  TagBox[\(InterpolatingFunction[{{0.`, 20.`}}, "<>"]\),
                    False,
                    Editable->False], "[", "t", "]"}]}]}], "}"}], "}"}]}], 
      "}"}]], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell["\<\
This is not using as high an order as might be expected.
In any case, about half the time is spent generating coefficients, so to make \
it better, we need to figure out the coefficient update.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      NDSolve[LorenzEquations, \ vars, \ {t, 0, 20}, \ 
        Method \[Rule] AdamsBM, \ WorkingPrecision \[Rule] 32]]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(95.32`\ Second\), ",", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{\(x[t]\), "\[Rule]", 
                RowBox[{
                  TagBox[\(InterpolatingFunction[{{0, 20.`32. }}, "<>"]\),
                    False,
                    Editable->False], "[", "t", "]"}]}], ",", 
              RowBox[{\(y[t]\), "\[Rule]", 
                RowBox[{
                  TagBox[\(InterpolatingFunction[{{0, 20.`32. }}, "<>"]\),
                    False,
                    Editable->False], "[", "t", "]"}]}], ",", 
              RowBox[{\(z[t]\), "\[Rule]", 
                RowBox[{
                  TagBox[\(InterpolatingFunction[{{0, 20.`32. }}, "<>"]\),
                    False,
                    Editable->False], "[", "t", "]"}]}]}], "}"}], "}"}]}], 
      "}"}]], "Output",
  CellLabel->"Out[10]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 967}},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Method Plug-in Framework",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[1776, 53, 62, 1, 92, "Chapter",
      CellTags->"c:1"]},
  "s:1"->{
    Cell[1863, 58, 50, 1, 65, "Section",
      CellTags->"s:1"]},
  "s:2"->{
    Cell[18601, 588, 59, 1, 65, "Section",
      CellTags->"s:2"]},
  "s:4"->{
    Cell[204228, 4521, 51, 1, 65, "Section",
      CellTags->"s:4"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 242739, 5645},
  {"s:1", 242816, 5648},
  {"s:2", 242893, 5651},
  {"s:4", 242972, 5654}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 62, 1, 92, "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{
Cell[1863, 58, 50, 1, 65, "Section",
  CellTags->"s:1"],
Cell[1916, 61, 287, 9, 42, "Text"],
Cell[2206, 72, 326, 8, 42, "Text"],
Cell[2535, 82, 1026, 27, 112, "DefinitionBox"],
Cell[3564, 111, 109, 4, 17, "Caption"],
Cell[3676, 117, 373, 8, 59, "Text"],
Cell[4052, 127, 1137, 41, 40, "TopSpanBox"],
Cell[5192, 170, 2079, 56, 164, "MiddleBox"],
Cell[7274, 228, 268, 9, 34, "MiddleSpanBox"],
Cell[7545, 239, 187, 7, 28, "MiddleBox"],
Cell[7735, 248, 261, 9, 34, "MiddleSpanBox"],
Cell[7999, 259, 817, 22, 114, "BottomBox"],
Cell[8819, 283, 122, 4, 17, "Caption"],
Cell[8944, 289, 626, 19, 76, "Text"],
Cell[9573, 310, 8932, 271, 390, "DefinitionBox"],
Cell[18508, 583, 56, 0, 17, "Caption"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18601, 588, 59, 1, 65, "Section",
  CellTags->"s:2"],
Cell[18663, 591, 102, 3, 25, "Text"],
Cell[18768, 596, 245, 5, 58, "MathCaption"],
Cell[19016, 603, 467, 9, 129, "Input"],
Cell[19486, 614, 259, 5, 58, "MathCaption"],
Cell[19748, 621, 105, 2, 29, "Input"],
Cell[19856, 625, 292, 7, 58, "MathCaption"],
Cell[20151, 634, 102, 2, 29, "Input"],
Cell[20256, 638, 110, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[20391, 645, 239, 5, 49, "Input"],
Cell[20633, 652, 288, 9, 27, "Output"]
}, Open  ]],
Cell[20936, 664, 1032, 23, 127, "Text"],
Cell[21971, 689, 221, 5, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[22217, 698, 323, 7, 49, "Input"],
Cell[22543, 707, 288, 9, 27, "Output"]
}, Open  ]],
Cell[22846, 719, 205, 5, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[23076, 728, 695, 13, 189, "Input"],
Cell[23774, 743, 21372, 744, 184, 9983, 598, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[45161, 1490, 293, 5, 59, "Text"],
Cell[45457, 1497, 648, 12, 93, "Text"],
Cell[46108, 1511, 251, 6, 42, "Text"],
Cell[46362, 1519, 100, 4, 41, "MathCaption"],
Cell[46465, 1525, 100, 2, 29, "Input"],
Cell[46568, 1529, 257, 5, 42, "Text"],
Cell[46828, 1536, 138, 4, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[46991, 1544, 148, 3, 29, "Input"],
Cell[47142, 1549, 439, 10, 74, "Output"]
}, Open  ]],
Cell[47596, 1562, 263, 5, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[47884, 1571, 174, 4, 29, "Input"],
Cell[48061, 1577, 95, 2, 43, "Output"]
}, Open  ]],
Cell[48171, 1582, 96, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[48292, 1589, 105, 2, 29, "Input"],
Cell[48400, 1593, 146927, 2649, 384, 15266, 1019, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[195342, 4245, 336, 7, 59, "Text"],
Cell[195681, 4254, 102, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[195808, 4261, 101, 2, 29, "Input"],
Cell[195912, 4265, 111, 2, 27, "Output"]
}, Open  ]],
Cell[196038, 4270, 117, 4, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[196180, 4278, 159, 3, 30, "Input"],
Cell[196342, 4283, 100, 2, 27, "Output"]
}, Open  ]],
Cell[196457, 4288, 195, 4, 42, "Text"],

Cell[CellGroupData[{
Cell[196677, 4296, 279, 6, 49, "Input"],
Cell[196959, 4304, 288, 9, 27, "Output"]
}, Open  ]],
Cell[197262, 4316, 382, 7, 59, "Text"],
Cell[197647, 4325, 4431, 132, 302, "DefinitionBox"],
Cell[202081, 4459, 54, 0, 17, "Caption"],
Cell[202138, 4461, 392, 10, 59, "Text"],
Cell[202533, 4473, 278, 5, 59, "Text"],
Cell[202814, 4480, 226, 4, 58, "MathCaption"],
Cell[203043, 4486, 504, 9, 149, "Input"],
Cell[203550, 4497, 122, 3, 41, "MathCaption"],
Cell[203675, 4502, 326, 7, 89, "Input"],
Cell[204004, 4511, 187, 5, 42, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[204228, 4521, 51, 1, 65, "Section",
  CellTags->"s:4"],
Cell[204282, 4524, 731, 16, 93, "Text"],
Cell[205016, 4542, 671, 20, 60, "Text"],
Cell[205690, 4564, 169, 4, 31, "DisplayMath"],
Cell[205862, 4570, 213, 4, 58, "DisplayMath"],
Cell[206078, 4576, 146, 5, 26, "Text"],
Cell[206227, 4583, 251, 5, 56, "DisplayMath"],
Cell[206481, 4590, 356, 5, 66, "DisplayMath"],
Cell[206840, 4597, 508, 15, 59, "MathCaption"],
Cell[207351, 4614, 1116, 21, 329, "Input"],
Cell[208470, 4637, 519, 11, 59, "Text"],
Cell[208992, 4650, 145, 3, 41, "MathCaption"],
Cell[209140, 4655, 212, 6, 49, "Input"],
Cell[209355, 4663, 565, 10, 76, "Text"],
Cell[209923, 4675, 164, 6, 41, "MathCaption"],
Cell[210090, 4683, 948, 16, 209, "Input"],
Cell[211041, 4701, 658, 12, 93, "Text"],
Cell[211702, 4715, 583, 11, 93, "Text"],
Cell[212288, 4728, 173, 6, 41, "MathCaption"],
Cell[212464, 4736, 139, 4, 29, "Input"],
Cell[212606, 4742, 263, 8, 42, "Text"],
Cell[212872, 4752, 293, 7, 58, "MathCaption"],
Cell[213168, 4761, 109, 2, 29, "Input"],
Cell[213280, 4765, 186, 6, 41, "MathCaption"],
Cell[213469, 4773, 143, 3, 29, "Input"],
Cell[213615, 4778, 266, 5, 42, "Text"],
Cell[213884, 4785, 212, 6, 58, "MathCaption"],
Cell[214099, 4793, 4296, 71, 927, "Input"],
Cell[218398, 4866, 762, 12, 110, "Text"],
Cell[219163, 4880, 420, 17, 59, "MathCaption"],
Cell[219586, 4899, 1126, 21, 227, "Input"],
Cell[220715, 4922, 119, 3, 41, "MathCaption"],
Cell[220837, 4927, 1379, 27, 411, "Input"],
Cell[222219, 4956, 189, 6, 41, "MathCaption"],
Cell[222411, 4964, 340, 7, 134, "Input"],
Cell[222754, 4973, 193, 6, 25, "Text"],
Cell[222950, 4981, 116, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[223091, 4988, 241, 5, 49, "Input"],
Cell[223335, 4995, 288, 9, 27, "Output"]
}, Open  ]],
Cell[223638, 5007, 217, 4, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[223880, 5015, 78, 2, 29, "Input"],
Cell[223961, 5019, 14721, 508, 184, 6190, 398, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[238697, 5530, 263, 5, 42, "Text"],
Cell[238963, 5537, 451, 8, 109, "Input"],
Cell[239417, 5547, 70, 0, 25, "Text"],

Cell[CellGroupData[{
Cell[239512, 5551, 153, 4, 29, "Input"],
Cell[239668, 5557, 894, 22, 65, "Output"]
}, Open  ]],
Cell[240577, 5582, 217, 4, 67, "Text"],

Cell[CellGroupData[{
Cell[240819, 5590, 185, 4, 49, "Input"],
Cell[241007, 5596, 902, 22, 103, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

