(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    293470,       9023]*)
(*NotebookOutlinePosition[    295352,       9087]*)
(*  CellTagsIndexPosition[    295053,       9074]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Projection", "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"s:1"],

Cell["\<\
When a differential system has a certain structure, it is \
advantageous if a numerical integration method preserves the structure. In \
certain situations it is useful to solve differential equations in which \
solutions are constrained. Projection methods work by taking a time step with \
a numerical integration method and then projecting the approximate solution \
onto the manifold on which the true solution evolves.\
\>", "Text"],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " includes a differential algebraic solver which may be appropriate and is \
described in more detail within ",
  ButtonBox["Differential-Algebraic Equations",
    ButtonData:>{"DAE.nb", None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell[TextData[{
  "Sometimes the form of the equations may not be reduced to the form \
required by a DAE solver. Furthermore so-called index reduction techniques \
can destroy certain structural properties, such as symplecticity, that the \
differential system may possess (see [",
  ButtonBox["HW96",
    ButtonData:>{"References.nb", "HW96"},
    ButtonStyle->"Hyperlink"],
  "] and [",
  ButtonBox["H02",
    ButtonData:>{"References.nb", "H02"},
    ButtonStyle->"Hyperlink"],
  "]). An example that illustrates this can be found in the documentation for \
DAEs."
}], "Text"],

Cell[TextData[{
  "In such cases it is often possible to solve a differential system and then \
use a projective procedure to ensure that the constraints are conserved. This \
is the idea behind the method ",
  StyleBox["Projection", "MR"],
  "."
}], "Text"],

Cell[TextData[{
  "If the differential system is \[Rho]-reversible then a ",
  StyleBox["symmetric",
    FontSlant->"Italic"],
  " projection process can be advantageous (see [",
  ButtonBox["H00",
    ButtonData:>{"References.nb", "H00"},
    ButtonStyle->"Hyperlink"],
  "]). Symmetric projection is generally more costly than projection and has \
not yet been implemented in ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Invariants", "Subsection"],

Cell["Consider a differential equation", "Text"],

Cell[BoxData[
    \(TraditionalForm\`y\& . \  = \ f(y), \ 
    y(t\_0)\  = \ y\_0, \)], "NumberedEquation",
  CellTags->"ODESystem"],

Cell["where y may be a vector or a matrix.", "Text"],

Cell[TextData[{
  StyleBox["Definition",
    FontWeight->"Bold"],
  ": A non-constant function I(",
  "y",
  ") is called an ",
  StyleBox["invariant",
    FontSlant->"Italic"],
  " of (",
  
  CounterBox["NumberedEquation", "ODESystem"],
  ") if ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(I\^\[Prime]\)(y)\) \(f(y)\)\  = \ 0\)]],
  " for all y."
}], "Text"],

Cell[TextData[{
  "This implies that every solution ",
  StyleBox["y",
    FontSlant->"Italic"],
  "(",
  StyleBox["t",
    FontSlant->"Italic"],
  ") of (",
  
  CounterBox["NumberedEquation", "ODESystem"],
  ") satisfies I(",
  StyleBox["y",
    FontSlant->"Italic"],
  "(",
  StyleBox["t",
    FontSlant->"Italic"],
  ")) = ",
  Cell[BoxData[
      \(TraditionalForm\`I(y\_0)\)]],
  "= Constant."
}], "Text"],

Cell[TextData[{
  "Synonymous with invariant, the terms ",
  StyleBox["first integral",
    FontSlant->"Italic"],
  ", ",
  StyleBox["conserved quantity",
    FontSlant->"Italic"],
  ", or ",
  StyleBox["constant of the motion",
    FontSlant->"Italic"],
  " are also common."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manifolds", "Subsection"],

Cell[TextData[{
  "Given an ",
  Cell[BoxData[
      \(TraditionalForm\`\((n - m)\)\)]],
  "-dimensional submanifold of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`g : \ \[DoubleStruckCapitalR]\^n \[RightTeeArrow] \(\
\(\[DoubleStruckCapitalR]\^m\)\(:\)\)\)]]
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[ScriptCapitalM] = \(\({y; 
          g(y) = 0}\)\(.\)\)\)], "NumberedEquation",
  CellTags->"Submanifold"],

Cell[TextData[{
  "Given a differential equation (",
  
  CounterBox["NumberedEquation", "ODESystem"],
  ") then ",
  Cell[BoxData[
      \(TraditionalForm\`y\_0 \[Element] \[ScriptCapitalM]\)]],
  " implies ",
  Cell[BoxData[
      \(TraditionalForm\`y(t) \[Element] \[ScriptCapitalM]\)]],
  " for all ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ".",
  " ",
  "This is a weaker assumption than invariance and g(y) is called a weak \
invariant (see [",
  ButtonBox["H02",
    ButtonData:>{"References.nb", "H02"},
    ButtonStyle->"Hyperlink"],
  "])."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Projection algorithm", "Subsection"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          FormBox[\(y\& \[Tilde] \),
            "TraditionalForm"], \(n + 1\)], TraditionalForm]]],
  "denote the solution from a one-step numerical integrator. Considering a \
constrained minimization problem leads to the following system (see [",
  ButtonBox["AP91",
    ButtonData:>{"References.nb", "AP91"},
    ButtonStyle->"Hyperlink"],
  "], [",
  ButtonBox["HW96",
    ButtonData:>{"References.nb", "HW96"},
    ButtonStyle->"Hyperlink"],
  "] and [",
  ButtonBox["H02",
    ButtonData:>{"References.nb", "H02"},
    ButtonStyle->"Hyperlink"],
  "]):"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(y\_\(n + 1\)\), 
            "=", \(\(y\& \[Tilde] \)\_\(n + 1\) + \ 
              g' \(\((y\_\(n + 1\))\)\^T\) \[Lambda]\)},
          {"0", "=", \(g(y\_\(n + 1\))\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"ConstrainedMinimum"],

Cell[TextData[{
  "To save work ",
  Cell[BoxData[
      \(TraditionalForm\`g(y\_\(n + 1\))\)]],
  "is approximated as ",
  Cell[BoxData[
      \(TraditionalForm\`g(\(y\& \[Tilde] \)\_\(n + 1\))\)]],
  ". Substituting the first relation into the second relation in (",
  
  CounterBox["NumberedEquation", "ConstrainedMinimum"],
  ") leads to the following simplified Newton scheme for \[Lambda]:"
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(\(\[CapitalDelta]\[Lambda]\_i\)\(\ \)\), 
            "=", \(\(\(-\((\ g' \((\(y\& \[Tilde] \)\_\(n + 1\))\)\ g' \((\(y\
\& \[Tilde] \)\_\(n + 1\))\)\^T)\)\^\(-1\)\) \(g(\(y\& \[Tilde] \)\_\(n + 1\)\
\  + \ g' \((\(y\& \[Tilde] \)\_\(n + 1\))\)\^T\ \[Lambda]\_i)\)\)\(\ \)\(,\)\
\)},
          {\(\[Lambda]\_\(i + 1\)\), 
            "=", \(\(\[Lambda]\_i\)\(+\)\(\ \)\(\[CapitalDelta]\[Lambda]\_i\)\
\(\ \)\)}
          }], TraditionalForm]], "NumberedEquation",
  CellTags->"StandardProjectionAlgorithm"],

Cell[TextData[{
  "with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\_0 = \ 0\)]],
  "."
}], "Text"],

Cell[TextData[{
  "The first increment ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\[Lambda]\_0\)]],
  "is of size ",
  Cell[BoxData[
      \(TraditionalForm\`O(h\_n\%\(p + 1\))\)]],
  " so that (",
  
  CounterBox["NumberedEquation", "StandardProjectionAlgorithm"],
  ") usually converges quickly."
}], "Text"],

Cell["\<\
The added expense of using a higher order integration method can be \
offset by fewer Newton iterations in the projective step.\
\>", "Text"],

Cell[TextData[{
  "For the termination criterion in the method ",
  StyleBox["Projection", "MR"],
  ", the option IterationSafetyFactor is combined with one Unit in the Last \
Place in the working precision used by ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",
  CellTags->"s:2"],

Cell["Load some utility packages.", "Text"],

Cell[BoxData[{
    \(\(Needs["\<DifferentialEquations`NDSolveProblems`\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(Needs["\<DifferentialEquations`NDSolveUtilities`\>"];\)\)}], "Input",
  CellLabel->"In[1]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Linear invariants", "Subsection"],

Cell["Define the a stiff system modeling a chemical reaction.", "Text"],

Cell[BoxData[{
    \(\(system\  = \ 
        GetNDSolveProblem["\<Robertson\>"];\)\), "\[IndentingNewLine]", 
    \(\(vars\  = \ system["\<DependentVariables\>"[]];\)\)}], "Input",
  CellLabel->"In[97]:="],

Cell["This system has a linear invariant.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(invariant\  = \ system["\<Invariants\>"[]]\)], "Input",
  CellLabel->"In[99]:="],

Cell[BoxData[
    \({Y\_1[T] + Y\_2[T] + Y\_3[T]}\)], "Output",
  CellLabel->"Out[99]="]
}, Open  ]],

Cell[TextData[{
  "Linear invariants are generally conserved by numerical integrators (see ",
  "[",
  ButtonBox["S86",
    ButtonData:>{"References.nb", "S86"},
    ButtonStyle->"Hyperlink"],
  "]",
  "), including the default ",
  StyleBox["NDSolve", "MR"],
  " method, as can be observed in a plot of the error in the invariant."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(sol\  = \ NDSolve[system];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(InvariantErrorPlot[invariant, vars, T, sol];\)\)}], "Input",
  CellLabel->"In[100]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 3.1746 0.0238095 2.85943e+15 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.18254 -0.0125 -12 -9 ]
[.18254 -0.0125 12 0 ]
[.34127 -0.0125 -9 -9 ]
[.34127 -0.0125 9 0 ]
[.5 -0.0125 -12 -9 ]
[.5 -0.0125 12 0 ]
[.65873 -0.0125 -9 -9 ]
[.65873 -0.0125 9 0 ]
[.81746 -0.0125 -12 -9 ]
[.81746 -0.0125 12 0 ]
[.97619 -0.0125 -9 -9 ]
[.97619 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .16678 -37.5 -6.25 ]
[-0.0125 .16678 0 6.25 ]
[-0.0125 .30975 -37.5 -6.25 ]
[-0.0125 .30975 0 6.25 ]
[-0.0125 .45272 -49.5 -6.25 ]
[-0.0125 .45272 0 6.25 ]
[-0.0125 .5957 -37.5 -6.25 ]
[-0.0125 .5957 0 6.25 ]
[-0.0125 .73867 -49.5 -6.25 ]
[-0.0125 .73867 0 6.25 ]
[-0.0125 .88164 -37.5 -6.25 ]
[-0.0125 .88164 0 6.25 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(0.05)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(0.1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0.15)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(0.2)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(0.25)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(0.3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .16678 m
.00625 .16678 L
s
gsave
-0.0125 .16678 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-17) show
grestore
0 .30975 m
.00625 .30975 L
s
gsave
-0.0125 .30975 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
0 .45272 m
.00625 .45272 L
s
gsave
-0.0125 .45272 -49.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
0 .5957 m
.00625 .5957 L
s
gsave
-0.0125 .5957 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
0 .73867 m
.00625 .73867 L
s
gsave
-0.0125 .73867 -49.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
0 .88164 m
.00625 .88164 L
s
gsave
-0.0125 .88164 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(3) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
.125 Mabswid
0 .0524 m
.00375 .0524 L
s
0 .081 m
.00375 .081 L
s
0 .10959 m
.00375 .10959 L
s
0 .13819 m
.00375 .13819 L
s
0 .19538 m
.00375 .19538 L
s
0 .22397 m
.00375 .22397 L
s
0 .25256 m
.00375 .25256 L
s
0 .28116 m
.00375 .28116 L
s
0 .33835 m
.00375 .33835 L
s
0 .36694 m
.00375 .36694 L
s
0 .39554 m
.00375 .39554 L
s
0 .42413 m
.00375 .42413 L
s
0 .48132 m
.00375 .48132 L
s
0 .50991 m
.00375 .50991 L
s
0 .53851 m
.00375 .53851 L
s
0 .5671 m
.00375 .5671 L
s
0 .62429 m
.00375 .62429 L
s
0 .65288 m
.00375 .65288 L
s
0 .68148 m
.00375 .68148 L
s
0 .71007 m
.00375 .71007 L
s
0 .76726 m
.00375 .76726 L
s
0 .79586 m
.00375 .79586 L
s
0 .82445 m
.00375 .82445 L
s
0 .85304 m
.00375 .85304 L
s
0 .91023 m
.00375 .91023 L
s
0 .93883 m
.00375 .93883 L
s
0 .96742 m
.00375 .96742 L
s
0 .99602 m
.00375 .99602 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.18254 .99375 m
.18254 1 L
s
.34127 .99375 m
.34127 1 L
s
.5 .99375 m
.5 1 L
s
.65873 .99375 m
.65873 1 L
s
.81746 .99375 m
.81746 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.05556 .99625 m
.05556 1 L
s
.0873 .99625 m
.0873 1 L
s
.11905 .99625 m
.11905 1 L
s
.15079 .99625 m
.15079 1 L
s
.21429 .99625 m
.21429 1 L
s
.24603 .99625 m
.24603 1 L
s
.27778 .99625 m
.27778 1 L
s
.30952 .99625 m
.30952 1 L
s
.37302 .99625 m
.37302 1 L
s
.40476 .99625 m
.40476 1 L
s
.43651 .99625 m
.43651 1 L
s
.46825 .99625 m
.46825 1 L
s
.53175 .99625 m
.53175 1 L
s
.56349 .99625 m
.56349 1 L
s
.59524 .99625 m
.59524 1 L
s
.62698 .99625 m
.62698 1 L
s
.69048 .99625 m
.69048 1 L
s
.72222 .99625 m
.72222 1 L
s
.75397 .99625 m
.75397 1 L
s
.78571 .99625 m
.78571 1 L
s
.84921 .99625 m
.84921 1 L
s
.88095 .99625 m
.88095 1 L
s
.9127 .99625 m
.9127 1 L
s
.94444 .99625 m
.94444 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .16678 m
1 .16678 L
s
.99375 .30975 m
1 .30975 L
s
.99375 .45272 m
1 .45272 L
s
.99375 .5957 m
1 .5957 L
s
.99375 .73867 m
1 .73867 L
s
.99375 .88164 m
1 .88164 L
s
.125 Mabswid
.99625 .0524 m
1 .0524 L
s
.99625 .081 m
1 .081 L
s
.99625 .10959 m
1 .10959 L
s
.99625 .13819 m
1 .13819 L
s
.99625 .19538 m
1 .19538 L
s
.99625 .22397 m
1 .22397 L
s
.99625 .25256 m
1 .25256 L
s
.99625 .28116 m
1 .28116 L
s
.99625 .33835 m
1 .33835 L
s
.99625 .36694 m
1 .36694 L
s
.99625 .39554 m
1 .39554 L
s
.99625 .42413 m
1 .42413 L
s
.99625 .48132 m
1 .48132 L
s
.99625 .50991 m
1 .50991 L
s
.99625 .53851 m
1 .53851 L
s
.99625 .5671 m
1 .5671 L
s
.99625 .62429 m
1 .62429 L
s
.99625 .65288 m
1 .65288 L
s
.99625 .68148 m
1 .68148 L
s
.99625 .71007 m
1 .71007 L
s
.99625 .76726 m
1 .76726 L
s
.99625 .79586 m
1 .79586 L
s
.99625 .82445 m
1 .82445 L
s
.99625 .85304 m
1 .85304 L
s
.99625 .91023 m
1 .91023 L
s
.99625 .93883 m
1 .93883 L
s
.99625 .96742 m
1 .96742 L
s
.99625 .99602 m
1 .99602 L
s
.25 Mabswid
1 0 m
1 1 L
s
.0001 w
.02381 .02381 -1.875 0 Mabsadd m
.02381 .02381 0 2.5 Mabsadd L
.02381 .02381 1.875 0 Mabsadd L
.02381 .02381 0 -2.5 Mabsadd L
.02381 .02381 -1.875 0 Mabsadd L closepath F
.02391 .02381 -1.875 0 Mabsadd m
.02391 .02381 0 2.5 Mabsadd L
.02391 .02381 1.875 0 Mabsadd L
.02391 .02381 0 -2.5 Mabsadd L
.02391 .02381 -1.875 0 Mabsadd L closepath F
.02401 .34127 -1.875 0 Mabsadd m
.02401 .34127 0 2.5 Mabsadd L
.02401 .34127 1.875 0 Mabsadd L
.02401 .34127 0 -2.5 Mabsadd L
.02401 .34127 -1.875 0 Mabsadd L closepath F
.02425 .34127 -1.875 0 Mabsadd m
.02425 .34127 0 2.5 Mabsadd L
.02425 .34127 1.875 0 Mabsadd L
.02425 .34127 0 -2.5 Mabsadd L
.02425 .34127 -1.875 0 Mabsadd L closepath F
.0245 .34127 -1.875 0 Mabsadd m
.0245 .34127 0 2.5 Mabsadd L
.0245 .34127 1.875 0 Mabsadd L
.0245 .34127 0 -2.5 Mabsadd L
.0245 .34127 -1.875 0 Mabsadd L closepath F
.02475 .34127 -1.875 0 Mabsadd m
.02475 .34127 0 2.5 Mabsadd L
.02475 .34127 1.875 0 Mabsadd L
.02475 .34127 0 -2.5 Mabsadd L
.02475 .34127 -1.875 0 Mabsadd L closepath F
.02522 .34127 -1.875 0 Mabsadd m
.02522 .34127 0 2.5 Mabsadd L
.02522 .34127 1.875 0 Mabsadd L
.02522 .34127 0 -2.5 Mabsadd L
.02522 .34127 -1.875 0 Mabsadd L closepath F
.02568 .34127 -1.875 0 Mabsadd m
.02568 .34127 0 2.5 Mabsadd L
.02568 .34127 1.875 0 Mabsadd L
.02568 .34127 0 -2.5 Mabsadd L
.02568 .34127 -1.875 0 Mabsadd L closepath F
.02614 .02381 -1.875 0 Mabsadd m
.02614 .02381 0 2.5 Mabsadd L
.02614 .02381 1.875 0 Mabsadd L
.02614 .02381 0 -2.5 Mabsadd L
.02614 .02381 -1.875 0 Mabsadd L closepath F
.02661 .02381 -1.875 0 Mabsadd m
.02661 .02381 0 2.5 Mabsadd L
.02661 .02381 1.875 0 Mabsadd L
.02661 .02381 0 -2.5 Mabsadd L
.02661 .02381 -1.875 0 Mabsadd L closepath F
.02717 .02381 -1.875 0 Mabsadd m
.02717 .02381 0 2.5 Mabsadd L
.02717 .02381 1.875 0 Mabsadd L
.02717 .02381 0 -2.5 Mabsadd L
.02717 .02381 -1.875 0 Mabsadd L closepath F
.02774 .02381 -1.875 0 Mabsadd m
.02774 .02381 0 2.5 Mabsadd L
.02774 .02381 1.875 0 Mabsadd L
.02774 .02381 0 -2.5 Mabsadd L
.02774 .02381 -1.875 0 Mabsadd L closepath F
.0283 .02381 -1.875 0 Mabsadd m
.0283 .02381 0 2.5 Mabsadd L
.0283 .02381 1.875 0 Mabsadd L
.0283 .02381 0 -2.5 Mabsadd L
.0283 .02381 -1.875 0 Mabsadd L closepath F
.02886 .02381 -1.875 0 Mabsadd m
.02886 .02381 0 2.5 Mabsadd L
.02886 .02381 1.875 0 Mabsadd L
.02886 .02381 0 -2.5 Mabsadd L
.02886 .02381 -1.875 0 Mabsadd L closepath F
.02943 .02381 -1.875 0 Mabsadd m
.02943 .02381 0 2.5 Mabsadd L
.02943 .02381 1.875 0 Mabsadd L
.02943 .02381 0 -2.5 Mabsadd L
.02943 .02381 -1.875 0 Mabsadd L closepath F
.03017 .02381 -1.875 0 Mabsadd m
.03017 .02381 0 2.5 Mabsadd L
.03017 .02381 1.875 0 Mabsadd L
.03017 .02381 0 -2.5 Mabsadd L
.03017 .02381 -1.875 0 Mabsadd L closepath F
.03091 .02381 -1.875 0 Mabsadd m
.03091 .02381 0 2.5 Mabsadd L
.03091 .02381 1.875 0 Mabsadd L
.03091 .02381 0 -2.5 Mabsadd L
.03091 .02381 -1.875 0 Mabsadd L closepath F
.03165 .02381 -1.875 0 Mabsadd m
.03165 .02381 0 2.5 Mabsadd L
.03165 .02381 1.875 0 Mabsadd L
.03165 .02381 0 -2.5 Mabsadd L
.03165 .02381 -1.875 0 Mabsadd L closepath F
.03239 .02381 -1.875 0 Mabsadd m
.03239 .02381 0 2.5 Mabsadd L
.03239 .02381 1.875 0 Mabsadd L
.03239 .02381 0 -2.5 Mabsadd L
.03239 .02381 -1.875 0 Mabsadd L closepath F
.03322 .02381 -1.875 0 Mabsadd m
.03322 .02381 0 2.5 Mabsadd L
.03322 .02381 1.875 0 Mabsadd L
.03322 .02381 0 -2.5 Mabsadd L
.03322 .02381 -1.875 0 Mabsadd L closepath F
.03404 .34127 -1.875 0 Mabsadd m
.03404 .34127 0 2.5 Mabsadd L
.03404 .34127 1.875 0 Mabsadd L
.03404 .34127 0 -2.5 Mabsadd L
.03404 .34127 -1.875 0 Mabsadd L closepath F
.03486 .34127 -1.875 0 Mabsadd m
.03486 .34127 0 2.5 Mabsadd L
.03486 .34127 1.875 0 Mabsadd L
.03486 .34127 0 -2.5 Mabsadd L
.03486 .34127 -1.875 0 Mabsadd L closepath F
.03569 .65873 -1.875 0 Mabsadd m
.03569 .65873 0 2.5 Mabsadd L
.03569 .65873 1.875 0 Mabsadd L
.03569 .65873 0 -2.5 Mabsadd L
.03569 .65873 -1.875 0 Mabsadd L closepath F
.03653 .65873 -1.875 0 Mabsadd m
.03653 .65873 0 2.5 Mabsadd L
.03653 .65873 1.875 0 Mabsadd L
.03653 .65873 0 -2.5 Mabsadd L
.03653 .65873 -1.875 0 Mabsadd L closepath F
.03736 .65873 -1.875 0 Mabsadd m
.03736 .65873 0 2.5 Mabsadd L
.03736 .65873 1.875 0 Mabsadd L
.03736 .65873 0 -2.5 Mabsadd L
.03736 .65873 -1.875 0 Mabsadd L closepath F
.0382 .65873 -1.875 0 Mabsadd m
.0382 .65873 0 2.5 Mabsadd L
.0382 .65873 1.875 0 Mabsadd L
.0382 .65873 0 -2.5 Mabsadd L
.0382 .65873 -1.875 0 Mabsadd L closepath F
.03903 .65873 -1.875 0 Mabsadd m
.03903 .65873 0 2.5 Mabsadd L
.03903 .65873 1.875 0 Mabsadd L
.03903 .65873 0 -2.5 Mabsadd L
.03903 .65873 -1.875 0 Mabsadd L closepath F
.03986 .65873 -1.875 0 Mabsadd m
.03986 .65873 0 2.5 Mabsadd L
.03986 .65873 1.875 0 Mabsadd L
.03986 .65873 0 -2.5 Mabsadd L
.03986 .65873 -1.875 0 Mabsadd L closepath F
.0407 .65873 -1.875 0 Mabsadd m
.0407 .65873 0 2.5 Mabsadd L
.0407 .65873 1.875 0 Mabsadd L
.0407 .65873 0 -2.5 Mabsadd L
.0407 .65873 -1.875 0 Mabsadd L closepath F
.04153 .65873 -1.875 0 Mabsadd m
.04153 .65873 0 2.5 Mabsadd L
.04153 .65873 1.875 0 Mabsadd L
.04153 .65873 0 -2.5 Mabsadd L
.04153 .65873 -1.875 0 Mabsadd L closepath F
.04591 .65873 -1.875 0 Mabsadd m
.04591 .65873 0 2.5 Mabsadd L
.04591 .65873 1.875 0 Mabsadd L
.04591 .65873 0 -2.5 Mabsadd L
.04591 .65873 -1.875 0 Mabsadd L closepath F
.05028 .65873 -1.875 0 Mabsadd m
.05028 .65873 0 2.5 Mabsadd L
.05028 .65873 1.875 0 Mabsadd L
.05028 .65873 0 -2.5 Mabsadd L
.05028 .65873 -1.875 0 Mabsadd L closepath F
.05466 .65873 -1.875 0 Mabsadd m
.05466 .65873 0 2.5 Mabsadd L
.05466 .65873 1.875 0 Mabsadd L
.05466 .65873 0 -2.5 Mabsadd L
.05466 .65873 -1.875 0 Mabsadd L closepath F
.06733 .34127 -1.875 0 Mabsadd m
.06733 .34127 0 2.5 Mabsadd L
.06733 .34127 1.875 0 Mabsadd L
.06733 .34127 0 -2.5 Mabsadd L
.06733 .34127 -1.875 0 Mabsadd L closepath F
.08001 .34127 -1.875 0 Mabsadd m
.08001 .34127 0 2.5 Mabsadd L
.08001 .34127 1.875 0 Mabsadd L
.08001 .34127 0 -2.5 Mabsadd L
.08001 .34127 -1.875 0 Mabsadd L closepath F
.09269 .34127 -1.875 0 Mabsadd m
.09269 .34127 0 2.5 Mabsadd L
.09269 .34127 1.875 0 Mabsadd L
.09269 .34127 0 -2.5 Mabsadd L
.09269 .34127 -1.875 0 Mabsadd L closepath F
.13196 .65873 -1.875 0 Mabsadd m
.13196 .65873 0 2.5 Mabsadd L
.13196 .65873 1.875 0 Mabsadd L
.13196 .65873 0 -2.5 Mabsadd L
.13196 .65873 -1.875 0 Mabsadd L closepath F
.17123 .34127 -1.875 0 Mabsadd m
.17123 .34127 0 2.5 Mabsadd L
.17123 .34127 1.875 0 Mabsadd L
.17123 .34127 0 -2.5 Mabsadd L
.17123 .34127 -1.875 0 Mabsadd L closepath F
.21051 .02381 -1.875 0 Mabsadd m
.21051 .02381 0 2.5 Mabsadd L
.21051 .02381 1.875 0 Mabsadd L
.21051 .02381 0 -2.5 Mabsadd L
.21051 .02381 -1.875 0 Mabsadd L closepath F
.24978 .34127 -1.875 0 Mabsadd m
.24978 .34127 0 2.5 Mabsadd L
.24978 .34127 1.875 0 Mabsadd L
.24978 .34127 0 -2.5 Mabsadd L
.24978 .34127 -1.875 0 Mabsadd L closepath F
.33312 .34127 -1.875 0 Mabsadd m
.33312 .34127 0 2.5 Mabsadd L
.33312 .34127 1.875 0 Mabsadd L
.33312 .34127 0 -2.5 Mabsadd L
.33312 .34127 -1.875 0 Mabsadd L closepath F
.41646 .34127 -1.875 0 Mabsadd m
.41646 .34127 0 2.5 Mabsadd L
.41646 .34127 1.875 0 Mabsadd L
.41646 .34127 0 -2.5 Mabsadd L
.41646 .34127 -1.875 0 Mabsadd L closepath F
.4998 .65873 -1.875 0 Mabsadd m
.4998 .65873 0 2.5 Mabsadd L
.4998 .65873 1.875 0 Mabsadd L
.4998 .65873 0 -2.5 Mabsadd L
.4998 .65873 -1.875 0 Mabsadd L closepath F
.58314 .65873 -1.875 0 Mabsadd m
.58314 .65873 0 2.5 Mabsadd L
.58314 .65873 1.875 0 Mabsadd L
.58314 .65873 0 -2.5 Mabsadd L
.58314 .65873 -1.875 0 Mabsadd L closepath F
.67838 .65873 -1.875 0 Mabsadd m
.67838 .65873 0 2.5 Mabsadd L
.67838 .65873 1.875 0 Mabsadd L
.67838 .65873 0 -2.5 Mabsadd L
.67838 .65873 -1.875 0 Mabsadd L closepath F
.77362 .65873 -1.875 0 Mabsadd m
.77362 .65873 0 2.5 Mabsadd L
.77362 .65873 1.875 0 Mabsadd L
.77362 .65873 0 -2.5 Mabsadd L
.77362 .65873 -1.875 0 Mabsadd L closepath F
.86885 .65873 -1.875 0 Mabsadd m
.86885 .65873 0 2.5 Mabsadd L
.86885 .65873 1.875 0 Mabsadd L
.86885 .65873 0 -2.5 Mabsadd L
.86885 .65873 -1.875 0 Mabsadd L closepath F
.92252 .97619 -1.875 0 Mabsadd m
.92252 .97619 0 2.5 Mabsadd L
.92252 .97619 1.875 0 Mabsadd L
.92252 .97619 0 -2.5 Mabsadd L
.92252 .97619 -1.875 0 Mabsadd L closepath F
.97619 .97619 -1.875 0 Mabsadd m
.97619 .97619 0 2.5 Mabsadd L
.97619 .97619 1.875 0 Mabsadd L
.97619 .97619 0 -2.5 Mabsadd L
.97619 .97619 -1.875 0 Mabsadd L closepath F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[100]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
>7oo0P006Woo0P0017oo00<007ooOol00goo0P000goo0`0057oo0P0017oo00<007ooOol00Woo1000
4Woo0P0017oo00<007ooOol00Woo10000Woo0`0057oo0P0017oo00<007ooOol00Woo10004goo0P00
17oo00<007ooOol00Woo10000Woo0`0057oo0P0017oo00<007ooOol00goo0P000goo000gOol01000
Oomoo`0067oo00@007ooOol000Qoo`04001oogoo0005Ool00`00Oomoo`0@Ool01000Oomoo`002Woo
00<007ooOol047oo00@007ooOol000Yoo`03001oogoo00Aoo`03001oogoo011oo`04001oogoo0008
Ool00`00Oomoo`0COol01000Oomoo`0027oo00<007ooOol01Woo00<007ooOol047oo00@007ooOol0
00Qoo`04001oogoo0002Ool003Moo`04001oogoo000HOol01000Oomoo`0027oo00@007ooOol000Eo
o`03001oogoo011oo`04001oogoo000:Ool00`00Oomoo`0@Ool01000Oomoo`002Woo00<007ooOol0
17oo00<007ooOol047oo00@007ooOol000Uoo`03001oogoo019oo`04001oogoo0009Ool00`00Oomo
o`05Ool00`00Oomoo`0@Ool01000Oomoo`002goo0@000Goo0Goo000gOol01000Oomoo`0067oo00@0
07ooOol000Qoo`04001oogoo0002Ool3000COol01000Oomoo`002Woo00<007ooOol047oo00@007oo
Ool000Yoo`04001oogooOol3000COol01000Oomoo`002Woo00<007ooOol04Goo00@007ooOol000Yo
o`04001oogooOol3000COol01000Oomoo`002Goo0P000goo000gOol01000Oomoo`0067oo00@007oo
Ool000Qoo`04001oogoo0002Ool00`00Oomoo`0COol01000Oomoo`002Woo00<007ooOol047oo00@0
07ooOol000Yoo`05001oogooOol0000EOol01000Oomoo`002goo00<007ooOol047oo00@007ooOol0
00]oo`04001oogoo000EOol01000Oomoo`002goo0@000Goo0Goo000gOol01000Oomoo`0067oo00@0
07ooOol000Qoo`04001oogoo0002Ool00`00Oomoo`0COol01000Oomoo`0027oo0`004Woo00@007oo
Ool000Qoo`<000=oo`03001oogoo01=oo`04001oogoo0008Ool01000Oomoo`004Woo00@007ooOol0
00Qoo`04001oogoo0002Ool00`00Oomoo`0COol01000Oomoo`0027oo00@007ooOol0009oo`00>7oo
0P006Woo0P002Woo0P000goo10004goo0P002goo00<007ooOol04Goo0P002goo00@007ooOomoo`@0
01=oo`8000Yoo`8001Aoo`8000Yoo`8000=oo`@001=oo`8000Yoo`8000=oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00=7ooj00017oo000dOol00`00Oomoo`02Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool003Aoo`03001oogoo009oo`03001oogoo029oo`03001oogoo029oo`03001oogoo025oo`03001o
ogoo029oo`03001oogoo029oo`03001oogoo029oo`03001oogoo009oo`03001oogoo009oo`00=7oo
00<007ooOol0i7oo00<007ooOol00Woo000]Ool20005Ool00`00Oomoo`02Ool4000XOol00`00Oomo
o`2cOol00`00Oomoo`02Ool002aoo`04001oogoo0004Ool00`00Oomoo`02Ool4000WOol2002eOol0
0`00Oomoo`02Ool002aoo`04001oogoo0004Ool20002Ool5000VOol3002dOol20004Ool002aoo`04
001oogoo0004Ool00`00Oomoo`02Ool4000WOol2002eOol00`00Oomoo`02Ool002aoo`04001oogoo
0004Ool00`00Oomoo`3TOol00`00Oomoo`02Ool002aoo`04001oogoo0004Ool00`00Oomoo`3TOol0
0`00Oomoo`02Ool002eoo`8000Eoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0
i7oo00<007ooOol00Woo000dOol2003TOol20004Ool003Aoo`03001oogoo0>Aoo`03001oogoo009o
o`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool0
03Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000d
Ool00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`800>Aoo`8000Aoo`00=7oo00<007ooOol0i7oo
00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03
001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00
Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo0P00i7oo0P0017oo000dOol0
0`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<0
07ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001o
ogoo0>Aoo`03001oogoo009oo`00=7oo0P00i7oo0P0017oo000dOol00`00Oomoo`3TOol00`00Oomo
o`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol0
0Woo000=Ool30003Ool01@00Oomoogoo00001Woo10000goo0P003Goo00<007ooOol0i7oo00<007oo
Ool00Woo000@Ool01`00Oomoogoo001oo`0000Uoo`05001oogooOol00002Ool00`00Oomoo`0:Ool0
0`00Oomoo`3TOol00`00Oomoo`02Ool0011oo`03001oogoo009oo`03001oogoo00Qoo`05001oogoo
Ool00002Ool00`00Oomoo`0:Ool00`00Oomoo`3TOol00`00Oomoo`02Ool000eoo`<000Aoo`03001o
o`0000Uoo`05001oogooOol00002Ool00`00Oomoo`0:Ool2003TOol20004Ool000eoo`03001oogoo
00=oo`05001oogooOol00008Ool01@00Oomoogoo00000Woo00<007ooOol02Woo00<007ooOol0i7oo
00<007ooOol00Woo000=Ool00`00Oomoo`0>Ool30003Ool01000Oomoo`001goo0`000Woo0P00iGoo
00<007ooOol00Woo000=Ool4000?Ool00`00Oomoo`02Ool20009Ool01000Oomoogoo0P00iGoo00<0
07ooOol00Woo000ZOol30003Ool01000Oomoogoo0P00iGoo00<007ooOol00Woo000`Ool01`00Oomo
ogoo001oo`000>Aoo`03001oogoo009oo`00;goo0P000goo00<007oo0000i7oo00<007ooOol00Woo
000`Ool01000Oomoogoo0`00hgoo0P0017oo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Ao
o`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol0
0`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo0P00
i7oo0P0017oo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001o
ogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomo
o`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol0
0Woo000dOol2003TOol20004Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007oo
Ool0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo
0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol2003TOol20004
Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo
000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool000eoo`@0009oo`05001oogooOol00006Ool40003
Ool2000=Ool00`00Oomoo`3TOol00`00Oomoo`02Ool000moo`03001oogoo009oo`03001oo`0000Uo
o`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3TOol00`00Oomoo`02Ool000moo`03
001oogoo00=oo`03001oogoo00Qoo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3T
Ool00`00Oomoo`02Ool000moo`03001oogoo009oo`03001oo`0000Uoo`05001oogooOol00002Ool0
0`00Oomoo`0:Ool2003TOol20004Ool000moo`05001oogooOol00003Ool00`00Oomoo`06Ool01@00
Oomoogoo00000Woo00<007ooOol02Woo00<007ooOol0i7oo00<007ooOol00Woo000=Ool3000>Ool3
0003Ool01000Oomoo`001goo0`000Woo0P00iGoo00<007ooOol00Woo000?Ool00`00Oomoo`0>Ool0
0`00Oomoo`02Ool20009Ool01`00Oomoogoo001oo`000>Aoo`03001oogoo009oo`00:Woo0`000goo
00@007ooOomoo`<00>Aoo`03001oogoo009oo`00<7oo00D007ooOomoo`000>Ioo`03001oogoo009o
o`00;goo0P000goo00<007ooOol00Woo10001Woo00D007ooOol007oo0080015oo`03001oogoo00mo
o`80015oo`80015oo`8008Ioo`03001oogoo009oo`00<7oo00@007ooOomoo`<00003Ool0000000@0
00Aoo`T000moo`<000moo`<0011oo`@000moo`@008Aoo`8000Aoo`00=7oo00<007ooOol00Woo1@00
1Goo0P0000=oo`0000000`0047oo0P0047oo0P004Goo0`0047oo0`00QGoo00<007ooOol00Woo000d
Ool00`00Oomoo`02Ool200000goo001oo`05Ool01000Oomoo`000Woo00<007ooOol03goo00<007oo
Ool047oo00<007ooOol047oo00<007ooOol047oo00<007ooOol0Q7oo00<007ooOol00Woo000dOol0
0`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<0
07ooOol0i7oo00<007ooOol00Woo000dOol2003TOol20004Ool003Aoo`03001oogoo0>Aoo`03001o
ogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomo
o`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol0
0Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`800>Aoo`8000Aoo`00=7oo00<007oo
Ool0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo
0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3T
Ool00`00Oomoo`02Ool003Aoo`800>Aoo`8000Aoo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo
000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00
00=oo`0000000P000goo00<007ooOol00Woo0`000goo00D007ooOomoo`0000Ioo`@000=oo`8000eo
o`03001oogoo0>Aoo`03001oogoo009oo`000goo00<007ooOol02Woo00L007ooOomoo`00Ool00009
Ool01@00Oomoogoo00000Woo00<007ooOol02Woo00<007ooOol0i7oo00<007ooOol00Woo0003Ool0
0`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00000Woo00<007ooOol0
2Woo00<007ooOol0i7oo00<007ooOol00Woo0003Ool00`00Oomoo`07Ool30004Ool00`00Ool00009
Ool01@00Oomoogoo00000Woo00<007ooOol02Woo0P00i7oo0P0017oo0003Ool00`00Oomoo`07Ool0
0`00Oomoo`03Ool01@00Oomoogoo000027oo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001o
ogoo0>Aoo`03001oogoo009oo`0000Aoo`00000000Uoo`03001oogoo00ioo`<000=oo`04001oogoo
0007Ool30002Ool2003UOol00`00Oomoo`02Ool000=oo`03001oogoo00Moo`@000moo`03001oogoo
009oo`8000Uoo`07001oogooOol007oo0000i7oo00<007ooOol00Woo000ZOol30003Ool01000Oomo
ogoo0`00i7oo00<007ooOol00Woo000`Ool01@00Oomoogoo0000iWoo00<007ooOol00Woo000_Ool2
0003Ool00`00Oomoo`3TOol00`00Oomoo`02Ool0031oo`04001oogooOol3003SOol20004Ool003Ao
o`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol0
0`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<0
07ooOol0i7oo00<007ooOol00Woo000dOol2003TOol20004Ool003Aoo`03001oogoo0>Aoo`03001o
ogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomo
o`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol0
0Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`800>Aoo`8000Aoo`00=7oo00<007oo
Ool0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo
0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3T
Ool00`00Oomoo`02Ool003Aoo`800>Aoo`8000Aoo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo
000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00
3Goo10000Woo00D007ooOomoo`0000Ioo`@000=oo`8000eoo`03001oogoo0>Aoo`03001oogoo009o
o`003Goo00<007ooOol017oo00<007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`03
001oogoo0>Aoo`03001oogoo009oo`003Woo00<007ooOol017oo00<007ooOol027oo00D007ooOomo
o`00009oo`03001oogoo00Yoo`03001oogoo0>Aoo`03001oogoo009oo`003goo00<007ooOol00Woo
00<007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`800>Aoo`8000Aoo`0047oo00@0
07ooOol000=oo`03001oogoo00Ioo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3T
Ool00`00Oomoo`02Ool000eoo`04001oogoo000=Ool30003Ool01000Oomoo`001goo0`000Woo0P00
iGoo00<007ooOol00Woo000>Ool2000@Ool00`00Oomoo`02Ool20009Ool01`00Oomoogoo001oo`00
0>Aoo`03001oogoo009oo`00:Woo0`000goo00@007ooOomoo`<00>Aoo`03001oogoo009oo`00<7oo
00D007ooOomoo`000>Ioo`03001oogoo009oo`00;goo0P000goo00<007ooOol0i7oo00<007ooOol0
0Woo000`Ool01000Oomoogoo0`00hgoo0P0017oo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool0
03Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000d
Ool00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo
0P001Woo0P0000Aoo`000000011oo`03001oogoo059oo`03001oogoo015oo`03001oogoo01=oo`03
001oogoo01=oo`03001oogoo01=oo`03001oogoo01Yoo`8000Aoo`00=7oo00<007ooOol017oo1`00
47oo0P00Dgoo0P004Goo0`004goo0`004goo0`004goo0`0077oo00<007ooOol00Woo000dOol00`00
Oomoo`03Ool8000?Ool3001BOol3000@Ool4000BOol4000BOol4000BOol4000LOol00`00Oomoo`02
Ool003Aoo`03001oogoo00Aoo`L0011oo`03001oogoo059oo`03001oogoo011oo`8001Aoo`8001Ao
o`8001Aoo`8001eoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol0
0`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo0P00
i7oo0P0017oo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001o
ogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomo
o`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo0P00i7oo0P0017oo000dOol00`00
Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007oo
Ool0i7oo00<007ooOol00Woo00000goo000000020003Ool00`00Oomoo`02Ool30003Ool01@00Oomo
ogoo00001Woo10000goo0P003Goo00<007ooOol0i7oo00<007ooOol00Woo00000goo001oo`0=Ool0
1`00Oomoogoo001oo`0000Uoo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3TOol0
0`00Oomoo`02Ool0009oo`03001oogoo00]oo`03001oogoo009oo`03001oogoo00Qoo`05001oogoo
Ool00002Ool00`00Oomoo`0:Ool00`00Oomoo`3TOol00`00Oomoo`02Ool000=oo`03001oogoo00Mo
o`<000Aoo`03001oo`0000Uoo`05001oogooOol00002Ool00`00Oomoo`0:Ool2003TOol20004Ool0
00Aoo`03001oogoo00Ioo`03001oogoo00=oo`05001oogooOol00008Ool01@00Oomoogoo00000Woo
00<007ooOol02Woo00<007ooOol0i7oo00<007ooOol00Woo00001Goo001oogoo000027oo00<007oo
Ool03Woo0`000goo00@007ooOol000Moo`<0009oo`800>Eoo`03001oogoo009oo`000Woo0P002Goo
10003goo00<007ooOol00Woo0P002Goo00L007ooOomoo`00Ool0003TOol00`00Oomoo`02Ool002Yo
o`<000=oo`04001oogooOol3003TOol00`00Oomoo`02Ool0031oo`05001oogooOol0003VOol00`00
Oomoo`02Ool002moo`8000=oo`03001oogoo0>Aoo`03001oogoo009oo`00<7oo00@007ooOomoo`<0
0>=oo`8000Aoo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00
Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007oo
Ool00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`800>Aoo`8000Aoo`00=7oo00<0
07ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001o
ogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomo
o`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo0P00i7oo0P00
17oo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009o
o`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool0
03Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000d
Ool2003TOol20004Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo
00<007ooOol00Woo000>Ool20003Ool01@00Oomoogoo00001Woo10000goo0P003Goo00<007ooOol0
i7oo00<007ooOol00Woo000=Ool01000Oomoo`000goo00<007oo00002Goo00D007ooOomoo`00009o
o`03001oogoo00Yoo`03001oogoo0>Aoo`03001oogoo009oo`0047oo00<007ooOol00Woo00<007oo
Ool027oo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo0>Aoo`03001oogoo009oo`00
3Woo0P0017oo00<007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`800>Aoo`8000Ao
o`0047oo00@007ooOol000=oo`03001oogoo00Ioo`05001oogooOol00002Ool00`00Oomoo`0:Ool0
0`00Oomoo`3TOol00`00Oomoo`02Ool000eoo`04001oogoo000=Ool30003Ool01000Oomoo`001goo
0`000Woo0P00iGoo00<007ooOol00Woo000>Ool2000@Ool00`00Oomoo`02Ool20009Ool01`00Oomo
ogoo001oo`000>Aoo`03001oogoo009oo`00:Woo0`000goo00@007ooOomoo`<00>Aoo`03001oogoo
009oo`00<7oo00D007ooOomoo`000>Ioo`03001oogoo009oo`00;goo0P000goo00<007ooOol0i7oo
00<007ooOol00Woo000`Ool01000Oomoogoo0`00hgoo0P0017oo000dOol00`00Oomoo`3TOol00`00
Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007oo
Ool00Woo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo
009oo`00=7oo0P00i7oo0P0017oo000dOol00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001o
ogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0i7oo00<007ooOol00Woo000dOol00`00Oomo
o`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo00<007ooOol0
i7oo00<007ooOol00Woo000dOol2003COol00`00Oomoo`0:Ool01000Oomoogoo0P0017oo000dOol0
0`00Oomoo`3AOol3000:Ool20004Ool00`00Oomoo`02Ool003Aoo`03001oogoo0=1oo`@000Uoo`<0
00Aoo`03001oogoo009oo`00=7oo00<007ooOol0dGoo0P002goo0P0017oo00<007ooOol00Woo000d
Ool00`00Oomoo`3TOol00`00Oomoo`02Ool003Aoo`03001oogoo0>Aoo`03001oogoo009oo`00=7oo
00<007ooOol00Woo00<007ooOol08Woo00<007ooOol08Woo00<007ooOol08Goo00<007ooOol08Woo
00<007ooOol08Woo00<007ooOol08Woo00<007ooOol00Woo00<007ooOol00Woo000dOooX0004Ool0
0?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo
8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol0
0?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {495.438, 136.688}} -> {-0.18096, \
1.059*^-16, 0.00136298, 1.51321*^-18}}]
}, Open  ]],

Cell[TextData[{
  "Therefore in this example there is no need to use the method ",
  StyleBox["Projection", "MR"],
  "."
}], "Text"],

Cell[TextData[{
  "Certain numerical methods preserve quadratic invariants exactly (see for \
example [",
  ButtonBox["C87",
    ButtonData:>{"References.nb", "C87"},
    ButtonStyle->"Hyperlink"],
  "]). The implicit midpoint rule, or one-stage Gauss implicit Runge-Kutta \
method, is one such method."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Harmonic oscillator", "Subsection"],

Cell["Define the Harmonic oscillator.", "Text"],

Cell[BoxData[{
    \(\(system\  = \ 
        GetNDSolveProblem["\<HarmonicOscillator\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(vars\  = \ system["\<DependentVariables\>"[]];\)\)}], "Input",
  CellLabel->"In[102]:="],

Cell["The Harmonic oscillator has the following invariant.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(invariant\  = \ system["\<Invariants\>"[]]\)], "Input",
  CellLabel->"In[104]:="],

Cell[BoxData[
    \({1\/2\ \((Y\_1[T]\^2 + Y\_2[T]\^2)\)}\)], "Output",
  CellLabel->"Out[104]="]
}, Open  ]],

Cell[TextData[{
  "Solve the system using the method ",
  StyleBox["ExplicitRungeKutta", "MR"],
  ". The error in the invariant grows roughly linearly which is typical \
behavior for a dissipative method applied to a Hamiltonian system."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(erksol\  = \ 
        NDSolve[system, \ 
          Method \[Rule] ExplicitRungeKutta];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(InvariantErrorPlot[invariant, vars, T, erksol];\)\)}], "Input",
  CellLabel->"In[105]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0238095 8.22847e+08 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .18838 -37.5 -6.25 ]
[-0.0125 .18838 0 6.25 ]
[-0.0125 .35295 -37.5 -6.25 ]
[-0.0125 .35295 0 6.25 ]
[-0.0125 .51752 -37.5 -6.25 ]
[-0.0125 .51752 0 6.25 ]
[-0.0125 .68209 -37.5 -6.25 ]
[-0.0125 .68209 0 6.25 ]
[-0.0125 .84666 -33 -6.25 ]
[-0.0125 .84666 0 6.25 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .18838 m
.00625 .18838 L
s
gsave
-0.0125 .18838 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-10) show
grestore
0 .35295 m
.00625 .35295 L
s
gsave
-0.0125 .35295 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-10) show
grestore
0 .51752 m
.00625 .51752 L
s
gsave
-0.0125 .51752 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(6) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-10) show
grestore
0 .68209 m
.00625 .68209 L
s
gsave
-0.0125 .68209 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(8) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-10) show
grestore
0 .84666 m
.00625 .84666 L
s
gsave
-0.0125 .84666 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-9) show
grestore
.125 Mabswid
0 .06495 m
.00375 .06495 L
s
0 .10609 m
.00375 .10609 L
s
0 .14724 m
.00375 .14724 L
s
0 .22952 m
.00375 .22952 L
s
0 .27066 m
.00375 .27066 L
s
0 .31181 m
.00375 .31181 L
s
0 .39409 m
.00375 .39409 L
s
0 .43523 m
.00375 .43523 L
s
0 .47638 m
.00375 .47638 L
s
0 .55866 m
.00375 .55866 L
s
0 .5998 m
.00375 .5998 L
s
0 .64094 m
.00375 .64094 L
s
0 .72323 m
.00375 .72323 L
s
0 .76437 m
.00375 .76437 L
s
0 .80551 m
.00375 .80551 L
s
0 .8878 m
.00375 .8878 L
s
0 .92894 m
.00375 .92894 L
s
0 .97008 m
.00375 .97008 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.21429 .99375 m
.21429 1 L
s
.40476 .99375 m
.40476 1 L
s
.59524 .99375 m
.59524 1 L
s
.78571 .99375 m
.78571 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.07143 .99625 m
.07143 1 L
s
.11905 .99625 m
.11905 1 L
s
.16667 .99625 m
.16667 1 L
s
.2619 .99625 m
.2619 1 L
s
.30952 .99625 m
.30952 1 L
s
.35714 .99625 m
.35714 1 L
s
.45238 .99625 m
.45238 1 L
s
.5 .99625 m
.5 1 L
s
.54762 .99625 m
.54762 1 L
s
.64286 .99625 m
.64286 1 L
s
.69048 .99625 m
.69048 1 L
s
.7381 .99625 m
.7381 1 L
s
.83333 .99625 m
.83333 1 L
s
.88095 .99625 m
.88095 1 L
s
.92857 .99625 m
.92857 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .18838 m
1 .18838 L
s
.99375 .35295 m
1 .35295 L
s
.99375 .51752 m
1 .51752 L
s
.99375 .68209 m
1 .68209 L
s
.99375 .84666 m
1 .84666 L
s
.125 Mabswid
.99625 .06495 m
1 .06495 L
s
.99625 .10609 m
1 .10609 L
s
.99625 .14724 m
1 .14724 L
s
.99625 .22952 m
1 .22952 L
s
.99625 .27066 m
1 .27066 L
s
.99625 .31181 m
1 .31181 L
s
.99625 .39409 m
1 .39409 L
s
.99625 .43523 m
1 .43523 L
s
.99625 .47638 m
1 .47638 L
s
.99625 .55866 m
1 .55866 L
s
.99625 .5998 m
1 .5998 L
s
.99625 .64094 m
1 .64094 L
s
.99625 .72323 m
1 .72323 L
s
.99625 .76437 m
1 .76437 L
s
.99625 .80551 m
1 .80551 L
s
.99625 .8878 m
1 .8878 L
s
.99625 .92894 m
1 .92894 L
s
.99625 .97008 m
1 .97008 L
s
.25 Mabswid
1 0 m
1 1 L
s
.0001 w
.02381 .02381 -1.875 0 Mabsadd m
.02381 .02381 0 2.5 Mabsadd L
.02381 .02381 1.875 0 Mabsadd L
.02381 .02381 0 -2.5 Mabsadd L
.02381 .02381 -1.875 0 Mabsadd L closepath F
.0345 .02414 -1.875 0 Mabsadd m
.0345 .02414 0 2.5 Mabsadd L
.0345 .02414 1.875 0 Mabsadd L
.0345 .02414 0 -2.5 Mabsadd L
.0345 .02414 -1.875 0 Mabsadd L closepath F
.04467 .02437 -1.875 0 Mabsadd m
.04467 .02437 0 2.5 Mabsadd L
.04467 .02437 1.875 0 Mabsadd L
.04467 .02437 0 -2.5 Mabsadd L
.04467 .02437 -1.875 0 Mabsadd L closepath F
.05691 .02535 -1.875 0 Mabsadd m
.05691 .02535 0 2.5 Mabsadd L
.05691 .02535 1.875 0 Mabsadd L
.05691 .02535 0 -2.5 Mabsadd L
.05691 .02535 -1.875 0 Mabsadd L closepath F
.06967 .02672 -1.875 0 Mabsadd m
.06967 .02672 0 2.5 Mabsadd L
.06967 .02672 1.875 0 Mabsadd L
.06967 .02672 0 -2.5 Mabsadd L
.06967 .02672 -1.875 0 Mabsadd L closepath F
.08367 .02958 -1.875 0 Mabsadd m
.08367 .02958 0 2.5 Mabsadd L
.08367 .02958 1.875 0 Mabsadd L
.08367 .02958 0 -2.5 Mabsadd L
.08367 .02958 -1.875 0 Mabsadd L closepath F
.0984 .03388 -1.875 0 Mabsadd m
.0984 .03388 0 2.5 Mabsadd L
.0984 .03388 1.875 0 Mabsadd L
.0984 .03388 0 -2.5 Mabsadd L
.0984 .03388 -1.875 0 Mabsadd L closepath F
.11406 .04086 -1.875 0 Mabsadd m
.11406 .04086 0 2.5 Mabsadd L
.11406 .04086 1.875 0 Mabsadd L
.11406 .04086 0 -2.5 Mabsadd L
.11406 .04086 -1.875 0 Mabsadd L closepath F
.13044 .05085 -1.875 0 Mabsadd m
.13044 .05085 0 2.5 Mabsadd L
.13044 .05085 1.875 0 Mabsadd L
.13044 .05085 0 -2.5 Mabsadd L
.13044 .05085 -1.875 0 Mabsadd L closepath F
.14693 .06141 -1.875 0 Mabsadd m
.14693 .06141 0 2.5 Mabsadd L
.14693 .06141 1.875 0 Mabsadd L
.14693 .06141 0 -2.5 Mabsadd L
.14693 .06141 -1.875 0 Mabsadd L closepath F
.16362 .07305 -1.875 0 Mabsadd m
.16362 .07305 0 2.5 Mabsadd L
.16362 .07305 1.875 0 Mabsadd L
.16362 .07305 0 -2.5 Mabsadd L
.16362 .07305 -1.875 0 Mabsadd L closepath F
.18031 .08463 -1.875 0 Mabsadd m
.18031 .08463 0 2.5 Mabsadd L
.18031 .08463 1.875 0 Mabsadd L
.18031 .08463 0 -2.5 Mabsadd L
.18031 .08463 -1.875 0 Mabsadd L closepath F
.19695 .09597 -1.875 0 Mabsadd m
.19695 .09597 0 2.5 Mabsadd L
.19695 .09597 1.875 0 Mabsadd L
.19695 .09597 0 -2.5 Mabsadd L
.19695 .09597 -1.875 0 Mabsadd L closepath F
.21394 .10936 -1.875 0 Mabsadd m
.21394 .10936 0 2.5 Mabsadd L
.21394 .10936 1.875 0 Mabsadd L
.21394 .10936 0 -2.5 Mabsadd L
.21394 .10936 -1.875 0 Mabsadd L closepath F
.23117 .1243 -1.875 0 Mabsadd m
.23117 .1243 0 2.5 Mabsadd L
.23117 .1243 1.875 0 Mabsadd L
.23117 .1243 0 -2.5 Mabsadd L
.23117 .1243 -1.875 0 Mabsadd L closepath F
.24875 .14187 -1.875 0 Mabsadd m
.24875 .14187 0 2.5 Mabsadd L
.24875 .14187 1.875 0 Mabsadd L
.24875 .14187 0 -2.5 Mabsadd L
.24875 .14187 -1.875 0 Mabsadd L closepath F
.2667 .1626 -1.875 0 Mabsadd m
.2667 .1626 0 2.5 Mabsadd L
.2667 .1626 1.875 0 Mabsadd L
.2667 .1626 0 -2.5 Mabsadd L
.2667 .1626 -1.875 0 Mabsadd L closepath F
.28501 .18687 -1.875 0 Mabsadd m
.28501 .18687 0 2.5 Mabsadd L
.28501 .18687 1.875 0 Mabsadd L
.28501 .18687 0 -2.5 Mabsadd L
.28501 .18687 -1.875 0 Mabsadd L closepath F
.30296 .20761 -1.875 0 Mabsadd m
.30296 .20761 0 2.5 Mabsadd L
.30296 .20761 1.875 0 Mabsadd L
.30296 .20761 0 -2.5 Mabsadd L
.30296 .20761 -1.875 0 Mabsadd L closepath F
.3208 .22738 -1.875 0 Mabsadd m
.3208 .22738 0 2.5 Mabsadd L
.3208 .22738 1.875 0 Mabsadd L
.3208 .22738 0 -2.5 Mabsadd L
.3208 .22738 -1.875 0 Mabsadd L closepath F
.33834 .24464 -1.875 0 Mabsadd m
.33834 .24464 0 2.5 Mabsadd L
.33834 .24464 1.875 0 Mabsadd L
.33834 .24464 0 -2.5 Mabsadd L
.33834 .24464 -1.875 0 Mabsadd L closepath F
.35584 .26154 -1.875 0 Mabsadd m
.35584 .26154 0 2.5 Mabsadd L
.35584 .26154 1.875 0 Mabsadd L
.35584 .26154 0 -2.5 Mabsadd L
.35584 .26154 -1.875 0 Mabsadd L closepath F
.37354 .28004 -1.875 0 Mabsadd m
.37354 .28004 0 2.5 Mabsadd L
.37354 .28004 1.875 0 Mabsadd L
.37354 .28004 0 -2.5 Mabsadd L
.37354 .28004 -1.875 0 Mabsadd L closepath F
.39141 .30007 -1.875 0 Mabsadd m
.39141 .30007 0 2.5 Mabsadd L
.39141 .30007 1.875 0 Mabsadd L
.39141 .30007 0 -2.5 Mabsadd L
.39141 .30007 -1.875 0 Mabsadd L closepath F
.40958 .32287 -1.875 0 Mabsadd m
.40958 .32287 0 2.5 Mabsadd L
.40958 .32287 1.875 0 Mabsadd L
.40958 .32287 0 -2.5 Mabsadd L
.40958 .32287 -1.875 0 Mabsadd L closepath F
.4281 .34947 -1.875 0 Mabsadd m
.4281 .34947 0 2.5 Mabsadd L
.4281 .34947 1.875 0 Mabsadd L
.4281 .34947 0 -2.5 Mabsadd L
.4281 .34947 -1.875 0 Mabsadd L closepath F
.44639 .37358 -1.875 0 Mabsadd m
.44639 .37358 0 2.5 Mabsadd L
.44639 .37358 1.875 0 Mabsadd L
.44639 .37358 0 -2.5 Mabsadd L
.44639 .37358 -1.875 0 Mabsadd L closepath F
.46447 .39548 -1.875 0 Mabsadd m
.46447 .39548 0 2.5 Mabsadd L
.46447 .39548 1.875 0 Mabsadd L
.46447 .39548 0 -2.5 Mabsadd L
.46447 .39548 -1.875 0 Mabsadd L closepath F
.48226 .41474 -1.875 0 Mabsadd m
.48226 .41474 0 2.5 Mabsadd L
.48226 .41474 1.875 0 Mabsadd L
.48226 .41474 0 -2.5 Mabsadd L
.48226 .41474 -1.875 0 Mabsadd L closepath F
.49976 .43172 -1.875 0 Mabsadd m
.49976 .43172 0 2.5 Mabsadd L
.49976 .43172 1.875 0 Mabsadd L
.49976 .43172 0 -2.5 Mabsadd L
.49976 .43172 -1.875 0 Mabsadd L closepath F
.51752 .45074 -1.875 0 Mabsadd m
.51752 .45074 0 2.5 Mabsadd L
.51752 .45074 1.875 0 Mabsadd L
.51752 .45074 0 -2.5 Mabsadd L
.51752 .45074 -1.875 0 Mabsadd L closepath F
.53537 .47058 -1.875 0 Mabsadd m
.53537 .47058 0 2.5 Mabsadd L
.53537 .47058 1.875 0 Mabsadd L
.53537 .47058 0 -2.5 Mabsadd L
.53537 .47058 -1.875 0 Mabsadd L closepath F
.5535 .49305 -1.875 0 Mabsadd m
.5535 .49305 0 2.5 Mabsadd L
.5535 .49305 1.875 0 Mabsadd L
.5535 .49305 0 -2.5 Mabsadd L
.5535 .49305 -1.875 0 Mabsadd L closepath F
.57194 .51869 -1.875 0 Mabsadd m
.57194 .51869 0 2.5 Mabsadd L
.57194 .51869 1.875 0 Mabsadd L
.57194 .51869 0 -2.5 Mabsadd L
.57194 .51869 -1.875 0 Mabsadd L closepath F
.59042 .54474 -1.875 0 Mabsadd m
.59042 .54474 0 2.5 Mabsadd L
.59042 .54474 1.875 0 Mabsadd L
.59042 .54474 0 -2.5 Mabsadd L
.59042 .54474 -1.875 0 Mabsadd L closepath F
.60856 .56727 -1.875 0 Mabsadd m
.60856 .56727 0 2.5 Mabsadd L
.60856 .56727 1.875 0 Mabsadd L
.60856 .56727 0 -2.5 Mabsadd L
.60856 .56727 -1.875 0 Mabsadd L closepath F
.62647 .58767 -1.875 0 Mabsadd m
.62647 .58767 0 2.5 Mabsadd L
.62647 .58767 1.875 0 Mabsadd L
.62647 .58767 0 -2.5 Mabsadd L
.62647 .58767 -1.875 0 Mabsadd L closepath F
.64405 .60527 -1.875 0 Mabsadd m
.64405 .60527 0 2.5 Mabsadd L
.64405 .60527 1.875 0 Mabsadd L
.64405 .60527 0 -2.5 Mabsadd L
.64405 .60527 -1.875 0 Mabsadd L closepath F
.66176 .62384 -1.875 0 Mabsadd m
.66176 .62384 0 2.5 Mabsadd L
.66176 .62384 1.875 0 Mabsadd L
.66176 .62384 0 -2.5 Mabsadd L
.66176 .62384 -1.875 0 Mabsadd L closepath F
.67959 .64347 -1.875 0 Mabsadd m
.67959 .64347 0 2.5 Mabsadd L
.67959 .64347 1.875 0 Mabsadd L
.67959 .64347 0 -2.5 Mabsadd L
.67959 .64347 -1.875 0 Mabsadd L closepath F
.69764 .66519 -1.875 0 Mabsadd m
.69764 .66519 0 2.5 Mabsadd L
.69764 .66519 1.875 0 Mabsadd L
.69764 .66519 0 -2.5 Mabsadd L
.69764 .66519 -1.875 0 Mabsadd L closepath F
.71599 .68984 -1.875 0 Mabsadd m
.71599 .68984 0 2.5 Mabsadd L
.71599 .68984 1.875 0 Mabsadd L
.71599 .68984 0 -2.5 Mabsadd L
.71599 .68984 -1.875 0 Mabsadd L closepath F
.73462 .71768 -1.875 0 Mabsadd m
.73462 .71768 0 2.5 Mabsadd L
.73462 .71768 1.875 0 Mabsadd L
.73462 .71768 0 -2.5 Mabsadd L
.73462 .71768 -1.875 0 Mabsadd L closepath F
.75281 .74075 -1.875 0 Mabsadd m
.75281 .74075 0 2.5 Mabsadd L
.75281 .74075 1.875 0 Mabsadd L
.75281 .74075 0 -2.5 Mabsadd L
.75281 .74075 -1.875 0 Mabsadd L closepath F
.77084 .76221 -1.875 0 Mabsadd m
.77084 .76221 0 2.5 Mabsadd L
.77084 .76221 1.875 0 Mabsadd L
.77084 .76221 0 -2.5 Mabsadd L
.77084 .76221 -1.875 0 Mabsadd L closepath F
.78852 .78057 -1.875 0 Mabsadd m
.78852 .78057 0 2.5 Mabsadd L
.78852 .78057 1.875 0 Mabsadd L
.78852 .78057 0 -2.5 Mabsadd L
.78852 .78057 -1.875 0 Mabsadd L closepath F
.80616 .79863 -1.875 0 Mabsadd m
.80616 .79863 0 2.5 Mabsadd L
.80616 .79863 1.875 0 Mabsadd L
.80616 .79863 0 -2.5 Mabsadd L
.80616 .79863 -1.875 0 Mabsadd L closepath F
.82397 .81808 -1.875 0 Mabsadd m
.82397 .81808 0 2.5 Mabsadd L
.82397 .81808 1.875 0 Mabsadd L
.82397 .81808 0 -2.5 Mabsadd L
.82397 .81808 -1.875 0 Mabsadd L closepath F
.84195 .83909 -1.875 0 Mabsadd m
.84195 .83909 0 2.5 Mabsadd L
.84195 .83909 1.875 0 Mabsadd L
.84195 .83909 0 -2.5 Mabsadd L
.84195 .83909 -1.875 0 Mabsadd L closepath F
.86021 .86286 -1.875 0 Mabsadd m
.86021 .86286 0 2.5 Mabsadd L
.86021 .86286 1.875 0 Mabsadd L
.86021 .86286 0 -2.5 Mabsadd L
.86021 .86286 -1.875 0 Mabsadd L closepath F
.87883 .89057 -1.875 0 Mabsadd m
.87883 .89057 0 2.5 Mabsadd L
.87883 .89057 1.875 0 Mabsadd L
.87883 .89057 0 -2.5 Mabsadd L
.87883 .89057 -1.875 0 Mabsadd L closepath F
.89713 .91466 -1.875 0 Mabsadd m
.89713 .91466 0 2.5 Mabsadd L
.89713 .91466 1.875 0 Mabsadd L
.89713 .91466 0 -2.5 Mabsadd L
.89713 .91466 -1.875 0 Mabsadd L closepath F
.91522 .93676 -1.875 0 Mabsadd m
.91522 .93676 0 2.5 Mabsadd L
.91522 .93676 1.875 0 Mabsadd L
.91522 .93676 0 -2.5 Mabsadd L
.91522 .93676 -1.875 0 Mabsadd L closepath F
.933 .95595 -1.875 0 Mabsadd m
.933 .95595 0 2.5 Mabsadd L
.933 .95595 1.875 0 Mabsadd L
.933 .95595 0 -2.5 Mabsadd L
.933 .95595 -1.875 0 Mabsadd L closepath F
.95056 .97336 -1.875 0 Mabsadd m
.95056 .97336 0 2.5 Mabsadd L
.95056 .97336 1.875 0 Mabsadd L
.95056 .97336 0 -2.5 Mabsadd L
.95056 .97336 -1.875 0 Mabsadd L closepath F
.96337 .97478 -1.875 0 Mabsadd m
.96337 .97478 0 2.5 Mabsadd L
.96337 .97478 1.875 0 Mabsadd L
.96337 .97478 0 -2.5 Mabsadd L
.96337 .97478 -1.875 0 Mabsadd L closepath F
.97619 .97619 -1.875 0 Mabsadd m
.97619 .97619 0 2.5 Mabsadd L
.97619 .97619 1.875 0 Mabsadd L
.97619 .97619 0 -2.5 Mabsadd L
.97619 .97619 -1.875 0 Mabsadd L closepath F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[105]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool002eoo`8002aoo`@002eoo`03001oogoo02]oo`8002eoo`8002Uoo`@000=oo`8000=oo`00;7oo
00@007ooOol002]oo`03001oogoo02ioo`03001oogoo02Yoo`04001oogoo000[Ool01000Oomoo`00
:Woo00D007ooOomoo`00009oo`40005oo`5oo`00;7oo00@007ooOol002aoo`03001oogoo02Yoo`D0
02]oo`04001oogoo000[Ool01000Oomoo`00:Woo00D007ooOomoo`00009oo`40005oo`5oo`00;7oo
00@007ooOol002eoo`03001oogoo02Uoo`04001oogoo000/Ool3000]Ool2000[Ool01@00Oomoogoo
00000Woo0@000Goo0Goo000/Ool01000Oomoo`00;Woo00<007ooOol0:Goo00<007oo0000;7oo00<0
07ooOol0;7oo00@007ooOol002Yoo`05001oogooOol00002Ool10001Ool1Ool002aoo`04001oogoo
000[Ool01000Oomoo`00;7oo0P00;7oo00<007ooOol0;7oo00@007ooOol002Qoo`<000=oo`04001o
ogoo0002Ool002eoo`8002eoo`8002ioo`03001oogoo02]oo`<002aoo`8002]oo`03001oogoo009o
o`8000=oo`00ogoo8Goo003oOolQOol00?moob5oo`00:7oom`000Goo000XOol00`00Oomoo`03Ool0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`02Ool10001Ool002Qoo`03001oogoo0?=oo`40005oo`00:7oo00<007ooOol0lgoo0@00
0Goo000QOol20005Ool00`00Oomoo`03Ool01P00Oomoo`00Ool00>Yoo`40005oo`0087oo00@007oo
Ool000Aoo`03001oogoo009oo`X00003Ool000000>Aoo`40005oo`0087oo00@007ooOol000Aoo`<0
0003Ool0000000d00003Ool000000=moo`80005oo`0087oo00@007ooOol000Aoo`03001oogoo009o
o`800003Ool0000000800003Ool0000000X00=eoo`40005oo`0087oo00@007ooOol000Aoo`03001o
ogoo00]oo`04001oogoo0002Ool60002Ool00`00Oomoo`3GOol10001Ool0021oo`04001oogoo0004
Ool00`00Oomoo`0BOol00`00Ool00002000017oo00000000f7oo0@000Goo000QOol20005Ool00`00
Oomoo`0EOol00`00Ool00003003HOol10001Ool002Qoo`03001oogoo01Qoo`80009oo`800=Eoo`40
005oo`00:7oo00<007ooOol06goo1000e7oo0@000Goo000XOol00`00Oomoo`0LOol3003DOol10001
Ool002Qoo`03001oogoo01eoo`03001oogoo00800=5oo`40005oo`00:7oo00<007ooOol07goo1000
d7oo0@000Goo000XOol2000QOol30002Ool00`00Oomoo`3:Ool20001Ool002Qoo`03001oogoo025o
o`04001oogooOol2003<Ool10001Ool002Qoo`03001oogoo02Aoo`<00<aoo`40005oo`00:7oo00<0
07ooOol09Goo00D007ooOomoo`000<Uoo`40005oo`00:7oo00<007ooOol0:Goo0P00b7oo0@000Goo
000XOol00`00Oomoo`0XOol30038Ool10001Ool002Qoo`03001oogoo02Uoo`03001oogoo009oo`03
001oogoo0<9oo`40005oo`00:7oo00<007ooOol0;Goo0P00a7oo0@000Goo000XOol00`00Oomoo`0/
Ool30034Ool10001Ool002Qoo`03001oogoo02eoo`8000=oo`03001oogoo0;ioo`40005oo`00:7oo
0P00<Woo0`00_Woo0P000Goo000XOol00`00Oomoo`0`Ool4002oOol10001Ool002Qoo`03001oogoo
035oo`800<1oo`40005oo`00:7oo00<007ooOol0=Woo00<007ooOol0^Woo0@000Goo000XOol00`00
Oomoo`0eOol3002kOol10001Ool002Qoo`03001oogoo03Aoo`@00;]oo`40005oo`00:7oo00<007oo
Ool0=Goo0P00_7oo0@000Goo000XOol00`00Oomoo`0jOol00`00Oomoo`2fOol10001Ool002Qoo`03
001oogoo03Uoo`<00;Moo`40005oo`00:7oo00<007ooOol0>7oo1000]goo0@000Goo000XOol2000j
Ool2002gOol20001Ool002Qoo`03001oogoo0?=oo`40005oo`00:7oo00<007ooOol0?goo00<007oo
Ool0/Goo0@000Goo000XOol00`00Oomoo`0nOol3002bOol10001Ool002Qoo`03001oogoo03eoo`@0
0;9oo`40005oo`00:7oo00<007ooOol0?Woo0P00/goo0@000Goo000XOol00`00Oomoo`3cOol10001
Ool00003Ool000000080009oo`05001oogooOol00006Ool40003Ool2000=Ool00`00Oomoo`3cOol1
0001Ool00003Ool007oo00Eoo`03001oo`0000Uoo`05001oogooOol00002Ool00`00Oomoo`0:Ool0
0`00Oomoo`13Ool00`00Oomoo`2]Ool10001Ool0009oo`03001oogoo00Aoo`03001oogoo00Qoo`05
001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`12Ool3002^Ool10001Ool000=oo`03001o
ogoo009oo`03001oo`0000Uoo`05001oogooOol00002Ool00`00Oomoo`0:Ool30011Ool4002]Ool2
0001Ool000Aoo`04001oogoo0003Ool00`00Oomoo`06Ool01@00Oomoogoo00000Woo00<007ooOol0
2Woo00<007ooOol0@Woo0P00[goo0@000Goo00001Goo001oogoo00003Goo0`000goo00@007ooOol0
00Moo`<0009oo`800?Aoo`40005oo`000Woo0P0047oo00<007ooOol00Woo0P002Goo00L007ooOomo
o`00Ool0003cOol10001Ool001ioo`<000=oo`07001oogooOol007oo0000Agoo0P00ZWoo0@000Goo
000TOol01`00Oomoogoo001oo`0004Ioo`@00:Uoo`40005oo`008goo0P000goo00<007oo0000Agoo
0`00ZGoo0@000Goo000TOol01000Oomoogoo0P00BGoo00<007ooOol0Z7oo0@000Goo000XOol00`00
Oomoo`1<Ool00`00Oomoo`2TOol10001Ool002Qoo`03001oogoo04]oo`<00:Eoo`40005oo`00:7oo
0P00Bgoo1000Y7oo0P000Goo000XOol00`00Oomoo`1;Ool2002VOol10001Ool002Qoo`03001oogoo
0?=oo`40005oo`00:7oo00<007ooOol0D7oo00<007ooOol0X7oo0@000Goo000XOol00`00Oomoo`1?
Ool3002QOol10001Ool002Qoo`03001oogoo051oo`800:5oo`40005oo`00:7oo00<007ooOol0D7oo
00<007ooOol0X7oo0@000Goo000XOol00`00Oomoo`1DOol2002MOol10001Ool002Qoo`03001oogoo
05=oo`@009aoo`40005oo`00:7oo00<007ooOol0E7oo0`00W7oo0@000Goo000XOol00`00Oomoo`1E
Ool00`00Oomoo`2KOol10001Ool002Qoo`8005Yoo`03001oogoo09Ioo`80005oo`00:7oo00<007oo
Ool0F7oo0`00V7oo0@000Goo000XOol00`00Oomoo`1GOol4002HOol10001Ool002Qoo`03001oogoo
05Qoo`8009Uoo`40005oo`00:7oo00<007ooOol0lgoo0@000Goo000XOol00`00Oomoo`1MOol00`00
Oomoo`2COol10001Ool002Qoo`03001oogoo05eoo`8009Aoo`40005oo`00:7oo00<007ooOol0G7oo
0`00U7oo0@000Goo000XOol00`00Oomoo`1MOol00`00Oomoo`2COol10001Ool002Qoo`03001oogoo
0?=oo`40005oo`00:7oo0P00lgoo0P000Goo000XOol00`00Oomoo`1QOol2002@Ool10001Ool002Qo
o`03001oogoo061oo`@008moo`40005oo`00:7oo00<007ooOol0HGoo0`00Sgoo0@000Goo000XOol0
0`00Oomoo`1ROol00`00Oomoo`2>Ool10001Ool002Qoo`03001oogoo0?=oo`40005oo`00:7oo00<0
07ooOol0lgoo0@000Goo0003Ool01@00Oomoogoo00000goo00<007ooOol017oo10000goo0P003Goo
00<007ooOol0Igoo00<007ooOol0RGoo0@000Goo0003Ool00`00Oomoo`02Ool00`00Ool00009Ool0
1@00Oomoogoo00000Woo00<007ooOol02Woo00<007ooOol0IWoo0P00Rgoo0@000Goo00050004Ool0
0`00Oomoo`08Ool01@00Oomoogoo00000Woo00<007ooOol02Woo00<007ooOol0IGoo0`00Rgoo0@00
0Goo00001000Oomoo`0017oo00<007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`<0
06Ioo`8008Yoo`80005oo`0000Aoo`00Ool000=oo`05001oogooOol00008Ool01@00Oomoogoo0000
0Woo00<007ooOol02Woo00<007ooOol0lgoo0@000Goo0002Ool2000>Ool30003Ool01000Oomoo`00
1goo0`000Woo0P00m7oo0@000Goo0003Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool20009Ool01`00
Oomoogoo001oo`0006]oo`03001oogoo08Eoo`40005oo`007Woo0`000goo00L007ooOomoo`00Ool0
001ZOol30026Ool10001Ool002Aoo`07001oogooOol007oo0000JGoo1000QWoo0@000Goo000SOol2
0003Ool00`00Ool0001ZOol20027Ool10001Ool002Aoo`04001oogooOol2003dOol10001Ool002Qo
o`03001oogoo0?=oo`40005oo`00:7oo00<007ooOol0Kgoo00<007ooOol0PGoo0@000Goo000XOol2
001_Ool30021Ool20001Ool002Qoo`03001oogoo06moo`80089oo`40005oo`00:7oo00<007ooOol0
Kgoo00<007ooOol0PGoo0@000Goo000XOol00`00Oomoo`3cOol10001Ool002Qoo`03001oogoo07=o
o`8007ioo`40005oo`00:7oo00<007ooOol0LWoo1000OGoo0@000Goo000XOol00`00Oomoo`1cOol3
001mOol10001Ool002Qoo`03001oogoo07Aoo`03001oogoo07aoo`40005oo`00:7oo00<007ooOol0
Mgoo0P00NWoo0@000Goo000XOol00`00Oomoo`1fOol4001iOol10001Ool002Qoo`8007Qoo`<007Qo
o`80005oo`00:7oo00<007ooOol0N7oo00<007ooOol0N7oo0@000Goo000XOol00`00Oomoo`1mOol0
0`00Oomoo`1cOol10001Ool002Qoo`03001oogoo07aoo`8007Eoo`40005oo`00:7oo00<007ooOol0
Ngoo0`00MGoo0@000Goo000XOol00`00Oomoo`1lOol2001eOol10001Ool002Qoo`03001oogoo0?=o
o`40005oo`00:7oo00<007ooOol0PGoo00<007ooOol0Kgoo0@000Goo000XOol00`00Oomoo`20Ool3
001`Ool10001Ool002Qoo`03001oogoo07moo`@0071oo`40005oo`00:7oo0P00PGoo0P00L7oo0P00
0Goo000XOol00`00Oomoo`3cOol10001Ool002Qoo`03001oogoo0?=oo`40005oo`00:7oo00<007oo
Ool0QGoo00<007ooOol0Jgoo0@000Goo000XOol00`00Oomoo`24Ool3001/Ool10001Ool002Qoo`03
001oogoo08Eoo`8006aoo`40005oo`00:7oo00<007ooOol0QGoo00<007ooOol0Jgoo0@000Goo0002
Ool20003Ool01@00Oomoogoo00001Woo10000goo0P003Goo00<007ooOol0lgoo0@000Goo00001Goo
001oogoo00000goo00<007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo
0?=oo`40005oo`0000Eoo`00Oomoo`0000Aoo`03001oogoo00Qoo`05001oogooOol00002Ool00`00
Oomoo`0:Ool00`00Oomoo`2:Ool00`00Oomoo`1VOol10001Ool00004Ool000000004Ool00`00Ool0
0009Ool01@00Oomoogoo00000Woo00<007ooOol02Woo0`00RGoo0`00IWoo0P000Goo00000goo001o
o`04Ool01@00Oomoogoo000027oo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo08Qo
o`@006Moo`40005oo`0000=oo`00Ool03goo0`000goo00@007ooOol000Moo`<0009oo`8008Yoo`80
06Qoo`40005oo`000Woo0`003goo00<007ooOol00Woo0P002Goo00L007ooOomoo`00Ool0003cOol1
0001Ool001ioo`<000=oo`07001oogooOol007oo0000lgoo0@000Goo000TOol01`00Oomoogoo001o
o`000?=oo`40005oo`008goo0P000goo00<007oo0000SWoo00<007ooOol0HWoo0@000Goo000TOol0
1000Oomoogoo0P00SWoo0`00Hgoo0@000Goo000XOol00`00Oomoo`2>Ool2001SOol10001Ool002Qo
o`03001oogoo08ioo`03001oogoo069oo`40005oo`00:7oo0P00lgoo0P000Goo000XOol00`00Oomo
o`2COol00`00Oomoo`1MOol10001Ool002Qoo`03001oogoo099oo`<005ioo`40005oo`00:7oo00<0
07ooOol0TGoo1000GWoo0@000Goo000XOol00`00Oomoo`2BOol2001OOol10001Ool002Qoo`03001o
ogoo0?=oo`40005oo`00:7oo00<007ooOol0Ugoo00<007ooOol0FGoo0@000Goo000XOol00`00Oomo
o`2FOol3001JOol10001Ool002Qoo`03001oogoo09Eoo`@005Yoo`40005oo`00:7oo00<007ooOol0
UWoo0P00Fgoo0@000Goo000XOol00`00Oomoo`2LOol00`00Oomoo`1DOol10001Ool002Qoo`8009ao
o`<005Aoo`80005oo`00:7oo00<007ooOol0VWoo1000EGoo0@000Goo000XOol00`00Oomoo`2KOol2
001FOol10001Ool002Qoo`03001oogoo0?=oo`40005oo`00:7oo00<007ooOol0X7oo00<007ooOol0
D7oo0@000Goo000XOol00`00Oomoo`2OOol3001AOol10001Ool002Qoo`03001oogoo09ioo`@0055o
o`40005oo`00:7oo00<007ooOol0Wgoo0P00DWoo0@000Goo000XOol00`00Oomoo`3cOol10001Ool0
02Qoo`03001oogoo0:Aoo`03001oogoo04aoo`40005oo`00:7oo0P00Y7oo0`00C7oo0P000Goo000X
Ool00`00Oomoo`2TOol2001=Ool10001Ool002Qoo`03001oogoo0:Aoo`03001oogoo04aoo`40005o
o`00:7oo00<007ooOol0lgoo0@000Goo000XOol00`00Oomoo`2YOol00`00Oomoo`17Ool10001Ool0
02Qoo`03001oogoo0:Qoo`<004Qoo`40005oo`00:7oo00<007ooOol0Ygoo1000B7oo0@000Goo0002
Ool20003Ool01@00Oomoogoo00001Woo10000goo0P003Goo00<007ooOol0Z7oo0P00BGoo0@000Goo
00001Goo001oogoo00000goo00<007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`03
001oogoo0?=oo`40005oo`0000Eoo`00Oomoo`0000Aoo`03001oogoo00Qoo`05001oogooOol00002
Ool00`00Oomoo`0:Ool00`00Oomoo`3cOol10001Ool0009oo`8000Aoo`03001oo`0000Uoo`05001o
ogooOol00002Ool00`00Oomoo`0:Ool3002]Ool00`00Oomoo`12Ool20001Ool00005Ool007ooOol0
0002Ool01@00Oomoogoo000027oo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo0:eo
o`8004Aoo`40005oo`0000Eoo`00Oomoo`0000eoo`<000=oo`04001oogoo0007Ool30002Ool2002]
Ool30014Ool10001Ool0009oo`80011oo`03001oogoo009oo`8000Uoo`07001oogooOol007oo0000
[Goo00<007ooOol0@goo0@000Goo000NOol30003Ool01`00Oomoogoo001oo`000?=oo`40005oo`00
97oo00L007ooOomoo`00Ool0003cOol10001Ool002=oo`8000=oo`03001oo`000?=oo`40005oo`00
97oo00@007ooOomoo`800;=oo`03001oogoo03ioo`40005oo`00:7oo00<007ooOol0/Goo0`00?goo
0@000Goo000XOol00`00Oomoo`2`Ool4000oOol10001Ool002Qoo`800;9oo`8003moo`80005oo`00
:7oo00<007ooOol0lgoo0@000Goo000XOol00`00Oomoo`3cOol10001Ool002Qoo`03001oogoo0;Io
o`03001oogoo03Yoo`40005oo`00:7oo00<007ooOol0]Goo0`00>goo0@000Goo000XOol00`00Oomo
o`2fOol2000kOol10001Ool002Qoo`03001oogoo0;Ioo`03001oogoo03Yoo`40005oo`00:7oo00<0
07ooOol0lgoo0@000Goo000XOol00`00Oomoo`2kOol00`00Oomoo`0eOol10001Ool002Qoo`03001o
ogoo0;Yoo`<003Ioo`40005oo`00:7oo0P00^Woo1000=Goo0P000Goo000XOol00`00Oomoo`2jOol2
000gOol10001Ool002Qoo`03001oogoo0?=oo`40005oo`00:7oo00<007ooOol0_Woo0P00<goo0@00
0Goo000XOol00`00Oomoo`2mOol4000bOol10001Ool002Qoo`03001oogoo0;ioo`<0039oo`40005o
o`00:7oo00<007ooOol0_goo00<007ooOol0<Goo0@000Goo000XOol00`00Oomoo`34Ool00`00Oomo
o`0/Ool10001Ool002Qoo`03001oogoo0<=oo`<002eoo`40005oo`00:7oo00<007ooOol0`Woo1000
;Goo0@000Goo000XOol20034Ool2000]Ool20001Ool002Qoo`03001oogoo0?=oo`40005oo`00:7oo
00<007ooOol0agoo0P00:Woo0@000Goo000XOol00`00Oomoo`36Ool4000YOol10001Ool002Qoo`03
001oogoo0<Moo`<002Uoo`40005oo`00:7oo00<007ooOol0b7oo00<007ooOol0:7oo0@000Goo000X
Ool00`00Oomoo`3cOol10001Ool000Eoo`@0009oo`05001oogooOol00006Ool40003Ool20009Ool0
0`00Oomoo`3<Ool00`00Oomoo`0TOol10001Ool000Moo`03001oogoo009oo`03001oo`0000Uoo`05
001oogooOol00002Ool00`00Oomoo`06Ool00`00Oomoo`3<Ool2000UOol10001Ool000Moo`03001o
ogoo00=oo`03001oogoo00Qoo`05001oogooOol00002Ool00`00Oomoo`06Ool00`00Oomoo`3;Ool3
000UOol10001Ool000Moo`03001oogoo009oo`03001oo`0000Uoo`05001oogooOol00002Ool00`00
Oomoo`06Ool3003<Ool00`00Oomoo`0SOol20001Ool000Moo`05001oogooOol00003Ool00`00Oomo
o`06Ool01@00Oomoogoo00000Woo00<007ooOol01Woo00<007ooOol0lgoo0@000Goo0005Ool3000>
Ool30003Ool01000Oomoo`001goo0P00mGoo0@000Goo0007Ool00`00Oomoo`0>Ool00`00Oomoo`02
Ool20009Ool2003AOol2000QOol10001Ool0029oo`<000=oo`800=1oo`@0021oo`40005oo`009goo
0`00dGoo0`0087oo0@000Goo000WOol3003BOol00`00Oomoo`0OOol10001Ool002Qoo`800?Aoo`40
005oo`00:7oo00<007ooOol0lgoo0@000Goo000XOol00`00Oomoo`3cOol10001Ool002Qoo`03001o
ogoo0=Eoo`8001aoo`40005oo`00:7oo0P00eGoo0`006goo0P000Goo000XOol00`00Oomoo`3EOol2
000LOol10001Ool002Qoo`03001oogoo0=Ioo`03001oogoo01Yoo`40005oo`00:7oo00<007ooOol0
lgoo0@000Goo000XOol00`00Oomoo`3cOol10001Ool002Qoo`03001oogoo0=Uoo`8001Qoo`40005o
o`00:7oo00<007ooOol0f7oo10005goo0@000Goo000XOol00`00Oomoo`3IOol3000GOol10001Ool0
02Qoo`03001oogoo0=Yoo`03001oogoo01Ioo`40005oo`00:7oo00<007ooOol0lgoo0@000Goo000X
Ool2003OOol00`00Oomoo`0AOol20001Ool002Qoo`03001oogoo0=ioo`8001=oo`40005oo`00:7oo
00<007ooOol0gGoo0`004goo0@000Goo000XOol00`00Oomoo`3NOol00`00Oomoo`0BOol10001Ool0
02Qoo`03001oogoo0?=oo`40005oo`00:7oo00<007ooOol0hWoo0P003goo0@000Goo000XOol00`00
Oomoo`3QOol4000>Ool10001Ool002Qoo`03001oogoo0>9oo`<000ioo`40005oo`00:7oo00<007oo
Ool0hgoo00<007ooOol03Goo0@000Goo000XOol00`00Oomoo`3WOol01000Oomoo`0027oo0@000Goo
000XOol2003WOol600000goo00000003Ool20001Ool002Qoo`03001oogoo0>Eoo`X000Aoo`40005o
o`00:7oo00<007ooOol0iWoo0P0000=oo`0000000Woo0P0017oo0@000Goo000XOol00`00Oomoo`3^
Ool00`00Oomoo`02Ool10001Ool002Qoo`03001oogoo0?=oo`40005oo`00:7oo00<007ooOol0lgoo
0@000Goo000XOol00`00Oomoo`03Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`02Ool10001Ool002QoooL0005oo`00ogoo8Goo
003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {495.438, 136.688}} -> {-5.17228, \
3.80519*^-10, 0.0426339, 4.93454*^-12}}]
}, Open  ]],

Cell[TextData[{
  "This also solves the system using the method ",
  StyleBox["ExplicitRungeKutta", "MR"],
  " but it projects the solution at the end of each step. A plot of the error \
in the invariant shows that it is conserved up to roundoff."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(projerksol\  = \ 
        NDSolve[system, 
          Method \[Rule] {"\<Projection\>", 
              Method \[Rule] "\<ExplicitRungeKutta\>", "\<Invariants\>" \
\[Rule] invariant}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(InvariantErrorPlot[invariant, vars, T, projerksol];\)\)}], "Input",
  CellLabel->"In[107]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0238095 4.28914e+15 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .23827 -37.5 -6.25 ]
[-0.0125 .23827 0 6.25 ]
[-0.0125 .45272 -37.5 -6.25 ]
[-0.0125 .45272 0 6.25 ]
[-0.0125 .66718 -49.5 -6.25 ]
[-0.0125 .66718 0 6.25 ]
[-0.0125 .88164 -37.5 -6.25 ]
[-0.0125 .88164 0 6.25 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .23827 m
.00625 .23827 L
s
gsave
-0.0125 .23827 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-17) show
grestore
0 .45272 m
.00625 .45272 L
s
gsave
-0.0125 .45272 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
0 .66718 m
.00625 .66718 L
s
gsave
-0.0125 .66718 -49.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
0 .88164 m
.00625 .88164 L
s
gsave
-0.0125 .88164 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
.125 Mabswid
0 .0667 m
.00375 .0667 L
s
0 .10959 m
.00375 .10959 L
s
0 .15248 m
.00375 .15248 L
s
0 .19538 m
.00375 .19538 L
s
0 .28116 m
.00375 .28116 L
s
0 .32405 m
.00375 .32405 L
s
0 .36694 m
.00375 .36694 L
s
0 .40983 m
.00375 .40983 L
s
0 .49562 m
.00375 .49562 L
s
0 .53851 m
.00375 .53851 L
s
0 .5814 m
.00375 .5814 L
s
0 .62429 m
.00375 .62429 L
s
0 .71007 m
.00375 .71007 L
s
0 .75296 m
.00375 .75296 L
s
0 .79586 m
.00375 .79586 L
s
0 .83875 m
.00375 .83875 L
s
0 .92453 m
.00375 .92453 L
s
0 .96742 m
.00375 .96742 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.21429 .99375 m
.21429 1 L
s
.40476 .99375 m
.40476 1 L
s
.59524 .99375 m
.59524 1 L
s
.78571 .99375 m
.78571 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.07143 .99625 m
.07143 1 L
s
.11905 .99625 m
.11905 1 L
s
.16667 .99625 m
.16667 1 L
s
.2619 .99625 m
.2619 1 L
s
.30952 .99625 m
.30952 1 L
s
.35714 .99625 m
.35714 1 L
s
.45238 .99625 m
.45238 1 L
s
.5 .99625 m
.5 1 L
s
.54762 .99625 m
.54762 1 L
s
.64286 .99625 m
.64286 1 L
s
.69048 .99625 m
.69048 1 L
s
.7381 .99625 m
.7381 1 L
s
.83333 .99625 m
.83333 1 L
s
.88095 .99625 m
.88095 1 L
s
.92857 .99625 m
.92857 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .23827 m
1 .23827 L
s
.99375 .45272 m
1 .45272 L
s
.99375 .66718 m
1 .66718 L
s
.99375 .88164 m
1 .88164 L
s
.125 Mabswid
.99625 .0667 m
1 .0667 L
s
.99625 .10959 m
1 .10959 L
s
.99625 .15248 m
1 .15248 L
s
.99625 .19538 m
1 .19538 L
s
.99625 .28116 m
1 .28116 L
s
.99625 .32405 m
1 .32405 L
s
.99625 .36694 m
1 .36694 L
s
.99625 .40983 m
1 .40983 L
s
.99625 .49562 m
1 .49562 L
s
.99625 .53851 m
1 .53851 L
s
.99625 .5814 m
1 .5814 L
s
.99625 .62429 m
1 .62429 L
s
.99625 .71007 m
1 .71007 L
s
.99625 .75296 m
1 .75296 L
s
.99625 .79586 m
1 .79586 L
s
.99625 .83875 m
1 .83875 L
s
.99625 .92453 m
1 .92453 L
s
.99625 .96742 m
1 .96742 L
s
.25 Mabswid
1 0 m
1 1 L
s
.0001 w
.02381 .02381 -1.875 0 Mabsadd m
.02381 .02381 0 2.5 Mabsadd L
.02381 .02381 1.875 0 Mabsadd L
.02381 .02381 0 -2.5 Mabsadd L
.02381 .02381 -1.875 0 Mabsadd L closepath F
.0345 .2619 -1.875 0 Mabsadd m
.0345 .2619 0 2.5 Mabsadd L
.0345 .2619 1.875 0 Mabsadd L
.0345 .2619 0 -2.5 Mabsadd L
.0345 .2619 -1.875 0 Mabsadd L closepath F
.04467 .2619 -1.875 0 Mabsadd m
.04467 .2619 0 2.5 Mabsadd L
.04467 .2619 1.875 0 Mabsadd L
.04467 .2619 0 -2.5 Mabsadd L
.04467 .2619 -1.875 0 Mabsadd L closepath F
.05691 .5 -1.875 0 Mabsadd m
.05691 .5 0 2.5 Mabsadd L
.05691 .5 1.875 0 Mabsadd L
.05691 .5 0 -2.5 Mabsadd L
.05691 .5 -1.875 0 Mabsadd L closepath F
.06967 .02381 -1.875 0 Mabsadd m
.06967 .02381 0 2.5 Mabsadd L
.06967 .02381 1.875 0 Mabsadd L
.06967 .02381 0 -2.5 Mabsadd L
.06967 .02381 -1.875 0 Mabsadd L closepath F
.08367 .2619 -1.875 0 Mabsadd m
.08367 .2619 0 2.5 Mabsadd L
.08367 .2619 1.875 0 Mabsadd L
.08367 .2619 0 -2.5 Mabsadd L
.08367 .2619 -1.875 0 Mabsadd L closepath F
.0984 .5 -1.875 0 Mabsadd m
.0984 .5 0 2.5 Mabsadd L
.0984 .5 1.875 0 Mabsadd L
.0984 .5 0 -2.5 Mabsadd L
.0984 .5 -1.875 0 Mabsadd L closepath F
.11406 .5 -1.875 0 Mabsadd m
.11406 .5 0 2.5 Mabsadd L
.11406 .5 1.875 0 Mabsadd L
.11406 .5 0 -2.5 Mabsadd L
.11406 .5 -1.875 0 Mabsadd L closepath F
.13044 .5 -1.875 0 Mabsadd m
.13044 .5 0 2.5 Mabsadd L
.13044 .5 1.875 0 Mabsadd L
.13044 .5 0 -2.5 Mabsadd L
.13044 .5 -1.875 0 Mabsadd L closepath F
.14693 .5 -1.875 0 Mabsadd m
.14693 .5 0 2.5 Mabsadd L
.14693 .5 1.875 0 Mabsadd L
.14693 .5 0 -2.5 Mabsadd L
.14693 .5 -1.875 0 Mabsadd L closepath F
.16362 .5 -1.875 0 Mabsadd m
.16362 .5 0 2.5 Mabsadd L
.16362 .5 1.875 0 Mabsadd L
.16362 .5 0 -2.5 Mabsadd L
.16362 .5 -1.875 0 Mabsadd L closepath F
.18031 .2619 -1.875 0 Mabsadd m
.18031 .2619 0 2.5 Mabsadd L
.18031 .2619 1.875 0 Mabsadd L
.18031 .2619 0 -2.5 Mabsadd L
.18031 .2619 -1.875 0 Mabsadd L closepath F
.19695 .02381 -1.875 0 Mabsadd m
.19695 .02381 0 2.5 Mabsadd L
.19695 .02381 1.875 0 Mabsadd L
.19695 .02381 0 -2.5 Mabsadd L
.19695 .02381 -1.875 0 Mabsadd L closepath F
.21394 .5 -1.875 0 Mabsadd m
.21394 .5 0 2.5 Mabsadd L
.21394 .5 1.875 0 Mabsadd L
.21394 .5 0 -2.5 Mabsadd L
.21394 .5 -1.875 0 Mabsadd L closepath F
.23117 .02381 -1.875 0 Mabsadd m
.23117 .02381 0 2.5 Mabsadd L
.23117 .02381 1.875 0 Mabsadd L
.23117 .02381 0 -2.5 Mabsadd L
.23117 .02381 -1.875 0 Mabsadd L closepath F
.24875 .5 -1.875 0 Mabsadd m
.24875 .5 0 2.5 Mabsadd L
.24875 .5 1.875 0 Mabsadd L
.24875 .5 0 -2.5 Mabsadd L
.24875 .5 -1.875 0 Mabsadd L closepath F
.2667 .5 -1.875 0 Mabsadd m
.2667 .5 0 2.5 Mabsadd L
.2667 .5 1.875 0 Mabsadd L
.2667 .5 0 -2.5 Mabsadd L
.2667 .5 -1.875 0 Mabsadd L closepath F
.28501 .02381 -1.875 0 Mabsadd m
.28501 .02381 0 2.5 Mabsadd L
.28501 .02381 1.875 0 Mabsadd L
.28501 .02381 0 -2.5 Mabsadd L
.28501 .02381 -1.875 0 Mabsadd L closepath F
.30296 .5 -1.875 0 Mabsadd m
.30296 .5 0 2.5 Mabsadd L
.30296 .5 1.875 0 Mabsadd L
.30296 .5 0 -2.5 Mabsadd L
.30296 .5 -1.875 0 Mabsadd L closepath F
.3208 .2619 -1.875 0 Mabsadd m
.3208 .2619 0 2.5 Mabsadd L
.3208 .2619 1.875 0 Mabsadd L
.3208 .2619 0 -2.5 Mabsadd L
.3208 .2619 -1.875 0 Mabsadd L closepath F
.33834 .02381 -1.875 0 Mabsadd m
.33834 .02381 0 2.5 Mabsadd L
.33834 .02381 1.875 0 Mabsadd L
.33834 .02381 0 -2.5 Mabsadd L
.33834 .02381 -1.875 0 Mabsadd L closepath F
.35584 .5 -1.875 0 Mabsadd m
.35584 .5 0 2.5 Mabsadd L
.35584 .5 1.875 0 Mabsadd L
.35584 .5 0 -2.5 Mabsadd L
.35584 .5 -1.875 0 Mabsadd L closepath F
.37354 .5 -1.875 0 Mabsadd m
.37354 .5 0 2.5 Mabsadd L
.37354 .5 1.875 0 Mabsadd L
.37354 .5 0 -2.5 Mabsadd L
.37354 .5 -1.875 0 Mabsadd L closepath F
.39141 .02381 -1.875 0 Mabsadd m
.39141 .02381 0 2.5 Mabsadd L
.39141 .02381 1.875 0 Mabsadd L
.39141 .02381 0 -2.5 Mabsadd L
.39141 .02381 -1.875 0 Mabsadd L closepath F
.40958 .97619 -1.875 0 Mabsadd m
.40958 .97619 0 2.5 Mabsadd L
.40958 .97619 1.875 0 Mabsadd L
.40958 .97619 0 -2.5 Mabsadd L
.40958 .97619 -1.875 0 Mabsadd L closepath F
.4281 .02381 -1.875 0 Mabsadd m
.4281 .02381 0 2.5 Mabsadd L
.4281 .02381 1.875 0 Mabsadd L
.4281 .02381 0 -2.5 Mabsadd L
.4281 .02381 -1.875 0 Mabsadd L closepath F
.44639 .02381 -1.875 0 Mabsadd m
.44639 .02381 0 2.5 Mabsadd L
.44639 .02381 1.875 0 Mabsadd L
.44639 .02381 0 -2.5 Mabsadd L
.44639 .02381 -1.875 0 Mabsadd L closepath F
.46447 .2619 -1.875 0 Mabsadd m
.46447 .2619 0 2.5 Mabsadd L
.46447 .2619 1.875 0 Mabsadd L
.46447 .2619 0 -2.5 Mabsadd L
.46447 .2619 -1.875 0 Mabsadd L closepath F
.48226 .02381 -1.875 0 Mabsadd m
.48226 .02381 0 2.5 Mabsadd L
.48226 .02381 1.875 0 Mabsadd L
.48226 .02381 0 -2.5 Mabsadd L
.48226 .02381 -1.875 0 Mabsadd L closepath F
.49976 .2619 -1.875 0 Mabsadd m
.49976 .2619 0 2.5 Mabsadd L
.49976 .2619 1.875 0 Mabsadd L
.49976 .2619 0 -2.5 Mabsadd L
.49976 .2619 -1.875 0 Mabsadd L closepath F
.51752 .02381 -1.875 0 Mabsadd m
.51752 .02381 0 2.5 Mabsadd L
.51752 .02381 1.875 0 Mabsadd L
.51752 .02381 0 -2.5 Mabsadd L
.51752 .02381 -1.875 0 Mabsadd L closepath F
.53537 .02381 -1.875 0 Mabsadd m
.53537 .02381 0 2.5 Mabsadd L
.53537 .02381 1.875 0 Mabsadd L
.53537 .02381 0 -2.5 Mabsadd L
.53537 .02381 -1.875 0 Mabsadd L closepath F
.5535 .02381 -1.875 0 Mabsadd m
.5535 .02381 0 2.5 Mabsadd L
.5535 .02381 1.875 0 Mabsadd L
.5535 .02381 0 -2.5 Mabsadd L
.5535 .02381 -1.875 0 Mabsadd L closepath F
.57194 .5 -1.875 0 Mabsadd m
.57194 .5 0 2.5 Mabsadd L
.57194 .5 1.875 0 Mabsadd L
.57194 .5 0 -2.5 Mabsadd L
.57194 .5 -1.875 0 Mabsadd L closepath F
.59042 .02381 -1.875 0 Mabsadd m
.59042 .02381 0 2.5 Mabsadd L
.59042 .02381 1.875 0 Mabsadd L
.59042 .02381 0 -2.5 Mabsadd L
.59042 .02381 -1.875 0 Mabsadd L closepath F
.60856 .02381 -1.875 0 Mabsadd m
.60856 .02381 0 2.5 Mabsadd L
.60856 .02381 1.875 0 Mabsadd L
.60856 .02381 0 -2.5 Mabsadd L
.60856 .02381 -1.875 0 Mabsadd L closepath F
.62647 .5 -1.875 0 Mabsadd m
.62647 .5 0 2.5 Mabsadd L
.62647 .5 1.875 0 Mabsadd L
.62647 .5 0 -2.5 Mabsadd L
.62647 .5 -1.875 0 Mabsadd L closepath F
.64405 .02381 -1.875 0 Mabsadd m
.64405 .02381 0 2.5 Mabsadd L
.64405 .02381 1.875 0 Mabsadd L
.64405 .02381 0 -2.5 Mabsadd L
.64405 .02381 -1.875 0 Mabsadd L closepath F
.66176 .02381 -1.875 0 Mabsadd m
.66176 .02381 0 2.5 Mabsadd L
.66176 .02381 1.875 0 Mabsadd L
.66176 .02381 0 -2.5 Mabsadd L
.66176 .02381 -1.875 0 Mabsadd L closepath F
.67959 .02381 -1.875 0 Mabsadd m
.67959 .02381 0 2.5 Mabsadd L
.67959 .02381 1.875 0 Mabsadd L
.67959 .02381 0 -2.5 Mabsadd L
.67959 .02381 -1.875 0 Mabsadd L closepath F
.69764 .2619 -1.875 0 Mabsadd m
.69764 .2619 0 2.5 Mabsadd L
.69764 .2619 1.875 0 Mabsadd L
.69764 .2619 0 -2.5 Mabsadd L
.69764 .2619 -1.875 0 Mabsadd L closepath F
.71599 .2619 -1.875 0 Mabsadd m
.71599 .2619 0 2.5 Mabsadd L
.71599 .2619 1.875 0 Mabsadd L
.71599 .2619 0 -2.5 Mabsadd L
.71599 .2619 -1.875 0 Mabsadd L closepath F
.73462 .5 -1.875 0 Mabsadd m
.73462 .5 0 2.5 Mabsadd L
.73462 .5 1.875 0 Mabsadd L
.73462 .5 0 -2.5 Mabsadd L
.73462 .5 -1.875 0 Mabsadd L closepath F
.75281 .02381 -1.875 0 Mabsadd m
.75281 .02381 0 2.5 Mabsadd L
.75281 .02381 1.875 0 Mabsadd L
.75281 .02381 0 -2.5 Mabsadd L
.75281 .02381 -1.875 0 Mabsadd L closepath F
.77084 .5 -1.875 0 Mabsadd m
.77084 .5 0 2.5 Mabsadd L
.77084 .5 1.875 0 Mabsadd L
.77084 .5 0 -2.5 Mabsadd L
.77084 .5 -1.875 0 Mabsadd L closepath F
.78852 .5 -1.875 0 Mabsadd m
.78852 .5 0 2.5 Mabsadd L
.78852 .5 1.875 0 Mabsadd L
.78852 .5 0 -2.5 Mabsadd L
.78852 .5 -1.875 0 Mabsadd L closepath F
.80616 .5 -1.875 0 Mabsadd m
.80616 .5 0 2.5 Mabsadd L
.80616 .5 1.875 0 Mabsadd L
.80616 .5 0 -2.5 Mabsadd L
.80616 .5 -1.875 0 Mabsadd L closepath F
.82397 .5 -1.875 0 Mabsadd m
.82397 .5 0 2.5 Mabsadd L
.82397 .5 1.875 0 Mabsadd L
.82397 .5 0 -2.5 Mabsadd L
.82397 .5 -1.875 0 Mabsadd L closepath F
.84195 .5 -1.875 0 Mabsadd m
.84195 .5 0 2.5 Mabsadd L
.84195 .5 1.875 0 Mabsadd L
.84195 .5 0 -2.5 Mabsadd L
.84195 .5 -1.875 0 Mabsadd L closepath F
.86021 .02381 -1.875 0 Mabsadd m
.86021 .02381 0 2.5 Mabsadd L
.86021 .02381 1.875 0 Mabsadd L
.86021 .02381 0 -2.5 Mabsadd L
.86021 .02381 -1.875 0 Mabsadd L closepath F
.87883 .02381 -1.875 0 Mabsadd m
.87883 .02381 0 2.5 Mabsadd L
.87883 .02381 1.875 0 Mabsadd L
.87883 .02381 0 -2.5 Mabsadd L
.87883 .02381 -1.875 0 Mabsadd L closepath F
.89713 .02381 -1.875 0 Mabsadd m
.89713 .02381 0 2.5 Mabsadd L
.89713 .02381 1.875 0 Mabsadd L
.89713 .02381 0 -2.5 Mabsadd L
.89713 .02381 -1.875 0 Mabsadd L closepath F
.91522 .2619 -1.875 0 Mabsadd m
.91522 .2619 0 2.5 Mabsadd L
.91522 .2619 1.875 0 Mabsadd L
.91522 .2619 0 -2.5 Mabsadd L
.91522 .2619 -1.875 0 Mabsadd L closepath F
.933 .5 -1.875 0 Mabsadd m
.933 .5 0 2.5 Mabsadd L
.933 .5 1.875 0 Mabsadd L
.933 .5 0 -2.5 Mabsadd L
.933 .5 -1.875 0 Mabsadd L closepath F
.95056 .02381 -1.875 0 Mabsadd m
.95056 .02381 0 2.5 Mabsadd L
.95056 .02381 1.875 0 Mabsadd L
.95056 .02381 0 -2.5 Mabsadd L
.95056 .02381 -1.875 0 Mabsadd L closepath F
.96337 .2619 -1.875 0 Mabsadd m
.96337 .2619 0 2.5 Mabsadd L
.96337 .2619 1.875 0 Mabsadd L
.96337 .2619 0 -2.5 Mabsadd L
.96337 .2619 -1.875 0 Mabsadd L closepath F
.97619 .02381 -1.875 0 Mabsadd m
.97619 .02381 0 2.5 Mabsadd L
.97619 .02381 1.875 0 Mabsadd L
.97619 .02381 0 -2.5 Mabsadd L
.97619 .02381 -1.875 0 Mabsadd L closepath F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[107]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol003Uoo`8002Uo
o`@002]oo`03001oogoo02Qoo`8002]oo`8002Moo`@000=oo`8000=oo`00>7oo00@007ooOol002Qo
o`03001oogoo02aoo`03001oogoo02Moo`04001oogoo000YOol01000Oomoo`00:7oo00D007ooOomo
o`00009oo`40005oo`5oo`00>7oo00@007ooOol002Uoo`03001oogoo02Qoo`D002Qoo`04001oogoo
000YOol01000Oomoo`00:7oo00D007ooOomoo`00009oo`40005oo`5oo`00>7oo00@007ooOol002Yo
o`03001oogoo02Moo`04001oogoo000YOol3000[Ool2000YOol01@00Oomoogoo00000Woo0@000Goo
0Goo000hOol01000Oomoo`00:goo00<007ooOol09goo00<007oo0000:Goo00<007ooOol0:Woo00@0
07ooOol002Qoo`05001oogooOol00002Ool10001Ool1Ool003Qoo`04001oogoo000XOol01000Oomo
o`00:Woo0P00:Goo00<007ooOol0:Woo00@007ooOol002Ioo`<000=oo`04001oogoo0002Ool003Uo
o`8002Yoo`8002aoo`03001oogoo02Qoo`<002Yoo`8002Uoo`03001oogoo009oo`8000=oo`00ogoo
8Goo003oOolQOol00?moob5oo`00=7ooj`000Goo000dOol00`00Oomoo`03Ool00`00Oomoo`08Ool0
0`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool0
0`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`08Ool0
0`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`02Ool1
0001Ool003Aoo`03001oogoo0>Moo`40005oo`00;Goo0P001Goo00<007ooOol0igoo0@000Goo000/
Ool01000Oomoo`0017oo00<007ooOol00Woo0P0027oo0P0077oo0P001Woo0P002goo0P002Woo0P00
2goo0P001Woo0P000goo00<007ooOol01Goo0P001Woo0P000Woo0P000goo0P001Woo0P000goo00<0
07ooOol01Goo0P000Woo0P000Woo0P003goo0P005goo0P000goo0P000Woo0P002goo00<007ooOol0
0goo0P0017oo0@000Goo000/Ool01000Oomoo`0017oo0P000Woo0`001goo10006Woo100017oo1000
2Goo100027oo10002Goo0`001Goo100000Aoo`00000000Eoo`@000Aoo`P00004Ool000000005Ool4
000017oo000000001Goo30003Goo10005Goo100000=oo`0000001P002Goo0`000goo0`000goo0P00
0Goo000/Ool01000Oomoo`0017oo00<007ooOol00Woo0P0027oo0`006goo0`001Goo0`002Woo0`00
2Goo0`002Woo0P001Woo0`000Woo0P001Woo0`001Goo0`0000Aoo`000000009oo`8000Ioo`<0009o
o`8000Ioo`<00005Ool00000001oo`03000>Ool3000FOol30002Ool3000017oo000000002Woo0P00
17oo0P0017oo0@000Goo000/Ool01000Oomoo`0017oo00<007ooOol00goo00<007ooOol01goo00<0
07ooOol06goo00<007ooOol01Goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<0
07ooOol01Goo00D007ooOomoo`0000Qoo`03001oogoo00Eoo`05001oogooOol00004Ool00`00Oomo
o`05Ool01@00Oomoogoo000027oo00D007ooOomoo`0000=oo`03001oogoo00ioo`03001oogoo01Io
o`03001oogoo009oo`05001oogooOol0000;Ool00`00Oomoo`04Ool00`00Oomoo`02Ool10001Ool0
02aoo`04001oogoo0004Ool00`00Oomoo`3WOol10001Ool002eoo`8000Eoo`03001oogoo0>Moo`40
005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001o
ogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool0
03Aoo`03001oogoo0>Moo`40005oo`00=7oo0P00igoo0P000Goo000dOol00`00Oomoo`3WOol10001
Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomo
o`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000d
Ool00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo
0@000Goo000dOol2003WOol20001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0
igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo
00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40
005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`800>Mo
o`80005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03
001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001
Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomo
o`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo0P00igoo0P000Goo000dOol00`00
Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo
000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`003Goo0`000goo00D0
07ooOomoo`0000Ioo`@000=oo`8000eoo`03001oogoo0>Moo`40005oo`0047oo00L007ooOomoo`00
Ool00009Ool01@00Oomoogoo00000Woo00<007ooOol02Woo00<007ooOol0igoo0@000Goo000@Ool0
0`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00000Woo00<007ooOol02Woo00<007ooOol0
igoo0@000Goo000=Ool30004Ool00`00Ool00009Ool01@00Oomoogoo00000Woo00<007ooOol02Woo
00<007ooOol0igoo0@000Goo000=Ool00`00Oomoo`03Ool01@00Oomoogoo000027oo00D007ooOomo
o`00009oo`03001oogoo00Yoo`800>Moo`80005oo`003Goo00<007ooOol03Woo0`000goo00@007oo
Ool000aoo`03001oogoo0>Moo`40005oo`003Goo10003goo00<007ooOol00Woo0P0027oo0`000Woo
0P00j7oo0@000Goo000`Ool01000Oomoogoo0P00j7oo0@000Goo000ZOol30003Ool01000Oomoogoo
0P001Goo0P0000=oo`00Ool01goo0P0057oo0P007goo0P0087oo0P001Woo0P00;7oo0P000goo0P00
;7oo0P002Woo00<007ooOol01Woo0@000Goo000`Ool01`00Oomoogoo001oo`0000=oo`H000Ioo`<0
01=oo`@001eoo`@001ioo`@000Aoo`@002Yoo`@00004Ool00000000[Ool40008Ool30007Ool10001
Ool002moo`8000=oo`03001oo`0000Aoo`D000Moo`8001Aoo`<001ioo`<001moo`<000Eoo`<002]o
o`<0009oo`8002aoo`<000Uoo`8000Moo`40005oo`00<7oo00@007ooOomoo`<000Eoo`03001oo`00
00Uoo`03001oogoo01=oo`03001oogoo01ioo`03001oogoo01moo`03001oogoo00Eoo`03001oogoo
02]oo`03001oogoo009oo`03001oogoo02]oo`03001oogoo00Qoo`03001oogoo00Ioo`40005oo`00
=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`800>Moo`80005o
o`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo
0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Ao
o`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol1
0001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo0P00igoo0P000Goo000dOol00`00Oomoo`3W
Ool10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol0
0`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@00
0Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007oo
Ool0igoo0@000Goo000dOol2003WOol20001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<0
07ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005o
o`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo
0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Ao
o`800>Moo`80005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool0
03Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3W
Ool10001Ool003Aoo`03001oogoo0>Moo`40005oo`003Goo10000Woo00D007ooOomoo`0000Ioo`@0
00=oo`8000eoo`03001oogoo0>Moo`40005oo`003goo00<007ooOol00Woo00<007oo00002Goo00D0
07ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo0>Moo`40005oo`003goo00<007ooOol00goo
00<007ooOol027oo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo0>Moo`40005oo`00
3goo00<007ooOol00Woo00<007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`800>Mo
o`80005oo`003goo00D007ooOomoo`0000=oo`03001oogoo00Ioo`05001oogooOol00002Ool00`00
Oomoo`0:Ool00`00Oomoo`3WOol10001Ool000eoo`<000ioo`<000=oo`04001oogoo0007Ool30002
Ool2003XOol10001Ool000moo`03001oogoo00ioo`03001oogoo009oo`8000Uoo`07001oogooOol0
07oo0000igoo0@000Goo000ZOol30003Ool01000Oomoogoo0`00igoo0@000Goo000`Ool01@00Oomo
ogoo0000jGoo0@000Goo000_Ool20003Ool00`00Oomoo`3WOol10001Ool0031oo`04001oogooOol3
003WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol02Woo00<007ooOol0
1goo00D007ooOomoo`00009oo`05001oogooOol00003Ool00`00Oomoo`09Ool00`00Oomoo`05Ool0
1@00Oomoogoo000027oo00<007ooOol02Goo00D007ooOomoo`0002ioo`03001oogoo00Yoo`03001o
ogoo01Ioo`03001oogoo00Eoo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo0000
57oo00<007ooOol03Goo0@000Goo000dOol2000:Ool30007Ool300001Goo00000000Ool00P0000Eo
o`00000007oo00<000Uoo`<000Eoo`<0009oo`8000Ioo`<000Uoo`<0009oo`8002aoo`<000Yoo`80
01Moo`<000Ioo`80009oo`80009oo`<00005Ool00000001oo`03000COol2000=Ool20001Ool003Ao
o`03001oogoo00Qoo`@000Iooa<000Qoo`@000Aoo`@00004Ool000000005Ool40008Ool4000017oo
00000000:goo10002Goo0`005Woo10001Goo0`0000Eoo`00000007oo00`0019oo`<000ioo`40005o
o`00=7oo00<007ooOol02Goo0P0027oo0P000Woo0P000Woo00<007ooOol00P000Woo0P002Woo0P00
1Woo0P000goo00<007ooOol01Goo0P002Woo0P000goo00<007ooOol0:goo0P002goo0P005goo0P00
1goo00@007ooOomoo`80009oo`80009oo`80009oo`8001Aoo`03001oogoo00eoo`40005oo`00=7oo
00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40
005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001o
ogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol2003WOol20001Ool003Aoo`03
001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001
Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomo
o`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000d
Ool00`00Oomoo`3WOol10001Ool003Aoo`800>Moo`80005oo`00=7oo00<007ooOol0igoo0@000Goo
000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0
igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo
00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40
005oo`00=7oo0P00igoo0P000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Mo
o`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03
001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo00000goo000000020003Ool00`00
Oomoo`02Ool30003Ool01@00Oomoogoo00001Woo10000goo0P003Goo00<007ooOol0igoo0@000Goo
0003Ool00`00Oomoo`0:Ool01`00Oomoogoo001oo`0000Uoo`05001oogooOol00002Ool00`00Oomo
o`0:Ool00`00Oomoo`3WOol10001Ool000=oo`03001oogoo00Yoo`03001oogoo009oo`03001oogoo
00Qoo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3WOol10001Ool000=oo`03001o
ogoo00Moo`<000Aoo`03001oo`0000Uoo`05001oogooOol00002Ool00`00Oomoo`0:Ool2003WOol2
0001Ool000=oo`03001oogoo00Moo`03001oogoo00=oo`05001oogooOol00008Ool01@00Oomoogoo
00000Woo00<007ooOol02Woo00<007ooOol0igoo0@000Goo000017oo000000002Goo00<007ooOol0
3Woo0`000goo00@007ooOol000Moo`<0009oo`800>Qoo`40005oo`000goo00<007ooOol01goo1000
3goo00<007ooOol00Woo0P002Goo00L007ooOomoo`00Ool0003WOol10001Ool002Yoo`<000=oo`04
001oogooOol3003WOol10001Ool0031oo`05001oogooOol0003YOol10001Ool002moo`8000=oo`03
001oogoo0>Moo`40005oo`00<7oo00@007ooOomoo`<00>Moo`40005oo`00=7oo00<007ooOol0igoo
0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`800>Moo`80005oo`00=7oo00<007ooOol0
igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo
00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40
005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001o
ogoo0>Moo`40005oo`00=7oo0P00igoo0P000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03
001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001
Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomo
o`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo000d
Ool2003WOol20001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo0@000Goo
000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0
igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo
00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`800>Moo`80005oo`00
=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Mo
o`40005oo`00=7oo00<007ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03
001oogoo0>Moo`40005oo`003Goo10000Woo00D007ooOomoo`0000Ioo`@000=oo`8000eoo`03001o
ogoo0>Moo`40005oo`003Goo00<007ooOol017oo00<007oo00002Goo00D007ooOomoo`00009oo`03
001oogoo00Yoo`03001oogoo0>Moo`40005oo`003Woo00<007ooOol017oo00<007ooOol027oo00D0
07ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo0>Moo`40005oo`003goo00<007ooOol00Woo
00<007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`800>Moo`80005oo`0047oo00@0
07ooOol000=oo`03001oogoo00Ioo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3W
Ool10001Ool000eoo`04001oogoo000=Ool30003Ool01000Oomoo`001goo0`000Woo0P00j7oo0@00
0Goo000>Ool2000@Ool00`00Oomoo`02Ool20009Ool01`00Oomoogoo001oo`000>Moo`40005oo`00
:Woo0`000goo00@007ooOomoo`<00>Moo`40005oo`00<7oo00D007ooOomoo`000>Uoo`40005oo`00
;goo0P000goo00<007ooOol0igoo0@000Goo000`Ool01000Oomoogoo0`00igoo0@000Goo000dOol0
0`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo0P00igoo0P000Goo000d
Ool00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<007ooOol0igoo
0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005oo`00=7oo00<0
07ooOol0igoo0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo0>Moo`40005o
o`00=7oo00<007ooOol0igoo0@000Goo000dOol2003WOol20001Ool003Aoo`03001oogoo05aoo`80
08Uoo`40005oo`00=7oo00<007ooOol0Fgoo1000R7oo0@000Goo000dOol00`00Oomoo`1LOol30028
Ool10001Ool003Aoo`03001oogoo05eoo`03001oogoo08Moo`40005oo`00=7oo00<007ooOol0igoo
0@000Goo000dOol00`00Oomoo`3WOol10001Ool003Aoo`03001oogoo00=oo`03001oogoo00Qoo`03
001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03
001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03
001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Qoo`03
001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo009oo`40
005oo`00=7ooj`000Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo
8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol0
0?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {509.5, 150.75}} -> {-5.95875, \
8.2307*^-17, 0.0448438, 9.95734*^-19}}]
}, Open  ]],

Cell["\<\
Since the system is Hamiltonian (the invariant is the Hamiltonian), \
a symplectic integrator performs well on this problem giving a small bounded \
error.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(projerksol\  = \ 
        NDSolve[system, 
          Method \[Rule] {"\<SymplecticPartitionedRungeKutta\>", \
"\<DifferenceOrder\>" \[Rule] 8, "\<PositionVariables\>" \[Rule] {Y\_1[T]}}, 
          StartingStepSize \[Rule] 1/5];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(InvariantErrorPlot[invariant, vars, T, projerksol];\)\)}], "Input",
  CellLabel->"In[109]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0238095 5.31163e+12 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .1566 -49.5 -6.25 ]
[-0.0125 .1566 0 6.25 ]
[-0.0125 .28939 -37.5 -6.25 ]
[-0.0125 .28939 0 6.25 ]
[-0.0125 .42218 -49.5 -6.25 ]
[-0.0125 .42218 0 6.25 ]
[-0.0125 .55497 -37.5 -6.25 ]
[-0.0125 .55497 0 6.25 ]
[-0.0125 .68776 -55.5 -6.25 ]
[-0.0125 .68776 0 6.25 ]
[-0.0125 .82055 -49.5 -6.25 ]
[-0.0125 .82055 0 6.25 ]
[-0.0125 .95335 -55.5 -6.25 ]
[-0.0125 .95335 0 6.25 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .1566 m
.00625 .1566 L
s
gsave
-0.0125 .1566 -49.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-14) show
grestore
0 .28939 m
.00625 .28939 L
s
gsave
-0.0125 .28939 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-14) show
grestore
0 .42218 m
.00625 .42218 L
s
gsave
-0.0125 .42218 -49.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(7.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-14) show
grestore
0 .55497 m
.00625 .55497 L
s
gsave
-0.0125 .55497 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-13) show
grestore
0 .68776 m
.00625 .68776 L
s
gsave
-0.0125 .68776 -55.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.25) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-13) show
grestore
0 .82055 m
.00625 .82055 L
s
gsave
-0.0125 .82055 -49.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-13) show
grestore
0 .95335 m
.00625 .95335 L
s
gsave
-0.0125 .95335 -55.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.75) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-13) show
grestore
.125 Mabswid
0 .05037 m
.00375 .05037 L
s
0 .07693 m
.00375 .07693 L
s
0 .10348 m
.00375 .10348 L
s
0 .13004 m
.00375 .13004 L
s
0 .18316 m
.00375 .18316 L
s
0 .20972 m
.00375 .20972 L
s
0 .23627 m
.00375 .23627 L
s
0 .26283 m
.00375 .26283 L
s
0 .31595 m
.00375 .31595 L
s
0 .34251 m
.00375 .34251 L
s
0 .36907 m
.00375 .36907 L
s
0 .39562 m
.00375 .39562 L
s
0 .44874 m
.00375 .44874 L
s
0 .4753 m
.00375 .4753 L
s
0 .50186 m
.00375 .50186 L
s
0 .52841 m
.00375 .52841 L
s
0 .58153 m
.00375 .58153 L
s
0 .60809 m
.00375 .60809 L
s
0 .63465 m
.00375 .63465 L
s
0 .66121 m
.00375 .66121 L
s
0 .71432 m
.00375 .71432 L
s
0 .74088 m
.00375 .74088 L
s
0 .76744 m
.00375 .76744 L
s
0 .794 m
.00375 .794 L
s
0 .84711 m
.00375 .84711 L
s
0 .87367 m
.00375 .87367 L
s
0 .90023 m
.00375 .90023 L
s
0 .92679 m
.00375 .92679 L
s
0 .9799 m
.00375 .9799 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.21429 .99375 m
.21429 1 L
s
.40476 .99375 m
.40476 1 L
s
.59524 .99375 m
.59524 1 L
s
.78571 .99375 m
.78571 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.07143 .99625 m
.07143 1 L
s
.11905 .99625 m
.11905 1 L
s
.16667 .99625 m
.16667 1 L
s
.2619 .99625 m
.2619 1 L
s
.30952 .99625 m
.30952 1 L
s
.35714 .99625 m
.35714 1 L
s
.45238 .99625 m
.45238 1 L
s
.5 .99625 m
.5 1 L
s
.54762 .99625 m
.54762 1 L
s
.64286 .99625 m
.64286 1 L
s
.69048 .99625 m
.69048 1 L
s
.7381 .99625 m
.7381 1 L
s
.83333 .99625 m
.83333 1 L
s
.88095 .99625 m
.88095 1 L
s
.92857 .99625 m
.92857 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .1566 m
1 .1566 L
s
.99375 .28939 m
1 .28939 L
s
.99375 .42218 m
1 .42218 L
s
.99375 .55497 m
1 .55497 L
s
.99375 .68776 m
1 .68776 L
s
.99375 .82055 m
1 .82055 L
s
.99375 .95335 m
1 .95335 L
s
.125 Mabswid
.99625 .05037 m
1 .05037 L
s
.99625 .07693 m
1 .07693 L
s
.99625 .10348 m
1 .10348 L
s
.99625 .13004 m
1 .13004 L
s
.99625 .18316 m
1 .18316 L
s
.99625 .20972 m
1 .20972 L
s
.99625 .23627 m
1 .23627 L
s
.99625 .26283 m
1 .26283 L
s
.99625 .31595 m
1 .31595 L
s
.99625 .34251 m
1 .34251 L
s
.99625 .36907 m
1 .36907 L
s
.99625 .39562 m
1 .39562 L
s
.99625 .44874 m
1 .44874 L
s
.99625 .4753 m
1 .4753 L
s
.99625 .50186 m
1 .50186 L
s
.99625 .52841 m
1 .52841 L
s
.99625 .58153 m
1 .58153 L
s
.99625 .60809 m
1 .60809 L
s
.99625 .63465 m
1 .63465 L
s
.99625 .66121 m
1 .66121 L
s
.99625 .71432 m
1 .71432 L
s
.99625 .74088 m
1 .74088 L
s
.99625 .76744 m
1 .76744 L
s
.99625 .794 m
1 .794 L
s
.99625 .84711 m
1 .84711 L
s
.99625 .87367 m
1 .87367 L
s
.99625 .90023 m
1 .90023 L
s
.99625 .92679 m
1 .92679 L
s
.99625 .9799 m
1 .9799 L
s
.25 Mabswid
1 0 m
1 1 L
s
.0001 w
.02381 .02381 -1.875 0 Mabsadd m
.02381 .02381 0 2.5 Mabsadd L
.02381 .02381 1.875 0 Mabsadd L
.02381 .02381 0 -2.5 Mabsadd L
.02381 .02381 -1.875 0 Mabsadd L closepath F
.04286 .06096 -1.875 0 Mabsadd m
.04286 .06096 0 2.5 Mabsadd L
.04286 .06096 1.875 0 Mabsadd L
.04286 .06096 0 -2.5 Mabsadd L
.04286 .06096 -1.875 0 Mabsadd L closepath F
.0619 .1677 -1.875 0 Mabsadd m
.0619 .1677 0 2.5 Mabsadd L
.0619 .1677 1.875 0 Mabsadd L
.0619 .1677 0 -2.5 Mabsadd L
.0619 .1677 -1.875 0 Mabsadd L closepath F
.08095 .3281 -1.875 0 Mabsadd m
.08095 .3281 0 2.5 Mabsadd L
.08095 .3281 1.875 0 Mabsadd L
.08095 .3281 0 -2.5 Mabsadd L
.08095 .3281 -1.875 0 Mabsadd L closepath F
.1 .51445 -1.875 0 Mabsadd m
.1 .51445 0 2.5 Mabsadd L
.1 .51445 1.875 0 Mabsadd L
.1 .51445 0 -2.5 Mabsadd L
.1 .51445 -1.875 0 Mabsadd L closepath F
.11905 .69903 -1.875 0 Mabsadd m
.11905 .69903 0 2.5 Mabsadd L
.11905 .69903 1.875 0 Mabsadd L
.11905 .69903 0 -2.5 Mabsadd L
.11905 .69903 -1.875 0 Mabsadd L closepath F
.1381 .85235 -1.875 0 Mabsadd m
.1381 .85235 0 2.5 Mabsadd L
.1381 .85235 1.875 0 Mabsadd L
.1381 .85235 0 -2.5 Mabsadd L
.1381 .85235 -1.875 0 Mabsadd L closepath F
.15714 .94965 -1.875 0 Mabsadd m
.15714 .94965 0 2.5 Mabsadd L
.15714 .94965 1.875 0 Mabsadd L
.15714 .94965 0 -2.5 Mabsadd L
.15714 .94965 -1.875 0 Mabsadd L closepath F
.17619 .97619 -1.875 0 Mabsadd m
.17619 .97619 0 2.5 Mabsadd L
.17619 .97619 1.875 0 Mabsadd L
.17619 .97619 0 -2.5 Mabsadd L
.17619 .97619 -1.875 0 Mabsadd L closepath F
.19524 .92783 -1.875 0 Mabsadd m
.19524 .92783 0 2.5 Mabsadd L
.19524 .92783 1.875 0 Mabsadd L
.19524 .92783 0 -2.5 Mabsadd L
.19524 .92783 -1.875 0 Mabsadd L closepath F
.21429 .81225 -1.875 0 Mabsadd m
.21429 .81225 0 2.5 Mabsadd L
.21429 .81225 1.875 0 Mabsadd L
.21429 .81225 0 -2.5 Mabsadd L
.21429 .81225 -1.875 0 Mabsadd L closepath F
.23333 .64713 -1.875 0 Mabsadd m
.23333 .64713 0 2.5 Mabsadd L
.23333 .64713 1.875 0 Mabsadd L
.23333 .64713 0 -2.5 Mabsadd L
.23333 .64713 -1.875 0 Mabsadd L closepath F
.25238 .45902 -1.875 0 Mabsadd m
.25238 .45902 0 2.5 Mabsadd L
.25238 .45902 1.875 0 Mabsadd L
.25238 .45902 0 -2.5 Mabsadd L
.25238 .45902 -1.875 0 Mabsadd L closepath F
.27143 .27738 -1.875 0 Mabsadd m
.27143 .27738 0 2.5 Mabsadd L
.27143 .27738 1.875 0 Mabsadd L
.27143 .27738 0 -2.5 Mabsadd L
.27143 .27738 -1.875 0 Mabsadd L closepath F
.29048 .13114 -1.875 0 Mabsadd m
.29048 .13114 0 2.5 Mabsadd L
.29048 .13114 1.875 0 Mabsadd L
.29048 .13114 0 -2.5 Mabsadd L
.29048 .13114 -1.875 0 Mabsadd L closepath F
.30952 .04268 -1.875 0 Mabsadd m
.30952 .04268 0 2.5 Mabsadd L
.30952 .04268 1.875 0 Mabsadd L
.30952 .04268 0 -2.5 Mabsadd L
.30952 .04268 -1.875 0 Mabsadd L closepath F
.32857 .02735 -1.875 0 Mabsadd m
.32857 .02735 0 2.5 Mabsadd L
.32857 .02735 1.875 0 Mabsadd L
.32857 .02735 0 -2.5 Mabsadd L
.32857 .02735 -1.875 0 Mabsadd L closepath F
.34762 .08573 -1.875 0 Mabsadd m
.34762 .08573 0 2.5 Mabsadd L
.34762 .08573 1.875 0 Mabsadd L
.34762 .08573 0 -2.5 Mabsadd L
.34762 .08573 -1.875 0 Mabsadd L closepath F
.36667 .21075 -1.875 0 Mabsadd m
.36667 .21075 0 2.5 Mabsadd L
.36667 .21075 1.875 0 Mabsadd L
.36667 .21075 0 -2.5 Mabsadd L
.36667 .21075 -1.875 0 Mabsadd L closepath F
.38571 .38117 -1.875 0 Mabsadd m
.38571 .38117 0 2.5 Mabsadd L
.38571 .38117 1.875 0 Mabsadd L
.38571 .38117 0 -2.5 Mabsadd L
.38571 .38117 -1.875 0 Mabsadd L closepath F
.40476 .56988 -1.875 0 Mabsadd m
.40476 .56988 0 2.5 Mabsadd L
.40476 .56988 1.875 0 Mabsadd L
.40476 .56988 0 -2.5 Mabsadd L
.40476 .56988 -1.875 0 Mabsadd L closepath F
.42381 .74797 -1.875 0 Mabsadd m
.42381 .74797 0 2.5 Mabsadd L
.42381 .74797 1.875 0 Mabsadd L
.42381 .74797 0 -2.5 Mabsadd L
.42381 .74797 -1.875 0 Mabsadd L closepath F
.44286 .88714 -1.875 0 Mabsadd m
.44286 .88714 0 2.5 Mabsadd L
.44286 .88714 1.875 0 Mabsadd L
.44286 .88714 0 -2.5 Mabsadd L
.44286 .88714 -1.875 0 Mabsadd L closepath F
.4619 .96558 -1.875 0 Mabsadd m
.4619 .96558 0 2.5 Mabsadd L
.4619 .96558 1.875 0 Mabsadd L
.4619 .96558 0 -2.5 Mabsadd L
.4619 .96558 -1.875 0 Mabsadd L closepath F
.48095 .97029 -1.875 0 Mabsadd m
.48095 .97029 0 2.5 Mabsadd L
.48095 .97029 1.875 0 Mabsadd L
.48095 .97029 0 -2.5 Mabsadd L
.48095 .97029 -1.875 0 Mabsadd L closepath F
.5 .9013 -1.875 0 Mabsadd m
.5 .9013 0 2.5 Mabsadd L
.5 .9013 1.875 0 Mabsadd L
.5 .9013 0 -2.5 Mabsadd L
.5 .9013 -1.875 0 Mabsadd L closepath F
.51905 .76861 -1.875 0 Mabsadd m
.51905 .76861 0 2.5 Mabsadd L
.51905 .76861 1.875 0 Mabsadd L
.51905 .76861 0 -2.5 Mabsadd L
.51905 .76861 -1.875 0 Mabsadd L closepath F
.5381 .59347 -1.875 0 Mabsadd m
.5381 .59347 0 2.5 Mabsadd L
.5381 .59347 1.875 0 Mabsadd L
.5381 .59347 0 -2.5 Mabsadd L
.5381 .59347 -1.875 0 Mabsadd L closepath F
.55714 .40417 -1.875 0 Mabsadd m
.55714 .40417 0 2.5 Mabsadd L
.55714 .40417 1.875 0 Mabsadd L
.55714 .40417 0 -2.5 Mabsadd L
.55714 .40417 -1.875 0 Mabsadd L closepath F
.57619 .22962 -1.875 0 Mabsadd m
.57619 .22962 0 2.5 Mabsadd L
.57619 .22962 1.875 0 Mabsadd L
.57619 .22962 0 -2.5 Mabsadd L
.57619 .22962 -1.875 0 Mabsadd L closepath F
.59524 .0987 -1.875 0 Mabsadd m
.59524 .0987 0 2.5 Mabsadd L
.59524 .0987 1.875 0 Mabsadd L
.59524 .0987 0 -2.5 Mabsadd L
.59524 .0987 -1.875 0 Mabsadd L closepath F
.61429 .03089 -1.875 0 Mabsadd m
.61429 .03089 0 2.5 Mabsadd L
.61429 .03089 1.875 0 Mabsadd L
.61429 .03089 0 -2.5 Mabsadd L
.61429 .03089 -1.875 0 Mabsadd L closepath F
.63333 .03737 -1.875 0 Mabsadd m
.63333 .03737 0 2.5 Mabsadd L
.63333 .03737 1.875 0 Mabsadd L
.63333 .03737 0 -2.5 Mabsadd L
.63333 .03737 -1.875 0 Mabsadd L closepath F
.65238 .11698 -1.875 0 Mabsadd m
.65238 .11698 0 2.5 Mabsadd L
.65238 .11698 1.875 0 Mabsadd L
.65238 .11698 0 -2.5 Mabsadd L
.65238 .11698 -1.875 0 Mabsadd L closepath F
.67143 .25674 -1.875 0 Mabsadd m
.67143 .25674 0 2.5 Mabsadd L
.67143 .25674 1.875 0 Mabsadd L
.67143 .25674 0 -2.5 Mabsadd L
.67143 .25674 -1.875 0 Mabsadd L closepath F
.69048 .43543 -1.875 0 Mabsadd m
.69048 .43543 0 2.5 Mabsadd L
.69048 .43543 1.875 0 Mabsadd L
.69048 .43543 0 -2.5 Mabsadd L
.69048 .43543 -1.875 0 Mabsadd L closepath F
.70952 .62413 -1.875 0 Mabsadd m
.70952 .62413 0 2.5 Mabsadd L
.70952 .62413 1.875 0 Mabsadd L
.70952 .62413 0 -2.5 Mabsadd L
.70952 .62413 -1.875 0 Mabsadd L closepath F
.72857 .79397 -1.875 0 Mabsadd m
.72857 .79397 0 2.5 Mabsadd L
.72857 .79397 1.875 0 Mabsadd L
.72857 .79397 0 -2.5 Mabsadd L
.72857 .79397 -1.875 0 Mabsadd L closepath F
.74762 .91722 -1.875 0 Mabsadd m
.74762 .91722 0 2.5 Mabsadd L
.74762 .91722 1.875 0 Mabsadd L
.74762 .91722 0 -2.5 Mabsadd L
.74762 .91722 -1.875 0 Mabsadd L closepath F
.76667 .97442 -1.875 0 Mabsadd m
.76667 .97442 0 2.5 Mabsadd L
.76667 .97442 1.875 0 Mabsadd L
.76667 .97442 0 -2.5 Mabsadd L
.76667 .97442 -1.875 0 Mabsadd L closepath F
.78571 .95732 -1.875 0 Mabsadd m
.78571 .95732 0 2.5 Mabsadd L
.78571 .95732 1.875 0 Mabsadd L
.78571 .95732 0 -2.5 Mabsadd L
.78571 .95732 -1.875 0 Mabsadd L closepath F
.80476 .86768 -1.875 0 Mabsadd m
.80476 .86768 0 2.5 Mabsadd L
.80476 .86768 1.875 0 Mabsadd L
.80476 .86768 0 -2.5 Mabsadd L
.80476 .86768 -1.875 0 Mabsadd L closepath F
.82381 .72085 -1.875 0 Mabsadd m
.82381 .72085 0 2.5 Mabsadd L
.82381 .72085 1.875 0 Mabsadd L
.82381 .72085 0 -2.5 Mabsadd L
.82381 .72085 -1.875 0 Mabsadd L closepath F
.84286 .53804 -1.875 0 Mabsadd m
.84286 .53804 0 2.5 Mabsadd L
.84286 .53804 1.875 0 Mabsadd L
.84286 .53804 0 -2.5 Mabsadd L
.84286 .53804 -1.875 0 Mabsadd L closepath F
.8619 .35051 -1.875 0 Mabsadd m
.8619 .35051 0 2.5 Mabsadd L
.8619 .35051 1.875 0 Mabsadd L
.8619 .35051 0 -2.5 Mabsadd L
.8619 .35051 -1.875 0 Mabsadd L closepath F
.88095 .18598 -1.875 0 Mabsadd m
.88095 .18598 0 2.5 Mabsadd L
.88095 .18598 1.875 0 Mabsadd L
.88095 .18598 0 -2.5 Mabsadd L
.88095 .18598 -1.875 0 Mabsadd L closepath F
.9 .07099 -1.875 0 Mabsadd m
.9 .07099 0 2.5 Mabsadd L
.9 .07099 1.875 0 Mabsadd L
.9 .07099 0 -2.5 Mabsadd L
.9 .07099 -1.875 0 Mabsadd L closepath F
.91905 .0244 -1.875 0 Mabsadd m
.91905 .0244 0 2.5 Mabsadd L
.91905 .0244 1.875 0 Mabsadd L
.91905 .0244 0 -2.5 Mabsadd L
.91905 .0244 -1.875 0 Mabsadd L closepath F
.9381 .05271 -1.875 0 Mabsadd m
.9381 .05271 0 2.5 Mabsadd L
.9381 .05271 1.875 0 Mabsadd L
.9381 .05271 0 -2.5 Mabsadd L
.9381 .05271 -1.875 0 Mabsadd L closepath F
.95714 .15237 -1.875 0 Mabsadd m
.95714 .15237 0 2.5 Mabsadd L
.95714 .15237 1.875 0 Mabsadd L
.95714 .15237 0 -2.5 Mabsadd L
.95714 .15237 -1.875 0 Mabsadd L closepath F
.97619 .30628 -1.875 0 Mabsadd m
.97619 .30628 0 2.5 Mabsadd L
.97619 .30628 1.875 0 Mabsadd L
.97619 .30628 0 -2.5 Mabsadd L
.97619 .30628 -1.875 0 Mabsadd L closepath F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[109]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol003ioo`8002Uoo`@002Uoo`03001oogoo02Qoo`8002Uoo`8002Ioo`@000=o
o`8000=oo`00?Goo00@007ooOol002Qoo`03001oogoo02Yoo`03001oogoo02Moo`04001oogoo000W
Ool01000Oomoo`009goo00D007ooOomoo`00009oo`40005oo`5oo`00?Goo00@007ooOol002Uoo`03
001oogoo02Ioo`D002Qoo`04001oogoo000WOol01000Oomoo`009goo00D007ooOomoo`00009oo`40
005oo`5oo`00?Goo00@007ooOol002Yoo`03001oogoo02Eoo`04001oogoo000YOol3000YOol2000X
Ool01@00Oomoogoo00000Woo0@000Goo0Goo000mOol01000Oomoo`00:goo00<007ooOol09Goo00<0
07oo0000:Goo00<007ooOol0:7oo00@007ooOol002Moo`05001oogooOol00002Ool10001Ool1Ool0
03eoo`04001oogoo000XOol01000Oomoo`00:7oo0P00:Goo00<007ooOol0:7oo00@007ooOol002Eo
o`<000=oo`04001oogoo0002Ool003ioo`8002Yoo`8002Yoo`03001oogoo02Qoo`<002Qoo`8002Qo
o`03001oogoo009oo`8000=oo`00ogoo8Goo003oOolQOol00?moob5oo`00>Wooi@000Goo000jOol0
0`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool0
0`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool0
0`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`08Ool0
0`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool0
0`00Oomoo`08Ool00`00Oomoo`02Ool10001Ool003Yoo`03001oogoo0>5oo`40005oo`00<goo0P00
1Goo00<007ooOol0hGoo0@000Goo000bOol01000Oomoo`0017oo00@007ooOomoo`800<]oo`03001o
ogoo011oo`40005oo`00<Woo00@007ooOol000Aoo`800003Ool00000008004=oo`80041oo`03001o
ogoo045oo`<0011oo`80005oo`00<Woo00@007ooOol000Aoo`04001oogooOol30012Ool4000nOol3
0013Ool2000AOol10001Ool0039oo`04001oogoo0004Ool00`00Oomoo`02Ool00`00Oomoo`12Ool3
000mOol400000goo00000010Ool00`00Oomoo`0@Ool10001Ool0039oo`04001oogoo0004Ool00`00
Oomoo`13Ool00`00Oomoo`02Ool00`00Oomoo`0mOol200000goo00000002001BOol10001Ool003=o
o`8000Eoo`03001oogoo04=oo`8004Moo`<0059oo`40005oo`00>Woo00<007ooOol0@Woo0`00B7oo
00<007ooOol0@goo00<007ooOol02goo0@000Goo000jOol20014Ool00`00Oomoo`2<Ool3000;Ool2
0001Ool003Yoo`03001oogoo00Moo`03001oogoo0<Moo`@000aoo`40005oo`00>Woo00<007ooOol0
1Woo0`00bGoo0P003Goo0@000Goo000jOol00`00Oomoo`05Ool4003HOol10001Ool003Yoo`03001o
ogoo00Ioo`800<5oo`8001Ioo`40005oo`00>Woo00<007ooOol0b7oo10005Goo0@000Goo000jOol2
003:Ool3000DOol20001Ool003Yoo`03001oogoo04]oo`8007eoo`03001oogoo01Aoo`40005oo`00
>Woo00<007ooOol0BWoo1000Tgoo0@000Goo000jOol00`00Oomoo`1;Ool3002COol10001Ool003Yo
o`03001oogoo04aoo`03001oogoo03Eoo`8005]oo`40005oo`00>Woo00<007ooOol0Pgoo0`00Fgoo
0@000Goo000jOol20025Ool2001JOol20001Ool003Yoo`03001oogoo08Eoo`03001oogoo05Uoo`40
005oo`00>Woo00<007ooOol0TWoo00<007ooOol0C7oo0@000Goo000jOol00`00Oomoo`2AOol3001=
Ool10001Ool003Yoo`03001oogoo091oo`@004eoo`40005oo`00>Woo00<007ooOol0?goo00<007oo
Ool0Cgoo0P00CWoo0@000Goo000jOol00`00Oomoo`0nOol3002POol10001Ool003Yoo`8003ioo`@0
09moo`80005oo`00>Woo00<007ooOol0?Woo0P00XGoo0@000Goo0007Ool40003Ool00`00Oomoo`02
Ool30003Ool01@00Oomoogoo00001Woo10000goo0P003Goo00<007ooOol0hGoo0@000Goo0007Ool0
0`00Oomoo`0<Ool01`00Oomoogoo001oo`0000Uoo`05001oogooOol00002Ool00`00Oomoo`0:Ool0
0`00Oomoo`3GOol00`00Oomoo`07Ool10001Ool000Qoo`03001oogoo00]oo`03001oogoo009oo`03
001oogoo00Qoo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3FOol30008Ool10001
Ool000Uoo`03001oogoo00Moo`<000Aoo`03001oo`0000Uoo`05001oogooOol00002Ool00`00Oomo
o`0:Ool00`00Oomoo`3EOol40008Ool10001Ool000Yoo`03001oogoo00Ioo`03001oogoo00=oo`05
001oogooOol00008Ool01@00Oomoogoo00000Woo00<007ooOol02Woo0P00egoo0P0027oo0P000Goo
0007Ool01000Oomoo`0027oo00<007ooOol03Woo0`000goo00@007ooOol000aoo`03001oogoo00Yo
o`800=Eoo`40005oo`0027oo0P002Goo10003goo00<007ooOol00Woo0P0027oo0`000Woo0P002Woo
1000e7oo0@000Goo000fOol01000Oomoogoo0P002goo0`00e7oo0@000Goo000`Ool30003Ool00`00
Oomoo`04000;Ool00`00Oomoo`3COol10001Ool003Ioo`03001oogoo00<00<Ioo`8001Yoo`40005o
o`00=Goo0P000goo0P00aGoo100067oo0P000Goo000fOol01000Oomoogoo0P00aWoo0`006Goo0@00
0Goo000jOol00`00Oomoo`36Ool00`00Oomoo`0HOol10001Ool003Yoo`03001oogoo0>5oo`40005o
o`00>Woo00<007ooOol0D7oo00<007ooOol0SWoo0@000Goo000jOol00`00Oomoo`1@Ool2002?Ool1
0001Ool003Yoo`80051oo`<008ioo`80005oo`00>Woo00<007ooOol0D7oo00<007ooOol0SWoo0@00
0Goo000jOol00`00Oomoo`3QOol10001Ool003Yoo`03001oogoo07moo`80061oo`40005oo`00>Woo
00<007ooOol0OWoo1000Ggoo0@000Goo000jOol00`00Oomoo`1oOol3001OOol10001Ool003Yoo`80
085oo`03001oogoo05eoo`80005oo`00>Woo00<007ooOol0hGoo0@000Goo000jOol00`00Oomoo`3Q
Ool10001Ool003Yoo`03001oogoo09Eoo`8004Yoo`40005oo`00>Woo00<007ooOol0U7oo1000BGoo
0@000Goo000jOol00`00Oomoo`2EOol30019Ool10001Ool003Yoo`8009Moo`03001oogoo04Moo`80
005oo`00>Woo00<007ooOol0hGoo0@000Goo000jOol00`00Oomoo`0jOol2002UOol10001Ool001=o
o`<000=oo`05001oogooOol00006Ool40003Ool2000=Ool00`00Oomoo`0iOol4002TOol10001Ool0
01Ioo`07001oogooOol007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo
03Yoo`<00:Aoo`40005oo`005Woo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`00009o
o`03001oogoo00Yoo`03001oogoo03]oo`03001oogoo0:=oo`40005oo`004goo0`0017oo00<007oo
00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`800>5oo`80005oo`004goo00<007ooOol0
0goo00D007ooOomoo`0000Qoo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3QOol1
0001Ool001=oo`03001oogoo00ioo`<000=oo`04001oogoo0007Ool30002Ool2003MOol00`00Oomo
o`02Ool10001Ool001=oo`@000moo`03001oogoo009oo`8000Uoo`04001oogooOol2003LOol20004
Ool10001Ool0031oo`<000=oo`03001oogoo00@00=Yoo`<000Aoo`40005oo`00=Woo00<007ooOol0
0`00g7oo0P0017oo0@000Goo000eOol20003Ool2003QOol20001Ool003Ioo`04001oogooOol2000@
Ool00`00Oomoo`3?Ool10001Ool003Yoo`03001oogoo00ioo`<00=1oo`40005oo`00>Woo00<007oo
Ool03Goo1000d7oo0@000Goo000jOol00`00Oomoo`0>Ool2003AOol10001Ool003Yoo`03001oogoo
0>5oo`40005oo`00>Woo0P00`Woo00<007ooOol077oo0P000Goo000jOol00`00Oomoo`31Ool2000N
Ool10001Ool003Yoo`03001oogoo0<1oo`<001ioo`40005oo`00>Woo00<007ooOol0`Goo00<007oo
Ool07Goo0@000Goo000jOol00`00Oomoo`3QOol10001Ool003Yoo`03001oogoo0>5oo`40005oo`00
>Woo0P00hGoo0P000Goo000jOol00`00Oomoo`1EOol00`00Oomoo`29Ool10001Ool003Yoo`03001o
ogoo05Aoo`<008Yoo`40005oo`00>Woo00<007ooOol0Dgoo1000RWoo0@000Goo000jOol00`00Oomo
o`1DOol2002;Ool10001Ool003Yoo`03001oogoo0>5oo`40005oo`00>Woo0P00hGoo0P000Goo000j
Ool00`00Oomoo`1kOol2001TOol10001Ool003Yoo`03001oogoo07Yoo`@006=oo`40005oo`0027oo
00<007ooOol00goo00<007ooOol00Woo0`000goo00D007ooOomoo`0000Ioo`@000=oo`8000eoo`03
001oogoo07]oo`<006=oo`40005oo`0027oo00<007ooOol02goo00L007ooOomoo`00Ool00009Ool0
1@00Oomoogoo00000Woo00<007ooOol02Woo00<007ooOol0O7oo00<007ooOol0HWoo0@000Goo0009
Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00000Woo00<007oo
Ool02Woo00<007ooOol0hGoo0@000Goo0009Ool00`00Oomoo`07Ool30004Ool00`00Ool00009Ool0
1@00Oomoogoo00000Woo00<007ooOol02Woo0P00hGoo0P000Goo000:Ool00`00Oomoo`06Ool00`00
Oomoo`03Ool01@00Oomoogoo000027oo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo
0>5oo`40005oo`001goo00@007ooOol000Qoo`03001oogoo00ioo`<000=oo`04001oogoo0007Ool3
0002Ool2002JOol20016Ool10001Ool000Moo`@000Qoo`@000moo`03001oogoo009oo`8000Uoo`04
001oogooOol2002IOol40015Ool10001Ool0031oo`<000=oo`03001oogoo00@009Uoo`<004Eoo`40
005oo`00=Woo00<007ooOol00`00Vgoo00<007ooOol0A7oo0@000Goo000eOol20003Ool2003QOol2
0001Ool003Ioo`04001oogooOol2000gOol00`00Oomoo`2XOol10001Ool003Yoo`03001oogoo03Io
o`800:Uoo`40005oo`00>Woo00<007ooOol0=Goo0`00ZGoo0@000Goo000jOol00`00Oomoo`0fOol0
0`00Oomoo`2XOol10001Ool003Yoo`03001oogoo0>5oo`40005oo`00>Woo0P00hGoo0P000Goo000j
Ool00`00Oomoo`3QOol10001Ool003Yoo`03001oogoo0>5oo`40005oo`00>Woo00<007ooOol0hGoo
0@000Goo000jOol00`00Oomoo`3QOol10001Ool003Yoo`03001oogoo0>5oo`40005oo`00>Woo0P00
hGoo0P000Goo000jOol00`00Oomoo`3QOol10001Ool003Yoo`03001oogoo01=oo`800<aoo`40005o
o`00>Woo00<007ooOol04Woo1000bgoo0@000Goo000jOol00`00Oomoo`0COol3003;Ool10001Ool0
03Yoo`03001oogoo01Aoo`03001oogoo0<Yoo`40005oo`00>Woo0P00hGoo0P000Goo000jOol00`00
Oomoo`2mOol00`00Oomoo`0QOol10001Ool003Yoo`03001oogoo0;aoo`<0029oo`40005oo`004goo
10000Woo00D007ooOomoo`0000Ioo`@000=oo`8000eoo`03001oogoo0;]oo`@0029oo`40005oo`00
5Goo00<007ooOol00Woo00<007oo00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001o
ogoo0;aoo`8002=oo`40005oo`005Goo00<007ooOol00goo00<007ooOol027oo00D007ooOomoo`00
009oo`03001oogoo00Yoo`03001oogoo0>5oo`40005oo`005Goo00<007ooOol00Woo00<007oo0000
2Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`800>5oo`80005oo`005Goo00D007ooOomoo`00
00=oo`03001oogoo00Ioo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3QOol10001
Ool001=oo`<000ioo`<000=oo`04001oogoo0007Ool30002Ool2001JOol00`00Oomoo`25Ool10001
Ool001Eoo`03001oogoo00ioo`03001oogoo009oo`8000Uoo`07001oogooOol007oo0000F7oo0`00
QWoo0@000Goo000`Ool30003Ool01`00Oomoogoo001oo`0005Moo`@008Ioo`40005oo`00=Woo00@0
07ooOomoo`<005Qoo`8008Moo`40005oo`00=Goo0P000goo00<007oo0000hGoo0@000Goo000fOol0
1000Oomoogoo0P00hGoo0P000Goo000jOol00`00Oomoo`1gOol2001XOol10001Ool003Yoo`03001o
ogoo07Ioo`<006Qoo`40005oo`00>Woo00<007ooOol0Mgoo0P00J7oo0@000Goo000jOol00`00Oomo
o`1hOol00`00Oomoo`1VOol10001Ool003Yoo`03001oogoo0>5oo`40005oo`00>Woo0P00hGoo0P00
0Goo000jOol00`00Oomoo`3QOol10001Ool003Yoo`03001oogoo09ioo`80045oo`40005oo`00>Woo
00<007ooOol0WGoo1000@7oo0@000Goo000jOol00`00Oomoo`2NOol30010Ool10001Ool003Yoo`03
001oogoo09moo`03001oogoo03moo`40005oo`00>Woo0P00hGoo0P000Goo000jOol00`00Oomoo`0a
Ool2002^Ool10001Ool003Yoo`03001oogoo031oo`@00:eoo`40005oo`00>Woo00<007ooOol0<Goo
0`00[Goo0@000Goo000jOol00`00Oomoo`0bOol00`00Oomoo`2/Ool10001Ool003Yoo`03001oogoo
0>5oo`40005oo`00>Woo0P00hGoo0P000Goo000jOol00`00Oomoo`3QOol10001Ool00003Ool00000
008000=oo`03001oogoo009oo`@0009oo`<000=oo`05001oogooOol00006Ool40003Ool2000=Ool0
0`00Oomoo`3QOol10001Ool000=oo`03001oogoo00Moo`03001oogoo00Ioo`07001oogooOol007oo
00002Goo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo0>5oo`40005oo`000goo00<0
07ooOol027oo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`00009o
o`03001oogoo00Yoo`03001oogoo0>5oo`40005oo`000goo00<007ooOol02Goo00@007ooOomoo`<0
00Aoo`03001oo`0000Uoo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3QOol10001
Ool000=oo`03001oogoo00Yoo`04001oogoo0005Ool01@00Oomoogoo000027oo00D007ooOomoo`00
009oo`03001oogoo00Yoo`800>5oo`80005oo`0000Aoo`00000000Uoo`04001oogoo0002Ool00`00
Oomoo`0>Ool30003Ool01000Oomoo`0037oo00<007ooOol05goo0P00b7oo0@000Goo0003Ool00`00
Oomoo`08Ool20003Ool4000?Ool00`00Oomoo`02Ool20008Ool30002Ool2000GOol40037Ool10001
Ool003Ioo`07001oogooOol007oo00005goo0`00agoo0@000Goo000`Ool30003Ool01`00Oomoogoo
001oo`0001Qoo`03001oogoo0<Ioo`40005oo`00=Woo00@007ooOomoo`<00>5oo`40005oo`00=Goo
0P000goo0`00^7oo0P009Woo0P000Goo000fOol01000Oomoogoo0P00^7oo10009Woo0@000Goo000j
Ool00`00Oomoo`2hOol3000VOol10001Ool003Yoo`03001oogoo0;Uoo`03001oogoo02Eoo`40005o
o`00>Woo00<007ooOol0hGoo0@000Goo000jOol00`00Oomoo`3QOol10001Ool003Yoo`8005ioo`80
085oo`80005oo`00>Woo00<007ooOol0G7oo0`00PWoo0@000Goo000jOol00`00Oomoo`1MOol20022
Ool10001Ool003Yoo`03001oogoo05ioo`03001oogoo081oo`40005oo`00>Woo00<007ooOol0hGoo
0@000Goo000jOol00`00Oomoo`1bOol2001]Ool10001Ool003Yoo`80079oo`@006]oo`80005oo`00
>Woo00<007ooOol0LWoo0`00K7oo0@000Goo000jOol00`00Oomoo`1cOol00`00Oomoo`1[Ool10001
Ool003Yoo`03001oogoo0>5oo`40005oo`00>Woo00<007ooOol0Xgoo00<007ooOol0>goo0@000Goo
000jOol00`00Oomoo`2ROol3000lOol10001Ool003Yoo`800:9oo`@003]oo`80005oo`00>Woo00<0
07ooOol0XWoo0P00?Goo0@000Goo000jOol00`00Oomoo`3QOol10001Ool000Moo`@000=oo`03001o
ogoo009oo`<000=oo`05001oogooOol00006Ool40003Ool2000=Ool00`00Oomoo`0]Ool2002bOol1
0001Ool000Uoo`03001oogoo00Yoo`07001oogooOol007oo00002Goo00D007ooOomoo`00009oo`03
001oogoo00Yoo`03001oogoo02aoo`@00;5oo`40005oo`002Goo00<007ooOol02Woo00<007ooOol0
0Woo00<007ooOol027oo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo02eoo`<00;5o
o`40005oo`002Goo00<007ooOol01goo0`0017oo00<007oo00002Goo00D007ooOomoo`00009oo`03
001oogoo00Yoo`8002moo`03001oogoo0:moo`80005oo`002Goo00<007ooOol01goo00<007ooOol0
0goo00D007ooOomoo`0000Qoo`05001oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomoo`3QOol1
0001Ool000Moo`<000Uoo`03001oogoo00ioo`<000=oo`04001oogoo0007Ool30002Ool2003ROol1
0001Ool000Uoo`03001oogoo00Moo`@000moo`03001oogoo009oo`8000Uoo`07001oogooOol007oo
0000hGoo0@000Goo000`Ool30003Ool01`00Oomoogoo001oo`000>5oo`40005oo`00=Woo00@007oo
Oomoo`<00>5oo`40005oo`00=Goo0P000goo0`006goo0P00`goo0P000Goo000fOol01000Oomoogoo
0P006goo1000`goo0@000Goo000jOol00`00Oomoo`0KOol30033Ool10001Ool003Yoo`03001oogoo
01aoo`03001oogoo09Eoo`03001oogoo02Yoo`40005oo`00>Woo00<007ooOol0]7oo0P00:goo0@00
0Goo000jOol00`00Oomoo`2cOol3000[Ool10001Ool003Yoo`800;Eoo`03001oogoo02Uoo`80005o
o`00>Woo00<007ooOol0hGoo0@000Goo000jOol00`00Oomoo`1QOol2001nOol10001Ool003Yoo`03
001oogoo061oo`@007eoo`40005oo`00>Woo00<007ooOol0HGoo0`00OGoo0@000Goo000jOol00`00
Oomoo`1ROol00`00Oomoo`09Ool2001aOol10001Ool003Yoo`8006ioo`@006moo`80005oo`00>Woo
00<007ooOol0KWoo0`00L7oo0@000Goo000jOol00`00Oomoo`1_Ool00`00Oomoo`1_Ool10001Ool0
03Yoo`03001oogoo0:Ioo`8003Uoo`40005oo`00>Woo00<007ooOol0YGoo1000>7oo0@000Goo000j
Ool00`00Oomoo`0YOol00`00Oomoo`1jOol3000hOol10001Ool003Yoo`8002Yoo`8007aoo`03001o
ogoo03Ioo`80005oo`00>Woo00<007ooOol0:7oo0`00]Woo0@000Goo000jOol00`00Oomoo`0YOol0
0`00Oomoo`2eOol10001Ool00003Ool00000008000=oo`03001oogoo00=oo`03001oogoo009oo`<0
00=oo`05001oogooOol00006Ool40003Ool2000=Ool00`00Oomoo`3QOol10001Ool000=oo`03001o
ogoo00Qoo`03001oogoo00Eoo`07001oogooOol007oo00002Goo00D007ooOomoo`00009oo`03001o
ogoo00Yoo`03001oogoo021oo`800;moo`40005oo`000goo00<007ooOol02Goo00<007ooOol017oo
00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`00009oo`03001oogoo00Yoo`03001oogoo
01moo`@00;ioo`40005oo`000goo00<007ooOol02Goo00@007ooOomoo`<000Aoo`03001oo`0000Uo
o`05001oogooOol00002Ool00`00Oomoo`0:Ool2000QOol3002<Ool2000_Ool20001Ool000=oo`03
001oogoo00Yoo`04001oogoo0005Ool01@00Oomoogoo000027oo00D007ooOomoo`00009oo`03001o
ogoo00Yoo`03001oogoo025oo`03001oogoo08Yoo`@002moo`40005oo`0000Aoo`00000000Uoo`04
001oogoo0002Ool00`00Oomoo`0>Ool30003Ool01000Oomoo`001goo0`000Woo0P00IWoo0P00B7oo
0`00;goo0@000Goo0003Ool00`00Oomoo`07Ool40002Ool4000?Ool00`00Oomoo`02Ool20009Ool0
1`00Oomoogoo001oo`0006Aoo`@0009oo`8004Aoo`03001oogoo02ioo`40005oo`00<7oo0`000goo
00L007ooOomoo`00Ool0000UOol00`00Oomoo`0mOol3000017oo00000000?goo0P00=7oo0@000Goo
000fOol01000Oomoogoo0`0097oo0`00?goo00@007ooOomoo`8003ioo`@003=oo`40005oo`00=Goo
0P000goo0`008goo1000A7oo00<007ooOol0?Goo0`00<Woo0P000Goo000fOol01000Oomoogoo0P00
9Goo0P00QWoo00<007ooOol0<Woo0@000Goo000jOol00`00Oomoo`3QOol10001Ool003Yoo`03001o
ogoo0>5oo`40005oo`00>Woo00<007ooOol00Woo00<007ooOol027oo00<007ooOol027oo00<007oo
Ool027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol01goo00<007ooOol027oo00<007oo
Ool027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007oo
Ool01goo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007oo
Ool027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol00Woo0@000Goo000jOooU0001Ool0
0?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo
8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol0
0?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo
8Goo0000\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {523.562, 164.812}} -> {-6.38338, \
7.51635*^-14, 0.046037, 8.25449*^-16}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Perturbed Kepler problem", "Subsection"],

Cell["\<\
This loads a Hamiltonian system known as the perturbed Kepler \
problem, sets the integration interval and the step size to take as well as \
defining the position variables in the Hamiltonian formalism.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(system\  = \ 
        GetNDSolveProblem["\<PerturbedKepler\>"];\)\), "\[IndentingNewLine]", \

    \(\(time\  = \ system["\<TimeData\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(step\  = \ 3/100;\)\), "\[IndentingNewLine]", 
    \(pvars\  = \ Take[system["\<DependentVariables\>"[]], \ 2]\)}], "Input",
  CellLabel->"In[17]:="],

Cell[BoxData[
    \({Y\_1[T], Y\_2[T]}\)], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell[TextData[{
  "The system has two invariants which ar defined as ",
  StyleBox["H", "MR"],
  " and ",
  StyleBox["L", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({L, H}\  = \ system["\<Invariants\>"[]]\)], "Input",
  CellLabel->"In[21]:="],

Cell[BoxData[
    \({\(-\(1\/\(400\ \((Y\_1[T]\^2 + Y\_2[T]\^2)\)\^\(3/2\)\)\)\) - 
        1\/\@\(Y\_1[T]\^2 + Y\_2[T]\^2\) + 
        1\/2\ \((Y\_3[T]\^2 + Y\_4[T]\^2)\), \(-Y\_2[T]\)\ Y\_3[T] + 
        Y\_1[T]\ Y\_4[T]}\)], "Output",
  CellLabel->"Out[21]="]
}, Open  ]],

Cell[TextData[{
  "An experiment now illustrates the importance of using all the available \
invariants in the projective process (see [",
  ButtonBox["H02",
    ButtonData:>{"References.nb", "H02"},
    ButtonStyle->"Hyperlink"],
  "] ). Consider the solutions obtained using:"
}], "Text"],

Cell[TextData[{
  "The method ",
  StyleBox["ExplicitEuler", "MR"],
  "."
}], "BulletedList"],

Cell[TextData[{
  "The method ",
  StyleBox["Projection", "MR"],
  " with ",
  StyleBox["ExplicitEuler", "MR"],
  ", projecting onto the invariant L."
}], "BulletedList"],

Cell[TextData[{
  "The method ",
  StyleBox["Projection", "MR"],
  " with ",
  StyleBox["ExplicitEuler", "MR"],
  ", projecting onto the invariant H."
}], "BulletedList"],

Cell[TextData[{
  "The method ",
  StyleBox["Projection", "MR"],
  " with ",
  StyleBox["ExplicitEuler", "MR"],
  ", projecting onto both the invariants H and L."
}], "BulletedList"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(sol\  = \ 
        NDSolve[system, \ Method \[Rule] "\<ExplicitEuler\>", \ 
          StartingStepSize \[Rule] step];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(ParametricPlot[Evaluate[pvars\  /. \ First[sol]], \ 
        Evaluate[time]];\)\)}], "Input",
  CellLabel->"In[24]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.949046 0.0475891 0.313153 0.137327 [
[.23521 .30065 -9 -9 ]
[.23521 .30065 9 0 ]
[.47315 .30065 -9 -9 ]
[.47315 .30065 9 0 ]
[.7111 .30065 -6 -9 ]
[.7111 .30065 6 0 ]
[.93655 .0385 -12 -4.5 ]
[.93655 .0385 0 4.5 ]
[.93655 .17583 -12 -4.5 ]
[.93655 .17583 0 4.5 ]
[.93655 .45048 -6 -4.5 ]
[.93655 .45048 0 4.5 ]
[.93655 .58781 -6 -4.5 ]
[.93655 .58781 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23521 .31315 m
.23521 .3194 L
s
[(-15)] .23521 .30065 0 1 Mshowa
.47315 .31315 m
.47315 .3194 L
s
[(-10)] .47315 .30065 0 1 Mshowa
.7111 .31315 m
.7111 .3194 L
s
[(-5)] .7111 .30065 0 1 Mshowa
.125 Mabswid
.04485 .31315 m
.04485 .3169 L
s
.09244 .31315 m
.09244 .3169 L
s
.14003 .31315 m
.14003 .3169 L
s
.18762 .31315 m
.18762 .3169 L
s
.2828 .31315 m
.2828 .3169 L
s
.33039 .31315 m
.33039 .3169 L
s
.37798 .31315 m
.37798 .3169 L
s
.42557 .31315 m
.42557 .3169 L
s
.52074 .31315 m
.52074 .3169 L
s
.56833 .31315 m
.56833 .3169 L
s
.61592 .31315 m
.61592 .3169 L
s
.66351 .31315 m
.66351 .3169 L
s
.75869 .31315 m
.75869 .3169 L
s
.80628 .31315 m
.80628 .3169 L
s
.85387 .31315 m
.85387 .3169 L
s
.90146 .31315 m
.90146 .3169 L
s
.99663 .31315 m
.99663 .3169 L
s
.25 Mabswid
0 .31315 m
1 .31315 L
s
.94905 .0385 m
.9553 .0385 L
s
[(-2)] .93655 .0385 1 0 Mshowa
.94905 .17583 m
.9553 .17583 L
s
[(-1)] .93655 .17583 1 0 Mshowa
.94905 .45048 m
.9553 .45048 L
s
[(1)] .93655 .45048 1 0 Mshowa
.94905 .58781 m
.9553 .58781 L
s
[(2)] .93655 .58781 1 0 Mshowa
.125 Mabswid
.94905 .06596 m
.9528 .06596 L
s
.94905 .09343 m
.9528 .09343 L
s
.94905 .1209 m
.9528 .1209 L
s
.94905 .14836 m
.9528 .14836 L
s
.94905 .20329 m
.9528 .20329 L
s
.94905 .23076 m
.9528 .23076 L
s
.94905 .25822 m
.9528 .25822 L
s
.94905 .28569 m
.9528 .28569 L
s
.94905 .34062 m
.9528 .34062 L
s
.94905 .36808 m
.9528 .36808 L
s
.94905 .39555 m
.9528 .39555 L
s
.94905 .42301 m
.9528 .42301 L
s
.94905 .47794 m
.9528 .47794 L
s
.94905 .50541 m
.9528 .50541 L
s
.94905 .53287 m
.9528 .53287 L
s
.94905 .56034 m
.9528 .56034 L
s
.94905 .01103 m
.9528 .01103 L
s
.94905 .61527 m
.9528 .61527 L
s
.25 Mabswid
.94905 0 m
.94905 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.96808 .31315 m
.96633 .34653 L
.9615 .37283 L
.95395 .39587 L
.94621 .41156 L
.93906 .42212 L
.93263 .42937 L
.92585 .43525 L
.91897 .43966 L
.9124 .44264 L
.90567 .44457 L
.89963 .44542 L
.89434 .44554 L
.88843 .445 L
.8852 .44443 L
.88228 .44374 L
.87711 .44214 L
.87183 .44 L
.86199 .4347 L
.85222 .42773 L
.83645 .41283 L
.82314 .39645 L
.8124 .38035 L
.79331 .34366 L
.77774 .30227 L
.77172 .28143 L
.76649 .2593 L
.76266 .23886 L
.75999 .2203 L
.75895 .21104 L
.75816 .20245 L
.75752 .19359 L
.75726 .18894 L
.75704 .18395 L
.75688 .1793 L
.75682 .17668 L
.75677 .17425 L
.75674 .17169 L
.75673 .16938 L
.75673 .16672 L
.75675 .16422 L
.75682 .1598 L
.75693 .15576 L
.757 .15367 L
.7571 .15137 L
.75733 .14677 L
.75792 .13839 L
.75862 .13089 L
.75956 .12298 L
.76079 .11457 L
Mistroke
.76352 .10021 L
.76675 .0873 L
.77112 .0737 L
.77597 .06187 L
.78099 .05201 L
.78693 .0426 L
.7942 .03362 L
.80162 .02668 L
.81042 .02079 L
.8158 .01826 L
.81833 .01732 L
.82107 .01647 L
.82354 .01586 L
.82487 .01558 L
.82632 .01533 L
.82891 .01499 L
.83139 .01479 L
.83281 .01473 L
.83439 .01472 L
.83606 .01475 L
.83764 .01484 L
.8405 .01511 L
.84213 .01534 L
.84363 .01559 L
.8495 .01698 L
.85291 .01807 L
.85612 .01929 L
.86261 .0223 L
.86891 .02593 L
.88122 .03503 L
.8958 .04933 L
.91115 .06891 L
.92894 .09855 L
.93866 .1188 L
.94927 .14549 L
.95836 .174 L
.9631 .19223 L
.9678 .21413 L
.97004 .22681 L
.97224 .24176 L
.97517 .271 L
.97606 .28905 L
.97619 .30929 L
.97539 .32877 L
.97389 .34626 L
.96897 .37784 L
.96535 .39362 L
.96165 .40674 L
.95444 .42739 L
.94641 .44561 L
Mistroke
.93222 .47072 L
.91945 .4885 L
.89246 .51704 L
.86656 .53715 L
.84467 .5505 L
.80469 .56889 L
.77078 .58014 L
.7361 .58863 L
.71777 .59213 L
.70139 .59476 L
.66968 .59868 L
.65357 .60016 L
.63693 .60136 L
.62272 .60214 L
.60969 .60267 L
.6023 .6029 L
.59561 .60306 L
.59194 .60313 L
.58796 .6032 L
.58422 .60325 L
.58078 .60328 L
.5776 .6033 L
.57428 .60331 L
.57144 .60332 L
.56836 .60332 L
.56503 .60331 L
.56318 .6033 L
.56149 .60328 L
.55823 .60326 L
.55515 .60322 L
.54924 .60313 L
.54383 .60303 L
.5317 .60273 L
.51955 .60232 L
.50634 .60177 L
.48011 .60035 L
.43338 .59686 L
.38499 .59213 L
.29377 .58065 L
.2103 .56777 L
.13322 .55426 L
.05404 .53905 L
Mfstroke
.05404 .53905 m
0 .52791 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[24]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo4Goo00<007oo
Ool03Goo003oOolAOol00`00Oomoo`0=Ool00?mooa5oo`03001oogoo00eoo`00ogoo4Goo0P003Woo
003[Ool9000LOol00`00Oomoo`0=Ool00>Uoo`8000Uoo`8001Yoo`03001oogoo00eoo`00igoo0P00
3Goo0P0067oo00<007ooOol03Goo003UOol2000AOol2000FOol00`00Oomoo`0=Ool00>Aoo`03001o
ogoo01=oo`03001oogoo01=oo`03001oogoo00eoo`00hgoo00<007ooOol05Goo00<007ooOol02Goo
10001Goo00<007ooOol03Goo003ROol00`00Oomoo`0GOol00`00Oomoo`08Ool00`00Oomoo`06Ool0
0`00Oomoo`0=Ool00>9oo`03001oogoo01Qoo`03001oogoo00Qoo`03001oogoo00Eoo`8000ioo`00
hGoo00<007ooOol06Woo00<007ooOol0100017oo00<007ooOol017oo00<007ooOol03Goo003POol0
0`00Oomoo`0LOol00`00Oomoo`08Ool00`00Oomoo`03Ool00`00Oomoo`0=Ool00=moo`03001oogoo
01ioo`03001oogoo00Aoo`04001oogoo0005Ool00`00Oomoo`0=Ool00=moo`03001oogoo01moo`03
001oogoo00Aoo`8000Ioo`03001oogoo00eoo`00gWoo00<007ooOol08Goo00<007ooOol02goo00<0
07ooOol03Goo003NOol00`00Oomoo`0ROol00`00Oomoo`0:Ool00`00Oomoo`0=Ool00=ioo`03001o
ogoo02=oo`03001oogoo00Uoo`8000ioo`00gWoo00<007ooOol097oo00<007ooOol027oo00<007oo
Ool03Goo003MOol00`00Oomoo`0VOol00`00Oomoo`07Ool00`00Oomoo`0=Ool00=eoo`03001oogoo
02Ioo`03001oogoo00Moo`03001oogoo00eoo`00gGoo00<007ooOol09goo00<007ooOol01Woo00<0
07ooOol03Goo003LOol00`00Oomoo`0XOol00`00Oomoo`06Ool00`00Oomoo`0=Ool00=aoo`03001o
ogoo02Uoo`03001oogoo00Eoo`03001oogoo00eoo`00fgoo00<007ooOol0:Woo00<007ooOol01Goo
00<007ooOol03Goo003KOol00`00Oomoo`0[Ool00`00Oomoo`04Ool2000>Ool00=Yoo`03001oogoo
02aoo`03001oogoo00Aoo`03001oogoo00eoo`00fWoo00<007ooOol0;Goo00<007ooOol00goo00<0
07ooOol03Goo003JOol00`00Oomoo`0]Ool00`00Oomoo`03Ool00`00Oomoo`0=Ool00=Yoo`03001o
ogoo02ioo`03001oogoo009oo`03001oogoo00eoo`00fWoo00<007ooOol0;Woo00<007ooOol00Woo
00<007ooOol03Goo003JOol00`00Oomoo`0_Ool01@00Oomoogoo00003goo003JOol00`00Oomoo`0_
Ool01@00Oomoogoo00003goo003IOol00`00Oomoo`0aOol00`00Oomoo`02000>Ool00=Uoo`03001o
ogoo035oo`04001oogoo000?Ool00=Uoo`03001oogoo039oo`03001oo`0000moo`00fGoo00<007oo
Ool0<Woo00<007oo00003goo003IOol00`00Oomoo`0cOol2000?Ool00=Uoo`03001oogoo03=oo`80
00moo`00fGoo00<007ooOol0=7oo00<007ooOol03Goo003IOol00`00Oomoo`0dOol00`00Oomoo`0=
Ool00=Uoo`03001oogoo03Aoo`8000ioo`00fGoo00<007ooOol0=7oo00<007ooOol03Goo003IOol0
0`00Oomoo`0dOol2000>Ool00=Uoo`03001oogoo03Aoo`8000ioo`00fGoo00<007ooOol0=7oo0P00
3Woo003IOol00`00Oomoo`0dOol2000>Ool00=Uoo`03001oogoo02]oo`@000Eoo`03001oo`0000eo
o`00fGoo00<007ooOol0;Goo00<007ooOol017oo00<007oo00003Goo003IOol00`00Oomoo`0]Ool0
0`00Oomoo`04Ool3000=Ool00=Uoo`03001oogoo02Eoo`@000Aoo`03001oogoo00Aoo`04001oogoo
000<Ool00=Uoo`03001oogoo02eoo`03001oogoo00Aoo`04001oogoo000<Ool00=Uoo`03001oogoo
02]oo`<000Ioo`04001oogoo000<Ool00=Uoo`03001oogoo02eoo`03001oogoo00Aoo`05001oogoo
Ool0000;Ool00=Uoo`03001oogoo03Aoo`05001oogooOol0000;Ool00=Uoo`03001oogoo03Aoo`05
001oogooOol0000;Ool00=Uoo`03001oogoo03Aoo`05001oogooOol0000;Ool00=Uoo`03001oogoo
03Aoo`80009oo`03001oogoo00Uoo`00fGoo00<007ooOol0=7oo00<007ooOol00Woo00<007ooOol0
27oo003IOol00`00Oomoo`0dOol00`00Oomoo`02Ool00`00Oomoo`08Ool00=Uoo`03001oogoo03Ao
o`03001oogoo009oo`03001oogoo00Qoo`00fGoo00<007ooOol0=7oo00<007ooOol00Woo00<007oo
Ool027oo003IOol00`00Oomoo`0dOol00`00Oomoo`03Ool00`00Oomoo`07Ool00=Uoo`03001oogoo
03Aoo`03001oogoo00=oo`03001oogoo00Moo`00fGoo00<007ooOol0=7oo00<007ooOol00goo00<0
07ooOol01goo003JOol00`00Oomoo`0cOol20004Ool00`00Oomoo`07Ool00=Yoo`03001oogoo03=o
o`03001oogoo00=oo`03001oogoo00Moo`00fWoo00<007ooOol0<goo00<007ooOol00goo00<007oo
Ool01goo003JOol00`00Oomoo`0cOol00`00Oomoo`03Ool00`00Oomoo`07Ool00=Yoo`03001oogoo
03=oo`03001oogoo00=oo`03001oogoo00Moo`00fWoo00<007ooOol0<goo00<007ooOol00goo00<0
07ooOol01goo003KOol00`00Oomoo`0bOol00`00Oomoo`03Ool00`00Oomoo`07Ool00=]oo`03001o
ogoo039oo`8000Aoo`03001oogoo00Moo`00fgoo00<007ooOol0<Woo00<007ooOol017oo00<007oo
Ool01Woo003KOol00`00Oomoo`0bOol00`00Oomoo`04Ool00`00Oomoo`06Ool00=aoo`03001oogoo
035oo`03001oogoo00Aoo`03001oogoo00Ioo`00g7oo00<007ooOol0<Goo00<007ooOol017oo00<0
07ooOol01Woo003LOol00`00Oomoo`0aOol00`00Oomoo`04Ool00`00Oomoo`06Ool0045oo`@0009o
o`<003]oo`@000=oo`8003ioo`<000ioo`03001oogoo031oo`03001oogoo00Aoo`03001oogoo00Io
o`00@goo00<007ooOol017oo00<007ooOol0>Woo00D007ooOomoo`00009oo`03001oogoo03ioo`03
001oogoo00]oo`03001oogoo031oo`03001oogoo00Aoo`03001oogoo00Ioo`00@goo00<007ooOol0
17oo00<007ooOol0>Woo00D007ooOomoo`00009oo`03001oogoo03ioo`03001oogoo00]oo`03001o
ogoo031oo`8000Eoo`03001oogoo00Ioo`00>goo100017oo00@007ooOomoo`<003Eoo`@000Aoo`05
001oogooOol00002Ool00`00Oomoo`0eOol40002Ool3000?Ool00`00Oomoo`0_Ool00`00Oomoo`04
Ool00`00Oomoo`06Ool004=oo`05001oogooOol0000oOol01@00Oomoogoo00000Woo00<007ooOol0
>goo00<007ooOol03goo00<007ooOol0;goo00<007ooOol017oo00<007ooOol01Woo0011Ool30003
Ool00`00Oomoo`0kOol30003Ool01000Oomoo`00?Goo00<007ooOol03goo00<007ooOol0;goo00<0
07ooOol017oo00<007ooOol01Woo0013Ool01000Oomoogoo1000?7oo00<007ooOol00Woo0P00?Woo
10003goo00<007ooOol0;Woo00<007ooOol017oo00<007ooOol01Woo003OOol00`00Oomoo`0^Ool0
0`00Oomoo`04Ool00`00Oomoo`06Ool00=moo`03001oogoo02ioo`03001oogoo00Aoo`03001oogoo
00Ioo`00h7oo00<007ooOol0;Goo00<007ooOol017oo00<007ooOol01Woo003o000P0001Ool000eo
o`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00]o
o`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00]o
o`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00]o
o`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]o
o`03001oogoo009oo`03001oo`0000Eoo`40005oo`5oo`00@goo00<007ooOol0@Goo00<007ooOol0
@Goo00<007ooOol04goo00<007ooOol0;7oo00<007ooOol00Woo00<007oo000027oo003QOol00`00
Oomoo`0/Ool00`00Oomoo`02Ool00`00Ool00008Ool00>5oo`03001oogoo02aoo`03001oogoo009o
o`03001oo`0000Qoo`00hWoo00<007ooOol0:goo00<007ooOol00Woo00<007oo000027oo003ROol0
0`00Oomoo`0[Ool00`00Oomoo`02Ool00`00Ool00008Ool00>9oo`03001oogoo02]oo`03001oogoo
009oo`03001oo`0000Qoo`00hgoo00<007ooOol0:Woo0P000goo00<007oo000027oo003SOol00`00
Oomoo`0ZOol00`00Oomoo`02Ool00`00Ool00008Ool00>=oo`03001oogoo02Yoo`03001oogoo009o
o`03001oo`0000Qoo`00i7oo00<007ooOol0:Goo00<007ooOol00Woo00<007oo000027oo003TOol0
0`00Oomoo`0YOol01@00Oomoogoo00000Woo00<007ooOol01Woo003UOol00`00Oomoo`0XOol01`00
Oomoogoo001oo`0000Uoo`00iGoo00<007ooOol0:7oo00L007ooOomoo`00Ool00009Ool00>Ioo`03
001oogoo02Moo`07001oogooOol007oo00002Goo003VOol00`00Oomoo`0WOol200001Goo001oogoo
00002Goo003WOol00`00Oomoo`0VOol01P00Oomoo`00Ool000Yoo`00igoo00<007ooOol09Woo00H0
07ooOol007oo000:Ool00>Qoo`03001oogoo02Eoo`03001oo`00009oo`03001oogoo00Qoo`00jGoo
00<007ooOol097oo00<007oo00000Woo00<007ooOol027oo003ZOol00`00Oomoo`0SOol00`00Ool0
0002Ool00`00Oomoo`08Ool00>Yoo`03001oogoo02=oo`05001oo`00Ool0000;Ool00>]oo`03001o
ogoo029oo`80009oo`03001oogoo00Uoo`00k7oo00<007ooOol08Goo0P000Woo00<007ooOol02Goo
003]Ool00`00Oomoo`0POol20002Ool00`00Oomoo`09Ool00>eoo`03001oogoo021oo`04001oogoo
000<Ool00>ioo`03001oogoo01moo`04001oogoo000<Ool00>ioo`03001oogoo01ioo`80009oo`03
001oogoo00Yoo`00kgoo00<007ooOol077oo00D007oo001oo`0000eoo`00l7oo00<007ooOol06goo
00D007oo001oo`0000eoo`00lGoo0P006Woo00H007ooOol007oo000=Ool00?=oo`03001oogoo01Io
o`04001oogooOol2000>Ool00?Aoo`03001oogoo01Aoo`03001oogoo009oo`8000ioo`00mGoo0P00
4goo00<007ooOol00goo0P003Woo003gOol00`00Oomoo`0>Ool20006Ool00`00Oomoo`0=Ool00?Qo
o`03001oogoo00]oo`8000Qoo`03001oogoo00eoo`00nGoo0`0027oo0P002Goo0P003goo003lOol8
0003Ool40004Ool2000?Ool00?moo`Yoo`03001oogoo009oo`03001oo`0000moo`00ogoo2Woo00<0
07ooOol00Woo00@007oo000000ioo`00ogoo2Woo00D007ooOomoo`00009oo`03001oogoo00eoo`00
ogoo2Woo00D007ooOomoo`00009oo`03001oogoo00eoo`00ogoo27oo0`000Woo00D007ooOomoo`00
00moo`00ogoo2Woo00@007ooOol000=oo`03001oogoo00eoo`00ogoo37oo00<007ooOol00Woo00<0
07ooOol03Goo003oOol;Ool00`00Oomoo`03Ool00`00Oomoo`0=Ool00?moo`Yoo`03001oogoo00Ao
o`8000ioo`00ogoo2Woo00<007ooOol017oo00<007ooOol03Goo003oOol9Ool00`00Oomoo`05Ool0
0`00Oomoo`0=Ool00?moo`Qoo`03001oogoo00Ioo`03001oogoo00eoo`00ogoo1goo00<007ooOol0
1goo00<007ooOol03Goo003oOol6Ool00`00Oomoo`08Ool00`00Oomoo`0=Ool00?moo`Eoo`03001o
ogoo00Uoo`03001oogoo00eoo`00ogoo17oo00<007ooOol02Woo00<007ooOol03Goo003oOol4Ool0
0`00Oomoo`0:Ool2000>Ool00?moo`=oo`03001oogoo00]oo`03001oogoo00eoo`00ogoo0Woo00<0
07ooOol037oo00<007ooOol03Goo003oOol1Ool00`00Oomoo`0=Ool00`00Oomoo`0=Ool00?moo`03
001oogoo00ioo`03001oogoo00eoo`00oGoo0P004Goo00<007ooOol03Goo003lOol00`00Oomoo`0A
Ool00`00Oomoo`0=Ool000<00?Qoo`03001oogoo019oo`03001oogoo00eoo`000goo1@00lGoo0P00
5Goo0P003Woo0008Ool5003[Ool00`00Oomoo`0EOol00`00Oomoo`0=Ool000eoo`D00>Aoo`8001Qo
o`03001oogoo00eoo`004Woo1P00gGoo00<007ooOol067oo00<007ooOol03Goo000HOol6003EOol2
000KOol00`00Oomoo`0=Ool001ioo`H00<eoo`8001eoo`03001oogoo00eoo`0097oo1@00aWoo0P00
7goo00<007ooOol03Goo000YOol6002mOol3000QOol00`00Oomoo`0=Ool002moo`D00;Ioo`8002Ao
o`8000ioo`00=7oo1P00[Woo0P009Woo00<007ooOol03Goo000jOol5002VOol3000XOol00`00Oomo
o`0=Ool003moo`H009ioo`8002]oo`03001oogoo00eoo`00AGoo1P00UWoo0P00;Goo00<007ooOol0
3Goo001;Ool6002>Ool2000_Ool00`00Oomoo`0=Ool0055oo`P0089oo`@002Qoo`@000Eoo`03001o
ogoo00eoo`00FGoo2000MGoo1@00;7oo00<007ooOol01Woo00<007ooOol03Goo001QOol9001VOol6
000bOol00`00Oomoo`05Ool2000>Ool006Yoo`/005Ioo`D003Uoo`03001oogoo00Aoo`03001oogoo
00eoo`00MGoo3P00@Woo1P00?goo00<007ooOol00goo00<007ooOol03Goo0023Ool:000/Ool<0012
Ool01000Oomoo`001Goo00<007ooOol03Goo002=Ool/001?Ool20006Ool00`00Oomoo`0=Ool00?mo
oa5oo`03001oogoo00eoo`00ogoo4Goo00<007ooOol03Goo003oOolAOol00`00Oomoo`0=Ool00?mo
oa5oo`8000ioo`00\
\>"],
  ImageRangeCache->{{{0, 358.75}, {221.125, 0}} -> {-19.9686, -2.28037, \
0.0733984, 0.0254354}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(sol\  = \ 
        NDSolve[system, \ 
          Method \[Rule] {"\<Projection\>", \ 
              Method -> "\<ExplicitEuler\>", \[IndentingNewLine]"\<Invariants\
\>" \[Rule] {H}}, \ StartingStepSize \[Rule] step];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(ParametricPlot[Evaluate[pvars\  /. \ First[sol]], \ 
        Evaluate[time]];\)\)}], "Input",
  CellLabel->"In[26]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.927542 0.121621 0.544578 0.0836897 [
[.19782 .53208 -6 -9 ]
[.19782 .53208 6 0 ]
[.44106 .53208 -6 -9 ]
[.44106 .53208 6 0 ]
[.6843 .53208 -6 -9 ]
[.6843 .53208 6 0 ]
[.91504 .04244 -12 -4.5 ]
[.91504 .04244 0 4.5 ]
[.91504 .12613 -12 -4.5 ]
[.91504 .12613 0 4.5 ]
[.91504 .20982 -12 -4.5 ]
[.91504 .20982 0 4.5 ]
[.91504 .29351 -12 -4.5 ]
[.91504 .29351 0 4.5 ]
[.91504 .3772 -12 -4.5 ]
[.91504 .3772 0 4.5 ]
[.91504 .46089 -12 -4.5 ]
[.91504 .46089 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.19782 .54458 m
.19782 .55083 L
s
[(-6)] .19782 .53208 0 1 Mshowa
.44106 .54458 m
.44106 .55083 L
s
[(-4)] .44106 .53208 0 1 Mshowa
.6843 .54458 m
.6843 .55083 L
s
[(-2)] .6843 .53208 0 1 Mshowa
.125 Mabswid
.25863 .54458 m
.25863 .54833 L
s
.31944 .54458 m
.31944 .54833 L
s
.38025 .54458 m
.38025 .54833 L
s
.50187 .54458 m
.50187 .54833 L
s
.56268 .54458 m
.56268 .54833 L
s
.62349 .54458 m
.62349 .54833 L
s
.74511 .54458 m
.74511 .54833 L
s
.80592 .54458 m
.80592 .54833 L
s
.86673 .54458 m
.86673 .54833 L
s
.13701 .54458 m
.13701 .54833 L
s
.0762 .54458 m
.0762 .54833 L
s
.01538 .54458 m
.01538 .54833 L
s
.98835 .54458 m
.98835 .54833 L
s
.25 Mabswid
0 .54458 m
1 .54458 L
s
.92754 .04244 m
.93379 .04244 L
s
[(-6)] .91504 .04244 1 0 Mshowa
.92754 .12613 m
.93379 .12613 L
s
[(-5)] .91504 .12613 1 0 Mshowa
.92754 .20982 m
.93379 .20982 L
s
[(-4)] .91504 .20982 1 0 Mshowa
.92754 .29351 m
.93379 .29351 L
s
[(-3)] .91504 .29351 1 0 Mshowa
.92754 .3772 m
.93379 .3772 L
s
[(-2)] .91504 .3772 1 0 Mshowa
.92754 .46089 m
.93379 .46089 L
s
[(-1)] .91504 .46089 1 0 Mshowa
.125 Mabswid
.92754 .05918 m
.93129 .05918 L
s
.92754 .07592 m
.93129 .07592 L
s
.92754 .09265 m
.93129 .09265 L
s
.92754 .10939 m
.93129 .10939 L
s
.92754 .14287 m
.93129 .14287 L
s
.92754 .15961 m
.93129 .15961 L
s
.92754 .17634 m
.93129 .17634 L
s
.92754 .19308 m
.93129 .19308 L
s
.92754 .22656 m
.93129 .22656 L
s
.92754 .2433 m
.93129 .2433 L
s
.92754 .26003 m
.93129 .26003 L
s
.92754 .27677 m
.93129 .27677 L
s
.92754 .31025 m
.93129 .31025 L
s
.92754 .32698 m
.93129 .32698 L
s
.92754 .34372 m
.93129 .34372 L
s
.92754 .36046 m
.93129 .36046 L
s
.92754 .39394 m
.93129 .39394 L
s
.92754 .41067 m
.93129 .41067 L
s
.92754 .42741 m
.93129 .42741 L
s
.92754 .44415 m
.93129 .44415 L
s
.92754 .47763 m
.93129 .47763 L
s
.92754 .49436 m
.93129 .49436 L
s
.92754 .5111 m
.93129 .5111 L
s
.92754 .52784 m
.93129 .52784 L
s
.92754 .0257 m
.93129 .0257 L
s
.92754 .00896 m
.93129 .00896 L
s
.92754 .56132 m
.93129 .56132 L
s
.92754 .57805 m
.93129 .57805 L
s
.92754 .59479 m
.93129 .59479 L
s
.92754 .61153 m
.93129 .61153 L
s
.25 Mabswid
.92754 0 m
.92754 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.97619 .54458 m
.96898 .56443 L
.95419 .57921 L
.93281 .59105 L
.91187 .59786 L
.89327 .60142 L
.87713 .60299 L
.86069 .60332 L
.84467 .60244 L
.83 .6006 L
.8157 .59779 L
.80351 .59452 L
.79339 .59112 L
.78277 .58674 L
.77254 .58156 L
.75731 .57137 L
.75086 .56564 L
.74579 .56011 L
.74201 .55502 L
.73885 .5496 L
.73753 .54676 L
.73634 .54365 L
.73489 .53818 L
.73442 .53511 L
.73419 .53184 L
.73424 .52876 L
.73451 .52598 L
.73561 .52068 L
.73731 .51587 L
.73993 .51071 L
.74357 .50537 L
.75165 .49687 L
.75738 .49232 L
.7635 .48829 L
.77863 .48072 L
.78866 .47704 L
.79897 .47409 L
.80498 .4727 L
.81092 .47154 L
.82274 .46983 L
.82976 .46916 L
.8365 .46875 L
.84418 .46854 L
.85265 .46863 L
.86631 .46948 L
.88186 .47151 L
.89732 .47474 L
.91201 .47906 L
.92956 .48623 L
.93948 .49152 L
Mistroke
.9484 .4974 L
.96315 .51105 L
.97346 .53022 L
.97448 .54281 L
.97054 .55641 L
.96294 .56712 L
.95143 .57703 L
.93691 .58519 L
.92075 .59138 L
.90576 .59533 L
.89261 .5977 L
.87999 .59918 L
.86889 .5999 L
.85735 .60013 L
.84578 .59985 L
.82784 .59844 L
.81839 .59722 L
.80999 .59586 L
.7955 .59289 L
.78169 .58925 L
.76018 .58183 L
.74101 .57297 L
.72416 .56267 L
.71215 .55305 L
.7023 .54252 L
.69879 .53768 L
.69575 .53259 L
.69365 .52822 L
.69193 .52357 L
.69078 .51909 L
.69017 .51506 L
.68996 .51106 L
.69014 .50731 L
.69079 .50304 L
.69182 .49915 L
.69342 .49498 L
.69566 .49065 L
.70132 .48287 L
.70534 .47872 L
.70955 .47507 L
.71865 .46877 L
.73011 .46281 L
.73699 .45997 L
.74496 .45721 L
.75237 .45508 L
.76096 .45304 L
.7665 .45196 L
.77181 .45107 L
.77696 .45035 L
.78283 .44967 L
Mistroke
.78826 .44918 L
.7935 .44883 L
.79919 .44857 L
.8055 .44844 L
.81162 .44847 L
.81754 .44862 L
.82903 .4493 L
.84205 .45065 L
.84967 .45174 L
.85688 .45297 L
.88359 .45933 L
.89783 .46402 L
.91395 .47064 L
.93202 .48024 L
.94816 .49174 L
.95655 .49956 L
.96466 .50949 L
.97055 .52041 L
.9736 .53189 L
.96929 .55423 L
.96013 .56615 L
.94812 .57543 L
.91991 .5876 L
.90416 .59148 L
.89034 .59374 L
.86824 .59564 L
.84686 .59581 L
.82854 .59481 L
.81325 .59323 L
.79668 .59079 L
.78025 .58762 L
.75385 .58093 L
.73009 .57309 L
.70854 .56427 L
.67748 .54788 L
.65434 .53137 L
.63894 .51655 L
.63251 .50855 L
.62705 .50003 L
.62506 .4962 L
.62329 .49218 L
.62202 .48871 L
.62095 .48511 L
.62016 .48149 L
.61969 .47822 L
.61944 .47476 L
.61942 .47282 L
.61948 .47104 L
.61978 .46784 L
.62027 .46498 L
Mistroke
.62107 .46174 L
.62207 .45875 L
.62454 .45337 L
.62751 .44862 L
.63153 .44364 L
.63666 .43866 L
.64318 .43364 L
.65033 .42923 L
.66626 .42203 L
.67659 .41867 L
.68711 .41602 L
.69971 .41367 L
.70724 .41264 L
.71438 .41189 L
.72094 .41137 L
.72812 .411 L
.73447 .41082 L
.74166 .41078 L
.74967 .41094 L
.75858 .41134 L
.76731 .41197 L
.77552 .41276 L
.79217 .41494 L
.81144 .41843 L
.83078 .42298 L
.84971 .4285 L
.87141 .43625 L
.8955 .44693 L
.92307 .46277 L
.93543 .47169 L
.94836 .48298 L
.9598 .49585 L
.96847 .50989 L
.97364 .52675 L
.97194 .54501 L
.957 .56591 L
.93306 .57942 L
.90487 .58715 L
.87741 .59038 L
.85269 .59092 L
.83235 .59005 L
.8219 .5892 L
.81104 .58804 L
.79257 .5855 L
.76086 .57953 L
.735 .57324 L
.68515 .55762 L
.64244 .54038 L
.58253 .50893 L
.53747 .47688 L
Mistroke
.52203 .463 L
.50877 .44896 L
.49894 .4364 L
.49198 .42546 L
.48914 .4201 L
.48657 .41441 L
.48475 .40962 L
.48318 .40446 L
.48256 .40189 L
.48201 .39916 L
.48176 .39767 L
.48157 .39632 L
.48129 .3937 L
.48115 .39148 L
.4811 .38908 L
.48117 .38662 L
.48133 .38436 L
.48159 .38225 L
.48197 .38001 L
.48242 .37792 L
.48292 .37603 L
.48409 .37252 L
.48563 .36894 L
.48982 .36188 L
.49279 .35811 L
.49595 .35476 L
.5037 .34828 L
.51393 .34206 L
.52529 .33702 L
.53729 .33311 L
.54928 .33026 L
.55663 .32892 L
.56388 .32787 L
.57185 .32699 L
.57949 .32637 L
.58362 .32613 L
.58825 .32593 L
.59319 .3258 L
.5979 .32574 L
.60289 .32575 L
.60544 .32579 L
.60829 .32585 L
.61341 .32601 L
.6183 .32623 L
.62417 .32658 L
.62967 .32698 L
.64245 .3282 L
.65391 .3296 L
.66692 .33153 L
.69203 .33622 L
Mistroke
.74794 .35094 L
.80772 .37322 L
.84553 .39126 L
.88983 .41751 L
.91127 .433 L
.9343 .4529 L
.9535 .47407 L
.96344 .48858 L
.97109 .5044 L
.97521 .52224 L
.97174 .54477 L
.95406 .56569 L
.92682 .57834 L
.90131 .5836 L
.87568 .58559 L
.8518 .58541 L
.83157 .5841 L
.81119 .5819 L
.79147 .57905 L
.75965 .57317 L
.69893 .55827 L
.60759 .52854 L
.53038 .49761 L
.42137 .44561 L
.25238 .34404 L
.1477 .26282 L
.08204 .19716 L
.05914 .16807 L
.04095 .1391 L
.03489 .12687 L
.02989 .11443 L
.02802 .10867 L
.02657 .10336 L
.02546 .09837 L
.02467 .09381 L
.02435 .09135 L
.02421 .09007 L
.02409 .08873 L
.024 .08761 L
.02392 .0864 L
.02387 .0853 L
.02384 .08428 L
.02382 .08367 L
.02381 .08301 L
.02381 .08182 L
.02383 .08067 L
.02386 .07962 L
.02391 .07849 L
.02399 .07726 L
.0241 .07598 L
Mistroke
.02422 .0748 L
.0245 .0727 L
.02482 .07073 L
.0256 .06713 L
.02669 .06338 L
.02816 .05944 L
.03005 .05542 L
.03214 .05179 L
.03683 .04545 L
.04303 .03926 L
.05105 .03332 L
.05915 .02878 L
.06924 .02451 L
.07478 .02264 L
.08108 .02084 L
.08732 .01936 L
.09337 .01817 L
.09962 .01717 L
.10682 .01625 L
.1144 .01554 L
.11869 .01525 L
.12281 .01503 L
.12656 .01488 L
.12847 .01482 L
.13058 .01477 L
.1324 .01474 L
.13437 .01472 L
.13625 .01472 L
.13796 .01472 L
.13902 .01472 L
.14015 .01473 L
.14218 .01476 L
.14331 .01478 L
.14438 .0148 L
.14684 .01486 L
.15099 .015 L
.15553 .01521 L
.16485 .01578 L
.17379 .01652 L
.19511 .01894 L
.21514 .02196 L
.23778 .02614 L
.33089 .05015 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[26]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo2Woo00<007oo
Ool057oo003oOol:Ool00`00Oomoo`0DOol00?moo`Yoo`8001Eoo`00ogoo2Woo00<007ooOol057oo
000LOolI003DOol00`00Oomoo`0DOol001Qoo`@001Uoo`H00<ioo`03001oogoo01Aoo`005Goo0`00
8goo1P00b7oo00<007ooOol057oo000COol2000/Ool50033Ool2000EOol0011oo`<003=oo`@00;mo
o`03001oogoo01Aoo`003Woo0P00>Woo1000^goo00<007ooOol057oo000=Ool00`00Oomoo`0nOol4
002`Ool20005Ool00`00Oomoo`0DOol000aoo`03001oogoo04=oo`@00:]oo`04001oogoo0004Ool0
0`00Oomoo`0DOol000]oo`03001oogoo04Qoo`@00:Moo`04001oogoo0004Ool3000DOol000Yoo`03
001oogoo04eoo`@009eoo`@0009oo`<000Eoo`03001oogoo01Aoo`002Goo00<007ooOol0DWoo0P00
XGoo00<007ooOol01Goo00<007ooOol057oo0008Ool00`00Oomoo`3fOol00`00Oomoo`05Ool00`00
Oomoo`0DOol000Qoo`03001oogoo0?Moo`<000Aoo`03001oogoo01Aoo`0027oo00<007ooOol0oWoo
0P005Goo0007Ool00`00Oomoo`3oOol00`00Oomoo`0DOol000Moo`03001oogoo0?moo`03001oogoo
01Aoo`001goo00<007ooOol0ogoo00<007ooOol057oo0007Ool00`00Oomoo`3oOol2000EOol000Mo
o`03001oogoo0?moo`03001oogoo01Aoo`001goo00<007ooOol0ogoo00<007ooOol057oo0007Ool0
0`00Oomoo`3oOol00`00Oomoo`0DOol000Moo`03001oogoo0?moo`03001oogoo01Aoo`001goo00<0
07ooOol0ogoo0P005Goo0007Ool00`00Oomoo`3oOol00`00Oomoo`0DOol000Moo`03001oogoo0?mo
o`03001oogoo01Aoo`001goo00<007ooOol0ogoo00<007ooOol057oo0007Ool00`00Oomoo`3oOol0
0`00Oomoo`0DOol000Qoo`03001oogoo0?ioo`8001Eoo`0027oo00<007ooOol0oWoo00<007ooOol0
57oo0008Ool00`00Oomoo`3nOol00`00Oomoo`0DOol000Uoo`03001oogoo0?Eoo`<000Eoo`03001o
ogoo01Aoo`002Goo00<007ooOol0n7oo00<007ooOol00Woo00<007ooOol057oo000:Ool00`00Oomo
o`3gOol00`00Oomoo`02Ool3000DOol000]oo`03001oogoo0>eoo`@0009oo`<000Eoo`03001oogoo
01Aoo`002goo00<007ooOol0lgoo00<007ooOol01Goo00<007ooOol057oo000<Ool00`00Oomoo`3b
Ool00`00Oomoo`05Ool00`00Oomoo`0DOol000eoo`03001oogoo0?5oo`@000Aoo`8001Eoo`003Goo
00<007ooOol0nGoo00<007ooOol057oo000>Ool00`00Oomoo`3hOol00`00Oomoo`0DOol000ioo`03
001oogoo0?Qoo`03001oogoo01Aoo`003goo00<007ooOol0mgoo00<007ooOol057oo000?Ool00`00
Oomoo`3gOol2000EOol0011oo`03001oogoo0?Ioo`03001oogoo01Aoo`0047oo00<007ooOol0mWoo
00<007ooOol057oo000AOol00`00Oomoo`3eOol00`00Oomoo`0DOol0019oo`03001oogoo0?Aoo`03
001oogoo01Aoo`004Woo00<007ooOol0m7oo0P005Goo000COol00`00Oomoo`3cOol00`00Oomoo`0D
Ool001Aoo`03001oogoo0?9oo`03001oogoo01Aoo`005Goo00<007ooOol0lGoo00<007ooOol057oo
000EOol00`00Oomoo`3aOol00`00Oomoo`0DOol001Ioo`03001oogoo0?1oo`8001Eoo`005goo00<0
07ooOol0kgoo00<007ooOol057oo000HOol00`00Oomoo`3^Ool00`00Oomoo`0DOol001Uoo`03001o
ogoo0>Moo`03001oogoo00=oo`03001oogoo01Aoo`006Woo00<007ooOol0iWoo00<007ooOol00goo
00<007ooOol057oo000KOol00`00Oomoo`3ROol50004Ool3000DOol001aoo`03001oogoo0=aoo`@0
0005Ool007ooOol00005Ool00`00Oomoo`0DOol001eoo`03001oogoo0>5oo`03001oo`0000Eoo`03
001oogoo01Aoo`007Woo00<007ooOol0hGoo0P001Goo00<007ooOol057oo000OOol00`00Oomoo`3Q
Ool00`00Oomoo`03Ool2000EOol0021oo`03001oogoo0>Ioo`03001oogoo01Aoo`008Goo00<007oo
Ool0iGoo00<007ooOol057oo000ROol00`00Oomoo`3TOol00`00Oomoo`0DOol002=oo`03001oogoo
0>=oo`03001oogoo01Aoo`0097oo00<007ooOol0hWoo0P005Goo000UOol00`00Oomoo`3QOol00`00
Oomoo`0DOol002Ioo`03001oogoo0>1oo`03001oogoo01Aoo`009goo00<007ooOol0ggoo00<007oo
Ool057oo000XOol00`00Oomoo`3NOol00`00Oomoo`0DOol002Uoo`03001oogoo0=eoo`8001Eoo`00
:Woo00<007ooOol0g7oo00<007ooOol057oo000[Ool00`00Oomoo`3KOol00`00Oomoo`0DOol002ao
o`800=]oo`03001oogoo01Aoo`00;Woo00<007ooOol0f7oo00<007ooOol057oo000_Ool00`00Oomo
o`3GOol2000EOol0031oo`800=Moo`03001oogoo01Aoo`00<Woo00<007ooOol0e7oo00<007ooOol0
57oo000cOol00`00Oomoo`3<Ool20005Ool00`00Oomoo`0DOol003Aoo`800<]oo`04001oogoo0004
Ool00`00Oomoo`0DOol003Ioo`03001oogoo0<]oo`03001oogoo009oo`<001Aoo`00=goo00<007oo
Ool0`Goo10000goo0P001Goo00<007ooOol057oo000hOol00`00Oomoo`39Ool00`00Oomoo`02Ool0
0`00Oomoo`0DOol003Uoo`800<Ioo`04001oogoo0004Ool00`00Oomoo`0DOol003]oo`03001oogoo
0<Aoo`8000Eoo`8001Eoo`00?7oo00<007ooOol0bWoo00<007ooOol057oo000mOol2003:Ool00`00
Oomoo`0DOol003moo`03001oogoo0<Moo`03001oogoo01Aoo`00@7oo00<007ooOol0aWoo00<007oo
Ool057oo0011Ool2001MOolF001COol2000EOol004=oo`03001oogoo05Ioo`@001Ioo`/004Qoo`03
001oogoo01Aoo`00A7oo00<007ooOol0DGoo10009Goo1000A7oo00<007ooOol057oo0015Ool2001>
Ool3000]Ool30011Ool00`00Oomoo`0DOol004Moo`03001oogoo04Uoo`8003=oo`@003eoo`03001o
ogoo01Aoo`00B7oo00<007ooOol0AWoo0P00>Goo1000>Goo0P005Goo0019Ool20015Ool00`00Oomo
o`0mOol4000eOol00`00Oomoo`0DOol004]oo`80049oo`03001oogoo049oo`@0035oo`03001oogoo
01Aoo`00CGoo00<007ooOol0?Woo00<007ooOol0Agoo0`00;Woo00<007ooOol057oo001>Ool2000m
Ool00`00Oomoo`1;Ool3000[Ool00`00Oomoo`0DOol0051oo`8003Yoo`03001oogoo04moo`8002Uo
o`8001Eoo`00DWoo00<007ooOol0=goo00<007ooOol0DGoo0`009Woo00<007ooOol057oo001COol2
000fOol00`00Oomoo`1EOol3000SOol00`00Oomoo`0DOol005Eoo`8003=oo`03001oogoo05Uoo`80
01Uoo`@000Aoo`03001oogoo01Aoo`00Egoo00<007ooOol0<7oo00<007ooOol0Fgoo0P005goo00<0
07ooOol01Goo00<007ooOol057oo001HOol2000`Ool00`00Oomoo`1MOol2000FOol00`00Oomoo`04
Ool3000DOol005Yoo`8002ioo`03001oogoo05moo`8000eoo`@000Aoo`03001oogoo00=oo`03001o
ogoo01Aoo`00G7oo00<007ooOol0:goo00<007ooOol0HGoo0P0057oo00<007ooOol00Woo00<007oo
Ool057oo001MOol2000[Ool00`00Oomoo`1SOol2000?Ool01000Oomoo`0017oo00<007ooOol057oo
001OOol00`00Oomoo`0XOol00`00Oomoo`1UOol00`00Oomoo`0=Ool20005Ool2000EOol0061oo`80
02Qoo`03001oogoo06Ioo`8001Aoo`03001oogoo01Aoo`00HWoo0P009Woo00<007ooOol0J7oo0P00
4Woo00<007ooOol057oo001TOol00`00Oomoo`0SOol00`00Oomoo`1ZOol2000@Ool00`00Oomoo`0D
Ool006Eoo`8002=oo`03001oogoo06aoo`8000ioo`03001oogoo01Aoo`00Igoo0P008Woo00<007oo
Ool0?Goo400087oo0P0037oo0P005Goo001YOol00`00Oomoo`0OOol00`00Oomoo`0iOol4000@Ool;
000GOol2000:Ool00`00Oomoo`0DOol006Yoo`8001moo`03001oogoo03=oo`H001moo`@001Eoo`03
001oogoo00Moo`03001oogoo01Aoo`00K7oo0P007Woo00<007ooOol0;goo0`00:Goo0`004goo00<0
07ooOol01Woo00<007ooOol057oo001^Ool00`00Oomoo`0LOol00`00Oomoo`0/Ool2000_Ool4000@
Ool00`00Oomoo`05Ool00`00Oomoo`0DOol006moo`8001eoo`03001oogoo02Uoo`8003Eoo`@000eo
o`8000Eoo`8001Eoo`00LGoo0P006goo00<007ooOol0:7oo00<007ooOol0>Goo0`0037oo00<007oo
Ool00Woo00<007ooOol057oo001cOol00`00Oomoo`0IOol00`00Oomoo`0UOol2000oOol2000;Ool0
1@00Oomoogoo00005Woo001dOol2000JOol00`00Oomoo`0SOol00`00Oomoo`11Ool2000:Ool01000
Oomoo`005Woo001fOol2000HOol00`00Oomoo`0SOol00`00Oomoo`13Ool20009Ool00`00Ool0000F
Ool007Qoo`8001Moo`03001oogoo025oo`03001oogoo04Ioo`8000Qoo`<001Eoo`00NWoo0P005Woo
00<007ooOol07goo00<007ooOol09goo4@004Goo00<007ooOol01Woo0P005Goo001lOol2000EOol0
0`00Oomoo`0MOol00`00Oomoo`0SOol5000AOol8000:Ool20006Ool00`00Ool0000DOol007ioo`80
01=oo`03001oogoo01eoo`03001oogoo01ioo`D001ioo`@000Ioo`@000Aoo`04001oogoo000COol0
081oo`80019oo`03001oogoo01]oo`03001oogoo01eoo`8002Moo`@000Aoo`04001oo`000002Ool0
1@00Oomoogoo00004Woo0022Ool2000AOol00`00Oomoo`0JOol00`00Oomoo`0LOol00`00Oomoo`0[
Ool50003Ool50002Ool00`00Oomoo`0?Ool008Aoo`80011oo`03001oogoo01Qoo`03001oogoo01]o
o`8002Yoo`@000Aoo`8000Aoo`03001oogoo00=oo`03001oogoo00ioo`00QWoo0P003goo0P0067oo
00<007ooOol06Woo00<007ooOol06Goo40002Goo00@007oo0000009oo`<000Aoo`03001oogoo00eo
o`00R7oo0`003Woo00<007ooOol05Goo00<007ooOol067oo0P005Woo1P0047oo2P000goo0`000Woo
00<007ooOol00Woo00<007ooOol037oo002;Ool2000=Ool00`00Oomoo`0DOol00`00Oomoo`0GOol0
0`00Oomoo`0COol3000NOol20005Ool20002Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool008eoo`80
00aoo`8001Aoo`03001oogoo01Ioo`03001oogoo015oo`<002=oo`<0009oo`03001oo`00009oo`05
001oogooOol0000=Ool008moo`8000aoo`03001oogoo019oo`03001oogoo01Aoo`03001oogoo011o
o`8002Uoo`<0009oo`04001oogoo0003Ool00`00Oomoo`0:Ool0095oo`8000]oo`80019oo`03001o
ogoo01=oo`03001oogoo00moo`8002eoo`<00005Ool00000Ool00003Ool00`00Oomoo`09Ool009=o
o`8000]oo`03001oogoo00moo`03001oogoo019oo`03001oogoo011oo`03001oogoo02aoo`03001o
ogoo00800004Ool007oo0002Ool00`00Oomoo`09Ool009Eoo`8000Yoo`03001oogoo00ioo`03001o
ogoo015oo`03001oogoo00moo`8002moo`8000=oo`05001oo`00Ool00002Ool00`00Oomoo`08Ool0
09Moo`<000Qoo`8000moo`03001oogoo011oo`03001oogoo00ioo`03001oogoo02moo`03001oogoo
00=oo`07001oo`00Ool007oo00002Woo002JOol20008Ool00`00Oomoo`0<Ool00`00Oomoo`0@Ool0
0`00Oomoo`0=Ool00`00Oomoo`0`Ool00`00Oomoo`04Ool01000Ool000000Woo00<007ooOol01goo
002LOol30006Ool2000=Ool00`00Oomoo`0?Ool00`00Oomoo`0<Ool00`00Oomoo`0aOol00`00Oomo
o`05Ool400000goo001oo`08Ool003Yoo`8004Eoo`03001oogoo01]oo`8000Ioo`03001oogoo00]o
o`03001oogoo00eoo`@000aoo`03001oogoo035oo`03001oogoo00Moo`800003Ool007oo00Qoo`00
>Goo00@007ooOol004Aoo`03001oogoo01eoo`8000Eoo`8000aoo`03001oogoo00aoo`03001oogoo
00aoo`03001oogoo039oo`8000Uoo`<000Uoo`00>Goo00@007ooOol0045oo`D0021oo`<000Aoo`80
00]oo`03001oogoo00]oo`8000aoo`03001oogoo03=oo`03001oogoo00Uoo`03001oo`0000Qoo`00
<goo10000Woo0`00?Goo100000Eoo`00Oomoo`0002Aoo`8000Aoo`8000Yoo`03001oogoo00Aoo`@0
00=oo`8000]oo`03001oogoo03=oo`03001oogoo00Uoo`<000Qoo`00>Goo00<007ooOol0@goo00<0
07oo00009Woo0`000goo0P002Goo00<007ooOol02Woo00<007oo00002Goo00<007ooOol0=7oo00<0
07ooOol02Woo0P0027oo000iOol00`00Oomoo`14Ool2000YOol20003Ool20007Ool00`00Oomoo`09
Ool200000goo001oo`08Ool00`00Oomoo`0dOol00`00Oomoo`0:Ool20008Ool003Yoo`<004Aoo`03
001oogoo02Uoo`<0009oo`8000Ioo`03001oogoo00Uoo`8000Yoo`03001oogoo03Aoo`8000aoo`03
001oogoo00Ioo`00/7oo0`0000=oo`0000001Goo00<007ooOol02Goo00<007ooOol027oo00<007oo
Ool0=7oo00<007ooOol02goo00<007ooOol01Woo002cOol50004Ool2000:Ool00`00Oomoo`07Ool0
0`00Oomoo`0dOol00`00Oomoo`0:Ool20008Ool00;Moo`<000Aoo`8000Qoo`03001oogoo00Moo`03
001oogoo03Aoo`03001oogoo00Yoo`8000Qoo`00o`0080000Goo0004Ool00`00Oomoo`0?Ool00`00
Oomoo`0>Ool00`00Oomoo`0>Ool00`00Oomoo`0?Ool00`00Oomoo`0>Ool00`00Oomoo`0?Ool00`00
Oomoo`0>Ool00`00Oomoo`0?Ool00`00Oomoo`0>Ool00`00Oomoo`0>Ool00`00Oomoo`07Ool40002
Ool00`00Ool00005Ool00`00Oomoo`06Ool00`00Ool0000AOol00`00Oomoo`0>Ool00`00Oomoo`0>
Ool00`00Oomoo`0:Ool20003Ool00`00Oomoo`02Ool000Aoo`03001oogoo00moo`03001oogoo00io
o`03001oogoo00ioo`03001oogoo00moo`03001oogoo00ioo`03001oogoo00moo`03001oogoo00io
o`03001oogoo00moo`03001oogoo00ioo`03001oogoo00ioo`03001oogoo00Uoo`L000Ioo`03001o
ogoo00Eoo`03001oo`00015oo`03001oogoo00ioo`03001oogoo00ioo`03001oogoo00Uoo`<000=o
o`03001oogoo009oo`00`Goo0P0000Aoo`00000000Eoo`03001oogoo00Eoo`03001oogoo039oo`03
001oogoo00Qoo`<000Uoo`00`goo0`0000Aoo`00000000=oo`03001oogoo00Aoo`03001oogoo039o
o`03001oogoo00Qoo`<000Uoo`00aWoo2@001Woo00<007ooOol0<Goo0P0027oo0`002Woo0039Ool3
0002Ool30005Ool2000aOol00`00Oomoo`06Ool4000:Ool00<]oo`<0009oo`@000Aoo`03001oogoo
02ioo`03001oogoo00Aoo`D000]oo`00cWoo0`0000=oo`000000100000=oo`00Ool0;Woo00@007oo
Oomoo`L000aoo`00d7oo1P000Woo1P00:goo00<007oo0000100000=oo`0000003Goo003COol:0000
0goo00000005000SOol6000017oo000000003Woo003GOol40002Ool40004Ool6000IOol800000goo
00000002000?Ool00=Yoo`H00003Ool0000000<000EooaT00004Ool00000Ool200001Goo000007oo
00004Goo003NOol40004Ool;000>Ool9000017oo000007oo0P004Woo003ROol90006Ool>0002Ool;
000DOol00>Eoo`@0009ooaX0009oo`@001Eoo`00j7oo6@000Woo10000Woo00<007ooOol057oo003[
OolH0006Ool00`00Oomoo`0DOol00?moo`Yoo`03001oogoo01Aoo`00ogoo2Woo00<007ooOol057oo
003oOol:Ool2000EOol00?moo`Yoo`03001oogoo01Aoo`00\
\>"],
  ImageRangeCache->{{{0, 358.75}, {221.125, 0}} -> {-7.63669, -6.50715, \
0.0287201, 0.0417371}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(sol\  = \ 
        NDSolve[system, \ 
          Method \[Rule] {"\<Projection\>", \ 
              Method -> "\<ExplicitEuler\>", \[IndentingNewLine]"\<Invariants\
\>" \[Rule] {L}}, \ StartingStepSize \[Rule] step];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(ParametricPlot[Evaluate[pvars\  /. \ First[sol]], \ 
        Evaluate[time]];\)\)}], "Input",
  CellLabel->"In[28]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.594255 0.406925 0.370996 0.303425 [
[.18733 .3585 -6 -9 ]
[.18733 .3585 6 0 ]
[.39079 .3585 -12 -9 ]
[.39079 .3585 12 0 ]
[.79772 .3585 -9 -9 ]
[.79772 .3585 9 0 ]
[.58175 .06757 -12 -4.5 ]
[.58175 .06757 0 4.5 ]
[.58175 .21928 -24 -4.5 ]
[.58175 .21928 0 4.5 ]
[.58175 .52271 -18 -4.5 ]
[.58175 .52271 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18733 .371 m
.18733 .37725 L
s
[(-1)] .18733 .3585 0 1 Mshowa
.39079 .371 m
.39079 .37725 L
s
[(-0.5)] .39079 .3585 0 1 Mshowa
.79772 .371 m
.79772 .37725 L
s
[(0.5)] .79772 .3585 0 1 Mshowa
.125 Mabswid
.22802 .371 m
.22802 .37475 L
s
.26871 .371 m
.26871 .37475 L
s
.30941 .371 m
.30941 .37475 L
s
.3501 .371 m
.3501 .37475 L
s
.43148 .371 m
.43148 .37475 L
s
.47218 .371 m
.47218 .37475 L
s
.51287 .371 m
.51287 .37475 L
s
.55356 .371 m
.55356 .37475 L
s
.63495 .371 m
.63495 .37475 L
s
.67564 .371 m
.67564 .37475 L
s
.71633 .371 m
.71633 .37475 L
s
.75702 .371 m
.75702 .37475 L
s
.83841 .371 m
.83841 .37475 L
s
.8791 .371 m
.8791 .37475 L
s
.91979 .371 m
.91979 .37475 L
s
.96049 .371 m
.96049 .37475 L
s
.14664 .371 m
.14664 .37475 L
s
.10594 .371 m
.10594 .37475 L
s
.06525 .371 m
.06525 .37475 L
s
.02456 .371 m
.02456 .37475 L
s
.25 Mabswid
0 .371 m
1 .371 L
s
.59425 .06757 m
.6005 .06757 L
s
[(-1)] .58175 .06757 1 0 Mshowa
.59425 .21928 m
.6005 .21928 L
s
[(-0.5)] .58175 .21928 1 0 Mshowa
.59425 .52271 m
.6005 .52271 L
s
[(0.5)] .58175 .52271 1 0 Mshowa
.125 Mabswid
.59425 .09791 m
.598 .09791 L
s
.59425 .12826 m
.598 .12826 L
s
.59425 .1586 m
.598 .1586 L
s
.59425 .18894 m
.598 .18894 L
s
.59425 .24963 m
.598 .24963 L
s
.59425 .27997 m
.598 .27997 L
s
.59425 .31031 m
.598 .31031 L
s
.59425 .34065 m
.598 .34065 L
s
.59425 .40134 m
.598 .40134 L
s
.59425 .43168 m
.598 .43168 L
s
.59425 .46202 m
.598 .46202 L
s
.59425 .49237 m
.598 .49237 L
s
.59425 .03723 m
.598 .03723 L
s
.59425 .00689 m
.598 .00689 L
s
.59425 .55305 m
.598 .55305 L
s
.59425 .58339 m
.598 .58339 L
s
.59425 .61374 m
.598 .61374 L
s
.25 Mabswid
.59425 0 m
.59425 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.75702 .371 m
.73166 .44165 L
.68262 .49332 L
.61166 .53436 L
.54153 .55703 L
.47894 .56744 L
.42469 .57033 L
.36967 .5679 L
.31664 .5605 L
.26875 .54929 L
.22291 .53405 L
.18473 .51736 L
.15386 .50059 L
.12247 .47962 L
.09361 .45547 L
.07275 .43357 L
.05456 .40936 L
.04662 .39622 L
.04039 .38409 L
.03109 .36019 L
.02594 .33853 L
.02381 .31584 L
.02521 .29179 L
.02993 .26982 L
.03408 .25747 L
.03877 .24639 L
.05249 .22222 L
.06752 .20264 L
.08418 .1854 L
.10503 .16792 L
.13157 .15011 L
.18449 .12429 L
.21794 .11273 L
.2522 .10383 L
.29312 .09654 L
.33421 .09248 L
.38259 .09155 L
.41113 .09286 L
.43795 .09537 L
.46702 .09946 L
.49454 .10473 L
.52546 .11233 L
.55884 .12271 L
.61572 .14644 L
.64785 .16405 L
.67715 .18368 L
.7274 .23004 L
.76288 .28658 L
.77591 .34635 L
.76113 .41423 L
Mistroke
.71182 .4783 L
.67389 .50608 L
.63611 .52581 L
.55933 .55084 L
.48884 .56101 L
.41785 .56127 L
.38067 .55766 L
.34811 .55238 L
.31589 .54512 L
.28849 .53726 L
.23338 .51618 L
.19306 .4954 L
.15574 .47077 L
.12643 .44634 L
.10366 .42265 L
.08275 .39483 L
.07316 .37869 L
.06587 .36388 L
.0601 .34947 L
.05528 .33379 L
.05192 .31813 L
.04999 .30182 L
.0496 .28751 L
.0503 .27468 L
.05234 .26009 L
.05544 .24658 L
.06373 .22318 L
.06994 .21041 L
.07662 .19895 L
.092 .17777 L
.1096 .15886 L
.15034 .12693 L
.1774 .11137 L
.20514 .09863 L
.2385 .0867 L
.25829 .0811 L
.27724 .07664 L
.31027 .07082 L
.34814 .06692 L
.3834 .06575 L
.42233 .06709 L
.46706 .07199 L
.51031 .08022 L
.55913 .09394 L
.61215 .11491 L
.66868 .14621 L
.71778 .1846 L
.74097 .20879 L
.76326 .23898 L
.78144 .27444 L
Mistroke
.79185 .31101 L
.79423 .34765 L
.78837 .38327 L
.75515 .44701 L
.69218 .50216 L
.64885 .52469 L
.6065 .54004 L
.52634 .55578 L
.45475 .55808 L
.39576 .55243 L
.33831 .5403 L
.28311 .52186 L
.23308 .49825 L
.19666 .47577 L
.16291 .44942 L
.13457 .42119 L
.11365 .39446 L
.09616 .36485 L
.08938 .34991 L
.08344 .33348 L
.07695 .30631 L
.07512 .29124 L
.07456 .27761 L
.07621 .25297 L
.08157 .22788 L
.08948 .20606 L
.10102 .18378 L
.11473 .16382 L
.12949 .14669 L
.14956 .12785 L
.17451 .1092 L
.19898 .09452 L
.22791 .08063 L
.26164 .06814 L
.29578 .05884 L
.31781 .05438 L
.33951 .05107 L
.38221 .04743 L
.40492 .04698 L
.42974 .04761 L
.47589 .05188 L
.50503 .05665 L
.53291 .06279 L
.58582 .07894 L
.63276 .09886 L
.68133 .1265 L
.72074 .15619 L
.75965 .19592 L
.79286 .24785 L
.80542 .28099 L
Mistroke
.81159 .31339 L
.8056 .38002 L
.77412 .44154 L
.72303 .49066 L
.65241 .52861 L
.57964 .5493 L
.51347 .55678 L
.44081 .55443 L
.40272 .54895 L
.36956 .54174 L
.3145 .52429 L
.26374 .5012 L
.21911 .47374 L
.17973 .44152 L
.15037 .40969 L
.12955 .37981 L
.11547 .35268 L
.10486 .32308 L
.09886 .29265 L
.09765 .26493 L
.10016 .23954 L
.10671 .21294 L
.11637 .18893 L
.12817 .16781 L
.14101 .1498 L
.15755 .13108 L
.19822 .09728 L
.22518 .08087 L
.25229 .0677 L
.28454 .05546 L
.32116 .04528 L
.3552 .03887 L
.38848 .03512 L
.42663 .03367 L
.46905 .03546 L
.51233 .04094 L
.53741 .04582 L
.5611 .05164 L
.6092 .06732 L
.66056 .09061 L
.70668 .11889 L
.74759 .15237 L
.78021 .18839 L
.80882 .23442 L
.82135 .26623 L
.82841 .29835 L
.83011 .32863 L
.82619 .36235 L
.81407 .3994 L
.79202 .43714 L
Mistroke
.76598 .46695 L
.73044 .49554 L
.69211 .51783 L
.65422 .53369 L
.60861 .54678 L
.56496 .55431 L
.48944 .55725 L
.44913 .55398 L
.41386 .54834 L
.35596 .53317 L
.3015 .5113 L
.25751 .48694 L
.22326 .46246 L
.19162 .43369 L
.16419 .40109 L
.15298 .3844 L
.14289 .36652 L
.12928 .33441 L
.12416 .31683 L
.12088 .30079 L
.11878 .28341 L
.11824 .26534 L
.12097 .23579 L
.12448 .21954 L
.12896 .20475 L
.14034 .17826 L
.15395 .15546 L
.17327 .13092 L
.19496 .10957 L
.21742 .09185 L
.24436 .07473 L
.26976 .06173 L
.29969 .04952 L
.33524 .03864 L
.35562 .03393 L
.3752 .03038 L
.41159 .02609 L
.45216 .02464 L
.49662 .02693 L
.52227 .03005 L
.54622 .0342 L
.59063 .04513 L
.61309 .05237 L
.63775 .06176 L
.67976 .08168 L
.72327 .10874 L
.76156 .14005 L
.79285 .17391 L
.81907 .21316 L
.83885 .26066 L
Mistroke
.84701 .31021 L
.84302 .35788 L
.82137 .41462 L
.77598 .4713 L
.71444 .51435 L
.64734 .54158 L
.58046 .5556 L
.51855 .55924 L
.45405 .55441 L
.391 .54104 L
.33279 .52021 L
.28541 .49588 L
.24915 .47139 L
.21617 .44284 L
.18801 .4111 L
.16803 .38138 L
.15206 .34859 L
.14149 .31437 L
.13709 .28507 L
.13677 .25851 L
.14031 .23032 L
.14829 .20151 L
.15465 .1858 L
.16161 .17178 L
.18107 .14188 L
.20222 .11773 L
.22836 .0946 L
.25294 .07733 L
.28192 .06102 L
.31652 .04592 L
.35131 .03464 L
.37104 .02972 L
.39269 .02546 L
.43307 .02042 L
.45865 .01908 L
.4832 .01908 L
.50559 .02017 L
.53007 .02254 L
.55213 .02575 L
.57645 .03048 L
.60193 .03684 L
.62565 .04412 L
.66777 .06058 L
.71162 .08336 L
.75226 .11111 L
.7924 .14777 L
.80886 .16692 L
.8246 .18888 L
.84732 .23247 L
.86048 .27894 L
Mistroke
.86291 .32592 L
.852 .37959 L
.82166 .43643 L
.79774 .46433 L
.77033 .48836 L
.70848 .52528 L
.63177 .55099 L
.58663 .55861 L
.54519 .56155 L
.47818 .55844 L
.41041 .54544 L
.34804 .52366 L
.29817 .4979 L
.24962 .46288 L
.21358 .42689 L
.18895 .39335 L
.16979 .35641 L
.16281 .33739 L
.15725 .31655 L
.15376 .29507 L
.15252 .27523 L
.15488 .24087 L
.15865 .22223 L
.16355 .20562 L
.17501 .1783 L
.19125 .15094 L
.21005 .12701 L
.22985 .10697 L
.25619 .08562 L
.28815 .06536 L
.32125 .04914 L
.35406 .03684 L
.38995 .02697 L
.42518 .02046 L
.46534 .0165 L
.48848 .0158 L
.50993 .01617 L
.55357 .01987 L
.57851 .02379 L
.6017 .02866 L
.64407 .04077 L
.68848 .05842 L
.7286 .07959 L
.77008 .10826 L
.80912 .14454 L
.82575 .16428 L
.83992 .18437 L
.86203 .22687 L
.87472 .26964 L
.87831 .31927 L
Mistroke
.87481 .34844 L
.86761 .37573 L
.85631 .40291 L
.83924 .43156 L
.79557 .47964 L
.76318 .50395 L
.72434 .5257 L
.68813 .54065 L
.64635 .55288 L
.60053 .56115 L
.55875 .56443 L
.5114 .56358 L
.46843 .55867 L
.43069 .55094 L
.39795 .54152 L
.36449 .529 L
.33208 .51366 L
.28425 .48388 L
.24836 .45374 L
.21575 .41681 L
.19299 .38072 L
.17854 .34724 L
.17031 .31649 L
.16657 .28341 L
.16817 .24936 L
.17151 .23046 L
.17603 .21359 L
.18252 .19564 L
.191 .17742 L
.20885 .14848 L
.23311 .11951 L
.25854 .09623 L
.28928 .07423 L
.32128 .05638 L
.35265 .04271 L
.3869 .03134 L
.42057 .02326 L
.45898 .01738 L
.50168 .01472 L
.52342 .01485 L
.54738 .01615 L
.59138 .0217 L
.63426 .03122 L
.67364 .04384 L
.71283 .06061 L
.74835 .08016 L
.77893 .10116 L
.8089 .12678 L
.83802 .15883 L
.86057 .19204 L
Mistroke
.8791 .23163 L
.89084 .27924 L
.89267 .3053 L
.89092 .33448 L
.87636 .38859 L
.84654 .44022 L
.80462 .48402 L
.7453 .52338 L
.70618 .54077 L
.66701 .5534 L
.62426 .56243 L
.58445 .56698 L
.54097 .56795 L
.49632 .56473 L
.43026 .55186 L
.36735 .52951 L
.3164 .50236 L
.2775 .47405 L
.24064 .43784 L
.22496 .41796 L
.21103 .39656 L
.20103 .3777 L
.19227 .3569 L
.18223 .32052 L
.17855 .28282 L
.18097 .24907 L
.18949 .21376 L
.19672 .19494 L
.20467 .17853 L
.22259 .15 L
.24633 .12178 L
.27249 .09782 L
.2994 .07822 L
.32592 .06258 L
.35631 .04815 L
.39174 .03517 L
.42647 .02586 L
.46714 .01876 L
.50684 .01542 L
.54321 .01532 L
.58316 .01844 L
.62694 .02581 L
.66764 .03661 L
.71128 .05292 L
.75627 .07588 L
.79782 .10436 L
.83678 .14049 L
.86486 .17634 L
.87813 .19863 L
.88845 .22057 L
Mistroke
.90208 .26647 L
.90564 .31292 L
.89972 .35636 L
.8822 .40386 L
.84862 .4539 L
.82591 .47743 L
.79654 .50119 L
.73476 .53627 L
.66835 .55884 L
.59419 .57052 L
.55643 .57176 L
.5154 .5696 L
.4466 .55769 L
.38806 .53851 L
.35786 .52475 L
.32878 .50845 L
.28394 .47573 L
.24599 .43697 L
.22906 .41401 L
.21616 .39228 L
.19946 .35264 L
.19102 .31548 L
.18903 .28284 L
.19235 .24861 L
.20187 .21313 L
.20882 .19605 L
.21801 .17795 L
.23795 .1479 L
.2605 .12217 L
.28544 .09972 L
.31583 .07802 L
.34505 .06142 L
.37837 .04646 L
.41326 .03452 L
.44625 .02624 L
.4805 .02044 L
.51352 .01733 L
.55294 .01668 L
.59498 .01961 L
.63088 .02511 L
.66991 .03442 L
.71107 .04835 L
.75349 .06787 L
.79123 .09072 L
.823 .1153 L
.85229 .14427 L
.87597 .17482 L
.89677 .21192 L
.91182 .25574 L
.91766 .30252 L
Mistroke
.91665 .32697 L
.91218 .35416 L
.89491 .40264 L
.86726 .44653 L
.8274 .48777 L
.77944 .52149 L
.729 .54579 L
.66857 .5644 L
.59892 .57457 L
.525 .57371 L
.46469 .56421 L
.40375 .54576 L
.37285 .53242 L
.34194 .51584 L
.29362 .48136 L
.25651 .44403 L
.23069 .40749 L
.21877 .38463 L
.21013 .36303 L
.20032 .32289 L
.19822 .3007 L
.1983 .28068 L
.20049 .25917 L
.20505 .23713 L
.21653 .20408 L
.23414 .17107 L
.25528 .1424 L
.27793 .11859 L
.30821 .09357 L
.34501 .07021 L
.38293 .05197 L
.42023 .03856 L
.45999 .02839 L
.49911 .02208 L
.53501 .01927 L
.57473 .01934 L
.61792 .0232 L
.64198 .02711 L
.66366 .03174 L
.7052 .04379 L
.74311 .05883 L
.77722 .07629 L
.81109 .09823 L
.8381 .12007 L
.86424 .14641 L
.8884 .17799 L
.90657 .21039 L
.92163 .25224 L
.92809 .29308 L
.92597 .33954 L
Mistroke
.92088 .36348 L
.91185 .38999 L
.88674 .43602 L
.85208 .47679 L
.82747 .49823 L
.79802 .51887 L
.73725 .54935 L
.69972 .56214 L
.66313 .571 L
.62179 .57715 L
.57708 .5796 L
.50329 .57429 L
.46358 .56643 L
.42874 .55643 L
.37044 .53206 L
.31798 .49953 L
.27974 .46623 L
.25149 .43271 L
.22865 .39445 L
.21312 .35273 L
.20845 .33071 L
.20618 .3102 L
.20714 .27275 L
.21513 .23417 L
.22252 .21344 L
.23103 .1951 L
.24867 .16602 L
.27245 .13675 L
.30163 .10936 L
.33234 .08692 L
.37252 .06436 L
.41364 .04726 L
.4526 .03556 L
.4753 .0305 L
.49663 .02685 L
.54165 .02245 L
.5676 .02187 L
.59203 .02261 L
.61772 .02475 L
.64116 .02794 L
.66671 .0328 L
.69325 .03945 L
.73504 .05357 L
.7714 .06999 L
.81082 .09319 L
.84481 .11922 L
.87284 .14683 L
.89514 .17513 L
.91501 .20918 L
.9299 .24826 L
Mistroke
.93752 .29037 L
.93813 .31492 L
.93618 .33776 L
.92501 .38265 L
.90475 .42491 L
.88903 .44802 L
.86878 .47167 L
.82354 .51063 L
.79379 .52957 L
.76311 .5452 L
.72685 .55964 L
.68523 .5716 L
.61516 .58233 L
.55043 .58275 L
.47807 .57256 L
.41498 .55354 L
.36312 .52918 L
.32175 .50216 L
.28406 .46878 L
.2531 .43053 L
.23111 .3905 L
.22259 .36773 L
.21712 .34691 L
.21246 .30698 L
.21481 .27013 L
.21881 .25012 L
.22503 .22943 L
.24097 .19408 L
.25348 .17376 L
.26702 .15563 L
.29643 .12454 L
.32692 .09988 L
.36412 .07663 L
.40644 .0568 L
.4485 .04253 L
.48959 .03299 L
.52808 .02757 L
.57324 .02527 L
.61626 .02704 L
.66252 .03333 L
.68557 .03824 L
.71063 .04503 L
.75357 .06046 L
.79183 .07897 L
.83337 .10558 L
.86741 .13448 L
.89925 .17097 L
.91268 .19109 L
.92514 .21436 L
.94003 .25571 L
Mistroke
.94648 .29629 L
.94676 .31821 L
.94442 .34272 L
.93885 .36857 L
.9306 .39277 L
.90737 .4366 L
.87676 .4747 L
.85602 .49443 L
.83036 .51448 L
.77614 .54604 L
.71516 .56926 L
.65514 .58249 L
.58318 .5877 L
.51594 .58266 L
.4564 .56983 L
.40588 .55189 L
.35642 .52646 L
.31208 .49449 L
.27351 .45526 L
.24747 .41707 L
.23672 .39537 L
.22789 .37161 L
.21912 .32852 L
.21883 .28905 L
.22615 .24883 L
.23803 .21631 L
.25648 .1828 L
.26929 .1649 L
.28439 .14711 L
.31512 .11812 L
.35286 .09116 L
.39865 .06702 L
.44147 .05071 L
.4664 .04353 L
.4895 .03824 L
.53547 .03133 L
.57953 .02896 L
.62091 .0304 L
.66497 .03592 L
.70577 .04487 L
.74193 .05622 L
.78246 .07333 L
.82365 .09656 L
.85899 .12278 L
.88793 .15062 L
.91312 .1825 L
.93201 .2153 L
.94659 .25407 L
.95166 .27699 L
.95415 .29859 L
Mistroke
.95274 .34067 L
.94814 .36491 L
.94123 .38754 L
.9192 .43268 L
.90199 .45713 L
.88329 .47853 L
.84452 .51256 L
.79474 .54362 L
.74606 .56488 L
.68735 .58159 L
.62054 .59075 L
.54755 .58989 L
.48071 .57911 L
.42376 .56147 L
.37251 .53741 L
.33113 .51039 L
.29325 .47676 L
.26198 .43772 L
.24089 .39867 L
.22857 .36127 L
.22342 .32781 L
.22377 .29231 L
.23119 .25292 L
.24389 .21891 L
.26483 .18241 L
.29014 .15094 L
.31762 .12484 L
.34607 .10338 L
.38016 .08295 L
.41911 .06494 L
.46031 .05085 L
.48425 .04468 L
.50657 .04014 L
.5484 .03462 L
.59296 .03279 L
.6167 .03349 L
.64197 .03553 L
.68693 .04253 L
.71387 .04892 L
.73876 .0564 L
.7835 .07414 L
.82097 .09407 L
.85864 .12026 L
.89314 .15216 L
.92008 .18591 L
.93982 .22057 L
.95263 .25451 L
.96046 .2959 L
.96026 .33676 L
.95092 .38164 L
Mistroke
.94132 .40666 L
.92981 .42902 L
.89949 .47107 L
.86151 .50752 L
.83586 .52637 L
.80591 .54438 L
.74563 .5707 L
.709 .58161 L
.67338 .58907 L
.63319 .59411 L
.58955 .59572 L
.52324 .59052 L
.48665 .58357 L
.45361 .57457 L
.39209 .54979 L
.36111 .53246 L
.33537 .51479 L
.2962 .47996 L
.2635 .43827 L
.24231 .39684 L
.23085 .35772 L
.22759 .33413 L
.22703 .3089 L
.22919 .28553 L
.23338 .26452 L
.24668 .22635 L
.26767 .1889 L
.28108 .17079 L
.29717 .15247 L
.33028 .12249 L
.3754 .09233 L
.42091 .07031 L
.46325 .05552 L
.48534 .04966 L
.51016 .04444 L
.55474 .03849 L
.59706 .0367 L
.62126 .03733 L
.64664 .03929 L
.69142 .0461 L
.71588 .05172 L
.73821 .0581 L
.78685 .07669 L
.82643 .09745 L
.86066 .12078 L
.88829 .14466 L
.91439 .1735 L
.93762 .20814 L
.94703 .22674 L
.95544 .24801 L
Mistroke
.96494 .28734 L
.96707 .32569 L
.96151 .36747 L
.95469 .39092 L
.9461 .41202 L
.92262 .45224 L
.8923 .48807 L
.87151 .50717 L
.84687 .52599 L
.79632 .55547 L
.76496 .56912 L
.73392 .57977 L
.69823 .58899 L
.65856 .59576 L
.5905 .59959 L
.55197 .59748 L
.51684 .59285 L
.45496 .57785 L
.39499 .55352 L
.34806 .52562 L
.31072 .49522 L
.27782 .45834 L
.25212 .41595 L
.23743 .37606 L
.23098 .33885 L
.23145 .29868 L
.23999 .25742 L
.24721 .23743 L
.25707 .21657 L
.27991 .18109 L
.30762 .14983 L
.33725 .12418 L
.36595 .10437 L
.3992 .08597 L
.43806 .06929 L
.47616 .0571 L
.52038 .04739 L
.56322 .0421 L
.602 .04061 L
.64413 .04248 L
.6886 .04848 L
.72839 .05758 L
.77039 .07144 L
.81212 .09033 L
.84586 .11025 L
.87464 .13156 L
.90281 .15784 L
.92842 .18904 L
.95029 .22632 L
.95955 .24867 L
Mistroke
.96595 .27002 L
.97196 .3107 L
.972 .33176 L
.96959 .35519 L
.95911 .39584 L
.9385 .43888 L
.90996 .47773 L
.87614 .51068 L
.82929 .54371 L
.79949 .55966 L
.77045 .57226 L
.70925 .59114 L
.64757 .6012 L
.61152 .60332 L
.57324 .60268 L
.50573 .59402 L
.46954 .5852 L
.43721 .5745 L
.40368 .56024 L
.37047 .54228 L
.3223 .50713 L
.29944 .48494 L
.28129 .46324 L
.25556 .42136 L
.24631 .39957 L
.23898 .37528 L
.23319 .33348 L
.23611 .28938 L
.24691 .24954 L
.26299 .21514 L
.27979 .18926 L
.2985 .16646 L
.33998 .1285 L
.36639 .11011 L
.39242 .09507 L
.42456 .07991 L
.45602 .06814 L
.48416 .05983 L
.51042 .0538 L
.54004 .04885 L
.5722 .0456 L
.60315 .04447 L
.63681 .04546 L
.66833 .04851 L
.69714 .05313 L
.73059 .06085 L
.76554 .07184 L
.79713 .08469 L
.8247 .09855 L
.87244 .13002 L
Mistroke
.89381 .14828 L
.9149 .17001 L
.93452 .19517 L
.94996 .22059 L
.96366 .2516 L
.97201 .28118 L
.97602 .30999 L
.97619 .33717 L
.97229 .36736 L
.96329 .39943 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[28]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00OZWoo00<007ooOol0
Lgoo002ZOol00`00Oomoo`1cOol00:Yoo`8007Aoo`00ZWoo00<007ooOol0Lgoo0020OolT0006Ool0
0`00Oomoo`1cOol007QoocD007=oo`00LWoo5@001Woo1`0000=oo`0000007P00Jgoo001]Oom=001V
Ool006Moo`d00003Ool0000000L000Aoo`T000Aoo`X000Mooad006=oo`00Hgoo1`0017oo0`0000=o
o`0000003P0000=oo`0000000P000goo1@001goo7P0000=oo`0000002`00GWoo001QOol60003Ool;
0005Ool40002Ool=0003Ool:0005Ool40002OolP001KOol005iooa400004Ool000000004Ool30002
Ool40002Ool40003Ool<0004OolI0004OolB001HOol005]oo``00004Ool000000003Ool20003Ool4
00000goo000000020003Ool30002Ool:0003Ool80002Oolb001COol005Qoo`P0009oo`800003Ool0
000001d0009oo`<000Aoo`@0009oo`X0009oo`X00003Ool0000000Iooad0055oo`00E7oo1P0000=o
o`0000002P000Woo0P000Woo0P0017oo0P0017oo0`0000Aoo`000000009oo`/0009oo`@000=oo``0
00Qoo`04001oo`000009Ool20006OolC001>Ool0051oo`L00003Ool0000000H00003Ool0000000Ao
o`80009oo`8000Aoo`8000=oo`<0009oo`8000=oo`P0009oo`D00003Ool0000000@000aoo`<000Eo
o`04001oogooOol30008Ool30006Ool200000goo0000000>001;Ool004ioo`@00003Ool0000000@0
00=oo`800003Ool0000000Aoo`80009oo`8000Aoo`80009oo`<0009oo`<0009oo`<00003Ool00000
00Aoo`@00003Ool0000000@001=oo`8000=oo`03001oogoo00Aoo`@000Moo`8000Ioo`8000=oo`h0
04Uoo`00C7oo0`0000=oo`000000100017oo0P0000=oo`00000017oo0P000goo00<007ooOol00Woo
0P000Woo0P000goo0P000Woo0`0000Aoo`000000009oo`@00003Ool00000008000Ioo`@000]oo`@0
009oo`@000Yoo`8000Moo`<000Eoo`8000=oo`80009oo`/004Ioo`00BWoo1`0000=oo`00000017oo
0P0000=oo`00000017oo0P000goo0P0000=oo`0000002`0000Aoo`000000009oo`800003Ool00000
00800003Ool00000008000ioo`@000Uoo`03001oogoo00Aoo`<000Yoo`8000Qoo`8000Eoo`8000=o
o`80009oo`/004Aoo`00Agoo200000=oo`00000017oo0P000Woo00<007ooOol00Woo2`000Woo0P00
17oo3P0000Aoo`00000001Ioo`@000Eoo`03001oogoo00Aoo`H000Uoo`8000Qoo`8000Eoo`8000=o
o`80009oo`800003Ool0000000H0049oo`00AGoo1@0000=oo`0000000Woo00<007ooOol00Woo0P00
00=oo`0000001P0017oo00<007ooOol00P000Woo0P0017oo0P0000=oo`0000000Woo1@000Woo2P00
4goo1`0000=oo`00Ool01Goo00<007ooOol00goo0P002Goo0P0027oo0P001Goo0P000goo00@007oo
Oomoo`80009oo`L0041oo`00@goo1@0000=oo`0000000Woo0P000goo1`000Woo0P0017oo0P0000=o
o`0000000Woo0P0017oo0P0000=oo`0000000Woo0P0000Aoo`00001oo`<000Yoo`@001Ioo`@000Ao
o`03001oogoo00Eoo`8000Uoo`8000Qoo`8000Eoo`80009oo`8000=oo`80009oo`03001oo`0000@0
03ioo`00@Goo1@000Woo00@007ooOomoo`L000=oo`05001oogooOol00004Ool200000goo00000002
Ool20004Ool200000goo00000002Ool2000017oo000007oo0P004Goo10004Goo0`000Woo1@002Goo
0P002Goo0P0027oo0P001Goo00@007ooOomoo`8000=oo`800004Ool007ooOol5000lOol0041oo`@0
009oo`L000=oo`04001oogooOol20002Ool20003Ool200000goo00000003Ool00`00Oomoo`02Ool2
00000goo00000002Ool2000017oo000007oo0P005goo1@003Woo00<007ooOol017oo0P002Woo0P00
2Goo0P0027oo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00@007oo0000009oo`D003Yoo`00
?Woo0P0000=oo`00Ool010000Woo00<007ooOol00Woo0P000goo00D007ooOomoo`0000=oo`80009o
o`04001oogooOol20003Ool200000goo00000002Ool2000017oo000007oo0P007Woo10004Goo00@0
07oo000000Yoo`8000Uoo`8000Qoo`8000=oo`8000=oo`8000=oo`800004Ool007ooOol6000hOol0
03aoo`800003Ool0000000800003Ool007oo009oo`03001oogoo009oo`03001oogoo009oo`05001o
ogooOol00002Ool20003Ool00`00Oomoo`020003Ool200000goo00000002Ool2000017oo000007oo
0P0097oo1@0037oo00@007ooOomoo`8000Yoo`8000Uoo`8000Qoo`03001oogoo009oo`03001oogoo
009oo`03001oogoo009oo`05001oo`00001oo`07000fOol003Yoo`80009oo`<00003Ool0000000=o
o`04001oogooOol20003Ool20002Ool20002Ool00`00Ool0000O000TOol40008Ool00`00Oomoo`03
Ool2000:Ool20009Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20003Ool20000
1Woo001oogoo001oo`D003Aoo`00>Goo00@007ooOomoo`80009oo`04001oogooOol20003Ool00`00
Oomoo`02Ool00`00Ool00008000017oo001oogoo0P000goo0P0000Aoo`00001oo`800003Ool00000
009oo`03001oogoo00Moo`P0021oo`8000Ioo`03001oogoo00Eoo`8000Yoo`8000Qoo`8000Moo`80
00=oo`8000Aoo`03001oogoo009oo`03001oo`00009oo`800003Ool0000000<0039oo`00=goo0P00
00Aoo`00000000=oo`05001oogooOol00004Ool00`00Ool0000500000goo001oo`02Ool01@00Oomo
ogoo00000Woo00<007ooOol00Woo00@007oo0000009oo`04001oo`000002Ool2000BOol6000LOol3
0003Ool20008Ool2000:Ool20008Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2
0003Ool40002Ool00`00Ool00004000aOol003Eoo`H000Aoo`05001oogooOol00003Ool400000goo
00000003Ool01@00Oomoogoo00000Woo0P000Woo00@007ooOomoo`800004Ool007ooOol2000017oo
001oogoo0P006Woo10006goo0P0000=oo`00Ool02Woo0P002Woo00<007ooOol01Woo0P001goo00<0
07ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<007oo00000Woo00<007ooOol01000<7oo
000cOol40002Ool01000Oomoogoo0P000goo1P000goo00<007ooOol00Woo00<007ooOol00P000Woo
00D007ooOomoo`00009oo`800003Ool00000009oo`05001oo`00001oo`02000POol4000IOol3000<
Ool20009Ool20008Ool20006Ool20003Ool20004Ool00`00Oomoo`02Ool00`00Ool00002Ool20000
0goo00000003000^Ool0039oo`<000=oo`05001oogooOol00003Ool30003Ool01@00Oomoogoo0000
0goo0P000Woo00D007ooOomoo`00009oo`80009oo`04001oogoo0003Ool00`00Ool00002Ool00`00
Oomoo`0TOol4000FOol01000Ool0000037oo0P002Goo00<007ooOol01goo00<007ooOol01Goo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00@007oo0000009oo`03001oo`0000@002eo
o`00<7oo10000goo00H007ooOomoo`00Ool40004Ool00`00Oomoo`020003Ool01@00Oomoogoo0000
0goo00@007ooOol0009oo`80009oo`03001oogoo00@00003Ool0000002]oo`@0019oo`04001oogoo
Ool2000<Ool00`00Oomoo`07Ool20008Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool01000Oomoo`000Woo00<007oo00001000;7oo000_Ool200000goo001oo`02
Ool01000Oomoogoo0`000Woo00<007ooOol00Woo00@007ooOol000Aoo`05001oogooOol00003Ool0
1000Oomoo`000Woo00<007ooOol00P000Woo00@007oo001oo`80035oo`<000moo`03001oogoo00=o
o`8000]oo`8000Uoo`8000Moo`8000Ioo`03001oogoo009oo`03001oogoo009oo`8000=oo`04001o
ogoo0002Ool200000goo00000003000ZOol002ioo`04001oo`000002Ool2000017oo0000000017oo
00<007ooOol00Woo00@007ooOol000Aoo`05001oogooOol00003Ool01000Oomoo`000Woo00@007oo
Ool0009oo`@00003Ool007oo03Eoo`@000]oo`03001oogoo00Eoo`8000]oo`8000Uoo`03001oogoo
00Ioo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo00=oo`05001oogooOol00002Ool01P00
Oomoogoo001oo`800003Ool0000002Uoo`00;7oo0P0000=oo`00Ool00Woo00H007oo000007oo0004
Ool00`00Oomoo`02Ool01000Oomoo`0017oo00D007ooOomoo`0000=oo`04001oogoo0002Ool01000
Oomoo`000Woo00@007oo001oo`8003]oo`<000Qoo`03001oogoo00Moo`8000]oo`8000Qoo`03001o
ogoo00Ioo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo00=oo`05001oogooOol00002Ool0
1P00Oomoogoo001oo`800003Ool0000002Qoo`00:goo00@007ooOol000=oo`<0009oo`03001oogoo
009oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo00000goo00@007ooOol0009o
o`04001oogoo0002Ool01@00Ool007oo0000@7oo0P001Woo0P002Woo00<007ooOol02Woo00<007oo
Ool01Woo0P001goo00<007ooOol017oo00<007ooOol00Woo0P0017oo00D007ooOomoo`00009oo`06
001oogooOol007oo1P009Woo000YOol20002Ool01000Oomoogoo0P0017oo00D007ooOomoo`0000Ao
o`05001oogooOol00003Ool01@00Oomoogoo00000goo00@007ooOol0009oo`04001oogoo0002Ool0
1@00Ool007oo0000@goo0`000goo00<007ooOol02Woo0P002goo0P0027oo00<007ooOol01Goo00<0
07ooOol017oo0P0017oo00<007ooOol00Woo00D007ooOomoo`00009oo`80009oo`04001oo`00Ool4
000UOol002Qoo`80009oo`03001oogoo008000Eoo`03001oogoo009oo`03001oogoo009oo`04001o
ogoo0003Ool01@00Oomoogoo00000goo00@007ooOol0009oo`04001oogoo0002Ool300000goo001o
o`16Ool4000>Ool2000;Ool00`00Oomoo`06Ool00`00Oomoo`05Ool20006Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool01@00Oomoogoo00000goo00L007ooOol007oo001oo`04000TOol002Moo`80009o
o`06001oo`00001oo`0017oo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`04
001oogoo0003Ool01000Oomoo`000Woo00D007ooOol007oo00<0009oo`03001oogoo04Uoo`8000mo
o`8000Yoo`03001oogoo00Ioo`8000Moo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009o
o`05001oogooOol00003Ool01`00Oomoo`00Ool007oo00@002=oo`009Goo0`000Woo0`000Woo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`04001oogoo0003
Ool01000Oomoo`000Woo00P007ooOol007oo001oo`000Woo00<007ooOol0BWoo00<007oo00000P00
3Woo0P002Goo0P0027oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol00Woo00<007ooOol0
0Woo00D007ooOomoo`0000=oo`07001oogoo001oo`00Ool00P0000=oo`0000008Goo000TOol00`00
Ool00002Ool20003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo
00000goo00@007ooOol000=oo`04001oogoo0002Ool02@00Oomoo`00Ool007oo001oo`02001=Ool0
0`00Oomoo`02Ool2000>Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomo
o`04Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOol007oo0080
0003Ool007oo0080021oo`008goo00@007oo001oo`8000Aoo`03001oogoo00=oo`03001oogoo009o
o`05001oogooOol00004Ool01000Oomoo`000goo00@007ooOol0009oo`04001oogoo0002Ool01`00
Ool007oo001oo`0004moo`03001oogoo00Aoo`8000eoo`03001oogoo00Qoo`03001oogoo00Ioo`80
00Ioo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00003Ool01@00
Oomoo`00Ool00P0000=oo`00Ool00P007goo000QOol200001Woo001oo`00Ool000Aoo`03001oogoo
009oo`03001oogoo009oo`05001oogooOol00004Ool01000Oomoo`000goo00L007ooOomoo`00Ool0
0002Ool02P00Oomoo`00Ool007oo001oo`00D7oo00<007ooOol01Woo00<007ooOol02goo0P002Goo
0P0027oo00<007ooOol017oo00<007ooOol017oo00<007ooOol00Woo00<007ooOol00Woo00@007oo
Ool000Aoo`03001oo`00009oo`800003Ool007oo008001ioo`0087oo00<007ooOol00`0000=oo`00
Ool00goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`04
001oogoo0003Ool00`00Ool00002Ool02P00Oomoo`00Ool007oo001oo`00DGoo00<007ooOol01goo
0P003Goo00<007ooOol027oo00<007ooOol01Woo00<007ooOol017oo00<007ooOol017oo00D007oo
Oomoo`0000Eoo`04001oogoo0003Ool02`00Oomoo`00Ool007oo001oo`00Ool00P007Goo000OOol0
0`00Oomoo`020003Ool01@00Oomoogoo00001Goo00<007ooOol00Woo00D007ooOomoo`0000Aoo`04
001oogoo0003Ool01P00Oomoo`00Ool000=oo`09001oo`00Ool007oo001oo`00059oo`8000Yoo`03
001oogoo00]oo`03001oogoo00Qoo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00=oo`03
001oogoo009oo`03001oogoo00=oo`04001oogoo0003Ool02@00Oomoo`00Ool007oo001oo`04000L
Ool001ioo`04001oogoo0004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009oo`03001oo`0000=oo`03001oogoo
00800004Ool007oo001COol00`00Oomoo`0:Ool2000<Ool00`00Oomoo`08Ool00`00Oomoo`06Ool0
0`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01000Oomoo`000goo
00<007oo00000Woo00D007oo000007oo00<001]oo`007Goo00@007oo000000Eoo`05001oogooOol0
0004Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`04001oogoo0002
Ool01000Oomoo`000Woo0P000Woo0P00E7oo00<007ooOol037oo00<007ooOol02Woo0P002Goo00<0
07ooOol01Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00D0
07ooOomoo`0000=oo`03001oo`00009oo`800003Ool007oo00<001Yoo`0077oo00D007oo001oo`00
00Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00003Ool01@00
Oomoogoo00000goo00<007oo00000Woo00@007ooOol0009oo`80009oo`8005Eoo`03001oogoo00eo
o`8000aoo`03001oogoo00Moo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00=oo`03001o
ogoo009oo`03001oogoo009oo`04001oogoo0003Ool02@00Oomoo`00Ool007oo001oo`0200000goo
0000000IOol001]oo`05001oo`00Ool00004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009oo`03001oo`00009o
o`03001oogoo0080009oo`03001oo`0005Eoo`03001oogoo00moo`8000]oo`03001oogoo00Moo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo009oo`03001oogoo00=oo`05001oogooOol00003
Ool01@00Oomoogoo00000Woo00H007oo001oo`00Ool200000goo0000000HOol001Yoo`<00003Ool0
07oo00Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00003Ool0
1@00Oomoogoo00000Woo00@007ooOol0009oo`04001oogoo0002Ool2000017oo001oo`00EWoo00<0
07ooOol04Goo0P002Woo0P001goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oo`00009oo`05001oo`00001o
o`03000HOol001Uoo`8000=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo009oo`04001oogoo0003Ool01@00Oomoogoo00000Woo00<007oo00000Woo
00<007ooOol00P0000Aoo`00Ool005Moo`03001oogoo01=oo`8000Yoo`03001oogoo00Eoo`03001o
ogoo00Ioo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`05001o
ogooOol00003Ool00`00Ool00002Ool01@00Ool00000Ool00`005goo000IOol01@00Oomoogoo0000
17oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`05001o
ogooOol00002Ool01000Oomoo`000Woo00<007oo00000Woo0P0000Aoo`00Ool005Qoo`03001oogoo
01Eoo`03001oogoo00Qoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo
00=oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo00000Woo00H007oo001oo`00
Ool200000goo0000000FOol001Qoo`05001oogooOol00005Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`000goo00L007ooOomoo`00Ool00002Ool0
0`00Ool00002Ool01`00Ool007oo001oo`0005Qoo`03001oogoo01Ioo`03001oogoo00Qoo`03001o
ogoo00Eoo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`05001o
ogooOol00003Ool01`00Oomoogoo001oo`00009oo`04001oo`00Ool5000EOol001Moo`8000=oo`03
001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00003
Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oo`00009oo`800004Ool007oo001IOol2
000HOol00`00Oomoo`08Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00@007ooOol0009oo`05001oogoo001oo`02
000017oo000000005Goo000FOol20003Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`000goo00L007ooOomoo`00Ool00002Ool0
0`00Ool00002Ool2000017oo001oo`00FWoo00<007ooOol067oo00<007ooOol027oo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00D007ooOomo
o`0000=oo`07001oogooOol007oo00000Woo00<007ooOol00`0000=oo`00000057oo000EOol00`00
Ool00003Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00
Oomoogoo00000goo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Ool00002Ool2000017oo
001oo`00FWoo00<007ooOol06Goo00<007ooOol027oo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=o
o`03001oo`00009oo`04001oo`00Ool5000COol001Aoo`03001oo`0000=oo`03001oogoo00=oo`03
001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`04001oogoo0004Ool0
1P00Oomoo`00Ool0009oo`03001oo`00009oo`800004Ool007oo001KOol00`00Oomoo`0JOol00`00
Oomoo`08Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00
Oomoo`03Ool01@00Oomoogoo00000goo00L007ooOomoo`00Ool00003Ool00`00Ool0000200000goo
0000000COol001=oo`03001oo`0000Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`08
001oo`00Ool007oo001oo`8005aoo`03001oogoo01]oo`03001oogoo00Qoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`05
001oogooOol00003Ool00`00Ool00002Ool01000Ool007oo1@004Woo000BOol01000Oomoo`000goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`00
00=oo`05001oogooOol00002Ool02000Oomoo`00Ool007oo0002Ool200000goo0000001MOol00`00
Oomoo`0LOol20009Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00L007ooOomoo`00Ool00003Ool01000Ool007oo
10004Woo000AOol01000Oomoo`0017oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo
00<007ooOol00Woo00D007ooOomoo`0000=oo`05001oogooOol00002Ool01000Oomoo`000Woo00@0
07oo001oo`800004Ool007oo0019Ool20004Ool00`00Oomoo`02Ool30006Ool00`00Oomoo`0NOol0
0`00Oomoo`07Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007oo00000Woo00@007oo001o
o`800003Ool00000015oo`004Goo00<007oo000017oo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`05001oogooOol00002Ool02000Oomo
o`00Ool007oo0002Ool200000goo00000019Ool01000Oomoo`002goo00<007ooOol00goo00<007oo
Ool07goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Goo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol00goo00D007ooOomoo`0000=oo`07001oogooOol007oo00000goo00@007oo
001oo`D0011oo`0047oo00@007ooOol000Aoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
00=oo`05001oogooOol00004Ool01@00Oomoogoo00000goo00@007ooOol0009oo`06001oo`00Ool0
07oo0P0000Aoo`00Ool004Uoo`04001oogoo000;Ool00`00Oomoo`03Ool3000POol00`00Oomoo`06
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007oo00000Woo00@007oo001oo`800003Ool0
0000011oo`003goo00@007ooOol000Eoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=o
o`05001oogooOol00004Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`05001oo`00Ool00002
Ool200000goo00000014Ool40002Ool01000Oomoo`0027oo0`001Woo00<007ooOol08Goo00<007oo
Ool01Woo00<007ooOol017oo00<007ooOol017oo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool00goo00D007ooOomoo`0000=oo`07001oogooOol007oo00000Woo00D007ooOol007oo00D000mo
o`003Woo00D007ooOomoo`0000Aoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`03
001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo00000Woo00T007ooOol007oo001oo`00
Ool00P0000Aoo`00Ool004Yoo`04001oogoo0008Ool00`00Oomoo`06Ool00`00Oomoo`0ROol00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`000goo00@007ooOol0009oo`04001oo`00Ool20000
0goo0000000?Ool000ioo`04001oogoo0005Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`05001oo`00Ool0
0002Ool01@00Ool00000Ool00P00Bgoo00@007ooOol000Qoo`03001oogoo00Ioo`03001oogoo02=o
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo00=oo`05001oogooOol00003Ool01`00Oomoogoo001oo`00009oo`06001oo`00Ool0
07oo10003Woo000=Ool01@00Oomoogoo00001Goo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool00goo00<007ooOol00Woo00D007ooOomoo`0000=oo`07001oogooOol007oo00000Woo00<007oo
00000Woo0`000Woo0P00C7oo0P002Goo10001Goo00<007ooOol097oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool00Woo00@007ooOol000=oo`03001oo`00009oo`05001oogoo001oo`0200000goo0000000>Ool0
00eoo`05001oogooOol00005Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00
Oomoogoo000017oo00D007ooOomoo`00009oo`06001oogoo001oo`000Woo00@007oo001oo`800004
Ool007oo001POol00`00Oomoo`0TOol00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`000goo
00@007ooOol0009oo`06001oo`00Ool007oo10003Goo000<Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00D007oo
Oomoo`00009oo`06001oogoo001oo`000Woo00@007oo001oo`800003Ool00000065oo`03001oogoo
02Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo
00=oo`03001oogoo009oo`05001oogooOol00003Ool01000Oomoo`000Woo00H007ooOol007oo0002
Ool300000goo001oo`0<Ool000aoo`05001oogooOol00005Ool00`00Oomoo`04Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00D007ooOomoo`0000=oo`03001oo`00009oo`03
001oo`00009oo`800003Ool007oo0080065oo`03001oogoo02Eoo`03001oogoo00Ioo`03001oogoo
00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo
009oo`04001oogoo0003Ool01P00Oomoo`00Ool0009oo`06001oo`00Ool007oo0P0037oo000;Ool0
0`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool01@00Oomoogoo00000goo00@007ooOol0009oo`03001oo`00009oo`04001oo`00
Ool200000goo0000001ROol00`00Oomoo`0VOol00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomo
o`000goo00@007ooOol0009oo`06001oo`00Ool007oo0P0000=oo`00Ool02goo000;Ool00`00Oomo
o`02Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool01@00Oomoogoo00000goo00@007ooOol0009oo`03001oo`00009oo`07001oo`00001oo`00
Ool00P00HWoo0P00:7oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00Woo00D007ooOomoo`0000Aoo`04001oogoo0003Ool02@00Oomoogoo001oo`00
Ool00002Ool01000Ool007oo0P002goo000:Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomo
o`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00@0
07ooOol0009oo`03001oo`00009oo`05001oo`00001oo`0200000goo001oo`1QOol00`00Oomoo`0W
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`03001oo`00009oo`06
001oo`00Ool007oo0P002goo000:Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00H007ooOol0
07oo0002Ool00`00Ool00002Ool2000017oo00000000Hgoo00<007ooOol0:7oo00<007ooOol01Goo
00<007ooOol017oo00<007ooOol00goo00<007ooOol00goo00D007ooOomoo`0000Aoo`05001oogoo
Ool00003Ool01@00Oomoogoo00000Woo00<007oo00000Woo00@007oo001oo`@000]oo`002Woo00<0
07ooOol00Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo00<0
07ooOol00Woo00D007ooOomoo`0000=oo`06001oogoo001oo`000Woo00H007oo001oo`00Ool20000
0goo0000001SOol00`00Oomoo`0XOol00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol00Woo00@007ooOol000=oo`06001oogoo
001oo`000Woo00@007oo001oo`@000]oo`002Goo00<007ooOol00goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`06
001oogoo001oo`000Woo00@007oo001oo`800003Ool007oo008006=oo`03001oogoo02Uoo`03001o
ogoo00Eoo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`05001o
ogooOol00004Ool01@00Oomoogoo00000Woo00`007ooOomoo`00Ool007oo001oo`00Ool200000goo
0000000:Ool000Uoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo009oo`05001oogooOol00003Ool02P00Oomoo`00Ool007oo001o
o`000Woo0P0000Aoo`00000006Aoo`03001oogoo02Uoo`03001oogoo00Ioo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00003
Ool01000Oomoo`000goo00<007oo00000Woo00H007oo001oo`00Ool2000:Ool000Qoo`03001oogoo
00=oo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
009oo`05001oogooOol00002Ool01000Oomoo`000Woo00D007oo001oo`00009oo`<00003Ool00000
06Aoo`03001oogoo02Yoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo00000Woo
00<007oo00000Woo00@007oo001oo`@000Yoo`0027oo00<007ooOol00goo00<007ooOol017oo00<0
07ooOol017oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`00009o
o`04001oogoo0002Ool01@00Ool007oo00000Woo0`0000=oo`00Ool0I7oo00<007ooOol0:goo00<0
07ooOol01Goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo00D0
07ooOomoo`0000Aoo`04001oogoo0003Ool01P00Oomoo`00Ool0009oo`04001oo`00Ool4000:Ool0
00Qoo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo009oo`05001oogooOol00002Ool01000Oomoo`000Woo00D007oo001oo`00009o
o`<00003Ool007oo06Aoo`03001oogoo02]oo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo
00=oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00004Ool01000Oomoo`000goo00H0
07ooOol007oo0002Ool01000Ool007oo0`0000=oo`00Ool027oo0008Ool00`00Oomoo`03Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00
Oomoogoo00000Woo00@007ooOol0009oo`0:001oo`00Ool007oo001oo`00Ool2001UOol2000]Ool0
0`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
1@00Oomoogoo000017oo00@007ooOol000=oo`06001oogoo001oo`000Woo00@007oo001oo`<00003
Ool007oo00Qoo`001goo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`00009oo`04001oogoo0002Ool01P00
Ool007oo001oo`<00003Ool007oo06Eoo`03001oogoo02aoo`03001oogoo00Eoo`03001oogoo009o
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00004Ool01000Oomo
o`000goo00h007ooOomoo`00Ool007oo001oo`00Ool007oo0`002Goo0007Ool00`00Oomoo`04Ool0
0`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
1@00Oomoogoo00000Woo00@007ooOol0009oo`06001oo`00Ool007oo0`0000=oo`00Ool0IGoo00<0
07ooOol0;Goo00<007ooOol017oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00<0
07ooOol00Woo00D007ooOomoo`0000Aoo`04001oogoo0003Ool01`00Oomoogoo001oo`00009oo`80
009oo`@000Uoo`001goo00<007ooOol017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`00009oo`04001oogoo0002Ool01P00
Ool007oo001oo`<00003Ool007oo06Eoo`03001oogoo02eoo`03001oogoo00Aoo`03001oogoo00=o
o`03001oogoo00=oo`05001oogooOol00004Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=o
o`06001oogoo001oo`000Woo00@007oo001oo`@000Uoo`001goo00<007ooOol017oo00<007ooOol0
17oo00<007ooOol017oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomo
o`00009oo`04001oogoo0002Ool01P00Ool007oo001oo`D006Ioo`03001oogoo02eoo`03001oogoo
00Eoo`03001oogoo009oo`03001oogoo00=oo`05001oogooOol00004Ool01@00Oomoogoo000017oo
00D007ooOomoo`0000=oo`06001oogoo001oo`000Woo00@007oo001oo`@000Uoo`001goo00<007oo
Ool017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool00Woo00D007ooOomoo`00009oo`04001oogoo0002Ool01P00Ool007oo001oo`D006Ioo`03001o
ogoo02ioo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`05001o
ogooOol00004Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`03001oo`00009oo`04001o
o`00Ool300000goo001oo`07Ool000Moo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo009oo`03001oogoo00=oo`05001oogooOol00004Ool00`00Ool00003Ool02000Ool0
07oo001oo`00Ool5001VOol00`00Oomoo`0^Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`05001oogooOol0
0002Ool00`00Ool00002Ool01000Ool007oo0`0000=oo`00Ool01goo0007Ool00`00Oomoo`04Ool0
0`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo0000
17oo00@007ooOol0009oo`08001oo`00Ool007oo001oo`D006Ioo`03001oogoo02ioo`03001oogoo
00Aoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`05001oogoo
Ool00003Ool01@00Oomoogoo00000goo00H007ooOol007oo0002Ool01000Ool007oo0P0000=oo`00
000027oo0007Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool01@00Oomoogoo00000Woo00/007ooOol007oo001oo`00Ool0
07oo00D006Ioo`8002moo`03001oogoo00Eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo00000goo00H007ooOol007oo
0002Ool01P00Ool007oo001oo`<000Qoo`001goo00<007ooOol01Goo00<007ooOol017oo00<007oo
Ool017oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`00009oo`0;
001oogoo001oo`00Ool007oo001oo`05001VOol00`00Oomoo`0_Ool00`00Oomoo`04Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D0
07ooOomoo`0000=oo`06001oogoo001oo`000Woo00H007oo001oo`00Ool30008Ool000Moo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo009oo`05001oogooOol00002Ool02`00Oomoo`00Ool007oo001oo`00Ool01@00IWoo00<007oo
Ool0;goo00<007ooOol017oo00<007ooOol00Woo00<007ooOol00goo00D007ooOomoo`0000Aoo`05
001oogooOol00003Ool01@00Oomoogoo00000Woo00L007ooOomoo`00Ool00002Ool01P00Ool007oo
001oo`<000Qoo`001goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`00009oo`0;001oogoo001oo`00Ool0
07oo001oo`05001VOol00`00Oomoo`0_Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`05001oogooOol00002Ool01000Oomoo`00
0Woo00T007ooOol007oo001oo`00Ool00`0027oo0007Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00@007ooOol0
009oo`03001oo`00009oo`800003Ool0000000<006Ioo`03001oogoo02moo`03001oogoo00Aoo`03
001oogoo009oo`03001oogoo00=oo`05001oogooOol00004Ool01@00Oomoogoo00000goo00D007oo
Oomoo`00009oo`04001oogoo0002Ool02@00Oomoo`00Ool007oo001oo`030008Ool000Moo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo009oo`05001o
ogooOol00004Ool01000Oomoo`000Woo0P000Woo0P0000=oo`0000000`00IWoo00<007ooOol0<7oo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00D007ooOomoo`0000Aoo`05001oogoo
Ool00003Ool01000Oomoo`000goo00@007ooOol0009oo`09001oogoo001oo`00Ool007oo00<000Qo
o`001goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol00goo00D007oo
Oomoo`0000Aoo`05001oogooOol00002Ool02@00Oomoo`00Ool007oo001oo`06001VOol00`00Oomo
o`0`Ool00`00Oomoo`03Ool01@00Oomoogoo00001Woo00D007ooOomoo`0000Aoo`05001oogooOol0
0003Ool01000Oomoo`000goo00@007ooOol0009oo`09001oogoo001oo`00Ool007oo00<000Qoo`00
1goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol00goo00<007ooOol0
0Woo00D007ooOomoo`0000=oo`03001oogoo00H00003Ool007oo00H002Qoo`8000Aoo`03001oogoo
009oo`<0031oo`03001oogoo031oo`8000Aoo`04001oogooOol40003Ool01@00Oomoogoo000017oo
00D007ooOomoo`0000=oo`04001oogoo0003Ool01000Oomoo`000Woo00<007oo00000Woo00@007oo
001oo`<000Qoo`001goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
0goo00<007ooOol00Woo00D007ooOomoo`0000=oo`04001oogoo0002Ool01P00Ool007oo001oo`H0
02Moo`04001oogoo000;Ool00`00Oomoo`0]Ool00`00Oomoo`0_Ool200000goo001oo`02Ool01@00
Oomoogoo00000goo00@007ooOol0009oo`03001oogoo009oo`05001oogooOol00004Ool01000Oomo
o`000goo00@007ooOol0009oo`03001oo`00009oo`04001oo`00Ool30008Ool000Moo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00=oo`05001oogooOol00003Ool00`00
Oomoo`02Ool02`00Oomoo`00Ool007oo001oo`00Ool01P009goo00@007ooOol000]oo`03001oogoo
02eoo`80031oo`04001oo`000003Ool01@00Oomoogoo00000goo00<007oo00000goo00<007ooOol0
0Woo00D007ooOomoo`0000Aoo`04001oogoo0003Ool01000Oomoo`000Woo00<007oo00000Woo00D0
07oo000007oo008000Qoo`0027oo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol00Woo00@007ooOomoo`D0009oo`03001oo`00009oo`05001oo`00001o
o`04000QOol40002Ool01000Oomoo`0027oo0`00<7oo00<007ooOol0;goo00@007oo000000=oo`04
001oogooOol40002Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`05001oogooOol00002
Ool01@00Oomoogoo00000Woo00<007oo00000Woo00D007oo000007oo008000Qoo`0027oo00<007oo
Ool01Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol017oo00D007ooOomoo`0000=oo`05
001oogooOol00002Ool01`00Ool00000Ool007oo00800003Ool00000008002Moo`04001oogoo0008
Ool00`00Oomoo`0`Ool00`00Oomoo`0_Ool01000Ool000000goo00@007ooOomoo`8000Aoo`05001o
ogooOol00004Ool01@00Oomoogoo00000goo00@007ooOol000=oo`04001oogoo0002Ool02@00Oomo
o`00Ool007oo001oo`0200000goo001oo`07Ool000Qoo`03001oogoo00Ioo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00=oo`05001oogooOol00003Ool01@00Oomoogoo00000Woo100000=o
o`00Ool00P0000=oo`0000000P009goo00@007ooOol000Qoo`03001oogoo031oo`03001oogoo02mo
o`04001oo`000003Ool01000Oomoogoo0P0017oo00D007ooOomoo`0000Aoo`05001oogooOol00003
Ool01000Oomoo`000goo00@007ooOol0009oo`09001oogoo001oo`00Ool007oo00800003Ool007oo
00Moo`0027oo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00D0
07ooOomoo`0000=oo`05001oogooOol00002Ool300001Goo001oo`00Ool01@00:7oo0P002Goo1000
;goo00<007ooOol0<7oo0P0017oo00@007ooOomoo`H000Aoo`05001oogooOol00004Ool01@00Oomo
ogoo00000Woo00D007ooOomoo`00009oo`04001oogoo0002Ool01P00Ool007oo001oo`<000Uoo`00
2Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol00goo00D007ooOomo
o`0000=oo`05001oogooOol00002Ool00`00Ool00002Ool200000goo00000004001UOol00`00Oomo
o`0`Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol00Woo00D007ooOomoo`0000=o
o`05001oogooOol00003Ool01@00Oomoogoo00000Woo00H007ooOol007oo0002Ool01000Ool007oo
0`002Goo0009Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool0
1@00Oomoogoo00000goo00L007ooOomoo`00Ool00002Ool01000Ool007oo1`00IGoo00<007ooOol0
<7oo00<007ooOol00goo00D007ooOomoo`0000Aoo`03001oogoo009oo`05001oogooOol00003Ool0
1@00Oomoogoo00000goo00@007ooOol0009oo`04001oogoo0002Ool02000Ool007oo001oo`00Ool2
0009Ool000Uoo`03001oogoo00Moo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00=oo`05
001oogooOol00003Ool01@00Oomoogoo00000Woo00P007oo001oo`00Ool007oo0P0000=oo`000000
IGoo00<007ooOol0<7oo00<007ooOol00goo00@007ooOol000Eoo`05001oogooOol00004Ool01@00
Oomoogoo00000goo00@007ooOol000=oo`04001oogoo0002Ool02@00Oomoo`00Ool007oo001oo`02
00000goo001oo`08Ool000Yoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Aoo`03001o
ogoo00=oo`03001oogoo009oo`05001oogooOol00002Ool01000Oomoo`000Woo00D007oo000007oo
00D006Eoo`03001oogoo031oo`03001oogoo009oo`05001oogooOol00004Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool01@00Oomoogoo00000goo00@007ooOol000=oo`04001oogoo0002Ool02@00Oomo
o`00Ool007oo001oo`0200000goo001oo`08Ool00?l00200005oo`001goo00@007ooOol000Qoo`80
00Qoo`8000Eoo`03001oogoo00=oo`03001oogoo009oo`06001oogooOol007oo0P000Woo00<007oo
Ool00P0000=oo`00Ool0100027oo00<007ooOol027oo00<007ooOol02Goo00<007ooOol02Goo00<0
07ooOol027oo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02Goo00<0
07ooOol02Goo00<007ooOol027oo00<007ooOol02Goo00<007ooOol02Goo00@007ooOol000Eoo`05
001oo`00Ool00004Ool01000Oomoogoo0P000goo00D007ooOomoo`0000=oo`04001oogoo0003Ool0
0`00Oomoo`0200002Woo001oogoo001oo`00Ool007oo0`0000=oo`00Ool027oo000:Ool00`00Oomo
o`08Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo0P00
00Aoo`00Ool0009oo`80009oo`D002]oo`03001oogoo03Moo`03001oogoo02]oo`05001oogooOol0
0005Ool01@00Ool007oo000017oo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool01000Oomo
o`000goo00@007ooOol0009oo`09001oogoo001oo`00Ool007oo00800003Ool007oo00Uoo`002goo
00<007ooOol027oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol00Woo
00D007ooOomoo`00009oo`04001oogoo0002Ool200000goo00000004001TOol00`00Oomoo`0[Ool0
1@00Oomoogoo00001Goo00D007ooOomoo`0000=oo`05001oogooOol00004Ool01@00Oomoogoo0000
17oo00<007oo00000goo00D007ooOomoo`00009oo`03001oo`00009oo`04001oo`00Ool200000goo
001oo`09Ool000]oo`03001oogoo00Qoo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00=o
o`03001oogoo009oo`05001oogooOol00002Ool00`00Ool00002Ool200000goo001oo`04001TOol0
0`00Oomoo`0ZOol00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00D007ooOomo
o`0000Aoo`05001oogooOol00003Ool01000Oomoo`000goo00@007ooOol000=oo`05001oo`00Ool0
0002Ool2000017oo001oo`002Woo000<Ool00`00Oomoo`08Ool00`00Oomoo`05Ool00`00Oomoo`05
Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00@007ooOol0009oo`03001oogoo00800003Ool0
000000<006Aoo`03001oogoo02Yoo`05001oogooOol00005Ool01@00Oomoogoo000017oo00D007oo
Oomoo`0000=oo`03001oogoo009oo`05001oogooOol00002Ool01000Oomoo`000goo00H007ooOol0
07oo0002Ool02@00Ool007oo001oo`00Ool0000:Ool000aoo`03001oogoo00Qoo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00002Ool00`00Ool0
0002Ool2000017oo000007oo0`00Hgoo00<007ooOol0:Woo00D007ooOomoo`0000Aoo`05001oogoo
Ool00005Ool01000Oomoo`0017oo00D007ooOomoo`0000=oo`04001oogoo0003Ool01000Oomoo`00
0goo00<007oo00000Woo00@007oo001oo`800003Ool007oo00Yoo`003Goo00<007ooOol027oo00<0
07ooOol01Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol00Woo00D007ooOomoo`00009o
o`08001oo`00Ool007oo001oo`D006=oo`03001oogoo02Uoo`03001oogoo009oo`03001oogoo009o
o`05001oogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`00009o
o`05001oogooOol00002Ool01000Oomoo`000Woo00/007oo001oo`00Ool007oo001oo`0000]oo`00
3Goo00<007ooOol02Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol00goo00<007ooOol0
0Woo00@007ooOol0009oo`07001oogoo001oo`00Ool01P00Hgoo0P00:Woo00<007ooOol00Woo00D0
07ooOomoo`0000=oo`03001oogoo00=oo`05001oogooOol00003Ool01@00Oomoogoo00000goo00@0
07ooOol000=oo`04001oogoo0003Ool00`00Ool00002Ool02@00Ool007oo001oo`00Ool0000;Ool0
00ioo`03001oogoo00Qoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00=oo`05001oogoo
Ool00003Ool02`00Oomoo`00Ool007oo001oo`00Ool01@00HWoo00<007ooOol0:7oo00<007ooOol0
0goo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool0
1@00Oomoogoo00000Woo00D007ooOomoo`00009oo`04001oogoo0002Ool01@00Ool007oo00000Woo
0P003Woo000>Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`04Ool0
1@00Oomoogoo00000goo00/007ooOol007oo001oo`00Ool007oo00@0069oo`03001oogoo02Qoo`03
001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00D007oo
Oomoo`0000=oo`04001oogoo0003Ool01000Oomoo`000goo00<007oo00000Woo00<007oo00000Woo
0P003Woo000?Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`02Ool01000Oomoo`000goo00@007oo0000009oo`D0069oo`03001oogoo02Qoo`03001o
ogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol0
0Woo00@007ooOol000=oo`05001oogooOol00002Ool01000Oomoo`000Woo00<007oo00000Woo00@0
07oo000000moo`0047oo00<007ooOol02Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
0goo00<007ooOol00Woo00@007ooOol0009oo`08001oo`00Ool007oo001oo`@0065oo`03001oogoo
02Moo`03001oogoo00=oo`04001oogoo0003Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo00D0
07ooOomoo`0000=oo`04001oogoo0003Ool01000Oomoo`000goo00<007oo00000Woo00<007oo0000
0Woo0P003goo000AOol00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool01000Oomoo`000Woo00H007oo001oo`00Ool5001QOol00`00Oomoo`0WOol0
0`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001o
ogoo009oo`04001oogoo0003Ool01000Oomoo`000goo00@007ooOol0009oo`03001oo`00009oo`05
001oo`00Ool0000?Ool0019oo`03001oogoo00Qoo`03001oogoo00Ioo`03001oogoo00Eoo`03001o
ogoo00=oo`03001oogoo009oo`04001oogoo0002Ool01000Ool000000Woo0P0000=oo`000000H7oo
00<007ooOol09Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo00=oo`04001oogoo
0004Ool01@00Oomoogoo00000goo00@007ooOol000=oo`04001oogoo0003Ool00`00Ool00002Ool0
0`00Ool00002Ool2000@Ool0019oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo00Eoo`03
001oogoo00=oo`03001oogoo009oo`03001oo`0000=oo`07001oo`00001oo`00Ool01000Ggoo00<0
07ooOol09Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol0
0003Ool01@00Oomoogoo00000goo00@007ooOol000=oo`05001oogooOol00002Ool01P00Oomoo`00
Ool0009oo`05001oo`00Ool0000@Ool001=oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo
00Aoo`03001oogoo00=oo`03001oogoo009oo`04001oogoo0003Ool200000goo001oo`0200000goo
0000001OOol00`00Oomoo`0VOol01@00Oomoogoo00000goo00D007ooOomoo`0000Eoo`04001oogoo
0004Ool01@00Oomoogoo00000Woo00D007ooOomoo`00009oo`05001oogooOol00002Ool01000Oomo
o`000Woo00L007oo001oo`00Ool0000AOol001Aoo`03001oogoo00Uoo`03001oogoo00Ioo`03001o
ogoo00Aoo`03001oogoo00=oo`03001oogoo009oo`04001oogoo0003Ool200001Woo000007oo001o
o`8005ioo`8002Ioo`05001oogooOol00004Ool01@00Oomoogoo000017oo00@007ooOol000Aoo`05
001oogooOol00003Ool01000Oomoo`000goo00D007ooOomoo`00009oo`08001oogoo001oo`00Ool0
009oo`03001oo`00015oo`005Goo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol00Woo00@007ooOol0009oo`07001oo`00001oo`00Ool00`00GWoo00<0
07ooOol09Goo00@007ooOol000Aoo`05001oogooOol00005Ool00`00Ool00005Ool01000Oomoo`00
0goo00D007ooOomoo`00009oo`05001oogooOol00002Ool01P00Oomoo`00Ool0009oo`05001oo`00
Ool0000BOol001Ioo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00=o
o`03001oogoo009oo`04001oogoo0002Ool01`00Ool00000Ool007oo00<005eoo`03001oogoo02Ao
o`05001oogooOol00004Ool01@00Oomoogoo000017oo00<007oo00001Goo00@007ooOol000Aoo`04
001oogoo0002Ool01@00Oomoogoo00000Woo00T007ooOomoo`00Ool007oo00000Woo00<007oo0000
4Woo000GOol00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool01000Oomoo`000Woo00<007oo00000P0000Aoo`00000005eoo`03001oogoo02Aoo`04
001oogoo0004Ool01@00Oomoogoo000017oo00@007ooOol000Aoo`04001oogoo0004Ool01000Oomo
o`000goo00@007ooOol0009oo`09001oogooOol007oo001oo`00009oo`03001oo`0001=oo`0067oo
00<007ooOol02Goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol00Woo
00@007ooOol0009oo`03001oo`0000800004Ool00000001LOol00`00Oomoo`0SOol01000Oomoo`00
1Goo00@007ooOol000Aoo`04001oogoo0004Ool01@00Oomoogoo00000goo00D007ooOomoo`00009o
o`05001oogooOol00002Ool02000Oomoo`00Ool007oo0002Ool00`00Ool0000DOol001Uoo`03001o
ogoo00Uoo`03001oogoo00Ioo`03001oogoo00Aoo`8000Aoo`8000=oo`04001oogoo0002Ool00`00
Ool00002000017oo00000000Fgoo00<007ooOol08Woo00@007ooOol000Eoo`04001oogoo0004Ool0
1000Oomoo`0017oo00D007ooOomoo`0000=oo`05001oogooOol00002Ool01@00Oomoogoo00000Woo
00H007ooOol007oo0002Ool01P00Oomoo`00Ool001Aoo`006Woo00<007ooOol02Goo00<007ooOol0
1Woo00<007ooOol01Goo00<007ooOol00goo00D007ooOomoo`00009oo`05001oogoo001oo`030000
0goo0000001KOol00`00Oomoo`0QOol01000Oomoo`001Goo00@007ooOol000Aoo`04001oogoo0004
Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007oo00000goo00@007ooOol0009oo`06001o
ogoo001oo`000Woo00<007oo00005Goo000KOol00`00Oomoo`09Ool00`00Oomoo`06Ool20006Ool0
0`00Oomoo`03Ool01@00Oomoogoo00000Woo00D007ooOol007oo00<00003Ool0000005Yoo`03001o
ogoo021oo`05001oogooOol00003Ool20002Ool00`00Oomoo`02Ool01000Oomoo`0017oo00D007oo
Oomoo`0000=oo`03001oogoo009oo`03001oo`0000=oo`05001oogooOol00002Ool01@00Ool007oo
00000Woo00<007oo00005Woo000LOol00`00Oomoo`09Ool20008Ool00`00Oomoo`04Ool20004Ool0
1@00Oomoogoo00000Woo00D007ooOol007oo00H005Uoo`03001oogoo01moo`05001oogooOol00003
Ool01@00Oomoogoo000017oo00@007ooOol000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool0
0`00Ool00003Ool01@00Oomoogoo00000Woo00D007oo001oo`00009oo`03001oo`0001Moo`007Goo
00<007ooOol02Woo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol00Woo00D007ooOomoo`00
009oo`05001oogoo001oo`06001HOol2000OOol01@00Oomoogoo00000goo00D007ooOomoo`0000Ao
o`05001oogooOol00003Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007oo00000goo00D0
07ooOomoo`00009oo`0:001oogoo001oo`00Ool007oo000HOol001ioo`03001oogoo00Yoo`03001o
ogoo00Ioo`03001oogoo00Eoo`03001oogoo009oo`80009oo`03001oogoo00800003Ool007oo0080
0004Ool00000001GOol00`00Oomoo`0MOol01@00Oomoogoo00000goo00D007ooOomoo`0000Aoo`05
001oogooOol00003Ool01@00Oomoogoo00000goo00@007ooOomoo`80009oo`05001oogooOol00002
Ool01000Oomoo`000Woo00L007oo001oo`00Ool0000IOol001moo`8000]oo`03001oogoo00Ioo`80
00Ioo`8000Aoo`04001oogoo0003Ool00`00Ool0000300000goo0000001GOol00`00Oomoo`0MOol0
1@00Oomoogoo00000Woo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool0
1000Oomoo`000goo00D007ooOomoo`0000=oo`07001oogooOol007oo00000Woo00<007oo00000Woo
00<007oo00006Goo000QOol00`00Oomoo`09Ool20008Ool00`00Oomoo`05Ool00`00Oomoo`02Ool0
1000Oomoo`000goo00<007ooOol00`0000=oo`000000EWoo00<007ooOol077oo00H007ooOomoo`00
Ool20003Ool01000Oomoogoo0P000Woo0P000Woo0P0017oo00@007ooOol000=oo`05001oogooOol0
0003Ool01`00Oomoogoo001oo`00009oo`03001oo`00009oo`03001oo`0001Yoo`008Woo00<007oo
Ool02Woo00<007ooOol01Woo00<007ooOol01Goo0P000goo0P0000=oo`0000000Woo0P0000Eoo`00
000007oo008005Eoo`03001oogoo01]oo`07001oogooOol007oo000017oo00D007ooOomoo`0000=o
o`05001oogooOol00005Ool01000Oomoo`000goo00D007ooOomoo`0000=oo`07001oogooOol007oo
00000goo0P000Woo00<007oo00006goo000SOol00`00Oomoo`0:Ool20007Ool20007Ool00`00Oomo
o`02Ool01000Oomoo`000goo00@007oo001oo`@005Aoo`03001oogoo01Yoo`03001oogoo00800003
Ool007oo00=oo`05001oogooOol00003Ool01@00Oomoogoo00001Goo00@007ooOol000=oo`05001o
ogooOol00003Ool01`00Oomoogoo001oo`0000=oo`80009oo`03001oo`0001aoo`0097oo0P0037oo
0P001goo0P001Woo0P000goo0P0000=oo`0000000Woo0`0000=oo`0000000P00Dgoo00<007ooOol0
6Goo00@007ooOol0009oo`03001oogoo009oo`05001oogooOol00002Ool20003Ool00`00Oomoo`02
Ool20002Ool01@00Oomoogoo00000goo00D007ooOomoo`00009oo`800003Ool007oo009oo`80009o
o`03001oo`0001eoo`009Woo00<007ooOol02goo00<007ooOol01Woo0P001Woo00<007ooOol00Woo
00<007ooOol00P000Woo1`00DWoo00<007ooOol067oo00@007ooOol0009oo`03001oogoo009oo`03
001oogoo0080009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo0080009oo`8000=oo`03
001oogoo0080009oo`04001oogoo0002Ool30002Ool00`00Ool0000NOol002Moo`8000aoo`8000Qo
o`8000Eoo`8000=oo`80009oo`07001oogoo001oo`00Ool00`00DGoo00<007ooOol05goo00D007oo
000007oo008000Aoo`04001oogoo0002Ool20003Ool20003Ool20002Ool01@00Oomoogoo00000goo
0P000Woo00D007ooOomoo`00009oo`06001oogoo001oo`000Woo00<007oo00007goo000YOol00`00
Oomoo`0;Ool00`00Oomoo`07Ool20005Ool00`00Oomoo`02Ool2000017oo000007oo2000Cgoo0P00
5goo00<007oo00000Woo00<007ooOol00Woo0P000Woo00@007ooOol000Aoo`03001oogoo009oo`03
001oogoo008000=oo`05001oogooOol00003Ool01@00Oomoogoo00000Woo00H007ooOol007oo0002
Ool01000Oomoo`007goo000ZOol2000<Ool20009Ool00`00Oomoo`03Ool20004Ool00`00Oomoo`02
00000goo001oo`05001>Ool00`00Oomoo`0DOol200001Goo001oogoo00000goo0P000Woo0P000Woo
00@007ooOomoo`8000Aoo`04001oogoo0004Ool01@00Oomoogoo00000goo00D007ooOomoo`00009o
o`06001oogoo001oo`000Woo00@007ooOol0021oo`00;7oo00<007ooOol02goo0P0027oo0P001Goo
0P000goo0P000Woo2P00C7oo00<007ooOol04Woo0P0000=oo`0000000Woo00<007ooOol00P000goo
00<007ooOol00P000goo00<007ooOol00Woo0P0000=oo`00000017oo00<007ooOol00P000Woo0P00
0Woo0P000Woo00H007ooOol007oo0002Ool01000Oomoo`008Goo000]Ool2000=Ool20008Ool20005
Ool20003Ool20002Ool9001;Ool00`00Oomoo`0AOol01000Oomoo`000Woo0P0000=oo`0000000goo
0P000Woo00@007ooOomoo`8000Aoo`04001oo`000004Ool20002Ool01@00Oomoogoo00000goo00<0
07ooOol00P0000Eoo`00001oo`00009oo`04001oogoo000ROol002moo`8000eoo`8000Qoo`8000Eo
o`8000=oo`80009oo`P004Yoo`03001oogoo00moo`800004Ool00000Ool200000goo00000003Ool2
0003Ool00`00Oomoo`020004Ool200000goo001oo`03Ool20002Ool20002Ool20003Ool01000Oomo
o`000Woo00@007ooOol0009oo`04001oogoo000SOol0035oo`8000eoo`8000Qoo`8000Eoo`8000=o
o`80009oo`P004Qoo`03001oogoo00eoo`800004Ool00000Ool20002Ool00`00Oomoo`02Ool01000
Oomoogoo0P000Woo00<007ooOol00Woo0P0000=oo`0000000goo0P000goo00D007ooOomoo`0000Ao
o`04001oogoo0002Ool01@00Ool00000Ool00P000Woo00<007ooOol08Woo000cOol2000=Ool30007
Ool20005Ool20003Ool20002Ool7000cOol20004Ool00`00Oomoo`02Ool30006Ool00`00Oomoo`0<
Ool01000Ool000000Woo00<007ooOol00P000goo0P000Woo0P000Woo0P000goo0P000Woo00@007oo
Oomoo`8000Aoo`03001oogoo008000=oo`80009oo`06001oo`00001oo`000Woo00<007ooOol00P00
9Goo000eOol2000>Ool20007Ool20005Ool20003Ool300000goo00000005000`Ool01000Oomoo`00
2goo00<007ooOol00goo00<007ooOol02Woo10000Woo0P0000=oo`0000000goo0P000Woo0P000goo
00@007ooOomoo`80009oo`8000=oo`03001oogoo009oo`80009oo`04001oogooOol20002Ool40002
Ool01000Oomoo`000Woo00<007ooOol09Goo000gOol3000=Ool30006Ool30004Ool20004Ool30000
0goo00000004000^Ool01000Oomoo`002goo00<007ooOol00goo0`0027oo10000Woo0P0000=oo`00
00000Woo0`000Woo0P000goo0P000Woo0P000Woo0P000goo0P000goo0P000Woo0P000Woo0P000Woo
0P0000Aoo`00Oomoo`800004Ool00000Ool2000XOol003Yoo`8000ioo`8000Moo`<000=oo`<000Ao
o`800003Ool0000000@002aoo`04001oogoo0008Ool30006Ool00`00Oomoo`07Ool30002Ool20000
0goo00000002Ool20002Ool30003Ool20002Ool20002Ool20003Ool20003Ool20002Ool20002Ool2
0002Ool200000goo00000002Ool01@00Oomoo`00Ool00P00:Woo000lOol3000=Ool30007Ool30003
Ool30003Ool9000ZOol01000Oomoo`0027oo00<007ooOol01Woo00<007ooOol01Goo0`0000Eoo`00
000007oo00800004Ool000000002Ool20003Ool30002Ool20002Ool20003Ool20003Ool20002Ool2
0003Ool00`00Oomoo`0200000goo00000002Ool200001Goo000007oo0000;7oo000oOol3000=Ool2
0008Ool40002Ool30003Ool8000XOol01000Oomoo`0027oo00<007ooOol01Woo00<007ooOol00Woo
3P000Woo0`000Woo0`000Woo0`000Woo0P000goo0P000goo0P000Woo0P000goo0P000Woo00@007oo
Ool0009oo`80009oo`04001oo`00000]Ool0049oo`8000eoo`<000Uoo`<0009oo`@00003Ool00000
00L002Ioo`8000Uoo`@000Eoo`P00005Ool00000001oo`030003Ool200000goo000000020003Ool2
0003Ool20003Ool20003Ool20002Ool20003Ool20002Ool200000goo00000002Ool00`00Oomoo`02
00000goo001oo`0^Ool004Aoo`<000eoo`8000Yoo`<000=oo`d003Eoo`l000Aoo`D000Aoo`<0009o
o`<0009oo`<000=oo`80009oo`8000=oo`80009oo`800003Ool00000009oo`800004Ool00000Ool2
000`Ool004Moo`<000aoo`<000Yoo`@0009oo`h002ioo`H00005Ool00000001oo`030004Ool60004
Ool30002Ool30003Ool20004Ool20002Ool20003Ool20002Ool200000goo00000002Ool20002Ool0
1000Oomoo`00<Woo001:Ool2000=Ool4000:OolE000VOol500000goo000000060002Ool80004Ool3
0003Ool20003Ool30004Ool20002Ool20003Ool20002Ool200000goo00000002Ool20002Ool20000
0goo0000000cOol004aoo`@000eoo`D000UooaD001eoo`h000=oo`T000Aoo`<000=oo`<0009oo`<0
00=oo`@0009oo`8000=oo`80009oo`800003Ool00000009oo`8000=oo`04001oo`00000eOol0051o
o`@000ioo`L000IooaX000eoo`l000Aoo`T000Aoo`D0009oo`@000=oo`80009oo`@0009oo`@0009o
o`<00003Ool0000000@0009oo`8000=oo`800003Ool007oo03Ioo`00E7oo1@0047oo@`0017oo1P00
0goo100017oo0`0000Aoo`000000009oo`@000Aoo`80009oo`800003Ool00000009oo`<000=oo`80
0003Ool0000003Qoo`00FGoo1P004goo<00017oo2P001Goo10000goo2@000Woo0`0017oo10000Woo
0P0000=oo`0000000Woo0P000goo0`0000=oo`000000>Woo001OOol8000>Ool200000goo00000005
00000goo0000000T0004Ool00`00Oomoo`0D0002Ool40003Ool40003Ool60002Ool20002Ool30000
17oo00000000?7oo001WOol;0005OolJ0004OolH00000goo0000000<0004Ool30003Ool40005Ool5
0003Ool200001Goo00000000Ool00`00?goo001bOolD0002OolV00000goo000000040006Ool50000
0goo000000030004Ool70003Ool3000017oo000007oo0`00@Woo001lOol800000goo000000050000
0goo0000000P0006Ool<0003Ool90003Ool40002Ool50015Ool007moo`P00003Ool0000000P00003
Ool0000000D00003Ool0000001d000Aoo`H000=oo`<000=oo`<000Aoo`@004Qoo`00PWoo20000goo
300000=oo`00000060000Woo200017oo1@000Woo10000goo1@00Bgoo0025Ool300000goo00000003
0005Ool@0007Ool<0006Ool60002Ool50002Ool8001=Ool008Qoo`@0009oo`H000Iooa8000Yoo`H0
009oo`H00003Ool0000000@0009oo`<0051oo`00S7oo10000Woo3P0027oo3P000Woo1P0000=oo`00
000010000goo1@00Dgoo002@Ool600000goo000000030004OolO0003Ool6001HOol009Iooad000Uo
o`H005ioo`00X7oo7000I7oo002ZOol00`00Oomoo`1cOol00:Yoo`03001oogoo07=oo`00ZWoo0P00
M7oo002ZOol00`00Oomoo`1cOol00001\
\>"],
  ImageRangeCache->{{{0, 358.75}, {221.125, 0}} -> {-1.4634, -1.2227, \
0.0085838, 0.0115118}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(sol\  = \ 
        NDSolve[system, \ 
          Method \[Rule] {"\<Projection\>", \ 
              Method -> "\<ExplicitEuler\>", \[IndentingNewLine]"\<Invariants\
\>" \[Rule] {H, L}}, \ 
          StartingStepSize \[Rule] step];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(ParametricPlot[Evaluate[pvars\  /. \ First[sol]], \ 
        Evaluate[time]];\)\)}], "Input",
  CellLabel->"In[30]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.492956 0.334833 0.312115 0.205603 [
[.15812 .29961 -6 -9 ]
[.15812 .29961 6 0 ]
[.32554 .29961 -12 -9 ]
[.32554 .29961 12 0 ]
[.66037 .29961 -9 -9 ]
[.66037 .29961 9 0 ]
[.82779 .29961 -3 -9 ]
[.82779 .29961 3 0 ]
[.99521 .29961 -9 -9 ]
[.99521 .29961 9 0 ]
[.48046 .00371 -24 -4.5 ]
[.48046 .00371 0 4.5 ]
[.48046 .10651 -12 -4.5 ]
[.48046 .10651 0 4.5 ]
[.48046 .20931 -24 -4.5 ]
[.48046 .20931 0 4.5 ]
[.48046 .41492 -18 -4.5 ]
[.48046 .41492 0 4.5 ]
[.48046 .51772 -6 -4.5 ]
[.48046 .51772 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15812 .31211 m
.15812 .31836 L
s
[(-1)] .15812 .29961 0 1 Mshowa
.32554 .31211 m
.32554 .31836 L
s
[(-0.5)] .32554 .29961 0 1 Mshowa
.66037 .31211 m
.66037 .31836 L
s
[(0.5)] .66037 .29961 0 1 Mshowa
.82779 .31211 m
.82779 .31836 L
s
[(1)] .82779 .29961 0 1 Mshowa
.99521 .31211 m
.99521 .31836 L
s
[(1.5)] .99521 .29961 0 1 Mshowa
.125 Mabswid
.19161 .31211 m
.19161 .31586 L
s
.22509 .31211 m
.22509 .31586 L
s
.25857 .31211 m
.25857 .31586 L
s
.29206 .31211 m
.29206 .31586 L
s
.35902 .31211 m
.35902 .31586 L
s
.39251 .31211 m
.39251 .31586 L
s
.42599 .31211 m
.42599 .31586 L
s
.45947 .31211 m
.45947 .31586 L
s
.52644 .31211 m
.52644 .31586 L
s
.55992 .31211 m
.55992 .31586 L
s
.59341 .31211 m
.59341 .31586 L
s
.62689 .31211 m
.62689 .31586 L
s
.69386 .31211 m
.69386 .31586 L
s
.72734 .31211 m
.72734 .31586 L
s
.76082 .31211 m
.76082 .31586 L
s
.79431 .31211 m
.79431 .31586 L
s
.86127 .31211 m
.86127 .31586 L
s
.89476 .31211 m
.89476 .31586 L
s
.92824 .31211 m
.92824 .31586 L
s
.96172 .31211 m
.96172 .31586 L
s
.12464 .31211 m
.12464 .31586 L
s
.09116 .31211 m
.09116 .31586 L
s
.05767 .31211 m
.05767 .31586 L
s
.02419 .31211 m
.02419 .31586 L
s
.25 Mabswid
0 .31211 m
1 .31211 L
s
.49296 .00371 m
.49921 .00371 L
s
[(-1.5)] .48046 .00371 1 0 Mshowa
.49296 .10651 m
.49921 .10651 L
s
[(-1)] .48046 .10651 1 0 Mshowa
.49296 .20931 m
.49921 .20931 L
s
[(-0.5)] .48046 .20931 1 0 Mshowa
.49296 .41492 m
.49921 .41492 L
s
[(0.5)] .48046 .41492 1 0 Mshowa
.49296 .51772 m
.49921 .51772 L
s
[(1)] .48046 .51772 1 0 Mshowa
.125 Mabswid
.49296 .02427 m
.49671 .02427 L
s
.49296 .04483 m
.49671 .04483 L
s
.49296 .06539 m
.49671 .06539 L
s
.49296 .08595 m
.49671 .08595 L
s
.49296 .12707 m
.49671 .12707 L
s
.49296 .14763 m
.49671 .14763 L
s
.49296 .16819 m
.49671 .16819 L
s
.49296 .18875 m
.49671 .18875 L
s
.49296 .22987 m
.49671 .22987 L
s
.49296 .25043 m
.49671 .25043 L
s
.49296 .27099 m
.49671 .27099 L
s
.49296 .29155 m
.49671 .29155 L
s
.49296 .33268 m
.49671 .33268 L
s
.49296 .35324 m
.49671 .35324 L
s
.49296 .3738 m
.49671 .3738 L
s
.49296 .39436 m
.49671 .39436 L
s
.49296 .43548 m
.49671 .43548 L
s
.49296 .45604 m
.49671 .45604 L
s
.49296 .4766 m
.49671 .4766 L
s
.49296 .49716 m
.49671 .49716 L
s
.49296 .53828 m
.49671 .53828 L
s
.49296 .55884 m
.49671 .55884 L
s
.49296 .5794 m
.49671 .5794 L
s
.49296 .59996 m
.49671 .59996 L
s
.25 Mabswid
.49296 0 m
.49296 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.62689 .31212 m
.61091 .35626 L
.57206 .39039 L
.51073 .41808 L
.44868 .43238 L
.39363 .43775 L
.34659 .43788 L
.2996 .43422 L
.25496 .42718 L
.2152 .41778 L
.17763 .40578 L
.12197 .3808 L
.095 .36424 L
.0738 .34794 L
.05685 .33157 L
.04468 .3166 L
.03505 .3009 L
.02873 .28619 L
.02486 .27083 L
.02381 .25448 L
.02547 .24047 L
.02978 .22604 L
.03548 .2141 L
.04383 .20143 L
.05644 .18716 L
.0705 .17486 L
.08971 .16165 L
.11082 .15022 L
.13127 .14134 L
.15529 .133 L
.18432 .1253 L
.2137 .11972 L
.24577 .11579 L
.26282 .11454 L
.28216 .11378 L
.31816 .11416 L
.35357 .11676 L
.37601 .11957 L
.39771 .12316 L
.4395 .13267 L
.46347 .13982 L
.48571 .14772 L
.50988 .15795 L
.53561 .17106 L
.57356 .19651 L
.60427 .227 L
.62751 .27329 L
.62538 .32502 L
.59479 .36872 L
.56477 .38838 L
Mistroke
.53119 .40269 L
.46373 .41834 L
.39373 .42236 L
.35619 .42037 L
.31974 .4159 L
.29109 .4106 L
.26228 .40362 L
.20673 .3849 L
.16466 .36508 L
.13221 .34511 L
.10825 .32645 L
.08653 .30475 L
.07125 .28434 L
.06153 .26629 L
.05797 .25732 L
.05504 .24756 L
.05232 .2307 L
.05248 .21539 L
.0537 .20687 L
.05584 .19812 L
.06179 .18304 L
.06625 .17496 L
.07111 .16769 L
.08458 .15204 L
.09891 .13952 L
.11662 .1274 L
.13399 .11792 L
.15466 .10886 L
.17918 .10051 L
.20416 .09411 L
.22038 .09093 L
.23641 .08845 L
.25134 .0867 L
.26814 .08532 L
.29741 .08435 L
.33149 .08538 L
.34925 .0868 L
.36888 .08909 L
.40547 .09534 L
.441 .10405 L
.47915 .11661 L
.51184 .13052 L
.54698 .14965 L
.58177 .17484 L
.61066 .20438 L
.63035 .23639 L
.63988 .27763 L
.62589 .32975 L
.60743 .35489 L
.58071 .37587 L
Mistroke
.51478 .4017 L
.44437 .41081 L
.3774 .40799 L
.3216 .39807 L
.27856 .38555 L
.23861 .3696 L
.20255 .35078 L
.17124 .32987 L
.14783 .31017 L
.13032 .29185 L
.11471 .27105 L
.10777 .25933 L
.10261 .24881 L
.09859 .23869 L
.09533 .22791 L
.09303 .21676 L
.09193 .20647 L
.09236 .18867 L
.09601 .17076 L
.10151 .15633 L
.10998 .14138 L
.12275 .12534 L
.13707 .11195 L
.15545 .09875 L
.17763 .08664 L
.1992 .07762 L
.22098 .0706 L
.24669 .0645 L
.26185 .06185 L
.27608 .05995 L
.30306 .05776 L
.31716 .05731 L
.33301 .05735 L
.36191 .05884 L
.38983 .06201 L
.40707 .06481 L
.42364 .06811 L
.45519 .07616 L
.48952 .08771 L
.52684 .10415 L
.55922 .12255 L
.58714 .14271 L
.60171 .15549 L
.61643 .17072 L
.63896 .20231 L
.65282 .23728 L
.65461 .27997 L
.63894 .32036 L
.59554 .365 L
.52897 .39434 L
Mistroke
.45343 .40334 L
.41419 .40156 L
.37377 .39552 L
.33577 .38604 L
.30424 .37505 L
.25614 .35196 L
.22172 .32923 L
.19133 .30254 L
.17009 .27748 L
.15642 .2558 L
.14647 .23352 L
.14087 .21338 L
.13861 .19593 L
.13901 .17639 L
.14278 .15656 L
.14919 .13911 L
.1573 .12417 L
.16811 .1094 L
.18195 .09497 L
.21216 .0727 L
.23355 .06154 L
.25566 .05272 L
.27687 .04628 L
.28929 .04329 L
.30128 .04089 L
.32619 .03733 L
.33986 .03613 L
.35491 .03539 L
.37011 .03524 L
.3864 .03571 L
.40052 .03665 L
.41615 .03826 L
.4447 .04274 L
.46084 .04618 L
.47559 .04991 L
.50446 .05894 L
.53135 .0696 L
.58136 .0966 L
.60632 .11483 L
.63102 .13779 L
.64225 .15072 L
.65332 .16594 L
.66948 .19702 L
.67801 .23159 L
.67644 .26758 L
.66053 .3077 L
.62547 .34657 L
.57297 .37809 L
.50977 .39573 L
.43363 .3967 L
Mistroke
.35977 .38098 L
.309 .35947 L
.26653 .33232 L
.24787 .31646 L
.23122 .29916 L
.20909 .2684 L
.19571 .2398 L
.18907 .21482 L
.18694 .18953 L
.18773 .17596 L
.18962 .16375 L
.19271 .15149 L
.19645 .14074 L
.20148 .12949 L
.20773 .11827 L
.21939 .10182 L
.23401 .08596 L
.26512 .06176 L
.28672 .0497 L
.30859 .04022 L
.3293 .03329 L
.35272 .02745 L
.37587 .02353 L
.39759 .02134 L
.4232 .0205 L
.44791 .02139 L
.47091 .02371 L
.49232 .02716 L
.5158 .03244 L
.54062 .03983 L
.56501 .0491 L
.59069 .0613 L
.6344 .08969 L
.6572 .1101 L
.67828 .13507 L
.69301 .15937 L
.69965 .17446 L
.70445 .18937 L
.7091 .22161 L
.70806 .24129 L
.70417 .26042 L
.68744 .29746 L
.67294 .3167 L
.651 .33788 L
.59393 .37159 L
.5124 .3939 L
.43536 .39241 L
.3705 .3752 L
.33798 .3601 L
.30929 .3418 L
Mistroke
.27174 .30681 L
.2562 .28536 L
.24573 .26562 L
.23919 .24851 L
.23474 .23068 L
.23273 .21545 L
.23236 .19949 L
.23376 .1836 L
.23649 .16952 L
.24433 .14604 L
.25623 .1233 L
.26988 .10433 L
.28735 .0857 L
.3078 .06871 L
.32865 .05498 L
.34787 .04473 L
.36898 .03561 L
.39299 .02754 L
.4156 .02188 L
.42875 .01938 L
.44079 .01757 L
.45479 .01602 L
.46808 .01509 L
.49183 .01472 L
.50524 .01522 L
.51758 .01613 L
.53097 .01762 L
.54343 .01949 L
.55814 .0223 L
.57146 .02543 L
.59814 .03352 L
.6258 .04478 L
.64712 .05586 L
.66856 .06966 L
.68584 .08331 L
.70289 .0999 L
.72039 .12203 L
.72726 .13313 L
.73361 .14548 L
.73846 .15726 L
.74268 .17084 L
.74686 .19638 L
.74584 .22544 L
.73877 .25387 L
.73174 .27031 L
.72106 .28864 L
.6917 .32264 L
.64906 .35349 L
.58226 .38096 L
.50773 .39386 L
Mistroke
.43367 .38889 L
.36331 .36357 L
.31676 .32931 L
.28662 .28879 L
.27742 .26661 L
.2727 .24733 L
.27117 .21425 L
.27725 .18198 L
.28828 .15483 L
.30179 .13248 L
.3172 .11315 L
.33322 .09698 L
.35386 .08001 L
.37387 .06653 L
.41715 .04455 L
.44189 .03544 L
.46568 .02866 L
.48954 .02365 L
.51591 .02007 L
.52911 .01902 L
.54328 .01845 L
.56868 .01886 L
.59218 .02091 L
.61636 .02479 L
.63643 .02947 L
.65768 .03602 L
.68174 .04573 L
.70234 .05637 L
.72432 .0708 L
.74303 .08657 L
.75825 .10302 L
.77023 .11981 L
.78074 .14001 L
.78484 .15092 L
.78833 .16347 L
.7915 .18692 L
.79056 .21024 L
.78433 .23752 L
.77807 .25343 L
.77038 .26827 L
.75046 .29623 L
.73538 .31218 L
.71861 .32683 L
.6792 .35295 L
.62285 .37707 L
.55651 .39167 L
.47194 .39336 L
.40637 .37838 L
.35813 .35201 L
.32089 .31284 L
Mistroke
.30314 .2689 L
.30191 .23051 L
.30965 .19877 L
.32394 .16923 L
.34408 .14157 L
.36613 .11906 L
.38807 .10122 L
.44278 .0688 L
.47127 .05673 L
.50262 .04644 L
.51861 .04227 L
.53362 .039 L
.56142 .03448 L
.57679 .03285 L
.59078 .03189 L
.60593 .03142 L
.6217 .03158 L
.64716 .03329 L
.6701 .03645 L
.6942 .04161 L
.71866 .04904 L
.74049 .05789 L
.75885 .06734 L
.777 .07902 L
.7945 .09333 L
.80862 .1082 L
.81955 .12317 L
.82799 .13862 L
.83454 .15611 L
.8386 .17649 L
.83934 .18851 L
.83896 .19981 L
.83507 .22275 L
.82709 .2455 L
.82047 .25879 L
.81161 .27314 L
.79032 .2994 L
.75828 .32785 L
.73501 .34372 L
.70932 .35803 L
.6583 .37894 L
.62359 .38854 L
.58715 .3952 L
.50958 .39806 L
.42459 .38314 L
.3658 .35114 L
.33334 .31008 L
.32332 .2716 L
.32768 .233 L
.34419 .19602 L
Mistroke
.35706 .1776 L
.37057 .16201 L
.40094 .13473 L
.43614 .111 L
.47002 .09334 L
.50239 .08002 L
.53131 .07058 L
.56233 .06275 L
.59208 .05733 L
.61864 .05418 L
.64687 .05256 L
.67542 .05281 L
.69925 .05456 L
.72045 .05741 L
.74257 .06182 L
.76479 .06793 L
.78729 .0762 L
.8095 .08693 L
.82824 .09867 L
.84348 .11079 L
.85545 .12276 L
.86654 .13701 L
.87564 .15304 L
.88169 .16907 L
.88526 .18703 L
.88592 .19763 L
.88557 .20774 L
.88245 .22688 L
.87918 .23791 L
.87522 .24808 L
.86491 .2678 L
.84923 .28958 L
.82955 .3104 L
.80673 .3295 L
.77365 .35121 L
.73546 .37033 L
.71038 .38024 L
.68407 .38873 L
.65029 .39712 L
.61622 .40284 L
.57915 .40615 L
.53633 .40602 L
.45203 .39202 L
.40888 .37621 L
.37937 .35803 L
.3557 .33333 L
.34159 .30362 L
.34158 .25624 L
.35845 .21813 L
.38907 .18174 L
Mistroke
.42356 .15427 L
.45763 .13386 L
.4896 .11871 L
.52466 .10551 L
.56112 .09493 L
.59683 .0873 L
.61633 .08421 L
.63373 .08208 L
.66639 .07967 L
.6959 .07931 L
.71185 .07987 L
.72827 .08103 L
.75635 .08447 L
.7711 .08708 L
.78442 .08999 L
.81279 .09809 L
.8339 .10617 L
.85472 .11641 L
.87383 .12851 L
.88915 .141 L
.90128 .1537 L
.91037 .16601 L
.91845 .18106 L
.92362 .19605 L
.92531 .20407 L
.92638 .21311 L
.92657 .22275 L
.92586 .23196 L
.92237 .24882 L
.91524 .26742 L
.90964 .27798 L
.90213 .28962 L
.88446 .31096 L
.86186 .33172 L
.83558 .35065 L
.80427 .36852 L
.76454 .38607 L
.72456 .39929 L
.67346 .41089 L
.64114 .41542 L
.60927 .41788 L
.56975 .41808 L
.52974 .4149 L
.45468 .39746 L
.41254 .3787 L
.38179 .3583 L
.35263 .31656 L
.35078 .27326 L
.37183 .22983 L
.40979 .19216 L
Mistroke
.45435 .16392 L
.47757 .15267 L
.50316 .14227 L
.54789 .12806 L
.5882 .11889 L
.62626 .11301 L
.66542 .10963 L
.70024 .10886 L
.73045 .10997 L
.75613 .11229 L
.78263 .11614 L
.80835 .12147 L
.83059 .12753 L
.85432 .13581 L
.87461 .14476 L
.90679 .16403 L
.92138 .17605 L
.93273 .18788 L
.94274 .20157 L
.94721 .2095 L
.95055 .21684 L
.95504 .23118 L
.95698 .24494 L
.95655 .2604 L
.95511 .26921 L
.95302 .27729 L
.94652 .29376 L
.94145 .30311 L
.93584 .31177 L
.92221 .32865 L
.90609 .34432 L
.86927 .37105 L
.84498 .3845 L
.81481 .3981 L
.77855 .41094 L
.73914 .42137 L
.69941 .42867 L
.651 .43363 L
.6209 .43459 L
.58646 .43363 L
.55211 .4304 L
.51933 .42489 L
.45562 .40568 L
.39259 .36817 L
.36918 .34375 L
.35679 .31746 L
.36224 .26775 L
.38034 .2397 L
.40451 .21667 L
.42952 .19919 L
Mistroke
.45888 .18345 L
.50876 .16391 L
.53691 .15581 L
.56289 .14986 L
.613 .14197 L
.63981 .13952 L
.66343 .13835 L
.70109 .13835 L
.73927 .14078 L
.77584 .14555 L
.8069 .15171 L
.83698 .15984 L
.86545 .16992 L
.90798 .19109 L
.927 .20425 L
.94188 .2173 L
.95495 .23229 L
.96078 .24092 L
.96526 .24906 L
.97102 .26385 L
.97293 .27179 L
.97408 .28031 L
.97435 .28851 L
.97385 .29625 L
.97097 .31079 L
.96557 .32517 L
.95835 .33833 L
.94787 .35262 L
.93382 .36743 L
.90155 .39228 L
.87899 .40535 L
.85548 .41653 L
.83095 .42616 L
.80127 .43556 L
.77026 .4432 L
.73886 .44893 L
.69916 .45359 L
.65854 .45553 L
.61028 .45418 L
.55427 .44732 L
.49557 .43291 L
.46583 .42186 L
.43402 .40614 L
.38469 .36636 L
.35917 .31946 L
.36811 .27064 L
.38531 .2476 L
.41144 .22558 L
.4675 .19612 L
.52322 .17874 L
Mistroke
.55637 .17203 L
.58675 .16777 L
.64047 .16422 L
.66852 .16426 L
.69315 .16535 L
.71882 .16753 L
.74448 .17083 L
.78082 .17755 L
.81602 .18661 L
.84562 .19654 L
.86984 .2066 L
.91579 .23257 L
.93376 .24666 L
.9497 .26263 L
.96074 .27726 L
.96844 .29129 L
.97313 .30399 L
.9759 .31781 L
.97619 .33283 L
.97528 .34037 L
.97345 .34863 L
.96815 .36306 L
.96078 .37633 L
.95107 .3893 L
.93968 .40126 L
.91254 .4225 L
.89407 .4335 L
.87475 .44305 L
.85148 .45253 L
.823 .46177 L
.79099 .46965 L
.7721 .47322 L
.75359 .47602 L
.71828 .4796 L
.6773 .48101 L
.65291 .4805 L
.62526 .47871 L
.59818 .47567 L
.57227 .47151 L
.52166 .45944 L
.49563 .45084 L
.46684 .43899 L
.41695 .40966 L
.37921 .37166 L
.35916 .31645 L
.3625 .29104 L
.37727 .26484 L
.42384 .22759 L
.4896 .20153 L
.55373 .18909 L
Mistroke
.60873 .18537 L
.66141 .18686 L
.71132 .19266 L
.74933 .20005 L
.78662 .21006 L
.82182 .22244 L
.85444 .23708 L
.90116 .2658 L
.91854 .28026 L
.93398 .29627 L
.94539 .3115 L
.95333 .32561 L
.9588 .33953 L
.96176 .35201 L
.96288 .36622 L
.96176 .37934 L
.95822 .39321 L
.95184 .40761 L
.94341 .42071 L
.93374 .43217 L
.92002 .44497 L
.90224 .45798 L
.86238 .47881 L
.83892 .4876 L
.8103 .49586 L
.79481 .49939 L
.77732 .50267 L
.76003 .50523 L
.74354 .5071 L
.71216 .50919 L
.67561 .50935 L
.635 .50675 L
.59523 .50137 L
.55602 .49313 L
.51234 .48008 L
.47078 .46296 L
.43351 .44215 L
.40231 .41829 L
.37384 .38545 L
.35704 .34262 L
.36165 .29584 L
.39452 .25263 L
.45056 .22272 L
.5104 .20731 L
.57524 .20145 L
.63937 .20419 L
.69863 .21369 L
.74219 .22515 L
.7835 .24003 L
.81765 .25596 L
Mistroke
.84463 .27158 L
.87129 .2907 L
.89094 .30833 L
.9073 .32688 L
.91902 .34425 L
.92777 .3623 L
.93114 .37231 L
.93331 .38141 L
.93497 .39615 L
.93443 .40955 L
.93163 .42376 L
.92613 .43839 L
.91776 .45293 L
.90741 .46596 L
.89621 .47696 L
.88202 .48815 L
.86247 .50032 L
.84156 .5105 L
.82077 .51851 L
.79623 .52585 L
.767 .53217 L
.75137 .53462 L
.73352 .53671 L
.71771 .53796 L
.70021 .53872 L
.66723 .5385 L
.63248 .53597 L
.61217 .53343 L
.59296 .53028 L
.55688 .52236 L
.51764 .51051 L
.48232 .49646 L
.44953 .47982 L
.415 .45705 L
.38164 .42628 L
.35684 .38921 L
.34646 .34858 L
.36066 .29371 L
.40205 .25017 L
.46188 .22472 L
.52627 .21398 L
.59506 .21446 L
.6591 .22436 L
.7132 .23997 L
.73927 .25014 L
.76069 .26005 L
.79672 .28047 L
.82381 .29997 L
.84878 .32278 L
.86909 .34735 L
Mistroke
.88178 .3685 L
.88698 .38004 L
.89057 .39028 L
.89311 .4 L
.89489 .41044 L
.89566 .42105 L
.89544 .43069 L
.8929 .4473 L
.8873 .46409 L
.88292 .47308 L
.87721 .48244 L
.86442 .49834 L
.84915 .51242 L
.83273 .52413 L
.81654 .53337 L
.79741 .54216 L
.7745 .55035 L
.75131 .55658 L
.73825 .55931 L
.72351 .56179 L
.70912 .56364 L
.69538 .5649 L
.6685 .56607 L
.63857 .56544 L
.60886 .56288 L
.59158 .56053 L
.57519 .55769 L
.54155 .54999 L
.50492 .53851 L
.47076 .52449 L
.43888 .50786 L
.41124 .48977 L
.38314 .46627 L
.3697 .45221 L
.35667 .43559 L
.34451 .41542 L
.33605 .39461 L
.33108 .37034 L
.33217 .3425 L
.34021 .31713 L
.35877 .28825 L
.38692 .2618 L
.41593 .2442 L
.4561 .22996 L
.49862 .22255 L
.57587 .2228 L
.61593 .2291 L
.64938 .2375 L
.70093 .25669 L
.74476 .28038 L
Mistroke
.77693 .30387 L
.79982 .32546 L
.82004 .35034 L
.82823 .36318 L
.83528 .37657 L
.84418 .40027 L
.84834 .42118 L
.84915 .4329 L
.84892 .44333 L
.84766 .4544 L
.84527 .46565 L
.83895 .48355 L
.83419 .49312 L
.82901 .50166 L
.81759 .51663 L
.80534 .52909 L
.78912 .54213 L
.77209 .55295 L
.75405 .56213 L
.7363 .56938 L
.71533 .5761 L
.6914 .58176 L
.66855 .58543 L
.64253 .58778 L
.62901 .58829 L
.61433 .58831 L
.58731 .58696 L
.5613 .58398 L
.53266 .57877 L
.50533 .57185 L
.48011 .56365 L
.43283 .54286 L
.40973 .52951 L
.38536 .51243 L
.35867 .48863 L
.33662 .4621 L
.3208 .43463 L
.31002 .40051 L
.30813 .38113 L
.30991 .3583 L
.31741 .33306 L
.33137 .30845 L
.37888 .26462 L
.41837 .2438 L
.45568 .23213 L
.53128 .22581 L
.59999 .23544 L
.66292 .25726 L
.71347 .28657 L
.73316 .30219 L
Mistroke
.75082 .31927 L
.77459 .34979 L
.78939 .37831 L
.79721 .40325 L
.79993 .4201 L
.80063 .43542 L
.79984 .44858 L
.79761 .46232 L
.79375 .47646 L
.78811 .49068 L
.78151 .50332 L
.77454 .51411 L
.7585 .53339 L
.73802 .55158 L
.71611 .56625 L
.69407 .57759 L
.68087 .58311 L
.6662 .58829 L
.65314 .59216 L
.63856 .59572 L
.62103 .59904 L
.60403 .60132 L
.58717 .60273 L
.57134 .60332 L
.55455 .60319 L
.53864 .60236 L
.52106 .60066 L
.50203 .59787 L
.48313 .5941 L
.46327 .58902 L
.42819 .577 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[30]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool007Eoo`@000=oo`03001oogoo009oo`<009aoo`00Mgoo00<007ooOol02Woo00<007ooOol00Woo
00<007ooOol0U7oo001gOol00`00Oomoo`0:Ool00`00Oomoo`02Ool3002DOol006moo`@000Aoo`03
001oogoo00Moo`<000Eoo`03001oogoo09Aoo`00Mgoo00<007ooOol01goo00<007ooOol01Goo00<0
07ooOol0U7oo001eOol30009Ool00`00Oomoo`05Ool00`00Oomoo`2DOol007Moo`03001oo`0001`0
08Yoo`00K7oo50002Goo00<007ooOol07@00Mgoo001UOol70005Ool5000:Ool<000=Ool4000<Ool5
001bOol0065oo`@000Moo`D0011oo`@00003Ool0000000<0019oo`@000eoo`80071oo`00GGoo1000
27oo0`004Goo100027oo00<007oo00000`004Woo4P00KGoo001JOol30004Ool<000=Ool3000<Ool0
0`00Oomoo`03Ool30007Ool:0002Ool40008Ool7001XOol005Qoo`T000=oo`8000Moo`d000moo`03
001oogoo00Ioo`L0011oo`8000]oo`P0069oo`00DWoo1P002Woo0P004Woo20002goo00<007ooOol0
0Woo1@000goo0`004Woo0P0037oo100000=oo`0000000`00GGoo001<Ool9000;Ool2000AOol30008
Ool40007Ool5000;Ool3000AOol2000>Ool20004Ool4001IOol004Uoo`<000Aoo`8000aoo`80015o
o`8000moo`@0009oo`<0015oo`80015oo`8000ioo`8000Ioo`8005Moo`00AWoo0`001Goo0P0037oo
0P004Goo0P0057oo0`0000=oo`00Ool04goo0P0047oo400000=oo`0000001Woo0P00EGoo0014Ool2
0007Ool00`00Oomoo`06Ool;000<Ool2000COol30003Ool3000EOol200000goo0000000;0003Ool2
000;Ool=001COol0049oo`8000Moo`/000=oo`8000Ioo`P0009oo`8001=oo`8000Moo`03001oo`00
0080015oo`D0015oo`8000ioo`8000Aoo`D0051oo`00@7oo0P0000=oo`0000001P003Goo00<007oo
Ool03Woo1P003goo0P002Goo00<007ooOol00Woo0P002goo10001Goo0P004Goo00<007ooOol03Goo
00<007ooOol017oo1000CWoo000nOol50005Ool2000<Ool2000@Ool00`00Oomoo`04Ool90004Ool2
000;Ool20005Ool30004Ool4000;Ool2000@Ool2000>Ool20008Ool4001:Ool003aoo`<000Qoo`03
001oogoo00]oo`03001oogoo00ioo`80011oo`@000eoo`03001oogoo00Moo`@0015oo`80011oo`03
001oogoo00eoo`03001oogoo00Moo`@004Qoo`00>Goo0`002Goo0P003Goo00<007ooOol03Woo00<0
07ooOol04Goo1@002goo00<007ooOol017oo0`000Woo0P004goo00<007ooOol03Woo00<007ooOol0
3Goo00<007ooOol027oo00@007oo000004Ioo`00=Woo1@002Goo00<007ooOol02goo0P003goo0P00
4Woo0P001Goo0`0027oo00<007ooOol00Woo0P001goo0P004Woo0P003goo0P003Woo00<007ooOol0
27oo0P0000Aoo`00000004=oo`00=7oo0P000Woo00<007ooOol01goo0P003Goo00<007ooOol03Woo
00<007ooOol04Goo00<007ooOol027oo0`001Goo00<007oo00000P002goo0P004Woo8P002Woo00@0
07ooOomoo`80045oo`00<Woo0P000Woo0P002Goo00<007ooOol017oo5`000Woo00<007ooOol047oo
0P003Woo0`000Woo0P0047oo0P0037oo20003Woo00<007ooOol037oo1`001Goo00<007ooOol00Woo
0P00?goo000`Ool20003Ool00`00Oomoo`08Ool80007Ool00`00Oomoo`0=Ool;0008Ool2000COol3
000COol20005Ool50008Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool40002Ool0
0`00Oomoo`03Ool2000mOol002ioo`8000=oo`8000Ioo`D000ioo`03001oogoo00ioo`03001oogoo
00Qoo`D0009oo`03001oogoo015oo`80009oo`<001=oo`D000ioo`03001oogoo00aoo`8000eoo`03
001oogoo00Ioo`@000Ioo`8003]oo`00;7oo0P0017oo00<007ooOol00goo0`0017oo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol03Woo10003goo0`0017oo00<007ooOol00P003Goo10000Woo
0P0047oo00<007ooOol03Goo00<007ooOol02goo00<007ooOol02Goo100017oo0P00>Goo000[Ool0
0`00Oomoo`03Ool00`00Oomoo`040006Ool00`00Oomoo`0<Ool00`00Oomoo`0=Ool00`00Oomoo`0=
Ool20004Ool3000:Ool50004Ool00`00Oomoo`02Ool20007Ool40008Ool00`00Oomoo`0>Ool00`00
Oomoo`0=Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`040002Ool00`00Oomoo`0fOol0
02Yoo`03001oogoo00=oo`@000Uoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00eoo`03
001oogoo00Moo`@000=oo`<000=oo`03001oogoo00=oo`03001oogoo00Aoo`80009oo`<000eoo`03
001oogoo00ioo`03001oogoo00eoo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00=oo`80
0003Ool007oo03Ioo`00:7oo0P000goo10002goo00<007ooOol037oo00<007ooOol037oo0P003goo
00<007ooOol037oo0`001Woo00<007ooOol00goo0`001Goo0`004Goo0P003goo00<007ooOol037oo
00<007ooOol037oo00<007ooOol02Goo00<007ooOol017oo1000=Goo000WOol00`00Oomoo`030000
0goo001oo`0<Ool00`00Oomoo`0;Ool00`00Oomoo`0<Ool00`00Oomoo`0=Ool2000>Ool70003Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool20003Ool2000AOol00`00Oomoo`0:OolL0005Ool00`00Oomo
o`09Ool00`00Oomoo`05Ool3000dOol002Ioo`@000=oo`03001oogoo00]oo`03001oogoo00UooaH0
00]oo`03001oogoo00eoo`03001oogoo00Eoo`@000Eoo`03001oogoo00<000Moo`80011oo`04001o
ogooOol80004Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool7000;Ool00`00Oomoo`06Ool2000cOol0
02Aoo`<000Ioo`03001oogoo00Yoo`03001oogoo00=oo`L0009oo`03001oogoo00]oo`03001oogoo
00=oo`T00003Ool007oo00eoo`8000Uoo`H0009oo`<000aoo`8000eoo`D000eoo`03001oogoo00ao
o`03001oogoo00]oo`P000Aoo`03001oogoo00Moo`<0035oo`008goo0P001goo00<007ooOol027oo
2@0027oo00<007ooOol02goo00<007ooOol03Goo1P002Goo00<007ooOol02goo00@007ooOomoo`<0
011oo`8000Ioo`D000=oo`03001oogoo00eoo`03001oogoo00]oo`03001oogoo00aoo`03001oogoo
00Aoo`H000Uoo`04001oo`00000_Ool0025oo`8000Qoo`03001oogoo00Aoo`D0009oo`03001oogoo
00]oo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00Aoo`D000=oo`03001oogoo00ioo`80
009oo`80015oo`H000Uoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00]oo`03001oogoo
00Uoo`@000Moo`03001oogoo008002eoo`0087oo0P002Goo00@007ooOomoo`<000Moo`03001oogoo
00]oo`03001oogoo00]oo`03001oogoo00aoo`03001oogoo00Yoo`@000ioo`8000Aoo`@000]oo`@0
0003Ool0000000eoo`8000eoo`03001oogoo00aoo`03001oogoo00]oo`03001oogoo00Yoo`03001o
o`00008000Eoo`04001oogooOol2000[Ool001ioo`<000Uoo`03001oogoo008000Uoo`03001oogoo
00]oo`03001oogoo00]oo`03001oogoo00aoo`03001oogoo00]oo`04001oogooOol40008Ool20006
Ool01000Oomoogoo0P001Woo0`001goo00<007ooOol037oo00<007ooOol02goo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02Woo00<007ooOol00Woo0`000goo00<007ooOol00Woo00<007oo
Ool0:7oo000LOol20002Ool00`00Oomoo`07Ool3000:Ool00`00Oomoo`0<Ool00`00Oomoo`0:Ool0
0`00Oomoo`0<Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool500000goo00000008Ool00`00Oomoo`03
Ool6000;Ool2000=Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0:
Ool00`00Oomoo`04Ool20002Ool00`00Oomoo`02Ool00`00Oomoo`0WOol001]oo`05001oogooOol0
0006Ool4000=Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool0
0`00Oomoo`0;Ool50007Ool00`00Oomoo`02Ool5000?Ool2000;OolJ0002Ool00`00Oomoo`0;Ool0
0`00Oomoo`0;Ool00`00Oomoo`05Ool200000goo001oo`03Ool00`00Oomoo`0VOol001Yoo`05001o
ogooOol00004Ool30003Ool00`00Oomoo`0:Ool00`00Oomoo`0<Ool00`00Oomoo`0:Ool00`00Oomo
o`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`03Ool20005Ool00`00Ool000020005
Ool2000?Ool01000Oomoogoo1`000Woo00<007ooOol02Woo00<007ooOol027oo2P001goo00<007oo
Ool02Woo00<007ooOol01goo0P001Goo00<007ooOol09Goo000IOol00`00Oomoo`02Ool00`00Ool0
00020005Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00
Oomoo`0;Ool00`00Oomoo`0:Ool20008Ool20003Ool2000:Ool2000:Ool70009Ool00`00Oomoo`0;
Ool00`00Oomoo`0:Ool00`00Oomoo`04Ool8000=Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`0T
Ool001Qoo`03001oogoo009oo`<000Qoo`03001oogoo00Yoo`03001oogoo00aoo`03001oogoo00Yo
o`03001oogoo00]oo`03001oogoo00Uoo`8000aoo`03001oogoo00Yoo`D000aoo`80009oo`H000Eo
o`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`@000Uoo`03001o
ogoo00Qoo`04001oo`000003Ool00`00Oomoo`0SOol001Moo`03001oogoo00=oo`03001oogoo00Mo
o`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00Uo
o`03001oogoo00Yoo`8000]oo`<0009oo`8000aoo`@000aoo`03001oogoo00Uoo`03001oogoo00Yo
o`03001oogoo00Yoo`03001oogoo00]oo`04001oogooOol40006Ool00`00Oomoo`08Ool00`00Oomo
o`020002Ool00`00Oomoo`0ROol001Ioo`03001oogoo009oo`8000Yoo`03001oogoo00]oo`03001o
ogoo00]oo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001o
ogoo00Uoo`8000Eoo`04001oo`000007Ool30004Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00
Oomoo`09Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool40002Ool00`00Oomoo`08
Ool00`00Oomoo`02Ool200000goo001oo`0ROol001Eoo`03001oogoo009oo`03001oo`0000Yoo`03
001oogoo00Yoo`03001oogoo00aoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03
001oogoo00Uoo`8000Yoo`8000Moo`04001oogooOol70008Ool00`00Oomoo`0:Ool00`00Oomoo`08
Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`08Ool4000:Ool00`00
Oomoo`03Ool2000SOol001Aoo`04001oogooOol200000goo001oo`0:Ool00`00Oomoo`0:Ool00`00
Oomoo`0<Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00
Oomoo`08Ool20009Ool01000Oomoogoo1@002goo0P002goo50000goo00<007ooOol02Woo00<007oo
Ool02goo00<007ooOol02Woo00@007oo000000Qoo`03001oogoo00Eoo`03001oogoo021oo`004goo
00<007ooOol00P000goo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol0
2Woo00<007ooOol02Goo00<007ooOol027oo00<007ooOol027oo0P002Goo0P002goo10001Goo0P00
2goo3@002Woo00<007ooOol01Goo3P000goo00<007ooOol02Woo00<007ooOol02Woo00@007ooOomo
o`<000Ioo`03001oogoo00Eoo`03001oogoo01moo`004goo0`0017oo00<007ooOol02Goo00<007oo
Ool02goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol027oo00<007oo
Ool027oo00<007ooOol027oo00<007ooOol02goo0P002Goo0P000goo1P0000=oo`0000002Woo00<0
07ooOol027oo00<007ooOol027oo00<007ooOol01goo1P002Woo00<007ooOol02goo00<007ooOol0
0goo0P0017oo00<007ooOol01Goo0P0087oo000BOol20006Ool00`00Oomoo`09Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`08
Ool00`00Oomoo`07Ool2000;Ool4000;Ool40009Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00
Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`060004Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool2
0002Ool00`00Oomoo`06Ool2000OOol0019oo`03001oogoo00Eoo`03001oogoo00Uoo`03001oogoo
00]oo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo
00Moo`8000Uoo`03001oogoo00Uoo`8000=oo`03001oogoo00Eoo`@000=oo`03001oogoo00Qoo`03
001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Ioo`@0
0003Ool007oo00]oo`03001oogoo00Moo`<000Qoo`03001oo`0001ioo`004Goo00<007ooOol01Goo
00<007ooOol02Woo00<007ooOol02goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo0P002Woo0P001Goo00<007ooOol00Woo
0`0027oo0P002Goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol02Goo
00<007ooOol02Woo0`002goo00<007ooOol02Goo0P0027oo00<007oo00007Goo000@Ool20007Ool0
0`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`08Ool0
0`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool30007Ool5000=Ool2
0005Ool?0008Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Ool000020008
Ool00`00Oomoo`0:Ool30006Ool01000Oomoo`0077oo000?Ool00`00Ool00007Ool00`00Oomoo`0:
Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool00`00Oomoo`06Ool20008Ool20008Ool4000=Ool:0004Ool00`00Oomoo`06
Ool00`00Ool0000=0005Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool40004Ool0
0`00Oomoo`0:Ool00`00Oomoo`020005Ool01000Oomoo`006goo000>Ool00`00Ool00008Ool00`00
Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool20007Ool30002Ool00`00
Oomoo`08Ool40006Ool20006Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`02Ool:0007
Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool5000<Ool00`00Oomoo`02Ool20003Ool01@00Oomoogoo
00006Woo000>Ool00`00Ool00008Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool20006Ool30005Ool00`00Oomoo`03Ool5000<Ool00`00Oomoo`04Ool00`00Oomo
o`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`02Ool600000goo001oo`0;Ool00`00
Oomoo`0:Ool3000:Ool00`00Oomoo`04Ool20002Ool01000Oomoo`006Woo000=Ool00`00Ool00009
Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool20006Ool20008
Ool00`00Ool00003000BOol00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomo
o`07Ool00`00Oomoo`07Ool4000:Ool00`00Oomoo`0:Ool00`00Oomoo`020008Ool00`00Oomoo`06
Ool30003Ool00`00Oomoo`0GOol000aoo`04001oogoo0009Ool00`00Oomoo`0:Ool00`00Oomoo`0;
Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`05
Ool00`00Oomoo`05Ool00`00Oomoo`03Ool30004Ool30002Ool30003Ool4000<OolN0006Ool00`00
Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`030006Ool00`00Oomoo`0;Ool00`00Oomoo`02Ool2
0006Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`0FOol000]oo`05001oogooOol00009
Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`08
Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`03Ool20002Ool00`00
Oomoo`020007Ool30002Ool01000Oomoogoo2P0037oo00<007ooOol017oo00<007ooOol01Goo00<0
07ooOol01P0000=oo`00Ool01goo00<007ooOol027oo00<007ooOol00goo10000Woo00<007ooOol0
2goo00<007ooOol017oo0P0017oo00<007ooOol027oo0P000goo00<007ooOol05Woo000:Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`03Ool00`00Ool00002Ool30007Ool30004Ool4000GOol00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`05Ool60004Ool00`00Oomoo`08Ool00`00Oomoo`07Ool3000=Ool00`00Oomoo`06
Ool20002Ool00`00Oomoo`08Ool01000Ool000000Woo00<007ooOol05Goo0009Ool00`00Oomoo`02
Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04
0002Ool01000Ool000001Woo1@000Woo10001Woo6@000Woo00<007ooOol01Goo00<007ooOol01Woo
00<007ooOol00Woo100000=oo`00Ool027oo00<007ooOol02Goo0`002Woo00<007ooOol02Goo0`00
2Woo00L007ooOomoo`00Ool0000GOol000Uoo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo
00]oo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`800003Ool0
07oo00=oo`80009oo`03001oo`00008000=oo`L001Eoo`04001oogooOol60005Ool00`00Oomoo`05
Ool00`00Oomoo`06Ool40007Ool00`00Oomoo`09Ool00`00Oomoo`030007Ool00`00Oomoo`0;Ool2
0009Ool00`00Oomoo`02Ool00`00Ool0000FOol000Uoo`03001oogoo009oo`03001oogoo00Qoo`03
001oogoo00]oo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo009oo`04001oogooOol30002
Ool00`00Ool000020002Ool400000goo00000004000LOol00`00Oomoo`04Ool00`00Ool000050007
Ool00`00Oomoo`07Ool00`00Oomoo`040003Ool00`00Oomoo`09Ool00`00Oomoo`03Ool20005Ool0
0`00Oomoo`0:Ool00`00Oomoo`020007Ool00`00Oomoo`03Ool2000FOol000Qoo`03001oogoo00=o
o`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00Mo
o`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo009o
o`05001oogooOol00003Ool40003Ool200000goo000000030003OolN00000goo001oo`05Ool00`00
Oomoo`03Ool60003Ool00`00Oomoo`06Ool00`00Oomoo`04Ool4000;Ool00`00Oomoo`05Ool30002
Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`03Ool2000FOol000Qoo`03001o
ogoo00=oo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00Uoo`03001o
ogoo00Moo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo009oo`03001o
ogoo009oo`05001oogooOol00004Ool20003Ool200000goo00000002Ool600000goo0000000>000=
Ool90006Ool00`00Oomoo`02Ool40008Ool00`00Oomoo`07Ool40007Ool00`00Oomoo`09Ool3000<
Ool00`00Oomoo`04Ool20003Ool00`00Oomoo`04Ool2000EOol000Qoo`03001oogoo00=oo`03001o
ogoo00Uoo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Moo`03001o
ogoo00Ioo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`05001o
ogooOol00004Ool01000Oomoogoo4P003Woo2P001Woo00<007ooOol00Woo0`0017oo00<007ooOol0
1Goo1@0017oo00<007ooOol01goo00@007ooOomoo`8000Eoo`03001oogoo00Yoo`<000]oo`03001o
ogoo00Ioo`04001oogoo0007Ool00`00Oomoo`0COol000Qoo`03001oogoo00=oo`03001oogoo00Yo
o`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`05001oogooOol00003Ool01000Oomo
ogoo0P000Woo1`002goo00<007ooOol05goo1`001Woo10000Woo00<007ooOol017oo00<007ooOol0
0Woo10002Goo00<007ooOol017oo0`000Woo00<007ooOol02Woo00<007ooOol00P0027oo00<007oo
Ool027oo00<007oo00001goo0P0057oo0007Ool00`00Oomoo`04Ool00`00Oomoo`0:Ool00`00Oomo
o`0:Ool00`00Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`05Ool00`00Oomo
o`04Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOomoo`00009o
o`H000ioo`03001oogoo01eoo`<000Aoo`04001oogooOol30006Ool00`00Oomoo`05Ool40006Ool0
0`00Oomoo`07Ool3000<Ool00`00Oomoo`02Ool20006Ool00`00Oomoo`09Ool20007Ool2000DOol0
00Moo`03001oogoo00Eoo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo
00Uoo`03001oogoo00Moo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo
009oo`04001oogoo0003Ool01P00Oomoogoo001oo`H0011oo`03001oogoo01ioo`03001oo`000080
0003Ool007oo00Aoo`@000=oo`03001oogoo00Eoo`04001oogooOol20004Ool00`00Oomoo`09Ool2
000:Ool00`00Oomoo`05Ool20004Ool00`00Oomoo`09Ool00`00Ool00007Ool2000COol000Moo`03
001oogoo00Eoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00Qoo`03
001oogoo00Moo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`05
001oogooOol00002Ool00`00Oomoo`07000COol00`00Oomoo`0OOol01000Oomoogoo0`0017oo00@0
07ooOomoo`800003Ool007oo00Ioo`03001oogoo00=oo`80009oo`03001oogoo00Qoo`03001oogoo
008000Qoo`03001oogoo00Moo`800003Ool007oo00]oo`04001oogoo0006Ool2000COol000Moo`03
001oogoo00Eoo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00Qoo`03
001oogoo00Moo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`04
001oogoo0002Ool00`00Oomoo`06000EOol2000POol00`00Oomoo`03Ool400000goo001oo`04Ool3
0006Ool00`00Oomoo`05Ool2000;Ool00`00Oomoo`02Ool20006Ool00`00Oomoo`09Ool2000<Ool0
1@00Oomoogoo00001Goo00<007oo00004Woo0006Ool00`00Oomoo`06Ool00`00Oomoo`0;Ool00`00
Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool01@00Oomoogoo000017oo00L007ooOomoo`00Ool00002Ool5000GOol00`00Oomoo`0P
Ool00`00Oomoo`02Ool01000Oomoogoo0`0017oo00<007ooOol00`000Woo00<007ooOol01goo0`00
27oo00<007ooOol01Goo0P000goo00<007ooOol02Woo0`002goo00<007ooOol00Woo00<007ooOol0
0Woo00<007oo00004Woo0006Ool00`00Oomoo`07Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00
Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool01`00Oomoo`00Ool007oo00D001Uoo`03001oogoo021oo`03001o
ogoo009oo`03001oogoo009oo`04001oo`000002Ool00`00Oomoo`03Ool30009Ool00`00Oomoo`02
0006Ool00`00Oomoo`07Ool200000goo001oo`0;Ool01000Oomoo`002Goo00<007ooOol017oo00D0
07ooOomoo`00009oo`03001oogoo00moo`001Woo00<007ooOol01goo00<007ooOol02goo00<007oo
Ool02goo00<007ooOol02Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol00Woo00D007ooOomoo`00009oo`03001oogoo00H001Yoo`03001oogoo025o
o`05001oogooOol00004Ool01000Oomoogoo0`001goo0P001goo00<007ooOol00goo0P000goo00<0
07ooOol02Woo0P002goo00<007ooOol00Woo0P001goo00<007ooOol01Goo00@007ooOol0009oo`03
001oogoo00moo`001Woo00<007ooOol027oo00<007ooOol02goo00<007ooOol02Woo00<007ooOol0
2Woo00<007ooOol027oo00<007ooOol01Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol0
0Woo00D007ooOomoo`00009oo`03001oo`0000800003Ool007oo01]oo`03001oogoo025oo`05001o
ogooOol00004Ool00`00Oomoo`03Ool20006Ool01000Ool000001Goo00<007ooOol01Goo0P0000=o
o`00Ool02Woo00<007ooOol00P002Goo00<007ooOol017oo0P0017oo00<007ooOol01goo00<007oo
00000goo00<007ooOol03Woo0006Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool0
0`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`02Ool01000Oomoo`000Woo00<007oo00000P0000=oo`00Ool077oo00<007ooOol08Woo
00@007ooOol000Aoo`03001oogoo00=oo`04001oo`000003Ool00`00Oomoo`02Ool20002Ool00`00
Oomoo`08Ool2000;Ool00`00Oomoo`02Ool20006Ool00`00Oomoo`07Ool01@00Oomoogoo00002Woo
00<007ooOol00Woo00<007ooOol03Woo0006Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool00`00Oomo
o`0;Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool01000Oomoo`000Woo100000=oo`00Ool07Goo0P008goo00D007ooOomo
o`0000=oo`03001oogoo00=oo`05001oogooOol00002Ool00`00Oomoo`04Ool30009Ool01000Oomo
o`002Goo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Yoo`03001o
ogoo009oo`03001oogoo00ioo`001Woo00<007ooOol02Goo00<007ooOol037oo00<007ooOol02Goo
10002Woo00<007ooOol01goo00<007ooOol01Woo00<007ooOol00goo00@007oo0000009oo`03001o
o`00009oo`03001oo`0000800004Ool00000Ool3000NOol00`00Oomoo`0SOol01000Ool000000goo
0P000goo10000Woo0`001goo0`0027oo00@007ooOomoo`8000Ioo`03001oogoo00@000=oo`05001o
ogooOol0000<Ool2000;Ool20002Ool40003Ool00`00Oomoo`02Ool30003Ool000Moo`03001oogoo
00Qoo`03001oogoo00aoo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00Moo`03001oogoo
00Eoo`03001oogoo00Aoo`04001oogoo0002Ool01`00Oomoogoo001oo`00009oo`H001moo`03001o
ogoo02=oo`800003Ool00000009oo`03001oogoo009oo`05001oogooOol00002Ool30006Ool00`00
Oomoo`020005Ool00`00Oomoo`04Ool20003Ool00`00Oomoo`03Ool00`00Oomoo`03Ool3000>Ool2
000:Ool00`00Ool00003Ool00`00Oomoo`0:Ool10001Ool1Ool000Moo`03001oogoo00Uoo`03001o
ogoo00aoo`03001oogoo00Yoo`8000aoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00=o
o`04001oogoo0002Ool01`00Oomoogoo001oo`00009oo`03001oo`000080021oo`03001oogoo02=o
o`800003Ool00000009oo`03001oogoo009oo`05001oogooOol00002Ool00`00Oomoo`020003Ool0
0`00Oomoo`03Ool01@00Oomoogoo00002Goo00<007oo00001Woo00<007ooOol017oo0P003Goo00@0
07ooOol000Uoo`03001oo`0000=oo`03001oogoo00Yoo`40005oo`5oo`0027oo00<007ooOol027oo
00<007ooOol03Goo00@007ooOomoo`@000Aoo`03001oo`0000]oo`03001oogoo00Moo`03001oogoo
00Eoo`@0009oo`800005Ool007ooOol00003Ool00`00Ool00006000QOol00`00Oomoo`0SOol30000
1Goo001oogoo00000goo00<007oo00000P000Woo00<007ooOol00goo00@007ooOol000Ioo`<000]o
o`8000Ioo`03001oogoo00Aoo`03001oo`0000aoo`05001oogooOol00007Ool01@00Oomoogoo0000
0Woo00<007ooOol01goo0`000goo0008Ool00`00Oomoo`09Ool00`00Oomoo`0<Ool00`00Oomoo`09
Ool01000Oomoo`002goo00<007ooOol01goo00<007ooOol01Goo00<007ooOol00Woo0P0000Eoo`00
Oomoo`0000=oo`05001oo`00001oo`04000QOol00`00Oomoo`0SOol3000017oo001oo`0017oo00<0
07oo000017oo00<007ooOol017oo0P002Goo00<007ooOol02Goo00<007oo00001Goo00<007ooOol0
0goo00@007ooOomoo`8000Uoo`03001oogoo00=oo`03001oogoo00Aoo`05001oogooOol00002Ool0
0`00Oomoo`07Ool00`00Oomoo`03Ool000Qoo`03001oogoo00Yoo`03001oogoo00aoo`03001oogoo
00Ioo`<0009oo`03001oogoo00Yoo`03001oogoo00Ioo`03001oogoo00Ioo`04001oogooOol20000
0goo001oo`02Ool01`00Oomoo`00Ool007oo00@0029oo`8002Aoo`<00004Ool007oo0003Ool01000
Oomoo`0017oo00<007ooOol017oo0P0027oo00@007oo000000Qoo`04001oogooOol2000017oo0000
000017oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol00Woo00<007oo
Ool00goo0`002Goo00<007ooOol00goo0009Ool00`00Oomoo`09Ool00`00Oomoo`0=Ool00`00Oomo
o`07Ool01@00Oomoogoo00002goo00<007ooOol01goo00<007ooOol01Goo00<007ooOol00Woo0P00
17oo00<007ooOol01`008goo00<007ooOol08goo00@007oo0000009oo`05001oogooOol00002Ool5
0006Ool01000Oomoo`001Woo00<007ooOol00Woo00<007ooOol017oo00<007ooOol017oo0P0000=o
o`00Ool00Woo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00@007ooOol000Ioo`03
001oo`0000Uoo`@0009oo`002Goo00<007ooOol02Woo00<007ooOol03Goo00<007ooOol02goo00<0
07ooOol02Goo00<007ooOol01goo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol00Woo00@0
07ooOol0009oo`04001oo`00000SOol00`00Oomoo`0SOol20003Ool00`00Oomoo`02Ool00`00Oomo
o`04Ool00`00Oomoo`04Ool01@00Oomoogoo000017oo00<007ooOol017oo0P000goo00<007ooOol0
1goo00D007ooOomoo`0000Yoo`03001oogoo009oo`03001oogoo00Qoo`03001oo`0000Moo`8000mo
o`002Woo00<007ooOol02Woo00<007ooOol03Goo00<007ooOol02goo00<007ooOol02Goo00<007oo
Ool01Woo00<007ooOol01Woo00<007ooOol00Woo00H007ooOomoo`00Ool20002Ool4000SOol00`00
Oomoo`0ROol00`00Ool00003Ool01@00Oomoogoo00001Woo00<007ooOol017oo00<007ooOol00goo
00@007ooOol000Uoo`03001oo`0000]oo`03001oo`0000aoo`04001oogoo000<Ool00`00Oomoo`06
Ool2000?Ool000Yoo`03001oogoo00]oo`03001oogoo00eoo`03001oogoo00]oo`03001oogoo00Uo
o`03001oogoo00Ioo`03001oogoo00Ioo`05001oogooOol00004Ool01000Ool007oo1@008goo00<0
07ooOol08Woo00<007oo00000Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol017oo00<0
07ooOol01Goo00<007oo00002Woo00<007ooOol02goo00<007ooOol037oo0P003Goo0P001goo00<0
07ooOol03Woo000;Ool00`00Oomoo`0;Ool00`00Oomoo`0=Ool00`00Oomoo`0;Ool00`00Oomoo`09
Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`020002Ool00`00Ool0
0002000TOol00`00Oomoo`0ROol00`00Ool00002Ool01@00Oomoogoo00001Goo00<007ooOol017oo
00<007ooOol01goo00<007ooOol027oo00<007oo00002goo00<007oo00003Goo0P0037oo00@007oo
Ool000Ioo`03001oogoo00ioo`00o`006@0027oo0006Ool00`00Oomoo`03Ool01@00Oomoogoo0000
27oo00<007oo00001Woo00<007ooOol01Woo0P0027oo00@007ooOomoo`8000=oo`03001oogoo00Ao
o`04001oogoo0005Ool01000Oomoo`0017oo00@007ooOomoo`80009oo`800003Ool00000008000Qo
o`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`80009oo`04001oogoo0002Ool01000Oomoo`001Goo00<0
07oo00001goo0P000goo00L007ooOomoo`00Ool00006Ool00`00Oomoo`04Ool200000goo001oo`02
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoogoo0P0027oo0P0017oo00P007ooOol007oo
001oo`001Goo00<007ooOol01goo000=Ool00`00Oomoo`0<Ool00`00Oomoo`0=Ool00`00Oomoo`0<
Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`020003Ool00`00Ool0
0003000TOol00`00Oomoo`0ROol20002Ool00`00Ool00005Ool00`00Oomoo`05Ool00`00Oomoo`05
Ool20005Ool01@00Oomoogoo000027oo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol017oo
0P001Woo00<007ooOol01Goo00<007ooOol00goo00<007ooOol00Woo00<007oo00003goo000=Ool0
0`00Oomoo`0=Ool00`00Oomoo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool20007Ool20005Ool0
0`00Ool00002Ool01P00Ool007oo001oo`@002=oo`03001oogoo029oo`800004Ool007oo0005Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Ool0000:Ool01000Oomoo`002Woo
00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol01Goo00@007ooOol0009o
o`03001oogoo00eoo`003Woo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol037oo00<007oo
Ool02Goo00<007ooOol01Woo00<007ooOol00goo0P000goo0P000Woo0P0000=oo`0000008goo00<0
07ooOol08Goo0P0000Eoo`00Oomoo`0000Aoo`03001oogoo00Aoo`8000Moo`03001oogoo00Qoo`03
001oogoo00Yoo`8000aoo`04001oogoo000;Ool01@00Oomoogoo000027oo00@007ooOol0009oo`03
001oogoo00eoo`003goo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol037oo0P002Woo00<0
07ooOol01Woo00<007ooOol00Woo0P000goo0P000Woo00@007oo001oo`80029oo`80029oo`<0009o
o`03001oogoo009oo`03001oogoo00Aoo`03001oogoo00Eoo`8000Uoo`800003Ool007oo00Yoo`80
00eoo`8000eoo`03001oo`0000Uoo`03001oo`0000=oo`03001oogoo00eoo`0047oo00<007ooOol0
3Goo00<007ooOol03Goo0P003Woo00<007ooOol027oo0P001goo00H007ooOomoo`00Ool200001Goo
001oo`00Ool00`0000=oo`0000008Woo00<007ooOol087oo0`000Woo00<007ooOol00Woo00<007oo
Ool00goo0P001goo00<007ooOol027oo00D007ooOomoo`0000Uoo`80009oo`03001oogoo00Uoo`80
00ioo`8000]oo`8000=oo`03001oogoo00eoo`004Goo00<007ooOol03Goo0P003goo0P003Goo00<0
07ooOol02Goo00<007ooOol01Goo00@007ooOol000=oo`04001oogooOol2000017oo000007oo0P00
8Goo00<007ooOol07goo0`000Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol01Goo0P00
2Goo0P001Goo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol027oo00@007ooOol000ioo`03
001oogoo00Uoo`03001oogoo009oo`03001oogoo00eoo`004Woo00<007ooOol03Woo00<007ooOol0
3Woo0P0037oo0P002Woo0P001Woo0P0017oo0P000goo00<007oo000010008Goo00<007ooOol07goo
0P000Woo00@007ooOomoo`8000Aoo`8000Ioo`8000Yoo`03001oogoo00Ioo`03001oogoo00=oo`03
001oogoo00Aoo`03001oogoo00Ioo`03001oogoo009oo`03001oogoo00Yoo`8000Yoo`8000Aoo`03
001oogoo00eoo`004goo00<007ooOol03Woo00<007ooOol03goo0P0037oo00<007ooOol02Goo00<0
07ooOol017oo0P000goo00<007oo00000P0000Eoo`00000007oo00<0021oo`03001oogoo01ioo`80
009oo`03001oogoo008000Eoo`03001oogoo00Eoo`03001oogoo00Qoo`8000Yoo`03001oogoo0080
00Qoo`03001oogoo00=oo`8000Ioo`03001oogoo00Qoo`04001oogoo0009Ool20004Ool00`00Oomo
o`0=Ool001Aoo`03001oogoo00ioo`80015oo`03001oogoo00Yoo`8000Yoo`8000Aoo`03001oo`00
009oo`05001oogooOol00002Ool3000017oo000000007goo00<007ooOol07Goo1@0000=oo`000000
1Goo0P001Woo0P002Goo0P003Goo0P002goo00D007ooOomoo`0000Uoo`03001oogoo00Eoo`8000Ao
o`03001oogoo00Eoo`04001oogoo0002Ool00`00Oomoo`0>Ool001Eoo`80011oo`80011oo`8000ao
o`8000Yoo`05001oogooOol00002Ool30003Ool20002Ool00`00Ool00004000NOol2000NOol30000
0goo00000005Ool20006Ool20009Ool2000>Ool2000<Ool01000Ool000002Woo00<007ooOol017oo
00<007ooOol017oo00<007ooOol017oo00D007ooOomoo`00009oo`03001oogoo00ioo`005goo00<0
07ooOol03goo0P0047oo0P0037oo0P002Goo0`001Goo0P000goo0`0000=oo`00000010007Woo00<0
07ooOol077oo0`0000=oo`00Ool017oo0P001Woo0P002Goo0P003Woo0P000Woo00<007ooOol02Goo
0P003Goo00@007ooOomoo`8000Qoo`03001oogoo009oo`03001oogoo009oo`04001oogoo000@Ool0
01Qoo`80015oo`80011oo`03001oogoo00]oo`8000Uoo`8000Aoo`06001oo`00001oo`000Woo0P00
00=oo`0000000`007Goo00<007ooOol06goo1@0017oo0P001Woo0P002Goo0P003Woo0P0017oo00<0
07ooOol01goo0P0000=oo`00Ool03Goo0`002Woo00D007ooOomoo`0000Eoo`03001oo`00015oo`00
6Woo00<007ooOol047oo00<007ooOol03Woo0P003Goo0P001goo00@007oo0000009oo`04001oogoo
Ool20003Ool200000goo00000003000LOol00`00Oomoo`0IOol50003Ool30005Ool30008Ool3000>
Ool20007Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Ool00006
Ool00`00Ool0000AOol001]oo`80015oo`80011oo`8000eoo`8000Eoo`04001oogooOol30004Ool3
0002Ool400000goo00000002000JOol00`00Oomoo`0GOol50003Ool20006Ool20009Ool2000?Ool2
0009Ool00`00Oomoo`02Ool20006Ool00`00Oomoo`09Ool200000goo001oo`0;Ool20007Ool00`00
Ool0000AOol001eoo`03001oogoo011oo`80011oo`8000eoo`8000=oo`03001oogoo00=oo`<000=o
o`03001oo`000080009oo`P001Qoo`03001oogoo01Eoo`D0009oo`<000Ioo`8000Qoo`<000ioo`<0
00aoo`04001oo`000009Ool00`00Oomoo`07Ool01@00Oomoogoo000037oo0P001goo0P004Woo000N
Ool2000BOol2000@Ool3000<Ool40005Ool00`00Oomoo`0200000goo001oo`02Ool3000017oo001o
ogoo1P005Woo0P0057oo1P0000=oo`0000001goo0P0027oo0P003goo0P003goo0P002goo00<007oo
Ool01Goo0P0017oo00<007ooOol027oo0P0000=oo`00Ool01Woo0P004Woo000POol2000BOol2000A
Ool2000=Ool30003Ool00`00Oomoo`02Ool20004Ool00`00Ool000030002Ool6000DOol00`00Oomo
o`0@Ool:0005Ool40007Ool3000?Ool2000?Ool200000goo001oo`0;Ool00`00Oomoo`03Ool00`00
Oomoo`05Ool00`00Oomoo`06Ool01@00Oomoogoo00001goo00<007ooOol04Goo000ROol2000BOol2
000AOol3000:Ool00`00Oomoo`040005Ool500000goo001oo`02Ool500000goo00000005000@Ool0
0`00Oomoo`0=Ool;0003Ool40008Ool3000?Ool3000?Ool20003Ool00`00Oomoo`0:Ool01000Oomo
ogoo0P0027oo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol017oo0P004goo000TOol2000B
Ool3000AOol30007Ool00`00Oomoo`03Ool30004Ool01000Oomoogoo1@0000Aoo`00Oomoo`@00003
Ool0000000L000]oo`03001oogoo00Uoo``00003Ool0000000<000Uoo`<000ioo`@000moo`<000Io
o`03001oogoo00Yoo`<000Yoo`03001oogoo00=oo`8000Eoo`03001oogoo00=oo`03001oo`0001=o
o`009Woo0P004goo0`004Goo0`0017oo00<007ooOol017oo00<007oo000010001Goo00<007ooOol0
5`001Woo00<007ooOol01Goo2@000Woo1P002Woo10003Goo100047oo0`002Goo00<007ooOol02Goo
0P003Goo00D007ooOomoo`0000Moo`03001oogoo009oo`03001oo`0001Aoo`00:7oo0P0057oo0`00
4Goo0`0000=oo`00Ool01Goo00<007ooOol00goo10000goo00<007ooOol00Woo00<007ooOol01@00
00=oo`00000090002Goo1@0037oo1@004Woo0P0037oo00<007ooOol01goo0P0000=oo`00Ool037oo
00@007ooOol000Uoo`04001oogoo0002Ool00`00Oomoo`0BOol002Yoo`8001Eoo`@0011oo`<000Eo
o`03001oogoo00Aoo`03001oogoo00D000Aoo`03001oogoo009oo`03001oo`0001d000=oo`l000ao
o`D001Aoo`<000ioo`03001oogoo00Eoo`8000Aoo`03001oogoo00]oo`8000Yoo`04001oogoo0002
Ool00`00Oomoo`0BOol002aoo`8001Moo`<000ioo`03001oo`0000@00003Ool007oo00Eoo`03001o
ogoo00=oo`L000Aoo`8000=oo`8000AooaT001Eoo`@001Eoo`@0019oo`04001oogooOol30006Ool0
0`00Oomoo`0:Ool2000;Ool00`00Ool00002Ool00`00Oomoo`0COol002ioo`8001Qoo`<000]oo`03
001oogoo00Aoo`P00003Ool007oo00Aoo`03001oogoo009ooa<00003Ool0000000<00003Ool00000
00/000moo`P001Aoo`D001Ioo`@000Uoo`03001oogoo00Qoo`800003Ool007oo00Yoo`8000=oo`03
001oogoo01=oo`00<7oo0`0067oo100027oo00<007ooOol01Goo00<007ooOol00goo3`000Woo0P00
00Eoo`00001oo`00009ooa<00003Ool00000018001Qoo`@001Qoo`@000aoo`03001oogoo00Ioo`80
00=oo`03001oogoo00Qoo`8000=oo`03001oogoo01Aoo`00<goo100067oo100017oo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol00Woo4P0017oo200000=oo`00000097oo
1`006Goo0`000goo00<007ooOol02Woo00<007ooOol017oo0P001Goo00<007ooOol01Woo0P0000=o
o`00Ool00Woo00<007ooOol057oo000gOol4000HOol50008Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`03Ool200000goo001oo`03Ool20005Ool80004Ool9000FOol9000LOol40007Ool0
0`00Oomoo`0:Ool01000Oomoogoo0P001goo00<007ooOol01Goo00D007ooOomoo`00009oo`03001o
ogoo01Eoo`00>goo0`006Goo1`000Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol00Woo
00<007oo0000300017oo20002Goo5P008Goo10002goo00<007ooOol02Woo10002Woo00<007ooOol0
0Woo0P0017oo00@007ooOol001Moo`00?Woo10005Woo00<007ooOol00goo6@0000Aoo`00000000Io
o`<000Aoo`P003aoo`@000moo`03001oogoo00Qoo`<000eoo`05001oogooOol00005Ool01000Oomo
o`0067oo0012Ool4000BOol00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool200001Goo
001oogoo00000Woo00<007ooOol00goo00<007ooOol0100000=oo`00Ool01Goo1000<Woo1P004goo
00<007ooOol01Goo0`000Woo00<007ooOol02goo00@007ooOol000Ioo`03001oo`0001Uoo`00AWoo
10003Woo00<007ooOol01goo00<007ooOol01Goo00<007ooOol01goo00@007oo000000Aoo`80009o
o`D00003Ool00000008000Yoo`@002Qoo`H001Uoo`03001oogoo009oo`<000Ioo`03001oogoo00Yo
o`<000Moo`8001Yoo`00BWoo1P002Goo00<007ooOol01Woo00<007ooOol01Woo00<007ooOol01goo
00@007ooOomoo`L000Uoo`<000aoo`L001Yoo`L001moo`03001oo`00008000Uoo`03001oogoo00Yo
o`03001oogoo00Ioo`8001]oo`00D7oo2P002Goo00<007ooOol01Woo00<007ooOol00Woo20001goo
0P001goo0P0000=oo`0000000P003goo6P0097oo100037oo00<007ooOol027oo0`0027oo00<007oo
Ool06Woo001JOolG0007Ool00`00Oomoo`07Ool20005Ool00`00Oomoo`04Ool40015Ool40002Ool0
0`00Oomoo`0;Ool00`00Oomoo`06Ool20002Ool00`00Oomoo`05Ool00`00Oomoo`0KOol005Yoo`03
001oogoo00Qoo`03001oogoo00Ioo`8000Uoo`03001oogoo00Qoo`8000=oo`03001oogoo00Qoo`@0
03eoo`@000Ioo`03001oogoo00]oo`03001oogoo00=oo`<000=oo`03001oogoo00Eoo`8001eoo`00
Fgoo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo0P002Woo10003Woo1P00<goo1000
2Woo00<007ooOol02goo00@007ooOomoo`8000Ioo`03001oogoo00Aoo`8001ioo`00Fgoo00<007oo
Ool027oo00<007ooOol027oo00<007ooOol027oo0P002goo0`004Woo20008goo20003Woo00<007oo
Ool02Woo00<007ooOol00P0027oo00<007ooOol00Woo0P0000=oo`00Ool07Goo001LOol00`00Oomo
o`08Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`02000HOol;000<
Ool<000FOol00`00Oomoo`09Ool40009Ool00`00Oomoo`02Ool01000Oomoo`007goo001MOol00`00
Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`09Ool20008Ool20003Ool2000QOol<000ROol00`00
Oomoo`05Ool400000goo001oo`0:Ool00`00Oomoo`020002Ool00`00Oomoo`0NOol005eoo`03001o
ogoo00Uoo`03001oogoo00Qoo`8000]oo`8000Ioo`03001oogoo00Aoo`@004Yoo`03001oogoo00=o
o`<000Eoo`03001oogoo00Qoo`04001oo`000004Ool00`00Oomoo`0NOol005ioo`03001oogoo00Uo
o`03001oogoo00Uoo`8000]oo`8000Aoo`03001oogoo00Qoo`@004Ioo`03001oogoo00<000Qoo`03
001oogoo00Qoo`8000Eoo`03001oogoo01moo`00Ggoo00<007ooOol02Goo00<007ooOol02Woo00<0
07ooOol02Woo0P000Woo00<007ooOol037oo1@00@Goo0`002goo00<007ooOol01Woo0`001Goo00<0
07ooOol087oo001POol00`00Oomoo`09Ool00`00Oomoo`0:Ool2000<Ool3000COol6000gOol5000=
Ool00`00Oomoo`04Ool200000goo001oo`04Ool00`00Oomoo`0QOol0065oo`03001oogoo00Uoo`03
001oogoo00]oo`8000aoo`<001Moo`P0029oo`d000=oo`03001oogoo00]oo`03001oogoo00=oo`80
00=oo`03001oogoo009oo`03001oogoo029oo`00HGoo00<007ooOol02Woo0P003Goo00<007ooOol0
2Goo0P0000=oo`0000007Goo1`004Goo2P0047oo00<007ooOol02goo00@007ooOomoo`8000Eoo`05
001oogooOol0000UOol0069oo`03001oogoo00]oo`03001oogoo00]oo`8000Uoo`03001oogoo009o
o`<0025ooa4001Yoo`03001oogoo00Yoo`03001oogoo008000Ioo`03001oogoo008002Ioo`00Hgoo
00<007ooOol02goo00<007ooOol037oo0P001goo00<007ooOol01Goo1000B7oo00<007ooOol02Woo
0`001goo00@007ooOol002Qoo`00I7oo00<007ooOol02goo00<007ooOol03Goo0P001Goo00<007oo
Ool02Goo1000@goo00<007ooOol02Goo0`0027oo00@007oo000002Uoo`00IGoo00<007ooOol02goo
0P003goo0P000goo00<007ooOol03Goo1@00?Woo00<007ooOol01Goo100000=oo`00Ool027oo0P00
:goo001VOol00`00Oomoo`0<Ool00`00Oomoo`0>Ool200000goo0000000COol6000gOol00`00Oomo
o`02Ool40004Ool00`00Oomoo`06Ool2000]Ool006Moo`03001oogoo00aoo`80011oo`8001Yoo`D0
039oo`D000Qoo`03001oogoo00Eoo`8002ioo`00J7oo00<007ooOol03Goo0P003goo100077oo1P00
:7oo1@002goo00<007ooOol017oo0`00;goo001YOol00`00Oomoo`0>Ool00`00Oomoo`0<Ool01000
Oomoogoo0P0087oo200057oo30000Woo00<007ooOol02Woo00<007ooOol00goo0P0000=oo`00Ool0
;goo001ZOol00`00Oomoo`0>Ool20004Ool40004Ool00`00Oomoo`03Ool3000UOolD000>Ool00`00
Oomoo`0:Ool01000Oomoogoo0P000Woo00<007ooOol0;goo001[Ool00`00Oomoo`0?Ool20004Ool0
0`00Oomoo`03Ool00`00Oomoo`06Ool40012Ool00`00Oomoo`0:Ool00`00Ool000020003Ool00`00
Oomoo`0`Ool006aoo`80015oo`80009oo`03001oogoo00=oo`<000Yoo`@003eoo`03001oogoo00Yo
o`<000Aoo`8003=oo`00KWoo0P004Goo0`001Goo00<007ooOol03Woo0`00>Goo00<007ooOol01goo
10001Goo0P00=Goo001`Ool2000AOol20004Ool00`00Oomoo`0AOol3000eOol00`00Oomoo`04Ool4
00000goo001oo`04Ool2000gOol0079oo`03001oogoo00aoo`<00003Ool00000009oo`03001oogoo
01Aoo`@0031oo`04001oogooOol40004Ool00`00Oomoo`02Ool2000iOol007=oo`8000ioo`04001o
ogooOol3000JOol:000UOol50007Ool01000Oomoogoo0P00>goo001eOol00`00Oomoo`0AOol3000R
Ool7000EOol:000:Ool00`00Oomoo`02000mOol007Ioo`80015oo`800004Ool00000000VOolE0007
Ool00`00Oomoo`09Ool01000Ool00000?goo001hOol2000?Ool00`00Oomoo`03Ool3000oOol00`00
Oomoo`08Ool30011Ool007Yoo`8000eoo`03001oogoo00Ioo`@003Yoo`03001oogoo00Moo`<004=o
o`00O7oo0P002goo00<007ooOol02Woo1000=Goo00<007ooOol01Goo0`00AWoo001nOol30008Ool0
0`00Oomoo`0>Ool4000`Ool00`00Oomoo`02Ool50018Ool0085oo`8000Ioo`03001oogoo019oo`D0
02Uoo`80009oo`<00003Ool0000004Yoo`00Pgoo0P0017oo0P0067oo1@0087oo200000Aoo`000000
04aoo`00QGoo0`0000=oo`00Ool07Goo3P0027oo2P0000=oo`00000017oo0P00Cgoo0028Ool4000Z
Ool80009Ool20003Ool3001AOol008Uoo`03001oogoo00<003Ioo`80009oo`<005Aoo`00RGoo00<0
07ooOol00goo1000<7oo0P0000Aoo`00000005Moo`00Mgoo0P0047oo0P0027oo0`00:Woo1P00FWoo
001iOol3000=Ool00`00Oomoo`0:Ool4000SOol6001MOol007aoo`@000Uoo`03001oogoo00ioo`h0
00moo`L0069oo`00P7oo10001Goo00<007ooOol077oo3`0000Aoo`00000006Eoo`00Q7oo1P00:Woo
1000J7oo0029Ool6000QOol4001/Ool008Uoo`8000Aoo`D0019oo`X0071oo`00RGoo00<007ooOol0
27oo4P00NWoo0029Ool00`00Oomoo`2DOol008Uoo`03001oogoo09Aoo`00RGoo00<007ooOol0U7oo
0029Ool00`00Oomoo`2DOol00001\
\>"],
  ImageRangeCache->{{{0, 358.75}, {221.125, 0}} -> {-1.47226, -1.58564, \
0.0106917, 0.0174118}}]
}, Open  ]],

Cell[TextData[{
  "It can be observed that only the solution with projection onto both \
invariants gives the correct qualitative behavior -  for comparison, results \
using an efficient symplectic solver can be found in ",
  ButtonBox["SymplecticPartitionedRungeKutta",
    ButtonData:>{"SPRK.nb", None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lotka Volterra", "Subsection"],

Cell[TextData[{
  "An example of constraint projection for the Lotka-Volterra system is given \
within ",
  ButtonBox["Numerical methods for solving the Lotka-Volterra equations",
    ButtonData:>{"LotkaVolterra.nb", None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Euler's equations", "Subsection"],

Cell[TextData[{
  "An example of constraint projection for Euler's equations is given within \
",
  ButtonBox["Rigid body solvers",
    ButtonData:>{"RigidBody.nb", None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option summary", "Section",
  CellTags->"s:3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["Invariants",
              "MR"], 
            StyleBox["None",
              "MR"], Cell["Your text", "Text"]},
          {
            StyleBox["IterationSafetyFactor",
              "MR"], 
            StyleBox[
              FractionBox[
                StyleBox["1",
                  "MR"], "10"],
              
              "MR"], \(Specifies\ the\ safety\ factor\ to\ use\ in\ the\ \
iterative\ solution\ of\ the\ \(\(invariants\)\(.\)\)\)},
          {
            StyleBox["MaxIterations",
              "MR"], 
            StyleBox["Automatic",
              
              "MR"], \(Specifies\ the\ maximum\ number\ of\ iterations\ to\ \
use\ in\ the\ iterative\ solution\ of\ the\ \(\(invariants\)\(.\)\)\)},
          {
            StyleBox["Method",
              "MR"], 
            StyleBox["StiffnessSwitching",
              
              "MR"], \(Specifies\ the\ method\ to\ use\ for\ integrating\ the\
\ differential\ system\ \(\(numerically\)\(.\)\)\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options of the method ",
  StyleBox["Projection", "MR"],
  ". "
}], "Caption"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1280}, {0, 1002}},
AutoGeneratedPackage->None,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Projection",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[1776, 53, 48, 1, 88, "Chapter",
      CellTags->"c:1"]},
  "s:1"->{
    Cell[1849, 58, 50, 1, 61, "Section",
      CellTags->"s:1"]},
  "ODESystem"->{
    Cell[4026, 124, 132, 3, 30, "NumberedEquation",
      CellTags->"ODESystem"]},
  "Submanifold"->{
    Cell[5714, 201, 145, 3, 28, "NumberedEquation",
      CellTags->"Submanifold"]},
  "ConstrainedMinimum"->{
    Cell[7171, 257, 304, 7, 50, "NumberedEquation",
      CellTags->"ConstrainedMinimum"]},
  "StandardProjectionAlgorithm"->{
    Cell[7889, 279, 555, 11, 52, "NumberedEquation",
      CellTags->"StandardProjectionAlgorithm"]},
  "s:2"->{
    Cell[9355, 330, 46, 1, 51, "Section",
      CellTags->"s:2"]},
  "s:3"->{
    Cell[292020, 8976, 52, 1, 61, "Section",
      CellTags->"s:3"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 294267, 9046},
  {"s:1", 294344, 9049},
  {"ODESystem", 294427, 9052},
  {"Submanifold", 294529, 9055},
  {"ConstrainedMinimum", 294640, 9058},
  {"StandardProjectionAlgorithm", 294767, 9061},
  {"s:2", 294880, 9064},
  {"s:3", 294958, 9067}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 48, 1, 88, "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{
Cell[1849, 58, 50, 1, 61, "Section",
  CellTags->"s:1"],
Cell[1902, 61, 447, 7, 72, "Text"],
Cell[2352, 70, 289, 8, 40, "Text"],
Cell[2644, 80, 580, 14, 56, "Text"],
Cell[3227, 96, 258, 6, 40, "Text"],
Cell[3488, 104, 427, 12, 40, "Text"],

Cell[CellGroupData[{
Cell[3940, 120, 32, 0, 36, "Subsection"],
Cell[3975, 122, 48, 0, 24, "Text"],
Cell[4026, 124, 132, 3, 30, "NumberedEquation",
  CellTags->"ODESystem"],
Cell[4161, 129, 52, 0, 24, "Text"],
Cell[4216, 131, 363, 15, 24, "Text"],
Cell[4582, 148, 411, 20, 24, "Text"],
Cell[4996, 170, 288, 11, 24, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5321, 186, 31, 0, 35, "Subsection"],
Cell[5355, 188, 356, 11, 21, "Text"],
Cell[5714, 201, 145, 3, 28, "NumberedEquation",
  CellTags->"Submanifold"],
Cell[5862, 206, 573, 21, 35, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6472, 232, 42, 0, 35, "Subsection"],
Cell[6517, 234, 651, 21, 52, "Text"],
Cell[7171, 257, 304, 7, 50, "NumberedEquation",
  CellTags->"ConstrainedMinimum"],
Cell[7478, 266, 408, 11, 39, "Text"],
Cell[7889, 279, 555, 11, 52, "NumberedEquation",
  CellTags->"StandardProjectionAlgorithm"],
Cell[8447, 292, 109, 5, 21, "Text"],
Cell[8559, 299, 326, 11, 23, "Text"],
Cell[8888, 312, 151, 3, 35, "Text"],
Cell[9042, 317, 264, 7, 35, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9355, 330, 46, 1, 51, "Section",
  CellTags->"s:2"],
Cell[9404, 333, 43, 0, 21, "Text"],
Cell[9450, 335, 236, 5, 40, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[9711, 344, 39, 0, 35, "Subsection"],
Cell[9753, 346, 71, 0, 21, "Text"],
Cell[9827, 348, 205, 4, 40, "Input"],
Cell[10035, 354, 51, 0, 21, "Text"],

Cell[CellGroupData[{
Cell[10111, 358, 100, 2, 24, "Input"],
Cell[10214, 362, 88, 2, 24, "Output"]
}, Open  ]],
Cell[10317, 367, 344, 10, 35, "Text"],

Cell[CellGroupData[{
Cell[10686, 381, 205, 4, 55, "Input"],
Cell[10894, 387, 31241, 1016, 293, 15647, 819, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[42150, 1406, 132, 4, 21, "Text"],
Cell[42285, 1412, 315, 8, 48, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42637, 1425, 41, 0, 35, "Subsection"],
Cell[42681, 1427, 47, 0, 21, "Text"],
Cell[42731, 1429, 217, 5, 40, "Input"],
Cell[42951, 1436, 68, 0, 21, "Text"],

Cell[CellGroupData[{
Cell[43044, 1440, 101, 2, 24, "Input"],
Cell[43148, 1444, 97, 2, 37, "Output"]
}, Open  ]],
Cell[43260, 1449, 249, 5, 48, "Text"],

Cell[CellGroupData[{
Cell[43534, 1458, 268, 6, 55, "Input"],
Cell[43805, 1466, 29481, 894, 293, 15356, 715, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[73301, 2363, 259, 5, 48, "Text"],

Cell[CellGroupData[{
Cell[73585, 2372, 368, 8, 85, "Input"],
Cell[73956, 2382, 28067, 866, 293, 14501, 694, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[102038, 3251, 179, 4, 35, "Text"],

Cell[CellGroupData[{
Cell[102242, 3259, 414, 8, 100, "Input"],
Cell[102659, 3269, 30901, 986, 293, 15699, 793, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[133609, 4261, 46, 0, 35, "Subsection"],
Cell[133658, 4263, 227, 4, 48, "Text"],

Cell[CellGroupData[{
Cell[133910, 4271, 349, 7, 70, "Input"],
Cell[134262, 4280, 77, 2, 24, "Output"]
}, Open  ]],
Cell[134354, 4285, 146, 6, 21, "Text"],

Cell[CellGroupData[{
Cell[134525, 4295, 97, 2, 24, "Input"],
Cell[134625, 4299, 262, 5, 75, "Output"]
}, Open  ]],
Cell[134902, 4307, 290, 7, 35, "Text"],
Cell[135195, 4316, 93, 4, 23, "BulletedList"],
Cell[135291, 4322, 170, 6, 23, "BulletedList"],
Cell[135464, 4330, 170, 6, 23, "BulletedList"],
Cell[135637, 4338, 182, 6, 38, "BulletedList"],

Cell[CellGroupData[{
Cell[135844, 4348, 328, 7, 85, "Input"],
Cell[136175, 4357, 14471, 468, 184, 4947, 345, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[150683, 4830, 426, 9, 100, "Input"],
Cell[151112, 4841, 19617, 723, 184, 8684, 583, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[170766, 5569, 426, 9, 100, "Input"],
Cell[171195, 5580, 64985, 1722, 184, 17134, 1126, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[236217, 7307, 440, 10, 100, "Input"],
Cell[236660, 7319, 54295, 1612, 184, 17543, 1153, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[290970, 8934, 354, 8, 40, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[291361, 8947, 36, 0, 36, "Subsection"],
Cell[291400, 8949, 272, 7, 40, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[291709, 8961, 39, 0, 36, "Subsection"],
Cell[291751, 8963, 220, 7, 24, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[292020, 8976, 52, 1, 61, "Section",
  CellTags->"s:3"],
Cell[292075, 8979, 1267, 34, 182, "DefinitionBox3Col"],
Cell[293345, 9015, 97, 4, 15, "Caption"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

